
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  128 ( 1004),  selected  128 , name 1gyw_B
# Molecule2: number of CA atoms  145 ( 1093),  selected  145 , name T0514.pdb
# PARAMETERS: 1gyw_B.T0514.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P   695_B      -       -           -
LGA    L   696_B      -       -           -
LGA    F   697_B      -       -           -
LGA    N   698_B      S       1           #
LGA    -       -      S       2           -
LGA    D   699_B      L       3          4.345
LGA    I   700_B      T       4          4.097
LGA    A   701_B      E       5          3.401
LGA    -       -      T       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      L       9           -
LGA    -       -      W      10           -
LGA    -       -      S      11           -
LGA    -       -      I      12           -
LGA    P   702_B      N      13          3.499
LGA    -       -      C      14           -
LGA    -       -      G      15           -
LGA    -       -      I      16           -
LGA    -       -      Q      17           -
LGA    -       -      E      18           -
LGA    -       -      G      19           -
LGA    -       -      K      20           -
LGA    -       -      K      21           -
LGA    -       -      V      22           -
LGA    G   703_B      C      23          3.870
LGA    I   704_B      F      24          4.413
LGA    P   705_B      M      25          3.648
LGA    S   706_B      H      26          1.721
LGA    I   707_B      R      27          1.473
LGA    T   708_B      Q      28          1.975
LGA    A   709_B      E      29          3.977
LGA    Y   710_B      -       -           -
LGA    S   711_B      V      30          4.681
LGA    K   712_B      N      31          5.594
LGA    N   713_B      D      32           -
LGA    G   714_B      Q      33           -
LGA    -       -      N      34           -
LGA    L   715_B      R      35           #
LGA    K   716_B      V      36          4.859
LGA    -       -      V      37           -
LGA    I   717_B      V      38          1.985
LGA    E   718_B      A      39          1.168
LGA    F   719_B      M      40          0.679
LGA    T   720_B      S      41          0.518
LGA    F   721_B      V      42          0.892
LGA    E   722_B      V      43          0.941
LGA    R   723_B      L      44          1.619
LGA    S   724_B      N      45          2.457
LGA    N   725_B      A      46          1.889
LGA    T   726_B      D      47          1.632
LGA    N   727_B      G      48          2.760
LGA    P   728_B      -       -           -
LGA    S   729_B      -       -           -
LGA    V   730_B      V      49          3.197
LGA    T   731_B      V      50          1.982
LGA    V   732_B      S      51          1.388
LGA    I   733_B      G      52          3.667
LGA    T   734_B      N      53          0.663
LGA    I   735_B      L      54          0.811
LGA    Q   736_B      T      55          1.638
LGA    A   737_B      V      56          2.439
LGA    S   738_B      P      57          4.104
LGA    N   739_B      F      58          3.854
LGA    S   740_B      -       -           -
LGA    T   741_B      -       -           -
LGA    E   742_B      -       -           -
LGA    L   743_B      -       -           -
LGA    D   744_B      -       -           -
LGA    M   745_B      G      59          1.536
LGA    T   746_B      I      60          4.960
LGA    D   747_B      L      61          1.975
LGA    F   748_B      V      62          4.178
LGA    V   749_B      S      63           #
LGA    -       -      K      64           -
LGA    -       -      P      65           -
LGA    F   750_B      V      66          2.320
LGA    Q   751_B      R      67          1.625
LGA    A   752_B      L      68          1.139
LGA    D   753_B      Q      69          1.909
LGA    V   754_B      V      70          2.990
LGA    -       -      D      71           -
LGA    P   755_B      E      72          5.722
LGA    K   756_B      G      73          5.308
LGA    T   757_B      K      74           #
LGA    F   758_B      A      75          4.721
LGA    Q   759_B      V      76           #
LGA    L   760_B      -       -           -
LGA    Q   761_B      I      77          4.392
LGA    L   762_B      E      78          4.078
LGA    L   763_B      T      79          3.969
LGA    S   764_B      G      80          3.518
LGA    P   765_B      I      81          1.761
LGA    S   766_B      R      82          1.417
LGA    S   767_B      T      83          4.209
LGA    S   768_B      -       -           -
LGA    V   769_B      C      84           #
LGA    V   770_B      -       -           -
LGA    P   771_B      -       -           -
LGA    A   772_B      -       -           -
LGA    F   773_B      -       -           -
LGA    N   774_B      V      85           #
LGA    T   775_B      P      86          3.494
LGA    G   776_B      A      87           #
LGA    T   777_B      G      88          2.988
LGA    I   778_B      C      89          1.773
LGA    T   779_B      I      90          1.132
LGA    Q   780_B      V      91          1.189
LGA    V   781_B      P      92          1.365
LGA    I   782_B      I      93          1.812
LGA    K   783_B      V      94          1.887
LGA    V   784_B      F      95          2.045
LGA    L   785_B      D      96          2.672
LGA    N   786_B      K      97          3.983
LGA    P   787_B      N      98          4.816
LGA    Q   788_B      Y      99           -
LGA    K   789_B      V     100           #
LGA    Q   790_B      A     101          4.548
LGA    -       -      A     102           -
LGA    -       -      L     103           -
LGA    -       -      R     104           -
LGA    Q   791_B      A     105          2.450
LGA    L   792_B      G     106          3.697
LGA    -       -      K     107           -
LGA    R   793_B      H     108          4.329
LGA    M   794_B      L     109          2.301
LGA    R   795_B      K     110          1.590
LGA    I   796_B      L     111          1.070
LGA    K   797_B      A     112          1.082
LGA    L   798_B      M     113          2.731
LGA    T   799_B      T     114          1.781
LGA    Y   800_B      I     115          0.744
LGA    N   801_B      A     116          2.709
LGA    H   802_B      A     117           #
LGA    K   803_B      -       -           -
LGA    G   804_B      P     118           #
LGA    S   805_B      G     119           #
LGA    A   806_B      E     120          4.021
LGA    M   807_B      P     121          3.824
LGA    Q   808_B      P     122          2.750
LGA    D   809_B      L     123          2.673
LGA    L   810_B      N     124          1.778
LGA    A   811_B      D     125          3.252
LGA    E   812_B      L     126           #
LGA    V   813_B      F     127          3.556
LGA    N   814_B      V     128           #
LGA    N   815_B      Q     129          2.019
LGA    F   816_B      L     130          2.417
LGA    P   817_B      N     131          5.023
LGA    P   818_B      G     132          2.589
LGA    -       -      F     133           -
LGA    -       -      S     134           -
LGA    -       -      N     135           -
LGA    Q   819_B      A     136          1.555
LGA    S   820_B      L     137          4.253
LGA    W   821_B      N     138           #
LGA    Q   822_B      R     139           #
LGA    -       -      L     140           -
LGA    -       -      I     141           -
LGA    -       -      A     142           -
LGA    -       -      L     143           -
LGA    -       -      Q     144           -
LGA    -       -      K     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  128  145    5.0     91    3.07     4.40     37.488     2.869

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.213241 * X  +  -0.366022 * Y  +  -0.905846 * Z  + -73.273232
  Y_new =  -0.112368 * X  +  -0.930206 * Y  +   0.349413 * Z  +  45.273937
  Z_new =  -0.970516 * X  +   0.027279 * Y  +  -0.239487 * Z  +  26.868362 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.028175   -0.113418  [ DEG:   173.5016     -6.4984 ]
  Theta =   1.327363    1.814229  [ DEG:    76.0523    103.9477 ]
  Phi   =  -0.484978    2.656614  [ DEG:   -27.7872    152.2128 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gyw_B                                        
REMARK     2: T0514.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gyw_B.T0514.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  128  145   5.0   91   3.07    4.40  37.488
REMARK  ---------------------------------------------------------- 
MOLECULE 1gyw_B
HEADER    ENDOCYTOSIS                             30-APR-02   1GYW              
TITLE     GAMMA-ADAPTIN APPENDAGE DOMAIN FROM CLATHRIN ADAPTOR AP1              
TITLE    2 A753D MUTANT                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ADAPTER-RELATED PROTEIN COMPLEX 1 GAMMA 1                  
COMPND   3 SUBUNIT;                                                             
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 FRAGMENT: APPENDAGE DOMAIN, RESIDUES 694-821;                        
COMPND   6 SYNONYM: GAMMA-ADAPTIN, GOLGI ADAPTOR HA1/AP1 ADAPTIN                
COMPND   7 GAMMA SUBUNIT, CLATHRIN ASSEMBLY PROTEIN COMPLEX 1 GAMMA             
COMPND   8 LARGE CHAIN;                                                         
COMPND   9 ENGINEERED: YES;                                                     
COMPND  10 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: DH5ALPHA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: PLASMID;                                   
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PGEX 4T2                                  
KEYWDS    ENDOCYTOSIS, ADAPTOR, COATED PITS                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.R.EVANS,A.E.MIELE,D.J.OWEN,H.M.MCMAHON,H.M.KENT                     
REVDAT   2   01-APR-03 1GYW    1       JRNL                                     
REVDAT   1   22-AUG-02 1GYW    0                                                
JRNL        AUTH   H.M.KENT,H.T.MCMAHON,P.R.EVANS,A.BENMERAH,D.J.OWEN           
JRNL        TITL   GAMMA-ADAPTIN APPENDAGE DOMAIN: STRUCTURE AND                
JRNL        TITL 2 BINDING SITE FOR EPS15 AND GAMMA-SYNERGIN.                   
JRNL        REF    STRUCTURE                     V.  10  1139 2002              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  1GYW A  695   822  UNP    P22892   AP1G1_MOUSE    694    821             
DBREF  1GYW B  695   822  UNP    P22892   AP1G1_MOUSE    694    821             
SEQRES   1 A  128  PRO LEU PHE ASN ASP ILE ALA PRO GLY ILE PRO SER ILE          
SEQRES   2 A  128  THR ALA TYR SER LYS ASN GLY LEU LYS ILE GLU PHE THR          
SEQRES   3 A  128  PHE GLU ARG SER ASN THR ASN PRO SER VAL THR VAL ILE          
SEQRES   4 A  128  THR ILE GLN ALA SER ASN SER THR GLU LEU ASP MET THR          
SEQRES   5 A  128  ASP PHE VAL PHE GLN ALA ASP VAL PRO LYS THR PHE GLN          
SEQRES   6 A  128  LEU GLN LEU LEU SER PRO SER SER SER VAL VAL PRO ALA          
SEQRES   7 A  128  PHE ASN THR GLY THR ILE THR GLN VAL ILE LYS VAL LEU          
SEQRES   8 A  128  ASN PRO GLN LYS GLN GLN LEU ARG MET ARG ILE LYS LEU          
SEQRES   9 A  128  THR TYR ASN HIS LYS GLY SER ALA MET GLN ASP LEU ALA          
SEQRES  10 A  128  GLU VAL ASN ASN PHE PRO PRO GLN SER TRP GLN                  
SEQRES   1 B  128  PRO LEU PHE ASN ASP ILE ALA PRO GLY ILE PRO SER ILE          
SEQRES   2 B  128  THR ALA TYR SER LYS ASN GLY LEU LYS ILE GLU PHE THR          
SEQRES   3 B  128  PHE GLU ARG SER ASN THR ASN PRO SER VAL THR VAL ILE          
SEQRES   4 B  128  THR ILE GLN ALA SER ASN SER THR GLU LEU ASP MET THR          
SEQRES   5 B  128  ASP PHE VAL PHE GLN ALA ASP VAL PRO LYS THR PHE GLN          
SEQRES   6 B  128  LEU GLN LEU LEU SER PRO SER SER SER VAL VAL PRO ALA          
SEQRES   7 B  128  PHE ASN THR GLY THR ILE THR GLN VAL ILE LYS VAL LEU          
SEQRES   8 B  128  ASN PRO GLN LYS GLN GLN LEU ARG MET ARG ILE LYS LEU          
SEQRES   9 B  128  THR TYR ASN HIS LYS GLY SER ALA MET GLN ASP LEU ALA          
SEQRES  10 B  128  GLU VAL ASN ASN PHE PRO PRO GLN SER TRP GLN                  
HET     CL  A1823       1                                                       
HETNAM      CL CHLORIDE ION                                                     
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  HOH   *178(H2 O)                                                    
CRYST1   62.155   62.155  148.903  90.00  90.00  90.00 P 43 21 2    16          
ATOM    991  N   PRO B 695     -74.659  22.295 -24.596  1.00 45.08           N  
ATOM    992  CA  PRO B 695     -74.275  22.030 -26.045  1.00 43.95           C  
ATOM    993  C   PRO B 695     -73.139  22.972 -26.544  1.00 43.56           C  
ATOM    994  O   PRO B 695     -73.302  24.172 -26.351  1.00 43.54           O  
ATOM    995  CB  PRO B 695     -75.590  22.320 -26.811  1.00 44.84           C  
ATOM    996  CG  PRO B 695     -76.502  23.183 -25.774  1.00 43.97           C  
ATOM    997  CD  PRO B 695     -76.108  22.595 -24.447  1.00 45.47           C  
ATOM    998  N   LEU B 696     -72.064  22.450 -27.179  1.00 41.82           N  
ATOM    999  CA  LEU B 696     -70.846  23.192 -27.532  1.00 40.02           C  
ATOM   1000  C   LEU B 696     -70.779  23.708 -28.991  1.00 40.13           C  
ATOM   1001  O   LEU B 696     -69.975  24.593 -29.356  1.00 36.72           O  
ATOM   1002  CB  LEU B 696     -69.621  22.323 -27.199  1.00 39.90           C  
ATOM   1003  CG  LEU B 696     -69.555  21.857 -25.729  1.00 39.34           C  
ATOM   1004  CD1 LEU B 696     -68.261  21.123 -25.402  1.00 36.33           C  
ATOM   1005  CD2 LEU B 696     -69.729  23.055 -24.691  1.00 39.70           C  
ATOM   1006  N   PHE B 697     -71.617  23.119 -29.826  1.00 40.67           N  
ATOM   1007  CA  PHE B 697     -71.776  23.609 -31.190  1.00 41.39           C  
ATOM   1008  C   PHE B 697     -72.980  24.506 -31.140  1.00 43.34           C  
ATOM   1009  O   PHE B 697     -74.024  24.126 -30.588  1.00 42.40           O  
ATOM   1010  CB  PHE B 697     -71.937  22.468 -32.179  1.00 39.88           C  
ATOM   1011  CG  PHE B 697     -70.640  21.792 -32.487  1.00 38.77           C  
ATOM   1012  CD1 PHE B 697     -70.227  20.650 -31.774  1.00 36.12           C  
ATOM   1013  CD2 PHE B 697     -69.780  22.326 -33.459  1.00 33.96           C  
ATOM   1014  CE1 PHE B 697     -69.020  20.015 -32.110  1.00 34.23           C  
ATOM   1015  CE2 PHE B 697     -68.575  21.717 -33.749  1.00 33.41           C  
ATOM   1016  CZ  PHE B 697     -68.181  20.593 -33.052  1.00 32.08           C  
ATOM   1017  N   ASN B 698     -72.803  25.704 -31.702  1.00 46.01           N  
ATOM   1018  CA  ASN B 698     -73.827  26.762 -31.653  1.00 48.58           C  
ATOM   1019  C   ASN B 698     -75.015  26.691 -32.650  1.00 47.94           C  
ATOM   1020  O   ASN B 698     -76.136  27.156 -32.314  1.00 48.62           O  
ATOM   1021  CB  ASN B 698     -73.140  28.149 -31.757  1.00 50.00           C  
ATOM   1022  CG  ASN B 698     -72.861  28.765 -30.378  1.00 52.89           C  
ATOM   1023  OD1 ASN B 698     -72.769  28.047 -29.351  1.00 56.26           O  
ATOM   1024  ND2 ASN B 698     -72.727  30.102 -30.345  1.00 57.27           N  
ATOM   1025  N   ASP B 699     -74.769  26.078 -33.809  1.00 46.59           N  
ATOM   1026  CA  ASP B 699     -75.748  25.948 -34.902  1.00 46.10           C  
ATOM   1027  C   ASP B 699     -77.244  25.589 -34.549  1.00 44.66           C  
ATOM   1028  O   ASP B 699     -77.593  24.772 -33.692  1.00 43.54           O  
ATOM   1029  CB  ASP B 699     -75.199  24.983 -35.954  1.00 46.14           C  
ATOM   1030  CG  ASP B 699     -75.190  23.551 -35.492  1.00 49.66           C  
ATOM   1031  OD1 ASP B 699     -74.585  23.296 -34.440  1.00 53.91           O  
ATOM   1032  OD2 ASP B 699     -75.764  22.597 -36.111  1.00 55.45           O  
ATOM   1033  N   ILE B 700     -78.129  26.217 -35.285  1.00 43.43           N  
ATOM   1034  CA  ILE B 700     -79.532  26.039 -35.074  1.00 41.55           C  
ATOM   1035  C   ILE B 700     -79.879  24.868 -35.963  1.00 39.15           C  
ATOM   1036  O   ILE B 700     -79.334  24.707 -37.087  1.00 38.84           O  
ATOM   1037  CB  ILE B 700     -80.273  27.284 -35.495  1.00 42.11           C  
ATOM   1038  CG1 ILE B 700     -79.563  28.506 -34.915  1.00 44.09           C  
ATOM   1039  CG2 ILE B 700     -81.712  27.238 -34.993  1.00 43.11           C  
ATOM   1040  CD1 ILE B 700     -79.803  29.790 -35.648  1.00 44.64           C  
ATOM   1041  N   ALA B 701     -80.748  24.036 -35.413  1.00 35.62           N  
ATOM   1042  CA  ALA B 701     -81.245  22.840 -36.071  1.00 33.86           C  
ATOM   1043  C   ALA B 701     -82.072  23.156 -37.323  1.00 31.59           C  
ATOM   1044  O   ALA B 701     -82.852  24.106 -37.313  1.00 30.87           O  
ATOM   1045  CB  ALA B 701     -82.135  22.056 -35.079  1.00 33.35           C  
ATOM   1046  N   PRO B 702     -81.930  22.334 -38.341  1.00 28.60           N  
ATOM   1047  CA  PRO B 702     -82.724  22.422 -39.571  1.00 28.51           C  
ATOM   1048  C   PRO B 702     -84.195  21.940 -39.440  1.00 28.62           C  
ATOM   1049  O   PRO B 702     -84.529  21.079 -38.643  1.00 30.42           O  
ATOM   1050  CB  PRO B 702     -81.942  21.506 -40.548  1.00 28.46           C  
ATOM   1051  CG  PRO B 702     -81.237  20.490 -39.619  1.00 27.89           C  
ATOM   1052  CD  PRO B 702     -80.939  21.238 -38.393  1.00 29.17           C  
ATOM   1053  N   GLY B 703     -85.050  22.509 -40.278  1.00 28.45           N  
ATOM   1054  CA  GLY B 703     -86.439  22.133 -40.397  1.00 27.57           C  
ATOM   1055  C   GLY B 703     -87.271  22.599 -39.181  1.00 27.39           C  
ATOM   1056  O   GLY B 703     -87.138  23.682 -38.684  1.00 25.86           O  
ATOM   1057  N   ILE B 704     -88.094  21.708 -38.698  1.00 26.47           N  
ATOM   1058  CA  ILE B 704     -88.995  21.998 -37.664  1.00 27.11           C  
ATOM   1059  C   ILE B 704     -88.639  21.107 -36.496  1.00 26.58           C  
ATOM   1060  O   ILE B 704     -88.559  19.900 -36.679  1.00 27.39           O  
ATOM   1061  CB  ILE B 704     -90.380  21.640 -38.182  1.00 27.77           C  
ATOM   1062  CG1 ILE B 704     -90.661  22.421 -39.498  1.00 26.55           C  
ATOM   1063  CG2 ILE B 704     -91.373  21.970 -37.152  1.00 27.51           C  
ATOM   1064  CD1 ILE B 704     -91.811  21.868 -40.271  1.00 25.78           C  
ATOM   1065  N   PRO B 705     -88.437  21.675 -35.305  1.00 25.09           N  
ATOM   1066  CA  PRO B 705     -88.087  20.866 -34.135  1.00 24.49           C  
ATOM   1067  C   PRO B 705     -89.224  20.017 -33.707  1.00 24.38           C  
ATOM   1068  O   PRO B 705     -90.405  20.312 -33.928  1.00 22.50           O  
ATOM   1069  CB  PRO B 705     -87.803  21.889 -33.049  1.00 25.11           C  
ATOM   1070  CG  PRO B 705     -87.660  23.194 -33.804  1.00 25.91           C  
ATOM   1071  CD  PRO B 705     -88.497  23.107 -35.002  1.00 23.81           C  
ATOM   1072  N   SER B 706     -88.833  18.912 -33.086  1.00 24.23           N  
ATOM   1073  CA  SER B 706     -89.762  17.949 -32.581  1.00 23.15           C  
ATOM   1074  C   SER B 706     -90.120  18.388 -31.218  1.00 21.39           C  
ATOM   1075  O   SER B 706     -89.352  19.037 -30.584  1.00 20.15           O  
ATOM   1076  CB  SER B 706     -89.076  16.593 -32.452  1.00 22.63           C  
ATOM   1077  OG  SER B 706     -89.205  15.846 -33.633  1.00 29.06           O  
ATOM   1078  N   ILE B 707     -91.278  17.935 -30.748  1.00 22.32           N  
ATOM   1079  CA  ILE B 707     -91.745  18.154 -29.370  1.00 21.49           C  
ATOM   1080  C   ILE B 707     -92.368  16.919 -28.724  1.00 21.58           C  
ATOM   1081  O   ILE B 707     -92.768  15.974 -29.400  1.00 20.60           O  
ATOM   1082  CB  ILE B 707     -92.859  19.239 -29.349  1.00 21.76           C  
ATOM   1083  CG1 ILE B 707     -94.098  18.775 -30.163  1.00 19.56           C  
ATOM   1084  CG2 ILE B 707     -92.284  20.635 -29.778  1.00 22.28           C  
ATOM   1085  CD1 ILE B 707     -95.193  19.843 -30.254  1.00 16.92           C  
ATOM   1086  N   THR B 708     -92.487  16.965 -27.413  1.00 21.69           N  
ATOM   1087  CA  THR B 708     -93.297  16.007 -26.732  1.00 23.28           C  
ATOM   1088  C   THR B 708     -94.611  16.777 -26.513  1.00 22.47           C  
ATOM   1089  O   THR B 708     -94.684  17.797 -25.793  1.00 21.61           O  
ATOM   1090  CB  THR B 708     -92.633  15.565 -25.408  1.00 24.83           C  
ATOM   1091  OG1 THR B 708     -91.508  14.699 -25.666  1.00 28.25           O  
ATOM   1092  CG2 THR B 708     -93.609  14.721 -24.549  1.00 26.19           C  
ATOM   1093  N   ALA B 709     -95.645  16.353 -27.219  1.00 22.15           N  
ATOM   1094  CA  ALA B 709     -96.895  17.025 -27.093  1.00 21.82           C  
ATOM   1095  C   ALA B 709     -97.601  16.546 -25.802  1.00 22.78           C  
ATOM   1096  O   ALA B 709     -98.438  17.291 -25.244  1.00 21.81           O  
ATOM   1097  CB  ALA B 709     -97.731  16.794 -28.322  1.00 21.50           C  
ATOM   1098  N   TYR B 710     -97.263  15.332 -25.310  1.00 22.82           N  
ATOM   1099  CA  TYR B 710     -97.998  14.726 -24.186  1.00 23.60           C  
ATOM   1100  C   TYR B 710     -97.194  13.685 -23.469  1.00 23.33           C  
ATOM   1101  O   TYR B 710     -96.586  12.859 -24.094  1.00 24.74           O  
ATOM   1102  CB  TYR B 710     -99.342  14.130 -24.685  1.00 23.78           C  
ATOM   1103  CG  TYR B 710    -100.319  13.550 -23.622  1.00 24.12           C  
ATOM   1104  CD1 TYR B 710    -101.447  14.236 -23.217  1.00 26.64           C  
ATOM   1105  CD2 TYR B 710    -100.115  12.291 -23.086  1.00 26.49           C  
ATOM   1106  CE1 TYR B 710    -102.333  13.692 -22.266  1.00 26.45           C  
ATOM   1107  CE2 TYR B 710    -100.990  11.713 -22.187  1.00 25.67           C  
ATOM   1108  CZ  TYR B 710    -102.106  12.399 -21.781  1.00 27.03           C  
ATOM   1109  OH  TYR B 710    -102.914  11.819 -20.827  1.00 22.38           O  
ATOM   1110  N   SER B 711     -97.158  13.773 -22.160  1.00 24.01           N  
ATOM   1111  CA  SER B 711     -96.493  12.784 -21.285  1.00 25.85           C  
ATOM   1112  C   SER B 711     -97.225  12.727 -19.945  1.00 25.61           C  
ATOM   1113  O   SER B 711     -96.985  13.531 -19.109  1.00 24.37           O  
ATOM   1114  CB  SER B 711     -95.044  13.185 -21.005  1.00 26.70           C  
ATOM   1115  OG  SER B 711     -94.303  12.090 -20.500  1.00 29.30           O  
ATOM   1116  N   LYS B 712     -98.122  11.781 -19.779  1.00 26.54           N  
ATOM   1117  CA  LYS B 712     -98.853  11.569 -18.545  1.00 27.96           C  
ATOM   1118  C   LYS B 712     -99.235  10.078 -18.451  1.00 27.25           C  
ATOM   1119  O   LYS B 712     -99.490   9.435 -19.483  1.00 26.49           O  
ATOM   1120  CB  LYS B 712    -100.191  12.322 -18.503  1.00 28.73           C  
ATOM   1121  CG  LYS B 712    -100.149  13.824 -18.803  1.00 34.93           C  
ATOM   1122  CD  LYS B 712    -101.440  14.513 -18.270  1.00 39.78           C  
ATOM   1123  CE  LYS B 712    -101.861  15.754 -19.144  1.00 41.53           C  
ATOM   1124  NZ  LYS B 712    -103.275  16.260 -18.930  1.00 41.22           N  
ATOM   1125  N   ASN B 713     -99.248   9.553 -17.215  1.00 25.60           N  
ATOM   1126  CA  ASN B 713     -99.639   8.185 -16.918  1.00 24.72           C  
ATOM   1127  C   ASN B 713     -98.856   7.105 -17.669  1.00 23.87           C  
ATOM   1128  O   ASN B 713     -99.358   6.044 -17.893  1.00 24.05           O  
ATOM   1129  CB  ASN B 713    -101.171   8.043 -17.077  1.00 23.79           C  
ATOM   1130  CG  ASN B 713    -101.979   9.312 -16.481  1.00 26.62           C  
ATOM   1131  OD1 ASN B 713    -101.769   9.711 -15.340  1.00 28.84           O  
ATOM   1132  ND2 ASN B 713    -102.905   9.891 -17.266  1.00 24.06           N  
ATOM   1133  N   GLY B 714     -97.617   7.362 -18.039  1.00 23.76           N  
ATOM   1134  CA  GLY B 714     -96.821   6.376 -18.731  1.00 24.78           C  
ATOM   1135  C   GLY B 714     -97.006   6.462 -20.242  1.00 25.70           C  
ATOM   1136  O   GLY B 714     -96.284   5.812 -21.069  1.00 24.94           O  
ATOM   1137  N   LEU B 715     -97.961   7.300 -20.642  1.00 25.20           N  
ATOM   1138  CA  LEU B 715     -98.151   7.511 -22.083  1.00 25.23           C  
ATOM   1139  C   LEU B 715     -97.420   8.763 -22.604  1.00 25.66           C  
ATOM   1140  O   LEU B 715     -97.694   9.902 -22.213  1.00 24.45           O  
ATOM   1141  CB  LEU B 715     -99.636   7.613 -22.425  1.00 24.32           C  
ATOM   1142  CG  LEU B 715    -100.014   7.894 -23.865  1.00 23.44           C  
ATOM   1143  CD1 LEU B 715     -99.762   6.703 -24.719  1.00 25.61           C  
ATOM   1144  CD2 LEU B 715    -101.459   8.208 -23.895  1.00 23.87           C  
ATOM   1145  N   LYS B 716     -96.589   8.545 -23.601  1.00 27.07           N  
ATOM   1146  CA  LYS B 716     -95.842   9.627 -24.215  1.00 27.28           C  
ATOM   1147  C   LYS B 716     -96.218   9.758 -25.688  1.00 27.65           C  
ATOM   1148  O   LYS B 716     -96.175   8.788 -26.432  1.00 27.45           O  
ATOM   1149  CB  LYS B 716     -94.345   9.420 -24.017  1.00 25.44           C  
ATOM   1150  CG  LYS B 716     -93.485  10.517 -24.637  1.00 27.92           C  
ATOM   1151  CD  LYS B 716     -92.023  10.093 -24.834  1.00 29.90           C  
ATOM   1152  CE  LYS B 716     -91.069  11.299 -24.792  1.00 30.29           C  
ATOM   1153  NZ  LYS B 716     -89.754  11.095 -25.507  1.00 30.91           N  
ATOM   1154  N   ILE B 717     -96.561  10.977 -26.096  1.00 28.06           N  
ATOM   1155  CA  ILE B 717     -96.854  11.251 -27.506  1.00 27.78           C  
ATOM   1156  C   ILE B 717     -95.928  12.312 -28.026  1.00 27.54           C  
ATOM   1157  O   ILE B 717     -95.917  13.431 -27.556  1.00 26.77           O  
ATOM   1158  CB  ILE B 717     -98.287  11.694 -27.704  1.00 27.68           C  
ATOM   1159  CG1 ILE B 717     -99.180  10.587 -27.209  1.00 27.39           C  
ATOM   1160  CG2 ILE B 717     -98.533  11.979 -29.207  1.00 25.25           C  
ATOM   1161  CD1 ILE B 717    -100.556  11.068 -26.876  1.00 31.72           C  
ATOM   1162  N   GLU B 718     -95.156  11.924 -29.017  1.00 28.65           N  
ATOM   1163  CA  GLU B 718     -94.249  12.814 -29.694  1.00 29.75           C  
ATOM   1164  C   GLU B 718     -94.795  13.233 -31.042  1.00 27.64           C  
ATOM   1165  O   GLU B 718     -95.460  12.458 -31.686  1.00 26.64           O  
ATOM   1166  CB  GLU B 718     -92.931  12.091 -29.878  1.00 31.14           C  
ATOM   1167  CG  GLU B 718     -91.735  12.977 -30.040  1.00 39.64           C  
ATOM   1168  CD  GLU B 718     -90.476  12.235 -29.683  1.00 53.79           C  
ATOM   1169  OE1 GLU B 718     -90.249  12.089 -28.414  1.00 62.89           O  
ATOM   1170  OE2 GLU B 718     -89.766  11.811 -30.652  1.00 60.81           O  
ATOM   1171  N   PHE B 719     -94.503  14.468 -31.447  1.00 26.67           N  
ATOM   1172  CA  PHE B 719     -94.831  14.974 -32.765  1.00 26.12           C  
ATOM   1173  C   PHE B 719     -93.536  15.298 -33.503  1.00 27.58           C  
ATOM   1174  O   PHE B 719     -92.637  15.926 -32.924  1.00 28.70           O  
ATOM   1175  CB  PHE B 719     -95.587  16.328 -32.704  1.00 25.36           C  
ATOM   1176  CG  PHE B 719     -97.036  16.270 -32.254  1.00 23.04           C  
ATOM   1177  CD1 PHE B 719     -97.675  15.081 -31.830  1.00 23.27           C  
ATOM   1178  CD2 PHE B 719     -97.742  17.423 -32.204  1.00 20.06           C  
ATOM   1179  CE1 PHE B 719     -98.981  15.089 -31.415  1.00 22.07           C  
ATOM   1180  CE2 PHE B 719     -99.075  17.432 -31.812  1.00 22.92           C  
ATOM   1181  CZ  PHE B 719     -99.696  16.255 -31.409  1.00 22.12           C  
ATOM   1182  N   THR B 720     -93.462  14.915 -34.789  1.00 28.44           N  
ATOM   1183  CA  THR B 720     -92.388  15.295 -35.699  1.00 28.49           C  
ATOM   1184  C   THR B 720     -93.079  16.029 -36.817  1.00 28.49           C  
ATOM   1185  O   THR B 720     -94.250  15.761 -37.121  1.00 28.02           O  
ATOM   1186  CB  THR B 720     -91.597  14.069 -36.217  1.00 28.87           C  
ATOM   1187  OG1 THR B 720     -92.479  13.065 -36.729  1.00 29.70           O  
ATOM   1188  CG2 THR B 720     -90.839  13.402 -35.059  1.00 29.50           C  
ATOM   1189  N   PHE B 721     -92.397  16.969 -37.429  1.00 28.39           N  
ATOM   1190  CA  PHE B 721     -93.084  17.800 -38.414  1.00 28.53           C  
ATOM   1191  C   PHE B 721     -92.341  17.911 -39.730  1.00 30.40           C  
ATOM   1192  O   PHE B 721     -91.141  18.019 -39.722  1.00 29.59           O  
ATOM   1193  CB  PHE B 721     -93.199  19.228 -37.933  1.00 27.58           C  
ATOM   1194  CG  PHE B 721     -93.847  19.421 -36.644  1.00 24.37           C  
ATOM   1195  CD1 PHE B 721     -93.129  19.279 -35.456  1.00 22.41           C  
ATOM   1196  CD2 PHE B 721     -95.168  19.827 -36.585  1.00 22.91           C  
ATOM   1197  CE1 PHE B 721     -93.745  19.482 -34.219  1.00 19.91           C  
ATOM   1198  CE2 PHE B 721     -95.805  20.013 -35.324  1.00 23.00           C  
ATOM   1199  CZ  PHE B 721     -95.067  19.902 -34.150  1.00 18.52           C  
ATOM   1200  N   GLU B 722     -93.058  17.913 -40.849  1.00 33.76           N  
ATOM   1201  CA  GLU B 722     -92.460  18.160 -42.171  1.00 37.96           C  
ATOM   1202  C   GLU B 722     -93.313  19.185 -42.917  1.00 40.33           C  
ATOM   1203  O   GLU B 722     -94.529  19.017 -43.029  1.00 40.05           O  
ATOM   1204  CB  GLU B 722     -92.397  16.867 -43.043  1.00 38.64           C  
ATOM   1205  CG  GLU B 722     -91.299  15.859 -42.799  1.00 43.05           C  
ATOM   1206  CD  GLU B 722     -89.881  16.469 -42.739  1.00 51.81           C  
ATOM   1207  OE1 GLU B 722     -89.428  17.130 -43.720  1.00 58.61           O  
ATOM   1208  OE2 GLU B 722     -89.191  16.278 -41.707  1.00 53.06           O  
ATOM   1209  N   ARG B 723     -92.701  20.254 -43.428  1.00 44.98           N  
ATOM   1210  CA  ARG B 723     -93.432  21.189 -44.291  1.00 47.93           C  
ATOM   1211  C   ARG B 723     -93.535  20.403 -45.571  1.00 50.29           C  
ATOM   1212  O   ARG B 723     -92.634  19.654 -45.892  1.00 51.03           O  
ATOM   1213  CB  ARG B 723     -92.679  22.499 -44.566  1.00 48.80           C  
ATOM   1214  CG  ARG B 723     -93.610  23.625 -45.128  1.00 48.25           C  
ATOM   1215  CD  ARG B 723     -94.802  23.968 -44.204  1.00 48.56           C  
ATOM   1216  NE  ARG B 723     -94.390  24.567 -42.931  1.00 44.93           N  
ATOM   1217  CZ  ARG B 723     -94.550  25.829 -42.604  1.00 46.48           C  
ATOM   1218  NH1 ARG B 723     -95.127  26.693 -43.411  1.00 51.12           N  
ATOM   1219  NH2 ARG B 723     -94.123  26.272 -41.453  1.00 50.01           N  
ATOM   1220  N   SER B 724     -94.624  20.580 -46.303  1.00 53.04           N  
ATOM   1221  CA  SER B 724     -94.922  19.753 -47.478  1.00 54.55           C  
ATOM   1222  C   SER B 724     -94.245  20.202 -48.807  1.00 56.21           C  
ATOM   1223  O   SER B 724     -93.827  21.393 -49.009  1.00 55.99           O  
ATOM   1224  CB  SER B 724     -96.444  19.651 -47.625  1.00 54.48           C  
ATOM   1225  OG  SER B 724     -96.853  18.706 -48.584  1.00 56.07           O  
ATOM   1226  N   ASN B 725     -94.138  19.207 -49.697  1.00 57.88           N  
ATOM   1227  CA  ASN B 725     -93.508  19.365 -51.016  1.00 59.11           C  
ATOM   1228  C   ASN B 725     -94.505  19.699 -52.099  1.00 59.19           C  
ATOM   1229  O   ASN B 725     -94.166  20.441 -53.034  1.00 59.51           O  
ATOM   1230  CB  ASN B 725     -92.719  18.116 -51.375  1.00 59.59           C  
ATOM   1231  CG  ASN B 725     -91.447  18.021 -50.578  1.00 60.96           C  
ATOM   1232  OD1 ASN B 725     -90.480  18.760 -50.828  1.00 59.86           O  
ATOM   1233  ND2 ASN B 725     -91.451  17.138 -49.582  1.00 60.30           N  
ATOM   1234  N   THR B 726     -95.719  19.152 -51.964  1.00 58.53           N  
ATOM   1235  CA  THR B 726     -96.857  19.519 -52.818  1.00 57.60           C  
ATOM   1236  C   THR B 726     -97.363  20.898 -52.409  1.00 57.04           C  
ATOM   1237  O   THR B 726     -97.071  21.897 -53.083  1.00 57.58           O  
ATOM   1238  CB  THR B 726     -98.001  18.501 -52.648  1.00 57.47           C  
ATOM   1239  OG1 THR B 726     -97.666  17.324 -53.371  1.00 57.51           O  
ATOM   1240  CG2 THR B 726     -99.363  18.989 -53.259  1.00 57.34           C  
ATOM   1241  N   ASN B 727     -98.089  20.942 -51.279  1.00 55.50           N  
ATOM   1242  CA  ASN B 727     -98.768  22.144 -50.830  1.00 54.32           C  
ATOM   1243  C   ASN B 727     -97.965  22.783 -49.704  1.00 53.51           C  
ATOM   1244  O   ASN B 727     -97.947  22.294 -48.581  1.00 54.21           O  
ATOM   1245  CB  ASN B 727    -100.204  21.793 -50.411  1.00 54.10           C  
ATOM   1246  CG  ASN B 727    -101.117  23.017 -50.308  1.00 54.21           C  
ATOM   1247  OD1 ASN B 727    -100.672  24.174 -50.157  1.00 56.51           O  
ATOM   1248  ND2 ASN B 727    -102.400  22.763 -50.364  1.00 54.98           N  
ATOM   1249  N   PRO B 728     -97.316  23.900 -49.966  1.00 52.23           N  
ATOM   1250  CA  PRO B 728     -96.474  24.511 -48.920  1.00 50.46           C  
ATOM   1251  C   PRO B 728     -97.315  25.192 -47.789  1.00 48.14           C  
ATOM   1252  O   PRO B 728     -96.791  25.898 -46.911  1.00 47.46           O  
ATOM   1253  CB  PRO B 728     -95.615  25.525 -49.696  1.00 51.32           C  
ATOM   1254  CG  PRO B 728     -96.222  25.617 -51.097  1.00 52.25           C  
ATOM   1255  CD  PRO B 728     -97.405  24.712 -51.196  1.00 52.47           C  
ATOM   1256  N   SER B 729     -98.629  24.971 -47.832  1.00 45.75           N  
ATOM   1257  CA  SER B 729     -99.569  25.414 -46.783  1.00 43.74           C  
ATOM   1258  C   SER B 729     -99.921  24.257 -45.829  1.00 40.98           C  
ATOM   1259  O   SER B 729    -100.536  24.462 -44.782  1.00 39.75           O  
ATOM   1260  CB  SER B 729    -100.837  25.980 -47.437  1.00 43.78           C  
ATOM   1261  OG  SER B 729    -100.493  27.098 -48.246  1.00 43.26           O  
ATOM   1262  N   VAL B 730     -99.491  23.060 -46.222  1.00 38.37           N  
ATOM   1263  CA  VAL B 730     -99.675  21.841 -45.487  1.00 36.38           C  
ATOM   1264  C   VAL B 730     -98.473  21.522 -44.560  1.00 35.49           C  
ATOM   1265  O   VAL B 730     -97.316  21.431 -44.992  1.00 32.97           O  
ATOM   1266  CB  VAL B 730     -99.834  20.630 -46.464  1.00 36.19           C  
ATOM   1267  CG1 VAL B 730     -99.752  19.243 -45.737  1.00 34.88           C  
ATOM   1268  CG2 VAL B 730    -101.107  20.726 -47.278  1.00 37.55           C  
ATOM   1269  N   THR B 731     -98.769  21.257 -43.295  1.00 33.83           N  
ATOM   1270  CA  THR B 731     -97.735  20.724 -42.469  1.00 33.02           C  
ATOM   1271  C   THR B 731     -98.080  19.302 -42.080  1.00 31.96           C  
ATOM   1272  O   THR B 731     -99.186  19.048 -41.609  1.00 31.71           O  
ATOM   1273  CB  THR B 731     -97.543  21.623 -41.269  1.00 32.85           C  
ATOM   1274  OG1 THR B 731     -97.069  22.887 -41.748  1.00 33.41           O  
ATOM   1275  CG2 THR B 731     -96.369  21.133 -40.409  1.00 32.80           C  
ATOM   1276  N   VAL B 732     -97.130  18.382 -42.277  1.00 30.86           N  
ATOM   1277  CA  VAL B 732     -97.346  16.951 -41.943  1.00 29.78           C  
ATOM   1278  C   VAL B 732     -96.745  16.644 -40.574  1.00 29.83           C  
ATOM   1279  O   VAL B 732     -95.520  16.761 -40.343  1.00 29.38           O  
ATOM   1280  CB  VAL B 732     -96.728  15.972 -42.959  1.00 29.50           C  
ATOM   1281  CG1 VAL B 732     -97.150  14.538 -42.658  1.00 28.05           C  
ATOM   1282  CG2 VAL B 732     -97.135  16.343 -44.426  1.00 28.76           C  
ATOM   1283  N   ILE B 733     -97.645  16.291 -39.671  1.00 28.67           N  
ATOM   1284  CA  ILE B 733     -97.285  15.974 -38.328  1.00 27.93           C  
ATOM   1285  C   ILE B 733     -97.341  14.470 -38.135  1.00 27.17           C  
ATOM   1286  O   ILE B 733     -98.379  13.891 -38.230  1.00 27.02           O  
ATOM   1287  CB  ILE B 733     -98.298  16.627 -37.348  1.00 28.23           C  
ATOM   1288  CG1 ILE B 733     -98.301  18.155 -37.459  1.00 25.44           C  
ATOM   1289  CG2 ILE B 733     -97.930  16.271 -35.922  1.00 27.12           C  
ATOM   1290  CD1 ILE B 733     -99.390  18.731 -36.584  1.00 25.63           C  
ATOM   1291  N   THR B 734     -96.227  13.838 -37.861  1.00 27.20           N  
ATOM   1292  CA  THR B 734     -96.246  12.426 -37.535  1.00 27.07           C  
ATOM   1293  C   THR B 734     -96.297  12.270 -36.003  1.00 26.50           C  
ATOM   1294  O   THR B 734     -95.421  12.767 -35.353  1.00 26.39           O  
ATOM   1295  CB  THR B 734     -94.990  11.763 -38.072  1.00 26.33           C  
ATOM   1296  OG1 THR B 734     -94.900  11.888 -39.497  1.00 26.12           O  
ATOM   1297  CG2 THR B 734     -95.092  10.312 -37.875  1.00 28.42           C  
ATOM   1298  N   ILE B 735     -97.303  11.620 -35.430  1.00 26.44           N  
ATOM   1299  CA  ILE B 735     -97.299  11.389 -33.981  1.00 27.96           C  
ATOM   1300  C   ILE B 735     -96.644  10.038 -33.668  1.00 28.16           C  
ATOM   1301  O   ILE B 735     -96.847   9.092 -34.397  1.00 27.89           O  
ATOM   1302  CB  ILE B 735     -98.730  11.447 -33.307  1.00 28.10           C  
ATOM   1303  CG1 ILE B 735     -99.385  10.071 -33.268  1.00 30.29           C  
ATOM   1304  CG2 ILE B 735     -99.663  12.468 -33.975  1.00 29.90           C  
ATOM   1305  CD1 ILE B 735    -100.745  10.045 -32.581  1.00 32.89           C  
ATOM   1306  N   GLN B 736     -95.880   9.951 -32.585  1.00 29.07           N  
ATOM   1307  CA  GLN B 736     -95.351   8.647 -32.078  1.00 31.26           C  
ATOM   1308  C   GLN B 736     -95.833   8.402 -30.605  1.00 30.28           C  
ATOM   1309  O   GLN B 736     -95.389   9.051 -29.658  1.00 29.78           O  
ATOM   1310  CB  GLN B 736     -93.782   8.536 -32.131  1.00 32.13           C  
ATOM   1311  CG  GLN B 736     -93.088   8.863 -33.513  1.00 37.06           C  
ATOM   1312  CD  GLN B 736     -92.870   7.597 -34.400  1.00 45.17           C  
ATOM   1313  OE1 GLN B 736     -92.604   6.490 -33.890  1.00 50.03           O  
ATOM   1314  NE2 GLN B 736     -92.977   7.774 -35.723  1.00 46.96           N  
ATOM   1315  N   ALA B 737     -96.749   7.477 -30.424  1.00 29.64           N  
ATOM   1316  CA  ALA B 737     -97.209   7.116 -29.084  1.00 28.48           C  
ATOM   1317  C   ALA B 737     -96.361   5.937 -28.562  1.00 28.46           C  
ATOM   1318  O   ALA B 737     -96.154   4.940 -29.243  1.00 28.05           O  
ATOM   1319  CB  ALA B 737     -98.656   6.821 -29.110  1.00 27.50           C  
ATOM   1320  N   SER B 738     -95.786   6.117 -27.376  1.00 28.54           N  
ATOM   1321  CA  SER B 738     -94.999   5.084 -26.673  1.00 26.91           C  
ATOM   1322  C   SER B 738     -95.588   4.955 -25.233  1.00 26.74           C  
ATOM   1323  O   SER B 738     -96.281   5.867 -24.776  1.00 25.36           O  
ATOM   1324  CB  SER B 738     -93.527   5.471 -26.611  1.00 26.22           C  
ATOM   1325  OG  SER B 738     -93.359   6.748 -26.023  1.00 30.95           O  
ATOM   1326  N   ASN B 739     -95.310   3.834 -24.553  1.00 26.79           N  
ATOM   1327  CA  ASN B 739     -95.862   3.469 -23.255  1.00 28.60           C  
ATOM   1328  C   ASN B 739     -94.726   2.982 -22.338  1.00 30.86           C  
ATOM   1329  O   ASN B 739     -94.068   1.975 -22.656  1.00 33.15           O  
ATOM   1330  CB  ASN B 739     -96.957   2.399 -23.471  1.00 28.20           C  
ATOM   1331  CG  ASN B 739     -97.313   1.578 -22.230  1.00 28.61           C  
ATOM   1332  OD1 ASN B 739     -97.131   1.991 -21.054  1.00 28.50           O  
ATOM   1333  ND2 ASN B 739     -97.919   0.431 -22.479  1.00 26.72           N  
ATOM   1334  N   SER B 740     -94.437   3.700 -21.254  1.00 32.05           N  
ATOM   1335  CA  SER B 740     -93.297   3.272 -20.412  1.00 33.23           C  
ATOM   1336  C   SER B 740     -93.754   2.353 -19.297  1.00 33.56           C  
ATOM   1337  O   SER B 740     -92.949   1.953 -18.514  1.00 32.54           O  
ATOM   1338  CB  SER B 740     -92.491   4.480 -19.850  1.00 32.96           C  
ATOM   1339  OG  SER B 740     -93.354   5.443 -19.261  1.00 34.89           O  
ATOM   1340  N   THR B 741     -95.043   2.019 -19.213  1.00 35.15           N  
ATOM   1341  CA  THR B 741     -95.504   1.184 -18.095  1.00 36.15           C  
ATOM   1342  C   THR B 741     -95.178  -0.316 -18.352  1.00 37.49           C  
ATOM   1343  O   THR B 741     -94.569  -0.663 -19.361  1.00 34.81           O  
ATOM   1344  CB  THR B 741     -97.008   1.380 -17.784  1.00 35.96           C  
ATOM   1345  OG1 THR B 741     -97.828   0.935 -18.870  1.00 33.78           O  
ATOM   1346  CG2 THR B 741     -97.341   2.855 -17.595  1.00 36.72           C  
ATOM   1347  N   GLU B 742     -95.535  -1.152 -17.377  1.00 39.57           N  
ATOM   1348  CA  GLU B 742     -95.321  -2.603 -17.447  1.00 41.61           C  
ATOM   1349  C   GLU B 742     -96.395  -3.313 -18.227  1.00 40.84           C  
ATOM   1350  O   GLU B 742     -96.179  -4.438 -18.639  1.00 41.10           O  
ATOM   1351  CB  GLU B 742     -95.233  -3.220 -16.031  1.00 42.31           C  
ATOM   1352  CG  GLU B 742     -93.870  -3.010 -15.379  1.00 47.73           C  
ATOM   1353  CD  GLU B 742     -93.472  -4.076 -14.309  1.00 55.98           C  
ATOM   1354  OE1 GLU B 742     -94.290  -4.991 -13.894  1.00 56.34           O  
ATOM   1355  OE2 GLU B 742     -92.275  -3.999 -13.893  1.00 58.46           O  
ATOM   1356  N   LEU B 743     -97.517  -2.637 -18.466  1.00 40.99           N  
ATOM   1357  CA  LEU B 743     -98.712  -3.253 -19.027  1.00 41.03           C  
ATOM   1358  C   LEU B 743     -99.172  -2.528 -20.350  1.00 39.35           C  
ATOM   1359  O   LEU B 743     -99.017  -1.301 -20.498  1.00 39.41           O  
ATOM   1360  CB  LEU B 743     -99.795  -3.336 -17.871  1.00 42.78           C  
ATOM   1361  CG  LEU B 743     -99.946  -4.629 -17.006  1.00 47.55           C  
ATOM   1362  CD1 LEU B 743    -100.965  -4.646 -15.794  1.00 49.18           C  
ATOM   1363  CD2 LEU B 743    -100.247  -5.724 -18.192  1.00 51.37           C  
ATOM   1364  N   ASP B 744     -99.690  -3.299 -21.316  1.00 37.34           N  
ATOM   1365  CA  ASP B 744    -100.119  -2.755 -22.584  1.00 36.58           C  
ATOM   1366  C   ASP B 744    -101.289  -1.800 -22.515  1.00 35.38           C  
ATOM   1367  O   ASP B 744    -102.200  -2.006 -21.724  1.00 34.95           O  
ATOM   1368  CB  ASP B 744    -100.507  -3.869 -23.567  1.00 36.85           C  
ATOM   1369  CG  ASP B 744     -99.273  -4.586 -24.209  1.00 40.73           C  
ATOM   1370  OD1 ASP B 744     -98.136  -4.055 -24.175  1.00 42.89           O  
ATOM   1371  OD2 ASP B 744     -99.353  -5.710 -24.757  1.00 42.02           O  
ATOM   1372  N   MET B 745    -101.244  -0.770 -23.390  1.00 34.05           N  
ATOM   1373  CA  MET B 745    -102.392   0.100 -23.670  1.00 32.67           C  
ATOM   1374  C   MET B 745    -103.022  -0.472 -24.922  1.00 31.80           C  
ATOM   1375  O   MET B 745    -102.332  -0.646 -25.919  1.00 31.41           O  
ATOM   1376  CB  MET B 745    -101.972   1.576 -23.897  1.00 32.18           C  
ATOM   1377  CG  MET B 745    -101.481   2.273 -22.604  1.00 32.59           C  
ATOM   1378  SD  MET B 745    -100.304   3.647 -22.831  1.00 30.39           S  
ATOM   1379  CE  MET B 745    -100.129   4.083 -21.200  1.00 33.08           C  
ATOM   1380  N   THR B 746    -104.327  -0.719 -24.875  1.00 31.36           N  
ATOM   1381  CA  THR B 746    -105.051  -1.382 -25.945  1.00 31.04           C  
ATOM   1382  C   THR B 746    -106.244  -0.570 -26.347  1.00 32.38           C  
ATOM   1383  O   THR B 746    -106.647   0.329 -25.578  1.00 33.34           O  
ATOM   1384  CB  THR B 746    -105.474  -2.830 -25.510  1.00 30.73           C  
ATOM   1385  OG1 THR B 746    -106.304  -2.779 -24.327  1.00 28.17           O  
ATOM   1386  CG2 THR B 746    -104.212  -3.691 -25.104  1.00 30.89           C  
ATOM   1387  N   ASP B 747    -106.815  -0.903 -27.525  1.00 32.27           N  
ATOM   1388  CA  ASP B 747    -107.878  -0.141 -28.197  1.00 33.15           C  
ATOM   1389  C   ASP B 747    -107.579   1.376 -28.180  1.00 31.64           C  
ATOM   1390  O   ASP B 747    -108.471   2.190 -27.920  1.00 31.87           O  
ATOM   1391  CB  ASP B 747    -109.283  -0.426 -27.604  1.00 34.12           C  
ATOM   1392  CG  ASP B 747    -109.644  -1.906 -27.616  1.00 40.35           C  
ATOM   1393  OD1 ASP B 747    -109.032  -2.726 -28.367  1.00 47.35           O  
ATOM   1394  OD2 ASP B 747    -110.522  -2.368 -26.854  1.00 49.64           O  
ATOM   1395  N   PHE B 748    -106.343   1.730 -28.522  1.00 29.75           N  
ATOM   1396  CA  PHE B 748    -105.870   3.091 -28.414  1.00 28.60           C  
ATOM   1397  C   PHE B 748    -106.386   3.889 -29.549  1.00 28.53           C  
ATOM   1398  O   PHE B 748    -106.304   3.452 -30.655  1.00 28.67           O  
ATOM   1399  CB  PHE B 748    -104.337   3.124 -28.343  1.00 28.46           C  
ATOM   1400  CG  PHE B 748    -103.739   4.511 -28.367  1.00 27.73           C  
ATOM   1401  CD1 PHE B 748    -103.407   5.153 -27.203  1.00 25.90           C  
ATOM   1402  CD2 PHE B 748    -103.476   5.139 -29.569  1.00 27.04           C  
ATOM   1403  CE1 PHE B 748    -102.858   6.421 -27.242  1.00 30.14           C  
ATOM   1404  CE2 PHE B 748    -102.948   6.413 -29.622  1.00 28.88           C  
ATOM   1405  CZ  PHE B 748    -102.626   7.070 -28.452  1.00 28.20           C  
ATOM   1406  N   VAL B 749    -106.937   5.063 -29.240  1.00 29.22           N  
ATOM   1407  CA  VAL B 749    -107.439   6.042 -30.215  1.00 29.34           C  
ATOM   1408  C   VAL B 749    -106.912   7.473 -29.963  1.00 28.64           C  
ATOM   1409  O   VAL B 749    -107.030   8.034 -28.850  1.00 27.83           O  
ATOM   1410  CB  VAL B 749    -108.999   6.132 -30.255  1.00 29.94           C  
ATOM   1411  CG1 VAL B 749    -109.444   7.006 -31.374  1.00 28.58           C  
ATOM   1412  CG2 VAL B 749    -109.635   4.726 -30.425  1.00 30.23           C  
ATOM   1413  N   PHE B 750    -106.370   8.043 -31.035  1.00 27.92           N  
ATOM   1414  CA  PHE B 750    -105.894   9.412 -31.062  1.00 28.25           C  
ATOM   1415  C   PHE B 750    -106.774  10.141 -31.995  1.00 28.89           C  
ATOM   1416  O   PHE B 750    -106.944   9.702 -33.134  1.00 28.55           O  
ATOM   1417  CB  PHE B 750    -104.459   9.513 -31.569  1.00 28.11           C  
ATOM   1418  CG  PHE B 750    -103.918  10.934 -31.672  1.00 25.34           C  
ATOM   1419  CD1 PHE B 750    -103.171  11.484 -30.667  1.00 25.75           C  
ATOM   1420  CD2 PHE B 750    -104.046  11.635 -32.823  1.00 24.34           C  
ATOM   1421  CE1 PHE B 750    -102.662  12.806 -30.777  1.00 25.71           C  
ATOM   1422  CE2 PHE B 750    -103.531  12.922 -32.978  1.00 24.29           C  
ATOM   1423  CZ  PHE B 750    -102.842  13.508 -31.949  1.00 26.70           C  
ATOM   1424  N   GLN B 751    -107.376  11.221 -31.469  1.00 29.58           N  
ATOM   1425  CA  GLN B 751    -108.188  12.188 -32.224  1.00 30.12           C  
ATOM   1426  C   GLN B 751    -107.568  13.557 -32.090  1.00 29.35           C  
ATOM   1427  O   GLN B 751    -107.082  13.930 -31.022  1.00 27.96           O  
ATOM   1428  CB  GLN B 751    -109.589  12.343 -31.638  1.00 30.38           C  
ATOM   1429  CG  GLN B 751    -110.435  11.141 -31.707  1.00 35.26           C  
ATOM   1430  CD  GLN B 751    -111.758  11.346 -30.976  1.00 41.18           C  
ATOM   1431  OE1 GLN B 751    -112.241  10.436 -30.269  1.00 35.69           O  
ATOM   1432  NE2 GLN B 751    -112.331  12.563 -31.141  1.00 46.89           N  
ATOM   1433  N   ALA B 752    -107.719  14.348 -33.129  1.00 30.60           N  
ATOM   1434  CA  ALA B 752    -107.192  15.692 -33.139  1.00 31.57           C  
ATOM   1435  C   ALA B 752    -108.174  16.615 -33.806  1.00 31.80           C  
ATOM   1436  O   ALA B 752    -108.769  16.261 -34.810  1.00 31.63           O  
ATOM   1437  CB  ALA B 752    -105.874  15.714 -33.896  1.00 32.34           C  
ATOM   1438  N   ASP B 753    -108.273  17.836 -33.294  1.00 32.38           N  
ATOM   1439  CA  ASP B 753    -109.162  18.842 -33.870  1.00 32.61           C  
ATOM   1440  C   ASP B 753    -108.448  20.225 -33.896  1.00 32.72           C  
ATOM   1441  O   ASP B 753    -107.592  20.482 -33.065  1.00 31.63           O  
ATOM   1442  CB  ASP B 753    -110.460  18.858 -33.053  1.00 32.83           C  
ATOM   1443  CG  ASP B 753    -111.652  19.452 -33.807  1.00 32.25           C  
ATOM   1444  OD1 ASP B 753    -111.646  19.653 -35.046  1.00 33.42           O  
ATOM   1445  OD2 ASP B 753    -112.668  19.776 -33.184  1.00 35.07           O  
ATOM   1446  N   VAL B 754    -108.820  21.098 -34.819  1.00 34.23           N  
ATOM   1447  CA  VAL B 754    -108.233  22.429 -34.888  1.00 35.34           C  
ATOM   1448  C   VAL B 754    -109.385  23.424 -34.970  1.00 37.29           C  
ATOM   1449  O   VAL B 754    -110.482  23.028 -35.329  1.00 39.06           O  
ATOM   1450  CB  VAL B 754    -107.340  22.555 -36.141  1.00 35.13           C  
ATOM   1451  CG1 VAL B 754    -106.077  21.725 -36.012  1.00 32.51           C  
ATOM   1452  CG2 VAL B 754    -108.097  22.138 -37.402  1.00 37.01           C  
ATOM   1453  N   PRO B 755    -109.200  24.697 -34.627  1.00 38.47           N  
ATOM   1454  CA  PRO B 755    -110.275  25.653 -34.938  1.00 38.23           C  
ATOM   1455  C   PRO B 755    -110.441  25.812 -36.468  1.00 37.91           C  
ATOM   1456  O   PRO B 755    -109.583  25.312 -37.245  1.00 37.53           O  
ATOM   1457  CB  PRO B 755    -109.812  26.963 -34.314  1.00 38.44           C  
ATOM   1458  CG  PRO B 755    -108.621  26.642 -33.518  1.00 39.55           C  
ATOM   1459  CD  PRO B 755    -108.037  25.356 -34.015  1.00 38.45           C  
ATOM   1460  N   LYS B 756    -111.518  26.514 -36.857  1.00 38.11           N  
ATOM   1461  CA  LYS B 756    -111.977  26.658 -38.262  1.00 38.70           C  
ATOM   1462  C   LYS B 756    -110.977  27.329 -39.193  1.00 37.70           C  
ATOM   1463  O   LYS B 756    -111.007  27.158 -40.408  1.00 36.99           O  
ATOM   1464  CB  LYS B 756    -113.343  27.402 -38.334  1.00 39.43           C  
ATOM   1465  CG  LYS B 756    -114.590  26.525 -37.967  1.00 43.08           C  
ATOM   1466  CD  LYS B 756    -115.617  27.382 -37.129  1.00 47.62           C  
ATOM   1467  CE  LYS B 756    -116.609  26.484 -36.347  1.00 49.00           C  
ATOM   1468  NZ  LYS B 756    -116.903  25.190 -37.007  1.00 47.95           N  
ATOM   1469  N   THR B 757    -110.079  28.072 -38.580  1.00 37.53           N  
ATOM   1470  CA  THR B 757    -109.021  28.791 -39.254  1.00 37.34           C  
ATOM   1471  C   THR B 757    -108.043  27.850 -40.013  1.00 36.64           C  
ATOM   1472  O   THR B 757    -107.332  28.259 -40.926  1.00 37.04           O  
ATOM   1473  CB  THR B 757    -108.243  29.687 -38.209  1.00 38.32           C  
ATOM   1474  OG1 THR B 757    -107.053  29.026 -37.861  1.00 41.31           O  
ATOM   1475  CG2 THR B 757    -108.899  29.850 -36.777  1.00 36.21           C  
ATOM   1476  N   PHE B 758    -108.078  26.568 -39.653  1.00 35.38           N  
ATOM   1477  CA  PHE B 758    -107.204  25.546 -40.181  1.00 33.10           C  
ATOM   1478  C   PHE B 758    -108.133  24.450 -40.611  1.00 32.61           C  
ATOM   1479  O   PHE B 758    -109.278  24.456 -40.194  1.00 32.18           O  
ATOM   1480  CB  PHE B 758    -106.392  24.953 -39.022  1.00 32.62           C  
ATOM   1481  CG  PHE B 758    -105.645  25.974 -38.237  1.00 28.13           C  
ATOM   1482  CD1 PHE B 758    -105.999  26.319 -36.976  1.00 25.29           C  
ATOM   1483  CD2 PHE B 758    -104.596  26.665 -38.824  1.00 29.26           C  
ATOM   1484  CE1 PHE B 758    -105.302  27.276 -36.281  1.00 24.32           C  
ATOM   1485  CE2 PHE B 758    -103.893  27.629 -38.103  1.00 27.06           C  
ATOM   1486  CZ  PHE B 758    -104.255  27.912 -36.838  1.00 24.78           C  
ATOM   1487  N   GLN B 759    -107.640  23.531 -41.429  1.00 32.81           N  
ATOM   1488  CA  GLN B 759    -108.356  22.324 -41.812  1.00 34.07           C  
ATOM   1489  C   GLN B 759    -107.399  21.204 -41.456  1.00 33.38           C  
ATOM   1490  O   GLN B 759    -106.187  21.414 -41.319  1.00 32.91           O  
ATOM   1491  CB  GLN B 759    -108.694  22.290 -43.306  1.00 35.34           C  
ATOM   1492  CG  GLN B 759    -109.698  23.426 -43.835  1.00 39.71           C  
ATOM   1493  CD  GLN B 759    -109.855  23.360 -45.380  1.00 44.89           C  
ATOM   1494  OE1 GLN B 759    -109.528  24.328 -46.055  1.00 51.85           O  
ATOM   1495  NE2 GLN B 759    -110.289  22.200 -45.927  1.00 41.34           N  
ATOM   1496  N   LEU B 760    -107.956  20.007 -41.346  1.00 33.46           N  
ATOM   1497  CA  LEU B 760    -107.269  18.869 -40.723  1.00 33.20           C  
ATOM   1498  C   LEU B 760    -107.621  17.521 -41.337  1.00 32.12           C  
ATOM   1499  O   LEU B 760    -108.783  17.255 -41.629  1.00 30.57           O  
ATOM   1500  CB  LEU B 760    -107.656  18.845 -39.249  1.00 33.24           C  
ATOM   1501  CG  LEU B 760    -107.014  17.840 -38.315  1.00 35.67           C  
ATOM   1502  CD1 LEU B 760    -105.576  17.975 -38.323  1.00 39.70           C  
ATOM   1503  CD2 LEU B 760    -107.491  18.149 -36.898  1.00 40.18           C  
ATOM   1504  N   GLN B 761    -106.588  16.735 -41.636  1.00 31.69           N  
ATOM   1505  CA  GLN B 761    -106.787  15.399 -42.113  1.00 31.74           C  
ATOM   1506  C   GLN B 761    -106.067  14.397 -41.233  1.00 31.64           C  
ATOM   1507  O   GLN B 761    -104.874  14.463 -40.980  1.00 31.33           O  
ATOM   1508  CB  GLN B 761    -106.336  15.240 -43.554  1.00 32.42           C  
ATOM   1509  CG  GLN B 761    -106.733  13.895 -44.153  1.00 33.56           C  
ATOM   1510  CD  GLN B 761    -105.980  13.586 -45.423  1.00 37.79           C  
ATOM   1511  OE1 GLN B 761    -105.064  14.348 -45.827  1.00 39.22           O  
ATOM   1512  NE2 GLN B 761    -106.323  12.448 -46.055  1.00 36.53           N  
ATOM   1513  N   LEU B 762    -106.789  13.394 -40.817  1.00 32.46           N  
ATOM   1514  CA  LEU B 762    -106.190  12.382 -39.972  1.00 32.95           C  
ATOM   1515  C   LEU B 762    -106.175  11.033 -40.674  1.00 31.83           C  
ATOM   1516  O   LEU B 762    -107.232  10.472 -40.921  1.00 31.58           O  
ATOM   1517  CB  LEU B 762    -106.961  12.299 -38.658  1.00 33.46           C  
ATOM   1518  CG  LEU B 762    -106.309  11.407 -37.598  1.00 37.91           C  
ATOM   1519  CD1 LEU B 762    -105.110  12.099 -36.957  1.00 40.65           C  
ATOM   1520  CD2 LEU B 762    -107.346  10.961 -36.505  1.00 41.67           C  
ATOM   1521  N   LEU B 763    -104.959  10.528 -40.934  1.00 30.83           N  
ATOM   1522  CA  LEU B 763    -104.714   9.249 -41.541  1.00 30.55           C  
ATOM   1523  C   LEU B 763    -104.696   8.156 -40.467  1.00 30.17           C  
ATOM   1524  O   LEU B 763    -104.574   8.415 -39.273  1.00 28.31           O  
ATOM   1525  CB  LEU B 763    -103.383   9.260 -42.321  1.00 30.67           C  
ATOM   1526  CG  LEU B 763    -103.202  10.319 -43.413  1.00 34.42           C  
ATOM   1527  CD1 LEU B 763    -101.962  10.057 -44.357  1.00 36.05           C  
ATOM   1528  CD2 LEU B 763    -104.438  10.372 -44.230  1.00 36.88           C  
ATOM   1529  N   SER B 764    -104.729   6.913 -40.908  1.00 30.30           N  
ATOM   1530  CA  SER B 764    -104.965   5.840 -39.978  1.00 31.36           C  
ATOM   1531  C   SER B 764    -103.724   5.454 -39.186  1.00 30.33           C  
ATOM   1532  O   SER B 764    -102.602   5.603 -39.644  1.00 28.74           O  
ATOM   1533  CB  SER B 764    -105.613   4.619 -40.668  1.00 32.78           C  
ATOM   1534  OG  SER B 764    -105.229   4.506 -41.999  1.00 36.62           O  
ATOM   1535  N   PRO B 765    -103.951   4.980 -37.968  1.00 29.47           N  
ATOM   1536  CA  PRO B 765    -102.828   4.626 -37.083  1.00 29.34           C  
ATOM   1537  C   PRO B 765    -102.117   3.344 -37.545  1.00 28.50           C  
ATOM   1538  O   PRO B 765    -102.760   2.536 -38.179  1.00 28.61           O  
ATOM   1539  CB  PRO B 765    -103.531   4.408 -35.729  1.00 29.67           C  
ATOM   1540  CG  PRO B 765    -104.988   4.005 -36.068  1.00 27.38           C  
ATOM   1541  CD  PRO B 765    -105.272   4.699 -37.350  1.00 28.86           C  
ATOM   1542  N   SER B 766    -100.838   3.159 -37.250  1.00 27.89           N  
ATOM   1543  CA  SER B 766    -100.184   1.910 -37.639  1.00 27.98           C  
ATOM   1544  C   SER B 766    -100.840   0.731 -36.928  1.00 29.34           C  
ATOM   1545  O   SER B 766    -100.880  -0.335 -37.457  1.00 30.46           O  
ATOM   1546  CB  SER B 766     -98.712   1.935 -37.285  1.00 27.20           C  
ATOM   1547  OG  SER B 766     -98.599   2.348 -35.954  1.00 24.55           O  
ATOM   1548  N   SER B 767    -101.281   0.923 -35.688  1.00 31.35           N  
ATOM   1549  CA  SER B 767    -101.948  -0.123 -34.895  1.00 32.11           C  
ATOM   1550  C   SER B 767    -102.713   0.485 -33.785  1.00 31.33           C  
ATOM   1551  O   SER B 767    -102.741   1.702 -33.641  1.00 30.37           O  
ATOM   1552  CB  SER B 767    -100.963  -1.149 -34.284  1.00 32.76           C  
ATOM   1553  OG  SER B 767    -100.194  -0.638 -33.225  1.00 33.74           O  
ATOM   1554  N   SER B 768    -103.358  -0.389 -33.026  1.00 31.64           N  
ATOM   1555  CA  SER B 768    -104.091  -0.019 -31.804  1.00 31.56           C  
ATOM   1556  C   SER B 768    -103.435  -0.275 -30.449  1.00 30.61           C  
ATOM   1557  O   SER B 768    -104.072  -0.101 -29.432  1.00 30.76           O  
ATOM   1558  CB  SER B 768    -105.339  -0.848 -31.738  1.00 31.36           C  
ATOM   1559  OG  SER B 768    -106.329  -0.222 -32.415  1.00 34.27           O  
ATOM   1560  N   VAL B 769    -102.218  -0.768 -30.402  1.00 31.66           N  
ATOM   1561  CA  VAL B 769    -101.600  -1.125 -29.101  1.00 31.49           C  
ATOM   1562  C   VAL B 769    -100.335  -0.336 -28.938  1.00 30.26           C  
ATOM   1563  O   VAL B 769     -99.581  -0.168 -29.907  1.00 29.86           O  
ATOM   1564  CB  VAL B 769    -101.291  -2.644 -29.051  1.00 32.25           C  
ATOM   1565  CG1 VAL B 769    -100.541  -3.014 -27.854  1.00 32.69           C  
ATOM   1566  CG2 VAL B 769    -102.576  -3.430 -29.074  1.00 35.80           C  
ATOM   1567  N   VAL B 770    -100.210   0.247 -27.755  1.00 30.63           N  
ATOM   1568  CA  VAL B 770     -99.014   0.913 -27.303  1.00 31.35           C  
ATOM   1569  C   VAL B 770     -98.442  -0.133 -26.276  1.00 32.89           C  
ATOM   1570  O   VAL B 770     -98.988  -0.326 -25.131  1.00 31.68           O  
ATOM   1571  CB  VAL B 770     -99.201   2.329 -26.619  1.00 31.30           C  
ATOM   1572  CG1 VAL B 770     -97.838   3.078 -26.619  1.00 32.02           C  
ATOM   1573  CG2 VAL B 770    -100.189   3.198 -27.269  1.00 28.21           C  
ATOM   1574  N   PRO B 771     -97.404  -0.837 -26.746  1.00 33.96           N  
ATOM   1575  CA  PRO B 771     -96.775  -1.952 -26.041  1.00 34.99           C  
ATOM   1576  C   PRO B 771     -95.932  -1.529 -24.856  1.00 34.02           C  
ATOM   1577  O   PRO B 771     -95.266  -0.494 -24.902  1.00 34.30           O  
ATOM   1578  CB  PRO B 771     -95.879  -2.602 -27.141  1.00 35.02           C  
ATOM   1579  CG  PRO B 771     -96.279  -1.979 -28.464  1.00 35.80           C  
ATOM   1580  CD  PRO B 771     -96.766  -0.619 -28.062  1.00 34.39           C  
ATOM   1581  N   ALA B 772     -95.946  -2.373 -23.831  1.00 34.26           N  
ATOM   1582  CA  ALA B 772     -95.236  -2.145 -22.575  1.00 34.61           C  
ATOM   1583  C   ALA B 772     -93.730  -1.978 -22.803  1.00 34.93           C  
ATOM   1584  O   ALA B 772     -93.207  -2.403 -23.818  1.00 35.88           O  
ATOM   1585  CB  ALA B 772     -95.568  -3.309 -21.597  1.00 34.58           C  
ATOM   1586  N   PHE B 773     -93.059  -1.291 -21.894  1.00 36.35           N  
ATOM   1587  CA  PHE B 773     -91.585  -1.120 -21.891  1.00 37.72           C  
ATOM   1588  C   PHE B 773     -90.949  -0.513 -23.119  1.00 37.97           C  
ATOM   1589  O   PHE B 773     -89.758  -0.784 -23.434  1.00 38.10           O  
ATOM   1590  CB  PHE B 773     -90.858  -2.441 -21.609  1.00 38.68           C  
ATOM   1591  CG  PHE B 773     -91.380  -3.177 -20.417  1.00 41.95           C  
ATOM   1592  CD1 PHE B 773     -90.890  -2.881 -19.122  1.00 45.36           C  
ATOM   1593  CD2 PHE B 773     -92.352  -4.191 -20.580  1.00 43.34           C  
ATOM   1594  CE1 PHE B 773     -91.358  -3.613 -17.997  1.00 46.36           C  
ATOM   1595  CE2 PHE B 773     -92.843  -4.943 -19.452  1.00 45.17           C  
ATOM   1596  CZ  PHE B 773     -92.359  -4.659 -18.178  1.00 46.04           C  
ATOM   1597  N   ASN B 774     -91.691   0.354 -23.782  1.00 38.07           N  
ATOM   1598  CA  ASN B 774     -91.150   1.040 -24.951  1.00 38.61           C  
ATOM   1599  C   ASN B 774     -90.585   0.119 -25.962  1.00 38.03           C  
ATOM   1600  O   ASN B 774     -89.554   0.408 -26.508  1.00 37.82           O  
ATOM   1601  CB  ASN B 774     -90.059   2.024 -24.550  1.00 39.22           C  
ATOM   1602  CG  ASN B 774     -90.597   3.207 -23.827  1.00 40.21           C  
ATOM   1603  OD1 ASN B 774     -90.276   3.396 -22.659  1.00 45.26           O  
ATOM   1604  ND2 ASN B 774     -91.452   3.990 -24.484  1.00 31.27           N  
ATOM   1605  N   THR B 775     -91.277  -0.982 -26.225  1.00 38.73           N  
ATOM   1606  CA  THR B 775     -90.748  -2.014 -27.116  1.00 39.52           C  
ATOM   1607  C   THR B 775     -91.015  -1.607 -28.543  1.00 39.91           C  
ATOM   1608  O   THR B 775     -90.260  -1.940 -29.483  1.00 41.71           O  
ATOM   1609  CB  THR B 775     -91.384  -3.385 -26.774  1.00 39.81           C  
ATOM   1610  OG1 THR B 775     -92.786  -3.223 -26.500  1.00 39.91           O  
ATOM   1611  CG2 THR B 775     -90.801  -3.918 -25.407  1.00 38.94           C  
ATOM   1612  N   GLY B 776     -92.089  -0.845 -28.678  1.00 39.23           N  
ATOM   1613  CA  GLY B 776     -92.558  -0.338 -29.942  1.00 38.45           C  
ATOM   1614  C   GLY B 776     -93.367   0.935 -29.677  1.00 38.38           C  
ATOM   1615  O   GLY B 776     -93.528   1.411 -28.528  1.00 37.32           O  
ATOM   1616  N   THR B 777     -93.857   1.468 -30.803  1.00 37.27           N  
ATOM   1617  CA  THR B 777     -94.637   2.705 -30.873  1.00 35.92           C  
ATOM   1618  C   THR B 777     -95.835   2.606 -31.828  1.00 34.19           C  
ATOM   1619  O   THR B 777     -95.893   1.673 -32.612  1.00 34.26           O  
ATOM   1620  CB  THR B 777     -93.753   3.917 -31.248  1.00 36.26           C  
ATOM   1621  OG1 THR B 777     -93.506   3.922 -32.642  1.00 36.70           O  
ATOM   1622  CG2 THR B 777     -92.351   3.833 -30.632  1.00 37.85           C  
ATOM   1623  N   ILE B 778     -96.828   3.494 -31.653  1.00 32.13           N  
ATOM   1624  CA  ILE B 778     -97.952   3.662 -32.605  1.00 30.33           C  
ATOM   1625  C   ILE B 778     -97.643   4.963 -33.331  1.00 30.00           C  
ATOM   1626  O   ILE B 778     -97.365   5.986 -32.690  1.00 28.25           O  
ATOM   1627  CB  ILE B 778     -99.333   3.787 -31.948  1.00 29.30           C  
ATOM   1628  CG1 ILE B 778     -99.830   2.449 -31.381  1.00 25.88           C  
ATOM   1629  CG2 ILE B 778    -100.341   4.187 -32.948  1.00 29.65           C  
ATOM   1630  CD1 ILE B 778    -101.129   2.547 -30.611  1.00 21.68           C  
ATOM   1631  N   THR B 779     -97.727   4.910 -34.661  1.00 29.49           N  
ATOM   1632  CA  THR B 779     -97.431   6.043 -35.529  1.00 29.23           C  
ATOM   1633  C   THR B 779     -98.695   6.554 -36.209  1.00 28.32           C  
ATOM   1634  O   THR B 779     -99.497   5.771 -36.653  1.00 29.52           O  
ATOM   1635  CB  THR B 779     -96.404   5.546 -36.575  1.00 29.54           C  
ATOM   1636  OG1 THR B 779     -95.158   5.387 -35.914  1.00 31.86           O  
ATOM   1637  CG2 THR B 779     -96.055   6.594 -37.569  1.00 30.29           C  
ATOM   1638  N   GLN B 780     -98.873   7.851 -36.398  1.00 26.95           N  
ATOM   1639  CA  GLN B 780    -100.099   8.280 -37.056  1.00 24.98           C  
ATOM   1640  C   GLN B 780     -99.899   9.646 -37.632  1.00 24.58           C  
ATOM   1641  O   GLN B 780     -99.400  10.566 -36.939  1.00 25.49           O  
ATOM   1642  CB  GLN B 780    -101.297   8.263 -36.083  1.00 24.41           C  
ATOM   1643  CG  GLN B 780    -102.600   8.540 -36.775  1.00 24.32           C  
ATOM   1644  CD  GLN B 780    -103.885   8.201 -35.979  1.00 27.80           C  
ATOM   1645  OE1 GLN B 780    -103.889   8.024 -34.733  1.00 28.16           O  
ATOM   1646  NE2 GLN B 780    -105.007   8.187 -36.708  1.00 24.45           N  
ATOM   1647  N   VAL B 781    -100.336   9.825 -38.876  1.00 23.55           N  
ATOM   1648  CA  VAL B 781    -100.069  11.049 -39.597  1.00 22.13           C  
ATOM   1649  C   VAL B 781    -101.258  11.973 -39.510  1.00 22.46           C  
ATOM   1650  O   VAL B 781    -102.392  11.542 -39.664  1.00 23.14           O  
ATOM   1651  CB  VAL B 781     -99.729  10.766 -41.068  1.00 22.60           C  
ATOM   1652  CG1 VAL B 781     -99.571  12.126 -41.874  1.00 22.03           C  
ATOM   1653  CG2 VAL B 781     -98.472   9.937 -41.216  1.00 21.07           C  
ATOM   1654  N   ILE B 782    -101.013  13.240 -39.181  1.00 23.22           N  
ATOM   1655  CA  ILE B 782    -102.017  14.272 -39.231  1.00 23.70           C  
ATOM   1656  C   ILE B 782    -101.518  15.280 -40.284  1.00 24.78           C  
ATOM   1657  O   ILE B 782    -100.338  15.660 -40.277  1.00 24.90           O  
ATOM   1658  CB  ILE B 782    -102.090  15.077 -37.979  1.00 23.98           C  
ATOM   1659  CG1 ILE B 782    -102.131  14.280 -36.740  1.00 27.83           C  
ATOM   1660  CG2 ILE B 782    -103.347  15.973 -37.996  1.00 25.78           C  
ATOM   1661  CD1 ILE B 782    -101.726  15.228 -35.577  1.00 30.07           C  
ATOM   1662  N   LYS B 783    -102.393  15.762 -41.134  1.00 26.18           N  
ATOM   1663  CA  LYS B 783    -101.998  16.823 -42.036  1.00 28.43           C  
ATOM   1664  C   LYS B 783    -102.869  18.024 -41.734  1.00 29.10           C  
ATOM   1665  O   LYS B 783    -104.109  17.902 -41.553  1.00 30.07           O  
ATOM   1666  CB  LYS B 783    -102.140  16.417 -43.491  1.00 30.32           C  
ATOM   1667  CG  LYS B 783    -101.225  15.232 -43.978  1.00 31.53           C  
ATOM   1668  CD  LYS B 783    -101.593  14.806 -45.432  1.00 33.80           C  
ATOM   1669  CE  LYS B 783    -100.892  13.505 -45.874  1.00 40.16           C  
ATOM   1670  NZ  LYS B 783    -100.264  13.677 -47.189  1.00 47.03           N  
ATOM   1671  N   VAL B 784    -102.197  19.171 -41.647  1.00 29.06           N  
ATOM   1672  CA  VAL B 784    -102.783  20.435 -41.314  1.00 29.41           C  
ATOM   1673  C   VAL B 784    -102.547  21.451 -42.424  1.00 30.04           C  
ATOM   1674  O   VAL B 784    -101.421  21.628 -42.902  1.00 29.63           O  
ATOM   1675  CB  VAL B 784    -102.171  20.968 -40.002  1.00 29.39           C  
ATOM   1676  CG1 VAL B 784    -102.619  22.373 -39.734  1.00 28.75           C  
ATOM   1677  CG2 VAL B 784    -102.631  20.075 -38.836  1.00 32.86           C  
ATOM   1678  N   LEU B 785    -103.643  22.086 -42.795  1.00 31.10           N  
ATOM   1679  CA  LEU B 785    -103.723  23.122 -43.789  1.00 32.11           C  
ATOM   1680  C   LEU B 785    -103.988  24.438 -43.029  1.00 32.67           C  
ATOM   1681  O   LEU B 785    -104.925  24.532 -42.185  1.00 30.82           O  
ATOM   1682  CB  LEU B 785    -104.866  22.813 -44.761  1.00 32.46           C  
ATOM   1683  CG  LEU B 785    -104.880  23.861 -45.959  1.00 37.17           C  
ATOM   1684  CD1 LEU B 785    -103.610  23.954 -46.885  1.00 38.93           C  
ATOM   1685  CD2 LEU B 785    -106.093  23.685 -46.857  1.00 38.84           C  
ATOM   1686  N   ASN B 786    -103.143  25.432 -43.344  1.00 33.67           N  
ATOM   1687  CA  ASN B 786    -103.011  26.723 -42.629  1.00 34.67           C  
ATOM   1688  C   ASN B 786    -102.678  27.872 -43.629  1.00 35.68           C  
ATOM   1689  O   ASN B 786    -101.532  28.327 -43.643  1.00 35.81           O  
ATOM   1690  CB  ASN B 786    -101.856  26.522 -41.607  1.00 34.81           C  
ATOM   1691  CG  ASN B 786    -101.741  27.616 -40.530  1.00 32.36           C  
ATOM   1692  OD1 ASN B 786    -102.328  28.666 -40.604  1.00 32.81           O  
ATOM   1693  ND2 ASN B 786    -100.952  27.329 -39.523  1.00 27.99           N  
ATOM   1694  N   PRO B 787    -103.681  28.298 -44.433  1.00 37.44           N  
ATOM   1695  CA  PRO B 787    -103.541  29.338 -45.487  1.00 38.73           C  
ATOM   1696  C   PRO B 787    -103.004  30.656 -44.942  1.00 39.03           C  
ATOM   1697  O   PRO B 787    -102.111  31.214 -45.573  1.00 39.43           O  
ATOM   1698  CB  PRO B 787    -104.996  29.522 -46.029  1.00 39.19           C  
ATOM   1699  CG  PRO B 787    -105.789  28.331 -45.542  1.00 39.29           C  
ATOM   1700  CD  PRO B 787    -105.067  27.790 -44.332  1.00 37.93           C  
ATOM   1701  N   GLN B 788    -103.477  31.115 -43.784  1.00 39.36           N  
ATOM   1702  CA  GLN B 788    -103.072  32.438 -43.276  1.00 39.17           C  
ATOM   1703  C   GLN B 788    -101.746  32.392 -42.457  1.00 38.35           C  
ATOM   1704  O   GLN B 788    -101.307  33.391 -41.827  1.00 37.98           O  
ATOM   1705  CB  GLN B 788    -104.247  33.007 -42.452  1.00 41.13           C  
ATOM   1706  CG  GLN B 788    -105.680  32.877 -43.139  1.00 39.25           C  
ATOM   1707  CD  GLN B 788    -105.628  33.487 -44.507  1.00 42.12           C  
ATOM   1708  OE1 GLN B 788    -106.251  32.988 -45.464  1.00 45.09           O  
ATOM   1709  NE2 GLN B 788    -104.846  34.560 -44.628  1.00 40.56           N  
ATOM   1710  N   LYS B 789    -101.106  31.216 -42.445  1.00 37.72           N  
ATOM   1711  CA  LYS B 789     -99.833  31.062 -41.745  1.00 37.37           C  
ATOM   1712  C   LYS B 789     -99.910  31.586 -40.299  1.00 35.20           C  
ATOM   1713  O   LYS B 789     -98.984  32.292 -39.782  1.00 35.72           O  
ATOM   1714  CB  LYS B 789     -98.729  31.769 -42.555  1.00 37.80           C  
ATOM   1715  CG  LYS B 789     -98.337  30.984 -43.842  1.00 42.75           C  
ATOM   1716  CD  LYS B 789     -97.384  31.783 -44.812  1.00 45.37           C  
ATOM   1717  CE  LYS B 789     -96.713  30.877 -45.835  1.00 47.72           C  
ATOM   1718  NZ  LYS B 789     -95.380  31.470 -46.331  1.00 52.87           N  
ATOM   1719  N   GLN B 790    -100.965  31.171 -39.618  1.00 32.11           N  
ATOM   1720  CA  GLN B 790    -101.172  31.610 -38.246  1.00 31.86           C  
ATOM   1721  C   GLN B 790    -100.836  30.585 -37.152  1.00 29.88           C  
ATOM   1722  O   GLN B 790    -100.674  29.371 -37.399  1.00 28.72           O  
ATOM   1723  CB  GLN B 790    -102.561  32.201 -38.035  1.00 32.21           C  
ATOM   1724  CG  GLN B 790    -103.489  32.090 -39.181  1.00 37.74           C  
ATOM   1725  CD  GLN B 790    -104.519  33.192 -39.235  1.00 39.30           C  
ATOM   1726  OE1 GLN B 790    -104.215  34.359 -38.940  1.00 42.07           O  
ATOM   1727  NE2 GLN B 790    -105.717  32.847 -39.692  1.00 42.90           N  
ATOM   1728  N   GLN B 791    -100.726  31.106 -35.934  1.00 27.43           N  
ATOM   1729  CA  GLN B 791    -100.285  30.304 -34.804  1.00 26.71           C  
ATOM   1730  C   GLN B 791    -101.076  29.031 -34.748  1.00 26.30           C  
ATOM   1731  O   GLN B 791    -102.261  29.077 -34.613  1.00 27.32           O  
ATOM   1732  CB  GLN B 791    -100.394  31.094 -33.514  1.00 26.40           C  
ATOM   1733  CG  GLN B 791    -100.285  30.305 -32.231  1.00 25.95           C  
ATOM   1734  CD  GLN B 791     -98.965  29.741 -32.033  1.00 24.82           C  
ATOM   1735  OE1 GLN B 791     -98.024  30.466 -31.998  1.00 26.42           O  
ATOM   1736  NE2 GLN B 791     -98.875  28.421 -31.869  1.00 28.72           N  
ATOM   1737  N   LEU B 792    -100.425  27.892 -34.822  1.00 24.53           N  
ATOM   1738  CA  LEU B 792    -101.184  26.675 -34.851  1.00 24.80           C  
ATOM   1739  C   LEU B 792    -101.776  26.401 -33.447  1.00 25.22           C  
ATOM   1740  O   LEU B 792    -101.189  26.819 -32.368  1.00 24.48           O  
ATOM   1741  CB  LEU B 792    -100.280  25.537 -35.356  1.00 24.88           C  
ATOM   1742  CG  LEU B 792    -100.903  24.194 -35.584  1.00 28.98           C  
ATOM   1743  CD1 LEU B 792    -101.822  24.284 -36.725  1.00 32.57           C  
ATOM   1744  CD2 LEU B 792     -99.824  23.133 -35.843  1.00 34.47           C  
ATOM   1745  N   ARG B 793    -102.977  25.815 -33.462  1.00 24.11           N  
ATOM   1746  CA  ARG B 793    -103.649  25.420 -32.255  1.00 24.65           C  
ATOM   1747  C   ARG B 793    -104.287  24.080 -32.493  1.00 24.00           C  
ATOM   1748  O   ARG B 793    -104.681  23.745 -33.614  1.00 23.14           O  
ATOM   1749  CB  ARG B 793    -104.725  26.422 -31.852  1.00 25.87           C  
ATOM   1750  CG  ARG B 793    -104.185  27.848 -31.808  1.00 29.67           C  
ATOM   1751  CD  ARG B 793    -105.177  28.916 -31.356  1.00 31.42           C  
ATOM   1752  NE  ARG B 793    -105.838  28.457 -30.170  1.00 31.76           N  
ATOM   1753  CZ  ARG B 793    -107.133  28.247 -30.032  1.00 37.00           C  
ATOM   1754  NH1 ARG B 793    -107.988  28.466 -31.026  1.00 37.20           N  
ATOM   1755  NH2 ARG B 793    -107.577  27.800 -28.860  1.00 38.80           N  
ATOM   1756  N   MET B 794    -104.445  23.324 -31.431  1.00 23.48           N  
ATOM   1757  CA  MET B 794    -104.957  21.958 -31.617  1.00 23.83           C  
ATOM   1758  C   MET B 794    -105.257  21.320 -30.265  1.00 23.55           C  
ATOM   1759  O   MET B 794    -104.560  21.582 -29.270  1.00 21.24           O  
ATOM   1760  CB  MET B 794    -103.940  21.104 -32.433  1.00 23.15           C  
ATOM   1761  CG  MET B 794    -104.191  19.649 -32.467  1.00 24.05           C  
ATOM   1762  SD  MET B 794    -102.968  18.561 -33.353  1.00 24.29           S  
ATOM   1763  CE  MET B 794    -102.932  19.352 -34.932  1.00 22.73           C  
ATOM   1764  N   ARG B 795    -106.358  20.547 -30.250  1.00 23.93           N  
ATOM   1765  CA  ARG B 795    -106.777  19.768 -29.099  1.00 24.23           C  
ATOM   1766  C   ARG B 795    -106.701  18.272 -29.468  1.00 23.45           C  
ATOM   1767  O   ARG B 795    -106.869  17.870 -30.634  1.00 23.02           O  
ATOM   1768  CB  ARG B 795    -108.169  20.182 -28.686  1.00 25.56           C  
ATOM   1769  CG  ARG B 795    -108.224  21.284 -27.616  1.00 29.54           C  
ATOM   1770  CD  ARG B 795    -109.428  22.211 -27.676  1.00 33.94           C  
ATOM   1771  NE  ARG B 795    -109.841  22.685 -26.369  1.00 40.58           N  
ATOM   1772  CZ  ARG B 795    -110.511  23.808 -26.106  1.00 48.95           C  
ATOM   1773  NH1 ARG B 795    -110.861  24.658 -27.039  1.00 53.16           N  
ATOM   1774  NH2 ARG B 795    -110.836  24.092 -24.866  1.00 53.33           N  
ATOM   1775  N   ILE B 796    -106.382  17.453 -28.485  1.00 23.16           N  
ATOM   1776  CA  ILE B 796    -106.299  16.035 -28.710  1.00 22.36           C  
ATOM   1777  C   ILE B 796    -107.082  15.320 -27.667  1.00 22.91           C  
ATOM   1778  O   ILE B 796    -107.200  15.806 -26.511  1.00 22.55           O  
ATOM   1779  CB  ILE B 796    -104.834  15.516 -28.720  1.00 22.52           C  
ATOM   1780  CG1 ILE B 796    -104.119  15.724 -27.410  1.00 22.62           C  
ATOM   1781  CG2 ILE B 796    -104.011  16.143 -29.826  1.00 23.81           C  
ATOM   1782  CD1 ILE B 796    -102.644  15.084 -27.384  1.00 22.14           C  
ATOM   1783  N   LYS B 797    -107.609  14.161 -28.084  1.00 23.19           N  
ATOM   1784  CA  LYS B 797    -108.300  13.235 -27.206  1.00 23.97           C  
ATOM   1785  C   LYS B 797    -107.667  11.835 -27.370  1.00 23.54           C  
ATOM   1786  O   LYS B 797    -107.501  11.293 -28.486  1.00 23.00           O  
ATOM   1787  CB  LYS B 797    -109.808  13.209 -27.526  1.00 25.20           C  
ATOM   1788  CG  LYS B 797    -110.765  12.534 -26.478  1.00 27.72           C  
ATOM   1789  CD  LYS B 797    -112.163  12.371 -27.070  1.00 31.94           C  
ATOM   1790  CE  LYS B 797    -113.215  12.034 -26.051  1.00 37.16           C  
ATOM   1791  NZ  LYS B 797    -114.572  12.322 -26.589  1.00 37.09           N  
ATOM   1792  N   LEU B 798    -107.335  11.267 -26.224  1.00 23.75           N  
ATOM   1793  CA  LEU B 798    -106.694   9.991 -26.064  1.00 23.94           C  
ATOM   1794  C   LEU B 798    -107.643   9.052 -25.250  1.00 25.61           C  
ATOM   1795  O   LEU B 798    -108.087   9.423 -24.150  1.00 24.99           O  
ATOM   1796  CB  LEU B 798    -105.368  10.186 -25.313  1.00 24.30           C  
ATOM   1797  CG  LEU B 798    -104.441  11.342 -25.748  1.00 24.47           C  
ATOM   1798  CD1 LEU B 798    -103.319  11.427 -24.829  1.00 27.89           C  
ATOM   1799  CD2 LEU B 798    -103.912  11.197 -27.109  1.00 26.54           C  
ATOM   1800  N   THR B 799    -107.988   7.879 -25.837  1.00 26.35           N  
ATOM   1801  CA  THR B 799    -108.805   6.853 -25.195  1.00 26.00           C  
ATOM   1802  C   THR B 799    -108.090   5.547 -25.420  1.00 25.98           C  
ATOM   1803  O   THR B 799    -107.564   5.313 -26.491  1.00 23.84           O  
ATOM   1804  CB  THR B 799    -110.176   6.734 -25.767  1.00 26.41           C  
ATOM   1805  OG1 THR B 799    -110.087   6.457 -27.177  1.00 30.30           O  
ATOM   1806  CG2 THR B 799    -110.947   8.022 -25.711  1.00 26.67           C  
ATOM   1807  N   TYR B 800    -108.032   4.732 -24.372  1.00 27.33           N  
ATOM   1808  CA  TYR B 800    -107.386   3.408 -24.372  1.00 28.15           C  
ATOM   1809  C   TYR B 800    -107.722   2.603 -23.080  1.00 30.10           C  
ATOM   1810  O   TYR B 800    -108.225   3.174 -22.088  1.00 28.52           O  
ATOM   1811  CB  TYR B 800    -105.880   3.538 -24.462  1.00 27.25           C  
ATOM   1812  CG  TYR B 800    -105.198   4.409 -23.388  1.00 27.47           C  
ATOM   1813  CD1 TYR B 800    -104.587   3.841 -22.295  1.00 28.15           C  
ATOM   1814  CD2 TYR B 800    -105.134   5.780 -23.509  1.00 24.11           C  
ATOM   1815  CE1 TYR B 800    -103.952   4.587 -21.363  1.00 28.05           C  
ATOM   1816  CE2 TYR B 800    -104.512   6.524 -22.597  1.00 25.84           C  
ATOM   1817  CZ  TYR B 800    -103.908   5.940 -21.513  1.00 29.56           C  
ATOM   1818  OH  TYR B 800    -103.253   6.733 -20.574  1.00 31.66           O  
ATOM   1819  N   ASN B 801    -107.458   1.286 -23.114  1.00 32.21           N  
ATOM   1820  CA  ASN B 801    -107.574   0.453 -21.918  1.00 34.31           C  
ATOM   1821  C   ASN B 801    -106.213   0.119 -21.329  1.00 35.63           C  
ATOM   1822  O   ASN B 801    -105.234  -0.069 -22.052  1.00 36.18           O  
ATOM   1823  CB  ASN B 801    -108.402  -0.808 -22.175  1.00 34.88           C  
ATOM   1824  CG  ASN B 801    -109.808  -0.497 -22.526  1.00 35.81           C  
ATOM   1825  OD1 ASN B 801    -110.267  -0.785 -23.634  1.00 43.03           O  
ATOM   1826  ND2 ASN B 801    -110.505   0.134 -21.612  1.00 36.95           N  
ATOM   1827  N   HIS B 802    -106.163   0.071 -20.004  1.00 37.24           N  
ATOM   1828  CA  HIS B 802    -104.924  -0.146 -19.264  1.00 38.35           C  
ATOM   1829  C   HIS B 802    -105.284  -0.652 -17.891  1.00 40.30           C  
ATOM   1830  O   HIS B 802    -106.153  -0.065 -17.226  1.00 40.39           O  
ATOM   1831  CB  HIS B 802    -104.223   1.172 -19.093  1.00 38.02           C  
ATOM   1832  CG  HIS B 802    -102.771   1.048 -18.815  1.00 37.68           C  
ATOM   1833  ND1 HIS B 802    -102.097   1.943 -18.020  1.00 33.31           N  
ATOM   1834  CD2 HIS B 802    -101.848   0.167 -19.275  1.00 38.61           C  
ATOM   1835  CE1 HIS B 802    -100.819   1.604 -17.976  1.00 38.07           C  
ATOM   1836  NE2 HIS B 802    -100.642   0.518 -18.715  1.00 38.25           N  
ATOM   1837  N   LYS B 803    -104.635  -1.745 -17.478  1.00 43.27           N  
ATOM   1838  CA  LYS B 803    -104.935  -2.445 -16.206  1.00 44.73           C  
ATOM   1839  C   LYS B 803    -106.425  -2.649 -16.011  1.00 44.68           C  
ATOM   1840  O   LYS B 803    -106.969  -2.299 -14.970  1.00 44.70           O  
ATOM   1841  CB  LYS B 803    -104.407  -1.677 -14.995  1.00 45.66           C  
ATOM   1842  CG  LYS B 803    -103.097  -0.908 -15.240  1.00 49.66           C  
ATOM   1843  CD  LYS B 803    -102.465  -0.298 -13.946  1.00 51.14           C  
ATOM   1844  CE  LYS B 803    -101.515   0.869 -14.362  1.00 53.71           C  
ATOM   1845  NZ  LYS B 803    -100.250   0.985 -13.544  1.00 53.87           N  
ATOM   1846  N   GLY B 804    -107.095  -3.167 -17.022  1.00 45.15           N  
ATOM   1847  CA  GLY B 804    -108.518  -3.427 -16.910  1.00 46.50           C  
ATOM   1848  C   GLY B 804    -109.431  -2.208 -16.805  1.00 47.41           C  
ATOM   1849  O   GLY B 804    -110.641  -2.405 -16.693  1.00 48.65           O  
ATOM   1850  N   SER B 805    -108.883  -0.985 -16.867  1.00 47.30           N  
ATOM   1851  CA  SER B 805    -109.647   0.244 -16.729  1.00 47.60           C  
ATOM   1852  C   SER B 805    -109.633   1.054 -18.069  1.00 46.77           C  
ATOM   1853  O   SER B 805    -108.573   1.125 -18.724  1.00 46.41           O  
ATOM   1854  CB  SER B 805    -108.994   1.108 -15.630  1.00 48.84           C  
ATOM   1855  OG  SER B 805    -109.717   1.149 -14.425  1.00 50.55           O  
ATOM   1856  N   ALA B 806    -110.782   1.665 -18.428  1.00 44.62           N  
ATOM   1857  CA  ALA B 806    -110.929   2.553 -19.602  1.00 43.59           C  
ATOM   1858  C   ALA B 806    -110.371   3.943 -19.300  1.00 42.59           C  
ATOM   1859  O   ALA B 806    -110.833   4.601 -18.388  1.00 43.57           O  
ATOM   1860  CB  ALA B 806    -112.416   2.667 -20.029  1.00 43.06           C  
ATOM   1861  N   MET B 807    -109.366   4.370 -20.047  1.00 42.31           N  
ATOM   1862  CA  MET B 807    -108.719   5.662 -19.841  1.00 42.18           C  
ATOM   1863  C   MET B 807    -109.201   6.720 -20.839  1.00 41.69           C  
ATOM   1864  O   MET B 807    -109.539   6.430 -21.984  1.00 39.67           O  
ATOM   1865  CB  MET B 807    -107.198   5.565 -19.988  1.00 42.36           C  
ATOM   1866  CG  MET B 807    -106.490   4.694 -18.995  1.00 44.47           C  
ATOM   1867  SD  MET B 807    -106.861   5.026 -17.291  1.00 46.70           S  
ATOM   1868  CE  MET B 807    -105.795   6.307 -16.859  1.00 46.17           C  
ATOM   1869  N   GLN B 808    -109.215   7.962 -20.370  1.00 41.91           N  
ATOM   1870  CA  GLN B 808    -109.570   9.115 -21.210  1.00 42.28           C  
ATOM   1871  C   GLN B 808    -108.745  10.371 -20.804  1.00 40.31           C  
ATOM   1872  O   GLN B 808    -108.483  10.586 -19.635  1.00 40.83           O  
ATOM   1873  CB  GLN B 808    -111.093   9.390 -21.168  1.00 42.53           C  
ATOM   1874  CG  GLN B 808    -111.456  10.650 -21.933  1.00 47.28           C  
ATOM   1875  CD  GLN B 808    -112.908  10.706 -22.420  1.00 51.72           C  
ATOM   1876  OE1 GLN B 808    -113.668  11.619 -22.036  1.00 53.41           O  
ATOM   1877  NE2 GLN B 808    -113.268   9.789 -23.320  1.00 53.10           N  
ATOM   1878  N   ASP B 809    -108.290  11.151 -21.780  1.00 38.63           N  
ATOM   1879  CA  ASP B 809    -107.655  12.440 -21.508  1.00 36.45           C  
ATOM   1880  C   ASP B 809    -107.875  13.338 -22.706  1.00 36.22           C  
ATOM   1881  O   ASP B 809    -108.021  12.884 -23.861  1.00 35.59           O  
ATOM   1882  CB  ASP B 809    -106.156  12.304 -21.236  1.00 36.44           C  
ATOM   1883  CG  ASP B 809    -105.665  13.276 -20.172  1.00 34.47           C  
ATOM   1884  OD1 ASP B 809    -106.458  14.123 -19.741  1.00 34.45           O  
ATOM   1885  OD2 ASP B 809    -104.518  13.268 -19.703  1.00 30.51           O  
ATOM   1886  N   LEU B 810    -107.947  14.617 -22.394  1.00 36.03           N  
ATOM   1887  CA  LEU B 810    -108.096  15.717 -23.363  1.00 36.20           C  
ATOM   1888  C   LEU B 810    -106.991  16.646 -23.044  1.00 33.30           C  
ATOM   1889  O   LEU B 810    -106.685  16.776 -21.908  1.00 32.60           O  
ATOM   1890  CB  LEU B 810    -109.399  16.485 -23.160  1.00 37.06           C  
ATOM   1891  CG  LEU B 810    -110.699  15.722 -23.393  1.00 43.02           C  
ATOM   1892  CD1 LEU B 810    -111.970  16.635 -23.310  1.00 46.51           C  
ATOM   1893  CD2 LEU B 810    -110.681  15.123 -24.756  1.00 46.94           C  
ATOM   1894  N   ALA B 811    -106.333  17.189 -24.057  1.00 32.52           N  
ATOM   1895  CA  ALA B 811    -105.257  18.216 -23.876  1.00 31.01           C  
ATOM   1896  C   ALA B 811    -105.231  19.221 -25.040  1.00 29.73           C  
ATOM   1897  O   ALA B 811    -105.610  18.924 -26.180  1.00 30.50           O  
ATOM   1898  CB  ALA B 811    -103.901  17.599 -23.723  1.00 30.07           C  
ATOM   1899  N   GLU B 812    -104.828  20.422 -24.709  1.00 28.61           N  
ATOM   1900  CA  GLU B 812    -104.575  21.469 -25.686  1.00 28.92           C  
ATOM   1901  C   GLU B 812    -103.074  21.624 -25.874  1.00 27.13           C  
ATOM   1902  O   GLU B 812    -102.362  21.718 -24.899  1.00 25.59           O  
ATOM   1903  CB  GLU B 812    -105.172  22.818 -25.273  1.00 28.26           C  
ATOM   1904  CG  GLU B 812    -105.120  23.789 -26.468  1.00 33.30           C  
ATOM   1905  CD  GLU B 812    -106.036  24.994 -26.348  1.00 36.72           C  
ATOM   1906  OE1 GLU B 812    -107.082  24.834 -25.688  1.00 38.18           O  
ATOM   1907  OE2 GLU B 812    -105.684  26.072 -26.935  1.00 41.80           O  
ATOM   1908  N   VAL B 813    -102.613  21.651 -27.133  1.00 26.52           N  
ATOM   1909  CA  VAL B 813    -101.205  21.672 -27.414  1.00 25.61           C  
ATOM   1910  C   VAL B 813    -100.801  23.068 -27.532  1.00 25.66           C  
ATOM   1911  O   VAL B 813    -101.225  23.737 -28.486  1.00 25.16           O  
ATOM   1912  CB  VAL B 813    -100.839  20.928 -28.663  1.00 26.12           C  
ATOM   1913  CG1 VAL B 813     -99.329  20.953 -28.874  1.00 24.12           C  
ATOM   1914  CG2 VAL B 813    -101.318  19.491 -28.539  1.00 27.86           C  
ATOM   1915  N   ASN B 814     -99.983  23.531 -26.561  1.00 25.52           N  
ATOM   1916  CA  ASN B 814     -99.532  24.948 -26.582  1.00 25.58           C  
ATOM   1917  C   ASN B 814     -98.037  25.138 -26.678  1.00 24.24           C  
ATOM   1918  O   ASN B 814     -97.513  26.212 -26.336  1.00 23.36           O  
ATOM   1919  CB  ASN B 814    -100.057  25.698 -25.366  1.00 27.12           C  
ATOM   1920  CG  ASN B 814    -101.503  26.102 -25.515  1.00 28.70           C  
ATOM   1921  OD1 ASN B 814    -102.295  25.783 -24.672  1.00 31.08           O  
ATOM   1922  ND2 ASN B 814    -101.839  26.831 -26.596  1.00 33.01           N  
ATOM   1923  N   ASN B 815     -97.369  24.079 -27.153  1.00 22.28           N  
ATOM   1924  CA  ASN B 815     -95.955  24.099 -27.445  1.00 20.86           C  
ATOM   1925  C   ASN B 815     -95.543  23.783 -28.932  1.00 20.02           C  
ATOM   1926  O   ASN B 815     -94.442  23.294 -29.165  1.00 18.99           O  
ATOM   1927  CB  ASN B 815     -95.188  23.206 -26.425  1.00 21.68           C  
ATOM   1928  CG  ASN B 815     -95.496  21.775 -26.559  1.00 17.15           C  
ATOM   1929  OD1 ASN B 815     -96.524  21.430 -27.041  1.00 21.66           O  
ATOM   1930  ND2 ASN B 815     -94.623  20.936 -26.095  1.00 18.02           N  
ATOM   1931  N   PHE B 816     -96.394  24.106 -29.914  1.00 18.81           N  
ATOM   1932  CA  PHE B 816     -95.984  24.013 -31.312  1.00 18.60           C  
ATOM   1933  C   PHE B 816     -94.829  25.007 -31.511  1.00 18.88           C  
ATOM   1934  O   PHE B 816     -94.887  26.135 -31.007  1.00 19.89           O  
ATOM   1935  CB  PHE B 816     -97.133  24.397 -32.241  1.00 19.36           C  
ATOM   1936  CG  PHE B 816     -98.316  23.352 -32.316  1.00 22.16           C  
ATOM   1937  CD1 PHE B 816     -99.586  23.665 -31.800  1.00 20.77           C  
ATOM   1938  CD2 PHE B 816     -98.123  22.115 -32.917  1.00 22.22           C  
ATOM   1939  CE1 PHE B 816    -100.647  22.761 -31.874  1.00 23.33           C  
ATOM   1940  CE2 PHE B 816     -99.164  21.192 -33.050  1.00 27.40           C  
ATOM   1941  CZ  PHE B 816    -100.453  21.513 -32.557  1.00 28.11           C  
ATOM   1942  N   PRO B 817     -93.774  24.635 -32.207  1.00 18.54           N  
ATOM   1943  CA  PRO B 817     -92.727  25.581 -32.514  1.00 20.11           C  
ATOM   1944  C   PRO B 817     -93.150  26.492 -33.687  1.00 20.48           C  
ATOM   1945  O   PRO B 817     -93.939  26.114 -34.535  1.00 20.21           O  
ATOM   1946  CB  PRO B 817     -91.565  24.688 -32.934  1.00 21.23           C  
ATOM   1947  CG  PRO B 817     -92.225  23.546 -33.638  1.00 21.09           C  
ATOM   1948  CD  PRO B 817     -93.498  23.339 -32.791  1.00 19.04           C  
ATOM   1949  N   PRO B 818     -92.656  27.723 -33.726  1.00 21.25           N  
ATOM   1950  CA  PRO B 818     -93.065  28.649 -34.809  1.00 22.00           C  
ATOM   1951  C   PRO B 818     -92.852  28.090 -36.252  1.00 22.67           C  
ATOM   1952  O   PRO B 818     -93.515  28.471 -37.233  1.00 21.85           O  
ATOM   1953  CB  PRO B 818     -92.188  29.909 -34.558  1.00 21.89           C  
ATOM   1954  CG  PRO B 818     -91.085  29.448 -33.617  1.00 20.64           C  
ATOM   1955  CD  PRO B 818     -91.729  28.347 -32.765  1.00 20.04           C  
ATOM   1956  N   GLN B 819     -91.891  27.189 -36.355  1.00 24.11           N  
ATOM   1957  CA  GLN B 819     -91.536  26.580 -37.639  1.00 24.26           C  
ATOM   1958  C   GLN B 819     -92.635  25.658 -38.149  1.00 24.63           C  
ATOM   1959  O   GLN B 819     -92.727  25.391 -39.365  1.00 25.31           O  
ATOM   1960  CB  GLN B 819     -90.218  25.806 -37.469  1.00 25.00           C  
ATOM   1961  CG  GLN B 819     -88.994  26.671 -37.167  1.00 24.17           C  
ATOM   1962  CD  GLN B 819     -88.573  26.710 -35.678  1.00 30.17           C  
ATOM   1963  OE1 GLN B 819     -89.418  26.632 -34.767  1.00 28.72           O  
ATOM   1964  NE2 GLN B 819     -87.241  26.878 -35.441  1.00 30.73           N  
ATOM   1965  N   SER B 820     -93.504  25.176 -37.259  1.00 23.89           N  
ATOM   1966  CA  SER B 820     -94.587  24.303 -37.707  1.00 23.24           C  
ATOM   1967  C   SER B 820     -95.695  25.087 -38.433  1.00 24.27           C  
ATOM   1968  O   SER B 820     -96.632  24.492 -39.012  1.00 25.22           O  
ATOM   1969  CB  SER B 820     -95.194  23.576 -36.520  1.00 22.54           C  
ATOM   1970  OG  SER B 820     -95.747  24.509 -35.616  1.00 22.40           O  
ATOM   1971  N   TRP B 821     -95.635  26.404 -38.403  1.00 23.56           N  
ATOM   1972  CA  TRP B 821     -96.703  27.167 -39.006  1.00 24.64           C  
ATOM   1973  C   TRP B 821     -96.277  28.489 -39.686  1.00 26.29           C  
ATOM   1974  O   TRP B 821     -97.005  28.974 -40.530  1.00 26.88           O  
ATOM   1975  CB  TRP B 821     -97.788  27.449 -37.952  1.00 24.06           C  
ATOM   1976  CG  TRP B 821     -97.306  28.221 -36.703  1.00 21.96           C  
ATOM   1977  CD1 TRP B 821     -97.031  27.690 -35.469  1.00 19.10           C  
ATOM   1978  CD2 TRP B 821     -97.144  29.647 -36.557  1.00 21.66           C  
ATOM   1979  NE1 TRP B 821     -96.656  28.679 -34.588  1.00 17.84           N  
ATOM   1980  CE2 TRP B 821     -96.714  29.891 -35.224  1.00 21.43           C  
ATOM   1981  CE3 TRP B 821     -97.333  30.746 -37.408  1.00 22.00           C  
ATOM   1982  CZ2 TRP B 821     -96.424  31.181 -34.746  1.00 19.37           C  
ATOM   1983  CZ3 TRP B 821     -97.066  32.016 -36.932  1.00 20.08           C  
ATOM   1984  CH2 TRP B 821     -96.625  32.230 -35.609  1.00 19.43           C  
ATOM   1985  N   GLN B 822     -95.140  29.075 -39.336  1.00 27.68           N  
ATOM   1986  CA  GLN B 822     -94.719  30.263 -40.060  1.00 30.34           C  
ATOM   1987  C   GLN B 822     -94.307  30.038 -41.524  1.00 30.99           C  
ATOM   1988  O   GLN B 822     -94.461  30.942 -42.337  1.00 30.67           O  
ATOM   1989  CB  GLN B 822     -93.492  30.887 -39.445  1.00 30.67           C  
ATOM   1990  CG  GLN B 822     -93.670  31.540 -38.184  1.00 33.04           C  
ATOM   1991  CD  GLN B 822     -92.396  32.152 -37.781  1.00 35.95           C  
ATOM   1992  OE1 GLN B 822     -92.385  33.352 -37.547  1.00 45.16           O  
ATOM   1993  NE2 GLN B 822     -91.283  31.384 -37.820  1.00 34.44           N  
ATOM   1994  OXT GLN B 822     -93.682  29.020 -41.875  1.00 34.13           O  
TER    1995      GLN B 822                                                      
END
MOLECULE T0514.pdb
ATOM   7695  N   SER     1     -73.106  18.033 -40.322  1.00 86.00           N  
ATOM   7696  CA  SER     1     -73.011  18.711 -38.995  1.00 85.50           C  
ATOM   7697  C   SER     1     -74.354  19.367 -38.664  1.00 79.83           C  
ATOM   7698  O   SER     1     -74.616  20.512 -39.038  1.00 86.46           O  
ATOM   7699  CB  SER     1     -71.867  19.728 -38.999  1.00 86.33           C  
ATOM   7700  OG  SER     1     -71.212  19.767 -37.742  1.00 88.81           O  
ATOM   7701  N   SER     2     -75.186  18.622 -37.940  1.00 70.86           N  
ATOM   7702  CA  SER     2     -76.629  18.868 -37.847  1.00 70.05           C  
ATOM   7703  C   SER     2     -77.049  19.675 -36.613  1.00 66.08           C  
ATOM   7704  O   SER     2     -77.518  19.116 -35.621  1.00 67.53           O  
ATOM   7705  CB  SER     2     -77.364  17.524 -37.883  1.00 72.15           C  
ATOM   7706  OG  SER     2     -78.761  17.686 -37.715  1.00 76.65           O  
ATOM   7707  N   LEU     3     -76.905  20.994 -36.702  1.00 57.90           N  
ATOM   7708  CA  LEU     3     -77.150  21.891 -35.579  1.00 49.32           C  
ATOM   7709  C   LEU     3     -78.641  22.135 -35.344  1.00 45.20           C  
ATOM   7710  O   LEU     3     -79.395  22.383 -36.285  1.00 46.29           O  
ATOM   7711  CB  LEU     3     -76.427  23.218 -35.823  1.00 50.89           C  
ATOM   7712  CG  LEU     3     -75.688  23.894 -34.673  1.00 48.11           C  
ATOM   7713  CD1 LEU     3     -74.641  22.973 -34.089  1.00 51.21           C  
ATOM   7714  CD2 LEU     3     -75.040  25.155 -35.184  1.00 47.04           C  
ATOM   7715  N   THR     4     -79.051  22.068 -34.078  1.00 40.66           N  
ATOM   7716  CA  THR     4     -80.445  22.293 -33.688  1.00 38.62           C  
ATOM   7717  C   THR     4     -80.772  23.788 -33.633  1.00 40.67           C  
ATOM   7718  O   THR     4     -80.086  24.559 -32.951  1.00 39.89           O  
ATOM   7719  CB  THR     4     -80.760  21.636 -32.319  1.00 36.41           C  
ATOM   7720  OG1 THR     4     -80.313  20.276 -32.327  1.00 37.81           O  
ATOM   7721  CG2 THR     4     -82.255  21.661 -32.026  1.00 30.45           C  
ATOM   7722  N   GLU     5     -81.811  24.184 -34.370  1.00 39.96           N  
ATOM   7723  CA  GLU     5     -82.345  25.546 -34.329  1.00 39.54           C  
ATOM   7724  C   GLU     5     -83.553  25.564 -33.417  1.00 37.36           C  
ATOM   7725  O   GLU     5     -84.281  24.581 -33.340  1.00 38.64           O  
ATOM   7726  CB  GLU     5     -82.768  26.019 -35.722  1.00 39.72           C  
ATOM   7727  CG  GLU     5     -81.673  25.972 -36.765  1.00 42.97           C  
ATOM   7728  CD  GLU     5     -82.038  26.679 -38.058  1.00 52.29           C  
ATOM   7729  OE1 GLU     5     -81.494  26.288 -39.114  1.00 59.87           O  
ATOM   7730  OE2 GLU     5     -82.861  27.622 -38.023  1.00 58.70           O  
ATOM   7731  N   THR     6     -83.771  26.685 -32.739  1.00 39.74           N  
ATOM   7732  CA  THR     6     -84.865  26.804 -31.783  1.00 40.46           C  
ATOM   7733  C   THR     6     -85.754  27.995 -32.125  1.00 40.75           C  
ATOM   7734  O   THR     6     -85.275  29.127 -32.261  1.00 42.54           O  
ATOM   7735  CB  THR     6     -84.337  26.935 -30.323  1.00 42.91           C  
ATOM   7736  OG1 THR     6     -83.371  25.908 -30.059  1.00 46.85           O  
ATOM   7737  CG2 THR     6     -85.477  26.818 -29.319  1.00 44.55           C  
ATOM   7738  N   TYR     7     -87.047  27.721 -32.277  1.00 39.16           N  
ATOM   7739  CA  TYR     7     -88.045  28.754 -32.525  1.00 35.75           C  
ATOM   7740  C   TYR     7     -89.166  28.573 -31.529  1.00 35.97           C  
ATOM   7741  O   TYR     7     -90.017  27.699 -31.698  1.00 39.75           O  
ATOM   7742  CB  TYR     7     -88.560  28.689 -33.969  1.00 38.99           C  
ATOM   7743  CG  TYR     7     -87.478  28.999 -34.969  1.00 40.54           C  
ATOM   7744  CD1 TYR     7     -87.179  30.317 -35.305  1.00 37.88           C  
ATOM   7745  CD2 TYR     7     -86.726  27.978 -35.553  1.00 37.35           C  
ATOM   7746  CE1 TYR     7     -86.166  30.614 -36.212  1.00 41.16           C  
ATOM   7747  CE2 TYR     7     -85.712  28.261 -36.456  1.00 37.99           C  
ATOM   7748  CZ  TYR     7     -85.437  29.579 -36.783  1.00 40.84           C  
ATOM   7749  OH  TYR     7     -84.431  29.867 -37.675  1.00 49.82           O  
ATOM   7750  N   GLY     8     -89.140  29.398 -30.483  1.00 35.98           N  
ATOM   7751  CA  GLY     8     -90.046  29.261 -29.348  1.00 34.78           C  
ATOM   7752  C   GLY     8     -89.837  27.928 -28.661  1.00 37.11           C  
ATOM   7753  O   GLY     8     -88.768  27.666 -28.097  1.00 39.11           O  
ATOM   7754  N   LEU     9     -90.858  27.081 -28.742  1.00 35.37           N  
ATOM   7755  CA  LEU     9     -90.831  25.755 -28.144  1.00 32.71           C  
ATOM   7756  C   LEU     9     -90.501  24.674 -29.174  1.00 33.56           C  
ATOM   7757  O   LEU     9     -90.358  23.498 -28.825  1.00 34.51           O  
ATOM   7758  CB  LEU     9     -92.174  25.452 -27.473  1.00 30.66           C  
ATOM   7759  CG  LEU     9     -92.546  26.278 -26.243  1.00 31.48           C  
ATOM   7760  CD1 LEU     9     -93.946  25.918 -25.798  1.00 26.00           C  
ATOM   7761  CD2 LEU     9     -91.550  26.088 -25.099  1.00 28.69           C  
ATOM   7762  N   TRP    10     -90.363  25.084 -30.436  1.00 35.01           N  
ATOM   7763  CA  TRP    10     -90.121  24.154 -31.539  1.00 33.36           C  
ATOM   7764  C   TRP    10     -88.660  24.091 -31.974  1.00 35.75           C  
ATOM   7765  O   TRP    10     -87.944  25.097 -31.949  1.00 33.95           O  
ATOM   7766  CB  TRP    10     -91.035  24.480 -32.721  1.00 31.82           C  
ATOM   7767  CG  TRP    10     -92.432  23.993 -32.495  1.00 30.68           C  
ATOM   7768  CD1 TRP    10     -93.389  24.573 -31.708  1.00 27.17           C  
ATOM   7769  CD2 TRP    10     -93.025  22.808 -33.041  1.00 29.19           C  
ATOM   7770  NE1 TRP    10     -94.545  23.827 -31.737  1.00 30.50           N  
ATOM   7771  CE2 TRP    10     -94.350  22.738 -32.549  1.00 31.52           C  
ATOM   7772  CE3 TRP    10     -92.566  21.798 -33.901  1.00 28.90           C  
ATOM   7773  CZ2 TRP    10     -95.224  21.695 -32.888  1.00 32.76           C  
ATOM   7774  CZ3 TRP    10     -93.437  20.759 -34.242  1.00 30.01           C  
ATOM   7775  CH2 TRP    10     -94.749  20.716 -33.733  1.00 32.69           C  
ATOM   7776  N   SER    11     -88.225  22.890 -32.351  1.00 35.54           N  
ATOM   7777  CA  SER    11     -86.858  22.665 -32.800  1.00 34.01           C  
ATOM   7778  C   SER    11     -86.809  22.282 -34.273  1.00 34.91           C  
ATOM   7779  O   SER    11     -87.770  21.719 -34.807  1.00 32.84           O  
ATOM   7780  CB  SER    11     -86.184  21.585 -31.957  1.00 34.82           C  
ATOM   7781  OG  SER    11     -86.153  21.951 -30.592  1.00 40.26           O  
ATOM   7782  N   ILE    12     -85.691  22.609 -34.921  1.00 37.39           N  
ATOM   7783  CA  ILE    12     -85.430  22.225 -36.311  1.00 38.04           C  
ATOM   7784  C   ILE    12     -84.071  21.530 -36.443  1.00 37.76           C  
ATOM   7785  O   ILE    12     -83.051  22.050 -35.989  1.00 38.44           O  
ATOM   7786  CB  ILE    12     -85.517  23.448 -37.280  1.00 39.96           C  
ATOM   7787  CG1 ILE    12     -86.963  23.902 -37.431  1.00 38.91           C  
ATOM   7788  CG2 ILE    12     -84.949  23.115 -38.674  1.00 37.07           C  
ATOM   7789  CD1 ILE    12     -87.101  25.226 -38.088  1.00 41.12           C  
ATOM   7790  N   ASN    13     -84.079  20.346 -37.047  1.00 40.63           N  
ATOM   7791  CA  ASN    13     -82.853  19.655 -37.434  1.00 42.33           C  
ATOM   7792  C   ASN    13     -82.896  19.247 -38.904  1.00 45.34           C  
ATOM   7793  O   ASN    13     -83.948  18.864 -39.422  1.00 47.47           O  
ATOM   7794  CB  ASN    13     -82.620  18.432 -36.552  1.00 40.33           C  
ATOM   7795  CG  ASN    13     -82.231  18.804 -35.141  1.00 41.17           C  
ATOM   7796  OD1 ASN    13     -83.081  18.895 -34.255  1.00 42.99           O  
ATOM   7797  ND2 ASN    13     -80.942  19.039 -34.925  1.00 36.69           N  
ATOM   7798  N   CYS    14     -81.753  19.358 -39.573  1.00 51.92           N  
ATOM   7799  CA  CYS    14     -81.608  18.893 -40.950  1.00 58.30           C  
ATOM   7800  C   CYS    14     -80.651  17.708 -40.975  1.00 63.16           C  
ATOM   7801  O   CYS    14     -79.557  17.774 -40.421  1.00 65.08           O  
ATOM   7802  CB  CYS    14     -81.105  20.020 -41.853  1.00 57.24           C  
ATOM   7803  SG  CYS    14     -82.207  21.455 -41.929  1.00 61.75           S  
ATOM   7804  N   GLY    15     -81.073  16.612 -41.593  1.00 71.49           N  
ATOM   7805  CA  GLY    15     -80.278  15.392 -41.572  1.00 79.04           C  
ATOM   7806  C   GLY    15     -80.256  14.637 -42.882  1.00 83.68           C  
ATOM   7807  O   GLY    15     -81.005  14.953 -43.807  1.00 81.70           O  
ATOM   7808  N   ILE    16     -79.385  13.635 -42.951  1.00 89.29           N  
ATOM   7809  CA  ILE    16     -79.296  12.768 -44.116  1.00 95.07           C  
ATOM   7810  C   ILE    16     -79.867  11.387 -43.785  1.00 97.80           C  
ATOM   7811  O   ILE    16     -79.246  10.598 -43.067  1.00101.91           O  
ATOM   7812  CB  ILE    16     -77.840  12.662 -44.659  1.00 95.61           C  
ATOM   7813  CG1 ILE    16     -77.255  14.058 -44.917  1.00 95.45           C  
ATOM   7814  CG2 ILE    16     -77.797  11.817 -45.936  1.00 97.89           C  
ATOM   7815  CD1 ILE    16     -75.734  14.100 -44.990  1.00 96.35           C  
ATOM   7816  N   GLN    17     -81.070  11.121 -44.289  1.00 99.86           N  
ATOM   7817  CA  GLN    17     -81.656   9.781 -44.248  1.00103.94           C  
ATOM   7818  C   GLN    17     -81.935   9.297 -45.671  1.00107.30           C  
ATOM   7819  O   GLN    17     -82.322  10.090 -46.537  1.00109.45           O  
ATOM   7820  CB  GLN    17     -82.913   9.730 -43.366  1.00103.97           C  
ATOM   7821  CG  GLN    17     -84.047  10.667 -43.776  1.00103.34           C  
ATOM   7822  CD  GLN    17     -85.227  10.643 -42.816  1.00103.34           C  
ATOM   7823  OE1 GLN    17     -86.325  11.077 -43.163  1.00101.58           O  
ATOM   7824  NE2 GLN    17     -85.007  10.138 -41.605  1.00103.62           N  
ATOM   7825  N   GLU    18     -81.735   7.993 -45.887  1.00109.68           N  
ATOM   7826  CA  GLU    18     -81.668   7.343 -47.222  1.00108.94           C  
ATOM   7827  C   GLU    18     -80.948   8.127 -48.341  1.00104.86           C  
ATOM   7828  O   GLU    18     -81.362   8.105 -49.506  1.00105.18           O  
ATOM   7829  CB  GLU    18     -83.026   6.751 -47.681  1.00110.74           C  
ATOM   7830  CG  GLU    18     -84.210   7.717 -47.825  1.00113.55           C  
ATOM   7831  CD  GLU    18     -85.104   7.762 -46.593  1.00119.58           C  
ATOM   7832  OE1 GLU    18     -84.621   7.489 -45.471  1.00119.83           O  
ATOM   7833  OE2 GLU    18     -86.303   8.075 -46.749  1.00123.72           O  
ATOM   7834  N   GLY    19     -79.866   8.811 -47.965  1.00 99.61           N  
ATOM   7835  CA  GLY    19     -79.063   9.610 -48.891  1.00 93.47           C  
ATOM   7836  C   GLY    19     -79.633  10.977 -49.231  1.00 89.20           C  
ATOM   7837  O   GLY    19     -79.123  11.659 -50.126  1.00 84.86           O  
ATOM   7838  N   LYS    20     -80.686  11.380 -48.519  1.00 87.80           N  
ATOM   7839  CA  LYS    20     -81.356  12.659 -48.774  1.00 85.31           C  
ATOM   7840  C   LYS    20     -81.306  13.652 -47.624  1.00 84.60           C  
ATOM   7841  O   LYS    20     -81.594  13.304 -46.478  1.00 83.32           O  
ATOM   7842  CB  LYS    20     -82.820  12.453 -49.188  1.00 82.26           C  
ATOM   7843  CG  LYS    20     -83.153  12.836 -50.629  1.00 80.18           C  
ATOM   7844  CD  LYS    20     -82.756  14.271 -50.990  1.00 79.88           C  
ATOM   7845  CE  LYS    20     -81.530  14.316 -51.907  1.00 71.59           C  
ATOM   7846  NZ  LYS    20     -81.177  15.696 -52.331  1.00 69.67           N  
ATOM   7847  N   LYS    21     -80.950  14.892 -47.957  1.00 84.11           N  
ATOM   7848  CA  LYS    21     -81.076  16.017 -47.038  1.00 83.87           C  
ATOM   7849  C   LYS    21     -82.556  16.337 -46.825  1.00 81.07           C  
ATOM   7850  O   LYS    21     -83.272  16.685 -47.769  1.00 86.07           O  
ATOM   7851  CB  LYS    21     -80.317  17.244 -47.569  1.00 87.63           C  
ATOM   7852  CG  LYS    21     -80.607  18.573 -46.838  1.00 91.25           C  
ATOM   7853  CD  LYS    21     -80.062  18.608 -45.407  1.00 91.27           C  
ATOM   7854  CE  LYS    21     -78.579  18.952 -45.370  1.00 92.40           C  
ATOM   7855  NZ  LYS    21     -78.069  19.024 -43.973  1.00 94.73           N  
ATOM   7856  N   VAL    22     -83.006  16.185 -45.583  1.00 75.46           N  
ATOM   7857  CA  VAL    22     -84.368  16.538 -45.195  1.00 66.54           C  
ATOM   7858  C   VAL    22     -84.341  17.350 -43.894  1.00 60.14           C  
ATOM   7859  O   VAL    22     -83.654  16.991 -42.932  1.00 50.69           O  
ATOM   7860  CB  VAL    22     -85.316  15.282 -45.129  1.00 69.02           C  
ATOM   7861  CG1 VAL    22     -84.927  14.316 -44.011  1.00 62.21           C  
ATOM   7862  CG2 VAL    22     -86.785  15.694 -45.009  1.00 75.37           C  
ATOM   7863  N   CYS    23     -85.051  18.474 -43.893  1.00 57.05           N  
ATOM   7864  CA  CYS    23     -85.160  19.292 -42.693  1.00 52.37           C  
ATOM   7865  C   CYS    23     -86.501  19.053 -42.026  1.00 48.74           C  
ATOM   7866  O   CYS    23     -87.550  19.124 -42.672  1.00 48.88           O  
ATOM   7867  CB  CYS    23     -84.960  20.774 -43.012  1.00 53.59           C  
ATOM   7868  SG  CYS    23     -83.302  21.159 -43.621  1.00 61.48           S  
ATOM   7869  N   PHE    24     -86.462  18.751 -40.734  1.00 47.22           N  
ATOM   7870  CA  PHE    24     -87.689  18.483 -39.991  1.00 45.34           C  
ATOM   7871  C   PHE    24     -87.883  19.369 -38.767  1.00 40.99           C  
ATOM   7872  O   PHE    24     -86.934  19.890 -38.181  1.00 37.69           O  
ATOM   7873  CB  PHE    24     -87.866  16.983 -39.669  1.00 47.46           C  
ATOM   7874  CG  PHE    24     -86.757  16.385 -38.850  1.00 53.18           C  
ATOM   7875  CD1 PHE    24     -86.894  16.249 -37.469  1.00 57.41           C  
ATOM   7876  CD2 PHE    24     -85.590  15.920 -39.458  1.00 56.07           C  
ATOM   7877  CE1 PHE    24     -85.877  15.680 -36.699  1.00 57.82           C  
ATOM   7878  CE2 PHE    24     -84.563  15.356 -38.702  1.00 61.34           C  
ATOM   7879  CZ  PHE    24     -84.707  15.235 -37.317  1.00 59.01           C  
ATOM   7880  N   MET    25     -89.150  19.526 -38.415  1.00 40.89           N  
ATOM   7881  CA  MET    25     -89.627  20.457 -37.417  1.00 37.14           C  
ATOM   7882  C   MET    25     -90.204  19.579 -36.318  1.00 36.34           C  
ATOM   7883  O   MET    25     -91.072  18.749 -36.595  1.00 35.61           O  
ATOM   7884  CB  MET    25     -90.745  21.248 -38.069  1.00 40.66           C  
ATOM   7885  CG  MET    25     -91.015  22.605 -37.554  1.00 41.74           C  
ATOM   7886  SD  MET    25     -92.447  23.209 -38.467  1.00 33.57           S  
ATOM   7887  CE  MET    25     -93.338  23.885 -37.087  1.00 29.70           C  
ATOM   7888  N   HIS    26     -89.737  19.742 -35.080  1.00 36.22           N  
ATOM   7889  CA  HIS    26     -90.155  18.821 -34.012  1.00 34.22           C  
ATOM   7890  C   HIS    26     -90.321  19.388 -32.595  1.00 34.68           C  
ATOM   7891  O   HIS    26     -89.727  20.411 -32.225  1.00 32.90           O  
ATOM   7892  CB  HIS    26     -89.268  17.565 -33.993  1.00 31.23           C  
ATOM   7893  CG  HIS    26     -87.822  17.849 -33.742  1.00 33.71           C  
ATOM   7894  ND1 HIS    26     -87.235  17.684 -32.506  1.00 37.09           N  
ATOM   7895  CD2 HIS    26     -86.845  18.296 -34.566  1.00 32.07           C  
ATOM   7896  CE1 HIS    26     -85.959  18.012 -32.580  1.00 36.78           C  
ATOM   7897  NE2 HIS    26     -85.697  18.388 -33.819  1.00 36.25           N  
ATOM   7898  N   ARG    27     -91.147  18.696 -31.815  1.00 34.90           N  
ATOM   7899  CA  ARG    27     -91.499  19.109 -30.464  1.00 35.60           C  
ATOM   7900  C   ARG    27     -91.845  17.880 -29.620  1.00 37.37           C  
ATOM   7901  O   ARG    27     -92.615  17.022 -30.055  1.00 37.78           O  
ATOM   7902  CB  ARG    27     -92.693  20.072 -30.515  1.00 34.68           C  
ATOM   7903  CG  ARG    27     -93.389  20.316 -29.183  1.00 32.93           C  
ATOM   7904  CD  ARG    27     -92.882  21.562 -28.499  1.00 34.97           C  
ATOM   7905  NE  ARG    27     -93.150  21.549 -27.062  1.00 35.70           N  
ATOM   7906  CZ  ARG    27     -92.237  21.777 -26.118  1.00 35.79           C  
ATOM   7907  NH1 ARG    27     -90.983  22.061 -26.446  1.00 35.35           N  
ATOM   7908  NH2 ARG    27     -92.584  21.734 -24.840  1.00 32.78           N  
ATOM   7909  N   GLN    28     -91.264  17.802 -28.424  1.00 39.12           N  
ATOM   7910  CA  GLN    28     -91.625  16.785 -27.438  1.00 39.03           C  
ATOM   7911  C   GLN    28     -92.318  17.425 -26.248  1.00 35.59           C  
ATOM   7912  O   GLN    28     -91.953  18.522 -25.819  1.00 36.00           O  
ATOM   7913  CB  GLN    28     -90.382  16.060 -26.928  1.00 37.97           C  
ATOM   7914  CG  GLN    28     -89.815  15.019 -27.865  1.00 50.79           C  
ATOM   7915  CD  GLN    28     -88.584  14.336 -27.295  1.00 51.82           C  
ATOM   7916  OE1 GLN    28     -87.931  14.854 -26.380  1.00 48.50           O  
ATOM   7917  NE2 GLN    28     -88.258  13.163 -27.836  1.00 56.54           N  
ATOM   7918  N   GLU    29     -93.310  16.727 -25.706  1.00 34.54           N  
ATOM   7919  CA  GLU    29     -93.924  17.138 -24.452  1.00 36.76           C  
ATOM   7920  C   GLU    29     -93.641  16.119 -23.352  1.00 37.73           C  
ATOM   7921  O   GLU    29     -93.732  14.906 -23.576  1.00 36.19           O  
ATOM   7922  CB  GLU    29     -95.432  17.367 -24.605  1.00 38.13           C  
ATOM   7923  CG  GLU    29     -95.845  18.263 -25.776  1.00 38.36           C  
ATOM   7924  CD  GLU    29     -95.494  19.736 -25.598  1.00 42.52           C  
ATOM   7925  OE1 GLU    29     -95.164  20.170 -24.475  1.00 47.87           O  
ATOM   7926  OE2 GLU    29     -95.559  20.472 -26.602  1.00 44.00           O  
ATOM   7927  N   VAL    30     -93.284  16.629 -22.172  1.00 39.11           N  
ATOM   7928  CA  VAL    30     -92.918  15.794 -21.024  1.00 38.76           C  
ATOM   7929  C   VAL    30     -93.876  15.994 -19.843  1.00 40.55           C  
ATOM   7930  O   VAL    30     -94.572  17.009 -19.767  1.00 40.75           O  
ATOM   7931  CB  VAL    30     -91.444  16.041 -20.568  1.00 36.91           C  
ATOM   7932  CG1 VAL    30     -90.460  15.709 -21.687  1.00 33.10           C  
ATOM   7933  CG2 VAL    30     -91.237  17.483 -20.087  1.00 35.14           C  
ATOM   7934  N   ASN    31     -93.917  15.016 -18.939  1.00 43.33           N  
ATOM   7935  CA  ASN    31     -94.651  15.160 -17.681  1.00 43.25           C  
ATOM   7936  C   ASN    31     -93.779  15.766 -16.584  1.00 47.22           C  
ATOM   7937  O   ASN    31     -92.674  16.237 -16.865  1.00 47.32           O  
ATOM   7938  CB  ASN    31     -95.294  13.832 -17.233  1.00 43.59           C  
ATOM   7939  CG  ASN    31     -94.288  12.688 -17.073  1.00 43.57           C  
ATOM   7940  OD1 ASN    31     -93.078  12.894 -16.971  1.00 49.89           O  
ATOM   7941  ND2 ASN    31     -94.803  11.466 -17.049  1.00 39.28           N  
ATOM   7942  N   ASP    32     -94.274  15.749 -15.343  1.00 52.63           N  
ATOM   7943  CA  ASP    32     -93.516  16.253 -14.183  1.00 58.15           C  
ATOM   7944  C   ASP    32     -92.281  15.415 -13.813  1.00 58.15           C  
ATOM   7945  O   ASP    32     -91.374  15.908 -13.142  1.00 58.05           O  
ATOM   7946  CB  ASP    32     -94.427  16.458 -12.960  1.00 63.77           C  
ATOM   7947  CG  ASP    32     -95.443  15.332 -12.767  1.00 76.42           C  
ATOM   7948  OD1 ASP    32     -95.134  14.158 -13.075  1.00 83.20           O  
ATOM   7949  OD2 ASP    32     -96.559  15.631 -12.288  1.00 85.45           O  
ATOM   7950  N   GLN    33     -92.253  14.159 -14.264  1.00 60.15           N  
ATOM   7951  CA  GLN    33     -91.095  13.270 -14.084  1.00 60.41           C  
ATOM   7952  C   GLN    33     -90.101  13.388 -15.240  1.00 60.28           C  
ATOM   7953  O   GLN    33     -89.128  12.631 -15.309  1.00 63.82           O  
ATOM   7954  CB  GLN    33     -91.542  11.809 -13.928  1.00 58.58           C  
ATOM   7955  CG  GLN    33     -92.418  11.530 -12.707  1.00 67.98           C  
ATOM   7956  CD  GLN    33     -91.759  11.932 -11.396  1.00 76.84           C  
ATOM   7957  OE1 GLN    33     -92.246  12.817 -10.691  1.00 77.72           O  
ATOM   7958  NE2 GLN    33     -90.641  11.290 -11.069  1.00 78.90           N  
ATOM   7959  N   ASN    34     -90.371  14.333 -16.142  1.00 56.72           N  
ATOM   7960  CA  ASN    34     -89.528  14.644 -17.307  1.00 57.64           C  
ATOM   7961  C   ASN    34     -89.388  13.517 -18.343  1.00 53.14           C  
ATOM   7962  O   ASN    34     -88.394  13.450 -19.064  1.00 54.45           O  
ATOM   7963  CB  ASN    34     -88.152  15.190 -16.875  1.00 63.11           C  
ATOM   7964  CG  ASN    34     -87.574  16.183 -17.871  1.00 73.48           C  
ATOM   7965  OD1 ASN    34     -88.079  17.298 -18.021  1.00 82.99           O  
ATOM   7966  ND2 ASN    34     -86.505  15.782 -18.552  1.00 71.05           N  
ATOM   7967  N   ARG    35     -90.384  12.638 -18.426  1.00 50.00           N  
ATOM   7968  CA  ARG    35     -90.399  11.638 -19.493  1.00 52.19           C  
ATOM   7969  C   ARG    35     -91.392  12.000 -20.607  1.00 49.40           C  
ATOM   7970  O   ARG    35     -92.459  12.566 -20.351  1.00 46.47           O  
ATOM   7971  CB  ARG    35     -90.621  10.214 -18.955  1.00 54.38           C  
ATOM   7972  CG  ARG    35     -92.008   9.913 -18.435  1.00 63.48           C  
ATOM   7973  CD  ARG    35     -92.314   8.431 -18.562  1.00 72.96           C  
ATOM   7974  NE  ARG    35     -93.747   8.174 -18.460  1.00 81.89           N  
ATOM   7975  CZ  ARG    35     -94.569   7.959 -19.487  1.00 85.10           C  
ATOM   7976  NH1 ARG    35     -94.122   7.945 -20.737  1.00 84.71           N  
ATOM   7977  NH2 ARG    35     -95.855   7.748 -19.252  1.00 85.00           N  
ATOM   7978  N   VAL    36     -91.016  11.665 -21.839  1.00 46.28           N  
ATOM   7979  CA  VAL    36     -91.781  12.021 -23.036  1.00 43.64           C  
ATOM   7980  C   VAL    36     -93.111  11.271 -23.099  1.00 43.57           C  
ATOM   7981  O   VAL    36     -93.145  10.043 -23.052  1.00 45.58           O  
ATOM   7982  CB  VAL    36     -90.946  11.794 -24.329  1.00 43.77           C  
ATOM   7983  CG1 VAL    36     -91.721  12.214 -25.571  1.00 40.76           C  
ATOM   7984  CG2 VAL    36     -89.632  12.564 -24.252  1.00 43.73           C  
ATOM   7985  N   VAL    37     -94.199  12.032 -23.190  1.00 42.93           N  
ATOM   7986  CA  VAL    37     -95.549  11.475 -23.274  1.00 42.32           C  
ATOM   7987  C   VAL    37     -96.081  11.586 -24.705  1.00 43.22           C  
ATOM   7988  O   VAL    37     -96.640  10.634 -25.249  1.00 45.11           O  
ATOM   7989  CB  VAL    37     -96.511  12.177 -22.282  1.00 41.41           C  
ATOM   7990  CG1 VAL    37     -97.901  11.548 -22.323  1.00 44.11           C  
ATOM   7991  CG2 VAL    37     -95.952  12.127 -20.860  1.00 41.25           C  
ATOM   7992  N   VAL    38     -95.891  12.752 -25.312  1.00 42.01           N  
ATOM   7993  CA  VAL    38     -96.311  12.978 -26.691  1.00 44.83           C  
ATOM   7994  C   VAL    38     -95.192  13.689 -27.472  1.00 39.42           C  
ATOM   7995  O   VAL    38     -94.454  14.503 -26.911  1.00 42.68           O  
ATOM   7996  CB  VAL    38     -97.733  13.666 -26.765  1.00 47.06           C  
ATOM   7997  CG1 VAL    38     -97.745  15.019 -26.108  1.00 49.87           C  
ATOM   7998  CG2 VAL    38     -98.250  13.765 -28.184  1.00 54.30           C  
ATOM   7999  N   ALA    39     -95.029  13.324 -28.742  1.00 39.00           N  
ATOM   8000  CA  ALA    39     -94.053  13.963 -29.619  1.00 36.49           C  
ATOM   8001  C   ALA    39     -94.664  14.211 -30.995  1.00 40.04           C  
ATOM   8002  O   ALA    39     -95.598  13.516 -31.405  1.00 41.01           O  
ATOM   8003  CB  ALA    39     -92.787  13.106 -29.733  1.00 33.14           C  
ATOM   8004  N   MET    40     -94.135  15.209 -31.698  1.00 39.36           N  
ATOM   8005  CA  MET    40     -94.594  15.548 -33.040  1.00 37.36           C  
ATOM   8006  C   MET    40     -93.396  15.917 -33.903  1.00 36.61           C  
ATOM   8007  O   MET    40     -92.546  16.694 -33.484  1.00 38.65           O  
ATOM   8008  CB  MET    40     -95.604  16.701 -32.982  1.00 35.72           C  
ATOM   8009  CG  MET    40     -96.020  17.272 -34.336  1.00 44.41           C  
ATOM   8010  SD  MET    40     -97.527  18.253 -34.261  1.00 43.34           S  
ATOM   8011  CE  MET    40     -98.734  16.944 -34.198  1.00 57.38           C  
ATOM   8012  N   SER    41     -93.328  15.329 -35.095  1.00 38.59           N  
ATOM   8013  CA  SER    41     -92.282  15.642 -36.068  1.00 39.90           C  
ATOM   8014  C   SER    41     -92.924  15.923 -37.423  1.00 42.42           C  
ATOM   8015  O   SER    41     -93.814  15.194 -37.858  1.00 44.66           O  
ATOM   8016  CB  SER    41     -91.275  14.497 -36.171  1.00 38.92           C  
ATOM   8017  OG  SER    41     -90.050  14.948 -36.720  1.00 45.02           O  
ATOM   8018  N   VAL    42     -92.465  16.980 -38.084  1.00 43.27           N  
ATOM   8019  CA  VAL    42     -93.147  17.520 -39.258  1.00 43.16           C  
ATOM   8020  C   VAL    42     -92.174  17.983 -40.359  1.00 42.78           C  
ATOM   8021  O   VAL    42     -91.132  18.582 -40.069  1.00 41.02           O  
ATOM   8022  CB  VAL    42     -94.163  18.624 -38.813  1.00 45.42           C  
ATOM   8023  CG1 VAL    42     -94.091  19.877 -39.667  1.00 47.71           C  
ATOM   8024  CG2 VAL    42     -95.576  18.055 -38.765  1.00 50.61           C  
ATOM   8025  N   VAL    43     -92.503  17.669 -41.615  1.00 44.23           N  
ATOM   8026  CA  VAL    43     -91.737  18.158 -42.773  1.00 45.03           C  
ATOM   8027  C   VAL    43     -92.593  19.010 -43.711  1.00 47.46           C  
ATOM   8028  O   VAL    43     -93.827  18.887 -43.743  1.00 45.91           O  
ATOM   8029  CB  VAL    43     -91.058  17.017 -43.599  1.00 45.82           C  
ATOM   8030  CG1 VAL    43     -89.978  16.311 -42.785  1.00 47.96           C  
ATOM   8031  CG2 VAL    43     -92.085  16.022 -44.131  1.00 44.05           C  
ATOM   8032  N   LEU    44     -91.923  19.882 -44.461  1.00 48.25           N  
ATOM   8033  CA  LEU    44     -92.552  20.638 -45.533  1.00 49.20           C  
ATOM   8034  C   LEU    44     -92.233  19.926 -46.840  1.00 50.17           C  
ATOM   8035  O   LEU    44     -91.069  19.834 -47.241  1.00 48.59           O  
ATOM   8036  CB  LEU    44     -92.007  22.069 -45.574  1.00 50.42           C  
ATOM   8037  CG  LEU    44     -92.858  23.273 -46.005  1.00 51.57           C  
ATOM   8038  CD1 LEU    44     -92.022  24.181 -46.886  1.00 48.17           C  
ATOM   8039  CD2 LEU    44     -94.179  22.925 -46.686  1.00 53.02           C  
ATOM   8040  N   ASN    45     -93.269  19.405 -47.490  1.00 53.56           N  
ATOM   8041  CA  ASN    45     -93.105  18.705 -48.759  1.00 60.61           C  
ATOM   8042  C   ASN    45     -92.953  19.682 -49.926  1.00 61.95           C  
ATOM   8043  O   ASN    45     -93.225  20.880 -49.780  1.00 62.94           O  
ATOM   8044  CB  ASN    45     -94.268  17.736 -48.991  1.00 61.44           C  
ATOM   8045  CG  ASN    45     -94.318  16.625 -47.955  1.00 61.88           C  
ATOM   8046  OD1 ASN    45     -93.560  15.656 -48.027  1.00 64.24           O  
ATOM   8047  ND2 ASN    45     -95.216  16.760 -46.986  1.00 54.93           N  
ATOM   8048  N   ALA    46     -92.519  19.160 -51.073  1.00 67.68           N  
ATOM   8049  CA  ALA    46     -92.230  19.965 -52.270  1.00 72.47           C  
ATOM   8050  C   ALA    46     -93.438  20.734 -52.823  1.00 71.74           C  
ATOM   8051  O   ALA    46     -93.283  21.830 -53.370  1.00 64.68           O  
ATOM   8052  CB  ALA    46     -91.609  19.090 -53.357  1.00 71.52           C  
ATOM   8053  N   ASP    47     -94.630  20.158 -52.664  1.00 76.25           N  
ATOM   8054  CA  ASP    47     -95.876  20.788 -53.116  1.00 81.64           C  
ATOM   8055  C   ASP    47     -96.438  21.812 -52.121  1.00 80.37           C  
ATOM   8056  O   ASP    47     -97.388  22.535 -52.433  1.00 83.42           O  
ATOM   8057  CB  ASP    47     -96.933  19.726 -53.454  1.00 83.20           C  
ATOM   8058  CG  ASP    47     -97.331  18.887 -52.253  1.00 89.84           C  
ATOM   8059  OD1 ASP    47     -96.480  18.135 -51.726  1.00 88.83           O  
ATOM   8060  OD2 ASP    47     -98.509  18.972 -51.847  1.00 94.11           O  
ATOM   8061  N   GLY    48     -95.851  21.869 -50.928  1.00 78.39           N  
ATOM   8062  CA  GLY    48     -96.258  22.836 -49.913  1.00 75.66           C  
ATOM   8063  C   GLY    48     -97.114  22.258 -48.802  1.00 74.27           C  
ATOM   8064  O   GLY    48     -97.499  22.977 -47.874  1.00 73.74           O  
ATOM   8065  N   VAL    49     -97.419  20.963 -48.893  1.00 70.95           N  
ATOM   8066  CA  VAL    49     -98.200  20.284 -47.858  1.00 66.91           C  
ATOM   8067  C   VAL    49     -97.320  19.964 -46.637  1.00 61.43           C  
ATOM   8068  O   VAL    49     -96.161  19.555 -46.773  1.00 59.04           O  
ATOM   8069  CB  VAL    49     -98.986  19.037 -48.419  1.00 70.53           C  
ATOM   8070  CG1 VAL    49     -98.077  17.831 -48.676  1.00 70.34           C  
ATOM   8071  CG2 VAL    49    -100.136  18.653 -47.503  1.00 72.21           C  
ATOM   8072  N   VAL    50     -97.867  20.205 -45.449  1.00 55.18           N  
ATOM   8073  CA  VAL    50     -97.165  19.942 -44.198  1.00 51.62           C  
ATOM   8074  C   VAL    50     -97.600  18.579 -43.655  1.00 50.09           C  
ATOM   8075  O   VAL    50     -98.779  18.360 -43.366  1.00 49.43           O  
ATOM   8076  CB  VAL    50     -97.396  21.082 -43.168  1.00 54.49           C  
ATOM   8077  CG1 VAL    50     -96.922  20.691 -41.780  1.00 51.97           C  
ATOM   8078  CG2 VAL    50     -96.696  22.361 -43.622  1.00 58.52           C  
ATOM   8079  N   SER    51     -96.642  17.662 -43.546  1.00 46.60           N  
ATOM   8080  CA  SER    51     -96.927  16.305 -43.098  1.00 46.78           C  
ATOM   8081  C   SER    51     -95.855  15.764 -42.153  1.00 45.98           C  
ATOM   8082  O   SER    51     -94.767  16.326 -42.041  1.00 47.23           O  
ATOM   8083  CB  SER    51     -97.097  15.362 -44.297  1.00 46.56           C  
ATOM   8084  OG  SER    51     -95.844  15.036 -44.878  1.00 47.27           O  
ATOM   8085  N   GLY    52     -96.178  14.667 -41.478  1.00 45.55           N  
ATOM   8086  CA  GLY    52     -95.223  13.985 -40.616  1.00 43.07           C  
ATOM   8087  C   GLY    52     -95.883  12.979 -39.699  1.00 43.98           C  
ATOM   8088  O   GLY    52     -96.833  12.294 -40.090  1.00 43.52           O  
ATOM   8089  N   ASN    53     -95.381  12.902 -38.469  1.00 43.90           N  
ATOM   8090  CA  ASN    53     -95.834  11.907 -37.504  1.00 40.61           C  
ATOM   8091  C   ASN    53     -96.062  12.463 -36.107  1.00 39.65           C  
ATOM   8092  O   ASN    53     -95.329  13.336 -35.638  1.00 40.08           O  
ATOM   8093  CB  ASN    53     -94.838  10.745 -37.431  1.00 41.51           C  
ATOM   8094  CG  ASN    53     -94.871   9.867 -38.667  1.00 47.13           C  
ATOM   8095  OD1 ASN    53     -95.901   9.287 -39.005  1.00 50.75           O  
ATOM   8096  ND2 ASN    53     -93.738   9.759 -39.343  1.00 49.89           N  
ATOM   8097  N   LEU    54     -97.097  11.938 -35.462  1.00 37.37           N  
ATOM   8098  CA  LEU    54     -97.386  12.191 -34.062  1.00 38.77           C  
ATOM   8099  C   LEU    54     -97.122  10.899 -33.277  1.00 38.50           C  
ATOM   8100  O   LEU    54     -97.566   9.821 -33.675  1.00 39.47           O  
ATOM   8101  CB  LEU    54     -98.845  12.642 -33.919  1.00 40.65           C  
ATOM   8102  CG  LEU    54     -99.498  12.858 -32.553  1.00 48.06           C  
ATOM   8103  CD1 LEU    54     -98.949  14.092 -31.861  1.00 52.48           C  
ATOM   8104  CD2 LEU    54    -101.005  12.973 -32.727  1.00 43.73           C  
ATOM   8105  N   THR    55     -96.378  11.010 -32.180  1.00 39.30           N  
ATOM   8106  CA  THR    55     -96.126   9.865 -31.304  1.00 39.91           C  
ATOM   8107  C   THR    55     -96.993   9.965 -30.053  1.00 40.74           C  
ATOM   8108  O   THR    55     -96.873  10.912 -29.277  1.00 41.61           O  
ATOM   8109  CB  THR    55     -94.633   9.737 -30.907  1.00 41.37           C  
ATOM   8110  OG1 THR    55     -93.816   9.773 -32.083  1.00 45.21           O  
ATOM   8111  CG2 THR    55     -94.383   8.421 -30.165  1.00 38.83           C  
ATOM   8112  N   VAL    56     -97.865   8.980 -29.871  1.00 41.74           N  
ATOM   8113  CA  VAL    56     -98.785   8.946 -28.740  1.00 39.47           C  
ATOM   8114  C   VAL    56     -98.411   7.781 -27.797  1.00 40.99           C  
ATOM   8115  O   VAL    56     -97.630   6.910 -28.194  1.00 39.59           O  
ATOM   8116  CB  VAL    56    -100.268   8.874 -29.224  1.00 39.38           C  
ATOM   8117  CG1 VAL    56    -100.628  10.107 -30.044  1.00 38.86           C  
ATOM   8118  CG2 VAL    56    -100.544   7.595 -30.007  1.00 36.61           C  
ATOM   8119  N   PRO    57     -98.932   7.774 -26.543  1.00 40.92           N  
ATOM   8120  CA  PRO    57     -98.623   6.686 -25.603  1.00 40.34           C  
ATOM   8121  C   PRO    57     -99.085   5.286 -26.011  1.00 39.91           C  
ATOM   8122  O   PRO    57     -99.891   5.127 -26.932  1.00 41.60           O  
ATOM   8123  CB  PRO    57     -99.368   7.101 -24.325  1.00 40.00           C  
ATOM   8124  CG  PRO    57     -99.582   8.555 -24.455  1.00 39.77           C  
ATOM   8125  CD  PRO    57     -99.794   8.790 -25.906  1.00 37.98           C  
ATOM   8126  N   PHE    58     -98.547   4.284 -25.316  1.00 39.09           N  
ATOM   8127  CA  PHE    58     -99.014   2.905 -25.401  1.00 36.94           C  
ATOM   8128  C   PHE    58    -100.369   2.794 -24.711  1.00 38.40           C  
ATOM   8129  O   PHE    58    -100.719   3.639 -23.889  1.00 39.49           O  
ATOM   8130  CB  PHE    58     -98.033   1.968 -24.691  1.00 36.65           C  
ATOM   8131  CG  PHE    58     -96.719   1.777 -25.406  1.00 37.29           C  
ATOM   8132  CD1 PHE    58     -96.674   1.317 -26.721  1.00 32.46           C  
ATOM   8133  CD2 PHE    58     -95.525   2.011 -24.740  1.00 36.17           C  
ATOM   8134  CE1 PHE    58     -95.456   1.124 -27.365  1.00 30.64           C  
ATOM   8135  CE2 PHE    58     -94.301   1.820 -25.375  1.00 36.39           C  
ATOM   8136  CZ  PHE    58     -94.265   1.374 -26.687  1.00 33.57           C  
ATOM   8137  N   GLY    59    -101.122   1.746 -25.033  1.00 38.02           N  
ATOM   8138  CA  GLY    59    -102.386   1.476 -24.353  1.00 38.64           C  
ATOM   8139  C   GLY    59    -103.588   2.148 -24.991  1.00 40.57           C  
ATOM   8140  O   GLY    59    -104.689   2.114 -24.437  1.00 41.45           O  
ATOM   8141  N   ILE    60    -103.373   2.751 -26.159  1.00 39.42           N  
ATOM   8142  CA  ILE    60    -104.424   3.446 -26.893  1.00 38.65           C  
ATOM   8143  C   ILE    60    -105.140   2.452 -27.794  1.00 39.98           C  
ATOM   8144  O   ILE    60    -104.493   1.652 -28.471  1.00 42.85           O  
ATOM   8145  CB  ILE    60    -103.848   4.646 -27.724  1.00 38.15           C  
ATOM   8146  CG1 ILE    60    -103.155   5.668 -26.813  1.00 35.54           C  
ATOM   8147  CG2 ILE    60    -104.926   5.336 -28.572  1.00 36.48           C  
ATOM   8148  CD1 ILE    60    -103.977   6.131 -25.609  1.00 40.32           C  
ATOM   8149  N   LEU    61    -106.473   2.500 -27.777  1.00 40.96           N  
ATOM   8150  CA  LEU    61    -107.313   1.695 -28.658  1.00 41.73           C  
ATOM   8151  C   LEU    61    -107.102   2.086 -30.115  1.00 43.74           C  
ATOM   8152  O   LEU    61    -107.481   3.174 -30.556  1.00 45.62           O  
ATOM   8153  CB  LEU    61    -108.791   1.801 -28.261  1.00 43.12           C  
ATOM   8154  CG  LEU    61    -109.809   0.889 -28.954  1.00 47.01           C  
ATOM   8155  CD1 LEU    61    -109.384  -0.574 -28.917  1.00 46.29           C  
ATOM   8156  CD2 LEU    61    -111.168   1.062 -28.305  1.00 48.24           C  
ATOM   8157  N   VAL    62    -106.482   1.158 -30.833  1.00 45.81           N  
ATOM   8158  CA  VAL    62    -106.000   1.327 -32.199  1.00 46.43           C  
ATOM   8159  C   VAL    62    -107.124   1.393 -33.254  1.00 49.99           C  
ATOM   8160  O   VAL    62    -106.973   2.042 -34.297  1.00 49.86           O  
ATOM   8161  CB  VAL    62    -104.952   0.203 -32.488  1.00 47.63           C  
ATOM   8162  CG1 VAL    62    -105.276  -0.618 -33.727  1.00 44.38           C  
ATOM   8163  CG2 VAL    62    -103.540   0.753 -32.479  1.00 43.08           C  
ATOM   8164  N   SER    63    -108.252   0.744 -32.963  1.00 52.24           N  
ATOM   8165  CA  SER    63    -109.386   0.694 -33.888  1.00 55.22           C  
ATOM   8166  C   SER    63    -110.231   1.973 -33.879  1.00 55.13           C  
ATOM   8167  O   SER    63    -110.996   2.225 -34.813  1.00 56.93           O  
ATOM   8168  CB  SER    63    -110.260  -0.534 -33.604  1.00 56.41           C  
ATOM   8169  OG  SER    63    -110.703  -0.554 -32.259  1.00 58.82           O  
ATOM   8170  N   LYS    64    -110.087   2.770 -32.823  1.00 54.64           N  
ATOM   8171  CA  LYS    64    -110.773   4.056 -32.702  1.00 54.80           C  
ATOM   8172  C   LYS    64    -109.828   5.216 -33.061  1.00 55.37           C  
ATOM   8173  O   LYS    64    -108.627   5.136 -32.792  1.00 54.67           O  
ATOM   8174  CB  LYS    64    -111.362   4.217 -31.295  1.00 55.30           C  
ATOM   8175  CG  LYS    64    -112.561   3.308 -31.037  1.00 63.31           C  
ATOM   8176  CD  LYS    64    -113.400   3.779 -29.855  1.00 78.37           C  
ATOM   8177  CE  LYS    64    -114.502   4.741 -30.289  1.00 85.91           C  
ATOM   8178  NZ  LYS    64    -115.560   4.064 -31.097  1.00 90.27           N  
ATOM   8179  N   PRO    65    -110.364   6.296 -33.674  1.00 55.58           N  
ATOM   8180  CA  PRO    65    -109.497   7.330 -34.247  1.00 52.60           C  
ATOM   8181  C   PRO    65    -108.828   8.256 -33.237  1.00 49.82           C  
ATOM   8182  O   PRO    65    -109.250   8.339 -32.083  1.00 48.16           O  
ATOM   8183  CB  PRO    65    -110.454   8.155 -35.122  1.00 54.13           C  
ATOM   8184  CG  PRO    65    -111.767   7.441 -35.107  1.00 56.65           C  
ATOM   8185  CD  PRO    65    -111.788   6.625 -33.873  1.00 55.49           C  
ATOM   8186  N   VAL    66    -107.782   8.940 -33.696  1.00 46.27           N  
ATOM   8187  CA  VAL    66    -107.118   9.997 -32.944  1.00 44.24           C  
ATOM   8188  C   VAL    66    -107.577  11.331 -33.533  1.00 46.00           C  
ATOM   8189  O   VAL    66    -107.417  11.587 -34.731  1.00 43.01           O  
ATOM   8190  CB  VAL    66    -105.565   9.870 -33.002  1.00 42.88           C  
ATOM   8191  CG1 VAL    66    -104.891  11.013 -32.249  1.00 35.13           C  
ATOM   8192  CG2 VAL    66    -105.110   8.531 -32.428  1.00 35.10           C  
ATOM   8193  N   ARG    67    -108.167  12.164 -32.684  1.00 48.36           N  
ATOM   8194  CA  ARG    67    -108.753  13.427 -33.112  1.00 53.92           C  
ATOM   8195  C   ARG    67    -107.820  14.591 -32.793  1.00 49.32           C  
ATOM   8196  O   ARG    67    -107.342  14.724 -31.667  1.00 48.15           O  
ATOM   8197  CB  ARG    67    -110.116  13.618 -32.440  1.00 58.21           C  
ATOM   8198  CG  ARG    67    -110.978  14.714 -33.038  1.00 66.31           C  
ATOM   8199  CD  ARG    67    -112.314  14.790 -32.317  1.00 73.54           C  
ATOM   8200  NE  ARG    67    -112.903  16.125 -32.388  1.00 80.28           N  
ATOM   8201  CZ  ARG    67    -112.664  17.103 -31.518  1.00 86.09           C  
ATOM   8202  NH1 ARG    67    -111.839  16.912 -30.494  1.00 80.35           N  
ATOM   8203  NH2 ARG    67    -113.252  18.282 -31.672  1.00 91.87           N  
ATOM   8204  N   LEU    68    -107.562  15.424 -33.795  1.00 49.12           N  
ATOM   8205  CA  LEU    68    -106.675  16.571 -33.647  1.00 49.18           C  
ATOM   8206  C   LEU    68    -107.459  17.867 -33.811  1.00 49.62           C  
ATOM   8207  O   LEU    68    -108.159  18.051 -34.804  1.00 48.56           O  
ATOM   8208  CB  LEU    68    -105.534  16.513 -34.671  1.00 49.41           C  
ATOM   8209  CG  LEU    68    -104.300  15.649 -34.391  1.00 49.62           C  
ATOM   8210  CD1 LEU    68    -104.533  14.193 -34.745  1.00 50.08           C  
ATOM   8211  CD2 LEU    68    -103.119  16.188 -35.170  1.00 55.46           C  
ATOM   8212  N   GLN    69    -107.330  18.764 -32.839  1.00 48.75           N  
ATOM   8213  CA  GLN    69    -108.055  20.028 -32.864  1.00 49.66           C  
ATOM   8214  C   GLN    69    -107.172  21.176 -32.386  1.00 47.73           C  
ATOM   8215  O   GLN    69    -106.540  21.078 -31.335  1.00 45.89           O  
ATOM   8216  CB  GLN    69    -109.320  19.936 -32.002  1.00 49.58           C  
ATOM   8217  CG  GLN    69    -110.243  21.150 -32.100  1.00 56.24           C  
ATOM   8218  CD  GLN    69    -111.428  21.082 -31.147  1.00 57.65           C  
ATOM   8219  OE1 GLN    69    -111.413  20.341 -30.165  1.00 61.51           O  
ATOM   8220  NE2 GLN    69    -112.460  21.865 -31.434  1.00 63.23           N  
ATOM   8221  N   VAL    70    -107.132  22.258 -33.162  1.00 46.79           N  
ATOM   8222  CA  VAL    70    -106.425  23.465 -32.744  1.00 45.63           C  
ATOM   8223  C   VAL    70    -107.314  24.237 -31.771  1.00 50.88           C  
ATOM   8224  O   VAL    70    -108.377  24.738 -32.157  1.00 51.95           O  
ATOM   8225  CB  VAL    70    -106.029  24.367 -33.933  1.00 44.32           C  
ATOM   8226  CG1 VAL    70    -105.031  25.425 -33.477  1.00 41.51           C  
ATOM   8227  CG2 VAL    70    -105.442  23.542 -35.065  1.00 37.72           C  
ATOM   8228  N   ASP    71    -106.859  24.307 -30.517  1.00 57.99           N  
ATOM   8229  CA  ASP    71    -107.581  24.923 -29.392  1.00 60.52           C  
ATOM   8230  C   ASP    71    -109.024  24.421 -29.270  1.00 61.83           C  
ATOM   8231  O   ASP    71    -109.254  23.219 -29.136  1.00 62.03           O  
ATOM   8232  CB  ASP    71    -107.508  26.457 -29.463  1.00 62.89           C  
ATOM   8233  CG  ASP    71    -106.079  26.981 -29.403  1.00 69.66           C  
ATOM   8234  OD1 ASP    71    -105.280  26.458 -28.597  1.00 66.80           O  
ATOM   8235  OD2 ASP    71    -105.759  27.927 -30.157  1.00 74.25           O  
ATOM   8236  N   GLU    72    -109.986  25.336 -29.324  1.00 67.01           N  
ATOM   8237  CA  GLU    72    -111.397  24.967 -29.370  1.00 69.33           C  
ATOM   8238  C   GLU    72    -112.042  25.472 -30.658  1.00 67.56           C  
ATOM   8239  O   GLU    72    -113.250  25.704 -30.716  1.00 69.21           O  
ATOM   8240  CB  GLU    72    -112.128  25.476 -28.127  1.00 72.79           C  
ATOM   8241  CG  GLU    72    -111.884  24.613 -26.893  1.00 84.26           C  
ATOM   8242  CD  GLU    72    -112.101  25.361 -25.594  1.00 95.67           C  
ATOM   8243  OE1 GLU    72    -111.532  26.464 -25.436  1.00100.41           O  
ATOM   8244  OE2 GLU    72    -112.831  24.839 -24.724  1.00 98.92           O  
ATOM   8245  N   GLY    73    -111.215  25.616 -31.691  1.00 67.67           N  
ATOM   8246  CA  GLY    73    -111.646  26.110 -32.993  1.00 68.92           C  
ATOM   8247  C   GLY    73    -112.233  25.051 -33.907  1.00 68.85           C  
ATOM   8248  O   GLY    73    -112.516  23.929 -33.484  1.00 66.45           O  
ATOM   8249  N   LYS    74    -112.392  25.420 -35.175  1.00 73.69           N  
ATOM   8250  CA  LYS    74    -113.137  24.626 -36.153  1.00 76.53           C  
ATOM   8251  C   LYS    74    -112.253  23.676 -36.967  1.00 75.07           C  
ATOM   8252  O   LYS    74    -112.757  22.896 -37.783  1.00 74.22           O  
ATOM   8253  CB  LYS    74    -113.920  25.556 -37.090  1.00 81.61           C  
ATOM   8254  CG  LYS    74    -114.897  26.494 -36.380  1.00 88.45           C  
ATOM   8255  CD  LYS    74    -115.299  27.663 -37.273  1.00 94.43           C  
ATOM   8256  CE  LYS    74    -116.285  28.596 -36.579  1.00 94.31           C  
ATOM   8257  NZ  LYS    74    -117.639  27.985 -36.428  1.00 96.16           N  
ATOM   8258  N   ALA    75    -110.943  23.746 -36.739  1.00 73.41           N  
ATOM   8259  CA  ALA    75    -109.978  22.892 -37.434  1.00 69.88           C  
ATOM   8260  C   ALA    75    -109.856  21.516 -36.768  1.00 67.42           C  
ATOM   8261  O   ALA    75    -109.128  21.353 -35.782  1.00 65.58           O  
ATOM   8262  CB  ALA    75    -108.621  23.581 -37.510  1.00 70.25           C  
ATOM   8263  N   VAL    76    -110.579  20.535 -37.311  1.00 60.66           N  
ATOM   8264  CA  VAL    76    -110.595  19.175 -36.765  1.00 59.27           C  
ATOM   8265  C   VAL    76    -110.114  18.142 -37.797  1.00 59.79           C  
ATOM   8266  O   VAL    76    -110.641  18.064 -38.908  1.00 60.59           O  
ATOM   8267  CB  VAL    76    -111.999  18.791 -36.193  1.00 58.84           C  
ATOM   8268  CG1 VAL    76    -112.044  17.324 -35.750  1.00 59.68           C  
ATOM   8269  CG2 VAL    76    -112.380  19.697 -35.023  1.00 57.82           C  
ATOM   8270  N   ILE    77    -109.096  17.371 -37.417  1.00 58.69           N  
ATOM   8271  CA  ILE    77    -108.611  16.242 -38.207  1.00 59.27           C  
ATOM   8272  C   ILE    77    -108.860  14.942 -37.441  1.00 57.23           C  
ATOM   8273  O   ILE    77    -108.650  14.878 -36.228  1.00 54.63           O  
ATOM   8274  CB  ILE    77    -107.106  16.413 -38.573  1.00 60.42           C  
ATOM   8275  CG1 ILE    77    -106.971  17.218 -39.864  1.00 62.03           C  
ATOM   8276  CG2 ILE    77    -106.384  15.063 -38.733  1.00 63.50           C  
ATOM   8277  CD1 ILE    77    -105.544  17.554 -40.232  1.00 65.24           C  
ATOM   8278  N   GLU    78    -109.340  13.922 -38.145  1.00 57.78           N  
ATOM   8279  CA  GLU    78    -109.468  12.599 -37.555  1.00 60.04           C  
ATOM   8280  C   GLU    78    -108.614  11.602 -38.333  1.00 57.68           C  
ATOM   8281  O   GLU    78    -108.806  11.399 -39.533  1.00 59.36           O  
ATOM   8282  CB  GLU    78    -110.933  12.161 -37.490  1.00 61.44           C  
ATOM   8283  CG  GLU    78    -111.316  11.586 -36.139  1.00 71.59           C  
ATOM   8284  CD  GLU    78    -112.807  11.362 -35.982  1.00 82.86           C  
ATOM   8285  OE1 GLU    78    -113.399  11.973 -35.065  1.00 85.63           O  
ATOM   8286  OE2 GLU    78    -113.384  10.575 -36.764  1.00 85.45           O  
ATOM   8287  N   THR    79    -107.655  11.004 -37.634  1.00 55.81           N  
ATOM   8288  CA  THR    79    -106.732  10.030 -38.214  1.00 53.71           C  
ATOM   8289  C   THR    79    -106.540   8.885 -37.214  1.00 50.88           C  
ATOM   8290  O   THR    79    -107.223   8.843 -36.198  1.00 53.52           O  
ATOM   8291  CB  THR    79    -105.387  10.704 -38.633  1.00 56.65           C  
ATOM   8292  OG1 THR    79    -104.436   9.713 -39.047  1.00 55.80           O  
ATOM   8293  CG2 THR    79    -104.801  11.534 -37.490  1.00 53.91           C  
ATOM   8294  N   GLY    80    -105.636   7.952 -37.499  1.00 48.90           N  
ATOM   8295  CA  GLY    80    -105.436   6.798 -36.626  1.00 45.19           C  
ATOM   8296  C   GLY    80    -103.998   6.328 -36.531  1.00 43.56           C  
ATOM   8297  O   GLY    80    -103.134   6.782 -37.288  1.00 43.06           O  
ATOM   8298  N   ILE    81    -103.749   5.418 -35.588  1.00 41.38           N  
ATOM   8299  CA  ILE    81    -102.425   4.828 -35.381  1.00 38.65           C  
ATOM   8300  C   ILE    81    -102.105   3.891 -36.542  1.00 38.79           C  
ATOM   8301  O   ILE    81    -102.950   3.084 -36.931  1.00 42.90           O  
ATOM   8302  CB  ILE    81    -102.347   4.072 -34.017  1.00 37.88           C  
ATOM   8303  CG1 ILE    81    -102.470   5.056 -32.844  1.00 37.27           C  
ATOM   8304  CG2 ILE    81    -101.049   3.254 -33.893  1.00 33.72           C  
ATOM   8305  CD1 ILE    81    -102.728   4.400 -31.495  1.00 36.56           C  
ATOM   8306  N   ARG    82    -100.906   4.039 -37.106  1.00 36.17           N  
ATOM   8307  CA  ARG    82    -100.434   3.188 -38.197  0.50 35.92           C  
ATOM   8309  C   ARG    82     -99.723   1.959 -37.641  1.00 38.22           C  
ATOM   8310  O   ARG    82     -99.928   0.840 -38.121  1.00 36.05           O  
ATOM   8311  CB  ARG    82     -99.487   3.972 -39.112  0.50 34.83           C  
ATOM   8313  CG  ARG    82     -99.010   3.215 -40.350  0.50 39.11           C  
ATOM   8315  CD  ARG    82     -98.224   4.118 -41.294  0.50 35.84           C  
ATOM   8317  NE  ARG    82     -97.622   3.368 -42.395  0.50 33.08           N  
ATOM   8319  CZ  ARG    82     -96.374   2.903 -42.404  0.50 37.07           C  
ATOM   8321  NH1 ARG    82     -95.569   3.106 -41.368  0.50 32.81           N  
ATOM   8323  NH2 ARG    82     -95.926   2.231 -43.457  0.50 36.71           N  
ATOM   8325  N   THR    83     -98.886   2.189 -36.632  1.00 37.48           N  
ATOM   8326  CA  THR    83     -98.088   1.158 -35.979  1.00 39.27           C  
ATOM   8327  C   THR    83     -97.544   1.685 -34.654  1.00 39.23           C  
ATOM   8328  O   THR    83     -97.584   2.892 -34.390  1.00 39.06           O  
ATOM   8329  CB  THR    83     -96.901   0.695 -36.874  1.00 41.83           C  
ATOM   8330  OG1 THR    83     -96.245  -0.419 -36.262  1.00 49.98           O  
ATOM   8331  CG2 THR    83     -95.888   1.825 -37.118  1.00 40.10           C  
ATOM   8332  N   CYS    84     -97.042   0.782 -33.816  1.00 39.51           N  
ATOM   8333  CA  CYS    84     -96.324   1.200 -32.615  1.00 40.53           C  
ATOM   8334  C   CYS    84     -94.914   0.628 -32.602  1.00 39.63           C  
ATOM   8335  O   CYS    84     -94.671  -0.472 -33.091  1.00 41.58           O  
ATOM   8336  CB  CYS    84     -97.084   0.853 -31.328  1.00 40.84           C  
ATOM   8337  SG  CYS    84     -98.856   1.307 -31.327  1.00 47.99           S  
ATOM   8338  N   VAL    85     -93.994   1.422 -32.069  1.00 41.26           N  
ATOM   8339  CA  VAL    85     -92.575   1.088 -31.962  1.00 38.74           C  
ATOM   8340  C   VAL    85     -92.207   1.247 -30.470  1.00 39.32           C  
ATOM   8341  O   VAL    85     -93.071   1.667 -29.693  1.00 38.98           O  
ATOM   8342  CB  VAL    85     -91.720   2.011 -32.891  1.00 39.61           C  
ATOM   8343  CG1 VAL    85     -91.939   1.654 -34.361  1.00 36.84           C  
ATOM   8344  CG2 VAL    85     -92.010   3.488 -32.630  1.00 36.34           C  
ATOM   8345  N   PRO    86     -90.965   0.887 -30.050  1.00 39.93           N  
ATOM   8346  CA  PRO    86     -90.579   1.125 -28.642  1.00 40.46           C  
ATOM   8347  C   PRO    86     -90.798   2.546 -28.099  1.00 41.17           C  
ATOM   8348  O   PRO    86     -91.110   2.702 -26.920  1.00 41.73           O  
ATOM   8349  CB  PRO    86     -89.090   0.763 -28.623  1.00 38.19           C  
ATOM   8350  CG  PRO    86     -88.964  -0.271 -29.677  1.00 39.12           C  
ATOM   8351  CD  PRO    86     -89.882   0.187 -30.776  1.00 40.81           C  
ATOM   8352  N   ALA    87     -90.664   3.561 -28.953  1.00 41.92           N  
ATOM   8353  CA  ALA    87     -90.876   4.959 -28.552  1.00 41.74           C  
ATOM   8354  C   ALA    87     -92.349   5.317 -28.308  1.00 42.35           C  
ATOM   8355  O   ALA    87     -92.646   6.320 -27.659  1.00 44.31           O  
ATOM   8356  CB  ALA    87     -90.265   5.907 -29.580  1.00 39.31           C  
ATOM   8357  N   GLY    88     -93.261   4.500 -28.829  1.00 40.31           N  
ATOM   8358  CA  GLY    88     -94.694   4.729 -28.676  1.00 35.02           C  
ATOM   8359  C   GLY    88     -95.465   4.404 -29.941  1.00 38.26           C  
ATOM   8360  O   GLY    88     -94.940   3.763 -30.856  1.00 38.56           O  
ATOM   8361  N   CYS    89     -96.718   4.846 -29.992  1.00 37.23           N  
ATOM   8362  CA  CYS    89     -97.581   4.594 -31.143  1.00 37.64           C  
ATOM   8363  C   CYS    89     -97.558   5.742 -32.153  1.00 37.25           C  
ATOM   8364  O   CYS    89     -97.679   6.909 -31.783  1.00 38.90           O  
ATOM   8365  CB  CYS    89     -98.997   4.263 -30.677  1.00 36.32           C  
ATOM   8366  SG  CYS    89     -99.087   2.665 -29.817  1.00 44.05           S  
ATOM   8367  N   ILE    90     -97.386   5.397 -33.426  1.00 38.32           N  
ATOM   8368  CA  ILE    90     -97.156   6.382 -34.485  1.00 38.77           C  
ATOM   8369  C   ILE    90     -98.438   6.728 -35.234  1.00 38.84           C  
ATOM   8370  O   ILE    90     -99.085   5.851 -35.811  1.00 39.38           O  
ATOM   8371  CB  ILE    90     -96.072   5.896 -35.490  1.00 40.66           C  
ATOM   8372  CG1 ILE    90     -94.799   5.434 -34.759  1.00 40.11           C  
ATOM   8373  CG2 ILE    90     -95.768   6.968 -36.549  1.00 36.05           C  
ATOM   8374  CD1 ILE    90     -94.091   6.505 -33.922  1.00 47.31           C  
ATOM   8375  N   VAL    91     -98.788   8.015 -35.214  1.00 37.89           N  
ATOM   8376  CA  VAL    91     -99.967   8.541 -35.903  1.00 38.22           C  
ATOM   8377  C   VAL    91     -99.531   9.458 -37.056  1.00 38.71           C  
ATOM   8378  O   VAL    91     -99.006  10.547 -36.804  1.00 37.63           O  
ATOM   8379  CB  VAL    91    -100.880   9.336 -34.930  1.00 37.64           C  
ATOM   8380  CG1 VAL    91    -102.136   9.797 -35.628  1.00 34.89           C  
ATOM   8381  CG2 VAL    91    -101.244   8.505 -33.701  1.00 34.78           C  
ATOM   8382  N   PRO    92     -99.724   9.015 -38.321  1.00 41.21           N  
ATOM   8383  CA  PRO    92     -99.403   9.864 -39.476  1.00 42.25           C  
ATOM   8384  C   PRO    92    -100.380  11.022 -39.603  1.00 43.69           C  
ATOM   8385  O   PRO    92    -101.587  10.855 -39.385  1.00 46.34           O  
ATOM   8386  CB  PRO    92     -99.558   8.923 -40.679  1.00 40.31           C  
ATOM   8387  CG  PRO    92     -99.658   7.560 -40.117  1.00 41.73           C  
ATOM   8388  CD  PRO    92    -100.242   7.706 -38.751  1.00 40.34           C  
ATOM   8389  N   ILE    93     -99.847  12.189 -39.942  1.00 45.44           N  
ATOM   8390  CA  ILE    93    -100.636  13.410 -40.027  1.00 49.26           C  
ATOM   8391  C   ILE    93    -100.320  14.166 -41.312  1.00 48.71           C  
ATOM   8392  O   ILE    93     -99.160  14.278 -41.705  1.00 47.82           O  
ATOM   8393  CB  ILE    93    -100.407  14.322 -38.799  1.00 49.93           C  
ATOM   8394  CG1 ILE    93     -98.955  14.218 -38.324  1.00 54.73           C  
ATOM   8395  CG2 ILE    93    -101.351  13.927 -37.673  1.00 51.42           C  
ATOM   8396  CD1 ILE    93     -98.444  15.402 -37.553  1.00 48.62           C  
ATOM   8397  N   VAL    94    -101.369  14.643 -41.977  1.00 50.69           N  
ATOM   8398  CA  VAL    94    -101.246  15.502 -43.154  1.00 50.83           C  
ATOM   8399  C   VAL    94    -102.096  16.742 -42.903  1.00 50.88           C  
ATOM   8400  O   VAL    94    -103.281  16.628 -42.589  1.00 49.91           O  
ATOM   8401  CB  VAL    94    -101.702  14.779 -44.456  1.00 51.87           C  
ATOM   8402  CG1 VAL    94    -101.773  15.746 -45.634  1.00 51.56           C  
ATOM   8403  CG2 VAL    94    -100.766  13.624 -44.794  1.00 52.37           C  
ATOM   8404  N   PHE    95    -101.482  17.918 -43.019  1.00 51.11           N  
ATOM   8405  CA  PHE    95    -102.182  19.184 -42.817  1.00 53.11           C  
ATOM   8406  C   PHE    95    -102.367  19.943 -44.131  1.00 55.23           C  
ATOM   8407  O   PHE    95    -101.393  20.207 -44.839  1.00 57.10           O  
ATOM   8408  CB  PHE    95    -101.417  20.069 -41.830  1.00 51.34           C  
ATOM   8409  CG  PHE    95    -101.156  19.428 -40.493  1.00 51.30           C  
ATOM   8410  CD1 PHE    95     -99.856  19.297 -40.014  1.00 52.45           C  
ATOM   8411  CD2 PHE    95    -102.205  18.971 -39.704  1.00 51.81           C  
ATOM   8412  CE1 PHE    95     -99.611  18.719 -38.773  1.00 51.34           C  
ATOM   8413  CE2 PHE    95    -101.969  18.393 -38.462  1.00 49.46           C  
ATOM   8414  CZ  PHE    95    -100.673  18.267 -37.997  1.00 47.79           C  
ATOM   8415  N   ASP    96    -103.612  20.298 -44.449  1.00 58.17           N  
ATOM   8416  CA  ASP    96    -103.896  21.166 -45.601  1.00 62.07           C  
ATOM   8417  C   ASP    96    -103.629  22.639 -45.269  1.00 61.94           C  
ATOM   8418  O   ASP    96    -103.404  22.977 -44.103  1.00 61.30           O  
ATOM   8419  CB  ASP    96    -105.324  20.955 -46.143  1.00 62.34           C  
ATOM   8420  CG  ASP    96    -106.411  21.130 -45.079  1.00 68.13           C  
ATOM   8421  OD1 ASP    96    -106.406  22.134 -44.332  1.00 70.22           O  
ATOM   8422  OD2 ASP    96    -107.305  20.260 -45.012  1.00 74.75           O  
ATOM   8423  N   LYS    97    -103.677  23.499 -46.293  1.00 63.21           N  
ATOM   8424  CA  LYS    97    -103.397  24.944 -46.171  1.00 62.15           C  
ATOM   8425  C   LYS    97    -104.205  25.629 -45.062  1.00 58.72           C  
ATOM   8426  O   LYS    97    -103.676  26.483 -44.340  1.00 56.63           O  
ATOM   8427  CB  LYS    97    -103.646  25.671 -47.505  1.00 66.63           C  
ATOM   8428  CG  LYS    97    -103.078  24.989 -48.754  1.00 79.15           C  
ATOM   8429  CD  LYS    97    -101.597  25.278 -48.960  1.00 86.33           C  
ATOM   8430  CE  LYS    97    -101.089  24.618 -50.234  1.00 91.32           C  
ATOM   8431  NZ  LYS    97     -99.626  24.816 -50.433  1.00 92.22           N  
ATOM   8432  N   ASN    98    -105.474  25.231 -44.942  1.00 57.44           N  
ATOM   8433  CA  ASN    98    -106.388  25.775 -43.937  0.50 56.36           C  
ATOM   8435  C   ASN    98    -106.004  25.379 -42.513  1.00 56.07           C  
ATOM   8436  O   ASN    98    -106.101  26.193 -41.586  1.00 55.82           O  
ATOM   8437  CB  ASN    98    -107.826  25.333 -44.230  0.50 55.43           C  
ATOM   8439  CG  ASN    98    -108.272  25.685 -45.639  0.50 59.53           C  
ATOM   8441  OD1 ASN    98    -108.337  24.821 -46.514  0.50 56.99           O  
ATOM   8443  ND2 ASN    98    -108.574  26.959 -45.866  0.50 60.32           N  
ATOM   8445  N   TYR    99    -105.572  24.127 -42.346  1.00 53.30           N  
ATOM   8446  CA  TYR    99    -105.174  23.604 -41.038  1.00 49.37           C  
ATOM   8447  C   TYR    99    -103.825  24.171 -40.601  1.00 46.29           C  
ATOM   8448  O   TYR    99    -103.633  24.483 -39.422  1.00 46.34           O  
ATOM   8449  CB  TYR    99    -105.136  22.073 -41.041  1.00 49.20           C  
ATOM   8450  CG  TYR    99    -105.383  21.459 -39.678  1.00 47.60           C  
ATOM   8451  CD1 TYR    99    -104.369  21.396 -38.725  1.00 45.07           C  
ATOM   8452  CD2 TYR    99    -106.631  20.950 -39.339  1.00 47.01           C  
ATOM   8453  CE1 TYR    99    -104.583  20.839 -37.479  1.00 45.69           C  
ATOM   8454  CE2 TYR    99    -106.857  20.387 -38.087  1.00 49.26           C  
ATOM   8455  CZ  TYR    99    -105.826  20.337 -37.164  1.00 46.90           C  
ATOM   8456  OH  TYR    99    -106.029  19.789 -35.921  1.00 49.80           O  
ATOM   8457  N   VAL   100    -102.906  24.302 -41.556  1.00 43.96           N  
ATOM   8458  CA  VAL   100    -101.616  24.960 -41.332  1.00 43.98           C  
ATOM   8459  C   VAL   100    -101.799  26.388 -40.802  1.00 45.79           C  
ATOM   8460  O   VAL   100    -101.137  26.778 -39.843  1.00 48.00           O  
ATOM   8461  CB  VAL   100    -100.750  24.947 -42.617  1.00 44.35           C  
ATOM   8462  CG1 VAL   100     -99.566  25.891 -42.500  1.00 40.53           C  
ATOM   8463  CG2 VAL   100    -100.267  23.541 -42.908  1.00 42.15           C  
ATOM   8464  N   ALA   101    -102.725  27.136 -41.407  1.00 47.44           N  
ATOM   8465  CA  ALA   101    -103.055  28.503 -40.983  1.00 47.64           C  
ATOM   8466  C   ALA   101    -103.597  28.568 -39.554  1.00 46.99           C  
ATOM   8467  O   ALA   101    -103.307  29.517 -38.819  1.00 51.32           O  
ATOM   8468  CB  ALA   101    -104.048  29.135 -41.954  1.00 47.36           C  
ATOM   8469  N   ALA   102    -104.378  27.558 -39.174  1.00 45.72           N  
ATOM   8470  CA  ALA   102    -104.909  27.437 -37.818  1.00 43.91           C  
ATOM   8471  C   ALA   102    -103.809  27.097 -36.807  1.00 45.33           C  
ATOM   8472  O   ALA   102    -103.827  27.592 -35.680  1.00 46.79           O  
ATOM   8473  CB  ALA   102    -106.022  26.394 -37.774  1.00 42.26           C  
ATOM   8474  N   LEU   103    -102.859  26.258 -37.228  1.00 45.67           N  
ATOM   8475  CA  LEU   103    -101.682  25.882 -36.429  1.00 44.40           C  
ATOM   8476  C   LEU   103    -100.780  27.074 -36.107  1.00 44.93           C  
ATOM   8477  O   LEU   103    -100.211  27.149 -35.017  1.00 44.18           O  
ATOM   8478  CB  LEU   103    -100.866  24.811 -37.167  1.00 43.89           C  
ATOM   8479  CG  LEU   103    -100.812  23.312 -36.816  1.00 45.04           C  
ATOM   8480  CD1 LEU   103    -101.862  22.848 -35.824  1.00 40.47           C  
ATOM   8481  CD2 LEU   103    -100.864  22.475 -38.089  1.00 39.92           C  
ATOM   8482  N   ARG   104    -100.654  27.997 -37.060  1.00 45.96           N  
ATOM   8483  CA  ARG   104     -99.846  29.205 -36.884  1.00 45.42           C  
ATOM   8484  C   ARG   104    -100.493  30.188 -35.908  1.00 45.70           C  
ATOM   8485  O   ARG   104     -99.793  30.910 -35.198  1.00 47.56           O  
ATOM   8486  CB  ARG   104     -99.612  29.903 -38.226  1.00 48.20           C  
ATOM   8487  CG  ARG   104     -98.985  29.032 -39.300  1.00 48.50           C  
ATOM   8488  CD  ARG   104     -98.942  29.763 -40.628  1.00 48.41           C  
ATOM   8489  NE  ARG   104     -97.597  30.242 -40.930  1.00 45.45           N  
ATOM   8490  CZ  ARG   104     -96.884  29.856 -41.983  1.00 48.70           C  
ATOM   8491  NH1 ARG   104     -97.389  28.999 -42.860  1.00 61.07           N  
ATOM   8492  NH2 ARG   104     -95.668  30.342 -42.172  1.00 38.74           N  
ATOM   8493  N   ALA   105    -101.825  30.206 -35.880  1.00 46.39           N  
ATOM   8494  CA  ALA   105    -102.577  31.137 -35.038  1.00 48.45           C  
ATOM   8495  C   ALA   105    -102.917  30.547 -33.674  1.00 49.51           C  
ATOM   8496  O   ALA   105    -103.317  31.272 -32.760  1.00 52.08           O  
ATOM   8497  CB  ALA   105    -103.850  31.589 -35.753  1.00 48.13           C  
ATOM   8498  N   GLY   106    -102.755  29.232 -33.541  1.00 47.95           N  
ATOM   8499  CA  GLY   106    -103.172  28.515 -32.335  1.00 42.97           C  
ATOM   8500  C   GLY   106    -102.157  28.480 -31.207  1.00 42.20           C  
ATOM   8501  O   GLY   106    -100.995  28.862 -31.377  1.00 42.49           O  
ATOM   8502  N   LYS   107    -102.614  28.015 -30.048  1.00 43.00           N  
ATOM   8503  CA  LYS   107    -101.771  27.880 -28.865  1.00 47.17           C  
ATOM   8504  C   LYS   107    -101.509  26.412 -28.525  1.00 45.45           C  
ATOM   8505  O   LYS   107    -100.383  26.029 -28.207  1.00 44.60           O  
ATOM   8506  CB  LYS   107    -102.407  28.607 -27.674  1.00 50.63           C  
ATOM   8507  CG  LYS   107    -101.873  30.023 -27.475  1.00 65.02           C  
ATOM   8508  CD  LYS   107    -102.913  30.961 -26.882  1.00 77.55           C  
ATOM   8509  CE  LYS   107    -103.747  31.627 -27.972  1.00 86.67           C  
ATOM   8510  NZ  LYS   107    -104.663  32.663 -27.416  1.00 90.76           N  
ATOM   8511  N   HIS   108    -102.546  25.600 -28.561  1.00 45.01           N  
ATOM   8512  CA  HIS   108    -102.459  24.180 -28.282  1.00 44.56           C  
ATOM   8513  C   HIS   108    -103.063  23.346 -29.397  1.00 44.55           C  
ATOM   8514  O   HIS   108    -104.122  23.632 -29.880  1.00 43.56           O  
ATOM   8515  CB  HIS   108    -103.221  23.854 -27.015  1.00 47.32           C  
ATOM   8516  CG  HIS   108    -102.505  24.212 -25.762  1.00 54.73           C  
ATOM   8517  ND1 HIS   108    -102.780  23.614 -24.564  1.00 64.61           N  
ATOM   8518  CD2 HIS   108    -101.536  25.110 -25.515  1.00 62.28           C  
ATOM   8519  CE1 HIS   108    -102.005  24.123 -23.633  1.00 65.87           C  
ATOM   8520  NE2 HIS   108    -101.244  25.038 -24.183  1.00 62.10           N  
ATOM   8521  N   LEU   109    -102.395  22.283 -29.779  1.00 41.56           N  
ATOM   8522  CA  LEU   109    -102.997  21.270 -30.627  1.00 41.76           C  
ATOM   8523  C   LEU   109    -103.484  20.151 -29.717  1.00 42.73           C  
ATOM   8524  O   LEU   109    -102.692  19.347 -29.231  1.00 43.29           O  
ATOM   8525  CB  LEU   109    -102.010  20.747 -31.677  1.00 38.66           C  
ATOM   8526  CG  LEU   109    -102.527  19.658 -32.627  1.00 38.21           C  
ATOM   8527  CD1 LEU   109    -103.705  20.134 -33.472  1.00 38.18           C  
ATOM   8528  CD2 LEU   109    -101.416  19.180 -33.517  1.00 37.24           C  
ATOM   8529  N   LYS   110    -104.791  20.125 -29.480  1.00 43.89           N  
ATOM   8530  CA  LYS   110    -105.404  19.176 -28.560  1.00 43.28           C  
ATOM   8531  C   LYS   110    -105.587  17.811 -29.212  1.00 42.81           C  
ATOM   8532  O   LYS   110    -105.958  17.711 -30.386  1.00 41.27           O  
ATOM   8533  CB  LYS   110    -106.747  19.713 -28.057  1.00 46.86           C  
ATOM   8534  CG  LYS   110    -106.637  20.949 -27.172  1.00 53.48           C  
ATOM   8535  CD  LYS   110    -107.995  21.343 -26.614  1.00 68.99           C  
ATOM   8536  CE  LYS   110    -107.894  22.573 -25.725  1.00 83.43           C  
ATOM   8537  NZ  LYS   110    -109.224  22.997 -25.197  1.00 87.33           N  
ATOM   8538  N   LEU   111    -105.312  16.761 -28.444  1.00 43.69           N  
ATOM   8539  CA  LEU   111    -105.471  15.391 -28.923  1.00 43.91           C  
ATOM   8540  C   LEU   111    -106.586  14.683 -28.168  1.00 42.18           C  
ATOM   8541  O   LEU   111    -106.776  14.908 -26.971  1.00 42.42           O  
ATOM   8542  CB  LEU   111    -104.172  14.585 -28.777  1.00 44.52           C  
ATOM   8543  CG  LEU   111    -102.890  14.770 -29.601  1.00 45.49           C  
ATOM   8544  CD1 LEU   111    -103.057  15.711 -30.792  1.00 43.61           C  
ATOM   8545  CD2 LEU   111    -101.758  15.239 -28.714  1.00 46.82           C  
ATOM   8546  N   ALA   112    -107.317  13.826 -28.874  1.00 41.70           N  
ATOM   8547  CA  ALA   112    -108.374  13.027 -28.265  1.00 42.11           C  
ATOM   8548  C   ALA   112    -108.318  11.600 -28.786  1.00 40.83           C  
ATOM   8549  O   ALA   112    -108.326  11.375 -29.995  1.00 41.53           O  
ATOM   8550  CB  ALA   112    -109.737  13.640 -28.541  1.00 43.85           C  
ATOM   8551  N   MET   113    -108.261  10.641 -27.867  1.00 42.50           N  
ATOM   8552  CA  MET   113    -108.178   9.224 -28.225  1.00 41.77           C  
ATOM   8553  C   MET   113    -108.865   8.337 -27.185  1.00 43.96           C  
ATOM   8554  O   MET   113    -109.351   8.830 -26.165  1.00 43.85           O  
ATOM   8555  CB  MET   113    -106.716   8.800 -28.455  1.00 39.60           C  
ATOM   8556  CG  MET   113    -105.768   9.074 -27.297  1.00 39.28           C  
ATOM   8557  SD  MET   113    -104.057   9.187 -27.855  1.00 38.65           S  
ATOM   8558  CE  MET   113    -103.916  10.929 -28.210  1.00 41.68           C  
ATOM   8559  N   THR   114    -108.912   7.036 -27.464  1.00 46.22           N  
ATOM   8560  CA  THR   114    -109.570   6.062 -26.595  1.00 45.64           C  
ATOM   8561  C   THR   114    -108.539   5.101 -26.004  1.00 45.67           C  
ATOM   8562  O   THR   114    -107.699   4.574 -26.725  1.00 45.03           O  
ATOM   8563  CB  THR   114    -110.642   5.261 -27.373  1.00 45.96           C  
ATOM   8564  OG1 THR   114    -111.473   6.162 -28.109  1.00 48.22           O  
ATOM   8565  CG2 THR   114    -111.514   4.449 -26.434  1.00 42.63           C  
ATOM   8566  N   ILE   115    -108.603   4.896 -24.688  1.00 45.73           N  
ATOM   8567  CA  ILE   115    -107.736   3.945 -23.995  1.00 46.76           C  
ATOM   8568  C   ILE   115    -108.279   2.526 -24.181  1.00 48.35           C  
ATOM   8569  O   ILE   115    -109.484   2.295 -24.043  1.00 46.33           O  
ATOM   8570  CB  ILE   115    -107.608   4.296 -22.484  1.00 48.02           C  
ATOM   8571  CG1 ILE   115    -107.145   5.752 -22.308  1.00 45.46           C  
ATOM   8572  CG2 ILE   115    -106.644   3.342 -21.767  1.00 46.95           C  
ATOM   8573  CD1 ILE   115    -107.260   6.284 -20.886  1.00 46.24           C  
ATOM   8574  N   ALA   116    -107.391   1.590 -24.528  1.00 50.35           N  
ATOM   8575  CA  ALA   116    -107.740   0.171 -24.607  1.00 52.06           C  
ATOM   8576  C   ALA   116    -107.751  -0.436 -23.205  1.00 55.15           C  
ATOM   8577  O   ALA   116    -106.767  -1.031 -22.750  1.00 59.61           O  
ATOM   8578  CB  ALA   116    -106.782  -0.572 -25.521  1.00 44.31           C  
ATOM   8579  N   ALA   117    -108.878  -0.253 -22.527  1.00 58.19           N  
ATOM   8580  CA  ALA   117    -109.069  -0.675 -21.145  1.00 61.47           C  
ATOM   8581  C   ALA   117    -110.547  -1.048 -20.998  1.00 66.06           C  
ATOM   8582  O   ALA   117    -111.353  -0.647 -21.847  1.00 65.12           O  
ATOM   8583  CB  ALA   117    -108.688   0.464 -20.192  1.00 59.16           C  
ATOM   8584  N   PRO   118    -110.907  -1.847 -19.961  1.00 70.36           N  
ATOM   8585  CA  PRO   118    -112.326  -2.104 -19.686  1.00 69.83           C  
ATOM   8586  C   PRO   118    -113.139  -0.815 -19.520  1.00 67.26           C  
ATOM   8587  O   PRO   118    -112.801   0.036 -18.690  1.00 65.41           O  
ATOM   8588  CB  PRO   118    -112.289  -2.889 -18.371  1.00 72.29           C  
ATOM   8589  CG  PRO   118    -110.970  -3.562 -18.380  1.00 73.53           C  
ATOM   8590  CD  PRO   118    -110.035  -2.587 -19.025  1.00 71.48           C  
ATOM   8591  N   GLY   119    -114.183  -0.678 -20.336  1.00 64.56           N  
ATOM   8592  CA  GLY   119    -115.020   0.521 -20.353  1.00 65.34           C  
ATOM   8593  C   GLY   119    -114.679   1.468 -21.491  1.00 66.33           C  
ATOM   8594  O   GLY   119    -115.500   2.313 -21.870  1.00 65.92           O  
ATOM   8595  N   GLU   120    -113.468   1.304 -22.031  1.00 65.10           N  
ATOM   8596  CA  GLU   120    -112.886   2.149 -23.091  1.00 60.07           C  
ATOM   8597  C   GLU   120    -112.930   3.659 -22.797  1.00 56.48           C  
ATOM   8598  O   GLU   120    -113.626   4.403 -23.499  1.00 54.40           O  
ATOM   8599  CB  GLU   120    -113.501   1.823 -24.461  1.00 57.83           C  
ATOM   8600  CG  GLU   120    -113.168   0.420 -24.972  1.00 61.58           C  
ATOM   8601  CD  GLU   120    -113.903   0.049 -26.256  1.00 66.14           C  
ATOM   8602  OE1 GLU   120    -114.475   0.945 -26.917  1.00 66.14           O  
ATOM   8603  OE2 GLU   120    -113.890  -1.148 -26.617  1.00 72.51           O  
ATOM   8604  N   PRO   121    -112.171   4.114 -21.774  1.00 52.88           N  
ATOM   8605  CA  PRO   121    -112.229   5.517 -21.353  1.00 53.24           C  
ATOM   8606  C   PRO   121    -111.534   6.454 -22.351  1.00 56.38           C  
ATOM   8607  O   PRO   121    -110.611   6.030 -23.048  1.00 53.06           O  
ATOM   8608  CB  PRO   121    -111.475   5.522 -20.009  1.00 52.61           C  
ATOM   8609  CG  PRO   121    -111.177   4.091 -19.683  1.00 52.96           C  
ATOM   8610  CD  PRO   121    -111.185   3.358 -20.979  1.00 52.36           C  
ATOM   8611  N   PRO   122    -111.985   7.719 -22.435  1.00 59.94           N  
ATOM   8612  CA  PRO   122    -111.286   8.657 -23.309  1.00 58.33           C  
ATOM   8613  C   PRO   122    -110.017   9.220 -22.674  1.00 56.98           C  
ATOM   8614  O   PRO   122    -109.922   9.322 -21.444  1.00 57.07           O  
ATOM   8615  CB  PRO   122    -112.315   9.769 -23.519  1.00 60.21           C  
ATOM   8616  CG  PRO   122    -113.144   9.755 -22.281  1.00 61.14           C  
ATOM   8617  CD  PRO   122    -113.148   8.339 -21.768  1.00 60.85           C  
ATOM   8618  N   LEU   123    -109.047   9.561 -23.519  1.00 54.52           N  
ATOM   8619  CA  LEU   123    -107.865  10.303 -23.100  1.00 53.27           C  
ATOM   8620  C   LEU   123    -107.857  11.620 -23.871  1.00 54.53           C  
ATOM   8621  O   LEU   123    -107.614  11.639 -25.083  1.00 51.60           O  
ATOM   8622  CB  LEU   123    -106.586   9.495 -23.354  1.00 51.52           C  
ATOM   8623  CG  LEU   123    -105.254  10.038 -22.815  1.00 53.22           C  
ATOM   8624  CD1 LEU   123    -105.218  10.070 -21.284  1.00 52.01           C  
ATOM   8625  CD2 LEU   123    -104.097   9.215 -23.355  1.00 50.63           C  
ATOM   8626  N   ASN   124    -108.144  12.713 -23.163  1.00 56.50           N  
ATOM   8627  CA  ASN   124    -108.382  14.015 -23.792  1.00 56.92           C  
ATOM   8628  C   ASN   124    -107.468  15.139 -23.302  1.00 56.47           C  
ATOM   8629  O   ASN   124    -107.540  16.263 -23.805  1.00 57.02           O  
ATOM   8630  CB  ASN   124    -109.848  14.431 -23.610  1.00 59.19           C  
ATOM   8631  CG  ASN   124    -110.825  13.484 -24.293  1.00 62.91           C  
ATOM   8632  OD1 ASN   124    -110.506  12.856 -25.306  1.00 63.84           O  
ATOM   8633  ND2 ASN   124    -112.032  13.388 -23.741  1.00 62.51           N  
ATOM   8634  N   ASP   125    -106.609  14.837 -22.332  1.00 55.89           N  
ATOM   8635  CA  ASP   125    -105.779  15.864 -21.692  1.00 57.91           C  
ATOM   8636  C   ASP   125    -104.396  16.068 -22.331  1.00 55.21           C  
ATOM   8637  O   ASP   125    -103.591  16.868 -21.845  1.00 54.81           O  
ATOM   8638  CB  ASP   125    -105.666  15.616 -20.173  1.00 62.84           C  
ATOM   8639  CG  ASP   125    -105.107  14.231 -19.822  1.00 72.01           C  
ATOM   8640  OD1 ASP   125    -104.941  13.962 -18.613  1.00 81.27           O  
ATOM   8641  OD2 ASP   125    -104.833  13.413 -20.727  1.00 74.19           O  
ATOM   8642  N   LEU   126    -104.131  15.349 -23.420  1.00 51.02           N  
ATOM   8643  CA  LEU   126    -102.862  15.481 -24.138  1.00 46.92           C  
ATOM   8644  C   LEU   126    -102.934  16.535 -25.235  1.00 44.90           C  
ATOM   8645  O   LEU   126    -103.976  16.714 -25.877  1.00 45.37           O  
ATOM   8646  CB  LEU   126    -102.422  14.140 -24.730  1.00 47.54           C  
ATOM   8647  CG  LEU   126    -101.420  13.221 -24.023  1.00 47.39           C  
ATOM   8648  CD1 LEU   126    -101.581  13.167 -22.504  1.00 46.51           C  
ATOM   8649  CD2 LEU   126    -101.553  11.842 -24.625  1.00 44.20           C  
ATOM   8650  N   PHE   127    -101.809  17.212 -25.446  1.00 41.83           N  
ATOM   8651  CA  PHE   127    -101.706  18.298 -26.410  1.00 41.39           C  
ATOM   8652  C   PHE   127    -100.275  18.487 -26.886  1.00 40.58           C  
ATOM   8653  O   PHE   127     -99.340  17.969 -26.280  1.00 41.29           O  
ATOM   8654  CB  PHE   127    -102.233  19.626 -25.825  1.00 44.43           C  
ATOM   8655  CG  PHE   127    -101.652  19.980 -24.479  1.00 47.75           C  
ATOM   8656  CD1 PHE   127    -100.417  20.619 -24.373  1.00 47.14           C  
ATOM   8657  CD2 PHE   127    -102.350  19.680 -23.312  1.00 49.24           C  
ATOM   8658  CE1 PHE   127     -99.883  20.940 -23.128  1.00 49.24           C  
ATOM   8659  CE2 PHE   127    -101.824  19.998 -22.065  1.00 50.32           C  
ATOM   8660  CZ  PHE   127    -100.590  20.629 -21.973  1.00 51.44           C  
ATOM   8661  N   VAL   128    -100.116  19.241 -27.969  1.00 39.64           N  
ATOM   8662  CA  VAL   128     -98.810  19.727 -28.402  1.00 35.39           C  
ATOM   8663  C   VAL   128     -98.871  21.252 -28.339  1.00 37.91           C  
ATOM   8664  O   VAL   128     -99.822  21.863 -28.828  1.00 37.48           O  
ATOM   8665  CB  VAL   128     -98.448  19.246 -29.832  1.00 34.96           C  
ATOM   8666  CG1 VAL   128     -97.069  19.763 -30.258  1.00 30.06           C  
ATOM   8667  CG2 VAL   128     -98.479  17.727 -29.917  1.00 32.12           C  
ATOM   8668  N   GLN   129     -97.872  21.862 -27.707  1.00 38.26           N  
ATOM   8669  CA  GLN   129     -97.810  23.317 -27.601  1.00 36.17           C  
ATOM   8670  C   GLN   129     -97.309  23.935 -28.904  1.00 36.80           C  
ATOM   8671  O   GLN   129     -96.326  23.473 -29.489  1.00 36.17           O  
ATOM   8672  CB  GLN   129     -96.923  23.732 -26.432  1.00 35.06           C  
ATOM   8673  CG  GLN   129     -97.478  23.348 -25.062  1.00 36.77           C  
ATOM   8674  CD  GLN   129     -96.547  23.751 -23.932  1.00 39.52           C  
ATOM   8675  OE1 GLN   129     -96.678  24.837 -23.363  1.00 44.44           O  
ATOM   8676  NE2 GLN   129     -95.588  22.888 -23.615  1.00 37.86           N  
ATOM   8677  N   LEU   130     -97.986  24.989 -29.348  1.00 39.66           N  
ATOM   8678  CA  LEU   130     -97.746  25.542 -30.682  1.00 37.39           C  
ATOM   8679  C   LEU   130     -96.927  26.823 -30.700  1.00 36.78           C  
ATOM   8680  O   LEU   130     -96.784  27.445 -31.753  1.00 41.24           O  
ATOM   8681  CB  LEU   130     -99.072  25.741 -31.425  1.00 35.81           C  
ATOM   8682  CG  LEU   130     -99.896  24.487 -31.722  1.00 34.91           C  
ATOM   8683  CD1 LEU   130    -101.245  24.877 -32.294  1.00 34.39           C  
ATOM   8684  CD2 LEU   130     -99.152  23.531 -32.666  1.00 30.66           C  
ATOM   8685  N   ASN   131     -96.387  27.213 -29.548  1.00 39.07           N  
ATOM   8686  CA  ASN   131     -95.550  28.406 -29.468  1.00 38.32           C  
ATOM   8687  C   ASN   131     -94.264  28.239 -30.276  1.00 39.51           C  
ATOM   8688  O   ASN   131     -93.415  27.407 -29.953  1.00 40.05           O  
ATOM   8689  CB  ASN   131     -95.232  28.778 -28.015  1.00 41.74           C  
ATOM   8690  CG  ASN   131     -94.448  30.077 -27.907  1.00 44.69           C  
ATOM   8691  OD1 ASN   131     -93.229  30.068 -27.732  1.00 50.64           O  
ATOM   8692  ND2 ASN   131     -95.144  31.199 -28.033  1.00 50.20           N  
ATOM   8693  N   GLY   132     -94.150  29.023 -31.343  1.00 37.36           N  
ATOM   8694  CA  GLY   132     -93.003  28.953 -32.239  1.00 31.67           C  
ATOM   8695  C   GLY   132     -93.244  28.183 -33.527  1.00 34.02           C  
ATOM   8696  O   GLY   132     -92.359  28.129 -34.377  1.00 38.35           O  
ATOM   8697  N   PHE   133     -94.431  27.590 -33.670  1.00 36.76           N  
ATOM   8698  CA  PHE   133     -94.796  26.820 -34.870  1.00 38.96           C  
ATOM   8699  C   PHE   133     -94.644  27.644 -36.152  1.00 41.71           C  
ATOM   8700  O   PHE   133     -94.022  27.185 -37.115  1.00 42.81           O  
ATOM   8701  CB  PHE   133     -96.235  26.273 -34.773  1.00 39.20           C  
ATOM   8702  CG  PHE   133     -96.596  25.297 -35.871  1.00 41.70           C  
ATOM   8703  CD1 PHE   133     -96.525  23.924 -35.649  1.00 43.33           C  
ATOM   8704  CD2 PHE   133     -97.017  25.749 -37.127  1.00 42.03           C  
ATOM   8705  CE1 PHE   133     -96.848  23.014 -36.665  1.00 43.98           C  
ATOM   8706  CE2 PHE   133     -97.337  24.854 -38.146  1.00 39.80           C  
ATOM   8707  CZ  PHE   133     -97.254  23.484 -37.916  1.00 42.34           C  
ATOM   8708  N   SER   134     -95.220  28.848 -36.149  1.00 42.18           N  
ATOM   8709  CA  SER   134     -95.229  29.740 -37.313  1.00 42.38           C  
ATOM   8710  C   SER   134     -93.817  30.116 -37.757  1.00 40.58           C  
ATOM   8711  O   SER   134     -93.495  30.008 -38.943  1.00 42.40           O  
ATOM   8712  CB  SER   134     -96.059  30.995 -37.014  1.00 46.82           C  
ATOM   8713  OG  SER   134     -96.150  31.853 -38.136  1.00 54.10           O  
ATOM   8714  N   ASN   135     -92.980  30.528 -36.802  1.00 38.02           N  
ATOM   8715  CA  ASN   135     -91.591  30.900 -37.084  1.00 39.07           C  
ATOM   8716  C   ASN   135     -90.716  29.738 -37.534  1.00 40.40           C  
ATOM   8717  O   ASN   135     -89.853  29.910 -38.399  1.00 45.00           O  
ATOM   8718  CB  ASN   135     -90.956  31.588 -35.877  1.00 42.86           C  
ATOM   8719  CG  ASN   135     -91.424  33.016 -35.704  1.00 45.18           C  
ATOM   8720  OD1 ASN   135     -91.832  33.673 -36.664  1.00 49.01           O  
ATOM   8721  ND2 ASN   135     -91.363  33.509 -34.472  1.00 45.57           N  
ATOM   8722  N   ALA   136     -90.941  28.563 -36.950  1.00 40.02           N  
ATOM   8723  CA  ALA   136     -90.217  27.350 -37.346  1.00 38.53           C  
ATOM   8724  C   ALA   136     -90.631  26.886 -38.742  1.00 36.86           C  
ATOM   8725  O   ALA   136     -89.804  26.381 -39.498  1.00 38.11           O  
ATOM   8726  CB  ALA   136     -90.411  26.230 -36.319  1.00 36.47           C  
ATOM   8727  N   LEU   137     -91.905  27.070 -39.082  1.00 37.02           N  
ATOM   8728  CA  LEU   137     -92.394  26.736 -40.420  1.00 39.48           C  
ATOM   8729  C   LEU   137     -91.861  27.698 -41.484  1.00 41.97           C  
ATOM   8730  O   LEU   137     -91.545  27.270 -42.596  1.00 45.89           O  
ATOM   8731  CB  LEU   137     -93.922  26.674 -40.453  1.00 38.11           C  
ATOM   8732  CG  LEU   137     -94.596  26.152 -41.724  1.00 38.77           C  
ATOM   8733  CD1 LEU   137     -94.068  24.788 -42.136  1.00 37.35           C  
ATOM   8734  CD2 LEU   137     -96.089  26.102 -41.522  1.00 38.36           C  
ATOM   8735  N   ASN   138     -91.750  28.982 -41.131  1.00 42.09           N  
ATOM   8736  CA  ASN   138     -91.138  29.994 -42.000  1.00 42.09           C  
ATOM   8737  C   ASN   138     -89.689  29.657 -42.328  1.00 43.62           C  
ATOM   8738  O   ASN   138     -89.239  29.867 -43.454  1.00 48.34           O  
ATOM   8739  CB  ASN   138     -91.190  31.386 -41.355  1.00 42.26           C  
ATOM   8740  CG  ASN   138     -92.591  31.979 -41.320  1.00 42.14           C  
ATOM   8741  OD1 ASN   138     -93.517  31.477 -41.950  1.00 42.75           O  
ATOM   8742  ND2 ASN   138     -92.745  33.061 -40.571  1.00 41.76           N  
ATOM   8743  N   ARG   139     -88.969  29.140 -41.334  1.00 45.67           N  
ATOM   8744  CA  ARG   139     -87.590  28.693 -41.508  1.00 43.72           C  
ATOM   8745  C   ARG   139     -87.516  27.463 -42.424  1.00 43.33           C  
ATOM   8746  O   ARG   139     -86.610  27.356 -43.247  1.00 45.37           O  
ATOM   8747  CB  ARG   139     -86.942  28.429 -40.142  1.00 42.86           C  
ATOM   8748  CG  ARG   139     -85.506  27.912 -40.174  1.00 43.81           C  
ATOM   8749  CD  ARG   139     -84.563  28.856 -40.900  1.00 45.81           C  
ATOM   8750  NE  ARG   139     -83.174  28.411 -40.801  1.00 53.72           N  
ATOM   8751  CZ  ARG   139     -82.195  28.800 -41.613  1.00 55.64           C  
ATOM   8752  NH1 ARG   139     -82.438  29.636 -42.614  1.00 57.67           N  
ATOM   8753  NH2 ARG   139     -80.965  28.341 -41.429  1.00 55.83           N  
ATOM   8754  N   LEU   140     -88.484  26.557 -42.290  1.00 44.94           N  
ATOM   8755  CA  LEU   140     -88.597  25.388 -43.168  1.00 46.02           C  
ATOM   8756  C   LEU   140     -88.870  25.768 -44.627  1.00 49.25           C  
ATOM   8757  O   LEU   140     -88.360  25.119 -45.547  1.00 50.94           O  
ATOM   8758  CB  LEU   140     -89.676  24.427 -42.657  1.00 44.43           C  
ATOM   8759  CG  LEU   140     -89.263  23.036 -42.161  1.00 42.54           C  
ATOM   8760  CD1 LEU   140     -88.145  23.071 -41.135  1.00 34.28           C  
ATOM   8761  CD2 LEU   140     -90.474  22.281 -41.622  1.00 34.42           C  
ATOM   8762  N   ILE   141     -89.674  26.813 -44.825  1.00 50.63           N  
ATOM   8763  CA  ILE   141     -89.933  27.380 -46.152  1.00 51.16           C  
ATOM   8764  C   ILE   141     -88.652  28.003 -46.720  1.00 52.42           C  
ATOM   8765  O   ILE   141     -88.311  27.776 -47.885  1.00 55.57           O  
ATOM   8766  CB  ILE   141     -91.092  28.418 -46.116  1.00 51.67           C  
ATOM   8767  CG1 ILE   141     -92.414  27.733 -45.743  1.00 48.54           C  
ATOM   8768  CG2 ILE   141     -91.245  29.126 -47.466  1.00 53.10           C  
ATOM   8769  CD1 ILE   141     -93.491  28.667 -45.217  1.00 46.79           C  
ATOM   8770  N   ALA   142     -87.940  28.750 -45.876  1.00 52.51           N  
ATOM   8771  CA  ALA   142     -86.662  29.376 -46.232  1.00 53.46           C  
ATOM   8772  C   ALA   142     -85.546  28.372 -46.549  1.00 55.72           C  
ATOM   8773  O   ALA   142     -84.695  28.639 -47.401  1.00 60.79           O  
ATOM   8774  CB  ALA   142     -86.216  30.336 -45.124  1.00 50.56           C  
ATOM   8775  N   LEU   143     -85.555  27.228 -45.864  1.00 57.21           N  
ATOM   8776  CA  LEU   143     -84.567  26.172 -46.092  1.00 58.17           C  
ATOM   8777  C   LEU   143     -84.829  25.377 -47.377  1.00 61.92           C  
ATOM   8778  O   LEU   143     -83.911  24.755 -47.923  1.00 63.84           O  
ATOM   8779  CB  LEU   143     -84.485  25.230 -44.885  1.00 55.26           C  
ATOM   8780  CG  LEU   143     -83.691  25.691 -43.658  1.00 52.15           C  
ATOM   8781  CD1 LEU   143     -84.099  24.885 -42.426  1.00 47.67           C  
ATOM   8782  CD2 LEU   143     -82.186  25.601 -43.889  1.00 51.87           C  
ATOM   8783  N   GLN   144     -86.078  25.390 -47.846  1.00 65.75           N  
ATOM   8784  CA  GLN   144     -86.444  24.772 -49.123  1.00 71.05           C  
ATOM   8785  C   GLN   144     -85.878  25.549 -50.307  1.00 73.07           C  
ATOM   8786  O   GLN   144     -85.436  24.954 -51.296  1.00 73.75           O  
ATOM   8787  CB  GLN   144     -87.963  24.664 -49.268  1.00 71.94           C  
ATOM   8788  CG  GLN   144     -88.529  23.295 -48.930  1.00 77.77           C  
ATOM   8789  CD  GLN   144     -89.821  22.994 -49.678  1.00 79.09           C  
ATOM   8790  OE1 GLN   144     -90.596  23.898 -50.003  1.00 73.88           O  
ATOM   8791  NE2 GLN   144     -90.057  21.714 -49.952  1.00 79.06           N  
ATOM   8792  N   LYS   145     -85.898  26.877 -50.191  1.00 74.17           N  
ATOM   8793  CA  LYS   145     -85.368  27.774 -51.220  1.00 75.54           C  
ATOM   8794  C   LYS   145     -83.838  27.721 -51.302  1.00 76.51           C  
ATOM   8795  O   LYS   145     -83.263  27.926 -52.374  1.00 79.49           O  
ATOM   8796  CB  LYS   145     -85.854  29.206 -50.982  1.00 76.15           C  
ATOM   8797  CG  LYS   145     -87.359  29.376 -51.148  1.00 79.02           C  
ATOM   8798  CD  LYS   145     -87.827  30.741 -50.679  1.00 82.69           C  
ATOM   8799  CE  LYS   145     -89.345  30.829 -50.697  1.00 86.16           C  
ATOM   8800  NZ  LYS   145     -89.840  32.104 -50.106  1.00 88.65           N  
END
