
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  171 ( 1326),  selected  171 , name 1nqz_A
# Molecule2: number of CA atoms  208 ( 1611),  selected  208 , name T0513_1_11_87_283.pdb
# PARAMETERS: 1nqz_A.T0513_1_11_87_283.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P     4_A      M       1           -
LGA    H     5_A      S       2           -
LGA    D     6_A      F       3           -
LGA    P     7_A      L       4           -
LGA    L     8_A      K       5           -
LGA    D     9_A      -       -           -
LGA    D    10_A      -       -           -
LGA    I    11_A      -       -           -
LGA    Q    12_A      -       -           -
LGA    A    13_A      -       -           -
LGA    D    14_A      -       -           -
LGA    P    15_A      -       -           -
LGA    W    16_A      H       6           #
LGA    A    17_A      V       7           -
LGA    -       -      Q       8           -
LGA    L    18_A      D       9          3.751
LGA    W    19_A      C      10          2.823
LGA    L    20_A      N      11          5.844
LGA    S    21_A      G      87           -
LGA    G    22_A      E      88           -
LGA    -       -      L      89           -
LGA    -       -      Y      90           -
LGA    -       -      R      91           -
LGA    -       -      V      92           -
LGA    -       -      N      93           -
LGA    -       -      Q      94           -
LGA    -       -      S      95           -
LGA    -       -      W      96           -
LGA    -       -      G      97           -
LGA    -       -      E      98           -
LGA    -       -      P      99           -
LGA    -       -      T     100           -
LGA    -       -      L     101           -
LGA    -       -      M     102           -
LGA    -       -      L     103           -
LGA    -       -      L     104           -
LGA    -       -      D     105           -
LGA    -       -      R     106           -
LGA    -       -      A     107           -
LGA    -       -      V     108           -
LGA    -       -      V     109           -
LGA    -       -      P     110           -
LGA    -       -      T     111           -
LGA    -       -      F     112           -
LGA    -       -      G     113           -
LGA    -       -      V     114           -
LGA    Y    33_A      R     115          1.516
LGA    R    34_A      A     116          1.378
LGA    R    35_A      Y     117          1.197
LGA    A    36_A      G     118          1.107
LGA    A    37_A      V     119          0.964
LGA    V    38_A      H     120          1.312
LGA    L    39_A      L     121          1.393
LGA    V    40_A      N     122          1.453
LGA    A    41_A      G     123          1.424
LGA    L    42_A      Y     124          1.538
LGA    T    43_A      V     125          1.717
LGA    R    44_A      G     126          4.079
LGA    E    45_A      A     127          4.738
LGA    A    46_A      G     128          5.356
LGA    -       -      A     129           -
LGA    D    47_A      D     130          1.608
LGA    P    48_A      L     131          2.153
LGA    R    49_A      H     132          1.832
LGA    V    50_A      L     133          1.720
LGA    L    51_A      W     134          2.198
LGA    L    52_A      I     135          1.900
LGA    T    53_A      G     136          1.057
LGA    V    54_A      R     137          0.900
LGA    R    55_A      R     138          1.081
LGA    S    56_A      S     139          1.192
LGA    K    63_A      P     140           #
LGA    -       -      D     141           -
LGA    -       -      K     142           -
LGA    -       -      S     143           -
LGA    -       -      V     144           -
LGA    -       -      A     145           -
LGA    -       -      P     146           -
LGA    G    64_A      G     147          0.522
LGA    Q    65_A      K     148          2.100
LGA    I    66_A      L     149          1.623
LGA    A    67_A      D     150          1.547
LGA    F    68_A      N     151          1.712
LGA    -       -      M     152           -
LGA    P    69_A      V     153          1.808
LGA    G    70_A      A     154          1.570
LGA    G    71_A      G     155          1.365
LGA    S    72_A      G     156          1.603
LGA    L    73_A      Q     157          1.469
LGA    D    74_A      P     158          1.873
LGA    A    75_A      A     159          2.211
LGA    G    76_A      D     160          3.451
LGA    E    77_A      L     161          1.726
LGA    T    78_A      S     162          2.147
LGA    P    79_A      L     163          2.074
LGA    T    80_A      R     164          2.610
LGA    Q    81_A      Q     165          2.318
LGA    A    82_A      N     166          1.742
LGA    A    83_A      L     167          2.289
LGA    L    84_A      I     168          2.746
LGA    R    85_A      K     169          1.636
LGA    E    86_A      E     170          1.077
LGA    A    87_A      C     171          2.165
LGA    Q    88_A      A     172          1.336
LGA    E    89_A      E     173          0.511
LGA    E    90_A      E     174          0.904
LGA    V    91_A      A     175          1.661
LGA    A    92_A      D     176          0.734
LGA    L    93_A      L     177          1.151
LGA    D    94_A      P     178          1.297
LGA    P    95_A      E     179          2.949
LGA    A    96_A      A     180          1.444
LGA    A    97_A      L     181          1.929
LGA    V    98_A      A     182          3.844
LGA    -       -      R     183           -
LGA    T    99_A      Q     184          2.398
LGA    L   100_A      A     185          2.105
LGA    L   101_A      I     186          2.756
LGA    G   102_A      P     187          2.142
LGA    E   103_A      V     188          1.893
LGA    L   104_A      G     189          2.856
LGA    D   105_A      A     190          2.584
LGA    D   106_A      -       -           -
LGA    V   107_A      I     191          2.024
LGA    F   108_A      T     192          2.818
LGA    T   109_A      Y     193          3.143
LGA    P   110_A      C     194          1.764
LGA    V   111_A      M     195          4.812
LGA    -       -      E     196           -
LGA    -       -      S     197           -
LGA    -       -      P     198           -
LGA    -       -      A     199           -
LGA    -       -      G     200           -
LGA    -       -      I     201           -
LGA    -       -      K     202           -
LGA    G   112_A      P     203          2.457
LGA    F   113_A      D     204          1.952
LGA    H   114_A      T     205          1.466
LGA    V   115_A      L     206          1.326
LGA    T   116_A      F     207          0.926
LGA    P   117_A      L     208          1.533
LGA    V   118_A      Y     209          1.692
LGA    L   119_A      D     210          1.744
LGA    G   120_A      L     211          1.706
LGA    R   121_A      A     212          1.758
LGA    I   122_A      L     213          1.171
LGA    A   123_A      P     214          0.909
LGA    P   124_A      E     215          2.115
LGA    E   125_A      D     216          1.116
LGA    A   126_A      F     217          0.919
LGA    L   127_A      R     218          1.934
LGA    D   128_A      -       -           -
LGA    T   129_A      P     219          5.598
LGA    L   130_A      H     220          2.944
LGA    R   131_A      N     221          4.082
LGA    V   132_A      T     222          4.470
LGA    T   133_A      D     223          3.099
LGA    P   134_A      G     224          1.825
LGA    E   135_A      E     225          1.624
LGA    V   136_A      M     226          1.166
LGA    A   137_A      A     227          0.630
LGA    Q   138_A      D     228          0.988
LGA    I   139_A      F     229          0.544
LGA    I   140_A      M     230          1.955
LGA    T   141_A      L     231          2.248
LGA    P   142_A      W     232          2.108
LGA    T   143_A      P     233          1.539
LGA    L   144_A      A     234          1.068
LGA    A   145_A      A     235          2.793
LGA    E   146_A      K     236          2.446
LGA    L   147_A      V     237          3.021
LGA    R   148_A      V     238          4.335
LGA    A   149_A      E     239          5.129
LGA    V   150_A      -       -           -
LGA    P   151_A      -       -           -
LGA    L   152_A      -       -           -
LGA    V   153_A      -       -           -
LGA    R   154_A      -       -           -
LGA    E   155_A      -       -           -
LGA    R   156_A      -       -           -
LGA    R   157_A      -       -           -
LGA    T   158_A      -       -           -
LGA    L   159_A      -       -           -
LGA    P   160_A      -       -           -
LGA    D   161_A      -       -           -
LGA    G   162_A      -       -           -
LGA    T   163_A      -       -           -
LGA    E   164_A      -       -           -
LGA    V   165_A      -       -           -
LGA    P   166_A      -       -           -
LGA    L   167_A      -       -           -
LGA    Y   168_A      -       -           -
LGA    R   169_A      A     240           #
LGA    Y   170_A      V     241          1.959
LGA    -       -      R     242           -
LGA    -       -      T     243           -
LGA    P   171_A      T     244          3.800
LGA    W   172_A      -       -           -
LGA    R   173_A      -       -           -
LGA    G   174_A      -       -           -
LGA    L   175_A      -       -           -
LGA    D   176_A      E     245          3.876
LGA    I   177_A      A     246          3.052
LGA    W   178_A      F     247          3.576
LGA    -       -      K     248           -
LGA    G   179_A      F     249          1.856
LGA    M   180_A      N     250          0.789
LGA    T   181_A      V     251          0.716
LGA    A   182_A      N     252          1.057
LGA    R   183_A      L     253          1.164
LGA    V   184_A      T     254          0.884
LGA    L   185_A      V     255          0.166
LGA    H   186_A      I     256          0.969
LGA    D   187_A      D     257          1.159
LGA    L   188_A      F     258          0.451
LGA    L   189_A      A     259          0.575
LGA    E   190_A      I     260          1.061
LGA    -       -      R     261           -
LGA    -       -      H     262           -
LGA    -       -      G     263           -
LGA    -       -      L     264           -
LGA    -       -      I     265           -
LGA    -       -      D     266           -
LGA    -       -      P     267           -
LGA    -       -      D     268           -
LGA    -       -      N     269           -
LGA    -       -      E     270           -
LGA    -       -      P     271           -
LGA    -       -      D     272           -
LGA    -       -      Y     273           -
LGA    -       -      Q     274           -
LGA    -       -      E     275           -
LGA    -       -      I     276           -
LGA    -       -      L     277           -
LGA    -       -      A     278           -
LGA    -       -      G     279           -
LGA    -       -      L     280           -
LGA    -       -      R     281           -
LGA    -       -      G     282           -
LGA    -       -      R     283           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  171  208    5.0    128    2.31    13.28     44.852     5.318

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.175365 * X  +  -0.246606 * Y  +   0.953117 * Z  +  25.954449
  Y_new =  -0.400982 * X  +  -0.902072 * Y  +  -0.159621 * Z  +  78.405029
  Z_new =   0.899144 * X  +  -0.354191 * Y  +  -0.257077 * Z  +  -6.839140 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.198637    0.942955  [ DEG:  -125.9726     54.0274 ]
  Theta =  -1.117810   -2.023783  [ DEG:   -64.0458   -115.9542 ]
  Phi   =  -1.158521    1.983072  [ DEG:   -66.3784    113.6216 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1nqz_A                                        
REMARK     2: T0513_1_11_87_283.pdb                         
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1nqz_A.T0513_1_11_87_283.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  171  208   5.0  128   2.31   13.28  44.852
REMARK  ---------------------------------------------------------- 
MOLECULE 1nqz_A
HEADER    HYDROLASE                               23-JAN-03   1NQZ              
TITLE     THE STRUCTURE OF A COA PYROPHOSPHATASE FROM D. RADIODURANS            
TITLE    2 COMPLEXED WITH A MAGNESIUM ION                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: COA PYROPHOSPHATASE (MUTT/NUDIX FAMILY PROTEIN);           
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 3.6.1.9;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DEINOCOCCUS RADIODURANS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: DR1184;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    NUDIX, MUTT, PYROPHOSPHATASE, COA, D.RADIODURANS                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    L.W.KANG,S.B.GABELLI,M.A.BIANCHET,W.L.XU,M.J.BESSMAN,                 
AUTHOR   2 L.M.AMZEL                                                            
REVDAT   2   09-SEP-03 1NQZ    1       JRNL                                     
REVDAT   1   13-MAY-03 1NQZ    0                                                
JRNL        AUTH   L.W.KANG,S.B.GABELLI,M.A.BIANCHET,W.L.XU,                    
JRNL        AUTH 2 M.J.BESSMAN,L.M.AMZEL                                        
JRNL        TITL   STRUCTURE OF A COENZYME A PYROPHOSPHATASE FROM               
JRNL        TITL 2 DEINOCOCCUS RADIODURANS: A MEMBER OF THE NUDIX               
JRNL        TITL 3 FAMILY.                                                      
JRNL        REF    J.BACTERIOL.                  V. 185  4110 2003              
JRNL        REFN   ASTM JOBAAY  US ISSN 0021-9193                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1NQZ A    1   194  UNP    Q9RV46   Q9RV46_DEIRA     1    194             
SEQRES   1 A  194  MET THR ALA PRO HIS ASP PRO LEU ASP ASP ILE GLN ALA          
SEQRES   2 A  194  ASP PRO TRP ALA LEU TRP LEU SER GLY ARG THR ARG THR          
SEQRES   3 A  194  ALA LEU GLU LEU PRO HIS TYR ARG ARG ALA ALA VAL LEU          
SEQRES   4 A  194  VAL ALA LEU THR ARG GLU ALA ASP PRO ARG VAL LEU LEU          
SEQRES   5 A  194  THR VAL ARG SER SER GLU LEU PRO THR HIS LYS GLY GLN          
SEQRES   6 A  194  ILE ALA PHE PRO GLY GLY SER LEU ASP ALA GLY GLU THR          
SEQRES   7 A  194  PRO THR GLN ALA ALA LEU ARG GLU ALA GLN GLU GLU VAL          
SEQRES   8 A  194  ALA LEU ASP PRO ALA ALA VAL THR LEU LEU GLY GLU LEU          
SEQRES   9 A  194  ASP ASP VAL PHE THR PRO VAL GLY PHE HIS VAL THR PRO          
SEQRES  10 A  194  VAL LEU GLY ARG ILE ALA PRO GLU ALA LEU ASP THR LEU          
SEQRES  11 A  194  ARG VAL THR PRO GLU VAL ALA GLN ILE ILE THR PRO THR          
SEQRES  12 A  194  LEU ALA GLU LEU ARG ALA VAL PRO LEU VAL ARG GLU ARG          
SEQRES  13 A  194  ARG THR LEU PRO ASP GLY THR GLU VAL PRO LEU TYR ARG          
SEQRES  14 A  194  TYR PRO TRP ARG GLY LEU ASP ILE TRP GLY MET THR ALA          
SEQRES  15 A  194  ARG VAL LEU HIS ASP LEU LEU GLU GLN GLY PRO GLY              
HET     MG  A 201       1                                                       
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   2   MG    MG 2+                                                        
FORMUL   3  HOH   *123(H2 O)                                                    
CRYST1   40.618   94.066   43.664  90.00  90.00  90.00 P 21 21 2     4          
ATOM      1  N   PRO A   4      30.067  62.764   9.104  1.00 38.01           N  
ATOM      2  CA  PRO A   4      28.787  62.022   9.054  1.00 37.49           C  
ATOM      3  C   PRO A   4      28.840  60.809   9.976  1.00 37.37           C  
ATOM      4  O   PRO A   4      29.915  60.400  10.424  1.00 39.39           O  
ATOM      5  CB  PRO A   4      28.581  61.570   7.615  1.00 37.49           C  
ATOM      6  CG  PRO A   4      29.511  62.504   6.856  1.00 38.32           C  
ATOM      7  CD  PRO A   4      30.712  62.716   7.782  1.00 37.75           C  
ATOM      8  N   HIS A   5      27.673  60.235  10.249  1.00 35.32           N  
ATOM      9  CA  HIS A   5      27.563  59.063  11.108  1.00 32.43           C  
ATOM     10  C   HIS A   5      27.913  57.811  10.299  1.00 29.87           C  
ATOM     11  O   HIS A   5      27.475  57.656   9.155  1.00 28.63           O  
ATOM     12  CB  HIS A   5      26.141  58.982  11.673  1.00 34.41           C  
ATOM     13  CG  HIS A   5      25.797  57.657  12.277  1.00 35.95           C  
ATOM     14  ND1 HIS A   5      25.431  56.567  11.516  1.00 37.55           N  
ATOM     15  CD2 HIS A   5      25.757  57.248  13.568  1.00 36.10           C  
ATOM     16  CE1 HIS A   5      25.179  55.544  12.311  1.00 37.70           C  
ATOM     17  NE2 HIS A   5      25.369  55.931  13.561  1.00 37.99           N  
ATOM     18  N   ASP A   6      28.710  56.928  10.896  1.00 26.59           N  
ATOM     19  CA  ASP A   6      29.140  55.709  10.220  1.00 24.24           C  
ATOM     20  C   ASP A   6      28.747  54.451  10.986  1.00 22.62           C  
ATOM     21  O   ASP A   6      29.029  54.325  12.175  1.00 22.39           O  
ATOM     22  CB  ASP A   6      30.659  55.725  10.036  1.00 22.76           C  
ATOM     23  CG  ASP A   6      31.137  54.671   9.065  1.00 19.82           C  
ATOM     24  OD1 ASP A   6      30.674  53.521   9.153  1.00 19.06           O  
ATOM     25  OD2 ASP A   6      31.982  54.992   8.211  1.00 20.53           O  
ATOM     26  N   PRO A   7      28.097  53.495  10.303  1.00 23.02           N  
ATOM     27  CA  PRO A   7      27.664  52.239  10.921  1.00 21.87           C  
ATOM     28  C   PRO A   7      28.817  51.525  11.618  1.00 21.09           C  
ATOM     29  O   PRO A   7      28.611  50.819  12.600  1.00 20.42           O  
ATOM     30  CB  PRO A   7      27.133  51.439   9.737  1.00 22.08           C  
ATOM     31  CG  PRO A   7      26.627  52.494   8.821  1.00 23.75           C  
ATOM     32  CD  PRO A   7      27.709  53.535   8.881  1.00 23.36           C  
ATOM     33  N   LEU A   8      30.028  51.721  11.104  1.00 20.63           N  
ATOM     34  CA  LEU A   8      31.217  51.088  11.672  1.00 20.14           C  
ATOM     35  C   LEU A   8      31.397  51.488  13.130  1.00 20.34           C  
ATOM     36  O   LEU A   8      31.783  50.675  13.969  1.00 20.02           O  
ATOM     37  CB  LEU A   8      32.466  51.490  10.883  1.00 17.47           C  
ATOM     38  CG  LEU A   8      33.781  50.881  11.379  1.00 16.86           C  
ATOM     39  CD1 LEU A   8      33.785  49.383  11.112  1.00 17.48           C  
ATOM     40  CD2 LEU A   8      34.950  51.546  10.684  1.00 17.87           C  
ATOM     41  N   ASP A   9      31.118  52.748  13.430  1.00 21.94           N  
ATOM     42  CA  ASP A   9      31.263  53.232  14.790  1.00 24.40           C  
ATOM     43  C   ASP A   9      30.200  52.635  15.709  1.00 25.98           C  
ATOM     44  O   ASP A   9      30.428  52.463  16.908  1.00 26.16           O  
ATOM     45  CB  ASP A   9      31.218  54.758  14.805  1.00 25.20           C  
ATOM     46  CG  ASP A   9      32.368  55.377  14.021  1.00 27.58           C  
ATOM     47  OD1 ASP A   9      33.500  54.847  14.102  1.00 30.04           O  
ATOM     48  OD2 ASP A   9      32.152  56.396  13.335  1.00 29.46           O  
ATOM     49  N   ASP A  10      29.040  52.304  15.146  1.00 26.98           N  
ATOM     50  CA  ASP A  10      27.972  51.697  15.939  1.00 26.99           C  
ATOM     51  C   ASP A  10      28.381  50.281  16.334  1.00 26.26           C  
ATOM     52  O   ASP A  10      28.358  49.924  17.510  1.00 26.71           O  
ATOM     53  CB  ASP A  10      26.652  51.631  15.148  1.00 27.71           C  
ATOM     54  CG  ASP A  10      25.973  52.993  15.002  1.00 29.12           C  
ATOM     55  OD1 ASP A  10      26.018  53.796  15.957  1.00 28.80           O  
ATOM     56  OD2 ASP A  10      25.374  53.249  13.932  1.00 31.58           O  
ATOM     57  N   ILE A  11      28.761  49.480  15.341  1.00 25.08           N  
ATOM     58  CA  ILE A  11      29.149  48.097  15.581  1.00 24.42           C  
ATOM     59  C   ILE A  11      30.409  48.001  16.441  1.00 24.88           C  
ATOM     60  O   ILE A  11      30.559  47.073  17.239  1.00 23.81           O  
ATOM     61  CB  ILE A  11      29.346  47.339  14.229  1.00 25.08           C  
ATOM     62  CG1 ILE A  11      29.667  45.866  14.491  1.00 27.75           C  
ATOM     63  CG2 ILE A  11      30.446  47.984  13.404  1.00 25.25           C  
ATOM     64  CD1 ILE A  11      28.482  45.053  14.991  1.00 29.61           C  
ATOM     65  N   GLN A  12      31.300  48.977  16.289  1.00 26.03           N  
ATOM     66  CA  GLN A  12      32.550  49.028  17.043  1.00 27.10           C  
ATOM     67  C   GLN A  12      32.325  49.244  18.535  1.00 26.99           C  
ATOM     68  O   GLN A  12      33.172  48.892  19.352  1.00 27.50           O  
ATOM     69  CB  GLN A  12      33.435  50.157  16.523  1.00 28.57           C  
ATOM     70  CG  GLN A  12      34.650  49.709  15.755  1.00 30.30           C  
ATOM     71  CD  GLN A  12      35.705  50.801  15.683  1.00 31.49           C  
ATOM     72  OE1 GLN A  12      35.473  51.881  15.131  1.00 32.05           O  
ATOM     73  NE2 GLN A  12      36.872  50.528  16.255  1.00 32.02           N  
ATOM     74  N   ALA A  13      31.192  49.840  18.885  1.00 27.73           N  
ATOM     75  CA  ALA A  13      30.874  50.105  20.281  1.00 27.56           C  
ATOM     76  C   ALA A  13      30.002  48.999  20.878  1.00 28.75           C  
ATOM     77  O   ALA A  13      29.689  49.023  22.070  1.00 29.43           O  
ATOM     78  CB  ALA A  13      30.173  51.449  20.407  1.00 26.87           C  
ATOM     79  N   ASP A  14      29.614  48.035  20.043  1.00 28.05           N  
ATOM     80  CA  ASP A  14      28.785  46.913  20.485  1.00 28.17           C  
ATOM     81  C   ASP A  14      29.662  45.968  21.291  1.00 28.26           C  
ATOM     82  O   ASP A  14      30.462  45.220  20.730  1.00 27.54           O  
ATOM     83  CB  ASP A  14      28.198  46.179  19.276  1.00 28.42           C  
ATOM     84  CG  ASP A  14      27.231  45.075  19.674  1.00 30.46           C  
ATOM     85  OD1 ASP A  14      26.636  44.450  18.769  1.00 29.93           O  
ATOM     86  OD2 ASP A  14      27.066  44.829  20.890  1.00 29.32           O  
ATOM     87  N   PRO A  15      29.506  45.977  22.624  1.00 28.95           N  
ATOM     88  CA  PRO A  15      30.280  45.136  23.543  1.00 29.06           C  
ATOM     89  C   PRO A  15      30.231  43.642  23.237  1.00 30.26           C  
ATOM     90  O   PRO A  15      31.157  42.902  23.579  1.00 30.84           O  
ATOM     91  CB  PRO A  15      29.659  45.446  24.905  1.00 28.57           C  
ATOM     92  CG  PRO A  15      29.059  46.806  24.724  1.00 28.37           C  
ATOM     93  CD  PRO A  15      28.464  46.719  23.354  1.00 27.91           C  
ATOM     94  N   TRP A  16      29.156  43.207  22.585  1.00 30.03           N  
ATOM     95  CA  TRP A  16      28.973  41.792  22.284  1.00 30.14           C  
ATOM     96  C   TRP A  16      29.171  41.385  20.830  1.00 29.26           C  
ATOM     97  O   TRP A  16      28.944  40.228  20.480  1.00 30.20           O  
ATOM     98  CB  TRP A  16      27.585  41.360  22.765  1.00 30.50           C  
ATOM     99  CG  TRP A  16      27.248  41.996  24.063  1.00 30.94           C  
ATOM    100  CD1 TRP A  16      26.349  42.996  24.270  1.00 31.63           C  
ATOM    101  CD2 TRP A  16      27.889  41.764  25.324  1.00 33.03           C  
ATOM    102  NE1 TRP A  16      26.390  43.411  25.579  1.00 32.93           N  
ATOM    103  CE2 TRP A  16      27.327  42.670  26.249  1.00 33.35           C  
ATOM    104  CE3 TRP A  16      28.888  40.880  25.762  1.00 34.16           C  
ATOM    105  CZ2 TRP A  16      27.730  42.720  27.592  1.00 34.23           C  
ATOM    106  CZ3 TRP A  16      29.290  40.930  27.098  1.00 34.84           C  
ATOM    107  CH2 TRP A  16      28.709  41.846  27.994  1.00 34.25           C  
ATOM    108  N   ALA A  17      29.579  42.324  19.982  1.00 27.04           N  
ATOM    109  CA  ALA A  17      29.833  42.006  18.582  1.00 25.51           C  
ATOM    110  C   ALA A  17      31.196  41.325  18.579  1.00 24.82           C  
ATOM    111  O   ALA A  17      32.184  41.905  19.033  1.00 24.33           O  
ATOM    112  CB  ALA A  17      29.871  43.276  17.747  1.00 26.10           C  
ATOM    113  N   LEU A  18      31.253  40.094  18.088  1.00 22.59           N  
ATOM    114  CA  LEU A  18      32.511  39.360  18.078  1.00 22.45           C  
ATOM    115  C   LEU A  18      33.294  39.564  16.787  1.00 21.92           C  
ATOM    116  O   LEU A  18      32.738  39.523  15.690  1.00 21.79           O  
ATOM    117  CB  LEU A  18      32.258  37.864  18.311  1.00 22.41           C  
ATOM    118  CG  LEU A  18      31.535  37.459  19.604  1.00 22.82           C  
ATOM    119  CD1 LEU A  18      31.459  35.935  19.698  1.00 23.61           C  
ATOM    120  CD2 LEU A  18      32.263  38.021  20.808  1.00 23.95           C  
ATOM    121  N   TRP A  19      34.595  39.779  16.940  1.00 21.32           N  
ATOM    122  CA  TRP A  19      35.480  39.997  15.809  1.00 20.00           C  
ATOM    123  C   TRP A  19      36.483  38.877  15.636  1.00 21.24           C  
ATOM    124  O   TRP A  19      37.088  38.421  16.603  1.00 20.27           O  
ATOM    125  CB  TRP A  19      36.215  41.321  15.978  1.00 18.55           C  
ATOM    126  CG  TRP A  19      35.287  42.472  15.951  1.00 17.18           C  
ATOM    127  CD1 TRP A  19      34.657  43.051  17.017  1.00 15.88           C  
ATOM    128  CD2 TRP A  19      34.828  43.162  14.787  1.00 16.02           C  
ATOM    129  NE1 TRP A  19      33.833  44.062  16.585  1.00 16.60           N  
ATOM    130  CE2 TRP A  19      33.920  44.152  15.219  1.00 16.74           C  
ATOM    131  CE3 TRP A  19      35.099  43.038  13.417  1.00 15.16           C  
ATOM    132  CZ2 TRP A  19      33.277  45.016  14.326  1.00 17.09           C  
ATOM    133  CZ3 TRP A  19      34.462  43.894  12.529  1.00 15.79           C  
ATOM    134  CH2 TRP A  19      33.561  44.872  12.986  1.00 16.76           C  
ATOM    135  N   LEU A  20      36.647  38.441  14.393  1.00 22.71           N  
ATOM    136  CA  LEU A  20      37.578  37.373  14.059  1.00 26.85           C  
ATOM    137  C   LEU A  20      38.181  37.620  12.677  1.00 29.99           C  
ATOM    138  O   LEU A  20      37.845  38.601  12.017  1.00 30.97           O  
ATOM    139  CB  LEU A  20      36.860  36.023  14.083  1.00 27.01           C  
ATOM    140  CG  LEU A  20      35.588  35.841  13.251  1.00 26.92           C  
ATOM    141  CD1 LEU A  20      35.238  34.363  13.183  1.00 27.28           C  
ATOM    142  CD2 LEU A  20      34.440  36.627  13.861  1.00 29.31           C  
ATOM    143  N   SER A  21      39.076  36.739  12.242  1.00 32.58           N  
ATOM    144  CA  SER A  21      39.702  36.880  10.929  1.00 37.09           C  
ATOM    145  C   SER A  21      40.185  35.531  10.419  1.00 39.39           C  
ATOM    146  O   SER A  21      41.200  35.018  10.880  1.00 41.76           O  
ATOM    147  CB  SER A  21      40.879  37.869  10.992  1.00 37.84           C  
ATOM    148  OG  SER A  21      41.776  37.570  12.049  1.00 39.73           O  
ATOM    149  N   GLY A  22      39.445  34.961   9.471  1.00 41.36           N  
ATOM    150  CA  GLY A  22      39.811  33.665   8.917  1.00 42.59           C  
ATOM    151  C   GLY A  22      38.639  32.918   8.302  1.00 42.73           C  
ATOM    152  O   GLY A  22      38.276  31.821   8.740  1.00 43.52           O  
ATOM    153  N   TYR A  33      28.833  41.665   4.891  1.00 38.80           N  
ATOM    154  CA  TYR A  33      28.765  42.226   3.555  1.00 37.02           C  
ATOM    155  C   TYR A  33      29.107  43.706   3.526  1.00 34.62           C  
ATOM    156  O   TYR A  33      29.398  44.258   2.465  1.00 33.97           O  
ATOM    157  CB  TYR A  33      27.377  42.004   2.956  1.00 42.21           C  
ATOM    158  CG  TYR A  33      27.269  40.713   2.190  1.00 47.99           C  
ATOM    159  CD1 TYR A  33      27.238  39.483   2.852  1.00 49.95           C  
ATOM    160  CD2 TYR A  33      27.251  40.714   0.794  1.00 50.23           C  
ATOM    161  CE1 TYR A  33      27.197  38.285   2.142  1.00 52.23           C  
ATOM    162  CE2 TYR A  33      27.212  39.525   0.072  1.00 52.65           C  
ATOM    163  CZ  TYR A  33      27.186  38.314   0.752  1.00 53.59           C  
ATOM    164  OH  TYR A  33      27.156  37.139   0.034  1.00 55.57           O  
ATOM    165  N   ARG A  34      29.057  44.360   4.679  1.00 31.05           N  
ATOM    166  CA  ARG A  34      29.402  45.774   4.724  1.00 28.42           C  
ATOM    167  C   ARG A  34      30.911  45.891   4.849  1.00 25.55           C  
ATOM    168  O   ARG A  34      31.521  45.291   5.732  1.00 24.08           O  
ATOM    169  CB  ARG A  34      28.705  46.469   5.893  1.00 29.23           C  
ATOM    170  CG  ARG A  34      27.270  46.830   5.577  1.00 34.47           C  
ATOM    171  CD  ARG A  34      26.572  47.503   6.738  1.00 37.21           C  
ATOM    172  NE  ARG A  34      26.412  46.599   7.868  1.00 40.19           N  
ATOM    173  CZ  ARG A  34      25.791  46.925   8.997  1.00 42.67           C  
ATOM    174  NH1 ARG A  34      25.269  48.137   9.137  1.00 42.71           N  
ATOM    175  NH2 ARG A  34      25.697  46.041   9.986  1.00 43.37           N  
ATOM    176  N   ARG A  35      31.511  46.658   3.948  1.00 22.49           N  
ATOM    177  CA  ARG A  35      32.953  46.828   3.946  1.00 19.05           C  
ATOM    178  C   ARG A  35      33.412  48.153   4.528  1.00 18.44           C  
ATOM    179  O   ARG A  35      32.791  49.197   4.314  1.00 17.72           O  
ATOM    180  CB  ARG A  35      33.480  46.684   2.522  1.00 19.77           C  
ATOM    181  CG  ARG A  35      33.190  45.327   1.911  1.00 19.79           C  
ATOM    182  CD  ARG A  35      33.593  45.318   0.477  1.00 21.40           C  
ATOM    183  NE  ARG A  35      35.034  45.457   0.333  1.00 26.07           N  
ATOM    184  CZ  ARG A  35      35.618  46.064  -0.695  1.00 28.07           C  
ATOM    185  NH1 ARG A  35      34.874  46.595  -1.663  1.00 27.43           N  
ATOM    186  NH2 ARG A  35      36.940  46.127  -0.763  1.00 28.51           N  
ATOM    187  N   ALA A  36      34.509  48.092   5.275  1.00 15.95           N  
ATOM    188  CA  ALA A  36      35.090  49.269   5.894  1.00 13.51           C  
ATOM    189  C   ALA A  36      36.598  49.082   5.948  1.00 13.02           C  
ATOM    190  O   ALA A  36      37.118  48.011   5.620  1.00 12.33           O  
ATOM    191  CB  ALA A  36      34.530  49.456   7.303  1.00 12.86           C  
ATOM    192  N   ALA A  37      37.300  50.126   6.359  1.00 12.56           N  
ATOM    193  CA  ALA A  37      38.747  50.055   6.456  1.00 10.60           C  
ATOM    194  C   ALA A  37      39.243  50.965   7.563  1.00 10.31           C  
ATOM    195  O   ALA A  37      38.597  51.952   7.921  1.00  9.97           O  
ATOM    196  CB  ALA A  37      39.387  50.456   5.120  1.00  8.53           C  
ATOM    197  N   VAL A  38      40.385  50.607   8.127  1.00  9.49           N  
ATOM    198  CA  VAL A  38      40.988  51.423   9.160  1.00 10.07           C  
ATOM    199  C   VAL A  38      42.446  51.590   8.774  1.00 10.56           C  
ATOM    200  O   VAL A  38      43.024  50.721   8.112  1.00  9.61           O  
ATOM    201  CB  VAL A  38      40.900  50.766  10.570  1.00 10.57           C  
ATOM    202  CG1 VAL A  38      39.443  50.663  11.005  1.00  9.11           C  
ATOM    203  CG2 VAL A  38      41.562  49.390  10.564  1.00  8.54           C  
ATOM    204  N   LEU A  39      43.026  52.731   9.136  1.00 10.02           N  
ATOM    205  CA  LEU A  39      44.432  52.957   8.855  1.00  9.57           C  
ATOM    206  C   LEU A  39      45.191  52.548  10.115  1.00 10.07           C  
ATOM    207  O   LEU A  39      44.814  52.915  11.233  1.00  9.25           O  
ATOM    208  CB  LEU A  39      44.710  54.432   8.530  1.00  9.89           C  
ATOM    209  CG  LEU A  39      46.171  54.748   8.179  1.00  9.95           C  
ATOM    210  CD1 LEU A  39      46.575  53.976   6.929  1.00 10.58           C  
ATOM    211  CD2 LEU A  39      46.354  56.232   7.951  1.00  8.85           C  
ATOM    212  N   VAL A  40      46.226  51.740   9.924  1.00 10.15           N  
ATOM    213  CA  VAL A  40      47.066  51.283  11.019  1.00 10.29           C  
ATOM    214  C   VAL A  40      48.433  51.868  10.702  1.00 10.48           C  
ATOM    215  O   VAL A  40      49.268  51.224  10.069  1.00 10.83           O  
ATOM    216  CB  VAL A  40      47.149  49.735  11.069  1.00 10.66           C  
ATOM    217  CG1 VAL A  40      48.009  49.286  12.258  1.00  8.62           C  
ATOM    218  CG2 VAL A  40      45.745  49.148  11.184  1.00 10.99           C  
ATOM    219  N   ALA A  41      48.635  53.110  11.127  1.00 10.93           N  
ATOM    220  CA  ALA A  41      49.891  53.812  10.884  1.00 12.03           C  
ATOM    221  C   ALA A  41      50.901  53.576  12.000  1.00 11.82           C  
ATOM    222  O   ALA A  41      50.596  53.757  13.171  1.00 11.19           O  
ATOM    223  CB  ALA A  41      49.631  55.310  10.728  1.00 11.23           C  
ATOM    224  N   LEU A  42      52.103  53.168  11.609  1.00 12.79           N  
ATOM    225  CA  LEU A  42      53.209  52.904  12.526  1.00 12.96           C  
ATOM    226  C   LEU A  42      54.323  53.910  12.225  1.00 13.89           C  
ATOM    227  O   LEU A  42      54.618  54.180  11.062  1.00 12.73           O  
ATOM    228  CB  LEU A  42      53.750  51.492  12.297  1.00 15.14           C  
ATOM    229  CG  LEU A  42      52.978  50.246  12.736  1.00 18.95           C  
ATOM    230  CD1 LEU A  42      51.483  50.478  12.747  1.00 21.67           C  
ATOM    231  CD2 LEU A  42      53.357  49.111  11.790  1.00 20.66           C  
ATOM    232  N   THR A  43      54.944  54.462  13.265  1.00 14.90           N  
ATOM    233  CA  THR A  43      56.024  55.425  13.061  1.00 16.36           C  
ATOM    234  C   THR A  43      57.291  54.693  12.646  1.00 18.33           C  
ATOM    235  O   THR A  43      57.509  53.534  13.035  1.00 18.02           O  
ATOM    236  CB  THR A  43      56.346  56.228  14.338  1.00 15.17           C  
ATOM    237  OG1 THR A  43      56.696  55.326  15.394  1.00 16.43           O  
ATOM    238  CG2 THR A  43      55.153  57.070  14.760  1.00 13.11           C  
ATOM    239  N   ARG A  44      58.111  55.371  11.847  1.00 19.32           N  
ATOM    240  CA  ARG A  44      59.371  54.820  11.373  1.00 20.56           C  
ATOM    241  C   ARG A  44      60.435  55.114  12.431  1.00 22.08           C  
ATOM    242  O   ARG A  44      61.168  56.100  12.334  1.00 20.97           O  
ATOM    243  CB  ARG A  44      59.757  55.469  10.043  1.00 20.80           C  
ATOM    244  CG  ARG A  44      60.940  54.809   9.342  1.00 23.87           C  
ATOM    245  CD  ARG A  44      61.221  55.433   7.971  1.00 25.17           C  
ATOM    246  NE  ARG A  44      60.104  55.287   7.034  1.00 28.37           N  
ATOM    247  CZ  ARG A  44      59.172  56.215   6.813  1.00 27.70           C  
ATOM    248  NH1 ARG A  44      59.211  57.378   7.456  1.00 26.90           N  
ATOM    249  NH2 ARG A  44      58.196  55.976   5.946  1.00 27.81           N  
ATOM    250  N   GLU A  45      60.496  54.267  13.456  1.00 22.95           N  
ATOM    251  CA  GLU A  45      61.466  54.444  14.524  1.00 24.53           C  
ATOM    252  C   GLU A  45      61.785  53.133  15.233  1.00 26.20           C  
ATOM    253  O   GLU A  45      61.177  52.099  14.957  1.00 25.54           O  
ATOM    254  CB  GLU A  45      60.961  55.488  15.528  1.00 25.77           C  
ATOM    255  CG  GLU A  45      59.641  55.167  16.203  1.00 23.56           C  
ATOM    256  CD  GLU A  45      59.183  56.301  17.104  1.00 22.83           C  
ATOM    257  OE1 GLU A  45      60.006  56.761  17.915  1.00 25.63           O  
ATOM    258  OE2 GLU A  45      58.012  56.731  17.013  1.00 20.03           O  
ATOM    259  N   ALA A  46      62.752  53.192  16.141  1.00 27.46           N  
ATOM    260  CA  ALA A  46      63.195  52.030  16.897  1.00 28.77           C  
ATOM    261  C   ALA A  46      62.033  51.301  17.554  1.00 29.70           C  
ATOM    262  O   ALA A  46      61.803  50.116  17.294  1.00 31.52           O  
ATOM    263  CB  ALA A  46      64.198  52.465  17.952  1.00 30.70           C  
ATOM    264  N   ASP A  47      61.319  52.020  18.415  1.00 29.39           N  
ATOM    265  CA  ASP A  47      60.159  51.489  19.134  1.00 28.01           C  
ATOM    266  C   ASP A  47      58.934  52.140  18.492  1.00 24.47           C  
ATOM    267  O   ASP A  47      58.447  53.164  18.967  1.00 23.66           O  
ATOM    268  CB  ASP A  47      60.250  51.862  20.622  1.00 29.56           C  
ATOM    269  CG  ASP A  47      59.212  51.155  21.468  1.00 30.40           C  
ATOM    270  OD1 ASP A  47      58.678  50.126  21.014  1.00 33.33           O  
ATOM    271  OD2 ASP A  47      58.942  51.614  22.595  1.00 32.65           O  
ATOM    272  N   PRO A  48      58.425  51.543  17.402  1.00 23.58           N  
ATOM    273  CA  PRO A  48      57.264  52.051  16.666  1.00 22.28           C  
ATOM    274  C   PRO A  48      56.040  52.346  17.505  1.00 20.23           C  
ATOM    275  O   PRO A  48      55.682  51.581  18.396  1.00 20.31           O  
ATOM    276  CB  PRO A  48      56.991  50.949  15.644  1.00 22.17           C  
ATOM    277  CG  PRO A  48      58.317  50.329  15.442  1.00 22.73           C  
ATOM    278  CD  PRO A  48      58.851  50.248  16.845  1.00 23.33           C  
ATOM    279  N   ARG A  49      55.407  53.474  17.218  1.00 18.80           N  
ATOM    280  CA  ARG A  49      54.185  53.858  17.904  1.00 17.60           C  
ATOM    281  C   ARG A  49      53.074  53.670  16.889  1.00 15.46           C  
ATOM    282  O   ARG A  49      53.303  53.787  15.683  1.00 15.24           O  
ATOM    283  CB  ARG A  49      54.248  55.313  18.358  1.00 18.56           C  
ATOM    284  CG  ARG A  49      55.070  55.511  19.618  1.00 22.55           C  
ATOM    285  CD  ARG A  49      55.202  56.977  19.956  1.00 23.31           C  
ATOM    286  NE  ARG A  49      56.104  57.654  19.033  1.00 26.68           N  
ATOM    287  CZ  ARG A  49      56.229  58.973  18.952  1.00 28.36           C  
ATOM    288  NH1 ARG A  49      55.503  59.761  19.741  1.00 28.00           N  
ATOM    289  NH2 ARG A  49      57.082  59.502  18.083  1.00 28.83           N  
ATOM    290  N   VAL A  50      51.881  53.351  17.374  1.00 15.26           N  
ATOM    291  CA  VAL A  50      50.734  53.145  16.504  1.00 12.50           C  
ATOM    292  C   VAL A  50      49.758  54.296  16.707  1.00 12.13           C  
ATOM    293  O   VAL A  50      49.464  54.690  17.835  1.00 13.38           O  
ATOM    294  CB  VAL A  50      50.030  51.787  16.804  1.00 13.26           C  
ATOM    295  CG1 VAL A  50      49.479  51.777  18.215  1.00 14.90           C  
ATOM    296  CG2 VAL A  50      48.929  51.527  15.783  1.00 10.97           C  
ATOM    297  N   LEU A  51      49.270  54.849  15.607  1.00 10.25           N  
ATOM    298  CA  LEU A  51      48.332  55.959  15.676  1.00 11.29           C  
ATOM    299  C   LEU A  51      46.921  55.490  16.021  1.00 11.32           C  
ATOM    300  O   LEU A  51      46.272  54.789  15.238  1.00 11.71           O  
ATOM    301  CB  LEU A  51      48.314  56.726  14.345  1.00 10.21           C  
ATOM    302  CG  LEU A  51      47.294  57.858  14.174  1.00 11.86           C  
ATOM    303  CD1 LEU A  51      47.480  58.911  15.259  1.00 12.24           C  
ATOM    304  CD2 LEU A  51      47.463  58.467  12.790  1.00 10.85           C  
ATOM    305  N   LEU A  52      46.453  55.884  17.199  1.00  9.33           N  
ATOM    306  CA  LEU A  52      45.115  55.532  17.641  1.00 10.37           C  
ATOM    307  C   LEU A  52      44.383  56.789  18.081  1.00 10.58           C  
ATOM    308  O   LEU A  52      44.998  57.825  18.347  1.00 11.26           O  
ATOM    309  CB  LEU A  52      45.173  54.528  18.796  1.00  9.30           C  
ATOM    310  CG  LEU A  52      45.447  53.082  18.383  1.00  8.94           C  
ATOM    311  CD1 LEU A  52      45.768  52.245  19.602  1.00  9.95           C  
ATOM    312  CD2 LEU A  52      44.231  52.533  17.663  1.00  8.67           C  
ATOM    313  N   THR A  53      43.064  56.697  18.153  1.00 12.12           N  
ATOM    314  CA  THR A  53      42.263  57.836  18.554  1.00 13.10           C  
ATOM    315  C   THR A  53      41.300  57.466  19.670  1.00 13.67           C  
ATOM    316  O   THR A  53      40.968  56.293  19.875  1.00 11.65           O  
ATOM    317  CB  THR A  53      41.395  58.373  17.381  1.00 13.69           C  
ATOM    318  OG1 THR A  53      40.420  57.384  17.021  1.00 12.09           O  
ATOM    319  CG2 THR A  53      42.257  58.721  16.164  1.00 14.37           C  
ATOM    320  N   VAL A  54      40.883  58.482  20.409  1.00 13.83           N  
ATOM    321  CA  VAL A  54      39.891  58.310  21.449  1.00 15.70           C  
ATOM    322  C   VAL A  54      38.770  59.180  20.905  1.00 16.93           C  
ATOM    323  O   VAL A  54      38.941  60.385  20.739  1.00 15.98           O  
ATOM    324  CB  VAL A  54      40.352  58.855  22.808  1.00 14.77           C  
ATOM    325  CG1 VAL A  54      39.189  58.831  23.775  1.00 14.61           C  
ATOM    326  CG2 VAL A  54      41.499  58.010  23.355  1.00 14.74           C  
ATOM    327  N   ARG A  55      37.637  58.569  20.585  1.00 20.64           N  
ATOM    328  CA  ARG A  55      36.524  59.327  20.029  1.00 24.48           C  
ATOM    329  C   ARG A  55      35.804  60.178  21.074  1.00 25.87           C  
ATOM    330  O   ARG A  55      35.732  59.820  22.252  1.00 26.22           O  
ATOM    331  CB  ARG A  55      35.543  58.379  19.328  1.00 25.44           C  
ATOM    332  CG  ARG A  55      36.167  57.598  18.171  1.00 26.98           C  
ATOM    333  CD  ARG A  55      36.899  58.527  17.199  1.00 29.79           C  
ATOM    334  NE  ARG A  55      37.612  57.798  16.150  1.00 32.26           N  
ATOM    335  CZ  ARG A  55      37.023  57.205  15.115  1.00 33.82           C  
ATOM    336  NH1 ARG A  55      35.704  57.258  14.979  1.00 33.89           N  
ATOM    337  NH2 ARG A  55      37.753  56.549  14.221  1.00 34.54           N  
ATOM    338  N   SER A  56      35.284  61.316  20.625  1.00 28.58           N  
ATOM    339  CA  SER A  56      34.576  62.252  21.496  1.00 30.70           C  
ATOM    340  C   SER A  56      33.202  61.729  21.901  1.00 31.96           C  
ATOM    341  O   SER A  56      32.666  60.822  21.264  1.00 34.27           O  
ATOM    342  CB  SER A  56      34.429  63.600  20.786  1.00 30.18           C  
ATOM    343  OG  SER A  56      33.868  63.431  19.496  1.00 32.88           O  
ATOM    344  N   LYS A  63      33.700  56.993  29.166  1.00 43.59           N  
ATOM    345  CA  LYS A  63      34.953  56.722  28.472  1.00 43.13           C  
ATOM    346  C   LYS A  63      34.752  56.672  26.954  1.00 41.92           C  
ATOM    347  O   LYS A  63      33.817  56.033  26.460  1.00 42.03           O  
ATOM    348  CB  LYS A  63      35.545  55.400  28.966  1.00 44.85           C  
ATOM    349  CG  LYS A  63      35.818  55.384  30.459  1.00 47.26           C  
ATOM    350  CD  LYS A  63      36.299  54.022  30.920  1.00 50.52           C  
ATOM    351  CE  LYS A  63      36.571  54.017  32.415  1.00 52.42           C  
ATOM    352  NZ  LYS A  63      37.080  52.697  32.884  1.00 54.87           N  
ATOM    353  N   GLY A  64      35.635  57.353  26.221  1.00 39.23           N  
ATOM    354  CA  GLY A  64      35.541  57.383  24.770  1.00 33.90           C  
ATOM    355  C   GLY A  64      35.989  56.108  24.077  1.00 30.64           C  
ATOM    356  O   GLY A  64      36.842  55.371  24.571  1.00 30.64           O  
ATOM    357  N   GLN A  65      35.397  55.850  22.919  1.00 28.06           N  
ATOM    358  CA  GLN A  65      35.711  54.676  22.118  1.00 25.65           C  
ATOM    359  C   GLN A  65      37.115  54.788  21.514  1.00 22.84           C  
ATOM    360  O   GLN A  65      37.403  55.738  20.782  1.00 22.69           O  
ATOM    361  CB  GLN A  65      34.673  54.559  20.999  1.00 28.69           C  
ATOM    362  CG  GLN A  65      35.068  53.681  19.825  1.00 33.42           C  
ATOM    363  CD  GLN A  65      34.839  52.211  20.090  1.00 35.96           C  
ATOM    364  OE1 GLN A  65      33.760  51.810  20.535  1.00 39.39           O  
ATOM    365  NE2 GLN A  65      35.846  51.394  19.803  1.00 35.68           N  
ATOM    366  N   ILE A  66      37.991  53.836  21.828  1.00 19.60           N  
ATOM    367  CA  ILE A  66      39.340  53.846  21.267  1.00 17.19           C  
ATOM    368  C   ILE A  66      39.298  53.121  19.926  1.00 15.78           C  
ATOM    369  O   ILE A  66      38.833  51.985  19.845  1.00 15.56           O  
ATOM    370  CB  ILE A  66      40.357  53.139  22.188  1.00 17.42           C  
ATOM    371  CG1 ILE A  66      40.442  53.883  23.526  1.00 18.60           C  
ATOM    372  CG2 ILE A  66      41.731  53.092  21.515  1.00 13.10           C  
ATOM    373  CD1 ILE A  66      41.380  53.244  24.519  1.00 19.50           C  
ATOM    374  N   ALA A  67      39.788  53.772  18.876  1.00 13.82           N  
ATOM    375  CA  ALA A  67      39.755  53.180  17.548  1.00 11.53           C  
ATOM    376  C   ALA A  67      40.825  53.735  16.625  1.00 11.93           C  
ATOM    377  O   ALA A  67      41.422  54.775  16.902  1.00 11.57           O  
ATOM    378  CB  ALA A  67      38.389  53.420  16.931  1.00 11.11           C  
ATOM    379  N   PHE A  68      41.071  53.022  15.531  1.00 11.33           N  
ATOM    380  CA  PHE A  68      42.025  53.476  14.524  1.00 11.81           C  
ATOM    381  C   PHE A  68      41.232  54.428  13.638  1.00 11.57           C  
ATOM    382  O   PHE A  68      40.008  54.363  13.610  1.00  9.90           O  
ATOM    383  CB  PHE A  68      42.472  52.331  13.609  1.00 11.34           C  
ATOM    384  CG  PHE A  68      43.375  51.332  14.254  1.00 10.98           C  
ATOM    385  CD1 PHE A  68      42.902  50.065  14.592  1.00 12.39           C  
ATOM    386  CD2 PHE A  68      44.713  51.633  14.476  1.00 11.71           C  
ATOM    387  CE1 PHE A  68      43.753  49.108  15.137  1.00 11.33           C  
ATOM    388  CE2 PHE A  68      45.573  50.681  15.024  1.00 12.32           C  
ATOM    389  CZ  PHE A  68      45.090  49.421  15.352  1.00 11.53           C  
ATOM    390  N   PRO A  69      41.913  55.335  12.920  1.00 12.02           N  
ATOM    391  CA  PRO A  69      41.166  56.241  12.039  1.00 12.37           C  
ATOM    392  C   PRO A  69      40.512  55.290  11.039  1.00 12.93           C  
ATOM    393  O   PRO A  69      41.147  54.316  10.625  1.00 14.73           O  
ATOM    394  CB  PRO A  69      42.268  57.057  11.367  1.00 10.98           C  
ATOM    395  CG  PRO A  69      43.323  57.115  12.423  1.00 11.39           C  
ATOM    396  CD  PRO A  69      43.331  55.721  13.008  1.00 11.47           C  
ATOM    397  N   GLY A  70      39.264  55.534  10.660  1.00 12.99           N  
ATOM    398  CA  GLY A  70      38.637  54.630   9.708  1.00 12.75           C  
ATOM    399  C   GLY A  70      37.162  54.862   9.467  1.00 12.54           C  
ATOM    400  O   GLY A  70      36.580  55.824   9.969  1.00 12.66           O  
ATOM    401  N   GLY A  71      36.559  53.973   8.683  1.00 12.27           N  
ATOM    402  CA  GLY A  71      35.150  54.092   8.378  1.00 12.72           C  
ATOM    403  C   GLY A  71      34.764  53.191   7.227  1.00 14.73           C  
ATOM    404  O   GLY A  71      35.609  52.472   6.677  1.00 13.97           O  
ATOM    405  N   SER A  72      33.483  53.231   6.862  1.00 16.25           N  
ATOM    406  CA  SER A  72      32.958  52.428   5.766  1.00 15.61           C  
ATOM    407  C   SER A  72      33.446  52.957   4.423  1.00 15.33           C  
ATOM    408  O   SER A  72      33.643  54.158   4.255  1.00 15.14           O  
ATOM    409  CB  SER A  72      31.427  52.451   5.781  1.00 17.39           C  
ATOM    410  OG  SER A  72      30.907  51.920   6.987  1.00 19.25           O  
ATOM    411  N   LEU A  73      33.648  52.057   3.466  1.00 15.62           N  
ATOM    412  CA  LEU A  73      34.085  52.474   2.142  1.00 16.60           C  
ATOM    413  C   LEU A  73      32.920  53.183   1.464  1.00 18.09           C  
ATOM    414  O   LEU A  73      31.784  52.723   1.552  1.00 18.88           O  
ATOM    415  CB  LEU A  73      34.466  51.269   1.280  1.00 15.95           C  
ATOM    416  CG  LEU A  73      35.358  50.173   1.860  1.00 17.49           C  
ATOM    417  CD1 LEU A  73      35.802  49.260   0.735  1.00 15.75           C  
ATOM    418  CD2 LEU A  73      36.558  50.775   2.548  1.00 15.71           C  
ATOM    419  N   ASP A  74      33.187  54.309   0.812  1.00 19.49           N  
ATOM    420  CA  ASP A  74      32.131  55.004   0.087  1.00 19.87           C  
ATOM    421  C   ASP A  74      31.983  54.203  -1.199  1.00 18.69           C  
ATOM    422  O   ASP A  74      32.792  53.319  -1.473  1.00 18.70           O  
ATOM    423  CB  ASP A  74      32.534  56.445  -0.250  1.00 22.76           C  
ATOM    424  CG  ASP A  74      32.536  57.349   0.962  1.00 25.42           C  
ATOM    425  OD1 ASP A  74      31.757  57.082   1.901  1.00 27.29           O  
ATOM    426  OD2 ASP A  74      33.302  58.337   0.967  1.00 28.03           O  
ATOM    427  N   ALA A  75      30.961  54.506  -1.990  1.00 19.09           N  
ATOM    428  CA  ALA A  75      30.754  53.780  -3.237  1.00 19.10           C  
ATOM    429  C   ALA A  75      31.927  54.017  -4.175  1.00 17.50           C  
ATOM    430  O   ALA A  75      32.379  55.148  -4.335  1.00 18.04           O  
ATOM    431  CB  ALA A  75      29.449  54.225  -3.897  1.00 20.54           C  
ATOM    432  N   GLY A  76      32.418  52.941  -4.784  1.00 16.20           N  
ATOM    433  CA  GLY A  76      33.532  53.045  -5.711  1.00 16.20           C  
ATOM    434  C   GLY A  76      34.888  53.355  -5.095  1.00 15.03           C  
ATOM    435  O   GLY A  76      35.861  53.563  -5.810  1.00 16.36           O  
ATOM    436  N   GLU A  77      34.957  53.376  -3.770  1.00 15.28           N  
ATOM    437  CA  GLU A  77      36.202  53.662  -3.056  1.00 15.57           C  
ATOM    438  C   GLU A  77      36.836  52.365  -2.537  1.00 15.25           C  
ATOM    439  O   GLU A  77      36.137  51.492  -2.024  1.00 17.11           O  
ATOM    440  CB  GLU A  77      35.892  54.603  -1.885  1.00 16.98           C  
ATOM    441  CG  GLU A  77      37.074  55.065  -1.071  1.00 14.41           C  
ATOM    442  CD  GLU A  77      36.638  55.942   0.091  1.00 16.36           C  
ATOM    443  OE1 GLU A  77      35.763  55.507   0.862  1.00 14.61           O  
ATOM    444  OE2 GLU A  77      37.165  57.063   0.237  1.00 16.82           O  
ATOM    445  N   THR A  78      38.154  52.243  -2.666  1.00 14.03           N  
ATOM    446  CA  THR A  78      38.868  51.051  -2.201  1.00 13.46           C  
ATOM    447  C   THR A  78      39.194  51.131  -0.707  1.00 12.61           C  
ATOM    448  O   THR A  78      39.062  52.186  -0.088  1.00 12.79           O  
ATOM    449  CB  THR A  78      40.210  50.861  -2.945  1.00 13.03           C  
ATOM    450  OG1 THR A  78      41.091  51.944  -2.617  1.00 12.42           O  
ATOM    451  CG2 THR A  78      39.998  50.818  -4.444  1.00 13.07           C  
ATOM    452  N   PRO A  79      39.628  50.012  -0.110  1.00 12.76           N  
ATOM    453  CA  PRO A  79      39.961  50.035   1.316  1.00 12.27           C  
ATOM    454  C   PRO A  79      41.064  51.058   1.604  1.00 12.04           C  
ATOM    455  O   PRO A  79      40.966  51.847   2.547  1.00 13.24           O  
ATOM    456  CB  PRO A  79      40.412  48.601   1.584  1.00 11.22           C  
ATOM    457  CG  PRO A  79      39.546  47.799   0.650  1.00 12.50           C  
ATOM    458  CD  PRO A  79      39.615  48.628  -0.627  1.00 12.02           C  
ATOM    459  N   THR A  80      42.110  51.050   0.785  1.00 11.14           N  
ATOM    460  CA  THR A  80      43.219  51.976   0.975  1.00 10.72           C  
ATOM    461  C   THR A  80      42.768  53.431   0.879  1.00  9.89           C  
ATOM    462  O   THR A  80      43.148  54.250   1.708  1.00 10.08           O  
ATOM    463  CB  THR A  80      44.345  51.699  -0.042  1.00 12.94           C  
ATOM    464  OG1 THR A  80      44.778  50.342   0.101  1.00 11.61           O  
ATOM    465  CG2 THR A  80      45.532  52.625   0.199  1.00 11.59           C  
ATOM    466  N   GLN A  81      41.950  53.756  -0.119  1.00  9.97           N  
ATOM    467  CA  GLN A  81      41.465  55.127  -0.266  1.00  9.79           C  
ATOM    468  C   GLN A  81      40.655  55.541   0.959  1.00 10.18           C  
ATOM    469  O   GLN A  81      40.781  56.666   1.448  1.00 10.35           O  
ATOM    470  CB  GLN A  81      40.582  55.266  -1.510  1.00 10.01           C  
ATOM    471  CG  GLN A  81      41.256  54.916  -2.818  1.00 11.14           C  
ATOM    472  CD  GLN A  81      40.318  55.069  -4.001  1.00 13.21           C  
ATOM    473  OE1 GLN A  81      39.137  54.734  -3.917  1.00 14.14           O  
ATOM    474  NE2 GLN A  81      40.842  55.564  -5.114  1.00 14.54           N  
ATOM    475  N   ALA A  82      39.811  54.635   1.447  1.00  9.65           N  
ATOM    476  CA  ALA A  82      38.982  54.926   2.614  1.00 10.51           C  
ATOM    477  C   ALA A  82      39.842  55.168   3.851  1.00 10.78           C  
ATOM    478  O   ALA A  82      39.663  56.162   4.559  1.00 11.75           O  
ATOM    479  CB  ALA A  82      38.013  53.773   2.870  1.00  8.59           C  
ATOM    480  N   ALA A  83      40.780  54.262   4.106  1.00 10.52           N  
ATOM    481  CA  ALA A  83      41.653  54.384   5.269  1.00 11.89           C  
ATOM    482  C   ALA A  83      42.398  55.718   5.258  1.00 12.77           C  
ATOM    483  O   ALA A  83      42.416  56.423   6.270  1.00 12.62           O  
ATOM    484  CB  ALA A  83      42.646  53.222   5.308  1.00 10.57           C  
ATOM    485  N   LEU A  84      43.003  56.071   4.123  1.00  9.98           N  
ATOM    486  CA  LEU A  84      43.736  57.337   4.016  1.00 11.38           C  
ATOM    487  C   LEU A  84      42.823  58.561   4.179  1.00 11.09           C  
ATOM    488  O   LEU A  84      43.170  59.511   4.886  1.00 11.33           O  
ATOM    489  CB  LEU A  84      44.478  57.415   2.673  1.00 11.75           C  
ATOM    490  CG  LEU A  84      45.616  56.401   2.490  1.00 12.66           C  
ATOM    491  CD1 LEU A  84      46.111  56.447   1.063  1.00 11.85           C  
ATOM    492  CD2 LEU A  84      46.752  56.698   3.462  1.00 11.67           C  
ATOM    493  N   ARG A  85      41.664  58.544   3.524  1.00  9.65           N  
ATOM    494  CA  ARG A  85      40.730  59.657   3.637  1.00  9.63           C  
ATOM    495  C   ARG A  85      40.301  59.844   5.088  1.00  9.98           C  
ATOM    496  O   ARG A  85      40.261  60.962   5.600  1.00  9.83           O  
ATOM    497  CB  ARG A  85      39.481  59.406   2.785  1.00 12.15           C  
ATOM    498  CG  ARG A  85      38.326  60.365   3.106  1.00 10.32           C  
ATOM    499  CD  ARG A  85      37.106  60.086   2.245  1.00 11.73           C  
ATOM    500  NE  ARG A  85      36.606  58.717   2.387  1.00 12.32           N  
ATOM    501  CZ  ARG A  85      35.979  58.248   3.461  1.00 14.28           C  
ATOM    502  NH1 ARG A  85      35.763  59.033   4.508  1.00 14.32           N  
ATOM    503  NH2 ARG A  85      35.564  56.987   3.487  1.00 13.88           N  
ATOM    504  N   GLU A  86      39.964  58.743   5.747  1.00 10.44           N  
ATOM    505  CA  GLU A  86      39.536  58.810   7.134  1.00 10.68           C  
ATOM    506  C   GLU A  86      40.600  59.383   8.060  1.00 10.09           C  
ATOM    507  O   GLU A  86      40.290  60.205   8.919  1.00 10.88           O  
ATOM    508  CB  GLU A  86      39.109  57.431   7.616  1.00 12.74           C  
ATOM    509  CG  GLU A  86      37.692  57.092   7.246  1.00 16.17           C  
ATOM    510  CD  GLU A  86      36.701  58.030   7.897  1.00 18.14           C  
ATOM    511  OE1 GLU A  86      37.080  58.696   8.882  1.00 19.74           O  
ATOM    512  OE2 GLU A  86      35.543  58.091   7.439  1.00 21.59           O  
ATOM    513  N   ALA A  87      41.850  58.957   7.895  1.00 10.00           N  
ATOM    514  CA  ALA A  87      42.917  59.485   8.738  1.00  9.57           C  
ATOM    515  C   ALA A  87      43.077  60.986   8.469  1.00 10.29           C  
ATOM    516  O   ALA A  87      43.344  61.765   9.382  1.00 10.96           O  
ATOM    517  CB  ALA A  87      44.222  58.763   8.460  1.00  9.87           C  
ATOM    518  N   GLN A  88      42.905  61.392   7.213  1.00 11.05           N  
ATOM    519  CA  GLN A  88      43.039  62.802   6.867  1.00 10.81           C  
ATOM    520  C   GLN A  88      41.850  63.624   7.363  1.00 10.89           C  
ATOM    521  O   GLN A  88      42.020  64.762   7.799  1.00 10.78           O  
ATOM    522  CB  GLN A  88      43.208  62.975   5.357  1.00 11.38           C  
ATOM    523  CG  GLN A  88      43.402  64.428   4.938  1.00 12.15           C  
ATOM    524  CD  GLN A  88      43.774  64.559   3.471  1.00 13.81           C  
ATOM    525  OE1 GLN A  88      43.149  63.948   2.600  1.00 13.60           O  
ATOM    526  NE2 GLN A  88      44.793  65.365   3.189  1.00 12.46           N  
ATOM    527  N   GLU A  89      40.651  63.052   7.301  1.00 11.18           N  
ATOM    528  CA  GLU A  89      39.456  63.748   7.770  1.00 12.66           C  
ATOM    529  C   GLU A  89      39.426  63.833   9.287  1.00 12.58           C  
ATOM    530  O   GLU A  89      38.983  64.836   9.841  1.00 13.68           O  
ATOM    531  CB  GLU A  89      38.181  63.032   7.314  1.00 13.97           C  
ATOM    532  CG  GLU A  89      37.940  63.051   5.819  1.00 18.08           C  
ATOM    533  CD  GLU A  89      36.655  62.337   5.438  1.00 21.68           C  
ATOM    534  OE1 GLU A  89      36.028  61.725   6.326  1.00 26.60           O  
ATOM    535  OE2 GLU A  89      36.276  62.379   4.251  1.00 24.65           O  
ATOM    536  N   GLU A  90      39.904  62.783   9.953  1.00 11.93           N  
ATOM    537  CA  GLU A  90      39.892  62.725  11.413  1.00 12.09           C  
ATOM    538  C   GLU A  90      40.988  63.492  12.146  1.00 13.16           C  
ATOM    539  O   GLU A  90      40.692  64.257  13.070  1.00 12.87           O  
ATOM    540  CB  GLU A  90      39.925  61.266  11.874  1.00 12.67           C  
ATOM    541  CG  GLU A  90      38.692  60.471  11.489  1.00 13.46           C  
ATOM    542  CD  GLU A  90      38.753  59.032  11.974  1.00 13.85           C  
ATOM    543  OE1 GLU A  90      39.355  58.797  13.044  1.00 14.14           O  
ATOM    544  OE2 GLU A  90      38.187  58.143  11.294  1.00 15.51           O  
ATOM    545  N   VAL A  91      42.245  63.277  11.756  1.00 12.95           N  
ATOM    546  CA  VAL A  91      43.360  63.946  12.422  1.00 13.37           C  
ATOM    547  C   VAL A  91      44.290  64.720  11.505  1.00 11.81           C  
ATOM    548  O   VAL A  91      45.398  65.078  11.893  1.00 12.47           O  
ATOM    549  CB  VAL A  91      44.204  62.942  13.256  1.00 14.28           C  
ATOM    550  CG1 VAL A  91      43.349  62.380  14.401  1.00 14.84           C  
ATOM    551  CG2 VAL A  91      44.726  61.814  12.368  1.00 12.60           C  
ATOM    552  N   ALA A  92      43.825  64.981  10.291  1.00 11.90           N  
ATOM    553  CA  ALA A  92      44.593  65.740   9.312  1.00 12.30           C  
ATOM    554  C   ALA A  92      45.887  65.067   8.864  1.00 12.11           C  
ATOM    555  O   ALA A  92      46.836  65.735   8.468  1.00 12.81           O  
ATOM    556  CB  ALA A  92      44.889  67.146   9.856  1.00 14.91           C  
ATOM    557  N   LEU A  93      45.925  63.741   8.921  1.00 11.53           N  
ATOM    558  CA  LEU A  93      47.103  63.018   8.468  1.00 11.76           C  
ATOM    559  C   LEU A  93      47.148  63.075   6.937  1.00 12.42           C  
ATOM    560  O   LEU A  93      46.238  62.589   6.260  1.00 11.66           O  
ATOM    561  CB  LEU A  93      47.047  61.556   8.922  1.00 10.43           C  
ATOM    562  CG  LEU A  93      48.195  60.691   8.390  1.00  8.18           C  
ATOM    563  CD1 LEU A  93      49.514  61.185   8.977  1.00  9.67           C  
ATOM    564  CD2 LEU A  93      47.957  59.226   8.743  1.00 10.07           C  
ATOM    565  N   ASP A  94      48.201  63.675   6.393  1.00 11.48           N  
ATOM    566  CA  ASP A  94      48.340  63.782   4.945  1.00 12.64           C  
ATOM    567  C   ASP A  94      48.633  62.399   4.353  1.00 12.07           C  
ATOM    568  O   ASP A  94      49.612  61.754   4.717  1.00 13.20           O  
ATOM    569  CB  ASP A  94      49.467  64.769   4.622  1.00 14.33           C  
ATOM    570  CG  ASP A  94      49.728  64.899   3.138  1.00 15.63           C  
ATOM    571  OD1 ASP A  94      48.907  64.402   2.348  1.00 19.50           O  
ATOM    572  OD2 ASP A  94      50.752  65.508   2.761  1.00 19.63           O  
ATOM    573  N   PRO A  95      47.777  61.916   3.439  1.00 12.84           N  
ATOM    574  CA  PRO A  95      47.993  60.599   2.829  1.00 13.98           C  
ATOM    575  C   PRO A  95      49.385  60.417   2.226  1.00 13.94           C  
ATOM    576  O   PRO A  95      49.926  59.312   2.218  1.00 13.44           O  
ATOM    577  CB  PRO A  95      46.897  60.525   1.770  1.00 14.73           C  
ATOM    578  CG  PRO A  95      45.803  61.317   2.376  1.00 15.90           C  
ATOM    579  CD  PRO A  95      46.526  62.515   2.952  1.00 13.98           C  
ATOM    580  N   ALA A  96      49.964  61.498   1.716  1.00 13.80           N  
ATOM    581  CA  ALA A  96      51.288  61.415   1.118  1.00 14.62           C  
ATOM    582  C   ALA A  96      52.366  61.172   2.184  1.00 15.77           C  
ATOM    583  O   ALA A  96      53.505  60.819   1.861  1.00 16.32           O  
ATOM    584  CB  ALA A  96      51.589  62.683   0.330  1.00 14.90           C  
ATOM    585  N   ALA A  97      52.007  61.353   3.453  1.00 14.31           N  
ATOM    586  CA  ALA A  97      52.957  61.132   4.541  1.00 14.20           C  
ATOM    587  C   ALA A  97      52.990  59.650   4.900  1.00 14.09           C  
ATOM    588  O   ALA A  97      53.836  59.203   5.679  1.00 13.92           O  
ATOM    589  CB  ALA A  97      52.560  61.949   5.760  1.00 14.93           C  
ATOM    590  N   VAL A  98      52.071  58.895   4.309  1.00 13.58           N  
ATOM    591  CA  VAL A  98      51.953  57.471   4.587  1.00 13.56           C  
ATOM    592  C   VAL A  98      52.525  56.546   3.512  1.00 13.96           C  
ATOM    593  O   VAL A  98      52.174  56.648   2.334  1.00 12.66           O  
ATOM    594  CB  VAL A  98      50.466  57.085   4.801  1.00 13.13           C  
ATOM    595  CG1 VAL A  98      50.355  55.638   5.277  1.00 13.06           C  
ATOM    596  CG2 VAL A  98      49.831  58.027   5.809  1.00 12.15           C  
ATOM    597  N   THR A  99      53.417  55.651   3.928  1.00 13.36           N  
ATOM    598  CA  THR A  99      53.982  54.659   3.019  1.00 14.07           C  
ATOM    599  C   THR A  99      53.138  53.413   3.240  1.00 13.19           C  
ATOM    600  O   THR A  99      53.133  52.854   4.332  1.00 13.36           O  
ATOM    601  CB  THR A  99      55.440  54.318   3.361  1.00 15.68           C  
ATOM    602  OG1 THR A  99      56.272  55.454   3.094  1.00 15.19           O  
ATOM    603  CG2 THR A  99      55.909  53.116   2.530  1.00 16.03           C  
ATOM    604  N   LEU A 100      52.418  52.990   2.211  1.00 13.70           N  
ATOM    605  CA  LEU A 100      51.552  51.824   2.324  1.00 14.80           C  
ATOM    606  C   LEU A 100      52.357  50.531   2.411  1.00 15.11           C  
ATOM    607  O   LEU A 100      53.184  50.236   1.550  1.00 17.75           O  
ATOM    608  CB  LEU A 100      50.588  51.804   1.145  1.00 13.59           C  
ATOM    609  CG  LEU A 100      49.751  53.088   1.098  1.00 13.89           C  
ATOM    610  CD1 LEU A 100      48.972  53.194  -0.217  1.00 14.60           C  
ATOM    611  CD2 LEU A 100      48.814  53.098   2.287  1.00 12.98           C  
ATOM    612  N   LEU A 101      52.106  49.768   3.466  1.00 14.16           N  
ATOM    613  CA  LEU A 101      52.821  48.523   3.709  1.00 14.25           C  
ATOM    614  C   LEU A 101      51.995  47.307   3.380  1.00 15.22           C  
ATOM    615  O   LEU A 101      52.442  46.181   3.563  1.00 16.93           O  
ATOM    616  CB  LEU A 101      53.239  48.448   5.173  1.00 13.03           C  
ATOM    617  CG  LEU A 101      54.059  49.645   5.650  1.00 11.55           C  
ATOM    618  CD1 LEU A 101      54.363  49.511   7.130  1.00 13.07           C  
ATOM    619  CD2 LEU A 101      55.330  49.733   4.842  1.00 13.59           C  
ATOM    620  N   GLY A 102      50.790  47.534   2.885  1.00 17.67           N  
ATOM    621  CA  GLY A 102      49.917  46.426   2.565  1.00 20.65           C  
ATOM    622  C   GLY A 102      48.871  46.393   3.657  1.00 22.79           C  
ATOM    623  O   GLY A 102      48.714  47.368   4.387  1.00 23.79           O  
ATOM    624  N   GLU A 103      48.156  45.286   3.784  1.00 24.23           N  
ATOM    625  CA  GLU A 103      47.125  45.193   4.803  1.00 25.58           C  
ATOM    626  C   GLU A 103      47.226  43.923   5.614  1.00 25.69           C  
ATOM    627  O   GLU A 103      47.897  42.969   5.220  1.00 27.25           O  
ATOM    628  CB  GLU A 103      45.732  45.265   4.162  1.00 26.98           C  
ATOM    629  CG  GLU A 103      45.663  44.784   2.718  1.00 30.57           C  
ATOM    630  CD  GLU A 103      45.967  45.889   1.715  1.00 32.71           C  
ATOM    631  OE1 GLU A 103      45.235  46.901   1.705  1.00 36.31           O  
ATOM    632  OE2 GLU A 103      46.930  45.751   0.934  1.00 33.78           O  
ATOM    633  N   LEU A 104      46.569  43.932   6.766  1.00 23.24           N  
ATOM    634  CA  LEU A 104      46.521  42.763   7.626  1.00 24.00           C  
ATOM    635  C   LEU A 104      45.302  41.993   7.118  1.00 22.63           C  
ATOM    636  O   LEU A 104      44.591  42.460   6.226  1.00 20.79           O  
ATOM    637  CB  LEU A 104      46.299  43.174   9.086  1.00 25.26           C  
ATOM    638  CG  LEU A 104      47.377  43.996   9.795  1.00 27.01           C  
ATOM    639  CD1 LEU A 104      46.865  44.462  11.139  1.00 27.74           C  
ATOM    640  CD2 LEU A 104      48.638  43.163   9.953  1.00 29.54           C  
ATOM    641  N   ASP A 105      45.047  40.821   7.679  1.00 23.06           N  
ATOM    642  CA  ASP A 105      43.884  40.061   7.251  1.00 21.92           C  
ATOM    643  C   ASP A 105      42.645  40.829   7.665  1.00 20.50           C  
ATOM    644  O   ASP A 105      42.662  41.552   8.667  1.00 17.72           O  
ATOM    645  CB  ASP A 105      43.856  38.689   7.917  1.00 26.04           C  
ATOM    646  CG  ASP A 105      44.930  37.774   7.395  1.00 28.24           C  
ATOM    647  OD1 ASP A 105      45.075  37.701   6.157  1.00 30.22           O  
ATOM    648  OD2 ASP A 105      45.614  37.125   8.214  1.00 30.90           O  
ATOM    649  N   ASP A 106      41.575  40.682   6.892  1.00 17.94           N  
ATOM    650  CA  ASP A 106      40.332  41.347   7.231  1.00 20.08           C  
ATOM    651  C   ASP A 106      39.835  40.766   8.542  1.00 20.11           C  
ATOM    652  O   ASP A 106      40.028  39.578   8.824  1.00 20.12           O  
ATOM    653  CB  ASP A 106      39.254  41.095   6.175  1.00 20.73           C  
ATOM    654  CG  ASP A 106      39.440  41.927   4.928  1.00 23.38           C  
ATOM    655  OD1 ASP A 106      38.546  41.875   4.056  1.00 27.56           O  
ATOM    656  OD2 ASP A 106      40.466  42.627   4.811  1.00 21.87           O  
ATOM    657  N   VAL A 107      39.221  41.612   9.356  1.00 19.06           N  
ATOM    658  CA  VAL A 107      38.630  41.161  10.600  1.00 18.48           C  
ATOM    659  C   VAL A 107      37.152  41.382  10.318  1.00 19.81           C  
ATOM    660  O   VAL A 107      36.783  42.303   9.584  1.00 19.45           O  
ATOM    661  CB  VAL A 107      39.089  41.996  11.807  1.00 19.62           C  
ATOM    662  CG1 VAL A 107      40.597  41.858  11.994  1.00 21.50           C  
ATOM    663  CG2 VAL A 107      38.718  43.441  11.611  1.00 20.62           C  
ATOM    664  N   PHE A 108      36.301  40.529  10.862  1.00 20.05           N  
ATOM    665  CA  PHE A 108      34.884  40.673  10.593  1.00 20.81           C  
ATOM    666  C   PHE A 108      34.038  40.217  11.764  1.00 20.10           C  
ATOM    667  O   PHE A 108      34.520  39.545  12.668  1.00 19.50           O  
ATOM    668  CB  PHE A 108      34.530  39.882   9.331  1.00 23.40           C  
ATOM    669  CG  PHE A 108      34.902  38.434   9.411  1.00 26.42           C  
ATOM    670  CD1 PHE A 108      34.004  37.500   9.917  1.00 29.25           C  
ATOM    671  CD2 PHE A 108      36.172  38.009   9.034  1.00 28.37           C  
ATOM    672  CE1 PHE A 108      34.367  36.162  10.051  1.00 30.62           C  
ATOM    673  CE2 PHE A 108      36.548  36.672   9.164  1.00 30.89           C  
ATOM    674  CZ  PHE A 108      35.641  35.747   9.676  1.00 31.02           C  
ATOM    675  N   THR A 109      32.773  40.609  11.740  1.00 20.81           N  
ATOM    676  CA  THR A 109      31.836  40.260  12.792  1.00 22.44           C  
ATOM    677  C   THR A 109      30.615  39.631  12.120  1.00 24.50           C  
ATOM    678  O   THR A 109      30.166  40.099  11.073  1.00 24.15           O  
ATOM    679  CB  THR A 109      31.445  41.521  13.600  1.00 20.60           C  
ATOM    680  OG1 THR A 109      30.508  41.169  14.621  1.00 20.73           O  
ATOM    681  CG2 THR A 109      30.847  42.574  12.692  1.00 18.64           C  
ATOM    682  N   PRO A 110      30.073  38.551  12.707  1.00 26.05           N  
ATOM    683  CA  PRO A 110      28.906  37.837  12.177  1.00 26.98           C  
ATOM    684  C   PRO A 110      27.790  38.709  11.600  1.00 30.05           C  
ATOM    685  O   PRO A 110      27.289  38.436  10.506  1.00 31.03           O  
ATOM    686  CB  PRO A 110      28.442  37.018  13.375  1.00 26.72           C  
ATOM    687  CG  PRO A 110      29.734  36.658  14.026  1.00 27.46           C  
ATOM    688  CD  PRO A 110      30.485  37.980  14.001  1.00 26.06           C  
ATOM    689  N   VAL A 111      27.405  39.755  12.326  1.00 31.98           N  
ATOM    690  CA  VAL A 111      26.334  40.643  11.879  1.00 34.59           C  
ATOM    691  C   VAL A 111      26.456  41.119  10.429  1.00 35.74           C  
ATOM    692  O   VAL A 111      25.442  41.356   9.770  1.00 37.85           O  
ATOM    693  CB  VAL A 111      26.209  41.883  12.789  1.00 35.38           C  
ATOM    694  CG1 VAL A 111      27.504  42.664  12.795  1.00 38.07           C  
ATOM    695  CG2 VAL A 111      25.059  42.754  12.308  1.00 37.37           C  
ATOM    696  N   GLY A 112      27.680  41.270   9.932  1.00 33.70           N  
ATOM    697  CA  GLY A 112      27.840  41.703   8.555  1.00 32.22           C  
ATOM    698  C   GLY A 112      28.747  42.899   8.320  1.00 31.16           C  
ATOM    699  O   GLY A 112      28.369  43.859   7.641  1.00 31.71           O  
ATOM    700  N   PHE A 113      29.948  42.848   8.877  1.00 28.30           N  
ATOM    701  CA  PHE A 113      30.909  43.921   8.691  1.00 26.33           C  
ATOM    702  C   PHE A 113      32.277  43.321   8.437  1.00 23.97           C  
ATOM    703  O   PHE A 113      32.732  42.465   9.186  1.00 21.53           O  
ATOM    704  CB  PHE A 113      30.975  44.819   9.927  1.00 29.10           C  
ATOM    705  CG  PHE A 113      30.449  46.207   9.697  1.00 31.91           C  
ATOM    706  CD1 PHE A 113      29.186  46.573  10.149  1.00 33.75           C  
ATOM    707  CD2 PHE A 113      31.210  47.148   9.010  1.00 33.55           C  
ATOM    708  CE1 PHE A 113      28.692  47.859   9.924  1.00 34.17           C  
ATOM    709  CE2 PHE A 113      30.723  48.436   8.780  1.00 34.28           C  
ATOM    710  CZ  PHE A 113      29.464  48.791   9.237  1.00 33.94           C  
ATOM    711  N   HIS A 114      32.918  43.760   7.361  1.00 23.04           N  
ATOM    712  CA  HIS A 114      34.255  43.300   7.008  1.00 22.67           C  
ATOM    713  C   HIS A 114      35.146  44.529   7.050  1.00 21.03           C  
ATOM    714  O   HIS A 114      34.872  45.519   6.376  1.00 20.24           O  
ATOM    715  CB  HIS A 114      34.262  42.678   5.608  1.00 26.65           C  
ATOM    716  CG  HIS A 114      34.545  41.208   5.609  1.00 31.28           C  
ATOM    717  ND1 HIS A 114      35.818  40.694   5.464  1.00 35.18           N  
ATOM    718  CD2 HIS A 114      33.732  40.142   5.803  1.00 32.59           C  
ATOM    719  CE1 HIS A 114      35.774  39.377   5.571  1.00 35.36           C  
ATOM    720  NE2 HIS A 114      34.519  39.017   5.778  1.00 33.79           N  
ATOM    721  N   VAL A 115      36.194  44.469   7.862  1.00 18.34           N  
ATOM    722  CA  VAL A 115      37.109  45.594   8.006  1.00 15.76           C  
ATOM    723  C   VAL A 115      38.501  45.246   7.488  1.00 14.60           C  
ATOM    724  O   VAL A 115      39.077  44.227   7.875  1.00 13.67           O  
ATOM    725  CB  VAL A 115      37.213  46.018   9.482  1.00 15.39           C  
ATOM    726  CG1 VAL A 115      38.052  47.265   9.611  1.00 14.65           C  
ATOM    727  CG2 VAL A 115      35.821  46.243  10.046  1.00 16.77           C  
ATOM    728  N   THR A 116      39.029  46.091   6.606  1.00 11.77           N  
ATOM    729  CA  THR A 116      40.350  45.879   6.042  1.00 11.32           C  
ATOM    730  C   THR A 116      41.347  46.777   6.760  1.00 10.26           C  
ATOM    731  O   THR A 116      41.273  48.001   6.650  1.00  9.70           O  
ATOM    732  CB  THR A 116      40.397  46.238   4.532  1.00 12.36           C  
ATOM    733  OG1 THR A 116      39.552  45.348   3.792  1.00 13.30           O  
ATOM    734  CG2 THR A 116      41.818  46.137   4.001  1.00 13.98           C  
ATOM    735  N   PRO A 117      42.266  46.187   7.540  1.00 11.31           N  
ATOM    736  CA  PRO A 117      43.223  47.070   8.209  1.00 12.65           C  
ATOM    737  C   PRO A 117      44.365  47.379   7.242  1.00 13.55           C  
ATOM    738  O   PRO A 117      45.153  46.503   6.880  1.00 14.98           O  
ATOM    739  CB  PRO A 117      43.642  46.277   9.447  1.00 13.26           C  
ATOM    740  CG  PRO A 117      43.396  44.864   9.085  1.00 14.21           C  
ATOM    741  CD  PRO A 117      42.197  44.864   8.187  1.00 11.58           C  
ATOM    742  N   VAL A 118      44.421  48.633   6.799  1.00 11.60           N  
ATOM    743  CA  VAL A 118      45.432  49.100   5.847  1.00 11.21           C  
ATOM    744  C   VAL A 118      46.676  49.569   6.589  1.00 10.90           C  
ATOM    745  O   VAL A 118      46.622  50.540   7.328  1.00 11.12           O  
ATOM    746  CB  VAL A 118      44.869  50.276   5.013  1.00 10.12           C  
ATOM    747  CG1 VAL A 118      45.902  50.764   4.016  1.00 11.44           C  
ATOM    748  CG2 VAL A 118      43.593  49.840   4.316  1.00  8.30           C  
ATOM    749  N   LEU A 119      47.799  48.891   6.383  1.00 11.48           N  
ATOM    750  CA  LEU A 119      49.024  49.268   7.079  1.00 11.46           C  
ATOM    751  C   LEU A 119      49.773  50.390   6.375  1.00 11.75           C  
ATOM    752  O   LEU A 119      49.788  50.475   5.144  1.00 11.49           O  
ATOM    753  CB  LEU A 119      49.956  48.061   7.240  1.00 14.17           C  
ATOM    754  CG  LEU A 119      49.442  46.900   8.087  1.00 19.06           C  
ATOM    755  CD1 LEU A 119      50.205  45.624   7.759  1.00 21.31           C  
ATOM    756  CD2 LEU A 119      49.570  47.250   9.563  1.00 19.52           C  
ATOM    757  N   GLY A 120      50.398  51.247   7.180  1.00 11.96           N  
ATOM    758  CA  GLY A 120      51.153  52.361   6.646  1.00 11.90           C  
ATOM    759  C   GLY A 120      52.256  52.761   7.604  1.00 13.23           C  
ATOM    760  O   GLY A 120      52.194  52.457   8.801  1.00 12.95           O  
ATOM    761  N   ARG A 121      53.289  53.413   7.083  1.00 13.09           N  
ATOM    762  CA  ARG A 121      54.373  53.863   7.932  1.00 14.17           C  
ATOM    763  C   ARG A 121      54.559  55.344   7.718  1.00 13.29           C  
ATOM    764  O   ARG A 121      54.549  55.825   6.584  1.00 13.40           O  
ATOM    765  CB  ARG A 121      55.684  53.135   7.636  1.00 17.03           C  
ATOM    766  CG  ARG A 121      56.716  53.378   8.730  1.00 20.40           C  
ATOM    767  CD  ARG A 121      57.903  52.467   8.601  1.00 25.98           C  
ATOM    768  NE  ARG A 121      57.565  51.062   8.820  1.00 29.13           N  
ATOM    769  CZ  ARG A 121      57.308  50.520  10.007  1.00 31.44           C  
ATOM    770  NH1 ARG A 121      57.340  51.260  11.111  1.00 31.90           N  
ATOM    771  NH2 ARG A 121      57.039  49.225  10.091  1.00 31.19           N  
ATOM    772  N   ILE A 122      54.716  56.058   8.823  1.00 13.01           N  
ATOM    773  CA  ILE A 122      54.898  57.495   8.801  1.00 13.21           C  
ATOM    774  C   ILE A 122      56.148  57.876   9.582  1.00 14.66           C  
ATOM    775  O   ILE A 122      56.656  57.102  10.402  1.00 14.48           O  
ATOM    776  CB  ILE A 122      53.694  58.206   9.455  1.00 13.92           C  
ATOM    777  CG1 ILE A 122      53.592  57.798  10.932  1.00 13.12           C  
ATOM    778  CG2 ILE A 122      52.409  57.844   8.722  1.00 11.64           C  
ATOM    779  CD1 ILE A 122      52.446  58.457  11.681  1.00 11.49           C  
ATOM    780  N   ALA A 123      56.644  59.076   9.322  1.00 14.51           N  
ATOM    781  CA  ALA A 123      57.801  59.568  10.046  1.00 15.57           C  
ATOM    782  C   ALA A 123      57.287  59.871  11.453  1.00 15.98           C  
ATOM    783  O   ALA A 123      56.136  60.280  11.625  1.00 15.32           O  
ATOM    784  CB  ALA A 123      58.325  60.833   9.383  1.00 16.44           C  
ATOM    785  N   PRO A 124      58.125  59.671  12.483  1.00 16.77           N  
ATOM    786  CA  PRO A 124      57.649  59.953  13.843  1.00 16.70           C  
ATOM    787  C   PRO A 124      57.180  61.401  13.974  1.00 16.80           C  
ATOM    788  O   PRO A 124      56.213  61.692  14.677  1.00 16.09           O  
ATOM    789  CB  PRO A 124      58.879  59.676  14.716  1.00 16.95           C  
ATOM    790  CG  PRO A 124      59.695  58.730  13.903  1.00 18.71           C  
ATOM    791  CD  PRO A 124      59.534  59.247  12.493  1.00 16.56           C  
ATOM    792  N   GLU A 125      57.877  62.302  13.292  1.00 16.83           N  
ATOM    793  CA  GLU A 125      57.557  63.720  13.337  1.00 19.40           C  
ATOM    794  C   GLU A 125      56.155  64.019  12.829  1.00 18.16           C  
ATOM    795  O   GLU A 125      55.550  65.006  13.240  1.00 17.84           O  
ATOM    796  CB  GLU A 125      58.556  64.524  12.504  1.00 23.61           C  
ATOM    797  CG  GLU A 125      60.014  64.191  12.749  1.00 30.18           C  
ATOM    798  CD  GLU A 125      60.424  62.872  12.119  1.00 32.85           C  
ATOM    799  OE1 GLU A 125      59.926  62.572  11.011  1.00 36.74           O  
ATOM    800  OE2 GLU A 125      61.251  62.148  12.715  1.00 35.75           O  
ATOM    801  N   ALA A 126      55.645  63.179  11.932  1.00 16.70           N  
ATOM    802  CA  ALA A 126      54.310  63.391  11.378  1.00 16.15           C  
ATOM    803  C   ALA A 126      53.248  63.524  12.467  1.00 16.35           C  
ATOM    804  O   ALA A 126      52.267  64.247  12.300  1.00 16.90           O  
ATOM    805  CB  ALA A 126      53.948  62.254  10.431  1.00 17.29           C  
ATOM    806  N   LEU A 127      53.452  62.841  13.588  1.00 15.01           N  
ATOM    807  CA  LEU A 127      52.499  62.887  14.693  1.00 16.58           C  
ATOM    808  C   LEU A 127      52.382  64.266  15.341  1.00 16.29           C  
ATOM    809  O   LEU A 127      51.304  64.671  15.787  1.00 17.63           O  
ATOM    810  CB  LEU A 127      52.907  61.886  15.784  1.00 16.96           C  
ATOM    811  CG  LEU A 127      53.019  60.395  15.461  1.00 16.77           C  
ATOM    812  CD1 LEU A 127      53.602  59.655  16.680  1.00 17.45           C  
ATOM    813  CD2 LEU A 127      51.647  59.844  15.087  1.00 16.87           C  
ATOM    814  N   ASP A 128      53.496  64.983  15.393  1.00 17.03           N  
ATOM    815  CA  ASP A 128      53.540  66.289  16.041  1.00 19.07           C  
ATOM    816  C   ASP A 128      52.556  67.348  15.542  1.00 19.23           C  
ATOM    817  O   ASP A 128      52.110  68.196  16.324  1.00 19.37           O  
ATOM    818  CB  ASP A 128      54.965  66.853  15.964  1.00 20.88           C  
ATOM    819  CG  ASP A 128      55.993  65.953  16.645  1.00 24.16           C  
ATOM    820  OD1 ASP A 128      57.202  66.268  16.560  1.00 27.65           O  
ATOM    821  OD2 ASP A 128      55.599  64.938  17.261  1.00 24.09           O  
ATOM    822  N   THR A 129      52.211  67.303  14.259  1.00 17.47           N  
ATOM    823  CA  THR A 129      51.322  68.310  13.704  1.00 17.12           C  
ATOM    824  C   THR A 129      49.929  67.833  13.330  1.00 17.18           C  
ATOM    825  O   THR A 129      49.199  68.536  12.633  1.00 17.49           O  
ATOM    826  CB  THR A 129      51.964  68.978  12.475  1.00 18.13           C  
ATOM    827  OG1 THR A 129      52.402  67.968  11.556  1.00 17.51           O  
ATOM    828  CG2 THR A 129      53.164  69.818  12.894  1.00 19.58           C  
ATOM    829  N   LEU A 130      49.555  66.639  13.773  1.00 15.57           N  
ATOM    830  CA  LEU A 130      48.219  66.154  13.476  1.00 15.76           C  
ATOM    831  C   LEU A 130      47.253  67.072  14.220  1.00 16.78           C  
ATOM    832  O   LEU A 130      47.594  67.632  15.262  1.00 16.15           O  
ATOM    833  CB  LEU A 130      48.047  64.708  13.942  1.00 15.02           C  
ATOM    834  CG  LEU A 130      48.862  63.676  13.166  1.00 14.02           C  
ATOM    835  CD1 LEU A 130      48.574  62.295  13.723  1.00 13.43           C  
ATOM    836  CD2 LEU A 130      48.524  63.750  11.679  1.00 15.17           C  
ATOM    837  N   ARG A 131      46.054  67.235  13.680  1.00 17.36           N  
ATOM    838  CA  ARG A 131      45.072  68.098  14.303  1.00 17.23           C  
ATOM    839  C   ARG A 131      43.743  67.390  14.383  1.00 18.25           C  
ATOM    840  O   ARG A 131      43.133  67.023  13.379  1.00 17.92           O  
ATOM    841  CB  ARG A 131      44.924  69.402  13.516  1.00 18.86           C  
ATOM    842  CG  ARG A 131      43.927  70.394  14.099  1.00 18.53           C  
ATOM    843  CD  ARG A 131      43.973  71.720  13.331  1.00 19.10           C  
ATOM    844  NE  ARG A 131      45.212  72.458  13.579  1.00 20.95           N  
ATOM    845  CZ  ARG A 131      45.397  73.290  14.603  1.00 21.30           C  
ATOM    846  NH1 ARG A 131      44.419  73.499  15.474  1.00 21.56           N  
ATOM    847  NH2 ARG A 131      46.562  73.906  14.758  1.00 21.54           N  
ATOM    848  N   VAL A 132      43.317  67.201  15.615  1.00 17.78           N  
ATOM    849  CA  VAL A 132      42.077  66.549  15.929  1.00 18.88           C  
ATOM    850  C   VAL A 132      40.893  67.345  15.383  1.00 20.26           C  
ATOM    851  O   VAL A 132      40.879  68.579  15.426  1.00 18.55           O  
ATOM    852  CB  VAL A 132      41.978  66.418  17.464  1.00 20.31           C  
ATOM    853  CG1 VAL A 132      40.607  66.790  17.945  1.00 23.24           C  
ATOM    854  CG2 VAL A 132      42.366  65.016  17.887  1.00 19.06           C  
ATOM    855  N   THR A 133      39.920  66.626  14.836  1.00 22.00           N  
ATOM    856  CA  THR A 133      38.690  67.233  14.344  1.00 23.16           C  
ATOM    857  C   THR A 133      37.658  66.873  15.421  1.00 24.39           C  
ATOM    858  O   THR A 133      37.942  66.062  16.311  1.00 24.38           O  
ATOM    859  CB  THR A 133      38.257  66.654  12.975  1.00 23.90           C  
ATOM    860  OG1 THR A 133      38.326  65.224  13.010  1.00 25.40           O  
ATOM    861  CG2 THR A 133      39.155  67.186  11.868  1.00 23.89           C  
ATOM    862  N   PRO A 134      36.459  67.470  15.370  1.00 25.19           N  
ATOM    863  CA  PRO A 134      35.415  67.195  16.364  1.00 25.16           C  
ATOM    864  C   PRO A 134      35.105  65.741  16.731  1.00 25.36           C  
ATOM    865  O   PRO A 134      34.825  65.450  17.894  1.00 25.28           O  
ATOM    866  CB  PRO A 134      34.207  67.925  15.786  1.00 24.58           C  
ATOM    867  CG  PRO A 134      34.842  69.142  15.214  1.00 24.14           C  
ATOM    868  CD  PRO A 134      36.036  68.562  14.475  1.00 24.19           C  
ATOM    869  N   GLU A 135      35.151  64.825  15.767  1.00 26.49           N  
ATOM    870  CA  GLU A 135      34.840  63.433  16.085  1.00 26.96           C  
ATOM    871  C   GLU A 135      35.918  62.723  16.904  1.00 25.05           C  
ATOM    872  O   GLU A 135      35.673  61.645  17.443  1.00 26.53           O  
ATOM    873  CB  GLU A 135      34.534  62.638  14.808  1.00 28.92           C  
ATOM    874  CG  GLU A 135      35.721  62.337  13.919  1.00 33.57           C  
ATOM    875  CD  GLU A 135      35.307  61.617  12.642  1.00 36.44           C  
ATOM    876  OE1 GLU A 135      34.701  60.524  12.731  1.00 37.57           O  
ATOM    877  OE2 GLU A 135      35.584  62.145  11.544  1.00 39.53           O  
ATOM    878  N   VAL A 136      37.102  63.325  17.004  1.00 22.70           N  
ATOM    879  CA  VAL A 136      38.207  62.741  17.774  1.00 18.65           C  
ATOM    880  C   VAL A 136      38.555  63.639  18.966  1.00 18.07           C  
ATOM    881  O   VAL A 136      38.823  64.827  18.794  1.00 18.31           O  
ATOM    882  CB  VAL A 136      39.463  62.550  16.886  1.00 17.93           C  
ATOM    883  CG1 VAL A 136      40.636  62.068  17.721  1.00 16.18           C  
ATOM    884  CG2 VAL A 136      39.169  61.549  15.786  1.00 17.59           C  
ATOM    885  N   ALA A 137      38.544  63.064  20.169  1.00 15.96           N  
ATOM    886  CA  ALA A 137      38.845  63.798  21.400  1.00 14.88           C  
ATOM    887  C   ALA A 137      40.343  63.944  21.638  1.00 15.31           C  
ATOM    888  O   ALA A 137      40.818  64.986  22.087  1.00 15.33           O  
ATOM    889  CB  ALA A 137      38.209  63.094  22.582  1.00 14.98           C  
ATOM    890  N   GLN A 138      41.086  62.886  21.357  1.00 15.65           N  
ATOM    891  CA  GLN A 138      42.526  62.937  21.535  1.00 15.23           C  
ATOM    892  C   GLN A 138      43.203  61.888  20.671  1.00 13.98           C  
ATOM    893  O   GLN A 138      42.566  60.958  20.170  1.00 13.39           O  
ATOM    894  CB  GLN A 138      42.910  62.734  23.017  1.00 17.15           C  
ATOM    895  CG  GLN A 138      42.717  61.325  23.561  1.00 18.48           C  
ATOM    896  CD  GLN A 138      43.162  61.169  25.017  1.00 16.49           C  
ATOM    897  OE1 GLN A 138      44.359  61.130  25.332  1.00 16.24           O  
ATOM    898  NE2 GLN A 138      42.191  61.078  25.909  1.00 15.84           N  
ATOM    899  N   ILE A 139      44.499  62.071  20.478  1.00 11.76           N  
ATOM    900  CA  ILE A 139      45.306  61.146  19.708  1.00 12.30           C  
ATOM    901  C   ILE A 139      46.207  60.429  20.711  1.00 11.91           C  
ATOM    902  O   ILE A 139      46.850  61.074  21.541  1.00 12.50           O  
ATOM    903  CB  ILE A 139      46.174  61.903  18.683  1.00 11.10           C  
ATOM    904  CG1 ILE A 139      45.273  62.538  17.619  1.00 10.80           C  
ATOM    905  CG2 ILE A 139      47.191  60.963  18.067  1.00 12.63           C  
ATOM    906  CD1 ILE A 139      45.979  63.511  16.694  1.00 11.59           C  
ATOM    907  N   ILE A 140      46.210  59.100  20.673  1.00 11.14           N  
ATOM    908  CA  ILE A 140      47.068  58.334  21.567  1.00 11.74           C  
ATOM    909  C   ILE A 140      47.985  57.482  20.703  1.00 13.23           C  
ATOM    910  O   ILE A 140      47.583  56.992  19.644  1.00 13.44           O  
ATOM    911  CB  ILE A 140      46.266  57.434  22.540  1.00 11.54           C  
ATOM    912  CG1 ILE A 140      45.307  56.523  21.767  1.00 11.12           C  
ATOM    913  CG2 ILE A 140      45.525  58.303  23.537  1.00 11.10           C  
ATOM    914  CD1 ILE A 140      44.726  55.419  22.614  1.00 11.86           C  
ATOM    915  N   THR A 141      49.226  57.321  21.141  1.00 12.23           N  
ATOM    916  CA  THR A 141      50.180  56.554  20.366  1.00 12.64           C  
ATOM    917  C   THR A 141      50.936  55.531  21.198  1.00 13.38           C  
ATOM    918  O   THR A 141      52.088  55.758  21.589  1.00 11.71           O  
ATOM    919  CB  THR A 141      51.194  57.486  19.676  1.00 12.78           C  
ATOM    920  OG1 THR A 141      51.917  58.230  20.668  1.00 13.75           O  
ATOM    921  CG2 THR A 141      50.467  58.457  18.756  1.00 12.79           C  
ATOM    922  N   PRO A 142      50.291  54.390  21.485  1.00 13.64           N  
ATOM    923  CA  PRO A 142      50.936  53.338  22.273  1.00 14.55           C  
ATOM    924  C   PRO A 142      52.128  52.832  21.466  1.00 15.24           C  
ATOM    925  O   PRO A 142      52.094  52.820  20.234  1.00 14.71           O  
ATOM    926  CB  PRO A 142      49.848  52.262  22.394  1.00 12.68           C  
ATOM    927  CG  PRO A 142      48.578  53.022  22.223  1.00 13.73           C  
ATOM    928  CD  PRO A 142      48.911  54.011  21.133  1.00 12.79           C  
ATOM    929  N   THR A 143      53.186  52.433  22.155  1.00 15.03           N  
ATOM    930  CA  THR A 143      54.347  51.908  21.472  1.00 15.79           C  
ATOM    931  C   THR A 143      54.026  50.420  21.323  1.00 15.22           C  
ATOM    932  O   THR A 143      53.260  49.871  22.108  1.00 15.00           O  
ATOM    933  CB  THR A 143      55.612  52.137  22.332  1.00 18.03           C  
ATOM    934  OG1 THR A 143      56.674  52.618  21.505  1.00 23.69           O  
ATOM    935  CG2 THR A 143      56.047  50.874  23.006  1.00 13.34           C  
ATOM    936  N   LEU A 144      54.579  49.768  20.312  1.00 15.26           N  
ATOM    937  CA  LEU A 144      54.303  48.346  20.136  1.00 16.08           C  
ATOM    938  C   LEU A 144      54.890  47.555  21.307  1.00 17.24           C  
ATOM    939  O   LEU A 144      54.307  46.561  21.752  1.00 18.26           O  
ATOM    940  CB  LEU A 144      54.877  47.839  18.808  1.00 16.51           C  
ATOM    941  CG  LEU A 144      54.320  48.480  17.530  1.00 16.17           C  
ATOM    942  CD1 LEU A 144      54.797  47.680  16.329  1.00 16.70           C  
ATOM    943  CD2 LEU A 144      52.795  48.502  17.568  1.00 16.92           C  
ATOM    944  N   ALA A 145      56.038  48.007  21.811  1.00 16.38           N  
ATOM    945  CA  ALA A 145      56.683  47.346  22.943  1.00 16.03           C  
ATOM    946  C   ALA A 145      55.759  47.401  24.149  1.00 15.92           C  
ATOM    947  O   ALA A 145      55.586  46.408  24.858  1.00 17.24           O  
ATOM    948  CB  ALA A 145      57.998  48.034  23.277  1.00 18.10           C  
ATOM    949  N   GLU A 146      55.176  48.574  24.383  1.00 15.70           N  
ATOM    950  CA  GLU A 146      54.269  48.768  25.500  1.00 15.47           C  
ATOM    951  C   GLU A 146      53.069  47.838  25.389  1.00 15.76           C  
ATOM    952  O   GLU A 146      52.731  47.143  26.345  1.00 16.99           O  
ATOM    953  CB  GLU A 146      53.798  50.224  25.556  1.00 16.02           C  
ATOM    954  CG  GLU A 146      54.905  51.226  25.849  1.00 16.89           C  
ATOM    955  CD  GLU A 146      54.465  52.667  25.657  1.00 18.17           C  
ATOM    956  OE1 GLU A 146      53.411  52.895  25.023  1.00 18.10           O  
ATOM    957  OE2 GLU A 146      55.179  53.575  26.132  1.00 19.53           O  
ATOM    958  N   LEU A 147      52.424  47.815  24.225  1.00 14.77           N  
ATOM    959  CA  LEU A 147      51.261  46.952  24.032  1.00 14.07           C  
ATOM    960  C   LEU A 147      51.604  45.472  24.213  1.00 15.65           C  
ATOM    961  O   LEU A 147      50.762  44.676  24.628  1.00 16.20           O  
ATOM    962  CB  LEU A 147      50.655  47.185  22.650  1.00 13.85           C  
ATOM    963  CG  LEU A 147      50.077  48.583  22.410  1.00 12.58           C  
ATOM    964  CD1 LEU A 147      49.610  48.671  20.977  1.00 12.70           C  
ATOM    965  CD2 LEU A 147      48.923  48.859  23.368  1.00 11.95           C  
ATOM    966  N   ARG A 148      52.837  45.101  23.894  1.00 17.17           N  
ATOM    967  CA  ARG A 148      53.270  43.717  24.060  1.00 19.01           C  
ATOM    968  C   ARG A 148      53.524  43.412  25.539  1.00 18.92           C  
ATOM    969  O   ARG A 148      53.436  42.262  25.961  1.00 20.16           O  
ATOM    970  CB  ARG A 148      54.567  43.458  23.289  1.00 19.81           C  
ATOM    971  CG  ARG A 148      54.444  43.481  21.788  1.00 21.79           C  
ATOM    972  CD  ARG A 148      55.693  42.880  21.143  1.00 24.63           C  
ATOM    973  NE  ARG A 148      55.472  42.584  19.727  1.00 30.07           N  
ATOM    974  CZ  ARG A 148      55.894  43.345  18.721  1.00 30.60           C  
ATOM    975  NH1 ARG A 148      56.574  44.455  18.964  1.00 31.58           N  
ATOM    976  NH2 ARG A 148      55.613  43.007  17.469  1.00 31.97           N  
ATOM    977  N   ALA A 149      53.831  44.447  26.320  1.00 17.97           N  
ATOM    978  CA  ALA A 149      54.143  44.295  27.746  1.00 18.70           C  
ATOM    979  C   ALA A 149      52.966  44.418  28.708  1.00 19.27           C  
ATOM    980  O   ALA A 149      53.024  43.938  29.842  1.00 19.60           O  
ATOM    981  CB  ALA A 149      55.218  45.300  28.141  1.00 17.76           C  
ATOM    982  N   VAL A 150      51.913  45.087  28.263  1.00 18.80           N  
ATOM    983  CA  VAL A 150      50.714  45.290  29.060  1.00 18.52           C  
ATOM    984  C   VAL A 150      50.082  43.948  29.420  1.00 16.74           C  
ATOM    985  O   VAL A 150      50.222  42.987  28.679  1.00 16.47           O  
ATOM    986  CB  VAL A 150      49.709  46.129  28.258  1.00 21.19           C  
ATOM    987  CG1 VAL A 150      48.338  46.000  28.840  1.00 27.43           C  
ATOM    988  CG2 VAL A 150      50.154  47.584  28.254  1.00 22.76           C  
ATOM    989  N   PRO A 151      49.402  43.857  30.577  1.00 16.28           N  
ATOM    990  CA  PRO A 151      48.778  42.578  30.937  1.00 16.64           C  
ATOM    991  C   PRO A 151      47.557  42.286  30.064  1.00 15.29           C  
ATOM    992  O   PRO A 151      46.421  42.544  30.449  1.00 15.74           O  
ATOM    993  CB  PRO A 151      48.427  42.758  32.415  1.00 15.54           C  
ATOM    994  CG  PRO A 151      48.260  44.233  32.555  1.00 17.18           C  
ATOM    995  CD  PRO A 151      49.379  44.791  31.716  1.00 16.67           C  
ATOM    996  N   LEU A 152      47.822  41.743  28.883  1.00 16.10           N  
ATOM    997  CA  LEU A 152      46.794  41.407  27.906  1.00 15.75           C  
ATOM    998  C   LEU A 152      45.666  40.582  28.495  1.00 15.50           C  
ATOM    999  O   LEU A 152      45.903  39.666  29.273  1.00 16.48           O  
ATOM   1000  CB  LEU A 152      47.428  40.629  26.753  1.00 16.00           C  
ATOM   1001  CG  LEU A 152      46.510  40.175  25.620  1.00 15.99           C  
ATOM   1002  CD1 LEU A 152      46.087  41.371  24.788  1.00 14.76           C  
ATOM   1003  CD2 LEU A 152      47.239  39.170  24.770  1.00 15.79           C  
ATOM   1004  N   VAL A 153      44.438  40.907  28.113  1.00 15.60           N  
ATOM   1005  CA  VAL A 153      43.273  40.169  28.585  1.00 16.80           C  
ATOM   1006  C   VAL A 153      42.833  39.237  27.456  1.00 18.25           C  
ATOM   1007  O   VAL A 153      42.594  39.682  26.337  1.00 17.51           O  
ATOM   1008  CB  VAL A 153      42.108  41.129  28.953  1.00 15.83           C  
ATOM   1009  CG1 VAL A 153      40.875  40.338  29.360  1.00 16.86           C  
ATOM   1010  CG2 VAL A 153      42.533  42.038  30.090  1.00 17.01           C  
ATOM   1011  N   ARG A 154      42.746  37.942  27.744  1.00 19.77           N  
ATOM   1012  CA  ARG A 154      42.338  36.972  26.732  1.00 20.40           C  
ATOM   1013  C   ARG A 154      41.106  36.193  27.157  1.00 18.95           C  
ATOM   1014  O   ARG A 154      41.179  35.338  28.036  1.00 17.19           O  
ATOM   1015  CB  ARG A 154      43.462  35.978  26.445  1.00 22.10           C  
ATOM   1016  CG  ARG A 154      44.777  36.614  26.083  1.00 28.31           C  
ATOM   1017  CD  ARG A 154      45.844  35.564  25.866  1.00 33.37           C  
ATOM   1018  NE  ARG A 154      47.170  36.111  26.131  1.00 41.68           N  
ATOM   1019  CZ  ARG A 154      47.897  35.829  27.209  1.00 45.90           C  
ATOM   1020  NH1 ARG A 154      47.443  34.993  28.138  1.00 49.37           N  
ATOM   1021  NH2 ARG A 154      49.075  36.404  27.377  1.00 48.86           N  
ATOM   1022  N   GLU A 155      39.975  36.495  26.536  1.00 19.81           N  
ATOM   1023  CA  GLU A 155      38.741  35.787  26.836  1.00 20.90           C  
ATOM   1024  C   GLU A 155      38.346  35.011  25.596  1.00 22.40           C  
ATOM   1025  O   GLU A 155      38.973  35.130  24.549  1.00 19.91           O  
ATOM   1026  CB  GLU A 155      37.621  36.757  27.201  1.00 21.62           C  
ATOM   1027  CG  GLU A 155      37.857  37.517  28.481  1.00 25.83           C  
ATOM   1028  CD  GLU A 155      36.632  38.294  28.920  1.00 28.01           C  
ATOM   1029  OE1 GLU A 155      35.610  37.650  29.252  1.00 29.67           O  
ATOM   1030  OE2 GLU A 155      36.696  39.546  28.927  1.00 30.67           O  
ATOM   1031  N   ARG A 156      37.294  34.217  25.713  1.00 25.00           N  
ATOM   1032  CA  ARG A 156      36.837  33.435  24.586  1.00 26.84           C  
ATOM   1033  C   ARG A 156      35.333  33.306  24.637  1.00 26.63           C  
ATOM   1034  O   ARG A 156      34.747  33.153  25.705  1.00 25.37           O  
ATOM   1035  CB  ARG A 156      37.485  32.056  24.623  1.00 31.28           C  
ATOM   1036  CG  ARG A 156      37.238  31.194  23.402  1.00 37.17           C  
ATOM   1037  CD  ARG A 156      38.256  30.077  23.410  1.00 42.82           C  
ATOM   1038  NE  ARG A 156      39.602  30.634  23.536  1.00 46.49           N  
ATOM   1039  CZ  ARG A 156      40.621  30.013  24.121  1.00 49.18           C  
ATOM   1040  NH1 ARG A 156      40.457  28.803  24.640  1.00 49.57           N  
ATOM   1041  NH2 ARG A 156      41.805  30.610  24.199  1.00 50.08           N  
ATOM   1042  N   ARG A 157      34.716  33.395  23.470  1.00 26.89           N  
ATOM   1043  CA  ARG A 157      33.281  33.271  23.351  1.00 27.82           C  
ATOM   1044  C   ARG A 157      33.029  32.315  22.218  1.00 26.84           C  
ATOM   1045  O   ARG A 157      33.912  32.062  21.403  1.00 27.26           O  
ATOM   1046  CB  ARG A 157      32.638  34.628  23.060  1.00 30.77           C  
ATOM   1047  CG  ARG A 157      32.188  35.342  24.316  1.00 33.86           C  
ATOM   1048  CD  ARG A 157      32.867  36.675  24.474  1.00 37.32           C  
ATOM   1049  NE  ARG A 157      32.743  37.185  25.835  1.00 39.76           N  
ATOM   1050  CZ  ARG A 157      33.258  36.586  26.907  1.00 41.03           C  
ATOM   1051  NH1 ARG A 157      33.937  35.453  26.783  1.00 41.75           N  
ATOM   1052  NH2 ARG A 157      33.096  37.119  28.110  1.00 43.45           N  
ATOM   1053  N   THR A 158      31.825  31.778  22.164  1.00 26.27           N  
ATOM   1054  CA  THR A 158      31.489  30.834  21.124  1.00 26.25           C  
ATOM   1055  C   THR A 158      30.409  31.427  20.249  1.00 26.25           C  
ATOM   1056  O   THR A 158      29.502  32.091  20.739  1.00 26.86           O  
ATOM   1057  CB  THR A 158      30.991  29.515  21.733  1.00 26.75           C  
ATOM   1058  OG1 THR A 158      31.984  29.002  22.630  1.00 27.56           O  
ATOM   1059  CG2 THR A 158      30.734  28.490  20.651  1.00 27.85           C  
ATOM   1060  N   LEU A 159      30.530  31.199  18.948  1.00 26.58           N  
ATOM   1061  CA  LEU A 159      29.557  31.688  17.985  1.00 28.06           C  
ATOM   1062  C   LEU A 159      28.434  30.660  17.872  1.00 29.46           C  
ATOM   1063  O   LEU A 159      28.562  29.533  18.356  1.00 28.07           O  
ATOM   1064  CB  LEU A 159      30.222  31.896  16.622  1.00 28.37           C  
ATOM   1065  CG  LEU A 159      31.136  33.115  16.470  1.00 29.86           C  
ATOM   1066  CD1 LEU A 159      32.102  33.199  17.630  1.00 31.10           C  
ATOM   1067  CD2 LEU A 159      31.891  33.019  15.163  1.00 31.28           C  
ATOM   1068  N   PRO A 160      27.316  31.040  17.237  1.00 32.53           N  
ATOM   1069  CA  PRO A 160      26.149  30.173  17.046  1.00 34.26           C  
ATOM   1070  C   PRO A 160      26.471  28.794  16.476  1.00 36.04           C  
ATOM   1071  O   PRO A 160      25.802  27.813  16.796  1.00 36.06           O  
ATOM   1072  CB  PRO A 160      25.269  30.992  16.112  1.00 34.10           C  
ATOM   1073  CG  PRO A 160      25.547  32.395  16.568  1.00 34.09           C  
ATOM   1074  CD  PRO A 160      27.052  32.390  16.702  1.00 33.38           C  
ATOM   1075  N   ASP A 161      27.499  28.724  15.635  1.00 37.34           N  
ATOM   1076  CA  ASP A 161      27.897  27.463  15.021  1.00 38.74           C  
ATOM   1077  C   ASP A 161      28.716  26.595  15.970  1.00 38.81           C  
ATOM   1078  O   ASP A 161      29.090  25.473  15.629  1.00 40.28           O  
ATOM   1079  CB  ASP A 161      28.711  27.731  13.759  1.00 40.37           C  
ATOM   1080  CG  ASP A 161      30.078  28.299  14.063  1.00 42.07           C  
ATOM   1081  OD1 ASP A 161      30.161  29.311  14.788  1.00 44.94           O  
ATOM   1082  OD2 ASP A 161      31.074  27.732  13.578  1.00 43.76           O  
ATOM   1083  N   GLY A 162      28.998  27.113  17.159  1.00 37.95           N  
ATOM   1084  CA  GLY A 162      29.771  26.349  18.120  1.00 38.03           C  
ATOM   1085  C   GLY A 162      31.253  26.675  18.087  1.00 38.09           C  
ATOM   1086  O   GLY A 162      32.016  26.171  18.912  1.00 39.12           O  
ATOM   1087  N   THR A 163      31.654  27.524  17.141  1.00 37.39           N  
ATOM   1088  CA  THR A 163      33.052  27.933  16.980  1.00 36.48           C  
ATOM   1089  C   THR A 163      33.564  28.884  18.055  1.00 34.97           C  
ATOM   1090  O   THR A 163      33.005  29.961  18.261  1.00 34.95           O  
ATOM   1091  CB  THR A 163      33.274  28.607  15.610  1.00 36.14           C  
ATOM   1092  OG1 THR A 163      33.393  27.598  14.604  1.00 38.84           O  
ATOM   1093  CG2 THR A 163      34.535  29.461  15.616  1.00 37.02           C  
ATOM   1094  N   GLU A 164      34.640  28.477  18.726  1.00 32.86           N  
ATOM   1095  CA  GLU A 164      35.265  29.292  19.759  1.00 29.17           C  
ATOM   1096  C   GLU A 164      36.011  30.435  19.083  1.00 27.65           C  
ATOM   1097  O   GLU A 164      36.527  30.287  17.975  1.00 27.34           O  
ATOM   1098  CB  GLU A 164      36.239  28.449  20.578  1.00 29.91           C  
ATOM   1099  CG  GLU A 164      35.564  27.476  21.524  1.00 31.68           C  
ATOM   1100  CD  GLU A 164      36.489  26.358  21.980  1.00 33.63           C  
ATOM   1101  OE1 GLU A 164      36.752  25.436  21.174  1.00 32.20           O  
ATOM   1102  OE2 GLU A 164      36.957  26.405  23.138  1.00 34.32           O  
ATOM   1103  N   VAL A 165      36.063  31.575  19.757  1.00 25.90           N  
ATOM   1104  CA  VAL A 165      36.720  32.753  19.216  1.00 24.80           C  
ATOM   1105  C   VAL A 165      37.415  33.541  20.312  1.00 23.02           C  
ATOM   1106  O   VAL A 165      36.820  33.830  21.347  1.00 23.42           O  
ATOM   1107  CB  VAL A 165      35.695  33.677  18.517  1.00 25.50           C  
ATOM   1108  CG1 VAL A 165      36.260  35.076  18.353  1.00 26.71           C  
ATOM   1109  CG2 VAL A 165      35.340  33.106  17.157  1.00 28.16           C  
ATOM   1110  N   PRO A 166      38.693  33.897  20.099  1.00 21.62           N  
ATOM   1111  CA  PRO A 166      39.435  34.662  21.103  1.00 21.28           C  
ATOM   1112  C   PRO A 166      39.082  36.157  21.092  1.00 21.10           C  
ATOM   1113  O   PRO A 166      38.904  36.757  20.027  1.00 20.85           O  
ATOM   1114  CB  PRO A 166      40.888  34.416  20.709  1.00 19.33           C  
ATOM   1115  CG  PRO A 166      40.806  34.360  19.221  1.00 20.83           C  
ATOM   1116  CD  PRO A 166      39.581  33.492  18.992  1.00 20.33           C  
ATOM   1117  N   LEU A 167      38.970  36.733  22.287  1.00 20.55           N  
ATOM   1118  CA  LEU A 167      38.676  38.151  22.464  1.00 21.14           C  
ATOM   1119  C   LEU A 167      39.853  38.772  23.199  1.00 20.33           C  
ATOM   1120  O   LEU A 167      40.379  38.176  24.132  1.00 22.80           O  
ATOM   1121  CB  LEU A 167      37.416  38.352  23.300  1.00 20.77           C  
ATOM   1122  CG  LEU A 167      36.096  37.932  22.668  1.00 23.98           C  
ATOM   1123  CD1 LEU A 167      34.987  38.667  23.402  1.00 25.66           C  
ATOM   1124  CD2 LEU A 167      36.070  38.285  21.173  1.00 26.16           C  
ATOM   1125  N   TYR A 168      40.258  39.970  22.797  1.00 18.62           N  
ATOM   1126  CA  TYR A 168      41.389  40.622  23.447  1.00 16.37           C  
ATOM   1127  C   TYR A 168      41.066  41.990  23.995  1.00 15.51           C  
ATOM   1128  O   TYR A 168      40.123  42.651  23.557  1.00 13.68           O  
ATOM   1129  CB  TYR A 168      42.564  40.772  22.473  1.00 16.42           C  
ATOM   1130  CG  TYR A 168      43.038  39.473  21.877  1.00 16.13           C  
ATOM   1131  CD1 TYR A 168      42.648  39.088  20.593  1.00 15.16           C  
ATOM   1132  CD2 TYR A 168      43.869  38.616  22.605  1.00 16.33           C  
ATOM   1133  CE1 TYR A 168      43.079  37.876  20.051  1.00 15.28           C  
ATOM   1134  CE2 TYR A 168      44.299  37.410  22.076  1.00 14.85           C  
ATOM   1135  CZ  TYR A 168      43.902  37.045  20.799  1.00 15.00           C  
ATOM   1136  OH  TYR A 168      44.332  35.851  20.274  1.00 15.37           O  
ATOM   1137  N   ARG A 169      41.880  42.409  24.953  1.00 14.79           N  
ATOM   1138  CA  ARG A 169      41.755  43.716  25.564  1.00 16.41           C  
ATOM   1139  C   ARG A 169      43.137  44.134  26.023  1.00 14.64           C  
ATOM   1140  O   ARG A 169      43.811  43.393  26.738  1.00 14.79           O  
ATOM   1141  CB  ARG A 169      40.810  43.679  26.766  1.00 20.39           C  
ATOM   1142  CG  ARG A 169      39.323  43.689  26.432  1.00 26.93           C  
ATOM   1143  CD  ARG A 169      38.520  43.485  27.701  1.00 32.86           C  
ATOM   1144  NE  ARG A 169      39.046  44.334  28.767  1.00 39.40           N  
ATOM   1145  CZ  ARG A 169      38.893  44.100  30.068  1.00 43.04           C  
ATOM   1146  NH1 ARG A 169      38.217  43.031  30.488  1.00 44.85           N  
ATOM   1147  NH2 ARG A 169      39.443  44.925  30.954  1.00 43.18           N  
ATOM   1148  N   TYR A 170      43.573  45.312  25.588  1.00 13.94           N  
ATOM   1149  CA  TYR A 170      44.872  45.825  25.988  1.00 12.39           C  
ATOM   1150  C   TYR A 170      44.677  46.962  26.966  1.00 13.23           C  
ATOM   1151  O   TYR A 170      44.209  48.031  26.587  1.00 13.50           O  
ATOM   1152  CB  TYR A 170      45.665  46.343  24.791  1.00 11.15           C  
ATOM   1153  CG  TYR A 170      46.120  45.268  23.849  1.00 12.57           C  
ATOM   1154  CD1 TYR A 170      45.258  44.755  22.879  1.00 14.35           C  
ATOM   1155  CD2 TYR A 170      47.415  44.753  23.923  1.00 12.21           C  
ATOM   1156  CE1 TYR A 170      45.674  43.756  22.005  1.00 14.31           C  
ATOM   1157  CE2 TYR A 170      47.838  43.756  23.060  1.00 12.94           C  
ATOM   1158  CZ  TYR A 170      46.966  43.260  22.105  1.00 15.27           C  
ATOM   1159  OH  TYR A 170      47.372  42.249  21.269  1.00 18.29           O  
ATOM   1160  N   PRO A 171      45.009  46.736  28.246  1.00 12.88           N  
ATOM   1161  CA  PRO A 171      44.885  47.742  29.307  1.00 14.84           C  
ATOM   1162  C   PRO A 171      46.108  48.656  29.209  1.00 14.67           C  
ATOM   1163  O   PRO A 171      47.172  48.331  29.730  1.00 17.70           O  
ATOM   1164  CB  PRO A 171      44.913  46.911  30.593  1.00 16.12           C  
ATOM   1165  CG  PRO A 171      44.608  45.488  30.134  1.00 18.27           C  
ATOM   1166  CD  PRO A 171      45.307  45.413  28.811  1.00 13.97           C  
ATOM   1167  N   TRP A 172      45.958  49.796  28.548  1.00 13.18           N  
ATOM   1168  CA  TRP A 172      47.083  50.705  28.368  1.00 12.81           C  
ATOM   1169  C   TRP A 172      46.886  52.078  29.007  1.00 13.00           C  
ATOM   1170  O   TRP A 172      46.001  52.840  28.608  1.00 11.29           O  
ATOM   1171  CB  TRP A 172      47.360  50.870  26.871  1.00 12.89           C  
ATOM   1172  CG  TRP A 172      48.527  51.763  26.540  1.00 13.76           C  
ATOM   1173  CD1 TRP A 172      49.848  51.440  26.598  1.00 13.65           C  
ATOM   1174  CD2 TRP A 172      48.463  53.123  26.083  1.00 13.86           C  
ATOM   1175  NE1 TRP A 172      50.617  52.515  26.198  1.00 14.79           N  
ATOM   1176  CE2 TRP A 172      49.789  53.559  25.880  1.00 14.15           C  
ATOM   1177  CE3 TRP A 172      47.409  54.013  25.825  1.00 15.85           C  
ATOM   1178  CZ2 TRP A 172      50.096  54.853  25.429  1.00 16.65           C  
ATOM   1179  CZ3 TRP A 172      47.712  55.304  25.374  1.00 16.77           C  
ATOM   1180  CH2 TRP A 172      49.048  55.708  25.181  1.00 14.86           C  
ATOM   1181  N   ARG A 173      47.718  52.375  30.005  1.00 13.58           N  
ATOM   1182  CA  ARG A 173      47.693  53.657  30.705  1.00 14.21           C  
ATOM   1183  C   ARG A 173      46.351  54.095  31.256  1.00 13.61           C  
ATOM   1184  O   ARG A 173      46.038  55.287  31.272  1.00 14.91           O  
ATOM   1185  CB  ARG A 173      48.237  54.745  29.789  1.00 14.73           C  
ATOM   1186  CG  ARG A 173      49.678  54.500  29.435  1.00 18.01           C  
ATOM   1187  CD  ARG A 173      50.312  55.723  28.872  1.00 22.33           C  
ATOM   1188  NE  ARG A 173      51.753  55.555  28.721  1.00 24.10           N  
ATOM   1189  CZ  ARG A 173      52.534  56.469  28.164  1.00 24.07           C  
ATOM   1190  NH1 ARG A 173      51.992  57.594  27.725  1.00 26.48           N  
ATOM   1191  NH2 ARG A 173      53.836  56.255  28.024  1.00 24.08           N  
ATOM   1192  N   GLY A 174      45.560  53.136  31.715  1.00 13.09           N  
ATOM   1193  CA  GLY A 174      44.266  53.475  32.270  1.00 14.58           C  
ATOM   1194  C   GLY A 174      43.153  53.325  31.258  1.00 14.20           C  
ATOM   1195  O   GLY A 174      41.986  53.229  31.626  1.00 13.05           O  
ATOM   1196  N   LEU A 175      43.519  53.303  29.981  1.00 14.02           N  
ATOM   1197  CA  LEU A 175      42.541  53.159  28.914  1.00 13.89           C  
ATOM   1198  C   LEU A 175      42.315  51.685  28.620  1.00 14.25           C  
ATOM   1199  O   LEU A 175      43.161  50.844  28.914  1.00 14.41           O  
ATOM   1200  CB  LEU A 175      43.025  53.880  27.651  1.00 15.52           C  
ATOM   1201  CG  LEU A 175      43.210  55.399  27.767  1.00 14.76           C  
ATOM   1202  CD1 LEU A 175      43.739  55.955  26.445  1.00 16.98           C  
ATOM   1203  CD2 LEU A 175      41.887  56.059  28.130  1.00 15.73           C  
ATOM   1204  N   ASP A 176      41.167  51.377  28.032  1.00 15.37           N  
ATOM   1205  CA  ASP A 176      40.821  50.004  27.706  1.00 16.76           C  
ATOM   1206  C   ASP A 176      40.612  49.854  26.195  1.00 16.35           C  
ATOM   1207  O   ASP A 176      39.614  50.309  25.642  1.00 17.56           O  
ATOM   1208  CB  ASP A 176      39.558  49.613  28.492  1.00 21.69           C  
ATOM   1209  CG  ASP A 176      39.097  48.178  28.224  1.00 26.18           C  
ATOM   1210  OD1 ASP A 176      39.942  47.261  28.141  1.00 28.07           O  
ATOM   1211  OD2 ASP A 176      37.868  47.965  28.119  1.00 29.12           O  
ATOM   1212  N   ILE A 177      41.580  49.244  25.524  1.00 14.64           N  
ATOM   1213  CA  ILE A 177      41.480  49.025  24.090  1.00 14.04           C  
ATOM   1214  C   ILE A 177      40.885  47.625  23.924  1.00 15.24           C  
ATOM   1215  O   ILE A 177      41.490  46.635  24.338  1.00 16.13           O  
ATOM   1216  CB  ILE A 177      42.869  49.117  23.427  1.00 13.90           C  
ATOM   1217  CG1 ILE A 177      43.567  50.400  23.900  1.00 12.27           C  
ATOM   1218  CG2 ILE A 177      42.728  49.133  21.902  1.00 13.42           C  
ATOM   1219  CD1 ILE A 177      45.004  50.531  23.445  1.00  9.75           C  
ATOM   1220  N   TRP A 178      39.696  47.548  23.331  1.00 14.69           N  
ATOM   1221  CA  TRP A 178      39.006  46.270  23.161  1.00 15.41           C  
ATOM   1222  C   TRP A 178      38.299  46.106  21.816  1.00 15.12           C  
ATOM   1223  O   TRP A 178      38.402  46.958  20.937  1.00 15.01           O  
ATOM   1224  CB  TRP A 178      37.963  46.105  24.269  1.00 15.07           C  
ATOM   1225  CG  TRP A 178      36.894  47.170  24.229  1.00 18.20           C  
ATOM   1226  CD1 TRP A 178      36.974  48.434  24.745  1.00 18.46           C  
ATOM   1227  CD2 TRP A 178      35.604  47.080  23.594  1.00 18.74           C  
ATOM   1228  NE1 TRP A 178      35.821  49.134  24.469  1.00 20.37           N  
ATOM   1229  CE2 TRP A 178      34.966  48.328  23.765  1.00 19.52           C  
ATOM   1230  CE3 TRP A 178      34.930  46.066  22.896  1.00 18.15           C  
ATOM   1231  CZ2 TRP A 178      33.682  48.590  23.265  1.00 19.74           C  
ATOM   1232  CZ3 TRP A 178      33.647  46.332  22.398  1.00 19.44           C  
ATOM   1233  CH2 TRP A 178      33.043  47.582  22.587  1.00 18.42           C  
ATOM   1234  N   GLY A 179      37.577  44.994  21.681  1.00 14.28           N  
ATOM   1235  CA  GLY A 179      36.822  44.717  20.472  1.00 13.20           C  
ATOM   1236  C   GLY A 179      37.614  44.593  19.185  1.00 13.71           C  
ATOM   1237  O   GLY A 179      38.687  43.999  19.142  1.00 13.47           O  
ATOM   1238  N   MET A 180      37.066  45.167  18.123  1.00 13.38           N  
ATOM   1239  CA  MET A 180      37.689  45.122  16.811  1.00 14.10           C  
ATOM   1240  C   MET A 180      39.098  45.703  16.830  1.00 14.02           C  
ATOM   1241  O   MET A 180      40.017  45.118  16.263  1.00 12.66           O  
ATOM   1242  CB  MET A 180      36.815  45.880  15.805  1.00 17.29           C  
ATOM   1243  CG  MET A 180      37.273  45.787  14.357  1.00 21.70           C  
ATOM   1244  SD  MET A 180      38.129  47.276  13.796  1.00 28.03           S  
ATOM   1245  CE  MET A 180      36.765  48.235  13.196  1.00 26.70           C  
ATOM   1246  N   THR A 181      39.269  46.844  17.492  1.00 13.40           N  
ATOM   1247  CA  THR A 181      40.570  47.490  17.552  1.00 11.15           C  
ATOM   1248  C   THR A 181      41.636  46.593  18.188  1.00 11.68           C  
ATOM   1249  O   THR A 181      42.758  46.512  17.689  1.00 12.19           O  
ATOM   1250  CB  THR A 181      40.489  48.827  18.322  1.00 11.12           C  
ATOM   1251  OG1 THR A 181      39.526  49.684  17.691  1.00 12.05           O  
ATOM   1252  CG2 THR A 181      41.846  49.522  18.334  1.00 11.61           C  
ATOM   1253  N   ALA A 182      41.284  45.916  19.280  1.00 11.00           N  
ATOM   1254  CA  ALA A 182      42.225  45.037  19.971  1.00 11.36           C  
ATOM   1255  C   ALA A 182      42.547  43.799  19.132  1.00 12.57           C  
ATOM   1256  O   ALA A 182      43.664  43.285  19.157  1.00 13.31           O  
ATOM   1257  CB  ALA A 182      41.650  44.629  21.313  1.00 11.58           C  
ATOM   1258  N   ARG A 183      41.557  43.324  18.390  1.00 13.08           N  
ATOM   1259  CA  ARG A 183      41.727  42.159  17.535  1.00 14.26           C  
ATOM   1260  C   ARG A 183      42.731  42.497  16.432  1.00 13.22           C  
ATOM   1261  O   ARG A 183      43.600  41.690  16.095  1.00 14.10           O  
ATOM   1262  CB  ARG A 183      40.366  41.774  16.937  1.00 16.53           C  
ATOM   1263  CG  ARG A 183      40.382  40.689  15.877  1.00 19.35           C  
ATOM   1264  CD  ARG A 183      40.808  39.353  16.418  1.00 24.14           C  
ATOM   1265  NE  ARG A 183      41.993  38.888  15.717  1.00 31.98           N  
ATOM   1266  CZ  ARG A 183      42.375  37.619  15.650  1.00 36.46           C  
ATOM   1267  NH1 ARG A 183      41.657  36.673  16.241  1.00 37.07           N  
ATOM   1268  NH2 ARG A 183      43.488  37.300  14.996  1.00 41.59           N  
ATOM   1269  N   VAL A 184      42.607  43.699  15.875  1.00 12.19           N  
ATOM   1270  CA  VAL A 184      43.508  44.145  14.818  1.00 11.54           C  
ATOM   1271  C   VAL A 184      44.892  44.335  15.425  1.00 11.45           C  
ATOM   1272  O   VAL A 184      45.891  43.910  14.856  1.00 11.38           O  
ATOM   1273  CB  VAL A 184      43.033  45.480  14.194  1.00  9.84           C  
ATOM   1274  CG1 VAL A 184      44.062  45.997  13.190  1.00 10.32           C  
ATOM   1275  CG2 VAL A 184      41.694  45.280  13.498  1.00 10.32           C  
ATOM   1276  N   LEU A 185      44.931  44.965  16.595  1.00 12.83           N  
ATOM   1277  CA  LEU A 185      46.175  45.216  17.307  1.00 13.85           C  
ATOM   1278  C   LEU A 185      46.920  43.904  17.561  1.00 13.94           C  
ATOM   1279  O   LEU A 185      48.105  43.784  17.257  1.00 14.66           O  
ATOM   1280  CB  LEU A 185      45.859  45.907  18.634  1.00 13.74           C  
ATOM   1281  CG  LEU A 185      46.589  47.178  19.064  1.00 16.38           C  
ATOM   1282  CD1 LEU A 185      46.954  48.056  17.879  1.00 13.33           C  
ATOM   1283  CD2 LEU A 185      45.674  47.922  20.033  1.00 13.94           C  
ATOM   1284  N   HIS A 186      46.218  42.912  18.099  1.00 14.76           N  
ATOM   1285  CA  HIS A 186      46.838  41.628  18.395  1.00 16.42           C  
ATOM   1286  C   HIS A 186      47.398  40.967  17.142  1.00 17.00           C  
ATOM   1287  O   HIS A 186      48.468  40.359  17.178  1.00 16.87           O  
ATOM   1288  CB  HIS A 186      45.834  40.696  19.076  1.00 18.65           C  
ATOM   1289  CG  HIS A 186      46.432  39.407  19.545  1.00 20.37           C  
ATOM   1290  ND1 HIS A 186      46.522  38.291  18.744  1.00 20.78           N  
ATOM   1291  CD2 HIS A 186      46.981  39.062  20.736  1.00 22.72           C  
ATOM   1292  CE1 HIS A 186      47.097  37.310  19.419  1.00 22.48           C  
ATOM   1293  NE2 HIS A 186      47.386  37.753  20.630  1.00 22.51           N  
ATOM   1294  N   ASP A 187      46.675  41.085  16.034  1.00 17.70           N  
ATOM   1295  CA  ASP A 187      47.124  40.505  14.774  1.00 19.31           C  
ATOM   1296  C   ASP A 187      48.380  41.249  14.313  1.00 19.40           C  
ATOM   1297  O   ASP A 187      49.326  40.640  13.821  1.00 18.49           O  
ATOM   1298  CB  ASP A 187      46.038  40.631  13.714  1.00 25.21           C  
ATOM   1299  CG  ASP A 187      46.420  39.955  12.416  1.00 32.96           C  
ATOM   1300  OD1 ASP A 187      46.168  40.542  11.339  1.00 35.24           O  
ATOM   1301  OD2 ASP A 187      46.970  38.828  12.475  1.00 36.80           O  
ATOM   1302  N   LEU A 188      48.375  42.574  14.474  1.00 17.46           N  
ATOM   1303  CA  LEU A 188      49.519  43.403  14.105  1.00 17.71           C  
ATOM   1304  C   LEU A 188      50.731  42.972  14.920  1.00 18.91           C  
ATOM   1305  O   LEU A 188      51.835  42.848  14.394  1.00 19.95           O  
ATOM   1306  CB  LEU A 188      49.231  44.884  14.394  1.00 16.70           C  
ATOM   1307  CG  LEU A 188      50.456  45.809  14.398  1.00 17.74           C  
ATOM   1308  CD1 LEU A 188      50.994  45.934  12.986  1.00 20.46           C  
ATOM   1309  CD2 LEU A 188      50.089  47.176  14.943  1.00 18.84           C  
ATOM   1310  N   LEU A 189      50.520  42.749  16.211  1.00 18.97           N  
ATOM   1311  CA  LEU A 189      51.607  42.352  17.086  1.00 21.99           C  
ATOM   1312  C   LEU A 189      52.130  40.948  16.798  1.00 25.00           C  
ATOM   1313  O   LEU A 189      53.247  40.614  17.191  1.00 26.27           O  
ATOM   1314  CB  LEU A 189      51.167  42.477  18.546  1.00 20.11           C  
ATOM   1315  CG  LEU A 189      50.822  43.905  18.984  1.00 20.17           C  
ATOM   1316  CD1 LEU A 189      50.286  43.876  20.399  1.00 20.11           C  
ATOM   1317  CD2 LEU A 189      52.047  44.799  18.900  1.00 18.94           C  
ATOM   1318  N   GLU A 190      51.333  40.137  16.104  1.00 28.06           N  
ATOM   1319  CA  GLU A 190      51.723  38.766  15.752  1.00 32.13           C  
ATOM   1320  C   GLU A 190      52.004  38.630  14.253  1.00 34.48           C  
ATOM   1321  O   GLU A 190      53.111  39.011  13.814  1.00 35.38           O  
ATOM   1322  CB  GLU A 190      50.609  37.788  16.135  1.00 34.03           C  
ATOM   1323  CG  GLU A 190      50.329  37.725  17.624  1.00 36.64           C  
ATOM   1324  CD  GLU A 190      51.260  36.775  18.351  1.00 38.73           C  
ATOM   1325  OE1 GLU A 190      52.385  36.537  17.854  1.00 41.27           O  
ATOM   1326  OE2 GLU A 190      50.864  36.273  19.426  1.00 38.63           O  
TER    1327      GLU A 190                                                      
END
MOLECULE T0513_1_11_87_283.pdb
ATOM      7  N   MET     1      40.511  38.696  30.932  1.00 34.21           N  
ATOM      8  CA  MET     1      40.458  39.135  29.549  1.00 22.06           C  
ATOM      9  C   MET     1      41.682  38.517  28.896  1.00 20.62           C  
ATOM     10  O   MET     1      42.651  38.176  29.595  1.00 20.32           O  
ATOM     11  CB  MET     1      40.508  40.662  29.493  1.00 26.67           C  
ATOM     12  CG  MET     1      39.316  41.294  30.229  1.00 26.17           C  
ATOM     15  N   SER     2      41.648  38.358  27.573  1.00 18.56           N  
ATOM     16  CA  SER     2      42.745  37.762  26.830  1.00 17.53           C  
ATOM     17  C   SER     2      42.560  38.118  25.378  1.00 19.94           C  
ATOM     18  O   SER     2      41.495  38.598  24.988  1.00 17.05           O  
ATOM     19  CB  SER     2      42.710  36.228  26.946  1.00 17.75           C  
ATOM     20  OG  SER     2      41.480  35.716  26.386  1.00 17.41           O  
ATOM     21  N   PHE     3      43.586  37.860  24.569  1.00 16.42           N  
ATOM     22  CA  PHE     3      43.459  38.022  23.110  1.00 16.19           C  
ATOM     23  C   PHE     3      42.307  37.173  22.593  1.00 21.25           C  
ATOM     24  O   PHE     3      41.461  37.650  21.819  1.00 19.18           O  
ATOM     25  CB  PHE     3      44.739  37.581  22.397  1.00 16.58           C  
ATOM     26  CG  PHE     3      45.941  38.449  22.661  1.00 15.61           C  
ATOM     27  CD1 PHE     3      45.828  39.838  22.823  1.00 13.92           C  
ATOM     28  CD2 PHE     3      47.208  37.862  22.709  1.00 20.52           C  
ATOM     29  CE1 PHE     3      46.981  40.625  23.045  1.00 17.47           C  
ATOM     30  CE2 PHE     3      48.343  38.632  22.922  1.00 19.74           C  
ATOM     31  CZ  PHE     3      48.236  40.011  23.095  1.00 20.60           C  
ATOM     32  N   LEU     4      42.276  35.914  23.034  1.00 17.01           N  
ATOM     33  CA  LEU     4      41.300  34.959  22.547  1.00 17.54           C  
ATOM     34  C   LEU     4      39.864  35.393  22.852  1.00 15.99           C  
ATOM     35  O   LEU     4      38.998  35.315  21.978  1.00 18.48           O  
ATOM     36  CB  LEU     4      41.598  33.535  23.044  1.00 18.74           C  
ATOM     37  CG  LEU     4      40.593  32.443  22.590  1.00 23.52           C  
ATOM     38  CD1 LEU     4      40.527  32.284  21.070  1.00 23.88           C  
ATOM     39  CD2 LEU     4      40.891  31.090  23.260  1.00 23.18           C  
ATOM     40  N   LYS     5      39.637  35.880  24.072  1.00 17.97           N  
ATOM     41  CA  LYS     5      38.295  36.329  24.470  1.00 16.32           C  
ATOM     42  C   LYS     5      37.818  37.464  23.559  1.00 17.11           C  
ATOM     43  O   LYS     5      36.660  37.464  23.200  1.00 17.21           O  
ATOM     44  CB  LYS     5      38.234  36.758  25.934  1.00 25.30           C  
ATOM     45  CG  LYS     5      36.789  36.876  26.476  1.00 32.59           C  
ATOM     46  CD  LYS     5      36.697  37.899  27.624  1.00 46.27           C  
ATOM     47  CE  LYS     5      35.251  38.200  28.091  1.00 40.02           C  
ATOM     48  NZ  LYS     5      34.171  38.126  27.026  1.00 37.12           N  
ATOM     49  N   HIS     6      38.696  38.404  23.186  1.00 16.06           N  
ATOM     50  CA  HIS     6      38.317  39.478  22.227  1.00 19.72           C  
ATOM     51  C   HIS     6      37.859  38.902  20.880  1.00 17.75           C  
ATOM     52  O   HIS     6      36.864  39.336  20.280  1.00 17.62           O  
ATOM     53  CB  HIS     6      39.490  40.435  21.971  1.00 17.88           C  
ATOM     54  CG  HIS     6      39.760  41.393  23.082  1.00 26.05           C  
ATOM     55  ND1 HIS     6      38.778  42.169  23.654  1.00 23.15           N  
ATOM     56  CD2 HIS     6      40.912  41.716  23.719  1.00 20.43           C  
ATOM     57  CE1 HIS     6      39.305  42.917  24.607  1.00 24.59           C  
ATOM     58  NE2 HIS     6      40.601  42.674  24.658  1.00 23.21           N  
ATOM     59  N   VAL     7      38.607  37.911  20.395  1.00 19.93           N  
ATOM     60  CA  VAL     7      38.322  37.270  19.129  1.00 15.58           C  
ATOM     61  C   VAL     7      36.992  36.526  19.218  1.00 20.03           C  
ATOM     62  O   VAL     7      36.166  36.642  18.319  1.00 17.61           O  
ATOM     63  CB  VAL     7      39.521  36.349  18.692  1.00 18.90           C  
ATOM     64  CG1 VAL     7      39.154  35.465  17.528  1.00 22.87           C  
ATOM     65  CG2 VAL     7      40.777  37.213  18.386  1.00 17.72           C  
ATOM     66  N   GLN     8      36.777  35.822  20.329  1.00 18.18           N  
ATOM     67  CA  GLN     8      35.531  35.100  20.579  1.00 15.33           C  
ATOM     68  C   GLN     8      34.323  36.036  20.681  1.00 17.02           C  
ATOM     69  O   GLN     8      33.252  35.717  20.142  1.00 23.55           O  
ATOM     70  CB  GLN     8      35.662  34.259  21.842  1.00 20.01           C  
ATOM     71  CG  GLN     8      36.479  32.991  21.588  1.00 19.14           C  
ATOM     72  CD  GLN     8      36.808  32.235  22.869  1.00 26.74           C  
ATOM     73  OE1 GLN     8      36.820  32.801  23.960  1.00 25.57           O  
ATOM     74  NE2 GLN     8      37.099  30.951  22.729  1.00 29.56           N  
ATOM     75  N   ASP     9      34.514  37.181  21.363  1.00 16.26           N  
ATOM     76  CA  ASP     9      33.480  38.214  21.515  1.00 17.99           C  
ATOM     77  C   ASP     9      33.012  38.673  20.127  1.00 17.79           C  
ATOM     78  O   ASP     9      31.805  38.752  19.866  1.00 15.63           O  
ATOM     79  CB  ASP     9      34.018  39.459  22.245  1.00 20.20           C  
ATOM     80  CG  ASP     9      34.205  39.262  23.755  1.00 21.46           C  
ATOM     81  OD1 ASP     9      33.680  38.295  24.334  1.00 22.14           O  
ATOM     82  OD2 ASP     9      34.896  40.116  24.337  1.00 25.62           O  
ATOM     83  N   CYS    10      33.972  38.942  19.230  1.00 13.03           N  
ATOM     84  CA  CYS    10      33.660  39.396  17.882  1.00 17.68           C  
ATOM     85  C   CYS    10      33.082  38.342  16.932  1.00 17.69           C  
ATOM     86  O   CYS    10      32.679  38.677  15.815  1.00 18.01           O  
ATOM     87  CB  CYS    10      34.881  40.047  17.257  1.00 20.69           C  
ATOM     88  SG  CYS    10      35.334  41.640  18.054  1.00 22.02           S  
ATOM     89  N   ASN    11      33.044  37.089  17.377  1.00 16.85           N  
ATOM     90  CA  ASN    11      32.489  36.005  16.585  1.00 16.00           C  
ATOM     91  C   ASN    11      31.330  35.320  17.254  1.00 21.69           C  
ATOM     92  O   ASN    11      30.958  34.203  16.885  1.00 21.64           O  
ATOM     93  CB  ASN    11      33.593  35.035  16.168  1.00 18.19           C  
ATOM     94  CG  ASN    11      34.453  35.616  15.082  1.00 21.69           C  
ATOM     95  OD1 ASN    11      33.977  35.828  13.968  1.00 20.16           O  
ATOM     96  ND2 ASN    11      35.712  35.932  15.408  1.00 25.35           N  
ATOM    704  N   GLY    87      22.335  58.715   5.514  1.00 25.39           N  
ATOM    705  CA  GLY    87      22.831  59.252   4.250  1.00 24.83           C  
ATOM    706  C   GLY    87      24.088  58.667   3.650  1.00 25.87           C  
ATOM    707  O   GLY    87      24.394  58.938   2.496  1.00 27.78           O  
ATOM    708  N   GLU    88      24.826  57.861   4.409  1.00 22.13           N  
ATOM    709  CA  GLU    88      25.998  57.160   3.861  1.00 22.36           C  
ATOM    710  C   GLU    88      25.582  55.816   3.295  1.00 23.51           C  
ATOM    711  O   GLU    88      25.054  54.989   4.020  1.00 19.80           O  
ATOM    712  CB  GLU    88      27.074  56.962   4.933  1.00 21.74           C  
ATOM    713  CG  GLU    88      28.275  56.190   4.365  1.00 22.96           C  
ATOM    714  CD  GLU    88      29.489  56.189   5.269  1.00 29.30           C  
ATOM    715  OE1 GLU    88      29.367  56.503   6.472  1.00 33.52           O  
ATOM    716  OE2 GLU    88      30.570  55.860   4.759  1.00 24.96           O  
ATOM    717  N   LEU    89      25.810  55.583   2.004  1.00 20.88           N  
ATOM    718  CA  LEU    89      25.365  54.333   1.387  1.00 21.09           C  
ATOM    719  C   LEU    89      26.512  53.320   1.330  1.00 18.78           C  
ATOM    720  O   LEU    89      27.654  53.675   1.020  1.00 23.48           O  
ATOM    721  CB  LEU    89      24.801  54.587  -0.030  1.00 24.83           C  
ATOM    722  CG  LEU    89      23.590  55.510  -0.163  1.00 24.17           C  
ATOM    723  CD1 LEU    89      23.159  55.634  -1.627  1.00 26.09           C  
ATOM    724  CD2 LEU    89      22.440  55.047   0.719  1.00 26.85           C  
ATOM    725  N   TYR    90      26.193  52.062   1.617  1.00 16.23           N  
ATOM    726  CA  TYR    90      27.161  50.972   1.554  1.00 16.87           C  
ATOM    727  C   TYR    90      26.790  50.018   0.421  1.00 21.89           C  
ATOM    728  O   TYR    90      25.612  49.841   0.095  1.00 21.37           O  
ATOM    729  CB  TYR    90      27.108  50.166   2.857  1.00 19.18           C  
ATOM    730  CG  TYR    90      27.980  50.636   4.014  1.00 19.39           C  
ATOM    731  CD1 TYR    90      28.586  51.896   4.022  1.00 22.76           C  
ATOM    732  CD2 TYR    90      28.157  49.810   5.129  1.00 17.63           C  
ATOM    733  CE1 TYR    90      29.384  52.298   5.104  1.00 23.15           C  
ATOM    734  CE2 TYR    90      28.930  50.204   6.222  1.00 16.30           C  
ATOM    735  CZ  TYR    90      29.555  51.449   6.190  1.00 20.05           C  
ATOM    736  OH  TYR    90      30.322  51.863   7.267  1.00 20.00           O  
ATOM    737  N   ARG    91      27.794  49.363  -0.136  1.00 20.63           N  
ATOM    738  CA  ARG    91      27.555  48.370  -1.175  1.00 19.85           C  
ATOM    739  C   ARG    91      27.051  47.062  -0.576  1.00 20.29           C  
ATOM    740  O   ARG    91      27.473  46.654   0.518  1.00 19.32           O  
ATOM    741  CB  ARG    91      28.840  48.157  -2.011  1.00 19.59           C  
ATOM    742  CG  ARG    91      29.881  47.303  -1.337  1.00 26.33           C  
ATOM    743  CD  ARG    91      31.225  47.506  -1.966  1.00 24.05           C  
ATOM    744  NE  ARG    91      31.794  48.821  -1.681  1.00 21.42           N  
ATOM    745  CZ  ARG    91      32.772  49.356  -2.401  1.00 28.61           C  
ATOM    746  NH1 ARG    91      33.284  48.673  -3.417  1.00 23.53           N  
ATOM    747  NH2 ARG    91      33.260  50.541  -2.095  1.00 22.18           N  
ATOM    748  N   VAL    92      26.123  46.418  -1.279  1.00 18.57           N  
ATOM    749  CA  VAL    92      25.629  45.105  -0.875  1.00 16.93           C  
ATOM    750  C   VAL    92      26.147  44.058  -1.867  1.00 21.31           C  
ATOM    751  O   VAL    92      25.839  44.127  -3.082  1.00 19.91           O  
ATOM    752  CB  VAL    92      24.077  45.066  -0.843  1.00 19.63           C  
ATOM    753  CG1 VAL    92      23.561  43.626  -0.553  1.00 18.79           C  
ATOM    754  CG2 VAL    92      23.540  46.091   0.161  1.00 19.26           C  
ATOM    755  N   ASN    93      26.930  43.104  -1.352  1.00 18.20           N  
ATOM    756  CA  ASN    93      27.505  42.038  -2.178  1.00 21.74           C  
ATOM    757  C   ASN    93      27.698  40.762  -1.358  1.00 24.96           C  
ATOM    758  O   ASN    93      27.499  40.746  -0.136  1.00 22.57           O  
ATOM    759  CB  ASN    93      28.859  42.491  -2.788  1.00 18.95           C  
ATOM    760  CG  ASN    93      29.874  42.903  -1.719  1.00 18.59           C  
ATOM    761  OD1 ASN    93      29.937  42.301  -0.661  1.00 24.48           O  
ATOM    762  ND2 ASN    93      30.678  43.942  -2.005  1.00 22.24           N  
ATOM    763  N   GLN    94      28.152  39.704  -2.018  1.00 26.36           N  
ATOM    764  CA  GLN    94      28.433  38.446  -1.340  1.00 26.49           C  
ATOM    765  C   GLN    94      29.823  38.381  -0.751  1.00 30.49           C  
ATOM    766  O   GLN    94      30.080  37.583   0.146  1.00 36.86           O  
ATOM    767  CB  GLN    94      28.266  37.286  -2.304  1.00 37.10           C  
ATOM    768  CG  GLN    94      26.932  36.636  -2.224  1.00 37.93           C  
ATOM    769  CD  GLN    94      26.869  35.435  -3.124  1.00 49.22           C  
ATOM    770  OE1 GLN    94      27.271  35.502  -4.289  1.00 48.89           O  
ATOM    771  NE2 GLN    94      26.362  34.325  -2.598  1.00 50.15           N  
ATOM    772  N   SER    95      30.722  39.175  -1.320  1.00 27.55           N  
ATOM    773  CA  SER    95      32.069  39.392  -0.824  1.00 28.80           C  
ATOM    774  C   SER    95      32.682  40.521  -1.622  1.00 22.53           C  
ATOM    775  O   SER    95      32.128  40.970  -2.634  1.00 27.82           O  
ATOM    776  CB  SER    95      32.951  38.132  -0.907  1.00 35.68           C  
ATOM    777  OG  SER    95      32.898  37.568  -2.200  1.00 45.01           O  
ATOM    778  N   TRP    96      33.826  40.973  -1.150  1.00 24.95           N  
ATOM    779  CA  TRP    96      34.436  42.202  -1.609  1.00 25.45           C  
ATOM    780  C   TRP    96      34.681  42.248  -3.134  1.00 31.67           C  
ATOM    781  O   TRP    96      34.439  43.261  -3.783  1.00 27.35           O  
ATOM    782  CB  TRP    96      35.741  42.422  -0.848  1.00 22.30           C  
ATOM    783  CG  TRP    96      36.462  43.612  -1.369  1.00 24.98           C  
ATOM    784  CD1 TRP    96      37.632  43.618  -2.096  1.00 26.49           C  
ATOM    785  CD2 TRP    96      36.055  44.983  -1.250  1.00 26.86           C  
ATOM    786  NE1 TRP    96      37.962  44.903  -2.437  1.00 27.97           N  
ATOM    787  CE2 TRP    96      37.019  45.764  -1.932  1.00 21.43           C  
ATOM    788  CE3 TRP    96      34.974  45.630  -0.629  1.00 26.25           C  
ATOM    789  CZ2 TRP    96      36.931  47.158  -2.015  1.00 27.21           C  
ATOM    790  CZ3 TRP    96      34.891  47.010  -0.708  1.00 24.31           C  
ATOM    791  CH2 TRP    96      35.870  47.765  -1.392  1.00 26.46           C  
ATOM    792  N   GLY    97      35.167  41.155  -3.704  1.00 34.73           N  
ATOM    793  CA  GLY    97      35.381  41.134  -5.170  1.00 43.04           C  
ATOM    794  C   GLY    97      34.138  41.139  -6.057  1.00 39.97           C  
ATOM    795  O   GLY    97      34.185  41.591  -7.209  1.00 39.72           O  
ATOM    796  N   GLU    98      33.033  40.651  -5.503  1.00 32.97           N  
ATOM    797  CA  GLU    98      31.804  40.317  -6.230  1.00 27.55           C  
ATOM    798  C   GLU    98      31.010  41.563  -6.666  1.00 28.91           C  
ATOM    799  O   GLU    98      31.254  42.659  -6.156  1.00 28.40           O  
ATOM    800  CB  GLU    98      30.957  39.401  -5.344  1.00 31.83           C  
ATOM    801  CG  GLU    98      31.496  37.987  -5.178  1.00 44.11           C  
ATOM    802  CD  GLU    98      31.337  37.164  -6.427  1.00 58.39           C  
ATOM    803  OE1 GLU    98      32.363  36.906  -7.087  1.00 64.85           O  
ATOM    804  OE2 GLU    98      30.189  36.793  -6.761  1.00 62.34           O  
ATOM    805  N   PRO    99      30.088  41.417  -7.650  1.00 29.23           N  
ATOM    806  CA  PRO    99      29.327  42.602  -8.113  1.00 31.34           C  
ATOM    807  C   PRO    99      28.456  43.270  -7.032  1.00 22.94           C  
ATOM    808  O   PRO    99      27.910  42.597  -6.172  1.00 22.94           O  
ATOM    809  CB  PRO    99      28.421  42.028  -9.225  1.00 30.62           C  
ATOM    810  CG  PRO    99      29.121  40.763  -9.672  1.00 34.18           C  
ATOM    811  CD  PRO    99      29.736  40.207  -8.431  1.00 34.24           C  
ATOM    812  N   THR   100      28.385  44.577  -7.048  1.00 21.61           N  
ATOM    813  CA  THR   100      27.472  45.266  -6.184  1.00 22.07           C  
ATOM    814  C   THR   100      26.055  45.017  -6.668  1.00 23.86           C  
ATOM    815  O   THR   100      25.724  45.353  -7.758  1.00 27.37           O  
ATOM    816  CB  THR   100      27.794  46.753  -6.127  1.00 25.42           C  
ATOM    817  OG1 THR   100      29.070  46.950  -5.547  1.00 25.25           O  
ATOM    818  CG2 THR   100      26.768  47.493  -5.390  1.00 21.58           C  
ATOM    819  N   LEU   101      25.252  44.413  -5.827  1.00 22.26           N  
ATOM    820  CA  LEU   101      23.902  44.054  -6.147  1.00 22.54           C  
ATOM    821  C   LEU   101      22.868  45.162  -5.909  1.00 26.84           C  
ATOM    822  O   LEU   101      21.835  45.169  -6.511  1.00 22.64           O  
ATOM    823  CB  LEU   101      23.512  42.785  -5.421  1.00 23.42           C  
ATOM    824  CG  LEU   101      24.336  41.556  -5.780  1.00 23.60           C  
ATOM    825  CD1 LEU   101      24.021  40.422  -4.914  1.00 24.49           C  
ATOM    826  CD2 LEU   101      24.104  41.185  -7.208  1.00 23.72           C  
ATOM    827  N   MET   102      23.182  46.045  -4.985  1.00 22.55           N  
ATOM    828  CA  MET   102      22.371  47.178  -4.624  1.00 21.19           C  
ATOM    829  C   MET   102      23.150  47.968  -3.581  1.00 23.28           C  
ATOM    830  O   MET   102      24.171  47.532  -3.145  1.00 19.55           O  
ATOM    831  CB  MET   102      21.053  46.709  -4.017  1.00 19.31           C  
ATOM    832  CG  MET   102      21.164  45.928  -2.733  1.00 21.18           C  
ATOM    833  SD  MET   102      19.405  45.525  -1.916  0.70 23.50          SE  
ATOM    834  CE  MET   102      19.035  47.338  -1.459  1.00 18.91           C  
ATOM    835  N   LEU   103      22.596  49.100  -3.191  1.00 18.82           N  
ATOM    836  CA  LEU   103      23.106  49.922  -2.110  1.00 19.48           C  
ATOM    837  C   LEU   103      22.134  50.000  -0.941  1.00 20.90           C  
ATOM    838  O   LEU   103      20.948  49.907  -1.109  1.00 20.47           O  
ATOM    839  CB  LEU   103      23.457  51.333  -2.574  1.00 19.25           C  
ATOM    840  CG  LEU   103      24.264  51.497  -3.846  1.00 25.37           C  
ATOM    841  CD1 LEU   103      24.555  52.930  -4.178  1.00 22.48           C  
ATOM    842  CD2 LEU   103      25.523  50.763  -3.726  1.00 16.64           C  
ATOM    843  N   LEU   104      22.687  50.192   0.242  1.00 19.74           N  
ATOM    844  CA  LEU   104      21.923  50.226   1.458  1.00 21.14           C  
ATOM    845  C   LEU   104      22.505  51.224   2.435  1.00 24.21           C  
ATOM    846  O   LEU   104      23.680  51.307   2.604  1.00 20.89           O  
ATOM    847  CB  LEU   104      21.901  48.860   2.084  1.00 23.77           C  
ATOM    848  CG  LEU   104      20.943  48.484   3.187  1.00 22.11           C  
ATOM    849  CD1 LEU   104      19.549  48.698   2.787  1.00 21.93           C  
ATOM    850  CD2 LEU   104      21.194  47.061   3.593  1.00 18.00           C  
ATOM    851  N   ASP   105      21.646  52.004   3.040  1.00 23.13           N  
ATOM    852  CA  ASP   105      22.136  52.996   3.987  1.00 19.41           C  
ATOM    853  C   ASP   105      22.867  52.277   5.131  1.00 15.14           C  
ATOM    854  O   ASP   105      22.375  51.291   5.654  1.00 18.33           O  
ATOM    855  CB  ASP   105      20.977  53.801   4.552  1.00 20.99           C  
ATOM    856  CG  ASP   105      21.447  55.029   5.285  1.00 20.36           C  
ATOM    857  OD1 ASP   105      21.842  54.928   6.470  1.00 21.30           O  
ATOM    858  OD2 ASP   105      21.476  56.107   4.673  1.00 21.56           O  
ATOM    859  N   ARG   106      24.040  52.796   5.477  1.00 21.02           N  
ATOM    860  CA  ARG   106      24.899  52.258   6.546  1.00 18.68           C  
ATOM    861  C   ARG   106      24.099  51.988   7.824  1.00 22.99           C  
ATOM    862  O   ARG   106      24.278  50.952   8.482  1.00 19.07           O  
ATOM    863  CB  ARG   106      26.026  53.245   6.801  1.00 20.67           C  
ATOM    864  CG  ARG   106      26.860  52.965   8.042  1.00 26.03           C  
ATOM    865  CD  ARG   106      27.944  54.002   8.188  1.00 21.79           C  
ATOM    866  NE  ARG   106      28.772  53.685   9.350  1.00 28.51           N  
ATOM    867  CZ  ARG   106      29.995  54.161   9.567  1.00 36.58           C  
ATOM    868  NH1 ARG   106      30.556  55.013   8.713  1.00 24.41           N  
ATOM    869  NH2 ARG   106      30.663  53.784  10.651  1.00 37.44           N  
ATOM    870  N   ALA   107      23.138  52.862   8.127  1.00 16.60           N  
ATOM    871  CA  ALA   107      22.420  52.758   9.398  1.00 22.69           C  
ATOM    872  C   ALA   107      21.586  51.489   9.530  1.00 19.03           C  
ATOM    873  O   ALA   107      21.297  51.057  10.637  1.00 21.36           O  
ATOM    874  CB  ALA   107      21.549  53.986   9.636  1.00 23.29           C  
ATOM    875  N   VAL   108      21.235  50.881   8.402  1.00 17.20           N  
ATOM    876  CA  VAL   108      20.418  49.676   8.404  1.00 17.43           C  
ATOM    877  C   VAL   108      21.193  48.455   7.914  1.00 21.77           C  
ATOM    878  O   VAL   108      20.631  47.379   7.750  1.00 19.19           O  
ATOM    879  CB  VAL   108      19.055  49.853   7.627  1.00 21.96           C  
ATOM    880  CG1 VAL   108      18.186  50.936   8.289  1.00 20.29           C  
ATOM    881  CG2 VAL   108      19.268  50.173   6.131  1.00 19.03           C  
ATOM    882  N   VAL   109      22.492  48.618   7.699  1.00 19.07           N  
ATOM    883  CA  VAL   109      23.306  47.473   7.234  1.00 17.15           C  
ATOM    884  C   VAL   109      23.208  46.292   8.255  1.00 15.02           C  
ATOM    885  O   VAL   109      22.810  45.158   7.867  1.00 17.93           O  
ATOM    886  CB  VAL   109      24.732  47.951   6.781  1.00 19.33           C  
ATOM    887  CG1 VAL   109      25.788  46.856   6.910  1.00 17.69           C  
ATOM    888  CG2 VAL   109      24.659  48.517   5.317  1.00 18.99           C  
ATOM    889  N   PRO   110      23.436  46.541   9.582  1.00 17.55           N  
ATOM    890  CA  PRO   110      23.209  45.433  10.540  1.00 18.17           C  
ATOM    891  C   PRO   110      21.767  44.902  10.631  1.00 17.33           C  
ATOM    892  O   PRO   110      21.566  43.727  10.878  1.00 18.00           O  
ATOM    893  CB  PRO   110      23.693  46.011  11.877  1.00 18.05           C  
ATOM    894  CG  PRO   110      24.670  47.112  11.485  1.00 20.81           C  
ATOM    895  CD  PRO   110      23.988  47.725  10.264  1.00 16.19           C  
ATOM    896  N   THR   111      20.779  45.761  10.386  1.00 17.33           N  
ATOM    897  CA  THR   111      19.362  45.360  10.360  1.00 18.97           C  
ATOM    898  C   THR   111      19.067  44.300   9.285  1.00 19.99           C  
ATOM    899  O   THR   111      18.183  43.453   9.462  1.00 20.53           O  
ATOM    900  CB  THR   111      18.509  46.609  10.107  1.00 21.00           C  
ATOM    901  OG1 THR   111      18.776  47.555  11.154  1.00 23.41           O  
ATOM    902  CG2 THR   111      17.008  46.263  10.007  1.00 17.86           C  
ATOM    903  N   PHE   112      19.787  44.369   8.160  1.00 16.89           N  
ATOM    904  CA  PHE   112      19.636  43.371   7.109  1.00 17.37           C  
ATOM    905  C   PHE   112      20.737  42.314   7.152  1.00 18.91           C  
ATOM    906  O   PHE   112      20.770  41.443   6.284  1.00 19.04           O  
ATOM    907  CB  PHE   112      19.554  44.029   5.725  1.00 21.08           C  
ATOM    908  CG  PHE   112      18.251  44.732   5.507  1.00 21.38           C  
ATOM    909  CD1 PHE   112      17.161  44.054   4.924  1.00 21.83           C  
ATOM    910  CD2 PHE   112      18.069  46.030   5.976  1.00 21.21           C  
ATOM    911  CE1 PHE   112      15.922  44.701   4.770  1.00 23.45           C  
ATOM    912  CE2 PHE   112      16.824  46.676   5.822  1.00 26.65           C  
ATOM    913  CZ  PHE   112      15.772  46.010   5.224  1.00 23.26           C  
ATOM    914  N   GLY   113      21.619  42.408   8.160  1.00 17.00           N  
ATOM    915  CA  GLY   113      22.760  41.450   8.343  1.00 19.86           C  
ATOM    916  C   GLY   113      23.708  41.372   7.156  1.00 19.08           C  
ATOM    917  O   GLY   113      24.320  40.316   6.875  1.00 17.65           O  
ATOM    918  N   VAL   114      23.822  42.488   6.453  1.00 16.66           N  
ATOM    919  CA  VAL   114      24.617  42.622   5.241  1.00 20.98           C  
ATOM    920  C   VAL   114      26.109  42.813   5.587  1.00 14.90           C  
ATOM    921  O   VAL   114      26.453  43.461   6.583  1.00 17.95           O  
ATOM    922  CB  VAL   114      24.061  43.812   4.391  1.00 22.54           C  
ATOM    923  CG1 VAL   114      25.108  44.402   3.471  1.00 26.90           C  
ATOM    924  CG2 VAL   114      22.800  43.348   3.641  1.00 20.80           C  
ATOM    925  N   ARG   115      26.992  42.207   4.798  1.00 18.90           N  
ATOM    926  CA  ARG   115      28.424  42.369   5.025  0.50 18.89           C  
ATOM    928  C   ARG   115      28.865  43.824   4.888  1.00 20.95           C  
ATOM    929  O   ARG   115      28.477  44.509   3.934  1.00 21.03           O  
ATOM    930  CB  ARG   115      29.202  41.456   4.089  0.50 25.76           C  
ATOM    932  CG  ARG   115      28.836  39.990   4.312  0.50 30.32           C  
ATOM    934  CD  ARG   115      29.435  39.054   3.279  0.50 39.53           C  
ATOM    936  NE  ARG   115      30.793  39.438   2.908  0.50 40.24           N  
ATOM    938  CZ  ARG   115      31.874  39.233   3.650  0.50 35.64           C  
ATOM    940  NH1 ARG   115      33.037  39.641   3.194  0.50 37.10           N  
ATOM    942  NH2 ARG   115      31.801  38.652   4.846  0.50 44.23           N  
ATOM    944  N   ALA   116      29.631  44.298   5.874  1.00 15.80           N  
ATOM    945  CA  ALA   116      30.150  45.685   5.878  1.00 23.26           C  
ATOM    946  C   ALA   116      31.663  45.682   5.736  1.00 22.47           C  
ATOM    947  O   ALA   116      32.346  44.741   6.166  1.00 22.50           O  
ATOM    948  CB  ALA   116      29.767  46.415   7.151  1.00 18.37           C  
ATOM    949  N   TYR   117      32.186  46.762   5.178  1.00 16.80           N  
ATOM    950  CA  TYR   117      33.643  46.870   4.922  1.00 16.57           C  
ATOM    951  C   TYR   117      34.160  48.128   5.558  1.00 19.40           C  
ATOM    952  O   TYR   117      33.404  49.096   5.756  1.00 17.01           O  
ATOM    953  CB  TYR   117      33.920  46.873   3.397  1.00 17.31           C  
ATOM    954  CG  TYR   117      33.361  45.617   2.746  1.00 19.59           C  
ATOM    955  CD1 TYR   117      34.018  44.399   2.876  1.00 20.47           C  
ATOM    956  CD2 TYR   117      32.124  45.637   2.084  1.00 20.52           C  
ATOM    957  CE1 TYR   117      33.501  43.243   2.328  1.00 17.56           C  
ATOM    958  CE2 TYR   117      31.601  44.488   1.515  1.00 22.34           C  
ATOM    959  CZ  TYR   117      32.279  43.295   1.653  1.00 22.06           C  
ATOM    960  OH  TYR   117      31.744  42.169   1.124  1.00 21.87           O  
ATOM    961  N   GLY   118      35.448  48.143   5.874  1.00 19.03           N  
ATOM    962  CA  GLY   118      36.030  49.316   6.478  1.00 19.24           C  
ATOM    963  C   GLY   118      37.527  49.267   6.295  1.00 16.72           C  
ATOM    964  O   GLY   118      38.090  48.234   5.913  1.00 20.13           O  
ATOM    965  N   VAL   119      38.164  50.403   6.517  1.00 16.32           N  
ATOM    966  CA  VAL   119      39.604  50.494   6.412  1.00 15.00           C  
ATOM    967  C   VAL   119      40.169  50.936   7.753  1.00 22.40           C  
ATOM    968  O   VAL   119      39.583  51.799   8.435  1.00 22.82           O  
ATOM    969  CB  VAL   119      40.100  51.440   5.249  1.00 22.27           C  
ATOM    970  CG1 VAL   119      39.592  50.948   3.891  1.00 19.88           C  
ATOM    971  CG2 VAL   119      39.690  52.898   5.489  1.00 22.21           C  
ATOM    972  N   HIS   120      41.285  50.311   8.137  1.00 18.08           N  
ATOM    973  CA  HIS   120      41.968  50.589   9.417  1.00 19.70           C  
ATOM    974  C   HIS   120      43.453  50.730   9.187  1.00 21.42           C  
ATOM    975  O   HIS   120      44.094  49.860   8.570  1.00 20.16           O  
ATOM    976  CB  HIS   120      41.709  49.468  10.444  1.00 18.67           C  
ATOM    977  CG  HIS   120      40.288  49.423  10.918  1.00 20.33           C  
ATOM    978  ND1 HIS   120      39.921  49.778  12.195  1.00 18.82           N  
ATOM    979  CD2 HIS   120      39.142  49.097  10.276  1.00 22.07           C  
ATOM    980  CE1 HIS   120      38.609  49.662  12.326  1.00 20.40           C  
ATOM    981  NE2 HIS   120      38.114  49.271  11.167  1.00 21.07           N  
ATOM    982  N   LEU   121      43.992  51.845   9.667  1.00 17.73           N  
ATOM    983  CA  LEU   121      45.391  52.168   9.486  1.00 19.07           C  
ATOM    984  C   LEU   121      46.194  52.043  10.780  1.00 17.80           C  
ATOM    985  O   LEU   121      45.801  52.603  11.817  1.00 19.58           O  
ATOM    986  CB  LEU   121      45.541  53.594   8.939  1.00 16.96           C  
ATOM    987  CG  LEU   121      46.996  54.056   8.719  1.00 19.89           C  
ATOM    988  CD1 LEU   121      47.636  53.390   7.537  1.00 22.06           C  
ATOM    989  CD2 LEU   121      47.033  55.582   8.509  1.00 22.75           C  
ATOM    990  N   ASN   122      47.303  51.298  10.705  1.00 19.55           N  
ATOM    991  CA  ASN   122      48.301  51.221  11.781  1.00 21.15           C  
ATOM    992  C   ASN   122      49.405  52.240  11.517  1.00 19.94           C  
ATOM    993  O   ASN   122      50.271  52.018  10.667  1.00 21.83           O  
ATOM    994  CB  ASN   122      48.888  49.806  11.905  1.00 17.68           C  
ATOM    995  CG  ASN   122      47.824  48.744  12.154  1.00 26.32           C  
ATOM    996  OD1 ASN   122      47.116  48.776  13.163  1.00 22.92           O  
ATOM    997  ND2 ASN   122      47.707  47.804  11.238  1.00 18.70           N  
ATOM    998  N   GLY   123      49.334  53.381  12.208  1.00 20.19           N  
ATOM    999  CA  GLY   123      50.345  54.440  12.079  1.00 18.15           C  
ATOM   1000  C   GLY   123      51.381  54.310  13.171  1.00 21.64           C  
ATOM   1001  O   GLY   123      51.065  54.442  14.366  1.00 22.55           O  
ATOM   1002  N   TYR   124      52.620  54.067  12.763  1.00 22.90           N  
ATOM   1003  CA  TYR   124      53.694  53.774  13.698  1.00 25.90           C  
ATOM   1004  C   TYR   124      55.020  54.490  13.366  1.00 25.41           C  
ATOM   1005  O   TYR   124      55.209  54.987  12.233  1.00 23.58           O  
ATOM   1006  CB  TYR   124      53.884  52.237  13.832  1.00 21.31           C  
ATOM   1007  CG  TYR   124      54.369  51.536  12.592  1.00 27.55           C  
ATOM   1008  CD1 TYR   124      55.728  51.400  12.332  1.00 30.72           C  
ATOM   1009  CD2 TYR   124      53.469  50.982  11.680  1.00 27.78           C  
ATOM   1010  CE1 TYR   124      56.182  50.760  11.192  1.00 31.47           C  
ATOM   1011  CE2 TYR   124      53.919  50.339  10.543  1.00 30.81           C  
ATOM   1012  CZ  TYR   124      55.265  50.228  10.304  1.00 31.70           C  
ATOM   1013  OH  TYR   124      55.719  49.579   9.177  1.00 42.11           O  
ATOM   1014  N   VAL   125      55.895  54.566  14.384  1.00 29.81           N  
ATOM   1015  CA  VAL   125      57.235  55.137  14.244  0.50 32.58           C  
ATOM   1017  C   VAL   125      58.246  54.234  14.931  1.00 34.47           C  
ATOM   1018  O   VAL   125      57.929  53.543  15.901  1.00 36.28           O  
ATOM   1019  CB  VAL   125      57.365  56.610  14.786  0.50 31.90           C  
ATOM   1021  CG1 VAL   125      56.598  57.581  13.923  0.50 28.83           C  
ATOM   1023  CG2 VAL   125      56.931  56.736  16.248  0.50 25.63           C  
ATOM   1025  N   GLY   126      59.472  54.206  14.407  1.00 37.83           N  
ATOM   1026  CA  GLY   126      60.529  53.399  15.017  1.00 35.15           C  
ATOM   1027  C   GLY   126      60.513  51.960  14.553  1.00 37.66           C  
ATOM   1028  O   GLY   126      59.729  51.601  13.680  1.00 38.85           O  
ATOM   1029  N   ALA   127      61.400  51.144  15.123  1.00 41.73           N  
ATOM   1030  CA  ALA   127      61.486  49.714  14.808  1.00 44.35           C  
ATOM   1031  C   ALA   127      61.973  48.958  16.031  1.00 47.23           C  
ATOM   1032  O   ALA   127      62.529  49.566  16.954  1.00 46.60           O  
ATOM   1033  CB  ALA   127      62.415  49.466  13.622  1.00 46.56           C  
ATOM   1034  N   GLY   128      61.751  47.644  16.037  1.00 47.40           N  
ATOM   1035  CA  GLY   128      62.218  46.768  17.107  1.00 50.12           C  
ATOM   1036  C   GLY   128      61.766  47.220  18.479  1.00 51.85           C  
ATOM   1037  O   GLY   128      60.591  47.487  18.685  1.00 49.32           O  
ATOM   1038  N   ALA   129      62.719  47.366  19.398  1.00 53.70           N  
ATOM   1039  CA  ALA   129      62.427  47.766  20.776  1.00 52.09           C  
ATOM   1040  C   ALA   129      61.864  49.189  20.926  1.00 49.76           C  
ATOM   1041  O   ALA   129      61.302  49.525  21.971  1.00 51.31           O  
ATOM   1042  CB  ALA   129      63.673  47.580  21.661  1.00 58.37           C  
ATOM   1043  N   ASP   130      61.988  50.006  19.878  1.00 42.21           N  
ATOM   1044  CA  ASP   130      61.566  51.406  19.908  0.50 41.80           C  
ATOM   1046  C   ASP   130      60.292  51.658  19.075  1.00 36.31           C  
ATOM   1047  O   ASP   130      59.968  52.791  18.752  1.00 38.36           O  
ATOM   1048  CB  ASP   130      62.718  52.293  19.417  0.50 40.53           C  
ATOM   1050  CG  ASP   130      64.080  51.814  19.913  0.50 50.35           C  
ATOM   1052  OD1 ASP   130      64.218  51.549  21.128  0.50 52.59           O  
ATOM   1054  OD2 ASP   130      65.011  51.699  19.084  0.50 53.48           O  
ATOM   1056  N   LEU   131      59.587  50.592  18.717  1.00 34.21           N  
ATOM   1057  CA  LEU   131      58.357  50.692  17.930  1.00 32.36           C  
ATOM   1058  C   LEU   131      57.231  51.347  18.729  1.00 29.17           C  
ATOM   1059  O   LEU   131      56.875  50.888  19.824  1.00 31.74           O  
ATOM   1060  CB  LEU   131      57.936  49.290  17.504  1.00 33.48           C  
ATOM   1061  CG  LEU   131      56.788  49.115  16.520  1.00 38.03           C  
ATOM   1062  CD1 LEU   131      57.146  49.674  15.163  1.00 38.14           C  
ATOM   1063  CD2 LEU   131      56.476  47.633  16.402  1.00 34.66           C  
ATOM   1064  N   HIS   132      56.697  52.440  18.189  1.00 27.61           N  
ATOM   1065  CA  HIS   132      55.625  53.187  18.816  1.00 23.90           C  
ATOM   1066  C   HIS   132      54.403  53.300  17.890  1.00 24.13           C  
ATOM   1067  O   HIS   132      54.568  53.508  16.702  1.00 28.10           O  
ATOM   1068  CB  HIS   132      56.104  54.594  19.205  1.00 25.85           C  
ATOM   1069  CG  HIS   132      57.031  54.617  20.382  1.00 24.89           C  
ATOM   1070  ND1 HIS   132      56.661  55.116  21.613  1.00 30.01           N  
ATOM   1071  CD2 HIS   132      58.310  54.197  20.517  1.00 29.31           C  
ATOM   1072  CE1 HIS   132      57.673  55.006  22.453  1.00 26.14           C  
ATOM   1073  NE2 HIS   132      58.684  54.446  21.815  1.00 33.17           N  
ATOM   1074  N   LEU   133      53.202  53.178  18.454  1.00 28.30           N  
ATOM   1075  CA  LEU   133      51.965  53.311  17.693  0.50 25.22           C  
ATOM   1077  C   LEU   133      51.192  54.565  18.089  1.00 28.50           C  
ATOM   1078  O   LEU   133      51.068  54.881  19.279  1.00 28.20           O  
ATOM   1079  CB  LEU   133      51.074  52.082  17.888  0.50 25.92           C  
ATOM   1081  CG  LEU   133      51.376  50.838  17.050  0.50 26.92           C  
ATOM   1083  CD1 LEU   133      50.895  49.605  17.797  0.50 26.96           C  
ATOM   1085  CD2 LEU   133      50.773  50.929  15.631  0.50 14.39           C  
ATOM   1087  N   TRP   134      50.677  55.273  17.079  1.00 24.73           N  
ATOM   1088  CA  TRP   134      49.741  56.378  17.310  1.00 28.04           C  
ATOM   1089  C   TRP   134      48.363  55.790  17.526  1.00 21.54           C  
ATOM   1090  O   TRP   134      47.880  55.030  16.697  1.00 27.82           O  
ATOM   1091  CB  TRP   134      49.680  57.332  16.115  1.00 24.82           C  
ATOM   1092  CG  TRP   134      50.814  58.286  16.080  1.00 25.59           C  
ATOM   1093  CD1 TRP   134      51.899  58.229  15.270  1.00 25.75           C  
ATOM   1094  CD2 TRP   134      50.989  59.436  16.920  1.00 27.94           C  
ATOM   1095  NE1 TRP   134      52.752  59.290  15.539  1.00 32.80           N  
ATOM   1096  CE2 TRP   134      52.208  60.045  16.547  1.00 32.27           C  
ATOM   1097  CE3 TRP   134      50.226  60.016  17.948  1.00 29.66           C  
ATOM   1098  CZ2 TRP   134      52.694  61.209  17.178  1.00 32.34           C  
ATOM   1099  CZ3 TRP   134      50.701  61.175  18.566  1.00 27.78           C  
ATOM   1100  CH2 TRP   134      51.928  61.751  18.178  1.00 25.76           C  
ATOM   1101  N   ILE   135      47.743  56.157  18.633  1.00 20.49           N  
ATOM   1102  CA  ILE   135      46.424  55.667  19.012  1.00 23.64           C  
ATOM   1103  C   ILE   135      45.507  56.876  19.036  1.00 24.63           C  
ATOM   1104  O   ILE   135      45.884  57.934  19.535  1.00 25.53           O  
ATOM   1105  CB  ILE   135      46.491  54.994  20.443  1.00 25.95           C  
ATOM   1106  CG1 ILE   135      47.393  53.740  20.415  1.00 32.16           C  
ATOM   1107  CG2 ILE   135      45.105  54.739  21.036  1.00 28.52           C  
ATOM   1108  CD1 ILE   135      47.131  52.779  19.275  1.00 32.57           C  
ATOM   1109  N   GLY   136      44.291  56.729  18.517  1.00 22.14           N  
ATOM   1110  CA  GLY   136      43.312  57.788  18.672  1.00 23.75           C  
ATOM   1111  C   GLY   136      42.392  57.506  19.845  1.00 29.17           C  
ATOM   1112  O   GLY   136      42.214  56.345  20.221  1.00 26.20           O  
ATOM   1113  N   ARG   137      41.853  58.561  20.468  1.00 27.14           N  
ATOM   1114  CA  ARG   137      40.785  58.419  21.449  0.50 27.41           C  
ATOM   1116  C   ARG   137      39.521  58.970  20.802  1.00 26.20           C  
ATOM   1117  O   ARG   137      39.511  60.130  20.393  1.00 30.01           O  
ATOM   1118  CB  ARG   137      41.113  59.202  22.723  0.50 28.24           C  
ATOM   1120  CG  ARG   137      40.424  58.677  23.983  0.50 35.93           C  
ATOM   1122  CD  ARG   137      40.349  59.720  25.115  0.50 34.31           C  
ATOM   1124  NE  ARG   137      41.505  60.618  25.170  0.50 35.77           N  
ATOM   1126  CZ  ARG   137      42.654  60.353  25.790  0.50 35.38           C  
ATOM   1128  NH1 ARG   137      43.629  61.251  25.770  0.50 40.30           N  
ATOM   1130  NH2 ARG   137      42.837  59.204  26.431  0.50 38.83           N  
ATOM   1132  N   ARG   138      38.478  58.146  20.717  1.00 26.46           N  
ATOM   1133  CA  ARG   138      37.248  58.524  20.025  1.00 25.62           C  
ATOM   1134  C   ARG   138      36.522  59.630  20.787  1.00 30.91           C  
ATOM   1135  O   ARG   138      36.602  59.709  22.021  1.00 29.45           O  
ATOM   1136  CB  ARG   138      36.339  57.304  19.832  1.00 23.64           C  
ATOM   1137  CG  ARG   138      36.966  56.242  18.907  1.00 21.94           C  
ATOM   1138  CD  ARG   138      36.266  54.910  18.996  1.00 20.70           C  
ATOM   1139  NE  ARG   138      34.880  54.968  18.531  1.00 22.86           N  
ATOM   1140  CZ  ARG   138      34.529  54.986  17.247  1.00 20.39           C  
ATOM   1141  NH1 ARG   138      35.457  54.949  16.293  1.00 22.53           N  
ATOM   1142  NH2 ARG   138      33.259  55.024  16.912  1.00 23.32           N  
ATOM   1143  N   SER   139      35.824  60.482  20.046  1.00 30.82           N  
ATOM   1144  CA  SER   139      35.057  61.578  20.638  1.00 30.87           C  
ATOM   1145  C   SER   139      33.940  61.000  21.509  1.00 34.11           C  
ATOM   1146  O   SER   139      33.421  59.916  21.203  1.00 30.95           O  
ATOM   1147  CB  SER   139      34.488  62.454  19.511  1.00 33.82           C  
ATOM   1148  OG  SER   139      33.340  63.180  19.913  1.00 44.80           O  
ATOM   1149  N   PRO   140      33.553  61.712  22.597  1.00 38.34           N  
ATOM   1150  CA  PRO   140      32.428  61.225  23.417  1.00 34.53           C  
ATOM   1151  C   PRO   140      31.082  61.213  22.695  1.00 37.90           C  
ATOM   1152  O   PRO   140      30.154  60.542  23.157  1.00 31.63           O  
ATOM   1153  CB  PRO   140      32.380  62.217  24.592  1.00 39.75           C  
ATOM   1154  CG  PRO   140      33.679  62.919  24.569  1.00 42.46           C  
ATOM   1155  CD  PRO   140      34.111  62.964  23.141  1.00 37.78           C  
ATOM   1156  N   ASP   141      30.996  61.920  21.563  1.00 35.55           N  
ATOM   1157  CA  ASP   141      29.781  62.004  20.771  1.00 36.36           C  
ATOM   1158  C   ASP   141      29.584  60.825  19.802  1.00 34.79           C  
ATOM   1159  O   ASP   141      28.527  60.709  19.174  1.00 34.78           O  
ATOM   1160  CB  ASP   141      29.739  63.340  20.013  1.00 44.42           C  
ATOM   1161  CG  ASP   141      29.874  64.547  20.938  1.00 49.36           C  
ATOM   1162  OD1 ASP   141      29.306  64.515  22.049  1.00 56.17           O  
ATOM   1163  OD2 ASP   141      30.558  65.525  20.559  1.00 52.17           O  
ATOM   1164  N   LYS   142      30.576  59.939  19.681  1.00 29.21           N  
ATOM   1165  CA  LYS   142      30.384  58.752  18.851  1.00 25.30           C  
ATOM   1166  C   LYS   142      29.212  57.930  19.356  1.00 25.78           C  
ATOM   1167  O   LYS   142      29.064  57.680  20.568  1.00 27.08           O  
ATOM   1168  CB  LYS   142      31.640  57.870  18.797  1.00 27.48           C  
ATOM   1169  CG  LYS   142      32.783  58.447  17.985  1.00 21.74           C  
ATOM   1170  CD  LYS   142      32.458  58.500  16.487  1.00 23.30           C  
ATOM   1171  CE  LYS   142      33.691  58.863  15.653  1.00 37.56           C  
ATOM   1172  NZ  LYS   142      33.392  58.674  14.195  1.00 34.81           N  
ATOM   1173  N   SER   143      28.395  57.504  18.408  1.00 28.71           N  
ATOM   1174  CA  SER   143      27.291  56.609  18.662  1.00 30.64           C  
ATOM   1175  C   SER   143      27.787  55.255  19.212  1.00 34.84           C  
ATOM   1176  O   SER   143      27.203  54.700  20.156  1.00 33.01           O  
ATOM   1177  CB  SER   143      26.516  56.417  17.359  1.00 38.43           C  
ATOM   1178  OG  SER   143      25.518  55.421  17.483  1.00 52.04           O  
ATOM   1179  N   VAL   144      28.881  54.763  18.625  1.00 26.02           N  
ATOM   1180  CA  VAL   144      29.490  53.472  18.954  1.00 27.84           C  
ATOM   1181  C   VAL   144      30.828  53.714  19.640  1.00 24.68           C  
ATOM   1182  O   VAL   144      31.624  54.538  19.176  1.00 29.30           O  
ATOM   1183  CB  VAL   144      29.689  52.619  17.656  1.00 24.85           C  
ATOM   1184  CG1 VAL   144      30.577  51.388  17.923  1.00 28.55           C  
ATOM   1185  CG2 VAL   144      28.334  52.209  17.074  1.00 29.86           C  
ATOM   1186  N   ALA   145      31.073  53.020  20.760  1.00 28.68           N  
ATOM   1187  CA  ALA   145      32.369  53.094  21.450  1.00 27.24           C  
ATOM   1188  C   ALA   145      32.860  54.538  21.737  1.00 24.20           C  
ATOM   1189  O   ALA   145      34.024  54.866  21.456  1.00 24.03           O  
ATOM   1190  CB  ALA   145      33.455  52.282  20.649  1.00 22.65           C  
ATOM   1191  N   PRO   146      31.979  55.416  22.294  1.00 26.11           N  
ATOM   1192  CA  PRO   146      32.462  56.776  22.548  1.00 27.01           C  
ATOM   1193  C   PRO   146      33.556  56.753  23.604  1.00 27.01           C  
ATOM   1194  O   PRO   146      33.477  55.947  24.536  1.00 26.67           O  
ATOM   1195  CB  PRO   146      31.219  57.494  23.089  1.00 26.92           C  
ATOM   1196  CG  PRO   146      30.367  56.410  23.679  1.00 26.95           C  
ATOM   1197  CD  PRO   146      30.582  55.243  22.751  1.00 26.57           C  
ATOM   1198  N   GLY   147      34.583  57.584  23.429  1.00 23.06           N  
ATOM   1199  CA  GLY   147      35.705  57.661  24.359  1.00 27.37           C  
ATOM   1200  C   GLY   147      36.691  56.497  24.326  1.00 31.76           C  
ATOM   1201  O   GLY   147      37.667  56.505  25.074  1.00 28.82           O  
ATOM   1202  N   LYS   148      36.440  55.491  23.485  1.00 27.28           N  
ATOM   1203  CA  LYS   148      37.332  54.317  23.405  1.00 26.06           C  
ATOM   1204  C   LYS   148      38.557  54.579  22.543  1.00 24.99           C  
ATOM   1205  O   LYS   148      38.583  55.495  21.700  1.00 22.55           O  
ATOM   1206  CB  LYS   148      36.593  53.091  22.883  1.00 28.51           C  
ATOM   1207  CG  LYS   148      35.318  52.761  23.627  1.00 30.74           C  
ATOM   1208  CD  LYS   148      35.550  52.390  25.007  1.00 43.85           C  
ATOM   1209  CE  LYS   148      35.908  50.942  25.127  1.00 32.51           C  
ATOM   1210  NZ  LYS   148      35.988  50.749  26.579  1.00 28.96           N  
ATOM   1211  N   LEU   149      39.580  53.755  22.738  1.00 19.09           N  
ATOM   1212  CA  LEU   149      40.799  53.869  21.978  1.00 20.06           C  
ATOM   1213  C   LEU   149      40.618  53.178  20.614  1.00 21.55           C  
ATOM   1214  O   LEU   149      39.808  52.249  20.469  1.00 19.47           O  
ATOM   1215  CB  LEU   149      41.978  53.254  22.739  1.00 19.37           C  
ATOM   1216  CG  LEU   149      42.239  53.841  24.143  1.00 22.93           C  
ATOM   1217  CD1 LEU   149      43.478  53.201  24.754  1.00 25.48           C  
ATOM   1218  CD2 LEU   149      42.424  55.331  24.014  1.00 24.59           C  
ATOM   1219  N   ASP   150      41.386  53.643  19.642  1.00 19.17           N  
ATOM   1220  CA  ASP   150      41.137  53.381  18.214  1.00 17.87           C  
ATOM   1221  C   ASP   150      42.435  53.385  17.456  1.00 21.13           C  
ATOM   1222  O   ASP   150      43.464  53.839  17.963  1.00 19.36           O  
ATOM   1223  CB  ASP   150      40.216  54.510  17.665  1.00 22.49           C  
ATOM   1224  CG  ASP   150      39.310  54.075  16.479  1.00 28.89           C  
ATOM   1225  OD1 ASP   150      39.538  53.036  15.793  1.00 24.67           O  
ATOM   1226  OD2 ASP   150      38.338  54.829  16.218  1.00 21.49           O  
ATOM   1227  N   ASN   151      42.412  52.873  16.220  1.00 19.91           N  
ATOM   1228  CA  ASN   151      43.513  53.121  15.292  1.00 18.90           C  
ATOM   1229  C   ASN   151      43.692  54.630  15.039  1.00 19.61           C  
ATOM   1230  O   ASN   151      42.763  55.413  15.282  1.00 21.72           O  
ATOM   1231  CB  ASN   151      43.249  52.436  13.953  1.00 19.47           C  
ATOM   1232  CG  ASN   151      42.927  50.965  14.110  1.00 21.52           C  
ATOM   1233  OD1 ASN   151      41.774  50.562  13.988  1.00 25.50           O  
ATOM   1234  ND2 ASN   151      43.938  50.165  14.449  1.00 24.44           N  
ATOM   1235  N   MET   152      44.869  55.023  14.553  1.00 20.04           N  
ATOM   1236  CA  MET   152      45.111  56.424  14.225  1.00 22.73           C  
ATOM   1237  C   MET   152      44.070  56.899  13.189  1.00 23.86           C  
ATOM   1238  O   MET   152      43.521  58.014  13.289  1.00 21.66           O  
ATOM   1239  CB  MET   152      46.514  56.636  13.679  1.00 18.42           C  
ATOM   1240  CG  MET   152      46.859  58.149  13.591  1.00 23.68           C  
ATOM   1241  SD  MET   152      48.604  58.426  12.865  0.70 28.49          SE  
ATOM   1242  CE  MET   152      48.177  58.085  11.003  1.00 34.44           C  
ATOM   1243  N   VAL   153      43.777  56.029  12.217  1.00 20.16           N  
ATOM   1244  CA  VAL   153      42.762  56.323  11.194  1.00 19.57           C  
ATOM   1245  C   VAL   153      41.943  55.047  10.963  1.00 19.06           C  
ATOM   1246  O   VAL   153      42.516  53.975  10.822  1.00 20.64           O  
ATOM   1247  CB  VAL   153      43.415  56.792   9.862  1.00 20.96           C  
ATOM   1248  CG1 VAL   153      42.353  56.936   8.741  1.00 24.65           C  
ATOM   1249  CG2 VAL   153      44.159  58.106  10.035  1.00 22.39           C  
ATOM   1250  N   ALA   154      40.617  55.163  10.971  1.00 19.92           N  
ATOM   1251  CA  ALA   154      39.731  54.023  10.657  1.00 21.62           C  
ATOM   1252  C   ALA   154      38.397  54.570  10.228  1.00 25.62           C  
ATOM   1253  O   ALA   154      37.948  55.570  10.773  1.00 25.22           O  
ATOM   1254  CB  ALA   154      39.524  53.137  11.885  1.00 20.52           C  
ATOM   1255  N   GLY   155      37.735  53.910   9.291  1.00 19.78           N  
ATOM   1256  CA  GLY   155      36.358  54.302   8.976  1.00 23.92           C  
ATOM   1257  C   GLY   155      35.641  53.261   8.154  1.00 25.11           C  
ATOM   1258  O   GLY   155      36.280  52.417   7.521  1.00 20.50           O  
ATOM   1259  N   GLY   156      34.313  53.317   8.176  1.00 16.33           N  
ATOM   1260  CA  GLY   156      33.510  52.527   7.267  1.00 17.20           C  
ATOM   1261  C   GLY   156      33.756  52.878   5.803  1.00 17.21           C  
ATOM   1262  O   GLY   156      34.197  53.983   5.475  1.00 20.27           O  
ATOM   1263  N   GLN   157      33.468  51.919   4.926  1.00 21.75           N  
ATOM   1264  CA  GLN   157      33.725  52.051   3.502  1.00 18.48           C  
ATOM   1265  C   GLN   157      32.454  52.429   2.761  1.00 20.30           C  
ATOM   1266  O   GLN   157      31.530  51.630   2.670  1.00 19.32           O  
ATOM   1267  CB  GLN   157      34.219  50.733   2.932  1.00 20.97           C  
ATOM   1268  CG  GLN   157      34.585  50.817   1.450  1.00 17.60           C  
ATOM   1269  CD  GLN   157      35.776  51.699   1.251  1.00 22.34           C  
ATOM   1270  OE1 GLN   157      36.605  51.847   2.153  1.00 20.60           O  
ATOM   1271  NE2 GLN   157      35.886  52.292   0.068  1.00 22.64           N  
ATOM   1272  N   PRO   158      32.420  53.634   2.195  1.00 20.08           N  
ATOM   1273  CA  PRO   158      31.248  53.977   1.381  1.00 22.50           C  
ATOM   1274  C   PRO   158      31.248  53.236   0.035  1.00 19.52           C  
ATOM   1275  O   PRO   158      32.300  52.813  -0.455  1.00 22.07           O  
ATOM   1276  CB  PRO   158      31.373  55.491   1.172  1.00 25.22           C  
ATOM   1277  CG  PRO   158      32.803  55.820   1.440  1.00 26.79           C  
ATOM   1278  CD  PRO   158      33.400  54.730   2.294  1.00 20.41           C  
ATOM   1279  N   ALA   159      30.050  53.050  -0.505  1.00 21.68           N  
ATOM   1280  CA  ALA   159      29.832  52.394  -1.781  1.00 23.81           C  
ATOM   1281  C   ALA   159      30.622  53.032  -2.917  1.00 28.04           C  
ATOM   1282  O   ALA   159      31.044  52.329  -3.845  1.00 25.76           O  
ATOM   1283  CB  ALA   159      28.379  52.443  -2.120  1.00 28.69           C  
ATOM   1284  N   ASP   160      30.840  54.346  -2.847  1.00 24.07           N  
ATOM   1285  CA  ASP   160      31.271  55.058  -4.054  1.00 33.19           C  
ATOM   1286  C   ASP   160      32.778  55.280  -4.144  1.00 33.50           C  
ATOM   1287  O   ASP   160      33.247  55.930  -5.091  1.00 25.67           O  
ATOM   1288  CB  ASP   160      30.494  56.378  -4.237  1.00 30.97           C  
ATOM   1289  CG  ASP   160      30.814  57.410  -3.164  1.00 39.20           C  
ATOM   1290  OD1 ASP   160      31.210  57.017  -2.048  1.00 33.72           O  
ATOM   1291  OD2 ASP   160      30.659  58.620  -3.436  1.00 46.55           O  
ATOM   1292  N   LEU   161      33.521  54.729  -3.178  1.00 24.34           N  
ATOM   1293  CA  LEU   161      34.989  54.888  -3.136  1.00 22.16           C  
ATOM   1294  C   LEU   161      35.713  53.536  -3.169  1.00 25.00           C  
ATOM   1295  O   LEU   161      35.177  52.523  -2.695  1.00 23.70           O  
ATOM   1296  CB  LEU   161      35.414  55.651  -1.874  1.00 22.56           C  
ATOM   1297  CG  LEU   161      34.928  57.096  -1.657  1.00 30.24           C  
ATOM   1298  CD1 LEU   161      35.634  57.695  -0.437  1.00 27.83           C  
ATOM   1299  CD2 LEU   161      35.183  57.934  -2.909  1.00 23.35           C  
ATOM   1300  N   SER   162      36.929  53.543  -3.710  1.00 19.44           N  
ATOM   1301  CA  SER   162      37.896  52.441  -3.518  1.00 18.75           C  
ATOM   1302  C   SER   162      38.383  52.464  -2.051  1.00 16.03           C  
ATOM   1303  O   SER   162      38.138  53.432  -1.324  1.00 18.03           O  
ATOM   1304  CB  SER   162      39.094  52.550  -4.471  1.00 17.15           C  
ATOM   1305  OG  SER   162      39.999  53.562  -4.049  1.00 20.75           O  
ATOM   1306  N   LEU   163      39.050  51.391  -1.627  1.00 19.00           N  
ATOM   1307  CA  LEU   163      39.595  51.317  -0.272  1.00 18.42           C  
ATOM   1308  C   LEU   163      40.671  52.381  -0.112  1.00 19.29           C  
ATOM   1309  O   LEU   163      40.718  53.055   0.905  1.00 17.38           O  
ATOM   1310  CB  LEU   163      40.196  49.919  -0.020  1.00 15.49           C  
ATOM   1311  CG  LEU   163      39.127  48.827  -0.009  1.00 17.28           C  
ATOM   1312  CD1 LEU   163      39.794  47.445  -0.052  1.00 19.40           C  
ATOM   1313  CD2 LEU   163      38.208  48.916   1.206  1.00 21.21           C  
ATOM   1314  N   ARG   164      41.510  52.514  -1.135  1.00 17.15           N  
ATOM   1315  CA  ARG   164      42.623  53.462  -1.087  1.00 22.19           C  
ATOM   1316  C   ARG   164      42.088  54.905  -1.016  1.00 22.29           C  
ATOM   1317  O   ARG   164      42.616  55.747  -0.281  1.00 22.06           O  
ATOM   1318  CB  ARG   164      43.540  53.283  -2.294  1.00 24.55           C  
ATOM   1319  CG  ARG   164      44.631  54.375  -2.420  1.00 26.08           C  
ATOM   1320  CD  ARG   164      45.627  54.235  -1.296  1.00 29.30           C  
ATOM   1321  NE  ARG   164      46.362  52.975  -1.399  1.00 38.00           N  
ATOM   1322  CZ  ARG   164      47.405  52.647  -0.639  1.00 34.41           C  
ATOM   1323  NH1 ARG   164      47.838  53.476   0.317  1.00 28.73           N  
ATOM   1324  NH2 ARG   164      48.010  51.489  -0.842  1.00 29.91           N  
ATOM   1325  N   GLN   165      41.038  55.181  -1.780  1.00 20.52           N  
ATOM   1326  CA  GLN   165      40.438  56.522  -1.806  1.00 21.23           C  
ATOM   1327  C   GLN   165      39.844  56.868  -0.457  1.00 21.59           C  
ATOM   1328  O   GLN   165      40.038  57.982   0.062  1.00 20.84           O  
ATOM   1329  CB  GLN   165      39.336  56.598  -2.863  1.00 21.52           C  
ATOM   1330  CG  GLN   165      39.894  56.847  -4.261  1.00 28.49           C  
ATOM   1331  CD  GLN   165      39.029  56.265  -5.354  1.00 36.32           C  
ATOM   1332  OE1 GLN   165      37.806  56.063  -5.196  1.00 26.17           O  
ATOM   1333  NE2 GLN   165      39.665  55.986  -6.491  1.00 39.85           N  
ATOM   1334  N   ASN   166      39.107  55.918   0.106  1.00 21.23           N  
ATOM   1335  CA  ASN   166      38.535  56.108   1.415  1.00 22.05           C  
ATOM   1336  C   ASN   166      39.629  56.262   2.475  1.00 22.07           C  
ATOM   1337  O   ASN   166      39.542  57.133   3.315  1.00 20.60           O  
ATOM   1338  CB  ASN   166      37.599  54.967   1.791  1.00 20.63           C  
ATOM   1339  CG  ASN   166      36.757  55.305   3.021  1.00 23.47           C  
ATOM   1340  OD1 ASN   166      36.291  56.449   3.168  1.00 23.28           O  
ATOM   1341  ND2 ASN   166      36.583  54.349   3.904  1.00 18.78           N  
ATOM   1342  N   LEU   167      40.657  55.415   2.423  1.00 19.16           N  
ATOM   1343  CA  LEU   167      41.799  55.585   3.326  1.00 22.36           C  
ATOM   1344  C   LEU   167      42.376  57.018   3.244  1.00 27.44           C  
ATOM   1345  O   LEU   167      42.636  57.642   4.269  1.00 22.88           O  
ATOM   1346  CB  LEU   167      42.895  54.563   3.029  1.00 20.82           C  
ATOM   1347  CG  LEU   167      44.107  54.634   3.965  1.00 26.27           C  
ATOM   1348  CD1 LEU   167      43.730  54.259   5.425  1.00 21.08           C  
ATOM   1349  CD2 LEU   167      45.208  53.749   3.420  1.00 22.64           C  
ATOM   1350  N   ILE   168      42.555  57.538   2.028  1.00 26.93           N  
ATOM   1351  CA  ILE   168      43.115  58.897   1.843  1.00 25.17           C  
ATOM   1352  C   ILE   168      42.233  59.979   2.470  1.00 24.22           C  
ATOM   1353  O   ILE   168      42.714  60.859   3.184  1.00 23.88           O  
ATOM   1354  CB  ILE   168      43.383  59.177   0.341  1.00 28.80           C  
ATOM   1355  CG1 ILE   168      44.609  58.378  -0.097  1.00 21.59           C  
ATOM   1356  CG2 ILE   168      43.611  60.674   0.062  1.00 24.28           C  
ATOM   1357  CD1 ILE   168      44.644  58.115  -1.579  1.00 29.12           C  
ATOM   1358  N   LYS   169      40.942  59.881   2.215  1.00 21.03           N  
ATOM   1359  CA  LYS   169      39.965  60.802   2.753  1.00 25.69           C  
ATOM   1360  C   LYS   169      39.921  60.744   4.277  1.00 27.01           C  
ATOM   1361  O   LYS   169      39.920  61.770   4.938  1.00 24.12           O  
ATOM   1362  CB  LYS   169      38.605  60.472   2.187  1.00 20.71           C  
ATOM   1363  CG  LYS   169      37.441  61.203   2.821  1.00 28.07           C  
ATOM   1364  CD  LYS   169      36.119  60.764   2.225  1.00 44.80           C  
ATOM   1365  CE  LYS   169      34.965  61.166   3.143  1.00 54.68           C  
ATOM   1366  NZ  LYS   169      33.661  60.638   2.662  1.00 64.28           N  
ATOM   1367  N   GLU   170      39.906  59.538   4.834  1.00 18.72           N  
ATOM   1368  CA  GLU   170      39.874  59.382   6.287  1.00 20.09           C  
ATOM   1369  C   GLU   170      41.139  59.892   6.938  1.00 23.18           C  
ATOM   1370  O   GLU   170      41.073  60.468   8.020  1.00 27.45           O  
ATOM   1371  CB  GLU   170      39.622  57.917   6.696  1.00 22.79           C  
ATOM   1372  CG  GLU   170      38.258  57.350   6.280  1.00 25.29           C  
ATOM   1373  CD  GLU   170      37.049  58.059   6.906  1.00 40.32           C  
ATOM   1374  OE1 GLU   170      36.871  59.283   6.729  1.00 53.74           O  
ATOM   1375  OE2 GLU   170      36.237  57.371   7.550  1.00 42.38           O  
ATOM   1376  N   CYS   171      42.271  59.697   6.276  1.00 20.72           N  
ATOM   1377  CA  CYS   171      43.568  60.139   6.779  1.00 23.54           C  
ATOM   1378  C   CYS   171      43.620  61.653   6.964  1.00 30.29           C  
ATOM   1379  O   CYS   171      44.135  62.136   7.976  1.00 28.00           O  
ATOM   1380  CB  CYS   171      44.709  59.704   5.866  1.00 24.69           C  
ATOM   1381  SG  CYS   171      45.309  57.986   6.121  1.00 24.58           S  
ATOM   1382  N   ALA   172      43.089  62.377   5.974  1.00 25.84           N  
ATOM   1383  CA  ALA   172      42.997  63.838   6.024  1.00 26.87           C  
ATOM   1384  C   ALA   172      41.963  64.287   7.049  1.00 24.26           C  
ATOM   1385  O   ALA   172      42.255  65.126   7.889  1.00 28.18           O  
ATOM   1386  CB  ALA   172      42.653  64.407   4.617  1.00 26.01           C  
ATOM   1387  N   GLU   173      40.763  63.712   7.013  1.00 23.60           N  
ATOM   1388  CA  GLU   173      39.687  64.192   7.870  1.00 31.06           C  
ATOM   1389  C   GLU   173      39.919  63.865   9.345  1.00 31.04           C  
ATOM   1390  O   GLU   173      39.618  64.676  10.216  1.00 30.90           O  
ATOM   1391  CB  GLU   173      38.336  63.634   7.421  1.00 28.56           C  
ATOM   1392  CG  GLU   173      37.884  64.143   6.052  1.00 33.70           C  
ATOM   1393  CD  GLU   173      36.558  63.542   5.607  1.00 44.95           C  
ATOM   1394  OE1 GLU   173      36.107  62.539   6.213  1.00 52.84           O  
ATOM   1395  OE2 GLU   173      35.976  64.071   4.633  1.00 57.87           O  
ATOM   1396  N   GLU   174      40.459  62.683   9.625  1.00 27.71           N  
ATOM   1397  CA  GLU   174      40.521  62.220  11.005  1.00 24.57           C  
ATOM   1398  C   GLU   174      41.802  62.587  11.697  1.00 23.74           C  
ATOM   1399  O   GLU   174      41.819  62.763  12.916  1.00 27.22           O  
ATOM   1400  CB  GLU   174      40.311  60.703  11.110  1.00 21.95           C  
ATOM   1401  CG  GLU   174      38.903  60.226  10.741  1.00 31.09           C  
ATOM   1402  CD  GLU   174      38.726  58.714  10.905  1.00 40.24           C  
ATOM   1403  OE1 GLU   174      39.712  58.058  11.331  1.00 29.99           O  
ATOM   1404  OE2 GLU   174      37.601  58.194  10.616  1.00 30.74           O  
ATOM   1405  N   ALA   175      42.886  62.691  10.937  1.00 23.54           N  
ATOM   1406  CA  ALA   175      44.190  62.794  11.559  1.00 26.67           C  
ATOM   1407  C   ALA   175      45.070  63.861  10.933  1.00 23.54           C  
ATOM   1408  O   ALA   175      46.236  64.004  11.327  1.00 26.48           O  
ATOM   1409  CB  ALA   175      44.898  61.448  11.543  1.00 25.30           C  
ATOM   1410  N   ASP   176      44.536  64.581   9.945  1.00 30.87           N  
ATOM   1411  CA  ASP   176      45.316  65.624   9.266  1.00 31.29           C  
ATOM   1412  C   ASP   176      46.584  65.021   8.650  1.00 31.62           C  
ATOM   1413  O   ASP   176      47.680  65.585   8.741  1.00 26.14           O  
ATOM   1414  CB  ASP   176      45.645  66.754  10.271  1.00 35.88           C  
ATOM   1415  CG  ASP   176      46.111  68.041   9.596  1.00 44.42           C  
ATOM   1416  OD1 ASP   176      45.799  68.242   8.402  1.00 42.23           O  
ATOM   1417  OD2 ASP   176      46.803  68.835  10.266  1.00 45.65           O  
ATOM   1418  N   LEU   177      46.436  63.833   8.063  1.00 28.64           N  
ATOM   1419  CA  LEU   177      47.547  63.153   7.415  1.00 28.98           C  
ATOM   1420  C   LEU   177      47.363  63.336   5.912  1.00 29.59           C  
ATOM   1421  O   LEU   177      46.375  62.864   5.350  1.00 29.80           O  
ATOM   1422  CB  LEU   177      47.591  61.655   7.796  1.00 28.47           C  
ATOM   1423  CG  LEU   177      48.676  60.813   7.119  1.00 31.21           C  
ATOM   1424  CD1 LEU   177      50.059  61.193   7.567  1.00 43.08           C  
ATOM   1425  CD2 LEU   177      48.462  59.350   7.408  1.00 35.93           C  
ATOM   1426  N   PRO   178      48.287  64.075   5.272  1.00 36.79           N  
ATOM   1427  CA  PRO   178      48.150  64.497   3.880  1.00 35.44           C  
ATOM   1428  C   PRO   178      48.266  63.343   2.903  1.00 31.05           C  
ATOM   1429  O   PRO   178      48.832  62.296   3.248  1.00 31.49           O  
ATOM   1430  CB  PRO   178      49.332  65.455   3.684  1.00 38.30           C  
ATOM   1431  CG  PRO   178      50.349  65.018   4.692  1.00 42.22           C  
ATOM   1432  CD  PRO   178      49.543  64.563   5.873  1.00 35.40           C  
ATOM   1433  N   GLU   179      47.743  63.564   1.695  1.00 33.20           N  
ATOM   1434  CA  GLU   179      47.658  62.554   0.647  1.00 34.92           C  
ATOM   1435  C   GLU   179      48.979  61.886   0.297  1.00 33.77           C  
ATOM   1436  O   GLU   179      49.014  60.670   0.118  1.00 35.14           O  
ATOM   1437  CB  GLU   179      47.021  63.129  -0.615  1.00 35.78           C  
ATOM   1438  CG  GLU   179      46.777  62.071  -1.703  1.00 36.31           C  
ATOM   1439  CD  GLU   179      45.889  62.560  -2.842  1.00 45.49           C  
ATOM   1440  OE1 GLU   179      45.597  63.774  -2.898  1.00 52.73           O  
ATOM   1441  OE2 GLU   179      45.477  61.722  -3.677  1.00 45.51           O  
ATOM   1442  N   ALA   180      50.058  62.667   0.227  1.00 36.39           N  
ATOM   1443  CA  ALA   180      51.379  62.133  -0.131  1.00 38.20           C  
ATOM   1444  C   ALA   180      51.853  61.056   0.853  1.00 37.77           C  
ATOM   1445  O   ALA   180      52.397  60.028   0.444  1.00 41.56           O  
ATOM   1446  CB  ALA   180      52.416  63.260  -0.251  1.00 40.78           C  
ATOM   1447  N   LEU   181      51.627  61.294   2.142  1.00 36.73           N  
ATOM   1448  CA  LEU   181      51.914  60.280   3.160  1.00 34.41           C  
ATOM   1449  C   LEU   181      50.891  59.141   3.182  1.00 27.36           C  
ATOM   1450  O   LEU   181      51.282  57.985   3.216  1.00 31.68           O  
ATOM   1451  CB  LEU   181      52.044  60.908   4.548  1.00 31.23           C  
ATOM   1452  CG  LEU   181      53.424  61.415   4.958  1.00 44.99           C  
ATOM   1453  CD1 LEU   181      53.292  62.339   6.142  1.00 46.78           C  
ATOM   1454  CD2 LEU   181      54.331  60.242   5.304  1.00 49.35           C  
ATOM   1455  N   ALA   182      49.589  59.457   3.184  1.00 24.43           N  
ATOM   1456  CA  ALA   182      48.533  58.431   3.118  1.00 26.05           C  
ATOM   1457  C   ALA   182      48.706  57.419   1.980  1.00 30.74           C  
ATOM   1458  O   ALA   182      48.386  56.233   2.140  1.00 25.47           O  
ATOM   1459  CB  ALA   182      47.142  59.081   3.053  1.00 25.43           C  
ATOM   1460  N   ARG   183      49.211  57.878   0.829  1.00 28.18           N  
ATOM   1461  CA  ARG   183      49.477  56.998  -0.308  1.00 31.04           C  
ATOM   1462  C   ARG   183      50.649  56.021  -0.087  1.00 25.44           C  
ATOM   1463  O   ARG   183      50.764  55.015  -0.789  1.00 29.60           O  
ATOM   1464  CB  ARG   183      49.697  57.813  -1.595  1.00 29.99           C  
ATOM   1465  CG  ARG   183      48.406  58.279  -2.240  1.00 34.47           C  
ATOM   1466  CD  ARG   183      48.654  58.995  -3.593  1.00 43.53           C  
ATOM   1467  NE  ARG   183      47.418  59.526  -4.180  1.00 42.49           N  
ATOM   1468  CZ  ARG   183      46.495  58.799  -4.812  1.00 45.86           C  
ATOM   1469  NH1 ARG   183      46.631  57.479  -4.952  1.00 51.31           N  
ATOM   1470  NH2 ARG   183      45.416  59.395  -5.297  1.00 49.80           N  
ATOM   1471  N   GLN   184      51.530  56.332   0.857  1.00 30.80           N  
ATOM   1472  CA  GLN   184      52.625  55.422   1.196  1.00 31.05           C  
ATOM   1473  C   GLN   184      52.169  54.233   2.055  1.00 27.05           C  
ATOM   1474  O   GLN   184      52.927  53.271   2.211  1.00 26.28           O  
ATOM   1475  CB  GLN   184      53.746  56.175   1.903  1.00 30.65           C  
ATOM   1476  CG  GLN   184      54.521  57.145   1.003  1.00 43.67           C  
ATOM   1477  CD  GLN   184      55.464  58.044   1.787  1.00 47.15           C  
ATOM   1478  OE1 GLN   184      56.057  57.632   2.791  1.00 55.62           O  
ATOM   1479  NE2 GLN   184      55.603  59.284   1.334  1.00 61.22           N  
ATOM   1480  N   ALA   185      50.965  54.313   2.632  1.00 27.12           N  
ATOM   1481  CA  ALA   185      50.421  53.199   3.447  1.00 26.49           C  
ATOM   1482  C   ALA   185      50.296  51.947   2.601  1.00 23.37           C  
ATOM   1483  O   ALA   185      49.831  52.000   1.454  1.00 26.33           O  
ATOM   1484  CB  ALA   185      49.064  53.550   4.049  1.00 22.77           C  
ATOM   1485  N   ILE   186      50.731  50.817   3.148  1.00 19.54           N  
ATOM   1486  CA  ILE   186      50.664  49.592   2.367  1.00 18.61           C  
ATOM   1487  C   ILE   186      49.586  48.655   2.902  1.00 19.53           C  
ATOM   1488  O   ILE   186      49.412  48.540   4.122  1.00 18.61           O  
ATOM   1489  CB  ILE   186      52.028  48.867   2.298  1.00 25.65           C  
ATOM   1490  CG1 ILE   186      52.474  48.403   3.664  1.00 23.08           C  
ATOM   1491  CG2 ILE   186      53.119  49.766   1.611  1.00 32.33           C  
ATOM   1492  CD1 ILE   186      53.373  47.159   3.562  1.00 23.38           C  
ATOM   1493  N   PRO   187      48.855  47.988   1.999  1.00 21.38           N  
ATOM   1494  CA  PRO   187      47.867  47.043   2.502  1.00 15.78           C  
ATOM   1495  C   PRO   187      48.569  45.828   3.087  1.00 20.47           C  
ATOM   1496  O   PRO   187      49.607  45.439   2.576  1.00 16.31           O  
ATOM   1497  CB  PRO   187      47.064  46.657   1.256  1.00 17.27           C  
ATOM   1498  CG  PRO   187      47.952  46.981   0.098  1.00 20.64           C  
ATOM   1499  CD  PRO   187      48.888  48.061   0.519  1.00 18.84           C  
ATOM   1500  N   VAL   188      48.046  45.287   4.183  1.00 18.73           N  
ATOM   1501  CA  VAL   188      48.744  44.218   4.909  1.00 16.69           C  
ATOM   1502  C   VAL   188      47.866  43.014   5.242  1.00 18.23           C  
ATOM   1503  O   VAL   188      48.310  42.075   5.917  1.00 21.16           O  
ATOM   1504  CB  VAL   188      49.437  44.737   6.215  1.00 19.46           C  
ATOM   1505  CG1 VAL   188      50.608  45.617   5.888  1.00 19.96           C  
ATOM   1506  CG2 VAL   188      48.436  45.460   7.141  1.00 15.01           C  
ATOM   1507  N   GLY   189      46.614  43.047   4.783  1.00 16.49           N  
ATOM   1508  CA  GLY   189      45.738  41.913   5.015  1.00 18.91           C  
ATOM   1509  C   GLY   189      44.371  42.407   5.404  1.00 18.87           C  
ATOM   1510  O   GLY   189      44.031  43.575   5.182  1.00 19.08           O  
ATOM   1511  N   ALA   190      43.588  41.519   5.986  1.00 16.54           N  
ATOM   1512  CA  ALA   190      42.232  41.863   6.412  1.00 20.59           C  
ATOM   1513  C   ALA   190      41.818  41.013   7.596  1.00 22.26           C  
ATOM   1514  O   ALA   190      42.310  39.908   7.782  1.00 22.93           O  
ATOM   1515  CB  ALA   190      41.193  41.719   5.252  1.00 17.91           C  
ATOM   1516  N   ILE   191      40.876  41.527   8.372  1.00 18.64           N  
ATOM   1517  CA  ILE   191      40.209  40.733   9.408  1.00 18.43           C  
ATOM   1518  C   ILE   191      38.742  40.564   9.089  1.00 21.37           C  
ATOM   1519  O   ILE   191      38.120  41.492   8.588  1.00 17.81           O  
ATOM   1520  CB  ILE   191      40.403  41.440  10.771  1.00 18.60           C  
ATOM   1521  CG1 ILE   191      41.794  41.129  11.305  1.00 22.38           C  
ATOM   1522  CG2 ILE   191      39.357  41.046  11.813  1.00 22.58           C  
ATOM   1523  CD1 ILE   191      42.241  42.201  12.244  1.00 27.81           C  
ATOM   1524  N   THR   192      38.193  39.370   9.332  1.00 16.15           N  
ATOM   1525  CA  THR   192      36.762  39.137   9.160  0.50 18.17           C  
ATOM   1527  C   THR   192      36.165  38.562  10.457  1.00 22.84           C  
ATOM   1528  O   THR   192      36.755  37.666  11.076  1.00 19.70           O  
ATOM   1529  CB  THR   192      36.505  38.231   7.926  0.50 23.49           C  
ATOM   1531  OG1 THR   192      36.932  38.911   6.737  0.50 21.60           O  
ATOM   1533  CG2 THR   192      35.053  37.898   7.769  0.50 12.87           C  
ATOM   1535  N   TYR   193      35.003  39.065  10.863  1.00 16.92           N  
ATOM   1536  CA  TYR   193      34.320  38.490  12.035  1.00 16.58           C  
ATOM   1537  C   TYR   193      32.832  38.520  11.779  1.00 20.59           C  
ATOM   1538  O   TYR   193      32.369  39.156  10.815  1.00 17.01           O  
ATOM   1539  CB  TYR   193      34.676  39.237  13.327  1.00 18.38           C  
ATOM   1540  CG  TYR   193      34.347  40.713  13.291  1.00 15.91           C  
ATOM   1541  CD1 TYR   193      33.058  41.166  13.568  1.00 20.25           C  
ATOM   1542  CD2 TYR   193      35.328  41.646  12.962  1.00 20.34           C  
ATOM   1543  CE1 TYR   193      32.761  42.513  13.536  1.00 20.52           C  
ATOM   1544  CE2 TYR   193      35.040  43.000  12.920  1.00 19.27           C  
ATOM   1545  CZ  TYR   193      33.755  43.418  13.219  1.00 16.20           C  
ATOM   1546  OH  TYR   193      33.448  44.772  13.151  1.00 20.98           O  
ATOM   1547  N   CYS   194      32.082  37.834  12.631  1.00 17.08           N  
ATOM   1548  CA  CYS   194      30.631  37.908  12.541  1.00 22.60           C  
ATOM   1549  C   CYS   194      30.028  37.871  13.931  1.00 22.09           C  
ATOM   1550  O   CYS   194      30.080  36.838  14.620  1.00 18.58           O  
ATOM   1551  CB  CYS   194      30.050  36.795  11.661  1.00 20.95           C  
ATOM   1552  SG  CYS   194      28.234  36.914  11.524  1.00 23.38           S  
ATOM   1553  N   MET   195      29.462  38.998  14.343  1.00 17.69           N  
ATOM   1554  CA  MET   195      28.851  39.085  15.673  1.00 18.41           C  
ATOM   1555  C   MET   195      27.433  39.597  15.665  1.00 20.71           C  
ATOM   1556  O   MET   195      27.045  40.381  14.778  1.00 20.17           O  
ATOM   1557  CB  MET   195      29.698  39.933  16.620  1.00 18.74           C  
ATOM   1558  CG  MET   195      29.772  41.398  16.224  1.00 25.25           C  
ATOM   1559  SD  MET   195      30.880  42.412  17.429  0.70 30.47          SE  
ATOM   1560  CE  MET   195      30.018  41.990  19.031  1.00 22.83           C  
ATOM   1561  N   GLU   196      26.663  39.172  16.666  1.00 20.84           N  
ATOM   1562  CA  GLU   196      25.352  39.749  16.911  1.00 21.64           C  
ATOM   1563  C   GLU   196      25.582  41.092  17.613  1.00 22.83           C  
ATOM   1564  O   GLU   196      26.303  41.181  18.614  1.00 20.50           O  
ATOM   1565  CB  GLU   196      24.470  38.823  17.761  1.00 21.99           C  
ATOM   1566  CG  GLU   196      23.072  39.424  17.999  1.00 28.14           C  
ATOM   1567  CD  GLU   196      22.005  38.428  18.472  1.00 27.63           C  
ATOM   1568  OE1 GLU   196      22.157  37.202  18.283  1.00 27.80           O  
ATOM   1569  OE2 GLU   196      20.982  38.917  19.004  1.00 38.54           O  
ATOM   1570  N   SER   197      24.962  42.137  17.088  1.00 20.19           N  
ATOM   1571  CA  SER   197      25.125  43.478  17.619  1.00 15.72           C  
ATOM   1572  C   SER   197      23.742  43.912  18.167  1.00 19.33           C  
ATOM   1573  O   SER   197      22.786  43.161  18.009  1.00 18.28           O  
ATOM   1574  CB  SER   197      25.552  44.410  16.490  1.00 18.24           C  
ATOM   1575  OG  SER   197      24.526  44.513  15.506  1.00 20.58           O  
ATOM   1576  N   PRO   198      23.651  45.084  18.836  1.00 19.82           N  
ATOM   1577  CA  PRO   198      22.353  45.521  19.391  1.00 25.01           C  
ATOM   1578  C   PRO   198      21.172  45.509  18.409  1.00 27.78           C  
ATOM   1579  O   PRO   198      20.049  45.138  18.784  1.00 27.26           O  
ATOM   1580  CB  PRO   198      22.640  46.948  19.858  1.00 21.66           C  
ATOM   1581  CG  PRO   198      24.110  46.942  20.199  1.00 25.92           C  
ATOM   1582  CD  PRO   198      24.735  46.026  19.187  1.00 21.79           C  
ATOM   1583  N   ALA   199      21.424  45.881  17.158  1.00 21.66           N  
ATOM   1584  CA  ALA   199      20.334  46.028  16.176  1.00 20.92           C  
ATOM   1585  C   ALA   199      20.302  44.928  15.105  1.00 27.82           C  
ATOM   1586  O   ALA   199      19.410  44.909  14.244  1.00 27.25           O  
ATOM   1587  CB  ALA   199      20.406  47.399  15.539  1.00 23.88           C  
ATOM   1588  N   GLY   200      21.269  44.016  15.139  1.00 21.47           N  
ATOM   1589  CA  GLY   200      21.257  42.919  14.178  1.00 20.08           C  
ATOM   1590  C   GLY   200      22.517  42.076  14.199  1.00 23.27           C  
ATOM   1591  O   GLY   200      22.938  41.612  15.250  1.00 23.02           O  
ATOM   1592  N   ILE   201      23.078  41.891  13.011  1.00 19.61           N  
ATOM   1593  CA  ILE   201      24.189  40.982  12.725  0.50 20.79           C  
ATOM   1595  C   ILE   201      25.253  41.788  11.991  1.00 21.52           C  
ATOM   1596  O   ILE   201      24.917  42.492  11.034  1.00 19.17           O  
ATOM   1597  CB  ILE   201      23.712  39.817  11.789  0.50 19.77           C  
ATOM   1599  CG1 ILE   201      22.825  38.828  12.545  0.50 23.67           C  
ATOM   1601  CG2 ILE   201      24.901  39.052  11.128  0.50 23.88           C  
ATOM   1603  CD1 ILE   201      23.586  37.842  13.400  0.50 30.69           C  
ATOM   1605  N   LYS   202      26.513  41.644  12.395  1.00 17.46           N  
ATOM   1606  CA  LYS   202      27.615  42.393  11.804  1.00 16.91           C  
ATOM   1607  C   LYS   202      28.686  41.412  11.283  1.00 19.03           C  
ATOM   1608  O   LYS   202      29.577  41.041  12.051  1.00 17.60           O  
ATOM   1609  CB  LYS   202      28.244  43.287  12.861  1.00 19.47           C  
ATOM   1610  CG  LYS   202      27.405  44.510  13.236  1.00 15.46           C  
ATOM   1611  CD  LYS   202      28.072  45.440  14.221  1.00 22.65           C  
ATOM   1612  CE  LYS   202      29.321  46.142  13.706  1.00 24.43           C  
ATOM   1613  NZ  LYS   202      29.066  47.055  12.516  1.00 27.31           N  
ATOM   1614  N   PRO   203      28.593  41.006   9.994  1.00 16.72           N  
ATOM   1615  CA  PRO   203      29.596  40.167   9.326  1.00 17.50           C  
ATOM   1616  C   PRO   203      30.545  41.129   8.652  1.00 18.96           C  
ATOM   1617  O   PRO   203      30.338  41.527   7.498  1.00 22.69           O  
ATOM   1618  CB  PRO   203      28.772  39.361   8.315  1.00 23.12           C  
ATOM   1619  CG  PRO   203      27.382  40.061   8.235  1.00 20.40           C  
ATOM   1620  CD  PRO   203      27.492  41.331   9.070  1.00 16.33           C  
ATOM   1621  N   ASP   204      31.554  41.558   9.391  1.00 14.49           N  
ATOM   1622  CA  ASP   204      32.398  42.684   8.939  1.00 18.90           C  
ATOM   1623  C   ASP   204      33.757  42.241   8.446  1.00 19.68           C  
ATOM   1624  O   ASP   204      34.325  41.264   8.944  1.00 19.53           O  
ATOM   1625  CB  ASP   204      32.610  43.701  10.053  1.00 17.03           C  
ATOM   1626  CG  ASP   204      31.314  44.405  10.487  1.00 21.45           C  
ATOM   1627  OD1 ASP   204      30.277  44.283   9.809  1.00 24.51           O  
ATOM   1628  OD2 ASP   204      31.358  45.071  11.528  1.00 25.88           O  
ATOM   1629  N   THR   205      34.267  42.983   7.469  1.00 16.49           N  
ATOM   1630  CA  THR   205      35.645  42.835   6.979  1.00 18.97           C  
ATOM   1631  C   THR   205      36.391  44.138   7.145  1.00 22.03           C  
ATOM   1632  O   THR   205      35.931  45.179   6.680  1.00 20.97           O  
ATOM   1633  CB  THR   205      35.650  42.381   5.527  1.00 20.97           C  
ATOM   1634  OG1 THR   205      35.084  41.066   5.454  1.00 18.93           O  
ATOM   1635  CG2 THR   205      37.050  42.330   4.966  1.00 18.62           C  
ATOM   1636  N   LEU   206      37.530  44.089   7.834  1.00 17.58           N  
ATOM   1637  CA  LEU   206      38.394  45.264   8.026  1.00 17.07           C  
ATOM   1638  C   LEU   206      39.632  45.098   7.186  1.00 19.34           C  
ATOM   1639  O   LEU   206      40.434  44.205   7.447  1.00 19.57           O  
ATOM   1640  CB  LEU   206      38.815  45.454   9.519  1.00 19.70           C  
ATOM   1641  CG  LEU   206      37.830  45.184  10.672  1.00 30.19           C  
ATOM   1642  CD1 LEU   206      38.456  45.413  12.051  1.00 30.63           C  
ATOM   1643  CD2 LEU   206      36.637  46.012  10.534  1.00 34.18           C  
ATOM   1644  N   PHE   207      39.797  45.960   6.190  1.00 15.14           N  
ATOM   1645  CA  PHE   207      41.012  45.982   5.403  1.00 14.18           C  
ATOM   1646  C   PHE   207      42.077  46.767   6.142  1.00 15.69           C  
ATOM   1647  O   PHE   207      41.870  47.911   6.555  1.00 19.26           O  
ATOM   1648  CB  PHE   207      40.737  46.514   3.988  1.00 15.92           C  
ATOM   1649  CG  PHE   207      39.840  45.607   3.185  1.00 19.36           C  
ATOM   1650  CD1 PHE   207      40.348  44.442   2.573  1.00 17.29           C  
ATOM   1651  CD2 PHE   207      38.484  45.899   3.052  1.00 16.61           C  
ATOM   1652  CE1 PHE   207      39.502  43.583   1.817  1.00 15.95           C  
ATOM   1653  CE2 PHE   207      37.653  45.048   2.310  1.00 18.64           C  
ATOM   1654  CZ  PHE   207      38.160  43.894   1.703  1.00 21.53           C  
ATOM   1655  N   LEU   208      43.247  46.163   6.259  1.00 16.02           N  
ATOM   1656  CA  LEU   208      44.265  46.699   7.147  1.00 16.18           C  
ATOM   1657  C   LEU   208      45.422  47.286   6.362  1.00 15.99           C  
ATOM   1658  O   LEU   208      45.801  46.761   5.317  1.00 17.80           O  
ATOM   1659  CB  LEU   208      44.773  45.584   8.056  1.00 17.30           C  
ATOM   1660  CG  LEU   208      43.666  44.740   8.702  1.00 21.82           C  
ATOM   1661  CD1 LEU   208      44.249  43.562   9.423  1.00 24.62           C  
ATOM   1662  CD2 LEU   208      42.840  45.588   9.656  1.00 21.41           C  
ATOM   1663  N   TYR   209      45.954  48.390   6.877  1.00 16.64           N  
ATOM   1664  CA  TYR   209      47.074  49.114   6.254  1.00 13.20           C  
ATOM   1665  C   TYR   209      48.103  49.478   7.319  1.00 18.91           C  
ATOM   1666  O   TYR   209      47.733  49.720   8.469  1.00 17.11           O  
ATOM   1667  CB  TYR   209      46.541  50.406   5.583  1.00 19.14           C  
ATOM   1668  CG  TYR   209      45.645  50.126   4.407  1.00 14.54           C  
ATOM   1669  CD1 TYR   209      46.130  50.167   3.107  1.00 16.75           C  
ATOM   1670  CD2 TYR   209      44.278  49.801   4.595  1.00 21.68           C  
ATOM   1671  CE1 TYR   209      45.281  49.903   1.991  1.00 21.68           C  
ATOM   1672  CE2 TYR   209      43.439  49.519   3.496  1.00 21.31           C  
ATOM   1673  CZ  TYR   209      43.959  49.570   2.209  1.00 20.17           C  
ATOM   1674  OH  TYR   209      43.129  49.283   1.152  1.00 21.68           O  
ATOM   1675  N   ASP   210      49.384  49.472   6.942  1.00 17.51           N  
ATOM   1676  CA  ASP   210      50.474  49.899   7.816  1.00 20.05           C  
ATOM   1677  C   ASP   210      51.129  51.115   7.175  1.00 19.12           C  
ATOM   1678  O   ASP   210      51.344  51.150   5.939  1.00 21.30           O  
ATOM   1679  CB  ASP   210      51.578  48.821   7.908  1.00 17.73           C  
ATOM   1680  CG  ASP   210      51.330  47.777   8.969  1.00 23.66           C  
ATOM   1681  OD1 ASP   210      50.234  47.740   9.580  1.00 19.71           O  
ATOM   1682  OD2 ASP   210      52.246  46.941   9.154  1.00 19.66           O  
ATOM   1683  N   LEU   211      51.483  52.081   8.014  1.00 21.44           N  
ATOM   1684  CA  LEU   211      52.293  53.218   7.583  1.00 19.60           C  
ATOM   1685  C   LEU   211      53.371  53.590   8.618  1.00 28.52           C  
ATOM   1686  O   LEU   211      53.047  53.917   9.773  1.00 25.01           O  
ATOM   1687  CB  LEU   211      51.396  54.433   7.289  1.00 21.33           C  
ATOM   1688  CG  LEU   211      52.079  55.711   6.778  1.00 23.75           C  
ATOM   1689  CD1 LEU   211      52.892  55.427   5.515  1.00 28.56           C  
ATOM   1690  CD2 LEU   211      51.050  56.768   6.486  1.00 21.28           C  
ATOM   1691  N   ALA   212      54.636  53.535   8.184  1.00 24.81           N  
ATOM   1692  CA  ALA   212      55.787  54.018   8.964  1.00 29.85           C  
ATOM   1693  C   ALA   212      55.828  55.527   8.798  1.00 29.57           C  
ATOM   1694  O   ALA   212      56.058  56.036   7.697  1.00 32.92           O  
ATOM   1695  CB  ALA   212      57.068  53.405   8.459  1.00 27.38           C  
ATOM   1696  N   LEU   213      55.551  56.239   9.876  1.00 25.42           N  
ATOM   1697  CA  LEU   213      55.416  57.697   9.832  1.00 25.21           C  
ATOM   1698  C   LEU   213      56.746  58.407  10.143  1.00 33.84           C  
ATOM   1699  O   LEU   213      57.605  57.834  10.822  1.00 36.56           O  
ATOM   1700  CB  LEU   213      54.344  58.147  10.814  1.00 25.79           C  
ATOM   1701  CG  LEU   213      52.903  57.810  10.408  1.00 27.39           C  
ATOM   1702  CD1 LEU   213      51.998  57.831  11.609  1.00 22.21           C  
ATOM   1703  CD2 LEU   213      52.419  58.783   9.358  1.00 32.76           C  
ATOM   1704  N   PRO   214      56.921  59.654   9.646  1.00 36.16           N  
ATOM   1705  CA  PRO   214      58.100  60.427  10.057  1.00 39.31           C  
ATOM   1706  C   PRO   214      58.066  60.728  11.559  1.00 34.96           C  
ATOM   1707  O   PRO   214      56.983  60.938  12.125  1.00 32.07           O  
ATOM   1708  CB  PRO   214      57.956  61.741   9.269  1.00 37.83           C  
ATOM   1709  CG  PRO   214      57.019  61.437   8.155  1.00 42.05           C  
ATOM   1710  CD  PRO   214      56.072  60.421   8.720  1.00 34.03           C  
ATOM   1711  N   GLU   215      59.244  60.772  12.182  1.00 38.88           N  
ATOM   1712  CA  GLU   215      59.400  61.115  13.605  1.00 42.52           C  
ATOM   1713  C   GLU   215      58.699  62.427  13.981  1.00 40.78           C  
ATOM   1714  O   GLU   215      58.184  62.559  15.092  1.00 41.45           O  
ATOM   1715  CB  GLU   215      60.889  61.205  13.984  1.00 47.40           C  
ATOM   1716  CG  GLU   215      61.675  59.879  13.903  1.00 61.85           C  
ATOM   1717  CD  GLU   215      61.590  59.037  15.173  1.00 71.62           C  
ATOM   1718  OE1 GLU   215      61.330  59.612  16.254  1.00 77.66           O  
ATOM   1719  OE2 GLU   215      61.789  57.799  15.091  1.00 66.95           O  
ATOM   1720  N   ASP   216      58.667  63.374  13.043  1.00 40.78           N  
ATOM   1721  CA  ASP   216      58.096  64.696  13.291  1.00 42.30           C  
ATOM   1722  C   ASP   216      56.617  64.850  12.910  1.00 42.05           C  
ATOM   1723  O   ASP   216      56.042  65.911  13.149  1.00 40.61           O  
ATOM   1724  CB  ASP   216      58.958  65.813  12.665  1.00 47.09           C  
ATOM   1725  CG  ASP   216      58.932  65.811  11.131  1.00 58.78           C  
ATOM   1726  OD1 ASP   216      58.804  64.731  10.514  1.00 70.12           O  
ATOM   1727  OD2 ASP   216      59.056  66.903  10.535  1.00 58.84           O  
ATOM   1728  N   PHE   217      55.990  63.813  12.342  1.00 33.84           N  
ATOM   1729  CA  PHE   217      54.531  63.879  12.124  1.00 28.76           C  
ATOM   1730  C   PHE   217      53.736  63.857  13.447  1.00 28.64           C  
ATOM   1731  O   PHE   217      54.063  63.107  14.375  1.00 33.24           O  
ATOM   1732  CB  PHE   217      54.032  62.756  11.171  1.00 31.39           C  
ATOM   1733  CG  PHE   217      52.537  62.770  10.970  1.00 34.89           C  
ATOM   1734  CD1 PHE   217      51.953  63.682  10.090  1.00 31.80           C  
ATOM   1735  CD2 PHE   217      51.708  61.919  11.707  1.00 30.13           C  
ATOM   1736  CE1 PHE   217      50.574  63.734   9.928  1.00 35.26           C  
ATOM   1737  CE2 PHE   217      50.343  61.968  11.554  1.00 26.65           C  
ATOM   1738  CZ  PHE   217      49.767  62.879  10.664  1.00 30.87           C  
ATOM   1739  N   ARG   218      52.701  64.691  13.531  1.00 30.24           N  
ATOM   1740  CA  ARG   218      51.765  64.675  14.649  1.00 33.07           C  
ATOM   1741  C   ARG   218      50.362  64.664  14.087  1.00 33.27           C  
ATOM   1742  O   ARG   218      50.005  65.570  13.349  1.00 30.02           O  
ATOM   1743  CB  ARG   218      51.913  65.918  15.548  1.00 36.17           C  
ATOM   1744  CG  ARG   218      53.292  66.156  16.149  1.00 38.66           C  
ATOM   1745  CD  ARG   218      53.636  65.164  17.279  1.00 44.01           C  
ATOM   1746  NE  ARG   218      54.971  65.428  17.825  1.00 50.41           N  
ATOM   1747  CZ  ARG   218      56.105  64.916  17.348  1.00 48.17           C  
ATOM   1748  NH1 ARG   218      56.091  64.081  16.319  1.00 53.09           N  
ATOM   1749  NH2 ARG   218      57.263  65.226  17.916  1.00 52.78           N  
ATOM   1750  N   PRO   219      49.551  63.642  14.425  1.00 32.18           N  
ATOM   1751  CA  PRO   219      48.154  63.704  13.986  1.00 28.77           C  
ATOM   1752  C   PRO   219      47.327  64.817  14.674  1.00 35.00           C  
ATOM   1753  O   PRO   219      47.516  65.087  15.867  1.00 35.22           O  
ATOM   1754  CB  PRO   219      47.602  62.299  14.338  1.00 26.16           C  
ATOM   1755  CG  PRO   219      48.499  61.797  15.400  1.00 29.84           C  
ATOM   1756  CD  PRO   219      49.859  62.389  15.144  1.00 29.45           C  
ATOM   1757  N   HIS   220      46.438  65.469  13.920  1.00 30.48           N  
ATOM   1758  CA  HIS   220      45.476  66.413  14.512  1.00 32.09           C  
ATOM   1759  C   HIS   220      44.077  66.058  14.111  1.00 30.14           C  
ATOM   1760  O   HIS   220      43.835  65.693  12.971  1.00 30.55           O  
ATOM   1761  CB  HIS   220      45.781  67.860  14.106  1.00 37.92           C  
ATOM   1762  CG  HIS   220      47.209  68.246  14.322  1.00 41.04           C  
ATOM   1763  ND1 HIS   220      48.122  68.330  13.293  1.00 50.01           N  
ATOM   1764  CD2 HIS   220      47.894  68.530  15.457  1.00 45.11           C  
ATOM   1765  CE1 HIS   220      49.305  68.660  13.781  1.00 40.41           C  
ATOM   1766  NE2 HIS   220      49.194  68.786  15.092  1.00 44.64           N  
ATOM   1767  N   ASN   221      43.153  66.229  15.047  1.00 25.59           N  
ATOM   1768  CA  ASN   221      41.767  65.783  14.921  1.00 31.42           C  
ATOM   1769  C   ASN   221      40.854  66.733  14.118  1.00 34.72           C  
ATOM   1770  O   ASN   221      39.805  67.183  14.617  1.00 40.74           O  
ATOM   1771  CB  ASN   221      41.192  65.500  16.330  1.00 32.04           C  
ATOM   1772  CG  ASN   221      41.034  66.778  17.195  1.00 41.90           C  
ATOM   1773  OD1 ASN   221      41.773  67.752  17.028  1.00 42.49           O  
ATOM   1774  ND2 ASN   221      40.056  66.768  18.105  1.00 30.00           N  
ATOM   1775  N   THR   222      41.229  66.990  12.866  1.00 34.65           N  
ATOM   1776  CA  THR   222      40.516  67.939  11.978  1.00 37.42           C  
ATOM   1777  C   THR   222      38.978  67.898  12.029  1.00 39.37           C  
ATOM   1778  O   THR   222      38.344  68.925  12.252  1.00 40.20           O  
ATOM   1779  CB  THR   222      41.007  67.833  10.506  1.00 40.30           C  
ATOM   1780  OG1 THR   222      42.441  67.862  10.475  1.00 38.41           O  
ATOM   1781  CG2 THR   222      40.467  68.991   9.654  1.00 37.82           C  
ATOM   1782  N   ASP   223      38.375  66.725  11.856  1.00 33.08           N  
ATOM   1783  CA  ASP   223      36.914  66.646  11.873  1.00 36.16           C  
ATOM   1784  C   ASP   223      36.279  66.357  13.243  1.00 36.45           C  
ATOM   1785  O   ASP   223      35.053  66.241  13.343  1.00 38.37           O  
ATOM   1786  CB  ASP   223      36.392  65.690  10.786  1.00 37.98           C  
ATOM   1787  CG  ASP   223      36.618  64.223  11.118  1.00 42.50           C  
ATOM   1788  OD1 ASP   223      37.293  63.886  12.122  1.00 34.80           O  
ATOM   1789  OD2 ASP   223      36.106  63.402  10.344  1.00 36.90           O  
ATOM   1790  N   GLY   224      37.111  66.244  14.282  1.00 35.55           N  
ATOM   1791  CA  GLY   224      36.630  66.034  15.654  1.00 36.89           C  
ATOM   1792  C   GLY   224      36.020  64.671  15.976  1.00 36.39           C  
ATOM   1793  O   GLY   224      35.449  64.482  17.054  1.00 40.38           O  
ATOM   1794  N   GLU   225      36.125  63.723  15.042  1.00 32.74           N  
ATOM   1795  CA  GLU   225      35.722  62.336  15.276  1.00 33.39           C  
ATOM   1796  C   GLU   225      36.597  61.697  16.367  1.00 31.95           C  
ATOM   1797  O   GLU   225      36.143  60.836  17.113  1.00 26.70           O  
ATOM   1798  CB  GLU   225      35.884  61.520  13.996  1.00 34.72           C  
ATOM   1799  CG  GLU   225      34.769  61.677  12.971  1.00 35.77           C  
ATOM   1800  CD  GLU   225      34.913  60.657  11.831  1.00 48.02           C  
ATOM   1801  OE1 GLU   225      34.275  59.583  11.894  1.00 36.79           O  
ATOM   1802  OE2 GLU   225      35.692  60.911  10.885  1.00 46.05           O  
ATOM   1803  N   MET   226      37.861  62.104  16.409  1.00 30.60           N  
ATOM   1804  CA  MET   226      38.780  61.764  17.497  1.00 33.62           C  
ATOM   1805  C   MET   226      38.879  62.927  18.495  1.00 35.35           C  
ATOM   1806  O   MET   226      39.017  64.078  18.089  1.00 34.95           O  
ATOM   1807  CB  MET   226      40.182  61.499  16.949  1.00 30.26           C  
ATOM   1808  CG  MET   226      40.305  60.311  16.011  1.00 38.22           C  
ATOM   1809  SD  MET   226      39.791  58.599  16.819  0.70 33.77          SE  
ATOM   1810  CE  MET   226      40.212  57.510  15.238  1.00 43.66           C  
ATOM   1811  N   ALA   227      38.835  62.611  19.788  1.00 30.11           N  
ATOM   1812  CA  ALA   227      39.070  63.585  20.851  1.00 30.34           C  
ATOM   1813  C   ALA   227      40.531  64.052  20.907  1.00 38.31           C  
ATOM   1814  O   ALA   227      40.797  65.253  21.065  1.00 39.38           O  
ATOM   1815  CB  ALA   227      38.624  63.028  22.201  1.00 32.23           C  
ATOM   1816  N   ASP   228      41.459  63.100  20.764  1.00 29.95           N  
ATOM   1817  CA  ASP   228      42.897  63.383  20.736  0.50 32.07           C  
ATOM   1819  C   ASP   228      43.640  62.133  20.291  1.00 31.14           C  
ATOM   1820  O   ASP   228      43.016  61.111  19.979  1.00 30.62           O  
ATOM   1821  CB  ASP   228      43.422  63.840  22.108  0.50 37.97           C  
ATOM   1823  CG  ASP   228      43.307  62.764  23.162  0.50 37.14           C  
ATOM   1825  OD1 ASP   228      42.167  62.425  23.532  0.50 39.67           O  
ATOM   1827  OD2 ASP   228      44.356  62.264  23.619  0.50 48.07           O  
ATOM   1829  N   PHE   229      44.961  62.237  20.221  1.00 23.57           N  
ATOM   1830  CA  PHE   229      45.842  61.157  19.805  1.00 28.22           C  
ATOM   1831  C   PHE   229      46.978  60.986  20.814  1.00 32.28           C  
ATOM   1832  O   PHE   229      47.356  61.956  21.464  1.00 29.69           O  
ATOM   1833  CB  PHE   229      46.454  61.481  18.450  1.00 27.21           C  
ATOM   1834  CG  PHE   229      45.462  61.500  17.324  1.00 28.89           C  
ATOM   1835  CD1 PHE   229      45.107  60.316  16.674  1.00 25.77           C  
ATOM   1836  CD2 PHE   229      44.905  62.698  16.895  1.00 29.22           C  
ATOM   1837  CE1 PHE   229      44.203  60.321  15.640  1.00 25.83           C  
ATOM   1838  CE2 PHE   229      43.985  62.718  15.846  1.00 29.84           C  
ATOM   1839  CZ  PHE   229      43.626  61.523  15.225  1.00 23.27           C  
ATOM   1840  N   MET   230      47.504  59.761  20.943  1.00 30.54           N  
ATOM   1841  CA  MET   230      48.633  59.475  21.839  0.50 31.97           C  
ATOM   1843  C   MET   230      49.613  58.548  21.148  1.00 32.95           C  
ATOM   1844  O   MET   230      49.212  57.668  20.384  1.00 30.38           O  
ATOM   1845  CB  MET   230      48.170  58.804  23.139  0.50 29.98           C  
ATOM   1847  CG  MET   230      47.326  59.655  24.086  0.50 30.10           C  
ATOM   1849  SD  MET   230      46.461  58.547  25.462  0.35 35.81          SE  
ATOM   1851  CE  MET   230      45.786  57.198  24.278  0.50  9.41           C  
ATOM   1853  N   LEU   231      50.903  58.740  21.417  1.00 26.63           N  
ATOM   1854  CA  LEU   231      51.928  57.875  20.870  1.00 24.90           C  
ATOM   1855  C   LEU   231      52.402  56.944  21.983  1.00 32.60           C  
ATOM   1856  O   LEU   231      52.984  57.400  22.973  1.00 27.40           O  
ATOM   1857  CB  LEU   231      53.092  58.697  20.318  1.00 22.14           C  
ATOM   1858  CG  LEU   231      54.213  57.917  19.627  1.00 27.92           C  
ATOM   1859  CD1 LEU   231      53.690  57.195  18.374  1.00 31.77           C  
ATOM   1860  CD2 LEU   231      55.354  58.858  19.235  1.00 34.90           C  
ATOM   1861  N   TRP   232      52.153  55.643  21.825  1.00 26.63           N  
ATOM   1862  CA  TRP   232      52.468  54.657  22.873  1.00 27.49           C  
ATOM   1863  C   TRP   232      53.463  53.641  22.351  1.00 24.44           C  
ATOM   1864  O   TRP   232      53.424  53.335  21.153  1.00 24.35           O  
ATOM   1865  CB  TRP   232      51.214  53.888  23.242  1.00 25.56           C  
ATOM   1866  CG  TRP   232      50.254  54.542  24.163  1.00 33.99           C  
ATOM   1867  CD1 TRP   232      50.243  55.857  24.583  1.00 30.32           C  
ATOM   1868  CD2 TRP   232      49.111  53.920  24.754  1.00 30.78           C  
ATOM   1869  NE1 TRP   232      49.172  56.067  25.416  1.00 28.93           N  
ATOM   1870  CE2 TRP   232      48.459  54.899  25.537  1.00 33.17           C  
ATOM   1871  CE3 TRP   232      48.592  52.611  24.734  1.00 25.26           C  
ATOM   1872  CZ2 TRP   232      47.301  54.615  26.278  1.00 33.10           C  
ATOM   1873  CZ3 TRP   232      47.429  52.341  25.462  1.00 31.07           C  
ATOM   1874  CH2 TRP   232      46.803  53.334  26.220  1.00 29.08           C  
ATOM   1875  N   PRO   233      54.330  53.081  23.229  1.00 25.37           N  
ATOM   1876  CA  PRO   233      55.152  51.969  22.783  1.00 26.06           C  
ATOM   1877  C   PRO   233      54.231  50.848  22.323  1.00 24.38           C  
ATOM   1878  O   PRO   233      53.160  50.647  22.927  1.00 22.96           O  
ATOM   1879  CB  PRO   233      55.902  51.547  24.060  1.00 29.18           C  
ATOM   1880  CG  PRO   233      55.941  52.785  24.901  1.00 28.56           C  
ATOM   1881  CD  PRO   233      54.598  53.424  24.647  1.00 28.32           C  
ATOM   1882  N   ALA   234      54.615  50.163  21.250  1.00 23.20           N  
ATOM   1883  CA  ALA   234      53.779  49.101  20.681  1.00 25.59           C  
ATOM   1884  C   ALA   234      53.388  48.077  21.749  1.00 22.71           C  
ATOM   1885  O   ALA   234      52.225  47.682  21.809  1.00 21.44           O  
ATOM   1886  CB  ALA   234      54.464  48.417  19.496  1.00 27.69           C  
ATOM   1887  N   ALA   235      54.338  47.677  22.603  1.00 25.08           N  
ATOM   1888  CA  ALA   235      54.065  46.687  23.659  1.00 23.69           C  
ATOM   1889  C   ALA   235      52.959  47.126  24.629  1.00 24.83           C  
ATOM   1890  O   ALA   235      52.156  46.305  25.065  1.00 23.63           O  
ATOM   1891  CB  ALA   235      55.343  46.309  24.415  1.00 29.81           C  
ATOM   1892  N   LYS   236      52.898  48.420  24.935  1.00 24.16           N  
ATOM   1893  CA  LYS   236      51.849  48.978  25.790  1.00 27.58           C  
ATOM   1894  C   LYS   236      50.451  48.847  25.143  1.00 21.12           C  
ATOM   1895  O   LYS   236      49.450  48.578  25.825  1.00 22.07           O  
ATOM   1896  CB  LYS   236      52.180  50.448  26.117  1.00 26.72           C  
ATOM   1897  CG  LYS   236      51.190  51.123  27.037  1.00 30.02           C  
ATOM   1898  CD  LYS   236      51.459  52.607  27.212  1.00 37.84           C  
ATOM   1899  CE  LYS   236      50.410  53.245  28.131  1.00 45.71           C  
ATOM   1900  NZ  LYS   236      50.697  54.688  28.391  1.00 44.63           N  
ATOM   1901  N   VAL   237      50.386  49.019  23.816  1.00 21.52           N  
ATOM   1902  CA  VAL   237      49.122  48.858  23.075  1.00 19.23           C  
ATOM   1903  C   VAL   237      48.692  47.392  23.125  1.00 17.87           C  
ATOM   1904  O   VAL   237      47.555  47.073  23.417  1.00 19.86           O  
ATOM   1905  CB  VAL   237      49.262  49.352  21.594  1.00 21.36           C  
ATOM   1906  CG1 VAL   237      47.994  49.054  20.745  1.00 21.80           C  
ATOM   1907  CG2 VAL   237      49.561  50.862  21.578  1.00 19.94           C  
ATOM   1908  N   VAL   238      49.638  46.515  22.828  1.00 15.89           N  
ATOM   1909  CA  VAL   238      49.356  45.083  22.794  1.00 17.55           C  
ATOM   1910  C   VAL   238      48.889  44.625  24.185  1.00 18.38           C  
ATOM   1911  O   VAL   238      47.898  43.906  24.296  1.00 17.12           O  
ATOM   1912  CB  VAL   238      50.579  44.302  22.299  1.00 20.65           C  
ATOM   1913  CG1 VAL   238      50.349  42.779  22.475  1.00 17.40           C  
ATOM   1914  CG2 VAL   238      50.879  44.646  20.838  1.00 22.23           C  
ATOM   1915  N   GLU   239      49.575  45.053  25.254  1.00 20.45           N  
ATOM   1916  CA  GLU   239      49.154  44.644  26.606  1.00 19.51           C  
ATOM   1917  C   GLU   239      47.828  45.270  27.046  1.00 17.58           C  
ATOM   1918  O   GLU   239      47.054  44.633  27.746  1.00 19.73           O  
ATOM   1919  CB  GLU   239      50.231  44.906  27.659  1.00 18.69           C  
ATOM   1920  CG  GLU   239      51.537  44.178  27.372  1.00 18.82           C  
ATOM   1921  CD  GLU   239      51.459  42.647  27.407  1.00 23.22           C  
ATOM   1922  OE1 GLU   239      50.465  42.043  27.875  1.00 29.15           O  
ATOM   1923  OE2 GLU   239      52.440  42.036  26.965  1.00 26.04           O  
ATOM   1924  N   ALA   240      47.560  46.498  26.609  1.00 18.60           N  
ATOM   1925  CA  ALA   240      46.227  47.090  26.833  1.00 18.75           C  
ATOM   1926  C   ALA   240      45.097  46.233  26.209  1.00 21.18           C  
ATOM   1927  O   ALA   240      44.067  46.000  26.831  1.00 17.62           O  
ATOM   1928  CB  ALA   240      46.183  48.550  26.332  1.00 18.84           C  
ATOM   1929  N   VAL   241      45.310  45.713  25.002  1.00 19.17           N  
ATOM   1930  CA  VAL   241      44.324  44.848  24.381  1.00 16.76           C  
ATOM   1931  C   VAL   241      44.267  43.498  25.112  1.00 15.47           C  
ATOM   1932  O   VAL   241      43.178  42.958  25.346  1.00 18.92           O  
ATOM   1933  CB  VAL   241      44.643  44.686  22.855  1.00 20.22           C  
ATOM   1934  CG1 VAL   241      43.787  43.559  22.183  1.00 17.92           C  
ATOM   1935  CG2 VAL   241      44.413  46.033  22.172  1.00 14.08           C  
ATOM   1936  N   ARG   242      45.422  42.960  25.515  1.00 14.46           N  
ATOM   1937  CA  ARG   242      45.425  41.642  26.181  1.00 16.30           C  
ATOM   1938  C   ARG   242      44.592  41.660  27.459  1.00 18.93           C  
ATOM   1939  O   ARG   242      43.795  40.741  27.716  1.00 21.27           O  
ATOM   1940  CB  ARG   242      46.864  41.171  26.494  1.00 15.30           C  
ATOM   1941  CG  ARG   242      46.889  39.763  27.067  1.00 16.78           C  
ATOM   1942  CD  ARG   242      48.226  39.519  27.784  1.00 22.29           C  
ATOM   1943  NE  ARG   242      49.335  39.487  26.843  1.00 20.03           N  
ATOM   1944  CZ  ARG   242      49.637  38.449  26.058  1.00 21.15           C  
ATOM   1945  NH1 ARG   242      48.907  37.328  26.050  1.00 21.56           N  
ATOM   1946  NH2 ARG   242      50.687  38.534  25.272  1.00 19.17           N  
ATOM   1947  N   THR   243      44.715  42.746  28.226  1.00 18.75           N  
ATOM   1948  CA  THR   243      44.213  42.720  29.582  1.00 20.29           C  
ATOM   1949  C   THR   243      43.134  43.725  29.948  1.00 20.77           C  
ATOM   1950  O   THR   243      42.682  43.716  31.088  1.00 20.63           O  
ATOM   1951  CB  THR   243      45.375  42.827  30.613  1.00 23.74           C  
ATOM   1952  OG1 THR   243      46.034  44.069  30.452  1.00 29.54           O  
ATOM   1953  CG2 THR   243      46.376  41.733  30.398  1.00 27.63           C  
ATOM   1954  N   THR   244      42.724  44.592  29.014  1.00 19.31           N  
ATOM   1955  CA  THR   244      41.730  45.624  29.312  1.00 20.53           C  
ATOM   1956  C   THR   244      40.672  45.705  28.197  1.00 24.18           C  
ATOM   1957  O   THR   244      40.803  45.067  27.141  1.00 19.20           O  
ATOM   1958  CB  THR   244      42.349  47.061  29.504  1.00 21.98           C  
ATOM   1959  OG1 THR   244      42.659  47.636  28.232  1.00 20.95           O  
ATOM   1960  CG2 THR   244      43.608  47.072  30.385  1.00 22.52           C  
ATOM   1961  N   GLU   245      39.649  46.532  28.423  1.00 22.28           N  
ATOM   1962  CA  GLU   245      38.659  46.803  27.380  1.00 21.28           C  
ATOM   1963  C   GLU   245      38.762  48.249  26.933  1.00 22.53           C  
ATOM   1964  O   GLU   245      37.759  48.847  26.603  1.00 22.94           O  
ATOM   1965  CB  GLU   245      37.243  46.518  27.900  1.00 25.72           C  
ATOM   1966  CG  GLU   245      37.013  45.108  28.390  1.00 29.04           C  
ATOM   1967  CD  GLU   245      36.556  44.167  27.293  1.00 39.66           C  
ATOM   1968  OE1 GLU   245      36.793  44.438  26.084  1.00 43.88           O  
ATOM   1969  OE2 GLU   245      35.930  43.148  27.639  1.00 34.03           O  
ATOM   1970  N   ALA   246      39.976  48.799  26.936  1.00 18.23           N  
ATOM   1971  CA  ALA   246      40.195  50.198  26.597  1.00 23.71           C  
ATOM   1972  C   ALA   246      39.887  50.482  25.118  1.00 25.82           C  
ATOM   1973  O   ALA   246      39.454  51.582  24.780  1.00 23.44           O  
ATOM   1974  CB  ALA   246      41.633  50.571  26.876  1.00 21.63           C  
ATOM   1975  N   PHE   247      40.124  49.490  24.248  1.00 20.81           N  
ATOM   1976  CA  PHE   247      39.980  49.691  22.795  1.00 20.54           C  
ATOM   1977  C   PHE   247      38.572  49.387  22.298  1.00 21.57           C  
ATOM   1978  O   PHE   247      37.861  48.501  22.835  1.00 21.62           O  
ATOM   1979  CB  PHE   247      41.037  48.883  22.019  1.00 17.15           C  
ATOM   1980  CG  PHE   247      42.407  49.520  22.021  1.00 24.57           C  
ATOM   1981  CD1 PHE   247      42.832  50.293  20.932  1.00 22.20           C  
ATOM   1982  CD2 PHE   247      43.256  49.386  23.128  1.00 20.78           C  
ATOM   1983  CE1 PHE   247      44.094  50.901  20.935  1.00 24.41           C  
ATOM   1984  CE2 PHE   247      44.516  49.983  23.134  1.00 24.91           C  
ATOM   1985  CZ  PHE   247      44.928  50.753  22.045  1.00 21.88           C  
ATOM   1986  N   LYS   248      38.157  50.113  21.258  1.00 19.66           N  
ATOM   1987  CA  LYS   248      36.895  49.781  20.572  1.00 15.71           C  
ATOM   1988  C   LYS   248      36.908  48.307  20.192  1.00 17.36           C  
ATOM   1989  O   LYS   248      37.957  47.775  19.831  1.00 16.16           O  
ATOM   1990  CB  LYS   248      36.785  50.665  19.313  1.00 20.31           C  
ATOM   1991  CG  LYS   248      35.653  50.308  18.350  1.00 19.58           C  
ATOM   1992  CD  LYS   248      35.383  51.525  17.446  1.00 20.79           C  
ATOM   1993  CE  LYS   248      34.446  51.169  16.277  1.00 19.70           C  
ATOM   1994  NZ  LYS   248      35.252  50.527  15.166  1.00 22.92           N  
ATOM   1995  N   PHE   249      35.758  47.644  20.279  1.00 16.33           N  
ATOM   1996  CA  PHE   249      35.678  46.156  20.219  1.00 16.95           C  
ATOM   1997  C   PHE   249      36.470  45.499  19.069  1.00 17.92           C  
ATOM   1998  O   PHE   249      37.251  44.547  19.278  1.00 20.40           O  
ATOM   1999  CB  PHE   249      34.203  45.693  20.232  1.00 17.22           C  
ATOM   2000  CG  PHE   249      33.419  46.084  18.995  1.00 27.57           C  
ATOM   2001  CD1 PHE   249      33.226  45.166  17.948  1.00 23.89           C  
ATOM   2002  CD2 PHE   249      32.841  47.348  18.884  1.00 34.84           C  
ATOM   2003  CE1 PHE   249      32.526  45.533  16.794  1.00 24.40           C  
ATOM   2004  CE2 PHE   249      32.121  47.707  17.741  1.00 29.75           C  
ATOM   2005  CZ  PHE   249      31.971  46.811  16.697  1.00 29.91           C  
ATOM   2006  N   ASN   250      36.319  46.021  17.857  1.00 17.89           N  
ATOM   2007  CA  ASN   250      36.948  45.377  16.717  1.00 18.87           C  
ATOM   2008  C   ASN   250      38.357  45.863  16.478  1.00 19.30           C  
ATOM   2009  O   ASN   250      39.125  45.186  15.831  1.00 17.61           O  
ATOM   2010  CB  ASN   250      36.074  45.436  15.463  1.00 19.36           C  
ATOM   2011  CG  ASN   250      35.623  46.859  15.113  1.00 26.18           C  
ATOM   2012  OD1 ASN   250      36.006  47.833  15.762  1.00 21.97           O  
ATOM   2013  ND2 ASN   250      34.794  46.966  14.082  1.00 23.76           N  
ATOM   2014  N   VAL   251      38.705  47.014  17.053  1.00 17.26           N  
ATOM   2015  CA  VAL   251      40.090  47.489  17.021  1.00 17.67           C  
ATOM   2016  C   VAL   251      41.045  46.546  17.793  1.00 15.70           C  
ATOM   2017  O   VAL   251      42.209  46.395  17.416  1.00 20.55           O  
ATOM   2018  CB  VAL   251      40.213  48.959  17.474  1.00 18.07           C  
ATOM   2019  CG1 VAL   251      41.693  49.419  17.429  1.00 19.60           C  
ATOM   2020  CG2 VAL   251      39.326  49.855  16.598  1.00 20.52           C  
ATOM   2021  N   ASN   252      40.554  45.898  18.853  1.00 16.54           N  
ATOM   2022  CA  ASN   252      41.300  44.796  19.520  1.00 19.17           C  
ATOM   2023  C   ASN   252      41.835  43.794  18.486  1.00 17.97           C  
ATOM   2024  O   ASN   252      43.016  43.390  18.550  1.00 13.67           O  
ATOM   2025  CB  ASN   252      40.427  44.044  20.518  1.00 16.95           C  
ATOM   2026  CG  ASN   252      40.085  44.874  21.712  1.00 21.39           C  
ATOM   2027  OD1 ASN   252      40.966  45.357  22.403  1.00 21.20           O  
ATOM   2028  ND2 ASN   252      38.796  45.077  21.939  1.00 18.46           N  
ATOM   2029  N   LEU   253      40.979  43.415  17.544  1.00 16.65           N  
ATOM   2030  CA  LEU   253      41.404  42.493  16.468  1.00 19.56           C  
ATOM   2031  C   LEU   253      42.543  43.033  15.601  1.00 16.73           C  
ATOM   2032  O   LEU   253      43.489  42.301  15.315  1.00 18.19           O  
ATOM   2033  CB  LEU   253      40.229  42.022  15.603  1.00 18.12           C  
ATOM   2034  CG  LEU   253      38.922  41.578  16.300  1.00 20.48           C  
ATOM   2035  CD1 LEU   253      37.904  41.116  15.291  1.00 21.68           C  
ATOM   2036  CD2 LEU   253      39.152  40.512  17.330  1.00 20.21           C  
ATOM   2037  N   THR   254      42.473  44.311  15.194  1.00 15.24           N  
ATOM   2038  CA  THR   254      43.556  44.925  14.404  1.00 18.27           C  
ATOM   2039  C   THR   254      44.865  44.978  15.187  1.00 16.83           C  
ATOM   2040  O   THR   254      45.934  44.825  14.612  1.00 17.38           O  
ATOM   2041  CB  THR   254      43.206  46.367  13.943  1.00 21.69           C  
ATOM   2042  OG1 THR   254      43.306  47.269  15.053  1.00 19.60           O  
ATOM   2043  CG2 THR   254      41.784  46.421  13.327  1.00 18.91           C  
ATOM   2044  N   VAL   255      44.787  45.190  16.513  1.00 16.92           N  
ATOM   2045  CA  VAL   255      46.014  45.184  17.332  1.00 20.44           C  
ATOM   2046  C   VAL   255      46.648  43.772  17.414  1.00 16.81           C  
ATOM   2047  O   VAL   255      47.861  43.602  17.301  1.00 15.75           O  
ATOM   2048  CB  VAL   255      45.729  45.717  18.762  1.00 23.19           C  
ATOM   2049  CG1 VAL   255      46.961  45.580  19.637  1.00 17.22           C  
ATOM   2050  CG2 VAL   255      45.271  47.183  18.700  1.00 17.07           C  
ATOM   2051  N   ILE   256      45.817  42.770  17.622  1.00 15.06           N  
ATOM   2052  CA  ILE   256      46.283  41.365  17.645  1.00 16.72           C  
ATOM   2053  C   ILE   256      46.945  40.996  16.304  1.00 18.72           C  
ATOM   2054  O   ILE   256      48.041  40.424  16.277  1.00 17.73           O  
ATOM   2055  CB  ILE   256      45.117  40.416  17.975  1.00 15.49           C  
ATOM   2056  CG1 ILE   256      44.671  40.628  19.426  1.00 16.40           C  
ATOM   2057  CG2 ILE   256      45.526  38.931  17.782  1.00 15.97           C  
ATOM   2058  CD1 ILE   256      43.271  40.002  19.721  1.00 17.55           C  
ATOM   2059  N   ASP   257      46.308  41.383  15.204  1.00 13.78           N  
ATOM   2060  CA  ASP   257      46.861  41.172  13.864  1.00 15.76           C  
ATOM   2061  C   ASP   257      48.199  41.850  13.683  1.00 15.74           C  
ATOM   2062  O   ASP   257      49.140  41.264  13.139  1.00 14.56           O  
ATOM   2063  CB  ASP   257      45.867  41.648  12.794  1.00 18.64           C  
ATOM   2064  CG  ASP   257      46.470  41.626  11.405  1.00 26.78           C  
ATOM   2065  OD1 ASP   257      46.453  40.556  10.783  1.00 20.72           O  
ATOM   2066  OD2 ASP   257      46.996  42.664  10.954  1.00 20.29           O  
ATOM   2067  N   PHE   258      48.273  43.108  14.105  1.00 16.25           N  
ATOM   2068  CA  PHE   258      49.528  43.852  14.067  1.00 17.51           C  
ATOM   2069  C   PHE   258      50.622  43.141  14.865  1.00 16.83           C  
ATOM   2070  O   PHE   258      51.773  43.018  14.390  1.00 17.69           O  
ATOM   2071  CB  PHE   258      49.323  45.269  14.626  1.00 15.95           C  
ATOM   2072  CG  PHE   258      50.559  46.166  14.516  1.00 17.88           C  
ATOM   2073  CD1 PHE   258      50.725  47.003  13.413  1.00 17.31           C  
ATOM   2074  CD2 PHE   258      51.537  46.171  15.533  1.00 17.86           C  
ATOM   2075  CE1 PHE   258      51.858  47.838  13.312  1.00 20.55           C  
ATOM   2076  CE2 PHE   258      52.654  46.980  15.434  1.00 23.41           C  
ATOM   2077  CZ  PHE   258      52.815  47.810  14.323  1.00 18.10           C  
ATOM   2078  N   ALA   259      50.285  42.691  16.073  1.00 14.66           N  
ATOM   2079  CA  ALA   259      51.247  41.942  16.906  1.00 17.15           C  
ATOM   2080  C   ALA   259      51.777  40.679  16.212  1.00 16.42           C  
ATOM   2081  O   ALA   259      52.985  40.380  16.281  1.00 17.86           O  
ATOM   2082  CB  ALA   259      50.584  41.557  18.213  1.00 16.20           C  
ATOM   2083  N   ILE   260      50.876  39.950  15.553  1.00 15.43           N  
ATOM   2084  CA  ILE   260      51.263  38.743  14.796  1.00 17.05           C  
ATOM   2085  C   ILE   260      52.194  39.088  13.631  1.00 21.68           C  
ATOM   2086  O   ILE   260      53.265  38.511  13.498  1.00 17.54           O  
ATOM   2087  CB  ILE   260      50.004  37.957  14.309  1.00 15.84           C  
ATOM   2088  CG1 ILE   260      49.276  37.306  15.480  1.00 15.26           C  
ATOM   2089  CG2 ILE   260      50.356  36.946  13.221  1.00 13.29           C  
ATOM   2090  CD1 ILE   260      47.801  37.088  15.148  1.00 20.98           C  
ATOM   2091  N   ARG   261      51.829  40.091  12.840  1.00 16.50           N  
ATOM   2092  CA  ARG   261      52.593  40.431  11.650  1.00 17.41           C  
ATOM   2093  C   ARG   261      53.957  41.067  11.969  1.00 20.27           C  
ATOM   2094  O   ARG   261      54.883  40.981  11.167  1.00 17.78           O  
ATOM   2095  CB  ARG   261      51.767  41.376  10.777  1.00 18.71           C  
ATOM   2096  CG  ARG   261      50.631  40.706  10.003  1.00 18.49           C  
ATOM   2097  CD  ARG   261      49.895  41.730   9.083  1.00 19.15           C  
ATOM   2098  NE  ARG   261      49.374  42.927   9.773  1.00 15.15           N  
ATOM   2099  CZ  ARG   261      49.999  44.110   9.879  1.00 17.36           C  
ATOM   2100  NH1 ARG   261      51.185  44.316   9.312  1.00 13.59           N  
ATOM   2101  NH2 ARG   261      49.410  45.118  10.534  1.00 17.72           N  
ATOM   2102  N   HIS   262      54.049  41.730  13.125  1.00 18.55           N  
ATOM   2103  CA  HIS   262      55.287  42.423  13.520  1.00 18.49           C  
ATOM   2104  C   HIS   262      56.111  41.632  14.541  1.00 19.93           C  
ATOM   2105  O   HIS   262      57.079  42.156  15.116  1.00 20.40           O  
ATOM   2106  CB  HIS   262      54.993  43.845  14.015  1.00 20.26           C  
ATOM   2107  CG  HIS   262      54.594  44.785  12.917  1.00 22.68           C  
ATOM   2108  ND1 HIS   262      55.464  45.707  12.373  1.00 26.66           N  
ATOM   2109  CD2 HIS   262      53.422  44.926  12.243  1.00 19.17           C  
ATOM   2110  CE1 HIS   262      54.846  46.384  11.418  1.00 25.84           C  
ATOM   2111  NE2 HIS   262      53.615  45.915  11.305  1.00 22.21           N  
ATOM   2112  N   GLY   263      55.748  40.363  14.727  1.00 15.73           N  
ATOM   2113  CA  GLY   263      56.525  39.416  15.539  1.00 18.52           C  
ATOM   2114  C   GLY   263      56.471  39.718  17.035  1.00 23.51           C  
ATOM   2115  O   GLY   263      57.383  39.371  17.767  1.00 19.61           O  
ATOM   2116  N   LEU   264      55.410  40.379  17.482  1.00 14.70           N  
ATOM   2117  CA  LEU   264      55.305  40.807  18.894  1.00 17.57           C  
ATOM   2118  C   LEU   264      54.781  39.666  19.747  1.00 21.10           C  
ATOM   2119  O   LEU   264      54.997  39.651  20.979  1.00 24.41           O  
ATOM   2120  CB  LEU   264      54.405  42.057  19.037  1.00 21.79           C  
ATOM   2121  CG  LEU   264      54.894  43.310  18.267  1.00 23.31           C  
ATOM   2122  CD1 LEU   264      54.040  44.564  18.553  1.00 26.68           C  
ATOM   2123  CD2 LEU   264      56.367  43.588  18.518  1.00 29.60           C  
ATOM   2124  N   ILE   265      54.031  38.749  19.115  1.00 18.52           N  
ATOM   2125  CA  ILE   265      53.686  37.475  19.752  1.00 22.83           C  
ATOM   2126  C   ILE   265      54.260  36.308  18.926  1.00 22.38           C  
ATOM   2127  O   ILE   265      54.466  36.436  17.709  1.00 22.45           O  
ATOM   2128  CB  ILE   265      52.160  37.348  20.072  1.00 25.81           C  
ATOM   2129  CG1 ILE   265      51.316  37.513  18.820  1.00 23.62           C  
ATOM   2130  CG2 ILE   265      51.719  38.400  21.120  1.00 28.12           C  
ATOM   2131  CD1 ILE   265      49.815  37.437  19.137  1.00 30.09           C  
ATOM   2132  N   ASP   266      54.528  35.182  19.589  1.00 17.59           N  
ATOM   2133  CA  ASP   266      55.396  34.130  19.052  1.00 18.41           C  
ATOM   2134  C   ASP   266      54.716  32.788  19.309  1.00 14.35           C  
ATOM   2135  O   ASP   266      54.356  32.498  20.449  1.00 17.74           O  
ATOM   2136  CB  ASP   266      56.736  34.200  19.769  1.00 22.76           C  
ATOM   2137  CG  ASP   266      57.793  33.287  19.155  1.00 23.74           C  
ATOM   2138  OD1 ASP   266      57.485  32.100  18.885  1.00 18.42           O  
ATOM   2139  OD2 ASP   266      58.934  33.756  18.958  1.00 28.70           O  
ATOM   2140  N   PRO   267      54.519  31.984  18.263  1.00 14.45           N  
ATOM   2141  CA  PRO   267      53.801  30.706  18.408  1.00 18.63           C  
ATOM   2142  C   PRO   267      54.476  29.707  19.342  1.00 19.37           C  
ATOM   2143  O   PRO   267      53.824  28.755  19.780  1.00 18.58           O  
ATOM   2144  CB  PRO   267      53.784  30.167  16.977  1.00 15.64           C  
ATOM   2145  CG  PRO   267      55.031  30.801  16.347  1.00 17.26           C  
ATOM   2146  CD  PRO   267      54.945  32.200  16.867  1.00 20.06           C  
ATOM   2147  N   ASP   268      55.740  29.927  19.664  1.00 15.62           N  
ATOM   2148  CA  ASP   268      56.414  29.081  20.623  1.00 15.57           C  
ATOM   2149  C   ASP   268      55.906  29.264  22.063  1.00 18.65           C  
ATOM   2150  O   ASP   268      56.171  28.468  22.893  1.00 20.39           O  
ATOM   2151  CB  ASP   268      57.926  29.260  20.596  1.00 15.64           C  
ATOM   2152  CG  ASP   268      58.650  28.193  19.765  1.00 20.73           C  
ATOM   2153  OD1 ASP   268      58.176  27.083  19.594  1.00 19.74           O  
ATOM   2154  OD2 ASP   268      59.709  28.523  19.289  1.00 18.59           O  
ATOM   2155  N   ASN   269      55.254  30.378  22.352  1.00 18.15           N  
ATOM   2156  CA  ASN   269      54.833  30.636  23.700  1.00 18.28           C  
ATOM   2157  C   ASN   269      53.520  31.390  23.936  1.00 23.96           C  
ATOM   2158  O   ASN   269      53.023  31.432  25.023  1.00 26.27           O  
ATOM   2159  CB  ASN   269      55.964  31.175  24.533  1.00 18.15           C  
ATOM   2160  CG  ASN   269      56.558  32.401  23.953  1.00 26.19           C  
ATOM   2161  OD1 ASN   269      57.699  32.422  23.568  1.00 32.60           O  
ATOM   2162  ND2 ASN   269      55.787  33.418  23.887  1.00 26.72           N  
ATOM   2163  N   GLU   270      52.941  31.937  22.902  1.00 16.48           N  
ATOM   2164  CA  GLU   270      51.647  32.553  23.047  1.00 15.11           C  
ATOM   2165  C   GLU   270      50.492  31.549  23.084  1.00 14.42           C  
ATOM   2166  O   GLU   270      50.240  30.921  22.121  1.00 21.12           O  
ATOM   2167  CB  GLU   270      51.467  33.548  21.932  1.00 18.79           C  
ATOM   2168  CG  GLU   270      50.290  34.433  22.053  1.00 18.97           C  
ATOM   2169  CD  GLU   270      50.347  35.361  23.231  1.00 22.84           C  
ATOM   2170  OE1 GLU   270      51.369  35.956  23.455  1.00 20.01           O  
ATOM   2171  OE2 GLU   270      49.349  35.477  23.920  1.00 26.54           O  
ATOM   2172  N   PRO   271      49.784  31.472  24.201  1.00 18.53           N  
ATOM   2173  CA  PRO   271      48.640  30.527  24.313  1.00 18.62           C  
ATOM   2174  C   PRO   271      47.585  30.711  23.209  1.00 21.48           C  
ATOM   2175  O   PRO   271      47.318  31.827  22.772  1.00 20.64           O  
ATOM   2176  CB  PRO   271      48.042  30.857  25.699  1.00 18.34           C  
ATOM   2177  CG  PRO   271      49.205  31.407  26.481  1.00 22.82           C  
ATOM   2178  CD  PRO   271      49.976  32.218  25.463  1.00 19.03           C  
ATOM   2179  N   ASP   272      47.040  29.602  22.722  1.00 19.39           N  
ATOM   2180  CA  ASP   272      45.946  29.606  21.734  1.00 21.41           C  
ATOM   2181  C   ASP   272      46.249  30.312  20.390  1.00 22.39           C  
ATOM   2182  O   ASP   272      45.353  30.844  19.739  1.00 21.93           O  
ATOM   2183  CB  ASP   272      44.665  30.132  22.399  1.00 25.85           C  
ATOM   2184  CG  ASP   272      44.337  29.387  23.701  1.00 22.95           C  
ATOM   2185  OD1 ASP   272      44.123  28.160  23.659  1.00 30.25           O  
ATOM   2186  OD2 ASP   272      44.290  30.024  24.762  1.00 25.66           O  
ATOM   2187  N   TYR   273      47.521  30.310  19.994  1.00 22.77           N  
ATOM   2188  CA  TYR   273      47.976  31.029  18.803  1.00 24.21           C  
ATOM   2189  C   TYR   273      47.124  30.663  17.581  1.00 25.07           C  
ATOM   2190  O   TYR   273      46.575  31.546  16.921  1.00 19.63           O  
ATOM   2191  CB  TYR   273      49.470  30.728  18.556  1.00 24.65           C  
ATOM   2192  CG  TYR   273      50.160  31.551  17.468  1.00 22.16           C  
ATOM   2193  CD1 TYR   273      50.778  32.746  17.787  1.00 22.26           C  
ATOM   2194  CD2 TYR   273      50.222  31.115  16.129  1.00 26.27           C  
ATOM   2195  CE1 TYR   273      51.455  33.514  16.826  1.00 25.71           C  
ATOM   2196  CE2 TYR   273      50.906  31.883  15.148  1.00 23.07           C  
ATOM   2197  CZ  TYR   273      51.516  33.091  15.519  1.00 26.26           C  
ATOM   2198  OH  TYR   273      52.227  33.891  14.619  1.00 25.63           O  
ATOM   2199  N   GLN   274      46.965  29.362  17.313  1.00 25.05           N  
ATOM   2200  CA  GLN   274      46.233  28.905  16.136  1.00 28.03           C  
ATOM   2201  C   GLN   274      44.756  29.291  16.186  1.00 21.12           C  
ATOM   2202  O   GLN   274      44.185  29.668  15.168  1.00 25.17           O  
ATOM   2203  CB  GLN   274      46.352  27.379  15.960  1.00 29.75           C  
ATOM   2204  CG  GLN   274      47.542  26.871  15.197  1.00 35.04           C  
ATOM   2205  CD  GLN   274      47.510  25.334  15.104  1.00 37.83           C  
ATOM   2206  OE1 GLN   274      47.600  24.655  16.103  1.00 54.17           O  
ATOM   2207  NE2 GLN   274      47.333  24.809  13.918  1.00 29.49           N  
ATOM   2208  N   GLU   275      44.133  29.184  17.363  1.00 21.24           N  
ATOM   2209  CA  GLU   275      42.711  29.558  17.518  1.00 23.65           C  
ATOM   2210  C   GLU   275      42.464  31.077  17.339  1.00 23.33           C  
ATOM   2211  O   GLU   275      41.438  31.485  16.766  1.00 23.64           O  
ATOM   2212  CB  GLU   275      42.172  29.094  18.877  1.00 25.97           C  
ATOM   2213  CG  GLU   275      40.632  29.029  18.967  1.00 32.41           C  
ATOM   2214  CD  GLU   275      40.122  28.518  20.321  1.00 39.35           C  
ATOM   2215  OE1 GLU   275      40.922  27.962  21.105  1.00 44.52           O  
ATOM   2216  OE2 GLU   275      38.908  28.672  20.601  1.00 41.90           O  
ATOM   2217  N   ILE   276      43.388  31.896  17.846  1.00 20.81           N  
ATOM   2218  CA  ILE   276      43.385  33.356  17.610  1.00 17.98           C  
ATOM   2219  C   ILE   276      43.453  33.689  16.106  1.00 17.71           C  
ATOM   2220  O   ILE   276      42.631  34.450  15.591  1.00 21.55           O  
ATOM   2221  CB  ILE   276      44.528  34.081  18.401  1.00 15.86           C  
ATOM   2222  CG1 ILE   276      44.247  34.008  19.908  1.00 19.73           C  
ATOM   2223  CG2 ILE   276      44.706  35.542  17.912  1.00 19.05           C  
ATOM   2224  CD1 ILE   276      45.475  34.302  20.768  1.00 19.29           C  
ATOM   2225  N   LEU   277      44.398  33.072  15.395  1.00 19.08           N  
ATOM   2226  CA  LEU   277      44.530  33.265  13.963  1.00 21.48           C  
ATOM   2227  C   LEU   277      43.274  32.840  13.211  1.00 24.88           C  
ATOM   2228  O   LEU   277      42.825  33.536  12.298  1.00 24.76           O  
ATOM   2229  CB  LEU   277      45.735  32.471  13.422  1.00 21.86           C  
ATOM   2230  CG  LEU   277      47.076  33.195  13.374  1.00 24.75           C  
ATOM   2231  CD1 LEU   277      47.600  33.586  14.733  1.00 34.47           C  
ATOM   2232  CD2 LEU   277      48.096  32.295  12.688  1.00 25.76           C  
ATOM   2233  N   ALA   278      42.715  31.692  13.593  1.00 27.02           N  
ATOM   2234  CA  ALA   278      41.506  31.175  12.965  1.00 25.77           C  
ATOM   2235  C   ALA   278      40.359  32.164  13.105  1.00 27.86           C  
ATOM   2236  O   ALA   278      39.644  32.463  12.139  1.00 27.51           O  
ATOM   2237  CB  ALA   278      41.141  29.816  13.572  1.00 26.62           C  
ATOM   2238  N   GLY   279      40.206  32.713  14.303  1.00 24.75           N  
ATOM   2239  CA  GLY   279      39.119  33.606  14.566  1.00 24.32           C  
ATOM   2240  C   GLY   279      39.255  34.969  13.922  1.00 21.62           C  
ATOM   2241  O   GLY   279      38.252  35.644  13.752  1.00 25.06           O  
ATOM   2242  N   LEU   280      40.471  35.367  13.529  1.00 21.70           N  
ATOM   2243  CA  LEU   280      40.689  36.640  12.818  1.00 16.91           C  
ATOM   2244  C   LEU   280      40.233  36.546  11.361  1.00 19.92           C  
ATOM   2245  O   LEU   280      40.131  37.569  10.678  1.00 23.50           O  
ATOM   2246  CB  LEU   280      42.167  37.093  12.848  1.00 19.48           C  
ATOM   2247  CG  LEU   280      42.750  37.463  14.221  1.00 19.47           C  
ATOM   2248  CD1 LEU   280      44.277  37.667  14.111  1.00 17.83           C  
ATOM   2249  CD2 LEU   280      42.045  38.638  14.883  1.00 22.63           C  
ATOM   2250  N   ARG   281      39.992  35.328  10.881  1.00 23.44           N  
ATOM   2251  CA  ARG   281      39.354  35.114   9.570  1.00 32.81           C  
ATOM   2252  C   ARG   281      37.935  34.561   9.712  1.00 32.09           C  
ATOM   2253  O   ARG   281      37.445  33.916   8.796  1.00 48.29           O  
ATOM   2254  CB  ARG   281      40.191  34.158   8.682  1.00 34.72           C  
ATOM   2255  CG  ARG   281      41.637  34.586   8.452  1.00 51.44           C  
ATOM   2256  CD  ARG   281      41.875  35.612   7.315  1.00 47.49           C  
ATOM   2257  NE  ARG   281      43.253  36.139   7.365  1.00 47.28           N  
ATOM   2258  CZ  ARG   281      44.352  35.493   6.941  1.00 62.28           C  
ATOM   2259  NH1 ARG   281      44.285  34.275   6.399  1.00 47.33           N  
ATOM   2260  NH2 ARG   281      45.544  36.071   7.053  1.00 64.73           N  
ATOM   2261  N   GLY   282      37.261  34.858  10.830  1.00 38.52           N  
ATOM   2262  CA  GLY   282      35.979  34.235  11.204  1.00 42.89           C  
ATOM   2263  C   GLY   282      34.742  34.549  10.371  1.00 58.44           C  
ATOM   2264  O   GLY   282      34.487  35.704  10.042  1.00 62.23           O  
ATOM   2265  N   ARG   283      33.963  33.519  10.030  1.00 64.93           N  
ATOM   2266  CA  ARG   283      32.705  33.700   9.274  1.00 72.21           C  
ATOM   2267  C   ARG   283      31.534  32.990   9.967  1.00 69.93           C  
ATOM   2268  O   ARG   283      30.361  33.286   9.718  1.00 69.14           O  
ATOM   2269  CB  ARG   283      32.831  33.197   7.821  1.00 73.70           C  
ATOM   2270  CG  ARG   283      34.107  33.605   7.074  1.00 81.93           C  
ATOM   2271  CD  ARG   283      33.954  33.492   5.560  1.00 83.14           C  
ATOM   2272  NE  ARG   283      33.593  34.769   4.934  1.00 96.15           N  
ATOM   2273  CZ  ARG   283      34.447  35.572   4.294  1.00100.15           C  
ATOM   2274  NH1 ARG   283      34.015  36.705   3.758  1.00 98.98           N  
ATOM   2275  NH2 ARG   283      35.731  35.249   4.181  1.00102.87           N  
END
