
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  238 ( 1748),  selected  238 , name 2qq5_A
# Molecule2: number of CA atoms  271 ( 1954),  selected  271 , name T0511.pdb
# PARAMETERS: 2qq5_A.T0511.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     3_A      M       1           -
LGA    P     4_A      T       2          1.820
LGA    M     5_A      L       3          1.519
LGA    N     6_A      S       4          1.483
LGA    G     7_A      G       5          1.264
LGA    Q     8_A      K       6          0.718
LGA    V     9_A      T       7          0.439
LGA    C    10_A      L       8          0.460
LGA    V    11_A      F       9          0.640
LGA    V    12_A      I      10          0.619
LGA    T    13_A      T      11          0.320
LGA    G    14_A      G      12          0.820
LGA    A    15_A      A      13          0.729
LGA    S    16_A      S      14          1.691
LGA    R    17_A      R      15          1.717
LGA    G    18_A      G      16          1.483
LGA    I    19_A      I      17          1.203
LGA    G    20_A      G      18          0.986
LGA    R    21_A      L      19          1.295
LGA    G    22_A      A      20          1.161
LGA    I    23_A      I      21          0.794
LGA    A    24_A      A      22          0.868
LGA    L    25_A      L      23          1.130
LGA    Q    26_A      R      24          0.717
LGA    L    27_A      A      25          1.057
LGA    C    28_A      A      26          0.772
LGA    K    29_A      R      27          1.247
LGA    A    30_A      D      28          1.898
LGA    G    31_A      G      29          1.391
LGA    A    32_A      A      30          0.379
LGA    T    33_A      N      31          0.353
LGA    V    34_A      V      32          0.368
LGA    Y    35_A      A      33          0.380
LGA    I    36_A      I      34          0.642
LGA    T    37_A      A      35          1.449
LGA    G    38_A      A      36          1.097
LGA    R    39_A      K      37          0.857
LGA    H    40_A      S      38          1.435
LGA    L    41_A      A      39          1.852
LGA    D    42_A      V      40          3.187
LGA    -       -      A      41           -
LGA    -       -      N      42           -
LGA    -       -      P      43           -
LGA    -       -      K      44           -
LGA    -       -      L      45           -
LGA    -       -      P      46           -
LGA    -       -      G      47           -
LGA    T    43_A      T      48          1.406
LGA    L    44_A      I      49          1.820
LGA    R    45_A      H      50          1.506
LGA    V    46_A      S      51          1.551
LGA    V    47_A      A      52          2.111
LGA    A    48_A      A      53          2.284
LGA    Q    49_A      A      54          2.299
LGA    E    50_A      A      55          2.220
LGA    A    51_A      V      56          2.472
LGA    Q    52_A      N      57          1.904
LGA    S    53_A      A      58          1.499
LGA    L    54_A      A      59          1.486
LGA    G    55_A      G      60          1.107
LGA    G    56_A      G      61          1.146
LGA    Q    57_A      Q      62          1.089
LGA    C    58_A      G      63          1.185
LGA    V    59_A      L      64          1.038
LGA    P    60_A      A      65          1.098
LGA    V    61_A      L      66          0.407
LGA    V    62_A      K      67          0.444
LGA    C    63_A      C      68          0.324
LGA    D    64_A      D      69          0.589
LGA    S    65_A      I      70          0.817
LGA    S    66_A      R      71          0.654
LGA    Q    67_A      E      72          0.604
LGA    E    68_A      E      73          0.524
LGA    S    69_A      D      74          0.460
LGA    E    70_A      Q      75          0.391
LGA    V    71_A      V      76          0.532
LGA    R    72_A      R      77          0.587
LGA    S    73_A      A      78          0.213
LGA    L    74_A      A      79          0.553
LGA    F    75_A      V      80          0.733
LGA    E    76_A      A      81          0.632
LGA    Q    77_A      A      82          0.536
LGA    V    78_A      T      83          1.281
LGA    D    79_A      V      84          1.550
LGA    R    80_A      D      85          1.243
LGA    E    81_A      T      86          1.482
LGA    Q    82_A      F      87          1.983
LGA    Q    83_A      G      88          2.298
LGA    G    84_A      G      89          3.033
LGA    R    85_A      -       -           -
LGA    L    86_A      I      90          1.081
LGA    D    87_A      D      91          0.985
LGA    V    88_A      I      92          0.768
LGA    L    89_A      L      93          0.466
LGA    V    90_A      V      94          0.234
LGA    N    91_A      N      95          0.473
LGA    N    92_A      N      96          0.733
LGA    A    93_A      A      97          0.682
LGA    Y    94_A      S      98          1.399
LGA    A    95_A      A      99          3.261
LGA    G    96_A      -       -           -
LGA    V    97_A      I     100          2.760
LGA    Q    98_A      -       -           -
LGA    T    99_A      -       -           -
LGA    I   100_A      W     101          1.822
LGA    L   101_A      -       -           -
LGA    N   102_A      -       -           -
LGA    T   103_A      L     102           #
LGA    R   104_A      -       -           -
LGA    N   105_A      -       -           -
LGA    K   106_A      R     103          3.977
LGA    A   107_A      G     104          1.923
LGA    F   108_A      T     105          0.925
LGA    W   109_A      L     106          1.331
LGA    E   110_A      D     107          2.475
LGA    T   111_A      T     108          2.726
LGA    P   112_A      P     109          1.335
LGA    A   113_A      M     110          2.180
LGA    S   114_A      K     111          2.256
LGA    M   115_A      R     112          1.666
LGA    W   116_A      F     113          1.052
LGA    D   117_A      D     114          1.179
LGA    D   118_A      L     115          1.922
LGA    I   119_A      M     116          1.114
LGA    N   120_A      Q     117          1.254
LGA    N   121_A      Q     118          0.626
LGA    V   122_A      V     119          1.507
LGA    G   123_A      N     120          1.498
LGA    L   124_A      A     121          1.607
LGA    R   125_A      R     122          0.954
LGA    G   126_A      G     123          1.391
LGA    H   127_A      S     124          1.165
LGA    Y   128_A      F     125          0.757
LGA    F   129_A      V     126          0.731
LGA    C   130_A      C     127          0.420
LGA    S   131_A      A     128          0.314
LGA    V   132_A      Q     129          0.543
LGA    Y   133_A      A     130          0.944
LGA    G   134_A      C     131          0.812
LGA    A   135_A      L     132          0.782
LGA    R   136_A      P     133          1.114
LGA    L   137_A      H     134          0.369
LGA    M   138_A      L     135          0.986
LGA    V   139_A      L     136          0.933
LGA    P   140_A      Q     137          2.561
LGA    A   141_A      A     138          3.130
LGA    G   142_A      P     139          5.475
LGA    Q   143_A      N     140          3.348
LGA    G   144_A      P     141          0.246
LGA    L   145_A      H     142          0.161
LGA    I   146_A      I     143          0.213
LGA    V   147_A      L     144          0.590
LGA    V   148_A      T     145          0.735
LGA    I   149_A      L     146          0.720
LGA    S   150_A      A     147          0.828
LGA    S   151_A      P     148          2.629
LGA    P   152_A      P     149          5.575
LGA    G   153_A      -       -           -
LGA    S   154_A      P     150          3.994
LGA    L   155_A      S     151          2.104
LGA    -       -      L     152           -
LGA    -       -      N     153           -
LGA    -       -      P     154           -
LGA    -       -      A     155           -
LGA    Q   156_A      W     156          3.154
LGA    Y   157_A      W     157          3.323
LGA    M   158_A      G     158           -
LGA    F   159_A      A     159           #
LGA    N   160_A      H     160          1.692
LGA    V   161_A      T     161          1.416
LGA    P   162_A      G     162          1.524
LGA    Y   163_A      Y     163          1.427
LGA    G   164_A      T     164          0.822
LGA    V   165_A      L     165          1.031
LGA    G   166_A      A     166          1.617
LGA    K   167_A      K     167          2.239
LGA    A   168_A      M     168          2.076
LGA    A   169_A      G     169          1.570
LGA    C   170_A      M     170          1.309
LGA    D   171_A      S     171          1.268
LGA    K   172_A      L     172          1.482
LGA    L   173_A      V     173          1.161
LGA    A   174_A      T     174          1.089
LGA    A   175_A      L     175          1.657
LGA    D   176_A      G     176          1.271
LGA    C   177_A      L     177          0.844
LGA    A   178_A      A     178          1.136
LGA    H   179_A      A     179          1.478
LGA    E   180_A      E     180          1.619
LGA    L   181_A      F     181          1.451
LGA    R   182_A      G     182          2.335
LGA    R   183_A      P     183          2.842
LGA    H   184_A      Q     184          1.906
LGA    G   185_A      G     185          1.315
LGA    V   186_A      V     186          1.009
LGA    S   187_A      A     187          0.986
LGA    C   188_A      I     188          0.353
LGA    V   189_A      N     189          0.305
LGA    S   190_A      A     190          0.883
LGA    L   191_A      L     191          0.753
LGA    W   192_A      W     192          0.633
LGA    P   193_A      P     193          2.543
LGA    -       -      R     194           -
LGA    G   194_A      T     195          4.337
LGA    I   195_A      V     196          3.127
LGA    V   196_A      I     197          2.316
LGA    Q   197_A      A     198          5.067
LGA    -       -      T     199           -
LGA    -       -      D     200           -
LGA    -       -      A     201           -
LGA    T   198_A      I     202          4.644
LGA    E   199_A      N     203           #
LGA    -       -      M     204           -
LGA    L   200_A      L     205          2.423
LGA    L   201_A      P     206           #
LGA    -       -      G     207           -
LGA    -       -      V     208           -
LGA    -       -      D     209           -
LGA    -       -      A     210           -
LGA    -       -      A     211           -
LGA    -       -      A     212           -
LGA    S   224_A      C     213          3.453
LGA    S   225_A      R     214          3.476
LGA    A   226_A      R     215          2.183
LGA    E   227_A      -       -           -
LGA    T   228_A      -       -           -
LGA    T   229_A      P     216          1.118
LGA    E   230_A      E     217          0.635
LGA    L   231_A      I     218          1.367
LGA    S   232_A      M     219          0.991
LGA    G   233_A      A     220          1.084
LGA    K   234_A      D     221          1.275
LGA    C   235_A      A     222          1.644
LGA    V   236_A      A     223          1.652
LGA    V   237_A      H     224          1.481
LGA    A   238_A      A     225          1.403
LGA    L   239_A      V     226          1.471
LGA    A   240_A      L     227          1.667
LGA    T   241_A      T     228          1.307
LGA    D   242_A      R     229          1.428
LGA    P   243_A      E     230          2.606
LGA    N   244_A      -       -           -
LGA    I   245_A      A     231          3.870
LGA    L   246_A      A     232          3.511
LGA    S   247_A      G     233          3.640
LGA    L   248_A      F     234          3.349
LGA    S   249_A      H     235          0.989
LGA    G   250_A      G     236          0.480
LGA    K   251_A      Q     237          0.804
LGA    V   252_A      F     238          0.327
LGA    L   253_A      L     239          0.111
LGA    P   254_A      I     240          0.532
LGA    S   255_A      D     241          0.736
LGA    C   256_A      D     242          0.759
LGA    D   257_A      E     243          0.344
LGA    L   258_A      V     244          0.371
LGA    A   259_A      L     245          0.480
LGA    R   260_A      A     246          0.344
LGA    R   261_A      Q     247          0.858
LGA    Y   262_A      A     248          0.765
LGA    -       -      G     249           -
LGA    -       -      I     250           -
LGA    -       -      T     251           -
LGA    -       -      D     252           -
LGA    -       -      L     253           -
LGA    -       -      S     254           -
LGA    -       -      G     255           -
LGA    -       -      Y     256           -
LGA    -       -      A     257           -
LGA    -       -      V     258           -
LGA    -       -      D     259           -
LGA    -       -      P     260           -
LGA    -       -      Q     261           -
LGA    -       -      R     262           -
LGA    -       -      A     263           -
LGA    -       -      L     264           -
LGA    -       -      L     265           -
LGA    -       -      P     266           -
LGA    -       -      D     267           -
LGA    -       -      L     268           -
LGA    -       -      F     269           -
LGA    -       -      L     270           -
LGA    -       -      E     271           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  238  271    5.0    220    1.74    26.82     74.327    11.946

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.907823 * X  +  -0.416602 * Y  +   0.047960 * Z  +  63.004753
  Y_new =   0.015564 * X  +  -0.080815 * Y  +  -0.996608 * Z  +  76.841919
  Z_new =   0.419065 * X  +   0.905490 * Y  +  -0.066882 * Z  +  31.324810 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.644525   -1.497068  [ DEG:    94.2243    -85.7757 ]
  Theta =  -0.432415   -2.709177  [ DEG:   -24.7756   -155.2244 ]
  Phi   =   0.017142   -3.124450  [ DEG:     0.9822   -179.0178 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qq5_A                                        
REMARK     2: T0511.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qq5_A.T0511.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  238  271   5.0  220   1.74   26.82  74.327
REMARK  ---------------------------------------------------------- 
MOLECULE 2qq5_A
HEADER    OXIDOREDUCTASE                          26-JUL-07   2QQ5              
TITLE     CRYSTAL STRUCTURE OF HUMAN SDR FAMILY MEMBER 1                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DEHYDROGENASE/REDUCTASE SDR FAMILY MEMBER 1;               
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 3-262;                                            
COMPND   5 SYNONYM: DHRS1;                                                      
COMPND   6 EC: 1.1.-.-;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: DHRS1;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-R3;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: P11                                       
KEYWDS    DHRS1, SDR, DEHYDROGENASE, REDUCTASE, SHORT-CHAIN,                    
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, SGC, OXIDOREDUCTASE                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.S.PILKA,V.HOZJAN,E.UGOCHUKWU,F.VON DELFT,M.SUNDSTROM,               
AUTHOR   2 C.H.ARROWSMITH,J.WEIGELT,A.EDWARDS,U.OPPERMANN,STRUCTURAL            
AUTHOR   3 GENOMICS CONSORTIUM (SGC)                                            
REVDAT   2   21-AUG-07 2QQ5    1       REMARK                                   
REVDAT   1   07-AUG-07 2QQ5    0                                                
JRNL        AUTH   E.S.PILKA,V.HOZJAN,E.UGOCHUKWU,F.VON DELFT,                  
JRNL        AUTH 2 M.SUNDSTROM,C.H.ARROWSMITH,J.WEIGELT,A.EDWARDS,              
JRNL        AUTH 3 U.OPPERMANN                                                  
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN SDR FAMILY MEMBER 1.              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2QQ5 A    3   262  UNP    Q96LJ7   DHRS1_HUMAN      3    262             
SEQRES   1 A  260  ALA PRO MET ASN GLY GLN VAL CYS VAL VAL THR GLY ALA          
SEQRES   2 A  260  SER ARG GLY ILE GLY ARG GLY ILE ALA LEU GLN LEU CYS          
SEQRES   3 A  260  LYS ALA GLY ALA THR VAL TYR ILE THR GLY ARG HIS LEU          
SEQRES   4 A  260  ASP THR LEU ARG VAL VAL ALA GLN GLU ALA GLN SER LEU          
SEQRES   5 A  260  GLY GLY GLN CYS VAL PRO VAL VAL CYS ASP SER SER GLN          
SEQRES   6 A  260  GLU SER GLU VAL ARG SER LEU PHE GLU GLN VAL ASP ARG          
SEQRES   7 A  260  GLU GLN GLN GLY ARG LEU ASP VAL LEU VAL ASN ASN ALA          
SEQRES   8 A  260  TYR ALA GLY VAL GLN THR ILE LEU ASN THR ARG ASN LYS          
SEQRES   9 A  260  ALA PHE TRP GLU THR PRO ALA SER MET TRP ASP ASP ILE          
SEQRES  10 A  260  ASN ASN VAL GLY LEU ARG GLY HIS TYR PHE CYS SER VAL          
SEQRES  11 A  260  TYR GLY ALA ARG LEU MET VAL PRO ALA GLY GLN GLY LEU          
SEQRES  12 A  260  ILE VAL VAL ILE SER SER PRO GLY SER LEU GLN TYR MET          
SEQRES  13 A  260  PHE ASN VAL PRO TYR GLY VAL GLY LYS ALA ALA CYS ASP          
SEQRES  14 A  260  LYS LEU ALA ALA ASP CYS ALA HIS GLU LEU ARG ARG HIS          
SEQRES  15 A  260  GLY VAL SER CYS VAL SER LEU TRP PRO GLY ILE VAL GLN          
SEQRES  16 A  260  THR GLU LEU LEU LYS GLU HIS MET ALA LYS GLU GLU VAL          
SEQRES  17 A  260  LEU GLN ASP PRO VAL LEU LYS GLN PHE LYS SER ALA PHE          
SEQRES  18 A  260  SER SER ALA GLU THR THR GLU LEU SER GLY LYS CYS VAL          
SEQRES  19 A  260  VAL ALA LEU ALA THR ASP PRO ASN ILE LEU SER LEU SER          
SEQRES  20 A  260  GLY LYS VAL LEU PRO SER CYS ASP LEU ALA ARG ARG TYR          
FORMUL   2  HOH   *201(H2 O)                                                    
CRYST1   56.225   87.854  100.583  90.00  90.00  90.00 I 2 2 2       8          
ATOM      1  N   ALA A   3      63.072  36.671  42.318  1.00 48.34           N  
ATOM      2  CA  ALA A   3      64.030  36.735  43.485  1.00 45.64           C  
ATOM      3  C   ALA A   3      63.342  36.193  44.734  1.00 41.74           C  
ATOM      4  O   ALA A   3      62.213  36.580  45.026  1.00 42.58           O  
ATOM      5  CB  ALA A   3      64.511  38.152  43.710  1.00 46.66           C  
ATOM      6  N   PRO A   4      64.014  35.285  45.469  1.00 42.11           N  
ATOM      7  CA  PRO A   4      63.423  34.474  46.543  1.00 42.36           C  
ATOM      8  C   PRO A   4      62.745  35.271  47.668  1.00 39.71           C  
ATOM      9  O   PRO A   4      61.773  34.813  48.272  1.00 40.43           O  
ATOM     10  CB  PRO A   4      64.634  33.731  47.126  1.00 44.51           C  
ATOM     11  CG  PRO A   4      65.680  33.833  46.140  1.00 45.88           C  
ATOM     12  CD  PRO A   4      65.445  34.993  45.288  1.00 42.74           C  
ATOM     13  N   MET A   5      63.277  36.446  47.965  1.00 39.11           N  
ATOM     14  CA  MET A   5      62.768  37.249  49.058  1.00 35.97           C  
ATOM     15  C   MET A   5      62.130  38.547  48.561  1.00 38.19           C  
ATOM     16  O   MET A   5      61.976  39.509  49.322  1.00 36.55           O  
ATOM     17  CB  MET A   5      63.889  37.504  50.054  1.00 36.29           C  
ATOM     18  CG  MET A   5      64.258  36.231  50.788  1.00 42.42           C  
ATOM     19  SD  MET A   5      65.315  36.517  52.197  1.00 41.17           S  
ATOM     20  CE  MET A   5      64.258  37.428  53.334  1.00 38.29           C  
ATOM     21  N   ASN A   6      61.744  38.558  47.282  1.00 35.66           N  
ATOM     22  CA  ASN A   6      60.938  39.641  46.715  1.00 37.32           C  
ATOM     23  C   ASN A   6      59.721  39.938  47.591  1.00 32.32           C  
ATOM     24  O   ASN A   6      59.005  39.024  48.013  1.00 37.68           O  
ATOM     25  CB  ASN A   6      60.435  39.275  45.315  1.00 38.32           C  
ATOM     26  CG  ASN A   6      59.649  40.397  44.677  1.00 45.27           C  
ATOM     27  OD1 ASN A   6      60.136  41.519  44.597  1.00 43.72           O  
ATOM     28  ND2 ASN A   6      58.419  40.110  44.242  1.00 43.70           N  
ATOM     29  N   GLY A   7      59.508  41.208  47.890  1.00 36.01           N  
ATOM     30  CA  GLY A   7      58.386  41.615  48.738  1.00 36.84           C  
ATOM     31  C   GLY A   7      58.614  41.497  50.233  1.00 40.11           C  
ATOM     32  O   GLY A   7      57.787  41.960  51.025  1.00 43.15           O  
ATOM     33  N   GLN A   8      59.732  40.900  50.639  1.00 37.20           N  
ATOM     34  CA  GLN A   8      59.982  40.712  52.069  1.00 35.85           C  
ATOM     35  C   GLN A   8      60.737  41.879  52.691  1.00 35.11           C  
ATOM     36  O   GLN A   8      61.428  42.639  52.002  1.00 34.31           O  
ATOM     37  CB  GLN A   8      60.673  39.392  52.330  1.00 36.63           C  
ATOM     38  CG  GLN A   8      59.854  38.212  51.802  1.00 40.70           C  
ATOM     39  CD  GLN A   8      60.204  36.928  52.476  1.00 45.79           C  
ATOM     40  OE1 GLN A   8      60.526  36.912  53.661  1.00 51.88           O  
ATOM     41  NE2 GLN A   8      60.159  35.834  51.726  1.00 54.41           N  
ATOM     42  N   VAL A   9      60.548  42.036  53.999  1.00 30.92           N  
ATOM     43  CA  VAL A   9      61.061  43.188  54.726  1.00 29.48           C  
ATOM     44  C   VAL A   9      61.921  42.660  55.882  1.00 32.95           C  
ATOM     45  O   VAL A   9      61.481  41.826  56.664  1.00 33.98           O  
ATOM     46  CB  VAL A   9      59.920  44.051  55.305  1.00 31.43           C  
ATOM     47  CG1 VAL A   9      60.486  45.187  56.209  1.00 32.03           C  
ATOM     48  CG2 VAL A   9      59.077  44.618  54.165  1.00 30.89           C  
ATOM     49  N   CYS A  10      63.144  43.141  55.955  1.00 31.43           N  
ATOM     50  CA  CYS A  10      64.075  42.690  56.979  1.00 33.57           C  
ATOM     51  C   CYS A  10      64.667  43.871  57.725  1.00 31.89           C  
ATOM     52  O   CYS A  10      64.759  44.973  57.173  1.00 32.33           O  
ATOM     53  CB  CYS A  10      65.221  41.903  56.330  1.00 33.52           C  
ATOM     54  SG  CYS A  10      64.746  40.564  55.276  1.00 39.50           S  
ATOM     55  N   VAL A  11      65.062  43.635  58.983  1.00 29.70           N  
ATOM     56  CA  VAL A  11      65.864  44.562  59.783  1.00 30.83           C  
ATOM     57  C   VAL A  11      67.102  43.827  60.280  1.00 35.19           C  
ATOM     58  O   VAL A  11      66.994  42.752  60.877  1.00 33.64           O  
ATOM     59  CB  VAL A  11      65.107  45.078  61.024  1.00 30.84           C  
ATOM     60  CG1 VAL A  11      66.075  45.879  61.988  1.00 30.98           C  
ATOM     61  CG2 VAL A  11      63.887  45.934  60.594  1.00 32.10           C  
ATOM     62  N   VAL A  12      68.273  44.400  60.019  1.00 30.94           N  
ATOM     63  CA  VAL A  12      69.523  43.817  60.468  1.00 31.58           C  
ATOM     64  C   VAL A  12      70.241  44.853  61.312  1.00 33.97           C  
ATOM     65  O   VAL A  12      70.552  45.951  60.834  1.00 33.11           O  
ATOM     66  CB  VAL A  12      70.437  43.355  59.297  1.00 31.58           C  
ATOM     67  CG1 VAL A  12      71.745  42.745  59.866  1.00 33.09           C  
ATOM     68  CG2 VAL A  12      69.692  42.349  58.375  1.00 33.06           C  
ATOM     69  N   THR A  13      70.416  44.537  62.595  1.00 31.95           N  
ATOM     70  CA  THR A  13      71.170  45.429  63.494  1.00 31.99           C  
ATOM     71  C   THR A  13      72.669  45.145  63.437  1.00 32.62           C  
ATOM     72  O   THR A  13      73.102  44.088  62.984  1.00 31.92           O  
ATOM     73  CB  THR A  13      70.647  45.382  64.959  1.00 30.66           C  
ATOM     74  OG1 THR A  13      70.885  44.086  65.514  1.00 33.84           O  
ATOM     75  CG2 THR A  13      69.168  45.699  64.990  1.00 36.97           C  
ATOM     76  N   GLY A  14      73.464  46.132  63.823  1.00 35.90           N  
ATOM     77  CA  GLY A  14      74.919  46.010  63.758  1.00 38.73           C  
ATOM     78  C   GLY A  14      75.422  45.719  62.352  1.00 36.58           C  
ATOM     79  O   GLY A  14      76.330  44.907  62.186  1.00 36.39           O  
ATOM     80  N   ALA A  15      74.837  46.377  61.345  1.00 34.55           N  
ATOM     81  CA  ALA A  15      75.075  46.041  59.942  1.00 33.90           C  
ATOM     82  C   ALA A  15      76.240  46.792  59.287  1.00 34.65           C  
ATOM     83  O   ALA A  15      76.443  46.661  58.081  1.00 33.80           O  
ATOM     84  CB  ALA A  15      73.794  46.264  59.107  1.00 35.00           C  
ATOM     85  N   SER A  16      76.969  47.605  60.047  1.00 34.03           N  
ATOM     86  CA  SER A  16      78.043  48.427  59.481  1.00 36.61           C  
ATOM     87  C   SER A  16      79.281  47.632  59.080  1.00 35.45           C  
ATOM     88  O   SER A  16      80.092  48.093  58.269  1.00 38.51           O  
ATOM     89  CB  SER A  16      78.483  49.484  60.502  1.00 38.75           C  
ATOM     90  OG  SER A  16      77.404  50.371  60.822  1.00 44.61           O  
ATOM     91  N   ARG A  17      79.429  46.456  59.658  1.00 34.25           N  
ATOM     92  CA  ARG A  17      80.587  45.623  59.390  1.00 36.33           C  
ATOM     93  C   ARG A  17      80.321  44.190  59.796  1.00 35.14           C  
ATOM     94  O   ARG A  17      79.289  43.877  60.414  1.00 33.77           O  
ATOM     95  CB  ARG A  17      81.808  46.132  60.161  1.00 37.40           C  
ATOM     96  CG  ARG A  17      81.618  46.078  61.630  1.00 37.75           C  
ATOM     97  CD  ARG A  17      82.938  46.117  62.360  1.00 49.38           C  
ATOM     98  NE  ARG A  17      83.207  47.438  62.863  1.00 54.50           N  
ATOM     99  CZ  ARG A  17      84.261  47.735  63.614  1.00 64.23           C  
ATOM    100  NH1 ARG A  17      85.159  46.801  63.916  1.00 47.43           N  
ATOM    101  NH2 ARG A  17      84.421  48.979  64.046  1.00 60.70           N  
ATOM    102  N   GLY A  18      81.269  43.328  59.442  1.00 37.91           N  
ATOM    103  CA  GLY A  18      81.294  41.963  59.943  1.00 37.86           C  
ATOM    104  C   GLY A  18      80.074  41.144  59.573  1.00 36.67           C  
ATOM    105  O   GLY A  18      79.569  41.213  58.432  1.00 32.89           O  
ATOM    106  N   ILE A  19      79.624  40.346  60.536  1.00 36.22           N  
ATOM    107  CA  ILE A  19      78.517  39.426  60.328  1.00 35.68           C  
ATOM    108  C   ILE A  19      77.249  40.150  59.879  1.00 35.40           C  
ATOM    109  O   ILE A  19      76.583  39.693  58.950  1.00 32.95           O  
ATOM    110  CB  ILE A  19      78.189  38.620  61.619  1.00 36.13           C  
ATOM    111  CG1 ILE A  19      79.294  37.617  61.930  1.00 42.49           C  
ATOM    112  CG2 ILE A  19      76.848  37.910  61.454  1.00 35.97           C  
ATOM    113  CD1 ILE A  19      79.607  36.691  60.757  1.00 49.12           C  
ATOM    114  N   GLY A  20      76.919  41.267  60.536  1.00 32.37           N  
ATOM    115  CA  GLY A  20      75.698  42.026  60.193  1.00 34.71           C  
ATOM    116  C   GLY A  20      75.714  42.549  58.772  1.00 33.42           C  
ATOM    117  O   GLY A  20      74.733  42.446  58.019  1.00 31.66           O  
ATOM    118  N   ARG A  21      76.845  43.094  58.374  1.00 31.42           N  
ATOM    119  CA  ARG A  21      76.991  43.533  56.992  1.00 30.20           C  
ATOM    120  C   ARG A  21      76.837  42.377  55.988  1.00 31.52           C  
ATOM    121  O   ARG A  21      76.155  42.521  54.973  1.00 33.25           O  
ATOM    122  CB  ARG A  21      78.347  44.203  56.813  1.00 31.42           C  
ATOM    123  CG  ARG A  21      78.714  44.465  55.369  1.00 33.87           C  
ATOM    124  CD  ARG A  21      80.074  45.128  55.294  1.00 38.13           C  
ATOM    125  NE  ARG A  21      80.484  45.247  53.906  1.00 41.01           N  
ATOM    126  CZ  ARG A  21      81.064  44.285  53.194  1.00 44.07           C  
ATOM    127  NH1 ARG A  21      81.361  43.107  53.733  1.00 44.18           N  
ATOM    128  NH2 ARG A  21      81.375  44.520  51.924  1.00 44.81           N  
ATOM    129  N   GLY A  22      77.471  41.239  56.271  1.00 32.73           N  
ATOM    130  CA  GLY A  22      77.387  40.047  55.408  1.00 32.10           C  
ATOM    131  C   GLY A  22      75.946  39.591  55.226  1.00 31.69           C  
ATOM    132  O   GLY A  22      75.507  39.298  54.110  1.00 33.50           O  
ATOM    133  N   ILE A  23      75.184  39.593  56.320  1.00 32.40           N  
ATOM    134  CA  ILE A  23      73.780  39.171  56.270  1.00 31.86           C  
ATOM    135  C   ILE A  23      72.931  40.168  55.467  1.00 32.61           C  
ATOM    136  O   ILE A  23      72.164  39.764  54.606  1.00 34.71           O  
ATOM    137  CB  ILE A  23      73.217  38.942  57.705  1.00 32.80           C  
ATOM    138  CG1 ILE A  23      73.947  37.766  58.383  1.00 32.43           C  
ATOM    139  CG2 ILE A  23      71.700  38.659  57.640  1.00 31.40           C  
ATOM    140  CD1 ILE A  23      73.637  37.622  59.881  1.00 31.95           C  
ATOM    141  N   ALA A  24      73.105  41.468  55.725  1.00 32.63           N  
ATOM    142  CA  ALA A  24      72.383  42.510  54.976  1.00 32.70           C  
ATOM    143  C   ALA A  24      72.587  42.335  53.478  1.00 34.09           C  
ATOM    144  O   ALA A  24      71.637  42.381  52.673  1.00 32.23           O  
ATOM    145  CB  ALA A  24      72.852  43.903  55.395  1.00 33.29           C  
ATOM    146  N   LEU A  25      73.842  42.118  53.102  1.00 35.16           N  
ATOM    147  CA  LEU A  25      74.181  41.959  51.697  1.00 32.41           C  
ATOM    148  C   LEU A  25      73.476  40.764  51.064  1.00 33.29           C  
ATOM    149  O   LEU A  25      72.945  40.881  49.954  1.00 32.64           O  
ATOM    150  CB  LEU A  25      75.695  41.812  51.528  1.00 33.88           C  
ATOM    151  CG  LEU A  25      76.608  43.001  51.808  1.00 40.73           C  
ATOM    152  CD1 LEU A  25      78.077  42.589  51.524  1.00 41.49           C  
ATOM    153  CD2 LEU A  25      76.254  44.190  50.979  1.00 42.23           C  
ATOM    154  N   GLN A  26      73.472  39.616  51.748  1.00 34.19           N  
ATOM    155  CA  GLN A  26      72.823  38.404  51.186  1.00 33.51           C  
ATOM    156  C   GLN A  26      71.306  38.550  51.125  1.00 31.78           C  
ATOM    157  O   GLN A  26      70.675  38.092  50.176  1.00 34.49           O  
ATOM    158  CB  GLN A  26      73.227  37.143  51.958  1.00 35.04           C  
ATOM    159  CG  GLN A  26      74.694  36.779  51.791  1.00 36.96           C  
ATOM    160  CD  GLN A  26      75.090  36.608  50.340  1.00 43.68           C  
ATOM    161  OE1 GLN A  26      74.393  35.956  49.582  1.00 38.57           O  
ATOM    162  NE2 GLN A  26      76.205  37.207  49.947  1.00 39.92           N  
ATOM    163  N   LEU A  27      70.724  39.229  52.116  1.00 33.65           N  
ATOM    164  CA  LEU A  27      69.283  39.471  52.123  1.00 35.62           C  
ATOM    165  C   LEU A  27      68.881  40.386  50.957  1.00 32.61           C  
ATOM    166  O   LEU A  27      67.893  40.125  50.277  1.00 34.46           O  
ATOM    167  CB  LEU A  27      68.824  40.026  53.470  1.00 32.05           C  
ATOM    168  CG  LEU A  27      68.812  39.065  54.674  1.00 33.73           C  
ATOM    169  CD1 LEU A  27      68.560  39.862  55.975  1.00 33.07           C  
ATOM    170  CD2 LEU A  27      67.741  37.971  54.466  1.00 33.51           C  
ATOM    171  N   CYS A  28      69.654  41.440  50.696  1.00 33.03           N  
ATOM    172  CA  CYS A  28      69.358  42.281  49.544  1.00 35.11           C  
ATOM    173  C   CYS A  28      69.558  41.494  48.251  1.00 37.12           C  
ATOM    174  O   CYS A  28      68.754  41.601  47.326  1.00 33.62           O  
ATOM    175  CB  CYS A  28      70.236  43.525  49.536  1.00 33.22           C  
ATOM    176  SG  CYS A  28      69.719  44.672  50.750  1.00 37.10           S  
ATOM    177  N   LYS A  29      70.619  40.690  48.202  1.00 36.37           N  
ATOM    178  CA  LYS A  29      70.866  39.855  47.024  1.00 38.07           C  
ATOM    179  C   LYS A  29      69.681  38.915  46.738  1.00 37.81           C  
ATOM    180  O   LYS A  29      69.360  38.652  45.575  1.00 37.36           O  
ATOM    181  CB  LYS A  29      72.156  39.054  47.175  1.00 34.21           C  
ATOM    182  CG  LYS A  29      72.542  38.310  45.909  1.00 44.70           C  
ATOM    183  CD  LYS A  29      73.887  37.623  46.054  1.00 44.81           C  
ATOM    184  CE  LYS A  29      74.258  36.899  44.771  1.00 52.92           C  
ATOM    185  NZ  LYS A  29      75.422  35.975  44.958  1.00 56.61           N  
ATOM    186  N   ALA A  30      69.008  38.460  47.792  1.00 36.61           N  
ATOM    187  CA  ALA A  30      67.824  37.598  47.670  1.00 35.03           C  
ATOM    188  C   ALA A  30      66.541  38.391  47.303  1.00 36.92           C  
ATOM    189  O   ALA A  30      65.496  37.798  47.064  1.00 38.79           O  
ATOM    190  CB  ALA A  30      67.625  36.791  48.969  1.00 35.30           C  
ATOM    191  N   GLY A  31      66.645  39.721  47.254  1.00 35.05           N  
ATOM    192  CA  GLY A  31      65.583  40.601  46.761  1.00 33.45           C  
ATOM    193  C   GLY A  31      64.767  41.312  47.828  1.00 35.02           C  
ATOM    194  O   GLY A  31      63.792  41.978  47.499  1.00 31.49           O  
ATOM    195  N   ALA A  32      65.166  41.186  49.102  1.00 35.62           N  
ATOM    196  CA  ALA A  32      64.422  41.783  50.225  1.00 31.18           C  
ATOM    197  C   ALA A  32      64.639  43.290  50.301  1.00 33.09           C  
ATOM    198  O   ALA A  32      65.637  43.811  49.802  1.00 34.37           O  
ATOM    199  CB  ALA A  32      64.847  41.142  51.577  1.00 33.33           C  
ATOM    200  N   THR A  33      63.734  43.982  50.981  1.00 32.75           N  
ATOM    201  CA  THR A  33      64.035  45.313  51.491  1.00 33.11           C  
ATOM    202  C   THR A  33      64.656  45.098  52.880  1.00 32.26           C  
ATOM    203  O   THR A  33      64.039  44.442  53.739  1.00 32.19           O  
ATOM    204  CB  THR A  33      62.743  46.165  51.613  1.00 32.63           C  
ATOM    205  OG1 THR A  33      62.188  46.399  50.308  1.00 38.27           O  
ATOM    206  CG2 THR A  33      63.037  47.492  52.304  1.00 36.41           C  
ATOM    207  N   VAL A  34      65.875  45.621  53.077  1.00 31.95           N  
ATOM    208  CA  VAL A  34      66.618  45.457  54.306  1.00 31.77           C  
ATOM    209  C   VAL A  34      66.930  46.803  54.955  1.00 31.20           C  
ATOM    210  O   VAL A  34      67.643  47.626  54.403  1.00 33.65           O  
ATOM    211  CB  VAL A  34      67.910  44.667  54.074  1.00 32.71           C  
ATOM    212  CG1 VAL A  34      68.576  44.330  55.423  1.00 33.98           C  
ATOM    213  CG2 VAL A  34      67.620  43.401  53.241  1.00 35.77           C  
ATOM    214  N   TYR A  35      66.335  47.011  56.124  1.00 32.31           N  
ATOM    215  CA  TYR A  35      66.690  48.102  57.010  1.00 31.51           C  
ATOM    216  C   TYR A  35      67.956  47.706  57.793  1.00 35.10           C  
ATOM    217  O   TYR A  35      68.000  46.647  58.440  1.00 35.23           O  
ATOM    218  CB  TYR A  35      65.564  48.401  57.983  1.00 33.99           C  
ATOM    219  CG  TYR A  35      64.341  48.958  57.290  1.00 28.72           C  
ATOM    220  CD1 TYR A  35      64.122  50.317  57.246  1.00 31.14           C  
ATOM    221  CD2 TYR A  35      63.432  48.124  56.623  1.00 33.69           C  
ATOM    222  CE1 TYR A  35      63.048  50.850  56.585  1.00 31.68           C  
ATOM    223  CE2 TYR A  35      62.321  48.661  55.962  1.00 35.85           C  
ATOM    224  CZ  TYR A  35      62.140  50.036  55.958  1.00 35.61           C  
ATOM    225  OH  TYR A  35      61.065  50.628  55.294  1.00 33.98           O  
ATOM    226  N   ILE A  36      68.972  48.549  57.705  1.00 32.99           N  
ATOM    227  CA  ILE A  36      70.242  48.316  58.394  1.00 32.48           C  
ATOM    228  C   ILE A  36      70.519  49.416  59.396  1.00 33.73           C  
ATOM    229  O   ILE A  36      70.328  50.628  59.128  1.00 34.41           O  
ATOM    230  CB  ILE A  36      71.447  48.121  57.426  1.00 31.87           C  
ATOM    231  CG1 ILE A  36      71.637  49.314  56.472  1.00 37.11           C  
ATOM    232  CG2 ILE A  36      71.224  46.883  56.593  1.00 32.13           C  
ATOM    233  CD1 ILE A  36      73.042  49.398  55.812  1.00 34.87           C  
ATOM    234  N   THR A  37      70.965  49.005  60.572  1.00 31.39           N  
ATOM    235  CA  THR A  37      71.125  49.983  61.637  1.00 33.01           C  
ATOM    236  C   THR A  37      72.546  50.054  62.177  1.00 33.95           C  
ATOM    237  O   THR A  37      73.356  49.078  62.097  1.00 33.50           O  
ATOM    238  CB  THR A  37      70.168  49.704  62.806  1.00 38.08           C  
ATOM    239  OG1 THR A  37      70.702  48.631  63.586  1.00 37.87           O  
ATOM    240  CG2 THR A  37      68.777  49.350  62.295  1.00 36.85           C  
ATOM    241  N   GLY A  38      72.797  51.192  62.815  1.00 34.81           N  
ATOM    242  CA  GLY A  38      74.096  51.526  63.378  1.00 37.37           C  
ATOM    243  C   GLY A  38      74.049  52.958  63.879  1.00 33.95           C  
ATOM    244  O   GLY A  38      73.052  53.649  63.704  1.00 35.57           O  
ATOM    245  N   ARG A  39      75.139  53.404  64.485  1.00 38.04           N  
ATOM    246  CA  ARG A  39      75.198  54.733  65.074  1.00 40.01           C  
ATOM    247  C   ARG A  39      75.560  55.796  64.047  1.00 37.53           C  
ATOM    248  O   ARG A  39      75.329  56.980  64.289  1.00 38.46           O  
ATOM    249  CB  ARG A  39      76.200  54.747  66.238  1.00 40.98           C  
ATOM    250  CG  ARG A  39      75.582  54.323  67.574  1.00 53.67           C  
ATOM    251  CD  ARG A  39      76.602  54.351  68.722  1.00 49.90           C  
ATOM    252  NE  ARG A  39      77.665  55.363  68.571  1.00 57.87           N  
ATOM    253  N   HIS A  40      76.100  55.401  62.892  1.00 35.35           N  
ATOM    254  CA  HIS A  40      76.691  56.381  61.960  1.00 37.75           C  
ATOM    255  C   HIS A  40      76.192  56.205  60.528  1.00 37.64           C  
ATOM    256  O   HIS A  40      76.497  55.221  59.853  1.00 37.49           O  
ATOM    257  CB  HIS A  40      78.228  56.327  61.996  1.00 38.66           C  
ATOM    258  CG  HIS A  40      78.798  56.414  63.382  1.00 40.18           C  
ATOM    259  ND1 HIS A  40      78.630  57.520  64.185  1.00 40.03           N  
ATOM    260  CD2 HIS A  40      79.513  55.527  64.110  1.00 42.74           C  
ATOM    261  CE1 HIS A  40      79.222  57.311  65.345  1.00 43.16           C  
ATOM    262  NE2 HIS A  40      79.769  56.110  65.325  1.00 42.34           N  
ATOM    263  N   LEU A  41      75.429  57.188  60.069  1.00 36.66           N  
ATOM    264  CA  LEU A  41      74.714  57.083  58.804  1.00 37.84           C  
ATOM    265  C   LEU A  41      75.654  56.898  57.602  1.00 36.54           C  
ATOM    266  O   LEU A  41      75.390  56.104  56.690  1.00 36.12           O  
ATOM    267  CB  LEU A  41      73.869  58.335  58.597  1.00 37.05           C  
ATOM    268  CG  LEU A  41      72.965  58.373  57.355  1.00 39.43           C  
ATOM    269  CD1 LEU A  41      72.050  57.168  57.303  1.00 38.54           C  
ATOM    270  CD2 LEU A  41      72.155  59.657  57.333  1.00 37.94           C  
ATOM    271  N   ASP A  42      76.738  57.652  57.613  1.00 38.04           N  
ATOM    272  CA  ASP A  42      77.715  57.641  56.508  1.00 42.83           C  
ATOM    273  C   ASP A  42      78.229  56.227  56.249  1.00 42.40           C  
ATOM    274  O   ASP A  42      78.313  55.776  55.102  1.00 40.84           O  
ATOM    275  CB  ASP A  42      78.886  58.569  56.852  1.00 44.65           C  
ATOM    276  CG  ASP A  42      79.297  58.460  58.338  1.00 61.39           C  
ATOM    277  OD1 ASP A  42      78.532  58.960  59.210  1.00 65.77           O  
ATOM    278  OD2 ASP A  42      80.354  57.847  58.631  1.00 68.18           O  
ATOM    279  N   THR A  43      78.577  55.538  57.326  1.00 38.09           N  
ATOM    280  CA  THR A  43      79.063  54.172  57.243  1.00 37.08           C  
ATOM    281  C   THR A  43      77.969  53.261  56.653  1.00 34.66           C  
ATOM    282  O   THR A  43      78.212  52.516  55.713  1.00 35.30           O  
ATOM    283  CB  THR A  43      79.479  53.648  58.635  1.00 41.75           C  
ATOM    284  OG1 THR A  43      80.337  54.611  59.267  1.00 44.28           O  
ATOM    285  CG2 THR A  43      80.204  52.317  58.497  1.00 41.30           C  
ATOM    286  N   LEU A  44      76.766  53.363  57.199  1.00 31.47           N  
ATOM    287  CA  LEU A  44      75.621  52.565  56.735  1.00 32.57           C  
ATOM    288  C   LEU A  44      75.323  52.790  55.258  1.00 30.22           C  
ATOM    289  O   LEU A  44      74.940  51.849  54.529  1.00 34.07           O  
ATOM    290  CB  LEU A  44      74.387  52.893  57.583  1.00 31.56           C  
ATOM    291  CG  LEU A  44      74.517  52.463  59.066  1.00 32.90           C  
ATOM    292  CD1 LEU A  44      73.496  53.177  59.902  1.00 40.17           C  
ATOM    293  CD2 LEU A  44      74.388  50.965  59.225  1.00 36.69           C  
ATOM    294  N   ARG A  45      75.471  54.029  54.809  1.00 30.90           N  
ATOM    295  CA  ARG A  45      75.201  54.336  53.393  1.00 33.92           C  
ATOM    296  C   ARG A  45      76.141  53.604  52.468  1.00 33.10           C  
ATOM    297  O   ARG A  45      75.749  53.193  51.379  1.00 30.02           O  
ATOM    298  CB  ARG A  45      75.239  55.835  53.117  1.00 34.91           C  
ATOM    299  CG  ARG A  45      73.992  56.547  53.582  1.00 39.29           C  
ATOM    300  CD  ARG A  45      74.009  58.027  53.208  1.00 46.43           C  
ATOM    301  NE  ARG A  45      72.655  58.568  53.285  1.00 46.61           N  
ATOM    302  CZ  ARG A  45      72.340  59.831  53.583  1.00 60.11           C  
ATOM    303  NH1 ARG A  45      73.286  60.724  53.859  1.00 63.46           N  
ATOM    304  NH2 ARG A  45      71.056  60.199  53.614  1.00 54.90           N  
ATOM    305  N   VAL A  46      77.390  53.435  52.886  1.00 30.55           N  
ATOM    306  CA  VAL A  46      78.344  52.706  52.046  1.00 31.62           C  
ATOM    307  C   VAL A  46      77.924  51.230  51.900  1.00 32.33           C  
ATOM    308  O   VAL A  46      77.931  50.685  50.788  1.00 33.75           O  
ATOM    309  CB  VAL A  46      79.799  52.825  52.596  1.00 30.37           C  
ATOM    310  CG1 VAL A  46      80.773  52.029  51.716  1.00 31.23           C  
ATOM    311  CG2 VAL A  46      80.224  54.295  52.693  1.00 36.02           C  
ATOM    312  N   VAL A  47      77.567  50.595  53.015  1.00 30.05           N  
ATOM    313  CA  VAL A  47      77.014  49.209  53.004  1.00 31.61           C  
ATOM    314  C   VAL A  47      75.755  49.124  52.103  1.00 32.03           C  
ATOM    315  O   VAL A  47      75.577  48.193  51.320  1.00 32.06           O  
ATOM    316  CB  VAL A  47      76.684  48.731  54.441  1.00 35.39           C  
ATOM    317  CG1 VAL A  47      76.036  47.327  54.410  1.00 32.70           C  
ATOM    318  CG2 VAL A  47      77.978  48.747  55.331  1.00 31.16           C  
ATOM    319  N   ALA A  48      74.889  50.123  52.225  1.00 30.06           N  
ATOM    320  CA  ALA A  48      73.618  50.168  51.475  1.00 35.35           C  
ATOM    321  C   ALA A  48      73.854  50.241  49.968  1.00 36.05           C  
ATOM    322  O   ALA A  48      73.152  49.604  49.187  1.00 37.12           O  
ATOM    323  CB  ALA A  48      72.813  51.352  51.945  1.00 29.98           C  
ATOM    324  N   GLN A  49      74.869  51.006  49.571  1.00 37.80           N  
ATOM    325  CA  GLN A  49      75.249  51.125  48.174  1.00 38.18           C  
ATOM    326  C   GLN A  49      75.664  49.766  47.644  1.00 39.70           C  
ATOM    327  O   GLN A  49      75.296  49.356  46.543  1.00 38.32           O  
ATOM    328  CB  GLN A  49      76.419  52.100  48.029  1.00 38.41           C  
ATOM    329  CG  GLN A  49      76.076  53.546  48.343  1.00 36.17           C  
ATOM    330  CD  GLN A  49      77.294  54.401  48.690  1.00 39.86           C  
ATOM    331  OE1 GLN A  49      78.434  54.034  48.405  1.00 63.92           O  
ATOM    332  NE2 GLN A  49      77.054  55.551  49.288  1.00 35.26           N  
ATOM    333  N   GLU A  50      76.437  49.051  48.438  1.00 36.54           N  
ATOM    334  CA  GLU A  50      76.893  47.747  48.029  1.00 38.93           C  
ATOM    335  C   GLU A  50      75.733  46.739  48.038  1.00 36.11           C  
ATOM    336  O   GLU A  50      75.544  45.981  47.078  1.00 36.86           O  
ATOM    337  CB  GLU A  50      78.064  47.311  48.890  1.00 35.83           C  
ATOM    338  CG  GLU A  50      78.623  46.001  48.454  1.00 42.04           C  
ATOM    339  CD  GLU A  50      79.978  45.710  49.042  1.00 53.08           C  
ATOM    340  OE1 GLU A  50      80.490  46.518  49.867  1.00 51.62           O  
ATOM    341  OE2 GLU A  50      80.523  44.656  48.662  1.00 44.97           O  
ATOM    342  N   ALA A  51      74.938  46.764  49.105  1.00 33.80           N  
ATOM    343  CA  ALA A  51      73.800  45.847  49.245  1.00 35.60           C  
ATOM    344  C   ALA A  51      72.825  46.019  48.073  1.00 39.17           C  
ATOM    345  O   ALA A  51      72.501  45.060  47.380  1.00 39.23           O  
ATOM    346  CB  ALA A  51      73.085  46.087  50.577  1.00 36.10           C  
ATOM    347  N   GLN A  52      72.377  47.252  47.862  1.00 36.08           N  
ATOM    348  CA  GLN A  52      71.389  47.557  46.827  1.00 40.97           C  
ATOM    349  C   GLN A  52      71.912  47.198  45.427  1.00 41.08           C  
ATOM    350  O   GLN A  52      71.146  46.820  44.555  1.00 41.27           O  
ATOM    351  CB  GLN A  52      70.914  49.023  46.930  1.00 43.72           C  
ATOM    352  CG  GLN A  52      71.888  50.110  46.360  1.00 47.12           C  
ATOM    353  CD  GLN A  52      71.451  51.568  46.668  1.00 46.24           C  
ATOM    354  OE1 GLN A  52      70.446  51.800  47.336  1.00 52.93           O  
ATOM    355  NE2 GLN A  52      72.198  52.547  46.135  1.00 46.94           N  
ATOM    356  N   SER A  53      73.226  47.256  45.240  1.00 40.76           N  
ATOM    357  CA  SER A  53      73.842  46.799  44.003  1.00 44.78           C  
ATOM    358  C   SER A  53      73.616  45.298  43.738  1.00 41.73           C  
ATOM    359  O   SER A  53      73.532  44.888  42.585  1.00 43.62           O  
ATOM    360  CB  SER A  53      75.350  47.108  44.015  1.00 45.61           C  
ATOM    361  OG  SER A  53      76.005  46.479  42.932  1.00 59.65           O  
ATOM    362  N   LEU A  54      73.535  44.491  44.794  1.00 39.35           N  
ATOM    363  CA  LEU A  54      73.291  43.062  44.647  1.00 38.45           C  
ATOM    364  C   LEU A  54      71.810  42.798  44.348  1.00 40.27           C  
ATOM    365  O   LEU A  54      71.475  41.847  43.653  1.00 40.38           O  
ATOM    366  CB  LEU A  54      73.735  42.284  45.887  1.00 35.26           C  
ATOM    367  CG  LEU A  54      75.246  42.280  46.205  1.00 37.52           C  
ATOM    368  CD1 LEU A  54      75.510  41.645  47.568  1.00 35.63           C  
ATOM    369  CD2 LEU A  54      76.058  41.558  45.068  1.00 37.13           C  
ATOM    370  N   GLY A  55      70.933  43.631  44.881  1.00 39.31           N  
ATOM    371  CA  GLY A  55      69.501  43.547  44.570  1.00 39.24           C  
ATOM    372  C   GLY A  55      68.677  44.121  45.718  1.00 38.15           C  
ATOM    373  O   GLY A  55      69.221  44.730  46.641  1.00 37.25           O  
ATOM    374  N   GLY A  56      67.371  43.911  45.656  1.00 36.20           N  
ATOM    375  CA  GLY A  56      66.464  44.388  46.673  1.00 35.98           C  
ATOM    376  C   GLY A  56      66.603  45.883  46.887  1.00 33.78           C  
ATOM    377  O   GLY A  56      66.865  46.630  45.950  1.00 35.71           O  
ATOM    378  N   GLN A  57      66.395  46.309  48.130  1.00 34.09           N  
ATOM    379  CA  GLN A  57      66.526  47.702  48.567  1.00 34.48           C  
ATOM    380  C   GLN A  57      67.155  47.705  49.952  1.00 35.10           C  
ATOM    381  O   GLN A  57      66.955  46.774  50.732  1.00 33.59           O  
ATOM    382  CB  GLN A  57      65.167  48.391  48.682  1.00 38.62           C  
ATOM    383  CG  GLN A  57      64.361  48.474  47.417  1.00 42.93           C  
ATOM    384  CD  GLN A  57      64.876  49.536  46.428  1.00 55.77           C  
ATOM    385  OE1 GLN A  57      65.395  50.583  46.823  1.00 60.66           O  
ATOM    386  NE2 GLN A  57      64.722  49.260  45.140  1.00 58.66           N  
ATOM    387  N   CYS A  58      67.885  48.767  50.262  1.00 33.71           N  
ATOM    388  CA  CYS A  58      68.585  48.836  51.545  1.00 34.46           C  
ATOM    389  C   CYS A  58      68.381  50.198  52.169  1.00 33.33           C  
ATOM    390  O   CYS A  58      68.673  51.232  51.534  1.00 35.27           O  
ATOM    391  CB  CYS A  58      70.057  48.522  51.361  1.00 34.88           C  
ATOM    392  SG  CYS A  58      70.893  48.326  52.945  1.00 36.72           S  
ATOM    393  N   VAL A  59      67.882  50.210  53.403  1.00 31.09           N  
ATOM    394  CA  VAL A  59      67.485  51.446  54.059  1.00 32.24           C  
ATOM    395  C   VAL A  59      68.303  51.657  55.347  1.00 32.10           C  
ATOM    396  O   VAL A  59      68.014  51.052  56.396  1.00 32.20           O  
ATOM    397  CB  VAL A  59      65.971  51.487  54.399  1.00 31.22           C  
ATOM    398  CG1 VAL A  59      65.567  52.898  54.842  1.00 35.44           C  
ATOM    399  CG2 VAL A  59      65.147  51.022  53.217  1.00 34.45           C  
ATOM    400  N   PRO A  60      69.340  52.488  55.254  1.00 34.59           N  
ATOM    401  CA  PRO A  60      70.078  52.886  56.465  1.00 35.98           C  
ATOM    402  C   PRO A  60      69.192  53.616  57.459  1.00 37.38           C  
ATOM    403  O   PRO A  60      68.485  54.546  57.070  1.00 33.18           O  
ATOM    404  CB  PRO A  60      71.165  53.816  55.930  1.00 37.13           C  
ATOM    405  CG  PRO A  60      71.338  53.442  54.524  1.00 39.27           C  
ATOM    406  CD  PRO A  60      69.971  53.018  54.033  1.00 35.45           C  
ATOM    407  N   VAL A  61      69.220  53.183  58.723  1.00 33.99           N  
ATOM    408  CA  VAL A  61      68.542  53.909  59.818  1.00 33.12           C  
ATOM    409  C   VAL A  61      69.510  54.036  60.980  1.00 35.56           C  
ATOM    410  O   VAL A  61      70.024  53.013  61.473  1.00 33.36           O  
ATOM    411  CB  VAL A  61      67.292  53.184  60.333  1.00 35.55           C  
ATOM    412  CG1 VAL A  61      66.653  53.980  61.482  1.00 35.25           C  
ATOM    413  CG2 VAL A  61      66.265  52.962  59.193  1.00 37.36           C  
ATOM    414  N   VAL A  62      69.733  55.267  61.427  1.00 33.73           N  
ATOM    415  CA  VAL A  62      70.593  55.505  62.584  1.00 35.11           C  
ATOM    416  C   VAL A  62      69.782  55.069  63.795  1.00 36.93           C  
ATOM    417  O   VAL A  62      68.640  55.528  63.998  1.00 36.68           O  
ATOM    418  CB  VAL A  62      71.007  56.965  62.728  1.00 37.10           C  
ATOM    419  CG1 VAL A  62      71.767  57.180  64.038  1.00 40.56           C  
ATOM    420  CG2 VAL A  62      71.852  57.435  61.498  1.00 36.47           C  
ATOM    421  N   CYS A  63      70.347  54.156  64.570  1.00 37.42           N  
ATOM    422  CA  CYS A  63      69.691  53.652  65.776  1.00 36.37           C  
ATOM    423  C   CYS A  63      70.735  53.152  66.756  1.00 39.12           C  
ATOM    424  O   CYS A  63      71.480  52.229  66.459  1.00 40.02           O  
ATOM    425  CB  CYS A  63      68.696  52.541  65.438  1.00 37.11           C  
ATOM    426  SG  CYS A  63      67.838  51.853  66.877  1.00 38.95           S  
ATOM    427  N   ASP A  64      70.824  53.824  67.899  1.00 35.35           N  
ATOM    428  CA  ASP A  64      71.587  53.333  69.024  1.00 34.59           C  
ATOM    429  C   ASP A  64      70.619  52.507  69.866  1.00 31.40           C  
ATOM    430  O   ASP A  64      69.752  53.063  70.573  1.00 34.31           O  
ATOM    431  CB  ASP A  64      72.179  54.511  69.808  1.00 34.34           C  
ATOM    432  CG  ASP A  64      72.802  54.095  71.131  1.00 39.22           C  
ATOM    433  OD1 ASP A  64      72.801  52.880  71.443  1.00 40.17           O  
ATOM    434  OD2 ASP A  64      73.271  55.014  71.850  1.00 41.70           O  
ATOM    435  N   SER A  65      70.743  51.176  69.784  1.00 34.65           N  
ATOM    436  CA  SER A  65      69.724  50.303  70.350  1.00 37.51           C  
ATOM    437  C   SER A  65      69.800  50.226  71.887  1.00 38.14           C  
ATOM    438  O   SER A  65      69.008  49.530  72.510  1.00 40.03           O  
ATOM    439  CB  SER A  65      69.831  48.921  69.734  1.00 38.98           C  
ATOM    440  OG  SER A  65      71.056  48.349  70.070  1.00 39.08           O  
ATOM    441  N   SER A  66      70.779  50.904  72.468  1.00 34.93           N  
ATOM    442  CA  SER A  66      70.840  51.107  73.932  1.00 36.32           C  
ATOM    443  C   SER A  66      69.804  52.130  74.366  1.00 40.82           C  
ATOM    444  O   SER A  66      69.541  52.298  75.557  1.00 41.77           O  
ATOM    445  CB  SER A  66      72.247  51.558  74.383  1.00 39.57           C  
ATOM    446  OG  SER A  66      72.498  52.953  74.190  1.00 35.36           O  
ATOM    447  N   GLN A  67      69.267  52.854  73.391  1.00 36.77           N  
ATOM    448  CA  GLN A  67      68.227  53.845  73.616  1.00 38.82           C  
ATOM    449  C   GLN A  67      66.895  53.325  73.114  1.00 38.66           C  
ATOM    450  O   GLN A  67      66.653  53.237  71.910  1.00 36.32           O  
ATOM    451  CB  GLN A  67      68.598  55.161  72.910  1.00 40.07           C  
ATOM    452  CG  GLN A  67      69.994  55.658  73.241  1.00 41.99           C  
ATOM    453  CD  GLN A  67      70.177  55.948  74.726  1.00 44.97           C  
ATOM    454  OE1 GLN A  67      69.387  56.681  75.318  1.00 43.01           O  
ATOM    455  NE2 GLN A  67      71.232  55.376  75.332  1.00 49.63           N  
ATOM    456  N   GLU A  68      66.021  52.983  74.060  1.00 35.82           N  
ATOM    457  CA  GLU A  68      64.726  52.418  73.718  1.00 39.10           C  
ATOM    458  C   GLU A  68      63.917  53.303  72.753  1.00 36.80           C  
ATOM    459  O   GLU A  68      63.276  52.797  71.842  1.00 35.10           O  
ATOM    460  CB  GLU A  68      63.907  52.134  74.973  1.00 39.61           C  
ATOM    461  CG  GLU A  68      62.691  51.286  74.646  1.00 44.51           C  
ATOM    462  CD  GLU A  68      61.536  51.510  75.560  1.00 51.37           C  
ATOM    463  OE1 GLU A  68      61.768  51.850  76.735  1.00 47.95           O  
ATOM    464  OE2 GLU A  68      60.397  51.325  75.094  1.00 50.34           O  
ATOM    465  N   SER A  69      63.964  54.620  72.923  1.00 36.35           N  
ATOM    466  CA  SER A  69      63.200  55.531  72.047  1.00 37.31           C  
ATOM    467  C   SER A  69      63.681  55.479  70.589  1.00 35.36           C  
ATOM    468  O   SER A  69      62.881  55.594  69.641  1.00 34.03           O  
ATOM    469  CB  SER A  69      63.259  56.960  72.591  1.00 38.33           C  
ATOM    470  OG  SER A  69      64.581  57.431  72.590  1.00 38.48           O  
ATOM    471  N   GLU A  70      64.978  55.228  70.399  1.00 32.65           N  
ATOM    472  CA  GLU A  70      65.520  55.061  69.040  1.00 31.35           C  
ATOM    473  C   GLU A  70      65.056  53.762  68.371  1.00 31.92           C  
ATOM    474  O   GLU A  70      64.846  53.713  67.163  1.00 32.06           O  
ATOM    475  CB  GLU A  70      67.038  55.170  69.054  1.00 33.32           C  
ATOM    476  CG  GLU A  70      67.478  56.546  69.579  1.00 38.81           C  
ATOM    477  CD  GLU A  70      68.948  56.856  69.336  1.00 43.18           C  
ATOM    478  OE1 GLU A  70      69.506  56.426  68.316  1.00 42.27           O  
ATOM    479  OE2 GLU A  70      69.550  57.552  70.172  1.00 47.32           O  
ATOM    480  N   VAL A  71      64.917  52.707  69.156  1.00 32.22           N  
ATOM    481  CA  VAL A  71      64.453  51.421  68.663  1.00 34.03           C  
ATOM    482  C   VAL A  71      62.971  51.574  68.291  1.00 34.82           C  
ATOM    483  O   VAL A  71      62.520  51.138  67.212  1.00 32.96           O  
ATOM    484  CB  VAL A  71      64.651  50.300  69.710  1.00 31.71           C  
ATOM    485  CG1 VAL A  71      64.139  48.954  69.160  1.00 36.13           C  
ATOM    486  CG2 VAL A  71      66.128  50.116  70.095  1.00 32.34           C  
ATOM    487  N   ARG A  72      62.194  52.189  69.177  1.00 34.42           N  
ATOM    488  CA  ARG A  72      60.795  52.478  68.839  1.00 35.57           C  
ATOM    489  C   ARG A  72      60.670  53.227  67.508  1.00 34.24           C  
ATOM    490  O   ARG A  72      59.865  52.848  66.641  1.00 35.22           O  
ATOM    491  CB  ARG A  72      60.105  53.267  69.953  1.00 36.85           C  
ATOM    492  CG  ARG A  72      58.581  53.368  69.738  1.00 42.22           C  
ATOM    493  CD  ARG A  72      57.971  54.351  70.669  1.00 44.69           C  
ATOM    494  NE  ARG A  72      58.095  53.961  72.073  1.00 51.82           N  
ATOM    495  CZ  ARG A  72      57.210  53.219  72.750  1.00 53.22           C  
ATOM    496  NH1 ARG A  72      56.134  52.705  72.157  1.00 53.57           N  
ATOM    497  NH2 ARG A  72      57.429  52.960  74.035  1.00 53.27           N  
ATOM    498  N   SER A  73      61.497  54.252  67.349  1.00 33.01           N  
ATOM    499  CA  SER A  73      61.532  55.091  66.133  1.00 37.33           C  
ATOM    500  C   SER A  73      61.861  54.288  64.873  1.00 36.95           C  
ATOM    501  O   SER A  73      61.228  54.473  63.824  1.00 36.23           O  
ATOM    502  CB  SER A  73      62.543  56.216  66.317  1.00 35.95           C  
ATOM    503  OG  SER A  73      62.731  56.907  65.103  1.00 52.09           O  
ATOM    504  N   LEU A  74      62.847  53.390  64.996  1.00 34.88           N  
ATOM    505  CA  LEU A  74      63.216  52.462  63.935  1.00 31.32           C  
ATOM    506  C   LEU A  74      62.011  51.660  63.482  1.00 33.01           C  
ATOM    507  O   LEU A  74      61.697  51.625  62.302  1.00 32.08           O  
ATOM    508  CB  LEU A  74      64.323  51.521  64.409  1.00 31.85           C  
ATOM    509  CG  LEU A  74      64.627  50.240  63.629  1.00 33.02           C  
ATOM    510  CD1 LEU A  74      65.061  50.571  62.179  1.00 36.26           C  
ATOM    511  CD2 LEU A  74      65.692  49.462  64.380  1.00 28.95           C  
ATOM    512  N   PHE A  75      61.336  51.001  64.417  1.00 33.21           N  
ATOM    513  CA  PHE A  75      60.232  50.128  64.020  1.00 37.80           C  
ATOM    514  C   PHE A  75      58.970  50.872  63.603  1.00 34.27           C  
ATOM    515  O   PHE A  75      58.192  50.356  62.793  1.00 34.43           O  
ATOM    516  CB  PHE A  75      59.975  49.060  65.084  1.00 33.28           C  
ATOM    517  CG  PHE A  75      61.070  47.995  65.114  1.00 33.67           C  
ATOM    518  CD1 PHE A  75      61.024  46.901  64.236  1.00 32.39           C  
ATOM    519  CD2 PHE A  75      62.153  48.124  65.947  1.00 34.17           C  
ATOM    520  CE1 PHE A  75      62.033  45.961  64.218  1.00 31.50           C  
ATOM    521  CE2 PHE A  75      63.185  47.165  65.950  1.00 32.87           C  
ATOM    522  CZ  PHE A  75      63.116  46.086  65.088  1.00 34.32           C  
ATOM    523  N   GLU A  76      58.797  52.093  64.104  1.00 34.63           N  
ATOM    524  CA  GLU A  76      57.751  52.985  63.593  1.00 39.87           C  
ATOM    525  C   GLU A  76      57.986  53.290  62.120  1.00 36.45           C  
ATOM    526  O   GLU A  76      57.037  53.290  61.343  1.00 35.35           O  
ATOM    527  CB  GLU A  76      57.671  54.289  64.399  1.00 38.11           C  
ATOM    528  CG  GLU A  76      56.996  54.041  65.758  1.00 45.62           C  
ATOM    529  CD  GLU A  76      57.111  55.215  66.735  1.00 49.64           C  
ATOM    530  OE1 GLU A  76      57.958  56.116  66.511  1.00 59.82           O  
ATOM    531  OE2 GLU A  76      56.350  55.211  67.734  1.00 52.93           O  
ATOM    532  N   GLN A  77      59.245  53.514  61.742  1.00 34.62           N  
ATOM    533  CA  GLN A  77      59.573  53.811  60.344  1.00 35.79           C  
ATOM    534  C   GLN A  77      59.221  52.636  59.454  1.00 32.41           C  
ATOM    535  O   GLN A  77      58.616  52.812  58.393  1.00 32.80           O  
ATOM    536  CB  GLN A  77      61.052  54.166  60.181  1.00 35.67           C  
ATOM    537  CG  GLN A  77      61.448  54.529  58.747  1.00 35.88           C  
ATOM    538  CD  GLN A  77      62.892  54.988  58.581  1.00 37.27           C  
ATOM    539  OE1 GLN A  77      63.604  55.278  59.568  1.00 37.87           O  
ATOM    540  NE2 GLN A  77      63.341  55.049  57.328  1.00 37.28           N  
ATOM    541  N   VAL A  78      59.657  51.443  59.866  1.00 35.03           N  
ATOM    542  CA  VAL A  78      59.381  50.204  59.152  1.00 33.50           C  
ATOM    543  C   VAL A  78      57.880  50.028  58.976  1.00 34.45           C  
ATOM    544  O   VAL A  78      57.410  49.773  57.869  1.00 32.49           O  
ATOM    545  CB  VAL A  78      59.960  48.952  59.881  1.00 34.35           C  
ATOM    546  CG1 VAL A  78      59.535  47.680  59.164  1.00 31.12           C  
ATOM    547  CG2 VAL A  78      61.511  49.023  59.958  1.00 32.79           C  
ATOM    548  N   ASP A  79      57.135  50.189  60.066  1.00 35.89           N  
ATOM    549  CA  ASP A  79      55.681  50.074  60.045  1.00 34.79           C  
ATOM    550  C   ASP A  79      55.060  51.048  59.042  1.00 35.92           C  
ATOM    551  O   ASP A  79      54.220  50.675  58.214  1.00 35.44           O  
ATOM    552  CB  ASP A  79      55.167  50.351  61.450  1.00 37.88           C  
ATOM    553  CG  ASP A  79      53.680  50.044  61.633  1.00 47.60           C  
ATOM    554  OD1 ASP A  79      53.057  49.350  60.808  1.00 36.97           O  
ATOM    555  OD2 ASP A  79      53.154  50.467  62.671  1.00 49.11           O  
ATOM    556  N   ARG A  80      55.488  52.303  59.128  1.00 38.28           N  
ATOM    557  CA  ARG A  80      55.005  53.362  58.254  1.00 38.01           C  
ATOM    558  C   ARG A  80      55.332  53.055  56.802  1.00 34.97           C  
ATOM    559  O   ARG A  80      54.454  53.056  55.954  1.00 33.30           O  
ATOM    560  CB  ARG A  80      55.657  54.678  58.665  1.00 39.81           C  
ATOM    561  CG  ARG A  80      55.271  55.883  57.852  1.00 47.03           C  
ATOM    562  CD  ARG A  80      55.830  57.163  58.496  1.00 54.63           C  
ATOM    563  NE  ARG A  80      57.286  57.283  58.345  1.00 57.61           N  
ATOM    564  CZ  ARG A  80      58.202  57.251  59.326  1.00 63.00           C  
ATOM    565  NH1 ARG A  80      57.875  57.108  60.614  1.00 60.02           N  
ATOM    566  NH2 ARG A  80      59.486  57.375  59.006  1.00 66.24           N  
ATOM    567  N   GLU A  81      56.597  52.765  56.516  1.00 32.08           N  
ATOM    568  CA  GLU A  81      57.029  52.616  55.134  1.00 35.20           C  
ATOM    569  C   GLU A  81      56.540  51.315  54.507  1.00 34.19           C  
ATOM    570  O   GLU A  81      56.324  51.282  53.304  1.00 35.01           O  
ATOM    571  CB  GLU A  81      58.550  52.707  54.988  1.00 36.31           C  
ATOM    572  CG  GLU A  81      59.138  54.045  55.368  1.00 37.20           C  
ATOM    573  CD  GLU A  81      60.658  54.121  55.142  1.00 42.55           C  
ATOM    574  OE1 GLU A  81      61.276  53.120  54.715  1.00 41.16           O  
ATOM    575  OE2 GLU A  81      61.230  55.202  55.383  1.00 51.18           O  
ATOM    576  N   GLN A  82      56.418  50.245  55.288  1.00 33.16           N  
ATOM    577  CA  GLN A  82      56.059  48.938  54.749  1.00 31.28           C  
ATOM    578  C   GLN A  82      54.641  48.488  55.097  1.00 32.89           C  
ATOM    579  O   GLN A  82      54.316  47.306  54.951  1.00 35.77           O  
ATOM    580  CB  GLN A  82      57.072  47.893  55.240  1.00 34.78           C  
ATOM    581  CG  GLN A  82      58.509  48.266  54.901  1.00 34.04           C  
ATOM    582  CD  GLN A  82      58.761  48.334  53.419  1.00 40.96           C  
ATOM    583  OE1 GLN A  82      58.064  47.690  52.622  1.00 36.87           O  
ATOM    584  NE2 GLN A  82      59.753  49.123  53.028  1.00 36.43           N  
ATOM    585  N   GLN A  83      53.808  49.417  55.562  1.00 33.51           N  
ATOM    586  CA  GLN A  83      52.428  49.111  55.982  1.00 33.62           C  
ATOM    587  C   GLN A  83      52.376  47.939  56.972  1.00 35.60           C  
ATOM    588  O   GLN A  83      51.592  47.004  56.816  1.00 35.97           O  
ATOM    589  CB  GLN A  83      51.513  48.836  54.772  1.00 34.65           C  
ATOM    590  CG  GLN A  83      51.377  50.022  53.854  1.00 34.39           C  
ATOM    591  CD  GLN A  83      50.907  51.262  54.590  1.00 39.76           C  
ATOM    592  OE1 GLN A  83      49.949  51.210  55.354  1.00 39.40           O  
ATOM    593  NE2 GLN A  83      51.578  52.370  54.370  1.00 40.47           N  
ATOM    594  N   GLY A  84      53.263  47.981  57.967  1.00 35.87           N  
ATOM    595  CA  GLY A  84      53.238  47.023  59.066  1.00 35.62           C  
ATOM    596  C   GLY A  84      53.938  45.699  58.818  1.00 36.46           C  
ATOM    597  O   GLY A  84      53.909  44.816  59.695  1.00 34.37           O  
ATOM    598  N   ARG A  85      54.552  45.543  57.641  1.00 33.33           N  
ATOM    599  CA  ARG A  85      55.151  44.243  57.281  1.00 36.49           C  
ATOM    600  C   ARG A  85      56.594  44.122  57.788  1.00 36.67           C  
ATOM    601  O   ARG A  85      57.447  44.994  57.494  1.00 33.82           O  
ATOM    602  CB  ARG A  85      55.118  44.003  55.767  1.00 34.07           C  
ATOM    603  CG  ARG A  85      55.693  42.644  55.410  1.00 39.88           C  
ATOM    604  CD  ARG A  85      55.478  42.194  53.973  1.00 41.88           C  
ATOM    605  NE  ARG A  85      55.985  40.822  53.870  1.00 41.75           N  
ATOM    606  CZ  ARG A  85      55.582  39.898  53.001  1.00 41.80           C  
ATOM    607  NH1 ARG A  85      54.630  40.149  52.123  1.00 43.60           N  
ATOM    608  NH2 ARG A  85      56.126  38.685  53.043  1.00 43.72           N  
ATOM    609  N   LEU A  86      56.867  43.043  58.524  1.00 30.74           N  
ATOM    610  CA  LEU A  86      58.233  42.686  58.915  1.00 30.25           C  
ATOM    611  C   LEU A  86      58.384  41.165  58.890  1.00 33.27           C  
ATOM    612  O   LEU A  86      57.675  40.481  59.636  1.00 32.82           O  
ATOM    613  CB  LEU A  86      58.560  43.189  60.320  1.00 31.07           C  
ATOM    614  CG  LEU A  86      59.988  42.881  60.799  1.00 29.90           C  
ATOM    615  CD1 LEU A  86      61.065  43.528  59.945  1.00 30.54           C  
ATOM    616  CD2 LEU A  86      60.151  43.287  62.316  1.00 30.64           C  
ATOM    617  N   ASP A  87      59.302  40.660  58.062  1.00 29.85           N  
ATOM    618  CA  ASP A  87      59.479  39.216  57.865  1.00 30.21           C  
ATOM    619  C   ASP A  87      60.651  38.660  58.679  1.00 32.16           C  
ATOM    620  O   ASP A  87      60.596  37.529  59.157  1.00 32.43           O  
ATOM    621  CB  ASP A  87      59.724  38.896  56.390  1.00 31.50           C  
ATOM    622  CG  ASP A  87      58.541  39.257  55.530  1.00 36.00           C  
ATOM    623  OD1 ASP A  87      57.517  38.562  55.638  1.00 34.81           O  
ATOM    624  OD2 ASP A  87      58.591  40.279  54.841  1.00 33.54           O  
ATOM    625  N   VAL A  88      61.727  39.422  58.739  1.00 31.73           N  
ATOM    626  CA  VAL A  88      62.961  38.955  59.381  1.00 31.39           C  
ATOM    627  C   VAL A  88      63.587  40.065  60.236  1.00 33.51           C  
ATOM    628  O   VAL A  88      63.763  41.185  59.780  1.00 31.86           O  
ATOM    629  CB  VAL A  88      64.020  38.457  58.349  1.00 34.54           C  
ATOM    630  CG1 VAL A  88      65.306  38.014  59.087  1.00 38.71           C  
ATOM    631  CG2 VAL A  88      63.489  37.296  57.459  1.00 29.95           C  
ATOM    632  N   LEU A  89      63.944  39.721  61.478  1.00 32.47           N  
ATOM    633  CA  LEU A  89      64.755  40.561  62.316  1.00 31.98           C  
ATOM    634  C   LEU A  89      66.014  39.820  62.703  1.00 31.55           C  
ATOM    635  O   LEU A  89      65.937  38.730  63.262  1.00 33.10           O  
ATOM    636  CB  LEU A  89      63.994  40.999  63.575  1.00 31.77           C  
ATOM    637  CG  LEU A  89      64.887  41.627  64.655  1.00 32.70           C  
ATOM    638  CD1 LEU A  89      65.580  42.929  64.168  1.00 32.28           C  
ATOM    639  CD2 LEU A  89      64.024  41.865  65.912  1.00 35.21           C  
ATOM    640  N   VAL A  90      67.175  40.381  62.351  1.00 28.30           N  
ATOM    641  CA  VAL A  90      68.436  39.815  62.784  1.00 30.70           C  
ATOM    642  C   VAL A  90      69.027  40.690  63.857  1.00 33.61           C  
ATOM    643  O   VAL A  90      69.422  41.821  63.588  1.00 31.56           O  
ATOM    644  CB  VAL A  90      69.462  39.680  61.611  1.00 32.28           C  
ATOM    645  CG1 VAL A  90      70.793  39.197  62.131  1.00 35.04           C  
ATOM    646  CG2 VAL A  90      68.923  38.756  60.513  1.00 31.78           C  
ATOM    647  N   ASN A  91      69.058  40.156  65.067  1.00 31.54           N  
ATOM    648  CA  ASN A  91      69.648  40.810  66.219  1.00 33.74           C  
ATOM    649  C   ASN A  91      71.127  40.467  66.268  1.00 35.58           C  
ATOM    650  O   ASN A  91      71.511  39.369  66.653  1.00 35.00           O  
ATOM    651  CB  ASN A  91      68.993  40.315  67.506  1.00 33.82           C  
ATOM    652  CG  ASN A  91      67.549  40.758  67.656  1.00 36.14           C  
ATOM    653  OD1 ASN A  91      66.660  39.927  67.892  1.00 45.07           O  
ATOM    654  ND2 ASN A  91      67.307  42.019  67.545  1.00 32.10           N  
ATOM    655  N   ASN A  92      71.952  41.411  65.864  1.00 32.23           N  
ATOM    656  CA  ASN A  92      73.381  41.173  65.736  1.00 34.08           C  
ATOM    657  C   ASN A  92      74.106  42.345  66.336  1.00 36.40           C  
ATOM    658  O   ASN A  92      73.673  43.480  66.157  1.00 34.77           O  
ATOM    659  CB  ASN A  92      73.736  41.038  64.249  1.00 34.86           C  
ATOM    660  CG  ASN A  92      75.208  41.196  63.974  1.00 35.75           C  
ATOM    661  OD1 ASN A  92      75.672  42.270  63.546  1.00 39.12           O  
ATOM    662  ND2 ASN A  92      75.965  40.144  64.261  1.00 30.83           N  
ATOM    663  N   ALA A  93      75.226  42.092  67.009  1.00 35.82           N  
ATOM    664  CA  ALA A  93      75.991  43.203  67.597  1.00 39.52           C  
ATOM    665  C   ALA A  93      77.475  42.890  67.603  1.00 39.48           C  
ATOM    666  O   ALA A  93      77.888  41.792  67.982  1.00 41.13           O  
ATOM    667  CB  ALA A  93      75.498  43.550  69.017  1.00 40.07           C  
ATOM    668  N   TYR A  94      78.245  43.864  67.133  1.00 38.29           N  
ATOM    669  CA  TYR A  94      79.714  43.853  67.238  1.00 39.88           C  
ATOM    670  C   TYR A  94      80.208  44.792  68.348  1.00 40.32           C  
ATOM    671  O   TYR A  94      81.390  44.780  68.681  1.00 41.26           O  
ATOM    672  CB  TYR A  94      80.354  44.243  65.896  1.00 39.29           C  
ATOM    673  CG  TYR A  94      79.984  45.601  65.368  1.00 38.66           C  
ATOM    674  CD1 TYR A  94      80.685  46.740  65.756  1.00 45.43           C  
ATOM    675  CD2 TYR A  94      78.949  45.751  64.448  1.00 40.15           C  
ATOM    676  CE1 TYR A  94      80.344  48.001  65.250  1.00 41.32           C  
ATOM    677  CE2 TYR A  94      78.618  46.979  63.930  1.00 40.84           C  
ATOM    678  CZ  TYR A  94      79.296  48.105  64.346  1.00 41.81           C  
ATOM    679  OH  TYR A  94      78.926  49.320  63.843  1.00 44.95           O  
ATOM    680  N   ALA A  95      79.299  45.608  68.878  1.00 43.79           N  
ATOM    681  CA  ALA A  95      79.538  46.456  70.052  1.00 45.53           C  
ATOM    682  C   ALA A  95      80.238  45.676  71.158  1.00 45.99           C  
ATOM    683  O   ALA A  95      79.750  44.620  71.585  1.00 45.82           O  
ATOM    684  CB  ALA A  95      78.212  46.981  70.565  1.00 48.98           C  
ATOM    685  N   GLY A  96      81.392  46.157  71.589  1.00 45.71           N  
ATOM    686  CA  GLY A  96      82.149  45.489  72.635  1.00 43.98           C  
ATOM    687  C   GLY A  96      83.224  44.479  72.265  1.00 39.95           C  
ATOM    688  O   GLY A  96      84.054  44.135  73.112  1.00 38.81           O  
ATOM    689  N   VAL A  97      83.218  43.976  71.036  1.00 38.99           N  
ATOM    690  CA  VAL A  97      84.193  42.955  70.641  1.00 40.82           C  
ATOM    691  C   VAL A  97      85.621  43.544  70.726  1.00 36.03           C  
ATOM    692  O   VAL A  97      86.568  42.912  71.223  1.00 36.02           O  
ATOM    693  CB  VAL A  97      83.909  42.423  69.232  1.00 43.23           C  
ATOM    694  CG1 VAL A  97      85.055  41.546  68.743  1.00 43.80           C  
ATOM    695  CG2 VAL A  97      82.594  41.669  69.225  1.00 53.70           C  
ATOM    696  N   GLN A  98      85.768  44.776  70.266  1.00 33.06           N  
ATOM    697  CA  GLN A  98      87.097  45.425  70.348  1.00 34.44           C  
ATOM    698  C   GLN A  98      87.562  45.550  71.807  1.00 32.63           C  
ATOM    699  O   GLN A  98      88.737  45.306  72.139  1.00 33.84           O  
ATOM    700  CB  GLN A  98      87.096  46.788  69.662  1.00 39.68           C  
ATOM    701  CG  GLN A  98      88.499  47.360  69.542  1.00 37.08           C  
ATOM    702  CD  GLN A  98      89.421  46.477  68.723  1.00 36.41           C  
ATOM    703  OE1 GLN A  98      89.083  46.089  67.610  1.00 36.46           O  
ATOM    704  NE2 GLN A  98      90.609  46.162  69.272  1.00 37.31           N  
ATOM    705  N   THR A  99      86.636  45.877  72.705  1.00 36.06           N  
ATOM    706  CA  THR A  99      86.951  45.924  74.159  1.00 37.36           C  
ATOM    707  C   THR A  99      87.416  44.579  74.691  1.00 38.92           C  
ATOM    708  O   THR A  99      88.366  44.520  75.466  1.00 40.53           O  
ATOM    709  CB  THR A  99      85.727  46.359  74.996  1.00 42.82           C  
ATOM    710  OG1 THR A  99      85.220  47.597  74.474  1.00 41.17           O  
ATOM    711  CG2 THR A  99      86.098  46.510  76.464  1.00 44.15           C  
ATOM    712  N   ILE A 100      86.752  43.512  74.256  1.00 39.09           N  
ATOM    713  CA  ILE A 100      87.152  42.139  74.613  1.00 40.60           C  
ATOM    714  C   ILE A 100      88.608  41.922  74.206  1.00 38.31           C  
ATOM    715  O   ILE A 100      89.460  41.538  75.027  1.00 38.41           O  
ATOM    716  CB  ILE A 100      86.213  41.073  73.969  1.00 42.64           C  
ATOM    717  CG1 ILE A 100      84.824  41.155  74.603  1.00 38.01           C  
ATOM    718  CG2 ILE A 100      86.751  39.610  74.170  1.00 40.81           C  
ATOM    719  CD1 ILE A 100      83.767  40.406  73.838  1.00 41.63           C  
ATOM    720  N   LEU A 101      88.901  42.258  72.954  1.00 40.66           N  
ATOM    721  CA  LEU A 101      90.243  42.129  72.420  1.00 42.03           C  
ATOM    722  C   LEU A 101      91.249  42.901  73.249  1.00 40.14           C  
ATOM    723  O   LEU A 101      92.271  42.367  73.625  1.00 45.68           O  
ATOM    724  CB  LEU A 101      90.283  42.619  70.966  1.00 43.40           C  
ATOM    725  CG  LEU A 101      89.665  41.694  69.919  1.00 47.92           C  
ATOM    726  CD1 LEU A 101      89.578  42.371  68.557  1.00 44.95           C  
ATOM    727  CD2 LEU A 101      90.483  40.415  69.833  1.00 48.00           C  
ATOM    728  N   ASN A 102      90.954  44.170  73.540  1.00 33.64           N  
ATOM    729  CA  ASN A 102      91.909  45.026  74.230  1.00 32.99           C  
ATOM    730  C   ASN A 102      92.245  44.571  75.640  1.00 33.28           C  
ATOM    731  O   ASN A 102      93.342  44.825  76.119  1.00 36.37           O  
ATOM    732  CB  ASN A 102      91.436  46.477  74.234  1.00 34.30           C  
ATOM    733  CG  ASN A 102      91.334  47.039  72.836  1.00 33.36           C  
ATOM    734  OD1 ASN A 102      91.902  46.469  71.909  1.00 35.29           O  
ATOM    735  ND2 ASN A 102      90.608  48.130  72.677  1.00 31.64           N  
ATOM    736  N   THR A 103      91.319  43.874  76.276  1.00 39.58           N  
ATOM    737  CA  THR A 103      91.465  43.494  77.669  1.00 41.42           C  
ATOM    738  C   THR A 103      91.800  42.000  77.795  1.00 46.54           C  
ATOM    739  O   THR A 103      91.623  41.403  78.863  1.00 46.33           O  
ATOM    740  CB  THR A 103      90.173  43.825  78.458  1.00 41.86           C  
ATOM    741  OG1 THR A 103      89.066  43.110  77.901  1.00 36.04           O  
ATOM    742  CG2 THR A 103      89.873  45.328  78.400  1.00 42.69           C  
ATOM    743  N   ARG A 104      92.296  41.403  76.711  1.00 49.98           N  
ATOM    744  CA  ARG A 104      92.637  39.978  76.701  1.00 51.32           C  
ATOM    745  C   ARG A 104      93.444  39.668  77.939  1.00 49.28           C  
ATOM    746  O   ARG A 104      94.322  40.451  78.332  1.00 48.16           O  
ATOM    747  CB  ARG A 104      93.454  39.600  75.457  1.00 51.25           C  
ATOM    748  N   ASN A 105      93.118  38.548  78.569  1.00 45.59           N  
ATOM    749  CA  ASN A 105      93.841  38.079  79.741  1.00 50.08           C  
ATOM    750  C   ASN A 105      93.818  39.057  80.930  1.00 47.96           C  
ATOM    751  O   ASN A 105      94.722  39.050  81.758  1.00 50.12           O  
ATOM    752  CB  ASN A 105      95.280  37.694  79.363  1.00 54.08           C  
ATOM    753  CG  ASN A 105      95.341  36.744  78.152  1.00 62.09           C  
ATOM    754  OD1 ASN A 105      95.893  37.092  77.105  1.00 76.57           O  
ATOM    755  ND2 ASN A 105      94.747  35.554  78.289  1.00 63.69           N  
ATOM    756  N   LYS A 106      92.788  39.899  81.019  1.00 41.56           N  
ATOM    757  CA  LYS A 106      92.552  40.634  82.269  1.00 39.58           C  
ATOM    758  C   LYS A 106      91.275  40.083  82.853  1.00 34.72           C  
ATOM    759  O   LYS A 106      90.299  39.872  82.119  1.00 37.13           O  
ATOM    760  CB  LYS A 106      92.414  42.136  82.042  1.00 42.08           C  
ATOM    761  CG  LYS A 106      93.693  42.809  81.509  1.00 50.24           C  
ATOM    762  N   ALA A 107      91.283  39.848  84.156  1.00 33.65           N  
ATOM    763  CA  ALA A 107      90.152  39.214  84.837  1.00 32.73           C  
ATOM    764  C   ALA A 107      89.056  40.231  85.067  1.00 31.24           C  
ATOM    765  O   ALA A 107      89.300  41.448  85.020  1.00 33.36           O  
ATOM    766  CB  ALA A 107      90.596  38.599  86.180  1.00 33.40           C  
ATOM    767  N   PHE A 108      87.848  39.742  85.355  1.00 31.26           N  
ATOM    768  CA  PHE A 108      86.683  40.631  85.455  1.00 33.77           C  
ATOM    769  C   PHE A 108      86.821  41.707  86.544  1.00 31.79           C  
ATOM    770  O   PHE A 108      86.233  42.786  86.440  1.00 32.97           O  
ATOM    771  CB  PHE A 108      85.378  39.835  85.624  1.00 31.54           C  
ATOM    772  CG  PHE A 108      85.160  39.266  87.006  1.00 33.05           C  
ATOM    773  CD1 PHE A 108      84.502  40.009  87.977  1.00 34.67           C  
ATOM    774  CD2 PHE A 108      85.565  37.959  87.322  1.00 28.48           C  
ATOM    775  CE1 PHE A 108      84.293  39.471  89.254  1.00 33.01           C  
ATOM    776  CE2 PHE A 108      85.335  37.417  88.578  1.00 32.28           C  
ATOM    777  CZ  PHE A 108      84.723  38.168  89.548  1.00 35.21           C  
ATOM    778  N   TRP A 109      87.573  41.423  87.595  1.00 28.01           N  
ATOM    779  CA  TRP A 109      87.814  42.438  88.636  1.00 31.29           C  
ATOM    780  C   TRP A 109      88.949  43.408  88.286  1.00 33.73           C  
ATOM    781  O   TRP A 109      89.143  44.408  88.969  1.00 33.73           O  
ATOM    782  CB  TRP A 109      88.066  41.780  90.006  1.00 31.05           C  
ATOM    783  CG  TRP A 109      89.289  40.969  90.052  1.00 34.30           C  
ATOM    784  CD1 TRP A 109      90.525  41.384  90.409  1.00 36.16           C  
ATOM    785  CD2 TRP A 109      89.404  39.586  89.710  1.00 32.61           C  
ATOM    786  NE1 TRP A 109      91.412  40.352  90.310  1.00 35.58           N  
ATOM    787  CE2 TRP A 109      90.752  39.225  89.910  1.00 35.14           C  
ATOM    788  CE3 TRP A 109      88.492  38.612  89.292  1.00 36.72           C  
ATOM    789  CZ2 TRP A 109      91.237  37.930  89.667  1.00 37.42           C  
ATOM    790  CZ3 TRP A 109      88.969  37.313  89.055  1.00 33.73           C  
ATOM    791  CH2 TRP A 109      90.334  36.992  89.245  1.00 35.51           C  
ATOM    792  N   GLU A 110      89.715  43.088  87.253  1.00 31.56           N  
ATOM    793  CA  GLU A 110      90.833  43.927  86.813  1.00 34.08           C  
ATOM    794  C   GLU A 110      90.346  44.979  85.829  1.00 34.04           C  
ATOM    795  O   GLU A 110      90.840  46.102  85.812  1.00 36.44           O  
ATOM    796  CB  GLU A 110      91.948  43.066  86.208  1.00 33.05           C  
ATOM    797  CG  GLU A 110      92.643  42.261  87.263  1.00 38.77           C  
ATOM    798  CD  GLU A 110      93.657  41.244  86.750  1.00 41.20           C  
ATOM    799  OE1 GLU A 110      93.511  40.706  85.640  1.00 37.57           O  
ATOM    800  OE2 GLU A 110      94.603  40.960  87.509  1.00 60.68           O  
ATOM    801  N   THR A 111      89.388  44.609  85.008  1.00 32.62           N  
ATOM    802  CA  THR A 111      88.775  45.526  84.057  1.00 33.86           C  
ATOM    803  C   THR A 111      87.712  46.396  84.753  1.00 35.66           C  
ATOM    804  O   THR A 111      87.231  46.053  85.834  1.00 35.59           O  
ATOM    805  CB  THR A 111      88.151  44.739  82.881  1.00 32.08           C  
ATOM    806  OG1 THR A 111      87.385  43.616  83.365  1.00 32.29           O  
ATOM    807  CG2 THR A 111      89.264  44.224  81.941  1.00 35.06           C  
ATOM    808  N   PRO A 112      87.345  47.536  84.144  1.00 35.51           N  
ATOM    809  CA  PRO A 112      86.347  48.399  84.778  1.00 33.79           C  
ATOM    810  C   PRO A 112      84.989  47.691  84.890  1.00 34.73           C  
ATOM    811  O   PRO A 112      84.636  46.866  84.045  1.00 34.53           O  
ATOM    812  CB  PRO A 112      86.230  49.586  83.800  1.00 35.16           C  
ATOM    813  CG  PRO A 112      87.479  49.558  83.019  1.00 42.49           C  
ATOM    814  CD  PRO A 112      87.804  48.099  82.868  1.00 38.09           C  
ATOM    815  N   ALA A 113      84.239  48.026  85.933  1.00 33.59           N  
ATOM    816  CA  ALA A 113      82.917  47.456  86.117  1.00 35.90           C  
ATOM    817  C   ALA A 113      82.035  47.792  84.921  1.00 33.45           C  
ATOM    818  O   ALA A 113      81.224  46.974  84.488  1.00 30.96           O  
ATOM    819  CB  ALA A 113      82.300  47.957  87.461  1.00 33.10           C  
ATOM    820  N   SER A 114      82.239  48.977  84.336  1.00 33.96           N  
ATOM    821  CA  SER A 114      81.410  49.466  83.245  1.00 33.65           C  
ATOM    822  C   SER A 114      81.624  48.670  81.941  1.00 33.65           C  
ATOM    823  O   SER A 114      80.862  48.837  80.980  1.00 34.53           O  
ATOM    824  CB  SER A 114      81.665  50.961  83.011  1.00 34.75           C  
ATOM    825  OG  SER A 114      83.022  51.168  82.623  1.00 38.12           O  
ATOM    826  N   MET A 115      82.632  47.787  81.905  1.00 34.46           N  
ATOM    827  CA  MET A 115      82.832  46.920  80.744  1.00 36.77           C  
ATOM    828  C   MET A 115      81.573  46.096  80.416  1.00 34.77           C  
ATOM    829  O   MET A 115      81.325  45.761  79.260  1.00 33.14           O  
ATOM    830  CB  MET A 115      84.062  45.999  80.916  1.00 36.46           C  
ATOM    831  CG  MET A 115      84.456  45.276  79.621  1.00 48.73           C  
ATOM    832  SD  MET A 115      85.922  44.225  79.791  1.00 46.34           S  
ATOM    833  CE  MET A 115      85.365  42.994  80.938  1.00 43.63           C  
ATOM    834  N   TRP A 116      80.765  45.788  81.426  1.00 33.60           N  
ATOM    835  CA  TRP A 116      79.490  45.139  81.198  1.00 34.52           C  
ATOM    836  C   TRP A 116      78.711  45.891  80.143  1.00 33.20           C  
ATOM    837  O   TRP A 116      78.193  45.288  79.195  1.00 36.68           O  
ATOM    838  CB  TRP A 116      78.682  45.066  82.496  1.00 32.21           C  
ATOM    839  CG  TRP A 116      77.325  44.515  82.279  1.00 31.47           C  
ATOM    840  CD1 TRP A 116      76.219  45.215  81.907  1.00 32.89           C  
ATOM    841  CD2 TRP A 116      76.929  43.148  82.358  1.00 35.18           C  
ATOM    842  NE1 TRP A 116      75.152  44.384  81.767  1.00 35.13           N  
ATOM    843  CE2 TRP A 116      75.545  43.103  82.036  1.00 32.83           C  
ATOM    844  CE3 TRP A 116      77.589  41.956  82.709  1.00 33.30           C  
ATOM    845  CZ2 TRP A 116      74.805  41.921  82.056  1.00 37.52           C  
ATOM    846  CZ3 TRP A 116      76.854  40.776  82.701  1.00 35.81           C  
ATOM    847  CH2 TRP A 116      75.471  40.764  82.369  1.00 35.39           C  
ATOM    848  N   ASP A 117      78.650  47.218  80.266  1.00 33.91           N  
ATOM    849  CA  ASP A 117      77.805  47.992  79.348  1.00 32.23           C  
ATOM    850  C   ASP A 117      78.353  48.067  77.917  1.00 35.34           C  
ATOM    851  O   ASP A 117      77.584  48.317  76.970  1.00 36.39           O  
ATOM    852  CB  ASP A 117      77.562  49.403  79.883  1.00 32.71           C  
ATOM    853  CG  ASP A 117      76.640  49.410  81.106  1.00 37.10           C  
ATOM    854  OD1 ASP A 117      75.738  48.543  81.206  1.00 37.16           O  
ATOM    855  OD2 ASP A 117      76.840  50.284  81.969  1.00 40.41           O  
ATOM    856  N   ASP A 118      79.655  47.845  77.766  1.00 34.07           N  
ATOM    857  CA  ASP A 118      80.286  47.861  76.434  1.00 36.48           C  
ATOM    858  C   ASP A 118      79.902  46.629  75.642  1.00 37.82           C  
ATOM    859  O   ASP A 118      79.950  46.651  74.410  1.00 37.39           O  
ATOM    860  CB  ASP A 118      81.806  47.907  76.543  1.00 34.87           C  
ATOM    861  CG  ASP A 118      82.309  49.190  77.170  1.00 43.10           C  
ATOM    862  OD1 ASP A 118      81.664  50.237  77.017  1.00 46.92           O  
ATOM    863  OD2 ASP A 118      83.355  49.134  77.818  1.00 51.29           O  
ATOM    864  N   ILE A 119      79.539  45.557  76.356  1.00 32.77           N  
ATOM    865  CA  ILE A 119      79.277  44.249  75.767  1.00 35.14           C  
ATOM    866  C   ILE A 119      77.781  43.865  75.808  1.00 36.59           C  
ATOM    867  O   ILE A 119      77.265  43.293  74.844  1.00 36.08           O  
ATOM    868  CB  ILE A 119      80.126  43.204  76.498  1.00 36.35           C  
ATOM    869  CG1 ILE A 119      81.605  43.507  76.261  1.00 42.09           C  
ATOM    870  CG2 ILE A 119      79.770  41.750  76.055  1.00 39.57           C  
ATOM    871  CD1 ILE A 119      82.551  42.766  77.170  1.00 43.99           C  
ATOM    872  N   ASN A 120      77.092  44.194  76.905  1.00 34.36           N  
ATOM    873  CA  ASN A 120      75.738  43.711  77.160  1.00 35.58           C  
ATOM    874  C   ASN A 120      74.674  44.784  77.189  1.00 40.76           C  
ATOM    875  O   ASN A 120      73.567  44.532  77.647  1.00 35.25           O  
ATOM    876  CB  ASN A 120      75.725  42.882  78.451  1.00 34.10           C  
ATOM    877  CG  ASN A 120      76.505  41.590  78.292  1.00 34.89           C  
ATOM    878  OD1 ASN A 120      76.490  40.995  77.214  1.00 35.60           O  
ATOM    879  ND2 ASN A 120      77.226  41.169  79.352  1.00 34.77           N  
ATOM    880  N   ASN A 121      75.003  45.985  76.708  1.00 38.61           N  
ATOM    881  CA  ASN A 121      73.969  46.984  76.485  1.00 34.41           C  
ATOM    882  C   ASN A 121      73.383  46.792  75.078  1.00 36.29           C  
ATOM    883  O   ASN A 121      72.405  46.069  74.924  1.00 34.21           O  
ATOM    884  CB  ASN A 121      74.445  48.407  76.805  1.00 34.45           C  
ATOM    885  CG  ASN A 121      73.303  49.345  77.020  1.00 33.40           C  
ATOM    886  OD1 ASN A 121      72.166  49.000  76.737  1.00 36.28           O  
ATOM    887  ND2 ASN A 121      73.582  50.523  77.524  1.00 35.93           N  
ATOM    888  N   VAL A 122      74.001  47.374  74.059  1.00 36.05           N  
ATOM    889  CA  VAL A 122      73.597  47.117  72.687  1.00 36.74           C  
ATOM    890  C   VAL A 122      73.540  45.596  72.401  1.00 36.00           C  
ATOM    891  O   VAL A 122      72.589  45.119  71.747  1.00 37.19           O  
ATOM    892  CB  VAL A 122      74.558  47.835  71.713  1.00 40.00           C  
ATOM    893  CG1 VAL A 122      74.327  47.358  70.298  1.00 40.05           C  
ATOM    894  CG2 VAL A 122      74.388  49.352  71.836  1.00 37.14           C  
ATOM    895  N   GLY A 123      74.508  44.836  72.918  1.00 36.20           N  
ATOM    896  CA  GLY A 123      74.617  43.406  72.646  1.00 36.11           C  
ATOM    897  C   GLY A 123      73.800  42.432  73.478  1.00 37.17           C  
ATOM    898  O   GLY A 123      73.975  41.210  73.371  1.00 35.69           O  
ATOM    899  N   LEU A 124      72.925  42.951  74.319  1.00 35.70           N  
ATOM    900  CA  LEU A 124      71.928  42.100  74.998  1.00 36.73           C  
ATOM    901  C   LEU A 124      70.633  42.846  75.182  1.00 33.26           C  
ATOM    902  O   LEU A 124      69.594  42.471  74.599  1.00 35.77           O  
ATOM    903  CB  LEU A 124      72.470  41.543  76.326  1.00 39.44           C  
ATOM    904  CG  LEU A 124      71.488  40.663  77.115  1.00 39.93           C  
ATOM    905  CD1 LEU A 124      71.090  39.435  76.294  1.00 35.62           C  
ATOM    906  CD2 LEU A 124      72.119  40.258  78.483  1.00 35.24           C  
ATOM    907  N   ARG A 125      70.707  43.943  75.932  1.00 35.98           N  
ATOM    908  CA  ARG A 125      69.566  44.786  76.207  1.00 37.86           C  
ATOM    909  C   ARG A 125      68.917  45.285  74.910  1.00 36.34           C  
ATOM    910  O   ARG A 125      67.694  45.212  74.762  1.00 33.47           O  
ATOM    911  CB  ARG A 125      70.028  45.934  77.097  1.00 39.09           C  
ATOM    912  CG  ARG A 125      69.012  46.861  77.577  1.00 39.39           C  
ATOM    913  CD  ARG A 125      69.613  47.690  78.683  1.00 34.25           C  
ATOM    914  NE  ARG A 125      68.725  48.783  78.979  1.00 35.15           N  
ATOM    915  CZ  ARG A 125      68.736  49.940  78.336  1.00 34.86           C  
ATOM    916  NH1 ARG A 125      69.620  50.186  77.366  1.00 36.86           N  
ATOM    917  NH2 ARG A 125      67.842  50.848  78.662  1.00 34.95           N  
ATOM    918  N   GLY A 126      69.739  45.757  73.963  1.00 34.47           N  
ATOM    919  CA  GLY A 126      69.246  46.213  72.655  1.00 34.71           C  
ATOM    920  C   GLY A 126      68.538  45.112  71.856  1.00 30.32           C  
ATOM    921  O   GLY A 126      67.545  45.372  71.148  1.00 31.96           O  
ATOM    922  N   HIS A 127      69.054  43.910  71.940  1.00 31.21           N  
ATOM    923  CA  HIS A 127      68.425  42.754  71.288  1.00 32.40           C  
ATOM    924  C   HIS A 127      67.006  42.548  71.832  1.00 32.15           C  
ATOM    925  O   HIS A 127      66.093  42.281  71.064  1.00 32.24           O  
ATOM    926  CB  HIS A 127      69.225  41.476  71.494  1.00 34.09           C  
ATOM    927  CG  HIS A 127      70.573  41.475  70.844  1.00 32.90           C  
ATOM    928  ND1 HIS A 127      70.886  42.239  69.745  1.00 34.48           N  
ATOM    929  CD2 HIS A 127      71.687  40.771  71.145  1.00 39.29           C  
ATOM    930  CE1 HIS A 127      72.141  42.005  69.396  1.00 39.16           C  
ATOM    931  NE2 HIS A 127      72.647  41.119  70.235  1.00 38.24           N  
ATOM    932  N   TYR A 128      66.827  42.689  73.145  1.00 33.21           N  
ATOM    933  CA  TYR A 128      65.485  42.579  73.749  1.00 30.88           C  
ATOM    934  C   TYR A 128      64.554  43.664  73.204  1.00 31.54           C  
ATOM    935  O   TYR A 128      63.437  43.387  72.765  1.00 31.42           O  
ATOM    936  CB  TYR A 128      65.502  42.612  75.289  1.00 33.46           C  
ATOM    937  CG  TYR A 128      64.125  42.357  75.885  1.00 33.25           C  
ATOM    938  CD1 TYR A 128      63.616  41.066  75.953  1.00 32.32           C  
ATOM    939  CD2 TYR A 128      63.312  43.407  76.328  1.00 34.96           C  
ATOM    940  CE1 TYR A 128      62.384  40.812  76.472  1.00 31.59           C  
ATOM    941  CE2 TYR A 128      62.036  43.159  76.855  1.00 32.37           C  
ATOM    942  CZ  TYR A 128      61.586  41.862  76.919  1.00 29.97           C  
ATOM    943  OH  TYR A 128      60.370  41.536  77.448  1.00 33.01           O  
ATOM    944  N   PHE A 129      65.025  44.898  73.202  1.00 32.26           N  
ATOM    945  CA  PHE A 129      64.214  45.996  72.708  1.00 32.13           C  
ATOM    946  C   PHE A 129      63.783  45.758  71.253  1.00 29.16           C  
ATOM    947  O   PHE A 129      62.580  45.914  70.908  1.00 30.56           O  
ATOM    948  CB  PHE A 129      64.959  47.325  72.799  1.00 32.32           C  
ATOM    949  CG  PHE A 129      65.218  47.822  74.199  1.00 35.51           C  
ATOM    950  CD1 PHE A 129      64.534  47.338  75.311  1.00 33.57           C  
ATOM    951  CD2 PHE A 129      66.123  48.862  74.377  1.00 31.83           C  
ATOM    952  CE1 PHE A 129      64.795  47.834  76.602  1.00 31.64           C  
ATOM    953  CE2 PHE A 129      66.402  49.365  75.666  1.00 33.08           C  
ATOM    954  CZ  PHE A 129      65.725  48.850  76.772  1.00 33.34           C  
ATOM    955  N   CYS A 130      64.735  45.374  70.411  1.00 32.57           N  
ATOM    956  CA  CYS A 130      64.417  45.110  69.014  1.00 34.32           C  
ATOM    957  C   CYS A 130      63.430  43.970  68.863  1.00 33.98           C  
ATOM    958  O   CYS A 130      62.516  44.044  68.038  1.00 30.86           O  
ATOM    959  CB  CYS A 130      65.661  44.847  68.196  1.00 35.46           C  
ATOM    960  SG  CYS A 130      66.708  46.330  68.022  1.00 35.78           S  
ATOM    961  N   SER A 131      63.613  42.918  69.648  1.00 32.47           N  
ATOM    962  CA  SER A 131      62.712  41.786  69.585  1.00 33.39           C  
ATOM    963  C   SER A 131      61.280  42.164  69.955  1.00 32.33           C  
ATOM    964  O   SER A 131      60.347  41.700  69.321  1.00 31.79           O  
ATOM    965  CB  SER A 131      63.213  40.645  70.455  1.00 31.44           C  
ATOM    966  OG  SER A 131      64.434  40.141  69.923  1.00 33.94           O  
ATOM    967  N   VAL A 132      61.119  42.984  70.980  1.00 31.53           N  
ATOM    968  CA  VAL A 132      59.791  43.453  71.388  1.00 32.36           C  
ATOM    969  C   VAL A 132      59.092  44.170  70.226  1.00 31.10           C  
ATOM    970  O   VAL A 132      57.973  43.789  69.822  1.00 30.78           O  
ATOM    971  CB  VAL A 132      59.861  44.368  72.660  1.00 36.60           C  
ATOM    972  CG1 VAL A 132      58.516  45.064  72.916  1.00 33.12           C  
ATOM    973  CG2 VAL A 132      60.304  43.538  73.901  1.00 33.94           C  
ATOM    974  N   TYR A 133      59.754  45.200  69.683  1.00 34.87           N  
ATOM    975  CA  TYR A 133      59.144  46.027  68.638  1.00 32.84           C  
ATOM    976  C   TYR A 133      58.931  45.279  67.321  1.00 33.53           C  
ATOM    977  O   TYR A 133      57.912  45.458  66.659  1.00 36.55           O  
ATOM    978  CB  TYR A 133      59.918  47.351  68.456  1.00 33.41           C  
ATOM    979  CG  TYR A 133      59.689  48.282  69.630  1.00 31.84           C  
ATOM    980  CD1 TYR A 133      58.478  48.928  69.804  1.00 37.82           C  
ATOM    981  CD2 TYR A 133      60.684  48.497  70.593  1.00 36.04           C  
ATOM    982  CE1 TYR A 133      58.251  49.776  70.897  1.00 43.17           C  
ATOM    983  CE2 TYR A 133      60.472  49.347  71.676  1.00 35.89           C  
ATOM    984  CZ  TYR A 133      59.260  49.973  71.834  1.00 37.96           C  
ATOM    985  OH  TYR A 133      59.048  50.816  72.904  1.00 36.74           O  
ATOM    986  N   GLY A 134      59.862  44.395  66.989  1.00 33.69           N  
ATOM    987  CA  GLY A 134      59.756  43.537  65.817  1.00 33.15           C  
ATOM    988  C   GLY A 134      58.658  42.514  65.928  1.00 31.84           C  
ATOM    989  O   GLY A 134      57.860  42.370  65.008  1.00 32.96           O  
ATOM    990  N   ALA A 135      58.592  41.838  67.070  1.00 31.88           N  
ATOM    991  CA  ALA A 135      57.544  40.858  67.332  1.00 33.04           C  
ATOM    992  C   ALA A 135      56.163  41.525  67.216  1.00 31.85           C  
ATOM    993  O   ALA A 135      55.188  40.907  66.747  1.00 33.16           O  
ATOM    994  CB  ALA A 135      57.743  40.213  68.713  1.00 31.53           C  
ATOM    995  N   ARG A 136      56.050  42.775  67.666  1.00 32.76           N  
ATOM    996  CA  ARG A 136      54.772  43.501  67.538  1.00 34.74           C  
ATOM    997  C   ARG A 136      54.291  43.562  66.087  1.00 33.51           C  
ATOM    998  O   ARG A 136      53.093  43.472  65.827  1.00 33.65           O  
ATOM    999  CB  ARG A 136      54.832  44.912  68.126  1.00 35.28           C  
ATOM   1000  CG  ARG A 136      54.805  44.886  69.621  1.00 32.50           C  
ATOM   1001  CD  ARG A 136      55.038  46.254  70.214  1.00 33.62           C  
ATOM   1002  NE  ARG A 136      55.115  46.116  71.662  1.00 33.58           N  
ATOM   1003  CZ  ARG A 136      55.213  47.137  72.501  1.00 41.06           C  
ATOM   1004  NH1 ARG A 136      55.242  48.385  72.045  1.00 43.66           N  
ATOM   1005  NH2 ARG A 136      55.267  46.897  73.799  1.00 40.03           N  
ATOM   1006  N   LEU A 137      55.221  43.674  65.155  1.00 32.75           N  
ATOM   1007  CA  LEU A 137      54.870  43.667  63.735  1.00 33.98           C  
ATOM   1008  C   LEU A 137      54.634  42.268  63.170  1.00 35.47           C  
ATOM   1009  O   LEU A 137      53.804  42.092  62.279  1.00 33.59           O  
ATOM   1010  CB  LEU A 137      55.963  44.383  62.931  1.00 33.22           C  
ATOM   1011  CG  LEU A 137      56.124  45.897  63.233  1.00 36.01           C  
ATOM   1012  CD1 LEU A 137      57.128  46.551  62.242  1.00 35.07           C  
ATOM   1013  CD2 LEU A 137      54.807  46.610  63.149  1.00 35.97           C  
ATOM   1014  N   MET A 138      55.382  41.283  63.660  1.00 33.15           N  
ATOM   1015  CA  MET A 138      55.275  39.919  63.126  1.00 33.06           C  
ATOM   1016  C   MET A 138      53.992  39.203  63.574  1.00 32.58           C  
ATOM   1017  O   MET A 138      53.349  38.511  62.781  1.00 33.04           O  
ATOM   1018  CB  MET A 138      56.481  39.098  63.545  1.00 33.84           C  
ATOM   1019  CG  MET A 138      57.775  39.643  63.003  1.00 31.36           C  
ATOM   1020  SD  MET A 138      59.141  38.589  63.430  1.00 35.69           S  
ATOM   1021  CE  MET A 138      60.498  39.449  62.593  1.00 34.18           C  
ATOM   1022  N   VAL A 139      53.674  39.309  64.872  1.00 35.19           N  
ATOM   1023  CA  VAL A 139      52.637  38.472  65.463  1.00 33.19           C  
ATOM   1024  C   VAL A 139      51.282  38.591  64.727  1.00 30.53           C  
ATOM   1025  O   VAL A 139      50.679  37.564  64.416  1.00 34.06           O  
ATOM   1026  CB  VAL A 139      52.549  38.655  66.998  1.00 33.87           C  
ATOM   1027  CG1 VAL A 139      51.313  38.006  67.589  1.00 33.06           C  
ATOM   1028  CG2 VAL A 139      53.853  38.090  67.663  1.00 30.13           C  
ATOM   1029  N   PRO A 140      50.825  39.823  64.397  1.00 33.21           N  
ATOM   1030  CA  PRO A 140      49.583  40.033  63.622  1.00 37.18           C  
ATOM   1031  C   PRO A 140      49.562  39.330  62.265  1.00 38.33           C  
ATOM   1032  O   PRO A 140      48.502  38.937  61.810  1.00 36.94           O  
ATOM   1033  CB  PRO A 140      49.547  41.558  63.438  1.00 38.59           C  
ATOM   1034  CG  PRO A 140      50.274  42.086  64.563  1.00 38.08           C  
ATOM   1035  CD  PRO A 140      51.406  41.119  64.801  1.00 37.92           C  
ATOM   1036  N   ALA A 141      50.731  39.147  61.649  1.00 33.67           N  
ATOM   1037  CA  ALA A 141      50.859  38.475  60.345  1.00 35.14           C  
ATOM   1038  C   ALA A 141      50.890  36.931  60.426  1.00 35.48           C  
ATOM   1039  O   ALA A 141      50.770  36.247  59.416  1.00 34.94           O  
ATOM   1040  CB  ALA A 141      52.100  38.996  59.616  1.00 34.51           C  
ATOM   1041  N   GLY A 142      51.055  36.391  61.624  1.00 32.67           N  
ATOM   1042  CA  GLY A 142      51.145  34.943  61.828  1.00 33.64           C  
ATOM   1043  C   GLY A 142      52.359  34.250  61.243  1.00 34.30           C  
ATOM   1044  O   GLY A 142      52.337  33.040  60.966  1.00 33.78           O  
ATOM   1045  N   GLN A 143      53.426  35.015  61.040  1.00 34.47           N  
ATOM   1046  CA  GLN A 143      54.647  34.510  60.446  1.00 33.60           C  
ATOM   1047  C   GLN A 143      55.788  35.509  60.696  1.00 31.62           C  
ATOM   1048  O   GLN A 143      55.564  36.697  61.067  1.00 33.95           O  
ATOM   1049  CB  GLN A 143      54.457  34.251  58.940  1.00 33.24           C  
ATOM   1050  CG  GLN A 143      54.207  35.513  58.158  1.00 36.12           C  
ATOM   1051  CD  GLN A 143      53.698  35.277  56.740  1.00 41.90           C  
ATOM   1052  OE1 GLN A 143      53.044  34.270  56.449  1.00 40.22           O  
ATOM   1053  NE2 GLN A 143      53.973  36.237  55.853  1.00 44.63           N  
ATOM   1054  N   GLY A 144      57.002  35.033  60.487  1.00 34.41           N  
ATOM   1055  CA  GLY A 144      58.177  35.858  60.634  1.00 33.03           C  
ATOM   1056  C   GLY A 144      59.254  35.085  61.353  1.00 33.63           C  
ATOM   1057  O   GLY A 144      59.016  33.970  61.887  1.00 30.85           O  
ATOM   1058  N   LEU A 145      60.458  35.659  61.302  1.00 32.14           N  
ATOM   1059  CA  LEU A 145      61.661  35.026  61.827  1.00 33.62           C  
ATOM   1060  C   LEU A 145      62.525  36.044  62.558  1.00 33.79           C  
ATOM   1061  O   LEU A 145      62.937  37.067  61.975  1.00 34.05           O  
ATOM   1062  CB  LEU A 145      62.488  34.361  60.707  1.00 37.49           C  
ATOM   1063  CG  LEU A 145      63.878  33.800  61.108  1.00 37.27           C  
ATOM   1064  CD1 LEU A 145      63.778  32.647  62.176  1.00 30.49           C  
ATOM   1065  CD2 LEU A 145      64.653  33.348  59.845  1.00 37.22           C  
ATOM   1066  N   ILE A 146      62.857  35.718  63.802  1.00 32.45           N  
ATOM   1067  CA  ILE A 146      63.810  36.490  64.559  1.00 29.99           C  
ATOM   1068  C   ILE A 146      65.066  35.645  64.736  1.00 33.45           C  
ATOM   1069  O   ILE A 146      65.005  34.475  65.164  1.00 34.69           O  
ATOM   1070  CB  ILE A 146      63.285  36.954  65.947  1.00 30.53           C  
ATOM   1071  CG1 ILE A 146      61.973  37.715  65.817  1.00 29.57           C  
ATOM   1072  CG2 ILE A 146      64.395  37.790  66.629  1.00 32.04           C  
ATOM   1073  CD1 ILE A 146      61.289  38.037  67.141  1.00 34.21           C  
ATOM   1074  N   VAL A 147      66.205  36.213  64.355  1.00 32.49           N  
ATOM   1075  CA  VAL A 147      67.506  35.555  64.495  1.00 33.68           C  
ATOM   1076  C   VAL A 147      68.329  36.297  65.554  1.00 35.45           C  
ATOM   1077  O   VAL A 147      68.517  37.518  65.478  1.00 37.68           O  
ATOM   1078  CB  VAL A 147      68.295  35.558  63.172  1.00 36.34           C  
ATOM   1079  CG1 VAL A 147      69.698  34.916  63.359  1.00 32.51           C  
ATOM   1080  CG2 VAL A 147      67.506  34.823  62.085  1.00 35.14           C  
ATOM   1081  N   VAL A 148      68.780  35.561  66.563  1.00 31.92           N  
ATOM   1082  CA  VAL A 148      69.743  36.064  67.527  1.00 31.98           C  
ATOM   1083  C   VAL A 148      71.117  35.495  67.217  1.00 34.05           C  
ATOM   1084  O   VAL A 148      71.285  34.269  67.111  1.00 34.97           O  
ATOM   1085  CB  VAL A 148      69.336  35.705  68.975  1.00 32.26           C  
ATOM   1086  CG1 VAL A 148      70.333  36.290  69.970  1.00 36.74           C  
ATOM   1087  CG2 VAL A 148      67.911  36.192  69.266  1.00 36.02           C  
ATOM   1088  N   ILE A 149      72.094  36.366  67.034  1.00 34.00           N  
ATOM   1089  CA  ILE A 149      73.455  35.917  66.749  1.00 34.54           C  
ATOM   1090  C   ILE A 149      74.119  35.598  68.094  1.00 40.43           C  
ATOM   1091  O   ILE A 149      74.200  36.463  68.971  1.00 39.47           O  
ATOM   1092  CB  ILE A 149      74.270  36.975  65.948  1.00 35.83           C  
ATOM   1093  CG1 ILE A 149      73.578  37.282  64.605  1.00 42.38           C  
ATOM   1094  CG2 ILE A 149      75.772  36.530  65.782  1.00 39.69           C  
ATOM   1095  CD1 ILE A 149      73.453  36.113  63.661  1.00 35.61           C  
ATOM   1096  N   SER A 150      74.611  34.370  68.249  1.00 36.61           N  
ATOM   1097  CA  SER A 150      75.260  33.942  69.504  1.00 36.75           C  
ATOM   1098  C   SER A 150      76.489  33.082  69.195  1.00 37.25           C  
ATOM   1099  O   SER A 150      77.019  33.136  68.062  1.00 38.26           O  
ATOM   1100  CB  SER A 150      74.248  33.198  70.399  1.00 34.66           C  
ATOM   1101  OG  SER A 150      74.775  32.959  71.712  1.00 42.94           O  
ATOM   1102  N   SER A 151      76.952  32.296  70.173  1.00 33.75           N  
ATOM   1103  CA  SER A 151      78.162  31.478  70.007  1.00 35.34           C  
ATOM   1104  C   SER A 151      78.269  30.450  71.149  1.00 32.54           C  
ATOM   1105  O   SER A 151      77.497  30.534  72.098  1.00 33.64           O  
ATOM   1106  CB  SER A 151      79.391  32.387  70.037  1.00 37.65           C  
ATOM   1107  OG  SER A 151      79.825  32.558  71.371  1.00 34.98           O  
ATOM   1108  N   PRO A 152      79.227  29.494  71.068  1.00 34.41           N  
ATOM   1109  CA  PRO A 152      79.440  28.528  72.155  1.00 37.61           C  
ATOM   1110  C   PRO A 152      79.785  29.149  73.510  1.00 34.22           C  
ATOM   1111  O   PRO A 152      79.764  28.462  74.524  1.00 32.63           O  
ATOM   1112  CB  PRO A 152      80.619  27.667  71.674  1.00 37.55           C  
ATOM   1113  CG  PRO A 152      80.812  27.970  70.274  1.00 39.88           C  
ATOM   1114  CD  PRO A 152      80.141  29.271  69.938  1.00 35.82           C  
ATOM   1115  N   GLY A 153      80.079  30.442  73.543  1.00 34.00           N  
ATOM   1116  CA  GLY A 153      80.190  31.140  74.805  1.00 33.06           C  
ATOM   1117  C   GLY A 153      78.941  31.034  75.657  1.00 34.92           C  
ATOM   1118  O   GLY A 153      79.014  31.232  76.860  1.00 34.16           O  
ATOM   1119  N   SER A 154      77.795  30.689  75.051  1.00 33.97           N  
ATOM   1120  CA  SER A 154      76.595  30.377  75.835  1.00 37.29           C  
ATOM   1121  C   SER A 154      76.744  29.125  76.734  1.00 37.24           C  
ATOM   1122  O   SER A 154      76.013  29.005  77.717  1.00 37.83           O  
ATOM   1123  CB  SER A 154      75.398  30.164  74.895  1.00 37.43           C  
ATOM   1124  OG  SER A 154      75.615  28.976  74.137  1.00 43.56           O  
ATOM   1125  N   LEU A 155      77.675  28.217  76.394  1.00 33.90           N  
ATOM   1126  CA  LEU A 155      77.808  26.924  77.059  1.00 37.30           C  
ATOM   1127  C   LEU A 155      78.867  26.873  78.128  1.00 36.30           C  
ATOM   1128  O   LEU A 155      78.892  25.949  78.941  1.00 35.22           O  
ATOM   1129  CB  LEU A 155      78.185  25.836  76.036  1.00 35.14           C  
ATOM   1130  CG  LEU A 155      77.253  25.673  74.847  1.00 39.75           C  
ATOM   1131  CD1 LEU A 155      77.777  24.548  73.942  1.00 32.50           C  
ATOM   1132  CD2 LEU A 155      75.843  25.411  75.343  1.00 35.50           C  
ATOM   1133  N   GLN A 156      79.806  27.804  78.071  1.00 33.17           N  
ATOM   1134  CA  GLN A 156      81.078  27.627  78.781  1.00 31.74           C  
ATOM   1135  C   GLN A 156      81.799  28.947  78.818  1.00 33.07           C  
ATOM   1136  O   GLN A 156      81.410  29.887  78.120  1.00 33.10           O  
ATOM   1137  CB  GLN A 156      81.945  26.586  78.059  1.00 33.75           C  
ATOM   1138  CG  GLN A 156      82.287  26.989  76.619  1.00 39.08           C  
ATOM   1139  CD  GLN A 156      82.388  25.804  75.648  1.00 36.89           C  
ATOM   1140  OE1 GLN A 156      81.994  24.674  75.963  1.00 36.06           O  
ATOM   1141  NE2 GLN A 156      82.927  26.065  74.470  1.00 32.48           N  
ATOM   1142  N   TYR A 157      82.867  28.997  79.604  1.00 35.93           N  
ATOM   1143  CA  TYR A 157      83.673  30.202  79.672  1.00 35.07           C  
ATOM   1144  C   TYR A 157      84.311  30.438  78.316  1.00 35.83           C  
ATOM   1145  O   TYR A 157      84.896  29.525  77.719  1.00 30.60           O  
ATOM   1146  CB  TYR A 157      84.756  30.063  80.726  1.00 31.39           C  
ATOM   1147  CG  TYR A 157      85.610  31.292  80.873  1.00 33.07           C  
ATOM   1148  CD1 TYR A 157      85.246  32.309  81.755  1.00 35.97           C  
ATOM   1149  CD2 TYR A 157      86.790  31.442  80.129  1.00 34.56           C  
ATOM   1150  CE1 TYR A 157      86.032  33.455  81.891  1.00 34.49           C  
ATOM   1151  CE2 TYR A 157      87.571  32.592  80.251  1.00 37.95           C  
ATOM   1152  CZ  TYR A 157      87.194  33.580  81.141  1.00 35.48           C  
ATOM   1153  OH  TYR A 157      87.984  34.715  81.265  1.00 36.85           O  
ATOM   1154  N   MET A 158      84.174  31.662  77.826  1.00 32.60           N  
ATOM   1155  CA  MET A 158      84.837  32.088  76.592  1.00 36.17           C  
ATOM   1156  C   MET A 158      85.230  33.565  76.649  1.00 32.86           C  
ATOM   1157  O   MET A 158      84.386  34.429  76.856  1.00 32.17           O  
ATOM   1158  CB  MET A 158      83.919  31.870  75.398  1.00 34.46           C  
ATOM   1159  CG  MET A 158      84.615  32.143  74.054  1.00 43.90           C  
ATOM   1160  N   PHE A 159      86.530  33.809  76.510  1.00 32.22           N  
ATOM   1161  CA  PHE A 159      87.136  35.144  76.410  1.00 35.56           C  
ATOM   1162  C   PHE A 159      87.127  35.942  77.712  1.00 33.09           C  
ATOM   1163  O   PHE A 159      88.175  36.278  78.212  1.00 31.26           O  
ATOM   1164  CB  PHE A 159      86.519  35.982  75.307  1.00 37.93           C  
ATOM   1165  CG  PHE A 159      86.391  35.269  74.008  1.00 36.27           C  
ATOM   1166  CD1 PHE A 159      87.360  34.354  73.587  1.00 47.59           C  
ATOM   1167  CD2 PHE A 159      85.299  35.538  73.179  1.00 44.82           C  
ATOM   1168  CE1 PHE A 159      87.222  33.695  72.363  1.00 54.26           C  
ATOM   1169  CE2 PHE A 159      85.161  34.899  71.962  1.00 48.82           C  
ATOM   1170  CZ  PHE A 159      86.110  33.971  71.555  1.00 47.15           C  
ATOM   1171  N   ASN A 160      85.947  36.251  78.218  1.00 30.82           N  
ATOM   1172  CA  ASN A 160      85.790  36.994  79.461  1.00 34.19           C  
ATOM   1173  C   ASN A 160      84.372  36.845  79.997  1.00 35.90           C  
ATOM   1174  O   ASN A 160      83.502  36.292  79.309  1.00 32.14           O  
ATOM   1175  CB  ASN A 160      86.239  38.485  79.316  1.00 32.85           C  
ATOM   1176  CG  ASN A 160      85.232  39.427  78.614  1.00 37.99           C  
ATOM   1177  OD1 ASN A 160      84.040  39.154  78.426  1.00 35.14           O  
ATOM   1178  ND2 ASN A 160      85.736  40.614  78.293  1.00 44.54           N  
ATOM   1179  N   VAL A 161      84.151  37.339  81.215  1.00 32.82           N  
ATOM   1180  CA  VAL A 161      82.903  37.103  81.905  1.00 31.66           C  
ATOM   1181  C   VAL A 161      81.710  37.731  81.192  1.00 31.51           C  
ATOM   1182  O   VAL A 161      80.730  37.040  80.889  1.00 33.80           O  
ATOM   1183  CB  VAL A 161      82.976  37.475  83.389  1.00 31.96           C  
ATOM   1184  CG1 VAL A 161      81.603  37.338  84.059  1.00 30.65           C  
ATOM   1185  CG2 VAL A 161      84.033  36.583  84.089  1.00 33.49           C  
ATOM   1186  N   PRO A 162      81.757  39.042  80.961  1.00 30.71           N  
ATOM   1187  CA  PRO A 162      80.563  39.618  80.331  1.00 33.58           C  
ATOM   1188  C   PRO A 162      80.237  39.032  78.964  1.00 30.77           C  
ATOM   1189  O   PRO A 162      79.058  38.931  78.621  1.00 34.29           O  
ATOM   1190  CB  PRO A 162      80.899  41.097  80.206  1.00 36.95           C  
ATOM   1191  CG  PRO A 162      81.947  41.341  81.199  1.00 36.45           C  
ATOM   1192  CD  PRO A 162      82.761  40.076  81.287  1.00 34.45           C  
ATOM   1193  N   TYR A 163      81.260  38.698  78.172  1.00 33.58           N  
ATOM   1194  CA  TYR A 163      81.004  38.061  76.877  1.00 33.90           C  
ATOM   1195  C   TYR A 163      80.159  36.785  77.028  1.00 33.54           C  
ATOM   1196  O   TYR A 163      79.095  36.627  76.381  1.00 33.99           O  
ATOM   1197  CB  TYR A 163      82.314  37.737  76.148  1.00 33.47           C  
ATOM   1198  CG  TYR A 163      82.109  37.001  74.841  1.00 34.75           C  
ATOM   1199  CD1 TYR A 163      81.825  37.684  73.665  1.00 37.09           C  
ATOM   1200  CD2 TYR A 163      82.169  35.604  74.795  1.00 38.18           C  
ATOM   1201  CE1 TYR A 163      81.597  36.995  72.473  1.00 35.66           C  
ATOM   1202  CE2 TYR A 163      81.965  34.912  73.623  1.00 37.16           C  
ATOM   1203  CZ  TYR A 163      81.681  35.605  72.457  1.00 34.54           C  
ATOM   1204  OH  TYR A 163      81.457  34.863  71.304  1.00 36.65           O  
ATOM   1205  N   GLY A 164      80.656  35.862  77.842  1.00 32.97           N  
ATOM   1206  CA  GLY A 164      80.003  34.558  78.092  1.00 35.27           C  
ATOM   1207  C   GLY A 164      78.639  34.639  78.723  1.00 32.96           C  
ATOM   1208  O   GLY A 164      77.723  33.897  78.362  1.00 31.92           O  
ATOM   1209  N   VAL A 165      78.488  35.541  79.676  1.00 33.29           N  
ATOM   1210  CA  VAL A 165      77.207  35.765  80.309  1.00 34.70           C  
ATOM   1211  C   VAL A 165      76.208  36.281  79.270  1.00 34.07           C  
ATOM   1212  O   VAL A 165      75.064  35.809  79.206  1.00 33.15           O  
ATOM   1213  CB  VAL A 165      77.319  36.721  81.499  1.00 35.16           C  
ATOM   1214  CG1 VAL A 165      75.906  37.094  82.038  1.00 33.37           C  
ATOM   1215  CG2 VAL A 165      78.220  36.103  82.650  1.00 32.57           C  
ATOM   1216  N   GLY A 166      76.652  37.234  78.446  1.00 36.06           N  
ATOM   1217  CA  GLY A 166      75.832  37.787  77.396  1.00 36.34           C  
ATOM   1218  C   GLY A 166      75.377  36.746  76.395  1.00 34.06           C  
ATOM   1219  O   GLY A 166      74.225  36.766  75.938  1.00 33.02           O  
ATOM   1220  N   LYS A 167      76.292  35.855  76.035  1.00 32.84           N  
ATOM   1221  CA  LYS A 167      75.981  34.769  75.088  1.00 34.96           C  
ATOM   1222  C   LYS A 167      75.003  33.757  75.679  1.00 37.00           C  
ATOM   1223  O   LYS A 167      74.086  33.329  74.987  1.00 34.51           O  
ATOM   1224  CB  LYS A 167      77.252  34.081  74.564  1.00 36.35           C  
ATOM   1225  CG  LYS A 167      78.122  34.983  73.681  1.00 36.41           C  
ATOM   1226  CD  LYS A 167      77.453  35.243  72.334  1.00 40.53           C  
ATOM   1227  CE  LYS A 167      78.256  36.158  71.426  1.00 45.68           C  
ATOM   1228  NZ  LYS A 167      77.916  37.578  71.642  1.00 45.05           N  
ATOM   1229  N   ALA A 168      75.184  33.383  76.946  1.00 33.88           N  
ATOM   1230  CA  ALA A 168      74.182  32.556  77.652  1.00 33.15           C  
ATOM   1231  C   ALA A 168      72.815  33.245  77.580  1.00 36.04           C  
ATOM   1232  O   ALA A 168      71.812  32.596  77.252  1.00 34.37           O  
ATOM   1233  CB  ALA A 168      74.592  32.303  79.103  1.00 33.62           C  
ATOM   1234  N   ALA A 169      72.782  34.555  77.848  1.00 31.79           N  
ATOM   1235  CA  ALA A 169      71.538  35.295  77.823  1.00 34.12           C  
ATOM   1236  C   ALA A 169      70.909  35.332  76.428  1.00 33.83           C  
ATOM   1237  O   ALA A 169      69.687  35.236  76.291  1.00 34.40           O  
ATOM   1238  CB  ALA A 169      71.739  36.731  78.354  1.00 34.70           C  
ATOM   1239  N   CYS A 170      71.730  35.519  75.404  1.00 34.47           N  
ATOM   1240  CA  CYS A 170      71.239  35.549  74.008  1.00 34.41           C  
ATOM   1241  C   CYS A 170      70.615  34.214  73.576  1.00 35.68           C  
ATOM   1242  O   CYS A 170      69.559  34.185  72.912  1.00 34.82           O  
ATOM   1243  CB  CYS A 170      72.370  35.951  73.019  1.00 36.94           C  
ATOM   1244  SG  CYS A 170      72.890  37.656  73.108  1.00 38.93           S  
ATOM   1245  N   ASP A 171      71.257  33.098  73.919  1.00 35.02           N  
ATOM   1246  CA  ASP A 171      70.694  31.790  73.562  1.00 36.29           C  
ATOM   1247  C   ASP A 171      69.353  31.615  74.281  1.00 37.59           C  
ATOM   1248  O   ASP A 171      68.385  31.095  73.706  1.00 32.84           O  
ATOM   1249  CB  ASP A 171      71.649  30.639  73.928  1.00 33.79           C  
ATOM   1250  CG  ASP A 171      72.631  30.256  72.807  1.00 47.36           C  
ATOM   1251  OD1 ASP A 171      72.723  30.927  71.754  1.00 44.97           O  
ATOM   1252  OD2 ASP A 171      73.311  29.231  72.997  1.00 45.39           O  
ATOM   1253  N   LYS A 172      69.284  32.058  75.541  1.00 32.83           N  
ATOM   1254  CA  LYS A 172      68.036  31.938  76.296  1.00 32.61           C  
ATOM   1255  C   LYS A 172      66.936  32.838  75.742  1.00 32.75           C  
ATOM   1256  O   LYS A 172      65.755  32.450  75.720  1.00 32.46           O  
ATOM   1257  CB  LYS A 172      68.279  32.199  77.775  1.00 30.37           C  
ATOM   1258  CG  LYS A 172      67.110  31.939  78.695  1.00 30.88           C  
ATOM   1259  CD  LYS A 172      66.516  30.534  78.515  1.00 34.81           C  
ATOM   1260  CE  LYS A 172      65.997  29.984  79.844  1.00 35.80           C  
ATOM   1261  NZ  LYS A 172      64.976  30.807  80.464  1.00 35.16           N  
ATOM   1262  N   LEU A 173      67.326  34.041  75.319  1.00 34.31           N  
ATOM   1263  CA  LEU A 173      66.418  34.988  74.699  1.00 35.69           C  
ATOM   1264  C   LEU A 173      65.766  34.361  73.484  1.00 34.36           C  
ATOM   1265  O   LEU A 173      64.556  34.428  73.318  1.00 31.51           O  
ATOM   1266  CB  LEU A 173      67.151  36.267  74.274  1.00 34.15           C  
ATOM   1267  CG  LEU A 173      66.341  37.371  73.562  1.00 33.00           C  
ATOM   1268  CD1 LEU A 173      65.281  37.974  74.505  1.00 35.41           C  
ATOM   1269  CD2 LEU A 173      67.320  38.430  73.044  1.00 34.65           C  
ATOM   1270  N   ALA A 174      66.573  33.757  72.622  1.00 32.37           N  
ATOM   1271  CA  ALA A 174      66.010  33.041  71.475  1.00 35.14           C  
ATOM   1272  C   ALA A 174      65.019  31.945  71.876  1.00 34.40           C  
ATOM   1273  O   ALA A 174      63.913  31.880  71.337  1.00 34.38           O  
ATOM   1274  CB  ALA A 174      67.126  32.479  70.573  1.00 34.59           C  
ATOM   1275  N   ALA A 175      65.403  31.098  72.833  1.00 31.57           N  
ATOM   1276  CA  ALA A 175      64.566  29.992  73.279  1.00 33.85           C  
ATOM   1277  C   ALA A 175      63.236  30.463  73.899  1.00 33.47           C  
ATOM   1278  O   ALA A 175      62.140  29.943  73.593  1.00 31.35           O  
ATOM   1279  CB  ALA A 175      65.339  29.140  74.283  1.00 33.95           C  
ATOM   1280  N   ASP A 176      63.330  31.442  74.782  1.00 33.63           N  
ATOM   1281  CA  ASP A 176      62.145  31.890  75.519  1.00 33.33           C  
ATOM   1282  C   ASP A 176      61.190  32.707  74.611  1.00 31.86           C  
ATOM   1283  O   ASP A 176      59.971  32.588  74.707  1.00 31.54           O  
ATOM   1284  CB  ASP A 176      62.577  32.686  76.734  1.00 33.56           C  
ATOM   1285  CG  ASP A 176      63.126  31.793  77.876  1.00 37.58           C  
ATOM   1286  OD1 ASP A 176      63.142  30.545  77.751  1.00 40.57           O  
ATOM   1287  OD2 ASP A 176      63.552  32.356  78.907  1.00 38.02           O  
ATOM   1288  N   CYS A 177      61.741  33.544  73.723  1.00 34.04           N  
ATOM   1289  CA  CYS A 177      60.918  34.228  72.718  1.00 32.57           C  
ATOM   1290  C   CYS A 177      60.228  33.221  71.797  1.00 32.57           C  
ATOM   1291  O   CYS A 177      59.032  33.363  71.501  1.00 31.50           O  
ATOM   1292  CB  CYS A 177      61.760  35.205  71.880  1.00 32.83           C  
ATOM   1293  SG  CYS A 177      62.251  36.671  72.796  1.00 33.08           S  
ATOM   1294  N   ALA A 178      60.989  32.221  71.334  1.00 29.80           N  
ATOM   1295  CA  ALA A 178      60.439  31.124  70.524  1.00 36.73           C  
ATOM   1296  C   ALA A 178      59.223  30.505  71.210  1.00 31.60           C  
ATOM   1297  O   ALA A 178      58.177  30.248  70.583  1.00 31.74           O  
ATOM   1298  CB  ALA A 178      61.526  30.042  70.253  1.00 31.26           C  
ATOM   1299  N   HIS A 179      59.383  30.237  72.500  1.00 31.93           N  
ATOM   1300  CA  HIS A 179      58.334  29.594  73.277  1.00 32.32           C  
ATOM   1301  C   HIS A 179      57.010  30.357  73.193  1.00 34.37           C  
ATOM   1302  O   HIS A 179      55.935  29.769  72.937  1.00 32.01           O  
ATOM   1303  CB  HIS A 179      58.798  29.470  74.731  1.00 31.99           C  
ATOM   1304  CG  HIS A 179      57.798  28.807  75.613  1.00 36.88           C  
ATOM   1305  ND1 HIS A 179      56.933  29.515  76.420  1.00 43.64           N  
ATOM   1306  CD2 HIS A 179      57.507  27.502  75.799  1.00 45.80           C  
ATOM   1307  CE1 HIS A 179      56.149  28.670  77.064  1.00 38.92           C  
ATOM   1308  NE2 HIS A 179      56.491  27.442  76.722  1.00 53.80           N  
ATOM   1309  N   GLU A 180      57.084  31.660  73.426  1.00 31.30           N  
ATOM   1310  CA  GLU A 180      55.882  32.497  73.412  1.00 34.47           C  
ATOM   1311  C   GLU A 180      55.349  32.715  72.001  1.00 31.11           C  
ATOM   1312  O   GLU A 180      54.139  32.881  71.813  1.00 34.59           O  
ATOM   1313  CB  GLU A 180      56.160  33.848  74.071  1.00 34.59           C  
ATOM   1314  CG  GLU A 180      56.451  33.750  75.600  1.00 33.35           C  
ATOM   1315  CD  GLU A 180      56.417  35.118  76.306  1.00 33.83           C  
ATOM   1316  OE1 GLU A 180      56.330  36.157  75.590  1.00 34.06           O  
ATOM   1317  OE2 GLU A 180      56.486  35.150  77.555  1.00 32.66           O  
ATOM   1318  N   LEU A 181      56.247  32.734  71.015  1.00 32.46           N  
ATOM   1319  CA  LEU A 181      55.860  33.052  69.635  1.00 31.16           C  
ATOM   1320  C   LEU A 181      55.279  31.900  68.847  1.00 33.56           C  
ATOM   1321  O   LEU A 181      54.594  32.109  67.845  1.00 32.35           O  
ATOM   1322  CB  LEU A 181      57.063  33.556  68.873  1.00 30.00           C  
ATOM   1323  CG  LEU A 181      57.485  34.956  69.283  1.00 30.72           C  
ATOM   1324  CD1 LEU A 181      58.900  35.196  68.727  1.00 33.12           C  
ATOM   1325  CD2 LEU A 181      56.466  36.014  68.813  1.00 33.87           C  
ATOM   1326  N   ARG A 182      55.552  30.690  69.289  1.00 31.76           N  
ATOM   1327  CA  ARG A 182      55.234  29.515  68.481  1.00 32.04           C  
ATOM   1328  C   ARG A 182      53.757  29.437  68.100  1.00 34.91           C  
ATOM   1329  O   ARG A 182      53.414  29.119  66.953  1.00 32.05           O  
ATOM   1330  CB  ARG A 182      55.632  28.260  69.232  1.00 29.88           C  
ATOM   1331  CG  ARG A 182      55.453  26.974  68.395  1.00 36.83           C  
ATOM   1332  CD  ARG A 182      55.953  25.788  69.139  1.00 39.78           C  
ATOM   1333  NE  ARG A 182      57.361  25.907  69.462  1.00 44.50           N  
ATOM   1334  CZ  ARG A 182      58.342  25.704  68.591  1.00 46.38           C  
ATOM   1335  NH1 ARG A 182      58.087  25.335  67.328  1.00 50.96           N  
ATOM   1336  NH2 ARG A 182      59.589  25.875  68.978  1.00 53.50           N  
ATOM   1337  N   ARG A 183      52.872  29.706  69.057  1.00 35.86           N  
ATOM   1338  CA  ARG A 183      51.440  29.583  68.780  1.00 36.47           C  
ATOM   1339  C   ARG A 183      50.943  30.597  67.747  1.00 38.37           C  
ATOM   1340  O   ARG A 183      49.869  30.414  67.171  1.00 37.69           O  
ATOM   1341  CB  ARG A 183      50.621  29.698  70.070  1.00 39.67           C  
ATOM   1342  CG  ARG A 183      50.572  31.099  70.645  1.00 41.97           C  
ATOM   1343  CD  ARG A 183      49.879  31.132  71.988  1.00 56.02           C  
ATOM   1344  NE  ARG A 183      48.519  30.612  71.913  1.00 70.97           N  
ATOM   1345  CZ  ARG A 183      47.425  31.337  71.680  1.00 75.60           C  
ATOM   1346  NH1 ARG A 183      47.503  32.652  71.478  1.00 75.58           N  
ATOM   1347  NH2 ARG A 183      46.238  30.733  71.646  1.00 77.04           N  
ATOM   1348  N   HIS A 184      51.725  31.650  67.520  1.00 36.19           N  
ATOM   1349  CA  HIS A 184      51.417  32.687  66.546  1.00 40.21           C  
ATOM   1350  C   HIS A 184      52.130  32.475  65.207  1.00 39.37           C  
ATOM   1351  O   HIS A 184      52.091  33.338  64.305  1.00 40.60           O  
ATOM   1352  CB  HIS A 184      51.826  34.045  67.109  1.00 38.78           C  
ATOM   1353  CG  HIS A 184      51.150  34.382  68.397  1.00 38.32           C  
ATOM   1354  ND1 HIS A 184      49.843  34.813  68.454  1.00 40.91           N  
ATOM   1355  CD2 HIS A 184      51.583  34.321  69.681  1.00 43.55           C  
ATOM   1356  CE1 HIS A 184      49.504  35.016  69.716  1.00 43.00           C  
ATOM   1357  NE2 HIS A 184      50.541  34.725  70.480  1.00 42.22           N  
ATOM   1358  N   GLY A 185      52.808  31.345  65.072  1.00 35.90           N  
ATOM   1359  CA  GLY A 185      53.481  31.022  63.825  1.00 35.01           C  
ATOM   1360  C   GLY A 185      54.783  31.743  63.529  1.00 30.11           C  
ATOM   1361  O   GLY A 185      55.299  31.641  62.411  1.00 34.40           O  
ATOM   1362  N   VAL A 186      55.329  32.439  64.522  1.00 30.23           N  
ATOM   1363  CA  VAL A 186      56.559  33.162  64.370  1.00 32.01           C  
ATOM   1364  C   VAL A 186      57.705  32.393  64.990  1.00 34.38           C  
ATOM   1365  O   VAL A 186      57.572  31.821  66.064  1.00 32.67           O  
ATOM   1366  CB  VAL A 186      56.454  34.576  65.015  1.00 33.63           C  
ATOM   1367  CG1 VAL A 186      57.769  35.338  64.873  1.00 32.26           C  
ATOM   1368  CG2 VAL A 186      55.262  35.376  64.401  1.00 33.76           C  
ATOM   1369  N   SER A 187      58.821  32.358  64.280  1.00 35.61           N  
ATOM   1370  CA  SER A 187      59.972  31.578  64.677  1.00 35.82           C  
ATOM   1371  C   SER A 187      61.048  32.490  65.250  1.00 34.67           C  
ATOM   1372  O   SER A 187      61.137  33.681  64.896  1.00 30.62           O  
ATOM   1373  CB  SER A 187      60.550  30.811  63.480  1.00 33.44           C  
ATOM   1374  OG  SER A 187      59.606  29.949  62.881  1.00 37.01           O  
ATOM   1375  N   CYS A 188      61.856  31.921  66.138  1.00 34.18           N  
ATOM   1376  CA  CYS A 188      63.018  32.626  66.694  1.00 33.59           C  
ATOM   1377  C   CYS A 188      64.133  31.613  66.916  1.00 35.59           C  
ATOM   1378  O   CYS A 188      63.919  30.577  67.551  1.00 33.07           O  
ATOM   1379  CB  CYS A 188      62.634  33.352  67.988  1.00 34.37           C  
ATOM   1380  SG  CYS A 188      63.980  34.290  68.735  1.00 39.22           S  
ATOM   1381  N   VAL A 189      65.306  31.871  66.349  1.00 32.42           N  
ATOM   1382  CA  VAL A 189      66.413  30.923  66.444  1.00 31.88           C  
ATOM   1383  C   VAL A 189      67.683  31.605  66.919  1.00 35.63           C  
ATOM   1384  O   VAL A 189      67.810  32.835  66.836  1.00 32.91           O  
ATOM   1385  CB  VAL A 189      66.712  30.264  65.061  1.00 35.05           C  
ATOM   1386  CG1 VAL A 189      65.480  29.475  64.565  1.00 31.27           C  
ATOM   1387  CG2 VAL A 189      67.179  31.320  64.021  1.00 30.48           C  
ATOM   1388  N   SER A 190      68.626  30.812  67.419  1.00 33.14           N  
ATOM   1389  CA  SER A 190      69.932  31.329  67.750  1.00 33.44           C  
ATOM   1390  C   SER A 190      70.910  30.799  66.707  1.00 35.69           C  
ATOM   1391  O   SER A 190      71.060  29.586  66.530  1.00 35.79           O  
ATOM   1392  CB  SER A 190      70.361  30.887  69.148  1.00 33.99           C  
ATOM   1393  OG  SER A 190      71.681  31.312  69.357  1.00 42.25           O  
ATOM   1394  N   LEU A 191      71.547  31.717  65.979  1.00 34.43           N  
ATOM   1395  CA  LEU A 191      72.502  31.343  64.957  1.00 34.35           C  
ATOM   1396  C   LEU A 191      73.903  31.502  65.522  1.00 35.05           C  
ATOM   1397  O   LEU A 191      74.221  32.539  66.104  1.00 35.87           O  
ATOM   1398  CB  LEU A 191      72.294  32.208  63.710  1.00 33.54           C  
ATOM   1399  CG  LEU A 191      73.204  31.981  62.503  1.00 40.01           C  
ATOM   1400  CD1 LEU A 191      72.938  30.606  61.908  1.00 36.73           C  
ATOM   1401  CD2 LEU A 191      72.992  33.140  61.460  1.00 38.70           C  
ATOM   1402  N   TRP A 192      74.728  30.467  65.395  1.00 33.65           N  
ATOM   1403  CA  TRP A 192      76.165  30.561  65.751  1.00 33.48           C  
ATOM   1404  C   TRP A 192      76.962  30.601  64.440  1.00 39.62           C  
ATOM   1405  O   TRP A 192      77.237  29.544  63.815  1.00 36.34           O  
ATOM   1406  CB  TRP A 192      76.609  29.334  66.539  1.00 35.19           C  
ATOM   1407  CG  TRP A 192      76.041  29.199  67.911  1.00 34.77           C  
ATOM   1408  CD1 TRP A 192      75.113  29.993  68.537  1.00 35.25           C  
ATOM   1409  CD2 TRP A 192      76.369  28.158  68.837  1.00 35.57           C  
ATOM   1410  NE1 TRP A 192      74.856  29.507  69.801  1.00 36.23           N  
ATOM   1411  CE2 TRP A 192      75.616  28.382  70.010  1.00 37.65           C  
ATOM   1412  CE3 TRP A 192      77.239  27.069  68.788  1.00 36.33           C  
ATOM   1413  CZ2 TRP A 192      75.688  27.533  71.116  1.00 34.92           C  
ATOM   1414  CZ3 TRP A 192      77.321  26.231  69.893  1.00 37.05           C  
ATOM   1415  CH2 TRP A 192      76.544  26.469  71.039  1.00 32.05           C  
ATOM   1416  N   PRO A 193      77.303  31.801  63.978  1.00 40.10           N  
ATOM   1417  CA  PRO A 193      77.892  31.876  62.644  1.00 42.86           C  
ATOM   1418  C   PRO A 193      79.390  31.666  62.650  1.00 51.88           C  
ATOM   1419  O   PRO A 193      80.026  31.731  61.579  1.00 57.96           O  
ATOM   1420  CB  PRO A 193      77.579  33.312  62.223  1.00 44.56           C  
ATOM   1421  CG  PRO A 193      77.681  34.074  63.490  1.00 42.55           C  
ATOM   1422  CD  PRO A 193      77.160  33.136  64.581  1.00 39.97           C  
ATOM   1423  N   GLY A 194      79.957  31.416  63.826  1.00 52.98           N  
ATOM   1424  CA  GLY A 194      81.399  31.391  63.983  1.00 61.10           C  
ATOM   1425  C   GLY A 194      81.938  32.795  64.197  1.00 65.39           C  
ATOM   1426  O   GLY A 194      81.311  33.781  63.802  1.00 69.33           O  
ATOM   1427  N   ILE A 195      83.113  32.875  64.814  1.00 68.86           N  
ATOM   1428  CA  ILE A 195      83.714  34.148  65.204  1.00 69.19           C  
ATOM   1429  C   ILE A 195      84.449  34.832  64.041  1.00 70.31           C  
ATOM   1430  O   ILE A 195      85.423  34.294  63.522  1.00 73.13           O  
ATOM   1431  CB  ILE A 195      84.689  33.927  66.382  1.00 69.47           C  
ATOM   1432  CG1 ILE A 195      83.942  33.330  67.573  1.00 67.32           C  
ATOM   1433  CG2 ILE A 195      85.364  35.221  66.777  1.00 70.88           C  
ATOM   1434  N   VAL A 196      83.988  36.020  63.647  1.00 70.95           N  
ATOM   1435  CA  VAL A 196      84.669  36.813  62.608  1.00 71.48           C  
ATOM   1436  C   VAL A 196      86.035  37.313  63.076  1.00 70.71           C  
ATOM   1437  O   VAL A 196      87.024  37.218  62.345  1.00 68.38           O  
ATOM   1438  CB  VAL A 196      83.824  38.033  62.155  1.00 70.78           C  
ATOM   1439  CG1 VAL A 196      84.719  39.139  61.585  1.00 70.27           C  
ATOM   1440  CG2 VAL A 196      82.798  37.603  61.125  1.00 73.45           C  
ATOM   1441  N   GLN A 197      86.073  37.861  64.287  1.00 69.27           N  
ATOM   1442  CA  GLN A 197      87.322  38.335  64.882  1.00 69.75           C  
ATOM   1443  C   GLN A 197      88.139  37.128  65.355  1.00 66.66           C  
ATOM   1444  O   GLN A 197      87.955  36.632  66.468  1.00 67.68           O  
ATOM   1445  CB  GLN A 197      87.043  39.303  66.035  1.00 68.13           C  
ATOM   1446  N   THR A 198      89.029  36.662  64.484  1.00 65.19           N  
ATOM   1447  CA  THR A 198      89.767  35.422  64.717  1.00 65.10           C  
ATOM   1448  C   THR A 198      90.803  35.580  65.830  1.00 65.69           C  
ATOM   1449  O   THR A 198      91.105  34.611  66.542  1.00 65.40           O  
ATOM   1450  CB  THR A 198      90.446  34.902  63.423  1.00 66.39           C  
ATOM   1451  OG1 THR A 198      91.431  35.839  62.970  1.00 63.59           O  
ATOM   1452  CG2 THR A 198      89.401  34.665  62.314  1.00 66.14           C  
ATOM   1453  N   GLU A 199      91.318  36.803  65.996  1.00 64.31           N  
ATOM   1454  CA  GLU A 199      92.201  37.127  67.118  1.00 64.60           C  
ATOM   1455  C   GLU A 199      91.577  36.678  68.433  1.00 63.97           C  
ATOM   1456  O   GLU A 199      92.280  36.244  69.338  1.00 65.29           O  
ATOM   1457  CB  GLU A 199      92.493  38.627  67.179  1.00 65.13           C  
ATOM   1458  N   LEU A 200      90.255  36.773  68.535  1.00 62.70           N  
ATOM   1459  CA  LEU A 200      89.547  36.281  69.719  1.00 64.77           C  
ATOM   1460  C   LEU A 200      89.976  34.847  69.975  1.00 65.79           C  
ATOM   1461  O   LEU A 200      90.447  34.514  71.061  1.00 68.20           O  
ATOM   1462  CB  LEU A 200      88.027  36.343  69.526  1.00 61.89           C  
ATOM   1463  N   LEU A 201      89.836  34.015  68.948  1.00 64.12           N  
ATOM   1464  CA  LEU A 201      90.135  32.593  69.059  1.00 65.06           C  
ATOM   1465  C   LEU A 201      91.645  32.390  69.111  1.00 64.43           C  
ATOM   1466  O   LEU A 201      92.127  31.505  69.807  1.00 65.72           O  
ATOM   1467  CB  LEU A 201      89.536  31.825  67.872  1.00 62.19           C  
ATOM   1468  CG  LEU A 201      88.024  31.971  67.671  1.00 61.20           C  
ATOM   1469  CD1 LEU A 201      87.609  31.348  66.334  1.00 58.05           C  
ATOM   1470  CD2 LEU A 201      87.236  31.359  68.828  1.00 53.14           C  
ATOM   1471  N   SER A 224      88.034  31.585  56.305  1.00 71.01           N  
ATOM   1472  CA  SER A 224      88.235  33.032  56.335  1.00 73.55           C  
ATOM   1473  C   SER A 224      86.997  33.754  56.860  1.00 73.86           C  
ATOM   1474  O   SER A 224      85.877  33.249  56.748  1.00 74.37           O  
ATOM   1475  CB  SER A 224      88.585  33.568  54.945  1.00 73.40           C  
ATOM   1476  OG  SER A 224      87.424  33.772  54.154  1.00 73.48           O  
ATOM   1477  N   SER A 225      87.217  34.941  57.423  1.00 74.29           N  
ATOM   1478  CA  SER A 225      86.140  35.779  57.956  1.00 72.40           C  
ATOM   1479  C   SER A 225      85.255  36.262  56.822  1.00 69.75           C  
ATOM   1480  O   SER A 225      84.024  36.225  56.919  1.00 67.06           O  
ATOM   1481  CB  SER A 225      86.717  36.984  58.707  1.00 73.17           C  
ATOM   1482  OG  SER A 225      87.541  36.569  59.789  1.00 76.91           O  
ATOM   1483  N   ALA A 226      85.901  36.708  55.745  1.00 67.01           N  
ATOM   1484  CA  ALA A 226      85.208  37.087  54.524  1.00 65.11           C  
ATOM   1485  C   ALA A 226      84.215  36.005  54.116  1.00 62.99           C  
ATOM   1486  O   ALA A 226      83.007  36.262  53.998  1.00 65.46           O  
ATOM   1487  CB  ALA A 226      86.219  37.320  53.409  1.00 65.53           C  
ATOM   1488  N   GLU A 227      84.733  34.795  53.921  1.00 57.87           N  
ATOM   1489  CA  GLU A 227      83.909  33.646  53.568  1.00 54.76           C  
ATOM   1490  C   GLU A 227      82.813  33.417  54.606  1.00 52.98           C  
ATOM   1491  O   GLU A 227      81.671  33.121  54.255  1.00 49.03           O  
ATOM   1492  CB  GLU A 227      84.768  32.378  53.460  1.00 56.92           C  
ATOM   1493  N   THR A 228      83.184  33.555  55.876  1.00 49.55           N  
ATOM   1494  CA  THR A 228      82.286  33.292  56.997  1.00 50.38           C  
ATOM   1495  C   THR A 228      81.079  34.234  57.041  1.00 47.09           C  
ATOM   1496  O   THR A 228      79.958  33.772  57.273  1.00 46.37           O  
ATOM   1497  CB  THR A 228      83.056  33.374  58.327  1.00 51.55           C  
ATOM   1498  OG1 THR A 228      84.036  32.334  58.354  1.00 62.77           O  
ATOM   1499  CG2 THR A 228      82.114  33.235  59.546  1.00 48.67           C  
ATOM   1500  N   THR A 229      81.308  35.532  56.807  1.00 41.67           N  
ATOM   1501  CA  THR A 229      80.219  36.508  56.867  1.00 45.18           C  
ATOM   1502  C   THR A 229      79.259  36.263  55.718  1.00 44.08           C  
ATOM   1503  O   THR A 229      78.055  36.427  55.889  1.00 40.17           O  
ATOM   1504  CB  THR A 229      80.685  37.978  56.823  1.00 45.29           C  
ATOM   1505  OG1 THR A 229      81.351  38.234  55.586  1.00 50.75           O  
ATOM   1506  CG2 THR A 229      81.617  38.299  57.975  1.00 40.35           C  
ATOM   1507  N   GLU A 230      79.787  35.882  54.550  1.00 46.24           N  
ATOM   1508  CA  GLU A 230      78.934  35.529  53.405  1.00 45.17           C  
ATOM   1509  C   GLU A 230      78.094  34.277  53.701  1.00 44.54           C  
ATOM   1510  O   GLU A 230      76.901  34.226  53.390  1.00 38.22           O  
ATOM   1511  CB  GLU A 230      79.759  35.321  52.136  1.00 47.72           C  
ATOM   1512  CG  GLU A 230      78.905  35.026  50.888  1.00 51.29           C  
ATOM   1513  CD  GLU A 230      79.694  35.132  49.571  1.00 54.34           C  
ATOM   1514  OE1 GLU A 230      80.907  34.810  49.567  1.00 56.98           O  
ATOM   1515  OE2 GLU A 230      79.094  35.540  48.544  1.00 68.55           O  
ATOM   1516  N   LEU A 231      78.719  33.277  54.313  1.00 41.81           N  
ATOM   1517  CA  LEU A 231      78.012  32.050  54.701  1.00 42.04           C  
ATOM   1518  C   LEU A 231      76.869  32.373  55.650  1.00 39.56           C  
ATOM   1519  O   LEU A 231      75.769  31.861  55.484  1.00 35.93           O  
ATOM   1520  CB  LEU A 231      78.967  31.040  55.357  1.00 38.88           C  
ATOM   1521  CG  LEU A 231      78.297  29.874  56.117  1.00 52.22           C  
ATOM   1522  CD1 LEU A 231      77.404  29.033  55.189  1.00 45.43           C  
ATOM   1523  CD2 LEU A 231      79.343  29.014  56.812  1.00 48.87           C  
ATOM   1524  N   SER A 232      77.126  33.242  56.627  1.00 37.97           N  
ATOM   1525  CA  SER A 232      76.104  33.617  57.612  1.00 39.21           C  
ATOM   1526  C   SER A 232      74.878  34.207  56.913  1.00 34.79           C  
ATOM   1527  O   SER A 232      73.728  33.900  57.259  1.00 35.85           O  
ATOM   1528  CB  SER A 232      76.676  34.647  58.589  1.00 41.78           C  
ATOM   1529  OG  SER A 232      75.817  34.812  59.694  1.00 65.44           O  
ATOM   1530  N   GLY A 233      75.142  35.065  55.931  1.00 33.82           N  
ATOM   1531  CA  GLY A 233      74.096  35.671  55.135  1.00 31.97           C  
ATOM   1532  C   GLY A 233      73.275  34.658  54.368  1.00 32.15           C  
ATOM   1533  O   GLY A 233      72.046  34.689  54.407  1.00 34.96           O  
ATOM   1534  N   LYS A 234      73.968  33.743  53.685  1.00 36.36           N  
ATOM   1535  CA  LYS A 234      73.307  32.656  52.954  1.00 37.70           C  
ATOM   1536  C   LYS A 234      72.423  31.793  53.855  1.00 37.04           C  
ATOM   1537  O   LYS A 234      71.313  31.437  53.458  1.00 35.45           O  
ATOM   1538  CB  LYS A 234      74.338  31.806  52.214  1.00 40.15           C  
ATOM   1539  CG  LYS A 234      74.959  32.526  51.032  1.00 45.74           C  
ATOM   1540  CD  LYS A 234      76.199  31.799  50.549  1.00 54.74           C  
ATOM   1541  CE  LYS A 234      76.813  32.495  49.341  1.00 61.77           C  
ATOM   1542  NZ  LYS A 234      78.227  32.064  49.104  1.00 66.69           N  
ATOM   1543  N   CYS A 235      72.897  31.512  55.069  1.00 37.19           N  
ATOM   1544  CA  CYS A 235      72.103  30.806  56.088  1.00 37.29           C  
ATOM   1545  C   CYS A 235      70.828  31.532  56.475  1.00 36.64           C  
ATOM   1546  O   CYS A 235      69.772  30.933  56.589  1.00 35.83           O  
ATOM   1547  CB  CYS A 235      72.927  30.593  57.366  1.00 40.27           C  
ATOM   1548  SG  CYS A 235      74.202  29.381  57.170  1.00 48.39           S  
ATOM   1549  N   VAL A 236      70.928  32.838  56.671  1.00 34.98           N  
ATOM   1550  CA  VAL A 236      69.759  33.601  57.055  1.00 36.61           C  
ATOM   1551  C   VAL A 236      68.746  33.602  55.905  1.00 34.07           C  
ATOM   1552  O   VAL A 236      67.535  33.430  56.132  1.00 36.41           O  
ATOM   1553  CB  VAL A 236      70.127  35.004  57.536  1.00 36.66           C  
ATOM   1554  CG1 VAL A 236      68.851  35.759  57.851  1.00 37.94           C  
ATOM   1555  CG2 VAL A 236      71.053  34.926  58.766  1.00 34.52           C  
ATOM   1556  N   VAL A 237      69.227  33.708  54.666  1.00 33.44           N  
ATOM   1557  CA  VAL A 237      68.305  33.651  53.506  1.00 35.32           C  
ATOM   1558  C   VAL A 237      67.640  32.271  53.440  1.00 34.31           C  
ATOM   1559  O   VAL A 237      66.439  32.158  53.216  1.00 36.07           O  
ATOM   1560  CB  VAL A 237      69.009  33.987  52.172  1.00 35.89           C  
ATOM   1561  CG1 VAL A 237      68.049  33.715  50.968  1.00 35.38           C  
ATOM   1562  CG2 VAL A 237      69.514  35.475  52.175  1.00 31.79           C  
ATOM   1563  N   ALA A 238      68.420  31.230  53.688  1.00 34.97           N  
ATOM   1564  CA  ALA A 238      67.907  29.853  53.691  1.00 36.71           C  
ATOM   1565  C   ALA A 238      66.833  29.686  54.778  1.00 36.62           C  
ATOM   1566  O   ALA A 238      65.742  29.162  54.512  1.00 34.93           O  
ATOM   1567  CB  ALA A 238      69.043  28.874  53.901  1.00 36.00           C  
ATOM   1568  N   LEU A 239      67.143  30.145  55.992  1.00 34.29           N  
ATOM   1569  CA  LEU A 239      66.178  30.077  57.102  1.00 33.30           C  
ATOM   1570  C   LEU A 239      64.896  30.836  56.784  1.00 36.59           C  
ATOM   1571  O   LEU A 239      63.799  30.321  56.984  1.00 35.81           O  
ATOM   1572  CB  LEU A 239      66.784  30.632  58.369  1.00 33.84           C  
ATOM   1573  CG  LEU A 239      67.893  29.792  58.992  1.00 38.27           C  
ATOM   1574  CD1 LEU A 239      68.609  30.590  60.055  1.00 32.73           C  
ATOM   1575  CD2 LEU A 239      67.387  28.476  59.560  1.00 40.82           C  
ATOM   1576  N   ALA A 240      65.053  32.046  56.249  1.00 37.85           N  
ATOM   1577  CA  ALA A 240      63.929  32.909  55.936  1.00 38.21           C  
ATOM   1578  C   ALA A 240      63.054  32.404  54.784  1.00 40.17           C  
ATOM   1579  O   ALA A 240      61.946  32.888  54.601  1.00 46.64           O  
ATOM   1580  CB  ALA A 240      64.426  34.311  55.623  1.00 36.63           C  
ATOM   1581  N   THR A 241      63.549  31.461  53.999  1.00 41.77           N  
ATOM   1582  CA  THR A 241      62.767  30.921  52.879  1.00 39.83           C  
ATOM   1583  C   THR A 241      62.411  29.432  53.067  1.00 41.48           C  
ATOM   1584  O   THR A 241      61.914  28.797  52.151  1.00 37.64           O  
ATOM   1585  CB  THR A 241      63.496  31.126  51.553  1.00 38.82           C  
ATOM   1586  OG1 THR A 241      64.783  30.517  51.609  1.00 36.78           O  
ATOM   1587  CG2 THR A 241      63.655  32.620  51.248  1.00 42.96           C  
ATOM   1588  N   ASP A 242      62.652  28.908  54.264  1.00 38.10           N  
ATOM   1589  CA  ASP A 242      62.362  27.509  54.601  1.00 35.41           C  
ATOM   1590  C   ASP A 242      60.917  27.423  55.047  1.00 38.03           C  
ATOM   1591  O   ASP A 242      60.552  27.990  56.064  1.00 34.76           O  
ATOM   1592  CB  ASP A 242      63.284  27.068  55.740  1.00 39.17           C  
ATOM   1593  CG  ASP A 242      63.223  25.574  56.026  1.00 45.92           C  
ATOM   1594  OD1 ASP A 242      62.218  24.903  55.683  1.00 42.75           O  
ATOM   1595  OD2 ASP A 242      64.215  25.078  56.615  1.00 42.27           O  
ATOM   1596  N   PRO A 243      60.076  26.709  54.292  1.00 39.46           N  
ATOM   1597  CA  PRO A 243      58.680  26.519  54.698  1.00 40.06           C  
ATOM   1598  C   PRO A 243      58.518  25.824  56.047  1.00 39.56           C  
ATOM   1599  O   PRO A 243      57.479  25.963  56.682  1.00 39.36           O  
ATOM   1600  CB  PRO A 243      58.119  25.599  53.609  1.00 39.95           C  
ATOM   1601  CG  PRO A 243      59.031  25.738  52.472  1.00 43.95           C  
ATOM   1602  CD  PRO A 243      60.377  26.003  53.030  1.00 42.48           C  
ATOM   1603  N   ASN A 244      59.536  25.074  56.464  1.00 35.79           N  
ATOM   1604  CA  ASN A 244      59.517  24.349  57.726  1.00 36.29           C  
ATOM   1605  C   ASN A 244      60.292  25.044  58.842  1.00 36.43           C  
ATOM   1606  O   ASN A 244      60.740  24.405  59.794  1.00 39.04           O  
ATOM   1607  CB  ASN A 244      60.096  22.968  57.500  1.00 38.02           C  
ATOM   1608  CG  ASN A 244      59.215  22.133  56.600  1.00 46.15           C  
ATOM   1609  OD1 ASN A 244      57.996  22.301  56.587  1.00 52.56           O  
ATOM   1610  ND2 ASN A 244      59.820  21.245  55.835  1.00 49.51           N  
ATOM   1611  N   ILE A 245      60.446  26.352  58.714  1.00 37.45           N  
ATOM   1612  CA  ILE A 245      61.272  27.121  59.650  1.00 36.96           C  
ATOM   1613  C   ILE A 245      60.800  26.959  61.118  1.00 36.20           C  
ATOM   1614  O   ILE A 245      61.612  26.910  62.052  1.00 34.13           O  
ATOM   1615  CB  ILE A 245      61.326  28.618  59.204  1.00 36.65           C  
ATOM   1616  CG1 ILE A 245      62.286  29.441  60.083  1.00 34.12           C  
ATOM   1617  CG2 ILE A 245      59.933  29.215  59.177  1.00 35.68           C  
ATOM   1618  CD1 ILE A 245      63.701  28.821  60.256  1.00 32.53           C  
ATOM   1619  N   LEU A 246      59.493  26.847  61.319  1.00 35.43           N  
ATOM   1620  CA  LEU A 246      58.957  26.727  62.679  1.00 41.00           C  
ATOM   1621  C   LEU A 246      59.484  25.499  63.401  1.00 39.14           C  
ATOM   1622  O   LEU A 246      59.608  25.507  64.623  1.00 39.06           O  
ATOM   1623  CB  LEU A 246      57.422  26.739  62.656  1.00 43.98           C  
ATOM   1624  CG  LEU A 246      56.616  27.228  63.867  1.00 44.74           C  
ATOM   1625  CD1 LEU A 246      57.072  28.541  64.485  1.00 41.70           C  
ATOM   1626  CD2 LEU A 246      55.159  27.329  63.371  1.00 48.16           C  
ATOM   1627  N   SER A 247      59.816  24.442  62.660  1.00 38.77           N  
ATOM   1628  CA  SER A 247      60.381  23.250  63.280  1.00 35.42           C  
ATOM   1629  C   SER A 247      61.785  23.486  63.878  1.00 38.82           C  
ATOM   1630  O   SER A 247      62.179  22.775  64.785  1.00 38.80           O  
ATOM   1631  CB  SER A 247      60.389  22.064  62.293  1.00 39.90           C  
ATOM   1632  OG  SER A 247      61.381  22.224  61.288  1.00 50.30           O  
ATOM   1633  N   LEU A 248      62.503  24.507  63.405  1.00 34.92           N  
ATOM   1634  CA  LEU A 248      63.810  24.898  63.962  1.00 36.41           C  
ATOM   1635  C   LEU A 248      63.686  25.958  65.065  1.00 33.84           C  
ATOM   1636  O   LEU A 248      64.662  26.291  65.737  1.00 31.97           O  
ATOM   1637  CB  LEU A 248      64.706  25.437  62.843  1.00 35.66           C  
ATOM   1638  CG  LEU A 248      64.923  24.487  61.655  1.00 41.44           C  
ATOM   1639  CD1 LEU A 248      65.705  25.187  60.533  1.00 41.76           C  
ATOM   1640  CD2 LEU A 248      65.633  23.224  62.137  1.00 42.48           C  
ATOM   1641  N   SER A 249      62.482  26.514  65.233  1.00 36.01           N  
ATOM   1642  CA  SER A 249      62.298  27.593  66.194  1.00 33.66           C  
ATOM   1643  C   SER A 249      62.701  27.164  67.607  1.00 35.10           C  
ATOM   1644  O   SER A 249      62.337  26.075  68.046  1.00 34.80           O  
ATOM   1645  CB  SER A 249      60.863  28.109  66.215  1.00 36.27           C  
ATOM   1646  OG  SER A 249      60.821  29.325  66.944  1.00 33.43           O  
ATOM   1647  N   GLY A 250      63.487  28.008  68.267  1.00 35.55           N  
ATOM   1648  CA  GLY A 250      63.913  27.801  69.643  1.00 37.34           C  
ATOM   1649  C   GLY A 250      65.249  27.066  69.703  1.00 41.82           C  
ATOM   1650  O   GLY A 250      65.808  26.886  70.776  1.00 44.53           O  
ATOM   1651  N   LYS A 251      65.773  26.654  68.553  1.00 35.76           N  
ATOM   1652  CA  LYS A 251      67.030  25.924  68.511  1.00 35.02           C  
ATOM   1653  C   LYS A 251      68.265  26.817  68.278  1.00 35.52           C  
ATOM   1654  O   LYS A 251      68.169  27.938  67.741  1.00 35.42           O  
ATOM   1655  CB  LYS A 251      66.947  24.842  67.429  1.00 34.14           C  
ATOM   1656  CG  LYS A 251      65.989  23.715  67.789  1.00 41.63           C  
ATOM   1657  CD  LYS A 251      65.909  22.668  66.696  1.00 40.68           C  
ATOM   1658  CE  LYS A 251      64.959  21.552  67.053  1.00 43.60           C  
ATOM   1659  NZ  LYS A 251      65.153  20.430  66.106  1.00 46.49           N  
ATOM   1660  N   VAL A 252      69.410  26.287  68.700  1.00 32.98           N  
ATOM   1661  CA  VAL A 252      70.742  26.734  68.319  1.00 33.54           C  
ATOM   1662  C   VAL A 252      71.129  26.076  66.984  1.00 33.57           C  
ATOM   1663  O   VAL A 252      71.004  24.838  66.798  1.00 32.70           O  
ATOM   1664  CB  VAL A 252      71.797  26.335  69.389  1.00 34.87           C  
ATOM   1665  CG1 VAL A 252      73.231  26.563  68.853  1.00 38.46           C  
ATOM   1666  CG2 VAL A 252      71.596  27.099  70.691  1.00 34.43           C  
ATOM   1667  N   LEU A 253      71.569  26.916  66.051  1.00 32.48           N  
ATOM   1668  CA  LEU A 253      71.904  26.528  64.684  1.00 34.63           C  
ATOM   1669  C   LEU A 253      73.340  26.971  64.355  1.00 38.53           C  
ATOM   1670  O   LEU A 253      73.561  28.134  64.053  1.00 37.84           O  
ATOM   1671  CB  LEU A 253      70.927  27.204  63.716  1.00 36.97           C  
ATOM   1672  CG  LEU A 253      69.430  26.962  63.960  1.00 38.16           C  
ATOM   1673  CD1 LEU A 253      68.570  27.756  62.991  1.00 38.48           C  
ATOM   1674  CD2 LEU A 253      69.107  25.479  63.891  1.00 36.15           C  
ATOM   1675  N   PRO A 254      74.321  26.056  64.426  1.00 44.14           N  
ATOM   1676  CA  PRO A 254      75.655  26.329  63.845  1.00 43.90           C  
ATOM   1677  C   PRO A 254      75.571  26.547  62.324  1.00 41.40           C  
ATOM   1678  O   PRO A 254      74.940  25.751  61.618  1.00 39.40           O  
ATOM   1679  CB  PRO A 254      76.457  25.056  64.169  1.00 47.94           C  
ATOM   1680  CG  PRO A 254      75.668  24.367  65.304  1.00 47.06           C  
ATOM   1681  CD  PRO A 254      74.244  24.738  65.088  1.00 42.62           C  
ATOM   1682  N   SER A 255      76.170  27.621  61.803  1.00 44.21           N  
ATOM   1683  CA  SER A 255      75.986  27.949  60.367  1.00 46.26           C  
ATOM   1684  C   SER A 255      76.503  26.849  59.426  1.00 47.37           C  
ATOM   1685  O   SER A 255      75.929  26.619  58.347  1.00 49.06           O  
ATOM   1686  CB  SER A 255      76.600  29.313  59.999  1.00 48.91           C  
ATOM   1687  OG  SER A 255      78.000  29.332  60.224  1.00 61.92           O  
ATOM   1688  N   CYS A 256      77.562  26.158  59.833  1.00 50.06           N  
ATOM   1689  CA  CYS A 256      78.106  25.056  59.017  1.00 49.87           C  
ATOM   1690  C   CYS A 256      77.077  23.939  58.780  1.00 48.44           C  
ATOM   1691  O   CYS A 256      76.966  23.439  57.667  1.00 47.58           O  
ATOM   1692  CB  CYS A 256      79.395  24.509  59.624  1.00 53.82           C  
ATOM   1693  SG  CYS A 256      80.845  25.580  59.279  1.00 61.29           S  
ATOM   1694  N   ASP A 257      76.313  23.579  59.814  1.00 46.68           N  
ATOM   1695  CA  ASP A 257      75.226  22.595  59.675  1.00 47.33           C  
ATOM   1696  C   ASP A 257      74.110  23.070  58.745  1.00 45.83           C  
ATOM   1697  O   ASP A 257      73.575  22.279  57.955  1.00 46.88           O  
ATOM   1698  CB  ASP A 257      74.656  22.220  61.046  1.00 48.30           C  
ATOM   1699  CG  ASP A 257      75.618  21.353  61.864  1.00 57.04           C  
ATOM   1700  OD1 ASP A 257      76.371  20.548  61.253  1.00 54.74           O  
ATOM   1701  OD2 ASP A 257      75.613  21.475  63.112  1.00 54.69           O  
ATOM   1702  N   LEU A 258      73.769  24.358  58.817  1.00 45.55           N  
ATOM   1703  CA  LEU A 258      72.731  24.901  57.926  1.00 43.44           C  
ATOM   1704  C   LEU A 258      73.154  24.812  56.464  1.00 43.28           C  
ATOM   1705  O   LEU A 258      72.328  24.528  55.584  1.00 45.32           O  
ATOM   1706  CB  LEU A 258      72.377  26.349  58.297  1.00 43.93           C  
ATOM   1707  CG  LEU A 258      71.723  26.526  59.676  1.00 40.41           C  
ATOM   1708  CD1 LEU A 258      71.473  28.013  59.982  1.00 35.97           C  
ATOM   1709  CD2 LEU A 258      70.441  25.702  59.777  1.00 41.56           C  
ATOM   1710  N   ALA A 259      74.441  25.032  56.210  1.00 42.96           N  
ATOM   1711  CA  ALA A 259      75.003  24.840  54.871  1.00 45.54           C  
ATOM   1712  C   ALA A 259      74.661  23.446  54.371  1.00 47.79           C  
ATOM   1713  O   ALA A 259      74.193  23.281  53.241  1.00 50.71           O  
ATOM   1714  CB  ALA A 259      76.511  25.043  54.889  1.00 45.33           C  
ATOM   1715  N   ARG A 260      74.853  22.453  55.234  1.00 47.28           N  
ATOM   1716  CA  ARG A 260      74.589  21.064  54.863  1.00 48.19           C  
ATOM   1717  C   ARG A 260      73.096  20.840  54.675  1.00 46.85           C  
ATOM   1718  O   ARG A 260      72.678  20.191  53.716  1.00 45.33           O  
ATOM   1719  CB  ARG A 260      75.157  20.113  55.916  1.00 49.54           C  
ATOM   1720  CG  ARG A 260      76.670  20.267  56.115  1.00 55.22           C  
ATOM   1721  CD  ARG A 260      77.230  19.350  57.194  1.00 56.05           C  
ATOM   1722  NE  ARG A 260      78.634  19.652  57.488  1.00 62.61           N  
ATOM   1723  CZ  ARG A 260      79.071  20.466  58.450  1.00 71.31           C  
ATOM   1724  NH1 ARG A 260      78.225  21.084  59.261  1.00 76.48           N  
ATOM   1725  NH2 ARG A 260      80.377  20.656  58.616  1.00 81.11           N  
ATOM   1726  N   ARG A 261      72.294  21.392  55.578  1.00 43.36           N  
ATOM   1727  CA  ARG A 261      70.838  21.286  55.472  1.00 44.96           C  
ATOM   1728  C   ARG A 261      70.352  21.891  54.147  1.00 44.59           C  
ATOM   1729  O   ARG A 261      69.446  21.363  53.512  1.00 43.78           O  
ATOM   1730  CB  ARG A 261      70.170  21.986  56.665  1.00 43.27           C  
ATOM   1731  CG  ARG A 261      68.666  22.197  56.526  1.00 47.11           C  
ATOM   1732  CD  ARG A 261      68.048  22.886  57.756  1.00 48.72           C  
ATOM   1733  NE  ARG A 261      66.604  23.095  57.550  1.00 52.65           N  
ATOM   1734  CZ  ARG A 261      65.641  22.243  57.918  1.00 58.70           C  
ATOM   1735  NH1 ARG A 261      65.925  21.098  58.536  1.00 52.49           N  
ATOM   1736  NH2 ARG A 261      64.369  22.540  57.665  1.00 51.71           N  
ATOM   1737  N   TYR A 262      70.952  23.004  53.738  1.00 46.64           N  
ATOM   1738  CA  TYR A 262      70.468  23.717  52.567  1.00 48.03           C  
ATOM   1739  C   TYR A 262      71.428  23.558  51.397  1.00 49.81           C  
ATOM   1740  O   TYR A 262      71.103  23.989  50.293  1.00 53.76           O  
ATOM   1741  CB  TYR A 262      70.250  25.197  52.894  1.00 47.09           C  
ATOM   1742  CG  TYR A 262      69.239  25.437  53.994  1.00 46.51           C  
ATOM   1743  CD1 TYR A 262      67.880  25.223  53.784  1.00 48.33           C  
ATOM   1744  CD2 TYR A 262      69.639  25.894  55.238  1.00 46.21           C  
ATOM   1745  CE1 TYR A 262      66.952  25.453  54.797  1.00 46.28           C  
ATOM   1746  CE2 TYR A 262      68.726  26.118  56.251  1.00 47.41           C  
ATOM   1747  CZ  TYR A 262      67.389  25.905  56.026  1.00 42.79           C  
ATOM   1748  OH  TYR A 262      66.496  26.134  57.046  1.00 44.47           O  
TER    1749      TYR A 262                                                      
END
MOLECULE T0511.pdb
ATOM   3951  N   MET     1      62.597  29.220  47.107  1.00 30.67           N  
ATOM   3952  CA  MET     1      62.845  29.811  48.467  1.00 29.57           C  
ATOM   3953  C   MET     1      63.620  31.132  48.359  1.00 27.36           C  
ATOM   3954  O   MET     1      64.850  31.137  48.239  1.00 28.85           O  
ATOM   3955  CB  MET     1      63.591  28.807  49.357  1.00 29.94           C  
ATOM   3956  N   THR     2      62.877  32.239  48.391  1.00 25.23           N  
ATOM   3957  CA  THR     2      63.403  33.587  48.132  1.00 22.67           C  
ATOM   3958  C   THR     2      62.942  34.592  49.198  1.00 18.88           C  
ATOM   3959  O   THR     2      61.858  34.461  49.757  1.00 18.29           O  
ATOM   3960  CB  THR     2      62.903  34.135  46.760  1.00 23.35           C  
ATOM   3961  OG1 THR     2      63.359  35.463  46.573  1.00 25.88           O  
ATOM   3962  CG2 THR     2      61.378  34.171  46.691  1.00 26.28           C  
ATOM   3963  N   LEU     3      63.760  35.618  49.440  1.00 15.02           N  
ATOM   3964  CA  LEU     3      63.374  36.703  50.340  1.00 13.66           C  
ATOM   3965  C   LEU     3      62.820  37.921  49.572  1.00 13.56           C  
ATOM   3966  O   LEU     3      62.745  39.020  50.112  1.00 12.43           O  
ATOM   3967  CB  LEU     3      64.547  37.093  51.236  1.00 12.07           C  
ATOM   3968  CG  LEU     3      64.994  35.993  52.218  1.00 11.15           C  
ATOM   3969  CD1 LEU     3      66.181  36.444  53.005  1.00 13.04           C  
ATOM   3970  CD2 LEU     3      63.855  35.585  53.148  1.00 10.48           C  
ATOM   3971  N   SER     4      62.447  37.723  48.314  1.00 14.77           N  
ATOM   3972  CA  SER     4      61.853  38.795  47.519  1.00 15.97           C  
ATOM   3973  C   SER     4      60.660  39.433  48.243  1.00 15.52           C  
ATOM   3974  O   SER     4      59.745  38.745  48.654  1.00 16.06           O  
ATOM   3975  CB  SER     4      61.389  38.288  46.155  1.00 16.75           C  
ATOM   3976  OG  SER     4      60.927  39.377  45.373  1.00 20.08           O  
ATOM   3977  N   GLY     5      60.704  40.757  48.393  1.00 15.66           N  
ATOM   3978  CA  GLY     5      59.619  41.521  48.999  1.00 15.02           C  
ATOM   3979  C   GLY     5      59.535  41.413  50.510  1.00 14.21           C  
ATOM   3980  O   GLY     5      58.676  42.070  51.125  1.00 15.43           O  
ATOM   3981  N   LYS     6      60.352  40.543  51.108  1.00 11.75           N  
ATOM   3982  CA  LYS     6      60.416  40.422  52.563  0.50 11.20           C  
ATOM   3984  C   LYS     6      61.177  41.607  53.131  1.00 12.33           C  
ATOM   3985  O   LYS     6      62.113  42.107  52.491  1.00 12.97           O  
ATOM   3986  CB  LYS     6      61.116  39.131  52.979  0.50 10.32           C  
ATOM   3988  CG  LYS     6      60.442  37.856  52.511  0.50  9.52           C  
ATOM   3990  CD  LYS     6      59.018  37.773  53.017  0.50  8.56           C  
ATOM   3992  CE  LYS     6      58.396  36.430  52.773  0.50  9.59           C  
ATOM   3994  NZ  LYS     6      56.954  36.413  53.165  0.50  8.36           N  
ATOM   3996  N   THR     7      60.795  42.032  54.333  1.00 11.54           N  
ATOM   3997  CA  THR     7      61.404  43.157  54.998  1.00 10.57           C  
ATOM   3998  C   THR     7      62.191  42.674  56.216  1.00 10.31           C  
ATOM   3999  O   THR     7      61.606  42.122  57.185  1.00  8.12           O  
ATOM   4000  CB  THR     7      60.336  44.191  55.400  1.00 10.97           C  
ATOM   4001  OG1 THR     7      59.628  44.627  54.224  1.00 11.12           O  
ATOM   4002  CG2 THR     7      60.981  45.397  56.117  1.00 11.35           C  
ATOM   4003  N   LEU     8      63.515  42.880  56.149  1.00  9.48           N  
ATOM   4004  CA  LEU     8      64.441  42.550  57.221  1.00  9.12           C  
ATOM   4005  C   LEU     8      64.855  43.800  57.995  1.00 10.02           C  
ATOM   4006  O   LEU     8      65.154  44.847  57.421  1.00  9.93           O  
ATOM   4007  CB  LEU     8      65.726  41.895  56.666  1.00  8.69           C  
ATOM   4008  CG  LEU     8      65.617  40.506  56.031  1.00  8.91           C  
ATOM   4009  CD1 LEU     8      64.948  40.526  54.667  1.00  9.80           C  
ATOM   4010  CD2 LEU     8      67.019  39.850  55.945  1.00 10.15           C  
ATOM   4011  N   PHE     9      64.864  43.671  59.311  1.00 10.64           N  
ATOM   4012  CA  PHE     9      65.393  44.701  60.193  1.00  9.82           C  
ATOM   4013  C   PHE     9      66.642  44.075  60.792  1.00 10.33           C  
ATOM   4014  O   PHE     9      66.556  43.086  61.518  1.00  9.34           O  
ATOM   4015  CB  PHE     9      64.353  45.039  61.271  1.00 11.76           C  
ATOM   4016  CG  PHE     9      64.736  46.193  62.169  1.00 11.01           C  
ATOM   4017  CD1 PHE     9      64.214  47.476  61.952  1.00 11.20           C  
ATOM   4018  CD2 PHE     9      65.612  45.997  63.246  1.00 11.20           C  
ATOM   4019  CE1 PHE     9      64.545  48.541  62.804  1.00 12.34           C  
ATOM   4020  CE2 PHE     9      65.972  47.059  64.072  1.00 11.47           C  
ATOM   4021  CZ  PHE     9      65.421  48.337  63.851  1.00 12.34           C  
ATOM   4022  N   ILE    10      67.804  44.632  60.449  1.00  9.68           N  
ATOM   4023  CA  ILE    10      69.085  44.043  60.842  1.00  8.82           C  
ATOM   4024  C   ILE    10      69.875  45.048  61.639  1.00  9.31           C  
ATOM   4025  O   ILE    10      70.190  46.135  61.158  1.00  8.86           O  
ATOM   4026  CB  ILE    10      69.954  43.569  59.614  1.00  8.91           C  
ATOM   4027  CG1 ILE    10      69.161  42.655  58.682  1.00  9.64           C  
ATOM   4028  CG2 ILE    10      71.253  42.869  60.098  1.00  9.55           C  
ATOM   4029  CD1 ILE    10      69.891  42.285  57.434  1.00  8.87           C  
ATOM   4030  N   THR    11      70.176  44.703  62.881  1.00  9.12           N  
ATOM   4031  CA  THR    11      71.002  45.584  63.719  1.00 10.75           C  
ATOM   4032  C   THR    11      72.490  45.424  63.375  1.00 10.49           C  
ATOM   4033  O   THR    11      72.965  44.333  63.011  1.00 12.33           O  
ATOM   4034  CB  THR    11      70.774  45.336  65.236  1.00 11.13           C  
ATOM   4035  OG1 THR    11      71.224  44.025  65.597  1.00  9.91           O  
ATOM   4036  CG2 THR    11      69.289  45.513  65.589  1.00 11.16           C  
ATOM   4037  N   GLY    12      73.205  46.541  63.433  1.00 11.26           N  
ATOM   4038  CA  GLY    12      74.650  46.585  63.240  1.00 11.66           C  
ATOM   4039  C   GLY    12      75.115  46.237  61.835  1.00 12.20           C  
ATOM   4040  O   GLY    12      76.236  45.796  61.663  1.00 14.31           O  
ATOM   4041  N   ALA    13      74.276  46.482  60.830  1.00 10.74           N  
ATOM   4042  CA  ALA    13      74.524  46.028  59.465  1.00 10.80           C  
ATOM   4043  C   ALA    13      75.251  47.052  58.569  1.00  9.89           C  
ATOM   4044  O   ALA    13      75.175  46.977  57.349  1.00 10.74           O  
ATOM   4045  CB  ALA    13      73.213  45.535  58.805  1.00 12.85           C  
ATOM   4046  N   SER    14      75.957  47.997  59.175  1.00 12.09           N  
ATOM   4047  CA  SER    14      76.826  48.908  58.410  1.00 13.18           C  
ATOM   4048  C   SER    14      78.103  48.221  57.906  1.00 13.87           C  
ATOM   4049  O   SER    14      78.781  48.720  56.992  1.00 14.18           O  
ATOM   4050  CB  SER    14      77.178  50.138  59.246  1.00 14.38           C  
ATOM   4051  OG  SER    14      77.783  49.759  60.460  1.00 17.14           O  
ATOM   4052  N   ARG    15      78.431  47.075  58.494  1.00 13.35           N  
ATOM   4053  CA  ARG    15      79.640  46.338  58.149  1.00 13.18           C  
ATOM   4054  C   ARG    15      79.528  44.878  58.620  1.00 13.07           C  
ATOM   4055  O   ARG    15      78.533  44.479  59.249  1.00 11.22           O  
ATOM   4056  CB  ARG    15      80.874  47.012  58.788  1.00 14.09           C  
ATOM   4057  CG  ARG    15      80.918  46.971  60.285  1.00 14.31           C  
ATOM   4058  CD  ARG    15      82.066  47.857  60.818  1.00 17.37           C  
ATOM   4059  NE  ARG    15      81.762  49.280  60.653  1.00 20.79           N  
ATOM   4060  CZ  ARG    15      81.012  49.990  61.486  1.00 20.72           C  
ATOM   4061  NH1 ARG    15      80.496  49.435  62.579  1.00 22.67           N  
ATOM   4062  NH2 ARG    15      80.782  51.263  61.236  1.00 20.56           N  
ATOM   4063  N   GLY    16      80.556  44.099  58.288  1.00 11.96           N  
ATOM   4064  CA  GLY    16      80.736  42.761  58.825  1.00 12.69           C  
ATOM   4065  C   GLY    16      79.604  41.803  58.491  1.00 10.91           C  
ATOM   4066  O   GLY    16      79.052  41.809  57.374  1.00 10.91           O  
ATOM   4067  N   ILE    17      79.280  40.958  59.460  1.00 11.51           N  
ATOM   4068  CA  ILE    17      78.291  39.912  59.250  1.00  9.32           C  
ATOM   4069  C   ILE    17      76.913  40.500  58.910  1.00  8.38           C  
ATOM   4070  O   ILE    17      76.253  40.004  58.023  1.00  7.43           O  
ATOM   4071  CB  ILE    17      78.222  38.953  60.470  1.00  9.84           C  
ATOM   4072  CG1 ILE    17      79.519  38.155  60.560  1.00 10.94           C  
ATOM   4073  CG2 ILE    17      77.030  37.970  60.375  1.00 10.76           C  
ATOM   4074  CD1 ILE    17      79.657  37.339  61.859  1.00 12.58           C  
ATOM   4075  N   GLY    18      76.494  41.539  59.618  1.00  8.76           N  
ATOM   4076  CA  GLY    18      75.170  42.138  59.368  1.00  8.15           C  
ATOM   4077  C   GLY    18      75.044  42.616  57.936  1.00  7.27           C  
ATOM   4078  O   GLY    18      74.060  42.340  57.263  1.00  8.56           O  
ATOM   4079  N   LEU    19      76.062  43.340  57.467  1.00  7.75           N  
ATOM   4080  CA  LEU    19      76.102  43.810  56.092  1.00  9.23           C  
ATOM   4081  C   LEU    19      76.014  42.632  55.116  1.00  8.73           C  
ATOM   4082  O   LEU    19      75.266  42.671  54.144  1.00  9.26           O  
ATOM   4083  CB  LEU    19      77.365  44.651  55.841  1.00  8.49           C  
ATOM   4084  CG  LEU    19      77.475  45.222  54.395  1.00  8.05           C  
ATOM   4085  CD1 LEU    19      76.268  46.087  54.030  1.00 11.07           C  
ATOM   4086  CD2 LEU    19      78.799  45.972  54.238  1.00 11.71           C  
ATOM   4087  N   ALA    20      76.790  41.575  55.363  1.00  8.21           N  
ATOM   4088  CA  ALA    20      76.818  40.418  54.466  1.00  8.31           C  
ATOM   4089  C   ALA    20      75.430  39.785  54.378  1.00  7.74           C  
ATOM   4090  O   ALA    20      74.958  39.458  53.296  1.00  8.04           O  
ATOM   4091  CB  ALA    20      77.848  39.389  54.944  1.00  9.02           C  
ATOM   4092  N   ILE    21      74.772  39.669  55.523  1.00  8.02           N  
ATOM   4093  CA  ILE    21      73.404  39.147  55.571  1.00  8.70           C  
ATOM   4094  C   ILE    21      72.490  40.086  54.769  1.00  8.63           C  
ATOM   4095  O   ILE    21      71.714  39.628  53.907  1.00  8.84           O  
ATOM   4096  CB  ILE    21      72.906  38.984  57.042  1.00  9.05           C  
ATOM   4097  CG1 ILE    21      73.668  37.891  57.784  1.00  7.45           C  
ATOM   4098  CG2 ILE    21      71.394  38.697  57.078  1.00  9.46           C  
ATOM   4099  CD1 ILE    21      73.339  37.846  59.303  1.00  8.85           C  
ATOM   4100  N   ALA    22      72.600  41.392  55.039  1.00  9.08           N  
ATOM   4101  CA  ALA    22      71.824  42.423  54.318  1.00  9.76           C  
ATOM   4102  C   ALA    22      71.958  42.242  52.788  1.00  8.59           C  
ATOM   4103  O   ALA    22      70.958  42.201  52.041  1.00  9.38           O  
ATOM   4104  CB  ALA    22      72.254  43.834  54.777  1.00  7.10           C  
ATOM   4105  N   LEU    23      73.188  42.058  52.311  1.00  8.83           N  
ATOM   4106  CA  LEU    23      73.424  41.979  50.858  1.00  9.35           C  
ATOM   4107  C   LEU    23      72.947  40.652  50.243  1.00  8.93           C  
ATOM   4108  O   LEU    23      72.440  40.619  49.090  1.00  8.82           O  
ATOM   4109  CB  LEU    23      74.888  42.229  50.554  1.00  9.38           C  
ATOM   4110  CG  LEU    23      75.440  43.596  50.959  1.00  9.38           C  
ATOM   4111  CD1 LEU    23      76.913  43.699  50.547  1.00 11.14           C  
ATOM   4112  CD2 LEU    23      74.585  44.776  50.392  1.00 12.49           C  
ATOM   4113  N   ARG    24      73.082  39.565  50.998  1.00  6.98           N  
ATOM   4114  CA  ARG    24      72.578  38.277  50.524  1.00 10.03           C  
ATOM   4115  C   ARG    24      71.052  38.351  50.351  1.00  9.92           C  
ATOM   4116  O   ARG    24      70.492  37.887  49.372  1.00 10.75           O  
ATOM   4117  CB  ARG    24      72.987  37.137  51.457  1.00 10.79           C  
ATOM   4118  CG  ARG    24      72.449  35.755  51.043  1.00 11.75           C  
ATOM   4119  CD  ARG    24      72.954  35.280  49.687  1.00 13.28           C  
ATOM   4120  NE  ARG    24      72.271  34.075  49.201  1.00 14.92           N  
ATOM   4121  CZ  ARG    24      71.136  34.057  48.499  1.00 13.41           C  
ATOM   4122  NH1 ARG    24      70.480  35.166  48.186  1.00 14.16           N  
ATOM   4123  NH2 ARG    24      70.644  32.898  48.090  1.00 15.36           N  
ATOM   4124  N   ALA    25      70.367  38.988  51.291  1.00  8.74           N  
ATOM   4125  CA  ALA    25      68.899  39.152  51.191  1.00  9.90           C  
ATOM   4126  C   ALA    25      68.517  40.102  50.028  1.00  9.92           C  
ATOM   4127  O   ALA    25      67.538  39.866  49.286  1.00 11.82           O  
ATOM   4128  CB  ALA    25      68.380  39.677  52.518  1.00  9.28           C  
ATOM   4129  N   ALA    26      69.281  41.190  49.901  1.00  9.89           N  
ATOM   4130  CA  ALA    26      69.099  42.193  48.822  1.00 10.10           C  
ATOM   4131  C   ALA    26      69.116  41.544  47.458  1.00 10.34           C  
ATOM   4132  O   ALA    26      68.316  41.889  46.578  1.00 11.34           O  
ATOM   4133  CB  ALA    26      70.148  43.259  48.872  1.00  9.94           C  
ATOM   4134  N   ARG    27      70.003  40.570  47.281  1.00 11.84           N  
ATOM   4135  CA  ARG    27      70.155  39.864  46.000  1.00 13.94           C  
ATOM   4136  C   ARG    27      68.850  39.211  45.538  1.00 14.38           C  
ATOM   4137  O   ARG    27      68.580  39.114  44.346  1.00 15.05           O  
ATOM   4138  CB  ARG    27      71.266  38.815  46.191  1.00 15.14           C  
ATOM   4139  CG  ARG    27      71.710  38.069  45.005  1.00 21.23           C  
ATOM   4140  CD  ARG    27      73.119  37.495  45.280  1.00 26.32           C  
ATOM   4141  NE  ARG    27      73.145  36.075  45.602  1.00 28.22           N  
ATOM   4142  CZ  ARG    27      74.087  35.472  46.333  1.00 29.94           C  
ATOM   4143  NH1 ARG    27      75.079  36.153  46.912  1.00 32.75           N  
ATOM   4144  NH2 ARG    27      74.015  34.172  46.523  1.00 31.76           N  
ATOM   4145  N   ASP    28      68.049  38.792  46.506  1.00 13.10           N  
ATOM   4146  CA  ASP    28      66.720  38.247  46.269  1.00 12.77           C  
ATOM   4147  C   ASP    28      65.638  39.307  46.007  1.00 12.75           C  
ATOM   4148  O   ASP    28      64.503  38.943  45.651  1.00 13.44           O  
ATOM   4149  CB  ASP    28      66.255  37.451  47.495  1.00 13.05           C  
ATOM   4150  CG  ASP    28      66.843  36.066  47.599  1.00 13.32           C  
ATOM   4151  OD1 ASP    28      67.775  35.704  46.843  1.00 14.41           O  
ATOM   4152  OD2 ASP    28      66.355  35.322  48.480  1.00 12.54           O  
ATOM   4153  N   GLY    29      65.935  40.587  46.231  1.00 10.11           N  
ATOM   4154  CA  GLY    29      64.912  41.654  46.146  1.00  9.93           C  
ATOM   4155  C   GLY    29      64.262  41.985  47.473  1.00 10.64           C  
ATOM   4156  O   GLY    29      63.130  42.494  47.518  1.00 12.32           O  
ATOM   4157  N   ALA    30      64.952  41.686  48.574  1.00  9.58           N  
ATOM   4158  CA  ALA    30      64.396  41.970  49.897  1.00  9.95           C  
ATOM   4159  C   ALA    30      64.521  43.470  50.182  1.00 10.01           C  
ATOM   4160  O   ALA    30      65.433  44.163  49.651  1.00  9.43           O  
ATOM   4161  CB  ALA    30      65.097  41.183  50.977  1.00  9.59           C  
ATOM   4162  N   ASN    31      63.610  43.950  51.029  1.00  9.52           N  
ATOM   4163  CA  ASN    31      63.752  45.233  51.686  1.00  9.86           C  
ATOM   4164  C   ASN    31      64.600  45.024  52.924  1.00  8.84           C  
ATOM   4165  O   ASN    31      64.373  44.084  53.690  1.00 10.54           O  
ATOM   4166  CB  ASN    31      62.386  45.773  52.119  1.00 10.20           C  
ATOM   4167  CG  ASN    31      61.383  45.795  50.986  1.00  9.19           C  
ATOM   4168  OD1 ASN    31      61.670  46.332  49.919  1.00 10.33           O  
ATOM   4169  ND2 ASN    31      60.167  45.261  51.237  1.00 10.75           N  
ATOM   4170  N   VAL    32      65.590  45.887  53.116  1.00  9.95           N  
ATOM   4171  CA  VAL    32      66.461  45.789  54.290  1.00  9.69           C  
ATOM   4172  C   VAL    32      66.596  47.133  55.012  1.00 10.30           C  
ATOM   4173  O   VAL    32      67.058  48.133  54.432  1.00 12.03           O  
ATOM   4174  CB  VAL    32      67.879  45.251  53.949  1.00  9.18           C  
ATOM   4175  CG1 VAL    32      68.643  44.975  55.249  1.00 11.10           C  
ATOM   4176  CG2 VAL    32      67.819  43.969  53.119  1.00 10.00           C  
ATOM   4177  N   ALA    33      66.191  47.150  56.277  1.00  9.49           N  
ATOM   4178  CA  ALA    33      66.381  48.263  57.162  1.00  9.13           C  
ATOM   4179  C   ALA    33      67.703  48.031  57.943  1.00 11.03           C  
ATOM   4180  O   ALA    33      67.848  47.054  58.690  1.00 10.96           O  
ATOM   4181  CB  ALA    33      65.140  48.420  58.106  1.00 10.39           C  
ATOM   4182  N   ILE    34      68.660  48.914  57.698  1.00  9.27           N  
ATOM   4183  CA  ILE    34      69.978  48.897  58.327  1.00 10.73           C  
ATOM   4184  C   ILE    34      69.911  49.779  59.555  1.00 10.74           C  
ATOM   4185  O   ILE    34      69.866  51.014  59.440  1.00 11.32           O  
ATOM   4186  CB  ILE    34      71.055  49.446  57.365  1.00 11.56           C  
ATOM   4187  CG1 ILE    34      71.079  48.663  56.046  1.00 12.76           C  
ATOM   4188  CG2 ILE    34      72.425  49.488  58.059  1.00 11.82           C  
ATOM   4189  CD1 ILE    34      71.623  47.273  56.171  1.00 15.51           C  
ATOM   4190  N   ALA    35      69.864  49.164  60.736  1.00 10.80           N  
ATOM   4191  CA  ALA    35      69.718  49.912  61.976  1.00 11.12           C  
ATOM   4192  C   ALA    35      71.054  49.915  62.714  1.00 12.35           C  
ATOM   4193  O   ALA    35      71.424  48.949  63.376  1.00 13.49           O  
ATOM   4194  CB  ALA    35      68.600  49.344  62.835  1.00 10.58           C  
ATOM   4195  N   ALA    36      71.772  51.019  62.600  1.00 12.61           N  
ATOM   4196  CA  ALA    36      73.119  51.086  63.144  1.00 13.43           C  
ATOM   4197  C   ALA    36      73.496  52.524  63.496  1.00 13.74           C  
ATOM   4198  O   ALA    36      72.828  53.477  63.065  1.00 11.72           O  
ATOM   4199  CB  ALA    36      74.102  50.509  62.158  1.00 11.42           C  
ATOM   4200  N   LYS    37      74.546  52.664  64.302  1.00 15.75           N  
ATOM   4201  CA  LYS    37      74.869  53.965  64.885  1.00 18.51           C  
ATOM   4202  C   LYS    37      75.644  54.902  63.963  1.00 18.21           C  
ATOM   4203  O   LYS    37      75.478  56.117  64.075  1.00 20.01           O  
ATOM   4204  CB  LYS    37      75.588  53.840  66.239  1.00 19.73           C  
ATOM   4205  CG  LYS    37      76.782  52.938  66.266  1.00 23.33           C  
ATOM   4206  CD  LYS    37      77.700  53.212  67.466  1.00 23.66           C  
ATOM   4207  CE  LYS    37      76.944  53.327  68.751  1.00 26.80           C  
ATOM   4208  NZ  LYS    37      76.411  54.714  68.945  1.00 28.42           N  
ATOM   4209  N   SER    38      76.463  54.352  63.059  1.00 18.12           N  
ATOM   4210  CA  SER    38      77.373  55.149  62.238  1.00 18.53           C  
ATOM   4211  C   SER    38      76.720  55.723  60.995  1.00 16.90           C  
ATOM   4212  O   SER    38      76.342  54.974  60.108  1.00 15.01           O  
ATOM   4213  CB  SER    38      78.574  54.307  61.790  1.00 19.20           C  
ATOM   4214  OG  SER    38      79.300  53.812  62.899  1.00 23.44           O  
ATOM   4215  N   ALA    39      76.652  57.057  60.934  1.00 17.63           N  
ATOM   4216  CA  ALA    39      76.100  57.802  59.800  1.00 17.44           C  
ATOM   4217  C   ALA    39      77.184  58.388  58.894  1.00 16.14           C  
ATOM   4218  O   ALA    39      76.980  58.563  57.700  1.00 16.68           O  
ATOM   4219  CB  ALA    39      75.168  58.905  60.301  1.00 18.43           C  
ATOM   4220  N   VAL    40      78.356  58.669  59.449  1.00 17.49           N  
ATOM   4221  CA  VAL    40      79.479  59.194  58.661  1.00 18.46           C  
ATOM   4222  C   VAL    40      80.694  58.310  58.896  1.00 20.70           C  
ATOM   4223  O   VAL    40      80.839  57.741  59.976  1.00 21.01           O  
ATOM   4224  CB  VAL    40      79.805  60.654  59.054  1.00 18.94           C  
ATOM   4225  CG1 VAL    40      78.557  61.514  58.972  1.00 17.23           C  
ATOM   4226  CG2 VAL    40      80.365  60.716  60.433  1.00 21.03           C  
ATOM   4227  N   ALA    41      81.549  58.211  57.880  1.00 23.79           N  
ATOM   4228  CA  ALA    41      82.672  57.275  57.846  1.00 27.02           C  
ATOM   4229  C   ALA    41      83.886  57.766  58.628  1.00 30.16           C  
ATOM   4230  O   ALA    41      84.101  58.958  58.765  1.00 29.60           O  
ATOM   4231  CB  ALA    41      83.078  57.029  56.414  1.00 26.45           C  
ATOM   4232  N   ASN    42      84.686  56.826  59.121  1.00 34.39           N  
ATOM   4233  CA  ASN    42      85.982  57.137  59.736  1.00 37.35           C  
ATOM   4234  C   ASN    42      87.024  56.189  59.163  1.00 37.86           C  
ATOM   4235  O   ASN    42      86.663  55.114  58.676  1.00 37.47           O  
ATOM   4236  CB  ASN    42      85.905  56.978  61.255  1.00 38.97           C  
ATOM   4237  CG  ASN    42      85.984  55.535  61.686  1.00 41.85           C  
ATOM   4238  OD1 ASN    42      85.250  54.679  61.176  1.00 45.32           O  
ATOM   4239  ND2 ASN    42      86.880  55.246  62.619  1.00 44.83           N  
ATOM   4240  N   PRO    43      88.319  56.571  59.222  1.00 39.25           N  
ATOM   4241  CA  PRO    43      89.357  55.734  58.596  1.00 39.71           C  
ATOM   4242  C   PRO    43      89.487  54.349  59.225  1.00 40.22           C  
ATOM   4243  O   PRO    43      89.883  53.401  58.539  1.00 41.70           O  
ATOM   4244  CB  PRO    43      90.651  56.529  58.828  1.00 40.04           C  
ATOM   4245  CG  PRO    43      90.363  57.413  59.989  1.00 40.12           C  
ATOM   4246  CD  PRO    43      88.895  57.761  59.874  1.00 39.62           C  
ATOM   4247  N   LYS    44      89.146  54.243  60.511  1.00 40.29           N  
ATOM   4248  CA  LYS    44      89.455  53.057  61.315  1.00 40.44           C  
ATOM   4249  C   LYS    44      88.515  51.890  61.049  1.00 40.27           C  
ATOM   4250  O   LYS    44      88.956  50.741  60.928  1.00 41.53           O  
ATOM   4251  CB  LYS    44      89.431  53.404  62.812  1.00 40.80           C  
ATOM   4252  N   LEU    45      87.222  52.178  60.972  1.00 39.05           N  
ATOM   4253  CA  LEU    45      86.218  51.131  60.866  1.00 37.50           C  
ATOM   4254  C   LEU    45      85.167  51.541  59.838  1.00 35.61           C  
ATOM   4255  O   LEU    45      84.102  52.037  60.207  1.00 36.83           O  
ATOM   4256  CB  LEU    45      85.583  50.908  62.238  1.00 38.08           C  
ATOM   4257  CG  LEU    45      84.656  49.705  62.386  1.00 39.22           C  
ATOM   4258  CD1 LEU    45      85.288  48.424  61.838  1.00 39.99           C  
ATOM   4259  CD2 LEU    45      84.277  49.533  63.845  1.00 40.21           C  
ATOM   4260  N   PRO    46      85.479  51.367  58.541  1.00 32.57           N  
ATOM   4261  CA  PRO    46      84.580  51.804  57.478  1.00 29.62           C  
ATOM   4262  C   PRO    46      83.181  51.163  57.498  1.00 25.47           C  
ATOM   4263  O   PRO    46      82.966  50.062  58.098  1.00 22.97           O  
ATOM   4264  CB  PRO    46      85.322  51.403  56.192  1.00 30.51           C  
ATOM   4265  CG  PRO    46      86.752  51.314  56.592  1.00 31.69           C  
ATOM   4266  CD  PRO    46      86.721  50.787  57.993  1.00 32.59           C  
ATOM   4267  N   GLY    47      82.267  51.872  56.828  1.00 20.24           N  
ATOM   4268  CA  GLY    47      80.893  51.466  56.666  1.00 17.13           C  
ATOM   4269  C   GLY    47      79.945  52.339  57.470  1.00 14.78           C  
ATOM   4270  O   GLY    47      80.178  52.610  58.646  1.00 14.21           O  
ATOM   4271  N   THR    48      78.845  52.748  56.854  1.00 12.11           N  
ATOM   4272  CA  THR    48      77.836  53.553  57.539  1.00 11.85           C  
ATOM   4273  C   THR    48      76.458  52.991  57.179  1.00 10.89           C  
ATOM   4274  O   THR    48      76.335  52.132  56.293  1.00 10.28           O  
ATOM   4275  CB  THR    48      77.887  55.017  57.087  1.00 11.91           C  
ATOM   4276  OG1 THR    48      77.440  55.084  55.728  1.00 11.31           O  
ATOM   4277  CG2 THR    48      79.309  55.580  57.219  1.00 10.23           C  
ATOM   4278  N   ILE    49      75.412  53.500  57.823  1.00 10.85           N  
ATOM   4279  CA  ILE    49      74.050  53.133  57.457  1.00 11.77           C  
ATOM   4280  C   ILE    49      73.758  53.496  55.991  1.00 11.48           C  
ATOM   4281  O   ILE    49      73.063  52.789  55.301  1.00 10.88           O  
ATOM   4282  CB  ILE    49      73.019  53.765  58.417  1.00 11.13           C  
ATOM   4283  CG1 ILE    49      73.116  55.306  58.420  1.00 10.53           C  
ATOM   4284  CG2 ILE    49      73.243  53.212  59.835  1.00 10.06           C  
ATOM   4285  CD1 ILE    49      72.142  56.006  59.385  1.00 12.06           C  
ATOM   4286  N   HIS    50      74.347  54.586  55.520  1.00 10.00           N  
ATOM   4287  CA  HIS    50      74.122  55.053  54.160  1.00 10.47           C  
ATOM   4288  C   HIS    50      74.872  54.216  53.113  1.00 10.35           C  
ATOM   4289  O   HIS    50      74.304  53.925  52.051  1.00 11.27           O  
ATOM   4290  CB  HIS    50      74.479  56.543  54.077  1.00 10.80           C  
ATOM   4291  CG  HIS    50      73.675  57.392  55.011  1.00 10.97           C  
ATOM   4292  ND1 HIS    50      72.304  57.486  54.923  1.00 12.42           N  
ATOM   4293  CD2 HIS    50      74.036  58.151  56.066  1.00 12.09           C  
ATOM   4294  CE1 HIS    50      71.858  58.265  55.888  1.00 12.60           C  
ATOM   4295  NE2 HIS    50      72.886  58.688  56.595  1.00 14.34           N  
ATOM   4296  N   SER    51      76.128  53.849  53.374  1.00 11.13           N  
ATOM   4297  CA  SER    51      76.866  53.008  52.407  1.00 11.05           C  
ATOM   4298  C   SER    51      76.184  51.617  52.353  1.00  9.62           C  
ATOM   4299  O   SER    51      76.037  51.007  51.281  1.00  9.84           O  
ATOM   4300  CB  SER    51      78.361  52.883  52.733  1.00 12.34           C  
ATOM   4301  OG  SER    51      78.583  52.345  54.001  1.00 11.91           O  
ATOM   4302  N   ALA    52      75.734  51.137  53.502  1.00  9.54           N  
ATOM   4303  CA  ALA    52      75.072  49.824  53.556  1.00  8.67           C  
ATOM   4304  C   ALA    52      73.733  49.851  52.804  1.00  9.08           C  
ATOM   4305  O   ALA    52      73.465  48.990  51.965  1.00 10.29           O  
ATOM   4306  CB  ALA    52      74.886  49.382  54.995  1.00  9.27           C  
ATOM   4307  N   ALA    53      72.915  50.878  53.043  1.00  9.71           N  
ATOM   4308  CA  ALA    53      71.666  51.040  52.278  1.00 10.36           C  
ATOM   4309  C   ALA    53      71.901  51.167  50.763  1.00  9.96           C  
ATOM   4310  O   ALA    53      71.181  50.566  49.976  1.00 11.61           O  
ATOM   4311  CB  ALA    53      70.844  52.230  52.790  1.00 10.97           C  
ATOM   4312  N   ALA    54      72.926  51.924  50.366  1.00 11.88           N  
ATOM   4313  CA  ALA    54      73.297  52.057  48.954  1.00 12.31           C  
ATOM   4314  C   ALA    54      73.722  50.707  48.347  1.00 11.30           C  
ATOM   4315  O   ALA    54      73.353  50.386  47.208  1.00 10.08           O  
ATOM   4316  CB  ALA    54      74.431  53.098  48.806  1.00 12.56           C  
ATOM   4317  N   ALA    55      74.509  49.940  49.112  1.00 10.85           N  
ATOM   4318  CA  ALA    55      74.954  48.592  48.703  1.00  9.92           C  
ATOM   4319  C   ALA    55      73.773  47.608  48.516  1.00 10.77           C  
ATOM   4320  O   ALA    55      73.742  46.853  47.557  1.00 11.65           O  
ATOM   4321  CB  ALA    55      76.006  48.045  49.693  1.00 10.49           C  
ATOM   4322  N   VAL    56      72.799  47.650  49.430  1.00  9.59           N  
ATOM   4323  CA  VAL    56      71.557  46.882  49.316  1.00 10.13           C  
ATOM   4324  C   VAL    56      70.872  47.218  47.978  1.00  8.79           C  
ATOM   4325  O   VAL    56      70.487  46.331  47.219  1.00  8.66           O  
ATOM   4326  CB  VAL    56      70.633  47.138  50.532  1.00 10.01           C  
ATOM   4327  CG1 VAL    56      69.172  46.649  50.280  1.00  7.56           C  
ATOM   4328  CG2 VAL    56      71.197  46.518  51.814  1.00 10.51           C  
ATOM   4329  N   ASN    57      70.745  48.500  47.692  1.00  9.87           N  
ATOM   4330  CA  ASN    57      70.154  48.947  46.418  1.00 11.76           C  
ATOM   4331  C   ASN    57      70.955  48.418  45.217  1.00 11.67           C  
ATOM   4332  O   ASN    57      70.387  47.822  44.284  1.00 12.55           O  
ATOM   4333  CB  ASN    57      70.021  50.469  46.372  1.00 11.99           C  
ATOM   4334  CG  ASN    57      69.007  51.027  47.383  1.00 15.66           C  
ATOM   4335  OD1 ASN    57      68.032  50.360  47.782  1.00 12.64           O  
ATOM   4336  ND2 ASN    57      69.219  52.277  47.765  1.00 17.06           N  
ATOM   4337  N   ALA    58      72.277  48.567  45.274  1.00 12.94           N  
ATOM   4338  CA  ALA    58      73.156  48.118  44.189  1.00 13.57           C  
ATOM   4339  C   ALA    58      73.017  46.612  43.937  1.00 13.61           C  
ATOM   4340  O   ALA    58      73.109  46.169  42.796  1.00 16.13           O  
ATOM   4341  CB  ALA    58      74.614  48.476  44.510  1.00 13.21           C  
ATOM   4342  N   ALA    59      72.771  45.838  45.008  1.00 11.39           N  
ATOM   4343  CA  ALA    59      72.713  44.387  44.990  1.00 12.51           C  
ATOM   4344  C   ALA    59      71.383  43.821  44.486  1.00 12.62           C  
ATOM   4345  O   ALA    59      71.285  42.620  44.220  1.00 15.13           O  
ATOM   4346  CB  ALA    59      72.996  43.852  46.390  1.00 11.06           C  
ATOM   4347  N   GLY    60      70.378  44.682  44.403  1.00 12.64           N  
ATOM   4348  CA  GLY    60      69.046  44.314  43.915  1.00 13.60           C  
ATOM   4349  C   GLY    60      67.892  44.413  44.895  1.00 12.69           C  
ATOM   4350  O   GLY    60      66.779  43.988  44.575  1.00 14.43           O  
ATOM   4351  N   GLY    61      68.157  44.977  46.071  1.00 11.70           N  
ATOM   4352  CA  GLY    61      67.159  45.202  47.083  1.00 11.61           C  
ATOM   4353  C   GLY    61      66.769  46.649  47.284  1.00 10.76           C  
ATOM   4354  O   GLY    61      67.133  47.541  46.509  1.00 11.66           O  
ATOM   4355  N   GLN    62      65.997  46.875  48.342  1.00 10.13           N  
ATOM   4356  CA  GLN    62      65.579  48.208  48.747  1.00 10.90           C  
ATOM   4357  C   GLN    62      66.130  48.515  50.154  1.00 10.77           C  
ATOM   4358  O   GLN    62      65.662  47.951  51.164  1.00 11.03           O  
ATOM   4359  CB  GLN    62      64.037  48.298  48.684  1.00 11.20           C  
ATOM   4360  CG  GLN    62      63.461  47.988  47.269  1.00 15.34           C  
ATOM   4361  CD  GLN    62      63.525  46.484  46.782  1.00 19.63           C  
ATOM   4362  OE1 GLN    62      63.962  46.197  45.643  1.00 24.40           O  
ATOM   4363  NE2 GLN    62      63.036  45.554  47.608  1.00 20.05           N  
ATOM   4364  N   GLY    63      67.141  49.385  50.235  1.00  9.97           N  
ATOM   4365  CA  GLY    63      67.772  49.697  51.514  1.00 10.52           C  
ATOM   4366  C   GLY    63      67.143  50.896  52.214  1.00 11.09           C  
ATOM   4367  O   GLY    63      66.751  51.872  51.565  1.00 11.70           O  
ATOM   4368  N   LEU    64      67.097  50.839  53.541  1.00 10.37           N  
ATOM   4369  CA  LEU    64      66.625  51.939  54.367  1.00 10.16           C  
ATOM   4370  C   LEU    64      67.664  52.174  55.478  1.00  9.71           C  
ATOM   4371  O   LEU    64      67.874  51.315  56.356  1.00 10.08           O  
ATOM   4372  CB  LEU    64      65.244  51.621  54.960  1.00 10.42           C  
ATOM   4373  CG  LEU    64      64.636  52.668  55.897  1.00 12.75           C  
ATOM   4374  CD1 LEU    64      64.511  54.024  55.202  1.00 12.09           C  
ATOM   4375  CD2 LEU    64      63.278  52.172  56.431  1.00 11.76           C  
ATOM   4376  N   ALA    65      68.330  53.321  55.410  1.00  9.06           N  
ATOM   4377  CA  ALA    65      69.351  53.704  56.389  1.00 10.32           C  
ATOM   4378  C   ALA    65      68.659  54.294  57.618  1.00 11.65           C  
ATOM   4379  O   ALA    65      67.982  55.338  57.508  1.00 11.62           O  
ATOM   4380  CB  ALA    65      70.334  54.747  55.780  1.00 11.66           C  
ATOM   4381  N   LEU    66      68.853  53.662  58.777  1.00 10.79           N  
ATOM   4382  CA  LEU    66      68.286  54.127  60.047  1.00 11.07           C  
ATOM   4383  C   LEU    66      69.362  54.351  61.107  1.00 12.60           C  
ATOM   4384  O   LEU    66      70.029  53.421  61.537  1.00 13.07           O  
ATOM   4385  CB  LEU    66      67.247  53.141  60.582  1.00 11.35           C  
ATOM   4386  CG  LEU    66      66.058  52.943  59.660  1.00 10.42           C  
ATOM   4387  CD1 LEU    66      65.099  51.776  60.092  1.00 11.42           C  
ATOM   4388  CD2 LEU    66      65.316  54.273  59.501  1.00 11.23           C  
ATOM   4389  N   LYS    67      69.536  55.602  61.503  1.00 14.30           N  
ATOM   4390  CA  LYS    67      70.479  55.934  62.564  1.00 15.13           C  
ATOM   4391  C   LYS    67      69.918  55.438  63.901  1.00 15.44           C  
ATOM   4392  O   LYS    67      68.971  55.999  64.442  1.00 15.52           O  
ATOM   4393  CB  LYS    67      70.754  57.440  62.607  1.00 18.18           C  
ATOM   4394  CG  LYS    67      71.845  57.783  63.568  1.00 20.83           C  
ATOM   4395  CD  LYS    67      72.370  59.186  63.374  1.00 25.57           C  
ATOM   4396  CE  LYS    67      73.249  59.584  64.533  1.00 29.07           C  
ATOM   4397  NZ  LYS    67      74.375  58.632  64.659  1.00 30.99           N  
ATOM   4398  N   CYS    68      70.520  54.384  64.435  1.00 15.01           N  
ATOM   4399  CA  CYS    68      69.929  53.672  65.558  1.00 14.35           C  
ATOM   4400  C   CYS    68      71.002  53.069  66.436  1.00 15.73           C  
ATOM   4401  O   CYS    68      71.712  52.159  66.030  1.00 15.85           O  
ATOM   4402  CB  CYS    68      68.987  52.584  65.037  1.00 14.77           C  
ATOM   4403  SG  CYS    68      68.102  51.658  66.320  1.00 16.51           S  
ATOM   4404  N   ASP    69      71.149  53.645  67.615  1.00 15.43           N  
ATOM   4405  CA  ASP    69      71.974  53.077  68.661  1.00 14.74           C  
ATOM   4406  C   ASP    69      71.058  52.152  69.482  1.00 14.40           C  
ATOM   4407  O   ASP    69      70.159  52.640  70.195  1.00 12.21           O  
ATOM   4408  CB  ASP    69      72.526  54.213  69.516  1.00 16.00           C  
ATOM   4409  CG  ASP    69      73.504  53.737  70.597  1.00 19.52           C  
ATOM   4410  OD1 ASP    69      73.547  52.525  70.927  1.00 18.10           O  
ATOM   4411  OD2 ASP    69      74.211  54.625  71.143  1.00 23.30           O  
ATOM   4412  N   ILE    70      71.266  50.833  69.379  1.00 14.30           N  
ATOM   4413  CA  ILE    70      70.321  49.876  69.990  1.00 15.56           C  
ATOM   4414  C   ILE    70      70.370  49.869  71.538  1.00 15.83           C  
ATOM   4415  O   ILE    70      69.527  49.223  72.182  1.00 15.07           O  
ATOM   4416  CB  ILE    70      70.395  48.418  69.397  1.00 16.26           C  
ATOM   4417  CG1 ILE    70      71.703  47.716  69.749  1.00 18.10           C  
ATOM   4418  CG2 ILE    70      70.142  48.415  67.861  1.00 17.83           C  
ATOM   4419  CD1 ILE    70      71.696  46.193  69.368  1.00 17.33           C  
ATOM   4420  N   ARG    71      71.298  50.643  72.109  1.00 14.82           N  
ATOM   4421  CA  ARG    71      71.335  50.907  73.554  1.00 15.94           C  
ATOM   4422  C   ARG    71      70.191  51.802  73.997  1.00 15.57           C  
ATOM   4423  O   ARG    71      69.853  51.845  75.194  1.00 15.81           O  
ATOM   4424  CB  ARG    71      72.664  51.558  73.964  1.00 15.65           C  
ATOM   4425  CG  ARG    71      73.911  50.663  73.791  1.00 14.57           C  
ATOM   4426  CD  ARG    71      75.186  51.376  74.210  1.00 19.32           C  
ATOM   4427  NE  ARG    71      75.512  52.425  73.239  1.00 21.10           N  
ATOM   4428  CZ  ARG    71      76.577  53.222  73.305  1.00 24.89           C  
ATOM   4429  NH1 ARG    71      77.449  53.098  74.293  1.00 24.75           N  
ATOM   4430  NH2 ARG    71      76.777  54.145  72.365  1.00 22.88           N  
ATOM   4431  N   GLU    72      69.595  52.500  73.025  1.00 15.06           N  
ATOM   4432  CA  GLU    72      68.561  53.486  73.263  1.00 14.85           C  
ATOM   4433  C   GLU    72      67.228  52.992  72.776  1.00 14.36           C  
ATOM   4434  O   GLU    72      66.974  52.971  71.572  1.00 14.13           O  
ATOM   4435  CB  GLU    72      68.927  54.788  72.547  1.00 16.20           C  
ATOM   4436  CG  GLU    72      70.228  55.424  73.032  1.00 19.28           C  
ATOM   4437  CD  GLU    72      70.163  55.912  74.477  1.00 24.79           C  
ATOM   4438  OE1 GLU    72      69.065  56.244  74.975  1.00 26.49           O  
ATOM   4439  OE2 GLU    72      71.228  55.987  75.109  1.00 31.64           O  
ATOM   4440  N   GLU    73      66.373  52.616  73.722  1.00 14.09           N  
ATOM   4441  CA  GLU    73      65.038  52.121  73.420  1.00 14.77           C  
ATOM   4442  C   GLU    73      64.240  53.052  72.481  1.00 15.01           C  
ATOM   4443  O   GLU    73      63.577  52.581  71.536  1.00 13.16           O  
ATOM   4444  CB  GLU    73      64.247  51.894  74.732  1.00 16.04           C  
ATOM   4445  CG  GLU    73      62.876  51.306  74.472  1.00 18.66           C  
ATOM   4446  CD  GLU    73      61.866  51.466  75.631  1.00 20.26           C  
ATOM   4447  OE1 GLU    73      62.232  52.012  76.692  1.00 24.55           O  
ATOM   4448  OE2 GLU    73      60.699  51.042  75.454  1.00 23.78           O  
ATOM   4449  N   ASP    74      64.303  54.362  72.738  1.00 14.98           N  
ATOM   4450  CA  ASP    74      63.582  55.324  71.895  0.50 14.83           C  
ATOM   4452  C   ASP    74      64.038  55.283  70.432  1.00 14.52           C  
ATOM   4453  O   ASP    74      63.213  55.398  69.513  1.00 14.83           O  
ATOM   4454  CB  ASP    74      63.633  56.758  72.467  0.50 15.52           C  
ATOM   4456  CG  ASP    74      65.035  57.340  72.522  0.50 16.56           C  
ATOM   4458  OD1 ASP    74      66.010  56.581  72.494  0.50 16.84           O  
ATOM   4460  OD2 ASP    74      65.147  58.582  72.630  0.50 20.41           O  
ATOM   4462  N   GLN    75      65.332  55.101  70.199  1.00 13.57           N  
ATOM   4463  CA  GLN    75      65.839  54.993  68.823  1.00 13.14           C  
ATOM   4464  C   GLN    75      65.410  53.694  68.158  1.00 14.19           C  
ATOM   4465  O   GLN    75      65.118  53.662  66.948  1.00 13.85           O  
ATOM   4466  CB  GLN    75      67.347  55.120  68.804  1.00 14.45           C  
ATOM   4467  CG  GLN    75      67.809  56.504  69.261  1.00 14.29           C  
ATOM   4468  CD  GLN    75      69.289  56.650  69.151  1.00 16.40           C  
ATOM   4469  OE1 GLN    75      69.882  56.165  68.197  1.00 15.63           O  
ATOM   4470  NE2 GLN    75      69.905  57.317  70.129  1.00 18.92           N  
ATOM   4471  N   VAL    76      65.380  52.610  68.929  1.00 11.77           N  
ATOM   4472  CA  VAL    76      64.900  51.323  68.393  1.00 12.50           C  
ATOM   4473  C   VAL    76      63.419  51.411  67.974  1.00 12.50           C  
ATOM   4474  O   VAL    76      63.030  51.036  66.868  1.00 10.96           O  
ATOM   4475  CB  VAL    76      65.084  50.176  69.410  1.00 11.81           C  
ATOM   4476  CG1 VAL    76      64.358  48.932  68.920  1.00 11.56           C  
ATOM   4477  CG2 VAL    76      66.542  49.876  69.627  1.00 12.60           C  
ATOM   4478  N   ARG    77      62.601  51.956  68.857  1.00 13.65           N  
ATOM   4479  CA  ARG    77      61.189  52.145  68.559  0.50 13.88           C  
ATOM   4481  C   ARG    77      61.020  53.019  67.324  1.00 12.93           C  
ATOM   4482  O   ARG    77      60.226  52.697  66.449  1.00 12.46           O  
ATOM   4483  CB  ARG    77      60.467  52.791  69.729  0.50 14.68           C  
ATOM   4485  CG  ARG    77      60.032  51.831  70.812  0.50 16.92           C  
ATOM   4487  CD  ARG    77      59.153  52.565  71.818  0.50 20.54           C  
ATOM   4489  NE  ARG    77      59.950  53.532  72.565  0.50 23.90           N  
ATOM   4491  CZ  ARG    77      60.040  53.601  73.889  0.50 25.52           C  
ATOM   4493  NH1 ARG    77      59.345  52.779  74.669  0.50 28.09           N  
ATOM   4495  NH2 ARG    77      60.825  54.518  74.436  0.50 24.10           N  
ATOM   4497  N   ALA    78      61.801  54.113  67.257  1.00 12.74           N  
ATOM   4498  CA  ALA    78      61.742  55.052  66.125  1.00 12.35           C  
ATOM   4499  C   ALA    78      62.108  54.311  64.829  1.00 11.80           C  
ATOM   4500  O   ALA    78      61.436  54.455  63.798  1.00 10.56           O  
ATOM   4501  CB  ALA    78      62.675  56.230  66.346  1.00 12.32           C  
ATOM   4502  N   ALA    79      63.188  53.526  64.875  1.00 10.16           N  
ATOM   4503  CA  ALA    79      63.613  52.764  63.698  1.00  9.21           C  
ATOM   4504  C   ALA    79      62.555  51.749  63.227  1.00  9.66           C  
ATOM   4505  O   ALA    79      62.283  51.644  62.029  1.00  9.19           O  
ATOM   4506  CB  ALA    79      64.950  52.109  63.938  1.00 11.41           C  
ATOM   4507  N   VAL    80      61.932  51.036  64.162  1.00 10.89           N  
ATOM   4508  CA  VAL    80      60.930  50.054  63.811  1.00 10.39           C  
ATOM   4509  C   VAL    80      59.708  50.748  63.173  1.00 11.76           C  
ATOM   4510  O   VAL    80      59.182  50.300  62.157  1.00 10.69           O  
ATOM   4511  CB  VAL    80      60.549  49.202  65.058  1.00 11.02           C  
ATOM   4512  CG1 VAL    80      59.275  48.393  64.797  1.00 12.27           C  
ATOM   4513  CG2 VAL    80      61.707  48.283  65.456  1.00 10.82           C  
ATOM   4514  N   ALA    81      59.284  51.847  63.774  1.00 11.29           N  
ATOM   4515  CA  ALA    81      58.149  52.634  63.249  1.00 11.10           C  
ATOM   4516  C   ALA    81      58.424  53.111  61.822  1.00 10.71           C  
ATOM   4517  O   ALA    81      57.583  52.981  60.937  1.00 10.67           O  
ATOM   4518  CB  ALA    81      57.848  53.798  64.168  1.00 11.80           C  
ATOM   4519  N   ALA    82      59.638  53.609  61.588  1.00 12.43           N  
ATOM   4520  CA  ALA    82      60.031  54.073  60.246  1.00 11.93           C  
ATOM   4521  C   ALA    82      60.020  52.929  59.223  1.00 12.13           C  
ATOM   4522  O   ALA    82      59.658  53.130  58.059  1.00 12.22           O  
ATOM   4523  CB  ALA    82      61.418  54.698  60.294  1.00 11.17           C  
ATOM   4524  N   THR    83      60.486  51.750  59.641  1.00 10.92           N  
ATOM   4525  CA  THR    83      60.552  50.567  58.781  1.00 11.47           C  
ATOM   4526  C   THR    83      59.150  50.169  58.351  1.00 10.06           C  
ATOM   4527  O   THR    83      58.901  49.929  57.170  1.00 10.48           O  
ATOM   4528  CB  THR    83      61.291  49.396  59.496  1.00 12.22           C  
ATOM   4529  OG1 THR    83      62.647  49.789  59.838  1.00 10.85           O  
ATOM   4530  CG2 THR    83      61.322  48.118  58.625  1.00 11.26           C  
ATOM   4531  N   VAL    84      58.226  50.151  59.308  1.00 11.11           N  
ATOM   4532  CA  VAL    84      56.815  49.819  59.019  1.00 11.98           C  
ATOM   4533  C   VAL    84      56.188  50.876  58.082  1.00 12.56           C  
ATOM   4534  O   VAL    84      55.509  50.529  57.121  1.00 14.11           O  
ATOM   4535  CB  VAL    84      56.056  49.667  60.328  1.00 12.21           C  
ATOM   4536  CG1 VAL    84      54.528  49.657  60.079  1.00 13.32           C  
ATOM   4537  CG2 VAL    84      56.577  48.395  61.081  1.00 11.90           C  
ATOM   4538  N   ASP    85      56.495  52.145  58.314  1.00 12.76           N  
ATOM   4539  CA  ASP    85      55.984  53.238  57.498  1.00 13.08           C  
ATOM   4540  C   ASP    85      56.545  53.222  56.074  1.00 14.08           C  
ATOM   4541  O   ASP    85      55.918  53.767  55.149  1.00 17.77           O  
ATOM   4542  CB  ASP    85      56.288  54.569  58.170  1.00 11.36           C  
ATOM   4543  CG  ASP    85      55.357  54.849  59.353  1.00 13.67           C  
ATOM   4544  OD1 ASP    85      54.298  54.183  59.454  1.00 16.53           O  
ATOM   4545  OD2 ASP    85      55.690  55.730  60.152  1.00 12.55           O  
ATOM   4546  N   THR    86      57.730  52.637  55.914  1.00 13.52           N  
ATOM   4547  CA  THR    86      58.421  52.588  54.626  1.00 13.64           C  
ATOM   4548  C   THR    86      58.031  51.337  53.806  1.00 12.99           C  
ATOM   4549  O   THR    86      57.796  51.439  52.603  1.00 13.01           O  
ATOM   4550  CB  THR    86      59.949  52.678  54.805  1.00 14.35           C  
ATOM   4551  OG1 THR    86      60.296  53.846  55.556  1.00 13.28           O  
ATOM   4552  CG2 THR    86      60.658  52.690  53.436  1.00 14.76           C  
ATOM   4553  N   PHE    87      57.985  50.175  54.453  1.00 12.20           N  
ATOM   4554  CA  PHE    87      57.786  48.909  53.776  1.00 13.39           C  
ATOM   4555  C   PHE    87      56.445  48.196  54.062  1.00 14.24           C  
ATOM   4556  O   PHE    87      56.106  47.230  53.376  1.00 14.71           O  
ATOM   4557  CB  PHE    87      58.978  47.966  54.067  1.00 12.60           C  
ATOM   4558  CG  PHE    87      60.331  48.500  53.574  1.00 12.24           C  
ATOM   4559  CD1 PHE    87      60.545  48.733  52.222  1.00 12.48           C  
ATOM   4560  CD2 PHE    87      61.377  48.710  54.450  1.00 10.71           C  
ATOM   4561  CE1 PHE    87      61.770  49.195  51.760  1.00 12.16           C  
ATOM   4562  CE2 PHE    87      62.623  49.163  53.993  1.00 11.59           C  
ATOM   4563  CZ  PHE    87      62.808  49.426  52.663  1.00 11.42           C  
ATOM   4564  N   GLY    88      55.701  48.651  55.066  1.00 14.19           N  
ATOM   4565  CA  GLY    88      54.385  48.070  55.374  1.00 15.72           C  
ATOM   4566  C   GLY    88      54.414  47.041  56.492  1.00 16.55           C  
ATOM   4567  O   GLY    88      53.366  46.641  56.994  1.00 18.76           O  
ATOM   4568  N   GLY    89      55.600  46.614  56.913  1.00 16.03           N  
ATOM   4569  CA  GLY    89      55.698  45.617  57.983  1.00 15.01           C  
ATOM   4570  C   GLY    89      57.135  45.227  58.265  1.00 14.27           C  
ATOM   4571  O   GLY    89      58.052  45.854  57.737  1.00 13.48           O  
ATOM   4572  N   ILE    90      57.300  44.214  59.119  1.00 13.25           N  
ATOM   4573  CA  ILE    90      58.606  43.592  59.372  1.00 13.40           C  
ATOM   4574  C   ILE    90      58.384  42.086  59.350  1.00 11.55           C  
ATOM   4575  O   ILE    90      57.515  41.570  60.077  1.00 11.69           O  
ATOM   4576  CB  ILE    90      59.255  44.041  60.701  1.00 12.64           C  
ATOM   4577  CG1 ILE    90      59.526  45.566  60.696  1.00 14.52           C  
ATOM   4578  CG2 ILE    90      60.558  43.283  60.906  1.00 12.56           C  
ATOM   4579  CD1 ILE    90      60.052  46.125  61.987  1.00 15.48           C  
ATOM   4580  N   ASP    91      59.096  41.403  58.457  1.00  9.86           N  
ATOM   4581  CA  ASP    91      59.002  39.958  58.303  1.00 11.11           C  
ATOM   4582  C   ASP    91      60.065  39.250  59.113  1.00  9.15           C  
ATOM   4583  O   ASP    91      59.854  38.134  59.552  1.00  9.18           O  
ATOM   4584  CB  ASP    91      59.140  39.542  56.847  1.00 11.65           C  
ATOM   4585  CG  ASP    91      58.037  40.107  55.980  1.00 14.84           C  
ATOM   4586  OD1 ASP    91      56.894  39.622  56.119  1.00 16.00           O  
ATOM   4587  OD2 ASP    91      58.298  41.074  55.229  1.00 12.79           O  
ATOM   4588  N   ILE    92      61.221  39.899  59.274  1.00  9.58           N  
ATOM   4589  CA  ILE    92      62.410  39.261  59.820  1.00  8.68           C  
ATOM   4590  C   ILE    92      63.218  40.242  60.659  1.00  8.52           C  
ATOM   4591  O   ILE    92      63.473  41.358  60.218  1.00  9.07           O  
ATOM   4592  CB  ILE    92      63.321  38.751  58.680  1.00  8.52           C  
ATOM   4593  CG1 ILE    92      62.638  37.607  57.875  1.00  9.06           C  
ATOM   4594  CG2 ILE    92      64.706  38.401  59.227  1.00  8.10           C  
ATOM   4595  CD1 ILE    92      63.261  37.353  56.436  1.00  7.79           C  
ATOM   4596  N   LEU    93      63.533  39.852  61.886  1.00  8.30           N  
ATOM   4597  CA  LEU    93      64.502  40.588  62.706  1.00  7.41           C  
ATOM   4598  C   LEU    93      65.775  39.756  62.820  1.00  8.70           C  
ATOM   4599  O   LEU    93      65.716  38.585  63.185  1.00  8.76           O  
ATOM   4600  CB  LEU    93      63.938  40.843  64.105  1.00  8.16           C  
ATOM   4601  CG  LEU    93      64.932  41.233  65.196  1.00  5.74           C  
ATOM   4602  CD1 LEU    93      65.628  42.551  64.861  1.00  6.57           C  
ATOM   4603  CD2 LEU    93      64.314  41.307  66.611  1.00  8.60           C  
ATOM   4604  N   VAL    94      66.914  40.375  62.510  1.00  7.98           N  
ATOM   4605  CA  VAL    94      68.219  39.769  62.709  1.00  9.12           C  
ATOM   4606  C   VAL    94      68.980  40.558  63.797  1.00 10.02           C  
ATOM   4607  O   VAL    94      69.390  41.739  63.605  1.00  9.86           O  
ATOM   4608  CB  VAL    94      69.055  39.690  61.423  1.00  9.47           C  
ATOM   4609  CG1 VAL    94      70.436  39.116  61.752  1.00  9.29           C  
ATOM   4610  CG2 VAL    94      68.318  38.871  60.309  1.00  8.59           C  
ATOM   4611  N   ASN    95      69.154  39.893  64.938  1.00 10.55           N  
ATOM   4612  CA  ASN    95      69.892  40.431  66.077  1.00  9.62           C  
ATOM   4613  C   ASN    95      71.373  40.123  65.903  1.00 11.40           C  
ATOM   4614  O   ASN    95      71.831  39.032  66.242  1.00  9.87           O  
ATOM   4615  CB  ASN    95      69.380  39.836  67.413  1.00 10.60           C  
ATOM   4616  CG  ASN    95      68.052  40.440  67.876  1.00 11.21           C  
ATOM   4617  OD1 ASN    95      67.818  41.634  67.732  1.00 10.76           O  
ATOM   4618  ND2 ASN    95      67.218  39.620  68.528  1.00 12.96           N  
ATOM   4619  N   ASN    96      72.085  41.091  65.326  1.00 11.59           N  
ATOM   4620  CA  ASN    96      73.528  41.016  65.035  1.00 13.37           C  
ATOM   4621  C   ASN    96      74.273  42.005  65.928  1.00 16.20           C  
ATOM   4622  O   ASN    96      73.928  43.179  65.993  1.00 15.11           O  
ATOM   4623  CB  ASN    96      73.715  41.313  63.557  1.00 11.50           C  
ATOM   4624  CG  ASN    96      75.139  41.575  63.180  1.00 14.49           C  
ATOM   4625  OD1 ASN    96      75.983  40.680  63.207  1.00 16.83           O  
ATOM   4626  ND2 ASN    96      75.409  42.792  62.790  1.00  9.56           N  
ATOM   4627  N   ALA    97      75.296  41.579  66.656  1.00 18.86           N  
ATOM   4628  CA  ALA    97      75.854  42.536  67.648  1.00 21.32           C  
ATOM   4629  C   ALA    97      77.288  42.237  68.037  1.00 24.35           C  
ATOM   4630  O   ALA    97      77.701  41.061  68.148  1.00 25.78           O  
ATOM   4631  CB  ALA    97      74.962  42.624  68.875  1.00 19.12           C  
ATOM   4632  N   SER    98      78.054  43.303  68.232  1.00 26.50           N  
ATOM   4633  CA  SER    98      79.498  43.168  68.439  1.00 27.11           C  
ATOM   4634  C   SER    98      79.973  44.056  69.562  1.00 28.44           C  
ATOM   4635  O   SER    98      80.188  45.265  69.386  1.00 30.58           O  
ATOM   4636  CB  SER    98      80.288  43.465  67.148  1.00 28.40           C  
ATOM   4637  N   ALA    99      80.109  43.449  70.737  1.00 27.31           N  
ATOM   4638  CA  ALA    99      80.844  44.047  71.820  1.00 25.99           C  
ATOM   4639  C   ALA    99      81.478  42.891  72.564  1.00 25.28           C  
ATOM   4640  O   ALA    99      80.775  42.057  73.139  1.00 26.40           O  
ATOM   4641  CB  ALA    99      79.943  44.863  72.705  1.00 23.45           C  
ATOM   4642  N   ILE   100      82.803  42.829  72.486  1.00 25.37           N  
ATOM   4643  CA  ILE   100      83.592  41.744  73.047  1.00 25.42           C  
ATOM   4644  C   ILE   100      84.627  42.316  73.998  1.00 24.81           C  
ATOM   4645  O   ILE   100      85.177  43.389  73.744  1.00 24.78           O  
ATOM   4646  CB  ILE   100      84.371  40.987  71.948  1.00 25.91           C  
ATOM   4647  CG1 ILE   100      83.484  40.708  70.742  1.00 27.86           C  
ATOM   4648  CG2 ILE   100      84.948  39.693  72.488  1.00 24.79           C  
ATOM   4649  CD1 ILE   100      84.232  40.102  69.571  1.00 29.67           C  
ATOM   4650  N   TRP   101      84.907  41.572  75.065  1.00 24.29           N  
ATOM   4651  CA  TRP   101      85.986  41.896  75.992  1.00 23.47           C  
ATOM   4652  C   TRP   101      86.430  40.636  76.723  1.00 22.77           C  
ATOM   4653  O   TRP   101      85.773  40.172  77.675  1.00 21.38           O  
ATOM   4654  CB  TRP   101      85.541  42.954  76.986  1.00 24.46           C  
ATOM   4655  CG  TRP   101      86.642  43.518  77.809  1.00 24.30           C  
ATOM   4656  CD1 TRP   101      86.913  43.240  79.101  1.00 24.59           C  
ATOM   4657  CD2 TRP   101      87.599  44.497  77.396  1.00 23.61           C  
ATOM   4658  NE1 TRP   101      87.994  43.970  79.529  1.00 24.57           N  
ATOM   4659  CE2 TRP   101      88.426  44.762  78.502  1.00 24.81           C  
ATOM   4660  CE3 TRP   101      87.836  45.178  76.195  1.00 25.08           C  
ATOM   4661  CZ2 TRP   101      89.479  45.672  78.448  1.00 25.92           C  
ATOM   4662  CZ3 TRP   101      88.884  46.096  76.148  1.00 24.84           C  
ATOM   4663  CH2 TRP   101      89.694  46.322  77.263  1.00 25.44           C  
ATOM   4664  N   LEU   102      87.548  40.074  76.284  1.00 21.75           N  
ATOM   4665  CA  LEU   102      87.973  38.788  76.788  1.00 22.04           C  
ATOM   4666  C   LEU   102      88.999  38.959  77.898  1.00 23.00           C  
ATOM   4667  O   LEU   102      90.183  38.677  77.729  1.00 24.09           O  
ATOM   4668  CB  LEU   102      88.501  37.906  75.658  1.00 22.22           C  
ATOM   4669  CG  LEU   102      87.511  37.608  74.531  1.00 21.08           C  
ATOM   4670  CD1 LEU   102      88.094  36.557  73.608  1.00 22.43           C  
ATOM   4671  CD2 LEU   102      86.161  37.181  75.059  1.00 23.06           C  
ATOM   4672  N   ARG   103      88.519  39.427  79.046  1.00 22.04           N  
ATOM   4673  CA  ARG   103      89.319  39.493  80.253  1.00 21.64           C  
ATOM   4674  C   ARG   103      88.537  39.038  81.485  1.00 20.27           C  
ATOM   4675  O   ARG   103      87.312  38.943  81.477  1.00 17.16           O  
ATOM   4676  CB  ARG   103      89.814  40.917  80.499  1.00 24.03           C  
ATOM   4677  CG  ARG   103      90.505  41.512  79.289  1.00 28.14           C  
ATOM   4678  CD  ARG   103      91.647  42.375  79.666  1.00 33.78           C  
ATOM   4679  NE  ARG   103      91.975  43.272  78.562  1.00 36.82           N  
ATOM   4680  CZ  ARG   103      92.748  44.347  78.676  1.00 38.51           C  
ATOM   4681  NH1 ARG   103      93.292  44.664  79.851  1.00 40.89           N  
ATOM   4682  NH2 ARG   103      92.980  45.113  77.610  1.00 38.28           N  
ATOM   4683  N   GLY   104      89.296  38.795  82.548  1.00 16.74           N  
ATOM   4684  CA  GLY   104      88.738  38.403  83.816  1.00 16.72           C  
ATOM   4685  C   GLY   104      88.016  39.549  84.476  1.00 15.68           C  
ATOM   4686  O   GLY   104      88.102  40.703  84.059  1.00 14.76           O  
ATOM   4687  N   THR   105      87.290  39.209  85.524  1.00 15.55           N  
ATOM   4688  CA  THR   105      86.415  40.145  86.195  1.00 15.07           C  
ATOM   4689  C   THR   105      87.085  41.370  86.813  1.00 16.19           C  
ATOM   4690  O   THR   105      86.541  42.478  86.727  1.00 17.66           O  
ATOM   4691  CB  THR   105      85.596  39.354  87.216  1.00 15.47           C  
ATOM   4692  OG1 THR   105      84.754  38.485  86.470  1.00 15.00           O  
ATOM   4693  CG2 THR   105      84.743  40.249  88.138  1.00 14.35           C  
ATOM   4694  N   LEU   106      88.263  41.202  87.418  1.00 15.58           N  
ATOM   4695  CA  LEU   106      88.968  42.363  87.978  1.00 17.21           C  
ATOM   4696  C   LEU   106      89.505  43.305  86.884  1.00 17.64           C  
ATOM   4697  O   LEU   106      89.758  44.483  87.159  1.00 18.32           O  
ATOM   4698  CB  LEU   106      90.100  41.919  88.905  1.00 18.10           C  
ATOM   4699  CG  LEU   106      89.663  41.104  90.120  1.00 18.99           C  
ATOM   4700  CD1 LEU   106      90.879  40.738  91.005  1.00 19.71           C  
ATOM   4701  CD2 LEU   106      88.591  41.858  90.886  1.00 19.70           C  
ATOM   4702  N   ASP   107      89.640  42.778  85.666  1.00 18.49           N  
ATOM   4703  CA  ASP   107      90.100  43.530  84.483  1.00 20.41           C  
ATOM   4704  C   ASP   107      88.994  43.850  83.466  1.00 20.75           C  
ATOM   4705  O   ASP   107      89.274  44.072  82.273  1.00 19.29           O  
ATOM   4706  CB  ASP   107      91.193  42.730  83.775  1.00 21.67           C  
ATOM   4707  CG  ASP   107      92.343  42.404  84.683  1.00 25.54           C  
ATOM   4708  OD1 ASP   107      92.765  43.318  85.419  1.00 30.40           O  
ATOM   4709  OD2 ASP   107      92.820  41.247  84.674  1.00 29.43           O  
ATOM   4710  N   THR   108      87.744  43.880  83.937  1.00 19.28           N  
ATOM   4711  CA  THR   108      86.581  44.210  83.116  1.00 18.97           C  
ATOM   4712  C   THR   108      85.864  45.409  83.737  1.00 18.53           C  
ATOM   4713  O   THR   108      84.979  45.238  84.572  1.00 18.30           O  
ATOM   4714  CB  THR   108      85.607  42.989  82.979  1.00 18.05           C  
ATOM   4715  OG1 THR   108      86.270  41.918  82.300  1.00 16.75           O  
ATOM   4716  CG2 THR   108      84.333  43.347  82.176  1.00 18.61           C  
ATOM   4717  N   PRO   109      86.236  46.634  83.326  1.00 19.10           N  
ATOM   4718  CA  PRO   109      85.571  47.825  83.855  1.00 18.95           C  
ATOM   4719  C   PRO   109      84.062  47.813  83.663  1.00 18.05           C  
ATOM   4720  O   PRO   109      83.562  47.256  82.680  1.00 17.09           O  
ATOM   4721  CB  PRO   109      86.210  48.986  83.052  1.00 19.61           C  
ATOM   4722  CG  PRO   109      87.506  48.462  82.542  1.00 19.54           C  
ATOM   4723  CD  PRO   109      87.301  46.969  82.358  1.00 19.08           C  
ATOM   4724  N   MET   110      83.332  48.423  84.588  1.00 18.14           N  
ATOM   4725  CA  MET   110      81.867  48.425  84.471  1.00 18.12           C  
ATOM   4726  C   MET   110      81.380  49.103  83.188  1.00 17.12           C  
ATOM   4727  O   MET   110      80.344  48.701  82.654  1.00 15.67           O  
ATOM   4728  CB  MET   110      81.211  49.040  85.703  1.00 18.68           C  
ATOM   4729  CG  MET   110      81.477  48.233  86.978  1.00 20.97           C  
ATOM   4730  SD  MET   110      81.044  46.309  86.827  1.00 25.12          SE  
ATOM   4731  CE  MET   110      79.163  46.430  86.231  1.00 15.96           C  
ATOM   4732  N   LYS   111      82.099  50.110  82.680  1.00 15.99           N  
ATOM   4733  CA  LYS   111      81.717  50.714  81.391  1.00 16.83           C  
ATOM   4734  C   LYS   111      81.719  49.670  80.260  1.00 16.95           C  
ATOM   4735  O   LYS   111      80.841  49.664  79.396  1.00 16.98           O  
ATOM   4736  CB  LYS   111      82.604  51.928  81.031  1.00 17.99           C  
ATOM   4737  N   ARG   112      82.687  48.772  80.283  1.00 16.61           N  
ATOM   4738  CA  ARG   112      82.800  47.714  79.279  1.00 16.84           C  
ATOM   4739  C   ARG   112      81.758  46.624  79.515  1.00 15.21           C  
ATOM   4740  O   ARG   112      81.088  46.175  78.593  1.00 14.90           O  
ATOM   4741  CB  ARG   112      84.206  47.118  79.324  1.00 19.03           C  
ATOM   4742  CG  ARG   112      84.488  46.147  78.241  1.00 24.00           C  
ATOM   4743  CD  ARG   112      84.588  46.814  76.882  1.00 28.63           C  
ATOM   4744  NE  ARG   112      85.729  47.725  76.809  1.00 31.55           N  
ATOM   4745  CZ  ARG   112      86.100  48.369  75.702  1.00 33.82           C  
ATOM   4746  NH1 ARG   112      85.423  48.203  74.565  1.00 35.01           N  
ATOM   4747  NH2 ARG   112      87.157  49.175  75.724  1.00 33.19           N  
ATOM   4748  N   PHE   113      81.589  46.242  80.771  1.00 14.46           N  
ATOM   4749  CA  PHE   113      80.528  45.298  81.141  1.00 13.19           C  
ATOM   4750  C   PHE   113      79.201  45.800  80.609  1.00 12.99           C  
ATOM   4751  O   PHE   113      78.449  45.038  79.996  1.00 13.17           O  
ATOM   4752  CB  PHE   113      80.464  45.166  82.666  1.00 13.14           C  
ATOM   4753  CG  PHE   113      79.424  44.201  83.156  1.00 12.58           C  
ATOM   4754  CD1 PHE   113      79.761  42.881  83.428  1.00 13.38           C  
ATOM   4755  CD2 PHE   113      78.112  44.619  83.395  1.00 12.08           C  
ATOM   4756  CE1 PHE   113      78.809  41.975  83.900  1.00 13.78           C  
ATOM   4757  CE2 PHE   113      77.166  43.727  83.864  1.00 14.33           C  
ATOM   4758  CZ  PHE   113      77.521  42.387  84.097  1.00 13.05           C  
ATOM   4759  N   ASP   114      78.925  47.089  80.832  1.00 13.50           N  
ATOM   4760  CA  ASP   114      77.629  47.702  80.477  1.00 13.35           C  
ATOM   4761  C   ASP   114      77.445  47.808  78.964  1.00 13.59           C  
ATOM   4762  O   ASP   114      76.377  47.516  78.440  1.00 13.57           O  
ATOM   4763  CB  ASP   114      77.495  49.087  81.096  1.00 14.35           C  
ATOM   4764  CG  ASP   114      77.199  49.046  82.581  1.00 16.36           C  
ATOM   4765  OD1 ASP   114      76.877  47.963  83.130  1.00 16.43           O  
ATOM   4766  OD2 ASP   114      77.296  50.123  83.213  1.00 17.53           O  
ATOM   4767  N   LEU   115      78.494  48.227  78.255  1.00 13.85           N  
ATOM   4768  CA  LEU   115      78.435  48.234  76.797  1.00 14.41           C  
ATOM   4769  C   LEU   115      78.001  46.864  76.291  1.00 13.73           C  
ATOM   4770  O   LEU   115      77.135  46.765  75.426  1.00 12.95           O  
ATOM   4771  CB  LEU   115      79.810  48.563  76.215  1.00 15.20           C  
ATOM   4772  CG  LEU   115      79.954  48.493  74.687  1.00 17.36           C  
ATOM   4773  CD1 LEU   115      79.052  49.546  74.048  1.00 20.85           C  
ATOM   4774  CD2 LEU   115      81.438  48.699  74.265  1.00 17.77           C  
ATOM   4775  N   MET   116      78.636  45.810  76.810  1.00 12.94           N  
ATOM   4776  CA  MET   116      78.357  44.446  76.364  1.00 14.83           C  
ATOM   4777  C   MET   116      76.934  44.028  76.686  1.00 13.40           C  
ATOM   4778  O   MET   116      76.227  43.522  75.812  1.00 12.46           O  
ATOM   4779  CB  MET   116      79.337  43.460  76.970  1.00 14.83           C  
ATOM   4780  CG  MET   116      80.753  43.700  76.483  1.00 17.13           C  
ATOM   4781  SD  MET   116      81.983  42.298  76.979  1.00 23.57          SE  
ATOM   4782  CE  MET   116      81.985  42.439  78.957  1.00 14.43           C  
ATOM   4783  N   GLN   117      76.479  44.232  77.914  1.00 12.39           N  
ATOM   4784  CA  GLN   117      75.076  43.805  78.221  1.00 10.84           C  
ATOM   4785  C   GLN   117      74.063  44.595  77.416  1.00 12.68           C  
ATOM   4786  O   GLN   117      73.022  44.081  77.083  1.00 13.09           O  
ATOM   4787  CB  GLN   117      74.696  43.928  79.699  1.00 11.00           C  
ATOM   4788  CG  GLN   117      75.734  43.443  80.721  1.00 10.79           C  
ATOM   4789  CD  GLN   117      76.335  42.099  80.406  1.00 12.31           C  
ATOM   4790  OE1 GLN   117      75.632  41.127  80.084  1.00 15.56           O  
ATOM   4791  NE2 GLN   117      77.669  42.022  80.528  1.00 13.42           N  
ATOM   4792  N   GLN   118      74.345  45.867  77.163  1.00 12.32           N  
ATOM   4793  CA  GLN   118      73.398  46.727  76.474  1.00 12.69           C  
ATOM   4794  C   GLN   118      73.291  46.412  74.976  1.00 12.42           C  
ATOM   4795  O   GLN   118      72.191  46.387  74.414  1.00 14.90           O  
ATOM   4796  CB  GLN   118      73.751  48.191  76.720  1.00 12.77           C  
ATOM   4797  CG  GLN   118      73.473  48.629  78.157  1.00 13.82           C  
ATOM   4798  CD  GLN   118      74.069  49.992  78.489  1.00 18.46           C  
ATOM   4799  OE1 GLN   118      74.460  50.744  77.596  1.00 20.95           O  
ATOM   4800  NE2 GLN   118      74.143  50.308  79.778  1.00 18.75           N  
ATOM   4801  N   VAL   119      74.414  46.146  74.323  1.00 11.13           N  
ATOM   4802  CA  VAL   119      74.416  45.869  72.895  1.00 12.66           C  
ATOM   4803  C   VAL   119      73.986  44.426  72.572  1.00 13.69           C  
ATOM   4804  O   VAL   119      73.292  44.178  71.564  1.00 14.74           O  
ATOM   4805  CB  VAL   119      75.809  46.132  72.258  1.00 13.12           C  
ATOM   4806  CG1 VAL   119      75.776  45.741  70.812  1.00 14.87           C  
ATOM   4807  CG2 VAL   119      76.195  47.602  72.424  1.00 12.12           C  
ATOM   4808  N   ASN   120      74.401  43.486  73.427  1.00 13.44           N  
ATOM   4809  CA  ASN   120      74.200  42.069  73.177  0.50 12.98           C  
ATOM   4811  C   ASN   120      72.813  41.670  73.715  1.00 13.00           C  
ATOM   4812  O   ASN   120      71.819  41.857  73.018  1.00 12.21           O  
ATOM   4813  CB  ASN   120      75.360  41.220  73.757  0.50 13.16           C  
ATOM   4815  CG  ASN   120      76.684  41.377  72.975  0.50 12.41           C  
ATOM   4817  OD1 ASN   120      76.764  41.060  71.790  0.50 13.07           O  
ATOM   4819  ND2 ASN   120      77.733  41.834  73.656  0.50 12.30           N  
ATOM   4821  N   ALA   121      72.726  41.185  74.956  1.00 12.16           N  
ATOM   4822  CA  ALA   121      71.464  40.643  75.491  1.00 11.72           C  
ATOM   4823  C   ALA   121      70.322  41.649  75.456  1.00 12.07           C  
ATOM   4824  O   ALA   121      69.208  41.328  74.996  1.00 12.16           O  
ATOM   4825  CB  ALA   121      71.669  40.131  76.946  1.00 13.02           C  
ATOM   4826  N   ARG   122      70.565  42.852  75.995  1.00 11.44           N  
ATOM   4827  CA  ARG   122      69.499  43.842  76.086  1.00 11.27           C  
ATOM   4828  C   ARG   122      69.060  44.279  74.698  1.00 10.77           C  
ATOM   4829  O   ARG   122      67.867  44.432  74.456  1.00 10.93           O  
ATOM   4830  CB  ARG   122      69.894  45.062  76.914  1.00 10.51           C  
ATOM   4831  CG  ARG   122      68.796  46.125  77.010  1.00 13.02           C  
ATOM   4832  CD  ARG   122      69.322  47.318  77.769  1.00 13.69           C  
ATOM   4833  NE  ARG   122      68.287  48.282  78.149  1.00 13.08           N  
ATOM   4834  CZ  ARG   122      67.886  49.308  77.407  1.00 15.18           C  
ATOM   4835  NH1 ARG   122      68.372  49.496  76.189  1.00 15.76           N  
ATOM   4836  NH2 ARG   122      66.952  50.136  77.870  1.00 15.43           N  
ATOM   4837  N   GLY   123      70.024  44.489  73.807  1.00 10.93           N  
ATOM   4838  CA  GLY   123      69.728  44.923  72.463  1.00 12.11           C  
ATOM   4839  C   GLY   123      68.832  43.942  71.757  1.00 10.92           C  
ATOM   4840  O   GLY   123      67.879  44.335  71.092  1.00 11.97           O  
ATOM   4841  N   SER   124      69.147  42.658  71.879  1.00 11.84           N  
ATOM   4842  CA  SER   124      68.289  41.598  71.314  1.00 12.43           C  
ATOM   4843  C   SER   124      66.855  41.606  71.898  1.00 11.52           C  
ATOM   4844  O   SER   124      65.874  41.445  71.187  1.00 12.03           O  
ATOM   4845  CB  SER   124      68.951  40.237  71.508  1.00 13.17           C  
ATOM   4846  OG  SER   124      70.098  40.135  70.688  1.00 14.58           O  
ATOM   4847  N   PHE   125      66.754  41.814  73.197  1.00 10.91           N  
ATOM   4848  CA  PHE   125      65.472  41.833  73.875  1.00 11.04           C  
ATOM   4849  C   PHE   125      64.646  43.039  73.427  1.00 10.57           C  
ATOM   4850  O   PHE   125      63.471  42.909  73.092  1.00 10.43           O  
ATOM   4851  CB  PHE   125      65.703  41.865  75.387  1.00 11.54           C  
ATOM   4852  CG  PHE   125      64.418  41.773  76.193  1.00 10.16           C  
ATOM   4853  CD1 PHE   125      63.897  40.544  76.579  1.00 13.28           C  
ATOM   4854  CD2 PHE   125      63.741  42.919  76.557  1.00 11.17           C  
ATOM   4855  CE1 PHE   125      62.693  40.470  77.301  1.00 11.83           C  
ATOM   4856  CE2 PHE   125      62.552  42.848  77.299  1.00 12.77           C  
ATOM   4857  CZ  PHE   125      62.044  41.624  77.670  1.00 12.83           C  
ATOM   4858  N   VAL   126      65.256  44.219  73.410  1.00  9.95           N  
ATOM   4859  CA  VAL   126      64.511  45.438  73.075  1.00 10.61           C  
ATOM   4860  C   VAL   126      64.085  45.414  71.595  1.00 10.08           C  
ATOM   4861  O   VAL   126      62.974  45.786  71.260  1.00  8.91           O  
ATOM   4862  CB  VAL   126      65.253  46.746  73.445  1.00 12.17           C  
ATOM   4863  CG1 VAL   126      66.411  46.975  72.549  1.00 13.03           C  
ATOM   4864  CG2 VAL   126      64.261  47.941  73.333  1.00 13.60           C  
ATOM   4865  N   CYS   127      64.940  44.918  70.706  1.00  8.78           N  
ATOM   4866  CA  CYS   127      64.556  44.829  69.293  1.00  9.64           C  
ATOM   4867  C   CYS   127      63.430  43.799  69.065  1.00  9.04           C  
ATOM   4868  O   CYS   127      62.509  44.066  68.289  1.00  9.08           O  
ATOM   4869  CB  CYS   127      65.755  44.527  68.395  1.00 11.59           C  
ATOM   4870  SG  CYS   127      66.985  45.896  68.327  1.00 12.35           S  
ATOM   4871  N   ALA   128      63.515  42.647  69.720  1.00  9.80           N  
ATOM   4872  CA  ALA   128      62.455  41.630  69.677  1.00 10.15           C  
ATOM   4873  C   ALA   128      61.138  42.245  70.181  1.00 11.65           C  
ATOM   4874  O   ALA   128      60.084  42.133  69.539  1.00 11.05           O  
ATOM   4875  CB  ALA   128      62.843  40.415  70.540  1.00 10.91           C  
ATOM   4876  N   GLN   129      61.188  42.911  71.330  1.00 11.23           N  
ATOM   4877  CA  GLN   129      59.985  43.547  71.886  1.00 11.14           C  
ATOM   4878  C   GLN   129      59.314  44.538  70.907  1.00 10.13           C  
ATOM   4879  O   GLN   129      58.088  44.591  70.759  1.00 11.68           O  
ATOM   4880  CB  GLN   129      60.369  44.283  73.190  1.00 11.56           C  
ATOM   4881  CG  GLN   129      59.181  44.730  74.003  1.00 13.69           C  
ATOM   4882  CD  GLN   129      59.602  45.485  75.254  1.00 13.88           C  
ATOM   4883  OE1 GLN   129      60.151  46.609  75.176  1.00 14.78           O  
ATOM   4884  NE2 GLN   129      59.383  44.865  76.410  1.00 12.56           N  
ATOM   4885  N   ALA   130      60.143  45.338  70.237  1.00 11.19           N  
ATOM   4886  CA  ALA   130      59.670  46.369  69.343  1.00 10.54           C  
ATOM   4887  C   ALA   130      59.142  45.773  68.036  1.00 11.30           C  
ATOM   4888  O   ALA   130      58.129  46.269  67.490  1.00 11.80           O  
ATOM   4889  CB  ALA   130      60.775  47.412  69.087  1.00 10.80           C  
ATOM   4890  N   CYS   131      59.797  44.715  67.541  1.00  9.61           N  
ATOM   4891  CA  CYS   131      59.391  44.102  66.271  1.00  9.08           C  
ATOM   4892  C   CYS   131      58.218  43.106  66.416  1.00 10.40           C  
ATOM   4893  O   CYS   131      57.470  42.901  65.465  1.00 11.49           O  
ATOM   4894  CB  CYS   131      60.552  43.393  65.597  1.00  9.36           C  
ATOM   4895  SG  CYS   131      61.871  44.495  65.006  1.00 11.22           S  
ATOM   4896  N   LEU   132      58.079  42.475  67.581  1.00 10.77           N  
ATOM   4897  CA  LEU   132      57.107  41.373  67.726  1.00  9.18           C  
ATOM   4898  C   LEU   132      55.663  41.690  67.279  1.00 10.03           C  
ATOM   4899  O   LEU   132      55.045  40.850  66.604  1.00  9.95           O  
ATOM   4900  CB  LEU   132      57.153  40.761  69.134  1.00 11.17           C  
ATOM   4901  CG  LEU   132      58.164  39.617  69.230  1.00 11.35           C  
ATOM   4902  CD1 LEU   132      58.557  39.333  70.702  1.00 13.15           C  
ATOM   4903  CD2 LEU   132      57.596  38.377  68.539  1.00 12.42           C  
ATOM   4904  N   PRO   133      55.114  42.868  67.665  1.00 10.54           N  
ATOM   4905  CA  PRO   133      53.739  43.225  67.224  1.00 11.32           C  
ATOM   4906  C   PRO   133      53.565  43.175  65.705  1.00 12.10           C  
ATOM   4907  O   PRO   133      52.485  42.830  65.204  1.00 12.95           O  
ATOM   4908  CB  PRO   133      53.538  44.635  67.781  1.00 11.39           C  
ATOM   4909  CG  PRO   133      54.421  44.675  69.013  1.00 11.30           C  
ATOM   4910  CD  PRO   133      55.667  43.877  68.578  1.00 11.32           C  
ATOM   4911  N   HIS   134      54.638  43.491  64.986  1.00 12.10           N  
ATOM   4912  CA  HIS   134      54.660  43.452  63.521  1.00 12.42           C  
ATOM   4913  C   HIS   134      54.978  42.070  62.973  1.00 12.18           C  
ATOM   4914  O   HIS   134      54.335  41.617  62.025  1.00 12.08           O  
ATOM   4915  CB  HIS   134      55.651  44.492  63.010  1.00 11.83           C  
ATOM   4916  CG  HIS   134      55.357  45.859  63.526  1.00 13.73           C  
ATOM   4917  ND1 HIS   134      54.203  46.531  63.184  1.00 13.93           N  
ATOM   4918  CD2 HIS   134      56.001  46.638  64.423  1.00 16.48           C  
ATOM   4919  CE1 HIS   134      54.173  47.687  63.821  1.00 16.64           C  
ATOM   4920  NE2 HIS   134      55.247  47.771  64.587  1.00 16.02           N  
ATOM   4921  N   LEU   135      55.956  41.390  63.574  1.00 11.61           N  
ATOM   4922  CA  LEU   135      56.254  40.010  63.200  1.00 11.72           C  
ATOM   4923  C   LEU   135      55.029  39.117  63.326  1.00 12.63           C  
ATOM   4924  O   LEU   135      54.788  38.262  62.481  1.00 12.07           O  
ATOM   4925  CB  LEU   135      57.383  39.427  64.059  1.00 11.18           C  
ATOM   4926  CG  LEU   135      58.759  40.045  63.825  1.00 11.31           C  
ATOM   4927  CD1 LEU   135      59.726  39.571  64.899  1.00 11.84           C  
ATOM   4928  CD2 LEU   135      59.269  39.678  62.420  1.00 11.63           C  
ATOM   4929  N   LEU   136      54.253  39.312  64.391  1.00 12.46           N  
ATOM   4930  CA  LEU   136      53.108  38.423  64.659  1.00 14.15           C  
ATOM   4931  C   LEU   136      52.018  38.541  63.584  1.00 16.01           C  
ATOM   4932  O   LEU   136      51.106  37.706  63.514  1.00 19.25           O  
ATOM   4933  CB  LEU   136      52.539  38.725  66.045  1.00 12.70           C  
ATOM   4934  CG  LEU   136      53.382  38.188  67.206  1.00 12.96           C  
ATOM   4935  CD1 LEU   136      52.957  38.868  68.508  1.00 14.52           C  
ATOM   4936  CD2 LEU   136      53.292  36.667  67.308  1.00 10.87           C  
ATOM   4937  N   GLN   137      52.110  39.571  62.759  1.00 16.74           N  
ATOM   4938  CA  GLN   137      51.183  39.771  61.640  1.00 18.19           C  
ATOM   4939  C   GLN   137      51.740  39.369  60.282  1.00 16.98           C  
ATOM   4940  O   GLN   137      51.024  39.422  59.274  1.00 17.55           O  
ATOM   4941  CB  GLN   137      50.766  41.225  61.630  1.00 19.63           C  
ATOM   4942  CG  GLN   137      50.111  41.555  62.966  1.00 23.17           C  
ATOM   4943  CD  GLN   137      49.402  42.830  62.973  1.00 27.69           C  
ATOM   4944  OE1 GLN   137      49.575  43.662  62.078  1.00 30.53           O  
ATOM   4945  NE2 GLN   137      48.580  43.029  64.003  1.00 30.84           N  
ATOM   4946  N   ALA   138      53.013  38.981  60.249  1.00 13.57           N  
ATOM   4947  CA  ALA   138      53.674  38.667  58.989  1.00 13.26           C  
ATOM   4948  C   ALA   138      53.365  37.223  58.577  1.00 13.01           C  
ATOM   4949  O   ALA   138      53.091  36.390  59.436  1.00 13.92           O  
ATOM   4950  CB  ALA   138      55.196  38.887  59.136  1.00 10.87           C  
ATOM   4951  N   PRO   139      53.404  36.912  57.256  1.00 13.60           N  
ATOM   4952  CA  PRO   139      53.165  35.548  56.775  1.00 14.70           C  
ATOM   4953  C   PRO   139      54.134  34.472  57.301  1.00 13.61           C  
ATOM   4954  O   PRO   139      53.723  33.352  57.564  1.00 14.84           O  
ATOM   4955  CB  PRO   139      53.284  35.676  55.245  1.00 15.05           C  
ATOM   4956  CG  PRO   139      53.252  37.102  54.932  1.00 16.25           C  
ATOM   4957  CD  PRO   139      53.571  37.875  56.152  1.00 14.63           C  
ATOM   4958  N   ASN   140      55.419  34.808  57.417  1.00 12.46           N  
ATOM   4959  CA  ASN   140      56.460  33.845  57.711  1.00 10.76           C  
ATOM   4960  C   ASN   140      57.542  34.465  58.631  1.00 10.92           C  
ATOM   4961  O   ASN   140      58.709  34.556  58.259  1.00 11.27           O  
ATOM   4962  CB  ASN   140      57.067  33.343  56.395  1.00 10.37           C  
ATOM   4963  CG  ASN   140      57.839  32.044  56.564  1.00 12.11           C  
ATOM   4964  OD1 ASN   140      57.293  31.043  57.044  1.00 12.13           O  
ATOM   4965  ND2 ASN   140      59.126  32.054  56.176  1.00 11.73           N  
ATOM   4966  N   PRO   141      57.145  34.894  59.845  1.00  9.73           N  
ATOM   4967  CA  PRO   141      57.996  35.713  60.714  1.00  8.93           C  
ATOM   4968  C   PRO   141      59.180  34.962  61.305  1.00  8.86           C  
ATOM   4969  O   PRO   141      59.015  33.848  61.832  1.00 10.00           O  
ATOM   4970  CB  PRO   141      57.056  36.160  61.844  1.00  8.95           C  
ATOM   4971  CG  PRO   141      55.917  35.154  61.826  1.00  9.54           C  
ATOM   4972  CD  PRO   141      55.826  34.603  60.458  1.00  9.92           C  
ATOM   4973  N   HIS   142      60.352  35.589  61.252  1.00  9.98           N  
ATOM   4974  CA  HIS   142      61.537  35.073  61.919  1.00  8.85           C  
ATOM   4975  C   HIS   142      62.138  36.109  62.858  1.00  8.43           C  
ATOM   4976  O   HIS   142      62.186  37.313  62.542  1.00  8.45           O  
ATOM   4977  CB  HIS   142      62.655  34.688  60.939  1.00  9.11           C  
ATOM   4978  CG  HIS   142      62.416  33.425  60.173  1.00  8.48           C  
ATOM   4979  ND1 HIS   142      63.165  32.291  60.363  1.00 10.07           N  
ATOM   4980  CD2 HIS   142      61.535  33.139  59.187  1.00  8.64           C  
ATOM   4981  CE1 HIS   142      62.749  31.350  59.525  1.00  8.26           C  
ATOM   4982  NE2 HIS   142      61.770  31.844  58.788  1.00  8.78           N  
ATOM   4983  N   ILE   143      62.666  35.625  63.979  1.00  7.13           N  
ATOM   4984  CA  ILE   143      63.736  36.341  64.693  1.00  8.08           C  
ATOM   4985  C   ILE   143      64.959  35.437  64.669  1.00  9.27           C  
ATOM   4986  O   ILE   143      64.889  34.307  65.156  1.00  8.91           O  
ATOM   4987  CB  ILE   143      63.392  36.694  66.158  1.00  7.68           C  
ATOM   4988  CG1 ILE   143      62.101  37.525  66.218  1.00  8.75           C  
ATOM   4989  CG2 ILE   143      64.586  37.385  66.855  1.00  8.80           C  
ATOM   4990  CD1 ILE   143      61.726  37.950  67.589  1.00  9.49           C  
ATOM   4991  N   LEU   144      66.067  35.939  64.131  1.00  8.41           N  
ATOM   4992  CA  LEU   144      67.316  35.177  64.084  1.00  8.62           C  
ATOM   4993  C   LEU   144      68.386  35.952  64.838  1.00  8.23           C  
ATOM   4994  O   LEU   144      68.756  37.060  64.432  1.00  8.96           O  
ATOM   4995  CB  LEU   144      67.739  34.959  62.640  1.00  9.69           C  
ATOM   4996  CG  LEU   144      68.944  33.999  62.466  1.00  7.56           C  
ATOM   4997  CD1 LEU   144      68.602  32.611  63.078  1.00 10.14           C  
ATOM   4998  CD2 LEU   144      69.312  33.862  61.003  1.00 10.82           C  
ATOM   4999  N   THR   145      68.862  35.377  65.942  1.00  7.76           N  
ATOM   5000  CA  THR   145      69.830  36.025  66.798  1.00  7.83           C  
ATOM   5001  C   THR   145      71.161  35.351  66.580  1.00  8.18           C  
ATOM   5002  O   THR   145      71.228  34.139  66.579  1.00  9.08           O  
ATOM   5003  CB  THR   145      69.395  35.948  68.263  1.00  8.67           C  
ATOM   5004  OG1 THR   145      68.161  36.674  68.398  1.00  7.71           O  
ATOM   5005  CG2 THR   145      70.427  36.543  69.196  1.00  9.71           C  
ATOM   5006  N   LEU   146      72.199  36.139  66.383  1.00  9.45           N  
ATOM   5007  CA  LEU   146      73.514  35.582  66.115  1.00  9.61           C  
ATOM   5008  C   LEU   146      74.244  35.352  67.441  1.00 10.74           C  
ATOM   5009  O   LEU   146      74.892  36.248  68.012  1.00 10.43           O  
ATOM   5010  CB  LEU   146      74.276  36.501  65.146  1.00 10.85           C  
ATOM   5011  CG  LEU   146      73.526  36.849  63.848  1.00 10.11           C  
ATOM   5012  CD1 LEU   146      74.460  37.650  62.891  1.00 11.64           C  
ATOM   5013  CD2 LEU   146      72.864  35.599  63.200  1.00 10.55           C  
ATOM   5014  N   ALA   147      74.062  34.146  67.964  1.00 10.19           N  
ATOM   5015  CA  ALA   147      74.465  33.801  69.319  1.00  9.82           C  
ATOM   5016  C   ALA   147      74.669  32.291  69.385  1.00  8.49           C  
ATOM   5017  O   ALA   147      74.109  31.543  68.580  1.00  9.17           O  
ATOM   5018  CB  ALA   147      73.416  34.232  70.355  1.00 10.13           C  
ATOM   5019  N   PRO   148      75.480  31.843  70.345  1.00  9.47           N  
ATOM   5020  CA  PRO   148      75.788  30.414  70.387  1.00  9.21           C  
ATOM   5021  C   PRO   148      74.721  29.572  71.101  1.00  9.33           C  
ATOM   5022  O   PRO   148      73.805  30.114  71.771  1.00  9.48           O  
ATOM   5023  CB  PRO   148      77.110  30.369  71.170  1.00  9.13           C  
ATOM   5024  CG  PRO   148      77.024  31.533  72.111  1.00  9.41           C  
ATOM   5025  CD  PRO   148      76.242  32.604  71.349  1.00  9.84           C  
ATOM   5026  N   PRO   149      74.825  28.242  70.970  1.00 10.68           N  
ATOM   5027  CA  PRO   149      73.992  27.398  71.799  1.00 10.84           C  
ATOM   5028  C   PRO   149      74.222  27.720  73.298  1.00 11.01           C  
ATOM   5029  O   PRO   149      75.353  28.008  73.701  1.00 11.27           O  
ATOM   5030  CB  PRO   149      74.441  25.974  71.425  1.00 11.31           C  
ATOM   5031  CG  PRO   149      75.058  26.107  70.082  1.00 13.25           C  
ATOM   5032  CD  PRO   149      75.689  27.455  70.069  1.00 11.23           C  
ATOM   5033  N   PRO   150      73.151  27.737  74.103  1.00 11.55           N  
ATOM   5034  CA  PRO   150      73.374  28.037  75.516  1.00 13.44           C  
ATOM   5035  C   PRO   150      74.165  26.917  76.172  1.00 12.69           C  
ATOM   5036  O   PRO   150      73.973  25.753  75.827  1.00 12.48           O  
ATOM   5037  CB  PRO   150      71.968  28.171  76.089  1.00 14.26           C  
ATOM   5038  CG  PRO   150      71.107  27.419  75.158  1.00 13.94           C  
ATOM   5039  CD  PRO   150      71.723  27.531  73.800  1.00 12.80           C  
ATOM   5040  N   SER   151      75.085  27.287  77.060  1.00 12.97           N  
ATOM   5041  CA  SER   151      75.913  26.337  77.760  1.00 12.67           C  
ATOM   5042  C   SER   151      76.224  26.798  79.189  1.00 11.79           C  
ATOM   5043  O   SER   151      76.415  27.985  79.449  1.00 10.95           O  
ATOM   5044  CB  SER   151      77.227  26.145  76.996  1.00 13.34           C  
ATOM   5045  OG  SER   151      78.177  25.447  77.782  1.00 15.32           O  
ATOM   5046  N   LEU   152      76.299  25.823  80.091  1.00 12.48           N  
ATOM   5047  CA  LEU   152      76.660  26.062  81.482  1.00 12.82           C  
ATOM   5048  C   LEU   152      78.100  25.619  81.746  1.00 13.82           C  
ATOM   5049  O   LEU   152      78.467  25.384  82.887  1.00 13.85           O  
ATOM   5050  CB  LEU   152      75.699  25.316  82.402  1.00 13.26           C  
ATOM   5051  CG  LEU   152      74.207  25.617  82.213  1.00 13.79           C  
ATOM   5052  CD1 LEU   152      73.254  24.806  83.109  1.00 16.95           C  
ATOM   5053  CD2 LEU   152      73.998  27.120  82.395  1.00 14.84           C  
ATOM   5054  N   ASN   153      78.909  25.520  80.696  1.00 14.56           N  
ATOM   5055  CA  ASN   153      80.316  25.120  80.813  1.00 15.16           C  
ATOM   5056  C   ASN   153      81.090  26.098  81.721  1.00 14.56           C  
ATOM   5057  O   ASN   153      81.274  27.238  81.359  1.00 12.48           O  
ATOM   5058  CB  ASN   153      80.953  25.082  79.412  1.00 15.67           C  
ATOM   5059  CG  ASN   153      82.402  24.595  79.428  1.00 18.65           C  
ATOM   5060  OD1 ASN   153      83.123  24.785  80.393  1.00 19.88           O  
ATOM   5061  ND2 ASN   153      82.818  23.947  78.351  1.00 19.99           N  
ATOM   5062  N   PRO   154      81.538  25.649  82.909  1.00 16.27           N  
ATOM   5063  CA  PRO   154      82.166  26.576  83.859  1.00 16.11           C  
ATOM   5064  C   PRO   154      83.430  27.274  83.360  1.00 16.70           C  
ATOM   5065  O   PRO   154      83.672  28.430  83.732  1.00 17.81           O  
ATOM   5066  CB  PRO   154      82.497  25.681  85.071  1.00 16.99           C  
ATOM   5067  CG  PRO   154      81.655  24.488  84.943  1.00 18.79           C  
ATOM   5068  CD  PRO   154      81.443  24.282  83.457  1.00 17.38           C  
ATOM   5069  N   ALA   155      84.241  26.569  82.574  1.00 16.28           N  
ATOM   5070  CA  ALA   155      85.427  27.138  81.941  1.00 15.99           C  
ATOM   5071  C   ALA   155      85.106  28.366  81.069  1.00 15.24           C  
ATOM   5072  O   ALA   155      85.818  29.369  81.106  1.00 14.81           O  
ATOM   5073  CB  ALA   155      86.139  26.059  81.097  1.00 16.78           C  
ATOM   5074  N   TRP   156      84.012  28.299  80.316  1.00 14.98           N  
ATOM   5075  CA  TRP   156      83.596  29.403  79.455  1.00 14.84           C  
ATOM   5076  C   TRP   156      83.109  30.615  80.265  1.00 14.80           C  
ATOM   5077  O   TRP   156      83.330  31.768  79.897  1.00 16.21           O  
ATOM   5078  CB  TRP   156      82.493  28.941  78.489  1.00 16.31           C  
ATOM   5079  CG  TRP   156      82.920  27.855  77.495  1.00 17.06           C  
ATOM   5080  CD1 TRP   156      84.188  27.333  77.315  1.00 17.90           C  
ATOM   5081  CD2 TRP   156      82.085  27.208  76.537  1.00 16.22           C  
ATOM   5082  NE1 TRP   156      84.169  26.398  76.309  1.00 17.25           N  
ATOM   5083  CE2 TRP   156      82.894  26.296  75.818  1.00 16.73           C  
ATOM   5084  CE3 TRP   156      80.726  27.305  76.212  1.00 15.91           C  
ATOM   5085  CZ2 TRP   156      82.385  25.474  74.814  1.00 17.44           C  
ATOM   5086  CZ3 TRP   156      80.223  26.489  75.198  1.00 17.20           C  
ATOM   5087  CH2 TRP   156      81.047  25.583  74.519  1.00 17.77           C  
ATOM   5088  N   TRP   157      82.424  30.329  81.366  1.00 13.94           N  
ATOM   5089  CA  TRP   157      81.970  31.353  82.284  1.00 13.64           C  
ATOM   5090  C   TRP   157      83.116  31.992  83.065  1.00 13.27           C  
ATOM   5091  O   TRP   157      83.147  33.196  83.195  1.00 14.25           O  
ATOM   5092  CB  TRP   157      80.866  30.814  83.193  1.00 12.20           C  
ATOM   5093  CG  TRP   157      79.571  30.678  82.408  1.00 11.88           C  
ATOM   5094  CD1 TRP   157      79.133  29.593  81.730  1.00 11.93           C  
ATOM   5095  CD2 TRP   157      78.629  31.738  82.126  1.00 11.22           C  
ATOM   5096  NE1 TRP   157      77.938  29.881  81.091  1.00 12.82           N  
ATOM   5097  CE2 TRP   157      77.616  31.191  81.321  1.00 11.10           C  
ATOM   5098  CE3 TRP   157      78.527  33.076  82.526  1.00 11.25           C  
ATOM   5099  CZ2 TRP   157      76.523  31.937  80.883  1.00 11.05           C  
ATOM   5100  CZ3 TRP   157      77.457  33.822  82.079  1.00 11.68           C  
ATOM   5101  CH2 TRP   157      76.459  33.249  81.274  1.00 11.49           C  
ATOM   5102  N   GLY   158      84.070  31.190  83.528  1.00 14.14           N  
ATOM   5103  CA  GLY   158      85.203  31.678  84.278  1.00 14.02           C  
ATOM   5104  C   GLY   158      86.217  32.465  83.452  1.00 14.82           C  
ATOM   5105  O   GLY   158      86.885  33.349  83.978  1.00 17.72           O  
ATOM   5106  N   ALA   159      86.317  32.154  82.153  1.00 14.72           N  
ATOM   5107  CA  ALA   159      87.318  32.745  81.267  1.00 14.94           C  
ATOM   5108  C   ALA   159      87.142  34.248  81.111  1.00 15.18           C  
ATOM   5109  O   ALA   159      88.131  34.992  81.027  1.00 16.65           O  
ATOM   5110  CB  ALA   159      87.289  32.061  79.925  1.00 13.67           C  
ATOM   5111  N   HIS   160      85.879  34.699  81.100  1.00 13.66           N  
ATOM   5112  CA  HIS   160      85.548  36.091  80.871  1.00 13.69           C  
ATOM   5113  C   HIS   160      84.069  36.260  81.181  1.00 13.04           C  
ATOM   5114  O   HIS   160      83.249  36.339  80.287  1.00 10.70           O  
ATOM   5115  CB  HIS   160      85.848  36.537  79.422  1.00 13.39           C  
ATOM   5116  CG  HIS   160      85.746  35.440  78.403  1.00 14.27           C  
ATOM   5117  ND1 HIS   160      84.553  34.824  78.087  1.00 14.09           N  
ATOM   5118  CD2 HIS   160      86.688  34.853  77.622  1.00 15.07           C  
ATOM   5119  CE1 HIS   160      84.764  33.903  77.165  1.00 16.60           C  
ATOM   5120  NE2 HIS   160      86.051  33.897  76.865  1.00 16.45           N  
ATOM   5121  N   THR   161      83.760  36.299  82.464  1.00 12.32           N  
ATOM   5122  CA  THR   161      82.368  36.278  82.925  1.00 12.36           C  
ATOM   5123  C   THR   161      81.500  37.381  82.324  1.00 11.52           C  
ATOM   5124  O   THR   161      80.342  37.142  81.929  1.00 11.52           O  
ATOM   5125  CB  THR   161      82.342  36.341  84.457  1.00 13.06           C  
ATOM   5126  OG1 THR   161      83.142  35.279  84.981  1.00 12.30           O  
ATOM   5127  CG2 THR   161      80.893  36.226  84.999  1.00 11.18           C  
ATOM   5128  N   GLY   162      82.041  38.594  82.211  1.00 11.50           N  
ATOM   5129  CA  GLY   162      81.234  39.705  81.696  1.00 11.59           C  
ATOM   5130  C   GLY   162      80.805  39.473  80.262  1.00 11.89           C  
ATOM   5131  O   GLY   162      79.656  39.683  79.899  1.00 11.18           O  
ATOM   5132  N   TYR   163      81.747  39.020  79.438  1.00 12.00           N  
ATOM   5133  CA  TYR   163      81.447  38.778  78.029  1.00 12.53           C  
ATOM   5134  C   TYR   163      80.522  37.563  77.840  1.00 12.08           C  
ATOM   5135  O   TYR   163      79.591  37.590  77.026  1.00 11.75           O  
ATOM   5136  CB  TYR   163      82.734  38.611  77.212  1.00 13.90           C  
ATOM   5137  CG  TYR   163      82.435  38.218  75.797  1.00 14.42           C  
ATOM   5138  CD1 TYR   163      81.652  39.033  74.997  1.00 14.43           C  
ATOM   5139  CD2 TYR   163      82.915  37.028  75.246  1.00 16.20           C  
ATOM   5140  CE1 TYR   163      81.350  38.696  73.705  1.00 15.28           C  
ATOM   5141  CE2 TYR   163      82.603  36.674  73.949  1.00 15.68           C  
ATOM   5142  CZ  TYR   163      81.813  37.513  73.182  1.00 14.96           C  
ATOM   5143  OH  TYR   163      81.489  37.202  71.880  1.00 17.96           O  
ATOM   5144  N   THR   164      80.803  36.493  78.569  1.00 11.34           N  
ATOM   5145  CA  THR   164      80.000  35.279  78.487  1.00 10.60           C  
ATOM   5146  C   THR   164      78.557  35.593  78.903  1.00 10.53           C  
ATOM   5147  O   THR   164      77.625  35.171  78.220  1.00 11.15           O  
ATOM   5148  CB  THR   164      80.597  34.158  79.318  1.00 10.90           C  
ATOM   5149  OG1 THR   164      81.939  33.874  78.843  1.00  9.94           O  
ATOM   5150  CG2 THR   164      79.751  32.877  79.220  1.00  8.86           C  
ATOM   5151  N   LEU   165      78.384  36.349  79.986  1.00 10.04           N  
ATOM   5152  CA  LEU   165      77.055  36.780  80.403  1.00 10.99           C  
ATOM   5153  C   LEU   165      76.352  37.508  79.259  1.00 11.20           C  
ATOM   5154  O   LEU   165      75.185  37.251  78.985  1.00 11.03           O  
ATOM   5155  CB  LEU   165      77.144  37.728  81.612  1.00 10.74           C  
ATOM   5156  CG  LEU   165      75.811  38.062  82.282  1.00 10.97           C  
ATOM   5157  CD1 LEU   165      75.159  36.786  82.895  1.00 12.62           C  
ATOM   5158  CD2 LEU   165      75.973  39.174  83.356  1.00 11.21           C  
ATOM   5159  N   ALA   166      77.068  38.431  78.604  1.00 11.10           N  
ATOM   5160  CA  ALA   166      76.474  39.264  77.550  1.00 10.84           C  
ATOM   5161  C   ALA   166      76.073  38.457  76.326  1.00 11.42           C  
ATOM   5162  O   ALA   166      74.969  38.621  75.804  1.00 10.68           O  
ATOM   5163  CB  ALA   166      77.403  40.407  77.140  1.00 11.67           C  
ATOM   5164  N   LYS   167      76.951  37.571  75.884  1.00 11.98           N  
ATOM   5165  CA  LYS   167      76.727  36.830  74.630  1.00 12.54           C  
ATOM   5166  C   LYS   167      75.839  35.627  74.874  1.00 11.75           C  
ATOM   5167  O   LYS   167      74.891  35.390  74.115  1.00 12.03           O  
ATOM   5168  CB  LYS   167      78.053  36.402  73.991  1.00 13.01           C  
ATOM   5169  CG  LYS   167      77.943  36.218  72.469  1.00 15.17           C  
ATOM   5170  CD  LYS   167      77.892  37.601  71.798  1.00 17.60           C  
ATOM   5171  CE  LYS   167      77.480  37.602  70.363  1.00 21.69           C  
ATOM   5172  NZ  LYS   167      77.482  39.019  69.896  1.00 23.77           N  
ATOM   5173  N   MET   168      76.095  34.873  75.938  1.00 10.34           N  
ATOM   5174  CA  MET   168      75.119  33.851  76.326  1.00 10.50           C  
ATOM   5175  C   MET   168      73.760  34.492  76.627  1.00 10.74           C  
ATOM   5176  O   MET   168      72.737  33.864  76.443  1.00 11.42           O  
ATOM   5177  CB  MET   168      75.592  32.997  77.487  1.00 11.10           C  
ATOM   5178  CG  MET   168      76.757  32.126  77.107  1.00 12.68           C  
ATOM   5179  SD  MET   168      76.108  30.665  75.946  1.00 19.95          SE  
ATOM   5180  CE  MET   168      77.842  29.786  75.485  1.00 10.61           C  
ATOM   5181  N   GLY   169      73.757  35.738  77.087  1.00 11.10           N  
ATOM   5182  CA  GLY   169      72.487  36.444  77.328  1.00 10.54           C  
ATOM   5183  C   GLY   169      71.662  36.546  76.068  1.00 10.60           C  
ATOM   5184  O   GLY   169      70.401  36.490  76.123  1.00  9.88           O  
ATOM   5185  N   MET   170      72.323  36.713  74.919  1.00 10.12           N  
ATOM   5186  CA  MET   170      71.602  36.754  73.648  1.00 13.27           C  
ATOM   5187  C   MET   170      70.969  35.403  73.353  1.00 11.19           C  
ATOM   5188  O   MET   170      69.841  35.333  72.875  1.00 10.49           O  
ATOM   5189  CB  MET   170      72.523  37.166  72.496  1.00 12.00           C  
ATOM   5190  CG  MET   170      72.855  38.616  72.502  1.00 14.77           C  
ATOM   5191  SD  MET   170      74.197  39.010  71.113  1.00 23.37          SE  
ATOM   5192  CE  MET   170      73.059  38.764  69.527  1.00 17.34           C  
ATOM   5193  N   SER   171      71.703  34.329  73.645  1.00 10.04           N  
ATOM   5194  CA  SER   171      71.198  32.953  73.510  1.00 10.06           C  
ATOM   5195  C   SER   171      70.010  32.670  74.429  1.00  9.55           C  
ATOM   5196  O   SER   171      69.042  32.033  74.028  1.00  8.84           O  
ATOM   5197  CB  SER   171      72.321  31.940  73.793  1.00 10.61           C  
ATOM   5198  OG  SER   171      73.515  32.341  73.128  1.00  9.88           O  
ATOM   5199  N   LEU   172      70.057  33.211  75.646  1.00  9.34           N  
ATOM   5200  CA  LEU   172      69.070  32.932  76.669  1.00  9.39           C  
ATOM   5201  C   LEU   172      67.785  33.752  76.435  1.00 10.31           C  
ATOM   5202  O   LEU   172      66.677  33.251  76.618  1.00 10.52           O  
ATOM   5203  CB  LEU   172      69.661  33.146  78.057  1.00  9.93           C  
ATOM   5204  CG  LEU   172      70.796  32.181  78.409  1.00 10.49           C  
ATOM   5205  CD1 LEU   172      71.469  32.706  79.679  1.00 13.66           C  
ATOM   5206  CD2 LEU   172      70.291  30.709  78.581  1.00 13.42           C  
ATOM   5207  N   VAL   173      67.952  34.993  75.978  1.00 11.39           N  
ATOM   5208  CA  VAL   173      66.839  35.772  75.445  1.00 10.64           C  
ATOM   5209  C   VAL   173      66.154  35.028  74.300  1.00 11.23           C  
ATOM   5210  O   VAL   173      64.918  34.943  74.269  1.00 11.24           O  
ATOM   5211  CB  VAL   173      67.291  37.195  75.021  1.00 10.93           C  
ATOM   5212  CG1 VAL   173      66.261  37.906  74.103  1.00  9.87           C  
ATOM   5213  CG2 VAL   173      67.607  38.028  76.268  1.00 11.90           C  
ATOM   5214  N   THR   174      66.938  34.471  73.376  1.00 10.79           N  
ATOM   5215  CA  THR   174      66.376  33.668  72.287  1.00 10.55           C  
ATOM   5216  C   THR   174      65.586  32.466  72.836  1.00 10.31           C  
ATOM   5217  O   THR   174      64.503  32.181  72.383  1.00  9.27           O  
ATOM   5218  CB  THR   174      67.467  33.169  71.328  1.00 11.68           C  
ATOM   5219  OG1 THR   174      68.128  34.291  70.737  1.00 10.40           O  
ATOM   5220  CG2 THR   174      66.857  32.276  70.221  1.00 14.65           C  
ATOM   5221  N   LEU   175      66.173  31.762  73.798  1.00  9.89           N  
ATOM   5222  CA  LEU   175      65.532  30.604  74.478  1.00 10.76           C  
ATOM   5223  C   LEU   175      64.148  30.968  75.037  1.00 10.60           C  
ATOM   5224  O   LEU   175      63.162  30.274  74.781  1.00 11.15           O  
ATOM   5225  CB  LEU   175      66.472  30.117  75.590  1.00 10.82           C  
ATOM   5226  CG  LEU   175      66.125  28.826  76.327  1.00 14.98           C  
ATOM   5227  CD1 LEU   175      66.054  27.656  75.367  1.00 16.59           C  
ATOM   5228  CD2 LEU   175      67.119  28.559  77.475  1.00 14.66           C  
ATOM   5229  N   GLY   176      64.076  32.093  75.745  1.00  9.37           N  
ATOM   5230  CA  GLY   176      62.833  32.576  76.339  1.00  9.14           C  
ATOM   5231  C   GLY   176      61.830  33.089  75.334  1.00  9.80           C  
ATOM   5232  O   GLY   176      60.641  32.810  75.447  1.00  9.37           O  
ATOM   5233  N   LEU   177      62.295  33.911  74.404  1.00  9.70           N  
ATOM   5234  CA  LEU   177      61.442  34.424  73.350  1.00  9.48           C  
ATOM   5235  C   LEU   177      60.778  33.274  72.550  1.00  8.52           C  
ATOM   5236  O   LEU   177      59.566  33.305  72.253  1.00  9.73           O  
ATOM   5237  CB  LEU   177      62.249  35.331  72.431  1.00  9.06           C  
ATOM   5238  CG  LEU   177      62.696  36.710  72.924  1.00 10.74           C  
ATOM   5239  CD1 LEU   177      63.597  37.313  71.853  1.00 11.62           C  
ATOM   5240  CD2 LEU   177      61.504  37.626  73.284  1.00 12.30           C  
ATOM   5241  N   ALA   178      61.566  32.256  72.216  1.00  8.43           N  
ATOM   5242  CA  ALA   178      61.093  31.109  71.453  1.00  9.28           C  
ATOM   5243  C   ALA   178      60.042  30.336  72.235  1.00 10.35           C  
ATOM   5244  O   ALA   178      59.033  29.929  71.680  1.00 12.33           O  
ATOM   5245  CB  ALA   178      62.282  30.197  71.065  1.00  8.50           C  
ATOM   5246  N   ALA   179      60.254  30.180  73.533  1.00  9.75           N  
ATOM   5247  CA  ALA   179      59.303  29.481  74.387  1.00  9.25           C  
ATOM   5248  C   ALA   179      58.010  30.275  74.495  1.00  9.33           C  
ATOM   5249  O   ALA   179      56.932  29.689  74.462  1.00 11.27           O  
ATOM   5250  CB  ALA   179      59.889  29.198  75.767  1.00  9.17           C  
ATOM   5251  N   GLU   180      58.102  31.598  74.575  1.00  9.20           N  
ATOM   5252  CA  GLU   180      56.897  32.431  74.672  1.00 10.66           C  
ATOM   5253  C   GLU   180      56.156  32.548  73.327  1.00 11.36           C  
ATOM   5254  O   GLU   180      54.948  32.296  73.260  1.00 13.31           O  
ATOM   5255  CB  GLU   180      57.199  33.824  75.238  1.00 10.57           C  
ATOM   5256  CG  GLU   180      55.909  34.623  75.449  1.00 12.04           C  
ATOM   5257  CD  GLU   180      56.024  35.918  76.272  1.00 12.93           C  
ATOM   5258  OE1 GLU   180      57.140  36.401  76.585  1.00 12.71           O  
ATOM   5259  OE2 GLU   180      54.928  36.453  76.579  1.00 13.47           O  
ATOM   5260  N   PHE   181      56.876  32.935  72.268  1.00 10.03           N  
ATOM   5261  CA  PHE   181      56.241  33.340  71.006  1.00  9.11           C  
ATOM   5262  C   PHE   181      56.311  32.308  69.872  1.00  9.14           C  
ATOM   5263  O   PHE   181      55.526  32.373  68.907  1.00  8.76           O  
ATOM   5264  CB  PHE   181      56.790  34.687  70.529  1.00  8.81           C  
ATOM   5265  CG  PHE   181      56.602  35.780  71.528  1.00  8.08           C  
ATOM   5266  CD1 PHE   181      55.378  36.399  71.658  1.00 10.81           C  
ATOM   5267  CD2 PHE   181      57.633  36.145  72.383  1.00  8.50           C  
ATOM   5268  CE1 PHE   181      55.179  37.385  72.606  1.00 13.06           C  
ATOM   5269  CE2 PHE   181      57.445  37.144  73.331  1.00 11.65           C  
ATOM   5270  CZ  PHE   181      56.206  37.750  73.445  1.00 10.19           C  
ATOM   5271  N   GLY   182      57.243  31.373  69.976  1.00  8.25           N  
ATOM   5272  CA  GLY   182      57.374  30.259  69.046  1.00  9.83           C  
ATOM   5273  C   GLY   182      56.049  29.554  68.803  1.00 10.22           C  
ATOM   5274  O   GLY   182      55.683  29.290  67.645  1.00 10.48           O  
ATOM   5275  N   PRO   183      55.312  29.266  69.892  1.00 11.08           N  
ATOM   5276  CA  PRO   183      53.963  28.671  69.718  1.00 12.39           C  
ATOM   5277  C   PRO   183      52.947  29.455  68.867  1.00 13.67           C  
ATOM   5278  O   PRO   183      52.015  28.824  68.319  1.00 14.71           O  
ATOM   5279  CB  PRO   183      53.482  28.491  71.155  1.00 12.40           C  
ATOM   5280  CG  PRO   183      54.800  28.346  71.972  1.00 11.55           C  
ATOM   5281  CD  PRO   183      55.674  29.382  71.314  1.00 12.27           C  
ATOM   5282  N   GLN   184      53.152  30.767  68.710  1.00 13.30           N  
ATOM   5283  CA  GLN   184      52.369  31.623  67.809  1.00 15.86           C  
ATOM   5284  C   GLN   184      52.832  31.589  66.346  1.00 15.32           C  
ATOM   5285  O   GLN   184      52.274  32.308  65.506  1.00 16.18           O  
ATOM   5286  CB  GLN   184      52.369  33.073  68.290  1.00 17.64           C  
ATOM   5287  CG  GLN   184      51.963  33.232  69.728  1.00 22.03           C  
ATOM   5288  CD  GLN   184      51.321  34.561  69.989  1.00 25.53           C  
ATOM   5289  OE1 GLN   184      50.299  34.902  69.375  1.00 29.99           O  
ATOM   5290  NE2 GLN   184      51.912  35.335  70.875  1.00 25.73           N  
ATOM   5291  N   GLY   185      53.845  30.777  66.061  1.00 13.43           N  
ATOM   5292  CA  GLY   185      54.344  30.563  64.705  1.00 13.34           C  
ATOM   5293  C   GLY   185      55.509  31.472  64.316  1.00 12.38           C  
ATOM   5294  O   GLY   185      55.856  31.555  63.128  1.00 11.77           O  
ATOM   5295  N   VAL   186      56.104  32.158  65.283  1.00 11.41           N  
ATOM   5296  CA  VAL   186      57.310  32.964  65.015  1.00  9.94           C  
ATOM   5297  C   VAL   186      58.534  32.043  65.073  1.00 10.45           C  
ATOM   5298  O   VAL   186      58.731  31.360  66.068  1.00 10.06           O  
ATOM   5299  CB  VAL   186      57.482  34.150  66.025  1.00 10.23           C  
ATOM   5300  CG1 VAL   186      58.684  35.044  65.578  1.00  8.77           C  
ATOM   5301  CG2 VAL   186      56.174  34.979  66.166  1.00 12.50           C  
ATOM   5302  N   ALA   187      59.359  32.039  64.016  1.00  9.98           N  
ATOM   5303  CA  ALA   187      60.599  31.240  63.996  1.00  9.28           C  
ATOM   5304  C   ALA   187      61.705  32.004  64.719  1.00  8.67           C  
ATOM   5305  O   ALA   187      62.406  32.837  64.124  1.00  9.41           O  
ATOM   5306  CB  ALA   187      61.005  30.888  62.601  1.00 10.54           C  
ATOM   5307  N   ILE   188      61.829  31.731  66.019  1.00  7.96           N  
ATOM   5308  CA  ILE   188      62.789  32.419  66.865  1.00  7.80           C  
ATOM   5309  C   ILE   188      63.915  31.423  67.152  1.00  7.32           C  
ATOM   5310  O   ILE   188      63.735  30.474  67.939  1.00  7.86           O  
ATOM   5311  CB  ILE   188      62.138  32.927  68.173  1.00  8.58           C  
ATOM   5312  CG1 ILE   188      60.963  33.856  67.842  1.00  8.13           C  
ATOM   5313  CG2 ILE   188      63.167  33.613  69.044  1.00  8.17           C  
ATOM   5314  CD1 ILE   188      60.276  34.446  69.053  1.00  8.96           C  
ATOM   5315  N   ASN   189      65.061  31.656  66.507  1.00  7.47           N  
ATOM   5316  CA  ASN   189      66.195  30.746  66.563  1.00  6.87           C  
ATOM   5317  C   ASN   189      67.498  31.548  66.687  1.00  8.06           C  
ATOM   5318  O   ASN   189      67.479  32.781  66.546  1.00  8.59           O  
ATOM   5319  CB  ASN   189      66.229  29.878  65.307  1.00  6.70           C  
ATOM   5320  CG  ASN   189      64.984  29.063  65.129  1.00  7.66           C  
ATOM   5321  OD1 ASN   189      64.724  28.150  65.905  1.00  7.79           O  
ATOM   5322  ND2 ASN   189      64.198  29.391  64.107  1.00 12.41           N  
ATOM   5323  N   ALA   190      68.609  30.835  66.915  1.00  8.26           N  
ATOM   5324  CA  ALA   190      69.944  31.450  66.876  1.00  9.32           C  
ATOM   5325  C   ALA   190      70.812  30.760  65.807  1.00  9.09           C  
ATOM   5326  O   ALA   190      70.573  29.599  65.475  1.00 10.07           O  
ATOM   5327  CB  ALA   190      70.648  31.359  68.209  1.00  9.25           C  
ATOM   5328  N   LEU   191      71.816  31.489  65.330  1.00 10.36           N  
ATOM   5329  CA  LEU   191      72.845  31.007  64.377  1.00  9.17           C  
ATOM   5330  C   LEU   191      74.238  31.462  64.835  1.00  9.57           C  
ATOM   5331  O   LEU   191      74.447  32.636  65.207  1.00  8.55           O  
ATOM   5332  CB  LEU   191      72.578  31.536  62.977  1.00  9.89           C  
ATOM   5333  CG  LEU   191      73.450  31.125  61.779  1.00 10.91           C  
ATOM   5334  CD1 LEU   191      73.372  29.626  61.545  1.00 10.30           C  
ATOM   5335  CD2 LEU   191      73.041  31.909  60.526  1.00  8.61           C  
ATOM   5336  N   TRP   192      75.178  30.531  64.784  1.00  9.45           N  
ATOM   5337  CA  TRP   192      76.544  30.741  65.277  1.00  9.01           C  
ATOM   5338  C   TRP   192      77.514  30.051  64.316  1.00  9.84           C  
ATOM   5339  O   TRP   192      77.222  28.952  63.839  1.00 10.90           O  
ATOM   5340  CB  TRP   192      76.679  30.144  66.673  1.00 10.80           C  
ATOM   5341  CG  TRP   192      77.856  30.603  67.439  1.00 10.61           C  
ATOM   5342  CD1 TRP   192      78.886  29.835  67.918  1.00 11.57           C  
ATOM   5343  CD2 TRP   192      78.141  31.952  67.839  1.00  9.13           C  
ATOM   5344  NE1 TRP   192      79.795  30.622  68.579  1.00 11.20           N  
ATOM   5345  CE2 TRP   192      79.364  31.923  68.557  1.00 11.68           C  
ATOM   5346  CE3 TRP   192      77.485  33.174  67.670  1.00 10.78           C  
ATOM   5347  CZ2 TRP   192      79.937  33.070  69.096  1.00 11.29           C  
ATOM   5348  CZ3 TRP   192      78.054  34.314  68.202  1.00 11.27           C  
ATOM   5349  CH2 TRP   192      79.278  34.253  68.914  1.00 12.30           C  
ATOM   5350  N   PRO   193      78.667  30.690  64.040  1.00  9.62           N  
ATOM   5351  CA  PRO   193      79.621  30.077  63.136  1.00 10.38           C  
ATOM   5352  C   PRO   193      80.513  29.019  63.797  1.00 10.94           C  
ATOM   5353  O   PRO   193      80.984  29.202  64.911  1.00  9.98           O  
ATOM   5354  CB  PRO   193      80.468  31.273  62.659  1.00 11.12           C  
ATOM   5355  CG  PRO   193      80.326  32.291  63.639  1.00 10.94           C  
ATOM   5356  CD  PRO   193      79.099  32.025  64.469  1.00 10.76           C  
ATOM   5357  N   ARG   194      80.776  27.930  63.080  1.00 10.77           N  
ATOM   5358  CA  ARG   194      81.727  26.913  63.570  1.00 10.69           C  
ATOM   5359  C   ARG   194      83.095  27.509  63.851  1.00 10.70           C  
ATOM   5360  O   ARG   194      83.748  27.156  64.828  1.00  9.13           O  
ATOM   5361  CB  ARG   194      81.890  25.806  62.532  1.00 11.19           C  
ATOM   5362  CG  ARG   194      82.814  24.686  62.960  1.00 11.22           C  
ATOM   5363  CD  ARG   194      82.180  23.835  64.078  1.00 12.94           C  
ATOM   5364  NE  ARG   194      81.005  23.167  63.543  1.00 12.73           N  
ATOM   5365  CZ  ARG   194      80.118  22.480  64.255  1.00 14.19           C  
ATOM   5366  NH1 ARG   194      80.286  22.324  65.558  1.00 16.53           N  
ATOM   5367  NH2 ARG   194      79.055  21.952  63.652  1.00 14.05           N  
ATOM   5368  N   THR   195      83.534  28.379  62.955  1.00 11.24           N  
ATOM   5369  CA  THR   195      84.879  28.978  63.046  1.00 11.59           C  
ATOM   5370  C   THR   195      84.790  30.461  63.425  1.00 12.97           C  
ATOM   5371  O   THR   195      83.704  31.053  63.383  1.00 13.53           O  
ATOM   5372  CB  THR   195      85.620  28.929  61.676  1.00 12.60           C  
ATOM   5373  OG1 THR   195      85.032  29.877  60.754  1.00 11.19           O  
ATOM   5374  CG2 THR   195      85.676  27.489  61.118  1.00 12.90           C  
ATOM   5375  N   VAL   196      85.942  31.073  63.701  1.00 11.44           N  
ATOM   5376  CA  VAL   196      86.008  32.521  63.839  1.00 11.47           C  
ATOM   5377  C   VAL   196      85.730  33.097  62.442  1.00 11.64           C  
ATOM   5378  O   VAL   196      86.074  32.485  61.403  1.00 10.13           O  
ATOM   5379  CB  VAL   196      87.356  33.001  64.413  1.00 11.27           C  
ATOM   5380  CG1 VAL   196      87.401  34.512  64.542  1.00 12.44           C  
ATOM   5381  CG2 VAL   196      87.597  32.355  65.780  1.00 10.12           C  
ATOM   5382  N   ILE   197      85.028  34.226  62.435  1.00 12.21           N  
ATOM   5383  CA  ILE   197      84.747  34.958  61.223  1.00 13.19           C  
ATOM   5384  C   ILE   197      85.583  36.247  61.188  1.00 14.47           C  
ATOM   5385  O   ILE   197      85.707  36.958  62.194  1.00 14.39           O  
ATOM   5386  CB  ILE   197      83.248  35.297  61.152  1.00 12.45           C  
ATOM   5387  CG1 ILE   197      82.388  34.023  61.239  1.00 13.93           C  
ATOM   5388  CG2 ILE   197      82.920  36.119  59.895  1.00 13.55           C  
ATOM   5389  CD1 ILE   197      82.545  33.084  60.053  1.00 14.19           C  
ATOM   5390  N   ALA   198      86.141  36.551  60.019  1.00 16.97           N  
ATOM   5391  CA  ALA   198      86.989  37.753  59.860  1.00 17.70           C  
ATOM   5392  C   ALA   198      86.111  39.009  59.807  1.00 18.75           C  
ATOM   5393  O   ALA   198      85.349  39.217  58.860  1.00 18.30           O  
ATOM   5394  CB  ALA   198      87.888  37.641  58.600  1.00 17.80           C  
ATOM   5395  N   THR   199      86.212  39.798  60.868  1.00 21.42           N  
ATOM   5396  CA  THR   199      85.578  41.116  61.002  1.00 24.66           C  
ATOM   5397  C   THR   199      86.500  41.968  61.873  1.00 26.60           C  
ATOM   5398  O   THR   199      87.403  41.432  62.484  1.00 26.00           O  
ATOM   5399  CB  THR   199      84.227  41.037  61.739  1.00 25.02           C  
ATOM   5400  OG1 THR   199      84.442  40.752  63.136  1.00 26.53           O  
ATOM   5401  CG2 THR   199      83.326  39.977  61.142  1.00 25.09           C  
ATOM   5402  N   ASP   200      86.223  43.270  61.970  1.00 29.31           N  
ATOM   5403  CA  ASP   200      86.932  44.183  62.889  1.00 30.32           C  
ATOM   5404  C   ASP   200      87.104  43.664  64.326  1.00 31.53           C  
ATOM   5405  O   ASP   200      88.110  43.967  64.981  1.00 32.46           O  
ATOM   5406  CB  ASP   200      86.198  45.525  62.943  1.00 31.47           C  
ATOM   5407  N   ALA   201      86.135  42.878  64.800  1.00 31.69           N  
ATOM   5408  CA  ALA   201      86.127  42.324  66.166  1.00 31.93           C  
ATOM   5409  C   ALA   201      87.251  41.332  66.487  1.00 32.03           C  
ATOM   5410  O   ALA   201      87.487  41.038  67.662  1.00 31.34           O  
ATOM   5411  CB  ALA   201      84.795  41.663  66.443  1.00 32.18           C  
ATOM   5412  N   ILE   202      87.932  40.801  65.467  1.00 31.53           N  
ATOM   5413  CA  ILE   202      89.063  39.902  65.713  1.00 31.58           C  
ATOM   5414  C   ILE   202      90.234  40.678  66.357  1.00 32.11           C  
ATOM   5415  O   ILE   202      91.125  40.084  66.978  1.00 31.21           O  
ATOM   5416  CB  ILE   202      89.485  39.082  64.436  1.00 31.88           C  
ATOM   5417  CG1 ILE   202      90.197  39.944  63.389  1.00 32.24           C  
ATOM   5418  CG2 ILE   202      88.262  38.397  63.811  1.00 31.23           C  
ATOM   5419  CD1 ILE   202      90.743  39.116  62.219  1.00 31.43           C  
ATOM   5420  N   ASN   203      90.198  42.007  66.237  1.00 32.73           N  
ATOM   5421  CA  ASN   203      91.054  42.892  67.029  1.00 34.45           C  
ATOM   5422  C   ASN   203      90.952  42.646  68.543  1.00 35.71           C  
ATOM   5423  O   ASN   203      91.914  42.909  69.274  1.00 36.12           O  
ATOM   5424  CB  ASN   203      90.715  44.354  66.734  1.00 34.31           C  
ATOM   5425  N   MET   204      89.790  42.155  68.997  1.00 36.69           N  
ATOM   5426  CA  MET   204      89.535  41.843  70.422  1.00 38.17           C  
ATOM   5427  C   MET   204      89.874  40.391  70.771  1.00 37.20           C  
ATOM   5428  O   MET   204      89.632  39.938  71.896  1.00 36.41           O  
ATOM   5429  CB  MET   204      88.062  42.091  70.766  1.00 40.03           C  
ATOM   5430  CG  MET   204      87.529  43.449  70.311  1.00 44.85           C  
ATOM   5431  SD  MET   204      88.510  44.923  71.156  1.00 54.38          SE  
ATOM   5432  CE  MET   204      87.862  44.661  72.974  1.00 51.52           C  
ATOM   5433  N   LEU   205      90.416  39.671  69.793  1.00 35.72           N  
ATOM   5434  CA  LEU   205      90.858  38.304  69.967  1.00 34.98           C  
ATOM   5435  C   LEU   205      92.377  38.279  69.775  1.00 35.18           C  
ATOM   5436  O   LEU   205      92.865  38.245  68.643  1.00 34.54           O  
ATOM   5437  CB  LEU   205      90.148  37.394  68.952  1.00 34.68           C  
ATOM   5438  CG  LEU   205      88.614  37.490  68.924  1.00 33.90           C  
ATOM   5439  CD1 LEU   205      88.037  36.670  67.789  1.00 33.73           C  
ATOM   5440  CD2 LEU   205      88.026  37.038  70.242  1.00 32.96           C  
ATOM   5441  N   PRO   206      93.136  38.348  70.882  1.00 35.71           N  
ATOM   5442  CA  PRO   206      94.597  38.309  70.775  1.00 35.39           C  
ATOM   5443  C   PRO   206      95.100  37.148  69.922  1.00 34.40           C  
ATOM   5444  O   PRO   206      94.643  36.016  70.072  1.00 34.60           O  
ATOM   5445  CB  PRO   206      95.058  38.150  72.229  1.00 35.54           C  
ATOM   5446  CG  PRO   206      93.972  38.750  73.037  1.00 36.25           C  
ATOM   5447  CD  PRO   206      92.692  38.510  72.281  1.00 36.21           C  
ATOM   5448  N   GLY   207      96.019  37.451  69.015  1.00 34.01           N  
ATOM   5449  CA  GLY   207      96.646  36.439  68.171  1.00 33.22           C  
ATOM   5450  C   GLY   207      95.911  36.060  66.890  1.00 32.07           C  
ATOM   5451  O   GLY   207      96.522  35.448  66.002  1.00 32.72           O  
ATOM   5452  N   VAL   208      94.624  36.409  66.783  1.00 30.05           N  
ATOM   5453  CA  VAL   208      93.756  35.957  65.671  1.00 27.96           C  
ATOM   5454  C   VAL   208      93.990  36.753  64.385  1.00 27.04           C  
ATOM   5455  O   VAL   208      93.672  37.942  64.316  1.00 27.08           O  
ATOM   5456  CB  VAL   208      92.250  36.048  66.054  1.00 28.33           C  
ATOM   5457  CG1 VAL   208      91.345  35.662  64.876  1.00 26.35           C  
ATOM   5458  CG2 VAL   208      91.955  35.168  67.254  1.00 27.54           C  
ATOM   5459  N   ASP   209      94.530  36.087  63.365  1.00 24.99           N  
ATOM   5460  CA  ASP   209      94.710  36.684  62.039  1.00 23.73           C  
ATOM   5461  C   ASP   209      93.466  36.381  61.216  1.00 21.98           C  
ATOM   5462  O   ASP   209      92.914  35.275  61.322  1.00 22.45           O  
ATOM   5463  CB  ASP   209      95.953  36.107  61.337  1.00 24.39           C  
ATOM   5464  N   ALA   210      93.033  37.354  60.414  1.00 19.90           N  
ATOM   5465  CA  ALA   210      91.928  37.172  59.477  1.00 18.55           C  
ATOM   5466  C   ALA   210      92.178  35.961  58.577  1.00 18.54           C  
ATOM   5467  O   ALA   210      91.233  35.279  58.206  1.00 16.36           O  
ATOM   5468  CB  ALA   210      91.725  38.381  58.635  1.00 18.39           C  
ATOM   5469  N   ALA   211      93.453  35.698  58.251  1.00 19.22           N  
ATOM   5470  CA  ALA   211      93.823  34.559  57.396  1.00 19.77           C  
ATOM   5471  C   ALA   211      93.396  33.177  57.928  1.00 18.66           C  
ATOM   5472  O   ALA   211      93.265  32.230  57.141  1.00 19.01           O  
ATOM   5473  CB  ALA   211      95.327  34.572  57.128  1.00 21.00           C  
ATOM   5474  N   ALA   212      93.189  33.060  59.243  1.00 17.16           N  
ATOM   5475  CA  ALA   212      92.806  31.799  59.875  1.00 17.32           C  
ATOM   5476  C   ALA   212      91.303  31.720  60.146  1.00 15.98           C  
ATOM   5477  O   ALA   212      90.850  30.865  60.903  1.00 16.45           O  
ATOM   5478  CB  ALA   212      93.583  31.597  61.193  1.00 19.36           C  
ATOM   5479  N   CYS   213      90.548  32.587  59.477  1.00 15.68           N  
ATOM   5480  CA  CYS   213      89.096  32.724  59.665  1.00 14.96           C  
ATOM   5481  C   CYS   213      88.347  32.398  58.401  1.00 13.90           C  
ATOM   5482  O   CYS   213      88.930  32.247  57.312  1.00 11.30           O  
ATOM   5483  CB  CYS   213      88.779  34.173  60.037  1.00 16.04           C  
ATOM   5484  SG  CYS   213      89.465  34.687  61.599  1.00 18.31           S  
ATOM   5485  N   ARG   214      87.028  32.321  58.541  1.00 11.55           N  
ATOM   5486  CA  ARG   214      86.146  32.352  57.377  1.00 11.17           C  
ATOM   5487  C   ARG   214      85.580  33.749  57.101  1.00 11.47           C  
ATOM   5488  O   ARG   214      85.539  34.626  57.993  1.00 10.53           O  
ATOM   5489  CB  ARG   214      85.013  31.352  57.523  1.00  9.96           C  
ATOM   5490  CG  ARG   214      85.378  29.941  57.116  1.00 10.13           C  
ATOM   5491  CD  ARG   214      84.332  28.940  57.540  1.00 13.06           C  
ATOM   5492  NE  ARG   214      84.674  27.599  57.086  1.00 11.49           N  
ATOM   5493  CZ  ARG   214      84.153  26.484  57.587  1.00 14.37           C  
ATOM   5494  NH1 ARG   214      83.233  26.531  58.552  1.00 14.60           N  
ATOM   5495  NH2 ARG   214      84.546  25.319  57.082  1.00 15.69           N  
ATOM   5496  N   ARG   215      85.191  33.946  55.854  1.00 11.96           N  
ATOM   5497  CA  ARG   215      84.573  35.193  55.404  1.00 13.62           C  
ATOM   5498  C   ARG   215      83.150  35.307  55.975  1.00 13.79           C  
ATOM   5499  O   ARG   215      82.469  34.282  56.179  1.00 11.81           O  
ATOM   5500  CB  ARG   215      84.546  35.244  53.871  1.00 15.28           C  
ATOM   5501  CG  ARG   215      85.990  35.211  53.309  1.00 18.33           C  
ATOM   5502  CD  ARG   215      86.047  35.215  51.806  1.00 24.21           C  
ATOM   5503  NE  ARG   215      85.094  34.272  51.253  1.00 28.15           N  
ATOM   5504  CZ  ARG   215      84.003  34.585  50.547  1.00 29.00           C  
ATOM   5505  NH1 ARG   215      83.716  35.842  50.227  1.00 30.59           N  
ATOM   5506  NH2 ARG   215      83.203  33.614  50.121  1.00 28.92           N  
ATOM   5507  N   PRO   216      82.682  36.556  56.199  1.00 13.39           N  
ATOM   5508  CA  PRO   216      81.301  36.730  56.690  1.00 13.19           C  
ATOM   5509  C   PRO   216      80.209  36.108  55.804  1.00 12.29           C  
ATOM   5510  O   PRO   216      79.103  35.859  56.313  1.00 10.07           O  
ATOM   5511  CB  PRO   216      81.120  38.247  56.741  1.00 14.69           C  
ATOM   5512  CG  PRO   216      82.496  38.852  56.576  1.00 16.80           C  
ATOM   5513  CD  PRO   216      83.400  37.829  56.004  1.00 13.98           C  
ATOM   5514  N   GLU   217      80.494  35.898  54.504  1.00 10.14           N  
ATOM   5515  CA  GLU   217      79.524  35.356  53.563  1.00  9.80           C  
ATOM   5516  C   GLU   217      79.001  33.955  53.979  1.00  9.93           C  
ATOM   5517  O   GLU   217      77.877  33.596  53.621  1.00 10.64           O  
ATOM   5518  CB  GLU   217      80.075  35.346  52.131  1.00 11.56           C  
ATOM   5519  CG  GLU   217      80.152  36.741  51.466  1.00 13.90           C  
ATOM   5520  CD  GLU   217      81.203  37.674  52.049  1.00 15.89           C  
ATOM   5521  OE1 GLU   217      82.190  37.184  52.627  1.00 14.96           O  
ATOM   5522  OE2 GLU   217      81.053  38.924  51.907  1.00 19.39           O  
ATOM   5523  N   ILE   218      79.782  33.174  54.733  1.00  9.54           N  
ATOM   5524  CA  ILE   218      79.265  31.870  55.216  1.00  9.51           C  
ATOM   5525  C   ILE   218      78.061  32.085  56.149  1.00  8.43           C  
ATOM   5526  O   ILE   218      77.044  31.361  56.049  1.00  9.07           O  
ATOM   5527  CB  ILE   218      80.356  30.962  55.875  1.00  9.51           C  
ATOM   5528  CG1 ILE   218      79.776  29.532  56.010  1.00 10.71           C  
ATOM   5529  CG2 ILE   218      80.869  31.523  57.243  1.00  9.59           C  
ATOM   5530  CD1 ILE   218      80.721  28.472  56.519  1.00 10.01           C  
ATOM   5531  N   MET   219      78.160  33.092  57.012  1.00  8.08           N  
ATOM   5532  CA  MET   219      77.037  33.462  57.908  1.00  9.75           C  
ATOM   5533  C   MET   219      75.877  34.075  57.105  1.00  9.33           C  
ATOM   5534  O   MET   219      74.705  33.796  57.393  1.00  8.50           O  
ATOM   5535  CB  MET   219      77.517  34.361  59.036  1.00 10.70           C  
ATOM   5536  CG  MET   219      78.318  33.632  60.104  1.00 10.83           C  
ATOM   5537  SD  MET   219      77.132  32.461  61.178  1.00 19.24          SE  
ATOM   5538  CE  MET   219      76.251  33.854  62.236  1.00 13.10           C  
ATOM   5539  N   ALA   220      76.175  34.864  56.093  1.00  9.79           N  
ATOM   5540  CA  ALA   220      75.142  35.398  55.209  1.00  8.81           C  
ATOM   5541  C   ALA   220      74.358  34.282  54.515  1.00 10.55           C  
ATOM   5542  O   ALA   220      73.131  34.330  54.420  1.00 10.80           O  
ATOM   5543  CB  ALA   220      75.776  36.335  54.162  1.00  9.90           C  
ATOM   5544  N   ASP   221      75.076  33.305  53.986  1.00  9.26           N  
ATOM   5545  CA  ASP   221      74.465  32.207  53.244  1.00 10.44           C  
ATOM   5546  C   ASP   221      73.722  31.244  54.162  1.00  8.96           C  
ATOM   5547  O   ASP   221      72.638  30.797  53.816  1.00  9.98           O  
ATOM   5548  CB  ASP   221      75.522  31.469  52.396  1.00 10.47           C  
ATOM   5549  CG  ASP   221      76.035  32.329  51.208  1.00 12.58           C  
ATOM   5550  OD1 ASP   221      75.426  33.389  50.886  1.00 12.60           O  
ATOM   5551  OD2 ASP   221      77.070  31.951  50.616  1.00 13.20           O  
ATOM   5552  N   ALA   222      74.281  30.981  55.344  1.00 10.14           N  
ATOM   5553  CA  ALA   222      73.588  30.148  56.343  1.00  9.51           C  
ATOM   5554  C   ALA   222      72.310  30.883  56.806  1.00  8.92           C  
ATOM   5555  O   ALA   222      71.228  30.287  56.887  1.00  9.18           O  
ATOM   5556  CB  ALA   222      74.463  29.823  57.531  1.00 10.57           C  
ATOM   5557  N   ALA   223      72.426  32.185  57.037  1.00  8.48           N  
ATOM   5558  CA  ALA   223      71.247  32.982  57.416  1.00  8.96           C  
ATOM   5559  C   ALA   223      70.127  32.893  56.386  1.00  9.41           C  
ATOM   5560  O   ALA   223      68.957  32.691  56.744  1.00  9.64           O  
ATOM   5561  CB  ALA   223      71.641  34.461  57.673  1.00  8.23           C  
ATOM   5562  N   HIS   224      70.468  33.020  55.111  1.00  9.26           N  
ATOM   5563  CA  HIS   224      69.485  32.935  54.044  1.00  9.24           C  
ATOM   5564  C   HIS   224      68.758  31.592  54.086  1.00  8.64           C  
ATOM   5565  O   HIS   224      67.525  31.505  53.908  1.00  9.28           O  
ATOM   5566  CB  HIS   224      70.181  33.124  52.698  1.00 10.68           C  
ATOM   5567  CG  HIS   224      69.238  33.111  51.541  1.00 11.78           C  
ATOM   5568  ND1 HIS   224      68.859  31.952  50.898  1.00 13.37           N  
ATOM   5569  CD2 HIS   224      68.592  34.121  50.920  1.00 13.87           C  
ATOM   5570  CE1 HIS   224      68.030  32.255  49.914  1.00 15.01           C  
ATOM   5571  NE2 HIS   224      67.844  33.563  49.912  1.00 14.14           N  
ATOM   5572  N   ALA   225      69.517  30.529  54.318  1.00  9.29           N  
ATOM   5573  CA  ALA   225      68.954  29.178  54.338  1.00 10.35           C  
ATOM   5574  C   ALA   225      67.978  29.020  55.497  1.00 10.67           C  
ATOM   5575  O   ALA   225      66.974  28.344  55.368  1.00 13.06           O  
ATOM   5576  CB  ALA   225      70.037  28.143  54.416  1.00 10.21           C  
ATOM   5577  N   VAL   226      68.296  29.623  56.629  1.00  9.64           N  
ATOM   5578  CA  VAL   226      67.402  29.632  57.786  1.00  8.31           C  
ATOM   5579  C   VAL   226      66.149  30.466  57.514  1.00  9.05           C  
ATOM   5580  O   VAL   226      65.042  30.008  57.759  1.00  8.06           O  
ATOM   5581  CB  VAL   226      68.089  30.177  59.040  1.00  9.54           C  
ATOM   5582  CG1 VAL   226      67.026  30.386  60.150  1.00  9.38           C  
ATOM   5583  CG2 VAL   226      69.208  29.249  59.496  1.00  8.88           C  
ATOM   5584  N   LEU   227      66.339  31.679  57.008  1.00  8.80           N  
ATOM   5585  CA  LEU   227      65.269  32.685  56.902  1.00  7.62           C  
ATOM   5586  C   LEU   227      64.221  32.400  55.830  1.00  9.30           C  
ATOM   5587  O   LEU   227      63.134  32.981  55.859  1.00 11.38           O  
ATOM   5588  CB  LEU   227      65.853  34.086  56.720  1.00  7.31           C  
ATOM   5589  CG  LEU   227      66.660  34.626  57.912  1.00  7.53           C  
ATOM   5590  CD1 LEU   227      67.456  35.893  57.453  1.00  7.82           C  
ATOM   5591  CD2 LEU   227      65.807  34.868  59.162  1.00  7.82           C  
ATOM   5592  N   THR   228      64.565  31.532  54.877  1.00 10.84           N  
ATOM   5593  CA  THR   228      63.640  31.106  53.834  1.00 11.21           C  
ATOM   5594  C   THR   228      62.902  29.813  54.207  1.00 12.51           C  
ATOM   5595  O   THR   228      62.089  29.324  53.427  1.00 13.36           O  
ATOM   5596  CB  THR   228      64.356  30.943  52.480  1.00 11.28           C  
ATOM   5597  OG1 THR   228      65.490  30.071  52.623  1.00 11.86           O  
ATOM   5598  CG2 THR   228      64.823  32.305  51.925  1.00 10.49           C  
ATOM   5599  N   ARG   229      63.164  29.275  55.392  1.00 12.31           N  
ATOM   5600  CA  ARG   229      62.398  28.131  55.886  1.00 13.02           C  
ATOM   5601  C   ARG   229      61.036  28.582  56.366  1.00 12.41           C  
ATOM   5602  O   ARG   229      60.857  29.699  56.833  1.00 11.12           O  
ATOM   5603  CB  ARG   229      63.131  27.449  57.042  1.00 13.90           C  
ATOM   5604  CG  ARG   229      64.361  26.695  56.573  1.00 18.22           C  
ATOM   5605  CD  ARG   229      64.905  25.781  57.639  1.00 24.70           C  
ATOM   5606  NE  ARG   229      66.358  25.629  57.578  1.00 27.94           N  
ATOM   5607  CZ  ARG   229      67.067  24.929  58.463  1.00 29.51           C  
ATOM   5608  NH1 ARG   229      66.464  24.315  59.473  1.00 30.07           N  
ATOM   5609  NH2 ARG   229      68.382  24.843  58.339  1.00 31.20           N  
ATOM   5610  N   GLU   230      60.073  27.682  56.263  1.00 13.02           N  
ATOM   5611  CA  GLU   230      58.789  27.853  56.934  1.00 13.00           C  
ATOM   5612  C   GLU   230      58.956  28.177  58.441  1.00 10.74           C  
ATOM   5613  O   GLU   230      59.669  27.483  59.145  1.00 10.37           O  
ATOM   5614  CB  GLU   230      57.992  26.558  56.766  1.00 14.44           C  
ATOM   5615  CG  GLU   230      56.714  26.470  57.570  1.00 16.81           C  
ATOM   5616  CD  GLU   230      55.756  27.580  57.297  1.00 20.75           C  
ATOM   5617  OE1 GLU   230      55.565  27.938  56.108  1.00 22.68           O  
ATOM   5618  OE2 GLU   230      55.183  28.101  58.273  1.00 23.60           O  
ATOM   5619  N   ALA   231      58.274  29.224  58.921  1.00 10.66           N  
ATOM   5620  CA  ALA   231      58.452  29.695  60.279  1.00  9.21           C  
ATOM   5621  C   ALA   231      57.666  28.814  61.265  1.00  9.22           C  
ATOM   5622  O   ALA   231      58.149  28.544  62.358  1.00 11.18           O  
ATOM   5623  CB  ALA   231      58.043  31.163  60.394  1.00 11.08           C  
ATOM   5624  N   ALA   232      56.440  28.411  60.900  1.00 11.57           N  
ATOM   5625  CA  ALA   232      55.657  27.536  61.794  1.00 11.84           C  
ATOM   5626  C   ALA   232      56.448  26.274  62.149  1.00 11.65           C  
ATOM   5627  O   ALA   232      57.030  25.635  61.277  1.00 11.13           O  
ATOM   5628  CB  ALA   232      54.287  27.166  61.177  1.00 12.63           C  
ATOM   5629  N   GLY   233      56.460  25.932  63.440  1.00 11.71           N  
ATOM   5630  CA  GLY   233      57.118  24.727  63.931  1.00 12.81           C  
ATOM   5631  C   GLY   233      58.631  24.731  63.914  1.00 12.78           C  
ATOM   5632  O   GLY   233      59.258  23.671  64.000  1.00 15.24           O  
ATOM   5633  N   PHE   234      59.231  25.920  63.845  1.00 11.53           N  
ATOM   5634  CA  PHE   234      60.681  26.065  63.718  1.00 10.95           C  
ATOM   5635  C   PHE   234      61.135  27.154  64.667  1.00 10.41           C  
ATOM   5636  O   PHE   234      61.335  28.309  64.285  1.00 10.14           O  
ATOM   5637  CB  PHE   234      61.024  26.418  62.268  1.00 10.28           C  
ATOM   5638  CG  PHE   234      62.481  26.660  61.998  1.00 11.48           C  
ATOM   5639  CD1 PHE   234      63.469  25.908  62.615  1.00 12.55           C  
ATOM   5640  CD2 PHE   234      62.851  27.629  61.057  1.00 12.01           C  
ATOM   5641  CE1 PHE   234      64.810  26.118  62.316  1.00 12.77           C  
ATOM   5642  CE2 PHE   234      64.198  27.847  60.754  1.00  9.77           C  
ATOM   5643  CZ  PHE   234      65.173  27.094  61.377  1.00 10.45           C  
ATOM   5644  N   HIS   235      61.220  26.803  65.939  1.00 11.11           N  
ATOM   5645  CA  HIS   235      61.674  27.764  66.942  1.00 10.75           C  
ATOM   5646  C   HIS   235      62.484  27.096  68.044  1.00 10.73           C  
ATOM   5647  O   HIS   235      62.409  25.871  68.220  1.00 11.07           O  
ATOM   5648  CB  HIS   235      60.488  28.535  67.516  1.00 11.00           C  
ATOM   5649  CG  HIS   235      59.431  27.661  68.116  1.00 12.49           C  
ATOM   5650  ND1 HIS   235      59.451  27.250  69.430  1.00 17.28           N  
ATOM   5651  CD2 HIS   235      58.298  27.159  67.583  1.00 15.51           C  
ATOM   5652  CE1 HIS   235      58.384  26.505  69.672  1.00 16.54           C  
ATOM   5653  NE2 HIS   235      57.661  26.444  68.572  1.00 19.60           N  
ATOM   5654  N   GLY   236      63.272  27.900  68.757  1.00  9.65           N  
ATOM   5655  CA  GLY   236      64.075  27.417  69.881  1.00 10.22           C  
ATOM   5656  C   GLY   236      65.311  26.612  69.493  1.00 11.11           C  
ATOM   5657  O   GLY   236      65.883  25.899  70.346  1.00 11.67           O  
ATOM   5658  N   GLN   237      65.737  26.719  68.229  1.00  9.79           N  
ATOM   5659  CA  GLN   237      66.917  26.007  67.719  0.50  9.71           C  
ATOM   5661  C   GLN   237      68.155  26.891  67.753  1.00  9.69           C  
ATOM   5662  O   GLN   237      68.076  28.093  67.421  1.00  9.08           O  
ATOM   5663  CB  GLN   237      66.702  25.568  66.277  0.50  9.51           C  
ATOM   5665  CG  GLN   237      65.375  24.867  66.030  0.50  9.75           C  
ATOM   5667  CD  GLN   237      65.237  23.639  66.887  0.50 12.51           C  
ATOM   5669  OE1 GLN   237      66.075  22.741  66.822  0.50 15.44           O  
ATOM   5671  NE2 GLN   237      64.207  23.607  67.731  0.50 13.76           N  
ATOM   5673  N   PHE   238      69.292  26.295  68.111  1.00 10.54           N  
ATOM   5674  CA  PHE   238      70.565  26.961  68.165  1.00 10.09           C  
ATOM   5675  C   PHE   238      71.422  26.330  67.095  1.00 10.10           C  
ATOM   5676  O   PHE   238      71.923  25.208  67.260  1.00 10.79           O  
ATOM   5677  CB  PHE   238      71.148  26.854  69.559  1.00 11.86           C  
ATOM   5678  CG  PHE   238      70.364  27.638  70.513  1.00 11.06           C  
ATOM   5679  CD1 PHE   238      70.683  28.963  70.740  1.00  9.74           C  
ATOM   5680  CD2 PHE   238      69.199  27.095  71.091  1.00 13.11           C  
ATOM   5681  CE1 PHE   238      69.877  29.754  71.591  1.00 12.73           C  
ATOM   5682  CE2 PHE   238      68.397  27.871  71.954  1.00 11.73           C  
ATOM   5683  CZ  PHE   238      68.729  29.199  72.181  1.00 12.13           C  
ATOM   5684  N   LEU   239      71.435  27.004  65.947  1.00  8.63           N  
ATOM   5685  CA  LEU   239      71.954  26.431  64.705  1.00  9.84           C  
ATOM   5686  C   LEU   239      73.415  26.809  64.453  1.00 10.60           C  
ATOM   5687  O   LEU   239      73.900  27.852  64.902  1.00  9.43           O  
ATOM   5688  CB  LEU   239      71.071  26.890  63.542  1.00 11.24           C  
ATOM   5689  CG  LEU   239      69.571  26.548  63.665  1.00 14.18           C  
ATOM   5690  CD1 LEU   239      68.745  27.380  62.716  1.00 15.68           C  
ATOM   5691  CD2 LEU   239      69.305  25.051  63.508  1.00 13.50           C  
ATOM   5692  N   ILE   240      74.114  25.957  63.699  1.00 10.01           N  
ATOM   5693  CA  ILE   240      75.506  26.202  63.350  1.00 10.29           C  
ATOM   5694  C   ILE   240      75.630  26.359  61.837  1.00 10.02           C  
ATOM   5695  O   ILE   240      74.977  25.618  61.079  1.00  9.20           O  
ATOM   5696  CB  ILE   240      76.425  25.078  63.844  1.00 12.25           C  
ATOM   5697  CG1 ILE   240      76.182  24.784  65.334  1.00 12.19           C  
ATOM   5698  CG2 ILE   240      77.889  25.507  63.641  1.00  9.74           C  
ATOM   5699  CD1 ILE   240      76.500  25.914  66.214  1.00 11.70           C  
ATOM   5700  N   ASP   241      76.455  27.320  61.392  1.00  8.55           N  
ATOM   5701  CA  ASP   241      76.500  27.630  59.948  1.00  7.63           C  
ATOM   5702  C   ASP   241      76.734  26.403  59.046  1.00  8.93           C  
ATOM   5703  O   ASP   241      75.986  26.182  58.087  1.00  7.81           O  
ATOM   5704  CB  ASP   241      77.462  28.776  59.622  1.00  8.63           C  
ATOM   5705  CG  ASP   241      78.910  28.556  60.089  1.00  8.77           C  
ATOM   5706  OD1 ASP   241      79.263  27.528  60.731  1.00  9.52           O  
ATOM   5707  OD2 ASP   241      79.702  29.490  59.786  1.00 10.21           O  
ATOM   5708  N   ASP   242      77.776  25.640  59.346  1.00  9.44           N  
ATOM   5709  CA  ASP   242      78.153  24.498  58.505  1.00  9.97           C  
ATOM   5710  C   ASP   242      77.045  23.463  58.410  1.00 11.43           C  
ATOM   5711  O   ASP   242      76.792  22.932  57.322  1.00 11.52           O  
ATOM   5712  CB  ASP   242      79.518  23.916  58.898  1.00 10.96           C  
ATOM   5713  CG  ASP   242      79.626  23.456  60.354  1.00 10.47           C  
ATOM   5714  OD1 ASP   242      78.637  23.411  61.152  1.00  9.82           O  
ATOM   5715  OD2 ASP   242      80.750  23.045  60.696  1.00 11.04           O  
ATOM   5716  N   GLU   243      76.340  23.240  59.528  1.00 10.97           N  
ATOM   5717  CA  GLU   243      75.254  22.271  59.563  1.00 12.10           C  
ATOM   5718  C   GLU   243      74.051  22.754  58.781  1.00 11.93           C  
ATOM   5719  O   GLU   243      73.450  21.991  58.013  1.00 12.25           O  
ATOM   5720  CB  GLU   243      74.891  21.953  61.015  1.00 10.90           C  
ATOM   5721  CG  GLU   243      75.989  21.186  61.752  1.00 11.73           C  
ATOM   5722  CD  GLU   243      75.652  20.881  63.201  1.00 14.83           C  
ATOM   5723  OE1 GLU   243      74.647  21.414  63.728  1.00 15.06           O  
ATOM   5724  OE2 GLU   243      76.424  20.123  63.820  1.00 15.27           O  
ATOM   5725  N   VAL   244      73.726  24.043  58.928  1.00 10.46           N  
ATOM   5726  CA  VAL   244      72.639  24.624  58.156  1.00 10.91           C  
ATOM   5727  C   VAL   244      72.944  24.498  56.657  1.00  9.60           C  
ATOM   5728  O   VAL   244      72.100  24.116  55.849  1.00  9.49           O  
ATOM   5729  CB  VAL   244      72.430  26.109  58.522  1.00 10.40           C  
ATOM   5730  CG1 VAL   244      71.527  26.825  57.494  1.00 10.80           C  
ATOM   5731  CG2 VAL   244      71.827  26.241  59.936  1.00 10.74           C  
ATOM   5732  N   LEU   245      74.171  24.845  56.271  1.00  8.34           N  
ATOM   5733  CA  LEU   245      74.524  24.803  54.873  1.00  9.08           C  
ATOM   5734  C   LEU   245      74.510  23.367  54.329  1.00  9.72           C  
ATOM   5735  O   LEU   245      74.061  23.135  53.212  1.00 12.07           O  
ATOM   5736  CB  LEU   245      75.864  25.495  54.646  1.00 10.01           C  
ATOM   5737  CG  LEU   245      75.757  27.025  54.754  1.00  9.78           C  
ATOM   5738  CD1 LEU   245      77.125  27.622  54.847  1.00 11.42           C  
ATOM   5739  CD2 LEU   245      74.933  27.662  53.573  1.00 10.98           C  
ATOM   5740  N   ALA   246      74.926  22.406  55.142  1.00  9.49           N  
ATOM   5741  CA  ALA   246      74.899  20.989  54.735  1.00 10.39           C  
ATOM   5742  C   ALA   246      73.460  20.527  54.472  1.00 13.02           C  
ATOM   5743  O   ALA   246      73.166  19.889  53.464  1.00 13.50           O  
ATOM   5744  CB  ALA   246      75.552  20.141  55.785  1.00 11.18           C  
ATOM   5745  N   GLN   247      72.545  20.906  55.350  1.00 14.76           N  
ATOM   5746  CA  GLN   247      71.142  20.553  55.146  1.00 15.96           C  
ATOM   5747  C   GLN   247      70.605  21.162  53.844  1.00 16.26           C  
ATOM   5748  O   GLN   247      69.775  20.553  53.163  1.00 17.07           O  
ATOM   5749  CB  GLN   247      70.284  20.972  56.345  1.00 16.47           C  
ATOM   5750  CG  GLN   247      68.830  20.506  56.232  1.00 19.53           C  
ATOM   5751  CD  GLN   247      68.716  18.981  56.287  1.00 23.04           C  
ATOM   5752  OE1 GLN   247      69.252  18.354  57.198  1.00 30.20           O  
ATOM   5753  NE2 GLN   247      68.015  18.387  55.318  1.00 26.17           N  
ATOM   5754  N   ALA   248      71.096  22.354  53.499  1.00 15.68           N  
ATOM   5755  CA  ALA   248      70.715  23.057  52.270  1.00 17.03           C  
ATOM   5756  C   ALA   248      71.405  22.541  50.999  1.00 17.73           C  
ATOM   5757  O   ALA   248      71.152  23.057  49.898  1.00 18.79           O  
ATOM   5758  CB  ALA   248      70.970  24.566  52.440  1.00 16.79           C  
ATOM   5759  N   GLY   249      72.257  21.525  51.136  1.00 17.88           N  
ATOM   5760  CA  GLY   249      72.937  20.916  50.006  1.00 17.09           C  
ATOM   5761  C   GLY   249      74.269  21.562  49.677  1.00 18.14           C  
ATOM   5762  O   GLY   249      74.836  21.281  48.639  1.00 18.86           O  
ATOM   5763  N   ILE   250      74.764  22.432  50.558  1.00 16.72           N  
ATOM   5764  CA  ILE   250      76.060  23.086  50.394  1.00 16.93           C  
ATOM   5765  C   ILE   250      77.010  22.469  51.401  1.00 17.11           C  
ATOM   5766  O   ILE   250      76.966  22.786  52.594  1.00 17.06           O  
ATOM   5767  CB  ILE   250      75.991  24.625  50.598  1.00 16.82           C  
ATOM   5768  CG1 ILE   250      75.017  25.237  49.576  1.00 18.36           C  
ATOM   5769  CG2 ILE   250      77.421  25.238  50.561  1.00 17.05           C  
ATOM   5770  CD1 ILE   250      74.554  26.663  49.877  1.00 20.00           C  
ATOM   5771  N   THR   251      77.844  21.565  50.907  1.00 16.28           N  
ATOM   5772  CA  THR   251      78.766  20.798  51.733  1.00 17.39           C  
ATOM   5773  C   THR   251      80.225  21.172  51.470  1.00 16.35           C  
ATOM   5774  O   THR   251      81.100  20.924  52.311  1.00 17.59           O  
ATOM   5775  CB  THR   251      78.548  19.258  51.518  1.00 18.88           C  
ATOM   5776  OG1 THR   251      78.633  18.951  50.125  1.00 19.35           O  
ATOM   5777  CG2 THR   251      77.179  18.803  52.048  1.00 18.81           C  
ATOM   5778  N   ASP   252      80.506  21.772  50.318  1.00 16.57           N  
ATOM   5779  CA  ASP   252      81.860  22.264  50.053  1.00 16.71           C  
ATOM   5780  C   ASP   252      81.990  23.719  50.530  1.00 15.16           C  
ATOM   5781  O   ASP   252      81.513  24.643  49.869  1.00 14.76           O  
ATOM   5782  CB  ASP   252      82.210  22.136  48.559  1.00 18.34           C  
ATOM   5783  CG  ASP   252      83.534  22.803  48.198  1.00 21.36           C  
ATOM   5784  OD1 ASP   252      84.360  23.072  49.092  1.00 20.58           O  
ATOM   5785  OD2 ASP   252      83.762  23.062  46.991  1.00 26.03           O  
ATOM   5786  N   LEU   253      82.677  23.907  51.654  1.00 14.09           N  
ATOM   5787  CA  LEU   253      82.822  25.212  52.292  1.00 13.04           C  
ATOM   5788  C   LEU   253      84.167  25.868  52.017  1.00 13.64           C  
ATOM   5789  O   LEU   253      84.484  26.925  52.582  1.00 13.52           O  
ATOM   5790  CB  LEU   253      82.650  25.059  53.802  1.00 12.46           C  
ATOM   5791  CG  LEU   253      81.350  24.462  54.293  1.00 14.11           C  
ATOM   5792  CD1 LEU   253      81.337  24.370  55.815  1.00 12.78           C  
ATOM   5793  CD2 LEU   253      80.193  25.302  53.751  1.00 14.19           C  
ATOM   5794  N   SER   254      84.964  25.252  51.146  1.00 15.63           N  
ATOM   5795  CA  SER   254      86.332  25.727  50.935  1.00 15.42           C  
ATOM   5796  C   SER   254      86.416  27.206  50.485  1.00 14.66           C  
ATOM   5797  O   SER   254      87.362  27.936  50.845  1.00 14.75           O  
ATOM   5798  CB  SER   254      87.046  24.810  49.915  1.00 17.15           C  
ATOM   5799  OG  SER   254      86.372  24.804  48.662  1.00 21.05           O  
ATOM   5800  N   GLY   255      85.450  27.636  49.674  1.00 13.97           N  
ATOM   5801  CA  GLY   255      85.415  29.023  49.171  1.00 15.07           C  
ATOM   5802  C   GLY   255      85.129  30.080  50.222  1.00 13.40           C  
ATOM   5803  O   GLY   255      85.300  31.281  49.964  1.00 15.35           O  
ATOM   5804  N   TYR   256      84.668  29.654  51.397  1.00 12.89           N  
ATOM   5805  CA  TYR   256      84.408  30.594  52.502  1.00 12.87           C  
ATOM   5806  C   TYR   256      85.652  30.922  53.329  1.00 13.02           C  
ATOM   5807  O   TYR   256      85.633  31.807  54.191  1.00 12.60           O  
ATOM   5808  CB  TYR   256      83.310  30.070  53.409  1.00 12.71           C  
ATOM   5809  CG  TYR   256      81.957  29.985  52.758  1.00 12.38           C  
ATOM   5810  CD1 TYR   256      81.262  31.146  52.368  1.00 12.60           C  
ATOM   5811  CD2 TYR   256      81.344  28.764  52.573  1.00 13.56           C  
ATOM   5812  CE1 TYR   256      79.982  31.066  51.790  1.00 13.07           C  
ATOM   5813  CE2 TYR   256      80.072  28.672  51.992  1.00 12.59           C  
ATOM   5814  CZ  TYR   256      79.398  29.822  51.595  1.00 12.08           C  
ATOM   5815  OH  TYR   256      78.136  29.650  51.055  1.00 13.51           O  
ATOM   5816  N   ALA   257      86.750  30.202  53.093  1.00 12.21           N  
ATOM   5817  CA  ALA   257      88.000  30.505  53.803  1.00 12.76           C  
ATOM   5818  C   ALA   257      88.579  31.834  53.341  1.00 13.14           C  
ATOM   5819  O   ALA   257      88.634  32.103  52.137  1.00 12.74           O  
ATOM   5820  CB  ALA   257      89.035  29.381  53.574  1.00 11.08           C  
ATOM   5821  N   VAL   258      89.025  32.653  54.291  1.00 13.59           N  
ATOM   5822  CA  VAL   258      89.766  33.875  53.957  1.00 13.15           C  
ATOM   5823  C   VAL   258      91.047  33.481  53.196  1.00 13.92           C  
ATOM   5824  O   VAL   258      91.350  34.062  52.167  1.00 15.15           O  
ATOM   5825  CB  VAL   258      90.139  34.695  55.196  1.00 13.73           C  
ATOM   5826  CG1 VAL   258      91.133  35.827  54.828  1.00 12.44           C  
ATOM   5827  CG2 VAL   258      88.887  35.275  55.836  1.00 11.73           C  
ATOM   5828  N   ASP   259      91.737  32.468  53.695  1.00 14.36           N  
ATOM   5829  CA  ASP   259      93.043  32.032  53.152  1.00 16.66           C  
ATOM   5830  C   ASP   259      93.207  30.531  53.378  1.00 16.00           C  
ATOM   5831  O   ASP   259      93.492  30.111  54.495  1.00 15.74           O  
ATOM   5832  CB  ASP   259      94.178  32.770  53.843  1.00 17.28           C  
ATOM   5833  CG  ASP   259      95.534  32.527  53.175  1.00 19.52           C  
ATOM   5834  OD1 ASP   259      95.638  31.603  52.334  1.00 19.14           O  
ATOM   5835  OD2 ASP   259      96.471  33.285  53.500  1.00 20.78           O  
ATOM   5836  N   PRO   260      93.040  29.731  52.314  1.00 16.57           N  
ATOM   5837  CA  PRO   260      93.114  28.263  52.358  1.00 17.14           C  
ATOM   5838  C   PRO   260      94.471  27.723  52.853  1.00 17.17           C  
ATOM   5839  O   PRO   260      94.556  26.568  53.229  1.00 17.32           O  
ATOM   5840  CB  PRO   260      92.895  27.856  50.906  1.00 17.55           C  
ATOM   5841  CG  PRO   260      92.197  29.012  50.297  1.00 19.80           C  
ATOM   5842  CD  PRO   260      92.761  30.208  50.948  1.00 17.57           C  
ATOM   5843  N   GLN   261      95.513  28.555  52.877  1.00 17.47           N  
ATOM   5844  CA  GLN   261      96.809  28.066  53.346  1.00 19.31           C  
ATOM   5845  C   GLN   261      96.883  27.935  54.861  1.00 18.28           C  
ATOM   5846  O   GLN   261      97.785  27.279  55.369  1.00 17.94           O  
ATOM   5847  CB  GLN   261      98.003  28.848  52.735  1.00 20.37           C  
ATOM   5848  CG  GLN   261      98.334  30.204  53.267  1.00 22.82           C  
ATOM   5849  CD  GLN   261      99.129  31.047  52.224  1.00 23.06           C  
ATOM   5850  OE1 GLN   261     100.267  30.741  51.890  1.00 24.28           O  
ATOM   5851  NE2 GLN   261      98.505  32.082  51.712  1.00 26.95           N  
ATOM   5852  N   ARG   262      95.897  28.499  55.570  1.00 17.95           N  
ATOM   5853  CA  ARG   262      95.835  28.452  57.026  1.00 18.53           C  
ATOM   5854  C   ARG   262      94.770  27.486  57.540  1.00 16.88           C  
ATOM   5855  O   ARG   262      93.689  27.377  56.957  1.00 15.84           O  
ATOM   5856  CB  ARG   262      95.538  29.856  57.567  1.00 19.88           C  
ATOM   5857  CG  ARG   262      96.516  30.933  57.099  1.00 24.55           C  
ATOM   5858  CD  ARG   262      97.860  30.788  57.788  1.00 29.13           C  
ATOM   5859  NE  ARG   262      97.735  31.167  59.198  1.00 33.15           N  
ATOM   5860  CZ  ARG   262      97.938  32.393  59.688  1.00 34.34           C  
ATOM   5861  NH1 ARG   262      98.293  33.410  58.897  1.00 36.27           N  
ATOM   5862  NH2 ARG   262      97.770  32.606  60.988  1.00 33.46           N  
ATOM   5863  N   ALA   263      95.068  26.798  58.640  1.00 17.37           N  
ATOM   5864  CA  ALA   263      94.067  26.008  59.366  1.00 17.08           C  
ATOM   5865  C   ALA   263      93.041  26.985  59.978  1.00 16.55           C  
ATOM   5866  O   ALA   263      93.421  28.032  60.471  1.00 17.26           O  
ATOM   5867  CB  ALA   263      94.745  25.188  60.460  1.00 18.51           C  
ATOM   5868  N   LEU   264      91.753  26.664  59.895  1.00 16.39           N  
ATOM   5869  CA  LEU   264      90.712  27.525  60.490  1.00 16.60           C  
ATOM   5870  C   LEU   264      90.679  27.453  62.024  1.00 16.45           C  
ATOM   5871  O   LEU   264      90.837  26.372  62.621  1.00 18.13           O  
ATOM   5872  CB  LEU   264      89.346  27.156  59.948  1.00 16.42           C  
ATOM   5873  CG  LEU   264      89.143  27.414  58.467  1.00 15.21           C  
ATOM   5874  CD1 LEU   264      87.920  26.660  57.985  1.00 13.98           C  
ATOM   5875  CD2 LEU   264      89.042  28.909  58.183  1.00 13.81           C  
ATOM   5876  N   LEU   265      90.505  28.618  62.652  1.00 16.21           N  
ATOM   5877  CA  LEU   265      90.405  28.714  64.100  1.00 16.33           C  
ATOM   5878  C   LEU   265      88.967  28.386  64.532  1.00 15.83           C  
ATOM   5879  O   LEU   265      88.023  29.000  64.038  1.00 16.09           O  
ATOM   5880  CB  LEU   265      90.750  30.120  64.588  1.00 17.75           C  
ATOM   5881  CG  LEU   265      92.181  30.627  64.317  1.00 20.10           C  
ATOM   5882  CD1 LEU   265      92.346  32.048  64.846  1.00 21.56           C  
ATOM   5883  CD2 LEU   265      93.196  29.698  64.919  1.00 20.73           C  
ATOM   5884  N   PRO   266      88.798  27.457  65.480  1.00 15.63           N  
ATOM   5885  CA  PRO   266      87.450  27.153  65.999  1.00 16.18           C  
ATOM   5886  C   PRO   266      86.857  28.356  66.741  1.00 14.14           C  
ATOM   5887  O   PRO   266      87.580  29.095  67.395  1.00 13.74           O  
ATOM   5888  CB  PRO   266      87.674  25.992  66.976  1.00 16.24           C  
ATOM   5889  CG  PRO   266      89.145  25.788  67.059  1.00 19.00           C  
ATOM   5890  CD  PRO   266      89.857  26.631  66.102  1.00 16.71           C  
ATOM   5891  N   ASP   267      85.546  28.556  66.607  1.00 13.96           N  
ATOM   5892  CA  ASP   267      84.855  29.689  67.218  1.00 14.10           C  
ATOM   5893  C   ASP   267      84.760  29.523  68.743  1.00 13.49           C  
ATOM   5894  O   ASP   267      84.859  28.418  69.281  1.00 12.65           O  
ATOM   5895  CB  ASP   267      83.449  29.792  66.625  1.00 12.54           C  
ATOM   5896  CG  ASP   267      82.819  31.171  66.739  1.00 15.42           C  
ATOM   5897  OD1 ASP   267      83.441  32.138  67.217  1.00 13.95           O  
ATOM   5898  OD2 ASP   267      81.637  31.269  66.309  1.00 14.52           O  
ATOM   5899  N   LEU   268      84.617  30.659  69.422  1.00 13.52           N  
ATOM   5900  CA  LEU   268      84.284  30.699  70.824  1.00 14.96           C  
ATOM   5901  C   LEU   268      82.946  29.991  71.042  1.00 14.82           C  
ATOM   5902  O   LEU   268      82.104  29.993  70.145  1.00 13.69           O  
ATOM   5903  CB  LEU   268      84.141  32.161  71.304  1.00 15.82           C  
ATOM   5904  CG  LEU   268      85.422  32.938  71.595  1.00 18.28           C  
ATOM   5905  CD1 LEU   268      86.182  33.204  70.301  1.00 19.74           C  
ATOM   5906  CD2 LEU   268      85.092  34.258  72.314  1.00 18.49           C  
ATOM   5907  N   PHE   269      82.776  29.416  72.224  1.00 13.88           N  
ATOM   5908  CA  PHE   269      81.479  28.918  72.704  1.00 14.11           C  
ATOM   5909  C   PHE   269      80.922  27.726  71.915  1.00 14.49           C  
ATOM   5910  O   PHE   269      79.710  27.559  71.807  1.00 14.78           O  
ATOM   5911  CB  PHE   269      80.436  30.047  72.742  1.00 13.13           C  
ATOM   5912  CG  PHE   269      80.814  31.243  73.592  1.00 12.50           C  
ATOM   5913  CD1 PHE   269      81.254  31.089  74.894  1.00 12.83           C  
ATOM   5914  CD2 PHE   269      80.654  32.522  73.105  1.00 12.47           C  
ATOM   5915  CE1 PHE   269      81.565  32.193  75.692  1.00 13.46           C  
ATOM   5916  CE2 PHE   269      80.964  33.642  73.895  1.00 12.05           C  
ATOM   5917  CZ  PHE   269      81.431  33.453  75.208  1.00 12.47           C  
ATOM   5918  N   LEU   270      81.812  26.920  71.338  1.00 14.37           N  
ATOM   5919  CA  LEU   270      81.447  25.635  70.789  1.00 16.10           C  
ATOM   5920  C   LEU   270      82.469  24.613  71.275  1.00 17.22           C  
ATOM   5921  O   LEU   270      83.675  24.880  71.244  1.00 16.86           O  
ATOM   5922  CB  LEU   270      81.459  25.668  69.258  1.00 16.26           C  
ATOM   5923  CG  LEU   270      80.278  26.364  68.588  1.00 15.58           C  
ATOM   5924  CD1 LEU   270      80.496  26.370  67.046  1.00 14.45           C  
ATOM   5925  CD2 LEU   270      78.909  25.742  68.959  1.00 15.54           C  
ATOM   5926  N   GLU   271      81.963  23.476  71.740  1.00 19.45           N  
ATOM   5927  CA  GLU   271      82.788  22.330  72.080  1.00 22.57           C  
ATOM   5928  C   GLU   271      83.343  21.779  70.762  1.00 25.04           C  
ATOM   5929  O   GLU   271      82.642  21.754  69.735  1.00 23.26           O  
ATOM   5930  CB  GLU   271      81.968  21.231  72.775  1.00 23.30           C  
ATOM   5931  CG  GLU   271      81.121  21.665  73.996  1.00 25.01           C  
ATOM   5932  CD  GLU   271      81.931  22.042  75.228  1.00 26.56           C  
ATOM   5933  OE1 GLU   271      83.171  21.827  75.219  1.00 26.60           O  
ATOM   5934  OE2 GLU   271      81.312  22.561  76.204  1.00 25.67           O  
END
