
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  218 ( 1697),  selected  218 , name 3cbg_A
# Molecule2: number of CA atoms  211 ( 1569),  selected  211 , name T0509.pdb
# PARAMETERS: 3cbg_A.T0509.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    I     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    F     8_A      -       -           -
LGA    D     9_A      -       -           -
LGA    P    10_A      -       -           -
LGA    S    11_A      N       3          3.152
LGA    L    12_A      A       4          1.627
LGA    Y    13_A      F       5          2.513
LGA    S    14_A      E       6          2.704
LGA    Y    15_A      Y       7          1.939
LGA    L    16_A      L       8          1.175
LGA    Q    17_A      R       9          2.252
LGA    -       -      T      10           -
LGA    S    18_A      Y      11          0.339
LGA    I    19_A      V      12          3.379
LGA    S    20_A      E      13          5.041
LGA    -       -      S      14           -
LGA    A    21_A      T      15           #
LGA    D    22_A      T      16          2.445
LGA    D    23_A      E      17           #
LGA    -       -      T      18           -
LGA    S    24_A      D      19          2.329
LGA    F    25_A      A      20          2.283
LGA    Y    26_A      A      21          0.779
LGA    L    27_A      V      22          0.696
LGA    A    28_A      A      23          1.493
LGA    Q    29_A      R      24          2.071
LGA    L    30_A      A      25          1.588
LGA    R    31_A      R      26          0.850
LGA    R    32_A      E      27          2.662
LGA    E    33_A      D      28          4.472
LGA    T    34_A      A      29          4.337
LGA    A    35_A      A      30          2.566
LGA    H    36_A      E      31          2.809
LGA    L    37_A      F      32          2.565
LGA    P    38_A      -       -           -
LGA    G    39_A      G      33          2.054
LGA    A    40_A      L      34          3.390
LGA    P    41_A      -       -           -
LGA    M    42_A      P      35          1.444
LGA    Q    43_A      A      36          1.124
LGA    I    44_A      P      37          0.897
LGA    S    45_A      D      38          1.112
LGA    P    46_A      E      39          1.214
LGA    E    47_A      M      40          0.922
LGA    Q    48_A      T      41          0.347
LGA    A    49_A      G      42          0.511
LGA    Q    50_A      Q      43          0.931
LGA    F    51_A      L      44          0.958
LGA    L    52_A      L      45          0.574
LGA    G    53_A      T      46          0.558
LGA    L    54_A      T      47          1.297
LGA    L    55_A      L      48          1.256
LGA    I    56_A      A      49          0.893
LGA    S    57_A      A      50          0.967
LGA    L    58_A      T      51          2.041
LGA    T    59_A      T      52          2.191
LGA    G    60_A      N      53          3.558
LGA    A    61_A      G      54          3.872
LGA    -       -      N      55           -
LGA    -       -      G      56           -
LGA    K    62_A      S      57          5.151
LGA    Q    63_A      T      58          3.372
LGA    -       -      G      59           -
LGA    V    64_A      A      60          0.741
LGA    L    65_A      I      61          1.553
LGA    E    66_A      A      62          1.809
LGA    I    67_A      I      63          1.684
LGA    G    68_A      T      64          1.711
LGA    V    69_A      P      65          3.760
LGA    F    70_A      A      66          2.427
LGA    R    71_A      A      67          5.121
LGA    G    72_A      G      68          1.682
LGA    Y    73_A      L      69          0.881
LGA    S    74_A      V      70          0.721
LGA    A    75_A      G      71          1.459
LGA    L    76_A      L      72          1.630
LGA    A    77_A      Y      73          1.095
LGA    M    78_A      I      74          0.423
LGA    A    79_A      L      75          1.371
LGA    L    80_A      N      76          2.207
LGA    Q    81_A      G      77          1.933
LGA    L    82_A      L      78          1.775
LGA    P    83_A      A      79          1.714
LGA    P    84_A      D      80          1.607
LGA    D    85_A      N      81          1.176
LGA    G    86_A      T      82          2.037
LGA    Q    87_A      T      83          0.800
LGA    I    88_A      L      84          1.333
LGA    I    89_A      T      85          1.335
LGA    A    90_A      C      86          1.107
LGA    C    91_A      I      87          1.012
LGA    D    92_A      D      88          0.770
LGA    Q    93_A      P      89          1.659
LGA    D    94_A      E      90          1.640
LGA    P    95_A      S      91          1.438
LGA    N    96_A      E      92          1.553
LGA    A    97_A      H      93          2.508
LGA    T    98_A      Q      94          2.815
LGA    A    99_A      R      95          1.520
LGA    I   100_A      Q      96          0.978
LGA    A   101_A      A      97          1.379
LGA    K   102_A      K      98          1.366
LGA    K   103_A      A      99          0.812
LGA    Y   104_A      L     100          0.434
LGA    W   105_A      F     101          0.936
LGA    Q   106_A      R     102          1.137
LGA    K   107_A      E     103          0.966
LGA    A   108_A      A     104          0.795
LGA    G   109_A      G     105          2.582
LGA    V   110_A      Y     106          2.743
LGA    A   111_A      S     107          5.122
LGA    E   112_A      P     108          2.629
LGA    -       -      S     109           -
LGA    K   113_A      R     110          1.583
LGA    I   114_A      V     111          1.631
LGA    S   115_A      R     112          0.712
LGA    L   116_A      F     113          0.776
LGA    R   117_A      L     114          0.520
LGA    L   118_A      L     115          0.699
LGA    G   119_A      S     116          1.501
LGA    P   120_A      R     117          1.157
LGA    A   121_A      P     118          1.043
LGA    L   122_A      L     119          1.437
LGA    A   123_A      D     120          1.493
LGA    T   124_A      V     121          0.734
LGA    L   125_A      M     122          0.638
LGA    E   126_A      S     123          1.141
LGA    Q   127_A      R     124          1.252
LGA    L   128_A      L     125          1.245
LGA    T   129_A      -       -           -
LGA    Q   130_A      -       -           -
LGA    G   131_A      -       -           -
LGA    K   132_A      -       -           -
LGA    P   133_A      A     126           #
LGA    L   134_A      N     127          4.060
LGA    P   135_A      D     128          5.292
LGA    E   136_A      S     129          1.248
LGA    F   137_A      Y     130          0.331
LGA    D   138_A      Q     131          0.771
LGA    L   139_A      L     132          1.092
LGA    I   140_A      V     133          1.201
LGA    F   141_A      F     134          1.165
LGA    I   142_A      G     135          1.734
LGA    D   143_A      Q     136          1.409
LGA    A   144_A      V     137          1.746
LGA    D   145_A      S     138          2.694
LGA    K   146_A      P     139          2.380
LGA    R   147_A      M     140          1.393
LGA    N   148_A      D     141          1.586
LGA    Y   149_A      L     142          1.224
LGA    P   150_A      K     143          0.813
LGA    R   151_A      A     144          1.185
LGA    Y   152_A      L     145          1.168
LGA    Y   153_A      V     146          0.458
LGA    E   154_A      D     147          1.079
LGA    I   155_A      A     148          1.813
LGA    G   156_A      A     149          1.029
LGA    L   157_A      W     150          0.613
LGA    N   158_A      P     151          0.942
LGA    L   159_A      L     152          1.068
LGA    L   160_A      L     153          0.918
LGA    R   161_A      R     154          1.051
LGA    R   162_A      R     155          1.695
LGA    G   163_A      G     156          1.952
LGA    G   164_A      G     157          1.308
LGA    L   165_A      A     158          1.336
LGA    M   166_A      L     159          1.473
LGA    V   167_A      V     160          1.260
LGA    I   168_A      L     161          1.270
LGA    D   169_A      A     162          1.321
LGA    N   170_A      D     163          1.231
LGA    V   171_A      A     164          2.086
LGA    L   172_A      L     165          1.872
LGA    W   173_A      L     166          0.985
LGA    H   174_A      D     167          3.495
LGA    G   175_A      G     168          3.566
LGA    K   176_A      T     169          2.389
LGA    V   177_A      I     170          1.451
LGA    T   178_A      A     171          3.650
LGA    E   179_A      D     172          2.712
LGA    V   180_A      Q     173          1.696
LGA    D   181_A      T     174          5.237
LGA    P   182_A      R     175          3.904
LGA    Q   183_A      K     176          3.529
LGA    E   184_A      D     177          2.719
LGA    A   185_A      R     178          2.062
LGA    Q   186_A      D     179          2.101
LGA    T   187_A      T     180          1.408
LGA    Q   188_A      Q     181          1.125
LGA    V   189_A      A     182          0.823
LGA    L   190_A      A     183          0.622
LGA    Q   191_A      R     184          0.419
LGA    Q   192_A      D     185          0.645
LGA    F   193_A      A     186          0.708
LGA    N   194_A      D     187          0.549
LGA    R   195_A      E     188          1.135
LGA    D   196_A      Y     189          1.606
LGA    L   197_A      I     190          1.551
LGA    A   198_A      R     191          1.805
LGA    Q   199_A      S     192          2.649
LGA    D   200_A      I     193          1.825
LGA    E   201_A      E     194          1.823
LGA    R   202_A      G     195          2.478
LGA    V   203_A      A     196          0.321
LGA    R   204_A      H     197          1.313
LGA    I   205_A      V     198          1.028
LGA    S   206_A      A     199          1.028
LGA    V   207_A      R     200          0.643
LGA    I   208_A      L     201          0.900
LGA    P   209_A      P     202          0.745
LGA    L   210_A      L     203          0.856
LGA    G   211_A      G     204          1.108
LGA    D   212_A      A     205          1.365
LGA    G   213_A      G     206          1.093
LGA    M   214_A      L     207          0.914
LGA    T   215_A      T     208          1.402
LGA    L   216_A      V     209          1.787
LGA    A   217_A      V     210          1.118
LGA    L   218_A      T     211          1.661
LGA    K   219_A      K     212          0.756
LGA    K   220_A      A     213          2.098

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  218  211    5.0    201    1.98    20.90     82.030     9.679

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.261644 * X  +  -0.785755 * Y  +  -0.560475 * Z  +   7.770735
  Y_new =  -0.582949 * X  +  -0.334162 * Y  +   0.740612 * Z  +  12.297633
  Z_new =  -0.769229 * X  +   0.520505 * Y  +  -0.370623 * Z  + 131.927414 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.189561   -0.952031  [ DEG:   125.4526    -54.5474 ]
  Theta =   0.877633    2.263959  [ DEG:    50.2847    129.7153 ]
  Phi   =  -1.992676    1.148917  [ DEG:  -114.1719     65.8281 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cbg_A                                        
REMARK     2: T0509.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cbg_A.T0509.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  218  211   5.0  201   1.98   20.90  82.030
REMARK  ---------------------------------------------------------- 
MOLECULE 3cbg_A
HEADER    TRANSFERASE                             22-FEB-08   3CBG              
TITLE     FUNCTIONAL AND STRUCTURAL CHARACTERIZATION OF A                       
TITLE    2 CATIONDEPENDENT O-METHYLTRANSFERASE FROM THE                         
TITLE    3 CYANOBACTERIUM SYNECHOCYSTIS SP. STRAIN PCC 6803                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: O-METHYLTRANSFERASE;                                       
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 2.1.1.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SYNECHOCYSTIS SP.;                              
SOURCE   3 STRAIN: PCC 6803;                                                    
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_GENUS: ESCHERICHIA;                                
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: M15 PREP4;                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PQE30                                     
KEYWDS    O-METHYLTRANSFERASE, CYANOBACTERIUM                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.G.KOPYCKI,P.NEUMANN,M.T.STUBBS                                      
REVDAT   1   10-JUN-08 3CBG    0                                                
JRNL        AUTH   J.G.KOPYCKI,M.T.STUBBS,W.BRANDT,M.HAGEMANN,                  
JRNL        AUTH 2 A.PORZEL,J.SCHMIDT,W.SCHLIEMANN,M.H.ZENK,T.VOGT              
JRNL        TITL   FUNCTIONAL AND STRUCTURAL CHARACTERIZATION OF A              
JRNL        TITL 2 CATION-DEPENDENT O-METHYLTRANSFERASE FROM THE                
JRNL        TITL 3 CYANOBACTERIUM SYNECHOCYSTIS SP. STRAIN PCC 6803             
JRNL        REF    J.BIOL.CHEM.                               2008              
JRNL        REFN   ASTM JBCHA3  US ESSN 1083-351X                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  3CBG A    1   220  UNP    Q55813   Q55813_SYNY3     1    220             
SEQRES   1 A  232  MET ARG GLY SER HIS HIS HIS HIS HIS HIS GLY SER MET          
SEQRES   2 A  232  GLY LYS GLY ILE THR GLY PHE ASP PRO SER LEU TYR SER          
SEQRES   3 A  232  TYR LEU GLN SER ILE SER ALA ASP ASP SER PHE TYR LEU          
SEQRES   4 A  232  ALA GLN LEU ARG ARG GLU THR ALA HIS LEU PRO GLY ALA          
SEQRES   5 A  232  PRO MET GLN ILE SER PRO GLU GLN ALA GLN PHE LEU GLY          
SEQRES   6 A  232  LEU LEU ILE SER LEU THR GLY ALA LYS GLN VAL LEU GLU          
SEQRES   7 A  232  ILE GLY VAL PHE ARG GLY TYR SER ALA LEU ALA MET ALA          
SEQRES   8 A  232  LEU GLN LEU PRO PRO ASP GLY GLN ILE ILE ALA CYS ASP          
SEQRES   9 A  232  GLN ASP PRO ASN ALA THR ALA ILE ALA LYS LYS TYR TRP          
SEQRES  10 A  232  GLN LYS ALA GLY VAL ALA GLU LYS ILE SER LEU ARG LEU          
SEQRES  11 A  232  GLY PRO ALA LEU ALA THR LEU GLU GLN LEU THR GLN GLY          
SEQRES  12 A  232  LYS PRO LEU PRO GLU PHE ASP LEU ILE PHE ILE ASP ALA          
SEQRES  13 A  232  ASP LYS ARG ASN TYR PRO ARG TYR TYR GLU ILE GLY LEU          
SEQRES  14 A  232  ASN LEU LEU ARG ARG GLY GLY LEU MET VAL ILE ASP ASN          
SEQRES  15 A  232  VAL LEU TRP HIS GLY LYS VAL THR GLU VAL ASP PRO GLN          
SEQRES  16 A  232  GLU ALA GLN THR GLN VAL LEU GLN GLN PHE ASN ARG ASP          
SEQRES  17 A  232  LEU ALA GLN ASP GLU ARG VAL ARG ILE SER VAL ILE PRO          
SEQRES  18 A  232  LEU GLY ASP GLY MET THR LEU ALA LEU LYS LYS                  
HET     MG  A 401       1                                                       
HET    SAH  A 301      26                                                       
HET    FER  A 501      14                                                       
HET    4FE  A 502      14                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     SAH S-ADENOSYL-L-HOMOCYSTEINE                                        
HETNAM     FER 3-(4-HYDROXY-3-METHOXYPHENYL)-2-PROPENOIC ACID                   
HETNAM     4FE (2E)-3-(3-HYDROXY-4-METHOXYPHENYL)PROP-2-ENOIC ACID              
HETSYN     FER FERULIC ACID                                                     
HETSYN     4FE 3-(3-HYDROXY-4-METHOXYPHENYL)-2-PROPENOIC ACID                   
FORMUL   2   MG    MG 2+                                                        
FORMUL   3  SAH    C14 H20 N6 O5 S                                              
FORMUL   4  FER    C10 H10 O4                                                   
FORMUL   5  4FE    C10 H10 O4                                                   
FORMUL   6  HOH   *124(H2 O)                                                    
CRYST1   57.622   57.622  119.834  90.00  90.00 120.00 P 31 2 1      6          
ATOM      1  N   LYS A   3      18.728  31.590 167.083  1.00 40.50           N  
ATOM      2  CA  LYS A   3      18.420  33.045 166.951  1.00 39.30           C  
ATOM      3  C   LYS A   3      18.313  33.783 168.296  1.00 38.41           C  
ATOM      4  O   LYS A   3      18.009  34.985 168.331  1.00 38.38           O  
ATOM      5  CB  LYS A   3      17.118  33.233 166.168  1.00 39.54           C  
ATOM      6  CG  LYS A   3      15.947  32.438 166.706  1.00 38.56           C  
ATOM      7  CD  LYS A   3      14.621  32.983 166.187  1.00 38.86           C  
ATOM      8  CE  LYS A   3      14.551  32.978 164.670  1.00 37.61           C  
ATOM      9  NZ  LYS A   3      13.162  33.221 164.195  1.00 35.75           N  
ATOM     10  N   GLY A   4      18.565  33.071 169.393  1.00 35.39           N  
ATOM     11  CA  GLY A   4      18.483  33.682 170.711  1.00 32.27           C  
ATOM     12  C   GLY A   4      17.130  34.296 171.032  1.00 30.38           C  
ATOM     13  O   GLY A   4      16.082  33.687 170.795  1.00 30.58           O  
ATOM     14  N   ILE A   5      17.157  35.503 171.589  1.00 27.34           N  
ATOM     15  CA  ILE A   5      15.942  36.232 171.932  1.00 26.37           C  
ATOM     16  C   ILE A   5      16.155  37.696 171.575  1.00 26.91           C  
ATOM     17  O   ILE A   5      17.018  38.362 172.143  1.00 28.73           O  
ATOM     18  CB  ILE A   5      15.610  36.130 173.443  1.00 25.08           C  
ATOM     19  CG1 ILE A   5      15.197  34.696 173.797  1.00 24.34           C  
ATOM     20  CG2 ILE A   5      14.485  37.095 173.798  1.00 22.47           C  
ATOM     21  CD1 ILE A   5      14.901  34.484 175.272  1.00 23.48           C  
ATOM     22  N   THR A   6      15.366  38.197 170.633  1.00 26.44           N  
ATOM     23  CA  THR A   6      15.487  39.584 170.200  1.00 26.47           C  
ATOM     24  C   THR A   6      15.450  40.596 171.345  1.00 26.35           C  
ATOM     25  O   THR A   6      14.487  40.654 172.107  1.00 25.88           O  
ATOM     26  CB  THR A   6      14.392  39.933 169.171  1.00 25.94           C  
ATOM     27  OG1 THR A   6      14.595  39.144 167.989  1.00 26.00           O  
ATOM     28  CG2 THR A   6      14.437  41.419 168.808  1.00 22.85           C  
ATOM     29  N   GLY A   7      16.522  41.382 171.449  1.00 27.02           N  
ATOM     30  CA  GLY A   7      16.632  42.408 172.472  1.00 27.63           C  
ATOM     31  C   GLY A   7      17.030  41.913 173.850  1.00 28.54           C  
ATOM     32  O   GLY A   7      17.050  42.689 174.807  1.00 27.78           O  
ATOM     33  N   PHE A   8      17.358  40.629 173.954  1.00 28.76           N  
ATOM     34  CA  PHE A   8      17.722  40.032 175.232  1.00 28.14           C  
ATOM     35  C   PHE A   8      19.238  39.912 175.389  1.00 29.08           C  
ATOM     36  O   PHE A   8      19.952  39.703 174.409  1.00 30.45           O  
ATOM     37  CB  PHE A   8      17.061  38.652 175.354  1.00 26.65           C  
ATOM     38  CG  PHE A   8      16.977  38.136 176.764  1.00 26.60           C  
ATOM     39  CD1 PHE A   8      16.148  38.757 177.696  1.00 25.43           C  
ATOM     40  CD2 PHE A   8      17.729  37.026 177.161  1.00 25.06           C  
ATOM     41  CE1 PHE A   8      16.065  38.280 179.010  1.00 25.34           C  
ATOM     42  CE2 PHE A   8      17.656  36.540 178.468  1.00 24.07           C  
ATOM     43  CZ  PHE A   8      16.822  37.169 179.397  1.00 23.99           C  
ATOM     44  N   ASP A   9      19.716  40.052 176.627  1.00 29.15           N  
ATOM     45  CA  ASP A   9      21.140  39.960 176.931  1.00 27.78           C  
ATOM     46  C   ASP A   9      21.697  38.616 176.465  1.00 28.10           C  
ATOM     47  O   ASP A   9      21.144  37.563 176.788  1.00 27.81           O  
ATOM     48  CB  ASP A   9      21.368  40.129 178.441  1.00 28.77           C  
ATOM     49  CG  ASP A   9      22.842  40.001 178.838  1.00 29.12           C  
ATOM     50  OD1 ASP A   9      23.669  40.836 178.412  1.00 28.08           O  
ATOM     51  OD2 ASP A   9      23.173  39.059 179.585  1.00 29.49           O  
ATOM     52  N   PRO A  10      22.801  38.640 175.687  1.00 28.16           N  
ATOM     53  CA  PRO A  10      23.449  37.427 175.165  1.00 27.45           C  
ATOM     54  C   PRO A  10      23.919  36.486 176.278  1.00 26.57           C  
ATOM     55  O   PRO A  10      23.808  35.262 176.165  1.00 25.90           O  
ATOM     56  CB  PRO A  10      24.614  37.984 174.354  1.00 27.68           C  
ATOM     57  CG  PRO A  10      24.092  39.323 173.897  1.00 28.08           C  
ATOM     58  CD  PRO A  10      23.441  39.850 175.140  1.00 27.09           C  
ATOM     59  N   SER A  11      24.448  37.078 177.344  1.00 25.04           N  
ATOM     60  CA  SER A  11      24.936  36.337 178.492  1.00 25.30           C  
ATOM     61  C   SER A  11      23.789  35.733 179.294  1.00 25.45           C  
ATOM     62  O   SER A  11      23.896  34.619 179.793  1.00 27.21           O  
ATOM     63  CB  SER A  11      25.760  37.263 179.389  1.00 26.68           C  
ATOM     64  OG  SER A  11      26.061  36.651 180.635  1.00 32.21           O  
ATOM     65  N   LEU A  12      22.691  36.472 179.423  1.00 26.06           N  
ATOM     66  CA  LEU A  12      21.541  35.979 180.175  1.00 25.36           C  
ATOM     67  C   LEU A  12      20.774  34.978 179.321  1.00 25.08           C  
ATOM     68  O   LEU A  12      20.124  34.075 179.840  1.00 25.18           O  
ATOM     69  CB  LEU A  12      20.629  37.137 180.595  1.00 23.76           C  
ATOM     70  CG  LEU A  12      19.678  36.829 181.759  1.00 25.75           C  
ATOM     71  CD1 LEU A  12      20.458  36.223 182.927  1.00 24.00           C  
ATOM     72  CD2 LEU A  12      18.962  38.111 182.189  1.00 23.19           C  
ATOM     73  N   TYR A  13      20.857  35.136 178.006  1.00 24.07           N  
ATOM     74  CA  TYR A  13      20.190  34.202 177.119  1.00 22.59           C  
ATOM     75  C   TYR A  13      20.901  32.846 177.187  1.00 21.15           C  
ATOM     76  O   TYR A  13      20.260  31.809 177.113  1.00 18.74           O  
ATOM     77  CB  TYR A  13      20.184  34.717 175.676  1.00 21.96           C  
ATOM     78  CG  TYR A  13      19.702  33.666 174.715  1.00 20.71           C  
ATOM     79  CD1 TYR A  13      18.398  33.176 174.788  1.00 19.40           C  
ATOM     80  CD2 TYR A  13      20.569  33.096 173.790  1.00 20.54           C  
ATOM     81  CE1 TYR A  13      17.969  32.135 173.964  1.00 19.47           C  
ATOM     82  CE2 TYR A  13      20.154  32.052 172.961  1.00 19.88           C  
ATOM     83  CZ  TYR A  13      18.851  31.576 173.055  1.00 19.16           C  
ATOM     84  OH  TYR A  13      18.438  30.544 172.240  1.00 18.85           O  
ATOM     85  N   SER A  14      22.225  32.855 177.321  1.00 22.20           N  
ATOM     86  CA  SER A  14      22.982  31.606 177.415  1.00 24.02           C  
ATOM     87  C   SER A  14      22.558  30.866 178.678  1.00 22.56           C  
ATOM     88  O   SER A  14      22.387  29.651 178.670  1.00 21.17           O  
ATOM     89  CB  SER A  14      24.491  31.881 177.470  1.00 26.12           C  
ATOM     90  OG  SER A  14      24.930  32.576 176.315  1.00 30.30           O  
ATOM     91  N   TYR A  15      22.394  31.610 179.766  1.00 23.16           N  
ATOM     92  CA  TYR A  15      21.966  31.022 181.026  1.00 24.80           C  
ATOM     93  C   TYR A  15      20.553  30.466 180.882  1.00 24.94           C  
ATOM     94  O   TYR A  15      20.294  29.316 181.237  1.00 25.65           O  
ATOM     95  CB  TYR A  15      21.981  32.057 182.156  1.00 25.77           C  
ATOM     96  CG  TYR A  15      21.452  31.489 183.452  1.00 25.53           C  
ATOM     97  CD1 TYR A  15      22.138  30.476 184.112  1.00 26.26           C  
ATOM     98  CD2 TYR A  15      20.243  31.925 183.991  1.00 25.53           C  
ATOM     99  CE1 TYR A  15      21.641  29.910 185.274  1.00 28.47           C  
ATOM    100  CE2 TYR A  15      19.731  31.365 185.156  1.00 24.86           C  
ATOM    101  CZ  TYR A  15      20.437  30.358 185.794  1.00 27.33           C  
ATOM    102  OH  TYR A  15      19.964  29.802 186.962  1.00 27.18           O  
ATOM    103  N   LEU A  16      19.644  31.296 180.373  1.00 24.73           N  
ATOM    104  CA  LEU A  16      18.259  30.889 180.170  1.00 24.39           C  
ATOM    105  C   LEU A  16      18.239  29.565 179.419  1.00 25.73           C  
ATOM    106  O   LEU A  16      17.443  28.682 179.731  1.00 25.03           O  
ATOM    107  CB  LEU A  16      17.498  31.966 179.395  1.00 24.35           C  
ATOM    108  CG  LEU A  16      16.033  31.684 179.061  1.00 21.71           C  
ATOM    109  CD1 LEU A  16      15.304  32.993 178.895  1.00 20.40           C  
ATOM    110  CD2 LEU A  16      15.933  30.834 177.803  1.00 23.08           C  
ATOM    111  N   GLN A  17      19.125  29.420 178.436  1.00 27.48           N  
ATOM    112  CA  GLN A  17      19.222  28.172 177.679  1.00 30.04           C  
ATOM    113  C   GLN A  17      19.654  27.022 178.614  1.00 30.18           C  
ATOM    114  O   GLN A  17      19.116  25.912 178.539  1.00 30.37           O  
ATOM    115  CB  GLN A  17      20.256  28.304 176.548  1.00 32.38           C  
ATOM    116  CG  GLN A  17      19.800  29.027 175.280  1.00 33.99           C  
ATOM    117  CD  GLN A  17      20.884  29.031 174.193  1.00 35.20           C  
ATOM    118  OE1 GLN A  17      21.951  29.630 174.361  1.00 34.14           O  
ATOM    119  NE2 GLN A  17      20.611  28.355 173.080  1.00 32.92           N  
ATOM    120  N   SER A  18      20.628  27.310 179.483  1.00 30.60           N  
ATOM    121  CA  SER A  18      21.183  26.346 180.446  1.00 30.65           C  
ATOM    122  C   SER A  18      20.108  25.723 181.314  1.00 29.78           C  
ATOM    123  O   SER A  18      20.188  24.551 181.679  1.00 29.38           O  
ATOM    124  CB  SER A  18      22.179  27.026 181.395  1.00 30.59           C  
ATOM    125  OG  SER A  18      23.086  27.875 180.721  1.00 38.44           O  
ATOM    126  N   ILE A  19      19.118  26.534 181.664  1.00 29.70           N  
ATOM    127  CA  ILE A  19      18.033  26.102 182.526  1.00 28.48           C  
ATOM    128  C   ILE A  19      16.742  25.771 181.764  1.00 29.70           C  
ATOM    129  O   ILE A  19      15.672  25.638 182.366  1.00 29.40           O  
ATOM    130  CB  ILE A  19      17.769  27.179 183.621  1.00 27.03           C  
ATOM    131  CG1 ILE A  19      17.433  28.530 182.980  1.00 24.77           C  
ATOM    132  CG2 ILE A  19      19.011  27.347 184.494  1.00 20.51           C  
ATOM    133  CD1 ILE A  19      16.876  29.557 183.962  1.00 23.96           C  
ATOM    134  N   SER A  20      16.856  25.635 180.441  1.00 31.29           N  
ATOM    135  CA  SER A  20      15.720  25.298 179.577  1.00 32.70           C  
ATOM    136  C   SER A  20      15.776  23.824 179.150  1.00 35.19           C  
ATOM    137  O   SER A  20      16.805  23.158 179.289  1.00 34.27           O  
ATOM    138  CB  SER A  20      15.695  26.193 178.328  1.00 31.21           C  
ATOM    139  OG  SER A  20      15.238  27.502 178.623  1.00 27.36           O  
ATOM    140  N   ALA A  21      14.663  23.326 178.618  1.00 38.58           N  
ATOM    141  CA  ALA A  21      14.558  21.933 178.188  1.00 41.77           C  
ATOM    142  C   ALA A  21      15.034  21.657 176.752  1.00 43.08           C  
ATOM    143  O   ALA A  21      14.709  22.409 175.826  1.00 43.38           O  
ATOM    144  CB  ALA A  21      13.107  21.460 178.355  1.00 40.94           C  
ATOM    145  N   ASP A  22      15.796  20.574 176.578  1.00 43.47           N  
ATOM    146  CA  ASP A  22      16.291  20.180 175.255  1.00 44.30           C  
ATOM    147  C   ASP A  22      15.118  19.705 174.400  1.00 43.64           C  
ATOM    148  O   ASP A  22      14.072  19.330 174.932  1.00 44.66           O  
ATOM    149  CB  ASP A  22      17.300  19.027 175.357  1.00 45.89           C  
ATOM    150  CG  ASP A  22      18.536  19.387 176.153  1.00 47.81           C  
ATOM    151  OD1 ASP A  22      19.055  20.513 175.982  1.00 49.20           O  
ATOM    152  OD2 ASP A  22      19.000  18.530 176.937  1.00 48.08           O  
ATOM    153  N   ASP A  23      15.287  19.718 173.080  1.00 42.62           N  
ATOM    154  CA  ASP A  23      14.225  19.256 172.188  1.00 40.71           C  
ATOM    155  C   ASP A  23      14.184  17.730 172.251  1.00 39.20           C  
ATOM    156  O   ASP A  23      15.210  17.089 172.478  1.00 37.56           O  
ATOM    157  CB  ASP A  23      14.488  19.672 170.729  1.00 41.16           C  
ATOM    158  CG  ASP A  23      14.396  21.172 170.506  1.00 42.10           C  
ATOM    159  OD1 ASP A  23      13.438  21.802 171.007  1.00 42.93           O  
ATOM    160  OD2 ASP A  23      15.280  21.715 169.803  1.00 42.57           O  
ATOM    161  N   SER A  24      13.002  17.151 172.058  1.00 38.08           N  
ATOM    162  CA  SER A  24      12.888  15.699 172.060  1.00 37.42           C  
ATOM    163  C   SER A  24      13.739  15.198 170.893  1.00 35.57           C  
ATOM    164  O   SER A  24      14.252  15.992 170.112  1.00 34.91           O  
ATOM    165  CB  SER A  24      11.420  15.258 171.921  1.00 37.25           C  
ATOM    166  OG  SER A  24      10.731  16.003 170.935  1.00 36.90           O  
ATOM    167  N   PHE A  25      13.888  13.886 170.773  1.00 34.71           N  
ATOM    168  CA  PHE A  25      14.730  13.311 169.732  1.00 33.54           C  
ATOM    169  C   PHE A  25      14.552  13.841 168.303  1.00 32.09           C  
ATOM    170  O   PHE A  25      15.472  14.434 167.737  1.00 31.63           O  
ATOM    171  CB  PHE A  25      14.586  11.785 169.730  1.00 32.53           C  
ATOM    172  CG  PHE A  25      15.601  11.087 168.880  1.00 31.32           C  
ATOM    173  CD1 PHE A  25      16.933  11.025 169.279  1.00 31.79           C  
ATOM    174  CD2 PHE A  25      15.240  10.532 167.657  1.00 30.87           C  
ATOM    175  CE1 PHE A  25      17.893  10.423 168.470  1.00 30.77           C  
ATOM    176  CE2 PHE A  25      16.194   9.928 166.839  1.00 31.65           C  
ATOM    177  CZ  PHE A  25      17.522   9.875 167.247  1.00 30.45           C  
ATOM    178  N   TYR A  26      13.378  13.624 167.723  1.00 31.50           N  
ATOM    179  CA  TYR A  26      13.115  14.043 166.350  1.00 30.94           C  
ATOM    180  C   TYR A  26      13.117  15.541 166.089  1.00 29.86           C  
ATOM    181  O   TYR A  26      13.403  15.970 164.972  1.00 29.27           O  
ATOM    182  CB  TYR A  26      11.806  13.422 165.866  1.00 32.92           C  
ATOM    183  CG  TYR A  26      11.843  11.910 165.905  1.00 34.84           C  
ATOM    184  CD1 TYR A  26      11.224  11.202 166.936  1.00 36.72           C  
ATOM    185  CD2 TYR A  26      12.542  11.192 164.941  1.00 35.62           C  
ATOM    186  CE1 TYR A  26      11.303   9.810 167.008  1.00 39.03           C  
ATOM    187  CE2 TYR A  26      12.630   9.802 165.001  1.00 39.88           C  
ATOM    188  CZ  TYR A  26      12.009   9.116 166.039  1.00 40.44           C  
ATOM    189  OH  TYR A  26      12.105   7.742 166.105  1.00 42.63           O  
ATOM    190  N   LEU A  27      12.789  16.335 167.103  1.00 29.46           N  
ATOM    191  CA  LEU A  27      12.793  17.791 166.959  1.00 28.41           C  
ATOM    192  C   LEU A  27      14.245  18.232 166.862  1.00 28.48           C  
ATOM    193  O   LEU A  27      14.603  19.045 166.007  1.00 28.97           O  
ATOM    194  CB  LEU A  27      12.159  18.472 168.178  1.00 26.04           C  
ATOM    195  CG  LEU A  27      10.716  18.966 168.140  1.00 25.28           C  
ATOM    196  CD1 LEU A  27      10.378  19.591 169.487  1.00 24.18           C  
ATOM    197  CD2 LEU A  27      10.541  19.981 167.027  1.00 21.77           C  
ATOM    198  N   ALA A  28      15.069  17.689 167.758  1.00 28.35           N  
ATOM    199  CA  ALA A  28      16.490  17.996 167.818  1.00 25.73           C  
ATOM    200  C   ALA A  28      17.150  17.502 166.553  1.00 25.59           C  
ATOM    201  O   ALA A  28      17.996  18.187 165.983  1.00 23.89           O  
ATOM    202  CB  ALA A  28      17.131  17.324 169.028  1.00 24.10           C  
ATOM    203  N   GLN A  29      16.751  16.308 166.120  1.00 24.99           N  
ATOM    204  CA  GLN A  29      17.310  15.701 164.916  1.00 25.32           C  
ATOM    205  C   GLN A  29      17.006  16.522 163.669  1.00 25.55           C  
ATOM    206  O   GLN A  29      17.894  16.755 162.845  1.00 25.68           O  
ATOM    207  CB  GLN A  29      16.764  14.292 164.736  1.00 25.81           C  
ATOM    208  CG  GLN A  29      17.349  13.565 163.555  1.00 26.64           C  
ATOM    209  CD  GLN A  29      16.721  12.205 163.369  1.00 29.06           C  
ATOM    210  OE1 GLN A  29      15.589  12.090 162.905  1.00 29.50           O  
ATOM    211  NE2 GLN A  29      17.449  11.163 163.753  1.00 31.72           N  
ATOM    212  N   LEU A  30      15.752  16.952 163.535  1.00 25.53           N  
ATOM    213  CA  LEU A  30      15.311  17.756 162.396  1.00 25.67           C  
ATOM    214  C   LEU A  30      16.129  19.040 162.349  1.00 25.96           C  
ATOM    215  O   LEU A  30      16.711  19.385 161.318  1.00 26.54           O  
ATOM    216  CB  LEU A  30      13.810  18.072 162.521  1.00 25.03           C  
ATOM    217  CG  LEU A  30      13.077  18.850 161.417  1.00 23.30           C  
ATOM    218  CD1 LEU A  30      11.576  18.683 161.591  1.00 21.73           C  
ATOM    219  CD2 LEU A  30      13.458  20.327 161.467  1.00 26.22           C  
ATOM    220  N   ARG A  31      16.170  19.734 163.480  1.00 27.05           N  
ATOM    221  CA  ARG A  31      16.912  20.980 163.619  1.00 29.59           C  
ATOM    222  C   ARG A  31      18.417  20.766 163.384  1.00 29.20           C  
ATOM    223  O   ARG A  31      19.085  21.593 162.759  1.00 29.16           O  
ATOM    224  CB  ARG A  31      16.667  21.556 165.022  1.00 29.91           C  
ATOM    225  CG  ARG A  31      17.664  22.609 165.474  1.00 35.39           C  
ATOM    226  CD  ARG A  31      17.335  23.987 164.942  1.00 40.09           C  
ATOM    227  NE  ARG A  31      16.439  24.730 165.831  1.00 43.63           N  
ATOM    228  CZ  ARG A  31      16.021  25.976 165.607  1.00 44.09           C  
ATOM    229  NH1 ARG A  31      16.410  26.634 164.520  1.00 43.49           N  
ATOM    230  NH2 ARG A  31      15.216  26.570 166.478  1.00 44.91           N  
ATOM    231  N   ARG A  32      18.943  19.646 163.874  1.00 29.41           N  
ATOM    232  CA  ARG A  32      20.363  19.351 163.730  1.00 30.12           C  
ATOM    233  C   ARG A  32      20.794  18.973 162.313  1.00 29.54           C  
ATOM    234  O   ARG A  32      21.806  19.471 161.814  1.00 29.17           O  
ATOM    235  CB  ARG A  32      20.778  18.232 164.698  1.00 32.78           C  
ATOM    236  CG  ARG A  32      22.184  17.705 164.427  1.00 35.73           C  
ATOM    237  CD  ARG A  32      22.650  16.659 165.425  1.00 39.25           C  
ATOM    238  NE  ARG A  32      21.900  15.404 165.377  1.00 40.92           N  
ATOM    239  CZ  ARG A  32      20.869  15.118 166.166  1.00 42.34           C  
ATOM    240  NH1 ARG A  32      20.453  16.003 167.066  1.00 41.54           N  
ATOM    241  NH2 ARG A  32      20.272  13.937 166.076  1.00 43.61           N  
ATOM    242  N   GLU A  33      20.036  18.096 161.667  1.00 27.86           N  
ATOM    243  CA  GLU A  33      20.388  17.655 160.327  1.00 28.33           C  
ATOM    244  C   GLU A  33      20.213  18.700 159.224  1.00 30.84           C  
ATOM    245  O   GLU A  33      20.881  18.626 158.192  1.00 32.70           O  
ATOM    246  CB  GLU A  33      19.600  16.395 159.979  1.00 28.04           C  
ATOM    247  CG  GLU A  33      19.840  15.253 160.958  1.00 29.52           C  
ATOM    248  CD  GLU A  33      19.186  13.957 160.530  1.00 27.13           C  
ATOM    249  OE1 GLU A  33      18.042  13.996 160.051  1.00 28.46           O  
ATOM    250  OE2 GLU A  33      19.809  12.891 160.689  1.00 31.65           O  
ATOM    251  N   THR A  34      19.336  19.678 159.440  1.00 30.35           N  
ATOM    252  CA  THR A  34      19.092  20.710 158.437  1.00 29.55           C  
ATOM    253  C   THR A  34      19.719  22.062 158.768  1.00 28.71           C  
ATOM    254  O   THR A  34      19.490  23.037 158.062  1.00 27.79           O  
ATOM    255  CB  THR A  34      17.576  20.934 158.220  1.00 29.38           C  
ATOM    256  OG1 THR A  34      16.987  21.433 159.428  1.00 30.89           O  
ATOM    257  CG2 THR A  34      16.894  19.634 157.831  1.00 29.55           C  
ATOM    258  N   ALA A  35      20.505  22.124 159.837  1.00 27.91           N  
ATOM    259  CA  ALA A  35      21.133  23.373 160.243  1.00 27.94           C  
ATOM    260  C   ALA A  35      21.967  23.998 159.127  1.00 29.15           C  
ATOM    261  O   ALA A  35      22.141  25.220 159.095  1.00 28.18           O  
ATOM    262  CB  ALA A  35      22.005  23.147 161.481  1.00 25.89           C  
ATOM    263  N   HIS A  36      22.465  23.163 158.214  1.00 29.72           N  
ATOM    264  CA  HIS A  36      23.308  23.618 157.096  1.00 32.31           C  
ATOM    265  C   HIS A  36      22.561  24.303 155.937  1.00 33.22           C  
ATOM    266  O   HIS A  36      23.092  25.224 155.303  1.00 32.95           O  
ATOM    267  CB  HIS A  36      24.113  22.438 156.538  1.00 31.82           C  
ATOM    268  CG  HIS A  36      23.263  21.359 155.946  1.00 32.72           C  
ATOM    269  ND1 HIS A  36      23.397  20.935 154.640  1.00 34.54           N  
ATOM    270  CD2 HIS A  36      22.247  20.636 156.472  1.00 33.32           C  
ATOM    271  CE1 HIS A  36      22.498  19.999 154.388  1.00 33.46           C  
ATOM    272  NE2 HIS A  36      21.788  19.799 155.483  1.00 33.69           N  
ATOM    273  N   LEU A  37      21.341  23.845 155.656  1.00 32.71           N  
ATOM    274  CA  LEU A  37      20.543  24.412 154.574  1.00 30.36           C  
ATOM    275  C   LEU A  37      20.188  25.876 154.791  1.00 29.39           C  
ATOM    276  O   LEU A  37      20.016  26.330 155.921  1.00 29.28           O  
ATOM    277  CB  LEU A  37      19.241  23.625 154.385  1.00 29.71           C  
ATOM    278  CG  LEU A  37      19.206  22.290 153.642  1.00 28.84           C  
ATOM    279  CD1 LEU A  37      20.408  22.183 152.706  1.00 27.87           C  
ATOM    280  CD2 LEU A  37      19.169  21.152 154.638  1.00 28.68           C  
ATOM    281  N   PRO A  38      20.075  26.640 153.697  1.00 28.95           N  
ATOM    282  CA  PRO A  38      19.728  28.056 153.821  1.00 29.30           C  
ATOM    283  C   PRO A  38      18.306  28.203 154.387  1.00 29.31           C  
ATOM    284  O   PRO A  38      17.457  27.329 154.186  1.00 29.45           O  
ATOM    285  CB  PRO A  38      19.863  28.567 152.383  1.00 27.59           C  
ATOM    286  CG  PRO A  38      19.538  27.356 151.560  1.00 27.25           C  
ATOM    287  CD  PRO A  38      20.283  26.270 152.286  1.00 27.85           C  
ATOM    288  N   GLY A  39      18.053  29.294 155.105  1.00 28.18           N  
ATOM    289  CA  GLY A  39      16.734  29.493 155.675  1.00 29.35           C  
ATOM    290  C   GLY A  39      16.579  28.997 157.107  1.00 30.10           C  
ATOM    291  O   GLY A  39      15.637  29.389 157.790  1.00 29.82           O  
ATOM    292  N   ALA A  40      17.491  28.140 157.565  1.00 30.72           N  
ATOM    293  CA  ALA A  40      17.450  27.606 158.930  1.00 30.53           C  
ATOM    294  C   ALA A  40      17.238  28.694 160.000  1.00 30.53           C  
ATOM    295  O   ALA A  40      16.596  28.443 161.020  1.00 30.83           O  
ATOM    296  CB  ALA A  40      18.726  26.830 159.219  1.00 30.16           C  
ATOM    297  N   PRO A  41      17.797  29.905 159.791  1.00 31.13           N  
ATOM    298  CA  PRO A  41      17.644  31.015 160.749  1.00 30.75           C  
ATOM    299  C   PRO A  41      16.197  31.531 160.888  1.00 28.68           C  
ATOM    300  O   PRO A  41      15.861  32.205 161.866  1.00 28.56           O  
ATOM    301  CB  PRO A  41      18.577  32.092 160.181  1.00 31.56           C  
ATOM    302  CG  PRO A  41      19.666  31.285 159.546  1.00 31.05           C  
ATOM    303  CD  PRO A  41      18.888  30.196 158.837  1.00 31.30           C  
ATOM    304  N   MET A  42      15.356  31.225 159.900  1.00 27.26           N  
ATOM    305  CA  MET A  42      13.952  31.641 159.907  1.00 24.75           C  
ATOM    306  C   MET A  42      13.131  30.830 160.898  1.00 23.60           C  
ATOM    307  O   MET A  42      12.087  31.289 161.354  1.00 23.73           O  
ATOM    308  CB  MET A  42      13.302  31.452 158.533  1.00 24.77           C  
ATOM    309  CG  MET A  42      13.666  32.446 157.450  1.00 25.33           C  
ATOM    310  SD  MET A  42      12.466  32.265 156.104  1.00 25.83           S  
ATOM    311  CE  MET A  42      12.687  30.524 155.673  1.00 20.72           C  
ATOM    312  N   GLN A  43      13.584  29.618 161.208  1.00 22.52           N  
ATOM    313  CA  GLN A  43      12.861  28.749 162.137  1.00 24.83           C  
ATOM    314  C   GLN A  43      12.787  29.334 163.546  1.00 24.97           C  
ATOM    315  O   GLN A  43      13.704  30.042 163.988  1.00 25.48           O  
ATOM    316  CB  GLN A  43      13.523  27.372 162.248  1.00 24.66           C  
ATOM    317  CG  GLN A  43      13.641  26.569 160.972  1.00 29.36           C  
ATOM    318  CD  GLN A  43      14.147  25.159 161.243  1.00 29.86           C  
ATOM    319  OE1 GLN A  43      14.931  24.941 162.170  1.00 32.79           O  
ATOM    320  NE2 GLN A  43      13.712  24.202 160.432  1.00 27.49           N  
ATOM    321  N   ILE A  44      11.699  29.025 164.251  1.00 23.42           N  
ATOM    322  CA  ILE A  44      11.537  29.488 165.619  1.00 21.42           C  
ATOM    323  C   ILE A  44      12.664  28.851 166.418  1.00 21.36           C  
ATOM    324  O   ILE A  44      13.159  27.779 166.062  1.00 19.93           O  
ATOM    325  CB  ILE A  44      10.182  29.049 166.237  1.00 20.88           C  
ATOM    326  CG1 ILE A  44      10.062  27.521 166.237  1.00 18.77           C  
ATOM    327  CG2 ILE A  44       9.038  29.709 165.493  1.00 17.71           C  
ATOM    328  CD1 ILE A  44       8.823  27.016 166.915  1.00 19.16           C  
ATOM    329  N   SER A  45      13.077  29.521 167.487  1.00 21.17           N  
ATOM    330  CA  SER A  45      14.145  29.022 168.337  1.00 20.56           C  
ATOM    331  C   SER A  45      13.649  27.809 169.125  1.00 21.91           C  
ATOM    332  O   SER A  45      12.444  27.543 169.184  1.00 20.55           O  
ATOM    333  CB  SER A  45      14.571  30.111 169.310  1.00 19.39           C  
ATOM    334  OG  SER A  45      13.533  30.336 170.245  1.00 14.98           O  
ATOM    335  N   PRO A  46      14.575  27.049 169.735  1.00 21.64           N  
ATOM    336  CA  PRO A  46      14.177  25.873 170.513  1.00 22.07           C  
ATOM    337  C   PRO A  46      13.280  26.262 171.697  1.00 23.43           C  
ATOM    338  O   PRO A  46      12.394  25.502 172.091  1.00 24.31           O  
ATOM    339  CB  PRO A  46      15.515  25.294 170.957  1.00 21.88           C  
ATOM    340  CG  PRO A  46      16.432  25.680 169.840  1.00 21.68           C  
ATOM    341  CD  PRO A  46      16.040  27.109 169.593  1.00 21.59           C  
ATOM    342  N   GLU A  47      13.515  27.449 172.256  1.00 23.87           N  
ATOM    343  CA  GLU A  47      12.723  27.941 173.382  1.00 24.12           C  
ATOM    344  C   GLU A  47      11.276  28.168 172.953  1.00 24.03           C  
ATOM    345  O   GLU A  47      10.340  27.867 173.689  1.00 24.27           O  
ATOM    346  CB  GLU A  47      13.314  29.250 173.938  1.00 23.73           C  
ATOM    347  CG  GLU A  47      14.659  29.081 174.656  1.00 23.74           C  
ATOM    348  CD  GLU A  47      15.813  28.846 173.702  1.00 24.09           C  
ATOM    349  OE1 GLU A  47      16.618  27.921 173.939  1.00 25.42           O  
ATOM    350  OE2 GLU A  47      15.916  29.597 172.715  1.00 25.21           O  
ATOM    351  N   GLN A  48      11.086  28.699 171.755  1.00 24.20           N  
ATOM    352  CA  GLN A  48       9.727  28.928 171.274  1.00 23.31           C  
ATOM    353  C   GLN A  48       9.020  27.596 170.995  1.00 22.43           C  
ATOM    354  O   GLN A  48       7.824  27.467 171.250  1.00 20.36           O  
ATOM    355  CB  GLN A  48       9.735  29.778 170.003  1.00 21.39           C  
ATOM    356  CG  GLN A  48      10.365  31.135 170.167  1.00 21.26           C  
ATOM    357  CD  GLN A  48      10.252  31.963 168.905  1.00 22.76           C  
ATOM    358  OE1 GLN A  48       9.276  32.697 168.717  1.00 26.18           O  
ATOM    359  NE2 GLN A  48      11.240  31.839 168.019  1.00 20.02           N  
ATOM    360  N   ALA A  49       9.754  26.616 170.467  1.00 22.29           N  
ATOM    361  CA  ALA A  49       9.164  25.308 170.163  1.00 22.32           C  
ATOM    362  C   ALA A  49       8.655  24.647 171.449  1.00 21.20           C  
ATOM    363  O   ALA A  49       7.568  24.073 171.477  1.00 20.57           O  
ATOM    364  CB  ALA A  49      10.190  24.405 169.466  1.00 20.01           C  
ATOM    365  N   GLN A  50       9.447  24.738 172.513  1.00 20.86           N  
ATOM    366  CA  GLN A  50       9.076  24.163 173.800  1.00 21.09           C  
ATOM    367  C   GLN A  50       7.823  24.845 174.357  1.00 21.33           C  
ATOM    368  O   GLN A  50       6.912  24.183 174.862  1.00 18.94           O  
ATOM    369  CB  GLN A  50      10.238  24.314 174.786  1.00 21.88           C  
ATOM    370  CG  GLN A  50       9.947  23.783 176.185  1.00 25.76           C  
ATOM    371  CD  GLN A  50       9.866  22.258 176.260  1.00 26.38           C  
ATOM    372  OE1 GLN A  50       9.527  21.703 177.314  1.00 29.54           O  
ATOM    373  NE2 GLN A  50      10.181  21.580 175.154  1.00 23.77           N  
ATOM    374  N   PHE A  51       7.797  26.175 174.264  1.00 21.38           N  
ATOM    375  CA  PHE A  51       6.672  26.978 174.728  1.00 21.44           C  
ATOM    376  C   PHE A  51       5.430  26.658 173.885  1.00 21.79           C  
ATOM    377  O   PHE A  51       4.321  26.563 174.407  1.00 22.77           O  
ATOM    378  CB  PHE A  51       7.023  28.470 174.618  1.00 20.15           C  
ATOM    379  CG  PHE A  51       5.946  29.399 175.129  1.00 21.38           C  
ATOM    380  CD1 PHE A  51       5.536  30.494 174.364  1.00 22.02           C  
ATOM    381  CD2 PHE A  51       5.344  29.189 176.371  1.00 19.62           C  
ATOM    382  CE1 PHE A  51       4.544  31.363 174.825  1.00 21.92           C  
ATOM    383  CE2 PHE A  51       4.350  30.054 176.839  1.00 18.86           C  
ATOM    384  CZ  PHE A  51       3.951  31.141 176.062  1.00 20.23           C  
ATOM    385  N   LEU A  52       5.634  26.495 172.582  1.00 21.47           N  
ATOM    386  CA  LEU A  52       4.563  26.171 171.640  1.00 21.99           C  
ATOM    387  C   LEU A  52       3.919  24.817 171.976  1.00 22.04           C  
ATOM    388  O   LEU A  52       2.694  24.685 171.956  1.00 21.39           O  
ATOM    389  CB  LEU A  52       5.133  26.137 170.217  1.00 22.66           C  
ATOM    390  CG  LEU A  52       4.408  26.873 169.096  1.00 23.20           C  
ATOM    391  CD1 LEU A  52       4.142  28.308 169.504  1.00 23.28           C  
ATOM    392  CD2 LEU A  52       5.250  26.814 167.828  1.00 24.70           C  
ATOM    393  N   GLY A  53       4.743  23.814 172.273  1.00 20.01           N  
ATOM    394  CA  GLY A  53       4.207  22.508 172.622  1.00 20.07           C  
ATOM    395  C   GLY A  53       3.492  22.560 173.963  1.00 19.85           C  
ATOM    396  O   GLY A  53       2.525  21.829 174.204  1.00 17.64           O  
ATOM    397  N   LEU A  54       3.974  23.439 174.840  1.00 19.89           N  
ATOM    398  CA  LEU A  54       3.390  23.605 176.165  1.00 20.74           C  
ATOM    399  C   LEU A  54       1.994  24.227 176.041  1.00 21.58           C  
ATOM    400  O   LEU A  54       1.089  23.922 176.821  1.00 21.47           O  
ATOM    401  CB  LEU A  54       4.290  24.491 177.029  1.00 20.23           C  
ATOM    402  CG  LEU A  54       4.236  24.203 178.532  1.00 22.61           C  
ATOM    403  CD1 LEU A  54       4.698  22.779 178.773  1.00 23.23           C  
ATOM    404  CD2 LEU A  54       5.113  25.182 179.301  1.00 22.62           C  
ATOM    405  N   LEU A  55       1.824  25.097 175.047  1.00 20.82           N  
ATOM    406  CA  LEU A  55       0.541  25.749 174.812  1.00 20.96           C  
ATOM    407  C   LEU A  55      -0.489  24.766 174.244  1.00 22.24           C  
ATOM    408  O   LEU A  55      -1.661  24.835 174.600  1.00 23.79           O  
ATOM    409  CB  LEU A  55       0.729  26.950 173.884  1.00 18.94           C  
ATOM    410  CG  LEU A  55       1.559  28.085 174.497  1.00 17.42           C  
ATOM    411  CD1 LEU A  55       1.867  29.153 173.465  1.00 15.81           C  
ATOM    412  CD2 LEU A  55       0.797  28.665 175.674  1.00 15.74           C  
ATOM    413  N   ILE A  56      -0.056  23.850 173.373  1.00 22.98           N  
ATOM    414  CA  ILE A  56      -0.956  22.833 172.810  1.00 23.01           C  
ATOM    415  C   ILE A  56      -1.542  21.994 173.951  1.00 23.49           C  
ATOM    416  O   ILE A  56      -2.739  21.718 173.980  1.00 23.11           O  
ATOM    417  CB  ILE A  56      -0.213  21.853 171.865  1.00 22.54           C  
ATOM    418  CG1 ILE A  56       0.248  22.575 170.594  1.00 21.60           C  
ATOM    419  CG2 ILE A  56      -1.120  20.667 171.539  1.00 20.65           C  
ATOM    420  CD1 ILE A  56      -0.877  23.128 169.754  1.00 20.54           C  
ATOM    421  N   SER A  57      -0.677  21.597 174.879  0.50 24.52           N  
ATOM    423  CA  SER A  57      -1.067  20.795 176.035  0.50 25.47           C  
ATOM    425  C   SER A  57      -1.973  21.559 177.003  0.50 25.68           C  
ATOM    427  O   SER A  57      -3.105  21.155 177.268  0.50 25.58           O  
ATOM    429  CB  SER A  57       0.188  20.326 176.776  0.50 26.23           C  
ATOM    431  OG  SER A  57      -0.139  19.772 178.036  0.50 28.96           O  
ATOM    433  N   LEU A  58      -1.456  22.662 177.530  1.00 25.70           N  
ATOM    434  CA  LEU A  58      -2.187  23.496 178.476  1.00 27.54           C  
ATOM    435  C   LEU A  58      -3.567  23.909 177.980  1.00 26.86           C  
ATOM    436  O   LEU A  58      -4.529  23.972 178.741  1.00 24.79           O  
ATOM    437  CB  LEU A  58      -1.371  24.759 178.784  1.00 31.23           C  
ATOM    438  CG  LEU A  58      -0.195  24.727 179.777  1.00 34.36           C  
ATOM    439  CD1 LEU A  58       0.720  23.529 179.536  1.00 36.53           C  
ATOM    440  CD2 LEU A  58       0.580  26.035 179.647  1.00 32.58           C  
ATOM    441  N   THR A  59      -3.646  24.182 176.688  1.00 27.66           N  
ATOM    442  CA  THR A  59      -4.871  24.634 176.058  1.00 27.81           C  
ATOM    443  C   THR A  59      -5.869  23.528 175.682  1.00 27.78           C  
ATOM    444  O   THR A  59      -7.069  23.782 175.576  1.00 28.41           O  
ATOM    445  CB  THR A  59      -4.492  25.486 174.821  1.00 28.63           C  
ATOM    446  OG1 THR A  59      -5.019  26.810 174.972  1.00 29.01           O  
ATOM    447  CG2 THR A  59      -4.983  24.856 173.546  1.00 28.37           C  
ATOM    448  N   GLY A  60      -5.374  22.307 175.493  1.00 27.70           N  
ATOM    449  CA  GLY A  60      -6.239  21.199 175.121  1.00 26.18           C  
ATOM    450  C   GLY A  60      -6.539  21.179 173.631  1.00 26.70           C  
ATOM    451  O   GLY A  60      -7.363  20.391 173.161  1.00 26.21           O  
ATOM    452  N   ALA A  61      -5.850  22.045 172.889  1.00 26.42           N  
ATOM    453  CA  ALA A  61      -6.032  22.177 171.448  1.00 26.32           C  
ATOM    454  C   ALA A  61      -5.994  20.857 170.695  1.00 27.06           C  
ATOM    455  O   ALA A  61      -5.179  19.978 170.984  1.00 27.54           O  
ATOM    456  CB  ALA A  61      -4.984  23.135 170.867  1.00 23.21           C  
ATOM    457  N   LYS A  62      -6.888  20.740 169.717  1.00 27.67           N  
ATOM    458  CA  LYS A  62      -6.988  19.558 168.873  1.00 27.80           C  
ATOM    459  C   LYS A  62      -6.909  19.999 167.412  1.00 27.43           C  
ATOM    460  O   LYS A  62      -6.317  19.322 166.574  1.00 26.75           O  
ATOM    461  CB  LYS A  62      -8.313  18.837 169.132  1.00 29.39           C  
ATOM    462  CG  LYS A  62      -8.494  18.365 170.567  1.00 31.74           C  
ATOM    463  CD  LYS A  62      -9.712  17.465 170.682  1.00 33.69           C  
ATOM    464  CE  LYS A  62      -9.809  16.805 172.050  1.00 34.48           C  
ATOM    465  NZ  LYS A  62     -10.965  15.857 172.101  1.00 34.64           N  
ATOM    466  N   GLN A  63      -7.505  21.153 167.125  1.00 27.55           N  
ATOM    467  CA  GLN A  63      -7.518  21.718 165.777  1.00 28.48           C  
ATOM    468  C   GLN A  63      -6.544  22.904 165.674  1.00 27.18           C  
ATOM    469  O   GLN A  63      -6.812  23.989 166.193  1.00 26.54           O  
ATOM    470  CB  GLN A  63      -8.938  22.178 165.417  1.00 30.35           C  
ATOM    471  CG  GLN A  63     -10.025  21.142 165.692  1.00 34.18           C  
ATOM    472  CD  GLN A  63      -9.713  19.781 165.079  1.00 37.98           C  
ATOM    473  OE1 GLN A  63      -9.370  19.685 163.899  1.00 40.25           O  
ATOM    474  NE2 GLN A  63      -9.843  18.718 165.879  1.00 38.00           N  
ATOM    475  N   VAL A  64      -5.419  22.680 164.999  1.00 25.88           N  
ATOM    476  CA  VAL A  64      -4.392  23.702 164.820  1.00 24.03           C  
ATOM    477  C   VAL A  64      -4.231  24.111 163.358  1.00 24.16           C  
ATOM    478  O   VAL A  64      -4.349  23.282 162.451  1.00 23.93           O  
ATOM    479  CB  VAL A  64      -3.013  23.197 165.329  1.00 22.87           C  
ATOM    480  CG1 VAL A  64      -1.944  24.272 165.134  1.00 20.60           C  
ATOM    481  CG2 VAL A  64      -3.116  22.806 166.786  1.00 21.88           C  
ATOM    482  N   LEU A  65      -3.961  25.396 163.140  1.00 23.50           N  
ATOM    483  CA  LEU A  65      -3.739  25.922 161.795  1.00 23.23           C  
ATOM    484  C   LEU A  65      -2.397  26.650 161.738  1.00 22.55           C  
ATOM    485  O   LEU A  65      -2.218  27.687 162.376  1.00 22.53           O  
ATOM    486  CB  LEU A  65      -4.848  26.896 161.387  1.00 21.82           C  
ATOM    487  CG  LEU A  65      -4.587  27.602 160.050  1.00 21.11           C  
ATOM    488  CD1 LEU A  65      -4.528  26.575 158.932  1.00 19.77           C  
ATOM    489  CD2 LEU A  65      -5.680  28.633 159.775  1.00 22.02           C  
ATOM    490  N   GLU A  66      -1.451  26.110 160.979  1.00 22.16           N  
ATOM    491  CA  GLU A  66      -0.149  26.756 160.857  1.00 22.11           C  
ATOM    492  C   GLU A  66       0.014  27.429 159.495  1.00 21.83           C  
ATOM    493  O   GLU A  66      -0.327  26.857 158.458  1.00 20.83           O  
ATOM    494  CB  GLU A  66       0.998  25.749 161.095  1.00 22.64           C  
ATOM    495  CG  GLU A  66       2.380  26.296 160.728  1.00 24.02           C  
ATOM    496  CD  GLU A  66       3.544  25.481 161.284  1.00 26.04           C  
ATOM    497  OE1 GLU A  66       3.843  25.588 162.493  1.00 24.54           O  
ATOM    498  OE2 GLU A  66       4.166  24.735 160.503  1.00 27.65           O  
ATOM    499  N   ILE A  67       0.508  28.663 159.520  1.00 21.39           N  
ATOM    500  CA  ILE A  67       0.760  29.434 158.311  1.00 21.47           C  
ATOM    501  C   ILE A  67       2.248  29.757 158.389  1.00 21.92           C  
ATOM    502  O   ILE A  67       2.672  30.552 159.222  1.00 25.04           O  
ATOM    503  CB  ILE A  67      -0.081  30.725 158.292  1.00 20.99           C  
ATOM    504  CG1 ILE A  67      -1.562  30.356 158.367  1.00 18.68           C  
ATOM    505  CG2 ILE A  67       0.192  31.521 157.016  1.00 18.30           C  
ATOM    506  CD1 ILE A  67      -2.453  31.509 158.606  1.00 19.05           C  
ATOM    507  N   GLY A  68       3.032  29.124 157.524  1.00 22.89           N  
ATOM    508  CA  GLY A  68       4.472  29.306 157.531  1.00 22.68           C  
ATOM    509  C   GLY A  68       5.040  28.031 158.125  1.00 22.07           C  
ATOM    510  O   GLY A  68       5.297  27.954 159.326  1.00 21.41           O  
ATOM    511  N   VAL A  69       5.227  27.026 157.272  1.00 21.95           N  
ATOM    512  CA  VAL A  69       5.708  25.711 157.690  1.00 21.80           C  
ATOM    513  C   VAL A  69       7.215  25.485 157.593  1.00 23.06           C  
ATOM    514  O   VAL A  69       7.853  25.058 158.562  1.00 22.34           O  
ATOM    515  CB  VAL A  69       4.979  24.592 156.874  1.00 21.65           C  
ATOM    516  CG1 VAL A  69       5.599  23.224 157.148  1.00 22.03           C  
ATOM    517  CG2 VAL A  69       3.498  24.582 157.227  1.00 21.03           C  
ATOM    518  N   PHE A  70       7.771  25.773 156.419  1.00 23.60           N  
ATOM    519  CA  PHE A  70       9.188  25.573 156.132  1.00 23.88           C  
ATOM    520  C   PHE A  70       9.546  24.080 156.198  1.00 24.60           C  
ATOM    521  O   PHE A  70       8.860  23.257 155.584  1.00 26.95           O  
ATOM    522  CB  PHE A  70      10.062  26.392 157.090  1.00 24.82           C  
ATOM    523  CG  PHE A  70      11.487  26.550 156.622  1.00 24.71           C  
ATOM    524  CD1 PHE A  70      11.768  26.796 155.277  1.00 24.93           C  
ATOM    525  CD2 PHE A  70      12.541  26.473 157.518  1.00 24.04           C  
ATOM    526  CE1 PHE A  70      13.077  26.960 154.840  1.00 25.17           C  
ATOM    527  CE2 PHE A  70      13.854  26.638 157.088  1.00 24.58           C  
ATOM    528  CZ  PHE A  70      14.123  26.881 155.749  1.00 23.72           C  
ATOM    529  N   ARG A  71      10.599  23.718 156.928  1.00 24.56           N  
ATOM    530  CA  ARG A  71      11.011  22.316 157.015  1.00 23.33           C  
ATOM    531  C   ARG A  71      10.282  21.508 158.085  1.00 23.66           C  
ATOM    532  O   ARG A  71      10.714  20.407 158.431  1.00 21.79           O  
ATOM    533  CB  ARG A  71      12.525  22.218 157.226  1.00 25.03           C  
ATOM    534  CG  ARG A  71      13.341  22.918 156.142  1.00 26.97           C  
ATOM    535  CD  ARG A  71      14.836  22.897 156.468  1.00 32.06           C  
ATOM    536  NE  ARG A  71      15.591  23.897 155.714  1.00 34.32           N  
ATOM    537  CZ  ARG A  71      15.647  23.952 154.384  1.00 38.18           C  
ATOM    538  NH1 ARG A  71      14.993  23.060 153.647  1.00 39.96           N  
ATOM    539  NH2 ARG A  71      16.342  24.914 153.787  1.00 36.84           N  
ATOM    540  N   GLY A  72       9.186  22.068 158.605  1.00 23.17           N  
ATOM    541  CA  GLY A  72       8.362  21.393 159.598  1.00 22.04           C  
ATOM    542  C   GLY A  72       8.719  21.408 161.079  1.00 21.60           C  
ATOM    543  O   GLY A  72       8.052  20.742 161.867  1.00 22.05           O  
ATOM    544  N   TYR A  73       9.735  22.162 161.480  1.00 22.69           N  
ATOM    545  CA  TYR A  73      10.137  22.191 162.891  1.00 21.75           C  
ATOM    546  C   TYR A  73       9.026  22.593 163.879  1.00 21.40           C  
ATOM    547  O   TYR A  73       8.735  21.846 164.822  1.00 19.91           O  
ATOM    548  CB  TYR A  73      11.358  23.109 163.065  1.00 22.51           C  
ATOM    549  CG  TYR A  73      11.953  23.152 164.468  1.00 21.93           C  
ATOM    550  CD1 TYR A  73      11.866  24.315 165.243  1.00 21.07           C  
ATOM    551  CD2 TYR A  73      12.646  22.057 164.997  1.00 20.05           C  
ATOM    552  CE1 TYR A  73      12.458  24.397 166.499  1.00 21.08           C  
ATOM    553  CE2 TYR A  73      13.245  22.126 166.265  1.00 21.67           C  
ATOM    554  CZ  TYR A  73      13.148  23.310 167.007  1.00 21.86           C  
ATOM    555  OH  TYR A  73      13.759  23.427 168.241  1.00 19.89           O  
ATOM    556  N   SER A  74       8.415  23.762 163.664  1.00 20.77           N  
ATOM    557  CA  SER A  74       7.352  24.265 164.540  1.00 18.57           C  
ATOM    558  C   SER A  74       6.123  23.363 164.510  1.00 18.58           C  
ATOM    559  O   SER A  74       5.502  23.116 165.546  1.00 17.93           O  
ATOM    560  CB  SER A  74       6.964  25.684 164.131  1.00 16.69           C  
ATOM    561  OG  SER A  74       6.638  25.727 162.754  1.00 19.32           O  
ATOM    562  N   ALA A  75       5.775  22.869 163.323  1.00 18.97           N  
ATOM    563  CA  ALA A  75       4.628  21.979 163.183  1.00 19.82           C  
ATOM    564  C   ALA A  75       4.894  20.690 163.965  1.00 20.00           C  
ATOM    565  O   ALA A  75       3.994  20.144 164.611  1.00 18.75           O  
ATOM    566  CB  ALA A  75       4.377  21.662 161.709  1.00 17.78           C  
ATOM    567  N   LEU A  76       6.139  20.217 163.908  1.00 20.77           N  
ATOM    568  CA  LEU A  76       6.538  18.994 164.612  1.00 20.56           C  
ATOM    569  C   LEU A  76       6.471  19.171 166.128  1.00 19.03           C  
ATOM    570  O   LEU A  76       6.033  18.277 166.840  1.00 20.06           O  
ATOM    571  CB  LEU A  76       7.956  18.578 164.207  1.00 18.96           C  
ATOM    572  CG  LEU A  76       8.497  17.319 164.889  1.00 18.74           C  
ATOM    573  CD1 LEU A  76       7.589  16.131 164.586  1.00 19.70           C  
ATOM    574  CD2 LEU A  76       9.914  17.052 164.410  1.00 18.73           C  
ATOM    575  N   ALA A  77       6.905  20.330 166.613  1.00 18.91           N  
ATOM    576  CA  ALA A  77       6.887  20.625 168.036  1.00 18.00           C  
ATOM    577  C   ALA A  77       5.458  20.536 168.573  1.00 18.76           C  
ATOM    578  O   ALA A  77       5.210  19.924 169.613  1.00 19.05           O  
ATOM    579  CB  ALA A  77       7.462  22.015 168.287  1.00 16.40           C  
ATOM    580  N   MET A  78       4.523  21.147 167.852  1.00 19.67           N  
ATOM    581  CA  MET A  78       3.123  21.137 168.247  1.00 19.57           C  
ATOM    582  C   MET A  78       2.508  19.753 168.081  1.00 19.83           C  
ATOM    583  O   MET A  78       1.819  19.262 168.970  1.00 20.15           O  
ATOM    584  CB  MET A  78       2.328  22.150 167.421  1.00 18.21           C  
ATOM    585  CG  MET A  78       2.782  23.585 167.602  1.00 19.17           C  
ATOM    586  SD  MET A  78       1.686  24.784 166.790  1.00 23.35           S  
ATOM    587  CE  MET A  78       2.206  24.646 165.066  1.00 17.03           C  
ATOM    588  N   ALA A  79       2.764  19.128 166.936  1.00 20.44           N  
ATOM    589  CA  ALA A  79       2.218  17.811 166.638  1.00 21.68           C  
ATOM    590  C   ALA A  79       2.534  16.761 167.696  1.00 22.89           C  
ATOM    591  O   ALA A  79       1.720  15.874 167.965  1.00 24.18           O  
ATOM    592  CB  ALA A  79       2.716  17.343 165.273  1.00 22.46           C  
ATOM    593  N   LEU A  80       3.710  16.864 168.300  1.00 22.95           N  
ATOM    594  CA  LEU A  80       4.133  15.903 169.313  1.00 22.51           C  
ATOM    595  C   LEU A  80       3.339  16.026 170.604  1.00 23.02           C  
ATOM    596  O   LEU A  80       3.423  15.161 171.471  1.00 23.46           O  
ATOM    597  CB  LEU A  80       5.623  16.078 169.610  1.00 18.96           C  
ATOM    598  CG  LEU A  80       6.581  15.791 168.448  1.00 17.73           C  
ATOM    599  CD1 LEU A  80       7.976  16.254 168.810  1.00 17.02           C  
ATOM    600  CD2 LEU A  80       6.569  14.313 168.121  1.00 17.34           C  
ATOM    601  N   GLN A  81       2.558  17.093 170.730  1.00 24.37           N  
ATOM    602  CA  GLN A  81       1.765  17.303 171.934  1.00 24.61           C  
ATOM    603  C   GLN A  81       0.269  17.171 171.679  1.00 24.93           C  
ATOM    604  O   GLN A  81      -0.530  17.242 172.611  1.00 24.76           O  
ATOM    605  CB  GLN A  81       2.080  18.679 172.525  1.00 24.95           C  
ATOM    606  CG  GLN A  81       3.570  18.905 172.745  1.00 26.13           C  
ATOM    607  CD  GLN A  81       4.198  17.888 173.698  1.00 25.65           C  
ATOM    608  OE1 GLN A  81       5.403  17.630 173.638  1.00 24.88           O  
ATOM    609  NE2 GLN A  81       3.387  17.321 174.586  1.00 23.27           N  
ATOM    610  N   LEU A  82      -0.101  16.979 170.413  1.00 25.81           N  
ATOM    611  CA  LEU A  82      -1.503  16.833 170.026  1.00 26.31           C  
ATOM    612  C   LEU A  82      -2.122  15.537 170.540  1.00 28.52           C  
ATOM    613  O   LEU A  82      -1.431  14.530 170.739  1.00 25.30           O  
ATOM    614  CB  LEU A  82      -1.660  16.860 168.498  1.00 24.23           C  
ATOM    615  CG  LEU A  82      -1.584  18.183 167.735  1.00 23.32           C  
ATOM    616  CD1 LEU A  82      -1.690  17.910 166.257  1.00 21.94           C  
ATOM    617  CD2 LEU A  82      -2.705  19.112 168.175  1.00 24.08           C  
ATOM    618  N   PRO A  83      -3.446  15.556 170.772  1.00 31.01           N  
ATOM    619  CA  PRO A  83      -4.167  14.372 171.253  1.00 31.91           C  
ATOM    620  C   PRO A  83      -4.165  13.339 170.119  1.00 32.58           C  
ATOM    621  O   PRO A  83      -3.775  13.650 168.985  1.00 29.30           O  
ATOM    622  CB  PRO A  83      -5.572  14.909 171.524  1.00 30.96           C  
ATOM    623  CG  PRO A  83      -5.333  16.354 171.835  1.00 31.24           C  
ATOM    624  CD  PRO A  83      -4.324  16.739 170.790  1.00 30.17           C  
ATOM    625  N   PRO A  84      -4.582  12.097 170.408  1.00 33.64           N  
ATOM    626  CA  PRO A  84      -4.600  11.087 169.346  1.00 34.69           C  
ATOM    627  C   PRO A  84      -5.446  11.537 168.145  1.00 34.60           C  
ATOM    628  O   PRO A  84      -5.210  11.127 167.007  1.00 34.24           O  
ATOM    629  CB  PRO A  84      -5.164   9.847 170.050  1.00 35.29           C  
ATOM    630  CG  PRO A  84      -5.926  10.418 171.230  1.00 36.05           C  
ATOM    631  CD  PRO A  84      -5.022  11.523 171.691  1.00 34.44           C  
ATOM    632  N   ASP A  85      -6.417  12.401 168.415  1.00 32.82           N  
ATOM    633  CA  ASP A  85      -7.303  12.915 167.384  1.00 33.00           C  
ATOM    634  C   ASP A  85      -6.918  14.345 166.982  1.00 33.69           C  
ATOM    635  O   ASP A  85      -7.694  15.047 166.329  1.00 32.71           O  
ATOM    636  CB  ASP A  85      -8.740  12.874 167.901  1.00 31.93           C  
ATOM    637  CG  ASP A  85      -8.893  13.573 169.235  1.00 33.23           C  
ATOM    638  OD1 ASP A  85      -7.989  13.438 170.091  1.00 33.55           O  
ATOM    639  OD2 ASP A  85      -9.921  14.249 169.435  1.00 34.68           O  
ATOM    640  N   GLY A  86      -5.716  14.763 167.378  1.00 34.44           N  
ATOM    641  CA  GLY A  86      -5.235  16.093 167.051  1.00 33.06           C  
ATOM    642  C   GLY A  86      -4.951  16.234 165.568  1.00 32.76           C  
ATOM    643  O   GLY A  86      -4.500  15.281 164.930  1.00 31.28           O  
ATOM    644  N   GLN A  87      -5.207  17.428 165.028  1.00 33.22           N  
ATOM    645  CA  GLN A  87      -5.009  17.727 163.601  1.00 34.18           C  
ATOM    646  C   GLN A  87      -4.368  19.096 163.331  1.00 32.33           C  
ATOM    647  O   GLN A  87      -4.751  20.090 163.938  1.00 32.11           O  
ATOM    648  CB  GLN A  87      -6.361  17.683 162.873  1.00 37.21           C  
ATOM    649  CG  GLN A  87      -6.754  16.326 162.336  1.00 42.12           C  
ATOM    650  CD  GLN A  87      -6.011  15.981 161.060  1.00 45.13           C  
ATOM    651  OE1 GLN A  87      -6.112  14.861 160.551  1.00 47.81           O  
ATOM    652  NE2 GLN A  87      -5.265  16.948 160.529  1.00 45.98           N  
ATOM    653  N   ILE A  88      -3.396  19.140 162.423  1.00 31.14           N  
ATOM    654  CA  ILE A  88      -2.753  20.401 162.053  1.00 28.91           C  
ATOM    655  C   ILE A  88      -2.877  20.614 160.552  1.00 28.51           C  
ATOM    656  O   ILE A  88      -2.505  19.748 159.761  1.00 27.67           O  
ATOM    657  CB  ILE A  88      -1.218  20.447 162.343  1.00 28.77           C  
ATOM    658  CG1 ILE A  88      -0.919  20.230 163.826  1.00 29.32           C  
ATOM    659  CG2 ILE A  88      -0.662  21.811 161.915  1.00 24.39           C  
ATOM    660  CD1 ILE A  88       0.561  20.398 164.180  1.00 24.25           C  
ATOM    661  N   ILE A  89      -3.411  21.763 160.162  1.00 28.02           N  
ATOM    662  CA  ILE A  89      -3.499  22.093 158.751  1.00 26.85           C  
ATOM    663  C   ILE A  89      -2.320  23.040 158.562  1.00 26.03           C  
ATOM    664  O   ILE A  89      -2.294  24.151 159.106  1.00 23.70           O  
ATOM    665  CB  ILE A  89      -4.844  22.764 158.397  1.00 26.90           C  
ATOM    666  CG1 ILE A  89      -5.953  21.703 158.449  1.00 27.01           C  
ATOM    667  CG2 ILE A  89      -4.763  23.407 157.013  1.00 25.69           C  
ATOM    668  CD1 ILE A  89      -7.342  22.206 158.129  1.00 27.27           C  
ATOM    669  N   ALA A  90      -1.324  22.555 157.825  1.00 25.49           N  
ATOM    670  CA  ALA A  90      -0.095  23.291 157.566  1.00 25.70           C  
ATOM    671  C   ALA A  90      -0.072  23.940 156.181  1.00 26.85           C  
ATOM    672  O   ALA A  90      -0.153  23.254 155.165  1.00 29.08           O  
ATOM    673  CB  ALA A  90       1.094  22.351 157.732  1.00 23.32           C  
ATOM    674  N   CYS A  91       0.064  25.265 156.149  1.00 27.46           N  
ATOM    675  CA  CYS A  91       0.077  26.007 154.891  1.00 28.22           C  
ATOM    676  C   CYS A  91       1.441  26.563 154.514  1.00 28.89           C  
ATOM    677  O   CYS A  91       2.045  27.328 155.269  1.00 30.32           O  
ATOM    678  CB  CYS A  91      -0.913  27.174 154.957  1.00 26.91           C  
ATOM    679  SG  CYS A  91      -2.532  26.731 155.560  1.00 26.88           S  
ATOM    680  N   ASP A  92       1.929  26.178 153.343  1.00 28.95           N  
ATOM    681  CA  ASP A  92       3.204  26.686 152.873  1.00 29.02           C  
ATOM    682  C   ASP A  92       3.315  26.621 151.355  1.00 29.80           C  
ATOM    683  O   ASP A  92       2.871  25.667 150.708  1.00 29.56           O  
ATOM    684  CB  ASP A  92       4.373  25.950 153.528  1.00 27.71           C  
ATOM    685  CG  ASP A  92       5.647  26.789 153.547  1.00 27.07           C  
ATOM    686  OD1 ASP A  92       6.267  26.985 152.480  1.00 24.05           O  
ATOM    687  OD2 ASP A  92       6.022  27.272 154.636  1.00 27.54           O  
ATOM    688  N   GLN A  93       3.923  27.670 150.819  1.00 30.88           N  
ATOM    689  CA  GLN A  93       4.133  27.888 149.397  1.00 32.97           C  
ATOM    690  C   GLN A  93       5.304  27.099 148.787  1.00 34.26           C  
ATOM    691  O   GLN A  93       5.292  26.780 147.595  1.00 34.66           O  
ATOM    692  CB  GLN A  93       4.348  29.386 149.218  1.00 34.01           C  
ATOM    693  CG  GLN A  93       4.383  29.899 147.816  1.00 39.00           C  
ATOM    694  CD  GLN A  93       4.262  31.409 147.796  1.00 39.90           C  
ATOM    695  OE1 GLN A  93       5.060  32.112 148.420  1.00 39.50           O  
ATOM    696  NE2 GLN A  93       3.256  31.916 147.086  1.00 40.47           N  
ATOM    697  N   ASP A  94       6.303  26.791 149.612  1.00 33.67           N  
ATOM    698  CA  ASP A  94       7.498  26.067 149.186  1.00 33.69           C  
ATOM    699  C   ASP A  94       7.317  24.541 149.193  1.00 34.78           C  
ATOM    700  O   ASP A  94       7.069  23.937 150.237  1.00 34.83           O  
ATOM    701  CB  ASP A  94       8.663  26.445 150.103  1.00 33.71           C  
ATOM    702  CG  ASP A  94       9.974  25.823 149.674  1.00 32.71           C  
ATOM    703  OD1 ASP A  94       9.951  24.794 148.973  1.00 34.14           O  
ATOM    704  OD2 ASP A  94      11.032  26.360 150.050  1.00 33.26           O  
ATOM    705  N   PRO A  95       7.466  23.897 148.023  1.00 35.05           N  
ATOM    706  CA  PRO A  95       7.318  22.445 147.889  1.00 35.10           C  
ATOM    707  C   PRO A  95       8.548  21.642 148.319  1.00 35.15           C  
ATOM    708  O   PRO A  95       8.431  20.500 148.775  1.00 34.58           O  
ATOM    709  CB  PRO A  95       7.029  22.278 146.404  1.00 35.43           C  
ATOM    710  CG  PRO A  95       7.919  23.317 145.803  1.00 35.23           C  
ATOM    711  CD  PRO A  95       7.677  24.523 146.703  1.00 35.01           C  
ATOM    712  N   ASN A  96       9.719  22.252 148.168  1.00 34.67           N  
ATOM    713  CA  ASN A  96      10.991  21.614 148.502  1.00 35.20           C  
ATOM    714  C   ASN A  96      11.276  21.557 149.999  1.00 34.33           C  
ATOM    715  O   ASN A  96      11.661  20.513 150.524  1.00 34.44           O  
ATOM    716  CB  ASN A  96      12.121  22.351 147.785  1.00 37.21           C  
ATOM    717  CG  ASN A  96      11.882  22.463 146.282  1.00 39.57           C  
ATOM    718  OD1 ASN A  96      12.369  23.393 145.633  1.00 40.63           O  
ATOM    719  ND2 ASN A  96      11.138  21.509 145.723  1.00 38.61           N  
ATOM    720  N   ALA A  97      11.100  22.680 150.686  1.00 32.80           N  
ATOM    721  CA  ALA A  97      11.338  22.724 152.121  1.00 33.06           C  
ATOM    722  C   ALA A  97      10.278  21.880 152.808  1.00 31.88           C  
ATOM    723  O   ALA A  97      10.558  21.154 153.758  1.00 31.89           O  
ATOM    724  CB  ALA A  97      11.269  24.163 152.628  1.00 32.55           C  
ATOM    725  N   THR A  98       9.058  21.985 152.296  1.00 31.27           N  
ATOM    726  CA  THR A  98       7.911  21.267 152.826  1.00 31.65           C  
ATOM    727  C   THR A  98       8.023  19.755 152.578  1.00 31.43           C  
ATOM    728  O   THR A  98       7.441  18.950 153.306  1.00 28.96           O  
ATOM    729  CB  THR A  98       6.604  21.861 152.211  1.00 34.01           C  
ATOM    730  OG1 THR A  98       5.686  22.200 153.260  1.00 33.56           O  
ATOM    731  CG2 THR A  98       5.962  20.894 151.233  1.00 33.44           C  
ATOM    732  N   ALA A  99       8.788  19.374 151.557  1.00 32.21           N  
ATOM    733  CA  ALA A  99       8.994  17.963 151.239  1.00 33.30           C  
ATOM    734  C   ALA A  99       9.885  17.371 152.322  1.00 34.49           C  
ATOM    735  O   ALA A  99       9.792  16.190 152.655  1.00 35.26           O  
ATOM    736  CB  ALA A  99       9.656  17.820 149.880  1.00 34.10           C  
ATOM    737  N   ILE A 100      10.762  18.211 152.864  1.00 35.85           N  
ATOM    738  CA  ILE A 100      11.672  17.811 153.933  1.00 35.26           C  
ATOM    739  C   ILE A 100      10.866  17.738 155.227  1.00 33.86           C  
ATOM    740  O   ILE A 100      11.123  16.900 156.087  1.00 33.22           O  
ATOM    741  CB  ILE A 100      12.818  18.838 154.093  1.00 36.35           C  
ATOM    742  CG1 ILE A 100      13.642  18.893 152.806  1.00 37.75           C  
ATOM    743  CG2 ILE A 100      13.699  18.467 155.270  1.00 36.82           C  
ATOM    744  CD1 ILE A 100      14.764  19.910 152.826  1.00 38.91           C  
ATOM    745  N   ALA A 101       9.881  18.624 155.351  1.00 33.95           N  
ATOM    746  CA  ALA A 101       9.024  18.651 156.529  1.00 32.24           C  
ATOM    747  C   ALA A 101       8.324  17.311 156.617  1.00 32.38           C  
ATOM    748  O   ALA A 101       8.347  16.664 157.661  1.00 31.78           O  
ATOM    749  CB  ALA A 101       7.996  19.773 156.417  1.00 29.50           C  
ATOM    750  N   LYS A 102       7.724  16.895 155.503  1.00 32.47           N  
ATOM    751  CA  LYS A 102       6.999  15.634 155.436  1.00 34.11           C  
ATOM    752  C   LYS A 102       7.880  14.441 155.822  1.00 34.33           C  
ATOM    753  O   LYS A 102       7.428  13.528 156.506  1.00 34.75           O  
ATOM    754  CB  LYS A 102       6.420  15.442 154.027  1.00 34.66           C  
ATOM    755  CG  LYS A 102       5.325  14.385 153.954  1.00 38.23           C  
ATOM    756  CD  LYS A 102       4.704  14.271 152.563  1.00 39.91           C  
ATOM    757  CE  LYS A 102       4.012  15.555 152.135  1.00 40.67           C  
ATOM    758  NZ  LYS A 102       4.980  16.634 151.828  1.00 41.63           N  
ATOM    759  N   LYS A 103       9.135  14.459 155.386  1.00 34.42           N  
ATOM    760  CA  LYS A 103      10.091  13.393 155.695  1.00 35.37           C  
ATOM    761  C   LYS A 103      10.279  13.200 157.197  1.00 35.57           C  
ATOM    762  O   LYS A 103      10.374  12.070 157.682  1.00 35.90           O  
ATOM    763  CB  LYS A 103      11.447  13.722 155.063  1.00 37.12           C  
ATOM    764  CG  LYS A 103      12.636  12.935 155.599  1.00 37.72           C  
ATOM    765  CD  LYS A 103      13.950  13.556 155.113  1.00 39.10           C  
ATOM    766  CE  LYS A 103      15.165  12.718 155.493  1.00 38.71           C  
ATOM    767  NZ  LYS A 103      15.331  12.540 156.965  1.00 40.07           N  
ATOM    768  N   TYR A 104      10.345  14.309 157.930  1.00 35.27           N  
ATOM    769  CA  TYR A 104      10.536  14.258 159.372  1.00 33.68           C  
ATOM    770  C   TYR A 104       9.281  14.006 160.182  1.00 33.48           C  
ATOM    771  O   TYR A 104       9.352  13.439 161.264  1.00 34.28           O  
ATOM    772  CB  TYR A 104      11.206  15.535 159.865  1.00 33.25           C  
ATOM    773  CG  TYR A 104      12.674  15.580 159.560  1.00 32.33           C  
ATOM    774  CD1 TYR A 104      13.140  16.089 158.349  1.00 32.62           C  
ATOM    775  CD2 TYR A 104      13.606  15.091 160.479  1.00 32.76           C  
ATOM    776  CE1 TYR A 104      14.503  16.115 158.055  1.00 32.67           C  
ATOM    777  CE2 TYR A 104      14.970  15.107 160.201  1.00 33.76           C  
ATOM    778  CZ  TYR A 104      15.413  15.623 158.986  1.00 34.21           C  
ATOM    779  OH  TYR A 104      16.762  15.649 158.712  1.00 34.38           O  
ATOM    780  N   TRP A 105       8.132  14.435 159.678  1.00 34.40           N  
ATOM    781  CA  TRP A 105       6.890  14.214 160.403  1.00 34.94           C  
ATOM    782  C   TRP A 105       6.562  12.723 160.430  1.00 35.72           C  
ATOM    783  O   TRP A 105       6.241  12.170 161.480  1.00 34.49           O  
ATOM    784  CB  TRP A 105       5.735  14.995 159.760  1.00 33.48           C  
ATOM    785  CG  TRP A 105       5.895  16.495 159.807  1.00 31.97           C  
ATOM    786  CD1 TRP A 105       6.607  17.220 160.725  1.00 31.20           C  
ATOM    787  CD2 TRP A 105       5.277  17.451 158.934  1.00 30.95           C  
ATOM    788  NE1 TRP A 105       6.468  18.565 160.478  1.00 30.45           N  
ATOM    789  CE2 TRP A 105       5.657  18.736 159.387  1.00 31.12           C  
ATOM    790  CE3 TRP A 105       4.436  17.347 157.816  1.00 30.83           C  
ATOM    791  CZ2 TRP A 105       5.224  19.916 158.756  1.00 31.61           C  
ATOM    792  CZ3 TRP A 105       4.004  18.520 157.187  1.00 31.70           C  
ATOM    793  CH2 TRP A 105       4.401  19.786 157.663  1.00 30.85           C  
ATOM    794  N   GLN A 106       6.652  12.080 159.270  1.00 38.64           N  
ATOM    795  CA  GLN A 106       6.368  10.650 159.156  1.00 41.49           C  
ATOM    796  C   GLN A 106       7.416   9.871 159.952  1.00 40.84           C  
ATOM    797  O   GLN A 106       7.128   8.826 160.547  1.00 41.55           O  
ATOM    798  CB  GLN A 106       6.400  10.231 157.678  1.00 44.63           C  
ATOM    799  CG  GLN A 106       5.504  11.097 156.790  1.00 51.20           C  
ATOM    800  CD  GLN A 106       5.545  10.712 155.321  1.00 54.05           C  
ATOM    801  OE1 GLN A 106       6.615  10.675 154.705  1.00 57.02           O  
ATOM    802  NE2 GLN A 106       4.375  10.432 154.747  1.00 54.97           N  
ATOM    803  N   LYS A 107       8.630  10.413 159.965  1.00 38.78           N  
ATOM    804  CA  LYS A 107       9.761   9.829 160.667  1.00 37.42           C  
ATOM    805  C   LYS A 107       9.547   9.856 162.187  1.00 36.37           C  
ATOM    806  O   LYS A 107      10.108   9.039 162.916  1.00 37.29           O  
ATOM    807  CB  LYS A 107      11.025  10.608 160.297  1.00 37.74           C  
ATOM    808  CG  LYS A 107      12.312   9.970 160.733  1.00 39.35           C  
ATOM    809  CD  LYS A 107      13.495  10.858 160.389  1.00 41.32           C  
ATOM    810  CE  LYS A 107      14.804  10.137 160.667  1.00 43.72           C  
ATOM    811  NZ  LYS A 107      14.921   9.647 162.074  1.00 44.93           N  
ATOM    812  N   ALA A 108       8.736  10.799 162.658  1.00 35.14           N  
ATOM    813  CA  ALA A 108       8.448  10.936 164.085  1.00 32.00           C  
ATOM    814  C   ALA A 108       7.083  10.343 164.410  1.00 30.58           C  
ATOM    815  O   ALA A 108       6.682  10.278 165.573  1.00 29.21           O  
ATOM    816  CB  ALA A 108       8.491  12.405 164.490  1.00 31.78           C  
ATOM    817  N   GLY A 109       6.376   9.920 163.367  1.00 30.11           N  
ATOM    818  CA  GLY A 109       5.065   9.320 163.538  1.00 30.96           C  
ATOM    819  C   GLY A 109       3.903  10.264 163.802  1.00 31.43           C  
ATOM    820  O   GLY A 109       2.888   9.850 164.366  1.00 32.63           O  
ATOM    821  N   VAL A 110       4.032  11.525 163.403  1.00 31.76           N  
ATOM    822  CA  VAL A 110       2.960  12.491 163.618  1.00 31.45           C  
ATOM    823  C   VAL A 110       2.412  13.002 162.295  1.00 32.03           C  
ATOM    824  O   VAL A 110       1.524  13.847 162.275  1.00 33.25           O  
ATOM    825  CB  VAL A 110       3.445  13.703 164.447  1.00 30.43           C  
ATOM    826  CG1 VAL A 110       3.900  13.243 165.824  1.00 29.02           C  
ATOM    827  CG2 VAL A 110       4.565  14.420 163.714  1.00 29.44           C  
ATOM    828  N   ALA A 111       2.943  12.481 161.193  1.00 33.10           N  
ATOM    829  CA  ALA A 111       2.510  12.892 159.860  1.00 34.18           C  
ATOM    830  C   ALA A 111       1.025  12.636 159.660  1.00 34.38           C  
ATOM    831  O   ALA A 111       0.410  13.166 158.735  1.00 33.87           O  
ATOM    832  CB  ALA A 111       3.308  12.146 158.802  1.00 34.61           C  
ATOM    833  N   GLU A 112       0.463  11.809 160.532  1.00 35.29           N  
ATOM    834  CA  GLU A 112      -0.952  11.466 160.486  1.00 36.24           C  
ATOM    835  C   GLU A 112      -1.794  12.629 160.980  1.00 33.73           C  
ATOM    836  O   GLU A 112      -2.951  12.788 160.583  1.00 31.98           O  
ATOM    837  CB  GLU A 112      -1.219  10.244 161.373  1.00 39.59           C  
ATOM    838  CG  GLU A 112      -0.513   9.002 160.895  1.00 45.66           C  
ATOM    839  CD  GLU A 112      -0.914   8.651 159.478  1.00 49.08           C  
ATOM    840  OE1 GLU A 112      -2.050   8.153 159.286  1.00 51.29           O  
ATOM    841  OE2 GLU A 112      -0.100   8.893 158.557  1.00 49.92           O  
ATOM    842  N   LYS A 113      -1.195  13.439 161.849  1.00 31.44           N  
ATOM    843  CA  LYS A 113      -1.872  14.576 162.447  1.00 31.10           C  
ATOM    844  C   LYS A 113      -1.601  15.911 161.754  1.00 29.46           C  
ATOM    845  O   LYS A 113      -2.008  16.960 162.249  1.00 29.75           O  
ATOM    846  CB  LYS A 113      -1.477  14.676 163.921  1.00 30.94           C  
ATOM    847  CG  LYS A 113      -1.659  13.389 164.711  1.00 31.02           C  
ATOM    848  CD  LYS A 113      -1.224  13.582 166.157  1.00 30.80           C  
ATOM    849  CE  LYS A 113      -1.254  12.277 166.929  1.00 32.89           C  
ATOM    850  NZ  LYS A 113      -0.879  12.471 168.358  1.00 32.18           N  
ATOM    851  N   ILE A 114      -0.922  15.870 160.612  1.00 29.19           N  
ATOM    852  CA  ILE A 114      -0.593  17.085 159.867  1.00 28.22           C  
ATOM    853  C   ILE A 114      -1.028  17.007 158.399  1.00 27.84           C  
ATOM    854  O   ILE A 114      -0.635  16.099 157.665  1.00 26.48           O  
ATOM    855  CB  ILE A 114       0.931  17.371 159.934  1.00 27.94           C  
ATOM    856  CG1 ILE A 114       1.387  17.355 161.398  1.00 25.10           C  
ATOM    857  CG2 ILE A 114       1.245  18.716 159.269  1.00 25.42           C  
ATOM    858  CD1 ILE A 114       2.874  17.373 161.586  1.00 25.00           C  
ATOM    859  N   SER A 115      -1.849  17.966 157.983  1.00 29.07           N  
ATOM    860  CA  SER A 115      -2.338  18.011 156.611  1.00 30.08           C  
ATOM    861  C   SER A 115      -1.714  19.210 155.919  1.00 30.36           C  
ATOM    862  O   SER A 115      -2.147  20.349 156.122  1.00 32.77           O  
ATOM    863  CB  SER A 115      -3.863  18.130 156.595  1.00 30.02           C  
ATOM    864  OG  SER A 115      -4.357  18.159 155.268  1.00 35.10           O  
ATOM    865  N   LEU A 116      -0.690  18.950 155.113  1.00 29.32           N  
ATOM    866  CA  LEU A 116       0.012  20.011 154.400  1.00 30.09           C  
ATOM    867  C   LEU A 116      -0.791  20.534 153.218  1.00 31.05           C  
ATOM    868  O   LEU A 116      -1.295  19.762 152.406  1.00 32.41           O  
ATOM    869  CB  LEU A 116       1.376  19.512 153.904  1.00 29.38           C  
ATOM    870  CG  LEU A 116       2.170  20.423 152.956  1.00 28.51           C  
ATOM    871  CD1 LEU A 116       2.735  21.638 153.702  1.00 26.33           C  
ATOM    872  CD2 LEU A 116       3.282  19.611 152.318  1.00 26.92           C  
ATOM    873  N   ARG A 117      -0.912  21.853 153.138  1.00 30.24           N  
ATOM    874  CA  ARG A 117      -1.624  22.491 152.050  1.00 31.78           C  
ATOM    875  C   ARG A 117      -0.589  23.328 151.307  1.00 32.46           C  
ATOM    876  O   ARG A 117      -0.268  24.438 151.729  1.00 33.14           O  
ATOM    877  CB  ARG A 117      -2.744  23.388 152.594  1.00 31.20           C  
ATOM    878  CG  ARG A 117      -3.708  22.692 153.550  1.00 32.95           C  
ATOM    879  CD  ARG A 117      -4.258  21.397 152.961  1.00 31.74           C  
ATOM    880  NE  ARG A 117      -5.092  20.665 153.914  1.00 31.64           N  
ATOM    881  CZ  ARG A 117      -6.336  21.004 154.245  1.00 31.12           C  
ATOM    882  NH1 ARG A 117      -6.906  22.070 153.701  1.00 29.40           N  
ATOM    883  NH2 ARG A 117      -7.011  20.273 155.127  1.00 29.98           N  
ATOM    884  N   LEU A 118      -0.059  22.782 150.213  1.00 32.67           N  
ATOM    885  CA  LEU A 118       0.955  23.468 149.409  1.00 32.31           C  
ATOM    886  C   LEU A 118       0.326  24.523 148.507  1.00 32.15           C  
ATOM    887  O   LEU A 118      -0.659  24.251 147.824  1.00 33.18           O  
ATOM    888  CB  LEU A 118       1.714  22.462 148.541  1.00 33.10           C  
ATOM    889  CG  LEU A 118       3.247  22.461 148.582  1.00 34.29           C  
ATOM    890  CD1 LEU A 118       3.761  21.587 147.450  1.00 35.12           C  
ATOM    891  CD2 LEU A 118       3.800  23.869 148.449  1.00 33.26           C  
ATOM    892  N   GLY A 119       0.912  25.720 148.501  1.00 31.84           N  
ATOM    893  CA  GLY A 119       0.399  26.806 147.685  1.00 31.48           C  
ATOM    894  C   GLY A 119       0.238  28.079 148.495  1.00 31.63           C  
ATOM    895  O   GLY A 119       0.331  28.034 149.719  1.00 31.62           O  
ATOM    896  N   PRO A 120      -0.003  29.236 147.850  1.00 32.18           N  
ATOM    897  CA  PRO A 120      -0.167  30.493 148.592  1.00 31.43           C  
ATOM    898  C   PRO A 120      -1.153  30.354 149.753  1.00 31.63           C  
ATOM    899  O   PRO A 120      -2.275  29.878 149.576  1.00 32.29           O  
ATOM    900  CB  PRO A 120      -0.652  31.461 147.521  1.00 30.20           C  
ATOM    901  CG  PRO A 120       0.076  30.978 146.306  1.00 32.44           C  
ATOM    902  CD  PRO A 120      -0.103  29.471 146.398  1.00 31.55           C  
ATOM    903  N   ALA A 121      -0.716  30.772 150.936  1.00 30.00           N  
ATOM    904  CA  ALA A 121      -1.526  30.688 152.142  1.00 29.24           C  
ATOM    905  C   ALA A 121      -2.915  31.316 152.008  1.00 29.68           C  
ATOM    906  O   ALA A 121      -3.897  30.757 152.492  1.00 29.91           O  
ATOM    907  CB  ALA A 121      -0.778  31.323 153.301  1.00 28.17           C  
ATOM    908  N   LEU A 122      -3.005  32.473 151.360  1.00 29.03           N  
ATOM    909  CA  LEU A 122      -4.300  33.139 151.198  1.00 28.70           C  
ATOM    910  C   LEU A 122      -5.315  32.276 150.445  1.00 28.40           C  
ATOM    911  O   LEU A 122      -6.496  32.225 150.801  1.00 28.12           O  
ATOM    912  CB  LEU A 122      -4.121  34.478 150.479  1.00 27.46           C  
ATOM    913  CG  LEU A 122      -3.363  35.522 151.292  1.00 30.18           C  
ATOM    914  CD1 LEU A 122      -3.123  36.762 150.446  1.00 30.46           C  
ATOM    915  CD2 LEU A 122      -4.166  35.854 152.552  1.00 30.88           C  
ATOM    916  N   ALA A 123      -4.847  31.602 149.402  1.00 27.71           N  
ATOM    917  CA  ALA A 123      -5.704  30.736 148.607  1.00 27.32           C  
ATOM    918  C   ALA A 123      -6.248  29.606 149.490  1.00 26.39           C  
ATOM    919  O   ALA A 123      -7.426  29.246 149.411  1.00 24.79           O  
ATOM    920  CB  ALA A 123      -4.905  30.166 147.430  1.00 26.28           C  
ATOM    921  N   THR A 124      -5.380  29.064 150.342  1.00 25.93           N  
ATOM    922  CA  THR A 124      -5.751  27.979 151.254  1.00 25.27           C  
ATOM    923  C   THR A 124      -6.730  28.442 152.328  1.00 25.96           C  
ATOM    924  O   THR A 124      -7.652  27.711 152.688  1.00 26.57           O  
ATOM    925  CB  THR A 124      -4.499  27.375 151.945  1.00 24.09           C  
ATOM    926  OG1 THR A 124      -3.629  26.823 150.949  1.00 21.01           O  
ATOM    927  CG2 THR A 124      -4.898  26.286 152.937  1.00 21.72           C  
ATOM    928  N   LEU A 125      -6.523  29.647 152.850  1.00 25.57           N  
ATOM    929  CA  LEU A 125      -7.413  30.179 153.874  1.00 26.82           C  
ATOM    930  C   LEU A 125      -8.781  30.429 153.254  1.00 26.79           C  
ATOM    931  O   LEU A 125      -9.814  30.205 153.876  1.00 24.99           O  
ATOM    932  CB  LEU A 125      -6.840  31.478 154.469  1.00 25.65           C  
ATOM    933  CG  LEU A 125      -5.691  31.311 155.478  1.00 24.47           C  
ATOM    934  CD1 LEU A 125      -5.116  32.660 155.878  1.00 22.51           C  
ATOM    935  CD2 LEU A 125      -6.212  30.579 156.693  1.00 22.04           C  
ATOM    936  N   GLU A 126      -8.776  30.888 152.011  1.00 30.04           N  
ATOM    937  CA  GLU A 126     -10.016  31.148 151.303  1.00 33.48           C  
ATOM    938  C   GLU A 126     -10.824  29.849 151.149  1.00 33.86           C  
ATOM    939  O   GLU A 126     -12.046  29.859 151.259  1.00 33.98           O  
ATOM    940  CB  GLU A 126      -9.706  31.759 149.937  1.00 35.45           C  
ATOM    941  CG  GLU A 126     -10.925  32.042 149.083  1.00 40.34           C  
ATOM    942  CD  GLU A 126     -10.578  32.791 147.808  1.00 43.71           C  
ATOM    943  OE1 GLU A 126     -10.243  33.998 147.898  1.00 45.76           O  
ATOM    944  OE2 GLU A 126     -10.630  32.171 146.722  1.00 44.25           O  
ATOM    945  N   GLN A 127     -10.140  28.734 150.905  1.00 35.09           N  
ATOM    946  CA  GLN A 127     -10.812  27.444 150.749  1.00 35.64           C  
ATOM    947  C   GLN A 127     -11.354  26.946 152.086  1.00 34.35           C  
ATOM    948  O   GLN A 127     -12.409  26.319 152.138  1.00 33.03           O  
ATOM    949  CB  GLN A 127      -9.849  26.402 150.170  1.00 38.66           C  
ATOM    950  CG  GLN A 127      -9.210  26.799 148.845  1.00 46.60           C  
ATOM    951  CD  GLN A 127     -10.229  27.160 147.767  1.00 51.30           C  
ATOM    952  OE1 GLN A 127     -10.939  28.166 147.872  1.00 53.94           O  
ATOM    953  NE2 GLN A 127     -10.305  26.337 146.723  1.00 54.42           N  
ATOM    954  N   LEU A 128     -10.620  27.223 153.163  1.00 34.10           N  
ATOM    955  CA  LEU A 128     -11.021  26.815 154.506  1.00 34.27           C  
ATOM    956  C   LEU A 128     -12.293  27.538 154.935  1.00 35.18           C  
ATOM    957  O   LEU A 128     -13.167  26.953 155.585  1.00 35.44           O  
ATOM    958  CB  LEU A 128      -9.905  27.121 155.509  1.00 33.47           C  
ATOM    959  CG  LEU A 128      -8.638  26.269 155.394  1.00 36.10           C  
ATOM    960  CD1 LEU A 128      -7.509  26.894 156.208  1.00 35.12           C  
ATOM    961  CD2 LEU A 128      -8.943  24.847 155.869  1.00 35.50           C  
ATOM    962  N   THR A 129     -12.385  28.817 154.579  1.00 35.03           N  
ATOM    963  CA  THR A 129     -13.546  29.625 154.921  1.00 35.67           C  
ATOM    964  C   THR A 129     -14.713  29.248 154.007  1.00 37.90           C  
ATOM    965  O   THR A 129     -15.875  29.455 154.355  1.00 38.35           O  
ATOM    966  CB  THR A 129     -13.243  31.131 154.770  1.00 34.40           C  
ATOM    967  OG1 THR A 129     -13.046  31.440 153.385  1.00 35.12           O  
ATOM    968  CG2 THR A 129     -11.993  31.505 155.554  1.00 30.90           C  
ATOM    969  N   GLN A 130     -14.396  28.692 152.840  1.00 39.69           N  
ATOM    970  CA  GLN A 130     -15.415  28.265 151.882  1.00 42.41           C  
ATOM    971  C   GLN A 130     -15.902  26.851 152.206  1.00 43.00           C  
ATOM    972  O   GLN A 130     -16.705  26.283 151.469  1.00 42.06           O  
ATOM    973  CB  GLN A 130     -14.854  28.271 150.456  1.00 43.72           C  
ATOM    974  CG  GLN A 130     -14.665  29.642 149.824  1.00 48.09           C  
ATOM    975  CD  GLN A 130     -14.097  29.553 148.409  1.00 49.83           C  
ATOM    976  OE1 GLN A 130     -14.597  28.798 147.571  1.00 51.38           O  
ATOM    977  NE2 GLN A 130     -13.053  30.328 148.138  1.00 51.31           N  
ATOM    978  N   GLY A 131     -15.414  26.296 153.312  1.00 43.91           N  
ATOM    979  CA  GLY A 131     -15.778  24.944 153.700  1.00 45.65           C  
ATOM    980  C   GLY A 131     -17.116  24.748 154.388  1.00 47.03           C  
ATOM    981  O   GLY A 131     -17.613  25.628 155.091  1.00 46.74           O  
ATOM    982  N   LYS A 132     -17.695  23.569 154.178  1.00 48.88           N  
ATOM    983  CA  LYS A 132     -18.977  23.215 154.770  1.00 50.75           C  
ATOM    984  C   LYS A 132     -18.824  21.972 155.656  1.00 52.36           C  
ATOM    985  O   LYS A 132     -18.593  20.865 155.158  1.00 53.80           O  
ATOM    986  CB  LYS A 132     -20.001  22.955 153.671  1.00 50.26           C  
ATOM    987  N   PRO A 133     -18.931  22.145 156.987  1.00 52.22           N  
ATOM    988  CA  PRO A 133     -19.179  23.421 157.667  1.00 51.15           C  
ATOM    989  C   PRO A 133     -17.883  24.199 157.911  1.00 50.78           C  
ATOM    990  O   PRO A 133     -16.786  23.660 157.767  1.00 51.24           O  
ATOM    991  CB  PRO A 133     -19.842  22.983 158.966  1.00 50.45           C  
ATOM    992  CG  PRO A 133     -19.096  21.735 159.286  1.00 51.64           C  
ATOM    993  CD  PRO A 133     -19.002  21.024 157.943  1.00 51.91           C  
ATOM    994  N   LEU A 134     -18.022  25.467 158.282  1.00 50.43           N  
ATOM    995  CA  LEU A 134     -16.874  26.330 158.552  1.00 49.48           C  
ATOM    996  C   LEU A 134     -15.975  25.752 159.644  1.00 48.00           C  
ATOM    997  O   LEU A 134     -16.416  25.548 160.779  1.00 48.36           O  
ATOM    998  CB  LEU A 134     -17.357  27.720 158.988  1.00 50.18           C  
ATOM    999  CG  LEU A 134     -16.291  28.775 159.313  1.00 51.51           C  
ATOM   1000  CD1 LEU A 134     -15.579  29.204 158.031  1.00 50.71           C  
ATOM   1001  CD2 LEU A 134     -16.946  29.974 159.984  1.00 51.70           C  
ATOM   1002  N   PRO A 135     -14.698  25.485 159.318  1.00 46.30           N  
ATOM   1003  CA  PRO A 135     -13.779  24.931 160.321  1.00 43.75           C  
ATOM   1004  C   PRO A 135     -13.439  25.964 161.403  1.00 41.69           C  
ATOM   1005  O   PRO A 135     -13.426  27.166 161.137  1.00 41.18           O  
ATOM   1006  CB  PRO A 135     -12.543  24.557 159.496  1.00 42.84           C  
ATOM   1007  CG  PRO A 135     -13.083  24.360 158.109  1.00 44.67           C  
ATOM   1008  CD  PRO A 135     -14.073  25.487 157.983  1.00 44.93           C  
ATOM   1009  N   GLU A 136     -13.194  25.497 162.624  1.00 40.06           N  
ATOM   1010  CA  GLU A 136     -12.802  26.385 163.719  1.00 38.54           C  
ATOM   1011  C   GLU A 136     -11.693  25.744 164.547  1.00 34.97           C  
ATOM   1012  O   GLU A 136     -11.889  24.739 165.233  1.00 35.10           O  
ATOM   1013  CB  GLU A 136     -13.999  26.780 164.601  1.00 39.12           C  
ATOM   1014  CG  GLU A 136     -15.048  25.717 164.820  1.00 43.28           C  
ATOM   1015  CD  GLU A 136     -16.256  26.255 165.572  1.00 45.44           C  
ATOM   1016  OE1 GLU A 136     -17.280  25.544 165.637  1.00 48.24           O  
ATOM   1017  OE2 GLU A 136     -16.183  27.390 166.099  1.00 45.80           O  
ATOM   1018  N   PHE A 137     -10.516  26.347 164.454  1.00 30.67           N  
ATOM   1019  CA  PHE A 137      -9.331  25.860 165.134  1.00 27.41           C  
ATOM   1020  C   PHE A 137      -9.264  26.327 166.577  1.00 25.32           C  
ATOM   1021  O   PHE A 137      -9.893  27.308 166.955  1.00 23.00           O  
ATOM   1022  CB  PHE A 137      -8.096  26.321 164.359  1.00 26.50           C  
ATOM   1023  CG  PHE A 137      -8.124  25.941 162.900  1.00 25.47           C  
ATOM   1024  CD1 PHE A 137      -7.609  24.721 162.471  1.00 25.13           C  
ATOM   1025  CD2 PHE A 137      -8.702  26.793 161.957  1.00 25.94           C  
ATOM   1026  CE1 PHE A 137      -7.666  24.354 161.119  1.00 25.55           C  
ATOM   1027  CE2 PHE A 137      -8.768  26.437 160.603  1.00 25.12           C  
ATOM   1028  CZ  PHE A 137      -8.249  25.215 160.183  1.00 24.84           C  
ATOM   1029  N   ASP A 138      -8.510  25.591 167.382  1.00 23.91           N  
ATOM   1030  CA  ASP A 138      -8.338  25.925 168.784  1.00 23.73           C  
ATOM   1031  C   ASP A 138      -7.154  26.875 168.878  1.00 23.67           C  
ATOM   1032  O   ASP A 138      -7.121  27.764 169.729  1.00 24.20           O  
ATOM   1033  CB  ASP A 138      -8.052  24.658 169.603  1.00 23.97           C  
ATOM   1034  CG  ASP A 138      -9.209  23.674 169.587  1.00 22.54           C  
ATOM   1035  OD1 ASP A 138     -10.327  24.069 169.968  1.00 24.57           O  
ATOM   1036  OD2 ASP A 138      -9.001  22.509 169.198  1.00 22.61           O  
ATOM   1037  N   LEU A 139      -6.190  26.682 167.981  1.00 23.18           N  
ATOM   1038  CA  LEU A 139      -4.991  27.506 167.950  1.00 20.95           C  
ATOM   1039  C   LEU A 139      -4.486  27.728 166.523  1.00 19.80           C  
ATOM   1040  O   LEU A 139      -4.536  26.832 165.685  1.00 18.85           O  
ATOM   1041  CB  LEU A 139      -3.900  26.858 168.815  1.00 20.55           C  
ATOM   1042  CG  LEU A 139      -2.600  27.636 169.055  1.00 19.41           C  
ATOM   1043  CD1 LEU A 139      -1.951  27.114 170.314  1.00 19.85           C  
ATOM   1044  CD2 LEU A 139      -1.651  27.509 167.868  1.00 19.93           C  
ATOM   1045  N   ILE A 140      -4.013  28.940 166.258  1.00 19.24           N  
ATOM   1046  CA  ILE A 140      -3.487  29.303 164.946  1.00 19.96           C  
ATOM   1047  C   ILE A 140      -2.102  29.937 165.091  1.00 18.87           C  
ATOM   1048  O   ILE A 140      -1.929  30.886 165.855  1.00 19.94           O  
ATOM   1049  CB  ILE A 140      -4.418  30.314 164.236  1.00 21.73           C  
ATOM   1050  CG1 ILE A 140      -5.810  29.691 164.060  1.00 20.90           C  
ATOM   1051  CG2 ILE A 140      -3.789  30.761 162.900  1.00 20.30           C  
ATOM   1052  CD1 ILE A 140      -6.853  30.628 163.494  1.00 20.91           C  
ATOM   1053  N   PHE A 141      -1.124  29.405 164.366  1.00 18.32           N  
ATOM   1054  CA  PHE A 141       0.236  29.932 164.408  1.00 19.49           C  
ATOM   1055  C   PHE A 141       0.617  30.633 163.101  1.00 21.12           C  
ATOM   1056  O   PHE A 141       0.846  29.982 162.070  1.00 22.33           O  
ATOM   1057  CB  PHE A 141       1.240  28.808 164.703  1.00 18.09           C  
ATOM   1058  CG  PHE A 141       2.676  29.276 164.784  1.00 17.16           C  
ATOM   1059  CD1 PHE A 141       3.009  30.440 165.485  1.00 17.83           C  
ATOM   1060  CD2 PHE A 141       3.696  28.549 164.178  1.00 15.47           C  
ATOM   1061  CE1 PHE A 141       4.334  30.867 165.576  1.00 14.27           C  
ATOM   1062  CE2 PHE A 141       5.022  28.970 164.265  1.00 13.75           C  
ATOM   1063  CZ  PHE A 141       5.338  30.128 164.966  1.00 15.74           C  
ATOM   1064  N   ILE A 142       0.686  31.964 163.156  1.00 20.52           N  
ATOM   1065  CA  ILE A 142       1.046  32.774 161.996  1.00 19.60           C  
ATOM   1066  C   ILE A 142       2.555  33.043 162.019  1.00 19.66           C  
ATOM   1067  O   ILE A 142       3.083  33.665 162.947  1.00 19.83           O  
ATOM   1068  CB  ILE A 142       0.256  34.087 161.997  1.00 16.87           C  
ATOM   1069  CG1 ILE A 142      -1.229  33.760 161.912  1.00 14.94           C  
ATOM   1070  CG2 ILE A 142       0.681  34.974 160.829  1.00 17.17           C  
ATOM   1071  CD1 ILE A 142      -2.137  34.923 162.212  1.00 14.70           C  
ATOM   1072  N   ASP A 143       3.244  32.556 160.993  1.00 18.79           N  
ATOM   1073  CA  ASP A 143       4.688  32.702 160.929  1.00 19.31           C  
ATOM   1074  C   ASP A 143       5.226  32.606 159.491  1.00 19.98           C  
ATOM   1075  O   ASP A 143       6.159  31.851 159.207  1.00 19.79           O  
ATOM   1076  CB  ASP A 143       5.314  31.630 161.829  1.00 17.84           C  
ATOM   1077  CG  ASP A 143       6.800  31.803 162.004  1.00 17.21           C  
ATOM   1078  OD1 ASP A 143       7.252  32.959 162.093  1.00 18.98           O  
ATOM   1079  OD2 ASP A 143       7.513  30.781 162.067  1.00 16.48           O  
ATOM   1080  N   ALA A 144       4.635  33.389 158.594  1.00 20.30           N  
ATOM   1081  CA  ALA A 144       5.038  33.403 157.192  1.00 20.60           C  
ATOM   1082  C   ALA A 144       5.465  34.809 156.770  1.00 21.69           C  
ATOM   1083  O   ALA A 144       6.024  35.564 157.570  1.00 19.88           O  
ATOM   1084  CB  ALA A 144       3.879  32.915 156.313  1.00 20.87           C  
ATOM   1085  N   ASP A 145       5.187  35.152 155.510  1.00 22.93           N  
ATOM   1086  CA  ASP A 145       5.536  36.457 154.955  1.00 21.87           C  
ATOM   1087  C   ASP A 145       4.855  37.570 155.745  1.00 20.67           C  
ATOM   1088  O   ASP A 145       3.633  37.641 155.819  1.00 19.12           O  
ATOM   1089  CB  ASP A 145       5.177  36.513 153.460  1.00 21.49           C  
ATOM   1090  CG  ASP A 145       3.720  36.190 153.184  1.00 24.60           C  
ATOM   1091  OD1 ASP A 145       3.212  35.175 153.706  1.00 25.43           O  
ATOM   1092  OD2 ASP A 145       3.079  36.950 152.428  1.00 26.87           O  
ATOM   1093  N   LYS A 146       5.672  38.434 156.341  1.00 21.41           N  
ATOM   1094  CA  LYS A 146       5.181  39.520 157.182  1.00 20.77           C  
ATOM   1095  C   LYS A 146       4.232  40.498 156.503  1.00 22.14           C  
ATOM   1096  O   LYS A 146       3.356  41.075 157.150  1.00 22.30           O  
ATOM   1097  CB  LYS A 146       6.369  40.280 157.788  1.00 19.87           C  
ATOM   1098  CG  LYS A 146       7.491  39.383 158.330  1.00 18.15           C  
ATOM   1099  CD  LYS A 146       6.952  38.211 159.164  1.00 16.93           C  
ATOM   1100  CE  LYS A 146       8.070  37.256 159.584  1.00 13.94           C  
ATOM   1101  NZ  LYS A 146       7.564  35.919 160.029  1.00 12.41           N  
ATOM   1102  N   ARG A 147       4.402  40.687 155.201  1.00 25.18           N  
ATOM   1103  CA  ARG A 147       3.561  41.612 154.449  1.00 26.41           C  
ATOM   1104  C   ARG A 147       2.077  41.265 154.586  1.00 25.82           C  
ATOM   1105  O   ARG A 147       1.229  42.154 154.656  1.00 26.03           O  
ATOM   1106  CB  ARG A 147       3.977  41.598 152.973  1.00 28.61           C  
ATOM   1107  CG  ARG A 147       3.547  42.816 152.182  1.00 32.45           C  
ATOM   1108  CD  ARG A 147       4.567  43.142 151.094  1.00 35.69           C  
ATOM   1109  NE  ARG A 147       4.526  44.560 150.729  1.00 38.31           N  
ATOM   1110  CZ  ARG A 147       5.590  45.269 150.356  1.00 38.77           C  
ATOM   1111  NH1 ARG A 147       6.784  44.688 150.295  1.00 39.87           N  
ATOM   1112  NH2 ARG A 147       5.467  46.563 150.068  1.00 38.97           N  
ATOM   1113  N   ASN A 148       1.771  39.972 154.656  1.00 24.88           N  
ATOM   1114  CA  ASN A 148       0.389  39.509 154.761  1.00 24.38           C  
ATOM   1115  C   ASN A 148      -0.125  39.207 156.167  1.00 23.18           C  
ATOM   1116  O   ASN A 148      -1.211  38.649 156.319  1.00 22.35           O  
ATOM   1117  CB  ASN A 148       0.188  38.271 153.882  1.00 24.70           C  
ATOM   1118  CG  ASN A 148       0.201  38.597 152.407  1.00 26.01           C  
ATOM   1119  OD1 ASN A 148       0.856  37.919 151.610  1.00 28.91           O  
ATOM   1120  ND2 ASN A 148      -0.532  39.632 152.031  1.00 24.52           N  
ATOM   1121  N   TYR A 149       0.641  39.564 157.194  1.00 23.66           N  
ATOM   1122  CA  TYR A 149       0.206  39.324 158.574  1.00 23.12           C  
ATOM   1123  C   TYR A 149      -1.194  39.885 158.854  1.00 23.69           C  
ATOM   1124  O   TYR A 149      -2.036  39.203 159.436  1.00 22.23           O  
ATOM   1125  CB  TYR A 149       1.208  39.926 159.560  1.00 20.91           C  
ATOM   1126  CG  TYR A 149       2.242  38.944 160.069  1.00 19.81           C  
ATOM   1127  CD1 TYR A 149       2.713  37.905 159.258  1.00 17.36           C  
ATOM   1128  CD2 TYR A 149       2.785  39.082 161.345  1.00 17.89           C  
ATOM   1129  CE1 TYR A 149       3.702  37.029 159.710  1.00 16.13           C  
ATOM   1130  CE2 TYR A 149       3.777  38.213 161.803  1.00 16.78           C  
ATOM   1131  CZ  TYR A 149       4.229  37.192 160.985  1.00 17.52           C  
ATOM   1132  OH  TYR A 149       5.206  36.336 161.449  1.00 17.86           O  
ATOM   1133  N   PRO A 150      -1.460  41.141 158.449  1.00 25.68           N  
ATOM   1134  CA  PRO A 150      -2.789  41.699 158.700  1.00 25.35           C  
ATOM   1135  C   PRO A 150      -3.900  40.810 158.137  1.00 25.62           C  
ATOM   1136  O   PRO A 150      -4.951  40.653 158.765  1.00 26.12           O  
ATOM   1137  CB  PRO A 150      -2.730  43.056 158.000  1.00 23.76           C  
ATOM   1138  CG  PRO A 150      -1.303  43.433 158.143  1.00 25.44           C  
ATOM   1139  CD  PRO A 150      -0.589  42.147 157.811  1.00 24.92           C  
ATOM   1140  N   ARG A 151      -3.661  40.231 156.961  1.00 25.15           N  
ATOM   1141  CA  ARG A 151      -4.654  39.376 156.317  1.00 26.23           C  
ATOM   1142  C   ARG A 151      -4.795  38.051 157.052  1.00 24.88           C  
ATOM   1143  O   ARG A 151      -5.906  37.627 157.381  1.00 23.69           O  
ATOM   1144  CB  ARG A 151      -4.281  39.127 154.846  1.00 29.00           C  
ATOM   1145  CG  ARG A 151      -3.814  40.377 154.106  1.00 35.93           C  
ATOM   1146  CD  ARG A 151      -3.981  40.278 152.584  1.00 41.33           C  
ATOM   1147  NE  ARG A 151      -3.088  41.188 151.856  1.00 45.95           N  
ATOM   1148  CZ  ARG A 151      -2.917  42.484 152.127  1.00 48.78           C  
ATOM   1149  NH1 ARG A 151      -3.579  43.062 153.124  1.00 49.77           N  
ATOM   1150  NH2 ARG A 151      -2.067  43.208 151.404  1.00 48.64           N  
ATOM   1151  N   TYR A 152      -3.667  37.406 157.324  1.00 24.16           N  
ATOM   1152  CA  TYR A 152      -3.677  36.128 158.025  1.00 24.09           C  
ATOM   1153  C   TYR A 152      -4.350  36.223 159.395  1.00 23.57           C  
ATOM   1154  O   TYR A 152      -5.057  35.298 159.813  1.00 23.58           O  
ATOM   1155  CB  TYR A 152      -2.256  35.598 158.189  1.00 21.66           C  
ATOM   1156  CG  TYR A 152      -1.499  35.406 156.896  1.00 22.09           C  
ATOM   1157  CD1 TYR A 152      -2.124  34.874 155.766  1.00 20.78           C  
ATOM   1158  CD2 TYR A 152      -0.136  35.710 156.816  1.00 22.50           C  
ATOM   1159  CE1 TYR A 152      -1.411  34.646 154.587  1.00 21.02           C  
ATOM   1160  CE2 TYR A 152       0.582  35.485 155.648  1.00 24.01           C  
ATOM   1161  CZ  TYR A 152      -0.062  34.955 154.538  1.00 21.93           C  
ATOM   1162  OH  TYR A 152       0.654  34.751 153.384  1.00 21.42           O  
ATOM   1163  N   TYR A 153      -4.130  37.337 160.089  1.00 22.20           N  
ATOM   1164  CA  TYR A 153      -4.723  37.551 161.404  1.00 22.65           C  
ATOM   1165  C   TYR A 153      -6.231  37.684 161.301  1.00 23.74           C  
ATOM   1166  O   TYR A 153      -6.971  37.004 162.004  1.00 25.44           O  
ATOM   1167  CB  TYR A 153      -4.166  38.823 162.053  1.00 23.24           C  
ATOM   1168  CG  TYR A 153      -4.844  39.181 163.365  1.00 23.09           C  
ATOM   1169  CD1 TYR A 153      -4.571  38.466 164.532  1.00 21.68           C  
ATOM   1170  CD2 TYR A 153      -5.793  40.204 163.429  1.00 22.92           C  
ATOM   1171  CE1 TYR A 153      -5.226  38.755 165.721  1.00 22.46           C  
ATOM   1172  CE2 TYR A 153      -6.457  40.501 164.623  1.00 21.90           C  
ATOM   1173  CZ  TYR A 153      -6.170  39.771 165.763  1.00 21.62           C  
ATOM   1174  OH  TYR A 153      -6.824  40.041 166.947  1.00 22.38           O  
ATOM   1175  N   GLU A 154      -6.678  38.574 160.420  1.00 24.04           N  
ATOM   1176  CA  GLU A 154      -8.100  38.835 160.215  1.00 25.57           C  
ATOM   1177  C   GLU A 154      -8.880  37.596 159.756  1.00 26.83           C  
ATOM   1178  O   GLU A 154      -9.903  37.239 160.354  1.00 26.32           O  
ATOM   1179  CB  GLU A 154      -8.275  39.967 159.191  1.00 26.35           C  
ATOM   1180  CG  GLU A 154      -9.499  40.843 159.424  1.00 30.59           C  
ATOM   1181  CD  GLU A 154      -9.588  41.369 160.860  1.00 31.44           C  
ATOM   1182  OE1 GLU A 154     -10.533  40.973 161.575  1.00 32.46           O  
ATOM   1183  OE2 GLU A 154      -8.716  42.168 161.276  1.00 31.81           O  
ATOM   1184  N   ILE A 155      -8.406  36.957 158.689  1.00 25.77           N  
ATOM   1185  CA  ILE A 155      -9.054  35.765 158.156  1.00 25.04           C  
ATOM   1186  C   ILE A 155      -9.010  34.634 159.173  1.00 24.31           C  
ATOM   1187  O   ILE A 155      -9.993  33.932 159.372  1.00 23.21           O  
ATOM   1188  CB  ILE A 155      -8.368  35.286 156.861  1.00 25.21           C  
ATOM   1189  CG1 ILE A 155      -8.461  36.379 155.795  1.00 24.34           C  
ATOM   1190  CG2 ILE A 155      -9.017  33.983 156.370  1.00 25.51           C  
ATOM   1191  CD1 ILE A 155      -7.699  36.052 154.539  1.00 24.91           C  
ATOM   1192  N   GLY A 156      -7.864  34.467 159.822  1.00 25.94           N  
ATOM   1193  CA  GLY A 156      -7.724  33.408 160.807  1.00 27.12           C  
ATOM   1194  C   GLY A 156      -8.553  33.632 162.057  1.00 28.46           C  
ATOM   1195  O   GLY A 156      -8.991  32.679 162.700  1.00 28.40           O  
ATOM   1196  N   LEU A 157      -8.772  34.897 162.402  1.00 30.46           N  
ATOM   1197  CA  LEU A 157      -9.548  35.242 163.585  1.00 31.09           C  
ATOM   1198  C   LEU A 157     -10.984  34.745 163.461  1.00 31.80           C  
ATOM   1199  O   LEU A 157     -11.584  34.340 164.456  1.00 33.90           O  
ATOM   1200  CB  LEU A 157      -9.527  36.759 163.820  1.00 30.48           C  
ATOM   1201  CG  LEU A 157      -9.966  37.256 165.201  1.00 30.11           C  
ATOM   1202  CD1 LEU A 157      -9.057  36.696 166.275  1.00 28.30           C  
ATOM   1203  CD2 LEU A 157      -9.924  38.765 165.225  1.00 30.27           C  
ATOM   1204  N   ASN A 158     -11.548  34.769 162.255  1.00 31.97           N  
ATOM   1205  CA  ASN A 158     -12.916  34.280 162.108  1.00 33.87           C  
ATOM   1206  C   ASN A 158     -12.968  32.752 161.961  1.00 33.74           C  
ATOM   1207  O   ASN A 158     -14.039  32.145 162.075  1.00 34.91           O  
ATOM   1208  CB  ASN A 158     -13.658  34.985 160.953  1.00 36.54           C  
ATOM   1209  CG  ASN A 158     -12.927  34.909 159.628  1.00 38.92           C  
ATOM   1210  OD1 ASN A 158     -12.438  33.851 159.233  1.00 41.50           O  
ATOM   1211  ND2 ASN A 158     -12.876  36.039 158.915  1.00 39.96           N  
ATOM   1212  N   LEU A 159     -11.807  32.136 161.727  1.00 32.32           N  
ATOM   1213  CA  LEU A 159     -11.705  30.679 161.618  1.00 29.46           C  
ATOM   1214  C   LEU A 159     -11.253  30.103 162.974  1.00 29.58           C  
ATOM   1215  O   LEU A 159     -10.987  28.902 163.094  1.00 27.41           O  
ATOM   1216  CB  LEU A 159     -10.696  30.284 160.534  1.00 28.12           C  
ATOM   1217  CG  LEU A 159     -11.097  30.366 159.059  1.00 27.52           C  
ATOM   1218  CD1 LEU A 159      -9.876  30.090 158.184  1.00 26.34           C  
ATOM   1219  CD2 LEU A 159     -12.199  29.362 158.767  1.00 27.47           C  
ATOM   1220  N   LEU A 160     -11.166  30.974 163.983  1.00 28.68           N  
ATOM   1221  CA  LEU A 160     -10.748  30.589 165.333  1.00 27.66           C  
ATOM   1222  C   LEU A 160     -11.957  30.566 166.263  1.00 28.03           C  
ATOM   1223  O   LEU A 160     -12.799  31.467 166.223  1.00 29.20           O  
ATOM   1224  CB  LEU A 160      -9.709  31.584 165.873  1.00 27.02           C  
ATOM   1225  CG  LEU A 160      -9.009  31.291 167.208  1.00 23.43           C  
ATOM   1226  CD1 LEU A 160      -8.080  30.103 167.051  1.00 22.09           C  
ATOM   1227  CD2 LEU A 160      -8.221  32.509 167.649  1.00 19.95           C  
ATOM   1228  N   ARG A 161     -12.046  29.535 167.098  1.00 26.98           N  
ATOM   1229  CA  ARG A 161     -13.158  29.418 168.035  1.00 26.17           C  
ATOM   1230  C   ARG A 161     -13.006  30.498 169.090  1.00 27.11           C  
ATOM   1231  O   ARG A 161     -11.927  31.060 169.248  1.00 27.94           O  
ATOM   1232  CB  ARG A 161     -13.145  28.046 168.723  1.00 24.39           C  
ATOM   1233  CG  ARG A 161     -12.023  27.860 169.749  1.00 21.99           C  
ATOM   1234  CD  ARG A 161     -12.111  26.495 170.409  1.00 21.50           C  
ATOM   1235  NE  ARG A 161     -11.054  26.237 171.387  1.00 20.59           N  
ATOM   1236  CZ  ARG A 161     -11.080  26.631 172.660  1.00 22.57           C  
ATOM   1237  NH1 ARG A 161     -12.116  27.316 173.133  1.00 20.97           N  
ATOM   1238  NH2 ARG A 161     -10.079  26.315 173.476  1.00 23.74           N  
ATOM   1239  N   ARG A 162     -14.089  30.808 169.793  1.00 27.90           N  
ATOM   1240  CA  ARG A 162     -14.011  31.785 170.865  1.00 27.54           C  
ATOM   1241  C   ARG A 162     -13.300  31.041 171.980  1.00 26.82           C  
ATOM   1242  O   ARG A 162     -13.678  29.921 172.337  1.00 25.66           O  
ATOM   1243  CB  ARG A 162     -15.403  32.224 171.319  1.00 29.68           C  
ATOM   1244  CG  ARG A 162     -16.034  33.283 170.432  1.00 34.81           C  
ATOM   1245  CD  ARG A 162     -17.394  33.689 170.962  1.00 38.80           C  
ATOM   1246  NE  ARG A 162     -17.333  34.070 172.373  1.00 40.75           N  
ATOM   1247  CZ  ARG A 162     -18.393  34.405 173.105  1.00 42.78           C  
ATOM   1248  NH1 ARG A 162     -19.607  34.406 172.566  1.00 43.62           N  
ATOM   1249  NH2 ARG A 162     -18.240  34.733 174.381  1.00 41.64           N  
ATOM   1250  N   GLY A 163     -12.251  31.659 172.507  1.00 25.80           N  
ATOM   1251  CA  GLY A 163     -11.476  31.033 173.555  1.00 24.52           C  
ATOM   1252  C   GLY A 163     -10.215  30.482 172.929  1.00 23.51           C  
ATOM   1253  O   GLY A 163      -9.268  30.135 173.630  1.00 24.47           O  
ATOM   1254  N   GLY A 164     -10.210  30.404 171.598  1.00 23.52           N  
ATOM   1255  CA  GLY A 164      -9.054  29.900 170.873  1.00 20.81           C  
ATOM   1256  C   GLY A 164      -7.868  30.833 171.044  1.00 22.52           C  
ATOM   1257  O   GLY A 164      -8.023  31.961 171.525  1.00 21.77           O  
ATOM   1258  N   LEU A 165      -6.679  30.379 170.654  1.00 21.25           N  
ATOM   1259  CA  LEU A 165      -5.487  31.206 170.799  1.00 20.38           C  
ATOM   1260  C   LEU A 165      -4.738  31.456 169.498  1.00 20.08           C  
ATOM   1261  O   LEU A 165      -4.359  30.527 168.790  1.00 18.98           O  
ATOM   1262  CB  LEU A 165      -4.517  30.584 171.820  1.00 18.75           C  
ATOM   1263  CG  LEU A 165      -3.252  31.378 172.194  1.00 17.42           C  
ATOM   1264  CD1 LEU A 165      -3.594  32.580 173.058  1.00 15.87           C  
ATOM   1265  CD2 LEU A 165      -2.303  30.474 172.941  1.00 16.28           C  
ATOM   1266  N   MET A 166      -4.538  32.731 169.194  1.00 21.67           N  
ATOM   1267  CA  MET A 166      -3.781  33.131 168.015  1.00 21.80           C  
ATOM   1268  C   MET A 166      -2.347  33.366 168.514  1.00 19.52           C  
ATOM   1269  O   MET A 166      -2.149  33.958 169.575  1.00 17.81           O  
ATOM   1270  CB  MET A 166      -4.336  34.434 167.440  1.00 24.97           C  
ATOM   1271  CG  MET A 166      -3.872  34.725 166.028  1.00 29.40           C  
ATOM   1272  SD  MET A 166      -5.268  34.667 164.882  1.00 37.90           S  
ATOM   1273  CE  MET A 166      -5.955  33.103 165.298  1.00 30.99           C  
ATOM   1274  N   VAL A 167      -1.365  32.871 167.768  1.00 17.80           N  
ATOM   1275  CA  VAL A 167       0.044  33.042 168.117  1.00 18.99           C  
ATOM   1276  C   VAL A 167       0.768  33.601 166.891  1.00 19.41           C  
ATOM   1277  O   VAL A 167       0.777  32.985 165.819  1.00 18.26           O  
ATOM   1278  CB  VAL A 167       0.696  31.704 168.534  1.00 19.19           C  
ATOM   1279  CG1 VAL A 167       2.168  31.923 168.848  1.00 19.14           C  
ATOM   1280  CG2 VAL A 167      -0.020  31.131 169.752  1.00 21.36           C  
ATOM   1281  N   ILE A 168       1.358  34.783 167.049  1.00 18.83           N  
ATOM   1282  CA  ILE A 168       2.053  35.439 165.949  1.00 19.24           C  
ATOM   1283  C   ILE A 168       3.539  35.614 166.260  1.00 20.39           C  
ATOM   1284  O   ILE A 168       3.896  36.141 167.315  1.00 20.43           O  
ATOM   1285  CB  ILE A 168       1.435  36.845 165.647  1.00 17.82           C  
ATOM   1286  CG1 ILE A 168      -0.089  36.754 165.538  1.00 15.44           C  
ATOM   1287  CG2 ILE A 168       2.004  37.400 164.349  1.00 15.08           C  
ATOM   1288  CD1 ILE A 168      -0.823  37.165 166.801  1.00 17.08           C  
ATOM   1289  N   ASP A 169       4.403  35.180 165.344  1.00 20.86           N  
ATOM   1290  CA  ASP A 169       5.837  35.315 165.559  1.00 22.19           C  
ATOM   1291  C   ASP A 169       6.446  36.504 164.815  1.00 21.98           C  
ATOM   1292  O   ASP A 169       5.876  36.996 163.848  1.00 23.38           O  
ATOM   1293  CB  ASP A 169       6.560  34.032 165.152  1.00 21.63           C  
ATOM   1294  CG  ASP A 169       8.004  34.006 165.632  1.00 21.41           C  
ATOM   1295  OD1 ASP A 169       8.254  34.329 166.811  1.00 23.81           O  
ATOM   1296  OD2 ASP A 169       8.893  33.654 164.839  1.00 20.58           O  
ATOM   1297  N   ASN A 170       7.604  36.956 165.297  1.00 21.43           N  
ATOM   1298  CA  ASN A 170       8.354  38.080 164.728  1.00 20.51           C  
ATOM   1299  C   ASN A 170       7.765  39.458 164.996  1.00 20.35           C  
ATOM   1300  O   ASN A 170       7.904  40.360 164.172  1.00 19.64           O  
ATOM   1301  CB  ASN A 170       8.539  37.906 163.224  1.00 19.72           C  
ATOM   1302  CG  ASN A 170       9.264  36.631 162.875  1.00 21.85           C  
ATOM   1303  OD1 ASN A 170       8.654  35.671 162.414  1.00 24.71           O  
ATOM   1304  ND2 ASN A 170      10.568  36.605 163.103  1.00 20.19           N  
ATOM   1305  N   VAL A 171       7.132  39.636 166.157  1.00 20.93           N  
ATOM   1306  CA  VAL A 171       6.526  40.924 166.500  1.00 21.24           C  
ATOM   1307  C   VAL A 171       7.555  41.974 166.953  1.00 21.65           C  
ATOM   1308  O   VAL A 171       7.242  43.165 167.015  1.00 20.33           O  
ATOM   1309  CB  VAL A 171       5.410  40.761 167.586  1.00 20.77           C  
ATOM   1310  CG1 VAL A 171       4.309  39.838 167.060  1.00 20.05           C  
ATOM   1311  CG2 VAL A 171       5.994  40.210 168.884  1.00 20.02           C  
ATOM   1312  N   LEU A 172       8.775  41.533 167.263  1.00 21.34           N  
ATOM   1313  CA  LEU A 172       9.825  42.467 167.668  1.00 23.51           C  
ATOM   1314  C   LEU A 172      10.823  42.661 166.528  1.00 24.16           C  
ATOM   1315  O   LEU A 172      11.786  43.420 166.656  1.00 26.98           O  
ATOM   1316  CB  LEU A 172      10.539  41.980 168.934  1.00 22.56           C  
ATOM   1317  CG  LEU A 172       9.692  42.017 170.215  1.00 22.79           C  
ATOM   1318  CD1 LEU A 172      10.532  41.541 171.400  1.00 22.88           C  
ATOM   1319  CD2 LEU A 172       9.171  43.437 170.463  1.00 23.54           C  
ATOM   1320  N   TRP A 173      10.563  41.960 165.422  1.00 24.12           N  
ATOM   1321  CA  TRP A 173      11.337  42.001 164.172  1.00 22.98           C  
ATOM   1322  C   TRP A 173      12.762  42.559 164.246  1.00 24.21           C  
ATOM   1323  O   TRP A 173      13.037  43.670 163.788  1.00 22.90           O  
ATOM   1324  CB  TRP A 173      10.536  42.781 163.125  1.00 21.33           C  
ATOM   1325  CG  TRP A 173      10.988  42.597 161.707  1.00 21.48           C  
ATOM   1326  CD1 TRP A 173      11.308  43.584 160.815  1.00 21.13           C  
ATOM   1327  CD2 TRP A 173      11.133  41.355 160.998  1.00 21.91           C  
ATOM   1328  NE1 TRP A 173      11.644  43.036 159.598  1.00 20.83           N  
ATOM   1329  CE2 TRP A 173      11.546  41.671 159.681  1.00 21.38           C  
ATOM   1330  CE3 TRP A 173      10.953  40.008 161.346  1.00 19.67           C  
ATOM   1331  CZ2 TRP A 173      11.786  40.686 158.710  1.00 21.09           C  
ATOM   1332  CZ3 TRP A 173      11.193  39.027 160.376  1.00 18.46           C  
ATOM   1333  CH2 TRP A 173      11.605  39.374 159.077  1.00 21.02           C  
ATOM   1334  N   HIS A 174      13.661  41.773 164.826  1.00 25.79           N  
ATOM   1335  CA  HIS A 174      15.067  42.138 164.960  1.00 28.23           C  
ATOM   1336  C   HIS A 174      15.323  43.523 165.552  1.00 28.34           C  
ATOM   1337  O   HIS A 174      16.357  44.137 165.289  1.00 29.67           O  
ATOM   1338  CB  HIS A 174      15.752  42.009 163.598  1.00 29.41           C  
ATOM   1339  CG  HIS A 174      15.459  40.713 162.911  1.00 29.82           C  
ATOM   1340  ND1 HIS A 174      14.269  40.471 162.259  1.00 31.03           N  
ATOM   1341  CD2 HIS A 174      16.169  39.564 162.832  1.00 31.38           C  
ATOM   1342  CE1 HIS A 174      14.259  39.231 161.809  1.00 28.84           C  
ATOM   1343  NE2 HIS A 174      15.400  38.658 162.143  1.00 30.66           N  
ATOM   1344  N   GLY A 175      14.383  43.999 166.362  1.00 27.31           N  
ATOM   1345  CA  GLY A 175      14.529  45.297 166.983  1.00 25.85           C  
ATOM   1346  C   GLY A 175      14.234  46.451 166.048  1.00 25.40           C  
ATOM   1347  O   GLY A 175      14.243  47.605 166.473  1.00 25.12           O  
ATOM   1348  N   LYS A 176      13.970  46.148 164.780  1.00 25.55           N  
ATOM   1349  CA  LYS A 176      13.674  47.186 163.793  1.00 26.29           C  
ATOM   1350  C   LYS A 176      12.374  47.929 164.103  1.00 27.14           C  
ATOM   1351  O   LYS A 176      12.142  49.021 163.585  1.00 26.97           O  
ATOM   1352  CB  LYS A 176      13.571  46.585 162.390  1.00 27.68           C  
ATOM   1353  CG  LYS A 176      14.801  45.840 161.902  1.00 28.57           C  
ATOM   1354  CD  LYS A 176      14.523  45.210 160.541  1.00 31.27           C  
ATOM   1355  CE  LYS A 176      15.572  44.168 160.166  1.00 34.85           C  
ATOM   1356  NZ  LYS A 176      15.241  43.462 158.885  1.00 36.91           N  
ATOM   1357  N   VAL A 177      11.530  47.335 164.945  1.00 27.77           N  
ATOM   1358  CA  VAL A 177      10.247  47.931 165.310  1.00 26.86           C  
ATOM   1359  C   VAL A 177      10.404  49.255 166.050  1.00 28.95           C  
ATOM   1360  O   VAL A 177       9.436  50.006 166.197  1.00 29.42           O  
ATOM   1361  CB  VAL A 177       9.412  46.964 166.182  1.00 23.99           C  
ATOM   1362  CG1 VAL A 177       9.026  45.742 165.374  1.00 21.79           C  
ATOM   1363  CG2 VAL A 177      10.209  46.551 167.410  1.00 25.22           C  
ATOM   1364  N   THR A 178      11.624  49.542 166.502  1.00 30.42           N  
ATOM   1365  CA  THR A 178      11.915  50.777 167.229  1.00 31.74           C  
ATOM   1366  C   THR A 178      12.302  51.931 166.299  1.00 31.64           C  
ATOM   1367  O   THR A 178      12.377  53.084 166.726  1.00 31.01           O  
ATOM   1368  CB  THR A 178      13.035  50.542 168.286  1.00 31.42           C  
ATOM   1369  OG1 THR A 178      12.456  49.947 169.454  1.00 34.77           O  
ATOM   1370  CG2 THR A 178      13.720  51.840 168.681  1.00 33.33           C  
ATOM   1371  N   GLU A 179      12.522  51.619 165.024  1.00 31.94           N  
ATOM   1372  CA  GLU A 179      12.896  52.634 164.042  1.00 31.92           C  
ATOM   1373  C   GLU A 179      11.826  53.701 163.883  1.00 33.01           C  
ATOM   1374  O   GLU A 179      10.634  53.402 163.788  1.00 32.39           O  
ATOM   1375  CB  GLU A 179      13.189  51.981 162.696  1.00 31.61           C  
ATOM   1376  CG  GLU A 179      14.558  51.329 162.637  1.00 32.20           C  
ATOM   1377  CD  GLU A 179      14.675  50.294 161.536  1.00 32.01           C  
ATOM   1378  OE1 GLU A 179      13.955  50.409 160.516  1.00 32.55           O  
ATOM   1379  OE2 GLU A 179      15.503  49.368 161.687  1.00 32.66           O  
ATOM   1380  N   VAL A 180      12.266  54.952 163.854  1.00 34.25           N  
ATOM   1381  CA  VAL A 180      11.355  56.077 163.730  1.00 36.86           C  
ATOM   1382  C   VAL A 180      10.734  56.152 162.333  1.00 37.68           C  
ATOM   1383  O   VAL A 180       9.516  56.303 162.197  1.00 38.17           O  
ATOM   1384  CB  VAL A 180      12.079  57.395 164.100  1.00 36.91           C  
ATOM   1385  CG1 VAL A 180      11.124  58.572 164.017  1.00 35.57           C  
ATOM   1386  CG2 VAL A 180      12.633  57.281 165.514  1.00 36.15           C  
ATOM   1387  N   ASP A 181      11.554  56.044 161.295  1.00 37.81           N  
ATOM   1388  CA  ASP A 181      11.015  56.059 159.938  1.00 39.98           C  
ATOM   1389  C   ASP A 181      11.487  54.788 159.241  1.00 40.11           C  
ATOM   1390  O   ASP A 181      12.419  54.821 158.438  1.00 41.09           O  
ATOM   1391  CB  ASP A 181      11.492  57.297 159.161  1.00 41.67           C  
ATOM   1392  CG  ASP A 181      10.812  57.436 157.793  1.00 42.87           C  
ATOM   1393  OD1 ASP A 181      11.074  58.439 157.095  1.00 43.26           O  
ATOM   1394  OD2 ASP A 181      10.016  56.548 157.413  1.00 43.29           O  
ATOM   1395  N   PRO A 182      10.850  53.643 159.548  1.00 39.75           N  
ATOM   1396  CA  PRO A 182      11.247  52.378 158.925  1.00 39.05           C  
ATOM   1397  C   PRO A 182      11.100  52.422 157.410  1.00 38.17           C  
ATOM   1398  O   PRO A 182      10.067  52.847 156.881  1.00 37.20           O  
ATOM   1399  CB  PRO A 182      10.315  51.364 159.584  1.00 38.07           C  
ATOM   1400  CG  PRO A 182       9.075  52.165 159.813  1.00 38.22           C  
ATOM   1401  CD  PRO A 182       9.630  53.463 160.356  1.00 39.43           C  
ATOM   1402  N   GLN A 183      12.151  51.989 156.721  1.00 37.81           N  
ATOM   1403  CA  GLN A 183      12.149  51.974 155.269  1.00 37.55           C  
ATOM   1404  C   GLN A 183      11.810  50.592 154.723  1.00 36.08           C  
ATOM   1405  O   GLN A 183      11.308  50.472 153.607  1.00 35.54           O  
ATOM   1406  CB  GLN A 183      13.505  52.446 154.734  1.00 39.58           C  
ATOM   1407  CG  GLN A 183      13.788  53.932 154.986  1.00 40.77           C  
ATOM   1408  CD  GLN A 183      12.669  54.844 154.485  1.00 40.93           C  
ATOM   1409  OE1 GLN A 183      12.325  54.837 153.301  1.00 42.82           O  
ATOM   1410  NE2 GLN A 183      12.100  55.634 155.392  1.00 40.10           N  
ATOM   1411  N   GLU A 184      12.075  49.552 155.511  1.00 34.48           N  
ATOM   1412  CA  GLU A 184      11.771  48.187 155.091  1.00 32.16           C  
ATOM   1413  C   GLU A 184      10.273  47.903 155.229  1.00 30.33           C  
ATOM   1414  O   GLU A 184       9.659  48.250 156.241  1.00 29.23           O  
ATOM   1415  CB  GLU A 184      12.556  47.177 155.926  1.00 34.30           C  
ATOM   1416  CG  GLU A 184      12.253  45.743 155.532  1.00 36.12           C  
ATOM   1417  CD  GLU A 184      12.756  44.741 156.540  1.00 36.84           C  
ATOM   1418  OE1 GLU A 184      13.989  44.563 156.645  1.00 40.05           O  
ATOM   1419  OE2 GLU A 184      11.912  44.135 157.232  1.00 37.67           O  
ATOM   1420  N   ALA A 185       9.699  47.258 154.214  1.00 27.88           N  
ATOM   1421  CA  ALA A 185       8.274  46.936 154.193  1.00 28.19           C  
ATOM   1422  C   ALA A 185       7.776  46.099 155.380  1.00 27.80           C  
ATOM   1423  O   ALA A 185       6.763  46.436 155.992  1.00 28.76           O  
ATOM   1424  CB  ALA A 185       7.930  46.237 152.884  1.00 26.83           C  
ATOM   1425  N   GLN A 186       8.476  45.011 155.698  1.00 28.44           N  
ATOM   1426  CA  GLN A 186       8.088  44.140 156.809  1.00 27.44           C  
ATOM   1427  C   GLN A 186       8.073  44.880 158.143  1.00 26.57           C  
ATOM   1428  O   GLN A 186       7.253  44.579 159.008  1.00 26.65           O  
ATOM   1429  CB  GLN A 186       9.025  42.934 156.925  1.00 28.83           C  
ATOM   1430  CG  GLN A 186       9.067  42.034 155.716  1.00 32.32           C  
ATOM   1431  CD  GLN A 186       9.845  42.643 154.573  1.00 34.09           C  
ATOM   1432  OE1 GLN A 186      11.034  42.928 154.701  1.00 35.60           O  
ATOM   1433  NE2 GLN A 186       9.176  42.850 153.446  1.00 33.43           N  
ATOM   1434  N   THR A 187       8.986  45.834 158.319  1.00 26.26           N  
ATOM   1435  CA  THR A 187       9.039  46.607 159.561  1.00 25.90           C  
ATOM   1436  C   THR A 187       7.815  47.510 159.666  1.00 26.18           C  
ATOM   1437  O   THR A 187       7.222  47.640 160.735  1.00 27.15           O  
ATOM   1438  CB  THR A 187      10.290  47.510 159.635  1.00 25.24           C  
ATOM   1439  OG1 THR A 187      11.470  46.717 159.495  1.00 25.59           O  
ATOM   1440  CG2 THR A 187      10.341  48.228 160.981  1.00 25.78           C  
ATOM   1441  N   GLN A 188       7.450  48.134 158.549  1.00 27.19           N  
ATOM   1442  CA  GLN A 188       6.301  49.030 158.500  1.00 27.03           C  
ATOM   1443  C   GLN A 188       5.010  48.260 158.740  1.00 26.50           C  
ATOM   1444  O   GLN A 188       4.130  48.710 159.480  1.00 25.51           O  
ATOM   1445  CB  GLN A 188       6.244  49.731 157.138  1.00 29.05           C  
ATOM   1446  CG  GLN A 188       7.440  50.622 156.849  1.00 30.71           C  
ATOM   1447  CD  GLN A 188       7.535  51.027 155.390  1.00 32.91           C  
ATOM   1448  OE1 GLN A 188       8.421  51.791 155.005  1.00 33.76           O  
ATOM   1449  NE2 GLN A 188       6.624  50.510 154.567  1.00 33.20           N  
ATOM   1450  N   VAL A 189       4.902  47.097 158.109  1.00 25.79           N  
ATOM   1451  CA  VAL A 189       3.716  46.267 158.258  1.00 24.96           C  
ATOM   1452  C   VAL A 189       3.600  45.720 159.678  1.00 25.04           C  
ATOM   1453  O   VAL A 189       2.503  45.630 160.227  1.00 24.91           O  
ATOM   1454  CB  VAL A 189       3.734  45.093 157.261  1.00 24.91           C  
ATOM   1455  CG1 VAL A 189       2.480  44.238 157.429  1.00 24.34           C  
ATOM   1456  CG2 VAL A 189       3.826  45.632 155.845  1.00 24.31           C  
ATOM   1457  N   LEU A 190       4.730  45.359 160.277  1.00 23.31           N  
ATOM   1458  CA  LEU A 190       4.708  44.823 161.627  1.00 24.63           C  
ATOM   1459  C   LEU A 190       4.415  45.911 162.661  1.00 25.01           C  
ATOM   1460  O   LEU A 190       3.746  45.659 163.667  1.00 22.82           O  
ATOM   1461  CB  LEU A 190       6.033  44.106 161.928  1.00 24.31           C  
ATOM   1462  CG  LEU A 190       6.201  42.817 161.106  1.00 26.02           C  
ATOM   1463  CD1 LEU A 190       7.601  42.238 161.247  1.00 25.85           C  
ATOM   1464  CD2 LEU A 190       5.146  41.814 161.565  1.00 27.22           C  
ATOM   1465  N   GLN A 191       4.895  47.125 162.402  1.00 25.62           N  
ATOM   1466  CA  GLN A 191       4.652  48.235 163.313  1.00 26.38           C  
ATOM   1467  C   GLN A 191       3.163  48.537 163.393  1.00 26.09           C  
ATOM   1468  O   GLN A 191       2.607  48.726 164.482  1.00 25.75           O  
ATOM   1469  CB  GLN A 191       5.399  49.487 162.851  1.00 28.03           C  
ATOM   1470  CG  GLN A 191       6.858  49.510 163.246  1.00 29.59           C  
ATOM   1471  CD  GLN A 191       7.533  50.814 162.880  1.00 32.26           C  
ATOM   1472  OE1 GLN A 191       8.582  51.152 163.431  1.00 33.62           O  
ATOM   1473  NE2 GLN A 191       6.941  51.553 161.945  1.00 31.86           N  
ATOM   1474  N   GLN A 192       2.515  48.579 162.234  1.00 25.16           N  
ATOM   1475  CA  GLN A 192       1.091  48.865 162.193  1.00 24.23           C  
ATOM   1476  C   GLN A 192       0.312  47.695 162.780  1.00 21.88           C  
ATOM   1477  O   GLN A 192      -0.673  47.891 163.481  1.00 20.05           O  
ATOM   1478  CB  GLN A 192       0.633  49.125 160.753  1.00 26.52           C  
ATOM   1479  CG  GLN A 192      -0.736  49.782 160.667  1.00 28.88           C  
ATOM   1480  CD  GLN A 192      -0.760  51.157 161.324  1.00 31.76           C  
ATOM   1481  OE1 GLN A 192      -0.098  52.089 160.865  1.00 35.69           O  
ATOM   1482  NE2 GLN A 192      -1.520  51.286 162.406  1.00 31.66           N  
ATOM   1483  N   PHE A 193       0.765  46.481 162.492  1.00 21.23           N  
ATOM   1484  CA  PHE A 193       0.115  45.271 162.995  1.00 22.55           C  
ATOM   1485  C   PHE A 193       0.084  45.242 164.522  1.00 21.51           C  
ATOM   1486  O   PHE A 193      -0.947  44.932 165.120  1.00 19.57           O  
ATOM   1487  CB  PHE A 193       0.846  44.022 162.493  1.00 23.59           C  
ATOM   1488  CG  PHE A 193       0.257  42.732 162.999  1.00 24.86           C  
ATOM   1489  CD1 PHE A 193      -0.834  42.145 162.351  1.00 25.84           C  
ATOM   1490  CD2 PHE A 193       0.762  42.125 164.146  1.00 22.86           C  
ATOM   1491  CE1 PHE A 193      -1.411  40.968 162.845  1.00 24.85           C  
ATOM   1492  CE2 PHE A 193       0.193  40.954 164.647  1.00 22.52           C  
ATOM   1493  CZ  PHE A 193      -0.896  40.374 163.996  1.00 24.24           C  
ATOM   1494  N   ASN A 194       1.220  45.549 165.147  1.00 21.44           N  
ATOM   1495  CA  ASN A 194       1.303  45.555 166.606  1.00 22.99           C  
ATOM   1496  C   ASN A 194       0.454  46.662 167.230  1.00 23.27           C  
ATOM   1497  O   ASN A 194      -0.166  46.465 168.271  1.00 22.76           O  
ATOM   1498  CB  ASN A 194       2.753  45.717 167.077  1.00 20.78           C  
ATOM   1499  CG  ASN A 194       3.629  44.534 166.706  1.00 20.55           C  
ATOM   1500  OD1 ASN A 194       3.142  43.410 166.536  1.00 18.89           O  
ATOM   1501  ND2 ASN A 194       4.934  44.777 166.597  1.00 19.41           N  
ATOM   1502  N   ARG A 195       0.435  47.827 166.593  1.00 25.20           N  
ATOM   1503  CA  ARG A 195      -0.341  48.955 167.094  1.00 26.42           C  
ATOM   1504  C   ARG A 195      -1.837  48.646 167.015  1.00 25.02           C  
ATOM   1505  O   ARG A 195      -2.607  48.994 167.910  1.00 24.48           O  
ATOM   1506  CB  ARG A 195      -0.034  50.205 166.271  1.00 30.77           C  
ATOM   1507  CG  ARG A 195      -0.451  51.503 166.937  1.00 36.57           C  
ATOM   1508  CD  ARG A 195      -0.950  52.494 165.913  1.00 43.26           C  
ATOM   1509  NE  ARG A 195      -2.183  52.022 165.282  1.00 49.41           N  
ATOM   1510  CZ  ARG A 195      -3.321  51.793 165.938  1.00 51.85           C  
ATOM   1511  NH1 ARG A 195      -3.386  51.994 167.248  1.00 54.05           N  
ATOM   1512  NH2 ARG A 195      -4.394  51.357 165.287  1.00 50.90           N  
ATOM   1513  N   ASP A 196      -2.238  47.999 165.926  1.00 24.59           N  
ATOM   1514  CA  ASP A 196      -3.631  47.636 165.709  1.00 24.15           C  
ATOM   1515  C   ASP A 196      -4.090  46.559 166.675  1.00 23.83           C  
ATOM   1516  O   ASP A 196      -5.215  46.596 167.170  1.00 23.32           O  
ATOM   1517  CB  ASP A 196      -3.847  47.130 164.275  1.00 24.45           C  
ATOM   1518  CG  ASP A 196      -3.825  48.244 163.252  1.00 21.61           C  
ATOM   1519  OD1 ASP A 196      -3.973  49.415 163.646  1.00 22.19           O  
ATOM   1520  OD2 ASP A 196      -3.676  47.948 162.052  1.00 22.17           O  
ATOM   1521  N   LEU A 197      -3.214  45.595 166.931  1.00 24.72           N  
ATOM   1522  CA  LEU A 197      -3.539  44.491 167.822  1.00 25.18           C  
ATOM   1523  C   LEU A 197      -3.580  44.911 169.290  1.00 26.59           C  
ATOM   1524  O   LEU A 197      -4.289  44.299 170.089  1.00 26.01           O  
ATOM   1525  CB  LEU A 197      -2.533  43.351 167.626  1.00 24.26           C  
ATOM   1526  CG  LEU A 197      -2.899  41.997 168.233  1.00 21.40           C  
ATOM   1527  CD1 LEU A 197      -4.192  41.509 167.629  1.00 19.07           C  
ATOM   1528  CD2 LEU A 197      -1.788  41.007 167.984  1.00 21.91           C  
ATOM   1529  N   ALA A 198      -2.823  45.955 169.637  1.00 28.32           N  
ATOM   1530  CA  ALA A 198      -2.771  46.462 171.012  1.00 30.54           C  
ATOM   1531  C   ALA A 198      -4.107  47.050 171.467  1.00 31.68           C  
ATOM   1532  O   ALA A 198      -4.353  47.200 172.662  1.00 32.39           O  
ATOM   1533  CB  ALA A 198      -1.667  47.508 171.152  1.00 27.95           C  
ATOM   1534  N   GLN A 199      -4.964  47.397 170.514  1.00 33.96           N  
ATOM   1535  CA  GLN A 199      -6.276  47.931 170.848  1.00 37.18           C  
ATOM   1536  C   GLN A 199      -7.406  47.184 170.135  1.00 36.56           C  
ATOM   1537  O   GLN A 199      -8.489  47.737 169.903  1.00 35.25           O  
ATOM   1538  CB  GLN A 199      -6.337  49.426 170.538  1.00 40.17           C  
ATOM   1539  CG  GLN A 199      -5.547  49.838 169.332  1.00 45.81           C  
ATOM   1540  CD  GLN A 199      -5.630  51.322 169.104  1.00 49.78           C  
ATOM   1541  OE1 GLN A 199      -5.414  52.110 170.024  1.00 53.87           O  
ATOM   1542  NE2 GLN A 199      -5.945  51.718 167.874  1.00 51.66           N  
ATOM   1543  N   ASP A 200      -7.135  45.924 169.795  1.00 35.32           N  
ATOM   1544  CA  ASP A 200      -8.110  45.048 169.147  1.00 34.07           C  
ATOM   1545  C   ASP A 200      -8.911  44.478 170.308  1.00 33.73           C  
ATOM   1546  O   ASP A 200      -8.420  43.615 171.036  1.00 33.34           O  
ATOM   1547  CB  ASP A 200      -7.404  43.908 168.415  1.00 32.54           C  
ATOM   1548  CG  ASP A 200      -8.343  43.114 167.539  1.00 30.94           C  
ATOM   1549  OD1 ASP A 200      -9.556  43.107 167.835  1.00 29.78           O  
ATOM   1550  OD2 ASP A 200      -7.870  42.494 166.564  1.00 30.36           O  
ATOM   1551  N   GLU A 201     -10.140  44.956 170.482  1.00 33.46           N  
ATOM   1552  CA  GLU A 201     -10.964  44.514 171.597  1.00 32.99           C  
ATOM   1553  C   GLU A 201     -11.634  43.159 171.430  1.00 30.63           C  
ATOM   1554  O   GLU A 201     -12.470  42.770 172.242  1.00 30.06           O  
ATOM   1555  CB  GLU A 201     -11.999  45.599 171.933  1.00 35.18           C  
ATOM   1556  CG  GLU A 201     -11.351  46.968 172.151  1.00 40.42           C  
ATOM   1557  CD  GLU A 201     -12.308  48.025 172.693  1.00 44.76           C  
ATOM   1558  OE1 GLU A 201     -13.489  48.035 172.275  1.00 47.13           O  
ATOM   1559  OE2 GLU A 201     -11.870  48.855 173.527  1.00 43.77           O  
ATOM   1560  N   ARG A 202     -11.256  42.430 170.388  1.00 29.45           N  
ATOM   1561  CA  ARG A 202     -11.808  41.100 170.155  1.00 29.02           C  
ATOM   1562  C   ARG A 202     -10.882  40.065 170.795  1.00 27.84           C  
ATOM   1563  O   ARG A 202     -11.248  38.902 170.950  1.00 27.60           O  
ATOM   1564  CB  ARG A 202     -11.895  40.809 168.661  1.00 29.44           C  
ATOM   1565  CG  ARG A 202     -12.759  41.753 167.872  1.00 29.60           C  
ATOM   1566  CD  ARG A 202     -12.547  41.521 166.386  1.00 28.37           C  
ATOM   1567  NE  ARG A 202     -11.206  41.915 165.956  1.00 27.23           N  
ATOM   1568  CZ  ARG A 202     -10.794  41.883 164.694  1.00 28.76           C  
ATOM   1569  NH1 ARG A 202     -11.618  41.469 163.739  1.00 29.34           N  
ATOM   1570  NH2 ARG A 202      -9.568  42.280 164.379  1.00 29.37           N  
ATOM   1571  N   VAL A 203      -9.680  40.505 171.160  1.00 27.34           N  
ATOM   1572  CA  VAL A 203      -8.672  39.631 171.761  1.00 24.62           C  
ATOM   1573  C   VAL A 203      -7.995  40.212 173.010  1.00 22.76           C  
ATOM   1574  O   VAL A 203      -7.942  41.429 173.206  1.00 20.69           O  
ATOM   1575  CB  VAL A 203      -7.550  39.304 170.730  1.00 24.32           C  
ATOM   1576  CG1 VAL A 203      -8.125  38.567 169.537  1.00 24.01           C  
ATOM   1577  CG2 VAL A 203      -6.887  40.594 170.263  1.00 23.08           C  
ATOM   1578  N   ARG A 204      -7.488  39.319 173.853  1.00 21.76           N  
ATOM   1579  CA  ARG A 204      -6.753  39.695 175.059  1.00 21.43           C  
ATOM   1580  C   ARG A 204      -5.327  39.224 174.747  1.00 20.71           C  
ATOM   1581  O   ARG A 204      -5.077  38.020 174.623  1.00 17.51           O  
ATOM   1582  CB  ARG A 204      -7.312  38.959 176.272  1.00 21.28           C  
ATOM   1583  CG  ARG A 204      -8.690  39.438 176.718  1.00 23.66           C  
ATOM   1584  CD  ARG A 204      -9.265  38.500 177.779  1.00 24.23           C  
ATOM   1585  NE  ARG A 204      -8.295  38.210 178.839  1.00 23.03           N  
ATOM   1586  CZ  ARG A 204      -8.222  37.052 179.490  1.00 22.68           C  
ATOM   1587  NH1 ARG A 204      -9.061  36.070 179.198  1.00 22.98           N  
ATOM   1588  NH2 ARG A 204      -7.297  36.868 180.423  1.00 22.34           N  
ATOM   1589  N   ILE A 205      -4.398  40.167 174.604  1.00 20.89           N  
ATOM   1590  CA  ILE A 205      -3.034  39.802 174.226  1.00 21.43           C  
ATOM   1591  C   ILE A 205      -1.923  39.844 175.275  1.00 22.08           C  
ATOM   1592  O   ILE A 205      -2.078  40.378 176.376  1.00 23.27           O  
ATOM   1593  CB  ILE A 205      -2.548  40.629 172.986  1.00 20.00           C  
ATOM   1594  CG1 ILE A 205      -2.171  42.054 173.395  1.00 17.79           C  
ATOM   1595  CG2 ILE A 205      -3.638  40.661 171.913  1.00 20.77           C  
ATOM   1596  CD1 ILE A 205      -1.428  42.800 172.315  1.00 14.03           C  
ATOM   1597  N   SER A 206      -0.792  39.262 174.889  1.00 21.45           N  
ATOM   1598  CA  SER A 206       0.401  39.189 175.715  1.00 22.14           C  
ATOM   1599  C   SER A 206       1.599  39.085 174.764  1.00 21.67           C  
ATOM   1600  O   SER A 206       1.690  38.147 173.972  1.00 21.25           O  
ATOM   1601  CB  SER A 206       0.323  37.958 176.624  1.00 22.93           C  
ATOM   1602  OG  SER A 206       1.377  37.926 177.573  1.00 27.68           O  
ATOM   1603  N   VAL A 207       2.495  40.069 174.808  1.00 22.69           N  
ATOM   1604  CA  VAL A 207       3.683  40.040 173.952  1.00 22.24           C  
ATOM   1605  C   VAL A 207       4.798  39.361 174.751  1.00 23.12           C  
ATOM   1606  O   VAL A 207       5.243  39.883 175.773  1.00 23.24           O  
ATOM   1607  CB  VAL A 207       4.136  41.466 173.537  1.00 21.96           C  
ATOM   1608  CG1 VAL A 207       5.268  41.375 172.528  1.00 20.20           C  
ATOM   1609  CG2 VAL A 207       2.972  42.243 172.947  1.00 18.50           C  
ATOM   1610  N   ILE A 208       5.233  38.194 174.274  1.00 24.01           N  
ATOM   1611  CA  ILE A 208       6.271  37.380 174.919  1.00 24.11           C  
ATOM   1612  C   ILE A 208       7.648  37.476 174.231  1.00 24.51           C  
ATOM   1613  O   ILE A 208       7.765  37.217 173.037  1.00 25.63           O  
ATOM   1614  CB  ILE A 208       5.848  35.881 174.926  1.00 24.00           C  
ATOM   1615  CG1 ILE A 208       4.411  35.740 175.452  1.00 22.62           C  
ATOM   1616  CG2 ILE A 208       6.847  35.057 175.730  1.00 22.03           C  
ATOM   1617  CD1 ILE A 208       4.185  36.360 176.818  1.00 24.02           C  
ATOM   1618  N   PRO A 209       8.708  37.845 174.980  1.00 24.35           N  
ATOM   1619  CA  PRO A 209      10.042  37.944 174.363  1.00 24.03           C  
ATOM   1620  C   PRO A 209      10.794  36.614 174.249  1.00 23.55           C  
ATOM   1621  O   PRO A 209      11.720  36.361 175.015  1.00 24.95           O  
ATOM   1622  CB  PRO A 209      10.796  38.926 175.275  1.00 23.37           C  
ATOM   1623  CG  PRO A 209       9.710  39.663 176.006  1.00 25.19           C  
ATOM   1624  CD  PRO A 209       8.681  38.576 176.257  1.00 24.90           C  
ATOM   1625  N   LEU A 210      10.376  35.761 173.319  1.00 23.25           N  
ATOM   1626  CA  LEU A 210      11.052  34.484 173.068  1.00 22.55           C  
ATOM   1627  C   LEU A 210      11.330  34.486 171.575  1.00 21.92           C  
ATOM   1628  O   LEU A 210      10.461  34.856 170.787  1.00 21.29           O  
ATOM   1629  CB  LEU A 210      10.176  33.276 173.428  1.00 21.61           C  
ATOM   1630  CG  LEU A 210      10.112  32.803 174.885  1.00 20.96           C  
ATOM   1631  CD1 LEU A 210       9.384  31.468 174.931  1.00 21.57           C  
ATOM   1632  CD2 LEU A 210      11.517  32.645 175.468  1.00 20.40           C  
ATOM   1633  N   GLY A 211      12.536  34.089 171.184  1.00 22.68           N  
ATOM   1634  CA  GLY A 211      12.876  34.106 169.773  1.00 22.71           C  
ATOM   1635  C   GLY A 211      12.810  35.549 169.303  1.00 21.93           C  
ATOM   1636  O   GLY A 211      13.304  36.433 169.995  1.00 20.83           O  
ATOM   1637  N   ASP A 212      12.178  35.796 168.156  1.00 21.28           N  
ATOM   1638  CA  ASP A 212      12.061  37.152 167.623  1.00 20.78           C  
ATOM   1639  C   ASP A 212      10.777  37.856 168.065  1.00 20.99           C  
ATOM   1640  O   ASP A 212      10.250  38.720 167.354  1.00 21.47           O  
ATOM   1641  CB  ASP A 212      12.137  37.122 166.090  1.00 20.22           C  
ATOM   1642  CG  ASP A 212      12.229  38.509 165.487  1.00 19.29           C  
ATOM   1643  OD1 ASP A 212      12.984  39.341 166.028  1.00 20.73           O  
ATOM   1644  OD2 ASP A 212      11.562  38.768 164.470  1.00 20.23           O  
ATOM   1645  N   GLY A 213      10.281  37.484 169.244  1.00 22.03           N  
ATOM   1646  CA  GLY A 213       9.072  38.088 169.776  1.00 20.02           C  
ATOM   1647  C   GLY A 213       7.818  37.416 169.257  1.00 20.00           C  
ATOM   1648  O   GLY A 213       7.636  37.273 168.052  1.00 19.76           O  
ATOM   1649  N   MET A 214       6.948  36.989 170.166  1.00 19.89           N  
ATOM   1650  CA  MET A 214       5.715  36.337 169.764  1.00 20.91           C  
ATOM   1651  C   MET A 214       4.558  36.847 170.601  1.00 21.90           C  
ATOM   1652  O   MET A 214       4.669  36.996 171.816  1.00 22.55           O  
ATOM   1653  CB  MET A 214       5.846  34.808 169.886  1.00 23.10           C  
ATOM   1654  CG  MET A 214       6.023  34.261 171.303  1.00 23.07           C  
ATOM   1655  SD  MET A 214       6.742  32.582 171.345  1.00 23.86           S  
ATOM   1656  CE  MET A 214       5.478  31.619 170.542  1.00 20.50           C  
ATOM   1657  N   THR A 215       3.446  37.127 169.934  1.00 21.62           N  
ATOM   1658  CA  THR A 215       2.260  37.626 170.606  1.00 21.29           C  
ATOM   1659  C   THR A 215       1.161  36.568 170.709  1.00 21.92           C  
ATOM   1660  O   THR A 215       0.874  35.841 169.748  1.00 19.78           O  
ATOM   1661  CB  THR A 215       1.701  38.880 169.884  1.00 19.98           C  
ATOM   1662  OG1 THR A 215       2.624  39.963 170.039  1.00 18.80           O  
ATOM   1663  CG2 THR A 215       0.351  39.290 170.464  1.00 19.75           C  
ATOM   1664  N   LEU A 216       0.570  36.481 171.898  1.00 21.46           N  
ATOM   1665  CA  LEU A 216      -0.520  35.555 172.147  1.00 20.97           C  
ATOM   1666  C   LEU A 216      -1.806  36.368 172.196  1.00 20.13           C  
ATOM   1667  O   LEU A 216      -1.948  37.278 173.008  1.00 17.69           O  
ATOM   1668  CB  LEU A 216      -0.323  34.817 173.474  1.00 21.09           C  
ATOM   1669  CG  LEU A 216       1.011  34.102 173.700  1.00 24.08           C  
ATOM   1670  CD1 LEU A 216       0.854  33.155 174.879  1.00 23.80           C  
ATOM   1671  CD2 LEU A 216       1.435  33.326 172.457  1.00 24.30           C  
ATOM   1672  N   ALA A 217      -2.735  36.050 171.303  1.00 22.30           N  
ATOM   1673  CA  ALA A 217      -4.007  36.744 171.257  1.00 22.80           C  
ATOM   1674  C   ALA A 217      -5.139  35.747 171.499  1.00 23.35           C  
ATOM   1675  O   ALA A 217      -5.468  34.928 170.637  1.00 22.05           O  
ATOM   1676  CB  ALA A 217      -4.176  37.442 169.906  1.00 24.20           C  
ATOM   1677  N   LEU A 218      -5.710  35.820 172.697  1.00 24.83           N  
ATOM   1678  CA  LEU A 218      -6.816  34.957 173.108  1.00 25.64           C  
ATOM   1679  C   LEU A 218      -8.139  35.586 172.646  1.00 25.24           C  
ATOM   1680  O   LEU A 218      -8.463  36.708 173.040  1.00 24.31           O  
ATOM   1681  CB  LEU A 218      -6.788  34.811 174.637  1.00 26.63           C  
ATOM   1682  CG  LEU A 218      -7.794  33.949 175.407  1.00 28.18           C  
ATOM   1683  CD1 LEU A 218      -9.145  34.617 175.413  1.00 29.64           C  
ATOM   1684  CD2 LEU A 218      -7.870  32.567 174.793  1.00 30.65           C  
ATOM   1685  N   LYS A 219      -8.885  34.864 171.809  1.00 24.14           N  
ATOM   1686  CA  LYS A 219     -10.163  35.346 171.283  1.00 24.57           C  
ATOM   1687  C   LYS A 219     -11.275  35.332 172.331  1.00 25.45           C  
ATOM   1688  O   LYS A 219     -11.550  34.301 172.945  1.00 25.64           O  
ATOM   1689  CB  LYS A 219     -10.593  34.502 170.076  1.00 22.53           C  
ATOM   1690  CG  LYS A 219     -11.947  34.893 169.504  1.00 20.10           C  
ATOM   1691  CD  LYS A 219     -12.283  34.112 168.247  1.00 20.99           C  
ATOM   1692  CE  LYS A 219     -13.572  34.625 167.604  1.00 21.62           C  
ATOM   1693  NZ  LYS A 219     -13.876  33.945 166.312  1.00 23.93           N  
ATOM   1694  N   LYS A 220     -11.913  36.480 172.532  1.00 25.73           N  
ATOM   1695  CA  LYS A 220     -12.990  36.584 173.511  1.00 28.49           C  
ATOM   1696  C   LYS A 220     -14.255  35.859 173.049  1.00 29.45           C  
ATOM   1697  O   LYS A 220     -14.945  35.281 173.887  1.00 30.98           O  
ATOM   1698  CB  LYS A 220     -13.315  38.052 173.787  1.00 28.88           C  
ATOM   1699  CG  LYS A 220     -12.170  38.857 174.386  1.00 29.31           C  
ATOM   1700  CD  LYS A 220     -12.614  40.294 174.592  1.00 29.99           C  
ATOM   1701  CE  LYS A 220     -11.503  41.177 175.130  1.00 30.36           C  
ATOM   1702  NZ  LYS A 220     -11.938  42.607 175.200  1.00 30.42           N  
ATOM   1703  OXT LYS A 220     -14.542  35.876 171.853  1.00 30.98           O  
TER    1704      LYS A 220                                                      
END
MOLECULE T0509.pdb
ATOM      1  N   ASN     3      22.807  39.978 177.332  1.00 85.83           N  
ATOM      2  CA  ASN     3      23.661  39.212 178.288  1.00 85.41           C  
ATOM      3  C   ASN     3      22.931  38.088 179.010  1.00 84.96           C  
ATOM      4  O   ASN     3      23.158  36.907 178.737  1.00 84.71           O  
ATOM      5  CB  ASN     3      24.283  40.169 179.320  1.00 85.60           C  
ATOM      6  N   ALA     4      22.046  38.464 179.926  1.00 84.06           N  
ATOM      7  CA  ALA     4      21.329  37.491 180.736  1.00 83.06           C  
ATOM      8  C   ALA     4      20.380  36.562 180.006  1.00 82.36           C  
ATOM      9  O   ALA     4      20.103  35.452 180.462  1.00 82.26           O  
ATOM     10  CB  ALA     4      20.607  38.203 181.891  1.00 82.85           C  
ATOM     11  N   PHE     5      19.905  37.014 178.857  1.00 81.23           N  
ATOM     12  CA  PHE     5      19.008  36.219 178.041  1.00 79.90           C  
ATOM     13  C   PHE     5      19.689  34.923 177.583  1.00 78.36           C  
ATOM     14  O   PHE     5      19.070  33.859 177.581  1.00 77.95           O  
ATOM     15  CB  PHE     5      18.590  37.011 176.806  1.00 80.49           C  
ATOM     16  CG  PHE     5      17.733  36.228 175.838  1.00 82.32           C  
ATOM     17  CD1 PHE     5      16.356  36.140 176.022  1.00 83.80           C  
ATOM     18  CD2 PHE     5      18.306  35.556 174.759  1.00 83.29           C  
ATOM     19  CE1 PHE     5      15.564  35.398 175.148  1.00 85.48           C  
ATOM     20  CE2 PHE     5      17.522  34.810 173.883  1.00 84.01           C  
ATOM     21  CZ  PHE     5      16.149  34.731 174.079  1.00 84.46           C  
ATOM     22  N   GLU     6      20.960  35.016 177.195  1.00 77.13           N  
ATOM     23  CA  GLU     6      21.696  33.867 176.675  1.00 75.49           C  
ATOM     24  C   GLU     6      22.150  32.844 177.700  1.00 73.34           C  
ATOM     25  O   GLU     6      22.237  31.656 177.384  1.00 73.19           O  
ATOM     26  CB  GLU     6      22.890  34.355 175.852  1.00 76.28           C  
ATOM     27  CG  GLU     6      22.530  35.380 174.776  1.00 80.27           C  
ATOM     28  CD  GLU     6      23.464  36.574 174.805  1.00 85.77           C  
ATOM     29  OE1 GLU     6      23.350  37.389 175.746  1.00 88.31           O  
ATOM     30  OE2 GLU     6      24.317  36.691 173.899  1.00 86.53           O  
ATOM     31  N   TYR     7      22.433  33.303 178.915  1.00 71.13           N  
ATOM     32  CA  TYR     7      22.835  32.402 179.977  1.00 68.99           C  
ATOM     33  C   TYR     7      21.579  31.589 180.326  1.00 65.55           C  
ATOM     34  O   TYR     7      21.657  30.395 180.624  1.00 65.44           O  
ATOM     35  CB  TYR     7      23.336  33.190 181.196  1.00 70.74           C  
ATOM     36  CG  TYR     7      24.578  32.584 181.806  1.00 76.24           C  
ATOM     37  CD1 TYR     7      25.455  33.360 182.555  1.00 82.00           C  
ATOM     38  CD2 TYR     7      24.886  31.230 181.618  1.00 81.17           C  
ATOM     39  CE1 TYR     7      26.612  32.812 183.107  1.00 85.04           C  
ATOM     40  CE2 TYR     7      26.039  30.671 182.169  1.00 84.74           C  
ATOM     41  CZ  TYR     7      26.897  31.469 182.910  1.00 86.92           C  
ATOM     42  OH  TYR     7      28.037  30.923 183.455  1.00 89.05           O  
ATOM     43  N   LEU     8      20.416  32.239 180.292  1.00 61.60           N  
ATOM     44  CA  LEU     8      19.157  31.545 180.549  1.00 57.37           C  
ATOM     45  C   LEU     8      18.973  30.589 179.350  1.00 54.56           C  
ATOM     46  O   LEU     8      18.710  29.399 179.527  1.00 52.14           O  
ATOM     47  CB  LEU     8      17.989  32.541 180.606  1.00 57.65           C  
ATOM     48  CG  LEU     8      16.729  32.079 181.345  1.00 56.45           C  
ATOM     49  CD1 LEU     8      17.110  31.130 182.479  1.00 55.09           C  
ATOM     50  CD2 LEU     8      15.999  33.299 181.898  1.00 57.98           C  
ATOM     51  N   ARG     9      19.120  31.107 178.129  1.00 52.49           N  
ATOM     52  CA  ARG     9      18.958  30.280 176.932  1.00 52.08           C  
ATOM     53  C   ARG     9      19.926  29.104 176.942  1.00 51.11           C  
ATOM     54  O   ARG     9      19.532  27.959 176.699  1.00 50.55           O  
ATOM     55  CB  ARG     9      19.141  31.125 175.658  1.00 52.07           C  
ATOM     56  CG  ARG     9      19.009  30.335 174.364  1.00 54.77           C  
ATOM     57  CD  ARG     9      18.455  31.194 173.237  1.00 60.14           C  
ATOM     58  NE  ARG     9      19.283  32.362 172.952  1.00 64.34           N  
ATOM     59  CZ  ARG     9      20.451  32.322 172.316  1.00 68.63           C  
ATOM     60  NH1 ARG     9      20.939  31.164 171.888  1.00 69.94           N  
ATOM     61  NH2 ARG     9      21.131  33.441 172.107  1.00 68.03           N  
ATOM     62  N   THR    10      21.189  29.388 177.240  1.00 50.60           N  
ATOM     63  CA  THR    10      22.217  28.357 177.275  1.00 50.83           C  
ATOM     64  C   THR    10      21.903  27.262 178.291  1.00 49.87           C  
ATOM     65  O   THR    10      22.003  26.074 177.983  1.00 50.46           O  
ATOM     66  CB  THR    10      23.603  28.971 177.581  1.00 51.38           C  
ATOM     67  OG1 THR    10      23.896  29.986 176.608  1.00 51.78           O  
ATOM     68  CG2 THR    10      24.680  27.904 177.521  1.00 50.61           C  
ATOM     69  N   TYR    11      21.521  27.657 179.499  1.00 48.77           N  
ATOM     70  CA  TYR    11      21.185  26.675 180.524  1.00 48.46           C  
ATOM     71  C   TYR    11      19.954  25.857 180.130  1.00 46.71           C  
ATOM     72  O   TYR    11      19.919  24.643 180.332  1.00 46.43           O  
ATOM     73  CB  TYR    11      20.893  27.339 181.860  1.00 50.01           C  
ATOM     74  CG  TYR    11      20.510  26.319 182.902  1.00 52.08           C  
ATOM     75  CD1 TYR    11      21.471  25.474 183.449  1.00 54.43           C  
ATOM     76  CD2 TYR    11      19.173  26.115 183.256  1.00 52.57           C  
ATOM     77  CE1 TYR    11      21.121  24.459 184.331  1.00 56.00           C  
ATOM     78  CE2 TYR    11      18.812  25.101 184.141  1.00 56.55           C  
ATOM     79  CZ  TYR    11      19.795  24.275 184.668  1.00 55.82           C  
ATOM     80  OH  TYR    11      19.458  23.278 185.549  1.00 57.24           O  
ATOM     81  N   VAL    12      18.942  26.515 179.570  1.00 45.29           N  
ATOM     82  CA  VAL    12      17.728  25.810 179.173  1.00 43.79           C  
ATOM     83  C   VAL    12      17.970  24.915 177.964  1.00 44.31           C  
ATOM     84  O   VAL    12      17.489  23.784 177.919  1.00 44.59           O  
ATOM     85  CB  VAL    12      16.575  26.796 178.864  1.00 44.09           C  
ATOM     86  CG1 VAL    12      15.364  26.044 178.307  1.00 38.90           C  
ATOM     87  CG2 VAL    12      16.187  27.557 180.138  1.00 40.82           C  
ATOM     88  N   GLU    13      18.706  25.418 176.982  1.00 45.77           N  
ATOM     89  CA  GLU    13      18.991  24.621 175.801  1.00 47.52           C  
ATOM     90  C   GLU    13      19.917  23.460 176.170  1.00 48.95           C  
ATOM     91  O   GLU    13      19.657  22.312 175.826  1.00 49.14           O  
ATOM     92  CB  GLU    13      19.621  25.491 174.701  1.00 47.27           C  
ATOM     93  CG  GLU    13      18.594  26.143 173.776  1.00 46.73           C  
ATOM     94  CD  GLU    13      19.213  27.051 172.733  1.00 47.14           C  
ATOM     95  OE1 GLU    13      18.462  27.802 172.070  1.00 46.58           O  
ATOM     96  OE2 GLU    13      20.451  27.011 172.568  1.00 48.58           O  
ATOM     97  N   SER    14      20.991  23.759 176.893  1.00 50.77           N  
ATOM     98  CA  SER    14      21.962  22.741 177.291  1.00 52.40           C  
ATOM     99  C   SER    14      21.408  21.764 178.315  1.00 52.24           C  
ATOM    100  O   SER    14      22.111  20.838 178.732  1.00 52.54           O  
ATOM    101  CB  SER    14      23.201  23.405 177.884  1.00 53.25           C  
ATOM    102  OG  SER    14      22.943  23.882 179.203  1.00 55.29           O  
ATOM    103  N   THR    15      20.152  21.956 178.709  1.00 51.44           N  
ATOM    104  CA  THR    15      19.565  21.104 179.726  1.00 50.00           C  
ATOM    105  C   THR    15      18.254  20.425 179.338  1.00 49.00           C  
ATOM    106  O   THR    15      17.740  19.581 180.077  1.00 48.09           O  
ATOM    107  CB  THR    15      19.421  21.928 181.040  1.00 50.48           C  
ATOM    108  OG1 THR    15      19.790  21.124 182.163  1.00 53.93           O  
ATOM    109  CG2 THR    15      18.042  22.429 181.224  1.00 49.25           C  
ATOM    110  N   THR    16      17.709  20.805 178.186  1.00 47.75           N  
ATOM    111  CA  THR    16      16.482  20.191 177.693  1.00 48.20           C  
ATOM    112  C   THR    16      16.843  18.834 177.065  1.00 50.22           C  
ATOM    113  O   THR    16      17.668  18.759 176.143  1.00 52.31           O  
ATOM    114  CB  THR    16      15.795  21.062 176.622  1.00 46.53           C  
ATOM    115  OG1 THR    16      15.318  22.271 177.220  1.00 45.88           O  
ATOM    116  CG2 THR    16      14.625  20.317 175.997  1.00 42.52           C  
ATOM    117  N   GLU    17      16.228  17.764 177.563  1.00 51.38           N  
ATOM    118  CA  GLU    17      16.493  16.421 177.062  1.00 53.69           C  
ATOM    119  C   GLU    17      16.282  16.387 175.556  1.00 54.77           C  
ATOM    120  O   GLU    17      15.184  16.632 175.051  1.00 53.95           O  
ATOM    121  CB  GLU    17      15.569  15.413 177.748  1.00 54.69           C  
ATOM    122  CG  GLU    17      15.799  13.980 177.324  1.00 57.95           C  
ATOM    123  CD  GLU    17      14.636  13.081 177.692  1.00 63.33           C  
ATOM    124  OE1 GLU    17      14.500  12.002 177.075  1.00 66.36           O  
ATOM    125  OE2 GLU    17      13.861  13.451 178.601  1.00 65.09           O  
ATOM    126  N   THR    18      17.345  16.068 174.836  1.00 56.14           N  
ATOM    127  CA  THR    18      17.289  16.046 173.385  1.00 57.87           C  
ATOM    128  C   THR    18      16.318  15.040 172.775  1.00 57.45           C  
ATOM    129  O   THR    18      16.215  13.904 173.238  1.00 57.97           O  
ATOM    130  CB  THR    18      18.709  15.817 172.779  1.00 58.68           C  
ATOM    131  OG1 THR    18      19.251  14.577 173.255  1.00 60.50           O  
ATOM    132  CG2 THR    18      19.660  16.960 173.166  1.00 57.87           C  
ATOM    133  N   ASP    19      15.587  15.481 171.752  1.00 56.51           N  
ATOM    134  CA  ASP    19      14.670  14.600 171.041  1.00 56.34           C  
ATOM    135  C   ASP    19      15.294  14.421 169.648  1.00 55.42           C  
ATOM    136  O   ASP    19      15.637  15.401 168.973  1.00 56.44           O  
ATOM    137  CB  ASP    19      13.263  15.210 170.904  1.00 55.60           C  
ATOM    138  CG  ASP    19      12.348  14.348 170.050  1.00 57.72           C  
ATOM    139  OD1 ASP    19      12.857  13.661 169.136  1.00 62.68           O  
ATOM    140  OD2 ASP    19      11.122  14.363 170.272  1.00 59.68           O  
ATOM    141  N   ALA    20      15.442  13.171 169.218  1.00 53.78           N  
ATOM    142  CA  ALA    20      16.054  12.863 167.926  1.00 51.44           C  
ATOM    143  C   ALA    20      15.281  13.437 166.750  1.00 49.39           C  
ATOM    144  O   ALA    20      15.857  14.097 165.881  1.00 47.69           O  
ATOM    145  CB  ALA    20      16.208  11.346 167.765  1.00 51.74           C  
ATOM    146  N   ALA    21      13.978  13.189 166.728  1.00 46.99           N  
ATOM    147  CA  ALA    21      13.140  13.693 165.655  1.00 44.89           C  
ATOM    148  C   ALA    21      13.208  15.221 165.610  1.00 43.57           C  
ATOM    149  O   ALA    21      13.247  15.812 164.534  1.00 43.64           O  
ATOM    150  CB  ALA    21      11.692  13.224 165.853  1.00 44.67           C  
ATOM    151  N   VAL    22      13.229  15.860 166.779  1.00 41.64           N  
ATOM    152  CA  VAL    22      13.292  17.319 166.849  1.00 39.09           C  
ATOM    153  C   VAL    22      14.655  17.846 166.414  1.00 38.15           C  
ATOM    154  O   VAL    22      14.745  18.838 165.688  1.00 36.18           O  
ATOM    155  CB  VAL    22      12.990  17.834 168.282  1.00 38.83           C  
ATOM    156  CG1 VAL    22      13.345  19.328 168.388  1.00 37.70           C  
ATOM    157  CG2 VAL    22      11.520  17.610 168.622  1.00 36.88           C  
ATOM    158  N   ALA    23      15.719  17.184 166.860  1.00 38.78           N  
ATOM    159  CA  ALA    23      17.070  17.602 166.500  1.00 39.37           C  
ATOM    160  C   ALA    23      17.260  17.469 164.984  1.00 38.28           C  
ATOM    161  O   ALA    23      17.908  18.299 164.359  1.00 37.20           O  
ATOM    162  CB  ALA    23      18.100  16.748 167.239  1.00 39.71           C  
ATOM    163  N   ARG    24      16.692  16.419 164.402  1.00 39.08           N  
ATOM    164  CA  ARG    24      16.800  16.188 162.969  1.00 40.86           C  
ATOM    165  C   ARG    24      16.093  17.324 162.217  1.00 40.75           C  
ATOM    166  O   ARG    24      16.635  17.874 161.249  1.00 40.53           O  
ATOM    167  CB  ARG    24      16.183  14.820 162.628  1.00 41.74           C  
ATOM    168  CG  ARG    24      16.075  14.501 161.150  1.00 49.23           C  
ATOM    169  CD  ARG    24      17.421  14.551 160.446  1.00 54.35           C  
ATOM    170  NE  ARG    24      17.462  13.599 159.339  1.00 59.94           N  
ATOM    171  CZ  ARG    24      18.095  13.812 158.194  1.00 59.09           C  
ATOM    172  NH1 ARG    24      18.742  14.952 158.002  1.00 62.71           N  
ATOM    173  NH2 ARG    24      18.073  12.890 157.241  1.00 60.22           N  
ATOM    174  N   ALA    25      14.891  17.680 162.668  1.00 40.03           N  
ATOM    175  CA  ALA    25      14.128  18.752 162.037  1.00 40.19           C  
ATOM    176  C   ALA    25      14.839  20.105 162.157  1.00 40.52           C  
ATOM    177  O   ALA    25      14.731  20.951 161.261  1.00 41.05           O  
ATOM    178  CB  ALA    25      12.728  18.829 162.649  1.00 40.91           C  
ATOM    179  N   ARG    26      15.564  20.307 163.256  1.00 40.54           N  
ATOM    180  CA  ARG    26      16.300  21.552 163.475  1.00 40.67           C  
ATOM    181  C   ARG    26      17.542  21.569 162.573  1.00 41.44           C  
ATOM    182  O   ARG    26      17.953  22.620 162.081  1.00 43.15           O  
ATOM    183  CB  ARG    26      16.716  21.666 164.945  1.00 40.06           C  
ATOM    184  CG  ARG    26      17.206  23.049 165.344  1.00 41.06           C  
ATOM    185  CD  ARG    26      17.244  23.192 166.860  1.00 39.59           C  
ATOM    186  NE  ARG    26      15.918  23.381 167.448  1.00 36.02           N  
ATOM    187  CZ  ARG    26      15.195  24.489 167.308  1.00 35.63           C  
ATOM    188  NH1 ARG    26      15.676  25.501 166.600  1.00 33.06           N  
ATOM    189  NH2 ARG    26      14.002  24.588 167.884  1.00 31.51           N  
ATOM    190  N   GLU    27      18.141  20.402 162.354  1.00 43.09           N  
ATOM    191  CA  GLU    27      19.306  20.309 161.483  1.00 45.53           C  
ATOM    192  C   GLU    27      18.829  20.549 160.048  1.00 44.47           C  
ATOM    193  O   GLU    27      19.434  21.325 159.304  1.00 44.94           O  
ATOM    194  CB  GLU    27      19.947  18.925 161.590  1.00 47.21           C  
ATOM    195  CG  GLU    27      21.435  18.965 161.907  1.00 56.44           C  
ATOM    196  CD  GLU    27      22.265  19.573 160.788  1.00 64.19           C  
ATOM    197  OE1 GLU    27      22.345  20.818 160.694  1.00 65.65           O  
ATOM    198  OE2 GLU    27      22.830  18.791 159.994  1.00 68.30           O  
ATOM    199  N   ASP    28      17.742  19.882 159.656  1.00 43.22           N  
ATOM    200  CA  ASP    28      17.198  20.053 158.307  1.00 42.84           C  
ATOM    201  C   ASP    28      16.904  21.517 157.990  1.00 42.31           C  
ATOM    202  O   ASP    28      17.295  22.014 156.935  1.00 42.99           O  
ATOM    203  CB  ASP    28      15.924  19.225 158.124  1.00 41.28           C  
ATOM    204  CG  ASP    28      16.209  17.744 157.975  1.00 42.74           C  
ATOM    205  OD1 ASP    28      17.404  17.380 157.943  1.00 44.72           O  
ATOM    206  OD2 ASP    28      15.246  16.946 157.885  1.00 45.45           O  
ATOM    207  N   ALA    29      16.225  22.209 158.902  1.00 41.52           N  
ATOM    208  CA  ALA    29      15.882  23.616 158.687  1.00 40.18           C  
ATOM    209  C   ALA    29      17.117  24.477 158.480  1.00 39.57           C  
ATOM    210  O   ALA    29      17.132  25.362 157.620  1.00 39.63           O  
ATOM    211  CB  ALA    29      15.058  24.154 159.864  1.00 40.56           C  
ATOM    212  N   ALA    30      18.146  24.209 159.275  1.00 39.17           N  
ATOM    213  CA  ALA    30      19.398  24.949 159.198  1.00 40.05           C  
ATOM    214  C   ALA    30      20.107  24.679 157.868  1.00 39.78           C  
ATOM    215  O   ALA    30      20.666  25.591 157.260  1.00 40.00           O  
ATOM    216  CB  ALA    30      20.305  24.561 160.365  1.00 40.11           C  
ATOM    217  N   GLU    31      20.085  23.427 157.422  1.00 38.65           N  
ATOM    218  CA  GLU    31      20.718  23.066 156.159  1.00 38.87           C  
ATOM    219  C   GLU    31      20.078  23.764 154.959  1.00 38.60           C  
ATOM    220  O   GLU    31      20.739  23.995 153.950  1.00 39.71           O  
ATOM    221  CB  GLU    31      20.668  21.552 155.963  1.00 39.36           C  
ATOM    222  CG  GLU    31      21.691  20.795 156.786  1.00 38.74           C  
ATOM    223  CD  GLU    31      21.437  19.310 156.790  1.00 43.41           C  
ATOM    224  OE1 GLU    31      20.865  18.809 155.803  1.00 47.35           O  
ATOM    225  OE2 GLU    31      21.820  18.637 157.764  1.00 48.92           O  
ATOM    226  N   PHE    32      18.796  24.105 155.072  1.00 37.78           N  
ATOM    227  CA  PHE    32      18.071  24.765 153.985  1.00 36.92           C  
ATOM    228  C   PHE    32      17.846  26.256 154.223  1.00 37.72           C  
ATOM    229  O   PHE    32      17.134  26.913 153.457  1.00 36.82           O  
ATOM    230  CB  PHE    32      16.727  24.064 153.758  1.00 35.46           C  
ATOM    231  CG  PHE    32      16.852  22.714 153.100  1.00 35.81           C  
ATOM    232  CD1 PHE    32      16.814  22.592 151.708  1.00 32.38           C  
ATOM    233  CD2 PHE    32      16.998  21.562 153.873  1.00 29.85           C  
ATOM    234  CE1 PHE    32      16.925  21.341 151.098  1.00 34.55           C  
ATOM    235  CE2 PHE    32      17.113  20.313 153.274  1.00 32.22           C  
ATOM    236  CZ  PHE    32      17.074  20.200 151.884  1.00 34.18           C  
ATOM    237  N   GLY    33      18.448  26.777 155.289  1.00 38.67           N  
ATOM    238  CA  GLY    33      18.321  28.190 155.623  1.00 38.55           C  
ATOM    239  C   GLY    33      16.923  28.661 155.983  1.00 37.08           C  
ATOM    240  O   GLY    33      16.572  29.818 155.756  1.00 36.54           O  
ATOM    241  N   LEU    34      16.129  27.765 156.564  1.00 38.38           N  
ATOM    242  CA  LEU    34      14.751  28.092 156.938  1.00 38.59           C  
ATOM    243  C   LEU    34      14.629  28.720 158.321  1.00 37.66           C  
ATOM    244  O   LEU    34      15.399  28.397 159.220  1.00 39.17           O  
ATOM    245  CB  LEU    34      13.887  26.827 156.897  1.00 38.83           C  
ATOM    246  CG  LEU    34      13.963  25.954 155.641  1.00 38.72           C  
ATOM    247  CD1 LEU    34      13.204  24.651 155.855  1.00 40.78           C  
ATOM    248  CD2 LEU    34      13.393  26.715 154.462  1.00 38.26           C  
ATOM    249  N   PRO    35      13.655  29.627 158.500  1.00 38.39           N  
ATOM    250  CA  PRO    35      13.416  30.306 159.780  1.00 39.03           C  
ATOM    251  C   PRO    35      12.913  29.261 160.777  1.00 40.77           C  
ATOM    252  O   PRO    35      11.820  28.713 160.611  1.00 41.07           O  
ATOM    253  CB  PRO    35      12.323  31.328 159.454  1.00 39.92           C  
ATOM    254  CG  PRO    35      12.269  31.377 157.939  1.00 39.36           C  
ATOM    255  CD  PRO    35      12.651  30.009 157.495  1.00 37.58           C  
ATOM    256  N   ALA    36      13.702  29.004 161.819  1.00 41.01           N  
ATOM    257  CA  ALA    36      13.344  27.997 162.818  1.00 40.99           C  
ATOM    258  C   ALA    36      13.320  28.519 164.250  1.00 40.41           C  
ATOM    259  O   ALA    36      14.364  28.860 164.803  1.00 41.47           O  
ATOM    260  CB  ALA    36      14.304  26.820 162.726  1.00 39.29           C  
ATOM    261  N   PRO    37      12.131  28.565 164.869  1.00 39.76           N  
ATOM    262  CA  PRO    37      11.992  29.042 166.250  1.00 37.91           C  
ATOM    263  C   PRO    37      12.926  28.246 167.151  1.00 36.44           C  
ATOM    264  O   PRO    37      13.077  27.035 166.962  1.00 35.90           O  
ATOM    265  CB  PRO    37      10.524  28.755 166.578  1.00 38.50           C  
ATOM    266  CG  PRO    37       9.850  28.774 165.250  1.00 40.52           C  
ATOM    267  CD  PRO    37      10.840  28.108 164.325  1.00 40.07           C  
ATOM    268  N   ASP    38      13.533  28.908 168.135  1.00 34.43           N  
ATOM    269  CA  ASP    38      14.448  28.213 169.038  1.00 34.87           C  
ATOM    270  C   ASP    38      13.717  27.211 169.936  1.00 35.84           C  
ATOM    271  O   ASP    38      12.491  27.094 169.887  1.00 34.82           O  
ATOM    272  CB  ASP    38      15.273  29.226 169.873  1.00 35.43           C  
ATOM    273  CG  ASP    38      14.428  30.055 170.830  1.00 37.24           C  
ATOM    274  OD1 ASP    38      13.181  30.018 170.734  1.00 39.36           O  
ATOM    275  OD2 ASP    38      15.029  30.747 171.687  1.00 41.15           O  
ATOM    276  N   GLU    39      14.478  26.489 170.752  1.00 35.27           N  
ATOM    277  CA  GLU    39      13.916  25.474 171.629  1.00 35.36           C  
ATOM    278  C   GLU    39      12.890  25.983 172.629  1.00 34.78           C  
ATOM    279  O   GLU    39      11.907  25.298 172.910  1.00 35.10           O  
ATOM    280  CB  GLU    39      15.040  24.754 172.372  1.00 36.46           C  
ATOM    281  CG  GLU    39      14.579  23.753 173.433  1.00 39.24           C  
ATOM    282  CD  GLU    39      13.757  22.609 172.864  1.00 42.52           C  
ATOM    283  OE1 GLU    39      14.081  22.141 171.754  1.00 46.69           O  
ATOM    284  OE2 GLU    39      12.795  22.167 173.532  1.00 44.19           O  
ATOM    285  N   MET    40      13.120  27.181 173.155  1.00 33.85           N  
ATOM    286  CA  MET    40      12.224  27.769 174.137  1.00 33.31           C  
ATOM    287  C   MET    40      10.880  28.153 173.523  1.00 31.59           C  
ATOM    288  O   MET    40       9.831  27.983 174.152  1.00 30.49           O  
ATOM    289  CB  MET    40      12.890  28.989 174.807  1.00 32.67           C  
ATOM    290  CG  MET    40      13.914  28.637 175.903  1.00 37.51           C  
ATOM    291  SD  MET    40      14.599  30.227 176.837  1.00 48.82          SE  
ATOM    292  CE  MET    40      16.150  29.483 177.672  1.00 47.77           C  
ATOM    293  N   THR    41      10.918  28.669 172.297  1.00 29.68           N  
ATOM    294  CA  THR    41       9.699  29.043 171.600  1.00 27.32           C  
ATOM    295  C   THR    41       8.914  27.755 171.285  1.00 26.43           C  
ATOM    296  O   THR    41       7.687  27.737 171.383  1.00 27.19           O  
ATOM    297  CB  THR    41      10.025  29.797 170.296  1.00 28.66           C  
ATOM    298  OG1 THR    41      10.738  30.996 170.619  1.00 26.10           O  
ATOM    299  CG2 THR    41       8.741  30.156 169.536  1.00 25.19           C  
ATOM    300  N   GLY    42       9.621  26.685 170.914  1.00 24.88           N  
ATOM    301  CA  GLY    42       8.967  25.414 170.622  1.00 26.74           C  
ATOM    302  C   GLY    42       8.266  24.847 171.858  1.00 27.45           C  
ATOM    303  O   GLY    42       7.145  24.339 171.751  1.00 27.33           O  
ATOM    304  N   GLN    43       8.910  24.928 173.025  1.00 26.78           N  
ATOM    305  CA  GLN    43       8.324  24.434 174.276  1.00 28.12           C  
ATOM    306  C   GLN    43       7.010  25.190 174.550  1.00 27.73           C  
ATOM    307  O   GLN    43       6.005  24.584 174.947  1.00 27.06           O  
ATOM    308  CB  GLN    43       9.332  24.610 175.437  1.00 27.92           C  
ATOM    309  CG  GLN    43      10.505  23.632 175.352  1.00 28.63           C  
ATOM    310  CD  GLN    43      11.578  23.886 176.399  1.00 34.03           C  
ATOM    311  OE1 GLN    43      11.355  24.607 177.373  1.00 36.82           O  
ATOM    312  NE2 GLN    43      12.752  23.290 176.204  1.00 32.59           N  
ATOM    313  N   LEU    44       7.014  26.508 174.335  1.00 27.40           N  
ATOM    314  CA  LEU    44       5.796  27.299 174.512  1.00 27.16           C  
ATOM    315  C   LEU    44       4.729  26.819 173.503  1.00 26.87           C  
ATOM    316  O   LEU    44       3.531  26.837 173.811  1.00 27.06           O  
ATOM    317  CB  LEU    44       6.061  28.795 174.302  1.00 25.60           C  
ATOM    318  CG  LEU    44       4.779  29.647 174.278  1.00 29.19           C  
ATOM    319  CD1 LEU    44       4.004  29.444 175.576  1.00 27.74           C  
ATOM    320  CD2 LEU    44       5.128  31.120 174.085  1.00 24.87           C  
ATOM    321  N   LEU    45       5.143  26.401 172.301  1.00 27.58           N  
ATOM    322  CA  LEU    45       4.174  25.911 171.307  1.00 29.21           C  
ATOM    323  C   LEU    45       3.531  24.614 171.836  1.00 28.50           C  
ATOM    324  O   LEU    45       2.331  24.399 171.691  1.00 29.78           O  
ATOM    325  CB  LEU    45       4.850  25.671 169.936  1.00 27.83           C  
ATOM    326  CG  LEU    45       5.300  26.957 169.216  1.00 30.54           C  
ATOM    327  CD1 LEU    45       5.894  26.601 167.853  1.00 32.59           C  
ATOM    328  CD2 LEU    45       4.104  27.908 169.041  1.00 29.82           C  
ATOM    329  N   THR    46       4.333  23.758 172.457  1.00 27.80           N  
ATOM    330  CA  THR    46       3.826  22.513 173.030  1.00 28.58           C  
ATOM    331  C   THR    46       2.826  22.835 174.150  1.00 27.31           C  
ATOM    332  O   THR    46       1.801  22.178 174.283  1.00 28.48           O  
ATOM    333  CB  THR    46       4.977  21.679 173.620  1.00 27.74           C  
ATOM    334  OG1 THR    46       5.956  21.451 172.604  1.00 28.37           O  
ATOM    335  CG2 THR    46       4.473  20.348 174.134  1.00 28.82           C  
ATOM    336  N   THR    47       3.136  23.852 174.953  1.00 28.69           N  
ATOM    337  CA  THR    47       2.279  24.266 176.060  1.00 27.73           C  
ATOM    338  C   THR    47       0.915  24.733 175.570  1.00 27.47           C  
ATOM    339  O   THR    47      -0.114  24.348 176.127  1.00 27.23           O  
ATOM    340  CB  THR    47       2.920  25.417 176.865  1.00 28.09           C  
ATOM    341  OG1 THR    47       4.170  24.984 177.415  1.00 27.40           O  
ATOM    342  CG2 THR    47       1.993  25.863 178.001  1.00 23.26           C  
ATOM    343  N   LEU    48       0.904  25.562 174.529  1.00 26.00           N  
ATOM    344  CA  LEU    48      -0.357  26.062 173.992  1.00 24.82           C  
ATOM    345  C   LEU    48      -1.138  24.957 173.294  1.00 24.93           C  
ATOM    346  O   LEU    48      -2.370  24.923 173.361  1.00 24.34           O  
ATOM    347  CB  LEU    48      -0.108  27.225 173.025  1.00 26.01           C  
ATOM    348  CG  LEU    48       0.505  28.475 173.683  1.00 30.70           C  
ATOM    349  CD1 LEU    48       0.765  29.551 172.624  1.00 30.77           C  
ATOM    350  CD2 LEU    48      -0.440  29.004 174.770  1.00 26.08           C  
ATOM    351  N   ALA    49      -0.428  24.053 172.620  1.00 25.73           N  
ATOM    352  CA  ALA    49      -1.091  22.953 171.935  1.00 26.68           C  
ATOM    353  C   ALA    49      -1.715  22.043 172.989  1.00 26.17           C  
ATOM    354  O   ALA    49      -2.765  21.445 172.761  1.00 25.74           O  
ATOM    355  CB  ALA    49      -0.084  22.163 171.077  1.00 24.82           C  
ATOM    356  N   ALA    50      -1.056  21.941 174.143  1.00 27.11           N  
ATOM    357  CA  ALA    50      -1.529  21.106 175.245  1.00 27.80           C  
ATOM    358  C   ALA    50      -2.642  21.769 176.057  1.00 29.60           C  
ATOM    359  O   ALA    50      -3.560  21.095 176.516  1.00 32.07           O  
ATOM    360  CB  ALA    50      -0.368  20.750 176.165  1.00 29.92           C  
ATOM    361  N   THR    51      -2.567  23.083 176.235  1.00 29.29           N  
ATOM    362  CA  THR    51      -3.576  23.787 177.009  1.00 30.18           C  
ATOM    363  C   THR    51      -4.841  24.127 176.208  1.00 32.02           C  
ATOM    364  O   THR    51      -5.941  24.063 176.767  1.00 31.22           O  
ATOM    365  CB  THR    51      -2.987  25.075 177.666  1.00 29.68           C  
ATOM    366  OG1 THR    51      -2.623  26.035 176.658  1.00 29.87           O  
ATOM    367  CG2 THR    51      -1.740  24.711 178.484  1.00 27.26           C  
ATOM    368  N   THR    52      -4.701  24.475 174.924  1.00 31.53           N  
ATOM    369  CA  THR    52      -5.877  24.802 174.119  1.00 31.58           C  
ATOM    370  C   THR    52      -6.810  23.597 174.026  1.00 33.91           C  
ATOM    371  O   THR    52      -6.387  22.444 174.151  1.00 34.00           O  
ATOM    372  CB  THR    52      -5.499  25.330 172.708  1.00 30.61           C  
ATOM    373  OG1 THR    52      -4.605  24.419 172.059  1.00 27.87           O  
ATOM    374  CG2 THR    52      -4.853  26.704 172.834  1.00 28.08           C  
ATOM    375  N   ASN    53      -8.085  23.868 173.784  1.00 36.96           N  
ATOM    376  CA  ASN    53      -9.107  22.823 173.780  1.00 41.28           C  
ATOM    377  C   ASN    53      -9.338  21.999 172.524  1.00 42.44           C  
ATOM    378  O   ASN    53      -9.875  22.501 171.540  1.00 42.24           O  
ATOM    379  CB  ASN    53     -10.426  23.449 174.254  1.00 41.27           C  
ATOM    380  CG  ASN    53     -11.429  22.416 174.745  1.00 44.44           C  
ATOM    381  OD1 ASN    53     -11.209  21.212 174.615  1.00 47.26           O  
ATOM    382  ND2 ASN    53     -12.548  22.888 175.303  1.00 47.57           N  
ATOM    383  N   GLY    54      -8.948  20.725 172.586  1.00 43.60           N  
ATOM    384  CA  GLY    54      -9.118  19.838 171.450  1.00 43.79           C  
ATOM    385  C   GLY    54     -10.568  19.477 171.184  1.00 46.01           C  
ATOM    386  O   GLY    54     -10.922  19.091 170.063  1.00 45.16           O  
ATOM    387  N   ASN    55     -11.408  19.603 172.213  1.00 46.67           N  
ATOM    388  CA  ASN    55     -12.834  19.294 172.096  1.00 46.74           C  
ATOM    389  C   ASN    55     -13.559  20.234 171.133  1.00 45.02           C  
ATOM    390  O   ASN    55     -13.647  21.441 171.374  1.00 46.21           O  
ATOM    391  CB  ASN    55     -13.509  19.362 173.473  1.00 48.61           C  
ATOM    392  CG  ASN    55     -13.087  18.220 174.394  1.00 52.70           C  
ATOM    393  OD1 ASN    55     -12.242  18.388 175.277  1.00 56.39           O  
ATOM    394  ND2 ASN    55     -13.671  17.045 174.179  1.00 58.74           N  
ATOM    395  N   GLY    56     -14.082  19.666 170.047  1.00 43.79           N  
ATOM    396  CA  GLY    56     -14.800  20.441 169.044  1.00 40.35           C  
ATOM    397  C   GLY    56     -13.862  21.143 168.080  1.00 38.97           C  
ATOM    398  O   GLY    56     -14.285  21.869 167.182  1.00 39.42           O  
ATOM    399  N   SER    57     -12.571  20.899 168.262  1.00 38.33           N  
ATOM    400  CA  SER    57     -11.535  21.505 167.437  1.00 35.50           C  
ATOM    401  C   SER    57     -10.963  20.557 166.387  1.00 33.56           C  
ATOM    402  O   SER    57     -10.777  19.374 166.646  1.00 31.18           O  
ATOM    403  CB  SER    57     -10.415  22.011 168.349  1.00 35.48           C  
ATOM    404  OG  SER    57      -9.243  22.356 167.632  1.00 34.61           O  
ATOM    405  N   THR    58     -10.681  21.087 165.200  1.00 32.90           N  
ATOM    406  CA  THR    58     -10.094  20.281 164.142  1.00 31.69           C  
ATOM    407  C   THR    58      -8.624  20.066 164.515  1.00 31.06           C  
ATOM    408  O   THR    58      -8.024  19.038 164.175  1.00 31.61           O  
ATOM    409  CB  THR    58     -10.180  20.998 162.777  1.00 32.99           C  
ATOM    410  OG1 THR    58     -11.548  21.305 162.487  1.00 32.94           O  
ATOM    411  CG2 THR    58      -9.628  20.102 161.665  1.00 33.92           C  
ATOM    412  N   GLY    59      -8.051  21.038 165.226  1.00 29.22           N  
ATOM    413  CA  GLY    59      -6.655  20.940 165.629  1.00 27.38           C  
ATOM    414  C   GLY    59      -5.873  22.231 165.456  1.00 28.44           C  
ATOM    415  O   GLY    59      -6.366  23.328 165.734  1.00 27.05           O  
ATOM    416  N   ALA    60      -4.650  22.104 164.964  1.00 27.51           N  
ATOM    417  CA  ALA    60      -3.798  23.261 164.784  1.00 28.53           C  
ATOM    418  C   ALA    60      -3.383  23.494 163.344  1.00 27.12           C  
ATOM    419  O   ALA    60      -3.470  22.598 162.499  1.00 26.54           O  
ATOM    420  CB  ALA    60      -2.553  23.121 165.676  1.00 26.61           C  
ATOM    421  N   ILE    61      -2.936  24.716 163.076  1.00 26.85           N  
ATOM    422  CA  ILE    61      -2.436  25.079 161.757  1.00 25.89           C  
ATOM    423  C   ILE    61      -1.026  25.662 161.925  1.00 26.23           C  
ATOM    424  O   ILE    61      -0.795  26.518 162.789  1.00 24.01           O  
ATOM    425  CB  ILE    61      -3.291  26.156 161.062  1.00 24.77           C  
ATOM    426  CG1 ILE    61      -4.711  25.646 160.832  1.00 26.17           C  
ATOM    427  CG2 ILE    61      -2.667  26.511 159.695  1.00 28.08           C  
ATOM    428  CD1 ILE    61      -5.649  26.690 160.250  1.00 24.83           C  
ATOM    429  N   ALA    62      -0.086  25.172 161.120  1.00 24.83           N  
ATOM    430  CA  ALA    62       1.285  25.687 161.129  1.00 27.04           C  
ATOM    431  C   ALA    62       1.558  26.266 159.728  1.00 26.93           C  
ATOM    432  O   ALA    62       1.616  25.537 158.737  1.00 27.63           O  
ATOM    433  CB  ALA    62       2.302  24.572 161.447  1.00 24.51           C  
ATOM    434  N   ILE    63       1.703  27.582 159.650  1.00 29.03           N  
ATOM    435  CA  ILE    63       1.974  28.269 158.397  1.00 30.40           C  
ATOM    436  C   ILE    63       3.430  28.702 158.444  1.00 30.95           C  
ATOM    437  O   ILE    63       3.771  29.745 159.002  1.00 32.03           O  
ATOM    438  CB  ILE    63       1.057  29.488 158.246  1.00 31.41           C  
ATOM    439  CG1 ILE    63      -0.394  29.016 158.112  1.00 33.10           C  
ATOM    440  CG2 ILE    63       1.472  30.306 157.044  1.00 33.12           C  
ATOM    441  CD1 ILE    63      -1.389  29.915 158.811  1.00 34.01           C  
ATOM    442  N   THR    64       4.289  27.911 157.812  1.00 31.33           N  
ATOM    443  CA  THR    64       5.721  28.179 157.842  1.00 31.25           C  
ATOM    444  C   THR    64       6.492  27.262 156.895  1.00 31.37           C  
ATOM    445  O   THR    64       6.055  26.147 156.621  1.00 31.07           O  
ATOM    446  CB  THR    64       6.248  27.938 159.275  1.00 30.66           C  
ATOM    447  OG1 THR    64       7.678  27.951 159.289  1.00 31.03           O  
ATOM    448  CG2 THR    64       5.768  26.557 159.795  1.00 30.49           C  
ATOM    449  N   PRO    65       7.651  27.719 156.398  1.00 32.35           N  
ATOM    450  CA  PRO    65       8.500  26.936 155.489  1.00 32.48           C  
ATOM    451  C   PRO    65       9.084  25.724 156.212  1.00 33.51           C  
ATOM    452  O   PRO    65       9.439  24.734 155.590  1.00 35.67           O  
ATOM    453  CB  PRO    65       9.603  27.913 155.089  1.00 31.90           C  
ATOM    454  CG  PRO    65       8.961  29.242 155.205  1.00 34.17           C  
ATOM    455  CD  PRO    65       8.050  29.140 156.412  1.00 32.46           C  
ATOM    456  N   ALA    66       9.209  25.823 157.529  1.00 33.82           N  
ATOM    457  CA  ALA    66       9.751  24.726 158.336  1.00 33.47           C  
ATOM    458  C   ALA    66       8.656  24.140 159.222  1.00 34.22           C  
ATOM    459  O   ALA    66       8.747  24.175 160.443  1.00 32.79           O  
ATOM    460  CB  ALA    66      10.897  25.226 159.206  1.00 34.03           C  
ATOM    461  N   ALA    67       7.622  23.586 158.600  1.00 34.58           N  
ATOM    462  CA  ALA    67       6.496  23.008 159.329  1.00 34.68           C  
ATOM    463  C   ALA    67       6.851  21.748 160.101  1.00 35.19           C  
ATOM    464  O   ALA    67       6.146  21.366 161.041  1.00 33.42           O  
ATOM    465  CB  ALA    67       5.348  22.721 158.365  1.00 33.52           C  
ATOM    466  N   GLY    68       7.944  21.108 159.698  1.00 34.05           N  
ATOM    467  CA  GLY    68       8.365  19.888 160.351  1.00 33.14           C  
ATOM    468  C   GLY    68       8.839  20.106 161.776  1.00 33.00           C  
ATOM    469  O   GLY    68       8.451  19.368 162.690  1.00 31.77           O  
ATOM    470  N   LEU    69       9.685  21.111 161.967  1.00 31.47           N  
ATOM    471  CA  LEU    69      10.206  21.409 163.290  1.00 32.26           C  
ATOM    472  C   LEU    69       9.049  21.904 164.167  1.00 33.07           C  
ATOM    473  O   LEU    69       8.747  21.322 165.202  1.00 33.37           O  
ATOM    474  CB  LEU    69      11.316  22.469 163.199  1.00 30.74           C  
ATOM    475  CG  LEU    69      11.850  23.000 164.535  1.00 32.20           C  
ATOM    476  CD1 LEU    69      12.571  21.903 165.298  1.00 32.82           C  
ATOM    477  CD2 LEU    69      12.786  24.161 164.273  1.00 29.97           C  
ATOM    478  N   VAL    70       8.404  22.979 163.737  1.00 33.16           N  
ATOM    479  CA  VAL    70       7.270  23.553 164.456  1.00 34.67           C  
ATOM    480  C   VAL    70       6.188  22.511 164.772  1.00 34.31           C  
ATOM    481  O   VAL    70       5.713  22.433 165.910  1.00 33.10           O  
ATOM    482  CB  VAL    70       6.641  24.707 163.632  1.00 35.05           C  
ATOM    483  CG1 VAL    70       5.295  25.134 164.236  1.00 37.65           C  
ATOM    484  CG2 VAL    70       7.594  25.883 163.595  1.00 33.13           C  
ATOM    485  N   GLY    71       5.818  21.730 163.755  1.00 32.90           N  
ATOM    486  CA  GLY    71       4.791  20.711 163.886  1.00 30.68           C  
ATOM    487  C   GLY    71       5.058  19.658 164.935  1.00 30.85           C  
ATOM    488  O   GLY    71       4.128  19.144 165.564  1.00 31.53           O  
ATOM    489  N   LEU    72       6.329  19.312 165.101  1.00 29.51           N  
ATOM    490  CA  LEU    72       6.718  18.310 166.080  1.00 30.07           C  
ATOM    491  C   LEU    72       6.456  18.822 167.497  1.00 28.95           C  
ATOM    492  O   LEU    72       6.056  18.058 168.379  1.00 29.63           O  
ATOM    493  CB  LEU    72       8.199  17.931 165.905  1.00 28.25           C  
ATOM    494  CG  LEU    72       8.495  17.019 164.697  1.00 28.77           C  
ATOM    495  CD1 LEU    72      10.006  16.853 164.530  1.00 31.04           C  
ATOM    496  CD2 LEU    72       7.842  15.648 164.901  1.00 27.33           C  
ATOM    497  N   TYR    73       6.689  20.111 167.721  1.00 29.65           N  
ATOM    498  CA  TYR    73       6.457  20.703 169.041  1.00 29.58           C  
ATOM    499  C   TYR    73       4.964  20.741 169.333  1.00 28.26           C  
ATOM    500  O   TYR    73       4.531  20.474 170.441  1.00 29.39           O  
ATOM    501  CB  TYR    73       7.009  22.121 169.087  1.00 29.72           C  
ATOM    502  CG  TYR    73       8.499  22.183 169.239  1.00 29.82           C  
ATOM    503  CD1 TYR    73       9.111  21.787 170.432  1.00 29.49           C  
ATOM    504  CD2 TYR    73       9.299  22.677 168.210  1.00 29.76           C  
ATOM    505  CE1 TYR    73      10.485  21.890 170.597  1.00 30.20           C  
ATOM    506  CE2 TYR    73      10.678  22.785 168.362  1.00 28.61           C  
ATOM    507  CZ  TYR    73      11.261  22.396 169.553  1.00 29.90           C  
ATOM    508  OH  TYR    73      12.613  22.544 169.717  1.00 35.40           O  
ATOM    509  N   ILE    74       4.187  21.075 168.313  1.00 27.05           N  
ATOM    510  CA  ILE    74       2.742  21.150 168.431  1.00 26.50           C  
ATOM    511  C   ILE    74       2.135  19.761 168.633  1.00 26.41           C  
ATOM    512  O   ILE    74       1.286  19.576 169.502  1.00 28.29           O  
ATOM    513  CB  ILE    74       2.133  21.843 167.173  1.00 25.58           C  
ATOM    514  CG1 ILE    74       2.499  23.330 167.185  1.00 23.49           C  
ATOM    515  CG2 ILE    74       0.621  21.655 167.133  1.00 22.85           C  
ATOM    516  CD1 ILE    74       1.908  24.129 166.028  1.00 28.06           C  
ATOM    517  N   LEU    75       2.578  18.785 167.838  1.00 29.11           N  
ATOM    518  CA  LEU    75       2.070  17.417 167.943  1.00 31.04           C  
ATOM    519  C   LEU    75       2.324  16.801 169.317  1.00 31.90           C  
ATOM    520  O   LEU    75       1.556  15.959 169.776  1.00 32.45           O  
ATOM    521  CB  LEU    75       2.669  16.541 166.827  1.00 29.40           C  
ATOM    522  CG  LEU    75       2.073  16.841 165.443  1.00 32.38           C  
ATOM    523  CD1 LEU    75       2.908  16.176 164.343  1.00 30.38           C  
ATOM    524  CD2 LEU    75       0.623  16.352 165.404  1.00 29.98           C  
ATOM    525  N   ASN    76       3.395  17.230 169.975  1.00 33.41           N  
ATOM    526  CA  ASN    76       3.712  16.733 171.314  1.00 35.17           C  
ATOM    527  C   ASN    76       2.572  17.013 172.296  1.00 35.09           C  
ATOM    528  O   ASN    76       2.253  16.169 173.134  1.00 36.99           O  
ATOM    529  CB  ASN    76       4.985  17.396 171.838  1.00 34.72           C  
ATOM    530  CG  ASN    76       6.245  16.662 171.424  1.00 39.54           C  
ATOM    531  OD1 ASN    76       7.342  17.238 171.396  1.00 43.81           O  
ATOM    532  ND2 ASN    76       6.101  15.382 171.115  1.00 43.80           N  
ATOM    533  N   GLY    77       1.956  18.193 172.195  1.00 32.65           N  
ATOM    534  CA  GLY    77       0.886  18.548 173.123  1.00 31.47           C  
ATOM    535  C   GLY    77      -0.552  18.330 172.695  1.00 32.40           C  
ATOM    536  O   GLY    77      -1.423  18.051 173.515  1.00 32.95           O  
ATOM    537  N   LEU    78      -0.793  18.459 171.402  1.00 31.49           N  
ATOM    538  CA  LEU    78      -2.120  18.294 170.822  1.00 32.19           C  
ATOM    539  C   LEU    78      -2.823  16.975 171.191  1.00 32.44           C  
ATOM    540  O   LEU    78      -2.192  15.920 171.231  1.00 33.08           O  
ATOM    541  CB  LEU    78      -2.002  18.403 169.302  1.00 29.81           C  
ATOM    542  CG  LEU    78      -2.898  19.317 168.462  1.00 36.01           C  
ATOM    543  CD1 LEU    78      -3.015  20.694 169.104  1.00 31.57           C  
ATOM    544  CD2 LEU    78      -2.310  19.420 167.051  1.00 33.99           C  
ATOM    545  N   ALA    79      -4.125  17.038 171.467  1.00 32.64           N  
ATOM    546  CA  ALA    79      -4.892  15.832 171.782  1.00 34.44           C  
ATOM    547  C   ALA    79      -4.895  14.941 170.513  1.00 36.11           C  
ATOM    548  O   ALA    79      -4.945  15.436 169.369  1.00 34.62           O  
ATOM    549  CB  ALA    79      -6.313  16.202 172.177  1.00 33.20           C  
ATOM    550  N   ASP    80      -4.855  13.626 170.720  1.00 37.28           N  
ATOM    551  CA  ASP    80      -4.807  12.657 169.619  1.00 38.96           C  
ATOM    552  C   ASP    80      -5.900  12.729 168.569  1.00 39.23           C  
ATOM    553  O   ASP    80      -5.662  12.390 167.403  1.00 40.09           O  
ATOM    554  CB  ASP    80      -4.733  11.229 170.168  1.00 39.60           C  
ATOM    555  CG  ASP    80      -3.476  10.985 170.982  1.00 42.87           C  
ATOM    556  OD1 ASP    80      -2.538  11.801 170.863  1.00 44.38           O  
ATOM    557  OD2 ASP    80      -3.422   9.972 171.723  1.00 45.18           O  
ATOM    558  N   ASN    81      -7.082  13.184 168.970  1.00 39.54           N  
ATOM    559  CA  ASN    81      -8.204  13.278 168.047  1.00 39.87           C  
ATOM    560  C   ASN    81      -8.299  14.609 167.305  1.00 39.74           C  
ATOM    561  O   ASN    81      -9.394  15.121 167.052  1.00 39.36           O  
ATOM    562  CB  ASN    81      -9.514  12.983 168.783  1.00 41.88           C  
ATOM    563  CG  ASN    81      -9.823  13.994 169.858  1.00 43.68           C  
ATOM    564  OD1 ASN    81      -8.920  14.588 170.441  1.00 47.17           O  
ATOM    565  ND2 ASN    81     -11.110  14.181 170.145  1.00 46.32           N  
ATOM    566  N   THR    82      -7.140  15.166 166.966  1.00 38.30           N  
ATOM    567  CA  THR    82      -7.066  16.420 166.219  1.00 36.46           C  
ATOM    568  C   THR    82      -5.965  16.231 165.179  1.00 37.02           C  
ATOM    569  O   THR    82      -5.215  15.253 165.228  1.00 35.72           O  
ATOM    570  CB  THR    82      -6.673  17.620 167.113  1.00 36.23           C  
ATOM    571  OG1 THR    82      -5.346  17.421 167.621  1.00 36.98           O  
ATOM    572  CG2 THR    82      -7.648  17.775 168.276  1.00 32.89           C  
ATOM    573  N   THR    83      -5.870  17.152 164.229  1.00 35.99           N  
ATOM    574  CA  THR    83      -4.833  17.056 163.204  1.00 36.94           C  
ATOM    575  C   THR    83      -3.979  18.323 163.161  1.00 35.17           C  
ATOM    576  O   THR    83      -4.354  19.372 163.704  1.00 34.96           O  
ATOM    577  CB  THR    83      -5.419  16.869 161.772  1.00 36.92           C  
ATOM    578  OG1 THR    83      -6.172  18.035 161.406  1.00 39.44           O  
ATOM    579  CG2 THR    83      -6.322  15.639 161.695  1.00 37.40           C  
ATOM    580  N   LEU    84      -2.814  18.214 162.535  1.00 33.33           N  
ATOM    581  CA  LEU    84      -1.956  19.373 162.347  1.00 32.12           C  
ATOM    582  C   LEU    84      -2.042  19.650 160.851  1.00 31.40           C  
ATOM    583  O   LEU    84      -1.809  18.764 160.022  1.00 32.33           O  
ATOM    584  CB  LEU    84      -0.491  19.090 162.727  1.00 32.68           C  
ATOM    585  CG  LEU    84       0.523  20.154 162.264  1.00 29.79           C  
ATOM    586  CD1 LEU    84       0.307  21.474 163.009  1.00 30.01           C  
ATOM    587  CD2 LEU    84       1.929  19.629 162.515  1.00 28.22           C  
ATOM    588  N   THR    85      -2.406  20.875 160.501  1.00 32.14           N  
ATOM    589  CA  THR    85      -2.507  21.273 159.104  1.00 30.98           C  
ATOM    590  C   THR    85      -1.329  22.197 158.812  1.00 31.89           C  
ATOM    591  O   THR    85      -1.208  23.272 159.401  1.00 32.68           O  
ATOM    592  CB  THR    85      -3.837  22.004 158.831  1.00 30.16           C  
ATOM    593  OG1 THR    85      -4.924  21.091 159.026  1.00 30.62           O  
ATOM    594  CG2 THR    85      -3.875  22.553 157.416  1.00 30.92           C  
ATOM    595  N   CYS    86      -0.458  21.762 157.906  1.00 32.18           N  
ATOM    596  CA  CYS    86       0.714  22.537 157.518  1.00 31.91           C  
ATOM    597  C   CYS    86       0.448  23.205 156.180  1.00 32.73           C  
ATOM    598  O   CYS    86      -0.146  22.612 155.283  1.00 33.43           O  
ATOM    599  CB  CYS    86       1.939  21.633 157.398  1.00 31.46           C  
ATOM    600  SG  CYS    86       2.309  20.684 158.888  1.00 30.56           S  
ATOM    601  N   ILE    87       0.900  24.445 156.047  1.00 32.21           N  
ATOM    602  CA  ILE    87       0.681  25.199 154.820  1.00 32.24           C  
ATOM    603  C   ILE    87       1.921  25.904 154.279  1.00 34.38           C  
ATOM    604  O   ILE    87       2.488  26.779 154.948  1.00 35.36           O  
ATOM    605  CB  ILE    87      -0.392  26.294 155.018  1.00 31.54           C  
ATOM    606  CG1 ILE    87      -1.607  25.723 155.753  1.00 28.05           C  
ATOM    607  CG2 ILE    87      -0.785  26.889 153.665  1.00 28.77           C  
ATOM    608  CD1 ILE    87      -2.753  26.703 155.903  1.00 31.08           C  
ATOM    609  N   ASP    88       2.344  25.505 153.082  1.00 34.03           N  
ATOM    610  CA  ASP    88       3.466  26.138 152.400  1.00 34.37           C  
ATOM    611  C   ASP    88       3.368  25.786 150.906  1.00 33.50           C  
ATOM    612  O   ASP    88       2.976  24.679 150.548  1.00 33.15           O  
ATOM    613  CB  ASP    88       4.823  25.687 152.965  1.00 32.69           C  
ATOM    614  CG  ASP    88       5.983  26.521 152.414  1.00 32.83           C  
ATOM    615  OD1 ASP    88       6.150  27.677 152.852  1.00 33.51           O  
ATOM    616  OD2 ASP    88       6.707  26.028 151.526  1.00 31.22           O  
ATOM    617  N   PRO    89       3.705  26.738 150.021  1.00 35.06           N  
ATOM    618  CA  PRO    89       3.654  26.536 148.564  1.00 37.30           C  
ATOM    619  C   PRO    89       4.796  25.746 147.929  1.00 39.95           C  
ATOM    620  O   PRO    89       4.690  25.310 146.781  1.00 40.65           O  
ATOM    621  CB  PRO    89       3.600  27.962 148.019  1.00 36.50           C  
ATOM    622  CG  PRO    89       4.416  28.736 149.005  1.00 33.94           C  
ATOM    623  CD  PRO    89       4.032  28.139 150.356  1.00 35.74           C  
ATOM    624  N   GLU    90       5.882  25.561 148.672  1.00 40.63           N  
ATOM    625  CA  GLU    90       7.049  24.865 148.164  1.00 41.49           C  
ATOM    626  C   GLU    90       6.934  23.361 148.357  1.00 41.43           C  
ATOM    627  O   GLU    90       6.688  22.892 149.464  1.00 42.37           O  
ATOM    628  CB  GLU    90       8.290  25.445 148.855  1.00 42.68           C  
ATOM    629  CG  GLU    90       9.148  26.359 147.968  1.00 47.20           C  
ATOM    630  CD  GLU    90       8.355  27.215 146.988  1.00 50.57           C  
ATOM    631  OE1 GLU    90       7.985  28.356 147.335  1.00 54.15           O  
ATOM    632  OE2 GLU    90       8.093  26.733 145.867  1.00 51.33           O  
ATOM    633  N   SER    91       7.118  22.606 147.277  1.00 40.04           N  
ATOM    634  CA  SER    91       6.974  21.159 147.346  1.00 40.28           C  
ATOM    635  C   SER    91       8.046  20.403 148.106  1.00 39.22           C  
ATOM    636  O   SER    91       7.757  19.360 148.698  1.00 38.91           O  
ATOM    637  CB  SER    91       6.795  20.574 145.938  1.00 40.80           C  
ATOM    638  OG  SER    91       7.828  20.986 145.076  1.00 47.75           O  
ATOM    639  N   GLU    92       9.273  20.917 148.105  1.00 38.40           N  
ATOM    640  CA  GLU    92      10.328  20.254 148.855  1.00 37.79           C  
ATOM    641  C   GLU    92      10.055  20.488 150.350  1.00 35.86           C  
ATOM    642  O   GLU    92      10.494  19.697 151.190  1.00 34.88           O  
ATOM    643  CB  GLU    92      11.724  20.777 148.458  1.00 37.99           C  
ATOM    644  CG  GLU    92      12.018  22.231 148.746  1.00 38.66           C  
ATOM    645  CD  GLU    92      13.401  22.629 148.226  1.00 39.16           C  
ATOM    646  OE1 GLU    92      13.730  23.832 148.234  1.00 44.47           O  
ATOM    647  OE2 GLU    92      14.165  21.728 147.819  1.00 39.56           O  
ATOM    648  N   HIS    93       9.339  21.565 150.689  1.00 34.44           N  
ATOM    649  CA  HIS    93       8.997  21.824 152.087  1.00 34.73           C  
ATOM    650  C   HIS    93       7.952  20.787 152.502  1.00 36.07           C  
ATOM    651  O   HIS    93       7.934  20.348 153.652  1.00 37.25           O  
ATOM    652  CB  HIS    93       8.472  23.258 152.258  1.00 34.41           C  
ATOM    653  CG  HIS    93       9.545  24.294 152.134  1.00 32.27           C  
ATOM    654  ND1 HIS    93       9.280  25.639 152.016  1.00 30.35           N  
ATOM    655  CD2 HIS    93      10.892  24.171 152.097  1.00 24.41           C  
ATOM    656  CE1 HIS    93      10.418  26.300 151.907  1.00 27.66           C  
ATOM    657  NE2 HIS    93      11.411  25.432 151.952  1.00 27.44           N  
ATOM    658  N   GLN    94       7.085  20.385 151.569  1.00 36.34           N  
ATOM    659  CA  GLN    94       6.070  19.368 151.863  1.00 36.30           C  
ATOM    660  C   GLN    94       6.777  18.026 152.075  1.00 37.32           C  
ATOM    661  O   GLN    94       6.414  17.252 152.974  1.00 36.92           O  
ATOM    662  CB  GLN    94       5.061  19.248 150.715  1.00 36.05           C  
ATOM    663  CG  GLN    94       4.217  17.979 150.781  1.00 38.03           C  
ATOM    664  CD  GLN    94       2.981  18.054 149.912  1.00 41.92           C  
ATOM    665  OE1 GLN    94       3.067  18.249 148.695  1.00 43.15           O  
ATOM    666  NE2 GLN    94       1.815  17.904 150.534  1.00 42.69           N  
ATOM    667  N   ARG    95       7.783  17.749 151.242  1.00 37.73           N  
ATOM    668  CA  ARG    95       8.554  16.513 151.365  1.00 38.04           C  
ATOM    669  C   ARG    95       9.350  16.566 152.664  1.00 36.71           C  
ATOM    670  O   ARG    95       9.433  15.578 153.389  1.00 37.54           O  
ATOM    671  CB  ARG    95       9.522  16.343 150.190  1.00 37.76           C  
ATOM    672  CG  ARG    95       8.981  15.501 149.051  1.00 41.07           C  
ATOM    673  CD  ARG    95      10.112  14.864 148.251  1.00 41.47           C  
ATOM    674  NE  ARG    95      10.210  13.421 148.471  1.00 44.73           N  
ATOM    675  CZ  ARG    95      11.303  12.697 148.238  1.00 48.22           C  
ATOM    676  NH1 ARG    95      12.405  13.277 147.777  1.00 43.75           N  
ATOM    677  NH2 ARG    95      11.300  11.388 148.466  1.00 50.29           N  
ATOM    678  N   GLN    96       9.929  17.729 152.950  1.00 36.06           N  
ATOM    679  CA  GLN    96      10.728  17.925 154.160  1.00 36.78           C  
ATOM    680  C   GLN    96       9.918  17.667 155.432  1.00 37.11           C  
ATOM    681  O   GLN    96      10.404  17.022 156.363  1.00 38.28           O  
ATOM    682  CB  GLN    96      11.321  19.352 154.177  1.00 36.09           C  
ATOM    683  CG  GLN    96      12.559  19.528 153.281  1.00 35.76           C  
ATOM    684  CD  GLN    96      12.876  20.987 152.938  1.00 37.87           C  
ATOM    685  OE1 GLN    96      12.553  21.902 153.695  1.00 37.55           O  
ATOM    686  NE2 GLN    96      13.521  21.202 151.787  1.00 37.71           N  
ATOM    687  N   ALA    97       8.685  18.164 155.459  1.00 36.86           N  
ATOM    688  CA  ALA    97       7.808  18.008 156.618  1.00 38.73           C  
ATOM    689  C   ALA    97       7.274  16.589 156.803  1.00 39.18           C  
ATOM    690  O   ALA    97       7.426  16.003 157.871  1.00 40.70           O  
ATOM    691  CB  ALA    97       6.642  18.998 156.527  1.00 38.41           C  
ATOM    692  N   LYS    98       6.643  16.043 155.767  1.00 41.29           N  
ATOM    693  CA  LYS    98       6.092  14.691 155.829  1.00 42.21           C  
ATOM    694  C   LYS    98       7.160  13.660 156.207  1.00 41.35           C  
ATOM    695  O   LYS    98       6.868  12.667 156.882  1.00 41.72           O  
ATOM    696  CB  LYS    98       5.452  14.320 154.489  1.00 42.60           C  
ATOM    697  CG  LYS    98       4.132  15.045 154.207  1.00 46.99           C  
ATOM    698  CD  LYS    98       3.701  14.826 152.757  1.00 50.33           C  
ATOM    699  CE  LYS    98       2.273  14.316 152.636  1.00 52.72           C  
ATOM    700  NZ  LYS    98       1.300  15.394 152.311  1.00 55.75           N  
ATOM    701  N   ALA    99       8.395  13.899 155.776  1.00 40.82           N  
ATOM    702  CA  ALA    99       9.501  13.005 156.096  1.00 40.65           C  
ATOM    703  C   ALA    99       9.746  13.051 157.612  1.00 41.49           C  
ATOM    704  O   ALA    99       9.763  12.015 158.279  1.00 42.92           O  
ATOM    705  CB  ALA    99      10.761  13.443 155.353  1.00 39.72           C  
ATOM    706  N   LEU   100       9.944  14.253 158.155  1.00 41.47           N  
ATOM    707  CA  LEU   100      10.195  14.414 159.590  1.00 42.16           C  
ATOM    708  C   LEU   100       9.088  13.802 160.454  1.00 43.10           C  
ATOM    709  O   LEU   100       9.366  13.216 161.504  1.00 44.57           O  
ATOM    710  CB  LEU   100      10.390  15.899 159.931  1.00 40.19           C  
ATOM    711  CG  LEU   100      11.760  16.459 159.539  1.00 40.76           C  
ATOM    712  CD1 LEU   100      11.733  17.979 159.622  1.00 38.21           C  
ATOM    713  CD2 LEU   100      12.845  15.879 160.463  1.00 39.23           C  
ATOM    714  N   PHE   101       7.837  13.937 160.017  1.00 43.20           N  
ATOM    715  CA  PHE   101       6.726  13.365 160.764  1.00 42.25           C  
ATOM    716  C   PHE   101       6.823  11.845 160.643  1.00 44.41           C  
ATOM    717  O   PHE   101       6.658  11.123 161.621  1.00 43.24           O  
ATOM    718  CB  PHE   101       5.385  13.879 160.217  1.00 41.31           C  
ATOM    719  CG  PHE   101       5.197  15.367 160.365  1.00 39.00           C  
ATOM    720  CD1 PHE   101       5.665  16.033 161.502  1.00 34.66           C  
ATOM    721  CD2 PHE   101       4.571  16.105 159.369  1.00 36.49           C  
ATOM    722  CE1 PHE   101       5.495  17.412 161.645  1.00 34.60           C  
ATOM    723  CE2 PHE   101       4.399  17.484 159.500  1.00 34.58           C  
ATOM    724  CZ  PHE   101       4.870  18.142 160.633  1.00 32.21           C  
ATOM    725  N   ARG   102       7.102  11.360 159.435  1.00 46.41           N  
ATOM    726  CA  ARG   102       7.242   9.923 159.196  1.00 48.11           C  
ATOM    727  C   ARG   102       8.348   9.354 160.107  1.00 48.36           C  
ATOM    728  O   ARG   102       8.139   8.336 160.770  1.00 48.43           O  
ATOM    729  CB  ARG   102       7.627   9.660 157.741  1.00 49.29           C  
ATOM    730  CG  ARG   102       7.634   8.184 157.333  1.00 51.02           C  
ATOM    731  CD  ARG   102       8.792   7.853 156.388  1.00 53.05           C  
ATOM    732  NE  ARG   102       9.139   8.969 155.508  1.00 52.14           N  
ATOM    733  CZ  ARG   102       8.311   9.516 154.622  1.00 55.54           C  
ATOM    734  NH1 ARG   102       7.078   9.047 154.486  1.00 53.38           N  
ATOM    735  NH2 ARG   102       8.711  10.542 153.882  1.00 51.50           N  
ATOM    736  N   GLU   103       9.516  10.005 160.131  1.00 48.96           N  
ATOM    737  CA  GLU   103      10.645   9.551 160.943  1.00 49.81           C  
ATOM    738  C   GLU   103      10.291   9.567 162.426  1.00 50.89           C  
ATOM    739  O   GLU   103      10.596   8.606 163.141  1.00 50.34           O  
ATOM    740  CB  GLU   103      11.893  10.388 160.616  1.00 50.09           C  
ATOM    741  CG  GLU   103      12.643   9.818 159.415  1.00 51.67           C  
ATOM    742  CD  GLU   103      13.347  10.890 158.626  1.00 51.76           C  
ATOM    743  OE1 GLU   103      13.899  11.825 159.251  1.00 48.29           O  
ATOM    744  OE2 GLU   103      13.354  10.796 157.383  1.00 55.16           O  
ATOM    745  N   ALA   104       9.667  10.652 162.892  1.00 51.35           N  
ATOM    746  CA  ALA   104       9.177  10.675 164.265  1.00 52.00           C  
ATOM    747  C   ALA   104       8.091   9.565 164.126  1.00 52.43           C  
ATOM    748  O   ALA   104       7.679   9.211 163.007  1.00 53.80           O  
ATOM    749  CB  ALA   104       8.528  12.007 164.577  1.00 52.52           C  
ATOM    750  N   GLY   105       7.572   9.038 165.222  1.00 51.99           N  
ATOM    751  CA  GLY   105       6.611   7.951 165.088  1.00 52.42           C  
ATOM    752  C   GLY   105       5.192   8.281 164.726  1.00 51.41           C  
ATOM    753  O   GLY   105       4.281   7.504 165.013  1.00 52.46           O  
ATOM    754  N   TYR   106       5.022   9.381 164.007  1.00 49.01           N  
ATOM    755  CA  TYR   106       3.692   9.848 163.660  1.00 48.06           C  
ATOM    756  C   TYR   106       2.927   9.292 162.481  1.00 48.12           C  
ATOM    757  O   TYR   106       3.453   9.190 161.388  1.00 48.28           O  
ATOM    758  CB  TYR   106       3.704  11.371 163.567  1.00 46.71           C  
ATOM    759  CG  TYR   106       3.873  12.108 164.893  1.00 46.02           C  
ATOM    760  CD1 TYR   106       2.832  12.165 165.824  1.00 45.78           C  
ATOM    761  CD2 TYR   106       5.077  12.743 165.217  1.00 45.53           C  
ATOM    762  CE1 TYR   106       2.987  12.828 167.043  1.00 43.89           C  
ATOM    763  CE2 TYR   106       5.242  13.401 166.435  1.00 45.18           C  
ATOM    764  CZ  TYR   106       4.194  13.441 167.339  1.00 47.22           C  
ATOM    765  OH  TYR   106       4.358  14.096 168.537  1.00 44.15           O  
ATOM    766  N   SER   107       1.663   8.960 162.731  1.00 48.48           N  
ATOM    767  CA  SER   107       0.783   8.435 161.702  1.00 49.27           C  
ATOM    768  C   SER   107       0.425   9.539 160.706  1.00 49.37           C  
ATOM    769  O   SER   107       0.319  10.710 161.073  1.00 49.53           O  
ATOM    770  CB  SER   107      -0.491   7.870 162.342  1.00 49.50           C  
ATOM    771  OG  SER   107      -1.474   7.588 161.364  1.00 52.70           O  
ATOM    772  N   PRO   108       0.235   9.176 159.429  1.00 49.21           N  
ATOM    773  CA  PRO   108      -0.110  10.142 158.376  1.00 48.45           C  
ATOM    774  C   PRO   108      -1.477  10.785 158.603  1.00 47.09           C  
ATOM    775  O   PRO   108      -1.770  11.856 158.079  1.00 46.18           O  
ATOM    776  CB  PRO   108      -0.096   9.296 157.096  1.00 49.07           C  
ATOM    777  CG  PRO   108       0.786   8.137 157.438  1.00 48.53           C  
ATOM    778  CD  PRO   108       0.450   7.831 158.867  1.00 48.40           C  
ATOM    779  N   SER   109      -2.314  10.103 159.375  1.00 45.54           N  
ATOM    780  CA  SER   109      -3.663  10.569 159.685  1.00 44.50           C  
ATOM    781  C   SER   109      -3.706  11.769 160.631  1.00 43.25           C  
ATOM    782  O   SER   109      -4.730  12.445 160.743  1.00 42.75           O  
ATOM    783  CB  SER   109      -4.464   9.421 160.291  1.00 44.79           C  
ATOM    784  OG  SER   109      -3.645   8.662 161.166  1.00 45.92           O  
ATOM    785  N   ARG   110      -2.588  12.025 161.304  1.00 42.31           N  
ATOM    786  CA  ARG   110      -2.488  13.132 162.250  1.00 41.07           C  
ATOM    787  C   ARG   110      -2.082  14.447 161.587  1.00 40.37           C  
ATOM    788  O   ARG   110      -2.299  15.523 162.138  1.00 38.73           O  
ATOM    789  CB  ARG   110      -1.468  12.805 163.339  1.00 41.93           C  
ATOM    790  CG  ARG   110      -1.842  11.684 164.295  1.00 39.91           C  
ATOM    791  CD  ARG   110      -3.104  12.011 165.079  1.00 39.10           C  
ATOM    792  NE  ARG   110      -3.127  13.356 165.664  1.00 35.37           N  
ATOM    793  CZ  ARG   110      -2.421  13.741 166.723  1.00 36.20           C  
ATOM    794  NH1 ARG   110      -1.620  12.889 167.337  1.00 32.35           N  
ATOM    795  NH2 ARG   110      -2.556  14.974 167.196  1.00 34.00           N  
ATOM    796  N   VAL   111      -1.499  14.351 160.399  1.00 39.59           N  
ATOM    797  CA  VAL   111      -1.040  15.528 159.674  1.00 38.83           C  
ATOM    798  C   VAL   111      -1.701  15.708 158.309  1.00 38.15           C  
ATOM    799  O   VAL   111      -2.128  14.745 157.676  1.00 37.24           O  
ATOM    800  CB  VAL   111       0.491  15.488 159.473  1.00 38.00           C  
ATOM    801  CG1 VAL   111       0.929  16.615 158.551  1.00 42.01           C  
ATOM    802  CG2 VAL   111       1.206  15.614 160.820  1.00 38.16           C  
ATOM    803  N   ARG   112      -1.765  16.957 157.867  1.00 36.98           N  
ATOM    804  CA  ARG   112      -2.351  17.300 156.590  1.00 36.33           C  
ATOM    805  C   ARG   112      -1.513  18.435 156.001  1.00 35.66           C  
ATOM    806  O   ARG   112      -1.324  19.472 156.648  1.00 36.99           O  
ATOM    807  CB  ARG   112      -3.798  17.750 156.830  1.00 36.34           C  
ATOM    808  CG  ARG   112      -4.485  18.397 155.660  1.00 37.42           C  
ATOM    809  CD  ARG   112      -5.397  19.503 156.170  1.00 40.20           C  
ATOM    810  NE  ARG   112      -6.749  19.400 155.634  1.00 45.44           N  
ATOM    811  CZ  ARG   112      -7.756  20.191 155.991  1.00 48.74           C  
ATOM    812  NH1 ARG   112      -7.573  21.156 156.889  1.00 49.80           N  
ATOM    813  NH2 ARG   112      -8.947  20.016 155.443  1.00 49.68           N  
ATOM    814  N   PHE   113      -1.009  18.253 154.784  1.00 34.58           N  
ATOM    815  CA  PHE   113      -0.209  19.303 154.170  1.00 35.15           C  
ATOM    816  C   PHE   113      -0.932  19.949 152.991  1.00 35.07           C  
ATOM    817  O   PHE   113      -1.384  19.270 152.067  1.00 37.67           O  
ATOM    818  CB  PHE   113       1.151  18.766 153.708  1.00 34.40           C  
ATOM    819  CG  PHE   113       2.229  19.827 153.643  1.00 36.00           C  
ATOM    820  CD1 PHE   113       3.235  19.879 154.609  1.00 36.27           C  
ATOM    821  CD2 PHE   113       2.207  20.800 152.650  1.00 32.65           C  
ATOM    822  CE1 PHE   113       4.199  20.895 154.590  1.00 33.82           C  
ATOM    823  CE2 PHE   113       3.163  21.815 152.616  1.00 34.72           C  
ATOM    824  CZ  PHE   113       4.163  21.865 153.589  1.00 33.01           C  
ATOM    825  N   LEU   114      -1.054  21.268 153.029  1.00 35.24           N  
ATOM    826  CA  LEU   114      -1.704  21.989 151.942  1.00 35.75           C  
ATOM    827  C   LEU   114      -0.634  22.776 151.168  1.00 36.12           C  
ATOM    828  O   LEU   114      -0.129  23.802 151.642  1.00 33.29           O  
ATOM    829  CB  LEU   114      -2.781  22.950 152.484  1.00 35.98           C  
ATOM    830  CG  LEU   114      -3.800  22.374 153.479  1.00 35.98           C  
ATOM    831  CD1 LEU   114      -4.787  23.453 153.902  1.00 30.83           C  
ATOM    832  CD2 LEU   114      -4.537  21.206 152.840  1.00 37.70           C  
ATOM    833  N   LEU   115      -0.291  22.272 149.982  1.00 36.66           N  
ATOM    834  CA  LEU   115       0.698  22.896 149.101  1.00 36.42           C  
ATOM    835  C   LEU   115       0.067  24.159 148.511  1.00 37.94           C  
ATOM    836  O   LEU   115      -0.413  24.156 147.371  1.00 37.92           O  
ATOM    837  CB  LEU   115       1.058  21.957 147.946  1.00 36.58           C  
ATOM    838  CG  LEU   115       2.472  21.414 147.736  1.00 37.22           C  
ATOM    839  CD1 LEU   115       2.652  21.168 146.230  1.00 32.33           C  
ATOM    840  CD2 LEU   115       3.537  22.398 148.235  1.00 31.00           C  
ATOM    841  N   SER   116       0.089  25.248 149.270  1.00 38.17           N  
ATOM    842  CA  SER   116      -0.526  26.495 148.825  1.00 39.28           C  
ATOM    843  C   SER   116       0.103  27.704 149.496  1.00 41.12           C  
ATOM    844  O   SER   116       0.891  27.567 150.442  1.00 40.46           O  
ATOM    845  CB  SER   116      -2.007  26.513 149.183  1.00 40.19           C  
ATOM    846  OG  SER   116      -2.470  25.254 149.656  1.00 42.22           O  
ATOM    847  N   ARG   117      -0.255  28.884 149.007  1.00 41.80           N  
ATOM    848  CA  ARG   117       0.210  30.105 149.614  1.00 42.60           C  
ATOM    849  C   ARG   117      -0.825  30.243 150.739  1.00 40.98           C  
ATOM    850  O   ARG   117      -2.039  30.078 150.529  1.00 41.28           O  
ATOM    851  CB  ARG   117       0.122  31.272 148.622  1.00 43.51           C  
ATOM    852  CG  ARG   117       0.859  30.961 147.339  1.00 49.76           C  
ATOM    853  CD  ARG   117       0.563  31.978 146.265  1.00 60.03           C  
ATOM    854  NE  ARG   117       0.982  33.320 146.662  1.00 67.32           N  
ATOM    855  CZ  ARG   117       1.017  34.367 145.842  1.00 67.66           C  
ATOM    856  NH1 ARG   117       0.659  34.231 144.571  1.00 67.92           N  
ATOM    857  NH2 ARG   117       1.413  35.550 146.293  1.00 68.00           N  
ATOM    858  N   PRO   118      -0.364  30.529 151.957  1.00 41.33           N  
ATOM    859  CA  PRO   118      -1.223  30.686 153.140  1.00 40.61           C  
ATOM    860  C   PRO   118      -2.504  31.479 152.927  1.00 39.64           C  
ATOM    861  O   PRO   118      -3.607  30.990 153.181  1.00 39.78           O  
ATOM    862  CB  PRO   118      -0.316  31.394 154.142  1.00 40.65           C  
ATOM    863  CG  PRO   118       1.041  30.954 153.775  1.00 41.68           C  
ATOM    864  CD  PRO   118       1.033  30.880 152.272  1.00 40.50           C  
ATOM    865  N   LEU   119      -2.343  32.715 152.460  1.00 41.33           N  
ATOM    866  CA  LEU   119      -3.471  33.595 152.279  1.00 43.36           C  
ATOM    867  C   LEU   119      -4.460  33.221 151.192  1.00 43.28           C  
ATOM    868  O   LEU   119      -5.565  33.763 151.135  1.00 43.18           O  
ATOM    869  CB  LEU   119      -2.962  35.032 152.110  1.00 44.68           C  
ATOM    870  CG  LEU   119      -2.149  35.568 153.306  1.00 47.79           C  
ATOM    871  CD1 LEU   119      -1.613  36.954 152.971  1.00 48.36           C  
ATOM    872  CD2 LEU   119      -3.017  35.620 154.562  1.00 48.43           C  
ATOM    873  N   ASP   120      -4.069  32.285 150.344  1.00 42.99           N  
ATOM    874  CA  ASP   120      -4.950  31.832 149.284  1.00 43.56           C  
ATOM    875  C   ASP   120      -5.859  30.709 149.778  1.00 42.46           C  
ATOM    876  O   ASP   120      -7.049  30.704 149.496  1.00 42.73           O  
ATOM    877  CB  ASP   120      -4.136  31.320 148.091  1.00 45.08           C  
ATOM    878  CG  ASP   120      -3.630  32.435 147.194  1.00 47.02           C  
ATOM    879  OD1 ASP   120      -2.502  32.322 146.665  1.00 52.57           O  
ATOM    880  OD2 ASP   120      -4.368  33.418 147.002  1.00 54.08           O  
ATOM    881  N   VAL   121      -5.295  29.775 150.541  1.00 41.31           N  
ATOM    882  CA  VAL   121      -6.037  28.611 151.013  1.00 39.94           C  
ATOM    883  C   VAL   121      -6.808  28.725 152.327  1.00 40.84           C  
ATOM    884  O   VAL   121      -7.690  27.907 152.604  1.00 38.80           O  
ATOM    885  CB  VAL   121      -5.094  27.400 151.086  1.00 39.13           C  
ATOM    886  CG1 VAL   121      -4.188  27.521 152.303  1.00 37.68           C  
ATOM    887  CG2 VAL   121      -5.882  26.106 151.110  1.00 37.94           C  
ATOM    888  N   MET   122      -6.475  29.722 153.134  1.00 42.29           N  
ATOM    889  CA  MET   122      -7.166  29.906 154.395  1.00 43.80           C  
ATOM    890  C   MET   122      -8.616  30.270 154.106  1.00 44.00           C  
ATOM    891  O   MET   122      -9.498  30.116 154.952  1.00 42.06           O  
ATOM    892  CB  MET   122      -6.466  30.986 155.225  1.00 44.01           C  
ATOM    893  CG  MET   122      -5.380  30.396 156.117  1.00 49.56           C  
ATOM    894  SD  MET   122      -4.119  31.725 156.693  1.00 61.27          SE  
ATOM    895  CE  MET   122      -2.501  30.840 156.177  1.00 61.36           C  
ATOM    896  N   SER   123      -8.852  30.740 152.885  1.00 45.14           N  
ATOM    897  CA  SER   123     -10.192  31.101 152.429  1.00 44.45           C  
ATOM    898  C   SER   123     -11.012  29.812 152.270  1.00 42.51           C  
ATOM    899  O   SER   123     -12.239  29.841 152.214  1.00 42.47           O  
ATOM    900  CB  SER   123     -10.104  31.792 151.072  1.00 44.03           C  
ATOM    901  OG  SER   123     -11.332  32.400 150.721  1.00 50.55           O  
ATOM    902  N   ARG   124     -10.320  28.682 152.204  1.00 39.98           N  
ATOM    903  CA  ARG   124     -10.938  27.375 151.993  1.00 39.77           C  
ATOM    904  C   ARG   124     -11.079  26.481 153.218  1.00 39.26           C  
ATOM    905  O   ARG   124     -11.430  25.302 153.091  1.00 38.53           O  
ATOM    906  CB  ARG   124     -10.144  26.624 150.927  1.00 39.41           C  
ATOM    907  CG  ARG   124     -10.516  26.921 149.478  1.00 39.67           C  
ATOM    908  CD  ARG   124     -10.214  28.346 149.054  1.00 34.87           C  
ATOM    909  NE  ARG   124     -10.183  28.446 147.599  1.00 37.32           N  
ATOM    910  CZ  ARG   124     -10.506  29.535 146.908  1.00 38.08           C  
ATOM    911  NH1 ARG   124     -10.895  30.633 147.538  1.00 40.47           N  
ATOM    912  NH2 ARG   124     -10.456  29.519 145.584  1.00 35.95           N  
ATOM    913  N   LEU   125     -10.807  27.038 154.392  1.00 38.20           N  
ATOM    914  CA  LEU   125     -10.896  26.266 155.616  1.00 37.17           C  
ATOM    915  C   LEU   125     -12.133  26.675 156.405  1.00 35.40           C  
ATOM    916  O   LEU   125     -12.668  27.759 156.217  1.00 35.38           O  
ATOM    917  CB  LEU   125      -9.612  26.457 156.446  1.00 36.51           C  
ATOM    918  CG  LEU   125      -8.289  26.098 155.744  1.00 34.19           C  
ATOM    919  CD1 LEU   125      -7.122  26.588 156.596  1.00 35.46           C  
ATOM    920  CD2 LEU   125      -8.189  24.592 155.505  1.00 33.35           C  
ATOM    921  N   ALA   126     -12.583  25.798 157.291  1.00 36.45           N  
ATOM    922  CA  ALA   126     -13.782  26.061 158.076  1.00 37.46           C  
ATOM    923  C   ALA   126     -13.588  27.043 159.223  1.00 37.94           C  
ATOM    924  O   ALA   126     -12.660  26.912 160.014  1.00 36.91           O  
ATOM    925  CB  ALA   126     -14.351  24.735 158.604  1.00 38.14           C  
ATOM    926  N   ASN   127     -14.479  28.026 159.299  1.00 37.51           N  
ATOM    927  CA  ASN   127     -14.436  29.028 160.357  1.00 39.25           C  
ATOM    928  C   ASN   127     -14.698  28.410 161.736  1.00 38.25           C  
ATOM    929  O   ASN   127     -15.415  27.410 161.853  1.00 37.89           O  
ATOM    930  CB  ASN   127     -15.499  30.104 160.130  1.00 38.20           C  
ATOM    931  CG  ASN   127     -15.109  31.115 159.077  1.00 45.54           C  
ATOM    932  OD1 ASN   127     -13.925  31.365 158.846  1.00 47.80           O  
ATOM    933  ND2 ASN   127     -16.114  31.728 158.440  1.00 50.71           N  
ATOM    934  N   ASP   128     -14.100  28.996 162.773  1.00 39.07           N  
ATOM    935  CA  ASP   128     -14.333  28.545 164.147  1.00 39.00           C  
ATOM    936  C   ASP   128     -14.037  27.068 164.369  1.00 37.42           C  
ATOM    937  O   ASP   128     -14.761  26.386 165.099  1.00 36.97           O  
ATOM    938  CB  ASP   128     -15.802  28.840 164.494  1.00 40.06           C  
ATOM    939  CG  ASP   128     -16.097  28.760 165.988  1.00 42.55           C  
ATOM    940  OD1 ASP   128     -15.284  29.278 166.781  1.00 42.74           O  
ATOM    941  OD2 ASP   128     -17.152  28.195 166.370  1.00 38.11           O  
ATOM    942  N   SER   129     -12.967  26.573 163.763  1.00 35.37           N  
ATOM    943  CA  SER   129     -12.636  25.160 163.890  1.00 34.54           C  
ATOM    944  C   SER   129     -11.245  24.857 164.426  1.00 31.43           C  
ATOM    945  O   SER   129     -10.918  23.699 164.679  1.00 32.63           O  
ATOM    946  CB  SER   129     -12.782  24.477 162.536  1.00 35.03           C  
ATOM    947  OG  SER   129     -14.099  24.034 162.294  1.00 37.23           O  
ATOM    948  N   TYR   130     -10.431  25.884 164.620  1.00 29.68           N  
ATOM    949  CA  TYR   130      -9.071  25.668 165.066  1.00 28.67           C  
ATOM    950  C   TYR   130      -8.751  26.269 166.423  1.00 28.72           C  
ATOM    951  O   TYR   130      -9.163  27.382 166.738  1.00 29.68           O  
ATOM    952  CB  TYR   130      -8.121  26.196 163.986  1.00 28.26           C  
ATOM    953  CG  TYR   130      -8.274  25.464 162.664  1.00 29.26           C  
ATOM    954  CD1 TYR   130      -7.600  24.263 162.430  1.00 29.35           C  
ATOM    955  CD2 TYR   130      -9.172  25.915 161.692  1.00 28.46           C  
ATOM    956  CE1 TYR   130      -7.803  23.531 161.259  1.00 26.56           C  
ATOM    957  CE2 TYR   130      -9.386  25.194 160.518  1.00 29.12           C  
ATOM    958  CZ  TYR   130      -8.700  23.994 160.313  1.00 29.08           C  
ATOM    959  OH  TYR   130      -8.905  23.276 159.154  1.00 27.26           O  
ATOM    960  N   GLN   131      -7.995  25.514 167.214  1.00 28.03           N  
ATOM    961  CA  GLN   131      -7.601  25.922 168.557  1.00 27.77           C  
ATOM    962  C   GLN   131      -6.230  26.599 168.607  1.00 27.85           C  
ATOM    963  O   GLN   131      -5.884  27.249 169.598  1.00 29.71           O  
ATOM    964  CB  GLN   131      -7.569  24.700 169.472  1.00 26.77           C  
ATOM    965  CG  GLN   131      -6.362  23.790 169.188  1.00 26.44           C  
ATOM    966  CD  GLN   131      -6.491  22.396 169.781  1.00 24.98           C  
ATOM    967  OE1 GLN   131      -5.943  22.106 170.843  1.00 24.78           O  
ATOM    968  NE2 GLN   131      -7.231  21.533 169.101  1.00 20.94           N  
ATOM    969  N   LEU   132      -5.446  26.448 167.546  1.00 27.47           N  
ATOM    970  CA  LEU   132      -4.105  27.023 167.532  1.00 26.57           C  
ATOM    971  C   LEU   132      -3.590  27.236 166.115  1.00 27.51           C  
ATOM    972  O   LEU   132      -3.679  26.349 165.264  1.00 29.60           O  
ATOM    973  CB  LEU   132      -3.137  26.104 168.301  1.00 25.75           C  
ATOM    974  CG  LEU   132      -1.629  26.415 168.296  1.00 29.37           C  
ATOM    975  CD1 LEU   132      -1.363  27.685 169.099  1.00 27.98           C  
ATOM    976  CD2 LEU   132      -0.842  25.243 168.885  1.00 27.03           C  
ATOM    977  N   VAL   133      -3.055  28.424 165.864  1.00 26.58           N  
ATOM    978  CA  VAL   133      -2.498  28.739 164.566  1.00 25.15           C  
ATOM    979  C   VAL   133      -1.139  29.410 164.763  1.00 26.35           C  
ATOM    980  O   VAL   133      -1.017  30.422 165.456  1.00 26.47           O  
ATOM    981  CB  VAL   133      -3.439  29.670 163.752  1.00 25.87           C  
ATOM    982  CG1 VAL   133      -2.807  30.010 162.398  1.00 25.01           C  
ATOM    983  CG2 VAL   133      -4.791  28.987 163.550  1.00 20.36           C  
ATOM    984  N   PHE   134      -0.113  28.818 164.169  1.00 25.32           N  
ATOM    985  CA  PHE   134       1.234  29.356 164.232  1.00 26.86           C  
ATOM    986  C   PHE   134       1.555  29.901 162.847  1.00 27.34           C  
ATOM    987  O   PHE   134       1.374  29.218 161.827  1.00 28.20           O  
ATOM    988  CB  PHE   134       2.266  28.275 164.582  1.00 26.10           C  
ATOM    989  CG  PHE   134       3.687  28.747 164.450  1.00 25.49           C  
ATOM    990  CD1 PHE   134       4.311  29.429 165.490  1.00 24.26           C  
ATOM    991  CD2 PHE   134       4.389  28.539 163.263  1.00 29.08           C  
ATOM    992  CE1 PHE   134       5.619  29.914 165.342  1.00 28.36           C  
ATOM    993  CE2 PHE   134       5.692  29.020 163.101  1.00 32.22           C  
ATOM    994  CZ  PHE   134       6.312  29.704 164.146  1.00 32.15           C  
ATOM    995  N   GLY   135       2.023  31.142 162.815  1.00 28.79           N  
ATOM    996  CA  GLY   135       2.375  31.753 161.551  1.00 28.63           C  
ATOM    997  C   GLY   135       3.800  32.285 161.495  1.00 29.23           C  
ATOM    998  O   GLY   135       4.256  32.988 162.400  1.00 26.26           O  
ATOM    999  N   GLN   136       4.525  31.894 160.454  1.00 30.13           N  
ATOM   1000  CA  GLN   136       5.876  32.386 160.239  1.00 33.40           C  
ATOM   1001  C   GLN   136       5.803  33.029 158.850  1.00 35.44           C  
ATOM   1002  O   GLN   136       5.966  32.367 157.820  1.00 36.80           O  
ATOM   1003  CB  GLN   136       6.918  31.255 160.234  1.00 32.41           C  
ATOM   1004  CG  GLN   136       8.323  31.769 159.955  1.00 33.06           C  
ATOM   1005  CD  GLN   136       9.078  32.162 161.210  1.00 33.64           C  
ATOM   1006  OE1 GLN   136       9.444  33.324 161.394  1.00 35.68           O  
ATOM   1007  NE2 GLN   136       9.320  31.192 162.080  1.00 29.90           N  
ATOM   1008  N   VAL   137       5.562  34.331 158.825  1.00 36.19           N  
ATOM   1009  CA  VAL   137       5.419  35.064 157.572  1.00 38.42           C  
ATOM   1010  C   VAL   137       6.248  36.342 157.564  1.00 41.25           C  
ATOM   1011  O   VAL   137       6.896  36.680 158.560  1.00 41.64           O  
ATOM   1012  CB  VAL   137       3.930  35.432 157.329  1.00 36.88           C  
ATOM   1013  CG1 VAL   137       3.080  34.166 157.285  1.00 34.48           C  
ATOM   1014  CG2 VAL   137       3.421  36.348 158.450  1.00 35.11           C  
ATOM   1015  N   SER   138       6.228  37.044 156.433  1.00 41.77           N  
ATOM   1016  CA  SER   138       6.941  38.307 156.320  1.00 41.93           C  
ATOM   1017  C   SER   138       6.078  39.351 157.022  1.00 41.25           C  
ATOM   1018  O   SER   138       4.846  39.232 157.063  1.00 40.59           O  
ATOM   1019  CB  SER   138       7.123  38.712 154.859  1.00 42.90           C  
ATOM   1020  OG  SER   138       8.000  37.823 154.205  1.00 48.55           O  
ATOM   1021  N   PRO   139       6.712  40.382 157.589  1.00 42.32           N  
ATOM   1022  CA  PRO   139       6.007  41.457 158.292  1.00 43.29           C  
ATOM   1023  C   PRO   139       4.924  42.111 157.442  1.00 45.67           C  
ATOM   1024  O   PRO   139       3.968  42.681 157.974  1.00 46.01           O  
ATOM   1025  CB  PRO   139       7.131  42.436 158.684  1.00 43.98           C  
ATOM   1026  CG  PRO   139       8.358  41.958 157.932  1.00 42.13           C  
ATOM   1027  CD  PRO   139       8.170  40.487 157.766  1.00 41.37           C  
ATOM   1028  N   MET   140       5.071  42.035 156.123  1.00 47.45           N  
ATOM   1029  CA  MET   140       4.076  42.638 155.239  1.00 49.28           C  
ATOM   1030  C   MET   140       2.823  41.772 155.122  1.00 47.01           C  
ATOM   1031  O   MET   140       1.779  42.231 154.660  1.00 47.15           O  
ATOM   1032  CB  MET   140       4.690  42.930 153.855  1.00 51.82           C  
ATOM   1033  CG  MET   140       5.654  44.141 153.862  1.00 59.82           C  
ATOM   1034  SD  MET   140       5.021  45.728 152.904  1.00 78.54          SE  
ATOM   1035  CE  MET   140       3.104  45.465 153.043  1.00 71.46           C  
ATOM   1036  N   ASP   141       2.921  40.519 155.556  1.00 44.94           N  
ATOM   1037  CA  ASP   141       1.783  39.606 155.512  1.00 41.78           C  
ATOM   1038  C   ASP   141       1.064  39.456 156.859  1.00 40.48           C  
ATOM   1039  O   ASP   141      -0.003  38.844 156.926  1.00 39.11           O  
ATOM   1040  CB  ASP   141       2.233  38.221 155.051  1.00 42.04           C  
ATOM   1041  CG  ASP   141       2.523  38.160 153.568  1.00 43.17           C  
ATOM   1042  OD1 ASP   141       1.754  38.773 152.809  1.00 41.63           O  
ATOM   1043  OD2 ASP   141       3.497  37.487 153.159  1.00 43.95           O  
ATOM   1044  N   LEU   142       1.630  40.029 157.922  1.00 40.15           N  
ATOM   1045  CA  LEU   142       1.058  39.873 159.259  1.00 39.48           C  
ATOM   1046  C   LEU   142      -0.394  40.231 159.457  1.00 39.93           C  
ATOM   1047  O   LEU   142      -1.167  39.431 159.997  1.00 40.66           O  
ATOM   1048  CB  LEU   142       1.924  40.590 160.300  1.00 38.67           C  
ATOM   1049  CG  LEU   142       3.300  39.975 160.600  1.00 38.68           C  
ATOM   1050  CD1 LEU   142       4.112  40.933 161.458  1.00 42.38           C  
ATOM   1051  CD2 LEU   142       3.129  38.637 161.311  1.00 38.58           C  
ATOM   1052  N   LYS   143      -0.757  41.420 159.004  1.00 38.96           N  
ATOM   1053  CA  LYS   143      -2.117  41.903 159.110  1.00 39.51           C  
ATOM   1054  C   LYS   143      -3.068  40.971 158.364  1.00 39.15           C  
ATOM   1055  O   LYS   143      -4.116  40.575 158.884  1.00 40.10           O  
ATOM   1056  CB  LYS   143      -2.215  43.303 158.502  1.00 40.31           C  
ATOM   1057  CG  LYS   143      -3.030  44.294 159.323  1.00 43.90           C  
ATOM   1058  CD  LYS   143      -4.008  45.096 158.470  1.00 49.29           C  
ATOM   1059  CE  LYS   143      -5.421  44.522 158.568  1.00 53.76           C  
ATOM   1060  NZ  LYS   143      -6.429  45.319 157.813  1.00 56.00           N  
ATOM   1061  N   ALA   144      -2.700  40.623 157.138  1.00 39.14           N  
ATOM   1062  CA  ALA   144      -3.530  39.752 156.316  1.00 38.68           C  
ATOM   1063  C   ALA   144      -3.670  38.382 156.968  1.00 38.00           C  
ATOM   1064  O   ALA   144      -4.731  37.759 156.900  1.00 38.66           O  
ATOM   1065  CB  ALA   144      -2.929  39.621 154.911  1.00 37.15           C  
ATOM   1066  N   LEU   145      -2.602  37.918 157.611  1.00 37.83           N  
ATOM   1067  CA  LEU   145      -2.646  36.621 158.263  1.00 37.23           C  
ATOM   1068  C   LEU   145      -3.621  36.667 159.451  1.00 37.14           C  
ATOM   1069  O   LEU   145      -4.358  35.707 159.691  1.00 36.62           O  
ATOM   1070  CB  LEU   145      -1.235  36.188 158.718  1.00 36.77           C  
ATOM   1071  CG  LEU   145      -1.168  34.756 159.271  1.00 39.44           C  
ATOM   1072  CD1 LEU   145      -1.620  33.766 158.186  1.00 37.20           C  
ATOM   1073  CD2 LEU   145       0.252  34.435 159.742  1.00 35.79           C  
ATOM   1074  N   VAL   146      -3.629  37.782 160.184  1.00 37.71           N  
ATOM   1075  CA  VAL   146      -4.521  37.956 161.337  1.00 37.17           C  
ATOM   1076  C   VAL   146      -5.980  37.944 160.885  1.00 38.38           C  
ATOM   1077  O   VAL   146      -6.835  37.306 161.498  1.00 37.63           O  
ATOM   1078  CB  VAL   146      -4.253  39.297 162.050  1.00 36.80           C  
ATOM   1079  CG1 VAL   146      -5.205  39.467 163.214  1.00 35.48           C  
ATOM   1080  CG2 VAL   146      -2.811  39.358 162.525  1.00 37.51           C  
ATOM   1081  N   ASP   147      -6.256  38.672 159.807  1.00 39.95           N  
ATOM   1082  CA  ASP   147      -7.606  38.754 159.260  1.00 38.92           C  
ATOM   1083  C   ASP   147      -8.037  37.403 158.725  1.00 38.35           C  
ATOM   1084  O   ASP   147      -9.206  37.036 158.812  1.00 42.00           O  
ATOM   1085  CB  ASP   147      -7.668  39.792 158.136  1.00 40.05           C  
ATOM   1086  CG  ASP   147      -7.366  41.190 158.624  1.00 41.34           C  
ATOM   1087  OD1 ASP   147      -7.807  41.532 159.743  1.00 43.67           O  
ATOM   1088  OD2 ASP   147      -6.697  41.948 157.892  1.00 43.65           O  
ATOM   1089  N   ALA   148      -7.085  36.658 158.171  1.00 36.95           N  
ATOM   1090  CA  ALA   148      -7.374  35.335 157.625  1.00 34.18           C  
ATOM   1091  C   ALA   148      -7.538  34.295 158.726  1.00 34.08           C  
ATOM   1092  O   ALA   148      -8.441  33.463 158.683  1.00 31.80           O  
ATOM   1093  CB  ALA   148      -6.259  34.907 156.667  1.00 33.64           C  
ATOM   1094  N   ALA   149      -6.658  34.343 159.716  1.00 33.69           N  
ATOM   1095  CA  ALA   149      -6.696  33.377 160.798  1.00 33.43           C  
ATOM   1096  C   ALA   149      -7.799  33.579 161.834  1.00 33.55           C  
ATOM   1097  O   ALA   149      -8.396  32.609 162.312  1.00 34.44           O  
ATOM   1098  CB  ALA   149      -5.327  33.330 161.489  1.00 34.63           C  
ATOM   1099  N   TRP   150      -8.088  34.830 162.172  1.00 35.02           N  
ATOM   1100  CA  TRP   150      -9.084  35.104 163.208  1.00 35.52           C  
ATOM   1101  C   TRP   150     -10.392  34.341 163.089  1.00 36.07           C  
ATOM   1102  O   TRP   150     -10.829  33.698 164.051  1.00 36.77           O  
ATOM   1103  CB  TRP   150      -9.368  36.609 163.312  1.00 36.87           C  
ATOM   1104  CG  TRP   150      -9.881  37.006 164.678  1.00 39.34           C  
ATOM   1105  CD1 TRP   150     -11.103  37.530 164.976  1.00 38.91           C  
ATOM   1106  CD2 TRP   150      -9.185  36.875 165.928  1.00 38.85           C  
ATOM   1107  NE1 TRP   150     -11.213  37.738 166.333  1.00 40.42           N  
ATOM   1108  CE2 TRP   150     -10.049  37.348 166.940  1.00 39.56           C  
ATOM   1109  CE3 TRP   150      -7.910  36.414 166.288  1.00 40.01           C  
ATOM   1110  CZ2 TRP   150      -9.686  37.359 168.296  1.00 38.56           C  
ATOM   1111  CZ3 TRP   150      -7.546  36.428 167.635  1.00 41.47           C  
ATOM   1112  CH2 TRP   150      -8.431  36.904 168.620  1.00 41.64           C  
ATOM   1113  N   PRO   151     -11.030  34.386 161.912  1.00 36.28           N  
ATOM   1114  CA  PRO   151     -12.297  33.668 161.748  1.00 36.18           C  
ATOM   1115  C   PRO   151     -12.183  32.164 161.992  1.00 34.50           C  
ATOM   1116  O   PRO   151     -13.130  31.534 162.451  1.00 34.71           O  
ATOM   1117  CB  PRO   151     -12.690  33.958 160.295  1.00 37.11           C  
ATOM   1118  CG  PRO   151     -11.968  35.221 159.959  1.00 37.77           C  
ATOM   1119  CD  PRO   151     -10.652  35.100 160.679  1.00 35.64           C  
ATOM   1120  N   LEU   152     -11.022  31.593 161.679  1.00 34.79           N  
ATOM   1121  CA  LEU   152     -10.801  30.153 161.836  1.00 35.06           C  
ATOM   1122  C   LEU   152     -10.602  29.733 163.289  1.00 34.90           C  
ATOM   1123  O   LEU   152     -10.874  28.596 163.669  1.00 35.83           O  
ATOM   1124  CB  LEU   152      -9.588  29.721 161.011  1.00 35.31           C  
ATOM   1125  CG  LEU   152      -9.532  30.146 159.535  1.00 32.06           C  
ATOM   1126  CD1 LEU   152      -8.139  29.863 158.949  1.00 28.65           C  
ATOM   1127  CD2 LEU   152     -10.608  29.410 158.747  1.00 30.78           C  
ATOM   1128  N   LEU   153     -10.130  30.668 164.101  1.00 36.20           N  
ATOM   1129  CA  LEU   153      -9.865  30.413 165.514  1.00 35.55           C  
ATOM   1130  C   LEU   153     -11.086  30.273 166.380  1.00 35.15           C  
ATOM   1131  O   LEU   153     -12.043  31.021 166.223  1.00 36.38           O  
ATOM   1132  CB  LEU   153      -9.014  31.525 166.110  1.00 34.73           C  
ATOM   1133  CG  LEU   153      -7.490  31.460 166.042  1.00 35.40           C  
ATOM   1134  CD1 LEU   153      -6.906  32.700 166.722  1.00 37.52           C  
ATOM   1135  CD2 LEU   153      -6.991  30.175 166.744  1.00 23.36           C  
ATOM   1136  N   ARG   154     -11.058  29.310 167.296  1.00 36.30           N  
ATOM   1137  CA  ARG   154     -12.162  29.145 168.232  1.00 36.51           C  
ATOM   1138  C   ARG   154     -11.818  30.000 169.474  1.00 36.76           C  
ATOM   1139  O   ARG   154     -10.651  30.379 169.676  1.00 33.72           O  
ATOM   1140  CB  ARG   154     -12.319  27.674 168.634  1.00 36.75           C  
ATOM   1141  CG  ARG   154     -12.718  26.785 167.478  1.00 37.06           C  
ATOM   1142  CD  ARG   154     -12.577  25.313 167.811  1.00 37.83           C  
ATOM   1143  NE  ARG   154     -13.585  24.850 168.759  1.00 45.05           N  
ATOM   1144  CZ  ARG   154     -14.877  24.707 168.473  1.00 47.28           C  
ATOM   1145  NH1 ARG   154     -15.331  24.991 167.257  1.00 41.82           N  
ATOM   1146  NH2 ARG   154     -15.710  24.265 169.404  1.00 47.48           N  
ATOM   1147  N   ARG   155     -12.823  30.308 170.295  1.00 37.44           N  
ATOM   1148  CA  ARG   155     -12.610  31.086 171.514  1.00 37.17           C  
ATOM   1149  C   ARG   155     -11.747  30.192 172.403  1.00 35.22           C  
ATOM   1150  O   ARG   155     -11.978  28.975 172.493  1.00 36.48           O  
ATOM   1151  CB  ARG   155     -13.961  31.403 172.183  1.00 38.81           C  
ATOM   1152  CG  ARG   155     -14.937  32.087 171.233  1.00 42.34           C  
ATOM   1153  CD  ARG   155     -16.218  32.427 171.953  1.00 47.96           C  
ATOM   1154  NE  ARG   155     -16.064  33.616 172.784  1.00 54.25           N  
ATOM   1155  CZ  ARG   155     -16.418  34.843 172.409  1.00 56.26           C  
ATOM   1156  NH1 ARG   155     -16.953  35.045 171.210  1.00 56.53           N  
ATOM   1157  NH2 ARG   155     -16.230  35.868 173.234  1.00 56.32           N  
ATOM   1158  N   GLY   156     -10.764  30.799 173.062  1.00 32.13           N  
ATOM   1159  CA  GLY   156      -9.822  30.049 173.880  1.00 30.79           C  
ATOM   1160  C   GLY   156      -8.670  29.644 172.940  1.00 29.86           C  
ATOM   1161  O   GLY   156      -7.673  29.034 173.361  1.00 28.96           O  
ATOM   1162  N   GLY   157      -8.795  30.009 171.657  1.00 28.58           N  
ATOM   1163  CA  GLY   157      -7.783  29.685 170.652  1.00 26.53           C  
ATOM   1164  C   GLY   157      -6.719  30.750 170.521  1.00 26.35           C  
ATOM   1165  O   GLY   157      -6.981  31.934 170.724  1.00 26.49           O  
ATOM   1166  N   ALA   158      -5.517  30.330 170.143  1.00 26.28           N  
ATOM   1167  CA  ALA   158      -4.402  31.253 170.021  1.00 26.53           C  
ATOM   1168  C   ALA   158      -3.752  31.338 168.663  1.00 27.37           C  
ATOM   1169  O   ALA   158      -3.498  30.317 168.023  1.00 27.64           O  
ATOM   1170  CB  ALA   158      -3.333  30.924 171.057  1.00 24.38           C  
ATOM   1171  N   LEU   159      -3.468  32.568 168.245  1.00 28.32           N  
ATOM   1172  CA  LEU   159      -2.747  32.823 167.013  1.00 28.11           C  
ATOM   1173  C   LEU   159      -1.342  33.223 167.503  1.00 27.21           C  
ATOM   1174  O   LEU   159      -1.189  34.162 168.296  1.00 26.79           O  
ATOM   1175  CB  LEU   159      -3.371  33.994 166.234  1.00 28.52           C  
ATOM   1176  CG  LEU   159      -2.577  34.518 165.030  1.00 31.81           C  
ATOM   1177  CD1 LEU   159      -2.417  33.424 163.973  1.00 33.87           C  
ATOM   1178  CD2 LEU   159      -3.322  35.715 164.451  1.00 31.17           C  
ATOM   1179  N   VAL   160      -0.322  32.501 167.047  1.00 25.88           N  
ATOM   1180  CA  VAL   160       1.064  32.772 167.428  1.00 24.79           C  
ATOM   1181  C   VAL   160       1.858  33.296 166.232  1.00 27.75           C  
ATOM   1182  O   VAL   160       2.033  32.591 165.232  1.00 26.63           O  
ATOM   1183  CB  VAL   160       1.738  31.501 167.987  1.00 24.17           C  
ATOM   1184  CG1 VAL   160       3.150  31.821 168.438  1.00 23.11           C  
ATOM   1185  CG2 VAL   160       0.923  30.964 169.163  1.00 19.43           C  
ATOM   1186  N   LEU   161       2.338  34.537 166.340  1.00 29.92           N  
ATOM   1187  CA  LEU   161       3.088  35.183 165.258  1.00 31.39           C  
ATOM   1188  C   LEU   161       4.569  35.347 165.580  1.00 33.08           C  
ATOM   1189  O   LEU   161       4.957  36.203 166.376  1.00 32.56           O  
ATOM   1190  CB  LEU   161       2.467  36.550 164.943  1.00 31.04           C  
ATOM   1191  CG  LEU   161       0.954  36.513 164.655  1.00 29.82           C  
ATOM   1192  CD1 LEU   161       0.395  37.937 164.570  1.00 26.88           C  
ATOM   1193  CD2 LEU   161       0.693  35.749 163.363  1.00 26.34           C  
ATOM   1194  N   ALA   162       5.394  34.522 164.946  1.00 33.46           N  
ATOM   1195  CA  ALA   162       6.841  34.557 165.155  1.00 35.04           C  
ATOM   1196  C   ALA   162       7.519  35.821 164.628  1.00 36.17           C  
ATOM   1197  O   ALA   162       7.108  36.373 163.604  1.00 36.48           O  
ATOM   1198  CB  ALA   162       7.484  33.337 164.511  1.00 35.01           C  
ATOM   1199  N   ASP   163       8.559  36.260 165.343  1.00 35.67           N  
ATOM   1200  CA  ASP   163       9.367  37.428 164.980  1.00 35.23           C  
ATOM   1201  C   ASP   163       8.577  38.664 164.556  1.00 34.80           C  
ATOM   1202  O   ASP   163       9.082  39.491 163.803  1.00 37.18           O  
ATOM   1203  CB  ASP   163      10.324  37.063 163.848  1.00 36.36           C  
ATOM   1204  CG  ASP   163      11.103  35.796 164.126  1.00 38.68           C  
ATOM   1205  OD1 ASP   163      11.514  35.602 165.286  1.00 41.88           O  
ATOM   1206  OD2 ASP   163      11.319  34.996 163.186  1.00 44.47           O  
ATOM   1207  N   ALA   164       7.352  38.800 165.048  1.00 34.25           N  
ATOM   1208  CA  ALA   164       6.485  39.911 164.677  1.00 35.10           C  
ATOM   1209  C   ALA   164       6.843  41.287 165.218  1.00 37.45           C  
ATOM   1210  O   ALA   164       6.275  42.297 164.783  1.00 36.35           O  
ATOM   1211  CB  ALA   164       5.058  39.579 165.062  1.00 34.18           C  
ATOM   1212  N   LEU   165       7.782  41.327 166.155  1.00 38.68           N  
ATOM   1213  CA  LEU   165       8.179  42.576 166.783  1.00 41.51           C  
ATOM   1214  C   LEU   165       9.527  43.091 166.299  1.00 43.63           C  
ATOM   1215  O   LEU   165       9.965  44.174 166.688  1.00 44.67           O  
ATOM   1216  CB  LEU   165       8.215  42.389 168.300  1.00 40.59           C  
ATOM   1217  CG  LEU   165       6.898  42.048 169.005  1.00 37.73           C  
ATOM   1218  CD1 LEU   165       7.169  41.504 170.401  1.00 39.58           C  
ATOM   1219  CD2 LEU   165       6.026  43.291 169.080  1.00 42.32           C  
ATOM   1220  N   LEU   166      10.172  42.306 165.446  1.00 46.20           N  
ATOM   1221  CA  LEU   166      11.477  42.650 164.900  1.00 47.74           C  
ATOM   1222  C   LEU   166      12.459  43.155 165.952  1.00 49.34           C  
ATOM   1223  O   LEU   166      13.031  44.241 165.822  1.00 48.89           O  
ATOM   1224  CB  LEU   166      11.326  43.671 163.760  1.00 47.18           C  
ATOM   1225  CG  LEU   166      10.589  43.140 162.518  1.00 47.23           C  
ATOM   1226  CD1 LEU   166      10.505  44.215 161.444  1.00 48.55           C  
ATOM   1227  CD2 LEU   166      11.325  41.922 161.986  1.00 48.26           C  
ATOM   1228  N   ASP   167      12.632  42.357 167.004  1.00 51.27           N  
ATOM   1229  CA  ASP   167      13.570  42.673 168.073  1.00 52.31           C  
ATOM   1230  C   ASP   167      13.333  44.014 168.764  1.00 53.19           C  
ATOM   1231  O   ASP   167      14.231  44.548 169.422  1.00 53.46           O  
ATOM   1232  CB  ASP   167      14.992  42.629 167.513  1.00 53.31           C  
ATOM   1233  CG  ASP   167      15.465  41.213 167.224  1.00 54.32           C  
ATOM   1234  OD1 ASP   167      15.400  40.377 168.146  1.00 57.29           O  
ATOM   1235  OD2 ASP   167      15.913  40.938 166.089  1.00 59.10           O  
ATOM   1236  N   GLY   168      12.123  44.545 168.614  1.00 54.04           N  
ATOM   1237  CA  GLY   168      11.793  45.823 169.209  1.00 56.23           C  
ATOM   1238  C   GLY   168      12.089  46.953 168.235  1.00 58.04           C  
ATOM   1239  O   GLY   168      11.750  48.110 168.482  1.00 57.65           O  
ATOM   1240  N   THR   169      12.735  46.611 167.124  1.00 59.91           N  
ATOM   1241  CA  THR   169      13.095  47.571 166.079  1.00 61.31           C  
ATOM   1242  C   THR   169      12.033  48.640 165.864  1.00 62.28           C  
ATOM   1243  O   THR   169      12.365  49.803 165.619  1.00 63.59           O  
ATOM   1244  CB  THR   169      13.342  46.846 164.726  1.00 60.94           C  
ATOM   1245  OG1 THR   169      14.680  46.335 164.684  1.00 60.61           O  
ATOM   1246  CG2 THR   169      13.109  47.780 163.544  1.00 62.48           C  
ATOM   1247  N   ILE   170      10.762  48.250 165.954  1.00 63.65           N  
ATOM   1248  CA  ILE   170       9.677  49.198 165.728  1.00 65.26           C  
ATOM   1249  C   ILE   170       9.646  50.344 166.743  1.00 67.56           C  
ATOM   1250  O   ILE   170      10.360  50.315 167.740  1.00 67.27           O  
ATOM   1251  CB  ILE   170       8.300  48.465 165.611  1.00 64.43           C  
ATOM   1252  CG1 ILE   170       8.059  47.560 166.808  1.00 65.08           C  
ATOM   1253  CG2 ILE   170       8.284  47.632 164.319  1.00 63.91           C  
ATOM   1254  CD1 ILE   170       6.824  46.694 166.661  1.00 61.22           C  
ATOM   1255  N   ALA   171       8.815  51.349 166.477  1.00 71.03           N  
ATOM   1256  CA  ALA   171       8.732  52.562 167.298  1.00 74.04           C  
ATOM   1257  C   ALA   171      10.147  53.153 167.376  1.00 76.78           C  
ATOM   1258  O   ALA   171      10.730  53.279 168.460  1.00 77.43           O  
ATOM   1259  CB  ALA   171       8.222  52.258 168.694  1.00 74.35           C  
ATOM   1260  N   ASP   172      10.699  53.525 166.223  1.00 79.39           N  
ATOM   1261  CA  ASP   172      12.045  54.097 166.162  1.00 81.44           C  
ATOM   1262  C   ASP   172      12.123  55.050 164.972  1.00 82.22           C  
ATOM   1263  O   ASP   172      12.056  54.625 163.819  1.00 83.14           O  
ATOM   1264  CB  ASP   172      13.070  52.972 165.995  1.00 81.68           C  
ATOM   1265  CG  ASP   172      14.447  53.340 166.498  1.00 85.84           C  
ATOM   1266  OD1 ASP   172      14.833  54.516 166.380  1.00 90.92           O  
ATOM   1267  OD2 ASP   172      15.153  52.441 166.997  1.00 87.39           O  
ATOM   1268  N   GLN   173      12.282  56.336 165.262  1.00 82.92           N  
ATOM   1269  CA  GLN   173      12.352  57.356 164.224  1.00 83.98           C  
ATOM   1270  C   GLN   173      13.324  57.023 163.106  1.00 83.45           C  
ATOM   1271  O   GLN   173      12.969  57.063 161.933  1.00 83.90           O  
ATOM   1272  CB  GLN   173      12.712  58.717 164.834  1.00 84.72           C  
ATOM   1273  CG  GLN   173      11.607  59.350 165.690  1.00 88.73           C  
ATOM   1274  CD  GLN   173      11.323  58.578 166.965  1.00 91.02           C  
ATOM   1275  OE1 GLN   173      12.243  58.150 167.655  1.00 91.29           O  
ATOM   1276  NE2 GLN   173      10.044  58.415 167.295  1.00 90.94           N  
ATOM   1277  N   THR   174      14.550  56.679 163.477  1.00 82.77           N  
ATOM   1278  CA  THR   174      15.575  56.341 162.498  1.00 82.11           C  
ATOM   1279  C   THR   174      15.135  55.223 161.573  1.00 81.93           C  
ATOM   1280  O   THR   174      15.240  55.333 160.348  1.00 81.65           O  
ATOM   1281  CB  THR   174      16.901  55.902 163.178  1.00 82.03           C  
ATOM   1282  OG1 THR   174      16.664  54.764 164.022  1.00 82.87           O  
ATOM   1283  CG2 THR   174      17.494  57.036 164.004  1.00 80.61           C  
ATOM   1284  N   ARG   175      14.620  54.155 162.170  1.00 81.42           N  
ATOM   1285  CA  ARG   175      14.203  52.990 161.400  1.00 80.76           C  
ATOM   1286  C   ARG   175      13.016  53.134 160.457  1.00 80.26           C  
ATOM   1287  O   ARG   175      11.901  52.742 160.806  1.00 80.41           O  
ATOM   1288  CB  ARG   175      13.966  51.805 162.341  1.00 80.91           C  
ATOM   1289  CG  ARG   175      14.234  50.422 161.726  1.00 82.08           C  
ATOM   1290  CD  ARG   175      15.675  49.988 161.956  1.00 84.76           C  
ATOM   1291  NE  ARG   175      16.086  50.219 163.341  1.00 85.35           N  
ATOM   1292  CZ  ARG   175      17.050  49.545 163.962  1.00 86.15           C  
ATOM   1293  NH1 ARG   175      17.712  48.585 163.327  1.00 83.31           N  
ATOM   1294  NH2 ARG   175      17.346  49.826 165.226  1.00 86.88           N  
ATOM   1295  N   LYS   176      13.252  53.728 159.283  1.00 79.32           N  
ATOM   1296  CA  LYS   176      12.200  53.819 158.277  1.00 77.64           C  
ATOM   1297  C   LYS   176      12.482  52.544 157.460  1.00 76.67           C  
ATOM   1298  O   LYS   176      13.654  52.147 157.250  1.00 76.95           O  
ATOM   1299  CB  LYS   176      12.349  55.063 157.415  1.00 78.36           C  
ATOM   1300  N   ASP   177      11.419  51.901 156.986  1.00 73.97           N  
ATOM   1301  CA  ASP   177      11.555  50.614 156.296  1.00 71.10           C  
ATOM   1302  C   ASP   177      10.173  50.140 155.855  1.00 69.68           C  
ATOM   1303  O   ASP   177       9.176  50.354 156.551  1.00 69.25           O  
ATOM   1304  CB  ASP   177      12.096  49.619 157.317  1.00 71.15           C  
ATOM   1305  CG  ASP   177      13.030  48.583 156.729  1.00 71.21           C  
ATOM   1306  OD1 ASP   177      13.875  48.966 155.902  1.00 71.86           O  
ATOM   1307  OD2 ASP   177      12.938  47.392 157.122  1.00 69.21           O  
ATOM   1308  N   ARG   178      10.122  49.464 154.716  1.00 67.48           N  
ATOM   1309  CA  ARG   178       8.873  48.908 154.231  1.00 65.11           C  
ATOM   1310  C   ARG   178       8.368  47.952 155.319  1.00 62.93           C  
ATOM   1311  O   ARG   178       7.205  47.995 155.716  1.00 61.37           O  
ATOM   1312  CB  ARG   178       9.120  48.129 152.934  1.00 65.76           C  
ATOM   1313  N   ASP   179       9.258  47.081 155.789  1.00 61.40           N  
ATOM   1314  CA  ASP   179       8.914  46.072 156.785  1.00 61.31           C  
ATOM   1315  C   ASP   179       8.565  46.570 158.176  1.00 61.77           C  
ATOM   1316  O   ASP   179       7.499  46.240 158.708  1.00 62.54           O  
ATOM   1317  CB  ASP   179      10.025  45.013 156.857  1.00 60.28           C  
ATOM   1318  CG  ASP   179       9.996  44.057 155.657  1.00 60.29           C  
ATOM   1319  OD1 ASP   179       8.969  44.025 154.933  1.00 56.76           O  
ATOM   1320  OD2 ASP   179      10.993  43.330 155.451  1.00 58.00           O  
ATOM   1321  N   THR   180       9.457  47.362 158.756  1.00 61.26           N  
ATOM   1322  CA  THR   180       9.238  47.899 160.085  1.00 60.59           C  
ATOM   1323  C   THR   180       7.871  48.589 160.156  1.00 59.22           C  
ATOM   1324  O   THR   180       7.154  48.475 161.156  1.00 59.51           O  
ATOM   1325  CB  THR   180      10.351  48.910 160.457  1.00 60.28           C  
ATOM   1326  OG1 THR   180      10.457  48.997 161.881  1.00 63.84           O  
ATOM   1327  CG2 THR   180      10.034  50.299 159.913  1.00 62.53           C  
ATOM   1328  N   GLN   181       7.517  49.301 159.089  1.00 57.42           N  
ATOM   1329  CA  GLN   181       6.250  50.026 159.021  1.00 56.34           C  
ATOM   1330  C   GLN   181       5.053  49.083 158.956  1.00 54.30           C  
ATOM   1331  O   GLN   181       3.980  49.394 159.486  1.00 55.01           O  
ATOM   1332  CB  GLN   181       6.247  50.951 157.799  1.00 56.61           C  
ATOM   1333  CG  GLN   181       5.074  51.905 157.722  1.00 60.31           C  
ATOM   1334  CD  GLN   181       5.224  52.896 156.579  1.00 66.50           C  
ATOM   1335  OE1 GLN   181       6.338  53.162 156.123  1.00 68.79           O  
ATOM   1336  NE2 GLN   181       4.108  53.467 156.131  1.00 65.27           N  
ATOM   1337  N   ALA   182       5.241  47.936 158.308  1.00 52.30           N  
ATOM   1338  CA  ALA   182       4.177  46.945 158.188  1.00 51.70           C  
ATOM   1339  C   ALA   182       4.042  46.221 159.534  1.00 49.61           C  
ATOM   1340  O   ALA   182       2.929  45.999 160.011  1.00 48.87           O  
ATOM   1341  CB  ALA   182       4.504  45.948 157.068  1.00 51.18           C  
ATOM   1342  N   ALA   183       5.175  45.864 160.141  1.00 47.78           N  
ATOM   1343  CA  ALA   183       5.170  45.196 161.439  1.00 49.10           C  
ATOM   1344  C   ALA   183       4.535  46.152 162.474  1.00 50.05           C  
ATOM   1345  O   ALA   183       3.764  45.721 163.333  1.00 49.60           O  
ATOM   1346  CB  ALA   183       6.601  44.831 161.846  1.00 47.67           C  
ATOM   1347  N   ARG   184       4.849  47.448 162.392  1.00 51.31           N  
ATOM   1348  CA  ARG   184       4.283  48.433 163.319  1.00 52.65           C  
ATOM   1349  C   ARG   184       2.760  48.504 163.162  1.00 53.41           C  
ATOM   1350  O   ARG   184       2.031  48.534 164.157  1.00 53.91           O  
ATOM   1351  CB  ARG   184       4.872  49.820 163.066  1.00 54.06           C  
ATOM   1352  CG  ARG   184       5.157  50.600 164.341  1.00 57.28           C  
ATOM   1353  CD  ARG   184       5.260  52.096 164.094  1.00 59.50           C  
ATOM   1354  NE  ARG   184       6.262  52.446 163.092  1.00 61.89           N  
ATOM   1355  CZ  ARG   184       7.549  52.123 163.171  1.00 65.18           C  
ATOM   1356  NH1 ARG   184       8.000  51.441 164.209  1.00 66.46           N  
ATOM   1357  NH2 ARG   184       8.390  52.486 162.210  1.00 67.83           N  
ATOM   1358  N   ASP   185       2.280  48.532 161.917  1.00 53.41           N  
ATOM   1359  CA  ASP   185       0.838  48.596 161.664  1.00 54.19           C  
ATOM   1360  C   ASP   185       0.141  47.321 162.135  1.00 52.11           C  
ATOM   1361  O   ASP   185      -0.988  47.361 162.637  1.00 51.76           O  
ATOM   1362  CB  ASP   185       0.545  48.817 160.177  1.00 55.83           C  
ATOM   1363  CG  ASP   185      -0.940  48.873 159.884  1.00 63.25           C  
ATOM   1364  OD1 ASP   185      -1.551  47.806 159.669  1.00 71.31           O  
ATOM   1365  OD2 ASP   185      -1.503  49.988 159.886  1.00 73.27           O  
ATOM   1366  N   ALA   186       0.817  46.189 161.972  1.00 50.23           N  
ATOM   1367  CA  ALA   186       0.269  44.908 162.407  1.00 48.60           C  
ATOM   1368  C   ALA   186       0.097  44.960 163.936  1.00 46.32           C  
ATOM   1369  O   ALA   186      -0.975  44.666 164.459  1.00 45.88           O  
ATOM   1370  CB  ALA   186       1.220  43.776 162.022  1.00 47.52           C  
ATOM   1371  N   ASP   187       1.157  45.336 164.646  1.00 45.93           N  
ATOM   1372  CA  ASP   187       1.121  45.421 166.106  1.00 46.57           C  
ATOM   1373  C   ASP   187      -0.020  46.353 166.537  1.00 46.63           C  
ATOM   1374  O   ASP   187      -0.879  45.975 167.341  1.00 46.91           O  
ATOM   1375  CB  ASP   187       2.474  45.939 166.620  1.00 45.25           C  
ATOM   1376  CG  ASP   187       2.575  45.923 168.138  1.00 49.55           C  
ATOM   1377  OD1 ASP   187       2.652  44.821 168.735  1.00 45.87           O  
ATOM   1378  OD2 ASP   187       2.569  47.024 168.736  1.00 50.96           O  
ATOM   1379  N   GLU   188      -0.024  47.571 166.001  1.00 46.68           N  
ATOM   1380  CA  GLU   188      -1.064  48.545 166.320  1.00 46.47           C  
ATOM   1381  C   GLU   188      -2.450  47.988 165.972  1.00 45.29           C  
ATOM   1382  O   GLU   188      -3.409  48.177 166.717  1.00 44.23           O  
ATOM   1383  CB  GLU   188      -0.806  49.845 165.548  1.00 47.29           C  
ATOM   1384  CG  GLU   188      -1.912  50.873 165.661  1.00 52.14           C  
ATOM   1385  CD  GLU   188      -1.559  52.167 164.960  1.00 58.46           C  
ATOM   1386  OE1 GLU   188      -0.450  52.686 165.211  1.00 60.41           O  
ATOM   1387  OE2 GLU   188      -2.388  52.672 164.171  1.00 57.72           O  
ATOM   1388  N   TYR   189      -2.552  47.304 164.835  1.00 44.78           N  
ATOM   1389  CA  TYR   189      -3.822  46.712 164.409  1.00 43.79           C  
ATOM   1390  C   TYR   189      -4.226  45.571 165.343  1.00 42.73           C  
ATOM   1391  O   TYR   189      -5.385  45.467 165.753  1.00 43.44           O  
ATOM   1392  CB  TYR   189      -3.716  46.157 162.994  1.00 43.66           C  
ATOM   1393  CG  TYR   189      -4.990  45.489 162.538  1.00 43.06           C  
ATOM   1394  CD1 TYR   189      -6.135  46.241 162.280  1.00 45.51           C  
ATOM   1395  CD2 TYR   189      -5.064  44.104 162.395  1.00 40.70           C  
ATOM   1396  CE1 TYR   189      -7.320  45.635 161.886  1.00 48.14           C  
ATOM   1397  CE2 TYR   189      -6.248  43.483 162.003  1.00 43.88           C  
ATOM   1398  CZ  TYR   189      -7.370  44.256 161.751  1.00 46.56           C  
ATOM   1399  OH  TYR   189      -8.540  43.659 161.351  1.00 45.85           O  
ATOM   1400  N   ILE   190      -3.268  44.710 165.676  1.00 41.78           N  
ATOM   1401  CA  ILE   190      -3.536  43.587 166.562  1.00 39.45           C  
ATOM   1402  C   ILE   190      -4.024  44.084 167.931  1.00 39.67           C  
ATOM   1403  O   ILE   190      -4.950  43.518 168.511  1.00 38.60           O  
ATOM   1404  CB  ILE   190      -2.267  42.701 166.725  1.00 40.19           C  
ATOM   1405  CG1 ILE   190      -2.089  41.824 165.479  1.00 36.29           C  
ATOM   1406  CG2 ILE   190      -2.366  41.848 167.998  1.00 37.83           C  
ATOM   1407  CD1 ILE   190      -0.753  41.100 165.413  1.00 26.27           C  
ATOM   1408  N   ARG   191      -3.404  45.142 168.445  1.00 40.01           N  
ATOM   1409  CA  ARG   191      -3.792  45.684 169.743  1.00 43.13           C  
ATOM   1410  C   ARG   191      -5.132  46.419 169.725  1.00 44.80           C  
ATOM   1411  O   ARG   191      -5.630  46.842 170.766  1.00 44.64           O  
ATOM   1412  CB  ARG   191      -2.695  46.611 170.265  1.00 41.94           C  
ATOM   1413  CG  ARG   191      -1.437  45.882 170.742  1.00 42.77           C  
ATOM   1414  CD  ARG   191      -0.238  46.814 170.764  1.00 46.32           C  
ATOM   1415  NE  ARG   191      -0.668  48.195 170.934  1.00 51.32           N  
ATOM   1416  CZ  ARG   191      -0.136  49.228 170.292  1.00 50.72           C  
ATOM   1417  NH1 ARG   191       0.853  49.047 169.427  1.00 50.42           N  
ATOM   1418  NH2 ARG   191      -0.598  50.446 170.515  1.00 53.35           N  
ATOM   1419  N   SER   192      -5.725  46.543 168.543  1.00 45.68           N  
ATOM   1420  CA  SER   192      -6.994  47.240 168.393  1.00 46.18           C  
ATOM   1421  C   SER   192      -8.188  46.294 168.323  1.00 46.25           C  
ATOM   1422  O   SER   192      -9.328  46.721 168.519  1.00 46.21           O  
ATOM   1423  CB  SER   192      -6.979  48.097 167.124  1.00 47.71           C  
ATOM   1424  OG  SER   192      -7.303  47.324 165.967  1.00 47.27           O  
ATOM   1425  N   ILE   193      -7.944  45.015 168.046  1.00 47.19           N  
ATOM   1426  CA  ILE   193      -9.054  44.092 167.912  1.00 46.69           C  
ATOM   1427  C   ILE   193      -9.698  43.766 169.246  1.00 45.97           C  
ATOM   1428  O   ILE   193      -9.027  43.638 170.263  1.00 45.13           O  
ATOM   1429  CB  ILE   193      -8.627  42.829 167.096  1.00 46.55           C  
ATOM   1430  CG1 ILE   193      -9.275  41.581 167.659  1.00 48.58           C  
ATOM   1431  CG2 ILE   193      -7.122  42.735 167.017  1.00 48.52           C  
ATOM   1432  CD1 ILE   193      -8.374  40.370 167.601  1.00 53.08           C  
ATOM   1433  N   GLU   194     -11.020  43.641 169.220  1.00 46.10           N  
ATOM   1434  CA  GLU   194     -11.803  43.405 170.419  1.00 46.72           C  
ATOM   1435  C   GLU   194     -12.074  41.944 170.734  1.00 45.13           C  
ATOM   1436  O   GLU   194     -12.243  41.126 169.834  1.00 44.75           O  
ATOM   1437  CB  GLU   194     -13.119  44.175 170.299  1.00 48.29           C  
ATOM   1438  CG  GLU   194     -13.732  44.629 171.616  1.00 53.72           C  
ATOM   1439  CD  GLU   194     -13.127  45.922 172.135  1.00 60.45           C  
ATOM   1440  OE1 GLU   194     -12.510  46.656 171.332  1.00 61.44           O  
ATOM   1441  OE2 GLU   194     -13.287  46.211 173.341  1.00 63.38           O  
ATOM   1442  N   GLY   195     -12.123  41.631 172.022  1.00 42.68           N  
ATOM   1443  CA  GLY   195     -12.355  40.262 172.422  1.00 41.19           C  
ATOM   1444  C   GLY   195     -11.115  39.427 172.149  1.00 38.96           C  
ATOM   1445  O   GLY   195     -11.204  38.228 171.879  1.00 38.68           O  
ATOM   1446  N   ALA   196      -9.949  40.069 172.193  1.00 37.97           N  
ATOM   1447  CA  ALA   196      -8.669  39.386 171.968  1.00 38.03           C  
ATOM   1448  C   ALA   196      -7.746  39.616 173.142  1.00 38.17           C  
ATOM   1449  O   ALA   196      -7.723  40.713 173.714  1.00 39.15           O  
ATOM   1450  CB  ALA   196      -7.979  39.904 170.722  1.00 37.01           C  
ATOM   1451  N   HIS   197      -6.990  38.587 173.518  1.00 36.67           N  
ATOM   1452  CA  HIS   197      -5.979  38.759 174.559  1.00 34.86           C  
ATOM   1453  C   HIS   197      -4.672  38.817 173.766  1.00 34.12           C  
ATOM   1454  O   HIS   197      -4.383  37.946 172.928  1.00 34.95           O  
ATOM   1455  CB  HIS   197      -5.904  37.572 175.516  1.00 34.32           C  
ATOM   1456  CG  HIS   197      -7.163  37.314 176.261  1.00 30.53           C  
ATOM   1457  ND1 HIS   197      -7.739  38.243 177.100  1.00 28.83           N  
ATOM   1458  CD2 HIS   197      -7.935  36.209 176.330  1.00 32.70           C  
ATOM   1459  CE1 HIS   197      -8.814  37.717 177.656  1.00 29.31           C  
ATOM   1460  NE2 HIS   197      -8.955  36.484 177.205  1.00 27.66           N  
ATOM   1461  N   VAL   198      -3.887  39.856 174.006  1.00 32.85           N  
ATOM   1462  CA  VAL   198      -2.614  40.026 173.315  1.00 31.44           C  
ATOM   1463  C   VAL   198      -1.459  39.870 174.291  1.00 31.83           C  
ATOM   1464  O   VAL   198      -1.404  40.553 175.311  1.00 33.09           O  
ATOM   1465  CB  VAL   198      -2.521  41.420 172.641  1.00 32.23           C  
ATOM   1466  CG1 VAL   198      -1.167  41.590 171.962  1.00 29.85           C  
ATOM   1467  CG2 VAL   198      -3.662  41.584 171.629  1.00 31.51           C  
ATOM   1468  N   ALA   199      -0.555  38.942 173.991  1.00 31.03           N  
ATOM   1469  CA  ALA   199       0.623  38.735 174.820  1.00 30.46           C  
ATOM   1470  C   ALA   199       1.808  38.865 173.865  1.00 30.64           C  
ATOM   1471  O   ALA   199       1.832  38.228 172.812  1.00 30.97           O  
ATOM   1472  CB  ALA   199       0.609  37.340 175.471  1.00 28.20           C  
ATOM   1473  N   ARG   200       2.775  39.707 174.212  1.00 30.50           N  
ATOM   1474  CA  ARG   200       3.949  39.902 173.383  1.00 31.66           C  
ATOM   1475  C   ARG   200       5.137  39.535 174.265  1.00 32.61           C  
ATOM   1476  O   ARG   200       5.411  40.170 175.282  1.00 33.33           O  
ATOM   1477  CB  ARG   200       3.962  41.351 172.862  1.00 31.67           C  
ATOM   1478  CG  ARG   200       2.891  41.543 171.766  1.00 36.13           C  
ATOM   1479  CD  ARG   200       2.761  43.000 171.353  1.00 37.83           C  
ATOM   1480  NE  ARG   200       2.310  43.827 172.467  1.00 38.02           N  
ATOM   1481  CZ  ARG   200       2.536  45.129 172.561  1.00 37.23           C  
ATOM   1482  NH1 ARG   200       3.209  45.752 171.599  1.00 37.07           N  
ATOM   1483  NH2 ARG   200       2.122  45.793 173.631  1.00 35.20           N  
ATOM   1484  N   LEU   201       5.848  38.501 173.837  1.00 31.75           N  
ATOM   1485  CA  LEU   201       6.921  37.919 174.608  1.00 31.41           C  
ATOM   1486  C   LEU   201       8.335  37.984 174.037  1.00 31.43           C  
ATOM   1487  O   LEU   201       8.513  38.065 172.835  1.00 31.82           O  
ATOM   1488  CB  LEU   201       6.513  36.467 174.892  1.00 29.43           C  
ATOM   1489  CG  LEU   201       5.021  36.302 175.288  1.00 32.44           C  
ATOM   1490  CD1 LEU   201       4.614  34.815 175.271  1.00 26.90           C  
ATOM   1491  CD2 LEU   201       4.773  36.920 176.667  1.00 27.08           C  
ATOM   1492  N   PRO   202       9.352  37.925 174.917  1.00 30.80           N  
ATOM   1493  CA  PRO   202      10.767  37.978 174.532  1.00 30.32           C  
ATOM   1494  C   PRO   202      11.335  36.677 173.954  1.00 30.34           C  
ATOM   1495  O   PRO   202      12.359  36.191 174.416  1.00 30.23           O  
ATOM   1496  CB  PRO   202      11.457  38.373 175.834  1.00 30.91           C  
ATOM   1497  CG  PRO   202      10.656  37.632 176.860  1.00 28.45           C  
ATOM   1498  CD  PRO   202       9.205  37.859 176.387  1.00 30.07           C  
ATOM   1499  N   LEU   203      10.667  36.118 172.952  1.00 30.48           N  
ATOM   1500  CA  LEU   203      11.123  34.883 172.314  1.00 30.84           C  
ATOM   1501  C   LEU   203      11.410  35.167 170.839  1.00 31.51           C  
ATOM   1502  O   LEU   203      10.659  35.887 170.186  1.00 30.41           O  
ATOM   1503  CB  LEU   203      10.053  33.790 172.456  1.00 30.29           C  
ATOM   1504  CG  LEU   203       9.891  33.170 173.843  1.00 32.44           C  
ATOM   1505  CD1 LEU   203       8.508  32.527 173.937  1.00 32.55           C  
ATOM   1506  CD2 LEU   203      11.009  32.152 174.088  1.00 23.45           C  
ATOM   1507  N   GLY   204      12.497  34.596 170.326  1.00 32.37           N  
ATOM   1508  CA  GLY   204      12.882  34.847 168.949  1.00 34.19           C  
ATOM   1509  C   GLY   204      13.081  36.350 168.798  1.00 35.62           C  
ATOM   1510  O   GLY   204      13.706  36.997 169.647  1.00 35.96           O  
ATOM   1511  N   ALA   205      12.557  36.924 167.719  1.00 35.06           N  
ATOM   1512  CA  ALA   205      12.671  38.366 167.495  1.00 35.51           C  
ATOM   1513  C   ALA   205      11.446  39.095 168.071  1.00 35.05           C  
ATOM   1514  O   ALA   205      11.159  40.235 167.697  1.00 34.58           O  
ATOM   1515  CB  ALA   205      12.804  38.661 165.991  1.00 35.87           C  
ATOM   1516  N   GLY   206      10.724  38.440 168.978  1.00 35.87           N  
ATOM   1517  CA  GLY   206       9.545  39.052 169.571  1.00 34.61           C  
ATOM   1518  C   GLY   206       8.283  38.367 169.082  1.00 35.34           C  
ATOM   1519  O   GLY   206       7.853  38.570 167.954  1.00 34.47           O  
ATOM   1520  N   LEU   207       7.677  37.575 169.958  1.00 34.79           N  
ATOM   1521  CA  LEU   207       6.491  36.801 169.637  1.00 31.42           C  
ATOM   1522  C   LEU   207       5.192  37.467 170.024  1.00 30.81           C  
ATOM   1523  O   LEU   207       5.061  37.984 171.123  1.00 31.83           O  
ATOM   1524  CB  LEU   207       6.606  35.445 170.336  1.00 33.46           C  
ATOM   1525  CG  LEU   207       5.572  34.340 170.108  1.00 33.46           C  
ATOM   1526  CD1 LEU   207       5.830  33.688 168.753  1.00 37.83           C  
ATOM   1527  CD2 LEU   207       5.667  33.296 171.214  1.00 30.57           C  
ATOM   1528  N   THR   208       4.228  37.466 169.113  1.00 30.32           N  
ATOM   1529  CA  THR   208       2.928  38.023 169.439  1.00 28.64           C  
ATOM   1530  C   THR   208       1.915  36.888 169.395  1.00 29.95           C  
ATOM   1531  O   THR   208       1.733  36.237 168.356  1.00 29.31           O  
ATOM   1532  CB  THR   208       2.457  39.112 168.449  1.00 30.18           C  
ATOM   1533  OG1 THR   208       3.403  40.185 168.423  1.00 30.22           O  
ATOM   1534  CG2 THR   208       1.104  39.671 168.893  1.00 26.07           C  
ATOM   1535  N   VAL   209       1.290  36.608 170.530  1.00 29.09           N  
ATOM   1536  CA  VAL   209       0.264  35.589 170.541  1.00 29.88           C  
ATOM   1537  C   VAL   209      -1.036  36.292 170.927  1.00 30.32           C  
ATOM   1538  O   VAL   209      -1.116  37.033 171.909  1.00 32.33           O  
ATOM   1539  CB  VAL   209       0.622  34.361 171.478  1.00 29.48           C  
ATOM   1540  CG1 VAL   209       1.798  34.685 172.342  1.00 29.65           C  
ATOM   1541  CG2 VAL   209      -0.590  33.915 172.266  1.00 25.94           C  
ATOM   1542  N   VAL   210      -2.055  36.092 170.111  1.00 30.08           N  
ATOM   1543  CA  VAL   210      -3.324  36.706 170.372  1.00 30.95           C  
ATOM   1544  C   VAL   210      -4.362  35.599 170.439  1.00 31.19           C  
ATOM   1545  O   VAL   210      -4.602  34.856 169.474  1.00 31.19           O  
ATOM   1546  CB  VAL   210      -3.619  37.855 169.309  1.00 32.54           C  
ATOM   1547  CG1 VAL   210      -2.689  37.714 168.126  1.00 29.10           C  
ATOM   1548  CG2 VAL   210      -5.061  37.887 168.913  1.00 30.41           C  
ATOM   1549  N   THR   211      -4.970  35.474 171.610  1.00 31.26           N  
ATOM   1550  CA  THR   211      -5.956  34.445 171.782  1.00 33.16           C  
ATOM   1551  C   THR   211      -7.354  35.046 171.827  1.00 33.51           C  
ATOM   1552  O   THR   211      -7.553  36.165 172.310  1.00 34.80           O  
ATOM   1553  CB  THR   211      -5.607  33.534 173.019  1.00 33.51           C  
ATOM   1554  OG1 THR   211      -6.632  33.598 174.013  1.00 32.53           O  
ATOM   1555  CG2 THR   211      -4.269  33.914 173.600  1.00 26.11           C  
ATOM   1556  N   LYS   212      -8.314  34.304 171.283  1.00 33.14           N  
ATOM   1557  CA  LYS   212      -9.690  34.759 171.217  1.00 32.21           C  
ATOM   1558  C   LYS   212     -10.338  34.586 172.574  1.00 33.16           C  
ATOM   1559  O   LYS   212     -10.486  33.483 173.093  1.00 31.48           O  
ATOM   1560  CB  LYS   212     -10.451  33.983 170.126  1.00 30.67           C  
ATOM   1561  CG  LYS   212     -11.848  34.499 169.856  1.00 31.48           C  
ATOM   1562  CD  LYS   212     -12.519  33.780 168.685  1.00 33.82           C  
ATOM   1563  CE  LYS   212     -11.949  34.223 167.341  1.00 34.01           C  
ATOM   1564  NZ  LYS   212     -12.701  33.627 166.197  1.00 35.69           N  
ATOM   1565  N   ALA   213     -10.723  35.710 173.156  1.00 35.52           N  
ATOM   1566  CA  ALA   213     -11.339  35.718 174.472  1.00 36.71           C  
ATOM   1567  C   ALA   213     -12.641  34.939 174.553  1.00 38.53           C  
ATOM   1568  O   ALA   213     -13.372  34.834 173.570  1.00 39.30           O  
ATOM   1569  CB  ALA   213     -11.569  37.170 174.922  1.00 37.58           C  
END
