
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  198 ( 1513),  selected  198 , name 3c3p_A
# Molecule2: number of CA atoms  211 ( 1569),  selected  211 , name T0509.pdb
# PARAMETERS: 3c3p_A.T0509.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    I     2_A      -       -           -
LGA    P     3_A      -       -           -
LGA    I     4_A      -       -           -
LGA    V     5_A      -       -           -
LGA    D     6_A      -       -           -
LGA    S     7_A      N       3          2.947
LGA    R     8_A      A       4          3.005
LGA    I     9_A      F       5          3.047
LGA    G    10_A      E       6          1.950
LGA    A    11_A      Y       7          2.219
LGA    Y    12_A      L       8          2.637
LGA    L    13_A      R       9          3.402
LGA    D    14_A      T      10          2.864
LGA    G    15_A      Y      11          1.288
LGA    L    16_A      V      12          2.852
LGA    L    17_A      E      13          3.519
LGA    -       -      S      14           -
LGA    -       -      T      15           -
LGA    P    18_A      T      16          1.478
LGA    E    19_A      E      17          2.770
LGA    A    20_A      T      18          1.956
LGA    D    21_A      D      19          1.648
LGA    P    22_A      A      20          2.571
LGA    V    23_A      A      21          2.248
LGA    V    24_A      V      22          2.267
LGA    A    25_A      A      23          2.201
LGA    A    26_A      R      24          2.195
LGA    X    27_A      A      25          2.368
LGA    E    28_A      R      26          2.489
LGA    Q    29_A      E      27          2.603
LGA    I    30_A      D      28          2.278
LGA    A    31_A      A      29          2.099
LGA    R    32_A      A      30          2.233
LGA    E    33_A      E      31          2.127
LGA    R    34_A      F      32          1.442
LGA    N    35_A      G      33          1.436
LGA    I    36_A      L      34          1.402
LGA    P    37_A      P      35          1.423
LGA    I    38_A      A      36          1.116
LGA    V    39_A      P      37          1.332
LGA    D    40_A      D      38          1.134
LGA    R    41_A      E      39          0.824
LGA    Q    42_A      M      40          0.965
LGA    T    43_A      T      41          0.717
LGA    G    44_A      G      42          0.639
LGA    R    45_A      Q      43          0.815
LGA    L    46_A      L      44          0.851
LGA    L    47_A      L      45          0.676
LGA    Y    48_A      T      46          0.686
LGA    L    49_A      T      47          0.962
LGA    L    50_A      L      48          1.477
LGA    A    51_A      A      49          1.327
LGA    R    52_A      A      50          0.841
LGA    I    53_A      T      51          1.128
LGA    K    54_A      T      52          1.231
LGA    Q    55_A      N      53          3.266
LGA    P    56_A      G      54          3.481
LGA    -       -      N      55           -
LGA    -       -      G      56           -
LGA    Q    57_A      S      57          2.988
LGA    L    58_A      T      58          3.328
LGA    -       -      G      59           -
LGA    V    59_A      A      60          0.734
LGA    V    60_A      I      61          1.236
LGA    V    61_A      A      62          1.712
LGA    P    62_A      I      63          2.358
LGA    G    63_A      T      64          2.832
LGA    D    64_A      P      65          3.311
LGA    G    65_A      A      66          1.687
LGA    L    66_A      A      67          4.838
LGA    G    67_A      G      68          2.175
LGA    C    68_A      L      69          1.968
LGA    A    69_A      V      70          1.582
LGA    S    70_A      G      71          1.525
LGA    W    71_A      L      72          1.776
LGA    W    72_A      Y      73          1.229
LGA    F    73_A      I      74          0.949
LGA    A    74_A      L      75          1.505
LGA    R    75_A      N      76          1.702
LGA    A    76_A      G      77          1.383
LGA    I    77_A      L      78          1.295
LGA    S    78_A      A      79          2.250
LGA    I    79_A      D      80          2.140
LGA    S    80_A      N      81          0.669
LGA    S    81_A      T      82          0.616
LGA    R    82_A      T      83          1.053
LGA    V    83_A      L      84          0.920
LGA    V    84_A      T      85          0.562
LGA    X    85_A      C      86          0.574
LGA    I    86_A      I      87          1.230
LGA    D    87_A      D      88          0.862
LGA    P    88_A      P      89          0.740
LGA    D    89_A      E      90          0.987
LGA    R    90_A      S      91          1.106
LGA    D    91_A      E      92          1.304
LGA    N    92_A      H      93          1.190
LGA    V    93_A      Q      94          1.126
LGA    E    94_A      R      95          1.006
LGA    H    95_A      Q      96          1.344
LGA    A    96_A      A      97          1.180
LGA    R    97_A      K      98          0.618
LGA    R    98_A      A      99          1.162
LGA    X    99_A      L     100          1.461
LGA    L   100_A      F     101          0.971
LGA    H   101_A      R     102          1.396
LGA    D   102_A      E     103          1.921
LGA    N   103_A      A     104          2.195
LGA    G   104_A      G     105          2.905
LGA    L   105_A      Y     106          2.266
LGA    -       -      S     107           -
LGA    I   106_A      P     108          3.159
LGA    D   107_A      S     109          3.013
LGA    R   108_A      R     110          1.031
LGA    V   109_A      V     111          1.070
LGA    E   110_A      R     112          0.830
LGA    L   111_A      F     113          1.378
LGA    Q   112_A      L     114          2.178
LGA    V   113_A      L     115          1.513
LGA    G   114_A      S     116          1.817
LGA    D   115_A      R     117          2.069
LGA    P   116_A      P     118          1.893
LGA    L   117_A      L     119          2.320
LGA    G   118_A      D     120          1.876
LGA    I   119_A      V     121          1.890
LGA    A   120_A      M     122          2.443
LGA    A   121_A      S     123          2.497
LGA    G   122_A      R     124          1.793
LGA    Q   123_A      L     125          1.787
LGA    R   124_A      A     126          2.013
LGA    -       -      N     127           -
LGA    -       -      D     128           -
LGA    D   125_A      S     129          1.416
LGA    I   126_A      Y     130          1.658
LGA    D   127_A      Q     131          1.366
LGA    I   128_A      L     132          1.069
LGA    L   129_A      V     133          1.578
LGA    F   130_A      F     134          1.302
LGA    X   131_A      G     135          1.354
LGA    D   132_A      Q     136          2.042
LGA    C   133_A      V     137          4.422
LGA    D   134_A      S     138          2.499
LGA    V   135_A      P     139           #
LGA    F   136_A      M     140          5.071
LGA    N   137_A      D     141          2.298
LGA    G   138_A      L     142          2.128
LGA    A   139_A      K     143          1.871
LGA    D   140_A      A     144          1.568
LGA    V   141_A      L     145          1.927
LGA    L   142_A      V     146          2.439
LGA    E   143_A      D     147          2.407
LGA    R   144_A      A     148          2.989
LGA    X   145_A      A     149          3.272
LGA    N   146_A      W     150          2.544
LGA    R   147_A      P     151          2.456
LGA    C   148_A      L     152          2.228
LGA    L   149_A      L     153          2.356
LGA    A   150_A      R     154          1.934
LGA    K   151_A      R     155          2.703
LGA    N   152_A      G     156          3.069
LGA    A   153_A      G     157          2.061
LGA    L   154_A      A     158          1.107
LGA    L   155_A      L     159          0.935
LGA    I   156_A      V     160          0.660
LGA    A   157_A      L     161          0.587
LGA    V   158_A      A     162          0.638
LGA    N   159_A      D     163          0.588
LGA    A   160_A      A     164          1.721
LGA    L   161_A      L     165          2.176
LGA    R   162_A      L     166          2.074
LGA    R   163_A      D     167           #
LGA    G   164_A      -       -           -
LGA    A   177_A      G     168          1.396
LGA    L   178_A      T     169          4.911
LGA    -       -      I     170           -
LGA    -       -      A     171           -
LGA    -       -      D     172           -
LGA    -       -      Q     173           -
LGA    -       -      T     174           -
LGA    -       -      R     175           -
LGA    -       -      K     176           -
LGA    -       -      D     177           -
LGA    -       -      R     178           -
LGA    -       -      D     179           -
LGA    -       -      T     180           -
LGA    -       -      Q     181           -
LGA    -       -      A     182           -
LGA    R   179_A      A     183          2.685
LGA    E   180_A      R     184          2.433
LGA    -       -      D     185           -
LGA    F   181_A      A     186          1.780
LGA    N   182_A      D     187          1.553
LGA    H   183_A      E     188          1.495
LGA    H   184_A      Y     189          1.149
LGA    L   185_A      I     190          0.592
LGA    S   186_A      R     191          0.899
LGA    R   187_A      S     192          1.355
LGA    R   188_A      I     193          1.165
LGA    R   189_A      E     194          1.948
LGA    D   190_A      G     195          2.685
LGA    F   191_A      A     196          1.104
LGA    F   192_A      H     197          1.470
LGA    T   193_A      V     198          0.450
LGA    T   194_A      A     199          1.467
LGA    I   195_A      R     200          0.160
LGA    V   196_A      L     201          0.878
LGA    P   197_A      P     202          0.818
LGA    V   198_A      L     203          1.460
LGA    G   199_A      G     204          1.926
LGA    N   200_A      A     205          1.672
LGA    G   201_A      G     206          1.383
LGA    V   202_A      L     207          1.054
LGA    L   203_A      T     208          0.450
LGA    L   204_A      V     209          1.100
LGA    G   205_A      V     210          0.644
LGA    Y   206_A      T     211          1.390
LGA    R   207_A      K     212          1.101
LGA    L   208_A      A     213          2.095
LGA    S   209_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  198  211    5.0    187    1.97    17.11     75.329     9.036

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.709652 * X  +  -0.693978 * Y  +   0.121605 * Z  + -13.078650
  Y_new =  -0.656260 * X  +   0.588290 * Y  +  -0.472481 * Z  +  87.677170
  Z_new =   0.256353 * X  +  -0.415102 * Y  +  -0.872911 * Z  + 156.433044 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.697706    0.443887  [ DEG:  -154.5672     25.4328 ]
  Theta =  -0.259247   -2.882346  [ DEG:   -14.8538   -165.1462 ]
  Phi   =  -2.395264    0.746329  [ DEG:  -137.2385     42.7615 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3c3p_A                                        
REMARK     2: T0509.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3c3p_A.T0509.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  198  211   5.0  187   1.97   17.11  75.329
REMARK  ---------------------------------------------------------- 
MOLECULE 3c3p_A
HEADER    TRANSFERASE                             28-JAN-08   3C3P              
TITLE     CRYSTAL STRUCTURE OF A METHYLTRANSFERASE (NP_951602.1) FROM           
TITLE    2 GEOBACTER SULFURREDUCENS AT 1.90 A RESOLUTION                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: METHYLTRANSFERASE;                                         
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: GEOBACTER SULFURREDUCENS PCA;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PCA / DSM 12127;                                             
SOURCE   5 ATCC: 51573;                                                         
SOURCE   6 GENE: NP_951602.1, GSU0544;                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_951602.1, O-METHYLTRANSFERASE, STRUCTURAL GENOMICS,                
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI-2                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   05-FEB-08 3C3P    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF A METHYLTRANSFERASE                     
JRNL        TITL 2 (NP_951602.1) FROM GEOBACTER SULFURREDUCENS AT               
JRNL        TITL 3 1.90 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  3C3P A    1   209  UNP    Q74FR2   Q74FR2_GEOSL     1    209             
DBREF  3C3P B    1   209  UNP    Q74FR2   Q74FR2_GEOSL     1    209             
DBREF  3C3P C    1   209  UNP    Q74FR2   Q74FR2_GEOSL     1    209             
SEQRES   1 A  210  GLY MSE ILE PRO ILE VAL ASP SER ARG ILE GLY ALA TYR          
SEQRES   2 A  210  LEU ASP GLY LEU LEU PRO GLU ALA ASP PRO VAL VAL ALA          
SEQRES   3 A  210  ALA MSE GLU GLN ILE ALA ARG GLU ARG ASN ILE PRO ILE          
SEQRES   4 A  210  VAL ASP ARG GLN THR GLY ARG LEU LEU TYR LEU LEU ALA          
SEQRES   5 A  210  ARG ILE LYS GLN PRO GLN LEU VAL VAL VAL PRO GLY ASP          
SEQRES   6 A  210  GLY LEU GLY CYS ALA SER TRP TRP PHE ALA ARG ALA ILE          
SEQRES   7 A  210  SER ILE SER SER ARG VAL VAL MSE ILE ASP PRO ASP ARG          
SEQRES   8 A  210  ASP ASN VAL GLU HIS ALA ARG ARG MSE LEU HIS ASP ASN          
SEQRES   9 A  210  GLY LEU ILE ASP ARG VAL GLU LEU GLN VAL GLY ASP PRO          
SEQRES  10 A  210  LEU GLY ILE ALA ALA GLY GLN ARG ASP ILE ASP ILE LEU          
SEQRES  11 A  210  PHE MSE ASP CYS ASP VAL PHE ASN GLY ALA ASP VAL LEU          
SEQRES  12 A  210  GLU ARG MSE ASN ARG CYS LEU ALA LYS ASN ALA LEU LEU          
SEQRES  13 A  210  ILE ALA VAL ASN ALA LEU ARG ARG GLY SER VAL ALA GLU          
SEQRES  14 A  210  SER HIS GLU ASP PRO GLU THR ALA ALA LEU ARG GLU PHE          
SEQRES  15 A  210  ASN HIS HIS LEU SER ARG ARG ARG ASP PHE PHE THR THR          
SEQRES  16 A  210  ILE VAL PRO VAL GLY ASN GLY VAL LEU LEU GLY TYR ARG          
SEQRES  17 A  210  LEU SER                                                      
SEQRES   1 B  210  GLY MSE ILE PRO ILE VAL ASP SER ARG ILE GLY ALA TYR          
SEQRES   2 B  210  LEU ASP GLY LEU LEU PRO GLU ALA ASP PRO VAL VAL ALA          
SEQRES   3 B  210  ALA MSE GLU GLN ILE ALA ARG GLU ARG ASN ILE PRO ILE          
SEQRES   4 B  210  VAL ASP ARG GLN THR GLY ARG LEU LEU TYR LEU LEU ALA          
SEQRES   5 B  210  ARG ILE LYS GLN PRO GLN LEU VAL VAL VAL PRO GLY ASP          
SEQRES   6 B  210  GLY LEU GLY CYS ALA SER TRP TRP PHE ALA ARG ALA ILE          
SEQRES   7 B  210  SER ILE SER SER ARG VAL VAL MSE ILE ASP PRO ASP ARG          
SEQRES   8 B  210  ASP ASN VAL GLU HIS ALA ARG ARG MSE LEU HIS ASP ASN          
SEQRES   9 B  210  GLY LEU ILE ASP ARG VAL GLU LEU GLN VAL GLY ASP PRO          
SEQRES  10 B  210  LEU GLY ILE ALA ALA GLY GLN ARG ASP ILE ASP ILE LEU          
SEQRES  11 B  210  PHE MSE ASP CYS ASP VAL PHE ASN GLY ALA ASP VAL LEU          
SEQRES  12 B  210  GLU ARG MSE ASN ARG CYS LEU ALA LYS ASN ALA LEU LEU          
SEQRES  13 B  210  ILE ALA VAL ASN ALA LEU ARG ARG GLY SER VAL ALA GLU          
SEQRES  14 B  210  SER HIS GLU ASP PRO GLU THR ALA ALA LEU ARG GLU PHE          
SEQRES  15 B  210  ASN HIS HIS LEU SER ARG ARG ARG ASP PHE PHE THR THR          
SEQRES  16 B  210  ILE VAL PRO VAL GLY ASN GLY VAL LEU LEU GLY TYR ARG          
SEQRES  17 B  210  LEU SER                                                      
SEQRES   1 C  210  GLY MSE ILE PRO ILE VAL ASP SER ARG ILE GLY ALA TYR          
SEQRES   2 C  210  LEU ASP GLY LEU LEU PRO GLU ALA ASP PRO VAL VAL ALA          
SEQRES   3 C  210  ALA MSE GLU GLN ILE ALA ARG GLU ARG ASN ILE PRO ILE          
SEQRES   4 C  210  VAL ASP ARG GLN THR GLY ARG LEU LEU TYR LEU LEU ALA          
SEQRES   5 C  210  ARG ILE LYS GLN PRO GLN LEU VAL VAL VAL PRO GLY ASP          
SEQRES   6 C  210  GLY LEU GLY CYS ALA SER TRP TRP PHE ALA ARG ALA ILE          
SEQRES   7 C  210  SER ILE SER SER ARG VAL VAL MSE ILE ASP PRO ASP ARG          
SEQRES   8 C  210  ASP ASN VAL GLU HIS ALA ARG ARG MSE LEU HIS ASP ASN          
SEQRES   9 C  210  GLY LEU ILE ASP ARG VAL GLU LEU GLN VAL GLY ASP PRO          
SEQRES  10 C  210  LEU GLY ILE ALA ALA GLY GLN ARG ASP ILE ASP ILE LEU          
SEQRES  11 C  210  PHE MSE ASP CYS ASP VAL PHE ASN GLY ALA ASP VAL LEU          
SEQRES  12 C  210  GLU ARG MSE ASN ARG CYS LEU ALA LYS ASN ALA LEU LEU          
SEQRES  13 C  210  ILE ALA VAL ASN ALA LEU ARG ARG GLY SER VAL ALA GLU          
SEQRES  14 C  210  SER HIS GLU ASP PRO GLU THR ALA ALA LEU ARG GLU PHE          
SEQRES  15 C  210  ASN HIS HIS LEU SER ARG ARG ARG ASP PHE PHE THR THR          
SEQRES  16 C  210  ILE VAL PRO VAL GLY ASN GLY VAL LEU LEU GLY TYR ARG          
SEQRES  17 C  210  LEU SER                                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  27       8                                                       
HET    MSE  A  85       8                                                       
HET    MSE  A  99       8                                                       
HET    MSE  A 131       8                                                       
HET    MSE  A 145       8                                                       
HET    MSE  B  27       8                                                       
HET    MSE  B  85       8                                                       
HET    MSE  B  99       8                                                       
HET    MSE  B 131       8                                                       
HET    MSE  B 145       8                                                       
HET    MSE  C  27       8                                                       
HET    MSE  C  85       8                                                       
HET    MSE  C  99       8                                                       
HET    MSE  C 131       8                                                       
HET    MSE  C 145       8                                                       
HET     CL  A 210       1                                                       
HET     CL  B 210       1                                                       
HET    EDO  A 211       4                                                       
HET    EDO  A 212       4                                                       
HET    EDO  A 213       4                                                       
HET    EDO  A 214       4                                                       
HET    EDO  A 215       4                                                       
HET    EDO  A 216       4                                                       
HET    EDO  A 217       4                                                       
HET    EDO  A 218       4                                                       
HET    EDO  B 211       4                                                       
HET    EDO  B 212       4                                                       
HET    EDO  B 213       4                                                       
HET    EDO  C 210       4                                                       
HET    EDO  C 211       4                                                       
HET    EDO  C 212       4                                                       
HET    EDO  C 213       4                                                       
HET    EDO  C 214       4                                                       
HET    EDO  C 215       4                                                       
HET    EDO  C 216       4                                                       
HET    EDO  C 217       4                                                       
HET    EDO  C 218       4                                                       
HET    EDO  C 219       4                                                       
HET    EDO  C 220       4                                                       
HET    EDO  C 221       4                                                       
HET    EDO  C 222       4                                                       
HET    PEG  A 219       7                                                       
HET    PEG  A 220       7                                                       
HET    PEG  A 221       7                                                       
HET    PEG  B 214       7                                                       
HET    PEG  B 215       7                                                       
HET    PEG  B 216       7                                                       
HET    PEG  B 217       7                                                       
HET    PEG  B 218       7                                                       
HET    PEG  C 223       7                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   4   CL    2(CL 1-)                                                     
FORMUL   6  EDO    24(C2 H6 O2)                                                 
FORMUL  30  PEG    9(C4 H10 O3)                                                 
FORMUL  39  HOH   *195(H2 O)                                                    
CRYST1  156.880   76.044   85.173  90.00 118.27  90.00 C 1 2 1      12          
ATOM      1  N   GLY A   0      22.883  40.345 168.576  1.00 70.48           N  
ATOM      2  CA  GLY A   0      23.620  40.357 167.280  1.00 70.71           C  
ATOM      3  C   GLY A   0      22.809  41.172 166.301  1.00 70.41           C  
ATOM      4  O   GLY A   0      23.333  42.001 165.559  1.00 71.08           O  
HETATM    5  N   MSE A   1      21.512  40.902 166.301  1.00 69.56           N  
HETATM    6  CA  MSE A   1      20.590  41.630 165.453  1.00 68.58           C  
HETATM    7  C   MSE A   1      20.090  42.621 166.451  1.00 64.95           C  
HETATM    8  O   MSE A   1      20.880  43.272 167.134  1.00 64.96           O  
HETATM    9  CB  MSE A   1      19.408  40.797 164.964  1.00 70.67           C  
HETATM   10  CG  MSE A   1      19.766  39.434 164.447  1.00 72.54           C  
HETATM   11 SE   MSE A   1      19.680  38.062 165.851  0.75 75.67          SE  
HETATM   12  CE  MSE A   1      20.741  38.877 167.262  1.00 75.19           C  
ATOM     13  N   ILE A   2      18.770  42.723 166.520  1.00 60.66           N  
ATOM     14  CA  ILE A   2      18.115  43.549 167.522  1.00 57.23           C  
ATOM     15  C   ILE A   2      18.229  42.630 168.716  1.00 53.39           C  
ATOM     16  O   ILE A   2      17.825  41.486 168.608  1.00 52.20           O  
ATOM     17  CB  ILE A   2      16.623  43.826 167.227  1.00 57.25           C  
ATOM     18  CG1 ILE A   2      16.483  44.773 166.027  1.00 57.28           C  
ATOM     19  CG2 ILE A   2      15.940  44.442 168.432  1.00 56.74           C  
ATOM     20  CD1 ILE A   2      17.167  46.109 166.230  1.00 57.47           C  
ATOM     21  N   PRO A   3      18.861  43.074 169.818  1.00 49.84           N  
ATOM     22  CA  PRO A   3      18.943  42.171 170.964  1.00 48.05           C  
ATOM     23  C   PRO A   3      17.650  42.150 171.792  1.00 45.59           C  
ATOM     24  O   PRO A   3      16.995  43.189 171.985  1.00 44.31           O  
ATOM     25  CB  PRO A   3      20.107  42.740 171.780  1.00 48.49           C  
ATOM     26  CG  PRO A   3      20.164  44.165 171.436  1.00 49.07           C  
ATOM     27  CD  PRO A   3      19.628  44.315 170.038  1.00 49.69           C  
ATOM     28  N   ILE A   4      17.273  40.962 172.243  1.00 41.84           N  
ATOM     29  CA  ILE A   4      16.063  40.835 173.043  1.00 39.71           C  
ATOM     30  C   ILE A   4      16.459  40.341 174.442  1.00 39.70           C  
ATOM     31  O   ILE A   4      16.643  41.146 175.331  1.00 39.65           O  
ATOM     32  CB  ILE A   4      15.022  40.000 172.320  1.00 37.84           C  
ATOM     33  CG1 ILE A   4      14.763  40.672 170.967  1.00 36.87           C  
ATOM     34  CG2 ILE A   4      13.742  39.920 173.116  1.00 37.20           C  
ATOM     35  CD1 ILE A   4      13.732  39.991 170.081  1.00 36.70           C  
ATOM     36  N   VAL A   5      16.621  39.039 174.633  1.00 39.14           N  
ATOM     37  CA  VAL A   5      17.020  38.516 175.951  1.00 39.18           C  
ATOM     38  C   VAL A   5      18.547  38.687 176.161  1.00 38.35           C  
ATOM     39  O   VAL A   5      19.335  38.462 175.243  1.00 37.32           O  
ATOM     40  CB  VAL A   5      16.604  37.009 176.142  1.00 39.87           C  
ATOM     41  CG1 VAL A   5      16.959  36.516 177.543  1.00 39.97           C  
ATOM     42  CG2 VAL A   5      15.081  36.792 175.869  1.00 40.78           C  
ATOM     43  N   ASP A   6      18.921  39.156 177.350  1.00 38.23           N  
ATOM     44  CA  ASP A   6      20.325  39.344 177.736  1.00 38.11           C  
ATOM     45  C   ASP A   6      21.060  38.032 177.470  1.00 36.02           C  
ATOM     46  O   ASP A   6      20.606  36.958 177.833  1.00 34.21           O  
ATOM     47  CB  ASP A   6      20.438  39.769 179.205  1.00 39.55           C  
ATOM     48  CG  ASP A   6      21.860  39.812 179.692  1.00 41.28           C  
ATOM     49  OD1 ASP A   6      22.769  39.974 178.872  1.00 42.28           O  
ATOM     50  OD2 ASP A   6      22.093  39.690 180.909  1.00 43.75           O  
ATOM     51  N   SER A   7      22.205  38.142 176.813  1.00 35.27           N  
ATOM     52  CA  SER A   7      23.031  36.980 176.469  0.50 34.49           C  
ATOM     54  C   SER A   7      23.290  36.044 177.643  1.00 34.42           C  
ATOM     55  O   SER A   7      23.317  34.828 177.492  1.00 35.04           O  
ATOM     56  CB  SER A   7      24.378  37.451 175.891  0.50 34.07           C  
ATOM     58  OG  SER A   7      24.994  38.399 176.749  0.50 32.89           O  
ATOM     60  N   ARG A   8      23.471  36.638 178.806  1.00 35.03           N  
ATOM     61  CA  ARG A   8      23.774  35.891 180.035  1.00 35.87           C  
ATOM     62  C   ARG A   8      22.546  35.103 180.481  1.00 35.56           C  
ATOM     63  O   ARG A   8      22.622  33.965 180.943  1.00 34.19           O  
ATOM     64  CB  ARG A   8      24.254  36.863 181.108  1.00 37.55           C  
ATOM     65  CG  ARG A   8      25.498  37.652 180.652  1.00 39.77           C  
ATOM     66  CD  ARG A   8      25.964  38.693 181.647  1.00 41.88           C  
ATOM     67  NE  ARG A   8      25.048  39.826 181.830  1.00 44.06           N  
ATOM     68  CZ  ARG A   8      25.073  40.938 181.096  1.00 45.78           C  
ATOM     69  NH1 ARG A   8      25.926  41.062 180.087  1.00 47.31           N  
ATOM     70  NH2 ARG A   8      24.226  41.927 181.346  1.00 46.66           N  
ATOM     71  N   ILE A   9      21.404  35.732 180.296  1.00 35.19           N  
ATOM     72  CA  ILE A   9      20.115  35.121 180.658  1.00 34.45           C  
ATOM     73  C   ILE A   9      19.815  34.041 179.637  1.00 33.21           C  
ATOM     74  O   ILE A   9      19.370  32.944 179.971  1.00 33.08           O  
ATOM     75  CB  ILE A   9      19.005  36.165 180.742  1.00 35.67           C  
ATOM     76  CG1 ILE A   9      19.288  37.120 181.904  1.00 37.94           C  
ATOM     77  CG2 ILE A   9      17.656  35.497 180.961  1.00 36.54           C  
ATOM     78  CD1 ILE A   9      19.140  36.488 183.301  1.00 38.67           C  
ATOM     79  N   GLY A  10      20.121  34.342 178.385  1.00 33.05           N  
ATOM     80  CA  GLY A  10      19.909  33.393 177.294  1.00 32.67           C  
ATOM     81  C   GLY A  10      20.689  32.121 177.514  1.00 33.73           C  
ATOM     82  O   GLY A  10      20.174  31.016 177.347  1.00 34.55           O  
ATOM     83  N   ALA A  11      21.951  32.289 177.893  1.00 33.86           N  
ATOM     84  CA  ALA A  11      22.834  31.151 178.144  1.00 33.57           C  
ATOM     85  C   ALA A  11      22.317  30.279 179.290  1.00 32.94           C  
ATOM     86  O   ALA A  11      22.355  29.050 179.250  1.00 33.32           O  
ATOM     87  CB  ALA A  11      24.248  31.635 178.437  1.00 33.71           C  
ATOM     88  N   TYR A  12      21.806  30.948 180.306  1.00 32.50           N  
ATOM     89  CA  TYR A  12      21.264  30.273 181.497  1.00 31.54           C  
ATOM     90  C   TYR A  12      20.028  29.452 181.163  1.00 31.21           C  
ATOM     91  O   TYR A  12      19.923  28.290 181.545  1.00 29.86           O  
ATOM     92  CB  TYR A  12      20.975  31.279 182.612  1.00 31.68           C  
ATOM     93  CG  TYR A  12      20.140  30.719 183.732  1.00 31.59           C  
ATOM     94  CD1 TYR A  12      20.727  29.995 184.745  1.00 31.83           C  
ATOM     95  CD2 TYR A  12      18.764  30.931 183.772  1.00 32.12           C  
ATOM     96  CE1 TYR A  12      19.988  29.475 185.756  1.00 31.53           C  
ATOM     97  CE2 TYR A  12      17.995  30.415 184.806  1.00 31.60           C  
ATOM     98  CZ  TYR A  12      18.633  29.679 185.795  1.00 30.95           C  
ATOM     99  OH  TYR A  12      17.936  29.147 186.840  1.00 29.43           O  
ATOM    100  N   LEU A  13      19.113  30.057 180.416  1.00 30.86           N  
ATOM    101  CA  LEU A  13      17.871  29.376 180.026  1.00 32.36           C  
ATOM    102  C   LEU A  13      18.187  28.187 179.133  1.00 32.95           C  
ATOM    103  O   LEU A  13      17.608  27.115 179.256  1.00 32.96           O  
ATOM    104  CB  LEU A  13      16.894  30.346 179.337  1.00 32.27           C  
ATOM    105  CG  LEU A  13      16.342  31.470 180.220  1.00 33.25           C  
ATOM    106  CD1 LEU A  13      15.494  32.473 179.427  1.00 33.73           C  
ATOM    107  CD2 LEU A  13      15.539  30.869 181.363  1.00 32.60           C  
ATOM    108  N   ASP A  14      19.184  28.357 178.288  1.00 34.13           N  
ATOM    109  CA  ASP A  14      19.564  27.284 177.378  1.00 35.50           C  
ATOM    110  C   ASP A  14      20.176  26.123 178.188  1.00 34.88           C  
ATOM    111  O   ASP A  14      19.951  24.938 177.896  1.00 33.65           O  
ATOM    112  CB  ASP A  14      20.505  27.808 176.292  1.00 36.94           C  
ATOM    113  CG  ASP A  14      19.873  28.921 175.432  1.00 39.13           C  
ATOM    114  OD1 ASP A  14      18.635  29.190 175.532  1.00 41.29           O  
ATOM    115  OD2 ASP A  14      20.632  29.525 174.627  1.00 40.09           O  
ATOM    116  N   GLY A  15      20.904  26.484 179.240  1.00 34.66           N  
ATOM    117  CA  GLY A  15      21.548  25.503 180.134  1.00 34.33           C  
ATOM    118  C   GLY A  15      20.536  24.633 180.865  1.00 34.18           C  
ATOM    119  O   GLY A  15      20.870  23.553 181.367  1.00 32.14           O  
ATOM    120  N   LEU A  16      19.308  25.138 180.973  1.00 34.86           N  
ATOM    121  CA  LEU A  16      18.196  24.403 181.610  1.00 37.13           C  
ATOM    122  C   LEU A  16      17.526  23.470 180.583  1.00 39.73           C  
ATOM    123  O   LEU A  16      16.725  22.628 180.939  1.00 41.95           O  
ATOM    124  CB  LEU A  16      17.118  25.346 182.191  1.00 36.19           C  
ATOM    125  CG  LEU A  16      17.431  26.308 183.343  1.00 35.76           C  
ATOM    126  CD1 LEU A  16      16.213  27.196 183.597  1.00 36.12           C  
ATOM    127  CD2 LEU A  16      17.847  25.597 184.603  1.00 35.86           C  
ATOM    128  N   LEU A  17      17.807  23.672 179.299  1.00 41.52           N  
ATOM    129  CA  LEU A  17      17.208  22.827 178.248  1.00 41.54           C  
ATOM    130  C   LEU A  17      17.602  21.388 178.506  1.00 42.60           C  
ATOM    131  O   LEU A  17      18.728  21.115 178.956  1.00 42.51           O  
ATOM    132  CB  LEU A  17      17.602  23.260 176.814  1.00 40.98           C  
ATOM    133  CG  LEU A  17      16.945  24.499 176.178  1.00 40.11           C  
ATOM    134  CD1 LEU A  17      17.573  24.865 174.839  1.00 40.71           C  
ATOM    135  CD2 LEU A  17      15.472  24.267 175.993  1.00 40.09           C  
ATOM    136  N   PRO A  18      16.684  20.446 178.231  1.00 44.23           N  
ATOM    137  CA  PRO A  18      17.067  19.061 178.446  1.00 43.99           C  
ATOM    138  C   PRO A  18      17.893  18.592 177.269  1.00 44.44           C  
ATOM    139  O   PRO A  18      18.128  19.364 176.328  1.00 42.06           O  
ATOM    140  CB  PRO A  18      15.730  18.341 178.435  1.00 44.62           C  
ATOM    141  CG  PRO A  18      14.938  19.098 177.400  1.00 44.80           C  
ATOM    142  CD  PRO A  18      15.352  20.551 177.598  1.00 44.46           C  
ATOM    143  N   GLU A  19      18.333  17.341 177.329  1.00 45.19           N  
ATOM    144  CA  GLU A  19      19.115  16.750 176.233  1.00 45.95           C  
ATOM    145  C   GLU A  19      18.272  16.911 174.974  1.00 46.69           C  
ATOM    146  O   GLU A  19      17.071  16.635 174.965  1.00 46.67           O  
ATOM    147  CB  GLU A  19      19.430  15.276 176.481  1.00 46.12           C  
ATOM    148  CG  GLU A  19      20.318  14.640 175.420  1.00 45.92           C  
ATOM    149  N   ALA A  20      18.910  17.370 173.914  1.00 47.61           N  
ATOM    150  CA  ALA A  20      18.210  17.605 172.645  1.00 48.92           C  
ATOM    151  C   ALA A  20      17.790  16.339 171.903  1.00 49.20           C  
ATOM    152  O   ALA A  20      18.485  15.336 171.902  1.00 49.95           O  
ATOM    153  CB  ALA A  20      19.066  18.497 171.725  1.00 49.54           C  
ATOM    154  N   ASP A  21      16.615  16.439 171.296  1.00 49.73           N  
ATOM    155  CA  ASP A  21      16.013  15.377 170.484  1.00 49.54           C  
ATOM    156  C   ASP A  21      16.819  15.388 169.181  1.00 49.40           C  
ATOM    157  O   ASP A  21      16.957  16.447 168.563  1.00 48.73           O  
ATOM    158  CB  ASP A  21      14.516  15.671 170.267  1.00 49.93           C  
ATOM    159  CG  ASP A  21      13.764  14.575 169.504  1.00 50.36           C  
ATOM    160  OD1 ASP A  21      14.373  13.746 168.796  1.00 50.59           O  
ATOM    161  OD2 ASP A  21      12.520  14.573 169.594  1.00 50.74           O  
ATOM    162  N   PRO A  22      17.370  14.229 168.748  1.00 49.03           N  
ATOM    163  CA  PRO A  22      18.168  14.266 167.513  1.00 48.84           C  
ATOM    164  C   PRO A  22      17.332  14.657 166.305  1.00 48.56           C  
ATOM    165  O   PRO A  22      17.851  15.131 165.294  1.00 47.74           O  
ATOM    166  CB  PRO A  22      18.696  12.831 167.380  1.00 49.10           C  
ATOM    167  CG  PRO A  22      17.764  11.997 168.168  1.00 49.14           C  
ATOM    168  CD  PRO A  22      17.240  12.861 169.279  1.00 49.28           C  
ATOM    169  N   VAL A  23      16.029  14.474 166.455  1.00 48.59           N  
ATOM    170  CA  VAL A  23      15.069  14.820 165.408  1.00 48.63           C  
ATOM    171  C   VAL A  23      15.138  16.309 165.190  1.00 48.14           C  
ATOM    172  O   VAL A  23      15.164  16.817 164.071  1.00 47.99           O  
ATOM    173  CB  VAL A  23      13.620  14.544 165.822  1.00 48.67           C  
ATOM    174  CG1 VAL A  23      12.687  14.980 164.718  1.00 49.04           C  
ATOM    175  CG2 VAL A  23      13.405  13.068 166.151  1.00 49.30           C  
ATOM    176  N   VAL A  24      15.123  17.001 166.315  1.00 48.32           N  
ATOM    177  CA  VAL A  24      15.180  18.462 166.332  1.00 48.03           C  
ATOM    178  C   VAL A  24      16.560  18.945 165.891  1.00 47.76           C  
ATOM    179  O   VAL A  24      16.687  19.916 165.137  1.00 48.11           O  
ATOM    180  CB  VAL A  24      14.802  19.057 167.729  1.00 48.33           C  
ATOM    181  CG1 VAL A  24      15.057  20.549 167.771  1.00 48.17           C  
ATOM    182  CG2 VAL A  24      13.337  18.773 168.068  1.00 48.24           C  
ATOM    183  N   ALA A  25      17.587  18.227 166.331  1.00 47.19           N  
ATOM    184  CA  ALA A  25      18.978  18.582 166.010  1.00 46.14           C  
ATOM    185  C   ALA A  25      19.270  18.360 164.523  1.00 45.70           C  
ATOM    186  O   ALA A  25      20.024  19.115 163.896  1.00 45.63           O  
ATOM    187  CB  ALA A  25      19.950  17.799 166.886  1.00 46.15           C  
ATOM    188  N   ALA A  26      18.627  17.340 163.967  1.00 44.88           N  
ATOM    189  CA  ALA A  26      18.805  16.985 162.566  1.00 44.18           C  
ATOM    190  C   ALA A  26      18.163  18.044 161.705  1.00 43.88           C  
ATOM    191  O   ALA A  26      18.649  18.376 160.634  1.00 43.99           O  
ATOM    192  CB  ALA A  26      18.189  15.638 162.278  1.00 44.16           C  
HETATM  193  N   MSE A  27      17.081  18.595 162.234  1.00 44.14           N  
HETATM  194  CA  MSE A  27      16.275  19.625 161.552  1.00 43.85           C  
HETATM  195  C   MSE A  27      16.949  21.012 161.493  1.00 45.57           C  
HETATM  196  O   MSE A  27      16.831  21.740 160.503  1.00 46.22           O  
HETATM  197  CB  MSE A  27      14.880  19.707 162.197  1.00 42.03           C  
HETATM  198  CG  MSE A  27      13.995  20.756 161.602  1.00 40.72           C  
HETATM  199 SE   MSE A  27      12.142  20.602 162.181  0.75 38.02          SE  
HETATM  200  CE  MSE A  27      12.374  20.709 164.120  1.00 38.83           C  
ATOM    201  N   GLU A  28      17.659  21.358 162.556  1.00 46.88           N  
ATOM    202  CA  GLU A  28      18.382  22.635 162.645  1.00 47.71           C  
ATOM    203  C   GLU A  28      19.460  22.733 161.591  1.00 47.74           C  
ATOM    204  O   GLU A  28      19.571  23.711 160.861  1.00 48.35           O  
ATOM    205  CB  GLU A  28      19.068  22.759 164.003  1.00 48.64           C  
ATOM    206  CG  GLU A  28      18.098  22.914 165.172  1.00 49.42           C  
ATOM    207  CD  GLU A  28      18.760  22.795 166.544  1.00 50.30           C  
ATOM    208  OE1 GLU A  28      19.991  22.580 166.612  1.00 51.18           O  
ATOM    209  OE2 GLU A  28      18.030  22.905 167.557  1.00 50.94           O  
ATOM    210  N   GLN A  29      20.280  21.694 161.550  0.50 47.66           N  
ATOM    212  CA  GLN A  29      21.381  21.591 160.576  0.50 47.50           C  
ATOM    214  C   GLN A  29      20.906  21.585 159.138  0.50 47.24           C  
ATOM    216  O   GLN A  29      21.555  22.139 158.251  0.50 47.25           O  
ATOM    218  CB  GLN A  29      22.216  20.329 160.816  0.50 47.65           C  
ATOM    220  CG  GLN A  29      23.306  20.467 161.859  0.50 47.66           C  
ATOM    222  CD  GLN A  29      24.442  21.348 161.368  0.50 47.56           C  
ATOM    224  OE1 GLN A  29      24.420  21.840 160.239  0.50 47.17           O  
ATOM    226  NE2 GLN A  29      25.449  21.535 162.210  0.50 47.60           N  
ATOM    228  N   ILE A  30      19.756  20.969 158.920  1.00 47.02           N  
ATOM    229  CA  ILE A  30      19.193  20.869 157.567  1.00 46.63           C  
ATOM    230  C   ILE A  30      18.697  22.256 157.192  1.00 46.55           C  
ATOM    231  O   ILE A  30      18.721  22.667 156.032  1.00 46.33           O  
ATOM    232  CB  ILE A  30      18.041  19.887 157.456  1.00 46.72           C  
ATOM    233  CG1 ILE A  30      18.579  18.459 157.438  1.00 46.87           C  
ATOM    234  CG2 ILE A  30      17.308  20.134 156.166  1.00 46.96           C  
ATOM    235  CD1 ILE A  30      17.512  17.389 157.425  1.00 46.78           C  
ATOM    236  N   ALA A  31      18.269  22.976 158.219  1.00 46.16           N  
ATOM    237  CA  ALA A  31      17.753  24.337 158.068  1.00 46.24           C  
ATOM    238  C   ALA A  31      18.904  25.262 157.729  1.00 46.70           C  
ATOM    239  O   ALA A  31      18.797  26.161 156.883  1.00 46.26           O  
ATOM    240  CB  ALA A  31      17.056  24.811 159.360  1.00 45.98           C  
ATOM    241  N   ARG A  32      20.012  25.012 158.410  1.00 47.21           N  
ATOM    242  CA  ARG A  32      21.231  25.800 158.249  1.00 48.12           C  
ATOM    243  C   ARG A  32      21.909  25.532 156.911  1.00 48.24           C  
ATOM    244  O   ARG A  32      22.661  26.365 156.421  1.00 48.31           O  
ATOM    245  CB  ARG A  32      22.220  25.516 159.393  1.00 48.21           C  
ATOM    246  N   GLU A  33      21.613  24.386 156.309  1.00 48.53           N  
ATOM    247  CA  GLU A  33      22.246  24.029 155.036  1.00 48.92           C  
ATOM    248  C   GLU A  33      21.378  24.466 153.863  1.00 48.01           C  
ATOM    249  O   GLU A  33      21.873  24.723 152.767  1.00 47.97           O  
ATOM    250  CB  GLU A  33      22.536  22.525 154.944  1.00 49.81           C  
ATOM    251  CG  GLU A  33      21.369  21.674 154.498  1.00 50.90           C  
ATOM    252  CD  GLU A  33      21.702  20.195 154.493  1.00 51.91           C  
ATOM    253  OE1 GLU A  33      22.576  19.790 155.296  1.00 52.47           O  
ATOM    254  OE2 GLU A  33      21.079  19.439 153.708  1.00 52.70           O  
ATOM    255  N   ARG A  34      20.081  24.549 154.093  1.00 47.09           N  
ATOM    256  CA  ARG A  34      19.150  24.958 153.047  0.50 46.73           C  
ATOM    258  C   ARG A  34      18.798  26.421 153.248  1.00 46.93           C  
ATOM    259  O   ARG A  34      17.951  26.983 152.538  1.00 46.82           O  
ATOM    260  CB  ARG A  34      17.869  24.116 153.056  0.50 46.30           C  
ATOM    262  CG  ARG A  34      18.055  22.608 152.893  0.50 45.88           C  
ATOM    264  CD  ARG A  34      16.697  21.937 152.728  0.50 45.51           C  
ATOM    266  NE  ARG A  34      16.736  20.484 152.860  0.50 45.15           N  
ATOM    268  CZ  ARG A  34      15.687  19.698 152.644  0.50 45.00           C  
ATOM    270  NH1 ARG A  34      14.546  20.228 152.239  0.50 44.65           N  
ATOM    272  NH2 ARG A  34      15.785  18.388 152.798  0.50 45.17           N  
ATOM    274  N   ASN A  35      19.479  27.005 154.225  1.00 46.87           N  
ATOM    275  CA  ASN A  35      19.323  28.407 154.619  1.00 46.61           C  
ATOM    276  C   ASN A  35      17.874  28.732 154.884  1.00 46.46           C  
ATOM    277  O   ASN A  35      17.330  29.695 154.342  1.00 46.94           O  
ATOM    278  CB  ASN A  35      19.862  29.336 153.531  1.00 46.76           C  
ATOM    279  N   ILE A  36      17.261  27.901 155.718  1.00 45.38           N  
ATOM    280  CA  ILE A  36      15.846  28.023 156.065  1.00 44.86           C  
ATOM    281  C   ILE A  36      15.614  28.520 157.494  1.00 44.48           C  
ATOM    282  O   ILE A  36      16.143  27.942 158.450  1.00 44.44           O  
ATOM    283  CB  ILE A  36      15.117  26.654 155.873  1.00 44.71           C  
ATOM    284  CG1 ILE A  36      15.186  26.215 154.405  1.00 44.72           C  
ATOM    285  CG2 ILE A  36      13.657  26.746 156.337  1.00 44.56           C  
ATOM    286  CD1 ILE A  36      14.662  24.820 154.139  1.00 44.54           C  
ATOM    287  N   PRO A  37      14.866  29.634 157.644  1.00 44.04           N  
ATOM    288  CA  PRO A  37      14.600  30.083 159.022  1.00 43.78           C  
ATOM    289  C   PRO A  37      13.592  29.188 159.711  1.00 42.47           C  
ATOM    290  O   PRO A  37      12.552  28.849 159.131  1.00 42.74           O  
ATOM    291  CB  PRO A  37      14.025  31.496 158.848  1.00 44.08           C  
ATOM    292  CG  PRO A  37      13.656  31.615 157.394  1.00 44.57           C  
ATOM    293  CD  PRO A  37      14.491  30.641 156.632  1.00 44.04           C  
ATOM    294  N   ILE A  38      13.949  28.767 160.917  1.00 40.44           N  
ATOM    295  CA  ILE A  38      13.068  27.915 161.740  1.00 40.04           C  
ATOM    296  C   ILE A  38      12.989  28.396 163.193  1.00 39.59           C  
ATOM    297  O   ILE A  38      13.861  29.099 163.710  1.00 39.99           O  
ATOM    298  CB  ILE A  38      13.458  26.379 161.720  1.00 39.70           C  
ATOM    299  CG1 ILE A  38      14.797  26.116 162.424  1.00 39.37           C  
ATOM    300  CG2 ILE A  38      13.436  25.805 160.282  1.00 39.58           C  
ATOM    301  CD1 ILE A  38      15.137  24.618 162.552  1.00 38.81           C  
ATOM    302  N   VAL A  39      11.882  28.020 163.810  1.00 38.90           N  
ATOM    303  CA  VAL A  39      11.593  28.303 165.216  1.00 38.51           C  
ATOM    304  C   VAL A  39      12.707  27.782 166.143  1.00 36.88           C  
ATOM    305  O   VAL A  39      13.003  26.602 166.082  1.00 36.05           O  
ATOM    306  CB  VAL A  39      10.186  27.672 165.596  1.00 39.57           C  
ATOM    307  CG1 VAL A  39      10.031  27.401 167.059  1.00 40.88           C  
ATOM    308  CG2 VAL A  39       9.053  28.568 165.057  1.00 40.51           C  
ATOM    309  N   ASP A  40      13.333  28.629 166.976  1.00 34.58           N  
ATOM    310  CA  ASP A  40      14.375  28.111 167.911  1.00 34.37           C  
ATOM    311  C   ASP A  40      13.737  27.220 169.009  1.00 33.31           C  
ATOM    312  O   ASP A  40      12.509  27.170 169.154  1.00 31.22           O  
ATOM    313  CB  ASP A  40      15.363  29.167 168.489  1.00 35.30           C  
ATOM    314  CG  ASP A  40      14.767  30.156 169.502  1.00 36.17           C  
ATOM    315  OD1 ASP A  40      13.629  30.038 170.018  1.00 36.30           O  
ATOM    316  OD2 ASP A  40      15.541  31.076 169.858  1.00 37.32           O  
ATOM    317  N   ARG A  41      14.577  26.550 169.789  1.00 32.35           N  
ATOM    318  CA  ARG A  41      14.060  25.617 170.830  1.00 32.65           C  
ATOM    319  C   ARG A  41      13.241  26.248 171.927  1.00 31.09           C  
ATOM    320  O   ARG A  41      12.246  25.679 172.327  1.00 30.99           O  
ATOM    321  CB  ARG A  41      15.164  24.778 171.486  1.00 34.00           C  
ATOM    322  CG  ARG A  41      15.716  23.667 170.615  1.00 35.46           C  
ATOM    323  CD  ARG A  41      16.834  22.906 171.338  1.00 35.95           C  
ATOM    324  NE  ARG A  41      16.400  22.107 172.496  1.00 36.87           N  
ATOM    325  CZ  ARG A  41      17.262  21.551 173.356  1.00 36.58           C  
ATOM    326  NH1 ARG A  41      18.550  21.793 173.232  1.00 36.00           N  
ATOM    327  NH2 ARG A  41      16.849  20.832 174.384  1.00 36.97           N  
ATOM    328  N   GLN A  42      13.646  27.408 172.424  1.00 30.31           N  
ATOM    329  CA  GLN A  42      12.893  28.052 173.501  1.00 31.34           C  
ATOM    330  C   GLN A  42      11.503  28.406 172.993  1.00 30.81           C  
ATOM    331  O   GLN A  42      10.508  28.312 173.719  1.00 31.40           O  
ATOM    332  CB  GLN A  42      13.593  29.314 174.011  1.00 32.96           C  
ATOM    333  CG  GLN A  42      14.943  29.046 174.676  1.00 35.21           C  
ATOM    334  CD  GLN A  42      14.818  28.277 175.969  1.00 35.50           C  
ATOM    335  OE1 GLN A  42      13.719  28.033 176.448  1.00 36.81           O  
ATOM    336  NE2 GLN A  42      15.948  27.939 176.567  1.00 36.28           N  
ATOM    337  N   THR A  43      11.444  28.807 171.722  1.00 30.01           N  
ATOM    338  CA  THR A  43      10.190  29.198 171.101  1.00 30.12           C  
ATOM    339  C   THR A  43       9.306  27.984 170.847  1.00 29.89           C  
ATOM    340  O   THR A  43       8.112  28.017 171.118  1.00 30.78           O  
ATOM    341  CB  THR A  43      10.424  30.033 169.795  1.00 31.53           C  
ATOM    342  OG1 THR A  43      11.164  31.214 170.140  1.00 31.24           O  
ATOM    343  CG2 THR A  43       9.109  30.441 169.150  1.00 31.65           C  
ATOM    344  N   GLY A  44       9.896  26.913 170.354  1.00 29.24           N  
ATOM    345  CA  GLY A  44       9.141  25.698 170.077  1.00 29.34           C  
ATOM    346  C   GLY A  44       8.558  25.148 171.369  1.00 29.55           C  
ATOM    347  O   GLY A  44       7.420  24.696 171.401  1.00 29.76           O  
ATOM    348  N   ARG A  45       9.352  25.197 172.433  1.00 28.55           N  
ATOM    349  CA  ARG A  45       8.894  24.688 173.751  1.00 28.76           C  
ATOM    350  C   ARG A  45       7.677  25.496 174.226  1.00 28.89           C  
ATOM    351  O   ARG A  45       6.730  24.959 174.778  1.00 28.90           O  
ATOM    352  CB  ARG A  45      10.031  24.672 174.786  1.00 28.02           C  
ATOM    353  CG  ARG A  45      11.115  23.642 174.481  1.00 28.20           C  
ATOM    354  CD  ARG A  45      12.222  23.592 175.537  1.00 28.22           C  
ATOM    355  NE  ARG A  45      11.750  23.249 176.878  1.00 27.42           N  
ATOM    356  CZ  ARG A  45      11.575  22.002 177.296  1.00 29.12           C  
ATOM    357  NH1 ARG A  45      11.807  20.993 176.482  1.00 28.17           N  
ATOM    358  NH2 ARG A  45      11.141  21.753 178.511  1.00 30.13           N  
ATOM    359  N   LEU A  46       7.677  26.786 173.932  1.00 28.62           N  
ATOM    360  CA  LEU A  46       6.550  27.648 174.324  1.00 28.96           C  
ATOM    361  C   LEU A  46       5.343  27.247 173.521  1.00 29.23           C  
ATOM    362  O   LEU A  46       4.240  27.196 174.054  1.00 29.62           O  
ATOM    363  CB  LEU A  46       6.823  29.124 174.114  1.00 29.41           C  
ATOM    364  CG  LEU A  46       5.659  30.046 174.505  1.00 30.52           C  
ATOM    365  CD1 LEU A  46       5.337  29.936 175.993  1.00 31.14           C  
ATOM    366  CD2 LEU A  46       5.978  31.487 174.072  1.00 31.81           C  
ATOM    367  N   LEU A  47       5.554  26.943 172.246  1.00 28.98           N  
ATOM    368  CA  LEU A  47       4.449  26.526 171.367  1.00 30.38           C  
ATOM    369  C   LEU A  47       3.806  25.264 171.915  1.00 29.33           C  
ATOM    370  O   LEU A  47       2.596  25.126 171.995  1.00 28.68           O  
ATOM    371  CB  LEU A  47       4.912  26.236 169.944  1.00 29.91           C  
ATOM    372  CG  LEU A  47       5.445  27.413 169.102  1.00 31.66           C  
ATOM    373  CD1 LEU A  47       5.733  26.978 167.645  1.00 31.66           C  
ATOM    374  CD2 LEU A  47       4.492  28.560 169.084  1.00 30.60           C  
ATOM    375  N   TYR A  48       4.661  24.320 172.237  1.00 29.09           N  
ATOM    376  CA  TYR A  48       4.209  23.046 172.831  1.00 28.32           C  
ATOM    377  C   TYR A  48       3.374  23.266 174.090  1.00 27.60           C  
ATOM    378  O   TYR A  48       2.292  22.726 174.229  1.00 26.60           O  
ATOM    379  CB  TYR A  48       5.396  22.136 173.169  1.00 28.51           C  
ATOM    380  CG  TYR A  48       4.975  20.811 173.833  1.00 29.33           C  
ATOM    381  CD1 TYR A  48       4.652  19.689 173.074  1.00 29.94           C  
ATOM    382  CD2 TYR A  48       4.880  20.714 175.216  1.00 29.93           C  
ATOM    383  CE1 TYR A  48       4.268  18.483 173.689  1.00 29.92           C  
ATOM    384  CE2 TYR A  48       4.484  19.533 175.839  1.00 29.91           C  
ATOM    385  CZ  TYR A  48       4.174  18.421 175.068  1.00 29.84           C  
ATOM    386  OH  TYR A  48       3.790  17.262 175.712  1.00 29.84           O  
ATOM    387  N   LEU A  49       3.892  24.085 174.995  1.00 27.17           N  
ATOM    388  CA  LEU A  49       3.217  24.331 176.263  1.00 28.87           C  
ATOM    389  C   LEU A  49       1.872  25.007 176.050  1.00 27.73           C  
ATOM    390  O   LEU A  49       0.865  24.614 176.649  1.00 28.35           O  
ATOM    391  CB  LEU A  49       4.111  25.088 177.265  1.00 29.58           C  
ATOM    392  CG  LEU A  49       3.485  25.173 178.675  1.00 31.70           C  
ATOM    393  CD1 LEU A  49       4.523  25.012 179.814  1.00 32.52           C  
ATOM    394  CD2 LEU A  49       2.629  26.472 178.793  1.00 32.98           C  
ATOM    395  N   LEU A  50       1.838  26.006 175.181  1.00 28.64           N  
ATOM    396  CA  LEU A  50       0.569  26.715 174.939  1.00 28.25           C  
ATOM    397  C   LEU A  50      -0.487  25.771 174.347  1.00 27.67           C  
ATOM    398  O   LEU A  50      -1.690  25.815 174.667  1.00 27.58           O  
ATOM    399  CB  LEU A  50       0.809  27.930 174.009  1.00 28.95           C  
ATOM    400  CG  LEU A  50       1.611  29.099 174.590  1.00 29.99           C  
ATOM    401  CD1 LEU A  50       1.957  30.099 173.489  1.00 30.79           C  
ATOM    402  CD2 LEU A  50       0.875  29.775 175.752  1.00 31.60           C  
ATOM    403  N   ALA A  51      -0.024  24.879 173.490  1.00 27.31           N  
ATOM    404  CA  ALA A  51      -0.901  23.935 172.807  1.00 28.44           C  
ATOM    405  C   ALA A  51      -1.427  22.929 173.808  1.00 28.15           C  
ATOM    406  O   ALA A  51      -2.594  22.580 173.798  1.00 29.63           O  
ATOM    407  CB  ALA A  51      -0.178  23.239 171.630  1.00 27.82           C  
ATOM    408  N   ARG A  52      -0.563  22.484 174.709  1.00 27.77           N  
ATOM    409  CA  ARG A  52      -1.025  21.553 175.748  1.00 27.72           C  
ATOM    410  C   ARG A  52      -2.117  22.184 176.626  1.00 27.59           C  
ATOM    411  O   ARG A  52      -3.114  21.565 176.931  1.00 26.86           O  
ATOM    412  CB  ARG A  52       0.093  21.075 176.663  1.00 28.06           C  
ATOM    413  CG  ARG A  52       1.053  20.068 176.077  1.00 28.06           C  
ATOM    414  CD  ARG A  52       0.373  18.813 175.498  1.00 28.45           C  
ATOM    415  NE  ARG A  52      -0.410  18.011 176.439  1.00 29.30           N  
ATOM    416  CZ  ARG A  52       0.052  16.976 177.136  1.00 30.20           C  
ATOM    417  NH1 ARG A  52       1.328  16.600 177.067  1.00 30.72           N  
ATOM    418  NH2 ARG A  52      -0.781  16.348 177.940  1.00 30.29           N  
ATOM    419  N   ILE A  53      -1.939  23.432 177.037  1.00 28.67           N  
ATOM    420  CA  ILE A  53      -2.957  24.044 177.917  1.00 29.77           C  
ATOM    421  C   ILE A  53      -4.187  24.463 177.150  1.00 28.97           C  
ATOM    422  O   ILE A  53      -5.284  24.491 177.683  1.00 29.01           O  
ATOM    423  CB  ILE A  53      -2.439  25.223 178.828  1.00 32.24           C  
ATOM    424  CG1 ILE A  53      -1.988  26.400 178.010  1.00 32.83           C  
ATOM    425  CG2 ILE A  53      -1.313  24.729 179.785  1.00 33.16           C  
ATOM    426  CD1 ILE A  53      -1.701  27.675 178.867  1.00 33.57           C  
ATOM    427  N   LYS A  54      -4.022  24.755 175.880  1.00 29.35           N  
ATOM    428  CA  LYS A  54      -5.166  25.150 175.062  1.00 29.24           C  
ATOM    429  C   LYS A  54      -6.066  23.945 174.700  1.00 29.84           C  
ATOM    430  O   LYS A  54      -7.289  24.074 174.638  1.00 29.87           O  
ATOM    431  CB  LYS A  54      -4.678  25.761 173.742  1.00 29.51           C  
ATOM    432  CG  LYS A  54      -5.779  26.298 172.804  1.00 29.85           C  
ATOM    433  CD  LYS A  54      -6.338  27.620 173.260  1.00 29.59           C  
ATOM    434  CE  LYS A  54      -7.355  28.201 172.246  1.00 29.55           C  
ATOM    435  NZ  LYS A  54      -8.674  27.439 172.266  1.00 28.62           N  
ATOM    436  N   GLN A  55      -5.431  22.796 174.489  1.00 30.07           N  
ATOM    437  CA  GLN A  55      -6.120  21.536 174.075  0.50 30.44           C  
ATOM    439  C   GLN A  55      -6.906  21.725 172.767  1.00 30.53           C  
ATOM    440  O   GLN A  55      -8.123  21.435 172.691  1.00 29.63           O  
ATOM    441  CB  GLN A  55      -7.093  20.987 175.116  0.50 31.08           C  
ATOM    443  CG  GLN A  55      -6.536  20.646 176.459  0.50 31.70           C  
ATOM    445  CD  GLN A  55      -7.493  19.718 177.209  0.50 31.78           C  
ATOM    447  OE1 GLN A  55      -8.692  19.733 176.979  0.50 31.86           O  
ATOM    449  NE2 GLN A  55      -6.956  18.889 178.067  0.50 32.40           N  
ATOM    451  N   PRO A  56      -6.237  22.187 171.727  1.00 30.17           N  
ATOM    452  CA  PRO A  56      -6.967  22.403 170.497  1.00 30.43           C  
ATOM    453  C   PRO A  56      -7.332  21.152 169.737  1.00 31.91           C  
ATOM    454  O   PRO A  56      -6.662  20.134 169.838  1.00 31.43           O  
ATOM    455  CB  PRO A  56      -5.951  23.162 169.643  1.00 30.63           C  
ATOM    456  CG  PRO A  56      -4.656  22.464 170.004  1.00 30.67           C  
ATOM    457  CD  PRO A  56      -4.777  22.335 171.536  1.00 31.08           C  
ATOM    458  N   GLN A  57      -8.429  21.274 169.001  1.00 32.20           N  
ATOM    459  CA  GLN A  57      -8.939  20.211 168.154  0.50 32.03           C  
ATOM    461  C   GLN A  57      -8.360  20.416 166.746  1.00 32.03           C  
ATOM    462  O   GLN A  57      -8.158  19.455 165.996  1.00 31.90           O  
ATOM    463  CB  GLN A  57     -10.471  20.240 168.174  0.50 32.85           C  
ATOM    465  CG  GLN A  57     -11.030  20.185 169.601  0.50 33.01           C  
ATOM    467  CD  GLN A  57     -12.474  20.612 169.703  0.50 34.38           C  
ATOM    469  OE1 GLN A  57     -12.839  21.328 170.636  0.50 35.62           O  
ATOM    471  NE2 GLN A  57     -13.284  20.252 168.715  0.50 34.73           N  
ATOM    473  N   LEU A  58      -8.065  21.681 166.442  1.00 30.91           N  
ATOM    474  CA  LEU A  58      -7.503  22.112 165.148  1.00 29.90           C  
ATOM    475  C   LEU A  58      -6.496  23.255 165.231  1.00 29.32           C  
ATOM    476  O   LEU A  58      -6.738  24.333 165.756  1.00 27.92           O  
ATOM    477  CB  LEU A  58      -8.634  22.506 164.165  1.00 29.81           C  
ATOM    478  CG  LEU A  58      -8.259  22.963 162.737  1.00 30.33           C  
ATOM    479  CD1 LEU A  58      -7.470  21.857 161.995  1.00 30.49           C  
ATOM    480  CD2 LEU A  58      -9.475  23.405 161.903  1.00 30.11           C  
ATOM    481  N   VAL A  59      -5.339  22.934 164.703  1.00 29.34           N  
ATOM    482  CA  VAL A  59      -4.214  23.836 164.597  1.00 28.91           C  
ATOM    483  C   VAL A  59      -3.888  23.965 163.129  1.00 27.79           C  
ATOM    484  O   VAL A  59      -3.681  22.966 162.439  1.00 30.01           O  
ATOM    485  CB  VAL A  59      -2.937  23.313 165.330  1.00 28.01           C  
ATOM    486  CG1 VAL A  59      -1.763  24.299 165.128  1.00 27.61           C  
ATOM    487  CG2 VAL A  59      -3.212  23.036 166.824  1.00 28.52           C  
ATOM    488  N   VAL A  60      -3.807  25.208 162.682  1.00 28.61           N  
ATOM    489  CA  VAL A  60      -3.486  25.544 161.299  1.00 28.72           C  
ATOM    490  C   VAL A  60      -2.175  26.364 161.229  1.00 29.65           C  
ATOM    491  O   VAL A  60      -1.973  27.362 161.929  1.00 29.38           O  
ATOM    492  CB  VAL A  60      -4.696  26.232 160.610  1.00 28.21           C  
ATOM    493  CG1 VAL A  60      -4.363  26.637 159.152  1.00 27.90           C  
ATOM    494  CG2 VAL A  60      -5.929  25.278 160.682  1.00 26.99           C  
ATOM    495  N   VAL A  61      -1.273  25.852 160.392  1.00 29.31           N  
ATOM    496  CA  VAL A  61       0.053  26.410 160.185  1.00 29.54           C  
ATOM    497  C   VAL A  61       0.265  26.764 158.715  1.00 31.29           C  
ATOM    498  O   VAL A  61       0.672  25.914 157.928  1.00 30.89           O  
ATOM    499  CB  VAL A  61       1.122  25.380 160.607  1.00 28.93           C  
ATOM    500  CG1 VAL A  61       2.496  25.991 160.563  1.00 28.61           C  
ATOM    501  CG2 VAL A  61       0.799  24.839 162.008  1.00 28.75           C  
ATOM    502  N   PRO A  62      -0.060  28.009 158.325  1.00 31.80           N  
ATOM    503  CA  PRO A  62       0.127  28.427 156.940  1.00 32.69           C  
ATOM    504  C   PRO A  62       1.534  28.911 156.705  1.00 32.22           C  
ATOM    505  O   PRO A  62       1.852  30.043 157.032  1.00 33.14           O  
ATOM    506  CB  PRO A  62      -0.868  29.588 156.763  1.00 33.06           C  
ATOM    507  CG  PRO A  62      -1.451  29.870 158.112  1.00 33.13           C  
ATOM    508  CD  PRO A  62      -0.769  29.015 159.133  1.00 33.25           C  
ATOM    509  N   GLY A  63       2.330  28.037 156.096  1.00 31.54           N  
ATOM    510  CA  GLY A  63       3.748  28.271 155.813  1.00 31.45           C  
ATOM    511  C   GLY A  63       4.549  27.687 156.970  1.00 31.81           C  
ATOM    512  O   GLY A  63       4.363  28.053 158.120  1.00 31.48           O  
ATOM    513  N   ASP A  64       5.442  26.756 156.675  1.00 32.59           N  
ATOM    514  CA  ASP A  64       6.210  26.147 157.747  1.00 31.93           C  
ATOM    515  C   ASP A  64       7.489  25.482 157.249  1.00 32.11           C  
ATOM    516  O   ASP A  64       7.495  24.351 156.731  1.00 30.92           O  
ATOM    517  CB  ASP A  64       5.307  25.151 158.498  1.00 31.80           C  
ATOM    518  CG  ASP A  64       5.910  24.661 159.793  1.00 31.65           C  
ATOM    519  OD1 ASP A  64       6.852  25.298 160.303  1.00 31.71           O  
ATOM    520  OD2 ASP A  64       5.413  23.649 160.339  1.00 30.25           O  
ATOM    521  N   GLY A  65       8.570  26.243 157.409  1.00 31.26           N  
ATOM    522  CA  GLY A  65       9.905  25.814 157.056  1.00 31.82           C  
ATOM    523  C   GLY A  65      10.255  24.519 157.773  1.00 31.18           C  
ATOM    524  O   GLY A  65      10.308  24.446 159.017  1.00 30.00           O  
ATOM    525  N   LEU A  66      10.461  23.501 156.936  1.00 31.46           N  
ATOM    526  CA  LEU A  66      10.823  22.145 157.343  1.00 31.70           C  
ATOM    527  C   LEU A  66       9.795  21.486 158.250  1.00 30.81           C  
ATOM    528  O   LEU A  66      10.058  20.427 158.814  1.00 31.19           O  
ATOM    529  CB  LEU A  66      12.192  22.123 158.040  1.00 31.61           C  
ATOM    530  CG  LEU A  66      13.406  22.620 157.261  1.00 32.10           C  
ATOM    531  CD1 LEU A  66      14.612  22.486 158.160  1.00 31.83           C  
ATOM    532  CD2 LEU A  66      13.618  21.865 155.955  1.00 31.71           C  
ATOM    533  N   GLY A  67       8.616  22.077 158.332  1.00 29.78           N  
ATOM    534  CA  GLY A  67       7.562  21.547 159.196  1.00 30.72           C  
ATOM    535  C   GLY A  67       7.941  21.694 160.667  1.00 31.68           C  
ATOM    536  O   GLY A  67       7.443  20.987 161.541  1.00 31.33           O  
ATOM    537  N   CYS A  68       8.807  22.649 160.944  1.00 32.82           N  
ATOM    538  CA  CYS A  68       9.265  22.843 162.325  1.00 34.82           C  
ATOM    539  C   CYS A  68       8.147  23.174 163.329  1.00 32.94           C  
ATOM    540  O   CYS A  68       8.069  22.592 164.413  1.00 32.48           O  
ATOM    541  CB  CYS A  68      10.346  23.918 162.391  1.00 37.19           C  
ATOM    542  SG  CYS A  68      10.999  24.136 164.050  1.00 42.99           S  
ATOM    543  N   ALA A  69       7.290  24.118 162.968  1.00 31.65           N  
ATOM    544  CA  ALA A  69       6.184  24.529 163.848  1.00 30.83           C  
ATOM    545  C   ALA A  69       5.204  23.384 164.039  1.00 31.05           C  
ATOM    546  O   ALA A  69       4.744  23.091 165.147  1.00 31.61           O  
ATOM    547  CB  ALA A  69       5.451  25.775 163.269  1.00 29.61           C  
ATOM    548  N   SER A  70       4.927  22.707 162.938  1.00 30.26           N  
ATOM    549  CA  SER A  70       3.980  21.574 162.925  1.00 30.34           C  
ATOM    550  C   SER A  70       4.501  20.425 163.772  1.00 30.12           C  
ATOM    551  O   SER A  70       3.738  19.672 164.371  1.00 29.58           O  
ATOM    552  CB  SER A  70       3.729  21.106 161.494  1.00 31.12           C  
ATOM    553  OG  SER A  70       3.189  22.154 160.705  1.00 31.28           O  
ATOM    554  N   TRP A  71       5.823  20.323 163.841  1.00 30.65           N  
ATOM    555  CA  TRP A  71       6.447  19.261 164.605  1.00 32.09           C  
ATOM    556  C   TRP A  71       6.128  19.480 166.092  1.00 31.32           C  
ATOM    557  O   TRP A  71       5.718  18.551 166.800  1.00 31.31           O  
ATOM    558  CB  TRP A  71       7.947  19.196 164.315  1.00 33.40           C  
ATOM    559  CG  TRP A  71       8.573  18.082 164.976  1.00 35.16           C  
ATOM    560  CD1 TRP A  71       8.662  16.783 164.523  1.00 37.10           C  
ATOM    561  CD2 TRP A  71       9.203  18.105 166.238  1.00 36.59           C  
ATOM    562  NE1 TRP A  71       9.323  16.010 165.441  1.00 37.50           N  
ATOM    563  CE2 TRP A  71       9.658  16.799 166.508  1.00 37.45           C  
ATOM    564  CE3 TRP A  71       9.429  19.096 167.176  1.00 36.40           C  
ATOM    565  CZ2 TRP A  71      10.336  16.477 167.674  1.00 38.06           C  
ATOM    566  CZ3 TRP A  71      10.098  18.764 168.339  1.00 37.76           C  
ATOM    567  CH2 TRP A  71      10.538  17.481 168.577  1.00 37.79           C  
ATOM    568  N   TRP A  72       6.270  20.724 166.541  1.00 30.78           N  
ATOM    569  CA  TRP A  72       6.009  21.079 167.960  1.00 30.73           C  
ATOM    570  C   TRP A  72       4.547  20.908 168.323  1.00 29.75           C  
ATOM    571  O   TRP A  72       4.194  20.350 169.365  1.00 28.28           O  
ATOM    572  CB  TRP A  72       6.472  22.506 168.302  1.00 31.25           C  
ATOM    573  CG  TRP A  72       7.961  22.647 168.300  1.00 31.42           C  
ATOM    574  CD1 TRP A  72       8.743  23.103 167.275  1.00 32.30           C  
ATOM    575  CD2 TRP A  72       8.848  22.283 169.355  1.00 30.67           C  
ATOM    576  NE1 TRP A  72      10.074  23.061 167.646  1.00 32.61           N  
ATOM    577  CE2 TRP A  72      10.164  22.544 168.908  1.00 31.84           C  
ATOM    578  CE3 TRP A  72       8.667  21.718 170.623  1.00 32.22           C  
ATOM    579  CZ2 TRP A  72      11.280  22.308 169.699  1.00 32.19           C  
ATOM    580  CZ3 TRP A  72       9.779  21.477 171.401  1.00 32.45           C  
ATOM    581  CH2 TRP A  72      11.073  21.769 170.931  1.00 32.03           C  
ATOM    582  N   PHE A  73       3.695  21.375 167.426  1.00 28.78           N  
ATOM    583  CA  PHE A  73       2.245  21.271 167.631  1.00 28.97           C  
ATOM    584  C   PHE A  73       1.718  19.820 167.582  1.00 29.48           C  
ATOM    585  O   PHE A  73       0.834  19.436 168.368  1.00 29.89           O  
ATOM    586  CB  PHE A  73       1.467  22.130 166.628  1.00 28.51           C  
ATOM    587  CG  PHE A  73       1.617  23.610 166.841  1.00 29.90           C  
ATOM    588  CD1 PHE A  73       1.190  24.190 168.036  1.00 29.54           C  
ATOM    589  CD2 PHE A  73       2.074  24.433 165.834  1.00 30.05           C  
ATOM    590  CE1 PHE A  73       1.283  25.563 168.250  1.00 29.95           C  
ATOM    591  CE2 PHE A  73       2.158  25.815 166.043  1.00 31.05           C  
ATOM    592  CZ  PHE A  73       1.757  26.372 167.250  1.00 30.35           C  
ATOM    593  N   ALA A  74       2.243  19.025 166.650  1.00 29.38           N  
ATOM    594  CA  ALA A  74       1.793  17.634 166.480  1.00 29.56           C  
ATOM    595  C   ALA A  74       1.994  16.813 167.743  1.00 30.02           C  
ATOM    596  O   ALA A  74       1.206  15.930 168.077  1.00 30.58           O  
ATOM    597  CB  ALA A  74       2.514  16.955 165.284  1.00 29.19           C  
ATOM    598  N   ARG A  75       3.070  17.137 168.423  1.00 31.12           N  
ATOM    599  CA  ARG A  75       3.475  16.449 169.653  1.00 33.24           C  
ATOM    600  C   ARG A  75       2.570  16.760 170.825  1.00 32.13           C  
ATOM    601  O   ARG A  75       2.528  16.018 171.797  1.00 29.51           O  
ATOM    602  CB  ARG A  75       4.904  16.858 170.058  1.00 36.17           C  
ATOM    603  CG  ARG A  75       5.981  16.548 169.023  1.00 39.43           C  
ATOM    604  CD  ARG A  75       7.386  16.478 169.644  1.00 42.20           C  
ATOM    605  NE  ARG A  75       7.372  15.570 170.799  1.00 44.47           N  
ATOM    606  CZ  ARG A  75       8.415  14.946 171.332  1.00 47.47           C  
ATOM    607  NH1 ARG A  75       9.617  14.993 170.768  1.00 48.62           N  
ATOM    608  NH2 ARG A  75       8.220  14.191 172.412  1.00 48.54           N  
ATOM    609  N   ALA A  76       1.838  17.862 170.689  1.00 31.34           N  
ATOM    610  CA  ALA A  76       0.963  18.395 171.751  1.00 32.08           C  
ATOM    611  C   ALA A  76      -0.510  18.071 171.663  1.00 33.08           C  
ATOM    612  O   ALA A  76      -1.267  18.411 172.568  1.00 33.54           O  
ATOM    613  CB  ALA A  76       1.123  19.948 171.799  1.00 29.63           C  
ATOM    614  N   ILE A  77      -0.908  17.396 170.594  1.00 34.34           N  
ATOM    615  CA  ILE A  77      -2.336  17.096 170.381  1.00 35.02           C  
ATOM    616  C   ILE A  77      -2.705  15.621 170.361  1.00 36.29           C  
ATOM    617  O   ILE A  77      -1.871  14.733 170.121  1.00 34.86           O  
ATOM    618  CB  ILE A  77      -2.859  17.766 169.048  1.00 34.41           C  
ATOM    619  CG1 ILE A  77      -2.251  17.093 167.823  1.00 34.17           C  
ATOM    620  CG2 ILE A  77      -2.568  19.302 169.021  1.00 35.49           C  
ATOM    621  CD1 ILE A  77      -2.932  17.456 166.522  1.00 34.02           C  
ATOM    622  N   SER A  78      -3.986  15.361 170.613  1.00 37.76           N  
ATOM    623  CA  SER A  78      -4.488  13.967 170.591  1.00 38.74           C  
ATOM    624  C   SER A  78      -4.721  13.473 169.183  1.00 37.54           C  
ATOM    625  O   SER A  78      -4.693  14.214 168.197  1.00 35.65           O  
ATOM    626  CB  SER A  78      -5.805  13.785 171.362  1.00 40.32           C  
ATOM    627  OG  SER A  78      -6.871  14.547 170.782  1.00 41.83           O  
ATOM    628  N   ILE A  79      -5.003  12.188 169.143  1.00 36.88           N  
ATOM    629  CA  ILE A  79      -5.266  11.476 167.895  0.50 36.77           C  
ATOM    631  C   ILE A  79      -6.565  11.983 167.278  1.00 37.09           C  
ATOM    632  O   ILE A  79      -6.778  11.894 166.064  1.00 36.77           O  
ATOM    633  CB  ILE A  79      -5.359   9.935 168.118  0.50 36.72           C  
ATOM    635  CG1 ILE A  79      -5.377   9.185 166.782  0.50 36.62           C  
ATOM    637  CG2 ILE A  79      -6.579   9.581 168.963  0.50 36.28           C  
ATOM    639  CD1 ILE A  79      -5.419   7.682 166.926  0.50 36.54           C  
ATOM    641  N   SER A  80      -7.416  12.535 168.129  1.00 37.22           N  
ATOM    642  CA  SER A  80      -8.726  13.043 167.700  1.00 38.63           C  
ATOM    643  C   SER A  80      -8.620  14.472 167.122  1.00 37.74           C  
ATOM    644  O   SER A  80      -9.541  14.976 166.472  1.00 39.64           O  
ATOM    645  CB  SER A  80      -9.748  12.956 168.849  1.00 39.56           C  
ATOM    646  OG  SER A  80      -9.329  13.699 169.980  1.00 43.12           O  
ATOM    647  N   SER A  81      -7.460  15.077 167.331  1.00 35.54           N  
ATOM    648  CA  SER A  81      -7.178  16.435 166.825  1.00 33.97           C  
ATOM    649  C   SER A  81      -6.303  16.388 165.595  1.00 32.92           C  
ATOM    650  O   SER A  81      -5.745  15.346 165.215  1.00 32.67           O  
ATOM    651  CB  SER A  81      -6.491  17.277 167.873  1.00 34.09           C  
ATOM    652  OG  SER A  81      -7.240  17.280 169.062  1.00 34.82           O  
ATOM    653  N   ARG A  82      -6.171  17.562 164.992  1.00 32.44           N  
ATOM    654  CA  ARG A  82      -5.389  17.746 163.773  1.00 32.07           C  
ATOM    655  C   ARG A  82      -4.604  19.033 163.657  1.00 31.36           C  
ATOM    656  O   ARG A  82      -4.987  20.078 164.172  1.00 30.49           O  
ATOM    657  CB  ARG A  82      -6.313  17.732 162.534  1.00 32.69           C  
ATOM    658  CG  ARG A  82      -7.013  16.406 162.215  1.00 34.87           C  
ATOM    659  CD  ARG A  82      -6.042  15.333 161.793  1.00 34.99           C  
ATOM    660  NE  ARG A  82      -6.732  14.091 161.482  1.00 36.57           N  
ATOM    661  CZ  ARG A  82      -7.037  13.143 162.365  1.00 36.78           C  
ATOM    662  NH1 ARG A  82      -6.704  13.267 163.643  1.00 36.44           N  
ATOM    663  NH2 ARG A  82      -7.660  12.045 161.960  1.00 37.10           N  
ATOM    664  N   VAL A  83      -3.454  18.873 163.010  1.00 30.86           N  
ATOM    665  CA  VAL A  83      -2.592  19.979 162.618  1.00 30.55           C  
ATOM    666  C   VAL A  83      -2.660  19.951 161.089  1.00 30.71           C  
ATOM    667  O   VAL A  83      -2.503  18.892 160.445  1.00 30.03           O  
ATOM    668  CB  VAL A  83      -1.110  19.887 163.031  1.00 31.29           C  
ATOM    669  CG1 VAL A  83      -0.357  21.066 162.436  1.00 30.71           C  
ATOM    670  CG2 VAL A  83      -0.929  19.845 164.543  1.00 30.67           C  
ATOM    671  N   VAL A  84      -2.986  21.099 160.530  1.00 30.51           N  
ATOM    672  CA  VAL A  84      -3.069  21.285 159.090  1.00 30.71           C  
ATOM    673  C   VAL A  84      -1.953  22.246 158.707  1.00 31.51           C  
ATOM    674  O   VAL A  84      -1.937  23.424 159.084  1.00 30.27           O  
ATOM    675  CB  VAL A  84      -4.418  21.863 158.632  1.00 30.41           C  
ATOM    676  CG1 VAL A  84      -4.420  22.032 157.107  1.00 30.52           C  
ATOM    677  CG2 VAL A  84      -5.584  20.979 159.087  1.00 30.20           C  
HETATM  678  N   MSE A  85      -1.014  21.705 157.961  1.00 31.68           N  
HETATM  679  CA  MSE A  85       0.150  22.434 157.497  1.00 32.72           C  
HETATM  680  C   MSE A  85       0.120  22.587 155.989  1.00 32.54           C  
HETATM  681  O   MSE A  85      -0.097  21.619 155.243  1.00 30.64           O  
HETATM  682  CB  MSE A  85       1.387  21.668 157.972  1.00 34.09           C  
HETATM  683  CG  MSE A  85       2.799  22.184 157.624  1.00 36.10           C  
HETATM  684 SE   MSE A  85       3.395  22.135 155.765  0.75 38.33          SE  
HETATM  685  CE  MSE A  85       5.323  22.022 156.116  1.00 36.58           C  
ATOM    686  N   ILE A  86       0.292  23.839 155.573  1.00 32.63           N  
ATOM    687  CA  ILE A  86       0.317  24.228 154.157  1.00 32.65           C  
ATOM    688  C   ILE A  86       1.604  25.005 153.851  1.00 32.07           C  
ATOM    689  O   ILE A  86       2.009  25.902 154.580  1.00 30.23           O  
ATOM    690  CB  ILE A  86      -0.911  25.089 153.710  1.00 33.59           C  
ATOM    691  CG1 ILE A  86      -2.250  24.472 154.109  1.00 34.12           C  
ATOM    692  CG2 ILE A  86      -0.902  25.346 152.203  1.00 33.88           C  
ATOM    693  CD1 ILE A  86      -2.690  24.856 155.499  1.00 34.73           C  
ATOM    694  N   ASP A  87       2.262  24.614 152.773  1.00 31.54           N  
ATOM    695  CA  ASP A  87       3.500  25.277 152.367  1.00 31.27           C  
ATOM    696  C   ASP A  87       3.691  25.212 150.841  1.00 32.23           C  
ATOM    697  O   ASP A  87       3.421  24.185 150.198  1.00 31.70           O  
ATOM    698  CB  ASP A  87       4.697  24.688 153.136  1.00 30.72           C  
ATOM    699  CG  ASP A  87       5.964  25.537 153.001  1.00 30.52           C  
ATOM    700  OD1 ASP A  87       6.213  26.312 153.957  1.00 31.50           O  
ATOM    701  OD2 ASP A  87       6.651  25.513 151.944  1.00 28.84           O  
ATOM    702  N   PRO A  88       4.159  26.317 150.249  1.00 32.69           N  
ATOM    703  CA  PRO A  88       4.293  26.249 148.800  1.00 32.41           C  
ATOM    704  C   PRO A  88       5.442  25.379 148.333  1.00 32.83           C  
ATOM    705  O   PRO A  88       5.436  24.896 147.198  1.00 32.81           O  
ATOM    706  CB  PRO A  88       4.527  27.719 148.404  1.00 32.56           C  
ATOM    707  CG  PRO A  88       4.979  28.395 149.606  1.00 32.62           C  
ATOM    708  CD  PRO A  88       4.364  27.677 150.767  1.00 32.34           C  
ATOM    709  N   ASP A  89       6.393  25.119 149.215  1.00 32.57           N  
ATOM    710  CA  ASP A  89       7.557  24.316 148.807  1.00 33.18           C  
ATOM    711  C   ASP A  89       7.375  22.823 149.103  1.00 32.62           C  
ATOM    712  O   ASP A  89       7.080  22.413 150.228  1.00 31.61           O  
ATOM    713  CB  ASP A  89       8.832  24.864 149.456  1.00 33.89           C  
ATOM    714  CG  ASP A  89      10.094  24.252 148.867  1.00 34.52           C  
ATOM    715  OD1 ASP A  89       9.993  23.495 147.890  1.00 34.34           O  
ATOM    716  OD2 ASP A  89      11.191  24.544 149.378  1.00 35.54           O  
ATOM    717  N   ARG A  90       7.571  22.021 148.058  1.00 32.66           N  
ATOM    718  CA  ARG A  90       7.426  20.550 148.150  1.00 32.59           C  
ATOM    719  C   ARG A  90       8.459  19.903 149.083  1.00 33.22           C  
ATOM    720  O   ARG A  90       8.193  18.867 149.689  1.00 32.71           O  
ATOM    721  CB  ARG A  90       7.490  19.880 146.763  1.00 32.94           C  
ATOM    722  CG  ARG A  90       8.840  19.973 146.055  1.00 32.82           C  
ATOM    723  N   ASP A  91       9.613  20.550 149.230  1.00 34.58           N  
ATOM    724  CA  ASP A  91      10.718  20.028 150.078  1.00 34.93           C  
ATOM    725  C   ASP A  91      10.420  20.199 151.571  1.00 34.24           C  
ATOM    726  O   ASP A  91      10.907  19.445 152.429  1.00 34.08           O  
ATOM    727  CB  ASP A  91      12.049  20.701 149.724  1.00 35.83           C  
ATOM    728  CG  ASP A  91      12.470  20.455 148.283  1.00 37.26           C  
ATOM    729  OD1 ASP A  91      12.033  19.454 147.665  1.00 37.85           O  
ATOM    730  OD2 ASP A  91      13.268  21.263 147.765  1.00 38.32           O  
ATOM    731  N   ASN A  92       9.628  21.225 151.862  1.00 33.36           N  
ATOM    732  CA  ASN A  92       9.210  21.518 153.217  1.00 32.25           C  
ATOM    733  C   ASN A  92       8.192  20.507 153.619  1.00 31.57           C  
ATOM    734  O   ASN A  92       8.255  19.907 154.691  1.00 31.12           O  
ATOM    735  CB  ASN A  92       8.601  22.926 153.365  1.00 31.75           C  
ATOM    736  CG  ASN A  92       9.658  23.992 153.436  1.00 31.67           C  
ATOM    737  OD1 ASN A  92      10.784  23.728 153.881  1.00 30.38           O  
ATOM    738  ND2 ASN A  92       9.310  25.212 153.030  1.00 31.34           N  
ATOM    739  N   VAL A  93       7.242  20.319 152.722  1.00 30.92           N  
ATOM    740  CA  VAL A  93       6.151  19.379 152.986  1.00 30.53           C  
ATOM    741  C   VAL A  93       6.730  17.965 153.138  1.00 29.59           C  
ATOM    742  O   VAL A  93       6.387  17.258 154.078  1.00 28.01           O  
ATOM    743  CB  VAL A  93       5.026  19.471 151.900  1.00 31.00           C  
ATOM    744  CG1 VAL A  93       3.960  18.386 152.108  1.00 30.72           C  
ATOM    745  CG2 VAL A  93       4.411  20.875 151.897  1.00 30.18           C  
ATOM    746  N   GLU A  94       7.657  17.593 152.255  1.00 29.68           N  
ATOM    747  CA  GLU A  94       8.285  16.240 152.295  1.00 29.74           C  
ATOM    748  C   GLU A  94       9.141  16.027 153.535  1.00 29.71           C  
ATOM    749  O   GLU A  94       9.156  14.948 154.127  1.00 27.73           O  
ATOM    750  CB  GLU A  94       9.130  15.970 151.039  1.00 30.20           C  
ATOM    751  CG  GLU A  94       9.905  14.611 151.042  1.00 30.53           C  
ATOM    752  CD  GLU A  94       9.011  13.370 151.064  1.00 30.37           C  
ATOM    753  OE1 GLU A  94       7.773  13.515 151.042  1.00 29.34           O  
ATOM    754  OE2 GLU A  94       9.559  12.241 151.091  1.00 29.62           O  
ATOM    755  N   HIS A  95       9.830  17.083 153.950  1.00 30.37           N  
ATOM    756  CA  HIS A  95      10.685  16.993 155.127  1.00 30.93           C  
ATOM    757  C   HIS A  95       9.818  16.703 156.342  1.00 29.89           C  
ATOM    758  O   HIS A  95      10.141  15.845 157.180  1.00 28.79           O  
ATOM    759  CB  HIS A  95      11.492  18.275 155.359  1.00 33.00           C  
ATOM    760  CG  HIS A  95      12.444  18.160 156.502  1.00 34.17           C  
ATOM    761  ND1 HIS A  95      12.123  18.564 157.777  1.00 35.44           N  
ATOM    762  CD2 HIS A  95      13.681  17.615 156.581  1.00 35.39           C  
ATOM    763  CE1 HIS A  95      13.133  18.308 158.589  1.00 35.42           C  
ATOM    764  NE2 HIS A  95      14.093  17.735 157.890  1.00 35.91           N  
ATOM    765  N   ALA A  96       8.705  17.425 156.424  1.00 29.70           N  
ATOM    766  CA  ALA A  96       7.771  17.263 157.532  1.00 28.43           C  
ATOM    767  C   ALA A  96       7.118  15.888 157.474  1.00 26.75           C  
ATOM    768  O   ALA A  96       6.938  15.232 158.491  1.00 25.82           O  
ATOM    769  CB  ALA A  96       6.695  18.345 157.518  1.00 28.01           C  
ATOM    770  N   ARG A  97       6.748  15.454 156.278  1.00 27.37           N  
ATOM    771  CA  ARG A  97       6.096  14.151 156.130  0.50 26.61           C  
ATOM    773  C   ARG A  97       6.999  13.059 156.692  1.00 27.00           C  
ATOM    774  O   ARG A  97       6.562  12.202 157.463  1.00 28.78           O  
ATOM    775  CB  ARG A  97       5.731  13.864 154.668  0.50 26.56           C  
ATOM    777  CG  ARG A  97       4.948  12.571 154.466  0.50 26.02           C  
ATOM    779  N   ARG A  98       8.256  13.107 156.307  1.00 26.39           N  
ATOM    780  CA  ARG A  98       9.210  12.106 156.774  1.00 26.35           C  
ATOM    781  C   ARG A  98       9.349  12.047 158.290  1.00 26.88           C  
ATOM    782  O   ARG A  98       9.284  10.965 158.883  1.00 26.46           O  
ATOM    783  CB  ARG A  98      10.586  12.271 156.090  1.00 25.96           C  
ATOM    784  CG  ARG A  98      10.526  12.083 154.583  1.00 24.25           C  
ATOM    785  CD  ARG A  98      11.864  12.193 153.911  1.00 24.15           C  
ATOM    786  NE  ARG A  98      11.677  12.109 152.471  1.00 23.38           N  
ATOM    787  CZ  ARG A  98      12.645  11.973 151.571  1.00 23.34           C  
ATOM    788  NH1 ARG A  98      13.925  11.846 151.912  1.00 22.69           N  
ATOM    789  NH2 ARG A  98      12.313  11.932 150.307  1.00 23.38           N  
HETATM  790  N   MSE A  99       9.545  13.206 158.915  1.00 29.67           N  
HETATM  791  CA  MSE A  99       9.710  13.279 160.373  1.00 30.46           C  
HETATM  792  C   MSE A  99       8.499  12.756 161.082  1.00 31.83           C  
HETATM  793  O   MSE A  99       8.577  12.062 162.088  1.00 32.46           O  
HETATM  794  CB  MSE A  99       9.864  14.718 160.872  1.00 31.60           C  
HETATM  795  CG  MSE A  99      11.109  15.459 160.505  1.00 31.87           C  
HETATM  796 SE   MSE A  99      11.100  17.055 161.632  0.75 33.69          SE  
HETATM  797  CE  MSE A  99       9.463  17.809 160.947  1.00 30.95           C  
ATOM    798  N   LEU A 100       7.358  13.132 160.548  1.00 31.96           N  
ATOM    799  CA  LEU A 100       6.095  12.742 161.161  1.00 32.24           C  
ATOM    800  C   LEU A 100       5.808  11.278 160.944  1.00 31.96           C  
ATOM    801  O   LEU A 100       5.248  10.611 161.812  1.00 32.53           O  
ATOM    802  CB  LEU A 100       4.952  13.627 160.650  1.00 32.77           C  
ATOM    803  CG  LEU A 100       5.028  15.091 161.090  1.00 33.37           C  
ATOM    804  CD1 LEU A 100       4.125  15.969 160.219  1.00 32.94           C  
ATOM    805  CD2 LEU A 100       4.703  15.236 162.603  1.00 33.26           C  
ATOM    806  N   HIS A 101       6.205  10.777 159.786  1.00 31.52           N  
ATOM    807  CA  HIS A 101       5.991   9.379 159.492  1.00 31.28           C  
ATOM    808  C   HIS A 101       6.903   8.620 160.429  1.00 31.32           C  
ATOM    809  O   HIS A 101       6.520   7.607 161.016  1.00 31.73           O  
ATOM    810  CB  HIS A 101       6.332   9.027 158.038  1.00 31.10           C  
ATOM    811  CG  HIS A 101       6.139   7.578 157.702  1.00 30.99           C  
ATOM    812  ND1 HIS A 101       7.130   6.634 157.863  1.00 31.45           N  
ATOM    813  CD2 HIS A 101       5.063   6.913 157.217  1.00 30.89           C  
ATOM    814  CE1 HIS A 101       6.677   5.450 157.484  1.00 31.34           C  
ATOM    815  NE2 HIS A 101       5.422   5.593 157.090  1.00 31.13           N  
ATOM    816  N   ASP A 102       8.107   9.150 160.580  1.00 30.62           N  
ATOM    817  CA  ASP A 102       9.115   8.485 161.403  1.00 31.60           C  
ATOM    818  C   ASP A 102       8.698   8.357 162.854  1.00 31.92           C  
ATOM    819  O   ASP A 102       9.015   7.346 163.478  1.00 31.61           O  
ATOM    820  CB  ASP A 102      10.496   9.153 161.312  1.00 32.05           C  
ATOM    821  CG  ASP A 102      11.228   8.811 160.036  1.00 33.32           C  
ATOM    822  OD1 ASP A 102      10.848   7.834 159.362  1.00 32.30           O  
ATOM    823  OD2 ASP A 102      12.225   9.488 159.724  1.00 35.38           O  
ATOM    824  N   ASN A 103       7.962   9.350 163.369  1.00 31.77           N  
ATOM    825  CA  ASN A 103       7.512   9.344 164.788  0.50 31.92           C  
ATOM    827  C   ASN A 103       6.052   8.931 164.944  1.00 32.51           C  
ATOM    828  O   ASN A 103       5.515   8.877 166.051  1.00 33.60           O  
ATOM    829  CB  ASN A 103       7.783  10.682 165.505  0.50 31.41           C  
ATOM    831  CG  ASN A 103       6.950  11.831 164.973  0.50 30.72           C  
ATOM    833  OD1 ASN A 103       5.984  11.627 164.244  0.50 30.14           O  
ATOM    835  ND2 ASN A 103       7.313  13.050 165.357  0.50 30.78           N  
ATOM    837  N   GLY A 104       5.434   8.635 163.820  1.00 33.02           N  
ATOM    838  CA  GLY A 104       4.041   8.183 163.753  1.00 33.43           C  
ATOM    839  C   GLY A 104       2.923   9.188 163.823  1.00 34.55           C  
ATOM    840  O   GLY A 104       1.757   8.855 163.536  1.00 35.41           O  
ATOM    841  N   LEU A 105       3.298  10.408 164.179  1.00 32.67           N  
ATOM    842  CA  LEU A 105       2.333  11.528 164.340  1.00 32.84           C  
ATOM    843  C   LEU A 105       1.714  11.982 163.021  1.00 31.84           C  
ATOM    844  O   LEU A 105       0.889  12.884 163.001  1.00 30.47           O  
ATOM    845  CB  LEU A 105       2.971  12.720 165.080  1.00 32.95           C  
ATOM    846  CG  LEU A 105       3.491  12.397 166.491  1.00 33.13           C  
ATOM    847  CD1 LEU A 105       4.230  13.559 167.096  1.00 32.24           C  
ATOM    848  CD2 LEU A 105       2.347  11.932 167.399  1.00 34.00           C  
ATOM    849  N   ILE A 106       2.100  11.317 161.929  1.00 31.44           N  
ATOM    850  CA  ILE A 106       1.555  11.644 160.601  1.00 30.69           C  
ATOM    851  C   ILE A 106       0.059  11.295 160.639  1.00 31.47           C  
ATOM    852  O   ILE A 106      -0.739  11.725 159.794  1.00 32.01           O  
ATOM    853  CB  ILE A 106       2.316  10.910 159.447  1.00 30.54           C  
ATOM    854  CG1 ILE A 106       1.940  11.486 158.080  1.00 30.88           C  
ATOM    855  CG2 ILE A 106       2.076   9.398 159.503  1.00 29.74           C  
ATOM    856  CD1 ILE A 106       2.233  12.968 157.914  1.00 30.15           C  
ATOM    857  N   ASP A 107      -0.303  10.535 161.672  1.00 31.42           N  
ATOM    858  CA  ASP A 107      -1.698  10.091 161.918  1.00 31.85           C  
ATOM    859  C   ASP A 107      -2.621  11.233 162.363  1.00 32.77           C  
ATOM    860  O   ASP A 107      -3.848  11.096 162.400  1.00 33.94           O  
ATOM    861  CB  ASP A 107      -1.761   8.947 162.963  1.00 32.55           C  
ATOM    862  CG  ASP A 107      -1.237   9.351 164.363  1.00 32.69           C  
ATOM    863  OD1 ASP A 107      -0.828  10.503 164.575  1.00 32.95           O  
ATOM    864  OD2 ASP A 107      -1.243   8.506 165.276  1.00 33.21           O  
ATOM    865  N   ARG A 108      -2.032  12.368 162.677  1.00 31.33           N  
ATOM    866  CA  ARG A 108      -2.846  13.513 163.139  1.00 32.11           C  
ATOM    867  C   ARG A 108      -2.374  14.835 162.567  1.00 31.29           C  
ATOM    868  O   ARG A 108      -2.605  15.915 163.127  1.00 31.73           O  
ATOM    869  CB  ARG A 108      -2.855  13.564 164.648  1.00 32.80           C  
ATOM    870  CG  ARG A 108      -1.553  14.001 165.220  1.00 33.78           C  
ATOM    871  CD  ARG A 108      -1.492  13.593 166.654  1.00 34.48           C  
ATOM    872  NE  ARG A 108      -1.421  12.141 166.714  1.00 36.43           N  
ATOM    873  CZ  ARG A 108      -1.418  11.433 167.835  1.00 37.25           C  
ATOM    874  NH1 ARG A 108      -1.498  12.056 169.010  1.00 38.01           N  
ATOM    875  NH2 ARG A 108      -1.339  10.107 167.777  1.00 38.13           N  
ATOM    876  N   VAL A 109      -1.698  14.722 161.435  1.00 31.16           N  
ATOM    877  CA  VAL A 109      -1.197  15.877 160.673  1.00 31.43           C  
ATOM    878  C   VAL A 109      -1.548  15.737 159.196  1.00 31.66           C  
ATOM    879  O   VAL A 109      -1.310  14.687 158.547  1.00 31.91           O  
ATOM    880  CB  VAL A 109       0.330  16.084 160.796  1.00 31.34           C  
ATOM    881  CG1 VAL A 109       0.771  17.319 159.999  1.00 30.98           C  
ATOM    882  CG2 VAL A 109       0.737  16.249 162.243  1.00 31.26           C  
ATOM    883  N   GLU A 110      -2.170  16.794 158.697  1.00 31.63           N  
ATOM    884  CA  GLU A 110      -2.566  16.913 157.292  1.00 32.98           C  
ATOM    885  C   GLU A 110      -1.596  17.886 156.652  1.00 31.98           C  
ATOM    886  O   GLU A 110      -1.514  19.047 157.059  1.00 31.78           O  
ATOM    887  CB  GLU A 110      -4.006  17.425 157.139  1.00 35.04           C  
ATOM    888  CG  GLU A 110      -4.377  17.662 155.662  1.00 37.74           C  
ATOM    889  CD  GLU A 110      -5.700  18.387 155.437  1.00 40.03           C  
ATOM    890  OE1 GLU A 110      -6.567  18.462 156.349  1.00 41.27           O  
ATOM    891  OE2 GLU A 110      -5.866  18.887 154.305  1.00 42.45           O  
ATOM    892  N   LEU A 111      -0.859  17.417 155.660  1.00 30.51           N  
ATOM    893  CA  LEU A 111       0.144  18.245 154.979  1.00 31.85           C  
ATOM    894  C   LEU A 111      -0.223  18.532 153.534  1.00 33.19           C  
ATOM    895  O   LEU A 111      -0.565  17.618 152.772  1.00 32.76           O  
ATOM    896  CB  LEU A 111       1.494  17.523 154.999  1.00 32.17           C  
ATOM    897  CG  LEU A 111       2.022  17.038 156.352  1.00 31.95           C  
ATOM    898  CD1 LEU A 111       3.246  16.141 156.206  1.00 32.54           C  
ATOM    899  CD2 LEU A 111       2.346  18.214 157.192  1.00 32.72           C  
ATOM    900  N   GLN A 112      -0.112  19.796 153.153  1.00 33.51           N  
ATOM    901  CA  GLN A 112      -0.448  20.217 151.784  1.00 35.29           C  
ATOM    902  C   GLN A 112       0.560  21.156 151.161  1.00 34.34           C  
ATOM    903  O   GLN A 112       1.084  22.052 151.804  1.00 32.74           O  
ATOM    904  CB  GLN A 112      -1.787  20.974 151.748  1.00 36.86           C  
ATOM    905  CG  GLN A 112      -2.942  20.347 152.477  1.00 38.28           C  
ATOM    906  CD  GLN A 112      -4.251  20.907 151.992  1.00 39.74           C  
ATOM    907  OE1 GLN A 112      -4.431  21.124 150.784  1.00 41.04           O  
ATOM    908  NE2 GLN A 112      -5.199  21.094 152.905  1.00 40.81           N  
ATOM    909  N   VAL A 113       0.799  20.922 149.877  1.00 33.73           N  
ATOM    910  CA  VAL A 113       1.674  21.741 149.060  1.00 33.61           C  
ATOM    911  C   VAL A 113       0.707  22.681 148.367  1.00 34.14           C  
ATOM    912  O   VAL A 113      -0.213  22.235 147.688  1.00 33.24           O  
ATOM    913  CB  VAL A 113       2.497  20.905 148.029  1.00 34.07           C  
ATOM    914  CG1 VAL A 113       3.163  21.804 146.982  1.00 33.64           C  
ATOM    915  CG2 VAL A 113       3.523  20.018 148.741  1.00 33.92           C  
ATOM    916  N   GLY A 114       0.879  23.978 148.583  1.00 34.31           N  
ATOM    917  CA  GLY A 114      -0.001  24.981 147.970  1.00 35.51           C  
ATOM    918  C   GLY A 114       0.095  26.362 148.585  1.00 36.19           C  
ATOM    919  O   GLY A 114       1.024  26.660 149.329  1.00 37.00           O  
ATOM    920  N   ASP A 115      -0.895  27.197 148.294  1.00 36.66           N  
ATOM    921  CA  ASP A 115      -0.916  28.563 148.818  1.00 37.45           C  
ATOM    922  C   ASP A 115      -1.335  28.536 150.287  1.00 36.86           C  
ATOM    923  O   ASP A 115      -2.462  28.145 150.591  1.00 36.68           O  
ATOM    924  CB  ASP A 115      -1.883  29.461 148.054  1.00 38.48           C  
ATOM    925  CG  ASP A 115      -1.821  30.897 148.537  1.00 39.56           C  
ATOM    926  OD1 ASP A 115      -0.719  31.490 148.508  1.00 40.47           O  
ATOM    927  OD2 ASP A 115      -2.872  31.441 148.922  1.00 40.44           O  
ATOM    928  N   PRO A 116      -0.461  29.000 151.206  1.00 36.43           N  
ATOM    929  CA  PRO A 116      -0.830  28.908 152.623  1.00 36.80           C  
ATOM    930  C   PRO A 116      -2.190  29.507 153.046  1.00 36.70           C  
ATOM    931  O   PRO A 116      -2.994  28.809 153.683  1.00 37.00           O  
ATOM    932  CB  PRO A 116       0.349  29.618 153.324  1.00 36.67           C  
ATOM    933  CG  PRO A 116       1.492  29.407 152.410  1.00 36.33           C  
ATOM    934  CD  PRO A 116       0.910  29.522 151.043  1.00 36.03           C  
ATOM    935  N   LEU A 117      -2.459  30.751 152.657  1.00 37.43           N  
ATOM    936  CA  LEU A 117      -3.710  31.429 153.074  1.00 38.05           C  
ATOM    937  C   LEU A 117      -4.895  31.015 152.264  1.00 37.99           C  
ATOM    938  O   LEU A 117      -6.015  30.939 152.773  1.00 38.43           O  
ATOM    939  CB  LEU A 117      -3.576  32.947 153.051  1.00 39.07           C  
ATOM    940  CG  LEU A 117      -2.655  33.503 154.126  1.00 39.49           C  
ATOM    941  CD1 LEU A 117      -2.668  34.998 154.016  1.00 40.30           C  
ATOM    942  CD2 LEU A 117      -3.104  33.050 155.512  1.00 39.57           C  
ATOM    943  N   GLY A 118      -4.631  30.732 150.997  1.00 37.89           N  
ATOM    944  CA  GLY A 118      -5.676  30.291 150.071  1.00 37.55           C  
ATOM    945  C   GLY A 118      -6.328  29.018 150.588  1.00 37.71           C  
ATOM    946  O   GLY A 118      -7.553  28.891 150.620  1.00 38.29           O  
ATOM    947  N   ILE A 119      -5.491  28.088 151.027  1.00 36.41           N  
ATOM    948  CA  ILE A 119      -5.949  26.802 151.551  1.00 36.38           C  
ATOM    949  C   ILE A 119      -6.452  26.909 152.999  1.00 37.02           C  
ATOM    950  O   ILE A 119      -7.473  26.313 153.363  1.00 37.77           O  
ATOM    951  CB  ILE A 119      -4.836  25.727 151.411  1.00 36.04           C  
ATOM    952  CG1 ILE A 119      -4.613  25.444 149.913  1.00 35.53           C  
ATOM    953  CG2 ILE A 119      -5.208  24.471 152.175  1.00 35.41           C  
ATOM    954  CD1 ILE A 119      -3.526  24.459 149.611  1.00 35.50           C  
ATOM    955  N   ALA A 120      -5.747  27.697 153.803  1.00 36.95           N  
ATOM    956  CA  ALA A 120      -6.098  27.870 155.220  1.00 37.61           C  
ATOM    957  C   ALA A 120      -7.495  28.473 155.351  1.00 38.02           C  
ATOM    958  O   ALA A 120      -8.291  28.123 156.239  1.00 37.22           O  
ATOM    959  CB  ALA A 120      -5.061  28.756 155.931  1.00 36.47           C  
ATOM    960  N   ALA A 121      -7.790  29.357 154.414  1.00 37.60           N  
ATOM    961  CA  ALA A 121      -9.074  30.051 154.400  1.00 37.42           C  
ATOM    962  C   ALA A 121     -10.272  29.102 154.278  1.00 37.45           C  
ATOM    963  O   ALA A 121     -11.402  29.494 154.560  1.00 38.10           O  
ATOM    964  CB  ALA A 121      -9.107  31.094 153.278  1.00 37.95           C  
ATOM    965  N   GLY A 122     -10.028  27.861 153.871  1.00 36.27           N  
ATOM    966  CA  GLY A 122     -11.095  26.868 153.706  1.00 36.02           C  
ATOM    967  C   GLY A 122     -11.354  26.072 154.974  1.00 36.65           C  
ATOM    968  O   GLY A 122     -12.235  25.213 155.042  1.00 36.31           O  
ATOM    969  N   GLN A 123     -10.552  26.366 155.985  1.00 36.92           N  
ATOM    970  CA  GLN A 123     -10.662  25.706 157.297  1.00 37.22           C  
ATOM    971  C   GLN A 123     -11.700  26.401 158.162  1.00 36.84           C  
ATOM    972  O   GLN A 123     -12.011  27.568 157.966  1.00 37.35           O  
ATOM    973  CB  GLN A 123      -9.295  25.659 157.989  1.00 37.56           C  
ATOM    974  CG  GLN A 123      -8.291  24.795 157.247  1.00 38.40           C  
ATOM    975  CD  GLN A 123      -8.570  23.313 157.385  1.00 38.58           C  
ATOM    976  OE1 GLN A 123      -8.809  22.809 158.486  1.00 39.59           O  
ATOM    977  NE2 GLN A 123      -8.461  22.589 156.281  1.00 39.37           N  
ATOM    978  N   ARG A 124     -12.261  25.651 159.095  1.00 37.15           N  
ATOM    979  CA  ARG A 124     -13.273  26.179 160.020  1.00 37.52           C  
ATOM    980  C   ARG A 124     -12.993  25.807 161.468  1.00 36.16           C  
ATOM    981  O   ARG A 124     -12.448  24.749 161.760  1.00 35.06           O  
ATOM    982  CB  ARG A 124     -14.681  25.675 159.646  1.00 39.08           C  
ATOM    983  CG  ARG A 124     -15.192  26.126 158.300  1.00 40.76           C  
ATOM    984  CD  ARG A 124     -15.314  27.639 158.203  1.00 42.27           C  
ATOM    985  NE  ARG A 124     -15.870  28.041 156.909  1.00 43.83           N  
ATOM    986  CZ  ARG A 124     -15.161  28.307 155.812  1.00 44.78           C  
ATOM    987  NH1 ARG A 124     -13.839  28.241 155.820  1.00 45.06           N  
ATOM    988  NH2 ARG A 124     -15.787  28.654 154.696  1.00 44.90           N  
ATOM    989  N   ASP A 125     -13.378  26.700 162.372  1.00 34.01           N  
ATOM    990  CA  ASP A 125     -13.211  26.451 163.810  1.00 33.62           C  
ATOM    991  C   ASP A 125     -11.776  26.128 164.185  1.00 30.92           C  
ATOM    992  O   ASP A 125     -11.478  25.135 164.830  1.00 29.52           O  
ATOM    993  CB  ASP A 125     -14.139  25.327 164.267  1.00 34.94           C  
ATOM    994  CG  ASP A 125     -15.598  25.730 164.225  1.00 37.22           C  
ATOM    995  OD1 ASP A 125     -15.923  26.868 164.631  1.00 39.49           O  
ATOM    996  OD2 ASP A 125     -16.421  24.888 163.829  1.00 39.45           O  
ATOM    997  N   ILE A 126     -10.892  26.969 163.694  1.00 29.84           N  
ATOM    998  CA  ILE A 126      -9.456  26.882 164.004  1.00 30.53           C  
ATOM    999  C   ILE A 126      -9.257  27.320 165.457  1.00 30.24           C  
ATOM   1000  O   ILE A 126      -9.683  28.399 165.852  1.00 30.23           O  
ATOM   1001  CB  ILE A 126      -8.598  27.765 163.060  1.00 30.22           C  
ATOM   1002  CG1 ILE A 126      -8.775  27.336 161.584  1.00 30.48           C  
ATOM   1003  CG2 ILE A 126      -7.104  27.719 163.468  1.00 30.81           C  
ATOM   1004  CD1 ILE A 126      -8.134  28.307 160.569  1.00 30.81           C  
ATOM   1005  N   ASP A 127      -8.596  26.458 166.235  1.00 30.67           N  
ATOM   1006  CA  ASP A 127      -8.309  26.691 167.677  1.00 29.68           C  
ATOM   1007  C   ASP A 127      -7.006  27.418 167.866  1.00 28.86           C  
ATOM   1008  O   ASP A 127      -6.871  28.223 168.781  1.00 27.58           O  
ATOM   1009  CB  ASP A 127      -8.338  25.376 168.460  1.00 29.76           C  
ATOM   1010  CG  ASP A 127      -9.717  24.749 168.453  1.00 30.18           C  
ATOM   1011  OD1 ASP A 127     -10.686  25.480 168.762  1.00 29.68           O  
ATOM   1012  OD2 ASP A 127      -9.838  23.550 168.127  1.00 29.20           O  
ATOM   1013  N   ILE A 128      -6.031  27.082 167.028  1.00 27.92           N  
ATOM   1014  CA  ILE A 128      -4.730  27.745 167.053  1.00 28.09           C  
ATOM   1015  C   ILE A 128      -4.314  28.053 165.640  1.00 27.87           C  
ATOM   1016  O   ILE A 128      -4.280  27.188 164.787  1.00 30.34           O  
ATOM   1017  CB  ILE A 128      -3.577  26.941 167.711  1.00 28.06           C  
ATOM   1018  CG1 ILE A 128      -3.849  26.674 169.177  1.00 29.24           C  
ATOM   1019  CG2 ILE A 128      -2.265  27.707 167.569  1.00 29.86           C  
ATOM   1020  CD1 ILE A 128      -2.734  25.974 169.879  1.00 29.36           C  
ATOM   1021  N   LEU A 129      -4.052  29.318 165.402  1.00 28.99           N  
ATOM   1022  CA  LEU A 129      -3.584  29.787 164.106  1.00 28.72           C  
ATOM   1023  C   LEU A 129      -2.162  30.310 164.298  1.00 29.36           C  
ATOM   1024  O   LEU A 129      -1.905  31.300 165.029  1.00 28.12           O  
ATOM   1025  CB  LEU A 129      -4.504  30.854 163.511  1.00 29.06           C  
ATOM   1026  CG  LEU A 129      -3.994  31.403 162.165  1.00 28.26           C  
ATOM   1027  CD1 LEU A 129      -3.950  30.284 161.116  1.00 28.29           C  
ATOM   1028  CD2 LEU A 129      -4.812  32.592 161.647  1.00 28.75           C  
ATOM   1029  N   PHE A 130      -1.234  29.600 163.665  1.00 29.21           N  
ATOM   1030  CA  PHE A 130       0.183  29.941 163.733  1.00 30.42           C  
ATOM   1031  C   PHE A 130       0.518  30.886 162.599  1.00 33.26           C  
ATOM   1032  O   PHE A 130       0.040  30.716 161.472  1.00 34.25           O  
ATOM   1033  CB  PHE A 130       1.069  28.700 163.663  1.00 31.18           C  
ATOM   1034  CG  PHE A 130       2.545  29.001 163.722  1.00 32.00           C  
ATOM   1035  CD1 PHE A 130       3.196  29.124 164.949  1.00 32.80           C  
ATOM   1036  CD2 PHE A 130       3.282  29.159 162.566  1.00 32.64           C  
ATOM   1037  CE1 PHE A 130       4.568  29.378 165.005  1.00 32.76           C  
ATOM   1038  CE2 PHE A 130       4.664  29.430 162.622  1.00 31.84           C  
ATOM   1039  CZ  PHE A 130       5.286  29.536 163.840  1.00 32.31           C  
HETATM 1040  N   MSE A 131       1.338  31.876 162.915  1.00 32.95           N  
HETATM 1041  CA  MSE A 131       1.697  32.859 161.939  1.00 36.33           C  
HETATM 1042  C   MSE A 131       3.140  33.367 162.051  1.00 35.72           C  
HETATM 1043  O   MSE A 131       3.673  33.493 163.143  1.00 34.94           O  
HETATM 1044  CB  MSE A 131       0.772  34.019 162.237  1.00 37.87           C  
HETATM 1045  CG  MSE A 131       0.316  34.644 161.067  1.00 39.37           C  
HETATM 1046 SE   MSE A 131      -0.419  36.319 161.588  0.75 40.08          SE  
HETATM 1047  CE  MSE A 131      -1.861  35.701 162.786  1.00 30.27           C  
ATOM   1048  N   ASP A 132       3.758  33.625 160.899  1.00 36.61           N  
ATOM   1049  CA  ASP A 132       5.127  34.195 160.817  1.00 36.62           C  
ATOM   1050  C   ASP A 132       5.050  35.650 160.301  1.00 36.30           C  
ATOM   1051  O   ASP A 132       4.715  35.923 159.151  1.00 35.55           O  
ATOM   1052  CB  ASP A 132       6.046  33.339 159.946  1.00 38.54           C  
ATOM   1053  CG  ASP A 132       7.503  33.822 159.958  1.00 39.64           C  
ATOM   1054  OD1 ASP A 132       7.790  34.959 160.419  1.00 39.81           O  
ATOM   1055  OD2 ASP A 132       8.369  33.056 159.480  1.00 41.56           O  
ATOM   1056  N   CYS A 133       5.362  36.572 161.194  1.00 37.27           N  
ATOM   1057  CA  CYS A 133       5.306  37.995 160.881  1.00 38.94           C  
ATOM   1058  C   CYS A 133       6.271  38.441 159.806  1.00 39.00           C  
ATOM   1059  O   CYS A 133       6.115  39.543 159.282  1.00 39.04           O  
ATOM   1060  CB  CYS A 133       5.532  38.857 162.130  1.00 39.02           C  
ATOM   1061  SG  CYS A 133       4.226  38.707 163.365  1.00 40.27           S  
ATOM   1062  N   ASP A 134       7.254  37.612 159.475  1.00 39.74           N  
ATOM   1063  CA  ASP A 134       8.239  37.930 158.422  0.50 39.84           C  
ATOM   1065  C   ASP A 134       7.693  37.687 157.043  1.00 40.49           C  
ATOM   1066  O   ASP A 134       8.142  38.267 156.062  1.00 41.11           O  
ATOM   1067  CB  ASP A 134       9.490  37.055 158.519  0.50 39.40           C  
ATOM   1069  CG  ASP A 134      10.391  37.450 159.636  0.50 38.82           C  
ATOM   1071  OD1 ASP A 134      10.221  38.560 160.167  0.50 38.84           O  
ATOM   1073  OD2 ASP A 134      11.310  36.672 159.936  0.50 38.28           O  
ATOM   1075  N   VAL A 135       6.706  36.809 156.991  1.00 40.67           N  
ATOM   1076  CA  VAL A 135       6.085  36.384 155.742  1.00 41.07           C  
ATOM   1077  C   VAL A 135       4.742  37.001 155.439  1.00 41.44           C  
ATOM   1078  O   VAL A 135       4.383  37.186 154.273  1.00 41.24           O  
ATOM   1079  CB  VAL A 135       5.860  34.852 155.747  1.00 41.56           C  
ATOM   1080  CG1 VAL A 135       5.185  34.406 154.456  1.00 41.58           C  
ATOM   1081  CG2 VAL A 135       7.166  34.126 155.938  1.00 41.88           C  
ATOM   1082  N   PHE A 136       3.996  37.323 156.475  1.00 40.92           N  
ATOM   1083  CA  PHE A 136       2.674  37.877 156.279  1.00 42.11           C  
ATOM   1084  C   PHE A 136       2.376  39.122 157.055  1.00 42.10           C  
ATOM   1085  O   PHE A 136       2.848  39.312 158.170  1.00 41.85           O  
ATOM   1086  CB  PHE A 136       1.622  36.866 156.738  1.00 43.49           C  
ATOM   1087  CG  PHE A 136       1.764  35.527 156.113  1.00 44.49           C  
ATOM   1088  CD1 PHE A 136       1.255  35.279 154.852  1.00 45.24           C  
ATOM   1089  CD2 PHE A 136       2.397  34.503 156.797  1.00 45.34           C  
ATOM   1090  CE1 PHE A 136       1.388  34.032 154.269  1.00 45.69           C  
ATOM   1091  CE2 PHE A 136       2.527  33.254 156.227  1.00 45.63           C  
ATOM   1092  CZ  PHE A 136       2.022  33.017 154.960  1.00 45.66           C  
ATOM   1093  N   ASN A 137       1.540  39.936 156.429  1.00 42.26           N  
ATOM   1094  CA  ASN A 137       1.013  41.163 157.016  1.00 42.69           C  
ATOM   1095  C   ASN A 137      -0.126  40.651 157.903  1.00 41.67           C  
ATOM   1096  O   ASN A 137      -1.167  40.195 157.425  1.00 41.04           O  
ATOM   1097  CB  ASN A 137       0.552  42.146 155.921  1.00 43.84           C  
ATOM   1098  CG  ASN A 137      -0.109  43.407 156.471  1.00 45.14           C  
ATOM   1099  OD1 ASN A 137      -0.623  43.417 157.580  1.00 47.42           O  
ATOM   1100  ND2 ASN A 137      -0.147  44.465 155.656  1.00 46.47           N  
ATOM   1101  N   GLY A 138       0.113  40.670 159.209  1.00 40.66           N  
ATOM   1102  CA  GLY A 138      -0.845  40.152 160.169  1.00 39.54           C  
ATOM   1103  C   GLY A 138      -2.275  40.603 160.031  1.00 39.71           C  
ATOM   1104  O   GLY A 138      -3.208  39.790 160.120  1.00 37.93           O  
ATOM   1105  N   ALA A 139      -2.440  41.905 159.817  1.00 39.41           N  
ATOM   1106  CA  ALA A 139      -3.779  42.520 159.709  1.00 40.44           C  
ATOM   1107  C   ALA A 139      -4.526  41.941 158.531  1.00 40.90           C  
ATOM   1108  O   ALA A 139      -5.722  41.696 158.586  1.00 41.39           O  
ATOM   1109  CB  ALA A 139      -3.690  44.043 159.578  1.00 39.49           C  
ATOM   1110  N   ASP A 140      -3.758  41.693 157.485  1.00 41.97           N  
ATOM   1111  CA  ASP A 140      -4.273  41.130 156.234  1.00 42.38           C  
ATOM   1112  C   ASP A 140      -4.697  39.683 156.462  1.00 41.31           C  
ATOM   1113  O   ASP A 140      -5.766  39.268 156.052  1.00 40.47           O  
ATOM   1114  CB  ASP A 140      -3.229  41.238 155.110  1.00 43.59           C  
ATOM   1115  CG  ASP A 140      -2.947  42.689 154.691  1.00 45.30           C  
ATOM   1116  OD1 ASP A 140      -3.696  43.609 155.110  1.00 46.54           O  
ATOM   1117  OD2 ASP A 140      -1.997  42.919 153.896  1.00 46.93           O  
ATOM   1118  N   VAL A 141      -3.863  38.934 157.166  1.00 40.84           N  
ATOM   1119  CA  VAL A 141      -4.151  37.527 157.471  1.00 40.16           C  
ATOM   1120  C   VAL A 141      -5.417  37.376 158.305  1.00 40.20           C  
ATOM   1121  O   VAL A 141      -6.252  36.506 158.075  1.00 38.01           O  
ATOM   1122  CB  VAL A 141      -2.979  36.849 158.265  1.00 40.13           C  
ATOM   1123  CG1 VAL A 141      -3.410  35.511 158.859  1.00 40.52           C  
ATOM   1124  CG2 VAL A 141      -1.724  36.707 157.393  1.00 40.23           C  
ATOM   1125  N   LEU A 142      -5.552  38.268 159.270  1.00 40.44           N  
ATOM   1126  CA  LEU A 142      -6.665  38.223 160.205  1.00 41.17           C  
ATOM   1127  C   LEU A 142      -7.969  38.680 159.532  1.00 41.61           C  
ATOM   1128  O   LEU A 142      -9.053  38.179 159.832  1.00 41.83           O  
ATOM   1129  CB  LEU A 142      -6.308  39.062 161.444  1.00 41.62           C  
ATOM   1130  CG  LEU A 142      -7.124  38.845 162.711  1.00 41.69           C  
ATOM   1131  CD1 LEU A 142      -7.112  37.378 163.022  1.00 41.17           C  
ATOM   1132  CD2 LEU A 142      -6.581  39.680 163.901  1.00 40.96           C  
ATOM   1133  N   GLU A 143      -7.861  39.599 158.582  1.00 41.94           N  
ATOM   1134  CA  GLU A 143      -9.060  40.097 157.891  1.00 42.17           C  
ATOM   1135  C   GLU A 143      -9.643  38.956 157.093  1.00 42.04           C  
ATOM   1136  O   GLU A 143     -10.857  38.848 156.940  1.00 43.31           O  
ATOM   1137  CB  GLU A 143      -8.764  41.293 156.975  1.00 42.67           C  
ATOM   1138  CG  GLU A 143     -10.018  41.927 156.315  1.00 43.66           C  
ATOM   1139  N   ARG A 144      -8.766  38.078 156.630  1.00 41.39           N  
ATOM   1140  CA  ARG A 144      -9.161  36.913 155.822  1.00 41.58           C  
ATOM   1141  C   ARG A 144      -9.549  35.690 156.637  1.00 41.83           C  
ATOM   1142  O   ARG A 144     -10.493  34.974 156.297  1.00 42.00           O  
ATOM   1143  CB  ARG A 144      -8.010  36.483 154.901  1.00 41.55           C  
HETATM 1144  N   MSE A 145      -8.813  35.490 157.728  1.00 41.68           N  
HETATM 1145  CA  MSE A 145      -8.947  34.306 158.612  1.00 41.58           C  
HETATM 1146  C   MSE A 145      -9.830  34.404 159.864  1.00 41.59           C  
HETATM 1147  O   MSE A 145     -10.223  33.372 160.420  1.00 40.81           O  
HETATM 1148  CB  MSE A 145      -7.538  33.893 159.107  1.00 41.29           C  
HETATM 1149  CG  MSE A 145      -6.519  33.518 158.011  1.00 41.13           C  
HETATM 1150 SE   MSE A 145      -7.046  31.991 156.934  0.75 41.42          SE  
HETATM 1151  CE  MSE A 145      -7.244  30.681 158.362  1.00 39.49           C  
ATOM   1152  N   ASN A 146     -10.135  35.610 160.321  1.00 41.42           N  
ATOM   1153  CA  ASN A 146     -10.917  35.724 161.556  1.00 41.51           C  
ATOM   1154  C   ASN A 146     -12.206  34.894 161.503  1.00 41.14           C  
ATOM   1155  O   ASN A 146     -12.656  34.356 162.524  1.00 40.83           O  
ATOM   1156  CB  ASN A 146     -11.254  37.169 161.908  1.00 41.57           C  
ATOM   1157  CG  ASN A 146     -11.651  37.311 163.345  1.00 41.00           C  
ATOM   1158  OD1 ASN A 146     -11.018  36.737 164.224  1.00 41.11           O  
ATOM   1159  ND2 ASN A 146     -12.665  38.098 163.606  1.00 40.80           N  
ATOM   1160  N   ARG A 147     -12.760  34.783 160.296  1.00 41.18           N  
ATOM   1161  CA  ARG A 147     -14.018  34.046 160.038  1.00 41.53           C  
ATOM   1162  C   ARG A 147     -13.866  32.537 160.197  1.00 39.66           C  
ATOM   1163  O   ARG A 147     -14.849  31.801 160.349  1.00 37.75           O  
ATOM   1164  CB  ARG A 147     -14.500  34.260 158.600  1.00 43.82           C  
ATOM   1165  CG  ARG A 147     -14.816  35.684 158.212  1.00 46.36           C  
ATOM   1166  CD  ARG A 147     -15.399  35.723 156.815  1.00 48.37           C  
ATOM   1167  NE  ARG A 147     -14.454  35.258 155.803  1.00 50.50           N  
ATOM   1168  CZ  ARG A 147     -13.572  36.036 155.171  1.00 52.20           C  
ATOM   1169  NH1 ARG A 147     -13.498  37.336 155.443  1.00 52.47           N  
ATOM   1170  NH2 ARG A 147     -12.752  35.505 154.265  1.00 53.28           N  
ATOM   1171  N   CYS A 148     -12.613  32.115 160.146  1.00 37.70           N  
ATOM   1172  CA  CYS A 148     -12.217  30.700 160.206  1.00 36.70           C  
ATOM   1173  C   CYS A 148     -11.876  30.268 161.606  1.00 34.72           C  
ATOM   1174  O   CYS A 148     -11.698  29.081 161.890  1.00 32.91           O  
ATOM   1175  CB  CYS A 148     -11.010  30.467 159.294  1.00 37.36           C  
ATOM   1176  SG  CYS A 148     -11.322  30.903 157.546  1.00 39.01           S  
ATOM   1177  N   LEU A 149     -11.843  31.247 162.490  1.00 33.15           N  
ATOM   1178  CA  LEU A 149     -11.470  30.989 163.889  1.00 32.97           C  
ATOM   1179  C   LEU A 149     -12.613  30.492 164.764  1.00 32.21           C  
ATOM   1180  O   LEU A 149     -13.759  30.891 164.619  1.00 31.67           O  
ATOM   1181  CB  LEU A 149     -10.842  32.234 164.547  1.00 32.81           C  
ATOM   1182  CG  LEU A 149      -9.548  32.807 163.966  1.00 33.42           C  
ATOM   1183  CD1 LEU A 149      -9.125  34.002 164.802  1.00 33.55           C  
ATOM   1184  CD2 LEU A 149      -8.455  31.745 163.923  1.00 32.88           C  
ATOM   1185  N   ALA A 150     -12.271  29.584 165.662  1.00 30.45           N  
ATOM   1186  CA  ALA A 150     -13.235  29.077 166.625  1.00 29.64           C  
ATOM   1187  C   ALA A 150     -13.341  30.060 167.766  1.00 29.41           C  
ATOM   1188  O   ALA A 150     -12.494  30.930 167.949  1.00 28.80           O  
ATOM   1189  CB  ALA A 150     -12.794  27.748 167.189  1.00 29.32           C  
ATOM   1190  N   LYS A 151     -14.419  29.915 168.518  1.00 29.62           N  
ATOM   1191  CA  LYS A 151     -14.596  30.706 169.720  1.00 30.41           C  
ATOM   1192  C   LYS A 151     -13.349  30.520 170.587  1.00 29.82           C  
ATOM   1193  O   LYS A 151     -12.901  29.388 170.801  1.00 29.63           O  
ATOM   1194  CB  LYS A 151     -15.797  30.218 170.533  1.00 30.77           C  
ATOM   1195  CG  LYS A 151     -15.919  30.886 171.900  1.00 32.27           C  
ATOM   1196  CD  LYS A 151     -17.123  30.401 172.708  1.00 33.89           C  
ATOM   1197  CE  LYS A 151     -17.074  30.982 174.110  1.00 35.03           C  
ATOM   1198  NZ  LYS A 151     -18.281  30.600 174.922  1.00 36.52           N  
ATOM   1199  N   ASN A 152     -12.814  31.631 171.083  1.00 29.45           N  
ATOM   1200  CA  ASN A 152     -11.656  31.628 171.993  1.00 29.30           C  
ATOM   1201  C   ASN A 152     -10.375  31.036 171.396  1.00 29.50           C  
ATOM   1202  O   ASN A 152      -9.514  30.480 172.116  1.00 29.37           O  
ATOM   1203  CB  ASN A 152     -11.978  30.936 173.343  1.00 29.21           C  
ATOM   1204  CG  ASN A 152     -13.066  31.639 174.168  1.00 29.88           C  
ATOM   1205  OD1 ASN A 152     -13.754  30.974 174.954  1.00 28.28           O  
ATOM   1206  ND2 ASN A 152     -13.238  32.948 173.990  1.00 29.22           N  
ATOM   1207  N   ALA A 153     -10.268  31.140 170.078  1.00 29.52           N  
ATOM   1208  CA  ALA A 153      -9.037  30.718 169.384  1.00 29.60           C  
ATOM   1209  C   ALA A 153      -7.863  31.553 169.864  1.00 29.23           C  
ATOM   1210  O   ALA A 153      -8.008  32.658 170.364  1.00 30.69           O  
ATOM   1211  CB  ALA A 153      -9.152  30.871 167.880  1.00 27.93           C  
ATOM   1212  N   LEU A 154      -6.687  30.993 169.659  1.00 29.07           N  
ATOM   1213  CA  LEU A 154      -5.442  31.631 169.998  1.00 28.60           C  
ATOM   1214  C   LEU A 154      -4.567  31.797 168.777  1.00 29.23           C  
ATOM   1215  O   LEU A 154      -4.305  30.844 168.040  1.00 29.24           O  
ATOM   1216  CB  LEU A 154      -4.658  30.759 170.992  1.00 29.10           C  
ATOM   1217  CG  LEU A 154      -3.280  31.246 171.451  1.00 30.70           C  
ATOM   1218  CD1 LEU A 154      -3.327  32.503 172.321  1.00 30.75           C  
ATOM   1219  CD2 LEU A 154      -2.547  30.079 172.181  1.00 31.56           C  
ATOM   1220  N   LEU A 155      -4.134  33.037 168.609  1.00 29.32           N  
ATOM   1221  CA  LEU A 155      -3.244  33.421 167.531  0.50 29.45           C  
ATOM   1223  C   LEU A 155      -1.847  33.428 168.117  1.00 28.26           C  
ATOM   1224  O   LEU A 155      -1.619  33.968 169.203  1.00 29.26           O  
ATOM   1225  CB  LEU A 155      -3.586  34.822 167.004  0.50 29.93           C  
ATOM   1227  CG  LEU A 155      -2.803  35.332 165.804  0.50 30.17           C  
ATOM   1229  CD1 LEU A 155      -3.206  34.548 164.560  0.50 31.23           C  
ATOM   1231  CD2 LEU A 155      -3.080  36.806 165.627  0.50 30.73           C  
ATOM   1233  N   ILE A 156      -0.927  32.804 167.399  1.00 28.30           N  
ATOM   1234  CA  ILE A 156       0.510  32.732 167.784  1.00 28.90           C  
ATOM   1235  C   ILE A 156       1.299  33.223 166.562  1.00 29.32           C  
ATOM   1236  O   ILE A 156       1.343  32.562 165.510  1.00 31.44           O  
ATOM   1237  CB  ILE A 156       0.997  31.339 168.220  1.00 29.30           C  
ATOM   1238  CG1 ILE A 156       0.119  30.775 169.350  1.00 28.96           C  
ATOM   1239  CG2 ILE A 156       2.482  31.427 168.644  1.00 28.78           C  
ATOM   1240  CD1 ILE A 156       0.474  29.359 169.782  1.00 29.52           C  
ATOM   1241  N   ALA A 157       1.890  34.396 166.711  1.00 28.29           N  
ATOM   1242  CA  ALA A 157       2.660  35.067 165.643  1.00 28.24           C  
ATOM   1243  C   ALA A 157       4.104  35.214 166.054  1.00 29.43           C  
ATOM   1244  O   ALA A 157       4.431  35.901 167.032  1.00 30.16           O  
ATOM   1245  CB  ALA A 157       2.041  36.431 165.305  1.00 28.19           C  
ATOM   1246  N   VAL A 158       4.976  34.552 165.306  1.00 28.73           N  
ATOM   1247  CA  VAL A 158       6.397  34.581 165.613  1.00 28.16           C  
ATOM   1248  C   VAL A 158       7.085  35.711 164.866  1.00 29.55           C  
ATOM   1249  O   VAL A 158       6.494  36.366 163.986  1.00 30.51           O  
ATOM   1250  CB  VAL A 158       7.097  33.218 165.360  1.00 28.32           C  
ATOM   1251  CG1 VAL A 158       6.515  32.138 166.324  1.00 27.80           C  
ATOM   1252  CG2 VAL A 158       7.039  32.785 163.871  1.00 28.08           C  
ATOM   1253  N   ASN A 159       8.339  35.910 165.231  1.00 29.91           N  
ATOM   1254  CA  ASN A 159       9.192  36.979 164.642  1.00 30.80           C  
ATOM   1255  C   ASN A 159       8.504  38.330 164.770  1.00 29.25           C  
ATOM   1256  O   ASN A 159       8.553  39.183 163.883  1.00 30.40           O  
ATOM   1257  CB  ASN A 159       9.545  36.671 163.189  1.00 32.07           C  
ATOM   1258  CG  ASN A 159      10.264  35.360 163.051  1.00 33.74           C  
ATOM   1259  OD1 ASN A 159      11.041  34.986 163.920  1.00 34.50           O  
ATOM   1260  ND2 ASN A 159       9.994  34.640 161.969  1.00 35.45           N  
ATOM   1261  N   ALA A 160       7.860  38.498 165.914  1.00 29.04           N  
ATOM   1262  CA  ALA A 160       7.109  39.717 166.269  1.00 29.60           C  
ATOM   1263  C   ALA A 160       7.941  40.958 166.680  1.00 29.88           C  
ATOM   1264  O   ALA A 160       7.456  42.079 166.548  1.00 30.47           O  
ATOM   1265  CB  ALA A 160       6.089  39.417 167.340  1.00 28.72           C  
ATOM   1266  N   LEU A 161       9.167  40.750 167.172  1.00 29.25           N  
ATOM   1267  CA  LEU A 161      10.051  41.846 167.619  1.00 30.31           C  
ATOM   1268  C   LEU A 161      11.242  42.033 166.710  1.00 31.61           C  
ATOM   1269  O   LEU A 161      11.788  43.124 166.602  1.00 31.43           O  
ATOM   1270  CB  LEU A 161      10.501  41.663 169.081  1.00 29.78           C  
ATOM   1271  CG  LEU A 161       9.353  41.792 170.083  1.00 30.18           C  
ATOM   1272  CD1 LEU A 161       9.834  41.473 171.475  1.00 31.19           C  
ATOM   1273  CD2 LEU A 161       8.684  43.205 169.993  1.00 30.63           C  
ATOM   1274  N   ARG A 162      11.655  40.967 166.068  1.00 32.09           N  
ATOM   1275  CA  ARG A 162      12.765  41.040 165.122  1.00 34.95           C  
ATOM   1276  C   ARG A 162      12.627  39.934 164.101  1.00 35.84           C  
ATOM   1277  O   ARG A 162      11.973  38.914 164.337  1.00 34.21           O  
ATOM   1278  CB  ARG A 162      14.109  40.951 165.818  1.00 36.47           C  
ATOM   1279  CG  ARG A 162      14.377  39.601 166.372  1.00 37.67           C  
ATOM   1280  CD  ARG A 162      15.655  39.589 167.127  1.00 39.18           C  
ATOM   1281  NE  ARG A 162      15.907  38.261 167.683  1.00 40.61           N  
ATOM   1282  CZ  ARG A 162      16.898  37.985 168.515  1.00 41.32           C  
ATOM   1283  NH1 ARG A 162      17.729  38.932 168.898  1.00 42.02           N  
ATOM   1284  NH2 ARG A 162      17.061  36.761 168.976  1.00 43.00           N  
ATOM   1285  N   ARG A 163      13.230  40.189 162.951  1.00 37.62           N  
ATOM   1286  CA  ARG A 163      13.182  39.266 161.817  1.00 40.30           C  
ATOM   1287  C   ARG A 163      13.891  37.968 162.076  1.00 40.40           C  
ATOM   1288  O   ARG A 163      14.899  37.904 162.785  1.00 40.67           O  
ATOM   1289  CB  ARG A 163      13.687  39.953 160.537  1.00 42.93           C  
ATOM   1290  CG  ARG A 163      13.654  39.089 159.286  1.00 45.58           C  
ATOM   1291  CD  ARG A 163      13.668  40.002 158.054  1.00 47.49           C  
ATOM   1292  NE  ARG A 163      12.491  40.876 158.122  1.00 49.71           N  
ATOM   1293  CZ  ARG A 163      11.340  40.670 157.482  1.00 51.24           C  
ATOM   1294  NH1 ARG A 163      11.204  39.657 156.631  1.00 51.98           N  
ATOM   1295  NH2 ARG A 163      10.336  41.524 157.651  1.00 51.68           N  
ATOM   1296  N   GLY A 164      13.315  36.935 161.478  1.00 40.15           N  
ATOM   1297  CA  GLY A 164      13.809  35.569 161.580  1.00 40.31           C  
ATOM   1298  C   GLY A 164      15.046  35.337 160.733  1.00 40.78           C  
ATOM   1299  O   GLY A 164      15.258  36.040 159.743  1.00 42.25           O  
ATOM   1300  N   ALA A 177      13.067  46.928 168.766  1.00 57.65           N  
ATOM   1301  CA  ALA A 177      12.359  45.941 167.938  1.00 56.01           C  
ATOM   1302  C   ALA A 177      10.880  46.210 167.884  1.00 54.68           C  
ATOM   1303  O   ALA A 177      10.390  47.141 168.519  1.00 54.49           O  
ATOM   1304  CB  ALA A 177      12.593  44.557 168.467  1.00 56.34           C  
ATOM   1305  N   LEU A 178      10.223  45.407 167.047  1.00 52.80           N  
ATOM   1306  CA  LEU A 178       8.755  45.403 166.837  1.00 51.76           C  
ATOM   1307  C   LEU A 178       8.213  45.876 165.517  1.00 49.09           C  
ATOM   1308  O   LEU A 178       8.792  46.762 164.927  1.00 52.90           O  
ATOM   1309  N   ARG A 179       7.138  45.225 165.050  1.00 46.95           N  
ATOM   1310  CA  ARG A 179       6.429  45.572 163.781  0.50 44.82           C  
ATOM   1312  C   ARG A 179       4.918  45.777 163.830  1.00 42.20           C  
ATOM   1313  O   ARG A 179       4.269  45.612 164.830  1.00 38.09           O  
ATOM   1314  CB  ARG A 179       6.744  44.688 162.562  0.50 45.49           C  
ATOM   1316  CG  ARG A 179       7.687  45.374 161.596  0.50 46.40           C  
ATOM   1318  CD  ARG A 179       7.436  44.873 160.168  0.50 46.47           C  
ATOM   1320  NE  ARG A 179       7.983  45.789 159.173  0.50 47.10           N  
ATOM   1322  CZ  ARG A 179       9.112  45.603 158.501  0.50 47.57           C  
ATOM   1324  NH1 ARG A 179       9.824  44.497 158.666  0.50 47.84           N  
ATOM   1326  NH2 ARG A 179       9.510  46.514 157.625  0.50 47.68           N  
ATOM   1328  N   GLU A 180       4.437  46.157 162.663  1.00 39.46           N  
ATOM   1329  CA  GLU A 180       3.033  46.559 162.400  1.00 38.16           C  
ATOM   1330  C   GLU A 180       1.905  45.749 163.003  1.00 34.50           C  
ATOM   1331  O   GLU A 180       0.958  46.323 163.541  1.00 31.65           O  
ATOM   1332  CB  GLU A 180       2.748  46.759 160.892  1.00 40.03           C  
ATOM   1333  CG  GLU A 180       1.638  47.786 160.707  1.00 42.42           C  
ATOM   1334  CD  GLU A 180       0.981  47.747 159.352  1.00 44.68           C  
ATOM   1335  OE1 GLU A 180       0.365  46.691 159.070  1.00 47.01           O  
ATOM   1336  OE2 GLU A 180       0.997  48.779 158.611  1.00 44.89           O  
ATOM   1337  N   PHE A 181       2.003  44.441 162.924  1.00 33.03           N  
ATOM   1338  CA  PHE A 181       0.905  43.600 163.433  1.00 31.43           C  
ATOM   1339  C   PHE A 181       0.711  43.817 164.926  1.00 30.30           C  
ATOM   1340  O   PHE A 181      -0.403  43.758 165.446  1.00 28.80           O  
ATOM   1341  CB  PHE A 181       1.112  42.133 163.046  1.00 33.12           C  
ATOM   1342  CG  PHE A 181      -0.065  41.273 163.358  1.00 32.70           C  
ATOM   1343  CD1 PHE A 181      -1.342  41.695 163.027  1.00 33.55           C  
ATOM   1344  CD2 PHE A 181       0.100  40.014 163.854  1.00 33.10           C  
ATOM   1345  CE1 PHE A 181      -2.452  40.885 163.300  1.00 33.56           C  
ATOM   1346  CE2 PHE A 181      -0.994  39.218 164.109  1.00 33.11           C  
ATOM   1347  CZ  PHE A 181      -2.265  39.660 163.834  1.00 32.61           C  
ATOM   1348  N   ASN A 182       1.813  44.100 165.615  1.00 29.61           N  
ATOM   1349  CA  ASN A 182       1.749  44.355 167.045  1.00 28.95           C  
ATOM   1350  C   ASN A 182       0.822  45.534 167.334  1.00 27.66           C  
ATOM   1351  O   ASN A 182      -0.007  45.494 168.237  1.00 28.64           O  
ATOM   1352  CB  ASN A 182       3.130  44.717 167.617  1.00 28.36           C  
ATOM   1353  CG  ASN A 182       4.143  43.622 167.451  1.00 28.89           C  
ATOM   1354  OD1 ASN A 182       3.787  42.457 167.261  1.00 29.76           O  
ATOM   1355  ND2 ASN A 182       5.421  43.978 167.559  1.00 29.34           N  
ATOM   1356  N   HIS A 183       0.965  46.575 166.523  1.00 27.36           N  
ATOM   1357  CA  HIS A 183       0.192  47.830 166.699  1.00 28.35           C  
ATOM   1358  C   HIS A 183      -1.247  47.630 166.348  1.00 29.80           C  
ATOM   1359  O   HIS A 183      -2.131  48.211 166.969  1.00 31.36           O  
ATOM   1360  CB  HIS A 183       0.822  48.968 165.929  1.00 28.24           C  
ATOM   1361  CG  HIS A 183       2.209  49.265 166.386  1.00 28.23           C  
ATOM   1362  ND1 HIS A 183       2.516  50.341 167.188  1.00 27.88           N  
ATOM   1363  CD2 HIS A 183       3.360  48.567 166.223  1.00 28.52           C  
ATOM   1364  CE1 HIS A 183       3.813  50.329 167.437  1.00 28.89           C  
ATOM   1365  NE2 HIS A 183       4.347  49.256 166.880  1.00 28.51           N  
ATOM   1366  N   HIS A 184      -1.468  46.787 165.352  1.00 29.77           N  
ATOM   1367  CA  HIS A 184      -2.823  46.467 164.921  1.00 30.48           C  
ATOM   1368  C   HIS A 184      -3.575  45.631 165.952  1.00 31.49           C  
ATOM   1369  O   HIS A 184      -4.602  46.021 166.494  1.00 32.71           O  
ATOM   1370  CB  HIS A 184      -2.790  45.647 163.634  1.00 30.01           C  
ATOM   1371  CG  HIS A 184      -4.149  45.199 163.172  1.00 30.55           C  
ATOM   1372  ND1 HIS A 184      -5.005  46.020 162.460  1.00 30.71           N  
ATOM   1373  CD2 HIS A 184      -4.805  44.026 163.341  1.00 30.53           C  
ATOM   1374  CE1 HIS A 184      -6.118  45.360 162.189  1.00 32.31           C  
ATOM   1375  NE2 HIS A 184      -6.028  44.153 162.722  1.00 30.39           N  
ATOM   1376  N   LEU A 185      -2.986  44.500 166.265  1.00 32.52           N  
ATOM   1377  CA  LEU A 185      -3.647  43.509 167.138  1.00 34.88           C  
ATOM   1378  C   LEU A 185      -3.900  44.002 168.537  1.00 35.90           C  
ATOM   1379  O   LEU A 185      -4.907  43.632 169.185  1.00 37.50           O  
ATOM   1380  CB  LEU A 185      -2.861  42.186 167.168  1.00 34.19           C  
ATOM   1381  CG  LEU A 185      -3.628  41.009 167.758  1.00 35.13           C  
ATOM   1382  CD1 LEU A 185      -4.870  40.767 166.917  1.00 36.37           C  
ATOM   1383  CD2 LEU A 185      -2.728  39.780 167.829  1.00 35.91           C  
ATOM   1384  N   SER A 186      -3.037  44.897 168.975  1.00 36.54           N  
ATOM   1385  CA  SER A 186      -3.148  45.446 170.323  0.50 37.52           C  
ATOM   1387  C   SER A 186      -4.359  46.350 170.446  1.00 38.16           C  
ATOM   1388  O   SER A 186      -4.841  46.635 171.558  1.00 39.10           O  
ATOM   1389  CB  SER A 186      -1.890  46.229 170.704  0.50 37.79           C  
ATOM   1391  OG  SER A 186      -1.746  47.374 169.894  0.50 39.24           O  
ATOM   1393  N   ARG A 187      -4.866  46.781 169.295  1.00 38.27           N  
ATOM   1394  CA  ARG A 187      -6.028  47.694 169.228  1.00 37.43           C  
ATOM   1395  C   ARG A 187      -7.311  47.001 168.924  1.00 38.38           C  
ATOM   1396  O   ARG A 187      -8.387  47.604 168.943  1.00 39.09           O  
ATOM   1397  CB  ARG A 187      -5.800  48.786 168.216  1.00 37.03           C  
ATOM   1398  CG  ARG A 187      -4.915  49.797 168.745  1.00 36.53           C  
ATOM   1399  CD  ARG A 187      -4.493  50.732 167.699  1.00 35.54           C  
ATOM   1400  NE  ARG A 187      -3.847  51.873 168.317  1.00 35.78           N  
ATOM   1401  CZ  ARG A 187      -2.590  51.881 168.716  1.00 35.78           C  
ATOM   1402  NH1 ARG A 187      -1.857  50.769 168.600  1.00 37.27           N  
ATOM   1403  NH2 ARG A 187      -2.101  52.989 169.249  1.00 34.49           N  
ATOM   1404  N   ARG A 188      -7.192  45.722 168.670  1.00 38.92           N  
ATOM   1405  CA  ARG A 188      -8.372  44.910 168.384  1.00 39.39           C  
ATOM   1406  C   ARG A 188      -9.058  44.517 169.669  1.00 39.16           C  
ATOM   1407  O   ARG A 188      -8.643  43.595 170.381  1.00 38.17           O  
ATOM   1408  CB  ARG A 188      -8.013  43.761 167.499  1.00 40.62           C  
ATOM   1409  CG  ARG A 188      -7.810  44.409 166.188  1.00 41.66           C  
ATOM   1410  CD  ARG A 188      -7.823  43.510 165.093  1.00 42.56           C  
ATOM   1411  NE  ARG A 188      -9.021  42.696 165.081  1.00 42.51           N  
ATOM   1412  CZ  ARG A 188      -9.436  42.086 163.994  1.00 41.12           C  
ATOM   1413  NH1 ARG A 188      -8.798  42.330 162.866  1.00 41.15           N  
ATOM   1414  NH2 ARG A 188     -10.501  41.315 164.034  1.00 40.80           N  
ATOM   1415  N   ARG A 189     -10.167  45.211 169.914  1.00 37.17           N  
ATOM   1416  CA  ARG A 189     -10.942  44.994 171.145  0.50 37.59           C  
ATOM   1418  C   ARG A 189     -11.549  43.609 171.246  1.00 36.51           C  
ATOM   1419  O   ARG A 189     -12.075  43.233 172.286  1.00 37.48           O  
ATOM   1420  CB  ARG A 189     -12.044  46.051 171.347  0.50 38.54           C  
ATOM   1422  CG  ARG A 189     -11.536  47.453 171.686  0.50 39.18           C  
ATOM   1424  CD  ARG A 189     -12.681  48.243 172.286  0.50 39.62           C  
ATOM   1426  NE  ARG A 189     -12.364  49.614 172.673  0.50 40.31           N  
ATOM   1428  CZ  ARG A 189     -11.244  50.263 172.371  0.50 40.67           C  
ATOM   1430  NH1 ARG A 189     -10.317  49.699 171.608  0.50 40.55           N  
ATOM   1432  NH2 ARG A 189     -11.082  51.515 172.794  0.50 40.89           N  
ATOM   1434  N   ASP A 190     -11.465  42.869 170.154  1.00 34.77           N  
ATOM   1435  CA  ASP A 190     -11.997  41.504 170.069  1.00 33.62           C  
ATOM   1436  C   ASP A 190     -10.959  40.470 170.465  1.00 31.84           C  
ATOM   1437  O   ASP A 190     -11.259  39.291 170.595  1.00 30.21           O  
ATOM   1438  CB  ASP A 190     -12.606  41.179 168.709  1.00 34.65           C  
ATOM   1439  CG  ASP A 190     -11.700  41.489 167.544  1.00 35.65           C  
ATOM   1440  OD1 ASP A 190     -10.786  42.334 167.676  1.00 36.30           O  
ATOM   1441  OD2 ASP A 190     -11.962  40.893 166.479  1.00 35.58           O  
ATOM   1442  N   PHE A 191      -9.753  40.966 170.697  1.00 31.26           N  
ATOM   1443  CA  PHE A 191      -8.622  40.144 171.167  1.00 29.23           C  
ATOM   1444  C   PHE A 191      -7.936  40.686 172.405  1.00 28.66           C  
ATOM   1445  O   PHE A 191      -7.893  41.888 172.650  1.00 28.67           O  
ATOM   1446  CB  PHE A 191      -7.536  40.018 170.093  1.00 28.97           C  
ATOM   1447  CG  PHE A 191      -7.905  39.132 168.964  1.00 28.43           C  
ATOM   1448  CD1 PHE A 191      -8.624  39.616 167.888  1.00 28.24           C  
ATOM   1449  CD2 PHE A 191      -7.510  37.808 168.960  1.00 28.87           C  
ATOM   1450  CE1 PHE A 191      -8.961  38.799 166.834  1.00 28.72           C  
ATOM   1451  CE2 PHE A 191      -7.873  36.975 167.922  1.00 29.41           C  
ATOM   1452  CZ  PHE A 191      -8.589  37.489 166.839  1.00 28.90           C  
ATOM   1453  N   PHE A 192      -7.428  39.750 173.203  1.00 28.60           N  
ATOM   1454  CA  PHE A 192      -6.601  40.076 174.357  1.00 29.10           C  
ATOM   1455  C   PHE A 192      -5.178  39.649 173.934  1.00 29.52           C  
ATOM   1456  O   PHE A 192      -4.891  38.464 173.704  1.00 28.97           O  
ATOM   1457  CB  PHE A 192      -6.997  39.423 175.681  1.00 29.05           C  
ATOM   1458  CG  PHE A 192      -6.082  39.814 176.804  1.00 28.87           C  
ATOM   1459  CD1 PHE A 192      -6.353  40.942 177.572  1.00 29.82           C  
ATOM   1460  CD2 PHE A 192      -4.905  39.092 177.052  1.00 31.09           C  
ATOM   1461  CE1 PHE A 192      -5.494  41.324 178.602  1.00 29.62           C  
ATOM   1462  CE2 PHE A 192      -4.045  39.460 178.063  1.00 31.19           C  
ATOM   1463  CZ  PHE A 192      -4.328  40.590 178.842  1.00 29.27           C  
ATOM   1464  N   THR A 193      -4.275  40.611 173.898  1.00 28.56           N  
ATOM   1465  CA  THR A 193      -2.924  40.340 173.400  1.00 30.88           C  
ATOM   1466  C   THR A 193      -1.756  40.672 174.321  1.00 29.98           C  
ATOM   1467  O   THR A 193      -1.820  41.524 175.178  1.00 28.96           O  
ATOM   1468  CB  THR A 193      -2.698  41.189 172.057  1.00 32.21           C  
ATOM   1469  OG1 THR A 193      -3.734  40.926 171.087  1.00 33.93           O  
ATOM   1470  CG2 THR A 193      -1.359  40.886 171.399  1.00 33.37           C  
ATOM   1471  N   THR A 194      -0.684  39.930 174.125  1.00 29.60           N  
ATOM   1472  CA  THR A 194       0.548  40.200 174.834  1.00 28.41           C  
ATOM   1473  C   THR A 194       1.683  39.665 173.975  1.00 27.45           C  
ATOM   1474  O   THR A 194       1.484  38.775 173.150  1.00 29.45           O  
ATOM   1475  CB  THR A 194       0.589  39.601 176.241  1.00 28.84           C  
ATOM   1476  OG1 THR A 194       1.601  40.295 177.004  1.00 29.02           O  
ATOM   1477  CG2 THR A 194       0.844  38.039 176.208  1.00 27.17           C  
ATOM   1478  N   ILE A 195       2.865  40.227 174.170  1.00 26.56           N  
ATOM   1479  CA  ILE A 195       4.057  39.808 173.454  1.00 27.02           C  
ATOM   1480  C   ILE A 195       5.073  39.287 174.471  1.00 28.45           C  
ATOM   1481  O   ILE A 195       5.435  39.984 175.407  1.00 30.15           O  
ATOM   1482  CB  ILE A 195       4.712  40.947 172.616  1.00 28.07           C  
ATOM   1483  CG1 ILE A 195       3.757  41.498 171.571  1.00 28.32           C  
ATOM   1484  CG2 ILE A 195       6.021  40.476 171.907  1.00 26.91           C  
ATOM   1485  CD1 ILE A 195       4.221  42.833 170.930  1.00 28.51           C  
ATOM   1486  N   VAL A 196       5.453  38.034 174.296  1.00 29.11           N  
ATOM   1487  CA  VAL A 196       6.451  37.458 175.188  0.50 29.58           C  
ATOM   1489  C   VAL A 196       7.801  37.550 174.450  1.00 29.46           C  
ATOM   1490  O   VAL A 196       7.978  37.175 173.287  1.00 29.72           O  
ATOM   1491  CB  VAL A 196       6.101  36.055 175.742  0.50 30.27           C  
ATOM   1493  CG1 VAL A 196       4.792  36.131 176.580  0.50 29.00           C  
ATOM   1495  CG2 VAL A 196       6.010  35.018 174.639  0.50 30.02           C  
ATOM   1497  N   PRO A 197       8.772  38.097 175.138  1.00 31.64           N  
ATOM   1498  CA  PRO A 197      10.007  38.249 174.395  1.00 33.94           C  
ATOM   1499  C   PRO A 197      10.958  37.049 174.357  1.00 34.84           C  
ATOM   1500  O   PRO A 197      12.130  37.177 174.735  1.00 37.53           O  
ATOM   1501  CB  PRO A 197      10.651  39.458 175.070  1.00 34.32           C  
ATOM   1502  CG  PRO A 197      10.175  39.433 176.383  1.00 34.18           C  
ATOM   1503  CD  PRO A 197       8.792  38.851 176.395  1.00 33.29           C  
ATOM   1504  N   VAL A 198      10.399  35.917 173.935  1.00 32.81           N  
ATOM   1505  CA  VAL A 198      11.162  34.661 173.757  0.50 33.08           C  
ATOM   1507  C   VAL A 198      11.601  34.625 172.296  1.00 32.63           C  
ATOM   1508  O   VAL A 198      10.863  34.976 171.404  1.00 31.19           O  
ATOM   1509  CB  VAL A 198      10.366  33.371 174.102  0.50 33.00           C  
ATOM   1511  CG1 VAL A 198       9.157  33.201 173.217  0.50 33.41           C  
ATOM   1513  CG2 VAL A 198      11.264  32.143 173.967  0.50 31.56           C  
ATOM   1515  N   GLY A 199      12.836  34.225 172.059  1.00 31.99           N  
ATOM   1516  CA  GLY A 199      13.362  34.176 170.689  1.00 31.92           C  
ATOM   1517  C   GLY A 199      13.347  35.543 169.999  1.00 30.11           C  
ATOM   1518  O   GLY A 199      13.926  36.499 170.470  1.00 31.57           O  
ATOM   1519  N   ASN A 200      12.662  35.595 168.875  1.00 29.25           N  
ATOM   1520  CA  ASN A 200      12.518  36.807 168.080  1.00 29.70           C  
ATOM   1521  C   ASN A 200      11.241  37.599 168.445  1.00 28.83           C  
ATOM   1522  O   ASN A 200      10.848  38.552 167.760  1.00 27.27           O  
ATOM   1523  CB  ASN A 200      12.538  36.456 166.587  1.00 30.75           C  
ATOM   1524  CG  ASN A 200      13.874  35.895 166.130  1.00 32.84           C  
ATOM   1525  OD1 ASN A 200      14.927  36.146 166.731  1.00 33.22           O  
ATOM   1526  ND2 ASN A 200      13.840  35.159 165.026  1.00 33.87           N  
ATOM   1527  N   GLY A 201      10.618  37.169 169.543  1.00 30.02           N  
ATOM   1528  CA  GLY A 201       9.379  37.772 170.066  1.00 29.86           C  
ATOM   1529  C   GLY A 201       8.198  36.989 169.558  1.00 28.37           C  
ATOM   1530  O   GLY A 201       8.138  36.619 168.397  1.00 28.45           O  
ATOM   1531  N   VAL A 202       7.267  36.728 170.457  1.00 27.27           N  
ATOM   1532  CA  VAL A 202       6.067  35.970 170.127  1.00 27.69           C  
ATOM   1533  C   VAL A 202       4.810  36.741 170.549  1.00 28.43           C  
ATOM   1534  O   VAL A 202       4.602  37.028 171.715  1.00 27.95           O  
ATOM   1535  CB  VAL A 202       6.066  34.550 170.791  1.00 28.92           C  
ATOM   1536  CG1 VAL A 202       4.788  33.769 170.383  1.00 27.98           C  
ATOM   1537  CG2 VAL A 202       7.342  33.746 170.417  1.00 28.59           C  
ATOM   1538  N   LEU A 203       3.995  37.079 169.558  1.00 28.53           N  
ATOM   1539  CA  LEU A 203       2.750  37.796 169.785  1.00 28.20           C  
ATOM   1540  C   LEU A 203       1.649  36.768 169.999  1.00 29.13           C  
ATOM   1541  O   LEU A 203       1.461  35.847 169.197  1.00 29.25           O  
ATOM   1542  CB  LEU A 203       2.427  38.705 168.598  1.00 29.99           C  
ATOM   1543  CG  LEU A 203       1.146  39.527 168.493  1.00 31.72           C  
ATOM   1544  CD1 LEU A 203       0.960  40.518 169.635  1.00 32.11           C  
ATOM   1545  CD2 LEU A 203       1.170  40.307 167.157  1.00 31.82           C  
ATOM   1546  N   LEU A 204       0.931  36.937 171.101  1.00 29.51           N  
ATOM   1547  CA  LEU A 204      -0.166  36.043 171.446  1.00 29.72           C  
ATOM   1548  C   LEU A 204      -1.448  36.844 171.499  1.00 30.24           C  
ATOM   1549  O   LEU A 204      -1.519  37.909 172.143  1.00 29.93           O  
ATOM   1550  CB  LEU A 204       0.094  35.384 172.809  1.00 30.25           C  
ATOM   1551  CG  LEU A 204       1.392  34.589 172.991  1.00 30.51           C  
ATOM   1552  CD1 LEU A 204       1.605  34.129 174.466  1.00 30.69           C  
ATOM   1553  CD2 LEU A 204       1.391  33.407 172.050  1.00 29.06           C  
ATOM   1554  N   GLY A 205      -2.444  36.332 170.791  1.00 29.87           N  
ATOM   1555  CA  GLY A 205      -3.784  36.945 170.754  1.00 30.25           C  
ATOM   1556  C   GLY A 205      -4.881  35.945 171.049  1.00 29.74           C  
ATOM   1557  O   GLY A 205      -5.100  34.991 170.295  1.00 30.14           O  
ATOM   1558  N   TYR A 206      -5.577  36.174 172.152  1.00 28.72           N  
ATOM   1559  CA  TYR A 206      -6.692  35.329 172.563  1.00 28.99           C  
ATOM   1560  C   TYR A 206      -7.980  35.979 172.103  1.00 29.60           C  
ATOM   1561  O   TYR A 206      -8.247  37.130 172.418  1.00 29.16           O  
ATOM   1562  CB  TYR A 206      -6.706  35.169 174.078  1.00 28.68           C  
ATOM   1563  CG  TYR A 206      -7.837  34.364 174.642  1.00 28.81           C  
ATOM   1564  CD1 TYR A 206      -7.736  32.976 174.726  1.00 29.44           C  
ATOM   1565  CD2 TYR A 206      -8.994  34.964 175.108  1.00 29.13           C  
ATOM   1566  CE1 TYR A 206      -8.764  32.224 175.233  1.00 29.32           C  
ATOM   1567  CE2 TYR A 206     -10.006  34.228 175.617  1.00 29.47           C  
ATOM   1568  CZ  TYR A 206      -9.879  32.850 175.695  1.00 29.62           C  
ATOM   1569  OH  TYR A 206     -10.894  32.111 176.220  1.00 30.23           O  
ATOM   1570  N   ARG A 207      -8.789  35.218 171.387  1.00 29.91           N  
ATOM   1571  CA  ARG A 207     -10.027  35.746 170.863  1.00 30.73           C  
ATOM   1572  C   ARG A 207     -11.084  35.704 171.939  1.00 29.63           C  
ATOM   1573  O   ARG A 207     -11.511  34.653 172.378  1.00 30.74           O  
ATOM   1574  CB  ARG A 207     -10.442  34.985 169.612  1.00 33.67           C  
ATOM   1575  CG  ARG A 207     -11.304  35.828 168.760  1.00 36.20           C  
ATOM   1576  CD  ARG A 207     -11.379  35.334 167.389  1.00 39.95           C  
ATOM   1577  NE  ARG A 207     -12.374  34.307 167.307  1.00 41.99           N  
ATOM   1578  CZ  ARG A 207     -13.595  34.462 166.816  1.00 42.65           C  
ATOM   1579  NH1 ARG A 207     -13.987  35.574 166.240  1.00 45.69           N  
ATOM   1580  NH2 ARG A 207     -14.404  33.438 166.836  1.00 42.55           N  
ATOM   1581  N   LEU A 208     -11.506  36.891 172.335  1.00 30.15           N  
ATOM   1582  CA  LEU A 208     -12.510  37.084 173.399  1.00 29.59           C  
ATOM   1583  C   LEU A 208     -13.864  36.483 173.027  1.00 28.24           C  
ATOM   1584  O   LEU A 208     -14.221  36.413 171.872  1.00 26.85           O  
ATOM   1585  CB  LEU A 208     -12.577  38.576 173.793  1.00 29.88           C  
ATOM   1586  CG  LEU A 208     -11.296  39.145 174.406  1.00 29.43           C  
ATOM   1587  CD1 LEU A 208     -11.395  40.651 174.551  1.00 30.89           C  
ATOM   1588  CD2 LEU A 208     -10.987  38.499 175.749  1.00 30.54           C  
ATOM   1589  N   SER A 209     -14.569  35.989 174.045  1.00 30.54           N  
ATOM   1590  CA  SER A 209     -15.883  35.333 173.886  1.00 30.96           C  
ATOM   1591  C   SER A 209     -16.903  36.268 173.248  1.00 32.97           C  
ATOM   1592  O   SER A 209     -17.776  35.783 172.531  1.00 33.79           O  
ATOM   1593  CB  SER A 209     -16.430  34.850 175.230  1.00 31.48           C  
ATOM   1594  OG  SER A 209     -15.532  33.960 175.870  1.00 29.56           O  
ATOM   1595  OXT SER A 209     -16.880  37.494 173.423  1.00 32.42           O  
TER    1596      SER A 209                                                      
END
MOLECULE T0509.pdb
ATOM      1  N   ASN     3      22.807  39.978 177.332  1.00 85.83           N  
ATOM      2  CA  ASN     3      23.661  39.212 178.288  1.00 85.41           C  
ATOM      3  C   ASN     3      22.931  38.088 179.010  1.00 84.96           C  
ATOM      4  O   ASN     3      23.158  36.907 178.737  1.00 84.71           O  
ATOM      5  CB  ASN     3      24.283  40.169 179.320  1.00 85.60           C  
ATOM      6  N   ALA     4      22.046  38.464 179.926  1.00 84.06           N  
ATOM      7  CA  ALA     4      21.329  37.491 180.736  1.00 83.06           C  
ATOM      8  C   ALA     4      20.380  36.562 180.006  1.00 82.36           C  
ATOM      9  O   ALA     4      20.103  35.452 180.462  1.00 82.26           O  
ATOM     10  CB  ALA     4      20.607  38.203 181.891  1.00 82.85           C  
ATOM     11  N   PHE     5      19.905  37.014 178.857  1.00 81.23           N  
ATOM     12  CA  PHE     5      19.008  36.219 178.041  1.00 79.90           C  
ATOM     13  C   PHE     5      19.689  34.923 177.583  1.00 78.36           C  
ATOM     14  O   PHE     5      19.070  33.859 177.581  1.00 77.95           O  
ATOM     15  CB  PHE     5      18.590  37.011 176.806  1.00 80.49           C  
ATOM     16  CG  PHE     5      17.733  36.228 175.838  1.00 82.32           C  
ATOM     17  CD1 PHE     5      16.356  36.140 176.022  1.00 83.80           C  
ATOM     18  CD2 PHE     5      18.306  35.556 174.759  1.00 83.29           C  
ATOM     19  CE1 PHE     5      15.564  35.398 175.148  1.00 85.48           C  
ATOM     20  CE2 PHE     5      17.522  34.810 173.883  1.00 84.01           C  
ATOM     21  CZ  PHE     5      16.149  34.731 174.079  1.00 84.46           C  
ATOM     22  N   GLU     6      20.960  35.016 177.195  1.00 77.13           N  
ATOM     23  CA  GLU     6      21.696  33.867 176.675  1.00 75.49           C  
ATOM     24  C   GLU     6      22.150  32.844 177.700  1.00 73.34           C  
ATOM     25  O   GLU     6      22.237  31.656 177.384  1.00 73.19           O  
ATOM     26  CB  GLU     6      22.890  34.355 175.852  1.00 76.28           C  
ATOM     27  CG  GLU     6      22.530  35.380 174.776  1.00 80.27           C  
ATOM     28  CD  GLU     6      23.464  36.574 174.805  1.00 85.77           C  
ATOM     29  OE1 GLU     6      23.350  37.389 175.746  1.00 88.31           O  
ATOM     30  OE2 GLU     6      24.317  36.691 173.899  1.00 86.53           O  
ATOM     31  N   TYR     7      22.433  33.303 178.915  1.00 71.13           N  
ATOM     32  CA  TYR     7      22.835  32.402 179.977  1.00 68.99           C  
ATOM     33  C   TYR     7      21.579  31.589 180.326  1.00 65.55           C  
ATOM     34  O   TYR     7      21.657  30.395 180.624  1.00 65.44           O  
ATOM     35  CB  TYR     7      23.336  33.190 181.196  1.00 70.74           C  
ATOM     36  CG  TYR     7      24.578  32.584 181.806  1.00 76.24           C  
ATOM     37  CD1 TYR     7      25.455  33.360 182.555  1.00 82.00           C  
ATOM     38  CD2 TYR     7      24.886  31.230 181.618  1.00 81.17           C  
ATOM     39  CE1 TYR     7      26.612  32.812 183.107  1.00 85.04           C  
ATOM     40  CE2 TYR     7      26.039  30.671 182.169  1.00 84.74           C  
ATOM     41  CZ  TYR     7      26.897  31.469 182.910  1.00 86.92           C  
ATOM     42  OH  TYR     7      28.037  30.923 183.455  1.00 89.05           O  
ATOM     43  N   LEU     8      20.416  32.239 180.292  1.00 61.60           N  
ATOM     44  CA  LEU     8      19.157  31.545 180.549  1.00 57.37           C  
ATOM     45  C   LEU     8      18.973  30.589 179.350  1.00 54.56           C  
ATOM     46  O   LEU     8      18.710  29.399 179.527  1.00 52.14           O  
ATOM     47  CB  LEU     8      17.989  32.541 180.606  1.00 57.65           C  
ATOM     48  CG  LEU     8      16.729  32.079 181.345  1.00 56.45           C  
ATOM     49  CD1 LEU     8      17.110  31.130 182.479  1.00 55.09           C  
ATOM     50  CD2 LEU     8      15.999  33.299 181.898  1.00 57.98           C  
ATOM     51  N   ARG     9      19.120  31.107 178.129  1.00 52.49           N  
ATOM     52  CA  ARG     9      18.958  30.280 176.932  1.00 52.08           C  
ATOM     53  C   ARG     9      19.926  29.104 176.942  1.00 51.11           C  
ATOM     54  O   ARG     9      19.532  27.959 176.699  1.00 50.55           O  
ATOM     55  CB  ARG     9      19.141  31.125 175.658  1.00 52.07           C  
ATOM     56  CG  ARG     9      19.009  30.335 174.364  1.00 54.77           C  
ATOM     57  CD  ARG     9      18.455  31.194 173.237  1.00 60.14           C  
ATOM     58  NE  ARG     9      19.283  32.362 172.952  1.00 64.34           N  
ATOM     59  CZ  ARG     9      20.451  32.322 172.316  1.00 68.63           C  
ATOM     60  NH1 ARG     9      20.939  31.164 171.888  1.00 69.94           N  
ATOM     61  NH2 ARG     9      21.131  33.441 172.107  1.00 68.03           N  
ATOM     62  N   THR    10      21.189  29.388 177.240  1.00 50.60           N  
ATOM     63  CA  THR    10      22.217  28.357 177.275  1.00 50.83           C  
ATOM     64  C   THR    10      21.903  27.262 178.291  1.00 49.87           C  
ATOM     65  O   THR    10      22.003  26.074 177.983  1.00 50.46           O  
ATOM     66  CB  THR    10      23.603  28.971 177.581  1.00 51.38           C  
ATOM     67  OG1 THR    10      23.896  29.986 176.608  1.00 51.78           O  
ATOM     68  CG2 THR    10      24.680  27.904 177.521  1.00 50.61           C  
ATOM     69  N   TYR    11      21.521  27.657 179.499  1.00 48.77           N  
ATOM     70  CA  TYR    11      21.185  26.675 180.524  1.00 48.46           C  
ATOM     71  C   TYR    11      19.954  25.857 180.130  1.00 46.71           C  
ATOM     72  O   TYR    11      19.919  24.643 180.332  1.00 46.43           O  
ATOM     73  CB  TYR    11      20.893  27.339 181.860  1.00 50.01           C  
ATOM     74  CG  TYR    11      20.510  26.319 182.902  1.00 52.08           C  
ATOM     75  CD1 TYR    11      21.471  25.474 183.449  1.00 54.43           C  
ATOM     76  CD2 TYR    11      19.173  26.115 183.256  1.00 52.57           C  
ATOM     77  CE1 TYR    11      21.121  24.459 184.331  1.00 56.00           C  
ATOM     78  CE2 TYR    11      18.812  25.101 184.141  1.00 56.55           C  
ATOM     79  CZ  TYR    11      19.795  24.275 184.668  1.00 55.82           C  
ATOM     80  OH  TYR    11      19.458  23.278 185.549  1.00 57.24           O  
ATOM     81  N   VAL    12      18.942  26.515 179.570  1.00 45.29           N  
ATOM     82  CA  VAL    12      17.728  25.810 179.173  1.00 43.79           C  
ATOM     83  C   VAL    12      17.970  24.915 177.964  1.00 44.31           C  
ATOM     84  O   VAL    12      17.489  23.784 177.919  1.00 44.59           O  
ATOM     85  CB  VAL    12      16.575  26.796 178.864  1.00 44.09           C  
ATOM     86  CG1 VAL    12      15.364  26.044 178.307  1.00 38.90           C  
ATOM     87  CG2 VAL    12      16.187  27.557 180.138  1.00 40.82           C  
ATOM     88  N   GLU    13      18.706  25.418 176.982  1.00 45.77           N  
ATOM     89  CA  GLU    13      18.991  24.621 175.801  1.00 47.52           C  
ATOM     90  C   GLU    13      19.917  23.460 176.170  1.00 48.95           C  
ATOM     91  O   GLU    13      19.657  22.312 175.826  1.00 49.14           O  
ATOM     92  CB  GLU    13      19.621  25.491 174.701  1.00 47.27           C  
ATOM     93  CG  GLU    13      18.594  26.143 173.776  1.00 46.73           C  
ATOM     94  CD  GLU    13      19.213  27.051 172.733  1.00 47.14           C  
ATOM     95  OE1 GLU    13      18.462  27.802 172.070  1.00 46.58           O  
ATOM     96  OE2 GLU    13      20.451  27.011 172.568  1.00 48.58           O  
ATOM     97  N   SER    14      20.991  23.759 176.893  1.00 50.77           N  
ATOM     98  CA  SER    14      21.962  22.741 177.291  1.00 52.40           C  
ATOM     99  C   SER    14      21.408  21.764 178.315  1.00 52.24           C  
ATOM    100  O   SER    14      22.111  20.838 178.732  1.00 52.54           O  
ATOM    101  CB  SER    14      23.201  23.405 177.884  1.00 53.25           C  
ATOM    102  OG  SER    14      22.943  23.882 179.203  1.00 55.29           O  
ATOM    103  N   THR    15      20.152  21.956 178.709  1.00 51.44           N  
ATOM    104  CA  THR    15      19.565  21.104 179.726  1.00 50.00           C  
ATOM    105  C   THR    15      18.254  20.425 179.338  1.00 49.00           C  
ATOM    106  O   THR    15      17.740  19.581 180.077  1.00 48.09           O  
ATOM    107  CB  THR    15      19.421  21.928 181.040  1.00 50.48           C  
ATOM    108  OG1 THR    15      19.790  21.124 182.163  1.00 53.93           O  
ATOM    109  CG2 THR    15      18.042  22.429 181.224  1.00 49.25           C  
ATOM    110  N   THR    16      17.709  20.805 178.186  1.00 47.75           N  
ATOM    111  CA  THR    16      16.482  20.191 177.693  1.00 48.20           C  
ATOM    112  C   THR    16      16.843  18.834 177.065  1.00 50.22           C  
ATOM    113  O   THR    16      17.668  18.759 176.143  1.00 52.31           O  
ATOM    114  CB  THR    16      15.795  21.062 176.622  1.00 46.53           C  
ATOM    115  OG1 THR    16      15.318  22.271 177.220  1.00 45.88           O  
ATOM    116  CG2 THR    16      14.625  20.317 175.997  1.00 42.52           C  
ATOM    117  N   GLU    17      16.228  17.764 177.563  1.00 51.38           N  
ATOM    118  CA  GLU    17      16.493  16.421 177.062  1.00 53.69           C  
ATOM    119  C   GLU    17      16.282  16.387 175.556  1.00 54.77           C  
ATOM    120  O   GLU    17      15.184  16.632 175.051  1.00 53.95           O  
ATOM    121  CB  GLU    17      15.569  15.413 177.748  1.00 54.69           C  
ATOM    122  CG  GLU    17      15.799  13.980 177.324  1.00 57.95           C  
ATOM    123  CD  GLU    17      14.636  13.081 177.692  1.00 63.33           C  
ATOM    124  OE1 GLU    17      14.500  12.002 177.075  1.00 66.36           O  
ATOM    125  OE2 GLU    17      13.861  13.451 178.601  1.00 65.09           O  
ATOM    126  N   THR    18      17.345  16.068 174.836  1.00 56.14           N  
ATOM    127  CA  THR    18      17.289  16.046 173.385  1.00 57.87           C  
ATOM    128  C   THR    18      16.318  15.040 172.775  1.00 57.45           C  
ATOM    129  O   THR    18      16.215  13.904 173.238  1.00 57.97           O  
ATOM    130  CB  THR    18      18.709  15.817 172.779  1.00 58.68           C  
ATOM    131  OG1 THR    18      19.251  14.577 173.255  1.00 60.50           O  
ATOM    132  CG2 THR    18      19.660  16.960 173.166  1.00 57.87           C  
ATOM    133  N   ASP    19      15.587  15.481 171.752  1.00 56.51           N  
ATOM    134  CA  ASP    19      14.670  14.600 171.041  1.00 56.34           C  
ATOM    135  C   ASP    19      15.294  14.421 169.648  1.00 55.42           C  
ATOM    136  O   ASP    19      15.637  15.401 168.973  1.00 56.44           O  
ATOM    137  CB  ASP    19      13.263  15.210 170.904  1.00 55.60           C  
ATOM    138  CG  ASP    19      12.348  14.348 170.050  1.00 57.72           C  
ATOM    139  OD1 ASP    19      12.857  13.661 169.136  1.00 62.68           O  
ATOM    140  OD2 ASP    19      11.122  14.363 170.272  1.00 59.68           O  
ATOM    141  N   ALA    20      15.442  13.171 169.218  1.00 53.78           N  
ATOM    142  CA  ALA    20      16.054  12.863 167.926  1.00 51.44           C  
ATOM    143  C   ALA    20      15.281  13.437 166.750  1.00 49.39           C  
ATOM    144  O   ALA    20      15.857  14.097 165.881  1.00 47.69           O  
ATOM    145  CB  ALA    20      16.208  11.346 167.765  1.00 51.74           C  
ATOM    146  N   ALA    21      13.978  13.189 166.728  1.00 46.99           N  
ATOM    147  CA  ALA    21      13.140  13.693 165.655  1.00 44.89           C  
ATOM    148  C   ALA    21      13.208  15.221 165.610  1.00 43.57           C  
ATOM    149  O   ALA    21      13.247  15.812 164.534  1.00 43.64           O  
ATOM    150  CB  ALA    21      11.692  13.224 165.853  1.00 44.67           C  
ATOM    151  N   VAL    22      13.229  15.860 166.779  1.00 41.64           N  
ATOM    152  CA  VAL    22      13.292  17.319 166.849  1.00 39.09           C  
ATOM    153  C   VAL    22      14.655  17.846 166.414  1.00 38.15           C  
ATOM    154  O   VAL    22      14.745  18.838 165.688  1.00 36.18           O  
ATOM    155  CB  VAL    22      12.990  17.834 168.282  1.00 38.83           C  
ATOM    156  CG1 VAL    22      13.345  19.328 168.388  1.00 37.70           C  
ATOM    157  CG2 VAL    22      11.520  17.610 168.622  1.00 36.88           C  
ATOM    158  N   ALA    23      15.719  17.184 166.860  1.00 38.78           N  
ATOM    159  CA  ALA    23      17.070  17.602 166.500  1.00 39.37           C  
ATOM    160  C   ALA    23      17.260  17.469 164.984  1.00 38.28           C  
ATOM    161  O   ALA    23      17.908  18.299 164.359  1.00 37.20           O  
ATOM    162  CB  ALA    23      18.100  16.748 167.239  1.00 39.71           C  
ATOM    163  N   ARG    24      16.692  16.419 164.402  1.00 39.08           N  
ATOM    164  CA  ARG    24      16.800  16.188 162.969  1.00 40.86           C  
ATOM    165  C   ARG    24      16.093  17.324 162.217  1.00 40.75           C  
ATOM    166  O   ARG    24      16.635  17.874 161.249  1.00 40.53           O  
ATOM    167  CB  ARG    24      16.183  14.820 162.628  1.00 41.74           C  
ATOM    168  CG  ARG    24      16.075  14.501 161.150  1.00 49.23           C  
ATOM    169  CD  ARG    24      17.421  14.551 160.446  1.00 54.35           C  
ATOM    170  NE  ARG    24      17.462  13.599 159.339  1.00 59.94           N  
ATOM    171  CZ  ARG    24      18.095  13.812 158.194  1.00 59.09           C  
ATOM    172  NH1 ARG    24      18.742  14.952 158.002  1.00 62.71           N  
ATOM    173  NH2 ARG    24      18.073  12.890 157.241  1.00 60.22           N  
ATOM    174  N   ALA    25      14.891  17.680 162.668  1.00 40.03           N  
ATOM    175  CA  ALA    25      14.128  18.752 162.037  1.00 40.19           C  
ATOM    176  C   ALA    25      14.839  20.105 162.157  1.00 40.52           C  
ATOM    177  O   ALA    25      14.731  20.951 161.261  1.00 41.05           O  
ATOM    178  CB  ALA    25      12.728  18.829 162.649  1.00 40.91           C  
ATOM    179  N   ARG    26      15.564  20.307 163.256  1.00 40.54           N  
ATOM    180  CA  ARG    26      16.300  21.552 163.475  1.00 40.67           C  
ATOM    181  C   ARG    26      17.542  21.569 162.573  1.00 41.44           C  
ATOM    182  O   ARG    26      17.953  22.620 162.081  1.00 43.15           O  
ATOM    183  CB  ARG    26      16.716  21.666 164.945  1.00 40.06           C  
ATOM    184  CG  ARG    26      17.206  23.049 165.344  1.00 41.06           C  
ATOM    185  CD  ARG    26      17.244  23.192 166.860  1.00 39.59           C  
ATOM    186  NE  ARG    26      15.918  23.381 167.448  1.00 36.02           N  
ATOM    187  CZ  ARG    26      15.195  24.489 167.308  1.00 35.63           C  
ATOM    188  NH1 ARG    26      15.676  25.501 166.600  1.00 33.06           N  
ATOM    189  NH2 ARG    26      14.002  24.588 167.884  1.00 31.51           N  
ATOM    190  N   GLU    27      18.141  20.402 162.354  1.00 43.09           N  
ATOM    191  CA  GLU    27      19.306  20.309 161.483  1.00 45.53           C  
ATOM    192  C   GLU    27      18.829  20.549 160.048  1.00 44.47           C  
ATOM    193  O   GLU    27      19.434  21.325 159.304  1.00 44.94           O  
ATOM    194  CB  GLU    27      19.947  18.925 161.590  1.00 47.21           C  
ATOM    195  CG  GLU    27      21.435  18.965 161.907  1.00 56.44           C  
ATOM    196  CD  GLU    27      22.265  19.573 160.788  1.00 64.19           C  
ATOM    197  OE1 GLU    27      22.345  20.818 160.694  1.00 65.65           O  
ATOM    198  OE2 GLU    27      22.830  18.791 159.994  1.00 68.30           O  
ATOM    199  N   ASP    28      17.742  19.882 159.656  1.00 43.22           N  
ATOM    200  CA  ASP    28      17.198  20.053 158.307  1.00 42.84           C  
ATOM    201  C   ASP    28      16.904  21.517 157.990  1.00 42.31           C  
ATOM    202  O   ASP    28      17.295  22.014 156.935  1.00 42.99           O  
ATOM    203  CB  ASP    28      15.924  19.225 158.124  1.00 41.28           C  
ATOM    204  CG  ASP    28      16.209  17.744 157.975  1.00 42.74           C  
ATOM    205  OD1 ASP    28      17.404  17.380 157.943  1.00 44.72           O  
ATOM    206  OD2 ASP    28      15.246  16.946 157.885  1.00 45.45           O  
ATOM    207  N   ALA    29      16.225  22.209 158.902  1.00 41.52           N  
ATOM    208  CA  ALA    29      15.882  23.616 158.687  1.00 40.18           C  
ATOM    209  C   ALA    29      17.117  24.477 158.480  1.00 39.57           C  
ATOM    210  O   ALA    29      17.132  25.362 157.620  1.00 39.63           O  
ATOM    211  CB  ALA    29      15.058  24.154 159.864  1.00 40.56           C  
ATOM    212  N   ALA    30      18.146  24.209 159.275  1.00 39.17           N  
ATOM    213  CA  ALA    30      19.398  24.949 159.198  1.00 40.05           C  
ATOM    214  C   ALA    30      20.107  24.679 157.868  1.00 39.78           C  
ATOM    215  O   ALA    30      20.666  25.591 157.260  1.00 40.00           O  
ATOM    216  CB  ALA    30      20.305  24.561 160.365  1.00 40.11           C  
ATOM    217  N   GLU    31      20.085  23.427 157.422  1.00 38.65           N  
ATOM    218  CA  GLU    31      20.718  23.066 156.159  1.00 38.87           C  
ATOM    219  C   GLU    31      20.078  23.764 154.959  1.00 38.60           C  
ATOM    220  O   GLU    31      20.739  23.995 153.950  1.00 39.71           O  
ATOM    221  CB  GLU    31      20.668  21.552 155.963  1.00 39.36           C  
ATOM    222  CG  GLU    31      21.691  20.795 156.786  1.00 38.74           C  
ATOM    223  CD  GLU    31      21.437  19.310 156.790  1.00 43.41           C  
ATOM    224  OE1 GLU    31      20.865  18.809 155.803  1.00 47.35           O  
ATOM    225  OE2 GLU    31      21.820  18.637 157.764  1.00 48.92           O  
ATOM    226  N   PHE    32      18.796  24.105 155.072  1.00 37.78           N  
ATOM    227  CA  PHE    32      18.071  24.765 153.985  1.00 36.92           C  
ATOM    228  C   PHE    32      17.846  26.256 154.223  1.00 37.72           C  
ATOM    229  O   PHE    32      17.134  26.913 153.457  1.00 36.82           O  
ATOM    230  CB  PHE    32      16.727  24.064 153.758  1.00 35.46           C  
ATOM    231  CG  PHE    32      16.852  22.714 153.100  1.00 35.81           C  
ATOM    232  CD1 PHE    32      16.814  22.592 151.708  1.00 32.38           C  
ATOM    233  CD2 PHE    32      16.998  21.562 153.873  1.00 29.85           C  
ATOM    234  CE1 PHE    32      16.925  21.341 151.098  1.00 34.55           C  
ATOM    235  CE2 PHE    32      17.113  20.313 153.274  1.00 32.22           C  
ATOM    236  CZ  PHE    32      17.074  20.200 151.884  1.00 34.18           C  
ATOM    237  N   GLY    33      18.448  26.777 155.289  1.00 38.67           N  
ATOM    238  CA  GLY    33      18.321  28.190 155.623  1.00 38.55           C  
ATOM    239  C   GLY    33      16.923  28.661 155.983  1.00 37.08           C  
ATOM    240  O   GLY    33      16.572  29.818 155.756  1.00 36.54           O  
ATOM    241  N   LEU    34      16.129  27.765 156.564  1.00 38.38           N  
ATOM    242  CA  LEU    34      14.751  28.092 156.938  1.00 38.59           C  
ATOM    243  C   LEU    34      14.629  28.720 158.321  1.00 37.66           C  
ATOM    244  O   LEU    34      15.399  28.397 159.220  1.00 39.17           O  
ATOM    245  CB  LEU    34      13.887  26.827 156.897  1.00 38.83           C  
ATOM    246  CG  LEU    34      13.963  25.954 155.641  1.00 38.72           C  
ATOM    247  CD1 LEU    34      13.204  24.651 155.855  1.00 40.78           C  
ATOM    248  CD2 LEU    34      13.393  26.715 154.462  1.00 38.26           C  
ATOM    249  N   PRO    35      13.655  29.627 158.500  1.00 38.39           N  
ATOM    250  CA  PRO    35      13.416  30.306 159.780  1.00 39.03           C  
ATOM    251  C   PRO    35      12.913  29.261 160.777  1.00 40.77           C  
ATOM    252  O   PRO    35      11.820  28.713 160.611  1.00 41.07           O  
ATOM    253  CB  PRO    35      12.323  31.328 159.454  1.00 39.92           C  
ATOM    254  CG  PRO    35      12.269  31.377 157.939  1.00 39.36           C  
ATOM    255  CD  PRO    35      12.651  30.009 157.495  1.00 37.58           C  
ATOM    256  N   ALA    36      13.702  29.004 161.819  1.00 41.01           N  
ATOM    257  CA  ALA    36      13.344  27.997 162.818  1.00 40.99           C  
ATOM    258  C   ALA    36      13.320  28.519 164.250  1.00 40.41           C  
ATOM    259  O   ALA    36      14.364  28.860 164.803  1.00 41.47           O  
ATOM    260  CB  ALA    36      14.304  26.820 162.726  1.00 39.29           C  
ATOM    261  N   PRO    37      12.131  28.565 164.869  1.00 39.76           N  
ATOM    262  CA  PRO    37      11.992  29.042 166.250  1.00 37.91           C  
ATOM    263  C   PRO    37      12.926  28.246 167.151  1.00 36.44           C  
ATOM    264  O   PRO    37      13.077  27.035 166.962  1.00 35.90           O  
ATOM    265  CB  PRO    37      10.524  28.755 166.578  1.00 38.50           C  
ATOM    266  CG  PRO    37       9.850  28.774 165.250  1.00 40.52           C  
ATOM    267  CD  PRO    37      10.840  28.108 164.325  1.00 40.07           C  
ATOM    268  N   ASP    38      13.533  28.908 168.135  1.00 34.43           N  
ATOM    269  CA  ASP    38      14.448  28.213 169.038  1.00 34.87           C  
ATOM    270  C   ASP    38      13.717  27.211 169.936  1.00 35.84           C  
ATOM    271  O   ASP    38      12.491  27.094 169.887  1.00 34.82           O  
ATOM    272  CB  ASP    38      15.273  29.226 169.873  1.00 35.43           C  
ATOM    273  CG  ASP    38      14.428  30.055 170.830  1.00 37.24           C  
ATOM    274  OD1 ASP    38      13.181  30.018 170.734  1.00 39.36           O  
ATOM    275  OD2 ASP    38      15.029  30.747 171.687  1.00 41.15           O  
ATOM    276  N   GLU    39      14.478  26.489 170.752  1.00 35.27           N  
ATOM    277  CA  GLU    39      13.916  25.474 171.629  1.00 35.36           C  
ATOM    278  C   GLU    39      12.890  25.983 172.629  1.00 34.78           C  
ATOM    279  O   GLU    39      11.907  25.298 172.910  1.00 35.10           O  
ATOM    280  CB  GLU    39      15.040  24.754 172.372  1.00 36.46           C  
ATOM    281  CG  GLU    39      14.579  23.753 173.433  1.00 39.24           C  
ATOM    282  CD  GLU    39      13.757  22.609 172.864  1.00 42.52           C  
ATOM    283  OE1 GLU    39      14.081  22.141 171.754  1.00 46.69           O  
ATOM    284  OE2 GLU    39      12.795  22.167 173.532  1.00 44.19           O  
ATOM    285  N   MET    40      13.120  27.181 173.155  1.00 33.85           N  
ATOM    286  CA  MET    40      12.224  27.769 174.137  1.00 33.31           C  
ATOM    287  C   MET    40      10.880  28.153 173.523  1.00 31.59           C  
ATOM    288  O   MET    40       9.831  27.983 174.152  1.00 30.49           O  
ATOM    289  CB  MET    40      12.890  28.989 174.807  1.00 32.67           C  
ATOM    290  CG  MET    40      13.914  28.637 175.903  1.00 37.51           C  
ATOM    291  SD  MET    40      14.599  30.227 176.837  1.00 48.82          SE  
ATOM    292  CE  MET    40      16.150  29.483 177.672  1.00 47.77           C  
ATOM    293  N   THR    41      10.918  28.669 172.297  1.00 29.68           N  
ATOM    294  CA  THR    41       9.699  29.043 171.600  1.00 27.32           C  
ATOM    295  C   THR    41       8.914  27.755 171.285  1.00 26.43           C  
ATOM    296  O   THR    41       7.687  27.737 171.383  1.00 27.19           O  
ATOM    297  CB  THR    41      10.025  29.797 170.296  1.00 28.66           C  
ATOM    298  OG1 THR    41      10.738  30.996 170.619  1.00 26.10           O  
ATOM    299  CG2 THR    41       8.741  30.156 169.536  1.00 25.19           C  
ATOM    300  N   GLY    42       9.621  26.685 170.914  1.00 24.88           N  
ATOM    301  CA  GLY    42       8.967  25.414 170.622  1.00 26.74           C  
ATOM    302  C   GLY    42       8.266  24.847 171.858  1.00 27.45           C  
ATOM    303  O   GLY    42       7.145  24.339 171.751  1.00 27.33           O  
ATOM    304  N   GLN    43       8.910  24.928 173.025  1.00 26.78           N  
ATOM    305  CA  GLN    43       8.324  24.434 174.276  1.00 28.12           C  
ATOM    306  C   GLN    43       7.010  25.190 174.550  1.00 27.73           C  
ATOM    307  O   GLN    43       6.005  24.584 174.947  1.00 27.06           O  
ATOM    308  CB  GLN    43       9.332  24.610 175.437  1.00 27.92           C  
ATOM    309  CG  GLN    43      10.505  23.632 175.352  1.00 28.63           C  
ATOM    310  CD  GLN    43      11.578  23.886 176.399  1.00 34.03           C  
ATOM    311  OE1 GLN    43      11.355  24.607 177.373  1.00 36.82           O  
ATOM    312  NE2 GLN    43      12.752  23.290 176.204  1.00 32.59           N  
ATOM    313  N   LEU    44       7.014  26.508 174.335  1.00 27.40           N  
ATOM    314  CA  LEU    44       5.796  27.299 174.512  1.00 27.16           C  
ATOM    315  C   LEU    44       4.729  26.819 173.503  1.00 26.87           C  
ATOM    316  O   LEU    44       3.531  26.837 173.811  1.00 27.06           O  
ATOM    317  CB  LEU    44       6.061  28.795 174.302  1.00 25.60           C  
ATOM    318  CG  LEU    44       4.779  29.647 174.278  1.00 29.19           C  
ATOM    319  CD1 LEU    44       4.004  29.444 175.576  1.00 27.74           C  
ATOM    320  CD2 LEU    44       5.128  31.120 174.085  1.00 24.87           C  
ATOM    321  N   LEU    45       5.143  26.401 172.301  1.00 27.58           N  
ATOM    322  CA  LEU    45       4.174  25.911 171.307  1.00 29.21           C  
ATOM    323  C   LEU    45       3.531  24.614 171.836  1.00 28.50           C  
ATOM    324  O   LEU    45       2.331  24.399 171.691  1.00 29.78           O  
ATOM    325  CB  LEU    45       4.850  25.671 169.936  1.00 27.83           C  
ATOM    326  CG  LEU    45       5.300  26.957 169.216  1.00 30.54           C  
ATOM    327  CD1 LEU    45       5.894  26.601 167.853  1.00 32.59           C  
ATOM    328  CD2 LEU    45       4.104  27.908 169.041  1.00 29.82           C  
ATOM    329  N   THR    46       4.333  23.758 172.457  1.00 27.80           N  
ATOM    330  CA  THR    46       3.826  22.513 173.030  1.00 28.58           C  
ATOM    331  C   THR    46       2.826  22.835 174.150  1.00 27.31           C  
ATOM    332  O   THR    46       1.801  22.178 174.283  1.00 28.48           O  
ATOM    333  CB  THR    46       4.977  21.679 173.620  1.00 27.74           C  
ATOM    334  OG1 THR    46       5.956  21.451 172.604  1.00 28.37           O  
ATOM    335  CG2 THR    46       4.473  20.348 174.134  1.00 28.82           C  
ATOM    336  N   THR    47       3.136  23.852 174.953  1.00 28.69           N  
ATOM    337  CA  THR    47       2.279  24.266 176.060  1.00 27.73           C  
ATOM    338  C   THR    47       0.915  24.733 175.570  1.00 27.47           C  
ATOM    339  O   THR    47      -0.114  24.348 176.127  1.00 27.23           O  
ATOM    340  CB  THR    47       2.920  25.417 176.865  1.00 28.09           C  
ATOM    341  OG1 THR    47       4.170  24.984 177.415  1.00 27.40           O  
ATOM    342  CG2 THR    47       1.993  25.863 178.001  1.00 23.26           C  
ATOM    343  N   LEU    48       0.904  25.562 174.529  1.00 26.00           N  
ATOM    344  CA  LEU    48      -0.357  26.062 173.992  1.00 24.82           C  
ATOM    345  C   LEU    48      -1.138  24.957 173.294  1.00 24.93           C  
ATOM    346  O   LEU    48      -2.370  24.923 173.361  1.00 24.34           O  
ATOM    347  CB  LEU    48      -0.108  27.225 173.025  1.00 26.01           C  
ATOM    348  CG  LEU    48       0.505  28.475 173.683  1.00 30.70           C  
ATOM    349  CD1 LEU    48       0.765  29.551 172.624  1.00 30.77           C  
ATOM    350  CD2 LEU    48      -0.440  29.004 174.770  1.00 26.08           C  
ATOM    351  N   ALA    49      -0.428  24.053 172.620  1.00 25.73           N  
ATOM    352  CA  ALA    49      -1.091  22.953 171.935  1.00 26.68           C  
ATOM    353  C   ALA    49      -1.715  22.043 172.989  1.00 26.17           C  
ATOM    354  O   ALA    49      -2.765  21.445 172.761  1.00 25.74           O  
ATOM    355  CB  ALA    49      -0.084  22.163 171.077  1.00 24.82           C  
ATOM    356  N   ALA    50      -1.056  21.941 174.143  1.00 27.11           N  
ATOM    357  CA  ALA    50      -1.529  21.106 175.245  1.00 27.80           C  
ATOM    358  C   ALA    50      -2.642  21.769 176.057  1.00 29.60           C  
ATOM    359  O   ALA    50      -3.560  21.095 176.516  1.00 32.07           O  
ATOM    360  CB  ALA    50      -0.368  20.750 176.165  1.00 29.92           C  
ATOM    361  N   THR    51      -2.567  23.083 176.235  1.00 29.29           N  
ATOM    362  CA  THR    51      -3.576  23.787 177.009  1.00 30.18           C  
ATOM    363  C   THR    51      -4.841  24.127 176.208  1.00 32.02           C  
ATOM    364  O   THR    51      -5.941  24.063 176.767  1.00 31.22           O  
ATOM    365  CB  THR    51      -2.987  25.075 177.666  1.00 29.68           C  
ATOM    366  OG1 THR    51      -2.623  26.035 176.658  1.00 29.87           O  
ATOM    367  CG2 THR    51      -1.740  24.711 178.484  1.00 27.26           C  
ATOM    368  N   THR    52      -4.701  24.475 174.924  1.00 31.53           N  
ATOM    369  CA  THR    52      -5.877  24.802 174.119  1.00 31.58           C  
ATOM    370  C   THR    52      -6.810  23.597 174.026  1.00 33.91           C  
ATOM    371  O   THR    52      -6.387  22.444 174.151  1.00 34.00           O  
ATOM    372  CB  THR    52      -5.499  25.330 172.708  1.00 30.61           C  
ATOM    373  OG1 THR    52      -4.605  24.419 172.059  1.00 27.87           O  
ATOM    374  CG2 THR    52      -4.853  26.704 172.834  1.00 28.08           C  
ATOM    375  N   ASN    53      -8.085  23.868 173.784  1.00 36.96           N  
ATOM    376  CA  ASN    53      -9.107  22.823 173.780  1.00 41.28           C  
ATOM    377  C   ASN    53      -9.338  21.999 172.524  1.00 42.44           C  
ATOM    378  O   ASN    53      -9.875  22.501 171.540  1.00 42.24           O  
ATOM    379  CB  ASN    53     -10.426  23.449 174.254  1.00 41.27           C  
ATOM    380  CG  ASN    53     -11.429  22.416 174.745  1.00 44.44           C  
ATOM    381  OD1 ASN    53     -11.209  21.212 174.615  1.00 47.26           O  
ATOM    382  ND2 ASN    53     -12.548  22.888 175.303  1.00 47.57           N  
ATOM    383  N   GLY    54      -8.948  20.725 172.586  1.00 43.60           N  
ATOM    384  CA  GLY    54      -9.118  19.838 171.450  1.00 43.79           C  
ATOM    385  C   GLY    54     -10.568  19.477 171.184  1.00 46.01           C  
ATOM    386  O   GLY    54     -10.922  19.091 170.063  1.00 45.16           O  
ATOM    387  N   ASN    55     -11.408  19.603 172.213  1.00 46.67           N  
ATOM    388  CA  ASN    55     -12.834  19.294 172.096  1.00 46.74           C  
ATOM    389  C   ASN    55     -13.559  20.234 171.133  1.00 45.02           C  
ATOM    390  O   ASN    55     -13.647  21.441 171.374  1.00 46.21           O  
ATOM    391  CB  ASN    55     -13.509  19.362 173.473  1.00 48.61           C  
ATOM    392  CG  ASN    55     -13.087  18.220 174.394  1.00 52.70           C  
ATOM    393  OD1 ASN    55     -12.242  18.388 175.277  1.00 56.39           O  
ATOM    394  ND2 ASN    55     -13.671  17.045 174.179  1.00 58.74           N  
ATOM    395  N   GLY    56     -14.082  19.666 170.047  1.00 43.79           N  
ATOM    396  CA  GLY    56     -14.800  20.441 169.044  1.00 40.35           C  
ATOM    397  C   GLY    56     -13.862  21.143 168.080  1.00 38.97           C  
ATOM    398  O   GLY    56     -14.285  21.869 167.182  1.00 39.42           O  
ATOM    399  N   SER    57     -12.571  20.899 168.262  1.00 38.33           N  
ATOM    400  CA  SER    57     -11.535  21.505 167.437  1.00 35.50           C  
ATOM    401  C   SER    57     -10.963  20.557 166.387  1.00 33.56           C  
ATOM    402  O   SER    57     -10.777  19.374 166.646  1.00 31.18           O  
ATOM    403  CB  SER    57     -10.415  22.011 168.349  1.00 35.48           C  
ATOM    404  OG  SER    57      -9.243  22.356 167.632  1.00 34.61           O  
ATOM    405  N   THR    58     -10.681  21.087 165.200  1.00 32.90           N  
ATOM    406  CA  THR    58     -10.094  20.281 164.142  1.00 31.69           C  
ATOM    407  C   THR    58      -8.624  20.066 164.515  1.00 31.06           C  
ATOM    408  O   THR    58      -8.024  19.038 164.175  1.00 31.61           O  
ATOM    409  CB  THR    58     -10.180  20.998 162.777  1.00 32.99           C  
ATOM    410  OG1 THR    58     -11.548  21.305 162.487  1.00 32.94           O  
ATOM    411  CG2 THR    58      -9.628  20.102 161.665  1.00 33.92           C  
ATOM    412  N   GLY    59      -8.051  21.038 165.226  1.00 29.22           N  
ATOM    413  CA  GLY    59      -6.655  20.940 165.629  1.00 27.38           C  
ATOM    414  C   GLY    59      -5.873  22.231 165.456  1.00 28.44           C  
ATOM    415  O   GLY    59      -6.366  23.328 165.734  1.00 27.05           O  
ATOM    416  N   ALA    60      -4.650  22.104 164.964  1.00 27.51           N  
ATOM    417  CA  ALA    60      -3.798  23.261 164.784  1.00 28.53           C  
ATOM    418  C   ALA    60      -3.383  23.494 163.344  1.00 27.12           C  
ATOM    419  O   ALA    60      -3.470  22.598 162.499  1.00 26.54           O  
ATOM    420  CB  ALA    60      -2.553  23.121 165.676  1.00 26.61           C  
ATOM    421  N   ILE    61      -2.936  24.716 163.076  1.00 26.85           N  
ATOM    422  CA  ILE    61      -2.436  25.079 161.757  1.00 25.89           C  
ATOM    423  C   ILE    61      -1.026  25.662 161.925  1.00 26.23           C  
ATOM    424  O   ILE    61      -0.795  26.518 162.789  1.00 24.01           O  
ATOM    425  CB  ILE    61      -3.291  26.156 161.062  1.00 24.77           C  
ATOM    426  CG1 ILE    61      -4.711  25.646 160.832  1.00 26.17           C  
ATOM    427  CG2 ILE    61      -2.667  26.511 159.695  1.00 28.08           C  
ATOM    428  CD1 ILE    61      -5.649  26.690 160.250  1.00 24.83           C  
ATOM    429  N   ALA    62      -0.086  25.172 161.120  1.00 24.83           N  
ATOM    430  CA  ALA    62       1.285  25.687 161.129  1.00 27.04           C  
ATOM    431  C   ALA    62       1.558  26.266 159.728  1.00 26.93           C  
ATOM    432  O   ALA    62       1.616  25.537 158.737  1.00 27.63           O  
ATOM    433  CB  ALA    62       2.302  24.572 161.447  1.00 24.51           C  
ATOM    434  N   ILE    63       1.703  27.582 159.650  1.00 29.03           N  
ATOM    435  CA  ILE    63       1.974  28.269 158.397  1.00 30.40           C  
ATOM    436  C   ILE    63       3.430  28.702 158.444  1.00 30.95           C  
ATOM    437  O   ILE    63       3.771  29.745 159.002  1.00 32.03           O  
ATOM    438  CB  ILE    63       1.057  29.488 158.246  1.00 31.41           C  
ATOM    439  CG1 ILE    63      -0.394  29.016 158.112  1.00 33.10           C  
ATOM    440  CG2 ILE    63       1.472  30.306 157.044  1.00 33.12           C  
ATOM    441  CD1 ILE    63      -1.389  29.915 158.811  1.00 34.01           C  
ATOM    442  N   THR    64       4.289  27.911 157.812  1.00 31.33           N  
ATOM    443  CA  THR    64       5.721  28.179 157.842  1.00 31.25           C  
ATOM    444  C   THR    64       6.492  27.262 156.895  1.00 31.37           C  
ATOM    445  O   THR    64       6.055  26.147 156.621  1.00 31.07           O  
ATOM    446  CB  THR    64       6.248  27.938 159.275  1.00 30.66           C  
ATOM    447  OG1 THR    64       7.678  27.951 159.289  1.00 31.03           O  
ATOM    448  CG2 THR    64       5.768  26.557 159.795  1.00 30.49           C  
ATOM    449  N   PRO    65       7.651  27.719 156.398  1.00 32.35           N  
ATOM    450  CA  PRO    65       8.500  26.936 155.489  1.00 32.48           C  
ATOM    451  C   PRO    65       9.084  25.724 156.212  1.00 33.51           C  
ATOM    452  O   PRO    65       9.439  24.734 155.590  1.00 35.67           O  
ATOM    453  CB  PRO    65       9.603  27.913 155.089  1.00 31.90           C  
ATOM    454  CG  PRO    65       8.961  29.242 155.205  1.00 34.17           C  
ATOM    455  CD  PRO    65       8.050  29.140 156.412  1.00 32.46           C  
ATOM    456  N   ALA    66       9.209  25.823 157.529  1.00 33.82           N  
ATOM    457  CA  ALA    66       9.751  24.726 158.336  1.00 33.47           C  
ATOM    458  C   ALA    66       8.656  24.140 159.222  1.00 34.22           C  
ATOM    459  O   ALA    66       8.747  24.175 160.443  1.00 32.79           O  
ATOM    460  CB  ALA    66      10.897  25.226 159.206  1.00 34.03           C  
ATOM    461  N   ALA    67       7.622  23.586 158.600  1.00 34.58           N  
ATOM    462  CA  ALA    67       6.496  23.008 159.329  1.00 34.68           C  
ATOM    463  C   ALA    67       6.851  21.748 160.101  1.00 35.19           C  
ATOM    464  O   ALA    67       6.146  21.366 161.041  1.00 33.42           O  
ATOM    465  CB  ALA    67       5.348  22.721 158.365  1.00 33.52           C  
ATOM    466  N   GLY    68       7.944  21.108 159.698  1.00 34.05           N  
ATOM    467  CA  GLY    68       8.365  19.888 160.351  1.00 33.14           C  
ATOM    468  C   GLY    68       8.839  20.106 161.776  1.00 33.00           C  
ATOM    469  O   GLY    68       8.451  19.368 162.690  1.00 31.77           O  
ATOM    470  N   LEU    69       9.685  21.111 161.967  1.00 31.47           N  
ATOM    471  CA  LEU    69      10.206  21.409 163.290  1.00 32.26           C  
ATOM    472  C   LEU    69       9.049  21.904 164.167  1.00 33.07           C  
ATOM    473  O   LEU    69       8.747  21.322 165.202  1.00 33.37           O  
ATOM    474  CB  LEU    69      11.316  22.469 163.199  1.00 30.74           C  
ATOM    475  CG  LEU    69      11.850  23.000 164.535  1.00 32.20           C  
ATOM    476  CD1 LEU    69      12.571  21.903 165.298  1.00 32.82           C  
ATOM    477  CD2 LEU    69      12.786  24.161 164.273  1.00 29.97           C  
ATOM    478  N   VAL    70       8.404  22.979 163.737  1.00 33.16           N  
ATOM    479  CA  VAL    70       7.270  23.553 164.456  1.00 34.67           C  
ATOM    480  C   VAL    70       6.188  22.511 164.772  1.00 34.31           C  
ATOM    481  O   VAL    70       5.713  22.433 165.910  1.00 33.10           O  
ATOM    482  CB  VAL    70       6.641  24.707 163.632  1.00 35.05           C  
ATOM    483  CG1 VAL    70       5.295  25.134 164.236  1.00 37.65           C  
ATOM    484  CG2 VAL    70       7.594  25.883 163.595  1.00 33.13           C  
ATOM    485  N   GLY    71       5.818  21.730 163.755  1.00 32.90           N  
ATOM    486  CA  GLY    71       4.791  20.711 163.886  1.00 30.68           C  
ATOM    487  C   GLY    71       5.058  19.658 164.935  1.00 30.85           C  
ATOM    488  O   GLY    71       4.128  19.144 165.564  1.00 31.53           O  
ATOM    489  N   LEU    72       6.329  19.312 165.101  1.00 29.51           N  
ATOM    490  CA  LEU    72       6.718  18.310 166.080  1.00 30.07           C  
ATOM    491  C   LEU    72       6.456  18.822 167.497  1.00 28.95           C  
ATOM    492  O   LEU    72       6.056  18.058 168.379  1.00 29.63           O  
ATOM    493  CB  LEU    72       8.199  17.931 165.905  1.00 28.25           C  
ATOM    494  CG  LEU    72       8.495  17.019 164.697  1.00 28.77           C  
ATOM    495  CD1 LEU    72      10.006  16.853 164.530  1.00 31.04           C  
ATOM    496  CD2 LEU    72       7.842  15.648 164.901  1.00 27.33           C  
ATOM    497  N   TYR    73       6.689  20.111 167.721  1.00 29.65           N  
ATOM    498  CA  TYR    73       6.457  20.703 169.041  1.00 29.58           C  
ATOM    499  C   TYR    73       4.964  20.741 169.333  1.00 28.26           C  
ATOM    500  O   TYR    73       4.531  20.474 170.441  1.00 29.39           O  
ATOM    501  CB  TYR    73       7.009  22.121 169.087  1.00 29.72           C  
ATOM    502  CG  TYR    73       8.499  22.183 169.239  1.00 29.82           C  
ATOM    503  CD1 TYR    73       9.111  21.787 170.432  1.00 29.49           C  
ATOM    504  CD2 TYR    73       9.299  22.677 168.210  1.00 29.76           C  
ATOM    505  CE1 TYR    73      10.485  21.890 170.597  1.00 30.20           C  
ATOM    506  CE2 TYR    73      10.678  22.785 168.362  1.00 28.61           C  
ATOM    507  CZ  TYR    73      11.261  22.396 169.553  1.00 29.90           C  
ATOM    508  OH  TYR    73      12.613  22.544 169.717  1.00 35.40           O  
ATOM    509  N   ILE    74       4.187  21.075 168.313  1.00 27.05           N  
ATOM    510  CA  ILE    74       2.742  21.150 168.431  1.00 26.50           C  
ATOM    511  C   ILE    74       2.135  19.761 168.633  1.00 26.41           C  
ATOM    512  O   ILE    74       1.286  19.576 169.502  1.00 28.29           O  
ATOM    513  CB  ILE    74       2.133  21.843 167.173  1.00 25.58           C  
ATOM    514  CG1 ILE    74       2.499  23.330 167.185  1.00 23.49           C  
ATOM    515  CG2 ILE    74       0.621  21.655 167.133  1.00 22.85           C  
ATOM    516  CD1 ILE    74       1.908  24.129 166.028  1.00 28.06           C  
ATOM    517  N   LEU    75       2.578  18.785 167.838  1.00 29.11           N  
ATOM    518  CA  LEU    75       2.070  17.417 167.943  1.00 31.04           C  
ATOM    519  C   LEU    75       2.324  16.801 169.317  1.00 31.90           C  
ATOM    520  O   LEU    75       1.556  15.959 169.776  1.00 32.45           O  
ATOM    521  CB  LEU    75       2.669  16.541 166.827  1.00 29.40           C  
ATOM    522  CG  LEU    75       2.073  16.841 165.443  1.00 32.38           C  
ATOM    523  CD1 LEU    75       2.908  16.176 164.343  1.00 30.38           C  
ATOM    524  CD2 LEU    75       0.623  16.352 165.404  1.00 29.98           C  
ATOM    525  N   ASN    76       3.395  17.230 169.975  1.00 33.41           N  
ATOM    526  CA  ASN    76       3.712  16.733 171.314  1.00 35.17           C  
ATOM    527  C   ASN    76       2.572  17.013 172.296  1.00 35.09           C  
ATOM    528  O   ASN    76       2.253  16.169 173.134  1.00 36.99           O  
ATOM    529  CB  ASN    76       4.985  17.396 171.838  1.00 34.72           C  
ATOM    530  CG  ASN    76       6.245  16.662 171.424  1.00 39.54           C  
ATOM    531  OD1 ASN    76       7.342  17.238 171.396  1.00 43.81           O  
ATOM    532  ND2 ASN    76       6.101  15.382 171.115  1.00 43.80           N  
ATOM    533  N   GLY    77       1.956  18.193 172.195  1.00 32.65           N  
ATOM    534  CA  GLY    77       0.886  18.548 173.123  1.00 31.47           C  
ATOM    535  C   GLY    77      -0.552  18.330 172.695  1.00 32.40           C  
ATOM    536  O   GLY    77      -1.423  18.051 173.515  1.00 32.95           O  
ATOM    537  N   LEU    78      -0.793  18.459 171.402  1.00 31.49           N  
ATOM    538  CA  LEU    78      -2.120  18.294 170.822  1.00 32.19           C  
ATOM    539  C   LEU    78      -2.823  16.975 171.191  1.00 32.44           C  
ATOM    540  O   LEU    78      -2.192  15.920 171.231  1.00 33.08           O  
ATOM    541  CB  LEU    78      -2.002  18.403 169.302  1.00 29.81           C  
ATOM    542  CG  LEU    78      -2.898  19.317 168.462  1.00 36.01           C  
ATOM    543  CD1 LEU    78      -3.015  20.694 169.104  1.00 31.57           C  
ATOM    544  CD2 LEU    78      -2.310  19.420 167.051  1.00 33.99           C  
ATOM    545  N   ALA    79      -4.125  17.038 171.467  1.00 32.64           N  
ATOM    546  CA  ALA    79      -4.892  15.832 171.782  1.00 34.44           C  
ATOM    547  C   ALA    79      -4.895  14.941 170.513  1.00 36.11           C  
ATOM    548  O   ALA    79      -4.945  15.436 169.369  1.00 34.62           O  
ATOM    549  CB  ALA    79      -6.313  16.202 172.177  1.00 33.20           C  
ATOM    550  N   ASP    80      -4.855  13.626 170.720  1.00 37.28           N  
ATOM    551  CA  ASP    80      -4.807  12.657 169.619  1.00 38.96           C  
ATOM    552  C   ASP    80      -5.900  12.729 168.569  1.00 39.23           C  
ATOM    553  O   ASP    80      -5.662  12.390 167.403  1.00 40.09           O  
ATOM    554  CB  ASP    80      -4.733  11.229 170.168  1.00 39.60           C  
ATOM    555  CG  ASP    80      -3.476  10.985 170.982  1.00 42.87           C  
ATOM    556  OD1 ASP    80      -2.538  11.801 170.863  1.00 44.38           O  
ATOM    557  OD2 ASP    80      -3.422   9.972 171.723  1.00 45.18           O  
ATOM    558  N   ASN    81      -7.082  13.184 168.970  1.00 39.54           N  
ATOM    559  CA  ASN    81      -8.204  13.278 168.047  1.00 39.87           C  
ATOM    560  C   ASN    81      -8.299  14.609 167.305  1.00 39.74           C  
ATOM    561  O   ASN    81      -9.394  15.121 167.052  1.00 39.36           O  
ATOM    562  CB  ASN    81      -9.514  12.983 168.783  1.00 41.88           C  
ATOM    563  CG  ASN    81      -9.823  13.994 169.858  1.00 43.68           C  
ATOM    564  OD1 ASN    81      -8.920  14.588 170.441  1.00 47.17           O  
ATOM    565  ND2 ASN    81     -11.110  14.181 170.145  1.00 46.32           N  
ATOM    566  N   THR    82      -7.140  15.166 166.966  1.00 38.30           N  
ATOM    567  CA  THR    82      -7.066  16.420 166.219  1.00 36.46           C  
ATOM    568  C   THR    82      -5.965  16.231 165.179  1.00 37.02           C  
ATOM    569  O   THR    82      -5.215  15.253 165.228  1.00 35.72           O  
ATOM    570  CB  THR    82      -6.673  17.620 167.113  1.00 36.23           C  
ATOM    571  OG1 THR    82      -5.346  17.421 167.621  1.00 36.98           O  
ATOM    572  CG2 THR    82      -7.648  17.775 168.276  1.00 32.89           C  
ATOM    573  N   THR    83      -5.870  17.152 164.229  1.00 35.99           N  
ATOM    574  CA  THR    83      -4.833  17.056 163.204  1.00 36.94           C  
ATOM    575  C   THR    83      -3.979  18.323 163.161  1.00 35.17           C  
ATOM    576  O   THR    83      -4.354  19.372 163.704  1.00 34.96           O  
ATOM    577  CB  THR    83      -5.419  16.869 161.772  1.00 36.92           C  
ATOM    578  OG1 THR    83      -6.172  18.035 161.406  1.00 39.44           O  
ATOM    579  CG2 THR    83      -6.322  15.639 161.695  1.00 37.40           C  
ATOM    580  N   LEU    84      -2.814  18.214 162.535  1.00 33.33           N  
ATOM    581  CA  LEU    84      -1.956  19.373 162.347  1.00 32.12           C  
ATOM    582  C   LEU    84      -2.042  19.650 160.851  1.00 31.40           C  
ATOM    583  O   LEU    84      -1.809  18.764 160.022  1.00 32.33           O  
ATOM    584  CB  LEU    84      -0.491  19.090 162.727  1.00 32.68           C  
ATOM    585  CG  LEU    84       0.523  20.154 162.264  1.00 29.79           C  
ATOM    586  CD1 LEU    84       0.307  21.474 163.009  1.00 30.01           C  
ATOM    587  CD2 LEU    84       1.929  19.629 162.515  1.00 28.22           C  
ATOM    588  N   THR    85      -2.406  20.875 160.501  1.00 32.14           N  
ATOM    589  CA  THR    85      -2.507  21.273 159.104  1.00 30.98           C  
ATOM    590  C   THR    85      -1.329  22.197 158.812  1.00 31.89           C  
ATOM    591  O   THR    85      -1.208  23.272 159.401  1.00 32.68           O  
ATOM    592  CB  THR    85      -3.837  22.004 158.831  1.00 30.16           C  
ATOM    593  OG1 THR    85      -4.924  21.091 159.026  1.00 30.62           O  
ATOM    594  CG2 THR    85      -3.875  22.553 157.416  1.00 30.92           C  
ATOM    595  N   CYS    86      -0.458  21.762 157.906  1.00 32.18           N  
ATOM    596  CA  CYS    86       0.714  22.537 157.518  1.00 31.91           C  
ATOM    597  C   CYS    86       0.448  23.205 156.180  1.00 32.73           C  
ATOM    598  O   CYS    86      -0.146  22.612 155.283  1.00 33.43           O  
ATOM    599  CB  CYS    86       1.939  21.633 157.398  1.00 31.46           C  
ATOM    600  SG  CYS    86       2.309  20.684 158.888  1.00 30.56           S  
ATOM    601  N   ILE    87       0.900  24.445 156.047  1.00 32.21           N  
ATOM    602  CA  ILE    87       0.681  25.199 154.820  1.00 32.24           C  
ATOM    603  C   ILE    87       1.921  25.904 154.279  1.00 34.38           C  
ATOM    604  O   ILE    87       2.488  26.779 154.948  1.00 35.36           O  
ATOM    605  CB  ILE    87      -0.392  26.294 155.018  1.00 31.54           C  
ATOM    606  CG1 ILE    87      -1.607  25.723 155.753  1.00 28.05           C  
ATOM    607  CG2 ILE    87      -0.785  26.889 153.665  1.00 28.77           C  
ATOM    608  CD1 ILE    87      -2.753  26.703 155.903  1.00 31.08           C  
ATOM    609  N   ASP    88       2.344  25.505 153.082  1.00 34.03           N  
ATOM    610  CA  ASP    88       3.466  26.138 152.400  1.00 34.37           C  
ATOM    611  C   ASP    88       3.368  25.786 150.906  1.00 33.50           C  
ATOM    612  O   ASP    88       2.976  24.679 150.548  1.00 33.15           O  
ATOM    613  CB  ASP    88       4.823  25.687 152.965  1.00 32.69           C  
ATOM    614  CG  ASP    88       5.983  26.521 152.414  1.00 32.83           C  
ATOM    615  OD1 ASP    88       6.150  27.677 152.852  1.00 33.51           O  
ATOM    616  OD2 ASP    88       6.707  26.028 151.526  1.00 31.22           O  
ATOM    617  N   PRO    89       3.705  26.738 150.021  1.00 35.06           N  
ATOM    618  CA  PRO    89       3.654  26.536 148.564  1.00 37.30           C  
ATOM    619  C   PRO    89       4.796  25.746 147.929  1.00 39.95           C  
ATOM    620  O   PRO    89       4.690  25.310 146.781  1.00 40.65           O  
ATOM    621  CB  PRO    89       3.600  27.962 148.019  1.00 36.50           C  
ATOM    622  CG  PRO    89       4.416  28.736 149.005  1.00 33.94           C  
ATOM    623  CD  PRO    89       4.032  28.139 150.356  1.00 35.74           C  
ATOM    624  N   GLU    90       5.882  25.561 148.672  1.00 40.63           N  
ATOM    625  CA  GLU    90       7.049  24.865 148.164  1.00 41.49           C  
ATOM    626  C   GLU    90       6.934  23.361 148.357  1.00 41.43           C  
ATOM    627  O   GLU    90       6.688  22.892 149.464  1.00 42.37           O  
ATOM    628  CB  GLU    90       8.290  25.445 148.855  1.00 42.68           C  
ATOM    629  CG  GLU    90       9.148  26.359 147.968  1.00 47.20           C  
ATOM    630  CD  GLU    90       8.355  27.215 146.988  1.00 50.57           C  
ATOM    631  OE1 GLU    90       7.985  28.356 147.335  1.00 54.15           O  
ATOM    632  OE2 GLU    90       8.093  26.733 145.867  1.00 51.33           O  
ATOM    633  N   SER    91       7.118  22.606 147.277  1.00 40.04           N  
ATOM    634  CA  SER    91       6.974  21.159 147.346  1.00 40.28           C  
ATOM    635  C   SER    91       8.046  20.403 148.106  1.00 39.22           C  
ATOM    636  O   SER    91       7.757  19.360 148.698  1.00 38.91           O  
ATOM    637  CB  SER    91       6.795  20.574 145.938  1.00 40.80           C  
ATOM    638  OG  SER    91       7.828  20.986 145.076  1.00 47.75           O  
ATOM    639  N   GLU    92       9.273  20.917 148.105  1.00 38.40           N  
ATOM    640  CA  GLU    92      10.328  20.254 148.855  1.00 37.79           C  
ATOM    641  C   GLU    92      10.055  20.488 150.350  1.00 35.86           C  
ATOM    642  O   GLU    92      10.494  19.697 151.190  1.00 34.88           O  
ATOM    643  CB  GLU    92      11.724  20.777 148.458  1.00 37.99           C  
ATOM    644  CG  GLU    92      12.018  22.231 148.746  1.00 38.66           C  
ATOM    645  CD  GLU    92      13.401  22.629 148.226  1.00 39.16           C  
ATOM    646  OE1 GLU    92      13.730  23.832 148.234  1.00 44.47           O  
ATOM    647  OE2 GLU    92      14.165  21.728 147.819  1.00 39.56           O  
ATOM    648  N   HIS    93       9.339  21.565 150.689  1.00 34.44           N  
ATOM    649  CA  HIS    93       8.997  21.824 152.087  1.00 34.73           C  
ATOM    650  C   HIS    93       7.952  20.787 152.502  1.00 36.07           C  
ATOM    651  O   HIS    93       7.934  20.348 153.652  1.00 37.25           O  
ATOM    652  CB  HIS    93       8.472  23.258 152.258  1.00 34.41           C  
ATOM    653  CG  HIS    93       9.545  24.294 152.134  1.00 32.27           C  
ATOM    654  ND1 HIS    93       9.280  25.639 152.016  1.00 30.35           N  
ATOM    655  CD2 HIS    93      10.892  24.171 152.097  1.00 24.41           C  
ATOM    656  CE1 HIS    93      10.418  26.300 151.907  1.00 27.66           C  
ATOM    657  NE2 HIS    93      11.411  25.432 151.952  1.00 27.44           N  
ATOM    658  N   GLN    94       7.085  20.385 151.569  1.00 36.34           N  
ATOM    659  CA  GLN    94       6.070  19.368 151.863  1.00 36.30           C  
ATOM    660  C   GLN    94       6.777  18.026 152.075  1.00 37.32           C  
ATOM    661  O   GLN    94       6.414  17.252 152.974  1.00 36.92           O  
ATOM    662  CB  GLN    94       5.061  19.248 150.715  1.00 36.05           C  
ATOM    663  CG  GLN    94       4.217  17.979 150.781  1.00 38.03           C  
ATOM    664  CD  GLN    94       2.981  18.054 149.912  1.00 41.92           C  
ATOM    665  OE1 GLN    94       3.067  18.249 148.695  1.00 43.15           O  
ATOM    666  NE2 GLN    94       1.815  17.904 150.534  1.00 42.69           N  
ATOM    667  N   ARG    95       7.783  17.749 151.242  1.00 37.73           N  
ATOM    668  CA  ARG    95       8.554  16.513 151.365  1.00 38.04           C  
ATOM    669  C   ARG    95       9.350  16.566 152.664  1.00 36.71           C  
ATOM    670  O   ARG    95       9.433  15.578 153.389  1.00 37.54           O  
ATOM    671  CB  ARG    95       9.522  16.343 150.190  1.00 37.76           C  
ATOM    672  CG  ARG    95       8.981  15.501 149.051  1.00 41.07           C  
ATOM    673  CD  ARG    95      10.112  14.864 148.251  1.00 41.47           C  
ATOM    674  NE  ARG    95      10.210  13.421 148.471  1.00 44.73           N  
ATOM    675  CZ  ARG    95      11.303  12.697 148.238  1.00 48.22           C  
ATOM    676  NH1 ARG    95      12.405  13.277 147.777  1.00 43.75           N  
ATOM    677  NH2 ARG    95      11.300  11.388 148.466  1.00 50.29           N  
ATOM    678  N   GLN    96       9.929  17.729 152.950  1.00 36.06           N  
ATOM    679  CA  GLN    96      10.728  17.925 154.160  1.00 36.78           C  
ATOM    680  C   GLN    96       9.918  17.667 155.432  1.00 37.11           C  
ATOM    681  O   GLN    96      10.404  17.022 156.363  1.00 38.28           O  
ATOM    682  CB  GLN    96      11.321  19.352 154.177  1.00 36.09           C  
ATOM    683  CG  GLN    96      12.559  19.528 153.281  1.00 35.76           C  
ATOM    684  CD  GLN    96      12.876  20.987 152.938  1.00 37.87           C  
ATOM    685  OE1 GLN    96      12.553  21.902 153.695  1.00 37.55           O  
ATOM    686  NE2 GLN    96      13.521  21.202 151.787  1.00 37.71           N  
ATOM    687  N   ALA    97       8.685  18.164 155.459  1.00 36.86           N  
ATOM    688  CA  ALA    97       7.808  18.008 156.618  1.00 38.73           C  
ATOM    689  C   ALA    97       7.274  16.589 156.803  1.00 39.18           C  
ATOM    690  O   ALA    97       7.426  16.003 157.871  1.00 40.70           O  
ATOM    691  CB  ALA    97       6.642  18.998 156.527  1.00 38.41           C  
ATOM    692  N   LYS    98       6.643  16.043 155.767  1.00 41.29           N  
ATOM    693  CA  LYS    98       6.092  14.691 155.829  1.00 42.21           C  
ATOM    694  C   LYS    98       7.160  13.660 156.207  1.00 41.35           C  
ATOM    695  O   LYS    98       6.868  12.667 156.882  1.00 41.72           O  
ATOM    696  CB  LYS    98       5.452  14.320 154.489  1.00 42.60           C  
ATOM    697  CG  LYS    98       4.132  15.045 154.207  1.00 46.99           C  
ATOM    698  CD  LYS    98       3.701  14.826 152.757  1.00 50.33           C  
ATOM    699  CE  LYS    98       2.273  14.316 152.636  1.00 52.72           C  
ATOM    700  NZ  LYS    98       1.300  15.394 152.311  1.00 55.75           N  
ATOM    701  N   ALA    99       8.395  13.899 155.776  1.00 40.82           N  
ATOM    702  CA  ALA    99       9.501  13.005 156.096  1.00 40.65           C  
ATOM    703  C   ALA    99       9.746  13.051 157.612  1.00 41.49           C  
ATOM    704  O   ALA    99       9.763  12.015 158.279  1.00 42.92           O  
ATOM    705  CB  ALA    99      10.761  13.443 155.353  1.00 39.72           C  
ATOM    706  N   LEU   100       9.944  14.253 158.155  1.00 41.47           N  
ATOM    707  CA  LEU   100      10.195  14.414 159.590  1.00 42.16           C  
ATOM    708  C   LEU   100       9.088  13.802 160.454  1.00 43.10           C  
ATOM    709  O   LEU   100       9.366  13.216 161.504  1.00 44.57           O  
ATOM    710  CB  LEU   100      10.390  15.899 159.931  1.00 40.19           C  
ATOM    711  CG  LEU   100      11.760  16.459 159.539  1.00 40.76           C  
ATOM    712  CD1 LEU   100      11.733  17.979 159.622  1.00 38.21           C  
ATOM    713  CD2 LEU   100      12.845  15.879 160.463  1.00 39.23           C  
ATOM    714  N   PHE   101       7.837  13.937 160.017  1.00 43.20           N  
ATOM    715  CA  PHE   101       6.726  13.365 160.764  1.00 42.25           C  
ATOM    716  C   PHE   101       6.823  11.845 160.643  1.00 44.41           C  
ATOM    717  O   PHE   101       6.658  11.123 161.621  1.00 43.24           O  
ATOM    718  CB  PHE   101       5.385  13.879 160.217  1.00 41.31           C  
ATOM    719  CG  PHE   101       5.197  15.367 160.365  1.00 39.00           C  
ATOM    720  CD1 PHE   101       5.665  16.033 161.502  1.00 34.66           C  
ATOM    721  CD2 PHE   101       4.571  16.105 159.369  1.00 36.49           C  
ATOM    722  CE1 PHE   101       5.495  17.412 161.645  1.00 34.60           C  
ATOM    723  CE2 PHE   101       4.399  17.484 159.500  1.00 34.58           C  
ATOM    724  CZ  PHE   101       4.870  18.142 160.633  1.00 32.21           C  
ATOM    725  N   ARG   102       7.102  11.360 159.435  1.00 46.41           N  
ATOM    726  CA  ARG   102       7.242   9.923 159.196  1.00 48.11           C  
ATOM    727  C   ARG   102       8.348   9.354 160.107  1.00 48.36           C  
ATOM    728  O   ARG   102       8.139   8.336 160.770  1.00 48.43           O  
ATOM    729  CB  ARG   102       7.627   9.660 157.741  1.00 49.29           C  
ATOM    730  CG  ARG   102       7.634   8.184 157.333  1.00 51.02           C  
ATOM    731  CD  ARG   102       8.792   7.853 156.388  1.00 53.05           C  
ATOM    732  NE  ARG   102       9.139   8.969 155.508  1.00 52.14           N  
ATOM    733  CZ  ARG   102       8.311   9.516 154.622  1.00 55.54           C  
ATOM    734  NH1 ARG   102       7.078   9.047 154.486  1.00 53.38           N  
ATOM    735  NH2 ARG   102       8.711  10.542 153.882  1.00 51.50           N  
ATOM    736  N   GLU   103       9.516  10.005 160.131  1.00 48.96           N  
ATOM    737  CA  GLU   103      10.645   9.551 160.943  1.00 49.81           C  
ATOM    738  C   GLU   103      10.291   9.567 162.426  1.00 50.89           C  
ATOM    739  O   GLU   103      10.596   8.606 163.141  1.00 50.34           O  
ATOM    740  CB  GLU   103      11.893  10.388 160.616  1.00 50.09           C  
ATOM    741  CG  GLU   103      12.643   9.818 159.415  1.00 51.67           C  
ATOM    742  CD  GLU   103      13.347  10.890 158.626  1.00 51.76           C  
ATOM    743  OE1 GLU   103      13.899  11.825 159.251  1.00 48.29           O  
ATOM    744  OE2 GLU   103      13.354  10.796 157.383  1.00 55.16           O  
ATOM    745  N   ALA   104       9.667  10.652 162.892  1.00 51.35           N  
ATOM    746  CA  ALA   104       9.177  10.675 164.265  1.00 52.00           C  
ATOM    747  C   ALA   104       8.091   9.565 164.126  1.00 52.43           C  
ATOM    748  O   ALA   104       7.679   9.211 163.007  1.00 53.80           O  
ATOM    749  CB  ALA   104       8.528  12.007 164.577  1.00 52.52           C  
ATOM    750  N   GLY   105       7.572   9.038 165.222  1.00 51.99           N  
ATOM    751  CA  GLY   105       6.611   7.951 165.088  1.00 52.42           C  
ATOM    752  C   GLY   105       5.192   8.281 164.726  1.00 51.41           C  
ATOM    753  O   GLY   105       4.281   7.504 165.013  1.00 52.46           O  
ATOM    754  N   TYR   106       5.022   9.381 164.007  1.00 49.01           N  
ATOM    755  CA  TYR   106       3.692   9.848 163.660  1.00 48.06           C  
ATOM    756  C   TYR   106       2.927   9.292 162.481  1.00 48.12           C  
ATOM    757  O   TYR   106       3.453   9.190 161.388  1.00 48.28           O  
ATOM    758  CB  TYR   106       3.704  11.371 163.567  1.00 46.71           C  
ATOM    759  CG  TYR   106       3.873  12.108 164.893  1.00 46.02           C  
ATOM    760  CD1 TYR   106       2.832  12.165 165.824  1.00 45.78           C  
ATOM    761  CD2 TYR   106       5.077  12.743 165.217  1.00 45.53           C  
ATOM    762  CE1 TYR   106       2.987  12.828 167.043  1.00 43.89           C  
ATOM    763  CE2 TYR   106       5.242  13.401 166.435  1.00 45.18           C  
ATOM    764  CZ  TYR   106       4.194  13.441 167.339  1.00 47.22           C  
ATOM    765  OH  TYR   106       4.358  14.096 168.537  1.00 44.15           O  
ATOM    766  N   SER   107       1.663   8.960 162.731  1.00 48.48           N  
ATOM    767  CA  SER   107       0.783   8.435 161.702  1.00 49.27           C  
ATOM    768  C   SER   107       0.425   9.539 160.706  1.00 49.37           C  
ATOM    769  O   SER   107       0.319  10.710 161.073  1.00 49.53           O  
ATOM    770  CB  SER   107      -0.491   7.870 162.342  1.00 49.50           C  
ATOM    771  OG  SER   107      -1.474   7.588 161.364  1.00 52.70           O  
ATOM    772  N   PRO   108       0.235   9.176 159.429  1.00 49.21           N  
ATOM    773  CA  PRO   108      -0.110  10.142 158.376  1.00 48.45           C  
ATOM    774  C   PRO   108      -1.477  10.785 158.603  1.00 47.09           C  
ATOM    775  O   PRO   108      -1.770  11.856 158.079  1.00 46.18           O  
ATOM    776  CB  PRO   108      -0.096   9.296 157.096  1.00 49.07           C  
ATOM    777  CG  PRO   108       0.786   8.137 157.438  1.00 48.53           C  
ATOM    778  CD  PRO   108       0.450   7.831 158.867  1.00 48.40           C  
ATOM    779  N   SER   109      -2.314  10.103 159.375  1.00 45.54           N  
ATOM    780  CA  SER   109      -3.663  10.569 159.685  1.00 44.50           C  
ATOM    781  C   SER   109      -3.706  11.769 160.631  1.00 43.25           C  
ATOM    782  O   SER   109      -4.730  12.445 160.743  1.00 42.75           O  
ATOM    783  CB  SER   109      -4.464   9.421 160.291  1.00 44.79           C  
ATOM    784  OG  SER   109      -3.645   8.662 161.166  1.00 45.92           O  
ATOM    785  N   ARG   110      -2.588  12.025 161.304  1.00 42.31           N  
ATOM    786  CA  ARG   110      -2.488  13.132 162.250  1.00 41.07           C  
ATOM    787  C   ARG   110      -2.082  14.447 161.587  1.00 40.37           C  
ATOM    788  O   ARG   110      -2.299  15.523 162.138  1.00 38.73           O  
ATOM    789  CB  ARG   110      -1.468  12.805 163.339  1.00 41.93           C  
ATOM    790  CG  ARG   110      -1.842  11.684 164.295  1.00 39.91           C  
ATOM    791  CD  ARG   110      -3.104  12.011 165.079  1.00 39.10           C  
ATOM    792  NE  ARG   110      -3.127  13.356 165.664  1.00 35.37           N  
ATOM    793  CZ  ARG   110      -2.421  13.741 166.723  1.00 36.20           C  
ATOM    794  NH1 ARG   110      -1.620  12.889 167.337  1.00 32.35           N  
ATOM    795  NH2 ARG   110      -2.556  14.974 167.196  1.00 34.00           N  
ATOM    796  N   VAL   111      -1.499  14.351 160.399  1.00 39.59           N  
ATOM    797  CA  VAL   111      -1.040  15.528 159.674  1.00 38.83           C  
ATOM    798  C   VAL   111      -1.701  15.708 158.309  1.00 38.15           C  
ATOM    799  O   VAL   111      -2.128  14.745 157.676  1.00 37.24           O  
ATOM    800  CB  VAL   111       0.491  15.488 159.473  1.00 38.00           C  
ATOM    801  CG1 VAL   111       0.929  16.615 158.551  1.00 42.01           C  
ATOM    802  CG2 VAL   111       1.206  15.614 160.820  1.00 38.16           C  
ATOM    803  N   ARG   112      -1.765  16.957 157.867  1.00 36.98           N  
ATOM    804  CA  ARG   112      -2.351  17.300 156.590  1.00 36.33           C  
ATOM    805  C   ARG   112      -1.513  18.435 156.001  1.00 35.66           C  
ATOM    806  O   ARG   112      -1.324  19.472 156.648  1.00 36.99           O  
ATOM    807  CB  ARG   112      -3.798  17.750 156.830  1.00 36.34           C  
ATOM    808  CG  ARG   112      -4.485  18.397 155.660  1.00 37.42           C  
ATOM    809  CD  ARG   112      -5.397  19.503 156.170  1.00 40.20           C  
ATOM    810  NE  ARG   112      -6.749  19.400 155.634  1.00 45.44           N  
ATOM    811  CZ  ARG   112      -7.756  20.191 155.991  1.00 48.74           C  
ATOM    812  NH1 ARG   112      -7.573  21.156 156.889  1.00 49.80           N  
ATOM    813  NH2 ARG   112      -8.947  20.016 155.443  1.00 49.68           N  
ATOM    814  N   PHE   113      -1.009  18.253 154.784  1.00 34.58           N  
ATOM    815  CA  PHE   113      -0.209  19.303 154.170  1.00 35.15           C  
ATOM    816  C   PHE   113      -0.932  19.949 152.991  1.00 35.07           C  
ATOM    817  O   PHE   113      -1.384  19.270 152.067  1.00 37.67           O  
ATOM    818  CB  PHE   113       1.151  18.766 153.708  1.00 34.40           C  
ATOM    819  CG  PHE   113       2.229  19.827 153.643  1.00 36.00           C  
ATOM    820  CD1 PHE   113       3.235  19.879 154.609  1.00 36.27           C  
ATOM    821  CD2 PHE   113       2.207  20.800 152.650  1.00 32.65           C  
ATOM    822  CE1 PHE   113       4.199  20.895 154.590  1.00 33.82           C  
ATOM    823  CE2 PHE   113       3.163  21.815 152.616  1.00 34.72           C  
ATOM    824  CZ  PHE   113       4.163  21.865 153.589  1.00 33.01           C  
ATOM    825  N   LEU   114      -1.054  21.268 153.029  1.00 35.24           N  
ATOM    826  CA  LEU   114      -1.704  21.989 151.942  1.00 35.75           C  
ATOM    827  C   LEU   114      -0.634  22.776 151.168  1.00 36.12           C  
ATOM    828  O   LEU   114      -0.129  23.802 151.642  1.00 33.29           O  
ATOM    829  CB  LEU   114      -2.781  22.950 152.484  1.00 35.98           C  
ATOM    830  CG  LEU   114      -3.800  22.374 153.479  1.00 35.98           C  
ATOM    831  CD1 LEU   114      -4.787  23.453 153.902  1.00 30.83           C  
ATOM    832  CD2 LEU   114      -4.537  21.206 152.840  1.00 37.70           C  
ATOM    833  N   LEU   115      -0.291  22.272 149.982  1.00 36.66           N  
ATOM    834  CA  LEU   115       0.698  22.896 149.101  1.00 36.42           C  
ATOM    835  C   LEU   115       0.067  24.159 148.511  1.00 37.94           C  
ATOM    836  O   LEU   115      -0.413  24.156 147.371  1.00 37.92           O  
ATOM    837  CB  LEU   115       1.058  21.957 147.946  1.00 36.58           C  
ATOM    838  CG  LEU   115       2.472  21.414 147.736  1.00 37.22           C  
ATOM    839  CD1 LEU   115       2.652  21.168 146.230  1.00 32.33           C  
ATOM    840  CD2 LEU   115       3.537  22.398 148.235  1.00 31.00           C  
ATOM    841  N   SER   116       0.089  25.248 149.270  1.00 38.17           N  
ATOM    842  CA  SER   116      -0.526  26.495 148.825  1.00 39.28           C  
ATOM    843  C   SER   116       0.103  27.704 149.496  1.00 41.12           C  
ATOM    844  O   SER   116       0.891  27.567 150.442  1.00 40.46           O  
ATOM    845  CB  SER   116      -2.007  26.513 149.183  1.00 40.19           C  
ATOM    846  OG  SER   116      -2.470  25.254 149.656  1.00 42.22           O  
ATOM    847  N   ARG   117      -0.255  28.884 149.007  1.00 41.80           N  
ATOM    848  CA  ARG   117       0.210  30.105 149.614  1.00 42.60           C  
ATOM    849  C   ARG   117      -0.825  30.243 150.739  1.00 40.98           C  
ATOM    850  O   ARG   117      -2.039  30.078 150.529  1.00 41.28           O  
ATOM    851  CB  ARG   117       0.122  31.272 148.622  1.00 43.51           C  
ATOM    852  CG  ARG   117       0.859  30.961 147.339  1.00 49.76           C  
ATOM    853  CD  ARG   117       0.563  31.978 146.265  1.00 60.03           C  
ATOM    854  NE  ARG   117       0.982  33.320 146.662  1.00 67.32           N  
ATOM    855  CZ  ARG   117       1.017  34.367 145.842  1.00 67.66           C  
ATOM    856  NH1 ARG   117       0.659  34.231 144.571  1.00 67.92           N  
ATOM    857  NH2 ARG   117       1.413  35.550 146.293  1.00 68.00           N  
ATOM    858  N   PRO   118      -0.364  30.529 151.957  1.00 41.33           N  
ATOM    859  CA  PRO   118      -1.223  30.686 153.140  1.00 40.61           C  
ATOM    860  C   PRO   118      -2.504  31.479 152.927  1.00 39.64           C  
ATOM    861  O   PRO   118      -3.607  30.990 153.181  1.00 39.78           O  
ATOM    862  CB  PRO   118      -0.316  31.394 154.142  1.00 40.65           C  
ATOM    863  CG  PRO   118       1.041  30.954 153.775  1.00 41.68           C  
ATOM    864  CD  PRO   118       1.033  30.880 152.272  1.00 40.50           C  
ATOM    865  N   LEU   119      -2.343  32.715 152.460  1.00 41.33           N  
ATOM    866  CA  LEU   119      -3.471  33.595 152.279  1.00 43.36           C  
ATOM    867  C   LEU   119      -4.460  33.221 151.192  1.00 43.28           C  
ATOM    868  O   LEU   119      -5.565  33.763 151.135  1.00 43.18           O  
ATOM    869  CB  LEU   119      -2.962  35.032 152.110  1.00 44.68           C  
ATOM    870  CG  LEU   119      -2.149  35.568 153.306  1.00 47.79           C  
ATOM    871  CD1 LEU   119      -1.613  36.954 152.971  1.00 48.36           C  
ATOM    872  CD2 LEU   119      -3.017  35.620 154.562  1.00 48.43           C  
ATOM    873  N   ASP   120      -4.069  32.285 150.344  1.00 42.99           N  
ATOM    874  CA  ASP   120      -4.950  31.832 149.284  1.00 43.56           C  
ATOM    875  C   ASP   120      -5.859  30.709 149.778  1.00 42.46           C  
ATOM    876  O   ASP   120      -7.049  30.704 149.496  1.00 42.73           O  
ATOM    877  CB  ASP   120      -4.136  31.320 148.091  1.00 45.08           C  
ATOM    878  CG  ASP   120      -3.630  32.435 147.194  1.00 47.02           C  
ATOM    879  OD1 ASP   120      -2.502  32.322 146.665  1.00 52.57           O  
ATOM    880  OD2 ASP   120      -4.368  33.418 147.002  1.00 54.08           O  
ATOM    881  N   VAL   121      -5.295  29.775 150.541  1.00 41.31           N  
ATOM    882  CA  VAL   121      -6.037  28.611 151.013  1.00 39.94           C  
ATOM    883  C   VAL   121      -6.808  28.725 152.327  1.00 40.84           C  
ATOM    884  O   VAL   121      -7.690  27.907 152.604  1.00 38.80           O  
ATOM    885  CB  VAL   121      -5.094  27.400 151.086  1.00 39.13           C  
ATOM    886  CG1 VAL   121      -4.188  27.521 152.303  1.00 37.68           C  
ATOM    887  CG2 VAL   121      -5.882  26.106 151.110  1.00 37.94           C  
ATOM    888  N   MET   122      -6.475  29.722 153.134  1.00 42.29           N  
ATOM    889  CA  MET   122      -7.166  29.906 154.395  1.00 43.80           C  
ATOM    890  C   MET   122      -8.616  30.270 154.106  1.00 44.00           C  
ATOM    891  O   MET   122      -9.498  30.116 154.952  1.00 42.06           O  
ATOM    892  CB  MET   122      -6.466  30.986 155.225  1.00 44.01           C  
ATOM    893  CG  MET   122      -5.380  30.396 156.117  1.00 49.56           C  
ATOM    894  SD  MET   122      -4.119  31.725 156.693  1.00 61.27          SE  
ATOM    895  CE  MET   122      -2.501  30.840 156.177  1.00 61.36           C  
ATOM    896  N   SER   123      -8.852  30.740 152.885  1.00 45.14           N  
ATOM    897  CA  SER   123     -10.192  31.101 152.429  1.00 44.45           C  
ATOM    898  C   SER   123     -11.012  29.812 152.270  1.00 42.51           C  
ATOM    899  O   SER   123     -12.239  29.841 152.214  1.00 42.47           O  
ATOM    900  CB  SER   123     -10.104  31.792 151.072  1.00 44.03           C  
ATOM    901  OG  SER   123     -11.332  32.400 150.721  1.00 50.55           O  
ATOM    902  N   ARG   124     -10.320  28.682 152.204  1.00 39.98           N  
ATOM    903  CA  ARG   124     -10.938  27.375 151.993  1.00 39.77           C  
ATOM    904  C   ARG   124     -11.079  26.481 153.218  1.00 39.26           C  
ATOM    905  O   ARG   124     -11.430  25.302 153.091  1.00 38.53           O  
ATOM    906  CB  ARG   124     -10.144  26.624 150.927  1.00 39.41           C  
ATOM    907  CG  ARG   124     -10.516  26.921 149.478  1.00 39.67           C  
ATOM    908  CD  ARG   124     -10.214  28.346 149.054  1.00 34.87           C  
ATOM    909  NE  ARG   124     -10.183  28.446 147.599  1.00 37.32           N  
ATOM    910  CZ  ARG   124     -10.506  29.535 146.908  1.00 38.08           C  
ATOM    911  NH1 ARG   124     -10.895  30.633 147.538  1.00 40.47           N  
ATOM    912  NH2 ARG   124     -10.456  29.519 145.584  1.00 35.95           N  
ATOM    913  N   LEU   125     -10.807  27.038 154.392  1.00 38.20           N  
ATOM    914  CA  LEU   125     -10.896  26.266 155.616  1.00 37.17           C  
ATOM    915  C   LEU   125     -12.133  26.675 156.405  1.00 35.40           C  
ATOM    916  O   LEU   125     -12.668  27.759 156.217  1.00 35.38           O  
ATOM    917  CB  LEU   125      -9.612  26.457 156.446  1.00 36.51           C  
ATOM    918  CG  LEU   125      -8.289  26.098 155.744  1.00 34.19           C  
ATOM    919  CD1 LEU   125      -7.122  26.588 156.596  1.00 35.46           C  
ATOM    920  CD2 LEU   125      -8.189  24.592 155.505  1.00 33.35           C  
ATOM    921  N   ALA   126     -12.583  25.798 157.291  1.00 36.45           N  
ATOM    922  CA  ALA   126     -13.782  26.061 158.076  1.00 37.46           C  
ATOM    923  C   ALA   126     -13.588  27.043 159.223  1.00 37.94           C  
ATOM    924  O   ALA   126     -12.660  26.912 160.014  1.00 36.91           O  
ATOM    925  CB  ALA   126     -14.351  24.735 158.604  1.00 38.14           C  
ATOM    926  N   ASN   127     -14.479  28.026 159.299  1.00 37.51           N  
ATOM    927  CA  ASN   127     -14.436  29.028 160.357  1.00 39.25           C  
ATOM    928  C   ASN   127     -14.698  28.410 161.736  1.00 38.25           C  
ATOM    929  O   ASN   127     -15.415  27.410 161.853  1.00 37.89           O  
ATOM    930  CB  ASN   127     -15.499  30.104 160.130  1.00 38.20           C  
ATOM    931  CG  ASN   127     -15.109  31.115 159.077  1.00 45.54           C  
ATOM    932  OD1 ASN   127     -13.925  31.365 158.846  1.00 47.80           O  
ATOM    933  ND2 ASN   127     -16.114  31.728 158.440  1.00 50.71           N  
ATOM    934  N   ASP   128     -14.100  28.996 162.773  1.00 39.07           N  
ATOM    935  CA  ASP   128     -14.333  28.545 164.147  1.00 39.00           C  
ATOM    936  C   ASP   128     -14.037  27.068 164.369  1.00 37.42           C  
ATOM    937  O   ASP   128     -14.761  26.386 165.099  1.00 36.97           O  
ATOM    938  CB  ASP   128     -15.802  28.840 164.494  1.00 40.06           C  
ATOM    939  CG  ASP   128     -16.097  28.760 165.988  1.00 42.55           C  
ATOM    940  OD1 ASP   128     -15.284  29.278 166.781  1.00 42.74           O  
ATOM    941  OD2 ASP   128     -17.152  28.195 166.370  1.00 38.11           O  
ATOM    942  N   SER   129     -12.967  26.573 163.763  1.00 35.37           N  
ATOM    943  CA  SER   129     -12.636  25.160 163.890  1.00 34.54           C  
ATOM    944  C   SER   129     -11.245  24.857 164.426  1.00 31.43           C  
ATOM    945  O   SER   129     -10.918  23.699 164.679  1.00 32.63           O  
ATOM    946  CB  SER   129     -12.782  24.477 162.536  1.00 35.03           C  
ATOM    947  OG  SER   129     -14.099  24.034 162.294  1.00 37.23           O  
ATOM    948  N   TYR   130     -10.431  25.884 164.620  1.00 29.68           N  
ATOM    949  CA  TYR   130      -9.071  25.668 165.066  1.00 28.67           C  
ATOM    950  C   TYR   130      -8.751  26.269 166.423  1.00 28.72           C  
ATOM    951  O   TYR   130      -9.163  27.382 166.738  1.00 29.68           O  
ATOM    952  CB  TYR   130      -8.121  26.196 163.986  1.00 28.26           C  
ATOM    953  CG  TYR   130      -8.274  25.464 162.664  1.00 29.26           C  
ATOM    954  CD1 TYR   130      -7.600  24.263 162.430  1.00 29.35           C  
ATOM    955  CD2 TYR   130      -9.172  25.915 161.692  1.00 28.46           C  
ATOM    956  CE1 TYR   130      -7.803  23.531 161.259  1.00 26.56           C  
ATOM    957  CE2 TYR   130      -9.386  25.194 160.518  1.00 29.12           C  
ATOM    958  CZ  TYR   130      -8.700  23.994 160.313  1.00 29.08           C  
ATOM    959  OH  TYR   130      -8.905  23.276 159.154  1.00 27.26           O  
ATOM    960  N   GLN   131      -7.995  25.514 167.214  1.00 28.03           N  
ATOM    961  CA  GLN   131      -7.601  25.922 168.557  1.00 27.77           C  
ATOM    962  C   GLN   131      -6.230  26.599 168.607  1.00 27.85           C  
ATOM    963  O   GLN   131      -5.884  27.249 169.598  1.00 29.71           O  
ATOM    964  CB  GLN   131      -7.569  24.700 169.472  1.00 26.77           C  
ATOM    965  CG  GLN   131      -6.362  23.790 169.188  1.00 26.44           C  
ATOM    966  CD  GLN   131      -6.491  22.396 169.781  1.00 24.98           C  
ATOM    967  OE1 GLN   131      -5.943  22.106 170.843  1.00 24.78           O  
ATOM    968  NE2 GLN   131      -7.231  21.533 169.101  1.00 20.94           N  
ATOM    969  N   LEU   132      -5.446  26.448 167.546  1.00 27.47           N  
ATOM    970  CA  LEU   132      -4.105  27.023 167.532  1.00 26.57           C  
ATOM    971  C   LEU   132      -3.590  27.236 166.115  1.00 27.51           C  
ATOM    972  O   LEU   132      -3.679  26.349 165.264  1.00 29.60           O  
ATOM    973  CB  LEU   132      -3.137  26.104 168.301  1.00 25.75           C  
ATOM    974  CG  LEU   132      -1.629  26.415 168.296  1.00 29.37           C  
ATOM    975  CD1 LEU   132      -1.363  27.685 169.099  1.00 27.98           C  
ATOM    976  CD2 LEU   132      -0.842  25.243 168.885  1.00 27.03           C  
ATOM    977  N   VAL   133      -3.055  28.424 165.864  1.00 26.58           N  
ATOM    978  CA  VAL   133      -2.498  28.739 164.566  1.00 25.15           C  
ATOM    979  C   VAL   133      -1.139  29.410 164.763  1.00 26.35           C  
ATOM    980  O   VAL   133      -1.017  30.422 165.456  1.00 26.47           O  
ATOM    981  CB  VAL   133      -3.439  29.670 163.752  1.00 25.87           C  
ATOM    982  CG1 VAL   133      -2.807  30.010 162.398  1.00 25.01           C  
ATOM    983  CG2 VAL   133      -4.791  28.987 163.550  1.00 20.36           C  
ATOM    984  N   PHE   134      -0.113  28.818 164.169  1.00 25.32           N  
ATOM    985  CA  PHE   134       1.234  29.356 164.232  1.00 26.86           C  
ATOM    986  C   PHE   134       1.555  29.901 162.847  1.00 27.34           C  
ATOM    987  O   PHE   134       1.374  29.218 161.827  1.00 28.20           O  
ATOM    988  CB  PHE   134       2.266  28.275 164.582  1.00 26.10           C  
ATOM    989  CG  PHE   134       3.687  28.747 164.450  1.00 25.49           C  
ATOM    990  CD1 PHE   134       4.311  29.429 165.490  1.00 24.26           C  
ATOM    991  CD2 PHE   134       4.389  28.539 163.263  1.00 29.08           C  
ATOM    992  CE1 PHE   134       5.619  29.914 165.342  1.00 28.36           C  
ATOM    993  CE2 PHE   134       5.692  29.020 163.101  1.00 32.22           C  
ATOM    994  CZ  PHE   134       6.312  29.704 164.146  1.00 32.15           C  
ATOM    995  N   GLY   135       2.023  31.142 162.815  1.00 28.79           N  
ATOM    996  CA  GLY   135       2.375  31.753 161.551  1.00 28.63           C  
ATOM    997  C   GLY   135       3.800  32.285 161.495  1.00 29.23           C  
ATOM    998  O   GLY   135       4.256  32.988 162.400  1.00 26.26           O  
ATOM    999  N   GLN   136       4.525  31.894 160.454  1.00 30.13           N  
ATOM   1000  CA  GLN   136       5.876  32.386 160.239  1.00 33.40           C  
ATOM   1001  C   GLN   136       5.803  33.029 158.850  1.00 35.44           C  
ATOM   1002  O   GLN   136       5.966  32.367 157.820  1.00 36.80           O  
ATOM   1003  CB  GLN   136       6.918  31.255 160.234  1.00 32.41           C  
ATOM   1004  CG  GLN   136       8.323  31.769 159.955  1.00 33.06           C  
ATOM   1005  CD  GLN   136       9.078  32.162 161.210  1.00 33.64           C  
ATOM   1006  OE1 GLN   136       9.444  33.324 161.394  1.00 35.68           O  
ATOM   1007  NE2 GLN   136       9.320  31.192 162.080  1.00 29.90           N  
ATOM   1008  N   VAL   137       5.562  34.331 158.825  1.00 36.19           N  
ATOM   1009  CA  VAL   137       5.419  35.064 157.572  1.00 38.42           C  
ATOM   1010  C   VAL   137       6.248  36.342 157.564  1.00 41.25           C  
ATOM   1011  O   VAL   137       6.896  36.680 158.560  1.00 41.64           O  
ATOM   1012  CB  VAL   137       3.930  35.432 157.329  1.00 36.88           C  
ATOM   1013  CG1 VAL   137       3.080  34.166 157.285  1.00 34.48           C  
ATOM   1014  CG2 VAL   137       3.421  36.348 158.450  1.00 35.11           C  
ATOM   1015  N   SER   138       6.228  37.044 156.433  1.00 41.77           N  
ATOM   1016  CA  SER   138       6.941  38.307 156.320  1.00 41.93           C  
ATOM   1017  C   SER   138       6.078  39.351 157.022  1.00 41.25           C  
ATOM   1018  O   SER   138       4.846  39.232 157.063  1.00 40.59           O  
ATOM   1019  CB  SER   138       7.123  38.712 154.859  1.00 42.90           C  
ATOM   1020  OG  SER   138       8.000  37.823 154.205  1.00 48.55           O  
ATOM   1021  N   PRO   139       6.712  40.382 157.589  1.00 42.32           N  
ATOM   1022  CA  PRO   139       6.007  41.457 158.292  1.00 43.29           C  
ATOM   1023  C   PRO   139       4.924  42.111 157.442  1.00 45.67           C  
ATOM   1024  O   PRO   139       3.968  42.681 157.974  1.00 46.01           O  
ATOM   1025  CB  PRO   139       7.131  42.436 158.684  1.00 43.98           C  
ATOM   1026  CG  PRO   139       8.358  41.958 157.932  1.00 42.13           C  
ATOM   1027  CD  PRO   139       8.170  40.487 157.766  1.00 41.37           C  
ATOM   1028  N   MET   140       5.071  42.035 156.123  1.00 47.45           N  
ATOM   1029  CA  MET   140       4.076  42.638 155.239  1.00 49.28           C  
ATOM   1030  C   MET   140       2.823  41.772 155.122  1.00 47.01           C  
ATOM   1031  O   MET   140       1.779  42.231 154.660  1.00 47.15           O  
ATOM   1032  CB  MET   140       4.690  42.930 153.855  1.00 51.82           C  
ATOM   1033  CG  MET   140       5.654  44.141 153.862  1.00 59.82           C  
ATOM   1034  SD  MET   140       5.021  45.728 152.904  1.00 78.54          SE  
ATOM   1035  CE  MET   140       3.104  45.465 153.043  1.00 71.46           C  
ATOM   1036  N   ASP   141       2.921  40.519 155.556  1.00 44.94           N  
ATOM   1037  CA  ASP   141       1.783  39.606 155.512  1.00 41.78           C  
ATOM   1038  C   ASP   141       1.064  39.456 156.859  1.00 40.48           C  
ATOM   1039  O   ASP   141      -0.003  38.844 156.926  1.00 39.11           O  
ATOM   1040  CB  ASP   141       2.233  38.221 155.051  1.00 42.04           C  
ATOM   1041  CG  ASP   141       2.523  38.160 153.568  1.00 43.17           C  
ATOM   1042  OD1 ASP   141       1.754  38.773 152.809  1.00 41.63           O  
ATOM   1043  OD2 ASP   141       3.497  37.487 153.159  1.00 43.95           O  
ATOM   1044  N   LEU   142       1.630  40.029 157.922  1.00 40.15           N  
ATOM   1045  CA  LEU   142       1.058  39.873 159.259  1.00 39.48           C  
ATOM   1046  C   LEU   142      -0.394  40.231 159.457  1.00 39.93           C  
ATOM   1047  O   LEU   142      -1.167  39.431 159.997  1.00 40.66           O  
ATOM   1048  CB  LEU   142       1.924  40.590 160.300  1.00 38.67           C  
ATOM   1049  CG  LEU   142       3.300  39.975 160.600  1.00 38.68           C  
ATOM   1050  CD1 LEU   142       4.112  40.933 161.458  1.00 42.38           C  
ATOM   1051  CD2 LEU   142       3.129  38.637 161.311  1.00 38.58           C  
ATOM   1052  N   LYS   143      -0.757  41.420 159.004  1.00 38.96           N  
ATOM   1053  CA  LYS   143      -2.117  41.903 159.110  1.00 39.51           C  
ATOM   1054  C   LYS   143      -3.068  40.971 158.364  1.00 39.15           C  
ATOM   1055  O   LYS   143      -4.116  40.575 158.884  1.00 40.10           O  
ATOM   1056  CB  LYS   143      -2.215  43.303 158.502  1.00 40.31           C  
ATOM   1057  CG  LYS   143      -3.030  44.294 159.323  1.00 43.90           C  
ATOM   1058  CD  LYS   143      -4.008  45.096 158.470  1.00 49.29           C  
ATOM   1059  CE  LYS   143      -5.421  44.522 158.568  1.00 53.76           C  
ATOM   1060  NZ  LYS   143      -6.429  45.319 157.813  1.00 56.00           N  
ATOM   1061  N   ALA   144      -2.700  40.623 157.138  1.00 39.14           N  
ATOM   1062  CA  ALA   144      -3.530  39.752 156.316  1.00 38.68           C  
ATOM   1063  C   ALA   144      -3.670  38.382 156.968  1.00 38.00           C  
ATOM   1064  O   ALA   144      -4.731  37.759 156.900  1.00 38.66           O  
ATOM   1065  CB  ALA   144      -2.929  39.621 154.911  1.00 37.15           C  
ATOM   1066  N   LEU   145      -2.602  37.918 157.611  1.00 37.83           N  
ATOM   1067  CA  LEU   145      -2.646  36.621 158.263  1.00 37.23           C  
ATOM   1068  C   LEU   145      -3.621  36.667 159.451  1.00 37.14           C  
ATOM   1069  O   LEU   145      -4.358  35.707 159.691  1.00 36.62           O  
ATOM   1070  CB  LEU   145      -1.235  36.188 158.718  1.00 36.77           C  
ATOM   1071  CG  LEU   145      -1.168  34.756 159.271  1.00 39.44           C  
ATOM   1072  CD1 LEU   145      -1.620  33.766 158.186  1.00 37.20           C  
ATOM   1073  CD2 LEU   145       0.252  34.435 159.742  1.00 35.79           C  
ATOM   1074  N   VAL   146      -3.629  37.782 160.184  1.00 37.71           N  
ATOM   1075  CA  VAL   146      -4.521  37.956 161.337  1.00 37.17           C  
ATOM   1076  C   VAL   146      -5.980  37.944 160.885  1.00 38.38           C  
ATOM   1077  O   VAL   146      -6.835  37.306 161.498  1.00 37.63           O  
ATOM   1078  CB  VAL   146      -4.253  39.297 162.050  1.00 36.80           C  
ATOM   1079  CG1 VAL   146      -5.205  39.467 163.214  1.00 35.48           C  
ATOM   1080  CG2 VAL   146      -2.811  39.358 162.525  1.00 37.51           C  
ATOM   1081  N   ASP   147      -6.256  38.672 159.807  1.00 39.95           N  
ATOM   1082  CA  ASP   147      -7.606  38.754 159.260  1.00 38.92           C  
ATOM   1083  C   ASP   147      -8.037  37.403 158.725  1.00 38.35           C  
ATOM   1084  O   ASP   147      -9.206  37.036 158.812  1.00 42.00           O  
ATOM   1085  CB  ASP   147      -7.668  39.792 158.136  1.00 40.05           C  
ATOM   1086  CG  ASP   147      -7.366  41.190 158.624  1.00 41.34           C  
ATOM   1087  OD1 ASP   147      -7.807  41.532 159.743  1.00 43.67           O  
ATOM   1088  OD2 ASP   147      -6.697  41.948 157.892  1.00 43.65           O  
ATOM   1089  N   ALA   148      -7.085  36.658 158.171  1.00 36.95           N  
ATOM   1090  CA  ALA   148      -7.374  35.335 157.625  1.00 34.18           C  
ATOM   1091  C   ALA   148      -7.538  34.295 158.726  1.00 34.08           C  
ATOM   1092  O   ALA   148      -8.441  33.463 158.683  1.00 31.80           O  
ATOM   1093  CB  ALA   148      -6.259  34.907 156.667  1.00 33.64           C  
ATOM   1094  N   ALA   149      -6.658  34.343 159.716  1.00 33.69           N  
ATOM   1095  CA  ALA   149      -6.696  33.377 160.798  1.00 33.43           C  
ATOM   1096  C   ALA   149      -7.799  33.579 161.834  1.00 33.55           C  
ATOM   1097  O   ALA   149      -8.396  32.609 162.312  1.00 34.44           O  
ATOM   1098  CB  ALA   149      -5.327  33.330 161.489  1.00 34.63           C  
ATOM   1099  N   TRP   150      -8.088  34.830 162.172  1.00 35.02           N  
ATOM   1100  CA  TRP   150      -9.084  35.104 163.208  1.00 35.52           C  
ATOM   1101  C   TRP   150     -10.392  34.341 163.089  1.00 36.07           C  
ATOM   1102  O   TRP   150     -10.829  33.698 164.051  1.00 36.77           O  
ATOM   1103  CB  TRP   150      -9.368  36.609 163.312  1.00 36.87           C  
ATOM   1104  CG  TRP   150      -9.881  37.006 164.678  1.00 39.34           C  
ATOM   1105  CD1 TRP   150     -11.103  37.530 164.976  1.00 38.91           C  
ATOM   1106  CD2 TRP   150      -9.185  36.875 165.928  1.00 38.85           C  
ATOM   1107  NE1 TRP   150     -11.213  37.738 166.333  1.00 40.42           N  
ATOM   1108  CE2 TRP   150     -10.049  37.348 166.940  1.00 39.56           C  
ATOM   1109  CE3 TRP   150      -7.910  36.414 166.288  1.00 40.01           C  
ATOM   1110  CZ2 TRP   150      -9.686  37.359 168.296  1.00 38.56           C  
ATOM   1111  CZ3 TRP   150      -7.546  36.428 167.635  1.00 41.47           C  
ATOM   1112  CH2 TRP   150      -8.431  36.904 168.620  1.00 41.64           C  
ATOM   1113  N   PRO   151     -11.030  34.386 161.912  1.00 36.28           N  
ATOM   1114  CA  PRO   151     -12.297  33.668 161.748  1.00 36.18           C  
ATOM   1115  C   PRO   151     -12.183  32.164 161.992  1.00 34.50           C  
ATOM   1116  O   PRO   151     -13.130  31.534 162.451  1.00 34.71           O  
ATOM   1117  CB  PRO   151     -12.690  33.958 160.295  1.00 37.11           C  
ATOM   1118  CG  PRO   151     -11.968  35.221 159.959  1.00 37.77           C  
ATOM   1119  CD  PRO   151     -10.652  35.100 160.679  1.00 35.64           C  
ATOM   1120  N   LEU   152     -11.022  31.593 161.679  1.00 34.79           N  
ATOM   1121  CA  LEU   152     -10.801  30.153 161.836  1.00 35.06           C  
ATOM   1122  C   LEU   152     -10.602  29.733 163.289  1.00 34.90           C  
ATOM   1123  O   LEU   152     -10.874  28.596 163.669  1.00 35.83           O  
ATOM   1124  CB  LEU   152      -9.588  29.721 161.011  1.00 35.31           C  
ATOM   1125  CG  LEU   152      -9.532  30.146 159.535  1.00 32.06           C  
ATOM   1126  CD1 LEU   152      -8.139  29.863 158.949  1.00 28.65           C  
ATOM   1127  CD2 LEU   152     -10.608  29.410 158.747  1.00 30.78           C  
ATOM   1128  N   LEU   153     -10.130  30.668 164.101  1.00 36.20           N  
ATOM   1129  CA  LEU   153      -9.865  30.413 165.514  1.00 35.55           C  
ATOM   1130  C   LEU   153     -11.086  30.273 166.380  1.00 35.15           C  
ATOM   1131  O   LEU   153     -12.043  31.021 166.223  1.00 36.38           O  
ATOM   1132  CB  LEU   153      -9.014  31.525 166.110  1.00 34.73           C  
ATOM   1133  CG  LEU   153      -7.490  31.460 166.042  1.00 35.40           C  
ATOM   1134  CD1 LEU   153      -6.906  32.700 166.722  1.00 37.52           C  
ATOM   1135  CD2 LEU   153      -6.991  30.175 166.744  1.00 23.36           C  
ATOM   1136  N   ARG   154     -11.058  29.310 167.296  1.00 36.30           N  
ATOM   1137  CA  ARG   154     -12.162  29.145 168.232  1.00 36.51           C  
ATOM   1138  C   ARG   154     -11.818  30.000 169.474  1.00 36.76           C  
ATOM   1139  O   ARG   154     -10.651  30.379 169.676  1.00 33.72           O  
ATOM   1140  CB  ARG   154     -12.319  27.674 168.634  1.00 36.75           C  
ATOM   1141  CG  ARG   154     -12.718  26.785 167.478  1.00 37.06           C  
ATOM   1142  CD  ARG   154     -12.577  25.313 167.811  1.00 37.83           C  
ATOM   1143  NE  ARG   154     -13.585  24.850 168.759  1.00 45.05           N  
ATOM   1144  CZ  ARG   154     -14.877  24.707 168.473  1.00 47.28           C  
ATOM   1145  NH1 ARG   154     -15.331  24.991 167.257  1.00 41.82           N  
ATOM   1146  NH2 ARG   154     -15.710  24.265 169.404  1.00 47.48           N  
ATOM   1147  N   ARG   155     -12.823  30.308 170.295  1.00 37.44           N  
ATOM   1148  CA  ARG   155     -12.610  31.086 171.514  1.00 37.17           C  
ATOM   1149  C   ARG   155     -11.747  30.192 172.403  1.00 35.22           C  
ATOM   1150  O   ARG   155     -11.978  28.975 172.493  1.00 36.48           O  
ATOM   1151  CB  ARG   155     -13.961  31.403 172.183  1.00 38.81           C  
ATOM   1152  CG  ARG   155     -14.937  32.087 171.233  1.00 42.34           C  
ATOM   1153  CD  ARG   155     -16.218  32.427 171.953  1.00 47.96           C  
ATOM   1154  NE  ARG   155     -16.064  33.616 172.784  1.00 54.25           N  
ATOM   1155  CZ  ARG   155     -16.418  34.843 172.409  1.00 56.26           C  
ATOM   1156  NH1 ARG   155     -16.953  35.045 171.210  1.00 56.53           N  
ATOM   1157  NH2 ARG   155     -16.230  35.868 173.234  1.00 56.32           N  
ATOM   1158  N   GLY   156     -10.764  30.799 173.062  1.00 32.13           N  
ATOM   1159  CA  GLY   156      -9.822  30.049 173.880  1.00 30.79           C  
ATOM   1160  C   GLY   156      -8.670  29.644 172.940  1.00 29.86           C  
ATOM   1161  O   GLY   156      -7.673  29.034 173.361  1.00 28.96           O  
ATOM   1162  N   GLY   157      -8.795  30.009 171.657  1.00 28.58           N  
ATOM   1163  CA  GLY   157      -7.783  29.685 170.652  1.00 26.53           C  
ATOM   1164  C   GLY   157      -6.719  30.750 170.521  1.00 26.35           C  
ATOM   1165  O   GLY   157      -6.981  31.934 170.724  1.00 26.49           O  
ATOM   1166  N   ALA   158      -5.517  30.330 170.143  1.00 26.28           N  
ATOM   1167  CA  ALA   158      -4.402  31.253 170.021  1.00 26.53           C  
ATOM   1168  C   ALA   158      -3.752  31.338 168.663  1.00 27.37           C  
ATOM   1169  O   ALA   158      -3.498  30.317 168.023  1.00 27.64           O  
ATOM   1170  CB  ALA   158      -3.333  30.924 171.057  1.00 24.38           C  
ATOM   1171  N   LEU   159      -3.468  32.568 168.245  1.00 28.32           N  
ATOM   1172  CA  LEU   159      -2.747  32.823 167.013  1.00 28.11           C  
ATOM   1173  C   LEU   159      -1.342  33.223 167.503  1.00 27.21           C  
ATOM   1174  O   LEU   159      -1.189  34.162 168.296  1.00 26.79           O  
ATOM   1175  CB  LEU   159      -3.371  33.994 166.234  1.00 28.52           C  
ATOM   1176  CG  LEU   159      -2.577  34.518 165.030  1.00 31.81           C  
ATOM   1177  CD1 LEU   159      -2.417  33.424 163.973  1.00 33.87           C  
ATOM   1178  CD2 LEU   159      -3.322  35.715 164.451  1.00 31.17           C  
ATOM   1179  N   VAL   160      -0.322  32.501 167.047  1.00 25.88           N  
ATOM   1180  CA  VAL   160       1.064  32.772 167.428  1.00 24.79           C  
ATOM   1181  C   VAL   160       1.858  33.296 166.232  1.00 27.75           C  
ATOM   1182  O   VAL   160       2.033  32.591 165.232  1.00 26.63           O  
ATOM   1183  CB  VAL   160       1.738  31.501 167.987  1.00 24.17           C  
ATOM   1184  CG1 VAL   160       3.150  31.821 168.438  1.00 23.11           C  
ATOM   1185  CG2 VAL   160       0.923  30.964 169.163  1.00 19.43           C  
ATOM   1186  N   LEU   161       2.338  34.537 166.340  1.00 29.92           N  
ATOM   1187  CA  LEU   161       3.088  35.183 165.258  1.00 31.39           C  
ATOM   1188  C   LEU   161       4.569  35.347 165.580  1.00 33.08           C  
ATOM   1189  O   LEU   161       4.957  36.203 166.376  1.00 32.56           O  
ATOM   1190  CB  LEU   161       2.467  36.550 164.943  1.00 31.04           C  
ATOM   1191  CG  LEU   161       0.954  36.513 164.655  1.00 29.82           C  
ATOM   1192  CD1 LEU   161       0.395  37.937 164.570  1.00 26.88           C  
ATOM   1193  CD2 LEU   161       0.693  35.749 163.363  1.00 26.34           C  
ATOM   1194  N   ALA   162       5.394  34.522 164.946  1.00 33.46           N  
ATOM   1195  CA  ALA   162       6.841  34.557 165.155  1.00 35.04           C  
ATOM   1196  C   ALA   162       7.519  35.821 164.628  1.00 36.17           C  
ATOM   1197  O   ALA   162       7.108  36.373 163.604  1.00 36.48           O  
ATOM   1198  CB  ALA   162       7.484  33.337 164.511  1.00 35.01           C  
ATOM   1199  N   ASP   163       8.559  36.260 165.343  1.00 35.67           N  
ATOM   1200  CA  ASP   163       9.367  37.428 164.980  1.00 35.23           C  
ATOM   1201  C   ASP   163       8.577  38.664 164.556  1.00 34.80           C  
ATOM   1202  O   ASP   163       9.082  39.491 163.803  1.00 37.18           O  
ATOM   1203  CB  ASP   163      10.324  37.063 163.848  1.00 36.36           C  
ATOM   1204  CG  ASP   163      11.103  35.796 164.126  1.00 38.68           C  
ATOM   1205  OD1 ASP   163      11.514  35.602 165.286  1.00 41.88           O  
ATOM   1206  OD2 ASP   163      11.319  34.996 163.186  1.00 44.47           O  
ATOM   1207  N   ALA   164       7.352  38.800 165.048  1.00 34.25           N  
ATOM   1208  CA  ALA   164       6.485  39.911 164.677  1.00 35.10           C  
ATOM   1209  C   ALA   164       6.843  41.287 165.218  1.00 37.45           C  
ATOM   1210  O   ALA   164       6.275  42.297 164.783  1.00 36.35           O  
ATOM   1211  CB  ALA   164       5.058  39.579 165.062  1.00 34.18           C  
ATOM   1212  N   LEU   165       7.782  41.327 166.155  1.00 38.68           N  
ATOM   1213  CA  LEU   165       8.179  42.576 166.783  1.00 41.51           C  
ATOM   1214  C   LEU   165       9.527  43.091 166.299  1.00 43.63           C  
ATOM   1215  O   LEU   165       9.965  44.174 166.688  1.00 44.67           O  
ATOM   1216  CB  LEU   165       8.215  42.389 168.300  1.00 40.59           C  
ATOM   1217  CG  LEU   165       6.898  42.048 169.005  1.00 37.73           C  
ATOM   1218  CD1 LEU   165       7.169  41.504 170.401  1.00 39.58           C  
ATOM   1219  CD2 LEU   165       6.026  43.291 169.080  1.00 42.32           C  
ATOM   1220  N   LEU   166      10.172  42.306 165.446  1.00 46.20           N  
ATOM   1221  CA  LEU   166      11.477  42.650 164.900  1.00 47.74           C  
ATOM   1222  C   LEU   166      12.459  43.155 165.952  1.00 49.34           C  
ATOM   1223  O   LEU   166      13.031  44.241 165.822  1.00 48.89           O  
ATOM   1224  CB  LEU   166      11.326  43.671 163.760  1.00 47.18           C  
ATOM   1225  CG  LEU   166      10.589  43.140 162.518  1.00 47.23           C  
ATOM   1226  CD1 LEU   166      10.505  44.215 161.444  1.00 48.55           C  
ATOM   1227  CD2 LEU   166      11.325  41.922 161.986  1.00 48.26           C  
ATOM   1228  N   ASP   167      12.632  42.357 167.004  1.00 51.27           N  
ATOM   1229  CA  ASP   167      13.570  42.673 168.073  1.00 52.31           C  
ATOM   1230  C   ASP   167      13.333  44.014 168.764  1.00 53.19           C  
ATOM   1231  O   ASP   167      14.231  44.548 169.422  1.00 53.46           O  
ATOM   1232  CB  ASP   167      14.992  42.629 167.513  1.00 53.31           C  
ATOM   1233  CG  ASP   167      15.465  41.213 167.224  1.00 54.32           C  
ATOM   1234  OD1 ASP   167      15.400  40.377 168.146  1.00 57.29           O  
ATOM   1235  OD2 ASP   167      15.913  40.938 166.089  1.00 59.10           O  
ATOM   1236  N   GLY   168      12.123  44.545 168.614  1.00 54.04           N  
ATOM   1237  CA  GLY   168      11.793  45.823 169.209  1.00 56.23           C  
ATOM   1238  C   GLY   168      12.089  46.953 168.235  1.00 58.04           C  
ATOM   1239  O   GLY   168      11.750  48.110 168.482  1.00 57.65           O  
ATOM   1240  N   THR   169      12.735  46.611 167.124  1.00 59.91           N  
ATOM   1241  CA  THR   169      13.095  47.571 166.079  1.00 61.31           C  
ATOM   1242  C   THR   169      12.033  48.640 165.864  1.00 62.28           C  
ATOM   1243  O   THR   169      12.365  49.803 165.619  1.00 63.59           O  
ATOM   1244  CB  THR   169      13.342  46.846 164.726  1.00 60.94           C  
ATOM   1245  OG1 THR   169      14.680  46.335 164.684  1.00 60.61           O  
ATOM   1246  CG2 THR   169      13.109  47.780 163.544  1.00 62.48           C  
ATOM   1247  N   ILE   170      10.762  48.250 165.954  1.00 63.65           N  
ATOM   1248  CA  ILE   170       9.677  49.198 165.728  1.00 65.26           C  
ATOM   1249  C   ILE   170       9.646  50.344 166.743  1.00 67.56           C  
ATOM   1250  O   ILE   170      10.360  50.315 167.740  1.00 67.27           O  
ATOM   1251  CB  ILE   170       8.300  48.465 165.611  1.00 64.43           C  
ATOM   1252  CG1 ILE   170       8.059  47.560 166.808  1.00 65.08           C  
ATOM   1253  CG2 ILE   170       8.284  47.632 164.319  1.00 63.91           C  
ATOM   1254  CD1 ILE   170       6.824  46.694 166.661  1.00 61.22           C  
ATOM   1255  N   ALA   171       8.815  51.349 166.477  1.00 71.03           N  
ATOM   1256  CA  ALA   171       8.732  52.562 167.298  1.00 74.04           C  
ATOM   1257  C   ALA   171      10.147  53.153 167.376  1.00 76.78           C  
ATOM   1258  O   ALA   171      10.730  53.279 168.460  1.00 77.43           O  
ATOM   1259  CB  ALA   171       8.222  52.258 168.694  1.00 74.35           C  
ATOM   1260  N   ASP   172      10.699  53.525 166.223  1.00 79.39           N  
ATOM   1261  CA  ASP   172      12.045  54.097 166.162  1.00 81.44           C  
ATOM   1262  C   ASP   172      12.123  55.050 164.972  1.00 82.22           C  
ATOM   1263  O   ASP   172      12.056  54.625 163.819  1.00 83.14           O  
ATOM   1264  CB  ASP   172      13.070  52.972 165.995  1.00 81.68           C  
ATOM   1265  CG  ASP   172      14.447  53.340 166.498  1.00 85.84           C  
ATOM   1266  OD1 ASP   172      14.833  54.516 166.380  1.00 90.92           O  
ATOM   1267  OD2 ASP   172      15.153  52.441 166.997  1.00 87.39           O  
ATOM   1268  N   GLN   173      12.282  56.336 165.262  1.00 82.92           N  
ATOM   1269  CA  GLN   173      12.352  57.356 164.224  1.00 83.98           C  
ATOM   1270  C   GLN   173      13.324  57.023 163.106  1.00 83.45           C  
ATOM   1271  O   GLN   173      12.969  57.063 161.933  1.00 83.90           O  
ATOM   1272  CB  GLN   173      12.712  58.717 164.834  1.00 84.72           C  
ATOM   1273  CG  GLN   173      11.607  59.350 165.690  1.00 88.73           C  
ATOM   1274  CD  GLN   173      11.323  58.578 166.965  1.00 91.02           C  
ATOM   1275  OE1 GLN   173      12.243  58.150 167.655  1.00 91.29           O  
ATOM   1276  NE2 GLN   173      10.044  58.415 167.295  1.00 90.94           N  
ATOM   1277  N   THR   174      14.550  56.679 163.477  1.00 82.77           N  
ATOM   1278  CA  THR   174      15.575  56.341 162.498  1.00 82.11           C  
ATOM   1279  C   THR   174      15.135  55.223 161.573  1.00 81.93           C  
ATOM   1280  O   THR   174      15.240  55.333 160.348  1.00 81.65           O  
ATOM   1281  CB  THR   174      16.901  55.902 163.178  1.00 82.03           C  
ATOM   1282  OG1 THR   174      16.664  54.764 164.022  1.00 82.87           O  
ATOM   1283  CG2 THR   174      17.494  57.036 164.004  1.00 80.61           C  
ATOM   1284  N   ARG   175      14.620  54.155 162.170  1.00 81.42           N  
ATOM   1285  CA  ARG   175      14.203  52.990 161.400  1.00 80.76           C  
ATOM   1286  C   ARG   175      13.016  53.134 160.457  1.00 80.26           C  
ATOM   1287  O   ARG   175      11.901  52.742 160.806  1.00 80.41           O  
ATOM   1288  CB  ARG   175      13.966  51.805 162.341  1.00 80.91           C  
ATOM   1289  CG  ARG   175      14.234  50.422 161.726  1.00 82.08           C  
ATOM   1290  CD  ARG   175      15.675  49.988 161.956  1.00 84.76           C  
ATOM   1291  NE  ARG   175      16.086  50.219 163.341  1.00 85.35           N  
ATOM   1292  CZ  ARG   175      17.050  49.545 163.962  1.00 86.15           C  
ATOM   1293  NH1 ARG   175      17.712  48.585 163.327  1.00 83.31           N  
ATOM   1294  NH2 ARG   175      17.346  49.826 165.226  1.00 86.88           N  
ATOM   1295  N   LYS   176      13.252  53.728 159.283  1.00 79.32           N  
ATOM   1296  CA  LYS   176      12.200  53.819 158.277  1.00 77.64           C  
ATOM   1297  C   LYS   176      12.482  52.544 157.460  1.00 76.67           C  
ATOM   1298  O   LYS   176      13.654  52.147 157.250  1.00 76.95           O  
ATOM   1299  CB  LYS   176      12.349  55.063 157.415  1.00 78.36           C  
ATOM   1300  N   ASP   177      11.419  51.901 156.986  1.00 73.97           N  
ATOM   1301  CA  ASP   177      11.555  50.614 156.296  1.00 71.10           C  
ATOM   1302  C   ASP   177      10.173  50.140 155.855  1.00 69.68           C  
ATOM   1303  O   ASP   177       9.176  50.354 156.551  1.00 69.25           O  
ATOM   1304  CB  ASP   177      12.096  49.619 157.317  1.00 71.15           C  
ATOM   1305  CG  ASP   177      13.030  48.583 156.729  1.00 71.21           C  
ATOM   1306  OD1 ASP   177      13.875  48.966 155.902  1.00 71.86           O  
ATOM   1307  OD2 ASP   177      12.938  47.392 157.122  1.00 69.21           O  
ATOM   1308  N   ARG   178      10.122  49.464 154.716  1.00 67.48           N  
ATOM   1309  CA  ARG   178       8.873  48.908 154.231  1.00 65.11           C  
ATOM   1310  C   ARG   178       8.368  47.952 155.319  1.00 62.93           C  
ATOM   1311  O   ARG   178       7.205  47.995 155.716  1.00 61.37           O  
ATOM   1312  CB  ARG   178       9.120  48.129 152.934  1.00 65.76           C  
ATOM   1313  N   ASP   179       9.258  47.081 155.789  1.00 61.40           N  
ATOM   1314  CA  ASP   179       8.914  46.072 156.785  1.00 61.31           C  
ATOM   1315  C   ASP   179       8.565  46.570 158.176  1.00 61.77           C  
ATOM   1316  O   ASP   179       7.499  46.240 158.708  1.00 62.54           O  
ATOM   1317  CB  ASP   179      10.025  45.013 156.857  1.00 60.28           C  
ATOM   1318  CG  ASP   179       9.996  44.057 155.657  1.00 60.29           C  
ATOM   1319  OD1 ASP   179       8.969  44.025 154.933  1.00 56.76           O  
ATOM   1320  OD2 ASP   179      10.993  43.330 155.451  1.00 58.00           O  
ATOM   1321  N   THR   180       9.457  47.362 158.756  1.00 61.26           N  
ATOM   1322  CA  THR   180       9.238  47.899 160.085  1.00 60.59           C  
ATOM   1323  C   THR   180       7.871  48.589 160.156  1.00 59.22           C  
ATOM   1324  O   THR   180       7.154  48.475 161.156  1.00 59.51           O  
ATOM   1325  CB  THR   180      10.351  48.910 160.457  1.00 60.28           C  
ATOM   1326  OG1 THR   180      10.457  48.997 161.881  1.00 63.84           O  
ATOM   1327  CG2 THR   180      10.034  50.299 159.913  1.00 62.53           C  
ATOM   1328  N   GLN   181       7.517  49.301 159.089  1.00 57.42           N  
ATOM   1329  CA  GLN   181       6.250  50.026 159.021  1.00 56.34           C  
ATOM   1330  C   GLN   181       5.053  49.083 158.956  1.00 54.30           C  
ATOM   1331  O   GLN   181       3.980  49.394 159.486  1.00 55.01           O  
ATOM   1332  CB  GLN   181       6.247  50.951 157.799  1.00 56.61           C  
ATOM   1333  CG  GLN   181       5.074  51.905 157.722  1.00 60.31           C  
ATOM   1334  CD  GLN   181       5.224  52.896 156.579  1.00 66.50           C  
ATOM   1335  OE1 GLN   181       6.338  53.162 156.123  1.00 68.79           O  
ATOM   1336  NE2 GLN   181       4.108  53.467 156.131  1.00 65.27           N  
ATOM   1337  N   ALA   182       5.241  47.936 158.308  1.00 52.30           N  
ATOM   1338  CA  ALA   182       4.177  46.945 158.188  1.00 51.70           C  
ATOM   1339  C   ALA   182       4.042  46.221 159.534  1.00 49.61           C  
ATOM   1340  O   ALA   182       2.929  45.999 160.011  1.00 48.87           O  
ATOM   1341  CB  ALA   182       4.504  45.948 157.068  1.00 51.18           C  
ATOM   1342  N   ALA   183       5.175  45.864 160.141  1.00 47.78           N  
ATOM   1343  CA  ALA   183       5.170  45.196 161.439  1.00 49.10           C  
ATOM   1344  C   ALA   183       4.535  46.152 162.474  1.00 50.05           C  
ATOM   1345  O   ALA   183       3.764  45.721 163.333  1.00 49.60           O  
ATOM   1346  CB  ALA   183       6.601  44.831 161.846  1.00 47.67           C  
ATOM   1347  N   ARG   184       4.849  47.448 162.392  1.00 51.31           N  
ATOM   1348  CA  ARG   184       4.283  48.433 163.319  1.00 52.65           C  
ATOM   1349  C   ARG   184       2.760  48.504 163.162  1.00 53.41           C  
ATOM   1350  O   ARG   184       2.031  48.534 164.157  1.00 53.91           O  
ATOM   1351  CB  ARG   184       4.872  49.820 163.066  1.00 54.06           C  
ATOM   1352  CG  ARG   184       5.157  50.600 164.341  1.00 57.28           C  
ATOM   1353  CD  ARG   184       5.260  52.096 164.094  1.00 59.50           C  
ATOM   1354  NE  ARG   184       6.262  52.446 163.092  1.00 61.89           N  
ATOM   1355  CZ  ARG   184       7.549  52.123 163.171  1.00 65.18           C  
ATOM   1356  NH1 ARG   184       8.000  51.441 164.209  1.00 66.46           N  
ATOM   1357  NH2 ARG   184       8.390  52.486 162.210  1.00 67.83           N  
ATOM   1358  N   ASP   185       2.280  48.532 161.917  1.00 53.41           N  
ATOM   1359  CA  ASP   185       0.838  48.596 161.664  1.00 54.19           C  
ATOM   1360  C   ASP   185       0.141  47.321 162.135  1.00 52.11           C  
ATOM   1361  O   ASP   185      -0.988  47.361 162.637  1.00 51.76           O  
ATOM   1362  CB  ASP   185       0.545  48.817 160.177  1.00 55.83           C  
ATOM   1363  CG  ASP   185      -0.940  48.873 159.884  1.00 63.25           C  
ATOM   1364  OD1 ASP   185      -1.551  47.806 159.669  1.00 71.31           O  
ATOM   1365  OD2 ASP   185      -1.503  49.988 159.886  1.00 73.27           O  
ATOM   1366  N   ALA   186       0.817  46.189 161.972  1.00 50.23           N  
ATOM   1367  CA  ALA   186       0.269  44.908 162.407  1.00 48.60           C  
ATOM   1368  C   ALA   186       0.097  44.960 163.936  1.00 46.32           C  
ATOM   1369  O   ALA   186      -0.975  44.666 164.459  1.00 45.88           O  
ATOM   1370  CB  ALA   186       1.220  43.776 162.022  1.00 47.52           C  
ATOM   1371  N   ASP   187       1.157  45.336 164.646  1.00 45.93           N  
ATOM   1372  CA  ASP   187       1.121  45.421 166.106  1.00 46.57           C  
ATOM   1373  C   ASP   187      -0.020  46.353 166.537  1.00 46.63           C  
ATOM   1374  O   ASP   187      -0.879  45.975 167.341  1.00 46.91           O  
ATOM   1375  CB  ASP   187       2.474  45.939 166.620  1.00 45.25           C  
ATOM   1376  CG  ASP   187       2.575  45.923 168.138  1.00 49.55           C  
ATOM   1377  OD1 ASP   187       2.652  44.821 168.735  1.00 45.87           O  
ATOM   1378  OD2 ASP   187       2.569  47.024 168.736  1.00 50.96           O  
ATOM   1379  N   GLU   188      -0.024  47.571 166.001  1.00 46.68           N  
ATOM   1380  CA  GLU   188      -1.064  48.545 166.320  1.00 46.47           C  
ATOM   1381  C   GLU   188      -2.450  47.988 165.972  1.00 45.29           C  
ATOM   1382  O   GLU   188      -3.409  48.177 166.717  1.00 44.23           O  
ATOM   1383  CB  GLU   188      -0.806  49.845 165.548  1.00 47.29           C  
ATOM   1384  CG  GLU   188      -1.912  50.873 165.661  1.00 52.14           C  
ATOM   1385  CD  GLU   188      -1.559  52.167 164.960  1.00 58.46           C  
ATOM   1386  OE1 GLU   188      -0.450  52.686 165.211  1.00 60.41           O  
ATOM   1387  OE2 GLU   188      -2.388  52.672 164.171  1.00 57.72           O  
ATOM   1388  N   TYR   189      -2.552  47.304 164.835  1.00 44.78           N  
ATOM   1389  CA  TYR   189      -3.822  46.712 164.409  1.00 43.79           C  
ATOM   1390  C   TYR   189      -4.226  45.571 165.343  1.00 42.73           C  
ATOM   1391  O   TYR   189      -5.385  45.467 165.753  1.00 43.44           O  
ATOM   1392  CB  TYR   189      -3.716  46.157 162.994  1.00 43.66           C  
ATOM   1393  CG  TYR   189      -4.990  45.489 162.538  1.00 43.06           C  
ATOM   1394  CD1 TYR   189      -6.135  46.241 162.280  1.00 45.51           C  
ATOM   1395  CD2 TYR   189      -5.064  44.104 162.395  1.00 40.70           C  
ATOM   1396  CE1 TYR   189      -7.320  45.635 161.886  1.00 48.14           C  
ATOM   1397  CE2 TYR   189      -6.248  43.483 162.003  1.00 43.88           C  
ATOM   1398  CZ  TYR   189      -7.370  44.256 161.751  1.00 46.56           C  
ATOM   1399  OH  TYR   189      -8.540  43.659 161.351  1.00 45.85           O  
ATOM   1400  N   ILE   190      -3.268  44.710 165.676  1.00 41.78           N  
ATOM   1401  CA  ILE   190      -3.536  43.587 166.562  1.00 39.45           C  
ATOM   1402  C   ILE   190      -4.024  44.084 167.931  1.00 39.67           C  
ATOM   1403  O   ILE   190      -4.950  43.518 168.511  1.00 38.60           O  
ATOM   1404  CB  ILE   190      -2.267  42.701 166.725  1.00 40.19           C  
ATOM   1405  CG1 ILE   190      -2.089  41.824 165.479  1.00 36.29           C  
ATOM   1406  CG2 ILE   190      -2.366  41.848 167.998  1.00 37.83           C  
ATOM   1407  CD1 ILE   190      -0.753  41.100 165.413  1.00 26.27           C  
ATOM   1408  N   ARG   191      -3.404  45.142 168.445  1.00 40.01           N  
ATOM   1409  CA  ARG   191      -3.792  45.684 169.743  1.00 43.13           C  
ATOM   1410  C   ARG   191      -5.132  46.419 169.725  1.00 44.80           C  
ATOM   1411  O   ARG   191      -5.630  46.842 170.766  1.00 44.64           O  
ATOM   1412  CB  ARG   191      -2.695  46.611 170.265  1.00 41.94           C  
ATOM   1413  CG  ARG   191      -1.437  45.882 170.742  1.00 42.77           C  
ATOM   1414  CD  ARG   191      -0.238  46.814 170.764  1.00 46.32           C  
ATOM   1415  NE  ARG   191      -0.668  48.195 170.934  1.00 51.32           N  
ATOM   1416  CZ  ARG   191      -0.136  49.228 170.292  1.00 50.72           C  
ATOM   1417  NH1 ARG   191       0.853  49.047 169.427  1.00 50.42           N  
ATOM   1418  NH2 ARG   191      -0.598  50.446 170.515  1.00 53.35           N  
ATOM   1419  N   SER   192      -5.725  46.543 168.543  1.00 45.68           N  
ATOM   1420  CA  SER   192      -6.994  47.240 168.393  1.00 46.18           C  
ATOM   1421  C   SER   192      -8.188  46.294 168.323  1.00 46.25           C  
ATOM   1422  O   SER   192      -9.328  46.721 168.519  1.00 46.21           O  
ATOM   1423  CB  SER   192      -6.979  48.097 167.124  1.00 47.71           C  
ATOM   1424  OG  SER   192      -7.303  47.324 165.967  1.00 47.27           O  
ATOM   1425  N   ILE   193      -7.944  45.015 168.046  1.00 47.19           N  
ATOM   1426  CA  ILE   193      -9.054  44.092 167.912  1.00 46.69           C  
ATOM   1427  C   ILE   193      -9.698  43.766 169.246  1.00 45.97           C  
ATOM   1428  O   ILE   193      -9.027  43.638 170.263  1.00 45.13           O  
ATOM   1429  CB  ILE   193      -8.627  42.829 167.096  1.00 46.55           C  
ATOM   1430  CG1 ILE   193      -9.275  41.581 167.659  1.00 48.58           C  
ATOM   1431  CG2 ILE   193      -7.122  42.735 167.017  1.00 48.52           C  
ATOM   1432  CD1 ILE   193      -8.374  40.370 167.601  1.00 53.08           C  
ATOM   1433  N   GLU   194     -11.020  43.641 169.220  1.00 46.10           N  
ATOM   1434  CA  GLU   194     -11.803  43.405 170.419  1.00 46.72           C  
ATOM   1435  C   GLU   194     -12.074  41.944 170.734  1.00 45.13           C  
ATOM   1436  O   GLU   194     -12.243  41.126 169.834  1.00 44.75           O  
ATOM   1437  CB  GLU   194     -13.119  44.175 170.299  1.00 48.29           C  
ATOM   1438  CG  GLU   194     -13.732  44.629 171.616  1.00 53.72           C  
ATOM   1439  CD  GLU   194     -13.127  45.922 172.135  1.00 60.45           C  
ATOM   1440  OE1 GLU   194     -12.510  46.656 171.332  1.00 61.44           O  
ATOM   1441  OE2 GLU   194     -13.287  46.211 173.341  1.00 63.38           O  
ATOM   1442  N   GLY   195     -12.123  41.631 172.022  1.00 42.68           N  
ATOM   1443  CA  GLY   195     -12.355  40.262 172.422  1.00 41.19           C  
ATOM   1444  C   GLY   195     -11.115  39.427 172.149  1.00 38.96           C  
ATOM   1445  O   GLY   195     -11.204  38.228 171.879  1.00 38.68           O  
ATOM   1446  N   ALA   196      -9.949  40.069 172.193  1.00 37.97           N  
ATOM   1447  CA  ALA   196      -8.669  39.386 171.968  1.00 38.03           C  
ATOM   1448  C   ALA   196      -7.746  39.616 173.142  1.00 38.17           C  
ATOM   1449  O   ALA   196      -7.723  40.713 173.714  1.00 39.15           O  
ATOM   1450  CB  ALA   196      -7.979  39.904 170.722  1.00 37.01           C  
ATOM   1451  N   HIS   197      -6.990  38.587 173.518  1.00 36.67           N  
ATOM   1452  CA  HIS   197      -5.979  38.759 174.559  1.00 34.86           C  
ATOM   1453  C   HIS   197      -4.672  38.817 173.766  1.00 34.12           C  
ATOM   1454  O   HIS   197      -4.383  37.946 172.928  1.00 34.95           O  
ATOM   1455  CB  HIS   197      -5.904  37.572 175.516  1.00 34.32           C  
ATOM   1456  CG  HIS   197      -7.163  37.314 176.261  1.00 30.53           C  
ATOM   1457  ND1 HIS   197      -7.739  38.243 177.100  1.00 28.83           N  
ATOM   1458  CD2 HIS   197      -7.935  36.209 176.330  1.00 32.70           C  
ATOM   1459  CE1 HIS   197      -8.814  37.717 177.656  1.00 29.31           C  
ATOM   1460  NE2 HIS   197      -8.955  36.484 177.205  1.00 27.66           N  
ATOM   1461  N   VAL   198      -3.887  39.856 174.006  1.00 32.85           N  
ATOM   1462  CA  VAL   198      -2.614  40.026 173.315  1.00 31.44           C  
ATOM   1463  C   VAL   198      -1.459  39.870 174.291  1.00 31.83           C  
ATOM   1464  O   VAL   198      -1.404  40.553 175.311  1.00 33.09           O  
ATOM   1465  CB  VAL   198      -2.521  41.420 172.641  1.00 32.23           C  
ATOM   1466  CG1 VAL   198      -1.167  41.590 171.962  1.00 29.85           C  
ATOM   1467  CG2 VAL   198      -3.662  41.584 171.629  1.00 31.51           C  
ATOM   1468  N   ALA   199      -0.555  38.942 173.991  1.00 31.03           N  
ATOM   1469  CA  ALA   199       0.623  38.735 174.820  1.00 30.46           C  
ATOM   1470  C   ALA   199       1.808  38.865 173.865  1.00 30.64           C  
ATOM   1471  O   ALA   199       1.832  38.228 172.812  1.00 30.97           O  
ATOM   1472  CB  ALA   199       0.609  37.340 175.471  1.00 28.20           C  
ATOM   1473  N   ARG   200       2.775  39.707 174.212  1.00 30.50           N  
ATOM   1474  CA  ARG   200       3.949  39.902 173.383  1.00 31.66           C  
ATOM   1475  C   ARG   200       5.137  39.535 174.265  1.00 32.61           C  
ATOM   1476  O   ARG   200       5.411  40.170 175.282  1.00 33.33           O  
ATOM   1477  CB  ARG   200       3.962  41.351 172.862  1.00 31.67           C  
ATOM   1478  CG  ARG   200       2.891  41.543 171.766  1.00 36.13           C  
ATOM   1479  CD  ARG   200       2.761  43.000 171.353  1.00 37.83           C  
ATOM   1480  NE  ARG   200       2.310  43.827 172.467  1.00 38.02           N  
ATOM   1481  CZ  ARG   200       2.536  45.129 172.561  1.00 37.23           C  
ATOM   1482  NH1 ARG   200       3.209  45.752 171.599  1.00 37.07           N  
ATOM   1483  NH2 ARG   200       2.122  45.793 173.631  1.00 35.20           N  
ATOM   1484  N   LEU   201       5.848  38.501 173.837  1.00 31.75           N  
ATOM   1485  CA  LEU   201       6.921  37.919 174.608  1.00 31.41           C  
ATOM   1486  C   LEU   201       8.335  37.984 174.037  1.00 31.43           C  
ATOM   1487  O   LEU   201       8.513  38.065 172.835  1.00 31.82           O  
ATOM   1488  CB  LEU   201       6.513  36.467 174.892  1.00 29.43           C  
ATOM   1489  CG  LEU   201       5.021  36.302 175.288  1.00 32.44           C  
ATOM   1490  CD1 LEU   201       4.614  34.815 175.271  1.00 26.90           C  
ATOM   1491  CD2 LEU   201       4.773  36.920 176.667  1.00 27.08           C  
ATOM   1492  N   PRO   202       9.352  37.925 174.917  1.00 30.80           N  
ATOM   1493  CA  PRO   202      10.767  37.978 174.532  1.00 30.32           C  
ATOM   1494  C   PRO   202      11.335  36.677 173.954  1.00 30.34           C  
ATOM   1495  O   PRO   202      12.359  36.191 174.416  1.00 30.23           O  
ATOM   1496  CB  PRO   202      11.457  38.373 175.834  1.00 30.91           C  
ATOM   1497  CG  PRO   202      10.656  37.632 176.860  1.00 28.45           C  
ATOM   1498  CD  PRO   202       9.205  37.859 176.387  1.00 30.07           C  
ATOM   1499  N   LEU   203      10.667  36.118 172.952  1.00 30.48           N  
ATOM   1500  CA  LEU   203      11.123  34.883 172.314  1.00 30.84           C  
ATOM   1501  C   LEU   203      11.410  35.167 170.839  1.00 31.51           C  
ATOM   1502  O   LEU   203      10.659  35.887 170.186  1.00 30.41           O  
ATOM   1503  CB  LEU   203      10.053  33.790 172.456  1.00 30.29           C  
ATOM   1504  CG  LEU   203       9.891  33.170 173.843  1.00 32.44           C  
ATOM   1505  CD1 LEU   203       8.508  32.527 173.937  1.00 32.55           C  
ATOM   1506  CD2 LEU   203      11.009  32.152 174.088  1.00 23.45           C  
ATOM   1507  N   GLY   204      12.497  34.596 170.326  1.00 32.37           N  
ATOM   1508  CA  GLY   204      12.882  34.847 168.949  1.00 34.19           C  
ATOM   1509  C   GLY   204      13.081  36.350 168.798  1.00 35.62           C  
ATOM   1510  O   GLY   204      13.706  36.997 169.647  1.00 35.96           O  
ATOM   1511  N   ALA   205      12.557  36.924 167.719  1.00 35.06           N  
ATOM   1512  CA  ALA   205      12.671  38.366 167.495  1.00 35.51           C  
ATOM   1513  C   ALA   205      11.446  39.095 168.071  1.00 35.05           C  
ATOM   1514  O   ALA   205      11.159  40.235 167.697  1.00 34.58           O  
ATOM   1515  CB  ALA   205      12.804  38.661 165.991  1.00 35.87           C  
ATOM   1516  N   GLY   206      10.724  38.440 168.978  1.00 35.87           N  
ATOM   1517  CA  GLY   206       9.545  39.052 169.571  1.00 34.61           C  
ATOM   1518  C   GLY   206       8.283  38.367 169.082  1.00 35.34           C  
ATOM   1519  O   GLY   206       7.853  38.570 167.954  1.00 34.47           O  
ATOM   1520  N   LEU   207       7.677  37.575 169.958  1.00 34.79           N  
ATOM   1521  CA  LEU   207       6.491  36.801 169.637  1.00 31.42           C  
ATOM   1522  C   LEU   207       5.192  37.467 170.024  1.00 30.81           C  
ATOM   1523  O   LEU   207       5.061  37.984 171.123  1.00 31.83           O  
ATOM   1524  CB  LEU   207       6.606  35.445 170.336  1.00 33.46           C  
ATOM   1525  CG  LEU   207       5.572  34.340 170.108  1.00 33.46           C  
ATOM   1526  CD1 LEU   207       5.830  33.688 168.753  1.00 37.83           C  
ATOM   1527  CD2 LEU   207       5.667  33.296 171.214  1.00 30.57           C  
ATOM   1528  N   THR   208       4.228  37.466 169.113  1.00 30.32           N  
ATOM   1529  CA  THR   208       2.928  38.023 169.439  1.00 28.64           C  
ATOM   1530  C   THR   208       1.915  36.888 169.395  1.00 29.95           C  
ATOM   1531  O   THR   208       1.733  36.237 168.356  1.00 29.31           O  
ATOM   1532  CB  THR   208       2.457  39.112 168.449  1.00 30.18           C  
ATOM   1533  OG1 THR   208       3.403  40.185 168.423  1.00 30.22           O  
ATOM   1534  CG2 THR   208       1.104  39.671 168.893  1.00 26.07           C  
ATOM   1535  N   VAL   209       1.290  36.608 170.530  1.00 29.09           N  
ATOM   1536  CA  VAL   209       0.264  35.589 170.541  1.00 29.88           C  
ATOM   1537  C   VAL   209      -1.036  36.292 170.927  1.00 30.32           C  
ATOM   1538  O   VAL   209      -1.116  37.033 171.909  1.00 32.33           O  
ATOM   1539  CB  VAL   209       0.622  34.361 171.478  1.00 29.48           C  
ATOM   1540  CG1 VAL   209       1.798  34.685 172.342  1.00 29.65           C  
ATOM   1541  CG2 VAL   209      -0.590  33.915 172.266  1.00 25.94           C  
ATOM   1542  N   VAL   210      -2.055  36.092 170.111  1.00 30.08           N  
ATOM   1543  CA  VAL   210      -3.324  36.706 170.372  1.00 30.95           C  
ATOM   1544  C   VAL   210      -4.362  35.599 170.439  1.00 31.19           C  
ATOM   1545  O   VAL   210      -4.602  34.856 169.474  1.00 31.19           O  
ATOM   1546  CB  VAL   210      -3.619  37.855 169.309  1.00 32.54           C  
ATOM   1547  CG1 VAL   210      -2.689  37.714 168.126  1.00 29.10           C  
ATOM   1548  CG2 VAL   210      -5.061  37.887 168.913  1.00 30.41           C  
ATOM   1549  N   THR   211      -4.970  35.474 171.610  1.00 31.26           N  
ATOM   1550  CA  THR   211      -5.956  34.445 171.782  1.00 33.16           C  
ATOM   1551  C   THR   211      -7.354  35.046 171.827  1.00 33.51           C  
ATOM   1552  O   THR   211      -7.553  36.165 172.310  1.00 34.80           O  
ATOM   1553  CB  THR   211      -5.607  33.534 173.019  1.00 33.51           C  
ATOM   1554  OG1 THR   211      -6.632  33.598 174.013  1.00 32.53           O  
ATOM   1555  CG2 THR   211      -4.269  33.914 173.600  1.00 26.11           C  
ATOM   1556  N   LYS   212      -8.314  34.304 171.283  1.00 33.14           N  
ATOM   1557  CA  LYS   212      -9.690  34.759 171.217  1.00 32.21           C  
ATOM   1558  C   LYS   212     -10.338  34.586 172.574  1.00 33.16           C  
ATOM   1559  O   LYS   212     -10.486  33.483 173.093  1.00 31.48           O  
ATOM   1560  CB  LYS   212     -10.451  33.983 170.126  1.00 30.67           C  
ATOM   1561  CG  LYS   212     -11.848  34.499 169.856  1.00 31.48           C  
ATOM   1562  CD  LYS   212     -12.519  33.780 168.685  1.00 33.82           C  
ATOM   1563  CE  LYS   212     -11.949  34.223 167.341  1.00 34.01           C  
ATOM   1564  NZ  LYS   212     -12.701  33.627 166.197  1.00 35.69           N  
ATOM   1565  N   ALA   213     -10.723  35.710 173.156  1.00 35.52           N  
ATOM   1566  CA  ALA   213     -11.339  35.718 174.472  1.00 36.71           C  
ATOM   1567  C   ALA   213     -12.641  34.939 174.553  1.00 38.53           C  
ATOM   1568  O   ALA   213     -13.372  34.834 173.570  1.00 39.30           O  
ATOM   1569  CB  ALA   213     -11.569  37.170 174.922  1.00 37.58           C  
END
