
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  214 ( 1684),  selected  214 , name 2cl5_A
# Molecule2: number of CA atoms  211 ( 1569),  selected  211 , name T0509.pdb
# PARAMETERS: 2cl5_A.T0509.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     2_A      N       3           -
LGA    D     3_A      A       4           -
LGA    T     4_A      F       5           -
LGA    K     5_A      E       6           -
LGA    E     6_A      Y       7           -
LGA    Q     7_A      L       8           -
LGA    R     8_A      R       9           -
LGA    I     9_A      T      10           -
LGA    L    10_A      Y      11           -
LGA    R    11_A      V      12           -
LGA    Y    12_A      E      13           -
LGA    V    13_A      S      14           -
LGA    Q    14_A      T      15           -
LGA    Q    15_A      T      16           -
LGA    N    16_A      E      17           -
LGA    A    17_A      T      18           -
LGA    K    18_A      -       -           -
LGA    P    19_A      -       -           -
LGA    G    20_A      -       -           -
LGA    D    21_A      -       -           -
LGA    P    22_A      -       -           -
LGA    Q    23_A      D      19          2.906
LGA    S    24_A      A      20          1.543
LGA    V    25_A      A      21          1.027
LGA    L    26_A      V      22          0.767
LGA    E    27_A      A      23          2.504
LGA    A    28_A      R      24          3.341
LGA    I    29_A      A      25          3.792
LGA    D    30_A      R      26          3.877
LGA    T    31_A      -       -           -
LGA    Y    32_A      -       -           -
LGA    C    33_A      E      27          4.362
LGA    T    34_A      D      28           -
LGA    Q    35_A      A      29           -
LGA    K    36_A      -       -           -
LGA    E    37_A      -       -           -
LGA    W    38_A      A      30          3.982
LGA    A    39_A      E      31           #
LGA    -       -      F      32           -
LGA    -       -      G      33           -
LGA    -       -      L      34           -
LGA    M    40_A      P      35          1.498
LGA    N    41_A      A      36          1.290
LGA    V    42_A      P      37          1.256
LGA    G    43_A      D      38          2.280
LGA    D    44_A      E      39          0.688
LGA    A    45_A      M      40          2.035
LGA    K    46_A      T      41          1.230
LGA    G    47_A      G      42          0.987
LGA    Q    48_A      Q      43          1.557
LGA    I    49_A      L      44          1.703
LGA    M    50_A      L      45          1.481
LGA    D    51_A      T      46          1.744
LGA    A    52_A      T      47          1.910
LGA    V    53_A      L      48          1.711
LGA    I    54_A      A      49          1.788
LGA    R    55_A      A      50          2.097
LGA    E    56_A      T      51          2.049
LGA    Y    57_A      T      52          1.703
LGA    S    58_A      N      53          4.204
LGA    P    59_A      G      54          3.860
LGA    -       -      N      55           -
LGA    -       -      G      56           -
LGA    S    60_A      S      57          3.822
LGA    L    61_A      T      58          3.143
LGA    -       -      G      59           -
LGA    V    62_A      A      60          0.902
LGA    L    63_A      I      61          1.329
LGA    E    64_A      A      62          1.447
LGA    L    65_A      I      63          1.209
LGA    G    66_A      T      64          1.374
LGA    A    67_A      P      65          4.172
LGA    Y    68_A      A      66          2.361
LGA    C    69_A      A      67          5.257
LGA    G    70_A      G      68          0.919
LGA    Y    71_A      L      69          0.464
LGA    S    72_A      V      70          0.281
LGA    A    73_A      G      71          0.870
LGA    V    74_A      L      72          1.317
LGA    R    75_A      Y      73          1.271
LGA    M    76_A      I      74          0.625
LGA    A    77_A      L      75          1.231
LGA    R    78_A      N      76          2.331
LGA    L    79_A      G      77          1.895
LGA    L    80_A      L      78          1.398
LGA    Q    81_A      A      79          1.295
LGA    P    82_A      D      80          1.606
LGA    G    83_A      N      81          0.739
LGA    A    84_A      T      82          1.385
LGA    R    85_A      T      83          1.126
LGA    L    86_A      L      84          1.086
LGA    L    87_A      T      85          0.805
LGA    T    88_A      C      86          1.140
LGA    M    89_A      I      87          0.729
LGA    E    90_A      D      88          0.777
LGA    M    91_A      P      89          1.162
LGA    N    92_A      E      90          1.039
LGA    P    93_A      S      91          1.311
LGA    D    94_A      E      92          1.604
LGA    Y    95_A      H      93          0.986
LGA    A    96_A      Q      94          1.246
LGA    A    97_A      R      95          1.470
LGA    I    98_A      Q      96          1.139
LGA    T    99_A      A      97          0.923
LGA    Q   100_A      K      98          1.169
LGA    Q   101_A      A      99          1.114
LGA    M   102_A      L     100          1.246
LGA    L   103_A      F     101          1.132
LGA    N   104_A      R     102          0.977
LGA    F   105_A      E     103          1.058
LGA    A   106_A      A     104          1.062
LGA    G   107_A      G     105          2.391
LGA    L   108_A      Y     106          2.119
LGA    -       -      S     107           -
LGA    Q   109_A      P     108          2.997
LGA    D   110_A      S     109          2.462
LGA    K   111_A      R     110          1.159
LGA    V   112_A      V     111          1.037
LGA    T   113_A      R     112          0.366
LGA    I   114_A      F     113          0.602
LGA    L   115_A      L     114          0.580
LGA    N   116_A      L     115          0.744
LGA    G   117_A      S     116          0.369
LGA    A   118_A      R     117          0.657
LGA    S   119_A      P     118          1.246
LGA    Q   120_A      L     119          1.398
LGA    D   121_A      D     120          1.227
LGA    L   122_A      V     121          0.414
LGA    I   123_A      M     122          0.666
LGA    P   124_A      S     123          0.905
LGA    Q   125_A      R     124          0.970
LGA    L   126_A      L     125          1.233
LGA    K   127_A      A     126          2.994
LGA    K   128_A      -       -           -
LGA    K   129_A      -       -           -
LGA    Y   130_A      -       -           -
LGA    D   131_A      -       -           -
LGA    V   132_A      N     127          6.167
LGA    D   133_A      D     128          4.856
LGA    T   134_A      S     129          2.117
LGA    L   135_A      Y     130          1.491
LGA    D   136_A      Q     131          1.284
LGA    M   137_A      L     132          1.320
LGA    V   138_A      V     133          0.919
LGA    F   139_A      F     134          0.726
LGA    L   140_A      G     135          1.082
LGA    D   141_A      Q     136          1.127
LGA    H   142_A      V     137          2.527
LGA    W   143_A      S     138          2.822
LGA    K   144_A      P     139          3.011
LGA    D   145_A      M     140          1.968
LGA    R   146_A      D     141          1.646
LGA    Y   147_A      L     142          2.029
LGA    L   148_A      K     143          1.044
LGA    P   149_A      A     144          0.568
LGA    D   150_A      L     145          2.012
LGA    T   151_A      V     146          1.407
LGA    L   152_A      D     147          1.096
LGA    L   153_A      A     148          2.619
LGA    L   154_A      A     149          3.278
LGA    E   155_A      W     150          3.832
LGA    K   156_A      -       -           -
LGA    C   157_A      -       -           -
LGA    G   158_A      P     151          3.661
LGA    L   159_A      L     152          1.981
LGA    L   160_A      L     153          2.931
LGA    R   161_A      R     154          3.334
LGA    K   162_A      R     155          2.632
LGA    G   163_A      G     156          2.300
LGA    T   164_A      G     157          2.084
LGA    V   165_A      A     158          0.982
LGA    L   166_A      L     159          0.804
LGA    L   167_A      V     160          1.077
LGA    A   168_A      L     161          1.130
LGA    D   169_A      A     162          0.765
LGA    N   170_A      D     163          0.675
LGA    V   171_A      A     164          1.901
LGA    I   172_A      L     165          2.781
LGA    V   173_A      L     166          3.134
LGA    P   174_A      -       -           -
LGA    G   175_A      D     167          6.158
LGA    T   176_A      G     168           -
LGA    -       -      T     169           -
LGA    -       -      I     170           -
LGA    -       -      A     171           -
LGA    -       -      D     172           -
LGA    -       -      Q     173           -
LGA    -       -      T     174           -
LGA    -       -      R     175           -
LGA    -       -      K     176           -
LGA    -       -      D     177           -
LGA    -       -      R     178           -
LGA    -       -      D     179           -
LGA    -       -      T     180           -
LGA    -       -      Q     181           -
LGA    -       -      A     182           -
LGA    P   177_A      A     183          1.920
LGA    -       -      R     184           -
LGA    D   178_A      D     185          2.758
LGA    F   179_A      A     186          2.218
LGA    L   180_A      D     187          1.600
LGA    A   181_A      E     188          1.547
LGA    Y   182_A      Y     189          1.279
LGA    V   183_A      I     190          1.289
LGA    R   184_A      R     191          1.437
LGA    G   185_A      S     192          2.286
LGA    S   186_A      I     193          2.273
LGA    S   187_A      E     194          2.400
LGA    S   188_A      G     195          3.178
LGA    F   189_A      A     196          1.626
LGA    E   190_A      H     197          0.943
LGA    C   191_A      V     198          1.049
LGA    T   192_A      A     199          1.363
LGA    H   193_A      R     200          1.936
LGA    Y   194_A      L     201          2.084
LGA    S   195_A      P     202          1.152
LGA    S   196_A      L     203          2.449
LGA    Y   197_A      G     204          3.837
LGA    L   198_A      -       -           -
LGA    E   199_A      -       -           -
LGA    Y   200_A      -       -           -
LGA    M   201_A      -       -           -
LGA    K   202_A      -       -           -
LGA    V   203_A      -       -           -
LGA    V   204_A      -       -           -
LGA    D   205_A      A     205          2.422
LGA    G   206_A      G     206          2.528
LGA    L   207_A      L     207          1.706
LGA    E   208_A      T     208          1.580
LGA    K   209_A      V     209          1.610
LGA    A   210_A      V     210          0.550
LGA    I   211_A      T     211          1.063
LGA    Y   212_A      K     212          1.938
LGA    Q   213_A      A     213          3.296
LGA    G   214_A      -       -           -
LGA    P   215_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  214  211    5.0    169    2.11    14.79     66.876     7.641

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.714268 * X  +   0.683408 * Y  +  -0.150915 * Z  +  25.482935
  Y_new =  -0.631612 * X  +  -0.722324 * Y  +  -0.281628 * Z  +  55.685879
  Z_new =  -0.301476 * X  +  -0.105839 * Y  +   0.947581 * Z  + 106.097626 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.111233    3.030360  [ DEG:    -6.3732    173.6268 ]
  Theta =   0.306241    2.835352  [ DEG:    17.5463    162.4537 ]
  Phi   =  -2.417532    0.724061  [ DEG:  -138.5144     41.4856 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cl5_A                                        
REMARK     2: T0509.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cl5_A.T0509.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  214  211   5.0  169   2.11   14.79  66.876
REMARK  ---------------------------------------------------------- 
MOLECULE 2cl5_A
HEADER    TRANSFERASE                             26-APR-06   2CL5              
TITLE     CATECHOL-O-METHYLTRANSFERASE IN COMPLEX WITH AN INHIBITOR             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CATECHOL O-METHYLTRANSFERASE;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 2.1.1.6;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_VECTOR: PCAL-N-FLAG (STRATAGENE);                  
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: QIAGEN MIDI                               
KEYWDS    ALTERNATIVE INITIATION, CATECHOLAMINE METABOLISM,                     
KEYWDS   2 NEUROTRANSMITTER DEGRADATION, CATECHOL-O-METHYLTRANSFERASE,          
KEYWDS   3 PHOSPHORYLATION, METHYLTRANSFERASE, SIGNAL-ANCHOR,                   
KEYWDS   4 TRANSMEMBRANE, COMT INHIBITOR, MEMBRANE, MAGNESIUM,                  
KEYWDS   5 TRANSFERASE, METAL-BINDING                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.N.PALMA,M.L.RODRIGUES,M.ARCHER,M.J.BONIFACIO,A.I.LOUREIRO,          
AUTHOR   2 D.LEARMONTH,M.A.CARRONDO,P.SOARES-DA-SILVA                           
REVDAT   1   28-JUN-06 2CL5    0                                                
JRNL        AUTH   P.N.PALMA,M.L.RODRIGUES,M.ARCHER,M.J.BONIFACIO,              
JRNL        AUTH 2 A.I.LOUREIRO,D.A.LEARMONTH,M.A.CARRONDO,                     
JRNL        AUTH 3 P.SOARES-DA-SILVA                                            
JRNL        TITL   COMPARATIVE STUDY OF ORTHO- AND META-NITRATED                
JRNL        TITL 2 INHIBITORS OF CATECHOL-O-METHYLTRANSFERASE:                  
JRNL        TITL 3 INTERACTIONS WITH THE ACTIVE SITE AND                        
JRNL        TITL 4 REGIOSELECTIVITY OF O-METHYLATION.                           
JRNL        REF    MOL.PHARMACOL.                V.  70   143 2006              
JRNL        REFN   ASTM MOPMA3  US ISSN 0026-895X                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2CL5 A    1   221  UNP    P22734   COMT_RAT        44    264             
DBREF  2CL5 B    1   221  UNP    P22734   COMT_RAT        44    264             
SEQRES   1 A  221  MET GLY ASP THR LYS GLU GLN ARG ILE LEU ARG TYR VAL          
SEQRES   2 A  221  GLN GLN ASN ALA LYS PRO GLY ASP PRO GLN SER VAL LEU          
SEQRES   3 A  221  GLU ALA ILE ASP THR TYR CYS THR GLN LYS GLU TRP ALA          
SEQRES   4 A  221  MET ASN VAL GLY ASP ALA LYS GLY GLN ILE MET ASP ALA          
SEQRES   5 A  221  VAL ILE ARG GLU TYR SER PRO SER LEU VAL LEU GLU LEU          
SEQRES   6 A  221  GLY ALA TYR CYS GLY TYR SER ALA VAL ARG MET ALA ARG          
SEQRES   7 A  221  LEU LEU GLN PRO GLY ALA ARG LEU LEU THR MET GLU MET          
SEQRES   8 A  221  ASN PRO ASP TYR ALA ALA ILE THR GLN GLN MET LEU ASN          
SEQRES   9 A  221  PHE ALA GLY LEU GLN ASP LYS VAL THR ILE LEU ASN GLY          
SEQRES  10 A  221  ALA SER GLN ASP LEU ILE PRO GLN LEU LYS LYS LYS TYR          
SEQRES  11 A  221  ASP VAL ASP THR LEU ASP MET VAL PHE LEU ASP HIS TRP          
SEQRES  12 A  221  LYS ASP ARG TYR LEU PRO ASP THR LEU LEU LEU GLU LYS          
SEQRES  13 A  221  CYS GLY LEU LEU ARG LYS GLY THR VAL LEU LEU ALA ASP          
SEQRES  14 A  221  ASN VAL ILE VAL PRO GLY THR PRO ASP PHE LEU ALA TYR          
SEQRES  15 A  221  VAL ARG GLY SER SER SER PHE GLU CYS THR HIS TYR SER          
SEQRES  16 A  221  SER TYR LEU GLU TYR MET LYS VAL VAL ASP GLY LEU GLU          
SEQRES  17 A  221  LYS ALA ILE TYR GLN GLY PRO SER SER PRO ASP LYS SER          
SEQRES   1 B  221  MET GLY ASP THR LYS GLU GLN ARG ILE LEU ARG TYR VAL          
SEQRES   2 B  221  GLN GLN ASN ALA LYS PRO GLY ASP PRO GLN SER VAL LEU          
SEQRES   3 B  221  GLU ALA ILE ASP THR TYR CYS THR GLN LYS GLU TRP ALA          
SEQRES   4 B  221  MET ASN VAL GLY ASP ALA LYS GLY GLN ILE MET ASP ALA          
SEQRES   5 B  221  VAL ILE ARG GLU TYR SER PRO SER LEU VAL LEU GLU LEU          
SEQRES   6 B  221  GLY ALA TYR CYS GLY TYR SER ALA VAL ARG MET ALA ARG          
SEQRES   7 B  221  LEU LEU GLN PRO GLY ALA ARG LEU LEU THR MET GLU MET          
SEQRES   8 B  221  ASN PRO ASP TYR ALA ALA ILE THR GLN GLN MET LEU ASN          
SEQRES   9 B  221  PHE ALA GLY LEU GLN ASP LYS VAL THR ILE LEU ASN GLY          
SEQRES  10 B  221  ALA SER GLN ASP LEU ILE PRO GLN LEU LYS LYS LYS TYR          
SEQRES  11 B  221  ASP VAL ASP THR LEU ASP MET VAL PHE LEU ASP HIS TRP          
SEQRES  12 B  221  LYS ASP ARG TYR LEU PRO ASP THR LEU LEU LEU GLU LYS          
SEQRES  13 B  221  CYS GLY LEU LEU ARG LYS GLY THR VAL LEU LEU ALA ASP          
SEQRES  14 B  221  ASN VAL ILE VAL PRO GLY THR PRO ASP PHE LEU ALA TYR          
SEQRES  15 B  221  VAL ARG GLY SER SER SER PHE GLU CYS THR HIS TYR SER          
SEQRES  16 B  221  SER TYR LEU GLU TYR MET LYS VAL VAL ASP GLY LEU GLU          
SEQRES  17 B  221  LYS ALA ILE TYR GLN GLY PRO SER SER PRO ASP LYS SER          
HET     MG  A1216       1                                                       
HET     MG  B1216       1                                                       
HET    SAM  A1217      27                                                       
HET    SAM  B1217      27                                                       
HET    BIE  A1218      19                                                       
HET    BU3  A1219       6                                                       
HET    BU3  A1220       6                                                       
HET    MES  B1215      12                                                       
HET    BIE  B1218      19                                                       
HET    BU3  B1219       6                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
HETNAM     BIE (3,4-DIHYDROXY-2-NITROPHENYL)(PHENYL)METHANONE                   
HETNAM     BU3 (R,R)-2,3-BUTANEDIOL                                             
HETNAM     MES 2-(N-MORPHOLINO)-ETHANESULFONIC ACID                             
HETSYN     BIE BIA 3-335                                                        
FORMUL   3   MG    2(MG 2+)                                                     
FORMUL   5  SAM    2(C15 H22 N6 O5 S)                                           
FORMUL   7  BIE    2(C13 H9 N O5)                                               
FORMUL   8  BU3    3(C4 H10 O2)                                                 
FORMUL  10  MES    C6 H13 N O4 S                                                
FORMUL  13  HOH   *554(H2 O)                                                    
CRYST1   52.767   79.627   61.540  90.00  91.14  90.00 P 1 21 1      4          
ATOM      1  N   GLY A   2      19.856  19.469 142.567  1.00 26.78           N  
ATOM      2  CA  GLY A   2      20.979  20.052 143.355  1.00 25.90           C  
ATOM      3  C   GLY A   2      20.639  20.075 144.835  1.00 24.75           C  
ATOM      4  O   GLY A   2      19.467  20.176 145.219  1.00 26.30           O  
ATOM      5  N   ASP A   3      21.668  19.996 145.661  1.00 21.62           N  
ATOM      6  CA  ASP A   3      21.506  19.879 147.105  1.00 19.93           C  
ATOM      7  C   ASP A   3      21.133  21.224 147.697  1.00 17.24           C  
ATOM      8  O   ASP A   3      21.504  22.274 147.194  1.00 17.09           O  
ATOM      9  CB  ASP A   3      22.773  19.382 147.765  1.00 20.41           C  
ATOM     10  CG  ASP A   3      22.517  18.758 149.104  1.00 22.62           C  
ATOM     11  OD1 ASP A   3      23.465  18.601 149.882  1.00 27.25           O  
ATOM     12  OD2 ASP A   3      21.391  18.374 149.480  1.00 24.16           O  
ATOM     13  N   THR A   4      20.344  21.161 148.740  1.00 14.77           N  
ATOM     14  CA  THR A   4      19.818  22.356 149.427  1.00 13.32           C  
ATOM     15  C   THR A   4      19.944  22.187 150.939  1.00 12.18           C  
ATOM     16  O   THR A   4      20.073  21.083 151.489  1.00 11.53           O  
ATOM     17  CB  THR A   4      18.326  22.593 149.102  1.00 13.71           C  
ATOM     18  OG1 THR A   4      17.539  21.495 149.617  1.00 13.60           O  
ATOM     19  CG2 THR A   4      18.095  22.626 147.604  1.00 14.41           C  
ATOM     20  N   LYS A   5      19.790  23.311 151.633  1.00 10.85           N  
ATOM     21  CA  LYS A   5      19.783  23.323 153.083  1.00 11.02           C  
ATOM     22  C   LYS A   5      18.747  22.365 153.648  1.00 11.09           C  
ATOM     23  O   LYS A   5      18.996  21.659 154.620  1.00 11.79           O  
ATOM     24  CB  LYS A   5      19.469  24.744 153.585  1.00 11.30           C  
ATOM     25  CG  LYS A   5      19.280  24.840 155.070  1.00 11.46           C  
ATOM     26  CD  LYS A   5      18.850  26.262 155.510  1.00 12.33           C  
ATOM     27  CE  LYS A   5      19.798  27.384 155.219  1.00 14.07           C  
ATOM     28  NZ  LYS A   5      21.135  27.247 155.813  1.00 13.32           N  
ATOM     29  N   GLU A   6      17.564  22.373 153.030  1.00 11.09           N  
ATOM     30  CA  GLU A   6      16.452  21.613 153.579  1.00 11.94           C  
ATOM     31  C   GLU A   6      16.690  20.099 153.419  1.00 12.55           C  
ATOM     32  O   GLU A   6      16.348  19.304 154.314  1.00 11.25           O  
ATOM     33  CB  GLU A   6      15.128  22.043 152.988  1.00 12.51           C  
ATOM     34  CG  GLU A   6      14.813  23.503 153.276  1.00 12.31           C  
ATOM     35  CD  GLU A   6      15.604  24.495 152.437  1.00 14.39           C  
ATOM     36  OE1 GLU A   6      16.008  24.187 151.298  1.00 13.45           O  
ATOM     37  OE2 GLU A   6      15.860  25.621 152.935  1.00 13.27           O  
ATOM     38  N   GLN A   7      17.299  19.729 152.307  1.00 13.09           N  
ATOM     39  CA  GLN A   7      17.707  18.339 152.101  1.00 14.06           C  
ATOM     40  C   GLN A   7      18.760  17.937 153.102  1.00 13.76           C  
ATOM     41  O   GLN A   7      18.741  16.812 153.615  1.00 13.77           O  
ATOM     42  CB  GLN A   7      18.215  18.116 150.667  1.00 14.55           C  
ATOM     43  CG  GLN A   7      17.125  18.169 149.617  1.00 15.33           C  
ATOM     44  CD  GLN A   7      17.674  17.998 148.240  1.00 22.75           C  
ATOM     45  OE1 GLN A   7      18.003  16.876 147.846  1.00 26.00           O  
ATOM     46  NE2 GLN A   7      17.796  19.085 147.497  1.00 22.42           N  
ATOM     47  N   ARG A   8      19.720  18.834 153.382  1.00 13.14           N  
ATOM     48  CA  ARG A   8      20.774  18.533 154.361  1.00 12.64           C  
ATOM     49  C   ARG A   8      20.196  18.306 155.751  1.00 12.22           C  
ATOM     50  O   ARG A   8      20.601  17.389 156.453  1.00 13.29           O  
ATOM     51  CB  ARG A   8      21.813  19.648 154.384  1.00 13.28           C  
ATOM     52  CG  ARG A   8      22.670  19.700 153.148  1.00 13.10           C  
ATOM     53  CD  ARG A   8      23.835  20.648 153.238  1.00 14.51           C  
ATOM     54  NE  ARG A   8      23.464  22.066 153.311  1.00 12.39           N  
ATOM     55  CZ  ARG A   8      23.321  22.880 152.262  1.00 11.61           C  
ATOM     56  NH1 ARG A   8      23.496  22.473 151.011  1.00 14.42           N  
ATOM     57  NH2 ARG A   8      23.015  24.146 152.479  1.00 12.62           N  
ATOM     58  N   ILE A   9      19.201  19.103 156.131  1.00 11.60           N  
ATOM     59  CA  ILE A   9      18.556  18.948 157.427  1.00 11.92           C  
ATOM     60  C   ILE A   9      17.855  17.589 157.501  1.00 12.26           C  
ATOM     61  O   ILE A   9      18.035  16.850 158.457  1.00 12.38           O  
ATOM     62  CB  ILE A   9      17.584  20.112 157.702  1.00 12.09           C  
ATOM     63  CG1 ILE A   9      18.347  21.434 157.848  1.00 11.68           C  
ATOM     64  CG2 ILE A   9      16.802  19.817 158.960  1.00 13.30           C  
ATOM     65  CD1 ILE A   9      17.392  22.647 157.870  1.00 13.67           C  
ATOM     66  N   LEU A  10      17.064  17.286 156.482  1.00 12.77           N  
ATOM     67  CA  LEU A  10      16.351  16.012 156.442  1.00 13.76           C  
ATOM     68  C   LEU A  10      17.312  14.812 156.471  1.00 13.78           C  
ATOM     69  O   LEU A  10      17.098  13.871 157.218  1.00 13.94           O  
ATOM     70  CB  LEU A  10      15.471  15.926 155.200  1.00 13.13           C  
ATOM     71  CG  LEU A  10      14.704  14.594 155.054  1.00 13.98           C  
ATOM     72  CD1 LEU A  10      13.836  14.333 156.321  1.00 14.31           C  
ATOM     73  CD2 LEU A  10      13.908  14.593 153.765  1.00 14.35           C  
ATOM     74  N   ARG A  11      18.353  14.857 155.677  1.00 13.98           N  
ATOM     75  CA  ARG A  11      19.346  13.767 155.680  1.00 13.97           C  
ATOM     76  C   ARG A  11      20.007  13.632 157.055  1.00 13.55           C  
ATOM     77  O   ARG A  11      20.249  12.524 157.522  1.00 14.29           O  
ATOM     78  CB  ARG A  11      20.392  13.969 154.578  1.00 14.64           C  
ATOM     79  CG  ARG A  11      19.876  13.702 153.183  1.00 18.64           C  
ATOM     80  CD  ARG A  11      20.983  13.391 152.163  1.00 22.51           C  
ATOM     81  NE  ARG A  11      22.088  14.324 152.282  1.00 22.73           N  
ATOM     82  CZ  ARG A  11      22.139  15.526 151.689  1.00 23.21           C  
ATOM     83  NH1 ARG A  11      21.172  15.929 150.890  1.00 22.40           N  
ATOM     84  NH2 ARG A  11      23.190  16.304 151.855  1.00 23.38           N  
ATOM     85  N   TYR A  12      20.292  14.748 157.731  1.00 13.43           N  
ATOM     86  CA  TYR A  12      20.871  14.676 159.059  1.00 12.88           C  
ATOM     87  C   TYR A  12      19.931  13.968 160.046  1.00 13.12           C  
ATOM     88  O   TYR A  12      20.346  13.155 160.873  1.00 13.66           O  
ATOM     89  CB  TYR A  12      21.260  16.074 159.582  1.00 12.84           C  
ATOM     90  CG  TYR A  12      22.018  15.994 160.890  1.00 12.09           C  
ATOM     91  CD1 TYR A  12      23.407  15.869 160.917  1.00 14.65           C  
ATOM     92  CD2 TYR A  12      21.333  15.969 162.108  1.00 13.97           C  
ATOM     93  CE1 TYR A  12      24.074  15.826 162.110  1.00 16.01           C  
ATOM     94  CE2 TYR A  12      21.994  15.891 163.294  1.00 14.45           C  
ATOM     95  CZ  TYR A  12      23.361  15.811 163.301  1.00 17.62           C  
ATOM     96  OH  TYR A  12      24.003  15.722 164.523  1.00 20.42           O  
ATOM     97  N   VAL A  13      18.659  14.313 159.982  1.00 13.47           N  
ATOM     98  CA  VAL A  13      17.656  13.681 160.804  1.00 13.32           C  
ATOM     99  C   VAL A  13      17.592  12.165 160.467  1.00 13.73           C  
ATOM    100  O   VAL A  13      17.658  11.347 161.369  1.00 14.46           O  
ATOM    101  CB  VAL A  13      16.284  14.317 160.597  1.00 14.26           C  
ATOM    102  CG1 VAL A  13      15.186  13.465 161.230  1.00 15.45           C  
ATOM    103  CG2 VAL A  13      16.254  15.735 161.228  1.00 13.64           C  
ATOM    104  N   GLN A  14      17.495  11.830 159.194  1.00 13.74           N  
ATOM    105  CA  GLN A  14      17.435  10.399 158.812  1.00 14.02           C  
ATOM    106  C   GLN A  14      18.665   9.621 159.229  1.00 15.12           C  
ATOM    107  O   GLN A  14      18.580   8.414 159.515  1.00 16.06           O  
ATOM    108  CB  GLN A  14      17.220  10.273 157.337  1.00 14.36           C  
ATOM    109  CG  GLN A  14      15.839  10.715 156.936  1.00 14.62           C  
ATOM    110  CD  GLN A  14      15.679  10.944 155.444  1.00 12.47           C  
ATOM    111  OE1 GLN A  14      16.618  11.243 154.731  1.00 16.57           O  
ATOM    112  NE2 GLN A  14      14.469  10.754 154.967  1.00 20.63           N  
ATOM    113  N   GLN A  15      19.797  10.289 159.321  1.00 15.57           N  
ATOM    114  CA  GLN A  15      21.051   9.657 159.694  1.00 16.41           C  
ATOM    115  C   GLN A  15      21.179   9.459 161.191  1.00 16.26           C  
ATOM    116  O   GLN A  15      21.719   8.447 161.629  1.00 17.51           O  
ATOM    117  CB  GLN A  15      22.227  10.516 159.204  1.00 17.16           C  
ATOM    118  CG  GLN A  15      23.607  10.004 159.566  1.00 19.99           C  
ATOM    119  CD  GLN A  15      24.668  10.935 159.025  1.00 22.17           C  
ATOM    120  OE1 GLN A  15      24.655  12.135 159.327  1.00 23.48           O  
ATOM    121  NE2 GLN A  15      25.533  10.422 158.181  1.00 23.15           N  
ATOM    122  N   ASN A  16      20.693  10.418 161.981  1.00 16.00           N  
ATOM    123  CA  ASN A  16      20.999  10.505 163.397  1.00 16.87           C  
ATOM    124  C   ASN A  16      19.844  10.337 164.382  1.00 18.15           C  
ATOM    125  O   ASN A  16      20.068   9.888 165.502  1.00 19.11           O  
ATOM    126  CB  ASN A  16      21.759  11.800 163.670  1.00 17.41           C  
ATOM    127  CG  ASN A  16      23.035  11.871 162.868  1.00 20.47           C  
ATOM    128  OD1 ASN A  16      23.168  12.643 161.898  1.00 20.14           O  
ATOM    129  ND2 ASN A  16      23.964  10.990 163.207  1.00 18.64           N  
ATOM    130  N   ALA A  17      18.621  10.683 163.992  1.00 16.66           N  
ATOM    131  CA  ALA A  17      17.492  10.622 164.891  1.00 17.76           C  
ATOM    132  C   ALA A  17      16.925   9.195 164.910  1.00 18.85           C  
ATOM    133  O   ALA A  17      17.169   8.384 164.012  1.00 19.77           O  
ATOM    134  CB  ALA A  17      16.425  11.612 164.453  1.00 16.88           C  
ATOM    135  N   LYS A  18      16.128   8.920 165.924  1.00 21.39           N  
ATOM    136  CA  LYS A  18      15.515   7.595 166.078  1.00 23.02           C  
ATOM    137  C   LYS A  18      14.170   7.603 165.368  1.00 23.40           C  
ATOM    138  O   LYS A  18      13.327   8.446 165.680  1.00 23.54           O  
ATOM    139  CB  LYS A  18      15.340   7.290 167.557  1.00 23.91           C  
ATOM    140  CG  LYS A  18      16.655   7.154 168.312  1.00 28.93           C  
ATOM    141  CD  LYS A  18      16.471   6.544 169.730  1.00 34.41           C  
ATOM    142  CE  LYS A  18      17.045   7.430 170.827  1.00 36.17           C  
ATOM    143  NZ  LYS A  18      18.483   7.113 171.065  1.00 40.82           N  
ATOM    144  N   PRO A  19      13.945   6.717 164.397  1.00 24.21           N  
ATOM    145  CA  PRO A  19      12.637   6.647 163.749  1.00 23.83           C  
ATOM    146  C   PRO A  19      11.485   6.483 164.753  1.00 23.35           C  
ATOM    147  O   PRO A  19      11.583   5.736 165.743  1.00 22.43           O  
ATOM    148  CB  PRO A  19      12.761   5.424 162.821  1.00 24.60           C  
ATOM    149  CG  PRO A  19      14.193   5.309 162.571  1.00 25.24           C  
ATOM    150  CD  PRO A  19      14.887   5.728 163.828  1.00 24.74           C  
ATOM    151  N   GLY A  20      10.415   7.239 164.526  1.00 22.84           N  
ATOM    152  CA  GLY A  20       9.234   7.247 165.375  1.00 22.21           C  
ATOM    153  C   GLY A  20       9.321   7.987 166.710  1.00 21.63           C  
ATOM    154  O   GLY A  20       8.430   7.867 167.554  1.00 21.95           O  
ATOM    155  N   ASP A  21      10.405   8.736 166.922  1.00 20.72           N  
ATOM    156  CA  ASP A  21      10.651   9.412 168.187  1.00 19.83           C  
ATOM    157  C   ASP A  21      10.719  10.932 167.897  1.00 19.39           C  
ATOM    158  O   ASP A  21      11.782  11.428 167.485  1.00 19.34           O  
ATOM    159  CB  ASP A  21      11.962   8.883 168.791  1.00 20.46           C  
ATOM    160  CG  ASP A  21      12.327   9.534 170.100  1.00 22.24           C  
ATOM    161  OD1 ASP A  21      11.820  10.622 170.404  1.00 21.92           O  
ATOM    162  OD2 ASP A  21      13.149   9.014 170.875  1.00 24.55           O  
ATOM    163  N   PRO A  22       9.595  11.640 168.043  1.00 18.23           N  
ATOM    164  CA  PRO A  22       9.564  13.082 167.755  1.00 17.41           C  
ATOM    165  C   PRO A  22      10.612  13.895 168.493  1.00 17.72           C  
ATOM    166  O   PRO A  22      11.197  14.796 167.888  1.00 16.49           O  
ATOM    167  CB  PRO A  22       8.180  13.486 168.192  1.00 16.93           C  
ATOM    168  CG  PRO A  22       7.341  12.264 167.924  1.00 19.03           C  
ATOM    169  CD  PRO A  22       8.242  11.135 168.328  1.00 18.25           C  
ATOM    170  N   GLN A  23      10.847  13.608 169.764  1.00 17.54           N  
ATOM    171  CA  GLN A  23      11.819  14.414 170.510  1.00 17.88           C  
ATOM    172  C   GLN A  23      13.210  14.251 169.916  1.00 17.53           C  
ATOM    173  O   GLN A  23      14.001  15.217 169.864  1.00 17.43           O  
ATOM    174  CB  GLN A  23      11.822  14.090 172.004  1.00 18.92           C  
ATOM    175  CG  GLN A  23      12.638  15.050 172.845  1.00 21.53           C  
ATOM    176  CD  GLN A  23      12.019  16.453 172.945  1.00 27.01           C  
ATOM    177  OE1 GLN A  23      10.797  16.605 173.001  1.00 28.44           O  
ATOM    178  NE2 GLN A  23      12.870  17.472 173.013  1.00 30.39           N  
ATOM    179  N   SER A  24      13.547  13.039 169.495  1.00 16.95           N  
ATOM    180  CA  SER A  24      14.848  12.799 168.887  1.00 17.34           C  
ATOM    181  C   SER A  24      14.982  13.557 167.562  1.00 16.36           C  
ATOM    182  O   SER A  24      16.068  14.049 167.219  1.00 17.08           O  
ATOM    183  CB  SER A  24      15.028  11.297 168.676  0.60 17.22           C  
ATOM    185  OG  SER A  24      16.309  10.965 168.222  0.60 15.92           O  
ATOM    187  N   VAL A  25      13.891  13.656 166.815  1.00 14.57           N  
ATOM    188  CA  VAL A  25      13.873  14.407 165.574  1.00 14.06           C  
ATOM    189  C   VAL A  25      14.149  15.888 165.838  1.00 14.17           C  
ATOM    190  O   VAL A  25      15.010  16.468 165.179  1.00 13.96           O  
ATOM    191  CB  VAL A  25      12.555  14.226 164.811  1.00 14.61           C  
ATOM    192  CG1 VAL A  25      12.403  15.231 163.685  1.00 14.46           C  
ATOM    193  CG2 VAL A  25      12.523  12.783 164.221  1.00 14.40           C  
ATOM    194  N   LEU A  26      13.443  16.466 166.794  1.00 14.22           N  
ATOM    195  CA  LEU A  26      13.698  17.859 167.212  1.00 14.29           C  
ATOM    196  C   LEU A  26      15.133  18.108 167.640  1.00 14.56           C  
ATOM    197  O   LEU A  26      15.739  19.121 167.243  1.00 13.58           O  
ATOM    198  CB  LEU A  26      12.782  18.230 168.368  1.00 14.73           C  
ATOM    199  CG  LEU A  26      11.309  18.233 168.032  1.00 14.96           C  
ATOM    200  CD1 LEU A  26      10.531  18.505 169.321  1.00 15.49           C  
ATOM    201  CD2 LEU A  26      10.938  19.185 166.917  1.00 14.48           C  
ATOM    202  N   GLU A  27      15.680  17.213 168.462  1.00 14.10           N  
ATOM    203  CA  GLU A  27      17.024  17.369 168.993  1.00 15.60           C  
ATOM    204  C   GLU A  27      18.041  17.284 167.872  1.00 14.00           C  
ATOM    205  O   GLU A  27      19.023  18.002 167.889  1.00 14.51           O  
ATOM    206  CB  GLU A  27      17.270  16.335 170.099  1.00 17.07           C  
ATOM    207  CG  GLU A  27      16.463  16.706 171.332  1.00 23.10           C  
ATOM    208  CD  GLU A  27      16.599  15.723 172.489  1.00 30.84           C  
ATOM    209  OE1 GLU A  27      17.388  14.764 172.377  1.00 37.13           O  
ATOM    210  OE2 GLU A  27      15.903  15.947 173.509  1.00 34.12           O  
ATOM    211  N   ALA A  28      17.796  16.416 166.894  1.00 13.85           N  
ATOM    212  CA  ALA A  28      18.682  16.275 165.729  1.00 12.74           C  
ATOM    213  C   ALA A  28      18.700  17.550 164.893  1.00 12.56           C  
ATOM    214  O   ALA A  28      19.766  18.038 164.516  1.00 11.90           O  
ATOM    215  CB  ALA A  28      18.308  15.098 164.916  1.00 13.41           C  
ATOM    216  N   ILE A  29      17.520  18.074 164.574  1.00 12.47           N  
ATOM    217  CA  ILE A  29      17.413  19.312 163.848  1.00 11.80           C  
ATOM    218  C   ILE A  29      18.161  20.417 164.593  1.00 12.20           C  
ATOM    219  O   ILE A  29      18.964  21.153 164.002  1.00 11.52           O  
ATOM    220  CB  ILE A  29      15.939  19.711 163.603  1.00 12.04           C  
ATOM    221  CG1 ILE A  29      15.292  18.708 162.649  1.00 13.21           C  
ATOM    222  CG2 ILE A  29      15.850  21.127 162.969  1.00 10.21           C  
ATOM    223  CD1 ILE A  29      13.847  18.882 162.415  1.00 13.88           C  
ATOM    224  N   ASP A  30      17.897  20.536 165.877  1.00 11.73           N  
ATOM    225  CA  ASP A  30      18.503  21.623 166.664  1.00 12.43           C  
ATOM    226  C   ASP A  30      20.007  21.479 166.771  1.00 11.83           C  
ATOM    227  O   ASP A  30      20.715  22.492 166.731  1.00 12.68           O  
ATOM    228  CB  ASP A  30      17.841  21.727 168.033  1.00 12.39           C  
ATOM    229  CG  ASP A  30      16.460  22.355 167.976  1.00 11.78           C  
ATOM    230  OD1 ASP A  30      16.169  23.155 167.024  1.00 15.40           O  
ATOM    231  OD2 ASP A  30      15.591  22.112 168.849  1.00 16.60           O  
ATOM    232  N   THR A  31      20.501  20.258 166.888  1.00 12.89           N  
ATOM    233  CA  THR A  31      21.936  20.010 166.923  1.00 12.80           C  
ATOM    234  C   THR A  31      22.585  20.403 165.587  1.00 12.55           C  
ATOM    235  O   THR A  31      23.557  21.147 165.566  1.00 12.73           O  
ATOM    236  CB  THR A  31      22.209  18.536 167.289  1.00 13.99           C  
ATOM    237  OG1 THR A  31      21.788  18.297 168.654  1.00 16.19           O  
ATOM    238  CG2 THR A  31      23.670  18.267 167.286  1.00 15.84           C  
ATOM    239  N   TYR A  32      22.020  19.926 164.474  1.00 12.54           N  
ATOM    240  CA  TYR A  32      22.524  20.253 163.149  1.00 12.23           C  
ATOM    241  C   TYR A  32      22.515  21.782 162.934  1.00 12.58           C  
ATOM    242  O   TYR A  32      23.481  22.359 162.444  1.00 13.57           O  
ATOM    243  CB  TYR A  32      21.717  19.515 162.045  1.00 12.03           C  
ATOM    244  CG  TYR A  32      22.225  19.855 160.682  1.00 11.79           C  
ATOM    245  CD1 TYR A  32      23.394  19.282 160.214  1.00 12.22           C  
ATOM    246  CD2 TYR A  32      21.595  20.820 159.895  1.00 11.32           C  
ATOM    247  CE1 TYR A  32      23.917  19.612 159.005  1.00 13.08           C  
ATOM    248  CE2 TYR A  32      22.127  21.174 158.671  1.00 12.02           C  
ATOM    249  CZ  TYR A  32      23.297  20.585 158.237  1.00 11.03           C  
ATOM    250  OH  TYR A  32      23.848  20.933 157.022  1.00 15.00           O  
ATOM    251  N   CYS A  33      21.448  22.451 163.326  1.00 12.33           N  
ATOM    252  CA  CYS A  33      21.307  23.876 162.998  1.00 13.10           C  
ATOM    253  C   CYS A  33      22.180  24.738 163.928  1.00 13.85           C  
ATOM    254  O   CYS A  33      22.585  25.853 163.559  1.00 16.55           O  
ATOM    255  CB  CYS A  33      19.842  24.280 162.979  1.00 12.63           C  
ATOM    256  SG  CYS A  33      18.940  23.532 161.596  1.00 13.05           S  
ATOM    257  N   THR A  34      22.482  24.227 165.109  1.00 13.98           N  
ATOM    258  CA  THR A  34      23.351  24.932 166.046  1.00 14.90           C  
ATOM    259  C   THR A  34      24.813  24.758 165.628  1.00 15.82           C  
ATOM    260  O   THR A  34      25.606  25.706 165.712  1.00 16.79           O  
ATOM    261  CB  THR A  34      23.130  24.336 167.467  1.00 15.79           C  
ATOM    262  OG1 THR A  34      21.808  24.649 167.914  1.00 15.56           O  
ATOM    263  CG2 THR A  34      24.089  24.945 168.509  1.00 18.58           C  
ATOM    264  N   GLN A  35      25.170  23.555 165.206  1.00 16.04           N  
ATOM    265  CA  GLN A  35      26.574  23.210 164.973  1.00 16.53           C  
ATOM    266  C   GLN A  35      27.043  23.429 163.551  1.00 16.60           C  
ATOM    267  O   GLN A  35      28.240  23.724 163.325  1.00 18.33           O  
ATOM    268  CB  GLN A  35      26.830  21.767 165.324  1.00 16.53           C  
ATOM    269  CG  GLN A  35      26.648  21.509 166.812  1.00 19.07           C  
ATOM    270  CD  GLN A  35      26.928  20.087 167.236  1.00 22.82           C  
ATOM    271  OE1 GLN A  35      27.098  19.187 166.415  1.00 27.03           O  
ATOM    272  NE2 GLN A  35      26.928  19.870 168.542  1.00 27.69           N  
ATOM    273  N   LYS A  36      26.148  23.257 162.580  1.00 15.26           N  
ATOM    274  CA  LYS A  36      26.575  23.236 161.193  1.00 14.91           C  
ATOM    275  C   LYS A  36      26.017  24.360 160.317  1.00 14.01           C  
ATOM    276  O   LYS A  36      26.746  24.941 159.517  1.00 13.40           O  
ATOM    277  CB  LYS A  36      26.250  21.877 160.568  1.00 15.40           C  
ATOM    278  CG  LYS A  36      26.773  20.658 161.354  1.00 21.02           C  
ATOM    279  CD  LYS A  36      28.267  20.489 161.317  1.00 27.79           C  
ATOM    280  CE  LYS A  36      28.664  19.146 161.980  1.00 30.00           C  
ATOM    281  NZ  LYS A  36      30.040  19.227 162.543  1.00 32.95           N  
ATOM    282  N   GLU A  37      24.722  24.611 160.440  1.00 13.55           N  
ATOM    283  CA  GLU A  37      24.050  25.459 159.493  1.00 13.03           C  
ATOM    284  C   GLU A  37      22.779  26.051 160.070  1.00 12.49           C  
ATOM    285  O   GLU A  37      21.884  25.285 160.433  1.00 12.41           O  
ATOM    286  CB  GLU A  37      23.702  24.541 158.309  1.00 15.50           C  
ATOM    287  CG  GLU A  37      23.043  25.220 157.207  1.00 16.20           C  
ATOM    288  CD  GLU A  37      22.854  24.386 155.952  1.00 10.86           C  
ATOM    289  OE1 GLU A  37      22.988  23.119 155.891  1.00 13.66           O  
ATOM    290  OE2 GLU A  37      22.526  25.105 155.046  1.00 15.18           O  
ATOM    291  N   TRP A  38      22.675  27.390 160.130  1.00 10.70           N  
ATOM    292  CA  TRP A  38      21.463  28.044 160.615  1.00 10.29           C  
ATOM    293  C   TRP A  38      20.273  27.659 159.728  1.00 10.96           C  
ATOM    294  O   TRP A  38      20.420  27.372 158.538  1.00 11.47           O  
ATOM    295  CB  TRP A  38      21.626  29.571 160.573  1.00 10.96           C  
ATOM    296  CG  TRP A  38      20.533  30.296 161.231  1.00 10.32           C  
ATOM    297  CD1 TRP A  38      20.382  30.532 162.580  1.00 12.71           C  
ATOM    298  CD2 TRP A  38      19.378  30.863 160.598  1.00  9.50           C  
ATOM    299  NE1 TRP A  38      19.204  31.199 162.808  1.00 12.22           N  
ATOM    300  CE2 TRP A  38      18.581  31.424 161.604  1.00 10.70           C  
ATOM    301  CE3 TRP A  38      18.932  30.948 159.268  1.00 12.37           C  
ATOM    302  CZ2 TRP A  38      17.384  32.074 161.328  1.00  9.11           C  
ATOM    303  CZ3 TRP A  38      17.705  31.573 159.008  1.00 10.74           C  
ATOM    304  CH2 TRP A  38      16.972  32.140 160.031  1.00  9.69           C  
ATOM    305  N   ALA A  39      19.091  27.642 160.337  1.00 10.46           N  
ATOM    306  CA  ALA A  39      17.837  27.582 159.585  1.00  9.81           C  
ATOM    307  C   ALA A  39      16.722  28.259 160.333  1.00  8.65           C  
ATOM    308  O   ALA A  39      16.717  28.301 161.577  1.00 10.38           O  
ATOM    309  CB  ALA A  39      17.486  26.109 159.286  1.00 10.00           C  
ATOM    310  N   MET A  40      15.702  28.649 159.593  1.00  8.52           N  
ATOM    311  CA  MET A  40      14.560  29.405 160.129  1.00  9.44           C  
ATOM    312  C   MET A  40      13.482  28.585 160.855  1.00 10.54           C  
ATOM    313  O   MET A  40      12.289  28.933 160.826  1.00 11.24           O  
ATOM    314  CB  MET A  40      13.973  30.313 159.043  1.00 10.78           C  
ATOM    315  CG  MET A  40      13.424  29.538 157.862  1.00  9.68           C  
ATOM    316  SD  MET A  40      12.852  30.712 156.571  1.00 15.24           S  
ATOM    317  CE  MET A  40      12.637  29.597 155.236  1.00 14.99           C  
ATOM    318  N   ASN A  41      13.887  27.534 161.557  1.00 10.13           N  
ATOM    319  CA  ASN A  41      12.994  26.810 162.452  1.00 10.91           C  
ATOM    320  C   ASN A  41      12.712  27.654 163.673  1.00 11.15           C  
ATOM    321  O   ASN A  41      13.591  28.426 164.085  1.00 10.98           O  
ATOM    322  CB  ASN A  41      13.592  25.474 162.916  1.00 10.29           C  
ATOM    323  CG  ASN A  41      14.178  24.668 161.804  1.00 11.19           C  
ATOM    324  OD1 ASN A  41      13.510  24.424 160.793  1.00 13.58           O  
ATOM    325  ND2 ASN A  41      15.464  24.278 161.943  1.00 10.46           N  
ATOM    326  N   VAL A  42      11.560  27.498 164.324  1.00 11.15           N  
ATOM    327  CA  VAL A  42      11.283  28.293 165.533  1.00 10.57           C  
ATOM    328  C   VAL A  42      12.328  28.064 166.614  1.00 11.42           C  
ATOM    329  O   VAL A  42      12.631  28.959 167.418  1.00 11.39           O  
ATOM    330  CB  VAL A  42       9.801  28.091 166.015  1.00 12.57           C  
ATOM    331  CG1 VAL A  42       9.546  26.664 166.558  1.00 12.21           C  
ATOM    332  CG2 VAL A  42       9.388  29.155 167.025  1.00 13.58           C  
ATOM    333  N   GLY A  43      12.901  26.863 166.651  1.00 11.20           N  
ATOM    334  CA  GLY A  43      13.982  26.551 167.549  1.00 11.97           C  
ATOM    335  C   GLY A  43      13.528  26.162 168.940  1.00 11.98           C  
ATOM    336  O   GLY A  43      12.344  26.235 169.290  1.00 12.39           O  
ATOM    337  N   ASP A  44      14.482  25.693 169.740  1.00 14.17           N  
ATOM    338  CA  ASP A  44      14.129  25.159 171.056  1.00 14.35           C  
ATOM    339  C   ASP A  44      13.671  26.193 172.088  1.00 14.16           C  
ATOM    340  O   ASP A  44      12.768  25.900 172.876  1.00 15.55           O  
ATOM    341  CB  ASP A  44      15.231  24.286 171.658  1.00 16.66           C  
ATOM    342  CG  ASP A  44      14.703  23.407 172.810  1.00 19.01           C  
ATOM    343  OD1 ASP A  44      13.903  22.428 172.602  1.00 21.59           O  
ATOM    344  OD2 ASP A  44      15.011  23.647 173.962  1.00 22.62           O  
ATOM    345  N   ALA A  45      14.241  27.397 172.105  1.00 13.74           N  
ATOM    346  CA  ALA A  45      13.896  28.355 173.136  1.00 13.74           C  
ATOM    347  C   ALA A  45      12.473  28.817 172.934  1.00 13.27           C  
ATOM    348  O   ALA A  45      11.651  28.720 173.838  1.00 12.30           O  
ATOM    349  CB  ALA A  45      14.857  29.529 173.160  1.00 13.74           C  
ATOM    350  N   LYS A  46      12.153  29.252 171.712  1.00 12.14           N  
ATOM    351  CA  LYS A  46      10.765  29.632 171.425  1.00 11.36           C  
ATOM    352  C   LYS A  46       9.843  28.394 171.395  1.00 11.87           C  
ATOM    353  O   LYS A  46       8.689  28.456 171.772  1.00 11.57           O  
ATOM    354  CB  LYS A  46      10.684  30.464 170.137  1.00 11.25           C  
ATOM    355  CG  LYS A  46      11.248  31.878 170.314  1.00 12.62           C  
ATOM    356  CD  LYS A  46      11.106  32.700 169.039  1.00 10.11           C  
ATOM    357  CE  LYS A  46      12.049  32.253 167.957  1.00  9.71           C  
ATOM    358  NZ  LYS A  46      11.809  33.073 166.755  1.00  9.95           N  
ATOM    359  N   GLY A  47      10.414  27.281 170.979  1.00 12.87           N  
ATOM    360  CA  GLY A  47       9.693  26.015 170.915  1.00 13.25           C  
ATOM    361  C   GLY A  47       9.152  25.585 172.272  1.00 14.76           C  
ATOM    362  O   GLY A  47       8.052  25.068 172.329  1.00 13.92           O  
ATOM    363  N   GLN A  48       9.877  25.843 173.353  1.00 14.47           N  
ATOM    364  CA  GLN A  48       9.386  25.493 174.696  1.00 16.29           C  
ATOM    365  C   GLN A  48       8.189  26.355 175.072  1.00 15.26           C  
ATOM    366  O   GLN A  48       7.284  25.903 175.791  1.00 15.50           O  
ATOM    367  CB  GLN A  48      10.510  25.565 175.734  0.70 17.06           C  
ATOM    369  CG  GLN A  48      11.487  24.385 175.625  0.70 17.56           C  
ATOM    371  CD  GLN A  48      12.533  24.379 176.730  0.70 21.70           C  
ATOM    373  OE1 GLN A  48      12.204  24.567 177.903  0.70 22.98           O  
ATOM    375  NE2 GLN A  48      13.789  24.174 176.361  0.70 21.38           N  
ATOM    377  N   ILE A  49       8.151  27.598 174.588  1.00 14.52           N  
ATOM    378  CA  ILE A  49       7.002  28.455 174.844  1.00 14.00           C  
ATOM    379  C   ILE A  49       5.803  27.940 174.033  1.00 14.11           C  
ATOM    380  O   ILE A  49       4.690  27.840 174.537  1.00 15.07           O  
ATOM    381  CB  ILE A  49       7.313  29.919 174.556  1.00 14.57           C  
ATOM    382  CG1 ILE A  49       8.394  30.416 175.513  1.00 16.38           C  
ATOM    383  CG2 ILE A  49       6.030  30.746 174.639  1.00 14.06           C  
ATOM    384  CD1 ILE A  49       9.115  31.687 175.002  1.00 16.40           C  
ATOM    385  N   MET A  50       6.045  27.581 172.785  1.00 13.33           N  
ATOM    386  CA  MET A  50       5.026  26.942 171.944  1.00 14.05           C  
ATOM    387  C   MET A  50       4.442  25.660 172.612  1.00 14.21           C  
ATOM    388  O   MET A  50       3.224  25.482 172.662  1.00 14.41           O  
ATOM    389  CB  MET A  50       5.650  26.623 170.585  1.00 15.07           C  
ATOM    390  CG  MET A  50       4.842  25.671 169.714  1.00 15.61           C  
ATOM    391  SD  MET A  50       5.722  25.233 168.163  1.00 17.77           S  
ATOM    392  CE  MET A  50       5.364  26.666 167.343  1.00 18.97           C  
ATOM    393  N   ASP A  51       5.319  24.835 173.162  1.00 13.38           N  
ATOM    394  CA  ASP A  51       4.890  23.612 173.868  1.00 13.28           C  
ATOM    395  C   ASP A  51       3.934  23.956 175.019  1.00 14.26           C  
ATOM    396  O   ASP A  51       2.924  23.281 175.230  1.00 15.46           O  
ATOM    397  CB  ASP A  51       6.081  22.886 174.492  1.00 13.14           C  
ATOM    398  CG  ASP A  51       7.036  22.244 173.481  1.00 14.50           C  
ATOM    399  OD1 ASP A  51       6.801  22.227 172.242  1.00 15.92           O  
ATOM    400  OD2 ASP A  51       8.078  21.680 173.944  1.00 16.56           O  
ATOM    401  N   ALA A  52       4.297  24.975 175.800  1.00 14.48           N  
ATOM    402  CA  ALA A  52       3.507  25.410 176.972  1.00 14.71           C  
ATOM    403  C   ALA A  52       2.138  25.895 176.524  1.00 15.59           C  
ATOM    404  O   ALA A  52       1.128  25.652 177.195  1.00 16.80           O  
ATOM    405  CB  ALA A  52       4.244  26.497 177.749  1.00 15.16           C  
ATOM    406  N   VAL A  53       2.067  26.571 175.380  1.00 14.91           N  
ATOM    407  CA  VAL A  53       0.780  27.015 174.844  1.00 14.80           C  
ATOM    408  C   VAL A  53      -0.087  25.835 174.405  1.00 16.19           C  
ATOM    409  O   VAL A  53      -1.286  25.791 174.704  1.00 16.93           O  
ATOM    410  CB  VAL A  53       0.985  28.013 173.699  1.00 14.62           C  
ATOM    411  CG1 VAL A  53      -0.331  28.350 172.969  1.00 14.86           C  
ATOM    412  CG2 VAL A  53       1.646  29.267 174.221  1.00 16.26           C  
ATOM    413  N   ILE A  54       0.515  24.865 173.734  1.00 16.15           N  
ATOM    414  CA  ILE A  54      -0.219  23.681 173.316  1.00 16.25           C  
ATOM    415  C   ILE A  54      -0.756  22.938 174.527  1.00 17.24           C  
ATOM    416  O   ILE A  54      -1.912  22.538 174.541  1.00 16.71           O  
ATOM    417  CB  ILE A  54       0.649  22.723 172.443  1.00 17.10           C  
ATOM    418  CG1 ILE A  54       0.949  23.350 171.064  1.00 17.50           C  
ATOM    419  CG2 ILE A  54      -0.070  21.401 172.220  1.00 16.47           C  
ATOM    420  CD1 ILE A  54      -0.212  23.405 170.046  1.00 18.58           C  
ATOM    421  N   ARG A  55       0.065  22.772 175.546  1.00 17.81           N  
ATOM    422  CA  ARG A  55      -0.388  22.047 176.732  1.00 19.11           C  
ATOM    423  C   ARG A  55      -1.506  22.786 177.459  1.00 19.26           C  
ATOM    424  O   ARG A  55      -2.447  22.161 177.988  1.00 20.62           O  
ATOM    425  CB  ARG A  55       0.765  21.816 177.671  1.00 19.51           C  
ATOM    426  CG  ARG A  55       1.798  20.823 177.178  1.00 21.55           C  
ATOM    427  CD  ARG A  55       2.762  20.418 178.297  1.00 23.71           C  
ATOM    428  NE  ARG A  55       4.002  19.859 177.795  1.00 25.92           N  
ATOM    429  CZ  ARG A  55       5.115  20.574 177.617  1.00 29.39           C  
ATOM    430  NH1 ARG A  55       5.159  21.881 177.896  1.00 31.05           N  
ATOM    431  NH2 ARG A  55       6.180  19.982 177.153  1.00 31.33           N  
ATOM    432  N   GLU A  56      -1.425  24.108 177.493  1.00 18.66           N  
ATOM    433  CA  GLU A  56      -2.388  24.897 178.256  1.00 18.69           C  
ATOM    434  C   GLU A  56      -3.757  24.817 177.605  1.00 18.22           C  
ATOM    435  O   GLU A  56      -4.763  24.660 178.294  1.00 19.38           O  
ATOM    436  CB  GLU A  56      -1.932  26.357 178.398  1.00 19.01           C  
ATOM    437  CG  GLU A  56      -3.012  27.268 178.959  1.00 20.07           C  
ATOM    438  CD  GLU A  56      -2.541  28.646 179.379  1.00 23.09           C  
ATOM    439  OE1 GLU A  56      -1.335  28.949 179.321  1.00 24.26           O  
ATOM    440  OE2 GLU A  56      -3.408  29.418 179.815  1.00 27.32           O  
ATOM    441  N   TYR A  57      -3.810  24.948 176.286  1.00 17.22           N  
ATOM    442  CA  TYR A  57      -5.053  25.127 175.574  1.00 17.58           C  
ATOM    443  C   TYR A  57      -5.602  23.825 174.970  1.00 17.98           C  
ATOM    444  O   TYR A  57      -6.761  23.793 174.544  1.00 19.44           O  
ATOM    445  CB  TYR A  57      -4.928  26.224 174.512  1.00 17.54           C  
ATOM    446  CG  TYR A  57      -4.713  27.571 175.153  1.00 15.92           C  
ATOM    447  CD1 TYR A  57      -5.779  28.319 175.661  1.00 17.76           C  
ATOM    448  CD2 TYR A  57      -3.433  28.105 175.279  1.00 15.19           C  
ATOM    449  CE1 TYR A  57      -5.561  29.524 176.294  1.00 17.04           C  
ATOM    450  CE2 TYR A  57      -3.222  29.311 175.911  1.00 16.42           C  
ATOM    451  CZ  TYR A  57      -4.284  30.016 176.412  1.00 16.92           C  
ATOM    452  OH  TYR A  57      -4.053  31.229 177.028  1.00 17.27           O  
ATOM    453  N   SER A  58      -4.776  22.779 174.911  1.00 18.29           N  
ATOM    454  CA  SER A  58      -5.162  21.482 174.333  1.00 18.62           C  
ATOM    455  C   SER A  58      -6.049  21.583 173.087  1.00 18.65           C  
ATOM    456  O   SER A  58      -7.178  21.056 173.039  1.00 18.41           O  
ATOM    457  CB  SER A  58      -5.872  20.615 175.404  0.65 19.39           C  
ATOM    459  OG  SER A  58      -5.079  20.490 176.558  0.65 22.15           O  
ATOM    461  N   PRO A  59      -5.573  22.279 172.044  1.00 17.06           N  
ATOM    462  CA  PRO A  59      -6.396  22.509 170.858  1.00 17.48           C  
ATOM    463  C   PRO A  59      -6.686  21.227 170.091  1.00 18.07           C  
ATOM    464  O   PRO A  59      -5.791  20.387 169.924  1.00 17.91           O  
ATOM    465  CB  PRO A  59      -5.533  23.448 170.008  1.00 17.68           C  
ATOM    466  CG  PRO A  59      -4.157  23.096 170.428  1.00 16.18           C  
ATOM    467  CD  PRO A  59      -4.226  22.866 171.897  1.00 17.35           C  
ATOM    468  N   SER A  60      -7.939  21.073 169.642  1.00 18.82           N  
ATOM    469  CA  SER A  60      -8.322  19.950 168.803  1.00 19.15           C  
ATOM    470  C   SER A  60      -7.969  20.133 167.354  1.00 17.97           C  
ATOM    471  O   SER A  60      -7.712  19.168 166.663  1.00 19.55           O  
ATOM    472  CB  SER A  60      -9.830  19.693 168.924  1.00 19.59           C  
ATOM    473  OG  SER A  60     -10.094  19.323 170.248  1.00 24.47           O  
ATOM    474  N   LEU A  61      -8.014  21.372 166.871  1.00 16.94           N  
ATOM    475  CA  LEU A  61      -7.658  21.705 165.526  1.00 15.96           C  
ATOM    476  C   LEU A  61      -6.735  22.929 165.517  1.00 14.68           C  
ATOM    477  O   LEU A  61      -7.118  24.004 165.943  1.00 14.88           O  
ATOM    478  CB  LEU A  61      -8.911  21.990 164.706  1.00 17.06           C  
ATOM    479  CG  LEU A  61      -8.700  22.306 163.235  1.00 19.05           C  
ATOM    480  CD1 LEU A  61      -7.970  21.161 162.513  1.00 20.38           C  
ATOM    481  CD2 LEU A  61     -10.003  22.663 162.533  1.00 21.48           C  
ATOM    482  N   VAL A  62      -5.519  22.725 165.024  1.00 14.07           N  
ATOM    483  CA  VAL A  62      -4.512  23.795 164.921  1.00 13.28           C  
ATOM    484  C   VAL A  62      -4.223  24.043 163.445  1.00 13.55           C  
ATOM    485  O   VAL A  62      -4.151  23.087 162.637  1.00 13.53           O  
ATOM    486  CB  VAL A  62      -3.187  23.367 165.599  1.00 12.45           C  
ATOM    487  CG1 VAL A  62      -2.149  24.515 165.562  1.00 13.41           C  
ATOM    488  CG2 VAL A  62      -3.357  22.929 167.034  1.00 13.01           C  
ATOM    489  N   LEU A  63      -4.064  25.301 163.057  1.00 12.36           N  
ATOM    490  CA  LEU A  63      -3.611  25.698 161.726  1.00 12.52           C  
ATOM    491  C   LEU A  63      -2.235  26.333 161.852  1.00 13.09           C  
ATOM    492  O   LEU A  63      -2.080  27.240 162.643  1.00 13.35           O  
ATOM    493  CB  LEU A  63      -4.555  26.720 161.108  1.00 13.52           C  
ATOM    494  CG  LEU A  63      -4.114  27.356 159.790  1.00 13.00           C  
ATOM    495  CD1 LEU A  63      -3.873  26.335 158.654  1.00 14.55           C  
ATOM    496  CD2 LEU A  63      -5.077  28.443 159.351  1.00 13.37           C  
ATOM    497  N   GLU A  64      -1.267  25.814 161.106  1.00 11.75           N  
ATOM    498  CA  GLU A  64       0.058  26.439 160.977  1.00 12.47           C  
ATOM    499  C   GLU A  64       0.218  27.106 159.641  1.00 12.48           C  
ATOM    500  O   GLU A  64      -0.098  26.536 158.607  1.00 12.90           O  
ATOM    501  CB  GLU A  64       1.152  25.378 161.208  1.00 13.16           C  
ATOM    502  CG  GLU A  64       2.537  25.807 160.746  1.00 14.28           C  
ATOM    503  CD  GLU A  64       3.581  24.785 161.166  1.00 14.77           C  
ATOM    504  OE1 GLU A  64       3.849  23.836 160.390  1.00 14.90           O  
ATOM    505  OE2 GLU A  64       4.044  24.897 162.319  1.00 15.35           O  
ATOM    506  N   LEU A  65       0.744  28.338 159.639  1.00 11.40           N  
ATOM    507  CA  LEU A  65       1.066  29.067 158.424  1.00 11.50           C  
ATOM    508  C   LEU A  65       2.584  29.099 158.291  1.00 11.87           C  
ATOM    509  O   LEU A  65       3.281  29.816 159.036  1.00 12.35           O  
ATOM    510  CB  LEU A  65       0.474  30.481 158.472  1.00 11.90           C  
ATOM    511  CG  LEU A  65      -1.034  30.520 158.777  1.00 11.93           C  
ATOM    512  CD1 LEU A  65      -1.522  31.936 158.912  1.00 13.91           C  
ATOM    513  CD2 LEU A  65      -1.791  29.788 157.688  1.00 14.05           C  
ATOM    514  N   GLY A  66       3.087  28.251 157.407  1.00 11.27           N  
ATOM    515  CA  GLY A  66       4.518  28.135 157.179  1.00 10.90           C  
ATOM    516  C   GLY A  66       5.100  26.887 157.811  1.00 11.64           C  
ATOM    517  O   GLY A  66       5.452  26.880 158.960  1.00 12.66           O  
ATOM    518  N   ALA A  67       5.229  25.811 157.027  1.00 11.64           N  
ATOM    519  CA  ALA A  67       5.745  24.549 157.519  1.00 11.61           C  
ATOM    520  C   ALA A  67       7.267  24.401 157.450  1.00 10.35           C  
ATOM    521  O   ALA A  67       7.904  23.875 158.376  1.00 10.72           O  
ATOM    522  CB  ALA A  67       5.088  23.382 156.725  1.00 12.76           C  
ATOM    523  N   TYR A  68       7.823  24.814 156.318  1.00 11.61           N  
ATOM    524  CA  TYR A  68       9.243  24.748 156.030  1.00 12.36           C  
ATOM    525  C   TYR A  68       9.715  23.307 156.020  1.00 12.46           C  
ATOM    526  O   TYR A  68       9.369  22.599 155.081  1.00 14.22           O  
ATOM    527  CB  TYR A  68      10.073  25.687 156.969  1.00 12.06           C  
ATOM    528  CG  TYR A  68      11.519  25.809 156.615  1.00 10.87           C  
ATOM    529  CD1 TYR A  68      11.877  26.004 155.320  1.00 11.33           C  
ATOM    530  CD2 TYR A  68      12.522  25.721 157.578  1.00 10.69           C  
ATOM    531  CE1 TYR A  68      13.207  26.111 154.941  1.00 11.82           C  
ATOM    532  CE2 TYR A  68      13.862  25.815 157.217  1.00 11.45           C  
ATOM    533  CZ  TYR A  68      14.185  26.030 155.913  1.00 10.73           C  
ATOM    534  OH  TYR A  68      15.512  26.122 155.518  1.00 13.94           O  
ATOM    535  N   CYS A  69      10.497  22.864 157.004  1.00 12.63           N  
ATOM    536  CA  CYS A  69      10.976  21.474 157.048  1.00 12.19           C  
ATOM    537  C   CYS A  69      10.222  20.591 158.030  1.00 12.50           C  
ATOM    538  O   CYS A  69      10.571  19.424 158.204  1.00 13.30           O  
ATOM    539  CB  CYS A  69      12.449  21.462 157.411  1.00 12.95           C  
ATOM    540  SG  CYS A  69      13.504  22.153 156.154  1.00 14.74           S  
ATOM    541  N   GLY A  70       9.240  21.163 158.708  1.00 11.48           N  
ATOM    542  CA  GLY A  70       8.385  20.443 159.618  1.00 11.33           C  
ATOM    543  C   GLY A  70       8.772  20.478 161.066  1.00 11.64           C  
ATOM    544  O   GLY A  70       8.181  19.781 161.894  1.00 13.36           O  
ATOM    545  N   TYR A  71       9.775  21.276 161.427  1.00 10.51           N  
ATOM    546  CA  TYR A  71      10.171  21.367 162.829  1.00 10.58           C  
ATOM    547  C   TYR A  71       9.028  21.744 163.783  1.00 11.20           C  
ATOM    548  O   TYR A  71       8.782  21.046 164.770  1.00 12.75           O  
ATOM    549  CB  TYR A  71      11.360  22.311 162.984  1.00 11.03           C  
ATOM    550  CG  TYR A  71      11.850  22.494 164.394  1.00 10.62           C  
ATOM    551  CD1 TYR A  71      12.872  21.676 164.920  1.00 11.33           C  
ATOM    552  CD2 TYR A  71      11.340  23.512 165.218  1.00 11.98           C  
ATOM    553  CE1 TYR A  71      13.342  21.859 166.210  1.00 12.32           C  
ATOM    554  CE2 TYR A  71      11.802  23.700 166.502  1.00 12.70           C  
ATOM    555  CZ  TYR A  71      12.785  22.881 167.006  1.00 12.50           C  
ATOM    556  OH  TYR A  71      13.235  23.058 168.291  1.00 12.44           O  
ATOM    557  N   SER A  72       8.370  22.868 163.535  1.00 10.94           N  
ATOM    558  CA  SER A  72       7.273  23.284 164.376  1.00 11.17           C  
ATOM    559  C   SER A  72       6.062  22.346 164.318  1.00 11.73           C  
ATOM    560  O   SER A  72       5.384  22.142 165.346  1.00 13.96           O  
ATOM    561  CB  SER A  72       6.853  24.716 164.126  1.00 12.02           C  
ATOM    562  OG  SER A  72       6.519  24.943 162.790  1.00 12.34           O  
ATOM    563  N   ALA A  73       5.843  21.744 163.161  1.00 12.67           N  
ATOM    564  CA  ALA A  73       4.763  20.769 163.018  1.00 12.97           C  
ATOM    565  C   ALA A  73       5.049  19.546 163.899  1.00 13.81           C  
ATOM    566  O   ALA A  73       4.156  19.047 164.592  1.00 14.03           O  
ATOM    567  CB  ALA A  73       4.576  20.381 161.566  1.00 13.39           C  
ATOM    568  N   VAL A  74       6.273  19.058 163.874  1.00 13.79           N  
ATOM    569  CA  VAL A  74       6.680  18.002 164.800  1.00 14.67           C  
ATOM    570  C   VAL A  74       6.511  18.424 166.271  1.00 14.63           C  
ATOM    571  O   VAL A  74       5.989  17.685 167.111  1.00 15.53           O  
ATOM    572  CB  VAL A  74       8.125  17.534 164.522  1.00 14.62           C  
ATOM    573  CG1 VAL A  74       8.637  16.639 165.660  1.00 15.87           C  
ATOM    574  CG2 VAL A  74       8.190  16.795 163.178  1.00 13.94           C  
ATOM    575  N   ARG A  75       6.921  19.645 166.600  1.00 13.09           N  
ATOM    576  CA  ARG A  75       6.804  20.132 167.960  1.00 13.79           C  
ATOM    577  C   ARG A  75       5.364  20.120 168.444  1.00 13.22           C  
ATOM    578  O   ARG A  75       5.091  19.653 169.532  1.00 13.60           O  
ATOM    579  CB  ARG A  75       7.325  21.576 168.081  1.00 14.50           C  
ATOM    580  CG  ARG A  75       8.801  21.703 168.213  1.00 17.29           C  
ATOM    581  CD  ARG A  75       9.230  22.922 169.062  1.00 16.80           C  
ATOM    582  NE  ARG A  75       9.323  22.635 170.497  1.00 17.42           N  
ATOM    583  CZ  ARG A  75      10.439  22.350 171.173  1.00 16.72           C  
ATOM    584  NH1 ARG A  75      11.615  22.272 170.555  1.00 15.57           N  
ATOM    585  NH2 ARG A  75      10.385  22.119 172.471  1.00 20.25           N  
ATOM    586  N   MET A  76       4.447  20.644 167.646  1.00 13.19           N  
ATOM    587  CA  MET A  76       3.052  20.768 168.046  1.00 12.97           C  
ATOM    588  C   MET A  76       2.342  19.422 168.005  1.00 14.38           C  
ATOM    589  O   MET A  76       1.610  19.078 168.921  1.00 15.02           O  
ATOM    590  CB  MET A  76       2.332  21.772 167.158  1.00 12.87           C  
ATOM    591  CG  MET A  76       2.766  23.204 167.448  1.00 13.60           C  
ATOM    592  SD  MET A  76       1.834  24.478 166.636  1.00 15.11           S  
ATOM    593  CE  MET A  76       2.445  24.341 165.045  1.00 15.35           C  
ATOM    594  N   ALA A  77       2.544  18.692 166.939  1.00 14.77           N  
ATOM    595  CA  ALA A  77       1.820  17.452 166.738  1.00 15.21           C  
ATOM    596  C   ALA A  77       2.178  16.422 167.798  1.00 16.39           C  
ATOM    597  O   ALA A  77       1.302  15.636 168.216  1.00 17.09           O  
ATOM    598  CB  ALA A  77       2.010  16.944 165.335  1.00 16.38           C  
ATOM    599  N   ARG A  78       3.401  16.429 168.320  1.00 16.10           N  
ATOM    600  CA  ARG A  78       3.779  15.471 169.355  1.00 16.47           C  
ATOM    601  C   ARG A  78       3.067  15.693 170.690  1.00 17.10           C  
ATOM    602  O   ARG A  78       3.095  14.821 171.563  1.00 18.42           O  
ATOM    603  CB  ARG A  78       5.287  15.446 169.583  1.00 16.66           C  
ATOM    604  CG  ARG A  78       5.784  16.479 170.549  1.00 16.61           C  
ATOM    605  CD  ARG A  78       7.307  16.690 170.446  1.00 17.44           C  
ATOM    606  NE  ARG A  78       7.923  17.202 171.654  1.00 18.74           N  
ATOM    607  CZ  ARG A  78       7.870  18.471 172.070  1.00 19.68           C  
ATOM    608  NH1 ARG A  78       7.156  19.378 171.426  1.00 15.21           N  
ATOM    609  NH2 ARG A  78       8.509  18.829 173.169  1.00 20.41           N  
ATOM    610  N   LEU A  79       2.474  16.871 170.871  1.00 16.49           N  
ATOM    611  CA  LEU A  79       1.784  17.227 172.105  1.00 17.26           C  
ATOM    612  C   LEU A  79       0.272  17.273 171.968  1.00 17.60           C  
ATOM    613  O   LEU A  79      -0.424  17.556 172.968  1.00 20.19           O  
ATOM    614  CB  LEU A  79       2.284  18.597 172.576  1.00 16.93           C  
ATOM    615  CG  LEU A  79       3.741  18.622 172.995  1.00 18.72           C  
ATOM    616  CD1 LEU A  79       4.101  20.027 173.426  1.00 19.42           C  
ATOM    617  CD2 LEU A  79       4.050  17.609 174.079  1.00 20.41           C  
ATOM    618  N   LEU A  80      -0.242  16.999 170.780  1.00 18.51           N  
ATOM    619  CA  LEU A  80      -1.693  16.994 170.537  1.00 19.55           C  
ATOM    620  C   LEU A  80      -2.328  15.754 171.197  1.00 21.76           C  
ATOM    621  O   LEU A  80      -1.738  14.670 171.221  1.00 21.99           O  
ATOM    622  CB  LEU A  80      -1.988  17.014 169.042  1.00 19.62           C  
ATOM    623  CG  LEU A  80      -1.656  18.323 168.318  1.00 20.07           C  
ATOM    624  CD1 LEU A  80      -2.066  18.204 166.910  1.00 20.82           C  
ATOM    625  CD2 LEU A  80      -2.289  19.544 168.970  1.00 19.74           C  
ATOM    626  N   GLN A  81      -3.521  15.941 171.730  1.00 23.56           N  
ATOM    627  CA  GLN A  81      -4.275  14.817 172.298  1.00 24.72           C  
ATOM    628  C   GLN A  81      -4.694  13.856 171.195  1.00 24.79           C  
ATOM    629  O   GLN A  81      -4.701  14.198 170.014  1.00 23.64           O  
ATOM    630  CB  GLN A  81      -5.493  15.345 173.068  1.00 25.82           C  
ATOM    631  CG  GLN A  81      -5.140  16.026 174.394  1.00 29.09           C  
ATOM    632  CD  GLN A  81      -4.390  15.144 175.377  1.00 34.38           C  
ATOM    633  OE1 GLN A  81      -4.587  13.927 175.416  1.00 40.00           O  
ATOM    634  NE2 GLN A  81      -3.515  15.756 176.171  1.00 38.37           N  
ATOM    635  N   PRO A  82      -5.045  12.618 171.564  1.00 25.21           N  
ATOM    636  CA  PRO A  82      -5.640  11.689 170.593  1.00 25.36           C  
ATOM    637  C   PRO A  82      -6.847  12.270 169.847  1.00 24.88           C  
ATOM    638  O   PRO A  82      -7.742  12.811 170.496  1.00 26.77           O  
ATOM    639  CB  PRO A  82      -6.083  10.495 171.471  1.00 25.89           C  
ATOM    640  CG  PRO A  82      -5.242  10.561 172.678  1.00 25.92           C  
ATOM    641  CD  PRO A  82      -4.879  12.021 172.903  1.00 26.18           C  
ATOM    642  N   GLY A  83      -6.871  12.149 168.521  1.00 24.82           N  
ATOM    643  CA  GLY A  83      -7.955  12.675 167.700  1.00 24.24           C  
ATOM    644  C   GLY A  83      -7.808  14.143 167.287  1.00 23.73           C  
ATOM    645  O   GLY A  83      -8.540  14.620 166.425  1.00 24.22           O  
ATOM    646  N   ALA A  84      -6.885  14.867 167.919  1.00 23.86           N  
ATOM    647  CA  ALA A  84      -6.572  16.244 167.501  1.00 22.94           C  
ATOM    648  C   ALA A  84      -5.731  16.263 166.212  1.00 22.80           C  
ATOM    649  O   ALA A  84      -5.024  15.291 165.877  1.00 23.22           O  
ATOM    650  CB  ALA A  84      -5.841  16.957 168.593  1.00 23.11           C  
ATOM    651  N   ARG A  85      -5.814  17.378 165.495  1.00 20.98           N  
ATOM    652  CA  ARG A  85      -5.244  17.487 164.160  1.00 21.02           C  
ATOM    653  C   ARG A  85      -4.538  18.830 163.962  1.00 19.12           C  
ATOM    654  O   ARG A  85      -4.964  19.853 164.510  1.00 18.46           O  
ATOM    655  CB  ARG A  85      -6.329  17.383 163.114  1.00 22.07           C  
ATOM    656  CG  ARG A  85      -7.054  16.020 163.070  1.00 28.56           C  
ATOM    657  CD  ARG A  85      -7.505  15.619 161.675  1.00 32.24           C  
ATOM    658  NE  ARG A  85      -6.359  15.522 160.776  1.00 34.69           N  
ATOM    659  CZ  ARG A  85      -5.688  14.408 160.500  1.00 37.19           C  
ATOM    660  NH1 ARG A  85      -6.055  13.237 161.017  1.00 39.78           N  
ATOM    661  NH2 ARG A  85      -4.642  14.465 159.682  1.00 37.04           N  
ATOM    662  N   LEU A  86      -3.448  18.793 163.202  1.00 17.10           N  
ATOM    663  CA  LEU A  86      -2.766  19.992 162.720  1.00 16.84           C  
ATOM    664  C   LEU A  86      -2.883  20.053 161.220  1.00 16.15           C  
ATOM    665  O   LEU A  86      -2.540  19.092 160.535  1.00 16.69           O  
ATOM    666  CB  LEU A  86      -1.276  19.911 163.096  1.00 16.39           C  
ATOM    667  CG  LEU A  86      -0.312  20.968 162.487  1.00 17.38           C  
ATOM    668  CD1 LEU A  86      -0.737  22.362 162.904  1.00 16.97           C  
ATOM    669  CD2 LEU A  86       1.139  20.679 162.864  1.00 19.78           C  
ATOM    670  N   LEU A  87      -3.319  21.191 160.695  1.00 15.31           N  
ATOM    671  CA  LEU A  87      -3.258  21.494 159.290  1.00 15.19           C  
ATOM    672  C   LEU A  87      -2.097  22.446 159.144  1.00 15.20           C  
ATOM    673  O   LEU A  87      -2.022  23.432 159.903  1.00 14.36           O  
ATOM    674  CB  LEU A  87      -4.536  22.177 158.812  1.00 15.69           C  
ATOM    675  CG  LEU A  87      -5.850  21.490 159.174  1.00 19.10           C  
ATOM    676  CD1 LEU A  87      -7.018  22.331 158.712  1.00 19.63           C  
ATOM    677  CD2 LEU A  87      -5.868  20.133 158.525  1.00 21.23           C  
ATOM    678  N   THR A  88      -1.206  22.209 158.192  1.00 13.77           N  
ATOM    679  CA  THR A  88      -0.113  23.167 157.986  1.00 13.46           C  
ATOM    680  C   THR A  88      -0.024  23.587 156.527  1.00 13.57           C  
ATOM    681  O   THR A  88      -0.018  22.737 155.618  1.00 14.97           O  
ATOM    682  CB  THR A  88       1.206  22.604 158.554  1.00 13.85           C  
ATOM    683  OG1 THR A  88       2.236  23.575 158.288  1.00 14.14           O  
ATOM    684  CG2 THR A  88       1.676  21.339 157.816  1.00 15.13           C  
ATOM    685  N   MET A  89      -0.014  24.881 156.268  1.00 13.23           N  
ATOM    686  CA  MET A  89      -0.004  25.430 154.911  1.00 13.18           C  
ATOM    687  C   MET A  89       1.429  25.778 154.522  1.00 14.24           C  
ATOM    688  O   MET A  89       2.150  26.433 155.320  1.00 13.86           O  
ATOM    689  CB  MET A  89      -0.889  26.678 154.797  1.00 14.38           C  
ATOM    690  CG  MET A  89      -2.335  26.385 155.087  1.00 14.63           C  
ATOM    691  SD  MET A  89      -3.319  27.814 155.021  1.00 15.14           S  
ATOM    692  CE  MET A  89      -4.996  27.058 155.067  1.00 15.07           C  
ATOM    693  N   GLU A  90       1.848  25.334 153.346  1.00 13.88           N  
ATOM    694  CA  GLU A  90       3.183  25.556 152.829  1.00 13.53           C  
ATOM    695  C   GLU A  90       3.122  25.765 151.313  1.00 14.67           C  
ATOM    696  O   GLU A  90       2.698  24.859 150.588  1.00 16.00           O  
ATOM    697  CB  GLU A  90       4.054  24.364 153.169  1.00 13.43           C  
ATOM    698  CG  GLU A  90       5.475  24.425 152.635  1.00 12.22           C  
ATOM    699  CD  GLU A  90       6.164  25.766 152.930  1.00 12.08           C  
ATOM    700  OE1 GLU A  90       6.341  26.086 154.143  1.00 12.67           O  
ATOM    701  OE2 GLU A  90       6.495  26.479 151.980  1.00 13.12           O  
ATOM    702  N   MET A  91       3.584  26.914 150.834  1.00 14.61           N  
ATOM    703  CA  MET A  91       3.443  27.275 149.436  1.00 15.46           C  
ATOM    704  C   MET A  91       4.552  26.699 148.554  1.00 15.79           C  
ATOM    705  O   MET A  91       4.377  26.593 147.340  1.00 16.95           O  
ATOM    706  CB  MET A  91       3.330  28.778 149.248  1.00 15.93           C  
ATOM    707  CG  MET A  91       4.585  29.564 149.511  1.00 19.55           C  
ATOM    708  SD  MET A  91       4.258  31.316 149.246  1.00 24.95           S  
ATOM    709  CE  MET A  91       5.848  31.887 149.482  1.00 25.43           C  
ATOM    710  N   ASN A  92       5.682  26.347 149.155  1.00 14.40           N  
ATOM    711  CA  ASN A  92       6.822  25.848 148.412  1.00 14.19           C  
ATOM    712  C   ASN A  92       6.746  24.320 148.358  1.00 14.40           C  
ATOM    713  O   ASN A  92       6.799  23.667 149.382  1.00 13.36           O  
ATOM    714  CB  ASN A  92       8.103  26.303 149.134  1.00 13.38           C  
ATOM    715  CG  ASN A  92       9.352  25.865 148.421  1.00 15.40           C  
ATOM    716  OD1 ASN A  92       9.456  24.701 147.974  1.00 16.41           O  
ATOM    717  ND2 ASN A  92      10.335  26.763 148.356  1.00 17.39           N  
ATOM    718  N   PRO A  93       6.506  23.728 147.169  1.00 15.36           N  
ATOM    719  CA  PRO A  93       6.325  22.268 147.089  1.00 16.36           C  
ATOM    720  C   PRO A  93       7.552  21.465 147.496  1.00 15.48           C  
ATOM    721  O   PRO A  93       7.405  20.391 148.032  1.00 16.26           O  
ATOM    722  CB  PRO A  93       6.017  22.028 145.603  1.00 17.19           C  
ATOM    723  CG  PRO A  93       6.573  23.190 144.923  1.00 18.10           C  
ATOM    724  CD  PRO A  93       6.377  24.379 145.862  1.00 17.27           C  
ATOM    725  N   ASP A  94       8.730  22.002 147.269  1.00 15.70           N  
ATOM    726  CA  ASP A  94       9.951  21.338 147.735  1.00 16.17           C  
ATOM    727  C   ASP A  94       9.954  21.218 149.270  1.00 15.30           C  
ATOM    728  O   ASP A  94      10.260  20.173 149.834  1.00 14.49           O  
ATOM    729  CB  ASP A  94      11.181  22.102 147.258  1.00 16.12           C  
ATOM    730  CG  ASP A  94      11.346  22.076 145.761  1.00 22.04           C  
ATOM    731  OD1 ASP A  94      10.741  21.194 145.088  1.00 23.90           O  
ATOM    732  OD2 ASP A  94      12.119  22.866 145.185  1.00 29.13           O  
ATOM    733  N   TYR A  95       9.603  22.316 149.953  1.00 15.03           N  
ATOM    734  CA  TYR A  95       9.543  22.286 151.408  1.00 14.16           C  
ATOM    735  C   TYR A  95       8.410  21.406 151.933  1.00 13.81           C  
ATOM    736  O   TYR A  95       8.553  20.712 152.891  1.00 14.10           O  
ATOM    737  CB  TYR A  95       9.352  23.724 151.933  1.00 14.03           C  
ATOM    738  CG  TYR A  95      10.479  24.703 151.606  1.00 14.91           C  
ATOM    739  CD1 TYR A  95      11.671  24.294 151.020  1.00 16.06           C  
ATOM    740  CD2 TYR A  95      10.342  26.048 151.931  1.00 13.76           C  
ATOM    741  CE1 TYR A  95      12.680  25.202 150.750  1.00 17.04           C  
ATOM    742  CE2 TYR A  95      11.346  26.951 151.685  1.00 15.75           C  
ATOM    743  CZ  TYR A  95      12.510  26.523 151.083  1.00 16.29           C  
ATOM    744  OH  TYR A  95      13.503  27.404 150.807  1.00 21.10           O  
ATOM    745  N   ALA A  96       7.268  21.441 151.266  1.00 14.04           N  
ATOM    746  CA  ALA A  96       6.149  20.594 151.654  1.00 14.13           C  
ATOM    747  C   ALA A  96       6.574  19.125 151.604  1.00 13.85           C  
ATOM    748  O   ALA A  96       6.248  18.361 152.506  1.00 14.99           O  
ATOM    749  CB  ALA A  96       4.968  20.856 150.737  1.00 14.87           C  
ATOM    750  N   ALA A  97       7.301  18.754 150.553  1.00 15.24           N  
ATOM    751  CA  ALA A  97       7.853  17.393 150.419  1.00 15.65           C  
ATOM    752  C   ALA A  97       8.792  17.015 151.555  1.00 16.02           C  
ATOM    753  O   ALA A  97       8.704  15.920 152.138  1.00 16.33           O  
ATOM    754  CB  ALA A  97       8.569  17.228 149.091  1.00 16.33           C  
ATOM    755  N   ILE A  98       9.695  17.931 151.910  1.00 15.63           N  
ATOM    756  CA  ILE A  98      10.574  17.686 153.057  1.00 14.89           C  
ATOM    757  C   ILE A  98       9.773  17.509 154.343  1.00 13.87           C  
ATOM    758  O   ILE A  98      10.035  16.606 155.137  1.00 13.93           O  
ATOM    759  CB  ILE A  98      11.608  18.848 153.223  1.00 15.19           C  
ATOM    760  CG1 ILE A  98      12.580  18.974 152.025  1.00 17.14           C  
ATOM    761  CG2 ILE A  98      12.345  18.712 154.545  1.00 13.45           C  
ATOM    762  CD1 ILE A  98      13.631  17.905 151.915  1.00 20.54           C  
ATOM    763  N   THR A  99       8.793  18.381 154.578  1.00 13.43           N  
ATOM    764  CA  THR A  99       7.971  18.313 155.762  1.00 13.32           C  
ATOM    765  C   THR A  99       7.234  16.954 155.880  1.00 12.29           C  
ATOM    766  O   THR A  99       7.101  16.397 156.953  1.00 13.68           O  
ATOM    767  CB  THR A  99       6.953  19.472 155.756  1.00 12.70           C  
ATOM    768  OG1 THR A  99       7.634  20.739 155.946  1.00 14.01           O  
ATOM    769  CG2 THR A  99       6.026  19.380 156.904  1.00 12.67           C  
ATOM    770  N   GLN A 100       6.732  16.458 154.755  1.00 14.19           N  
ATOM    771  CA  GLN A 100       6.040  15.165 154.761  1.00 14.73           C  
ATOM    772  C   GLN A 100       6.984  14.058 155.182  1.00 14.27           C  
ATOM    773  O   GLN A 100       6.657  13.237 156.028  1.00 15.91           O  
ATOM    774  CB  GLN A 100       5.429  14.876 153.406  1.00 15.08           C  
ATOM    775  CG  GLN A 100       4.519  13.613 153.445  1.00 16.66           C  
ATOM    776  CD  GLN A 100       3.307  13.804 154.326  1.00 17.69           C  
ATOM    777  OE1 GLN A 100       2.381  14.540 153.951  1.00 19.30           O  
ATOM    778  NE2 GLN A 100       3.319  13.190 155.514  1.00 18.26           N  
ATOM    779  N   GLN A 101       8.189  14.058 154.634  1.00 14.52           N  
ATOM    780  CA  GLN A 101       9.167  13.044 155.034  1.00 16.05           C  
ATOM    781  C   GLN A 101       9.607  13.146 156.482  1.00 15.57           C  
ATOM    782  O   GLN A 101       9.848  12.147 157.174  1.00 15.30           O  
ATOM    783  CB  GLN A 101      10.376  13.089 154.138  1.00 16.59           C  
ATOM    784  CG  GLN A 101      10.049  12.656 152.744  1.00 19.35           C  
ATOM    785  CD  GLN A 101      11.170  12.898 151.805  1.00 25.11           C  
ATOM    786  OE1 GLN A 101      12.088  12.078 151.710  1.00 29.54           O  
ATOM    787  NE2 GLN A 101      11.130  14.027 151.107  1.00 28.97           N  
ATOM    788  N   MET A 102       9.710  14.395 156.980  1.00 14.80           N  
ATOM    789  CA  MET A 102      10.041  14.625 158.371  1.00 14.61           C  
ATOM    790  C   MET A 102       8.978  14.076 159.322  1.00 14.96           C  
ATOM    791  O   MET A 102       9.285  13.461 160.352  1.00 15.39           O  
ATOM    792  CB  MET A 102      10.226  16.160 158.617  1.00 15.40           C  
ATOM    793  CG  MET A 102      10.960  16.496 159.919  1.00 14.37           C  
ATOM    794  SD  MET A 102      12.706  16.094 159.891  1.00 14.66           S  
ATOM    795  CE  MET A 102      13.344  17.388 158.833  1.00 12.94           C  
ATOM    796  N   LEU A 103       7.721  14.344 158.985  1.00 15.49           N  
ATOM    797  CA  LEU A 103       6.577  13.874 159.764  1.00 15.99           C  
ATOM    798  C   LEU A 103       6.527  12.334 159.749  1.00 15.69           C  
ATOM    799  O   LEU A 103       6.348  11.729 160.799  1.00 16.90           O  
ATOM    800  CB  LEU A 103       5.285  14.466 159.214  1.00 16.15           C  
ATOM    801  CG  LEU A 103       5.119  15.960 159.524  1.00 17.31           C  
ATOM    802  CD1 LEU A 103       4.032  16.485 158.676  1.00 20.34           C  
ATOM    803  CD2 LEU A 103       4.828  16.161 160.984  1.00 18.69           C  
ATOM    804  N   ASN A 104       6.803  11.762 158.595  1.00 17.57           N  
ATOM    805  CA  ASN A 104       6.788  10.304 158.419  1.00 18.26           C  
ATOM    806  C   ASN A 104       7.874   9.700 159.288  1.00 17.77           C  
ATOM    807  O   ASN A 104       7.687   8.694 159.991  1.00 18.74           O  
ATOM    808  CB  ASN A 104       7.043   9.948 156.954  1.00 18.18           C  
ATOM    809  CG  ASN A 104       5.869  10.277 156.025  1.00 19.26           C  
ATOM    810  OD1 ASN A 104       4.772  10.607 156.464  1.00 20.54           O  
ATOM    811  ND2 ASN A 104       6.109  10.150 154.716  1.00 20.80           N  
ATOM    812  N   PHE A 105       9.056  10.293 159.234  1.00 17.37           N  
ATOM    813  CA  PHE A 105      10.143   9.804 160.047  1.00 16.86           C  
ATOM    814  C   PHE A 105       9.818   9.868 161.521  1.00 16.93           C  
ATOM    815  O   PHE A 105      10.123   8.938 162.264  1.00 17.15           O  
ATOM    816  CB  PHE A 105      11.443  10.557 159.744  1.00 16.42           C  
ATOM    817  CG  PHE A 105      12.655   9.918 160.337  1.00 16.53           C  
ATOM    818  CD1 PHE A 105      13.422   9.033 159.599  1.00 16.69           C  
ATOM    819  CD2 PHE A 105      13.036  10.165 161.632  1.00 16.46           C  
ATOM    820  CE1 PHE A 105      14.547   8.410 160.158  1.00 16.65           C  
ATOM    821  CE2 PHE A 105      14.151   9.558 162.180  1.00 16.83           C  
ATOM    822  CZ  PHE A 105      14.904   8.685 161.438  1.00 15.18           C  
ATOM    823  N   ALA A 106       9.192  10.973 161.965  1.00 16.49           N  
ATOM    824  CA  ALA A 106       8.863  11.152 163.370  1.00 17.27           C  
ATOM    825  C   ALA A 106       7.689  10.280 163.825  1.00 18.06           C  
ATOM    826  O   ALA A 106       7.460  10.142 165.047  1.00 19.36           O  
ATOM    827  CB  ALA A 106       8.520  12.619 163.640  1.00 16.73           C  
ATOM    828  N   GLY A 107       6.949   9.758 162.850  1.00 18.36           N  
ATOM    829  CA  GLY A 107       5.751   8.949 163.093  1.00 19.97           C  
ATOM    830  C   GLY A 107       4.492   9.740 163.422  1.00 20.23           C  
ATOM    831  O   GLY A 107       3.564   9.215 164.096  1.00 20.33           O  
ATOM    832  N   LEU A 108       4.445  11.007 162.977  1.00 19.02           N  
ATOM    833  CA  LEU A 108       3.329  11.904 163.296  1.00 19.30           C  
ATOM    834  C   LEU A 108       2.434  12.215 162.119  1.00 19.65           C  
ATOM    835  O   LEU A 108       1.549  13.098 162.191  1.00 19.35           O  
ATOM    836  CB  LEU A 108       3.872  13.233 163.858  1.00 19.27           C  
ATOM    837  CG  LEU A 108       4.556  13.104 165.195  1.00 18.12           C  
ATOM    838  CD1 LEU A 108       5.411  14.382 165.444  1.00 19.14           C  
ATOM    839  CD2 LEU A 108       3.610  12.891 166.334  1.00 21.09           C  
ATOM    840  N   GLN A 109       2.626  11.479 161.030  1.00 19.91           N  
ATOM    841  CA  GLN A 109       1.959  11.788 159.787  1.00 20.78           C  
ATOM    842  C   GLN A 109       0.438  11.681 159.908  1.00 20.77           C  
ATOM    843  O   GLN A 109      -0.277  12.390 159.222  1.00 21.26           O  
ATOM    844  CB  GLN A 109       2.501  10.967 158.613  1.00 21.69           C  
ATOM    845  CG  GLN A 109       2.230   9.465 158.621  1.00 22.90           C  
ATOM    846  CD  GLN A 109       2.849   8.690 159.784  1.00 27.03           C  
ATOM    847  OE1 GLN A 109       3.923   9.038 160.302  1.00 22.31           O  
ATOM    848  NE2 GLN A 109       2.163   7.613 160.201  1.00 30.86           N  
ATOM    849  N   ASP A 110      -0.057  10.822 160.785  1.00 22.87           N  
ATOM    850  CA  ASP A 110      -1.517  10.657 160.888  1.00 24.13           C  
ATOM    851  C   ASP A 110      -2.214  11.766 161.694  1.00 24.14           C  
ATOM    852  O   ASP A 110      -3.439  11.821 161.743  1.00 24.73           O  
ATOM    853  CB  ASP A 110      -1.863   9.286 161.492  1.00 25.46           C  
ATOM    854  CG  ASP A 110      -1.388   8.119 160.636  1.00 28.62           C  
ATOM    855  OD1 ASP A 110      -1.437   8.184 159.374  1.00 33.96           O  
ATOM    856  OD2 ASP A 110      -0.948   7.078 161.159  1.00 35.17           O  
ATOM    857  N   LYS A 111      -1.440  12.646 162.323  1.00 23.14           N  
ATOM    858  CA  LYS A 111      -1.987  13.786 163.065  1.00 22.70           C  
ATOM    859  C   LYS A 111      -1.912  15.104 162.293  1.00 21.66           C  
ATOM    860  O   LYS A 111      -2.486  16.090 162.741  1.00 21.42           O  
ATOM    861  CB  LYS A 111      -1.258  13.931 164.389  1.00 23.57           C  
ATOM    862  CG  LYS A 111      -1.390  12.652 165.270  1.00 26.25           C  
ATOM    863  CD  LYS A 111      -0.955  12.846 166.684  1.00 30.70           C  
ATOM    864  CE  LYS A 111      -1.833  13.868 167.431  1.00 33.26           C  
ATOM    865  NZ  LYS A 111      -3.254  13.514 167.827  1.00 33.65           N  
ATOM    866  N   VAL A 112      -1.237  15.102 161.143  1.00 19.68           N  
ATOM    867  CA  VAL A 112      -0.993  16.305 160.359  1.00 19.54           C  
ATOM    868  C   VAL A 112      -1.425  16.152 158.900  1.00 19.71           C  
ATOM    869  O   VAL A 112      -1.164  15.129 158.251  1.00 19.92           O  
ATOM    870  CB  VAL A 112       0.531  16.673 160.391  1.00 19.16           C  
ATOM    871  CG1 VAL A 112       0.779  18.012 159.703  1.00 18.98           C  
ATOM    872  CG2 VAL A 112       1.075  16.657 161.810  1.00 18.99           C  
ATOM    873  N   THR A 113      -2.047  17.195 158.357  1.00 18.51           N  
ATOM    874  CA  THR A 113      -2.291  17.314 156.950  1.00 18.90           C  
ATOM    875  C   THR A 113      -1.550  18.547 156.424  1.00 18.27           C  
ATOM    876  O   THR A 113      -1.802  19.668 156.881  1.00 17.01           O  
ATOM    877  CB  THR A 113      -3.802  17.491 156.710  1.00 19.24           C  
ATOM    878  OG1 THR A 113      -4.514  16.407 157.327  1.00 22.00           O  
ATOM    879  CG2 THR A 113      -4.148  17.414 155.261  1.00 21.21           C  
ATOM    880  N   ILE A 114      -0.695  18.333 155.433  1.00 17.38           N  
ATOM    881  CA  ILE A 114      -0.042  19.411 154.738  1.00 17.39           C  
ATOM    882  C   ILE A 114      -0.899  19.914 153.599  1.00 19.03           C  
ATOM    883  O   ILE A 114      -1.344  19.115 152.765  1.00 20.05           O  
ATOM    884  CB  ILE A 114       1.324  18.956 154.182  1.00 17.30           C  
ATOM    885  CG1 ILE A 114       2.187  18.396 155.296  1.00 17.43           C  
ATOM    886  CG2 ILE A 114       2.011  20.090 153.492  1.00 18.64           C  
ATOM    887  CD1 ILE A 114       3.416  17.670 154.776  1.00 18.00           C  
ATOM    888  N   LEU A 115      -1.147  21.224 153.554  1.00 18.38           N  
ATOM    889  CA  LEU A 115      -1.897  21.847 152.471  1.00 20.11           C  
ATOM    890  C   LEU A 115      -0.940  22.612 151.622  1.00 20.86           C  
ATOM    891  O   LEU A 115      -0.251  23.540 152.077  1.00 19.47           O  
ATOM    892  CB  LEU A 115      -2.998  22.767 152.993  1.00 20.61           C  
ATOM    893  CG  LEU A 115      -3.945  22.134 154.030  1.00 24.04           C  
ATOM    894  CD1 LEU A 115      -5.050  23.119 154.415  1.00 25.53           C  
ATOM    895  CD2 LEU A 115      -4.514  20.842 153.478  1.00 28.99           C  
ATOM    896  N   ASN A 116      -0.876  22.214 150.375  1.00 21.99           N  
ATOM    897  CA  ASN A 116       0.037  22.810 149.431  1.00 22.15           C  
ATOM    898  C   ASN A 116      -0.578  23.989 148.788  1.00 21.40           C  
ATOM    899  O   ASN A 116      -1.553  23.875 148.030  1.00 23.72           O  
ATOM    900  CB  ASN A 116       0.393  21.816 148.353  1.00 23.70           C  
ATOM    901  CG  ASN A 116       1.326  20.812 148.845  1.00 27.28           C  
ATOM    902  OD1 ASN A 116       2.527  20.965 148.687  1.00 33.99           O  
ATOM    903  ND2 ASN A 116       0.795  19.760 149.468  1.00 32.32           N  
ATOM    904  N   GLY A 117      -0.063  25.155 149.107  1.00 18.14           N  
ATOM    905  CA  GLY A 117      -0.525  26.363 148.480  1.00 17.37           C  
ATOM    906  C   GLY A 117      -0.228  27.540 149.390  1.00 16.75           C  
ATOM    907  O   GLY A 117       0.322  27.339 150.472  1.00 16.43           O  
ATOM    908  N   ALA A 118      -0.573  28.720 148.904  1.00 15.78           N  
ATOM    909  CA  ALA A 118      -0.435  29.982 149.631  1.00 14.65           C  
ATOM    910  C   ALA A 118      -1.634  30.142 150.553  1.00 15.49           C  
ATOM    911  O   ALA A 118      -2.764  29.883 150.156  1.00 16.21           O  
ATOM    912  CB  ALA A 118      -0.367  31.097 148.684  1.00 15.87           C  
ATOM    913  N   SER A 119      -1.387  30.596 151.771  1.00 14.13           N  
ATOM    914  CA  SER A 119      -2.416  30.752 152.788  1.00 14.42           C  
ATOM    915  C   SER A 119      -3.556  31.650 152.321  1.00 15.22           C  
ATOM    916  O   SER A 119      -4.728  31.370 152.622  1.00 16.11           O  
ATOM    917  CB  SER A 119      -1.772  31.291 154.073  1.00 14.84           C  
ATOM    918  OG  SER A 119      -1.106  32.496 153.805  1.00 15.37           O  
ATOM    919  N   GLN A 120      -3.236  32.726 151.616  1.00 15.46           N  
ATOM    920  CA  GLN A 120      -4.282  33.651 151.142  1.00 17.21           C  
ATOM    921  C   GLN A 120      -5.272  32.947 150.199  1.00 18.10           C  
ATOM    922  O   GLN A 120      -6.446  33.346 150.134  1.00 18.10           O  
ATOM    923  CB  GLN A 120      -3.706  34.901 150.463  1.00 17.26           C  
ATOM    924  CG  GLN A 120      -2.825  34.678 149.239  1.00 19.32           C  
ATOM    925  CD  GLN A 120      -1.330  34.539 149.581  1.00 17.03           C  
ATOM    926  OE1 GLN A 120      -0.981  34.016 150.626  1.00 15.72           O  
ATOM    927  NE2 GLN A 120      -0.465  34.977 148.678  1.00 20.37           N  
ATOM    928  N   ASP A 121      -4.787  31.948 149.453  1.00 18.05           N  
ATOM    929  CA  ASP A 121      -5.657  31.119 148.579  1.00 19.17           C  
ATOM    930  C   ASP A 121      -6.374  30.007 149.325  1.00 19.19           C  
ATOM    931  O   ASP A 121      -7.536  29.667 148.993  1.00 19.94           O  
ATOM    932  CB  ASP A 121      -4.843  30.499 147.452  1.00 19.78           C  
ATOM    933  CG  ASP A 121      -4.177  31.519 146.589  1.00 21.36           C  
ATOM    934  OD1 ASP A 121      -4.742  32.618 146.384  1.00 24.97           O  
ATOM    935  OD2 ASP A 121      -3.076  31.309 146.066  1.00 25.12           O  
ATOM    936  N   LEU A 122      -5.710  29.413 150.319  1.00 18.58           N  
ATOM    937  CA  LEU A 122      -6.227  28.244 150.993  1.00 17.07           C  
ATOM    938  C   LEU A 122      -7.155  28.559 152.150  1.00 16.89           C  
ATOM    939  O   LEU A 122      -8.093  27.824 152.405  1.00 16.43           O  
ATOM    940  CB  LEU A 122      -5.086  27.367 151.520  1.00 17.84           C  
ATOM    941  CG  LEU A 122      -4.166  26.744 150.469  1.00 17.46           C  
ATOM    942  CD1 LEU A 122      -2.930  26.136 151.125  1.00 20.81           C  
ATOM    943  CD2 LEU A 122      -4.926  25.667 149.680  1.00 21.57           C  
ATOM    944  N   ILE A 123      -6.906  29.661 152.855  1.00 15.72           N  
ATOM    945  CA  ILE A 123      -7.712  29.988 154.024  1.00 15.02           C  
ATOM    946  C   ILE A 123      -9.232  30.059 153.675  1.00 15.49           C  
ATOM    947  O   ILE A 123     -10.035  29.442 154.408  1.00 15.44           O  
ATOM    948  CB  ILE A 123      -7.171  31.256 154.741  1.00 15.41           C  
ATOM    949  CG1 ILE A 123      -5.955  30.879 155.584  1.00 14.61           C  
ATOM    950  CG2 ILE A 123      -8.206  31.862 155.661  1.00 15.06           C  
ATOM    951  CD1 ILE A 123      -5.204  32.094 156.068  1.00 14.78           C  
ATOM    952  N   PRO A 124      -9.596  30.739 152.604  1.00 16.61           N  
ATOM    953  CA  PRO A 124     -11.034  30.815 152.260  1.00 17.58           C  
ATOM    954  C   PRO A 124     -11.652  29.511 151.788  1.00 19.12           C  
ATOM    955  O   PRO A 124     -12.873  29.481 151.662  1.00 19.87           O  
ATOM    956  CB  PRO A 124     -11.075  31.831 151.134  1.00 17.73           C  
ATOM    957  CG  PRO A 124      -9.770  32.610 151.224  1.00 19.32           C  
ATOM    958  CD  PRO A 124      -8.792  31.584 151.699  1.00 16.00           C  
ATOM    959  N   GLN A 125     -10.843  28.501 151.510  1.00 19.68           N  
ATOM    960  CA  GLN A 125     -11.319  27.163 151.127  1.00 20.28           C  
ATOM    961  C   GLN A 125     -11.467  26.173 152.272  1.00 18.85           C  
ATOM    962  O   GLN A 125     -11.944  25.045 152.070  1.00 18.82           O  
ATOM    963  CB  GLN A 125     -10.379  26.546 150.098  1.00 20.57           C  
ATOM    964  CG  GLN A 125     -10.127  27.355 148.877  1.00 24.79           C  
ATOM    965  CD  GLN A 125      -9.222  26.633 147.892  1.00 31.45           C  
ATOM    966  OE1 GLN A 125      -8.116  27.087 147.611  1.00 33.82           O  
ATOM    967  NE2 GLN A 125      -9.700  25.506 147.354  1.00 35.14           N  
ATOM    968  N   LEU A 126     -11.062  26.548 153.472  1.00 18.20           N  
ATOM    969  CA  LEU A 126     -11.041  25.622 154.574  1.00 18.45           C  
ATOM    970  C   LEU A 126     -12.451  25.110 154.942  1.00 19.93           C  
ATOM    971  O   LEU A 126     -12.618  23.927 155.232  1.00 19.69           O  
ATOM    972  CB  LEU A 126     -10.381  26.249 155.796  1.00 18.13           C  
ATOM    973  CG  LEU A 126      -8.875  26.452 155.673  1.00 17.52           C  
ATOM    974  CD1 LEU A 126      -8.390  27.143 156.918  1.00 17.67           C  
ATOM    975  CD2 LEU A 126      -8.156  25.135 155.484  1.00 18.12           C  
ATOM    976  N   LYS A 127     -13.448  25.993 154.933  1.00 19.46           N  
ATOM    977  CA  LYS A 127     -14.796  25.576 155.301  1.00 21.08           C  
ATOM    978  C   LYS A 127     -15.366  24.637 154.211  1.00 21.29           C  
ATOM    979  O   LYS A 127     -16.039  23.671 154.547  1.00 23.44           O  
ATOM    980  CB  LYS A 127     -15.697  26.789 155.505  1.00 20.33           C  
ATOM    981  CG  LYS A 127     -15.572  27.455 156.877  1.00 20.62           C  
ATOM    982  CD  LYS A 127     -16.681  28.506 157.074  1.00 21.71           C  
ATOM    983  CE  LYS A 127     -16.644  29.156 158.464  1.00 21.32           C  
ATOM    984  NZ  LYS A 127     -16.908  28.231 159.608  1.00 23.06           N  
ATOM    985  N   LYS A 128     -15.106  24.930 152.944  1.00 22.82           N  
ATOM    986  CA  LYS A 128     -15.725  24.185 151.836  1.00 24.43           C  
ATOM    987  C   LYS A 128     -15.010  22.879 151.531  1.00 25.74           C  
ATOM    988  O   LYS A 128     -15.643  21.831 151.372  1.00 26.72           O  
ATOM    989  CB  LYS A 128     -15.760  25.014 150.564  1.00 25.04           C  
ATOM    990  CG  LYS A 128     -16.486  24.327 149.375  1.00 27.59           C  
ATOM    991  CD  LYS A 128     -16.429  25.189 148.131  1.00 32.22           C  
ATOM    992  CE  LYS A 128     -17.044  24.476 146.906  1.00 35.02           C  
ATOM    993  NZ  LYS A 128     -17.475  25.502 145.909  1.00 37.11           N  
ATOM    994  N   LYS A 129     -13.694  22.958 151.418  1.00 27.16           N  
ATOM    995  CA  LYS A 129     -12.890  21.828 150.951  1.00 28.67           C  
ATOM    996  C   LYS A 129     -12.390  20.934 152.104  1.00 29.11           C  
ATOM    997  O   LYS A 129     -12.321  19.696 151.966  1.00 29.27           O  
ATOM    998  CB  LYS A 129     -11.741  22.369 150.089  1.00 28.75           C  
ATOM    999  CG  LYS A 129     -11.091  21.359 149.140  1.00 31.80           C  
ATOM   1000  CD  LYS A 129     -10.282  22.082 148.033  1.00 34.20           C  
ATOM   1001  CE  LYS A 129      -9.096  21.239 147.541  1.00 37.11           C  
ATOM   1002  NZ  LYS A 129      -8.397  21.865 146.359  1.00 37.24           N  
ATOM   1003  N   TYR A 130     -12.063  21.520 153.248  1.00 29.97           N  
ATOM   1004  CA  TYR A 130     -11.404  20.746 154.309  1.00 31.15           C  
ATOM   1005  C   TYR A 130     -12.287  20.490 155.524  1.00 31.85           C  
ATOM   1006  O   TYR A 130     -11.807  20.020 156.551  1.00 33.13           O  
ATOM   1007  CB  TYR A 130     -10.032  21.369 154.657  1.00 31.03           C  
ATOM   1008  CG  TYR A 130      -9.091  21.462 153.441  1.00 32.57           C  
ATOM   1009  CD1 TYR A 130      -9.058  22.597 152.656  1.00 34.39           C  
ATOM   1010  CD2 TYR A 130      -8.256  20.392 153.072  1.00 35.36           C  
ATOM   1011  CE1 TYR A 130      -8.224  22.693 151.541  1.00 36.08           C  
ATOM   1012  CE2 TYR A 130      -7.409  20.476 151.951  1.00 35.58           C  
ATOM   1013  CZ  TYR A 130      -7.404  21.632 151.183  1.00 37.31           C  
ATOM   1014  OH  TYR A 130      -6.594  21.780 150.057  1.00 38.77           O  
ATOM   1015  N   ASP A 131     -13.588  20.785 155.376  1.00 32.60           N  
ATOM   1016  CA  ASP A 131     -14.625  20.548 156.391  1.00 33.18           C  
ATOM   1017  C   ASP A 131     -14.406  21.247 157.740  1.00 31.71           C  
ATOM   1018  O   ASP A 131     -14.859  20.760 158.788  1.00 32.76           O  
ATOM   1019  CB  ASP A 131     -14.816  19.033 156.633  1.00 34.36           C  
ATOM   1020  CG  ASP A 131     -15.518  18.314 155.479  1.00 38.97           C  
ATOM   1021  OD1 ASP A 131     -16.261  18.956 154.688  1.00 43.73           O  
ATOM   1022  OD2 ASP A 131     -15.396  17.068 155.311  1.00 45.08           O  
ATOM   1023  N   VAL A 132     -13.728  22.391 157.733  1.00 28.50           N  
ATOM   1024  CA  VAL A 132     -13.446  23.099 158.976  1.00 26.55           C  
ATOM   1025  C   VAL A 132     -14.630  23.946 159.441  1.00 24.65           C  
ATOM   1026  O   VAL A 132     -15.247  24.636 158.645  1.00 25.84           O  
ATOM   1027  CB  VAL A 132     -12.214  24.017 158.798  1.00 26.40           C  
ATOM   1028  CG1 VAL A 132     -11.980  24.865 160.047  1.00 24.23           C  
ATOM   1029  CG2 VAL A 132     -10.990  23.194 158.479  1.00 26.32           C  
ATOM   1030  N   ASP A 133     -14.906  23.932 160.735  1.00 23.92           N  
ATOM   1031  CA  ASP A 133     -15.832  24.881 161.335  1.00 22.94           C  
ATOM   1032  C   ASP A 133     -15.006  26.111 161.799  1.00 21.32           C  
ATOM   1033  O   ASP A 133     -14.905  27.110 161.072  1.00 20.86           O  
ATOM   1034  CB  ASP A 133     -16.589  24.238 162.508  1.00 23.89           C  
ATOM   1035  CG  ASP A 133     -17.555  25.190 163.189  1.00 26.41           C  
ATOM   1036  OD1 ASP A 133     -17.887  26.253 162.616  1.00 30.08           O  
ATOM   1037  OD2 ASP A 133     -18.058  24.956 164.317  1.00 30.70           O  
ATOM   1038  N   THR A 134     -14.444  26.016 163.003  1.00 20.55           N  
ATOM   1039  CA  THR A 134     -13.532  27.043 163.527  1.00 20.03           C  
ATOM   1040  C   THR A 134     -12.238  26.392 164.014  1.00 19.35           C  
ATOM   1041  O   THR A 134     -12.166  25.186 164.274  1.00 19.42           O  
ATOM   1042  CB  THR A 134     -14.124  27.864 164.663  1.00 19.47           C  
ATOM   1043  OG1 THR A 134     -14.582  27.011 165.717  1.00 22.36           O  
ATOM   1044  CG2 THR A 134     -15.353  28.658 164.225  1.00 19.92           C  
ATOM   1045  N   LEU A 135     -11.207  27.215 164.093  1.00 18.03           N  
ATOM   1046  CA  LEU A 135      -9.894  26.782 164.516  1.00 16.98           C  
ATOM   1047  C   LEU A 135      -9.708  27.033 166.000  1.00 15.19           C  
ATOM   1048  O   LEU A 135     -10.194  28.011 166.544  1.00 16.69           O  
ATOM   1049  CB  LEU A 135      -8.817  27.524 163.713  1.00 17.01           C  
ATOM   1050  CG  LEU A 135      -8.938  27.411 162.209  1.00 17.68           C  
ATOM   1051  CD1 LEU A 135      -8.082  28.460 161.542  1.00 17.48           C  
ATOM   1052  CD2 LEU A 135      -8.572  26.018 161.720  1.00 19.13           C  
ATOM   1053  N   ASP A 136      -9.020  26.131 166.682  1.00 12.96           N  
ATOM   1054  CA  ASP A 136      -8.727  26.321 168.086  1.00 13.35           C  
ATOM   1055  C   ASP A 136      -7.437  27.099 168.296  1.00 14.01           C  
ATOM   1056  O   ASP A 136      -7.307  27.786 169.304  1.00 13.87           O  
ATOM   1057  CB  ASP A 136      -8.683  25.014 168.837  1.00 13.64           C  
ATOM   1058  CG  ASP A 136      -9.958  24.218 168.645  1.00 17.69           C  
ATOM   1059  OD1 ASP A 136     -11.050  24.772 168.934  1.00 17.97           O  
ATOM   1060  OD2 ASP A 136      -9.921  23.056 168.193  1.00 18.99           O  
ATOM   1061  N   MET A 137      -6.538  27.024 167.323  1.00 14.13           N  
ATOM   1062  CA  MET A 137      -5.244  27.687 167.461  1.00 14.07           C  
ATOM   1063  C   MET A 137      -4.649  27.877 166.088  1.00 13.34           C  
ATOM   1064  O   MET A 137      -4.842  27.062 165.199  1.00 13.58           O  
ATOM   1065  CB  MET A 137      -4.334  26.850 168.338  1.00 13.29           C  
ATOM   1066  CG  MET A 137      -2.889  27.398 168.520  1.00 14.55           C  
ATOM   1067  SD  MET A 137      -1.998  26.544 169.765  1.00 16.11           S  
ATOM   1068  CE  MET A 137      -0.276  27.133 169.418  1.00 19.31           C  
ATOM   1069  N   VAL A 138      -3.923  28.988 165.919  1.00 12.36           N  
ATOM   1070  CA  VAL A 138      -3.219  29.292 164.703  1.00 11.82           C  
ATOM   1071  C   VAL A 138      -1.785  29.675 165.076  1.00 12.08           C  
ATOM   1072  O   VAL A 138      -1.589  30.532 165.894  1.00 12.56           O  
ATOM   1073  CB  VAL A 138      -3.820  30.484 163.963  1.00 12.58           C  
ATOM   1074  CG1 VAL A 138      -3.080  30.728 162.611  1.00 13.49           C  
ATOM   1075  CG2 VAL A 138      -5.322  30.285 163.703  1.00 13.21           C  
ATOM   1076  N   PHE A 139      -0.805  29.063 164.425  1.00 10.61           N  
ATOM   1077  CA  PHE A 139       0.606  29.444 164.586  1.00 10.76           C  
ATOM   1078  C   PHE A 139       0.993  30.166 163.293  1.00 10.62           C  
ATOM   1079  O   PHE A 139       0.959  29.619 162.182  1.00 10.35           O  
ATOM   1080  CB  PHE A 139       1.493  28.234 164.836  1.00 10.84           C  
ATOM   1081  CG  PHE A 139       2.983  28.569 164.930  1.00 10.74           C  
ATOM   1082  CD1 PHE A 139       3.409  29.537 165.783  1.00 12.19           C  
ATOM   1083  CD2 PHE A 139       3.913  27.901 164.179  1.00 11.47           C  
ATOM   1084  CE1 PHE A 139       4.773  29.847 165.889  1.00 12.49           C  
ATOM   1085  CE2 PHE A 139       5.268  28.201 164.288  1.00 11.68           C  
ATOM   1086  CZ  PHE A 139       5.680  29.194 165.131  1.00 11.44           C  
ATOM   1087  N   LEU A 140       1.339  31.443 163.421  1.00 10.17           N  
ATOM   1088  CA  LEU A 140       1.776  32.240 162.309  1.00  9.49           C  
ATOM   1089  C   LEU A 140       3.294  32.315 162.273  1.00  9.97           C  
ATOM   1090  O   LEU A 140       3.923  32.813 163.190  1.00  9.68           O  
ATOM   1091  CB  LEU A 140       1.216  33.657 162.404  1.00 10.30           C  
ATOM   1092  CG  LEU A 140      -0.317  33.820 162.468  1.00 10.94           C  
ATOM   1093  CD1 LEU A 140      -0.881  33.668 163.905  1.00 13.53           C  
ATOM   1094  CD2 LEU A 140      -0.740  35.127 161.836  1.00 13.30           C  
ATOM   1095  N   ASP A 141       3.871  31.818 161.188  1.00  9.79           N  
ATOM   1096  CA  ASP A 141       5.342  31.767 161.015  1.00  9.86           C  
ATOM   1097  C   ASP A 141       5.710  31.723 159.542  1.00 10.31           C  
ATOM   1098  O   ASP A 141       6.678  31.032 159.162  1.00 12.31           O  
ATOM   1099  CB  ASP A 141       5.885  30.567 161.748  1.00 10.04           C  
ATOM   1100  CG  ASP A 141       7.378  30.615 161.979  1.00 10.31           C  
ATOM   1101  OD1 ASP A 141       7.999  31.735 161.971  1.00  9.07           O  
ATOM   1102  OD2 ASP A 141       7.978  29.544 162.191  1.00 10.21           O  
ATOM   1103  N   HIS A 142       4.973  32.474 158.722  1.00 10.54           N  
ATOM   1104  CA  HIS A 142       5.242  32.557 157.308  1.00 10.95           C  
ATOM   1105  C   HIS A 142       5.890  33.896 156.965  1.00 11.49           C  
ATOM   1106  O   HIS A 142       6.492  34.497 157.849  1.00 11.97           O  
ATOM   1107  CB  HIS A 142       4.029  32.149 156.452  1.00 11.84           C  
ATOM   1108  CG  HIS A 142       2.779  32.912 156.735  1.00 12.68           C  
ATOM   1109  ND1 HIS A 142       2.561  33.578 157.919  1.00 14.01           N  
ATOM   1110  CD2 HIS A 142       1.636  33.034 156.010  1.00 12.55           C  
ATOM   1111  CE1 HIS A 142       1.349  34.119 157.892  1.00 13.83           C  
ATOM   1112  NE2 HIS A 142       0.767  33.815 156.737  1.00 12.36           N  
ATOM   1113  N   TRP A 143       5.849  34.373 155.720  1.00 10.83           N  
ATOM   1114  CA  TRP A 143       6.488  35.657 155.461  1.00 11.69           C  
ATOM   1115  C   TRP A 143       5.751  36.716 156.280  1.00 11.28           C  
ATOM   1116  O   TRP A 143       4.523  36.706 156.380  1.00 11.84           O  
ATOM   1117  CB  TRP A 143       6.503  36.016 153.991  1.00 11.98           C  
ATOM   1118  CG  TRP A 143       7.245  35.099 153.060  1.00 12.82           C  
ATOM   1119  CD1 TRP A 143       6.971  34.977 151.746  1.00 16.32           C  
ATOM   1120  CD2 TRP A 143       8.320  34.154 153.324  1.00 14.07           C  
ATOM   1121  NE1 TRP A 143       7.801  34.065 151.159  1.00 16.45           N  
ATOM   1122  CE2 TRP A 143       8.640  33.541 152.104  1.00 15.28           C  
ATOM   1123  CE3 TRP A 143       9.056  33.773 154.453  1.00 14.25           C  
ATOM   1124  CZ2 TRP A 143       9.623  32.560 151.977  1.00 14.37           C  
ATOM   1125  CZ3 TRP A 143      10.047  32.802 154.311  1.00 13.55           C  
ATOM   1126  CH2 TRP A 143      10.338  32.228 153.082  1.00 15.23           C  
ATOM   1127  N   LYS A 144       6.499  37.600 156.931  1.00 11.10           N  
ATOM   1128  CA  LYS A 144       5.911  38.466 157.960  1.00 10.69           C  
ATOM   1129  C   LYS A 144       4.875  39.459 157.442  1.00 10.42           C  
ATOM   1130  O   LYS A 144       3.979  39.842 158.207  1.00 11.49           O  
ATOM   1131  CB  LYS A 144       6.982  39.171 158.812  1.00 11.71           C  
ATOM   1132  CG  LYS A 144       8.100  38.277 159.355  1.00 11.70           C  
ATOM   1133  CD  LYS A 144       7.600  36.959 159.887  1.00 11.73           C  
ATOM   1134  CE  LYS A 144       8.682  35.946 160.071  1.00 11.27           C  
ATOM   1135  NZ  LYS A 144       8.080  34.564 160.208  1.00  9.56           N  
ATOM   1136  N   ASP A 145       4.978  39.851 156.188  1.00 11.38           N  
ATOM   1137  CA  ASP A 145       3.965  40.704 155.584  1.00 13.05           C  
ATOM   1138  C   ASP A 145       2.598  40.044 155.425  1.00 12.82           C  
ATOM   1139  O   ASP A 145       1.619  40.730 155.136  1.00 13.35           O  
ATOM   1140  CB  ASP A 145       4.404  41.250 154.229  1.00 14.20           C  
ATOM   1141  CG  ASP A 145       4.527  40.193 153.176  1.00 19.60           C  
ATOM   1142  OD1 ASP A 145       4.952  39.088 153.474  1.00 27.36           O  
ATOM   1143  OD2 ASP A 145       4.264  40.404 151.986  1.00 30.49           O  
ATOM   1144  N   ARG A 146       2.508  38.747 155.656  1.00 12.17           N  
ATOM   1145  CA  ARG A 146       1.222  38.059 155.546  1.00 11.99           C  
ATOM   1146  C   ARG A 146       0.515  37.899 156.880  1.00 11.59           C  
ATOM   1147  O   ARG A 146      -0.667  37.547 156.926  1.00 12.81           O  
ATOM   1148  CB  ARG A 146       1.385  36.680 154.915  1.00 12.99           C  
ATOM   1149  CG  ARG A 146       2.003  36.689 153.524  1.00 15.99           C  
ATOM   1150  CD  ARG A 146       1.494  37.789 152.585  1.00 19.28           C  
ATOM   1151  NE  ARG A 146       0.043  37.700 152.434  1.00 22.92           N  
ATOM   1152  CZ  ARG A 146      -0.687  38.559 151.739  1.00 23.31           C  
ATOM   1153  NH1 ARG A 146      -0.141  39.624 151.171  1.00 26.57           N  
ATOM   1154  NH2 ARG A 146      -1.992  38.395 151.681  1.00 22.81           N  
ATOM   1155  N   TYR A 147       1.176  38.176 158.006  1.00 11.43           N  
ATOM   1156  CA  TYR A 147       0.499  37.923 159.288  1.00 10.54           C  
ATOM   1157  C   TYR A 147      -0.788  38.735 159.405  1.00 11.92           C  
ATOM   1158  O   TYR A 147      -1.809  38.195 159.826  1.00 11.25           O  
ATOM   1159  CB  TYR A 147       1.357  38.277 160.501  1.00 10.75           C  
ATOM   1160  CG  TYR A 147       2.493  37.325 160.872  1.00  9.53           C  
ATOM   1161  CD1 TYR A 147       3.159  36.521 159.944  1.00  9.96           C  
ATOM   1162  CD2 TYR A 147       2.970  37.310 162.164  1.00  9.90           C  
ATOM   1163  CE1 TYR A 147       4.236  35.726 160.310  1.00  9.53           C  
ATOM   1164  CE2 TYR A 147       4.069  36.550 162.542  1.00  9.98           C  
ATOM   1165  CZ  TYR A 147       4.714  35.766 161.626  1.00  8.72           C  
ATOM   1166  OH  TYR A 147       5.796  35.034 162.074  1.00  9.99           O  
ATOM   1167  N   LEU A 148      -0.707  40.029 159.122  1.00 11.45           N  
ATOM   1168  CA  LEU A 148      -1.885  40.900 159.282  1.00 11.35           C  
ATOM   1169  C   LEU A 148      -2.980  40.526 158.262  1.00 12.39           C  
ATOM   1170  O   LEU A 148      -4.114  40.261 158.678  1.00 12.07           O  
ATOM   1171  CB  LEU A 148      -1.500  42.390 159.255  1.00 12.56           C  
ATOM   1172  CG  LEU A 148      -2.694  43.342 159.299  1.00 12.70           C  
ATOM   1173  CD1 LEU A 148      -3.484  43.156 160.514  1.00 14.68           C  
ATOM   1174  CD2 LEU A 148      -2.245  44.794 159.161  1.00 14.11           C  
ATOM   1175  N   PRO A 149      -2.697  40.502 156.970  1.00 12.70           N  
ATOM   1176  CA  PRO A 149      -3.805  40.175 156.054  1.00 12.63           C  
ATOM   1177  C   PRO A 149      -4.377  38.784 156.319  1.00 12.72           C  
ATOM   1178  O   PRO A 149      -5.599  38.642 156.221  1.00 13.24           O  
ATOM   1179  CB  PRO A 149      -3.202  40.341 154.659  1.00 13.10           C  
ATOM   1180  CG  PRO A 149      -1.711  40.427 154.883  1.00 13.66           C  
ATOM   1181  CD  PRO A 149      -1.474  40.888 156.252  1.00 12.42           C  
ATOM   1182  N   ASP A 150      -3.593  37.782 156.708  1.00 13.00           N  
ATOM   1183  CA  ASP A 150      -4.185  36.469 156.976  1.00 13.03           C  
ATOM   1184  C   ASP A 150      -5.037  36.474 158.230  1.00 13.02           C  
ATOM   1185  O   ASP A 150      -6.024  35.772 158.309  1.00 13.04           O  
ATOM   1186  CB  ASP A 150      -3.149  35.349 157.054  1.00 13.58           C  
ATOM   1187  CG  ASP A 150      -2.607  34.954 155.713  1.00 14.99           C  
ATOM   1188  OD1 ASP A 150      -3.122  35.397 154.659  1.00 18.25           O  
ATOM   1189  OD2 ASP A 150      -1.650  34.140 155.621  1.00 15.85           O  
ATOM   1190  N   THR A 151      -4.654  37.262 159.229  1.00 12.13           N  
ATOM   1191  CA  THR A 151      -5.443  37.386 160.440  1.00 12.61           C  
ATOM   1192  C   THR A 151      -6.807  38.006 160.110  1.00 13.59           C  
ATOM   1193  O   THR A 151      -7.836  37.521 160.593  1.00 13.82           O  
ATOM   1194  CB  THR A 151      -4.696  38.208 161.503  1.00 12.98           C  
ATOM   1195  OG1 THR A 151      -3.523  37.479 161.930  1.00 12.11           O  
ATOM   1196  CG2 THR A 151      -5.538  38.347 162.772  1.00 13.07           C  
ATOM   1197  N   LEU A 152      -6.803  39.060 159.328  1.00 13.35           N  
ATOM   1198  CA  LEU A 152      -8.051  39.693 158.911  1.00 12.95           C  
ATOM   1199  C   LEU A 152      -8.910  38.705 158.115  1.00 14.41           C  
ATOM   1200  O   LEU A 152     -10.117  38.647 158.307  1.00 15.98           O  
ATOM   1201  CB  LEU A 152      -7.760  40.943 158.086  1.00 13.67           C  
ATOM   1202  CG  LEU A 152      -7.090  42.089 158.846  1.00 13.17           C  
ATOM   1203  CD1 LEU A 152      -6.737  43.193 157.911  1.00 14.48           C  
ATOM   1204  CD2 LEU A 152      -7.943  42.603 159.995  1.00 15.35           C  
ATOM   1205  N   LEU A 153      -8.281  37.949 157.223  1.00 14.57           N  
ATOM   1206  CA  LEU A 153      -8.970  36.987 156.367  1.00 14.37           C  
ATOM   1207  C   LEU A 153      -9.561  35.835 157.176  1.00 14.50           C  
ATOM   1208  O   LEU A 153     -10.705  35.409 156.950  1.00 13.34           O  
ATOM   1209  CB  LEU A 153      -7.994  36.464 155.330  1.00 14.48           C  
ATOM   1210  CG  LEU A 153      -8.601  35.558 154.265  1.00 16.80           C  
ATOM   1211  CD1 LEU A 153      -9.649  36.330 153.494  1.00 18.16           C  
ATOM   1212  CD2 LEU A 153      -7.513  35.105 153.319  1.00 17.09           C  
ATOM   1213  N   LEU A 154      -8.819  35.346 158.165  1.00 13.48           N  
ATOM   1214  CA  LEU A 154      -9.315  34.331 159.073  1.00 13.83           C  
ATOM   1215  C   LEU A 154     -10.603  34.791 159.779  1.00 14.71           C  
ATOM   1216  O   LEU A 154     -11.605  34.018 159.870  1.00 14.12           O  
ATOM   1217  CB  LEU A 154      -8.235  33.959 160.117  1.00 14.21           C  
ATOM   1218  CG  LEU A 154      -7.108  33.064 159.581  1.00 13.18           C  
ATOM   1219  CD1 LEU A 154      -5.985  33.067 160.595  1.00 14.51           C  
ATOM   1220  CD2 LEU A 154      -7.541  31.625 159.323  1.00 15.89           C  
ATOM   1221  N   GLU A 155     -10.598  36.030 160.252  1.00 14.37           N  
ATOM   1222  CA  GLU A 155     -11.767  36.608 160.922  1.00 15.84           C  
ATOM   1223  C   GLU A 155     -12.934  36.706 159.928  1.00 16.66           C  
ATOM   1224  O   GLU A 155     -14.050  36.258 160.241  1.00 15.99           O  
ATOM   1225  CB  GLU A 155     -11.477  37.973 161.568  0.60 16.34           C  
ATOM   1227  CG  GLU A 155     -12.732  38.529 162.258  0.60 17.47           C  
ATOM   1229  CD  GLU A 155     -12.496  39.635 163.263  0.60 20.17           C  
ATOM   1231  OE1 GLU A 155     -11.389  40.228 163.260  0.60 21.01           O  
ATOM   1233  OE2 GLU A 155     -13.448  39.927 164.042  0.60 15.28           O  
ATOM   1235  N   LYS A 156     -12.668  37.275 158.747  1.00 16.45           N  
ATOM   1236  CA  LYS A 156     -13.695  37.534 157.741  1.00 17.11           C  
ATOM   1237  C   LYS A 156     -14.366  36.231 157.311  1.00 17.18           C  
ATOM   1238  O   LYS A 156     -15.594  36.167 157.094  1.00 17.17           O  
ATOM   1239  CB  LYS A 156     -13.067  38.168 156.528  1.00 17.50           C  
ATOM   1240  CG  LYS A 156     -14.079  38.624 155.463  1.00 20.72           C  
ATOM   1241  CD  LYS A 156     -13.359  39.351 154.326  1.00 25.25           C  
ATOM   1242  CE  LYS A 156     -12.772  40.673 154.808  1.00 29.89           C  
ATOM   1243  NZ  LYS A 156     -12.527  41.659 153.719  1.00 33.97           N  
ATOM   1244  N   CYS A 157     -13.562  35.177 157.246  1.00 16.23           N  
ATOM   1245  CA  CYS A 157     -14.040  33.882 156.796  1.00 16.14           C  
ATOM   1246  C   CYS A 157     -14.744  33.079 157.869  1.00 15.35           C  
ATOM   1247  O   CYS A 157     -15.161  31.969 157.591  1.00 15.65           O  
ATOM   1248  CB  CYS A 157     -12.868  33.087 156.192  1.00 17.08           C  
ATOM   1249  SG  CYS A 157     -12.377  33.778 154.602  1.00 18.59           S  
ATOM   1250  N   GLY A 158     -14.811  33.565 159.105  1.00 15.24           N  
ATOM   1251  CA  GLY A 158     -15.504  32.876 160.171  1.00 15.62           C  
ATOM   1252  C   GLY A 158     -14.768  31.716 160.790  1.00 16.21           C  
ATOM   1253  O   GLY A 158     -15.345  30.847 161.404  1.00 17.91           O  
ATOM   1254  N   LEU A 159     -13.431  31.757 160.703  1.00 15.05           N  
ATOM   1255  CA  LEU A 159     -12.601  30.659 161.179  1.00 15.86           C  
ATOM   1256  C   LEU A 159     -12.119  30.813 162.612  1.00 15.34           C  
ATOM   1257  O   LEU A 159     -11.593  29.886 163.174  1.00 16.20           O  
ATOM   1258  CB  LEU A 159     -11.423  30.478 160.212  1.00 15.56           C  
ATOM   1259  CG  LEU A 159     -11.826  29.931 158.833  1.00 17.32           C  
ATOM   1260  CD1 LEU A 159     -10.747  30.138 157.784  1.00 18.18           C  
ATOM   1261  CD2 LEU A 159     -12.161  28.451 158.996  1.00 17.65           C  
ATOM   1262  N   LEU A 160     -12.313  31.983 163.191  1.00 15.68           N  
ATOM   1263  CA  LEU A 160     -11.945  32.245 164.560  1.00 16.43           C  
ATOM   1264  C   LEU A 160     -13.175  32.229 165.432  1.00 17.38           C  
ATOM   1265  O   LEU A 160     -14.232  32.717 165.029  1.00 19.63           O  
ATOM   1266  CB  LEU A 160     -11.237  33.614 164.687  1.00 17.12           C  
ATOM   1267  CG  LEU A 160     -10.040  33.828 163.743  1.00 16.64           C  
ATOM   1268  CD1 LEU A 160      -9.388  35.175 164.063  1.00 16.98           C  
ATOM   1269  CD2 LEU A 160      -9.013  32.737 163.857  1.00 16.01           C  
ATOM   1270  N   ARG A 161     -13.052  31.651 166.611  1.00 17.73           N  
ATOM   1271  CA  ARG A 161     -14.145  31.754 167.617  1.00 18.11           C  
ATOM   1272  C   ARG A 161     -13.612  32.375 168.897  1.00 17.80           C  
ATOM   1273  O   ARG A 161     -12.388  32.525 169.069  1.00 16.43           O  
ATOM   1274  CB  ARG A 161     -14.793  30.395 167.879  1.00 18.35           C  
ATOM   1275  CG  ARG A 161     -13.862  29.234 168.102  1.00 20.16           C  
ATOM   1276  CD  ARG A 161     -13.402  29.094 169.469  1.00 22.29           C  
ATOM   1277  NE  ARG A 161     -12.656  27.860 169.723  1.00 21.08           N  
ATOM   1278  CZ  ARG A 161     -12.078  27.615 170.886  1.00 17.74           C  
ATOM   1279  NH1 ARG A 161     -12.228  28.476 171.871  1.00 17.60           N  
ATOM   1280  NH2 ARG A 161     -11.361  26.515 171.096  1.00 19.58           N  
ATOM   1281  N   LYS A 162     -14.491  32.739 169.836  1.00 18.04           N  
ATOM   1282  CA  LYS A 162     -14.030  33.266 171.116  1.00 18.69           C  
ATOM   1283  C   LYS A 162     -13.154  32.230 171.828  1.00 18.04           C  
ATOM   1284  O   LYS A 162     -13.598  31.101 172.077  1.00 18.33           O  
ATOM   1285  CB  LYS A 162     -15.223  33.683 172.006  1.00 19.62           C  
ATOM   1286  CG  LYS A 162     -14.813  34.284 173.299  1.00 23.66           C  
ATOM   1287  CD  LYS A 162     -16.025  34.815 174.080  1.00 28.37           C  
ATOM   1288  CE  LYS A 162     -15.580  35.462 175.382  1.00 31.06           C  
ATOM   1289  NZ  LYS A 162     -16.606  36.426 175.835  1.00 35.31           N  
ATOM   1290  N   GLY A 163     -11.902  32.602 172.133  1.00 17.35           N  
ATOM   1291  CA  GLY A 163     -10.929  31.707 172.732  1.00 16.37           C  
ATOM   1292  C   GLY A 163      -9.915  31.095 171.769  1.00 15.35           C  
ATOM   1293  O   GLY A 163      -9.025  30.394 172.206  1.00 16.55           O  
ATOM   1294  N   THR A 164     -10.074  31.321 170.476  1.00 14.79           N  
ATOM   1295  CA  THR A 164      -9.088  30.828 169.498  1.00 14.27           C  
ATOM   1296  C   THR A 164      -7.770  31.523 169.837  1.00 14.29           C  
ATOM   1297  O   THR A 164      -7.771  32.752 169.965  1.00 13.89           O  
ATOM   1298  CB  THR A 164      -9.497  31.187 168.069  1.00 15.00           C  
ATOM   1299  OG1 THR A 164     -10.649  30.398 167.664  1.00 15.12           O  
ATOM   1300  CG2 THR A 164      -8.441  30.804 167.098  1.00 15.27           C  
ATOM   1301  N   VAL A 165      -6.687  30.756 169.860  1.00 12.81           N  
ATOM   1302  CA  VAL A 165      -5.361  31.272 170.229  1.00 12.45           C  
ATOM   1303  C   VAL A 165      -4.557  31.476 168.956  1.00 12.85           C  
ATOM   1304  O   VAL A 165      -4.339  30.536 168.212  1.00 13.78           O  
ATOM   1305  CB  VAL A 165      -4.626  30.280 171.143  1.00 13.42           C  
ATOM   1306  CG1 VAL A 165      -3.214  30.779 171.478  1.00 15.45           C  
ATOM   1307  CG2 VAL A 165      -5.410  30.040 172.435  1.00 14.80           C  
ATOM   1308  N   LEU A 166      -4.085  32.698 168.741  1.00 11.69           N  
ATOM   1309  CA  LEU A 166      -3.089  32.982 167.723  1.00 12.35           C  
ATOM   1310  C   LEU A 166      -1.742  33.083 168.406  1.00 11.43           C  
ATOM   1311  O   LEU A 166      -1.606  33.669 169.488  1.00 13.69           O  
ATOM   1312  CB  LEU A 166      -3.385  34.298 167.006  1.00 12.25           C  
ATOM   1313  CG  LEU A 166      -4.743  34.544 166.359  1.00 16.39           C  
ATOM   1314  CD1 LEU A 166      -4.635  35.813 165.526  1.00 16.93           C  
ATOM   1315  CD2 LEU A 166      -5.293  33.431 165.507  1.00 19.93           C  
ATOM   1316  N   LEU A 167      -0.742  32.456 167.815  1.00 10.96           N  
ATOM   1317  CA  LEU A 167       0.598  32.478 168.354  1.00 10.92           C  
ATOM   1318  C   LEU A 167       1.479  32.861 167.212  1.00 10.40           C  
ATOM   1319  O   LEU A 167       1.514  32.136 166.222  1.00 10.90           O  
ATOM   1320  CB  LEU A 167       1.029  31.097 168.893  1.00 11.22           C  
ATOM   1321  CG  LEU A 167       2.381  31.070 169.606  1.00 12.39           C  
ATOM   1322  CD1 LEU A 167       2.326  31.962 170.837  1.00 13.24           C  
ATOM   1323  CD2 LEU A 167       2.751  29.631 169.937  1.00 13.48           C  
ATOM   1324  N   ALA A 168       2.151  34.020 167.305  1.00  9.10           N  
ATOM   1325  CA  ALA A 168       2.898  34.583 166.196  1.00  9.05           C  
ATOM   1326  C   ALA A 168       4.387  34.605 166.507  1.00  9.04           C  
ATOM   1327  O   ALA A 168       4.794  35.155 167.520  1.00  9.40           O  
ATOM   1328  CB  ALA A 168       2.431  36.013 165.905  1.00  9.10           C  
ATOM   1329  N   ASP A 169       5.192  34.037 165.610  1.00  8.75           N  
ATOM   1330  CA  ASP A 169       6.641  34.061 165.702  1.00  9.01           C  
ATOM   1331  C   ASP A 169       7.204  35.386 165.212  1.00  9.25           C  
ATOM   1332  O   ASP A 169       6.634  36.045 164.357  1.00  9.76           O  
ATOM   1333  CB  ASP A 169       7.269  32.925 164.880  1.00  9.03           C  
ATOM   1334  CG  ASP A 169       8.714  32.625 165.306  1.00  9.72           C  
ATOM   1335  OD1 ASP A 169       9.099  32.976 166.464  1.00 10.69           O  
ATOM   1336  OD2 ASP A 169       9.523  32.025 164.527  1.00 10.27           O  
ATOM   1337  N   ASN A 170       8.389  35.736 165.726  1.00  9.11           N  
ATOM   1338  CA  ASN A 170       9.220  36.781 165.103  1.00  9.42           C  
ATOM   1339  C   ASN A 170       8.671  38.186 165.243  1.00  9.82           C  
ATOM   1340  O   ASN A 170       8.937  39.067 164.438  1.00 10.97           O  
ATOM   1341  CB  ASN A 170       9.508  36.470 163.644  1.00  9.67           C  
ATOM   1342  CG  ASN A 170      10.175  35.184 163.479  1.00 11.27           C  
ATOM   1343  OD1 ASN A 170      11.328  34.978 163.980  1.00 13.80           O  
ATOM   1344  ND2 ASN A 170       9.518  34.263 162.810  1.00  6.04           N  
ATOM   1345  N   VAL A 171       7.869  38.408 166.275  1.00 10.41           N  
ATOM   1346  CA  VAL A 171       7.268  39.747 166.402  1.00 10.87           C  
ATOM   1347  C   VAL A 171       8.286  40.838 166.767  1.00 11.61           C  
ATOM   1348  O   VAL A 171       7.992  42.028 166.559  1.00 13.14           O  
ATOM   1349  CB  VAL A 171       6.078  39.781 167.377  1.00 11.27           C  
ATOM   1350  CG1 VAL A 171       5.039  38.694 166.961  1.00 11.39           C  
ATOM   1351  CG2 VAL A 171       6.495  39.581 168.819  1.00 12.95           C  
ATOM   1352  N   ILE A 172       9.475  40.424 167.195  1.00 10.71           N  
ATOM   1353  CA  ILE A 172      10.588  41.369 167.473  1.00 11.04           C  
ATOM   1354  C   ILE A 172      11.618  41.362 166.321  1.00 11.05           C  
ATOM   1355  O   ILE A 172      11.955  42.440 165.779  1.00 11.33           O  
ATOM   1356  CB  ILE A 172      11.254  41.103 168.825  1.00 12.27           C  
ATOM   1357  CG1 ILE A 172      10.219  41.093 169.963  1.00 15.11           C  
ATOM   1358  CG2 ILE A 172      12.398  42.131 169.102  1.00 13.09           C  
ATOM   1359  CD1 ILE A 172       9.374  42.307 170.082  1.00 17.59           C  
ATOM   1360  N   VAL A 173      12.095  40.170 165.962  1.00 10.21           N  
ATOM   1361  CA  VAL A 173      13.103  39.970 164.887  1.00 10.01           C  
ATOM   1362  C   VAL A 173      12.632  38.862 163.951  1.00  9.99           C  
ATOM   1363  O   VAL A 173      12.443  37.727 164.418  1.00 10.76           O  
ATOM   1364  CB  VAL A 173      14.480  39.579 165.427  1.00 10.79           C  
ATOM   1365  CG1 VAL A 173      15.477  39.373 164.292  1.00 11.65           C  
ATOM   1366  CG2 VAL A 173      14.961  40.640 166.418  1.00 10.42           C  
ATOM   1367  N   PRO A 174      12.507  39.123 162.651  1.00  9.70           N  
ATOM   1368  CA  PRO A 174      12.709  40.435 162.025  1.00 10.65           C  
ATOM   1369  C   PRO A 174      11.721  41.532 162.427  1.00 11.44           C  
ATOM   1370  O   PRO A 174      11.965  42.698 162.125  1.00 11.27           O  
ATOM   1371  CB  PRO A 174      12.543  40.115 160.525  1.00 11.56           C  
ATOM   1372  CG  PRO A 174      12.905  38.648 160.426  1.00 12.08           C  
ATOM   1373  CD  PRO A 174      12.281  38.077 161.630  1.00 11.19           C  
ATOM   1374  N   GLY A 175      10.591  41.136 163.008  1.00 11.33           N  
ATOM   1375  CA  GLY A 175       9.552  42.059 163.446  1.00 12.06           C  
ATOM   1376  C   GLY A 175       8.304  41.986 162.593  1.00 12.02           C  
ATOM   1377  O   GLY A 175       8.360  41.722 161.380  1.00 11.29           O  
ATOM   1378  N   THR A 176       7.174  42.219 163.249  1.00 11.96           N  
ATOM   1379  CA  THR A 176       5.879  42.196 162.576  1.00 12.15           C  
ATOM   1380  C   THR A 176       5.103  43.435 163.000  1.00 13.04           C  
ATOM   1381  O   THR A 176       4.088  43.342 163.688  1.00 12.59           O  
ATOM   1382  CB  THR A 176       5.117  40.912 162.896  1.00 12.40           C  
ATOM   1383  OG1 THR A 176       4.860  40.804 164.296  1.00 11.93           O  
ATOM   1384  CG2 THR A 176       5.931  39.662 162.524  1.00 13.45           C  
ATOM   1385  N   PRO A 177       5.572  44.620 162.636  1.00 14.28           N  
ATOM   1386  CA  PRO A 177       4.984  45.815 163.247  1.00 14.13           C  
ATOM   1387  C   PRO A 177       3.499  46.018 162.947  1.00 13.56           C  
ATOM   1388  O   PRO A 177       2.766  46.424 163.884  1.00 12.74           O  
ATOM   1389  CB  PRO A 177       5.857  46.967 162.714  1.00 15.08           C  
ATOM   1390  CG  PRO A 177       6.631  46.427 161.589  1.00 15.72           C  
ATOM   1391  CD  PRO A 177       6.718  44.945 161.771  1.00 15.21           C  
ATOM   1392  N   ASP A 178       3.073  45.733 161.728  1.00 13.74           N  
ATOM   1393  CA  ASP A 178       1.663  45.980 161.372  1.00 14.48           C  
ATOM   1394  C   ASP A 178       0.725  45.011 162.110  1.00 13.43           C  
ATOM   1395  O   ASP A 178      -0.330  45.400 162.590  1.00 12.94           O  
ATOM   1396  CB  ASP A 178       1.402  46.122 159.849  0.65 14.24           C  
ATOM   1398  CG  ASP A 178       1.563  44.820 159.028  0.65 17.29           C  
ATOM   1400  OD1 ASP A 178       2.079  43.794 159.514  0.65 16.41           O  
ATOM   1402  OD2 ASP A 178       1.242  44.767 157.815  0.65 21.42           O  
ATOM   1404  N   PHE A 179       1.149  43.767 162.239  1.00 11.64           N  
ATOM   1405  CA  PHE A 179       0.376  42.760 162.946  1.00 11.15           C  
ATOM   1406  C   PHE A 179       0.280  43.105 164.427  1.00 11.30           C  
ATOM   1407  O   PHE A 179      -0.808  43.040 165.021  1.00 10.99           O  
ATOM   1408  CB  PHE A 179       1.018  41.380 162.740  1.00 10.96           C  
ATOM   1409  CG  PHE A 179       0.450  40.333 163.638  1.00 10.23           C  
ATOM   1410  CD1 PHE A 179      -0.757  39.738 163.328  1.00 12.02           C  
ATOM   1411  CD2 PHE A 179       1.074  39.978 164.794  1.00 10.56           C  
ATOM   1412  CE1 PHE A 179      -1.304  38.772 164.163  1.00  9.49           C  
ATOM   1413  CE2 PHE A 179       0.523  39.022 165.643  1.00 11.73           C  
ATOM   1414  CZ  PHE A 179      -0.699  38.432 165.310  1.00 10.81           C  
ATOM   1415  N   LEU A 180       1.401  43.511 165.033  1.00 11.39           N  
ATOM   1416  CA  LEU A 180       1.381  43.880 166.450  1.00 12.00           C  
ATOM   1417  C   LEU A 180       0.525  45.085 166.704  1.00 12.60           C  
ATOM   1418  O   LEU A 180      -0.241  45.117 167.674  1.00 12.23           O  
ATOM   1419  CB  LEU A 180       2.787  44.188 167.006  1.00 12.79           C  
ATOM   1420  CG  LEU A 180       3.627  43.017 167.430  1.00 14.46           C  
ATOM   1421  CD1 LEU A 180       4.928  43.578 168.118  1.00 14.17           C  
ATOM   1422  CD2 LEU A 180       2.878  42.060 168.361  1.00 15.09           C  
ATOM   1423  N   ALA A 181       0.607  46.081 165.834  1.00 11.33           N  
ATOM   1424  CA  ALA A 181      -0.228  47.274 166.037  1.00 12.61           C  
ATOM   1425  C   ALA A 181      -1.705  46.925 165.949  1.00 13.05           C  
ATOM   1426  O   ALA A 181      -2.520  47.494 166.690  1.00 13.73           O  
ATOM   1427  CB  ALA A 181       0.117  48.342 165.059  1.00 12.34           C  
ATOM   1428  N   TYR A 182      -2.060  46.013 165.026  1.00 12.23           N  
ATOM   1429  CA  TYR A 182      -3.435  45.587 164.878  1.00 11.76           C  
ATOM   1430  C   TYR A 182      -3.937  44.867 166.146  1.00 12.45           C  
ATOM   1431  O   TYR A 182      -4.952  45.273 166.756  1.00 12.82           O  
ATOM   1432  CB  TYR A 182      -3.565  44.706 163.631  1.00 11.98           C  
ATOM   1433  CG  TYR A 182      -4.932  44.077 163.539  1.00 12.81           C  
ATOM   1434  CD1 TYR A 182      -6.058  44.869 163.439  1.00 15.38           C  
ATOM   1435  CD2 TYR A 182      -5.079  42.705 163.664  1.00 11.90           C  
ATOM   1436  CE1 TYR A 182      -7.319  44.313 163.397  1.00 15.19           C  
ATOM   1437  CE2 TYR A 182      -6.344  42.137 163.633  1.00 14.19           C  
ATOM   1438  CZ  TYR A 182      -7.451  42.940 163.498  1.00 16.26           C  
ATOM   1439  OH  TYR A 182      -8.718  42.368 163.484  1.00 19.76           O  
ATOM   1440  N   VAL A 183      -3.262  43.794 166.561  1.00 12.61           N  
ATOM   1441  CA  VAL A 183      -3.786  43.015 167.690  1.00 12.65           C  
ATOM   1442  C   VAL A 183      -3.715  43.812 169.004  1.00 13.58           C  
ATOM   1443  O   VAL A 183      -4.637  43.739 169.819  1.00 14.31           O  
ATOM   1444  CB  VAL A 183      -3.172  41.593 167.851  1.00 12.91           C  
ATOM   1445  CG1 VAL A 183      -3.479  40.760 166.626  1.00 14.78           C  
ATOM   1446  CG2 VAL A 183      -1.675  41.616 168.159  1.00 13.02           C  
ATOM   1447  N   ARG A 184      -2.664  44.608 169.162  1.00 13.91           N  
ATOM   1448  CA  ARG A 184      -2.508  45.445 170.343  1.00 14.58           C  
ATOM   1449  C   ARG A 184      -3.428  46.676 170.325  1.00 15.46           C  
ATOM   1450  O   ARG A 184      -3.567  47.338 171.353  1.00 17.08           O  
ATOM   1451  CB  ARG A 184      -1.064  45.880 170.549  1.00 14.14           C  
ATOM   1452  CG  ARG A 184      -0.119  44.742 170.824  1.00 15.90           C  
ATOM   1453  CD  ARG A 184       1.333  45.203 171.043  1.00 16.70           C  
ATOM   1454  NE  ARG A 184       2.129  44.096 171.531  1.00 18.58           N  
ATOM   1455  CZ  ARG A 184       3.425  44.180 171.819  1.00 18.03           C  
ATOM   1456  NH1 ARG A 184       4.050  45.345 171.649  1.00 16.53           N  
ATOM   1457  NH2 ARG A 184       4.084  43.111 172.291  1.00 15.68           N  
ATOM   1458  N   GLY A 185      -4.037  46.999 169.186  1.00 14.28           N  
ATOM   1459  CA  GLY A 185      -4.985  48.097 169.068  1.00 13.45           C  
ATOM   1460  C   GLY A 185      -6.441  47.668 169.099  1.00 13.55           C  
ATOM   1461  O   GLY A 185      -7.341  48.513 169.032  1.00 13.59           O  
ATOM   1462  N   SER A 186      -6.679  46.367 169.212  1.00 14.11           N  
ATOM   1463  CA  SER A 186      -8.003  45.799 168.983  1.00 14.76           C  
ATOM   1464  C   SER A 186      -8.587  45.241 170.251  1.00 15.34           C  
ATOM   1465  O   SER A 186      -7.902  44.548 170.986  1.00 16.93           O  
ATOM   1466  CB  SER A 186      -7.927  44.680 167.944  1.00 15.18           C  
ATOM   1467  OG  SER A 186      -9.175  44.002 167.859  1.00 17.09           O  
ATOM   1468  N   SER A 187      -9.863  45.518 170.529  1.00 13.57           N  
ATOM   1469  CA  SER A 187     -10.483  44.932 171.718  1.00 14.44           C  
ATOM   1470  C   SER A 187     -10.920  43.472 171.459  1.00 14.12           C  
ATOM   1471  O   SER A 187     -11.407  42.809 172.367  1.00 15.92           O  
ATOM   1472  CB  SER A 187     -11.696  45.754 172.186  1.00 15.88           C  
ATOM   1473  OG  SER A 187     -12.664  45.846 171.173  1.00 16.56           O  
ATOM   1474  N   SER A 188     -10.759  43.005 170.225  1.00 13.42           N  
ATOM   1475  CA  SER A 188     -11.005  41.613 169.882  1.00 14.05           C  
ATOM   1476  C   SER A 188      -9.845  40.671 170.252  1.00 13.60           C  
ATOM   1477  O   SER A 188      -9.951  39.470 170.045  1.00 14.86           O  
ATOM   1478  CB  SER A 188     -11.296  41.498 168.391  1.00 14.20           C  
ATOM   1479  OG  SER A 188     -12.498  42.154 168.045  1.00 17.27           O  
ATOM   1480  N   PHE A 189      -8.735  41.185 170.767  1.00 13.57           N  
ATOM   1481  CA  PHE A 189      -7.618  40.317 171.148  1.00 13.47           C  
ATOM   1482  C   PHE A 189      -7.120  40.617 172.552  1.00 13.92           C  
ATOM   1483  O   PHE A 189      -6.863  41.777 172.885  1.00 15.23           O  
ATOM   1484  CB  PHE A 189      -6.470  40.448 170.131  1.00 13.81           C  
ATOM   1485  CG  PHE A 189      -6.836  39.962 168.748  1.00 13.27           C  
ATOM   1486  CD1 PHE A 189      -6.731  38.621 168.417  1.00 13.45           C  
ATOM   1487  CD2 PHE A 189      -7.334  40.834 167.812  1.00 16.13           C  
ATOM   1488  CE1 PHE A 189      -7.110  38.170 167.162  1.00 13.87           C  
ATOM   1489  CE2 PHE A 189      -7.722  40.374 166.553  1.00 16.53           C  
ATOM   1490  CZ  PHE A 189      -7.566  39.043 166.244  1.00 16.52           C  
ATOM   1491  N   GLU A 190      -7.000  39.572 173.378  1.00 12.99           N  
ATOM   1492  CA  GLU A 190      -6.328  39.627 174.674  1.00 13.87           C  
ATOM   1493  C   GLU A 190      -4.948  39.056 174.439  1.00 12.78           C  
ATOM   1494  O   GLU A 190      -4.832  37.885 174.045  1.00 13.25           O  
ATOM   1495  CB  GLU A 190      -7.046  38.836 175.761  0.60 14.12           C  
ATOM   1497  CG  GLU A 190      -6.384  38.988 177.124  0.60 15.34           C  
ATOM   1499  CD  GLU A 190      -7.199  38.434 178.287  0.60 16.76           C  
ATOM   1501  OE1 GLU A 190      -7.773  39.220 179.135  0.60 14.40           O  
ATOM   1503  OE2 GLU A 190      -7.223  37.184 178.388  0.60 18.71           O  
ATOM   1505  N   CYS A 191      -3.910  39.858 174.649  1.00 12.83           N  
ATOM   1506  CA  CYS A 191      -2.560  39.491 174.215  1.00 12.59           C  
ATOM   1507  C   CYS A 191      -1.565  39.357 175.343  1.00 12.34           C  
ATOM   1508  O   CYS A 191      -1.611  40.122 176.325  1.00 12.20           O  
ATOM   1509  CB  CYS A 191      -2.006  40.509 173.211  1.00 12.86           C  
ATOM   1510  SG  CYS A 191      -2.997  40.817 171.733  1.00 15.42           S  
ATOM   1511  N   THR A 192      -0.640  38.404 175.182  1.00 10.71           N  
ATOM   1512  CA  THR A 192       0.483  38.241 176.082  1.00 10.99           C  
ATOM   1513  C   THR A 192       1.754  38.158 175.234  1.00 11.70           C  
ATOM   1514  O   THR A 192       1.782  37.463 174.254  1.00 13.16           O  
ATOM   1515  CB  THR A 192       0.348  36.950 176.902  1.00 11.09           C  
ATOM   1516  OG1 THR A 192      -0.926  36.933 177.584  1.00 12.86           O  
ATOM   1517  CG2 THR A 192       1.410  36.895 178.011  1.00 12.34           C  
ATOM   1518  N   HIS A 193       2.788  38.865 175.633  1.00 11.33           N  
ATOM   1519  CA  HIS A 193       4.078  38.780 174.956  1.00 11.34           C  
ATOM   1520  C   HIS A 193       5.017  37.841 175.708  1.00 11.83           C  
ATOM   1521  O   HIS A 193       5.115  37.923 176.933  1.00 12.49           O  
ATOM   1522  CB  HIS A 193       4.687  40.164 174.844  1.00 12.78           C  
ATOM   1523  CG  HIS A 193       5.979  40.184 174.106  1.00 10.84           C  
ATOM   1524  ND1 HIS A 193       6.048  40.022 172.744  1.00 12.94           N  
ATOM   1525  CD2 HIS A 193       7.251  40.297 174.543  1.00 14.28           C  
ATOM   1526  CE1 HIS A 193       7.318  40.041 172.369  1.00 13.63           C  
ATOM   1527  NE2 HIS A 193       8.068  40.225 173.437  1.00 12.67           N  
ATOM   1528  N   TYR A 194       5.707  36.960 174.967  1.00 11.16           N  
ATOM   1529  CA  TYR A 194       6.708  36.059 175.524  1.00 11.93           C  
ATOM   1530  C   TYR A 194       8.066  36.353 174.919  1.00 12.60           C  
ATOM   1531  O   TYR A 194       8.381  35.966 173.784  1.00 12.74           O  
ATOM   1532  CB  TYR A 194       6.326  34.587 175.286  1.00 11.49           C  
ATOM   1533  CG  TYR A 194       5.037  34.211 175.977  1.00 13.26           C  
ATOM   1534  CD1 TYR A 194       4.983  33.945 177.328  1.00 14.92           C  
ATOM   1535  CD2 TYR A 194       3.858  34.180 175.263  1.00 14.56           C  
ATOM   1536  CE1 TYR A 194       3.772  33.632 177.947  1.00 14.28           C  
ATOM   1537  CE2 TYR A 194       2.657  33.848 175.864  1.00 16.24           C  
ATOM   1538  CZ  TYR A 194       2.609  33.589 177.196  1.00 15.36           C  
ATOM   1539  OH  TYR A 194       1.374  33.269 177.772  1.00 18.26           O  
ATOM   1540  N   SER A 195       8.920  36.981 175.712  1.00 13.03           N  
ATOM   1541  CA  SER A 195      10.273  37.278 175.303  1.00 13.86           C  
ATOM   1542  C   SER A 195      11.118  36.008 175.337  1.00 13.72           C  
ATOM   1543  O   SER A 195      11.025  35.213 176.267  1.00 15.59           O  
ATOM   1544  CB  SER A 195      10.882  38.374 176.201  1.00 15.53           C  
ATOM   1545  OG  SER A 195      12.043  38.936 175.582  1.00 18.95           O  
ATOM   1546  N   SER A 196      11.932  35.833 174.307  1.00 12.43           N  
ATOM   1547  CA  SER A 196      12.748  34.649 174.131  1.00 12.60           C  
ATOM   1548  C   SER A 196      13.976  35.013 173.251  1.00 12.80           C  
ATOM   1549  O   SER A 196      14.503  36.130 173.347  1.00 12.93           O  
ATOM   1550  CB  SER A 196      11.906  33.500 173.540  1.00 12.53           C  
ATOM   1551  OG  SER A 196      12.612  32.266 173.568  1.00 13.88           O  
ATOM   1552  N   TYR A 197      14.440  34.055 172.457  1.00 12.29           N  
ATOM   1553  CA  TYR A 197      15.597  34.242 171.593  1.00 12.45           C  
ATOM   1554  C   TYR A 197      15.304  33.724 170.202  1.00 11.01           C  
ATOM   1555  O   TYR A 197      14.648  32.690 170.023  1.00 11.64           O  
ATOM   1556  CB  TYR A 197      16.834  33.539 172.159  1.00 12.62           C  
ATOM   1557  CG  TYR A 197      17.224  34.101 173.517  1.00 15.64           C  
ATOM   1558  CD1 TYR A 197      17.900  35.293 173.607  1.00 17.43           C  
ATOM   1559  CD2 TYR A 197      16.818  33.469 174.699  1.00 22.99           C  
ATOM   1560  CE1 TYR A 197      18.237  35.835 174.831  1.00 21.91           C  
ATOM   1561  CE2 TYR A 197      17.132  34.022 175.947  1.00 25.29           C  
ATOM   1562  CZ  TYR A 197      17.840  35.210 175.985  1.00 25.58           C  
ATOM   1563  OH  TYR A 197      18.164  35.799 177.188  1.00 31.24           O  
ATOM   1564  N   LEU A 198      15.819  34.454 169.229  1.00 10.81           N  
ATOM   1565  CA  LEU A 198      15.803  34.013 167.847  1.00 10.78           C  
ATOM   1566  C   LEU A 198      16.519  32.685 167.749  1.00 11.19           C  
ATOM   1567  O   LEU A 198      17.523  32.454 168.393  1.00 11.43           O  
ATOM   1568  CB  LEU A 198      16.484  35.056 166.957  1.00 11.56           C  
ATOM   1569  CG  LEU A 198      16.222  34.904 165.457  1.00 12.27           C  
ATOM   1570  CD1 LEU A 198      14.787  35.152 165.107  1.00 13.07           C  
ATOM   1571  CD2 LEU A 198      17.069  35.845 164.661  1.00 15.99           C  
ATOM   1572  N   GLU A 199      15.934  31.771 166.989  1.00 10.53           N  
ATOM   1573  CA  GLU A 199      16.485  30.448 166.819  1.00 11.05           C  
ATOM   1574  C   GLU A 199      18.000  30.413 166.602  1.00 11.46           C  
ATOM   1575  O   GLU A 199      18.532  31.078 165.719  1.00 11.14           O  
ATOM   1576  CB  GLU A 199      15.736  29.711 165.722  1.00 10.32           C  
ATOM   1577  CG  GLU A 199      15.685  30.417 164.391  1.00 10.32           C  
ATOM   1578  CD  GLU A 199      14.405  31.177 164.167  1.00  8.59           C  
ATOM   1579  OE1 GLU A 199      13.841  31.756 165.124  1.00  9.29           O  
ATOM   1580  OE2 GLU A 199      13.975  31.250 162.994  1.00 10.99           O  
ATOM   1581  N   TYR A 200      18.641  29.574 167.405  1.00 12.82           N  
ATOM   1582  CA  TYR A 200      20.060  29.237 167.309  1.00 13.99           C  
ATOM   1583  C   TYR A 200      20.977  30.391 167.634  1.00 16.11           C  
ATOM   1584  O   TYR A 200      22.168  30.352 167.326  1.00 17.87           O  
ATOM   1585  CB  TYR A 200      20.392  28.587 165.960  1.00 14.00           C  
ATOM   1586  CG  TYR A 200      19.371  27.525 165.614  1.00 13.23           C  
ATOM   1587  CD1 TYR A 200      19.210  26.410 166.430  1.00 16.29           C  
ATOM   1588  CD2 TYR A 200      18.528  27.649 164.520  1.00 14.05           C  
ATOM   1589  CE1 TYR A 200      18.242  25.459 166.177  1.00 14.99           C  
ATOM   1590  CE2 TYR A 200      17.557  26.702 164.260  1.00 11.50           C  
ATOM   1591  CZ  TYR A 200      17.415  25.607 165.065  1.00 13.96           C  
ATOM   1592  OH  TYR A 200      16.446  24.676 164.815  1.00 13.86           O  
ATOM   1593  N   MET A 201      20.448  31.420 168.286  1.00 15.30           N  
ATOM   1594  CA  MET A 201      21.299  32.514 168.714  1.00 16.02           C  
ATOM   1595  C   MET A 201      20.802  33.182 169.974  1.00 15.72           C  
ATOM   1596  O   MET A 201      19.822  32.757 170.555  1.00 17.02           O  
ATOM   1597  CB  MET A 201      21.483  33.504 167.589  1.00 16.84           C  
ATOM   1598  CG  MET A 201      20.296  34.091 167.076  1.00 18.33           C  
ATOM   1599  SD  MET A 201      20.608  34.997 165.519  1.00 21.09           S  
ATOM   1600  CE  MET A 201      20.635  33.818 164.402  1.00 20.58           C  
ATOM   1601  N   LYS A 202      21.533  34.202 170.457  1.00 17.99           N  
ATOM   1602  CA  LYS A 202      21.115  34.906 171.666  1.00 18.21           C  
ATOM   1603  C   LYS A 202      20.616  36.333 171.388  1.00 17.73           C  
ATOM   1604  O   LYS A 202      20.425  37.116 172.324  1.00 18.05           O  
ATOM   1605  CB  LYS A 202      22.231  34.883 172.760  1.00 19.60           C  
ATOM   1606  CG  LYS A 202      22.688  33.476 173.157  1.00 23.58           C  
ATOM   1607  CD  LYS A 202      21.583  32.616 173.754  1.00 28.29           C  
ATOM   1608  CE  LYS A 202      21.001  33.251 175.020  1.00 30.93           C  
ATOM   1609  NZ  LYS A 202      20.900  32.279 176.131  1.00 35.55           N  
ATOM   1610  N   VAL A 203      20.333  36.648 170.127  1.00 14.60           N  
ATOM   1611  CA  VAL A 203      19.538  37.820 169.771  1.00 13.87           C  
ATOM   1612  C   VAL A 203      18.104  37.642 170.304  1.00 13.04           C  
ATOM   1613  O   VAL A 203      17.510  36.568 170.150  1.00 12.41           O  
ATOM   1614  CB  VAL A 203      19.494  38.001 168.227  1.00 14.48           C  
ATOM   1615  CG1 VAL A 203      18.600  39.133 167.850  1.00 15.28           C  
ATOM   1616  CG2 VAL A 203      20.926  38.236 167.695  1.00 15.72           C  
ATOM   1617  N   VAL A 204      17.576  38.657 170.983  1.00 12.60           N  
ATOM   1618  CA  VAL A 204      16.229  38.551 171.545  1.00 11.68           C  
ATOM   1619  C   VAL A 204      15.176  38.571 170.449  1.00 11.87           C  
ATOM   1620  O   VAL A 204      15.228  39.373 169.522  1.00 12.74           O  
ATOM   1621  CB  VAL A 204      15.985  39.701 172.574  1.00 12.44           C  
ATOM   1622  CG1 VAL A 204      14.545  39.774 173.045  1.00 14.12           C  
ATOM   1623  CG2 VAL A 204      16.922  39.500 173.758  1.00 12.88           C  
ATOM   1624  N   ASP A 205      14.209  37.659 170.592  1.00 12.25           N  
ATOM   1625  CA  ASP A 205      12.973  37.702 169.804  1.00 12.17           C  
ATOM   1626  C   ASP A 205      11.824  37.422 170.730  1.00 13.41           C  
ATOM   1627  O   ASP A 205      12.024  37.309 171.948  1.00 16.79           O  
ATOM   1628  CB  ASP A 205      13.059  36.677 168.676  1.00 11.04           C  
ATOM   1629  CG  ASP A 205      11.939  36.781 167.675  1.00 12.91           C  
ATOM   1630  OD1 ASP A 205      11.276  37.850 167.555  1.00 10.37           O  
ATOM   1631  OD2 ASP A 205      11.675  35.795 166.937  1.00 12.55           O  
ATOM   1632  N   GLY A 206      10.607  37.399 170.232  1.00 12.79           N  
ATOM   1633  CA  GLY A 206       9.495  37.010 171.062  1.00 12.17           C  
ATOM   1634  C   GLY A 206       8.352  36.422 170.279  1.00 12.68           C  
ATOM   1635  O   GLY A 206       8.295  36.616 169.089  1.00 11.33           O  
ATOM   1636  N   LEU A 207       7.446  35.746 170.969  1.00 12.92           N  
ATOM   1637  CA  LEU A 207       6.194  35.292 170.377  1.00 13.15           C  
ATOM   1638  C   LEU A 207       5.075  36.136 170.966  1.00 12.60           C  
ATOM   1639  O   LEU A 207       5.138  36.487 172.159  1.00 12.75           O  
ATOM   1640  CB  LEU A 207       5.914  33.840 170.755  1.00 13.89           C  
ATOM   1641  CG  LEU A 207       6.928  32.752 170.380  1.00 16.11           C  
ATOM   1642  CD1 LEU A 207       6.678  31.480 171.229  1.00 21.28           C  
ATOM   1643  CD2 LEU A 207       6.745  32.383 168.971  1.00 17.62           C  
ATOM   1644  N   GLU A 208       4.028  36.420 170.184  1.00 11.67           N  
ATOM   1645  CA  GLU A 208       2.835  37.072 170.698  1.00 11.69           C  
ATOM   1646  C   GLU A 208       1.713  36.035 170.742  1.00 11.93           C  
ATOM   1647  O   GLU A 208       1.478  35.327 169.759  1.00 11.89           O  
ATOM   1648  CB  GLU A 208       2.432  38.254 169.818  1.00 12.10           C  
ATOM   1649  CG  GLU A 208       1.646  39.302 170.573  1.00 11.68           C  
ATOM   1650  CD  GLU A 208       2.545  40.148 171.455  1.00 17.43           C  
ATOM   1651  OE1 GLU A 208       3.747  39.921 171.423  1.00 17.89           O  
ATOM   1652  OE2 GLU A 208       2.013  41.051 172.103  1.00 21.63           O  
ATOM   1653  N   LYS A 209       1.071  35.903 171.900  1.00 11.84           N  
ATOM   1654  CA  LYS A 209      -0.154  35.109 172.020  1.00 11.71           C  
ATOM   1655  C   LYS A 209      -1.293  36.106 171.970  1.00 13.02           C  
ATOM   1656  O   LYS A 209      -1.327  37.026 172.794  1.00 13.44           O  
ATOM   1657  CB  LYS A 209      -0.175  34.348 173.342  1.00 12.35           C  
ATOM   1658  CG  LYS A 209      -1.391  33.450 173.480  1.00 12.70           C  
ATOM   1659  CD  LYS A 209      -1.326  32.593 174.751  1.00 13.89           C  
ATOM   1660  CE  LYS A 209      -1.456  33.405 176.034  1.00 13.83           C  
ATOM   1661  NZ  LYS A 209      -1.499  32.546 177.281  1.00 18.04           N  
ATOM   1662  N   ALA A 210      -2.191  35.967 171.015  1.00 12.10           N  
ATOM   1663  CA  ALA A 210      -3.312  36.891 170.890  1.00 12.75           C  
ATOM   1664  C   ALA A 210      -4.563  36.028 170.868  1.00 13.79           C  
ATOM   1665  O   ALA A 210      -4.764  35.285 169.921  1.00 14.19           O  
ATOM   1666  CB  ALA A 210      -3.189  37.710 169.613  1.00 12.96           C  
ATOM   1667  N   ILE A 211      -5.386  36.130 171.905  1.00 13.18           N  
ATOM   1668  CA  ILE A 211      -6.581  35.277 171.996  1.00 14.09           C  
ATOM   1669  C   ILE A 211      -7.810  36.043 171.522  1.00 14.95           C  
ATOM   1670  O   ILE A 211      -8.138  37.120 172.059  1.00 14.46           O  
ATOM   1671  CB  ILE A 211      -6.792  34.799 173.429  1.00 13.92           C  
ATOM   1672  CG1 ILE A 211      -5.525  34.078 173.955  1.00 17.08           C  
ATOM   1673  CG2 ILE A 211      -7.984  33.865 173.467  1.00 16.07           C  
ATOM   1674  CD1 ILE A 211      -5.645  33.638 175.361  1.00 20.74           C  
ATOM   1675  N   TYR A 212      -8.474  35.506 170.508  1.00 14.66           N  
ATOM   1676  CA  TYR A 212      -9.615  36.184 169.905  1.00 15.84           C  
ATOM   1677  C   TYR A 212     -10.767  36.190 170.898  1.00 17.19           C  
ATOM   1678  O   TYR A 212     -11.064  35.178 171.537  1.00 17.26           O  
ATOM   1679  CB  TYR A 212      -9.975  35.508 168.585  1.00 15.87           C  
ATOM   1680  CG  TYR A 212     -11.051  36.181 167.775  1.00 16.36           C  
ATOM   1681  CD1 TYR A 212     -10.863  37.430 167.214  1.00 16.77           C  
ATOM   1682  CD2 TYR A 212     -12.275  35.549 167.574  1.00 18.47           C  
ATOM   1683  CE1 TYR A 212     -11.852  38.038 166.442  1.00 17.81           C  
ATOM   1684  CE2 TYR A 212     -13.260  36.141 166.819  1.00 19.41           C  
ATOM   1685  CZ  TYR A 212     -13.056  37.377 166.272  1.00 19.77           C  
ATOM   1686  OH  TYR A 212     -14.066  37.951 165.535  1.00 21.13           O  
ATOM   1687  N   GLN A 213     -11.423  37.338 171.008  1.00 17.85           N  
ATOM   1688  CA  GLN A 213     -12.513  37.524 171.978  1.00 20.81           C  
ATOM   1689  C   GLN A 213     -13.862  37.640 171.310  1.00 22.69           C  
ATOM   1690  O   GLN A 213     -14.888  37.781 172.003  1.00 23.60           O  
ATOM   1691  CB  GLN A 213     -12.284  38.796 172.772  1.00 21.01           C  
ATOM   1692  CG  GLN A 213     -11.011  38.791 173.561  1.00 23.37           C  
ATOM   1693  CD  GLN A 213     -10.952  37.610 174.509  1.00 27.01           C  
ATOM   1694  OE1 GLN A 213     -11.908  37.374 175.267  1.00 30.94           O  
ATOM   1695  NE2 GLN A 213      -9.856  36.844 174.457  1.00 25.90           N  
ATOM   1696  N   GLY A 214     -13.873  37.583 169.986  1.00 24.15           N  
ATOM   1697  CA  GLY A 214     -15.076  37.841 169.211  1.00 25.34           C  
ATOM   1698  C   GLY A 214     -14.958  39.192 168.561  1.00 26.81           C  
ATOM   1699  O   GLY A 214     -13.975  39.901 168.772  1.00 24.92           O  
ATOM   1700  N   PRO A 215     -15.951  39.546 167.750  1.00 29.30           N  
ATOM   1701  CA  PRO A 215     -16.033  40.873 167.113  1.00 30.45           C  
ATOM   1702  C   PRO A 215     -16.164  42.076 168.049  1.00 31.49           C  
ATOM   1703  O   PRO A 215     -15.755  43.183 167.695  1.00 33.85           O  
ATOM   1704  CB  PRO A 215     -17.304  40.759 166.265  1.00 30.75           C  
ATOM   1705  CG  PRO A 215     -17.487  39.333 166.041  1.00 30.49           C  
ATOM   1706  CD  PRO A 215     -17.053  38.662 167.321  1.00 29.45           C  
ATOM   1707  N   SER A 216     -16.681  42.040 169.172  1.00 32.77           N  
TER    1708      SER A 216                                                      
END
MOLECULE T0509.pdb
ATOM      1  N   ASN     3      22.807  39.978 177.332  1.00 85.83           N  
ATOM      2  CA  ASN     3      23.661  39.212 178.288  1.00 85.41           C  
ATOM      3  C   ASN     3      22.931  38.088 179.010  1.00 84.96           C  
ATOM      4  O   ASN     3      23.158  36.907 178.737  1.00 84.71           O  
ATOM      5  CB  ASN     3      24.283  40.169 179.320  1.00 85.60           C  
ATOM      6  N   ALA     4      22.046  38.464 179.926  1.00 84.06           N  
ATOM      7  CA  ALA     4      21.329  37.491 180.736  1.00 83.06           C  
ATOM      8  C   ALA     4      20.380  36.562 180.006  1.00 82.36           C  
ATOM      9  O   ALA     4      20.103  35.452 180.462  1.00 82.26           O  
ATOM     10  CB  ALA     4      20.607  38.203 181.891  1.00 82.85           C  
ATOM     11  N   PHE     5      19.905  37.014 178.857  1.00 81.23           N  
ATOM     12  CA  PHE     5      19.008  36.219 178.041  1.00 79.90           C  
ATOM     13  C   PHE     5      19.689  34.923 177.583  1.00 78.36           C  
ATOM     14  O   PHE     5      19.070  33.859 177.581  1.00 77.95           O  
ATOM     15  CB  PHE     5      18.590  37.011 176.806  1.00 80.49           C  
ATOM     16  CG  PHE     5      17.733  36.228 175.838  1.00 82.32           C  
ATOM     17  CD1 PHE     5      16.356  36.140 176.022  1.00 83.80           C  
ATOM     18  CD2 PHE     5      18.306  35.556 174.759  1.00 83.29           C  
ATOM     19  CE1 PHE     5      15.564  35.398 175.148  1.00 85.48           C  
ATOM     20  CE2 PHE     5      17.522  34.810 173.883  1.00 84.01           C  
ATOM     21  CZ  PHE     5      16.149  34.731 174.079  1.00 84.46           C  
ATOM     22  N   GLU     6      20.960  35.016 177.195  1.00 77.13           N  
ATOM     23  CA  GLU     6      21.696  33.867 176.675  1.00 75.49           C  
ATOM     24  C   GLU     6      22.150  32.844 177.700  1.00 73.34           C  
ATOM     25  O   GLU     6      22.237  31.656 177.384  1.00 73.19           O  
ATOM     26  CB  GLU     6      22.890  34.355 175.852  1.00 76.28           C  
ATOM     27  CG  GLU     6      22.530  35.380 174.776  1.00 80.27           C  
ATOM     28  CD  GLU     6      23.464  36.574 174.805  1.00 85.77           C  
ATOM     29  OE1 GLU     6      23.350  37.389 175.746  1.00 88.31           O  
ATOM     30  OE2 GLU     6      24.317  36.691 173.899  1.00 86.53           O  
ATOM     31  N   TYR     7      22.433  33.303 178.915  1.00 71.13           N  
ATOM     32  CA  TYR     7      22.835  32.402 179.977  1.00 68.99           C  
ATOM     33  C   TYR     7      21.579  31.589 180.326  1.00 65.55           C  
ATOM     34  O   TYR     7      21.657  30.395 180.624  1.00 65.44           O  
ATOM     35  CB  TYR     7      23.336  33.190 181.196  1.00 70.74           C  
ATOM     36  CG  TYR     7      24.578  32.584 181.806  1.00 76.24           C  
ATOM     37  CD1 TYR     7      25.455  33.360 182.555  1.00 82.00           C  
ATOM     38  CD2 TYR     7      24.886  31.230 181.618  1.00 81.17           C  
ATOM     39  CE1 TYR     7      26.612  32.812 183.107  1.00 85.04           C  
ATOM     40  CE2 TYR     7      26.039  30.671 182.169  1.00 84.74           C  
ATOM     41  CZ  TYR     7      26.897  31.469 182.910  1.00 86.92           C  
ATOM     42  OH  TYR     7      28.037  30.923 183.455  1.00 89.05           O  
ATOM     43  N   LEU     8      20.416  32.239 180.292  1.00 61.60           N  
ATOM     44  CA  LEU     8      19.157  31.545 180.549  1.00 57.37           C  
ATOM     45  C   LEU     8      18.973  30.589 179.350  1.00 54.56           C  
ATOM     46  O   LEU     8      18.710  29.399 179.527  1.00 52.14           O  
ATOM     47  CB  LEU     8      17.989  32.541 180.606  1.00 57.65           C  
ATOM     48  CG  LEU     8      16.729  32.079 181.345  1.00 56.45           C  
ATOM     49  CD1 LEU     8      17.110  31.130 182.479  1.00 55.09           C  
ATOM     50  CD2 LEU     8      15.999  33.299 181.898  1.00 57.98           C  
ATOM     51  N   ARG     9      19.120  31.107 178.129  1.00 52.49           N  
ATOM     52  CA  ARG     9      18.958  30.280 176.932  1.00 52.08           C  
ATOM     53  C   ARG     9      19.926  29.104 176.942  1.00 51.11           C  
ATOM     54  O   ARG     9      19.532  27.959 176.699  1.00 50.55           O  
ATOM     55  CB  ARG     9      19.141  31.125 175.658  1.00 52.07           C  
ATOM     56  CG  ARG     9      19.009  30.335 174.364  1.00 54.77           C  
ATOM     57  CD  ARG     9      18.455  31.194 173.237  1.00 60.14           C  
ATOM     58  NE  ARG     9      19.283  32.362 172.952  1.00 64.34           N  
ATOM     59  CZ  ARG     9      20.451  32.322 172.316  1.00 68.63           C  
ATOM     60  NH1 ARG     9      20.939  31.164 171.888  1.00 69.94           N  
ATOM     61  NH2 ARG     9      21.131  33.441 172.107  1.00 68.03           N  
ATOM     62  N   THR    10      21.189  29.388 177.240  1.00 50.60           N  
ATOM     63  CA  THR    10      22.217  28.357 177.275  1.00 50.83           C  
ATOM     64  C   THR    10      21.903  27.262 178.291  1.00 49.87           C  
ATOM     65  O   THR    10      22.003  26.074 177.983  1.00 50.46           O  
ATOM     66  CB  THR    10      23.603  28.971 177.581  1.00 51.38           C  
ATOM     67  OG1 THR    10      23.896  29.986 176.608  1.00 51.78           O  
ATOM     68  CG2 THR    10      24.680  27.904 177.521  1.00 50.61           C  
ATOM     69  N   TYR    11      21.521  27.657 179.499  1.00 48.77           N  
ATOM     70  CA  TYR    11      21.185  26.675 180.524  1.00 48.46           C  
ATOM     71  C   TYR    11      19.954  25.857 180.130  1.00 46.71           C  
ATOM     72  O   TYR    11      19.919  24.643 180.332  1.00 46.43           O  
ATOM     73  CB  TYR    11      20.893  27.339 181.860  1.00 50.01           C  
ATOM     74  CG  TYR    11      20.510  26.319 182.902  1.00 52.08           C  
ATOM     75  CD1 TYR    11      21.471  25.474 183.449  1.00 54.43           C  
ATOM     76  CD2 TYR    11      19.173  26.115 183.256  1.00 52.57           C  
ATOM     77  CE1 TYR    11      21.121  24.459 184.331  1.00 56.00           C  
ATOM     78  CE2 TYR    11      18.812  25.101 184.141  1.00 56.55           C  
ATOM     79  CZ  TYR    11      19.795  24.275 184.668  1.00 55.82           C  
ATOM     80  OH  TYR    11      19.458  23.278 185.549  1.00 57.24           O  
ATOM     81  N   VAL    12      18.942  26.515 179.570  1.00 45.29           N  
ATOM     82  CA  VAL    12      17.728  25.810 179.173  1.00 43.79           C  
ATOM     83  C   VAL    12      17.970  24.915 177.964  1.00 44.31           C  
ATOM     84  O   VAL    12      17.489  23.784 177.919  1.00 44.59           O  
ATOM     85  CB  VAL    12      16.575  26.796 178.864  1.00 44.09           C  
ATOM     86  CG1 VAL    12      15.364  26.044 178.307  1.00 38.90           C  
ATOM     87  CG2 VAL    12      16.187  27.557 180.138  1.00 40.82           C  
ATOM     88  N   GLU    13      18.706  25.418 176.982  1.00 45.77           N  
ATOM     89  CA  GLU    13      18.991  24.621 175.801  1.00 47.52           C  
ATOM     90  C   GLU    13      19.917  23.460 176.170  1.00 48.95           C  
ATOM     91  O   GLU    13      19.657  22.312 175.826  1.00 49.14           O  
ATOM     92  CB  GLU    13      19.621  25.491 174.701  1.00 47.27           C  
ATOM     93  CG  GLU    13      18.594  26.143 173.776  1.00 46.73           C  
ATOM     94  CD  GLU    13      19.213  27.051 172.733  1.00 47.14           C  
ATOM     95  OE1 GLU    13      18.462  27.802 172.070  1.00 46.58           O  
ATOM     96  OE2 GLU    13      20.451  27.011 172.568  1.00 48.58           O  
ATOM     97  N   SER    14      20.991  23.759 176.893  1.00 50.77           N  
ATOM     98  CA  SER    14      21.962  22.741 177.291  1.00 52.40           C  
ATOM     99  C   SER    14      21.408  21.764 178.315  1.00 52.24           C  
ATOM    100  O   SER    14      22.111  20.838 178.732  1.00 52.54           O  
ATOM    101  CB  SER    14      23.201  23.405 177.884  1.00 53.25           C  
ATOM    102  OG  SER    14      22.943  23.882 179.203  1.00 55.29           O  
ATOM    103  N   THR    15      20.152  21.956 178.709  1.00 51.44           N  
ATOM    104  CA  THR    15      19.565  21.104 179.726  1.00 50.00           C  
ATOM    105  C   THR    15      18.254  20.425 179.338  1.00 49.00           C  
ATOM    106  O   THR    15      17.740  19.581 180.077  1.00 48.09           O  
ATOM    107  CB  THR    15      19.421  21.928 181.040  1.00 50.48           C  
ATOM    108  OG1 THR    15      19.790  21.124 182.163  1.00 53.93           O  
ATOM    109  CG2 THR    15      18.042  22.429 181.224  1.00 49.25           C  
ATOM    110  N   THR    16      17.709  20.805 178.186  1.00 47.75           N  
ATOM    111  CA  THR    16      16.482  20.191 177.693  1.00 48.20           C  
ATOM    112  C   THR    16      16.843  18.834 177.065  1.00 50.22           C  
ATOM    113  O   THR    16      17.668  18.759 176.143  1.00 52.31           O  
ATOM    114  CB  THR    16      15.795  21.062 176.622  1.00 46.53           C  
ATOM    115  OG1 THR    16      15.318  22.271 177.220  1.00 45.88           O  
ATOM    116  CG2 THR    16      14.625  20.317 175.997  1.00 42.52           C  
ATOM    117  N   GLU    17      16.228  17.764 177.563  1.00 51.38           N  
ATOM    118  CA  GLU    17      16.493  16.421 177.062  1.00 53.69           C  
ATOM    119  C   GLU    17      16.282  16.387 175.556  1.00 54.77           C  
ATOM    120  O   GLU    17      15.184  16.632 175.051  1.00 53.95           O  
ATOM    121  CB  GLU    17      15.569  15.413 177.748  1.00 54.69           C  
ATOM    122  CG  GLU    17      15.799  13.980 177.324  1.00 57.95           C  
ATOM    123  CD  GLU    17      14.636  13.081 177.692  1.00 63.33           C  
ATOM    124  OE1 GLU    17      14.500  12.002 177.075  1.00 66.36           O  
ATOM    125  OE2 GLU    17      13.861  13.451 178.601  1.00 65.09           O  
ATOM    126  N   THR    18      17.345  16.068 174.836  1.00 56.14           N  
ATOM    127  CA  THR    18      17.289  16.046 173.385  1.00 57.87           C  
ATOM    128  C   THR    18      16.318  15.040 172.775  1.00 57.45           C  
ATOM    129  O   THR    18      16.215  13.904 173.238  1.00 57.97           O  
ATOM    130  CB  THR    18      18.709  15.817 172.779  1.00 58.68           C  
ATOM    131  OG1 THR    18      19.251  14.577 173.255  1.00 60.50           O  
ATOM    132  CG2 THR    18      19.660  16.960 173.166  1.00 57.87           C  
ATOM    133  N   ASP    19      15.587  15.481 171.752  1.00 56.51           N  
ATOM    134  CA  ASP    19      14.670  14.600 171.041  1.00 56.34           C  
ATOM    135  C   ASP    19      15.294  14.421 169.648  1.00 55.42           C  
ATOM    136  O   ASP    19      15.637  15.401 168.973  1.00 56.44           O  
ATOM    137  CB  ASP    19      13.263  15.210 170.904  1.00 55.60           C  
ATOM    138  CG  ASP    19      12.348  14.348 170.050  1.00 57.72           C  
ATOM    139  OD1 ASP    19      12.857  13.661 169.136  1.00 62.68           O  
ATOM    140  OD2 ASP    19      11.122  14.363 170.272  1.00 59.68           O  
ATOM    141  N   ALA    20      15.442  13.171 169.218  1.00 53.78           N  
ATOM    142  CA  ALA    20      16.054  12.863 167.926  1.00 51.44           C  
ATOM    143  C   ALA    20      15.281  13.437 166.750  1.00 49.39           C  
ATOM    144  O   ALA    20      15.857  14.097 165.881  1.00 47.69           O  
ATOM    145  CB  ALA    20      16.208  11.346 167.765  1.00 51.74           C  
ATOM    146  N   ALA    21      13.978  13.189 166.728  1.00 46.99           N  
ATOM    147  CA  ALA    21      13.140  13.693 165.655  1.00 44.89           C  
ATOM    148  C   ALA    21      13.208  15.221 165.610  1.00 43.57           C  
ATOM    149  O   ALA    21      13.247  15.812 164.534  1.00 43.64           O  
ATOM    150  CB  ALA    21      11.692  13.224 165.853  1.00 44.67           C  
ATOM    151  N   VAL    22      13.229  15.860 166.779  1.00 41.64           N  
ATOM    152  CA  VAL    22      13.292  17.319 166.849  1.00 39.09           C  
ATOM    153  C   VAL    22      14.655  17.846 166.414  1.00 38.15           C  
ATOM    154  O   VAL    22      14.745  18.838 165.688  1.00 36.18           O  
ATOM    155  CB  VAL    22      12.990  17.834 168.282  1.00 38.83           C  
ATOM    156  CG1 VAL    22      13.345  19.328 168.388  1.00 37.70           C  
ATOM    157  CG2 VAL    22      11.520  17.610 168.622  1.00 36.88           C  
ATOM    158  N   ALA    23      15.719  17.184 166.860  1.00 38.78           N  
ATOM    159  CA  ALA    23      17.070  17.602 166.500  1.00 39.37           C  
ATOM    160  C   ALA    23      17.260  17.469 164.984  1.00 38.28           C  
ATOM    161  O   ALA    23      17.908  18.299 164.359  1.00 37.20           O  
ATOM    162  CB  ALA    23      18.100  16.748 167.239  1.00 39.71           C  
ATOM    163  N   ARG    24      16.692  16.419 164.402  1.00 39.08           N  
ATOM    164  CA  ARG    24      16.800  16.188 162.969  1.00 40.86           C  
ATOM    165  C   ARG    24      16.093  17.324 162.217  1.00 40.75           C  
ATOM    166  O   ARG    24      16.635  17.874 161.249  1.00 40.53           O  
ATOM    167  CB  ARG    24      16.183  14.820 162.628  1.00 41.74           C  
ATOM    168  CG  ARG    24      16.075  14.501 161.150  1.00 49.23           C  
ATOM    169  CD  ARG    24      17.421  14.551 160.446  1.00 54.35           C  
ATOM    170  NE  ARG    24      17.462  13.599 159.339  1.00 59.94           N  
ATOM    171  CZ  ARG    24      18.095  13.812 158.194  1.00 59.09           C  
ATOM    172  NH1 ARG    24      18.742  14.952 158.002  1.00 62.71           N  
ATOM    173  NH2 ARG    24      18.073  12.890 157.241  1.00 60.22           N  
ATOM    174  N   ALA    25      14.891  17.680 162.668  1.00 40.03           N  
ATOM    175  CA  ALA    25      14.128  18.752 162.037  1.00 40.19           C  
ATOM    176  C   ALA    25      14.839  20.105 162.157  1.00 40.52           C  
ATOM    177  O   ALA    25      14.731  20.951 161.261  1.00 41.05           O  
ATOM    178  CB  ALA    25      12.728  18.829 162.649  1.00 40.91           C  
ATOM    179  N   ARG    26      15.564  20.307 163.256  1.00 40.54           N  
ATOM    180  CA  ARG    26      16.300  21.552 163.475  1.00 40.67           C  
ATOM    181  C   ARG    26      17.542  21.569 162.573  1.00 41.44           C  
ATOM    182  O   ARG    26      17.953  22.620 162.081  1.00 43.15           O  
ATOM    183  CB  ARG    26      16.716  21.666 164.945  1.00 40.06           C  
ATOM    184  CG  ARG    26      17.206  23.049 165.344  1.00 41.06           C  
ATOM    185  CD  ARG    26      17.244  23.192 166.860  1.00 39.59           C  
ATOM    186  NE  ARG    26      15.918  23.381 167.448  1.00 36.02           N  
ATOM    187  CZ  ARG    26      15.195  24.489 167.308  1.00 35.63           C  
ATOM    188  NH1 ARG    26      15.676  25.501 166.600  1.00 33.06           N  
ATOM    189  NH2 ARG    26      14.002  24.588 167.884  1.00 31.51           N  
ATOM    190  N   GLU    27      18.141  20.402 162.354  1.00 43.09           N  
ATOM    191  CA  GLU    27      19.306  20.309 161.483  1.00 45.53           C  
ATOM    192  C   GLU    27      18.829  20.549 160.048  1.00 44.47           C  
ATOM    193  O   GLU    27      19.434  21.325 159.304  1.00 44.94           O  
ATOM    194  CB  GLU    27      19.947  18.925 161.590  1.00 47.21           C  
ATOM    195  CG  GLU    27      21.435  18.965 161.907  1.00 56.44           C  
ATOM    196  CD  GLU    27      22.265  19.573 160.788  1.00 64.19           C  
ATOM    197  OE1 GLU    27      22.345  20.818 160.694  1.00 65.65           O  
ATOM    198  OE2 GLU    27      22.830  18.791 159.994  1.00 68.30           O  
ATOM    199  N   ASP    28      17.742  19.882 159.656  1.00 43.22           N  
ATOM    200  CA  ASP    28      17.198  20.053 158.307  1.00 42.84           C  
ATOM    201  C   ASP    28      16.904  21.517 157.990  1.00 42.31           C  
ATOM    202  O   ASP    28      17.295  22.014 156.935  1.00 42.99           O  
ATOM    203  CB  ASP    28      15.924  19.225 158.124  1.00 41.28           C  
ATOM    204  CG  ASP    28      16.209  17.744 157.975  1.00 42.74           C  
ATOM    205  OD1 ASP    28      17.404  17.380 157.943  1.00 44.72           O  
ATOM    206  OD2 ASP    28      15.246  16.946 157.885  1.00 45.45           O  
ATOM    207  N   ALA    29      16.225  22.209 158.902  1.00 41.52           N  
ATOM    208  CA  ALA    29      15.882  23.616 158.687  1.00 40.18           C  
ATOM    209  C   ALA    29      17.117  24.477 158.480  1.00 39.57           C  
ATOM    210  O   ALA    29      17.132  25.362 157.620  1.00 39.63           O  
ATOM    211  CB  ALA    29      15.058  24.154 159.864  1.00 40.56           C  
ATOM    212  N   ALA    30      18.146  24.209 159.275  1.00 39.17           N  
ATOM    213  CA  ALA    30      19.398  24.949 159.198  1.00 40.05           C  
ATOM    214  C   ALA    30      20.107  24.679 157.868  1.00 39.78           C  
ATOM    215  O   ALA    30      20.666  25.591 157.260  1.00 40.00           O  
ATOM    216  CB  ALA    30      20.305  24.561 160.365  1.00 40.11           C  
ATOM    217  N   GLU    31      20.085  23.427 157.422  1.00 38.65           N  
ATOM    218  CA  GLU    31      20.718  23.066 156.159  1.00 38.87           C  
ATOM    219  C   GLU    31      20.078  23.764 154.959  1.00 38.60           C  
ATOM    220  O   GLU    31      20.739  23.995 153.950  1.00 39.71           O  
ATOM    221  CB  GLU    31      20.668  21.552 155.963  1.00 39.36           C  
ATOM    222  CG  GLU    31      21.691  20.795 156.786  1.00 38.74           C  
ATOM    223  CD  GLU    31      21.437  19.310 156.790  1.00 43.41           C  
ATOM    224  OE1 GLU    31      20.865  18.809 155.803  1.00 47.35           O  
ATOM    225  OE2 GLU    31      21.820  18.637 157.764  1.00 48.92           O  
ATOM    226  N   PHE    32      18.796  24.105 155.072  1.00 37.78           N  
ATOM    227  CA  PHE    32      18.071  24.765 153.985  1.00 36.92           C  
ATOM    228  C   PHE    32      17.846  26.256 154.223  1.00 37.72           C  
ATOM    229  O   PHE    32      17.134  26.913 153.457  1.00 36.82           O  
ATOM    230  CB  PHE    32      16.727  24.064 153.758  1.00 35.46           C  
ATOM    231  CG  PHE    32      16.852  22.714 153.100  1.00 35.81           C  
ATOM    232  CD1 PHE    32      16.814  22.592 151.708  1.00 32.38           C  
ATOM    233  CD2 PHE    32      16.998  21.562 153.873  1.00 29.85           C  
ATOM    234  CE1 PHE    32      16.925  21.341 151.098  1.00 34.55           C  
ATOM    235  CE2 PHE    32      17.113  20.313 153.274  1.00 32.22           C  
ATOM    236  CZ  PHE    32      17.074  20.200 151.884  1.00 34.18           C  
ATOM    237  N   GLY    33      18.448  26.777 155.289  1.00 38.67           N  
ATOM    238  CA  GLY    33      18.321  28.190 155.623  1.00 38.55           C  
ATOM    239  C   GLY    33      16.923  28.661 155.983  1.00 37.08           C  
ATOM    240  O   GLY    33      16.572  29.818 155.756  1.00 36.54           O  
ATOM    241  N   LEU    34      16.129  27.765 156.564  1.00 38.38           N  
ATOM    242  CA  LEU    34      14.751  28.092 156.938  1.00 38.59           C  
ATOM    243  C   LEU    34      14.629  28.720 158.321  1.00 37.66           C  
ATOM    244  O   LEU    34      15.399  28.397 159.220  1.00 39.17           O  
ATOM    245  CB  LEU    34      13.887  26.827 156.897  1.00 38.83           C  
ATOM    246  CG  LEU    34      13.963  25.954 155.641  1.00 38.72           C  
ATOM    247  CD1 LEU    34      13.204  24.651 155.855  1.00 40.78           C  
ATOM    248  CD2 LEU    34      13.393  26.715 154.462  1.00 38.26           C  
ATOM    249  N   PRO    35      13.655  29.627 158.500  1.00 38.39           N  
ATOM    250  CA  PRO    35      13.416  30.306 159.780  1.00 39.03           C  
ATOM    251  C   PRO    35      12.913  29.261 160.777  1.00 40.77           C  
ATOM    252  O   PRO    35      11.820  28.713 160.611  1.00 41.07           O  
ATOM    253  CB  PRO    35      12.323  31.328 159.454  1.00 39.92           C  
ATOM    254  CG  PRO    35      12.269  31.377 157.939  1.00 39.36           C  
ATOM    255  CD  PRO    35      12.651  30.009 157.495  1.00 37.58           C  
ATOM    256  N   ALA    36      13.702  29.004 161.819  1.00 41.01           N  
ATOM    257  CA  ALA    36      13.344  27.997 162.818  1.00 40.99           C  
ATOM    258  C   ALA    36      13.320  28.519 164.250  1.00 40.41           C  
ATOM    259  O   ALA    36      14.364  28.860 164.803  1.00 41.47           O  
ATOM    260  CB  ALA    36      14.304  26.820 162.726  1.00 39.29           C  
ATOM    261  N   PRO    37      12.131  28.565 164.869  1.00 39.76           N  
ATOM    262  CA  PRO    37      11.992  29.042 166.250  1.00 37.91           C  
ATOM    263  C   PRO    37      12.926  28.246 167.151  1.00 36.44           C  
ATOM    264  O   PRO    37      13.077  27.035 166.962  1.00 35.90           O  
ATOM    265  CB  PRO    37      10.524  28.755 166.578  1.00 38.50           C  
ATOM    266  CG  PRO    37       9.850  28.774 165.250  1.00 40.52           C  
ATOM    267  CD  PRO    37      10.840  28.108 164.325  1.00 40.07           C  
ATOM    268  N   ASP    38      13.533  28.908 168.135  1.00 34.43           N  
ATOM    269  CA  ASP    38      14.448  28.213 169.038  1.00 34.87           C  
ATOM    270  C   ASP    38      13.717  27.211 169.936  1.00 35.84           C  
ATOM    271  O   ASP    38      12.491  27.094 169.887  1.00 34.82           O  
ATOM    272  CB  ASP    38      15.273  29.226 169.873  1.00 35.43           C  
ATOM    273  CG  ASP    38      14.428  30.055 170.830  1.00 37.24           C  
ATOM    274  OD1 ASP    38      13.181  30.018 170.734  1.00 39.36           O  
ATOM    275  OD2 ASP    38      15.029  30.747 171.687  1.00 41.15           O  
ATOM    276  N   GLU    39      14.478  26.489 170.752  1.00 35.27           N  
ATOM    277  CA  GLU    39      13.916  25.474 171.629  1.00 35.36           C  
ATOM    278  C   GLU    39      12.890  25.983 172.629  1.00 34.78           C  
ATOM    279  O   GLU    39      11.907  25.298 172.910  1.00 35.10           O  
ATOM    280  CB  GLU    39      15.040  24.754 172.372  1.00 36.46           C  
ATOM    281  CG  GLU    39      14.579  23.753 173.433  1.00 39.24           C  
ATOM    282  CD  GLU    39      13.757  22.609 172.864  1.00 42.52           C  
ATOM    283  OE1 GLU    39      14.081  22.141 171.754  1.00 46.69           O  
ATOM    284  OE2 GLU    39      12.795  22.167 173.532  1.00 44.19           O  
ATOM    285  N   MET    40      13.120  27.181 173.155  1.00 33.85           N  
ATOM    286  CA  MET    40      12.224  27.769 174.137  1.00 33.31           C  
ATOM    287  C   MET    40      10.880  28.153 173.523  1.00 31.59           C  
ATOM    288  O   MET    40       9.831  27.983 174.152  1.00 30.49           O  
ATOM    289  CB  MET    40      12.890  28.989 174.807  1.00 32.67           C  
ATOM    290  CG  MET    40      13.914  28.637 175.903  1.00 37.51           C  
ATOM    291  SD  MET    40      14.599  30.227 176.837  1.00 48.82          SE  
ATOM    292  CE  MET    40      16.150  29.483 177.672  1.00 47.77           C  
ATOM    293  N   THR    41      10.918  28.669 172.297  1.00 29.68           N  
ATOM    294  CA  THR    41       9.699  29.043 171.600  1.00 27.32           C  
ATOM    295  C   THR    41       8.914  27.755 171.285  1.00 26.43           C  
ATOM    296  O   THR    41       7.687  27.737 171.383  1.00 27.19           O  
ATOM    297  CB  THR    41      10.025  29.797 170.296  1.00 28.66           C  
ATOM    298  OG1 THR    41      10.738  30.996 170.619  1.00 26.10           O  
ATOM    299  CG2 THR    41       8.741  30.156 169.536  1.00 25.19           C  
ATOM    300  N   GLY    42       9.621  26.685 170.914  1.00 24.88           N  
ATOM    301  CA  GLY    42       8.967  25.414 170.622  1.00 26.74           C  
ATOM    302  C   GLY    42       8.266  24.847 171.858  1.00 27.45           C  
ATOM    303  O   GLY    42       7.145  24.339 171.751  1.00 27.33           O  
ATOM    304  N   GLN    43       8.910  24.928 173.025  1.00 26.78           N  
ATOM    305  CA  GLN    43       8.324  24.434 174.276  1.00 28.12           C  
ATOM    306  C   GLN    43       7.010  25.190 174.550  1.00 27.73           C  
ATOM    307  O   GLN    43       6.005  24.584 174.947  1.00 27.06           O  
ATOM    308  CB  GLN    43       9.332  24.610 175.437  1.00 27.92           C  
ATOM    309  CG  GLN    43      10.505  23.632 175.352  1.00 28.63           C  
ATOM    310  CD  GLN    43      11.578  23.886 176.399  1.00 34.03           C  
ATOM    311  OE1 GLN    43      11.355  24.607 177.373  1.00 36.82           O  
ATOM    312  NE2 GLN    43      12.752  23.290 176.204  1.00 32.59           N  
ATOM    313  N   LEU    44       7.014  26.508 174.335  1.00 27.40           N  
ATOM    314  CA  LEU    44       5.796  27.299 174.512  1.00 27.16           C  
ATOM    315  C   LEU    44       4.729  26.819 173.503  1.00 26.87           C  
ATOM    316  O   LEU    44       3.531  26.837 173.811  1.00 27.06           O  
ATOM    317  CB  LEU    44       6.061  28.795 174.302  1.00 25.60           C  
ATOM    318  CG  LEU    44       4.779  29.647 174.278  1.00 29.19           C  
ATOM    319  CD1 LEU    44       4.004  29.444 175.576  1.00 27.74           C  
ATOM    320  CD2 LEU    44       5.128  31.120 174.085  1.00 24.87           C  
ATOM    321  N   LEU    45       5.143  26.401 172.301  1.00 27.58           N  
ATOM    322  CA  LEU    45       4.174  25.911 171.307  1.00 29.21           C  
ATOM    323  C   LEU    45       3.531  24.614 171.836  1.00 28.50           C  
ATOM    324  O   LEU    45       2.331  24.399 171.691  1.00 29.78           O  
ATOM    325  CB  LEU    45       4.850  25.671 169.936  1.00 27.83           C  
ATOM    326  CG  LEU    45       5.300  26.957 169.216  1.00 30.54           C  
ATOM    327  CD1 LEU    45       5.894  26.601 167.853  1.00 32.59           C  
ATOM    328  CD2 LEU    45       4.104  27.908 169.041  1.00 29.82           C  
ATOM    329  N   THR    46       4.333  23.758 172.457  1.00 27.80           N  
ATOM    330  CA  THR    46       3.826  22.513 173.030  1.00 28.58           C  
ATOM    331  C   THR    46       2.826  22.835 174.150  1.00 27.31           C  
ATOM    332  O   THR    46       1.801  22.178 174.283  1.00 28.48           O  
ATOM    333  CB  THR    46       4.977  21.679 173.620  1.00 27.74           C  
ATOM    334  OG1 THR    46       5.956  21.451 172.604  1.00 28.37           O  
ATOM    335  CG2 THR    46       4.473  20.348 174.134  1.00 28.82           C  
ATOM    336  N   THR    47       3.136  23.852 174.953  1.00 28.69           N  
ATOM    337  CA  THR    47       2.279  24.266 176.060  1.00 27.73           C  
ATOM    338  C   THR    47       0.915  24.733 175.570  1.00 27.47           C  
ATOM    339  O   THR    47      -0.114  24.348 176.127  1.00 27.23           O  
ATOM    340  CB  THR    47       2.920  25.417 176.865  1.00 28.09           C  
ATOM    341  OG1 THR    47       4.170  24.984 177.415  1.00 27.40           O  
ATOM    342  CG2 THR    47       1.993  25.863 178.001  1.00 23.26           C  
ATOM    343  N   LEU    48       0.904  25.562 174.529  1.00 26.00           N  
ATOM    344  CA  LEU    48      -0.357  26.062 173.992  1.00 24.82           C  
ATOM    345  C   LEU    48      -1.138  24.957 173.294  1.00 24.93           C  
ATOM    346  O   LEU    48      -2.370  24.923 173.361  1.00 24.34           O  
ATOM    347  CB  LEU    48      -0.108  27.225 173.025  1.00 26.01           C  
ATOM    348  CG  LEU    48       0.505  28.475 173.683  1.00 30.70           C  
ATOM    349  CD1 LEU    48       0.765  29.551 172.624  1.00 30.77           C  
ATOM    350  CD2 LEU    48      -0.440  29.004 174.770  1.00 26.08           C  
ATOM    351  N   ALA    49      -0.428  24.053 172.620  1.00 25.73           N  
ATOM    352  CA  ALA    49      -1.091  22.953 171.935  1.00 26.68           C  
ATOM    353  C   ALA    49      -1.715  22.043 172.989  1.00 26.17           C  
ATOM    354  O   ALA    49      -2.765  21.445 172.761  1.00 25.74           O  
ATOM    355  CB  ALA    49      -0.084  22.163 171.077  1.00 24.82           C  
ATOM    356  N   ALA    50      -1.056  21.941 174.143  1.00 27.11           N  
ATOM    357  CA  ALA    50      -1.529  21.106 175.245  1.00 27.80           C  
ATOM    358  C   ALA    50      -2.642  21.769 176.057  1.00 29.60           C  
ATOM    359  O   ALA    50      -3.560  21.095 176.516  1.00 32.07           O  
ATOM    360  CB  ALA    50      -0.368  20.750 176.165  1.00 29.92           C  
ATOM    361  N   THR    51      -2.567  23.083 176.235  1.00 29.29           N  
ATOM    362  CA  THR    51      -3.576  23.787 177.009  1.00 30.18           C  
ATOM    363  C   THR    51      -4.841  24.127 176.208  1.00 32.02           C  
ATOM    364  O   THR    51      -5.941  24.063 176.767  1.00 31.22           O  
ATOM    365  CB  THR    51      -2.987  25.075 177.666  1.00 29.68           C  
ATOM    366  OG1 THR    51      -2.623  26.035 176.658  1.00 29.87           O  
ATOM    367  CG2 THR    51      -1.740  24.711 178.484  1.00 27.26           C  
ATOM    368  N   THR    52      -4.701  24.475 174.924  1.00 31.53           N  
ATOM    369  CA  THR    52      -5.877  24.802 174.119  1.00 31.58           C  
ATOM    370  C   THR    52      -6.810  23.597 174.026  1.00 33.91           C  
ATOM    371  O   THR    52      -6.387  22.444 174.151  1.00 34.00           O  
ATOM    372  CB  THR    52      -5.499  25.330 172.708  1.00 30.61           C  
ATOM    373  OG1 THR    52      -4.605  24.419 172.059  1.00 27.87           O  
ATOM    374  CG2 THR    52      -4.853  26.704 172.834  1.00 28.08           C  
ATOM    375  N   ASN    53      -8.085  23.868 173.784  1.00 36.96           N  
ATOM    376  CA  ASN    53      -9.107  22.823 173.780  1.00 41.28           C  
ATOM    377  C   ASN    53      -9.338  21.999 172.524  1.00 42.44           C  
ATOM    378  O   ASN    53      -9.875  22.501 171.540  1.00 42.24           O  
ATOM    379  CB  ASN    53     -10.426  23.449 174.254  1.00 41.27           C  
ATOM    380  CG  ASN    53     -11.429  22.416 174.745  1.00 44.44           C  
ATOM    381  OD1 ASN    53     -11.209  21.212 174.615  1.00 47.26           O  
ATOM    382  ND2 ASN    53     -12.548  22.888 175.303  1.00 47.57           N  
ATOM    383  N   GLY    54      -8.948  20.725 172.586  1.00 43.60           N  
ATOM    384  CA  GLY    54      -9.118  19.838 171.450  1.00 43.79           C  
ATOM    385  C   GLY    54     -10.568  19.477 171.184  1.00 46.01           C  
ATOM    386  O   GLY    54     -10.922  19.091 170.063  1.00 45.16           O  
ATOM    387  N   ASN    55     -11.408  19.603 172.213  1.00 46.67           N  
ATOM    388  CA  ASN    55     -12.834  19.294 172.096  1.00 46.74           C  
ATOM    389  C   ASN    55     -13.559  20.234 171.133  1.00 45.02           C  
ATOM    390  O   ASN    55     -13.647  21.441 171.374  1.00 46.21           O  
ATOM    391  CB  ASN    55     -13.509  19.362 173.473  1.00 48.61           C  
ATOM    392  CG  ASN    55     -13.087  18.220 174.394  1.00 52.70           C  
ATOM    393  OD1 ASN    55     -12.242  18.388 175.277  1.00 56.39           O  
ATOM    394  ND2 ASN    55     -13.671  17.045 174.179  1.00 58.74           N  
ATOM    395  N   GLY    56     -14.082  19.666 170.047  1.00 43.79           N  
ATOM    396  CA  GLY    56     -14.800  20.441 169.044  1.00 40.35           C  
ATOM    397  C   GLY    56     -13.862  21.143 168.080  1.00 38.97           C  
ATOM    398  O   GLY    56     -14.285  21.869 167.182  1.00 39.42           O  
ATOM    399  N   SER    57     -12.571  20.899 168.262  1.00 38.33           N  
ATOM    400  CA  SER    57     -11.535  21.505 167.437  1.00 35.50           C  
ATOM    401  C   SER    57     -10.963  20.557 166.387  1.00 33.56           C  
ATOM    402  O   SER    57     -10.777  19.374 166.646  1.00 31.18           O  
ATOM    403  CB  SER    57     -10.415  22.011 168.349  1.00 35.48           C  
ATOM    404  OG  SER    57      -9.243  22.356 167.632  1.00 34.61           O  
ATOM    405  N   THR    58     -10.681  21.087 165.200  1.00 32.90           N  
ATOM    406  CA  THR    58     -10.094  20.281 164.142  1.00 31.69           C  
ATOM    407  C   THR    58      -8.624  20.066 164.515  1.00 31.06           C  
ATOM    408  O   THR    58      -8.024  19.038 164.175  1.00 31.61           O  
ATOM    409  CB  THR    58     -10.180  20.998 162.777  1.00 32.99           C  
ATOM    410  OG1 THR    58     -11.548  21.305 162.487  1.00 32.94           O  
ATOM    411  CG2 THR    58      -9.628  20.102 161.665  1.00 33.92           C  
ATOM    412  N   GLY    59      -8.051  21.038 165.226  1.00 29.22           N  
ATOM    413  CA  GLY    59      -6.655  20.940 165.629  1.00 27.38           C  
ATOM    414  C   GLY    59      -5.873  22.231 165.456  1.00 28.44           C  
ATOM    415  O   GLY    59      -6.366  23.328 165.734  1.00 27.05           O  
ATOM    416  N   ALA    60      -4.650  22.104 164.964  1.00 27.51           N  
ATOM    417  CA  ALA    60      -3.798  23.261 164.784  1.00 28.53           C  
ATOM    418  C   ALA    60      -3.383  23.494 163.344  1.00 27.12           C  
ATOM    419  O   ALA    60      -3.470  22.598 162.499  1.00 26.54           O  
ATOM    420  CB  ALA    60      -2.553  23.121 165.676  1.00 26.61           C  
ATOM    421  N   ILE    61      -2.936  24.716 163.076  1.00 26.85           N  
ATOM    422  CA  ILE    61      -2.436  25.079 161.757  1.00 25.89           C  
ATOM    423  C   ILE    61      -1.026  25.662 161.925  1.00 26.23           C  
ATOM    424  O   ILE    61      -0.795  26.518 162.789  1.00 24.01           O  
ATOM    425  CB  ILE    61      -3.291  26.156 161.062  1.00 24.77           C  
ATOM    426  CG1 ILE    61      -4.711  25.646 160.832  1.00 26.17           C  
ATOM    427  CG2 ILE    61      -2.667  26.511 159.695  1.00 28.08           C  
ATOM    428  CD1 ILE    61      -5.649  26.690 160.250  1.00 24.83           C  
ATOM    429  N   ALA    62      -0.086  25.172 161.120  1.00 24.83           N  
ATOM    430  CA  ALA    62       1.285  25.687 161.129  1.00 27.04           C  
ATOM    431  C   ALA    62       1.558  26.266 159.728  1.00 26.93           C  
ATOM    432  O   ALA    62       1.616  25.537 158.737  1.00 27.63           O  
ATOM    433  CB  ALA    62       2.302  24.572 161.447  1.00 24.51           C  
ATOM    434  N   ILE    63       1.703  27.582 159.650  1.00 29.03           N  
ATOM    435  CA  ILE    63       1.974  28.269 158.397  1.00 30.40           C  
ATOM    436  C   ILE    63       3.430  28.702 158.444  1.00 30.95           C  
ATOM    437  O   ILE    63       3.771  29.745 159.002  1.00 32.03           O  
ATOM    438  CB  ILE    63       1.057  29.488 158.246  1.00 31.41           C  
ATOM    439  CG1 ILE    63      -0.394  29.016 158.112  1.00 33.10           C  
ATOM    440  CG2 ILE    63       1.472  30.306 157.044  1.00 33.12           C  
ATOM    441  CD1 ILE    63      -1.389  29.915 158.811  1.00 34.01           C  
ATOM    442  N   THR    64       4.289  27.911 157.812  1.00 31.33           N  
ATOM    443  CA  THR    64       5.721  28.179 157.842  1.00 31.25           C  
ATOM    444  C   THR    64       6.492  27.262 156.895  1.00 31.37           C  
ATOM    445  O   THR    64       6.055  26.147 156.621  1.00 31.07           O  
ATOM    446  CB  THR    64       6.248  27.938 159.275  1.00 30.66           C  
ATOM    447  OG1 THR    64       7.678  27.951 159.289  1.00 31.03           O  
ATOM    448  CG2 THR    64       5.768  26.557 159.795  1.00 30.49           C  
ATOM    449  N   PRO    65       7.651  27.719 156.398  1.00 32.35           N  
ATOM    450  CA  PRO    65       8.500  26.936 155.489  1.00 32.48           C  
ATOM    451  C   PRO    65       9.084  25.724 156.212  1.00 33.51           C  
ATOM    452  O   PRO    65       9.439  24.734 155.590  1.00 35.67           O  
ATOM    453  CB  PRO    65       9.603  27.913 155.089  1.00 31.90           C  
ATOM    454  CG  PRO    65       8.961  29.242 155.205  1.00 34.17           C  
ATOM    455  CD  PRO    65       8.050  29.140 156.412  1.00 32.46           C  
ATOM    456  N   ALA    66       9.209  25.823 157.529  1.00 33.82           N  
ATOM    457  CA  ALA    66       9.751  24.726 158.336  1.00 33.47           C  
ATOM    458  C   ALA    66       8.656  24.140 159.222  1.00 34.22           C  
ATOM    459  O   ALA    66       8.747  24.175 160.443  1.00 32.79           O  
ATOM    460  CB  ALA    66      10.897  25.226 159.206  1.00 34.03           C  
ATOM    461  N   ALA    67       7.622  23.586 158.600  1.00 34.58           N  
ATOM    462  CA  ALA    67       6.496  23.008 159.329  1.00 34.68           C  
ATOM    463  C   ALA    67       6.851  21.748 160.101  1.00 35.19           C  
ATOM    464  O   ALA    67       6.146  21.366 161.041  1.00 33.42           O  
ATOM    465  CB  ALA    67       5.348  22.721 158.365  1.00 33.52           C  
ATOM    466  N   GLY    68       7.944  21.108 159.698  1.00 34.05           N  
ATOM    467  CA  GLY    68       8.365  19.888 160.351  1.00 33.14           C  
ATOM    468  C   GLY    68       8.839  20.106 161.776  1.00 33.00           C  
ATOM    469  O   GLY    68       8.451  19.368 162.690  1.00 31.77           O  
ATOM    470  N   LEU    69       9.685  21.111 161.967  1.00 31.47           N  
ATOM    471  CA  LEU    69      10.206  21.409 163.290  1.00 32.26           C  
ATOM    472  C   LEU    69       9.049  21.904 164.167  1.00 33.07           C  
ATOM    473  O   LEU    69       8.747  21.322 165.202  1.00 33.37           O  
ATOM    474  CB  LEU    69      11.316  22.469 163.199  1.00 30.74           C  
ATOM    475  CG  LEU    69      11.850  23.000 164.535  1.00 32.20           C  
ATOM    476  CD1 LEU    69      12.571  21.903 165.298  1.00 32.82           C  
ATOM    477  CD2 LEU    69      12.786  24.161 164.273  1.00 29.97           C  
ATOM    478  N   VAL    70       8.404  22.979 163.737  1.00 33.16           N  
ATOM    479  CA  VAL    70       7.270  23.553 164.456  1.00 34.67           C  
ATOM    480  C   VAL    70       6.188  22.511 164.772  1.00 34.31           C  
ATOM    481  O   VAL    70       5.713  22.433 165.910  1.00 33.10           O  
ATOM    482  CB  VAL    70       6.641  24.707 163.632  1.00 35.05           C  
ATOM    483  CG1 VAL    70       5.295  25.134 164.236  1.00 37.65           C  
ATOM    484  CG2 VAL    70       7.594  25.883 163.595  1.00 33.13           C  
ATOM    485  N   GLY    71       5.818  21.730 163.755  1.00 32.90           N  
ATOM    486  CA  GLY    71       4.791  20.711 163.886  1.00 30.68           C  
ATOM    487  C   GLY    71       5.058  19.658 164.935  1.00 30.85           C  
ATOM    488  O   GLY    71       4.128  19.144 165.564  1.00 31.53           O  
ATOM    489  N   LEU    72       6.329  19.312 165.101  1.00 29.51           N  
ATOM    490  CA  LEU    72       6.718  18.310 166.080  1.00 30.07           C  
ATOM    491  C   LEU    72       6.456  18.822 167.497  1.00 28.95           C  
ATOM    492  O   LEU    72       6.056  18.058 168.379  1.00 29.63           O  
ATOM    493  CB  LEU    72       8.199  17.931 165.905  1.00 28.25           C  
ATOM    494  CG  LEU    72       8.495  17.019 164.697  1.00 28.77           C  
ATOM    495  CD1 LEU    72      10.006  16.853 164.530  1.00 31.04           C  
ATOM    496  CD2 LEU    72       7.842  15.648 164.901  1.00 27.33           C  
ATOM    497  N   TYR    73       6.689  20.111 167.721  1.00 29.65           N  
ATOM    498  CA  TYR    73       6.457  20.703 169.041  1.00 29.58           C  
ATOM    499  C   TYR    73       4.964  20.741 169.333  1.00 28.26           C  
ATOM    500  O   TYR    73       4.531  20.474 170.441  1.00 29.39           O  
ATOM    501  CB  TYR    73       7.009  22.121 169.087  1.00 29.72           C  
ATOM    502  CG  TYR    73       8.499  22.183 169.239  1.00 29.82           C  
ATOM    503  CD1 TYR    73       9.111  21.787 170.432  1.00 29.49           C  
ATOM    504  CD2 TYR    73       9.299  22.677 168.210  1.00 29.76           C  
ATOM    505  CE1 TYR    73      10.485  21.890 170.597  1.00 30.20           C  
ATOM    506  CE2 TYR    73      10.678  22.785 168.362  1.00 28.61           C  
ATOM    507  CZ  TYR    73      11.261  22.396 169.553  1.00 29.90           C  
ATOM    508  OH  TYR    73      12.613  22.544 169.717  1.00 35.40           O  
ATOM    509  N   ILE    74       4.187  21.075 168.313  1.00 27.05           N  
ATOM    510  CA  ILE    74       2.742  21.150 168.431  1.00 26.50           C  
ATOM    511  C   ILE    74       2.135  19.761 168.633  1.00 26.41           C  
ATOM    512  O   ILE    74       1.286  19.576 169.502  1.00 28.29           O  
ATOM    513  CB  ILE    74       2.133  21.843 167.173  1.00 25.58           C  
ATOM    514  CG1 ILE    74       2.499  23.330 167.185  1.00 23.49           C  
ATOM    515  CG2 ILE    74       0.621  21.655 167.133  1.00 22.85           C  
ATOM    516  CD1 ILE    74       1.908  24.129 166.028  1.00 28.06           C  
ATOM    517  N   LEU    75       2.578  18.785 167.838  1.00 29.11           N  
ATOM    518  CA  LEU    75       2.070  17.417 167.943  1.00 31.04           C  
ATOM    519  C   LEU    75       2.324  16.801 169.317  1.00 31.90           C  
ATOM    520  O   LEU    75       1.556  15.959 169.776  1.00 32.45           O  
ATOM    521  CB  LEU    75       2.669  16.541 166.827  1.00 29.40           C  
ATOM    522  CG  LEU    75       2.073  16.841 165.443  1.00 32.38           C  
ATOM    523  CD1 LEU    75       2.908  16.176 164.343  1.00 30.38           C  
ATOM    524  CD2 LEU    75       0.623  16.352 165.404  1.00 29.98           C  
ATOM    525  N   ASN    76       3.395  17.230 169.975  1.00 33.41           N  
ATOM    526  CA  ASN    76       3.712  16.733 171.314  1.00 35.17           C  
ATOM    527  C   ASN    76       2.572  17.013 172.296  1.00 35.09           C  
ATOM    528  O   ASN    76       2.253  16.169 173.134  1.00 36.99           O  
ATOM    529  CB  ASN    76       4.985  17.396 171.838  1.00 34.72           C  
ATOM    530  CG  ASN    76       6.245  16.662 171.424  1.00 39.54           C  
ATOM    531  OD1 ASN    76       7.342  17.238 171.396  1.00 43.81           O  
ATOM    532  ND2 ASN    76       6.101  15.382 171.115  1.00 43.80           N  
ATOM    533  N   GLY    77       1.956  18.193 172.195  1.00 32.65           N  
ATOM    534  CA  GLY    77       0.886  18.548 173.123  1.00 31.47           C  
ATOM    535  C   GLY    77      -0.552  18.330 172.695  1.00 32.40           C  
ATOM    536  O   GLY    77      -1.423  18.051 173.515  1.00 32.95           O  
ATOM    537  N   LEU    78      -0.793  18.459 171.402  1.00 31.49           N  
ATOM    538  CA  LEU    78      -2.120  18.294 170.822  1.00 32.19           C  
ATOM    539  C   LEU    78      -2.823  16.975 171.191  1.00 32.44           C  
ATOM    540  O   LEU    78      -2.192  15.920 171.231  1.00 33.08           O  
ATOM    541  CB  LEU    78      -2.002  18.403 169.302  1.00 29.81           C  
ATOM    542  CG  LEU    78      -2.898  19.317 168.462  1.00 36.01           C  
ATOM    543  CD1 LEU    78      -3.015  20.694 169.104  1.00 31.57           C  
ATOM    544  CD2 LEU    78      -2.310  19.420 167.051  1.00 33.99           C  
ATOM    545  N   ALA    79      -4.125  17.038 171.467  1.00 32.64           N  
ATOM    546  CA  ALA    79      -4.892  15.832 171.782  1.00 34.44           C  
ATOM    547  C   ALA    79      -4.895  14.941 170.513  1.00 36.11           C  
ATOM    548  O   ALA    79      -4.945  15.436 169.369  1.00 34.62           O  
ATOM    549  CB  ALA    79      -6.313  16.202 172.177  1.00 33.20           C  
ATOM    550  N   ASP    80      -4.855  13.626 170.720  1.00 37.28           N  
ATOM    551  CA  ASP    80      -4.807  12.657 169.619  1.00 38.96           C  
ATOM    552  C   ASP    80      -5.900  12.729 168.569  1.00 39.23           C  
ATOM    553  O   ASP    80      -5.662  12.390 167.403  1.00 40.09           O  
ATOM    554  CB  ASP    80      -4.733  11.229 170.168  1.00 39.60           C  
ATOM    555  CG  ASP    80      -3.476  10.985 170.982  1.00 42.87           C  
ATOM    556  OD1 ASP    80      -2.538  11.801 170.863  1.00 44.38           O  
ATOM    557  OD2 ASP    80      -3.422   9.972 171.723  1.00 45.18           O  
ATOM    558  N   ASN    81      -7.082  13.184 168.970  1.00 39.54           N  
ATOM    559  CA  ASN    81      -8.204  13.278 168.047  1.00 39.87           C  
ATOM    560  C   ASN    81      -8.299  14.609 167.305  1.00 39.74           C  
ATOM    561  O   ASN    81      -9.394  15.121 167.052  1.00 39.36           O  
ATOM    562  CB  ASN    81      -9.514  12.983 168.783  1.00 41.88           C  
ATOM    563  CG  ASN    81      -9.823  13.994 169.858  1.00 43.68           C  
ATOM    564  OD1 ASN    81      -8.920  14.588 170.441  1.00 47.17           O  
ATOM    565  ND2 ASN    81     -11.110  14.181 170.145  1.00 46.32           N  
ATOM    566  N   THR    82      -7.140  15.166 166.966  1.00 38.30           N  
ATOM    567  CA  THR    82      -7.066  16.420 166.219  1.00 36.46           C  
ATOM    568  C   THR    82      -5.965  16.231 165.179  1.00 37.02           C  
ATOM    569  O   THR    82      -5.215  15.253 165.228  1.00 35.72           O  
ATOM    570  CB  THR    82      -6.673  17.620 167.113  1.00 36.23           C  
ATOM    571  OG1 THR    82      -5.346  17.421 167.621  1.00 36.98           O  
ATOM    572  CG2 THR    82      -7.648  17.775 168.276  1.00 32.89           C  
ATOM    573  N   THR    83      -5.870  17.152 164.229  1.00 35.99           N  
ATOM    574  CA  THR    83      -4.833  17.056 163.204  1.00 36.94           C  
ATOM    575  C   THR    83      -3.979  18.323 163.161  1.00 35.17           C  
ATOM    576  O   THR    83      -4.354  19.372 163.704  1.00 34.96           O  
ATOM    577  CB  THR    83      -5.419  16.869 161.772  1.00 36.92           C  
ATOM    578  OG1 THR    83      -6.172  18.035 161.406  1.00 39.44           O  
ATOM    579  CG2 THR    83      -6.322  15.639 161.695  1.00 37.40           C  
ATOM    580  N   LEU    84      -2.814  18.214 162.535  1.00 33.33           N  
ATOM    581  CA  LEU    84      -1.956  19.373 162.347  1.00 32.12           C  
ATOM    582  C   LEU    84      -2.042  19.650 160.851  1.00 31.40           C  
ATOM    583  O   LEU    84      -1.809  18.764 160.022  1.00 32.33           O  
ATOM    584  CB  LEU    84      -0.491  19.090 162.727  1.00 32.68           C  
ATOM    585  CG  LEU    84       0.523  20.154 162.264  1.00 29.79           C  
ATOM    586  CD1 LEU    84       0.307  21.474 163.009  1.00 30.01           C  
ATOM    587  CD2 LEU    84       1.929  19.629 162.515  1.00 28.22           C  
ATOM    588  N   THR    85      -2.406  20.875 160.501  1.00 32.14           N  
ATOM    589  CA  THR    85      -2.507  21.273 159.104  1.00 30.98           C  
ATOM    590  C   THR    85      -1.329  22.197 158.812  1.00 31.89           C  
ATOM    591  O   THR    85      -1.208  23.272 159.401  1.00 32.68           O  
ATOM    592  CB  THR    85      -3.837  22.004 158.831  1.00 30.16           C  
ATOM    593  OG1 THR    85      -4.924  21.091 159.026  1.00 30.62           O  
ATOM    594  CG2 THR    85      -3.875  22.553 157.416  1.00 30.92           C  
ATOM    595  N   CYS    86      -0.458  21.762 157.906  1.00 32.18           N  
ATOM    596  CA  CYS    86       0.714  22.537 157.518  1.00 31.91           C  
ATOM    597  C   CYS    86       0.448  23.205 156.180  1.00 32.73           C  
ATOM    598  O   CYS    86      -0.146  22.612 155.283  1.00 33.43           O  
ATOM    599  CB  CYS    86       1.939  21.633 157.398  1.00 31.46           C  
ATOM    600  SG  CYS    86       2.309  20.684 158.888  1.00 30.56           S  
ATOM    601  N   ILE    87       0.900  24.445 156.047  1.00 32.21           N  
ATOM    602  CA  ILE    87       0.681  25.199 154.820  1.00 32.24           C  
ATOM    603  C   ILE    87       1.921  25.904 154.279  1.00 34.38           C  
ATOM    604  O   ILE    87       2.488  26.779 154.948  1.00 35.36           O  
ATOM    605  CB  ILE    87      -0.392  26.294 155.018  1.00 31.54           C  
ATOM    606  CG1 ILE    87      -1.607  25.723 155.753  1.00 28.05           C  
ATOM    607  CG2 ILE    87      -0.785  26.889 153.665  1.00 28.77           C  
ATOM    608  CD1 ILE    87      -2.753  26.703 155.903  1.00 31.08           C  
ATOM    609  N   ASP    88       2.344  25.505 153.082  1.00 34.03           N  
ATOM    610  CA  ASP    88       3.466  26.138 152.400  1.00 34.37           C  
ATOM    611  C   ASP    88       3.368  25.786 150.906  1.00 33.50           C  
ATOM    612  O   ASP    88       2.976  24.679 150.548  1.00 33.15           O  
ATOM    613  CB  ASP    88       4.823  25.687 152.965  1.00 32.69           C  
ATOM    614  CG  ASP    88       5.983  26.521 152.414  1.00 32.83           C  
ATOM    615  OD1 ASP    88       6.150  27.677 152.852  1.00 33.51           O  
ATOM    616  OD2 ASP    88       6.707  26.028 151.526  1.00 31.22           O  
ATOM    617  N   PRO    89       3.705  26.738 150.021  1.00 35.06           N  
ATOM    618  CA  PRO    89       3.654  26.536 148.564  1.00 37.30           C  
ATOM    619  C   PRO    89       4.796  25.746 147.929  1.00 39.95           C  
ATOM    620  O   PRO    89       4.690  25.310 146.781  1.00 40.65           O  
ATOM    621  CB  PRO    89       3.600  27.962 148.019  1.00 36.50           C  
ATOM    622  CG  PRO    89       4.416  28.736 149.005  1.00 33.94           C  
ATOM    623  CD  PRO    89       4.032  28.139 150.356  1.00 35.74           C  
ATOM    624  N   GLU    90       5.882  25.561 148.672  1.00 40.63           N  
ATOM    625  CA  GLU    90       7.049  24.865 148.164  1.00 41.49           C  
ATOM    626  C   GLU    90       6.934  23.361 148.357  1.00 41.43           C  
ATOM    627  O   GLU    90       6.688  22.892 149.464  1.00 42.37           O  
ATOM    628  CB  GLU    90       8.290  25.445 148.855  1.00 42.68           C  
ATOM    629  CG  GLU    90       9.148  26.359 147.968  1.00 47.20           C  
ATOM    630  CD  GLU    90       8.355  27.215 146.988  1.00 50.57           C  
ATOM    631  OE1 GLU    90       7.985  28.356 147.335  1.00 54.15           O  
ATOM    632  OE2 GLU    90       8.093  26.733 145.867  1.00 51.33           O  
ATOM    633  N   SER    91       7.118  22.606 147.277  1.00 40.04           N  
ATOM    634  CA  SER    91       6.974  21.159 147.346  1.00 40.28           C  
ATOM    635  C   SER    91       8.046  20.403 148.106  1.00 39.22           C  
ATOM    636  O   SER    91       7.757  19.360 148.698  1.00 38.91           O  
ATOM    637  CB  SER    91       6.795  20.574 145.938  1.00 40.80           C  
ATOM    638  OG  SER    91       7.828  20.986 145.076  1.00 47.75           O  
ATOM    639  N   GLU    92       9.273  20.917 148.105  1.00 38.40           N  
ATOM    640  CA  GLU    92      10.328  20.254 148.855  1.00 37.79           C  
ATOM    641  C   GLU    92      10.055  20.488 150.350  1.00 35.86           C  
ATOM    642  O   GLU    92      10.494  19.697 151.190  1.00 34.88           O  
ATOM    643  CB  GLU    92      11.724  20.777 148.458  1.00 37.99           C  
ATOM    644  CG  GLU    92      12.018  22.231 148.746  1.00 38.66           C  
ATOM    645  CD  GLU    92      13.401  22.629 148.226  1.00 39.16           C  
ATOM    646  OE1 GLU    92      13.730  23.832 148.234  1.00 44.47           O  
ATOM    647  OE2 GLU    92      14.165  21.728 147.819  1.00 39.56           O  
ATOM    648  N   HIS    93       9.339  21.565 150.689  1.00 34.44           N  
ATOM    649  CA  HIS    93       8.997  21.824 152.087  1.00 34.73           C  
ATOM    650  C   HIS    93       7.952  20.787 152.502  1.00 36.07           C  
ATOM    651  O   HIS    93       7.934  20.348 153.652  1.00 37.25           O  
ATOM    652  CB  HIS    93       8.472  23.258 152.258  1.00 34.41           C  
ATOM    653  CG  HIS    93       9.545  24.294 152.134  1.00 32.27           C  
ATOM    654  ND1 HIS    93       9.280  25.639 152.016  1.00 30.35           N  
ATOM    655  CD2 HIS    93      10.892  24.171 152.097  1.00 24.41           C  
ATOM    656  CE1 HIS    93      10.418  26.300 151.907  1.00 27.66           C  
ATOM    657  NE2 HIS    93      11.411  25.432 151.952  1.00 27.44           N  
ATOM    658  N   GLN    94       7.085  20.385 151.569  1.00 36.34           N  
ATOM    659  CA  GLN    94       6.070  19.368 151.863  1.00 36.30           C  
ATOM    660  C   GLN    94       6.777  18.026 152.075  1.00 37.32           C  
ATOM    661  O   GLN    94       6.414  17.252 152.974  1.00 36.92           O  
ATOM    662  CB  GLN    94       5.061  19.248 150.715  1.00 36.05           C  
ATOM    663  CG  GLN    94       4.217  17.979 150.781  1.00 38.03           C  
ATOM    664  CD  GLN    94       2.981  18.054 149.912  1.00 41.92           C  
ATOM    665  OE1 GLN    94       3.067  18.249 148.695  1.00 43.15           O  
ATOM    666  NE2 GLN    94       1.815  17.904 150.534  1.00 42.69           N  
ATOM    667  N   ARG    95       7.783  17.749 151.242  1.00 37.73           N  
ATOM    668  CA  ARG    95       8.554  16.513 151.365  1.00 38.04           C  
ATOM    669  C   ARG    95       9.350  16.566 152.664  1.00 36.71           C  
ATOM    670  O   ARG    95       9.433  15.578 153.389  1.00 37.54           O  
ATOM    671  CB  ARG    95       9.522  16.343 150.190  1.00 37.76           C  
ATOM    672  CG  ARG    95       8.981  15.501 149.051  1.00 41.07           C  
ATOM    673  CD  ARG    95      10.112  14.864 148.251  1.00 41.47           C  
ATOM    674  NE  ARG    95      10.210  13.421 148.471  1.00 44.73           N  
ATOM    675  CZ  ARG    95      11.303  12.697 148.238  1.00 48.22           C  
ATOM    676  NH1 ARG    95      12.405  13.277 147.777  1.00 43.75           N  
ATOM    677  NH2 ARG    95      11.300  11.388 148.466  1.00 50.29           N  
ATOM    678  N   GLN    96       9.929  17.729 152.950  1.00 36.06           N  
ATOM    679  CA  GLN    96      10.728  17.925 154.160  1.00 36.78           C  
ATOM    680  C   GLN    96       9.918  17.667 155.432  1.00 37.11           C  
ATOM    681  O   GLN    96      10.404  17.022 156.363  1.00 38.28           O  
ATOM    682  CB  GLN    96      11.321  19.352 154.177  1.00 36.09           C  
ATOM    683  CG  GLN    96      12.559  19.528 153.281  1.00 35.76           C  
ATOM    684  CD  GLN    96      12.876  20.987 152.938  1.00 37.87           C  
ATOM    685  OE1 GLN    96      12.553  21.902 153.695  1.00 37.55           O  
ATOM    686  NE2 GLN    96      13.521  21.202 151.787  1.00 37.71           N  
ATOM    687  N   ALA    97       8.685  18.164 155.459  1.00 36.86           N  
ATOM    688  CA  ALA    97       7.808  18.008 156.618  1.00 38.73           C  
ATOM    689  C   ALA    97       7.274  16.589 156.803  1.00 39.18           C  
ATOM    690  O   ALA    97       7.426  16.003 157.871  1.00 40.70           O  
ATOM    691  CB  ALA    97       6.642  18.998 156.527  1.00 38.41           C  
ATOM    692  N   LYS    98       6.643  16.043 155.767  1.00 41.29           N  
ATOM    693  CA  LYS    98       6.092  14.691 155.829  1.00 42.21           C  
ATOM    694  C   LYS    98       7.160  13.660 156.207  1.00 41.35           C  
ATOM    695  O   LYS    98       6.868  12.667 156.882  1.00 41.72           O  
ATOM    696  CB  LYS    98       5.452  14.320 154.489  1.00 42.60           C  
ATOM    697  CG  LYS    98       4.132  15.045 154.207  1.00 46.99           C  
ATOM    698  CD  LYS    98       3.701  14.826 152.757  1.00 50.33           C  
ATOM    699  CE  LYS    98       2.273  14.316 152.636  1.00 52.72           C  
ATOM    700  NZ  LYS    98       1.300  15.394 152.311  1.00 55.75           N  
ATOM    701  N   ALA    99       8.395  13.899 155.776  1.00 40.82           N  
ATOM    702  CA  ALA    99       9.501  13.005 156.096  1.00 40.65           C  
ATOM    703  C   ALA    99       9.746  13.051 157.612  1.00 41.49           C  
ATOM    704  O   ALA    99       9.763  12.015 158.279  1.00 42.92           O  
ATOM    705  CB  ALA    99      10.761  13.443 155.353  1.00 39.72           C  
ATOM    706  N   LEU   100       9.944  14.253 158.155  1.00 41.47           N  
ATOM    707  CA  LEU   100      10.195  14.414 159.590  1.00 42.16           C  
ATOM    708  C   LEU   100       9.088  13.802 160.454  1.00 43.10           C  
ATOM    709  O   LEU   100       9.366  13.216 161.504  1.00 44.57           O  
ATOM    710  CB  LEU   100      10.390  15.899 159.931  1.00 40.19           C  
ATOM    711  CG  LEU   100      11.760  16.459 159.539  1.00 40.76           C  
ATOM    712  CD1 LEU   100      11.733  17.979 159.622  1.00 38.21           C  
ATOM    713  CD2 LEU   100      12.845  15.879 160.463  1.00 39.23           C  
ATOM    714  N   PHE   101       7.837  13.937 160.017  1.00 43.20           N  
ATOM    715  CA  PHE   101       6.726  13.365 160.764  1.00 42.25           C  
ATOM    716  C   PHE   101       6.823  11.845 160.643  1.00 44.41           C  
ATOM    717  O   PHE   101       6.658  11.123 161.621  1.00 43.24           O  
ATOM    718  CB  PHE   101       5.385  13.879 160.217  1.00 41.31           C  
ATOM    719  CG  PHE   101       5.197  15.367 160.365  1.00 39.00           C  
ATOM    720  CD1 PHE   101       5.665  16.033 161.502  1.00 34.66           C  
ATOM    721  CD2 PHE   101       4.571  16.105 159.369  1.00 36.49           C  
ATOM    722  CE1 PHE   101       5.495  17.412 161.645  1.00 34.60           C  
ATOM    723  CE2 PHE   101       4.399  17.484 159.500  1.00 34.58           C  
ATOM    724  CZ  PHE   101       4.870  18.142 160.633  1.00 32.21           C  
ATOM    725  N   ARG   102       7.102  11.360 159.435  1.00 46.41           N  
ATOM    726  CA  ARG   102       7.242   9.923 159.196  1.00 48.11           C  
ATOM    727  C   ARG   102       8.348   9.354 160.107  1.00 48.36           C  
ATOM    728  O   ARG   102       8.139   8.336 160.770  1.00 48.43           O  
ATOM    729  CB  ARG   102       7.627   9.660 157.741  1.00 49.29           C  
ATOM    730  CG  ARG   102       7.634   8.184 157.333  1.00 51.02           C  
ATOM    731  CD  ARG   102       8.792   7.853 156.388  1.00 53.05           C  
ATOM    732  NE  ARG   102       9.139   8.969 155.508  1.00 52.14           N  
ATOM    733  CZ  ARG   102       8.311   9.516 154.622  1.00 55.54           C  
ATOM    734  NH1 ARG   102       7.078   9.047 154.486  1.00 53.38           N  
ATOM    735  NH2 ARG   102       8.711  10.542 153.882  1.00 51.50           N  
ATOM    736  N   GLU   103       9.516  10.005 160.131  1.00 48.96           N  
ATOM    737  CA  GLU   103      10.645   9.551 160.943  1.00 49.81           C  
ATOM    738  C   GLU   103      10.291   9.567 162.426  1.00 50.89           C  
ATOM    739  O   GLU   103      10.596   8.606 163.141  1.00 50.34           O  
ATOM    740  CB  GLU   103      11.893  10.388 160.616  1.00 50.09           C  
ATOM    741  CG  GLU   103      12.643   9.818 159.415  1.00 51.67           C  
ATOM    742  CD  GLU   103      13.347  10.890 158.626  1.00 51.76           C  
ATOM    743  OE1 GLU   103      13.899  11.825 159.251  1.00 48.29           O  
ATOM    744  OE2 GLU   103      13.354  10.796 157.383  1.00 55.16           O  
ATOM    745  N   ALA   104       9.667  10.652 162.892  1.00 51.35           N  
ATOM    746  CA  ALA   104       9.177  10.675 164.265  1.00 52.00           C  
ATOM    747  C   ALA   104       8.091   9.565 164.126  1.00 52.43           C  
ATOM    748  O   ALA   104       7.679   9.211 163.007  1.00 53.80           O  
ATOM    749  CB  ALA   104       8.528  12.007 164.577  1.00 52.52           C  
ATOM    750  N   GLY   105       7.572   9.038 165.222  1.00 51.99           N  
ATOM    751  CA  GLY   105       6.611   7.951 165.088  1.00 52.42           C  
ATOM    752  C   GLY   105       5.192   8.281 164.726  1.00 51.41           C  
ATOM    753  O   GLY   105       4.281   7.504 165.013  1.00 52.46           O  
ATOM    754  N   TYR   106       5.022   9.381 164.007  1.00 49.01           N  
ATOM    755  CA  TYR   106       3.692   9.848 163.660  1.00 48.06           C  
ATOM    756  C   TYR   106       2.927   9.292 162.481  1.00 48.12           C  
ATOM    757  O   TYR   106       3.453   9.190 161.388  1.00 48.28           O  
ATOM    758  CB  TYR   106       3.704  11.371 163.567  1.00 46.71           C  
ATOM    759  CG  TYR   106       3.873  12.108 164.893  1.00 46.02           C  
ATOM    760  CD1 TYR   106       2.832  12.165 165.824  1.00 45.78           C  
ATOM    761  CD2 TYR   106       5.077  12.743 165.217  1.00 45.53           C  
ATOM    762  CE1 TYR   106       2.987  12.828 167.043  1.00 43.89           C  
ATOM    763  CE2 TYR   106       5.242  13.401 166.435  1.00 45.18           C  
ATOM    764  CZ  TYR   106       4.194  13.441 167.339  1.00 47.22           C  
ATOM    765  OH  TYR   106       4.358  14.096 168.537  1.00 44.15           O  
ATOM    766  N   SER   107       1.663   8.960 162.731  1.00 48.48           N  
ATOM    767  CA  SER   107       0.783   8.435 161.702  1.00 49.27           C  
ATOM    768  C   SER   107       0.425   9.539 160.706  1.00 49.37           C  
ATOM    769  O   SER   107       0.319  10.710 161.073  1.00 49.53           O  
ATOM    770  CB  SER   107      -0.491   7.870 162.342  1.00 49.50           C  
ATOM    771  OG  SER   107      -1.474   7.588 161.364  1.00 52.70           O  
ATOM    772  N   PRO   108       0.235   9.176 159.429  1.00 49.21           N  
ATOM    773  CA  PRO   108      -0.110  10.142 158.376  1.00 48.45           C  
ATOM    774  C   PRO   108      -1.477  10.785 158.603  1.00 47.09           C  
ATOM    775  O   PRO   108      -1.770  11.856 158.079  1.00 46.18           O  
ATOM    776  CB  PRO   108      -0.096   9.296 157.096  1.00 49.07           C  
ATOM    777  CG  PRO   108       0.786   8.137 157.438  1.00 48.53           C  
ATOM    778  CD  PRO   108       0.450   7.831 158.867  1.00 48.40           C  
ATOM    779  N   SER   109      -2.314  10.103 159.375  1.00 45.54           N  
ATOM    780  CA  SER   109      -3.663  10.569 159.685  1.00 44.50           C  
ATOM    781  C   SER   109      -3.706  11.769 160.631  1.00 43.25           C  
ATOM    782  O   SER   109      -4.730  12.445 160.743  1.00 42.75           O  
ATOM    783  CB  SER   109      -4.464   9.421 160.291  1.00 44.79           C  
ATOM    784  OG  SER   109      -3.645   8.662 161.166  1.00 45.92           O  
ATOM    785  N   ARG   110      -2.588  12.025 161.304  1.00 42.31           N  
ATOM    786  CA  ARG   110      -2.488  13.132 162.250  1.00 41.07           C  
ATOM    787  C   ARG   110      -2.082  14.447 161.587  1.00 40.37           C  
ATOM    788  O   ARG   110      -2.299  15.523 162.138  1.00 38.73           O  
ATOM    789  CB  ARG   110      -1.468  12.805 163.339  1.00 41.93           C  
ATOM    790  CG  ARG   110      -1.842  11.684 164.295  1.00 39.91           C  
ATOM    791  CD  ARG   110      -3.104  12.011 165.079  1.00 39.10           C  
ATOM    792  NE  ARG   110      -3.127  13.356 165.664  1.00 35.37           N  
ATOM    793  CZ  ARG   110      -2.421  13.741 166.723  1.00 36.20           C  
ATOM    794  NH1 ARG   110      -1.620  12.889 167.337  1.00 32.35           N  
ATOM    795  NH2 ARG   110      -2.556  14.974 167.196  1.00 34.00           N  
ATOM    796  N   VAL   111      -1.499  14.351 160.399  1.00 39.59           N  
ATOM    797  CA  VAL   111      -1.040  15.528 159.674  1.00 38.83           C  
ATOM    798  C   VAL   111      -1.701  15.708 158.309  1.00 38.15           C  
ATOM    799  O   VAL   111      -2.128  14.745 157.676  1.00 37.24           O  
ATOM    800  CB  VAL   111       0.491  15.488 159.473  1.00 38.00           C  
ATOM    801  CG1 VAL   111       0.929  16.615 158.551  1.00 42.01           C  
ATOM    802  CG2 VAL   111       1.206  15.614 160.820  1.00 38.16           C  
ATOM    803  N   ARG   112      -1.765  16.957 157.867  1.00 36.98           N  
ATOM    804  CA  ARG   112      -2.351  17.300 156.590  1.00 36.33           C  
ATOM    805  C   ARG   112      -1.513  18.435 156.001  1.00 35.66           C  
ATOM    806  O   ARG   112      -1.324  19.472 156.648  1.00 36.99           O  
ATOM    807  CB  ARG   112      -3.798  17.750 156.830  1.00 36.34           C  
ATOM    808  CG  ARG   112      -4.485  18.397 155.660  1.00 37.42           C  
ATOM    809  CD  ARG   112      -5.397  19.503 156.170  1.00 40.20           C  
ATOM    810  NE  ARG   112      -6.749  19.400 155.634  1.00 45.44           N  
ATOM    811  CZ  ARG   112      -7.756  20.191 155.991  1.00 48.74           C  
ATOM    812  NH1 ARG   112      -7.573  21.156 156.889  1.00 49.80           N  
ATOM    813  NH2 ARG   112      -8.947  20.016 155.443  1.00 49.68           N  
ATOM    814  N   PHE   113      -1.009  18.253 154.784  1.00 34.58           N  
ATOM    815  CA  PHE   113      -0.209  19.303 154.170  1.00 35.15           C  
ATOM    816  C   PHE   113      -0.932  19.949 152.991  1.00 35.07           C  
ATOM    817  O   PHE   113      -1.384  19.270 152.067  1.00 37.67           O  
ATOM    818  CB  PHE   113       1.151  18.766 153.708  1.00 34.40           C  
ATOM    819  CG  PHE   113       2.229  19.827 153.643  1.00 36.00           C  
ATOM    820  CD1 PHE   113       3.235  19.879 154.609  1.00 36.27           C  
ATOM    821  CD2 PHE   113       2.207  20.800 152.650  1.00 32.65           C  
ATOM    822  CE1 PHE   113       4.199  20.895 154.590  1.00 33.82           C  
ATOM    823  CE2 PHE   113       3.163  21.815 152.616  1.00 34.72           C  
ATOM    824  CZ  PHE   113       4.163  21.865 153.589  1.00 33.01           C  
ATOM    825  N   LEU   114      -1.054  21.268 153.029  1.00 35.24           N  
ATOM    826  CA  LEU   114      -1.704  21.989 151.942  1.00 35.75           C  
ATOM    827  C   LEU   114      -0.634  22.776 151.168  1.00 36.12           C  
ATOM    828  O   LEU   114      -0.129  23.802 151.642  1.00 33.29           O  
ATOM    829  CB  LEU   114      -2.781  22.950 152.484  1.00 35.98           C  
ATOM    830  CG  LEU   114      -3.800  22.374 153.479  1.00 35.98           C  
ATOM    831  CD1 LEU   114      -4.787  23.453 153.902  1.00 30.83           C  
ATOM    832  CD2 LEU   114      -4.537  21.206 152.840  1.00 37.70           C  
ATOM    833  N   LEU   115      -0.291  22.272 149.982  1.00 36.66           N  
ATOM    834  CA  LEU   115       0.698  22.896 149.101  1.00 36.42           C  
ATOM    835  C   LEU   115       0.067  24.159 148.511  1.00 37.94           C  
ATOM    836  O   LEU   115      -0.413  24.156 147.371  1.00 37.92           O  
ATOM    837  CB  LEU   115       1.058  21.957 147.946  1.00 36.58           C  
ATOM    838  CG  LEU   115       2.472  21.414 147.736  1.00 37.22           C  
ATOM    839  CD1 LEU   115       2.652  21.168 146.230  1.00 32.33           C  
ATOM    840  CD2 LEU   115       3.537  22.398 148.235  1.00 31.00           C  
ATOM    841  N   SER   116       0.089  25.248 149.270  1.00 38.17           N  
ATOM    842  CA  SER   116      -0.526  26.495 148.825  1.00 39.28           C  
ATOM    843  C   SER   116       0.103  27.704 149.496  1.00 41.12           C  
ATOM    844  O   SER   116       0.891  27.567 150.442  1.00 40.46           O  
ATOM    845  CB  SER   116      -2.007  26.513 149.183  1.00 40.19           C  
ATOM    846  OG  SER   116      -2.470  25.254 149.656  1.00 42.22           O  
ATOM    847  N   ARG   117      -0.255  28.884 149.007  1.00 41.80           N  
ATOM    848  CA  ARG   117       0.210  30.105 149.614  1.00 42.60           C  
ATOM    849  C   ARG   117      -0.825  30.243 150.739  1.00 40.98           C  
ATOM    850  O   ARG   117      -2.039  30.078 150.529  1.00 41.28           O  
ATOM    851  CB  ARG   117       0.122  31.272 148.622  1.00 43.51           C  
ATOM    852  CG  ARG   117       0.859  30.961 147.339  1.00 49.76           C  
ATOM    853  CD  ARG   117       0.563  31.978 146.265  1.00 60.03           C  
ATOM    854  NE  ARG   117       0.982  33.320 146.662  1.00 67.32           N  
ATOM    855  CZ  ARG   117       1.017  34.367 145.842  1.00 67.66           C  
ATOM    856  NH1 ARG   117       0.659  34.231 144.571  1.00 67.92           N  
ATOM    857  NH2 ARG   117       1.413  35.550 146.293  1.00 68.00           N  
ATOM    858  N   PRO   118      -0.364  30.529 151.957  1.00 41.33           N  
ATOM    859  CA  PRO   118      -1.223  30.686 153.140  1.00 40.61           C  
ATOM    860  C   PRO   118      -2.504  31.479 152.927  1.00 39.64           C  
ATOM    861  O   PRO   118      -3.607  30.990 153.181  1.00 39.78           O  
ATOM    862  CB  PRO   118      -0.316  31.394 154.142  1.00 40.65           C  
ATOM    863  CG  PRO   118       1.041  30.954 153.775  1.00 41.68           C  
ATOM    864  CD  PRO   118       1.033  30.880 152.272  1.00 40.50           C  
ATOM    865  N   LEU   119      -2.343  32.715 152.460  1.00 41.33           N  
ATOM    866  CA  LEU   119      -3.471  33.595 152.279  1.00 43.36           C  
ATOM    867  C   LEU   119      -4.460  33.221 151.192  1.00 43.28           C  
ATOM    868  O   LEU   119      -5.565  33.763 151.135  1.00 43.18           O  
ATOM    869  CB  LEU   119      -2.962  35.032 152.110  1.00 44.68           C  
ATOM    870  CG  LEU   119      -2.149  35.568 153.306  1.00 47.79           C  
ATOM    871  CD1 LEU   119      -1.613  36.954 152.971  1.00 48.36           C  
ATOM    872  CD2 LEU   119      -3.017  35.620 154.562  1.00 48.43           C  
ATOM    873  N   ASP   120      -4.069  32.285 150.344  1.00 42.99           N  
ATOM    874  CA  ASP   120      -4.950  31.832 149.284  1.00 43.56           C  
ATOM    875  C   ASP   120      -5.859  30.709 149.778  1.00 42.46           C  
ATOM    876  O   ASP   120      -7.049  30.704 149.496  1.00 42.73           O  
ATOM    877  CB  ASP   120      -4.136  31.320 148.091  1.00 45.08           C  
ATOM    878  CG  ASP   120      -3.630  32.435 147.194  1.00 47.02           C  
ATOM    879  OD1 ASP   120      -2.502  32.322 146.665  1.00 52.57           O  
ATOM    880  OD2 ASP   120      -4.368  33.418 147.002  1.00 54.08           O  
ATOM    881  N   VAL   121      -5.295  29.775 150.541  1.00 41.31           N  
ATOM    882  CA  VAL   121      -6.037  28.611 151.013  1.00 39.94           C  
ATOM    883  C   VAL   121      -6.808  28.725 152.327  1.00 40.84           C  
ATOM    884  O   VAL   121      -7.690  27.907 152.604  1.00 38.80           O  
ATOM    885  CB  VAL   121      -5.094  27.400 151.086  1.00 39.13           C  
ATOM    886  CG1 VAL   121      -4.188  27.521 152.303  1.00 37.68           C  
ATOM    887  CG2 VAL   121      -5.882  26.106 151.110  1.00 37.94           C  
ATOM    888  N   MET   122      -6.475  29.722 153.134  1.00 42.29           N  
ATOM    889  CA  MET   122      -7.166  29.906 154.395  1.00 43.80           C  
ATOM    890  C   MET   122      -8.616  30.270 154.106  1.00 44.00           C  
ATOM    891  O   MET   122      -9.498  30.116 154.952  1.00 42.06           O  
ATOM    892  CB  MET   122      -6.466  30.986 155.225  1.00 44.01           C  
ATOM    893  CG  MET   122      -5.380  30.396 156.117  1.00 49.56           C  
ATOM    894  SD  MET   122      -4.119  31.725 156.693  1.00 61.27          SE  
ATOM    895  CE  MET   122      -2.501  30.840 156.177  1.00 61.36           C  
ATOM    896  N   SER   123      -8.852  30.740 152.885  1.00 45.14           N  
ATOM    897  CA  SER   123     -10.192  31.101 152.429  1.00 44.45           C  
ATOM    898  C   SER   123     -11.012  29.812 152.270  1.00 42.51           C  
ATOM    899  O   SER   123     -12.239  29.841 152.214  1.00 42.47           O  
ATOM    900  CB  SER   123     -10.104  31.792 151.072  1.00 44.03           C  
ATOM    901  OG  SER   123     -11.332  32.400 150.721  1.00 50.55           O  
ATOM    902  N   ARG   124     -10.320  28.682 152.204  1.00 39.98           N  
ATOM    903  CA  ARG   124     -10.938  27.375 151.993  1.00 39.77           C  
ATOM    904  C   ARG   124     -11.079  26.481 153.218  1.00 39.26           C  
ATOM    905  O   ARG   124     -11.430  25.302 153.091  1.00 38.53           O  
ATOM    906  CB  ARG   124     -10.144  26.624 150.927  1.00 39.41           C  
ATOM    907  CG  ARG   124     -10.516  26.921 149.478  1.00 39.67           C  
ATOM    908  CD  ARG   124     -10.214  28.346 149.054  1.00 34.87           C  
ATOM    909  NE  ARG   124     -10.183  28.446 147.599  1.00 37.32           N  
ATOM    910  CZ  ARG   124     -10.506  29.535 146.908  1.00 38.08           C  
ATOM    911  NH1 ARG   124     -10.895  30.633 147.538  1.00 40.47           N  
ATOM    912  NH2 ARG   124     -10.456  29.519 145.584  1.00 35.95           N  
ATOM    913  N   LEU   125     -10.807  27.038 154.392  1.00 38.20           N  
ATOM    914  CA  LEU   125     -10.896  26.266 155.616  1.00 37.17           C  
ATOM    915  C   LEU   125     -12.133  26.675 156.405  1.00 35.40           C  
ATOM    916  O   LEU   125     -12.668  27.759 156.217  1.00 35.38           O  
ATOM    917  CB  LEU   125      -9.612  26.457 156.446  1.00 36.51           C  
ATOM    918  CG  LEU   125      -8.289  26.098 155.744  1.00 34.19           C  
ATOM    919  CD1 LEU   125      -7.122  26.588 156.596  1.00 35.46           C  
ATOM    920  CD2 LEU   125      -8.189  24.592 155.505  1.00 33.35           C  
ATOM    921  N   ALA   126     -12.583  25.798 157.291  1.00 36.45           N  
ATOM    922  CA  ALA   126     -13.782  26.061 158.076  1.00 37.46           C  
ATOM    923  C   ALA   126     -13.588  27.043 159.223  1.00 37.94           C  
ATOM    924  O   ALA   126     -12.660  26.912 160.014  1.00 36.91           O  
ATOM    925  CB  ALA   126     -14.351  24.735 158.604  1.00 38.14           C  
ATOM    926  N   ASN   127     -14.479  28.026 159.299  1.00 37.51           N  
ATOM    927  CA  ASN   127     -14.436  29.028 160.357  1.00 39.25           C  
ATOM    928  C   ASN   127     -14.698  28.410 161.736  1.00 38.25           C  
ATOM    929  O   ASN   127     -15.415  27.410 161.853  1.00 37.89           O  
ATOM    930  CB  ASN   127     -15.499  30.104 160.130  1.00 38.20           C  
ATOM    931  CG  ASN   127     -15.109  31.115 159.077  1.00 45.54           C  
ATOM    932  OD1 ASN   127     -13.925  31.365 158.846  1.00 47.80           O  
ATOM    933  ND2 ASN   127     -16.114  31.728 158.440  1.00 50.71           N  
ATOM    934  N   ASP   128     -14.100  28.996 162.773  1.00 39.07           N  
ATOM    935  CA  ASP   128     -14.333  28.545 164.147  1.00 39.00           C  
ATOM    936  C   ASP   128     -14.037  27.068 164.369  1.00 37.42           C  
ATOM    937  O   ASP   128     -14.761  26.386 165.099  1.00 36.97           O  
ATOM    938  CB  ASP   128     -15.802  28.840 164.494  1.00 40.06           C  
ATOM    939  CG  ASP   128     -16.097  28.760 165.988  1.00 42.55           C  
ATOM    940  OD1 ASP   128     -15.284  29.278 166.781  1.00 42.74           O  
ATOM    941  OD2 ASP   128     -17.152  28.195 166.370  1.00 38.11           O  
ATOM    942  N   SER   129     -12.967  26.573 163.763  1.00 35.37           N  
ATOM    943  CA  SER   129     -12.636  25.160 163.890  1.00 34.54           C  
ATOM    944  C   SER   129     -11.245  24.857 164.426  1.00 31.43           C  
ATOM    945  O   SER   129     -10.918  23.699 164.679  1.00 32.63           O  
ATOM    946  CB  SER   129     -12.782  24.477 162.536  1.00 35.03           C  
ATOM    947  OG  SER   129     -14.099  24.034 162.294  1.00 37.23           O  
ATOM    948  N   TYR   130     -10.431  25.884 164.620  1.00 29.68           N  
ATOM    949  CA  TYR   130      -9.071  25.668 165.066  1.00 28.67           C  
ATOM    950  C   TYR   130      -8.751  26.269 166.423  1.00 28.72           C  
ATOM    951  O   TYR   130      -9.163  27.382 166.738  1.00 29.68           O  
ATOM    952  CB  TYR   130      -8.121  26.196 163.986  1.00 28.26           C  
ATOM    953  CG  TYR   130      -8.274  25.464 162.664  1.00 29.26           C  
ATOM    954  CD1 TYR   130      -7.600  24.263 162.430  1.00 29.35           C  
ATOM    955  CD2 TYR   130      -9.172  25.915 161.692  1.00 28.46           C  
ATOM    956  CE1 TYR   130      -7.803  23.531 161.259  1.00 26.56           C  
ATOM    957  CE2 TYR   130      -9.386  25.194 160.518  1.00 29.12           C  
ATOM    958  CZ  TYR   130      -8.700  23.994 160.313  1.00 29.08           C  
ATOM    959  OH  TYR   130      -8.905  23.276 159.154  1.00 27.26           O  
ATOM    960  N   GLN   131      -7.995  25.514 167.214  1.00 28.03           N  
ATOM    961  CA  GLN   131      -7.601  25.922 168.557  1.00 27.77           C  
ATOM    962  C   GLN   131      -6.230  26.599 168.607  1.00 27.85           C  
ATOM    963  O   GLN   131      -5.884  27.249 169.598  1.00 29.71           O  
ATOM    964  CB  GLN   131      -7.569  24.700 169.472  1.00 26.77           C  
ATOM    965  CG  GLN   131      -6.362  23.790 169.188  1.00 26.44           C  
ATOM    966  CD  GLN   131      -6.491  22.396 169.781  1.00 24.98           C  
ATOM    967  OE1 GLN   131      -5.943  22.106 170.843  1.00 24.78           O  
ATOM    968  NE2 GLN   131      -7.231  21.533 169.101  1.00 20.94           N  
ATOM    969  N   LEU   132      -5.446  26.448 167.546  1.00 27.47           N  
ATOM    970  CA  LEU   132      -4.105  27.023 167.532  1.00 26.57           C  
ATOM    971  C   LEU   132      -3.590  27.236 166.115  1.00 27.51           C  
ATOM    972  O   LEU   132      -3.679  26.349 165.264  1.00 29.60           O  
ATOM    973  CB  LEU   132      -3.137  26.104 168.301  1.00 25.75           C  
ATOM    974  CG  LEU   132      -1.629  26.415 168.296  1.00 29.37           C  
ATOM    975  CD1 LEU   132      -1.363  27.685 169.099  1.00 27.98           C  
ATOM    976  CD2 LEU   132      -0.842  25.243 168.885  1.00 27.03           C  
ATOM    977  N   VAL   133      -3.055  28.424 165.864  1.00 26.58           N  
ATOM    978  CA  VAL   133      -2.498  28.739 164.566  1.00 25.15           C  
ATOM    979  C   VAL   133      -1.139  29.410 164.763  1.00 26.35           C  
ATOM    980  O   VAL   133      -1.017  30.422 165.456  1.00 26.47           O  
ATOM    981  CB  VAL   133      -3.439  29.670 163.752  1.00 25.87           C  
ATOM    982  CG1 VAL   133      -2.807  30.010 162.398  1.00 25.01           C  
ATOM    983  CG2 VAL   133      -4.791  28.987 163.550  1.00 20.36           C  
ATOM    984  N   PHE   134      -0.113  28.818 164.169  1.00 25.32           N  
ATOM    985  CA  PHE   134       1.234  29.356 164.232  1.00 26.86           C  
ATOM    986  C   PHE   134       1.555  29.901 162.847  1.00 27.34           C  
ATOM    987  O   PHE   134       1.374  29.218 161.827  1.00 28.20           O  
ATOM    988  CB  PHE   134       2.266  28.275 164.582  1.00 26.10           C  
ATOM    989  CG  PHE   134       3.687  28.747 164.450  1.00 25.49           C  
ATOM    990  CD1 PHE   134       4.311  29.429 165.490  1.00 24.26           C  
ATOM    991  CD2 PHE   134       4.389  28.539 163.263  1.00 29.08           C  
ATOM    992  CE1 PHE   134       5.619  29.914 165.342  1.00 28.36           C  
ATOM    993  CE2 PHE   134       5.692  29.020 163.101  1.00 32.22           C  
ATOM    994  CZ  PHE   134       6.312  29.704 164.146  1.00 32.15           C  
ATOM    995  N   GLY   135       2.023  31.142 162.815  1.00 28.79           N  
ATOM    996  CA  GLY   135       2.375  31.753 161.551  1.00 28.63           C  
ATOM    997  C   GLY   135       3.800  32.285 161.495  1.00 29.23           C  
ATOM    998  O   GLY   135       4.256  32.988 162.400  1.00 26.26           O  
ATOM    999  N   GLN   136       4.525  31.894 160.454  1.00 30.13           N  
ATOM   1000  CA  GLN   136       5.876  32.386 160.239  1.00 33.40           C  
ATOM   1001  C   GLN   136       5.803  33.029 158.850  1.00 35.44           C  
ATOM   1002  O   GLN   136       5.966  32.367 157.820  1.00 36.80           O  
ATOM   1003  CB  GLN   136       6.918  31.255 160.234  1.00 32.41           C  
ATOM   1004  CG  GLN   136       8.323  31.769 159.955  1.00 33.06           C  
ATOM   1005  CD  GLN   136       9.078  32.162 161.210  1.00 33.64           C  
ATOM   1006  OE1 GLN   136       9.444  33.324 161.394  1.00 35.68           O  
ATOM   1007  NE2 GLN   136       9.320  31.192 162.080  1.00 29.90           N  
ATOM   1008  N   VAL   137       5.562  34.331 158.825  1.00 36.19           N  
ATOM   1009  CA  VAL   137       5.419  35.064 157.572  1.00 38.42           C  
ATOM   1010  C   VAL   137       6.248  36.342 157.564  1.00 41.25           C  
ATOM   1011  O   VAL   137       6.896  36.680 158.560  1.00 41.64           O  
ATOM   1012  CB  VAL   137       3.930  35.432 157.329  1.00 36.88           C  
ATOM   1013  CG1 VAL   137       3.080  34.166 157.285  1.00 34.48           C  
ATOM   1014  CG2 VAL   137       3.421  36.348 158.450  1.00 35.11           C  
ATOM   1015  N   SER   138       6.228  37.044 156.433  1.00 41.77           N  
ATOM   1016  CA  SER   138       6.941  38.307 156.320  1.00 41.93           C  
ATOM   1017  C   SER   138       6.078  39.351 157.022  1.00 41.25           C  
ATOM   1018  O   SER   138       4.846  39.232 157.063  1.00 40.59           O  
ATOM   1019  CB  SER   138       7.123  38.712 154.859  1.00 42.90           C  
ATOM   1020  OG  SER   138       8.000  37.823 154.205  1.00 48.55           O  
ATOM   1021  N   PRO   139       6.712  40.382 157.589  1.00 42.32           N  
ATOM   1022  CA  PRO   139       6.007  41.457 158.292  1.00 43.29           C  
ATOM   1023  C   PRO   139       4.924  42.111 157.442  1.00 45.67           C  
ATOM   1024  O   PRO   139       3.968  42.681 157.974  1.00 46.01           O  
ATOM   1025  CB  PRO   139       7.131  42.436 158.684  1.00 43.98           C  
ATOM   1026  CG  PRO   139       8.358  41.958 157.932  1.00 42.13           C  
ATOM   1027  CD  PRO   139       8.170  40.487 157.766  1.00 41.37           C  
ATOM   1028  N   MET   140       5.071  42.035 156.123  1.00 47.45           N  
ATOM   1029  CA  MET   140       4.076  42.638 155.239  1.00 49.28           C  
ATOM   1030  C   MET   140       2.823  41.772 155.122  1.00 47.01           C  
ATOM   1031  O   MET   140       1.779  42.231 154.660  1.00 47.15           O  
ATOM   1032  CB  MET   140       4.690  42.930 153.855  1.00 51.82           C  
ATOM   1033  CG  MET   140       5.654  44.141 153.862  1.00 59.82           C  
ATOM   1034  SD  MET   140       5.021  45.728 152.904  1.00 78.54          SE  
ATOM   1035  CE  MET   140       3.104  45.465 153.043  1.00 71.46           C  
ATOM   1036  N   ASP   141       2.921  40.519 155.556  1.00 44.94           N  
ATOM   1037  CA  ASP   141       1.783  39.606 155.512  1.00 41.78           C  
ATOM   1038  C   ASP   141       1.064  39.456 156.859  1.00 40.48           C  
ATOM   1039  O   ASP   141      -0.003  38.844 156.926  1.00 39.11           O  
ATOM   1040  CB  ASP   141       2.233  38.221 155.051  1.00 42.04           C  
ATOM   1041  CG  ASP   141       2.523  38.160 153.568  1.00 43.17           C  
ATOM   1042  OD1 ASP   141       1.754  38.773 152.809  1.00 41.63           O  
ATOM   1043  OD2 ASP   141       3.497  37.487 153.159  1.00 43.95           O  
ATOM   1044  N   LEU   142       1.630  40.029 157.922  1.00 40.15           N  
ATOM   1045  CA  LEU   142       1.058  39.873 159.259  1.00 39.48           C  
ATOM   1046  C   LEU   142      -0.394  40.231 159.457  1.00 39.93           C  
ATOM   1047  O   LEU   142      -1.167  39.431 159.997  1.00 40.66           O  
ATOM   1048  CB  LEU   142       1.924  40.590 160.300  1.00 38.67           C  
ATOM   1049  CG  LEU   142       3.300  39.975 160.600  1.00 38.68           C  
ATOM   1050  CD1 LEU   142       4.112  40.933 161.458  1.00 42.38           C  
ATOM   1051  CD2 LEU   142       3.129  38.637 161.311  1.00 38.58           C  
ATOM   1052  N   LYS   143      -0.757  41.420 159.004  1.00 38.96           N  
ATOM   1053  CA  LYS   143      -2.117  41.903 159.110  1.00 39.51           C  
ATOM   1054  C   LYS   143      -3.068  40.971 158.364  1.00 39.15           C  
ATOM   1055  O   LYS   143      -4.116  40.575 158.884  1.00 40.10           O  
ATOM   1056  CB  LYS   143      -2.215  43.303 158.502  1.00 40.31           C  
ATOM   1057  CG  LYS   143      -3.030  44.294 159.323  1.00 43.90           C  
ATOM   1058  CD  LYS   143      -4.008  45.096 158.470  1.00 49.29           C  
ATOM   1059  CE  LYS   143      -5.421  44.522 158.568  1.00 53.76           C  
ATOM   1060  NZ  LYS   143      -6.429  45.319 157.813  1.00 56.00           N  
ATOM   1061  N   ALA   144      -2.700  40.623 157.138  1.00 39.14           N  
ATOM   1062  CA  ALA   144      -3.530  39.752 156.316  1.00 38.68           C  
ATOM   1063  C   ALA   144      -3.670  38.382 156.968  1.00 38.00           C  
ATOM   1064  O   ALA   144      -4.731  37.759 156.900  1.00 38.66           O  
ATOM   1065  CB  ALA   144      -2.929  39.621 154.911  1.00 37.15           C  
ATOM   1066  N   LEU   145      -2.602  37.918 157.611  1.00 37.83           N  
ATOM   1067  CA  LEU   145      -2.646  36.621 158.263  1.00 37.23           C  
ATOM   1068  C   LEU   145      -3.621  36.667 159.451  1.00 37.14           C  
ATOM   1069  O   LEU   145      -4.358  35.707 159.691  1.00 36.62           O  
ATOM   1070  CB  LEU   145      -1.235  36.188 158.718  1.00 36.77           C  
ATOM   1071  CG  LEU   145      -1.168  34.756 159.271  1.00 39.44           C  
ATOM   1072  CD1 LEU   145      -1.620  33.766 158.186  1.00 37.20           C  
ATOM   1073  CD2 LEU   145       0.252  34.435 159.742  1.00 35.79           C  
ATOM   1074  N   VAL   146      -3.629  37.782 160.184  1.00 37.71           N  
ATOM   1075  CA  VAL   146      -4.521  37.956 161.337  1.00 37.17           C  
ATOM   1076  C   VAL   146      -5.980  37.944 160.885  1.00 38.38           C  
ATOM   1077  O   VAL   146      -6.835  37.306 161.498  1.00 37.63           O  
ATOM   1078  CB  VAL   146      -4.253  39.297 162.050  1.00 36.80           C  
ATOM   1079  CG1 VAL   146      -5.205  39.467 163.214  1.00 35.48           C  
ATOM   1080  CG2 VAL   146      -2.811  39.358 162.525  1.00 37.51           C  
ATOM   1081  N   ASP   147      -6.256  38.672 159.807  1.00 39.95           N  
ATOM   1082  CA  ASP   147      -7.606  38.754 159.260  1.00 38.92           C  
ATOM   1083  C   ASP   147      -8.037  37.403 158.725  1.00 38.35           C  
ATOM   1084  O   ASP   147      -9.206  37.036 158.812  1.00 42.00           O  
ATOM   1085  CB  ASP   147      -7.668  39.792 158.136  1.00 40.05           C  
ATOM   1086  CG  ASP   147      -7.366  41.190 158.624  1.00 41.34           C  
ATOM   1087  OD1 ASP   147      -7.807  41.532 159.743  1.00 43.67           O  
ATOM   1088  OD2 ASP   147      -6.697  41.948 157.892  1.00 43.65           O  
ATOM   1089  N   ALA   148      -7.085  36.658 158.171  1.00 36.95           N  
ATOM   1090  CA  ALA   148      -7.374  35.335 157.625  1.00 34.18           C  
ATOM   1091  C   ALA   148      -7.538  34.295 158.726  1.00 34.08           C  
ATOM   1092  O   ALA   148      -8.441  33.463 158.683  1.00 31.80           O  
ATOM   1093  CB  ALA   148      -6.259  34.907 156.667  1.00 33.64           C  
ATOM   1094  N   ALA   149      -6.658  34.343 159.716  1.00 33.69           N  
ATOM   1095  CA  ALA   149      -6.696  33.377 160.798  1.00 33.43           C  
ATOM   1096  C   ALA   149      -7.799  33.579 161.834  1.00 33.55           C  
ATOM   1097  O   ALA   149      -8.396  32.609 162.312  1.00 34.44           O  
ATOM   1098  CB  ALA   149      -5.327  33.330 161.489  1.00 34.63           C  
ATOM   1099  N   TRP   150      -8.088  34.830 162.172  1.00 35.02           N  
ATOM   1100  CA  TRP   150      -9.084  35.104 163.208  1.00 35.52           C  
ATOM   1101  C   TRP   150     -10.392  34.341 163.089  1.00 36.07           C  
ATOM   1102  O   TRP   150     -10.829  33.698 164.051  1.00 36.77           O  
ATOM   1103  CB  TRP   150      -9.368  36.609 163.312  1.00 36.87           C  
ATOM   1104  CG  TRP   150      -9.881  37.006 164.678  1.00 39.34           C  
ATOM   1105  CD1 TRP   150     -11.103  37.530 164.976  1.00 38.91           C  
ATOM   1106  CD2 TRP   150      -9.185  36.875 165.928  1.00 38.85           C  
ATOM   1107  NE1 TRP   150     -11.213  37.738 166.333  1.00 40.42           N  
ATOM   1108  CE2 TRP   150     -10.049  37.348 166.940  1.00 39.56           C  
ATOM   1109  CE3 TRP   150      -7.910  36.414 166.288  1.00 40.01           C  
ATOM   1110  CZ2 TRP   150      -9.686  37.359 168.296  1.00 38.56           C  
ATOM   1111  CZ3 TRP   150      -7.546  36.428 167.635  1.00 41.47           C  
ATOM   1112  CH2 TRP   150      -8.431  36.904 168.620  1.00 41.64           C  
ATOM   1113  N   PRO   151     -11.030  34.386 161.912  1.00 36.28           N  
ATOM   1114  CA  PRO   151     -12.297  33.668 161.748  1.00 36.18           C  
ATOM   1115  C   PRO   151     -12.183  32.164 161.992  1.00 34.50           C  
ATOM   1116  O   PRO   151     -13.130  31.534 162.451  1.00 34.71           O  
ATOM   1117  CB  PRO   151     -12.690  33.958 160.295  1.00 37.11           C  
ATOM   1118  CG  PRO   151     -11.968  35.221 159.959  1.00 37.77           C  
ATOM   1119  CD  PRO   151     -10.652  35.100 160.679  1.00 35.64           C  
ATOM   1120  N   LEU   152     -11.022  31.593 161.679  1.00 34.79           N  
ATOM   1121  CA  LEU   152     -10.801  30.153 161.836  1.00 35.06           C  
ATOM   1122  C   LEU   152     -10.602  29.733 163.289  1.00 34.90           C  
ATOM   1123  O   LEU   152     -10.874  28.596 163.669  1.00 35.83           O  
ATOM   1124  CB  LEU   152      -9.588  29.721 161.011  1.00 35.31           C  
ATOM   1125  CG  LEU   152      -9.532  30.146 159.535  1.00 32.06           C  
ATOM   1126  CD1 LEU   152      -8.139  29.863 158.949  1.00 28.65           C  
ATOM   1127  CD2 LEU   152     -10.608  29.410 158.747  1.00 30.78           C  
ATOM   1128  N   LEU   153     -10.130  30.668 164.101  1.00 36.20           N  
ATOM   1129  CA  LEU   153      -9.865  30.413 165.514  1.00 35.55           C  
ATOM   1130  C   LEU   153     -11.086  30.273 166.380  1.00 35.15           C  
ATOM   1131  O   LEU   153     -12.043  31.021 166.223  1.00 36.38           O  
ATOM   1132  CB  LEU   153      -9.014  31.525 166.110  1.00 34.73           C  
ATOM   1133  CG  LEU   153      -7.490  31.460 166.042  1.00 35.40           C  
ATOM   1134  CD1 LEU   153      -6.906  32.700 166.722  1.00 37.52           C  
ATOM   1135  CD2 LEU   153      -6.991  30.175 166.744  1.00 23.36           C  
ATOM   1136  N   ARG   154     -11.058  29.310 167.296  1.00 36.30           N  
ATOM   1137  CA  ARG   154     -12.162  29.145 168.232  1.00 36.51           C  
ATOM   1138  C   ARG   154     -11.818  30.000 169.474  1.00 36.76           C  
ATOM   1139  O   ARG   154     -10.651  30.379 169.676  1.00 33.72           O  
ATOM   1140  CB  ARG   154     -12.319  27.674 168.634  1.00 36.75           C  
ATOM   1141  CG  ARG   154     -12.718  26.785 167.478  1.00 37.06           C  
ATOM   1142  CD  ARG   154     -12.577  25.313 167.811  1.00 37.83           C  
ATOM   1143  NE  ARG   154     -13.585  24.850 168.759  1.00 45.05           N  
ATOM   1144  CZ  ARG   154     -14.877  24.707 168.473  1.00 47.28           C  
ATOM   1145  NH1 ARG   154     -15.331  24.991 167.257  1.00 41.82           N  
ATOM   1146  NH2 ARG   154     -15.710  24.265 169.404  1.00 47.48           N  
ATOM   1147  N   ARG   155     -12.823  30.308 170.295  1.00 37.44           N  
ATOM   1148  CA  ARG   155     -12.610  31.086 171.514  1.00 37.17           C  
ATOM   1149  C   ARG   155     -11.747  30.192 172.403  1.00 35.22           C  
ATOM   1150  O   ARG   155     -11.978  28.975 172.493  1.00 36.48           O  
ATOM   1151  CB  ARG   155     -13.961  31.403 172.183  1.00 38.81           C  
ATOM   1152  CG  ARG   155     -14.937  32.087 171.233  1.00 42.34           C  
ATOM   1153  CD  ARG   155     -16.218  32.427 171.953  1.00 47.96           C  
ATOM   1154  NE  ARG   155     -16.064  33.616 172.784  1.00 54.25           N  
ATOM   1155  CZ  ARG   155     -16.418  34.843 172.409  1.00 56.26           C  
ATOM   1156  NH1 ARG   155     -16.953  35.045 171.210  1.00 56.53           N  
ATOM   1157  NH2 ARG   155     -16.230  35.868 173.234  1.00 56.32           N  
ATOM   1158  N   GLY   156     -10.764  30.799 173.062  1.00 32.13           N  
ATOM   1159  CA  GLY   156      -9.822  30.049 173.880  1.00 30.79           C  
ATOM   1160  C   GLY   156      -8.670  29.644 172.940  1.00 29.86           C  
ATOM   1161  O   GLY   156      -7.673  29.034 173.361  1.00 28.96           O  
ATOM   1162  N   GLY   157      -8.795  30.009 171.657  1.00 28.58           N  
ATOM   1163  CA  GLY   157      -7.783  29.685 170.652  1.00 26.53           C  
ATOM   1164  C   GLY   157      -6.719  30.750 170.521  1.00 26.35           C  
ATOM   1165  O   GLY   157      -6.981  31.934 170.724  1.00 26.49           O  
ATOM   1166  N   ALA   158      -5.517  30.330 170.143  1.00 26.28           N  
ATOM   1167  CA  ALA   158      -4.402  31.253 170.021  1.00 26.53           C  
ATOM   1168  C   ALA   158      -3.752  31.338 168.663  1.00 27.37           C  
ATOM   1169  O   ALA   158      -3.498  30.317 168.023  1.00 27.64           O  
ATOM   1170  CB  ALA   158      -3.333  30.924 171.057  1.00 24.38           C  
ATOM   1171  N   LEU   159      -3.468  32.568 168.245  1.00 28.32           N  
ATOM   1172  CA  LEU   159      -2.747  32.823 167.013  1.00 28.11           C  
ATOM   1173  C   LEU   159      -1.342  33.223 167.503  1.00 27.21           C  
ATOM   1174  O   LEU   159      -1.189  34.162 168.296  1.00 26.79           O  
ATOM   1175  CB  LEU   159      -3.371  33.994 166.234  1.00 28.52           C  
ATOM   1176  CG  LEU   159      -2.577  34.518 165.030  1.00 31.81           C  
ATOM   1177  CD1 LEU   159      -2.417  33.424 163.973  1.00 33.87           C  
ATOM   1178  CD2 LEU   159      -3.322  35.715 164.451  1.00 31.17           C  
ATOM   1179  N   VAL   160      -0.322  32.501 167.047  1.00 25.88           N  
ATOM   1180  CA  VAL   160       1.064  32.772 167.428  1.00 24.79           C  
ATOM   1181  C   VAL   160       1.858  33.296 166.232  1.00 27.75           C  
ATOM   1182  O   VAL   160       2.033  32.591 165.232  1.00 26.63           O  
ATOM   1183  CB  VAL   160       1.738  31.501 167.987  1.00 24.17           C  
ATOM   1184  CG1 VAL   160       3.150  31.821 168.438  1.00 23.11           C  
ATOM   1185  CG2 VAL   160       0.923  30.964 169.163  1.00 19.43           C  
ATOM   1186  N   LEU   161       2.338  34.537 166.340  1.00 29.92           N  
ATOM   1187  CA  LEU   161       3.088  35.183 165.258  1.00 31.39           C  
ATOM   1188  C   LEU   161       4.569  35.347 165.580  1.00 33.08           C  
ATOM   1189  O   LEU   161       4.957  36.203 166.376  1.00 32.56           O  
ATOM   1190  CB  LEU   161       2.467  36.550 164.943  1.00 31.04           C  
ATOM   1191  CG  LEU   161       0.954  36.513 164.655  1.00 29.82           C  
ATOM   1192  CD1 LEU   161       0.395  37.937 164.570  1.00 26.88           C  
ATOM   1193  CD2 LEU   161       0.693  35.749 163.363  1.00 26.34           C  
ATOM   1194  N   ALA   162       5.394  34.522 164.946  1.00 33.46           N  
ATOM   1195  CA  ALA   162       6.841  34.557 165.155  1.00 35.04           C  
ATOM   1196  C   ALA   162       7.519  35.821 164.628  1.00 36.17           C  
ATOM   1197  O   ALA   162       7.108  36.373 163.604  1.00 36.48           O  
ATOM   1198  CB  ALA   162       7.484  33.337 164.511  1.00 35.01           C  
ATOM   1199  N   ASP   163       8.559  36.260 165.343  1.00 35.67           N  
ATOM   1200  CA  ASP   163       9.367  37.428 164.980  1.00 35.23           C  
ATOM   1201  C   ASP   163       8.577  38.664 164.556  1.00 34.80           C  
ATOM   1202  O   ASP   163       9.082  39.491 163.803  1.00 37.18           O  
ATOM   1203  CB  ASP   163      10.324  37.063 163.848  1.00 36.36           C  
ATOM   1204  CG  ASP   163      11.103  35.796 164.126  1.00 38.68           C  
ATOM   1205  OD1 ASP   163      11.514  35.602 165.286  1.00 41.88           O  
ATOM   1206  OD2 ASP   163      11.319  34.996 163.186  1.00 44.47           O  
ATOM   1207  N   ALA   164       7.352  38.800 165.048  1.00 34.25           N  
ATOM   1208  CA  ALA   164       6.485  39.911 164.677  1.00 35.10           C  
ATOM   1209  C   ALA   164       6.843  41.287 165.218  1.00 37.45           C  
ATOM   1210  O   ALA   164       6.275  42.297 164.783  1.00 36.35           O  
ATOM   1211  CB  ALA   164       5.058  39.579 165.062  1.00 34.18           C  
ATOM   1212  N   LEU   165       7.782  41.327 166.155  1.00 38.68           N  
ATOM   1213  CA  LEU   165       8.179  42.576 166.783  1.00 41.51           C  
ATOM   1214  C   LEU   165       9.527  43.091 166.299  1.00 43.63           C  
ATOM   1215  O   LEU   165       9.965  44.174 166.688  1.00 44.67           O  
ATOM   1216  CB  LEU   165       8.215  42.389 168.300  1.00 40.59           C  
ATOM   1217  CG  LEU   165       6.898  42.048 169.005  1.00 37.73           C  
ATOM   1218  CD1 LEU   165       7.169  41.504 170.401  1.00 39.58           C  
ATOM   1219  CD2 LEU   165       6.026  43.291 169.080  1.00 42.32           C  
ATOM   1220  N   LEU   166      10.172  42.306 165.446  1.00 46.20           N  
ATOM   1221  CA  LEU   166      11.477  42.650 164.900  1.00 47.74           C  
ATOM   1222  C   LEU   166      12.459  43.155 165.952  1.00 49.34           C  
ATOM   1223  O   LEU   166      13.031  44.241 165.822  1.00 48.89           O  
ATOM   1224  CB  LEU   166      11.326  43.671 163.760  1.00 47.18           C  
ATOM   1225  CG  LEU   166      10.589  43.140 162.518  1.00 47.23           C  
ATOM   1226  CD1 LEU   166      10.505  44.215 161.444  1.00 48.55           C  
ATOM   1227  CD2 LEU   166      11.325  41.922 161.986  1.00 48.26           C  
ATOM   1228  N   ASP   167      12.632  42.357 167.004  1.00 51.27           N  
ATOM   1229  CA  ASP   167      13.570  42.673 168.073  1.00 52.31           C  
ATOM   1230  C   ASP   167      13.333  44.014 168.764  1.00 53.19           C  
ATOM   1231  O   ASP   167      14.231  44.548 169.422  1.00 53.46           O  
ATOM   1232  CB  ASP   167      14.992  42.629 167.513  1.00 53.31           C  
ATOM   1233  CG  ASP   167      15.465  41.213 167.224  1.00 54.32           C  
ATOM   1234  OD1 ASP   167      15.400  40.377 168.146  1.00 57.29           O  
ATOM   1235  OD2 ASP   167      15.913  40.938 166.089  1.00 59.10           O  
ATOM   1236  N   GLY   168      12.123  44.545 168.614  1.00 54.04           N  
ATOM   1237  CA  GLY   168      11.793  45.823 169.209  1.00 56.23           C  
ATOM   1238  C   GLY   168      12.089  46.953 168.235  1.00 58.04           C  
ATOM   1239  O   GLY   168      11.750  48.110 168.482  1.00 57.65           O  
ATOM   1240  N   THR   169      12.735  46.611 167.124  1.00 59.91           N  
ATOM   1241  CA  THR   169      13.095  47.571 166.079  1.00 61.31           C  
ATOM   1242  C   THR   169      12.033  48.640 165.864  1.00 62.28           C  
ATOM   1243  O   THR   169      12.365  49.803 165.619  1.00 63.59           O  
ATOM   1244  CB  THR   169      13.342  46.846 164.726  1.00 60.94           C  
ATOM   1245  OG1 THR   169      14.680  46.335 164.684  1.00 60.61           O  
ATOM   1246  CG2 THR   169      13.109  47.780 163.544  1.00 62.48           C  
ATOM   1247  N   ILE   170      10.762  48.250 165.954  1.00 63.65           N  
ATOM   1248  CA  ILE   170       9.677  49.198 165.728  1.00 65.26           C  
ATOM   1249  C   ILE   170       9.646  50.344 166.743  1.00 67.56           C  
ATOM   1250  O   ILE   170      10.360  50.315 167.740  1.00 67.27           O  
ATOM   1251  CB  ILE   170       8.300  48.465 165.611  1.00 64.43           C  
ATOM   1252  CG1 ILE   170       8.059  47.560 166.808  1.00 65.08           C  
ATOM   1253  CG2 ILE   170       8.284  47.632 164.319  1.00 63.91           C  
ATOM   1254  CD1 ILE   170       6.824  46.694 166.661  1.00 61.22           C  
ATOM   1255  N   ALA   171       8.815  51.349 166.477  1.00 71.03           N  
ATOM   1256  CA  ALA   171       8.732  52.562 167.298  1.00 74.04           C  
ATOM   1257  C   ALA   171      10.147  53.153 167.376  1.00 76.78           C  
ATOM   1258  O   ALA   171      10.730  53.279 168.460  1.00 77.43           O  
ATOM   1259  CB  ALA   171       8.222  52.258 168.694  1.00 74.35           C  
ATOM   1260  N   ASP   172      10.699  53.525 166.223  1.00 79.39           N  
ATOM   1261  CA  ASP   172      12.045  54.097 166.162  1.00 81.44           C  
ATOM   1262  C   ASP   172      12.123  55.050 164.972  1.00 82.22           C  
ATOM   1263  O   ASP   172      12.056  54.625 163.819  1.00 83.14           O  
ATOM   1264  CB  ASP   172      13.070  52.972 165.995  1.00 81.68           C  
ATOM   1265  CG  ASP   172      14.447  53.340 166.498  1.00 85.84           C  
ATOM   1266  OD1 ASP   172      14.833  54.516 166.380  1.00 90.92           O  
ATOM   1267  OD2 ASP   172      15.153  52.441 166.997  1.00 87.39           O  
ATOM   1268  N   GLN   173      12.282  56.336 165.262  1.00 82.92           N  
ATOM   1269  CA  GLN   173      12.352  57.356 164.224  1.00 83.98           C  
ATOM   1270  C   GLN   173      13.324  57.023 163.106  1.00 83.45           C  
ATOM   1271  O   GLN   173      12.969  57.063 161.933  1.00 83.90           O  
ATOM   1272  CB  GLN   173      12.712  58.717 164.834  1.00 84.72           C  
ATOM   1273  CG  GLN   173      11.607  59.350 165.690  1.00 88.73           C  
ATOM   1274  CD  GLN   173      11.323  58.578 166.965  1.00 91.02           C  
ATOM   1275  OE1 GLN   173      12.243  58.150 167.655  1.00 91.29           O  
ATOM   1276  NE2 GLN   173      10.044  58.415 167.295  1.00 90.94           N  
ATOM   1277  N   THR   174      14.550  56.679 163.477  1.00 82.77           N  
ATOM   1278  CA  THR   174      15.575  56.341 162.498  1.00 82.11           C  
ATOM   1279  C   THR   174      15.135  55.223 161.573  1.00 81.93           C  
ATOM   1280  O   THR   174      15.240  55.333 160.348  1.00 81.65           O  
ATOM   1281  CB  THR   174      16.901  55.902 163.178  1.00 82.03           C  
ATOM   1282  OG1 THR   174      16.664  54.764 164.022  1.00 82.87           O  
ATOM   1283  CG2 THR   174      17.494  57.036 164.004  1.00 80.61           C  
ATOM   1284  N   ARG   175      14.620  54.155 162.170  1.00 81.42           N  
ATOM   1285  CA  ARG   175      14.203  52.990 161.400  1.00 80.76           C  
ATOM   1286  C   ARG   175      13.016  53.134 160.457  1.00 80.26           C  
ATOM   1287  O   ARG   175      11.901  52.742 160.806  1.00 80.41           O  
ATOM   1288  CB  ARG   175      13.966  51.805 162.341  1.00 80.91           C  
ATOM   1289  CG  ARG   175      14.234  50.422 161.726  1.00 82.08           C  
ATOM   1290  CD  ARG   175      15.675  49.988 161.956  1.00 84.76           C  
ATOM   1291  NE  ARG   175      16.086  50.219 163.341  1.00 85.35           N  
ATOM   1292  CZ  ARG   175      17.050  49.545 163.962  1.00 86.15           C  
ATOM   1293  NH1 ARG   175      17.712  48.585 163.327  1.00 83.31           N  
ATOM   1294  NH2 ARG   175      17.346  49.826 165.226  1.00 86.88           N  
ATOM   1295  N   LYS   176      13.252  53.728 159.283  1.00 79.32           N  
ATOM   1296  CA  LYS   176      12.200  53.819 158.277  1.00 77.64           C  
ATOM   1297  C   LYS   176      12.482  52.544 157.460  1.00 76.67           C  
ATOM   1298  O   LYS   176      13.654  52.147 157.250  1.00 76.95           O  
ATOM   1299  CB  LYS   176      12.349  55.063 157.415  1.00 78.36           C  
ATOM   1300  N   ASP   177      11.419  51.901 156.986  1.00 73.97           N  
ATOM   1301  CA  ASP   177      11.555  50.614 156.296  1.00 71.10           C  
ATOM   1302  C   ASP   177      10.173  50.140 155.855  1.00 69.68           C  
ATOM   1303  O   ASP   177       9.176  50.354 156.551  1.00 69.25           O  
ATOM   1304  CB  ASP   177      12.096  49.619 157.317  1.00 71.15           C  
ATOM   1305  CG  ASP   177      13.030  48.583 156.729  1.00 71.21           C  
ATOM   1306  OD1 ASP   177      13.875  48.966 155.902  1.00 71.86           O  
ATOM   1307  OD2 ASP   177      12.938  47.392 157.122  1.00 69.21           O  
ATOM   1308  N   ARG   178      10.122  49.464 154.716  1.00 67.48           N  
ATOM   1309  CA  ARG   178       8.873  48.908 154.231  1.00 65.11           C  
ATOM   1310  C   ARG   178       8.368  47.952 155.319  1.00 62.93           C  
ATOM   1311  O   ARG   178       7.205  47.995 155.716  1.00 61.37           O  
ATOM   1312  CB  ARG   178       9.120  48.129 152.934  1.00 65.76           C  
ATOM   1313  N   ASP   179       9.258  47.081 155.789  1.00 61.40           N  
ATOM   1314  CA  ASP   179       8.914  46.072 156.785  1.00 61.31           C  
ATOM   1315  C   ASP   179       8.565  46.570 158.176  1.00 61.77           C  
ATOM   1316  O   ASP   179       7.499  46.240 158.708  1.00 62.54           O  
ATOM   1317  CB  ASP   179      10.025  45.013 156.857  1.00 60.28           C  
ATOM   1318  CG  ASP   179       9.996  44.057 155.657  1.00 60.29           C  
ATOM   1319  OD1 ASP   179       8.969  44.025 154.933  1.00 56.76           O  
ATOM   1320  OD2 ASP   179      10.993  43.330 155.451  1.00 58.00           O  
ATOM   1321  N   THR   180       9.457  47.362 158.756  1.00 61.26           N  
ATOM   1322  CA  THR   180       9.238  47.899 160.085  1.00 60.59           C  
ATOM   1323  C   THR   180       7.871  48.589 160.156  1.00 59.22           C  
ATOM   1324  O   THR   180       7.154  48.475 161.156  1.00 59.51           O  
ATOM   1325  CB  THR   180      10.351  48.910 160.457  1.00 60.28           C  
ATOM   1326  OG1 THR   180      10.457  48.997 161.881  1.00 63.84           O  
ATOM   1327  CG2 THR   180      10.034  50.299 159.913  1.00 62.53           C  
ATOM   1328  N   GLN   181       7.517  49.301 159.089  1.00 57.42           N  
ATOM   1329  CA  GLN   181       6.250  50.026 159.021  1.00 56.34           C  
ATOM   1330  C   GLN   181       5.053  49.083 158.956  1.00 54.30           C  
ATOM   1331  O   GLN   181       3.980  49.394 159.486  1.00 55.01           O  
ATOM   1332  CB  GLN   181       6.247  50.951 157.799  1.00 56.61           C  
ATOM   1333  CG  GLN   181       5.074  51.905 157.722  1.00 60.31           C  
ATOM   1334  CD  GLN   181       5.224  52.896 156.579  1.00 66.50           C  
ATOM   1335  OE1 GLN   181       6.338  53.162 156.123  1.00 68.79           O  
ATOM   1336  NE2 GLN   181       4.108  53.467 156.131  1.00 65.27           N  
ATOM   1337  N   ALA   182       5.241  47.936 158.308  1.00 52.30           N  
ATOM   1338  CA  ALA   182       4.177  46.945 158.188  1.00 51.70           C  
ATOM   1339  C   ALA   182       4.042  46.221 159.534  1.00 49.61           C  
ATOM   1340  O   ALA   182       2.929  45.999 160.011  1.00 48.87           O  
ATOM   1341  CB  ALA   182       4.504  45.948 157.068  1.00 51.18           C  
ATOM   1342  N   ALA   183       5.175  45.864 160.141  1.00 47.78           N  
ATOM   1343  CA  ALA   183       5.170  45.196 161.439  1.00 49.10           C  
ATOM   1344  C   ALA   183       4.535  46.152 162.474  1.00 50.05           C  
ATOM   1345  O   ALA   183       3.764  45.721 163.333  1.00 49.60           O  
ATOM   1346  CB  ALA   183       6.601  44.831 161.846  1.00 47.67           C  
ATOM   1347  N   ARG   184       4.849  47.448 162.392  1.00 51.31           N  
ATOM   1348  CA  ARG   184       4.283  48.433 163.319  1.00 52.65           C  
ATOM   1349  C   ARG   184       2.760  48.504 163.162  1.00 53.41           C  
ATOM   1350  O   ARG   184       2.031  48.534 164.157  1.00 53.91           O  
ATOM   1351  CB  ARG   184       4.872  49.820 163.066  1.00 54.06           C  
ATOM   1352  CG  ARG   184       5.157  50.600 164.341  1.00 57.28           C  
ATOM   1353  CD  ARG   184       5.260  52.096 164.094  1.00 59.50           C  
ATOM   1354  NE  ARG   184       6.262  52.446 163.092  1.00 61.89           N  
ATOM   1355  CZ  ARG   184       7.549  52.123 163.171  1.00 65.18           C  
ATOM   1356  NH1 ARG   184       8.000  51.441 164.209  1.00 66.46           N  
ATOM   1357  NH2 ARG   184       8.390  52.486 162.210  1.00 67.83           N  
ATOM   1358  N   ASP   185       2.280  48.532 161.917  1.00 53.41           N  
ATOM   1359  CA  ASP   185       0.838  48.596 161.664  1.00 54.19           C  
ATOM   1360  C   ASP   185       0.141  47.321 162.135  1.00 52.11           C  
ATOM   1361  O   ASP   185      -0.988  47.361 162.637  1.00 51.76           O  
ATOM   1362  CB  ASP   185       0.545  48.817 160.177  1.00 55.83           C  
ATOM   1363  CG  ASP   185      -0.940  48.873 159.884  1.00 63.25           C  
ATOM   1364  OD1 ASP   185      -1.551  47.806 159.669  1.00 71.31           O  
ATOM   1365  OD2 ASP   185      -1.503  49.988 159.886  1.00 73.27           O  
ATOM   1366  N   ALA   186       0.817  46.189 161.972  1.00 50.23           N  
ATOM   1367  CA  ALA   186       0.269  44.908 162.407  1.00 48.60           C  
ATOM   1368  C   ALA   186       0.097  44.960 163.936  1.00 46.32           C  
ATOM   1369  O   ALA   186      -0.975  44.666 164.459  1.00 45.88           O  
ATOM   1370  CB  ALA   186       1.220  43.776 162.022  1.00 47.52           C  
ATOM   1371  N   ASP   187       1.157  45.336 164.646  1.00 45.93           N  
ATOM   1372  CA  ASP   187       1.121  45.421 166.106  1.00 46.57           C  
ATOM   1373  C   ASP   187      -0.020  46.353 166.537  1.00 46.63           C  
ATOM   1374  O   ASP   187      -0.879  45.975 167.341  1.00 46.91           O  
ATOM   1375  CB  ASP   187       2.474  45.939 166.620  1.00 45.25           C  
ATOM   1376  CG  ASP   187       2.575  45.923 168.138  1.00 49.55           C  
ATOM   1377  OD1 ASP   187       2.652  44.821 168.735  1.00 45.87           O  
ATOM   1378  OD2 ASP   187       2.569  47.024 168.736  1.00 50.96           O  
ATOM   1379  N   GLU   188      -0.024  47.571 166.001  1.00 46.68           N  
ATOM   1380  CA  GLU   188      -1.064  48.545 166.320  1.00 46.47           C  
ATOM   1381  C   GLU   188      -2.450  47.988 165.972  1.00 45.29           C  
ATOM   1382  O   GLU   188      -3.409  48.177 166.717  1.00 44.23           O  
ATOM   1383  CB  GLU   188      -0.806  49.845 165.548  1.00 47.29           C  
ATOM   1384  CG  GLU   188      -1.912  50.873 165.661  1.00 52.14           C  
ATOM   1385  CD  GLU   188      -1.559  52.167 164.960  1.00 58.46           C  
ATOM   1386  OE1 GLU   188      -0.450  52.686 165.211  1.00 60.41           O  
ATOM   1387  OE2 GLU   188      -2.388  52.672 164.171  1.00 57.72           O  
ATOM   1388  N   TYR   189      -2.552  47.304 164.835  1.00 44.78           N  
ATOM   1389  CA  TYR   189      -3.822  46.712 164.409  1.00 43.79           C  
ATOM   1390  C   TYR   189      -4.226  45.571 165.343  1.00 42.73           C  
ATOM   1391  O   TYR   189      -5.385  45.467 165.753  1.00 43.44           O  
ATOM   1392  CB  TYR   189      -3.716  46.157 162.994  1.00 43.66           C  
ATOM   1393  CG  TYR   189      -4.990  45.489 162.538  1.00 43.06           C  
ATOM   1394  CD1 TYR   189      -6.135  46.241 162.280  1.00 45.51           C  
ATOM   1395  CD2 TYR   189      -5.064  44.104 162.395  1.00 40.70           C  
ATOM   1396  CE1 TYR   189      -7.320  45.635 161.886  1.00 48.14           C  
ATOM   1397  CE2 TYR   189      -6.248  43.483 162.003  1.00 43.88           C  
ATOM   1398  CZ  TYR   189      -7.370  44.256 161.751  1.00 46.56           C  
ATOM   1399  OH  TYR   189      -8.540  43.659 161.351  1.00 45.85           O  
ATOM   1400  N   ILE   190      -3.268  44.710 165.676  1.00 41.78           N  
ATOM   1401  CA  ILE   190      -3.536  43.587 166.562  1.00 39.45           C  
ATOM   1402  C   ILE   190      -4.024  44.084 167.931  1.00 39.67           C  
ATOM   1403  O   ILE   190      -4.950  43.518 168.511  1.00 38.60           O  
ATOM   1404  CB  ILE   190      -2.267  42.701 166.725  1.00 40.19           C  
ATOM   1405  CG1 ILE   190      -2.089  41.824 165.479  1.00 36.29           C  
ATOM   1406  CG2 ILE   190      -2.366  41.848 167.998  1.00 37.83           C  
ATOM   1407  CD1 ILE   190      -0.753  41.100 165.413  1.00 26.27           C  
ATOM   1408  N   ARG   191      -3.404  45.142 168.445  1.00 40.01           N  
ATOM   1409  CA  ARG   191      -3.792  45.684 169.743  1.00 43.13           C  
ATOM   1410  C   ARG   191      -5.132  46.419 169.725  1.00 44.80           C  
ATOM   1411  O   ARG   191      -5.630  46.842 170.766  1.00 44.64           O  
ATOM   1412  CB  ARG   191      -2.695  46.611 170.265  1.00 41.94           C  
ATOM   1413  CG  ARG   191      -1.437  45.882 170.742  1.00 42.77           C  
ATOM   1414  CD  ARG   191      -0.238  46.814 170.764  1.00 46.32           C  
ATOM   1415  NE  ARG   191      -0.668  48.195 170.934  1.00 51.32           N  
ATOM   1416  CZ  ARG   191      -0.136  49.228 170.292  1.00 50.72           C  
ATOM   1417  NH1 ARG   191       0.853  49.047 169.427  1.00 50.42           N  
ATOM   1418  NH2 ARG   191      -0.598  50.446 170.515  1.00 53.35           N  
ATOM   1419  N   SER   192      -5.725  46.543 168.543  1.00 45.68           N  
ATOM   1420  CA  SER   192      -6.994  47.240 168.393  1.00 46.18           C  
ATOM   1421  C   SER   192      -8.188  46.294 168.323  1.00 46.25           C  
ATOM   1422  O   SER   192      -9.328  46.721 168.519  1.00 46.21           O  
ATOM   1423  CB  SER   192      -6.979  48.097 167.124  1.00 47.71           C  
ATOM   1424  OG  SER   192      -7.303  47.324 165.967  1.00 47.27           O  
ATOM   1425  N   ILE   193      -7.944  45.015 168.046  1.00 47.19           N  
ATOM   1426  CA  ILE   193      -9.054  44.092 167.912  1.00 46.69           C  
ATOM   1427  C   ILE   193      -9.698  43.766 169.246  1.00 45.97           C  
ATOM   1428  O   ILE   193      -9.027  43.638 170.263  1.00 45.13           O  
ATOM   1429  CB  ILE   193      -8.627  42.829 167.096  1.00 46.55           C  
ATOM   1430  CG1 ILE   193      -9.275  41.581 167.659  1.00 48.58           C  
ATOM   1431  CG2 ILE   193      -7.122  42.735 167.017  1.00 48.52           C  
ATOM   1432  CD1 ILE   193      -8.374  40.370 167.601  1.00 53.08           C  
ATOM   1433  N   GLU   194     -11.020  43.641 169.220  1.00 46.10           N  
ATOM   1434  CA  GLU   194     -11.803  43.405 170.419  1.00 46.72           C  
ATOM   1435  C   GLU   194     -12.074  41.944 170.734  1.00 45.13           C  
ATOM   1436  O   GLU   194     -12.243  41.126 169.834  1.00 44.75           O  
ATOM   1437  CB  GLU   194     -13.119  44.175 170.299  1.00 48.29           C  
ATOM   1438  CG  GLU   194     -13.732  44.629 171.616  1.00 53.72           C  
ATOM   1439  CD  GLU   194     -13.127  45.922 172.135  1.00 60.45           C  
ATOM   1440  OE1 GLU   194     -12.510  46.656 171.332  1.00 61.44           O  
ATOM   1441  OE2 GLU   194     -13.287  46.211 173.341  1.00 63.38           O  
ATOM   1442  N   GLY   195     -12.123  41.631 172.022  1.00 42.68           N  
ATOM   1443  CA  GLY   195     -12.355  40.262 172.422  1.00 41.19           C  
ATOM   1444  C   GLY   195     -11.115  39.427 172.149  1.00 38.96           C  
ATOM   1445  O   GLY   195     -11.204  38.228 171.879  1.00 38.68           O  
ATOM   1446  N   ALA   196      -9.949  40.069 172.193  1.00 37.97           N  
ATOM   1447  CA  ALA   196      -8.669  39.386 171.968  1.00 38.03           C  
ATOM   1448  C   ALA   196      -7.746  39.616 173.142  1.00 38.17           C  
ATOM   1449  O   ALA   196      -7.723  40.713 173.714  1.00 39.15           O  
ATOM   1450  CB  ALA   196      -7.979  39.904 170.722  1.00 37.01           C  
ATOM   1451  N   HIS   197      -6.990  38.587 173.518  1.00 36.67           N  
ATOM   1452  CA  HIS   197      -5.979  38.759 174.559  1.00 34.86           C  
ATOM   1453  C   HIS   197      -4.672  38.817 173.766  1.00 34.12           C  
ATOM   1454  O   HIS   197      -4.383  37.946 172.928  1.00 34.95           O  
ATOM   1455  CB  HIS   197      -5.904  37.572 175.516  1.00 34.32           C  
ATOM   1456  CG  HIS   197      -7.163  37.314 176.261  1.00 30.53           C  
ATOM   1457  ND1 HIS   197      -7.739  38.243 177.100  1.00 28.83           N  
ATOM   1458  CD2 HIS   197      -7.935  36.209 176.330  1.00 32.70           C  
ATOM   1459  CE1 HIS   197      -8.814  37.717 177.656  1.00 29.31           C  
ATOM   1460  NE2 HIS   197      -8.955  36.484 177.205  1.00 27.66           N  
ATOM   1461  N   VAL   198      -3.887  39.856 174.006  1.00 32.85           N  
ATOM   1462  CA  VAL   198      -2.614  40.026 173.315  1.00 31.44           C  
ATOM   1463  C   VAL   198      -1.459  39.870 174.291  1.00 31.83           C  
ATOM   1464  O   VAL   198      -1.404  40.553 175.311  1.00 33.09           O  
ATOM   1465  CB  VAL   198      -2.521  41.420 172.641  1.00 32.23           C  
ATOM   1466  CG1 VAL   198      -1.167  41.590 171.962  1.00 29.85           C  
ATOM   1467  CG2 VAL   198      -3.662  41.584 171.629  1.00 31.51           C  
ATOM   1468  N   ALA   199      -0.555  38.942 173.991  1.00 31.03           N  
ATOM   1469  CA  ALA   199       0.623  38.735 174.820  1.00 30.46           C  
ATOM   1470  C   ALA   199       1.808  38.865 173.865  1.00 30.64           C  
ATOM   1471  O   ALA   199       1.832  38.228 172.812  1.00 30.97           O  
ATOM   1472  CB  ALA   199       0.609  37.340 175.471  1.00 28.20           C  
ATOM   1473  N   ARG   200       2.775  39.707 174.212  1.00 30.50           N  
ATOM   1474  CA  ARG   200       3.949  39.902 173.383  1.00 31.66           C  
ATOM   1475  C   ARG   200       5.137  39.535 174.265  1.00 32.61           C  
ATOM   1476  O   ARG   200       5.411  40.170 175.282  1.00 33.33           O  
ATOM   1477  CB  ARG   200       3.962  41.351 172.862  1.00 31.67           C  
ATOM   1478  CG  ARG   200       2.891  41.543 171.766  1.00 36.13           C  
ATOM   1479  CD  ARG   200       2.761  43.000 171.353  1.00 37.83           C  
ATOM   1480  NE  ARG   200       2.310  43.827 172.467  1.00 38.02           N  
ATOM   1481  CZ  ARG   200       2.536  45.129 172.561  1.00 37.23           C  
ATOM   1482  NH1 ARG   200       3.209  45.752 171.599  1.00 37.07           N  
ATOM   1483  NH2 ARG   200       2.122  45.793 173.631  1.00 35.20           N  
ATOM   1484  N   LEU   201       5.848  38.501 173.837  1.00 31.75           N  
ATOM   1485  CA  LEU   201       6.921  37.919 174.608  1.00 31.41           C  
ATOM   1486  C   LEU   201       8.335  37.984 174.037  1.00 31.43           C  
ATOM   1487  O   LEU   201       8.513  38.065 172.835  1.00 31.82           O  
ATOM   1488  CB  LEU   201       6.513  36.467 174.892  1.00 29.43           C  
ATOM   1489  CG  LEU   201       5.021  36.302 175.288  1.00 32.44           C  
ATOM   1490  CD1 LEU   201       4.614  34.815 175.271  1.00 26.90           C  
ATOM   1491  CD2 LEU   201       4.773  36.920 176.667  1.00 27.08           C  
ATOM   1492  N   PRO   202       9.352  37.925 174.917  1.00 30.80           N  
ATOM   1493  CA  PRO   202      10.767  37.978 174.532  1.00 30.32           C  
ATOM   1494  C   PRO   202      11.335  36.677 173.954  1.00 30.34           C  
ATOM   1495  O   PRO   202      12.359  36.191 174.416  1.00 30.23           O  
ATOM   1496  CB  PRO   202      11.457  38.373 175.834  1.00 30.91           C  
ATOM   1497  CG  PRO   202      10.656  37.632 176.860  1.00 28.45           C  
ATOM   1498  CD  PRO   202       9.205  37.859 176.387  1.00 30.07           C  
ATOM   1499  N   LEU   203      10.667  36.118 172.952  1.00 30.48           N  
ATOM   1500  CA  LEU   203      11.123  34.883 172.314  1.00 30.84           C  
ATOM   1501  C   LEU   203      11.410  35.167 170.839  1.00 31.51           C  
ATOM   1502  O   LEU   203      10.659  35.887 170.186  1.00 30.41           O  
ATOM   1503  CB  LEU   203      10.053  33.790 172.456  1.00 30.29           C  
ATOM   1504  CG  LEU   203       9.891  33.170 173.843  1.00 32.44           C  
ATOM   1505  CD1 LEU   203       8.508  32.527 173.937  1.00 32.55           C  
ATOM   1506  CD2 LEU   203      11.009  32.152 174.088  1.00 23.45           C  
ATOM   1507  N   GLY   204      12.497  34.596 170.326  1.00 32.37           N  
ATOM   1508  CA  GLY   204      12.882  34.847 168.949  1.00 34.19           C  
ATOM   1509  C   GLY   204      13.081  36.350 168.798  1.00 35.62           C  
ATOM   1510  O   GLY   204      13.706  36.997 169.647  1.00 35.96           O  
ATOM   1511  N   ALA   205      12.557  36.924 167.719  1.00 35.06           N  
ATOM   1512  CA  ALA   205      12.671  38.366 167.495  1.00 35.51           C  
ATOM   1513  C   ALA   205      11.446  39.095 168.071  1.00 35.05           C  
ATOM   1514  O   ALA   205      11.159  40.235 167.697  1.00 34.58           O  
ATOM   1515  CB  ALA   205      12.804  38.661 165.991  1.00 35.87           C  
ATOM   1516  N   GLY   206      10.724  38.440 168.978  1.00 35.87           N  
ATOM   1517  CA  GLY   206       9.545  39.052 169.571  1.00 34.61           C  
ATOM   1518  C   GLY   206       8.283  38.367 169.082  1.00 35.34           C  
ATOM   1519  O   GLY   206       7.853  38.570 167.954  1.00 34.47           O  
ATOM   1520  N   LEU   207       7.677  37.575 169.958  1.00 34.79           N  
ATOM   1521  CA  LEU   207       6.491  36.801 169.637  1.00 31.42           C  
ATOM   1522  C   LEU   207       5.192  37.467 170.024  1.00 30.81           C  
ATOM   1523  O   LEU   207       5.061  37.984 171.123  1.00 31.83           O  
ATOM   1524  CB  LEU   207       6.606  35.445 170.336  1.00 33.46           C  
ATOM   1525  CG  LEU   207       5.572  34.340 170.108  1.00 33.46           C  
ATOM   1526  CD1 LEU   207       5.830  33.688 168.753  1.00 37.83           C  
ATOM   1527  CD2 LEU   207       5.667  33.296 171.214  1.00 30.57           C  
ATOM   1528  N   THR   208       4.228  37.466 169.113  1.00 30.32           N  
ATOM   1529  CA  THR   208       2.928  38.023 169.439  1.00 28.64           C  
ATOM   1530  C   THR   208       1.915  36.888 169.395  1.00 29.95           C  
ATOM   1531  O   THR   208       1.733  36.237 168.356  1.00 29.31           O  
ATOM   1532  CB  THR   208       2.457  39.112 168.449  1.00 30.18           C  
ATOM   1533  OG1 THR   208       3.403  40.185 168.423  1.00 30.22           O  
ATOM   1534  CG2 THR   208       1.104  39.671 168.893  1.00 26.07           C  
ATOM   1535  N   VAL   209       1.290  36.608 170.530  1.00 29.09           N  
ATOM   1536  CA  VAL   209       0.264  35.589 170.541  1.00 29.88           C  
ATOM   1537  C   VAL   209      -1.036  36.292 170.927  1.00 30.32           C  
ATOM   1538  O   VAL   209      -1.116  37.033 171.909  1.00 32.33           O  
ATOM   1539  CB  VAL   209       0.622  34.361 171.478  1.00 29.48           C  
ATOM   1540  CG1 VAL   209       1.798  34.685 172.342  1.00 29.65           C  
ATOM   1541  CG2 VAL   209      -0.590  33.915 172.266  1.00 25.94           C  
ATOM   1542  N   VAL   210      -2.055  36.092 170.111  1.00 30.08           N  
ATOM   1543  CA  VAL   210      -3.324  36.706 170.372  1.00 30.95           C  
ATOM   1544  C   VAL   210      -4.362  35.599 170.439  1.00 31.19           C  
ATOM   1545  O   VAL   210      -4.602  34.856 169.474  1.00 31.19           O  
ATOM   1546  CB  VAL   210      -3.619  37.855 169.309  1.00 32.54           C  
ATOM   1547  CG1 VAL   210      -2.689  37.714 168.126  1.00 29.10           C  
ATOM   1548  CG2 VAL   210      -5.061  37.887 168.913  1.00 30.41           C  
ATOM   1549  N   THR   211      -4.970  35.474 171.610  1.00 31.26           N  
ATOM   1550  CA  THR   211      -5.956  34.445 171.782  1.00 33.16           C  
ATOM   1551  C   THR   211      -7.354  35.046 171.827  1.00 33.51           C  
ATOM   1552  O   THR   211      -7.553  36.165 172.310  1.00 34.80           O  
ATOM   1553  CB  THR   211      -5.607  33.534 173.019  1.00 33.51           C  
ATOM   1554  OG1 THR   211      -6.632  33.598 174.013  1.00 32.53           O  
ATOM   1555  CG2 THR   211      -4.269  33.914 173.600  1.00 26.11           C  
ATOM   1556  N   LYS   212      -8.314  34.304 171.283  1.00 33.14           N  
ATOM   1557  CA  LYS   212      -9.690  34.759 171.217  1.00 32.21           C  
ATOM   1558  C   LYS   212     -10.338  34.586 172.574  1.00 33.16           C  
ATOM   1559  O   LYS   212     -10.486  33.483 173.093  1.00 31.48           O  
ATOM   1560  CB  LYS   212     -10.451  33.983 170.126  1.00 30.67           C  
ATOM   1561  CG  LYS   212     -11.848  34.499 169.856  1.00 31.48           C  
ATOM   1562  CD  LYS   212     -12.519  33.780 168.685  1.00 33.82           C  
ATOM   1563  CE  LYS   212     -11.949  34.223 167.341  1.00 34.01           C  
ATOM   1564  NZ  LYS   212     -12.701  33.627 166.197  1.00 35.69           N  
ATOM   1565  N   ALA   213     -10.723  35.710 173.156  1.00 35.52           N  
ATOM   1566  CA  ALA   213     -11.339  35.718 174.472  1.00 36.71           C  
ATOM   1567  C   ALA   213     -12.641  34.939 174.553  1.00 38.53           C  
ATOM   1568  O   ALA   213     -13.372  34.834 173.570  1.00 39.30           O  
ATOM   1569  CB  ALA   213     -11.569  37.170 174.922  1.00 37.58           C  
END
