
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 ( 1598),  selected  104 , name 2e6n_A
# Molecule2: number of CA atoms  208 ( 1702),  selected  208 , name T0504.pdb
# PARAMETERS: 2e6n_A.T0504.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      L       3           -
LGA    G     4_A      Y       4           -
LGA    S     5_A      F       5           -
LGA    S     6_A      Q       6           -
LGA    G     7_A      G       7           -
LGA    G     8_A      D       8           -
LGA    T     9_A      L       9           -
LGA    Q    10_A      I      10           -
LGA    L    11_A      V      11           -
LGA    E    12_A      S      12           -
LGA    K    13_A      M      13           -
LGA    -       -      R      14           -
LGA    -       -      I      15           -
LGA    -       -      L      16           -
LGA    L    14_A      G      17           #
LGA    M    15_A      K      18          2.695
LGA    E    16_A      K      19          0.746
LGA    N    17_A      R      20           #
LGA    -       -      T      21           -
LGA    -       -      K      22           -
LGA    M    18_A      T      23           #
LGA    R    19_A      W      24          2.490
LGA    N    20_A      H      25          3.558
LGA    D    21_A      K      26          3.147
LGA    I    22_A      G      27           #
LGA    A    23_A      T      28           -
LGA    -       -      L      29           -
LGA    -       -      I      30           -
LGA    -       -      A      31           -
LGA    -       -      I      32           -
LGA    -       -      Q      33           -
LGA    -       -      T      34           -
LGA    -       -      V      35           -
LGA    -       -      G      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    -       -      K      39           -
LGA    -       -      K      40           -
LGA    -       -      Y      41           -
LGA    -       -      K      42           -
LGA    -       -      V      43           -
LGA    -       -      K      44           -
LGA    -       -      F      45           -
LGA    S    24_A      D      46          4.795
LGA    H    25_A      N      47           -
LGA    -       -      K      48           -
LGA    -       -      G      49           -
LGA    -       -      K      50           -
LGA    -       -      S      51           -
LGA    -       -      L      52           -
LGA    -       -      L      53           -
LGA    -       -      S      54           -
LGA    -       -      G      55           -
LGA    -       -      N      56           -
LGA    -       -      H      57           -
LGA    -       -      I      58           -
LGA    -       -      A      59           -
LGA    P    26_A      Y      60           #
LGA    P    27_A      D      61          2.450
LGA    V    28_A      Y      62          3.187
LGA    E    29_A      -       -           -
LGA    G    30_A      H      63          4.440
LGA    S    31_A      P      64          3.509
LGA    Y    32_A      P      65          4.480
LGA    A    33_A      A      66          2.760
LGA    -       -      D      67           -
LGA    -       -      K      68           -
LGA    P    34_A      L      69          2.833
LGA    R    35_A      Y      70          1.865
LGA    R    36_A      V      71          1.689
LGA    G    37_A      G      72          2.168
LGA    E    38_A      S      73          1.280
LGA    F    39_A      R      74          1.238
LGA    C    40_A      V      75          1.121
LGA    I    41_A      V      76          0.995
LGA    A    42_A      A      77          1.034
LGA    K    43_A      K      78          1.319
LGA    F    44_A      Y      79          1.282
LGA    V    45_A      K      80          2.401
LGA    D    46_A      D      81           -
LGA    -       -      G      82           -
LGA    -       -      N      83           -
LGA    -       -      Q      84           -
LGA    G    47_A      V      85          4.272
LGA    E    48_A      W      86          1.796
LGA    W    49_A      L      87          1.648
LGA    Y    50_A      Y      88          1.624
LGA    R    51_A      A      89          1.571
LGA    A    52_A      G      90          0.945
LGA    R    53_A      I      91          0.968
LGA    V    54_A      V      92          0.819
LGA    E    55_A      A      93          1.063
LGA    K    56_A      E      94          1.203
LGA    V    57_A      T      95          1.090
LGA    E    58_A      P      96          2.579
LGA    -       -      N      97           -
LGA    -       -      V      98           -
LGA    -       -      K      99           -
LGA    -       -      N     100           -
LGA    -       -      K     101           -
LGA    S    59_A      L     102          1.815
LGA    P    60_A      R     103          4.665
LGA    A    61_A      -       -           -
LGA    K    62_A      -       -           -
LGA    I    63_A      F     104          0.678
LGA    H    64_A      L     105          1.090
LGA    V    65_A      I     106          1.585
LGA    F    66_A      F     107          0.701
LGA    Y    67_A      F     108          1.125
LGA    I    68_A      D     109          2.486
LGA    D    69_A      -       -           -
LGA    Y    70_A      D     110          1.071
LGA    G    71_A      G     111          1.929
LGA    N    72_A      Y     112          2.103
LGA    R    73_A      A     113          1.451
LGA    E    74_A      S     114          1.298
LGA    V    75_A      Y     115          1.445
LGA    L    76_A      V     116          1.320
LGA    P    77_A      T     117          1.355
LGA    S    78_A      Q     118          1.335
LGA    T    79_A      S     119          1.430
LGA    R    80_A      E     120          1.100
LGA    L    81_A      L     121          0.735
LGA    G    82_A      Y     122          0.818
LGA    T    83_A      P     123          1.362
LGA    L    84_A      I     124          0.954
LGA    S    85_A      C     125          2.345
LGA    P    86_A      R     126          2.323
LGA    A    87_A      -       -           -
LGA    F    88_A      -       -           -
LGA    S    89_A      -       -           -
LGA    T    90_A      P     127           #
LGA    R    91_A      L     128          4.116
LGA    V    92_A      K     129           -
LGA    L    93_A      K     130           -
LGA    -       -      T     131           -
LGA    -       -      W     132           -
LGA    P    94_A      E     133          5.277
LGA    -       -      D     134           -
LGA    A    95_A      I     135          0.855
LGA    Q    96_A      E     136          1.934
LGA    A    97_A      D     137          3.552
LGA    T    98_A      I     138          5.283
LGA    E    99_A      S     139          4.266
LGA    Y   100_A      C     140          2.366
LGA    -       -      R     141           -
LGA    A   101_A      D     142          0.674
LGA    F   102_A      F     143          1.059
LGA    A   103_A      I     144          1.807
LGA    F   104_A      E     145          2.747
LGA    -       -      E     146           -
LGA    -       -      Y     147           -
LGA    -       -      V     148           -
LGA    -       -      T     149           -
LGA    -       -      A     150           -
LGA    -       -      Y     151           -
LGA    -       -      P     152           -
LGA    -       -      N     153           -
LGA    -       -      R     154           -
LGA    -       -      P     155           -
LGA    -       -      M     156           -
LGA    -       -      V     157           -
LGA    -       -      L     158           -
LGA    -       -      L     159           -
LGA    -       -      K     160           -
LGA    -       -      S     161           -
LGA    -       -      G     162           -
LGA    -       -      Q     163           -
LGA    -       -      L     164           -
LGA    -       -      I     165           -
LGA    -       -      K     166           -
LGA    -       -      T     167           -
LGA    -       -      E     168           -
LGA    -       -      W     169           -
LGA    -       -      E     170           -
LGA    -       -      G     171           -
LGA    -       -      T     172           -
LGA    -       -      W     173           -
LGA    -       -      W     174           -
LGA    -       -      K     175           -
LGA    -       -      S     176           -
LGA    -       -      R     177           -
LGA    -       -      V     178           -
LGA    -       -      E     179           -
LGA    -       -      E     180           -
LGA    -       -      V     181           -
LGA    -       -      D     182           -
LGA    -       -      G     183           -
LGA    -       -      S     184           -
LGA    -       -      L     185           -
LGA    -       -      V     186           -
LGA    -       -      R     187           -
LGA    -       -      I     188           -
LGA    -       -      L     189           -
LGA    -       -      F     190           -
LGA    -       -      L     191           -
LGA    -       -      D     192           -
LGA    -       -      D     193           -
LGA    -       -      K     194           -
LGA    -       -      R     195           -
LGA    -       -      C     196           -
LGA    -       -      E     197           -
LGA    -       -      W     198           -
LGA    -       -      I     199           -
LGA    -       -      Y     200           -
LGA    -       -      R     201           -
LGA    -       -      G     202           -
LGA    -       -      S     203           -
LGA    -       -      T     204           -
LGA    -       -      R     205           -
LGA    -       -      L     206           -
LGA    -       -      E     207           -
LGA    -       -      P     208           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104  208    5.0     73    2.38    13.70     27.087     2.941

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.971768 * X  +  -0.146905 * Y  +   0.184625 * Z  +  23.159571
  Y_new =   0.012911 * X  +   0.748228 * Y  +   0.663316 * Z  +  62.232826
  Z_new =  -0.235586 * X  +   0.646973 * Y  +  -0.725207 * Z  +   7.663602 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.413148   -0.728445  [ DEG:   138.2632    -41.7368 ]
  Theta =   0.237822    2.903771  [ DEG:    13.6262    166.3738 ]
  Phi   =   3.128307   -0.013285  [ DEG:   179.2388     -0.7612 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2e6n_A                                        
REMARK     2: T0504.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2e6n_A.T0504.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104  208   5.0   73   2.38   13.70  27.087
REMARK  ---------------------------------------------------------- 
MOLECULE 2e6n_A
HEADER    TRANSCRIPTION                           27-DEC-06   2E6N              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF STAPHYLOCOCCAL              
TITLE    2 NUCLEASE DOMAIN-CONTAINING PROTEIN 1                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: STAPHYLOCOCCAL NUCLEASE DOMAIN-CONTAINING                  
COMPND   3 PROTEIN 1;                                                           
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   6 SYNONYM: P100 CO-ACTIVATOR, 100 KDA COACTIVATOR, EBNA2               
COMPND   7 COACTIVATOR P100;                                                    
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SND1;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060731-01;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, YUDOR DOMAIN, STAPHYLOCOCCAL NUCLEASE DOMAIN-                    
KEYWDS   2 CONTAINING PROTEIN 1, P100 CO-ACTIVATOR, 100 KDA                     
KEYWDS   3 COACTIVATOR, EBNA2 COACTIVATOR P100, STRUCTURAL GENOMICS,            
KEYWDS   4 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   5 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   6 INITIATIVE, RSGI                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   03-JUL-07 2E6N    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF                    
JRNL        TITL 2 STAPHYLOCOCCAL NUCLEASE DOMAIN-CONTAINING PROTEIN 1          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2E6N A    8   104  UNP    Q7KZF4   SND1_HUMAN     704    800             
SEQRES   1 A  104  GLY SER SER GLY SER SER GLY GLY THR GLN LEU GLU LYS          
SEQRES   2 A  104  LEU MET GLU ASN MET ARG ASN ASP ILE ALA SER HIS PRO          
SEQRES   3 A  104  PRO VAL GLU GLY SER TYR ALA PRO ARG ARG GLY GLU PHE          
SEQRES   4 A  104  CYS ILE ALA LYS PHE VAL ASP GLY GLU TRP TYR ARG ALA          
SEQRES   5 A  104  ARG VAL GLU LYS VAL GLU SER PRO ALA LYS ILE HIS VAL          
SEQRES   6 A  104  PHE TYR ILE ASP TYR GLY ASN ARG GLU VAL LEU PRO SER          
SEQRES   7 A  104  THR ARG LEU GLY THR LEU SER PRO ALA PHE SER THR ARG          
SEQRES   8 A  104  VAL LEU PRO ALA GLN ALA THR GLU TYR ALA PHE ALA PHE          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      44.822  54.942  -3.633  1.00  0.00           N  
ATOM      2  CA  GLY A   1      44.415  54.978  -5.025  1.00  0.00           C  
ATOM      3  C   GLY A   1      44.295  53.593  -5.630  1.00  0.00           C  
ATOM      4  O   GLY A   1      44.807  52.620  -5.077  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      43.459  55.475  -5.097  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      45.145  55.542  -5.588  1.00  0.00           H  
ATOM      7  H1  GLY A   1      45.742  54.695  -3.401  1.00  0.00           H  
ATOM      8  N   SER A   2      43.615  53.504  -6.769  1.00  0.00           N  
ATOM      9  CA  SER A   2      43.424  52.226  -7.447  1.00  0.00           C  
ATOM     10  C   SER A   2      43.741  52.348  -8.934  1.00  0.00           C  
ATOM     11  O   SER A   2      43.274  53.267  -9.607  1.00  0.00           O  
ATOM     12  CB  SER A   2      41.987  51.735  -7.259  1.00  0.00           C  
ATOM     13  OG  SER A   2      41.055  52.682  -7.753  1.00  0.00           O  
ATOM     14  H   SER A   2      43.229  54.315  -7.160  1.00  0.00           H  
ATOM     15  HA  SER A   2      44.101  51.512  -7.003  1.00  0.00           H  
ATOM     16  HB2 SER A   2      41.855  50.806  -7.793  1.00  0.00           H  
ATOM     17  HB3 SER A   2      41.799  51.577  -6.207  1.00  0.00           H  
ATOM     18  HG  SER A   2      41.081  53.471  -7.207  1.00  0.00           H  
ATOM     19  N   SER A   3      44.540  51.414  -9.441  1.00  0.00           N  
ATOM     20  CA  SER A   3      44.924  51.417 -10.847  1.00  0.00           C  
ATOM     21  C   SER A   3      44.726  50.038 -11.468  1.00  0.00           C  
ATOM     22  O   SER A   3      45.250  49.041 -10.972  1.00  0.00           O  
ATOM     23  CB  SER A   3      46.384  51.853 -10.998  1.00  0.00           C  
ATOM     24  OG  SER A   3      46.673  52.211 -12.338  1.00  0.00           O  
ATOM     25  H   SER A   3      44.881  50.707  -8.853  1.00  0.00           H  
ATOM     26  HA  SER A   3      44.292  52.125 -11.361  1.00  0.00           H  
ATOM     27  HB2 SER A   3      46.570  52.704 -10.362  1.00  0.00           H  
ATOM     28  HB3 SER A   3      47.031  51.038 -10.707  1.00  0.00           H  
ATOM     29  HG  SER A   3      47.582  51.980 -12.542  1.00  0.00           H  
ATOM     30  N   GLY A   4      43.965  49.990 -12.557  1.00  0.00           N  
ATOM     31  CA  GLY A   4      43.710  48.728 -13.228  1.00  0.00           C  
ATOM     32  C   GLY A   4      42.412  48.086 -12.782  1.00  0.00           C  
ATOM     33  O   GLY A   4      42.243  47.763 -11.606  1.00  0.00           O  
ATOM     34  H   GLY A   4      43.574  50.817 -12.907  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      43.666  48.903 -14.293  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      44.525  48.051 -13.017  1.00  0.00           H  
ATOM     37  N   SER A   5      41.491  47.901 -13.722  1.00  0.00           N  
ATOM     38  CA  SER A   5      40.198  47.298 -13.418  1.00  0.00           C  
ATOM     39  C   SER A   5      39.560  47.965 -12.203  1.00  0.00           C  
ATOM     40  O   SER A   5      38.990  47.295 -11.342  1.00  0.00           O  
ATOM     41  CB  SER A   5      40.359  45.797 -13.166  1.00  0.00           C  
ATOM     42  OG  SER A   5      40.363  45.074 -14.384  1.00  0.00           O  
ATOM     43  H   SER A   5      41.684  48.180 -14.642  1.00  0.00           H  
ATOM     44  HA  SER A   5      39.556  47.444 -14.273  1.00  0.00           H  
ATOM     45  HB2 SER A   5      41.291  45.619 -12.652  1.00  0.00           H  
ATOM     46  HB3 SER A   5      39.539  45.449 -12.555  1.00  0.00           H  
ATOM     47  HG  SER A   5      41.223  44.670 -14.513  1.00  0.00           H  
ATOM     48  N   SER A   6      39.661  49.288 -12.141  1.00  0.00           N  
ATOM     49  CA  SER A   6      39.097  50.047 -11.031  1.00  0.00           C  
ATOM     50  C   SER A   6      37.643  50.416 -11.308  1.00  0.00           C  
ATOM     51  O   SER A   6      37.094  50.078 -12.355  1.00  0.00           O  
ATOM     52  CB  SER A   6      39.918  51.313 -10.782  1.00  0.00           C  
ATOM     53  OG  SER A   6      41.191  50.999 -10.244  1.00  0.00           O  
ATOM     54  H   SER A   6      40.127  49.766 -12.859  1.00  0.00           H  
ATOM     55  HA  SER A   6      39.137  49.424 -10.150  1.00  0.00           H  
ATOM     56  HB2 SER A   6      40.055  51.840 -11.714  1.00  0.00           H  
ATOM     57  HB3 SER A   6      39.392  51.949 -10.084  1.00  0.00           H  
ATOM     58  HG  SER A   6      41.660  51.810 -10.034  1.00  0.00           H  
ATOM     59  N   GLY A   7      37.025  51.112 -10.358  1.00  0.00           N  
ATOM     60  CA  GLY A   7      35.641  51.517 -10.517  1.00  0.00           C  
ATOM     61  C   GLY A   7      34.865  51.452  -9.217  1.00  0.00           C  
ATOM     62  O   GLY A   7      34.931  50.458  -8.495  1.00  0.00           O  
ATOM     63  H   GLY A   7      37.513  51.354  -9.544  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      35.613  52.530 -10.890  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      35.168  50.865 -11.238  1.00  0.00           H  
ATOM     66  N   GLY A   8      34.126  52.517  -8.915  1.00  0.00           N  
ATOM     67  CA  GLY A   8      33.347  52.556  -7.692  1.00  0.00           C  
ATOM     68  C   GLY A   8      31.960  53.127  -7.907  1.00  0.00           C  
ATOM     69  O   GLY A   8      31.480  53.207  -9.039  1.00  0.00           O  
ATOM     70  H   GLY A   8      34.112  53.281  -9.528  1.00  0.00           H  
ATOM     71  HA2 GLY A   8      33.256  51.553  -7.303  1.00  0.00           H  
ATOM     72  HA3 GLY A   8      33.866  53.166  -6.968  1.00  0.00           H  
ATOM     73  N   THR A   9      31.310  53.526  -6.818  1.00  0.00           N  
ATOM     74  CA  THR A   9      29.968  54.090  -6.892  1.00  0.00           C  
ATOM     75  C   THR A   9      30.006  55.613  -6.813  1.00  0.00           C  
ATOM     76  O   THR A   9      30.848  56.185  -6.121  1.00  0.00           O  
ATOM     77  CB  THR A   9      29.069  53.551  -5.764  1.00  0.00           C  
ATOM     78  OG1 THR A   9      29.277  52.144  -5.602  1.00  0.00           O  
ATOM     79  CG2 THR A   9      27.602  53.819  -6.067  1.00  0.00           C  
ATOM     80  H   THR A   9      31.744  53.438  -5.945  1.00  0.00           H  
ATOM     81  HA  THR A   9      29.536  53.800  -7.839  1.00  0.00           H  
ATOM     82  HB  THR A   9      29.330  54.054  -4.844  1.00  0.00           H  
ATOM     83  HG1 THR A   9      29.881  51.992  -4.871  1.00  0.00           H  
ATOM     84 HG21 THR A   9      27.156  54.353  -5.240  1.00  0.00           H  
ATOM     85 HG22 THR A   9      27.086  52.882  -6.209  1.00  0.00           H  
ATOM     86 HG23 THR A   9      27.523  54.415  -6.963  1.00  0.00           H  
ATOM     87  N   GLN A  10      29.090  56.261  -7.523  1.00  0.00           N  
ATOM     88  CA  GLN A  10      29.019  57.717  -7.531  1.00  0.00           C  
ATOM     89  C   GLN A  10      29.386  58.288  -6.166  1.00  0.00           C  
ATOM     90  O   GLN A  10      30.370  59.018  -6.030  1.00  0.00           O  
ATOM     91  CB  GLN A  10      27.617  58.180  -7.930  1.00  0.00           C  
ATOM     92  CG  GLN A  10      27.394  58.224  -9.433  1.00  0.00           C  
ATOM     93  CD  GLN A  10      26.982  56.880 -10.002  1.00  0.00           C  
ATOM     94  OE1 GLN A  10      27.713  55.895  -9.892  1.00  0.00           O  
ATOM     95  NE2 GLN A  10      25.804  56.832 -10.613  1.00  0.00           N  
ATOM     96  H   GLN A  10      28.445  55.748  -8.054  1.00  0.00           H  
ATOM     97  HA  GLN A  10      29.728  58.079  -8.261  1.00  0.00           H  
ATOM     98  HB2 GLN A  10      26.892  57.504  -7.500  1.00  0.00           H  
ATOM     99  HB3 GLN A  10      27.452  59.171  -7.534  1.00  0.00           H  
ATOM    100  HG2 GLN A  10      26.617  58.942  -9.648  1.00  0.00           H  
ATOM    101  HG3 GLN A  10      28.312  58.533  -9.910  1.00  0.00           H  
ATOM    102 HE21 GLN A  10      25.276  57.656 -10.664  1.00  0.00           H  
ATOM    103 HE22 GLN A  10      25.513  55.976 -10.991  1.00  0.00           H  
ATOM    104  N   LEU A  11      28.591  57.952  -5.156  1.00  0.00           N  
ATOM    105  CA  LEU A  11      28.832  58.430  -3.800  1.00  0.00           C  
ATOM    106  C   LEU A  11      30.240  58.072  -3.337  1.00  0.00           C  
ATOM    107  O   LEU A  11      30.949  58.904  -2.772  1.00  0.00           O  
ATOM    108  CB  LEU A  11      27.801  57.838  -2.837  1.00  0.00           C  
ATOM    109  CG  LEU A  11      27.739  58.470  -1.446  1.00  0.00           C  
ATOM    110  CD1 LEU A  11      27.149  59.869  -1.522  1.00  0.00           C  
ATOM    111  CD2 LEU A  11      26.929  57.598  -0.499  1.00  0.00           C  
ATOM    112  H   LEU A  11      27.824  57.367  -5.326  1.00  0.00           H  
ATOM    113  HA  LEU A  11      28.731  59.506  -3.805  1.00  0.00           H  
ATOM    114  HB2 LEU A  11      26.827  57.943  -3.291  1.00  0.00           H  
ATOM    115  HB3 LEU A  11      28.028  56.789  -2.716  1.00  0.00           H  
ATOM    116  HG  LEU A  11      28.743  58.552  -1.051  1.00  0.00           H  
ATOM    117 HD11 LEU A  11      27.872  60.543  -1.957  1.00  0.00           H  
ATOM    118 HD12 LEU A  11      26.896  60.207  -0.527  1.00  0.00           H  
ATOM    119 HD13 LEU A  11      26.258  59.852  -2.134  1.00  0.00           H  
ATOM    120 HD21 LEU A  11      27.155  56.558  -0.686  1.00  0.00           H  
ATOM    121 HD22 LEU A  11      25.875  57.771  -0.662  1.00  0.00           H  
ATOM    122 HD23 LEU A  11      27.181  57.844   0.521  1.00  0.00           H  
ATOM    123  N   GLU A  12      30.640  56.827  -3.584  1.00  0.00           N  
ATOM    124  CA  GLU A  12      31.964  56.360  -3.194  1.00  0.00           C  
ATOM    125  C   GLU A  12      33.051  57.270  -3.759  1.00  0.00           C  
ATOM    126  O   GLU A  12      34.094  57.471  -3.137  1.00  0.00           O  
ATOM    127  CB  GLU A  12      32.185  54.925  -3.675  1.00  0.00           C  
ATOM    128  CG  GLU A  12      31.761  53.871  -2.665  1.00  0.00           C  
ATOM    129  CD  GLU A  12      32.367  54.101  -1.294  1.00  0.00           C  
ATOM    130  OE1 GLU A  12      33.603  53.979  -1.165  1.00  0.00           O  
ATOM    131  OE2 GLU A  12      31.606  54.400  -0.351  1.00  0.00           O  
ATOM    132  H   GLU A  12      30.028  56.210  -4.038  1.00  0.00           H  
ATOM    133  HA  GLU A  12      32.019  56.380  -2.116  1.00  0.00           H  
ATOM    134  HB2 GLU A  12      31.620  54.771  -4.584  1.00  0.00           H  
ATOM    135  HB3 GLU A  12      33.235  54.787  -3.888  1.00  0.00           H  
ATOM    136  HG2 GLU A  12      30.685  53.892  -2.574  1.00  0.00           H  
ATOM    137  HG3 GLU A  12      32.072  52.901  -3.024  1.00  0.00           H  
ATOM    138  N   LYS A  13      32.800  57.817  -4.943  1.00  0.00           N  
ATOM    139  CA  LYS A  13      33.754  58.707  -5.594  1.00  0.00           C  
ATOM    140  C   LYS A  13      33.929  59.995  -4.795  1.00  0.00           C  
ATOM    141  O   LYS A  13      35.014  60.278  -4.284  1.00  0.00           O  
ATOM    142  CB  LYS A  13      33.289  59.035  -7.015  1.00  0.00           C  
ATOM    143  CG  LYS A  13      32.643  57.861  -7.729  1.00  0.00           C  
ATOM    144  CD  LYS A  13      32.697  58.029  -9.239  1.00  0.00           C  
ATOM    145  CE  LYS A  13      32.331  59.446  -9.655  1.00  0.00           C  
ATOM    146  NZ  LYS A  13      32.284  59.594 -11.136  1.00  0.00           N  
ATOM    147  H   LYS A  13      31.949  57.619  -5.390  1.00  0.00           H  
ATOM    148  HA  LYS A  13      34.703  58.196  -5.644  1.00  0.00           H  
ATOM    149  HB2 LYS A  13      32.573  59.841  -6.970  1.00  0.00           H  
ATOM    150  HB3 LYS A  13      34.143  59.356  -7.595  1.00  0.00           H  
ATOM    151  HG2 LYS A  13      33.166  56.955  -7.461  1.00  0.00           H  
ATOM    152  HG3 LYS A  13      31.610  57.788  -7.420  1.00  0.00           H  
ATOM    153  HD2 LYS A  13      33.697  57.812  -9.581  1.00  0.00           H  
ATOM    154  HD3 LYS A  13      32.000  57.339  -9.694  1.00  0.00           H  
ATOM    155  HE2 LYS A  13      31.363  59.689  -9.246  1.00  0.00           H  
ATOM    156  HE3 LYS A  13      33.071  60.125  -9.257  1.00  0.00           H  
ATOM    157  HZ1 LYS A  13      32.640  60.531 -11.413  1.00  0.00           H  
ATOM    158  HZ2 LYS A  13      31.305  59.494 -11.474  1.00  0.00           H  
ATOM    159  HZ3 LYS A  13      32.871  58.865 -11.588  1.00  0.00           H  
ATOM    160  N   LEU A  14      32.857  60.771  -4.690  1.00  0.00           N  
ATOM    161  CA  LEU A  14      32.891  62.030  -3.953  1.00  0.00           C  
ATOM    162  C   LEU A  14      33.367  61.807  -2.520  1.00  0.00           C  
ATOM    163  O   LEU A  14      34.317  62.443  -2.065  1.00  0.00           O  
ATOM    164  CB  LEU A  14      31.507  62.679  -3.947  1.00  0.00           C  
ATOM    165  CG  LEU A  14      31.422  64.073  -3.325  1.00  0.00           C  
ATOM    166  CD1 LEU A  14      31.659  65.143  -4.379  1.00  0.00           C  
ATOM    167  CD2 LEU A  14      30.072  64.275  -2.652  1.00  0.00           C  
ATOM    168  H   LEU A  14      32.021  60.493  -5.120  1.00  0.00           H  
ATOM    169  HA  LEU A  14      33.587  62.688  -4.452  1.00  0.00           H  
ATOM    170  HB2 LEU A  14      31.172  62.752  -4.970  1.00  0.00           H  
ATOM    171  HB3 LEU A  14      30.840  62.029  -3.398  1.00  0.00           H  
ATOM    172  HG  LEU A  14      32.192  64.172  -2.571  1.00  0.00           H  
ATOM    173 HD11 LEU A  14      31.461  66.116  -3.956  1.00  0.00           H  
ATOM    174 HD12 LEU A  14      31.001  64.973  -5.219  1.00  0.00           H  
ATOM    175 HD13 LEU A  14      32.686  65.098  -4.713  1.00  0.00           H  
ATOM    176 HD21 LEU A  14      29.565  63.326  -2.570  1.00  0.00           H  
ATOM    177 HD22 LEU A  14      29.474  64.954  -3.243  1.00  0.00           H  
ATOM    178 HD23 LEU A  14      30.221  64.691  -1.666  1.00  0.00           H  
ATOM    179  N   MET A  15      32.702  60.897  -1.815  1.00  0.00           N  
ATOM    180  CA  MET A  15      33.059  60.588  -0.436  1.00  0.00           C  
ATOM    181  C   MET A  15      34.529  60.192  -0.331  1.00  0.00           C  
ATOM    182  O   MET A  15      35.191  60.492   0.661  1.00  0.00           O  
ATOM    183  CB  MET A  15      32.176  59.462   0.102  1.00  0.00           C  
ATOM    184  CG  MET A  15      30.743  59.890   0.374  1.00  0.00           C  
ATOM    185  SD  MET A  15      30.628  61.161   1.648  1.00  0.00           S  
ATOM    186  CE  MET A  15      29.596  62.373   0.826  1.00  0.00           C  
ATOM    187  H   MET A  15      31.953  60.421  -2.233  1.00  0.00           H  
ATOM    188  HA  MET A  15      32.895  61.476   0.155  1.00  0.00           H  
ATOM    189  HB2 MET A  15      32.158  58.658  -0.619  1.00  0.00           H  
ATOM    190  HB3 MET A  15      32.600  59.096   1.026  1.00  0.00           H  
ATOM    191  HG2 MET A  15      30.317  60.278  -0.540  1.00  0.00           H  
ATOM    192  HG3 MET A  15      30.178  59.026   0.693  1.00  0.00           H  
ATOM    193  HE1 MET A  15      29.808  63.354   1.222  1.00  0.00           H  
ATOM    194  HE2 MET A  15      29.804  62.360  -0.235  1.00  0.00           H  
ATOM    195  HE3 MET A  15      28.556  62.133   0.993  1.00  0.00           H  
ATOM    196  N   GLU A  16      35.031  59.518  -1.361  1.00  0.00           N  
ATOM    197  CA  GLU A  16      36.421  59.080  -1.382  1.00  0.00           C  
ATOM    198  C   GLU A  16      37.368  60.277  -1.404  1.00  0.00           C  
ATOM    199  O   GLU A  16      38.436  60.249  -0.794  1.00  0.00           O  
ATOM    200  CB  GLU A  16      36.680  58.188  -2.597  1.00  0.00           C  
ATOM    201  CG  GLU A  16      38.153  57.902  -2.839  1.00  0.00           C  
ATOM    202  CD  GLU A  16      38.679  56.776  -1.970  1.00  0.00           C  
ATOM    203  OE1 GLU A  16      38.929  57.017  -0.771  1.00  0.00           O  
ATOM    204  OE2 GLU A  16      38.840  55.651  -2.490  1.00  0.00           O  
ATOM    205  H   GLU A  16      34.452  59.308  -2.123  1.00  0.00           H  
ATOM    206  HA  GLU A  16      36.603  58.510  -0.483  1.00  0.00           H  
ATOM    207  HB2 GLU A  16      36.171  57.247  -2.452  1.00  0.00           H  
ATOM    208  HB3 GLU A  16      36.281  58.673  -3.475  1.00  0.00           H  
ATOM    209  HG2 GLU A  16      38.288  57.629  -3.875  1.00  0.00           H  
ATOM    210  HG3 GLU A  16      38.721  58.795  -2.626  1.00  0.00           H  
ATOM    211  N   ASN A  17      36.967  61.328  -2.113  1.00  0.00           N  
ATOM    212  CA  ASN A  17      37.779  62.534  -2.218  1.00  0.00           C  
ATOM    213  C   ASN A  17      37.719  63.344  -0.926  1.00  0.00           C  
ATOM    214  O   ASN A  17      38.723  63.900  -0.483  1.00  0.00           O  
ATOM    215  CB  ASN A  17      37.307  63.391  -3.393  1.00  0.00           C  
ATOM    216  CG  ASN A  17      37.650  62.773  -4.735  1.00  0.00           C  
ATOM    217  OD1 ASN A  17      38.777  62.890  -5.215  1.00  0.00           O  
ATOM    218  ND2 ASN A  17      36.675  62.110  -5.347  1.00  0.00           N  
ATOM    219  H   ASN A  17      36.105  61.290  -2.578  1.00  0.00           H  
ATOM    220  HA  ASN A  17      38.801  62.232  -2.391  1.00  0.00           H  
ATOM    221  HB2 ASN A  17      36.235  63.510  -3.337  1.00  0.00           H  
ATOM    222  HB3 ASN A  17      37.776  64.363  -3.334  1.00  0.00           H  
ATOM    223 HD21 ASN A  17      35.802  62.058  -4.904  1.00  0.00           H  
ATOM    224 HD22 ASN A  17      36.869  61.699  -6.215  1.00  0.00           H  
ATOM    225  N   MET A  18      36.533  63.405  -0.328  1.00  0.00           N  
ATOM    226  CA  MET A  18      36.341  64.145   0.914  1.00  0.00           C  
ATOM    227  C   MET A  18      37.013  63.431   2.082  1.00  0.00           C  
ATOM    228  O   MET A  18      37.807  64.025   2.811  1.00  0.00           O  
ATOM    229  CB  MET A  18      34.850  64.325   1.201  1.00  0.00           C  
ATOM    230  CG  MET A  18      34.563  64.977   2.544  1.00  0.00           C  
ATOM    231  SD  MET A  18      32.806  64.995   2.947  1.00  0.00           S  
ATOM    232  CE  MET A  18      32.569  63.310   3.508  1.00  0.00           C  
ATOM    233  H   MET A  18      35.769  62.941  -0.730  1.00  0.00           H  
ATOM    234  HA  MET A  18      36.796  65.118   0.793  1.00  0.00           H  
ATOM    235  HB2 MET A  18      34.418  64.941   0.427  1.00  0.00           H  
ATOM    236  HB3 MET A  18      34.373  63.356   1.187  1.00  0.00           H  
ATOM    237  HG2 MET A  18      35.089  64.431   3.314  1.00  0.00           H  
ATOM    238  HG3 MET A  18      34.924  65.994   2.518  1.00  0.00           H  
ATOM    239  HE1 MET A  18      31.571  62.984   3.257  1.00  0.00           H  
ATOM    240  HE2 MET A  18      33.290  62.666   3.025  1.00  0.00           H  
ATOM    241  HE3 MET A  18      32.705  63.265   4.578  1.00  0.00           H  
ATOM    242  N   ARG A  19      36.690  62.153   2.253  1.00  0.00           N  
ATOM    243  CA  ARG A  19      37.262  61.359   3.334  1.00  0.00           C  
ATOM    244  C   ARG A  19      38.765  61.597   3.447  1.00  0.00           C  
ATOM    245  O   ARG A  19      39.336  61.512   4.534  1.00  0.00           O  
ATOM    246  CB  ARG A  19      36.987  59.871   3.103  1.00  0.00           C  
ATOM    247  CG  ARG A  19      35.556  59.461   3.410  1.00  0.00           C  
ATOM    248  CD  ARG A  19      35.319  57.991   3.101  1.00  0.00           C  
ATOM    249  NE  ARG A  19      35.130  57.756   1.673  1.00  0.00           N  
ATOM    250  CZ  ARG A  19      34.654  56.622   1.172  1.00  0.00           C  
ATOM    251  NH1 ARG A  19      34.320  55.625   1.980  1.00  0.00           N  
ATOM    252  NH2 ARG A  19      34.509  56.482  -0.140  1.00  0.00           N  
ATOM    253  H   ARG A  19      36.052  61.734   1.638  1.00  0.00           H  
ATOM    254  HA  ARG A  19      36.790  61.663   4.256  1.00  0.00           H  
ATOM    255  HB2 ARG A  19      37.191  59.636   2.068  1.00  0.00           H  
ATOM    256  HB3 ARG A  19      37.647  59.294   3.732  1.00  0.00           H  
ATOM    257  HG2 ARG A  19      35.360  59.634   4.458  1.00  0.00           H  
ATOM    258  HG3 ARG A  19      34.884  60.059   2.812  1.00  0.00           H  
ATOM    259  HD2 ARG A  19      36.174  57.424   3.440  1.00  0.00           H  
ATOM    260  HD3 ARG A  19      34.437  57.664   3.631  1.00  0.00           H  
ATOM    261  HE  ARG A  19      35.370  58.479   1.058  1.00  0.00           H  
ATOM    262 HH11 ARG A  19      34.427  55.726   2.969  1.00  0.00           H  
ATOM    263 HH12 ARG A  19      33.961  54.772   1.601  1.00  0.00           H  
ATOM    264 HH21 ARG A  19      34.760  57.231  -0.752  1.00  0.00           H  
ATOM    265 HH22 ARG A  19      34.151  55.628  -0.515  1.00  0.00           H  
ATOM    266  N   ASN A  20      39.399  61.897   2.319  1.00  0.00           N  
ATOM    267  CA  ASN A  20      40.835  62.146   2.291  1.00  0.00           C  
ATOM    268  C   ASN A  20      41.179  63.424   3.051  1.00  0.00           C  
ATOM    269  O   ASN A  20      41.754  63.376   4.140  1.00  0.00           O  
ATOM    270  CB  ASN A  20      41.329  62.250   0.848  1.00  0.00           C  
ATOM    271  CG  ASN A  20      41.577  60.890   0.223  1.00  0.00           C  
ATOM    272  OD1 ASN A  20      41.864  59.918   0.920  1.00  0.00           O  
ATOM    273  ND2 ASN A  20      41.467  60.818  -1.099  1.00  0.00           N  
ATOM    274  H   ASN A  20      38.889  61.950   1.484  1.00  0.00           H  
ATOM    275  HA  ASN A  20      41.326  61.313   2.772  1.00  0.00           H  
ATOM    276  HB2 ASN A  20      40.587  62.766   0.255  1.00  0.00           H  
ATOM    277  HB3 ASN A  20      42.252  62.809   0.828  1.00  0.00           H  
ATOM    278 HD21 ASN A  20      41.235  61.634  -1.590  1.00  0.00           H  
ATOM    279 HD22 ASN A  20      41.622  59.951  -1.529  1.00  0.00           H  
ATOM    280  N   ASP A  21      40.824  64.565   2.471  1.00  0.00           N  
ATOM    281  CA  ASP A  21      41.093  65.856   3.093  1.00  0.00           C  
ATOM    282  C   ASP A  21      40.411  65.956   4.454  1.00  0.00           C  
ATOM    283  O   ASP A  21      40.809  66.756   5.301  1.00  0.00           O  
ATOM    284  CB  ASP A  21      40.618  66.993   2.186  1.00  0.00           C  
ATOM    285  CG  ASP A  21      41.471  68.239   2.325  1.00  0.00           C  
ATOM    286  OD1 ASP A  21      42.539  68.302   1.682  1.00  0.00           O  
ATOM    287  OD2 ASP A  21      41.068  69.151   3.077  1.00  0.00           O  
ATOM    288  H   ASP A  21      40.369  64.538   1.604  1.00  0.00           H  
ATOM    289  HA  ASP A  21      42.161  65.941   3.232  1.00  0.00           H  
ATOM    290  HB2 ASP A  21      40.658  66.664   1.158  1.00  0.00           H  
ATOM    291  HB3 ASP A  21      39.599  67.244   2.440  1.00  0.00           H  
ATOM    292  N   ILE A  22      39.383  65.139   4.656  1.00  0.00           N  
ATOM    293  CA  ILE A  22      38.645  65.137   5.914  1.00  0.00           C  
ATOM    294  C   ILE A  22      39.360  64.297   6.967  1.00  0.00           C  
ATOM    295  O   ILE A  22      39.352  64.630   8.152  1.00  0.00           O  
ATOM    296  CB  ILE A  22      37.215  64.597   5.727  1.00  0.00           C  
ATOM    297  CG1 ILE A  22      36.263  65.734   5.348  1.00  0.00           C  
ATOM    298  CG2 ILE A  22      36.741  63.902   6.995  1.00  0.00           C  
ATOM    299  CD1 ILE A  22      36.046  66.736   6.461  1.00  0.00           C  
ATOM    300  H   ILE A  22      39.113  64.525   3.943  1.00  0.00           H  
ATOM    301  HA  ILE A  22      38.581  66.157   6.264  1.00  0.00           H  
ATOM    302  HB  ILE A  22      37.230  63.869   4.931  1.00  0.00           H  
ATOM    303 HG12 ILE A  22      36.665  66.264   4.499  1.00  0.00           H  
ATOM    304 HG13 ILE A  22      35.303  65.315   5.085  1.00  0.00           H  
ATOM    305 HG21 ILE A  22      36.811  64.587   7.827  1.00  0.00           H  
ATOM    306 HG22 ILE A  22      35.715  63.591   6.872  1.00  0.00           H  
ATOM    307 HG23 ILE A  22      37.360  63.039   7.186  1.00  0.00           H  
ATOM    308 HD11 ILE A  22      35.132  66.499   6.985  1.00  0.00           H  
ATOM    309 HD12 ILE A  22      36.877  66.698   7.148  1.00  0.00           H  
ATOM    310 HD13 ILE A  22      35.972  67.729   6.041  1.00  0.00           H  
ATOM    311  N   ALA A  23      39.979  63.206   6.527  1.00  0.00           N  
ATOM    312  CA  ALA A  23      40.702  62.321   7.431  1.00  0.00           C  
ATOM    313  C   ALA A  23      42.105  62.850   7.713  1.00  0.00           C  
ATOM    314  O   ALA A  23      42.724  62.491   8.715  1.00  0.00           O  
ATOM    315  CB  ALA A  23      40.774  60.916   6.850  1.00  0.00           C  
ATOM    316  H   ALA A  23      39.950  62.994   5.571  1.00  0.00           H  
ATOM    317  HA  ALA A  23      40.153  62.272   8.361  1.00  0.00           H  
ATOM    318  HB1 ALA A  23      41.256  60.952   5.884  1.00  0.00           H  
ATOM    319  HB2 ALA A  23      41.340  60.281   7.514  1.00  0.00           H  
ATOM    320  HB3 ALA A  23      39.775  60.523   6.738  1.00  0.00           H  
ATOM    321  N   SER A  24      42.599  63.705   6.825  1.00  0.00           N  
ATOM    322  CA  SER A  24      43.930  64.281   6.976  1.00  0.00           C  
ATOM    323  C   SER A  24      43.856  65.654   7.637  1.00  0.00           C  
ATOM    324  O   SER A  24      44.757  66.047   8.380  1.00  0.00           O  
ATOM    325  CB  SER A  24      44.618  64.394   5.615  1.00  0.00           C  
ATOM    326  OG  SER A  24      46.028  64.352   5.750  1.00  0.00           O  
ATOM    327  H   SER A  24      42.056  63.953   6.046  1.00  0.00           H  
ATOM    328  HA  SER A  24      44.507  63.621   7.607  1.00  0.00           H  
ATOM    329  HB2 SER A  24      44.305  63.574   4.986  1.00  0.00           H  
ATOM    330  HB3 SER A  24      44.340  65.330   5.151  1.00  0.00           H  
ATOM    331  HG  SER A  24      46.264  63.744   6.456  1.00  0.00           H  
ATOM    332  N   HIS A  25      42.778  66.380   7.360  1.00  0.00           N  
ATOM    333  CA  HIS A  25      42.586  67.710   7.928  1.00  0.00           C  
ATOM    334  C   HIS A  25      41.190  67.846   8.532  1.00  0.00           C  
ATOM    335  O   HIS A  25      40.431  68.757   8.203  1.00  0.00           O  
ATOM    336  CB  HIS A  25      42.796  68.780   6.856  1.00  0.00           C  
ATOM    337  CG  HIS A  25      44.224  69.206   6.708  1.00  0.00           C  
ATOM    338  ND1 HIS A  25      44.726  70.363   7.267  1.00  0.00           N  
ATOM    339  CD2 HIS A  25      45.260  68.622   6.061  1.00  0.00           C  
ATOM    340  CE1 HIS A  25      46.009  70.472   6.968  1.00  0.00           C  
ATOM    341  NE2 HIS A  25      46.356  69.429   6.238  1.00  0.00           N  
ATOM    342  H   HIS A  25      42.096  66.012   6.761  1.00  0.00           H  
ATOM    343  HA  HIS A  25      43.317  67.846   8.709  1.00  0.00           H  
ATOM    344  HB2 HIS A  25      42.464  68.396   5.903  1.00  0.00           H  
ATOM    345  HB3 HIS A  25      42.213  69.654   7.109  1.00  0.00           H  
ATOM    346  HD1 HIS A  25      44.218  71.007   7.802  1.00  0.00           H  
ATOM    347  HD2 HIS A  25      45.229  67.695   5.506  1.00  0.00           H  
ATOM    348  HE1 HIS A  25      46.661  71.277   7.271  1.00  0.00           H  
ATOM    349  N   PRO A  26      40.845  66.918   9.437  1.00  0.00           N  
ATOM    350  CA  PRO A  26      39.540  66.914  10.106  1.00  0.00           C  
ATOM    351  C   PRO A  26      39.164  68.286  10.654  1.00  0.00           C  
ATOM    352  O   PRO A  26      40.019  69.073  11.062  1.00  0.00           O  
ATOM    353  CB  PRO A  26      39.732  65.915  11.250  1.00  0.00           C  
ATOM    354  CG  PRO A  26      40.813  65.003  10.779  1.00  0.00           C  
ATOM    355  CD  PRO A  26      41.700  65.804   9.878  1.00  0.00           C  
ATOM    356  HA  PRO A  26      38.758  66.563   9.448  1.00  0.00           H  
ATOM    357  HB2 PRO A  26      40.023  66.443  12.148  1.00  0.00           H  
ATOM    358  HB3 PRO A  26      38.811  65.379  11.423  1.00  0.00           H  
ATOM    359  HG2 PRO A  26      41.379  64.639  11.624  1.00  0.00           H  
ATOM    360  HG3 PRO A  26      40.382  64.178  10.231  1.00  0.00           H  
ATOM    361  HD2 PRO A  26      42.556  66.168  10.426  1.00  0.00           H  
ATOM    362  HD3 PRO A  26      42.016  65.205   9.037  1.00  0.00           H  
ATOM    363  N   PRO A  27      37.856  68.582  10.665  1.00  0.00           N  
ATOM    364  CA  PRO A  27      37.338  69.859  11.162  1.00  0.00           C  
ATOM    365  C   PRO A  27      37.481  69.995  12.674  1.00  0.00           C  
ATOM    366  O   PRO A  27      37.737  69.015  13.374  1.00  0.00           O  
ATOM    367  CB  PRO A  27      35.860  69.820  10.767  1.00  0.00           C  
ATOM    368  CG  PRO A  27      35.530  68.370  10.675  1.00  0.00           C  
ATOM    369  CD  PRO A  27      36.783  67.691  10.194  1.00  0.00           C  
ATOM    370  HA  PRO A  27      37.819  70.698  10.680  1.00  0.00           H  
ATOM    371  HB2 PRO A  27      35.268  70.314  11.525  1.00  0.00           H  
ATOM    372  HB3 PRO A  27      35.724  70.317   9.818  1.00  0.00           H  
ATOM    373  HG2 PRO A  27      35.250  67.996  11.647  1.00  0.00           H  
ATOM    374  HG3 PRO A  27      34.728  68.221   9.968  1.00  0.00           H  
ATOM    375  HD2 PRO A  27      36.873  66.710  10.636  1.00  0.00           H  
ATOM    376  HD3 PRO A  27      36.785  67.622   9.116  1.00  0.00           H  
ATOM    377  N   VAL A  28      37.313  71.215  13.173  1.00  0.00           N  
ATOM    378  CA  VAL A  28      37.423  71.478  14.603  1.00  0.00           C  
ATOM    379  C   VAL A  28      36.117  71.156  15.322  1.00  0.00           C  
ATOM    380  O   VAL A  28      35.081  71.759  15.047  1.00  0.00           O  
ATOM    381  CB  VAL A  28      37.798  72.947  14.877  1.00  0.00           C  
ATOM    382  CG1 VAL A  28      37.791  73.230  16.372  1.00  0.00           C  
ATOM    383  CG2 VAL A  28      39.154  73.271  14.270  1.00  0.00           C  
ATOM    384  H   VAL A  28      37.110  71.956  12.565  1.00  0.00           H  
ATOM    385  HA  VAL A  28      38.205  70.849  15.000  1.00  0.00           H  
ATOM    386  HB  VAL A  28      37.057  73.579  14.411  1.00  0.00           H  
ATOM    387 HG11 VAL A  28      37.169  74.090  16.572  1.00  0.00           H  
ATOM    388 HG12 VAL A  28      37.403  72.372  16.899  1.00  0.00           H  
ATOM    389 HG13 VAL A  28      38.799  73.431  16.703  1.00  0.00           H  
ATOM    390 HG21 VAL A  28      39.382  72.553  13.497  1.00  0.00           H  
ATOM    391 HG22 VAL A  28      39.129  74.264  13.843  1.00  0.00           H  
ATOM    392 HG23 VAL A  28      39.912  73.229  15.038  1.00  0.00           H  
ATOM    393  N   GLU A  29      36.177  70.201  16.246  1.00  0.00           N  
ATOM    394  CA  GLU A  29      34.999  69.798  17.005  1.00  0.00           C  
ATOM    395  C   GLU A  29      34.458  70.964  17.830  1.00  0.00           C  
ATOM    396  O   GLU A  29      35.098  71.417  18.777  1.00  0.00           O  
ATOM    397  CB  GLU A  29      35.334  68.622  17.924  1.00  0.00           C  
ATOM    398  CG  GLU A  29      36.107  69.023  19.169  1.00  0.00           C  
ATOM    399  CD  GLU A  29      36.916  67.878  19.746  1.00  0.00           C  
ATOM    400  OE1 GLU A  29      37.798  67.356  19.032  1.00  0.00           O  
ATOM    401  OE2 GLU A  29      36.667  67.504  20.911  1.00  0.00           O  
ATOM    402  H   GLU A  29      37.032  69.757  16.420  1.00  0.00           H  
ATOM    403  HA  GLU A  29      34.240  69.489  16.301  1.00  0.00           H  
ATOM    404  HB2 GLU A  29      34.413  68.149  18.233  1.00  0.00           H  
ATOM    405  HB3 GLU A  29      35.926  67.907  17.371  1.00  0.00           H  
ATOM    406  HG2 GLU A  29      36.782  69.827  18.915  1.00  0.00           H  
ATOM    407  HG3 GLU A  29      35.408  69.364  19.917  1.00  0.00           H  
ATOM    408  N   GLY A  30      33.274  71.444  17.460  1.00  0.00           N  
ATOM    409  CA  GLY A  30      32.667  72.552  18.174  1.00  0.00           C  
ATOM    410  C   GLY A  30      32.987  73.893  17.543  1.00  0.00           C  
ATOM    411  O   GLY A  30      33.012  74.917  18.225  1.00  0.00           O  
ATOM    412  H   GLY A  30      32.810  71.042  16.695  1.00  0.00           H  
ATOM    413  HA2 GLY A  30      31.596  72.417  18.183  1.00  0.00           H  
ATOM    414  HA3 GLY A  30      33.030  72.550  19.191  1.00  0.00           H  
ATOM    415  N   SER A  31      33.235  73.887  16.237  1.00  0.00           N  
ATOM    416  CA  SER A  31      33.560  75.112  15.515  1.00  0.00           C  
ATOM    417  C   SER A  31      32.398  75.543  14.625  1.00  0.00           C  
ATOM    418  O   SER A  31      32.004  76.709  14.623  1.00  0.00           O  
ATOM    419  CB  SER A  31      34.818  74.911  14.668  1.00  0.00           C  
ATOM    420  OG  SER A  31      35.127  76.078  13.929  1.00  0.00           O  
ATOM    421  H   SER A  31      33.200  73.038  15.748  1.00  0.00           H  
ATOM    422  HA  SER A  31      33.747  75.887  16.244  1.00  0.00           H  
ATOM    423  HB2 SER A  31      35.650  74.677  15.315  1.00  0.00           H  
ATOM    424  HB3 SER A  31      34.658  74.094  13.978  1.00  0.00           H  
ATOM    425  HG  SER A  31      34.590  76.108  13.135  1.00  0.00           H  
ATOM    426  N   TYR A  32      31.855  74.594  13.871  1.00  0.00           N  
ATOM    427  CA  TYR A  32      30.739  74.875  12.975  1.00  0.00           C  
ATOM    428  C   TYR A  32      29.411  74.816  13.723  1.00  0.00           C  
ATOM    429  O   TYR A  32      29.118  73.839  14.413  1.00  0.00           O  
ATOM    430  CB  TYR A  32      30.729  73.880  11.814  1.00  0.00           C  
ATOM    431  CG  TYR A  32      29.397  73.796  11.102  1.00  0.00           C  
ATOM    432  CD1 TYR A  32      28.341  73.075  11.645  1.00  0.00           C  
ATOM    433  CD2 TYR A  32      29.196  74.438   9.886  1.00  0.00           C  
ATOM    434  CE1 TYR A  32      27.124  72.994  10.997  1.00  0.00           C  
ATOM    435  CE2 TYR A  32      27.981  74.363   9.232  1.00  0.00           C  
ATOM    436  CZ  TYR A  32      26.949  73.640   9.791  1.00  0.00           C  
ATOM    437  OH  TYR A  32      25.737  73.563   9.144  1.00  0.00           O  
ATOM    438  H   TYR A  32      32.213  73.683  13.917  1.00  0.00           H  
ATOM    439  HA  TYR A  32      30.874  75.872  12.582  1.00  0.00           H  
ATOM    440  HB2 TYR A  32      31.472  74.175  11.089  1.00  0.00           H  
ATOM    441  HB3 TYR A  32      30.968  72.896  12.189  1.00  0.00           H  
ATOM    442  HD1 TYR A  32      28.482  72.570  12.590  1.00  0.00           H  
ATOM    443  HD2 TYR A  32      30.006  75.004   9.449  1.00  0.00           H  
ATOM    444  HE1 TYR A  32      26.315  72.428  11.435  1.00  0.00           H  
ATOM    445  HE2 TYR A  32      27.843  74.869   8.288  1.00  0.00           H  
ATOM    446  HH  TYR A  32      25.026  73.608   9.789  1.00  0.00           H  
ATOM    447  N   ALA A  33      28.611  75.867  13.581  1.00  0.00           N  
ATOM    448  CA  ALA A  33      27.313  75.935  14.240  1.00  0.00           C  
ATOM    449  C   ALA A  33      26.198  75.484  13.303  1.00  0.00           C  
ATOM    450  O   ALA A  33      25.881  76.145  12.314  1.00  0.00           O  
ATOM    451  CB  ALA A  33      27.047  77.347  14.740  1.00  0.00           C  
ATOM    452  H   ALA A  33      28.902  76.615  13.018  1.00  0.00           H  
ATOM    453  HA  ALA A  33      27.339  75.275  15.096  1.00  0.00           H  
ATOM    454  HB1 ALA A  33      27.578  77.506  15.668  1.00  0.00           H  
ATOM    455  HB2 ALA A  33      27.389  78.059  14.003  1.00  0.00           H  
ATOM    456  HB3 ALA A  33      25.988  77.477  14.903  1.00  0.00           H  
ATOM    457  N   PRO A  34      25.588  74.333  13.618  1.00  0.00           N  
ATOM    458  CA  PRO A  34      24.499  73.767  12.816  1.00  0.00           C  
ATOM    459  C   PRO A  34      23.217  74.587  12.920  1.00  0.00           C  
ATOM    460  O   PRO A  34      22.731  74.860  14.017  1.00  0.00           O  
ATOM    461  CB  PRO A  34      24.295  72.377  13.424  1.00  0.00           C  
ATOM    462  CG  PRO A  34      24.785  72.500  14.825  1.00  0.00           C  
ATOM    463  CD  PRO A  34      25.915  73.491  14.782  1.00  0.00           C  
ATOM    464  HA  PRO A  34      24.780  73.671  11.777  1.00  0.00           H  
ATOM    465  HB2 PRO A  34      23.245  72.119  13.392  1.00  0.00           H  
ATOM    466  HB3 PRO A  34      24.866  71.650  12.867  1.00  0.00           H  
ATOM    467  HG2 PRO A  34      23.991  72.863  15.461  1.00  0.00           H  
ATOM    468  HG3 PRO A  34      25.140  71.542  15.174  1.00  0.00           H  
ATOM    469  HD2 PRO A  34      25.935  74.080  15.688  1.00  0.00           H  
ATOM    470  HD3 PRO A  34      26.857  72.984  14.638  1.00  0.00           H  
ATOM    471  N   ARG A  35      22.675  74.977  11.770  1.00  0.00           N  
ATOM    472  CA  ARG A  35      21.450  75.768  11.733  1.00  0.00           C  
ATOM    473  C   ARG A  35      20.342  75.017  11.002  1.00  0.00           C  
ATOM    474  O   ARG A  35      20.590  74.339  10.004  1.00  0.00           O  
ATOM    475  CB  ARG A  35      21.706  77.112  11.051  1.00  0.00           C  
ATOM    476  CG  ARG A  35      22.801  77.933  11.713  1.00  0.00           C  
ATOM    477  CD  ARG A  35      22.350  78.481  13.058  1.00  0.00           C  
ATOM    478  NE  ARG A  35      23.480  78.855  13.903  1.00  0.00           N  
ATOM    479  CZ  ARG A  35      23.354  79.260  15.162  1.00  0.00           C  
ATOM    480  NH1 ARG A  35      22.153  79.341  15.718  1.00  0.00           N  
ATOM    481  NH2 ARG A  35      24.431  79.584  15.867  1.00  0.00           N  
ATOM    482  H   ARG A  35      23.109  74.729  10.928  1.00  0.00           H  
ATOM    483  HA  ARG A  35      21.138  75.944  12.751  1.00  0.00           H  
ATOM    484  HB2 ARG A  35      21.992  76.934  10.024  1.00  0.00           H  
ATOM    485  HB3 ARG A  35      20.794  77.689  11.066  1.00  0.00           H  
ATOM    486  HG2 ARG A  35      23.667  77.305  11.865  1.00  0.00           H  
ATOM    487  HG3 ARG A  35      23.061  78.757  11.066  1.00  0.00           H  
ATOM    488  HD2 ARG A  35      21.736  79.353  12.888  1.00  0.00           H  
ATOM    489  HD3 ARG A  35      21.769  77.724  13.564  1.00  0.00           H  
ATOM    490  HE  ARG A  35      24.377  78.803  13.512  1.00  0.00           H  
ATOM    491 HH11 ARG A  35      21.341  79.097  15.190  1.00  0.00           H  
ATOM    492 HH12 ARG A  35      22.061  79.646  16.667  1.00  0.00           H  
ATOM    493 HH21 ARG A  35      25.338  79.524  15.451  1.00  0.00           H  
ATOM    494 HH22 ARG A  35      24.335  79.888  16.814  1.00  0.00           H  
ATOM    495  N   ARG A  36      19.118  75.141  11.505  1.00  0.00           N  
ATOM    496  CA  ARG A  36      17.972  74.473  10.901  1.00  0.00           C  
ATOM    497  C   ARG A  36      17.869  74.806   9.415  1.00  0.00           C  
ATOM    498  O   ARG A  36      17.479  75.911   9.041  1.00  0.00           O  
ATOM    499  CB  ARG A  36      16.682  74.880  11.615  1.00  0.00           C  
ATOM    500  CG  ARG A  36      15.441  74.187  11.076  1.00  0.00           C  
ATOM    501  CD  ARG A  36      14.379  74.029  12.152  1.00  0.00           C  
ATOM    502  NE  ARG A  36      13.058  73.772  11.585  1.00  0.00           N  
ATOM    503  CZ  ARG A  36      11.949  73.692  12.312  1.00  0.00           C  
ATOM    504  NH1 ARG A  36      12.001  73.847  13.627  1.00  0.00           N  
ATOM    505  NH2 ARG A  36      10.784  73.456  11.722  1.00  0.00           N  
ATOM    506  H   ARG A  36      18.983  75.694  12.302  1.00  0.00           H  
ATOM    507  HA  ARG A  36      18.112  73.408  11.010  1.00  0.00           H  
ATOM    508  HB2 ARG A  36      16.773  74.641  12.664  1.00  0.00           H  
ATOM    509  HB3 ARG A  36      16.546  75.946  11.508  1.00  0.00           H  
ATOM    510  HG2 ARG A  36      15.034  74.775  10.267  1.00  0.00           H  
ATOM    511  HG3 ARG A  36      15.719  73.209  10.710  1.00  0.00           H  
ATOM    512  HD2 ARG A  36      14.652  73.202  12.791  1.00  0.00           H  
ATOM    513  HD3 ARG A  36      14.339  74.936  12.737  1.00  0.00           H  
ATOM    514  HE  ARG A  36      12.997  73.654  10.615  1.00  0.00           H  
ATOM    515 HH11 ARG A  36      12.877  74.027  14.074  1.00  0.00           H  
ATOM    516 HH12 ARG A  36      11.165  73.787  14.172  1.00  0.00           H  
ATOM    517 HH21 ARG A  36      10.741  73.338  10.731  1.00  0.00           H  
ATOM    518 HH22 ARG A  36       9.950  73.395  12.269  1.00  0.00           H  
ATOM    519  N   GLY A  37      18.223  73.841   8.571  1.00  0.00           N  
ATOM    520  CA  GLY A  37      18.165  74.051   7.137  1.00  0.00           C  
ATOM    521  C   GLY A  37      19.524  74.364   6.541  1.00  0.00           C  
ATOM    522  O   GLY A  37      19.621  75.079   5.544  1.00  0.00           O  
ATOM    523  H   GLY A  37      18.527  72.979   8.926  1.00  0.00           H  
ATOM    524  HA2 GLY A  37      17.775  73.159   6.669  1.00  0.00           H  
ATOM    525  HA3 GLY A  37      17.497  74.875   6.932  1.00  0.00           H  
ATOM    526  N   GLU A  38      20.575  73.829   7.155  1.00  0.00           N  
ATOM    527  CA  GLU A  38      21.935  74.058   6.679  1.00  0.00           C  
ATOM    528  C   GLU A  38      22.660  72.736   6.447  1.00  0.00           C  
ATOM    529  O   GLU A  38      22.556  71.808   7.250  1.00  0.00           O  
ATOM    530  CB  GLU A  38      22.713  74.909   7.684  1.00  0.00           C  
ATOM    531  CG  GLU A  38      22.586  76.404   7.443  1.00  0.00           C  
ATOM    532  CD  GLU A  38      23.296  76.855   6.182  1.00  0.00           C  
ATOM    533  OE1 GLU A  38      24.538  76.982   6.213  1.00  0.00           O  
ATOM    534  OE2 GLU A  38      22.610  77.079   5.163  1.00  0.00           O  
ATOM    535  H   GLU A  38      20.433  73.268   7.946  1.00  0.00           H  
ATOM    536  HA  GLU A  38      21.872  74.591   5.742  1.00  0.00           H  
ATOM    537  HB2 GLU A  38      22.351  74.694   8.679  1.00  0.00           H  
ATOM    538  HB3 GLU A  38      23.758  74.645   7.628  1.00  0.00           H  
ATOM    539  HG2 GLU A  38      21.539  76.654   7.357  1.00  0.00           H  
ATOM    540  HG3 GLU A  38      23.012  76.930   8.286  1.00  0.00           H  
ATOM    541  N   PHE A  39      23.394  72.657   5.342  1.00  0.00           N  
ATOM    542  CA  PHE A  39      24.135  71.448   5.002  1.00  0.00           C  
ATOM    543  C   PHE A  39      25.498  71.436   5.688  1.00  0.00           C  
ATOM    544  O   PHE A  39      26.127  72.479   5.862  1.00  0.00           O  
ATOM    545  CB  PHE A  39      24.314  71.345   3.486  1.00  0.00           C  
ATOM    546  CG  PHE A  39      23.064  70.933   2.762  1.00  0.00           C  
ATOM    547  CD1 PHE A  39      22.637  69.615   2.783  1.00  0.00           C  
ATOM    548  CD2 PHE A  39      22.316  71.864   2.059  1.00  0.00           C  
ATOM    549  CE1 PHE A  39      21.488  69.234   2.116  1.00  0.00           C  
ATOM    550  CE2 PHE A  39      21.165  71.489   1.392  1.00  0.00           C  
ATOM    551  CZ  PHE A  39      20.751  70.172   1.422  1.00  0.00           C  
ATOM    552  H   PHE A  39      23.437  73.430   4.741  1.00  0.00           H  
ATOM    553  HA  PHE A  39      23.563  70.601   5.347  1.00  0.00           H  
ATOM    554  HB2 PHE A  39      24.619  72.305   3.099  1.00  0.00           H  
ATOM    555  HB3 PHE A  39      25.079  70.614   3.270  1.00  0.00           H  
ATOM    556  HD1 PHE A  39      23.211  68.880   3.328  1.00  0.00           H  
ATOM    557  HD2 PHE A  39      22.640  72.895   2.036  1.00  0.00           H  
ATOM    558  HE1 PHE A  39      21.165  68.204   2.142  1.00  0.00           H  
ATOM    559  HE2 PHE A  39      20.592  72.225   0.849  1.00  0.00           H  
ATOM    560  HZ  PHE A  39      19.852  69.877   0.900  1.00  0.00           H  
ATOM    561  N   CYS A  40      25.947  70.246   6.075  1.00  0.00           N  
ATOM    562  CA  CYS A  40      27.234  70.096   6.744  1.00  0.00           C  
ATOM    563  C   CYS A  40      27.640  68.628   6.818  1.00  0.00           C  
ATOM    564  O   CYS A  40      26.870  67.742   6.446  1.00  0.00           O  
ATOM    565  CB  CYS A  40      27.174  70.693   8.152  1.00  0.00           C  
ATOM    566  SG  CYS A  40      25.796  70.086   9.153  1.00  0.00           S  
ATOM    567  H   CYS A  40      25.399  69.451   5.909  1.00  0.00           H  
ATOM    568  HA  CYS A  40      27.971  70.632   6.167  1.00  0.00           H  
ATOM    569  HB2 CYS A  40      28.089  70.455   8.674  1.00  0.00           H  
ATOM    570  HB3 CYS A  40      27.079  71.766   8.075  1.00  0.00           H  
ATOM    571  HG  CYS A  40      25.393  68.935   8.637  1.00  0.00           H  
ATOM    572  N   ILE A  41      28.853  68.378   7.301  1.00  0.00           N  
ATOM    573  CA  ILE A  41      29.361  67.018   7.422  1.00  0.00           C  
ATOM    574  C   ILE A  41      29.217  66.503   8.851  1.00  0.00           C  
ATOM    575  O   ILE A  41      29.574  67.189   9.807  1.00  0.00           O  
ATOM    576  CB  ILE A  41      30.840  66.930   7.004  1.00  0.00           C  
ATOM    577  CG1 ILE A  41      31.694  67.860   7.868  1.00  0.00           C  
ATOM    578  CG2 ILE A  41      30.996  67.276   5.530  1.00  0.00           C  
ATOM    579  CD1 ILE A  41      33.175  67.767   7.574  1.00  0.00           C  
ATOM    580  H   ILE A  41      29.419  69.127   7.580  1.00  0.00           H  
ATOM    581  HA  ILE A  41      28.783  66.386   6.763  1.00  0.00           H  
ATOM    582  HB  ILE A  41      31.172  65.912   7.146  1.00  0.00           H  
ATOM    583 HG12 ILE A  41      31.386  68.880   7.701  1.00  0.00           H  
ATOM    584 HG13 ILE A  41      31.544  67.609   8.909  1.00  0.00           H  
ATOM    585 HG21 ILE A  41      31.428  68.262   5.436  1.00  0.00           H  
ATOM    586 HG22 ILE A  41      31.644  66.553   5.057  1.00  0.00           H  
ATOM    587 HG23 ILE A  41      30.028  67.260   5.053  1.00  0.00           H  
ATOM    588 HD11 ILE A  41      33.640  68.725   7.762  1.00  0.00           H  
ATOM    589 HD12 ILE A  41      33.623  67.019   8.211  1.00  0.00           H  
ATOM    590 HD13 ILE A  41      33.320  67.494   6.539  1.00  0.00           H  
ATOM    591  N   ALA A  42      28.692  65.290   8.986  1.00  0.00           N  
ATOM    592  CA  ALA A  42      28.504  64.681  10.297  1.00  0.00           C  
ATOM    593  C   ALA A  42      29.401  63.459  10.468  1.00  0.00           C  
ATOM    594  O   ALA A  42      29.622  62.700   9.524  1.00  0.00           O  
ATOM    595  CB  ALA A  42      27.045  64.299  10.498  1.00  0.00           C  
ATOM    596  H   ALA A  42      28.426  64.791   8.185  1.00  0.00           H  
ATOM    597  HA  ALA A  42      28.765  65.414  11.046  1.00  0.00           H  
ATOM    598  HB1 ALA A  42      26.836  64.225  11.554  1.00  0.00           H  
ATOM    599  HB2 ALA A  42      26.412  65.054  10.056  1.00  0.00           H  
ATOM    600  HB3 ALA A  42      26.854  63.347  10.025  1.00  0.00           H  
ATOM    601  N   LYS A  43      29.915  63.273  11.679  1.00  0.00           N  
ATOM    602  CA  LYS A  43      30.788  62.143  11.975  1.00  0.00           C  
ATOM    603  C   LYS A  43      29.977  60.936  12.434  1.00  0.00           C  
ATOM    604  O   LYS A  43      29.191  61.024  13.377  1.00  0.00           O  
ATOM    605  CB  LYS A  43      31.804  62.527  13.053  1.00  0.00           C  
ATOM    606  CG  LYS A  43      33.113  61.763  12.954  1.00  0.00           C  
ATOM    607  CD  LYS A  43      34.190  62.385  13.827  1.00  0.00           C  
ATOM    608  CE  LYS A  43      35.577  62.165  13.242  1.00  0.00           C  
ATOM    609  NZ  LYS A  43      36.634  62.210  14.290  1.00  0.00           N  
ATOM    610  H   LYS A  43      29.702  63.913  12.392  1.00  0.00           H  
ATOM    611  HA  LYS A  43      31.316  61.886  11.070  1.00  0.00           H  
ATOM    612  HB2 LYS A  43      32.020  63.582  12.969  1.00  0.00           H  
ATOM    613  HB3 LYS A  43      31.371  62.333  14.024  1.00  0.00           H  
ATOM    614  HG2 LYS A  43      32.950  60.744  13.275  1.00  0.00           H  
ATOM    615  HG3 LYS A  43      33.446  61.769  11.927  1.00  0.00           H  
ATOM    616  HD2 LYS A  43      34.008  63.446  13.904  1.00  0.00           H  
ATOM    617  HD3 LYS A  43      34.147  61.939  14.810  1.00  0.00           H  
ATOM    618  HE2 LYS A  43      35.601  61.200  12.760  1.00  0.00           H  
ATOM    619  HE3 LYS A  43      35.771  62.937  12.512  1.00  0.00           H  
ATOM    620  HZ1 LYS A  43      36.830  63.197  14.556  1.00  0.00           H  
ATOM    621  HZ2 LYS A  43      37.510  61.778  13.933  1.00  0.00           H  
ATOM    622  HZ3 LYS A  43      36.322  61.690  15.135  1.00  0.00           H  
ATOM    623  N   PHE A  44      30.172  59.807  11.760  1.00  0.00           N  
ATOM    624  CA  PHE A  44      29.460  58.581  12.098  1.00  0.00           C  
ATOM    625  C   PHE A  44      30.185  57.817  13.201  1.00  0.00           C  
ATOM    626  O   PHE A  44      31.391  57.975  13.392  1.00  0.00           O  
ATOM    627  CB  PHE A  44      29.312  57.694  10.860  1.00  0.00           C  
ATOM    628  CG  PHE A  44      28.265  56.626  11.008  1.00  0.00           C  
ATOM    629  CD1 PHE A  44      26.951  56.961  11.294  1.00  0.00           C  
ATOM    630  CD2 PHE A  44      28.597  55.289  10.864  1.00  0.00           C  
ATOM    631  CE1 PHE A  44      25.987  55.980  11.432  1.00  0.00           C  
ATOM    632  CE2 PHE A  44      27.636  54.304  11.001  1.00  0.00           C  
ATOM    633  CZ  PHE A  44      26.330  54.650  11.284  1.00  0.00           C  
ATOM    634  H   PHE A  44      30.812  59.799  11.016  1.00  0.00           H  
ATOM    635  HA  PHE A  44      28.478  58.856  12.452  1.00  0.00           H  
ATOM    636  HB2 PHE A  44      29.039  58.309  10.016  1.00  0.00           H  
ATOM    637  HB3 PHE A  44      30.255  57.210  10.658  1.00  0.00           H  
ATOM    638  HD1 PHE A  44      26.681  58.000  11.408  1.00  0.00           H  
ATOM    639  HD2 PHE A  44      29.618  55.016  10.641  1.00  0.00           H  
ATOM    640  HE1 PHE A  44      24.966  56.254  11.653  1.00  0.00           H  
ATOM    641  HE2 PHE A  44      27.908  53.265  10.885  1.00  0.00           H  
ATOM    642  HZ  PHE A  44      25.579  53.882  11.393  1.00  0.00           H  
ATOM    643  N   VAL A  45      29.441  56.987  13.925  1.00  0.00           N  
ATOM    644  CA  VAL A  45      30.013  56.196  15.009  1.00  0.00           C  
ATOM    645  C   VAL A  45      31.335  55.564  14.591  1.00  0.00           C  
ATOM    646  O   VAL A  45      32.180  55.255  15.431  1.00  0.00           O  
ATOM    647  CB  VAL A  45      29.047  55.087  15.465  1.00  0.00           C  
ATOM    648  CG1 VAL A  45      27.711  55.682  15.887  1.00  0.00           C  
ATOM    649  CG2 VAL A  45      28.856  54.060  14.359  1.00  0.00           C  
ATOM    650  H   VAL A  45      28.486  56.903  13.726  1.00  0.00           H  
ATOM    651  HA  VAL A  45      30.190  56.856  15.847  1.00  0.00           H  
ATOM    652  HB  VAL A  45      29.479  54.589  16.319  1.00  0.00           H  
ATOM    653 HG11 VAL A  45      27.099  54.910  16.330  1.00  0.00           H  
ATOM    654 HG12 VAL A  45      27.878  56.469  16.607  1.00  0.00           H  
ATOM    655 HG13 VAL A  45      27.208  56.086  15.021  1.00  0.00           H  
ATOM    656 HG21 VAL A  45      28.512  53.130  14.788  1.00  0.00           H  
ATOM    657 HG22 VAL A  45      28.124  54.422  13.652  1.00  0.00           H  
ATOM    658 HG23 VAL A  45      29.796  53.897  13.852  1.00  0.00           H  
ATOM    659  N   ASP A  46      31.507  55.373  13.288  1.00  0.00           N  
ATOM    660  CA  ASP A  46      32.727  54.778  12.755  1.00  0.00           C  
ATOM    661  C   ASP A  46      33.726  55.858  12.351  1.00  0.00           C  
ATOM    662  O   ASP A  46      34.542  55.656  11.453  1.00  0.00           O  
ATOM    663  CB  ASP A  46      32.405  53.887  11.555  1.00  0.00           C  
ATOM    664  CG  ASP A  46      31.896  52.521  11.968  1.00  0.00           C  
ATOM    665  OD1 ASP A  46      32.666  51.767  12.598  1.00  0.00           O  
ATOM    666  OD2 ASP A  46      30.727  52.204  11.661  1.00  0.00           O  
ATOM    667  H   ASP A  46      30.795  55.640  12.667  1.00  0.00           H  
ATOM    668  HA  ASP A  46      33.167  54.173  13.534  1.00  0.00           H  
ATOM    669  HB2 ASP A  46      31.646  54.366  10.953  1.00  0.00           H  
ATOM    670  HB3 ASP A  46      33.298  53.755  10.963  1.00  0.00           H  
ATOM    671  N   GLY A  47      33.655  57.005  13.020  1.00  0.00           N  
ATOM    672  CA  GLY A  47      34.556  58.099  12.713  1.00  0.00           C  
ATOM    673  C   GLY A  47      34.587  58.431  11.235  1.00  0.00           C  
ATOM    674  O   GLY A  47      35.608  58.872  10.712  1.00  0.00           O  
ATOM    675  H   GLY A  47      32.983  57.108  13.726  1.00  0.00           H  
ATOM    676  HA2 GLY A  47      34.242  58.975  13.262  1.00  0.00           H  
ATOM    677  HA3 GLY A  47      35.553  57.828  13.030  1.00  0.00           H  
ATOM    678  N   GLU A  48      33.461  58.215  10.559  1.00  0.00           N  
ATOM    679  CA  GLU A  48      33.365  58.492   9.131  1.00  0.00           C  
ATOM    680  C   GLU A  48      32.464  59.697   8.870  1.00  0.00           C  
ATOM    681  O   GLU A  48      31.303  59.717   9.279  1.00  0.00           O  
ATOM    682  CB  GLU A  48      32.827  57.268   8.387  1.00  0.00           C  
ATOM    683  CG  GLU A  48      33.834  56.138   8.266  1.00  0.00           C  
ATOM    684  CD  GLU A  48      34.699  56.256   7.025  1.00  0.00           C  
ATOM    685  OE1 GLU A  48      34.171  56.671   5.973  1.00  0.00           O  
ATOM    686  OE2 GLU A  48      35.902  55.933   7.108  1.00  0.00           O  
ATOM    687  H   GLU A  48      32.679  57.861  11.032  1.00  0.00           H  
ATOM    688  HA  GLU A  48      34.357  58.715   8.768  1.00  0.00           H  
ATOM    689  HB2 GLU A  48      31.959  56.896   8.911  1.00  0.00           H  
ATOM    690  HB3 GLU A  48      32.533  57.569   7.392  1.00  0.00           H  
ATOM    691  HG2 GLU A  48      34.476  56.150   9.134  1.00  0.00           H  
ATOM    692  HG3 GLU A  48      33.301  55.199   8.227  1.00  0.00           H  
ATOM    693  N   TRP A  49      33.008  60.697   8.187  1.00  0.00           N  
ATOM    694  CA  TRP A  49      32.255  61.906   7.872  1.00  0.00           C  
ATOM    695  C   TRP A  49      31.303  61.665   6.706  1.00  0.00           C  
ATOM    696  O   TRP A  49      31.644  60.973   5.747  1.00  0.00           O  
ATOM    697  CB  TRP A  49      33.209  63.054   7.538  1.00  0.00           C  
ATOM    698  CG  TRP A  49      33.971  63.556   8.727  1.00  0.00           C  
ATOM    699  CD1 TRP A  49      35.206  63.146   9.144  1.00  0.00           C  
ATOM    700  CD2 TRP A  49      33.549  64.564   9.653  1.00  0.00           C  
ATOM    701  NE1 TRP A  49      35.575  63.836  10.272  1.00  0.00           N  
ATOM    702  CE2 TRP A  49      34.577  64.713  10.605  1.00  0.00           C  
ATOM    703  CE3 TRP A  49      32.404  65.356   9.769  1.00  0.00           C  
ATOM    704  CZ2 TRP A  49      34.490  65.621  11.657  1.00  0.00           C  
ATOM    705  CZ3 TRP A  49      32.320  66.256  10.814  1.00  0.00           C  
ATOM    706  CH2 TRP A  49      33.358  66.383  11.747  1.00  0.00           C  
ATOM    707  H   TRP A  49      33.939  60.623   7.888  1.00  0.00           H  
ATOM    708  HA  TRP A  49      31.677  62.172   8.745  1.00  0.00           H  
ATOM    709  HB2 TRP A  49      33.924  62.717   6.803  1.00  0.00           H  
ATOM    710  HB3 TRP A  49      32.641  63.878   7.133  1.00  0.00           H  
ATOM    711  HD1 TRP A  49      35.792  62.386   8.649  1.00  0.00           H  
ATOM    712  HE1 TRP A  49      36.419  63.721  10.759  1.00  0.00           H  
ATOM    713  HE3 TRP A  49      31.593  65.273   9.060  1.00  0.00           H  
ATOM    714  HZ2 TRP A  49      35.283  65.730  12.383  1.00  0.00           H  
ATOM    715  HZ3 TRP A  49      31.441  66.876  10.921  1.00  0.00           H  
ATOM    716  HH2 TRP A  49      33.249  67.098  12.548  1.00  0.00           H  
ATOM    717  N   TYR A  50      30.108  62.239   6.795  1.00  0.00           N  
ATOM    718  CA  TYR A  50      29.106  62.085   5.748  1.00  0.00           C  
ATOM    719  C   TYR A  50      28.273  63.354   5.599  1.00  0.00           C  
ATOM    720  O   TYR A  50      28.114  64.120   6.550  1.00  0.00           O  
ATOM    721  CB  TYR A  50      28.195  60.896   6.057  1.00  0.00           C  
ATOM    722  CG  TYR A  50      28.922  59.572   6.109  1.00  0.00           C  
ATOM    723  CD1 TYR A  50      29.421  58.984   4.953  1.00  0.00           C  
ATOM    724  CD2 TYR A  50      29.113  58.909   7.315  1.00  0.00           C  
ATOM    725  CE1 TYR A  50      30.086  57.775   4.996  1.00  0.00           C  
ATOM    726  CE2 TYR A  50      29.778  57.699   7.368  1.00  0.00           C  
ATOM    727  CZ  TYR A  50      30.263  57.136   6.207  1.00  0.00           C  
ATOM    728  OH  TYR A  50      30.926  55.931   6.254  1.00  0.00           O  
ATOM    729  H   TYR A  50      29.895  62.779   7.585  1.00  0.00           H  
ATOM    730  HA  TYR A  50      29.624  61.897   4.818  1.00  0.00           H  
ATOM    731  HB2 TYR A  50      27.723  61.053   7.015  1.00  0.00           H  
ATOM    732  HB3 TYR A  50      27.433  60.827   5.294  1.00  0.00           H  
ATOM    733  HD1 TYR A  50      29.282  59.488   4.007  1.00  0.00           H  
ATOM    734  HD2 TYR A  50      28.732  59.353   8.224  1.00  0.00           H  
ATOM    735  HE1 TYR A  50      30.466  57.334   4.087  1.00  0.00           H  
ATOM    736  HE2 TYR A  50      29.916  57.198   8.315  1.00  0.00           H  
ATOM    737  HH  TYR A  50      30.333  55.253   6.586  1.00  0.00           H  
ATOM    738  N   ARG A  51      27.743  63.569   4.400  1.00  0.00           N  
ATOM    739  CA  ARG A  51      26.926  64.745   4.125  1.00  0.00           C  
ATOM    740  C   ARG A  51      25.558  64.624   4.790  1.00  0.00           C  
ATOM    741  O   ARG A  51      24.904  63.585   4.705  1.00  0.00           O  
ATOM    742  CB  ARG A  51      26.756  64.933   2.617  1.00  0.00           C  
ATOM    743  CG  ARG A  51      27.895  65.703   1.967  1.00  0.00           C  
ATOM    744  CD  ARG A  51      27.430  66.439   0.720  1.00  0.00           C  
ATOM    745  NE  ARG A  51      27.571  65.621  -0.482  1.00  0.00           N  
ATOM    746  CZ  ARG A  51      26.652  64.754  -0.894  1.00  0.00           C  
ATOM    747  NH1 ARG A  51      25.531  64.593  -0.204  1.00  0.00           N  
ATOM    748  NH2 ARG A  51      26.852  64.046  -1.997  1.00  0.00           N  
ATOM    749  H   ARG A  51      27.906  62.922   3.682  1.00  0.00           H  
ATOM    750  HA  ARG A  51      27.436  65.605   4.532  1.00  0.00           H  
ATOM    751  HB2 ARG A  51      26.695  63.962   2.149  1.00  0.00           H  
ATOM    752  HB3 ARG A  51      25.838  65.470   2.435  1.00  0.00           H  
ATOM    753  HG2 ARG A  51      28.280  66.424   2.673  1.00  0.00           H  
ATOM    754  HG3 ARG A  51      28.676  65.009   1.696  1.00  0.00           H  
ATOM    755  HD2 ARG A  51      26.391  66.705   0.841  1.00  0.00           H  
ATOM    756  HD3 ARG A  51      28.020  67.335   0.606  1.00  0.00           H  
ATOM    757  HE  ARG A  51      28.391  65.723  -1.007  1.00  0.00           H  
ATOM    758 HH11 ARG A  51      25.377  65.127   0.628  1.00  0.00           H  
ATOM    759 HH12 ARG A  51      24.840  63.941  -0.515  1.00  0.00           H  
ATOM    760 HH21 ARG A  51      27.696  64.164  -2.520  1.00  0.00           H  
ATOM    761 HH22 ARG A  51      26.161  63.395  -2.306  1.00  0.00           H  
ATOM    762  N   ALA A  52      25.132  65.694   5.455  1.00  0.00           N  
ATOM    763  CA  ALA A  52      23.842  65.709   6.133  1.00  0.00           C  
ATOM    764  C   ALA A  52      23.279  67.124   6.211  1.00  0.00           C  
ATOM    765  O   ALA A  52      24.026  68.102   6.192  1.00  0.00           O  
ATOM    766  CB  ALA A  52      23.973  65.114   7.527  1.00  0.00           C  
ATOM    767  H   ALA A  52      25.699  66.493   5.488  1.00  0.00           H  
ATOM    768  HA  ALA A  52      23.161  65.091   5.567  1.00  0.00           H  
ATOM    769  HB1 ALA A  52      23.707  64.067   7.497  1.00  0.00           H  
ATOM    770  HB2 ALA A  52      24.993  65.217   7.869  1.00  0.00           H  
ATOM    771  HB3 ALA A  52      23.311  65.634   8.204  1.00  0.00           H  
ATOM    772  N   ARG A  53      21.956  67.225   6.296  1.00  0.00           N  
ATOM    773  CA  ARG A  53      21.293  68.521   6.374  1.00  0.00           C  
ATOM    774  C   ARG A  53      20.600  68.697   7.722  1.00  0.00           C  
ATOM    775  O   ARG A  53      19.730  67.908   8.093  1.00  0.00           O  
ATOM    776  CB  ARG A  53      20.275  68.665   5.242  1.00  0.00           C  
ATOM    777  CG  ARG A  53      19.513  69.981   5.271  1.00  0.00           C  
ATOM    778  CD  ARG A  53      18.577  70.109   4.080  1.00  0.00           C  
ATOM    779  NE  ARG A  53      18.350  71.504   3.710  1.00  0.00           N  
ATOM    780  CZ  ARG A  53      17.468  71.887   2.794  1.00  0.00           C  
ATOM    781  NH1 ARG A  53      16.733  70.984   2.158  1.00  0.00           N  
ATOM    782  NH2 ARG A  53      17.320  73.175   2.512  1.00  0.00           N  
ATOM    783  H   ARG A  53      21.414  66.410   6.306  1.00  0.00           H  
ATOM    784  HA  ARG A  53      22.047  69.287   6.267  1.00  0.00           H  
ATOM    785  HB2 ARG A  53      20.791  68.595   4.296  1.00  0.00           H  
ATOM    786  HB3 ARG A  53      19.559  67.859   5.313  1.00  0.00           H  
ATOM    787  HG2 ARG A  53      18.931  70.028   6.180  1.00  0.00           H  
ATOM    788  HG3 ARG A  53      20.221  70.795   5.252  1.00  0.00           H  
ATOM    789  HD2 ARG A  53      19.012  69.590   3.240  1.00  0.00           H  
ATOM    790  HD3 ARG A  53      17.630  69.655   4.334  1.00  0.00           H  
ATOM    791  HE  ARG A  53      18.883  72.186   4.168  1.00  0.00           H  
ATOM    792 HH11 ARG A  53      16.842  70.013   2.369  1.00  0.00           H  
ATOM    793 HH12 ARG A  53      16.069  71.275   1.469  1.00  0.00           H  
ATOM    794 HH21 ARG A  53      17.872  73.857   2.988  1.00  0.00           H  
ATOM    795 HH22 ARG A  53      16.656  73.462   1.822  1.00  0.00           H  
ATOM    796  N   VAL A  54      20.992  69.736   8.452  1.00  0.00           N  
ATOM    797  CA  VAL A  54      20.409  70.016   9.759  1.00  0.00           C  
ATOM    798  C   VAL A  54      18.888  70.081   9.680  1.00  0.00           C  
ATOM    799  O   VAL A  54      18.329  70.950   9.013  1.00  0.00           O  
ATOM    800  CB  VAL A  54      20.939  71.342  10.338  1.00  0.00           C  
ATOM    801  CG1 VAL A  54      20.383  71.574  11.734  1.00  0.00           C  
ATOM    802  CG2 VAL A  54      22.460  71.345  10.353  1.00  0.00           C  
ATOM    803  H   VAL A  54      21.690  70.329   8.103  1.00  0.00           H  
ATOM    804  HA  VAL A  54      20.692  69.216  10.429  1.00  0.00           H  
ATOM    805  HB  VAL A  54      20.604  72.148   9.702  1.00  0.00           H  
ATOM    806 HG11 VAL A  54      21.194  71.792  12.413  1.00  0.00           H  
ATOM    807 HG12 VAL A  54      19.695  72.409  11.714  1.00  0.00           H  
ATOM    808 HG13 VAL A  54      19.863  70.688  12.068  1.00  0.00           H  
ATOM    809 HG21 VAL A  54      22.827  71.821   9.456  1.00  0.00           H  
ATOM    810 HG22 VAL A  54      22.810  71.890  11.219  1.00  0.00           H  
ATOM    811 HG23 VAL A  54      22.823  70.329  10.397  1.00  0.00           H  
ATOM    812  N   GLU A  55      18.225  69.154  10.365  1.00  0.00           N  
ATOM    813  CA  GLU A  55      16.768  69.107  10.371  1.00  0.00           C  
ATOM    814  C   GLU A  55      16.202  69.916  11.534  1.00  0.00           C  
ATOM    815  O   GLU A  55      15.254  70.685  11.368  1.00  0.00           O  
ATOM    816  CB  GLU A  55      16.283  67.657  10.460  1.00  0.00           C  
ATOM    817  CG  GLU A  55      16.755  66.787   9.308  1.00  0.00           C  
ATOM    818  CD  GLU A  55      16.110  65.414   9.313  1.00  0.00           C  
ATOM    819  OE1 GLU A  55      16.182  64.727  10.353  1.00  0.00           O  
ATOM    820  OE2 GLU A  55      15.531  65.027   8.275  1.00  0.00           O  
ATOM    821  H   GLU A  55      18.728  68.487  10.877  1.00  0.00           H  
ATOM    822  HA  GLU A  55      16.418  69.537   9.445  1.00  0.00           H  
ATOM    823  HB2 GLU A  55      16.643  67.226  11.381  1.00  0.00           H  
ATOM    824  HB3 GLU A  55      15.203  67.653  10.469  1.00  0.00           H  
ATOM    825  HG2 GLU A  55      16.512  67.278   8.378  1.00  0.00           H  
ATOM    826  HG3 GLU A  55      17.826  66.665   9.381  1.00  0.00           H  
ATOM    827  N   LYS A  56      16.789  69.738  12.712  1.00  0.00           N  
ATOM    828  CA  LYS A  56      16.346  70.452  13.904  1.00  0.00           C  
ATOM    829  C   LYS A  56      17.485  70.592  14.909  1.00  0.00           C  
ATOM    830  O   LYS A  56      18.061  69.598  15.353  1.00  0.00           O  
ATOM    831  CB  LYS A  56      15.168  69.720  14.552  1.00  0.00           C  
ATOM    832  CG  LYS A  56      15.102  69.890  16.060  1.00  0.00           C  
ATOM    833  CD  LYS A  56      13.769  69.417  16.616  1.00  0.00           C  
ATOM    834  CE  LYS A  56      13.501  70.003  17.995  1.00  0.00           C  
ATOM    835  NZ  LYS A  56      13.297  71.477  17.941  1.00  0.00           N  
ATOM    836  H   LYS A  56      17.541  69.112  12.782  1.00  0.00           H  
ATOM    837  HA  LYS A  56      16.025  71.436  13.602  1.00  0.00           H  
ATOM    838  HB2 LYS A  56      14.248  70.097  14.128  1.00  0.00           H  
ATOM    839  HB3 LYS A  56      15.249  68.665  14.332  1.00  0.00           H  
ATOM    840  HG2 LYS A  56      15.894  69.311  16.513  1.00  0.00           H  
ATOM    841  HG3 LYS A  56      15.233  70.935  16.302  1.00  0.00           H  
ATOM    842  HD2 LYS A  56      12.979  69.725  15.947  1.00  0.00           H  
ATOM    843  HD3 LYS A  56      13.781  68.339  16.690  1.00  0.00           H  
ATOM    844  HE2 LYS A  56      12.616  69.541  18.403  1.00  0.00           H  
ATOM    845  HE3 LYS A  56      14.346  69.789  18.633  1.00  0.00           H  
ATOM    846  HZ1 LYS A  56      14.098  71.931  17.453  1.00  0.00           H  
ATOM    847  HZ2 LYS A  56      13.229  71.864  18.903  1.00  0.00           H  
ATOM    848  HZ3 LYS A  56      12.422  71.699  17.426  1.00  0.00           H  
ATOM    849  N   VAL A  57      17.805  71.832  15.265  1.00  0.00           N  
ATOM    850  CA  VAL A  57      18.872  72.103  16.219  1.00  0.00           C  
ATOM    851  C   VAL A  57      18.317  72.298  17.626  1.00  0.00           C  
ATOM    852  O   VAL A  57      17.673  73.306  17.914  1.00  0.00           O  
ATOM    853  CB  VAL A  57      19.679  73.352  15.820  1.00  0.00           C  
ATOM    854  CG1 VAL A  57      20.784  73.622  16.830  1.00  0.00           C  
ATOM    855  CG2 VAL A  57      20.254  73.190  14.421  1.00  0.00           C  
ATOM    856  H   VAL A  57      17.309  72.584  14.876  1.00  0.00           H  
ATOM    857  HA  VAL A  57      19.541  71.253  16.222  1.00  0.00           H  
ATOM    858  HB  VAL A  57      19.012  74.201  15.815  1.00  0.00           H  
ATOM    859 HG11 VAL A  57      20.557  74.522  17.380  1.00  0.00           H  
ATOM    860 HG12 VAL A  57      20.856  72.788  17.515  1.00  0.00           H  
ATOM    861 HG13 VAL A  57      21.723  73.743  16.312  1.00  0.00           H  
ATOM    862 HG21 VAL A  57      20.124  74.110  13.870  1.00  0.00           H  
ATOM    863 HG22 VAL A  57      21.306  72.956  14.487  1.00  0.00           H  
ATOM    864 HG23 VAL A  57      19.739  72.389  13.910  1.00  0.00           H  
ATOM    865  N   GLU A  58      18.570  71.328  18.497  1.00  0.00           N  
ATOM    866  CA  GLU A  58      18.095  71.394  19.874  1.00  0.00           C  
ATOM    867  C   GLU A  58      19.103  72.116  20.763  1.00  0.00           C  
ATOM    868  O   GLU A  58      18.812  73.181  21.310  1.00  0.00           O  
ATOM    869  CB  GLU A  58      17.836  69.986  20.415  1.00  0.00           C  
ATOM    870  CG  GLU A  58      16.452  69.452  20.088  1.00  0.00           C  
ATOM    871  CD  GLU A  58      15.346  70.261  20.735  1.00  0.00           C  
ATOM    872  OE1 GLU A  58      15.059  71.373  20.245  1.00  0.00           O  
ATOM    873  OE2 GLU A  58      14.768  69.782  21.733  1.00  0.00           O  
ATOM    874  H   GLU A  58      19.089  70.548  18.207  1.00  0.00           H  
ATOM    875  HA  GLU A  58      17.167  71.947  19.878  1.00  0.00           H  
ATOM    876  HB2 GLU A  58      18.569  69.312  19.997  1.00  0.00           H  
ATOM    877  HB3 GLU A  58      17.947  70.002  21.490  1.00  0.00           H  
ATOM    878  HG2 GLU A  58      16.315  69.477  19.017  1.00  0.00           H  
ATOM    879  HG3 GLU A  58      16.383  68.432  20.434  1.00  0.00           H  
ATOM    880  N   SER A  59      20.286  71.529  20.904  1.00  0.00           N  
ATOM    881  CA  SER A  59      21.336  72.114  21.731  1.00  0.00           C  
ATOM    882  C   SER A  59      22.717  71.737  21.202  1.00  0.00           C  
ATOM    883  O   SER A  59      22.879  70.784  20.439  1.00  0.00           O  
ATOM    884  CB  SER A  59      21.189  71.651  23.181  1.00  0.00           C  
ATOM    885  OG  SER A  59      19.833  71.389  23.498  1.00  0.00           O  
ATOM    886  H   SER A  59      20.457  70.682  20.442  1.00  0.00           H  
ATOM    887  HA  SER A  59      21.230  73.188  21.692  1.00  0.00           H  
ATOM    888  HB2 SER A  59      21.761  70.748  23.328  1.00  0.00           H  
ATOM    889  HB3 SER A  59      21.559  72.422  23.842  1.00  0.00           H  
ATOM    890  HG  SER A  59      19.441  70.850  22.808  1.00  0.00           H  
ATOM    891  N   PRO A  60      23.737  72.502  21.617  1.00  0.00           N  
ATOM    892  CA  PRO A  60      25.123  72.269  21.199  1.00  0.00           C  
ATOM    893  C   PRO A  60      25.531  70.806  21.336  1.00  0.00           C  
ATOM    894  O   PRO A  60      26.524  70.372  20.753  1.00  0.00           O  
ATOM    895  CB  PRO A  60      25.935  73.143  22.158  1.00  0.00           C  
ATOM    896  CG  PRO A  60      25.000  74.229  22.564  1.00  0.00           C  
ATOM    897  CD  PRO A  60      23.618  73.654  22.526  1.00  0.00           C  
ATOM    898  HA  PRO A  60      25.291  72.595  20.182  1.00  0.00           H  
ATOM    899  HB2 PRO A  60      26.249  72.553  23.007  1.00  0.00           H  
ATOM    900  HB3 PRO A  60      26.799  73.537  21.646  1.00  0.00           H  
ATOM    901  HG2 PRO A  60      25.232  74.558  23.566  1.00  0.00           H  
ATOM    902  HG3 PRO A  60      25.072  75.054  21.870  1.00  0.00           H  
ATOM    903  HD2 PRO A  60      23.318  73.336  23.514  1.00  0.00           H  
ATOM    904  HD3 PRO A  60      22.921  74.381  22.136  1.00  0.00           H  
ATOM    905  N   ALA A  61      24.759  70.051  22.111  1.00  0.00           N  
ATOM    906  CA  ALA A  61      25.039  68.636  22.322  1.00  0.00           C  
ATOM    907  C   ALA A  61      24.064  67.761  21.542  1.00  0.00           C  
ATOM    908  O   ALA A  61      24.337  66.589  21.282  1.00  0.00           O  
ATOM    909  CB  ALA A  61      24.982  68.303  23.805  1.00  0.00           C  
ATOM    910  H   ALA A  61      23.981  70.455  22.549  1.00  0.00           H  
ATOM    911  HA  ALA A  61      26.042  68.439  21.973  1.00  0.00           H  
ATOM    912  HB1 ALA A  61      24.011  67.891  24.043  1.00  0.00           H  
ATOM    913  HB2 ALA A  61      25.747  67.580  24.042  1.00  0.00           H  
ATOM    914  HB3 ALA A  61      25.142  69.201  24.382  1.00  0.00           H  
ATOM    915  N   LYS A  62      22.925  68.337  21.172  1.00  0.00           N  
ATOM    916  CA  LYS A  62      21.908  67.609  20.422  1.00  0.00           C  
ATOM    917  C   LYS A  62      21.521  68.367  19.155  1.00  0.00           C  
ATOM    918  O   LYS A  62      20.966  69.464  19.222  1.00  0.00           O  
ATOM    919  CB  LYS A  62      20.669  67.381  21.290  1.00  0.00           C  
ATOM    920  CG  LYS A  62      20.931  66.507  22.504  1.00  0.00           C  
ATOM    921  CD  LYS A  62      19.679  65.759  22.931  1.00  0.00           C  
ATOM    922  CE  LYS A  62      20.022  64.450  23.627  1.00  0.00           C  
ATOM    923  NZ  LYS A  62      20.251  64.641  25.086  1.00  0.00           N  
ATOM    924  H   LYS A  62      22.765  69.275  21.409  1.00  0.00           H  
ATOM    925  HA  LYS A  62      22.322  66.653  20.142  1.00  0.00           H  
ATOM    926  HB2 LYS A  62      20.304  68.338  21.634  1.00  0.00           H  
ATOM    927  HB3 LYS A  62      19.905  66.909  20.689  1.00  0.00           H  
ATOM    928  HG2 LYS A  62      21.700  65.790  22.261  1.00  0.00           H  
ATOM    929  HG3 LYS A  62      21.262  67.131  23.322  1.00  0.00           H  
ATOM    930  HD2 LYS A  62      19.114  66.377  23.613  1.00  0.00           H  
ATOM    931  HD3 LYS A  62      19.080  65.545  22.056  1.00  0.00           H  
ATOM    932  HE2 LYS A  62      19.206  63.758  23.486  1.00  0.00           H  
ATOM    933  HE3 LYS A  62      20.918  64.045  23.181  1.00  0.00           H  
ATOM    934  HZ1 LYS A  62      20.911  63.919  25.441  1.00  0.00           H  
ATOM    935  HZ2 LYS A  62      19.352  64.557  25.602  1.00  0.00           H  
ATOM    936  HZ3 LYS A  62      20.654  65.583  25.265  1.00  0.00           H  
ATOM    937  N   ILE A  63      21.817  67.775  18.003  1.00  0.00           N  
ATOM    938  CA  ILE A  63      21.498  68.393  16.722  1.00  0.00           C  
ATOM    939  C   ILE A  63      20.873  67.383  15.765  1.00  0.00           C  
ATOM    940  O   ILE A  63      21.551  66.485  15.264  1.00  0.00           O  
ATOM    941  CB  ILE A  63      22.751  69.000  16.063  1.00  0.00           C  
ATOM    942  CG1 ILE A  63      23.642  69.656  17.119  1.00  0.00           C  
ATOM    943  CG2 ILE A  63      22.350  70.011  14.998  1.00  0.00           C  
ATOM    944  CD1 ILE A  63      23.149  71.014  17.568  1.00  0.00           C  
ATOM    945  H   ILE A  63      22.261  66.901  18.015  1.00  0.00           H  
ATOM    946  HA  ILE A  63      20.789  69.187  16.904  1.00  0.00           H  
ATOM    947  HB  ILE A  63      23.299  68.205  15.582  1.00  0.00           H  
ATOM    948 HG12 ILE A  63      23.691  69.018  17.987  1.00  0.00           H  
ATOM    949 HG13 ILE A  63      24.636  69.781  16.714  1.00  0.00           H  
ATOM    950 HG21 ILE A  63      21.729  70.774  15.443  1.00  0.00           H  
ATOM    951 HG22 ILE A  63      23.237  70.467  14.584  1.00  0.00           H  
ATOM    952 HG23 ILE A  63      21.802  69.511  14.215  1.00  0.00           H  
ATOM    953 HD11 ILE A  63      23.008  71.649  16.706  1.00  0.00           H  
ATOM    954 HD12 ILE A  63      22.213  70.902  18.093  1.00  0.00           H  
ATOM    955 HD13 ILE A  63      23.879  71.461  18.228  1.00  0.00           H  
ATOM    956  N   HIS A  64      19.577  67.537  15.515  1.00  0.00           N  
ATOM    957  CA  HIS A  64      18.859  66.641  14.616  1.00  0.00           C  
ATOM    958  C   HIS A  64      19.283  66.871  13.168  1.00  0.00           C  
ATOM    959  O   HIS A  64      19.115  67.963  12.627  1.00  0.00           O  
ATOM    960  CB  HIS A  64      17.351  66.843  14.756  1.00  0.00           C  
ATOM    961  CG  HIS A  64      16.850  66.663  16.156  1.00  0.00           C  
ATOM    962  ND1 HIS A  64      15.899  65.726  16.501  1.00  0.00           N  
ATOM    963  CD2 HIS A  64      17.175  67.306  17.302  1.00  0.00           C  
ATOM    964  CE1 HIS A  64      15.659  65.802  17.798  1.00  0.00           C  
ATOM    965  NE2 HIS A  64      16.421  66.753  18.307  1.00  0.00           N  
ATOM    966  H   HIS A  64      19.092  68.272  15.945  1.00  0.00           H  
ATOM    967  HA  HIS A  64      19.106  65.627  14.893  1.00  0.00           H  
ATOM    968  HB2 HIS A  64      17.098  67.844  14.440  1.00  0.00           H  
ATOM    969  HB3 HIS A  64      16.838  66.131  14.126  1.00  0.00           H  
ATOM    970  HD1 HIS A  64      15.462  65.101  15.885  1.00  0.00           H  
ATOM    971  HD2 HIS A  64      17.894  68.106  17.407  1.00  0.00           H  
ATOM    972  HE1 HIS A  64      14.960  65.191  18.348  1.00  0.00           H  
ATOM    973  N   VAL A  65      19.834  65.833  12.545  1.00  0.00           N  
ATOM    974  CA  VAL A  65      20.282  65.922  11.161  1.00  0.00           C  
ATOM    975  C   VAL A  65      19.839  64.701  10.361  1.00  0.00           C  
ATOM    976  O   VAL A  65      19.343  63.724  10.923  1.00  0.00           O  
ATOM    977  CB  VAL A  65      21.814  66.050  11.073  1.00  0.00           C  
ATOM    978  CG1 VAL A  65      22.252  67.467  11.416  1.00  0.00           C  
ATOM    979  CG2 VAL A  65      22.487  65.040  11.990  1.00  0.00           C  
ATOM    980  H   VAL A  65      19.941  64.988  13.030  1.00  0.00           H  
ATOM    981  HA  VAL A  65      19.841  66.806  10.723  1.00  0.00           H  
ATOM    982  HB  VAL A  65      22.116  65.841  10.058  1.00  0.00           H  
ATOM    983 HG11 VAL A  65      21.440  67.985  11.908  1.00  0.00           H  
ATOM    984 HG12 VAL A  65      23.108  67.431  12.072  1.00  0.00           H  
ATOM    985 HG13 VAL A  65      22.514  67.991  10.509  1.00  0.00           H  
ATOM    986 HG21 VAL A  65      22.119  65.168  12.997  1.00  0.00           H  
ATOM    987 HG22 VAL A  65      22.263  64.040  11.649  1.00  0.00           H  
ATOM    988 HG23 VAL A  65      23.555  65.194  11.975  1.00  0.00           H  
ATOM    989  N   PHE A  66      20.022  64.764   9.047  1.00  0.00           N  
ATOM    990  CA  PHE A  66      19.641  63.665   8.169  1.00  0.00           C  
ATOM    991  C   PHE A  66      20.694  63.443   7.086  1.00  0.00           C  
ATOM    992  O   PHE A  66      20.986  64.340   6.296  1.00  0.00           O  
ATOM    993  CB  PHE A  66      18.282  63.947   7.523  1.00  0.00           C  
ATOM    994  CG  PHE A  66      18.000  63.091   6.320  1.00  0.00           C  
ATOM    995  CD1 PHE A  66      17.366  61.867   6.458  1.00  0.00           C  
ATOM    996  CD2 PHE A  66      18.370  63.512   5.053  1.00  0.00           C  
ATOM    997  CE1 PHE A  66      17.106  61.078   5.352  1.00  0.00           C  
ATOM    998  CE2 PHE A  66      18.112  62.728   3.945  1.00  0.00           C  
ATOM    999  CZ  PHE A  66      17.480  61.510   4.094  1.00  0.00           C  
ATOM   1000  H   PHE A  66      20.422  65.571   8.658  1.00  0.00           H  
ATOM   1001  HA  PHE A  66      19.565  62.772   8.770  1.00  0.00           H  
ATOM   1002  HB2 PHE A  66      17.503  63.765   8.248  1.00  0.00           H  
ATOM   1003  HB3 PHE A  66      18.246  64.980   7.214  1.00  0.00           H  
ATOM   1004  HD1 PHE A  66      17.073  61.529   7.441  1.00  0.00           H  
ATOM   1005  HD2 PHE A  66      18.866  64.465   4.935  1.00  0.00           H  
ATOM   1006  HE1 PHE A  66      16.611  60.127   5.473  1.00  0.00           H  
ATOM   1007  HE2 PHE A  66      18.406  63.068   2.962  1.00  0.00           H  
ATOM   1008  HZ  PHE A  66      17.278  60.895   3.230  1.00  0.00           H  
ATOM   1009  N   TYR A  67      21.260  62.242   7.058  1.00  0.00           N  
ATOM   1010  CA  TYR A  67      22.283  61.902   6.076  1.00  0.00           C  
ATOM   1011  C   TYR A  67      21.697  61.874   4.667  1.00  0.00           C  
ATOM   1012  O   TYR A  67      20.892  61.003   4.334  1.00  0.00           O  
ATOM   1013  CB  TYR A  67      22.907  60.546   6.407  1.00  0.00           C  
ATOM   1014  CG  TYR A  67      23.716  60.546   7.684  1.00  0.00           C  
ATOM   1015  CD1 TYR A  67      23.092  60.568   8.926  1.00  0.00           C  
ATOM   1016  CD2 TYR A  67      25.105  60.525   7.650  1.00  0.00           C  
ATOM   1017  CE1 TYR A  67      23.827  60.571  10.096  1.00  0.00           C  
ATOM   1018  CE2 TYR A  67      25.848  60.527   8.815  1.00  0.00           C  
ATOM   1019  CZ  TYR A  67      25.205  60.550  10.034  1.00  0.00           C  
ATOM   1020  OH  TYR A  67      25.941  60.551  11.197  1.00  0.00           O  
ATOM   1021  H   TYR A  67      20.985  61.567   7.714  1.00  0.00           H  
ATOM   1022  HA  TYR A  67      23.050  62.660   6.120  1.00  0.00           H  
ATOM   1023  HB2 TYR A  67      22.122  59.812   6.514  1.00  0.00           H  
ATOM   1024  HB3 TYR A  67      23.561  60.251   5.600  1.00  0.00           H  
ATOM   1025  HD1 TYR A  67      22.012  60.584   8.970  1.00  0.00           H  
ATOM   1026  HD2 TYR A  67      25.606  60.508   6.693  1.00  0.00           H  
ATOM   1027  HE1 TYR A  67      23.323  60.588  11.051  1.00  0.00           H  
ATOM   1028  HE2 TYR A  67      26.927  60.510   8.768  1.00  0.00           H  
ATOM   1029  HH  TYR A  67      25.642  59.836  11.766  1.00  0.00           H  
ATOM   1030  N   ILE A  68      22.108  62.832   3.845  1.00  0.00           N  
ATOM   1031  CA  ILE A  68      21.626  62.918   2.471  1.00  0.00           C  
ATOM   1032  C   ILE A  68      22.422  61.997   1.552  1.00  0.00           C  
ATOM   1033  O   ILE A  68      22.395  62.148   0.330  1.00  0.00           O  
ATOM   1034  CB  ILE A  68      21.710  64.358   1.933  1.00  0.00           C  
ATOM   1035  CG1 ILE A  68      23.153  64.703   1.557  1.00  0.00           C  
ATOM   1036  CG2 ILE A  68      21.179  65.341   2.967  1.00  0.00           C  
ATOM   1037  CD1 ILE A  68      23.304  66.073   0.933  1.00  0.00           C  
ATOM   1038  H   ILE A  68      22.751  63.497   4.168  1.00  0.00           H  
ATOM   1039  HA  ILE A  68      20.590  62.611   2.462  1.00  0.00           H  
ATOM   1040  HB  ILE A  68      21.090  64.428   1.054  1.00  0.00           H  
ATOM   1041 HG12 ILE A  68      23.767  64.672   2.442  1.00  0.00           H  
ATOM   1042 HG13 ILE A  68      23.515  63.972   0.847  1.00  0.00           H  
ATOM   1043 HG21 ILE A  68      20.263  65.784   2.604  1.00  0.00           H  
ATOM   1044 HG22 ILE A  68      20.984  64.819   3.892  1.00  0.00           H  
ATOM   1045 HG23 ILE A  68      21.911  66.116   3.137  1.00  0.00           H  
ATOM   1046 HD11 ILE A  68      24.200  66.543   1.310  1.00  0.00           H  
ATOM   1047 HD12 ILE A  68      23.372  65.974  -0.139  1.00  0.00           H  
ATOM   1048 HD13 ILE A  68      22.447  66.680   1.186  1.00  0.00           H  
ATOM   1049  N   ASP A  69      23.128  61.042   2.146  1.00  0.00           N  
ATOM   1050  CA  ASP A  69      23.930  60.094   1.381  1.00  0.00           C  
ATOM   1051  C   ASP A  69      23.325  58.696   1.445  1.00  0.00           C  
ATOM   1052  O   ASP A  69      23.414  57.926   0.488  1.00  0.00           O  
ATOM   1053  CB  ASP A  69      25.366  60.067   1.906  1.00  0.00           C  
ATOM   1054  CG  ASP A  69      26.003  61.442   1.922  1.00  0.00           C  
ATOM   1055  OD1 ASP A  69      26.158  62.036   0.835  1.00  0.00           O  
ATOM   1056  OD2 ASP A  69      26.347  61.924   3.022  1.00  0.00           O  
ATOM   1057  H   ASP A  69      23.110  60.973   3.125  1.00  0.00           H  
ATOM   1058  HA  ASP A  69      23.939  60.422   0.353  1.00  0.00           H  
ATOM   1059  HB2 ASP A  69      25.366  59.679   2.915  1.00  0.00           H  
ATOM   1060  HB3 ASP A  69      25.960  59.422   1.277  1.00  0.00           H  
ATOM   1061  N   TYR A  70      22.711  58.373   2.578  1.00  0.00           N  
ATOM   1062  CA  TYR A  70      22.094  57.066   2.768  1.00  0.00           C  
ATOM   1063  C   TYR A  70      20.583  57.195   2.937  1.00  0.00           C  
ATOM   1064  O   TYR A  70      19.814  56.435   2.351  1.00  0.00           O  
ATOM   1065  CB  TYR A  70      22.697  56.367   3.988  1.00  0.00           C  
ATOM   1066  CG  TYR A  70      24.203  56.244   3.933  1.00  0.00           C  
ATOM   1067  CD1 TYR A  70      25.015  57.367   4.038  1.00  0.00           C  
ATOM   1068  CD2 TYR A  70      24.814  55.006   3.776  1.00  0.00           C  
ATOM   1069  CE1 TYR A  70      26.391  57.259   3.988  1.00  0.00           C  
ATOM   1070  CE2 TYR A  70      26.189  54.889   3.727  1.00  0.00           C  
ATOM   1071  CZ  TYR A  70      26.974  56.019   3.832  1.00  0.00           C  
ATOM   1072  OH  TYR A  70      28.345  55.908   3.783  1.00  0.00           O  
ATOM   1073  H   TYR A  70      22.672  59.029   3.305  1.00  0.00           H  
ATOM   1074  HA  TYR A  70      22.297  56.472   1.888  1.00  0.00           H  
ATOM   1075  HB2 TYR A  70      22.442  56.924   4.876  1.00  0.00           H  
ATOM   1076  HB3 TYR A  70      22.285  55.371   4.063  1.00  0.00           H  
ATOM   1077  HD1 TYR A  70      24.556  58.337   4.162  1.00  0.00           H  
ATOM   1078  HD2 TYR A  70      24.196  54.123   3.694  1.00  0.00           H  
ATOM   1079  HE1 TYR A  70      27.006  58.143   4.072  1.00  0.00           H  
ATOM   1080  HE2 TYR A  70      26.645  53.918   3.604  1.00  0.00           H  
ATOM   1081  HH  TYR A  70      28.715  56.691   3.369  1.00  0.00           H  
ATOM   1082  N   GLY A  71      20.165  58.167   3.742  1.00  0.00           N  
ATOM   1083  CA  GLY A  71      18.749  58.380   3.975  1.00  0.00           C  
ATOM   1084  C   GLY A  71      18.334  58.028   5.389  1.00  0.00           C  
ATOM   1085  O   GLY A  71      17.284  57.422   5.602  1.00  0.00           O  
ATOM   1086  H   GLY A  71      20.825  58.743   4.183  1.00  0.00           H  
ATOM   1087  HA2 GLY A  71      18.518  59.419   3.791  1.00  0.00           H  
ATOM   1088  HA3 GLY A  71      18.186  57.769   3.284  1.00  0.00           H  
ATOM   1089  N   ASN A  72      19.161  58.404   6.359  1.00  0.00           N  
ATOM   1090  CA  ASN A  72      18.875  58.121   7.761  1.00  0.00           C  
ATOM   1091  C   ASN A  72      18.959  59.392   8.600  1.00  0.00           C  
ATOM   1092  O   ASN A  72      19.423  60.430   8.129  1.00  0.00           O  
ATOM   1093  CB  ASN A  72      19.851  57.074   8.301  1.00  0.00           C  
ATOM   1094  CG  ASN A  72      19.238  56.223   9.396  1.00  0.00           C  
ATOM   1095  OD1 ASN A  72      18.335  55.426   9.145  1.00  0.00           O  
ATOM   1096  ND2 ASN A  72      19.729  56.389  10.619  1.00  0.00           N  
ATOM   1097  H   ASN A  72      19.984  58.884   6.126  1.00  0.00           H  
ATOM   1098  HA  ASN A  72      17.871  57.729   7.821  1.00  0.00           H  
ATOM   1099  HB2 ASN A  72      20.155  56.424   7.494  1.00  0.00           H  
ATOM   1100  HB3 ASN A  72      20.720  57.574   8.702  1.00  0.00           H  
ATOM   1101 HD21 ASN A  72      20.448  57.043  10.744  1.00  0.00           H  
ATOM   1102 HD22 ASN A  72      19.351  55.852  11.346  1.00  0.00           H  
ATOM   1103  N   ARG A  73      18.507  59.303   9.847  1.00  0.00           N  
ATOM   1104  CA  ARG A  73      18.530  60.446  10.752  1.00  0.00           C  
ATOM   1105  C   ARG A  73      19.211  60.082  12.069  1.00  0.00           C  
ATOM   1106  O   ARG A  73      19.030  58.982  12.588  1.00  0.00           O  
ATOM   1107  CB  ARG A  73      17.107  60.940  11.020  1.00  0.00           C  
ATOM   1108  CG  ARG A  73      16.232  60.978   9.778  1.00  0.00           C  
ATOM   1109  CD  ARG A  73      14.771  60.728  10.119  1.00  0.00           C  
ATOM   1110  NE  ARG A  73      14.512  59.322  10.421  1.00  0.00           N  
ATOM   1111  CZ  ARG A  73      13.293  58.810  10.551  1.00  0.00           C  
ATOM   1112  NH1 ARG A  73      12.227  59.585  10.409  1.00  0.00           N  
ATOM   1113  NH2 ARG A  73      13.140  57.521  10.827  1.00  0.00           N  
ATOM   1114  H   ARG A  73      18.148  58.448  10.165  1.00  0.00           H  
ATOM   1115  HA  ARG A  73      19.092  61.235  10.276  1.00  0.00           H  
ATOM   1116  HB2 ARG A  73      16.642  60.285  11.742  1.00  0.00           H  
ATOM   1117  HB3 ARG A  73      17.157  61.937  11.430  1.00  0.00           H  
ATOM   1118  HG2 ARG A  73      16.320  61.950   9.317  1.00  0.00           H  
ATOM   1119  HG3 ARG A  73      16.568  60.218   9.089  1.00  0.00           H  
ATOM   1120  HD2 ARG A  73      14.508  61.324  10.980  1.00  0.00           H  
ATOM   1121  HD3 ARG A  73      14.163  61.024   9.277  1.00  0.00           H  
ATOM   1122  HE  ARG A  73      15.287  58.731  10.530  1.00  0.00           H  
ATOM   1123 HH11 ARG A  73      12.341  60.556  10.202  1.00  0.00           H  
ATOM   1124 HH12 ARG A  73      11.311  59.197  10.507  1.00  0.00           H  
ATOM   1125 HH21 ARG A  73      13.941  56.934  10.935  1.00  0.00           H  
ATOM   1126 HH22 ARG A  73      12.223  57.137  10.925  1.00  0.00           H  
ATOM   1127  N   GLU A  74      19.994  61.015  12.601  1.00  0.00           N  
ATOM   1128  CA  GLU A  74      20.702  60.791  13.856  1.00  0.00           C  
ATOM   1129  C   GLU A  74      20.951  62.110  14.583  1.00  0.00           C  
ATOM   1130  O   GLU A  74      21.389  63.091  13.981  1.00  0.00           O  
ATOM   1131  CB  GLU A  74      22.032  60.080  13.597  1.00  0.00           C  
ATOM   1132  CG  GLU A  74      22.739  59.629  14.865  1.00  0.00           C  
ATOM   1133  CD  GLU A  74      22.201  58.314  15.395  1.00  0.00           C  
ATOM   1134  OE1 GLU A  74      22.643  57.254  14.904  1.00  0.00           O  
ATOM   1135  OE2 GLU A  74      21.342  58.346  16.300  1.00  0.00           O  
ATOM   1136  H   GLU A  74      20.098  61.873  12.139  1.00  0.00           H  
ATOM   1137  HA  GLU A  74      20.084  60.163  14.478  1.00  0.00           H  
ATOM   1138  HB2 GLU A  74      21.848  59.211  12.983  1.00  0.00           H  
ATOM   1139  HB3 GLU A  74      22.688  60.754  13.065  1.00  0.00           H  
ATOM   1140  HG2 GLU A  74      23.791  59.512  14.653  1.00  0.00           H  
ATOM   1141  HG3 GLU A  74      22.607  60.388  15.623  1.00  0.00           H  
ATOM   1142  N   VAL A  75      20.667  62.126  15.882  1.00  0.00           N  
ATOM   1143  CA  VAL A  75      20.860  63.322  16.692  1.00  0.00           C  
ATOM   1144  C   VAL A  75      22.286  63.402  17.224  1.00  0.00           C  
ATOM   1145  O   VAL A  75      22.619  62.780  18.233  1.00  0.00           O  
ATOM   1146  CB  VAL A  75      19.877  63.362  17.877  1.00  0.00           C  
ATOM   1147  CG1 VAL A  75      20.105  64.610  18.718  1.00  0.00           C  
ATOM   1148  CG2 VAL A  75      18.441  63.298  17.380  1.00  0.00           C  
ATOM   1149  H   VAL A  75      20.320  61.313  16.305  1.00  0.00           H  
ATOM   1150  HA  VAL A  75      20.671  64.183  16.066  1.00  0.00           H  
ATOM   1151  HB  VAL A  75      20.060  62.497  18.498  1.00  0.00           H  
ATOM   1152 HG11 VAL A  75      19.680  64.463  19.700  1.00  0.00           H  
ATOM   1153 HG12 VAL A  75      21.165  64.795  18.808  1.00  0.00           H  
ATOM   1154 HG13 VAL A  75      19.630  65.455  18.243  1.00  0.00           H  
ATOM   1155 HG21 VAL A  75      18.432  62.990  16.346  1.00  0.00           H  
ATOM   1156 HG22 VAL A  75      17.886  62.585  17.974  1.00  0.00           H  
ATOM   1157 HG23 VAL A  75      17.985  64.273  17.471  1.00  0.00           H  
ATOM   1158  N   LEU A  76      23.125  64.172  16.539  1.00  0.00           N  
ATOM   1159  CA  LEU A  76      24.518  64.334  16.944  1.00  0.00           C  
ATOM   1160  C   LEU A  76      24.791  65.765  17.395  1.00  0.00           C  
ATOM   1161  O   LEU A  76      24.137  66.714  16.960  1.00  0.00           O  
ATOM   1162  CB  LEU A  76      25.450  63.964  15.790  1.00  0.00           C  
ATOM   1163  CG  LEU A  76      25.143  62.648  15.073  1.00  0.00           C  
ATOM   1164  CD1 LEU A  76      25.581  62.716  13.619  1.00  0.00           C  
ATOM   1165  CD2 LEU A  76      25.820  61.484  15.782  1.00  0.00           C  
ATOM   1166  H   LEU A  76      22.802  64.643  15.743  1.00  0.00           H  
ATOM   1167  HA  LEU A  76      24.701  63.667  17.773  1.00  0.00           H  
ATOM   1168  HB2 LEU A  76      25.403  64.756  15.059  1.00  0.00           H  
ATOM   1169  HB3 LEU A  76      26.455  63.899  16.185  1.00  0.00           H  
ATOM   1170  HG  LEU A  76      24.075  62.476  15.093  1.00  0.00           H  
ATOM   1171 HD11 LEU A  76      24.828  63.229  13.040  1.00  0.00           H  
ATOM   1172 HD12 LEU A  76      25.711  61.716  13.235  1.00  0.00           H  
ATOM   1173 HD13 LEU A  76      26.516  63.253  13.549  1.00  0.00           H  
ATOM   1174 HD21 LEU A  76      26.853  61.425  15.470  1.00  0.00           H  
ATOM   1175 HD22 LEU A  76      25.316  60.564  15.526  1.00  0.00           H  
ATOM   1176 HD23 LEU A  76      25.774  61.636  16.850  1.00  0.00           H  
ATOM   1177  N   PRO A  77      25.781  65.927  18.284  1.00  0.00           N  
ATOM   1178  CA  PRO A  77      26.165  67.239  18.812  1.00  0.00           C  
ATOM   1179  C   PRO A  77      26.837  68.113  17.758  1.00  0.00           C  
ATOM   1180  O   PRO A  77      27.097  67.665  16.641  1.00  0.00           O  
ATOM   1181  CB  PRO A  77      27.151  66.898  19.931  1.00  0.00           C  
ATOM   1182  CG  PRO A  77      27.711  65.571  19.552  1.00  0.00           C  
ATOM   1183  CD  PRO A  77      26.601  64.841  18.845  1.00  0.00           C  
ATOM   1184  HA  PRO A  77      25.316  67.765  19.224  1.00  0.00           H  
ATOM   1185  HB2 PRO A  77      27.922  67.654  19.979  1.00  0.00           H  
ATOM   1186  HB3 PRO A  77      26.628  66.850  20.875  1.00  0.00           H  
ATOM   1187  HG2 PRO A  77      28.553  65.703  18.890  1.00  0.00           H  
ATOM   1188  HG3 PRO A  77      28.009  65.031  20.438  1.00  0.00           H  
ATOM   1189  HD2 PRO A  77      27.001  64.215  18.060  1.00  0.00           H  
ATOM   1190  HD3 PRO A  77      26.031  64.250  19.547  1.00  0.00           H  
ATOM   1191  N   SER A  78      27.119  69.360  18.121  1.00  0.00           N  
ATOM   1192  CA  SER A  78      27.758  70.297  17.204  1.00  0.00           C  
ATOM   1193  C   SER A  78      29.249  69.999  17.075  1.00  0.00           C  
ATOM   1194  O   SER A  78      29.977  70.701  16.374  1.00  0.00           O  
ATOM   1195  CB  SER A  78      27.555  71.735  17.687  1.00  0.00           C  
ATOM   1196  OG  SER A  78      28.514  72.084  18.670  1.00  0.00           O  
ATOM   1197  H   SER A  78      26.887  69.658  19.025  1.00  0.00           H  
ATOM   1198  HA  SER A  78      27.294  70.183  16.236  1.00  0.00           H  
ATOM   1199  HB2 SER A  78      27.651  72.410  16.851  1.00  0.00           H  
ATOM   1200  HB3 SER A  78      26.566  71.831  18.115  1.00  0.00           H  
ATOM   1201  HG  SER A  78      28.068  72.438  19.442  1.00  0.00           H  
ATOM   1202  N   THR A  79      29.697  68.950  17.759  1.00  0.00           N  
ATOM   1203  CA  THR A  79      31.101  68.557  17.723  1.00  0.00           C  
ATOM   1204  C   THR A  79      31.389  67.659  16.526  1.00  0.00           C  
ATOM   1205  O   THR A  79      32.443  67.767  15.898  1.00  0.00           O  
ATOM   1206  CB  THR A  79      31.512  67.822  19.013  1.00  0.00           C  
ATOM   1207  OG1 THR A  79      30.653  66.697  19.229  1.00  0.00           O  
ATOM   1208  CG2 THR A  79      31.445  68.756  20.212  1.00  0.00           C  
ATOM   1209  H   THR A  79      29.068  68.429  18.301  1.00  0.00           H  
ATOM   1210  HA  THR A  79      31.696  69.455  17.639  1.00  0.00           H  
ATOM   1211  HB  THR A  79      32.528  67.474  18.902  1.00  0.00           H  
ATOM   1212  HG1 THR A  79      30.751  66.389  20.134  1.00  0.00           H  
ATOM   1213 HG21 THR A  79      30.960  68.252  21.034  1.00  0.00           H  
ATOM   1214 HG22 THR A  79      30.884  69.640  19.949  1.00  0.00           H  
ATOM   1215 HG23 THR A  79      32.446  69.038  20.504  1.00  0.00           H  
ATOM   1216  N   ARG A  80      30.447  66.775  16.215  1.00  0.00           N  
ATOM   1217  CA  ARG A  80      30.603  65.857  15.091  1.00  0.00           C  
ATOM   1218  C   ARG A  80      30.234  66.540  13.778  1.00  0.00           C  
ATOM   1219  O   ARG A  80      30.363  65.951  12.703  1.00  0.00           O  
ATOM   1220  CB  ARG A  80      29.733  64.616  15.297  1.00  0.00           C  
ATOM   1221  CG  ARG A  80      29.465  64.294  16.758  1.00  0.00           C  
ATOM   1222  CD  ARG A  80      29.172  62.815  16.958  1.00  0.00           C  
ATOM   1223  NE  ARG A  80      29.251  62.428  18.364  1.00  0.00           N  
ATOM   1224  CZ  ARG A  80      29.057  61.187  18.796  1.00  0.00           C  
ATOM   1225  NH1 ARG A  80      28.775  60.218  17.935  1.00  0.00           N  
ATOM   1226  NH2 ARG A  80      29.146  60.913  20.091  1.00  0.00           N  
ATOM   1227  H   ARG A  80      29.630  66.737  16.753  1.00  0.00           H  
ATOM   1228  HA  ARG A  80      31.639  65.558  15.049  1.00  0.00           H  
ATOM   1229  HB2 ARG A  80      28.784  64.771  14.805  1.00  0.00           H  
ATOM   1230  HB3 ARG A  80      30.227  63.767  14.848  1.00  0.00           H  
ATOM   1231  HG2 ARG A  80      30.334  64.560  17.341  1.00  0.00           H  
ATOM   1232  HG3 ARG A  80      28.614  64.870  17.093  1.00  0.00           H  
ATOM   1233  HD2 ARG A  80      28.179  62.606  16.592  1.00  0.00           H  
ATOM   1234  HD3 ARG A  80      29.892  62.241  16.395  1.00  0.00           H  
ATOM   1235  HE  ARG A  80      29.458  63.128  19.017  1.00  0.00           H  
ATOM   1236 HH11 ARG A  80      28.709  60.422  16.959  1.00  0.00           H  
ATOM   1237 HH12 ARG A  80      28.631  59.284  18.264  1.00  0.00           H  
ATOM   1238 HH21 ARG A  80      29.359  61.639  20.742  1.00  0.00           H  
ATOM   1239 HH22 ARG A  80      28.999  59.978  20.415  1.00  0.00           H  
ATOM   1240  N   LEU A  81      29.773  67.781  13.871  1.00  0.00           N  
ATOM   1241  CA  LEU A  81      29.384  68.545  12.690  1.00  0.00           C  
ATOM   1242  C   LEU A  81      30.476  69.533  12.296  1.00  0.00           C  
ATOM   1243  O   LEU A  81      31.111  70.146  13.153  1.00  0.00           O  
ATOM   1244  CB  LEU A  81      28.073  69.290  12.948  1.00  0.00           C  
ATOM   1245  CG  LEU A  81      26.865  68.423  13.304  1.00  0.00           C  
ATOM   1246  CD1 LEU A  81      25.712  69.287  13.789  1.00  0.00           C  
ATOM   1247  CD2 LEU A  81      26.440  67.586  12.106  1.00  0.00           C  
ATOM   1248  H   LEU A  81      29.691  68.197  14.755  1.00  0.00           H  
ATOM   1249  HA  LEU A  81      29.237  67.847  11.879  1.00  0.00           H  
ATOM   1250  HB2 LEU A  81      28.239  69.976  13.765  1.00  0.00           H  
ATOM   1251  HB3 LEU A  81      27.831  69.850  12.057  1.00  0.00           H  
ATOM   1252  HG  LEU A  81      27.137  67.749  14.104  1.00  0.00           H  
ATOM   1253 HD11 LEU A  81      25.420  68.974  14.780  1.00  0.00           H  
ATOM   1254 HD12 LEU A  81      24.874  69.180  13.116  1.00  0.00           H  
ATOM   1255 HD13 LEU A  81      26.023  70.322  13.814  1.00  0.00           H  
ATOM   1256 HD21 LEU A  81      26.121  66.611  12.444  1.00  0.00           H  
ATOM   1257 HD22 LEU A  81      27.275  67.477  11.428  1.00  0.00           H  
ATOM   1258 HD23 LEU A  81      25.623  68.075  11.596  1.00  0.00           H  
ATOM   1259  N   GLY A  82      30.688  69.685  10.992  1.00  0.00           N  
ATOM   1260  CA  GLY A  82      31.703  70.602  10.506  1.00  0.00           C  
ATOM   1261  C   GLY A  82      31.302  71.277   9.210  1.00  0.00           C  
ATOM   1262  O   GLY A  82      30.286  70.928   8.607  1.00  0.00           O  
ATOM   1263  H   GLY A  82      30.151  69.169  10.353  1.00  0.00           H  
ATOM   1264  HA2 GLY A  82      31.876  71.358  11.256  1.00  0.00           H  
ATOM   1265  HA3 GLY A  82      32.619  70.053  10.344  1.00  0.00           H  
ATOM   1266  N   THR A  83      32.100  72.249   8.780  1.00  0.00           N  
ATOM   1267  CA  THR A  83      31.822  72.977   7.548  1.00  0.00           C  
ATOM   1268  C   THR A  83      32.001  72.082   6.327  1.00  0.00           C  
ATOM   1269  O   THR A  83      33.102  71.603   6.053  1.00  0.00           O  
ATOM   1270  CB  THR A  83      32.735  74.210   7.406  1.00  0.00           C  
ATOM   1271  OG1 THR A  83      32.855  74.879   8.665  1.00  0.00           O  
ATOM   1272  CG2 THR A  83      32.186  75.172   6.364  1.00  0.00           C  
ATOM   1273  H   THR A  83      32.894  72.481   9.303  1.00  0.00           H  
ATOM   1274  HA  THR A  83      30.797  73.318   7.586  1.00  0.00           H  
ATOM   1275  HB  THR A  83      33.714  73.879   7.088  1.00  0.00           H  
ATOM   1276  HG1 THR A  83      33.263  75.738   8.534  1.00  0.00           H  
ATOM   1277 HG21 THR A  83      31.200  75.498   6.659  1.00  0.00           H  
ATOM   1278 HG22 THR A  83      32.130  74.675   5.408  1.00  0.00           H  
ATOM   1279 HG23 THR A  83      32.838  76.030   6.287  1.00  0.00           H  
ATOM   1280  N   LEU A  84      30.914  71.862   5.598  1.00  0.00           N  
ATOM   1281  CA  LEU A  84      30.950  71.024   4.403  1.00  0.00           C  
ATOM   1282  C   LEU A  84      31.578  71.773   3.232  1.00  0.00           C  
ATOM   1283  O   LEU A  84      31.003  72.731   2.715  1.00  0.00           O  
ATOM   1284  CB  LEU A  84      29.538  70.567   4.034  1.00  0.00           C  
ATOM   1285  CG  LEU A  84      29.369  69.982   2.631  1.00  0.00           C  
ATOM   1286  CD1 LEU A  84      30.276  68.776   2.442  1.00  0.00           C  
ATOM   1287  CD2 LEU A  84      27.916  69.602   2.384  1.00  0.00           C  
ATOM   1288  H   LEU A  84      30.065  72.271   5.866  1.00  0.00           H  
ATOM   1289  HA  LEU A  84      31.555  70.157   4.626  1.00  0.00           H  
ATOM   1290  HB2 LEU A  84      29.238  69.813   4.745  1.00  0.00           H  
ATOM   1291  HB3 LEU A  84      28.882  71.421   4.119  1.00  0.00           H  
ATOM   1292  HG  LEU A  84      29.648  70.728   1.900  1.00  0.00           H  
ATOM   1293 HD11 LEU A  84      29.790  68.057   1.800  1.00  0.00           H  
ATOM   1294 HD12 LEU A  84      30.478  68.324   3.401  1.00  0.00           H  
ATOM   1295 HD13 LEU A  84      31.205  69.092   1.990  1.00  0.00           H  
ATOM   1296 HD21 LEU A  84      27.768  68.561   2.634  1.00  0.00           H  
ATOM   1297 HD22 LEU A  84      27.674  69.759   1.342  1.00  0.00           H  
ATOM   1298 HD23 LEU A  84      27.274  70.215   2.999  1.00  0.00           H  
ATOM   1299  N   SER A  85      32.760  71.328   2.817  1.00  0.00           N  
ATOM   1300  CA  SER A  85      33.466  71.956   1.707  1.00  0.00           C  
ATOM   1301  C   SER A  85      32.611  71.950   0.444  1.00  0.00           C  
ATOM   1302  O   SER A  85      31.852  71.016   0.183  1.00  0.00           O  
ATOM   1303  CB  SER A  85      34.790  71.235   1.444  1.00  0.00           C  
ATOM   1304  OG  SER A  85      35.437  71.760   0.297  1.00  0.00           O  
ATOM   1305  H   SER A  85      33.167  70.559   3.270  1.00  0.00           H  
ATOM   1306  HA  SER A  85      33.672  72.979   1.983  1.00  0.00           H  
ATOM   1307  HB2 SER A  85      35.440  71.359   2.297  1.00  0.00           H  
ATOM   1308  HB3 SER A  85      34.599  70.183   1.286  1.00  0.00           H  
ATOM   1309  HG  SER A  85      35.366  71.132  -0.426  1.00  0.00           H  
ATOM   1310  N   PRO A  86      32.735  73.016  -0.359  1.00  0.00           N  
ATOM   1311  CA  PRO A  86      31.982  73.158  -1.609  1.00  0.00           C  
ATOM   1312  C   PRO A  86      32.444  72.174  -2.679  1.00  0.00           C  
ATOM   1313  O   PRO A  86      31.700  71.857  -3.607  1.00  0.00           O  
ATOM   1314  CB  PRO A  86      32.278  74.596  -2.041  1.00  0.00           C  
ATOM   1315  CG  PRO A  86      33.590  74.918  -1.413  1.00  0.00           C  
ATOM   1316  CD  PRO A  86      33.621  74.165  -0.110  1.00  0.00           C  
ATOM   1317  HA  PRO A  86      30.920  73.040  -1.448  1.00  0.00           H  
ATOM   1318  HB2 PRO A  86      32.332  74.647  -3.119  1.00  0.00           H  
ATOM   1319  HB3 PRO A  86      31.498  75.251  -1.682  1.00  0.00           H  
ATOM   1320  HG2 PRO A  86      34.395  74.590  -2.053  1.00  0.00           H  
ATOM   1321  HG3 PRO A  86      33.659  75.980  -1.233  1.00  0.00           H  
ATOM   1322  HD2 PRO A  86      34.625  73.837   0.111  1.00  0.00           H  
ATOM   1323  HD3 PRO A  86      33.237  74.780   0.690  1.00  0.00           H  
ATOM   1324  N   ALA A  87      33.676  71.695  -2.543  1.00  0.00           N  
ATOM   1325  CA  ALA A  87      34.236  70.746  -3.497  1.00  0.00           C  
ATOM   1326  C   ALA A  87      33.612  69.365  -3.329  1.00  0.00           C  
ATOM   1327  O   ALA A  87      33.432  68.630  -4.300  1.00  0.00           O  
ATOM   1328  CB  ALA A  87      35.747  70.669  -3.339  1.00  0.00           C  
ATOM   1329  H   ALA A  87      34.221  71.986  -1.783  1.00  0.00           H  
ATOM   1330  HA  ALA A  87      34.021  71.107  -4.493  1.00  0.00           H  
ATOM   1331  HB1 ALA A  87      35.998  70.659  -2.288  1.00  0.00           H  
ATOM   1332  HB2 ALA A  87      36.111  69.764  -3.805  1.00  0.00           H  
ATOM   1333  HB3 ALA A  87      36.203  71.526  -3.811  1.00  0.00           H  
ATOM   1334  N   PHE A  88      33.285  69.016  -2.088  1.00  0.00           N  
ATOM   1335  CA  PHE A  88      32.684  67.722  -1.791  1.00  0.00           C  
ATOM   1336  C   PHE A  88      31.182  67.861  -1.558  1.00  0.00           C  
ATOM   1337  O   PHE A  88      30.463  66.866  -1.467  1.00  0.00           O  
ATOM   1338  CB  PHE A  88      33.347  67.097  -0.561  1.00  0.00           C  
ATOM   1339  CG  PHE A  88      34.848  67.126  -0.609  1.00  0.00           C  
ATOM   1340  CD1 PHE A  88      35.530  66.581  -1.685  1.00  0.00           C  
ATOM   1341  CD2 PHE A  88      35.576  67.698   0.422  1.00  0.00           C  
ATOM   1342  CE1 PHE A  88      36.911  66.607  -1.732  1.00  0.00           C  
ATOM   1343  CE2 PHE A  88      36.957  67.727   0.379  1.00  0.00           C  
ATOM   1344  CZ  PHE A  88      37.626  67.179  -0.698  1.00  0.00           C  
ATOM   1345  H   PHE A  88      33.454  69.645  -1.354  1.00  0.00           H  
ATOM   1346  HA  PHE A  88      32.846  67.078  -2.642  1.00  0.00           H  
ATOM   1347  HB2 PHE A  88      33.032  67.635   0.320  1.00  0.00           H  
ATOM   1348  HB3 PHE A  88      33.035  66.067  -0.479  1.00  0.00           H  
ATOM   1349  HD1 PHE A  88      34.971  66.133  -2.494  1.00  0.00           H  
ATOM   1350  HD2 PHE A  88      35.054  68.126   1.266  1.00  0.00           H  
ATOM   1351  HE1 PHE A  88      37.431  66.177  -2.576  1.00  0.00           H  
ATOM   1352  HE2 PHE A  88      37.513  68.175   1.190  1.00  0.00           H  
ATOM   1353  HZ  PHE A  88      38.705  67.201  -0.733  1.00  0.00           H  
ATOM   1354  N   SER A  89      30.717  69.101  -1.463  1.00  0.00           N  
ATOM   1355  CA  SER A  89      29.302  69.372  -1.237  1.00  0.00           C  
ATOM   1356  C   SER A  89      28.440  68.670  -2.283  1.00  0.00           C  
ATOM   1357  O   SER A  89      28.861  68.477  -3.424  1.00  0.00           O  
ATOM   1358  CB  SER A  89      29.037  70.878  -1.269  1.00  0.00           C  
ATOM   1359  OG  SER A  89      27.722  71.156  -1.721  1.00  0.00           O  
ATOM   1360  H   SER A  89      31.340  69.854  -1.544  1.00  0.00           H  
ATOM   1361  HA  SER A  89      29.044  68.991  -0.260  1.00  0.00           H  
ATOM   1362  HB2 SER A  89      29.156  71.284  -0.277  1.00  0.00           H  
ATOM   1363  HB3 SER A  89      29.741  71.351  -1.939  1.00  0.00           H  
ATOM   1364  HG  SER A  89      27.130  71.209  -0.967  1.00  0.00           H  
ATOM   1365  N   THR A  90      27.229  68.291  -1.886  1.00  0.00           N  
ATOM   1366  CA  THR A  90      26.309  67.610  -2.786  1.00  0.00           C  
ATOM   1367  C   THR A  90      26.135  68.387  -4.086  1.00  0.00           C  
ATOM   1368  O   THR A  90      25.659  67.845  -5.084  1.00  0.00           O  
ATOM   1369  CB  THR A  90      24.928  67.410  -2.131  1.00  0.00           C  
ATOM   1370  OG1 THR A  90      24.103  66.592  -2.969  1.00  0.00           O  
ATOM   1371  CG2 THR A  90      24.245  68.748  -1.891  1.00  0.00           C  
ATOM   1372  H   THR A  90      26.952  68.474  -0.963  1.00  0.00           H  
ATOM   1373  HA  THR A  90      26.721  66.637  -3.011  1.00  0.00           H  
ATOM   1374  HB  THR A  90      25.065  66.916  -1.181  1.00  0.00           H  
ATOM   1375  HG1 THR A  90      24.288  65.666  -2.793  1.00  0.00           H  
ATOM   1376 HG21 THR A  90      23.897  69.149  -2.831  1.00  0.00           H  
ATOM   1377 HG22 THR A  90      24.948  69.435  -1.444  1.00  0.00           H  
ATOM   1378 HG23 THR A  90      23.405  68.609  -1.227  1.00  0.00           H  
ATOM   1379  N   ARG A  91      26.524  69.657  -4.067  1.00  0.00           N  
ATOM   1380  CA  ARG A  91      26.411  70.508  -5.245  1.00  0.00           C  
ATOM   1381  C   ARG A  91      26.985  69.812  -6.476  1.00  0.00           C  
ATOM   1382  O   ARG A  91      26.575  70.087  -7.604  1.00  0.00           O  
ATOM   1383  CB  ARG A  91      27.135  71.836  -5.013  1.00  0.00           C  
ATOM   1384  CG  ARG A  91      26.260  72.904  -4.379  1.00  0.00           C  
ATOM   1385  CD  ARG A  91      26.949  74.260  -4.378  1.00  0.00           C  
ATOM   1386  NE  ARG A  91      27.762  74.459  -3.182  1.00  0.00           N  
ATOM   1387  CZ  ARG A  91      27.257  74.750  -1.989  1.00  0.00           C  
ATOM   1388  NH1 ARG A  91      25.946  74.872  -1.833  1.00  0.00           N  
ATOM   1389  NH2 ARG A  91      28.062  74.916  -0.948  1.00  0.00           N  
ATOM   1390  H   ARG A  91      26.897  70.031  -3.241  1.00  0.00           H  
ATOM   1391  HA  ARG A  91      25.363  70.705  -5.413  1.00  0.00           H  
ATOM   1392  HB2 ARG A  91      27.981  71.662  -4.363  1.00  0.00           H  
ATOM   1393  HB3 ARG A  91      27.491  72.208  -5.962  1.00  0.00           H  
ATOM   1394  HG2 ARG A  91      25.339  72.981  -4.938  1.00  0.00           H  
ATOM   1395  HG3 ARG A  91      26.041  72.620  -3.361  1.00  0.00           H  
ATOM   1396  HD2 ARG A  91      27.583  74.327  -5.250  1.00  0.00           H  
ATOM   1397  HD3 ARG A  91      26.194  75.032  -4.421  1.00  0.00           H  
ATOM   1398  HE  ARG A  91      28.734  74.373  -3.275  1.00  0.00           H  
ATOM   1399 HH11 ARG A  91      25.336  74.746  -2.615  1.00  0.00           H  
ATOM   1400 HH12 ARG A  91      25.568  75.090  -0.932  1.00  0.00           H  
ATOM   1401 HH21 ARG A  91      29.052  74.823  -1.062  1.00  0.00           H  
ATOM   1402 HH22 ARG A  91      27.681  75.134  -0.051  1.00  0.00           H  
ATOM   1403  N   VAL A  92      27.935  68.910  -6.251  1.00  0.00           N  
ATOM   1404  CA  VAL A  92      28.564  68.174  -7.341  1.00  0.00           C  
ATOM   1405  C   VAL A  92      27.883  66.828  -7.561  1.00  0.00           C  
ATOM   1406  O   VAL A  92      27.693  66.394  -8.698  1.00  0.00           O  
ATOM   1407  CB  VAL A  92      30.062  67.941  -7.069  1.00  0.00           C  
ATOM   1408  CG1 VAL A  92      30.782  67.545  -8.349  1.00  0.00           C  
ATOM   1409  CG2 VAL A  92      30.691  69.182  -6.456  1.00  0.00           C  
ATOM   1410  H   VAL A  92      28.218  68.735  -5.329  1.00  0.00           H  
ATOM   1411  HA  VAL A  92      28.471  68.765  -8.240  1.00  0.00           H  
ATOM   1412  HB  VAL A  92      30.157  67.129  -6.363  1.00  0.00           H  
ATOM   1413 HG11 VAL A  92      30.215  66.779  -8.858  1.00  0.00           H  
ATOM   1414 HG12 VAL A  92      30.879  68.408  -8.990  1.00  0.00           H  
ATOM   1415 HG13 VAL A  92      31.763  67.163  -8.107  1.00  0.00           H  
ATOM   1416 HG21 VAL A  92      31.653  68.928  -6.037  1.00  0.00           H  
ATOM   1417 HG22 VAL A  92      30.820  69.936  -7.220  1.00  0.00           H  
ATOM   1418 HG23 VAL A  92      30.049  69.565  -5.678  1.00  0.00           H  
ATOM   1419  N   LEU A  93      27.516  66.171  -6.465  1.00  0.00           N  
ATOM   1420  CA  LEU A  93      26.855  64.873  -6.537  1.00  0.00           C  
ATOM   1421  C   LEU A  93      25.483  64.923  -5.871  1.00  0.00           C  
ATOM   1422  O   LEU A  93      25.310  65.493  -4.794  1.00  0.00           O  
ATOM   1423  CB  LEU A  93      27.719  63.800  -5.873  1.00  0.00           C  
ATOM   1424  CG  LEU A  93      27.422  62.355  -6.274  1.00  0.00           C  
ATOM   1425  CD1 LEU A  93      27.805  62.114  -7.726  1.00  0.00           C  
ATOM   1426  CD2 LEU A  93      28.156  61.385  -5.359  1.00  0.00           C  
ATOM   1427  H   LEU A  93      27.694  66.567  -5.587  1.00  0.00           H  
ATOM   1428  HA  LEU A  93      26.725  64.624  -7.581  1.00  0.00           H  
ATOM   1429  HB2 LEU A  93      28.749  64.007  -6.119  1.00  0.00           H  
ATOM   1430  HB3 LEU A  93      27.583  63.883  -4.804  1.00  0.00           H  
ATOM   1431  HG  LEU A  93      26.360  62.172  -6.175  1.00  0.00           H  
ATOM   1432 HD11 LEU A  93      26.967  61.685  -8.253  1.00  0.00           H  
ATOM   1433 HD12 LEU A  93      28.644  61.434  -7.768  1.00  0.00           H  
ATOM   1434 HD13 LEU A  93      28.079  63.052  -8.186  1.00  0.00           H  
ATOM   1435 HD21 LEU A  93      29.201  61.655  -5.313  1.00  0.00           H  
ATOM   1436 HD22 LEU A  93      28.059  60.382  -5.746  1.00  0.00           H  
ATOM   1437 HD23 LEU A  93      27.729  61.433  -4.368  1.00  0.00           H  
ATOM   1438  N   PRO A  94      24.485  64.310  -6.523  1.00  0.00           N  
ATOM   1439  CA  PRO A  94      23.112  64.267  -6.011  1.00  0.00           C  
ATOM   1440  C   PRO A  94      22.981  63.382  -4.777  1.00  0.00           C  
ATOM   1441  O   PRO A  94      23.619  62.333  -4.684  1.00  0.00           O  
ATOM   1442  CB  PRO A  94      22.315  63.681  -7.179  1.00  0.00           C  
ATOM   1443  CG  PRO A  94      23.309  62.886  -7.954  1.00  0.00           C  
ATOM   1444  CD  PRO A  94      24.619  63.609  -7.812  1.00  0.00           C  
ATOM   1445  HA  PRO A  94      22.744  65.257  -5.783  1.00  0.00           H  
ATOM   1446  HB2 PRO A  94      21.520  63.056  -6.798  1.00  0.00           H  
ATOM   1447  HB3 PRO A  94      21.900  64.480  -7.773  1.00  0.00           H  
ATOM   1448  HG2 PRO A  94      23.384  61.891  -7.543  1.00  0.00           H  
ATOM   1449  HG3 PRO A  94      23.015  62.843  -8.992  1.00  0.00           H  
ATOM   1450  HD2 PRO A  94      25.438  62.906  -7.785  1.00  0.00           H  
ATOM   1451  HD3 PRO A  94      24.751  64.314  -8.621  1.00  0.00           H  
ATOM   1452  N   ALA A  95      22.150  63.810  -3.833  1.00  0.00           N  
ATOM   1453  CA  ALA A  95      21.933  63.052  -2.606  1.00  0.00           C  
ATOM   1454  C   ALA A  95      21.415  61.651  -2.910  1.00  0.00           C  
ATOM   1455  O   ALA A  95      20.342  61.489  -3.490  1.00  0.00           O  
ATOM   1456  CB  ALA A  95      20.963  63.790  -1.696  1.00  0.00           C  
ATOM   1457  H   ALA A  95      21.669  64.653  -3.966  1.00  0.00           H  
ATOM   1458  HA  ALA A  95      22.880  62.971  -2.092  1.00  0.00           H  
ATOM   1459  HB1 ALA A  95      20.118  64.133  -2.275  1.00  0.00           H  
ATOM   1460  HB2 ALA A  95      20.621  63.124  -0.918  1.00  0.00           H  
ATOM   1461  HB3 ALA A  95      21.461  64.637  -1.249  1.00  0.00           H  
ATOM   1462  N   GLN A  96      22.184  60.642  -2.515  1.00  0.00           N  
ATOM   1463  CA  GLN A  96      21.802  59.254  -2.746  1.00  0.00           C  
ATOM   1464  C   GLN A  96      20.877  58.752  -1.642  1.00  0.00           C  
ATOM   1465  O   GLN A  96      20.441  57.602  -1.660  1.00  0.00           O  
ATOM   1466  CB  GLN A  96      23.046  58.367  -2.829  1.00  0.00           C  
ATOM   1467  CG  GLN A  96      24.056  58.831  -3.865  1.00  0.00           C  
ATOM   1468  CD  GLN A  96      23.496  58.814  -5.274  1.00  0.00           C  
ATOM   1469  OE1 GLN A  96      22.871  57.840  -5.695  1.00  0.00           O  
ATOM   1470  NE2 GLN A  96      23.716  59.895  -6.012  1.00  0.00           N  
ATOM   1471  H   GLN A  96      23.028  60.835  -2.057  1.00  0.00           H  
ATOM   1472  HA  GLN A  96      21.276  59.208  -3.688  1.00  0.00           H  
ATOM   1473  HB2 GLN A  96      23.532  58.358  -1.864  1.00  0.00           H  
ATOM   1474  HB3 GLN A  96      22.741  57.363  -3.079  1.00  0.00           H  
ATOM   1475  HG2 GLN A  96      24.360  59.840  -3.629  1.00  0.00           H  
ATOM   1476  HG3 GLN A  96      24.916  58.179  -3.828  1.00  0.00           H  
ATOM   1477 HE21 GLN A  96      24.223  60.633  -5.612  1.00  0.00           H  
ATOM   1478 HE22 GLN A  96      23.366  59.911  -6.927  1.00  0.00           H  
ATOM   1479  N   ALA A  97      20.585  59.622  -0.681  1.00  0.00           N  
ATOM   1480  CA  ALA A  97      19.711  59.267   0.430  1.00  0.00           C  
ATOM   1481  C   ALA A  97      18.337  58.834  -0.069  1.00  0.00           C  
ATOM   1482  O   ALA A  97      17.829  59.362  -1.059  1.00  0.00           O  
ATOM   1483  CB  ALA A  97      19.580  60.438   1.393  1.00  0.00           C  
ATOM   1484  H   ALA A  97      20.964  60.525  -0.722  1.00  0.00           H  
ATOM   1485  HA  ALA A  97      20.166  58.445   0.963  1.00  0.00           H  
ATOM   1486  HB1 ALA A  97      20.199  60.261   2.261  1.00  0.00           H  
ATOM   1487  HB2 ALA A  97      19.899  61.345   0.902  1.00  0.00           H  
ATOM   1488  HB3 ALA A  97      18.549  60.538   1.700  1.00  0.00           H  
ATOM   1489  N   THR A  98      17.739  57.868   0.622  1.00  0.00           N  
ATOM   1490  CA  THR A  98      16.424  57.362   0.249  1.00  0.00           C  
ATOM   1491  C   THR A  98      15.316  58.255   0.795  1.00  0.00           C  
ATOM   1492  O   THR A  98      14.441  58.697   0.052  1.00  0.00           O  
ATOM   1493  CB  THR A  98      16.209  55.926   0.760  1.00  0.00           C  
ATOM   1494  OG1 THR A  98      16.941  55.002  -0.054  1.00  0.00           O  
ATOM   1495  CG2 THR A  98      14.732  55.561   0.745  1.00  0.00           C  
ATOM   1496  H   THR A  98      18.194  57.487   1.401  1.00  0.00           H  
ATOM   1497  HA  THR A  98      16.366  57.352  -0.830  1.00  0.00           H  
ATOM   1498  HB  THR A  98      16.570  55.863   1.776  1.00  0.00           H  
ATOM   1499  HG1 THR A  98      16.964  55.321  -0.960  1.00  0.00           H  
ATOM   1500 HG21 THR A  98      14.606  54.552   1.108  1.00  0.00           H  
ATOM   1501 HG22 THR A  98      14.354  55.631  -0.264  1.00  0.00           H  
ATOM   1502 HG23 THR A  98      14.188  56.242   1.381  1.00  0.00           H  
ATOM   1503  N   GLU A  99      15.361  58.516   2.098  1.00  0.00           N  
ATOM   1504  CA  GLU A  99      14.358  59.356   2.743  1.00  0.00           C  
ATOM   1505  C   GLU A  99      14.719  60.833   2.609  1.00  0.00           C  
ATOM   1506  O   GLU A  99      14.339  61.654   3.444  1.00  0.00           O  
ATOM   1507  CB  GLU A  99      14.224  58.984   4.221  1.00  0.00           C  
ATOM   1508  CG  GLU A  99      13.558  57.640   4.453  1.00  0.00           C  
ATOM   1509  CD  GLU A  99      13.524  57.250   5.919  1.00  0.00           C  
ATOM   1510  OE1 GLU A  99      14.334  57.795   6.697  1.00  0.00           O  
ATOM   1511  OE2 GLU A  99      12.688  56.398   6.286  1.00  0.00           O  
ATOM   1512  H   GLU A  99      16.084  58.134   2.638  1.00  0.00           H  
ATOM   1513  HA  GLU A  99      13.413  59.182   2.251  1.00  0.00           H  
ATOM   1514  HB2 GLU A  99      15.209  58.956   4.664  1.00  0.00           H  
ATOM   1515  HB3 GLU A  99      13.638  59.744   4.719  1.00  0.00           H  
ATOM   1516  HG2 GLU A  99      12.543  57.687   4.086  1.00  0.00           H  
ATOM   1517  HG3 GLU A  99      14.101  56.883   3.906  1.00  0.00           H  
ATOM   1518  N   TYR A 100      15.454  61.162   1.552  1.00  0.00           N  
ATOM   1519  CA  TYR A 100      15.869  62.539   1.309  1.00  0.00           C  
ATOM   1520  C   TYR A 100      14.697  63.381   0.814  1.00  0.00           C  
ATOM   1521  O   TYR A 100      14.419  64.454   1.350  1.00  0.00           O  
ATOM   1522  CB  TYR A 100      17.008  62.578   0.289  1.00  0.00           C  
ATOM   1523  CG  TYR A 100      17.263  63.955  -0.281  1.00  0.00           C  
ATOM   1524  CD1 TYR A 100      17.739  64.984   0.523  1.00  0.00           C  
ATOM   1525  CD2 TYR A 100      17.029  64.227  -1.624  1.00  0.00           C  
ATOM   1526  CE1 TYR A 100      17.973  66.244   0.006  1.00  0.00           C  
ATOM   1527  CE2 TYR A 100      17.263  65.484  -2.148  1.00  0.00           C  
ATOM   1528  CZ  TYR A 100      17.733  66.489  -1.330  1.00  0.00           C  
ATOM   1529  OH  TYR A 100      17.967  67.742  -1.848  1.00  0.00           O  
ATOM   1530  H   TYR A 100      15.726  60.463   0.922  1.00  0.00           H  
ATOM   1531  HA  TYR A 100      16.223  62.949   2.245  1.00  0.00           H  
ATOM   1532  HB2 TYR A 100      17.917  62.241   0.762  1.00  0.00           H  
ATOM   1533  HB3 TYR A 100      16.768  61.918  -0.532  1.00  0.00           H  
ATOM   1534  HD1 TYR A 100      17.927  64.789   1.569  1.00  0.00           H  
ATOM   1535  HD2 TYR A 100      16.660  63.438  -2.262  1.00  0.00           H  
ATOM   1536  HE1 TYR A 100      18.342  67.030   0.647  1.00  0.00           H  
ATOM   1537  HE2 TYR A 100      17.074  65.676  -3.195  1.00  0.00           H  
ATOM   1538  HH  TYR A 100      17.450  68.389  -1.363  1.00  0.00           H  
ATOM   1539  N   ALA A 101      14.015  62.887  -0.213  1.00  0.00           N  
ATOM   1540  CA  ALA A 101      12.871  63.591  -0.780  1.00  0.00           C  
ATOM   1541  C   ALA A 101      11.887  64.007   0.308  1.00  0.00           C  
ATOM   1542  O   ALA A 101      11.195  65.017   0.180  1.00  0.00           O  
ATOM   1543  CB  ALA A 101      12.176  62.721  -1.817  1.00  0.00           C  
ATOM   1544  H   ALA A 101      14.285  62.027  -0.598  1.00  0.00           H  
ATOM   1545  HA  ALA A 101      13.239  64.478  -1.277  1.00  0.00           H  
ATOM   1546  HB1 ALA A 101      11.497  62.044  -1.322  1.00  0.00           H  
ATOM   1547  HB2 ALA A 101      11.626  63.349  -2.503  1.00  0.00           H  
ATOM   1548  HB3 ALA A 101      12.916  62.153  -2.364  1.00  0.00           H  
ATOM   1549  N   PHE A 102      11.830  63.222   1.379  1.00  0.00           N  
ATOM   1550  CA  PHE A 102      10.929  63.508   2.489  1.00  0.00           C  
ATOM   1551  C   PHE A 102      11.648  64.287   3.586  1.00  0.00           C  
ATOM   1552  O   PHE A 102      11.016  64.954   4.405  1.00  0.00           O  
ATOM   1553  CB  PHE A 102      10.360  62.208   3.060  1.00  0.00           C  
ATOM   1554  CG  PHE A 102       9.554  61.418   2.068  1.00  0.00           C  
ATOM   1555  CD1 PHE A 102       8.429  61.969   1.474  1.00  0.00           C  
ATOM   1556  CD2 PHE A 102       9.922  60.127   1.729  1.00  0.00           C  
ATOM   1557  CE1 PHE A 102       7.686  61.246   0.560  1.00  0.00           C  
ATOM   1558  CE2 PHE A 102       9.183  59.399   0.815  1.00  0.00           C  
ATOM   1559  CZ  PHE A 102       8.063  59.958   0.231  1.00  0.00           C  
ATOM   1560  H   PHE A 102      12.407  62.431   1.423  1.00  0.00           H  
ATOM   1561  HA  PHE A 102      10.117  64.110   2.109  1.00  0.00           H  
ATOM   1562  HB2 PHE A 102      11.174  61.584   3.396  1.00  0.00           H  
ATOM   1563  HB3 PHE A 102       9.721  62.440   3.898  1.00  0.00           H  
ATOM   1564  HD1 PHE A 102       8.134  62.976   1.732  1.00  0.00           H  
ATOM   1565  HD2 PHE A 102      10.796  59.686   2.184  1.00  0.00           H  
ATOM   1566  HE1 PHE A 102       6.811  61.686   0.106  1.00  0.00           H  
ATOM   1567  HE2 PHE A 102       9.479  58.393   0.559  1.00  0.00           H  
ATOM   1568  HZ  PHE A 102       7.485  59.392  -0.484  1.00  0.00           H  
ATOM   1569  N   ALA A 103      12.974  64.197   3.596  1.00  0.00           N  
ATOM   1570  CA  ALA A 103      13.780  64.893   4.590  1.00  0.00           C  
ATOM   1571  C   ALA A 103      13.375  66.359   4.697  1.00  0.00           C  
ATOM   1572  O   ALA A 103      13.328  66.923   5.791  1.00  0.00           O  
ATOM   1573  CB  ALA A 103      15.258  64.776   4.248  1.00  0.00           C  
ATOM   1574  H   ALA A 103      13.420  63.649   2.916  1.00  0.00           H  
ATOM   1575  HA  ALA A 103      13.618  64.415   5.545  1.00  0.00           H  
ATOM   1576  HB1 ALA A 103      15.552  63.736   4.278  1.00  0.00           H  
ATOM   1577  HB2 ALA A 103      15.430  65.171   3.258  1.00  0.00           H  
ATOM   1578  HB3 ALA A 103      15.838  65.334   4.966  1.00  0.00           H  
ATOM   1579  N   PHE A 104      13.083  66.972   3.555  1.00  0.00           N  
ATOM   1580  CA  PHE A 104      12.683  68.374   3.519  1.00  0.00           C  
ATOM   1581  C   PHE A 104      11.646  68.616   2.426  1.00  0.00           C  
ATOM   1582  O   PHE A 104      11.869  68.289   1.262  1.00  0.00           O  
ATOM   1583  CB  PHE A 104      13.903  69.268   3.288  1.00  0.00           C  
ATOM   1584  CG  PHE A 104      14.811  69.365   4.481  1.00  0.00           C  
ATOM   1585  CD1 PHE A 104      15.560  68.273   4.888  1.00  0.00           C  
ATOM   1586  CD2 PHE A 104      14.915  70.548   5.195  1.00  0.00           C  
ATOM   1587  CE1 PHE A 104      16.395  68.359   5.986  1.00  0.00           C  
ATOM   1588  CE2 PHE A 104      15.749  70.640   6.294  1.00  0.00           C  
ATOM   1589  CZ  PHE A 104      16.490  69.545   6.689  1.00  0.00           C  
ATOM   1590  H   PHE A 104      13.139  66.469   2.715  1.00  0.00           H  
ATOM   1591  HA  PHE A 104      12.245  68.617   4.475  1.00  0.00           H  
ATOM   1592  HB2 PHE A 104      14.479  68.874   2.465  1.00  0.00           H  
ATOM   1593  HB3 PHE A 104      13.568  70.265   3.043  1.00  0.00           H  
ATOM   1594  HD1 PHE A 104      15.487  67.346   4.339  1.00  0.00           H  
ATOM   1595  HD2 PHE A 104      14.334  71.406   4.886  1.00  0.00           H  
ATOM   1596  HE1 PHE A 104      16.974  67.502   6.293  1.00  0.00           H  
ATOM   1597  HE2 PHE A 104      15.820  71.568   6.841  1.00  0.00           H  
ATOM   1598  HZ  PHE A 104      17.142  69.614   7.546  1.00  0.00           H  
TER    1599      PHE A 104                                                      
END
MOLECULE T0504.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37      A    N   
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83      A    C   
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78      A    C   
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39      A    C   
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16      A    C   
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97      A    O   
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44      A    O   
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49      A    C   
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06      A    O   
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86      A    N   
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98      A    C   
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58      A    C   
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84      A    C   
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71      A    O   
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97      A    N   
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53      A    C   
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15      A    O   
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85      A    N   
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02      A    C   
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25      A    C   
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02      A    C   
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09      A    C   
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44      A    C   
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19      A    C   
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84      A    O   
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57      A    N   
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42      A    C   
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98      A    C   
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50      A    C   
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82      A    C   
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45      A    C   
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13      A    C   
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65      A    O   
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20      A    C   
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73      A    C   
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61      A    C   
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26      A    O   
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30      A    N   
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43      A    C   
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10      A    C   
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27      A    C   
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53      A    C   
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63      A    C   
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66      A    C   
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69      A    C   
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08      A    C   
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65      A    C   
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56      A    O   
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36      A    N   
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14      A    C   
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23      A    C   
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69      A    C   
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80      A    C   
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70      A    O   
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90      A    N   
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19      A    C   
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02      A    O   
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63      A    N   
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46      A    C   
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41      A    C   
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44      A    O   
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77      A    N   
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30      A    C   
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54      A    C   
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43      A    C   
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86      A    O   
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63      A    O   
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60      A    C   
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73      A    O   
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56      A    N   
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77      A    C   
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79      A    C   
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44      A    C   
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81      A    C   
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75      A    C   
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16      A    C   
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21      A    O   
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94      A    N   
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76      A    C   
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23      A    C   
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89      A    C   
ATOM     82  CD1 ILE    10      43.756  81.529   2.264  1.00 19.82      A    C   
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10      A    C   
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82      A    C   
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77      A    O   
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59      A    N   
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06      A    C   
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08      A    C   
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60      A    C   
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92      A    C   
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05      A    C   
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69      A    O   
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61      A    N   
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09      A    C   
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98      A    C   
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77      A    O   
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91      A    C   
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32      A    O   
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08      A    N   
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70      A    C   
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79      A    C   
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89      A    C   
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11      A    S   
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35      A    C   
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22      A    C   
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56      A    O   
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80      A    N   
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49      A    C   
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73      A    C   
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59      A    C   
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95      A    C   
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61      A    N   
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50      A    C   
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44      A    N   
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31      A    N   
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43      A    C   
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04      A    O   
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91      A    N   
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92      A    C   
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59      A    C   
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51      A    C   
ATOM    122  CD1 ILE    15      39.996  70.306   0.585  1.00 27.05      A    C   
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98      A    C   
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96      A    C   
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85      A    O   
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39      A    N   
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24      A    C   
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17      A    C   
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85      A    C   
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99      A    C   
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18      A    C   
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28      A    C   
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31      A    O   
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22      A    N   
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80      A    C   
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12      A    C   
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61      A    O   
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83      A    N   
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17      A    C   
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50      A    C   
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64      A    C   
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12      A    C   
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74      A    C   
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73      A    N   
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38      A    C   
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23      A    O   
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11      A    N   
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79      A    C   
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26      A    C   
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88      A    C   
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99      A    C   
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04      A    C   
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94      A    N   
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81      A    C   
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30      A    O   
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76      A    N   
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24      A    C   
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99      A    C   
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44      A    C   
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93      A    C   
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65      A    N   
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27      A    C   
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35      A    N   
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75      A    N   
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01      A    C   
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04      A    O   
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23      A    N   
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54      A    C   
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45      A    C   
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78      A    O   
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28      A    C   
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38      A    C   
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92      A    O   
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59      A    N   
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14      A    C   
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57      A    C   
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45      A    C   
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60      A    C   
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60      A    C   
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41      A    N   
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65      A    C   
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29      A    O   
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11      A    N   
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84      A    C   
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56      A    C   
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85      A    O   
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10      A    C   
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11      A    C   
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72      A    O   
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67      A    N   
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31      A    C   
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09      A    C   
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47      A    C   
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88      A    C   
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63      A    N   
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14      A    C   
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29      A    C   
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05      A    C   
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65      A    C   
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25      A    C   
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47      A    C   
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55      A    C   
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75      A    O   
ATOM    204  N   HIS    25      37.463  62.079   4.725  1.00 21.41      A    N   
ATOM    205  CA  HIS    25      38.827  61.919   5.220  1.00 21.79      A    C   
ATOM    206  CB  HIS    25      39.499  60.706   4.534  1.00 22.01      A    C   
ATOM    207  CG  HIS    25      38.761  59.428   4.754  1.00 21.78      A    C   
ATOM    208  ND1 HIS    25      37.736  59.007   3.930  1.00 24.64      A    N   
ATOM    209  CE1 HIS    25      37.239  57.871   4.392  1.00 21.18      A    C   
ATOM    210  NE2 HIS    25      37.889  57.555   5.498  1.00 25.69      A    N   
ATOM    211  CD2 HIS    25      38.845  58.514   5.748  1.00 20.97      A    C   
ATOM    212  C   HIS    25      39.676  63.161   5.020  1.00 22.34      A    C   
ATOM    213  O   HIS    25      39.459  63.941   4.095  1.00 22.06      A    O   
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29      A    N   
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67      A    C   
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03      A    C   
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30      A    C   
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62      A    C   
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11      A    C   
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57      A    N   
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07      A    C   
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59      A    O   
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33      A    N   
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34      A    C   
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08      A    C   
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58      A    O   
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74      A    N   
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93      A    C   
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06      A    C   
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73      A    O   
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50      A    C   
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32      A    C   
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70      A    O   
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17      A    N   
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39      A    C   
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00      A    C   
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05      A    C   
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84      A    C   
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24      A    C   
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77      A    C   
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81      A    O   
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86      A    N   
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29      A    C   
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12      A    C   
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65      A    C   
ATOM    246  CD1 ILE    30      47.190  67.505  -5.529  1.00 23.75      A    C   
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13      A    C   
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92      A    C   
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81      A    O   
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57      A    N   
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70      A    C   
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85      A    C   
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21      A    C   
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86      A    O   
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51      A    N   
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06      A    C   
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62      A    C   
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72      A    C   
ATOM    259  CD1 ILE    32      41.312  76.990  -4.538  1.00 21.43      A    C   
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89      A    C   
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59      A    C   
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54      A    O   
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30      A    N   
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55      A    C   
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71      A    C   
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65      A    C   
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37      A    C   
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45      A    O   
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01      A    N   
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54      A    C   
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76      A    O   
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78      A    N   
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41      A    C   
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30      A    C   
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81      A    O   
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36      A    C   
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52      A    C   
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01      A    O   
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56      A    N   
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84      A    C   
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18      A    C   
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09      A    C   
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61      A    C   
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94      A    C   
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63      A    O   
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84      A    N   
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85      A    C   
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67      A    C   
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99      A    O   
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19      A    N   
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16      A    C   
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59      A    C   
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83      A    C   
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32      A    C   
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79      A    C   
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51      A    O   
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42      A    N   
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23      A    C   
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59      A    C   
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97      A    O   
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52      A    N   
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99      A    C   
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28      A    C   
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73      A    C   
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93      A    C   
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28      A    C   
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24      A    N   
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68      A    C   
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89      A    O   
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54      A    N   
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74      A    C   
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45      A    C   
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21      A    C   
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42      A    C   
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38      A    C   
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30      A    N   
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98      A    C   
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60      A    O   
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67      A    N   
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61      A    C   
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74      A    C   
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37      A    C   
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43      A    C   
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08      A    C   
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70      A    C   
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71      A    O   
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29      A    C   
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84      A    C   
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85      A    C   
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49      A    O   
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94      A    N   
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02      A    C   
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22      A    C   
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67      A    C   
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84      A    C   
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36      A    C   
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81      A    N   
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53      A    C   
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05      A    O   
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35      A    N   
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92      A    C   
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50      A    C   
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28      A    C   
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88      A    C   
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25      A    C   
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86      A    O   
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74      A    N   
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81      A    C   
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63      A    C   
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17      A    C   
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45      A    C   
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65      A    C   
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07      A    N   
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00      A    C   
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51      A    O   
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53      A    N   
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40      A    C   
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65      A    C   
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24      A    C   
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75      A    C   
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50      A    C   
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86      A    C   
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89      A    C   
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72      A    C   
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99      A    C   
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81      A    O   
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71      A    N   
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20      A    C   
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20      A    C   
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31      A    C   
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82      A    O   
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86      A    O   
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51      A    C   
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78      A    O   
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36      A    N   
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07      A    C   
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82      A    C   
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15      A    O   
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00           N   
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00           C   
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00           C   
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00           C   
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89      A    O   
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66      A    N   
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00      A    C   
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62      A    C   
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03      A    O   
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46      A    N   
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65      A    C   
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92      A    C   
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50      A    C   
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70      A    C   
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53      A    C   
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89      A    N   
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83      A    C   
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32      A    O   
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37      A    N   
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75      A    C   
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54      A    C   
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38      A    O   
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54      A    C   
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69      A    O   
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75      A    N   
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31      A    C   
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47      A    C   
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39      A    C   
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20      A    C   
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52      A    C   
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65      A    C   
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95      A    O   
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72      A    N   
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96      A    C   
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56      A    C   
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20      A    C   
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98      A    C   
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46      A    C   
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06      A    C   
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74      A    O   
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72      A    N   
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06      A    C   
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95      A    C   
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54      A    O   
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42      A    C   
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57      A    O   
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72      A    N   
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16      A    C   
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50      A    C   
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73      A    O   
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83      A    N   
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79      A    C   
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23      A    C   
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56      A    C   
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74      A    O   
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32      A    N   
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90      A    C   
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34      A    O   
ATOM    437  N   HIS    57      31.698  68.348  -2.203  1.00 18.92      A    N   
ATOM    438  CA  HIS    57      32.361  67.115  -1.745  1.00 19.22      A    C   
ATOM    439  CB  HIS    57      32.520  66.145  -2.914  1.00 19.81      A    C   
ATOM    440  CG  HIS    57      31.219  65.568  -3.378  1.00 20.14      A    C   
ATOM    441  ND1 HIS    57      31.049  65.028  -4.633  1.00 22.60      A    N   
ATOM    442  CE1 HIS    57      29.809  64.583  -4.748  1.00 22.65      A    C   
ATOM    443  NE2 HIS    57      29.171  64.824  -3.616  1.00 21.53      A    N   
ATOM    444  CD2 HIS    57      30.028  65.448  -2.747  1.00 20.42      A    C   
ATOM    445  C   HIS    57      33.680  67.336  -0.975  1.00 19.11      A    C   
ATOM    446  O   HIS    57      34.538  66.434  -0.828  1.00 18.12      A    O   
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70      A    N   
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51      A    C   
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69      A    C   
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12      A    C   
ATOM    451  CD1 ILE    58      36.427  72.053  -1.279  1.00 20.43      A    C   
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86      A    C   
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50      A    C   
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32      A    O   
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26      A    N   
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14      A    C   
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64      A    C   
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13      A    C   
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21      A    O   
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54      A    N   
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93      A    C   
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71      A    C   
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24      A    C   
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29      A    C   
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49      A    C   
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43      A    C   
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41      A    O   
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82      A    C   
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93      A    C   
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12      A    C   
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61      A    O   
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95      A    N   
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35      A    C   
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77      A    C   
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11      A    C   
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02      A    O   
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95      A    O   
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08      A    C   
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03      A    O   
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41      A    N   
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63      A    C   
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27      A    C   
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13      A    C   
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54      A    C   
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38      A    C   
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74      A    C   
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51      A    O   
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91      A    C   
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32      A    C   
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84      A    C   
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97      A    O   
ATOM    492  N   HIS    63      35.010  73.105  13.440  1.00 24.32      A    N   
ATOM    493  CA  HIS    63      33.615  73.111  13.872  1.00 25.56      A    C   
ATOM    494  CB  HIS    63      33.519  72.477  15.263  1.00 24.97      A    C   
ATOM    495  CG  HIS    63      34.160  71.127  15.321  1.00 24.22      A    C   
ATOM    496  ND1 HIS    63      35.270  70.847  16.088  1.00 28.07      A    N   
ATOM    497  CE1 HIS    63      35.632  69.590  15.888  1.00 26.20      A    C   
ATOM    498  NE2 HIS    63      34.807  69.053  15.003  1.00 26.25      A    N   
ATOM    499  CD2 HIS    63      33.881  69.993  14.634  1.00 22.43      A    C   
ATOM    500  C   HIS    63      33.056  74.547  13.817  1.00 27.28      A    C   
ATOM    501  O   HIS    63      33.586  75.443  14.467  1.00 29.56      A    O   
ATOM    502  N   PRO    64      31.954  74.758  13.096  1.00 27.66      A    N   
ATOM    503  CA  PRO    64      31.450  76.135  12.904  1.00 28.40      A    C   
ATOM    504  CB  PRO    64      30.466  75.960  11.757  1.00 28.92      A    C   
ATOM    505  CG  PRO    64      29.955  74.603  11.911  1.00 28.74      A    C   
ATOM    506  CD  PRO    64      31.088  73.762  12.452  1.00 28.41      A    C   
ATOM    507  C   PRO    64      30.737  76.680  14.157  1.00 28.53      A    C   
ATOM    508  O   PRO    64      30.267  75.870  14.966  1.00 26.81      A    O   
ATOM    509  N   PRO    65      30.670  78.032  14.343  1.00 28.51      A    N   
ATOM    510  CA  PRO    65      29.781  78.511  15.410  1.00 28.90      A    C   
ATOM    511  CB  PRO    65      29.983  80.037  15.387  1.00 29.10      A    C   
ATOM    512  CG  PRO    65      30.416  80.320  13.970  1.00 29.99      A    C   
ATOM    513  CD  PRO    65      31.331  79.162  13.652  1.00 29.84      A    C   
ATOM    514  C   PRO    65      28.326  78.162  15.115  1.00 28.20      A    C   
ATOM    515  O   PRO    65      27.971  77.919  13.959  1.00 26.73      A    O   
ATOM    516  N   ALA    66      27.491  78.145  16.155  1.00 27.87      A    N   
ATOM    517  CA  ALA    66      26.122  77.661  16.034  1.00 28.85      A    C   
ATOM    518  CB  ALA    66      25.446  77.601  17.415  1.00 28.88      A    C   
ATOM    519  C   ALA    66      25.292  78.496  15.066  1.00 29.29      A    C   
ATOM    520  O   ALA    66      24.380  77.978  14.416  1.00 29.66      A    O   
ATOM    521  N   ASP    67      25.614  79.781  14.954  1.00 29.76      A    N   
ATOM    522  CA  ASP    67      24.822  80.664  14.085  1.00 30.53      A    C   
ATOM    523  CB  ASP    67      24.981  82.137  14.486  1.00 31.00      A    C   
ATOM    524  CG  ASP    67      26.274  82.764  14.004  1.00 32.77      A    C   
ATOM    525  OD1 ASP    67      27.240  82.069  13.600  1.00 32.49      A    O   
ATOM    526  OD2 ASP    67      26.323  84.014  14.053  1.00 36.84      A    O   
ATOM    527  C   ASP    67      25.035  80.472  12.582  1.00 30.00      A    C   
ATOM    528  O   ASP    67      24.381  81.149  11.775  1.00 30.51      A    O   
ATOM    529  N   LYS    68      25.975  79.592  12.223  1.00 29.05      A    N   
ATOM    530  CA  LYS    68      26.257  79.261  10.831  1.00 29.09      A    C   
ATOM    531  CB  LYS    68      27.768  79.137  10.608  1.00 30.00      A    C   
ATOM    532  CG  LYS    68      28.497  80.472  10.640  1.00 31.64      A    C   
ATOM    533  CD  LYS    68      28.432  81.150   9.278  1.00 36.82      A    C   
ATOM    534  CE  LYS    68      29.065  82.536   9.325  1.00 39.10      A    C   
ATOM    535  NZ  LYS    68      28.023  83.587   9.542  1.00 41.28      A    N   
ATOM    536  C   LYS    68      25.574  77.952  10.469  1.00 28.41      A    C   
ATOM    537  O   LYS    68      25.670  77.468   9.339  1.00 28.19      A    O   
ATOM    538  N   LEU    69      24.905  77.369  11.451  1.00 27.13      A    N   
ATOM    539  CA  LEU    69      24.227  76.106  11.240  1.00 26.80      A    C   
ATOM    540  CB  LEU    69      24.664  75.091  12.293  1.00 25.60      A    C   
ATOM    541  CG  LEU    69      26.066  74.516  12.062  1.00 26.76      A    C   
ATOM    542  CD1 LEU    69      26.629  73.978  13.390  1.00 25.41      A    C   
ATOM    543  CD2 LEU    69      26.050  73.448  10.979  1.00 29.04      A    C   
ATOM    544  C   LEU    69      22.727  76.339  11.288  1.00 26.41      A    C   
ATOM    545  O   LEU    69      22.192  76.825  12.304  1.00 28.95      A    O   
ATOM    546  N   TYR    70      22.055  76.023  10.194  1.00 25.13      A    N   
ATOM    547  CA  TYR    70      20.602  76.160  10.119  1.00 24.67      A    C   
ATOM    548  CB  TYR    70      20.206  77.029   8.925  1.00 25.50      A    C   
ATOM    549  CG  TYR    70      20.819  78.411   8.966  1.00 26.84      A    C   
ATOM    550  CD1 TYR    70      20.114  79.468   9.532  1.00 27.92      A    C   
ATOM    551  CE1 TYR    70      20.671  80.753   9.600  1.00 28.60      A    C   
ATOM    552  CZ  TYR    70      21.941  80.970   9.108  1.00 29.62      A    C   
ATOM    553  OH  TYR    70      22.471  82.247   9.188  1.00 30.75      A    O   
ATOM    554  CE2 TYR    70      22.676  79.929   8.531  1.00 28.82      A    C   
ATOM    555  CD2 TYR    70      22.111  78.648   8.480  1.00 27.32      A    C   
ATOM    556  C   TYR    70      20.022  74.801   9.857  1.00 23.40      A    C   
ATOM    557  O   TYR    70      20.727  73.903   9.390  1.00 22.25      A    O   
ATOM    558  N   VAL    71      18.722  74.673  10.082  1.00 21.95      A    N   
ATOM    559  CA  VAL    71      18.000  73.541   9.492  1.00 21.52      A    C   
ATOM    560  CB  VAL    71      16.497  73.566   9.837  1.00 20.43      A    C   
ATOM    561  CG1 VAL    71      15.731  72.502   9.067  1.00 22.15      A    C   
ATOM    562  CG2 VAL    71      16.313  73.376  11.329  1.00 21.14      A    C   
ATOM    563  C   VAL    71      18.242  73.599   7.982  1.00 21.13      A    C   
ATOM    564  O   VAL    71      18.112  74.665   7.335  1.00 21.79      A    O   
ATOM    565  N   GLY    72      18.643  72.465   7.427  1.00 20.52      A    N   
ATOM    566  CA  GLY    72      19.027  72.403   6.023  1.00 19.27      A    C   
ATOM    567  C   GLY    72      20.503  72.589   5.709  1.00 18.65      A    C   
ATOM    568  O   GLY    72      20.884  72.392   4.558  1.00 19.42      A    O   
ATOM    569  N   SER    73      21.322  72.979   6.694  1.00 18.32      A    N   
ATOM    570  CA  SER    73      22.768  73.109   6.475  1.00 17.94      A    C   
ATOM    571  CB  SER    73      23.491  73.687   7.681  1.00 19.83      A    C   
ATOM    572  OG  SER    73      23.162  75.054   7.865  1.00 21.16      A    O   
ATOM    573  C   SER    73      23.384  71.758   6.093  1.00 17.98      A    C   
ATOM    574  O   SER    73      23.001  70.712   6.647  1.00 17.46      A    O   
ATOM    575  N   ARG    74      24.267  71.811   5.107  1.00 17.33      A    N   
ATOM    576  CA  ARG    74      24.972  70.629   4.602  1.00 17.00      A    C   
ATOM    577  CB  ARG    74      25.307  70.845   3.121  1.00 17.66      A    C   
ATOM    578  CG  ARG    74      25.490  69.516   2.311  1.00 17.27      A    C   
ATOM    579  CD  ARG    74      24.152  68.716   2.225  1.00 19.00      A    C   
ATOM    580  NE  ARG    74      24.224  67.577   1.272  1.00 19.45      A    N   
ATOM    581  CZ  ARG    74      24.384  66.290   1.601  1.00 22.96      A    C   
ATOM    582  NH1 ARG    74      24.534  65.905   2.872  1.00 18.65      A    N   
ATOM    583  NH2 ARG    74      24.408  65.370   0.631  1.00 20.44      A    N   
ATOM    584  C   ARG    74      26.245  70.424   5.421  1.00 17.93      A    C   
ATOM    585  O   ARG    74      27.115  71.311   5.498  1.00 17.89      A    O   
ATOM    586  N   VAL    75      26.350  69.262   6.065  1.00 17.79      A    N   
ATOM    587  CA  VAL    75      27.437  69.024   7.001  1.00 16.83      A    C   
ATOM    588  CB  VAL    75      26.981  69.171   8.505  1.00 17.62      A    C   
ATOM    589  CG1 VAL    75      26.515  70.620   8.802  1.00 17.43      A    C   
ATOM    590  CG2 VAL    75      25.842  68.163   8.832  1.00 16.70      A    C   
ATOM    591  C   VAL    75      28.041  67.639   6.815  1.00 17.62      A    C   
ATOM    592  O   VAL    75      27.437  66.752   6.187  1.00 17.18      A    O   
ATOM    593  N   VAL    76      29.216  67.480   7.401  1.00 17.40      A    N   
ATOM    594  CA  VAL    76      29.800  66.152   7.639  1.00 18.21      A    C   
ATOM    595  CB  VAL    76      31.244  66.107   7.110  1.00 18.42      A    C   
ATOM    596  CG1 VAL    76      31.983  64.839   7.564  1.00 20.77      A    C   
ATOM    597  CG2 VAL    76      31.257  66.213   5.590  1.00 19.22      A    C   
ATOM    598  C   VAL    76      29.760  65.965   9.149  1.00 18.24      A    C   
ATOM    599  O   VAL    76      30.067  66.894   9.934  1.00 18.16      A    O   
ATOM    600  N   ALA    77      29.360  64.774   9.589  1.00 18.51      A    N   
ATOM    601  CA  ALA    77      29.223  64.565  11.030  1.00 20.54      A    C   
ATOM    602  CB  ALA    77      27.753  64.750  11.474  1.00 20.86      A    C   
ATOM    603  C   ALA    77      29.730  63.185  11.413  1.00 21.89      A    C   
ATOM    604  O   ALA    77      29.783  62.267  10.578  1.00 21.43      A    O   
ATOM    605  N   LYS    78      30.065  63.037  12.684  1.00 23.68      A    N   
ATOM    606  CA  LYS    78      30.467  61.724  13.184  1.00 25.04      A    C   
ATOM    607  CB  LYS    78      31.050  61.874  14.577  1.00 26.30      A    C   
ATOM    608  CG  LYS    78      31.737  60.639  15.086  1.00 29.63      A    C   
ATOM    609  CD  LYS    78      32.168  60.834  16.530  1.00 35.97      A    C   
ATOM    610  CE  LYS    78      33.419  61.715  16.641  1.00 40.00      A    C   
ATOM    611  NZ  LYS    78      34.262  61.335  17.829  1.00 43.09      A    N   
ATOM    612  C   LYS    78      29.228  60.826  13.170  1.00 25.29      A    C   
ATOM    613  O   LYS    78      28.232  61.104  13.820  1.00 24.83      A    O   
ATOM    614  N   TYR    79      29.308  59.759  12.394  1.00 25.82      A    N   
ATOM    615  CA  TYR    79      28.202  58.817  12.184  1.00 26.33      A    C   
ATOM    616  CB  TYR    79      28.216  58.335  10.718  1.00 25.99      A    C   
ATOM    617  CG  TYR    79      27.107  57.390  10.298  1.00 25.73      A    C   
ATOM    618  CD1 TYR    79      26.167  57.778   9.362  1.00 25.64      A    C   
ATOM    619  CE1 TYR    79      25.152  56.927   8.943  1.00 25.11      A    C   
ATOM    620  CZ  TYR    79      25.092  55.636   9.442  1.00 24.97      A    C   
ATOM    621  OH  TYR    79      24.082  54.791   9.022  1.00 26.65      A    O   
ATOM    622  CE2 TYR    79      26.019  55.211  10.374  1.00 26.25      A    C   
ATOM    623  CD2 TYR    79      27.027  56.074  10.794  1.00 27.71      A    C   
ATOM    624  C   TYR    79      28.450  57.647  13.117  1.00 27.65      A    C   
ATOM    625  O   TYR    79      29.509  57.008  13.022  1.00 27.57      A    O   
ATOM    626  N   LYS    80      27.499  57.394  14.023  1.00 28.32      A    N   
ATOM    627  CA  LYS    80      27.613  56.285  14.974  1.00 30.27      A    C   
ATOM    628  CB  LYS    80      28.212  56.765  16.311  1.00 31.32      A    C   
ATOM    629  CG  LYS    80      28.299  55.656  17.366  1.00 34.72      A    C   
ATOM    630  CD  LYS    80      29.620  55.700  18.133  1.00 39.04      A    C   
ATOM    631  CE  LYS    80      29.740  54.526  19.134  1.00 37.43      A    C   
ATOM    632  NZ  LYS    80      30.227  53.238  18.525  1.00 39.93      A    N   
ATOM    633  C   LYS    80      26.245  55.652  15.200  1.00 30.48      A    C   
ATOM    634  O   LYS    80      25.295  56.328  15.629  1.00 29.81      A    O   
ATOM    635  N   ASP    81      26.158  54.349  14.936  1.00 30.78      A    N   
ATOM    636  CA  ASP    81      24.890  53.631  15.101  1.00 31.62      A    C   
ATOM    637  CB  ASP    81      24.290  53.253  13.740  1.00 31.24      A    C   
ATOM    638  CG  ASP    81      25.103  52.198  13.017  1.00 31.99      A    C   
ATOM    639  OD1 ASP    81      26.169  51.811  13.552  1.00 32.44      A    O   
ATOM    640  OD2 ASP    81      24.677  51.755  11.924  1.00 32.57      A    O   
ATOM    641  C   ASP    81      25.032  52.397  15.987  1.00 32.52      A    C   
ATOM    642  O   ASP    81      24.121  51.547  16.021  1.00 32.39      A    O   
ATOM    643  N   GLY    82      26.161  52.303  16.693  1.00 32.60      A    N   
ATOM    644  CA  GLY    82      26.454  51.141  17.539  1.00 33.72      A    C   
ATOM    645  C   GLY    82      27.269  50.072  16.834  1.00 34.07      A    C   
ATOM    646  O   GLY    82      27.990  49.304  17.483  1.00 34.78      A    O   
ATOM    647  N   ASN    83      27.171  50.021  15.509  1.00 33.49      A    N   
ATOM    648  CA  ASN    83      27.859  48.989  14.726  1.00 33.85      A    C   
ATOM    649  CB  ASN    83      26.843  48.201  13.889  1.00 33.92      A    C   
ATOM    650  CG  ASN    83      25.764  47.543  14.744  1.00 35.01      A    C   
ATOM    651  OD1 ASN    83      24.575  47.731  14.504  1.00 36.64      A    O   
ATOM    652  ND2 ASN    83      26.177  46.769  15.737  1.00 32.43      A    N   
ATOM    653  C   ASN    83      28.983  49.490  13.815  1.00 33.94      A    C   
ATOM    654  O   ASN    83      29.738  48.683  13.234  1.00 32.99      A    O   
ATOM    655  N   GLN    84      29.082  50.816  13.679  1.00 33.49      A    N   
ATOM    656  CA  GLN    84      30.076  51.448  12.814  1.00 32.91      A    C   
ATOM    657  CB  GLN    84      29.665  51.336  11.339  1.00 33.50      A    C   
ATOM    658  CG  GLN    84      28.349  52.061  11.017  1.00 33.10      A    C   
ATOM    659  CD  GLN    84      27.745  51.651   9.698  1.00 34.73      A    C   
ATOM    660  OE1 GLN    84      28.441  51.559   8.669  1.00 34.41      A    O   
ATOM    661  NE2 GLN    84      26.424  51.417   9.705  1.00 32.20      A    N   
ATOM    662  C   GLN    84      30.258  52.922  13.193  1.00 32.46      A    C   
ATOM    663  O   GLN    84      29.351  53.546  13.809  1.00 31.29      A    O   
ATOM    664  N   VAL    85      31.432  53.457  12.841  1.00 31.39      A    N   
ATOM    665  CA  VAL    85      31.760  54.887  13.047  1.00 29.91      A    C   
ATOM    666  CB  VAL    85      32.634  55.138  14.313  1.00 30.56      A    C   
ATOM    667  CG1 VAL    85      33.954  54.356  14.277  1.00 30.69      A    C   
ATOM    668  CG2 VAL    85      32.883  56.628  14.515  1.00 30.70      A    C   
ATOM    669  C   VAL    85      32.480  55.446  11.817  1.00 29.15      A    C   
ATOM    670  O   VAL    85      33.440  54.858  11.334  1.00 28.90      A    O   
ATOM    671  N   TRP    86      32.010  56.574  11.307  1.00 27.99      A    N   
ATOM    672  CA  TRP    86      32.633  57.193  10.132  1.00 27.21      A    C   
ATOM    673  CB  TRP    86      31.895  56.749   8.875  1.00 29.50      A    C   
ATOM    674  CG  TRP    86      31.869  55.289   8.620  1.00 32.34      A    C   
ATOM    675  CD1 TRP    86      30.781  54.457   8.669  1.00 34.51      A    C   
ATOM    676  NE1 TRP    86      31.163  53.166   8.344  1.00 35.04      A    N   
ATOM    677  CE2 TRP    86      32.508  53.161   8.074  1.00 34.89      A    C   
ATOM    678  CD2 TRP    86      32.981  54.487   8.232  1.00 32.94      A    C   
ATOM    679  CE3 TRP    86      34.339  54.760   8.001  1.00 33.27      A    C   
ATOM    680  CZ3 TRP    86      35.178  53.713   7.624  1.00 35.48      A    C   
ATOM    681  CH2 TRP    86      34.679  52.401   7.481  1.00 34.06      A    C   
ATOM    682  CZ2 TRP    86      33.351  52.108   7.687  1.00 33.81      A    C   
ATOM    683  C   TRP    86      32.437  58.704  10.237  1.00 25.19      A    C   
ATOM    684  O   TRP    86      31.658  59.149  11.054  1.00 23.63      A    O   
ATOM    685  N   LEU    87      33.125  59.483   9.402  1.00 22.91      A    N   
ATOM    686  CA  LEU    87      32.593  60.818   9.063  1.00 21.62      A    C   
ATOM    687  CB  LEU    87      33.719  61.836   8.862  1.00 21.68      A    C   
ATOM    688  CG  LEU    87      34.587  62.138  10.076  1.00 23.51      A    C   
ATOM    689  CD1 LEU    87      35.641  63.163   9.723  1.00 24.55      A    C   
ATOM    690  CD2 LEU    87      33.716  62.624  11.219  1.00 22.57      A    C   
ATOM    691  C   LEU    87      31.744  60.685   7.778  1.00 21.15      A    C   
ATOM    692  O   LEU    87      32.223  60.192   6.770  1.00 21.15      A    O   
ATOM    693  N   TYR    88      30.488  61.126   7.830  1.00 20.09      A    N   
ATOM    694  CA  TYR    88      29.549  60.888   6.752  1.00 20.91      A    C   
ATOM    695  CB  TYR    88      28.612  59.737   7.164  1.00 21.64      A    C   
ATOM    696  CG  TYR    88      27.992  58.971   6.015  1.00 23.36      A    C   
ATOM    697  CD1 TYR    88      28.713  57.956   5.372  1.00 24.44      A    C   
ATOM    698  CE1 TYR    88      28.156  57.234   4.332  1.00 25.12      A    C   
ATOM    699  CZ  TYR    88      26.864  57.492   3.927  1.00 25.12      A    C   
ATOM    700  OH  TYR    88      26.379  56.750   2.877  1.00 26.59      A    O   
ATOM    701  CE2 TYR    88      26.104  58.495   4.539  1.00 25.18      A    C   
ATOM    702  CD2 TYR    88      26.682  59.225   5.599  1.00 23.61      A    C   
ATOM    703  C   TYR    88      28.743  62.156   6.544  1.00 20.17      A    C   
ATOM    704  O   TYR    88      28.519  62.919   7.489  1.00 19.43      A    O   
ATOM    705  N   ALA    89      28.278  62.383   5.320  1.00 19.08      A    N   
ATOM    706  CA  ALA    89      27.549  63.620   5.027  1.00 19.00      A    C   
ATOM    707  CB  ALA    89      27.634  63.935   3.486  1.00 19.19      A    C   
ATOM    708  C   ALA    89      26.092  63.581   5.475  1.00 18.22      A    C   
ATOM    709  O   ALA    89      25.468  62.507   5.543  1.00 19.28      A    O   
ATOM    710  N   GLY    90      25.519  64.751   5.755  1.00 17.54      A    N   
ATOM    711  CA  GLY    90      24.128  64.808   6.156  1.00 18.43      A    C   
ATOM    712  C   GLY    90      23.606  66.240   6.095  1.00 18.72      A    C   
ATOM    713  O   GLY    90      24.264  67.147   5.553  1.00 19.00      A    O   
ATOM    714  N   ILE    91      22.413  66.417   6.637  1.00 18.87      A    N   
ATOM    715  CA  ILE    91      21.713  67.707   6.687  1.00 19.36      A    C   
ATOM    716  CB  ILE    91      20.453  67.630   5.787  1.00 20.32      A    C   
ATOM    717  CG1 ILE    91      20.861  67.518   4.302  1.00 21.77      A    C   
ATOM    718  CD1 ILE    91      21.004  68.804   3.522  1.00 26.35      A    C   
ATOM    719  CG2 ILE    91      19.454  68.799   6.106  1.00 20.37      A    C   
ATOM    720  C   ILE    91      21.279  67.938   8.132  1.00 19.40      A    C   
ATOM    721  O   ILE    91      20.813  67.005   8.780  1.00 18.69      A    O   
ATOM    722  N   VAL    92      21.495  69.151   8.649  1.00 18.01      A    N   
ATOM    723  CA  VAL    92      21.017  69.514   9.981  1.00 18.58      A    C   
ATOM    724  CB  VAL    92      21.575  70.896  10.374  1.00 17.01      A    C   
ATOM    725  CG1 VAL    92      20.943  71.377  11.683  1.00 19.99      A    C   
ATOM    726  CG2 VAL    92      23.102  70.864  10.453  1.00 20.64      A    C   
ATOM    727  C   VAL    92      19.461  69.535  10.013  1.00 18.26      A    C   
ATOM    728  O   VAL    92      18.820  70.223   9.213  1.00 18.42      A    O   
ATOM    729  N   ALA    93      18.876  68.737  10.906  1.00 18.59      A    N   
ATOM    730  CA  ALA    93      17.426  68.625  11.053  1.00 19.19      A    C   
ATOM    731  CB  ALA    93      17.036  67.158  11.262  1.00 19.13      A    C   
ATOM    732  C   ALA    93      16.923  69.445  12.246  1.00 19.92      A    C   
ATOM    733  O   ALA    93      15.770  69.888  12.253  1.00 20.56      A    O   
ATOM    734  N   GLU    94      17.754  69.565  13.285  1.00 20.37      A    N   
ATOM    735  CA  GLU    94      17.407  70.387  14.467  1.00 22.21      A    C   
ATOM    736  CB  GLU    94      16.824  69.575  15.638  1.00 21.92      A    C   
ATOM    737  CG  GLU    94      15.570  68.798  15.339  1.00 24.03      A    C   
ATOM    738  CD  GLU    94      15.083  67.935  16.517  1.00 23.98      A    C   
ATOM    739  OE1 GLU    94      15.735  67.866  17.615  1.00 23.90      A    O   
ATOM    740  OE2 GLU    94      14.011  67.320  16.319  1.00 24.28      A    O   
ATOM    741  C   GLU    94      18.655  71.021  14.971  1.00 22.23      A    C   
ATOM    742  O   GLU    94      19.733  70.452  14.883  1.00 21.59      A    O   
ATOM    743  N   THR    95      18.504  72.223  15.510  1.00 23.37      A    N   
ATOM    744  CA  THR    95      19.605  72.908  16.162  1.00 24.74      A    C   
ATOM    745  CB  THR    95      19.618  74.392  15.730  1.00 24.84      A    C   
ATOM    746  OG1 THR    95      18.333  74.944  15.994  1.00 24.78      A    O   
ATOM    747  CG2 THR    95      19.917  74.515  14.214  1.00 24.52      A    C   
ATOM    748  C   THR    95      19.341  72.746  17.690  1.00 25.60      A    C   
ATOM    749  O   THR    95      18.224  72.351  18.083  1.00 25.69      A    O   
ATOM    750  N   PRO    96      20.352  73.024  18.544  1.00 26.69      A    N   
ATOM    751  CA  PRO    96      20.209  72.866  19.997  1.00 27.59      A    C   
ATOM    752  CB  PRO    96      21.550  73.368  20.548  1.00 28.22      A    C   
ATOM    753  CG  PRO    96      22.512  73.152  19.456  1.00 27.67      A    C   
ATOM    754  CD  PRO    96      21.734  73.412  18.185  1.00 26.43      A    C   
ATOM    755  C   PRO    96      19.041  73.623  20.635  1.00 28.84      A    C   
ATOM    756  O   PRO    96      18.868  74.825  20.420  1.00 30.06      A    O   
ATOM    757  N   ASN    97      18.241  72.908  21.412  1.00 29.07      A    N   
ATOM    758  CA  ASN    97      17.179  73.538  22.188  1.00 29.93      A    C   
ATOM    759  CB  ASN    97      15.920  73.783  21.328  1.00 29.42      A    C   
ATOM    760  CG  ASN    97      15.394  72.510  20.672  1.00 30.70      A    C   
ATOM    761  OD1 ASN    97      15.324  71.460  21.308  1.00 30.18      A    O   
ATOM    762  ND2 ASN    97      15.002  72.607  19.399  1.00 29.03      A    N   
ATOM    763  C   ASN    97      16.891  72.722  23.445  1.00 30.34      A    C   
ATOM    764  O   ASN    97      17.505  71.685  23.675  1.00 29.04      A    O   
ATOM    765  N   VAL    98      15.965  73.204  24.272  1.00 31.73      A    N   
ATOM    766  CA  VAL    98      15.640  72.532  25.525  1.00 33.02      A    C   
ATOM    767  CB  VAL    98      14.605  73.351  26.346  1.00 33.18      A    C   
ATOM    768  CG1 VAL    98      14.147  72.598  27.596  1.00 35.17      A    C   
ATOM    769  CG2 VAL    98      15.185  74.706  26.731  1.00 34.25      A    C   
ATOM    770  C   VAL    98      15.131  71.118  25.250  1.00 32.86      A    C   
ATOM    771  O   VAL    98      15.522  70.166  25.927  1.00 33.40      A    O   
ATOM    772  N   LYS    99      14.301  70.976  24.221  1.00 32.93      A    N   
ATOM    773  CA  LYS    99      13.624  69.707  23.974  1.00 32.74      A    C   
ATOM    774  CB  LYS    99      12.379  69.899  23.096  1.00 33.01      A    C   
ATOM    775  CG  LYS    99      11.129  70.218  23.941  1.00 34.21      A    C   
ATOM    776  CD  LYS    99       9.923  70.720  23.143  1.00 34.77      A    C   
ATOM    777  CE  LYS    99       8.688  70.818  24.070  1.00 37.90      A    C   
ATOM    778  NZ  LYS    99       7.545  71.581  23.454  1.00 40.85      A    N   
ATOM    779  C   LYS    99      14.549  68.594  23.467  1.00 31.32      A    C   
ATOM    780  O   LYS    99      14.262  67.423  23.707  1.00 31.38      A    O   
ATOM    781  N   ASN   100      15.666  68.953  22.812  1.00 29.61      A    N   
ATOM    782  CA  ASN   100      16.681  67.959  22.394  1.00 27.96      A    C   
ATOM    783  CB  ASN   100      16.992  68.051  20.876  1.00 27.58      A    C   
ATOM    784  CG  ASN   100      17.624  69.379  20.464  1.00 27.24      A    C   
ATOM    785  OD1 ASN   100      18.359  70.023  21.231  1.00 26.88      A    O   
ATOM    786  ND2 ASN   100      17.353  69.782  19.229  1.00 26.73      A    N   
ATOM    787  C   ASN   100      17.961  67.944  23.241  1.00 27.87      A    C   
ATOM    788  O   ASN   100      18.972  67.341  22.874  1.00 27.07      A    O   
ATOM    789  N   LYS   101      17.894  68.594  24.406  1.00 27.69      A    N   
ATOM    790  CA  LYS   101      19.034  68.690  25.323  1.00 27.96      A    C   
ATOM    791  CB  LYS   101      19.375  67.329  25.920  1.00 28.57      A    C   
ATOM    792  CG  LYS   101      18.298  66.727  26.808  1.00 33.38      A    C   
ATOM    793  CD  LYS   101      18.907  65.617  27.637  1.00 37.44      A    C   
ATOM    794  CE  LYS   101      18.004  64.411  27.704  1.00 40.30      A    C   
ATOM    795  NZ  LYS   101      18.460  63.482  28.785  1.00 42.55      A    N   
ATOM    796  C   LYS   101      20.265  69.307  24.648  1.00 26.33      A    C   
ATOM    797  O   LYS   101      21.385  68.859  24.834  1.00 26.46      A    O   
ATOM    798  N   LEU   102      20.021  70.338  23.849  1.00 26.23      A    N   
ATOM    799  CA  LEU   102      21.077  71.148  23.245  1.00 26.59      A    C   
ATOM    800  CB  LEU   102      21.869  71.929  24.335  1.00 27.55      A    C   
ATOM    801  CG  LEU   102      21.007  72.854  25.203  1.00 29.10      A    C   
ATOM    802  CD1 LEU   102      21.859  73.507  26.301  1.00 31.70      A    C   
ATOM    803  CD2 LEU   102      20.286  73.936  24.387  1.00 29.74      A    C   
ATOM    804  C   LEU   102      22.001  70.347  22.323  1.00 24.80      A    C   
ATOM    805  O   LEU   102      23.223  70.453  22.393  1.00 25.60      A    O   
ATOM    806  N   ARG   103      21.393  69.533  21.466  1.00 23.82      A    N   
ATOM    807  CA  ARG   103      22.128  68.765  20.481  1.00 22.44      A    C   
ATOM    808  CB  ARG   103      21.964  67.253  20.719  1.00 22.22      A    C   
ATOM    809  CG  ARG   103      22.697  66.752  21.958  1.00 23.32      A    C   
ATOM    810  CD  ARG   103      22.191  65.339  22.355  1.00 22.56      A    C   
ATOM    811  NE  ARG   103      20.761  65.326  22.643  1.00 24.24      A    N   
ATOM    812  CZ  ARG   103      20.011  64.218  22.711  1.00 24.25      A    C   
ATOM    813  NH1 ARG   103      20.553  63.021  22.488  1.00 26.17      A    N   
ATOM    814  NH2 ARG   103      18.714  64.310  22.983  1.00 25.74      A    N   
ATOM    815  C   ARG   103      21.660  69.141  19.083  1.00 21.49      A    C   
ATOM    816  O   ARG   103      20.669  69.837  18.940  1.00 22.66      A    O   
ATOM    817  N   PHE   104      22.410  68.711  18.064  1.00 21.03      A    N   
ATOM    818  CA  PHE   104      21.994  68.853  16.670  1.00 19.77      A    C   
ATOM    819  CB  PHE   104      23.201  69.215  15.779  1.00 19.90      A    C   
ATOM    820  CG  PHE   104      23.730  70.602  16.027  1.00 21.91      A    C   
ATOM    821  CD1 PHE   104      23.291  71.669  15.249  1.00 22.77      A    C   
ATOM    822  CE1 PHE   104      23.800  72.975  15.498  1.00 23.30      A    C   
ATOM    823  CZ  PHE   104      24.693  73.177  16.531  1.00 21.62      A    C   
ATOM    824  CE2 PHE   104      25.125  72.117  17.319  1.00 23.79      A    C   
ATOM    825  CD2 PHE   104      24.630  70.834  17.067  1.00 23.41      A    C   
ATOM    826  C   PHE   104      21.477  67.507  16.178  1.00 19.73      A    C   
ATOM    827  O   PHE   104      22.151  66.508  16.353  1.00 20.07      A    O   
ATOM    828  N   LEU   105      20.318  67.493  15.552  1.00 17.95      A    N   
ATOM    829  CA  LEU   105      19.837  66.264  14.916  1.00 17.90      A    C   
ATOM    830  CB  LEU   105      18.320  66.216  14.910  1.00 18.16      A    C   
ATOM    831  CG  LEU   105      17.694  64.940  14.313  1.00 17.79      A    C   
ATOM    832  CD1 LEU   105      18.245  63.687  15.017  1.00 19.70      A    C   
ATOM    833  CD2 LEU   105      16.159  64.979  14.382  1.00 19.00      A    C   
ATOM    834  C   LEU   105      20.364  66.286  13.490  1.00 18.31      A    C   
ATOM    835  O   LEU   105      20.174  67.280  12.779  1.00 19.80      A    O   
ATOM    836  N   ILE   106      21.004  65.193  13.076  1.00 18.01      A    N   
ATOM    837  CA  ILE   106      21.496  65.051  11.691  1.00 18.24      A    C   
ATOM    838  CB  ILE   106      23.019  64.709  11.662  1.00 18.24      A    C   
ATOM    839  CG1 ILE   106      23.818  65.708  12.536  1.00 21.43      A    C   
ATOM    840  CD1 ILE   106      23.603  67.212  12.165  1.00 20.23      A    C   
ATOM    841  CG2 ILE   106      23.560  64.643  10.187  1.00 18.52      A    C   
ATOM    842  C   ILE   106      20.721  63.974  10.948  1.00 18.58      A    C   
ATOM    843  O   ILE   106      20.594  62.875  11.461  1.00 19.61      A    O   
ATOM    844  N   PHE   107      20.233  64.309   9.749  1.00 18.23      A    N   
ATOM    845  CA  PHE   107      19.712  63.323   8.776  1.00 19.45      A    C   
ATOM    846  CB  PHE   107      18.493  63.888   8.039  1.00 20.44      A    C   
ATOM    847  CG  PHE   107      17.256  64.047   8.896  1.00 18.93      A    C   
ATOM    848  CD1 PHE   107      17.137  63.401  10.134  1.00 21.99      A    C   
ATOM    849  CE1 PHE   107      15.979  63.542  10.907  1.00 22.41      A    C   
ATOM    850  CZ  PHE   107      14.932  64.328  10.444  1.00 21.32      A    C   
ATOM    851  CE2 PHE   107      15.022  64.971   9.224  1.00 21.50      A    C   
ATOM    852  CD2 PHE   107      16.194  64.835   8.452  1.00 19.35      A    C   
ATOM    853  C   PHE   107      20.825  63.019   7.763  1.00 19.80      A    C   
ATOM    854  O   PHE   107      21.149  63.853   6.896  1.00 19.67      A    O   
ATOM    855  N   PHE   108      21.428  61.838   7.908  1.00 19.44      A    N   
ATOM    856  CA  PHE   108      22.551  61.424   7.058  1.00 18.55      A    C   
ATOM    857  CB  PHE   108      23.313  60.268   7.722  1.00 19.60      A    C   
ATOM    858  CG  PHE   108      24.136  60.686   8.907  1.00 19.49      A    C   
ATOM    859  CD1 PHE   108      25.407  61.287   8.736  1.00 18.81      A    C   
ATOM    860  CE1 PHE   108      26.191  61.652   9.836  1.00 19.08      A    C   
ATOM    861  CZ  PHE   108      25.677  61.432  11.135  1.00 20.48      A    C   
ATOM    862  CE2 PHE   108      24.438  60.854  11.301  1.00 19.72      A    C   
ATOM    863  CD2 PHE   108      23.654  60.499  10.199  1.00 18.79      A    C   
ATOM    864  C   PHE   108      22.040  61.008   5.676  1.00 19.19      A    C   
ATOM    865  O   PHE   108      20.847  60.681   5.534  1.00 18.68      A    O   
ATOM    866  N   ASP   109      22.932  61.029   4.675  1.00 19.03      A    N   
ATOM    867  CA  ASP   109      22.556  60.756   3.273  1.00 20.13      A    C   
ATOM    868  CB  ASP   109      23.793  60.883   2.374  1.00 19.75      A    C   
ATOM    869  CG  ASP   109      24.227  62.330   2.164  1.00 18.93      A    C   
ATOM    870  OD1 ASP   109      23.777  63.224   2.906  1.00 20.78      A    O   
ATOM    871  OD2 ASP   109      24.995  62.556   1.207  1.00 21.40      A    O   
ATOM    872  C   ASP   109      21.955  59.366   3.028  1.00 21.28      A    C   
ATOM    873  O   ASP   109      21.234  59.131   2.038  1.00 21.96      A    O   
ATOM    874  N   ASP   110      22.284  58.449   3.915  1.00 21.54      A    N   
ATOM    875  CA  ASP   110      21.807  57.067   3.800  1.00 22.57      A    C   
ATOM    876  CB  ASP   110      22.910  56.134   4.328  1.00 22.39      A    C   
ATOM    877  CG  ASP   110      23.011  56.153   5.848  1.00 25.68      A    C   
ATOM    878  OD1 ASP   110      22.652  57.188   6.460  1.00 23.45      A    O   
ATOM    879  OD2 ASP   110      23.432  55.122   6.434  1.00 27.92      A    O   
ATOM    880  C   ASP   110      20.500  56.820   4.542  1.00 23.52      A    C   
ATOM    881  O   ASP   110      20.031  55.662   4.627  1.00 23.49      A    O   
ATOM    882  N   GLY   111      19.925  57.881   5.108  1.00 22.29      A    N   
ATOM    883  CA  GLY   111      18.655  57.784   5.807  1.00 23.31      A    C   
ATOM    884  C   GLY   111      18.712  57.653   7.318  1.00 22.94      A    C   
ATOM    885  O   GLY   111      17.675  57.755   7.987  1.00 23.78      A    O   
ATOM    886  N   TYR   112      19.902  57.430   7.847  1.00 22.27      A    N   
ATOM    887  CA  TYR   112      20.096  57.355   9.292  1.00 22.81      A    C   
ATOM    888  CB  TYR   112      21.463  56.763   9.582  1.00 23.78      A    C   
ATOM    889  CG  TYR   112      21.725  56.516  11.046  1.00 26.13      A    C   
ATOM    890  CD1 TYR   112      20.862  55.708  11.797  1.00 29.13      A    C   
ATOM    891  CE1 TYR   112      21.098  55.488  13.163  1.00 27.46      A    C   
ATOM    892  CZ  TYR   112      22.198  56.069  13.761  1.00 27.51      A    C   
ATOM    893  OH  TYR   112      22.420  55.852  15.100  1.00 30.35      A    O   
ATOM    894  CE2 TYR   112      23.072  56.865  13.041  1.00 27.49      A    C   
ATOM    895  CD2 TYR   112      22.819  57.092  11.675  1.00 26.42      A    C   
ATOM    896  C   TYR   112      19.917  58.739   9.949  1.00 22.38      A    C   
ATOM    897  O   TYR   112      20.238  59.773   9.339  1.00 22.60      A    O   
ATOM    898  N   ALA   113      19.343  58.749  11.151  1.00 21.28      A    N   
ATOM    899  CA  ALA   113      19.215  59.980  11.943  1.00 21.48      A    C   
ATOM    900  CB  ALA   113      17.757  60.370  12.116  1.00 21.94      A    C   
ATOM    901  C   ALA   113      19.877  59.810  13.304  1.00 21.88      A    C   
ATOM    902  O   ALA   113      19.699  58.787  13.968  1.00 21.02      A    O   
ATOM    903  N   SER   114      20.640  60.818  13.722  1.00 21.78      A    N   
ATOM    904  CA  SER   114      21.352  60.751  14.979  1.00 21.51      A    C   
ATOM    905  CB  SER   114      22.715  60.124  14.754  1.00 22.32      A    C   
ATOM    906  OG  SER   114      23.364  59.910  15.980  1.00 27.59      A    O   
ATOM    907  C   SER   114      21.546  62.143  15.592  1.00 21.14      A    C   
ATOM    908  O   SER   114      21.672  63.119  14.852  1.00 20.10      A    O   
ATOM    909  N   TYR   115      21.582  62.213  16.927  1.00 20.88      A    N   
ATOM    910  CA  TYR   115      21.952  63.448  17.629  1.00 20.97      A    C   
ATOM    911  CB  TYR   115      21.278  63.554  19.018  1.00 21.23      A    C   
ATOM    912  CG  TYR   115      19.838  64.050  18.967  1.00 19.98      A    C   
ATOM    913  CD1 TYR   115      19.542  65.370  18.593  1.00 19.69      A    C   
ATOM    914  CE1 TYR   115      18.222  65.828  18.545  1.00 20.06      A    C   
ATOM    915  CZ  TYR   115      17.174  64.937  18.862  1.00 21.17      A    C   
ATOM    916  OH  TYR   115      15.870  65.366  18.796  1.00 21.32      A    O   
ATOM    917  CE2 TYR   115      17.449  63.640  19.226  1.00 20.57      A    C   
ATOM    918  CD2 TYR   115      18.761  63.199  19.282  1.00 21.00      A    C   
ATOM    919  C   TYR   115      23.473  63.477  17.793  1.00 21.83      A    C   
ATOM    920  O   TYR   115      24.095  62.473  18.199  1.00 21.57      A    O   
ATOM    921  N   VAL   116      24.071  64.618  17.451  1.00 20.72      A    N   
ATOM    922  CA  VAL   116      25.490  64.836  17.682  1.00 21.52      A    C   
ATOM    923  CB  VAL   116      26.297  64.797  16.351  1.00 21.69      A    C   
ATOM    924  CG1 VAL   116      26.012  63.516  15.594  1.00 22.00      A    C   
ATOM    925  CG2 VAL   116      25.990  66.036  15.481  1.00 22.31      A    C   
ATOM    926  C   VAL   116      25.710  66.194  18.357  1.00 21.61      A    C   
ATOM    927  O   VAL   116      24.776  66.992  18.487  1.00 20.30      A    O   
ATOM    928  N   THR   117      26.942  66.447  18.778  1.00 22.89      A    N   
ATOM    929  CA  THR   117      27.296  67.712  19.389  1.00 23.98      A    C   
ATOM    930  CB  THR   117      28.271  67.492  20.584  1.00 24.31      A    C   
ATOM    931  OG1 THR   117      29.505  66.937  20.108  1.00 25.79      A    O   
ATOM    932  CG2 THR   117      27.640  66.559  21.602  1.00 24.61      A    C   
ATOM    933  C   THR   117      27.979  68.611  18.354  1.00 24.21      A    C   
ATOM    934  O   THR   117      28.440  68.135  17.314  1.00 23.79      A    O   
ATOM    935  N   GLN   118      28.042  69.908  18.662  1.00 25.01      A    N   
ATOM    936  CA  GLN   118      28.759  70.892  17.857  1.00 26.28      A    C   
ATOM    937  CB  GLN   118      28.834  72.224  18.630  1.00 26.49      A    C   
ATOM    938  CG  GLN   118      29.102  73.432  17.704  1.00 28.99      A    C   
ATOM    939  CD  GLN   118      28.644  74.782  18.288  1.00 28.55      A    C   
ATOM    940  OE1 GLN   118      27.694  74.868  19.095  1.00 31.72      A    O   
ATOM    941  NE2 GLN   118      29.300  75.849  17.842  1.00 30.57      A    N   
ATOM    942  C   GLN   118      30.166  70.460  17.453  1.00 26.10      A    C   
ATOM    943  O   GLN   118      30.604  70.741  16.331  1.00 26.56      A    O   
ATOM    944  N   SER   119      30.868  69.776  18.359  1.00 25.49      A    N   
ATOM    945  CA  SER   119      32.230  69.330  18.137  1.00 26.07      A    C   
ATOM    946  CB  SER   119      32.930  69.095  19.468  1.00 26.47      A    C   
ATOM    947  OG  SER   119      32.300  68.030  20.152  1.00 29.78      A    O   
ATOM    948  C   SER   119      32.325  68.073  17.247  1.00 25.32      A    C   
ATOM    949  O   SER   119      33.412  67.566  17.000  1.00 25.85      A    O   
ATOM    950  N   GLU   120      31.179  67.615  16.747  1.00 24.18      A    N   
ATOM    951  CA  GLU   120      31.116  66.445  15.866  1.00 23.24      A    C   
ATOM    952  CB  GLU   120      30.198  65.362  16.461  1.00 21.92      A    C   
ATOM    953  CG  GLU   120      30.872  64.718  17.683  1.00 24.83      A    C   
ATOM    954  CD  GLU   120      29.976  63.851  18.566  1.00 26.58      A    C   
ATOM    955  OE1 GLU   120      28.735  63.931  18.509  1.00 27.17      A    O   
ATOM    956  OE2 GLU   120      30.547  63.115  19.393  1.00 32.52      A    O   
ATOM    957  C   GLU   120      30.678  66.813  14.455  1.00 22.67      A    C   
ATOM    958  O   GLU   120      30.428  65.921  13.652  1.00 22.73      A    O   
ATOM    959  N   LEU   121      30.644  68.113  14.154  1.00 21.86      A    N   
ATOM    960  CA  LEU   121      30.081  68.640  12.900  1.00 22.32      A    C   
ATOM    961  CB  LEU   121      28.914  69.604  13.213  1.00 23.01      A    C   
ATOM    962  CG  LEU   121      27.589  68.955  13.609  1.00 25.02      A    C   
ATOM    963  CD1 LEU   121      26.520  70.005  13.897  1.00 27.23      A    C   
ATOM    964  CD2 LEU   121      27.135  68.057  12.487  1.00 26.86      A    C   
ATOM    965  C   LEU   121      31.130  69.442  12.141  1.00 21.96      A    C   
ATOM    966  O   LEU   121      31.931  70.166  12.758  1.00 22.86      A    O   
ATOM    967  N   TYR   122      31.109  69.324  10.817  1.00 20.66      A    N   
ATOM    968  CA  TYR   122      31.995  70.095   9.935  1.00 20.39      A    C   
ATOM    969  CB  TYR   122      33.106  69.202   9.361  1.00 21.52      A    C   
ATOM    970  CG  TYR   122      33.919  68.457  10.394  1.00 21.82      A    C   
ATOM    971  CD1 TYR   122      35.110  68.972  10.841  1.00 25.09      A    C   
ATOM    972  CE1 TYR   122      35.887  68.290  11.791  1.00 25.95      A    C   
ATOM    973  CZ  TYR   122      35.457  67.084  12.272  1.00 26.50      A    C   
ATOM    974  OH  TYR   122      36.239  66.452  13.220  1.00 28.88      A    O   
ATOM    975  CE2 TYR   122      34.259  66.531  11.841  1.00 25.16      A    C   
ATOM    976  CD2 TYR   122      33.491  67.216  10.900  1.00 24.29      A    C   
ATOM    977  C   TYR   122      31.184  70.648   8.769  1.00 19.68      A    C   
ATOM    978  O   TYR   122      30.352  69.936   8.202  1.00 20.71      A    O   
ATOM    979  N   PRO   123      31.413  71.908   8.387  1.00 18.87      A    N   
ATOM    980  CA  PRO   123      30.582  72.459   7.325  1.00 18.79      A    C   
ATOM    981  CB  PRO   123      30.621  73.994   7.610  1.00 19.35      A    C   
ATOM    982  CG  PRO   123      31.884  74.215   8.380  1.00 19.92      A    C   
ATOM    983  CD  PRO   123      32.431  72.876   8.864  1.00 19.87      A    C   
ATOM    984  C   PRO   123      31.098  72.099   5.916  1.00 17.69      A    C   
ATOM    985  O   PRO   123      32.281  72.202   5.666  1.00 18.01      A    O   
ATOM    986  N   ILE   124      30.208  71.669   5.017  1.00 17.52      A    N   
ATOM    987  CA  ILE   124      30.613  71.418   3.602  1.00 17.49      A    C   
ATOM    988  CB  ILE   124      29.547  70.503   2.860  1.00 18.21      A    C   
ATOM    989  CG1 ILE   124      29.892  69.033   3.170  1.00 19.81      A    C   
ATOM    990  CD1 ILE   124      28.803  68.039   3.091  1.00 25.49      A    C   
ATOM    991  CG2 ILE   124      29.603  70.735   1.377  1.00 20.25      A    C   
ATOM    992  C   ILE   124      30.929  72.786   2.943  1.00 17.92      A    C   
ATOM    993  O   ILE   124      30.273  73.830   3.294  1.00 18.39      A    O   
ATOM    994  N   CYS   125      31.978  72.822   2.112  1.00 17.68      A    N   
ATOM    995  CA  CYS   125      32.548  74.113   1.671  1.00 17.92      A    C   
ATOM    996  CB  CYS   125      33.907  73.922   0.988  1.00 17.66      A    C   
ATOM    997  SG  CYS   125      35.142  73.175   2.086  1.00 18.72      A    S   
ATOM    998  C   CYS   125      31.614  74.859   0.748  1.00 18.26      A    C   
ATOM    999  O   CYS   125      31.352  76.064   0.931  1.00 20.07      A    O   
ATOM   1000  N   ARG   126      31.131  74.155  -0.259  1.00 18.14      A    N   
ATOM   1001  CA  ARG   126      30.365  74.799  -1.315  1.00 18.10      A    C   
ATOM   1002  CB  ARG   126      31.192  74.868  -2.615  1.00 18.44      A    C   
ATOM   1003  CG  ARG   126      32.495  75.658  -2.518  1.00 19.05      A    C   
ATOM   1004  CD  ARG   126      32.271  77.142  -2.331  1.00 20.38      A    C   
ATOM   1005  NE  ARG   126      33.548  77.837  -2.192  1.00 20.14      A    N   
ATOM   1006  CZ  ARG   126      34.067  78.238  -1.031  1.00 20.93      A    C   
ATOM   1007  NH1 ARG   126      33.427  78.009   0.125  1.00 23.80      A    N   
ATOM   1008  NH2 ARG   126      35.252  78.854  -1.019  1.00 20.37      A    N   
ATOM   1009  C   ARG   126      29.055  74.018  -1.494  1.00 18.61      A    C   
ATOM   1010  O   ARG   126      28.899  73.257  -2.477  1.00 17.58      A    O   
ATOM   1011  N   PRO   127      28.109  74.186  -0.539  1.00 18.84      A    N   
ATOM   1012  CA  PRO   127      26.842  73.404  -0.634  1.00 18.55      A    C   
ATOM   1013  CB  PRO   127      26.113  73.756   0.654  1.00 19.73      A    C   
ATOM   1014  CG  PRO   127      26.657  75.124   1.044  1.00 18.71      A    C   
ATOM   1015  CD  PRO   127      28.121  75.081   0.641  1.00 18.69      A    C   
ATOM   1016  C   PRO   127      26.010  73.887  -1.797  1.00 19.20      A    C   
ATOM   1017  O   PRO   127      26.129  75.047  -2.224  1.00 18.13      A    O   
ATOM   1018  N   LEU   128      25.135  73.024  -2.310  1.00 18.93      A    N   
ATOM   1019  CA  LEU   128      24.250  73.469  -3.375  1.00 19.11      A    C   
ATOM   1020  CB  LEU   128      23.562  72.259  -4.019  1.00 19.11      A    C   
ATOM   1021  CG  LEU   128      24.451  71.206  -4.694  1.00 20.78      A    C   
ATOM   1022  CD1 LEU   128      23.541  70.096  -5.243  1.00 21.21      A    C   
ATOM   1023  CD2 LEU   128      25.197  71.837  -5.836  1.00 22.11      A    C   
ATOM   1024  C   LEU   128      23.213  74.420  -2.799  1.00 19.10      A    C   
ATOM   1025  O   LEU   128      22.949  74.400  -1.591  1.00 20.50      A    O   
ATOM   1026  N   LYS   129      22.620  75.247  -3.675  1.00 18.83      A    N   
ATOM   1027  CA  LYS   129      21.558  76.183  -3.288  1.00 18.96      A    C   
ATOM   1028  CB  LYS   129      20.994  76.873  -4.541  1.00 19.23      A    C   
ATOM   1029  CG  LYS   129      19.853  77.869  -4.270  1.00 19.25      A    C   
ATOM   1030  CD  LYS   129      19.650  78.699  -5.537  1.00 22.12      A    C   
ATOM   1031  CE  LYS   129      18.444  79.611  -5.413  1.00 22.73      A    C   
ATOM   1032  NZ  LYS   129      18.260  80.497  -6.633  1.00 22.80      A    N   
ATOM   1033  C   LYS   129      20.437  75.497  -2.535  1.00 18.59      A    C   
ATOM   1034  O   LYS   129      20.030  75.954  -1.468  1.00 19.18      A    O   
ATOM   1035  N   LYS   130      19.946  74.400  -3.110  1.00 18.19      A    N   
ATOM   1036  CA  LYS   130      19.038  73.477  -2.413  1.00 18.79      A    C   
ATOM   1037  CB  LYS   130      17.961  72.983  -3.372  1.00 18.69      A    C   
ATOM   1038  CG  LYS   130      17.023  74.108  -3.796  1.00 19.99      A    C   
ATOM   1039  CD  LYS   130      15.999  73.586  -4.800  1.00 20.29      A    C   
ATOM   1040  CE  LYS   130      15.116  74.729  -5.315  1.00 22.81      A    C   
ATOM   1041  NZ  LYS   130      14.194  74.263  -6.425  1.00 20.82      A    N   
ATOM   1042  C   LYS   130      19.919  72.352  -1.906  1.00 18.63      A    C   
ATOM   1043  O   LYS   130      20.343  71.485  -2.658  1.00 18.95      A    O   
ATOM   1044  N   THR   131      20.247  72.432  -0.626  1.00 19.22      A    N   
ATOM   1045  CA  THR   131      21.343  71.635  -0.068  1.00 19.50      A    C   
ATOM   1046  CB  THR   131      21.516  71.942   1.415  1.00 19.06      A    C   
ATOM   1047  OG1 THR   131      20.242  71.896   2.065  1.00 20.82      A    O   
ATOM   1048  CG2 THR   131      22.159  73.328   1.589  1.00 20.04      A    C   
ATOM   1049  C   THR   131      21.141  70.138  -0.222  1.00 19.62      A    C   
ATOM   1050  O   THR   131      22.093  69.410  -0.321  1.00 19.97      A    O   
ATOM   1051  N   TRP   132      19.884  69.697  -0.211  1.00 21.04      A    N   
ATOM   1052  CA  TRP   132      19.557  68.276  -0.337  1.00 21.89      A    C   
ATOM   1053  CB  TRP   132      18.090  68.042   0.107  1.00 22.11      A    C   
ATOM   1054  CG  TRP   132      17.147  68.950  -0.635  1.00 23.44      A    C   
ATOM   1055  CD1 TRP   132      16.566  68.719  -1.849  1.00 23.59      A    C   
ATOM   1056  NE1 TRP   132      15.786  69.791  -2.211  1.00 22.49      A    N   
ATOM   1057  CE2 TRP   132      15.881  70.749  -1.239  1.00 23.16      A    C   
ATOM   1058  CD2 TRP   132      16.737  70.253  -0.234  1.00 21.91      A    C   
ATOM   1059  CE3 TRP   132      17.008  71.056   0.889  1.00 23.11      A    C   
ATOM   1060  CZ3 TRP   132      16.420  72.329   0.959  1.00 23.36      A    C   
ATOM   1061  CH2 TRP   132      15.564  72.785  -0.059  1.00 23.08      A    C   
ATOM   1062  CZ2 TRP   132      15.283  72.014  -1.160  1.00 22.78      A    C   
ATOM   1063  C   TRP   132      19.752  67.710  -1.748  1.00 21.73      A    C   
ATOM   1064  O   TRP   132      19.666  66.496  -1.929  1.00 22.50      A    O   
ATOM   1065  N   GLU   133      19.976  68.558  -2.760  1.00 21.66      A    N   
ATOM   1066  CA  GLU   133      19.959  68.059  -4.133  1.00 21.34      A    C   
ATOM   1067  CB  GLU   133      19.833  69.185  -5.165  1.00 21.61      A    C   
ATOM   1068  CG  GLU   133      18.438  69.715  -5.298  1.00 22.64      A    C   
ATOM   1069  CD  GLU   133      18.315  70.716  -6.432  1.00 23.80      A    C   
ATOM   1070  OE1 GLU   133      19.347  71.172  -6.944  1.00 23.45      A    O   
ATOM   1071  OE2 GLU   133      17.173  71.039  -6.811  1.00 26.15      A    O   
ATOM   1072  C   GLU   133      21.103  67.114  -4.503  1.00 21.32      A    C   
ATOM   1073  O   GLU   133      21.043  66.451  -5.546  1.00 21.86      A    O   
ATOM   1074  N   ASP   134      22.143  67.042  -3.670  1.00 21.24      A    N   
ATOM   1075  CA  ASP   134      23.235  66.119  -3.962  1.00 22.25      A    C   
ATOM   1076  CB  ASP   134      24.607  66.803  -3.798  1.00 22.54      A    C   
ATOM   1077  CG  ASP   134      24.808  67.381  -2.405  1.00 21.08      A    C   
ATOM   1078  OD1 ASP   134      23.904  67.173  -1.568  1.00 20.87      A    O   
ATOM   1079  OD2 ASP   134      25.867  68.013  -2.140  1.00 20.84      A    O   
ATOM   1080  C   ASP   134      23.114  64.839  -3.116  1.00 23.00      A    C   
ATOM   1081  O   ASP   134      24.078  64.081  -3.000  1.00 24.24      A    O   
ATOM   1082  N   ILE   135      21.940  64.627  -2.520  1.00 23.19      A    N   
ATOM   1083  CA  ILE   135      21.614  63.345  -1.869  1.00 23.87      A    C   
ATOM   1084  CB  ILE   135      20.478  63.494  -0.830  1.00 23.06      A    C   
ATOM   1085  CG1 ILE   135      20.931  64.407   0.322  1.00 23.49      A    C   
ATOM   1086  CD1 ILE   135      19.824  64.761   1.305  1.00 23.82      A    C   
ATOM   1087  CG2 ILE   135      20.058  62.119  -0.307  1.00 22.41      A    C   
ATOM   1088  C   ILE   135      21.209  62.368  -2.970  1.00 25.62      A    C   
ATOM   1089  O   ILE   135      20.214  62.601  -3.676  1.00 25.83      A    O   
ATOM   1090  N   GLU   136      21.974  61.291  -3.116  1.00 28.22      A    N   
ATOM   1091  CA  GLU   136      21.847  60.407  -4.299  1.00 31.84      A    C   
ATOM   1092  CB  GLU   136      23.002  59.407  -4.369  1.00 32.33      A    C   
ATOM   1093  CG  GLU   136      24.379  60.003  -4.705  1.00 35.07      A    C   
ATOM   1094  CD  GLU   136      25.477  58.936  -4.873  1.00 36.16      A    C   
ATOM   1095  OE1 GLU   136      25.147  57.741  -5.142  1.00 43.64      A    O   
ATOM   1096  OE2 GLU   136      26.670  59.287  -4.730  1.00 40.16      A    O   
ATOM   1097  C   GLU   136      20.520  59.656  -4.296  1.00 32.21      A    C   
ATOM   1098  O   GLU   136      19.866  59.505  -5.332  1.00 32.43      A    O   
ATOM   1099  N   ASP   137      20.120  59.214  -3.108  1.00 32.97      A    N   
ATOM   1100  CA  ASP   137      18.904  58.443  -2.929  1.00 33.33      A    C   
ATOM   1101  CB  ASP   137      18.979  57.710  -1.597  1.00 33.96      A    C   
ATOM   1102  CG  ASP   137      17.867  56.724  -1.419  1.00 35.40      A    C   
ATOM   1103  OD1 ASP   137      16.781  57.135  -0.989  1.00 35.12      A    O   
ATOM   1104  OD2 ASP   137      18.108  55.532  -1.686  1.00 39.44      A    O   
ATOM   1105  C   ASP   137      17.654  59.307  -3.028  1.00 33.22      A    C   
ATOM   1106  O   ASP   137      17.418  60.175  -2.190  1.00 32.47      A    O   
ATOM   1107  N   ILE   138      16.856  59.057  -4.067  1.00 33.01      A    N   
ATOM   1108  CA  ILE   138      15.665  59.859  -4.345  1.00 33.20      A    C   
ATOM   1109  CB  ILE   138      14.937  59.387  -5.642  1.00 34.03      A    C   
ATOM   1110  CG1 ILE   138      15.942  58.946  -6.736  1.00 36.30      A    C   
ATOM   1111  CD1 ILE   138      16.726  60.053  -7.522  1.00 39.39      A    C   
ATOM   1112  CG2 ILE   138      13.872  60.416  -6.066  1.00 35.48      A    C   
ATOM   1113  C   ILE   138      14.668  59.899  -3.184  1.00 32.36      A    C   
ATOM   1114  O   ILE   138      14.098  60.943  -2.890  1.00 32.12      A    O   
ATOM   1115  N   SER   139      14.443  58.758  -2.533  1.00 32.01      A    N   
ATOM   1116  CA  SER   139      13.531  58.696  -1.389  1.00 32.00      A    C   
ATOM   1117  CB  SER   139      13.372  57.244  -0.932  1.00 32.18      A    C   
ATOM   1118  OG  SER   139      12.430  57.154   0.119  1.00 37.34      A    O   
ATOM   1119  C   SER   139      14.039  59.561  -0.225  1.00 30.51      A    C   
ATOM   1120  O   SER   139      13.269  60.302   0.403  1.00 29.97      A    O   
ATOM   1121  N   CYS   140      15.325  59.427   0.073  1.00 29.81      A    N   
ATOM   1122  CA  CYS   140      15.921  60.177   1.172  1.00 28.88      A    C   
ATOM   1123  CB  CYS   140      17.328  59.673   1.472  1.00 29.25      A    C   
ATOM   1124  SG  CYS   140      18.048  60.583   2.796  1.00 33.11      A    S   
ATOM   1125  C   CYS   140      15.943  61.663   0.800  1.00 27.83      A    C   
ATOM   1126  O   CYS   140      15.551  62.516   1.597  1.00 26.62      A    O   
ATOM   1127  N   ARG   141      16.381  61.949  -0.420  1.00 26.66      A    N   
ATOM   1128  CA  ARG   141      16.424  63.336  -0.918  1.00 26.46      A    C   
ATOM   1129  CB  ARG   141      16.966  63.397  -2.343  1.00 26.64      A    C   
ATOM   1130  CG  ARG   141      16.923  64.826  -2.926  1.00 27.59      A    C   
ATOM   1131  CD  ARG   141      17.618  64.908  -4.258  1.00 30.60      A    C   
ATOM   1132  NE  ARG   141      16.760  64.354  -5.294  1.00 34.75      A    N   
ATOM   1133  CZ  ARG   141      16.983  63.211  -5.936  1.00 35.41      A    C   
ATOM   1134  NH1 ARG   141      18.062  62.472  -5.667  1.00 33.78      A    N   
ATOM   1135  NH2 ARG   141      16.115  62.819  -6.867  1.00 34.62      A    N   
ATOM   1136  C   ARG   141      15.066  64.044  -0.818  1.00 26.45      A    C   
ATOM   1137  O   ARG   141      14.977  65.137  -0.285  1.00 25.66      A    O   
ATOM   1138  N   ASP   142      14.011  63.415  -1.345  1.00 26.96      A    N   
ATOM   1139  CA  ASP   142      12.663  63.973  -1.295  1.00 26.71      A    C   
ATOM   1140  CB  ASP   142      11.715  63.046  -2.051  1.00 27.78      A    C   
ATOM   1141  CG  ASP   142      11.781  63.232  -3.558  1.00 30.65      A    C   
ATOM   1142  OD1 ASP   142      12.482  64.155  -4.053  1.00 29.59      A    O   
ATOM   1143  OD2 ASP   142      11.118  62.442  -4.267  1.00 33.79      A    O   
ATOM   1144  C   ASP   142      12.135  64.178   0.121  1.00 26.31      A    C   
ATOM   1145  O   ASP   142      11.449  65.167   0.393  1.00 26.37      A    O   
ATOM   1146  N   PHE   143      12.423  63.233   1.019  1.00 25.25      A    N   
ATOM   1147  CA  PHE   143      11.977  63.386   2.399  1.00 25.37      A    C   
ATOM   1148  CB  PHE   143      12.307  62.171   3.263  1.00 25.32      A    C   
ATOM   1149  CG  PHE   143      11.781  62.285   4.691  1.00 26.89      A    C   
ATOM   1150  CD1 PHE   143      10.487  61.850   5.006  1.00 30.74      A    C   
ATOM   1151  CE1 PHE   143       9.993  61.941   6.324  1.00 31.27      A    C   
ATOM   1152  CZ  PHE   143      10.817  62.486   7.338  1.00 29.23      A    C   
ATOM   1153  CE2 PHE   143      12.103  62.917   7.025  1.00 27.99      A    C   
ATOM   1154  CD2 PHE   143      12.574  62.817   5.710  1.00 28.83      A    C   
ATOM   1155  C   PHE   143      12.654  64.596   3.022  1.00 24.84      A    C   
ATOM   1156  O   PHE   143      12.011  65.352   3.719  1.00 25.22      A    O   
ATOM   1157  N   ILE   144      13.955  64.746   2.776  1.00 25.15      A    N   
ATOM   1158  CA  ILE   144      14.703  65.873   3.385  1.00 24.71      A    C   
ATOM   1159  CB  ILE   144      16.260  65.732   3.236  1.00 25.41      A    C   
ATOM   1160  CG1 ILE   144      16.789  64.438   3.884  1.00 26.65      A    C   
ATOM   1161  CD1 ILE   144      16.433  64.307   5.309  1.00 32.59      A    C   
ATOM   1162  CG2 ILE   144      17.004  66.949   3.845  1.00 25.38      A    C   
ATOM   1163  C   ILE   144      14.199  67.208   2.820  1.00 24.23      A    C   
ATOM   1164  O   ILE   144      14.017  68.151   3.565  1.00 22.99      A    O   
ATOM   1165  N   GLU   145      14.013  67.271   1.509  1.00 24.54      A    N   
ATOM   1166  CA  GLU   145      13.421  68.461   0.875  1.00 26.22      A    C   
ATOM   1167  CB  GLU   145      13.132  68.231  -0.600  1.00 26.83      A    C   
ATOM   1168  CG  GLU   145      12.375  69.440  -1.213  1.00 31.06      A    C   
ATOM   1169  CD  GLU   145      12.239  69.396  -2.707  1.00 34.55      A    C   
ATOM   1170  OE1 GLU   145      11.936  68.329  -3.267  1.00 36.48      A    O   
ATOM   1171  OE2 GLU   145      12.422  70.469  -3.324  1.00 40.38      A    O   
ATOM   1172  C   GLU   145      12.113  68.863   1.560  1.00 26.02      A    C   
ATOM   1173  O   GLU   145      11.930  70.007   1.930  1.00 25.51      A    O   
ATOM   1174  N   GLU   146      11.214  67.900   1.722  1.00 26.22      A    N   
ATOM   1175  CA  GLU   146       9.919  68.182   2.323  1.00 26.31      A    C   
ATOM   1176  CB  GLU   146       8.990  66.968   2.216  1.00 26.99      A    C   
ATOM   1177  CG  GLU   146       7.710  67.112   3.054  1.00 30.93      A    C   
ATOM   1178  CD  GLU   146       6.815  68.273   2.620  1.00 35.96      A    C   
ATOM   1179  OE1 GLU   146       6.923  68.723   1.447  1.00 37.56      A    O   
ATOM   1180  OE2 GLU   146       5.995  68.744   3.460  1.00 38.44      A    O   
ATOM   1181  C   GLU   146      10.097  68.657   3.759  1.00 25.30      A    C   
ATOM   1182  O   GLU   146       9.524  69.673   4.161  1.00 25.67      A    O   
ATOM   1183  N   TYR   147      10.925  67.940   4.519  1.00 24.95      A    N   
ATOM   1184  CA  TYR   147      11.232  68.295   5.902  1.00 24.26      A    C   
ATOM   1185  CB  TYR   147      12.292  67.332   6.478  1.00 24.62      A    C   
ATOM   1186  CG  TYR   147      12.628  67.654   7.931  1.00 25.42      A    C   
ATOM   1187  CD1 TYR   147      11.906  67.074   8.979  1.00 25.78      A    C   
ATOM   1188  CE1 TYR   147      12.192  67.381  10.316  1.00 26.51      A    C   
ATOM   1189  CZ  TYR   147      13.210  68.288  10.614  1.00 26.34      A    C   
ATOM   1190  OH  TYR   147      13.491  68.595  11.920  1.00 24.94      A    O   
ATOM   1191  CE2 TYR   147      13.955  68.870   9.590  1.00 24.26      A    C   
ATOM   1192  CD2 TYR   147      13.658  68.568   8.261  1.00 23.68      A    C   
ATOM   1193  C   TYR   147      11.767  69.727   6.057  1.00 23.42      A    C   
ATOM   1194  O   TYR   147      11.306  70.501   6.908  1.00 22.71      A    O   
ATOM   1195  N   VAL   148      12.791  70.031   5.272  1.00 22.89      A    N   
ATOM   1196  CA  VAL   148      13.526  71.291   5.420  1.00 23.22      A    C   
ATOM   1197  CB  VAL   148      14.850  71.291   4.598  1.00 22.51      A    C   
ATOM   1198  CG1 VAL   148      15.411  72.710   4.463  1.00 22.81      A    C   
ATOM   1199  CG2 VAL   148      15.906  70.380   5.253  1.00 21.91      A    C   
ATOM   1200  C   VAL   148      12.635  72.469   5.040  1.00 24.19      A    C   
ATOM   1201  O   VAL   148      12.622  73.509   5.724  1.00 25.11      A    O   
ATOM   1202  N   THR   149      11.872  72.282   3.972  1.00 26.28      A    N   
ATOM   1203  CA  THR   149      11.007  73.347   3.460  1.00 27.60      A    C   
ATOM   1204  CB  THR   149      10.656  73.154   1.966  1.00 27.71      A    C   
ATOM   1205  OG1 THR   149      10.005  71.900   1.759  1.00 27.07      A    O   
ATOM   1206  CG2 THR   149      11.943  73.213   1.091  1.00 26.99      A    C   
ATOM   1207  C   THR   149       9.771  73.557   4.356  1.00 28.95      A    C   
ATOM   1208  O   THR   149       9.395  74.715   4.633  1.00 30.70      A    O   
ATOM   1209  N   ALA   150       9.199  72.463   4.868  1.00 27.59      A    N   
ATOM   1210  CA  ALA   150       8.037  72.539   5.784  1.00 27.60      A    C   
ATOM   1211  CB  ALA   150       7.338  71.216   5.841  1.00 27.85      A    C   
ATOM   1212  C   ALA   150       8.379  73.031   7.198  1.00 27.59      A    C   
ATOM   1213  O   ALA   150       7.527  73.592   7.903  1.00 26.80      A    O   
ATOM   1214  N   TYR   151       9.632  72.841   7.608  1.00 26.51      A    N   
ATOM   1215  CA  TYR   151      10.105  73.251   8.916  1.00 27.02      A    C   
ATOM   1216  CB  TYR   151      11.626  73.029   9.030  1.00 26.25      A    C   
ATOM   1217  CG  TYR   151      12.156  73.258  10.428  1.00 25.64      A    C   
ATOM   1218  CD1 TYR   151      12.260  72.202  11.338  1.00 24.89      A    C   
ATOM   1219  CE1 TYR   151      12.732  72.409  12.636  1.00 24.64      A    C   
ATOM   1220  CZ  TYR   151      13.098  73.675  13.038  1.00 24.96      A    C   
ATOM   1221  OH  TYR   151      13.575  73.897  14.309  1.00 26.53      A    O   
ATOM   1222  CE2 TYR   151      13.000  74.750  12.154  1.00 24.39      A    C   
ATOM   1223  CD2 TYR   151      12.553  74.530  10.850  1.00 24.63      A    C   
ATOM   1224  C   TYR   151       9.735  74.720   9.189  1.00 28.26      A    C   
ATOM   1225  O   TYR   151       9.886  75.560   8.276  1.00 28.36      A    O   
ATOM   1226  N   PRO   152       9.275  75.038  10.426  1.00 29.02      A    N   
ATOM   1227  CA  PRO   152       9.187  74.177  11.612  1.00 29.87      A    C   
ATOM   1228  CB  PRO   152       9.310  75.172  12.764  1.00 29.97      A    C   
ATOM   1229  CG  PRO   152       8.651  76.398  12.233  1.00 30.14      A    C   
ATOM   1230  CD  PRO   152       8.836  76.413  10.742  1.00 30.10      A    C   
ATOM   1231  C   PRO   152       7.926  73.321  11.779  1.00 30.49      A    C   
ATOM   1232  O   PRO   152       7.770  72.704  12.833  1.00 30.95      A    O   
ATOM   1233  N   ASN   153       7.023  73.282  10.779  1.00 20.00           N   
ATOM   1234  CA  ASN   153       5.912  72.337  10.772  1.00 20.00           C   
ATOM   1235  C   ASN   153       6.382  70.898  10.581  1.00 20.00           C   
ATOM   1236  CB  ASN   153       4.899  72.708   9.688  1.00 20.00           C   
ATOM   1237  O   ASN   153       6.906  70.556   9.498  1.00 34.11      A    O   
ATOM   1238  N   ARG   154       6.343  70.087  11.628  1.00 34.24      A    N   
ATOM   1239  CA  ARG   154       6.936  68.749  11.595  1.00 35.67      A    C   
ATOM   1240  CB  ARG   154       8.227  68.707  12.425  1.00 35.22      A    C   
ATOM   1241  CG  ARG   154       9.211  69.818  12.124  1.00 36.95      A    C   
ATOM   1242  CD  ARG   154      10.553  69.530  12.762  1.00 37.24      A    C   
ATOM   1243  NE  ARG   154      10.532  69.551  14.224  1.00 36.56      A    N   
ATOM   1244  CZ  ARG   154      11.377  68.854  14.987  1.00 38.65      A    C   
ATOM   1245  NH1 ARG   154      12.305  68.068  14.428  1.00 37.10      A    N   
ATOM   1246  NH2 ARG   154      11.287  68.922  16.314  1.00 38.91      A    N   
ATOM   1247  C   ARG   154       5.972  67.656  12.079  1.00 35.48      A    C   
ATOM   1248  O   ARG   154       5.862  67.419  13.289  1.00 36.60      A    O   
ATOM   1249  N   PRO   155       5.286  66.978  11.141  1.00 35.81      A    N   
ATOM   1250  CA  PRO   155       4.463  65.852  11.573  1.00 35.57      A    C   
ATOM   1251  CB  PRO   155       3.855  65.324  10.270  1.00 36.30      A    C   
ATOM   1252  CG  PRO   155       3.956  66.479   9.313  1.00 36.91      A    C   
ATOM   1253  CD  PRO   155       5.226  67.180   9.682  1.00 35.74      A    C   
ATOM   1254  C   PRO   155       5.343  64.783  12.218  1.00 35.68      A    C   
ATOM   1255  O   PRO   155       6.358  64.349  11.638  1.00 34.45      A    O   
ATOM   1256  N   MET   156       4.971  64.409  13.437  1.00 34.58      A    N   
ATOM   1257  CA  MET   156       5.645  63.339  14.146  1.00 34.91      A    C   
ATOM   1258  CB  MET   156       6.635  63.918  15.156  1.00 34.72      A    C   
ATOM   1259  CG  MET   156       7.983  64.252  14.579  1.00 35.80      A    C   
ATOM   1260  SD  MET   156       9.041  64.902  15.882  1.00 38.27      A    S   
ATOM   1261  CE  MET   156       8.828  66.670  15.635  1.00 38.73      A    C   
ATOM   1262  C   MET   156       4.594  62.530  14.877  1.00 33.88      A    C   
ATOM   1263  O   MET   156       3.528  63.050  15.200  1.00 33.77      A    O   
ATOM   1264  N   VAL   157       4.892  61.260  15.135  1.00 32.68      A    N   
ATOM   1265  CA  VAL   157       4.011  60.455  15.976  1.00 31.94      A    C   
ATOM   1266  CB  VAL   157       3.840  59.008  15.458  1.00 32.31      A    C   
ATOM   1267  CG1 VAL   157       5.169  58.286  15.379  1.00 33.02      A    C   
ATOM   1268  CG2 VAL   157       2.852  58.227  16.337  1.00 34.19      A    C   
ATOM   1269  C   VAL   157       4.550  60.460  17.396  1.00 30.70      A    C   
ATOM   1270  O   VAL   157       5.766  60.361  17.610  1.00 30.12      A    O   
ATOM   1271  N   LEU   158       3.637  60.611  18.354  1.00 29.86      A    N   
ATOM   1272  CA  LEU   158       3.995  60.654  19.766  1.00 29.34      A    C   
ATOM   1273  CB  LEU   158       2.960  61.447  20.567  1.00 29.76      A    C   
ATOM   1274  CG  LEU   158       3.511  62.265  21.740  1.00 32.71      A    C   
ATOM   1275  CD1 LEU   158       4.056  63.603  21.231  1.00 35.52      A    C   
ATOM   1276  CD2 LEU   158       2.430  62.529  22.806  1.00 30.91      A    C   
ATOM   1277  C   LEU   158       4.028  59.214  20.237  1.00 27.36      A    C   
ATOM   1278  O   LEU   158       3.037  58.490  20.115  1.00 27.38      A    O   
ATOM   1279  N   LEU   159       5.180  58.801  20.737  1.00 25.39      A    N   
ATOM   1280  CA  LEU   159       5.403  57.409  21.093  1.00 24.82      A    C   
ATOM   1281  CB  LEU   159       6.423  56.786  20.119  1.00 24.48      A    C   
ATOM   1282  CG  LEU   159       5.961  56.607  18.665  1.00 24.98      A    C   
ATOM   1283  CD1 LEU   159       7.133  56.146  17.769  1.00 23.19      A    C   
ATOM   1284  CD2 LEU   159       4.778  55.652  18.569  1.00 25.71      A    C   
ATOM   1285  C   LEU   159       5.943  57.308  22.513  1.00 23.84      A    C   
ATOM   1286  O   LEU   159       6.673  58.185  22.954  1.00 25.14      A    O   
ATOM   1287  N   LYS   160       5.635  56.204  23.182  1.00 23.05      A    N   
ATOM   1288  CA  LYS   160       6.060  55.971  24.556  1.00 22.85      A    C   
ATOM   1289  CB  LYS   160       4.850  56.031  25.484  1.00 23.53      A    C   
ATOM   1290  CG  LYS   160       4.168  57.403  25.532  1.00 24.66      A    C   
ATOM   1291  CD  LYS   160       5.157  58.455  26.034  1.00 27.77      A    C   
ATOM   1292  CE  LYS   160       4.444  59.759  26.441  1.00 29.29      A    C   
ATOM   1293  NZ  LYS   160       4.130  60.569  25.254  1.00 31.32      A    N   
ATOM   1294  C   LYS   160       6.681  54.587  24.622  1.00 21.60      A    C   
ATOM   1295  O   LYS   160       6.262  53.694  23.876  1.00 21.59      A    O   
ATOM   1296  N   SER   161       7.646  54.395  25.521  1.00 21.08      A    N   
ATOM   1297  CA  SER   161       8.251  53.083  25.685  1.00 20.57      A    C   
ATOM   1298  CB  SER   161       9.311  53.109  26.804  1.00 21.74      A    C   
ATOM   1299  OG  SER   161      10.377  54.020  26.512  1.00 21.20      A    O   
ATOM   1300  C   SER   161       7.166  52.029  25.993  1.00 21.82      A    C   
ATOM   1301  O   SER   161       6.249  52.295  26.790  1.00 21.39      A    O   
ATOM   1302  N   GLY   162       7.273  50.866  25.343  1.00 20.79      A    N   
ATOM   1303  CA  GLY   162       6.350  49.735  25.567  1.00 22.54      A    C   
ATOM   1304  C   GLY   162       5.284  49.662  24.495  1.00 22.96      A    C   
ATOM   1305  O   GLY   162       4.646  48.626  24.303  1.00 24.12      A    O   
ATOM   1306  N   GLN   163       5.096  50.766  23.782  1.00 23.51      A    N   
ATOM   1307  CA  GLN   163       4.086  50.847  22.731  1.00 24.64      A    C   
ATOM   1308  CB  GLN   163       3.955  52.288  22.270  1.00 24.76      A    C   
ATOM   1309  CG  GLN   163       2.740  52.571  21.468  1.00 27.65      A    C   
ATOM   1310  CD  GLN   163       2.588  54.038  21.157  1.00 29.28      A    C   
ATOM   1311  OE1 GLN   163       3.250  54.902  21.761  1.00 29.12      A    O   
ATOM   1312  NE2 GLN   163       1.722  54.339  20.181  1.00 30.38      A    N   
ATOM   1313  C   GLN   163       4.372  49.922  21.546  1.00 25.12      A    C   
ATOM   1314  O   GLN   163       5.508  49.855  21.046  1.00 24.39      A    O   
ATOM   1315  N   LEU   164       3.334  49.187  21.130  1.00 25.12      A    N   
ATOM   1316  CA  LEU   164       3.447  48.248  20.006  1.00 26.66      A    C   
ATOM   1317  CB  LEU   164       2.582  47.001  20.236  1.00 26.46      A    C   
ATOM   1318  CG  LEU   164       2.987  46.078  21.379  1.00 28.68      A    C   
ATOM   1319  CD1 LEU   164       1.967  44.926  21.516  1.00 30.83      A    C   
ATOM   1320  CD2 LEU   164       4.403  45.512  21.181  1.00 31.29      A    C   
ATOM   1321  C   LEU   164       3.026  48.921  18.712  1.00 26.79      A    C   
ATOM   1322  O   LEU   164       1.920  49.492  18.614  1.00 26.92      A    O   
ATOM   1323  N   ILE   165       3.915  48.865  17.731  1.00 26.19      A    N   
ATOM   1324  CA  ILE   165       3.649  49.430  16.424  1.00 26.22      A    C   
ATOM   1325  CB  ILE   165       4.173  50.888  16.295  1.00 26.55      A    C   
ATOM   1326  CG1 ILE   165       5.705  50.951  16.338  1.00 26.94      A    C   
ATOM   1327  CD1 ILE   165       6.209  52.315  15.886  1.00 31.23      A    C   
ATOM   1328  CG2 ILE   165       3.498  51.801  17.340  1.00 28.32      A    C   
ATOM   1329  C   ILE   165       4.247  48.553  15.337  1.00 25.55      A    C   
ATOM   1330  O   ILE   165       5.032  47.639  15.628  1.00 25.72      A    O   
ATOM   1331  N   LYS   166       3.857  48.808  14.095  1.00 24.69      A    N   
ATOM   1332  CA  LYS   166       4.532  48.201  12.962  1.00 25.62      A    C   
ATOM   1333  CB  LYS   166       3.546  47.801  11.841  1.00 25.02      A    C   
ATOM   1334  CG  LYS   166       2.637  46.635  12.225  1.00 27.39      A    C   
ATOM   1335  CD  LYS   166       1.482  46.477  11.223  1.00 30.70      A    C   
ATOM   1336  CE  LYS   166       0.449  47.592  11.399  1.00 36.81      A    C   
ATOM   1337  NZ  LYS   166      -0.949  47.203  10.993  1.00 40.59      A    N   
ATOM   1338  C   LYS   166       5.553  49.172  12.425  1.00 23.66      A    C   
ATOM   1339  O   LYS   166       5.273  50.379  12.281  1.00 23.59      A    O   
ATOM   1340  N   THR   167       6.731  48.634  12.141  1.00 23.49      A    N   
ATOM   1341  CA  THR   167       7.843  49.377  11.541  1.00 23.44      A    C   
ATOM   1342  CB  THR   167       9.029  49.524  12.554  1.00 23.65      A    C   
ATOM   1343  OG1 THR   167       8.529  50.063  13.767  1.00 22.70      A    O   
ATOM   1344  CG2 THR   167      10.106  50.482  12.004  1.00 23.83      A    C   
ATOM   1345  C   THR   167       8.345  48.707  10.257  1.00 23.50      A    C   
ATOM   1346  O   THR   167       8.466  47.480  10.181  1.00 22.37      A    O   
ATOM   1347  N   GLU   168       8.648  49.527   9.254  1.00 23.23      A    N   
ATOM   1348  CA  GLU   168       9.146  49.022   7.986  1.00 24.42      A    C   
ATOM   1349  CB  GLU   168       8.955  50.091   6.883  1.00 24.75      A    C   
ATOM   1350  CG  GLU   168       9.408  49.656   5.486  1.00 26.02      A    C   
ATOM   1351  CD  GLU   168      10.914  49.794   5.215  1.00 30.37      A    C   
ATOM   1352  OE1 GLU   168      11.678  50.506   5.941  1.00 29.81      A    O   
ATOM   1353  OE2 GLU   168      11.345  49.200   4.212  1.00 30.83      A    O   
ATOM   1354  C   GLU   168      10.602  48.588   8.082  1.00 24.47      A    C   
ATOM   1355  O   GLU   168      11.418  49.238   8.747  1.00 24.48      A    O   
ATOM   1356  N   TRP   169      10.930  47.486   7.411  1.00 24.67      A    N   
ATOM   1357  CA  TRP   169      12.311  47.080   7.218  1.00 26.31      A    C   
ATOM   1358  CB  TRP   169      12.843  46.350   8.458  1.00 27.92      A    C   
ATOM   1359  CG  TRP   169      14.297  46.013   8.404  1.00 29.33      A    C   
ATOM   1360  CD1 TRP   169      15.360  46.882   8.521  1.00 32.61      A    C   
ATOM   1361  NE1 TRP   169      16.545  46.192   8.424  1.00 34.22      A    N   
ATOM   1362  CE2 TRP   169      16.270  44.859   8.267  1.00 33.95      A    C   
ATOM   1363  CD2 TRP   169      14.861  44.712   8.251  1.00 33.43      A    C   
ATOM   1364  CE3 TRP   169      14.311  43.431   8.089  1.00 33.18      A    C   
ATOM   1365  CZ3 TRP   169      15.178  42.341   7.961  1.00 33.32      A    C   
ATOM   1366  CH2 TRP   169      16.574  42.523   7.980  1.00 33.82      A    C   
ATOM   1367  CZ2 TRP   169      17.138  43.770   8.130  1.00 34.67      A    C   
ATOM   1368  C   TRP   169      12.339  46.163   6.009  1.00 26.81      A    C   
ATOM   1369  O   TRP   169      11.487  45.283   5.881  1.00 26.65      A    O   
ATOM   1370  N   GLU   170      13.282  46.417   5.110  1.00 27.53      A    N   
ATOM   1371  CA  GLU   170      13.428  45.625   3.877  1.00 29.22      A    C   
ATOM   1372  CB  GLU   170      14.045  44.248   4.210  1.00 28.81      A    C   
ATOM   1373  CG  GLU   170      15.549  44.338   4.551  1.00 30.48      A    C   
ATOM   1374  CD  GLU   170      16.282  42.988   4.660  1.00 32.91      A    C   
ATOM   1375  OE1 GLU   170      15.626  41.926   4.750  1.00 37.38      A    O   
ATOM   1376  OE2 GLU   170      17.538  43.002   4.669  1.00 34.53      A    O   
ATOM   1377  C   GLU   170      12.115  45.562   3.076  1.00 27.91      A    C   
ATOM   1378  O   GLU   170      11.758  44.522   2.469  1.00 28.93      A    O   
ATOM   1379  N   GLY   171      11.384  46.681   3.072  1.00 27.29      A    N   
ATOM   1380  CA  GLY   171      10.155  46.829   2.269  1.00 26.97      A    C   
ATOM   1381  C   GLY   171       8.860  46.225   2.793  1.00 26.96      A    C   
ATOM   1382  O   GLY   171       7.815  46.271   2.118  1.00 26.58      A    O   
ATOM   1383  N   THR   172       8.901  45.657   4.001  1.00 26.03      A    N   
ATOM   1384  CA  THR   172       7.717  45.067   4.597  1.00 25.14      A    C   
ATOM   1385  CB  THR   172       7.738  43.502   4.543  1.00 25.39      A    C   
ATOM   1386  OG1 THR   172       8.901  43.014   5.215  1.00 24.72      A    O   
ATOM   1387  CG2 THR   172       7.739  43.005   3.086  1.00 25.96      A    C   
ATOM   1388  C   THR   172       7.568  45.515   6.035  1.00 25.58      A    C   
ATOM   1389  O   THR   172       8.498  46.091   6.603  1.00 25.06      A    O   
ATOM   1390  N   TRP   173       6.394  45.265   6.606  1.00 25.62      A    N   
ATOM   1391  CA  TRP   173       6.086  45.751   7.956  1.00 26.25      A    C   
ATOM   1392  CB  TRP   173       4.643  46.236   8.023  1.00 28.07      A    C   
ATOM   1393  CG  TRP   173       4.405  47.389   7.140  1.00 30.76      A    C   
ATOM   1394  CD1 TRP   173       3.918  47.357   5.855  1.00 33.53      A    C   
ATOM   1395  NE1 TRP   173       3.864  48.634   5.340  1.00 34.95      A    N   
ATOM   1396  CE2 TRP   173       4.323  49.518   6.287  1.00 34.13      A    C   
ATOM   1397  CD2 TRP   173       4.684  48.765   7.433  1.00 31.72      A    C   
ATOM   1398  CE3 TRP   173       5.217  49.434   8.543  1.00 30.76      A    C   
ATOM   1399  CZ3 TRP   173       5.347  50.823   8.486  1.00 31.92      A    C   
ATOM   1400  CH2 TRP   173       4.973  51.549   7.337  1.00 32.47      A    C   
ATOM   1401  CZ2 TRP   173       4.460  50.918   6.229  1.00 32.94      A    C   
ATOM   1402  C   TRP   173       6.313  44.676   8.990  1.00 25.59      A    C   
ATOM   1403  O   TRP   173       5.957  43.509   8.762  1.00 25.02      A    O   
ATOM   1404  N   TRP   174       6.895  45.070  10.128  1.00 24.27      A    N   
ATOM   1405  CA  TRP   174       7.264  44.143  11.185  1.00 24.02      A    C   
ATOM   1406  CB  TRP   174       8.794  44.060  11.321  1.00 24.07      A    C   
ATOM   1407  CG  TRP   174       9.508  43.642  10.086  1.00 23.96      A    C   
ATOM   1408  CD1 TRP   174       9.725  44.395   8.973  1.00 24.25      A    C   
ATOM   1409  NE1 TRP   174      10.435  43.661   8.036  1.00 26.15      A    N   
ATOM   1410  CE2 TRP   174      10.695  42.418   8.551  1.00 26.78      A    C   
ATOM   1411  CD2 TRP   174      10.113  42.363   9.836  1.00 25.29      A    C   
ATOM   1412  CE3 TRP   174      10.227  41.177  10.589  1.00 26.76      A    C   
ATOM   1413  CZ3 TRP   174      10.921  40.083  10.030  1.00 27.16      A    C   
ATOM   1414  CH2 TRP   174      11.489  40.174   8.737  1.00 26.08      A    C   
ATOM   1415  CZ2 TRP   174      11.379  41.328   7.980  1.00 27.93      A    C   
ATOM   1416  C   TRP   174       6.685  44.550  12.529  1.00 24.03      A    C   
ATOM   1417  O   TRP   174       6.655  45.727  12.861  1.00 23.12      A    O   
ATOM   1418  N   LYS   175       6.262  43.551  13.302  1.00 23.58      A    N   
ATOM   1419  CA  LYS   175       5.817  43.763  14.653  1.00 24.08      A    C   
ATOM   1420  CB  LYS   175       5.284  42.465  15.246  1.00 25.32      A    C   
ATOM   1421  CG  LYS   175       4.027  41.996  14.544  1.00 28.83      A    C   
ATOM   1422  CD  LYS   175       3.303  40.943  15.374  1.00 35.01      A    C   
ATOM   1423  CE  LYS   175       1.952  40.624  14.752  1.00 38.96      A    C   
ATOM   1424  NZ  LYS   175       1.273  39.517  15.488  1.00 42.78      A    N   
ATOM   1425  C   LYS   175       7.005  44.272  15.460  1.00 22.65      A    C   
ATOM   1426  O   LYS   175       8.081  43.685  15.427  1.00 22.82      A    O   
ATOM   1427  N   SER   176       6.795  45.377  16.150  1.00 22.57      A    N   
ATOM   1428  CA  SER   176       7.896  46.047  16.845  1.00 22.13      A    C   
ATOM   1429  CB  SER   176       8.616  47.014  15.884  1.00 22.30      A    C   
ATOM   1430  OG  SER   176       7.878  48.200  15.696  1.00 24.50      A    O   
ATOM   1431  C   SER   176       7.387  46.748  18.099  1.00 22.23      A    C   
ATOM   1432  O   SER   176       6.167  46.890  18.304  1.00 22.69      A    O   
ATOM   1433  N   ARG   177       8.316  47.169  18.954  1.00 21.37      A    N   
ATOM   1434  CA  ARG   177       7.972  47.805  20.215  1.00 21.78      A    C   
ATOM   1435  CB  ARG   177       8.083  46.795  21.376  1.00 21.90      A    C   
ATOM   1436  CG  ARG   177       7.582  47.337  22.714  1.00 23.76      A    C   
ATOM   1437  CD  ARG   177       7.477  46.229  23.770  1.00 23.41      A    C   
ATOM   1438  NE  ARG   177       8.753  45.578  24.022  1.00 28.84      A    N   
ATOM   1439  CZ  ARG   177       8.903  44.265  24.218  1.00 31.54      A    C   
ATOM   1440  NH1 ARG   177       7.859  43.443  24.169  1.00 31.82      A    N   
ATOM   1441  NH2 ARG   177      10.108  43.774  24.437  1.00 33.67      A    N   
ATOM   1442  C   ARG   177       8.922  48.970  20.457  1.00 21.14      A    C   
ATOM   1443  O   ARG   177      10.123  48.840  20.210  1.00 20.15      A    O   
ATOM   1444  N   VAL   178       8.381  50.099  20.915  1.00 20.17      A    N   
ATOM   1445  CA  VAL   178       9.193  51.261  21.294  1.00 20.26      A    C   
ATOM   1446  CB  VAL   178       8.321  52.495  21.587  1.00 20.41      A    C   
ATOM   1447  CG1 VAL   178       9.187  53.654  22.038  1.00 20.74      A    C   
ATOM   1448  CG2 VAL   178       7.491  52.881  20.333  1.00 21.77      A    C   
ATOM   1449  C   VAL   178       9.975  50.903  22.559  1.00 20.35      A    C   
ATOM   1450  O   VAL   178       9.384  50.585  23.589  1.00 19.94      A    O   
ATOM   1451  N   GLU   179      11.292  50.966  22.452  1.00 19.10      A    N   
ATOM   1452  CA  GLU   179      12.181  50.639  23.559  1.00 20.30      A    C   
ATOM   1453  CB  GLU   179      13.391  49.912  23.027  1.00 22.27      A    C   
ATOM   1454  CG  GLU   179      13.004  48.530  22.493  1.00 24.60      A    C   
ATOM   1455  CD  GLU   179      12.270  47.717  23.559  1.00 30.02      A    C   
ATOM   1456  OE1 GLU   179      12.985  47.339  24.512  1.00 29.04      A    O   
ATOM   1457  OE2 GLU   179      11.011  47.523  23.461  1.00 26.81      A    O   
ATOM   1458  C   GLU   179      12.592  51.861  24.350  1.00 20.78      A    C   
ATOM   1459  O   GLU   179      12.674  51.823  25.579  1.00 20.10      A    O   
ATOM   1460  N   GLU   180      12.828  52.961  23.643  1.00 21.01      A    N   
ATOM   1461  CA  GLU   180      13.355  54.173  24.274  1.00 22.48      A    C   
ATOM   1462  CB  GLU   180      14.862  54.049  24.294  1.00 22.67      A    C   
ATOM   1463  CG  GLU   180      15.611  54.859  25.312  1.00 28.28      A    C   
ATOM   1464  CD  GLU   180      17.130  54.662  25.184  1.00 25.92      A    C   
ATOM   1465  OE1 GLU   180      17.588  53.571  24.743  1.00 28.88      A    O   
ATOM   1466  OE2 GLU   180      17.840  55.613  25.553  1.00 33.40      A    O   
ATOM   1467  C   GLU   180      12.937  55.361  23.404  1.00 21.39      A    C   
ATOM   1468  O   GLU   180      12.727  55.209  22.206  1.00 20.18      A    O   
ATOM   1469  N   VAL   181      12.790  56.524  24.021  1.00 21.81      A    N   
ATOM   1470  CA  VAL   181      12.523  57.758  23.298  1.00 24.39      A    C   
ATOM   1471  CB  VAL   181      11.096  58.319  23.582  1.00 25.32      A    C   
ATOM   1472  CG1 VAL   181      10.929  59.674  22.937  1.00 27.58      A    C   
ATOM   1473  CG2 VAL   181      10.016  57.354  23.037  1.00 28.76      A    C   
ATOM   1474  C   VAL   181      13.600  58.772  23.676  1.00 24.51      A    C   
ATOM   1475  O   VAL   181      13.957  58.893  24.837  1.00 25.24      A    O   
ATOM   1476  N   ASP   182      14.133  59.473  22.680  1.00 24.81      A    N   
ATOM   1477  CA  ASP   182      15.165  60.488  22.898  1.00 24.85      A    C   
ATOM   1478  CB  ASP   182      16.565  59.895  22.687  1.00 25.36      A    C   
ATOM   1479  CG  ASP   182      17.684  60.927  22.931  1.00 26.04      A    C   
ATOM   1480  OD1 ASP   182      17.440  61.928  23.657  1.00 28.46      A    O   
ATOM   1481  OD2 ASP   182      18.780  60.730  22.404  1.00 25.63      A    O   
ATOM   1482  C   ASP   182      14.913  61.650  21.929  1.00 25.34      A    C   
ATOM   1483  O   ASP   182      15.193  61.544  20.742  1.00 24.28      A    O   
ATOM   1484  N   GLY   183      14.387  62.762  22.450  1.00 24.60      A    N   
ATOM   1485  CA  GLY   183      13.952  63.886  21.611  1.00 25.82      A    C   
ATOM   1486  C   GLY   183      13.031  63.431  20.491  1.00 26.12      A    C   
ATOM   1487  O   GLY   183      12.002  62.814  20.751  1.00 26.15      A    O   
ATOM   1488  N   SER   184      13.447  63.702  19.251  1.00 25.45      A    N   
ATOM   1489  CA  SER   184      12.677  63.398  18.046  1.00 24.55      A    C   
ATOM   1490  CB  SER   184      12.963  64.448  16.966  1.00 24.99      A    C   
ATOM   1491  OG  SER   184      12.511  65.727  17.403  1.00 27.01      A    O   
ATOM   1492  C   SER   184      13.015  62.012  17.488  1.00 23.84      A    C   
ATOM   1493  O   SER   184      12.578  61.686  16.375  1.00 23.91      A    O   
ATOM   1494  N   LEU   185      13.767  61.227  18.256  1.00 23.02      A    N   
ATOM   1495  CA  LEU   185      14.110  59.846  17.862  1.00 22.76      A    C   
ATOM   1496  CB  LEU   185      15.613  59.603  17.899  1.00 23.01      A    C   
ATOM   1497  CG  LEU   185      16.483  60.496  17.011  1.00 22.62      A    C   
ATOM   1498  CD1 LEU   185      17.960  60.181  17.227  1.00 24.91      A    C   
ATOM   1499  CD2 LEU   185      16.080  60.412  15.549  1.00 26.03      A    C   
ATOM   1500  C   LEU   185      13.442  58.803  18.735  1.00 22.69      A    C   
ATOM   1501  O   LEU   185      13.210  59.018  19.929  1.00 22.74      A    O   
ATOM   1502  N   VAL   186      13.182  57.639  18.146  1.00 22.00      A    N   
ATOM   1503  CA  VAL   186      12.692  56.494  18.925  1.00 21.67      A    C   
ATOM   1504  CB  VAL   186      11.182  56.214  18.652  1.00 22.49      A    C   
ATOM   1505  CG1 VAL   186      10.877  56.003  17.150  1.00 21.21      A    C   
ATOM   1506  CG2 VAL   186      10.728  55.019  19.440  1.00 23.37      A    C   
ATOM   1507  C   VAL   186      13.599  55.278  18.660  1.00 21.33      A    C   
ATOM   1508  O   VAL   186      14.073  55.105  17.525  1.00 21.21      A    O   
ATOM   1509  N   ARG   187      13.890  54.486  19.693  1.00 20.88      A    N   
ATOM   1510  CA  ARG   187      14.634  53.250  19.529  1.00 20.64      A    C   
ATOM   1511  CB  ARG   187      15.573  52.986  20.711  1.00 20.81      A    C   
ATOM   1512  CG  ARG   187      16.655  51.994  20.352  1.00 23.28      A    C   
ATOM   1513  CD  ARG   187      17.654  51.832  21.456  1.00 28.49      A    C   
ATOM   1514  NE  ARG   187      18.801  51.061  20.977  1.00 33.90      A    N   
ATOM   1515  CZ  ARG   187      19.969  50.948  21.610  1.00 39.02      A    C   
ATOM   1516  NH1 ARG   187      20.193  51.582  22.765  1.00 42.12      A    N   
ATOM   1517  NH2 ARG   187      20.937  50.211  21.070  1.00 41.09      A    N   
ATOM   1518  C   ARG   187      13.601  52.148  19.405  1.00 20.66      A    C   
ATOM   1519  O   ARG   187      12.814  51.930  20.328  1.00 20.30      A    O   
ATOM   1520  N   ILE   188      13.563  51.521  18.236  1.00 19.33      A    N   
ATOM   1521  CA  ILE   188      12.559  50.477  17.962  1.00 19.61      A    C   
ATOM   1522  CB  ILE   188      12.010  50.630  16.527  1.00 20.16      A    C   
ATOM   1523  CG1 ILE   188      11.293  51.977  16.341  1.00 19.49      A    C   
ATOM   1524  CD1 ILE   188      10.070  52.171  17.195  1.00 22.12      A    C   
ATOM   1525  CG2 ILE   188      11.111  49.453  16.172  1.00 18.97      A    C   
ATOM   1526  C   ILE   188      13.195  49.097  18.098  1.00 20.24      A    C   
ATOM   1527  O   ILE   188      14.268  48.844  17.544  1.00 20.98      A    O   
ATOM   1528  N   LEU   189      12.520  48.209  18.833  1.00 20.53      A    N   
ATOM   1529  CA  LEU   189      12.915  46.820  18.921  1.00 20.66      A    C   
ATOM   1530  CB  LEU   189      12.687  46.281  20.344  1.00 21.05      A    C   
ATOM   1531  CG  LEU   189      12.813  44.770  20.537  1.00 21.76      A    C   
ATOM   1532  CD1 LEU   189      14.231  44.303  20.289  1.00 25.44      A    C   
ATOM   1533  CD2 LEU   189      12.319  44.397  21.954  1.00 22.56      A    C   
ATOM   1534  C   LEU   189      12.054  46.044  17.937  1.00 20.30      A    C   
ATOM   1535  O   LEU   189      10.819  45.985  18.074  1.00 20.61      A    O   
ATOM   1536  N   PHE   190      12.708  45.468  16.949  1.00 21.27      A    N   
ATOM   1537  CA  PHE   190      12.065  44.521  16.033  1.00 21.14      A    C   
ATOM   1538  CB  PHE   190      12.903  44.373  14.775  1.00 21.24      A    C   
ATOM   1539  CG  PHE   190      12.823  45.588  13.881  1.00 21.90      A    C   
ATOM   1540  CD1 PHE   190      11.845  45.670  12.893  1.00 22.65      A    C   
ATOM   1541  CE1 PHE   190      11.754  46.800  12.084  1.00 23.09      A    C   
ATOM   1542  CZ  PHE   190      12.622  47.871  12.285  1.00 23.22      A    C   
ATOM   1543  CE2 PHE   190      13.586  47.806  13.264  1.00 25.07      A    C   
ATOM   1544  CD2 PHE   190      13.681  46.665  14.070  1.00 22.13      A    C   
ATOM   1545  C   PHE   190      11.907  43.194  16.758  1.00 22.23      A    C   
ATOM   1546  O   PHE   190      12.895  42.583  17.144  1.00 22.45      A    O   
ATOM   1547  N   LEU   191      10.663  42.764  16.939  1.00 23.88      A    N   
ATOM   1548  CA  LEU   191      10.389  41.688  17.907  1.00 25.39      A    C   
ATOM   1549  CB  LEU   191       8.920  41.668  18.340  1.00 25.37      A    C   
ATOM   1550  CG  LEU   191       8.495  42.872  19.199  1.00 25.18      A    C   
ATOM   1551  CD1 LEU   191       6.968  43.019  19.277  1.00 27.11      A    C   
ATOM   1552  CD2 LEU   191       9.104  42.845  20.616  1.00 23.76      A    C   
ATOM   1553  C   LEU   191      10.857  40.330  17.410  1.00 26.98      A    C   
ATOM   1554  O   LEU   191      11.385  39.531  18.183  1.00 27.06      A    O   
ATOM   1555  N   ASP   192      10.654  40.052  16.132  1.00 28.15      A    N   
ATOM   1556  CA  ASP   192      11.056  38.753  15.625  1.00 30.12      A    C   
ATOM   1557  CB  ASP   192      10.379  38.409  14.297  1.00 31.35      A    C   
ATOM   1558  CG  ASP   192       9.364  37.291  14.463  1.00 36.17      A    C   
ATOM   1559  OD1 ASP   192       9.771  36.139  14.781  1.00 41.49      A    O   
ATOM   1560  OD2 ASP   192       8.160  37.567  14.329  1.00 41.48      A    O   
ATOM   1561  C   ASP   192      12.568  38.555  15.591  1.00 30.20      A    C   
ATOM   1562  O   ASP   192      13.040  37.511  16.018  1.00 30.84      A    O   
ATOM   1563  N   ASP   193      13.321  39.571  15.159  1.00 29.46      A    N   
ATOM   1564  CA  ASP   193      14.777  39.460  15.066  1.00 29.90      A    C   
ATOM   1565  CB  ASP   193      15.302  40.239  13.854  1.00 31.22      A    C   
ATOM   1566  CG  ASP   193      14.807  39.658  12.515  1.00 34.81      A    C   
ATOM   1567  OD1 ASP   193      14.371  38.486  12.482  1.00 39.17      A    O   
ATOM   1568  OD2 ASP   193      14.852  40.388  11.500  1.00 39.73      A    O   
ATOM   1569  C   ASP   193      15.497  39.901  16.352  1.00 28.40      A    C   
ATOM   1570  O   ASP   193      16.721  39.709  16.475  1.00 27.81      A    O   
ATOM   1571  N   LYS   194      14.732  40.483  17.284  1.00 26.79      A    N   
ATOM   1572  CA  LYS   194      15.248  41.003  18.554  1.00 27.00      A    C   
ATOM   1573  CB  LYS   194      15.602  39.849  19.503  1.00 28.11      A    C   
ATOM   1574  CG  LYS   194      14.444  38.884  19.781  1.00 29.34      A    C   
ATOM   1575  CD  LYS   194      14.929  37.810  20.762  1.00 35.22      A    C   
ATOM   1576  CE  LYS   194      13.930  36.669  20.924  1.00 38.08      A    C   
ATOM   1577  NZ  LYS   194      14.511  35.620  21.821  1.00 41.25      A    N   
ATOM   1578  C   LYS   194      16.445  41.956  18.376  1.00 27.17      A    C   
ATOM   1579  O   LYS   194      17.475  41.839  19.068  1.00 26.60      A    O   
ATOM   1580  N   ARG   195      16.316  42.886  17.430  1.00 25.73      A    N   
ATOM   1581  CA  ARG   195      17.346  43.893  17.230  1.00 26.18      A    C   
ATOM   1582  CB  ARG   195      18.107  43.690  15.910  1.00 27.44      A    C   
ATOM   1583  CG  ARG   195      17.246  43.556  14.757  1.00 28.65      A    C   
ATOM   1584  CD  ARG   195      17.921  43.932  13.416  1.00 33.06      A    C   
ATOM   1585  NE  ARG   195      16.809  44.043  12.482  1.00 33.18      A    N   
ATOM   1586  CZ  ARG   195      16.288  45.174  12.024  1.00 35.07      A    C   
ATOM   1587  NH1 ARG   195      16.805  46.363  12.327  1.00 35.04      A    N   
ATOM   1588  NH2 ARG   195      15.228  45.100  11.231  1.00 35.77      A    N   
ATOM   1589  C   ARG   195      16.712  45.269  17.258  1.00 25.81      A    C   
ATOM   1590  O   ARG   195      15.541  45.421  16.901  1.00 24.67      A    O   
ATOM   1591  N   CYS   196      17.493  46.265  17.690  1.00 25.17      A    N   
ATOM   1592  CA  CYS   196      17.020  47.644  17.788  1.00 24.89      A    C   
ATOM   1593  CB  CYS   196      17.363  48.249  19.172  1.00 25.26      A    C   
ATOM   1594  SG  CYS   196      16.378  47.607  20.518  1.00 29.76      A    S   
ATOM   1595  C   CYS   196      17.582  48.557  16.711  1.00 24.18      A    C   
ATOM   1596  O   CYS   196      18.673  48.332  16.151  1.00 24.50      A    O   
ATOM   1597  N   GLU   197      16.843  49.618  16.449  1.00 23.36      A    N   
ATOM   1598  CA  GLU   197      17.271  50.654  15.537  1.00 23.74      A    C   
ATOM   1599  CB  GLU   197      16.681  50.328  14.175  1.00 24.30      A    C   
ATOM   1600  CG  GLU   197      17.229  51.094  13.106  1.00 28.31      A    C   
ATOM   1601  CD  GLU   197      16.779  50.574  11.739  1.00 28.51      A    C   
ATOM   1602  OE1 GLU   197      16.108  49.502  11.626  1.00 31.61      A    O   
ATOM   1603  OE2 GLU   197      17.116  51.257  10.782  1.00 31.47      A    O   
ATOM   1604  C   GLU   197      16.739  51.995  16.005  1.00 22.94      A    C   
ATOM   1605  O   GLU   197      15.590  52.071  16.437  1.00 23.12      A    O   
ATOM   1606  N   TRP   198      17.564  53.050  15.910  1.00 22.46      A    N   
ATOM   1607  CA  TRP   198      17.072  54.419  16.114  1.00 22.05      A    C   
ATOM   1608  CB  TRP   198      18.196  55.361  16.568  1.00 22.37      A    C   
ATOM   1609  CG  TRP   198      18.604  55.146  17.968  1.00 23.69      A    C   
ATOM   1610  CD1 TRP   198      19.653  54.427  18.406  1.00 24.54      A    C   
ATOM   1611  NE1 TRP   198      19.719  54.456  19.785  1.00 25.80      A    N   
ATOM   1612  CE2 TRP   198      18.664  55.190  20.257  1.00 23.60      A    C   
ATOM   1613  CD2 TRP   198      17.937  55.649  19.133  1.00 23.83      A    C   
ATOM   1614  CE3 TRP   198      16.788  56.429  19.332  1.00 23.73      A    C   
ATOM   1615  CZ3 TRP   198      16.421  56.749  20.645  1.00 23.65      A    C   
ATOM   1616  CH2 TRP   198      17.189  56.297  21.738  1.00 23.44      A    C   
ATOM   1617  CZ2 TRP   198      18.314  55.533  21.571  1.00 23.23      A    C   
ATOM   1618  C   TRP   198      16.463  54.975  14.836  1.00 22.26      A    C   
ATOM   1619  O   TRP   198      17.078  54.913  13.766  1.00 22.58      A    O   
ATOM   1620  N   ILE   199      15.254  55.518  14.949  1.00 22.43      A    N   
ATOM   1621  CA  ILE   199      14.496  56.010  13.814  1.00 22.27      A    C   
ATOM   1622  CB  ILE   199      13.385  55.003  13.402  1.00 22.13      A    C   
ATOM   1623  CG1 ILE   199      14.011  53.644  13.051  1.00 21.58      A    C   
ATOM   1624  CD1 ILE   199      12.999  52.559  12.729  1.00 20.55      A    C   
ATOM   1625  CG2 ILE   199      12.468  55.561  12.235  1.00 20.51      A    C   
ATOM   1626  C   ILE   199      13.856  57.338  14.167  1.00 23.19      A    C   
ATOM   1627  O   ILE   199      13.371  57.537  15.290  1.00 22.92      A    O   
ATOM   1628  N   TYR   200      13.856  58.258  13.211  1.00 23.19      A    N   
ATOM   1629  CA  TYR   200      13.181  59.541  13.400  1.00 23.38      A    C   
ATOM   1630  CB  TYR   200      13.479  60.432  12.181  1.00 24.91      A    C   
ATOM   1631  CG  TYR   200      12.694  61.712  12.166  1.00 24.47      A    C   
ATOM   1632  CD1 TYR   200      12.829  62.640  13.214  1.00 24.20      A    C   
ATOM   1633  CE1 TYR   200      12.120  63.859  13.201  1.00 24.57      A    C   
ATOM   1634  CZ  TYR   200      11.280  64.142  12.156  1.00 25.44      A    C   
ATOM   1635  OH  TYR   200      10.569  65.331  12.131  1.00 28.50      A    O   
ATOM   1636  CE2 TYR   200      11.133  63.245  11.091  1.00 26.12      A    C   
ATOM   1637  CD2 TYR   200      11.857  62.029  11.098  1.00 26.97      A    C   
ATOM   1638  C   TYR   200      11.662  59.384  13.598  1.00 23.26      A    C   
ATOM   1639  O   TYR   200      11.000  58.668  12.840  1.00 22.54      A    O   
ATOM   1640  N   ARG   201      11.091  60.051  14.610  1.00 23.69      A    N   
ATOM   1641  CA  ARG   201       9.654  59.895  14.878  1.00 24.36      A    C   
ATOM   1642  CB  ARG   201       9.266  60.498  16.231  1.00 24.88      A    C   
ATOM   1643  CG  ARG   201       9.833  59.734  17.384  1.00 26.58      A    C   
ATOM   1644  CD  ARG   201       9.200  60.159  18.710  1.00 26.28      A    C   
ATOM   1645  NE  ARG   201       9.562  61.524  19.120  1.00 26.92      A    N   
ATOM   1646  CZ  ARG   201       8.732  62.566  19.125  1.00 27.45      A    C   
ATOM   1647  NH1 ARG   201       7.481  62.425  18.687  1.00 25.56      A    N   
ATOM   1648  NH2 ARG   201       9.162  63.773  19.549  1.00 26.01      A    N   
ATOM   1649  C   ARG   201       8.705  60.384  13.767  1.00 24.86      A    C   
ATOM   1650  O   ARG   201       7.507  60.083  13.784  1.00 25.26      A    O   
ATOM   1651  N   GLY   202       9.224  61.144  12.806  1.00 23.88      A    N   
ATOM   1652  CA  GLY   202       8.402  61.541  11.671  1.00 24.49      A    C   
ATOM   1653  C   GLY   202       8.659  60.681  10.440  1.00 24.20      A    C   
ATOM   1654  O   GLY   202       8.171  60.998   9.354  1.00 24.50      A    O   
ATOM   1655  N   SER   203       9.425  59.604  10.609  1.00 24.52      A    N   
ATOM   1656  CA  SER   203       9.765  58.704   9.482  1.00 24.94      A    C   
ATOM   1657  CB  SER   203      10.883  57.724   9.849  1.00 24.80      A    C   
ATOM   1658  OG  SER   203      11.058  56.694   8.845  1.00 24.15      A    O   
ATOM   1659  C   SER   203       8.533  57.920   9.046  1.00 25.74      A    C   
ATOM   1660  O   SER   203       7.774  57.452   9.879  1.00 25.11      A    O   
ATOM   1661  N   THR   204       8.376  57.737   7.729  1.00 27.13      A    N   
ATOM   1662  CA  THR   204       7.268  56.935   7.201  1.00 28.63      A    C   
ATOM   1663  CB  THR   204       7.034  57.179   5.696  1.00 28.86      A    C   
ATOM   1664  OG1 THR   204       8.293  57.102   5.029  1.00 30.83      A    O   
ATOM   1665  CG2 THR   204       6.421  58.563   5.470  1.00 32.24      A    C   
ATOM   1666  C   THR   204       7.539  55.448   7.397  1.00 27.93      A    C   
ATOM   1667  O   THR   204       6.700  54.615   7.048  1.00 28.95      A    O   
ATOM   1668  N   ARG   205       8.700  55.114   7.961  1.00 26.76      A    N   
ATOM   1669  CA  ARG   205       8.980  53.730   8.372  1.00 25.56      A    C   
ATOM   1670  CB  ARG   205      10.457  53.547   8.713  1.00 24.52      A    C   
ATOM   1671  CG  ARG   205      11.408  53.569   7.513  1.00 25.50      A    C   
ATOM   1672  CD  ARG   205      12.816  53.277   7.928  1.00 22.97      A    C   
ATOM   1673  NE  ARG   205      12.994  51.894   8.382  1.00 24.21      A    N   
ATOM   1674  CZ  ARG   205      13.995  51.484   9.149  1.00 25.11      A    C   
ATOM   1675  NH1 ARG   205      14.920  52.360   9.574  1.00 26.43      A    N   
ATOM   1676  NH2 ARG   205      14.065  50.204   9.522  1.00 24.70      A    N   
ATOM   1677  C   ARG   205       8.132  53.340   9.583  1.00 25.63      A    C   
ATOM   1678  O   ARG   205       7.975  52.154   9.870  1.00 25.00      A    O   
ATOM   1679  N   LEU   206       7.615  54.327  10.314  1.00 25.37      A    N   
ATOM   1680  CA  LEU   206       6.752  54.057  11.467  1.00 26.66      A    C   
ATOM   1681  CB  LEU   206       6.932  55.121  12.558  1.00 26.91      A    C   
ATOM   1682  CG  LEU   206       8.360  55.266  13.067  1.00 25.37      A    C   
ATOM   1683  CD1 LEU   206       8.430  56.508  13.966  1.00 25.02      A    C   
ATOM   1684  CD2 LEU   206       8.822  54.016  13.771  1.00 27.72      A    C   
ATOM   1685  C   LEU   206       5.314  54.041  10.971  1.00 29.09      A    C   
ATOM   1686  O   LEU   206       4.849  55.029  10.388  1.00 28.64      A    O   
ATOM   1687  N   GLU   207       4.618  52.927  11.183  1.00 31.26      A    N   
ATOM   1688  CA  GLU   207       3.282  52.754  10.566  1.00 34.27      A    C   
ATOM   1689  CB  GLU   207       2.701  51.359  10.827  1.00 34.33      A    C   
ATOM   1690  CG  GLU   207       1.367  51.074  10.118  1.00 37.61      A    C   
ATOM   1691  CD  GLU   207       0.159  51.609  10.882  1.00 43.10      A    C   
ATOM   1692  OE1 GLU   207       0.221  51.697  12.133  1.00 44.09      A    O   
ATOM   1693  OE2 GLU   207      -0.863  51.952  10.232  1.00 46.83      A    O   
ATOM   1694  C   GLU   207       2.299  53.869  10.948  1.00 35.60      A    C   
ATOM   1695  O   GLU   207       1.582  54.370  10.070  1.00 36.76      A    O   
ATOM   1696  N   PRO   208       2.240  54.247  12.248  1.00 37.26      A    N   
ATOM   1697  CA  PRO   208       1.397  55.375  12.652  1.00 37.94      A    C   
ATOM   1698  CB  PRO   208       1.720  55.521  14.144  1.00 38.04      A    C   
ATOM   1699  CG  PRO   208       2.072  54.167  14.574  1.00 38.06      A    C   
ATOM   1700  CD  PRO   208       2.864  53.610  13.426  1.00 37.74      A    C   
ATOM   1701  C   PRO   208       1.723  56.677  11.910  1.00 38.96      A    C   
ATOM   1702  O   PRO   208       0.837  57.526  11.732  1.00 39.24      A    O   
END
