
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 ( 1434),  selected   92 , name 2bud_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2bud_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   363_A      E       1           -
LGA    S   364_A      N       2           -
LGA    H   365_A      L       3           -
LGA    M   366_A      Y       4           -
LGA    D   367_A      F       5           -
LGA    P   368_A      -       -           -
LGA    L   369_A      -       -           -
LGA    M   370_A      -       -           -
LGA    Q   371_A      Q       6          5.000
LGA    K   372_A      G       7          2.940
LGA    I   373_A      D       8          3.426
LGA    D   374_A      L       9          3.080
LGA    I   375_A      I      10          1.322
LGA    S   376_A      -       -           -
LGA    E   377_A      -       -           -
LGA    N   378_A      V      11           #
LGA    P   379_A      S      12          2.064
LGA    D   380_A      -       -           -
LGA    K   381_A      M      13          3.353
LGA    I   382_A      R      14          1.478
LGA    Y   383_A      I      15          0.818
LGA    F   384_A      L      16          0.548
LGA    I   385_A      G      17          0.721
LGA    R   386_A      K      18          1.893
LGA    R   387_A      K      19          1.944
LGA    E   388_A      R      20          3.489
LGA    D   389_A      T      21          2.691
LGA    G   390_A      K      22          1.926
LGA    T   391_A      T      23          0.963
LGA    V   392_A      W      24          0.558
LGA    H   393_A      X      25          0.699
LGA    R   394_A      K      26          0.906
LGA    G   395_A      G      27          1.068
LGA    Q   396_A      T      28          0.624
LGA    V   397_A      L      29          0.711
LGA    L   398_A      I      30          1.407
LGA    Q   399_A      A      31          0.949
LGA    S   400_A      I      32          0.700
LGA    R   401_A      Q      33          1.440
LGA    T   402_A      T      34          2.172
LGA    T   403_A      V      35          0.967
LGA    E   404_A      G      36          2.050
LGA    N   405_A      P      37          3.023
LGA    A   406_A      -       -           -
LGA    A   407_A      -       -           -
LGA    A   408_A      -       -           -
LGA    P   409_A      G      38          1.610
LGA    D   410_A      K      39          0.787
LGA    E   411_A      K      40          0.557
LGA    Y   412_A      Y      41          0.693
LGA    Y   413_A      K      42          0.804
LGA    V   414_A      V      43          0.520
LGA    H   415_A      K      44          0.343
LGA    Y   416_A      F      45          0.525
LGA    V   417_A      D      46          1.034
LGA    G   418_A      N      47          2.143
LGA    L   419_A      K      48          1.702
LGA    N   420_A      G      49          3.864
LGA    R   421_A      -       -           -
LGA    R   422_A      -       -           -
LGA    L   423_A      -       -           -
LGA    D   424_A      K      50          0.720
LGA    G   425_A      S      51          2.388
LGA    W   426_A      L      52          0.664
LGA    V   427_A      L      53          0.674
LGA    G   428_A      S      54          0.886
LGA    R   429_A      G      55          0.771
LGA    H   430_A      N      56          0.762
LGA    R   431_A      X      57          0.980
LGA    I   432_A      I      58          0.891
LGA    S   433_A      A      59          1.280
LGA    D   434_A      Y      60          0.744
LGA    N   435_A      D      61          3.420
LGA    A   436_A      Y      62          6.599
LGA    D   437_A      -       -           -
LGA    D   438_A      -       -           -
LGA    L   439_A      -       -           -
LGA    G   440_A      -       -           -
LGA    G   441_A      -       -           -
LGA    I   442_A      -       -           -
LGA    T   443_A      -       -           -
LGA    V   444_A      -       -           -
LGA    L   445_A      -       -           -
LGA    P   446_A      -       -           -
LGA    A   447_A      -       -           -
LGA    P   448_A      -       -           -
LGA    P   449_A      -       -           -
LGA    L   450_A      -       -           -
LGA    A   451_A      -       -           -
LGA    P   452_A      -       -           -
LGA    D   453_A      -       -           -
LGA    Q   454_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92   62    5.0     56    2.04    14.29     81.225     2.620

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.724533 * X  +   0.670540 * Y  +   0.159463 * Z  +  37.178783
  Y_new =  -0.533148 * X  +  -0.691869 * Y  +   0.486899 * Z  +  67.793732
  Z_new =   0.436813 * X  +   0.267757 * Y  +   0.858778 * Z  +  -0.599710 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.302236   -2.839356  [ DEG:    17.3169   -162.6831 ]
  Theta =  -0.452053   -2.689540  [ DEG:   -25.9007   -154.0993 ]
  Phi   =  -2.507209    0.634383  [ DEG:  -143.6525     36.3475 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2bud_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2bud_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92   62   5.0   56   2.04   14.29  81.225
REMARK  ---------------------------------------------------------- 
MOLECULE 2bud_A
HEADER    TRANSFERASE                             09-JUN-05   2BUD              
TITLE     THE SOLUTION STRUCTURE OF THE CHROMO BARREL DOMAIN FROM THE           
TITLE    2 MALES-ABSENT ON THE FIRST (MOF) PROTEIN                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MALES-ABSENT ON THE FIRST PROTEIN;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CHROMO BARREL DOMAIN, RESIDUES 367-454;                    
COMPND   5 SYNONYM: PUTATIVE ACETYL TRANSFERASE MOF;                            
COMPND   6 EC: 2.3.1.48;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DROSOPHILA MELANOGASTER;                        
SOURCE   3 ORGANISM_COMMON: FRUIT FLY;                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   6 EXPRESSION_SYSTEM_VARIANT: TUNER(DE3) PLACI;                         
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    MOF,HAT,ACETYL-TRANSFER,DOSAGE COMPENSATION COMPLEX,DCC,              
KEYWDS   2 ROYAL FAMILY,CHROMODOMAIN LIKE,BETA BARREL,TRANSFERASE               
KEYWDS   3 ACYLTRANSFERASE, METAL-BINDING                                       
EXPDTA    NMR, 25 STRUCTURES                                                    
AUTHOR    P.R.NIELSEN,D.NIETLISPACH,A.BUSCAINO,R.J.WARNER,A.AKHTAR,             
AUTHOR   2 A.G.MURZIN,N.V.MURZINA,E.D.LAUE                                      
REVDAT   2   15-SEP-05 2BUD    1       JRNL                                     
REVDAT   1   24-JUN-05 2BUD    0                                                
JRNL        AUTH   P.R.NIELSEN,D.NIETLISPACH,A.BUSCAINO,R.J.WARNER,             
JRNL        AUTH 2 A.AKHTAR,A.G.MURZIN,N.V.MURZINA,E.D.LAUE                     
JRNL        TITL   STRUCTURE OF THE CHROMO BARREL DOMAIN FROM THE MOF           
JRNL        TITL 2 ACETYLTRANSFERASE.                                           
JRNL        REF    J.BIOL.CHEM.                  V. 280 32326 2005              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2BUD A  363   366  UNP    O02193   MOF_DROME      363    366             
DBREF  2BUD A  367   454  UNP    O02193   MOF_DROME      367    454             
SEQRES   1 A   92  GLY SER HIS MET ASP PRO LEU MET GLN LYS ILE ASP ILE          
SEQRES   2 A   92  SER GLU ASN PRO ASP LYS ILE TYR PHE ILE ARG ARG GLU          
SEQRES   3 A   92  ASP GLY THR VAL HIS ARG GLY GLN VAL LEU GLN SER ARG          
SEQRES   4 A   92  THR THR GLU ASN ALA ALA ALA PRO ASP GLU TYR TYR VAL          
SEQRES   5 A   92  HIS TYR VAL GLY LEU ASN ARG ARG LEU ASP GLY TRP VAL          
SEQRES   6 A   92  GLY ARG HIS ARG ILE SER ASP ASN ALA ASP ASP LEU GLY          
SEQRES   7 A   92  GLY ILE THR VAL LEU PRO ALA PRO PRO LEU ALA PRO ASP          
SEQRES   8 A   92  GLN                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A 363      22.437  80.588  -5.721  1.00 11.64           N  
ATOM      2  CA  GLY A 363      22.822  80.265  -7.124  1.00 11.03           C  
ATOM      3  C   GLY A 363      22.757  81.473  -8.037  1.00 10.23           C  
ATOM      4  O   GLY A 363      22.250  81.387  -9.156  1.00 10.21           O  
ATOM      5  H2  GLY A 363      22.333  79.713  -5.169  1.00 11.91           H  
ATOM      6  HA2 GLY A 363      23.831  79.878  -7.127  1.00 11.23           H  
ATOM      7  HA3 GLY A 363      22.156  79.505  -7.502  1.00 11.16           H  
ATOM      8  H1  GLY A 363      21.534  81.102  -5.708  1.00 11.74           H  
ATOM      9  H3  GLY A 363      23.167  81.181  -5.277  1.00 11.90           H  
ATOM     10  N   SER A 364      23.274  82.604  -7.560  1.00  9.80           N  
ATOM     11  CA  SER A 364      23.276  83.837  -8.339  1.00  9.25           C  
ATOM     12  C   SER A 364      24.086  84.920  -7.634  1.00  8.36           C  
ATOM     13  O   SER A 364      23.898  85.169  -6.443  1.00  8.24           O  
ATOM     14  CB  SER A 364      21.843  84.326  -8.564  1.00  9.60           C  
ATOM     15  OG  SER A 364      21.191  84.579  -7.331  1.00  9.86           O  
ATOM     16  H   SER A 364      23.665  82.606  -6.662  1.00 10.02           H  
ATOM     17  HA  SER A 364      23.730  83.627  -9.296  1.00  9.49           H  
ATOM     18  HB2 SER A 364      21.862  85.239  -9.140  1.00  9.79           H  
ATOM     19  HB3 SER A 364      21.288  83.572  -9.103  1.00  9.74           H  
ATOM     20  HG  SER A 364      20.558  83.880  -7.154  1.00 10.13           H  
ATOM     21  N   HIS A 365      24.985  85.555  -8.382  1.00  7.98           N  
ATOM     22  CA  HIS A 365      25.835  86.613  -7.842  1.00  7.35           C  
ATOM     23  C   HIS A 365      26.684  86.097  -6.683  1.00  6.30           C  
ATOM     24  O   HIS A 365      26.172  85.817  -5.600  1.00  6.44           O  
ATOM     25  CB  HIS A 365      24.985  87.800  -7.379  1.00  7.88           C  
ATOM     26  CG  HIS A 365      25.777  88.885  -6.714  1.00  7.65           C  
ATOM     27  ND1 HIS A 365      26.801  89.563  -7.342  1.00  7.18           N  
ATOM     28  CD2 HIS A 365      25.690  89.406  -5.467  1.00  8.07           C  
ATOM     29  CE1 HIS A 365      27.310  90.455  -6.510  1.00  7.26           C  
ATOM     30  NE2 HIS A 365      26.653  90.380  -5.367  1.00  7.79           N  
ATOM     31  H   HIS A 365      25.081  85.306  -9.325  1.00  8.31           H  
ATOM     32  HA  HIS A 365      26.494  86.943  -8.632  1.00  7.51           H  
ATOM     33  HB2 HIS A 365      24.487  88.231  -8.234  1.00  8.26           H  
ATOM     34  HB3 HIS A 365      24.244  87.449  -6.676  1.00  8.33           H  
ATOM     35  HD1 HIS A 365      27.109  89.413  -8.259  1.00  7.00           H  
ATOM     36  HD2 HIS A 365      24.993  89.111  -4.695  1.00  8.67           H  
ATOM     37  HE1 HIS A 365      28.123  91.131  -6.728  1.00  7.11           H  
ATOM     38  HE2 HIS A 365      26.891  90.862  -4.546  1.00  8.09           H  
ATOM     39  N   MET A 366      27.988  85.983  -6.918  1.00  5.51           N  
ATOM     40  CA  MET A 366      28.905  85.508  -5.891  1.00  4.67           C  
ATOM     41  C   MET A 366      29.094  86.561  -4.805  1.00  4.56           C  
ATOM     42  O   MET A 366      29.364  87.726  -5.097  1.00  4.71           O  
ATOM     43  CB  MET A 366      30.257  85.145  -6.511  1.00  4.15           C  
ATOM     44  CG  MET A 366      30.174  84.041  -7.553  1.00  3.72           C  
ATOM     45  SD  MET A 366      29.564  82.485  -6.871  1.00  3.31           S  
ATOM     46  CE  MET A 366      29.597  81.436  -8.324  1.00  2.76           C  
ATOM     47  H   MET A 366      28.339  86.228  -7.799  1.00  5.70           H  
ATOM     48  HA  MET A 366      28.475  84.623  -5.445  1.00  4.86           H  
ATOM     49  HB2 MET A 366      30.671  86.025  -6.982  1.00  4.39           H  
ATOM     50  HB3 MET A 366      30.924  84.820  -5.728  1.00  4.31           H  
ATOM     51  HG2 MET A 366      29.505  84.356  -8.341  1.00  4.07           H  
ATOM     52  HG3 MET A 366      31.158  83.876  -7.964  1.00  3.90           H  
ATOM     53  HE1 MET A 366      30.203  81.898  -9.089  1.00  2.90           H  
ATOM     54  HE2 MET A 366      30.017  80.475  -8.065  1.00  2.96           H  
ATOM     55  HE3 MET A 366      28.591  81.303  -8.694  1.00  2.91           H  
ATOM     56  N   ASP A 367      28.954  86.142  -3.551  1.00  4.67           N  
ATOM     57  CA  ASP A 367      29.111  87.045  -2.416  1.00  4.80           C  
ATOM     58  C   ASP A 367      30.514  87.650  -2.403  1.00  4.50           C  
ATOM     59  O   ASP A 367      31.464  87.034  -2.885  1.00  4.10           O  
ATOM     60  CB  ASP A 367      28.843  86.304  -1.105  1.00  4.92           C  
ATOM     61  CG  ASP A 367      27.426  85.772  -1.022  1.00  5.55           C  
ATOM     62  OD1 ASP A 367      26.482  86.588  -1.080  1.00  6.06           O  
ATOM     63  OD2 ASP A 367      27.261  84.541  -0.898  1.00  5.80           O  
ATOM     64  H   ASP A 367      28.740  85.199  -3.385  1.00  4.91           H  
ATOM     65  HA  ASP A 367      28.390  87.840  -2.525  1.00  5.35           H  
ATOM     66  HB2 ASP A 367      29.526  85.470  -1.024  1.00  4.64           H  
ATOM     67  HB3 ASP A 367      29.005  86.979  -0.278  1.00  5.17           H  
ATOM     68  N   PRO A 368      30.660  88.875  -1.857  1.00  4.98           N  
ATOM     69  CA  PRO A 368      31.957  89.562  -1.791  1.00  5.12           C  
ATOM     70  C   PRO A 368      32.898  88.953  -0.752  1.00  5.15           C  
ATOM     71  O   PRO A 368      33.628  89.670  -0.068  1.00  5.66           O  
ATOM     72  CB  PRO A 368      31.578  90.990  -1.396  1.00  5.90           C  
ATOM     73  CG  PRO A 368      30.308  90.842  -0.635  1.00  6.16           C  
ATOM     74  CD  PRO A 368      29.578  89.687  -1.268  1.00  5.69           C  
ATOM     75  HA  PRO A 368      32.447  89.572  -2.754  1.00  4.98           H  
ATOM     76  HB2 PRO A 368      32.359  91.415  -0.784  1.00  6.24           H  
ATOM     77  HB3 PRO A 368      31.439  91.588  -2.284  1.00  6.10           H  
ATOM     78  HG2 PRO A 368      30.523  90.627   0.400  1.00  6.43           H  
ATOM     79  HG3 PRO A 368      29.722  91.746  -0.719  1.00  6.59           H  
ATOM     80  HD2 PRO A 368      29.041  89.126  -0.518  1.00  5.88           H  
ATOM     81  HD3 PRO A 368      28.902  90.040  -2.032  1.00  5.87           H  
ATOM     82  N   LEU A 369      32.876  87.628  -0.644  1.00  4.84           N  
ATOM     83  CA  LEU A 369      33.720  86.915   0.301  1.00  5.12           C  
ATOM     84  C   LEU A 369      33.663  85.417   0.040  1.00  4.61           C  
ATOM     85  O   LEU A 369      34.681  84.726   0.102  1.00  4.91           O  
ATOM     86  CB  LEU A 369      33.288  87.225   1.738  1.00  5.80           C  
ATOM     87  CG  LEU A 369      34.096  86.537   2.850  1.00  6.34           C  
ATOM     88  CD1 LEU A 369      33.607  85.112   3.073  1.00  6.73           C  
ATOM     89  CD2 LEU A 369      35.582  86.535   2.519  1.00  6.94           C  
ATOM     90  H   LEU A 369      32.275  87.117  -1.215  1.00  4.61           H  
ATOM     91  HA  LEU A 369      34.736  87.253   0.160  1.00  5.45           H  
ATOM     92  HB2 LEU A 369      33.354  88.292   1.881  1.00  6.13           H  
ATOM     93  HB3 LEU A 369      32.254  86.933   1.845  1.00  5.89           H  
ATOM     94  HG  LEU A 369      33.960  87.081   3.775  1.00  6.42           H  
ATOM     95 HD11 LEU A 369      32.607  85.009   2.678  1.00  7.08           H  
ATOM     96 HD12 LEU A 369      34.268  84.421   2.568  1.00  6.77           H  
ATOM     97 HD13 LEU A 369      33.600  84.894   4.131  1.00  6.95           H  
ATOM     98 HD21 LEU A 369      35.825  87.421   1.952  1.00  7.21           H  
ATOM     99 HD22 LEU A 369      36.156  86.524   3.434  1.00  7.21           H  
ATOM    100 HD23 LEU A 369      35.819  85.657   1.934  1.00  7.18           H  
ATOM    101  N   MET A 370      32.467  84.919  -0.256  1.00  4.12           N  
ATOM    102  CA  MET A 370      32.278  83.501  -0.531  1.00  3.87           C  
ATOM    103  C   MET A 370      32.748  83.161  -1.949  1.00  3.02           C  
ATOM    104  O   MET A 370      32.177  82.299  -2.618  1.00  3.06           O  
ATOM    105  CB  MET A 370      30.803  83.126  -0.349  1.00  4.63           C  
ATOM    106  CG  MET A 370      30.532  81.629  -0.383  1.00  5.03           C  
ATOM    107  SD  MET A 370      31.427  80.730   0.899  1.00  5.63           S  
ATOM    108  CE  MET A 370      30.865  79.057   0.596  1.00  5.52           C  
ATOM    109  H   MET A 370      31.694  85.520  -0.293  1.00  4.15           H  
ATOM    110  HA  MET A 370      32.875  82.946   0.178  1.00  4.18           H  
ATOM    111  HB2 MET A 370      30.463  83.507   0.604  1.00  5.14           H  
ATOM    112  HB3 MET A 370      30.227  83.590  -1.135  1.00  4.81           H  
ATOM    113  HG2 MET A 370      29.474  81.465  -0.244  1.00  5.22           H  
ATOM    114  HG3 MET A 370      30.831  81.245  -1.347  1.00  5.24           H  
ATOM    115  HE1 MET A 370      30.613  78.945  -0.449  1.00  5.67           H  
ATOM    116  HE2 MET A 370      31.650  78.361   0.855  1.00  5.67           H  
ATOM    117  HE3 MET A 370      29.991  78.855   1.200  1.00  5.59           H  
ATOM    118  N   GLN A 371      33.797  83.845  -2.398  1.00  2.80           N  
ATOM    119  CA  GLN A 371      34.354  83.618  -3.727  1.00  2.63           C  
ATOM    120  C   GLN A 371      35.268  82.399  -3.726  1.00  2.21           C  
ATOM    121  O   GLN A 371      36.467  82.523  -3.966  1.00  2.80           O  
ATOM    122  CB  GLN A 371      35.126  84.851  -4.201  1.00  3.46           C  
ATOM    123  CG  GLN A 371      34.269  86.104  -4.297  1.00  3.91           C  
ATOM    124  CD  GLN A 371      35.036  87.317  -4.798  1.00  4.54           C  
ATOM    125  OE1 GLN A 371      34.473  88.406  -4.924  1.00  4.97           O  
ATOM    126  NE2 GLN A 371      36.322  87.142  -5.088  1.00  5.04           N  
ATOM    127  H   GLN A 371      34.212  84.517  -1.819  1.00  3.22           H  
ATOM    128  HA  GLN A 371      33.532  83.436  -4.404  1.00  2.81           H  
ATOM    129  HB2 GLN A 371      35.933  85.044  -3.509  1.00  3.90           H  
ATOM    130  HB3 GLN A 371      35.540  84.648  -5.177  1.00  3.78           H  
ATOM    131  HG2 GLN A 371      33.451  85.911  -4.976  1.00  3.97           H  
ATOM    132  HG3 GLN A 371      33.874  86.328  -3.317  1.00  4.18           H  
ATOM    133 HE21 GLN A 371      36.708  86.251  -4.967  1.00  5.03           H  
ATOM    134 HE22 GLN A 371      36.830  87.913  -5.415  1.00  5.61           H  
ATOM    135  N   LYS A 372      34.679  81.233  -3.436  1.00  1.82           N  
ATOM    136  CA  LYS A 372      35.397  79.952  -3.374  1.00  1.77           C  
ATOM    137  C   LYS A 372      36.614  80.012  -2.447  1.00  1.50           C  
ATOM    138  O   LYS A 372      37.358  80.991  -2.426  1.00  1.89           O  
ATOM    139  CB  LYS A 372      35.791  79.444  -4.773  1.00  2.26           C  
ATOM    140  CG  LYS A 372      36.726  80.352  -5.555  1.00  2.93           C  
ATOM    141  CD  LYS A 372      37.120  79.728  -6.884  1.00  3.98           C  
ATOM    142  CE  LYS A 372      38.037  80.641  -7.682  1.00  4.77           C  
ATOM    143  NZ  LYS A 372      38.438  80.026  -8.979  1.00  5.39           N  
ATOM    144  H   LYS A 372      33.719  81.235  -3.247  1.00  2.14           H  
ATOM    145  HA  LYS A 372      34.705  79.239  -2.947  1.00  2.10           H  
ATOM    146  HB2 LYS A 372      36.277  78.487  -4.664  1.00  2.35           H  
ATOM    147  HB3 LYS A 372      34.891  79.309  -5.355  1.00  2.71           H  
ATOM    148  HG2 LYS A 372      36.224  81.289  -5.745  1.00  3.14           H  
ATOM    149  HG3 LYS A 372      37.616  80.530  -4.970  1.00  3.02           H  
ATOM    150  HD2 LYS A 372      37.634  78.796  -6.695  1.00  4.25           H  
ATOM    151  HD3 LYS A 372      36.227  79.536  -7.460  1.00  4.37           H  
ATOM    152  HE2 LYS A 372      37.517  81.567  -7.879  1.00  5.03           H  
ATOM    153  HE3 LYS A 372      38.921  80.840  -7.099  1.00  5.07           H  
ATOM    154  HZ1 LYS A 372      37.805  79.232  -9.209  1.00  5.55           H  
ATOM    155  HZ2 LYS A 372      38.383  80.731  -9.741  1.00  5.68           H  
ATOM    156  HZ3 LYS A 372      39.413  79.671  -8.920  1.00  5.78           H  
ATOM    157  N   ILE A 373      36.793  78.952  -1.662  1.00  1.42           N  
ATOM    158  CA  ILE A 373      37.896  78.864  -0.708  1.00  1.22           C  
ATOM    159  C   ILE A 373      39.236  79.224  -1.344  1.00  1.13           C  
ATOM    160  O   ILE A 373      39.608  78.687  -2.389  1.00  1.20           O  
ATOM    161  CB  ILE A 373      37.996  77.448  -0.102  1.00  1.16           C  
ATOM    162  CG1 ILE A 373      36.737  77.125   0.705  1.00  1.40           C  
ATOM    163  CG2 ILE A 373      39.240  77.322   0.767  1.00  1.26           C  
ATOM    164  CD1 ILE A 373      36.742  75.738   1.314  1.00  1.48           C  
ATOM    165  H   ILE A 373      36.156  78.208  -1.720  1.00  1.86           H  
ATOM    166  HA  ILE A 373      37.695  79.559   0.095  1.00  1.44           H  
ATOM    167  HB  ILE A 373      38.084  76.741  -0.913  1.00  1.17           H  
ATOM    168 HG12 ILE A 373      36.639  77.839   1.510  1.00  1.60           H  
ATOM    169 HG13 ILE A 373      35.875  77.201   0.059  1.00  1.77           H  
ATOM    170 HG21 ILE A 373      39.849  78.206   0.655  1.00  1.69           H  
ATOM    171 HG22 ILE A 373      38.947  77.215   1.801  1.00  1.62           H  
ATOM    172 HG23 ILE A 373      39.805  76.454   0.463  1.00  1.63           H  
ATOM    173 HD11 ILE A 373      37.613  75.199   0.973  1.00  1.86           H  
ATOM    174 HD12 ILE A 373      36.765  75.818   2.390  1.00  1.77           H  
ATOM    175 HD13 ILE A 373      35.851  75.209   1.011  1.00  1.93           H  
ATOM    176  N   ASP A 374      39.960  80.130  -0.691  1.00  1.16           N  
ATOM    177  CA  ASP A 374      41.270  80.560  -1.168  1.00  1.17           C  
ATOM    178  C   ASP A 374      42.371  79.676  -0.594  1.00  1.03           C  
ATOM    179  O   ASP A 374      42.417  79.435   0.611  1.00  1.25           O  
ATOM    180  CB  ASP A 374      41.524  82.019  -0.779  1.00  1.40           C  
ATOM    181  CG  ASP A 374      40.571  82.976  -1.467  1.00  1.77           C  
ATOM    182  OD1 ASP A 374      40.568  83.017  -2.715  1.00  2.04           O  
ATOM    183  OD2 ASP A 374      39.829  83.687  -0.756  1.00  2.17           O  
ATOM    184  H   ASP A 374      39.609  80.510   0.142  1.00  1.29           H  
ATOM    185  HA  ASP A 374      41.278  80.477  -2.244  1.00  1.24           H  
ATOM    186  HB2 ASP A 374      41.401  82.124   0.288  1.00  1.49           H  
ATOM    187  HB3 ASP A 374      42.536  82.286  -1.049  1.00  1.43           H  
ATOM    188  N   ILE A 375      43.253  79.194  -1.460  1.00  0.84           N  
ATOM    189  CA  ILE A 375      44.351  78.340  -1.028  1.00  0.76           C  
ATOM    190  C   ILE A 375      45.510  79.160  -0.478  1.00  0.76           C  
ATOM    191  O   ILE A 375      46.095  78.811   0.545  1.00  0.79           O  
ATOM    192  CB  ILE A 375      44.866  77.454  -2.173  1.00  0.77           C  
ATOM    193  CG1 ILE A 375      43.762  76.504  -2.641  1.00  0.82           C  
ATOM    194  CG2 ILE A 375      46.097  76.681  -1.722  1.00  0.84           C  
ATOM    195  CD1 ILE A 375      44.152  75.655  -3.831  1.00  0.92           C  
ATOM    196  H   ILE A 375      43.167  79.421  -2.409  1.00  0.92           H  
ATOM    197  HA  ILE A 375      43.980  77.698  -0.245  1.00  0.81           H  
ATOM    198  HB  ILE A 375      45.154  78.094  -2.994  1.00  0.83           H  
ATOM    199 HG12 ILE A 375      43.501  75.838  -1.832  1.00  0.98           H  
ATOM    200 HG13 ILE A 375      42.891  77.082  -2.917  1.00  1.01           H  
ATOM    201 HG21 ILE A 375      46.698  77.309  -1.076  1.00  1.34           H  
ATOM    202 HG22 ILE A 375      45.792  75.799  -1.178  1.00  1.37           H  
ATOM    203 HG23 ILE A 375      46.680  76.390  -2.582  1.00  1.30           H  
ATOM    204 HD11 ILE A 375      45.073  75.133  -3.614  1.00  1.43           H  
ATOM    205 HD12 ILE A 375      43.371  74.936  -4.033  1.00  1.35           H  
ATOM    206 HD13 ILE A 375      44.290  76.287  -4.694  1.00  1.44           H  
ATOM    207  N   SER A 376      45.840  80.242  -1.176  1.00  0.79           N  
ATOM    208  CA  SER A 376      46.937  81.117  -0.775  1.00  0.87           C  
ATOM    209  C   SER A 376      46.634  81.809   0.549  1.00  0.96           C  
ATOM    210  O   SER A 376      46.332  83.002   0.589  1.00  1.54           O  
ATOM    211  CB  SER A 376      47.211  82.154  -1.860  1.00  0.95           C  
ATOM    212  OG  SER A 376      46.055  82.928  -2.136  1.00  1.71           O  
ATOM    213  H   SER A 376      45.335  80.454  -1.989  1.00  0.81           H  
ATOM    214  HA  SER A 376      47.815  80.504  -0.650  1.00  0.88           H  
ATOM    215  HB2 SER A 376      48.001  82.814  -1.535  1.00  1.35           H  
ATOM    216  HB3 SER A 376      47.513  81.647  -2.760  1.00  1.34           H  
ATOM    217  HG  SER A 376      46.177  83.403  -2.961  1.00  2.20           H  
ATOM    218  N   GLU A 377      46.720  81.043   1.627  1.00  0.93           N  
ATOM    219  CA  GLU A 377      46.462  81.553   2.962  1.00  1.03           C  
ATOM    220  C   GLU A 377      46.787  80.488   3.998  1.00  0.87           C  
ATOM    221  O   GLU A 377      47.128  80.791   5.141  1.00  0.93           O  
ATOM    222  CB  GLU A 377      45.005  81.994   3.101  1.00  1.18           C  
ATOM    223  CG  GLU A 377      44.001  80.863   2.943  1.00  1.28           C  
ATOM    224  CD  GLU A 377      42.581  81.304   3.237  1.00  1.54           C  
ATOM    225  OE1 GLU A 377      42.314  81.722   4.383  1.00  1.90           O  
ATOM    226  OE2 GLU A 377      41.734  81.234   2.321  1.00  1.92           O  
ATOM    227  H   GLU A 377      46.969  80.103   1.523  1.00  1.26           H  
ATOM    228  HA  GLU A 377      47.107  82.401   3.120  1.00  1.21           H  
ATOM    229  HB2 GLU A 377      44.864  82.436   4.074  1.00  1.72           H  
ATOM    230  HB3 GLU A 377      44.795  82.736   2.346  1.00  1.51           H  
ATOM    231  HG2 GLU A 377      44.047  80.496   1.928  1.00  1.35           H  
ATOM    232  HG3 GLU A 377      44.265  80.068   3.625  1.00  1.79           H  
ATOM    233  N   ASN A 378      46.678  79.233   3.576  1.00  0.71           N  
ATOM    234  CA  ASN A 378      46.958  78.099   4.453  1.00  0.61           C  
ATOM    235  C   ASN A 378      47.104  76.801   3.656  1.00  0.58           C  
ATOM    236  O   ASN A 378      46.385  75.833   3.899  1.00  0.59           O  
ATOM    237  CB  ASN A 378      45.856  77.953   5.513  1.00  0.62           C  
ATOM    238  CG  ASN A 378      44.456  77.892   4.923  1.00  1.15           C  
ATOM    239  OD1 ASN A 378      43.468  78.057   5.636  1.00  1.16           O  
ATOM    240  ND2 ASN A 378      44.362  77.628   3.625  1.00  2.14           N  
ATOM    241  H   ASN A 378      46.402  79.068   2.648  1.00  0.72           H  
ATOM    242  HA  ASN A 378      47.895  78.300   4.953  1.00  0.66           H  
ATOM    243  HB2 ASN A 378      46.026  77.044   6.070  1.00  1.18           H  
ATOM    244  HB3 ASN A 378      45.904  78.791   6.190  1.00  1.15           H  
ATOM    245 HD21 ASN A 378      45.186  77.482   3.122  1.00  2.14           H  
ATOM    246 HD22 ASN A 378      43.469  77.592   3.226  1.00  2.89           H  
ATOM    247  N   PRO A 379      48.046  76.756   2.691  1.00  0.62           N  
ATOM    248  CA  PRO A 379      48.272  75.560   1.875  1.00  0.65           C  
ATOM    249  C   PRO A 379      48.510  74.327   2.739  1.00  0.61           C  
ATOM    250  O   PRO A 379      48.034  73.234   2.428  1.00  0.62           O  
ATOM    251  CB  PRO A 379      49.530  75.901   1.072  1.00  0.77           C  
ATOM    252  CG  PRO A 379      49.563  77.391   1.031  1.00  0.85           C  
ATOM    253  CD  PRO A 379      48.961  77.854   2.329  1.00  0.75           C  
ATOM    254  HA  PRO A 379      47.448  75.375   1.202  1.00  0.67           H  
ATOM    255  HB2 PRO A 379      50.401  75.500   1.573  1.00  0.80           H  
ATOM    256  HB3 PRO A 379      49.453  75.482   0.081  1.00  0.85           H  
ATOM    257  HG2 PRO A 379      50.583  77.733   0.948  1.00  0.98           H  
ATOM    258  HG3 PRO A 379      48.977  77.748   0.198  1.00  0.95           H  
ATOM    259  HD2 PRO A 379      49.729  77.979   3.077  1.00  0.80           H  
ATOM    260  HD3 PRO A 379      48.418  78.777   2.184  1.00  0.80           H  
ATOM    261  N   ASP A 380      49.245  74.519   3.828  1.00  0.62           N  
ATOM    262  CA  ASP A 380      49.550  73.438   4.754  1.00  0.64           C  
ATOM    263  C   ASP A 380      48.277  72.899   5.403  1.00  0.55           C  
ATOM    264  O   ASP A 380      48.187  71.712   5.717  1.00  0.55           O  
ATOM    265  CB  ASP A 380      50.518  73.925   5.833  1.00  0.75           C  
ATOM    266  CG  ASP A 380      51.848  74.367   5.256  1.00  0.86           C  
ATOM    267  OD1 ASP A 380      52.530  73.531   4.626  1.00  1.21           O  
ATOM    268  OD2 ASP A 380      52.208  75.550   5.434  1.00  1.20           O  
ATOM    269  H   ASP A 380      49.589  75.419   4.017  1.00  0.65           H  
ATOM    270  HA  ASP A 380      50.019  72.644   4.196  1.00  0.68           H  
ATOM    271  HB2 ASP A 380      50.076  74.761   6.353  1.00  0.73           H  
ATOM    272  HB3 ASP A 380      50.698  73.123   6.537  1.00  0.79           H  
ATOM    273  N   LYS A 381      47.300  73.781   5.604  1.00  0.51           N  
ATOM    274  CA  LYS A 381      46.033  73.395   6.221  1.00  0.47           C  
ATOM    275  C   LYS A 381      45.441  72.166   5.539  1.00  0.39           C  
ATOM    276  O   LYS A 381      45.273  72.140   4.320  1.00  0.37           O  
ATOM    277  CB  LYS A 381      45.031  74.552   6.158  1.00  0.50           C  
ATOM    278  CG  LYS A 381      43.677  74.215   6.759  1.00  0.52           C  
ATOM    279  CD  LYS A 381      42.668  75.328   6.538  1.00  0.59           C  
ATOM    280  CE  LYS A 381      41.303  74.960   7.096  1.00  0.67           C  
ATOM    281  NZ  LYS A 381      40.273  75.984   6.769  1.00  1.66           N  
ATOM    282  H   LYS A 381      47.434  74.714   5.337  1.00  0.53           H  
ATOM    283  HA  LYS A 381      46.228  73.162   7.255  1.00  0.51           H  
ATOM    284  HB2 LYS A 381      45.440  75.396   6.693  1.00  0.56           H  
ATOM    285  HB3 LYS A 381      44.885  74.829   5.124  1.00  0.50           H  
ATOM    286  HG2 LYS A 381      43.307  73.315   6.296  1.00  0.48           H  
ATOM    287  HG3 LYS A 381      43.795  74.051   7.821  1.00  0.55           H  
ATOM    288  HD2 LYS A 381      43.019  76.221   7.034  1.00  0.64           H  
ATOM    289  HD3 LYS A 381      42.576  75.514   5.478  1.00  0.60           H  
ATOM    290  HE2 LYS A 381      41.000  74.012   6.678  1.00  1.17           H  
ATOM    291  HE3 LYS A 381      41.380  74.870   8.169  1.00  1.04           H  
ATOM    292  HZ1 LYS A 381      40.730  76.875   6.489  1.00  2.16           H  
ATOM    293  HZ2 LYS A 381      39.676  75.653   5.983  1.00  2.27           H  
ATOM    294  HZ3 LYS A 381      39.668  76.161   7.597  1.00  2.11           H  
ATOM    295  N   ILE A 382      45.121  71.150   6.336  1.00  0.40           N  
ATOM    296  CA  ILE A 382      44.543  69.919   5.812  1.00  0.35           C  
ATOM    297  C   ILE A 382      43.035  70.064   5.633  1.00  0.34           C  
ATOM    298  O   ILE A 382      42.329  70.441   6.567  1.00  0.41           O  
ATOM    299  CB  ILE A 382      44.820  68.724   6.746  1.00  0.37           C  
ATOM    300  CG1 ILE A 382      46.325  68.574   6.997  1.00  0.38           C  
ATOM    301  CG2 ILE A 382      44.242  67.442   6.163  1.00  0.41           C  
ATOM    302  CD1 ILE A 382      47.135  68.345   5.738  1.00  0.37           C  
ATOM    303  H   ILE A 382      45.277  71.232   7.300  1.00  0.47           H  
ATOM    304  HA  ILE A 382      44.995  69.715   4.852  1.00  0.35           H  
ATOM    305  HB  ILE A 382      44.326  68.913   7.688  1.00  0.41           H  
ATOM    306 HG12 ILE A 382      46.695  69.473   7.466  1.00  0.40           H  
ATOM    307 HG13 ILE A 382      46.490  67.735   7.656  1.00  0.42           H  
ATOM    308 HG21 ILE A 382      43.492  67.689   5.425  1.00  1.13           H  
ATOM    309 HG22 ILE A 382      45.030  66.869   5.697  1.00  1.07           H  
ATOM    310 HG23 ILE A 382      43.791  66.858   6.952  1.00  1.06           H  
ATOM    311 HD11 ILE A 382      46.472  68.074   4.929  1.00  1.05           H  
ATOM    312 HD12 ILE A 382      47.665  69.250   5.481  1.00  1.03           H  
ATOM    313 HD13 ILE A 382      47.843  67.548   5.906  1.00  1.10           H  
ATOM    314  N   TYR A 383      42.542  69.756   4.437  1.00  0.30           N  
ATOM    315  CA  TYR A 383      41.114  69.852   4.167  1.00  0.30           C  
ATOM    316  C   TYR A 383      40.468  68.472   4.190  1.00  0.28           C  
ATOM    317  O   TYR A 383      41.067  67.490   3.757  1.00  0.25           O  
ATOM    318  CB  TYR A 383      40.853  70.536   2.820  1.00  0.32           C  
ATOM    319  CG  TYR A 383      41.274  71.988   2.785  1.00  0.36           C  
ATOM    320  CD1 TYR A 383      42.612  72.347   2.874  1.00  0.40           C  
ATOM    321  CD2 TYR A 383      40.328  73.000   2.662  1.00  0.48           C  
ATOM    322  CE1 TYR A 383      42.998  73.674   2.840  1.00  0.48           C  
ATOM    323  CE2 TYR A 383      40.707  74.328   2.628  1.00  0.55           C  
ATOM    324  CZ  TYR A 383      42.041  74.660   2.716  1.00  0.52           C  
ATOM    325  OH  TYR A 383      42.421  75.981   2.681  1.00  0.63           O  
ATOM    326  H   TYR A 383      43.147  69.452   3.726  1.00  0.31           H  
ATOM    327  HA  TYR A 383      40.672  70.449   4.951  1.00  0.34           H  
ATOM    328  HB2 TYR A 383      41.402  70.020   2.044  1.00  0.31           H  
ATOM    329  HB3 TYR A 383      39.798  70.491   2.598  1.00  0.35           H  
ATOM    330  HD1 TYR A 383      43.359  71.572   2.970  1.00  0.44           H  
ATOM    331  HD2 TYR A 383      39.283  72.738   2.597  1.00  0.58           H  
ATOM    332  HE1 TYR A 383      44.044  73.935   2.910  1.00  0.58           H  
ATOM    333  HE2 TYR A 383      39.958  75.100   2.532  1.00  0.68           H  
ATOM    334  HH  TYR A 383      41.879  76.487   3.293  1.00  1.10           H  
ATOM    335  N   PHE A 384      39.245  68.404   4.700  1.00  0.31           N  
ATOM    336  CA  PHE A 384      38.518  67.142   4.778  1.00  0.30           C  
ATOM    337  C   PHE A 384      37.658  66.950   3.533  1.00  0.28           C  
ATOM    338  O   PHE A 384      37.054  67.902   3.038  1.00  0.33           O  
ATOM    339  CB  PHE A 384      37.642  67.096   6.034  1.00  0.40           C  
ATOM    340  CG  PHE A 384      38.406  67.234   7.324  1.00  0.48           C  
ATOM    341  CD1 PHE A 384      39.135  68.379   7.604  1.00  0.83           C  
ATOM    342  CD2 PHE A 384      38.385  66.214   8.263  1.00  0.57           C  
ATOM    343  CE1 PHE A 384      39.830  68.502   8.793  1.00  0.96           C  
ATOM    344  CE2 PHE A 384      39.076  66.333   9.454  1.00  0.64           C  
ATOM    345  CZ  PHE A 384      39.800  67.478   9.718  1.00  0.74           C  
ATOM    346  H   PHE A 384      38.818  69.222   5.033  1.00  0.35           H  
ATOM    347  HA  PHE A 384      39.245  66.345   4.824  1.00  0.30           H  
ATOM    348  HB2 PHE A 384      36.917  67.895   5.987  1.00  0.45           H  
ATOM    349  HB3 PHE A 384      37.120  66.149   6.057  1.00  0.44           H  
ATOM    350  HD1 PHE A 384      39.160  69.181   6.882  1.00  1.11           H  
ATOM    351  HD2 PHE A 384      37.820  65.316   8.057  1.00  0.82           H  
ATOM    352  HE1 PHE A 384      40.396  69.400   8.999  1.00  1.32           H  
ATOM    353  HE2 PHE A 384      39.050  65.531  10.177  1.00  0.86           H  
ATOM    354  HZ  PHE A 384      40.342  67.572  10.648  1.00  0.86           H  
ATOM    355  N   ILE A 385      37.607  65.723   3.024  1.00  0.26           N  
ATOM    356  CA  ILE A 385      36.817  65.433   1.832  1.00  0.27           C  
ATOM    357  C   ILE A 385      35.979  64.175   2.021  1.00  0.24           C  
ATOM    358  O   ILE A 385      36.500  63.117   2.370  1.00  0.30           O  
ATOM    359  CB  ILE A 385      37.701  65.240   0.579  1.00  0.33           C  
ATOM    360  CG1 ILE A 385      38.854  66.247   0.550  1.00  0.32           C  
ATOM    361  CG2 ILE A 385      36.855  65.369  -0.681  1.00  0.49           C  
ATOM    362  CD1 ILE A 385      39.982  65.903   1.496  1.00  0.32           C  
ATOM    363  H   ILE A 385      38.110  65.000   3.456  1.00  0.28           H  
ATOM    364  HA  ILE A 385      36.158  66.271   1.657  1.00  0.31           H  
ATOM    365  HB  ILE A 385      38.107  64.240   0.606  1.00  0.37           H  
ATOM    366 HG12 ILE A 385      39.262  66.289  -0.448  1.00  0.41           H  
ATOM    367 HG13 ILE A 385      38.482  67.222   0.821  1.00  0.43           H  
ATOM    368 HG21 ILE A 385      35.965  65.941  -0.463  1.00  1.12           H  
ATOM    369 HG22 ILE A 385      37.426  65.871  -1.448  1.00  1.12           H  
ATOM    370 HG23 ILE A 385      36.575  64.385  -1.028  1.00  1.20           H  
ATOM    371 HD11 ILE A 385      39.572  65.573   2.439  1.00  0.98           H  
ATOM    372 HD12 ILE A 385      40.582  65.115   1.068  1.00  1.10           H  
ATOM    373 HD13 ILE A 385      40.596  66.777   1.656  1.00  1.08           H  
ATOM    374  N   ARG A 386      34.682  64.299   1.778  1.00  0.29           N  
ATOM    375  CA  ARG A 386      33.767  63.174   1.908  1.00  0.30           C  
ATOM    376  C   ARG A 386      33.846  62.280   0.677  1.00  0.33           C  
ATOM    377  O   ARG A 386      33.518  62.711  -0.429  1.00  0.42           O  
ATOM    378  CB  ARG A 386      32.338  63.691   2.081  1.00  0.38           C  
ATOM    379  CG  ARG A 386      31.301  62.597   2.282  1.00  0.50           C  
ATOM    380  CD  ARG A 386      29.899  63.179   2.365  1.00  1.02           C  
ATOM    381  NE  ARG A 386      28.884  62.151   2.591  1.00  1.40           N  
ATOM    382  CZ  ARG A 386      28.804  61.420   3.698  1.00  1.86           C  
ATOM    383  NH1 ARG A 386      29.672  61.598   4.684  1.00  2.42           N  
ATOM    384  NH2 ARG A 386      27.848  60.508   3.823  1.00  2.39           N  
ATOM    385  H   ARG A 386      34.331  65.169   1.495  1.00  0.37           H  
ATOM    386  HA  ARG A 386      34.050  62.606   2.780  1.00  0.35           H  
ATOM    387  HB2 ARG A 386      32.306  64.346   2.940  1.00  0.45           H  
ATOM    388  HB3 ARG A 386      32.066  64.256   1.200  1.00  0.42           H  
ATOM    389  HG2 ARG A 386      31.349  61.911   1.448  1.00  1.01           H  
ATOM    390  HG3 ARG A 386      31.520  62.071   3.200  1.00  0.98           H  
ATOM    391  HD2 ARG A 386      29.866  63.887   3.179  1.00  1.53           H  
ATOM    392  HD3 ARG A 386      29.682  63.690   1.438  1.00  1.53           H  
ATOM    393  HE  ARG A 386      28.227  61.999   1.879  1.00  1.90           H  
ATOM    394 HH11 ARG A 386      30.393  62.285   4.599  1.00  2.37           H  
ATOM    395 HH12 ARG A 386      29.608  61.045   5.514  1.00  3.17           H  
ATOM    396 HH21 ARG A 386      27.188  60.371   3.085  1.00  2.55           H  
ATOM    397 HH22 ARG A 386      27.786  59.960   4.657  1.00  2.93           H  
ATOM    398  N   ARG A 387      34.274  61.034   0.864  1.00  0.41           N  
ATOM    399  CA  ARG A 387      34.374  60.106  -0.256  1.00  0.51           C  
ATOM    400  C   ARG A 387      32.985  59.719  -0.744  1.00  0.49           C  
ATOM    401  O   ARG A 387      32.011  59.804   0.003  1.00  0.47           O  
ATOM    402  CB  ARG A 387      35.173  58.862   0.126  1.00  0.63           C  
ATOM    403  CG  ARG A 387      36.596  59.166   0.567  1.00  0.84           C  
ATOM    404  CD  ARG A 387      37.468  57.922   0.521  1.00  0.94           C  
ATOM    405  NE  ARG A 387      36.891  56.813   1.274  1.00  1.32           N  
ATOM    406  CZ  ARG A 387      37.453  55.610   1.360  1.00  1.79           C  
ATOM    407  NH1 ARG A 387      38.608  55.369   0.751  1.00  2.30           N  
ATOM    408  NH2 ARG A 387      36.862  54.647   2.053  1.00  2.25           N  
ATOM    409  H   ARG A 387      34.520  60.732   1.767  1.00  0.46           H  
ATOM    410  HA  ARG A 387      34.887  60.617  -1.057  1.00  0.58           H  
ATOM    411  HB2 ARG A 387      34.668  58.357   0.938  1.00  0.63           H  
ATOM    412  HB3 ARG A 387      35.218  58.200  -0.725  1.00  0.77           H  
ATOM    413  HG2 ARG A 387      37.015  59.912  -0.091  1.00  1.24           H  
ATOM    414  HG3 ARG A 387      36.577  59.544   1.579  1.00  1.17           H  
ATOM    415  HD2 ARG A 387      37.587  57.621  -0.509  1.00  1.21           H  
ATOM    416  HD3 ARG A 387      38.437  58.163   0.936  1.00  1.21           H  
ATOM    417  HE  ARG A 387      36.041  56.970   1.733  1.00  1.73           H  
ATOM    418 HH11 ARG A 387      39.057  56.092   0.227  1.00  2.22           H  
ATOM    419 HH12 ARG A 387      39.027  54.464   0.817  1.00  2.99           H  
ATOM    420 HH21 ARG A 387      35.993  54.822   2.514  1.00  2.35           H  
ATOM    421 HH22 ARG A 387      37.287  53.742   2.115  1.00  2.76           H  
ATOM    422  N   GLU A 388      32.895  59.315  -2.007  1.00  0.64           N  
ATOM    423  CA  GLU A 388      31.615  58.937  -2.598  1.00  0.69           C  
ATOM    424  C   GLU A 388      30.877  57.923  -1.733  1.00  0.61           C  
ATOM    425  O   GLU A 388      29.680  58.073  -1.489  1.00  0.63           O  
ATOM    426  CB  GLU A 388      31.820  58.379  -4.007  1.00  0.88           C  
ATOM    427  CG  GLU A 388      32.458  59.369  -4.970  1.00  1.58           C  
ATOM    428  CD  GLU A 388      32.643  58.797  -6.363  1.00  2.20           C  
ATOM    429  OE1 GLU A 388      32.277  57.621  -6.576  1.00  2.82           O  
ATOM    430  OE2 GLU A 388      33.152  59.524  -7.242  1.00  2.65           O  
ATOM    431  H   GLU A 388      33.703  59.285  -2.558  1.00  0.79           H  
ATOM    432  HA  GLU A 388      31.011  59.829  -2.657  1.00  0.72           H  
ATOM    433  HB2 GLU A 388      32.456  57.508  -3.948  1.00  1.18           H  
ATOM    434  HB3 GLU A 388      30.861  58.086  -4.410  1.00  1.27           H  
ATOM    435  HG2 GLU A 388      31.827  60.243  -5.038  1.00  2.17           H  
ATOM    436  HG3 GLU A 388      33.425  59.655  -4.583  1.00  2.04           H  
ATOM    437  N   ASP A 389      31.587  56.906  -1.254  1.00  0.65           N  
ATOM    438  CA  ASP A 389      30.963  55.902  -0.401  1.00  0.69           C  
ATOM    439  C   ASP A 389      30.345  56.590   0.807  1.00  0.64           C  
ATOM    440  O   ASP A 389      29.291  56.187   1.300  1.00  0.91           O  
ATOM    441  CB  ASP A 389      31.975  54.843   0.043  1.00  0.81           C  
ATOM    442  CG  ASP A 389      33.094  55.416   0.886  1.00  0.80           C  
ATOM    443  OD1 ASP A 389      33.837  56.278   0.378  1.00  1.06           O  
ATOM    444  OD2 ASP A 389      33.226  55.001   2.057  1.00  1.23           O  
ATOM    445  H   ASP A 389      32.541  56.837  -1.466  1.00  0.72           H  
ATOM    446  HA  ASP A 389      30.178  55.428  -0.971  1.00  0.76           H  
ATOM    447  HB2 ASP A 389      31.464  54.089   0.623  1.00  0.89           H  
ATOM    448  HB3 ASP A 389      32.409  54.380  -0.832  1.00  0.90           H  
ATOM    449  N   GLY A 390      31.007  57.651   1.263  1.00  0.55           N  
ATOM    450  CA  GLY A 390      30.512  58.411   2.391  1.00  0.53           C  
ATOM    451  C   GLY A 390      31.583  58.696   3.429  1.00  0.55           C  
ATOM    452  O   GLY A 390      31.597  59.765   4.039  1.00  1.03           O  
ATOM    453  H   GLY A 390      31.832  57.929   0.814  1.00  0.70           H  
ATOM    454  HA2 GLY A 390      30.123  59.352   2.022  1.00  0.51           H  
ATOM    455  HA3 GLY A 390      29.710  57.860   2.860  1.00  0.62           H  
ATOM    456  N   THR A 391      32.475  57.731   3.636  1.00  0.57           N  
ATOM    457  CA  THR A 391      33.548  57.868   4.617  1.00  0.54           C  
ATOM    458  C   THR A 391      34.455  59.058   4.316  1.00  0.41           C  
ATOM    459  O   THR A 391      35.182  59.071   3.322  1.00  0.44           O  
ATOM    460  CB  THR A 391      34.407  56.592   4.694  1.00  0.71           C  
ATOM    461  OG1 THR A 391      35.014  56.328   3.426  1.00  0.98           O  
ATOM    462  CG2 THR A 391      33.562  55.398   5.117  1.00  0.88           C  
ATOM    463  H   THR A 391      32.401  56.899   3.123  1.00  0.95           H  
ATOM    464  HA  THR A 391      33.091  58.019   5.584  1.00  0.58           H  
ATOM    465  HB  THR A 391      35.183  56.741   5.431  1.00  0.81           H  
ATOM    466  HG1 THR A 391      34.603  56.876   2.752  1.00  1.19           H  
ATOM    467 HG21 THR A 391      32.515  55.657   5.050  1.00  1.34           H  
ATOM    468 HG22 THR A 391      33.769  54.562   4.466  1.00  1.30           H  
ATOM    469 HG23 THR A 391      33.802  55.130   6.135  1.00  1.46           H  
ATOM    470  N   VAL A 392      34.408  60.056   5.195  1.00  0.37           N  
ATOM    471  CA  VAL A 392      35.226  61.255   5.049  1.00  0.33           C  
ATOM    472  C   VAL A 392      36.688  60.956   5.381  1.00  0.32           C  
ATOM    473  O   VAL A 392      36.978  60.184   6.294  1.00  0.41           O  
ATOM    474  CB  VAL A 392      34.721  62.390   5.961  1.00  0.45           C  
ATOM    475  CG1 VAL A 392      35.579  63.636   5.799  1.00  0.55           C  
ATOM    476  CG2 VAL A 392      33.262  62.697   5.663  1.00  0.52           C  
ATOM    477  H   VAL A 392      33.810  59.981   5.968  1.00  0.45           H  
ATOM    478  HA  VAL A 392      35.159  61.586   4.023  1.00  0.35           H  
ATOM    479  HB  VAL A 392      34.795  62.060   6.987  1.00  0.53           H  
ATOM    480 HG11 VAL A 392      36.615  63.386   5.972  1.00  1.13           H  
ATOM    481 HG12 VAL A 392      35.464  64.025   4.798  1.00  1.12           H  
ATOM    482 HG13 VAL A 392      35.267  64.384   6.513  1.00  1.24           H  
ATOM    483 HG21 VAL A 392      32.937  62.111   4.815  1.00  1.14           H  
ATOM    484 HG22 VAL A 392      32.658  62.447   6.525  1.00  1.14           H  
ATOM    485 HG23 VAL A 392      33.153  63.746   5.440  1.00  1.13           H  
ATOM    486  N   HIS A 393      37.602  61.569   4.635  1.00  0.29           N  
ATOM    487  CA  HIS A 393      39.033  61.362   4.851  1.00  0.31           C  
ATOM    488  C   HIS A 393      39.832  62.619   4.516  1.00  0.27           C  
ATOM    489  O   HIS A 393      39.495  63.354   3.586  1.00  0.26           O  
ATOM    490  CB  HIS A 393      39.534  60.184   4.011  1.00  0.37           C  
ATOM    491  CG  HIS A 393      39.040  58.853   4.486  1.00  0.92           C  
ATOM    492  ND1 HIS A 393      39.328  58.346   5.737  1.00  1.92           N  
ATOM    493  CD2 HIS A 393      38.270  57.922   3.876  1.00  0.94           C  
ATOM    494  CE1 HIS A 393      38.756  57.163   5.873  1.00  2.43           C  
ATOM    495  NE2 HIS A 393      38.110  56.883   4.758  1.00  1.82           N  
ATOM    496  H   HIS A 393      37.311  62.172   3.919  1.00  0.32           H  
ATOM    497  HA  HIS A 393      39.174  61.131   5.896  1.00  0.37           H  
ATOM    498  HB2 HIS A 393      39.204  60.314   2.991  1.00  0.68           H  
ATOM    499  HB3 HIS A 393      40.614  60.167   4.034  1.00  0.71           H  
ATOM    500  HD1 HIS A 393      39.872  58.789   6.422  1.00  2.24           H  
ATOM    501  HD2 HIS A 393      37.858  57.986   2.877  1.00  0.73           H  
ATOM    502  HE1 HIS A 393      38.809  56.533   6.748  1.00  3.24           H  
ATOM    503  HE2 HIS A 393      37.545  56.095   4.613  1.00  2.04           H  
ATOM    504  N   ARG A 394      40.887  62.861   5.290  1.00  0.29           N  
ATOM    505  CA  ARG A 394      41.741  64.031   5.096  1.00  0.28           C  
ATOM    506  C   ARG A 394      42.298  64.097   3.677  1.00  0.26           C  
ATOM    507  O   ARG A 394      42.430  63.076   3.000  1.00  0.32           O  
ATOM    508  CB  ARG A 394      42.897  64.022   6.098  1.00  0.35           C  
ATOM    509  CG  ARG A 394      42.455  64.140   7.544  1.00  0.42           C  
ATOM    510  CD  ARG A 394      43.649  64.225   8.482  1.00  0.52           C  
ATOM    511  NE  ARG A 394      44.478  63.023   8.425  1.00  1.34           N  
ATOM    512  CZ  ARG A 394      45.581  62.851   9.150  1.00  2.01           C  
ATOM    513  NH1 ARG A 394      45.989  63.802   9.980  1.00  2.41           N  
ATOM    514  NH2 ARG A 394      46.278  61.728   9.044  1.00  2.96           N  
ATOM    515  H   ARG A 394      41.094  62.238   6.018  1.00  0.34           H  
ATOM    516  HA  ARG A 394      41.140  64.910   5.271  1.00  0.27           H  
ATOM    517  HB2 ARG A 394      43.448  63.099   5.985  1.00  0.41           H  
ATOM    518  HB3 ARG A 394      43.555  64.851   5.876  1.00  0.38           H  
ATOM    519  HG2 ARG A 394      41.858  65.032   7.657  1.00  0.45           H  
ATOM    520  HG3 ARG A 394      41.866  63.272   7.803  1.00  0.44           H  
ATOM    521  HD2 ARG A 394      44.250  65.077   8.199  1.00  1.07           H  
ATOM    522  HD3 ARG A 394      43.289  64.357   9.491  1.00  1.04           H  
ATOM    523  HE  ARG A 394      44.199  62.307   7.817  1.00  2.01           H  
ATOM    524 HH11 ARG A 394      45.468  64.651  10.062  1.00  2.28           H  
ATOM    525 HH12 ARG A 394      46.817  63.669  10.524  1.00  3.24           H  
ATOM    526 HH21 ARG A 394      45.975  61.008   8.419  1.00  3.32           H  
ATOM    527 HH22 ARG A 394      47.107  61.601   9.589  1.00  3.56           H  
ATOM    528  N   GLY A 395      42.625  65.311   3.241  1.00  0.23           N  
ATOM    529  CA  GLY A 395      43.169  65.513   1.912  1.00  0.25           C  
ATOM    530  C   GLY A 395      43.662  66.933   1.702  1.00  0.23           C  
ATOM    531  O   GLY A 395      42.942  67.893   1.979  1.00  0.26           O  
ATOM    532  H   GLY A 395      42.496  66.079   3.834  1.00  0.24           H  
ATOM    533  HA2 GLY A 395      43.988  64.829   1.761  1.00  0.32           H  
ATOM    534  HA3 GLY A 395      42.400  65.300   1.185  1.00  0.27           H  
ATOM    535  N   GLN A 396      44.891  67.070   1.213  1.00  0.29           N  
ATOM    536  CA  GLN A 396      45.467  68.387   0.969  1.00  0.34           C  
ATOM    537  C   GLN A 396      45.050  68.915  -0.399  1.00  0.35           C  
ATOM    538  O   GLN A 396      45.212  68.235  -1.411  1.00  0.46           O  
ATOM    539  CB  GLN A 396      46.994  68.321   1.052  1.00  0.43           C  
ATOM    540  CG  GLN A 396      47.513  67.819   2.389  1.00  0.50           C  
ATOM    541  CD  GLN A 396      49.024  67.749   2.438  1.00  0.64           C  
ATOM    542  OE1 GLN A 396      49.664  67.177   1.555  1.00  1.28           O  
ATOM    543  NE2 GLN A 396      49.596  68.314   3.488  1.00  0.61           N  
ATOM    544  H   GLN A 396      45.420  66.271   1.011  1.00  0.34           H  
ATOM    545  HA  GLN A 396      45.101  69.059   1.730  1.00  0.36           H  
ATOM    546  HB2 GLN A 396      47.355  67.658   0.280  1.00  0.44           H  
ATOM    547  HB3 GLN A 396      47.394  69.310   0.883  1.00  0.50           H  
ATOM    548  HG2 GLN A 396      47.176  68.491   3.164  1.00  0.53           H  
ATOM    549  HG3 GLN A 396      47.118  66.836   2.574  1.00  0.48           H  
ATOM    550 HE21 GLN A 396      49.014  68.730   4.156  1.00  0.99           H  
ATOM    551 HE22 GLN A 396      50.574  68.290   3.554  1.00  0.64           H  
ATOM    552  N   VAL A 397      44.529  70.134  -0.430  1.00  0.33           N  
ATOM    553  CA  VAL A 397      44.105  70.748  -1.680  1.00  0.33           C  
ATOM    554  C   VAL A 397      45.197  71.671  -2.219  1.00  0.33           C  
ATOM    555  O   VAL A 397      45.802  72.435  -1.465  1.00  0.37           O  
ATOM    556  CB  VAL A 397      42.762  71.498  -1.499  1.00  0.38           C  
ATOM    557  CG1 VAL A 397      42.880  72.980  -1.801  1.00  0.73           C  
ATOM    558  CG2 VAL A 397      41.689  70.863  -2.365  1.00  0.83           C  
ATOM    559  H   VAL A 397      44.434  70.635   0.407  1.00  0.40           H  
ATOM    560  HA  VAL A 397      43.949  69.952  -2.395  1.00  0.36           H  
ATOM    561  HB  VAL A 397      42.458  71.393  -0.472  1.00  0.82           H  
ATOM    562 HG11 VAL A 397      43.874  73.321  -1.557  1.00  1.27           H  
ATOM    563 HG12 VAL A 397      42.685  73.152  -2.849  1.00  1.42           H  
ATOM    564 HG13 VAL A 397      42.159  73.522  -1.208  1.00  1.31           H  
ATOM    565 HG21 VAL A 397      41.575  69.823  -2.093  1.00  1.42           H  
ATOM    566 HG22 VAL A 397      40.753  71.379  -2.214  1.00  1.22           H  
ATOM    567 HG23 VAL A 397      41.977  70.934  -3.404  1.00  1.58           H  
ATOM    568  N   LEU A 398      45.476  71.568  -3.518  1.00  0.36           N  
ATOM    569  CA  LEU A 398      46.531  72.372  -4.131  1.00  0.40           C  
ATOM    570  C   LEU A 398      46.018  73.272  -5.258  1.00  0.41           C  
ATOM    571  O   LEU A 398      46.418  74.432  -5.355  1.00  0.47           O  
ATOM    572  CB  LEU A 398      47.628  71.452  -4.671  1.00  0.46           C  
ATOM    573  CG  LEU A 398      48.267  70.526  -3.634  1.00  0.49           C  
ATOM    574  CD1 LEU A 398      49.240  69.567  -4.301  1.00  1.16           C  
ATOM    575  CD2 LEU A 398      48.973  71.337  -2.556  1.00  1.45           C  
ATOM    576  H   LEU A 398      44.983  70.923  -4.065  1.00  0.40           H  
ATOM    577  HA  LEU A 398      46.956  72.995  -3.361  1.00  0.43           H  
ATOM    578  HB2 LEU A 398      47.202  70.842  -5.456  1.00  0.48           H  
ATOM    579  HB3 LEU A 398      48.405  72.068  -5.099  1.00  0.54           H  
ATOM    580  HG  LEU A 398      47.493  69.939  -3.160  1.00  0.90           H  
ATOM    581 HD11 LEU A 398      48.816  69.214  -5.231  1.00  1.63           H  
ATOM    582 HD12 LEU A 398      50.170  70.077  -4.501  1.00  1.74           H  
ATOM    583 HD13 LEU A 398      49.423  68.727  -3.647  1.00  1.81           H  
ATOM    584 HD21 LEU A 398      48.992  72.377  -2.844  1.00  2.01           H  
ATOM    585 HD22 LEU A 398      48.443  71.231  -1.622  1.00  1.95           H  
ATOM    586 HD23 LEU A 398      49.984  70.976  -2.440  1.00  2.04           H  
ATOM    587  N   GLN A 399      45.163  72.733  -6.125  1.00  0.39           N  
ATOM    588  CA  GLN A 399      44.646  73.507  -7.254  1.00  0.43           C  
ATOM    589  C   GLN A 399      43.122  73.577  -7.256  1.00  0.38           C  
ATOM    590  O   GLN A 399      42.456  72.944  -6.439  1.00  0.35           O  
ATOM    591  CB  GLN A 399      45.129  72.902  -8.572  1.00  0.49           C  
ATOM    592  CG  GLN A 399      46.644  72.826  -8.689  1.00  0.60           C  
ATOM    593  CD  GLN A 399      47.113  72.212  -9.999  1.00  1.36           C  
ATOM    594  OE1 GLN A 399      48.314  72.103 -10.246  1.00  2.08           O  
ATOM    595  NE2 GLN A 399      46.172  71.805 -10.847  1.00  2.04           N  
ATOM    596  H   GLN A 399      44.894  71.797  -6.018  1.00  0.39           H  
ATOM    597  HA  GLN A 399      45.036  74.509  -7.171  1.00  0.49           H  
ATOM    598  HB2 GLN A 399      44.730  71.902  -8.663  1.00  0.46           H  
ATOM    599  HB3 GLN A 399      44.757  73.503  -9.388  1.00  0.53           H  
ATOM    600  HG2 GLN A 399      47.046  73.824  -8.616  1.00  0.92           H  
ATOM    601  HG3 GLN A 399      47.023  72.226  -7.874  1.00  1.00           H  
ATOM    602 HE21 GLN A 399      45.234  71.919 -10.591  1.00  2.28           H  
ATOM    603 HE22 GLN A 399      46.457  71.405 -11.696  1.00  2.64           H  
ATOM    604  N   SER A 400      42.585  74.355  -8.193  1.00  0.42           N  
ATOM    605  CA  SER A 400      41.142  74.522  -8.332  1.00  0.41           C  
ATOM    606  C   SER A 400      40.803  75.181  -9.668  1.00  0.47           C  
ATOM    607  O   SER A 400      41.549  76.031 -10.153  1.00  0.54           O  
ATOM    608  CB  SER A 400      40.587  75.359  -7.177  1.00  0.47           C  
ATOM    609  OG  SER A 400      41.140  76.663  -7.179  1.00  0.56           O  
ATOM    610  H   SER A 400      43.177  74.829  -8.814  1.00  0.47           H  
ATOM    611  HA  SER A 400      40.691  73.542  -8.302  1.00  0.38           H  
ATOM    612  HB2 SER A 400      39.515  75.436  -7.274  1.00  0.49           H  
ATOM    613  HB3 SER A 400      40.829  74.881  -6.239  1.00  0.48           H  
ATOM    614  HG  SER A 400      41.984  76.654  -7.637  1.00  1.13           H  
ATOM    615  N   ARG A 401      39.680  74.783 -10.262  1.00  0.51           N  
ATOM    616  CA  ARG A 401      39.256  75.342 -11.546  1.00  0.60           C  
ATOM    617  C   ARG A 401      37.735  75.487 -11.601  1.00  0.73           C  
ATOM    618  O   ARG A 401      37.001  74.580 -11.210  1.00  0.86           O  
ATOM    619  CB  ARG A 401      39.739  74.455 -12.698  1.00  0.65           C  
ATOM    620  CG  ARG A 401      39.033  73.113 -12.772  1.00  0.72           C  
ATOM    621  CD  ARG A 401      39.513  72.295 -13.960  1.00  0.91           C  
ATOM    622  NE  ARG A 401      38.797  71.027 -14.070  1.00  1.02           N  
ATOM    623  CZ  ARG A 401      39.025  70.131 -15.026  1.00  1.25           C  
ATOM    624  NH1 ARG A 401      39.948  70.361 -15.948  1.00  1.55           N  
ATOM    625  NH2 ARG A 401      38.327  69.004 -15.059  1.00  1.43           N  
ATOM    626  H   ARG A 401      39.123  74.101  -9.832  1.00  0.53           H  
ATOM    627  HA  ARG A 401      39.702  76.321 -11.645  1.00  0.64           H  
ATOM    628  HB2 ARG A 401      39.579  74.973 -13.631  1.00  0.72           H  
ATOM    629  HB3 ARG A 401      40.796  74.275 -12.577  1.00  0.66           H  
ATOM    630  HG2 ARG A 401      39.232  72.562 -11.866  1.00  0.74           H  
ATOM    631  HG3 ARG A 401      37.971  73.281 -12.868  1.00  0.85           H  
ATOM    632  HD2 ARG A 401      39.356  72.867 -14.862  1.00  1.06           H  
ATOM    633  HD3 ARG A 401      40.567  72.094 -13.840  1.00  1.07           H  
ATOM    634  HE  ARG A 401      38.109  70.835 -13.398  1.00  1.14           H  
ATOM    635 HH11 ARG A 401      40.477  71.211 -15.926  1.00  1.56           H  
ATOM    636 HH12 ARG A 401      40.117  69.687 -16.666  1.00  1.88           H  
ATOM    637 HH21 ARG A 401      37.628  68.826 -14.365  1.00  1.47           H  
ATOM    638 HH22 ARG A 401      38.498  68.330 -15.779  1.00  1.68           H  
ATOM    639  N   THR A 402      37.268  76.639 -12.079  1.00  0.82           N  
ATOM    640  CA  THR A 402      35.837  76.907 -12.176  1.00  0.99           C  
ATOM    641  C   THR A 402      35.302  76.668 -13.585  1.00  1.16           C  
ATOM    642  O   THR A 402      34.432  77.403 -14.057  1.00  1.79           O  
ATOM    643  CB  THR A 402      35.515  78.350 -11.752  1.00  1.14           C  
ATOM    644  OG1 THR A 402      36.414  79.263 -12.392  1.00  1.38           O  
ATOM    645  CG2 THR A 402      35.606  78.500 -10.241  1.00  1.29           C  
ATOM    646  H   THR A 402      37.901  77.328 -12.368  1.00  0.85           H  
ATOM    647  HA  THR A 402      35.329  76.237 -11.496  1.00  1.02           H  
ATOM    648  HB  THR A 402      34.506  78.580 -12.060  1.00  1.29           H  
ATOM    649  HG1 THR A 402      37.176  78.782 -12.726  1.00  1.65           H  
ATOM    650 HG21 THR A 402      34.974  77.760  -9.771  1.00  1.62           H  
ATOM    651 HG22 THR A 402      36.628  78.355  -9.925  1.00  1.72           H  
ATOM    652 HG23 THR A 402      35.277  79.488  -9.957  1.00  1.77           H  
ATOM    653  N   THR A 403      35.814  75.631 -14.242  1.00  1.43           N  
ATOM    654  CA  THR A 403      35.389  75.276 -15.598  1.00  1.62           C  
ATOM    655  C   THR A 403      35.362  76.510 -16.513  1.00  1.84           C  
ATOM    656  O   THR A 403      35.795  77.595 -16.124  1.00  1.85           O  
ATOM    657  CB  THR A 403      34.001  74.603 -15.575  1.00  1.77           C  
ATOM    658  OG1 THR A 403      33.916  73.715 -14.455  1.00  1.78           O  
ATOM    659  CG2 THR A 403      33.749  73.805 -16.847  1.00  1.95           C  
ATOM    660  H   THR A 403      36.489  75.078 -13.797  1.00  1.94           H  
ATOM    661  HA  THR A 403      36.102  74.568 -15.992  1.00  1.60           H  
ATOM    662  HB  THR A 403      33.242  75.365 -15.486  1.00  1.85           H  
ATOM    663  HG1 THR A 403      34.468  74.044 -13.742  1.00  1.98           H  
ATOM    664 HG21 THR A 403      34.674  73.695 -17.393  1.00  2.13           H  
ATOM    665 HG22 THR A 403      33.364  72.829 -16.592  1.00  2.29           H  
ATOM    666 HG23 THR A 403      33.029  74.326 -17.462  1.00  2.30           H  
ATOM    667  N   GLU A 404      34.865  76.336 -17.735  1.00  2.08           N  
ATOM    668  CA  GLU A 404      34.792  77.430 -18.699  1.00  2.34           C  
ATOM    669  C   GLU A 404      33.768  78.480 -18.274  1.00  2.30           C  
ATOM    670  O   GLU A 404      34.004  79.680 -18.407  1.00  2.37           O  
ATOM    671  CB  GLU A 404      34.427  76.891 -20.084  1.00  2.72           C  
ATOM    672  CG  GLU A 404      35.422  75.880 -20.627  1.00  2.91           C  
ATOM    673  CD  GLU A 404      35.031  75.351 -21.994  1.00  3.42           C  
ATOM    674  OE1 GLU A 404      33.977  75.772 -22.516  1.00  3.79           O  
ATOM    675  OE2 GLU A 404      35.779  74.513 -22.542  1.00  3.87           O  
ATOM    676  H   GLU A 404      34.545  75.452 -17.997  1.00  2.11           H  
ATOM    677  HA  GLU A 404      35.765  77.894 -18.750  1.00  2.36           H  
ATOM    678  HB2 GLU A 404      33.459  76.416 -20.027  1.00  2.90           H  
ATOM    679  HB3 GLU A 404      34.373  77.718 -20.776  1.00  2.84           H  
ATOM    680  HG2 GLU A 404      36.390  76.352 -20.706  1.00  3.03           H  
ATOM    681  HG3 GLU A 404      35.484  75.048 -19.939  1.00  3.07           H  
ATOM    682  N   ASN A 405      32.622  78.015 -17.778  1.00  2.26           N  
ATOM    683  CA  ASN A 405      31.549  78.909 -17.348  1.00  2.30           C  
ATOM    684  C   ASN A 405      32.051  79.930 -16.327  1.00  2.07           C  
ATOM    685  O   ASN A 405      31.862  81.134 -16.501  1.00  2.40           O  
ATOM    686  CB  ASN A 405      30.396  78.094 -16.758  1.00  2.43           C  
ATOM    687  CG  ASN A 405      29.203  78.955 -16.393  1.00  2.67           C  
ATOM    688  OD1 ASN A 405      29.301  79.843 -15.548  1.00  3.16           O  
ATOM    689  ND2 ASN A 405      28.067  78.696 -17.030  1.00  2.73           N  
ATOM    690  H   ASN A 405      32.492  77.047 -17.710  1.00  2.26           H  
ATOM    691  HA  ASN A 405      31.193  79.437 -18.219  1.00  2.52           H  
ATOM    692  HB2 ASN A 405      30.075  77.360 -17.482  1.00  2.67           H  
ATOM    693  HB3 ASN A 405      30.739  77.589 -15.867  1.00  2.30           H  
ATOM    694 HD21 ASN A 405      28.062  77.973 -17.692  1.00  2.82           H  
ATOM    695 HD22 ASN A 405      27.281  79.239 -16.814  1.00  2.96           H  
ATOM    696  N   ALA A 406      32.695  79.441 -15.272  1.00  1.82           N  
ATOM    697  CA  ALA A 406      33.234  80.312 -14.227  1.00  1.67           C  
ATOM    698  C   ALA A 406      32.155  81.219 -13.633  1.00  1.85           C  
ATOM    699  O   ALA A 406      32.263  82.445 -13.682  1.00  2.18           O  
ATOM    700  CB  ALA A 406      34.386  81.138 -14.772  1.00  1.72           C  
ATOM    701  H   ALA A 406      32.818  78.472 -15.193  1.00  2.00           H  
ATOM    702  HA  ALA A 406      33.621  79.678 -13.442  1.00  1.53           H  
ATOM    703  HB1 ALA A 406      34.092  82.175 -14.829  1.00  1.91           H  
ATOM    704  HB2 ALA A 406      34.649  80.784 -15.757  1.00  2.07           H  
ATOM    705  HB3 ALA A 406      35.238  81.042 -14.115  1.00  2.10           H  
ATOM    706  N   ALA A 407      31.123  80.603 -13.070  1.00  1.91           N  
ATOM    707  CA  ALA A 407      30.022  81.338 -12.456  1.00  2.19           C  
ATOM    708  C   ALA A 407      29.216  80.413 -11.558  1.00  2.37           C  
ATOM    709  O   ALA A 407      28.128  80.754 -11.095  1.00  2.77           O  
ATOM    710  CB  ALA A 407      29.131  81.949 -13.523  1.00  2.38           C  
ATOM    711  H   ALA A 407      31.101  79.624 -13.063  1.00  1.96           H  
ATOM    712  HA  ALA A 407      30.440  82.136 -11.861  1.00  2.22           H  
ATOM    713  HB1 ALA A 407      29.717  82.153 -14.406  1.00  2.52           H  
ATOM    714  HB2 ALA A 407      28.701  82.867 -13.152  1.00  2.76           H  
ATOM    715  HB3 ALA A 407      28.340  81.254 -13.769  1.00  2.63           H  
ATOM    716  N   ALA A 408      29.778  79.234 -11.324  1.00  2.15           N  
ATOM    717  CA  ALA A 408      29.159  78.213 -10.491  1.00  2.35           C  
ATOM    718  C   ALA A 408      30.081  76.997 -10.370  1.00  2.05           C  
ATOM    719  O   ALA A 408      30.345  76.524  -9.264  1.00  1.99           O  
ATOM    720  CB  ALA A 408      27.802  77.804 -11.052  1.00  2.76           C  
ATOM    721  H   ALA A 408      30.649  79.042 -11.730  1.00  1.90           H  
ATOM    722  HA  ALA A 408      29.006  78.634  -9.507  1.00  2.50           H  
ATOM    723  HB1 ALA A 408      27.017  78.255 -10.462  1.00  3.28           H  
ATOM    724  HB2 ALA A 408      27.720  78.137 -12.075  1.00  3.03           H  
ATOM    725  HB3 ALA A 408      27.706  76.729 -11.013  1.00  2.78           H  
ATOM    726  N   PRO A 409      30.596  76.476 -11.507  1.00  1.99           N  
ATOM    727  CA  PRO A 409      31.501  75.322 -11.502  1.00  1.80           C  
ATOM    728  C   PRO A 409      32.794  75.602 -10.756  1.00  1.41           C  
ATOM    729  O   PRO A 409      33.299  76.719 -10.779  1.00  1.86           O  
ATOM    730  CB  PRO A 409      31.781  75.065 -12.985  1.00  2.10           C  
ATOM    731  CG  PRO A 409      31.477  76.353 -13.663  1.00  2.49           C  
ATOM    732  CD  PRO A 409      30.354  76.966 -12.881  1.00  2.27           C  
ATOM    733  HA  PRO A 409      31.034  74.461 -11.072  1.00  1.94           H  
ATOM    734  HB2 PRO A 409      32.816  74.785 -13.114  1.00  2.00           H  
ATOM    735  HB3 PRO A 409      31.141  74.271 -13.342  1.00  2.29           H  
ATOM    736  HG2 PRO A 409      32.346  76.995 -13.640  1.00  2.74           H  
ATOM    737  HG3 PRO A 409      31.169  76.170 -14.680  1.00  2.87           H  
ATOM    738  HD2 PRO A 409      30.409  78.042 -12.923  1.00  2.22           H  
ATOM    739  HD3 PRO A 409      29.402  76.618 -13.250  1.00  2.54           H  
ATOM    740  N   ASP A 410      33.320  74.574 -10.093  1.00  0.92           N  
ATOM    741  CA  ASP A 410      34.562  74.698  -9.337  1.00  0.79           C  
ATOM    742  C   ASP A 410      34.950  73.362  -8.712  1.00  0.68           C  
ATOM    743  O   ASP A 410      34.169  72.755  -7.976  1.00  0.93           O  
ATOM    744  CB  ASP A 410      34.426  75.764  -8.246  1.00  1.18           C  
ATOM    745  CG  ASP A 410      33.350  75.427  -7.234  1.00  1.62           C  
ATOM    746  OD1 ASP A 410      32.178  75.278  -7.639  1.00  1.99           O  
ATOM    747  OD2 ASP A 410      33.681  75.311  -6.035  1.00  2.14           O  
ATOM    748  H   ASP A 410      32.862  73.708 -10.117  1.00  1.11           H  
ATOM    749  HA  ASP A 410      35.337  74.998 -10.026  1.00  0.99           H  
ATOM    750  HB2 ASP A 410      35.367  75.858  -7.727  1.00  1.50           H  
ATOM    751  HB3 ASP A 410      34.177  76.711  -8.708  1.00  1.35           H  
ATOM    752  N   GLU A 411      36.164  72.912  -9.009  1.00  0.54           N  
ATOM    753  CA  GLU A 411      36.674  71.651  -8.479  1.00  0.45           C  
ATOM    754  C   GLU A 411      38.054  71.858  -7.869  1.00  0.40           C  
ATOM    755  O   GLU A 411      38.885  72.572  -8.429  1.00  0.42           O  
ATOM    756  CB  GLU A 411      36.745  70.585  -9.578  1.00  0.49           C  
ATOM    757  CG  GLU A 411      35.390  70.132 -10.099  1.00  0.58           C  
ATOM    758  CD  GLU A 411      34.635  71.227 -10.829  1.00  1.47           C  
ATOM    759  OE1 GLU A 411      35.176  71.764 -11.818  1.00  2.10           O  
ATOM    760  OE2 GLU A 411      33.501  71.546 -10.411  1.00  2.08           O  
ATOM    761  H   GLU A 411      36.737  73.445  -9.597  1.00  0.68           H  
ATOM    762  HA  GLU A 411      35.997  71.318  -7.704  1.00  0.49           H  
ATOM    763  HB2 GLU A 411      37.309  70.984 -10.409  1.00  0.55           H  
ATOM    764  HB3 GLU A 411      37.263  69.721  -9.187  1.00  0.51           H  
ATOM    765  HG2 GLU A 411      35.539  69.309 -10.783  1.00  0.98           H  
ATOM    766  HG3 GLU A 411      34.792  69.798  -9.264  1.00  1.09           H  
ATOM    767  N   TYR A 412      38.291  71.244  -6.716  1.00  0.38           N  
ATOM    768  CA  TYR A 412      39.572  71.381  -6.031  1.00  0.35           C  
ATOM    769  C   TYR A 412      40.376  70.085  -6.077  1.00  0.33           C  
ATOM    770  O   TYR A 412      39.855  69.009  -5.791  1.00  0.34           O  
ATOM    771  CB  TYR A 412      39.359  71.785  -4.571  1.00  0.39           C  
ATOM    772  CG  TYR A 412      38.750  73.158  -4.376  1.00  0.45           C  
ATOM    773  CD1 TYR A 412      37.583  73.531  -5.031  1.00  0.50           C  
ATOM    774  CD2 TYR A 412      39.345  74.078  -3.522  1.00  0.53           C  
ATOM    775  CE1 TYR A 412      37.027  74.780  -4.842  1.00  0.58           C  
ATOM    776  CE2 TYR A 412      38.795  75.331  -3.327  1.00  0.61           C  
ATOM    777  CZ  TYR A 412      37.638  75.676  -3.988  1.00  0.62           C  
ATOM    778  OH  TYR A 412      37.087  76.920  -3.794  1.00  0.72           O  
ATOM    779  H   TYR A 412      37.588  70.695  -6.310  1.00  0.41           H  
ATOM    780  HA  TYR A 412      40.133  72.157  -6.530  1.00  0.36           H  
ATOM    781  HB2 TYR A 412      38.704  71.068  -4.103  1.00  0.41           H  
ATOM    782  HB3 TYR A 412      40.313  71.774  -4.065  1.00  0.40           H  
ATOM    783  HD1 TYR A 412      37.109  72.827  -5.701  1.00  0.52           H  
ATOM    784  HD2 TYR A 412      40.252  73.804  -3.005  1.00  0.58           H  
ATOM    785  HE1 TYR A 412      36.120  75.052  -5.360  1.00  0.66           H  
ATOM    786  HE2 TYR A 412      39.273  76.030  -2.659  1.00  0.70           H  
ATOM    787  HH  TYR A 412      37.714  77.594  -4.066  1.00  1.06           H  
ATOM    788  N   TYR A 413      41.657  70.204  -6.412  1.00  0.33           N  
ATOM    789  CA  TYR A 413      42.543  69.049  -6.463  1.00  0.32           C  
ATOM    790  C   TYR A 413      42.859  68.589  -5.046  1.00  0.32           C  
ATOM    791  O   TYR A 413      43.391  69.359  -4.248  1.00  0.40           O  
ATOM    792  CB  TYR A 413      43.840  69.415  -7.185  1.00  0.36           C  
ATOM    793  CG  TYR A 413      44.774  68.243  -7.396  1.00  0.38           C  
ATOM    794  CD1 TYR A 413      44.338  67.084  -8.030  1.00  0.40           C  
ATOM    795  CD2 TYR A 413      46.092  68.298  -6.964  1.00  0.44           C  
ATOM    796  CE1 TYR A 413      45.192  66.015  -8.225  1.00  0.44           C  
ATOM    797  CE2 TYR A 413      46.951  67.232  -7.156  1.00  0.48           C  
ATOM    798  CZ  TYR A 413      46.496  66.093  -7.786  1.00  0.46           C  
ATOM    799  OH  TYR A 413      47.348  65.031  -7.978  1.00  0.51           O  
ATOM    800  H   TYR A 413      42.018  71.091  -6.611  1.00  0.35           H  
ATOM    801  HA  TYR A 413      42.043  68.256  -6.997  1.00  0.33           H  
ATOM    802  HB2 TYR A 413      43.602  69.828  -8.153  1.00  0.38           H  
ATOM    803  HB3 TYR A 413      44.366  70.157  -6.600  1.00  0.37           H  
ATOM    804  HD1 TYR A 413      43.317  67.026  -8.375  1.00  0.42           H  
ATOM    805  HD2 TYR A 413      46.446  69.190  -6.469  1.00  0.49           H  
ATOM    806  HE1 TYR A 413      44.835  65.122  -8.718  1.00  0.49           H  
ATOM    807  HE2 TYR A 413      47.974  67.296  -6.813  1.00  0.55           H  
ATOM    808  HH  TYR A 413      46.850  64.271  -8.290  1.00  1.05           H  
ATOM    809  N   VAL A 414      42.523  67.346  -4.724  1.00  0.33           N  
ATOM    810  CA  VAL A 414      42.769  66.829  -3.384  1.00  0.33           C  
ATOM    811  C   VAL A 414      43.828  65.732  -3.364  1.00  0.29           C  
ATOM    812  O   VAL A 414      43.850  64.848  -4.221  1.00  0.38           O  
ATOM    813  CB  VAL A 414      41.477  66.289  -2.743  1.00  0.39           C  
ATOM    814  CG1 VAL A 414      40.895  65.159  -3.575  1.00  1.09           C  
ATOM    815  CG2 VAL A 414      41.741  65.832  -1.317  1.00  1.15           C  
ATOM    816  H   VAL A 414      42.092  66.774  -5.391  1.00  0.40           H  
ATOM    817  HA  VAL A 414      43.118  67.652  -2.777  1.00  0.36           H  
ATOM    818  HB  VAL A 414      40.752  67.091  -2.712  1.00  1.07           H  
ATOM    819 HG11 VAL A 414      41.647  64.782  -4.249  1.00  1.58           H  
ATOM    820 HG12 VAL A 414      40.567  64.364  -2.920  1.00  1.65           H  
ATOM    821 HG13 VAL A 414      40.053  65.527  -4.142  1.00  1.74           H  
ATOM    822 HG21 VAL A 414      42.792  65.618  -1.197  1.00  1.84           H  
ATOM    823 HG22 VAL A 414      41.452  66.615  -0.630  1.00  1.58           H  
ATOM    824 HG23 VAL A 414      41.166  64.942  -1.111  1.00  1.76           H  
ATOM    825  N   HIS A 415      44.689  65.795  -2.354  1.00  0.33           N  
ATOM    826  CA  HIS A 415      45.746  64.812  -2.166  1.00  0.32           C  
ATOM    827  C   HIS A 415      45.579  64.142  -0.807  1.00  0.32           C  
ATOM    828  O   HIS A 415      46.122  64.608   0.195  1.00  0.34           O  
ATOM    829  CB  HIS A 415      47.119  65.483  -2.258  1.00  0.37           C  
ATOM    830  CG  HIS A 415      48.265  64.525  -2.147  1.00  0.44           C  
ATOM    831  ND1 HIS A 415      48.501  63.525  -3.066  1.00  0.50           N  
ATOM    832  CD2 HIS A 415      49.244  64.417  -1.217  1.00  0.54           C  
ATOM    833  CE1 HIS A 415      49.575  62.843  -2.706  1.00  0.60           C  
ATOM    834  NE2 HIS A 415      50.043  63.364  -1.589  1.00  0.62           N  
ATOM    835  H   HIS A 415      44.596  66.516  -1.700  1.00  0.43           H  
ATOM    836  HA  HIS A 415      45.658  64.068  -2.944  1.00  0.33           H  
ATOM    837  HB2 HIS A 415      47.204  65.992  -3.207  1.00  0.40           H  
ATOM    838  HB3 HIS A 415      47.212  66.205  -1.460  1.00  0.39           H  
ATOM    839  HD1 HIS A 415      47.963  63.343  -3.865  1.00  0.52           H  
ATOM    840  HD2 HIS A 415      49.372  65.042  -0.345  1.00  0.59           H  
ATOM    841  HE1 HIS A 415      49.994  62.002  -3.238  1.00  0.68           H  
ATOM    842  HE2 HIS A 415      50.796  63.009  -1.072  1.00  0.71           H  
ATOM    843  N   TYR A 416      44.808  63.058  -0.775  1.00  0.37           N  
ATOM    844  CA  TYR A 416      44.549  62.339   0.468  1.00  0.40           C  
ATOM    845  C   TYR A 416      45.848  61.975   1.177  1.00  0.45           C  
ATOM    846  O   TYR A 416      46.660  61.208   0.658  1.00  0.57           O  
ATOM    847  CB  TYR A 416      43.728  61.076   0.196  1.00  0.46           C  
ATOM    848  CG  TYR A 416      42.399  61.347  -0.475  1.00  0.47           C  
ATOM    849  CD1 TYR A 416      42.323  61.573  -1.845  1.00  0.53           C  
ATOM    850  CD2 TYR A 416      41.219  61.368   0.258  1.00  0.51           C  
ATOM    851  CE1 TYR A 416      41.110  61.813  -2.463  1.00  0.59           C  
ATOM    852  CE2 TYR A 416      40.002  61.607  -0.353  1.00  0.54           C  
ATOM    853  CZ  TYR A 416      39.954  61.829  -1.712  1.00  0.57           C  
ATOM    854  OH  TYR A 416      38.745  62.068  -2.323  1.00  0.65           O  
ATOM    855  H   TYR A 416      44.391  62.745  -1.605  1.00  0.42           H  
ATOM    856  HA  TYR A 416      43.978  62.993   1.110  1.00  0.39           H  
ATOM    857  HB2 TYR A 416      44.295  60.418  -0.445  1.00  0.51           H  
ATOM    858  HB3 TYR A 416      43.532  60.577   1.134  1.00  0.50           H  
ATOM    859  HD1 TYR A 416      43.231  61.558  -2.431  1.00  0.59           H  
ATOM    860  HD2 TYR A 416      41.263  61.195   1.323  1.00  0.56           H  
ATOM    861  HE1 TYR A 416      41.071  61.987  -3.527  1.00  0.69           H  
ATOM    862  HE2 TYR A 416      39.097  61.620   0.236  1.00  0.61           H  
ATOM    863  HH  TYR A 416      38.147  62.486  -1.699  1.00  1.13           H  
ATOM    864  N   VAL A 417      46.037  62.537   2.367  1.00  0.45           N  
ATOM    865  CA  VAL A 417      47.235  62.282   3.157  1.00  0.55           C  
ATOM    866  C   VAL A 417      47.350  60.811   3.531  1.00  0.66           C  
ATOM    867  O   VAL A 417      46.413  60.221   4.067  1.00  1.34           O  
ATOM    868  CB  VAL A 417      47.252  63.131   4.442  1.00  0.68           C  
ATOM    869  CG1 VAL A 417      48.509  62.854   5.256  1.00  1.10           C  
ATOM    870  CG2 VAL A 417      47.147  64.606   4.102  1.00  1.01           C  
ATOM    871  H   VAL A 417      45.352  63.142   2.723  1.00  0.45           H  
ATOM    872  HA  VAL A 417      48.093  62.557   2.559  1.00  0.55           H  
ATOM    873  HB  VAL A 417      46.396  62.859   5.041  1.00  0.84           H  
ATOM    874 HG11 VAL A 417      48.595  61.793   5.436  1.00  1.53           H  
ATOM    875 HG12 VAL A 417      49.374  63.198   4.708  1.00  1.70           H  
ATOM    876 HG13 VAL A 417      48.449  63.376   6.199  1.00  1.57           H  
ATOM    877 HG21 VAL A 417      46.453  64.737   3.284  1.00  1.48           H  
ATOM    878 HG22 VAL A 417      46.794  65.152   4.965  1.00  1.56           H  
ATOM    879 HG23 VAL A 417      48.119  64.975   3.812  1.00  1.54           H  
ATOM    880  N   GLY A 418      48.513  60.235   3.258  1.00  0.71           N  
ATOM    881  CA  GLY A 418      48.748  58.837   3.577  1.00  0.82           C  
ATOM    882  C   GLY A 418      48.097  57.876   2.594  1.00  0.72           C  
ATOM    883  O   GLY A 418      48.704  56.879   2.203  1.00  0.76           O  
ATOM    884  H   GLY A 418      49.221  60.769   2.840  1.00  1.17           H  
ATOM    885  HA2 GLY A 418      49.814  58.658   3.578  1.00  0.94           H  
ATOM    886  HA3 GLY A 418      48.363  58.638   4.565  1.00  0.94           H  
ATOM    887  N   LEU A 419      46.859  58.168   2.202  1.00  0.66           N  
ATOM    888  CA  LEU A 419      46.128  57.312   1.268  1.00  0.60           C  
ATOM    889  C   LEU A 419      46.863  57.179  -0.064  1.00  0.59           C  
ATOM    890  O   LEU A 419      47.730  57.988  -0.394  1.00  0.76           O  
ATOM    891  CB  LEU A 419      44.716  57.852   1.027  1.00  0.58           C  
ATOM    892  CG  LEU A 419      43.735  57.670   2.190  1.00  0.78           C  
ATOM    893  CD1 LEU A 419      44.117  58.548   3.369  1.00  1.60           C  
ATOM    894  CD2 LEU A 419      42.313  57.966   1.737  1.00  1.40           C  
ATOM    895  H   LEU A 419      46.422  58.970   2.553  1.00  0.72           H  
ATOM    896  HA  LEU A 419      46.052  56.333   1.716  1.00  0.67           H  
ATOM    897  HB2 LEU A 419      44.790  58.907   0.812  1.00  0.73           H  
ATOM    898  HB3 LEU A 419      44.308  57.353   0.162  1.00  0.65           H  
ATOM    899  HG  LEU A 419      43.771  56.642   2.518  1.00  1.43           H  
ATOM    900 HD11 LEU A 419      44.292  59.556   3.026  1.00  2.09           H  
ATOM    901 HD12 LEU A 419      43.315  58.549   4.094  1.00  2.15           H  
ATOM    902 HD13 LEU A 419      45.016  58.164   3.829  1.00  2.14           H  
ATOM    903 HD21 LEU A 419      42.264  58.969   1.339  1.00  1.98           H  
ATOM    904 HD22 LEU A 419      42.026  57.261   0.969  1.00  1.92           H  
ATOM    905 HD23 LEU A 419      41.641  57.877   2.575  1.00  1.94           H  
ATOM    906  N   ASN A 420      46.502  56.141  -0.816  1.00  0.61           N  
ATOM    907  CA  ASN A 420      47.109  55.869  -2.116  1.00  0.63           C  
ATOM    908  C   ASN A 420      47.127  57.107  -3.006  1.00  0.56           C  
ATOM    909  O   ASN A 420      46.170  57.882  -3.031  1.00  0.56           O  
ATOM    910  CB  ASN A 420      46.350  54.747  -2.825  1.00  0.75           C  
ATOM    911  CG  ASN A 420      46.498  53.411  -2.127  1.00  1.57           C  
ATOM    912  OD1 ASN A 420      46.180  53.273  -0.946  1.00  2.53           O  
ATOM    913  ND2 ASN A 420      46.977  52.417  -2.864  1.00  1.98           N  
ATOM    914  H   ASN A 420      45.805  55.537  -0.485  1.00  0.75           H  
ATOM    915  HA  ASN A 420      48.127  55.549  -1.946  1.00  0.71           H  
ATOM    916  HB2 ASN A 420      45.302  54.998  -2.859  1.00  1.30           H  
ATOM    917  HB3 ASN A 420      46.725  54.649  -3.831  1.00  1.19           H  
ATOM    918 HD21 ASN A 420      47.204  52.603  -3.798  1.00  1.91           H  
ATOM    919 HD22 ASN A 420      47.080  51.537  -2.446  1.00  2.76           H  
ATOM    920  N   ARG A 421      48.221  57.277  -3.742  1.00  0.62           N  
ATOM    921  CA  ARG A 421      48.372  58.411  -4.646  1.00  0.67           C  
ATOM    922  C   ARG A 421      47.353  58.340  -5.780  1.00  0.66           C  
ATOM    923  O   ARG A 421      46.834  59.363  -6.225  1.00  0.69           O  
ATOM    924  CB  ARG A 421      49.792  58.455  -5.214  1.00  0.87           C  
ATOM    925  CG  ARG A 421      50.855  58.722  -4.159  1.00  1.09           C  
ATOM    926  CD  ARG A 421      52.246  58.757  -4.768  1.00  1.51           C  
ATOM    927  NE  ARG A 421      52.620  57.475  -5.357  1.00  2.25           N  
ATOM    928  CZ  ARG A 421      53.788  57.248  -5.951  1.00  3.00           C  
ATOM    929  NH1 ARG A 421      54.689  58.217  -6.042  1.00  3.28           N  
ATOM    930  NH2 ARG A 421      54.055  56.052  -6.456  1.00  3.98           N  
ATOM    931  H   ARG A 421      48.943  56.618  -3.680  1.00  0.68           H  
ATOM    932  HA  ARG A 421      48.194  59.310  -4.078  1.00  0.66           H  
ATOM    933  HB2 ARG A 421      50.010  57.507  -5.682  1.00  1.30           H  
ATOM    934  HB3 ARG A 421      49.846  59.237  -5.956  1.00  1.29           H  
ATOM    935  HG2 ARG A 421      50.654  59.674  -3.693  1.00  1.61           H  
ATOM    936  HG3 ARG A 421      50.816  57.939  -3.417  1.00  1.39           H  
ATOM    937  HD2 ARG A 421      52.271  59.515  -5.537  1.00  1.91           H  
ATOM    938  HD3 ARG A 421      52.958  59.009  -3.995  1.00  1.94           H  
ATOM    939  HE  ARG A 421      51.968  56.744  -5.304  1.00  2.72           H  
ATOM    940 HH11 ARG A 421      54.492  59.121  -5.663  1.00  2.99           H  
ATOM    941 HH12 ARG A 421      55.566  58.042  -6.490  1.00  4.12           H  
ATOM    942 HH21 ARG A 421      53.377  55.318  -6.389  1.00  4.27           H  
ATOM    943 HH22 ARG A 421      54.933  55.882  -6.902  1.00  4.65           H  
ATOM    944  N   ARG A 422      47.069  57.124  -6.243  1.00  0.71           N  
ATOM    945  CA  ARG A 422      46.108  56.919  -7.322  1.00  0.83           C  
ATOM    946  C   ARG A 422      44.759  57.540  -6.967  1.00  0.72           C  
ATOM    947  O   ARG A 422      44.057  58.065  -7.832  1.00  0.77           O  
ATOM    948  CB  ARG A 422      45.942  55.422  -7.607  1.00  1.01           C  
ATOM    949  CG  ARG A 422      45.391  54.631  -6.431  1.00  1.19           C  
ATOM    950  CD  ARG A 422      45.271  53.143  -6.745  1.00  1.49           C  
ATOM    951  NE  ARG A 422      44.301  52.867  -7.808  1.00  2.09           N  
ATOM    952  CZ  ARG A 422      44.576  52.945  -9.109  1.00  2.79           C  
ATOM    953  NH1 ARG A 422      45.806  53.224  -9.519  1.00  3.07           N  
ATOM    954  NH2 ARG A 422      43.622  52.722 -10.003  1.00  3.71           N  
ATOM    955  H   ARG A 422      47.515  56.347  -5.846  1.00  0.72           H  
ATOM    956  HA  ARG A 422      46.494  57.405  -8.206  1.00  0.93           H  
ATOM    957  HB2 ARG A 422      45.269  55.299  -8.442  1.00  1.40           H  
ATOM    958  HB3 ARG A 422      46.906  55.008  -7.869  1.00  1.63           H  
ATOM    959  HG2 ARG A 422      46.053  54.755  -5.590  1.00  1.77           H  
ATOM    960  HG3 ARG A 422      44.414  55.016  -6.181  1.00  1.59           H  
ATOM    961  HD2 ARG A 422      46.238  52.777  -7.054  1.00  1.85           H  
ATOM    962  HD3 ARG A 422      44.965  52.626  -5.848  1.00  1.98           H  
ATOM    963  HE  ARG A 422      43.392  52.625  -7.535  1.00  2.50           H  
ATOM    964 HH11 ARG A 422      46.534  53.376  -8.851  1.00  2.89           H  
ATOM    965 HH12 ARG A 422      46.005  53.283 -10.498  1.00  3.81           H  
ATOM    966 HH21 ARG A 422      42.696  52.493  -9.700  1.00  4.01           H  
ATOM    967 HH22 ARG A 422      43.827  52.782 -10.979  1.00  4.32           H  
ATOM    968  N   LEU A 423      44.410  57.471  -5.687  1.00  0.65           N  
ATOM    969  CA  LEU A 423      43.148  58.021  -5.195  1.00  0.62           C  
ATOM    970  C   LEU A 423      43.044  59.518  -5.479  1.00  0.52           C  
ATOM    971  O   LEU A 423      41.958  60.036  -5.739  1.00  0.53           O  
ATOM    972  CB  LEU A 423      43.025  57.774  -3.690  1.00  0.69           C  
ATOM    973  CG  LEU A 423      43.100  56.306  -3.259  1.00  0.89           C  
ATOM    974  CD1 LEU A 423      43.107  56.194  -1.743  1.00  1.31           C  
ATOM    975  CD2 LEU A 423      41.937  55.518  -3.842  1.00  1.49           C  
ATOM    976  H   LEU A 423      45.016  57.039  -5.052  1.00  0.67           H  
ATOM    977  HA  LEU A 423      42.342  57.512  -5.702  1.00  0.70           H  
ATOM    978  HB2 LEU A 423      43.818  58.313  -3.192  1.00  0.84           H  
ATOM    979  HB3 LEU A 423      42.079  58.173  -3.358  1.00  0.96           H  
ATOM    980  HG  LEU A 423      44.018  55.874  -3.631  1.00  1.73           H  
ATOM    981 HD11 LEU A 423      43.137  57.184  -1.309  1.00  1.89           H  
ATOM    982 HD12 LEU A 423      42.213  55.684  -1.414  1.00  1.84           H  
ATOM    983 HD13 LEU A 423      43.976  55.636  -1.428  1.00  1.77           H  
ATOM    984 HD21 LEU A 423      41.711  55.888  -4.831  1.00  2.04           H  
ATOM    985 HD22 LEU A 423      42.203  54.472  -3.901  1.00  1.97           H  
ATOM    986 HD23 LEU A 423      41.070  55.634  -3.208  1.00  2.03           H  
ATOM    987  N   ASP A 424      44.179  60.209  -5.405  1.00  0.49           N  
ATOM    988  CA  ASP A 424      44.222  61.652  -5.632  1.00  0.50           C  
ATOM    989  C   ASP A 424      43.615  62.035  -6.979  1.00  0.45           C  
ATOM    990  O   ASP A 424      43.826  61.363  -7.988  1.00  0.49           O  
ATOM    991  CB  ASP A 424      45.662  62.158  -5.554  1.00  0.66           C  
ATOM    992  CG  ASP A 424      46.343  61.764  -4.259  1.00  0.81           C  
ATOM    993  OD1 ASP A 424      45.768  62.025  -3.183  1.00  0.97           O  
ATOM    994  OD2 ASP A 424      47.454  61.200  -4.322  1.00  1.20           O  
ATOM    995  H   ASP A 424      45.009  59.738  -5.180  1.00  0.54           H  
ATOM    996  HA  ASP A 424      43.648  62.123  -4.849  1.00  0.53           H  
ATOM    997  HB2 ASP A 424      46.229  61.746  -6.376  1.00  0.64           H  
ATOM    998  HB3 ASP A 424      45.661  63.235  -5.626  1.00  0.77           H  
ATOM    999  N   GLY A 425      42.866  63.135  -6.977  1.00  0.44           N  
ATOM   1000  CA  GLY A 425      42.237  63.622  -8.191  1.00  0.50           C  
ATOM   1001  C   GLY A 425      41.425  64.879  -7.942  1.00  0.45           C  
ATOM   1002  O   GLY A 425      41.709  65.629  -7.009  1.00  0.70           O  
ATOM   1003  H   GLY A 425      42.746  63.628  -6.139  1.00  0.44           H  
ATOM   1004  HA2 GLY A 425      43.002  63.836  -8.923  1.00  0.64           H  
ATOM   1005  HA3 GLY A 425      41.584  62.855  -8.579  1.00  0.55           H  
ATOM   1006  N   TRP A 426      40.409  65.107  -8.767  1.00  0.50           N  
ATOM   1007  CA  TRP A 426      39.555  66.279  -8.614  1.00  0.44           C  
ATOM   1008  C   TRP A 426      38.309  65.949  -7.798  1.00  0.45           C  
ATOM   1009  O   TRP A 426      37.723  64.876  -7.948  1.00  0.57           O  
ATOM   1010  CB  TRP A 426      39.155  66.853  -9.974  1.00  0.47           C  
ATOM   1011  CG  TRP A 426      40.302  67.467 -10.721  1.00  0.49           C  
ATOM   1012  CD1 TRP A 426      41.241  66.816 -11.467  1.00  0.57           C  
ATOM   1013  CD2 TRP A 426      40.640  68.859 -10.774  1.00  0.48           C  
ATOM   1014  NE1 TRP A 426      42.131  67.721 -11.998  1.00  0.61           N  
ATOM   1015  CE2 TRP A 426      41.785  68.981 -11.584  1.00  0.55           C  
ATOM   1016  CE3 TRP A 426      40.082  70.015 -10.221  1.00  0.50           C  
ATOM   1017  CZ2 TRP A 426      42.379  70.212 -11.852  1.00  0.59           C  
ATOM   1018  CZ3 TRP A 426      40.674  71.235 -10.485  1.00  0.56           C  
ATOM   1019  CH2 TRP A 426      41.812  71.325 -11.295  1.00  0.59           C  
ATOM   1020  H   TRP A 426      40.224  64.470  -9.489  1.00  0.76           H  
ATOM   1021  HA  TRP A 426      40.123  67.025  -8.078  1.00  0.40           H  
ATOM   1022  HB2 TRP A 426      38.746  66.063 -10.584  1.00  0.54           H  
ATOM   1023  HB3 TRP A 426      38.405  67.616  -9.828  1.00  0.48           H  
ATOM   1024  HD1 TRP A 426      41.262  65.747 -11.621  1.00  0.64           H  
ATOM   1025  HE1 TRP A 426      42.891  67.499 -12.574  1.00  0.69           H  
ATOM   1026  HE3 TRP A 426      39.205  69.964  -9.592  1.00  0.51           H  
ATOM   1027  HZ2 TRP A 426      43.253  70.303 -12.477  1.00  0.66           H  
ATOM   1028  HZ3 TRP A 426      40.258  72.137 -10.063  1.00  0.62           H  
ATOM   1029  HH2 TRP A 426      42.243  72.298 -11.475  1.00  0.66           H  
ATOM   1030  N   VAL A 427      37.914  66.878  -6.935  1.00  0.39           N  
ATOM   1031  CA  VAL A 427      36.742  66.691  -6.090  1.00  0.46           C  
ATOM   1032  C   VAL A 427      35.915  67.968  -5.996  1.00  0.51           C  
ATOM   1033  O   VAL A 427      36.455  69.064  -5.849  1.00  0.70           O  
ATOM   1034  CB  VAL A 427      37.139  66.251  -4.670  1.00  0.64           C  
ATOM   1035  CG1 VAL A 427      37.687  64.836  -4.679  1.00  0.89           C  
ATOM   1036  CG2 VAL A 427      38.158  67.210  -4.084  1.00  0.85           C  
ATOM   1037  H   VAL A 427      38.427  67.711  -6.863  1.00  0.36           H  
ATOM   1038  HA  VAL A 427      36.136  65.912  -6.529  1.00  0.51           H  
ATOM   1039  HB  VAL A 427      36.257  66.269  -4.046  1.00  0.82           H  
ATOM   1040 HG11 VAL A 427      38.078  64.607  -5.660  1.00  1.39           H  
ATOM   1041 HG12 VAL A 427      38.478  64.754  -3.948  1.00  1.37           H  
ATOM   1042 HG13 VAL A 427      36.899  64.141  -4.434  1.00  1.44           H  
ATOM   1043 HG21 VAL A 427      37.744  68.208  -4.064  1.00  1.41           H  
ATOM   1044 HG22 VAL A 427      38.405  66.904  -3.078  1.00  1.32           H  
ATOM   1045 HG23 VAL A 427      39.051  67.204  -4.691  1.00  1.42           H  
ATOM   1046  N   GLY A 428      34.598  67.811  -6.077  1.00  0.52           N  
ATOM   1047  CA  GLY A 428      33.704  68.949  -6.000  1.00  0.65           C  
ATOM   1048  C   GLY A 428      33.797  69.673  -4.671  1.00  0.79           C  
ATOM   1049  O   GLY A 428      34.095  69.063  -3.643  1.00  1.72           O  
ATOM   1050  H   GLY A 428      34.229  66.909  -6.193  1.00  0.55           H  
ATOM   1051  HA2 GLY A 428      33.949  69.641  -6.791  1.00  0.70           H  
ATOM   1052  HA3 GLY A 428      32.690  68.605  -6.138  1.00  0.71           H  
ATOM   1053  N   ARG A 429      33.541  70.976  -4.697  1.00  0.54           N  
ATOM   1054  CA  ARG A 429      33.593  71.800  -3.494  1.00  0.54           C  
ATOM   1055  C   ARG A 429      32.714  71.220  -2.386  1.00  0.49           C  
ATOM   1056  O   ARG A 429      33.073  71.265  -1.210  1.00  0.53           O  
ATOM   1057  CB  ARG A 429      33.152  73.230  -3.823  1.00  0.68           C  
ATOM   1058  CG  ARG A 429      33.064  74.146  -2.612  1.00  0.83           C  
ATOM   1059  CD  ARG A 429      34.407  74.293  -1.912  1.00  0.85           C  
ATOM   1060  NE  ARG A 429      34.329  75.196  -0.765  1.00  1.20           N  
ATOM   1061  CZ  ARG A 429      33.661  74.919   0.354  1.00  1.26           C  
ATOM   1062  NH1 ARG A 429      33.072  73.741   0.507  1.00  1.73           N  
ATOM   1063  NH2 ARG A 429      33.602  75.814   1.329  1.00  1.65           N  
ATOM   1064  H   ARG A 429      33.310  71.399  -5.550  1.00  1.16           H  
ATOM   1065  HA  ARG A 429      34.616  71.819  -3.150  1.00  0.54           H  
ATOM   1066  HB2 ARG A 429      33.859  73.658  -4.518  1.00  0.75           H  
ATOM   1067  HB3 ARG A 429      32.181  73.194  -4.292  1.00  0.75           H  
ATOM   1068  HG2 ARG A 429      32.733  75.122  -2.938  1.00  1.02           H  
ATOM   1069  HG3 ARG A 429      32.346  73.738  -1.917  1.00  0.96           H  
ATOM   1070  HD2 ARG A 429      34.730  73.321  -1.570  1.00  0.83           H  
ATOM   1071  HD3 ARG A 429      35.125  74.683  -2.617  1.00  0.95           H  
ATOM   1072  HE  ARG A 429      34.784  76.062  -0.838  1.00  1.83           H  
ATOM   1073 HH11 ARG A 429      33.129  73.055  -0.218  1.00  1.78           H  
ATOM   1074 HH12 ARG A 429      32.572  73.539   1.349  1.00  2.32           H  
ATOM   1075 HH21 ARG A 429      34.058  76.699   1.225  1.00  2.00           H  
ATOM   1076 HH22 ARG A 429      33.101  75.606   2.170  1.00  1.92           H  
ATOM   1077  N   HIS A 430      31.557  70.685  -2.767  1.00  0.49           N  
ATOM   1078  CA  HIS A 430      30.627  70.104  -1.803  1.00  0.53           C  
ATOM   1079  C   HIS A 430      31.269  68.980  -0.996  1.00  0.47           C  
ATOM   1080  O   HIS A 430      30.896  68.742   0.153  1.00  0.49           O  
ATOM   1081  CB  HIS A 430      29.372  69.584  -2.506  1.00  0.65           C  
ATOM   1082  CG  HIS A 430      29.649  68.655  -3.646  1.00  0.77           C  
ATOM   1083  ND1 HIS A 430      30.311  69.043  -4.792  1.00  1.20           N  
ATOM   1084  CD2 HIS A 430      29.336  67.349  -3.819  1.00  1.47           C  
ATOM   1085  CE1 HIS A 430      30.392  68.017  -5.621  1.00  1.31           C  
ATOM   1086  NE2 HIS A 430      29.807  66.978  -5.054  1.00  1.46           N  
ATOM   1087  H   HIS A 430      31.322  70.682  -3.719  1.00  0.54           H  
ATOM   1088  HA  HIS A 430      30.338  70.890  -1.121  1.00  0.60           H  
ATOM   1089  HB2 HIS A 430      28.769  69.049  -1.788  1.00  0.79           H  
ATOM   1090  HB3 HIS A 430      28.808  70.423  -2.887  1.00  0.84           H  
ATOM   1091  HD1 HIS A 430      30.670  69.938  -4.971  1.00  1.81           H  
ATOM   1092  HD2 HIS A 430      28.812  66.717  -3.116  1.00  2.23           H  
ATOM   1093  HE1 HIS A 430      30.850  68.028  -6.598  1.00  1.79           H  
ATOM   1094  HE2 HIS A 430      29.628  66.122  -5.498  1.00  1.93           H  
ATOM   1095  N   ARG A 431      32.225  68.287  -1.601  1.00  0.43           N  
ATOM   1096  CA  ARG A 431      32.902  67.182  -0.930  1.00  0.41           C  
ATOM   1097  C   ARG A 431      33.947  67.692   0.057  1.00  0.37           C  
ATOM   1098  O   ARG A 431      34.143  67.105   1.120  1.00  0.57           O  
ATOM   1099  CB  ARG A 431      33.557  66.254  -1.955  1.00  0.44           C  
ATOM   1100  CG  ARG A 431      32.571  65.638  -2.933  1.00  0.53           C  
ATOM   1101  CD  ARG A 431      33.258  64.678  -3.888  1.00  0.64           C  
ATOM   1102  NE  ARG A 431      32.327  64.121  -4.866  1.00  1.39           N  
ATOM   1103  CZ  ARG A 431      32.685  63.286  -5.838  1.00  2.05           C  
ATOM   1104  NH1 ARG A 431      33.953  62.919  -5.970  1.00  2.55           N  
ATOM   1105  NH2 ARG A 431      31.774  62.821  -6.683  1.00  2.84           N  
ATOM   1106  H   ARG A 431      32.476  68.515  -2.520  1.00  0.44           H  
ATOM   1107  HA  ARG A 431      32.154  66.624  -0.385  1.00  0.45           H  
ATOM   1108  HB2 ARG A 431      34.286  66.817  -2.518  1.00  0.44           H  
ATOM   1109  HB3 ARG A 431      34.059  65.454  -1.431  1.00  0.48           H  
ATOM   1110  HG2 ARG A 431      31.817  65.100  -2.378  1.00  0.79           H  
ATOM   1111  HG3 ARG A 431      32.105  66.428  -3.504  1.00  0.68           H  
ATOM   1112  HD2 ARG A 431      34.041  65.207  -4.410  1.00  1.04           H  
ATOM   1113  HD3 ARG A 431      33.692  63.870  -3.317  1.00  1.03           H  
ATOM   1114  HE  ARG A 431      31.385  64.380  -4.794  1.00  1.96           H  
ATOM   1115 HH11 ARG A 431      34.644  63.269  -5.339  1.00  2.45           H  
ATOM   1116 HH12 ARG A 431      34.218  62.291  -6.702  1.00  3.35           H  
ATOM   1117 HH21 ARG A 431      30.818  63.098  -6.590  1.00  3.11           H  
ATOM   1118 HH22 ARG A 431      32.044  62.193  -7.413  1.00  3.42           H  
ATOM   1119  N   ILE A 432      34.616  68.783  -0.296  1.00  0.39           N  
ATOM   1120  CA  ILE A 432      35.635  69.363   0.571  1.00  0.36           C  
ATOM   1121  C   ILE A 432      35.033  70.378   1.536  1.00  0.38           C  
ATOM   1122  O   ILE A 432      34.160  71.164   1.165  1.00  0.44           O  
ATOM   1123  CB  ILE A 432      36.757  70.034  -0.245  1.00  0.38           C  
ATOM   1124  CG1 ILE A 432      37.435  69.000  -1.146  1.00  0.40           C  
ATOM   1125  CG2 ILE A 432      37.771  70.693   0.684  1.00  0.42           C  
ATOM   1126  CD1 ILE A 432      38.590  69.553  -1.952  1.00  0.46           C  
ATOM   1127  H   ILE A 432      34.417  69.210  -1.156  1.00  0.58           H  
ATOM   1128  HA  ILE A 432      36.074  68.559   1.144  1.00  0.36           H  
ATOM   1129  HB  ILE A 432      36.315  70.805  -0.860  1.00  0.42           H  
ATOM   1130 HG12 ILE A 432      37.816  68.196  -0.535  1.00  0.45           H  
ATOM   1131 HG13 ILE A 432      36.707  68.606  -1.839  1.00  0.41           H  
ATOM   1132 HG21 ILE A 432      37.759  70.193   1.641  1.00  1.14           H  
ATOM   1133 HG22 ILE A 432      38.758  70.617   0.250  1.00  1.08           H  
ATOM   1134 HG23 ILE A 432      37.515  71.733   0.815  1.00  1.07           H  
ATOM   1135 HD11 ILE A 432      39.305  70.011  -1.286  1.00  1.14           H  
ATOM   1136 HD12 ILE A 432      39.065  68.748  -2.496  1.00  1.11           H  
ATOM   1137 HD13 ILE A 432      38.222  70.291  -2.649  1.00  1.08           H  
ATOM   1138  N   SER A 433      35.508  70.355   2.777  1.00  0.34           N  
ATOM   1139  CA  SER A 433      35.025  71.267   3.808  1.00  0.38           C  
ATOM   1140  C   SER A 433      36.022  71.356   4.957  1.00  0.36           C  
ATOM   1141  O   SER A 433      36.606  70.352   5.364  1.00  0.34           O  
ATOM   1142  CB  SER A 433      33.665  70.809   4.338  1.00  0.41           C  
ATOM   1143  OG  SER A 433      32.684  70.829   3.318  1.00  0.53           O  
ATOM   1144  H   SER A 433      36.205  69.704   3.007  1.00  0.31           H  
ATOM   1145  HA  SER A 433      34.917  72.245   3.362  1.00  0.46           H  
ATOM   1146  HB2 SER A 433      33.752  69.800   4.715  1.00  0.39           H  
ATOM   1147  HB3 SER A 433      33.351  71.464   5.136  1.00  0.44           H  
ATOM   1148  HG  SER A 433      32.301  71.707   3.260  1.00  0.96           H  
ATOM   1149  N   ASP A 434      36.216  72.565   5.470  1.00  0.43           N  
ATOM   1150  CA  ASP A 434      37.147  72.791   6.569  1.00  0.48           C  
ATOM   1151  C   ASP A 434      36.702  72.058   7.832  1.00  0.48           C  
ATOM   1152  O   ASP A 434      37.523  71.711   8.679  1.00  0.74           O  
ATOM   1153  CB  ASP A 434      37.274  74.287   6.850  1.00  0.60           C  
ATOM   1154  CG  ASP A 434      35.950  74.916   7.236  1.00  0.83           C  
ATOM   1155  OD1 ASP A 434      35.006  74.864   6.421  1.00  1.12           O  
ATOM   1156  OD2 ASP A 434      35.856  75.459   8.357  1.00  1.35           O  
ATOM   1157  H   ASP A 434      35.723  73.327   5.099  1.00  0.48           H  
ATOM   1158  HA  ASP A 434      38.110  72.408   6.269  1.00  0.50           H  
ATOM   1159  HB2 ASP A 434      37.973  74.438   7.658  1.00  0.63           H  
ATOM   1160  HB3 ASP A 434      37.643  74.780   5.961  1.00  0.77           H  
ATOM   1161  N   ASN A 435      35.397  71.824   7.953  1.00  0.43           N  
ATOM   1162  CA  ASN A 435      34.856  71.129   9.117  1.00  0.47           C  
ATOM   1163  C   ASN A 435      34.367  69.735   8.734  1.00  0.39           C  
ATOM   1164  O   ASN A 435      33.691  69.558   7.720  1.00  0.38           O  
ATOM   1165  CB  ASN A 435      33.715  71.935   9.742  1.00  0.59           C  
ATOM   1166  CG  ASN A 435      33.308  71.397  11.099  1.00  1.26           C  
ATOM   1167  OD1 ASN A 435      34.120  71.333  12.022  1.00  2.16           O  
ATOM   1168  ND2 ASN A 435      32.046  71.009  11.230  1.00  1.81           N  
ATOM   1169  H   ASN A 435      34.787  72.123   7.246  1.00  0.58           H  
ATOM   1170  HA  ASN A 435      35.652  71.031   9.840  1.00  0.57           H  
ATOM   1171  HB2 ASN A 435      34.030  72.962   9.860  1.00  1.33           H  
ATOM   1172  HB3 ASN A 435      32.857  71.899   9.088  1.00  1.18           H  
ATOM   1173 HD21 ASN A 435      31.456  71.089  10.453  1.00  1.92           H  
ATOM   1174 HD22 ASN A 435      31.755  70.661  12.100  1.00  2.53           H  
ATOM   1175  N   ALA A 436      34.730  68.747   9.544  1.00  0.49           N  
ATOM   1176  CA  ALA A 436      34.350  67.362   9.293  1.00  0.55           C  
ATOM   1177  C   ALA A 436      32.872  67.105   9.582  1.00  0.55           C  
ATOM   1178  O   ALA A 436      32.212  66.364   8.853  1.00  0.54           O  
ATOM   1179  CB  ALA A 436      35.217  66.426  10.124  1.00  0.75           C  
ATOM   1180  H   ALA A 436      35.280  68.954  10.329  1.00  0.58           H  
ATOM   1181  HA  ALA A 436      34.540  67.150   8.251  1.00  0.55           H  
ATOM   1182  HB1 ALA A 436      35.916  67.007  10.706  1.00  1.33           H  
ATOM   1183  HB2 ALA A 436      35.759  65.761   9.467  1.00  1.30           H  
ATOM   1184  HB3 ALA A 436      34.589  65.848  10.785  1.00  1.23           H  
ATOM   1185  N   ASP A 437      32.364  67.702  10.658  1.00  0.65           N  
ATOM   1186  CA  ASP A 437      30.966  67.517  11.053  1.00  0.75           C  
ATOM   1187  C   ASP A 437      30.011  67.739   9.882  1.00  0.71           C  
ATOM   1188  O   ASP A 437      29.042  66.999   9.717  1.00  0.78           O  
ATOM   1189  CB  ASP A 437      30.609  68.463  12.201  1.00  0.92           C  
ATOM   1190  CG  ASP A 437      31.463  68.230  13.432  1.00  1.02           C  
ATOM   1191  OD1 ASP A 437      31.434  67.103  13.970  1.00  1.34           O  
ATOM   1192  OD2 ASP A 437      32.161  69.174  13.858  1.00  1.34           O  
ATOM   1193  H   ASP A 437      32.944  68.267  11.209  1.00  0.70           H  
ATOM   1194  HA  ASP A 437      30.857  66.500  11.396  1.00  0.80           H  
ATOM   1195  HB2 ASP A 437      30.749  69.482  11.876  1.00  0.91           H  
ATOM   1196  HB3 ASP A 437      29.573  68.315  12.471  1.00  1.02           H  
ATOM   1197  N   ASP A 438      30.289  68.754   9.071  1.00  0.68           N  
ATOM   1198  CA  ASP A 438      29.447  69.057   7.917  1.00  0.73           C  
ATOM   1199  C   ASP A 438      29.503  67.930   6.890  1.00  0.73           C  
ATOM   1200  O   ASP A 438      28.487  67.562   6.302  1.00  1.35           O  
ATOM   1201  CB  ASP A 438      29.875  70.376   7.269  1.00  0.88           C  
ATOM   1202  CG  ASP A 438      29.553  71.578   8.134  1.00  1.08           C  
ATOM   1203  OD1 ASP A 438      30.039  71.632   9.282  1.00  1.56           O  
ATOM   1204  OD2 ASP A 438      28.813  72.468   7.662  1.00  1.36           O  
ATOM   1205  H   ASP A 438      31.076  69.310   9.248  1.00  0.69           H  
ATOM   1206  HA  ASP A 438      28.431  69.153   8.269  1.00  0.83           H  
ATOM   1207  HB2 ASP A 438      30.941  70.355   7.098  1.00  0.89           H  
ATOM   1208  HB3 ASP A 438      29.364  70.486   6.324  1.00  0.96           H  
ATOM   1209  N   LEU A 439      30.699  67.392   6.676  1.00  0.54           N  
ATOM   1210  CA  LEU A 439      30.896  66.313   5.717  1.00  0.53           C  
ATOM   1211  C   LEU A 439      30.159  65.042   6.143  1.00  0.61           C  
ATOM   1212  O   LEU A 439      29.048  64.780   5.680  1.00  0.86           O  
ATOM   1213  CB  LEU A 439      32.386  66.029   5.534  1.00  0.52           C  
ATOM   1214  CG  LEU A 439      33.209  67.200   4.999  1.00  0.63           C  
ATOM   1215  CD1 LEU A 439      34.666  66.800   4.866  1.00  1.12           C  
ATOM   1216  CD2 LEU A 439      32.669  67.672   3.661  1.00  1.10           C  
ATOM   1217  H   LEU A 439      31.472  67.734   7.175  1.00  0.93           H  
ATOM   1218  HA  LEU A 439      30.489  66.642   4.773  1.00  0.63           H  
ATOM   1219  HB2 LEU A 439      32.798  65.738   6.489  1.00  0.73           H  
ATOM   1220  HB3 LEU A 439      32.492  65.204   4.848  1.00  0.76           H  
ATOM   1221  HG  LEU A 439      33.152  68.023   5.696  1.00  1.38           H  
ATOM   1222 HD11 LEU A 439      34.745  65.938   4.221  1.00  1.76           H  
ATOM   1223 HD12 LEU A 439      35.227  67.620   4.441  1.00  1.65           H  
ATOM   1224 HD13 LEU A 439      35.064  66.558   5.840  1.00  1.66           H  
ATOM   1225 HD21 LEU A 439      32.299  66.826   3.101  1.00  1.65           H  
ATOM   1226 HD22 LEU A 439      31.867  68.375   3.824  1.00  1.70           H  
ATOM   1227 HD23 LEU A 439      33.462  68.152   3.105  1.00  1.63           H  
ATOM   1228  N   GLY A 440      30.783  64.248   7.014  1.00  0.59           N  
ATOM   1229  CA  GLY A 440      30.161  63.016   7.463  1.00  0.77           C  
ATOM   1230  C   GLY A 440      30.342  62.766   8.949  1.00  0.96           C  
ATOM   1231  O   GLY A 440      30.457  61.619   9.376  1.00  1.36           O  
ATOM   1232  H   GLY A 440      31.669  64.497   7.346  1.00  0.62           H  
ATOM   1233  HA2 GLY A 440      29.104  63.055   7.242  1.00  0.83           H  
ATOM   1234  HA3 GLY A 440      30.598  62.190   6.919  1.00  0.91           H  
ATOM   1235  N   GLY A 441      30.351  63.842   9.736  1.00  0.93           N  
ATOM   1236  CA  GLY A 441      30.499  63.724  11.181  1.00  1.24           C  
ATOM   1237  C   GLY A 441      31.567  62.734  11.606  1.00  1.14           C  
ATOM   1238  O   GLY A 441      31.357  61.945  12.526  1.00  1.83           O  
ATOM   1239  H   GLY A 441      30.242  64.728   9.333  1.00  0.91           H  
ATOM   1240  HA2 GLY A 441      30.749  64.693  11.584  1.00  1.44           H  
ATOM   1241  HA3 GLY A 441      29.557  63.412  11.597  1.00  1.56           H  
ATOM   1242  N   ILE A 442      32.711  62.791  10.943  1.00  1.10           N  
ATOM   1243  CA  ILE A 442      33.833  61.912  11.244  1.00  1.03           C  
ATOM   1244  C   ILE A 442      33.547  60.470  10.810  1.00  1.05           C  
ATOM   1245  O   ILE A 442      33.326  59.580  11.633  1.00  1.39           O  
ATOM   1246  CB  ILE A 442      34.175  61.962  12.742  1.00  1.26           C  
ATOM   1247  CG1 ILE A 442      34.566  63.384  13.155  1.00  1.41           C  
ATOM   1248  CG2 ILE A 442      35.288  60.979  13.087  1.00  1.38           C  
ATOM   1249  CD1 ILE A 442      35.796  63.913  12.447  1.00  1.48           C  
ATOM   1250  H   ILE A 442      32.806  63.449  10.242  1.00  1.64           H  
ATOM   1251  HA  ILE A 442      34.688  62.274  10.693  1.00  0.97           H  
ATOM   1252  HB  ILE A 442      33.289  61.677  13.280  1.00  1.41           H  
ATOM   1253 HG12 ILE A 442      33.746  64.053  12.937  1.00  1.56           H  
ATOM   1254 HG13 ILE A 442      34.762  63.401  14.218  1.00  1.74           H  
ATOM   1255 HG21 ILE A 442      36.136  61.154  12.441  1.00  1.61           H  
ATOM   1256 HG22 ILE A 442      35.584  61.115  14.117  1.00  1.81           H  
ATOM   1257 HG23 ILE A 442      34.932  59.968  12.947  1.00  1.80           H  
ATOM   1258 HD11 ILE A 442      35.870  63.461  11.469  1.00  1.92           H  
ATOM   1259 HD12 ILE A 442      35.719  64.985  12.344  1.00  1.89           H  
ATOM   1260 HD13 ILE A 442      36.676  63.669  13.022  1.00  1.76           H  
ATOM   1261  N   THR A 443      33.581  60.257   9.496  1.00  1.13           N  
ATOM   1262  CA  THR A 443      33.365  58.948   8.894  1.00  1.36           C  
ATOM   1263  C   THR A 443      32.171  58.196   9.479  1.00  1.47           C  
ATOM   1264  O   THR A 443      32.303  57.082   9.989  1.00  2.20           O  
ATOM   1265  CB  THR A 443      34.630  58.090   9.011  1.00  2.21           C  
ATOM   1266  OG1 THR A 443      35.748  58.799   8.464  1.00  3.05           O  
ATOM   1267  CG2 THR A 443      34.473  56.759   8.289  1.00  2.78           C  
ATOM   1268  H   THR A 443      33.784  61.007   8.910  1.00  1.32           H  
ATOM   1269  HA  THR A 443      33.168  59.104   7.849  1.00  1.77           H  
ATOM   1270  HB  THR A 443      34.808  57.907  10.055  1.00  2.55           H  
ATOM   1271  HG1 THR A 443      35.741  59.705   8.782  1.00  3.42           H  
ATOM   1272 HG21 THR A 443      33.428  56.591   8.067  1.00  3.13           H  
ATOM   1273 HG22 THR A 443      35.038  56.779   7.369  1.00  3.23           H  
ATOM   1274 HG23 THR A 443      34.839  55.961   8.919  1.00  3.10           H  
ATOM   1275  N   VAL A 444      31.002  58.805   9.375  1.00  1.90           N  
ATOM   1276  CA  VAL A 444      29.779  58.206   9.849  1.00  2.70           C  
ATOM   1277  C   VAL A 444      28.595  58.717   9.035  1.00  3.02           C  
ATOM   1278  O   VAL A 444      28.411  59.924   8.881  1.00  3.60           O  
ATOM   1279  CB  VAL A 444      29.537  58.511  11.326  1.00  3.53           C  
ATOM   1280  CG1 VAL A 444      30.536  57.785  12.213  1.00  4.18           C  
ATOM   1281  CG2 VAL A 444      29.565  60.004  11.587  1.00  4.02           C  
ATOM   1282  H   VAL A 444      30.956  59.674   8.954  1.00  2.21           H  
ATOM   1283  HA  VAL A 444      29.858  57.136   9.727  1.00  3.01           H  
ATOM   1284  HB  VAL A 444      28.567  58.157  11.555  1.00  3.88           H  
ATOM   1285 HG11 VAL A 444      30.846  56.870  11.733  1.00  4.32           H  
ATOM   1286 HG12 VAL A 444      31.398  58.416  12.376  1.00  4.55           H  
ATOM   1287 HG13 VAL A 444      30.073  57.555  13.161  1.00  4.64           H  
ATOM   1288 HG21 VAL A 444      30.402  60.446  11.068  1.00  4.34           H  
ATOM   1289 HG22 VAL A 444      28.646  60.449  11.234  1.00  4.35           H  
ATOM   1290 HG23 VAL A 444      29.666  60.182  12.649  1.00  4.27           H  
ATOM   1291  N   LEU A 445      27.802  57.795   8.505  1.00  3.13           N  
ATOM   1292  CA  LEU A 445      26.647  58.167   7.698  1.00  3.83           C  
ATOM   1293  C   LEU A 445      25.494  58.657   8.572  1.00  4.75           C  
ATOM   1294  O   LEU A 445      25.065  57.962   9.492  1.00  4.99           O  
ATOM   1295  CB  LEU A 445      26.193  56.982   6.843  1.00  3.87           C  
ATOM   1296  CG  LEU A 445      27.244  56.446   5.869  1.00  3.48           C  
ATOM   1297  CD1 LEU A 445      26.676  55.292   5.057  1.00  3.82           C  
ATOM   1298  CD2 LEU A 445      27.739  57.553   4.952  1.00  3.70           C  
ATOM   1299  H   LEU A 445      28.000  56.847   8.651  1.00  3.04           H  
ATOM   1300  HA  LEU A 445      26.952  58.969   7.043  1.00  4.04           H  
ATOM   1301  HB2 LEU A 445      25.902  56.179   7.505  1.00  4.14           H  
ATOM   1302  HB3 LEU A 445      25.329  57.287   6.272  1.00  4.36           H  
ATOM   1303  HG  LEU A 445      28.089  56.073   6.432  1.00  3.46           H  
ATOM   1304 HD11 LEU A 445      25.738  54.977   5.486  1.00  4.26           H  
ATOM   1305 HD12 LEU A 445      26.518  55.614   4.038  1.00  4.01           H  
ATOM   1306 HD13 LEU A 445      27.373  54.467   5.068  1.00  3.98           H  
ATOM   1307 HD21 LEU A 445      27.811  58.477   5.507  1.00  3.88           H  
ATOM   1308 HD22 LEU A 445      28.711  57.291   4.561  1.00  3.91           H  
ATOM   1309 HD23 LEU A 445      27.046  57.679   4.132  1.00  4.11           H  
ATOM   1310  N   PRO A 446      24.969  59.864   8.288  1.00  5.56           N  
ATOM   1311  CA  PRO A 446      23.857  60.442   9.050  1.00  6.59           C  
ATOM   1312  C   PRO A 446      22.538  59.732   8.765  1.00  7.07           C  
ATOM   1313  O   PRO A 446      22.254  59.370   7.623  1.00  7.26           O  
ATOM   1314  CB  PRO A 446      23.803  61.888   8.558  1.00  7.40           C  
ATOM   1315  CG  PRO A 446      24.367  61.838   7.180  1.00  6.97           C  
ATOM   1316  CD  PRO A 446      25.415  60.760   7.200  1.00  5.82           C  
ATOM   1317  HA  PRO A 446      24.053  60.425  10.112  1.00  6.67           H  
ATOM   1318  HB2 PRO A 446      22.779  62.234   8.555  1.00  8.01           H  
ATOM   1319  HB3 PRO A 446      24.400  62.514   9.204  1.00  7.82           H  
ATOM   1320  HG2 PRO A 446      23.588  61.591   6.475  1.00  7.47           H  
ATOM   1321  HG3 PRO A 446      24.813  62.790   6.931  1.00  7.18           H  
ATOM   1322  HD2 PRO A 446      25.437  60.237   6.256  1.00  5.90           H  
ATOM   1323  HD3 PRO A 446      26.385  61.181   7.424  1.00  5.41           H  
ATOM   1324  N   ALA A 447      21.736  59.534   9.809  1.00  7.52           N  
ATOM   1325  CA  ALA A 447      20.449  58.864   9.662  1.00  8.19           C  
ATOM   1326  C   ALA A 447      19.592  59.552   8.600  1.00  8.83           C  
ATOM   1327  O   ALA A 447      19.397  60.767   8.642  1.00  9.06           O  
ATOM   1328  CB  ALA A 447      19.717  58.833  10.996  1.00  8.42           C  
ATOM   1329  H   ALA A 447      22.018  59.843  10.695  1.00  7.56           H  
ATOM   1330  HA  ALA A 447      20.637  57.845   9.358  1.00  8.35           H  
ATOM   1331  HB1 ALA A 447      19.102  57.947  11.048  1.00  8.54           H  
ATOM   1332  HB2 ALA A 447      19.093  59.710  11.085  1.00  8.56           H  
ATOM   1333  HB3 ALA A 447      20.436  58.820  11.802  1.00  8.62           H  
ATOM   1334  N   PRO A 448      19.071  58.781   7.625  1.00  9.38           N  
ATOM   1335  CA  PRO A 448      18.239  59.328   6.546  1.00 10.23           C  
ATOM   1336  C   PRO A 448      16.972  59.999   7.070  1.00 10.87           C  
ATOM   1337  O   PRO A 448      16.249  59.426   7.886  1.00 11.06           O  
ATOM   1338  CB  PRO A 448      17.879  58.099   5.704  1.00 10.80           C  
ATOM   1339  CG  PRO A 448      18.897  57.071   6.056  1.00 10.31           C  
ATOM   1340  CD  PRO A 448      19.260  57.327   7.490  1.00  9.48           C  
ATOM   1341  HA  PRO A 448      18.792  60.031   5.941  1.00 10.21           H  
ATOM   1342  HB2 PRO A 448      16.880  57.769   5.956  1.00 11.42           H  
ATOM   1343  HB3 PRO A 448      17.923  58.354   4.655  1.00 11.10           H  
ATOM   1344  HG2 PRO A 448      18.474  56.083   5.946  1.00 10.69           H  
ATOM   1345  HG3 PRO A 448      19.765  57.182   5.423  1.00 10.36           H  
ATOM   1346  HD2 PRO A 448      18.597  56.787   8.150  1.00  9.62           H  
ATOM   1347  HD3 PRO A 448      20.287  57.053   7.674  1.00  9.08           H  
ATOM   1348  N   PRO A 449      16.679  61.227   6.603  1.00 11.41           N  
ATOM   1349  CA  PRO A 449      15.490  61.972   7.029  1.00 12.23           C  
ATOM   1350  C   PRO A 449      14.198  61.285   6.603  1.00 13.10           C  
ATOM   1351  O   PRO A 449      14.056  60.867   5.453  1.00 13.50           O  
ATOM   1352  CB  PRO A 449      15.628  63.328   6.318  1.00 12.72           C  
ATOM   1353  CG  PRO A 449      17.052  63.401   5.878  1.00 12.39           C  
ATOM   1354  CD  PRO A 449      17.480  61.985   5.630  1.00 11.49           C  
ATOM   1355  HA  PRO A 449      15.480  62.123   8.098  1.00 12.04           H  
ATOM   1356  HB2 PRO A 449      14.955  63.363   5.475  1.00 13.53           H  
ATOM   1357  HB3 PRO A 449      15.390  64.122   7.009  1.00 12.61           H  
ATOM   1358  HG2 PRO A 449      17.127  63.981   4.970  1.00 13.04           H  
ATOM   1359  HG3 PRO A 449      17.655  63.843   6.660  1.00 12.30           H  
ATOM   1360  HD2 PRO A 449      17.243  61.689   4.618  1.00 11.77           H  
ATOM   1361  HD3 PRO A 449      18.535  61.867   5.823  1.00 10.85           H  
ATOM   1362  N   LEU A 450      13.256  61.174   7.535  1.00 13.55           N  
ATOM   1363  CA  LEU A 450      11.971  60.541   7.254  1.00 14.50           C  
ATOM   1364  C   LEU A 450      11.024  61.514   6.552  1.00 14.96           C  
ATOM   1365  O   LEU A 450       9.859  61.641   6.930  1.00 15.17           O  
ATOM   1366  CB  LEU A 450      11.335  60.036   8.553  1.00 15.07           C  
ATOM   1367  CG  LEU A 450      12.150  58.988   9.316  1.00 15.25           C  
ATOM   1368  CD1 LEU A 450      11.453  58.614  10.615  1.00 15.76           C  
ATOM   1369  CD2 LEU A 450      12.372  57.751   8.457  1.00 15.35           C  
ATOM   1370  H   LEU A 450      13.428  61.530   8.432  1.00 13.32           H  
ATOM   1371  HA  LEU A 450      12.153  59.701   6.604  1.00 14.63           H  
ATOM   1372  HB2 LEU A 450      11.177  60.882   9.206  1.00 15.17           H  
ATOM   1373  HB3 LEU A 450      10.374  59.605   8.313  1.00 15.44           H  
ATOM   1374  HG  LEU A 450      13.117  59.404   9.563  1.00 15.14           H  
ATOM   1375 HD11 LEU A 450      10.589  59.246  10.755  1.00 16.01           H  
ATOM   1376 HD12 LEU A 450      11.142  57.581  10.571  1.00 15.88           H  
ATOM   1377 HD13 LEU A 450      12.136  58.749  11.442  1.00 15.90           H  
ATOM   1378 HD21 LEU A 450      11.532  57.620   7.793  1.00 15.59           H  
ATOM   1379 HD22 LEU A 450      13.274  57.872   7.877  1.00 15.19           H  
ATOM   1380 HD23 LEU A 450      12.468  56.884   9.094  1.00 15.50           H  
ATOM   1381  N   ALA A 451      11.534  62.201   5.530  1.00 15.28           N  
ATOM   1382  CA  ALA A 451      10.734  63.164   4.778  1.00 15.91           C  
ATOM   1383  C   ALA A 451      10.177  64.248   5.699  1.00 16.47           C  
ATOM   1384  O   ALA A 451       8.963  64.378   5.857  1.00 16.74           O  
ATOM   1385  CB  ALA A 451       9.607  62.460   4.035  1.00 16.18           C  
ATOM   1386  H   ALA A 451      12.469  62.058   5.278  1.00 15.21           H  
ATOM   1387  HA  ALA A 451      11.381  63.629   4.048  1.00 15.94           H  
ATOM   1388  HB1 ALA A 451       8.902  63.192   3.674  1.00 16.28           H  
ATOM   1389  HB2 ALA A 451       9.107  61.777   4.705  1.00 16.27           H  
ATOM   1390  HB3 ALA A 451      10.015  61.911   3.199  1.00 16.32           H  
ATOM   1391  N   PRO A 452      11.064  65.040   6.330  1.00 16.82           N  
ATOM   1392  CA  PRO A 452      10.655  66.110   7.246  1.00 17.52           C  
ATOM   1393  C   PRO A 452       9.896  67.228   6.540  1.00 18.21           C  
ATOM   1394  O   PRO A 452      10.295  67.686   5.469  1.00 18.53           O  
ATOM   1395  CB  PRO A 452      11.980  66.635   7.809  1.00 17.79           C  
ATOM   1396  CG  PRO A 452      13.011  66.241   6.810  1.00 17.36           C  
ATOM   1397  CD  PRO A 452      12.530  64.954   6.200  1.00 16.73           C  
ATOM   1398  HA  PRO A 452      10.049  65.724   8.052  1.00 17.50           H  
ATOM   1399  HB2 PRO A 452      11.926  67.709   7.916  1.00 18.40           H  
ATOM   1400  HB3 PRO A 452      12.169  66.182   8.769  1.00 17.78           H  
ATOM   1401  HG2 PRO A 452      13.098  67.004   6.051  1.00 17.76           H  
ATOM   1402  HG3 PRO A 452      13.960  66.089   7.302  1.00 17.23           H  
ATOM   1403  HD2 PRO A 452      12.822  64.896   5.162  1.00 16.84           H  
ATOM   1404  HD3 PRO A 452      12.915  64.107   6.748  1.00 16.27           H  
ATOM   1405  N   ASP A 453       8.800  67.664   7.155  1.00 18.57           N  
ATOM   1406  CA  ASP A 453       7.975  68.732   6.601  1.00 19.36           C  
ATOM   1407  C   ASP A 453       6.910  69.161   7.606  1.00 19.52           C  
ATOM   1408  O   ASP A 453       6.173  68.329   8.136  1.00 19.55           O  
ATOM   1409  CB  ASP A 453       7.311  68.271   5.300  1.00 19.71           C  
ATOM   1410  CG  ASP A 453       6.490  69.366   4.644  1.00 20.25           C  
ATOM   1411  OD1 ASP A 453       5.510  69.831   5.266  1.00 20.55           O  
ATOM   1412  OD2 ASP A 453       6.828  69.761   3.508  1.00 20.48           O  
ATOM   1413  H   ASP A 453       8.542  67.257   8.009  1.00 18.38           H  
ATOM   1414  HA  ASP A 453       8.618  69.574   6.391  1.00 19.73           H  
ATOM   1415  HB2 ASP A 453       8.076  67.958   4.604  1.00 19.66           H  
ATOM   1416  HB3 ASP A 453       6.660  67.437   5.512  1.00 19.75           H  
ATOM   1417  N   GLN A 454       6.838  70.462   7.866  1.00 19.77           N  
ATOM   1418  CA  GLN A 454       5.865  71.002   8.807  1.00 20.09           C  
ATOM   1419  C   GLN A 454       4.449  70.892   8.249  1.00 20.37           C  
ATOM   1420  O   GLN A 454       4.205  71.433   7.150  1.00 20.63           O  
ATOM   1421  CB  GLN A 454       6.191  72.460   9.134  1.00 20.30           C  
ATOM   1422  CG  GLN A 454       7.566  72.652   9.754  1.00 20.53           C  
ATOM   1423  CD  GLN A 454       7.864  74.098  10.115  1.00 20.93           C  
ATOM   1424  OE1 GLN A 454       8.945  74.412  10.612  1.00 21.22           O  
ATOM   1425  NE2 GLN A 454       6.906  74.989   9.872  1.00 21.08           N  
ATOM   1426  OXT GLN A 454       3.597  70.270   8.917  1.00 20.45           O  
ATOM   1427  H   GLN A 454       7.455  71.075   7.412  1.00 19.82           H  
ATOM   1428  HA  GLN A 454       5.926  70.417   9.713  1.00 20.12           H  
ATOM   1429  HB2 GLN A 454       6.146  73.040   8.225  1.00 20.31           H  
ATOM   1430  HB3 GLN A 454       5.454  72.836   9.827  1.00 20.42           H  
ATOM   1431  HG2 GLN A 454       7.627  72.056  10.652  1.00 20.46           H  
ATOM   1432  HG3 GLN A 454       8.313  72.313   9.050  1.00 20.59           H  
ATOM   1433 HE21 GLN A 454       6.067  74.674   9.476  1.00 20.91           H  
ATOM   1434 HE22 GLN A 454       7.080  75.926  10.100  1.00 21.41           H  
TER    1435      GLN A 454                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
