
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 ( 1756),  selected  110 , name 2b8a_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2b8a_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    R     3_A      L       3           -
LGA    S     4_A      Y       4           -
LGA    N     5_A      F       5           -
LGA    R     6_A      Q       6           -
LGA    Q     7_A      G       7           #
LGA    K     8_A      -       -           -
LGA    E     9_A      D       8          3.571
LGA    Y    10_A      L       9          1.476
LGA    K    11_A      I      10          1.288
LGA    C    12_A      V      11          0.312
LGA    G    13_A      S      12          0.988
LGA    D    14_A      M      13          1.008
LGA    L    15_A      R      14          0.907
LGA    V    16_A      I      15          0.615
LGA    F    17_A      L      16          0.463
LGA    A    18_A      G      17          0.645
LGA    K    19_A      K      18          1.431
LGA    M    20_A      K      19          3.087
LGA    K    21_A      R      20          4.119
LGA    G    22_A      T      21          2.604
LGA    Y    23_A      K      22          3.293
LGA    P    24_A      T      23          1.031
LGA    H    25_A      W      24          0.405
LGA    W    26_A      X      25          1.298
LGA    P    27_A      K      26          0.734
LGA    A    28_A      G      27          0.757
LGA    R    29_A      T      28          1.180
LGA    I    30_A      L      29          0.659
LGA    D    31_A      I      30          0.807
LGA    E    32_A      A      31          1.346
LGA    M    33_A      I      32          1.673
LGA    P    34_A      Q      33          1.771
LGA    E    35_A      T      34          3.181
LGA    A    36_A      -       -           -
LGA    A    37_A      V      35          2.063
LGA    V    38_A      G      36          5.712
LGA    K    39_A      P      37           -
LGA    S    40_A      -       -           -
LGA    T    41_A      -       -           -
LGA    A    42_A      G      38          1.995
LGA    N    43_A      K      39          1.331
LGA    K    44_A      K      40          0.911
LGA    Y    45_A      Y      41          1.090
LGA    Q    46_A      K      42          0.861
LGA    V    47_A      V      43          0.690
LGA    F    48_A      K      44          0.713
LGA    F    49_A      F      45          0.715
LGA    F    50_A      D      46          0.930
LGA    G    51_A      N      47          1.262
LGA    T    52_A      K      48          2.547
LGA    H    53_A      -       -           -
LGA    E    54_A      G      49          1.225
LGA    T    55_A      K      50          0.821
LGA    A    56_A      S      51          0.914
LGA    F    57_A      L      52          0.616
LGA    L    58_A      L      53          0.606
LGA    G    59_A      S      54          1.565
LGA    P    60_A      G      55          1.599
LGA    K    61_A      N      56          0.958
LGA    D    62_A      X      57          1.024
LGA    L    63_A      I      58          0.854
LGA    F    64_A      A      59          0.804
LGA    P    65_A      Y      60          1.100
LGA    Y    66_A      D      61          1.490
LGA    E    67_A      Y      62          3.354
LGA    E    68_A      -       -           -
LGA    S    69_A      -       -           -
LGA    K    70_A      -       -           -
LGA    E    71_A      -       -           -
LGA    K    72_A      -       -           -
LGA    F    73_A      -       -           -
LGA    G    74_A      -       -           -
LGA    K    75_A      -       -           -
LGA    P    76_A      -       -           -
LGA    N    77_A      -       -           -
LGA    K    78_A      -       -           -
LGA    R    79_A      -       -           -
LGA    K    80_A      -       -           -
LGA    G    81_A      -       -           -
LGA    F    82_A      -       -           -
LGA    S    83_A      -       -           -
LGA    E    84_A      -       -           -
LGA    G    85_A      -       -           -
LGA    L    86_A      -       -           -
LGA    W    87_A      -       -           -
LGA    E    88_A      -       -           -
LGA    I    89_A      -       -           -
LGA    E    90_A      -       -           -
LGA    N    91_A      -       -           -
LGA    N    92_A      -       -           -
LGA    P    93_A      -       -           -
LGA    T    94_A      -       -           -
LGA    V    95_A      -       -           -
LGA    K    96_A      -       -           -
LGA    A    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    G    99_A      -       -           -
LGA    Y   100_A      -       -           -
LGA    Q   101_A      -       -           -
LGA    S   102_A      -       -           -
LGA    S   103_A      -       -           -
LGA    Q   104_A      -       -           -
LGA    K   105_A      -       -           -
LGA    K   106_A      -       -           -
LGA    S   107_A      -       -           -
LGA    C   108_A      -       -           -
LGA    A   109_A      -       -           -
LGA    E   110_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110   62    5.0     54    1.79    11.11     80.737     2.852

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.857736 * X  +  -0.513718 * Y  +  -0.019575 * Z  +  44.171375
  Y_new =  -0.498260 * X  +  -0.821343 * Y  +  -0.277728 * Z  +  66.437843
  Z_new =   0.126596 * X  +   0.247970 * Y  +  -0.960460 * Z  +  -0.774061 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.888931   -0.252661  [ DEG:   165.5236    -14.4764 ]
  Theta =  -0.126937   -3.014656  [ DEG:    -7.2729   -172.7271 ]
  Phi   =  -0.526258    2.615335  [ DEG:   -30.1524    149.8476 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2b8a_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2b8a_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110   62   5.0   54   1.79   11.11  80.737
REMARK  ---------------------------------------------------------- 
MOLECULE 2b8a_A
HEADER    HORMONE/GROWTH FACTOR                   06-OCT-05   2B8A              
TITLE     HIGH RESOLUTION STRUCTURE OF THE HDGF PWWP DOMAIN                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HEPATOMA-DERIVED GROWTH FACTOR;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PWWP DOMAIN;                                               
COMPND   5 SYNONYM: HDGF;                                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: HDGF;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: ROSETTA(DE3);                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PHIS PARALLEL II                          
KEYWDS    PWWP, HDGF                                                            
EXPDTA    NMR, 26 STRUCTURES                                                    
AUTHOR    S.M.LUKASIK,T.CIERPICKI,M.BORLOZ,J.GREMBECKA,A.EVERETT,               
AUTHOR   2 J.H.BUSHWELLER                                                       
REVDAT   2   21-MAR-06 2B8A    1       JRNL                                     
REVDAT   1   06-DEC-05 2B8A    0                                                
JRNL        AUTH   S.M.LUKASIK,T.CIERPICKI,M.BORLOZ,J.GREMBECKA,                
JRNL        AUTH 2 A.EVERETT,J.H.BUSHWELLER                                     
JRNL        TITL   HIGH RESOLUTION STRUCTURE OF THE HDGF PWWP DOMAIN:           
JRNL        TITL 2 A POTENTIAL DNA BINDING DOMAIN.                              
JRNL        REF    PROTEIN SCI.                  V.  15   314 2006              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2B8A A    1   110  UNP    Q8VHK7   HDGF_RAT         1    110             
SEQRES   1 A  110  MET SER ARG SER ASN ARG GLN LYS GLU TYR LYS CYS GLY          
SEQRES   2 A  110  ASP LEU VAL PHE ALA LYS MET LYS GLY TYR PRO HIS TRP          
SEQRES   3 A  110  PRO ALA ARG ILE ASP GLU MET PRO GLU ALA ALA VAL LYS          
SEQRES   4 A  110  SER THR ALA ASN LYS TYR GLN VAL PHE PHE PHE GLY THR          
SEQRES   5 A  110  HIS GLU THR ALA PHE LEU GLY PRO LYS ASP LEU PHE PRO          
SEQRES   6 A  110  TYR GLU GLU SER LYS GLU LYS PHE GLY LYS PRO ASN LYS          
SEQRES   7 A  110  ARG LYS GLY PHE SER GLU GLY LEU TRP GLU ILE GLU ASN          
SEQRES   8 A  110  ASN PRO THR VAL LYS ALA SER GLY TYR GLN SER SER GLN          
SEQRES   9 A  110  LYS LYS SER CYS ALA GLU                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      16.498  88.089  -4.071  1.00  0.00           N  
ATOM      2  CA  MET A   1      16.364  86.617  -3.918  1.00  0.00           C  
ATOM      3  C   MET A   1      17.181  86.110  -2.733  1.00  0.00           C  
ATOM      4  O   MET A   1      18.411  86.146  -2.754  1.00  0.00           O  
ATOM      5  CB  MET A   1      16.833  85.948  -5.213  1.00  0.00           C  
ATOM      6  CG  MET A   1      15.747  85.147  -5.912  1.00  0.00           C  
ATOM      7  SD  MET A   1      15.934  85.138  -7.705  1.00  0.00           S  
ATOM      8  CE  MET A   1      17.443  84.187  -7.882  1.00  0.00           C  
ATOM      9  H2  MET A   1      15.777  88.403  -4.755  1.00  0.00           H  
ATOM     10  HA  MET A   1      15.324  86.381  -3.754  1.00  0.00           H  
ATOM     11  HB2 MET A   1      17.181  86.711  -5.893  1.00  0.00           H  
ATOM     12  HB3 MET A   1      17.652  85.280  -4.986  1.00  0.00           H  
ATOM     13  HG2 MET A   1      15.785  84.128  -5.556  1.00  0.00           H  
ATOM     14  HG3 MET A   1      14.788  85.577  -5.665  1.00  0.00           H  
ATOM     15  HE1 MET A   1      18.037  84.601  -8.684  1.00  0.00           H  
ATOM     16  HE2 MET A   1      17.196  83.160  -8.110  1.00  0.00           H  
ATOM     17  HE3 MET A   1      18.004  84.225  -6.961  1.00  0.00           H  
ATOM     18  H1  MET A   1      16.342  88.520  -3.139  1.00  0.00           H  
ATOM     19  H3  MET A   1      17.456  88.286  -4.420  1.00  0.00           H  
ATOM     20  N   SER A   2      16.489  85.640  -1.701  1.00  0.00           N  
ATOM     21  CA  SER A   2      17.151  85.128  -0.507  1.00  0.00           C  
ATOM     22  C   SER A   2      17.137  83.602  -0.493  1.00  0.00           C  
ATOM     23  O   SER A   2      16.211  82.985   0.034  1.00  0.00           O  
ATOM     24  CB  SER A   2      16.470  85.671   0.753  1.00  0.00           C  
ATOM     25  OG  SER A   2      17.388  86.395   1.554  1.00  0.00           O  
ATOM     26  H   SER A   2      15.509  85.638  -1.744  1.00  0.00           H  
ATOM     27  HA  SER A   2      18.175  85.467  -0.526  1.00  0.00           H  
ATOM     28  HB2 SER A   2      15.664  86.329   0.468  1.00  0.00           H  
ATOM     29  HB3 SER A   2      16.076  84.848   1.332  1.00  0.00           H  
ATOM     30  HG  SER A   2      18.120  85.823   1.798  1.00  0.00           H  
ATOM     31  N   ARG A   3      18.169  83.001  -1.074  1.00  0.00           N  
ATOM     32  CA  ARG A   3      18.275  81.546  -1.129  1.00  0.00           C  
ATOM     33  C   ARG A   3      19.522  81.064  -0.391  1.00  0.00           C  
ATOM     34  O   ARG A   3      20.538  80.746  -1.008  1.00  0.00           O  
ATOM     35  CB  ARG A   3      18.303  81.072  -2.585  1.00  0.00           C  
ATOM     36  CG  ARG A   3      17.167  80.129  -2.941  1.00  0.00           C  
ATOM     37  CD  ARG A   3      17.397  78.739  -2.375  1.00  0.00           C  
ATOM     38  NE  ARG A   3      17.994  77.839  -3.358  1.00  0.00           N  
ATOM     39  CZ  ARG A   3      18.501  76.644  -3.058  1.00  0.00           C  
ATOM     40  NH1 ARG A   3      18.489  76.206  -1.805  1.00  0.00           N  
ATOM     41  NH2 ARG A   3      19.024  75.887  -4.013  1.00  0.00           N  
ATOM     42  H   ARG A   3      18.876  83.548  -1.478  1.00  0.00           H  
ATOM     43  HA  ARG A   3      17.404  81.135  -0.643  1.00  0.00           H  
ATOM     44  HB2 ARG A   3      18.243  81.934  -3.233  1.00  0.00           H  
ATOM     45  HB3 ARG A   3      19.237  80.561  -2.770  1.00  0.00           H  
ATOM     46  HG2 ARG A   3      16.245  80.522  -2.537  1.00  0.00           H  
ATOM     47  HG3 ARG A   3      17.089  80.063  -4.016  1.00  0.00           H  
ATOM     48  HD2 ARG A   3      18.060  78.815  -1.524  1.00  0.00           H  
ATOM     49  HD3 ARG A   3      16.450  78.331  -2.055  1.00  0.00           H  
ATOM     50  HE  ARG A   3      18.016  78.138  -4.290  1.00  0.00           H  
ATOM     51 HH11 ARG A   3      18.096  76.772  -1.081  1.00  0.00           H  
ATOM     52 HH12 ARG A   3      18.872  75.309  -1.586  1.00  0.00           H  
ATOM     53 HH21 ARG A   3      19.037  76.212  -4.959  1.00  0.00           H  
ATOM     54 HH22 ARG A   3      19.406  74.991  -3.789  1.00  0.00           H  
ATOM     55  N   SER A   4      19.435  81.014   0.933  1.00  0.00           N  
ATOM     56  CA  SER A   4      20.554  80.571   1.758  1.00  0.00           C  
ATOM     57  C   SER A   4      21.788  81.436   1.518  1.00  0.00           C  
ATOM     58  O   SER A   4      22.577  81.170   0.612  1.00  0.00           O  
ATOM     59  CB  SER A   4      20.880  79.105   1.464  1.00  0.00           C  
ATOM     60  OG  SER A   4      19.736  78.285   1.628  1.00  0.00           O  
ATOM     61  H   SER A   4      18.598  81.282   1.369  1.00  0.00           H  
ATOM     62  HA  SER A   4      20.260  80.662   2.792  1.00  0.00           H  
ATOM     63  HB2 SER A   4      21.230  79.014   0.447  1.00  0.00           H  
ATOM     64  HB3 SER A   4      21.650  78.767   2.142  1.00  0.00           H  
ATOM     65  HG  SER A   4      19.844  77.736   2.409  1.00  0.00           H  
ATOM     66  N   ASN A   5      21.947  82.471   2.335  1.00  0.00           N  
ATOM     67  CA  ASN A   5      23.084  83.376   2.213  1.00  0.00           C  
ATOM     68  C   ASN A   5      24.363  82.709   2.707  1.00  0.00           C  
ATOM     69  O   ASN A   5      24.755  82.879   3.862  1.00  0.00           O  
ATOM     70  CB  ASN A   5      22.828  84.662   3.000  1.00  0.00           C  
ATOM     71  CG  ASN A   5      21.681  85.472   2.430  1.00  0.00           C  
ATOM     72  OD1 ASN A   5      20.639  84.925   2.067  1.00  0.00           O  
ATOM     73  ND2 ASN A   5      21.867  86.783   2.349  1.00  0.00           N  
ATOM     74  H   ASN A   5      21.282  82.632   3.039  1.00  0.00           H  
ATOM     75  HA  ASN A   5      23.201  83.620   1.167  1.00  0.00           H  
ATOM     76  HB2 ASN A   5      22.593  84.409   4.022  1.00  0.00           H  
ATOM     77  HB3 ASN A   5      23.720  85.272   2.980  1.00  0.00           H  
ATOM     78 HD21 ASN A   5      22.722  87.150   2.656  1.00  0.00           H  
ATOM     79 HD22 ASN A   5      21.142  87.332   1.984  1.00  0.00           H  
ATOM     80  N   ARG A   6      25.009  81.951   1.829  1.00  0.00           N  
ATOM     81  CA  ARG A   6      26.244  81.260   2.180  1.00  0.00           C  
ATOM     82  C   ARG A   6      27.143  81.093   0.960  1.00  0.00           C  
ATOM     83  O   ARG A   6      26.720  80.565  -0.068  1.00  0.00           O  
ATOM     84  CB  ARG A   6      25.932  79.892   2.788  1.00  0.00           C  
ATOM     85  CG  ARG A   6      25.186  78.962   1.845  1.00  0.00           C  
ATOM     86  CD  ARG A   6      24.265  78.020   2.603  1.00  0.00           C  
ATOM     87  NE  ARG A   6      24.957  77.335   3.692  1.00  0.00           N  
ATOM     88  CZ  ARG A   6      24.461  76.282   4.339  1.00  0.00           C  
ATOM     89  NH1 ARG A   6      23.271  75.792   4.014  1.00  0.00           N  
ATOM     90  NH2 ARG A   6      25.159  75.718   5.316  1.00  0.00           N  
ATOM     91  H   ARG A   6      24.648  81.853   0.923  1.00  0.00           H  
ATOM     92  HA  ARG A   6      26.762  81.859   2.914  1.00  0.00           H  
ATOM     93  HB2 ARG A   6      26.861  79.414   3.068  1.00  0.00           H  
ATOM     94  HB3 ARG A   6      25.328  80.032   3.672  1.00  0.00           H  
ATOM     95  HG2 ARG A   6      24.595  79.556   1.164  1.00  0.00           H  
ATOM     96  HG3 ARG A   6      25.905  78.377   1.287  1.00  0.00           H  
ATOM     97  HD2 ARG A   6      23.447  78.593   3.015  1.00  0.00           H  
ATOM     98  HD3 ARG A   6      23.877  77.284   1.915  1.00  0.00           H  
ATOM     99  HE  ARG A   6      25.837  77.675   3.953  1.00  0.00           H  
ATOM    100 HH11 ARG A   6      22.739  76.214   3.280  1.00  0.00           H  
ATOM    101 HH12 ARG A   6      22.906  75.002   4.505  1.00  0.00           H  
ATOM    102 HH21 ARG A   6      26.056  76.083   5.565  1.00  0.00           H  
ATOM    103 HH22 ARG A   6      24.787  74.927   5.803  1.00  0.00           H  
ATOM    104  N   GLN A   7      28.387  81.545   1.082  1.00  0.00           N  
ATOM    105  CA  GLN A   7      29.347  81.443  -0.011  1.00  0.00           C  
ATOM    106  C   GLN A   7      30.751  81.172   0.522  1.00  0.00           C  
ATOM    107  O   GLN A   7      31.516  82.100   0.785  1.00  0.00           O  
ATOM    108  CB  GLN A   7      29.346  82.725  -0.846  1.00  0.00           C  
ATOM    109  CG  GLN A   7      30.115  82.599  -2.151  1.00  0.00           C  
ATOM    110  CD  GLN A   7      31.187  83.660  -2.303  1.00  0.00           C  
ATOM    111  OE1 GLN A   7      32.052  83.814  -1.441  1.00  0.00           O  
ATOM    112  NE2 GLN A   7      31.135  84.398  -3.405  1.00  0.00           N  
ATOM    113  H   GLN A   7      28.667  81.954   1.928  1.00  0.00           H  
ATOM    114  HA  GLN A   7      29.049  80.617  -0.636  1.00  0.00           H  
ATOM    115  HB2 GLN A   7      28.324  82.986  -1.079  1.00  0.00           H  
ATOM    116  HB3 GLN A   7      29.788  83.521  -0.266  1.00  0.00           H  
ATOM    117  HG2 GLN A   7      30.586  81.627  -2.183  1.00  0.00           H  
ATOM    118  HG3 GLN A   7      29.420  82.688  -2.975  1.00  0.00           H  
ATOM    119 HE21 GLN A   7      30.418  84.220  -4.049  1.00  0.00           H  
ATOM    120 HE22 GLN A   7      31.817  85.092  -3.530  1.00  0.00           H  
ATOM    121  N   LYS A   8      31.080  79.895   0.677  1.00  0.00           N  
ATOM    122  CA  LYS A   8      32.391  79.498   1.177  1.00  0.00           C  
ATOM    123  C   LYS A   8      33.388  79.355   0.031  1.00  0.00           C  
ATOM    124  O   LYS A   8      33.002  79.239  -1.132  1.00  0.00           O  
ATOM    125  CB  LYS A   8      32.282  78.174   1.939  1.00  0.00           C  
ATOM    126  CG  LYS A   8      33.339  77.998   3.017  1.00  0.00           C  
ATOM    127  CD  LYS A   8      33.459  76.546   3.445  1.00  0.00           C  
ATOM    128  CE  LYS A   8      32.349  76.155   4.408  1.00  0.00           C  
ATOM    129  NZ  LYS A   8      32.840  75.250   5.484  1.00  0.00           N  
ATOM    130  H   LYS A   8      30.426  79.203   0.448  1.00  0.00           H  
ATOM    131  HA  LYS A   8      32.738  80.265   1.851  1.00  0.00           H  
ATOM    132  HB2 LYS A   8      31.311  78.122   2.408  1.00  0.00           H  
ATOM    133  HB3 LYS A   8      32.376  77.359   1.236  1.00  0.00           H  
ATOM    134  HG2 LYS A   8      34.292  78.327   2.633  1.00  0.00           H  
ATOM    135  HG3 LYS A   8      33.069  78.596   3.875  1.00  0.00           H  
ATOM    136  HD2 LYS A   8      33.399  75.917   2.568  1.00  0.00           H  
ATOM    137  HD3 LYS A   8      34.413  76.400   3.930  1.00  0.00           H  
ATOM    138  HE2 LYS A   8      31.949  77.050   4.859  1.00  0.00           H  
ATOM    139  HE3 LYS A   8      31.570  75.653   3.853  1.00  0.00           H  
ATOM    140  HZ1 LYS A   8      32.060  75.004   6.126  1.00  0.00           H  
ATOM    141  HZ2 LYS A   8      33.591  75.717   6.030  1.00  0.00           H  
ATOM    142  HZ3 LYS A   8      33.222  74.376   5.069  1.00  0.00           H  
ATOM    143  N   GLU A   9      34.674  79.359   0.370  1.00  0.00           N  
ATOM    144  CA  GLU A   9      35.730  79.228  -0.623  1.00  0.00           C  
ATOM    145  C   GLU A   9      36.990  78.648   0.010  1.00  0.00           C  
ATOM    146  O   GLU A   9      37.327  78.971   1.148  1.00  0.00           O  
ATOM    147  CB  GLU A   9      36.037  80.588  -1.259  1.00  0.00           C  
ATOM    148  CG  GLU A   9      35.430  80.760  -2.642  1.00  0.00           C  
ATOM    149  CD  GLU A   9      36.280  81.629  -3.548  1.00  0.00           C  
ATOM    150  OE1 GLU A   9      36.388  82.843  -3.275  1.00  0.00           O  
ATOM    151  OE2 GLU A   9      36.840  81.095  -4.529  1.00  0.00           O  
ATOM    152  H   GLU A   9      34.917  79.454   1.314  1.00  0.00           H  
ATOM    153  HA  GLU A   9      35.383  78.552  -1.390  1.00  0.00           H  
ATOM    154  HB2 GLU A   9      35.649  81.367  -0.619  1.00  0.00           H  
ATOM    155  HB3 GLU A   9      37.108  80.701  -1.342  1.00  0.00           H  
ATOM    156  HG2 GLU A   9      35.324  79.786  -3.098  1.00  0.00           H  
ATOM    157  HG3 GLU A   9      34.456  81.215  -2.540  1.00  0.00           H  
ATOM    158  N   TYR A  10      37.684  77.791  -0.734  1.00  0.00           N  
ATOM    159  CA  TYR A  10      38.910  77.166  -0.239  1.00  0.00           C  
ATOM    160  C   TYR A  10      40.119  77.622  -1.051  1.00  0.00           C  
ATOM    161  O   TYR A  10      39.975  78.117  -2.169  1.00  0.00           O  
ATOM    162  CB  TYR A  10      38.784  75.643  -0.297  1.00  0.00           C  
ATOM    163  CG  TYR A  10      37.683  75.104   0.586  1.00  0.00           C  
ATOM    164  CD1 TYR A  10      37.921  74.806   1.921  1.00  0.00           C  
ATOM    165  CD2 TYR A  10      36.402  74.903   0.087  1.00  0.00           C  
ATOM    166  CE1 TYR A  10      36.915  74.324   2.736  1.00  0.00           C  
ATOM    167  CE2 TYR A  10      35.391  74.419   0.894  1.00  0.00           C  
ATOM    168  CZ  TYR A  10      35.651  74.131   2.217  1.00  0.00           C  
ATOM    169  OH  TYR A  10      34.646  73.652   3.024  1.00  0.00           O  
ATOM    170  H   TYR A  10      37.368  77.575  -1.635  1.00  0.00           H  
ATOM    171  HA  TYR A  10      39.047  77.468   0.791  1.00  0.00           H  
ATOM    172  HB2 TYR A  10      38.574  75.342  -1.313  1.00  0.00           H  
ATOM    173  HB3 TYR A  10      39.716  75.198   0.021  1.00  0.00           H  
ATOM    174  HD1 TYR A  10      38.911  74.956   2.324  1.00  0.00           H  
ATOM    175  HD2 TYR A  10      36.200  75.127  -0.950  1.00  0.00           H  
ATOM    176  HE1 TYR A  10      37.120  74.098   3.772  1.00  0.00           H  
ATOM    177  HE2 TYR A  10      34.401  74.269   0.488  1.00  0.00           H  
ATOM    178  HH  TYR A  10      34.971  72.902   3.528  1.00  0.00           H  
ATOM    179  N   LYS A  11      41.309  77.471  -0.480  1.00  0.00           N  
ATOM    180  CA  LYS A  11      42.531  77.886  -1.153  1.00  0.00           C  
ATOM    181  C   LYS A  11      43.626  76.832  -1.006  1.00  0.00           C  
ATOM    182  O   LYS A  11      43.585  75.997  -0.105  1.00  0.00           O  
ATOM    183  CB  LYS A  11      43.016  79.224  -0.592  1.00  0.00           C  
ATOM    184  CG  LYS A  11      42.787  80.396  -1.532  1.00  0.00           C  
ATOM    185  CD  LYS A  11      43.721  80.337  -2.730  1.00  0.00           C  
ATOM    186  CE  LYS A  11      43.755  81.661  -3.476  1.00  0.00           C  
ATOM    187  NZ  LYS A  11      44.920  82.498  -3.074  1.00  0.00           N  
ATOM    188  H   LYS A  11      41.365  77.086   0.420  1.00  0.00           H  
ATOM    189  HA  LYS A  11      42.303  78.008  -2.199  1.00  0.00           H  
ATOM    190  HB2 LYS A  11      42.492  79.425   0.332  1.00  0.00           H  
ATOM    191  HB3 LYS A  11      44.074  79.156  -0.388  1.00  0.00           H  
ATOM    192  HG2 LYS A  11      41.766  80.370  -1.882  1.00  0.00           H  
ATOM    193  HG3 LYS A  11      42.962  81.315  -0.995  1.00  0.00           H  
ATOM    194  HD2 LYS A  11      44.718  80.103  -2.387  1.00  0.00           H  
ATOM    195  HD3 LYS A  11      43.379  79.565  -3.403  1.00  0.00           H  
ATOM    196  HE2 LYS A  11      43.816  81.462  -4.535  1.00  0.00           H  
ATOM    197  HE3 LYS A  11      42.845  82.202  -3.264  1.00  0.00           H  
ATOM    198  HZ1 LYS A  11      45.508  81.989  -2.384  1.00  0.00           H  
ATOM    199  HZ2 LYS A  11      44.593  83.386  -2.644  1.00  0.00           H  
ATOM    200  HZ3 LYS A  11      45.502  82.724  -3.908  1.00  0.00           H  
ATOM    201  N   CYS A  12      44.608  76.887  -1.903  1.00  0.00           N  
ATOM    202  CA  CYS A  12      45.722  75.943  -1.887  1.00  0.00           C  
ATOM    203  C   CYS A  12      46.396  75.897  -0.519  1.00  0.00           C  
ATOM    204  O   CYS A  12      46.785  76.935   0.020  1.00  0.00           O  
ATOM    205  CB  CYS A  12      46.748  76.321  -2.956  1.00  0.00           C  
ATOM    206  SG  CYS A  12      47.946  75.018  -3.322  1.00  0.00           S  
ATOM    207  H   CYS A  12      44.582  77.580  -2.595  1.00  0.00           H  
ATOM    208  HA  CYS A  12      45.327  74.961  -2.116  1.00  0.00           H  
ATOM    209  HB2 CYS A  12      46.231  76.558  -3.872  1.00  0.00           H  
ATOM    210  HB3 CYS A  12      47.296  77.190  -2.623  1.00  0.00           H  
ATOM    211  HG  CYS A  12      48.362  75.226  -4.162  1.00  0.00           H  
ATOM    212  N   GLY A  13      46.536  74.699   0.046  1.00  0.00           N  
ATOM    213  CA  GLY A  13      47.170  74.560   1.343  1.00  0.00           C  
ATOM    214  C   GLY A  13      46.176  74.379   2.475  1.00  0.00           C  
ATOM    215  O   GLY A  13      46.551  73.980   3.577  1.00  0.00           O  
ATOM    216  H   GLY A  13      46.205  73.911  -0.426  1.00  0.00           H  
ATOM    217  HA2 GLY A  13      47.826  73.703   1.318  1.00  0.00           H  
ATOM    218  HA3 GLY A  13      47.760  75.443   1.538  1.00  0.00           H  
ATOM    219  N   ASP A  14      44.907  74.671   2.206  1.00  0.00           N  
ATOM    220  CA  ASP A  14      43.862  74.538   3.215  1.00  0.00           C  
ATOM    221  C   ASP A  14      43.606  73.071   3.552  1.00  0.00           C  
ATOM    222  O   ASP A  14      43.570  72.216   2.666  1.00  0.00           O  
ATOM    223  CB  ASP A  14      42.568  75.190   2.727  1.00  0.00           C  
ATOM    224  CG  ASP A  14      42.485  76.660   3.091  1.00  0.00           C  
ATOM    225  OD1 ASP A  14      43.112  77.481   2.389  1.00  0.00           O  
ATOM    226  OD2 ASP A  14      41.795  76.988   4.077  1.00  0.00           O  
ATOM    227  H   ASP A  14      44.666  74.981   1.309  1.00  0.00           H  
ATOM    228  HA  ASP A  14      44.197  75.048   4.107  1.00  0.00           H  
ATOM    229  HB2 ASP A  14      42.512  75.103   1.651  1.00  0.00           H  
ATOM    230  HB3 ASP A  14      41.725  74.681   3.169  1.00  0.00           H  
ATOM    231  N   LEU A  15      43.420  72.785   4.837  1.00  0.00           N  
ATOM    232  CA  LEU A  15      43.155  71.424   5.285  1.00  0.00           C  
ATOM    233  C   LEU A  15      41.653  71.173   5.344  1.00  0.00           C  
ATOM    234  O   LEU A  15      40.932  71.825   6.100  1.00  0.00           O  
ATOM    235  CB  LEU A  15      43.787  71.177   6.657  1.00  0.00           C  
ATOM    236  CG  LEU A  15      45.318  71.207   6.682  1.00  0.00           C  
ATOM    237  CD1 LEU A  15      45.836  70.817   8.057  1.00  0.00           C  
ATOM    238  CD2 LEU A  15      45.887  70.282   5.614  1.00  0.00           C  
ATOM    239  H   LEU A  15      43.458  73.506   5.498  1.00  0.00           H  
ATOM    240  HA  LEU A  15      43.592  70.748   4.566  1.00  0.00           H  
ATOM    241  HB2 LEU A  15      43.422  71.931   7.338  1.00  0.00           H  
ATOM    242  HB3 LEU A  15      43.464  70.209   7.009  1.00  0.00           H  
ATOM    243  HG  LEU A  15      45.655  72.211   6.470  1.00  0.00           H  
ATOM    244 HD11 LEU A  15      45.609  71.602   8.764  1.00  0.00           H  
ATOM    245 HD12 LEU A  15      46.907  70.675   8.012  1.00  0.00           H  
ATOM    246 HD13 LEU A  15      45.364  69.900   8.375  1.00  0.00           H  
ATOM    247 HD21 LEU A  15      46.766  69.786   5.999  1.00  0.00           H  
ATOM    248 HD22 LEU A  15      46.155  70.862   4.742  1.00  0.00           H  
ATOM    249 HD23 LEU A  15      45.146  69.546   5.343  1.00  0.00           H  
ATOM    250  N   VAL A  16      41.186  70.227   4.538  1.00  0.00           N  
ATOM    251  CA  VAL A  16      39.768  69.904   4.496  1.00  0.00           C  
ATOM    252  C   VAL A  16      39.528  68.406   4.362  1.00  0.00           C  
ATOM    253  O   VAL A  16      40.454  67.632   4.114  1.00  0.00           O  
ATOM    254  CB  VAL A  16      39.071  70.621   3.325  1.00  0.00           C  
ATOM    255  CG1 VAL A  16      39.096  72.126   3.529  1.00  0.00           C  
ATOM    256  CG2 VAL A  16      39.724  70.241   2.006  1.00  0.00           C  
ATOM    257  H   VAL A  16      41.809  69.740   3.960  1.00  0.00           H  
ATOM    258  HA  VAL A  16      39.321  70.251   5.413  1.00  0.00           H  
ATOM    259  HB  VAL A  16      38.040  70.301   3.296  1.00  0.00           H  
ATOM    260 HG11 VAL A  16      40.073  72.429   3.874  1.00  0.00           H  
ATOM    261 HG12 VAL A  16      38.353  72.404   4.263  1.00  0.00           H  
ATOM    262 HG13 VAL A  16      38.876  72.620   2.593  1.00  0.00           H  
ATOM    263 HG21 VAL A  16      38.995  70.309   1.211  1.00  0.00           H  
ATOM    264 HG22 VAL A  16      40.098  69.229   2.067  1.00  0.00           H  
ATOM    265 HG23 VAL A  16      40.543  70.915   1.801  1.00  0.00           H  
ATOM    266  N   PHE A  17      38.267  68.018   4.496  1.00  0.00           N  
ATOM    267  CA  PHE A  17      37.863  66.622   4.366  1.00  0.00           C  
ATOM    268  C   PHE A  17      37.046  66.446   3.089  1.00  0.00           C  
ATOM    269  O   PHE A  17      36.198  67.279   2.772  1.00  0.00           O  
ATOM    270  CB  PHE A  17      37.033  66.194   5.577  1.00  0.00           C  
ATOM    271  CG  PHE A  17      37.854  65.873   6.789  1.00  0.00           C  
ATOM    272  CD1 PHE A  17      38.753  64.821   6.775  1.00  0.00           C  
ATOM    273  CD2 PHE A  17      37.717  66.622   7.943  1.00  0.00           C  
ATOM    274  CE1 PHE A  17      39.505  64.523   7.896  1.00  0.00           C  
ATOM    275  CE2 PHE A  17      38.462  66.330   9.067  1.00  0.00           C  
ATOM    276  CZ  PHE A  17      39.358  65.280   9.046  1.00  0.00           C  
ATOM    277  H   PHE A  17      37.580  68.700   4.660  1.00  0.00           H  
ATOM    278  HA  PHE A  17      38.755  66.014   4.308  1.00  0.00           H  
ATOM    279  HB2 PHE A  17      36.356  66.991   5.840  1.00  0.00           H  
ATOM    280  HB3 PHE A  17      36.464  65.315   5.320  1.00  0.00           H  
ATOM    281  HD1 PHE A  17      38.871  64.235   5.874  1.00  0.00           H  
ATOM    282  HD2 PHE A  17      37.019  67.443   7.963  1.00  0.00           H  
ATOM    283  HE1 PHE A  17      40.207  63.704   7.873  1.00  0.00           H  
ATOM    284  HE2 PHE A  17      38.345  66.922   9.960  1.00  0.00           H  
ATOM    285  HZ  PHE A  17      39.943  65.052   9.928  1.00  0.00           H  
ATOM    286  N   ALA A  18      37.303  65.371   2.348  1.00  0.00           N  
ATOM    287  CA  ALA A  18      36.582  65.117   1.107  1.00  0.00           C  
ATOM    288  C   ALA A  18      35.666  63.904   1.227  1.00  0.00           C  
ATOM    289  O   ALA A  18      36.111  62.807   1.574  1.00  0.00           O  
ATOM    290  CB  ALA A  18      37.561  64.930  -0.043  1.00  0.00           C  
ATOM    291  H   ALA A  18      37.993  64.740   2.635  1.00  0.00           H  
ATOM    292  HA  ALA A  18      35.979  65.987   0.896  1.00  0.00           H  
ATOM    293  HB1 ALA A  18      38.564  64.839   0.349  1.00  0.00           H  
ATOM    294  HB2 ALA A  18      37.511  65.786  -0.702  1.00  0.00           H  
ATOM    295  HB3 ALA A  18      37.307  64.037  -0.593  1.00  0.00           H  
ATOM    296  N   LYS A  19      34.386  64.105   0.930  1.00  0.00           N  
ATOM    297  CA  LYS A  19      33.409  63.028   0.997  1.00  0.00           C  
ATOM    298  C   LYS A  19      33.303  62.306  -0.344  1.00  0.00           C  
ATOM    299  O   LYS A  19      33.226  62.936  -1.399  1.00  0.00           O  
ATOM    300  CB  LYS A  19      32.039  63.575   1.407  1.00  0.00           C  
ATOM    301  CG  LYS A  19      30.972  62.499   1.537  1.00  0.00           C  
ATOM    302  CD  LYS A  19      30.686  62.169   2.992  1.00  0.00           C  
ATOM    303  CE  LYS A  19      30.410  60.687   3.184  1.00  0.00           C  
ATOM    304  NZ  LYS A  19      29.475  60.438   4.314  1.00  0.00           N  
ATOM    305  H   LYS A  19      34.095  64.998   0.653  1.00  0.00           H  
ATOM    306  HA  LYS A  19      33.746  62.326   1.739  1.00  0.00           H  
ATOM    307  HB2 LYS A  19      32.134  64.078   2.359  1.00  0.00           H  
ATOM    308  HB3 LYS A  19      31.712  64.288   0.665  1.00  0.00           H  
ATOM    309  HG2 LYS A  19      30.064  62.848   1.071  1.00  0.00           H  
ATOM    310  HG3 LYS A  19      31.314  61.605   1.036  1.00  0.00           H  
ATOM    311  HD2 LYS A  19      31.540  62.446   3.590  1.00  0.00           H  
ATOM    312  HD3 LYS A  19      29.821  62.731   3.315  1.00  0.00           H  
ATOM    313  HE2 LYS A  19      29.977  60.293   2.277  1.00  0.00           H  
ATOM    314  HE3 LYS A  19      31.345  60.182   3.383  1.00  0.00           H  
ATOM    315  HZ1 LYS A  19      29.683  61.087   5.099  1.00  0.00           H  
ATOM    316  HZ2 LYS A  19      29.576  59.459   4.654  1.00  0.00           H  
ATOM    317  HZ3 LYS A  19      28.493  60.587   4.005  1.00  0.00           H  
ATOM    318  N   MET A  20      33.298  60.979  -0.289  1.00  0.00           N  
ATOM    319  CA  MET A  20      33.199  60.159  -1.491  1.00  0.00           C  
ATOM    320  C   MET A  20      32.102  59.108  -1.335  1.00  0.00           C  
ATOM    321  O   MET A  20      31.804  58.674  -0.224  1.00  0.00           O  
ATOM    322  CB  MET A  20      34.537  59.476  -1.780  1.00  0.00           C  
ATOM    323  CG  MET A  20      35.708  60.441  -1.896  1.00  0.00           C  
ATOM    324  SD  MET A  20      36.189  60.753  -3.607  1.00  0.00           S  
ATOM    325  CE  MET A  20      37.830  60.031  -3.641  1.00  0.00           C  
ATOM    326  H   MET A  20      33.362  60.539   0.585  1.00  0.00           H  
ATOM    327  HA  MET A  20      32.947  60.807  -2.317  1.00  0.00           H  
ATOM    328  HB2 MET A  20      34.751  58.784  -0.979  1.00  0.00           H  
ATOM    329  HB3 MET A  20      34.456  58.927  -2.706  1.00  0.00           H  
ATOM    330  HG2 MET A  20      35.431  61.378  -1.438  1.00  0.00           H  
ATOM    331  HG3 MET A  20      36.553  60.021  -1.370  1.00  0.00           H  
ATOM    332  HE1 MET A  20      38.567  60.814  -3.763  1.00  0.00           H  
ATOM    333  HE2 MET A  20      37.900  59.338  -4.466  1.00  0.00           H  
ATOM    334  HE3 MET A  20      38.013  59.507  -2.715  1.00  0.00           H  
ATOM    335  N   LYS A  21      31.508  58.700  -2.454  1.00  0.00           N  
ATOM    336  CA  LYS A  21      30.447  57.698  -2.435  1.00  0.00           C  
ATOM    337  C   LYS A  21      30.998  56.330  -2.042  1.00  0.00           C  
ATOM    338  O   LYS A  21      31.904  55.807  -2.691  1.00  0.00           O  
ATOM    339  CB  LYS A  21      29.769  57.612  -3.805  1.00  0.00           C  
ATOM    340  CG  LYS A  21      28.357  57.053  -3.751  1.00  0.00           C  
ATOM    341  CD  LYS A  21      27.846  56.699  -5.138  1.00  0.00           C  
ATOM    342  CE  LYS A  21      27.331  57.926  -5.876  1.00  0.00           C  
ATOM    343  NZ  LYS A  21      28.143  58.223  -7.090  1.00  0.00           N  
ATOM    344  H   LYS A  21      31.790  59.081  -3.312  1.00  0.00           H  
ATOM    345  HA  LYS A  21      29.714  58.005  -1.701  1.00  0.00           H  
ATOM    346  HB2 LYS A  21      29.725  58.604  -4.234  1.00  0.00           H  
ATOM    347  HB3 LYS A  21      30.361  56.978  -4.447  1.00  0.00           H  
ATOM    348  HG2 LYS A  21      28.356  56.163  -3.141  1.00  0.00           H  
ATOM    349  HG3 LYS A  21      27.704  57.793  -3.314  1.00  0.00           H  
ATOM    350  HD2 LYS A  21      28.651  56.260  -5.708  1.00  0.00           H  
ATOM    351  HD3 LYS A  21      27.040  55.984  -5.042  1.00  0.00           H  
ATOM    352  HE2 LYS A  21      26.308  57.750  -6.172  1.00  0.00           H  
ATOM    353  HE3 LYS A  21      27.371  58.775  -5.211  1.00  0.00           H  
ATOM    354  HZ1 LYS A  21      28.568  57.350  -7.459  1.00  0.00           H  
ATOM    355  HZ2 LYS A  21      28.902  58.895  -6.858  1.00  0.00           H  
ATOM    356  HZ3 LYS A  21      27.540  58.642  -7.827  1.00  0.00           H  
ATOM    357  N   GLY A  22      30.445  55.757  -0.980  1.00  0.00           N  
ATOM    358  CA  GLY A  22      30.893  54.455  -0.522  1.00  0.00           C  
ATOM    359  C   GLY A  22      32.057  54.539   0.449  1.00  0.00           C  
ATOM    360  O   GLY A  22      32.524  53.517   0.952  1.00  0.00           O  
ATOM    361  H   GLY A  22      29.725  56.221  -0.502  1.00  0.00           H  
ATOM    362  HA2 GLY A  22      30.069  53.956  -0.035  1.00  0.00           H  
ATOM    363  HA3 GLY A  22      31.197  53.871  -1.379  1.00  0.00           H  
ATOM    364  N   TYR A  23      32.531  55.754   0.714  1.00  0.00           N  
ATOM    365  CA  TYR A  23      33.647  55.957   1.634  1.00  0.00           C  
ATOM    366  C   TYR A  23      33.405  57.180   2.514  1.00  0.00           C  
ATOM    367  O   TYR A  23      32.690  58.104   2.122  1.00  0.00           O  
ATOM    368  CB  TYR A  23      34.959  56.119   0.858  1.00  0.00           C  
ATOM    369  CG  TYR A  23      35.001  55.340  -0.440  1.00  0.00           C  
ATOM    370  CD1 TYR A  23      34.921  53.954  -0.446  1.00  0.00           C  
ATOM    371  CD2 TYR A  23      35.121  55.995  -1.660  1.00  0.00           C  
ATOM    372  CE1 TYR A  23      34.961  53.242  -1.629  1.00  0.00           C  
ATOM    373  CE2 TYR A  23      35.162  55.292  -2.847  1.00  0.00           C  
ATOM    374  CZ  TYR A  23      35.081  53.916  -2.827  1.00  0.00           C  
ATOM    375  OH  TYR A  23      35.122  53.211  -4.007  1.00  0.00           O  
ATOM    376  H   TYR A  23      32.122  56.533   0.282  1.00  0.00           H  
ATOM    377  HA  TYR A  23      33.718  55.083   2.269  1.00  0.00           H  
ATOM    378  HB2 TYR A  23      35.102  57.162   0.622  1.00  0.00           H  
ATOM    379  HB3 TYR A  23      35.776  55.779   1.475  1.00  0.00           H  
ATOM    380  HD1 TYR A  23      34.825  53.430   0.493  1.00  0.00           H  
ATOM    381  HD2 TYR A  23      35.181  57.070  -1.672  1.00  0.00           H  
ATOM    382  HE1 TYR A  23      34.898  52.164  -1.612  1.00  0.00           H  
ATOM    383  HE2 TYR A  23      35.257  55.823  -3.783  1.00  0.00           H  
ATOM    384  HH  TYR A  23      35.862  53.517  -4.538  1.00  0.00           H  
ATOM    385  N   PRO A  24      33.983  57.197   3.728  1.00  0.00           N  
ATOM    386  CA  PRO A  24      33.817  58.305   4.661  1.00  0.00           C  
ATOM    387  C   PRO A  24      34.787  59.450   4.394  1.00  0.00           C  
ATOM    388  O   PRO A  24      35.792  59.282   3.702  1.00  0.00           O  
ATOM    389  CB  PRO A  24      34.102  57.655   6.011  1.00  0.00           C  
ATOM    390  CG  PRO A  24      35.085  56.571   5.712  1.00  0.00           C  
ATOM    391  CD  PRO A  24      34.835  56.131   4.288  1.00  0.00           C  
ATOM    392  HA  PRO A  24      32.809  58.682   4.646  1.00  0.00           H  
ATOM    393  HB2 PRO A  24      34.515  58.389   6.687  1.00  0.00           H  
ATOM    394  HB3 PRO A  24      33.188  57.253   6.420  1.00  0.00           H  
ATOM    395  HG2 PRO A  24      36.090  56.955   5.812  1.00  0.00           H  
ATOM    396  HG3 PRO A  24      34.931  55.745   6.389  1.00  0.00           H  
ATOM    397  HD2 PRO A  24      35.768  56.063   3.749  1.00  0.00           H  
ATOM    398  HD3 PRO A  24      34.322  55.182   4.274  1.00  0.00           H  
ATOM    399  N   HIS A  25      34.485  60.611   4.969  1.00  0.00           N  
ATOM    400  CA  HIS A  25      35.323  61.799   4.816  1.00  0.00           C  
ATOM    401  C   HIS A  25      36.801  61.463   5.031  1.00  0.00           C  
ATOM    402  O   HIS A  25      37.194  61.032   6.115  1.00  0.00           O  
ATOM    403  CB  HIS A  25      34.885  62.867   5.818  1.00  0.00           C  
ATOM    404  CG  HIS A  25      33.425  63.190   5.747  1.00  0.00           C  
ATOM    405  ND1 HIS A  25      32.455  62.433   6.370  1.00  0.00           N  
ATOM    406  CD2 HIS A  25      32.770  64.193   5.117  1.00  0.00           C  
ATOM    407  CE1 HIS A  25      31.267  62.955   6.124  1.00  0.00           C  
ATOM    408  NE2 HIS A  25      31.430  64.023   5.367  1.00  0.00           N  
ATOM    409  H   HIS A  25      33.678  60.669   5.522  1.00  0.00           H  
ATOM    410  HA  HIS A  25      35.181  62.182   3.812  1.00  0.00           H  
ATOM    411  HB2 HIS A  25      35.097  62.522   6.817  1.00  0.00           H  
ATOM    412  HB3 HIS A  25      35.436  63.776   5.630  1.00  0.00           H  
ATOM    413  HD1 HIS A  25      32.615  61.632   6.912  1.00  0.00           H  
ATOM    414  HD2 HIS A  25      33.218  64.978   4.523  1.00  0.00           H  
ATOM    415  HE1 HIS A  25      30.323  62.572   6.483  1.00  0.00           H  
ATOM    416  HE2 HIS A  25      30.706  64.543   4.962  1.00  0.00           H  
ATOM    417  N   TRP A  26      37.614  61.650   3.995  1.00  0.00           N  
ATOM    418  CA  TRP A  26      39.043  61.350   4.074  1.00  0.00           C  
ATOM    419  C   TRP A  26      39.874  62.618   4.275  1.00  0.00           C  
ATOM    420  O   TRP A  26      39.753  63.571   3.507  1.00  0.00           O  
ATOM    421  CB  TRP A  26      39.493  60.639   2.795  1.00  0.00           C  
ATOM    422  CG  TRP A  26      40.623  59.675   2.999  1.00  0.00           C  
ATOM    423  CD1 TRP A  26      41.941  59.978   3.192  1.00  0.00           C  
ATOM    424  CD2 TRP A  26      40.535  58.245   3.015  1.00  0.00           C  
ATOM    425  NE1 TRP A  26      42.678  58.824   3.320  1.00  0.00           N  
ATOM    426  CE2 TRP A  26      41.835  57.748   3.218  1.00  0.00           C  
ATOM    427  CE3 TRP A  26      39.482  57.336   2.879  1.00  0.00           C  
ATOM    428  CZ2 TRP A  26      42.106  56.384   3.283  1.00  0.00           C  
ATOM    429  CZ3 TRP A  26      39.751  55.988   2.946  1.00  0.00           C  
ATOM    430  CH2 TRP A  26      41.050  55.522   3.146  1.00  0.00           C  
ATOM    431  H   TRP A  26      37.245  61.992   3.152  1.00  0.00           H  
ATOM    432  HA  TRP A  26      39.195  60.689   4.913  1.00  0.00           H  
ATOM    433  HB2 TRP A  26      38.659  60.090   2.388  1.00  0.00           H  
ATOM    434  HB3 TRP A  26      39.812  61.380   2.077  1.00  0.00           H  
ATOM    435  HD1 TRP A  26      42.334  60.985   3.231  1.00  0.00           H  
ATOM    436  HE1 TRP A  26      43.645  58.775   3.461  1.00  0.00           H  
ATOM    437  HE3 TRP A  26      38.473  57.669   2.724  1.00  0.00           H  
ATOM    438  HZ2 TRP A  26      43.106  56.004   3.438  1.00  0.00           H  
ATOM    439  HZ3 TRP A  26      38.949  55.273   2.842  1.00  0.00           H  
ATOM    440  HH2 TRP A  26      41.208  54.462   3.190  1.00  0.00           H  
ATOM    441  N   PRO A  27      40.760  62.642   5.293  1.00  0.00           N  
ATOM    442  CA  PRO A  27      41.621  63.799   5.556  1.00  0.00           C  
ATOM    443  C   PRO A  27      42.382  64.210   4.304  1.00  0.00           C  
ATOM    444  O   PRO A  27      43.138  63.418   3.737  1.00  0.00           O  
ATOM    445  CB  PRO A  27      42.589  63.305   6.644  1.00  0.00           C  
ATOM    446  CG  PRO A  27      42.415  61.822   6.694  1.00  0.00           C  
ATOM    447  CD  PRO A  27      41.011  61.548   6.241  1.00  0.00           C  
ATOM    448  HA  PRO A  27      41.054  64.643   5.926  1.00  0.00           H  
ATOM    449  HB2 PRO A  27      43.600  63.574   6.377  1.00  0.00           H  
ATOM    450  HB3 PRO A  27      42.330  63.760   7.588  1.00  0.00           H  
ATOM    451  HG2 PRO A  27      43.123  61.348   6.028  1.00  0.00           H  
ATOM    452  HG3 PRO A  27      42.558  61.470   7.704  1.00  0.00           H  
ATOM    453  HD2 PRO A  27      40.951  60.588   5.752  1.00  0.00           H  
ATOM    454  HD3 PRO A  27      40.328  61.597   7.075  1.00  0.00           H  
ATOM    455  N   ALA A  28      42.159  65.440   3.857  1.00  0.00           N  
ATOM    456  CA  ALA A  28      42.803  65.918   2.643  1.00  0.00           C  
ATOM    457  C   ALA A  28      43.162  67.399   2.713  1.00  0.00           C  
ATOM    458  O   ALA A  28      42.867  68.086   3.691  1.00  0.00           O  
ATOM    459  CB  ALA A  28      41.889  65.648   1.461  1.00  0.00           C  
ATOM    460  H   ALA A  28      41.531  66.022   4.335  1.00  0.00           H  
ATOM    461  HA  ALA A  28      43.706  65.346   2.502  1.00  0.00           H  
ATOM    462  HB1 ALA A  28      42.354  64.934   0.800  1.00  0.00           H  
ATOM    463  HB2 ALA A  28      41.705  66.568   0.927  1.00  0.00           H  
ATOM    464  HB3 ALA A  28      40.951  65.247   1.824  1.00  0.00           H  
ATOM    465  N   ARG A  29      43.805  67.877   1.648  1.00  0.00           N  
ATOM    466  CA  ARG A  29      44.219  69.273   1.555  1.00  0.00           C  
ATOM    467  C   ARG A  29      44.073  69.789   0.124  1.00  0.00           C  
ATOM    468  O   ARG A  29      44.095  69.009  -0.829  1.00  0.00           O  
ATOM    469  CB  ARG A  29      45.673  69.423   2.013  1.00  0.00           C  
ATOM    470  CG  ARG A  29      46.177  70.857   1.993  1.00  0.00           C  
ATOM    471  CD  ARG A  29      47.685  70.925   2.174  1.00  0.00           C  
ATOM    472  NE  ARG A  29      48.352  71.473   0.998  1.00  0.00           N  
ATOM    473  CZ  ARG A  29      49.673  71.588   0.880  1.00  0.00           C  
ATOM    474  NH1 ARG A  29      50.470  71.186   1.862  1.00  0.00           N  
ATOM    475  NH2 ARG A  29      50.198  72.104  -0.222  1.00  0.00           N  
ATOM    476  H   ARG A  29      44.006  67.270   0.902  1.00  0.00           H  
ATOM    477  HA  ARG A  29      43.585  69.854   2.204  1.00  0.00           H  
ATOM    478  HB2 ARG A  29      45.761  69.047   3.021  1.00  0.00           H  
ATOM    479  HB3 ARG A  29      46.305  68.833   1.364  1.00  0.00           H  
ATOM    480  HG2 ARG A  29      45.923  71.305   1.044  1.00  0.00           H  
ATOM    481  HG3 ARG A  29      45.702  71.408   2.792  1.00  0.00           H  
ATOM    482  HD2 ARG A  29      47.904  71.552   3.025  1.00  0.00           H  
ATOM    483  HD3 ARG A  29      48.060  69.927   2.358  1.00  0.00           H  
ATOM    484  HE  ARG A  29      47.787  71.775   0.255  1.00  0.00           H  
ATOM    485 HH11 ARG A  29      50.079  70.796   2.696  1.00  0.00           H  
ATOM    486 HH12 ARG A  29      51.461  71.275   1.768  1.00  0.00           H  
ATOM    487 HH21 ARG A  29      49.601  72.408  -0.965  1.00  0.00           H  
ATOM    488 HH22 ARG A  29      51.191  72.189  -0.309  1.00  0.00           H  
ATOM    489  N   ILE A  30      43.946  71.103  -0.028  1.00  0.00           N  
ATOM    490  CA  ILE A  30      43.821  71.711  -1.351  1.00  0.00           C  
ATOM    491  C   ILE A  30      45.200  71.900  -1.979  1.00  0.00           C  
ATOM    492  O   ILE A  30      46.159  72.253  -1.292  1.00  0.00           O  
ATOM    493  CB  ILE A  30      43.111  73.077  -1.280  1.00  0.00           C  
ATOM    494  CG1 ILE A  30      41.802  72.959  -0.495  1.00  0.00           C  
ATOM    495  CG2 ILE A  30      42.852  73.614  -2.682  1.00  0.00           C  
ATOM    496  CD1 ILE A  30      40.756  72.111  -1.184  1.00  0.00           C  
ATOM    497  H   ILE A  30      43.958  71.681   0.764  1.00  0.00           H  
ATOM    498  HA  ILE A  30      43.233  71.050  -1.972  1.00  0.00           H  
ATOM    499  HB  ILE A  30      43.766  73.770  -0.773  1.00  0.00           H  
ATOM    500 HG12 ILE A  30      42.007  72.515   0.468  1.00  0.00           H  
ATOM    501 HG13 ILE A  30      41.389  73.947  -0.349  1.00  0.00           H  
ATOM    502 HG21 ILE A  30      41.790  73.605  -2.881  1.00  0.00           H  
ATOM    503 HG22 ILE A  30      43.360  72.994  -3.406  1.00  0.00           H  
ATOM    504 HG23 ILE A  30      43.222  74.627  -2.752  1.00  0.00           H  
ATOM    505 HD11 ILE A  30      41.200  71.178  -1.500  1.00  0.00           H  
ATOM    506 HD12 ILE A  30      40.376  72.640  -2.047  1.00  0.00           H  
ATOM    507 HD13 ILE A  30      39.947  71.912  -0.498  1.00  0.00           H  
ATOM    508  N   ASP A  31      45.301  71.647  -3.281  1.00  0.00           N  
ATOM    509  CA  ASP A  31      46.576  71.778  -3.979  1.00  0.00           C  
ATOM    510  C   ASP A  31      46.497  72.753  -5.155  1.00  0.00           C  
ATOM    511  O   ASP A  31      47.522  73.251  -5.619  1.00  0.00           O  
ATOM    512  CB  ASP A  31      47.046  70.409  -4.474  1.00  0.00           C  
ATOM    513  CG  ASP A  31      47.517  69.516  -3.342  1.00  0.00           C  
ATOM    514  OD1 ASP A  31      46.803  69.425  -2.321  1.00  0.00           O  
ATOM    515  OD2 ASP A  31      48.597  68.904  -3.478  1.00  0.00           O  
ATOM    516  H   ASP A  31      44.509  71.358  -3.779  1.00  0.00           H  
ATOM    517  HA  ASP A  31      47.292  72.153  -3.269  1.00  0.00           H  
ATOM    518  HB2 ASP A  31      46.231  69.916  -4.982  1.00  0.00           H  
ATOM    519  HB3 ASP A  31      47.866  70.546  -5.165  1.00  0.00           H  
ATOM    520  N   GLU A  32      45.288  73.028  -5.634  1.00  0.00           N  
ATOM    521  CA  GLU A  32      45.112  73.945  -6.756  1.00  0.00           C  
ATOM    522  C   GLU A  32      43.664  74.411  -6.859  1.00  0.00           C  
ATOM    523  O   GLU A  32      42.740  73.691  -6.479  1.00  0.00           O  
ATOM    524  CB  GLU A  32      45.538  73.274  -8.064  1.00  0.00           C  
ATOM    525  CG  GLU A  32      45.943  74.257  -9.150  1.00  0.00           C  
ATOM    526  CD  GLU A  32      47.188  73.822  -9.898  1.00  0.00           C  
ATOM    527  OE1 GLU A  32      48.258  73.721  -9.261  1.00  0.00           O  
ATOM    528  OE2 GLU A  32      47.094  73.585 -11.121  1.00  0.00           O  
ATOM    529  H   GLU A  32      44.502  72.610  -5.231  1.00  0.00           H  
ATOM    530  HA  GLU A  32      45.741  74.803  -6.584  1.00  0.00           H  
ATOM    531  HB2 GLU A  32      46.378  72.623  -7.864  1.00  0.00           H  
ATOM    532  HB3 GLU A  32      44.715  72.679  -8.435  1.00  0.00           H  
ATOM    533  HG2 GLU A  32      45.131  74.346  -9.857  1.00  0.00           H  
ATOM    534  HG3 GLU A  32      46.130  75.219  -8.694  1.00  0.00           H  
ATOM    535  N   MET A  33      43.476  75.613  -7.391  1.00  0.00           N  
ATOM    536  CA  MET A  33      42.143  76.176  -7.563  1.00  0.00           C  
ATOM    537  C   MET A  33      41.589  75.836  -8.947  1.00  0.00           C  
ATOM    538  O   MET A  33      42.326  75.384  -9.822  1.00  0.00           O  
ATOM    539  CB  MET A  33      42.176  77.694  -7.369  1.00  0.00           C  
ATOM    540  CG  MET A  33      42.732  78.119  -6.021  1.00  0.00           C  
ATOM    541  SD  MET A  33      41.445  78.340  -4.778  1.00  0.00           S  
ATOM    542  CE  MET A  33      40.969  76.640  -4.482  1.00  0.00           C  
ATOM    543  H   MET A  33      44.251  76.131  -7.696  1.00  0.00           H  
ATOM    544  HA  MET A  33      41.498  75.739  -6.815  1.00  0.00           H  
ATOM    545  HB2 MET A  33      42.788  78.131  -8.144  1.00  0.00           H  
ATOM    546  HB3 MET A  33      41.171  78.079  -7.457  1.00  0.00           H  
ATOM    547  HG2 MET A  33      43.420  77.361  -5.675  1.00  0.00           H  
ATOM    548  HG3 MET A  33      43.260  79.054  -6.142  1.00  0.00           H  
ATOM    549  HE1 MET A  33      40.787  76.494  -3.428  1.00  0.00           H  
ATOM    550  HE2 MET A  33      41.762  75.981  -4.804  1.00  0.00           H  
ATOM    551  HE3 MET A  33      40.069  76.418  -5.036  1.00  0.00           H  
ATOM    552  N   PRO A  34      40.281  76.050  -9.162  1.00  0.00           N  
ATOM    553  CA  PRO A  34      39.633  75.767 -10.448  1.00  0.00           C  
ATOM    554  C   PRO A  34      40.134  76.685 -11.556  1.00  0.00           C  
ATOM    555  O   PRO A  34      40.444  77.853 -11.316  1.00  0.00           O  
ATOM    556  CB  PRO A  34      38.143  76.023 -10.177  1.00  0.00           C  
ATOM    557  CG  PRO A  34      38.013  76.078  -8.690  1.00  0.00           C  
ATOM    558  CD  PRO A  34      39.329  76.583  -8.179  1.00  0.00           C  
ATOM    559  HA  PRO A  34      39.777  74.739 -10.745  1.00  0.00           H  
ATOM    560  HB2 PRO A  34      37.849  76.958 -10.632  1.00  0.00           H  
ATOM    561  HB3 PRO A  34      37.556  75.217 -10.593  1.00  0.00           H  
ATOM    562  HG2 PRO A  34      37.219  76.756  -8.416  1.00  0.00           H  
ATOM    563  HG3 PRO A  34      37.813  75.090  -8.302  1.00  0.00           H  
ATOM    564  HD2 PRO A  34      39.344  77.663  -8.169  1.00  0.00           H  
ATOM    565  HD3 PRO A  34      39.530  76.188  -7.194  1.00  0.00           H  
ATOM    566  N   GLU A  35      40.209  76.153 -12.772  1.00  0.00           N  
ATOM    567  CA  GLU A  35      40.671  76.930 -13.915  1.00  0.00           C  
ATOM    568  C   GLU A  35      39.763  78.129 -14.155  1.00  0.00           C  
ATOM    569  O   GLU A  35      40.077  79.251 -13.759  1.00  0.00           O  
ATOM    570  CB  GLU A  35      40.739  76.048 -15.166  1.00  0.00           C  
ATOM    571  CG  GLU A  35      42.140  75.923 -15.741  1.00  0.00           C  
ATOM    572  CD  GLU A  35      42.590  74.482 -15.886  1.00  0.00           C  
ATOM    573  OE1 GLU A  35      42.896  73.850 -14.853  1.00  0.00           O  
ATOM    574  OE2 GLU A  35      42.636  73.986 -17.032  1.00  0.00           O  
ATOM    575  H   GLU A  35      39.948  75.217 -12.902  1.00  0.00           H  
ATOM    576  HA  GLU A  35      41.657  77.289 -13.691  1.00  0.00           H  
ATOM    577  HB2 GLU A  35      40.384  75.060 -14.916  1.00  0.00           H  
ATOM    578  HB3 GLU A  35      40.098  76.468 -15.927  1.00  0.00           H  
ATOM    579  HG2 GLU A  35      42.157  76.388 -16.716  1.00  0.00           H  
ATOM    580  HG3 GLU A  35      42.829  76.436 -15.088  1.00  0.00           H  
ATOM    581  N   ALA A  36      38.633  77.882 -14.801  1.00  0.00           N  
ATOM    582  CA  ALA A  36      37.672  78.931 -15.096  1.00  0.00           C  
ATOM    583  C   ALA A  36      36.374  78.330 -15.616  1.00  0.00           C  
ATOM    584  O   ALA A  36      35.319  78.459 -14.995  1.00  0.00           O  
ATOM    585  CB  ALA A  36      38.252  79.910 -16.107  1.00  0.00           C  
ATOM    586  H   ALA A  36      38.441  76.964 -15.081  1.00  0.00           H  
ATOM    587  HA  ALA A  36      37.472  79.469 -14.182  1.00  0.00           H  
ATOM    588  HB1 ALA A  36      38.625  80.781 -15.592  1.00  0.00           H  
ATOM    589  HB2 ALA A  36      37.484  80.206 -16.805  1.00  0.00           H  
ATOM    590  HB3 ALA A  36      39.061  79.435 -16.643  1.00  0.00           H  
ATOM    591  N   ALA A  37      36.469  77.666 -16.760  1.00  0.00           N  
ATOM    592  CA  ALA A  37      35.315  77.030 -17.378  1.00  0.00           C  
ATOM    593  C   ALA A  37      35.748  76.069 -18.480  1.00  0.00           C  
ATOM    594  O   ALA A  37      34.994  75.806 -19.417  1.00  0.00           O  
ATOM    595  CB  ALA A  37      34.372  78.082 -17.937  1.00  0.00           C  
ATOM    596  H   ALA A  37      37.341  77.602 -17.200  1.00  0.00           H  
ATOM    597  HA  ALA A  37      34.791  76.476 -16.611  1.00  0.00           H  
ATOM    598  HB1 ALA A  37      34.786  78.483 -18.849  1.00  0.00           H  
ATOM    599  HB2 ALA A  37      34.250  78.876 -17.216  1.00  0.00           H  
ATOM    600  HB3 ALA A  37      33.413  77.631 -18.144  1.00  0.00           H  
ATOM    601  N   VAL A  38      36.964  75.552 -18.364  1.00  0.00           N  
ATOM    602  CA  VAL A  38      37.502  74.628 -19.351  1.00  0.00           C  
ATOM    603  C   VAL A  38      37.216  73.182 -18.966  1.00  0.00           C  
ATOM    604  O   VAL A  38      36.803  72.902 -17.841  1.00  0.00           O  
ATOM    605  CB  VAL A  38      39.020  74.821 -19.509  1.00  0.00           C  
ATOM    606  CG1 VAL A  38      39.321  76.201 -20.075  1.00  0.00           C  
ATOM    607  CG2 VAL A  38      39.725  74.618 -18.176  1.00  0.00           C  
ATOM    608  H   VAL A  38      37.520  75.797 -17.595  1.00  0.00           H  
ATOM    609  HA  VAL A  38      37.032  74.841 -20.301  1.00  0.00           H  
ATOM    610  HB  VAL A  38      39.388  74.080 -20.205  1.00  0.00           H  
ATOM    611 HG11 VAL A  38      38.488  76.861 -19.878  1.00  0.00           H  
ATOM    612 HG12 VAL A  38      39.477  76.127 -21.141  1.00  0.00           H  
ATOM    613 HG13 VAL A  38      40.211  76.597 -19.609  1.00  0.00           H  
ATOM    614 HG21 VAL A  38      39.135  73.963 -17.552  1.00  0.00           H  
ATOM    615 HG22 VAL A  38      39.845  75.573 -17.683  1.00  0.00           H  
ATOM    616 HG23 VAL A  38      40.696  74.176 -18.344  1.00  0.00           H  
ATOM    617  N   LYS A  39      37.445  72.267 -19.907  1.00  0.00           N  
ATOM    618  CA  LYS A  39      37.222  70.839 -19.680  1.00  0.00           C  
ATOM    619  C   LYS A  39      35.926  70.590 -18.903  1.00  0.00           C  
ATOM    620  O   LYS A  39      35.077  71.474 -18.795  1.00  0.00           O  
ATOM    621  CB  LYS A  39      38.417  70.234 -18.935  1.00  0.00           C  
ATOM    622  CG  LYS A  39      38.695  70.881 -17.587  1.00  0.00           C  
ATOM    623  CD  LYS A  39      39.954  70.317 -16.948  1.00  0.00           C  
ATOM    624  CE  LYS A  39      40.631  71.341 -16.053  1.00  0.00           C  
ATOM    625  NZ  LYS A  39      42.097  71.412 -16.299  1.00  0.00           N  
ATOM    626  H   LYS A  39      37.780  72.560 -20.780  1.00  0.00           H  
ATOM    627  HA  LYS A  39      37.140  70.364 -20.645  1.00  0.00           H  
ATOM    628  HB2 LYS A  39      38.234  69.182 -18.773  1.00  0.00           H  
ATOM    629  HB3 LYS A  39      39.299  70.343 -19.548  1.00  0.00           H  
ATOM    630  HG2 LYS A  39      38.822  71.945 -17.724  1.00  0.00           H  
ATOM    631  HG3 LYS A  39      37.856  70.698 -16.930  1.00  0.00           H  
ATOM    632  HD2 LYS A  39      39.689  69.454 -16.355  1.00  0.00           H  
ATOM    633  HD3 LYS A  39      40.639  70.023 -17.728  1.00  0.00           H  
ATOM    634  HE2 LYS A  39      40.197  72.312 -16.243  1.00  0.00           H  
ATOM    635  HE3 LYS A  39      40.460  71.069 -15.022  1.00  0.00           H  
ATOM    636  HZ1 LYS A  39      42.505  70.454 -16.307  1.00  0.00           H  
ATOM    637  HZ2 LYS A  39      42.559  71.966 -15.551  1.00  0.00           H  
ATOM    638  HZ3 LYS A  39      42.284  71.863 -17.217  1.00  0.00           H  
ATOM    639  N   SER A  40      35.777  69.381 -18.368  1.00  0.00           N  
ATOM    640  CA  SER A  40      34.586  69.025 -17.609  1.00  0.00           C  
ATOM    641  C   SER A  40      34.775  69.335 -16.126  1.00  0.00           C  
ATOM    642  O   SER A  40      34.631  68.458 -15.274  1.00  0.00           O  
ATOM    643  CB  SER A  40      34.260  67.541 -17.799  1.00  0.00           C  
ATOM    644  OG  SER A  40      32.867  67.340 -17.963  1.00  0.00           O  
ATOM    645  H   SER A  40      36.483  68.714 -18.488  1.00  0.00           H  
ATOM    646  HA  SER A  40      33.764  69.615 -17.986  1.00  0.00           H  
ATOM    647  HB2 SER A  40      34.769  67.173 -18.678  1.00  0.00           H  
ATOM    648  HB3 SER A  40      34.592  66.987 -16.934  1.00  0.00           H  
ATOM    649  HG  SER A  40      32.389  67.868 -17.319  1.00  0.00           H  
ATOM    650  N   THR A  41      35.096  70.589 -15.827  1.00  0.00           N  
ATOM    651  CA  THR A  41      35.307  71.019 -14.447  1.00  0.00           C  
ATOM    652  C   THR A  41      34.446  72.234 -14.118  1.00  0.00           C  
ATOM    653  O   THR A  41      34.830  73.371 -14.392  1.00  0.00           O  
ATOM    654  CB  THR A  41      36.781  71.349 -14.212  1.00  0.00           C  
ATOM    655  OG1 THR A  41      37.241  72.305 -15.150  1.00  0.00           O  
ATOM    656  CG2 THR A  41      37.688  70.140 -14.303  1.00  0.00           C  
ATOM    657  H   THR A  41      35.194  71.242 -16.551  1.00  0.00           H  
ATOM    658  HA  THR A  41      35.021  70.204 -13.797  1.00  0.00           H  
ATOM    659  HB  THR A  41      36.890  71.767 -13.221  1.00  0.00           H  
ATOM    660  HG1 THR A  41      36.871  72.112 -16.015  1.00  0.00           H  
ATOM    661 HG21 THR A  41      37.153  69.325 -14.768  1.00  0.00           H  
ATOM    662 HG22 THR A  41      38.001  69.849 -13.312  1.00  0.00           H  
ATOM    663 HG23 THR A  41      38.556  70.386 -14.896  1.00  0.00           H  
ATOM    664  N   ALA A  42      33.283  71.986 -13.528  1.00  0.00           N  
ATOM    665  CA  ALA A  42      32.371  73.058 -13.157  1.00  0.00           C  
ATOM    666  C   ALA A  42      32.946  73.888 -12.017  1.00  0.00           C  
ATOM    667  O   ALA A  42      33.232  75.074 -12.178  1.00  0.00           O  
ATOM    668  CB  ALA A  42      31.021  72.486 -12.757  1.00  0.00           C  
ATOM    669  H   ALA A  42      33.033  71.058 -13.335  1.00  0.00           H  
ATOM    670  HA  ALA A  42      32.229  73.693 -14.018  1.00  0.00           H  
ATOM    671  HB1 ALA A  42      30.699  71.770 -13.499  1.00  0.00           H  
ATOM    672  HB2 ALA A  42      30.298  73.284 -12.686  1.00  0.00           H  
ATOM    673  HB3 ALA A  42      31.113  71.995 -11.799  1.00  0.00           H  
ATOM    674  N   ASN A  43      33.118  73.251 -10.864  1.00  0.00           N  
ATOM    675  CA  ASN A  43      33.664  73.923  -9.695  1.00  0.00           C  
ATOM    676  C   ASN A  43      34.340  72.919  -8.772  1.00  0.00           C  
ATOM    677  O   ASN A  43      34.002  72.804  -7.596  1.00  0.00           O  
ATOM    678  CB  ASN A  43      32.564  74.682  -8.946  1.00  0.00           C  
ATOM    679  CG  ASN A  43      32.543  76.160  -9.287  1.00  0.00           C  
ATOM    680  OD1 ASN A  43      33.478  76.897  -8.969  1.00  0.00           O  
ATOM    681  ND2 ASN A  43      31.472  76.603  -9.936  1.00  0.00           N  
ATOM    682  H   ASN A  43      32.874  72.304 -10.802  1.00  0.00           H  
ATOM    683  HA  ASN A  43      34.405  74.621 -10.040  1.00  0.00           H  
ATOM    684  HB2 ASN A  43      31.605  74.260  -9.201  1.00  0.00           H  
ATOM    685  HB3 ASN A  43      32.726  74.581  -7.882  1.00  0.00           H  
ATOM    686 HD21 ASN A  43      30.766  75.959 -10.155  1.00  0.00           H  
ATOM    687 HD22 ASN A  43      31.432  77.553 -10.169  1.00  0.00           H  
ATOM    688  N   LYS A  44      35.295  72.187  -9.326  1.00  0.00           N  
ATOM    689  CA  LYS A  44      36.026  71.181  -8.569  1.00  0.00           C  
ATOM    690  C   LYS A  44      37.419  71.681  -8.198  1.00  0.00           C  
ATOM    691  O   LYS A  44      37.824  72.776  -8.591  1.00  0.00           O  
ATOM    692  CB  LYS A  44      36.130  69.880  -9.375  1.00  0.00           C  
ATOM    693  CG  LYS A  44      34.963  69.651 -10.329  1.00  0.00           C  
ATOM    694  CD  LYS A  44      33.987  68.618  -9.784  1.00  0.00           C  
ATOM    695  CE  LYS A  44      32.661  69.251  -9.394  1.00  0.00           C  
ATOM    696  NZ  LYS A  44      31.501  68.422  -9.824  1.00  0.00           N  
ATOM    697  H   LYS A  44      35.510  72.326 -10.273  1.00  0.00           H  
ATOM    698  HA  LYS A  44      35.474  70.990  -7.662  1.00  0.00           H  
ATOM    699  HB2 LYS A  44      37.041  69.902  -9.955  1.00  0.00           H  
ATOM    700  HB3 LYS A  44      36.174  69.047  -8.687  1.00  0.00           H  
ATOM    701  HG2 LYS A  44      34.439  70.587 -10.475  1.00  0.00           H  
ATOM    702  HG3 LYS A  44      35.351  69.304 -11.276  1.00  0.00           H  
ATOM    703  HD2 LYS A  44      33.808  67.873 -10.544  1.00  0.00           H  
ATOM    704  HD3 LYS A  44      34.422  68.148  -8.914  1.00  0.00           H  
ATOM    705  HE2 LYS A  44      32.633  69.363  -8.320  1.00  0.00           H  
ATOM    706  HE3 LYS A  44      32.589  70.224  -9.857  1.00  0.00           H  
ATOM    707  HZ1 LYS A  44      31.714  67.414  -9.691  1.00  0.00           H  
ATOM    708  HZ2 LYS A  44      31.294  68.591 -10.828  1.00  0.00           H  
ATOM    709  HZ3 LYS A  44      30.661  68.666  -9.262  1.00  0.00           H  
ATOM    710  N   TYR A  45      38.146  70.867  -7.442  1.00  0.00           N  
ATOM    711  CA  TYR A  45      39.502  71.200  -7.011  1.00  0.00           C  
ATOM    712  C   TYR A  45      40.330  69.931  -6.853  1.00  0.00           C  
ATOM    713  O   TYR A  45      39.782  68.841  -6.707  1.00  0.00           O  
ATOM    714  CB  TYR A  45      39.478  71.957  -5.677  1.00  0.00           C  
ATOM    715  CG  TYR A  45      38.406  73.018  -5.593  1.00  0.00           C  
ATOM    716  CD1 TYR A  45      37.067  72.675  -5.442  1.00  0.00           C  
ATOM    717  CD2 TYR A  45      38.731  74.364  -5.676  1.00  0.00           C  
ATOM    718  CE1 TYR A  45      36.087  73.642  -5.374  1.00  0.00           C  
ATOM    719  CE2 TYR A  45      37.756  75.340  -5.607  1.00  0.00           C  
ATOM    720  CZ  TYR A  45      36.435  74.974  -5.458  1.00  0.00           C  
ATOM    721  OH  TYR A  45      35.460  75.942  -5.392  1.00  0.00           O  
ATOM    722  H   TYR A  45      37.755  70.010  -7.171  1.00  0.00           H  
ATOM    723  HA  TYR A  45      39.956  71.824  -7.771  1.00  0.00           H  
ATOM    724  HB2 TYR A  45      39.310  71.254  -4.876  1.00  0.00           H  
ATOM    725  HB3 TYR A  45      40.433  72.440  -5.530  1.00  0.00           H  
ATOM    726  HD1 TYR A  45      36.796  71.633  -5.371  1.00  0.00           H  
ATOM    727  HD2 TYR A  45      39.767  74.647  -5.792  1.00  0.00           H  
ATOM    728  HE1 TYR A  45      35.054  73.353  -5.258  1.00  0.00           H  
ATOM    729  HE2 TYR A  45      38.030  76.382  -5.671  1.00  0.00           H  
ATOM    730  HH  TYR A  45      34.699  75.665  -5.908  1.00  0.00           H  
ATOM    731  N   GLN A  46      41.648  70.077  -6.877  1.00  0.00           N  
ATOM    732  CA  GLN A  46      42.541  68.935  -6.728  1.00  0.00           C  
ATOM    733  C   GLN A  46      42.921  68.764  -5.264  1.00  0.00           C  
ATOM    734  O   GLN A  46      43.715  69.532  -4.720  1.00  0.00           O  
ATOM    735  CB  GLN A  46      43.798  69.124  -7.580  1.00  0.00           C  
ATOM    736  CG  GLN A  46      43.782  68.332  -8.877  1.00  0.00           C  
ATOM    737  CD  GLN A  46      45.018  68.571  -9.720  1.00  0.00           C  
ATOM    738  OE1 GLN A  46      45.505  69.697  -9.825  1.00  0.00           O  
ATOM    739  NE2 GLN A  46      45.535  67.508 -10.327  1.00  0.00           N  
ATOM    740  H   GLN A  46      42.031  70.973  -6.993  1.00  0.00           H  
ATOM    741  HA  GLN A  46      42.013  68.053  -7.060  1.00  0.00           H  
ATOM    742  HB2 GLN A  46      43.899  70.171  -7.826  1.00  0.00           H  
ATOM    743  HB3 GLN A  46      44.660  68.815  -7.007  1.00  0.00           H  
ATOM    744  HG2 GLN A  46      43.726  67.279  -8.640  1.00  0.00           H  
ATOM    745  HG3 GLN A  46      42.912  68.618  -9.449  1.00  0.00           H  
ATOM    746 HE21 GLN A  46      45.095  66.643 -10.197  1.00  0.00           H  
ATOM    747 HE22 GLN A  46      46.336  67.633 -10.878  1.00  0.00           H  
ATOM    748  N   VAL A  47      42.332  67.757  -4.629  1.00  0.00           N  
ATOM    749  CA  VAL A  47      42.594  67.489  -3.224  1.00  0.00           C  
ATOM    750  C   VAL A  47      43.537  66.306  -3.045  1.00  0.00           C  
ATOM    751  O   VAL A  47      43.520  65.350  -3.824  1.00  0.00           O  
ATOM    752  CB  VAL A  47      41.288  67.214  -2.446  1.00  0.00           C  
ATOM    753  CG1 VAL A  47      40.283  68.331  -2.682  1.00  0.00           C  
ATOM    754  CG2 VAL A  47      40.700  65.864  -2.831  1.00  0.00           C  
ATOM    755  H   VAL A  47      41.700  67.186  -5.116  1.00  0.00           H  
ATOM    756  HA  VAL A  47      43.057  68.368  -2.803  1.00  0.00           H  
ATOM    757  HB  VAL A  47      41.521  67.192  -1.392  1.00  0.00           H  
ATOM    758 HG11 VAL A  47      39.315  67.906  -2.900  1.00  0.00           H  
ATOM    759 HG12 VAL A  47      40.606  68.937  -3.517  1.00  0.00           H  
ATOM    760 HG13 VAL A  47      40.215  68.946  -1.797  1.00  0.00           H  
ATOM    761 HG21 VAL A  47      41.122  65.540  -3.771  1.00  0.00           H  
ATOM    762 HG22 VAL A  47      39.627  65.951  -2.929  1.00  0.00           H  
ATOM    763 HG23 VAL A  47      40.932  65.137  -2.064  1.00  0.00           H  
ATOM    764  N   PHE A  48      44.349  66.383  -1.999  1.00  0.00           N  
ATOM    765  CA  PHE A  48      45.301  65.327  -1.690  1.00  0.00           C  
ATOM    766  C   PHE A  48      44.803  64.488  -0.520  1.00  0.00           C  
ATOM    767  O   PHE A  48      44.557  65.010   0.567  1.00  0.00           O  
ATOM    768  CB  PHE A  48      46.672  65.927  -1.362  1.00  0.00           C  
ATOM    769  CG  PHE A  48      47.805  64.973  -1.607  1.00  0.00           C  
ATOM    770  CD1 PHE A  48      47.918  64.315  -2.822  1.00  0.00           C  
ATOM    771  CD2 PHE A  48      48.747  64.722  -0.622  1.00  0.00           C  
ATOM    772  CE1 PHE A  48      48.949  63.425  -3.050  1.00  0.00           C  
ATOM    773  CE2 PHE A  48      49.783  63.834  -0.845  1.00  0.00           C  
ATOM    774  CZ  PHE A  48      49.883  63.185  -2.060  1.00  0.00           C  
ATOM    775  H   PHE A  48      44.296  67.168  -1.414  1.00  0.00           H  
ATOM    776  HA  PHE A  48      45.395  64.693  -2.562  1.00  0.00           H  
ATOM    777  HB2 PHE A  48      46.832  66.800  -1.977  1.00  0.00           H  
ATOM    778  HB3 PHE A  48      46.694  66.214  -0.322  1.00  0.00           H  
ATOM    779  HD1 PHE A  48      47.190  64.504  -3.596  1.00  0.00           H  
ATOM    780  HD2 PHE A  48      48.670  65.232   0.328  1.00  0.00           H  
ATOM    781  HE1 PHE A  48      49.024  62.920  -4.004  1.00  0.00           H  
ATOM    782  HE2 PHE A  48      50.511  63.648  -0.070  1.00  0.00           H  
ATOM    783  HZ  PHE A  48      50.690  62.488  -2.236  1.00  0.00           H  
ATOM    784  N   PHE A  49      44.684  63.181  -0.748  1.00  0.00           N  
ATOM    785  CA  PHE A  49      44.234  62.245   0.281  1.00  0.00           C  
ATOM    786  C   PHE A  49      45.439  61.648   1.000  1.00  0.00           C  
ATOM    787  O   PHE A  49      46.136  60.792   0.446  1.00  0.00           O  
ATOM    788  CB  PHE A  49      43.396  61.124  -0.344  1.00  0.00           C  
ATOM    789  CG  PHE A  49      42.149  61.617  -1.026  1.00  0.00           C  
ATOM    790  CD1 PHE A  49      41.100  62.146  -0.290  1.00  0.00           C  
ATOM    791  CD2 PHE A  49      42.035  61.563  -2.404  1.00  0.00           C  
ATOM    792  CE1 PHE A  49      39.962  62.615  -0.919  1.00  0.00           C  
ATOM    793  CE2 PHE A  49      40.902  62.026  -3.037  1.00  0.00           C  
ATOM    794  CZ  PHE A  49      39.862  62.555  -2.295  1.00  0.00           C  
ATOM    795  H   PHE A  49      44.924  62.837  -1.625  1.00  0.00           H  
ATOM    796  HA  PHE A  49      43.620  62.790   0.987  1.00  0.00           H  
ATOM    797  HB2 PHE A  49      43.992  60.604  -1.078  1.00  0.00           H  
ATOM    798  HB3 PHE A  49      43.100  60.430   0.430  1.00  0.00           H  
ATOM    799  HD1 PHE A  49      41.175  62.195   0.786  1.00  0.00           H  
ATOM    800  HD2 PHE A  49      42.841  61.151  -2.987  1.00  0.00           H  
ATOM    801  HE1 PHE A  49      39.152  63.026  -0.336  1.00  0.00           H  
ATOM    802  HE2 PHE A  49      40.829  61.972  -4.112  1.00  0.00           H  
ATOM    803  HZ  PHE A  49      38.974  62.919  -2.791  1.00  0.00           H  
ATOM    804  N   PHE A  50      45.686  62.101   2.226  1.00  0.00           N  
ATOM    805  CA  PHE A  50      46.822  61.614   3.004  1.00  0.00           C  
ATOM    806  C   PHE A  50      46.779  60.100   3.162  1.00  0.00           C  
ATOM    807  O   PHE A  50      45.857  59.441   2.680  1.00  0.00           O  
ATOM    808  CB  PHE A  50      46.854  62.282   4.379  1.00  0.00           C  
ATOM    809  CG  PHE A  50      47.267  63.722   4.327  1.00  0.00           C  
ATOM    810  CD1 PHE A  50      48.562  64.073   3.973  1.00  0.00           C  
ATOM    811  CD2 PHE A  50      46.361  64.729   4.617  1.00  0.00           C  
ATOM    812  CE1 PHE A  50      48.943  65.399   3.914  1.00  0.00           C  
ATOM    813  CE2 PHE A  50      46.737  66.057   4.557  1.00  0.00           C  
ATOM    814  CZ  PHE A  50      48.029  66.392   4.207  1.00  0.00           C  
ATOM    815  H   PHE A  50      45.094  62.785   2.616  1.00  0.00           H  
ATOM    816  HA  PHE A  50      47.722  61.883   2.465  1.00  0.00           H  
ATOM    817  HB2 PHE A  50      45.871  62.232   4.821  1.00  0.00           H  
ATOM    818  HB3 PHE A  50      47.556  61.758   5.010  1.00  0.00           H  
ATOM    819  HD1 PHE A  50      49.277  63.297   3.744  1.00  0.00           H  
ATOM    820  HD2 PHE A  50      45.350  64.467   4.895  1.00  0.00           H  
ATOM    821  HE1 PHE A  50      49.955  65.659   3.641  1.00  0.00           H  
ATOM    822  HE2 PHE A  50      46.021  66.832   4.785  1.00  0.00           H  
ATOM    823  HZ  PHE A  50      48.324  67.429   4.160  1.00  0.00           H  
ATOM    824  N   GLY A  51      47.789  59.550   3.831  1.00  0.00           N  
ATOM    825  CA  GLY A  51      47.849  58.114   4.029  1.00  0.00           C  
ATOM    826  C   GLY A  51      48.172  57.374   2.746  1.00  0.00           C  
ATOM    827  O   GLY A  51      49.205  56.714   2.643  1.00  0.00           O  
ATOM    828  H   GLY A  51      48.500  60.123   4.187  1.00  0.00           H  
ATOM    829  HA2 GLY A  51      48.611  57.893   4.762  1.00  0.00           H  
ATOM    830  HA3 GLY A  51      46.895  57.772   4.401  1.00  0.00           H  
ATOM    831  N   THR A  52      47.287  57.498   1.764  1.00  0.00           N  
ATOM    832  CA  THR A  52      47.471  56.851   0.471  1.00  0.00           C  
ATOM    833  C   THR A  52      48.203  57.772  -0.502  1.00  0.00           C  
ATOM    834  O   THR A  52      48.801  57.314  -1.475  1.00  0.00           O  
ATOM    835  CB  THR A  52      46.115  56.449  -0.108  1.00  0.00           C  
ATOM    836  OG1 THR A  52      45.322  57.594  -0.366  1.00  0.00           O  
ATOM    837  CG2 THR A  52      45.323  55.542   0.809  1.00  0.00           C  
ATOM    838  H   THR A  52      46.492  58.050   1.907  1.00  0.00           H  
ATOM    839  HA  THR A  52      48.064  55.962   0.623  1.00  0.00           H  
ATOM    840  HB  THR A  52      46.272  55.925  -1.039  1.00  0.00           H  
ATOM    841  HG1 THR A  52      45.140  58.050   0.458  1.00  0.00           H  
ATOM    842 HG21 THR A  52      45.707  55.624   1.816  1.00  0.00           H  
ATOM    843 HG22 THR A  52      45.413  54.521   0.472  1.00  0.00           H  
ATOM    844 HG23 THR A  52      44.283  55.837   0.797  1.00  0.00           H  
ATOM    845  N   HIS A  53      48.147  59.077  -0.233  1.00  0.00           N  
ATOM    846  CA  HIS A  53      48.798  60.067  -1.087  1.00  0.00           C  
ATOM    847  C   HIS A  53      48.150  60.093  -2.467  1.00  0.00           C  
ATOM    848  O   HIS A  53      48.819  60.325  -3.473  1.00  0.00           O  
ATOM    849  CB  HIS A  53      50.296  59.768  -1.219  1.00  0.00           C  
ATOM    850  CG  HIS A  53      51.035  59.807   0.083  1.00  0.00           C  
ATOM    851  ND1 HIS A  53      52.271  59.221   0.264  1.00  0.00           N  
ATOM    852  CD2 HIS A  53      50.709  60.368   1.272  1.00  0.00           C  
ATOM    853  CE1 HIS A  53      52.672  59.419   1.507  1.00  0.00           C  
ATOM    854  NE2 HIS A  53      51.743  60.111   2.139  1.00  0.00           N  
ATOM    855  H   HIS A  53      47.647  59.380   0.552  1.00  0.00           H  
ATOM    856  HA  HIS A  53      48.673  61.035  -0.626  1.00  0.00           H  
ATOM    857  HB2 HIS A  53      50.423  58.783  -1.643  1.00  0.00           H  
ATOM    858  HB3 HIS A  53      50.744  60.496  -1.878  1.00  0.00           H  
ATOM    859  HD1 HIS A  53      52.778  58.733  -0.419  1.00  0.00           H  
ATOM    860  HD2 HIS A  53      49.805  60.915   1.496  1.00  0.00           H  
ATOM    861  HE1 HIS A  53      53.602  59.074   1.934  1.00  0.00           H  
ATOM    862  HE2 HIS A  53      51.832  60.484   3.042  1.00  0.00           H  
ATOM    863  N   GLU A  54      46.843  59.859  -2.503  1.00  0.00           N  
ATOM    864  CA  GLU A  54      46.103  59.859  -3.763  1.00  0.00           C  
ATOM    865  C   GLU A  54      45.463  61.220  -4.010  1.00  0.00           C  
ATOM    866  O   GLU A  54      45.239  61.977  -3.075  1.00  0.00           O  
ATOM    867  CB  GLU A  54      45.032  58.767  -3.751  1.00  0.00           C  
ATOM    868  CG  GLU A  54      45.589  57.380  -3.453  1.00  0.00           C  
ATOM    869  CD  GLU A  54      44.535  56.293  -3.528  1.00  0.00           C  
ATOM    870  OE1 GLU A  54      43.340  56.630  -3.654  1.00  0.00           O  
ATOM    871  OE2 GLU A  54      44.906  55.101  -3.458  1.00  0.00           O  
ATOM    872  H   GLU A  54      46.365  59.685  -1.660  1.00  0.00           H  
ATOM    873  HA  GLU A  54      46.804  59.655  -4.558  1.00  0.00           H  
ATOM    874  HB2 GLU A  54      44.294  59.009  -2.999  1.00  0.00           H  
ATOM    875  HB3 GLU A  54      44.551  58.740  -4.717  1.00  0.00           H  
ATOM    876  HG2 GLU A  54      46.363  57.157  -4.174  1.00  0.00           H  
ATOM    877  HG3 GLU A  54      46.015  57.383  -2.460  1.00  0.00           H  
ATOM    878  N   THR A  55      45.165  61.529  -5.267  1.00  0.00           N  
ATOM    879  CA  THR A  55      44.551  62.809  -5.594  1.00  0.00           C  
ATOM    880  C   THR A  55      43.319  62.638  -6.470  1.00  0.00           C  
ATOM    881  O   THR A  55      43.228  61.709  -7.272  1.00  0.00           O  
ATOM    882  CB  THR A  55      45.569  63.743  -6.254  1.00  0.00           C  
ATOM    883  OG1 THR A  55      45.160  65.093  -6.136  1.00  0.00           O  
ATOM    884  CG2 THR A  55      45.785  63.458  -7.717  1.00  0.00           C  
ATOM    885  H   THR A  55      45.355  60.888  -5.984  1.00  0.00           H  
ATOM    886  HA  THR A  55      44.235  63.255  -4.673  1.00  0.00           H  
ATOM    887  HB  THR A  55      46.519  63.632  -5.752  1.00  0.00           H  
ATOM    888  HG1 THR A  55      45.867  65.670  -6.437  1.00  0.00           H  
ATOM    889 HG21 THR A  55      45.248  62.564  -7.988  1.00  0.00           H  
ATOM    890 HG22 THR A  55      46.840  63.318  -7.902  1.00  0.00           H  
ATOM    891 HG23 THR A  55      45.422  64.291  -8.300  1.00  0.00           H  
ATOM    892  N   ALA A  56      42.372  63.549  -6.298  1.00  0.00           N  
ATOM    893  CA  ALA A  56      41.132  63.512  -7.060  1.00  0.00           C  
ATOM    894  C   ALA A  56      40.492  64.892  -7.159  1.00  0.00           C  
ATOM    895  O   ALA A  56      40.924  65.834  -6.495  1.00  0.00           O  
ATOM    896  CB  ALA A  56      40.174  62.521  -6.426  1.00  0.00           C  
ATOM    897  H   ALA A  56      42.521  64.259  -5.634  1.00  0.00           H  
ATOM    898  HA  ALA A  56      41.362  63.163  -8.058  1.00  0.00           H  
ATOM    899  HB1 ALA A  56      39.408  62.250  -7.136  1.00  0.00           H  
ATOM    900  HB2 ALA A  56      39.718  62.972  -5.555  1.00  0.00           H  
ATOM    901  HB3 ALA A  56      40.721  61.639  -6.128  1.00  0.00           H  
ATOM    902  N   PHE A  57      39.457  65.009  -7.991  1.00  0.00           N  
ATOM    903  CA  PHE A  57      38.759  66.273  -8.170  1.00  0.00           C  
ATOM    904  C   PHE A  57      37.378  66.225  -7.521  1.00  0.00           C  
ATOM    905  O   PHE A  57      36.568  65.349  -7.828  1.00  0.00           O  
ATOM    906  CB  PHE A  57      38.622  66.601  -9.659  1.00  0.00           C  
ATOM    907  CG  PHE A  57      39.928  66.909 -10.334  1.00  0.00           C  
ATOM    908  CD1 PHE A  57      40.943  65.965 -10.381  1.00  0.00           C  
ATOM    909  CD2 PHE A  57      40.140  68.143 -10.928  1.00  0.00           C  
ATOM    910  CE1 PHE A  57      42.141  66.246 -11.007  1.00  0.00           C  
ATOM    911  CE2 PHE A  57      41.338  68.430 -11.555  1.00  0.00           C  
ATOM    912  CZ  PHE A  57      42.340  67.480 -11.594  1.00  0.00           C  
ATOM    913  H   PHE A  57      39.150  64.226  -8.495  1.00  0.00           H  
ATOM    914  HA  PHE A  57      39.341  67.042  -7.692  1.00  0.00           H  
ATOM    915  HB2 PHE A  57      38.178  65.759 -10.165  1.00  0.00           H  
ATOM    916  HB3 PHE A  57      37.978  67.461  -9.771  1.00  0.00           H  
ATOM    917  HD1 PHE A  57      40.788  64.999  -9.922  1.00  0.00           H  
ATOM    918  HD2 PHE A  57      39.357  68.887 -10.899  1.00  0.00           H  
ATOM    919  HE1 PHE A  57      42.925  65.502 -11.035  1.00  0.00           H  
ATOM    920  HE2 PHE A  57      41.490  69.397 -12.014  1.00  0.00           H  
ATOM    921  HZ  PHE A  57      43.276  67.703 -12.085  1.00  0.00           H  
ATOM    922  N   LEU A  58      37.115  67.166  -6.623  1.00  0.00           N  
ATOM    923  CA  LEU A  58      35.831  67.220  -5.935  1.00  0.00           C  
ATOM    924  C   LEU A  58      35.334  68.655  -5.818  1.00  0.00           C  
ATOM    925  O   LEU A  58      36.105  69.602  -5.962  1.00  0.00           O  
ATOM    926  CB  LEU A  58      35.950  66.599  -4.542  1.00  0.00           C  
ATOM    927  CG  LEU A  58      36.516  65.178  -4.510  1.00  0.00           C  
ATOM    928  CD1 LEU A  58      36.896  64.786  -3.090  1.00  0.00           C  
ATOM    929  CD2 LEU A  58      35.509  64.194  -5.086  1.00  0.00           C  
ATOM    930  H   LEU A  58      37.799  67.836  -6.416  1.00  0.00           H  
ATOM    931  HA  LEU A  58      35.123  66.649  -6.513  1.00  0.00           H  
ATOM    932  HB2 LEU A  58      36.588  67.232  -3.942  1.00  0.00           H  
ATOM    933  HB3 LEU A  58      34.969  66.581  -4.093  1.00  0.00           H  
ATOM    934  HG  LEU A  58      37.409  65.139  -5.117  1.00  0.00           H  
ATOM    935 HD11 LEU A  58      36.697  63.736  -2.941  1.00  0.00           H  
ATOM    936 HD12 LEU A  58      36.315  65.366  -2.388  1.00  0.00           H  
ATOM    937 HD13 LEU A  58      37.947  64.979  -2.933  1.00  0.00           H  
ATOM    938 HD21 LEU A  58      34.510  64.588  -4.969  1.00  0.00           H  
ATOM    939 HD22 LEU A  58      35.587  63.251  -4.565  1.00  0.00           H  
ATOM    940 HD23 LEU A  58      35.715  64.041  -6.136  1.00  0.00           H  
ATOM    941  N   GLY A  59      34.038  68.811  -5.561  1.00  0.00           N  
ATOM    942  CA  GLY A  59      33.464  70.136  -5.430  1.00  0.00           C  
ATOM    943  C   GLY A  59      33.506  70.641  -4.000  1.00  0.00           C  
ATOM    944  O   GLY A  59      33.922  69.914  -3.098  1.00  0.00           O  
ATOM    945  H   GLY A  59      33.469  68.021  -5.459  1.00  0.00           H  
ATOM    946  HA2 GLY A  59      34.015  70.821  -6.058  1.00  0.00           H  
ATOM    947  HA3 GLY A  59      32.437  70.108  -5.761  1.00  0.00           H  
ATOM    948  N   PRO A  60      33.073  71.890  -3.755  1.00  0.00           N  
ATOM    949  CA  PRO A  60      33.071  72.466  -2.413  1.00  0.00           C  
ATOM    950  C   PRO A  60      32.033  71.805  -1.513  1.00  0.00           C  
ATOM    951  O   PRO A  60      32.178  71.789  -0.291  1.00  0.00           O  
ATOM    952  CB  PRO A  60      32.725  73.947  -2.637  1.00  0.00           C  
ATOM    953  CG  PRO A  60      32.790  74.165  -4.113  1.00  0.00           C  
ATOM    954  CD  PRO A  60      32.552  72.829  -4.754  1.00  0.00           C  
ATOM    955  HA  PRO A  60      34.047  72.386  -1.953  1.00  0.00           H  
ATOM    956  HB2 PRO A  60      31.736  74.147  -2.254  1.00  0.00           H  
ATOM    957  HB3 PRO A  60      33.446  74.562  -2.120  1.00  0.00           H  
ATOM    958  HG2 PRO A  60      32.022  74.864  -4.412  1.00  0.00           H  
ATOM    959  HG3 PRO A  60      33.765  74.543  -4.386  1.00  0.00           H  
ATOM    960  HD2 PRO A  60      31.497  72.671  -4.921  1.00  0.00           H  
ATOM    961  HD3 PRO A  60      33.099  72.750  -5.680  1.00  0.00           H  
ATOM    962  N   LYS A  61      30.992  71.249  -2.127  1.00  0.00           N  
ATOM    963  CA  LYS A  61      29.938  70.575  -1.382  1.00  0.00           C  
ATOM    964  C   LYS A  61      30.461  69.281  -0.761  1.00  0.00           C  
ATOM    965  O   LYS A  61      29.899  68.776   0.211  1.00  0.00           O  
ATOM    966  CB  LYS A  61      28.749  70.279  -2.296  1.00  0.00           C  
ATOM    967  CG  LYS A  61      28.237  71.506  -3.037  1.00  0.00           C  
ATOM    968  CD  LYS A  61      26.718  71.549  -3.069  1.00  0.00           C  
ATOM    969  CE  LYS A  61      26.203  72.126  -4.379  1.00  0.00           C  
ATOM    970  NZ  LYS A  61      25.595  73.473  -4.196  1.00  0.00           N  
ATOM    971  H   LYS A  61      30.934  71.283  -3.104  1.00  0.00           H  
ATOM    972  HA  LYS A  61      29.618  71.235  -0.590  1.00  0.00           H  
ATOM    973  HB2 LYS A  61      29.047  69.542  -3.028  1.00  0.00           H  
ATOM    974  HB3 LYS A  61      27.940  69.881  -1.702  1.00  0.00           H  
ATOM    975  HG2 LYS A  61      28.602  72.393  -2.540  1.00  0.00           H  
ATOM    976  HG3 LYS A  61      28.609  71.483  -4.051  1.00  0.00           H  
ATOM    977  HD2 LYS A  61      26.335  70.548  -2.952  1.00  0.00           H  
ATOM    978  HD3 LYS A  61      26.369  72.167  -2.252  1.00  0.00           H  
ATOM    979  HE2 LYS A  61      27.027  72.206  -5.072  1.00  0.00           H  
ATOM    980  HE3 LYS A  61      25.457  71.457  -4.783  1.00  0.00           H  
ATOM    981  HZ1 LYS A  61      26.278  74.213  -4.459  1.00  0.00           H  
ATOM    982  HZ2 LYS A  61      25.320  73.609  -3.202  1.00  0.00           H  
ATOM    983  HZ3 LYS A  61      24.749  73.568  -4.792  1.00  0.00           H  
ATOM    984  N   ASP A  62      31.543  68.753  -1.330  1.00  0.00           N  
ATOM    985  CA  ASP A  62      32.144  67.522  -0.831  1.00  0.00           C  
ATOM    986  C   ASP A  62      33.365  67.823   0.038  1.00  0.00           C  
ATOM    987  O   ASP A  62      34.030  66.909   0.524  1.00  0.00           O  
ATOM    988  CB  ASP A  62      32.540  66.614  -1.996  1.00  0.00           C  
ATOM    989  CG  ASP A  62      31.343  66.150  -2.801  1.00  0.00           C  
ATOM    990  OD1 ASP A  62      30.340  66.894  -2.858  1.00  0.00           O  
ATOM    991  OD2 ASP A  62      31.406  65.042  -3.374  1.00  0.00           O  
ATOM    992  H   ASP A  62      31.947  69.204  -2.102  1.00  0.00           H  
ATOM    993  HA  ASP A  62      31.405  67.016  -0.227  1.00  0.00           H  
ATOM    994  HB2 ASP A  62      33.206  67.153  -2.654  1.00  0.00           H  
ATOM    995  HB3 ASP A  62      33.049  65.745  -1.609  1.00  0.00           H  
ATOM    996  N   LEU A  63      33.653  69.108   0.236  1.00  0.00           N  
ATOM    997  CA  LEU A  63      34.784  69.523   1.055  1.00  0.00           C  
ATOM    998  C   LEU A  63      34.295  70.173   2.343  1.00  0.00           C  
ATOM    999  O   LEU A  63      33.327  70.935   2.332  1.00  0.00           O  
ATOM   1000  CB  LEU A  63      35.674  70.500   0.283  1.00  0.00           C  
ATOM   1001  CG  LEU A  63      36.282  69.948  -1.008  1.00  0.00           C  
ATOM   1002  CD1 LEU A  63      36.790  71.081  -1.884  1.00  0.00           C  
ATOM   1003  CD2 LEU A  63      37.404  68.971  -0.694  1.00  0.00           C  
ATOM   1004  H   LEU A  63      33.085  69.794  -0.171  1.00  0.00           H  
ATOM   1005  HA  LEU A  63      35.356  68.642   1.302  1.00  0.00           H  
ATOM   1006  HB2 LEU A  63      35.084  71.371   0.035  1.00  0.00           H  
ATOM   1007  HB3 LEU A  63      36.482  70.807   0.930  1.00  0.00           H  
ATOM   1008  HG  LEU A  63      35.519  69.418  -1.558  1.00  0.00           H  
ATOM   1009 HD11 LEU A  63      37.700  71.482  -1.461  1.00  0.00           H  
ATOM   1010 HD12 LEU A  63      36.045  71.859  -1.937  1.00  0.00           H  
ATOM   1011 HD13 LEU A  63      36.991  70.707  -2.877  1.00  0.00           H  
ATOM   1012 HD21 LEU A  63      38.332  69.512  -0.584  1.00  0.00           H  
ATOM   1013 HD22 LEU A  63      37.495  68.257  -1.498  1.00  0.00           H  
ATOM   1014 HD23 LEU A  63      37.179  68.449   0.227  1.00  0.00           H  
ATOM   1015  N   PHE A  64      34.959  69.866   3.452  1.00  0.00           N  
ATOM   1016  CA  PHE A  64      34.583  70.421   4.750  1.00  0.00           C  
ATOM   1017  C   PHE A  64      35.816  70.864   5.537  1.00  0.00           C  
ATOM   1018  O   PHE A  64      36.935  70.433   5.251  1.00  0.00           O  
ATOM   1019  CB  PHE A  64      33.793  69.386   5.558  1.00  0.00           C  
ATOM   1020  CG  PHE A  64      32.638  68.788   4.805  1.00  0.00           C  
ATOM   1021  CD1 PHE A  64      32.860  67.971   3.708  1.00  0.00           C  
ATOM   1022  CD2 PHE A  64      31.332  69.046   5.191  1.00  0.00           C  
ATOM   1023  CE1 PHE A  64      31.799  67.421   3.010  1.00  0.00           C  
ATOM   1024  CE2 PHE A  64      30.269  68.498   4.498  1.00  0.00           C  
ATOM   1025  CZ  PHE A  64      30.504  67.685   3.405  1.00  0.00           C  
ATOM   1026  H   PHE A  64      35.714  69.243   3.402  1.00  0.00           H  
ATOM   1027  HA  PHE A  64      33.953  71.283   4.573  1.00  0.00           H  
ATOM   1028  HB2 PHE A  64      34.454  68.583   5.843  1.00  0.00           H  
ATOM   1029  HB3 PHE A  64      33.403  69.857   6.449  1.00  0.00           H  
ATOM   1030  HD1 PHE A  64      33.873  67.764   3.397  1.00  0.00           H  
ATOM   1031  HD2 PHE A  64      31.149  69.682   6.046  1.00  0.00           H  
ATOM   1032  HE1 PHE A  64      31.987  66.787   2.157  1.00  0.00           H  
ATOM   1033  HE2 PHE A  64      29.255  68.707   4.808  1.00  0.00           H  
ATOM   1034  HZ  PHE A  64      29.677  67.255   2.860  1.00  0.00           H  
ATOM   1035  N   PRO A  65      35.631  71.740   6.542  1.00  0.00           N  
ATOM   1036  CA  PRO A  65      36.733  72.238   7.370  1.00  0.00           C  
ATOM   1037  C   PRO A  65      37.333  71.138   8.242  1.00  0.00           C  
ATOM   1038  O   PRO A  65      36.684  70.633   9.158  1.00  0.00           O  
ATOM   1039  CB  PRO A  65      36.082  73.324   8.240  1.00  0.00           C  
ATOM   1040  CG  PRO A  65      34.756  73.597   7.612  1.00  0.00           C  
ATOM   1041  CD  PRO A  65      34.343  72.314   6.952  1.00  0.00           C  
ATOM   1042  HA  PRO A  65      37.512  72.679   6.764  1.00  0.00           H  
ATOM   1043  HB2 PRO A  65      35.971  72.955   9.248  1.00  0.00           H  
ATOM   1044  HB3 PRO A  65      36.705  74.206   8.242  1.00  0.00           H  
ATOM   1045  HG2 PRO A  65      34.041  73.876   8.370  1.00  0.00           H  
ATOM   1046  HG3 PRO A  65      34.855  74.382   6.876  1.00  0.00           H  
ATOM   1047  HD2 PRO A  65      33.836  71.671   7.656  1.00  0.00           H  
ATOM   1048  HD3 PRO A  65      33.718  72.512   6.095  1.00  0.00           H  
ATOM   1049  N   TYR A  66      38.574  70.773   7.947  1.00  0.00           N  
ATOM   1050  CA  TYR A  66      39.274  69.727   8.686  1.00  0.00           C  
ATOM   1051  C   TYR A  66      39.204  69.942  10.201  1.00  0.00           C  
ATOM   1052  O   TYR A  66      38.662  69.112  10.927  1.00  0.00           O  
ATOM   1053  CB  TYR A  66      40.737  69.665   8.238  1.00  0.00           C  
ATOM   1054  CG  TYR A  66      41.569  68.674   9.018  1.00  0.00           C  
ATOM   1055  CD1 TYR A  66      41.491  67.314   8.754  1.00  0.00           C  
ATOM   1056  CD2 TYR A  66      42.429  69.101  10.021  1.00  0.00           C  
ATOM   1057  CE1 TYR A  66      42.249  66.404   9.468  1.00  0.00           C  
ATOM   1058  CE2 TYR A  66      43.189  68.199  10.739  1.00  0.00           C  
ATOM   1059  CZ  TYR A  66      43.095  66.852  10.459  1.00  0.00           C  
ATOM   1060  OH  TYR A  66      43.850  65.949  11.172  1.00  0.00           O  
ATOM   1061  H   TYR A  66      39.035  71.216   7.203  1.00  0.00           H  
ATOM   1062  HA  TYR A  66      38.802  68.786   8.450  1.00  0.00           H  
ATOM   1063  HB2 TYR A  66      40.775  69.381   7.197  1.00  0.00           H  
ATOM   1064  HB3 TYR A  66      41.184  70.642   8.357  1.00  0.00           H  
ATOM   1065  HD1 TYR A  66      40.826  66.967   7.977  1.00  0.00           H  
ATOM   1066  HD2 TYR A  66      42.500  70.156  10.238  1.00  0.00           H  
ATOM   1067  HE1 TYR A  66      42.174  65.349   9.247  1.00  0.00           H  
ATOM   1068  HE2 TYR A  66      43.851  68.551  11.518  1.00  0.00           H  
ATOM   1069  HH  TYR A  66      44.714  66.325  11.352  1.00  0.00           H  
ATOM   1070  N   GLU A  67      39.752  71.059  10.666  1.00  0.00           N  
ATOM   1071  CA  GLU A  67      39.762  71.364  12.099  1.00  0.00           C  
ATOM   1072  C   GLU A  67      38.364  71.253  12.710  1.00  0.00           C  
ATOM   1073  O   GLU A  67      38.200  70.775  13.832  1.00  0.00           O  
ATOM   1074  CB  GLU A  67      40.333  72.766  12.339  1.00  0.00           C  
ATOM   1075  CG  GLU A  67      41.578  72.773  13.211  1.00  0.00           C  
ATOM   1076  CD  GLU A  67      41.268  73.034  14.672  1.00  0.00           C  
ATOM   1077  OE1 GLU A  67      41.051  74.211  15.031  1.00  0.00           O  
ATOM   1078  OE2 GLU A  67      41.243  72.064  15.457  1.00  0.00           O  
ATOM   1079  H   GLU A  67      40.160  71.689  10.033  1.00  0.00           H  
ATOM   1080  HA  GLU A  67      40.408  70.640  12.581  1.00  0.00           H  
ATOM   1081  HB2 GLU A  67      40.585  73.207  11.386  1.00  0.00           H  
ATOM   1082  HB3 GLU A  67      39.580  73.374  12.820  1.00  0.00           H  
ATOM   1083  HG2 GLU A  67      42.064  71.812  13.129  1.00  0.00           H  
ATOM   1084  HG3 GLU A  67      42.247  73.544  12.855  1.00  0.00           H  
ATOM   1085  N   GLU A  68      37.370  71.707  11.962  1.00  0.00           N  
ATOM   1086  CA  GLU A  68      35.980  71.677  12.406  1.00  0.00           C  
ATOM   1087  C   GLU A  68      35.407  70.259  12.430  1.00  0.00           C  
ATOM   1088  O   GLU A  68      34.641  69.912  13.329  1.00  0.00           O  
ATOM   1089  CB  GLU A  68      35.112  72.580  11.527  1.00  0.00           C  
ATOM   1090  CG  GLU A  68      34.000  73.282  12.290  1.00  0.00           C  
ATOM   1091  CD  GLU A  68      32.638  72.662  12.045  1.00  0.00           C  
ATOM   1092  OE1 GLU A  68      32.025  72.969  11.002  1.00  0.00           O  
ATOM   1093  OE2 GLU A  68      32.184  71.870  12.898  1.00  0.00           O  
ATOM   1094  H   GLU A  68      37.575  72.081  11.079  1.00  0.00           H  
ATOM   1095  HA  GLU A  68      35.959  72.062  13.413  1.00  0.00           H  
ATOM   1096  HB2 GLU A  68      35.741  73.337  11.080  1.00  0.00           H  
ATOM   1097  HB3 GLU A  68      34.665  71.986  10.744  1.00  0.00           H  
ATOM   1098  HG2 GLU A  68      34.217  73.228  13.346  1.00  0.00           H  
ATOM   1099  HG3 GLU A  68      33.967  74.317  11.983  1.00  0.00           H  
ATOM   1100  N   SER A  69      35.757  69.450  11.433  1.00  0.00           N  
ATOM   1101  CA  SER A  69      35.238  68.081  11.354  1.00  0.00           C  
ATOM   1102  C   SER A  69      36.294  67.047  11.734  1.00  0.00           C  
ATOM   1103  O   SER A  69      36.102  65.849  11.533  1.00  0.00           O  
ATOM   1104  CB  SER A  69      34.720  67.793   9.945  1.00  0.00           C  
ATOM   1105  OG  SER A  69      33.501  68.472   9.700  1.00  0.00           O  
ATOM   1106  H   SER A  69      36.378  69.772  10.740  1.00  0.00           H  
ATOM   1107  HA  SER A  69      34.415  68.004  12.048  1.00  0.00           H  
ATOM   1108  HB2 SER A  69      35.451  68.119   9.221  1.00  0.00           H  
ATOM   1109  HB3 SER A  69      34.554  66.730   9.838  1.00  0.00           H  
ATOM   1110  HG  SER A  69      32.768  67.858   9.793  1.00  0.00           H  
ATOM   1111  N   LYS A  70      37.406  67.517  12.280  1.00  0.00           N  
ATOM   1112  CA  LYS A  70      38.497  66.643  12.688  1.00  0.00           C  
ATOM   1113  C   LYS A  70      38.021  65.552  13.647  1.00  0.00           C  
ATOM   1114  O   LYS A  70      38.344  64.378  13.475  1.00  0.00           O  
ATOM   1115  CB  LYS A  70      39.589  67.476  13.352  1.00  0.00           C  
ATOM   1116  CG  LYS A  70      40.993  66.958  13.115  1.00  0.00           C  
ATOM   1117  CD  LYS A  70      41.914  67.332  14.266  1.00  0.00           C  
ATOM   1118  CE  LYS A  70      43.374  67.099  13.920  1.00  0.00           C  
ATOM   1119  NZ  LYS A  70      44.209  66.892  15.136  1.00  0.00           N  
ATOM   1120  H   LYS A  70      37.505  68.483  12.419  1.00  0.00           H  
ATOM   1121  HA  LYS A  70      38.902  66.178  11.803  1.00  0.00           H  
ATOM   1122  HB2 LYS A  70      39.534  68.483  12.966  1.00  0.00           H  
ATOM   1123  HB3 LYS A  70      39.409  67.498  14.415  1.00  0.00           H  
ATOM   1124  HG2 LYS A  70      40.960  65.883  13.024  1.00  0.00           H  
ATOM   1125  HG3 LYS A  70      41.373  67.389  12.203  1.00  0.00           H  
ATOM   1126  HD2 LYS A  70      41.776  68.377  14.498  1.00  0.00           H  
ATOM   1127  HD3 LYS A  70      41.659  66.733  15.128  1.00  0.00           H  
ATOM   1128  HE2 LYS A  70      43.448  66.226  13.292  1.00  0.00           H  
ATOM   1129  HE3 LYS A  70      43.744  67.961  13.382  1.00  0.00           H  
ATOM   1130  HZ1 LYS A  70      43.727  67.282  15.971  1.00  0.00           H  
ATOM   1131  HZ2 LYS A  70      45.126  67.366  15.026  1.00  0.00           H  
ATOM   1132  HZ3 LYS A  70      44.374  65.876  15.287  1.00  0.00           H  
ATOM   1133  N   GLU A  71      37.270  65.952  14.666  1.00  0.00           N  
ATOM   1134  CA  GLU A  71      36.766  65.015  15.667  1.00  0.00           C  
ATOM   1135  C   GLU A  71      35.713  64.072  15.087  1.00  0.00           C  
ATOM   1136  O   GLU A  71      35.563  62.942  15.551  1.00  0.00           O  
ATOM   1137  CB  GLU A  71      36.172  65.780  16.852  1.00  0.00           C  
ATOM   1138  CG  GLU A  71      37.170  66.689  17.555  1.00  0.00           C  
ATOM   1139  CD  GLU A  71      36.759  68.147  17.518  1.00  0.00           C  
ATOM   1140  OE1 GLU A  71      35.810  68.516  18.241  1.00  0.00           O  
ATOM   1141  OE2 GLU A  71      37.385  68.920  16.763  1.00  0.00           O  
ATOM   1142  H   GLU A  71      37.057  66.905  14.756  1.00  0.00           H  
ATOM   1143  HA  GLU A  71      37.600  64.427  16.018  1.00  0.00           H  
ATOM   1144  HB2 GLU A  71      35.352  66.386  16.499  1.00  0.00           H  
ATOM   1145  HB3 GLU A  71      35.796  65.068  17.573  1.00  0.00           H  
ATOM   1146  HG2 GLU A  71      37.252  66.381  18.587  1.00  0.00           H  
ATOM   1147  HG3 GLU A  71      38.131  66.587  17.072  1.00  0.00           H  
ATOM   1148  N   LYS A  72      34.974  64.539  14.086  1.00  0.00           N  
ATOM   1149  CA  LYS A  72      33.921  63.733  13.470  1.00  0.00           C  
ATOM   1150  C   LYS A  72      34.469  62.794  12.401  1.00  0.00           C  
ATOM   1151  O   LYS A  72      34.097  61.624  12.343  1.00  0.00           O  
ATOM   1152  CB  LYS A  72      32.861  64.642  12.850  1.00  0.00           C  
ATOM   1153  CG  LYS A  72      32.142  65.511  13.865  1.00  0.00           C  
ATOM   1154  CD  LYS A  72      31.753  66.859  13.276  1.00  0.00           C  
ATOM   1155  CE  LYS A  72      30.242  67.018  13.198  1.00  0.00           C  
ATOM   1156  NZ  LYS A  72      29.581  66.730  14.501  1.00  0.00           N  
ATOM   1157  H   LYS A  72      35.126  65.451  13.763  1.00  0.00           H  
ATOM   1158  HA  LYS A  72      33.460  63.142  14.247  1.00  0.00           H  
ATOM   1159  HB2 LYS A  72      33.333  65.288  12.126  1.00  0.00           H  
ATOM   1160  HB3 LYS A  72      32.126  64.029  12.348  1.00  0.00           H  
ATOM   1161  HG2 LYS A  72      31.250  65.000  14.191  1.00  0.00           H  
ATOM   1162  HG3 LYS A  72      32.797  65.674  14.708  1.00  0.00           H  
ATOM   1163  HD2 LYS A  72      32.153  67.642  13.901  1.00  0.00           H  
ATOM   1164  HD3 LYS A  72      32.165  66.941  12.281  1.00  0.00           H  
ATOM   1165  HE2 LYS A  72      30.014  68.032  12.906  1.00  0.00           H  
ATOM   1166  HE3 LYS A  72      29.860  66.335  12.453  1.00  0.00           H  
ATOM   1167  HZ1 LYS A  72      30.292  66.654  15.256  1.00  0.00           H  
ATOM   1168  HZ2 LYS A  72      29.055  65.835  14.447  1.00  0.00           H  
ATOM   1169  HZ3 LYS A  72      28.917  67.494  14.742  1.00  0.00           H  
ATOM   1170  N   PHE A  73      35.323  63.323  11.537  1.00  0.00           N  
ATOM   1171  CA  PHE A  73      35.883  62.535  10.441  1.00  0.00           C  
ATOM   1172  C   PHE A  73      37.275  61.994  10.756  1.00  0.00           C  
ATOM   1173  O   PHE A  73      37.785  61.139  10.033  1.00  0.00           O  
ATOM   1174  CB  PHE A  73      35.933  63.384   9.169  1.00  0.00           C  
ATOM   1175  CG  PHE A  73      34.635  64.084   8.844  1.00  0.00           C  
ATOM   1176  CD1 PHE A  73      33.445  63.707   9.452  1.00  0.00           C  
ATOM   1177  CD2 PHE A  73      34.610  65.120   7.926  1.00  0.00           C  
ATOM   1178  CE1 PHE A  73      32.261  64.351   9.150  1.00  0.00           C  
ATOM   1179  CE2 PHE A  73      33.427  65.768   7.619  1.00  0.00           C  
ATOM   1180  CZ  PHE A  73      32.252  65.383   8.232  1.00  0.00           C  
ATOM   1181  H   PHE A  73      35.561  64.272  11.616  1.00  0.00           H  
ATOM   1182  HA  PHE A  73      35.221  61.698  10.266  1.00  0.00           H  
ATOM   1183  HB2 PHE A  73      36.694  64.141   9.283  1.00  0.00           H  
ATOM   1184  HB3 PHE A  73      36.188  62.751   8.334  1.00  0.00           H  
ATOM   1185  HD1 PHE A  73      33.448  62.900  10.169  1.00  0.00           H  
ATOM   1186  HD2 PHE A  73      35.528  65.423   7.445  1.00  0.00           H  
ATOM   1187  HE1 PHE A  73      31.343  64.049   9.633  1.00  0.00           H  
ATOM   1188  HE2 PHE A  73      33.424  66.575   6.902  1.00  0.00           H  
ATOM   1189  HZ  PHE A  73      31.328  65.888   7.995  1.00  0.00           H  
ATOM   1190  N   GLY A  74      37.893  62.487  11.822  1.00  0.00           N  
ATOM   1191  CA  GLY A  74      39.222  62.024  12.174  1.00  0.00           C  
ATOM   1192  C   GLY A  74      39.209  60.754  13.003  1.00  0.00           C  
ATOM   1193  O   GLY A  74      39.485  60.788  14.203  1.00  0.00           O  
ATOM   1194  H   GLY A  74      37.454  63.169  12.370  1.00  0.00           H  
ATOM   1195  HA2 GLY A  74      39.777  61.838  11.266  1.00  0.00           H  
ATOM   1196  HA3 GLY A  74      39.722  62.799  12.735  1.00  0.00           H  
ATOM   1197  N   LYS A  75      38.889  59.628  12.368  1.00  0.00           N  
ATOM   1198  CA  LYS A  75      38.845  58.346  13.060  1.00  0.00           C  
ATOM   1199  C   LYS A  75      39.175  57.205  12.098  1.00  0.00           C  
ATOM   1200  O   LYS A  75      38.795  57.242  10.929  1.00  0.00           O  
ATOM   1201  CB  LYS A  75      37.462  58.121  13.677  1.00  0.00           C  
ATOM   1202  CG  LYS A  75      37.163  59.034  14.853  1.00  0.00           C  
ATOM   1203  CD  LYS A  75      36.331  58.328  15.915  1.00  0.00           C  
ATOM   1204  CE  LYS A  75      35.112  59.148  16.315  1.00  0.00           C  
ATOM   1205  NZ  LYS A  75      33.839  58.412  16.071  1.00  0.00           N  
ATOM   1206  H   LYS A  75      38.674  59.654  11.413  1.00  0.00           H  
ATOM   1207  HA  LYS A  75      39.584  58.367  13.846  1.00  0.00           H  
ATOM   1208  HB2 LYS A  75      36.713  58.288  12.918  1.00  0.00           H  
ATOM   1209  HB3 LYS A  75      37.396  57.099  14.016  1.00  0.00           H  
ATOM   1210  HG2 LYS A  75      38.095  59.352  15.296  1.00  0.00           H  
ATOM   1211  HG3 LYS A  75      36.620  59.897  14.496  1.00  0.00           H  
ATOM   1212  HD2 LYS A  75      35.998  57.377  15.524  1.00  0.00           H  
ATOM   1213  HD3 LYS A  75      36.944  58.164  16.788  1.00  0.00           H  
ATOM   1214  HE2 LYS A  75      35.183  59.385  17.366  1.00  0.00           H  
ATOM   1215  HE3 LYS A  75      35.104  60.064  15.741  1.00  0.00           H  
ATOM   1216  HZ1 LYS A  75      34.033  57.402  15.915  1.00  0.00           H  
ATOM   1217  HZ2 LYS A  75      33.358  58.797  15.233  1.00  0.00           H  
ATOM   1218  HZ3 LYS A  75      33.209  58.509  16.892  1.00  0.00           H  
ATOM   1219  N   PRO A  76      39.889  56.170  12.576  1.00  0.00           N  
ATOM   1220  CA  PRO A  76      40.267  55.022  11.744  1.00  0.00           C  
ATOM   1221  C   PRO A  76      39.093  54.459  10.945  1.00  0.00           C  
ATOM   1222  O   PRO A  76      37.931  54.682  11.287  1.00  0.00           O  
ATOM   1223  CB  PRO A  76      40.765  53.998  12.764  1.00  0.00           C  
ATOM   1224  CG  PRO A  76      41.261  54.815  13.907  1.00  0.00           C  
ATOM   1225  CD  PRO A  76      40.385  56.039  13.960  1.00  0.00           C  
ATOM   1226  HA  PRO A  76      41.069  55.278  11.066  1.00  0.00           H  
ATOM   1227  HB2 PRO A  76      39.949  53.355  13.061  1.00  0.00           H  
ATOM   1228  HB3 PRO A  76      41.557  53.408  12.329  1.00  0.00           H  
ATOM   1229  HG2 PRO A  76      41.173  54.254  14.825  1.00  0.00           H  
ATOM   1230  HG3 PRO A  76      42.289  55.098  13.738  1.00  0.00           H  
ATOM   1231  HD2 PRO A  76      39.568  55.889  14.648  1.00  0.00           H  
ATOM   1232  HD3 PRO A  76      40.965  56.905  14.244  1.00  0.00           H  
ATOM   1233  N   ASN A  77      39.407  53.741   9.868  1.00  0.00           N  
ATOM   1234  CA  ASN A  77      38.371  53.166   9.016  1.00  0.00           C  
ATOM   1235  C   ASN A  77      38.718  51.748   8.574  1.00  0.00           C  
ATOM   1236  O   ASN A  77      39.821  51.260   8.813  1.00  0.00           O  
ATOM   1237  CB  ASN A  77      38.143  54.055   7.791  1.00  0.00           C  
ATOM   1238  CG  ASN A  77      36.736  54.614   7.737  1.00  0.00           C  
ATOM   1239  OD1 ASN A  77      35.801  53.931   7.315  1.00  0.00           O  
ATOM   1240  ND2 ASN A  77      36.577  55.860   8.166  1.00  0.00           N  
ATOM   1241  H   ASN A  77      40.355  53.617   9.643  1.00  0.00           H  
ATOM   1242  HA  ASN A  77      37.459  53.132   9.590  1.00  0.00           H  
ATOM   1243  HB2 ASN A  77      38.837  54.883   7.821  1.00  0.00           H  
ATOM   1244  HB3 ASN A  77      38.318  53.479   6.894  1.00  0.00           H  
ATOM   1245 HD21 ASN A  77      37.367  56.342   8.489  1.00  0.00           H  
ATOM   1246 HD22 ASN A  77      35.677  56.247   8.145  1.00  0.00           H  
ATOM   1247  N   LYS A  78      37.752  51.094   7.932  1.00  0.00           N  
ATOM   1248  CA  LYS A  78      37.930  49.728   7.455  1.00  0.00           C  
ATOM   1249  C   LYS A  78      38.550  49.702   6.059  1.00  0.00           C  
ATOM   1250  O   LYS A  78      39.067  48.673   5.622  1.00  0.00           O  
ATOM   1251  CB  LYS A  78      36.588  48.995   7.439  1.00  0.00           C  
ATOM   1252  CG  LYS A  78      36.030  48.713   8.825  1.00  0.00           C  
ATOM   1253  CD  LYS A  78      36.548  47.395   9.376  1.00  0.00           C  
ATOM   1254  CE  LYS A  78      36.758  47.463  10.882  1.00  0.00           C  
ATOM   1255  NZ  LYS A  78      37.028  46.121  11.467  1.00  0.00           N  
ATOM   1256  H   LYS A  78      36.893  51.543   7.780  1.00  0.00           H  
ATOM   1257  HA  LYS A  78      38.594  49.223   8.138  1.00  0.00           H  
ATOM   1258  HB2 LYS A  78      35.868  49.597   6.901  1.00  0.00           H  
ATOM   1259  HB3 LYS A  78      36.711  48.053   6.924  1.00  0.00           H  
ATOM   1260  HG2 LYS A  78      36.325  49.511   9.490  1.00  0.00           H  
ATOM   1261  HG3 LYS A  78      34.952  48.670   8.766  1.00  0.00           H  
ATOM   1262  HD2 LYS A  78      35.831  46.618   9.159  1.00  0.00           H  
ATOM   1263  HD3 LYS A  78      37.489  47.162   8.902  1.00  0.00           H  
ATOM   1264  HE2 LYS A  78      37.597  48.111  11.086  1.00  0.00           H  
ATOM   1265  HE3 LYS A  78      35.868  47.873  11.337  1.00  0.00           H  
ATOM   1266  HZ1 LYS A  78      37.498  45.512  10.766  1.00  0.00           H  
ATOM   1267  HZ2 LYS A  78      36.136  45.671  11.757  1.00  0.00           H  
ATOM   1268  HZ3 LYS A  78      37.644  46.212  12.301  1.00  0.00           H  
ATOM   1269  N   ARG A  79      38.509  50.838   5.365  1.00  0.00           N  
ATOM   1270  CA  ARG A  79      39.086  50.927   4.029  1.00  0.00           C  
ATOM   1271  C   ARG A  79      40.598  50.772   4.091  1.00  0.00           C  
ATOM   1272  O   ARG A  79      41.256  50.574   3.071  1.00  0.00           O  
ATOM   1273  CB  ARG A  79      38.726  52.261   3.373  1.00  0.00           C  
ATOM   1274  CG  ARG A  79      37.239  52.575   3.411  1.00  0.00           C  
ATOM   1275  CD  ARG A  79      36.599  52.438   2.039  1.00  0.00           C  
ATOM   1276  NE  ARG A  79      35.351  51.680   2.090  1.00  0.00           N  
ATOM   1277  CZ  ARG A  79      35.264  50.367   1.881  1.00  0.00           C  
ATOM   1278  NH1 ARG A  79      36.351  49.652   1.613  1.00  0.00           N  
ATOM   1279  NH2 ARG A  79      34.085  49.764   1.946  1.00  0.00           N  
ATOM   1280  H   ARG A  79      38.100  51.635   5.761  1.00  0.00           H  
ATOM   1281  HA  ARG A  79      38.679  50.121   3.440  1.00  0.00           H  
ATOM   1282  HB2 ARG A  79      39.254  53.052   3.883  1.00  0.00           H  
ATOM   1283  HB3 ARG A  79      39.041  52.236   2.341  1.00  0.00           H  
ATOM   1284  HG2 ARG A  79      36.755  51.892   4.092  1.00  0.00           H  
ATOM   1285  HG3 ARG A  79      37.106  53.589   3.761  1.00  0.00           H  
ATOM   1286  HD2 ARG A  79      36.394  53.425   1.653  1.00  0.00           H  
ATOM   1287  HD3 ARG A  79      37.290  51.934   1.380  1.00  0.00           H  
ATOM   1288  HE  ARG A  79      34.529  52.177   2.289  1.00  0.00           H  
ATOM   1289 HH11 ARG A  79      37.245  50.097   1.565  1.00  0.00           H  
ATOM   1290 HH12 ARG A  79      36.275  48.668   1.457  1.00  0.00           H  
ATOM   1291 HH21 ARG A  79      33.263  50.293   2.151  1.00  0.00           H  
ATOM   1292 HH22 ARG A  79      34.020  48.777   1.790  1.00  0.00           H  
ATOM   1293  N   LYS A  80      41.140  50.878   5.298  1.00  0.00           N  
ATOM   1294  CA  LYS A  80      42.571  50.765   5.513  1.00  0.00           C  
ATOM   1295  C   LYS A  80      43.298  51.930   4.860  1.00  0.00           C  
ATOM   1296  O   LYS A  80      42.924  52.384   3.780  1.00  0.00           O  
ATOM   1297  CB  LYS A  80      43.093  49.427   4.985  1.00  0.00           C  
ATOM   1298  CG  LYS A  80      42.479  48.216   5.679  1.00  0.00           C  
ATOM   1299  CD  LYS A  80      42.281  48.456   7.171  1.00  0.00           C  
ATOM   1300  CE  LYS A  80      41.640  47.255   7.851  1.00  0.00           C  
ATOM   1301  NZ  LYS A  80      40.398  47.630   8.581  1.00  0.00           N  
ATOM   1302  H   LYS A  80      40.559  51.046   6.067  1.00  0.00           H  
ATOM   1303  HA  LYS A  80      42.744  50.809   6.578  1.00  0.00           H  
ATOM   1304  HB2 LYS A  80      42.876  49.358   3.930  1.00  0.00           H  
ATOM   1305  HB3 LYS A  80      44.163  49.391   5.128  1.00  0.00           H  
ATOM   1306  HG2 LYS A  80      41.520  48.007   5.229  1.00  0.00           H  
ATOM   1307  HG3 LYS A  80      43.133  47.368   5.543  1.00  0.00           H  
ATOM   1308  HD2 LYS A  80      43.241  48.644   7.627  1.00  0.00           H  
ATOM   1309  HD3 LYS A  80      41.640  49.319   7.308  1.00  0.00           H  
ATOM   1310  HE2 LYS A  80      41.397  46.517   7.100  1.00  0.00           H  
ATOM   1311  HE3 LYS A  80      42.347  46.835   8.553  1.00  0.00           H  
ATOM   1312  HZ1 LYS A  80      39.564  47.434   7.991  1.00  0.00           H  
ATOM   1313  HZ2 LYS A  80      40.413  48.644   8.813  1.00  0.00           H  
ATOM   1314  HZ3 LYS A  80      40.323  47.084   9.463  1.00  0.00           H  
ATOM   1315  N   GLY A  81      44.322  52.422   5.536  1.00  0.00           N  
ATOM   1316  CA  GLY A  81      45.069  53.549   5.021  1.00  0.00           C  
ATOM   1317  C   GLY A  81      44.506  54.872   5.508  1.00  0.00           C  
ATOM   1318  O   GLY A  81      45.180  55.900   5.448  1.00  0.00           O  
ATOM   1319  H   GLY A  81      44.560  52.022   6.401  1.00  0.00           H  
ATOM   1320  HA2 GLY A  81      46.096  53.466   5.342  1.00  0.00           H  
ATOM   1321  HA3 GLY A  81      45.033  53.531   3.942  1.00  0.00           H  
ATOM   1322  N   PHE A  82      43.265  54.846   6.007  1.00  0.00           N  
ATOM   1323  CA  PHE A  82      42.617  56.049   6.512  1.00  0.00           C  
ATOM   1324  C   PHE A  82      43.422  56.649   7.660  1.00  0.00           C  
ATOM   1325  O   PHE A  82      43.779  57.827   7.634  1.00  0.00           O  
ATOM   1326  CB  PHE A  82      41.202  55.720   6.989  1.00  0.00           C  
ATOM   1327  CG  PHE A  82      40.395  56.936   7.331  1.00  0.00           C  
ATOM   1328  CD1 PHE A  82      40.533  57.547   8.567  1.00  0.00           C  
ATOM   1329  CD2 PHE A  82      39.506  57.472   6.415  1.00  0.00           C  
ATOM   1330  CE1 PHE A  82      39.799  58.672   8.882  1.00  0.00           C  
ATOM   1331  CE2 PHE A  82      38.767  58.598   6.726  1.00  0.00           C  
ATOM   1332  CZ  PHE A  82      38.914  59.200   7.962  1.00  0.00           C  
ATOM   1333  H   PHE A  82      42.774  53.996   6.036  1.00  0.00           H  
ATOM   1334  HA  PHE A  82      42.557  56.768   5.705  1.00  0.00           H  
ATOM   1335  HB2 PHE A  82      40.681  55.184   6.209  1.00  0.00           H  
ATOM   1336  HB3 PHE A  82      41.261  55.097   7.869  1.00  0.00           H  
ATOM   1337  HD1 PHE A  82      41.225  57.135   9.286  1.00  0.00           H  
ATOM   1338  HD2 PHE A  82      39.390  57.003   5.451  1.00  0.00           H  
ATOM   1339  HE1 PHE A  82      39.915  59.138   9.850  1.00  0.00           H  
ATOM   1340  HE2 PHE A  82      38.077  59.007   6.004  1.00  0.00           H  
ATOM   1341  HZ  PHE A  82      38.338  60.079   8.205  1.00  0.00           H  
ATOM   1342  N   SER A  83      43.704  55.825   8.664  1.00  0.00           N  
ATOM   1343  CA  SER A  83      44.467  56.266   9.825  1.00  0.00           C  
ATOM   1344  C   SER A  83      45.789  56.896   9.403  1.00  0.00           C  
ATOM   1345  O   SER A  83      46.152  57.971   9.876  1.00  0.00           O  
ATOM   1346  CB  SER A  83      44.732  55.093  10.768  1.00  0.00           C  
ATOM   1347  OG  SER A  83      44.664  53.856  10.079  1.00  0.00           O  
ATOM   1348  H   SER A  83      43.390  54.897   8.622  1.00  0.00           H  
ATOM   1349  HA  SER A  83      43.880  57.007  10.346  1.00  0.00           H  
ATOM   1350  HB2 SER A  83      45.716  55.198  11.199  1.00  0.00           H  
ATOM   1351  HB3 SER A  83      43.993  55.094  11.555  1.00  0.00           H  
ATOM   1352  HG  SER A  83      44.861  53.140  10.686  1.00  0.00           H  
ATOM   1353  N   GLU A  84      46.504  56.224   8.502  1.00  0.00           N  
ATOM   1354  CA  GLU A  84      47.781  56.730   8.010  1.00  0.00           C  
ATOM   1355  C   GLU A  84      47.648  58.191   7.593  1.00  0.00           C  
ATOM   1356  O   GLU A  84      48.594  58.970   7.706  1.00  0.00           O  
ATOM   1357  CB  GLU A  84      48.268  55.891   6.828  1.00  0.00           C  
ATOM   1358  CG  GLU A  84      49.778  55.908   6.651  1.00  0.00           C  
ATOM   1359  CD  GLU A  84      50.428  54.605   7.074  1.00  0.00           C  
ATOM   1360  OE1 GLU A  84      49.849  53.535   6.795  1.00  0.00           O  
ATOM   1361  OE2 GLU A  84      51.516  54.654   7.686  1.00  0.00           O  
ATOM   1362  H   GLU A  84      46.159  55.376   8.154  1.00  0.00           H  
ATOM   1363  HA  GLU A  84      48.499  56.660   8.813  1.00  0.00           H  
ATOM   1364  HB2 GLU A  84      47.956  54.867   6.976  1.00  0.00           H  
ATOM   1365  HB3 GLU A  84      47.817  56.269   5.924  1.00  0.00           H  
ATOM   1366  HG2 GLU A  84      50.004  56.084   5.611  1.00  0.00           H  
ATOM   1367  HG3 GLU A  84      50.189  56.709   7.248  1.00  0.00           H  
ATOM   1368  N   GLY A  85      46.459  58.553   7.122  1.00  0.00           N  
ATOM   1369  CA  GLY A  85      46.218  59.920   6.711  1.00  0.00           C  
ATOM   1370  C   GLY A  85      46.130  60.858   7.897  1.00  0.00           C  
ATOM   1371  O   GLY A  85      46.517  62.022   7.809  1.00  0.00           O  
ATOM   1372  H   GLY A  85      45.739  57.894   7.061  1.00  0.00           H  
ATOM   1373  HA2 GLY A  85      47.024  60.240   6.068  1.00  0.00           H  
ATOM   1374  HA3 GLY A  85      45.290  59.963   6.159  1.00  0.00           H  
ATOM   1375  N   LEU A  86      45.623  60.345   9.016  1.00  0.00           N  
ATOM   1376  CA  LEU A  86      45.492  61.144  10.227  1.00  0.00           C  
ATOM   1377  C   LEU A  86      46.860  61.631  10.693  1.00  0.00           C  
ATOM   1378  O   LEU A  86      47.027  62.793  11.062  1.00  0.00           O  
ATOM   1379  CB  LEU A  86      44.818  60.330  11.336  1.00  0.00           C  
ATOM   1380  CG  LEU A  86      43.292  60.234  11.240  1.00  0.00           C  
ATOM   1381  CD1 LEU A  86      42.649  61.578  11.554  1.00  0.00           C  
ATOM   1382  CD2 LEU A  86      42.869  59.749   9.862  1.00  0.00           C  
ATOM   1383  H   LEU A  86      45.331  59.406   9.026  1.00  0.00           H  
ATOM   1384  HA  LEU A  86      44.875  62.000   9.995  1.00  0.00           H  
ATOM   1385  HB2 LEU A  86      45.223  59.330  11.317  1.00  0.00           H  
ATOM   1386  HB3 LEU A  86      45.068  60.782  12.284  1.00  0.00           H  
ATOM   1387  HG  LEU A  86      42.940  59.519  11.968  1.00  0.00           H  
ATOM   1388 HD11 LEU A  86      42.055  61.490  12.452  1.00  0.00           H  
ATOM   1389 HD12 LEU A  86      42.017  61.877  10.732  1.00  0.00           H  
ATOM   1390 HD13 LEU A  86      43.419  62.321  11.704  1.00  0.00           H  
ATOM   1391 HD21 LEU A  86      43.345  60.353   9.105  1.00  0.00           H  
ATOM   1392 HD22 LEU A  86      41.798  59.831   9.764  1.00  0.00           H  
ATOM   1393 HD23 LEU A  86      43.163  58.716   9.736  1.00  0.00           H  
ATOM   1394  N   TRP A  87      47.841  60.735  10.660  1.00  0.00           N  
ATOM   1395  CA  TRP A  87      49.200  61.068  11.076  1.00  0.00           C  
ATOM   1396  C   TRP A  87      49.827  62.102  10.143  1.00  0.00           C  
ATOM   1397  O   TRP A  87      50.470  63.046  10.596  1.00  0.00           O  
ATOM   1398  CB  TRP A  87      50.068  59.803  11.103  1.00  0.00           C  
ATOM   1399  CG  TRP A  87      51.492  60.071  11.483  1.00  0.00           C  
ATOM   1400  CD1 TRP A  87      52.040  59.969  12.728  1.00  0.00           C  
ATOM   1401  CD2 TRP A  87      52.546  60.502  10.614  1.00  0.00           C  
ATOM   1402  NE1 TRP A  87      53.369  60.312  12.689  1.00  0.00           N  
ATOM   1403  CE2 TRP A  87      53.705  60.641  11.401  1.00  0.00           C  
ATOM   1404  CE3 TRP A  87      52.623  60.782   9.245  1.00  0.00           C  
ATOM   1405  CZ2 TRP A  87      54.924  61.050  10.865  1.00  0.00           C  
ATOM   1406  CZ3 TRP A  87      53.834  61.186   8.717  1.00  0.00           C  
ATOM   1407  CH2 TRP A  87      54.970  61.318   9.525  1.00  0.00           C  
ATOM   1408  H   TRP A  87      47.648  59.826  10.347  1.00  0.00           H  
ATOM   1409  HA  TRP A  87      49.153  61.481  12.077  1.00  0.00           H  
ATOM   1410  HB2 TRP A  87      49.656  59.107  11.818  1.00  0.00           H  
ATOM   1411  HB3 TRP A  87      50.063  59.350  10.122  1.00  0.00           H  
ATOM   1412  HD1 TRP A  87      51.494  59.664  13.609  1.00  0.00           H  
ATOM   1413  HE1 TRP A  87      53.979  60.312  13.456  1.00  0.00           H  
ATOM   1414  HE3 TRP A  87      51.757  60.687   8.605  1.00  0.00           H  
ATOM   1415  HZ2 TRP A  87      55.809  61.155  11.474  1.00  0.00           H  
ATOM   1416  HZ3 TRP A  87      53.913  61.408   7.663  1.00  0.00           H  
ATOM   1417  HH2 TRP A  87      55.893  61.638   9.068  1.00  0.00           H  
ATOM   1418  N   GLU A  88      49.652  61.912   8.838  1.00  0.00           N  
ATOM   1419  CA  GLU A  88      50.226  62.820   7.845  1.00  0.00           C  
ATOM   1420  C   GLU A  88      49.653  64.230   7.952  1.00  0.00           C  
ATOM   1421  O   GLU A  88      50.402  65.201   8.046  1.00  0.00           O  
ATOM   1422  CB  GLU A  88      49.988  62.273   6.436  1.00  0.00           C  
ATOM   1423  CG  GLU A  88      51.014  61.239   6.000  1.00  0.00           C  
ATOM   1424  CD  GLU A  88      52.387  61.842   5.768  1.00  0.00           C  
ATOM   1425  OE1 GLU A  88      52.538  63.067   5.954  1.00  0.00           O  
ATOM   1426  OE2 GLU A  88      53.310  61.086   5.401  1.00  0.00           O  
ATOM   1427  H   GLU A  88      49.138  61.138   8.531  1.00  0.00           H  
ATOM   1428  HA  GLU A  88      51.292  62.869   8.024  1.00  0.00           H  
ATOM   1429  HB2 GLU A  88      49.011  61.816   6.399  1.00  0.00           H  
ATOM   1430  HB3 GLU A  88      50.018  63.095   5.735  1.00  0.00           H  
ATOM   1431  HG2 GLU A  88      51.094  60.484   6.766  1.00  0.00           H  
ATOM   1432  HG3 GLU A  88      50.678  60.785   5.079  1.00  0.00           H  
ATOM   1433  N   ILE A  89      48.331  64.346   7.929  1.00  0.00           N  
ATOM   1434  CA  ILE A  89      47.683  65.646   8.015  1.00  0.00           C  
ATOM   1435  C   ILE A  89      48.171  66.445   9.224  1.00  0.00           C  
ATOM   1436  O   ILE A  89      48.131  67.675   9.223  1.00  0.00           O  
ATOM   1437  CB  ILE A  89      46.150  65.497   8.075  1.00  0.00           C  
ATOM   1438  CG1 ILE A  89      45.473  66.854   7.889  1.00  0.00           C  
ATOM   1439  CG2 ILE A  89      45.716  64.848   9.380  1.00  0.00           C  
ATOM   1440  CD1 ILE A  89      44.522  66.877   6.716  1.00  0.00           C  
ATOM   1441  H   ILE A  89      47.778  63.542   7.850  1.00  0.00           H  
ATOM   1442  HA  ILE A  89      47.930  66.196   7.119  1.00  0.00           H  
ATOM   1443  HB  ILE A  89      45.849  64.846   7.268  1.00  0.00           H  
ATOM   1444 HG12 ILE A  89      44.913  67.100   8.778  1.00  0.00           H  
ATOM   1445 HG13 ILE A  89      46.227  67.609   7.720  1.00  0.00           H  
ATOM   1446 HG21 ILE A  89      46.120  65.403  10.213  1.00  0.00           H  
ATOM   1447 HG22 ILE A  89      46.077  63.832   9.412  1.00  0.00           H  
ATOM   1448 HG23 ILE A  89      44.637  64.848   9.437  1.00  0.00           H  
ATOM   1449 HD11 ILE A  89      44.688  65.998   6.109  1.00  0.00           H  
ATOM   1450 HD12 ILE A  89      44.699  67.762   6.126  1.00  0.00           H  
ATOM   1451 HD13 ILE A  89      43.505  66.879   7.078  1.00  0.00           H  
ATOM   1452  N   GLU A  90      48.617  65.736  10.257  1.00  0.00           N  
ATOM   1453  CA  GLU A  90      49.094  66.378  11.478  1.00  0.00           C  
ATOM   1454  C   GLU A  90      50.619  66.487  11.523  1.00  0.00           C  
ATOM   1455  O   GLU A  90      51.161  67.523  11.909  1.00  0.00           O  
ATOM   1456  CB  GLU A  90      48.592  65.606  12.700  1.00  0.00           C  
ATOM   1457  CG  GLU A  90      47.876  66.478  13.718  1.00  0.00           C  
ATOM   1458  CD  GLU A  90      48.351  66.229  15.136  1.00  0.00           C  
ATOM   1459  OE1 GLU A  90      49.467  66.674  15.476  1.00  0.00           O  
ATOM   1460  OE2 GLU A  90      47.606  65.587  15.909  1.00  0.00           O  
ATOM   1461  H   GLU A  90      48.612  64.759  10.200  1.00  0.00           H  
ATOM   1462  HA  GLU A  90      48.678  67.374  11.507  1.00  0.00           H  
ATOM   1463  HB2 GLU A  90      47.907  64.839  12.370  1.00  0.00           H  
ATOM   1464  HB3 GLU A  90      49.434  65.137  13.188  1.00  0.00           H  
ATOM   1465  HG2 GLU A  90      48.051  67.514  13.473  1.00  0.00           H  
ATOM   1466  HG3 GLU A  90      46.817  66.270  13.668  1.00  0.00           H  
ATOM   1467  N   ASN A  91      51.308  65.406  11.162  1.00  0.00           N  
ATOM   1468  CA  ASN A  91      52.769  65.383  11.196  1.00  0.00           C  
ATOM   1469  C   ASN A  91      53.385  66.040   9.963  1.00  0.00           C  
ATOM   1470  O   ASN A  91      54.459  66.634  10.044  1.00  0.00           O  
ATOM   1471  CB  ASN A  91      53.273  63.945  11.319  1.00  0.00           C  
ATOM   1472  CG  ASN A  91      53.206  63.428  12.743  1.00  0.00           C  
ATOM   1473  OD1 ASN A  91      54.233  63.217  13.388  1.00  0.00           O  
ATOM   1474  ND2 ASN A  91      51.993  63.216  13.240  1.00  0.00           N  
ATOM   1475  H   ASN A  91      50.825  64.603  10.881  1.00  0.00           H  
ATOM   1476  HA  ASN A  91      53.083  65.935  12.068  1.00  0.00           H  
ATOM   1477  HB2 ASN A  91      52.670  63.304  10.694  1.00  0.00           H  
ATOM   1478  HB3 ASN A  91      54.300  63.901  10.987  1.00  0.00           H  
ATOM   1479 HD21 ASN A  91      51.219  63.403  12.668  1.00  0.00           H  
ATOM   1480 HD22 ASN A  91      51.922  62.882  14.158  1.00  0.00           H  
ATOM   1481  N   ASN A  92      52.713  65.927   8.824  1.00  0.00           N  
ATOM   1482  CA  ASN A  92      53.221  66.508   7.588  1.00  0.00           C  
ATOM   1483  C   ASN A  92      52.094  66.763   6.590  1.00  0.00           C  
ATOM   1484  O   ASN A  92      51.754  65.892   5.790  1.00  0.00           O  
ATOM   1485  CB  ASN A  92      54.270  65.584   6.965  1.00  0.00           C  
ATOM   1486  CG  ASN A  92      55.529  66.326   6.565  1.00  0.00           C  
ATOM   1487  OD1 ASN A  92      55.907  67.317   7.193  1.00  0.00           O  
ATOM   1488  ND2 ASN A  92      56.185  65.853   5.511  1.00  0.00           N  
ATOM   1489  H   ASN A  92      51.865  65.437   8.811  1.00  0.00           H  
ATOM   1490  HA  ASN A  92      53.689  67.448   7.835  1.00  0.00           H  
ATOM   1491  HB2 ASN A  92      54.537  64.818   7.680  1.00  0.00           H  
ATOM   1492  HB3 ASN A  92      53.853  65.117   6.084  1.00  0.00           H  
ATOM   1493 HD21 ASN A  92      55.823  65.064   5.058  1.00  0.00           H  
ATOM   1494 HD22 ASN A  92      57.002  66.314   5.230  1.00  0.00           H  
ATOM   1495  N   PRO A  93      51.498  67.968   6.624  1.00  0.00           N  
ATOM   1496  CA  PRO A  93      50.409  68.332   5.718  1.00  0.00           C  
ATOM   1497  C   PRO A  93      50.900  68.658   4.308  1.00  0.00           C  
ATOM   1498  O   PRO A  93      50.102  68.792   3.381  1.00  0.00           O  
ATOM   1499  CB  PRO A  93      49.810  69.572   6.377  1.00  0.00           C  
ATOM   1500  CG  PRO A  93      50.949  70.199   7.107  1.00  0.00           C  
ATOM   1501  CD  PRO A  93      51.840  69.067   7.549  1.00  0.00           C  
ATOM   1502  HA  PRO A  93      49.664  67.556   5.662  1.00  0.00           H  
ATOM   1503  HB2 PRO A  93      49.415  70.233   5.619  1.00  0.00           H  
ATOM   1504  HB3 PRO A  93      49.021  69.278   7.054  1.00  0.00           H  
ATOM   1505  HG2 PRO A  93      51.486  70.864   6.448  1.00  0.00           H  
ATOM   1506  HG3 PRO A  93      50.579  70.739   7.967  1.00  0.00           H  
ATOM   1507  HD2 PRO A  93      52.879  69.345   7.447  1.00  0.00           H  
ATOM   1508  HD3 PRO A  93      51.621  68.791   8.570  1.00  0.00           H  
ATOM   1509  N   THR A  94      52.215  68.794   4.153  1.00  0.00           N  
ATOM   1510  CA  THR A  94      52.799  69.111   2.854  1.00  0.00           C  
ATOM   1511  C   THR A  94      53.503  67.898   2.244  1.00  0.00           C  
ATOM   1512  O   THR A  94      54.250  68.032   1.274  1.00  0.00           O  
ATOM   1513  CB  THR A  94      53.790  70.267   2.990  1.00  0.00           C  
ATOM   1514  OG1 THR A  94      55.001  69.825   3.576  1.00  0.00           O  
ATOM   1515  CG2 THR A  94      53.264  71.413   3.829  1.00  0.00           C  
ATOM   1516  H   THR A  94      52.804  68.683   4.927  1.00  0.00           H  
ATOM   1517  HA  THR A  94      51.999  69.413   2.197  1.00  0.00           H  
ATOM   1518  HB  THR A  94      54.012  70.655   2.005  1.00  0.00           H  
ATOM   1519  HG1 THR A  94      55.682  70.491   3.449  1.00  0.00           H  
ATOM   1520 HG21 THR A  94      52.703  71.019   4.664  1.00  0.00           H  
ATOM   1521 HG22 THR A  94      52.621  72.036   3.226  1.00  0.00           H  
ATOM   1522 HG23 THR A  94      54.092  71.999   4.198  1.00  0.00           H  
ATOM   1523  N   VAL A  95      53.270  66.719   2.815  1.00  0.00           N  
ATOM   1524  CA  VAL A  95      53.896  65.496   2.320  1.00  0.00           C  
ATOM   1525  C   VAL A  95      53.518  65.222   0.867  1.00  0.00           C  
ATOM   1526  O   VAL A  95      52.424  65.566   0.422  1.00  0.00           O  
ATOM   1527  CB  VAL A  95      53.508  64.277   3.182  1.00  0.00           C  
ATOM   1528  CG1 VAL A  95      52.004  64.050   3.147  1.00  0.00           C  
ATOM   1529  CG2 VAL A  95      54.256  63.034   2.718  1.00  0.00           C  
ATOM   1530  H   VAL A  95      52.674  66.665   3.589  1.00  0.00           H  
ATOM   1531  HA  VAL A  95      54.968  65.626   2.384  1.00  0.00           H  
ATOM   1532  HB  VAL A  95      53.793  64.480   4.204  1.00  0.00           H  
ATOM   1533 HG11 VAL A  95      51.801  62.990   3.092  1.00  0.00           H  
ATOM   1534 HG12 VAL A  95      51.585  64.541   2.281  1.00  0.00           H  
ATOM   1535 HG13 VAL A  95      51.558  64.454   4.043  1.00  0.00           H  
ATOM   1536 HG21 VAL A  95      55.209  63.322   2.301  1.00  0.00           H  
ATOM   1537 HG22 VAL A  95      53.673  62.523   1.966  1.00  0.00           H  
ATOM   1538 HG23 VAL A  95      54.414  62.374   3.559  1.00  0.00           H  
ATOM   1539  N   LYS A  96      54.440  64.602   0.133  1.00  0.00           N  
ATOM   1540  CA  LYS A  96      54.213  64.278  -1.271  1.00  0.00           C  
ATOM   1541  C   LYS A  96      54.015  65.543  -2.098  1.00  0.00           C  
ATOM   1542  O   LYS A  96      53.692  66.605  -1.561  1.00  0.00           O  
ATOM   1543  CB  LYS A  96      52.995  63.360  -1.415  1.00  0.00           C  
ATOM   1544  CG  LYS A  96      53.356  61.916  -1.722  1.00  0.00           C  
ATOM   1545  CD  LYS A  96      53.081  61.567  -3.177  1.00  0.00           C  
ATOM   1546  CE  LYS A  96      54.002  60.462  -3.669  1.00  0.00           C  
ATOM   1547  NZ  LYS A  96      55.114  60.995  -4.504  1.00  0.00           N  
ATOM   1548  H   LYS A  96      55.294  64.364   0.546  1.00  0.00           H  
ATOM   1549  HA  LYS A  96      55.087  63.759  -1.636  1.00  0.00           H  
ATOM   1550  HB2 LYS A  96      52.434  63.379  -0.493  1.00  0.00           H  
ATOM   1551  HB3 LYS A  96      52.370  63.730  -2.214  1.00  0.00           H  
ATOM   1552  HG2 LYS A  96      54.405  61.765  -1.518  1.00  0.00           H  
ATOM   1553  HG3 LYS A  96      52.769  61.266  -1.089  1.00  0.00           H  
ATOM   1554  HD2 LYS A  96      52.057  61.238  -3.270  1.00  0.00           H  
ATOM   1555  HD3 LYS A  96      53.234  62.448  -3.781  1.00  0.00           H  
ATOM   1556  HE2 LYS A  96      54.419  59.949  -2.815  1.00  0.00           H  
ATOM   1557  HE3 LYS A  96      53.423  59.765  -4.259  1.00  0.00           H  
ATOM   1558  HZ1 LYS A  96      54.877  60.908  -5.513  1.00  0.00           H  
ATOM   1559  HZ2 LYS A  96      55.988  60.465  -4.318  1.00  0.00           H  
ATOM   1560  HZ3 LYS A  96      55.277  61.998  -4.284  1.00  0.00           H  
ATOM   1561  N   ALA A  97      54.211  65.426  -3.407  1.00  0.00           N  
ATOM   1562  CA  ALA A  97      54.055  66.557  -4.310  1.00  0.00           C  
ATOM   1563  C   ALA A  97      53.531  66.104  -5.669  1.00  0.00           C  
ATOM   1564  O   ALA A  97      53.212  64.931  -5.861  1.00  0.00           O  
ATOM   1565  CB  ALA A  97      55.378  67.293  -4.467  1.00  0.00           C  
ATOM   1566  H   ALA A  97      54.468  64.553  -3.773  1.00  0.00           H  
ATOM   1567  HA  ALA A  97      53.341  67.239  -3.870  1.00  0.00           H  
ATOM   1568  HB1 ALA A  97      55.801  67.072  -5.436  1.00  0.00           H  
ATOM   1569  HB2 ALA A  97      56.062  66.972  -3.695  1.00  0.00           H  
ATOM   1570  HB3 ALA A  97      55.210  68.356  -4.381  1.00  0.00           H  
ATOM   1571  N   SER A  98      53.448  67.040  -6.610  1.00  0.00           N  
ATOM   1572  CA  SER A  98      52.963  66.732  -7.951  1.00  0.00           C  
ATOM   1573  C   SER A  98      53.977  65.884  -8.712  1.00  0.00           C  
ATOM   1574  O   SER A  98      53.606  64.977  -9.457  1.00  0.00           O  
ATOM   1575  CB  SER A  98      52.679  68.023  -8.721  1.00  0.00           C  
ATOM   1576  OG  SER A  98      53.568  69.055  -8.333  1.00  0.00           O  
ATOM   1577  H   SER A  98      53.719  67.958  -6.396  1.00  0.00           H  
ATOM   1578  HA  SER A  98      52.045  66.173  -7.850  1.00  0.00           H  
ATOM   1579  HB2 SER A  98      52.798  67.841  -9.780  1.00  0.00           H  
ATOM   1580  HB3 SER A  98      51.667  68.342  -8.522  1.00  0.00           H  
ATOM   1581  HG  SER A  98      53.191  69.907  -8.566  1.00  0.00           H  
ATOM   1582  N   GLY A  99      55.256  66.184  -8.518  1.00  0.00           N  
ATOM   1583  CA  GLY A  99      56.304  65.439  -9.192  1.00  0.00           C  
ATOM   1584  C   GLY A  99      57.159  66.319 -10.082  1.00  0.00           C  
ATOM   1585  O   GLY A  99      56.690  67.333 -10.599  1.00  0.00           O  
ATOM   1586  H   GLY A  99      55.493  66.916  -7.911  1.00  0.00           H  
ATOM   1587  HA2 GLY A  99      56.937  64.976  -8.449  1.00  0.00           H  
ATOM   1588  HA3 GLY A  99      55.852  64.667  -9.797  1.00  0.00           H  
ATOM   1589  N   TYR A 100      58.418  65.932 -10.262  1.00  0.00           N  
ATOM   1590  CA  TYR A 100      59.341  66.694 -11.095  1.00  0.00           C  
ATOM   1591  C   TYR A 100      59.830  65.855 -12.272  1.00  0.00           C  
ATOM   1592  O   TYR A 100      59.854  64.627 -12.204  1.00  0.00           O  
ATOM   1593  CB  TYR A 100      60.534  67.172 -10.267  1.00  0.00           C  
ATOM   1594  CG  TYR A 100      61.165  68.439 -10.791  1.00  0.00           C  
ATOM   1595  CD1 TYR A 100      62.129  68.395 -11.790  1.00  0.00           C  
ATOM   1596  CD2 TYR A 100      60.799  69.679 -10.286  1.00  0.00           C  
ATOM   1597  CE1 TYR A 100      62.709  69.551 -12.271  1.00  0.00           C  
ATOM   1598  CE2 TYR A 100      61.374  70.841 -10.761  1.00  0.00           C  
ATOM   1599  CZ  TYR A 100      62.329  70.772 -11.754  1.00  0.00           C  
ATOM   1600  OH  TYR A 100      62.906  71.927 -12.231  1.00  0.00           O  
ATOM   1601  H   TYR A 100      58.734  65.114  -9.823  1.00  0.00           H  
ATOM   1602  HA  TYR A 100      58.811  67.554 -11.477  1.00  0.00           H  
ATOM   1603  HB2 TYR A 100      60.209  67.362  -9.255  1.00  0.00           H  
ATOM   1604  HB3 TYR A 100      61.292  66.404 -10.260  1.00  0.00           H  
ATOM   1605  HD1 TYR A 100      62.422  67.437 -12.192  1.00  0.00           H  
ATOM   1606  HD2 TYR A 100      60.052  69.730  -9.509  1.00  0.00           H  
ATOM   1607  HE1 TYR A 100      63.456  69.496 -13.048  1.00  0.00           H  
ATOM   1608  HE2 TYR A 100      61.076  71.794 -10.356  1.00  0.00           H  
ATOM   1609  HH  TYR A 100      62.967  71.883 -13.188  1.00  0.00           H  
ATOM   1610  N   GLN A 101      60.218  66.529 -13.350  1.00  0.00           N  
ATOM   1611  CA  GLN A 101      60.707  65.846 -14.542  1.00  0.00           C  
ATOM   1612  C   GLN A 101      62.232  65.793 -14.552  1.00  0.00           C  
ATOM   1613  O   GLN A 101      62.898  66.803 -14.780  1.00  0.00           O  
ATOM   1614  CB  GLN A 101      60.202  66.553 -15.802  1.00  0.00           C  
ATOM   1615  CG  GLN A 101      58.743  66.268 -16.119  1.00  0.00           C  
ATOM   1616  CD  GLN A 101      58.464  66.241 -17.609  1.00  0.00           C  
ATOM   1617  OE1 GLN A 101      57.571  66.933 -18.097  1.00  0.00           O  
ATOM   1618  NE2 GLN A 101      59.229  65.439 -18.338  1.00  0.00           N  
ATOM   1619  H   GLN A 101      60.175  67.509 -13.344  1.00  0.00           H  
ATOM   1620  HA  GLN A 101      60.323  64.838 -14.527  1.00  0.00           H  
ATOM   1621  HB2 GLN A 101      60.318  67.620 -15.674  1.00  0.00           H  
ATOM   1622  HB3 GLN A 101      60.799  66.235 -16.644  1.00  0.00           H  
ATOM   1623  HG2 GLN A 101      58.479  65.306 -15.701  1.00  0.00           H  
ATOM   1624  HG3 GLN A 101      58.133  67.036 -15.666  1.00  0.00           H  
ATOM   1625 HE21 GLN A 101      59.921  64.915 -17.881  1.00  0.00           H  
ATOM   1626 HE22 GLN A 101      59.071  65.401 -19.305  1.00  0.00           H  
ATOM   1627  N   SER A 102      62.779  64.607 -14.303  1.00  0.00           N  
ATOM   1628  CA  SER A 102      64.226  64.420 -14.283  1.00  0.00           C  
ATOM   1629  C   SER A 102      64.758  64.165 -15.691  1.00  0.00           C  
ATOM   1630  O   SER A 102      64.253  63.303 -16.410  1.00  0.00           O  
ATOM   1631  CB  SER A 102      64.599  63.256 -13.362  1.00  0.00           C  
ATOM   1632  OG  SER A 102      65.256  63.720 -12.194  1.00  0.00           O  
ATOM   1633  H   SER A 102      62.196  63.837 -14.129  1.00  0.00           H  
ATOM   1634  HA  SER A 102      64.671  65.326 -13.902  1.00  0.00           H  
ATOM   1635  HB2 SER A 102      63.702  62.730 -13.069  1.00  0.00           H  
ATOM   1636  HB3 SER A 102      65.257  62.578 -13.885  1.00  0.00           H  
ATOM   1637  HG  SER A 102      65.822  63.025 -11.849  1.00  0.00           H  
ATOM   1638  N   SER A 103      65.780  64.924 -16.079  1.00  0.00           N  
ATOM   1639  CA  SER A 103      66.378  64.780 -17.401  1.00  0.00           C  
ATOM   1640  C   SER A 103      65.352  65.063 -18.493  1.00  0.00           C  
ATOM   1641  O   SER A 103      64.437  64.271 -18.719  1.00  0.00           O  
ATOM   1642  CB  SER A 103      66.951  63.373 -17.574  1.00  0.00           C  
ATOM   1643  OG  SER A 103      68.113  63.197 -16.784  1.00  0.00           O  
ATOM   1644  H   SER A 103      66.138  65.595 -15.462  1.00  0.00           H  
ATOM   1645  HA  SER A 103      67.180  65.498 -17.482  1.00  0.00           H  
ATOM   1646  HB2 SER A 103      66.212  62.645 -17.274  1.00  0.00           H  
ATOM   1647  HB3 SER A 103      67.209  63.216 -18.612  1.00  0.00           H  
ATOM   1648  HG  SER A 103      68.691  63.956 -16.887  1.00  0.00           H  
ATOM   1649  N   GLN A 104      65.509  66.198 -19.165  1.00  0.00           N  
ATOM   1650  CA  GLN A 104      64.591  66.587 -20.231  1.00  0.00           C  
ATOM   1651  C   GLN A 104      65.288  66.571 -21.588  1.00  0.00           C  
ATOM   1652  O   GLN A 104      64.720  66.118 -22.582  1.00  0.00           O  
ATOM   1653  CB  GLN A 104      64.020  67.980 -19.954  1.00  0.00           C  
ATOM   1654  CG  GLN A 104      62.557  68.124 -20.339  1.00  0.00           C  
ATOM   1655  CD  GLN A 104      62.041  69.536 -20.139  1.00  0.00           C  
ATOM   1656  OE1 GLN A 104      61.908  70.302 -21.092  1.00  0.00           O  
ATOM   1657  NE2 GLN A 104      61.745  69.886 -18.892  1.00  0.00           N  
ATOM   1658  H   GLN A 104      66.255  66.791 -18.938  1.00  0.00           H  
ATOM   1659  HA  GLN A 104      63.781  65.873 -20.247  1.00  0.00           H  
ATOM   1660  HB2 GLN A 104      64.115  68.191 -18.899  1.00  0.00           H  
ATOM   1661  HB3 GLN A 104      64.591  68.707 -20.510  1.00  0.00           H  
ATOM   1662  HG2 GLN A 104      62.444  67.862 -21.380  1.00  0.00           H  
ATOM   1663  HG3 GLN A 104      61.969  67.451 -19.731  1.00  0.00           H  
ATOM   1664 HE21 GLN A 104      61.874  69.222 -18.182  1.00  0.00           H  
ATOM   1665 HE22 GLN A 104      61.410  70.793 -18.733  1.00  0.00           H  
ATOM   1666  N   LYS A 105      66.519  67.073 -21.625  1.00  0.00           N  
ATOM   1667  CA  LYS A 105      67.286  67.118 -22.865  1.00  0.00           C  
ATOM   1668  C   LYS A 105      68.340  66.015 -22.903  1.00  0.00           C  
ATOM   1669  O   LYS A 105      68.599  65.428 -23.953  1.00  0.00           O  
ATOM   1670  CB  LYS A 105      67.953  68.485 -23.029  1.00  0.00           C  
ATOM   1671  CG  LYS A 105      68.925  68.829 -21.912  1.00  0.00           C  
ATOM   1672  CD  LYS A 105      68.821  70.292 -21.513  1.00  0.00           C  
ATOM   1673  CE  LYS A 105      67.521  70.578 -20.777  1.00  0.00           C  
ATOM   1674  NZ  LYS A 105      66.692  71.592 -21.485  1.00  0.00           N  
ATOM   1675  H   LYS A 105      66.917  67.422 -20.802  1.00  0.00           H  
ATOM   1676  HA  LYS A 105      66.598  66.965 -23.683  1.00  0.00           H  
ATOM   1677  HB2 LYS A 105      68.493  68.499 -23.964  1.00  0.00           H  
ATOM   1678  HB3 LYS A 105      67.186  69.245 -23.056  1.00  0.00           H  
ATOM   1679  HG2 LYS A 105      68.703  68.215 -21.053  1.00  0.00           H  
ATOM   1680  HG3 LYS A 105      69.932  68.628 -22.251  1.00  0.00           H  
ATOM   1681  HD2 LYS A 105      69.650  70.540 -20.871  1.00  0.00           H  
ATOM   1682  HD3 LYS A 105      68.860  70.901 -22.405  1.00  0.00           H  
ATOM   1683  HE2 LYS A 105      66.958  69.661 -20.692  1.00  0.00           H  
ATOM   1684  HE3 LYS A 105      67.757  70.948 -19.789  1.00  0.00           H  
ATOM   1685  HZ1 LYS A 105      67.304  72.275 -21.975  1.00  0.00           H  
ATOM   1686  HZ2 LYS A 105      66.094  72.104 -20.806  1.00  0.00           H  
ATOM   1687  HZ3 LYS A 105      66.080  71.125 -22.185  1.00  0.00           H  
ATOM   1688  N   LYS A 106      68.948  65.739 -21.753  1.00  0.00           N  
ATOM   1689  CA  LYS A 106      69.973  64.707 -21.663  1.00  0.00           C  
ATOM   1690  C   LYS A 106      70.089  64.172 -20.241  1.00  0.00           C  
ATOM   1691  O   LYS A 106      69.676  64.827 -19.284  1.00  0.00           O  
ATOM   1692  CB  LYS A 106      71.323  65.261 -22.127  1.00  0.00           C  
ATOM   1693  CG  LYS A 106      71.651  64.933 -23.577  1.00  0.00           C  
ATOM   1694  CD  LYS A 106      72.957  64.164 -23.694  1.00  0.00           C  
ATOM   1695  CE  LYS A 106      73.165  63.631 -25.103  1.00  0.00           C  
ATOM   1696  NZ  LYS A 106      73.803  64.640 -25.993  1.00  0.00           N  
ATOM   1697  H   LYS A 106      68.700  66.240 -20.948  1.00  0.00           H  
ATOM   1698  HA  LYS A 106      69.685  63.897 -22.318  1.00  0.00           H  
ATOM   1699  HB2 LYS A 106      71.314  66.336 -22.018  1.00  0.00           H  
ATOM   1700  HB3 LYS A 106      72.102  64.852 -21.501  1.00  0.00           H  
ATOM   1701  HG2 LYS A 106      70.854  64.333 -23.988  1.00  0.00           H  
ATOM   1702  HG3 LYS A 106      71.735  65.856 -24.133  1.00  0.00           H  
ATOM   1703  HD2 LYS A 106      73.776  64.824 -23.447  1.00  0.00           H  
ATOM   1704  HD3 LYS A 106      72.940  63.335 -23.002  1.00  0.00           H  
ATOM   1705  HE2 LYS A 106      73.799  62.758 -25.053  1.00  0.00           H  
ATOM   1706  HE3 LYS A 106      72.206  63.353 -25.514  1.00  0.00           H  
ATOM   1707  HZ1 LYS A 106      74.826  64.471 -26.050  1.00  0.00           H  
ATOM   1708  HZ2 LYS A 106      73.641  65.598 -25.620  1.00  0.00           H  
ATOM   1709  HZ3 LYS A 106      73.397  64.580 -26.949  1.00  0.00           H  
ATOM   1710  N   SER A 107      70.653  62.975 -20.109  1.00  0.00           N  
ATOM   1711  CA  SER A 107      70.824  62.347 -18.804  1.00  0.00           C  
ATOM   1712  C   SER A 107      72.299  62.080 -18.519  1.00  0.00           C  
ATOM   1713  O   SER A 107      73.114  62.004 -19.439  1.00  0.00           O  
ATOM   1714  CB  SER A 107      70.030  61.041 -18.738  1.00  0.00           C  
ATOM   1715  OG  SER A 107      69.024  61.105 -17.742  1.00  0.00           O  
ATOM   1716  H   SER A 107      70.962  62.503 -20.911  1.00  0.00           H  
ATOM   1717  HA  SER A 107      70.444  63.027 -18.057  1.00  0.00           H  
ATOM   1718  HB2 SER A 107      69.562  60.857 -19.693  1.00  0.00           H  
ATOM   1719  HB3 SER A 107      70.699  60.225 -18.502  1.00  0.00           H  
ATOM   1720  HG  SER A 107      68.798  60.216 -17.457  1.00  0.00           H  
ATOM   1721  N   CYS A 108      72.636  61.940 -17.242  1.00  0.00           N  
ATOM   1722  CA  CYS A 108      74.014  61.680 -16.839  1.00  0.00           C  
ATOM   1723  C   CYS A 108      74.119  60.369 -16.066  1.00  0.00           C  
ATOM   1724  O   CYS A 108      75.043  59.586 -16.277  1.00  0.00           O  
ATOM   1725  CB  CYS A 108      74.543  62.832 -15.983  1.00  0.00           C  
ATOM   1726  SG  CYS A 108      73.499  63.238 -14.564  1.00  0.00           S  
ATOM   1727  H   CYS A 108      71.942  62.011 -16.553  1.00  0.00           H  
ATOM   1728  HA  CYS A 108      74.613  61.605 -17.734  1.00  0.00           H  
ATOM   1729  HB2 CYS A 108      75.521  62.571 -15.607  1.00  0.00           H  
ATOM   1730  HB3 CYS A 108      74.623  63.718 -16.596  1.00  0.00           H  
ATOM   1731  HG  CYS A 108      73.784  64.087 -14.220  1.00  0.00           H  
ATOM   1732  N   ALA A 109      73.164  60.139 -15.172  1.00  0.00           N  
ATOM   1733  CA  ALA A 109      73.150  58.924 -14.367  1.00  0.00           C  
ATOM   1734  C   ALA A 109      72.574  57.750 -15.153  1.00  0.00           C  
ATOM   1735  O   ALA A 109      73.138  56.657 -15.160  1.00  0.00           O  
ATOM   1736  CB  ALA A 109      72.355  59.147 -13.089  1.00  0.00           C  
ATOM   1737  H   ALA A 109      72.454  60.802 -15.048  1.00  0.00           H  
ATOM   1738  HA  ALA A 109      74.170  58.694 -14.094  1.00  0.00           H  
ATOM   1739  HB1 ALA A 109      72.299  60.206 -12.880  1.00  0.00           H  
ATOM   1740  HB2 ALA A 109      72.846  58.643 -12.269  1.00  0.00           H  
ATOM   1741  HB3 ALA A 109      71.359  58.750 -13.211  1.00  0.00           H  
ATOM   1742  N   GLU A 110      71.444  57.986 -15.814  1.00  0.00           N  
ATOM   1743  CA  GLU A 110      70.792  56.948 -16.603  1.00  0.00           C  
ATOM   1744  C   GLU A 110      69.690  57.540 -17.477  1.00  0.00           C  
ATOM   1745  O   GLU A 110      68.952  56.812 -18.140  1.00  0.00           O  
ATOM   1746  CB  GLU A 110      70.211  55.870 -15.684  1.00  0.00           C  
ATOM   1747  CG  GLU A 110      70.814  54.492 -15.904  1.00  0.00           C  
ATOM   1748  CD  GLU A 110      70.094  53.707 -16.983  1.00  0.00           C  
ATOM   1749  OE1 GLU A 110      69.689  54.320 -17.993  1.00  0.00           O  
ATOM   1750  OE2 GLU A 110      69.933  52.479 -16.817  1.00  0.00           O  
ATOM   1751  H   GLU A 110      71.042  58.878 -15.772  1.00  0.00           H  
ATOM   1752  HA  GLU A 110      71.537  56.499 -17.241  1.00  0.00           H  
ATOM   1753  HB2 GLU A 110      70.387  56.156 -14.658  1.00  0.00           H  
ATOM   1754  HB3 GLU A 110      69.146  55.803 -15.852  1.00  0.00           H  
ATOM   1755  HG2 GLU A 110      71.848  54.607 -16.195  1.00  0.00           H  
ATOM   1756  HG3 GLU A 110      70.760  53.938 -14.979  1.00  0.00           H  
TER    1757      GLU A 110                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
