
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 ( 1317),  selected   92 , name 1whm_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 1whm_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      L       3          5.787
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    P     8_A      Q       6          2.138
LGA    P     9_A      G       7          2.936
LGA    -       -      D       8           -
LGA    L    10_A      L       9          1.677
LGA    E    11_A      I      10          1.892
LGA    I    12_A      V      11          1.825
LGA    N    13_A      S      12          1.113
LGA    S    14_A      M      13          0.910
LGA    R    15_A      R      14          0.534
LGA    V    16_A      I      15          0.577
LGA    S    17_A      L      16          1.126
LGA    L    18_A      G      17          0.908
LGA    K    19_A      K      18          1.447
LGA    V    20_A      K      19          2.058
LGA    G    21_A      R      20          3.318
LGA    -       -      T      21           -
LGA    E    22_A      K      22          1.932
LGA    T    23_A      T      23          0.561
LGA    I    24_A      W      24          0.627
LGA    E    25_A      X      25          1.640
LGA    S    26_A      K      26          0.987
LGA    G    27_A      G      27          0.303
LGA    T    28_A      T      28          0.405
LGA    V    29_A      L      29          1.175
LGA    I    30_A      I      30          1.593
LGA    F    31_A      A      31          0.641
LGA    C    32_A      I      32          0.953
LGA    D    33_A      Q      33          2.203
LGA    V    34_A      T      34          0.852
LGA    L    35_A      V      35          3.090
LGA    P    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    K    38_A      -       -           -
LGA    E    39_A      G      36          2.365
LGA    S    40_A      P      37          3.182
LGA    L    41_A      G      38          3.363
LGA    G    42_A      -       -           -
LGA    Y    43_A      K      39          0.876
LGA    F    44_A      K      40          0.375
LGA    V    45_A      Y      41          0.669
LGA    G    46_A      K      42          0.604
LGA    V    47_A      V      43          0.850
LGA    D    48_A      K      44          1.241
LGA    M    49_A      F      45          0.921
LGA    D    50_A      D      46          1.201
LGA    N    51_A      N      47          1.173
LGA    P    52_A      K      48          2.776
LGA    I    53_A      G      49          2.728
LGA    G    54_A      K      50          2.598
LGA    N    55_A      -       -           -
LGA    W    56_A      -       -           -
LGA    D    57_A      -       -           -
LGA    G    58_A      -       -           -
LGA    R    59_A      -       -           -
LGA    F    60_A      -       -           -
LGA    D    61_A      -       -           -
LGA    G    62_A      -       -           -
LGA    V    63_A      -       -           -
LGA    Q    64_A      -       -           -
LGA    L    65_A      -       -           -
LGA    C    66_A      -       -           -
LGA    S    67_A      -       -           -
LGA    F    68_A      -       -           -
LGA    A    69_A      -       -           -
LGA    C    70_A      -       -           -
LGA    V    71_A      -       -           -
LGA    E    72_A      -       -           -
LGA    S    73_A      -       -           -
LGA    T    74_A      -       -           -
LGA    I    75_A      S      51          1.611
LGA    L    76_A      L      52          1.176
LGA    L    77_A      L      53          1.081
LGA    H    78_A      S      54          0.713
LGA    I    79_A      G      55          1.479
LGA    N    80_A      N      56          1.564
LGA    D    81_A      X      57          0.703
LGA    I    82_A      I      58          0.514
LGA    I    83_A      A      59          1.197
LGA    P    84_A      Y      60          1.480
LGA    E    85_A      D      61          1.564
LGA    S    86_A      Y      62          3.674
LGA    S    87_A      -       -           -
LGA    G    88_A      -       -           -
LGA    P    89_A      -       -           -
LGA    S    90_A      -       -           -
LGA    S    91_A      -       -           -
LGA    G    92_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92   62    5.0     56    1.86    25.00     82.675     2.852

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.468189 * X  +   0.403268 * Y  +   0.786240 * Z  +  40.712963
  Y_new =   0.509897 * X  +  -0.603399 * Y  +   0.613120 * Z  +  67.923264
  Z_new =   0.721668 * X  +   0.687957 * Y  +   0.076879 * Z  +  -5.980344 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.459508   -1.682085  [ DEG:    83.6237    -96.3763 ]
  Theta =  -0.806209   -2.335384  [ DEG:   -46.1924   -133.8076 ]
  Phi   =   2.313578   -0.828015  [ DEG:   132.5583    -47.4417 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1whm_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1whm_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92   62   5.0   56   1.86   25.00  82.675
REMARK  ---------------------------------------------------------- 
MOLECULE 1whm_A
HEADER    ANTITUMOR PROTEIN                       28-MAY-04   1WHM              
TITLE     SOLUTION STRUCTURE OF THE 2ND CAP-GLY DOMAIN IN HUMAN                 
TITLE    2 CYLINDROMATOSIS TUMOR SUPPRESSOR CYLD                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CYLINDROMATOSIS TUMOR SUPPRESSOR CYLD;                     
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CAP-GLY DOMAIN;                                            
COMPND   5 SYNONYM: KIAA0849 PROTEIN;                                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KAZUSA CDNA FH04363;                                           
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P031006-38;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    TUMOR SUPPRESSOR, DEUBIQUITINATING ENZYME, STRUCTURAL                 
KEYWDS   2 GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   3 RSGI                                                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.SAITOK,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA,RIKEN                  
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   28-NOV-04 1WHM    0                                                
JRNL        AUTH   K.SAITOK,S.KOSHIBA,M.INOUE,T.KIGAWA,S.YOKOYAMA               
JRNL        TITL   SOLUTION STRUCTURE OF THE 2ND CAP-GLY DOMAIN IN              
JRNL        TITL 2 HUMAN CYLINDROMATOSIS TUMOR SUPPRESSOR CYLD                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WHM A    8    86  UNP    Q9NQC7   CYLD_HUMAN     235    313             
SEQRES   1 A   92  GLY SER SER GLY SER SER GLY PRO PRO LEU GLU ILE ASN          
SEQRES   2 A   92  SER ARG VAL SER LEU LYS VAL GLY GLU THR ILE GLU SER          
SEQRES   3 A   92  GLY THR VAL ILE PHE CYS ASP VAL LEU PRO GLY LYS GLU          
SEQRES   4 A   92  SER LEU GLY TYR PHE VAL GLY VAL ASP MET ASP ASN PRO          
SEQRES   5 A   92  ILE GLY ASN TRP ASP GLY ARG PHE ASP GLY VAL GLN LEU          
SEQRES   6 A   92  CYS SER PHE ALA CYS VAL GLU SER THR ILE LEU LEU HIS          
SEQRES   7 A   92  ILE ASN ASP ILE ILE PRO GLU SER SER GLY PRO SER SER          
SEQRES   8 A   92  GLY                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      31.312  83.830 -15.520  1.00  0.00           N  
ATOM      2  CA  GLY A   1      32.142  84.318 -14.384  1.00  0.00           C  
ATOM      3  C   GLY A   1      31.315  85.001 -13.312  1.00  0.00           C  
ATOM      4  O   GLY A   1      30.085  84.953 -13.343  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      32.659  83.479 -13.943  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      32.872  85.019 -14.761  1.00  0.00           H  
ATOM      7  H1  GLY A   1      31.807  83.989 -16.419  1.00  0.00           H  
ATOM      8  H2  GLY A   1      30.405  84.338 -15.543  1.00  0.00           H  
ATOM      9  H3  GLY A   1      31.124  82.813 -15.414  1.00  0.00           H  
ATOM     10  N   SER A   2      31.992  85.637 -12.362  1.00  0.00           N  
ATOM     11  CA  SER A   2      31.313  86.332 -11.275  1.00  0.00           C  
ATOM     12  C   SER A   2      32.056  87.609 -10.896  1.00  0.00           C  
ATOM     13  O   SER A   2      33.048  87.972 -11.529  1.00  0.00           O  
ATOM     14  CB  SER A   2      31.190  85.418 -10.054  1.00  0.00           C  
ATOM     15  OG  SER A   2      29.963  84.712 -10.066  1.00  0.00           O  
ATOM     16  H   SER A   2      32.971  85.639 -12.391  1.00  0.00           H  
ATOM     17  HA  SER A   2      30.323  86.595 -11.616  1.00  0.00           H  
ATOM     18  HB2 SER A   2      32.001  84.705 -10.057  1.00  0.00           H  
ATOM     19  HB3 SER A   2      31.239  86.014  -9.155  1.00  0.00           H  
ATOM     20  HG  SER A   2      29.492  84.872  -9.245  1.00  0.00           H  
ATOM     21  N   SER A   3      31.572  88.285  -9.859  1.00  0.00           N  
ATOM     22  CA  SER A   3      32.193  89.520  -9.397  1.00  0.00           C  
ATOM     23  C   SER A   3      32.196  89.591  -7.873  1.00  0.00           C  
ATOM     24  O   SER A   3      31.365  88.967  -7.211  1.00  0.00           O  
ATOM     25  CB  SER A   3      31.455  90.732  -9.972  1.00  0.00           C  
ATOM     26  OG  SER A   3      31.726  90.884 -11.354  1.00  0.00           O  
ATOM     27  H   SER A   3      30.779  87.945  -9.395  1.00  0.00           H  
ATOM     28  HA  SER A   3      33.213  89.531  -9.748  1.00  0.00           H  
ATOM     29  HB2 SER A   3      30.392  90.602  -9.839  1.00  0.00           H  
ATOM     30  HB3 SER A   3      31.775  91.624  -9.454  1.00  0.00           H  
ATOM     31  HG  SER A   3      31.052  90.430 -11.865  1.00  0.00           H  
ATOM     32  N   GLY A   4      33.135  90.353  -7.322  1.00  0.00           N  
ATOM     33  CA  GLY A   4      33.229  90.490  -5.880  1.00  0.00           C  
ATOM     34  C   GLY A   4      34.517  89.911  -5.326  1.00  0.00           C  
ATOM     35  O   GLY A   4      35.353  90.640  -4.791  1.00  0.00           O  
ATOM     36  H   GLY A   4      33.770  90.826  -7.900  1.00  0.00           H  
ATOM     37  HA2 GLY A   4      33.180  91.538  -5.626  1.00  0.00           H  
ATOM     38  HA3 GLY A   4      32.393  89.980  -5.426  1.00  0.00           H  
ATOM     39  N   SER A   5      34.675  88.598  -5.451  1.00  0.00           N  
ATOM     40  CA  SER A   5      35.869  87.923  -4.958  1.00  0.00           C  
ATOM     41  C   SER A   5      36.873  87.696  -6.084  1.00  0.00           C  
ATOM     42  O   SER A   5      36.501  87.625  -7.255  1.00  0.00           O  
ATOM     43  CB  SER A   5      35.495  86.585  -4.318  1.00  0.00           C  
ATOM     44  OG  SER A   5      34.569  85.874  -5.122  1.00  0.00           O  
ATOM     45  H   SER A   5      33.973  88.072  -5.886  1.00  0.00           H  
ATOM     46  HA  SER A   5      36.322  88.554  -4.209  1.00  0.00           H  
ATOM     47  HB2 SER A   5      36.384  85.983  -4.199  1.00  0.00           H  
ATOM     48  HB3 SER A   5      35.049  86.763  -3.350  1.00  0.00           H  
ATOM     49  HG  SER A   5      33.691  85.949  -4.743  1.00  0.00           H  
ATOM     50  N   SER A   6      38.147  87.585  -5.721  1.00  0.00           N  
ATOM     51  CA  SER A   6      39.204  87.367  -6.700  1.00  0.00           C  
ATOM     52  C   SER A   6      40.170  86.287  -6.225  1.00  0.00           C  
ATOM     53  O   SER A   6      40.928  86.490  -5.276  1.00  0.00           O  
ATOM     54  CB  SER A   6      39.965  88.669  -6.959  1.00  0.00           C  
ATOM     55  OG  SER A   6      41.120  88.437  -7.746  1.00  0.00           O  
ATOM     56  H   SER A   6      38.380  87.651  -4.771  1.00  0.00           H  
ATOM     57  HA  SER A   6      38.743  87.042  -7.621  1.00  0.00           H  
ATOM     58  HB2 SER A   6      39.322  89.361  -7.483  1.00  0.00           H  
ATOM     59  HB3 SER A   6      40.267  89.101  -6.016  1.00  0.00           H  
ATOM     60  HG  SER A   6      41.354  89.241  -8.218  1.00  0.00           H  
ATOM     61  N   GLY A   7      40.138  85.137  -6.891  1.00  0.00           N  
ATOM     62  CA  GLY A   7      41.014  84.039  -6.523  1.00  0.00           C  
ATOM     63  C   GLY A   7      40.246  82.798  -6.112  1.00  0.00           C  
ATOM     64  O   GLY A   7      39.016  82.790  -6.136  1.00  0.00           O  
ATOM     65  H   GLY A   7      39.514  85.032  -7.639  1.00  0.00           H  
ATOM     66  HA2 GLY A   7      41.643  83.798  -7.367  1.00  0.00           H  
ATOM     67  HA3 GLY A   7      41.639  84.353  -5.699  1.00  0.00           H  
ATOM     68  N   PRO A   8      40.952  81.721  -5.723  1.00  0.00           N  
ATOM     69  CA  PRO A   8      40.313  80.469  -5.306  1.00  0.00           C  
ATOM     70  C   PRO A   8      39.610  80.600  -3.955  1.00  0.00           C  
ATOM     71  O   PRO A   8      40.127  81.240  -3.040  1.00  0.00           O  
ATOM     72  CB  PRO A   8      41.485  79.489  -5.205  1.00  0.00           C  
ATOM     73  CG  PRO A   8      42.672  80.347  -4.935  1.00  0.00           C  
ATOM     74  CD  PRO A   8      42.423  81.640  -5.663  1.00  0.00           C  
ATOM     75  HA  PRO A   8      39.610  80.119  -6.047  1.00  0.00           H  
ATOM     76  HB2 PRO A   8      41.308  78.794  -4.398  1.00  0.00           H  
ATOM     77  HB3 PRO A   8      41.590  78.952  -6.136  1.00  0.00           H  
ATOM     78  HG2 PRO A   8      42.764  80.526  -3.874  1.00  0.00           H  
ATOM     79  HG3 PRO A   8      43.564  79.870  -5.315  1.00  0.00           H  
ATOM     80  HD2 PRO A   8      42.832  82.471  -5.106  1.00  0.00           H  
ATOM     81  HD3 PRO A   8      42.848  81.603  -6.655  1.00  0.00           H  
ATOM     82  N   PRO A   9      38.418  79.991  -3.811  1.00  0.00           N  
ATOM     83  CA  PRO A   9      37.651  80.049  -2.562  1.00  0.00           C  
ATOM     84  C   PRO A   9      38.296  79.229  -1.448  1.00  0.00           C  
ATOM     85  O   PRO A   9      38.423  79.695  -0.316  1.00  0.00           O  
ATOM     86  CB  PRO A   9      36.296  79.454  -2.949  1.00  0.00           C  
ATOM     87  CG  PRO A   9      36.590  78.560  -4.103  1.00  0.00           C  
ATOM     88  CD  PRO A   9      37.725  79.206  -4.850  1.00  0.00           C  
ATOM     89  HA  PRO A   9      37.519  81.067  -2.226  1.00  0.00           H  
ATOM     90  HB2 PRO A   9      35.891  78.901  -2.113  1.00  0.00           H  
ATOM     91  HB3 PRO A   9      35.618  80.246  -3.227  1.00  0.00           H  
ATOM     92  HG2 PRO A   9      36.883  77.583  -3.746  1.00  0.00           H  
ATOM     93  HG3 PRO A   9      35.720  78.483  -4.737  1.00  0.00           H  
ATOM     94  HD2 PRO A   9      38.379  78.453  -5.264  1.00  0.00           H  
ATOM     95  HD3 PRO A   9      37.345  79.848  -5.630  1.00  0.00           H  
ATOM     96  N   LEU A  10      38.701  78.007  -1.778  1.00  0.00           N  
ATOM     97  CA  LEU A  10      39.332  77.123  -0.806  1.00  0.00           C  
ATOM     98  C   LEU A  10      40.755  77.579  -0.498  1.00  0.00           C  
ATOM     99  O   LEU A  10      41.532  77.877  -1.406  1.00  0.00           O  
ATOM    100  CB  LEU A  10      39.347  75.685  -1.326  1.00  0.00           C  
ATOM    101  CG  LEU A  10      39.246  74.606  -0.246  1.00  0.00           C  
ATOM    102  CD1 LEU A  10      37.831  74.533   0.304  1.00  0.00           C  
ATOM    103  CD2 LEU A  10      39.674  73.256  -0.803  1.00  0.00           C  
ATOM    104  H   LEU A  10      38.573  77.692  -2.698  1.00  0.00           H  
ATOM    105  HA  LEU A  10      38.751  77.163   0.103  1.00  0.00           H  
ATOM    106  HB2 LEU A  10      38.519  75.563  -2.007  1.00  0.00           H  
ATOM    107  HB3 LEU A  10      40.267  75.532  -1.871  1.00  0.00           H  
ATOM    108  HG  LEU A  10      39.910  74.859   0.569  1.00  0.00           H  
ATOM    109 HD11 LEU A  10      37.287  73.752  -0.204  1.00  0.00           H  
ATOM    110 HD12 LEU A  10      37.335  75.479   0.147  1.00  0.00           H  
ATOM    111 HD13 LEU A  10      37.868  74.318   1.363  1.00  0.00           H  
ATOM    112 HD21 LEU A  10      39.273  73.133  -1.798  1.00  0.00           H  
ATOM    113 HD22 LEU A  10      39.301  72.469  -0.165  1.00  0.00           H  
ATOM    114 HD23 LEU A  10      40.753  73.207  -0.840  1.00  0.00           H  
ATOM    115  N   GLU A  11      41.089  77.633   0.786  1.00  0.00           N  
ATOM    116  CA  GLU A  11      42.419  78.052   1.213  1.00  0.00           C  
ATOM    117  C   GLU A  11      43.487  77.104   0.679  1.00  0.00           C  
ATOM    118  O   GLU A  11      43.350  75.884   0.770  1.00  0.00           O  
ATOM    119  CB  GLU A  11      42.493  78.114   2.740  1.00  0.00           C  
ATOM    120  CG  GLU A  11      41.755  79.301   3.337  1.00  0.00           C  
ATOM    121  CD  GLU A  11      42.545  79.986   4.436  1.00  0.00           C  
ATOM    122  OE1 GLU A  11      43.324  80.909   4.120  1.00  0.00           O  
ATOM    123  OE2 GLU A  11      42.384  79.599   5.612  1.00  0.00           O  
ATOM    124  H   GLU A  11      40.426  77.385   1.464  1.00  0.00           H  
ATOM    125  HA  GLU A  11      42.599  79.040   0.814  1.00  0.00           H  
ATOM    126  HB2 GLU A  11      42.064  77.210   3.146  1.00  0.00           H  
ATOM    127  HB3 GLU A  11      43.530  78.174   3.036  1.00  0.00           H  
ATOM    128  HG2 GLU A  11      41.561  80.019   2.554  1.00  0.00           H  
ATOM    129  HG3 GLU A  11      40.819  78.957   3.748  1.00  0.00           H  
ATOM    130  N   ILE A  12      44.551  77.673   0.120  1.00  0.00           N  
ATOM    131  CA  ILE A  12      45.642  76.877  -0.429  1.00  0.00           C  
ATOM    132  C   ILE A  12      46.570  76.380   0.674  1.00  0.00           C  
ATOM    133  O   ILE A  12      46.777  77.062   1.679  1.00  0.00           O  
ATOM    134  CB  ILE A  12      46.465  77.682  -1.452  1.00  0.00           C  
ATOM    135  CG1 ILE A  12      45.540  78.365  -2.460  1.00  0.00           C  
ATOM    136  CG2 ILE A  12      47.458  76.776  -2.164  1.00  0.00           C  
ATOM    137  CD1 ILE A  12      44.756  77.393  -3.317  1.00  0.00           C  
ATOM    138  H   ILE A  12      44.603  78.650   0.077  1.00  0.00           H  
ATOM    139  HA  ILE A  12      45.212  76.024  -0.935  1.00  0.00           H  
ATOM    140  HB  ILE A  12      47.024  78.437  -0.917  1.00  0.00           H  
ATOM    141 HG12 ILE A  12      44.832  78.983  -1.929  1.00  0.00           H  
ATOM    142 HG13 ILE A  12      46.130  78.986  -3.118  1.00  0.00           H  
ATOM    143 HG21 ILE A  12      48.214  76.450  -1.466  1.00  0.00           H  
ATOM    144 HG22 ILE A  12      47.925  77.318  -2.972  1.00  0.00           H  
ATOM    145 HG23 ILE A  12      46.939  75.915  -2.561  1.00  0.00           H  
ATOM    146 HD11 ILE A  12      44.578  77.832  -4.287  1.00  0.00           H  
ATOM    147 HD12 ILE A  12      43.812  77.174  -2.840  1.00  0.00           H  
ATOM    148 HD13 ILE A  12      45.322  76.480  -3.433  1.00  0.00           H  
ATOM    149  N   ASN A  13      47.126  75.189   0.481  1.00  0.00           N  
ATOM    150  CA  ASN A  13      48.034  74.601   1.460  1.00  0.00           C  
ATOM    151  C   ASN A  13      47.331  74.400   2.799  1.00  0.00           C  
ATOM    152  O   ASN A  13      47.958  74.471   3.857  1.00  0.00           O  
ATOM    153  CB  ASN A  13      49.264  75.490   1.646  1.00  0.00           C  
ATOM    154  CG  ASN A  13      50.309  75.262   0.570  1.00  0.00           C  
ATOM    155  OD1 ASN A  13      50.582  76.145  -0.242  1.00  0.00           O  
ATOM    156  ND2 ASN A  13      50.898  74.072   0.562  1.00  0.00           N  
ATOM    157  H   ASN A  13      46.923  74.694  -0.339  1.00  0.00           H  
ATOM    158  HA  ASN A  13      48.347  73.639   1.085  1.00  0.00           H  
ATOM    159  HB2 ASN A  13      48.961  76.526   1.613  1.00  0.00           H  
ATOM    160  HB3 ASN A  13      49.710  75.280   2.607  1.00  0.00           H  
ATOM    161 HD21 ASN A  13      50.630  73.417   1.240  1.00  0.00           H  
ATOM    162 HD22 ASN A  13      51.578  73.898  -0.122  1.00  0.00           H  
ATOM    163  N   SER A  14      46.027  74.147   2.747  1.00  0.00           N  
ATOM    164  CA  SER A  14      45.240  73.933   3.956  1.00  0.00           C  
ATOM    165  C   SER A  14      44.829  72.470   4.087  1.00  0.00           C  
ATOM    166  O   SER A  14      45.161  71.644   3.237  1.00  0.00           O  
ATOM    167  CB  SER A  14      43.998  74.826   3.945  1.00  0.00           C  
ATOM    168  OG  SER A  14      44.345  76.186   4.148  1.00  0.00           O  
ATOM    169  H   SER A  14      45.585  74.101   1.875  1.00  0.00           H  
ATOM    170  HA  SER A  14      45.855  74.199   4.804  1.00  0.00           H  
ATOM    171  HB2 SER A  14      43.500  74.735   2.991  1.00  0.00           H  
ATOM    172  HB3 SER A  14      43.327  74.516   4.733  1.00  0.00           H  
ATOM    173  HG  SER A  14      44.618  76.313   5.059  1.00  0.00           H  
ATOM    174  N   ARG A  15      44.104  72.159   5.156  1.00  0.00           N  
ATOM    175  CA  ARG A  15      43.646  70.795   5.399  1.00  0.00           C  
ATOM    176  C   ARG A  15      42.135  70.690   5.228  1.00  0.00           C  
ATOM    177  O   ARG A  15      41.372  71.355   5.932  1.00  0.00           O  
ATOM    178  CB  ARG A  15      44.047  70.343   6.804  1.00  0.00           C  
ATOM    179  CG  ARG A  15      45.347  69.554   6.841  1.00  0.00           C  
ATOM    180  CD  ARG A  15      45.171  68.160   6.258  1.00  0.00           C  
ATOM    181  NE  ARG A  15      45.172  67.129   7.291  1.00  0.00           N  
ATOM    182  CZ  ARG A  15      46.269  66.705   7.915  1.00  0.00           C  
ATOM    183  NH1 ARG A  15      47.454  67.220   7.611  1.00  0.00           N  
ATOM    184  NH2 ARG A  15      46.182  65.763   8.843  1.00  0.00           N  
ATOM    185  H   ARG A  15      43.871  72.862   5.798  1.00  0.00           H  
ATOM    186  HA  ARG A  15      44.124  70.152   4.673  1.00  0.00           H  
ATOM    187  HB2 ARG A  15      44.164  71.214   7.431  1.00  0.00           H  
ATOM    188  HB3 ARG A  15      43.263  69.721   7.209  1.00  0.00           H  
ATOM    189  HG2 ARG A  15      46.094  70.081   6.266  1.00  0.00           H  
ATOM    190  HG3 ARG A  15      45.674  69.466   7.867  1.00  0.00           H  
ATOM    191  HD2 ARG A  15      44.232  68.121   5.726  1.00  0.00           H  
ATOM    192  HD3 ARG A  15      45.981  67.968   5.569  1.00  0.00           H  
ATOM    193  HE  ARG A  15      44.309  66.732   7.536  1.00  0.00           H  
ATOM    194 HH11 ARG A  15      47.527  67.932   6.912  1.00  0.00           H  
ATOM    195 HH12 ARG A  15      48.275  66.898   8.083  1.00  0.00           H  
ATOM    196 HH21 ARG A  15      45.291  65.371   9.076  1.00  0.00           H  
ATOM    197 HH22 ARG A  15      47.006  65.444   9.311  1.00  0.00           H  
ATOM    198  N   VAL A  16      41.707  69.853   4.290  1.00  0.00           N  
ATOM    199  CA  VAL A  16      40.286  69.660   4.026  1.00  0.00           C  
ATOM    200  C   VAL A  16      39.992  68.218   3.621  1.00  0.00           C  
ATOM    201  O   VAL A  16      40.816  67.565   2.980  1.00  0.00           O  
ATOM    202  CB  VAL A  16      39.785  70.604   2.918  1.00  0.00           C  
ATOM    203  CG1 VAL A  16      39.893  72.055   3.363  1.00  0.00           C  
ATOM    204  CG2 VAL A  16      40.560  70.375   1.629  1.00  0.00           C  
ATOM    205  H   VAL A  16      42.362  69.351   3.761  1.00  0.00           H  
ATOM    206  HA  VAL A  16      39.744  69.884   4.934  1.00  0.00           H  
ATOM    207  HB  VAL A  16      38.743  70.386   2.730  1.00  0.00           H  
ATOM    208 HG11 VAL A  16      39.601  72.136   4.399  1.00  0.00           H  
ATOM    209 HG12 VAL A  16      39.242  72.666   2.755  1.00  0.00           H  
ATOM    210 HG13 VAL A  16      40.912  72.390   3.249  1.00  0.00           H  
ATOM    211 HG21 VAL A  16      41.619  70.375   1.841  1.00  0.00           H  
ATOM    212 HG22 VAL A  16      40.333  71.162   0.927  1.00  0.00           H  
ATOM    213 HG23 VAL A  16      40.279  69.421   1.204  1.00  0.00           H  
ATOM    214  N   SER A  17      38.818  67.727   4.000  1.00  0.00           N  
ATOM    215  CA  SER A  17      38.418  66.362   3.677  1.00  0.00           C  
ATOM    216  C   SER A  17      37.635  66.317   2.369  1.00  0.00           C  
ATOM    217  O   SER A  17      37.329  67.353   1.780  1.00  0.00           O  
ATOM    218  CB  SER A  17      37.576  65.775   4.810  1.00  0.00           C  
ATOM    219  OG  SER A  17      37.816  66.454   6.030  1.00  0.00           O  
ATOM    220  H   SER A  17      38.204  68.296   4.511  1.00  0.00           H  
ATOM    221  HA  SER A  17      39.316  65.773   3.564  1.00  0.00           H  
ATOM    222  HB2 SER A  17      36.530  65.866   4.563  1.00  0.00           H  
ATOM    223  HB3 SER A  17      37.827  64.731   4.938  1.00  0.00           H  
ATOM    224  HG  SER A  17      38.254  65.862   6.645  1.00  0.00           H  
ATOM    225  N   LEU A  18      37.313  65.108   1.920  1.00  0.00           N  
ATOM    226  CA  LEU A  18      36.565  64.924   0.683  1.00  0.00           C  
ATOM    227  C   LEU A  18      35.528  63.815   0.833  1.00  0.00           C  
ATOM    228  O   LEU A  18      35.825  62.739   1.355  1.00  0.00           O  
ATOM    229  CB  LEU A  18      37.518  64.598  -0.470  1.00  0.00           C  
ATOM    230  CG  LEU A  18      37.733  65.734  -1.474  1.00  0.00           C  
ATOM    231  CD1 LEU A  18      38.696  65.304  -2.567  1.00  0.00           C  
ATOM    232  CD2 LEU A  18      36.404  66.173  -2.071  1.00  0.00           C  
ATOM    233  H   LEU A  18      37.586  64.319   2.436  1.00  0.00           H  
ATOM    234  HA  LEU A  18      36.055  65.850   0.464  1.00  0.00           H  
ATOM    235  HB2 LEU A  18      38.478  64.331  -0.051  1.00  0.00           H  
ATOM    236  HB3 LEU A  18      37.129  63.745  -1.006  1.00  0.00           H  
ATOM    237  HG  LEU A  18      38.166  66.580  -0.961  1.00  0.00           H  
ATOM    238 HD11 LEU A  18      38.348  64.384  -3.013  1.00  0.00           H  
ATOM    239 HD12 LEU A  18      39.677  65.150  -2.144  1.00  0.00           H  
ATOM    240 HD13 LEU A  18      38.748  66.073  -3.325  1.00  0.00           H  
ATOM    241 HD21 LEU A  18      35.832  66.705  -1.326  1.00  0.00           H  
ATOM    242 HD22 LEU A  18      35.851  65.304  -2.396  1.00  0.00           H  
ATOM    243 HD23 LEU A  18      36.587  66.820  -2.916  1.00  0.00           H  
ATOM    244  N   LYS A  19      34.311  64.085   0.373  1.00  0.00           N  
ATOM    245  CA  LYS A  19      33.229  63.109   0.457  1.00  0.00           C  
ATOM    246  C   LYS A  19      33.351  62.063  -0.648  1.00  0.00           C  
ATOM    247  O   LYS A  19      32.888  62.271  -1.769  1.00  0.00           O  
ATOM    248  CB  LYS A  19      31.874  63.813   0.360  1.00  0.00           C  
ATOM    249  CG  LYS A  19      30.692  62.903   0.651  1.00  0.00           C  
ATOM    250  CD  LYS A  19      29.397  63.692   0.773  1.00  0.00           C  
ATOM    251  CE  LYS A  19      29.002  63.901   2.226  1.00  0.00           C  
ATOM    252  NZ  LYS A  19      29.029  65.340   2.608  1.00  0.00           N  
ATOM    253  H   LYS A  19      34.135  64.959  -0.032  1.00  0.00           H  
ATOM    254  HA  LYS A  19      33.300  62.616   1.414  1.00  0.00           H  
ATOM    255  HB2 LYS A  19      31.854  64.631   1.065  1.00  0.00           H  
ATOM    256  HB3 LYS A  19      31.757  64.209  -0.639  1.00  0.00           H  
ATOM    257  HG2 LYS A  19      30.592  62.189  -0.153  1.00  0.00           H  
ATOM    258  HG3 LYS A  19      30.874  62.380   1.578  1.00  0.00           H  
ATOM    259  HD2 LYS A  19      29.529  64.656   0.305  1.00  0.00           H  
ATOM    260  HD3 LYS A  19      28.609  63.151   0.270  1.00  0.00           H  
ATOM    261  HE2 LYS A  19      28.003  63.519   2.373  1.00  0.00           H  
ATOM    262  HE3 LYS A  19      29.692  63.357   2.856  1.00  0.00           H  
ATOM    263  HZ1 LYS A  19      29.930  65.571   3.072  1.00  0.00           H  
ATOM    264  HZ2 LYS A  19      28.250  65.552   3.264  1.00  0.00           H  
ATOM    265  HZ3 LYS A  19      28.924  65.936   1.761  1.00  0.00           H  
ATOM    266  N   VAL A  20      33.980  60.939  -0.322  1.00  0.00           N  
ATOM    267  CA  VAL A  20      34.163  59.859  -1.285  1.00  0.00           C  
ATOM    268  C   VAL A  20      33.211  58.703  -1.002  1.00  0.00           C  
ATOM    269  O   VAL A  20      33.224  58.124   0.084  1.00  0.00           O  
ATOM    270  CB  VAL A  20      35.609  59.330  -1.268  1.00  0.00           C  
ATOM    271  CG1 VAL A  20      36.547  60.315  -1.951  1.00  0.00           C  
ATOM    272  CG2 VAL A  20      36.062  59.056   0.158  1.00  0.00           C  
ATOM    273  H   VAL A  20      34.327  60.831   0.588  1.00  0.00           H  
ATOM    274  HA  VAL A  20      33.957  60.252  -2.269  1.00  0.00           H  
ATOM    275  HB  VAL A  20      35.638  58.401  -1.817  1.00  0.00           H  
ATOM    276 HG11 VAL A  20      36.056  60.739  -2.814  1.00  0.00           H  
ATOM    277 HG12 VAL A  20      37.443  59.800  -2.264  1.00  0.00           H  
ATOM    278 HG13 VAL A  20      36.806  61.104  -1.261  1.00  0.00           H  
ATOM    279 HG21 VAL A  20      36.655  58.153   0.180  1.00  0.00           H  
ATOM    280 HG22 VAL A  20      35.196  58.932   0.792  1.00  0.00           H  
ATOM    281 HG23 VAL A  20      36.654  59.885   0.515  1.00  0.00           H  
ATOM    282  N   GLY A  21      32.381  58.372  -1.987  1.00  0.00           N  
ATOM    283  CA  GLY A  21      31.433  57.286  -1.823  1.00  0.00           C  
ATOM    284  C   GLY A  21      30.468  57.526  -0.678  1.00  0.00           C  
ATOM    285  O   GLY A  21      29.590  58.383  -0.766  1.00  0.00           O  
ATOM    286  H   GLY A  21      32.415  58.868  -2.831  1.00  0.00           H  
ATOM    287  HA2 GLY A  21      30.867  57.177  -2.737  1.00  0.00           H  
ATOM    288  HA3 GLY A  21      31.976  56.372  -1.637  1.00  0.00           H  
ATOM    289  N   GLU A  22      30.634  56.768   0.401  1.00  0.00           N  
ATOM    290  CA  GLU A  22      29.774  56.903   1.572  1.00  0.00           C  
ATOM    291  C   GLU A  22      30.589  57.268   2.809  1.00  0.00           C  
ATOM    292  O   GLU A  22      30.202  56.950   3.933  1.00  0.00           O  
ATOM    293  CB  GLU A  22      29.005  55.603   1.817  1.00  0.00           C  
ATOM    294  CG  GLU A  22      27.884  55.361   0.819  1.00  0.00           C  
ATOM    295  CD  GLU A  22      27.996  54.017   0.127  1.00  0.00           C  
ATOM    296  OE1 GLU A  22      29.117  53.652  -0.283  1.00  0.00           O  
ATOM    297  OE2 GLU A  22      26.962  53.330  -0.004  1.00  0.00           O  
ATOM    298  H   GLU A  22      31.355  56.103   0.412  1.00  0.00           H  
ATOM    299  HA  GLU A  22      29.069  57.696   1.374  1.00  0.00           H  
ATOM    300  HB2 GLU A  22      29.696  54.775   1.759  1.00  0.00           H  
ATOM    301  HB3 GLU A  22      28.577  55.634   2.808  1.00  0.00           H  
ATOM    302  HG2 GLU A  22      26.941  55.403   1.342  1.00  0.00           H  
ATOM    303  HG3 GLU A  22      27.913  56.139   0.070  1.00  0.00           H  
ATOM    304  N   THR A  23      31.717  57.937   2.594  1.00  0.00           N  
ATOM    305  CA  THR A  23      32.585  58.344   3.691  1.00  0.00           C  
ATOM    306  C   THR A  23      33.441  59.541   3.291  1.00  0.00           C  
ATOM    307  O   THR A  23      33.502  59.908   2.119  1.00  0.00           O  
ATOM    308  CB  THR A  23      33.481  57.180   4.116  1.00  0.00           C  
ATOM    309  OG1 THR A  23      34.467  57.613   5.037  1.00  0.00           O  
ATOM    310  CG2 THR A  23      34.192  56.516   2.955  1.00  0.00           C  
ATOM    311  H   THR A  23      31.972  58.162   1.675  1.00  0.00           H  
ATOM    312  HA  THR A  23      31.958  58.626   4.523  1.00  0.00           H  
ATOM    313  HB  THR A  23      32.871  56.432   4.599  1.00  0.00           H  
ATOM    314  HG1 THR A  23      35.159  58.088   4.570  1.00  0.00           H  
ATOM    315 HG21 THR A  23      33.717  56.807   2.028  1.00  0.00           H  
ATOM    316 HG22 THR A  23      34.139  55.443   3.066  1.00  0.00           H  
ATOM    317 HG23 THR A  23      35.226  56.827   2.941  1.00  0.00           H  
ATOM    318  N   ILE A  24      34.100  60.144   4.274  1.00  0.00           N  
ATOM    319  CA  ILE A  24      34.954  61.301   4.025  1.00  0.00           C  
ATOM    320  C   ILE A  24      36.424  60.949   4.225  1.00  0.00           C  
ATOM    321  O   ILE A  24      36.755  60.033   4.979  1.00  0.00           O  
ATOM    322  CB  ILE A  24      34.591  62.483   4.945  1.00  0.00           C  
ATOM    323  CG1 ILE A  24      33.072  62.611   5.087  1.00  0.00           C  
ATOM    324  CG2 ILE A  24      35.186  63.774   4.405  1.00  0.00           C  
ATOM    325  CD1 ILE A  24      32.366  62.901   3.780  1.00  0.00           C  
ATOM    326  H   ILE A  24      34.012  59.803   5.188  1.00  0.00           H  
ATOM    327  HA  ILE A  24      34.805  61.609   2.999  1.00  0.00           H  
ATOM    328  HB  ILE A  24      35.022  62.298   5.917  1.00  0.00           H  
ATOM    329 HG12 ILE A  24      32.675  61.686   5.478  1.00  0.00           H  
ATOM    330 HG13 ILE A  24      32.847  63.413   5.773  1.00  0.00           H  
ATOM    331 HG21 ILE A  24      36.257  63.670   4.320  1.00  0.00           H  
ATOM    332 HG22 ILE A  24      34.956  64.587   5.079  1.00  0.00           H  
ATOM    333 HG23 ILE A  24      34.766  63.984   3.432  1.00  0.00           H  
ATOM    334 HD11 ILE A  24      32.337  62.005   3.179  1.00  0.00           H  
ATOM    335 HD12 ILE A  24      32.899  63.675   3.247  1.00  0.00           H  
ATOM    336 HD13 ILE A  24      31.358  63.233   3.981  1.00  0.00           H  
ATOM    337  N   GLU A  25      37.302  61.681   3.546  1.00  0.00           N  
ATOM    338  CA  GLU A  25      38.737  61.444   3.653  1.00  0.00           C  
ATOM    339  C   GLU A  25      39.499  62.758   3.782  1.00  0.00           C  
ATOM    340  O   GLU A  25      39.459  63.600   2.885  1.00  0.00           O  
ATOM    341  CB  GLU A  25      39.238  60.667   2.433  1.00  0.00           C  
ATOM    342  CG  GLU A  25      39.204  59.159   2.617  1.00  0.00           C  
ATOM    343  CD  GLU A  25      40.280  58.663   3.565  1.00  0.00           C  
ATOM    344  OE1 GLU A  25      41.304  59.362   3.718  1.00  0.00           O  
ATOM    345  OE2 GLU A  25      40.097  57.577   4.155  1.00  0.00           O  
ATOM    346  H   GLU A  25      36.977  62.397   2.962  1.00  0.00           H  
ATOM    347  HA  GLU A  25      38.911  60.853   4.540  1.00  0.00           H  
ATOM    348  HB2 GLU A  25      38.623  60.918   1.583  1.00  0.00           H  
ATOM    349  HB3 GLU A  25      40.257  60.960   2.228  1.00  0.00           H  
ATOM    350  HG2 GLU A  25      38.241  58.878   3.015  1.00  0.00           H  
ATOM    351  HG3 GLU A  25      39.347  58.688   1.656  1.00  0.00           H  
ATOM    352  N   SER A  26      40.191  62.928   4.903  1.00  0.00           N  
ATOM    353  CA  SER A  26      40.963  64.140   5.150  1.00  0.00           C  
ATOM    354  C   SER A  26      42.057  64.310   4.101  1.00  0.00           C  
ATOM    355  O   SER A  26      42.689  63.339   3.684  1.00  0.00           O  
ATOM    356  CB  SER A  26      41.582  64.100   6.548  1.00  0.00           C  
ATOM    357  OG  SER A  26      40.596  64.291   7.548  1.00  0.00           O  
ATOM    358  H   SER A  26      40.184  62.220   5.580  1.00  0.00           H  
ATOM    359  HA  SER A  26      40.288  64.981   5.088  1.00  0.00           H  
ATOM    360  HB2 SER A  26      42.054  63.141   6.703  1.00  0.00           H  
ATOM    361  HB3 SER A  26      42.321  64.883   6.634  1.00  0.00           H  
ATOM    362  HG  SER A  26      40.367  65.221   7.599  1.00  0.00           H  
ATOM    363  N   GLY A  27      42.277  65.551   3.678  1.00  0.00           N  
ATOM    364  CA  GLY A  27      43.297  65.825   2.681  1.00  0.00           C  
ATOM    365  C   GLY A  27      43.811  67.250   2.755  1.00  0.00           C  
ATOM    366  O   GLY A  27      43.420  68.013   3.639  1.00  0.00           O  
ATOM    367  H   GLY A  27      41.743  66.286   4.046  1.00  0.00           H  
ATOM    368  HA2 GLY A  27      44.123  65.148   2.833  1.00  0.00           H  
ATOM    369  HA3 GLY A  27      42.880  65.654   1.700  1.00  0.00           H  
ATOM    370  N   THR A  28      44.689  67.608   1.824  1.00  0.00           N  
ATOM    371  CA  THR A  28      45.258  68.951   1.786  1.00  0.00           C  
ATOM    372  C   THR A  28      44.899  69.657   0.484  1.00  0.00           C  
ATOM    373  O   THR A  28      44.666  69.014  -0.539  1.00  0.00           O  
ATOM    374  CB  THR A  28      46.778  68.886   1.941  1.00  0.00           C  
ATOM    375  OG1 THR A  28      47.151  67.814   2.789  1.00  0.00           O  
ATOM    376  CG2 THR A  28      47.375  70.152   2.515  1.00  0.00           C  
ATOM    377  H   THR A  28      44.961  66.955   1.147  1.00  0.00           H  
ATOM    378  HA  THR A  28      44.845  69.510   2.612  1.00  0.00           H  
ATOM    379  HB  THR A  28      47.222  68.720   0.971  1.00  0.00           H  
ATOM    380  HG1 THR A  28      46.969  66.981   2.350  1.00  0.00           H  
ATOM    381 HG21 THR A  28      47.128  70.988   1.876  1.00  0.00           H  
ATOM    382 HG22 THR A  28      48.450  70.050   2.575  1.00  0.00           H  
ATOM    383 HG23 THR A  28      46.975  70.325   3.502  1.00  0.00           H  
ATOM    384  N   VAL A  29      44.857  70.984   0.529  1.00  0.00           N  
ATOM    385  CA  VAL A  29      44.526  71.779  -0.648  1.00  0.00           C  
ATOM    386  C   VAL A  29      45.779  72.125  -1.445  1.00  0.00           C  
ATOM    387  O   VAL A  29      46.857  72.310  -0.880  1.00  0.00           O  
ATOM    388  CB  VAL A  29      43.801  73.082  -0.263  1.00  0.00           C  
ATOM    389  CG1 VAL A  29      43.278  73.790  -1.503  1.00  0.00           C  
ATOM    390  CG2 VAL A  29      42.672  72.797   0.715  1.00  0.00           C  
ATOM    391  H   VAL A  29      45.053  71.441   1.374  1.00  0.00           H  
ATOM    392  HA  VAL A  29      43.865  71.193  -1.270  1.00  0.00           H  
ATOM    393  HB  VAL A  29      44.512  73.735   0.223  1.00  0.00           H  
ATOM    394 HG11 VAL A  29      44.108  74.186  -2.069  1.00  0.00           H  
ATOM    395 HG12 VAL A  29      42.626  74.599  -1.208  1.00  0.00           H  
ATOM    396 HG13 VAL A  29      42.729  73.088  -2.114  1.00  0.00           H  
ATOM    397 HG21 VAL A  29      42.125  73.708   0.907  1.00  0.00           H  
ATOM    398 HG22 VAL A  29      43.081  72.420   1.640  1.00  0.00           H  
ATOM    399 HG23 VAL A  29      42.005  72.061   0.289  1.00  0.00           H  
ATOM    400  N   ILE A  30      45.630  72.210  -2.764  1.00  0.00           N  
ATOM    401  CA  ILE A  30      46.751  72.534  -3.639  1.00  0.00           C  
ATOM    402  C   ILE A  30      46.277  73.246  -4.901  1.00  0.00           C  
ATOM    403  O   ILE A  30      46.882  74.226  -5.337  1.00  0.00           O  
ATOM    404  CB  ILE A  30      47.537  71.270  -4.037  1.00  0.00           C  
ATOM    405  CG1 ILE A  30      46.593  70.214  -4.614  1.00  0.00           C  
ATOM    406  CG2 ILE A  30      48.294  70.718  -2.839  1.00  0.00           C  
ATOM    407  CD1 ILE A  30      47.285  68.919  -4.985  1.00  0.00           C  
ATOM    408  H   ILE A  30      44.747  72.053  -3.156  1.00  0.00           H  
ATOM    409  HA  ILE A  30      47.417  73.189  -3.098  1.00  0.00           H  
ATOM    410  HB  ILE A  30      48.259  71.547  -4.792  1.00  0.00           H  
ATOM    411 HG12 ILE A  30      45.832  69.983  -3.883  1.00  0.00           H  
ATOM    412 HG13 ILE A  30      46.123  70.605  -5.503  1.00  0.00           H  
ATOM    413 HG21 ILE A  30      49.208  70.251  -3.174  1.00  0.00           H  
ATOM    414 HG22 ILE A  30      47.680  69.989  -2.331  1.00  0.00           H  
ATOM    415 HG23 ILE A  30      48.529  71.526  -2.159  1.00  0.00           H  
ATOM    416 HD11 ILE A  30      48.355  69.069  -4.979  1.00  0.00           H  
ATOM    417 HD12 ILE A  30      46.969  68.613  -5.971  1.00  0.00           H  
ATOM    418 HD13 ILE A  30      47.025  68.153  -4.269  1.00  0.00           H  
ATOM    419  N   PHE A  31      45.190  72.749  -5.487  1.00  0.00           N  
ATOM    420  CA  PHE A  31      44.637  73.340  -6.700  1.00  0.00           C  
ATOM    421  C   PHE A  31      43.143  73.603  -6.542  1.00  0.00           C  
ATOM    422  O   PHE A  31      42.411  72.777  -5.996  1.00  0.00           O  
ATOM    423  CB  PHE A  31      44.882  72.422  -7.898  1.00  0.00           C  
ATOM    424  CG  PHE A  31      44.545  73.053  -9.217  1.00  0.00           C  
ATOM    425  CD1 PHE A  31      45.330  74.070  -9.735  1.00  0.00           C  
ATOM    426  CD2 PHE A  31      43.441  72.630  -9.940  1.00  0.00           C  
ATOM    427  CE1 PHE A  31      45.021  74.653 -10.950  1.00  0.00           C  
ATOM    428  CE2 PHE A  31      43.126  73.208 -11.156  1.00  0.00           C  
ATOM    429  CZ  PHE A  31      43.918  74.222 -11.661  1.00  0.00           C  
ATOM    430  H   PHE A  31      44.750  71.967  -5.093  1.00  0.00           H  
ATOM    431  HA  PHE A  31      45.140  74.280  -6.869  1.00  0.00           H  
ATOM    432  HB2 PHE A  31      45.926  72.143  -7.921  1.00  0.00           H  
ATOM    433  HB3 PHE A  31      44.280  71.532  -7.789  1.00  0.00           H  
ATOM    434  HD1 PHE A  31      46.193  74.409  -9.180  1.00  0.00           H  
ATOM    435  HD2 PHE A  31      42.821  71.838  -9.546  1.00  0.00           H  
ATOM    436  HE1 PHE A  31      45.642  75.446 -11.343  1.00  0.00           H  
ATOM    437  HE2 PHE A  31      42.263  72.869 -11.709  1.00  0.00           H  
ATOM    438  HZ  PHE A  31      43.675  74.676 -12.610  1.00  0.00           H  
ATOM    439  N   CYS A  32      42.696  74.757  -7.025  1.00  0.00           N  
ATOM    440  CA  CYS A  32      41.289  75.129  -6.940  1.00  0.00           C  
ATOM    441  C   CYS A  32      40.903  76.069  -8.077  1.00  0.00           C  
ATOM    442  O   CYS A  32      41.135  77.275  -8.006  1.00  0.00           O  
ATOM    443  CB  CYS A  32      40.998  75.793  -5.593  1.00  0.00           C  
ATOM    444  SG  CYS A  32      39.238  75.921  -5.198  1.00  0.00           S  
ATOM    445  H   CYS A  32      43.327  75.375  -7.451  1.00  0.00           H  
ATOM    446  HA  CYS A  32      40.703  74.225  -7.020  1.00  0.00           H  
ATOM    447  HB2 CYS A  32      41.469  75.220  -4.807  1.00  0.00           H  
ATOM    448  HB3 CYS A  32      41.408  76.792  -5.598  1.00  0.00           H  
ATOM    449  HG  CYS A  32      38.799  76.345  -5.938  1.00  0.00           H  
ATOM    450  N   ASP A  33      40.314  75.507  -9.128  1.00  0.00           N  
ATOM    451  CA  ASP A  33      39.896  76.295 -10.282  1.00  0.00           C  
ATOM    452  C   ASP A  33      38.887  75.526 -11.128  1.00  0.00           C  
ATOM    453  O   ASP A  33      38.429  74.451 -10.741  1.00  0.00           O  
ATOM    454  CB  ASP A  33      41.111  76.674 -11.132  1.00  0.00           C  
ATOM    455  CG  ASP A  33      41.538  78.114 -10.919  1.00  0.00           C  
ATOM    456  OD1 ASP A  33      40.657  79.000 -10.909  1.00  0.00           O  
ATOM    457  OD2 ASP A  33      42.753  78.355 -10.760  1.00  0.00           O  
ATOM    458  H   ASP A  33      40.156  74.540  -9.128  1.00  0.00           H  
ATOM    459  HA  ASP A  33      39.428  77.197  -9.916  1.00  0.00           H  
ATOM    460  HB2 ASP A  33      41.938  76.032 -10.873  1.00  0.00           H  
ATOM    461  HB3 ASP A  33      40.869  76.541 -12.177  1.00  0.00           H  
ATOM    462  N   VAL A  34      38.546  76.083 -12.285  1.00  0.00           N  
ATOM    463  CA  VAL A  34      37.591  75.449 -13.187  1.00  0.00           C  
ATOM    464  C   VAL A  34      38.304  74.605 -14.238  1.00  0.00           C  
ATOM    465  O   VAL A  34      39.532  74.521 -14.251  1.00  0.00           O  
ATOM    466  CB  VAL A  34      36.709  76.493 -13.897  1.00  0.00           C  
ATOM    467  CG1 VAL A  34      35.824  77.218 -12.894  1.00  0.00           C  
ATOM    468  CG2 VAL A  34      37.569  77.482 -14.669  1.00  0.00           C  
ATOM    469  H   VAL A  34      38.944  76.941 -12.539  1.00  0.00           H  
ATOM    470  HA  VAL A  34      36.950  74.808 -12.599  1.00  0.00           H  
ATOM    471  HB  VAL A  34      36.070  75.978 -14.599  1.00  0.00           H  
ATOM    472 HG11 VAL A  34      36.263  78.175 -12.652  1.00  0.00           H  
ATOM    473 HG12 VAL A  34      35.737  76.624 -11.996  1.00  0.00           H  
ATOM    474 HG13 VAL A  34      34.845  77.369 -13.321  1.00  0.00           H  
ATOM    475 HG21 VAL A  34      36.998  77.894 -15.488  1.00  0.00           H  
ATOM    476 HG22 VAL A  34      38.439  76.973 -15.059  1.00  0.00           H  
ATOM    477 HG23 VAL A  34      37.882  78.279 -14.013  1.00  0.00           H  
ATOM    478  N   LEU A  35      37.526  73.986 -15.118  1.00  0.00           N  
ATOM    479  CA  LEU A  35      38.084  73.148 -16.173  1.00  0.00           C  
ATOM    480  C   LEU A  35      37.436  73.464 -17.519  1.00  0.00           C  
ATOM    481  O   LEU A  35      36.302  73.941 -17.576  1.00  0.00           O  
ATOM    482  CB  LEU A  35      37.889  71.669 -15.835  1.00  0.00           C  
ATOM    483  CG  LEU A  35      38.193  71.291 -14.384  1.00  0.00           C  
ATOM    484  CD1 LEU A  35      37.460  70.014 -14.001  1.00  0.00           C  
ATOM    485  CD2 LEU A  35      39.693  71.129 -14.181  1.00  0.00           C  
ATOM    486  H   LEU A  35      36.554  74.092 -15.056  1.00  0.00           H  
ATOM    487  HA  LEU A  35      39.142  73.357 -16.238  1.00  0.00           H  
ATOM    488  HB2 LEU A  35      36.864  71.404 -16.049  1.00  0.00           H  
ATOM    489  HB3 LEU A  35      38.534  71.087 -16.477  1.00  0.00           H  
ATOM    490  HG  LEU A  35      37.849  72.082 -13.734  1.00  0.00           H  
ATOM    491 HD11 LEU A  35      37.907  69.599 -13.111  1.00  0.00           H  
ATOM    492 HD12 LEU A  35      37.533  69.301 -14.808  1.00  0.00           H  
ATOM    493 HD13 LEU A  35      36.421  70.240 -13.812  1.00  0.00           H  
ATOM    494 HD21 LEU A  35      40.221  71.770 -14.872  1.00  0.00           H  
ATOM    495 HD22 LEU A  35      39.971  70.101 -14.357  1.00  0.00           H  
ATOM    496 HD23 LEU A  35      39.949  71.404 -13.168  1.00  0.00           H  
ATOM    497  N   PRO A  36      38.152  73.202 -18.627  1.00  0.00           N  
ATOM    498  CA  PRO A  36      37.642  73.462 -19.976  1.00  0.00           C  
ATOM    499  C   PRO A  36      36.270  72.836 -20.206  1.00  0.00           C  
ATOM    500  O   PRO A  36      36.068  71.649 -19.953  1.00  0.00           O  
ATOM    501  CB  PRO A  36      38.686  72.808 -20.886  1.00  0.00           C  
ATOM    502  CG  PRO A  36      39.940  72.808 -20.081  1.00  0.00           C  
ATOM    503  CD  PRO A  36      39.513  72.633 -18.650  1.00  0.00           C  
ATOM    504  HA  PRO A  36      37.591  74.520 -20.184  1.00  0.00           H  
ATOM    505  HB2 PRO A  36      38.374  71.804 -21.133  1.00  0.00           H  
ATOM    506  HB3 PRO A  36      38.797  73.389 -21.788  1.00  0.00           H  
ATOM    507  HG2 PRO A  36      40.572  71.987 -20.387  1.00  0.00           H  
ATOM    508  HG3 PRO A  36      40.456  73.748 -20.206  1.00  0.00           H  
ATOM    509  HD2 PRO A  36      39.498  71.586 -18.385  1.00  0.00           H  
ATOM    510  HD3 PRO A  36      40.170  73.182 -17.990  1.00  0.00           H  
ATOM    511  N   GLY A  37      35.330  73.643 -20.688  1.00  0.00           N  
ATOM    512  CA  GLY A  37      33.990  73.151 -20.944  1.00  0.00           C  
ATOM    513  C   GLY A  37      33.317  72.622 -19.691  1.00  0.00           C  
ATOM    514  O   GLY A  37      32.461  71.740 -19.763  1.00  0.00           O  
ATOM    515  H   GLY A  37      35.549  74.581 -20.871  1.00  0.00           H  
ATOM    516  HA2 GLY A  37      33.394  73.956 -21.346  1.00  0.00           H  
ATOM    517  HA3 GLY A  37      34.042  72.357 -21.673  1.00  0.00           H  
ATOM    518  N   LYS A  38      33.707  73.162 -18.540  1.00  0.00           N  
ATOM    519  CA  LYS A  38      33.135  72.739 -17.266  1.00  0.00           C  
ATOM    520  C   LYS A  38      33.095  73.899 -16.277  1.00  0.00           C  
ATOM    521  O   LYS A  38      33.206  73.698 -15.067  1.00  0.00           O  
ATOM    522  CB  LYS A  38      33.943  71.580 -16.681  1.00  0.00           C  
ATOM    523  CG  LYS A  38      33.466  70.212 -17.139  1.00  0.00           C  
ATOM    524  CD  LYS A  38      34.113  69.097 -16.333  1.00  0.00           C  
ATOM    525  CE  LYS A  38      33.809  67.731 -16.929  1.00  0.00           C  
ATOM    526  NZ  LYS A  38      34.890  66.749 -16.645  1.00  0.00           N  
ATOM    527  H   LYS A  38      34.392  73.862 -18.548  1.00  0.00           H  
ATOM    528  HA  LYS A  38      32.126  72.404 -17.451  1.00  0.00           H  
ATOM    529  HB2 LYS A  38      34.977  71.692 -16.975  1.00  0.00           H  
ATOM    530  HB3 LYS A  38      33.878  71.619 -15.604  1.00  0.00           H  
ATOM    531  HG2 LYS A  38      32.394  70.156 -17.015  1.00  0.00           H  
ATOM    532  HG3 LYS A  38      33.717  70.084 -18.182  1.00  0.00           H  
ATOM    533  HD2 LYS A  38      35.182  69.246 -16.327  1.00  0.00           H  
ATOM    534  HD3 LYS A  38      33.735  69.131 -15.322  1.00  0.00           H  
ATOM    535  HE2 LYS A  38      32.884  67.367 -16.507  1.00  0.00           H  
ATOM    536  HE3 LYS A  38      33.700  67.835 -17.998  1.00  0.00           H  
ATOM    537  HZ1 LYS A  38      35.757  67.015 -17.155  1.00  0.00           H  
ATOM    538  HZ2 LYS A  38      34.600  65.798 -16.952  1.00  0.00           H  
ATOM    539  HZ3 LYS A  38      35.093  66.725 -15.625  1.00  0.00           H  
ATOM    540  N   GLU A  39      32.935  75.111 -16.797  1.00  0.00           N  
ATOM    541  CA  GLU A  39      32.880  76.302 -15.958  1.00  0.00           C  
ATOM    542  C   GLU A  39      31.517  76.428 -15.285  1.00  0.00           C  
ATOM    543  O   GLU A  39      31.410  76.935 -14.168  1.00  0.00           O  
ATOM    544  CB  GLU A  39      33.168  77.552 -16.791  1.00  0.00           C  
ATOM    545  CG  GLU A  39      34.598  77.629 -17.299  1.00  0.00           C  
ATOM    546  CD  GLU A  39      34.860  78.878 -18.119  1.00  0.00           C  
ATOM    547  OE1 GLU A  39      34.237  79.919 -17.827  1.00  0.00           O  
ATOM    548  OE2 GLU A  39      35.688  78.812 -19.051  1.00  0.00           O  
ATOM    549  H   GLU A  39      32.853  75.207 -17.770  1.00  0.00           H  
ATOM    550  HA  GLU A  39      33.638  76.206 -15.195  1.00  0.00           H  
ATOM    551  HB2 GLU A  39      32.505  77.564 -17.643  1.00  0.00           H  
ATOM    552  HB3 GLU A  39      32.977  78.426 -16.185  1.00  0.00           H  
ATOM    553  HG2 GLU A  39      35.269  77.626 -16.452  1.00  0.00           H  
ATOM    554  HG3 GLU A  39      34.795  76.763 -17.915  1.00  0.00           H  
ATOM    555  N   SER A  40      30.478  75.961 -15.970  1.00  0.00           N  
ATOM    556  CA  SER A  40      29.122  76.020 -15.439  1.00  0.00           C  
ATOM    557  C   SER A  40      28.947  75.041 -14.283  1.00  0.00           C  
ATOM    558  O   SER A  40      28.153  75.276 -13.372  1.00  0.00           O  
ATOM    559  CB  SER A  40      28.107  75.714 -16.541  1.00  0.00           C  
ATOM    560  OG  SER A  40      26.955  76.527 -16.414  1.00  0.00           O  
ATOM    561  H   SER A  40      30.629  75.567 -16.855  1.00  0.00           H  
ATOM    562  HA  SER A  40      28.953  77.023 -15.074  1.00  0.00           H  
ATOM    563  HB2 SER A  40      28.559  75.899 -17.504  1.00  0.00           H  
ATOM    564  HB3 SER A  40      27.810  74.678 -16.475  1.00  0.00           H  
ATOM    565  HG  SER A  40      26.801  76.995 -17.239  1.00  0.00           H  
ATOM    566  N   LEU A  41      29.694  73.941 -14.326  1.00  0.00           N  
ATOM    567  CA  LEU A  41      29.621  72.926 -13.282  1.00  0.00           C  
ATOM    568  C   LEU A  41      29.963  73.519 -11.919  1.00  0.00           C  
ATOM    569  O   LEU A  41      29.394  73.127 -10.900  1.00  0.00           O  
ATOM    570  CB  LEU A  41      30.569  71.768 -13.600  1.00  0.00           C  
ATOM    571  CG  LEU A  41      30.020  70.731 -14.579  1.00  0.00           C  
ATOM    572  CD1 LEU A  41      31.034  69.619 -14.803  1.00  0.00           C  
ATOM    573  CD2 LEU A  41      28.705  70.162 -14.069  1.00  0.00           C  
ATOM    574  H   LEU A  41      30.308  73.810 -15.079  1.00  0.00           H  
ATOM    575  HA  LEU A  41      28.608  72.551 -13.254  1.00  0.00           H  
ATOM    576  HB2 LEU A  41      31.478  72.180 -14.015  1.00  0.00           H  
ATOM    577  HB3 LEU A  41      30.812  71.266 -12.676  1.00  0.00           H  
ATOM    578  HG  LEU A  41      29.832  71.207 -15.531  1.00  0.00           H  
ATOM    579 HD11 LEU A  41      30.934  68.879 -14.023  1.00  0.00           H  
ATOM    580 HD12 LEU A  41      32.031  70.031 -14.783  1.00  0.00           H  
ATOM    581 HD13 LEU A  41      30.853  69.156 -15.762  1.00  0.00           H  
ATOM    582 HD21 LEU A  41      28.621  69.127 -14.365  1.00  0.00           H  
ATOM    583 HD22 LEU A  41      27.882  70.723 -14.486  1.00  0.00           H  
ATOM    584 HD23 LEU A  41      28.677  70.230 -12.991  1.00  0.00           H  
ATOM    585  N   GLY A  42      30.896  74.466 -11.909  1.00  0.00           N  
ATOM    586  CA  GLY A  42      31.296  75.097 -10.665  1.00  0.00           C  
ATOM    587  C   GLY A  42      32.785  75.374 -10.609  1.00  0.00           C  
ATOM    588  O   GLY A  42      33.338  76.016 -11.502  1.00  0.00           O  
ATOM    589  H   GLY A  42      31.315  74.737 -12.752  1.00  0.00           H  
ATOM    590  HA2 GLY A  42      30.763  76.031 -10.560  1.00  0.00           H  
ATOM    591  HA3 GLY A  42      31.031  74.448  -9.843  1.00  0.00           H  
ATOM    592  N   TYR A  43      33.436  74.889  -9.557  1.00  0.00           N  
ATOM    593  CA  TYR A  43      34.871  75.088  -9.386  1.00  0.00           C  
ATOM    594  C   TYR A  43      35.527  73.844  -8.800  1.00  0.00           C  
ATOM    595  O   TYR A  43      35.453  73.600  -7.595  1.00  0.00           O  
ATOM    596  CB  TYR A  43      35.135  76.293  -8.481  1.00  0.00           C  
ATOM    597  CG  TYR A  43      35.239  77.603  -9.230  1.00  0.00           C  
ATOM    598  CD1 TYR A  43      36.459  78.045  -9.729  1.00  0.00           C  
ATOM    599  CD2 TYR A  43      34.119  78.398  -9.437  1.00  0.00           C  
ATOM    600  CE1 TYR A  43      36.557  79.241 -10.414  1.00  0.00           C  
ATOM    601  CE2 TYR A  43      34.210  79.596 -10.120  1.00  0.00           C  
ATOM    602  CZ  TYR A  43      35.431  80.013 -10.606  1.00  0.00           C  
ATOM    603  OH  TYR A  43      35.526  81.205 -11.286  1.00  0.00           O  
ATOM    604  H   TYR A  43      32.940  74.385  -8.878  1.00  0.00           H  
ATOM    605  HA  TYR A  43      35.296  75.280 -10.359  1.00  0.00           H  
ATOM    606  HB2 TYR A  43      34.330  76.383  -7.768  1.00  0.00           H  
ATOM    607  HB3 TYR A  43      36.063  76.139  -7.951  1.00  0.00           H  
ATOM    608  HD1 TYR A  43      37.339  77.439  -9.577  1.00  0.00           H  
ATOM    609  HD2 TYR A  43      33.163  78.068  -9.055  1.00  0.00           H  
ATOM    610  HE1 TYR A  43      37.514  79.569 -10.794  1.00  0.00           H  
ATOM    611  HE2 TYR A  43      33.328  80.199 -10.271  1.00  0.00           H  
ATOM    612  HH  TYR A  43      35.353  81.056 -12.219  1.00  0.00           H  
ATOM    613  N   PHE A  44      36.170  73.058  -9.657  1.00  0.00           N  
ATOM    614  CA  PHE A  44      36.840  71.838  -9.223  1.00  0.00           C  
ATOM    615  C   PHE A  44      37.987  72.158  -8.269  1.00  0.00           C  
ATOM    616  O   PHE A  44      38.558  73.248  -8.311  1.00  0.00           O  
ATOM    617  CB  PHE A  44      37.367  71.063 -10.432  1.00  0.00           C  
ATOM    618  CG  PHE A  44      36.310  70.268 -11.142  1.00  0.00           C  
ATOM    619  CD1 PHE A  44      35.221  70.900 -11.722  1.00  0.00           C  
ATOM    620  CD2 PHE A  44      36.403  68.888 -11.230  1.00  0.00           C  
ATOM    621  CE1 PHE A  44      34.245  70.172 -12.376  1.00  0.00           C  
ATOM    622  CE2 PHE A  44      35.431  68.155 -11.884  1.00  0.00           C  
ATOM    623  CZ  PHE A  44      34.351  68.797 -12.456  1.00  0.00           C  
ATOM    624  H   PHE A  44      36.195  73.306 -10.606  1.00  0.00           H  
ATOM    625  HA  PHE A  44      36.116  71.229  -8.704  1.00  0.00           H  
ATOM    626  HB2 PHE A  44      37.792  71.759 -11.140  1.00  0.00           H  
ATOM    627  HB3 PHE A  44      38.136  70.378 -10.103  1.00  0.00           H  
ATOM    628  HD1 PHE A  44      35.139  71.977 -11.660  1.00  0.00           H  
ATOM    629  HD2 PHE A  44      37.246  68.385 -10.783  1.00  0.00           H  
ATOM    630  HE1 PHE A  44      33.402  70.678 -12.823  1.00  0.00           H  
ATOM    631  HE2 PHE A  44      35.516  67.080 -11.946  1.00  0.00           H  
ATOM    632  HZ  PHE A  44      33.590  68.225 -12.967  1.00  0.00           H  
ATOM    633  N   VAL A  45      38.318  71.203  -7.407  1.00  0.00           N  
ATOM    634  CA  VAL A  45      39.396  71.385  -6.441  1.00  0.00           C  
ATOM    635  C   VAL A  45      40.173  70.089  -6.232  1.00  0.00           C  
ATOM    636  O   VAL A  45      39.587  69.031  -6.007  1.00  0.00           O  
ATOM    637  CB  VAL A  45      38.858  71.870  -5.083  1.00  0.00           C  
ATOM    638  CG1 VAL A  45      40.004  72.250  -4.158  1.00  0.00           C  
ATOM    639  CG2 VAL A  45      37.903  73.040  -5.273  1.00  0.00           C  
ATOM    640  H   VAL A  45      37.826  70.356  -7.420  1.00  0.00           H  
ATOM    641  HA  VAL A  45      40.066  72.137  -6.829  1.00  0.00           H  
ATOM    642  HB  VAL A  45      38.311  71.058  -4.625  1.00  0.00           H  
ATOM    643 HG11 VAL A  45      40.059  73.326  -4.074  1.00  0.00           H  
ATOM    644 HG12 VAL A  45      40.933  71.873  -4.560  1.00  0.00           H  
ATOM    645 HG13 VAL A  45      39.836  71.821  -3.181  1.00  0.00           H  
ATOM    646 HG21 VAL A  45      37.912  73.659  -4.388  1.00  0.00           H  
ATOM    647 HG22 VAL A  45      36.904  72.665  -5.439  1.00  0.00           H  
ATOM    648 HG23 VAL A  45      38.216  73.624  -6.126  1.00  0.00           H  
ATOM    649  N   GLY A  46      41.498  70.183  -6.303  1.00  0.00           N  
ATOM    650  CA  GLY A  46      42.335  69.013  -6.114  1.00  0.00           C  
ATOM    651  C   GLY A  46      42.854  68.898  -4.695  1.00  0.00           C  
ATOM    652  O   GLY A  46      43.635  69.735  -4.244  1.00  0.00           O  
ATOM    653  H   GLY A  46      41.908  71.055  -6.482  1.00  0.00           H  
ATOM    654  HA2 GLY A  46      41.759  68.131  -6.349  1.00  0.00           H  
ATOM    655  HA3 GLY A  46      43.174  69.073  -6.791  1.00  0.00           H  
ATOM    656  N   VAL A  47      42.420  67.858  -3.990  1.00  0.00           N  
ATOM    657  CA  VAL A  47      42.845  67.639  -2.613  1.00  0.00           C  
ATOM    658  C   VAL A  47      43.873  66.516  -2.526  1.00  0.00           C  
ATOM    659  O   VAL A  47      43.659  65.423  -3.051  1.00  0.00           O  
ATOM    660  CB  VAL A  47      41.650  67.298  -1.703  1.00  0.00           C  
ATOM    661  CG1 VAL A  47      42.079  67.274  -0.244  1.00  0.00           C  
ATOM    662  CG2 VAL A  47      40.516  68.288  -1.917  1.00  0.00           C  
ATOM    663  H   VAL A  47      41.797  67.226  -4.405  1.00  0.00           H  
ATOM    664  HA  VAL A  47      43.295  68.553  -2.253  1.00  0.00           H  
ATOM    665  HB  VAL A  47      41.294  66.313  -1.966  1.00  0.00           H  
ATOM    666 HG11 VAL A  47      41.814  68.212   0.224  1.00  0.00           H  
ATOM    667 HG12 VAL A  47      43.149  67.131  -0.185  1.00  0.00           H  
ATOM    668 HG13 VAL A  47      41.579  66.465   0.265  1.00  0.00           H  
ATOM    669 HG21 VAL A  47      40.917  69.222  -2.284  1.00  0.00           H  
ATOM    670 HG22 VAL A  47      40.006  68.460  -0.982  1.00  0.00           H  
ATOM    671 HG23 VAL A  47      39.820  67.888  -2.640  1.00  0.00           H  
ATOM    672  N   ASP A  48      44.987  66.792  -1.858  1.00  0.00           N  
ATOM    673  CA  ASP A  48      46.050  65.805  -1.699  1.00  0.00           C  
ATOM    674  C   ASP A  48      45.900  65.055  -0.379  1.00  0.00           C  
ATOM    675  O   ASP A  48      46.325  65.535   0.670  1.00  0.00           O  
ATOM    676  CB  ASP A  48      47.419  66.483  -1.761  1.00  0.00           C  
ATOM    677  CG  ASP A  48      48.561  65.485  -1.708  1.00  0.00           C  
ATOM    678  OD1 ASP A  48      48.621  64.606  -2.593  1.00  0.00           O  
ATOM    679  OD2 ASP A  48      49.391  65.583  -0.781  1.00  0.00           O  
ATOM    680  H   ASP A  48      45.099  67.681  -1.461  1.00  0.00           H  
ATOM    681  HA  ASP A  48      45.969  65.099  -2.512  1.00  0.00           H  
ATOM    682  HB2 ASP A  48      47.497  67.041  -2.681  1.00  0.00           H  
ATOM    683  HB3 ASP A  48      47.516  67.159  -0.924  1.00  0.00           H  
ATOM    684  N   MET A  49      45.290  63.874  -0.441  1.00  0.00           N  
ATOM    685  CA  MET A  49      45.084  63.058   0.750  1.00  0.00           C  
ATOM    686  C   MET A  49      46.412  62.541   1.292  1.00  0.00           C  
ATOM    687  O   MET A  49      47.420  62.528   0.585  1.00  0.00           O  
ATOM    688  CB  MET A  49      44.157  61.884   0.433  1.00  0.00           C  
ATOM    689  CG  MET A  49      42.847  62.301  -0.219  1.00  0.00           C  
ATOM    690  SD  MET A  49      41.632  62.890   0.977  1.00  0.00           S  
ATOM    691  CE  MET A  49      40.106  62.450   0.152  1.00  0.00           C  
ATOM    692  H   MET A  49      44.973  63.544  -1.307  1.00  0.00           H  
ATOM    693  HA  MET A  49      44.621  63.680   1.501  1.00  0.00           H  
ATOM    694  HB2 MET A  49      44.667  61.206  -0.235  1.00  0.00           H  
ATOM    695  HB3 MET A  49      43.926  61.365   1.352  1.00  0.00           H  
ATOM    696  HG2 MET A  49      43.049  63.092  -0.925  1.00  0.00           H  
ATOM    697  HG3 MET A  49      42.434  61.450  -0.740  1.00  0.00           H  
ATOM    698  HE1 MET A  49      39.271  62.644   0.811  1.00  0.00           H  
ATOM    699  HE2 MET A  49      40.125  61.400  -0.104  1.00  0.00           H  
ATOM    700  HE3 MET A  49      39.999  63.037  -0.746  1.00  0.00           H  
ATOM    701  N   ASP A  50      46.407  62.116   2.551  1.00  0.00           N  
ATOM    702  CA  ASP A  50      47.611  61.596   3.188  1.00  0.00           C  
ATOM    703  C   ASP A  50      47.838  60.137   2.810  1.00  0.00           C  
ATOM    704  O   ASP A  50      48.978  59.679   2.720  1.00  0.00           O  
ATOM    705  CB  ASP A  50      47.509  61.735   4.708  1.00  0.00           C  
ATOM    706  CG  ASP A  50      48.381  62.853   5.247  1.00  0.00           C  
ATOM    707  OD1 ASP A  50      48.333  63.966   4.685  1.00  0.00           O  
ATOM    708  OD2 ASP A  50      49.112  62.613   6.232  1.00  0.00           O  
ATOM    709  H   ASP A  50      45.572  62.151   3.064  1.00  0.00           H  
ATOM    710  HA  ASP A  50      48.448  62.181   2.839  1.00  0.00           H  
ATOM    711  HB2 ASP A  50      46.484  61.943   4.978  1.00  0.00           H  
ATOM    712  HB3 ASP A  50      47.817  60.808   5.171  1.00  0.00           H  
ATOM    713  N   ASN A  51      46.747  59.411   2.587  1.00  0.00           N  
ATOM    714  CA  ASN A  51      46.827  58.002   2.218  1.00  0.00           C  
ATOM    715  C   ASN A  51      46.745  57.833   0.702  1.00  0.00           C  
ATOM    716  O   ASN A  51      46.222  58.697  -0.000  1.00  0.00           O  
ATOM    717  CB  ASN A  51      45.707  57.211   2.891  1.00  0.00           C  
ATOM    718  CG  ASN A  51      46.080  56.752   4.288  1.00  0.00           C  
ATOM    719  OD1 ASN A  51      46.119  55.555   4.571  1.00  0.00           O  
ATOM    720  ND2 ASN A  51      46.362  57.706   5.168  1.00  0.00           N  
ATOM    721  H   ASN A  51      45.867  59.833   2.674  1.00  0.00           H  
ATOM    722  HA  ASN A  51      47.780  57.624   2.559  1.00  0.00           H  
ATOM    723  HB2 ASN A  51      44.826  57.833   2.961  1.00  0.00           H  
ATOM    724  HB3 ASN A  51      45.479  56.340   2.294  1.00  0.00           H  
ATOM    725 HD21 ASN A  51      46.311  58.638   4.872  1.00  0.00           H  
ATOM    726 HD22 ASN A  51      46.608  57.438   6.078  1.00  0.00           H  
ATOM    727  N   PRO A  52      47.266  56.710   0.176  1.00  0.00           N  
ATOM    728  CA  PRO A  52      47.249  56.431  -1.264  1.00  0.00           C  
ATOM    729  C   PRO A  52      45.846  56.126  -1.777  1.00  0.00           C  
ATOM    730  O   PRO A  52      45.472  54.965  -1.941  1.00  0.00           O  
ATOM    731  CB  PRO A  52      48.147  55.200  -1.398  1.00  0.00           C  
ATOM    732  CG  PRO A  52      48.068  54.528  -0.071  1.00  0.00           C  
ATOM    733  CD  PRO A  52      47.909  55.627   0.942  1.00  0.00           C  
ATOM    734  HA  PRO A  52      47.667  57.250  -1.829  1.00  0.00           H  
ATOM    735  HB2 PRO A  52      47.775  54.564  -2.188  1.00  0.00           H  
ATOM    736  HB3 PRO A  52      49.157  55.510  -1.621  1.00  0.00           H  
ATOM    737  HG2 PRO A  52      47.212  53.868  -0.045  1.00  0.00           H  
ATOM    738  HG3 PRO A  52      48.975  53.974   0.116  1.00  0.00           H  
ATOM    739  HD2 PRO A  52      47.277  55.302   1.756  1.00  0.00           H  
ATOM    740  HD3 PRO A  52      48.875  55.939   1.314  1.00  0.00           H  
ATOM    741  N   ILE A  53      45.072  57.177  -2.030  1.00  0.00           N  
ATOM    742  CA  ILE A  53      43.710  57.022  -2.526  1.00  0.00           C  
ATOM    743  C   ILE A  53      43.375  58.091  -3.561  1.00  0.00           C  
ATOM    744  O   ILE A  53      42.215  58.470  -3.723  1.00  0.00           O  
ATOM    745  CB  ILE A  53      42.682  57.095  -1.380  1.00  0.00           C  
ATOM    746  CG1 ILE A  53      42.855  58.397  -0.595  1.00  0.00           C  
ATOM    747  CG2 ILE A  53      42.828  55.892  -0.460  1.00  0.00           C  
ATOM    748  CD1 ILE A  53      41.602  58.830   0.137  1.00  0.00           C  
ATOM    749  H   ILE A  53      45.425  58.078  -1.880  1.00  0.00           H  
ATOM    750  HA  ILE A  53      43.632  56.049  -2.989  1.00  0.00           H  
ATOM    751  HB  ILE A  53      41.693  57.070  -1.811  1.00  0.00           H  
ATOM    752 HG12 ILE A  53      43.637  58.268   0.138  1.00  0.00           H  
ATOM    753 HG13 ILE A  53      43.131  59.187  -1.276  1.00  0.00           H  
ATOM    754 HG21 ILE A  53      42.307  56.082   0.466  1.00  0.00           H  
ATOM    755 HG22 ILE A  53      43.876  55.719  -0.257  1.00  0.00           H  
ATOM    756 HG23 ILE A  53      42.408  55.020  -0.938  1.00  0.00           H  
ATOM    757 HD11 ILE A  53      40.765  58.237  -0.202  1.00  0.00           H  
ATOM    758 HD12 ILE A  53      41.410  59.873  -0.064  1.00  0.00           H  
ATOM    759 HD13 ILE A  53      41.738  58.687   1.200  1.00  0.00           H  
ATOM    760  N   GLY A  54      44.398  58.574  -4.259  1.00  0.00           N  
ATOM    761  CA  GLY A  54      44.190  59.595  -5.269  1.00  0.00           C  
ATOM    762  C   GLY A  54      43.662  59.024  -6.571  1.00  0.00           C  
ATOM    763  O   GLY A  54      43.397  57.827  -6.669  1.00  0.00           O  
ATOM    764  H   GLY A  54      45.300  58.235  -4.088  1.00  0.00           H  
ATOM    765  HA2 GLY A  54      43.482  60.318  -4.892  1.00  0.00           H  
ATOM    766  HA3 GLY A  54      45.128  60.092  -5.460  1.00  0.00           H  
ATOM    767  N   ASN A  55      43.512  59.883  -7.574  1.00  0.00           N  
ATOM    768  CA  ASN A  55      43.012  59.458  -8.876  1.00  0.00           C  
ATOM    769  C   ASN A  55      43.002  60.623  -9.862  1.00  0.00           C  
ATOM    770  O   ASN A  55      42.085  60.754 -10.673  1.00  0.00           O  
ATOM    771  CB  ASN A  55      41.606  58.875  -8.741  1.00  0.00           C  
ATOM    772  CG  ASN A  55      40.685  59.766  -7.929  1.00  0.00           C  
ATOM    773  OD1 ASN A  55      40.349  59.455  -6.787  1.00  0.00           O  
ATOM    774  ND2 ASN A  55      40.273  60.883  -8.519  1.00  0.00           N  
ATOM    775  H   ASN A  55      43.741  60.826  -7.433  1.00  0.00           H  
ATOM    776  HA  ASN A  55      43.675  58.692  -9.251  1.00  0.00           H  
ATOM    777  HB2 ASN A  55      41.178  58.750  -9.726  1.00  0.00           H  
ATOM    778  HB3 ASN A  55      41.666  57.913  -8.255  1.00  0.00           H  
ATOM    779 HD21 ASN A  55      40.580  61.068  -9.430  1.00  0.00           H  
ATOM    780 HD22 ASN A  55      39.677  61.477  -8.016  1.00  0.00           H  
ATOM    781  N   TRP A  56      44.026  61.466  -9.787  1.00  0.00           N  
ATOM    782  CA  TRP A  56      44.133  62.619 -10.674  1.00  0.00           C  
ATOM    783  C   TRP A  56      45.559  63.161 -10.694  1.00  0.00           C  
ATOM    784  O   TRP A  56      46.027  63.742  -9.715  1.00  0.00           O  
ATOM    785  CB  TRP A  56      43.163  63.718 -10.233  1.00  0.00           C  
ATOM    786  CG  TRP A  56      43.011  64.813 -11.244  1.00  0.00           C  
ATOM    787  CD1 TRP A  56      42.468  64.708 -12.491  1.00  0.00           C  
ATOM    788  CD2 TRP A  56      43.407  66.182 -11.092  1.00  0.00           C  
ATOM    789  NE1 TRP A  56      42.502  65.927 -13.126  1.00  0.00           N  
ATOM    790  CE2 TRP A  56      43.073  66.847 -12.288  1.00  0.00           C  
ATOM    791  CE3 TRP A  56      44.012  66.908 -10.062  1.00  0.00           C  
ATOM    792  CZ2 TRP A  56      43.324  68.204 -12.479  1.00  0.00           C  
ATOM    793  CZ3 TRP A  56      44.260  68.255 -10.254  1.00  0.00           C  
ATOM    794  CH2 TRP A  56      43.916  68.890 -11.453  1.00  0.00           C  
ATOM    795  H   TRP A  56      44.728  61.309  -9.120  1.00  0.00           H  
ATOM    796  HA  TRP A  56      43.869  62.297 -11.669  1.00  0.00           H  
ATOM    797  HB2 TRP A  56      42.189  63.283 -10.064  1.00  0.00           H  
ATOM    798  HB3 TRP A  56      43.523  64.157  -9.314  1.00  0.00           H  
ATOM    799  HD1 TRP A  56      42.073  63.793 -12.908  1.00  0.00           H  
ATOM    800  HE1 TRP A  56      42.170  66.107 -14.029  1.00  0.00           H  
ATOM    801  HE3 TRP A  56      44.283  66.436  -9.130  1.00  0.00           H  
ATOM    802  HZ2 TRP A  56      43.064  68.708 -13.397  1.00  0.00           H  
ATOM    803  HZ3 TRP A  56      44.725  68.833  -9.470  1.00  0.00           H  
ATOM    804  HH2 TRP A  56      44.128  69.944 -11.559  1.00  0.00           H  
ATOM    805  N   ASP A  57      46.244  62.966 -11.816  1.00  0.00           N  
ATOM    806  CA  ASP A  57      47.617  63.437 -11.965  1.00  0.00           C  
ATOM    807  C   ASP A  57      47.654  64.947 -12.179  1.00  0.00           C  
ATOM    808  O   ASP A  57      48.610  65.614 -11.788  1.00  0.00           O  
ATOM    809  CB  ASP A  57      48.296  62.726 -13.139  1.00  0.00           C  
ATOM    810  CG  ASP A  57      49.793  62.593 -12.945  1.00  0.00           C  
ATOM    811  OD1 ASP A  57      50.429  63.584 -12.529  1.00  0.00           O  
ATOM    812  OD2 ASP A  57      50.330  61.498 -13.208  1.00  0.00           O  
ATOM    813  H   ASP A  57      45.815  62.496 -12.562  1.00  0.00           H  
ATOM    814  HA  ASP A  57      48.148  63.201 -11.056  1.00  0.00           H  
ATOM    815  HB2 ASP A  57      47.876  61.737 -13.244  1.00  0.00           H  
ATOM    816  HB3 ASP A  57      48.116  63.289 -14.043  1.00  0.00           H  
ATOM    817  N   GLY A  58      46.605  65.477 -12.799  1.00  0.00           N  
ATOM    818  CA  GLY A  58      46.539  66.904 -13.052  1.00  0.00           C  
ATOM    819  C   GLY A  58      46.484  67.227 -14.533  1.00  0.00           C  
ATOM    820  O   GLY A  58      47.214  68.094 -15.014  1.00  0.00           O  
ATOM    821  H   GLY A  58      45.872  64.896 -13.087  1.00  0.00           H  
ATOM    822  HA2 GLY A  58      45.653  67.303 -12.576  1.00  0.00           H  
ATOM    823  HA3 GLY A  58      47.412  67.378 -12.625  1.00  0.00           H  
ATOM    824  N   ARG A  59      45.615  66.528 -15.257  1.00  0.00           N  
ATOM    825  CA  ARG A  59      45.467  66.743 -16.691  1.00  0.00           C  
ATOM    826  C   ARG A  59      43.997  66.735 -17.095  1.00  0.00           C  
ATOM    827  O   ARG A  59      43.134  66.312 -16.327  1.00  0.00           O  
ATOM    828  CB  ARG A  59      46.228  65.670 -17.472  1.00  0.00           C  
ATOM    829  CG  ARG A  59      47.701  65.580 -17.106  1.00  0.00           C  
ATOM    830  CD  ARG A  59      48.454  64.656 -18.051  1.00  0.00           C  
ATOM    831  NE  ARG A  59      49.885  64.945 -18.073  1.00  0.00           N  
ATOM    832  CZ  ARG A  59      50.707  64.546 -19.042  1.00  0.00           C  
ATOM    833  NH1 ARG A  59      50.243  63.846 -20.069  1.00  0.00           N  
ATOM    834  NH2 ARG A  59      51.996  64.853 -18.984  1.00  0.00           N  
ATOM    835  H   ARG A  59      45.061  65.851 -14.815  1.00  0.00           H  
ATOM    836  HA  ARG A  59      45.887  67.711 -16.925  1.00  0.00           H  
ATOM    837  HB2 ARG A  59      45.772  64.710 -17.278  1.00  0.00           H  
ATOM    838  HB3 ARG A  59      46.153  65.888 -18.526  1.00  0.00           H  
ATOM    839  HG2 ARG A  59      48.136  66.567 -17.160  1.00  0.00           H  
ATOM    840  HG3 ARG A  59      47.789  65.200 -16.099  1.00  0.00           H  
ATOM    841  HD2 ARG A  59      48.306  63.636 -17.730  1.00  0.00           H  
ATOM    842  HD3 ARG A  59      48.055  64.781 -19.048  1.00  0.00           H  
ATOM    843  HE  ARG A  59      50.255  65.460 -17.326  1.00  0.00           H  
ATOM    844 HH11 ARG A  59      49.272  63.613 -20.118  1.00  0.00           H  
ATOM    845 HH12 ARG A  59      50.865  63.551 -20.794  1.00  0.00           H  
ATOM    846 HH21 ARG A  59      52.351  65.380 -18.214  1.00  0.00           H  
ATOM    847 HH22 ARG A  59      52.613  64.554 -19.713  1.00  0.00           H  
ATOM    848  N   PHE A  60      43.720  67.204 -18.308  1.00  0.00           N  
ATOM    849  CA  PHE A  60      42.355  67.249 -18.817  1.00  0.00           C  
ATOM    850  C   PHE A  60      42.330  66.990 -20.319  1.00  0.00           C  
ATOM    851  O   PHE A  60      42.591  67.889 -21.118  1.00  0.00           O  
ATOM    852  CB  PHE A  60      41.718  68.605 -18.510  1.00  0.00           C  
ATOM    853  CG  PHE A  60      40.216  68.570 -18.480  1.00  0.00           C  
ATOM    854  CD1 PHE A  60      39.543  68.212 -17.324  1.00  0.00           C  
ATOM    855  CD2 PHE A  60      39.481  68.894 -19.608  1.00  0.00           C  
ATOM    856  CE1 PHE A  60      38.160  68.179 -17.294  1.00  0.00           C  
ATOM    857  CE2 PHE A  60      38.099  68.863 -19.585  1.00  0.00           C  
ATOM    858  CZ  PHE A  60      37.438  68.504 -18.426  1.00  0.00           C  
ATOM    859  H   PHE A  60      44.452  67.525 -18.874  1.00  0.00           H  
ATOM    860  HA  PHE A  60      41.790  66.475 -18.320  1.00  0.00           H  
ATOM    861  HB2 PHE A  60      42.061  68.946 -17.543  1.00  0.00           H  
ATOM    862  HB3 PHE A  60      42.020  69.315 -19.265  1.00  0.00           H  
ATOM    863  HD1 PHE A  60      40.106  67.957 -16.439  1.00  0.00           H  
ATOM    864  HD2 PHE A  60      39.997  69.175 -20.515  1.00  0.00           H  
ATOM    865  HE1 PHE A  60      37.647  67.899 -16.387  1.00  0.00           H  
ATOM    866  HE2 PHE A  60      37.537  69.118 -20.470  1.00  0.00           H  
ATOM    867  HZ  PHE A  60      36.359  68.479 -18.404  1.00  0.00           H  
ATOM    868  N   ASP A  61      42.013  65.756 -20.696  1.00  0.00           N  
ATOM    869  CA  ASP A  61      41.954  65.377 -22.104  1.00  0.00           C  
ATOM    870  C   ASP A  61      43.313  65.553 -22.774  1.00  0.00           C  
ATOM    871  O   ASP A  61      43.394  65.823 -23.973  1.00  0.00           O  
ATOM    872  CB  ASP A  61      40.899  66.210 -22.835  1.00  0.00           C  
ATOM    873  CG  ASP A  61      39.485  65.773 -22.502  1.00  0.00           C  
ATOM    874  OD1 ASP A  61      39.226  65.445 -21.326  1.00  0.00           O  
ATOM    875  OD2 ASP A  61      38.638  65.758 -23.420  1.00  0.00           O  
ATOM    876  H   ASP A  61      41.815  65.083 -20.012  1.00  0.00           H  
ATOM    877  HA  ASP A  61      41.675  64.335 -22.154  1.00  0.00           H  
ATOM    878  HB2 ASP A  61      41.009  67.247 -22.555  1.00  0.00           H  
ATOM    879  HB3 ASP A  61      41.046  66.110 -23.901  1.00  0.00           H  
ATOM    880  N   GLY A  62      44.378  65.401 -21.993  1.00  0.00           N  
ATOM    881  CA  GLY A  62      45.719  65.545 -22.530  1.00  0.00           C  
ATOM    882  C   GLY A  62      46.452  66.742 -21.955  1.00  0.00           C  
ATOM    883  O   GLY A  62      47.608  66.631 -21.546  1.00  0.00           O  
ATOM    884  H   GLY A  62      44.253  65.186 -21.045  1.00  0.00           H  
ATOM    885  HA2 GLY A  62      46.282  64.651 -22.306  1.00  0.00           H  
ATOM    886  HA3 GLY A  62      45.655  65.658 -23.603  1.00  0.00           H  
ATOM    887  N   VAL A  63      45.781  67.888 -21.927  1.00  0.00           N  
ATOM    888  CA  VAL A  63      46.377  69.110 -21.400  1.00  0.00           C  
ATOM    889  C   VAL A  63      46.628  68.996 -19.899  1.00  0.00           C  
ATOM    890  O   VAL A  63      45.894  68.313 -19.188  1.00  0.00           O  
ATOM    891  CB  VAL A  63      45.481  70.335 -21.675  1.00  0.00           C  
ATOM    892  CG1 VAL A  63      44.127  70.175 -21.001  1.00  0.00           C  
ATOM    893  CG2 VAL A  63      46.167  71.614 -21.219  1.00  0.00           C  
ATOM    894  H   VAL A  63      44.863  67.913 -22.270  1.00  0.00           H  
ATOM    895  HA  VAL A  63      47.322  69.262 -21.902  1.00  0.00           H  
ATOM    896  HB  VAL A  63      45.319  70.401 -22.742  1.00  0.00           H  
ATOM    897 HG11 VAL A  63      44.194  69.418 -20.233  1.00  0.00           H  
ATOM    898 HG12 VAL A  63      43.391  69.880 -21.734  1.00  0.00           H  
ATOM    899 HG13 VAL A  63      43.833  71.114 -20.554  1.00  0.00           H  
ATOM    900 HG21 VAL A  63      45.710  72.462 -21.706  1.00  0.00           H  
ATOM    901 HG22 VAL A  63      47.215  71.572 -21.476  1.00  0.00           H  
ATOM    902 HG23 VAL A  63      46.065  71.716 -20.148  1.00  0.00           H  
ATOM    903  N   GLN A  64      47.668  69.676 -19.426  1.00  0.00           N  
ATOM    904  CA  GLN A  64      48.016  69.652 -18.010  1.00  0.00           C  
ATOM    905  C   GLN A  64      47.572  70.939 -17.321  1.00  0.00           C  
ATOM    906  O   GLN A  64      47.939  72.037 -17.741  1.00  0.00           O  
ATOM    907  CB  GLN A  64      49.523  69.459 -17.836  1.00  0.00           C  
ATOM    908  CG  GLN A  64      49.961  69.373 -16.383  1.00  0.00           C  
ATOM    909  CD  GLN A  64      50.210  67.946 -15.934  1.00  0.00           C  
ATOM    910  OE1 GLN A  64      50.722  67.123 -16.695  1.00  0.00           O  
ATOM    911  NE2 GLN A  64      49.851  67.645 -14.692  1.00  0.00           N  
ATOM    912  H   GLN A  64      48.215  70.204 -20.044  1.00  0.00           H  
ATOM    913  HA  GLN A  64      47.500  68.818 -17.556  1.00  0.00           H  
ATOM    914  HB2 GLN A  64      49.818  68.548 -18.333  1.00  0.00           H  
ATOM    915  HB3 GLN A  64      50.037  70.291 -18.295  1.00  0.00           H  
ATOM    916  HG2 GLN A  64      50.873  69.936 -16.261  1.00  0.00           H  
ATOM    917  HG3 GLN A  64      49.188  69.800 -15.760  1.00  0.00           H  
ATOM    918 HE21 GLN A  64      49.450  68.350 -14.142  1.00  0.00           H  
ATOM    919 HE22 GLN A  64      50.001  66.729 -14.375  1.00  0.00           H  
ATOM    920  N   LEU A  65      46.781  70.796 -16.263  1.00  0.00           N  
ATOM    921  CA  LEU A  65      46.288  71.946 -15.517  1.00  0.00           C  
ATOM    922  C   LEU A  65      46.987  72.061 -14.165  1.00  0.00           C  
ATOM    923  O   LEU A  65      47.351  73.154 -13.734  1.00  0.00           O  
ATOM    924  CB  LEU A  65      44.776  71.839 -15.313  1.00  0.00           C  
ATOM    925  CG  LEU A  65      43.946  71.887 -16.598  1.00  0.00           C  
ATOM    926  CD1 LEU A  65      42.481  71.608 -16.297  1.00  0.00           C  
ATOM    927  CD2 LEU A  65      44.104  73.237 -17.283  1.00  0.00           C  
ATOM    928  H   LEU A  65      46.523  69.894 -15.976  1.00  0.00           H  
ATOM    929  HA  LEU A  65      46.502  72.832 -16.095  1.00  0.00           H  
ATOM    930  HB2 LEU A  65      44.568  70.906 -14.809  1.00  0.00           H  
ATOM    931  HB3 LEU A  65      44.459  72.652 -14.677  1.00  0.00           H  
ATOM    932  HG  LEU A  65      44.299  71.123 -17.276  1.00  0.00           H  
ATOM    933 HD11 LEU A  65      41.862  72.118 -17.019  1.00  0.00           H  
ATOM    934 HD12 LEU A  65      42.243  71.961 -15.304  1.00  0.00           H  
ATOM    935 HD13 LEU A  65      42.297  70.546 -16.354  1.00  0.00           H  
ATOM    936 HD21 LEU A  65      44.902  73.180 -18.008  1.00  0.00           H  
ATOM    937 HD22 LEU A  65      44.340  73.989 -16.546  1.00  0.00           H  
ATOM    938 HD23 LEU A  65      43.182  73.496 -17.782  1.00  0.00           H  
ATOM    939  N   CYS A  66      47.171  70.924 -13.502  1.00  0.00           N  
ATOM    940  CA  CYS A  66      47.825  70.897 -12.198  1.00  0.00           C  
ATOM    941  C   CYS A  66      49.111  70.079 -12.251  1.00  0.00           C  
ATOM    942  O   CYS A  66      49.079  68.869 -12.482  1.00  0.00           O  
ATOM    943  CB  CYS A  66      46.880  70.316 -11.143  1.00  0.00           C  
ATOM    944  SG  CYS A  66      47.442  70.553  -9.441  1.00  0.00           S  
ATOM    945  H   CYS A  66      46.857  70.084 -13.897  1.00  0.00           H  
ATOM    946  HA  CYS A  66      48.070  71.912 -11.928  1.00  0.00           H  
ATOM    947  HB2 CYS A  66      45.913  70.788 -11.237  1.00  0.00           H  
ATOM    948  HB3 CYS A  66      46.775  69.255 -11.311  1.00  0.00           H  
ATOM    949  HG  CYS A  66      46.717  70.322  -8.856  1.00  0.00           H  
ATOM    950  N   SER A  67      50.239  70.745 -12.034  1.00  0.00           N  
ATOM    951  CA  SER A  67      51.537  70.079 -12.057  1.00  0.00           C  
ATOM    952  C   SER A  67      51.820  69.399 -10.722  1.00  0.00           C  
ATOM    953  O   SER A  67      52.367  68.297 -10.679  1.00  0.00           O  
ATOM    954  CB  SER A  67      52.644  71.085 -12.375  1.00  0.00           C  
ATOM    955  OG  SER A  67      52.682  71.380 -13.761  1.00  0.00           O  
ATOM    956  H   SER A  67      50.199  71.708 -11.855  1.00  0.00           H  
ATOM    957  HA  SER A  67      51.511  69.328 -12.832  1.00  0.00           H  
ATOM    958  HB2 SER A  67      52.466  71.999 -11.830  1.00  0.00           H  
ATOM    959  HB3 SER A  67      53.598  70.672 -12.082  1.00  0.00           H  
ATOM    960  HG  SER A  67      53.195  72.179 -13.904  1.00  0.00           H  
ATOM    961  N   PHE A  68      51.446  70.064  -9.634  1.00  0.00           N  
ATOM    962  CA  PHE A  68      51.658  69.523  -8.296  1.00  0.00           C  
ATOM    963  C   PHE A  68      50.819  68.269  -8.071  1.00  0.00           C  
ATOM    964  O   PHE A  68      51.155  67.426  -7.239  1.00  0.00           O  
ATOM    965  CB  PHE A  68      51.317  70.576  -7.239  1.00  0.00           C  
ATOM    966  CG  PHE A  68      51.939  71.917  -7.504  1.00  0.00           C  
ATOM    967  CD1 PHE A  68      53.303  72.030  -7.729  1.00  0.00           C  
ATOM    968  CD2 PHE A  68      51.162  73.064  -7.528  1.00  0.00           C  
ATOM    969  CE1 PHE A  68      53.879  73.262  -7.973  1.00  0.00           C  
ATOM    970  CE2 PHE A  68      51.732  74.299  -7.772  1.00  0.00           C  
ATOM    971  CZ  PHE A  68      53.092  74.398  -7.994  1.00  0.00           C  
ATOM    972  H   PHE A  68      51.014  70.938  -9.733  1.00  0.00           H  
ATOM    973  HA  PHE A  68      52.703  69.263  -8.207  1.00  0.00           H  
ATOM    974  HB2 PHE A  68      50.246  70.708  -7.206  1.00  0.00           H  
ATOM    975  HB3 PHE A  68      51.663  70.232  -6.275  1.00  0.00           H  
ATOM    976  HD1 PHE A  68      53.917  71.142  -7.712  1.00  0.00           H  
ATOM    977  HD2 PHE A  68      50.099  72.987  -7.354  1.00  0.00           H  
ATOM    978  HE1 PHE A  68      54.941  73.337  -8.146  1.00  0.00           H  
ATOM    979  HE2 PHE A  68      51.116  75.185  -7.789  1.00  0.00           H  
ATOM    980  HZ  PHE A  68      53.540  75.362  -8.184  1.00  0.00           H  
ATOM    981  N   ALA A  69      49.723  68.152  -8.816  1.00  0.00           N  
ATOM    982  CA  ALA A  69      48.837  67.000  -8.694  1.00  0.00           C  
ATOM    983  C   ALA A  69      49.568  65.707  -9.035  1.00  0.00           C  
ATOM    984  O   ALA A  69      50.645  65.731  -9.632  1.00  0.00           O  
ATOM    985  CB  ALA A  69      47.622  67.173  -9.594  1.00  0.00           C  
ATOM    986  H   ALA A  69      49.505  68.855  -9.462  1.00  0.00           H  
ATOM    987  HA  ALA A  69      48.494  66.950  -7.672  1.00  0.00           H  
ATOM    988  HB1 ALA A  69      47.885  67.794 -10.439  1.00  0.00           H  
ATOM    989  HB2 ALA A  69      46.826  67.644  -9.037  1.00  0.00           H  
ATOM    990  HB3 ALA A  69      47.293  66.206  -9.945  1.00  0.00           H  
ATOM    991  N   CYS A  70      48.978  64.581  -8.651  1.00  0.00           N  
ATOM    992  CA  CYS A  70      49.574  63.278  -8.916  1.00  0.00           C  
ATOM    993  C   CYS A  70      48.541  62.165  -8.768  1.00  0.00           C  
ATOM    994  O   CYS A  70      47.812  62.109  -7.778  1.00  0.00           O  
ATOM    995  CB  CYS A  70      50.748  63.028  -7.965  1.00  0.00           C  
ATOM    996  SG  CYS A  70      52.133  62.144  -8.719  1.00  0.00           S  
ATOM    997  H   CYS A  70      48.120  64.627  -8.178  1.00  0.00           H  
ATOM    998  HA  CYS A  70      49.940  63.282  -9.932  1.00  0.00           H  
ATOM    999  HB2 CYS A  70      51.120  63.977  -7.609  1.00  0.00           H  
ATOM   1000  HB3 CYS A  70      50.402  62.444  -7.125  1.00  0.00           H  
ATOM   1001  HG  CYS A  70      52.908  62.285  -8.171  1.00  0.00           H  
ATOM   1002  N   VAL A  71      48.484  61.283  -9.760  1.00  0.00           N  
ATOM   1003  CA  VAL A  71      47.540  60.172  -9.741  1.00  0.00           C  
ATOM   1004  C   VAL A  71      47.929  59.142  -8.681  1.00  0.00           C  
ATOM   1005  O   VAL A  71      48.301  58.014  -9.003  1.00  0.00           O  
ATOM   1006  CB  VAL A  71      47.457  59.483 -11.118  1.00  0.00           C  
ATOM   1007  CG1 VAL A  71      48.816  58.934 -11.528  1.00  0.00           C  
ATOM   1008  CG2 VAL A  71      46.407  58.380 -11.103  1.00  0.00           C  
ATOM   1009  H   VAL A  71      49.092  61.380 -10.523  1.00  0.00           H  
ATOM   1010  HA  VAL A  71      46.565  60.569  -9.500  1.00  0.00           H  
ATOM   1011  HB  VAL A  71      47.159  60.222 -11.848  1.00  0.00           H  
ATOM   1012 HG11 VAL A  71      48.701  57.928 -11.905  1.00  0.00           H  
ATOM   1013 HG12 VAL A  71      49.475  58.926 -10.673  1.00  0.00           H  
ATOM   1014 HG13 VAL A  71      49.238  59.560 -12.302  1.00  0.00           H  
ATOM   1015 HG21 VAL A  71      45.547  58.709 -10.540  1.00  0.00           H  
ATOM   1016 HG22 VAL A  71      46.822  57.495 -10.643  1.00  0.00           H  
ATOM   1017 HG23 VAL A  71      46.110  58.153 -12.115  1.00  0.00           H  
ATOM   1018  N   GLU A  72      47.840  59.542  -7.417  1.00  0.00           N  
ATOM   1019  CA  GLU A  72      48.183  58.656  -6.311  1.00  0.00           C  
ATOM   1020  C   GLU A  72      47.480  59.083  -5.027  1.00  0.00           C  
ATOM   1021  O   GLU A  72      46.963  58.246  -4.286  1.00  0.00           O  
ATOM   1022  CB  GLU A  72      49.698  58.639  -6.096  1.00  0.00           C  
ATOM   1023  CG  GLU A  72      50.329  60.022  -6.113  1.00  0.00           C  
ATOM   1024  CD  GLU A  72      51.818  59.986  -5.827  1.00  0.00           C  
ATOM   1025  OE1 GLU A  72      52.460  58.964  -6.148  1.00  0.00           O  
ATOM   1026  OE2 GLU A  72      52.342  60.980  -5.282  1.00  0.00           O  
ATOM   1027  H   GLU A  72      47.538  60.454  -7.226  1.00  0.00           H  
ATOM   1028  HA  GLU A  72      47.857  57.660  -6.572  1.00  0.00           H  
ATOM   1029  HB2 GLU A  72      49.909  58.184  -5.139  1.00  0.00           H  
ATOM   1030  HB3 GLU A  72      50.155  58.048  -6.874  1.00  0.00           H  
ATOM   1031  HG2 GLU A  72      50.178  60.461  -7.089  1.00  0.00           H  
ATOM   1032  HG3 GLU A  72      49.849  60.634  -5.365  1.00  0.00           H  
ATOM   1033  N   SER A  73      47.464  60.386  -4.768  1.00  0.00           N  
ATOM   1034  CA  SER A  73      46.825  60.918  -3.568  1.00  0.00           C  
ATOM   1035  C   SER A  73      45.873  62.061  -3.912  1.00  0.00           C  
ATOM   1036  O   SER A  73      44.774  62.152  -3.364  1.00  0.00           O  
ATOM   1037  CB  SER A  73      47.883  61.398  -2.573  1.00  0.00           C  
ATOM   1038  OG  SER A  73      47.628  60.892  -1.274  1.00  0.00           O  
ATOM   1039  H   SER A  73      47.894  61.003  -5.394  1.00  0.00           H  
ATOM   1040  HA  SER A  73      46.257  60.119  -3.116  1.00  0.00           H  
ATOM   1041  HB2 SER A  73      48.857  61.054  -2.893  1.00  0.00           H  
ATOM   1042  HB3 SER A  73      47.875  62.479  -2.534  1.00  0.00           H  
ATOM   1043  HG  SER A  73      47.407  59.960  -1.332  1.00  0.00           H  
ATOM   1044  N   THR A  74      46.304  62.937  -4.816  1.00  0.00           N  
ATOM   1045  CA  THR A  74      45.491  64.077  -5.228  1.00  0.00           C  
ATOM   1046  C   THR A  74      44.131  63.625  -5.752  1.00  0.00           C  
ATOM   1047  O   THR A  74      43.994  62.526  -6.291  1.00  0.00           O  
ATOM   1048  CB  THR A  74      46.220  64.886  -6.301  1.00  0.00           C  
ATOM   1049  OG1 THR A  74      47.497  65.290  -5.845  1.00  0.00           O  
ATOM   1050  CG2 THR A  74      45.469  66.129  -6.727  1.00  0.00           C  
ATOM   1051  H   THR A  74      47.190  62.814  -5.214  1.00  0.00           H  
ATOM   1052  HA  THR A  74      45.339  64.705  -4.362  1.00  0.00           H  
ATOM   1053  HB  THR A  74      46.353  64.265  -7.176  1.00  0.00           H  
ATOM   1054  HG1 THR A  74      48.069  64.522  -5.768  1.00  0.00           H  
ATOM   1055 HG21 THR A  74      45.221  66.715  -5.856  1.00  0.00           H  
ATOM   1056 HG22 THR A  74      44.563  65.844  -7.241  1.00  0.00           H  
ATOM   1057 HG23 THR A  74      46.089  66.715  -7.391  1.00  0.00           H  
ATOM   1058  N   ILE A  75      43.126  64.483  -5.589  1.00  0.00           N  
ATOM   1059  CA  ILE A  75      41.776  64.177  -6.046  1.00  0.00           C  
ATOM   1060  C   ILE A  75      41.028  65.447  -6.440  1.00  0.00           C  
ATOM   1061  O   ILE A  75      40.729  66.290  -5.593  1.00  0.00           O  
ATOM   1062  CB  ILE A  75      40.967  63.438  -4.963  1.00  0.00           C  
ATOM   1063  CG1 ILE A  75      41.766  62.255  -4.415  1.00  0.00           C  
ATOM   1064  CG2 ILE A  75      39.634  62.967  -5.525  1.00  0.00           C  
ATOM   1065  CD1 ILE A  75      41.034  61.471  -3.348  1.00  0.00           C  
ATOM   1066  H   ILE A  75      43.299  65.343  -5.153  1.00  0.00           H  
ATOM   1067  HA  ILE A  75      41.852  63.534  -6.911  1.00  0.00           H  
ATOM   1068  HB  ILE A  75      40.766  64.130  -4.159  1.00  0.00           H  
ATOM   1069 HG12 ILE A  75      41.996  61.577  -5.224  1.00  0.00           H  
ATOM   1070 HG13 ILE A  75      42.689  62.620  -3.986  1.00  0.00           H  
ATOM   1071 HG21 ILE A  75      39.376  63.563  -6.387  1.00  0.00           H  
ATOM   1072 HG22 ILE A  75      38.867  63.075  -4.771  1.00  0.00           H  
ATOM   1073 HG23 ILE A  75      39.710  61.930  -5.815  1.00  0.00           H  
ATOM   1074 HD11 ILE A  75      40.026  61.269  -3.678  1.00  0.00           H  
ATOM   1075 HD12 ILE A  75      41.006  62.045  -2.434  1.00  0.00           H  
ATOM   1076 HD13 ILE A  75      41.548  60.537  -3.170  1.00  0.00           H  
ATOM   1077  N   LEU A  76      40.728  65.578  -7.726  1.00  0.00           N  
ATOM   1078  CA  LEU A  76      40.013  66.745  -8.230  1.00  0.00           C  
ATOM   1079  C   LEU A  76      38.507  66.507  -8.222  1.00  0.00           C  
ATOM   1080  O   LEU A  76      38.000  65.645  -8.941  1.00  0.00           O  
ATOM   1081  CB  LEU A  76      40.479  67.082  -9.648  1.00  0.00           C  
ATOM   1082  CG  LEU A  76      39.940  68.399 -10.210  1.00  0.00           C  
ATOM   1083  CD1 LEU A  76      40.844  69.557  -9.816  1.00  0.00           C  
ATOM   1084  CD2 LEU A  76      39.805  68.317 -11.722  1.00  0.00           C  
ATOM   1085  H   LEU A  76      40.991  64.871  -8.354  1.00  0.00           H  
ATOM   1086  HA  LEU A  76      40.238  67.576  -7.580  1.00  0.00           H  
ATOM   1087  HB2 LEU A  76      41.558  67.130  -9.648  1.00  0.00           H  
ATOM   1088  HB3 LEU A  76      40.171  66.285 -10.306  1.00  0.00           H  
ATOM   1089  HG  LEU A  76      38.959  68.586  -9.795  1.00  0.00           H  
ATOM   1090 HD11 LEU A  76      40.849  70.294 -10.605  1.00  0.00           H  
ATOM   1091 HD12 LEU A  76      41.847  69.192  -9.656  1.00  0.00           H  
ATOM   1092 HD13 LEU A  76      40.475  70.008  -8.906  1.00  0.00           H  
ATOM   1093 HD21 LEU A  76      39.641  69.306 -12.124  1.00  0.00           H  
ATOM   1094 HD22 LEU A  76      38.968  67.684 -11.976  1.00  0.00           H  
ATOM   1095 HD23 LEU A  76      40.710  67.903 -12.144  1.00  0.00           H  
ATOM   1096  N   LEU A  77      37.795  67.274  -7.401  1.00  0.00           N  
ATOM   1097  CA  LEU A  77      36.347  67.145  -7.299  1.00  0.00           C  
ATOM   1098  C   LEU A  77      35.696  68.494  -7.013  1.00  0.00           C  
ATOM   1099  O   LEU A  77      36.379  69.514  -6.900  1.00  0.00           O  
ATOM   1100  CB  LEU A  77      35.981  66.148  -6.198  1.00  0.00           C  
ATOM   1101  CG  LEU A  77      36.515  64.729  -6.405  1.00  0.00           C  
ATOM   1102  CD1 LEU A  77      36.295  63.889  -5.157  1.00  0.00           C  
ATOM   1103  CD2 LEU A  77      35.850  64.081  -7.611  1.00  0.00           C  
ATOM   1104  H   LEU A  77      38.256  67.942  -6.853  1.00  0.00           H  
ATOM   1105  HA  LEU A  77      35.979  66.775  -8.244  1.00  0.00           H  
ATOM   1106  HB2 LEU A  77      36.365  66.521  -5.261  1.00  0.00           H  
ATOM   1107  HB3 LEU A  77      34.904  66.096  -6.131  1.00  0.00           H  
ATOM   1108  HG  LEU A  77      37.578  64.776  -6.595  1.00  0.00           H  
ATOM   1109 HD11 LEU A  77      36.850  64.315  -4.335  1.00  0.00           H  
ATOM   1110 HD12 LEU A  77      36.637  62.879  -5.339  1.00  0.00           H  
ATOM   1111 HD13 LEU A  77      35.244  63.873  -4.914  1.00  0.00           H  
ATOM   1112 HD21 LEU A  77      36.270  63.099  -7.768  1.00  0.00           H  
ATOM   1113 HD22 LEU A  77      36.018  64.691  -8.487  1.00  0.00           H  
ATOM   1114 HD23 LEU A  77      34.787  63.993  -7.432  1.00  0.00           H  
ATOM   1115  N   HIS A  78      34.373  68.495  -6.899  1.00  0.00           N  
ATOM   1116  CA  HIS A  78      33.627  69.719  -6.627  1.00  0.00           C  
ATOM   1117  C   HIS A  78      33.895  70.218  -5.211  1.00  0.00           C  
ATOM   1118  O   HIS A  78      33.901  69.439  -4.258  1.00  0.00           O  
ATOM   1119  CB  HIS A  78      32.129  69.480  -6.821  1.00  0.00           C  
ATOM   1120  CG  HIS A  78      31.416  70.634  -7.456  1.00  0.00           C  
ATOM   1121  ND1 HIS A  78      31.399  71.901  -6.912  1.00  0.00           N  
ATOM   1122  CD2 HIS A  78      30.693  70.709  -8.599  1.00  0.00           C  
ATOM   1123  CE1 HIS A  78      30.694  72.703  -7.689  1.00  0.00           C  
ATOM   1124  NE2 HIS A  78      30.256  72.005  -8.720  1.00  0.00           N  
ATOM   1125  H   HIS A  78      33.884  67.651  -7.001  1.00  0.00           H  
ATOM   1126  HA  HIS A  78      33.956  70.469  -7.331  1.00  0.00           H  
ATOM   1127  HB2 HIS A  78      31.987  68.616  -7.453  1.00  0.00           H  
ATOM   1128  HB3 HIS A  78      31.674  69.296  -5.859  1.00  0.00           H  
ATOM   1129  HD1 HIS A  78      31.836  72.170  -6.077  1.00  0.00           H  
ATOM   1130  HD2 HIS A  78      30.496  69.899  -9.287  1.00  0.00           H  
ATOM   1131  HE1 HIS A  78      30.510  73.753  -7.512  1.00  0.00           H  
ATOM   1132  HE2 HIS A  78      29.638  72.335  -9.404  1.00  0.00           H  
ATOM   1133  N   ILE A  79      34.118  71.524  -5.082  1.00  0.00           N  
ATOM   1134  CA  ILE A  79      34.388  72.131  -3.783  1.00  0.00           C  
ATOM   1135  C   ILE A  79      33.343  71.709  -2.754  1.00  0.00           C  
ATOM   1136  O   ILE A  79      33.674  71.385  -1.613  1.00  0.00           O  
ATOM   1137  CB  ILE A  79      34.417  73.671  -3.876  1.00  0.00           C  
ATOM   1138  CG1 ILE A  79      34.805  74.281  -2.527  1.00  0.00           C  
ATOM   1139  CG2 ILE A  79      33.069  74.204  -4.337  1.00  0.00           C  
ATOM   1140  CD1 ILE A  79      35.371  75.680  -2.637  1.00  0.00           C  
ATOM   1141  H   ILE A  79      34.100  72.093  -5.881  1.00  0.00           H  
ATOM   1142  HA  ILE A  79      35.359  71.793  -3.453  1.00  0.00           H  
ATOM   1143  HB  ILE A  79      35.156  73.949  -4.613  1.00  0.00           H  
ATOM   1144 HG12 ILE A  79      33.931  74.326  -1.895  1.00  0.00           H  
ATOM   1145 HG13 ILE A  79      35.552  73.657  -2.057  1.00  0.00           H  
ATOM   1146 HG21 ILE A  79      33.138  75.270  -4.493  1.00  0.00           H  
ATOM   1147 HG22 ILE A  79      32.323  73.997  -3.584  1.00  0.00           H  
ATOM   1148 HG23 ILE A  79      32.789  73.721  -5.263  1.00  0.00           H  
ATOM   1149 HD11 ILE A  79      34.566  76.381  -2.803  1.00  0.00           H  
ATOM   1150 HD12 ILE A  79      36.063  75.725  -3.464  1.00  0.00           H  
ATOM   1151 HD13 ILE A  79      35.885  75.934  -1.722  1.00  0.00           H  
ATOM   1152  N   ASN A  80      32.080  71.705  -3.172  1.00  0.00           N  
ATOM   1153  CA  ASN A  80      30.987  71.312  -2.293  1.00  0.00           C  
ATOM   1154  C   ASN A  80      31.233  69.918  -1.722  1.00  0.00           C  
ATOM   1155  O   ASN A  80      30.759  69.586  -0.636  1.00  0.00           O  
ATOM   1156  CB  ASN A  80      29.656  71.344  -3.050  1.00  0.00           C  
ATOM   1157  CG  ASN A  80      28.819  72.557  -2.696  1.00  0.00           C  
ATOM   1158  OD1 ASN A  80      28.538  72.812  -1.525  1.00  0.00           O  
ATOM   1159  ND2 ASN A  80      28.416  73.312  -3.711  1.00  0.00           N  
ATOM   1160  H   ASN A  80      31.881  71.966  -4.095  1.00  0.00           H  
ATOM   1161  HA  ASN A  80      30.945  72.019  -1.478  1.00  0.00           H  
ATOM   1162  HB2 ASN A  80      29.854  71.363  -4.111  1.00  0.00           H  
ATOM   1163  HB3 ASN A  80      29.089  70.455  -2.810  1.00  0.00           H  
ATOM   1164 HD21 ASN A  80      28.677  73.049  -4.618  1.00  0.00           H  
ATOM   1165 HD22 ASN A  80      27.873  74.104  -3.510  1.00  0.00           H  
ATOM   1166  N   ASP A  81      31.987  69.108  -2.463  1.00  0.00           N  
ATOM   1167  CA  ASP A  81      32.305  67.755  -2.029  1.00  0.00           C  
ATOM   1168  C   ASP A  81      33.357  67.775  -0.925  1.00  0.00           C  
ATOM   1169  O   ASP A  81      33.434  66.856  -0.110  1.00  0.00           O  
ATOM   1170  CB  ASP A  81      32.800  66.921  -3.214  1.00  0.00           C  
ATOM   1171  CG  ASP A  81      32.062  65.603  -3.342  1.00  0.00           C  
ATOM   1172  OD1 ASP A  81      30.855  65.628  -3.660  1.00  0.00           O  
ATOM   1173  OD2 ASP A  81      32.692  64.547  -3.123  1.00  0.00           O  
ATOM   1174  H   ASP A  81      32.341  69.432  -3.317  1.00  0.00           H  
ATOM   1175  HA  ASP A  81      31.401  67.310  -1.641  1.00  0.00           H  
ATOM   1176  HB2 ASP A  81      32.658  67.482  -4.125  1.00  0.00           H  
ATOM   1177  HB3 ASP A  81      33.852  66.713  -3.086  1.00  0.00           H  
ATOM   1178  N   ILE A  82      34.167  68.830  -0.903  1.00  0.00           N  
ATOM   1179  CA  ILE A  82      35.215  68.969   0.102  1.00  0.00           C  
ATOM   1180  C   ILE A  82      34.625  69.322   1.462  1.00  0.00           C  
ATOM   1181  O   ILE A  82      33.609  70.013   1.549  1.00  0.00           O  
ATOM   1182  CB  ILE A  82      36.238  70.050  -0.297  1.00  0.00           C  
ATOM   1183  CG1 ILE A  82      36.696  69.845  -1.742  1.00  0.00           C  
ATOM   1184  CG2 ILE A  82      37.427  70.026   0.651  1.00  0.00           C  
ATOM   1185  CD1 ILE A  82      37.707  70.871  -2.207  1.00  0.00           C  
ATOM   1186  H   ILE A  82      34.059  69.532  -1.579  1.00  0.00           H  
ATOM   1187  HA  ILE A  82      35.732  68.023   0.178  1.00  0.00           H  
ATOM   1188  HB  ILE A  82      35.761  71.014  -0.211  1.00  0.00           H  
ATOM   1189 HG12 ILE A  82      37.148  68.869  -1.835  1.00  0.00           H  
ATOM   1190 HG13 ILE A  82      35.838  69.904  -2.396  1.00  0.00           H  
ATOM   1191 HG21 ILE A  82      37.979  69.108   0.513  1.00  0.00           H  
ATOM   1192 HG22 ILE A  82      37.077  70.086   1.670  1.00  0.00           H  
ATOM   1193 HG23 ILE A  82      38.071  70.868   0.442  1.00  0.00           H  
ATOM   1194 HD11 ILE A  82      37.269  71.486  -2.978  1.00  0.00           H  
ATOM   1195 HD12 ILE A  82      38.578  70.367  -2.600  1.00  0.00           H  
ATOM   1196 HD13 ILE A  82      37.998  71.494  -1.372  1.00  0.00           H  
ATOM   1197  N   ILE A  83      35.269  68.847   2.525  1.00  0.00           N  
ATOM   1198  CA  ILE A  83      34.807  69.117   3.881  1.00  0.00           C  
ATOM   1199  C   ILE A  83      35.943  69.652   4.751  1.00  0.00           C  
ATOM   1200  O   ILE A  83      36.660  68.883   5.390  1.00  0.00           O  
ATOM   1201  CB  ILE A  83      34.225  67.851   4.537  1.00  0.00           C  
ATOM   1202  CG1 ILE A  83      33.228  67.173   3.597  1.00  0.00           C  
ATOM   1203  CG2 ILE A  83      33.561  68.199   5.861  1.00  0.00           C  
ATOM   1204  CD1 ILE A  83      32.005  68.014   3.305  1.00  0.00           C  
ATOM   1205  H   ILE A  83      36.074  68.304   2.392  1.00  0.00           H  
ATOM   1206  HA  ILE A  83      34.026  69.860   3.826  1.00  0.00           H  
ATOM   1207  HB  ILE A  83      35.039  67.170   4.741  1.00  0.00           H  
ATOM   1208 HG12 ILE A  83      33.716  66.963   2.657  1.00  0.00           H  
ATOM   1209 HG13 ILE A  83      32.896  66.246   4.041  1.00  0.00           H  
ATOM   1210 HG21 ILE A  83      32.675  68.790   5.675  1.00  0.00           H  
ATOM   1211 HG22 ILE A  83      34.248  68.764   6.473  1.00  0.00           H  
ATOM   1212 HG23 ILE A  83      33.285  67.291   6.377  1.00  0.00           H  
ATOM   1213 HD11 ILE A  83      31.155  67.612   3.836  1.00  0.00           H  
ATOM   1214 HD12 ILE A  83      31.804  68.001   2.242  1.00  0.00           H  
ATOM   1215 HD13 ILE A  83      32.182  69.031   3.624  1.00  0.00           H  
ATOM   1216  N   PRO A  84      36.119  70.984   4.786  1.00  0.00           N  
ATOM   1217  CA  PRO A  84      37.174  71.620   5.582  1.00  0.00           C  
ATOM   1218  C   PRO A  84      36.890  71.555   7.079  1.00  0.00           C  
ATOM   1219  O   PRO A  84      35.886  70.985   7.507  1.00  0.00           O  
ATOM   1220  CB  PRO A  84      37.160  73.069   5.097  1.00  0.00           C  
ATOM   1221  CG  PRO A  84      35.768  73.291   4.617  1.00  0.00           C  
ATOM   1222  CD  PRO A  84      35.307  71.974   4.053  1.00  0.00           C  
ATOM   1223  HA  PRO A  84      38.141  71.179   5.380  1.00  0.00           H  
ATOM   1224  HB2 PRO A  84      37.407  73.729   5.917  1.00  0.00           H  
ATOM   1225  HB3 PRO A  84      37.876  73.192   4.299  1.00  0.00           H  
ATOM   1226  HG2 PRO A  84      35.137  73.586   5.443  1.00  0.00           H  
ATOM   1227  HG3 PRO A  84      35.761  74.049   3.848  1.00  0.00           H  
ATOM   1228  HD2 PRO A  84      34.255  71.828   4.246  1.00  0.00           H  
ATOM   1229  HD3 PRO A  84      35.509  71.927   2.993  1.00  0.00           H  
ATOM   1230  N   GLU A  85      37.780  72.144   7.870  1.00  0.00           N  
ATOM   1231  CA  GLU A  85      37.625  72.154   9.320  1.00  0.00           C  
ATOM   1232  C   GLU A  85      38.171  73.450   9.916  1.00  0.00           C  
ATOM   1233  O   GLU A  85      39.097  73.433  10.729  1.00  0.00           O  
ATOM   1234  CB  GLU A  85      38.341  70.951   9.938  1.00  0.00           C  
ATOM   1235  CG  GLU A  85      37.448  69.730  10.099  1.00  0.00           C  
ATOM   1236  CD  GLU A  85      38.205  68.429   9.924  1.00  0.00           C  
ATOM   1237  OE1 GLU A  85      38.837  67.973  10.899  1.00  0.00           O  
ATOM   1238  OE2 GLU A  85      38.166  67.866   8.809  1.00  0.00           O  
ATOM   1239  H   GLU A  85      38.560  72.583   7.469  1.00  0.00           H  
ATOM   1240  HA  GLU A  85      36.571  72.088   9.540  1.00  0.00           H  
ATOM   1241  HB2 GLU A  85      39.175  70.679   9.307  1.00  0.00           H  
ATOM   1242  HB3 GLU A  85      38.713  71.229  10.912  1.00  0.00           H  
ATOM   1243  HG2 GLU A  85      37.015  69.746  11.088  1.00  0.00           H  
ATOM   1244  HG3 GLU A  85      36.661  69.776   9.361  1.00  0.00           H  
ATOM   1245  N   SER A  86      37.590  74.574   9.508  1.00  0.00           N  
ATOM   1246  CA  SER A  86      38.017  75.878  10.000  1.00  0.00           C  
ATOM   1247  C   SER A  86      36.814  76.732  10.390  1.00  0.00           C  
ATOM   1248  O   SER A  86      35.702  76.505   9.916  1.00  0.00           O  
ATOM   1249  CB  SER A  86      38.848  76.600   8.939  1.00  0.00           C  
ATOM   1250  OG  SER A  86      39.461  75.679   8.055  1.00  0.00           O  
ATOM   1251  H   SER A  86      36.858  74.524   8.858  1.00  0.00           H  
ATOM   1252  HA  SER A  86      38.629  75.718  10.875  1.00  0.00           H  
ATOM   1253  HB2 SER A  86      38.207  77.255   8.367  1.00  0.00           H  
ATOM   1254  HB3 SER A  86      39.618  77.184   9.423  1.00  0.00           H  
ATOM   1255  HG  SER A  86      40.033  75.089   8.554  1.00  0.00           H  
ATOM   1256  N   SER A  87      37.046  77.712  11.258  1.00  0.00           N  
ATOM   1257  CA  SER A  87      35.981  78.598  11.711  1.00  0.00           C  
ATOM   1258  C   SER A  87      36.172  80.008  11.162  1.00  0.00           C  
ATOM   1259  O   SER A  87      35.202  80.715  10.890  1.00  0.00           O  
ATOM   1260  CB  SER A  87      35.937  78.636  13.240  1.00  0.00           C  
ATOM   1261  OG  SER A  87      36.005  77.329  13.786  1.00  0.00           O  
ATOM   1262  H   SER A  87      37.955  77.841  11.600  1.00  0.00           H  
ATOM   1263  HA  SER A  87      35.045  78.206  11.344  1.00  0.00           H  
ATOM   1264  HB2 SER A  87      36.777  79.209  13.608  1.00  0.00           H  
ATOM   1265  HB3 SER A  87      35.018  79.100  13.561  1.00  0.00           H  
ATOM   1266  HG  SER A  87      35.419  76.748  13.297  1.00  0.00           H  
ATOM   1267  N   GLY A  88      37.430  80.412  11.004  1.00  0.00           N  
ATOM   1268  CA  GLY A  88      37.723  81.736  10.490  1.00  0.00           C  
ATOM   1269  C   GLY A  88      37.662  82.804  11.566  1.00  0.00           C  
ATOM   1270  O   GLY A  88      37.522  82.487  12.747  1.00  0.00           O  
ATOM   1271  H   GLY A  88      38.162  79.805  11.239  1.00  0.00           H  
ATOM   1272  HA2 GLY A  88      38.713  81.731  10.057  1.00  0.00           H  
ATOM   1273  HA3 GLY A  88      37.007  81.978   9.719  1.00  0.00           H  
ATOM   1274  N   PRO A  89      37.766  84.090  11.187  1.00  0.00           N  
ATOM   1275  CA  PRO A  89      37.721  85.201  12.142  1.00  0.00           C  
ATOM   1276  C   PRO A  89      36.332  85.389  12.746  1.00  0.00           C  
ATOM   1277  O   PRO A  89      35.356  84.807  12.275  1.00  0.00           O  
ATOM   1278  CB  PRO A  89      38.104  86.416  11.294  1.00  0.00           C  
ATOM   1279  CG  PRO A  89      37.721  86.043   9.903  1.00  0.00           C  
ATOM   1280  CD  PRO A  89      37.935  84.559   9.798  1.00  0.00           C  
ATOM   1281  HA  PRO A  89      38.441  85.070  12.935  1.00  0.00           H  
ATOM   1282  HB2 PRO A  89      37.559  87.284  11.637  1.00  0.00           H  
ATOM   1283  HB3 PRO A  89      39.166  86.594  11.376  1.00  0.00           H  
ATOM   1284  HG2 PRO A  89      36.683  86.285   9.732  1.00  0.00           H  
ATOM   1285  HG3 PRO A  89      38.350  86.564   9.199  1.00  0.00           H  
ATOM   1286  HD2 PRO A  89      37.197  84.115   9.148  1.00  0.00           H  
ATOM   1287  HD3 PRO A  89      38.932  84.345   9.439  1.00  0.00           H  
ATOM   1288  N   SER A  90      36.254  86.207  13.791  1.00  0.00           N  
ATOM   1289  CA  SER A  90      34.985  86.472  14.459  1.00  0.00           C  
ATOM   1290  C   SER A  90      34.776  87.972  14.654  1.00  0.00           C  
ATOM   1291  O   SER A  90      35.600  88.783  14.230  1.00  0.00           O  
ATOM   1292  CB  SER A  90      34.937  85.760  15.811  1.00  0.00           C  
ATOM   1293  OG  SER A  90      34.327  84.485  15.695  1.00  0.00           O  
ATOM   1294  H   SER A  90      37.067  86.643  14.119  1.00  0.00           H  
ATOM   1295  HA  SER A  90      34.194  86.090  13.832  1.00  0.00           H  
ATOM   1296  HB2 SER A  90      35.943  85.628  16.182  1.00  0.00           H  
ATOM   1297  HB3 SER A  90      34.370  86.355  16.511  1.00  0.00           H  
ATOM   1298  HG  SER A  90      34.669  84.035  14.918  1.00  0.00           H  
ATOM   1299  N   SER A  91      33.670  88.331  15.298  1.00  0.00           N  
ATOM   1300  CA  SER A  91      33.356  89.732  15.549  1.00  0.00           C  
ATOM   1301  C   SER A  91      32.087  89.863  16.387  1.00  0.00           C  
ATOM   1302  O   SER A  91      32.010  90.699  17.287  1.00  0.00           O  
ATOM   1303  CB  SER A  91      33.187  90.483  14.227  1.00  0.00           C  
ATOM   1304  OG  SER A  91      32.378  89.751  13.323  1.00  0.00           O  
ATOM   1305  H   SER A  91      33.053  87.638  15.612  1.00  0.00           H  
ATOM   1306  HA  SER A  91      34.180  90.165  16.097  1.00  0.00           H  
ATOM   1307  HB2 SER A  91      32.718  91.438  14.416  1.00  0.00           H  
ATOM   1308  HB3 SER A  91      34.157  90.641  13.779  1.00  0.00           H  
ATOM   1309  HG  SER A  91      32.894  89.038  12.939  1.00  0.00           H  
ATOM   1310  N   GLY A  92      31.097  89.030  16.086  1.00  0.00           N  
ATOM   1311  CA  GLY A  92      29.846  89.068  16.820  1.00  0.00           C  
ATOM   1312  C   GLY A  92      28.866  90.072  16.244  1.00  0.00           C  
ATOM   1313  O   GLY A  92      27.816  90.307  16.877  1.00  0.00           O  
ATOM   1314  OXT GLY A  92      29.149  90.623  15.160  1.00  0.00           O  
ATOM   1315  H   GLY A  92      31.215  88.384  15.358  1.00  0.00           H  
ATOM   1316  HA2 GLY A  92      29.396  88.087  16.796  1.00  0.00           H  
ATOM   1317  HA3 GLY A  92      30.052  89.332  17.847  1.00  0.00           H  
TER    1318      GLY A  92                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
