
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   56 (  864),  selected   56 , name 1g5v_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 1g5v_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E       1           -
LGA    -       -      N       2           -
LGA    -       -      L       3           -
LGA    -       -      Y       4           -
LGA    -       -      F       5           -
LGA    -       -      Q       6           -
LGA    Q    90_A      G       7          5.418
LGA    Q    91_A      D       8          1.826
LGA    W    92_A      L       9          1.639
LGA    K    93_A      I      10          2.161
LGA    V    94_A      V      11          1.044
LGA    G    95_A      S      12          0.763
LGA    D    96_A      M      13          0.808
LGA    K    97_A      R      14          0.697
LGA    C    98_A      I      15          0.662
LGA    S    99_A      L      16          0.328
LGA    A   100_A      G      17          0.670
LGA    I   101_A      K      18          1.445
LGA    W   102_A      K      19          1.059
LGA    S   103_A      R      20          0.607
LGA    E   104_A      T      21          2.573
LGA    D   105_A      -       -           -
LGA    G   106_A      K      22          1.865
LGA    C   107_A      T      23          1.088
LGA    I   108_A      W      24          1.415
LGA    Y   109_A      X      25          0.635
LGA    P   110_A      K      26          0.223
LGA    A   111_A      G      27          1.308
LGA    T   112_A      T      28          0.950
LGA    I   113_A      L      29          0.737
LGA    A   114_A      I      30          0.542
LGA    S   115_A      A      31          0.852
LGA    I   116_A      I      32          0.999
LGA    D   117_A      Q      33          0.611
LGA    F   118_A      T      34          2.229
LGA    K   119_A      V      35          2.315
LGA    -       -      G      36           -
LGA    -       -      P      37           -
LGA    R   120_A      G      38          3.053
LGA    E   121_A      K      39          0.865
LGA    T   122_A      K      40          0.777
LGA    C   123_A      Y      41          1.550
LGA    V   124_A      K      42          0.615
LGA    V   125_A      V      43          0.568
LGA    V   126_A      K      44          0.784
LGA    Y   127_A      F      45          0.582
LGA    T   128_A      D      46          0.854
LGA    G   129_A      N      47          2.099
LGA    Y   130_A      K      48          2.151
LGA    G   131_A      -       -           -
LGA    N   132_A      G      49          0.226
LGA    R   133_A      K      50          0.154
LGA    E   134_A      S      51          0.511
LGA    E   135_A      L      52          0.703
LGA    Q   136_A      L      53          0.298
LGA    N   137_A      S      54          0.853
LGA    L   138_A      G      55          1.918
LGA    S   139_A      N      56          3.412
LGA    D   140_A      X      57          2.892
LGA    L   141_A      I      58          1.816
LGA    L   142_A      A      59          0.367
LGA    S   143_A      Y      60          0.914
LGA    P   144_A      D      61          0.591
LGA    I   145_A      Y      62          4.020

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   56   62    5.0     54    1.65     7.41     81.402     3.080

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.905196 * X  +  -0.292509 * Y  +   0.308315 * Z  +  39.369675
  Y_new =  -0.339931 * X  +   0.933740 * Y  +  -0.112147 * Z  +  69.263016
  Z_new =  -0.255082 * X  +  -0.206321 * Y  +  -0.944651 * Z  +  -2.138051 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.926559    0.215033  [ DEG:  -167.6795     12.3205 ]
  Theta =   0.257932    2.883660  [ DEG:    14.7784    165.2216 ]
  Phi   =  -2.782355    0.359238  [ DEG:  -159.4172     20.5828 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1g5v_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1g5v_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   56   62   5.0   54   1.65    7.41  81.402
REMARK  ---------------------------------------------------------- 
MOLECULE 1g5v_A
HEADER    TRANSLATION                             02-NOV-00   1G5V              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF THE HUMAN SMN               
TITLE    2 PROTEIN                                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SURVIVAL MOTOR NEURON PROTEIN 1;                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SMN1;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET9D;                                    
SOURCE  10 EXPRESSION_SYSTEM_GENE: EXPRESSED AS FUSION PROTEIN WITH N-          
SOURCE  11 TERMINAL HIS6-GST AND TEV CLEAVAGE SITE                              
KEYWDS    MRNA PROCESSING                                                       
EXPDTA    NMR, 10 STRUCTURES                                                    
AUTHOR    P.SELENKO,R.SPRANGERS,G.STIER,D.BUEHLER,U.FISCHER,M.SATTLER           
REVDAT   2   01-APR-03 1G5V    1       JRNL                                     
REVDAT   1   02-MAY-01 1G5V    0                                                
JRNL        AUTH   P.SELENKO,R.SPRANGERS,G.STIER,D.BUHLER,U.FISCHER,            
JRNL        AUTH 2 M.SATTLER                                                    
JRNL        TITL   SMN TUDOR DOMAIN STRUCTURE AND ITS INTERACTION               
JRNL        TITL 2 WITH THE SM PROTEINS.                                        
JRNL        REF    NAT.STRUCT.BIOL.              V.   8    27 2001              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1G5V A   82   169  UNP    Q16637   SMN_HUMAN       82    169             
SEQRES   1 A   88  LYS LYS ASN THR ALA ALA SER LEU GLN GLN TRP LYS VAL          
SEQRES   2 A   88  GLY ASP LYS CYS SER ALA ILE TRP SER GLU ASP GLY CYS          
SEQRES   3 A   88  ILE TYR PRO ALA THR ILE ALA SER ILE ASP PHE LYS ARG          
SEQRES   4 A   88  GLU THR CYS VAL VAL VAL TYR THR GLY TYR GLY ASN ARG          
SEQRES   5 A   88  GLU GLU GLN ASN LEU SER ASP LEU LEU SER PRO ILE CYS          
SEQRES   6 A   88  GLU VAL ALA ASN ASN ILE GLU GLN ASN ALA GLN GLU ASN          
SEQRES   7 A   88  GLU ASN GLU SER GLN VAL SER THR ASP GLU                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLN A  90      36.520  80.784   4.510  1.00  7.42           N  
ATOM      2  CA  GLN A  90      35.851  80.782   3.217  1.00  8.00           C  
ATOM      3  C   GLN A  90      36.861  80.962   2.087  1.00  8.02           C  
ATOM      4  O   GLN A  90      38.056  81.127   2.336  1.00  8.02           O  
ATOM      5  CB  GLN A  90      34.795  81.888   3.158  1.00  8.61           C  
ATOM      6  CG  GLN A  90      35.306  83.243   3.625  1.00  9.27           C  
ATOM      7  CD  GLN A  90      35.481  84.225   2.484  1.00  9.99           C  
ATOM      8  OE1 GLN A  90      34.659  84.284   1.568  1.00 10.31           O  
ATOM      9  NE2 GLN A  90      36.553  85.005   2.532  1.00 10.47           N  
ATOM     10  H   GLN A  90      36.352  81.519   5.137  1.00  7.43           H  
ATOM     11  HA  GLN A  90      35.363  79.825   3.096  1.00  8.21           H  
ATOM     12  HB2 GLN A  90      34.453  81.990   2.140  1.00  8.80           H  
ATOM     13  HB3 GLN A  90      33.961  81.609   3.783  1.00  8.62           H  
ATOM     14  HG2 GLN A  90      34.601  83.655   4.329  1.00  9.33           H  
ATOM     15  HG3 GLN A  90      36.260  83.105   4.112  1.00  9.38           H  
ATOM     16 HE21 GLN A  90      37.166  84.903   3.292  1.00 10.35           H  
ATOM     17 HE22 GLN A  90      36.692  85.649   1.807  1.00 11.04           H  
ATOM     18  N   GLN A  91      36.374  80.931   0.850  1.00  8.30           N  
ATOM     19  CA  GLN A  91      37.231  81.091  -0.321  1.00  8.58           C  
ATOM     20  C   GLN A  91      38.306  80.007  -0.364  1.00  7.86           C  
ATOM     21  O   GLN A  91      39.343  80.121   0.290  1.00  7.55           O  
ATOM     22  CB  GLN A  91      37.885  82.474  -0.322  1.00  9.49           C  
ATOM     23  CG  GLN A  91      38.689  82.767  -1.578  1.00  9.88           C  
ATOM     24  CD  GLN A  91      38.643  84.230  -1.974  1.00 10.82           C  
ATOM     25  OE1 GLN A  91      38.285  85.092  -1.170  1.00 11.18           O  
ATOM     26  NE2 GLN A  91      39.005  84.518  -3.216  1.00 11.40           N  
ATOM     27  H   GLN A  91      35.412  80.796   0.720  1.00  8.47           H  
ATOM     28  HA  GLN A  91      36.610  80.997  -1.200  1.00  8.82           H  
ATOM     29  HB2 GLN A  91      37.112  83.224  -0.231  1.00  9.92           H  
ATOM     30  HB3 GLN A  91      38.546  82.548   0.529  1.00  9.67           H  
ATOM     31  HG2 GLN A  91      39.718  82.491  -1.404  1.00  9.76           H  
ATOM     32  HG3 GLN A  91      38.292  82.176  -2.390  1.00  9.84           H  
ATOM     33 HE21 GLN A  91      39.281  83.781  -3.802  1.00 11.23           H  
ATOM     34 HE22 GLN A  91      38.987  85.457  -3.500  1.00 12.09           H  
ATOM     35  N   TRP A  92      38.048  78.958  -1.137  1.00  7.74           N  
ATOM     36  CA  TRP A  92      38.991  77.854  -1.265  1.00  7.12           C  
ATOM     37  C   TRP A  92      40.191  78.252  -2.119  1.00  7.81           C  
ATOM     38  O   TRP A  92      40.041  78.899  -3.156  1.00  8.60           O  
ATOM     39  CB  TRP A  92      38.295  76.636  -1.874  1.00  6.73           C  
ATOM     40  CG  TRP A  92      37.266  76.024  -0.971  1.00  6.11           C  
ATOM     41  CD1 TRP A  92      35.936  75.863  -1.236  1.00  6.47           C  
ATOM     42  CD2 TRP A  92      37.482  75.499   0.344  1.00  5.26           C  
ATOM     43  NE1 TRP A  92      35.312  75.269  -0.168  1.00  5.95           N  
ATOM     44  CE2 TRP A  92      36.239  75.034   0.814  1.00  5.17           C  
ATOM     45  CE3 TRP A  92      38.603  75.374   1.168  1.00  4.81           C  
ATOM     46  CZ2 TRP A  92      36.088  74.456   2.073  1.00  4.65           C  
ATOM     47  CZ3 TRP A  92      38.453  74.797   2.416  1.00  4.27           C  
ATOM     48  CH2 TRP A  92      37.203  74.346   2.857  1.00  4.18           C  
ATOM     49  H   TRP A  92      37.204  78.926  -1.634  1.00  8.17           H  
ATOM     50  HA  TRP A  92      39.338  77.598  -0.275  1.00  6.55           H  
ATOM     51  HB2 TRP A  92      37.803  76.930  -2.790  1.00  7.42           H  
ATOM     52  HB3 TRP A  92      39.035  75.880  -2.097  1.00  6.37           H  
ATOM     53  HD1 TRP A  92      35.458  76.165  -2.157  1.00  7.20           H  
ATOM     54  HE1 TRP A  92      34.359  75.045  -0.114  1.00  6.25           H  
ATOM     55  HE3 TRP A  92      39.576  75.716   0.845  1.00  5.13           H  
ATOM     56  HZ2 TRP A  92      35.131  74.101   2.428  1.00  4.86           H  
ATOM     57  HZ3 TRP A  92      39.308  74.694   3.067  1.00  4.21           H  
ATOM     58  HH2 TRP A  92      37.131  73.903   3.840  1.00  4.03           H  
ATOM     59  N   LYS A  93      41.383  77.856  -1.677  1.00  7.67           N  
ATOM     60  CA  LYS A  93      42.612  78.166  -2.401  1.00  8.46           C  
ATOM     61  C   LYS A  93      43.599  77.007  -2.310  1.00  8.08           C  
ATOM     62  O   LYS A  93      43.386  76.054  -1.558  1.00  7.25           O  
ATOM     63  CB  LYS A  93      43.252  79.442  -1.846  1.00  9.25           C  
ATOM     64  CG  LYS A  93      43.789  79.293  -0.432  1.00 10.03           C  
ATOM     65  CD  LYS A  93      44.768  80.405  -0.087  1.00 10.80           C  
ATOM     66  CE  LYS A  93      46.046  79.856   0.522  1.00 11.72           C  
ATOM     67  NZ  LYS A  93      45.798  79.183   1.827  1.00 12.39           N  
ATOM     68  H   LYS A  93      41.436  77.341  -0.844  1.00  7.13           H  
ATOM     69  HA  LYS A  93      42.354  78.323  -3.437  1.00  8.90           H  
ATOM     70  HB2 LYS A  93      44.071  79.727  -2.490  1.00  9.17           H  
ATOM     71  HB3 LYS A  93      42.515  80.232  -1.847  1.00  9.53           H  
ATOM     72  HG2 LYS A  93      42.962  79.328   0.262  1.00 10.14           H  
ATOM     73  HG3 LYS A  93      44.293  78.342  -0.346  1.00 10.10           H  
ATOM     74  HD2 LYS A  93      45.013  80.947  -0.989  1.00 10.94           H  
ATOM     75  HD3 LYS A  93      44.301  81.075   0.620  1.00 10.75           H  
ATOM     76  HE2 LYS A  93      46.477  79.140  -0.163  1.00 11.97           H  
ATOM     77  HE3 LYS A  93      46.739  80.670   0.672  1.00 11.81           H  
ATOM     78  HZ1 LYS A  93      46.077  79.808   2.609  1.00 12.71           H  
ATOM     79  HZ2 LYS A  93      46.348  78.303   1.888  1.00 12.53           H  
ATOM     80  HZ3 LYS A  93      44.788  78.954   1.923  1.00 12.60           H  
ATOM     81  N   VAL A  94      44.679  77.095  -3.080  1.00  8.81           N  
ATOM     82  CA  VAL A  94      45.699  76.051  -3.083  1.00  8.73           C  
ATOM     83  C   VAL A  94      46.405  75.972  -1.734  1.00  8.69           C  
ATOM     84  O   VAL A  94      46.790  76.992  -1.163  1.00  9.36           O  
ATOM     85  CB  VAL A  94      46.749  76.288  -4.186  1.00  9.74           C  
ATOM     86  CG1 VAL A  94      47.496  75.000  -4.494  1.00  9.66           C  
ATOM     87  CG2 VAL A  94      46.096  76.846  -5.441  1.00 10.15           C  
ATOM     88  H   VAL A  94      44.794  77.878  -3.656  1.00  9.49           H  
ATOM     89  HA  VAL A  94      45.209  75.108  -3.278  1.00  8.07           H  
ATOM     90  HB  VAL A  94      47.463  77.012  -3.825  1.00 10.36           H  
ATOM     91 HG11 VAL A  94      48.228  74.816  -3.722  1.00  9.56           H  
ATOM     92 HG12 VAL A  94      46.797  74.179  -4.530  1.00  9.67           H  
ATOM     93 HG13 VAL A  94      47.994  75.092  -5.447  1.00  9.89           H  
ATOM     94 HG21 VAL A  94      45.212  76.272  -5.675  1.00 10.19           H  
ATOM     95 HG22 VAL A  94      45.819  77.877  -5.275  1.00 10.42           H  
ATOM     96 HG23 VAL A  94      46.791  76.789  -6.265  1.00 10.36           H  
ATOM     97  N   GLY A  95      46.567  74.753  -1.230  1.00  8.04           N  
ATOM     98  CA  GLY A  95      47.221  74.560   0.052  1.00  8.20           C  
ATOM     99  C   GLY A  95      46.303  74.865   1.218  1.00  7.64           C  
ATOM    100  O   GLY A  95      46.458  75.884   1.891  1.00  8.10           O  
ATOM    101  H   GLY A  95      46.236  73.978  -1.728  1.00  7.54           H  
ATOM    102  HA2 GLY A  95      47.550  73.534   0.124  1.00  8.06           H  
ATOM    103  HA3 GLY A  95      48.082  75.209   0.105  1.00  9.01           H  
ATOM    104  N   ASP A  96      45.339  73.979   1.455  1.00  6.70           N  
ATOM    105  CA  ASP A  96      44.388  74.158   2.546  1.00  6.20           C  
ATOM    106  C   ASP A  96      43.951  72.811   3.114  1.00  5.53           C  
ATOM    107  O   ASP A  96      43.722  71.857   2.371  1.00  4.92           O  
ATOM    108  CB  ASP A  96      43.165  74.939   2.060  1.00  5.87           C  
ATOM    109  CG  ASP A  96      43.044  76.298   2.721  1.00  6.35           C  
ATOM    110  OD1 ASP A  96      44.075  76.827   3.187  1.00  6.81           O  
ATOM    111  OD2 ASP A  96      41.918  76.837   2.769  1.00  6.44           O  
ATOM    112  H   ASP A  96      45.265  73.188   0.884  1.00  6.39           H  
ATOM    113  HA  ASP A  96      44.878  74.722   3.326  1.00  6.75           H  
ATOM    114  HB2 ASP A  96      43.240  75.085   0.994  1.00  6.15           H  
ATOM    115  HB3 ASP A  96      42.273  74.371   2.280  1.00  5.22           H  
ATOM    116  N   LYS A  97      43.837  72.745   4.438  1.00  5.83           N  
ATOM    117  CA  LYS A  97      43.427  71.517   5.111  1.00  5.62           C  
ATOM    118  C   LYS A  97      41.908  71.398   5.144  1.00  4.80           C  
ATOM    119  O   LYS A  97      41.243  72.022   5.972  1.00  4.86           O  
ATOM    120  CB  LYS A  97      43.983  71.485   6.537  1.00  6.55           C  
ATOM    121  CG  LYS A  97      45.295  70.731   6.663  1.00  7.39           C  
ATOM    122  CD  LYS A  97      45.169  69.545   7.606  1.00  7.70           C  
ATOM    123  CE  LYS A  97      45.844  68.307   7.037  1.00  8.21           C  
ATOM    124  NZ  LYS A  97      46.734  67.651   8.034  1.00  9.10           N  
ATOM    125  H   LYS A  97      44.034  73.541   4.974  1.00  6.34           H  
ATOM    126  HA  LYS A  97      43.831  70.684   4.559  1.00  5.59           H  
ATOM    127  HB2 LYS A  97      44.141  72.500   6.873  1.00  6.81           H  
ATOM    128  HB3 LYS A  97      43.257  71.012   7.183  1.00  6.52           H  
ATOM    129  HG2 LYS A  97      45.588  70.372   5.687  1.00  7.35           H  
ATOM    130  HG3 LYS A  97      46.051  71.403   7.043  1.00  8.01           H  
ATOM    131  HD2 LYS A  97      45.636  69.794   8.548  1.00  8.14           H  
ATOM    132  HD3 LYS A  97      44.123  69.333   7.766  1.00  7.34           H  
ATOM    133  HE2 LYS A  97      45.082  67.604   6.733  1.00  7.96           H  
ATOM    134  HE3 LYS A  97      46.432  68.595   6.178  1.00  8.38           H  
ATOM    135  HZ1 LYS A  97      46.306  67.698   8.981  1.00  9.44           H  
ATOM    136  HZ2 LYS A  97      47.657  68.129   8.061  1.00  9.31           H  
ATOM    137  HZ3 LYS A  97      46.882  66.652   7.783  1.00  9.40           H  
ATOM    138  N   CYS A  98      41.363  70.593   4.237  1.00  4.16           N  
ATOM    139  CA  CYS A  98      39.921  70.389   4.160  1.00  3.60           C  
ATOM    140  C   CYS A  98      39.561  68.930   4.418  1.00  3.78           C  
ATOM    141  O   CYS A  98      40.417  68.129   4.792  1.00  4.46           O  
ATOM    142  CB  CYS A  98      39.398  70.821   2.788  1.00  2.97           C  
ATOM    143  SG  CYS A  98      39.821  69.686   1.447  1.00  2.58           S  
ATOM    144  H   CYS A  98      41.945  70.124   3.603  1.00  4.21           H  
ATOM    145  HA  CYS A  98      39.458  71.002   4.920  1.00  3.89           H  
ATOM    146  HB2 CYS A  98      38.322  70.895   2.827  1.00  2.90           H  
ATOM    147  HB3 CYS A  98      39.810  71.789   2.542  1.00  3.27           H  
ATOM    148  HG  CYS A  98      39.070  68.601   1.578  1.00  2.63           H  
ATOM    149  N   SER A  99      38.291  68.592   4.214  1.00  3.54           N  
ATOM    150  CA  SER A  99      37.819  67.227   4.424  1.00  4.08           C  
ATOM    151  C   SER A  99      37.010  66.745   3.226  1.00  3.73           C  
ATOM    152  O   SER A  99      36.087  67.426   2.773  1.00  3.54           O  
ATOM    153  CB  SER A  99      36.966  67.148   5.692  1.00  5.02           C  
ATOM    154  OG  SER A  99      37.532  66.251   6.632  1.00  5.76           O  
ATOM    155  H   SER A  99      37.658  69.276   3.918  1.00  3.26           H  
ATOM    156  HA  SER A  99      38.681  66.591   4.541  1.00  4.35           H  
ATOM    157  HB2 SER A  99      36.903  68.129   6.142  1.00  4.95           H  
ATOM    158  HB3 SER A  99      35.975  66.805   5.437  1.00  5.41           H  
ATOM    159  HG  SER A  99      38.363  66.606   6.955  1.00  6.10           H  
ATOM    160  N   ALA A 100      37.361  65.571   2.710  1.00  3.97           N  
ATOM    161  CA  ALA A 100      36.666  65.005   1.559  1.00  3.95           C  
ATOM    162  C   ALA A 100      36.219  63.572   1.827  1.00  4.93           C  
ATOM    163  O   ALA A 100      36.919  62.803   2.489  1.00  5.47           O  
ATOM    164  CB  ALA A 100      37.560  65.060   0.329  1.00  3.19           C  
ATOM    165  H   ALA A 100      38.105  65.074   3.111  1.00  4.37           H  
ATOM    166  HA  ALA A 100      35.795  65.612   1.368  1.00  4.02           H  
ATOM    167  HB1 ALA A 100      38.453  65.624   0.556  1.00  3.13           H  
ATOM    168  HB2 ALA A 100      37.833  64.056   0.039  1.00  3.18           H  
ATOM    169  HB3 ALA A 100      37.027  65.537  -0.481  1.00  3.31           H  
ATOM    170  N   ILE A 101      35.046  63.222   1.307  1.00  5.36           N  
ATOM    171  CA  ILE A 101      34.494  61.884   1.483  1.00  6.34           C  
ATOM    172  C   ILE A 101      35.047  60.924   0.433  1.00  6.26           C  
ATOM    173  O   ILE A 101      35.275  61.309  -0.715  1.00  5.81           O  
ATOM    174  CB  ILE A 101      32.955  61.893   1.395  1.00  7.10           C  
ATOM    175  CG1 ILE A 101      32.392  63.152   2.056  1.00  7.16           C  
ATOM    176  CG2 ILE A 101      32.381  60.645   2.045  1.00  8.16           C  
ATOM    177  CD1 ILE A 101      31.564  64.007   1.120  1.00  7.47           C  
ATOM    178  H   ILE A 101      34.537  63.883   0.795  1.00  5.16           H  
ATOM    179  HA  ILE A 101      34.779  61.530   2.464  1.00  6.77           H  
ATOM    180  HB  ILE A 101      32.677  61.885   0.353  1.00  6.97           H  
ATOM    181 HG12 ILE A 101      31.762  62.865   2.885  1.00  7.79           H  
ATOM    182 HG13 ILE A 101      33.209  63.757   2.422  1.00  6.50           H  
ATOM    183 HG21 ILE A 101      32.611  60.649   3.101  1.00  8.60           H  
ATOM    184 HG22 ILE A 101      31.309  60.631   1.913  1.00  8.42           H  
ATOM    185 HG23 ILE A 101      32.811  59.767   1.588  1.00  8.42           H  
ATOM    186 HD11 ILE A 101      30.517  63.792   1.268  1.00  7.80           H  
ATOM    187 HD12 ILE A 101      31.749  65.052   1.326  1.00  7.53           H  
ATOM    188 HD13 ILE A 101      31.836  63.789   0.097  1.00  7.60           H  
ATOM    189  N   TRP A 102      35.262  59.674   0.834  1.00  6.86           N  
ATOM    190  CA  TRP A 102      35.789  58.661  -0.072  1.00  6.96           C  
ATOM    191  C   TRP A 102      34.661  57.944  -0.809  1.00  7.60           C  
ATOM    192  O   TRP A 102      33.588  57.715  -0.250  1.00  8.38           O  
ATOM    193  CB  TRP A 102      36.637  57.646   0.702  1.00  7.61           C  
ATOM    194  CG  TRP A 102      37.742  57.033  -0.109  1.00  7.54           C  
ATOM    195  CD1 TRP A 102      38.096  57.345  -1.393  1.00  6.89           C  
ATOM    196  CD2 TRP A 102      38.638  55.997   0.312  1.00  8.31           C  
ATOM    197  NE1 TRP A 102      39.155  56.566  -1.792  1.00  7.22           N  
ATOM    198  CE2 TRP A 102      39.506  55.732  -0.764  1.00  8.10           C  
ATOM    199  CE3 TRP A 102      38.789  55.269   1.495  1.00  9.26           C  
ATOM    200  CZ2 TRP A 102      40.510  54.769  -0.691  1.00  8.82           C  
ATOM    201  CZ3 TRP A 102      39.787  54.313   1.567  1.00  9.95           C  
ATOM    202  CH2 TRP A 102      40.635  54.072   0.478  1.00  9.73           C  
ATOM    203  H   TRP A 102      35.062  59.430   1.761  1.00  7.33           H  
ATOM    204  HA  TRP A 102      36.415  59.159  -0.798  1.00  6.25           H  
ATOM    205  HB2 TRP A 102      37.086  58.140   1.551  1.00  7.50           H  
ATOM    206  HB3 TRP A 102      35.999  56.850   1.053  1.00  8.39           H  
ATOM    207  HD1 TRP A 102      37.607  58.095  -1.992  1.00  6.33           H  
ATOM    208  HE1 TRP A 102      39.589  56.604  -2.671  1.00  6.98           H  
ATOM    209  HE3 TRP A 102      38.144  55.440   2.344  1.00  9.54           H  
ATOM    210  HZ2 TRP A 102      41.173  54.572  -1.520  1.00  8.75           H  
ATOM    211  HZ3 TRP A 102      39.918  53.741   2.471  1.00 10.73           H  
ATOM    212  HH2 TRP A 102      41.400  53.317   0.579  1.00 10.36           H  
ATOM    213  N   SER A 103      34.914  57.596  -2.067  1.00  7.36           N  
ATOM    214  CA  SER A 103      33.922  56.907  -2.885  1.00  8.04           C  
ATOM    215  C   SER A 103      34.124  55.397  -2.826  1.00  8.76           C  
ATOM    216  O   SER A 103      33.666  54.664  -3.705  1.00  9.24           O  
ATOM    217  CB  SER A 103      34.005  57.389  -4.336  1.00  7.63           C  
ATOM    218  OG  SER A 103      33.133  58.482  -4.562  1.00  7.51           O  
ATOM    219  H   SER A 103      35.788  57.809  -2.455  1.00  6.79           H  
ATOM    220  HA  SER A 103      32.945  57.144  -2.492  1.00  8.46           H  
ATOM    221  HB2 SER A 103      35.017  57.702  -4.550  1.00  7.67           H  
ATOM    222  HB3 SER A 103      33.731  56.580  -4.998  1.00  7.68           H  
ATOM    223  HG  SER A 103      32.285  58.156  -4.874  1.00  7.54           H  
ATOM    224  N   GLU A 104      34.813  54.935  -1.787  1.00  8.96           N  
ATOM    225  CA  GLU A 104      35.078  53.512  -1.614  1.00  9.78           C  
ATOM    226  C   GLU A 104      34.263  52.941  -0.459  1.00 10.72           C  
ATOM    227  O   GLU A 104      33.756  51.819  -0.539  1.00 11.50           O  
ATOM    228  CB  GLU A 104      36.568  53.278  -1.364  1.00  9.65           C  
ATOM    229  CG  GLU A 104      37.431  53.476  -2.600  1.00  9.77           C  
ATOM    230  CD  GLU A 104      38.378  52.316  -2.844  1.00 10.55           C  
ATOM    231  OE1 GLU A 104      38.089  51.202  -2.360  1.00 10.87           O  
ATOM    232  OE2 GLU A 104      39.405  52.523  -3.524  1.00 10.99           O  
ATOM    233  H   GLU A 104      35.153  55.570  -1.120  1.00  8.64           H  
ATOM    234  HA  GLU A 104      34.792  53.009  -2.525  1.00  9.92           H  
ATOM    235  HB2 GLU A 104      36.907  53.964  -0.601  1.00  9.03           H  
ATOM    236  HB3 GLU A 104      36.708  52.266  -1.013  1.00 10.24           H  
ATOM    237  HG2 GLU A 104      36.787  53.582  -3.460  1.00  9.51           H  
ATOM    238  HG3 GLU A 104      38.012  54.377  -2.475  1.00  9.72           H  
ATOM    239  N   ASP A 105      34.139  53.716   0.613  1.00 10.68           N  
ATOM    240  CA  ASP A 105      33.384  53.286   1.785  1.00 11.61           C  
ATOM    241  C   ASP A 105      32.384  54.356   2.210  1.00 11.51           C  
ATOM    242  O   ASP A 105      31.512  54.107   3.044  1.00 12.31           O  
ATOM    243  CB  ASP A 105      34.332  52.972   2.943  1.00 12.02           C  
ATOM    244  CG  ASP A 105      35.062  51.655   2.753  1.00 12.58           C  
ATOM    245  OD1 ASP A 105      34.419  50.680   2.309  1.00 12.80           O  
ATOM    246  OD2 ASP A 105      36.274  51.599   3.048  1.00 12.93           O  
ATOM    247  H   ASP A 105      34.564  54.598   0.617  1.00 10.04           H  
ATOM    248  HA  ASP A 105      32.843  52.390   1.520  1.00 12.21           H  
ATOM    249  HB2 ASP A 105      35.066  53.760   3.023  1.00 11.64           H  
ATOM    250  HB3 ASP A 105      33.765  52.919   3.862  1.00 12.44           H  
ATOM    251  N   GLY A 106      32.516  55.545   1.631  1.00 10.59           N  
ATOM    252  CA  GLY A 106      31.617  56.635   1.963  1.00 10.51           C  
ATOM    253  C   GLY A 106      31.821  57.141   3.378  1.00 10.58           C  
ATOM    254  O   GLY A 106      30.915  57.060   4.209  1.00 11.27           O  
ATOM    255  H   GLY A 106      33.230  55.683   0.975  1.00 10.02           H  
ATOM    256  HA2 GLY A 106      31.785  57.448   1.273  1.00  9.82           H  
ATOM    257  HA3 GLY A 106      30.599  56.292   1.858  1.00 11.16           H  
ATOM    258  N   CYS A 107      33.011  57.662   3.652  1.00  9.96           N  
ATOM    259  CA  CYS A 107      33.333  58.183   4.977  1.00 10.08           C  
ATOM    260  C   CYS A 107      34.160  59.460   4.872  1.00  9.03           C  
ATOM    261  O   CYS A 107      34.754  59.743   3.831  1.00  8.22           O  
ATOM    262  CB  CYS A 107      34.094  57.133   5.788  1.00 10.82           C  
ATOM    263  SG  CYS A 107      33.032  56.044   6.766  1.00 12.07           S  
ATOM    264  H   CYS A 107      33.692  57.698   2.949  1.00  9.48           H  
ATOM    265  HA  CYS A 107      32.404  58.409   5.478  1.00 10.51           H  
ATOM    266  HB2 CYS A 107      34.666  56.514   5.115  1.00 10.74           H  
ATOM    267  HB3 CYS A 107      34.767  57.633   6.469  1.00 10.81           H  
ATOM    268  HG  CYS A 107      31.892  56.680   6.992  1.00 12.45           H  
ATOM    269  N   ILE A 108      34.197  60.229   5.957  1.00  9.09           N  
ATOM    270  CA  ILE A 108      34.952  61.477   5.986  1.00  8.18           C  
ATOM    271  C   ILE A 108      36.414  61.228   6.344  1.00  8.20           C  
ATOM    272  O   ILE A 108      36.714  60.575   7.343  1.00  9.05           O  
ATOM    273  CB  ILE A 108      34.353  62.475   6.995  1.00  8.31           C  
ATOM    274  CG1 ILE A 108      32.840  62.587   6.800  1.00  8.80           C  
ATOM    275  CG2 ILE A 108      35.014  63.837   6.853  1.00  7.33           C  
ATOM    276  CD1 ILE A 108      32.039  61.909   7.889  1.00  9.51           C  
ATOM    277  H   ILE A 108      33.704  59.949   6.758  1.00  9.78           H  
ATOM    278  HA  ILE A 108      34.904  61.918   5.002  1.00  7.48           H  
ATOM    279  HB  ILE A 108      34.553  62.107   7.992  1.00  8.90           H  
ATOM    280 HG12 ILE A 108      32.562  63.630   6.784  1.00  8.60           H  
ATOM    281 HG13 ILE A 108      32.571  62.135   5.857  1.00  9.01           H  
ATOM    282 HG21 ILE A 108      34.278  64.566   6.549  1.00  7.23           H  
ATOM    283 HG22 ILE A 108      35.441  64.131   7.799  1.00  7.20           H  
ATOM    284 HG23 ILE A 108      35.794  63.783   6.108  1.00  7.09           H  
ATOM    285 HD11 ILE A 108      32.542  62.034   8.836  1.00  9.82           H  
ATOM    286 HD12 ILE A 108      31.055  62.353   7.941  1.00  9.78           H  
ATOM    287 HD13 ILE A 108      31.945  60.857   7.666  1.00  9.63           H  
ATOM    288  N   TYR A 109      37.317  61.755   5.526  1.00  7.40           N  
ATOM    289  CA  TYR A 109      38.748  61.594   5.760  1.00  7.58           C  
ATOM    290  C   TYR A 109      39.501  62.880   5.424  1.00  6.75           C  
ATOM    291  O   TYR A 109      39.144  63.585   4.481  1.00  5.79           O  
ATOM    292  CB  TYR A 109      39.296  60.433   4.925  1.00  7.78           C  
ATOM    293  CG  TYR A 109      38.847  59.069   5.406  1.00  8.74           C  
ATOM    294  CD1 TYR A 109      39.107  58.647   6.704  1.00  9.44           C  
ATOM    295  CD2 TYR A 109      38.162  58.206   4.558  1.00  9.05           C  
ATOM    296  CE1 TYR A 109      38.698  57.403   7.144  1.00 10.35           C  
ATOM    297  CE2 TYR A 109      37.748  56.960   4.993  1.00  9.98           C  
ATOM    298  CZ  TYR A 109      38.018  56.564   6.285  1.00 10.60           C  
ATOM    299  OH  TYR A 109      37.610  55.325   6.723  1.00 11.54           O  
ATOM    300  H   TYR A 109      37.016  62.269   4.747  1.00  6.76           H  
ATOM    301  HA  TYR A 109      38.889  61.370   6.807  1.00  8.35           H  
ATOM    302  HB2 TYR A 109      38.968  60.548   3.903  1.00  7.11           H  
ATOM    303  HB3 TYR A 109      40.375  60.456   4.955  1.00  7.98           H  
ATOM    304  HD1 TYR A 109      39.637  59.306   7.375  1.00  9.32           H  
ATOM    305  HD2 TYR A 109      37.951  58.519   3.547  1.00  8.62           H  
ATOM    306  HE1 TYR A 109      38.908  57.093   8.156  1.00 10.91           H  
ATOM    307  HE2 TYR A 109      37.218  56.303   4.320  1.00 10.28           H  
ATOM    308  HH  TYR A 109      37.835  55.221   7.649  1.00 11.63           H  
ATOM    309  N   PRO A 110      40.558  63.204   6.194  1.00  7.22           N  
ATOM    310  CA  PRO A 110      41.359  64.414   5.971  1.00  6.71           C  
ATOM    311  C   PRO A 110      41.807  64.556   4.520  1.00  6.03           C  
ATOM    312  O   PRO A 110      42.108  63.565   3.853  1.00  6.34           O  
ATOM    313  CB  PRO A 110      42.566  64.208   6.887  1.00  7.77           C  
ATOM    314  CG  PRO A 110      42.055  63.340   7.983  1.00  8.66           C  
ATOM    315  CD  PRO A 110      41.055  62.420   7.343  1.00  8.42           C  
ATOM    316  HA  PRO A 110      40.824  65.304   6.269  1.00  6.30           H  
ATOM    317  HB2 PRO A 110      43.363  63.725   6.339  1.00  7.86           H  
ATOM    318  HB3 PRO A 110      42.905  65.162   7.263  1.00  7.87           H  
ATOM    319  HG2 PRO A 110      42.868  62.775   8.415  1.00  9.09           H  
ATOM    320  HG3 PRO A 110      41.577  63.946   8.739  1.00  9.14           H  
ATOM    321  HD2 PRO A 110      41.537  61.511   7.012  1.00  8.74           H  
ATOM    322  HD3 PRO A 110      40.254  62.193   8.031  1.00  8.86           H  
ATOM    323  N   ALA A 111      41.842  65.793   4.034  1.00  5.22           N  
ATOM    324  CA  ALA A 111      42.248  66.065   2.660  1.00  4.71           C  
ATOM    325  C   ALA A 111      42.998  67.388   2.552  1.00  4.65           C  
ATOM    326  O   ALA A 111      43.015  68.183   3.493  1.00  4.72           O  
ATOM    327  CB  ALA A 111      41.032  66.075   1.746  1.00  3.76           C  
ATOM    328  H   ALA A 111      41.587  66.541   4.613  1.00  5.07           H  
ATOM    329  HA  ALA A 111      42.901  65.266   2.340  1.00  5.28           H  
ATOM    330  HB1 ALA A 111      41.134  66.867   1.019  1.00  3.53           H  
ATOM    331  HB2 ALA A 111      40.957  65.126   1.235  1.00  3.83           H  
ATOM    332  HB3 ALA A 111      40.141  66.239   2.334  1.00  3.72           H  
ATOM    333  N   THR A 112      43.618  67.616   1.397  1.00  4.78           N  
ATOM    334  CA  THR A 112      44.370  68.843   1.158  1.00  5.14           C  
ATOM    335  C   THR A 112      44.241  69.290  -0.294  1.00  4.91           C  
ATOM    336  O   THR A 112      44.682  68.594  -1.210  1.00  5.15           O  
ATOM    337  CB  THR A 112      45.862  68.662   1.496  1.00  6.32           C  
ATOM    338  OG1 THR A 112      46.004  67.885   2.692  1.00  6.81           O  
ATOM    339  CG2 THR A 112      46.543  70.010   1.681  1.00  6.83           C  
ATOM    340  H   THR A 112      43.565  66.942   0.689  1.00  4.82           H  
ATOM    341  HA  THR A 112      43.968  69.613   1.800  1.00  4.95           H  
ATOM    342  HB  THR A 112      46.341  68.142   0.679  1.00  6.59           H  
ATOM    343  HG1 THR A 112      46.929  67.845   2.941  1.00  6.86           H  
ATOM    344 HG21 THR A 112      46.225  70.683   0.898  1.00  6.78           H  
ATOM    345 HG22 THR A 112      47.614  69.883   1.633  1.00  7.40           H  
ATOM    346 HG23 THR A 112      46.271  70.422   2.641  1.00  6.91           H  
ATOM    347  N   ILE A 113      43.632  70.455  -0.498  1.00  4.70           N  
ATOM    348  CA  ILE A 113      43.442  70.996  -1.841  1.00  4.93           C  
ATOM    349  C   ILE A 113      44.783  71.270  -2.516  1.00  6.00           C  
ATOM    350  O   ILE A 113      45.492  72.208  -2.154  1.00  6.70           O  
ATOM    351  CB  ILE A 113      42.610  72.293  -1.810  1.00  4.99           C  
ATOM    352  CG1 ILE A 113      41.277  72.053  -1.101  1.00  4.08           C  
ATOM    353  CG2 ILE A 113      42.378  72.806  -3.223  1.00  5.66           C  
ATOM    354  CD1 ILE A 113      41.000  73.031   0.023  1.00  4.34           C  
ATOM    355  H   ILE A 113      43.301  70.963   0.273  1.00  4.58           H  
ATOM    356  HA  ILE A 113      42.902  70.261  -2.420  1.00  4.50           H  
ATOM    357  HB  ILE A 113      43.170  73.041  -1.269  1.00  5.46           H  
ATOM    358 HG12 ILE A 113      40.474  72.139  -1.816  1.00  4.02           H  
ATOM    359 HG13 ILE A 113      41.273  71.057  -0.681  1.00  3.58           H  
ATOM    360 HG21 ILE A 113      43.329  73.017  -3.690  1.00  6.04           H  
ATOM    361 HG22 ILE A 113      41.853  72.054  -3.796  1.00  5.85           H  
ATOM    362 HG23 ILE A 113      41.787  73.709  -3.185  1.00  5.84           H  
ATOM    363 HD11 ILE A 113      40.831  74.015  -0.392  1.00  4.53           H  
ATOM    364 HD12 ILE A 113      40.124  72.715   0.569  1.00  4.66           H  
ATOM    365 HD13 ILE A 113      41.850  73.063   0.689  1.00  4.37           H  
ATOM    366  N   ALA A 114      45.130  70.431  -3.488  1.00  6.19           N  
ATOM    367  CA  ALA A 114      46.396  70.564  -4.204  1.00  7.25           C  
ATOM    368  C   ALA A 114      46.275  71.462  -5.436  1.00  7.83           C  
ATOM    369  O   ALA A 114      47.194  72.219  -5.748  1.00  8.77           O  
ATOM    370  CB  ALA A 114      46.913  69.191  -4.606  1.00  7.35           C  
ATOM    371  H   ALA A 114      44.528  69.692  -3.715  1.00  5.66           H  
ATOM    372  HA  ALA A 114      47.113  71.005  -3.527  1.00  7.70           H  
ATOM    373  HB1 ALA A 114      47.350  68.706  -3.745  1.00  7.34           H  
ATOM    374  HB2 ALA A 114      46.096  68.593  -4.980  1.00  7.27           H  
ATOM    375  HB3 ALA A 114      47.663  69.299  -5.375  1.00  7.76           H  
ATOM    376  N   SER A 115      45.148  71.374  -6.137  1.00  7.42           N  
ATOM    377  CA  SER A 115      44.934  72.181  -7.335  1.00  8.19           C  
ATOM    378  C   SER A 115      43.459  72.515  -7.510  1.00  7.84           C  
ATOM    379  O   SER A 115      42.588  71.810  -7.006  1.00  6.96           O  
ATOM    380  CB  SER A 115      45.450  71.442  -8.571  1.00  8.69           C  
ATOM    381  OG  SER A 115      46.690  71.972  -9.005  1.00  9.20           O  
ATOM    382  H   SER A 115      44.446  70.753  -5.850  1.00  6.69           H  
ATOM    383  HA  SER A 115      45.489  73.100  -7.219  1.00  8.81           H  
ATOM    384  HB2 SER A 115      45.584  70.396  -8.334  1.00  8.76           H  
ATOM    385  HB3 SER A 115      44.730  71.539  -9.372  1.00  8.78           H  
ATOM    386  HG  SER A 115      46.979  72.652  -8.392  1.00  9.31           H  
ATOM    387  N   ILE A 116      43.184  73.603  -8.223  1.00  8.68           N  
ATOM    388  CA  ILE A 116      41.811  74.036  -8.460  1.00  8.72           C  
ATOM    389  C   ILE A 116      41.634  74.568  -9.876  1.00  9.82           C  
ATOM    390  O   ILE A 116      42.543  75.176 -10.440  1.00 10.64           O  
ATOM    391  CB  ILE A 116      41.392  75.130  -7.458  1.00  8.70           C  
ATOM    392  CG1 ILE A 116      41.600  74.654  -6.023  1.00  7.65           C  
ATOM    393  CG2 ILE A 116      39.941  75.535  -7.680  1.00  8.99           C  
ATOM    394  CD1 ILE A 116      42.408  75.619  -5.187  1.00  7.79           C  
ATOM    395  H   ILE A 116      43.922  74.131  -8.593  1.00  9.37           H  
ATOM    396  HA  ILE A 116      41.162  73.183  -8.320  1.00  8.07           H  
ATOM    397  HB  ILE A 116      42.011  75.996  -7.633  1.00  9.38           H  
ATOM    398 HG12 ILE A 116      40.639  74.523  -5.548  1.00  6.99           H  
ATOM    399 HG13 ILE A 116      42.121  73.708  -6.037  1.00  7.54           H  
ATOM    400 HG21 ILE A 116      39.899  76.348  -8.390  1.00  9.25           H  
ATOM    401 HG22 ILE A 116      39.387  74.692  -8.063  1.00  9.06           H  
ATOM    402 HG23 ILE A 116      39.509  75.854  -6.743  1.00  9.11           H  
ATOM    403 HD11 ILE A 116      42.224  75.429  -4.139  1.00  7.72           H  
ATOM    404 HD12 ILE A 116      43.458  75.486  -5.399  1.00  7.97           H  
ATOM    405 HD13 ILE A 116      42.118  76.632  -5.426  1.00  7.97           H  
ATOM    406  N   ASP A 117      40.451  74.341 -10.443  1.00  9.92           N  
ATOM    407  CA  ASP A 117      40.149  74.805 -11.790  1.00 11.01           C  
ATOM    408  C   ASP A 117      38.845  75.599 -11.804  1.00 11.42           C  
ATOM    409  O   ASP A 117      37.763  75.034 -11.964  1.00 11.09           O  
ATOM    410  CB  ASP A 117      40.053  73.621 -12.754  1.00 11.04           C  
ATOM    411  CG  ASP A 117      41.113  72.571 -12.488  1.00 11.32           C  
ATOM    412  OD1 ASP A 117      40.910  71.739 -11.579  1.00 11.56           O  
ATOM    413  OD2 ASP A 117      42.146  72.580 -13.191  1.00 11.44           O  
ATOM    414  H   ASP A 117      39.767  73.858  -9.937  1.00  9.31           H  
ATOM    415  HA  ASP A 117      40.954  75.452 -12.103  1.00 11.61           H  
ATOM    416  HB2 ASP A 117      39.082  73.159 -12.653  1.00 10.47           H  
ATOM    417  HB3 ASP A 117      40.171  73.981 -13.767  1.00 11.55           H  
ATOM    418  N   PHE A 118      38.960  76.912 -11.625  1.00 12.23           N  
ATOM    419  CA  PHE A 118      37.796  77.794 -11.604  1.00 12.79           C  
ATOM    420  C   PHE A 118      36.948  77.642 -12.865  1.00 13.61           C  
ATOM    421  O   PHE A 118      35.763  77.977 -12.867  1.00 14.24           O  
ATOM    422  CB  PHE A 118      38.242  79.250 -11.453  1.00 13.45           C  
ATOM    423  CG  PHE A 118      39.041  79.508 -10.209  1.00 12.78           C  
ATOM    424  CD1 PHE A 118      38.445  79.437  -8.958  1.00 12.45           C  
ATOM    425  CD2 PHE A 118      40.389  79.825 -10.287  1.00 12.56           C  
ATOM    426  CE1 PHE A 118      39.177  79.675  -7.812  1.00 11.89           C  
ATOM    427  CE2 PHE A 118      41.126  80.064  -9.143  1.00 12.01           C  
ATOM    428  CZ  PHE A 118      40.520  79.988  -7.904  1.00 11.67           C  
ATOM    429  H   PHE A 118      39.850  77.296 -11.491  1.00 12.52           H  
ATOM    430  HA  PHE A 118      37.195  77.524 -10.750  1.00 12.17           H  
ATOM    431  HB2 PHE A 118      38.851  79.522 -12.303  1.00 14.05           H  
ATOM    432  HB3 PHE A 118      37.368  79.885 -11.427  1.00 13.92           H  
ATOM    433  HD1 PHE A 118      37.396  79.190  -8.886  1.00 12.68           H  
ATOM    434  HD2 PHE A 118      40.863  79.883 -11.255  1.00 12.88           H  
ATOM    435  HE1 PHE A 118      38.701  79.616  -6.844  1.00 11.70           H  
ATOM    436  HE2 PHE A 118      42.174  80.310  -9.218  1.00 11.91           H  
ATOM    437  HZ  PHE A 118      41.095  80.174  -7.008  1.00 11.29           H  
ATOM    438  N   LYS A 119      37.558  77.140 -13.936  1.00 13.66           N  
ATOM    439  CA  LYS A 119      36.850  76.951 -15.200  1.00 14.45           C  
ATOM    440  C   LYS A 119      35.584  76.121 -15.001  1.00 14.19           C  
ATOM    441  O   LYS A 119      34.472  76.621 -15.162  1.00 14.83           O  
ATOM    442  CB  LYS A 119      37.759  76.280 -16.234  1.00 14.52           C  
ATOM    443  CG  LYS A 119      38.747  75.290 -15.635  1.00 15.42           C  
ATOM    444  CD  LYS A 119      40.133  75.454 -16.235  1.00 16.01           C  
ATOM    445  CE  LYS A 119      40.191  74.931 -17.664  1.00 16.53           C  
ATOM    446  NZ  LYS A 119      39.686  73.534 -17.768  1.00 16.87           N  
ATOM    447  H   LYS A 119      38.505  76.895 -13.876  1.00 13.20           H  
ATOM    448  HA  LYS A 119      36.568  77.927 -15.567  1.00 15.26           H  
ATOM    449  HB2 LYS A 119      37.144  75.753 -16.948  1.00 14.10           H  
ATOM    450  HB3 LYS A 119      38.320  77.045 -16.750  1.00 14.43           H  
ATOM    451  HG2 LYS A 119      38.805  75.453 -14.569  1.00 15.78           H  
ATOM    452  HG3 LYS A 119      38.397  74.286 -15.827  1.00 15.41           H  
ATOM    453  HD2 LYS A 119      40.391  76.502 -16.237  1.00 16.18           H  
ATOM    454  HD3 LYS A 119      40.842  74.906 -15.633  1.00 16.03           H  
ATOM    455  HE2 LYS A 119      39.589  75.569 -18.292  1.00 16.67           H  
ATOM    456  HE3 LYS A 119      41.218  74.961 -18.002  1.00 16.65           H  
ATOM    457  HZ1 LYS A 119      39.930  73.135 -18.697  1.00 17.07           H  
ATOM    458  HZ2 LYS A 119      38.653  73.518 -17.656  1.00 16.84           H  
ATOM    459  HZ3 LYS A 119      40.113  72.943 -17.026  1.00 17.09           H  
ATOM    460  N   ARG A 120      35.763  74.849 -14.651  1.00 13.31           N  
ATOM    461  CA  ARG A 120      34.635  73.950 -14.432  1.00 13.08           C  
ATOM    462  C   ARG A 120      34.278  73.869 -12.950  1.00 12.15           C  
ATOM    463  O   ARG A 120      33.675  72.893 -12.500  1.00 11.68           O  
ATOM    464  CB  ARG A 120      34.957  72.554 -14.970  1.00 12.82           C  
ATOM    465  CG  ARG A 120      34.565  72.358 -16.424  1.00 13.39           C  
ATOM    466  CD  ARG A 120      33.103  71.961 -16.560  1.00 13.47           C  
ATOM    467  NE  ARG A 120      32.380  72.843 -17.473  1.00 14.06           N  
ATOM    468  CZ  ARG A 120      31.971  72.473 -18.685  1.00 14.44           C  
ATOM    469  NH1 ARG A 120      32.215  71.246 -19.127  1.00 14.31           N  
ATOM    470  NH2 ARG A 120      31.318  73.333 -19.455  1.00 15.09           N  
ATOM    471  H   ARG A 120      36.674  74.509 -14.539  1.00 12.85           H  
ATOM    472  HA  ARG A 120      33.787  74.346 -14.971  1.00 13.86           H  
ATOM    473  HB2 ARG A 120      36.020  72.384 -14.877  1.00 12.38           H  
ATOM    474  HB3 ARG A 120      34.431  71.822 -14.374  1.00 12.75           H  
ATOM    475  HG2 ARG A 120      34.727  73.281 -16.959  1.00 13.86           H  
ATOM    476  HG3 ARG A 120      35.183  71.580 -16.851  1.00 13.42           H  
ATOM    477  HD2 ARG A 120      33.053  70.950 -16.936  1.00 13.44           H  
ATOM    478  HD3 ARG A 120      32.639  72.007 -15.587  1.00 13.26           H  
ATOM    479  HE  ARG A 120      32.188  73.753 -17.170  1.00 14.28           H  
ATOM    480 HH11 ARG A 120      32.706  70.595 -18.549  1.00 13.92           H  
ATOM    481 HH12 ARG A 120      31.905  70.974 -20.038  1.00 14.68           H  
ATOM    482 HH21 ARG A 120      31.132  74.257 -19.126  1.00 15.30           H  
ATOM    483 HH22 ARG A 120      31.010  73.055 -20.364  1.00 15.44           H  
ATOM    484  N   GLU A 121      34.648  74.908 -12.202  1.00 11.98           N  
ATOM    485  CA  GLU A 121      34.368  74.973 -10.768  1.00 11.15           C  
ATOM    486  C   GLU A 121      34.652  73.636 -10.085  1.00 10.00           C  
ATOM    487  O   GLU A 121      33.754  73.018  -9.508  1.00  9.65           O  
ATOM    488  CB  GLU A 121      32.913  75.383 -10.535  1.00 11.64           C  
ATOM    489  CG  GLU A 121      32.607  76.809 -10.967  1.00 12.24           C  
ATOM    490  CD  GLU A 121      31.131  77.142 -10.884  1.00 13.04           C  
ATOM    491  OE1 GLU A 121      30.444  76.585 -10.004  1.00 13.22           O  
ATOM    492  OE2 GLU A 121      30.661  77.964 -11.702  1.00 13.61           O  
ATOM    493  H   GLU A 121      35.115  75.654 -12.630  1.00 12.47           H  
ATOM    494  HA  GLU A 121      35.015  75.723 -10.339  1.00 11.10           H  
ATOM    495  HB2 GLU A 121      32.268  74.715 -11.087  1.00 12.14           H  
ATOM    496  HB3 GLU A 121      32.689  75.295  -9.481  1.00 11.21           H  
ATOM    497  HG2 GLU A 121      33.149  77.489 -10.329  1.00 12.02           H  
ATOM    498  HG3 GLU A 121      32.935  76.939 -11.989  1.00 12.45           H  
ATOM    499  N   THR A 122      35.904  73.194 -10.152  1.00  9.51           N  
ATOM    500  CA  THR A 122      36.302  71.932  -9.541  1.00  8.44           C  
ATOM    501  C   THR A 122      37.648  72.066  -8.835  1.00  7.82           C  
ATOM    502  O   THR A 122      38.240  73.144  -8.809  1.00  8.35           O  
ATOM    503  CB  THR A 122      36.398  70.805 -10.586  1.00  8.64           C  
ATOM    504  OG1 THR A 122      36.898  71.324 -11.825  1.00  9.57           O  
ATOM    505  CG2 THR A 122      35.037  70.162 -10.814  1.00  8.95           C  
ATOM    506  H   THR A 122      36.576  73.731 -10.621  1.00  9.95           H  
ATOM    507  HA  THR A 122      35.551  71.659  -8.814  1.00  8.02           H  
ATOM    508  HB  THR A 122      37.078  70.050 -10.219  1.00  7.97           H  
ATOM    509  HG1 THR A 122      36.676  72.254 -11.894  1.00  9.63           H  
ATOM    510 HG21 THR A 122      34.810  69.501  -9.991  1.00  9.10           H  
ATOM    511 HG22 THR A 122      35.057  69.597 -11.734  1.00  9.07           H  
ATOM    512 HG23 THR A 122      34.283  70.930 -10.879  1.00  9.12           H  
ATOM    513  N   CYS A 123      38.125  70.963  -8.267  1.00  6.82           N  
ATOM    514  CA  CYS A 123      39.402  70.956  -7.562  1.00  6.32           C  
ATOM    515  C   CYS A 123      39.881  69.531  -7.309  1.00  5.48           C  
ATOM    516  O   CYS A 123      39.144  68.570  -7.527  1.00  5.04           O  
ATOM    517  CB  CYS A 123      39.279  71.711  -6.236  1.00  5.96           C  
ATOM    518  SG  CYS A 123      38.460  70.773  -4.925  1.00  5.05           S  
ATOM    519  H   CYS A 123      37.607  70.134  -8.322  1.00  6.52           H  
ATOM    520  HA  CYS A 123      40.126  71.461  -8.185  1.00  6.99           H  
ATOM    521  HB2 CYS A 123      40.268  71.970  -5.884  1.00  5.78           H  
ATOM    522  HB3 CYS A 123      38.713  72.618  -6.395  1.00  6.61           H  
ATOM    523  HG  CYS A 123      38.716  71.373  -3.770  1.00  4.94           H  
ATOM    524  N   VAL A 124      41.118  69.405  -6.843  1.00  5.51           N  
ATOM    525  CA  VAL A 124      41.706  68.103  -6.553  1.00  5.03           C  
ATOM    526  C   VAL A 124      42.139  68.025  -5.094  1.00  4.47           C  
ATOM    527  O   VAL A 124      42.863  68.894  -4.607  1.00  4.86           O  
ATOM    528  CB  VAL A 124      42.920  67.821  -7.458  1.00  5.88           C  
ATOM    529  CG1 VAL A 124      43.550  66.479  -7.112  1.00  5.71           C  
ATOM    530  CG2 VAL A 124      42.517  67.867  -8.923  1.00  6.50           C  
ATOM    531  H   VAL A 124      41.652  70.211  -6.690  1.00  6.04           H  
ATOM    532  HA  VAL A 124      40.955  67.347  -6.740  1.00  4.69           H  
ATOM    533  HB  VAL A 124      43.657  68.592  -7.285  1.00  6.36           H  
ATOM    534 HG11 VAL A 124      44.399  66.637  -6.463  1.00  5.77           H  
ATOM    535 HG12 VAL A 124      42.823  65.859  -6.609  1.00  5.91           H  
ATOM    536 HG13 VAL A 124      43.875  65.989  -8.019  1.00  5.68           H  
ATOM    537 HG21 VAL A 124      42.369  66.861  -9.288  1.00  6.91           H  
ATOM    538 HG22 VAL A 124      41.599  68.427  -9.025  1.00  6.56           H  
ATOM    539 HG23 VAL A 124      43.297  68.348  -9.496  1.00  6.75           H  
ATOM    540  N   VAL A 125      41.689  66.987  -4.396  1.00  3.79           N  
ATOM    541  CA  VAL A 125      42.032  66.814  -2.991  1.00  3.55           C  
ATOM    542  C   VAL A 125      42.964  65.626  -2.782  1.00  4.11           C  
ATOM    543  O   VAL A 125      42.829  64.592  -3.440  1.00  4.19           O  
ATOM    544  CB  VAL A 125      40.773  66.615  -2.127  1.00  2.74           C  
ATOM    545  CG1 VAL A 125      39.995  67.916  -2.009  1.00  2.53           C  
ATOM    546  CG2 VAL A 125      39.898  65.512  -2.702  1.00  2.61           C  
ATOM    547  H   VAL A 125      41.111  66.327  -4.832  1.00  3.68           H  
ATOM    548  HA  VAL A 125      42.532  67.711  -2.658  1.00  3.91           H  
ATOM    549  HB  VAL A 125      41.087  66.319  -1.136  1.00  2.91           H  
ATOM    550 HG11 VAL A 125      38.941  67.699  -1.942  1.00  2.50           H  
ATOM    551 HG12 VAL A 125      40.313  68.446  -1.123  1.00  2.81           H  
ATOM    552 HG13 VAL A 125      40.183  68.526  -2.880  1.00  2.85           H  
ATOM    553 HG21 VAL A 125      39.352  65.891  -3.552  1.00  2.85           H  
ATOM    554 HG22 VAL A 125      40.519  64.684  -3.014  1.00  2.89           H  
ATOM    555 HG23 VAL A 125      39.201  65.174  -1.948  1.00  2.69           H  
ATOM    556  N   VAL A 126      43.901  65.782  -1.853  1.00  4.74           N  
ATOM    557  CA  VAL A 126      44.856  64.728  -1.536  1.00  5.60           C  
ATOM    558  C   VAL A 126      44.500  64.069  -0.208  1.00  5.78           C  
ATOM    559  O   VAL A 126      44.292  64.750   0.796  1.00  5.73           O  
ATOM    560  CB  VAL A 126      46.294  65.272  -1.458  1.00  6.59           C  
ATOM    561  CG1 VAL A 126      47.298  64.131  -1.387  1.00  7.53           C  
ATOM    562  CG2 VAL A 126      46.586  66.178  -2.645  1.00  6.75           C  
ATOM    563  H   VAL A 126      43.948  66.628  -1.360  1.00  4.75           H  
ATOM    564  HA  VAL A 126      44.811  63.985  -2.319  1.00  5.61           H  
ATOM    565  HB  VAL A 126      46.387  65.860  -0.555  1.00  6.71           H  
ATOM    566 HG11 VAL A 126      46.889  63.262  -1.881  1.00  7.85           H  
ATOM    567 HG12 VAL A 126      48.214  64.427  -1.879  1.00  7.90           H  
ATOM    568 HG13 VAL A 126      47.502  63.895  -0.354  1.00  7.73           H  
ATOM    569 HG21 VAL A 126      46.205  65.722  -3.548  1.00  6.86           H  
ATOM    570 HG22 VAL A 126      46.109  67.134  -2.496  1.00  7.04           H  
ATOM    571 HG23 VAL A 126      47.653  66.319  -2.738  1.00  6.78           H  
ATOM    572  N   TYR A 127      44.428  62.742  -0.206  1.00  6.19           N  
ATOM    573  CA  TYR A 127      44.091  61.998   1.002  1.00  6.72           C  
ATOM    574  C   TYR A 127      45.300  61.869   1.922  1.00  7.79           C  
ATOM    575  O   TYR A 127      46.214  61.091   1.658  1.00  8.59           O  
ATOM    576  CB  TYR A 127      43.552  60.613   0.639  1.00  7.03           C  
ATOM    577  CG  TYR A 127      42.077  60.609   0.304  1.00  6.28           C  
ATOM    578  CD1 TYR A 127      41.584  61.375  -0.746  1.00  5.71           C  
ATOM    579  CD2 TYR A 127      41.179  59.846   1.039  1.00  6.38           C  
ATOM    580  CE1 TYR A 127      40.236  61.379  -1.054  1.00  5.23           C  
ATOM    581  CE2 TYR A 127      39.829  59.845   0.735  1.00  5.99           C  
ATOM    582  CZ  TYR A 127      39.364  60.612  -0.312  1.00  5.42           C  
ATOM    583  OH  TYR A 127      38.025  60.615  -0.617  1.00  5.31           O  
ATOM    584  H   TYR A 127      44.602  62.252  -1.037  1.00  6.26           H  
ATOM    585  HA  TYR A 127      43.317  62.548   1.521  1.00  6.24           H  
ATOM    586  HB2 TYR A 127      44.088  60.240  -0.220  1.00  7.27           H  
ATOM    587  HB3 TYR A 127      43.705  59.944   1.474  1.00  7.71           H  
ATOM    588  HD1 TYR A 127      42.269  61.975  -1.326  1.00  5.81           H  
ATOM    589  HD2 TYR A 127      41.546  59.246   1.857  1.00  6.93           H  
ATOM    590  HE1 TYR A 127      39.874  61.980  -1.874  1.00  4.94           H  
ATOM    591  HE2 TYR A 127      39.147  59.245   1.317  1.00  6.30           H  
ATOM    592  HH  TYR A 127      37.833  61.341  -1.213  1.00  5.35           H  
ATOM    593  N   THR A 128      45.293  62.647   2.999  1.00  7.86           N  
ATOM    594  CA  THR A 128      46.386  62.634   3.965  1.00  8.91           C  
ATOM    595  C   THR A 128      46.608  61.238   4.538  1.00  9.91           C  
ATOM    596  O   THR A 128      45.822  60.760   5.356  1.00 10.27           O  
ATOM    597  CB  THR A 128      46.121  63.613   5.124  1.00  8.84           C  
ATOM    598  OG1 THR A 128      44.975  64.421   4.831  1.00  7.77           O  
ATOM    599  CG2 THR A 128      47.328  64.506   5.366  1.00  9.50           C  
ATOM    600  H   THR A 128      44.535  63.249   3.145  1.00  7.23           H  
ATOM    601  HA  THR A 128      47.285  62.950   3.454  1.00  9.14           H  
ATOM    602  HB  THR A 128      45.929  63.041   6.021  1.00  9.27           H  
ATOM    603  HG1 THR A 128      45.072  65.278   5.250  1.00  7.67           H  
ATOM    604 HG21 THR A 128      46.998  65.520   5.532  1.00  9.78           H  
ATOM    605 HG22 THR A 128      47.976  64.475   4.502  1.00  9.69           H  
ATOM    606 HG23 THR A 128      47.868  64.156   6.232  1.00  9.70           H  
ATOM    607  N   GLY A 129      47.685  60.589   4.103  1.00 10.49           N  
ATOM    608  CA  GLY A 129      47.995  59.257   4.588  1.00 11.51           C  
ATOM    609  C   GLY A 129      47.787  58.185   3.537  1.00 11.53           C  
ATOM    610  O   GLY A 129      48.403  57.120   3.598  1.00 12.41           O  
ATOM    611  H   GLY A 129      48.278  61.023   3.454  1.00 10.32           H  
ATOM    612  HA2 GLY A 129      49.026  59.234   4.907  1.00 12.25           H  
ATOM    613  HA3 GLY A 129      47.364  59.039   5.438  1.00 11.63           H  
ATOM    614  N   TYR A 130      46.919  58.463   2.569  1.00 10.62           N  
ATOM    615  CA  TYR A 130      46.631  57.509   1.503  1.00 10.62           C  
ATOM    616  C   TYR A 130      47.385  57.873   0.227  1.00 10.60           C  
ATOM    617  O   TYR A 130      47.727  57.002  -0.574  1.00 11.27           O  
ATOM    618  CB  TYR A 130      45.127  57.461   1.228  1.00  9.73           C  
ATOM    619  CG  TYR A 130      44.309  56.975   2.404  1.00 10.03           C  
ATOM    620  CD1 TYR A 130      43.927  57.846   3.418  1.00  9.83           C  
ATOM    621  CD2 TYR A 130      43.924  55.644   2.502  1.00 10.64           C  
ATOM    622  CE1 TYR A 130      43.181  57.403   4.493  1.00 10.27           C  
ATOM    623  CE2 TYR A 130      43.179  55.195   3.576  1.00 11.09           C  
ATOM    624  CZ  TYR A 130      42.810  56.078   4.568  1.00 10.92           C  
ATOM    625  OH  TYR A 130      42.067  55.634   5.638  1.00 11.49           O  
ATOM    626  H   TYR A 130      46.457  59.327   2.570  1.00  9.98           H  
ATOM    627  HA  TYR A 130      46.958  56.535   1.834  1.00 11.41           H  
ATOM    628  HB2 TYR A 130      44.782  58.453   0.974  1.00  8.96           H  
ATOM    629  HB3 TYR A 130      44.941  56.797   0.396  1.00  9.70           H  
ATOM    630  HD1 TYR A 130      44.218  58.884   3.356  1.00  9.40           H  
ATOM    631  HD2 TYR A 130      44.216  54.954   1.725  1.00 10.84           H  
ATOM    632  HE1 TYR A 130      42.891  58.096   5.271  1.00 10.18           H  
ATOM    633  HE2 TYR A 130      42.888  54.157   3.633  1.00 11.63           H  
ATOM    634  HH  TYR A 130      42.360  56.077   6.437  1.00 11.63           H  
ATOM    635  N   GLY A 131      47.645  59.165   0.048  1.00  9.97           N  
ATOM    636  CA  GLY A 131      48.363  59.624  -1.128  1.00 10.07           C  
ATOM    637  C   GLY A 131      47.463  59.806  -2.336  1.00  9.30           C  
ATOM    638  O   GLY A 131      47.695  60.692  -3.159  1.00  9.47           O  
ATOM    639  H   GLY A 131      47.353  59.810   0.723  1.00  9.52           H  
ATOM    640  HA2 GLY A 131      48.833  60.569  -0.900  1.00 10.03           H  
ATOM    641  HA3 GLY A 131      49.130  58.904  -1.372  1.00 10.86           H  
ATOM    642  N   ASN A 132      46.440  58.962  -2.448  1.00  8.58           N  
ATOM    643  CA  ASN A 132      45.507  59.029  -3.569  1.00  7.89           C  
ATOM    644  C   ASN A 132      44.924  60.430  -3.729  1.00  6.95           C  
ATOM    645  O   ASN A 132      44.663  61.121  -2.744  1.00  6.64           O  
ATOM    646  CB  ASN A 132      44.372  58.020  -3.375  1.00  7.85           C  
ATOM    647  CG  ASN A 132      44.881  56.632  -3.034  1.00  7.69           C  
ATOM    648  OD1 ASN A 132      46.043  56.306  -3.272  1.00  7.99           O  
ATOM    649  ND2 ASN A 132      44.006  55.804  -2.474  1.00  7.49           N  
ATOM    650  H   ASN A 132      46.311  58.272  -1.765  1.00  8.60           H  
ATOM    651  HA  ASN A 132      46.049  58.773  -4.467  1.00  8.25           H  
ATOM    652  HB2 ASN A 132      43.735  58.355  -2.572  1.00  8.44           H  
ATOM    653  HB3 ASN A 132      43.794  57.958  -4.287  1.00  7.60           H  
ATOM    654 HD21 ASN A 132      43.097  56.131  -2.314  1.00  7.44           H  
ATOM    655 HD22 ASN A 132      44.308  54.900  -2.245  1.00  7.57           H  
ATOM    656  N   ARG A 133      44.717  60.838  -4.978  1.00  6.59           N  
ATOM    657  CA  ARG A 133      44.157  62.150  -5.278  1.00  5.87           C  
ATOM    658  C   ARG A 133      42.920  62.011  -6.159  1.00  5.31           C  
ATOM    659  O   ARG A 133      42.973  61.386  -7.218  1.00  5.65           O  
ATOM    660  CB  ARG A 133      45.199  63.028  -5.976  1.00  6.37           C  
ATOM    661  CG  ARG A 133      46.236  63.613  -5.032  1.00  6.55           C  
ATOM    662  CD  ARG A 133      47.609  63.677  -5.682  1.00  7.46           C  
ATOM    663  NE  ARG A 133      47.577  64.375  -6.965  1.00  7.96           N  
ATOM    664  CZ  ARG A 133      48.635  64.515  -7.760  1.00  8.74           C  
ATOM    665  NH1 ARG A 133      49.807  64.009  -7.403  1.00  9.12           N  
ATOM    666  NH2 ARG A 133      48.520  65.159  -8.911  1.00  9.35           N  
ATOM    667  H   ARG A 133      44.940  60.238  -5.720  1.00  6.92           H  
ATOM    668  HA  ARG A 133      43.872  62.613  -4.344  1.00  5.60           H  
ATOM    669  HB2 ARG A 133      45.714  62.435  -6.719  1.00  7.06           H  
ATOM    670  HB3 ARG A 133      44.691  63.845  -6.471  1.00  6.16           H  
ATOM    671  HG2 ARG A 133      45.934  64.612  -4.756  1.00  6.06           H  
ATOM    672  HG3 ARG A 133      46.293  62.996  -4.149  1.00  6.73           H  
ATOM    673  HD2 ARG A 133      48.284  64.195  -5.019  1.00  7.83           H  
ATOM    674  HD3 ARG A 133      47.965  62.668  -5.840  1.00  7.63           H  
ATOM    675  HE  ARG A 133      46.720  64.758  -7.251  1.00  7.87           H  
ATOM    676 HH11 ARG A 133      49.899  63.521  -6.534  1.00  8.86           H  
ATOM    677 HH12 ARG A 133      50.601  64.115  -8.002  1.00  9.80           H  
ATOM    678 HH21 ARG A 133      47.637  65.543  -9.185  1.00  9.27           H  
ATOM    679 HH22 ARG A 133      49.316  65.265  -9.508  1.00 10.00           H  
ATOM    680  N   GLU A 134      41.808  62.586  -5.714  1.00  4.60           N  
ATOM    681  CA  GLU A 134      40.559  62.509  -6.468  1.00  4.37           C  
ATOM    682  C   GLU A 134      39.961  63.895  -6.692  1.00  4.10           C  
ATOM    683  O   GLU A 134      40.047  64.767  -5.825  1.00  3.69           O  
ATOM    684  CB  GLU A 134      39.553  61.619  -5.735  1.00  4.32           C  
ATOM    685  CG  GLU A 134      40.165  60.353  -5.157  1.00  4.69           C  
ATOM    686  CD  GLU A 134      39.596  59.091  -5.777  1.00  5.28           C  
ATOM    687  OE1 GLU A 134      40.104  58.673  -6.838  1.00  5.81           O  
ATOM    688  OE2 GLU A 134      38.644  58.525  -5.202  1.00  5.49           O  
ATOM    689  H   GLU A 134      41.824  63.066  -4.859  1.00  4.39           H  
ATOM    690  HA  GLU A 134      40.781  62.070  -7.428  1.00  4.78           H  
ATOM    691  HB2 GLU A 134      39.112  62.183  -4.927  1.00  4.29           H  
ATOM    692  HB3 GLU A 134      38.773  61.332  -6.427  1.00  4.53           H  
ATOM    693  HG2 GLU A 134      41.231  60.373  -5.331  1.00  4.93           H  
ATOM    694  HG3 GLU A 134      39.975  60.331  -4.093  1.00  4.73           H  
ATOM    695  N   GLU A 135      39.354  64.089  -7.859  1.00  4.58           N  
ATOM    696  CA  GLU A 135      38.737  65.367  -8.202  1.00  4.87           C  
ATOM    697  C   GLU A 135      37.351  65.483  -7.575  1.00  4.79           C  
ATOM    698  O   GLU A 135      36.527  64.576  -7.690  1.00  5.09           O  
ATOM    699  CB  GLU A 135      38.636  65.513  -9.722  1.00  5.81           C  
ATOM    700  CG  GLU A 135      38.578  66.957 -10.193  1.00  6.48           C  
ATOM    701  CD  GLU A 135      37.677  67.140 -11.400  1.00  7.38           C  
ATOM    702  OE1 GLU A 135      36.443  67.044 -11.239  1.00  7.78           O  
ATOM    703  OE2 GLU A 135      38.208  67.379 -12.506  1.00  7.86           O  
ATOM    704  H   GLU A 135      39.319  63.355  -8.507  1.00  4.92           H  
ATOM    705  HA  GLU A 135      39.364  66.155  -7.813  1.00  4.73           H  
ATOM    706  HB2 GLU A 135      39.498  65.045 -10.175  1.00  5.97           H  
ATOM    707  HB3 GLU A 135      37.743  65.011 -10.062  1.00  6.02           H  
ATOM    708  HG2 GLU A 135      38.203  67.571  -9.387  1.00  6.60           H  
ATOM    709  HG3 GLU A 135      39.576  67.278 -10.455  1.00  6.41           H  
ATOM    710  N   GLN A 136      37.100  66.608  -6.910  1.00  4.64           N  
ATOM    711  CA  GLN A 136      35.818  66.847  -6.259  1.00  4.84           C  
ATOM    712  C   GLN A 136      35.316  68.258  -6.546  1.00  5.56           C  
ATOM    713  O   GLN A 136      36.014  69.061  -7.170  1.00  5.86           O  
ATOM    714  CB  GLN A 136      35.943  66.631  -4.750  1.00  4.04           C  
ATOM    715  CG  GLN A 136      34.766  65.888  -4.139  1.00  4.34           C  
ATOM    716  CD  GLN A 136      35.170  64.566  -3.515  1.00  4.37           C  
ATOM    717  OE1 GLN A 136      36.336  64.169  -3.571  1.00  4.53           O  
ATOM    718  NE2 GLN A 136      34.208  63.876  -2.914  1.00  4.63           N  
ATOM    719  H   GLN A 136      37.799  67.292  -6.851  1.00  4.55           H  
ATOM    720  HA  GLN A 136      35.106  66.137  -6.658  1.00  5.29           H  
ATOM    721  HB2 GLN A 136      36.840  66.064  -4.554  1.00  3.65           H  
ATOM    722  HB3 GLN A 136      36.024  67.594  -4.266  1.00  3.98           H  
ATOM    723  HG2 GLN A 136      34.323  66.507  -3.374  1.00  4.33           H  
ATOM    724  HG3 GLN A 136      34.037  65.696  -4.912  1.00  4.99           H  
ATOM    725 HE21 GLN A 136      33.304  64.254  -2.906  1.00  4.79           H  
ATOM    726 HE22 GLN A 136      34.441  63.018  -2.503  1.00  4.88           H  
ATOM    727  N   ASN A 137      34.107  68.559  -6.084  1.00  6.06           N  
ATOM    728  CA  ASN A 137      33.514  69.878  -6.287  1.00  6.90           C  
ATOM    729  C   ASN A 137      33.784  70.781  -5.088  1.00  6.54           C  
ATOM    730  O   ASN A 137      33.677  70.350  -3.940  1.00  5.95           O  
ATOM    731  CB  ASN A 137      32.007  69.752  -6.518  1.00  7.87           C  
ATOM    732  CG  ASN A 137      31.337  71.098  -6.708  1.00  8.40           C  
ATOM    733  OD1 ASN A 137      31.882  71.992  -7.355  1.00  8.92           O  
ATOM    734  ND2 ASN A 137      30.143  71.249  -6.144  1.00  8.47           N  
ATOM    735  H   ASN A 137      33.600  67.879  -5.592  1.00  5.98           H  
ATOM    736  HA  ASN A 137      33.970  70.314  -7.164  1.00  7.24           H  
ATOM    737  HB2 ASN A 137      31.833  69.157  -7.402  1.00  7.82           H  
ATOM    738  HB3 ASN A 137      31.558  69.263  -5.667  1.00  8.38           H  
ATOM    739 HD21 ASN A 137      29.768  70.495  -5.645  1.00  8.23           H  
ATOM    740 HD22 ASN A 137      29.687  72.111  -6.250  1.00  8.87           H  
ATOM    741  N   LEU A 138      34.142  72.032  -5.361  1.00  7.04           N  
ATOM    742  CA  LEU A 138      34.436  72.994  -4.303  1.00  6.90           C  
ATOM    743  C   LEU A 138      33.247  73.160  -3.359  1.00  7.16           C  
ATOM    744  O   LEU A 138      33.419  73.306  -2.150  1.00  6.67           O  
ATOM    745  CB  LEU A 138      34.814  74.349  -4.906  1.00  7.77           C  
ATOM    746  CG  LEU A 138      36.183  74.399  -5.582  1.00  7.75           C  
ATOM    747  CD1 LEU A 138      36.266  75.582  -6.535  1.00  8.95           C  
ATOM    748  CD2 LEU A 138      37.290  74.472  -4.541  1.00  7.32           C  
ATOM    749  H   LEU A 138      34.222  72.316  -6.297  1.00  7.61           H  
ATOM    750  HA  LEU A 138      35.275  72.619  -3.737  1.00  6.08           H  
ATOM    751  HB2 LEU A 138      34.063  74.616  -5.636  1.00  8.57           H  
ATOM    752  HB3 LEU A 138      34.799  75.086  -4.117  1.00  7.78           H  
ATOM    753  HG  LEU A 138      36.326  73.496  -6.160  1.00  7.33           H  
ATOM    754 HD11 LEU A 138      35.425  75.558  -7.212  1.00  9.31           H  
ATOM    755 HD12 LEU A 138      36.246  76.503  -5.968  1.00  9.31           H  
ATOM    756 HD13 LEU A 138      37.186  75.527  -7.098  1.00  9.28           H  
ATOM    757 HD21 LEU A 138      36.880  74.827  -3.605  1.00  7.31           H  
ATOM    758 HD22 LEU A 138      37.716  73.491  -4.396  1.00  7.16           H  
ATOM    759 HD23 LEU A 138      38.059  75.153  -4.877  1.00  7.45           H  
ATOM    760  N   SER A 139      32.040  73.139  -3.920  1.00  8.07           N  
ATOM    761  CA  SER A 139      30.823  73.291  -3.126  1.00  8.59           C  
ATOM    762  C   SER A 139      30.596  72.070  -2.240  1.00  8.04           C  
ATOM    763  O   SER A 139      29.761  72.095  -1.335  1.00  8.40           O  
ATOM    764  CB  SER A 139      29.616  73.504  -4.043  1.00  9.76           C  
ATOM    765  OG  SER A 139      28.460  72.869  -3.525  1.00 10.26           O  
ATOM    766  H   SER A 139      31.966  73.022  -4.891  1.00  8.46           H  
ATOM    767  HA  SER A 139      30.944  74.159  -2.498  1.00  8.66           H  
ATOM    768  HB2 SER A 139      29.419  74.562  -4.135  1.00 10.08           H  
ATOM    769  HB3 SER A 139      29.831  73.092  -5.019  1.00 10.07           H  
ATOM    770  HG  SER A 139      28.040  72.352  -4.217  1.00 10.60           H  
ATOM    771  N   ASP A 140      31.343  71.003  -2.504  1.00  7.28           N  
ATOM    772  CA  ASP A 140      31.222  69.774  -1.731  1.00  6.90           C  
ATOM    773  C   ASP A 140      32.395  69.608  -0.769  1.00  5.82           C  
ATOM    774  O   ASP A 140      32.552  68.564  -0.138  1.00  5.53           O  
ATOM    775  CB  ASP A 140      31.143  68.565  -2.667  1.00  6.97           C  
ATOM    776  CG  ASP A 140      29.784  68.435  -3.329  1.00  7.80           C  
ATOM    777  OD1 ASP A 140      28.774  68.349  -2.600  1.00  8.30           O  
ATOM    778  OD2 ASP A 140      29.731  68.421  -4.576  1.00  8.12           O  
ATOM    779  H   ASP A 140      31.991  71.045  -3.238  1.00  7.09           H  
ATOM    780  HA  ASP A 140      30.308  69.832  -1.158  1.00  7.50           H  
ATOM    781  HB2 ASP A 140      31.890  68.667  -3.439  1.00  7.25           H  
ATOM    782  HB3 ASP A 140      31.336  67.666  -2.102  1.00  6.31           H  
ATOM    783  N   LEU A 141      33.218  70.649  -0.662  1.00  5.41           N  
ATOM    784  CA  LEU A 141      34.376  70.619   0.225  1.00  4.46           C  
ATOM    785  C   LEU A 141      33.960  70.863   1.673  1.00  4.72           C  
ATOM    786  O   LEU A 141      33.311  71.863   1.979  1.00  5.47           O  
ATOM    787  CB  LEU A 141      35.407  71.666  -0.205  1.00  4.23           C  
ATOM    788  CG  LEU A 141      36.357  71.225  -1.322  1.00  3.96           C  
ATOM    789  CD1 LEU A 141      37.302  72.358  -1.695  1.00  4.31           C  
ATOM    790  CD2 LEU A 141      37.146  69.992  -0.901  1.00  3.01           C  
ATOM    791  H   LEU A 141      33.041  71.455  -1.191  1.00  5.88           H  
ATOM    792  HA  LEU A 141      34.822  69.637   0.154  1.00  3.96           H  
ATOM    793  HB2 LEU A 141      34.875  72.546  -0.539  1.00  4.97           H  
ATOM    794  HB3 LEU A 141      36.000  71.931   0.656  1.00  3.83           H  
ATOM    795  HG  LEU A 141      35.779  70.971  -2.198  1.00  4.49           H  
ATOM    796 HD11 LEU A 141      38.317  71.990  -1.712  1.00  4.36           H  
ATOM    797 HD12 LEU A 141      37.042  72.737  -2.673  1.00  4.74           H  
ATOM    798 HD13 LEU A 141      37.219  73.152  -0.969  1.00  4.50           H  
ATOM    799 HD21 LEU A 141      37.098  69.250  -1.685  1.00  2.90           H  
ATOM    800 HD22 LEU A 141      38.176  70.267  -0.725  1.00  2.92           H  
ATOM    801 HD23 LEU A 141      36.720  69.586   0.004  1.00  3.12           H  
ATOM    802  N   LEU A 142      34.337  69.945   2.557  1.00  4.30           N  
ATOM    803  CA  LEU A 142      34.003  70.063   3.972  1.00  4.79           C  
ATOM    804  C   LEU A 142      35.112  70.779   4.737  1.00  4.37           C  
ATOM    805  O   LEU A 142      36.279  70.729   4.349  1.00  3.72           O  
ATOM    806  CB  LEU A 142      33.760  68.679   4.581  1.00  5.32           C  
ATOM    807  CG  LEU A 142      32.908  67.734   3.730  1.00  5.88           C  
ATOM    808  CD1 LEU A 142      33.085  66.296   4.191  1.00  6.01           C  
ATOM    809  CD2 LEU A 142      31.444  68.139   3.790  1.00  6.92           C  
ATOM    810  H   LEU A 142      34.853  69.170   2.251  1.00  3.81           H  
ATOM    811  HA  LEU A 142      33.096  70.642   4.051  1.00  5.36           H  
ATOM    812  HB2 LEU A 142      34.721  68.211   4.750  1.00  4.99           H  
ATOM    813  HB3 LEU A 142      33.270  68.809   5.533  1.00  5.85           H  
ATOM    814  HG  LEU A 142      33.234  67.797   2.702  1.00  5.62           H  
ATOM    815 HD11 LEU A 142      32.114  65.842   4.329  1.00  6.04           H  
ATOM    816 HD12 LEU A 142      33.637  65.742   3.448  1.00  6.13           H  
ATOM    817 HD13 LEU A 142      33.626  66.281   5.127  1.00  6.31           H  
ATOM    818 HD21 LEU A 142      30.908  67.455   4.430  1.00  7.24           H  
ATOM    819 HD22 LEU A 142      31.364  69.140   4.184  1.00  7.20           H  
ATOM    820 HD23 LEU A 142      31.020  68.108   2.795  1.00  7.31           H  
ATOM    821  N   SER A 143      34.739  71.445   5.825  1.00  4.93           N  
ATOM    822  CA  SER A 143      35.699  72.173   6.647  1.00  4.89           C  
ATOM    823  C   SER A 143      36.565  71.208   7.458  1.00  5.19           C  
ATOM    824  O   SER A 143      36.170  70.070   7.706  1.00  5.64           O  
ATOM    825  CB  SER A 143      34.965  73.135   7.585  1.00  5.50           C  
ATOM    826  OG  SER A 143      33.658  73.413   7.112  1.00  6.07           O  
ATOM    827  H   SER A 143      33.792  71.447   6.081  1.00  5.50           H  
ATOM    828  HA  SER A 143      36.336  72.743   5.986  1.00  4.45           H  
ATOM    829  HB2 SER A 143      34.891  72.693   8.567  1.00  5.79           H  
ATOM    830  HB3 SER A 143      35.515  74.063   7.648  1.00  5.46           H  
ATOM    831  HG  SER A 143      33.706  73.732   6.207  1.00  6.37           H  
ATOM    832  N   PRO A 144      37.764  71.652   7.884  1.00  5.25           N  
ATOM    833  CA  PRO A 144      38.681  70.817   8.669  1.00  5.91           C  
ATOM    834  C   PRO A 144      38.111  70.451  10.034  1.00  6.73           C  
ATOM    835  O   PRO A 144      36.992  70.839  10.375  1.00  7.04           O  
ATOM    836  CB  PRO A 144      39.927  71.698   8.830  1.00  6.05           C  
ATOM    837  CG  PRO A 144      39.441  73.091   8.626  1.00  5.71           C  
ATOM    838  CD  PRO A 144      38.320  72.995   7.635  1.00  5.04           C  
ATOM    839  HA  PRO A 144      38.943  69.914   8.137  1.00  5.88           H  
ATOM    840  HB2 PRO A 144      40.339  71.563   9.821  1.00  6.76           H  
ATOM    841  HB3 PRO A 144      40.662  71.425   8.088  1.00  5.88           H  
ATOM    842  HG2 PRO A 144      39.082  73.496   9.561  1.00  6.14           H  
ATOM    843  HG3 PRO A 144      40.238  73.704   8.232  1.00  5.70           H  
ATOM    844  HD2 PRO A 144      37.579  73.761   7.824  1.00  5.15           H  
ATOM    845  HD3 PRO A 144      38.697  73.074   6.626  1.00  4.57           H  
ATOM    846  N   ILE A 145      38.886  69.700  10.812  1.00  7.30           N  
ATOM    847  CA  ILE A 145      38.455  69.279  12.142  1.00  8.19           C  
ATOM    848  C   ILE A 145      39.407  69.794  13.217  1.00  8.35           C  
ATOM    849  O   ILE A 145      40.580  70.058  12.948  1.00  8.81           O  
ATOM    850  CB  ILE A 145      38.365  67.742  12.246  1.00  8.86           C  
ATOM    851  CG1 ILE A 145      37.936  67.140  10.906  1.00  9.14           C  
ATOM    852  CG2 ILE A 145      37.395  67.346  13.348  1.00  9.47           C  
ATOM    853  CD1 ILE A 145      38.096  65.636  10.835  1.00  9.94           C  
ATOM    854  H   ILE A 145      39.765  69.424  10.484  1.00  7.24           H  
ATOM    855  HA  ILE A 145      37.472  69.689  12.319  1.00  8.49           H  
ATOM    856  HB  ILE A 145      39.343  67.365  12.507  1.00  8.99           H  
ATOM    857 HG12 ILE A 145      36.895  67.370  10.732  1.00  9.06           H  
ATOM    858 HG13 ILE A 145      38.532  67.576  10.116  1.00  9.11           H  
ATOM    859 HG21 ILE A 145      37.944  66.914  14.174  1.00  9.85           H  
ATOM    860 HG22 ILE A 145      36.859  68.219  13.689  1.00  9.78           H  
ATOM    861 HG23 ILE A 145      36.692  66.619  12.965  1.00  9.44           H  
ATOM    862 HD11 ILE A 145      38.340  65.346   9.824  1.00 10.24           H  
ATOM    863 HD12 ILE A 145      38.890  65.326  11.499  1.00 10.18           H  
ATOM    864 HD13 ILE A 145      37.173  65.161  11.133  1.00 10.18           H  
TER     865      ILE A 145                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
