
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   80 (  682),  selected   80 , name 2f5k_C
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2f5k_C.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P     7_C      E       1           -
LGA    -       -      N       2           -
LGA    -       -      L       3           -
LGA    K     8_C      Y       4           #
LGA    -       -      F       5           -
LGA    P     9_C      Q       6          1.968
LGA    -       -      G       7           -
LGA    K    10_C      D       8          4.394
LGA    F    11_C      L       9          1.870
LGA    Q    12_C      I      10          1.098
LGA    E    13_C      V      11          0.335
LGA    G    14_C      S      12          0.396
LGA    E    15_C      M      13          0.491
LGA    R    16_C      R      14          0.094
LGA    V    17_C      I      15          0.165
LGA    L    18_C      L      16          0.357
LGA    C    19_C      G      17          0.580
LGA    F    20_C      K      18          0.899
LGA    H    21_C      K      19          1.165
LGA    G    22_C      R      20          3.233
LGA    -       -      T      21           -
LGA    P    23_C      K      22          2.151
LGA    L    24_C      T      23          0.654
LGA    L    25_C      W      24          0.733
LGA    Y    26_C      X      25          0.252
LGA    E    27_C      K      26          0.244
LGA    A    28_C      G      27          0.680
LGA    K    29_C      T      28          0.518
LGA    C    30_C      L      29          0.270
LGA    V    31_C      I      30          0.204
LGA    K    32_C      A      31          0.681
LGA    V    33_C      I      32          1.119
LGA    A    34_C      Q      33          1.500
LGA    I    35_C      T      34          2.064
LGA    K    36_C      V      35          1.975
LGA    D    37_C      G      36          2.111
LGA    K    38_C      P      37          0.685
LGA    Q    39_C      G      38          2.222
LGA    V    40_C      K      39          1.603
LGA    K    41_C      K      40          0.913
LGA    Y    42_C      Y      41          0.816
LGA    F    43_C      K      42          0.965
LGA    I    44_C      V      43          0.845
LGA    H    45_C      K      44          0.408
LGA    Y    46_C      F      45          0.341
LGA    S    47_C      D      46          0.767
LGA    G    48_C      N      47          2.191
LGA    W    49_C      K      48          1.952
LGA    N    50_C      -       -           -
LGA    K    51_C      -       -           -
LGA    N    52_C      -       -           -
LGA    W    53_C      G      49          2.451
LGA    D    54_C      K      50          0.881
LGA    E    55_C      S      51          1.815
LGA    W    56_C      L      52          1.298
LGA    V    57_C      L      53          1.026
LGA    P    58_C      S      54          0.846
LGA    E    59_C      G      55          0.398
LGA    S    60_C      N      56          0.688
LGA    R    61_C      X      57          0.505
LGA    V    62_C      I      58          0.231
LGA    L    63_C      A      59          0.384
LGA    K    64_C      Y      60          0.500
LGA    Y    65_C      D      61          0.876
LGA    V    66_C      Y      62          0.629
LGA    D    67_C      -       -           -
LGA    T    68_C      -       -           -
LGA    N    69_C      -       -           -
LGA    L    70_C      -       -           -
LGA    Q    71_C      -       -           -
LGA    K    72_C      -       -           -
LGA    Q    73_C      -       -           -
LGA    R    74_C      -       -           -
LGA    E    75_C      -       -           -
LGA    L    76_C      -       -           -
LGA    Q    77_C      -       -           -
LGA    K    78_C      -       -           -
LGA    A    79_C      -       -           -
LGA    N    80_C      -       -           -
LGA    Q    81_C      -       -           -
LGA    E    82_C      -       -           -
LGA    Q    83_C      -       -           -
LGA    Y    84_C      -       -           -
LGA    A    85_C      -       -           -
LGA    E    86_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   80   62    5.0     55    1.36     7.27     84.720     3.775

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.182496 * X  +  -0.976226 * Y  +   0.116953 * Z  +  30.935238
  Y_new =  -0.128448 * X  +  -0.141604 * Y  +  -0.981555 * Z  +  55.638931
  Z_new =   0.974780 * X  +   0.164107 * Y  +  -0.151237 * Z  +  33.517300 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.315403   -0.826190  [ DEG:   132.6628    -47.3372 ]
  Theta =  -1.345734   -1.795859  [ DEG:   -77.1049   -102.8951 ]
  Phi   =  -0.613300    2.528293  [ DEG:   -35.1395    144.8605 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f5k_C                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f5k_C.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   80   62   5.0   55   1.36    7.27  84.720
REMARK  ---------------------------------------------------------- 
MOLECULE 2f5k_C
HEADER    GENE REGULATION                         26-NOV-05   2F5K              
TITLE     CRYSTAL STRUCTURE OF THE CHROMO DOMAIN OF HUMAN MRG15                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MORF-RELATED GENE 15 ISOFORM 1;                            
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 FRAGMENT: CHROMO DOMAIN;                                             
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-3E-HIS                                
KEYWDS    BETA BARREL, GENE REGULATION                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.ZHANG,J.DU,J.DING                                                   
REVDAT   2   25-DEC-07 2F5K    1       JRNL                                     
REVDAT   1   14-NOV-06 2F5K    0                                                
JRNL        AUTH   P.ZHANG,J.DU,B.SUN,X.DONG,G.XU,J.ZHOU,Q.HUANG,               
JRNL        AUTH 2 Q.LIU,Q.HAO,J.DING                                           
JRNL        TITL   STRUCTURE OF HUMAN MRG15 CHROMO DOMAIN AND ITS               
JRNL        TITL 2 BINDING TO LYS36-METHYLATED HISTONE H3.                      
JRNL        REF    NUCLEIC ACIDS RES.            V.  34  6621 2006              
JRNL        REFN   ASTM NARHAD  UK ISSN 0305-1048                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2F5K A    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K B    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K C    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K D    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K E    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K F    1    90  GB     5803102  NP_006782        1     90             
SEQRES   1 A  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 A  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 A  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 A  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 A  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 A  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 A  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 A  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 B  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 B  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 B  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 B  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 B  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 B  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 B  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 B  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 C  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 C  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 C  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 C  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 C  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 C  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 C  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 C  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 D  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 D  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 D  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 D  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 D  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 D  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 D  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 D  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 E  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 E  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 E  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 E  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 E  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 E  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 E  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 E  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 F  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 F  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 F  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 F  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 F  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 F  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 F  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 F  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
FORMUL   7  HOH   *457(H2 O)                                                    
CRYST1  109.480   80.313   81.285  90.00 123.91  90.00 C 1 2 1      24          
ATOM   1429  N   PRO C   7      34.022  82.687  -9.060  1.00 73.39           N  
ATOM   1430  CA  PRO C   7      33.902  83.292  -7.703  1.00 72.82           C  
ATOM   1431  C   PRO C   7      35.142  83.022  -6.875  1.00 71.92           C  
ATOM   1432  O   PRO C   7      36.042  82.321  -7.334  1.00 71.83           O  
ATOM   1433  CB  PRO C   7      32.714  82.534  -7.115  1.00 72.97           C  
ATOM   1434  CG  PRO C   7      32.894  81.198  -7.697  1.00 73.58           C  
ATOM   1435  CD  PRO C   7      33.152  81.502  -9.177  1.00 73.75           C  
ATOM   1436  N   LYS C   8      35.194  83.597  -5.678  1.00 70.67           N  
ATOM   1437  CA  LYS C   8      36.305  83.348  -4.778  1.00 69.49           C  
ATOM   1438  C   LYS C   8      36.119  81.948  -4.195  1.00 67.43           C  
ATOM   1439  O   LYS C   8      35.242  81.705  -3.373  1.00 67.57           O  
ATOM   1440  CB  LYS C   8      36.358  84.422  -3.696  1.00 70.26           C  
ATOM   1441  CG  LYS C   8      36.442  85.824  -4.295  1.00 72.48           C  
ATOM   1442  CD  LYS C   8      36.721  86.880  -3.254  1.00 75.66           C  
ATOM   1443  CE  LYS C   8      36.514  88.283  -3.836  1.00 77.77           C  
ATOM   1444  NZ  LYS C   8      36.391  89.316  -2.761  1.00 78.83           N  
ATOM   1445  N   PRO C   9      36.941  81.018  -4.638  1.00 65.18           N  
ATOM   1446  CA  PRO C   9      36.798  79.626  -4.212  1.00 63.21           C  
ATOM   1447  C   PRO C   9      36.644  79.493  -2.691  1.00 60.78           C  
ATOM   1448  O   PRO C   9      37.097  80.348  -1.946  1.00 59.77           O  
ATOM   1449  CB  PRO C   9      38.094  79.000  -4.704  1.00 63.48           C  
ATOM   1450  CG  PRO C   9      38.444  79.826  -5.904  1.00 64.21           C  
ATOM   1451  CD  PRO C   9      38.087  81.216  -5.540  1.00 64.91           C  
ATOM   1452  N   LYS C  10      35.988  78.425  -2.250  1.00 58.61           N  
ATOM   1453  CA  LYS C  10      35.742  78.205  -0.824  1.00 56.36           C  
ATOM   1454  C   LYS C  10      37.012  77.773  -0.099  1.00 55.26           C  
ATOM   1455  O   LYS C  10      37.180  78.014   1.090  1.00 54.42           O  
ATOM   1456  CB  LYS C  10      34.641  77.156  -0.656  1.00 55.91           C  
ATOM   1457  CG  LYS C  10      34.186  76.918   0.765  1.00 53.45           C  
ATOM   1458  CD  LYS C  10      32.996  76.000   0.742  1.00 50.13           C  
ATOM   1459  CE  LYS C  10      32.456  75.708   2.130  1.00 46.32           C  
ATOM   1460  NZ  LYS C  10      31.326  74.813   1.911  1.00 43.14           N  
ATOM   1461  N   PHE C  11      37.916  77.147  -0.840  1.00 54.59           N  
ATOM   1462  CA  PHE C  11      39.177  76.683  -0.280  1.00 53.92           C  
ATOM   1463  C   PHE C  11      40.370  77.292  -1.025  1.00 53.73           C  
ATOM   1464  O   PHE C  11      40.225  77.716  -2.157  1.00 54.09           O  
ATOM   1465  CB  PHE C  11      39.196  75.152  -0.334  1.00 53.77           C  
ATOM   1466  CG  PHE C  11      37.917  74.527   0.174  1.00 52.56           C  
ATOM   1467  CD1 PHE C  11      36.856  74.299  -0.676  1.00 51.52           C  
ATOM   1468  CD2 PHE C  11      37.768  74.221   1.517  1.00 51.63           C  
ATOM   1469  CE1 PHE C  11      35.689  73.749  -0.202  1.00 50.96           C  
ATOM   1470  CE2 PHE C  11      36.599  73.667   1.996  1.00 50.84           C  
ATOM   1471  CZ  PHE C  11      35.558  73.442   1.137  1.00 50.87           C  
ATOM   1472  N   GLN C  12      41.528  77.362  -0.369  1.00 52.90           N  
ATOM   1473  CA  GLN C  12      42.745  77.869  -0.989  1.00 52.55           C  
ATOM   1474  C   GLN C  12      43.676  76.683  -1.227  1.00 51.67           C  
ATOM   1475  O   GLN C  12      43.381  75.552  -0.808  1.00 51.96           O  
ATOM   1476  CB  GLN C  12      43.490  78.835  -0.079  1.00 52.92           C  
ATOM   1477  CG  GLN C  12      42.777  80.067   0.380  1.00 55.20           C  
ATOM   1478  CD  GLN C  12      43.602  80.740   1.469  1.00 59.11           C  
ATOM   1479  OE1 GLN C  12      44.338  80.058   2.186  1.00 61.23           O  
ATOM   1480  NE2 GLN C  12      43.503  82.062   1.589  1.00 60.51           N  
ATOM   1481  N   GLU C  13      44.815  76.937  -1.864  1.00 49.78           N  
ATOM   1482  CA  GLU C  13      45.744  75.874  -2.168  1.00 48.52           C  
ATOM   1483  C   GLU C  13      46.565  75.531  -0.931  1.00 46.53           C  
ATOM   1484  O   GLU C  13      46.936  76.405  -0.156  1.00 45.35           O  
ATOM   1485  CB  GLU C  13      46.652  76.269  -3.333  1.00 50.23           C  
ATOM   1486  CG  GLU C  13      45.918  76.715  -4.597  1.00 52.80           C  
ATOM   1487  CD  GLU C  13      46.747  76.488  -5.855  1.00 56.50           C  
ATOM   1488  OE1 GLU C  13      48.004  76.453  -5.725  1.00 57.44           O  
ATOM   1489  OE2 GLU C  13      46.144  76.330  -6.960  1.00 57.54           O  
ATOM   1490  N   GLY C  14      46.828  74.247  -0.753  1.00 44.84           N  
ATOM   1491  CA  GLY C  14      47.535  73.757   0.420  1.00 44.10           C  
ATOM   1492  C   GLY C  14      46.705  73.719   1.712  1.00 42.43           C  
ATOM   1493  O   GLY C  14      47.236  73.478   2.800  1.00 42.22           O  
ATOM   1494  N   GLU C  15      45.416  73.995   1.619  1.00 41.08           N  
ATOM   1495  CA  GLU C  15      44.592  74.025   2.857  1.00 40.06           C  
ATOM   1496  C   GLU C  15      44.294  72.638   3.343  1.00 38.10           C  
ATOM   1497  O   GLU C  15      44.043  71.762   2.539  1.00 37.28           O  
ATOM   1498  CB  GLU C  15      43.263  74.720   2.607  1.00 40.53           C  
ATOM   1499  CG  GLU C  15      42.440  74.939   3.877  1.00 42.98           C  
ATOM   1500  CD  GLU C  15      41.228  75.768   3.593  1.00 43.89           C  
ATOM   1501  OE1 GLU C  15      41.167  76.307   2.454  1.00 44.81           O  
ATOM   1502  OE2 GLU C  15      40.354  75.868   4.482  1.00 43.17           O  
ATOM   1503  N   ARG C  16      44.331  72.422   4.650  1.00 37.25           N  
ATOM   1504  CA  ARG C  16      43.937  71.121   5.192  1.00 36.77           C  
ATOM   1505  C   ARG C  16      42.408  71.019   5.150  1.00 35.67           C  
ATOM   1506  O   ARG C  16      41.719  71.910   5.599  1.00 35.96           O  
ATOM   1507  CB  ARG C  16      44.439  70.925   6.608  1.00 37.45           C  
ATOM   1508  CG  ARG C  16      43.978  69.586   7.212  1.00 40.23           C  
ATOM   1509  CD  ARG C  16      44.824  69.107   8.359  1.00 45.55           C  
ATOM   1510  NE  ARG C  16      44.578  69.855   9.583  1.00 51.28           N  
ATOM   1511  CZ  ARG C  16      44.727  69.353  10.810  1.00 54.45           C  
ATOM   1512  NH1 ARG C  16      45.127  68.086  10.976  1.00 55.40           N  
ATOM   1513  NH2 ARG C  16      44.493  70.121  11.867  1.00 56.32           N  
ATOM   1514  N   VAL C  17      41.873  69.951   4.597  1.00 33.87           N  
ATOM   1515  CA  VAL C  17      40.430  69.863   4.474  1.00 33.88           C  
ATOM   1516  C   VAL C  17      39.864  68.465   4.824  1.00 32.78           C  
ATOM   1517  O   VAL C  17      40.597  67.577   5.144  1.00 31.82           O  
ATOM   1518  CB  VAL C  17      40.023  70.211   3.032  1.00 34.33           C  
ATOM   1519  CG1 VAL C  17      38.684  69.631   2.713  1.00 36.36           C  
ATOM   1520  CG2 VAL C  17      40.049  71.777   2.772  1.00 33.25           C  
ATOM   1521  N   LEU C  18      38.548  68.304   4.751  1.00 32.59           N  
ATOM   1522  CA  LEU C  18      37.924  66.996   4.850  1.00 32.76           C  
ATOM   1523  C   LEU C  18      37.222  66.806   3.505  1.00 32.90           C  
ATOM   1524  O   LEU C  18      36.602  67.717   3.005  1.00 32.55           O  
ATOM   1525  CB  LEU C  18      36.903  66.962   5.991  1.00 32.72           C  
ATOM   1526  CG  LEU C  18      37.465  67.043   7.409  1.00 34.03           C  
ATOM   1527  CD1 LEU C  18      36.356  67.405   8.434  1.00 34.61           C  
ATOM   1528  CD2 LEU C  18      38.118  65.685   7.752  1.00 34.37           C  
ATOM   1529  N   CYS C  19      37.330  65.620   2.917  1.00 33.01           N  
ATOM   1530  CA  CYS C  19      36.769  65.383   1.616  1.00 31.81           C  
ATOM   1531  C   CYS C  19      36.099  64.053   1.634  1.00 31.10           C  
ATOM   1532  O   CYS C  19      36.679  63.075   2.155  1.00 30.36           O  
ATOM   1533  CB  CYS C  19      37.884  65.401   0.556  1.00 32.82           C  
ATOM   1534  SG  CYS C  19      37.354  65.107  -1.164  1.00 35.06           S  
ATOM   1535  N   PHE C  20      34.865  64.024   1.111  1.00 30.19           N  
ATOM   1536  CA  PHE C  20      34.060  62.811   0.988  1.00 30.20           C  
ATOM   1537  C   PHE C  20      34.659  61.889  -0.058  1.00 31.07           C  
ATOM   1538  O   PHE C  20      35.168  62.330  -1.100  1.00 30.51           O  
ATOM   1539  CB  PHE C  20      32.602  63.135   0.519  1.00 29.65           C  
ATOM   1540  CG  PHE C  20      31.715  63.836   1.570  1.00 28.90           C  
ATOM   1541  CD1 PHE C  20      31.519  65.195   1.525  1.00 28.28           C  
ATOM   1542  CD2 PHE C  20      31.064  63.105   2.572  1.00 29.83           C  
ATOM   1543  CE1 PHE C  20      30.700  65.839   2.451  1.00 32.66           C  
ATOM   1544  CE2 PHE C  20      30.230  63.728   3.497  1.00 29.37           C  
ATOM   1545  CZ  PHE C  20      30.053  65.096   3.450  1.00 32.03           C  
ATOM   1546  N   HIS C  21      34.576  60.591   0.195  1.00 32.05           N  
ATOM   1547  CA  HIS C  21      34.962  59.628  -0.789  1.00 33.18           C  
ATOM   1548  C   HIS C  21      34.094  58.447  -0.451  1.00 32.71           C  
ATOM   1549  O   HIS C  21      34.300  57.799   0.568  1.00 33.25           O  
ATOM   1550  CB  HIS C  21      36.450  59.299  -0.664  1.00 34.51           C  
ATOM   1551  CG  HIS C  21      36.936  58.371  -1.721  1.00 37.64           C  
ATOM   1552  ND1 HIS C  21      36.839  57.002  -1.607  1.00 40.20           N  
ATOM   1553  CD2 HIS C  21      37.463  58.613  -2.947  1.00 39.54           C  
ATOM   1554  CE1 HIS C  21      37.299  56.439  -2.711  1.00 40.26           C  
ATOM   1555  NE2 HIS C  21      37.681  57.393  -3.540  1.00 39.21           N  
ATOM   1556  N   GLY C  22      33.122  58.122  -1.289  1.00 32.03           N  
ATOM   1557  CA  GLY C  22      32.188  57.059  -0.890  1.00 31.08           C  
ATOM   1558  C   GLY C  22      31.360  57.559   0.314  1.00 30.04           C  
ATOM   1559  O   GLY C  22      30.972  58.712   0.318  1.00 29.17           O  
ATOM   1560  N   PRO C  23      31.066  56.723   1.317  1.00 29.77           N  
ATOM   1561  CA  PRO C  23      30.281  57.188   2.490  1.00 29.14           C  
ATOM   1562  C   PRO C  23      31.092  57.830   3.626  1.00 29.05           C  
ATOM   1563  O   PRO C  23      30.526  58.100   4.680  1.00 28.73           O  
ATOM   1564  CB  PRO C  23      29.606  55.924   2.987  1.00 28.66           C  
ATOM   1565  CG  PRO C  23      30.575  54.762   2.622  1.00 29.28           C  
ATOM   1566  CD  PRO C  23      31.331  55.276   1.369  1.00 30.26           C  
ATOM   1567  N   LEU C  24      32.370  58.131   3.418  1.00 28.50           N  
ATOM   1568  CA  LEU C  24      33.178  58.608   4.534  1.00 28.38           C  
ATOM   1569  C   LEU C  24      33.908  59.915   4.252  1.00 28.07           C  
ATOM   1570  O   LEU C  24      34.118  60.296   3.101  1.00 27.60           O  
ATOM   1571  CB  LEU C  24      34.147  57.504   4.952  1.00 28.42           C  
ATOM   1572  CG  LEU C  24      33.432  56.198   5.390  1.00 28.26           C  
ATOM   1573  CD1 LEU C  24      34.363  54.967   5.467  1.00 27.70           C  
ATOM   1574  CD2 LEU C  24      32.722  56.387   6.749  1.00 23.84           C  
ATOM   1575  N   LEU C  25      34.277  60.608   5.323  1.00 27.57           N  
ATOM   1576  CA  LEU C  25      35.019  61.855   5.236  1.00 26.81           C  
ATOM   1577  C   LEU C  25      36.465  61.580   5.542  1.00 26.13           C  
ATOM   1578  O   LEU C  25      36.726  60.845   6.472  1.00 26.47           O  
ATOM   1579  CB  LEU C  25      34.455  62.876   6.222  1.00 26.89           C  
ATOM   1580  CG  LEU C  25      33.220  63.559   5.644  1.00 27.45           C  
ATOM   1581  CD1 LEU C  25      32.472  64.421   6.707  1.00 27.65           C  
ATOM   1582  CD2 LEU C  25      33.699  64.395   4.519  1.00 26.99           C  
ATOM   1583  N   TYR C  26      37.401  62.128   4.759  1.00 26.09           N  
ATOM   1584  CA  TYR C  26      38.850  61.895   4.970  1.00 26.37           C  
ATOM   1585  C   TYR C  26      39.633  63.185   5.087  1.00 26.60           C  
ATOM   1586  O   TYR C  26      39.361  64.132   4.372  1.00 26.29           O  
ATOM   1587  CB  TYR C  26      39.486  61.044   3.838  1.00 26.37           C  
ATOM   1588  CG  TYR C  26      38.939  59.645   3.787  1.00 28.47           C  
ATOM   1589  CD1 TYR C  26      37.790  59.362   3.065  1.00 29.76           C  
ATOM   1590  CD2 TYR C  26      39.528  58.619   4.503  1.00 28.63           C  
ATOM   1591  CE1 TYR C  26      37.279  58.079   3.018  1.00 31.85           C  
ATOM   1592  CE2 TYR C  26      39.014  57.332   4.460  1.00 31.07           C  
ATOM   1593  CZ  TYR C  26      37.882  57.088   3.736  1.00 32.47           C  
ATOM   1594  OH  TYR C  26      37.335  55.833   3.704  1.00 36.26           O  
ATOM   1595  N   GLU C  27      40.617  63.210   5.989  1.00 27.11           N  
ATOM   1596  CA  GLU C  27      41.485  64.352   6.082  1.00 28.24           C  
ATOM   1597  C   GLU C  27      42.231  64.413   4.723  1.00 29.04           C  
ATOM   1598  O   GLU C  27      42.655  63.385   4.180  1.00 27.33           O  
ATOM   1599  CB  GLU C  27      42.470  64.164   7.229  1.00 28.18           C  
ATOM   1600  CG  GLU C  27      43.448  65.335   7.350  1.00 26.86           C  
ATOM   1601  CD  GLU C  27      44.513  65.075   8.387  1.00 27.90           C  
ATOM   1602  OE1 GLU C  27      44.618  63.944   8.929  1.00 28.29           O  
ATOM   1603  OE2 GLU C  27      45.265  65.994   8.648  1.00 28.44           O  
ATOM   1604  N   ALA C  28      42.279  65.600   4.146  1.00 30.71           N  
ATOM   1605  CA  ALA C  28      42.823  65.782   2.817  1.00 33.08           C  
ATOM   1606  C   ALA C  28      43.424  67.143   2.670  1.00 35.25           C  
ATOM   1607  O   ALA C  28      43.198  68.050   3.504  1.00 35.35           O  
ATOM   1608  CB  ALA C  28      41.778  65.563   1.738  1.00 31.53           C  
ATOM   1609  N   LYS C  29      44.195  67.259   1.600  1.00 37.50           N  
ATOM   1610  CA  LYS C  29      44.891  68.477   1.241  1.00 40.99           C  
ATOM   1611  C   LYS C  29      44.432  69.042  -0.106  1.00 42.27           C  
ATOM   1612  O   LYS C  29      44.421  68.333  -1.101  1.00 41.52           O  
ATOM   1613  CB  LYS C  29      46.387  68.182   1.178  1.00 41.42           C  
ATOM   1614  CG  LYS C  29      47.213  69.266   1.801  1.00 44.56           C  
ATOM   1615  CD  LYS C  29      47.302  69.126   3.318  1.00 47.64           C  
ATOM   1616  CE  LYS C  29      48.529  69.917   3.807  1.00 49.41           C  
ATOM   1617  NZ  LYS C  29      49.317  69.202   4.862  1.00 48.97           N  
ATOM   1618  N   CYS C  30      44.058  70.318  -0.136  1.00 44.99           N  
ATOM   1619  CA  CYS C  30      43.670  70.947  -1.395  1.00 48.44           C  
ATOM   1620  C   CYS C  30      44.931  71.352  -2.181  1.00 49.62           C  
ATOM   1621  O   CYS C  30      45.569  72.349  -1.889  1.00 49.08           O  
ATOM   1622  CB  CYS C  30      42.745  72.133  -1.162  1.00 49.10           C  
ATOM   1623  SG  CYS C  30      42.517  73.148  -2.655  1.00 53.15           S  
ATOM   1624  N   VAL C  31      45.309  70.552  -3.162  1.00 52.00           N  
ATOM   1625  CA  VAL C  31      46.555  70.845  -3.878  1.00 54.66           C  
ATOM   1626  C   VAL C  31      46.389  72.017  -4.822  1.00 56.68           C  
ATOM   1627  O   VAL C  31      47.080  73.007  -4.716  1.00 56.56           O  
ATOM   1628  CB  VAL C  31      47.074  69.628  -4.658  1.00 54.40           C  
ATOM   1629  CG1 VAL C  31      48.368  69.959  -5.385  1.00 54.71           C  
ATOM   1630  CG2 VAL C  31      47.265  68.427  -3.728  1.00 53.48           C  
ATOM   1631  N   LYS C  32      45.438  71.907  -5.733  1.00 59.82           N  
ATOM   1632  CA  LYS C  32      45.231  72.944  -6.728  1.00 62.70           C  
ATOM   1633  C   LYS C  32      43.786  73.367  -6.830  1.00 64.85           C  
ATOM   1634  O   LYS C  32      42.863  72.543  -6.726  1.00 64.84           O  
ATOM   1635  CB  LYS C  32      45.706  72.457  -8.097  1.00 62.83           C  
ATOM   1636  CG  LYS C  32      47.197  72.167  -8.135  1.00 63.31           C  
ATOM   1637  CD  LYS C  32      47.614  71.600  -9.479  1.00 63.57           C  
ATOM   1638  CE  LYS C  32      47.189  70.166  -9.620  1.00 63.81           C  
ATOM   1639  NZ  LYS C  32      47.847  69.505 -10.776  1.00 63.44           N  
ATOM   1640  N   VAL C  33      43.600  74.663  -7.055  1.00 67.32           N  
ATOM   1641  CA  VAL C  33      42.276  75.237  -7.204  1.00 69.86           C  
ATOM   1642  C   VAL C  33      42.132  75.747  -8.627  1.00 71.82           C  
ATOM   1643  O   VAL C  33      42.893  76.605  -9.064  1.00 71.89           O  
ATOM   1644  CB  VAL C  33      42.074  76.426  -6.238  1.00 70.01           C  
ATOM   1645  CG1 VAL C  33      40.604  76.867  -6.230  1.00 70.02           C  
ATOM   1646  CG2 VAL C  33      42.566  76.082  -4.827  1.00 69.49           C  
ATOM   1647  N   ALA C  34      41.162  75.217  -9.356  1.00 74.39           N  
ATOM   1648  CA  ALA C  34      40.936  75.654 -10.727  1.00 76.97           C  
ATOM   1649  C   ALA C  34      39.474  76.028 -10.948  1.00 79.14           C  
ATOM   1650  O   ALA C  34      38.560  75.250 -10.629  1.00 79.21           O  
ATOM   1651  CB  ALA C  34      41.369  74.577 -11.707  1.00 76.80           C  
ATOM   1652  N   ILE C  35      39.256  77.227 -11.486  1.00 81.46           N  
ATOM   1653  CA  ILE C  35      37.907  77.707 -11.764  1.00 83.70           C  
ATOM   1654  C   ILE C  35      37.477  77.331 -13.182  1.00 85.29           C  
ATOM   1655  O   ILE C  35      37.435  78.175 -14.070  1.00 85.58           O  
ATOM   1656  CB  ILE C  35      37.835  79.227 -11.568  1.00 83.76           C  
ATOM   1657  CG1 ILE C  35      38.462  79.624 -10.231  1.00 83.87           C  
ATOM   1658  CG2 ILE C  35      36.391  79.712 -11.657  1.00 84.09           C  
ATOM   1659  CD1 ILE C  35      38.163  81.044  -9.822  1.00 83.70           C  
ATOM   1660  N   LYS C  36      37.144  76.063 -13.392  1.00 87.14           N  
ATOM   1661  CA  LYS C  36      36.769  75.588 -14.722  1.00 88.99           C  
ATOM   1662  C   LYS C  36      35.464  76.196 -15.222  1.00 89.89           C  
ATOM   1663  O   LYS C  36      34.916  77.124 -14.620  1.00 89.87           O  
ATOM   1664  CB  LYS C  36      36.666  74.058 -14.733  1.00 89.42           C  
ATOM   1665  CG  LYS C  36      37.216  73.379 -15.990  1.00 90.42           C  
ATOM   1666  CD  LYS C  36      37.184  71.856 -15.847  1.00 91.47           C  
ATOM   1667  CE  LYS C  36      37.901  71.144 -16.999  1.00 91.90           C  
ATOM   1668  NZ  LYS C  36      37.299  71.426 -18.335  1.00 92.12           N  
ATOM   1669  N   ASP C  37      34.985  75.643 -16.335  1.00 90.99           N  
ATOM   1670  CA  ASP C  37      33.767  76.081 -17.025  1.00 91.71           C  
ATOM   1671  C   ASP C  37      33.011  77.214 -16.329  1.00 91.27           C  
ATOM   1672  O   ASP C  37      33.210  78.391 -16.629  1.00 91.47           O  
ATOM   1673  CB  ASP C  37      32.832  74.885 -17.265  1.00 92.52           C  
ATOM   1674  CG  ASP C  37      33.575  73.644 -17.769  1.00 94.43           C  
ATOM   1675  OD1 ASP C  37      34.281  73.733 -18.798  1.00 95.62           O  
ATOM   1676  OD2 ASP C  37      33.511  72.530 -17.200  1.00 96.29           O  
ATOM   1677  N   LYS C  38      32.141  76.847 -15.398  1.00 90.62           N  
ATOM   1678  CA  LYS C  38      31.324  77.819 -14.687  1.00 89.75           C  
ATOM   1679  C   LYS C  38      31.723  77.844 -13.210  1.00 88.20           C  
ATOM   1680  O   LYS C  38      31.922  78.910 -12.611  1.00 88.46           O  
ATOM   1681  CB  LYS C  38      29.849  77.417 -14.825  1.00 90.35           C  
ATOM   1682  CG  LYS C  38      28.877  78.550 -15.139  1.00 91.89           C  
ATOM   1683  CD  LYS C  38      27.445  78.145 -14.779  1.00 93.92           C  
ATOM   1684  CE  LYS C  38      26.418  79.065 -15.406  1.00 94.84           C  
ATOM   1685  NZ  LYS C  38      26.255  78.786 -16.853  1.00 95.40           N  
ATOM   1686  N   GLN C  39      31.873  76.647 -12.646  1.00 85.93           N  
ATOM   1687  CA  GLN C  39      32.156  76.476 -11.227  1.00 83.47           C  
ATOM   1688  C   GLN C  39      33.613  76.108 -10.916  1.00 80.55           C  
ATOM   1689  O   GLN C  39      34.421  75.885 -11.814  1.00 80.33           O  
ATOM   1690  CB  GLN C  39      31.203  75.428 -10.636  1.00 84.31           C  
ATOM   1691  CG  GLN C  39      29.725  75.647 -10.985  1.00 86.18           C  
ATOM   1692  CD  GLN C  39      28.846  74.474 -10.586  1.00 88.26           C  
ATOM   1693  OE1 GLN C  39      29.142  73.331 -10.933  1.00 88.97           O  
ATOM   1694  NE2 GLN C  39      27.767  74.752  -9.855  1.00 89.34           N  
ATOM   1695  N   VAL C  40      33.923  76.044  -9.624  1.00 76.86           N  
ATOM   1696  CA  VAL C  40      35.268  75.767  -9.142  1.00 73.12           C  
ATOM   1697  C   VAL C  40      35.439  74.309  -8.774  1.00 70.00           C  
ATOM   1698  O   VAL C  40      34.526  73.692  -8.222  1.00 69.97           O  
ATOM   1699  CB  VAL C  40      35.578  76.612  -7.889  1.00 73.40           C  
ATOM   1700  CG1 VAL C  40      37.037  76.482  -7.476  1.00 73.56           C  
ATOM   1701  CG2 VAL C  40      35.233  78.067  -8.137  1.00 73.53           C  
ATOM   1702  N   LYS C  41      36.608  73.759  -9.092  1.00 65.79           N  
ATOM   1703  CA  LYS C  41      36.937  72.382  -8.732  1.00 61.88           C  
ATOM   1704  C   LYS C  41      38.253  72.308  -7.945  1.00 58.24           C  
ATOM   1705  O   LYS C  41      39.036  73.259  -7.939  1.00 57.55           O  
ATOM   1706  CB  LYS C  41      36.960  71.479  -9.959  1.00 62.36           C  
ATOM   1707  CG  LYS C  41      35.605  71.346 -10.628  1.00 64.55           C  
ATOM   1708  CD  LYS C  41      35.623  70.323 -11.769  1.00 67.15           C  
ATOM   1709  CE  LYS C  41      35.462  68.902 -11.236  1.00 68.95           C  
ATOM   1710  NZ  LYS C  41      35.035  67.902 -12.267  1.00 69.61           N  
ATOM   1711  N   TYR C  42      38.491  71.191  -7.258  1.00 53.86           N  
ATOM   1712  CA  TYR C  42      39.704  71.082  -6.461  1.00 49.71           C  
ATOM   1713  C   TYR C  42      40.483  69.796  -6.687  1.00 47.49           C  
ATOM   1714  O   TYR C  42      39.901  68.710  -6.791  1.00 47.26           O  
ATOM   1715  CB  TYR C  42      39.385  71.201  -4.980  1.00 49.16           C  
ATOM   1716  CG  TYR C  42      38.701  72.472  -4.594  1.00 46.10           C  
ATOM   1717  CD1 TYR C  42      37.350  72.663  -4.836  1.00 44.12           C  
ATOM   1718  CD2 TYR C  42      39.404  73.487  -3.992  1.00 45.60           C  
ATOM   1719  CE1 TYR C  42      36.732  73.823  -4.487  1.00 42.93           C  
ATOM   1720  CE2 TYR C  42      38.785  74.655  -3.642  1.00 44.55           C  
ATOM   1721  CZ  TYR C  42      37.453  74.824  -3.891  1.00 42.98           C  
ATOM   1722  OH  TYR C  42      36.840  76.003  -3.510  1.00 43.40           O  
ATOM   1723  N   PHE C  43      41.807  69.924  -6.777  1.00 44.46           N  
ATOM   1724  CA  PHE C  43      42.633  68.726  -6.881  1.00 42.01           C  
ATOM   1725  C   PHE C  43      42.980  68.300  -5.446  1.00 39.71           C  
ATOM   1726  O   PHE C  43      43.630  69.019  -4.729  1.00 37.69           O  
ATOM   1727  CB  PHE C  43      43.890  68.944  -7.718  1.00 41.65           C  
ATOM   1728  CG  PHE C  43      44.579  67.659  -8.115  1.00 40.16           C  
ATOM   1729  CD1 PHE C  43      43.935  66.739  -8.917  1.00 38.04           C  
ATOM   1730  CD2 PHE C  43      45.882  67.391  -7.698  1.00 39.32           C  
ATOM   1731  CE1 PHE C  43      44.560  65.561  -9.303  1.00 37.96           C  
ATOM   1732  CE2 PHE C  43      46.536  66.221  -8.091  1.00 37.71           C  
ATOM   1733  CZ  PHE C  43      45.879  65.298  -8.894  1.00 36.48           C  
ATOM   1734  N   ILE C  44      42.506  67.124  -5.071  1.00 38.82           N  
ATOM   1735  CA  ILE C  44      42.604  66.610  -3.698  1.00 38.55           C  
ATOM   1736  C   ILE C  44      43.645  65.524  -3.552  1.00 37.68           C  
ATOM   1737  O   ILE C  44      43.636  64.554  -4.273  1.00 37.09           O  
ATOM   1738  CB  ILE C  44      41.208  65.990  -3.224  1.00 38.21           C  
ATOM   1739  CG1 ILE C  44      40.080  67.046  -3.157  1.00 37.75           C  
ATOM   1740  CG2 ILE C  44      41.344  65.238  -1.903  1.00 37.72           C  
ATOM   1741  CD1 ILE C  44      40.390  68.298  -2.400  1.00 37.37           C  
ATOM   1742  N   HIS C  45      44.492  65.643  -2.552  1.00 37.88           N  
ATOM   1743  CA  HIS C  45      45.416  64.538  -2.275  1.00 37.80           C  
ATOM   1744  C   HIS C  45      44.909  63.427  -1.294  1.00 38.03           C  
ATOM   1745  O   HIS C  45      44.858  62.260  -1.644  1.00 39.85           O  
ATOM   1746  CB  HIS C  45      46.793  65.064  -1.857  1.00 36.81           C  
ATOM   1747  CG  HIS C  45      47.656  63.999  -1.290  1.00 35.43           C  
ATOM   1748  ND1 HIS C  45      48.209  64.078  -0.027  1.00 33.47           N  
ATOM   1749  CD2 HIS C  45      47.985  62.781  -1.775  1.00 34.13           C  
ATOM   1750  CE1 HIS C  45      48.881  62.971   0.220  1.00 32.37           C  
ATOM   1751  NE2 HIS C  45      48.739  62.159  -0.811  1.00 34.07           N  
ATOM   1752  N   TYR C  46      44.508  63.741  -0.092  1.00 37.43           N  
ATOM   1753  CA  TYR C  46      44.078  62.647   0.835  1.00 37.01           C  
ATOM   1754  C   TYR C  46      45.241  62.184   1.728  1.00 36.40           C  
ATOM   1755  O   TYR C  46      46.030  61.285   1.365  1.00 36.23           O  
ATOM   1756  CB  TYR C  46      43.484  61.409   0.155  1.00 36.97           C  
ATOM   1757  CG  TYR C  46      42.142  61.586  -0.536  1.00 37.87           C  
ATOM   1758  CD1 TYR C  46      42.045  61.462  -1.908  1.00 37.84           C  
ATOM   1759  CD2 TYR C  46      40.987  61.881   0.188  1.00 37.64           C  
ATOM   1760  CE1 TYR C  46      40.848  61.637  -2.566  1.00 39.17           C  
ATOM   1761  CE2 TYR C  46      39.769  62.059  -0.456  1.00 38.44           C  
ATOM   1762  CZ  TYR C  46      39.713  61.926  -1.844  1.00 39.89           C  
ATOM   1763  OH  TYR C  46      38.538  62.096  -2.520  1.00 41.80           O  
ATOM   1764  N   SER C  47      45.323  62.796   2.901  1.00 35.30           N  
ATOM   1765  CA  SER C  47      46.448  62.562   3.810  1.00 34.86           C  
ATOM   1766  C   SER C  47      46.754  61.090   4.031  1.00 35.50           C  
ATOM   1767  O   SER C  47      45.870  60.311   4.342  1.00 34.01           O  
ATOM   1768  CB  SER C  47      46.230  63.278   5.130  1.00 33.98           C  
ATOM   1769  OG  SER C  47      45.853  64.598   4.888  1.00 30.28           O  
ATOM   1770  N   GLY C  48      48.005  60.710   3.764  1.00 36.84           N  
ATOM   1771  CA  GLY C  48      48.434  59.347   3.967  1.00 39.17           C  
ATOM   1772  C   GLY C  48      48.006  58.323   2.932  1.00 41.13           C  
ATOM   1773  O   GLY C  48      48.261  57.101   3.120  1.00 41.32           O  
ATOM   1774  N   TRP C  49      47.354  58.793   1.865  1.00 42.22           N  
ATOM   1775  CA  TRP C  49      46.940  57.919   0.767  1.00 44.10           C  
ATOM   1776  C   TRP C  49      47.979  58.037  -0.313  1.00 44.74           C  
ATOM   1777  O   TRP C  49      48.558  59.109  -0.497  1.00 42.91           O  
ATOM   1778  CB  TRP C  49      45.617  58.377   0.145  1.00 44.57           C  
ATOM   1779  CG  TRP C  49      44.377  58.109   0.970  1.00 46.74           C  
ATOM   1780  CD1 TRP C  49      44.271  58.137   2.320  1.00 47.42           C  
ATOM   1781  CD2 TRP C  49      43.064  57.835   0.467  1.00 48.05           C  
ATOM   1782  NE1 TRP C  49      42.980  57.860   2.704  1.00 50.10           N  
ATOM   1783  CE2 TRP C  49      42.214  57.671   1.579  1.00 49.79           C  
ATOM   1784  CE3 TRP C  49      42.524  57.675  -0.810  1.00 47.52           C  
ATOM   1785  CZ2 TRP C  49      40.857  57.371   1.448  1.00 49.59           C  
ATOM   1786  CZ3 TRP C  49      41.192  57.377  -0.938  1.00 48.00           C  
ATOM   1787  CH2 TRP C  49      40.371  57.220   0.185  1.00 48.76           C  
ATOM   1788  N   ASN C  50      48.178  56.967  -1.071  1.00 47.11           N  
ATOM   1789  CA  ASN C  50      49.116  57.037  -2.195  1.00 49.74           C  
ATOM   1790  C   ASN C  50      48.631  58.042  -3.234  1.00 51.29           C  
ATOM   1791  O   ASN C  50      47.436  58.198  -3.451  1.00 51.06           O  
ATOM   1792  CB  ASN C  50      49.308  55.676  -2.832  1.00 50.13           C  
ATOM   1793  CG  ASN C  50      50.209  54.757  -2.010  1.00 51.51           C  
ATOM   1794  OD1 ASN C  50      50.889  55.171  -1.053  1.00 53.08           O  
ATOM   1795  ND2 ASN C  50      50.208  53.494  -2.380  1.00 52.09           N  
ATOM   1796  N   LYS C  51      49.573  58.711  -3.885  1.00 53.55           N  
ATOM   1797  CA  LYS C  51      49.285  59.756  -4.864  1.00 55.44           C  
ATOM   1798  C   LYS C  51      48.371  59.443  -6.045  1.00 55.72           C  
ATOM   1799  O   LYS C  51      47.905  60.364  -6.722  1.00 55.83           O  
ATOM   1800  CB  LYS C  51      50.586  60.360  -5.385  1.00 56.77           C  
ATOM   1801  CG  LYS C  51      51.479  60.877  -4.272  1.00 60.40           C  
ATOM   1802  CD  LYS C  51      52.673  61.615  -4.822  1.00 65.12           C  
ATOM   1803  CE  LYS C  51      53.672  61.878  -3.717  1.00 68.70           C  
ATOM   1804  NZ  LYS C  51      54.804  62.752  -4.172  1.00 71.69           N  
ATOM   1805  N   ASN C  52      48.074  58.187  -6.325  1.00 56.05           N  
ATOM   1806  CA  ASN C  52      47.222  57.990  -7.489  1.00 56.81           C  
ATOM   1807  C   ASN C  52      45.718  58.044  -7.230  1.00 56.30           C  
ATOM   1808  O   ASN C  52      44.934  57.894  -8.162  1.00 55.91           O  
ATOM   1809  CB  ASN C  52      47.623  56.749  -8.278  1.00 57.40           C  
ATOM   1810  CG  ASN C  52      48.923  56.953  -9.047  1.00 59.98           C  
ATOM   1811  OD1 ASN C  52      49.981  57.220  -8.456  1.00 61.60           O  
ATOM   1812  ND2 ASN C  52      48.851  56.832 -10.375  1.00 61.66           N  
ATOM   1813  N   TRP C  53      45.335  58.230  -5.965  1.00 55.75           N  
ATOM   1814  CA  TRP C  53      43.936  58.395  -5.586  1.00 55.04           C  
ATOM   1815  C   TRP C  53      43.613  59.872  -5.631  1.00 53.64           C  
ATOM   1816  O   TRP C  53      42.480  60.277  -5.383  1.00 53.42           O  
ATOM   1817  CB  TRP C  53      43.685  57.897  -4.177  1.00 55.98           C  
ATOM   1818  CG  TRP C  53      44.003  56.500  -4.015  1.00 58.68           C  
ATOM   1819  CD1 TRP C  53      45.155  55.976  -3.525  1.00 59.98           C  
ATOM   1820  CD2 TRP C  53      43.170  55.407  -4.358  1.00 60.84           C  
ATOM   1821  NE1 TRP C  53      45.086  54.607  -3.537  1.00 61.01           N  
ATOM   1822  CE2 TRP C  53      43.874  54.234  -4.054  1.00 62.04           C  
ATOM   1823  CE3 TRP C  53      41.891  55.295  -4.897  1.00 62.76           C  
ATOM   1824  CZ2 TRP C  53      43.344  52.966  -4.270  1.00 63.86           C  
ATOM   1825  CZ3 TRP C  53      41.365  54.034  -5.103  1.00 63.99           C  
ATOM   1826  CH2 TRP C  53      42.089  52.890  -4.788  1.00 63.80           C  
ATOM   1827  N   ASP C  54      44.622  60.685  -5.902  1.00 51.89           N  
ATOM   1828  CA  ASP C  54      44.381  62.103  -6.019  1.00 51.04           C  
ATOM   1829  C   ASP C  54      43.395  62.264  -7.159  1.00 49.82           C  
ATOM   1830  O   ASP C  54      43.405  61.480  -8.108  1.00 49.59           O  
ATOM   1831  CB  ASP C  54      45.672  62.878  -6.274  1.00 51.48           C  
ATOM   1832  CG  ASP C  54      46.696  62.653  -5.185  1.00 53.46           C  
ATOM   1833  OD1 ASP C  54      46.991  61.487  -4.908  1.00 56.55           O  
ATOM   1834  OD2 ASP C  54      47.257  63.541  -4.535  1.00 54.25           O  
ATOM   1835  N   GLU C  55      42.500  63.230  -7.029  1.00 47.96           N  
ATOM   1836  CA  GLU C  55      41.476  63.420  -8.032  1.00 46.76           C  
ATOM   1837  C   GLU C  55      40.937  64.833  -7.987  1.00 45.79           C  
ATOM   1838  O   GLU C  55      41.046  65.544  -6.976  1.00 45.13           O  
ATOM   1839  CB  GLU C  55      40.334  62.433  -7.840  1.00 46.59           C  
ATOM   1840  CG  GLU C  55      39.788  62.442  -6.419  1.00 47.04           C  
ATOM   1841  CD  GLU C  55      38.522  61.620  -6.264  1.00 46.80           C  
ATOM   1842  OE1 GLU C  55      38.253  61.106  -5.158  1.00 47.41           O  
ATOM   1843  OE2 GLU C  55      37.784  61.487  -7.244  1.00 46.68           O  
ATOM   1844  N   TRP C  56      40.411  65.253  -9.122  1.00 45.00           N  
ATOM   1845  CA  TRP C  56      39.733  66.523  -9.208  1.00 44.24           C  
ATOM   1846  C   TRP C  56      38.320  66.293  -8.663  1.00 42.88           C  
ATOM   1847  O   TRP C  56      37.655  65.327  -9.028  1.00 42.99           O  
ATOM   1848  CB  TRP C  56      39.674  66.997 -10.654  1.00 44.57           C  
ATOM   1849  CG  TRP C  56      40.942  67.598 -11.107  1.00 44.04           C  
ATOM   1850  CD1 TRP C  56      41.882  67.020 -11.911  1.00 43.43           C  
ATOM   1851  CD2 TRP C  56      41.436  68.899 -10.771  1.00 43.61           C  
ATOM   1852  NE1 TRP C  56      42.930  67.887 -12.100  1.00 43.92           N  
ATOM   1853  CE2 TRP C  56      42.684  69.048 -11.410  1.00 43.85           C  
ATOM   1854  CE3 TRP C  56      40.953  69.955  -9.978  1.00 42.32           C  
ATOM   1855  CZ2 TRP C  56      43.444  70.201 -11.300  1.00 43.29           C  
ATOM   1856  CZ3 TRP C  56      41.708  71.090  -9.856  1.00 42.63           C  
ATOM   1857  CH2 TRP C  56      42.942  71.214 -10.529  1.00 44.11           C  
ATOM   1858  N   VAL C  57      37.860  67.185  -7.802  1.00 41.29           N  
ATOM   1859  CA  VAL C  57      36.556  66.997  -7.202  1.00 40.35           C  
ATOM   1860  C   VAL C  57      35.812  68.334  -7.159  1.00 39.80           C  
ATOM   1861  O   VAL C  57      36.428  69.363  -7.051  1.00 38.24           O  
ATOM   1862  CB  VAL C  57      36.781  66.466  -5.756  1.00 40.53           C  
ATOM   1863  CG1 VAL C  57      36.835  67.623  -4.745  1.00 37.09           C  
ATOM   1864  CG2 VAL C  57      35.783  65.424  -5.390  1.00 41.52           C  
ATOM   1865  N   PRO C  58      34.491  68.331  -7.301  1.00 40.60           N  
ATOM   1866  CA  PRO C  58      33.706  69.575  -7.142  1.00 41.28           C  
ATOM   1867  C   PRO C  58      33.697  70.072  -5.690  1.00 41.90           C  
ATOM   1868  O   PRO C  58      34.081  69.304  -4.778  1.00 41.33           O  
ATOM   1869  CB  PRO C  58      32.291  69.158  -7.552  1.00 40.93           C  
ATOM   1870  CG  PRO C  58      32.292  67.695  -7.366  1.00 41.17           C  
ATOM   1871  CD  PRO C  58      33.661  67.189  -7.715  1.00 40.18           C  
ATOM   1872  N   GLU C  59      33.254  71.310  -5.478  1.00 42.78           N  
ATOM   1873  CA  GLU C  59      33.232  71.933  -4.149  1.00 44.22           C  
ATOM   1874  C   GLU C  59      32.470  71.143  -3.096  1.00 43.83           C  
ATOM   1875  O   GLU C  59      32.898  71.051  -1.961  1.00 44.40           O  
ATOM   1876  CB  GLU C  59      32.711  73.384  -4.180  1.00 45.48           C  
ATOM   1877  CG  GLU C  59      33.823  74.438  -4.256  1.00 48.77           C  
ATOM   1878  CD  GLU C  59      33.386  75.866  -3.940  1.00 53.55           C  
ATOM   1879  OE1 GLU C  59      34.273  76.779  -3.873  1.00 53.84           O  
ATOM   1880  OE2 GLU C  59      32.162  76.089  -3.753  1.00 56.49           O  
ATOM   1881  N   SER C  60      31.361  70.547  -3.486  1.00 43.19           N  
ATOM   1882  CA  SER C  60      30.515  69.827  -2.558  1.00 42.54           C  
ATOM   1883  C   SER C  60      31.137  68.591  -1.907  1.00 41.46           C  
ATOM   1884  O   SER C  60      30.632  68.107  -0.893  1.00 42.00           O  
ATOM   1885  CB  SER C  60      29.234  69.401  -3.282  1.00 43.10           C  
ATOM   1886  OG  SER C  60      29.507  68.437  -4.275  1.00 43.39           O  
ATOM   1887  N   ARG C  61      32.204  68.044  -2.479  1.00 39.26           N  
ATOM   1888  CA  ARG C  61      32.788  66.871  -1.858  1.00 37.75           C  
ATOM   1889  C   ARG C  61      33.753  67.257  -0.766  1.00 35.80           C  
ATOM   1890  O   ARG C  61      34.318  66.419  -0.075  1.00 33.56           O  
ATOM   1891  CB  ARG C  61      33.444  65.963  -2.896  1.00 38.02           C  
ATOM   1892  CG  ARG C  61      32.451  64.982  -3.407  1.00 39.57           C  
ATOM   1893  CD  ARG C  61      32.973  63.939  -4.268  1.00 43.18           C  
ATOM   1894  NE  ARG C  61      34.069  63.176  -3.682  1.00 46.22           N  
ATOM   1895  CZ  ARG C  61      34.873  62.411  -4.412  1.00 47.90           C  
ATOM   1896  NH1 ARG C  61      34.709  62.340  -5.730  1.00 48.97           N  
ATOM   1897  NH2 ARG C  61      35.849  61.733  -3.842  1.00 49.28           N  
ATOM   1898  N   VAL C  62      33.923  68.556  -0.612  1.00 35.38           N  
ATOM   1899  CA  VAL C  62      34.895  69.061   0.328  1.00 35.33           C  
ATOM   1900  C   VAL C  62      34.276  69.874   1.441  1.00 35.66           C  
ATOM   1901  O   VAL C  62      33.369  70.658   1.206  1.00 35.77           O  
ATOM   1902  CB  VAL C  62      35.867  69.978  -0.397  1.00 34.70           C  
ATOM   1903  CG1 VAL C  62      37.027  70.289   0.484  1.00 35.75           C  
ATOM   1904  CG2 VAL C  62      36.337  69.323  -1.697  1.00 33.65           C  
ATOM   1905  N   LEU C  63      34.824  69.736   2.647  1.00 35.41           N  
ATOM   1906  CA  LEU C  63      34.359  70.513   3.781  1.00 35.02           C  
ATOM   1907  C   LEU C  63      35.505  71.152   4.508  1.00 34.16           C  
ATOM   1908  O   LEU C  63      36.624  70.680   4.458  1.00 34.54           O  
ATOM   1909  CB  LEU C  63      33.596  69.616   4.747  1.00 35.56           C  
ATOM   1910  CG  LEU C  63      32.273  69.010   4.256  1.00 35.62           C  
ATOM   1911  CD1 LEU C  63      31.667  68.057   5.325  1.00 32.07           C  
ATOM   1912  CD2 LEU C  63      31.265  70.139   3.913  1.00 35.73           C  
ATOM   1913  N   LYS C  64      35.209  72.198   5.235  1.00 34.01           N  
ATOM   1914  CA  LYS C  64      36.174  72.889   6.053  1.00 35.29           C  
ATOM   1915  C   LYS C  64      36.689  72.044   7.221  1.00 35.65           C  
ATOM   1916  O   LYS C  64      35.932  71.253   7.836  1.00 34.82           O  
ATOM   1917  CB  LYS C  64      35.520  74.158   6.580  1.00 36.19           C  
ATOM   1918  CG  LYS C  64      36.362  75.440   6.427  1.00 39.81           C  
ATOM   1919  CD  LYS C  64      36.489  75.886   4.994  1.00 40.29           C  
ATOM   1920  CE  LYS C  64      37.183  77.240   4.907  1.00 40.31           C  
ATOM   1921  NZ  LYS C  64      37.802  77.429   3.579  1.00 39.32           N  
ATOM   1922  N   TYR C  65      37.970  72.213   7.553  1.00 35.91           N  
ATOM   1923  CA  TYR C  65      38.573  71.427   8.624  1.00 36.18           C  
ATOM   1924  C   TYR C  65      38.205  72.061   9.960  1.00 36.88           C  
ATOM   1925  O   TYR C  65      39.043  72.728  10.576  1.00 37.64           O  
ATOM   1926  CB  TYR C  65      40.104  71.332   8.494  1.00 36.17           C  
ATOM   1927  CG  TYR C  65      40.647  70.130   9.225  1.00 34.80           C  
ATOM   1928  CD1 TYR C  65      40.609  68.882   8.643  1.00 35.15           C  
ATOM   1929  CD2 TYR C  65      41.112  70.222  10.530  1.00 33.71           C  
ATOM   1930  CE1 TYR C  65      41.096  67.763   9.319  1.00 34.91           C  
ATOM   1931  CE2 TYR C  65      41.585  69.098  11.210  1.00 32.51           C  
ATOM   1932  CZ  TYR C  65      41.558  67.875  10.596  1.00 33.36           C  
ATOM   1933  OH  TYR C  65      41.957  66.720  11.246  1.00 35.02           O  
ATOM   1934  N   VAL C  66      36.969  71.835  10.409  1.00 36.54           N  
ATOM   1935  CA  VAL C  66      36.455  72.458  11.621  1.00 36.58           C  
ATOM   1936  C   VAL C  66      35.672  71.476  12.533  1.00 36.00           C  
ATOM   1937  O   VAL C  66      35.153  70.473  12.051  1.00 34.73           O  
ATOM   1938  CB  VAL C  66      35.561  73.652  11.252  1.00 37.34           C  
ATOM   1939  CG1 VAL C  66      34.211  73.193  10.752  1.00 35.56           C  
ATOM   1940  CG2 VAL C  66      35.361  74.543  12.456  1.00 40.47           C  
ATOM   1941  N   ASP C  67      35.627  71.740  13.840  1.00 35.29           N  
ATOM   1942  CA  ASP C  67      34.945  70.819  14.780  1.00 36.33           C  
ATOM   1943  C   ASP C  67      33.645  70.249  14.258  1.00 35.34           C  
ATOM   1944  O   ASP C  67      33.463  69.044  14.226  1.00 35.67           O  
ATOM   1945  CB  ASP C  67      34.592  71.519  16.090  1.00 37.18           C  
ATOM   1946  CG  ASP C  67      35.759  71.692  16.970  1.00 38.63           C  
ATOM   1947  OD1 ASP C  67      36.839  71.147  16.654  1.00 39.52           O  
ATOM   1948  OD2 ASP C  67      35.690  72.359  18.012  1.00 41.48           O  
ATOM   1949  N   THR C  68      32.732  71.123  13.879  1.00 34.70           N  
ATOM   1950  CA  THR C  68      31.460  70.695  13.289  1.00 35.31           C  
ATOM   1951  C   THR C  68      31.687  69.529  12.287  1.00 32.87           C  
ATOM   1952  O   THR C  68      31.037  68.482  12.335  1.00 32.47           O  
ATOM   1953  CB  THR C  68      30.809  71.925  12.572  1.00 36.22           C  
ATOM   1954  OG1 THR C  68      29.938  72.581  13.488  1.00 40.20           O  
ATOM   1955  CG2 THR C  68      29.853  71.506  11.499  1.00 38.27           C  
ATOM   1956  N   ASN C  69      32.618  69.721  11.371  1.00 30.53           N  
ATOM   1957  CA  ASN C  69      32.840  68.730  10.321  1.00 28.28           C  
ATOM   1958  C   ASN C  69      33.570  67.536  10.839  1.00 26.48           C  
ATOM   1959  O   ASN C  69      33.406  66.452  10.360  1.00 24.72           O  
ATOM   1960  CB  ASN C  69      33.582  69.374   9.164  1.00 27.77           C  
ATOM   1961  CG  ASN C  69      32.713  70.375   8.429  1.00 28.67           C  
ATOM   1962  OD1 ASN C  69      33.213  71.300   7.788  1.00 29.81           O  
ATOM   1963  ND2 ASN C  69      31.401  70.156   8.474  1.00 24.22           N  
ATOM   1964  N   LEU C  70      34.402  67.756  11.832  1.00 26.32           N  
ATOM   1965  CA  LEU C  70      35.122  66.645  12.434  1.00 26.80           C  
ATOM   1966  C   LEU C  70      34.148  65.742  13.190  1.00 26.17           C  
ATOM   1967  O   LEU C  70      34.337  64.549  13.198  1.00 26.38           O  
ATOM   1968  CB  LEU C  70      36.213  67.162  13.390  1.00 27.12           C  
ATOM   1969  CG  LEU C  70      37.383  67.896  12.732  1.00 29.08           C  
ATOM   1970  CD1 LEU C  70      38.298  68.481  13.828  1.00 29.59           C  
ATOM   1971  CD2 LEU C  70      38.173  66.983  11.747  1.00 28.86           C  
ATOM   1972  N   GLN C  71      33.142  66.317  13.862  1.00 25.21           N  
ATOM   1973  CA  GLN C  71      32.140  65.501  14.528  1.00 25.47           C  
ATOM   1974  C   GLN C  71      31.334  64.714  13.474  1.00 25.75           C  
ATOM   1975  O   GLN C  71      31.033  63.542  13.680  1.00 24.96           O  
ATOM   1976  CB  GLN C  71      31.217  66.360  15.419  1.00 26.48           C  
ATOM   1977  CG  GLN C  71      30.026  65.635  16.093  1.00 26.23           C  
ATOM   1978  CD  GLN C  71      30.469  64.526  17.014  1.00 25.03           C  
ATOM   1979  OE1 GLN C  71      31.557  64.587  17.569  1.00 25.38           O  
ATOM   1980  NE2 GLN C  71      29.663  63.499  17.144  1.00 24.74           N  
ATOM   1981  N   LYS C  72      31.013  65.358  12.343  1.00 24.06           N  
ATOM   1982  CA  LYS C  72      30.311  64.677  11.268  1.00 24.85           C  
ATOM   1983  C   LYS C  72      31.138  63.525  10.758  1.00 24.01           C  
ATOM   1984  O   LYS C  72      30.625  62.428  10.528  1.00 22.25           O  
ATOM   1985  CB  LYS C  72      29.985  65.639  10.105  1.00 25.87           C  
ATOM   1986  CG  LYS C  72      29.287  65.027   8.896  1.00 29.03           C  
ATOM   1987  CD  LYS C  72      29.181  66.076   7.795  1.00 34.99           C  
ATOM   1988  CE  LYS C  72      27.979  65.895   6.967  1.00 42.07           C  
ATOM   1989  NZ  LYS C  72      28.090  64.600   6.180  1.00 47.74           N  
ATOM   1990  N   GLN C  73      32.435  63.767  10.595  1.00 24.06           N  
ATOM   1991  CA  GLN C  73      33.308  62.694  10.162  1.00 24.18           C  
ATOM   1992  C   GLN C  73      33.179  61.449  11.100  1.00 24.19           C  
ATOM   1993  O   GLN C  73      33.080  60.319  10.620  1.00 21.61           O  
ATOM   1994  CB  GLN C  73      34.756  63.166  10.039  1.00 23.33           C  
ATOM   1995  CG  GLN C  73      35.766  62.016   9.873  1.00 24.00           C  
ATOM   1996  CD  GLN C  73      37.235  62.485   9.851  1.00 24.26           C  
ATOM   1997  OE1 GLN C  73      37.698  63.254  10.713  1.00 24.77           O  
ATOM   1998  NE2 GLN C  73      37.947  62.022   8.874  1.00 23.38           N  
ATOM   1999  N   ARG C  74      33.219  61.679  12.420  1.00 25.47           N  
ATOM   2000  CA  ARG C  74      33.085  60.612  13.411  1.00 27.17           C  
ATOM   2001  C   ARG C  74      31.754  59.891  13.250  1.00 26.92           C  
ATOM   2002  O   ARG C  74      31.694  58.648  13.252  1.00 26.69           O  
ATOM   2003  CB  ARG C  74      33.125  61.135  14.858  1.00 27.90           C  
ATOM   2004  CG  ARG C  74      34.228  62.037  15.184  1.00 35.12           C  
ATOM   2005  CD  ARG C  74      34.606  62.064  16.694  1.00 43.98           C  
ATOM   2006  NE  ARG C  74      35.743  62.934  16.928  1.00 48.09           N  
ATOM   2007  CZ  ARG C  74      35.630  64.252  17.038  1.00 52.06           C  
ATOM   2008  NH1 ARG C  74      34.420  64.846  16.971  1.00 51.01           N  
ATOM   2009  NH2 ARG C  74      36.726  64.978  17.233  1.00 54.55           N  
ATOM   2010  N   GLU C  75      30.683  60.672  13.119  1.00 27.06           N  
ATOM   2011  CA  GLU C  75      29.362  60.068  12.977  1.00 27.60           C  
ATOM   2012  C   GLU C  75      29.297  59.220  11.707  1.00 28.15           C  
ATOM   2013  O   GLU C  75      28.743  58.146  11.741  1.00 26.63           O  
ATOM   2014  CB  GLU C  75      28.247  61.122  13.081  1.00 27.65           C  
ATOM   2015  CG  GLU C  75      28.321  61.902  14.410  1.00 27.61           C  
ATOM   2016  CD  GLU C  75      27.177  62.882  14.698  1.00 26.66           C  
ATOM   2017  OE1 GLU C  75      26.316  63.146  13.836  1.00 22.87           O  
ATOM   2018  OE2 GLU C  75      27.162  63.424  15.838  1.00 29.06           O  
ATOM   2019  N   LEU C  76      29.929  59.657  10.602  1.00 28.70           N  
ATOM   2020  CA  LEU C  76      29.817  58.840   9.395  1.00 29.93           C  
ATOM   2021  C   LEU C  76      30.587  57.528   9.526  1.00 30.31           C  
ATOM   2022  O   LEU C  76      30.134  56.515   9.042  1.00 30.02           O  
ATOM   2023  CB  LEU C  76      30.248  59.578   8.138  1.00 29.96           C  
ATOM   2024  CG  LEU C  76      29.469  60.844   7.744  1.00 32.27           C  
ATOM   2025  CD1 LEU C  76      29.373  60.922   6.232  1.00 32.57           C  
ATOM   2026  CD2 LEU C  76      28.107  61.022   8.414  1.00 29.77           C  
ATOM   2027  N   GLN C  77      31.751  57.573  10.167  1.00 31.44           N  
ATOM   2028  CA  GLN C  77      32.561  56.386  10.431  1.00 33.23           C  
ATOM   2029  C   GLN C  77      31.723  55.423  11.214  1.00 34.43           C  
ATOM   2030  O   GLN C  77      31.697  54.238  10.926  1.00 34.45           O  
ATOM   2031  CB  GLN C  77      33.821  56.735  11.259  1.00 33.10           C  
ATOM   2032  CG  GLN C  77      34.711  57.714  10.558  1.00 34.96           C  
ATOM   2033  CD  GLN C  77      35.940  58.145  11.356  1.00 37.99           C  
ATOM   2034  OE1 GLN C  77      35.935  58.160  12.596  1.00 36.49           O  
ATOM   2035  NE2 GLN C  77      37.005  58.494  10.632  1.00 38.81           N  
ATOM   2036  N   LYS C  78      31.038  55.969  12.218  1.00 36.34           N  
ATOM   2037  CA  LYS C  78      30.188  55.194  13.113  1.00 37.79           C  
ATOM   2038  C   LYS C  78      29.019  54.605  12.371  1.00 38.10           C  
ATOM   2039  O   LYS C  78      28.750  53.427  12.530  1.00 37.12           O  
ATOM   2040  CB  LYS C  78      29.702  56.086  14.250  1.00 38.91           C  
ATOM   2041  CG  LYS C  78      28.818  55.434  15.247  1.00 42.43           C  
ATOM   2042  CD  LYS C  78      28.948  56.139  16.632  1.00 45.36           C  
ATOM   2043  CE  LYS C  78      27.576  56.583  17.085  1.00 46.63           C  
ATOM   2044  NZ  LYS C  78      27.590  56.979  18.516  1.00 47.37           N  
ATOM   2045  N   ALA C  79      28.315  55.409  11.559  1.00 38.34           N  
ATOM   2046  CA  ALA C  79      27.193  54.863  10.777  1.00 39.73           C  
ATOM   2047  C   ALA C  79      27.680  53.770   9.818  1.00 41.17           C  
ATOM   2048  O   ALA C  79      27.019  52.768   9.646  1.00 39.72           O  
ATOM   2049  CB  ALA C  79      26.477  55.944   9.988  1.00 38.56           C  
ATOM   2050  N   ASN C  80      28.830  54.002   9.185  1.00 44.11           N  
ATOM   2051  CA  ASN C  80      29.411  53.013   8.289  1.00 47.51           C  
ATOM   2052  C   ASN C  80      29.869  51.791   9.048  1.00 50.53           C  
ATOM   2053  O   ASN C  80      29.750  50.673   8.544  1.00 50.69           O  
ATOM   2054  CB  ASN C  80      30.588  53.572   7.507  1.00 47.21           C  
ATOM   2055  CG  ASN C  80      30.842  52.806   6.224  1.00 47.73           C  
ATOM   2056  OD1 ASN C  80      30.011  52.792   5.309  1.00 46.88           O  
ATOM   2057  ND2 ASN C  80      31.990  52.142   6.160  1.00 48.25           N  
ATOM   2058  N   GLN C  81      30.399  51.993  10.254  1.00 54.00           N  
ATOM   2059  CA  GLN C  81      30.822  50.855  11.061  1.00 57.73           C  
ATOM   2060  C   GLN C  81      29.575  50.062  11.445  1.00 60.28           C  
ATOM   2061  O   GLN C  81      29.638  48.851  11.612  1.00 60.20           O  
ATOM   2062  CB  GLN C  81      31.556  51.286  12.333  1.00 57.63           C  
ATOM   2063  CG  GLN C  81      32.852  52.030  12.126  1.00 58.78           C  
ATOM   2064  CD  GLN C  81      33.439  52.557  13.437  1.00 59.99           C  
ATOM   2065  OE1 GLN C  81      32.693  52.871  14.362  1.00 61.34           O  
ATOM   2066  NE2 GLN C  81      34.764  52.645  13.520  1.00 59.71           N  
ATOM   2067  N   GLU C  82      28.447  50.752  11.572  1.00 63.66           N  
ATOM   2068  CA  GLU C  82      27.205  50.111  11.972  1.00 67.83           C  
ATOM   2069  C   GLU C  82      26.591  49.345  10.816  1.00 71.04           C  
ATOM   2070  O   GLU C  82      25.773  48.449  11.017  1.00 70.82           O  
ATOM   2071  CB  GLU C  82      26.209  51.133  12.529  1.00 67.78           C  
ATOM   2072  CG  GLU C  82      24.900  50.530  13.022  1.00 69.11           C  
ATOM   2073  CD  GLU C  82      24.061  51.491  13.859  1.00 71.81           C  
ATOM   2074  OE1 GLU C  82      23.838  52.647  13.420  1.00 73.15           O  
ATOM   2075  OE2 GLU C  82      23.614  51.092  14.959  1.00 72.40           O  
ATOM   2076  N   GLN C  83      26.992  49.703   9.602  1.00 75.26           N  
ATOM   2077  CA  GLN C  83      26.533  49.008   8.412  1.00 79.54           C  
ATOM   2078  C   GLN C  83      27.217  47.656   8.283  1.00 82.04           C  
ATOM   2079  O   GLN C  83      26.547  46.645   8.151  1.00 82.48           O  
ATOM   2080  CB  GLN C  83      26.784  49.846   7.155  1.00 80.06           C  
ATOM   2081  CG  GLN C  83      26.034  51.159   7.149  1.00 82.23           C  
ATOM   2082  CD  GLN C  83      25.961  51.805   5.768  1.00 84.54           C  
ATOM   2083  OE1 GLN C  83      26.992  52.117   5.146  1.00 84.99           O  
ATOM   2084  NE2 GLN C  83      24.739  52.022   5.294  1.00 85.05           N  
ATOM   2085  N   TYR C  84      28.548  47.650   8.323  1.00 85.33           N  
ATOM   2086  CA  TYR C  84      29.329  46.417   8.217  1.00 88.75           C  
ATOM   2087  C   TYR C  84      28.647  45.312   9.018  1.00 90.55           C  
ATOM   2088  O   TYR C  84      28.219  44.295   8.469  1.00 90.76           O  
ATOM   2089  CB  TYR C  84      30.754  46.630   8.744  1.00 89.33           C  
ATOM   2090  CG  TYR C  84      31.731  47.287   7.773  1.00 91.29           C  
ATOM   2091  CD1 TYR C  84      33.013  47.651   8.192  1.00 92.45           C  
ATOM   2092  CD2 TYR C  84      31.383  47.540   6.442  1.00 92.48           C  
ATOM   2093  CE1 TYR C  84      33.918  48.244   7.324  1.00 93.07           C  
ATOM   2094  CE2 TYR C  84      32.287  48.137   5.566  1.00 93.27           C  
ATOM   2095  CZ  TYR C  84      33.553  48.484   6.017  1.00 93.71           C  
ATOM   2096  OH  TYR C  84      34.463  49.075   5.167  1.00 94.35           O  
ATOM   2097  N   ALA C  85      28.566  45.525  10.325  1.00 92.68           N  
ATOM   2098  CA  ALA C  85      27.894  44.605  11.220  1.00 94.55           C  
ATOM   2099  C   ALA C  85      26.439  45.010  11.204  1.00 95.93           C  
ATOM   2100  O   ALA C  85      26.070  45.987  11.844  1.00 96.34           O  
ATOM   2101  CB  ALA C  85      28.455  44.741  12.614  1.00 94.56           C  
ATOM   2102  N   GLU C  86      25.618  44.270  10.464  1.00 97.43           N  
ATOM   2103  CA  GLU C  86      24.201  44.607  10.317  1.00 98.62           C  
ATOM   2104  C   GLU C  86      23.586  45.026  11.649  1.00 98.94           C  
ATOM   2105  O   GLU C  86      24.161  44.802  12.719  1.00 99.30           O  
ATOM   2106  CB  GLU C  86      23.411  43.440   9.718  1.00 99.00           C  
ATOM   2107  CG  GLU C  86      22.476  43.853   8.593  1.00100.44           C  
ATOM   2108  CD  GLU C  86      21.036  43.424   8.823  1.00101.97           C  
ATOM   2109  OE1 GLU C  86      20.802  42.259   9.210  1.00102.20           O  
ATOM   2110  OE2 GLU C  86      20.130  44.262   8.618  1.00102.69           O  
TER    2111      GLU C  86                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
