
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   88 ( 1462),  selected   88 , name 2eqm_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2eqm_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      L       3           -
LGA    G     4_A      Y       4           -
LGA    S     5_A      F       5           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    M     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    K    10_A      -       -           -
LGA    K    11_A      Q       6          4.399
LGA    P    12_A      G       7          3.303
LGA    P    13_A      -       -           -
LGA    N    14_A      -       -           -
LGA    R    15_A      -       -           -
LGA    P    16_A      -       -           -
LGA    G    17_A      -       -           -
LGA    I    18_A      -       -           -
LGA    T    19_A      D       8          3.986
LGA    F    20_A      L       9          2.317
LGA    E    21_A      I      10          1.699
LGA    I    22_A      V      11          0.692
LGA    G    23_A      S      12          0.586
LGA    A    24_A      M      13          1.068
LGA    R    25_A      R      14          0.717
LGA    L    26_A      I      15          0.471
LGA    E    27_A      L      16          0.344
LGA    A    28_A      G      17          0.856
LGA    L    29_A      K      18          1.547
LGA    D    30_A      K      19          1.158
LGA    Y    31_A      R      20          1.934
LGA    L    32_A      T      21          1.422
LGA    Q    33_A      K      22          2.042
LGA    K    34_A      T      23          1.338
LGA    W    35_A      W      24          1.839
LGA    Y    36_A      X      25          0.869
LGA    P    37_A      K      26          0.461
LGA    S    38_A      G      27          0.829
LGA    R    39_A      T      28          1.081
LGA    I    40_A      L      29          1.161
LGA    E    41_A      I      30          0.922
LGA    K    42_A      A      31          1.032
LGA    I    43_A      I      32          0.788
LGA    D    44_A      Q      33          0.997
LGA    Y    45_A      T      34          2.738
LGA    E    46_A      V      35          3.451
LGA    -       -      G      36           -
LGA    -       -      P      37           -
LGA    E    47_A      G      38          4.405
LGA    G    48_A      K      39          1.298
LGA    K    49_A      K      40          1.320
LGA    M    50_A      Y      41          2.016
LGA    L    51_A      K      42          1.500
LGA    V    52_A      V      43          1.073
LGA    H    53_A      K      44          0.782
LGA    F    54_A      F      45          0.873
LGA    E    55_A      D      46          1.178
LGA    R    56_A      N      47          2.660
LGA    W    57_A      K      48          2.009
LGA    S    58_A      -       -           -
LGA    H    59_A      -       -           -
LGA    R    60_A      -       -           -
LGA    Y    61_A      G      49          1.135
LGA    D    62_A      K      50          0.966
LGA    E    63_A      S      51          1.542
LGA    W    64_A      L      52          1.175
LGA    I    65_A      L      53          0.968
LGA    Y    66_A      S      54          1.882
LGA    W    67_A      G      55          2.272
LGA    D    68_A      -       -           -
LGA    S    69_A      -       -           -
LGA    N    70_A      N      56          1.160
LGA    R    71_A      X      57          2.138
LGA    L    72_A      I      58          1.922
LGA    R    73_A      A      59          1.866
LGA    P    74_A      Y      60          1.526
LGA    L    75_A      D      61          0.654
LGA    E    76_A      Y      62          3.545
LGA    R    77_A      -       -           -
LGA    P    78_A      -       -           -
LGA    A    79_A      -       -           -
LGA    L    80_A      -       -           -
LGA    R    81_A      -       -           -
LGA    K    82_A      -       -           -
LGA    E    83_A      -       -           -
LGA    G    84_A      -       -           -
LGA    L    85_A      -       -           -
LGA    K    86_A      -       -           -
LGA    D    87_A      -       -           -
LGA    E    88_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   88   62    5.0     55    1.87    12.73     79.938     2.793

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.554930 * X  +  -0.063398 * Y  +  -0.829478 * Z  +  39.449112
  Y_new =   0.801881 * X  +   0.306188 * Y  +   0.513065 * Z  +  70.588737
  Z_new =   0.221449 * X  +  -0.949858 * Y  +   0.220751 * Z  +   1.436913 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.342446    1.799147  [ DEG:   -76.9165    103.0835 ]
  Theta =  -0.223300   -2.918293  [ DEG:   -12.7941   -167.2059 ]
  Phi   =   0.965436   -2.176157  [ DEG:    55.3154   -124.6846 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eqm_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eqm_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   88   62   5.0   55   1.87   12.73  79.938
REMARK  ---------------------------------------------------------- 
MOLECULE 2eqm_A
HEADER    TRANSCRIPTION                           30-MAR-07   2EQM              
TITLE     SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD FINGER                  
TITLE    2 PROTEIN 20-LIKE 1 [HOMO SAPIENS]                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHD FINGER PROTEIN 20-LIKE 1;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: TUDOR DOMAIN;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: PHF20L1;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060911-19;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, TUDOR DOMAIN,PHD FINGER PROTEIN 20-LIKE 1, HOMO                  
KEYWDS   2 SAPIENS, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON            
KEYWDS   3 PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                    
KEYWDS   4 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,                     
KEYWDS   5 TRANSCRIPTION                                                        
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TARADA,                   
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   02-OCT-07 2EQM    0                                                
JRNL        AUTH   W.DANG,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TARADA,          
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE TUDOR DOMAIN OF PHD                
JRNL        TITL 2 FINGER PROTEIN 20-LIKE 1 [HOMO SAPIENS]                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EQM A    8    88  UNP    Q96BT0   Q96BT0_HUMAN     1     81             
SEQRES   1 A   88  GLY SER SER GLY SER SER GLY MET SER LYS LYS PRO PRO          
SEQRES   2 A   88  ASN ARG PRO GLY ILE THR PHE GLU ILE GLY ALA ARG LEU          
SEQRES   3 A   88  GLU ALA LEU ASP TYR LEU GLN LYS TRP TYR PRO SER ARG          
SEQRES   4 A   88  ILE GLU LYS ILE ASP TYR GLU GLU GLY LYS MET LEU VAL          
SEQRES   5 A   88  HIS PHE GLU ARG TRP SER HIS ARG TYR ASP GLU TRP ILE          
SEQRES   6 A   88  TYR TRP ASP SER ASN ARG LEU ARG PRO LEU GLU ARG PRO          
SEQRES   7 A   88  ALA LEU ARG LYS GLU GLY LEU LYS ASP GLU                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      10.792  73.022  -2.597  1.00  0.00           N  
ATOM      2  CA  GLY A   1      12.238  72.977  -2.709  1.00  0.00           C  
ATOM      3  C   GLY A   1      12.833  74.320  -3.084  1.00  0.00           C  
ATOM      4  O   GLY A   1      12.121  75.216  -3.537  1.00  0.00           O  
ATOM      5  H1  GLY A   1      10.351  73.845  -2.302  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      12.653  72.663  -1.762  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      12.507  72.254  -3.465  1.00  0.00           H  
ATOM      8  N   SER A   2      14.141  74.460  -2.893  1.00  0.00           N  
ATOM      9  CA  SER A   2      14.829  75.706  -3.210  1.00  0.00           C  
ATOM     10  C   SER A   2      16.252  75.433  -3.692  1.00  0.00           C  
ATOM     11  O   SER A   2      17.035  74.775  -3.007  1.00  0.00           O  
ATOM     12  CB  SER A   2      14.861  76.621  -1.985  1.00  0.00           C  
ATOM     13  OG  SER A   2      15.316  77.919  -2.330  1.00  0.00           O  
ATOM     14  H   SER A   2      14.654  73.709  -2.530  1.00  0.00           H  
ATOM     15  HA  SER A   2      14.282  76.196  -4.001  1.00  0.00           H  
ATOM     16  HB2 SER A   2      13.867  76.700  -1.572  1.00  0.00           H  
ATOM     17  HB3 SER A   2      15.528  76.203  -1.244  1.00  0.00           H  
ATOM     18  HG  SER A   2      15.135  78.086  -3.257  1.00  0.00           H  
ATOM     19  N   SER A   3      16.577  75.944  -4.875  1.00  0.00           N  
ATOM     20  CA  SER A   3      17.903  75.753  -5.451  1.00  0.00           C  
ATOM     21  C   SER A   3      18.683  77.063  -5.465  1.00  0.00           C  
ATOM     22  O   SER A   3      18.126  78.128  -5.730  1.00  0.00           O  
ATOM     23  CB  SER A   3      17.789  75.199  -6.873  1.00  0.00           C  
ATOM     24  OG  SER A   3      17.161  76.133  -7.736  1.00  0.00           O  
ATOM     25  H   SER A   3      15.909  76.459  -5.373  1.00  0.00           H  
ATOM     26  HA  SER A   3      18.431  75.039  -4.838  1.00  0.00           H  
ATOM     27  HB2 SER A   3      18.776  74.984  -7.253  1.00  0.00           H  
ATOM     28  HB3 SER A   3      17.203  74.291  -6.857  1.00  0.00           H  
ATOM     29  HG  SER A   3      17.261  75.845  -8.646  1.00  0.00           H  
ATOM     30  N   GLY A   4      19.978  76.977  -5.176  1.00  0.00           N  
ATOM     31  CA  GLY A   4      20.816  78.162  -5.161  1.00  0.00           C  
ATOM     32  C   GLY A   4      22.022  78.033  -6.069  1.00  0.00           C  
ATOM     33  O   GLY A   4      21.883  77.974  -7.291  1.00  0.00           O  
ATOM     34  H   GLY A   4      20.368  76.101  -4.973  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      20.227  79.009  -5.479  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      21.157  78.334  -4.150  1.00  0.00           H  
ATOM     37  N   SER A   5      23.208  77.990  -5.473  1.00  0.00           N  
ATOM     38  CA  SER A   5      24.445  77.871  -6.237  1.00  0.00           C  
ATOM     39  C   SER A   5      24.409  78.768  -7.471  1.00  0.00           C  
ATOM     40  O   SER A   5      24.804  78.359  -8.562  1.00  0.00           O  
ATOM     41  CB  SER A   5      24.674  76.418  -6.656  1.00  0.00           C  
ATOM     42  OG  SER A   5      24.747  75.567  -5.526  1.00  0.00           O  
ATOM     43  H   SER A   5      23.254  78.041  -4.495  1.00  0.00           H  
ATOM     44  HA  SER A   5      25.259  78.186  -5.601  1.00  0.00           H  
ATOM     45  HB2 SER A   5      23.857  76.094  -7.283  1.00  0.00           H  
ATOM     46  HB3 SER A   5      25.601  76.346  -7.207  1.00  0.00           H  
ATOM     47  HG  SER A   5      23.868  75.252  -5.304  1.00  0.00           H  
ATOM     48  N   SER A   6      23.930  79.996  -7.288  1.00  0.00           N  
ATOM     49  CA  SER A   6      23.838  80.951  -8.386  1.00  0.00           C  
ATOM     50  C   SER A   6      24.813  82.107  -8.183  1.00  0.00           C  
ATOM     51  O   SER A   6      25.373  82.637  -9.141  1.00  0.00           O  
ATOM     52  CB  SER A   6      22.410  81.487  -8.505  1.00  0.00           C  
ATOM     53  OG  SER A   6      22.267  82.310  -9.650  1.00  0.00           O  
ATOM     54  H   SER A   6      23.631  80.264  -6.394  1.00  0.00           H  
ATOM     55  HA  SER A   6      24.097  80.434  -9.298  1.00  0.00           H  
ATOM     56  HB2 SER A   6      21.723  80.659  -8.584  1.00  0.00           H  
ATOM     57  HB3 SER A   6      22.173  82.069  -7.626  1.00  0.00           H  
ATOM     58  HG  SER A   6      21.345  82.338  -9.911  1.00  0.00           H  
ATOM     59  N   GLY A   7      25.009  82.494  -6.926  1.00  0.00           N  
ATOM     60  CA  GLY A   7      25.914  83.586  -6.618  1.00  0.00           C  
ATOM     61  C   GLY A   7      27.367  83.212  -6.838  1.00  0.00           C  
ATOM     62  O   GLY A   7      28.072  82.855  -5.895  1.00  0.00           O  
ATOM     63  H   GLY A   7      24.534  82.035  -6.202  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      25.671  84.429  -7.247  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      25.780  83.869  -5.584  1.00  0.00           H  
ATOM     66  N   MET A   8      27.815  83.293  -8.086  1.00  0.00           N  
ATOM     67  CA  MET A   8      29.194  82.961  -8.426  1.00  0.00           C  
ATOM     68  C   MET A   8      29.631  81.676  -7.728  1.00  0.00           C  
ATOM     69  O   MET A   8      30.668  81.641  -7.065  1.00  0.00           O  
ATOM     70  CB  MET A   8      30.128  84.108  -8.039  1.00  0.00           C  
ATOM     71  CG  MET A   8      29.963  85.346  -8.907  1.00  0.00           C  
ATOM     72  SD  MET A   8      30.759  85.178 -10.515  1.00  0.00           S  
ATOM     73  CE  MET A   8      29.366  84.706 -11.536  1.00  0.00           C  
ATOM     74  H   MET A   8      27.205  83.585  -8.796  1.00  0.00           H  
ATOM     75  HA  MET A   8      29.244  82.812  -9.494  1.00  0.00           H  
ATOM     76  HB2 MET A   8      29.934  84.386  -7.014  1.00  0.00           H  
ATOM     77  HB3 MET A   8      31.150  83.770  -8.124  1.00  0.00           H  
ATOM     78  HG2 MET A   8      28.909  85.523  -9.060  1.00  0.00           H  
ATOM     79  HG3 MET A   8      30.396  86.190  -8.391  1.00  0.00           H  
ATOM     80  HE1 MET A   8      29.693  84.004 -12.290  1.00  0.00           H  
ATOM     81  HE2 MET A   8      28.608  84.245 -10.920  1.00  0.00           H  
ATOM     82  HE3 MET A   8      28.957  85.584 -12.014  1.00  0.00           H  
ATOM     83  N   SER A   9      28.834  80.623  -7.883  1.00  0.00           N  
ATOM     84  CA  SER A   9      29.137  79.339  -7.265  1.00  0.00           C  
ATOM     85  C   SER A   9      30.640  79.072  -7.274  1.00  0.00           C  
ATOM     86  O   SER A   9      31.216  78.666  -6.264  1.00  0.00           O  
ATOM     87  CB  SER A   9      28.403  78.212  -7.993  1.00  0.00           C  
ATOM     88  OG  SER A   9      28.650  78.262  -9.388  1.00  0.00           O  
ATOM     89  H   SER A   9      28.022  80.715  -8.424  1.00  0.00           H  
ATOM     90  HA  SER A   9      28.797  79.375  -6.240  1.00  0.00           H  
ATOM     91  HB2 SER A   9      28.742  77.260  -7.614  1.00  0.00           H  
ATOM     92  HB3 SER A   9      27.340  78.310  -7.824  1.00  0.00           H  
ATOM     93  HG  SER A   9      28.209  79.027  -9.764  1.00  0.00           H  
ATOM     94  N   LYS A  10      31.268  79.303  -8.421  1.00  0.00           N  
ATOM     95  CA  LYS A  10      32.702  79.090  -8.565  1.00  0.00           C  
ATOM     96  C   LYS A  10      33.435  79.429  -7.270  1.00  0.00           C  
ATOM     97  O   LYS A  10      33.869  78.538  -6.538  1.00  0.00           O  
ATOM     98  CB  LYS A  10      33.254  79.940  -9.712  1.00  0.00           C  
ATOM     99  CG  LYS A  10      32.577  79.674 -11.046  1.00  0.00           C  
ATOM    100  CD  LYS A  10      32.902  78.285 -11.569  1.00  0.00           C  
ATOM    101  CE  LYS A  10      31.841  77.792 -12.541  1.00  0.00           C  
ATOM    102  NZ  LYS A  10      32.091  78.278 -13.927  1.00  0.00           N  
ATOM    103  H   LYS A  10      30.753  79.627  -9.191  1.00  0.00           H  
ATOM    104  HA  LYS A  10      32.862  78.047  -8.792  1.00  0.00           H  
ATOM    105  HB2 LYS A  10      33.121  80.983  -9.467  1.00  0.00           H  
ATOM    106  HB3 LYS A  10      34.309  79.737  -9.821  1.00  0.00           H  
ATOM    107  HG2 LYS A  10      31.507  79.758 -10.920  1.00  0.00           H  
ATOM    108  HG3 LYS A  10      32.915  80.407 -11.764  1.00  0.00           H  
ATOM    109  HD2 LYS A  10      33.854  78.315 -12.076  1.00  0.00           H  
ATOM    110  HD3 LYS A  10      32.959  77.600 -10.734  1.00  0.00           H  
ATOM    111  HE2 LYS A  10      31.844  76.714 -12.540  1.00  0.00           H  
ATOM    112  HE3 LYS A  10      30.877  78.150 -12.212  1.00  0.00           H  
ATOM    113  HZ1 LYS A  10      32.805  79.034 -13.917  1.00  0.00           H  
ATOM    114  HZ2 LYS A  10      31.211  78.651 -14.338  1.00  0.00           H  
ATOM    115  HZ3 LYS A  10      32.435  77.498 -14.521  1.00  0.00           H  
ATOM    116  N   LYS A  11      33.569  80.721  -6.993  1.00  0.00           N  
ATOM    117  CA  LYS A  11      34.247  81.178  -5.785  1.00  0.00           C  
ATOM    118  C   LYS A  11      33.597  80.584  -4.538  1.00  0.00           C  
ATOM    119  O   LYS A  11      32.423  80.216  -4.537  1.00  0.00           O  
ATOM    120  CB  LYS A  11      34.220  82.707  -5.707  1.00  0.00           C  
ATOM    121  CG  LYS A  11      32.999  83.257  -4.991  1.00  0.00           C  
ATOM    122  CD  LYS A  11      32.915  84.769  -5.116  1.00  0.00           C  
ATOM    123  CE  LYS A  11      33.674  85.465  -3.998  1.00  0.00           C  
ATOM    124  NZ  LYS A  11      33.721  86.941  -4.193  1.00  0.00           N  
ATOM    125  H   LYS A  11      33.203  81.384  -7.614  1.00  0.00           H  
ATOM    126  HA  LYS A  11      35.273  80.847  -5.834  1.00  0.00           H  
ATOM    127  HB2 LYS A  11      35.102  83.044  -5.184  1.00  0.00           H  
ATOM    128  HB3 LYS A  11      34.231  83.105  -6.711  1.00  0.00           H  
ATOM    129  HG2 LYS A  11      32.112  82.821  -5.422  1.00  0.00           H  
ATOM    130  HG3 LYS A  11      33.059  82.995  -3.944  1.00  0.00           H  
ATOM    131  HD2 LYS A  11      33.339  85.068  -6.063  1.00  0.00           H  
ATOM    132  HD3 LYS A  11      31.876  85.068  -5.075  1.00  0.00           H  
ATOM    133  HE2 LYS A  11      33.184  85.251  -3.060  1.00  0.00           H  
ATOM    134  HE3 LYS A  11      34.683  85.081  -3.972  1.00  0.00           H  
ATOM    135  HZ1 LYS A  11      33.713  87.424  -3.273  1.00  0.00           H  
ATOM    136  HZ2 LYS A  11      32.898  87.254  -4.746  1.00  0.00           H  
ATOM    137  HZ3 LYS A  11      34.588  87.206  -4.705  1.00  0.00           H  
ATOM    138  N   PRO A  12      34.378  80.489  -3.451  1.00  0.00           N  
ATOM    139  CA  PRO A  12      33.898  79.942  -2.179  1.00  0.00           C  
ATOM    140  C   PRO A  12      32.892  80.861  -1.496  1.00  0.00           C  
ATOM    141  O   PRO A  12      33.230  81.941  -1.012  1.00  0.00           O  
ATOM    142  CB  PRO A  12      35.173  79.828  -1.339  1.00  0.00           C  
ATOM    143  CG  PRO A  12      36.096  80.849  -1.912  1.00  0.00           C  
ATOM    144  CD  PRO A  12      35.788  80.908  -3.382  1.00  0.00           C  
ATOM    145  HA  PRO A  12      33.461  78.963  -2.307  1.00  0.00           H  
ATOM    146  HB2 PRO A  12      34.945  80.036  -0.304  1.00  0.00           H  
ATOM    147  HB3 PRO A  12      35.581  78.832  -1.431  1.00  0.00           H  
ATOM    148  HG2 PRO A  12      35.914  81.808  -1.451  1.00  0.00           H  
ATOM    149  HG3 PRO A  12      37.120  80.545  -1.756  1.00  0.00           H  
ATOM    150  HD2 PRO A  12      35.909  81.915  -3.753  1.00  0.00           H  
ATOM    151  HD3 PRO A  12      36.420  80.224  -3.928  1.00  0.00           H  
ATOM    152  N   PRO A  13      31.624  80.424  -1.454  1.00  0.00           N  
ATOM    153  CA  PRO A  13      30.542  81.193  -0.831  1.00  0.00           C  
ATOM    154  C   PRO A  13      30.674  81.254   0.686  1.00  0.00           C  
ATOM    155  O   PRO A  13      31.510  80.570   1.274  1.00  0.00           O  
ATOM    156  CB  PRO A  13      29.283  80.418  -1.229  1.00  0.00           C  
ATOM    157  CG  PRO A  13      29.754  79.025  -1.465  1.00  0.00           C  
ATOM    158  CD  PRO A  13      31.149  79.147  -2.011  1.00  0.00           C  
ATOM    159  HA  PRO A  13      30.489  82.196  -1.228  1.00  0.00           H  
ATOM    160  HB2 PRO A  13      28.562  80.461  -0.423  1.00  0.00           H  
ATOM    161  HB3 PRO A  13      28.858  80.848  -2.123  1.00  0.00           H  
ATOM    162  HG2 PRO A  13      29.762  78.477  -0.535  1.00  0.00           H  
ATOM    163  HG3 PRO A  13      29.111  78.537  -2.183  1.00  0.00           H  
ATOM    164  HD2 PRO A  13      31.762  78.326  -1.671  1.00  0.00           H  
ATOM    165  HD3 PRO A  13      31.130  79.181  -3.091  1.00  0.00           H  
ATOM    166  N   ASN A  14      29.841  82.077   1.315  1.00  0.00           N  
ATOM    167  CA  ASN A  14      29.865  82.227   2.766  1.00  0.00           C  
ATOM    168  C   ASN A  14      29.852  80.866   3.454  1.00  0.00           C  
ATOM    169  O   ASN A  14      28.800  80.242   3.598  1.00  0.00           O  
ATOM    170  CB  ASN A  14      28.669  83.059   3.233  1.00  0.00           C  
ATOM    171  CG  ASN A  14      28.612  83.192   4.743  1.00  0.00           C  
ATOM    172  OD1 ASN A  14      27.972  82.391   5.424  1.00  0.00           O  
ATOM    173  ND2 ASN A  14      29.283  84.208   5.272  1.00  0.00           N  
ATOM    174  H   ASN A  14      29.195  82.597   0.792  1.00  0.00           H  
ATOM    175  HA  ASN A  14      30.776  82.743   3.030  1.00  0.00           H  
ATOM    176  HB2 ASN A  14      28.738  84.049   2.806  1.00  0.00           H  
ATOM    177  HB3 ASN A  14      27.758  82.589   2.897  1.00  0.00           H  
ATOM    178 HD21 ASN A  14      29.770  84.807   4.668  1.00  0.00           H  
ATOM    179 HD22 ASN A  14      29.264  84.318   6.246  1.00  0.00           H  
ATOM    180  N   ARG A  15      31.027  80.411   3.877  1.00  0.00           N  
ATOM    181  CA  ARG A  15      31.151  79.123   4.549  1.00  0.00           C  
ATOM    182  C   ARG A  15      32.045  79.237   5.781  1.00  0.00           C  
ATOM    183  O   ARG A  15      33.272  79.248   5.689  1.00  0.00           O  
ATOM    184  CB  ARG A  15      31.717  78.076   3.590  1.00  0.00           C  
ATOM    185  CG  ARG A  15      31.264  76.658   3.900  1.00  0.00           C  
ATOM    186  CD  ARG A  15      31.175  75.813   2.638  1.00  0.00           C  
ATOM    187  NE  ARG A  15      29.937  76.055   1.904  1.00  0.00           N  
ATOM    188  CZ  ARG A  15      29.747  75.690   0.641  1.00  0.00           C  
ATOM    189  NH1 ARG A  15      30.711  75.069  -0.025  1.00  0.00           N  
ATOM    190  NH2 ARG A  15      28.591  75.944   0.041  1.00  0.00           N  
ATOM    191  H   ARG A  15      31.830  80.954   3.733  1.00  0.00           H  
ATOM    192  HA  ARG A  15      30.164  78.816   4.862  1.00  0.00           H  
ATOM    193  HB2 ARG A  15      31.405  78.318   2.585  1.00  0.00           H  
ATOM    194  HB3 ARG A  15      32.795  78.104   3.640  1.00  0.00           H  
ATOM    195  HG2 ARG A  15      31.973  76.203   4.575  1.00  0.00           H  
ATOM    196  HG3 ARG A  15      30.292  76.695   4.367  1.00  0.00           H  
ATOM    197  HD2 ARG A  15      32.013  76.055   2.000  1.00  0.00           H  
ATOM    198  HD3 ARG A  15      31.221  74.771   2.915  1.00  0.00           H  
ATOM    199  HE  ARG A  15      29.210  76.512   2.377  1.00  0.00           H  
ATOM    200 HH11 ARG A  15      31.583  74.874   0.425  1.00  0.00           H  
ATOM    201 HH12 ARG A  15      30.566  74.793  -0.975  1.00  0.00           H  
ATOM    202 HH21 ARG A  15      27.861  76.411   0.539  1.00  0.00           H  
ATOM    203 HH22 ARG A  15      28.450  75.668  -0.909  1.00  0.00           H  
ATOM    204  N   PRO A  16      31.415  79.325   6.962  1.00  0.00           N  
ATOM    205  CA  PRO A  16      32.135  79.440   8.236  1.00  0.00           C  
ATOM    206  C   PRO A  16      32.863  78.152   8.608  1.00  0.00           C  
ATOM    207  O   PRO A  16      32.377  77.367   9.421  1.00  0.00           O  
ATOM    208  CB  PRO A  16      31.023  79.737   9.245  1.00  0.00           C  
ATOM    209  CG  PRO A  16      29.792  79.161   8.634  1.00  0.00           C  
ATOM    210  CD  PRO A  16      29.955  79.319   7.147  1.00  0.00           C  
ATOM    211  HA  PRO A  16      32.838  80.259   8.221  1.00  0.00           H  
ATOM    212  HB2 PRO A  16      31.255  79.265  10.189  1.00  0.00           H  
ATOM    213  HB3 PRO A  16      30.933  80.804   9.383  1.00  0.00           H  
ATOM    214  HG2 PRO A  16      29.708  78.116   8.893  1.00  0.00           H  
ATOM    215  HG3 PRO A  16      28.924  79.705   8.976  1.00  0.00           H  
ATOM    216  HD2 PRO A  16      29.503  78.487   6.628  1.00  0.00           H  
ATOM    217  HD3 PRO A  16      29.521  80.252   6.818  1.00  0.00           H  
ATOM    218  N   GLY A  17      34.030  77.943   8.007  1.00  0.00           N  
ATOM    219  CA  GLY A  17      34.806  76.750   8.289  1.00  0.00           C  
ATOM    220  C   GLY A  17      35.666  76.325   7.115  1.00  0.00           C  
ATOM    221  O   GLY A  17      36.894  76.340   7.200  1.00  0.00           O  
ATOM    222  H   GLY A  17      34.367  78.605   7.367  1.00  0.00           H  
ATOM    223  HA2 GLY A  17      35.444  76.941   9.139  1.00  0.00           H  
ATOM    224  HA3 GLY A  17      34.129  75.944   8.535  1.00  0.00           H  
ATOM    225  N   ILE A  18      35.019  75.947   6.017  1.00  0.00           N  
ATOM    226  CA  ILE A  18      35.734  75.517   4.822  1.00  0.00           C  
ATOM    227  C   ILE A  18      36.135  76.710   3.962  1.00  0.00           C  
ATOM    228  O   ILE A  18      35.402  77.695   3.864  1.00  0.00           O  
ATOM    229  CB  ILE A  18      34.883  74.552   3.975  1.00  0.00           C  
ATOM    230  CG1 ILE A  18      34.100  73.599   4.880  1.00  0.00           C  
ATOM    231  CG2 ILE A  18      35.767  73.771   3.014  1.00  0.00           C  
ATOM    232  CD1 ILE A  18      33.350  72.526   4.122  1.00  0.00           C  
ATOM    233  H   ILE A  18      34.040  75.958   6.011  1.00  0.00           H  
ATOM    234  HA  ILE A  18      36.627  74.997   5.137  1.00  0.00           H  
ATOM    235  HB  ILE A  18      34.188  75.136   3.392  1.00  0.00           H  
ATOM    236 HG12 ILE A  18      34.784  73.110   5.555  1.00  0.00           H  
ATOM    237 HG13 ILE A  18      33.381  74.167   5.452  1.00  0.00           H  
ATOM    238 HG21 ILE A  18      36.285  74.460   2.362  1.00  0.00           H  
ATOM    239 HG22 ILE A  18      36.488  73.196   3.574  1.00  0.00           H  
ATOM    240 HG23 ILE A  18      35.156  73.106   2.422  1.00  0.00           H  
ATOM    241 HD11 ILE A  18      32.956  72.941   3.206  1.00  0.00           H  
ATOM    242 HD12 ILE A  18      34.021  71.713   3.890  1.00  0.00           H  
ATOM    243 HD13 ILE A  18      32.535  72.160   4.729  1.00  0.00           H  
ATOM    244  N   THR A  19      37.306  76.616   3.339  1.00  0.00           N  
ATOM    245  CA  THR A  19      37.806  77.688   2.486  1.00  0.00           C  
ATOM    246  C   THR A  19      38.593  77.129   1.305  1.00  0.00           C  
ATOM    247  O   THR A  19      39.709  76.637   1.468  1.00  0.00           O  
ATOM    248  CB  THR A  19      38.705  78.659   3.273  1.00  0.00           C  
ATOM    249  OG1 THR A  19      37.941  79.322   4.286  1.00  0.00           O  
ATOM    250  CG2 THR A  19      39.330  79.691   2.346  1.00  0.00           C  
ATOM    251  H   THR A  19      37.845  75.807   3.455  1.00  0.00           H  
ATOM    252  HA  THR A  19      36.956  78.240   2.111  1.00  0.00           H  
ATOM    253  HB  THR A  19      39.496  78.093   3.743  1.00  0.00           H  
ATOM    254  HG1 THR A  19      37.205  78.764   4.549  1.00  0.00           H  
ATOM    255 HG21 THR A  19      40.132  79.233   1.788  1.00  0.00           H  
ATOM    256 HG22 THR A  19      39.721  80.511   2.931  1.00  0.00           H  
ATOM    257 HG23 THR A  19      38.580  80.060   1.662  1.00  0.00           H  
ATOM    258  N   PHE A  20      38.004  77.209   0.117  1.00  0.00           N  
ATOM    259  CA  PHE A  20      38.650  76.711  -1.092  1.00  0.00           C  
ATOM    260  C   PHE A  20      39.860  77.566  -1.453  1.00  0.00           C  
ATOM    261  O   PHE A  20      39.719  78.677  -1.962  1.00  0.00           O  
ATOM    262  CB  PHE A  20      37.657  76.693  -2.257  1.00  0.00           C  
ATOM    263  CG  PHE A  20      36.315  76.128  -1.891  1.00  0.00           C  
ATOM    264  CD1 PHE A  20      36.218  75.005  -1.085  1.00  0.00           C  
ATOM    265  CD2 PHE A  20      35.150  76.717  -2.355  1.00  0.00           C  
ATOM    266  CE1 PHE A  20      34.984  74.481  -0.749  1.00  0.00           C  
ATOM    267  CE2 PHE A  20      33.913  76.198  -2.022  1.00  0.00           C  
ATOM    268  CZ  PHE A  20      33.830  75.079  -1.217  1.00  0.00           C  
ATOM    269  H   PHE A  20      37.112  77.612   0.051  1.00  0.00           H  
ATOM    270  HA  PHE A  20      38.982  75.702  -0.898  1.00  0.00           H  
ATOM    271  HB2 PHE A  20      37.506  77.704  -2.606  1.00  0.00           H  
ATOM    272  HB3 PHE A  20      38.065  76.097  -3.058  1.00  0.00           H  
ATOM    273  HD1 PHE A  20      37.119  74.537  -0.716  1.00  0.00           H  
ATOM    274  HD2 PHE A  20      35.214  77.593  -2.986  1.00  0.00           H  
ATOM    275  HE1 PHE A  20      34.922  73.606  -0.118  1.00  0.00           H  
ATOM    276  HE2 PHE A  20      33.013  76.668  -2.389  1.00  0.00           H  
ATOM    277  HZ  PHE A  20      32.865  74.671  -0.956  1.00  0.00           H  
ATOM    278  N   GLU A  21      41.051  77.039  -1.185  1.00  0.00           N  
ATOM    279  CA  GLU A  21      42.287  77.755  -1.480  1.00  0.00           C  
ATOM    280  C   GLU A  21      43.394  76.785  -1.882  1.00  0.00           C  
ATOM    281  O   GLU A  21      43.180  75.575  -1.949  1.00  0.00           O  
ATOM    282  CB  GLU A  21      42.729  78.577  -0.268  1.00  0.00           C  
ATOM    283  CG  GLU A  21      42.161  79.987  -0.248  1.00  0.00           C  
ATOM    284  CD  GLU A  21      43.077  80.974   0.449  1.00  0.00           C  
ATOM    285  OE1 GLU A  21      43.833  80.549   1.347  1.00  0.00           O  
ATOM    286  OE2 GLU A  21      43.036  82.172   0.097  1.00  0.00           O  
ATOM    287  H   GLU A  21      41.099  76.149  -0.778  1.00  0.00           H  
ATOM    288  HA  GLU A  21      42.093  78.423  -2.306  1.00  0.00           H  
ATOM    289  HB2 GLU A  21      42.410  78.070   0.632  1.00  0.00           H  
ATOM    290  HB3 GLU A  21      43.806  78.645  -0.268  1.00  0.00           H  
ATOM    291  HG2 GLU A  21      42.013  80.315  -1.266  1.00  0.00           H  
ATOM    292  HG3 GLU A  21      41.211  79.972   0.267  1.00  0.00           H  
ATOM    293  N   ILE A  22      44.578  77.327  -2.149  1.00  0.00           N  
ATOM    294  CA  ILE A  22      45.720  76.510  -2.543  1.00  0.00           C  
ATOM    295  C   ILE A  22      46.535  76.082  -1.328  1.00  0.00           C  
ATOM    296  O   ILE A  22      47.202  76.900  -0.695  1.00  0.00           O  
ATOM    297  CB  ILE A  22      46.638  77.263  -3.525  1.00  0.00           C  
ATOM    298  CG1 ILE A  22      45.896  77.551  -4.831  1.00  0.00           C  
ATOM    299  CG2 ILE A  22      47.899  76.456  -3.793  1.00  0.00           C  
ATOM    300  CD1 ILE A  22      45.197  76.341  -5.410  1.00  0.00           C  
ATOM    301  H   ILE A  22      44.687  78.298  -2.078  1.00  0.00           H  
ATOM    302  HA  ILE A  22      45.342  75.627  -3.039  1.00  0.00           H  
ATOM    303  HB  ILE A  22      46.926  78.197  -3.069  1.00  0.00           H  
ATOM    304 HG12 ILE A  22      45.150  78.311  -4.655  1.00  0.00           H  
ATOM    305 HG13 ILE A  22      46.602  77.910  -5.566  1.00  0.00           H  
ATOM    306 HG21 ILE A  22      48.036  76.344  -4.859  1.00  0.00           H  
ATOM    307 HG22 ILE A  22      48.751  76.972  -3.376  1.00  0.00           H  
ATOM    308 HG23 ILE A  22      47.809  75.483  -3.337  1.00  0.00           H  
ATOM    309 HD11 ILE A  22      44.380  76.055  -4.763  1.00  0.00           H  
ATOM    310 HD12 ILE A  22      44.811  76.581  -6.390  1.00  0.00           H  
ATOM    311 HD13 ILE A  22      45.896  75.523  -5.487  1.00  0.00           H  
ATOM    312  N   GLY A  23      46.480  74.792  -1.008  1.00  0.00           N  
ATOM    313  CA  GLY A  23      47.219  74.277   0.129  1.00  0.00           C  
ATOM    314  C   GLY A  23      46.363  74.165   1.375  1.00  0.00           C  
ATOM    315  O   GLY A  23      46.813  73.657   2.401  1.00  0.00           O  
ATOM    316  H   GLY A  23      45.931  74.187  -1.549  1.00  0.00           H  
ATOM    317  HA2 GLY A  23      47.605  73.300  -0.120  1.00  0.00           H  
ATOM    318  HA3 GLY A  23      48.048  74.939   0.334  1.00  0.00           H  
ATOM    319  N   ALA A  24      45.126  74.643   1.286  1.00  0.00           N  
ATOM    320  CA  ALA A  24      44.205  74.594   2.415  1.00  0.00           C  
ATOM    321  C   ALA A  24      44.006  73.162   2.899  1.00  0.00           C  
ATOM    322  O   ALA A  24      43.957  72.227   2.099  1.00  0.00           O  
ATOM    323  CB  ALA A  24      42.869  75.214   2.033  1.00  0.00           C  
ATOM    324  H   ALA A  24      44.826  75.037   0.440  1.00  0.00           H  
ATOM    325  HA  ALA A  24      44.630  75.179   3.217  1.00  0.00           H  
ATOM    326  HB1 ALA A  24      43.007  76.264   1.823  1.00  0.00           H  
ATOM    327  HB2 ALA A  24      42.481  74.719   1.154  1.00  0.00           H  
ATOM    328  HB3 ALA A  24      42.173  75.099   2.850  1.00  0.00           H  
ATOM    329  N   ARG A  25      43.893  72.997   4.213  1.00  0.00           N  
ATOM    330  CA  ARG A  25      43.702  71.678   4.804  1.00  0.00           C  
ATOM    331  C   ARG A  25      42.245  71.468   5.205  1.00  0.00           C  
ATOM    332  O   ARG A  25      41.714  72.186   6.053  1.00  0.00           O  
ATOM    333  CB  ARG A  25      44.609  71.505   6.023  1.00  0.00           C  
ATOM    334  CG  ARG A  25      46.077  71.773   5.735  1.00  0.00           C  
ATOM    335  CD  ARG A  25      46.832  72.155   6.997  1.00  0.00           C  
ATOM    336  NE  ARG A  25      48.185  72.622   6.706  1.00  0.00           N  
ATOM    337  CZ  ARG A  25      48.974  73.200   7.606  1.00  0.00           C  
ATOM    338  NH1 ARG A  25      48.545  73.380   8.847  1.00  0.00           N  
ATOM    339  NH2 ARG A  25      50.192  73.597   7.263  1.00  0.00           N  
ATOM    340  H   ARG A  25      43.941  73.780   4.799  1.00  0.00           H  
ATOM    341  HA  ARG A  25      43.968  70.940   4.061  1.00  0.00           H  
ATOM    342  HB2 ARG A  25      44.287  72.188   6.796  1.00  0.00           H  
ATOM    343  HB3 ARG A  25      44.514  70.493   6.387  1.00  0.00           H  
ATOM    344  HG2 ARG A  25      46.520  70.880   5.318  1.00  0.00           H  
ATOM    345  HG3 ARG A  25      46.152  72.580   5.021  1.00  0.00           H  
ATOM    346  HD2 ARG A  25      46.291  72.943   7.500  1.00  0.00           H  
ATOM    347  HD3 ARG A  25      46.891  71.290   7.641  1.00  0.00           H  
ATOM    348  HE  ARG A  25      48.521  72.498   5.794  1.00  0.00           H  
ATOM    349 HH11 ARG A  25      47.628  73.081   9.108  1.00  0.00           H  
ATOM    350 HH12 ARG A  25      49.142  73.814   9.523  1.00  0.00           H  
ATOM    351 HH21 ARG A  25      50.518  73.463   6.328  1.00  0.00           H  
ATOM    352 HH22 ARG A  25      50.785  74.032   7.941  1.00  0.00           H  
ATOM    353  N   LEU A  26      41.604  70.480   4.589  1.00  0.00           N  
ATOM    354  CA  LEU A  26      40.207  70.176   4.882  1.00  0.00           C  
ATOM    355  C   LEU A  26      39.930  68.685   4.723  1.00  0.00           C  
ATOM    356  O   LEU A  26      40.840  67.900   4.459  1.00  0.00           O  
ATOM    357  CB  LEU A  26      39.286  70.979   3.961  1.00  0.00           C  
ATOM    358  CG  LEU A  26      39.531  70.817   2.461  1.00  0.00           C  
ATOM    359  CD1 LEU A  26      40.827  71.502   2.054  1.00  0.00           C  
ATOM    360  CD2 LEU A  26      39.562  69.344   2.081  1.00  0.00           C  
ATOM    361  H   LEU A  26      42.079  69.943   3.923  1.00  0.00           H  
ATOM    362  HA  LEU A  26      40.014  70.459   5.906  1.00  0.00           H  
ATOM    363  HB2 LEU A  26      38.270  70.676   4.165  1.00  0.00           H  
ATOM    364  HB3 LEU A  26      39.405  72.025   4.206  1.00  0.00           H  
ATOM    365  HG  LEU A  26      38.721  71.285   1.917  1.00  0.00           H  
ATOM    366 HD11 LEU A  26      41.269  71.976   2.917  1.00  0.00           H  
ATOM    367 HD12 LEU A  26      40.618  72.247   1.301  1.00  0.00           H  
ATOM    368 HD13 LEU A  26      41.511  70.768   1.655  1.00  0.00           H  
ATOM    369 HD21 LEU A  26      39.386  69.241   1.020  1.00  0.00           H  
ATOM    370 HD22 LEU A  26      38.794  68.815   2.627  1.00  0.00           H  
ATOM    371 HD23 LEU A  26      40.529  68.928   2.328  1.00  0.00           H  
ATOM    372  N   GLU A  27      38.668  68.302   4.884  1.00  0.00           N  
ATOM    373  CA  GLU A  27      38.271  66.904   4.757  1.00  0.00           C  
ATOM    374  C   GLU A  27      37.391  66.698   3.528  1.00  0.00           C  
ATOM    375  O   GLU A  27      36.728  67.626   3.064  1.00  0.00           O  
ATOM    376  CB  GLU A  27      37.528  66.445   6.014  1.00  0.00           C  
ATOM    377  CG  GLU A  27      38.398  66.422   7.260  1.00  0.00           C  
ATOM    378  CD  GLU A  27      37.962  65.364   8.254  1.00  0.00           C  
ATOM    379  OE1 GLU A  27      38.116  64.163   7.951  1.00  0.00           O  
ATOM    380  OE2 GLU A  27      37.467  65.738   9.339  1.00  0.00           O  
ATOM    381  H   GLU A  27      37.987  68.975   5.094  1.00  0.00           H  
ATOM    382  HA  GLU A  27      39.168  66.314   4.645  1.00  0.00           H  
ATOM    383  HB2 GLU A  27      36.698  67.113   6.190  1.00  0.00           H  
ATOM    384  HB3 GLU A  27      37.148  65.449   5.847  1.00  0.00           H  
ATOM    385  HG2 GLU A  27      39.418  66.222   6.968  1.00  0.00           H  
ATOM    386  HG3 GLU A  27      38.344  67.389   7.738  1.00  0.00           H  
ATOM    387  N   ALA A  28      37.388  65.476   3.007  1.00  0.00           N  
ATOM    388  CA  ALA A  28      36.588  65.146   1.834  1.00  0.00           C  
ATOM    389  C   ALA A  28      35.824  63.842   2.038  1.00  0.00           C  
ATOM    390  O   ALA A  28      36.314  62.920   2.692  1.00  0.00           O  
ATOM    391  CB  ALA A  28      37.474  65.054   0.601  1.00  0.00           C  
ATOM    392  H   ALA A  28      37.936  64.778   3.422  1.00  0.00           H  
ATOM    393  HA  ALA A  28      35.879  65.947   1.678  1.00  0.00           H  
ATOM    394  HB1 ALA A  28      37.349  64.085   0.139  1.00  0.00           H  
ATOM    395  HB2 ALA A  28      37.195  65.827  -0.101  1.00  0.00           H  
ATOM    396  HB3 ALA A  28      38.507  65.185   0.888  1.00  0.00           H  
ATOM    397  N   LEU A  29      34.623  63.772   1.476  1.00  0.00           N  
ATOM    398  CA  LEU A  29      33.791  62.579   1.596  1.00  0.00           C  
ATOM    399  C   LEU A  29      34.057  61.612   0.449  1.00  0.00           C  
ATOM    400  O   LEU A  29      33.632  61.845  -0.684  1.00  0.00           O  
ATOM    401  CB  LEU A  29      32.311  62.967   1.621  1.00  0.00           C  
ATOM    402  CG  LEU A  29      31.340  61.882   2.087  1.00  0.00           C  
ATOM    403  CD1 LEU A  29      31.286  61.829   3.605  1.00  0.00           C  
ATOM    404  CD2 LEU A  29      29.954  62.123   1.508  1.00  0.00           C  
ATOM    405  H   LEU A  29      34.287  64.539   0.967  1.00  0.00           H  
ATOM    406  HA  LEU A  29      34.043  62.093   2.527  1.00  0.00           H  
ATOM    407  HB2 LEU A  29      32.203  63.813   2.282  1.00  0.00           H  
ATOM    408  HB3 LEU A  29      32.030  63.258   0.619  1.00  0.00           H  
ATOM    409  HG  LEU A  29      31.689  60.920   1.732  1.00  0.00           H  
ATOM    410 HD11 LEU A  29      32.256  61.559   3.991  1.00  0.00           H  
ATOM    411 HD12 LEU A  29      30.557  61.094   3.914  1.00  0.00           H  
ATOM    412 HD13 LEU A  29      31.003  62.800   3.988  1.00  0.00           H  
ATOM    413 HD21 LEU A  29      30.023  62.821   0.687  1.00  0.00           H  
ATOM    414 HD22 LEU A  29      29.311  62.529   2.275  1.00  0.00           H  
ATOM    415 HD23 LEU A  29      29.544  61.187   1.154  1.00  0.00           H  
ATOM    416  N   ASP A  30      34.758  60.525   0.748  1.00  0.00           N  
ATOM    417  CA  ASP A  30      35.076  59.518  -0.258  1.00  0.00           C  
ATOM    418  C   ASP A  30      33.841  58.699  -0.618  1.00  0.00           C  
ATOM    419  O   ASP A  30      32.851  58.696   0.113  1.00  0.00           O  
ATOM    420  CB  ASP A  30      36.186  58.595   0.247  1.00  0.00           C  
ATOM    421  CG  ASP A  30      35.728  57.709   1.388  1.00  0.00           C  
ATOM    422  OD1 ASP A  30      34.501  57.568   1.575  1.00  0.00           O  
ATOM    423  OD2 ASP A  30      36.597  57.155   2.093  1.00  0.00           O  
ATOM    424  H   ASP A  30      35.068  60.395   1.669  1.00  0.00           H  
ATOM    425  HA  ASP A  30      35.423  60.032  -1.143  1.00  0.00           H  
ATOM    426  HB2 ASP A  30      36.517  57.963  -0.566  1.00  0.00           H  
ATOM    427  HB3 ASP A  30      37.017  59.195   0.590  1.00  0.00           H  
ATOM    428  N   TYR A  31      33.906  58.007  -1.750  1.00  0.00           N  
ATOM    429  CA  TYR A  31      32.792  57.186  -2.209  1.00  0.00           C  
ATOM    430  C   TYR A  31      32.279  56.288  -1.088  1.00  0.00           C  
ATOM    431  O   TYR A  31      31.137  55.824  -1.120  1.00  0.00           O  
ATOM    432  CB  TYR A  31      33.217  56.335  -3.406  1.00  0.00           C  
ATOM    433  CG  TYR A  31      34.519  55.597  -3.193  1.00  0.00           C  
ATOM    434  CD1 TYR A  31      35.739  56.219  -3.431  1.00  0.00           C  
ATOM    435  CD2 TYR A  31      34.530  54.279  -2.753  1.00  0.00           C  
ATOM    436  CE1 TYR A  31      36.932  55.548  -3.238  1.00  0.00           C  
ATOM    437  CE2 TYR A  31      35.718  53.601  -2.556  1.00  0.00           C  
ATOM    438  CZ  TYR A  31      36.916  54.240  -2.800  1.00  0.00           C  
ATOM    439  OH  TYR A  31      38.101  53.568  -2.606  1.00  0.00           O  
ATOM    440  H   TYR A  31      34.722  58.049  -2.291  1.00  0.00           H  
ATOM    441  HA  TYR A  31      31.995  57.849  -2.515  1.00  0.00           H  
ATOM    442  HB2 TYR A  31      32.451  55.603  -3.609  1.00  0.00           H  
ATOM    443  HB3 TYR A  31      33.334  56.973  -4.269  1.00  0.00           H  
ATOM    444  HD1 TYR A  31      35.748  57.242  -3.774  1.00  0.00           H  
ATOM    445  HD2 TYR A  31      33.590  53.781  -2.563  1.00  0.00           H  
ATOM    446  HE1 TYR A  31      37.870  56.047  -3.428  1.00  0.00           H  
ATOM    447  HE2 TYR A  31      35.705  52.578  -2.214  1.00  0.00           H  
ATOM    448  HH  TYR A  31      38.279  53.499  -1.665  1.00  0.00           H  
ATOM    449  N   LEU A  32      33.130  56.045  -0.098  1.00  0.00           N  
ATOM    450  CA  LEU A  32      32.764  55.202   1.036  1.00  0.00           C  
ATOM    451  C   LEU A  32      32.052  56.014   2.112  1.00  0.00           C  
ATOM    452  O   LEU A  32      31.929  55.576   3.255  1.00  0.00           O  
ATOM    453  CB  LEU A  32      34.010  54.536   1.624  1.00  0.00           C  
ATOM    454  CG  LEU A  32      34.857  53.718   0.650  1.00  0.00           C  
ATOM    455  CD1 LEU A  32      36.160  53.288   1.307  1.00  0.00           C  
ATOM    456  CD2 LEU A  32      34.081  52.506   0.156  1.00  0.00           C  
ATOM    457  H   LEU A  32      34.025  56.441  -0.127  1.00  0.00           H  
ATOM    458  HA  LEU A  32      32.093  54.436   0.676  1.00  0.00           H  
ATOM    459  HB2 LEU A  32      34.636  55.313   2.036  1.00  0.00           H  
ATOM    460  HB3 LEU A  32      33.688  53.878   2.419  1.00  0.00           H  
ATOM    461  HG  LEU A  32      35.103  54.331  -0.207  1.00  0.00           H  
ATOM    462 HD11 LEU A  32      36.631  52.523   0.707  1.00  0.00           H  
ATOM    463 HD12 LEU A  32      35.955  52.897   2.291  1.00  0.00           H  
ATOM    464 HD13 LEU A  32      36.820  54.139   1.388  1.00  0.00           H  
ATOM    465 HD21 LEU A  32      34.130  52.461  -0.921  1.00  0.00           H  
ATOM    466 HD22 LEU A  32      33.050  52.588   0.467  1.00  0.00           H  
ATOM    467 HD23 LEU A  32      34.513  51.607   0.575  1.00  0.00           H  
ATOM    468  N   GLN A  33      31.581  57.200   1.737  1.00  0.00           N  
ATOM    469  CA  GLN A  33      30.880  58.073   2.670  1.00  0.00           C  
ATOM    470  C   GLN A  33      31.676  58.245   3.960  1.00  0.00           C  
ATOM    471  O   GLN A  33      31.109  58.488   5.024  1.00  0.00           O  
ATOM    472  CB  GLN A  33      29.493  57.508   2.985  1.00  0.00           C  
ATOM    473  CG  GLN A  33      28.603  57.365   1.761  1.00  0.00           C  
ATOM    474  CD  GLN A  33      27.128  57.447   2.099  1.00  0.00           C  
ATOM    475  OE1 GLN A  33      26.734  58.119   3.055  1.00  0.00           O  
ATOM    476  NE2 GLN A  33      26.301  56.762   1.318  1.00  0.00           N  
ATOM    477  H   GLN A  33      31.711  57.494   0.812  1.00  0.00           H  
ATOM    478  HA  GLN A  33      30.767  59.038   2.200  1.00  0.00           H  
ATOM    479  HB2 GLN A  33      29.608  56.535   3.436  1.00  0.00           H  
ATOM    480  HB3 GLN A  33      29.002  58.166   3.686  1.00  0.00           H  
ATOM    481  HG2 GLN A  33      28.840  58.156   1.064  1.00  0.00           H  
ATOM    482  HG3 GLN A  33      28.799  56.409   1.299  1.00  0.00           H  
ATOM    483 HE21 GLN A  33      26.686  56.249   0.576  1.00  0.00           H  
ATOM    484 HE22 GLN A  33      25.343  56.797   1.514  1.00  0.00           H  
ATOM    485  N   LYS A  34      32.995  58.115   3.856  1.00  0.00           N  
ATOM    486  CA  LYS A  34      33.871  58.257   5.013  1.00  0.00           C  
ATOM    487  C   LYS A  34      34.533  59.631   5.030  1.00  0.00           C  
ATOM    488  O   LYS A  34      34.738  60.244   3.982  1.00  0.00           O  
ATOM    489  CB  LYS A  34      34.942  57.164   5.004  1.00  0.00           C  
ATOM    490  CG  LYS A  34      34.408  55.786   5.357  1.00  0.00           C  
ATOM    491  CD  LYS A  34      34.099  55.672   6.841  1.00  0.00           C  
ATOM    492  CE  LYS A  34      35.335  55.288   7.639  1.00  0.00           C  
ATOM    493  NZ  LYS A  34      34.990  54.858   9.022  1.00  0.00           N  
ATOM    494  H   LYS A  34      33.388  57.921   2.979  1.00  0.00           H  
ATOM    495  HA  LYS A  34      33.268  58.150   5.901  1.00  0.00           H  
ATOM    496  HB2 LYS A  34      35.381  57.115   4.019  1.00  0.00           H  
ATOM    497  HB3 LYS A  34      35.710  57.423   5.719  1.00  0.00           H  
ATOM    498  HG2 LYS A  34      33.503  55.606   4.797  1.00  0.00           H  
ATOM    499  HG3 LYS A  34      35.150  55.045   5.095  1.00  0.00           H  
ATOM    500  HD2 LYS A  34      33.735  56.623   7.198  1.00  0.00           H  
ATOM    501  HD3 LYS A  34      33.340  54.917   6.984  1.00  0.00           H  
ATOM    502  HE2 LYS A  34      35.837  54.476   7.134  1.00  0.00           H  
ATOM    503  HE3 LYS A  34      35.994  56.142   7.690  1.00  0.00           H  
ATOM    504  HZ1 LYS A  34      34.056  54.403   9.033  1.00  0.00           H  
ATOM    505  HZ2 LYS A  34      34.971  55.681   9.658  1.00  0.00           H  
ATOM    506  HZ3 LYS A  34      35.698  54.181   9.373  1.00  0.00           H  
ATOM    507  N   TRP A  35      34.865  60.108   6.224  1.00  0.00           N  
ATOM    508  CA  TRP A  35      35.504  61.410   6.375  1.00  0.00           C  
ATOM    509  C   TRP A  35      37.006  61.256   6.591  1.00  0.00           C  
ATOM    510  O   TRP A  35      37.447  60.434   7.393  1.00  0.00           O  
ATOM    511  CB  TRP A  35      34.884  62.173   7.547  1.00  0.00           C  
ATOM    512  CG  TRP A  35      33.513  62.701   7.253  1.00  0.00           C  
ATOM    513  CD1 TRP A  35      32.341  62.312   7.836  1.00  0.00           C  
ATOM    514  CD2 TRP A  35      33.171  63.715   6.300  1.00  0.00           C  
ATOM    515  NE1 TRP A  35      31.293  63.023   7.305  1.00  0.00           N  
ATOM    516  CE2 TRP A  35      31.775  63.890   6.360  1.00  0.00           C  
ATOM    517  CE3 TRP A  35      33.909  64.493   5.403  1.00  0.00           C  
ATOM    518  CZ2 TRP A  35      31.105  64.810   5.558  1.00  0.00           C  
ATOM    519  CZ3 TRP A  35      33.244  65.404   4.608  1.00  0.00           C  
ATOM    520  CH2 TRP A  35      31.853  65.557   4.689  1.00  0.00           C  
ATOM    521  H   TRP A  35      34.675  59.573   7.023  1.00  0.00           H  
ATOM    522  HA  TRP A  35      35.338  61.968   5.466  1.00  0.00           H  
ATOM    523  HB2 TRP A  35      34.811  61.514   8.399  1.00  0.00           H  
ATOM    524  HB3 TRP A  35      35.519  63.010   7.797  1.00  0.00           H  
ATOM    525  HD1 TRP A  35      32.266  61.555   8.601  1.00  0.00           H  
ATOM    526  HE1 TRP A  35      30.351  62.925   7.561  1.00  0.00           H  
ATOM    527  HE3 TRP A  35      34.982  64.389   5.327  1.00  0.00           H  
ATOM    528  HZ2 TRP A  35      30.035  64.940   5.609  1.00  0.00           H  
ATOM    529  HZ3 TRP A  35      33.797  66.013   3.908  1.00  0.00           H  
ATOM    530  HH2 TRP A  35      31.374  66.281   4.048  1.00  0.00           H  
ATOM    531  N   TYR A  36      37.787  62.053   5.870  1.00  0.00           N  
ATOM    532  CA  TYR A  36      39.240  62.004   5.980  1.00  0.00           C  
ATOM    533  C   TYR A  36      39.861  63.343   5.598  1.00  0.00           C  
ATOM    534  O   TYR A  36      39.289  64.130   4.843  1.00  0.00           O  
ATOM    535  CB  TYR A  36      39.803  60.894   5.091  1.00  0.00           C  
ATOM    536  CG  TYR A  36      39.450  59.502   5.563  1.00  0.00           C  
ATOM    537  CD1 TYR A  36      39.850  59.048   6.813  1.00  0.00           C  
ATOM    538  CD2 TYR A  36      38.714  58.640   4.757  1.00  0.00           C  
ATOM    539  CE1 TYR A  36      39.530  57.776   7.248  1.00  0.00           C  
ATOM    540  CE2 TYR A  36      38.389  57.367   5.185  1.00  0.00           C  
ATOM    541  CZ  TYR A  36      38.800  56.940   6.430  1.00  0.00           C  
ATOM    542  OH  TYR A  36      38.478  55.673   6.860  1.00  0.00           O  
ATOM    543  H   TYR A  36      37.377  62.689   5.246  1.00  0.00           H  
ATOM    544  HA  TYR A  36      39.487  61.787   7.010  1.00  0.00           H  
ATOM    545  HB2 TYR A  36      39.416  61.012   4.091  1.00  0.00           H  
ATOM    546  HB3 TYR A  36      40.880  60.974   5.067  1.00  0.00           H  
ATOM    547  HD1 TYR A  36      40.421  59.706   7.452  1.00  0.00           H  
ATOM    548  HD2 TYR A  36      38.395  58.978   3.782  1.00  0.00           H  
ATOM    549  HE1 TYR A  36      39.851  57.442   8.223  1.00  0.00           H  
ATOM    550  HE2 TYR A  36      37.817  56.712   4.545  1.00  0.00           H  
ATOM    551  HH  TYR A  36      37.563  55.483   6.638  1.00  0.00           H  
ATOM    552  N   PRO A  37      41.064  63.610   6.129  1.00  0.00           N  
ATOM    553  CA  PRO A  37      41.791  64.853   5.857  1.00  0.00           C  
ATOM    554  C   PRO A  37      42.302  64.924   4.421  1.00  0.00           C  
ATOM    555  O   PRO A  37      42.493  63.897   3.770  1.00  0.00           O  
ATOM    556  CB  PRO A  37      42.964  64.800   6.840  1.00  0.00           C  
ATOM    557  CG  PRO A  37      43.168  63.349   7.107  1.00  0.00           C  
ATOM    558  CD  PRO A  37      41.805  62.719   7.037  1.00  0.00           C  
ATOM    559  HA  PRO A  37      41.184  65.722   6.065  1.00  0.00           H  
ATOM    560  HB2 PRO A  37      43.838  65.246   6.385  1.00  0.00           H  
ATOM    561  HB3 PRO A  37      42.707  65.335   7.741  1.00  0.00           H  
ATOM    562  HG2 PRO A  37      43.817  62.926   6.355  1.00  0.00           H  
ATOM    563  HG3 PRO A  37      43.593  63.215   8.091  1.00  0.00           H  
ATOM    564  HD2 PRO A  37      41.871  61.721   6.628  1.00  0.00           H  
ATOM    565  HD3 PRO A  37      41.348  62.698   8.015  1.00  0.00           H  
ATOM    566  N   SER A  38      42.520  66.141   3.936  1.00  0.00           N  
ATOM    567  CA  SER A  38      43.006  66.345   2.575  1.00  0.00           C  
ATOM    568  C   SER A  38      43.467  67.785   2.374  1.00  0.00           C  
ATOM    569  O   SER A  38      43.282  68.636   3.245  1.00  0.00           O  
ATOM    570  CB  SER A  38      41.910  66.002   1.564  1.00  0.00           C  
ATOM    571  OG  SER A  38      41.618  64.617   1.578  1.00  0.00           O  
ATOM    572  H   SER A  38      42.349  66.921   4.505  1.00  0.00           H  
ATOM    573  HA  SER A  38      43.846  65.685   2.421  1.00  0.00           H  
ATOM    574  HB2 SER A  38      41.013  66.549   1.810  1.00  0.00           H  
ATOM    575  HB3 SER A  38      42.240  66.279   0.573  1.00  0.00           H  
ATOM    576  HG  SER A  38      41.045  64.417   2.321  1.00  0.00           H  
ATOM    577  N   ARG A  39      44.070  68.051   1.220  1.00  0.00           N  
ATOM    578  CA  ARG A  39      44.560  69.387   0.903  1.00  0.00           C  
ATOM    579  C   ARG A  39      44.236  69.757  -0.541  1.00  0.00           C  
ATOM    580  O   ARG A  39      43.906  68.894  -1.355  1.00  0.00           O  
ATOM    581  CB  ARG A  39      46.070  69.467   1.135  1.00  0.00           C  
ATOM    582  CG  ARG A  39      46.449  69.918   2.536  1.00  0.00           C  
ATOM    583  CD  ARG A  39      47.958  69.933   2.728  1.00  0.00           C  
ATOM    584  NE  ARG A  39      48.335  69.679   4.115  1.00  0.00           N  
ATOM    585  CZ  ARG A  39      48.143  68.515   4.728  1.00  0.00           C  
ATOM    586  NH1 ARG A  39      47.582  67.505   4.078  1.00  0.00           N  
ATOM    587  NH2 ARG A  39      48.514  68.360   5.992  1.00  0.00           N  
ATOM    588  H   ARG A  39      44.189  67.331   0.565  1.00  0.00           H  
ATOM    589  HA  ARG A  39      44.067  70.086   1.561  1.00  0.00           H  
ATOM    590  HB2 ARG A  39      46.501  68.491   0.966  1.00  0.00           H  
ATOM    591  HB3 ARG A  39      46.494  70.166   0.428  1.00  0.00           H  
ATOM    592  HG2 ARG A  39      46.067  70.916   2.699  1.00  0.00           H  
ATOM    593  HG3 ARG A  39      46.010  69.241   3.252  1.00  0.00           H  
ATOM    594  HD2 ARG A  39      48.395  69.171   2.101  1.00  0.00           H  
ATOM    595  HD3 ARG A  39      48.335  70.901   2.434  1.00  0.00           H  
ATOM    596  HE  ARG A  39      48.751  70.411   4.614  1.00  0.00           H  
ATOM    597 HH11 ARG A  39      47.303  67.618   3.124  1.00  0.00           H  
ATOM    598 HH12 ARG A  39      47.439  66.629   4.541  1.00  0.00           H  
ATOM    599 HH21 ARG A  39      48.938  69.119   6.486  1.00  0.00           H  
ATOM    600 HH22 ARG A  39      48.368  67.485   6.451  1.00  0.00           H  
ATOM    601  N   ILE A  40      44.330  71.045  -0.852  1.00  0.00           N  
ATOM    602  CA  ILE A  40      44.047  71.529  -2.197  1.00  0.00           C  
ATOM    603  C   ILE A  40      45.337  71.819  -2.960  1.00  0.00           C  
ATOM    604  O   ILE A  40      45.974  72.850  -2.749  1.00  0.00           O  
ATOM    605  CB  ILE A  40      43.184  72.804  -2.167  1.00  0.00           C  
ATOM    606  CG1 ILE A  40      41.749  72.465  -1.760  1.00  0.00           C  
ATOM    607  CG2 ILE A  40      43.207  73.491  -3.524  1.00  0.00           C  
ATOM    608  CD1 ILE A  40      40.963  73.659  -1.264  1.00  0.00           C  
ATOM    609  H   ILE A  40      44.598  71.685  -0.160  1.00  0.00           H  
ATOM    610  HA  ILE A  40      43.498  70.759  -2.719  1.00  0.00           H  
ATOM    611  HB  ILE A  40      43.607  73.481  -1.441  1.00  0.00           H  
ATOM    612 HG12 ILE A  40      41.227  72.055  -2.610  1.00  0.00           H  
ATOM    613 HG13 ILE A  40      41.772  71.730  -0.969  1.00  0.00           H  
ATOM    614 HG21 ILE A  40      42.244  73.941  -3.716  1.00  0.00           H  
ATOM    615 HG22 ILE A  40      43.968  74.257  -3.527  1.00  0.00           H  
ATOM    616 HG23 ILE A  40      43.424  72.764  -4.293  1.00  0.00           H  
ATOM    617 HD11 ILE A  40      39.906  73.456  -1.355  1.00  0.00           H  
ATOM    618 HD12 ILE A  40      41.205  73.844  -0.228  1.00  0.00           H  
ATOM    619 HD13 ILE A  40      41.215  74.526  -1.855  1.00  0.00           H  
ATOM    620  N   GLU A  41      45.712  70.903  -3.847  1.00  0.00           N  
ATOM    621  CA  GLU A  41      46.924  71.061  -4.641  1.00  0.00           C  
ATOM    622  C   GLU A  41      46.741  72.142  -5.703  1.00  0.00           C  
ATOM    623  O   GLU A  41      47.623  72.975  -5.915  1.00  0.00           O  
ATOM    624  CB  GLU A  41      47.302  69.736  -5.306  1.00  0.00           C  
ATOM    625  CG  GLU A  41      47.827  68.694  -4.333  1.00  0.00           C  
ATOM    626  CD  GLU A  41      49.015  69.190  -3.532  1.00  0.00           C  
ATOM    627  OE1 GLU A  41      50.049  69.520  -4.149  1.00  0.00           O  
ATOM    628  OE2 GLU A  41      48.911  69.247  -2.288  1.00  0.00           O  
ATOM    629  H   GLU A  41      45.162  70.101  -3.969  1.00  0.00           H  
ATOM    630  HA  GLU A  41      47.721  71.359  -3.975  1.00  0.00           H  
ATOM    631  HB2 GLU A  41      46.429  69.333  -5.798  1.00  0.00           H  
ATOM    632  HB3 GLU A  41      48.066  69.923  -6.046  1.00  0.00           H  
ATOM    633  HG2 GLU A  41      47.035  68.429  -3.647  1.00  0.00           H  
ATOM    634  HG3 GLU A  41      48.126  67.819  -4.890  1.00  0.00           H  
ATOM    635  N   LYS A  42      45.591  72.121  -6.368  1.00  0.00           N  
ATOM    636  CA  LYS A  42      45.289  73.098  -7.406  1.00  0.00           C  
ATOM    637  C   LYS A  42      43.796  73.407  -7.447  1.00  0.00           C  
ATOM    638  O   LYS A  42      42.986  72.675  -6.879  1.00  0.00           O  
ATOM    639  CB  LYS A  42      45.751  72.581  -8.772  1.00  0.00           C  
ATOM    640  CG  LYS A  42      47.237  72.767  -9.021  1.00  0.00           C  
ATOM    641  CD  LYS A  42      47.705  71.969 -10.227  1.00  0.00           C  
ATOM    642  CE  LYS A  42      49.208  71.739 -10.194  1.00  0.00           C  
ATOM    643  NZ  LYS A  42      49.967  73.009 -10.356  1.00  0.00           N  
ATOM    644  H   LYS A  42      44.928  71.432  -6.153  1.00  0.00           H  
ATOM    645  HA  LYS A  42      45.827  74.006  -7.175  1.00  0.00           H  
ATOM    646  HB2 LYS A  42      45.525  71.527  -8.838  1.00  0.00           H  
ATOM    647  HB3 LYS A  42      45.209  73.106  -9.544  1.00  0.00           H  
ATOM    648  HG2 LYS A  42      47.435  73.814  -9.198  1.00  0.00           H  
ATOM    649  HG3 LYS A  42      47.784  72.438  -8.149  1.00  0.00           H  
ATOM    650  HD2 LYS A  42      47.206  71.011 -10.228  1.00  0.00           H  
ATOM    651  HD3 LYS A  42      47.452  72.511 -11.127  1.00  0.00           H  
ATOM    652  HE2 LYS A  42      49.471  71.291  -9.247  1.00  0.00           H  
ATOM    653  HE3 LYS A  42      49.474  71.066 -10.996  1.00  0.00           H  
ATOM    654  HZ1 LYS A  42      49.318  73.786 -10.594  1.00  0.00           H  
ATOM    655  HZ2 LYS A  42      50.669  72.912 -11.118  1.00  0.00           H  
ATOM    656  HZ3 LYS A  42      50.463  73.245  -9.472  1.00  0.00           H  
ATOM    657  N   ILE A  43      43.440  74.495  -8.123  1.00  0.00           N  
ATOM    658  CA  ILE A  43      42.043  74.897  -8.238  1.00  0.00           C  
ATOM    659  C   ILE A  43      41.745  75.451  -9.628  1.00  0.00           C  
ATOM    660  O   ILE A  43      42.464  76.314 -10.131  1.00  0.00           O  
ATOM    661  CB  ILE A  43      41.675  75.959  -7.185  1.00  0.00           C  
ATOM    662  CG1 ILE A  43      41.882  75.403  -5.775  1.00  0.00           C  
ATOM    663  CG2 ILE A  43      40.237  76.415  -7.375  1.00  0.00           C  
ATOM    664  CD1 ILE A  43      41.627  76.417  -4.681  1.00  0.00           C  
ATOM    665  H   ILE A  43      44.132  75.038  -8.554  1.00  0.00           H  
ATOM    666  HA  ILE A  43      41.430  74.025  -8.070  1.00  0.00           H  
ATOM    667  HB  ILE A  43      42.319  76.812  -7.326  1.00  0.00           H  
ATOM    668 HG12 ILE A  43      41.210  74.573  -5.620  1.00  0.00           H  
ATOM    669 HG13 ILE A  43      42.901  75.058  -5.678  1.00  0.00           H  
ATOM    670 HG21 ILE A  43      40.093  77.367  -6.884  1.00  0.00           H  
ATOM    671 HG22 ILE A  43      40.029  76.521  -8.429  1.00  0.00           H  
ATOM    672 HG23 ILE A  43      39.567  75.684  -6.947  1.00  0.00           H  
ATOM    673 HD11 ILE A  43      42.569  76.822  -4.340  1.00  0.00           H  
ATOM    674 HD12 ILE A  43      41.012  77.217  -5.068  1.00  0.00           H  
ATOM    675 HD13 ILE A  43      41.120  75.939  -3.857  1.00  0.00           H  
ATOM    676  N   ASP A  44      40.679  74.949 -10.242  1.00  0.00           N  
ATOM    677  CA  ASP A  44      40.282  75.396 -11.571  1.00  0.00           C  
ATOM    678  C   ASP A  44      39.014  76.241 -11.506  1.00  0.00           C  
ATOM    679  O   ASP A  44      37.917  75.718 -11.306  1.00  0.00           O  
ATOM    680  CB  ASP A  44      40.061  74.194 -12.492  1.00  0.00           C  
ATOM    681  CG  ASP A  44      40.113  74.569 -13.959  1.00  0.00           C  
ATOM    682  OD1 ASP A  44      39.807  75.736 -14.284  1.00  0.00           O  
ATOM    683  OD2 ASP A  44      40.461  73.698 -14.783  1.00  0.00           O  
ATOM    684  H   ASP A  44      40.145  74.263  -9.788  1.00  0.00           H  
ATOM    685  HA  ASP A  44      41.082  76.000 -11.971  1.00  0.00           H  
ATOM    686  HB2 ASP A  44      40.828  73.457 -12.300  1.00  0.00           H  
ATOM    687  HB3 ASP A  44      39.093  73.762 -12.283  1.00  0.00           H  
ATOM    688  N   TYR A  45      39.172  77.549 -11.674  1.00  0.00           N  
ATOM    689  CA  TYR A  45      38.041  78.468 -11.630  1.00  0.00           C  
ATOM    690  C   TYR A  45      37.334  78.527 -12.980  1.00  0.00           C  
ATOM    691  O   TYR A  45      36.177  78.936 -13.070  1.00  0.00           O  
ATOM    692  CB  TYR A  45      38.508  79.867 -11.223  1.00  0.00           C  
ATOM    693  CG  TYR A  45      38.896  79.976  -9.766  1.00  0.00           C  
ATOM    694  CD1 TYR A  45      40.042  79.356  -9.284  1.00  0.00           C  
ATOM    695  CD2 TYR A  45      38.118  80.701  -8.872  1.00  0.00           C  
ATOM    696  CE1 TYR A  45      40.400  79.453  -7.953  1.00  0.00           C  
ATOM    697  CE2 TYR A  45      38.470  80.804  -7.540  1.00  0.00           C  
ATOM    698  CZ  TYR A  45      39.611  80.178  -7.086  1.00  0.00           C  
ATOM    699  OH  TYR A  45      39.965  80.278  -5.760  1.00  0.00           O  
ATOM    700  H   TYR A  45      40.071  77.906 -11.829  1.00  0.00           H  
ATOM    701  HA  TYR A  45      37.345  78.102 -10.888  1.00  0.00           H  
ATOM    702  HB2 TYR A  45      39.368  80.138 -11.817  1.00  0.00           H  
ATOM    703  HB3 TYR A  45      37.711  80.573 -11.409  1.00  0.00           H  
ATOM    704  HD1 TYR A  45      40.658  78.789  -9.967  1.00  0.00           H  
ATOM    705  HD2 TYR A  45      37.224  81.190  -9.231  1.00  0.00           H  
ATOM    706  HE1 TYR A  45      41.295  78.962  -7.597  1.00  0.00           H  
ATOM    707  HE2 TYR A  45      37.851  81.371  -6.860  1.00  0.00           H  
ATOM    708  HH  TYR A  45      39.548  79.570  -5.262  1.00  0.00           H  
ATOM    709  N   GLU A  46      38.041  78.115 -14.029  1.00  0.00           N  
ATOM    710  CA  GLU A  46      37.482  78.122 -15.376  1.00  0.00           C  
ATOM    711  C   GLU A  46      36.582  76.910 -15.597  1.00  0.00           C  
ATOM    712  O   GLU A  46      35.657  76.951 -16.407  1.00  0.00           O  
ATOM    713  CB  GLU A  46      38.604  78.136 -16.417  1.00  0.00           C  
ATOM    714  CG  GLU A  46      39.248  79.500 -16.600  1.00  0.00           C  
ATOM    715  CD  GLU A  46      38.254  80.561 -17.030  1.00  0.00           C  
ATOM    716  OE1 GLU A  46      37.849  80.551 -18.211  1.00  0.00           O  
ATOM    717  OE2 GLU A  46      37.882  81.402 -16.185  1.00  0.00           O  
ATOM    718  H   GLU A  46      38.959  77.802 -13.893  1.00  0.00           H  
ATOM    719  HA  GLU A  46      36.891  79.019 -15.485  1.00  0.00           H  
ATOM    720  HB2 GLU A  46      39.369  77.437 -16.113  1.00  0.00           H  
ATOM    721  HB3 GLU A  46      38.199  77.822 -17.368  1.00  0.00           H  
ATOM    722  HG2 GLU A  46      39.692  79.802 -15.664  1.00  0.00           H  
ATOM    723  HG3 GLU A  46      40.018  79.421 -17.354  1.00  0.00           H  
ATOM    724  N   GLU A  47      36.862  75.832 -14.871  1.00  0.00           N  
ATOM    725  CA  GLU A  47      36.079  74.608 -14.991  1.00  0.00           C  
ATOM    726  C   GLU A  47      35.227  74.385 -13.744  1.00  0.00           C  
ATOM    727  O   GLU A  47      34.054  74.022 -13.838  1.00  0.00           O  
ATOM    728  CB  GLU A  47      37.000  73.407 -15.214  1.00  0.00           C  
ATOM    729  CG  GLU A  47      37.502  73.282 -16.643  1.00  0.00           C  
ATOM    730  CD  GLU A  47      36.420  73.565 -17.668  1.00  0.00           C  
ATOM    731  OE1 GLU A  47      35.431  72.803 -17.710  1.00  0.00           O  
ATOM    732  OE2 GLU A  47      36.563  74.545 -18.427  1.00  0.00           O  
ATOM    733  H   GLU A  47      37.613  75.860 -14.243  1.00  0.00           H  
ATOM    734  HA  GLU A  47      35.426  74.713 -15.844  1.00  0.00           H  
ATOM    735  HB2 GLU A  47      37.855  73.496 -14.560  1.00  0.00           H  
ATOM    736  HB3 GLU A  47      36.460  72.504 -14.965  1.00  0.00           H  
ATOM    737  HG2 GLU A  47      38.308  73.985 -16.790  1.00  0.00           H  
ATOM    738  HG3 GLU A  47      37.868  72.278 -16.796  1.00  0.00           H  
ATOM    739  N   GLY A  48      35.826  74.602 -12.577  1.00  0.00           N  
ATOM    740  CA  GLY A  48      35.108  74.420 -11.329  1.00  0.00           C  
ATOM    741  C   GLY A  48      35.555  73.178 -10.581  1.00  0.00           C  
ATOM    742  O   GLY A  48      34.807  72.630  -9.771  1.00  0.00           O  
ATOM    743  H   GLY A  48      36.763  74.890 -12.564  1.00  0.00           H  
ATOM    744  HA2 GLY A  48      35.272  75.283 -10.703  1.00  0.00           H  
ATOM    745  HA3 GLY A  48      34.053  74.336 -11.543  1.00  0.00           H  
ATOM    746  N   LYS A  49      36.776  72.732 -10.853  1.00  0.00           N  
ATOM    747  CA  LYS A  49      37.322  71.549 -10.201  1.00  0.00           C  
ATOM    748  C   LYS A  49      38.662  71.858  -9.543  1.00  0.00           C  
ATOM    749  O   LYS A  49      39.463  72.625 -10.078  1.00  0.00           O  
ATOM    750  CB  LYS A  49      37.488  70.414 -11.214  1.00  0.00           C  
ATOM    751  CG  LYS A  49      38.234  70.826 -12.471  1.00  0.00           C  
ATOM    752  CD  LYS A  49      38.982  69.654 -13.085  1.00  0.00           C  
ATOM    753  CE  LYS A  49      40.194  70.120 -13.879  1.00  0.00           C  
ATOM    754  NZ  LYS A  49      41.002  68.975 -14.381  1.00  0.00           N  
ATOM    755  H   LYS A  49      37.325  73.212 -11.509  1.00  0.00           H  
ATOM    756  HA  LYS A  49      36.623  71.239  -9.437  1.00  0.00           H  
ATOM    757  HB2 LYS A  49      38.032  69.606 -10.746  1.00  0.00           H  
ATOM    758  HB3 LYS A  49      36.510  70.057 -11.501  1.00  0.00           H  
ATOM    759  HG2 LYS A  49      37.525  71.203 -13.193  1.00  0.00           H  
ATOM    760  HG3 LYS A  49      38.943  71.602 -12.220  1.00  0.00           H  
ATOM    761  HD2 LYS A  49      39.316  68.997 -12.294  1.00  0.00           H  
ATOM    762  HD3 LYS A  49      38.315  69.118 -13.744  1.00  0.00           H  
ATOM    763  HE2 LYS A  49      39.853  70.706 -14.719  1.00  0.00           H  
ATOM    764  HE3 LYS A  49      40.811  70.734 -13.240  1.00  0.00           H  
ATOM    765  HZ1 LYS A  49      41.478  69.236 -15.268  1.00  0.00           H  
ATOM    766  HZ2 LYS A  49      40.388  68.155 -14.558  1.00  0.00           H  
ATOM    767  HZ3 LYS A  49      41.721  68.710 -13.677  1.00  0.00           H  
ATOM    768  N   MET A  50      38.901  71.257  -8.382  1.00  0.00           N  
ATOM    769  CA  MET A  50      40.146  71.468  -7.654  1.00  0.00           C  
ATOM    770  C   MET A  50      40.849  70.141  -7.382  1.00  0.00           C  
ATOM    771  O   MET A  50      40.204  69.138  -7.073  1.00  0.00           O  
ATOM    772  CB  MET A  50      39.875  72.195  -6.336  1.00  0.00           C  
ATOM    773  CG  MET A  50      38.495  71.916  -5.761  1.00  0.00           C  
ATOM    774  SD  MET A  50      38.328  72.475  -4.055  1.00  0.00           S  
ATOM    775  CE  MET A  50      37.925  70.935  -3.234  1.00  0.00           C  
ATOM    776  H   MET A  50      38.223  70.657  -8.006  1.00  0.00           H  
ATOM    777  HA  MET A  50      40.789  72.082  -8.267  1.00  0.00           H  
ATOM    778  HB2 MET A  50      40.612  71.886  -5.610  1.00  0.00           H  
ATOM    779  HB3 MET A  50      39.965  73.259  -6.498  1.00  0.00           H  
ATOM    780  HG2 MET A  50      37.759  72.425  -6.365  1.00  0.00           H  
ATOM    781  HG3 MET A  50      38.314  70.852  -5.798  1.00  0.00           H  
ATOM    782  HE1 MET A  50      38.691  70.203  -3.446  1.00  0.00           H  
ATOM    783  HE2 MET A  50      37.870  71.099  -2.167  1.00  0.00           H  
ATOM    784  HE3 MET A  50      36.972  70.574  -3.592  1.00  0.00           H  
ATOM    785  N   LEU A  51      42.172  70.142  -7.499  1.00  0.00           N  
ATOM    786  CA  LEU A  51      42.961  68.938  -7.266  1.00  0.00           C  
ATOM    787  C   LEU A  51      43.187  68.715  -5.773  1.00  0.00           C  
ATOM    788  O   LEU A  51      44.048  69.349  -5.163  1.00  0.00           O  
ATOM    789  CB  LEU A  51      44.307  69.039  -7.986  1.00  0.00           C  
ATOM    790  CG  LEU A  51      44.946  67.714  -8.403  1.00  0.00           C  
ATOM    791  CD1 LEU A  51      46.420  67.908  -8.720  1.00  0.00           C  
ATOM    792  CD2 LEU A  51      44.766  66.669  -7.312  1.00  0.00           C  
ATOM    793  H   LEU A  51      42.629  70.972  -7.748  1.00  0.00           H  
ATOM    794  HA  LEU A  51      42.410  68.098  -7.664  1.00  0.00           H  
ATOM    795  HB2 LEU A  51      44.161  69.630  -8.877  1.00  0.00           H  
ATOM    796  HB3 LEU A  51      44.996  69.547  -7.328  1.00  0.00           H  
ATOM    797  HG  LEU A  51      44.457  67.351  -9.298  1.00  0.00           H  
ATOM    798 HD11 LEU A  51      46.859  66.960  -8.992  1.00  0.00           H  
ATOM    799 HD12 LEU A  51      46.926  68.304  -7.852  1.00  0.00           H  
ATOM    800 HD13 LEU A  51      46.523  68.602  -9.542  1.00  0.00           H  
ATOM    801 HD21 LEU A  51      45.438  66.884  -6.494  1.00  0.00           H  
ATOM    802 HD22 LEU A  51      44.988  65.690  -7.711  1.00  0.00           H  
ATOM    803 HD23 LEU A  51      43.747  66.690  -6.957  1.00  0.00           H  
ATOM    804  N   VAL A  52      42.407  67.808  -5.191  1.00  0.00           N  
ATOM    805  CA  VAL A  52      42.523  67.499  -3.772  1.00  0.00           C  
ATOM    806  C   VAL A  52      43.243  66.172  -3.555  1.00  0.00           C  
ATOM    807  O   VAL A  52      43.017  65.206  -4.284  1.00  0.00           O  
ATOM    808  CB  VAL A  52      41.141  67.437  -3.096  1.00  0.00           C  
ATOM    809  CG1 VAL A  52      40.258  66.403  -3.778  1.00  0.00           C  
ATOM    810  CG2 VAL A  52      41.287  67.130  -1.613  1.00  0.00           C  
ATOM    811  H   VAL A  52      41.738  67.336  -5.731  1.00  0.00           H  
ATOM    812  HA  VAL A  52      43.095  68.288  -3.303  1.00  0.00           H  
ATOM    813  HB  VAL A  52      40.669  68.404  -3.197  1.00  0.00           H  
ATOM    814 HG11 VAL A  52      40.865  65.571  -4.103  1.00  0.00           H  
ATOM    815 HG12 VAL A  52      39.508  66.055  -3.084  1.00  0.00           H  
ATOM    816 HG13 VAL A  52      39.776  66.851  -4.635  1.00  0.00           H  
ATOM    817 HG21 VAL A  52      42.220  66.616  -1.442  1.00  0.00           H  
ATOM    818 HG22 VAL A  52      41.275  68.053  -1.052  1.00  0.00           H  
ATOM    819 HG23 VAL A  52      40.467  66.504  -1.292  1.00  0.00           H  
ATOM    820  N   HIS A  53      44.109  66.132  -2.549  1.00  0.00           N  
ATOM    821  CA  HIS A  53      44.861  64.923  -2.235  1.00  0.00           C  
ATOM    822  C   HIS A  53      44.374  64.303  -0.928  1.00  0.00           C  
ATOM    823  O   HIS A  53      44.078  65.012   0.033  1.00  0.00           O  
ATOM    824  CB  HIS A  53      46.355  65.237  -2.138  1.00  0.00           C  
ATOM    825  CG  HIS A  53      46.808  65.570  -0.750  1.00  0.00           C  
ATOM    826  ND1 HIS A  53      46.695  64.695   0.309  1.00  0.00           N  
ATOM    827  CD2 HIS A  53      47.379  66.692  -0.251  1.00  0.00           C  
ATOM    828  CE1 HIS A  53      47.176  65.264   1.401  1.00  0.00           C  
ATOM    829  NE2 HIS A  53      47.598  66.475   1.087  1.00  0.00           N  
ATOM    830  H   HIS A  53      44.246  66.935  -2.003  1.00  0.00           H  
ATOM    831  HA  HIS A  53      44.702  64.217  -3.035  1.00  0.00           H  
ATOM    832  HB2 HIS A  53      46.918  64.378  -2.473  1.00  0.00           H  
ATOM    833  HB3 HIS A  53      46.582  66.080  -2.774  1.00  0.00           H  
ATOM    834  HD1 HIS A  53      46.317  63.792   0.268  1.00  0.00           H  
ATOM    835  HD2 HIS A  53      47.619  67.590  -0.803  1.00  0.00           H  
ATOM    836  HE1 HIS A  53      47.217  64.815   2.382  1.00  0.00           H  
ATOM    837  N   PHE A  54      44.292  62.977  -0.903  1.00  0.00           N  
ATOM    838  CA  PHE A  54      43.839  62.262   0.284  1.00  0.00           C  
ATOM    839  C   PHE A  54      45.024  61.713   1.075  1.00  0.00           C  
ATOM    840  O   PHE A  54      46.048  61.345   0.501  1.00  0.00           O  
ATOM    841  CB  PHE A  54      42.902  61.119  -0.109  1.00  0.00           C  
ATOM    842  CG  PHE A  54      41.586  61.586  -0.663  1.00  0.00           C  
ATOM    843  CD1 PHE A  54      41.456  61.897  -2.008  1.00  0.00           C  
ATOM    844  CD2 PHE A  54      40.479  61.715   0.160  1.00  0.00           C  
ATOM    845  CE1 PHE A  54      40.248  62.328  -2.520  1.00  0.00           C  
ATOM    846  CE2 PHE A  54      39.267  62.145  -0.347  1.00  0.00           C  
ATOM    847  CZ  PHE A  54      39.151  62.451  -1.690  1.00  0.00           C  
ATOM    848  H   PHE A  54      44.543  62.467  -1.702  1.00  0.00           H  
ATOM    849  HA  PHE A  54      43.300  62.960   0.905  1.00  0.00           H  
ATOM    850  HB2 PHE A  54      43.381  60.513  -0.863  1.00  0.00           H  
ATOM    851  HB3 PHE A  54      42.699  60.513   0.761  1.00  0.00           H  
ATOM    852  HD1 PHE A  54      42.313  61.800  -2.659  1.00  0.00           H  
ATOM    853  HD2 PHE A  54      40.568  61.476   1.209  1.00  0.00           H  
ATOM    854  HE1 PHE A  54      40.159  62.567  -3.569  1.00  0.00           H  
ATOM    855  HE2 PHE A  54      38.412  62.241   0.305  1.00  0.00           H  
ATOM    856  HZ  PHE A  54      38.205  62.789  -2.087  1.00  0.00           H  
ATOM    857  N   GLU A  55      44.875  61.665   2.394  1.00  0.00           N  
ATOM    858  CA  GLU A  55      45.933  61.163   3.263  1.00  0.00           C  
ATOM    859  C   GLU A  55      45.755  59.671   3.533  1.00  0.00           C  
ATOM    860  O   GLU A  55      46.687  58.884   3.370  1.00  0.00           O  
ATOM    861  CB  GLU A  55      45.946  61.933   4.586  1.00  0.00           C  
ATOM    862  CG  GLU A  55      45.591  63.403   4.437  1.00  0.00           C  
ATOM    863  CD  GLU A  55      46.268  64.274   5.477  1.00  0.00           C  
ATOM    864  OE1 GLU A  55      47.185  63.775   6.163  1.00  0.00           O  
ATOM    865  OE2 GLU A  55      45.881  65.455   5.606  1.00  0.00           O  
ATOM    866  H   GLU A  55      44.035  61.973   2.793  1.00  0.00           H  
ATOM    867  HA  GLU A  55      46.875  61.314   2.760  1.00  0.00           H  
ATOM    868  HB2 GLU A  55      45.235  61.478   5.260  1.00  0.00           H  
ATOM    869  HB3 GLU A  55      46.934  61.865   5.018  1.00  0.00           H  
ATOM    870  HG2 GLU A  55      45.897  63.737   3.456  1.00  0.00           H  
ATOM    871  HG3 GLU A  55      44.521  63.514   4.537  1.00  0.00           H  
ATOM    872  N   ARG A  56      44.550  59.291   3.947  1.00  0.00           N  
ATOM    873  CA  ARG A  56      44.249  57.895   4.242  1.00  0.00           C  
ATOM    874  C   ARG A  56      45.014  56.964   3.305  1.00  0.00           C  
ATOM    875  O   ARG A  56      45.932  56.260   3.728  1.00  0.00           O  
ATOM    876  CB  ARG A  56      42.746  57.638   4.116  1.00  0.00           C  
ATOM    877  CG  ARG A  56      42.255  56.475   4.962  1.00  0.00           C  
ATOM    878  CD  ARG A  56      42.385  55.153   4.222  1.00  0.00           C  
ATOM    879  NE  ARG A  56      43.685  54.527   4.446  1.00  0.00           N  
ATOM    880  CZ  ARG A  56      43.992  53.845   5.544  1.00  0.00           C  
ATOM    881  NH1 ARG A  56      43.097  53.703   6.513  1.00  0.00           N  
ATOM    882  NH2 ARG A  56      45.196  53.303   5.675  1.00  0.00           N  
ATOM    883  H   ARG A  56      43.848  59.966   4.059  1.00  0.00           H  
ATOM    884  HA  ARG A  56      44.556  57.697   5.257  1.00  0.00           H  
ATOM    885  HB2 ARG A  56      42.214  58.527   4.422  1.00  0.00           H  
ATOM    886  HB3 ARG A  56      42.514  57.427   3.083  1.00  0.00           H  
ATOM    887  HG2 ARG A  56      42.841  56.428   5.868  1.00  0.00           H  
ATOM    888  HG3 ARG A  56      41.216  56.638   5.212  1.00  0.00           H  
ATOM    889  HD2 ARG A  56      41.609  54.486   4.566  1.00  0.00           H  
ATOM    890  HD3 ARG A  56      42.261  55.335   3.165  1.00  0.00           H  
ATOM    891  HE  ARG A  56      44.360  54.619   3.743  1.00  0.00           H  
ATOM    892 HH11 ARG A  56      42.189  54.110   6.416  1.00  0.00           H  
ATOM    893 HH12 ARG A  56      43.331  53.188   7.338  1.00  0.00           H  
ATOM    894 HH21 ARG A  56      45.873  53.408   4.947  1.00  0.00           H  
ATOM    895 HH22 ARG A  56      45.427  52.791   6.501  1.00  0.00           H  
ATOM    896  N   TRP A  57      44.632  56.968   2.034  1.00  0.00           N  
ATOM    897  CA  TRP A  57      45.282  56.123   1.038  1.00  0.00           C  
ATOM    898  C   TRP A  57      46.799  56.258   1.117  1.00  0.00           C  
ATOM    899  O   TRP A  57      47.373  57.223   0.613  1.00  0.00           O  
ATOM    900  CB  TRP A  57      44.797  56.490  -0.366  1.00  0.00           C  
ATOM    901  CG  TRP A  57      43.446  55.930  -0.692  1.00  0.00           C  
ATOM    902  CD1 TRP A  57      43.175  54.714  -1.252  1.00  0.00           C  
ATOM    903  CD2 TRP A  57      42.181  56.568  -0.481  1.00  0.00           C  
ATOM    904  NE1 TRP A  57      41.818  54.557  -1.401  1.00  0.00           N  
ATOM    905  CE2 TRP A  57      41.187  55.680  -0.935  1.00  0.00           C  
ATOM    906  CE3 TRP A  57      41.792  57.801   0.048  1.00  0.00           C  
ATOM    907  CZ2 TRP A  57      39.830  55.989  -0.875  1.00  0.00           C  
ATOM    908  CZ3 TRP A  57      40.446  58.106   0.107  1.00  0.00           C  
ATOM    909  CH2 TRP A  57      39.477  57.203  -0.352  1.00  0.00           C  
ATOM    910  H   TRP A  57      43.894  57.551   1.757  1.00  0.00           H  
ATOM    911  HA  TRP A  57      45.012  55.098   1.246  1.00  0.00           H  
ATOM    912  HB2 TRP A  57      44.744  57.565  -0.452  1.00  0.00           H  
ATOM    913  HB3 TRP A  57      45.501  56.108  -1.092  1.00  0.00           H  
ATOM    914  HD1 TRP A  57      43.928  53.993  -1.531  1.00  0.00           H  
ATOM    915  HE1 TRP A  57      41.376  53.768  -1.778  1.00  0.00           H  
ATOM    916  HE3 TRP A  57      42.523  58.511   0.407  1.00  0.00           H  
ATOM    917  HZ2 TRP A  57      39.072  55.303  -1.224  1.00  0.00           H  
ATOM    918  HZ3 TRP A  57      40.126  59.055   0.512  1.00  0.00           H  
ATOM    919  HH2 TRP A  57      38.438  57.483  -0.287  1.00  0.00           H  
ATOM    920  N   SER A  58      47.442  55.284   1.753  1.00  0.00           N  
ATOM    921  CA  SER A  58      48.893  55.297   1.900  1.00  0.00           C  
ATOM    922  C   SER A  58      49.559  55.918   0.676  1.00  0.00           C  
ATOM    923  O   SER A  58      50.191  56.971   0.765  1.00  0.00           O  
ATOM    924  CB  SER A  58      49.417  53.875   2.114  1.00  0.00           C  
ATOM    925  OG  SER A  58      49.160  53.430   3.435  1.00  0.00           O  
ATOM    926  H   SER A  58      46.929  54.541   2.133  1.00  0.00           H  
ATOM    927  HA  SER A  58      49.133  55.894   2.767  1.00  0.00           H  
ATOM    928  HB2 SER A  58      48.931  53.207   1.421  1.00  0.00           H  
ATOM    929  HB3 SER A  58      50.484  53.859   1.943  1.00  0.00           H  
ATOM    930  HG  SER A  58      49.988  53.346   3.912  1.00  0.00           H  
ATOM    931  N   HIS A  59      49.412  55.256  -0.468  1.00  0.00           N  
ATOM    932  CA  HIS A  59      49.999  55.743  -1.713  1.00  0.00           C  
ATOM    933  C   HIS A  59      49.392  57.084  -2.110  1.00  0.00           C  
ATOM    934  O   HIS A  59      48.196  57.179  -2.388  1.00  0.00           O  
ATOM    935  CB  HIS A  59      49.788  54.722  -2.833  1.00  0.00           C  
ATOM    936  CG  HIS A  59      50.226  55.212  -4.178  1.00  0.00           C  
ATOM    937  ND1 HIS A  59      49.519  56.146  -4.906  1.00  0.00           N  
ATOM    938  CD2 HIS A  59      51.307  54.894  -4.927  1.00  0.00           C  
ATOM    939  CE1 HIS A  59      50.145  56.379  -6.045  1.00  0.00           C  
ATOM    940  NE2 HIS A  59      51.234  55.633  -6.082  1.00  0.00           N  
ATOM    941  H   HIS A  59      48.898  54.422  -0.476  1.00  0.00           H  
ATOM    942  HA  HIS A  59      51.057  55.874  -1.551  1.00  0.00           H  
ATOM    943  HB2 HIS A  59      50.351  53.829  -2.607  1.00  0.00           H  
ATOM    944  HB3 HIS A  59      48.738  54.476  -2.894  1.00  0.00           H  
ATOM    945  HD1 HIS A  59      48.681  56.572  -4.629  1.00  0.00           H  
ATOM    946  HD2 HIS A  59      52.085  54.190  -4.666  1.00  0.00           H  
ATOM    947  HE1 HIS A  59      49.822  57.064  -6.816  1.00  0.00           H  
ATOM    948  N   ARG A  60      50.225  58.120  -2.135  1.00  0.00           N  
ATOM    949  CA  ARG A  60      49.770  59.457  -2.497  1.00  0.00           C  
ATOM    950  C   ARG A  60      48.677  59.391  -3.560  1.00  0.00           C  
ATOM    951  O   ARG A  60      48.965  59.327  -4.756  1.00  0.00           O  
ATOM    952  CB  ARG A  60      50.943  60.298  -3.007  1.00  0.00           C  
ATOM    953  CG  ARG A  60      51.796  59.586  -4.044  1.00  0.00           C  
ATOM    954  CD  ARG A  60      52.923  58.799  -3.392  1.00  0.00           C  
ATOM    955  NE  ARG A  60      54.096  58.706  -4.258  1.00  0.00           N  
ATOM    956  CZ  ARG A  60      55.121  57.895  -4.020  1.00  0.00           C  
ATOM    957  NH1 ARG A  60      55.119  57.112  -2.949  1.00  0.00           N  
ATOM    958  NH2 ARG A  60      56.153  57.866  -4.854  1.00  0.00           N  
ATOM    959  H   ARG A  60      51.167  57.982  -1.903  1.00  0.00           H  
ATOM    960  HA  ARG A  60      49.364  59.922  -1.611  1.00  0.00           H  
ATOM    961  HB2 ARG A  60      50.555  61.203  -3.451  1.00  0.00           H  
ATOM    962  HB3 ARG A  60      51.573  60.558  -2.170  1.00  0.00           H  
ATOM    963  HG2 ARG A  60      51.173  58.903  -4.603  1.00  0.00           H  
ATOM    964  HG3 ARG A  60      52.220  60.320  -4.712  1.00  0.00           H  
ATOM    965  HD2 ARG A  60      53.205  59.292  -2.474  1.00  0.00           H  
ATOM    966  HD3 ARG A  60      52.568  57.803  -3.173  1.00  0.00           H  
ATOM    967  HE  ARG A  60      54.118  59.274  -5.054  1.00  0.00           H  
ATOM    968 HH11 ARG A  60      54.343  57.133  -2.319  1.00  0.00           H  
ATOM    969 HH12 ARG A  60      55.892  56.503  -2.773  1.00  0.00           H  
ATOM    970 HH21 ARG A  60      56.159  58.454  -5.662  1.00  0.00           H  
ATOM    971 HH22 ARG A  60      56.924  57.256  -4.674  1.00  0.00           H  
ATOM    972  N   TYR A  61      47.426  59.406  -3.117  1.00  0.00           N  
ATOM    973  CA  TYR A  61      46.291  59.344  -4.030  1.00  0.00           C  
ATOM    974  C   TYR A  61      45.576  60.690  -4.102  1.00  0.00           C  
ATOM    975  O   TYR A  61      44.947  61.124  -3.137  1.00  0.00           O  
ATOM    976  CB  TYR A  61      45.311  58.257  -3.586  1.00  0.00           C  
ATOM    977  CG  TYR A  61      43.886  58.510  -4.025  1.00  0.00           C  
ATOM    978  CD1 TYR A  61      43.523  58.415  -5.362  1.00  0.00           C  
ATOM    979  CD2 TYR A  61      42.903  58.845  -3.101  1.00  0.00           C  
ATOM    980  CE1 TYR A  61      42.223  58.645  -5.768  1.00  0.00           C  
ATOM    981  CE2 TYR A  61      41.600  59.077  -3.498  1.00  0.00           C  
ATOM    982  CZ  TYR A  61      41.265  58.976  -4.832  1.00  0.00           C  
ATOM    983  OH  TYR A  61      39.968  59.207  -5.231  1.00  0.00           O  
ATOM    984  H   TYR A  61      47.261  59.457  -2.153  1.00  0.00           H  
ATOM    985  HA  TYR A  61      46.667  59.096  -5.012  1.00  0.00           H  
ATOM    986  HB2 TYR A  61      45.622  57.311  -4.001  1.00  0.00           H  
ATOM    987  HB3 TYR A  61      45.320  58.192  -2.508  1.00  0.00           H  
ATOM    988  HD1 TYR A  61      44.275  58.155  -6.094  1.00  0.00           H  
ATOM    989  HD2 TYR A  61      43.170  58.925  -2.058  1.00  0.00           H  
ATOM    990  HE1 TYR A  61      41.959  58.565  -6.812  1.00  0.00           H  
ATOM    991  HE2 TYR A  61      40.850  59.336  -2.765  1.00  0.00           H  
ATOM    992  HH  TYR A  61      39.749  58.622  -5.959  1.00  0.00           H  
ATOM    993  N   ASP A  62      45.677  61.346  -5.252  1.00  0.00           N  
ATOM    994  CA  ASP A  62      45.040  62.642  -5.453  1.00  0.00           C  
ATOM    995  C   ASP A  62      44.006  62.571  -6.572  1.00  0.00           C  
ATOM    996  O   ASP A  62      44.176  61.832  -7.541  1.00  0.00           O  
ATOM    997  CB  ASP A  62      46.089  63.706  -5.778  1.00  0.00           C  
ATOM    998  CG  ASP A  62      47.083  63.238  -6.824  1.00  0.00           C  
ATOM    999  OD1 ASP A  62      46.669  62.517  -7.756  1.00  0.00           O  
ATOM   1000  OD2 ASP A  62      48.274  63.595  -6.711  1.00  0.00           O  
ATOM   1001  H   ASP A  62      46.193  60.948  -5.986  1.00  0.00           H  
ATOM   1002  HA  ASP A  62      44.540  62.911  -4.535  1.00  0.00           H  
ATOM   1003  HB2 ASP A  62      45.593  64.590  -6.151  1.00  0.00           H  
ATOM   1004  HB3 ASP A  62      46.632  63.954  -4.878  1.00  0.00           H  
ATOM   1005  N   GLU A  63      42.934  63.344  -6.431  1.00  0.00           N  
ATOM   1006  CA  GLU A  63      41.872  63.367  -7.430  1.00  0.00           C  
ATOM   1007  C   GLU A  63      41.123  64.697  -7.397  1.00  0.00           C  
ATOM   1008  O   GLU A  63      40.832  65.230  -6.328  1.00  0.00           O  
ATOM   1009  CB  GLU A  63      40.895  62.214  -7.195  1.00  0.00           C  
ATOM   1010  CG  GLU A  63      39.541  62.416  -7.856  1.00  0.00           C  
ATOM   1011  CD  GLU A  63      38.724  61.141  -7.915  1.00  0.00           C  
ATOM   1012  OE1 GLU A  63      39.105  60.226  -8.673  1.00  0.00           O  
ATOM   1013  OE2 GLU A  63      37.702  61.059  -7.199  1.00  0.00           O  
ATOM   1014  H   GLU A  63      42.855  63.912  -5.636  1.00  0.00           H  
ATOM   1015  HA  GLU A  63      42.327  63.248  -8.401  1.00  0.00           H  
ATOM   1016  HB2 GLU A  63      41.330  61.304  -7.583  1.00  0.00           H  
ATOM   1017  HB3 GLU A  63      40.739  62.102  -6.132  1.00  0.00           H  
ATOM   1018  HG2 GLU A  63      38.989  63.155  -7.296  1.00  0.00           H  
ATOM   1019  HG3 GLU A  63      39.698  62.773  -8.863  1.00  0.00           H  
ATOM   1020  N   TRP A  64      40.815  65.225  -8.577  1.00  0.00           N  
ATOM   1021  CA  TRP A  64      40.101  66.492  -8.684  1.00  0.00           C  
ATOM   1022  C   TRP A  64      38.657  66.343  -8.218  1.00  0.00           C  
ATOM   1023  O   TRP A  64      37.928  65.473  -8.694  1.00  0.00           O  
ATOM   1024  CB  TRP A  64      40.134  66.998 -10.127  1.00  0.00           C  
ATOM   1025  CG  TRP A  64      41.504  67.399 -10.585  1.00  0.00           C  
ATOM   1026  CD1 TRP A  64      42.483  66.574 -11.059  1.00  0.00           C  
ATOM   1027  CD2 TRP A  64      42.046  68.723 -10.608  1.00  0.00           C  
ATOM   1028  NE1 TRP A  64      43.602  67.305 -11.377  1.00  0.00           N  
ATOM   1029  CE2 TRP A  64      43.359  68.628 -11.110  1.00  0.00           C  
ATOM   1030  CE3 TRP A  64      41.551  69.982 -10.257  1.00  0.00           C  
ATOM   1031  CZ2 TRP A  64      44.179  69.741 -11.267  1.00  0.00           C  
ATOM   1032  CZ3 TRP A  64      42.366  71.086 -10.412  1.00  0.00           C  
ATOM   1033  CH2 TRP A  64      43.668  70.961 -10.914  1.00  0.00           C  
ATOM   1034  H   TRP A  64      41.075  64.751  -9.395  1.00  0.00           H  
ATOM   1035  HA  TRP A  64      40.601  67.207  -8.049  1.00  0.00           H  
ATOM   1036  HB2 TRP A  64      39.777  66.219 -10.785  1.00  0.00           H  
ATOM   1037  HB3 TRP A  64      39.488  67.860 -10.212  1.00  0.00           H  
ATOM   1038  HD1 TRP A  64      42.380  65.504 -11.162  1.00  0.00           H  
ATOM   1039  HE1 TRP A  64      44.437  66.940 -11.738  1.00  0.00           H  
ATOM   1040  HE3 TRP A  64      40.550  70.099  -9.868  1.00  0.00           H  
ATOM   1041  HZ2 TRP A  64      45.185  69.662 -11.653  1.00  0.00           H  
ATOM   1042  HZ3 TRP A  64      42.000  72.067 -10.145  1.00  0.00           H  
ATOM   1043  HH2 TRP A  64      44.270  71.851 -11.019  1.00  0.00           H  
ATOM   1044  N   ILE A  65      38.251  67.198  -7.285  1.00  0.00           N  
ATOM   1045  CA  ILE A  65      36.894  67.162  -6.755  1.00  0.00           C  
ATOM   1046  C   ILE A  65      36.218  68.523  -6.882  1.00  0.00           C  
ATOM   1047  O   ILE A  65      36.653  69.502  -6.276  1.00  0.00           O  
ATOM   1048  CB  ILE A  65      36.877  66.728  -5.278  1.00  0.00           C  
ATOM   1049  CG1 ILE A  65      37.504  65.341  -5.122  1.00  0.00           C  
ATOM   1050  CG2 ILE A  65      35.453  66.735  -4.739  1.00  0.00           C  
ATOM   1051  CD1 ILE A  65      37.524  64.843  -3.695  1.00  0.00           C  
ATOM   1052  H   ILE A  65      38.879  67.868  -6.944  1.00  0.00           H  
ATOM   1053  HA  ILE A  65      36.332  66.438  -7.328  1.00  0.00           H  
ATOM   1054  HB  ILE A  65      37.453  67.442  -4.709  1.00  0.00           H  
ATOM   1055 HG12 ILE A  65      36.945  64.633  -5.713  1.00  0.00           H  
ATOM   1056 HG13 ILE A  65      38.524  65.374  -5.478  1.00  0.00           H  
ATOM   1057 HG21 ILE A  65      34.981  67.675  -4.984  1.00  0.00           H  
ATOM   1058 HG22 ILE A  65      34.896  65.926  -5.187  1.00  0.00           H  
ATOM   1059 HG23 ILE A  65      35.473  66.609  -3.667  1.00  0.00           H  
ATOM   1060 HD11 ILE A  65      36.638  64.253  -3.507  1.00  0.00           H  
ATOM   1061 HD12 ILE A  65      38.401  64.233  -3.538  1.00  0.00           H  
ATOM   1062 HD13 ILE A  65      37.545  65.686  -3.019  1.00  0.00           H  
ATOM   1063  N   TYR A  66      35.151  68.576  -7.672  1.00  0.00           N  
ATOM   1064  CA  TYR A  66      34.415  69.818  -7.878  1.00  0.00           C  
ATOM   1065  C   TYR A  66      34.201  70.551  -6.558  1.00  0.00           C  
ATOM   1066  O   TYR A  66      33.557  70.033  -5.645  1.00  0.00           O  
ATOM   1067  CB  TYR A  66      33.066  69.531  -8.540  1.00  0.00           C  
ATOM   1068  CG  TYR A  66      33.182  69.027  -9.960  1.00  0.00           C  
ATOM   1069  CD1 TYR A  66      34.002  69.670 -10.881  1.00  0.00           C  
ATOM   1070  CD2 TYR A  66      32.473  67.910 -10.384  1.00  0.00           C  
ATOM   1071  CE1 TYR A  66      34.111  69.214 -12.180  1.00  0.00           C  
ATOM   1072  CE2 TYR A  66      32.577  67.446 -11.680  1.00  0.00           C  
ATOM   1073  CZ  TYR A  66      33.397  68.102 -12.575  1.00  0.00           C  
ATOM   1074  OH  TYR A  66      33.503  67.645 -13.869  1.00  0.00           O  
ATOM   1075  H   TYR A  66      34.852  67.762  -8.128  1.00  0.00           H  
ATOM   1076  HA  TYR A  66      34.999  70.445  -8.535  1.00  0.00           H  
ATOM   1077  HB2 TYR A  66      32.543  68.781  -7.965  1.00  0.00           H  
ATOM   1078  HB3 TYR A  66      32.480  70.438  -8.555  1.00  0.00           H  
ATOM   1079  HD1 TYR A  66      34.560  70.541 -10.569  1.00  0.00           H  
ATOM   1080  HD2 TYR A  66      31.831  67.399  -9.680  1.00  0.00           H  
ATOM   1081  HE1 TYR A  66      34.754  69.727 -12.881  1.00  0.00           H  
ATOM   1082  HE2 TYR A  66      32.018  66.576 -11.991  1.00  0.00           H  
ATOM   1083  HH  TYR A  66      34.245  67.039 -13.934  1.00  0.00           H  
ATOM   1084  N   TRP A  67      34.744  71.759  -6.465  1.00  0.00           N  
ATOM   1085  CA  TRP A  67      34.613  72.565  -5.257  1.00  0.00           C  
ATOM   1086  C   TRP A  67      33.149  72.879  -4.969  1.00  0.00           C  
ATOM   1087  O   TRP A  67      32.817  73.421  -3.913  1.00  0.00           O  
ATOM   1088  CB  TRP A  67      35.408  73.864  -5.397  1.00  0.00           C  
ATOM   1089  CG  TRP A  67      35.051  74.650  -6.623  1.00  0.00           C  
ATOM   1090  CD1 TRP A  67      34.232  74.253  -7.640  1.00  0.00           C  
ATOM   1091  CD2 TRP A  67      35.506  75.964  -6.960  1.00  0.00           C  
ATOM   1092  NE1 TRP A  67      34.149  75.243  -8.590  1.00  0.00           N  
ATOM   1093  CE2 TRP A  67      34.920  76.303  -8.196  1.00  0.00           C  
ATOM   1094  CE3 TRP A  67      36.348  76.890  -6.338  1.00  0.00           C  
ATOM   1095  CZ2 TRP A  67      35.153  77.526  -8.819  1.00  0.00           C  
ATOM   1096  CZ3 TRP A  67      36.578  78.104  -6.958  1.00  0.00           C  
ATOM   1097  CH2 TRP A  67      35.982  78.414  -8.188  1.00  0.00           C  
ATOM   1098  H   TRP A  67      35.246  72.118  -7.227  1.00  0.00           H  
ATOM   1099  HA  TRP A  67      35.016  71.994  -4.433  1.00  0.00           H  
ATOM   1100  HB2 TRP A  67      35.221  74.488  -4.536  1.00  0.00           H  
ATOM   1101  HB3 TRP A  67      36.461  73.629  -5.446  1.00  0.00           H  
ATOM   1102  HD1 TRP A  67      33.730  73.298  -7.680  1.00  0.00           H  
ATOM   1103  HE1 TRP A  67      33.620  75.197  -9.415  1.00  0.00           H  
ATOM   1104  HE3 TRP A  67      36.817  76.670  -5.391  1.00  0.00           H  
ATOM   1105  HZ2 TRP A  67      34.700  77.781  -9.767  1.00  0.00           H  
ATOM   1106  HZ3 TRP A  67      37.227  78.830  -6.492  1.00  0.00           H  
ATOM   1107  HH2 TRP A  67      36.190  79.373  -8.635  1.00  0.00           H  
ATOM   1108  N   ASP A  68      32.278  72.536  -5.911  1.00  0.00           N  
ATOM   1109  CA  ASP A  68      30.849  72.780  -5.757  1.00  0.00           C  
ATOM   1110  C   ASP A  68      30.097  71.475  -5.522  1.00  0.00           C  
ATOM   1111  O   ASP A  68      28.887  71.396  -5.736  1.00  0.00           O  
ATOM   1112  CB  ASP A  68      30.295  73.488  -6.994  1.00  0.00           C  
ATOM   1113  CG  ASP A  68      28.789  73.660  -6.936  1.00  0.00           C  
ATOM   1114  OD1 ASP A  68      28.275  74.038  -5.862  1.00  0.00           O  
ATOM   1115  OD2 ASP A  68      28.125  73.419  -7.965  1.00  0.00           O  
ATOM   1116  H   ASP A  68      32.604  72.107  -6.730  1.00  0.00           H  
ATOM   1117  HA  ASP A  68      30.712  73.419  -4.897  1.00  0.00           H  
ATOM   1118  HB2 ASP A  68      30.747  74.466  -7.075  1.00  0.00           H  
ATOM   1119  HB3 ASP A  68      30.539  72.908  -7.872  1.00  0.00           H  
ATOM   1120  N   SER A  69      30.821  70.452  -5.081  1.00  0.00           N  
ATOM   1121  CA  SER A  69      30.223  69.147  -4.821  1.00  0.00           C  
ATOM   1122  C   SER A  69      29.513  69.133  -3.471  1.00  0.00           C  
ATOM   1123  O   SER A  69      28.544  68.401  -3.275  1.00  0.00           O  
ATOM   1124  CB  SER A  69      31.294  68.055  -4.858  1.00  0.00           C  
ATOM   1125  OG  SER A  69      30.740  66.811  -5.248  1.00  0.00           O  
ATOM   1126  H   SER A  69      31.781  70.576  -4.929  1.00  0.00           H  
ATOM   1127  HA  SER A  69      29.498  68.954  -5.598  1.00  0.00           H  
ATOM   1128  HB2 SER A  69      32.061  68.331  -5.565  1.00  0.00           H  
ATOM   1129  HB3 SER A  69      31.730  67.950  -3.875  1.00  0.00           H  
ATOM   1130  HG  SER A  69      30.602  66.804  -6.198  1.00  0.00           H  
ATOM   1131  N   ASN A  70      30.004  69.949  -2.544  1.00  0.00           N  
ATOM   1132  CA  ASN A  70      29.418  70.031  -1.211  1.00  0.00           C  
ATOM   1133  C   ASN A  70      29.647  68.738  -0.434  1.00  0.00           C  
ATOM   1134  O   ASN A  70      28.825  68.344   0.393  1.00  0.00           O  
ATOM   1135  CB  ASN A  70      27.918  70.322  -1.307  1.00  0.00           C  
ATOM   1136  CG  ASN A  70      27.615  71.499  -2.214  1.00  0.00           C  
ATOM   1137  OD1 ASN A  70      28.156  72.590  -2.034  1.00  0.00           O  
ATOM   1138  ND2 ASN A  70      26.745  71.282  -3.194  1.00  0.00           N  
ATOM   1139  H   ASN A  70      30.779  70.509  -2.760  1.00  0.00           H  
ATOM   1140  HA  ASN A  70      29.899  70.843  -0.686  1.00  0.00           H  
ATOM   1141  HB2 ASN A  70      27.414  69.451  -1.700  1.00  0.00           H  
ATOM   1142  HB3 ASN A  70      27.536  70.542  -0.321  1.00  0.00           H  
ATOM   1143 HD21 ASN A  70      26.354  70.388  -3.276  1.00  0.00           H  
ATOM   1144 HD22 ASN A  70      26.531  72.026  -3.794  1.00  0.00           H  
ATOM   1145  N   ARG A  71      30.771  68.083  -0.707  1.00  0.00           N  
ATOM   1146  CA  ARG A  71      31.109  66.834  -0.035  1.00  0.00           C  
ATOM   1147  C   ARG A  71      32.340  67.008   0.851  1.00  0.00           C  
ATOM   1148  O   ARG A  71      32.998  66.034   1.216  1.00  0.00           O  
ATOM   1149  CB  ARG A  71      31.361  65.729  -1.063  1.00  0.00           C  
ATOM   1150  CG  ARG A  71      30.213  65.535  -2.041  1.00  0.00           C  
ATOM   1151  CD  ARG A  71      30.646  64.722  -3.251  1.00  0.00           C  
ATOM   1152  NE  ARG A  71      29.554  64.536  -4.204  1.00  0.00           N  
ATOM   1153  CZ  ARG A  71      29.531  63.570  -5.116  1.00  0.00           C  
ATOM   1154  NH1 ARG A  71      30.535  62.708  -5.199  1.00  0.00           N  
ATOM   1155  NH2 ARG A  71      28.503  63.466  -5.947  1.00  0.00           N  
ATOM   1156  H   ARG A  71      31.388  68.447  -1.376  1.00  0.00           H  
ATOM   1157  HA  ARG A  71      30.271  66.553   0.586  1.00  0.00           H  
ATOM   1158  HB2 ARG A  71      32.248  65.972  -1.627  1.00  0.00           H  
ATOM   1159  HB3 ARG A  71      31.520  64.797  -0.540  1.00  0.00           H  
ATOM   1160  HG2 ARG A  71      29.409  65.017  -1.541  1.00  0.00           H  
ATOM   1161  HG3 ARG A  71      29.869  66.503  -2.374  1.00  0.00           H  
ATOM   1162  HD2 ARG A  71      31.456  65.236  -3.744  1.00  0.00           H  
ATOM   1163  HD3 ARG A  71      30.986  63.754  -2.914  1.00  0.00           H  
ATOM   1164  HE  ARG A  71      28.803  65.162  -4.160  1.00  0.00           H  
ATOM   1165 HH11 ARG A  71      31.311  62.783  -4.572  1.00  0.00           H  
ATOM   1166 HH12 ARG A  71      30.515  61.981  -5.885  1.00  0.00           H  
ATOM   1167 HH21 ARG A  71      27.744  64.115  -5.889  1.00  0.00           H  
ATOM   1168 HH22 ARG A  71      28.487  62.739  -6.634  1.00  0.00           H  
ATOM   1169  N   LEU A  72      32.643  68.256   1.193  1.00  0.00           N  
ATOM   1170  CA  LEU A  72      33.795  68.559   2.035  1.00  0.00           C  
ATOM   1171  C   LEU A  72      33.359  69.247   3.325  1.00  0.00           C  
ATOM   1172  O   LEU A  72      32.373  69.985   3.344  1.00  0.00           O  
ATOM   1173  CB  LEU A  72      34.785  69.447   1.279  1.00  0.00           C  
ATOM   1174  CG  LEU A  72      34.986  69.119  -0.200  1.00  0.00           C  
ATOM   1175  CD1 LEU A  72      35.334  70.375  -0.983  1.00  0.00           C  
ATOM   1176  CD2 LEU A  72      36.070  68.064  -0.371  1.00  0.00           C  
ATOM   1177  H   LEU A  72      32.081  68.990   0.871  1.00  0.00           H  
ATOM   1178  HA  LEU A  72      34.277  67.626   2.285  1.00  0.00           H  
ATOM   1179  HB2 LEU A  72      34.435  70.465   1.348  1.00  0.00           H  
ATOM   1180  HB3 LEU A  72      35.744  69.363   1.771  1.00  0.00           H  
ATOM   1181  HG  LEU A  72      34.065  68.720  -0.603  1.00  0.00           H  
ATOM   1182 HD11 LEU A  72      35.604  71.164  -0.297  1.00  0.00           H  
ATOM   1183 HD12 LEU A  72      34.481  70.683  -1.568  1.00  0.00           H  
ATOM   1184 HD13 LEU A  72      36.167  70.170  -1.642  1.00  0.00           H  
ATOM   1185 HD21 LEU A  72      35.701  67.266  -0.997  1.00  0.00           H  
ATOM   1186 HD22 LEU A  72      36.340  67.667   0.596  1.00  0.00           H  
ATOM   1187 HD23 LEU A  72      36.939  68.512  -0.832  1.00  0.00           H  
ATOM   1188  N   ARG A  73      34.101  69.004   4.400  1.00  0.00           N  
ATOM   1189  CA  ARG A  73      33.793  69.601   5.694  1.00  0.00           C  
ATOM   1190  C   ARG A  73      34.992  70.374   6.235  1.00  0.00           C  
ATOM   1191  O   ARG A  73      36.144  70.084   5.915  1.00  0.00           O  
ATOM   1192  CB  ARG A  73      33.375  68.520   6.692  1.00  0.00           C  
ATOM   1193  CG  ARG A  73      34.419  67.432   6.883  1.00  0.00           C  
ATOM   1194  CD  ARG A  73      33.878  66.281   7.717  1.00  0.00           C  
ATOM   1195  NE  ARG A  73      33.899  66.582   9.146  1.00  0.00           N  
ATOM   1196  CZ  ARG A  73      32.934  67.249   9.770  1.00  0.00           C  
ATOM   1197  NH1 ARG A  73      31.878  67.681   9.095  1.00  0.00           N  
ATOM   1198  NH2 ARG A  73      33.025  67.484  11.073  1.00  0.00           N  
ATOM   1199  H   ARG A  73      34.875  68.407   4.322  1.00  0.00           H  
ATOM   1200  HA  ARG A  73      32.971  70.287   5.555  1.00  0.00           H  
ATOM   1201  HB2 ARG A  73      33.190  68.983   7.650  1.00  0.00           H  
ATOM   1202  HB3 ARG A  73      32.465  68.057   6.342  1.00  0.00           H  
ATOM   1203  HG2 ARG A  73      34.714  67.054   5.916  1.00  0.00           H  
ATOM   1204  HG3 ARG A  73      35.278  67.855   7.383  1.00  0.00           H  
ATOM   1205  HD2 ARG A  73      32.861  66.083   7.415  1.00  0.00           H  
ATOM   1206  HD3 ARG A  73      34.484  65.406   7.533  1.00  0.00           H  
ATOM   1207  HE  ARG A  73      34.669  66.272   9.664  1.00  0.00           H  
ATOM   1208 HH11 ARG A  73      31.808  67.505   8.113  1.00  0.00           H  
ATOM   1209 HH12 ARG A  73      31.153  68.183   9.567  1.00  0.00           H  
ATOM   1210 HH21 ARG A  73      33.819  67.160  11.585  1.00  0.00           H  
ATOM   1211 HH22 ARG A  73      32.298  67.987  11.541  1.00  0.00           H  
ATOM   1212  N   PRO A  74      34.715  71.381   7.076  1.00  0.00           N  
ATOM   1213  CA  PRO A  74      35.758  72.216   7.681  1.00  0.00           C  
ATOM   1214  C   PRO A  74      36.586  71.455   8.710  1.00  0.00           C  
ATOM   1215  O   PRO A  74      36.183  71.312   9.865  1.00  0.00           O  
ATOM   1216  CB  PRO A  74      34.966  73.338   8.357  1.00  0.00           C  
ATOM   1217  CG  PRO A  74      33.625  72.747   8.627  1.00  0.00           C  
ATOM   1218  CD  PRO A  74      33.364  71.783   7.502  1.00  0.00           C  
ATOM   1219  HA  PRO A  74      36.413  72.636   6.933  1.00  0.00           H  
ATOM   1220  HB2 PRO A  74      35.461  73.632   9.272  1.00  0.00           H  
ATOM   1221  HB3 PRO A  74      34.896  74.186   7.692  1.00  0.00           H  
ATOM   1222  HG2 PRO A  74      33.638  72.225   9.572  1.00  0.00           H  
ATOM   1223  HG3 PRO A  74      32.876  73.524   8.635  1.00  0.00           H  
ATOM   1224  HD2 PRO A  74      32.803  70.932   7.858  1.00  0.00           H  
ATOM   1225  HD3 PRO A  74      32.837  72.275   6.698  1.00  0.00           H  
ATOM   1226  N   LEU A  75      37.747  70.967   8.285  1.00  0.00           N  
ATOM   1227  CA  LEU A  75      38.633  70.220   9.170  1.00  0.00           C  
ATOM   1228  C   LEU A  75      39.014  71.054  10.390  1.00  0.00           C  
ATOM   1229  O   LEU A  75      39.049  72.282  10.326  1.00  0.00           O  
ATOM   1230  CB  LEU A  75      39.894  69.791   8.418  1.00  0.00           C  
ATOM   1231  CG  LEU A  75      41.013  69.192   9.270  1.00  0.00           C  
ATOM   1232  CD1 LEU A  75      40.765  67.710   9.512  1.00  0.00           C  
ATOM   1233  CD2 LEU A  75      42.364  69.406   8.603  1.00  0.00           C  
ATOM   1234  H   LEU A  75      38.014  71.112   7.354  1.00  0.00           H  
ATOM   1235  HA  LEU A  75      38.104  69.340   9.502  1.00  0.00           H  
ATOM   1236  HB2 LEU A  75      39.606  69.053   7.684  1.00  0.00           H  
ATOM   1237  HB3 LEU A  75      40.290  70.661   7.913  1.00  0.00           H  
ATOM   1238  HG  LEU A  75      41.030  69.687  10.231  1.00  0.00           H  
ATOM   1239 HD11 LEU A  75      41.698  67.224   9.749  1.00  0.00           H  
ATOM   1240 HD12 LEU A  75      40.343  67.266   8.622  1.00  0.00           H  
ATOM   1241 HD13 LEU A  75      40.076  67.590  10.335  1.00  0.00           H  
ATOM   1242 HD21 LEU A  75      42.375  70.367   8.113  1.00  0.00           H  
ATOM   1243 HD22 LEU A  75      42.533  68.628   7.874  1.00  0.00           H  
ATOM   1244 HD23 LEU A  75      43.143  69.372   9.351  1.00  0.00           H  
ATOM   1245  N   GLU A  76      39.301  70.376  11.497  1.00  0.00           N  
ATOM   1246  CA  GLU A  76      39.680  71.055  12.730  1.00  0.00           C  
ATOM   1247  C   GLU A  76      40.652  72.197  12.445  1.00  0.00           C  
ATOM   1248  O   GLU A  76      41.678  72.005  11.794  1.00  0.00           O  
ATOM   1249  CB  GLU A  76      40.314  70.064  13.710  1.00  0.00           C  
ATOM   1250  CG  GLU A  76      39.322  69.079  14.304  1.00  0.00           C  
ATOM   1251  CD  GLU A  76      38.183  69.764  15.034  1.00  0.00           C  
ATOM   1252  OE1 GLU A  76      38.429  70.326  16.121  1.00  0.00           O  
ATOM   1253  OE2 GLU A  76      37.047  69.739  14.518  1.00  0.00           O  
ATOM   1254  H   GLU A  76      39.255  69.398  11.484  1.00  0.00           H  
ATOM   1255  HA  GLU A  76      38.784  71.463  13.173  1.00  0.00           H  
ATOM   1256  HB2 GLU A  76      41.080  69.506  13.193  1.00  0.00           H  
ATOM   1257  HB3 GLU A  76      40.768  70.618  14.518  1.00  0.00           H  
ATOM   1258  HG2 GLU A  76      38.909  68.479  13.507  1.00  0.00           H  
ATOM   1259  HG3 GLU A  76      39.844  68.439  15.001  1.00  0.00           H  
ATOM   1260  N   ARG A  77      40.319  73.385  12.938  1.00  0.00           N  
ATOM   1261  CA  ARG A  77      41.160  74.559  12.736  1.00  0.00           C  
ATOM   1262  C   ARG A  77      42.440  74.459  13.559  1.00  0.00           C  
ATOM   1263  O   ARG A  77      42.460  73.899  14.656  1.00  0.00           O  
ATOM   1264  CB  ARG A  77      40.397  75.831  13.111  1.00  0.00           C  
ATOM   1265  CG  ARG A  77      40.401  76.125  14.603  1.00  0.00           C  
ATOM   1266  CD  ARG A  77      39.546  77.338  14.933  1.00  0.00           C  
ATOM   1267  NE  ARG A  77      39.754  77.797  16.304  1.00  0.00           N  
ATOM   1268  CZ  ARG A  77      39.189  77.228  17.363  1.00  0.00           C  
ATOM   1269  NH1 ARG A  77      38.386  76.185  17.210  1.00  0.00           N  
ATOM   1270  NH2 ARG A  77      39.426  77.703  18.579  1.00  0.00           N  
ATOM   1271  H   ARG A  77      39.488  73.476  13.449  1.00  0.00           H  
ATOM   1272  HA  ARG A  77      41.421  74.603  11.689  1.00  0.00           H  
ATOM   1273  HB2 ARG A  77      40.846  76.670  12.601  1.00  0.00           H  
ATOM   1274  HB3 ARG A  77      39.371  75.729  12.789  1.00  0.00           H  
ATOM   1275  HG2 ARG A  77      40.008  75.268  15.130  1.00  0.00           H  
ATOM   1276  HG3 ARG A  77      41.415  76.312  14.921  1.00  0.00           H  
ATOM   1277  HD2 ARG A  77      39.802  78.138  14.255  1.00  0.00           H  
ATOM   1278  HD3 ARG A  77      38.507  77.076  14.805  1.00  0.00           H  
ATOM   1279  HE  ARG A  77      40.344  78.567  16.441  1.00  0.00           H  
ATOM   1280 HH11 ARG A  77      38.205  75.824  16.295  1.00  0.00           H  
ATOM   1281 HH12 ARG A  77      37.962  75.757  18.009  1.00  0.00           H  
ATOM   1282 HH21 ARG A  77      40.031  78.489  18.700  1.00  0.00           H  
ATOM   1283 HH22 ARG A  77      39.000  77.274  19.375  1.00  0.00           H  
ATOM   1284  N   PRO A  78      43.537  75.013  13.019  1.00  0.00           N  
ATOM   1285  CA  PRO A  78      44.841  74.998  13.687  1.00  0.00           C  
ATOM   1286  C   PRO A  78      44.872  75.899  14.918  1.00  0.00           C  
ATOM   1287  O   PRO A  78      43.843  76.429  15.337  1.00  0.00           O  
ATOM   1288  CB  PRO A  78      45.795  75.528  12.613  1.00  0.00           C  
ATOM   1289  CG  PRO A  78      44.938  76.354  11.719  1.00  0.00           C  
ATOM   1290  CD  PRO A  78      43.586  75.696  11.716  1.00  0.00           C  
ATOM   1291  HA  PRO A  78      45.132  73.997  13.969  1.00  0.00           H  
ATOM   1292  HB2 PRO A  78      46.571  76.121  13.078  1.00  0.00           H  
ATOM   1293  HB3 PRO A  78      46.237  74.699  12.081  1.00  0.00           H  
ATOM   1294  HG2 PRO A  78      44.865  77.359  12.107  1.00  0.00           H  
ATOM   1295  HG3 PRO A  78      45.351  76.365  10.722  1.00  0.00           H  
ATOM   1296  HD2 PRO A  78      42.805  76.438  11.640  1.00  0.00           H  
ATOM   1297  HD3 PRO A  78      43.514  74.985  10.906  1.00  0.00           H  
ATOM   1298  N   ALA A  79      46.059  76.069  15.491  1.00  0.00           N  
ATOM   1299  CA  ALA A  79      46.223  76.908  16.672  1.00  0.00           C  
ATOM   1300  C   ALA A  79      46.701  78.305  16.291  1.00  0.00           C  
ATOM   1301  O   ALA A  79      47.814  78.478  15.792  1.00  0.00           O  
ATOM   1302  CB  ALA A  79      47.199  76.263  17.646  1.00  0.00           C  
ATOM   1303  H   ALA A  79      46.842  75.620  15.110  1.00  0.00           H  
ATOM   1304  HA  ALA A  79      45.264  76.987  17.162  1.00  0.00           H  
ATOM   1305  HB1 ALA A  79      46.838  76.392  18.655  1.00  0.00           H  
ATOM   1306  HB2 ALA A  79      47.282  75.209  17.425  1.00  0.00           H  
ATOM   1307  HB3 ALA A  79      48.168  76.729  17.547  1.00  0.00           H  
ATOM   1308  N   LEU A  80      45.852  79.300  16.527  1.00  0.00           N  
ATOM   1309  CA  LEU A  80      46.187  80.683  16.207  1.00  0.00           C  
ATOM   1310  C   LEU A  80      47.311  81.192  17.104  1.00  0.00           C  
ATOM   1311  O   LEU A  80      47.111  81.425  18.296  1.00  0.00           O  
ATOM   1312  CB  LEU A  80      44.954  81.575  16.360  1.00  0.00           C  
ATOM   1313  CG  LEU A  80      44.501  81.853  17.794  1.00  0.00           C  
ATOM   1314  CD1 LEU A  80      45.156  83.119  18.324  1.00  0.00           C  
ATOM   1315  CD2 LEU A  80      42.984  81.967  17.862  1.00  0.00           C  
ATOM   1316  H   LEU A  80      44.980  79.100  16.926  1.00  0.00           H  
ATOM   1317  HA  LEU A  80      46.519  80.714  15.180  1.00  0.00           H  
ATOM   1318  HB2 LEU A  80      45.171  82.523  15.893  1.00  0.00           H  
ATOM   1319  HB3 LEU A  80      44.135  81.098  15.840  1.00  0.00           H  
ATOM   1320  HG  LEU A  80      44.804  81.030  18.427  1.00  0.00           H  
ATOM   1321 HD11 LEU A  80      45.476  82.959  19.343  1.00  0.00           H  
ATOM   1322 HD12 LEU A  80      44.445  83.932  18.294  1.00  0.00           H  
ATOM   1323 HD13 LEU A  80      46.011  83.365  17.712  1.00  0.00           H  
ATOM   1324 HD21 LEU A  80      42.547  81.436  17.030  1.00  0.00           H  
ATOM   1325 HD22 LEU A  80      42.700  83.007  17.816  1.00  0.00           H  
ATOM   1326 HD23 LEU A  80      42.632  81.537  18.789  1.00  0.00           H  
ATOM   1327  N   ARG A  81      48.493  81.364  16.520  1.00  0.00           N  
ATOM   1328  CA  ARG A  81      49.650  81.846  17.266  1.00  0.00           C  
ATOM   1329  C   ARG A  81      49.614  81.348  18.708  1.00  0.00           C  
ATOM   1330  O   ARG A  81      49.695  82.135  19.650  1.00  0.00           O  
ATOM   1331  CB  ARG A  81      49.695  83.376  17.244  1.00  0.00           C  
ATOM   1332  CG  ARG A  81      48.471  84.030  17.865  1.00  0.00           C  
ATOM   1333  CD  ARG A  81      48.814  85.374  18.487  1.00  0.00           C  
ATOM   1334  NE  ARG A  81      49.300  85.236  19.857  1.00  0.00           N  
ATOM   1335  CZ  ARG A  81      48.504  85.052  20.904  1.00  0.00           C  
ATOM   1336  NH1 ARG A  81      47.190  84.983  20.738  1.00  0.00           N  
ATOM   1337  NH2 ARG A  81      49.022  84.934  22.120  1.00  0.00           N  
ATOM   1338  H   ARG A  81      48.591  81.160  15.567  1.00  0.00           H  
ATOM   1339  HA  ARG A  81      50.538  81.462  16.787  1.00  0.00           H  
ATOM   1340  HB2 ARG A  81      50.567  83.706  17.788  1.00  0.00           H  
ATOM   1341  HB3 ARG A  81      49.773  83.707  16.220  1.00  0.00           H  
ATOM   1342  HG2 ARG A  81      47.727  84.180  17.098  1.00  0.00           H  
ATOM   1343  HG3 ARG A  81      48.077  83.379  18.630  1.00  0.00           H  
ATOM   1344  HD2 ARG A  81      49.579  85.848  17.890  1.00  0.00           H  
ATOM   1345  HD3 ARG A  81      47.928  85.991  18.489  1.00  0.00           H  
ATOM   1346  HE  ARG A  81      50.268  85.283  20.002  1.00  0.00           H  
ATOM   1347 HH11 ARG A  81      46.798  85.070  19.823  1.00  0.00           H  
ATOM   1348 HH12 ARG A  81      46.593  84.843  21.529  1.00  0.00           H  
ATOM   1349 HH21 ARG A  81      50.012  84.986  22.249  1.00  0.00           H  
ATOM   1350 HH22 ARG A  81      48.422  84.796  22.908  1.00  0.00           H  
ATOM   1351  N   LYS A  82      49.491  80.035  18.871  1.00  0.00           N  
ATOM   1352  CA  LYS A  82      49.445  79.430  20.197  1.00  0.00           C  
ATOM   1353  C   LYS A  82      50.443  80.101  21.136  1.00  0.00           C  
ATOM   1354  O   LYS A  82      51.549  80.452  20.731  1.00  0.00           O  
ATOM   1355  CB  LYS A  82      49.743  77.932  20.107  1.00  0.00           C  
ATOM   1356  CG  LYS A  82      49.697  77.220  21.448  1.00  0.00           C  
ATOM   1357  CD  LYS A  82      48.268  76.939  21.881  1.00  0.00           C  
ATOM   1358  CE  LYS A  82      48.154  76.842  23.396  1.00  0.00           C  
ATOM   1359  NZ  LYS A  82      46.806  76.374  23.821  1.00  0.00           N  
ATOM   1360  H   LYS A  82      49.431  79.459  18.081  1.00  0.00           H  
ATOM   1361  HA  LYS A  82      48.450  79.568  20.590  1.00  0.00           H  
ATOM   1362  HB2 LYS A  82      49.016  77.471  19.454  1.00  0.00           H  
ATOM   1363  HB3 LYS A  82      50.729  77.797  19.685  1.00  0.00           H  
ATOM   1364  HG2 LYS A  82      50.229  76.283  21.368  1.00  0.00           H  
ATOM   1365  HG3 LYS A  82      50.174  77.843  22.192  1.00  0.00           H  
ATOM   1366  HD2 LYS A  82      47.632  77.740  21.535  1.00  0.00           H  
ATOM   1367  HD3 LYS A  82      47.946  76.005  21.445  1.00  0.00           H  
ATOM   1368  HE2 LYS A  82      48.898  76.148  23.756  1.00  0.00           H  
ATOM   1369  HE3 LYS A  82      48.338  77.818  23.820  1.00  0.00           H  
ATOM   1370  HZ1 LYS A  82      46.847  75.373  24.100  1.00  0.00           H  
ATOM   1371  HZ2 LYS A  82      46.128  76.478  23.039  1.00  0.00           H  
ATOM   1372  HZ3 LYS A  82      46.472  76.934  24.631  1.00  0.00           H  
ATOM   1373  N   GLU A  83      50.041  80.274  22.392  1.00  0.00           N  
ATOM   1374  CA  GLU A  83      50.901  80.903  23.388  1.00  0.00           C  
ATOM   1375  C   GLU A  83      51.965  79.926  23.883  1.00  0.00           C  
ATOM   1376  O   GLU A  83      51.648  78.855  24.398  1.00  0.00           O  
ATOM   1377  CB  GLU A  83      50.068  81.407  24.568  1.00  0.00           C  
ATOM   1378  CG  GLU A  83      49.062  82.481  24.188  1.00  0.00           C  
ATOM   1379  CD  GLU A  83      48.443  83.155  25.397  1.00  0.00           C  
ATOM   1380  OE1 GLU A  83      49.205  83.655  26.250  1.00  0.00           O  
ATOM   1381  OE2 GLU A  83      47.198  83.182  25.489  1.00  0.00           O  
ATOM   1382  H   GLU A  83      49.147  79.973  22.654  1.00  0.00           H  
ATOM   1383  HA  GLU A  83      51.392  81.743  22.920  1.00  0.00           H  
ATOM   1384  HB2 GLU A  83      49.531  80.574  24.996  1.00  0.00           H  
ATOM   1385  HB3 GLU A  83      50.734  81.817  25.314  1.00  0.00           H  
ATOM   1386  HG2 GLU A  83      49.562  83.231  23.594  1.00  0.00           H  
ATOM   1387  HG3 GLU A  83      48.274  82.027  23.604  1.00  0.00           H  
ATOM   1388  N   GLY A  84      53.229  80.305  23.722  1.00  0.00           N  
ATOM   1389  CA  GLY A  84      54.320  79.453  24.155  1.00  0.00           C  
ATOM   1390  C   GLY A  84      54.111  78.002  23.770  1.00  0.00           C  
ATOM   1391  O   GLY A  84      53.863  77.153  24.628  1.00  0.00           O  
ATOM   1392  H   GLY A  84      53.422  81.171  23.304  1.00  0.00           H  
ATOM   1393  HA2 GLY A  84      55.237  79.805  23.708  1.00  0.00           H  
ATOM   1394  HA3 GLY A  84      54.407  79.518  25.230  1.00  0.00           H  
ATOM   1395  N   LEU A  85      54.209  77.715  22.477  1.00  0.00           N  
ATOM   1396  CA  LEU A  85      54.026  76.355  21.978  1.00  0.00           C  
ATOM   1397  C   LEU A  85      54.939  75.379  22.714  1.00  0.00           C  
ATOM   1398  O   LEU A  85      54.481  74.379  23.266  1.00  0.00           O  
ATOM   1399  CB  LEU A  85      54.305  76.300  20.476  1.00  0.00           C  
ATOM   1400  CG  LEU A  85      53.646  75.151  19.712  1.00  0.00           C  
ATOM   1401  CD1 LEU A  85      53.609  75.453  18.222  1.00  0.00           C  
ATOM   1402  CD2 LEU A  85      54.381  73.845  19.976  1.00  0.00           C  
ATOM   1403  H   LEU A  85      54.407  78.432  21.841  1.00  0.00           H  
ATOM   1404  HA  LEU A  85      52.999  76.072  22.157  1.00  0.00           H  
ATOM   1405  HB2 LEU A  85      53.960  77.226  20.041  1.00  0.00           H  
ATOM   1406  HB3 LEU A  85      55.374  76.218  20.342  1.00  0.00           H  
ATOM   1407  HG  LEU A  85      52.627  75.038  20.055  1.00  0.00           H  
ATOM   1408 HD11 LEU A  85      52.789  76.122  18.012  1.00  0.00           H  
ATOM   1409 HD12 LEU A  85      53.473  74.533  17.672  1.00  0.00           H  
ATOM   1410 HD13 LEU A  85      54.538  75.916  17.925  1.00  0.00           H  
ATOM   1411 HD21 LEU A  85      54.252  73.563  21.011  1.00  0.00           H  
ATOM   1412 HD22 LEU A  85      55.432  73.975  19.766  1.00  0.00           H  
ATOM   1413 HD23 LEU A  85      53.979  73.071  19.338  1.00  0.00           H  
ATOM   1414  N   LYS A  86      56.234  75.678  22.717  1.00  0.00           N  
ATOM   1415  CA  LYS A  86      57.213  74.829  23.387  1.00  0.00           C  
ATOM   1416  C   LYS A  86      57.483  75.324  24.804  1.00  0.00           C  
ATOM   1417  O   LYS A  86      56.948  76.349  25.226  1.00  0.00           O  
ATOM   1418  CB  LYS A  86      58.519  74.796  22.590  1.00  0.00           C  
ATOM   1419  CG  LYS A  86      59.166  76.161  22.424  1.00  0.00           C  
ATOM   1420  CD  LYS A  86      60.090  76.485  23.586  1.00  0.00           C  
ATOM   1421  CE  LYS A  86      60.859  77.774  23.343  1.00  0.00           C  
ATOM   1422  NZ  LYS A  86      61.923  77.986  24.364  1.00  0.00           N  
ATOM   1423  H   LYS A  86      56.539  76.489  22.259  1.00  0.00           H  
ATOM   1424  HA  LYS A  86      56.807  73.831  23.437  1.00  0.00           H  
ATOM   1425  HB2 LYS A  86      59.220  74.148  23.096  1.00  0.00           H  
ATOM   1426  HB3 LYS A  86      58.317  74.396  21.607  1.00  0.00           H  
ATOM   1427  HG2 LYS A  86      59.739  76.169  21.509  1.00  0.00           H  
ATOM   1428  HG3 LYS A  86      58.391  76.912  22.373  1.00  0.00           H  
ATOM   1429  HD2 LYS A  86      59.501  76.593  24.484  1.00  0.00           H  
ATOM   1430  HD3 LYS A  86      60.794  75.674  23.711  1.00  0.00           H  
ATOM   1431  HE2 LYS A  86      61.314  77.728  22.365  1.00  0.00           H  
ATOM   1432  HE3 LYS A  86      60.166  78.602  23.380  1.00  0.00           H  
ATOM   1433  HZ1 LYS A  86      61.512  77.962  25.318  1.00  0.00           H  
ATOM   1434  HZ2 LYS A  86      62.380  78.908  24.217  1.00  0.00           H  
ATOM   1435  HZ3 LYS A  86      62.643  77.240  24.289  1.00  0.00           H  
ATOM   1436  N   ASP A  87      58.315  74.590  25.533  1.00  0.00           N  
ATOM   1437  CA  ASP A  87      58.657  74.955  26.903  1.00  0.00           C  
ATOM   1438  C   ASP A  87      60.167  75.108  27.063  1.00  0.00           C  
ATOM   1439  O   ASP A  87      60.643  76.088  27.636  1.00  0.00           O  
ATOM   1440  CB  ASP A  87      58.133  73.902  27.881  1.00  0.00           C  
ATOM   1441  CG  ASP A  87      56.618  73.870  27.938  1.00  0.00           C  
ATOM   1442  OD1 ASP A  87      55.984  73.846  26.862  1.00  0.00           O  
ATOM   1443  OD2 ASP A  87      56.066  73.866  29.058  1.00  0.00           O  
ATOM   1444  H   ASP A  87      58.710  73.783  25.141  1.00  0.00           H  
ATOM   1445  HA  ASP A  87      58.187  75.901  27.121  1.00  0.00           H  
ATOM   1446  HB2 ASP A  87      58.484  72.928  27.574  1.00  0.00           H  
ATOM   1447  HB3 ASP A  87      58.508  74.120  28.869  1.00  0.00           H  
ATOM   1448  N   GLU A  88      60.913  74.133  26.555  1.00  0.00           N  
ATOM   1449  CA  GLU A  88      62.369  74.159  26.644  1.00  0.00           C  
ATOM   1450  C   GLU A  88      62.916  75.511  26.195  1.00  0.00           C  
ATOM   1451  O   GLU A  88      63.517  76.240  26.982  1.00  0.00           O  
ATOM   1452  CB  GLU A  88      62.975  73.043  25.791  1.00  0.00           C  
ATOM   1453  CG  GLU A  88      64.486  73.128  25.661  1.00  0.00           C  
ATOM   1454  CD  GLU A  88      65.014  72.347  24.474  1.00  0.00           C  
ATOM   1455  OE1 GLU A  88      64.917  71.102  24.492  1.00  0.00           O  
ATOM   1456  OE2 GLU A  88      65.525  72.980  23.527  1.00  0.00           O  
ATOM   1457  H   GLU A  88      60.475  73.378  26.110  1.00  0.00           H  
ATOM   1458  HA  GLU A  88      62.641  73.999  27.676  1.00  0.00           H  
ATOM   1459  HB2 GLU A  88      62.725  72.090  26.236  1.00  0.00           H  
ATOM   1460  HB3 GLU A  88      62.546  73.089  24.801  1.00  0.00           H  
ATOM   1461  HG2 GLU A  88      64.767  74.164  25.545  1.00  0.00           H  
ATOM   1462  HG3 GLU A  88      64.934  72.733  26.561  1.00  0.00           H  
TER    1463      GLU A  88                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
