
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   87 ( 1262),  selected   87 , name 2eko_A
# Molecule2: number of CA atoms   62 (  491),  selected   62 , name T0504_1_62.pdb
# PARAMETERS: 2eko_A.T0504_1_62.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      E       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      L       3           -
LGA    G     4_A      Y       4           -
LGA    S     5_A      F       5           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    G     8_A      Q       6           #
LGA    E     9_A      G       7          2.931
LGA    -       -      D       8           -
LGA    I    10_A      L       9          1.487
LGA    I    11_A      I      10          1.108
LGA    E    12_A      V      11          0.851
LGA    G    13_A      S      12          0.988
LGA    C    14_A      M      13          1.223
LGA    R    15_A      R      14          1.315
LGA    L    16_A      I      15          1.255
LGA    P    17_A      L      16          1.069
LGA    V    18_A      G      17          0.647
LGA    L    19_A      K      18          0.979
LGA    R    20_A      K      19          1.378
LGA    R    21_A      R      20          2.704
LGA    N    22_A      T      21          1.969
LGA    Q    23_A      -       -           -
LGA    D    24_A      -       -           -
LGA    N    25_A      -       -           -
LGA    E    26_A      -       -           -
LGA    D    27_A      K      22          1.926
LGA    E    28_A      T      23          0.564
LGA    W    29_A      W      24          0.513
LGA    P    30_A      X      25          0.721
LGA    L    31_A      K      26          0.600
LGA    A    32_A      G      27          1.349
LGA    E    33_A      T      28          0.591
LGA    I    34_A      L      29          0.486
LGA    L    35_A      I      30          0.506
LGA    S    36_A      A      31          0.906
LGA    V    37_A      I      32          0.559
LGA    K    38_A      Q      33          1.132
LGA    D    39_A      T      34          1.091
LGA    I    40_A      V      35          1.386
LGA    S    41_A      G      36          2.390
LGA    G    42_A      P      37          2.405
LGA    R    43_A      G      38          1.517
LGA    K    44_A      K      39          0.954
LGA    L    45_A      K      40          1.090
LGA    F    46_A      Y      41          1.247
LGA    Y    47_A      K      42          1.047
LGA    V    48_A      V      43          0.490
LGA    H    49_A      K      44          0.519
LGA    Y    50_A      F      45          0.786
LGA    I    51_A      D      46          0.603
LGA    D    52_A      N      47          2.581
LGA    F    53_A      -       -           -
LGA    N    54_A      K      48          4.068
LGA    R    55_A      -       -           -
LGA    R    56_A      -       -           -
LGA    L    57_A      G      49          1.817
LGA    D    58_A      K      50          1.635
LGA    E    59_A      S      51          2.049
LGA    W    60_A      L      52          1.122
LGA    V    61_A      L      53          0.956
LGA    T    62_A      S      54          1.201
LGA    H    63_A      G      55          0.438
LGA    E    64_A      N      56          0.547
LGA    R    65_A      X      57          0.806
LGA    L    66_A      I      58          1.344
LGA    D    67_A      A      59          0.767
LGA    L    68_A      Y      60          2.670
LGA    K    69_A      -       -           -
LGA    K    70_A      D      61          2.367
LGA    I    71_A      Y      62          5.251
LGA    Q    72_A      -       -           -
LGA    F    73_A      -       -           -
LGA    P    74_A      -       -           -
LGA    K    75_A      -       -           -
LGA    K    76_A      -       -           -
LGA    E    77_A      -       -           -
LGA    A    78_A      -       -           -
LGA    K    79_A      -       -           -
LGA    T    80_A      -       -           -
LGA    P    81_A      -       -           -
LGA    S    82_A      -       -           -
LGA    G    83_A      -       -           -
LGA    P    84_A      -       -           -
LGA    S    85_A      -       -           -
LGA    S    86_A      -       -           -
LGA    G    87_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   87   62    5.0     55    1.64    10.91     82.668     3.156

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.495924 * X  +  -0.253550 * Y  +   0.830525 * Z  +  39.811543
  Y_new =   0.635760 * X  +  -0.757493 * Y  +   0.148372 * Z  +  69.573051
  Z_new =   0.591497 * X  +   0.601595 * Y  +   0.536856 * Z  +   2.781947 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.842204   -2.299389  [ DEG:    48.2547   -131.7453 ]
  Theta =  -0.632915   -2.508678  [ DEG:   -36.2633   -143.7367 ]
  Phi   =   2.233253   -0.908339  [ DEG:   127.9560    -52.0440 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eko_A                                        
REMARK     2: T0504_1_62.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eko_A.T0504_1_62.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   87   62   5.0   55   1.64   10.91  82.668
REMARK  ---------------------------------------------------------- 
MOLECULE 2eko_A
HEADER    TRANSFERASE                             23-MAR-07   2EKO              
TITLE     SOLUTION STRUCTURE OF RUH-073, A PSEUDO CHROMO DOMAIN FROM            
TITLE    2 HUMAN CDNA                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HISTONE ACETYLTRANSFERASE HTATIP;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: HISTONE TAIL BINDING DOMAIN, PSEUDO CHROMO                 
COMPND   5 DOMAIN, UNP RESIDUES 5-78;                                           
COMPND   6 SYNONYM: 60 KDA TAT INTERACTIVE PROTEIN, TIP60, HIV-1 TAT            
COMPND   7 INTERACTIVE PROTEIN, CPLA(2)-INTERACTING PROTEIN;                    
COMPND   8 EC: 2.3.1.48, 2.3.1.-;                                               
COMPND   9 ENGINEERED: YES;                                                     
COMPND  10 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050905-08;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    CHROMO DOMAIN, HISTONE TAIL, CHROMATIN ORGANIZATION                   
KEYWDS   2 MODIFIER, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON           
KEYWDS   3 PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                    
KEYWDS   4 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI, TRANSFERASE         
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.Z.M.RUHUL MOMEN,H.HIROTA,F.HAYASHI,S.YOKOYAMA,RIKEN                 
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   25-SEP-07 2EKO    0                                                
JRNL        AUTH   A.Z.M.RUHUL MOMEN,H.HIROTA,F.HAYASHI,S.YOKOYAMA              
JRNL        TITL   SOLUTION STRUCTURE OF RUH-073, A PSEUDO CHROMO               
JRNL        TITL 2 DOMAIN FROM HUMAN CDNA                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EKO A    8    81  UNP    Q92993   TIP60_HUMAN      5     78             
SEQRES   1 A   87  GLY SER SER GLY SER SER GLY GLY GLU ILE ILE GLU GLY          
SEQRES   2 A   87  CYS ARG LEU PRO VAL LEU ARG ARG ASN GLN ASP ASN GLU          
SEQRES   3 A   87  ASP GLU TRP PRO LEU ALA GLU ILE LEU SER VAL LYS ASP          
SEQRES   4 A   87  ILE SER GLY ARG LYS LEU PHE TYR VAL HIS TYR ILE ASP          
SEQRES   5 A   87  PHE ASN ARG ARG LEU ASP GLU TRP VAL THR HIS GLU ARG          
SEQRES   6 A   87  LEU ASP LEU LYS LYS ILE GLN PHE PRO LYS LYS GLU ALA          
SEQRES   7 A   87  LYS THR PRO SER GLY PRO SER SER GLY                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      46.975  93.017   6.015  1.00  0.00           N  
ATOM      2  CA  GLY A   1      45.570  93.056   6.382  1.00  0.00           C  
ATOM      3  C   GLY A   1      44.971  91.647   6.413  1.00  0.00           C  
ATOM      4  O   GLY A   1      45.435  90.758   5.701  1.00  0.00           O  
ATOM      5  H1  GLY A   1      47.557  93.669   6.503  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      45.458  93.523   7.360  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      45.021  93.672   5.670  1.00  0.00           H  
ATOM      8  N   SER A   2      43.953  91.489   7.244  1.00  0.00           N  
ATOM      9  CA  SER A   2      43.287  90.204   7.377  1.00  0.00           C  
ATOM     10  C   SER A   2      42.110  90.323   8.346  1.00  0.00           C  
ATOM     11  O   SER A   2      42.194  91.032   9.348  1.00  0.00           O  
ATOM     12  CB  SER A   2      44.262  89.126   7.854  1.00  0.00           C  
ATOM     13  OG  SER A   2      44.140  87.924   7.099  1.00  0.00           O  
ATOM     14  H   SER A   2      43.582  92.219   7.819  1.00  0.00           H  
ATOM     15  HA  SER A   2      42.935  89.958   6.374  1.00  0.00           H  
ATOM     16  HB3 SER A   2      44.079  88.913   8.907  1.00  0.00           H  
ATOM     17  HG  SER A   2      43.174  87.720   6.934  1.00  0.00           H  
ATOM     18  N   SER A   3      41.039  89.618   8.016  1.00  0.00           N  
ATOM     19  CA  SER A   3      39.846  89.634   8.844  1.00  0.00           C  
ATOM     20  C   SER A   3      39.240  88.231   8.920  1.00  0.00           C  
ATOM     21  O   SER A   3      39.598  87.354   8.134  1.00  0.00           O  
ATOM     22  CB  SER A   3      38.814  90.629   8.307  1.00  0.00           C  
ATOM     23  OG  SER A   3      38.147  90.132   7.150  1.00  0.00           O  
ATOM     24  H   SER A   3      40.977  89.043   7.199  1.00  0.00           H  
ATOM     25  HA  SER A   3      40.182  89.958   9.830  1.00  0.00           H  
ATOM     26  HB3 SER A   3      39.309  91.569   8.063  1.00  0.00           H  
ATOM     27  HG  SER A   3      37.178  90.383   7.180  1.00  0.00           H  
ATOM     28  N   GLY A   4      38.333  88.062   9.871  1.00  0.00           N  
ATOM     29  CA  GLY A   4      37.676  86.781  10.058  1.00  0.00           C  
ATOM     30  C   GLY A   4      36.669  86.512   8.938  1.00  0.00           C  
ATOM     31  O   GLY A   4      35.854  87.373   8.611  1.00  0.00           O  
ATOM     32  H   GLY A   4      38.049  88.780  10.505  1.00  0.00           H  
ATOM     33  HA2 GLY A   4      38.421  85.985  10.081  1.00  0.00           H  
ATOM     34  HA3 GLY A   4      37.165  86.768  11.022  1.00  0.00           H  
ATOM     35  N   SER A   5      36.758  85.313   8.381  1.00  0.00           N  
ATOM     36  CA  SER A   5      35.865  84.920   7.304  1.00  0.00           C  
ATOM     37  C   SER A   5      35.670  83.403   7.313  1.00  0.00           C  
ATOM     38  O   SER A   5      36.560  82.661   7.727  1.00  0.00           O  
ATOM     39  CB  SER A   5      36.403  85.378   5.947  1.00  0.00           C  
ATOM     40  OG  SER A   5      37.761  84.989   5.753  1.00  0.00           O  
ATOM     41  H   SER A   5      37.424  84.618   8.653  1.00  0.00           H  
ATOM     42  HA  SER A   5      34.923  85.429   7.511  1.00  0.00           H  
ATOM     43  HB3 SER A   5      36.323  86.462   5.873  1.00  0.00           H  
ATOM     44  HG  SER A   5      38.282  85.750   5.367  1.00  0.00           H  
ATOM     45  N   SER A   6      34.499  82.986   6.853  1.00  0.00           N  
ATOM     46  CA  SER A   6      34.176  81.571   6.804  1.00  0.00           C  
ATOM     47  C   SER A   6      34.454  81.019   5.403  1.00  0.00           C  
ATOM     48  O   SER A   6      33.797  81.406   4.438  1.00  0.00           O  
ATOM     49  CB  SER A   6      32.716  81.325   7.190  1.00  0.00           C  
ATOM     50  OG  SER A   6      32.596  80.371   8.242  1.00  0.00           O  
ATOM     51  H   SER A   6      33.780  83.596   6.520  1.00  0.00           H  
ATOM     52  HA  SER A   6      34.830  81.099   7.537  1.00  0.00           H  
ATOM     53  HB3 SER A   6      32.165  80.974   6.318  1.00  0.00           H  
ATOM     54  HG  SER A   6      33.108  79.542   8.013  1.00  0.00           H  
ATOM     55  N   GLY A   7      35.430  80.125   5.337  1.00  0.00           N  
ATOM     56  CA  GLY A   7      35.803  79.518   4.071  1.00  0.00           C  
ATOM     57  C   GLY A   7      35.830  80.558   2.950  1.00  0.00           C  
ATOM     58  O   GLY A   7      35.317  80.312   1.858  1.00  0.00           O  
ATOM     59  H   GLY A   7      35.961  79.816   6.126  1.00  0.00           H  
ATOM     60  HA2 GLY A   7      36.784  79.051   4.163  1.00  0.00           H  
ATOM     61  HA3 GLY A   7      35.096  78.725   3.821  1.00  0.00           H  
ATOM     62  N   GLY A   8      36.432  81.696   3.258  1.00  0.00           N  
ATOM     63  CA  GLY A   8      36.531  82.775   2.290  1.00  0.00           C  
ATOM     64  C   GLY A   8      36.784  82.229   0.883  1.00  0.00           C  
ATOM     65  O   GLY A   8      35.877  82.195   0.053  1.00  0.00           O  
ATOM     66  H   GLY A   8      36.846  81.888   4.148  1.00  0.00           H  
ATOM     67  HA2 GLY A   8      35.613  83.361   2.295  1.00  0.00           H  
ATOM     68  HA3 GLY A   8      37.341  83.449   2.572  1.00  0.00           H  
ATOM     69  N   GLU A   9      38.021  81.812   0.658  1.00  0.00           N  
ATOM     70  CA  GLU A   9      38.405  81.269  -0.634  1.00  0.00           C  
ATOM     71  C   GLU A   9      39.293  80.037  -0.448  1.00  0.00           C  
ATOM     72  O   GLU A   9      40.253  80.067   0.320  1.00  0.00           O  
ATOM     73  CB  GLU A   9      39.109  82.326  -1.487  1.00  0.00           C  
ATOM     74  CG  GLU A   9      40.586  82.446  -1.106  1.00  0.00           C  
ATOM     75  CD  GLU A   9      41.110  83.858  -1.377  1.00  0.00           C  
ATOM     76  OE1 GLU A   9      40.737  84.761  -0.597  1.00  0.00           O  
ATOM     77  OE2 GLU A   9      41.870  84.002  -2.358  1.00  0.00           O  
ATOM     78  H   GLU A   9      38.754  81.844   1.337  1.00  0.00           H  
ATOM     79  HA  GLU A   9      37.471  80.983  -1.117  1.00  0.00           H  
ATOM     80  HB3 GLU A   9      38.616  83.290  -1.356  1.00  0.00           H  
ATOM     81  HG3 GLU A   9      41.172  81.722  -1.672  1.00  0.00           H  
ATOM     82  N   ILE A  10      38.940  78.979  -1.164  1.00  0.00           N  
ATOM     83  CA  ILE A  10      39.691  77.739  -1.088  1.00  0.00           C  
ATOM     84  C   ILE A  10      41.063  77.937  -1.734  1.00  0.00           C  
ATOM     85  O   ILE A  10      41.169  78.050  -2.955  1.00  0.00           O  
ATOM     86  CB  ILE A  10      38.887  76.587  -1.696  1.00  0.00           C  
ATOM     87  CG1 ILE A  10      37.791  76.117  -0.735  1.00  0.00           C  
ATOM     88  CG2 ILE A  10      39.806  75.440  -2.120  1.00  0.00           C  
ATOM     89  CD1 ILE A  10      38.389  75.363   0.454  1.00  0.00           C  
ATOM     90  H   ILE A  10      38.157  78.962  -1.787  1.00  0.00           H  
ATOM     91  HA  ILE A  10      39.837  77.508  -0.033  1.00  0.00           H  
ATOM     92  HB  ILE A  10      38.392  76.952  -2.595  1.00  0.00           H  
ATOM     93 HG13 ILE A  10      37.091  75.471  -1.265  1.00  0.00           H  
ATOM     94 HG21 ILE A  10      40.292  75.693  -3.063  1.00  0.00           H  
ATOM     95 HG22 ILE A  10      40.564  75.278  -1.353  1.00  0.00           H  
ATOM     96 HG23 ILE A  10      39.219  74.530  -2.247  1.00  0.00           H  
ATOM     97 HD11 ILE A  10      39.228  74.755   0.114  1.00  0.00           H  
ATOM     98 HD12 ILE A  10      38.738  76.077   1.199  1.00  0.00           H  
ATOM     99 HD13 ILE A  10      37.630  74.719   0.896  1.00  0.00           H  
ATOM    100  N   ILE A  11      42.081  77.974  -0.888  1.00  0.00           N  
ATOM    101  CA  ILE A  11      43.443  78.158  -1.360  1.00  0.00           C  
ATOM    102  C   ILE A  11      44.200  76.833  -1.251  1.00  0.00           C  
ATOM    103  O   ILE A  11      43.734  75.900  -0.598  1.00  0.00           O  
ATOM    104  CB  ILE A  11      44.116  79.315  -0.620  1.00  0.00           C  
ATOM    105  CG1 ILE A  11      44.475  78.913   0.813  1.00  0.00           C  
ATOM    106  CG2 ILE A  11      43.246  80.573  -0.661  1.00  0.00           C  
ATOM    107  CD1 ILE A  11      45.763  78.087   0.844  1.00  0.00           C  
ATOM    108  H   ILE A  11      41.987  77.881   0.104  1.00  0.00           H  
ATOM    109  HA  ILE A  11      43.388  78.438  -2.412  1.00  0.00           H  
ATOM    110  HB  ILE A  11      45.049  79.552  -1.132  1.00  0.00           H  
ATOM    111 HG13 ILE A  11      43.659  78.337   1.248  1.00  0.00           H  
ATOM    112 HG21 ILE A  11      43.495  81.157  -1.547  1.00  0.00           H  
ATOM    113 HG22 ILE A  11      42.195  80.286  -0.698  1.00  0.00           H  
ATOM    114 HG23 ILE A  11      43.429  81.170   0.233  1.00  0.00           H  
ATOM    115 HD11 ILE A  11      45.519  77.030   0.742  1.00  0.00           H  
ATOM    116 HD12 ILE A  11      46.409  78.392   0.021  1.00  0.00           H  
ATOM    117 HD13 ILE A  11      46.278  78.253   1.790  1.00  0.00           H  
ATOM    118  N   GLU A  12      45.354  76.793  -1.898  1.00  0.00           N  
ATOM    119  CA  GLU A  12      46.181  75.598  -1.882  1.00  0.00           C  
ATOM    120  C   GLU A  12      46.801  75.400  -0.497  1.00  0.00           C  
ATOM    121  O   GLU A  12      47.472  76.293   0.019  1.00  0.00           O  
ATOM    122  CB  GLU A  12      47.262  75.663  -2.963  1.00  0.00           C  
ATOM    123  CG  GLU A  12      46.638  75.790  -4.353  1.00  0.00           C  
ATOM    124  CD  GLU A  12      47.710  76.061  -5.411  1.00  0.00           C  
ATOM    125  OE1 GLU A  12      48.754  75.375  -5.351  1.00  0.00           O  
ATOM    126  OE2 GLU A  12      47.462  76.949  -6.256  1.00  0.00           O  
ATOM    127  H   GLU A  12      45.726  77.556  -2.427  1.00  0.00           H  
ATOM    128  HA  GLU A  12      45.503  74.773  -2.103  1.00  0.00           H  
ATOM    129  HB3 GLU A  12      47.878  74.766  -2.918  1.00  0.00           H  
ATOM    130  HG3 GLU A  12      45.909  76.601  -4.355  1.00  0.00           H  
ATOM    131  N   GLY A  13      46.555  74.227   0.066  1.00  0.00           N  
ATOM    132  CA  GLY A  13      47.081  73.902   1.381  1.00  0.00           C  
ATOM    133  C   GLY A  13      45.950  73.616   2.369  1.00  0.00           C  
ATOM    134  O   GLY A  13      46.125  72.852   3.316  1.00  0.00           O  
ATOM    135  H   GLY A  13      46.009  73.506  -0.361  1.00  0.00           H  
ATOM    136  HA2 GLY A  13      47.735  73.032   1.310  1.00  0.00           H  
ATOM    137  HA3 GLY A  13      47.689  74.729   1.748  1.00  0.00           H  
ATOM    138  N   CYS A  14      44.811  74.244   2.115  1.00  0.00           N  
ATOM    139  CA  CYS A  14      43.649  74.067   2.970  1.00  0.00           C  
ATOM    140  C   CYS A  14      43.389  72.567   3.120  1.00  0.00           C  
ATOM    141  O   CYS A  14      43.473  71.818   2.148  1.00  0.00           O  
ATOM    142  CB  CYS A  14      42.427  74.808   2.424  1.00  0.00           C  
ATOM    143  SG  CYS A  14      42.519  76.580   2.872  1.00  0.00           S  
ATOM    144  H   CYS A  14      44.675  74.864   1.341  1.00  0.00           H  
ATOM    145  HA  CYS A  14      43.898  74.515   3.931  1.00  0.00           H  
ATOM    146  HB3 CYS A  14      41.515  74.368   2.830  1.00  0.00           H  
ATOM    147  HG  CYS A  14      41.235  76.708   3.196  1.00  0.00           H  
ATOM    148  N   ARG A  15      43.076  72.173   4.345  1.00  0.00           N  
ATOM    149  CA  ARG A  15      42.800  70.776   4.636  1.00  0.00           C  
ATOM    150  C   ARG A  15      41.346  70.602   5.076  1.00  0.00           C  
ATOM    151  O   ARG A  15      40.916  71.201   6.061  1.00  0.00           O  
ATOM    152  CB  ARG A  15      43.727  70.250   5.733  1.00  0.00           C  
ATOM    153  CG  ARG A  15      44.981  69.610   5.133  1.00  0.00           C  
ATOM    154  CD  ARG A  15      45.681  68.713   6.156  1.00  0.00           C  
ATOM    155  NE  ARG A  15      47.039  69.229   6.437  1.00  0.00           N  
ATOM    156  CZ  ARG A  15      47.301  70.226   7.294  1.00  0.00           C  
ATOM    157  NH1 ARG A  15      46.300  70.819   7.958  1.00  0.00           N  
ATOM    158  NH2 ARG A  15      48.563  70.629   7.486  1.00  0.00           N  
ATOM    159  H   ARG A  15      43.008  72.789   5.131  1.00  0.00           H  
ATOM    160  HA  ARG A  15      42.991  70.254   3.698  1.00  0.00           H  
ATOM    161  HB3 ARG A  15      43.196  69.516   6.341  1.00  0.00           H  
ATOM    162  HG3 ARG A  15      45.666  70.389   4.799  1.00  0.00           H  
ATOM    163  HD3 ARG A  15      45.743  67.693   5.774  1.00  0.00           H  
ATOM    164  HE  ARG A  15      47.809  68.810   5.958  1.00  0.00           H  
ATOM    165 HH11 ARG A  15      45.357  70.517   7.814  1.00  0.00           H  
ATOM    166 HH12 ARG A  15      46.494  71.563   8.596  1.00  0.00           H  
ATOM    167 HH21 ARG A  15      49.312  70.188   6.991  1.00  0.00           H  
ATOM    168 HH22 ARG A  15      48.759  71.374   8.125  1.00  0.00           H  
ATOM    169  N   LEU A  16      40.628  69.777   4.327  1.00  0.00           N  
ATOM    170  CA  LEU A  16      39.232  69.516   4.629  1.00  0.00           C  
ATOM    171  C   LEU A  16      38.880  68.091   4.200  1.00  0.00           C  
ATOM    172  O   LEU A  16      39.533  67.522   3.327  1.00  0.00           O  
ATOM    173  CB  LEU A  16      38.338  70.586   3.997  1.00  0.00           C  
ATOM    174  CG  LEU A  16      38.923  71.320   2.790  1.00  0.00           C  
ATOM    175  CD1 LEU A  16      39.690  70.358   1.881  1.00  0.00           C  
ATOM    176  CD2 LEU A  16      37.833  72.079   2.029  1.00  0.00           C  
ATOM    177  H   LEU A  16      40.986  69.294   3.529  1.00  0.00           H  
ATOM    178  HA  LEU A  16      39.111  69.592   5.710  1.00  0.00           H  
ATOM    179  HB3 LEU A  16      38.094  71.323   4.762  1.00  0.00           H  
ATOM    180  HG  LEU A  16      39.635  72.060   3.151  1.00  0.00           H  
ATOM    181 HD11 LEU A  16      39.423  69.331   2.130  1.00  0.00           H  
ATOM    182 HD12 LEU A  16      39.436  70.557   0.841  1.00  0.00           H  
ATOM    183 HD13 LEU A  16      40.762  70.499   2.026  1.00  0.00           H  
ATOM    184 HD21 LEU A  16      37.071  72.418   2.730  1.00  0.00           H  
ATOM    185 HD22 LEU A  16      38.272  72.940   1.526  1.00  0.00           H  
ATOM    186 HD23 LEU A  16      37.378  71.418   1.291  1.00  0.00           H  
ATOM    187  N   PRO A  17      37.821  67.539   4.852  1.00  0.00           N  
ATOM    188  CA  PRO A  17      37.375  66.190   4.547  1.00  0.00           C  
ATOM    189  C   PRO A  17      36.622  66.150   3.216  1.00  0.00           C  
ATOM    190  O   PRO A  17      35.496  66.638   3.120  1.00  0.00           O  
ATOM    191  CB  PRO A  17      36.511  65.785   5.731  1.00  0.00           C  
ATOM    192  CG  PRO A  17      36.127  67.079   6.429  1.00  0.00           C  
ATOM    193  CD  PRO A  17      37.023  68.182   5.891  1.00  0.00           C  
ATOM    194  HA  PRO A  17      38.160  65.581   4.435  1.00  0.00           H  
ATOM    195  HB3 PRO A  17      37.058  65.125   6.404  1.00  0.00           H  
ATOM    196  HG3 PRO A  17      36.248  66.981   7.508  1.00  0.00           H  
ATOM    197  HD3 PRO A  17      37.656  68.597   6.677  1.00  0.00           H  
ATOM    198  N   VAL A  18      37.272  65.563   2.222  1.00  0.00           N  
ATOM    199  CA  VAL A  18      36.677  65.451   0.902  1.00  0.00           C  
ATOM    200  C   VAL A  18      35.920  64.126   0.796  1.00  0.00           C  
ATOM    201  O   VAL A  18      36.530  63.058   0.798  1.00  0.00           O  
ATOM    202  CB  VAL A  18      37.755  65.611  -0.173  1.00  0.00           C  
ATOM    203  CG1 VAL A  18      37.206  65.259  -1.557  1.00  0.00           C  
ATOM    204  CG2 VAL A  18      38.340  67.024  -0.157  1.00  0.00           C  
ATOM    205  H   VAL A  18      38.187  65.167   2.309  1.00  0.00           H  
ATOM    206  HA  VAL A  18      35.967  66.271   0.790  1.00  0.00           H  
ATOM    207  HB  VAL A  18      38.561  64.913   0.056  1.00  0.00           H  
ATOM    208 HG11 VAL A  18      36.164  64.953  -1.467  1.00  0.00           H  
ATOM    209 HG12 VAL A  18      37.275  66.131  -2.208  1.00  0.00           H  
ATOM    210 HG13 VAL A  18      37.789  64.441  -1.983  1.00  0.00           H  
ATOM    211 HG21 VAL A  18      39.384  66.990  -0.473  1.00  0.00           H  
ATOM    212 HG22 VAL A  18      37.774  67.659  -0.841  1.00  0.00           H  
ATOM    213 HG23 VAL A  18      38.278  67.433   0.852  1.00  0.00           H  
ATOM    214  N   LEU A  19      34.604  64.238   0.708  1.00  0.00           N  
ATOM    215  CA  LEU A  19      33.756  63.061   0.603  1.00  0.00           C  
ATOM    216  C   LEU A  19      34.395  62.065  -0.366  1.00  0.00           C  
ATOM    217  O   LEU A  19      35.015  62.461  -1.350  1.00  0.00           O  
ATOM    218  CB  LEU A  19      32.329  63.460   0.223  1.00  0.00           C  
ATOM    219  CG  LEU A  19      31.391  62.314  -0.156  1.00  0.00           C  
ATOM    220  CD1 LEU A  19      30.724  61.717   1.084  1.00  0.00           C  
ATOM    221  CD2 LEU A  19      30.365  62.766  -1.198  1.00  0.00           C  
ATOM    222  H   LEU A  19      34.115  65.111   0.707  1.00  0.00           H  
ATOM    223  HA  LEU A  19      33.711  62.603   1.591  1.00  0.00           H  
ATOM    224  HB3 LEU A  19      32.379  64.157  -0.614  1.00  0.00           H  
ATOM    225  HG  LEU A  19      31.986  61.523  -0.614  1.00  0.00           H  
ATOM    226 HD11 LEU A  19      30.145  60.839   0.799  1.00  0.00           H  
ATOM    227 HD12 LEU A  19      31.488  61.431   1.806  1.00  0.00           H  
ATOM    228 HD13 LEU A  19      30.062  62.459   1.532  1.00  0.00           H  
ATOM    229 HD21 LEU A  19      29.534  63.262  -0.697  1.00  0.00           H  
ATOM    230 HD22 LEU A  19      30.836  63.462  -1.894  1.00  0.00           H  
ATOM    231 HD23 LEU A  19      29.995  61.899  -1.744  1.00  0.00           H  
ATOM    232  N   ARG A  20      34.221  60.790  -0.052  1.00  0.00           N  
ATOM    233  CA  ARG A  20      34.772  59.732  -0.883  1.00  0.00           C  
ATOM    234  C   ARG A  20      34.132  58.389  -0.527  1.00  0.00           C  
ATOM    235  O   ARG A  20      34.398  57.834   0.538  1.00  0.00           O  
ATOM    236  CB  ARG A  20      36.289  59.629  -0.709  1.00  0.00           C  
ATOM    237  CG  ARG A  20      36.900  58.701  -1.761  1.00  0.00           C  
ATOM    238  CD  ARG A  20      38.175  58.040  -1.234  1.00  0.00           C  
ATOM    239  NE  ARG A  20      38.001  56.573  -1.181  1.00  0.00           N  
ATOM    240  CZ  ARG A  20      38.034  55.770  -2.253  1.00  0.00           C  
ATOM    241  NH1 ARG A  20      38.237  56.291  -3.472  1.00  0.00           N  
ATOM    242  NH2 ARG A  20      37.865  54.449  -2.109  1.00  0.00           N  
ATOM    243  H   ARG A  20      33.715  60.475   0.752  1.00  0.00           H  
ATOM    244  HA  ARG A  20      34.528  60.024  -1.905  1.00  0.00           H  
ATOM    245  HB3 ARG A  20      36.519  59.255   0.288  1.00  0.00           H  
ATOM    246  HG3 ARG A  20      37.124  59.267  -2.665  1.00  0.00           H  
ATOM    247  HD3 ARG A  20      38.411  58.424  -0.242  1.00  0.00           H  
ATOM    248  HE  ARG A  20      37.848  56.152  -0.285  1.00  0.00           H  
ATOM    249 HH11 ARG A  20      38.362  57.278  -3.580  1.00  0.00           H  
ATOM    250 HH12 ARG A  20      38.262  55.694  -4.272  1.00  0.00           H  
ATOM    251 HH21 ARG A  20      37.714  54.061  -1.200  1.00  0.00           H  
ATOM    252 HH22 ARG A  20      37.891  53.851  -2.910  1.00  0.00           H  
ATOM    253  N   ARG A  21      33.301  57.906  -1.438  1.00  0.00           N  
ATOM    254  CA  ARG A  21      32.621  56.637  -1.234  1.00  0.00           C  
ATOM    255  C   ARG A  21      33.554  55.475  -1.575  1.00  0.00           C  
ATOM    256  O   ARG A  21      33.845  55.228  -2.745  1.00  0.00           O  
ATOM    257  CB  ARG A  21      31.361  56.543  -2.097  1.00  0.00           C  
ATOM    258  CG  ARG A  21      30.196  57.298  -1.454  1.00  0.00           C  
ATOM    259  CD  ARG A  21      28.859  56.848  -2.044  1.00  0.00           C  
ATOM    260  NE  ARG A  21      28.045  58.029  -2.409  1.00  0.00           N  
ATOM    261  CZ  ARG A  21      26.738  57.979  -2.695  1.00  0.00           C  
ATOM    262  NH1 ARG A  21      26.085  56.809  -2.657  1.00  0.00           N  
ATOM    263  NH2 ARG A  21      26.078  59.101  -3.017  1.00  0.00           N  
ATOM    264  H   ARG A  21      33.091  58.364  -2.302  1.00  0.00           H  
ATOM    265  HA  ARG A  21      32.357  56.631  -0.177  1.00  0.00           H  
ATOM    266  HB3 ARG A  21      31.090  55.496  -2.236  1.00  0.00           H  
ATOM    267  HG3 ARG A  21      30.324  58.369  -1.607  1.00  0.00           H  
ATOM    268  HD3 ARG A  21      28.321  56.235  -1.321  1.00  0.00           H  
ATOM    269  HE  ARG A  21      28.499  58.918  -2.447  1.00  0.00           H  
ATOM    270 HH11 ARG A  21      26.577  55.972  -2.417  1.00  0.00           H  
ATOM    271 HH12 ARG A  21      25.110  56.772  -2.870  1.00  0.00           H  
ATOM    272 HH21 ARG A  21      26.564  59.975  -3.045  1.00  0.00           H  
ATOM    273 HH22 ARG A  21      25.102  59.065  -3.230  1.00  0.00           H  
ATOM    274  N   ASN A  22      33.997  54.788  -0.533  1.00  0.00           N  
ATOM    275  CA  ASN A  22      34.891  53.655  -0.706  1.00  0.00           C  
ATOM    276  C   ASN A  22      34.132  52.510  -1.380  1.00  0.00           C  
ATOM    277  O   ASN A  22      32.937  52.626  -1.646  1.00  0.00           O  
ATOM    278  CB  ASN A  22      35.410  53.151   0.642  1.00  0.00           C  
ATOM    279  CG  ASN A  22      34.281  53.079   1.671  1.00  0.00           C  
ATOM    280  OD1 ASN A  22      33.321  52.339   1.529  1.00  0.00           O  
ATOM    281  ND2 ASN A  22      34.448  53.887   2.714  1.00  0.00           N  
ATOM    282  H   ASN A  22      33.756  54.994   0.417  1.00  0.00           H  
ATOM    283  HA  ASN A  22      35.711  54.030  -1.319  1.00  0.00           H  
ATOM    284  HB3 ASN A  22      36.196  53.813   1.004  1.00  0.00           H  
ATOM    285 HD21 ASN A  22      35.259  54.470   2.771  1.00  0.00           H  
ATOM    286 HD22 ASN A  22      33.764  53.912   3.442  1.00  0.00           H  
ATOM    287  N   GLN A  23      34.858  51.432  -1.636  1.00  0.00           N  
ATOM    288  CA  GLN A  23      34.268  50.267  -2.274  1.00  0.00           C  
ATOM    289  C   GLN A  23      32.914  49.944  -1.638  1.00  0.00           C  
ATOM    290  O   GLN A  23      31.883  49.982  -2.310  1.00  0.00           O  
ATOM    291  CB  GLN A  23      35.210  49.064  -2.197  1.00  0.00           C  
ATOM    292  CG  GLN A  23      35.208  48.282  -3.513  1.00  0.00           C  
ATOM    293  CD  GLN A  23      35.932  46.944  -3.355  1.00  0.00           C  
ATOM    294  OE1 GLN A  23      37.054  46.760  -3.796  1.00  0.00           O  
ATOM    295  NE2 GLN A  23      35.228  46.021  -2.705  1.00  0.00           N  
ATOM    296  H   GLN A  23      35.830  51.347  -1.416  1.00  0.00           H  
ATOM    297  HA  GLN A  23      34.129  50.547  -3.318  1.00  0.00           H  
ATOM    298  HB3 GLN A  23      34.905  48.409  -1.381  1.00  0.00           H  
ATOM    299  HG3 GLN A  23      35.692  48.873  -4.291  1.00  0.00           H  
ATOM    300 HE21 GLN A  23      34.311  46.236  -2.369  1.00  0.00           H  
ATOM    301 HE22 GLN A  23      35.616  45.112  -2.551  1.00  0.00           H  
ATOM    302  N   ASP A  24      32.959  49.632  -0.351  1.00  0.00           N  
ATOM    303  CA  ASP A  24      31.748  49.303   0.382  1.00  0.00           C  
ATOM    304  C   ASP A  24      30.637  50.278  -0.013  1.00  0.00           C  
ATOM    305  O   ASP A  24      29.456  49.934   0.044  1.00  0.00           O  
ATOM    306  CB  ASP A  24      31.968  49.423   1.891  1.00  0.00           C  
ATOM    307  CG  ASP A  24      32.735  48.261   2.528  1.00  0.00           C  
ATOM    308  OD1 ASP A  24      33.496  47.609   1.783  1.00  0.00           O  
ATOM    309  OD2 ASP A  24      32.541  48.053   3.745  1.00  0.00           O  
ATOM    310  H   ASP A  24      33.800  49.604   0.188  1.00  0.00           H  
ATOM    311  HA  ASP A  24      31.518  48.275   0.107  1.00  0.00           H  
ATOM    312  HB3 ASP A  24      30.997  49.509   2.379  1.00  0.00           H  
ATOM    313  N   ASN A  25      31.053  51.474  -0.404  1.00  0.00           N  
ATOM    314  CA  ASN A  25      30.108  52.499  -0.808  1.00  0.00           C  
ATOM    315  C   ASN A  25      29.573  53.212   0.435  1.00  0.00           C  
ATOM    316  O   ASN A  25      28.364  53.391   0.582  1.00  0.00           O  
ATOM    317  CB  ASN A  25      28.918  51.890  -1.552  1.00  0.00           C  
ATOM    318  CG  ASN A  25      28.291  52.906  -2.510  1.00  0.00           C  
ATOM    319  OD1 ASN A  25      28.955  53.512  -3.335  1.00  0.00           O  
ATOM    320  ND2 ASN A  25      26.979  53.058  -2.355  1.00  0.00           N  
ATOM    321  H   ASN A  25      32.014  51.744  -0.447  1.00  0.00           H  
ATOM    322  HA  ASN A  25      30.670  53.167  -1.461  1.00  0.00           H  
ATOM    323  HB3 ASN A  25      28.169  51.552  -0.836  1.00  0.00           H  
ATOM    324 HD21 ASN A  25      26.493  52.529  -1.658  1.00  0.00           H  
ATOM    325 HD22 ASN A  25      26.477  53.700  -2.933  1.00  0.00           H  
ATOM    326  N   GLU A  26      30.498  53.599   1.300  1.00  0.00           N  
ATOM    327  CA  GLU A  26      30.134  54.289   2.527  1.00  0.00           C  
ATOM    328  C   GLU A  26      30.680  55.719   2.514  1.00  0.00           C  
ATOM    329  O   GLU A  26      31.881  55.929   2.680  1.00  0.00           O  
ATOM    330  CB  GLU A  26      30.631  53.523   3.755  1.00  0.00           C  
ATOM    331  CG  GLU A  26      30.070  52.099   3.777  1.00  0.00           C  
ATOM    332  CD  GLU A  26      30.295  51.443   5.142  1.00  0.00           C  
ATOM    333  OE1 GLU A  26      31.453  51.486   5.608  1.00  0.00           O  
ATOM    334  OE2 GLU A  26      29.302  50.913   5.685  1.00  0.00           O  
ATOM    335  H   GLU A  26      31.478  53.450   1.174  1.00  0.00           H  
ATOM    336  HA  GLU A  26      29.044  54.309   2.536  1.00  0.00           H  
ATOM    337  HB3 GLU A  26      30.335  54.049   4.662  1.00  0.00           H  
ATOM    338  HG3 GLU A  26      30.547  51.504   2.999  1.00  0.00           H  
ATOM    339  N   ASP A  27      29.771  56.662   2.319  1.00  0.00           N  
ATOM    340  CA  ASP A  27      30.146  58.066   2.282  1.00  0.00           C  
ATOM    341  C   ASP A  27      31.200  58.335   3.358  1.00  0.00           C  
ATOM    342  O   ASP A  27      30.871  58.452   4.537  1.00  0.00           O  
ATOM    343  CB  ASP A  27      28.942  58.965   2.563  1.00  0.00           C  
ATOM    344  CG  ASP A  27      28.405  58.899   3.995  1.00  0.00           C  
ATOM    345  OD1 ASP A  27      27.923  57.807   4.370  1.00  0.00           O  
ATOM    346  OD2 ASP A  27      28.489  59.939   4.682  1.00  0.00           O  
ATOM    347  H   ASP A  27      28.797  56.482   2.186  1.00  0.00           H  
ATOM    348  HA  ASP A  27      30.528  58.235   1.275  1.00  0.00           H  
ATOM    349  HB3 ASP A  27      28.140  58.697   1.878  1.00  0.00           H  
ATOM    350  N   GLU A  28      32.445  58.426   2.913  1.00  0.00           N  
ATOM    351  CA  GLU A  28      33.547  58.680   3.825  1.00  0.00           C  
ATOM    352  C   GLU A  28      33.887  60.172   3.847  1.00  0.00           C  
ATOM    353  O   GLU A  28      33.372  60.941   3.035  1.00  0.00           O  
ATOM    354  CB  GLU A  28      34.773  57.845   3.447  1.00  0.00           C  
ATOM    355  CG  GLU A  28      35.790  57.815   4.590  1.00  0.00           C  
ATOM    356  CD  GLU A  28      36.537  56.480   4.625  1.00  0.00           C  
ATOM    357  OE1 GLU A  28      37.087  56.111   3.564  1.00  0.00           O  
ATOM    358  OE2 GLU A  28      36.541  55.859   5.708  1.00  0.00           O  
ATOM    359  H   GLU A  28      32.703  58.330   1.953  1.00  0.00           H  
ATOM    360  HA  GLU A  28      33.192  58.368   4.806  1.00  0.00           H  
ATOM    361  HB3 GLU A  28      35.239  58.260   2.553  1.00  0.00           H  
ATOM    362  HG3 GLU A  28      35.279  57.974   5.540  1.00  0.00           H  
ATOM    363  N   TRP A  29      34.750  60.537   4.781  1.00  0.00           N  
ATOM    364  CA  TRP A  29      35.163  61.923   4.919  1.00  0.00           C  
ATOM    365  C   TRP A  29      36.626  61.938   5.364  1.00  0.00           C  
ATOM    366  O   TRP A  29      36.939  62.384   6.467  1.00  0.00           O  
ATOM    367  CB  TRP A  29      34.239  62.678   5.878  1.00  0.00           C  
ATOM    368  CG  TRP A  29      32.816  62.867   5.349  1.00  0.00           C  
ATOM    369  CD1 TRP A  29      31.742  62.099   5.580  1.00  0.00           C  
ATOM    370  CD2 TRP A  29      32.352  63.927   4.487  1.00  0.00           C  
ATOM    371  NE1 TRP A  29      30.624  62.584   4.932  1.00  0.00           N  
ATOM    372  CE2 TRP A  29      31.007  63.732   4.246  1.00  0.00           C  
ATOM    373  CE3 TRP A  29      33.045  65.016   3.929  1.00  0.00           C  
ATOM    374  CZ2 TRP A  29      30.240  64.584   3.443  1.00  0.00           C  
ATOM    375  CZ3 TRP A  29      32.265  65.858   3.129  1.00  0.00           C  
ATOM    376  CH2 TRP A  29      30.910  65.675   2.876  1.00  0.00           C  
ATOM    377  H   TRP A  29      35.165  59.906   5.437  1.00  0.00           H  
ATOM    378  HA  TRP A  29      35.066  62.399   3.944  1.00  0.00           H  
ATOM    379  HB3 TRP A  29      34.671  63.657   6.087  1.00  0.00           H  
ATOM    380  HD1 TRP A  29      31.750  61.204   6.202  1.00  0.00           H  
ATOM    381  HE1 TRP A  29      29.625  62.149   4.955  1.00  0.00           H  
ATOM    382  HE3 TRP A  29      34.107  65.191   4.104  1.00  0.00           H  
ATOM    383  HZ2 TRP A  29      29.179  64.407   3.269  1.00  0.00           H  
ATOM    384  HZ3 TRP A  29      32.754  66.718   2.670  1.00  0.00           H  
ATOM    385  HH2 TRP A  29      30.371  66.377   2.241  1.00  0.00           H  
ATOM    386  N   PRO A  30      37.508  61.434   4.460  1.00  0.00           N  
ATOM    387  CA  PRO A  30      38.932  61.384   4.748  1.00  0.00           C  
ATOM    388  C   PRO A  30      39.561  62.775   4.638  1.00  0.00           C  
ATOM    389  O   PRO A  30      39.057  63.633   3.913  1.00  0.00           O  
ATOM    390  CB  PRO A  30      39.501  60.393   3.748  1.00  0.00           C  
ATOM    391  CG  PRO A  30      38.467  60.274   2.642  1.00  0.00           C  
ATOM    392  CD  PRO A  30      37.173  60.897   3.144  1.00  0.00           C  
ATOM    393  HA  PRO A  30      39.084  61.090   5.692  1.00  0.00           H  
ATOM    394  HB3 PRO A  30      39.684  59.425   4.218  1.00  0.00           H  
ATOM    395  HG3 PRO A  30      38.308  59.230   2.376  1.00  0.00           H  
ATOM    396  HD3 PRO A  30      36.377  60.156   3.209  1.00  0.00           H  
ATOM    397  N   LEU A  31      40.654  62.955   5.364  1.00  0.00           N  
ATOM    398  CA  LEU A  31      41.358  64.225   5.357  1.00  0.00           C  
ATOM    399  C   LEU A  31      42.060  64.406   4.009  1.00  0.00           C  
ATOM    400  O   LEU A  31      42.793  63.525   3.564  1.00  0.00           O  
ATOM    401  CB  LEU A  31      42.299  64.324   6.559  1.00  0.00           C  
ATOM    402  CG  LEU A  31      42.553  65.733   7.098  1.00  0.00           C  
ATOM    403  CD1 LEU A  31      43.379  66.559   6.108  1.00  0.00           C  
ATOM    404  CD2 LEU A  31      41.239  66.424   7.467  1.00  0.00           C  
ATOM    405  H   LEU A  31      41.058  62.251   5.950  1.00  0.00           H  
ATOM    406  HA  LEU A  31      40.612  65.012   5.466  1.00  0.00           H  
ATOM    407  HB3 LEU A  31      43.257  63.885   6.280  1.00  0.00           H  
ATOM    408  HG  LEU A  31      43.140  65.647   8.013  1.00  0.00           H  
ATOM    409 HD11 LEU A  31      44.338  66.072   5.941  1.00  0.00           H  
ATOM    410 HD12 LEU A  31      42.840  66.636   5.164  1.00  0.00           H  
ATOM    411 HD13 LEU A  31      43.541  67.557   6.516  1.00  0.00           H  
ATOM    412 HD21 LEU A  31      40.973  67.138   6.687  1.00  0.00           H  
ATOM    413 HD22 LEU A  31      40.449  65.677   7.558  1.00  0.00           H  
ATOM    414 HD23 LEU A  31      41.357  66.947   8.415  1.00  0.00           H  
ATOM    415  N   ALA A  32      41.809  65.554   3.397  1.00  0.00           N  
ATOM    416  CA  ALA A  32      42.408  65.863   2.110  1.00  0.00           C  
ATOM    417  C   ALA A  32      42.979  67.281   2.143  1.00  0.00           C  
ATOM    418  O   ALA A  32      42.452  68.150   2.838  1.00  0.00           O  
ATOM    419  CB  ALA A  32      41.366  65.680   1.005  1.00  0.00           C  
ATOM    420  H   ALA A  32      41.211  66.266   3.766  1.00  0.00           H  
ATOM    421  HA  ALA A  32      43.221  65.157   1.945  1.00  0.00           H  
ATOM    422  HB1 ALA A  32      40.928  66.646   0.756  1.00  0.00           H  
ATOM    423  HB2 ALA A  32      41.842  65.257   0.120  1.00  0.00           H  
ATOM    424  HB3 ALA A  32      40.583  65.006   1.352  1.00  0.00           H  
ATOM    425  N   GLU A  33      44.048  67.472   1.385  1.00  0.00           N  
ATOM    426  CA  GLU A  33      44.696  68.771   1.320  1.00  0.00           C  
ATOM    427  C   GLU A  33      44.585  69.350  -0.093  1.00  0.00           C  
ATOM    428  O   GLU A  33      44.815  68.648  -1.075  1.00  0.00           O  
ATOM    429  CB  GLU A  33      46.159  68.677   1.760  1.00  0.00           C  
ATOM    430  CG  GLU A  33      46.751  70.068   1.998  1.00  0.00           C  
ATOM    431  CD  GLU A  33      48.278  70.010   2.060  1.00  0.00           C  
ATOM    432  OE1 GLU A  33      48.857  69.320   1.194  1.00  0.00           O  
ATOM    433  OE2 GLU A  33      48.834  70.659   2.975  1.00  0.00           O  
ATOM    434  H   GLU A  33      44.470  66.762   0.823  1.00  0.00           H  
ATOM    435  HA  GLU A  33      44.153  69.403   2.022  1.00  0.00           H  
ATOM    436  HB3 GLU A  33      46.738  68.157   0.997  1.00  0.00           H  
ATOM    437  HG3 GLU A  33      46.360  70.479   2.928  1.00  0.00           H  
ATOM    438  N   ILE A  34      44.232  70.627  -0.147  1.00  0.00           N  
ATOM    439  CA  ILE A  34      44.086  71.308  -1.423  1.00  0.00           C  
ATOM    440  C   ILE A  34      45.457  71.429  -2.092  1.00  0.00           C  
ATOM    441  O   ILE A  34      46.455  71.704  -1.425  1.00  0.00           O  
ATOM    442  CB  ILE A  34      43.373  72.648  -1.236  1.00  0.00           C  
ATOM    443  CG1 ILE A  34      42.030  72.460  -0.527  1.00  0.00           C  
ATOM    444  CG2 ILE A  34      43.218  73.378  -2.572  1.00  0.00           C  
ATOM    445  CD1 ILE A  34      40.936  72.060  -1.520  1.00  0.00           C  
ATOM    446  H   ILE A  34      44.047  71.192   0.656  1.00  0.00           H  
ATOM    447  HA  ILE A  34      43.449  70.688  -2.054  1.00  0.00           H  
ATOM    448  HB  ILE A  34      43.991  73.277  -0.595  1.00  0.00           H  
ATOM    449 HG13 ILE A  34      41.749  73.385  -0.023  1.00  0.00           H  
ATOM    450 HG21 ILE A  34      44.195  73.488  -3.041  1.00  0.00           H  
ATOM    451 HG22 ILE A  34      42.564  72.802  -3.227  1.00  0.00           H  
ATOM    452 HG23 ILE A  34      42.784  74.363  -2.399  1.00  0.00           H  
ATOM    453 HD11 ILE A  34      40.565  72.950  -2.027  1.00  0.00           H  
ATOM    454 HD12 ILE A  34      41.348  71.369  -2.254  1.00  0.00           H  
ATOM    455 HD13 ILE A  34      40.118  71.579  -0.983  1.00  0.00           H  
ATOM    456  N   LEU A  35      45.463  71.218  -3.399  1.00  0.00           N  
ATOM    457  CA  LEU A  35      46.696  71.300  -4.165  1.00  0.00           C  
ATOM    458  C   LEU A  35      46.564  72.401  -5.218  1.00  0.00           C  
ATOM    459  O   LEU A  35      47.434  73.263  -5.333  1.00  0.00           O  
ATOM    460  CB  LEU A  35      47.059  69.932  -4.745  1.00  0.00           C  
ATOM    461  CG  LEU A  35      47.103  68.772  -3.750  1.00  0.00           C  
ATOM    462  CD1 LEU A  35      47.552  67.479  -4.435  1.00  0.00           C  
ATOM    463  CD2 LEU A  35      47.979  69.116  -2.544  1.00  0.00           C  
ATOM    464  H   LEU A  35      44.650  70.995  -3.933  1.00  0.00           H  
ATOM    465  HA  LEU A  35      47.493  71.578  -3.473  1.00  0.00           H  
ATOM    466  HB3 LEU A  35      48.034  70.010  -5.225  1.00  0.00           H  
ATOM    467  HG  LEU A  35      46.092  68.602  -3.377  1.00  0.00           H  
ATOM    468 HD11 LEU A  35      48.212  67.720  -5.268  1.00  0.00           H  
ATOM    469 HD12 LEU A  35      48.086  66.855  -3.718  1.00  0.00           H  
ATOM    470 HD13 LEU A  35      46.680  66.942  -4.807  1.00  0.00           H  
ATOM    471 HD21 LEU A  35      48.641  68.277  -2.326  1.00  0.00           H  
ATOM    472 HD22 LEU A  35      48.573  70.001  -2.768  1.00  0.00           H  
ATOM    473 HD23 LEU A  35      47.345  69.312  -1.679  1.00  0.00           H  
ATOM    474  N   SER A  36      45.470  72.336  -5.962  1.00  0.00           N  
ATOM    475  CA  SER A  36      45.212  73.317  -7.003  1.00  0.00           C  
ATOM    476  C   SER A  36      43.705  73.483  -7.204  1.00  0.00           C  
ATOM    477  O   SER A  36      42.940  72.544  -6.992  1.00  0.00           O  
ATOM    478  CB  SER A  36      45.883  72.913  -8.318  1.00  0.00           C  
ATOM    479  OG  SER A  36      46.377  74.042  -9.034  1.00  0.00           O  
ATOM    480  H   SER A  36      44.767  71.633  -5.862  1.00  0.00           H  
ATOM    481  HA  SER A  36      45.655  74.246  -6.640  1.00  0.00           H  
ATOM    482  HB3 SER A  36      45.168  72.374  -8.938  1.00  0.00           H  
ATOM    483  HG  SER A  36      45.636  74.690  -9.204  1.00  0.00           H  
ATOM    484  N   VAL A  37      43.324  74.684  -7.613  1.00  0.00           N  
ATOM    485  CA  VAL A  37      41.921  74.986  -7.845  1.00  0.00           C  
ATOM    486  C   VAL A  37      41.698  75.231  -9.339  1.00  0.00           C  
ATOM    487  O   VAL A  37      42.656  75.377 -10.098  1.00  0.00           O  
ATOM    488  CB  VAL A  37      41.488  76.166  -6.975  1.00  0.00           C  
ATOM    489  CG1 VAL A  37      40.043  76.569  -7.277  1.00  0.00           C  
ATOM    490  CG2 VAL A  37      41.670  75.848  -5.490  1.00  0.00           C  
ATOM    491  H   VAL A  37      43.954  75.443  -7.784  1.00  0.00           H  
ATOM    492  HA  VAL A  37      41.343  74.112  -7.543  1.00  0.00           H  
ATOM    493  HB  VAL A  37      42.130  77.014  -7.216  1.00  0.00           H  
ATOM    494 HG11 VAL A  37      39.710  77.303  -6.543  1.00  0.00           H  
ATOM    495 HG12 VAL A  37      39.988  77.002  -8.275  1.00  0.00           H  
ATOM    496 HG13 VAL A  37      39.402  75.689  -7.227  1.00  0.00           H  
ATOM    497 HG21 VAL A  37      40.757  76.100  -4.949  1.00  0.00           H  
ATOM    498 HG22 VAL A  37      41.881  74.786  -5.370  1.00  0.00           H  
ATOM    499 HG23 VAL A  37      42.501  76.430  -5.092  1.00  0.00           H  
ATOM    500  N   LYS A  38      40.429  75.268  -9.718  1.00  0.00           N  
ATOM    501  CA  LYS A  38      40.068  75.493 -11.107  1.00  0.00           C  
ATOM    502  C   LYS A  38      38.618  75.973 -11.181  1.00  0.00           C  
ATOM    503  O   LYS A  38      37.957  76.125 -10.154  1.00  0.00           O  
ATOM    504  CB  LYS A  38      40.344  74.240 -11.942  1.00  0.00           C  
ATOM    505  CG  LYS A  38      40.608  74.605 -13.404  1.00  0.00           C  
ATOM    506  CD  LYS A  38      39.527  74.024 -14.317  1.00  0.00           C  
ATOM    507  CE  LYS A  38      40.111  72.966 -15.255  1.00  0.00           C  
ATOM    508  NZ  LYS A  38      41.209  73.540 -16.064  1.00  0.00           N  
ATOM    509  H   LYS A  38      39.656  75.147  -9.095  1.00  0.00           H  
ATOM    510  HA  LYS A  38      40.714  76.283 -11.488  1.00  0.00           H  
ATOM    511  HB3 LYS A  38      39.494  73.563 -11.879  1.00  0.00           H  
ATOM    512  HG3 LYS A  38      41.586  74.227 -13.706  1.00  0.00           H  
ATOM    513  HD3 LYS A  38      39.072  74.823 -14.902  1.00  0.00           H  
ATOM    514  HE3 LYS A  38      39.330  72.581 -15.912  1.00  0.00           H  
ATOM    515  HZ1 LYS A  38      40.966  74.466 -16.347  1.00  0.00           H  
ATOM    516  HZ2 LYS A  38      42.047  73.567 -15.517  1.00  0.00           H  
ATOM    517  HZ3 LYS A  38      41.359  72.971 -16.874  1.00  0.00           H  
ATOM    518  N   ASP A  39      38.165  76.199 -12.405  1.00  0.00           N  
ATOM    519  CA  ASP A  39      36.804  76.659 -12.627  1.00  0.00           C  
ATOM    520  C   ASP A  39      36.404  76.374 -14.075  1.00  0.00           C  
ATOM    521  O   ASP A  39      37.079  76.809 -15.007  1.00  0.00           O  
ATOM    522  CB  ASP A  39      36.688  78.166 -12.391  1.00  0.00           C  
ATOM    523  CG  ASP A  39      35.517  78.844 -13.108  1.00  0.00           C  
ATOM    524  OD1 ASP A  39      35.715  79.227 -14.281  1.00  0.00           O  
ATOM    525  OD2 ASP A  39      34.451  78.963 -12.466  1.00  0.00           O  
ATOM    526  H   ASP A  39      38.708  76.073 -13.234  1.00  0.00           H  
ATOM    527  HA  ASP A  39      36.195  76.109 -11.909  1.00  0.00           H  
ATOM    528  HB3 ASP A  39      37.614  78.642 -12.713  1.00  0.00           H  
ATOM    529  N   ILE A  40      35.305  75.646 -14.220  1.00  0.00           N  
ATOM    530  CA  ILE A  40      34.807  75.298 -15.539  1.00  0.00           C  
ATOM    531  C   ILE A  40      33.334  75.700 -15.645  1.00  0.00           C  
ATOM    532  O   ILE A  40      32.454  74.842 -15.686  1.00  0.00           O  
ATOM    533  CB  ILE A  40      35.063  73.819 -15.837  1.00  0.00           C  
ATOM    534  CG1 ILE A  40      36.560  73.502 -15.787  1.00  0.00           C  
ATOM    535  CG2 ILE A  40      34.435  73.410 -17.169  1.00  0.00           C  
ATOM    536  CD1 ILE A  40      36.803  72.080 -15.280  1.00  0.00           C  
ATOM    537  H   ILE A  40      34.762  75.297 -13.456  1.00  0.00           H  
ATOM    538  HA  ILE A  40      35.377  75.877 -16.266  1.00  0.00           H  
ATOM    539  HB  ILE A  40      34.584  73.226 -15.058  1.00  0.00           H  
ATOM    540 HG13 ILE A  40      37.065  74.215 -15.137  1.00  0.00           H  
ATOM    541 HG21 ILE A  40      33.889  72.475 -17.043  1.00  0.00           H  
ATOM    542 HG22 ILE A  40      33.747  74.189 -17.501  1.00  0.00           H  
ATOM    543 HG23 ILE A  40      35.217  73.275 -17.915  1.00  0.00           H  
ATOM    544 HD11 ILE A  40      37.644  72.080 -14.587  1.00  0.00           H  
ATOM    545 HD12 ILE A  40      35.910  71.720 -14.768  1.00  0.00           H  
ATOM    546 HD13 ILE A  40      37.025  71.426 -16.122  1.00  0.00           H  
ATOM    547  N   SER A  41      33.112  77.006 -15.688  1.00  0.00           N  
ATOM    548  CA  SER A  41      31.761  77.531 -15.789  1.00  0.00           C  
ATOM    549  C   SER A  41      31.047  77.401 -14.442  1.00  0.00           C  
ATOM    550  O   SER A  41      29.954  76.843 -14.367  1.00  0.00           O  
ATOM    551  CB  SER A  41      30.970  76.810 -16.882  1.00  0.00           C  
ATOM    552  OG  SER A  41      30.242  77.721 -17.703  1.00  0.00           O  
ATOM    553  H   SER A  41      33.834  77.698 -15.654  1.00  0.00           H  
ATOM    554  HA  SER A  41      31.879  78.582 -16.059  1.00  0.00           H  
ATOM    555  HB3 SER A  41      30.278  76.104 -16.422  1.00  0.00           H  
ATOM    556  HG  SER A  41      30.163  77.356 -18.630  1.00  0.00           H  
ATOM    557  N   GLY A  42      31.693  77.926 -13.412  1.00  0.00           N  
ATOM    558  CA  GLY A  42      31.134  77.874 -12.072  1.00  0.00           C  
ATOM    559  C   GLY A  42      31.560  76.596 -11.349  1.00  0.00           C  
ATOM    560  O   GLY A  42      31.622  76.565 -10.120  1.00  0.00           O  
ATOM    561  H   GLY A  42      32.583  78.378 -13.481  1.00  0.00           H  
ATOM    562  HA2 GLY A  42      31.462  78.745 -11.504  1.00  0.00           H  
ATOM    563  HA3 GLY A  42      30.046  77.921 -12.126  1.00  0.00           H  
ATOM    564  N   ARG A  43      31.843  75.572 -12.140  1.00  0.00           N  
ATOM    565  CA  ARG A  43      32.262  74.294 -11.591  1.00  0.00           C  
ATOM    566  C   ARG A  43      33.726  74.358 -11.155  1.00  0.00           C  
ATOM    567  O   ARG A  43      34.618  73.959 -11.903  1.00  0.00           O  
ATOM    568  CB  ARG A  43      32.089  73.170 -12.614  1.00  0.00           C  
ATOM    569  CG  ARG A  43      31.918  71.818 -11.921  1.00  0.00           C  
ATOM    570  CD  ARG A  43      33.264  71.109 -11.760  1.00  0.00           C  
ATOM    571  NE  ARG A  43      33.225  69.790 -12.431  1.00  0.00           N  
ATOM    572  CZ  ARG A  43      32.390  68.799 -12.092  1.00  0.00           C  
ATOM    573  NH1 ARG A  43      31.519  68.972 -11.088  1.00  0.00           N  
ATOM    574  NH2 ARG A  43      32.424  67.637 -12.756  1.00  0.00           N  
ATOM    575  H   ARG A  43      31.790  75.606 -13.137  1.00  0.00           H  
ATOM    576  HA  ARG A  43      31.606  74.130 -10.736  1.00  0.00           H  
ATOM    577  HB3 ARG A  43      32.957  73.138 -13.273  1.00  0.00           H  
ATOM    578  HG3 ARG A  43      31.239  71.191 -12.501  1.00  0.00           H  
ATOM    579  HD3 ARG A  43      33.494  70.982 -10.703  1.00  0.00           H  
ATOM    580  HE  ARG A  43      33.862  69.629 -13.185  1.00  0.00           H  
ATOM    581 HH11 ARG A  43      31.493  69.841 -10.592  1.00  0.00           H  
ATOM    582 HH12 ARG A  43      30.895  68.232 -10.835  1.00  0.00           H  
ATOM    583 HH21 ARG A  43      33.074  67.508 -13.506  1.00  0.00           H  
ATOM    584 HH22 ARG A  43      31.800  66.897 -12.503  1.00  0.00           H  
ATOM    585  N   LYS A  44      33.932  74.862  -9.946  1.00  0.00           N  
ATOM    586  CA  LYS A  44      35.273  74.983  -9.402  1.00  0.00           C  
ATOM    587  C   LYS A  44      35.812  73.589  -9.073  1.00  0.00           C  
ATOM    588  O   LYS A  44      35.147  72.808  -8.395  1.00  0.00           O  
ATOM    589  CB  LYS A  44      35.285  75.946  -8.213  1.00  0.00           C  
ATOM    590  CG  LYS A  44      35.858  77.306  -8.614  1.00  0.00           C  
ATOM    591  CD  LYS A  44      37.027  77.696  -7.707  1.00  0.00           C  
ATOM    592  CE  LYS A  44      36.527  78.152  -6.334  1.00  0.00           C  
ATOM    593  NZ  LYS A  44      36.237  79.603  -6.345  1.00  0.00           N  
ATOM    594  H   LYS A  44      33.201  75.184  -9.344  1.00  0.00           H  
ATOM    595  HA  LYS A  44      35.901  75.422 -10.178  1.00  0.00           H  
ATOM    596  HB3 LYS A  44      35.877  75.521  -7.403  1.00  0.00           H  
ATOM    597  HG3 LYS A  44      35.078  78.066  -8.555  1.00  0.00           H  
ATOM    598  HD3 LYS A  44      37.601  78.497  -8.173  1.00  0.00           H  
ATOM    599  HE3 LYS A  44      37.278  77.932  -5.576  1.00  0.00           H  
ATOM    600  HZ1 LYS A  44      36.921  80.084  -5.798  1.00  0.00           H  
ATOM    601  HZ2 LYS A  44      36.262  79.942  -7.285  1.00  0.00           H  
ATOM    602  HZ3 LYS A  44      35.328  79.764  -5.958  1.00  0.00           H  
ATOM    603  N   LEU A  45      37.012  73.322  -9.566  1.00  0.00           N  
ATOM    604  CA  LEU A  45      37.649  72.037  -9.332  1.00  0.00           C  
ATOM    605  C   LEU A  45      38.826  72.223  -8.373  1.00  0.00           C  
ATOM    606  O   LEU A  45      39.509  73.245  -8.412  1.00  0.00           O  
ATOM    607  CB  LEU A  45      38.034  71.381 -10.660  1.00  0.00           C  
ATOM    608  CG  LEU A  45      37.187  70.181 -11.086  1.00  0.00           C  
ATOM    609  CD1 LEU A  45      35.771  70.278 -10.511  1.00  0.00           C  
ATOM    610  CD2 LEU A  45      37.177  70.030 -12.608  1.00  0.00           C  
ATOM    611  H   LEU A  45      37.547  73.965 -10.116  1.00  0.00           H  
ATOM    612  HA  LEU A  45      36.912  71.392  -8.855  1.00  0.00           H  
ATOM    613  HB3 LEU A  45      39.074  71.061 -10.594  1.00  0.00           H  
ATOM    614  HG  LEU A  45      37.640  69.279 -10.676  1.00  0.00           H  
ATOM    615 HD11 LEU A  45      35.450  71.318 -10.511  1.00  0.00           H  
ATOM    616 HD12 LEU A  45      35.091  69.686 -11.122  1.00  0.00           H  
ATOM    617 HD13 LEU A  45      35.768  69.896  -9.489  1.00  0.00           H  
ATOM    618 HD21 LEU A  45      36.744  69.067 -12.876  1.00  0.00           H  
ATOM    619 HD22 LEU A  45      36.583  70.831 -13.049  1.00  0.00           H  
ATOM    620 HD23 LEU A  45      38.198  70.087 -12.986  1.00  0.00           H  
ATOM    621  N   PHE A  46      39.026  71.219  -7.531  1.00  0.00           N  
ATOM    622  CA  PHE A  46      40.108  71.260  -6.563  1.00  0.00           C  
ATOM    623  C   PHE A  46      40.805  69.901  -6.462  1.00  0.00           C  
ATOM    624  O   PHE A  46      40.158  68.886  -6.211  1.00  0.00           O  
ATOM    625  CB  PHE A  46      39.484  71.599  -5.208  1.00  0.00           C  
ATOM    626  CG  PHE A  46      38.519  72.787  -5.248  1.00  0.00           C  
ATOM    627  CD1 PHE A  46      37.198  72.581  -5.495  1.00  0.00           C  
ATOM    628  CD2 PHE A  46      38.982  74.048  -5.036  1.00  0.00           C  
ATOM    629  CE1 PHE A  46      36.302  73.682  -5.533  1.00  0.00           C  
ATOM    630  CE2 PHE A  46      38.088  75.150  -5.073  1.00  0.00           C  
ATOM    631  CZ  PHE A  46      36.765  74.943  -5.321  1.00  0.00           C  
ATOM    632  H   PHE A  46      38.465  70.392  -7.504  1.00  0.00           H  
ATOM    633  HA  PHE A  46      40.821  72.008  -6.906  1.00  0.00           H  
ATOM    634  HB3 PHE A  46      40.280  71.816  -4.496  1.00  0.00           H  
ATOM    635  HD1 PHE A  46      36.826  71.571  -5.665  1.00  0.00           H  
ATOM    636  HD2 PHE A  46      40.042  74.213  -4.838  1.00  0.00           H  
ATOM    637  HE1 PHE A  46      35.243  73.518  -5.731  1.00  0.00           H  
ATOM    638  HE2 PHE A  46      38.459  76.160  -4.904  1.00  0.00           H  
ATOM    639  HZ  PHE A  46      36.079  75.789  -5.350  1.00  0.00           H  
ATOM    640  N   TYR A  47      42.113  69.927  -6.666  1.00  0.00           N  
ATOM    641  CA  TYR A  47      42.905  68.710  -6.601  1.00  0.00           C  
ATOM    642  C   TYR A  47      43.344  68.417  -5.165  1.00  0.00           C  
ATOM    643  O   TYR A  47      44.377  68.911  -4.715  1.00  0.00           O  
ATOM    644  CB  TYR A  47      44.145  68.968  -7.458  1.00  0.00           C  
ATOM    645  CG  TYR A  47      44.894  67.698  -7.869  1.00  0.00           C  
ATOM    646  CD1 TYR A  47      44.201  66.632  -8.406  1.00  0.00           C  
ATOM    647  CD2 TYR A  47      46.262  67.619  -7.703  1.00  0.00           C  
ATOM    648  CE1 TYR A  47      44.904  65.437  -8.792  1.00  0.00           C  
ATOM    649  CE2 TYR A  47      46.965  66.424  -8.089  1.00  0.00           C  
ATOM    650  CZ  TYR A  47      46.253  65.392  -8.615  1.00  0.00           C  
ATOM    651  OH  TYR A  47      46.917  64.263  -8.980  1.00  0.00           O  
ATOM    652  H   TYR A  47      42.631  70.758  -6.870  1.00  0.00           H  
ATOM    653  HA  TYR A  47      42.287  67.887  -6.960  1.00  0.00           H  
ATOM    654  HB3 TYR A  47      44.826  69.617  -6.908  1.00  0.00           H  
ATOM    655  HD1 TYR A  47      43.120  66.695  -8.537  1.00  0.00           H  
ATOM    656  HD2 TYR A  47      46.809  68.461  -7.280  1.00  0.00           H  
ATOM    657  HE1 TYR A  47      44.369  64.587  -9.216  1.00  0.00           H  
ATOM    658  HE2 TYR A  47      48.045  66.348  -7.964  1.00  0.00           H  
ATOM    659  HH  TYR A  47      47.842  64.272  -8.600  1.00  0.00           H  
ATOM    660  N   VAL A  48      42.538  67.614  -4.486  1.00  0.00           N  
ATOM    661  CA  VAL A  48      42.831  67.248  -3.111  1.00  0.00           C  
ATOM    662  C   VAL A  48      43.554  65.901  -3.088  1.00  0.00           C  
ATOM    663  O   VAL A  48      43.400  65.095  -4.004  1.00  0.00           O  
ATOM    664  CB  VAL A  48      41.542  67.250  -2.284  1.00  0.00           C  
ATOM    665  CG1 VAL A  48      40.816  68.590  -2.404  1.00  0.00           C  
ATOM    666  CG2 VAL A  48      40.630  66.091  -2.690  1.00  0.00           C  
ATOM    667  H   VAL A  48      41.700  67.216  -4.860  1.00  0.00           H  
ATOM    668  HA  VAL A  48      43.495  68.011  -2.703  1.00  0.00           H  
ATOM    669  HB  VAL A  48      41.817  67.109  -1.238  1.00  0.00           H  
ATOM    670 HG11 VAL A  48      39.816  68.426  -2.807  1.00  0.00           H  
ATOM    671 HG12 VAL A  48      40.740  69.052  -1.420  1.00  0.00           H  
ATOM    672 HG13 VAL A  48      41.372  69.247  -3.072  1.00  0.00           H  
ATOM    673 HG21 VAL A  48      41.200  65.362  -3.266  1.00  0.00           H  
ATOM    674 HG22 VAL A  48      40.228  65.614  -1.796  1.00  0.00           H  
ATOM    675 HG23 VAL A  48      39.809  66.472  -3.299  1.00  0.00           H  
ATOM    676  N   HIS A  49      44.328  65.699  -2.032  1.00  0.00           N  
ATOM    677  CA  HIS A  49      45.076  64.463  -1.878  1.00  0.00           C  
ATOM    678  C   HIS A  49      44.784  63.853  -0.505  1.00  0.00           C  
ATOM    679  O   HIS A  49      45.109  64.445   0.522  1.00  0.00           O  
ATOM    680  CB  HIS A  49      46.569  64.698  -2.116  1.00  0.00           C  
ATOM    681  CG  HIS A  49      47.456  63.596  -1.588  1.00  0.00           C  
ATOM    682  ND1 HIS A  49      47.423  62.304  -2.081  1.00  0.00           N  
ATOM    683  CD2 HIS A  49      48.401  63.608  -0.604  1.00  0.00           C  
ATOM    684  CE1 HIS A  49      48.311  61.579  -1.418  1.00  0.00           C  
ATOM    685  NE2 HIS A  49      48.916  62.389  -0.502  1.00  0.00           N  
ATOM    686  H   HIS A  49      44.448  66.359  -1.292  1.00  0.00           H  
ATOM    687  HA  HIS A  49      44.719  63.783  -2.652  1.00  0.00           H  
ATOM    688  HB3 HIS A  49      46.857  65.639  -1.649  1.00  0.00           H  
ATOM    689  HD1 HIS A  49      46.829  61.973  -2.816  1.00  0.00           H  
ATOM    690  HD2 HIS A  49      48.685  64.472  -0.004  1.00  0.00           H  
ATOM    691  HE1 HIS A  49      48.522  60.521  -1.577  1.00  0.00           H  
ATOM    692  N   TYR A  50      44.173  62.677  -0.534  1.00  0.00           N  
ATOM    693  CA  TYR A  50      43.832  61.983   0.695  1.00  0.00           C  
ATOM    694  C   TYR A  50      45.082  61.714   1.538  1.00  0.00           C  
ATOM    695  O   TYR A  50      46.084  61.218   1.027  1.00  0.00           O  
ATOM    696  CB  TYR A  50      43.224  60.645   0.269  1.00  0.00           C  
ATOM    697  CG  TYR A  50      41.991  60.781  -0.628  1.00  0.00           C  
ATOM    698  CD1 TYR A  50      41.021  61.714  -0.330  1.00  0.00           C  
ATOM    699  CD2 TYR A  50      41.850  59.967  -1.735  1.00  0.00           C  
ATOM    700  CE1 TYR A  50      39.861  61.842  -1.174  1.00  0.00           C  
ATOM    701  CE2 TYR A  50      40.691  60.095  -2.579  1.00  0.00           C  
ATOM    702  CZ  TYR A  50      39.753  61.026  -2.258  1.00  0.00           C  
ATOM    703  OH  TYR A  50      38.659  61.147  -3.055  1.00  0.00           O  
ATOM    704  H   TYR A  50      43.911  62.203  -1.374  1.00  0.00           H  
ATOM    705  HA  TYR A  50      43.149  62.614   1.263  1.00  0.00           H  
ATOM    706  HB3 TYR A  50      42.951  60.080   1.160  1.00  0.00           H  
ATOM    707  HD1 TYR A  50      41.132  62.356   0.543  1.00  0.00           H  
ATOM    708  HD2 TYR A  50      42.618  59.229  -1.970  1.00  0.00           H  
ATOM    709  HE1 TYR A  50      39.087  62.576  -0.951  1.00  0.00           H  
ATOM    710  HE2 TYR A  50      40.569  59.460  -3.457  1.00  0.00           H  
ATOM    711  HH  TYR A  50      38.106  61.926  -2.762  1.00  0.00           H  
ATOM    712  N   ILE A  51      44.980  62.055   2.813  1.00  0.00           N  
ATOM    713  CA  ILE A  51      46.090  61.858   3.731  1.00  0.00           C  
ATOM    714  C   ILE A  51      45.658  60.905   4.849  1.00  0.00           C  
ATOM    715  O   ILE A  51      45.173  61.344   5.890  1.00  0.00           O  
ATOM    716  CB  ILE A  51      46.611  63.204   4.238  1.00  0.00           C  
ATOM    717  CG1 ILE A  51      45.460  64.099   4.703  1.00  0.00           C  
ATOM    718  CG2 ILE A  51      47.479  63.889   3.181  1.00  0.00           C  
ATOM    719  CD1 ILE A  51      45.171  65.197   3.678  1.00  0.00           C  
ATOM    720  H   ILE A  51      44.161  62.459   3.222  1.00  0.00           H  
ATOM    721  HA  ILE A  51      46.898  61.390   3.171  1.00  0.00           H  
ATOM    722  HB  ILE A  51      47.246  63.020   5.105  1.00  0.00           H  
ATOM    723 HG13 ILE A  51      45.709  64.550   5.663  1.00  0.00           H  
ATOM    724 HG21 ILE A  51      48.341  63.261   2.956  1.00  0.00           H  
ATOM    725 HG22 ILE A  51      46.894  64.041   2.274  1.00  0.00           H  
ATOM    726 HG23 ILE A  51      47.821  64.852   3.560  1.00  0.00           H  
ATOM    727 HD11 ILE A  51      45.026  64.747   2.696  1.00  0.00           H  
ATOM    728 HD12 ILE A  51      44.269  65.737   3.968  1.00  0.00           H  
ATOM    729 HD13 ILE A  51      46.012  65.888   3.640  1.00  0.00           H  
ATOM    730  N   ASP A  52      45.852  59.620   4.593  1.00  0.00           N  
ATOM    731  CA  ASP A  52      45.488  58.602   5.564  1.00  0.00           C  
ATOM    732  C   ASP A  52      45.791  57.218   4.983  1.00  0.00           C  
ATOM    733  O   ASP A  52      45.030  56.704   4.165  1.00  0.00           O  
ATOM    734  CB  ASP A  52      43.994  58.660   5.892  1.00  0.00           C  
ATOM    735  CG  ASP A  52      43.659  58.665   7.384  1.00  0.00           C  
ATOM    736  OD1 ASP A  52      43.707  57.568   7.981  1.00  0.00           O  
ATOM    737  OD2 ASP A  52      43.364  59.766   7.896  1.00  0.00           O  
ATOM    738  H   ASP A  52      46.246  59.271   3.743  1.00  0.00           H  
ATOM    739  HA  ASP A  52      46.086  58.822   6.448  1.00  0.00           H  
ATOM    740  HB3 ASP A  52      43.502  57.806   5.427  1.00  0.00           H  
ATOM    741  N   PHE A  53      46.904  56.655   5.430  1.00  0.00           N  
ATOM    742  CA  PHE A  53      47.317  55.342   4.965  1.00  0.00           C  
ATOM    743  C   PHE A  53      47.125  55.211   3.452  1.00  0.00           C  
ATOM    744  O   PHE A  53      46.036  54.876   2.988  1.00  0.00           O  
ATOM    745  CB  PHE A  53      46.426  54.317   5.670  1.00  0.00           C  
ATOM    746  CG  PHE A  53      47.191  53.333   6.557  1.00  0.00           C  
ATOM    747  CD1 PHE A  53      47.767  53.763   7.711  1.00  0.00           C  
ATOM    748  CD2 PHE A  53      47.296  52.027   6.189  1.00  0.00           C  
ATOM    749  CE1 PHE A  53      48.476  52.849   8.534  1.00  0.00           C  
ATOM    750  CE2 PHE A  53      48.007  51.113   7.012  1.00  0.00           C  
ATOM    751  CZ  PHE A  53      48.582  51.544   8.167  1.00  0.00           C  
ATOM    752  H   PHE A  53      47.517  57.079   6.096  1.00  0.00           H  
ATOM    753  HA  PHE A  53      48.374  55.231   5.207  1.00  0.00           H  
ATOM    754  HB3 PHE A  53      45.868  53.757   4.920  1.00  0.00           H  
ATOM    755  HD1 PHE A  53      47.682  54.809   8.005  1.00  0.00           H  
ATOM    756  HD2 PHE A  53      46.836  51.683   5.264  1.00  0.00           H  
ATOM    757  HE1 PHE A  53      48.939  53.194   9.459  1.00  0.00           H  
ATOM    758  HE2 PHE A  53      48.092  50.067   6.718  1.00  0.00           H  
ATOM    759  HZ  PHE A  53      49.128  50.842   8.798  1.00  0.00           H  
ATOM    760  N   ASN A  54      48.200  55.480   2.727  1.00  0.00           N  
ATOM    761  CA  ASN A  54      48.165  55.398   1.277  1.00  0.00           C  
ATOM    762  C   ASN A  54      49.503  55.874   0.710  1.00  0.00           C  
ATOM    763  O   ASN A  54      50.200  56.668   1.340  1.00  0.00           O  
ATOM    764  CB  ASN A  54      47.062  56.288   0.701  1.00  0.00           C  
ATOM    765  CG  ASN A  54      45.810  55.470   0.377  1.00  0.00           C  
ATOM    766  OD1 ASN A  54      45.865  54.427  -0.252  1.00  0.00           O  
ATOM    767  ND2 ASN A  54      44.683  56.001   0.842  1.00  0.00           N  
ATOM    768  H   ASN A  54      49.082  55.752   3.114  1.00  0.00           H  
ATOM    769  HA  ASN A  54      47.968  54.348   1.055  1.00  0.00           H  
ATOM    770  HB3 ASN A  54      47.423  56.781  -0.203  1.00  0.00           H  
ATOM    771 HD21 ASN A  54      44.708  56.861   1.352  1.00  0.00           H  
ATOM    772 HD22 ASN A  54      43.810  55.540   0.681  1.00  0.00           H  
ATOM    773  N   ARG A  55      49.821  55.371  -0.474  1.00  0.00           N  
ATOM    774  CA  ARG A  55      51.063  55.737  -1.133  1.00  0.00           C  
ATOM    775  C   ARG A  55      50.918  57.093  -1.824  1.00  0.00           C  
ATOM    776  O   ARG A  55      51.655  58.031  -1.522  1.00  0.00           O  
ATOM    777  CB  ARG A  55      51.468  54.685  -2.167  1.00  0.00           C  
ATOM    778  CG  ARG A  55      52.482  53.700  -1.580  1.00  0.00           C  
ATOM    779  CD  ARG A  55      51.782  52.451  -1.037  1.00  0.00           C  
ATOM    780  NE  ARG A  55      51.785  52.474   0.442  1.00  0.00           N  
ATOM    781  CZ  ARG A  55      52.894  52.462   1.192  1.00  0.00           C  
ATOM    782  NH1 ARG A  55      54.099  52.429   0.606  1.00  0.00           N  
ATOM    783  NH2 ARG A  55      52.800  52.484   2.528  1.00  0.00           N  
ATOM    784  H   ARG A  55      49.249  54.727  -0.980  1.00  0.00           H  
ATOM    785  HA  ARG A  55      51.801  55.782  -0.331  1.00  0.00           H  
ATOM    786  HB3 ARG A  55      51.897  55.175  -3.041  1.00  0.00           H  
ATOM    787  HG3 ARG A  55      53.043  54.182  -0.781  1.00  0.00           H  
ATOM    788  HD3 ARG A  55      52.287  51.557  -1.397  1.00  0.00           H  
ATOM    789  HE  ARG A  55      50.901  52.499   0.912  1.00  0.00           H  
ATOM    790 HH11 ARG A  55      54.169  52.414  -0.392  1.00  0.00           H  
ATOM    791 HH12 ARG A  55      54.928  52.421   1.166  1.00  0.00           H  
ATOM    792 HH21 ARG A  55      51.901  52.509   2.967  1.00  0.00           H  
ATOM    793 HH22 ARG A  55      53.629  52.476   3.088  1.00  0.00           H  
ATOM    794  N   ARG A  56      49.963  57.156  -2.740  1.00  0.00           N  
ATOM    795  CA  ARG A  56      49.712  58.382  -3.479  1.00  0.00           C  
ATOM    796  C   ARG A  56      48.498  58.212  -4.394  1.00  0.00           C  
ATOM    797  O   ARG A  56      48.421  57.251  -5.158  1.00  0.00           O  
ATOM    798  CB  ARG A  56      50.925  58.777  -4.321  1.00  0.00           C  
ATOM    799  CG  ARG A  56      51.240  57.702  -5.364  1.00  0.00           C  
ATOM    800  CD  ARG A  56      52.656  57.878  -5.921  1.00  0.00           C  
ATOM    801  NE  ARG A  56      52.705  57.422  -7.328  1.00  0.00           N  
ATOM    802  CZ  ARG A  56      53.839  57.253  -8.023  1.00  0.00           C  
ATOM    803  NH1 ARG A  56      55.022  57.501  -7.447  1.00  0.00           N  
ATOM    804  NH2 ARG A  56      53.788  56.836  -9.296  1.00  0.00           N  
ATOM    805  H   ARG A  56      49.368  56.388  -2.980  1.00  0.00           H  
ATOM    806  HA  ARG A  56      49.523  59.134  -2.711  1.00  0.00           H  
ATOM    807  HB3 ARG A  56      51.790  58.924  -3.673  1.00  0.00           H  
ATOM    808  HG3 ARG A  56      50.517  57.757  -6.178  1.00  0.00           H  
ATOM    809  HD3 ARG A  56      53.364  57.308  -5.320  1.00  0.00           H  
ATOM    810  HE  ARG A  56      51.840  57.227  -7.789  1.00  0.00           H  
ATOM    811 HH11 ARG A  56      55.060  57.813  -6.497  1.00  0.00           H  
ATOM    812 HH12 ARG A  56      55.867  57.376  -7.965  1.00  0.00           H  
ATOM    813 HH21 ARG A  56      52.905  56.650  -9.727  1.00  0.00           H  
ATOM    814 HH22 ARG A  56      54.634  56.711  -9.815  1.00  0.00           H  
ATOM    815  N   LEU A  57      47.577  59.158  -4.284  1.00  0.00           N  
ATOM    816  CA  LEU A  57      46.370  59.126  -5.094  1.00  0.00           C  
ATOM    817  C   LEU A  57      46.237  60.444  -5.857  1.00  0.00           C  
ATOM    818  O   LEU A  57      46.505  60.500  -7.056  1.00  0.00           O  
ATOM    819  CB  LEU A  57      45.154  58.791  -4.227  1.00  0.00           C  
ATOM    820  CG  LEU A  57      45.286  57.554  -3.335  1.00  0.00           C  
ATOM    821  CD1 LEU A  57      45.105  57.919  -1.860  1.00  0.00           C  
ATOM    822  CD2 LEU A  57      44.316  56.456  -3.776  1.00  0.00           C  
ATOM    823  H   LEU A  57      47.646  59.937  -3.659  1.00  0.00           H  
ATOM    824  HA  LEU A  57      46.483  58.317  -5.815  1.00  0.00           H  
ATOM    825  HB3 LEU A  57      44.293  58.653  -4.882  1.00  0.00           H  
ATOM    826  HG  LEU A  57      46.294  57.157  -3.448  1.00  0.00           H  
ATOM    827 HD11 LEU A  57      45.831  57.373  -1.259  1.00  0.00           H  
ATOM    828 HD12 LEU A  57      45.257  58.990  -1.731  1.00  0.00           H  
ATOM    829 HD13 LEU A  57      44.096  57.655  -1.542  1.00  0.00           H  
ATOM    830 HD21 LEU A  57      44.378  56.329  -4.857  1.00  0.00           H  
ATOM    831 HD22 LEU A  57      44.580  55.519  -3.285  1.00  0.00           H  
ATOM    832 HD23 LEU A  57      43.299  56.737  -3.502  1.00  0.00           H  
ATOM    833  N   ASP A  58      45.822  61.472  -5.131  1.00  0.00           N  
ATOM    834  CA  ASP A  58      45.651  62.786  -5.726  1.00  0.00           C  
ATOM    835  C   ASP A  58      44.587  62.710  -6.824  1.00  0.00           C  
ATOM    836  O   ASP A  58      44.769  62.014  -7.822  1.00  0.00           O  
ATOM    837  CB  ASP A  58      46.952  63.277  -6.363  1.00  0.00           C  
ATOM    838  CG  ASP A  58      48.217  62.998  -5.548  1.00  0.00           C  
ATOM    839  OD1 ASP A  58      48.727  61.863  -5.666  1.00  0.00           O  
ATOM    840  OD2 ASP A  58      48.643  63.924  -4.826  1.00  0.00           O  
ATOM    841  H   ASP A  58      45.607  61.418  -4.157  1.00  0.00           H  
ATOM    842  HA  ASP A  58      45.354  63.437  -4.904  1.00  0.00           H  
ATOM    843  HB3 ASP A  58      46.875  64.354  -6.528  1.00  0.00           H  
ATOM    844  N   GLU A  59      43.500  63.435  -6.602  1.00  0.00           N  
ATOM    845  CA  GLU A  59      42.408  63.458  -7.560  1.00  0.00           C  
ATOM    846  C   GLU A  59      41.591  64.742  -7.404  1.00  0.00           C  
ATOM    847  O   GLU A  59      41.526  65.312  -6.316  1.00  0.00           O  
ATOM    848  CB  GLU A  59      41.518  62.221  -7.407  1.00  0.00           C  
ATOM    849  CG  GLU A  59      40.688  62.299  -6.124  1.00  0.00           C  
ATOM    850  CD  GLU A  59      39.600  61.224  -6.110  1.00  0.00           C  
ATOM    851  OE1 GLU A  59      39.981  60.033  -6.094  1.00  0.00           O  
ATOM    852  OE2 GLU A  59      38.413  61.617  -6.115  1.00  0.00           O  
ATOM    853  H   GLU A  59      43.361  63.997  -5.788  1.00  0.00           H  
ATOM    854  HA  GLU A  59      42.882  63.438  -8.541  1.00  0.00           H  
ATOM    855  HB3 GLU A  59      42.138  61.324  -7.391  1.00  0.00           H  
ATOM    856  HG3 GLU A  59      40.230  63.285  -6.043  1.00  0.00           H  
ATOM    857  N   TRP A  60      40.992  65.162  -8.508  1.00  0.00           N  
ATOM    858  CA  TRP A  60      40.184  66.370  -8.508  1.00  0.00           C  
ATOM    859  C   TRP A  60      38.860  66.052  -7.809  1.00  0.00           C  
ATOM    860  O   TRP A  60      38.376  64.922  -7.872  1.00  0.00           O  
ATOM    861  CB  TRP A  60      39.996  66.904  -9.929  1.00  0.00           C  
ATOM    862  CG  TRP A  60      41.297  67.349 -10.602  1.00  0.00           C  
ATOM    863  CD1 TRP A  60      42.181  66.594 -11.267  1.00  0.00           C  
ATOM    864  CD2 TRP A  60      41.824  68.691 -10.651  1.00  0.00           C  
ATOM    865  NE1 TRP A  60      43.237  67.348 -11.738  1.00  0.00           N  
ATOM    866  CE2 TRP A  60      43.013  68.664 -11.350  1.00  0.00           C  
ATOM    867  CE3 TRP A  60      41.314  69.889 -10.120  1.00  0.00           C  
ATOM    868  CZ2 TRP A  60      43.791  69.804 -11.585  1.00  0.00           C  
ATOM    869  CZ3 TRP A  60      42.103  71.019 -10.363  1.00  0.00           C  
ATOM    870  CH2 TRP A  60      43.302  71.009 -11.065  1.00  0.00           C  
ATOM    871  H   TRP A  60      41.051  64.693  -9.390  1.00  0.00           H  
ATOM    872  HA  TRP A  60      40.725  67.133  -7.951  1.00  0.00           H  
ATOM    873  HB3 TRP A  60      39.307  67.748  -9.901  1.00  0.00           H  
ATOM    874  HD1 TRP A  60      42.080  65.520 -11.417  1.00  0.00           H  
ATOM    875  HE1 TRP A  60      44.089  66.979 -12.308  1.00  0.00           H  
ATOM    876  HE3 TRP A  60      40.377  69.937  -9.563  1.00  0.00           H  
ATOM    877  HZ2 TRP A  60      44.727  69.757 -12.141  1.00  0.00           H  
ATOM    878  HZ3 TRP A  60      41.754  71.975  -9.972  1.00  0.00           H  
ATOM    879  HH2 TRP A  60      43.860  71.934 -11.212  1.00  0.00           H  
ATOM    880  N   VAL A  61      38.310  67.068  -7.160  1.00  0.00           N  
ATOM    881  CA  VAL A  61      37.052  66.912  -6.452  1.00  0.00           C  
ATOM    882  C   VAL A  61      36.190  68.156  -6.671  1.00  0.00           C  
ATOM    883  O   VAL A  61      36.532  69.019  -7.476  1.00  0.00           O  
ATOM    884  CB  VAL A  61      37.318  66.619  -4.974  1.00  0.00           C  
ATOM    885  CG1 VAL A  61      38.090  65.310  -4.803  1.00  0.00           C  
ATOM    886  CG2 VAL A  61      38.058  67.783  -4.309  1.00  0.00           C  
ATOM    887  H   VAL A  61      38.711  67.984  -7.115  1.00  0.00           H  
ATOM    888  HA  VAL A  61      36.539  66.049  -6.879  1.00  0.00           H  
ATOM    889  HB  VAL A  61      36.354  66.507  -4.475  1.00  0.00           H  
ATOM    890 HG11 VAL A  61      38.352  65.177  -3.753  1.00  0.00           H  
ATOM    891 HG12 VAL A  61      37.468  64.476  -5.130  1.00  0.00           H  
ATOM    892 HG13 VAL A  61      38.998  65.344  -5.403  1.00  0.00           H  
ATOM    893 HG21 VAL A  61      38.012  67.670  -3.225  1.00  0.00           H  
ATOM    894 HG22 VAL A  61      39.098  67.783  -4.631  1.00  0.00           H  
ATOM    895 HG23 VAL A  61      37.587  68.723  -4.597  1.00  0.00           H  
ATOM    896  N   THR A  62      35.088  68.210  -5.937  1.00  0.00           N  
ATOM    897  CA  THR A  62      34.174  69.334  -6.040  1.00  0.00           C  
ATOM    898  C   THR A  62      33.990  69.999  -4.675  1.00  0.00           C  
ATOM    899  O   THR A  62      34.491  69.504  -3.666  1.00  0.00           O  
ATOM    900  CB  THR A  62      32.866  68.827  -6.650  1.00  0.00           C  
ATOM    901  OG1 THR A  62      32.498  67.729  -5.818  1.00  0.00           O  
ATOM    902  CG2 THR A  62      33.069  68.196  -8.030  1.00  0.00           C  
ATOM    903  H   THR A  62      34.817  67.503  -5.282  1.00  0.00           H  
ATOM    904  HA  THR A  62      34.618  70.079  -6.701  1.00  0.00           H  
ATOM    905  HB  THR A  62      32.121  69.621  -6.691  1.00  0.00           H  
ATOM    906  HG1 THR A  62      31.798  67.176  -6.271  1.00  0.00           H  
ATOM    907 HG21 THR A  62      32.150  67.699  -8.341  1.00  0.00           H  
ATOM    908 HG22 THR A  62      33.322  68.974  -8.751  1.00  0.00           H  
ATOM    909 HG23 THR A  62      33.878  67.468  -7.981  1.00  0.00           H  
ATOM    910  N   HIS A  63      33.269  71.111  -4.686  1.00  0.00           N  
ATOM    911  CA  HIS A  63      33.012  71.848  -3.461  1.00  0.00           C  
ATOM    912  C   HIS A  63      32.069  71.043  -2.564  1.00  0.00           C  
ATOM    913  O   HIS A  63      32.260  70.988  -1.351  1.00  0.00           O  
ATOM    914  CB  HIS A  63      32.482  73.250  -3.772  1.00  0.00           C  
ATOM    915  CG  HIS A  63      31.790  73.916  -2.607  1.00  0.00           C  
ATOM    916  ND1 HIS A  63      30.738  74.802  -2.767  1.00  0.00           N  
ATOM    917  CD2 HIS A  63      32.007  73.817  -1.265  1.00  0.00           C  
ATOM    918  CE1 HIS A  63      30.350  75.211  -1.568  1.00  0.00           C  
ATOM    919  NE2 HIS A  63      31.138  74.601  -0.638  1.00  0.00           N  
ATOM    920  H   HIS A  63      32.866  71.507  -5.511  1.00  0.00           H  
ATOM    921  HA  HIS A  63      33.973  71.961  -2.957  1.00  0.00           H  
ATOM    922  HB3 HIS A  63      31.785  73.187  -4.608  1.00  0.00           H  
ATOM    923  HD1 HIS A  63      30.340  75.086  -3.639  1.00  0.00           H  
ATOM    924  HD2 HIS A  63      32.768  73.198  -0.787  1.00  0.00           H  
ATOM    925  HE1 HIS A  63      29.542  75.914  -1.362  1.00  0.00           H  
ATOM    926  N   GLU A  64      31.076  70.439  -3.197  1.00  0.00           N  
ATOM    927  CA  GLU A  64      30.103  69.639  -2.472  1.00  0.00           C  
ATOM    928  C   GLU A  64      30.814  68.687  -1.507  1.00  0.00           C  
ATOM    929  O   GLU A  64      30.286  68.372  -0.441  1.00  0.00           O  
ATOM    930  CB  GLU A  64      29.199  68.869  -3.437  1.00  0.00           C  
ATOM    931  CG  GLU A  64      30.021  67.949  -4.342  1.00  0.00           C  
ATOM    932  CD  GLU A  64      29.667  68.171  -5.814  1.00  0.00           C  
ATOM    933  OE1 GLU A  64      29.940  69.289  -6.301  1.00  0.00           O  
ATOM    934  OE2 GLU A  64      29.133  67.217  -6.419  1.00  0.00           O  
ATOM    935  H   GLU A  64      30.929  70.490  -4.186  1.00  0.00           H  
ATOM    936  HA  GLU A  64      29.500  70.354  -1.912  1.00  0.00           H  
ATOM    937  HB3 GLU A  64      28.629  69.570  -4.046  1.00  0.00           H  
ATOM    938  HG3 GLU A  64      29.837  66.908  -4.074  1.00  0.00           H  
ATOM    939  N   ARG A  65      31.997  68.257  -1.916  1.00  0.00           N  
ATOM    940  CA  ARG A  65      32.785  67.348  -1.100  1.00  0.00           C  
ATOM    941  C   ARG A  65      33.641  68.134  -0.105  1.00  0.00           C  
ATOM    942  O   ARG A  65      33.995  67.621   0.956  1.00  0.00           O  
ATOM    943  CB  ARG A  65      33.695  66.476  -1.968  1.00  0.00           C  
ATOM    944  CG  ARG A  65      32.879  65.675  -2.984  1.00  0.00           C  
ATOM    945  CD  ARG A  65      33.740  65.267  -4.181  1.00  0.00           C  
ATOM    946  NE  ARG A  65      33.452  63.867  -4.560  1.00  0.00           N  
ATOM    947  CZ  ARG A  65      33.684  63.353  -5.776  1.00  0.00           C  
ATOM    948  NH1 ARG A  65      34.212  64.123  -6.738  1.00  0.00           N  
ATOM    949  NH2 ARG A  65      33.391  62.070  -6.030  1.00  0.00           N  
ATOM    950  H   ARG A  65      32.419  68.519  -2.783  1.00  0.00           H  
ATOM    951  HA  ARG A  65      32.051  66.730  -0.583  1.00  0.00           H  
ATOM    952  HB3 ARG A  65      34.265  65.796  -1.335  1.00  0.00           H  
ATOM    953  HG3 ARG A  65      32.032  66.270  -3.327  1.00  0.00           H  
ATOM    954  HD3 ARG A  65      34.796  65.375  -3.933  1.00  0.00           H  
ATOM    955  HE  ARG A  65      33.058  63.265  -3.865  1.00  0.00           H  
ATOM    956 HH11 ARG A  65      34.431  65.080  -6.549  1.00  0.00           H  
ATOM    957 HH12 ARG A  65      34.385  63.740  -7.645  1.00  0.00           H  
ATOM    958 HH21 ARG A  65      32.998  61.496  -5.311  1.00  0.00           H  
ATOM    959 HH22 ARG A  65      33.565  61.688  -6.937  1.00  0.00           H  
ATOM    960  N   LEU A  66      33.951  69.366  -0.483  1.00  0.00           N  
ATOM    961  CA  LEU A  66      34.759  70.227   0.363  1.00  0.00           C  
ATOM    962  C   LEU A  66      33.934  70.663   1.577  1.00  0.00           C  
ATOM    963  O   LEU A  66      33.008  71.462   1.448  1.00  0.00           O  
ATOM    964  CB  LEU A  66      35.325  71.395  -0.446  1.00  0.00           C  
ATOM    965  CG  LEU A  66      36.322  71.028  -1.546  1.00  0.00           C  
ATOM    966  CD1 LEU A  66      36.561  72.209  -2.487  1.00  0.00           C  
ATOM    967  CD2 LEU A  66      37.627  70.499  -0.947  1.00  0.00           C  
ATOM    968  H   LEU A  66      33.658  69.775  -1.347  1.00  0.00           H  
ATOM    969  HA  LEU A  66      35.606  69.639   0.715  1.00  0.00           H  
ATOM    970  HB3 LEU A  66      35.810  72.087   0.242  1.00  0.00           H  
ATOM    971  HG  LEU A  66      35.893  70.223  -2.142  1.00  0.00           H  
ATOM    972 HD11 LEU A  66      36.004  72.058  -3.410  1.00  0.00           H  
ATOM    973 HD12 LEU A  66      36.228  73.130  -2.007  1.00  0.00           H  
ATOM    974 HD13 LEU A  66      37.625  72.284  -2.714  1.00  0.00           H  
ATOM    975 HD21 LEU A  66      37.400  69.779  -0.161  1.00  0.00           H  
ATOM    976 HD22 LEU A  66      38.213  70.011  -1.727  1.00  0.00           H  
ATOM    977 HD23 LEU A  66      38.198  71.327  -0.530  1.00  0.00           H  
ATOM    978  N   ASP A  67      34.301  70.118   2.728  1.00  0.00           N  
ATOM    979  CA  ASP A  67      33.607  70.439   3.963  1.00  0.00           C  
ATOM    980  C   ASP A  67      34.343  71.573   4.676  1.00  0.00           C  
ATOM    981  O   ASP A  67      35.012  71.347   5.684  1.00  0.00           O  
ATOM    982  CB  ASP A  67      33.569  69.233   4.904  1.00  0.00           C  
ATOM    983  CG  ASP A  67      32.349  69.170   5.826  1.00  0.00           C  
ATOM    984  OD1 ASP A  67      31.826  70.258   6.150  1.00  0.00           O  
ATOM    985  OD2 ASP A  67      31.967  68.036   6.184  1.00  0.00           O  
ATOM    986  H   ASP A  67      35.054  69.468   2.824  1.00  0.00           H  
ATOM    987  HA  ASP A  67      32.598  70.722   3.659  1.00  0.00           H  
ATOM    988  HB3 ASP A  67      34.469  69.243   5.518  1.00  0.00           H  
ATOM    989  N   LEU A  68      34.198  72.770   4.125  1.00  0.00           N  
ATOM    990  CA  LEU A  68      34.842  73.940   4.697  1.00  0.00           C  
ATOM    991  C   LEU A  68      34.504  74.026   6.187  1.00  0.00           C  
ATOM    992  O   LEU A  68      35.219  74.672   6.952  1.00  0.00           O  
ATOM    993  CB  LEU A  68      34.467  75.197   3.908  1.00  0.00           C  
ATOM    994  CG  LEU A  68      34.415  75.042   2.386  1.00  0.00           C  
ATOM    995  CD1 LEU A  68      34.492  76.405   1.694  1.00  0.00           C  
ATOM    996  CD2 LEU A  68      35.503  74.087   1.896  1.00  0.00           C  
ATOM    997  H   LEU A  68      33.652  72.946   3.306  1.00  0.00           H  
ATOM    998  HA  LEU A  68      35.918  73.804   4.595  1.00  0.00           H  
ATOM    999  HB3 LEU A  68      35.186  75.980   4.149  1.00  0.00           H  
ATOM   1000  HG  LEU A  68      33.454  74.600   2.121  1.00  0.00           H  
ATOM   1001 HD11 LEU A  68      33.487  76.809   1.575  1.00  0.00           H  
ATOM   1002 HD12 LEU A  68      35.088  77.087   2.301  1.00  0.00           H  
ATOM   1003 HD13 LEU A  68      34.957  76.289   0.715  1.00  0.00           H  
ATOM   1004 HD21 LEU A  68      35.663  74.237   0.827  1.00  0.00           H  
ATOM   1005 HD22 LEU A  68      36.431  74.285   2.433  1.00  0.00           H  
ATOM   1006 HD23 LEU A  68      35.193  73.058   2.075  1.00  0.00           H  
ATOM   1007  N   LYS A  69      33.414  73.367   6.554  1.00  0.00           N  
ATOM   1008  CA  LYS A  69      32.974  73.361   7.938  1.00  0.00           C  
ATOM   1009  C   LYS A  69      33.987  72.593   8.788  1.00  0.00           C  
ATOM   1010  O   LYS A  69      33.907  72.603  10.015  1.00  0.00           O  
ATOM   1011  CB  LYS A  69      31.547  72.820   8.043  1.00  0.00           C  
ATOM   1012  CG  LYS A  69      30.608  73.560   7.088  1.00  0.00           C  
ATOM   1013  CD  LYS A  69      29.337  74.015   7.811  1.00  0.00           C  
ATOM   1014  CE  LYS A  69      28.121  73.934   6.885  1.00  0.00           C  
ATOM   1015  NZ  LYS A  69      27.829  75.261   6.298  1.00  0.00           N  
ATOM   1016  H   LYS A  69      32.839  72.846   5.924  1.00  0.00           H  
ATOM   1017  HA  LYS A  69      32.952  74.398   8.278  1.00  0.00           H  
ATOM   1018  HB3 LYS A  69      31.188  72.927   9.066  1.00  0.00           H  
ATOM   1019  HG3 LYS A  69      30.342  72.908   6.255  1.00  0.00           H  
ATOM   1020  HD3 LYS A  69      29.463  75.037   8.165  1.00  0.00           H  
ATOM   1021  HE3 LYS A  69      27.255  73.578   7.443  1.00  0.00           H  
ATOM   1022  HZ1 LYS A  69      27.008  75.201   5.730  1.00  0.00           H  
ATOM   1023  HZ2 LYS A  69      27.680  75.925   7.031  1.00  0.00           H  
ATOM   1024  HZ3 LYS A  69      28.603  75.554   5.735  1.00  0.00           H  
ATOM   1025  N   LYS A  70      34.918  71.946   8.103  1.00  0.00           N  
ATOM   1026  CA  LYS A  70      35.945  71.175   8.779  1.00  0.00           C  
ATOM   1027  C   LYS A  70      37.307  71.486   8.153  1.00  0.00           C  
ATOM   1028  O   LYS A  70      38.229  70.674   8.227  1.00  0.00           O  
ATOM   1029  CB  LYS A  70      35.591  69.687   8.771  1.00  0.00           C  
ATOM   1030  CG  LYS A  70      34.285  69.431   9.526  1.00  0.00           C  
ATOM   1031  CD  LYS A  70      34.384  68.162  10.377  1.00  0.00           C  
ATOM   1032  CE  LYS A  70      33.070  67.896  11.117  1.00  0.00           C  
ATOM   1033  NZ  LYS A  70      32.211  66.978  10.335  1.00  0.00           N  
ATOM   1034  H   LYS A  70      34.976  71.944   7.104  1.00  0.00           H  
ATOM   1035  HA  LYS A  70      35.963  71.497   9.821  1.00  0.00           H  
ATOM   1036  HB3 LYS A  70      36.398  69.114   9.229  1.00  0.00           H  
ATOM   1037  HG3 LYS A  70      33.464  69.335   8.816  1.00  0.00           H  
ATOM   1038  HD3 LYS A  70      35.196  68.263  11.096  1.00  0.00           H  
ATOM   1039  HE3 LYS A  70      32.546  68.837  11.289  1.00  0.00           H  
ATOM   1040  HZ1 LYS A  70      32.147  67.304   9.393  1.00  0.00           H  
ATOM   1041  HZ2 LYS A  70      32.609  66.061  10.346  1.00  0.00           H  
ATOM   1042  HZ3 LYS A  70      31.298  66.950  10.743  1.00  0.00           H  
ATOM   1043  N   ILE A  71      37.389  72.663   7.548  1.00  0.00           N  
ATOM   1044  CA  ILE A  71      38.621  73.091   6.909  1.00  0.00           C  
ATOM   1045  C   ILE A  71      39.681  73.359   7.981  1.00  0.00           C  
ATOM   1046  O   ILE A  71      39.355  73.496   9.160  1.00  0.00           O  
ATOM   1047  CB  ILE A  71      38.361  74.284   5.988  1.00  0.00           C  
ATOM   1048  CG1 ILE A  71      38.900  74.019   4.582  1.00  0.00           C  
ATOM   1049  CG2 ILE A  71      38.931  75.572   6.586  1.00  0.00           C  
ATOM   1050  CD1 ILE A  71      38.951  75.310   3.762  1.00  0.00           C  
ATOM   1051  H   ILE A  71      36.635  73.316   7.493  1.00  0.00           H  
ATOM   1052  HA  ILE A  71      38.966  72.269   6.282  1.00  0.00           H  
ATOM   1053  HB  ILE A  71      37.283  74.419   5.902  1.00  0.00           H  
ATOM   1054 HG13 ILE A  71      38.266  73.290   4.076  1.00  0.00           H  
ATOM   1055 HG21 ILE A  71      38.783  75.568   7.667  1.00  0.00           H  
ATOM   1056 HG22 ILE A  71      39.997  75.635   6.367  1.00  0.00           H  
ATOM   1057 HG23 ILE A  71      38.420  76.431   6.153  1.00  0.00           H  
ATOM   1058 HD11 ILE A  71      37.937  75.665   3.577  1.00  0.00           H  
ATOM   1059 HD12 ILE A  71      39.507  76.068   4.314  1.00  0.00           H  
ATOM   1060 HD13 ILE A  71      39.448  75.118   2.811  1.00  0.00           H  
ATOM   1061  N   GLN A  72      40.926  73.427   7.534  1.00  0.00           N  
ATOM   1062  CA  GLN A  72      42.034  73.677   8.439  1.00  0.00           C  
ATOM   1063  C   GLN A  72      43.162  74.406   7.708  1.00  0.00           C  
ATOM   1064  O   GLN A  72      44.262  73.873   7.565  1.00  0.00           O  
ATOM   1065  CB  GLN A  72      42.537  72.374   9.062  1.00  0.00           C  
ATOM   1066  CG  GLN A  72      41.495  71.784  10.016  1.00  0.00           C  
ATOM   1067  CD  GLN A  72      42.133  70.761  10.959  1.00  0.00           C  
ATOM   1068  OE1 GLN A  72      42.550  71.070  12.063  1.00  0.00           O  
ATOM   1069  NE2 GLN A  72      42.184  69.527  10.463  1.00  0.00           N  
ATOM   1070  H   GLN A  72      41.181  73.315   6.573  1.00  0.00           H  
ATOM   1071  HA  GLN A  72      41.628  74.315   9.225  1.00  0.00           H  
ATOM   1072  HB3 GLN A  72      43.466  72.560   9.603  1.00  0.00           H  
ATOM   1073  HG3 GLN A  72      40.700  71.310   9.444  1.00  0.00           H  
ATOM   1074 HE21 GLN A  72      41.824  69.341   9.550  1.00  0.00           H  
ATOM   1075 HE22 GLN A  72      42.583  68.788  11.005  1.00  0.00           H  
ATOM   1076  N   PHE A  73      42.853  75.616   7.264  1.00  0.00           N  
ATOM   1077  CA  PHE A  73      43.827  76.424   6.551  1.00  0.00           C  
ATOM   1078  C   PHE A  73      45.227  76.244   7.143  1.00  0.00           C  
ATOM   1079  O   PHE A  73      45.369  75.916   8.320  1.00  0.00           O  
ATOM   1080  CB  PHE A  73      43.402  77.885   6.715  1.00  0.00           C  
ATOM   1081  CG  PHE A  73      42.343  78.341   5.707  1.00  0.00           C  
ATOM   1082  CD1 PHE A  73      41.036  78.020   5.903  1.00  0.00           C  
ATOM   1083  CD2 PHE A  73      42.710  79.066   4.617  1.00  0.00           C  
ATOM   1084  CE1 PHE A  73      40.055  78.443   4.969  1.00  0.00           C  
ATOM   1085  CE2 PHE A  73      41.728  79.488   3.682  1.00  0.00           C  
ATOM   1086  CZ  PHE A  73      40.421  79.168   3.878  1.00  0.00           C  
ATOM   1087  H   PHE A  73      41.957  76.044   7.385  1.00  0.00           H  
ATOM   1088  HA  PHE A  73      43.828  76.091   5.514  1.00  0.00           H  
ATOM   1089  HB3 PHE A  73      44.280  78.522   6.616  1.00  0.00           H  
ATOM   1090  HD1 PHE A  73      40.742  77.439   6.777  1.00  0.00           H  
ATOM   1091  HD2 PHE A  73      43.758  79.322   4.460  1.00  0.00           H  
ATOM   1092  HE1 PHE A  73      39.007  78.187   5.126  1.00  0.00           H  
ATOM   1093  HE2 PHE A  73      42.022  80.069   2.808  1.00  0.00           H  
ATOM   1094  HZ  PHE A  73      39.668  79.493   3.161  1.00  0.00           H  
ATOM   1095  N   PRO A  74      46.251  76.474   6.278  1.00  0.00           N  
ATOM   1096  CA  PRO A  74      47.634  76.341   6.703  1.00  0.00           C  
ATOM   1097  C   PRO A  74      48.057  77.526   7.573  1.00  0.00           C  
ATOM   1098  O   PRO A  74      47.481  78.609   7.475  1.00  0.00           O  
ATOM   1099  CB  PRO A  74      48.433  76.234   5.415  1.00  0.00           C  
ATOM   1100  CG  PRO A  74      47.530  76.774   4.318  1.00  0.00           C  
ATOM   1101  CD  PRO A  74      46.119  76.865   4.879  1.00  0.00           C  
ATOM   1102  HA  PRO A  74      47.744  75.529   7.277  1.00  0.00           H  
ATOM   1103  HB3 PRO A  74      48.713  75.199   5.214  1.00  0.00           H  
ATOM   1104  HG3 PRO A  74      47.553  76.121   3.447  1.00  0.00           H  
ATOM   1105  HD3 PRO A  74      45.439  76.202   4.345  1.00  0.00           H  
ATOM   1106  N   LYS A  75      49.060  77.282   8.402  1.00  0.00           N  
ATOM   1107  CA  LYS A  75      49.568  78.316   9.289  1.00  0.00           C  
ATOM   1108  C   LYS A  75      50.899  78.838   8.747  1.00  0.00           C  
ATOM   1109  O   LYS A  75      51.956  78.557   9.311  1.00  0.00           O  
ATOM   1110  CB  LYS A  75      49.650  77.798  10.726  1.00  0.00           C  
ATOM   1111  CG  LYS A  75      50.067  78.911  11.688  1.00  0.00           C  
ATOM   1112  CD  LYS A  75      49.322  78.794  13.019  1.00  0.00           C  
ATOM   1113  CE  LYS A  75      50.212  79.233  14.184  1.00  0.00           C  
ATOM   1114  NZ  LYS A  75      49.456  79.193  15.456  1.00  0.00           N  
ATOM   1115  H   LYS A  75      49.522  76.399   8.476  1.00  0.00           H  
ATOM   1116  HA  LYS A  75      48.847  79.135   9.281  1.00  0.00           H  
ATOM   1117  HB3 LYS A  75      50.365  76.978  10.781  1.00  0.00           H  
ATOM   1118  HG3 LYS A  75      49.862  79.883  11.236  1.00  0.00           H  
ATOM   1119  HD3 LYS A  75      49.001  77.765  13.170  1.00  0.00           H  
ATOM   1120  HE3 LYS A  75      50.584  80.243  14.006  1.00  0.00           H  
ATOM   1121  HZ1 LYS A  75      48.537  78.837  15.287  1.00  0.00           H  
ATOM   1122  HZ2 LYS A  75      49.929  78.601  16.107  1.00  0.00           H  
ATOM   1123  HZ3 LYS A  75      49.390  80.118  15.834  1.00  0.00           H  
ATOM   1124  N   LYS A  76      50.806  79.588   7.658  1.00  0.00           N  
ATOM   1125  CA  LYS A  76      51.991  80.151   7.034  1.00  0.00           C  
ATOM   1126  C   LYS A  76      52.407  81.415   7.789  1.00  0.00           C  
ATOM   1127  O   LYS A  76      51.585  82.295   8.035  1.00  0.00           O  
ATOM   1128  CB  LYS A  76      51.751  80.379   5.539  1.00  0.00           C  
ATOM   1129  CG  LYS A  76      53.075  80.562   4.794  1.00  0.00           C  
ATOM   1130  CD  LYS A  76      53.162  79.621   3.591  1.00  0.00           C  
ATOM   1131  CE  LYS A  76      54.216  78.536   3.817  1.00  0.00           C  
ATOM   1132  NZ  LYS A  76      55.477  78.885   3.126  1.00  0.00           N  
ATOM   1133  H   LYS A  76      49.942  79.812   7.206  1.00  0.00           H  
ATOM   1134  HA  LYS A  76      52.789  79.415   7.123  1.00  0.00           H  
ATOM   1135  HB3 LYS A  76      51.125  81.261   5.398  1.00  0.00           H  
ATOM   1136  HG3 LYS A  76      53.907  80.371   5.472  1.00  0.00           H  
ATOM   1137  HD3 LYS A  76      53.409  80.192   2.696  1.00  0.00           H  
ATOM   1138  HE3 LYS A  76      53.847  77.578   3.451  1.00  0.00           H  
ATOM   1139  HZ1 LYS A  76      55.582  78.311   2.314  1.00  0.00           H  
ATOM   1140  HZ2 LYS A  76      55.452  79.848   2.853  1.00  0.00           H  
ATOM   1141  HZ3 LYS A  76      56.249  78.735   3.744  1.00  0.00           H  
ATOM   1142  N   GLU A  77      53.685  81.463   8.136  1.00  0.00           N  
ATOM   1143  CA  GLU A  77      54.222  82.604   8.858  1.00  0.00           C  
ATOM   1144  C   GLU A  77      53.525  82.751  10.212  1.00  0.00           C  
ATOM   1145  O   GLU A  77      52.336  82.464  10.337  1.00  0.00           O  
ATOM   1146  CB  GLU A  77      54.092  83.886   8.033  1.00  0.00           C  
ATOM   1147  CG  GLU A  77      55.392  84.693   8.066  1.00  0.00           C  
ATOM   1148  CD  GLU A  77      55.132  86.132   8.515  1.00  0.00           C  
ATOM   1149  OE1 GLU A  77      54.499  86.868   7.728  1.00  0.00           O  
ATOM   1150  OE2 GLU A  77      55.573  86.464   9.637  1.00  0.00           O  
ATOM   1151  H   GLU A  77      54.348  80.742   7.932  1.00  0.00           H  
ATOM   1152  HA  GLU A  77      55.278  82.381   9.008  1.00  0.00           H  
ATOM   1153  HB3 GLU A  77      53.275  84.491   8.422  1.00  0.00           H  
ATOM   1154  HG3 GLU A  77      55.849  84.694   7.076  1.00  0.00           H  
ATOM   1155  N   ALA A  78      54.296  83.198  11.193  1.00  0.00           N  
ATOM   1156  CA  ALA A  78      53.767  83.386  12.534  1.00  0.00           C  
ATOM   1157  C   ALA A  78      52.591  84.363  12.481  1.00  0.00           C  
ATOM   1158  O   ALA A  78      52.622  85.338  11.731  1.00  0.00           O  
ATOM   1159  CB  ALA A  78      54.885  83.869  13.459  1.00  0.00           C  
ATOM   1160  H   ALA A  78      55.263  83.430  11.083  1.00  0.00           H  
ATOM   1161  HA  ALA A  78      53.409  82.418  12.888  1.00  0.00           H  
ATOM   1162  HB1 ALA A  78      55.851  83.699  12.984  1.00  0.00           H  
ATOM   1163  HB2 ALA A  78      54.760  84.934  13.656  1.00  0.00           H  
ATOM   1164  HB3 ALA A  78      54.841  83.319  14.401  1.00  0.00           H  
ATOM   1165  N   LYS A  79      51.580  84.066  13.285  1.00  0.00           N  
ATOM   1166  CA  LYS A  79      50.396  84.908  13.340  1.00  0.00           C  
ATOM   1167  C   LYS A  79      50.538  85.906  14.489  1.00  0.00           C  
ATOM   1168  O   LYS A  79      50.331  85.556  15.650  1.00  0.00           O  
ATOM   1169  CB  LYS A  79      49.134  84.048  13.422  1.00  0.00           C  
ATOM   1170  CG  LYS A  79      48.392  84.031  12.085  1.00  0.00           C  
ATOM   1171  CD  LYS A  79      47.110  84.861  12.157  1.00  0.00           C  
ATOM   1172  CE  LYS A  79      46.941  85.723  10.904  1.00  0.00           C  
ATOM   1173  NZ  LYS A  79      45.630  86.407  10.917  1.00  0.00           N  
ATOM   1174  H   LYS A  79      51.562  83.272  13.891  1.00  0.00           H  
ATOM   1175  HA  LYS A  79      50.347  85.463  12.402  1.00  0.00           H  
ATOM   1176  HB3 LYS A  79      48.476  84.436  14.202  1.00  0.00           H  
ATOM   1177  HG3 LYS A  79      48.150  83.003  11.812  1.00  0.00           H  
ATOM   1178  HD3 LYS A  79      47.134  85.498  13.041  1.00  0.00           H  
ATOM   1179  HE3 LYS A  79      47.024  85.100  10.014  1.00  0.00           H  
ATOM   1180  HZ1 LYS A  79      45.261  86.440   9.988  1.00  0.00           H  
ATOM   1181  HZ2 LYS A  79      44.999  85.906  11.510  1.00  0.00           H  
ATOM   1182  HZ3 LYS A  79      45.743  87.339  11.263  1.00  0.00           H  
ATOM   1183  N   THR A  80      50.888  87.131  14.127  1.00  0.00           N  
ATOM   1184  CA  THR A  80      51.059  88.184  15.113  1.00  0.00           C  
ATOM   1185  C   THR A  80      51.036  89.557  14.439  1.00  0.00           C  
ATOM   1186  O   THR A  80      51.482  89.702  13.302  1.00  0.00           O  
ATOM   1187  CB  THR A  80      52.354  87.907  15.880  1.00  0.00           C  
ATOM   1188  OG1 THR A  80      52.656  89.149  16.512  1.00  0.00           O  
ATOM   1189  CG2 THR A  80      53.545  87.664  14.951  1.00  0.00           C  
ATOM   1190  H   THR A  80      51.055  87.409  13.180  1.00  0.00           H  
ATOM   1191  HA  THR A  80      50.215  88.151  15.801  1.00  0.00           H  
ATOM   1192  HB  THR A  80      52.226  87.077  16.573  1.00  0.00           H  
ATOM   1193  HG1 THR A  80      53.328  89.008  17.239  1.00  0.00           H  
ATOM   1194 HG21 THR A  80      53.280  86.909  14.210  1.00  0.00           H  
ATOM   1195 HG22 THR A  80      53.807  88.593  14.445  1.00  0.00           H  
ATOM   1196 HG23 THR A  80      54.397  87.316  15.534  1.00  0.00           H  
ATOM   1197  N   PRO A  81      50.493  90.556  15.187  1.00  0.00           N  
ATOM   1198  CA  PRO A  81      50.405  91.911  14.674  1.00  0.00           C  
ATOM   1199  C   PRO A  81      51.774  92.595  14.689  1.00  0.00           C  
ATOM   1200  O   PRO A  81      52.800  91.934  14.843  1.00  0.00           O  
ATOM   1201  CB  PRO A  81      49.385  92.604  15.563  1.00  0.00           C  
ATOM   1202  CG  PRO A  81      49.287  91.756  16.821  1.00  0.00           C  
ATOM   1203  CD  PRO A  81      49.955  90.420  16.536  1.00  0.00           C  
ATOM   1204  HA  PRO A  81      50.115  91.902  13.715  1.00  0.00           H  
ATOM   1205  HB3 PRO A  81      48.418  92.677  15.066  1.00  0.00           H  
ATOM   1206  HG3 PRO A  81      48.245  91.610  17.103  1.00  0.00           H  
ATOM   1207  HD3 PRO A  81      49.238  89.600  16.596  1.00  0.00           H  
ATOM   1208  N   SER A  82      51.745  93.911  14.528  1.00  0.00           N  
ATOM   1209  CA  SER A  82      52.971  94.690  14.523  1.00  0.00           C  
ATOM   1210  C   SER A  82      52.653  96.161  14.254  1.00  0.00           C  
ATOM   1211  O   SER A  82      52.323  96.534  13.128  1.00  0.00           O  
ATOM   1212  CB  SER A  82      53.955  94.161  13.477  1.00  0.00           C  
ATOM   1213  OG  SER A  82      55.303  94.215  13.937  1.00  0.00           O  
ATOM   1214  H   SER A  82      50.907  94.440  14.404  1.00  0.00           H  
ATOM   1215  HA  SER A  82      53.397  94.566  15.517  1.00  0.00           H  
ATOM   1216  HB3 SER A  82      53.860  94.744  12.561  1.00  0.00           H  
ATOM   1217  HG  SER A  82      55.540  93.364  14.405  1.00  0.00           H  
ATOM   1218  N   GLY A  83      52.764  96.960  15.306  1.00  0.00           N  
ATOM   1219  CA  GLY A  83      52.492  98.383  15.198  1.00  0.00           C  
ATOM   1220  C   GLY A  83      52.995  98.938  13.864  1.00  0.00           C  
ATOM   1221  O   GLY A  83      54.193  99.155  13.691  1.00  0.00           O  
ATOM   1222  H   GLY A  83      53.033  96.649  16.218  1.00  0.00           H  
ATOM   1223  HA2 GLY A  83      51.421  98.560  15.289  1.00  0.00           H  
ATOM   1224  HA3 GLY A  83      52.974  98.912  16.021  1.00  0.00           H  
ATOM   1225  N   PRO A  84      52.031  99.158  12.932  1.00  0.00           N  
ATOM   1226  CA  PRO A  84      52.363  99.683  11.619  1.00  0.00           C  
ATOM   1227  C   PRO A  84      52.682 101.178  11.691  1.00  0.00           C  
ATOM   1228  O   PRO A  84      51.845 101.975  12.107  1.00  0.00           O  
ATOM   1229  CB  PRO A  84      51.152  99.375  10.753  1.00  0.00           C  
ATOM   1230  CG  PRO A  84      50.008  99.109  11.717  1.00  0.00           C  
ATOM   1231  CD  PRO A  84      50.602  98.913  13.102  1.00  0.00           C  
ATOM   1232  HA  PRO A  84      53.191  99.244  11.268  1.00  0.00           H  
ATOM   1233  HB3 PRO A  84      51.338  98.509  10.117  1.00  0.00           H  
ATOM   1234  HG3 PRO A  84      49.450  98.224  11.411  1.00  0.00           H  
ATOM   1235  HD3 PRO A  84      50.413  97.905  13.474  1.00  0.00           H  
ATOM   1236  N   SER A  85      53.897 101.510  11.279  1.00  0.00           N  
ATOM   1237  CA  SER A  85      54.337 102.896  11.291  1.00  0.00           C  
ATOM   1238  C   SER A  85      54.438 103.425   9.860  1.00  0.00           C  
ATOM   1239  O   SER A  85      54.936 102.735   8.973  1.00  0.00           O  
ATOM   1240  CB  SER A  85      55.681 103.040  12.007  1.00  0.00           C  
ATOM   1241  OG  SER A  85      55.548 103.688  13.269  1.00  0.00           O  
ATOM   1242  H   SER A  85      54.573 100.855  10.942  1.00  0.00           H  
ATOM   1243  HA  SER A  85      53.570 103.437  11.847  1.00  0.00           H  
ATOM   1244  HB3 SER A  85      56.368 103.607  11.378  1.00  0.00           H  
ATOM   1245  HG  SER A  85      55.520 103.007  14.001  1.00  0.00           H  
ATOM   1246  N   SER A  86      53.958 104.648   9.680  1.00  0.00           N  
ATOM   1247  CA  SER A  86      53.988 105.279   8.371  1.00  0.00           C  
ATOM   1248  C   SER A  86      53.152 104.466   7.379  1.00  0.00           C  
ATOM   1249  O   SER A  86      53.497 103.331   7.054  1.00  0.00           O  
ATOM   1250  CB  SER A  86      55.424 105.423   7.862  1.00  0.00           C  
ATOM   1251  OG  SER A  86      55.871 104.249   7.188  1.00  0.00           O  
ATOM   1252  H   SER A  86      53.554 105.203  10.408  1.00  0.00           H  
ATOM   1253  HA  SER A  86      53.554 106.268   8.517  1.00  0.00           H  
ATOM   1254  HB3 SER A  86      56.087 105.633   8.701  1.00  0.00           H  
ATOM   1255  HG  SER A  86      56.017 103.512   7.845  1.00  0.00           H  
ATOM   1256  N   GLY A  87      52.069 105.081   6.926  1.00  0.00           N  
ATOM   1257  CA  GLY A  87      51.181 104.429   5.978  1.00  0.00           C  
ATOM   1258  C   GLY A  87      50.335 105.456   5.224  1.00  0.00           C  
ATOM   1259  O   GLY A  87      50.371 105.515   3.996  1.00  0.00           O  
ATOM   1260  H   GLY A  87      51.795 106.004   7.194  1.00  0.00           H  
ATOM   1261  HA2 GLY A  87      51.767 103.843   5.269  1.00  0.00           H  
ATOM   1262  HA3 GLY A  87      50.529 103.731   6.504  1.00  0.00           H  
TER    1263      GLY A  87                                                      
END
MOLECULE T0504_1_62.pdb
ATOM      1  N   GLU     1      40.590  77.876 -15.783  1.00 30.37          
ATOM      2  CA  GLU     1      41.814  78.514 -15.208  1.00 29.83          
ATOM      3  CB  GLU     1      41.570  79.973 -14.814  1.00 30.78          
ATOM      4  CG  GLU     1      40.717  80.800 -15.730  1.00 32.39          
ATOM      5  CD  GLU     1      40.476  82.164 -15.158  1.00 36.16          
ATOM      6  OE1 GLU     1      41.462  82.859 -14.819  1.00 34.97          
ATOM      7  OE2 GLU     1      39.290  82.537 -15.017  1.00 38.44          
ATOM      8  C   GLU     1      42.188  77.797 -13.930  1.00 29.49          
ATOM      9  O   GLU     1      41.335  77.161 -13.297  1.00 30.06          
ATOM     10  N   ASN     2      43.451  77.929 -13.536  1.00 27.86          
ATOM     11  CA  ASN     2      43.913  77.388 -12.251  1.00 26.98          
ATOM     12  CB  ASN     2      45.313  76.828 -12.390  1.00 27.58          
ATOM     13  CG  ASN     2      45.366  75.684 -13.366  1.00 31.84          
ATOM     14  OD1 ASN     2      44.621  74.710 -13.223  1.00 34.71          
ATOM     15  ND2 ASN     2      46.230  75.798 -14.381  1.00 36.97          
ATOM     16  C   ASN     2      43.921  78.518 -11.257  1.00 25.53          
ATOM     17  O   ASN     2      44.527  79.573 -11.531  1.00 25.15          
ATOM     18  N   LEU     3      43.229  78.314 -10.140  1.00 22.85          
ATOM     19  CA  LEU     3      43.169  79.321  -9.090  1.00 22.02          
ATOM     20  CB  LEU     3      41.724  79.562  -8.641  1.00 21.25          
ATOM     21  CG  LEU     3      40.728  79.872  -9.762  1.00 22.02          
ATOM     22  CD1 LEU     3      39.336  80.029  -9.203  1.00 22.09          
ATOM     23  CD2 LEU     3      41.165  81.100 -10.561  1.00 22.44          
ATOM     24  C   LEU     3      43.975  78.930  -7.867  1.00 21.19          
ATOM     25  O   LEU     3      44.197  77.753  -7.613  1.00 21.84          
ATOM     26  N   TYR     4      44.395  79.937  -7.100  1.00 20.57          
ATOM     27  CA  TYR     4      45.008  79.700  -5.793  1.00 20.42          
ATOM     28  CB  TYR     4      46.312  80.486  -5.638  1.00 21.98          
ATOM     29  CG  TYR     4      47.299  79.768  -4.750  1.00 23.50          
ATOM     30  CD1 TYR     4      48.147  78.800  -5.292  1.00 25.82          
ATOM     31  CE1 TYR     4      49.053  78.124  -4.504  1.00 26.45          
ATOM     32  CZ  TYR     4      49.131  78.390  -3.152  1.00 26.13          
ATOM     33  OH  TYR     4      50.045  77.666  -2.424  1.00 27.65          
ATOM     34  CE2 TYR     4      48.291  79.354  -2.548  1.00 25.20          
ATOM     35  CD2 TYR     4      47.354  80.024  -3.372  1.00 23.73          
ATOM     36  C   TYR     4      44.063  80.041  -4.642  1.00 20.61          
ATOM     37  O   TYR     4      44.171  79.461  -3.553  1.00 20.26          
ATOM     38  N   PHE     5      43.163  80.991  -4.903  1.00 20.30          
ATOM     39  CA  PHE     5      42.115  81.416  -3.977  1.00 20.43          
ATOM     40  CB  PHE     5      42.293  82.886  -3.614  1.00 21.10          
ATOM     41  CG  PHE     5      43.654  83.202  -3.061  1.00 20.27          
ATOM     42  CD1 PHE     5      43.870  83.193  -1.692  1.00 20.53          
ATOM     43  CE1 PHE     5      45.133  83.463  -1.170  1.00 20.63          
ATOM     44  CZ  PHE     5      46.191  83.752  -2.038  1.00 21.66          
ATOM     45  CE2 PHE     5      45.987  83.733  -3.406  1.00 21.69          
ATOM     46  CD2 PHE     5      44.720  83.478  -3.917  1.00 21.08          
ATOM     47  C   PHE     5      40.749  81.257  -4.650  1.00 20.65          
ATOM     48  O   PHE     5      40.597  81.482  -5.860  1.00 20.56          
ATOM     49  N   GLN     6      39.754  80.887  -3.861  1.00 20.36          
ATOM     50  CA  GLN     6      38.399  80.756  -4.396  1.00 21.14          
ATOM     51  CB  GLN     6      38.229  79.390  -5.065  1.00 20.23          
ATOM     52  CG  GLN     6      36.969  79.226  -5.900  1.00 22.69          
ATOM     53  CD  GLN     6      35.703  79.207  -5.058  1.00 22.80          
ATOM     54  OE1 GLN     6      35.473  78.253  -4.316  1.00 22.70          
ATOM     55  NE2 GLN     6      34.867  80.260  -5.177  1.00 22.90          
ATOM     56  C   GLN     6      37.476  80.935  -3.216  1.00 21.19          
ATOM     57  O   GLN     6      37.416  80.062  -2.345  1.00 21.02          
ATOM     58  N   GLY     7      36.789  82.078  -3.155  1.00 21.63          
ATOM     59  CA  GLY     7      36.054  82.433  -1.940  1.00 21.46          
ATOM     60  C   GLY     7      37.022  82.377  -0.779  1.00 22.41          
ATOM     61  O   GLY     7      38.111  82.951  -0.847  1.00 22.44          
ATOM     62  N   ASP     8      36.668  81.629   0.265  1.00 21.77          
ATOM     63  CA  ASP     8      37.546  81.521   1.425  1.00 22.30          
ATOM     64  CB  ASP     8      36.751  81.547   2.720  1.00 23.54          
ATOM     65  CG  ASP     8      35.812  80.351   2.870  1.00 25.43          
ATOM     66  OD1 ASP     8      35.768  79.461   1.981  1.00 23.86          
ATOM     67  OD2 ASP     8      35.061  80.353   3.877  1.00 28.63          
ATOM     68  C   ASP     8      38.455  80.296   1.429  1.00 21.60          
ATOM     69  O   ASP     8      39.057  79.991   2.454  1.00 21.73          
ATOM     70  N   LEU     9      38.560  79.618   0.292  1.00 20.56          
ATOM     71  CA  LEU     9      39.448  78.475   0.181  1.00 19.77          
ATOM     72  CB  LEU     9      38.826  77.400  -0.711  1.00 19.79          
ATOM     73  CG  LEU     9      37.683  76.599  -0.100  1.00 20.44          
ATOM     74  CD1 LEU     9      37.011  75.810  -1.189  1.00 22.81          
ATOM     75  CD2 LEU     9      38.177  75.660   0.980  1.00 21.75          
ATOM     76  C   LEU     9      40.777  78.946  -0.390  1.00 20.16          
ATOM     77  O   LEU     9      40.795  79.841  -1.237  1.00 20.21          
ATOM     78  N   ILE    10      41.871  78.323   0.061  1.00 19.94          
ATOM     79  CA  ILE    10      43.235  78.646  -0.388  1.00 19.76          
ATOM     80  CB  ILE    10      43.999  79.521   0.663  1.00 19.23          
ATOM     81  CG1 ILE    10      43.199  80.772   1.034  1.00 20.89          
ATOM     82  CD  ILE    10      43.756  81.529   2.264  1.00 19.82          
ATOM     83  CG2 ILE    10      45.444  79.895   0.160  1.00 21.10          
ATOM     84  C   ILE    10      43.977  77.335  -0.624  1.00 19.82          
ATOM     85  O   ILE    10      43.917  76.412   0.207  1.00 19.77          
ATOM     86  N   VAL    11      44.659  77.243  -1.759  1.00 20.59          
ATOM     87  CA  VAL    11      45.495  76.070  -2.059  1.00 21.06          
ATOM     88  CB  VAL    11      46.171  76.201  -3.469  1.00 21.08          
ATOM     89  CG1 VAL    11      47.279  75.145  -3.651  1.00 22.60          
ATOM     90  CG2 VAL    11      45.124  76.032  -4.570  1.00 21.92          
ATOM     91  C   VAL    11      46.502  75.859  -0.924  1.00 22.05          
ATOM     92  O   VAL    11      47.032  76.837  -0.375  1.00 21.69          
ATOM     93  N   SER    12      46.729  74.581  -0.573  1.00 22.61          
ATOM     94  CA  SER    12      47.585  74.124   0.560  1.00 24.09          
ATOM     95  CB  SER    12      48.853  74.986   0.721  1.00 24.98          
ATOM     96  OG  SER    12      48.545  76.155   1.461  1.00 28.77          
ATOM     97  C   SER    12      46.846  73.965   1.901  1.00 24.91          
ATOM     98  O   SER    12      47.389  73.400   2.858  1.00 24.32          
ATOM     99  N   MET    13      45.601  74.450   1.986  1.00 25.08          
ATOM    100  CA  MET    13      44.832  74.263   3.213  1.00 26.70          
ATOM    101  CB  MET    13      43.538  75.070   3.186  1.00 26.79          
ATOM    102  CG  MET    13      42.577  74.588   2.191  1.00 26.89          
ATOM    103  SD  MET    13      41.104  75.607   2.200  1.00 34.11          
ATOM    104  CE  MET    13      41.664  77.083   3.022  1.00 16.35          
ATOM    105  C   MET    13      44.523  72.782   3.457  1.00 25.22          
ATOM    106  O   MET    13      44.411  71.989   2.519  1.00 24.56          
ATOM    107  N   ARG    14      44.428  72.427   4.725  1.00 24.80          
ATOM    108  CA  ARG    14      43.983  71.096   5.114  1.00 25.49          
ATOM    109  CB  ARG    14      44.551  70.760   6.484  1.00 26.73          
ATOM    110  CG  ARG    14      46.073  70.744   6.489  1.00 29.59          
ATOM    111  CD  ARG    14      46.562  69.465   5.835  1.00 35.95          
ATOM    112  NE  ARG    14      46.405  68.332   6.754  1.00 36.61          
ATOM    113  CZ  ARG    14      46.274  67.070   6.365  1.00 38.50          
ATOM    114  NH1 ARG    14      46.280  66.761   5.076  1.00 39.44          
ATOM    115  NH2 ARG    14      46.149  66.113   7.273  1.00 41.31          
ATOM    116  C   ARG    14      42.451  71.097   5.132  1.00 25.43          
ATOM    117  O   ARG    14      41.839  72.038   5.645  1.00 27.04          
ATOM    118  N   ILE    15      41.833  70.079   4.550  1.00 23.91          
ATOM    119  CA  ILE    15      40.372  70.018   4.470  1.00 23.92          
ATOM    120  CB  ILE    15      39.823  70.552   3.109  1.00 24.59          
ATOM    121  CG1 ILE    15      40.618  69.962   1.947  1.00 25.51          
ATOM    122  CD  ILE    15      39.996  70.306   0.585  1.00 27.05          
ATOM    123  CG2 ILE    15      39.787  72.098   3.129  1.00 27.98          
ATOM    124  C   ILE    15      39.932  68.579   4.635  1.00 21.96          
ATOM    125  O   ILE    15      40.790  67.689   4.769  1.00 21.85          
ATOM    126  N   LEU    16      38.617  68.362   4.645  1.00 20.39          
ATOM    127  CA  LEU    16      38.052  67.017   4.517  1.00 19.24          
ATOM    128  CB  LEU    16      36.906  66.808   5.514  1.00 20.17          
ATOM    129  CG  LEU    16      37.256  66.922   7.002  1.00 20.85          
ATOM    130  CD1 LEU    16      35.968  66.980   7.801  1.00 22.99          
ATOM    131  CD2 LEU    16      38.092  65.713   7.450  1.00 25.18          
ATOM    132  C   LEU    16      37.544  66.793   3.084  1.00 19.28          
ATOM    133  O   LEU    16      36.953  67.693   2.466  1.00 18.31          
ATOM    134  N   GLY    17      37.757  65.589   2.551  1.00 18.22          
ATOM    135  CA  GLY    17      37.195  65.264   1.241  1.00 18.80          
ATOM    136  C   GLY    17      36.401  63.974   1.287  1.00 19.12          
ATOM    137  O   GLY    17      36.672  63.115   2.125  1.00 19.61          
ATOM    138  N   LYS    18      35.444  63.846   0.372  1.00 18.83          
ATOM    139  CA  LYS    18      34.599  62.680   0.281  1.00 19.17          
ATOM    140  CB  LYS    18      33.224  63.061  -0.290  1.00 18.50          
ATOM    141  CG  LYS    18      32.187  61.951  -0.219  1.00 16.64          
ATOM    142  CD  LYS    18      30.860  62.428  -0.817  1.00 18.12          
ATOM    143  CE  LYS    18      29.778  61.359  -0.612  1.00 20.74          
ATOM    144  NZ  LYS    18      28.507  61.699  -1.285  1.00 19.73          
ATOM    145  C   LYS    18      35.264  61.665  -0.605  1.00 20.38          
ATOM    146  O   LYS    18      35.539  61.941  -1.784  1.00 20.23          
ATOM    147  N   LYS    19      35.558  60.506  -0.022  1.00 20.11          
ATOM    148  CA  LYS    19      36.101  59.383  -0.780  1.00 21.79          
ATOM    149  CB  LYS    19      36.903  58.458   0.154  1.00 21.26          
ATOM    150  CG  LYS    19      38.288  58.989   0.439  1.00 21.88          
ATOM    151  CD  LYS    19      39.203  57.908   0.947  1.00 25.99          
ATOM    152  CE  LYS    19      40.488  58.512   1.408  1.00 27.04          
ATOM    153  NZ  LYS    19      41.498  57.436   1.722  1.00 29.94          
ATOM    154  C   LYS    19      34.980  58.621  -1.523  1.00 21.81          
ATOM    155  O   LYS    19      33.779  58.816  -1.283  1.00 21.30          
ATOM    156  N   ARG    20      35.377  57.761  -2.454  1.00 21.76          
ATOM    157  CA  ARG    20      34.423  56.964  -3.224  1.00 23.24          
ATOM    158  CB  ARG    20      35.188  56.198  -4.301  1.00 23.99          
ATOM    159  CG  ARG    20      35.769  57.101  -5.347  1.00 26.44          
ATOM    160  CD  ARG    20      36.481  56.292  -6.396  1.00 31.93          
ATOM    161  NE  ARG    20      35.543  55.449  -7.128  1.00 34.65          
ATOM    162  CZ  ARG    20      35.021  55.752  -8.309  1.00 36.27          
ATOM    163  NH1 ARG    20      35.367  56.882  -8.915  1.00 39.35          
ATOM    164  NH2 ARG    20      34.175  54.914  -8.901  1.00 33.75          
ATOM    165  C   ARG    20      33.591  56.000  -2.365  1.00 23.01          
ATOM    166  O   ARG    20      32.502  55.562  -2.771  1.00 24.04          
ATOM    167  N   THR    21      34.111  55.697  -1.175  1.00 23.23          
ATOM    168  CA  THR    21      33.439  54.873  -0.171  1.00 23.54          
ATOM    169  CB  THR    21      34.413  54.508   0.942  1.00 23.45          
ATOM    170  OG1 THR    21      35.067  55.703   1.398  1.00 24.78          
ATOM    171  CG2 THR    21      35.477  53.500   0.469  1.00 23.28          
ATOM    172  C   THR    21      32.253  55.638   0.453  1.00 23.38          
ATOM    173  O   THR    21      31.436  55.061   1.208  1.00 22.92          
ATOM    174  N   LYS    22      32.166  56.932   0.120  1.00 22.59          
ATOM    175  CA  LYS    22      31.163  57.885   0.656  1.00 23.14          
ATOM    176  CB  LYS    22      29.689  57.433   0.534  1.00 24.57          
ATOM    177  CG  LYS    22      29.230  56.877  -0.821  1.00 26.45          
ATOM    178  CD  LYS    22      29.467  57.788  -2.015  1.00 28.60          
ATOM    179  CE  LYS    22      29.021  57.085  -3.323  1.00 31.60          
ATOM    180  NZ  LYS    22      29.286  57.940  -4.535  1.00 35.41          
ATOM    181  C   LYS    22      31.503  58.308   2.092  1.00 22.65          
ATOM    182  O   LYS    22      30.738  59.043   2.716  1.00 23.29          
ATOM    183  N   THR    23      32.643  57.866   2.617  1.00 21.11          
ATOM    184  CA  THR    23      33.091  58.367   3.932  1.00 20.84          
ATOM    185  CB  THR    23      33.682  57.251   4.819  1.00 21.56          
ATOM    186  OG1 THR    23      34.810  56.650   4.157  1.00 22.85          
ATOM    187  CG2 THR    23      32.594  56.158   5.084  1.00 22.10          
ATOM    188  C   THR    23      34.107  59.492   3.718  1.00 20.11          
ATOM    189  O   THR    23      34.720  59.575   2.658  1.00 18.72          
ATOM    190  N   TRP    24      34.296  60.328   4.738  1.00 19.67          
ATOM    191  CA  TRP    24      35.116  61.540   4.582  1.00 20.31          
ATOM    192  CB  TRP    24      34.311  62.791   4.991  1.00 19.09          
ATOM    193  CG  TRP    24      33.088  63.026   4.161  1.00 20.47          
ATOM    194  CD1 TRP    24      32.006  62.204   4.025  1.00 18.88          
ATOM    195  NE1 TRP    24      31.073  62.768   3.177  1.00 17.63          
ATOM    196  CE2 TRP    24      31.541  63.988   2.761  1.00 19.14          
ATOM    197  CD2 TRP    24      32.816  64.182   3.362  1.00 19.29          
ATOM    198  CE3 TRP    24      33.522  65.362   3.098  1.00 20.05          
ATOM    199  CZ3 TRP    24      32.941  66.308   2.256  1.00 17.65          
ATOM    200  CH2 TRP    24      31.678  66.089   1.668  1.00 19.25          
ATOM    201  CZ2 TRP    24      30.950  64.940   1.920  1.00 18.47          
ATOM    202  C   TRP    24      36.423  61.521   5.338  1.00 20.55          
ATOM    203  O   TRP    24      36.487  61.019   6.463  1.00 21.75          
ATOM    204  N   HSD    25      37.463  62.079   4.725  1.00 21.41          
ATOM    205  CA  HSD    25      38.827  61.919   5.220  1.00 21.79          
ATOM    206  CB  HSD    25      39.499  60.706   4.534  1.00 22.01          
ATOM    207  CG  HSD    25      38.761  59.428   4.754  1.00 21.78          
ATOM    208  ND1 HSD    25      37.736  59.007   3.930  1.00 24.64          
ATOM    209  CE1 HSD    25      37.239  57.871   4.392  1.00 21.18          
ATOM    210  NE2 HSD    25      37.889  57.555   5.498  1.00 25.69          
ATOM    211  CD2 HSD    25      38.845  58.514   5.748  1.00 20.97          
ATOM    212  C   HSD    25      39.676  63.161   5.020  1.00 22.34          
ATOM    213  O   HSD    25      39.459  63.941   4.095  1.00 22.06          
ATOM    214  N   LYS    26      40.664  63.311   5.896  1.00 23.29          
ATOM    215  CA  LYS    26      41.555  64.457   5.874  1.00 24.67          
ATOM    216  CB  LYS    26      42.397  64.476   7.150  1.00 25.03          
ATOM    217  CG  LYS    26      41.663  65.064   8.381  1.00 28.30          
ATOM    218  CD  LYS    26      42.592  65.088   9.609  1.00 29.62          
ATOM    219  CE  LYS    26      43.657  66.171   9.468  1.00 36.11          
ATOM    220  NZ  LYS    26      44.532  66.251  10.678  1.00 40.57          
ATOM    221  C   LYS    26      42.453  64.428   4.645  1.00 24.07          
ATOM    222  O   LYS    26      42.939  63.354   4.215  1.00 23.59          
ATOM    223  N   GLY    27      42.638  65.613   4.056  1.00 23.33          
ATOM    224  CA  GLY    27      43.498  65.761   2.898  1.00 23.34          
ATOM    225  C   GLY    27      43.987  67.187   2.777  1.00 23.08          
ATOM    226  O   GLY    27      43.681  68.033   3.622  1.00 23.58          
ATOM    227  N   THR    28      44.784  67.424   1.753  1.00 23.74          
ATOM    228  CA  THR    28      45.278  68.769   1.425  1.00 23.93          
ATOM    229  CB  THR    28      46.817  68.797   1.343  1.00 25.06          
ATOM    230  OG1 THR    28      47.360  68.396   2.608  1.00 26.73          
ATOM    231  CG2 THR    28      47.309  70.201   0.998  1.00 26.50          
ATOM    232  C   THR    28      44.681  69.233   0.095  1.00 23.32          
ATOM    233  O   THR    28      44.627  68.470  -0.875  1.00 22.70          
ATOM    234  N   LEU    29      44.226  70.487   0.059  1.00 22.17          
ATOM    235  CA  LEU    29      43.738  71.082  -1.171  1.00 22.39          
ATOM    236  CB  LEU    29      42.831  72.290  -0.847  1.00 22.00          
ATOM    237  CG  LEU    29      42.264  73.053  -2.045  1.00 22.05          
ATOM    238  CD1 LEU    29      41.382  72.147  -2.911  1.00 21.84          
ATOM    239  CD2 LEU    29      41.495  74.283  -1.556  1.00 22.24          
ATOM    240  C   LEU    29      44.956  71.497  -2.000  1.00 22.77          
ATOM    241  O   LEU    29      45.683  72.428  -1.637  1.00 23.81          
ATOM    242  N   ILE    30      45.215  70.764  -3.084  1.00 22.86          
ATOM    243  CA  ILE    30      46.416  70.994  -3.875  1.00 23.29          
ATOM    244  CB  ILE    30      47.220  69.703  -4.140  1.00 23.12          
ATOM    245  CG1 ILE    30      46.374  68.690  -4.933  1.00 23.65          
ATOM    246  CD  ILE    30      47.190  67.505  -5.529  1.00 23.75          
ATOM    247  CG2 ILE    30      47.797  69.175  -2.812  1.00 24.13          
ATOM    248  C   ILE    30      46.195  71.774  -5.164  1.00 23.92          
ATOM    249  O   ILE    30      47.172  72.232  -5.789  1.00 22.81          
ATOM    250  N   ALA    31      44.928  71.915  -5.567  1.00 23.57          
ATOM    251  CA  ALA    31      44.595  72.703  -6.754  1.00 23.70          
ATOM    252  CB  ALA    31      44.999  71.970  -8.043  1.00 23.85          
ATOM    253  C   ALA    31      43.127  73.095  -6.823  1.00 23.21          
ATOM    254  O   ALA    31      42.265  72.433  -6.272  1.00 22.86          
ATOM    255  N   ILE    32      42.861  74.176  -7.534  1.00 22.51          
ATOM    256  CA  ILE    32      41.490  74.646  -7.737  1.00 23.06          
ATOM    257  CB  ILE    32      41.146  75.935  -6.912  1.00 22.62          
ATOM    258  CG1 ILE    32      41.351  75.716  -5.409  1.00 23.72          
ATOM    259  CD  ILE    32      41.312  76.990  -4.538  1.00 21.43          
ATOM    260  CG2 ILE    32      39.730  76.373  -7.241  1.00 21.89          
ATOM    261  C   ILE    32      41.399  74.948  -9.215  1.00 24.59          
ATOM    262  O   ILE    32      42.191  75.743  -9.745  1.00 24.54          
ATOM    263  N   GLN    33      40.464  74.291  -9.895  1.00 26.30          
ATOM    264  CA  GLN    33      40.349  74.425 -11.355  1.00 28.55          
ATOM    265  CB  GLN    33      40.614  73.075 -12.046  1.00 28.71          
ATOM    266  CG  GLN    33      41.941  72.434 -11.676  1.00 30.65          
ATOM    267  CD  GLN    33      42.074  70.929 -12.026  1.00 31.37          
ATOM    268  OE1 GLN    33      43.083  70.307 -11.665  1.00 36.45          
ATOM    269  NE2 GLN    33      41.083  70.355 -12.724  1.00 34.01          
ATOM    270  C   GLN    33      38.957  74.940 -11.727  1.00 29.54          
ATOM    271  O   GLN    33      37.949  74.556 -11.115  1.00 28.76          
ATOM    272  N   THR    34      38.901  75.819 -12.728  1.00 30.78          
ATOM    273  CA  THR    34      37.626  76.298 -13.247  1.00 32.41          
ATOM    274  CB  THR    34      37.497  77.831 -13.199  1.00 33.30          
ATOM    275  OG1 THR    34      38.456  78.425 -14.085  1.00 32.81          
ATOM    276  CG2 THR    34      37.676  78.368 -11.771  1.00 32.36          
ATOM    277  C   THR    34      37.458  75.872 -14.695  1.00 34.52          
ATOM    278  O   THR    34      38.414  75.910 -15.486  1.00 34.01          
ATOM    279  N   VAL    35      36.240  75.462 -15.035  1.00 36.56          
ATOM    280  CA  VAL    35      35.856  75.271 -16.444  1.00 38.84          
ATOM    281  CB  VAL    35      35.814  73.770 -16.906  1.00 39.18          
ATOM    282  CG1 VAL    35      37.216  73.285 -17.291  1.00 40.09          
ATOM    283  CG2 VAL    35      35.191  72.851 -15.853  1.00 40.61          
ATOM    284  C   VAL    35      34.544  76.012 -16.676  1.00 38.94          
ATOM    285  O   VAL    35      33.462  75.506 -16.374  1.00 39.63          
ATOM    286  N   GLY    36      34.669  77.244 -17.167  1.00 39.84          
ATOM    287  CA  GLY    36      33.541  78.168 -17.252  1.00 39.85          
ATOM    288  C   GLY    36      32.959  78.395 -15.869  1.00 39.67          
ATOM    289  O   GLY    36      33.680  78.802 -14.947  1.00 39.99          
ATOM    290  N   PRO    37      31.657  78.106 -15.700  1.00 39.19          
ATOM    291  CA  PRO    37      31.013  78.369 -14.423  1.00 38.16          
ATOM    292  CB  PRO    37      29.530  78.410 -14.793  1.00 38.59          
ATOM    293  CG  PRO    37      29.421  77.411 -15.918  1.00 38.83          
ATOM    294  CD  PRO    37      30.722  77.509 -16.681  1.00 39.32          
ATOM    295  C   PRO    37      31.275  77.279 -13.381  1.00 36.79          
ATOM    296  O   PRO    37      30.869  77.451 -12.242  1.00 37.51          
ATOM    297  N   GLY    38      31.939  76.187 -13.782  1.00 35.42          
ATOM    298  CA  GLY    38      32.217  75.032 -12.915  1.00 33.23          
ATOM    299  C   GLY    38      33.514  75.136 -12.124  1.00 31.59          
ATOM    300  O   GLY    38      34.493  75.712 -12.602  1.00 30.97          
ATOM    301  N   LYS    39      33.515  74.610 -10.898  1.00 29.52          
ATOM    302  CA  LYS    39      34.747  74.586 -10.093  1.00 27.99          
ATOM    303  CB  LYS    39      34.680  75.594  -8.942  1.00 28.28          
ATOM    304  CG  LYS    39      34.535  77.051  -9.427  1.00 29.73          
ATOM    305  CD  LYS    39      34.014  77.934  -8.305  1.00 34.93          
ATOM    306  CE  LYS    39      33.978  79.411  -8.708  1.00 35.28          
ATOM    307  NZ  LYS    39      33.025  79.704  -9.819  1.00 38.24          
ATOM    308  C   LYS    39      35.039  73.193  -9.567  1.00 26.68          
ATOM    309  O   LYS    39      34.124  72.450  -9.216  1.00 25.89          
ATOM    310  N   LYS    40      36.316  72.833  -9.555  1.00 24.54          
ATOM    311  CA  LYS    40      36.729  71.542  -9.022  1.00 24.74          
ATOM    312  CB  LYS    40      37.085  70.557 -10.131  1.00 25.45          
ATOM    313  CG  LYS    40      35.914  70.164 -11.051  1.00 28.21          
ATOM    314  CD  LYS    40      35.191  68.967 -10.465  1.00 33.42          
ATOM    315  CE  LYS    40      34.097  68.448 -11.395  1.00 36.38          
ATOM    316  NZ  LYS    40      33.119  67.667 -10.600  1.00 36.30          
ATOM    317  C   LYS    40      37.925  71.734  -8.134  1.00 23.98          
ATOM    318  O   LYS    40      38.716  72.662  -8.328  1.00 23.60          
ATOM    319  N   TYR    41      38.048  70.844  -7.156  1.00 22.67          
ATOM    320  CA  TYR    41      38.993  71.002  -6.068  1.00 22.61          
ATOM    321  CB  TYR    41      38.204  71.267  -4.750  1.00 21.74          
ATOM    322  CG  TYR    41      37.342  72.509  -4.872  1.00 21.37          
ATOM    323  CD1 TYR    41      37.847  73.766  -4.506  1.00 22.43          
ATOM    324  CE1 TYR    41      37.087  74.910  -4.660  1.00 21.08          
ATOM    325  CZ  TYR    41      35.806  74.824  -5.196  1.00 20.70          
ATOM    326  OH  TYR    41      35.038  75.955  -5.357  1.00 21.71          
ATOM    327  CE2 TYR    41      35.274  73.601  -5.568  1.00 21.29          
ATOM    328  CD2 TYR    41      36.049  72.441  -5.421  1.00 19.84          
ATOM    329  C   TYR    41      39.769  69.692  -6.013  1.00 22.85          
ATOM    330  O   TYR    41      39.195  68.653  -5.731  1.00 23.49          
ATOM    331  N   LYS    42      41.057  69.748  -6.324  1.00 23.94          
ATOM    332  CA  LYS    42      41.935  68.576  -6.233  1.00 24.02          
ATOM    333  CB  LYS    42      43.124  68.724  -7.180  1.00 24.22          
ATOM    334  CG  LYS    42      43.948  67.436  -7.282  1.00 24.67          
ATOM    335  CD  LYS    42      45.051  67.549  -8.351  1.00 26.84          
ATOM    336  CE  LYS    42      44.490  67.560  -9.756  1.00 32.36          
ATOM    337  NZ  LYS    42      45.637  67.411 -10.729  1.00 34.81          
ATOM    338  C   LYS    42      42.448  68.382  -4.814  1.00 23.53          
ATOM    339  O   LYS    42      43.058  69.281  -4.240  1.00 23.05          
ATOM    340  N   VAL    43      42.197  67.195  -4.256  1.00 23.35          
ATOM    341  CA  VAL    43      42.589  66.880  -2.898  1.00 23.92          
ATOM    342  CB  VAL    43      41.341  66.552  -2.034  1.00 23.50          
ATOM    343  CG1 VAL    43      41.744  66.093  -0.656  1.00 24.28          
ATOM    344  CG2 VAL    43      40.382  67.789  -1.952  1.00 24.88          
ATOM    345  C   VAL    43      43.536  65.686  -2.881  1.00 24.25          
ATOM    346  O   VAL    43      43.268  64.674  -3.538  1.00 24.86          
ATOM    347  N   LYS    44      44.634  65.821  -2.143  1.00 24.74          
ATOM    348  CA  LYS    44      45.539  64.695  -1.919  1.00 25.81          
ATOM    349  CB  LYS    44      47.004  65.120  -2.071  1.00 25.63          
ATOM    350  CG  LYS    44      47.999  63.946  -1.953  1.00 27.17          
ATOM    351  CD  LYS    44      49.430  64.409  -2.222  1.00 29.45          
ATOM    352  CE  LYS    44      50.393  63.219  -2.332  1.00 34.65          
ATOM    353  NZ  LYS    44      51.790  63.731  -2.613  1.00 39.07          
ATOM    354  C   LYS    44      45.236  64.228  -0.507  1.00 26.00          
ATOM    355  O   LYS    44      45.423  64.967   0.457  1.00 24.51          
ATOM    356  N   PHE    45      44.702  63.015  -0.391  1.00 26.53          
ATOM    357  CA  PHE    45      44.371  62.504   0.933  1.00 28.40          
ATOM    358  CB  PHE    45      43.390  61.339   0.818  1.00 27.65          
ATOM    359  CG  PHE    45      42.036  61.754   0.348  1.00 25.24          
ATOM    360  CD1 PHE    45      41.132  62.329   1.251  1.00 23.75          
ATOM    361  CE1 PHE    45      39.873  62.734   0.836  1.00 22.50          
ATOM    362  CZ  PHE    45      39.478  62.561  -0.498  1.00 23.86          
ATOM    363  CE2 PHE    45      40.383  61.973  -1.416  1.00 24.89          
ATOM    364  CD2 PHE    45      41.661  61.596  -0.984  1.00 24.72          
ATOM    365  C   PHE    45      45.632  62.115   1.695  1.00 30.99          
ATOM    366  O   PHE    45      46.678  61.819   1.089  1.00 31.81          
ATOM    367  N   ASP    46      45.532  62.131   3.017  1.00 33.71          
ATOM    368  CA  ASP    46      46.669  61.832   3.895  1.00 37.20          
ATOM    369  CB  ASP    46      46.298  62.094   5.345  1.00 37.20          
ATOM    370  CG  ASP    46      46.214  63.553   5.675  1.00 39.31          
ATOM    371  OD1 ASP    46      46.634  64.404   4.868  1.00 40.82          
ATOM    372  OD2 ASP    46      45.717  63.863   6.771  1.00 43.86          
ATOM    373  C   ASP    46      47.209  60.411   3.763  1.00 38.51          
ATOM    374  O   ASP    46      48.413  60.196   3.871  1.00 39.78          
ATOM    375  N   ASN    47      46.330  59.439   3.561  1.00 40.36          
ATOM    376  CA  ASN    47      46.764  58.052   3.388  1.00 42.07          
ATOM    377  C   ASN    47      46.263  57.434   2.087  1.00 42.82          
ATOM    378  O   ASN    47      46.251  56.208   1.935  1.00 44.15          
ATOM    379  N   LYS    48      45.876  58.298   1.131  1.00 20.00          
ATOM    380  CA  LYS    48      45.170  57.811  -0.047  1.00 20.00          
ATOM    381  C   LYS    48      45.751  58.410  -1.324  1.00 20.00          
ATOM    382  CB  LYS    48      43.678  58.133   0.052  1.00 20.00          
ATOM    383  O   LYS    48      46.865  58.865  -1.395  1.00 43.89          
ATOM    384  N   GLY    49      44.911  58.354  -2.373  1.00 41.66          
ATOM    385  CA  GLY    49      45.310  58.935  -3.630  1.00 40.00          
ATOM    386  C   GLY    49      44.986  60.407  -3.652  1.00 38.62          
ATOM    387  O   GLY    49      44.992  61.095  -2.615  1.00 38.03          
ATOM    388  N   LYS    50      44.766  60.879  -4.873  1.00 37.46          
ATOM    389  CA  LYS    50      44.240  62.190  -5.154  1.00 35.65          
ATOM    390  CB  LYS    50      45.140  62.915  -6.149  1.00 35.92          
ATOM    391  CG  LYS    50      46.390  63.521  -5.561  1.00 38.50          
ATOM    392  CD  LYS    50      47.540  63.453  -6.537  1.00 41.70          
ATOM    393  CE  LYS    50      47.219  64.100  -7.868  1.00 44.53          
ATOM    394  NZ  LYS    50      48.145  63.590  -8.944  1.00 46.89          
ATOM    395  C   LYS    50      42.869  61.983  -5.783  1.00 33.83          
ATOM    396  O   LYS    50      42.618  60.967  -6.428  1.00 33.32          
ATOM    397  N   SER    51      41.974  62.941  -5.597  1.00 31.37          
ATOM    398  CA  SER    51      40.780  62.967  -6.417  1.00 29.75          
ATOM    399  CB  SER    51      39.614  62.227  -5.760  1.00 30.54          
ATOM    400  OG  SER    51      39.211  62.908  -4.617  1.00 34.38          
ATOM    401  C   SER    51      40.416  64.397  -6.693  1.00 27.54          
ATOM    402  O   SER    51      40.784  65.309  -5.936  1.00 26.69          
ATOM    403  N   LEU    52      39.690  64.569  -7.787  1.00 24.75          
ATOM    404  CA  LEU    52      39.225  65.872  -8.206  1.00 24.31          
ATOM    405  CB  LEU    52      39.482  66.049  -9.708  1.00 24.47          
ATOM    406  CG  LEU    52      39.235  67.429 -10.303  1.00 26.39          
ATOM    407  CD1 LEU    52      40.264  68.430  -9.785  1.00 25.20          
ATOM    408  CD2 LEU    52      39.352  67.297 -11.800  1.00 29.52          
ATOM    409  C   LEU    52      37.747  65.945  -7.875  1.00 22.65          
ATOM    410  O   LEU    52      36.924  65.205  -8.432  1.00 22.95          
ATOM    411  N   LEU    53      37.417  66.822  -6.928  1.00 21.72          
ATOM    412  CA  LEU    53      36.113  66.822  -6.294  1.00 20.96          
ATOM    413  CB  LEU    53      36.310  66.658  -4.777  1.00 20.56          
ATOM    414  CG  LEU    53      36.971  65.364  -4.265  1.00 21.20          
ATOM    415  CD1 LEU    53      37.320  65.527  -2.774  1.00 23.98          
ATOM    416  CD2 LEU    53      36.053  64.194  -4.503  1.00 23.46          
ATOM    417  C   LEU    53      35.329  68.111  -6.554  1.00 21.06          
ATOM    418  O   LEU    53      35.923  69.186  -6.708  1.00 21.74          
ATOM    419  N   SER    54      34.005  68.001  -6.621  1.00 20.72          
ATOM    420  CA  SER    54      33.142  69.196  -6.639  1.00 21.06          
ATOM    421  CB  SER    54      31.722  68.829  -7.086  1.00 21.95          
ATOM    422  OG  SER    54      31.148  67.839  -6.238  1.00 24.54          
ATOM    423  C   SER    54      33.170  69.845  -5.245  1.00 20.42          
ATOM    424  O   SER    54      33.537  69.175  -4.252  1.00 19.57          
ATOM    425  N   GLY    55      32.826  71.138  -5.169  1.00 19.72          
ATOM    426  CA  GLY    55      32.936  71.871  -3.891  1.00 19.16          
ATOM    427  C   GLY    55      31.958  71.427  -2.809  1.00 18.50          
ATOM    428  O   GLY    55      32.148  71.758  -1.649  1.00 19.73          
ATOM    429  N   ASN    56      30.906  70.708  -3.195  1.00 18.83          
ATOM    430  CA  ASN    56      29.988  70.110  -2.218  1.00 18.79          
ATOM    431  CB  ASN    56      28.592  69.874  -2.819  1.00 19.23          
ATOM    432  CG  ASN    56      28.626  69.020  -4.098  1.00 19.56          
ATOM    433  OD1 ASN    56      29.467  69.246  -4.985  1.00 21.74          
ATOM    434  ND2 ASN    56      27.721  68.036  -4.197  1.00 21.32          
ATOM    435  C   ASN    56      30.555  68.789  -1.669  1.00 18.90          
ATOM    436  O   ASN    56      29.947  68.191  -0.791  1.00 18.34          
ATOM    437  N   HSD    57      31.698  68.348  -2.203  1.00 18.92          
ATOM    438  CA  HSD    57      32.361  67.115  -1.745  1.00 19.22          
ATOM    439  CB  HSD    57      32.520  66.145  -2.914  1.00 19.81          
ATOM    440  CG  HSD    57      31.219  65.568  -3.378  1.00 20.14          
ATOM    441  ND1 HSD    57      31.049  65.028  -4.633  1.00 22.60          
ATOM    442  CE1 HSD    57      29.809  64.583  -4.748  1.00 22.65          
ATOM    443  NE2 HSD    57      29.171  64.824  -3.616  1.00 21.53          
ATOM    444  CD2 HSD    57      30.028  65.448  -2.747  1.00 20.42          
ATOM    445  C   HSD    57      33.680  67.336  -0.975  1.00 19.11          
ATOM    446  O   HSD    57      34.538  66.434  -0.828  1.00 18.12          
ATOM    447  N   ILE    58      33.804  68.543  -0.437  1.00 18.70          
ATOM    448  CA  ILE    58      34.882  68.894   0.486  1.00 18.51          
ATOM    449  CB  ILE    58      35.994  69.767  -0.177  1.00 17.69          
ATOM    450  CG1 ILE    58      35.390  70.978  -0.927  1.00 18.12          
ATOM    451  CD  ILE    58      36.427  72.053  -1.279  1.00 20.43          
ATOM    452  CG2 ILE    58      36.864  68.880  -1.094  1.00 19.86          
ATOM    453  C   ILE    58      34.238  69.643   1.626  1.00 18.50          
ATOM    454  O   ILE    58      33.177  70.255   1.435  1.00 18.32          
ATOM    455  N   ALA    59      34.860  69.568   2.805  1.00 18.26          
ATOM    456  CA  ALA    59      34.336  70.209   4.015  1.00 18.14          
ATOM    457  CB  ALA    59      33.553  69.205   4.891  1.00 18.64          
ATOM    458  C   ALA    59      35.493  70.806   4.760  1.00 18.13          
ATOM    459  O   ALA    59      36.646  70.328   4.708  1.00 18.21          
ATOM    460  N   TYR    60      35.192  71.888   5.472  1.00 18.54          
ATOM    461  CA  TYR    60      36.445  72.629   6.383  1.00 20.93          
ATOM    462  CB  TYR    60      35.883  73.948   6.895  1.00 21.71          
ATOM    463  CG  TYR    60      35.442  74.920   5.805  1.00 22.24          
ATOM    464  CD1 TYR    60      36.371  75.645   5.083  1.00 23.29          
ATOM    465  CE1 TYR    60      35.963  76.560   4.093  1.00 24.49          
ATOM    466  CZ  TYR    60      34.610  76.758   3.866  1.00 24.43          
ATOM    467  OH  TYR    60      34.179  77.657   2.900  1.00 26.41          
ATOM    468  CE2 TYR    60      33.657  76.053   4.578  1.00 23.82          
ATOM    469  CD2 TYR    60      34.078  75.134   5.549  1.00 22.93          
ATOM    470  C   TYR    60      36.651  71.688   7.554  1.00 21.12          
ATOM    471  O   TYR    60      35.692  71.075   8.077  1.00 20.61          
ATOM    472  N   ASP    61      37.895  71.604   7.978  1.00 20.95          
ATOM    473  CA  ASP    61      38.254  70.744   9.070  1.00 22.35          
ATOM    474  CB  ASP    61      39.646  70.172   8.815  1.00 22.77          
ATOM    475  CG  ASP    61      40.072  69.189   9.875  1.00 27.11          
ATOM    476  OD1 ASP    61      39.186  68.574  10.497  1.00 29.02          
ATOM    477  OD2 ASP    61      41.303  69.061  10.086  1.00 32.95          
ATOM    478  C   ASP    61      38.188  71.558  10.358  1.00 23.08          
ATOM    479  O   ASP    61      39.154  71.599  11.124  1.00 24.03          
ATOM    480  N   TYR    62      37.060  72.246  10.569  1.00 22.41          
ATOM    481  CA  TYR    62      36.809  72.933  11.835  1.00 23.63          
ATOM    482  CB  TYR    62      37.274  74.409  11.802  1.00 24.27          
ATOM    483  CG  TYR    62      36.651  75.283  10.702  1.00 25.13          
ATOM    484  CD1 TYR    62      35.292  75.615  10.728  1.00 27.54          
ATOM    485  CE1 TYR    62      34.714  76.422   9.744  1.00 26.38          
ATOM    486  CZ  TYR    62      35.509  76.926   8.722  1.00 27.74          
ATOM    487  OH  TYR    62      34.924  77.735   7.747  1.00 28.51          
ATOM    488  CE2 TYR    62      36.865  76.626   8.677  1.00 26.91          
ATOM    489  CD2 TYR    62      37.434  75.811   9.668  1.00 26.32          
ATOM    490  C   TYR    62      35.339  72.818  12.192  1.00 23.84          
ATOM    491  O   TYR    62      34.516  72.471  11.346  1.00 22.97          
END
