
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   56 (  868),  selected   56 , name 2rmm_A
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 2rmm_A.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      T       1          0.851
LGA    Q     2_A      T       2          0.979
LGA    Y     3_A      Y       3          0.901
LGA    K     4_A      K       4          0.741
LGA    L     5_A      L       5          0.742
LGA    I     6_A      I       6          0.839
LGA    L     7_A      L       7          0.994
LGA    N     8_A      N       8          0.870
LGA    G     9_A      L       9          0.988
LGA    K    10_A      K      10          0.957
LGA    T    11_A      Q      11          3.580
LGA    L    12_A      A      12          2.229
LGA    K    13_A      K      13          1.014
LGA    G    14_A      E      14          1.733
LGA    E    15_A      E      15          1.651
LGA    T    16_A      A      16          2.539
LGA    T    17_A      I      17          1.899
LGA    T    18_A      K      18          0.990
LGA    E    19_A      E      19          0.387
LGA    A    20_A      A      20          1.224
LGA    V    21_A      V      21          1.960
LGA    D    22_A      D      22          0.951
LGA    A    23_A      A      23          1.507
LGA    A    24_A      G      24          2.047
LGA    T    25_A      T      25          1.235
LGA    A    26_A      A      26          0.346
LGA    E    27_A      E      27          0.867
LGA    K    28_A      K      28          0.749
LGA    V    29_A      Y      29          0.607
LGA    F    30_A      F      30          0.698
LGA    K    31_A      K      31          0.517
LGA    Q    32_A      L      32          0.540
LGA    Y    33_A      I      33          0.925
LGA    F    34_A      A      34          0.731
LGA    N    35_A      N      35          1.344
LGA    D    36_A      A      36          4.841
LGA    N    37_A      K      37          3.787
LGA    G    38_A      T      38          3.267
LGA    V    39_A      V      39          3.507
LGA    D    40_A      E      40          2.080
LGA    G    41_A      G      41          1.498
LGA    E    42_A      V      42          1.610
LGA    W    43_A      W      43          0.654
LGA    T    44_A      T      44          0.297
LGA    Y    45_A      Y      45          0.711
LGA    D    46_A      K      46          1.803
LGA    D    47_A      D      47          2.868
LGA    A    48_A      E      48          1.815
LGA    T    49_A      I      49          1.948
LGA    K    50_A      K      50          0.828
LGA    T    51_A      T      51          0.944
LGA    F    52_A      F      52          0.776
LGA    T    53_A      T      53          0.963
LGA    V    54_A      V      54          0.975
LGA    T    55_A      T      55          0.707
LGA    E    56_A      E      56          0.537

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   56   56    5.0     56    1.68    60.71     92.497     3.144

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.281455 * X  +   0.794836 * Y  +   0.537604 * Z  +   6.468825
  Y_new =   0.522766 * X  +  -0.342803 * Y  +   0.780514 * Z  +   5.130144
  Z_new =   0.804673 * X  +   0.500721 * Y  +  -0.319030 * Z  +  -1.268904 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.138079   -1.003513  [ DEG:   122.5029    -57.4971 ]
  Theta =  -0.935125   -2.206468  [ DEG:   -53.5787   -126.4213 ]
  Phi   =   2.064686   -1.076907  [ DEG:   118.2978    -61.7022 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rmm_A                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rmm_A.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   56   56   5.0   56   1.68   60.71  92.497
REMARK  ---------------------------------------------------------- 
MOLECULE 2rmm_A
HEADER    IMMUNE SYSTEM                           30-OCT-07   2RMM              
TITLE     SOLUTION STRUCTURE OF GB1 A34F MUTANT                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: IMMUNOGLOBULIN G-BINDING PROTEIN G;                        
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: IGG-BINDING PROTEIN G;                                      
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS SP. GROUP G;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: SPG;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_VECTOR: PET15B                                     
KEYWDS    GB1 MUTANT, CELL WALL, IGG-BINDING PROTEIN, PEPTIDOGLYCAN-            
KEYWDS   2 ANCHOR, SECRETED, IMMUNE SYSTEM                                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    J.JEE,I.BYEON,J.M.LOUIS,A.M.GRONENBORN                                
REVDAT   1   04-DEC-07 2RMM    0                                                
JRNL        AUTH   J.JEE,I.BYEON,J.M.LOUIS,A.M.GRONENBORN                       
JRNL        TITL   SOLUTION STRUCTURE OF GB1 A34F MUTANT                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2RMM A    3    56  UNP    P06654   SPG1_STRSG     229    282             
DBREF  2RMM B    3    56  UNP    P06654   SPG1_STRSG     229    282             
SEQRES   1 A   56  MET GLN TYR LYS LEU ILE LEU ASN GLY LYS THR LEU LYS          
SEQRES   2 A   56  GLY GLU THR THR THR GLU ALA VAL ASP ALA ALA THR ALA          
SEQRES   3 A   56  GLU LYS VAL PHE LYS GLN TYR PHE ASN ASP ASN GLY VAL          
SEQRES   4 A   56  ASP GLY GLU TRP THR TYR ASP ASP ALA THR LYS THR PHE          
SEQRES   5 A   56  THR VAL THR GLU                                              
SEQRES   1 B   56  MET GLN TYR LYS LEU ILE LEU ASN GLY LYS THR LEU LYS          
SEQRES   2 B   56  GLY GLU THR THR THR GLU ALA VAL ASP ALA ALA THR ALA          
SEQRES   3 B   56  GLU LYS VAL PHE LYS GLN TYR PHE ASN ASP ASN GLY VAL          
SEQRES   4 B   56  ASP GLY GLU TRP THR TYR ASP ASP ALA THR LYS THR PHE          
SEQRES   5 B   56  THR VAL THR GLU                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       6.039 -13.390   5.614  1.00  0.00           N  
ATOM      2  CA  MET A   1       5.617 -13.382   4.191  1.00  0.00           C  
ATOM      3  C   MET A   1       5.822 -11.993   3.594  1.00  0.00           C  
ATOM      4  O   MET A   1       5.567 -10.992   4.263  1.00  0.00           O  
ATOM      5  CB  MET A   1       4.161 -13.868   4.036  1.00  0.00           C  
ATOM      6  CG  MET A   1       3.715 -13.988   2.573  1.00  0.00           C  
ATOM      7  SD  MET A   1       4.790 -15.031   1.541  1.00  0.00           S  
ATOM      8  CE  MET A   1       4.026 -14.768  -0.081  1.00  0.00           C  
ATOM      9  H1  MET A   1       5.512 -12.705   6.141  1.00  0.00           H  
ATOM     10  H2  MET A   1       7.024 -13.162   5.673  1.00  0.00           H  
ATOM     11  H3  MET A   1       5.896 -14.300   6.020  1.00  0.00           H  
ATOM     12  HA  MET A   1       6.261 -14.076   3.651  1.00  0.00           H  
ATOM     13  HB2 MET A   1       4.069 -14.852   4.497  1.00  0.00           H  
ATOM     14  HB3 MET A   1       3.489 -13.186   4.556  1.00  0.00           H  
ATOM     15  HG2 MET A   1       2.706 -14.403   2.555  1.00  0.00           H  
ATOM     16  HG3 MET A   1       3.663 -12.990   2.136  1.00  0.00           H  
ATOM     17  HE1 MET A   1       4.578 -15.327  -0.838  1.00  0.00           H  
ATOM     18  HE2 MET A   1       2.993 -15.116  -0.062  1.00  0.00           H  
ATOM     19  HE3 MET A   1       4.050 -13.707  -0.331  1.00  0.00           H  
ATOM     20  N   GLN A   2       6.282 -11.920   2.342  1.00  0.00           N  
ATOM     21  CA  GLN A   2       6.393 -10.662   1.581  1.00  0.00           C  
ATOM     22  C   GLN A   2       5.004 -10.151   1.142  1.00  0.00           C  
ATOM     23  O   GLN A   2       4.185 -10.922   0.635  1.00  0.00           O  
ATOM     24  CB  GLN A   2       7.282 -10.879   0.340  1.00  0.00           C  
ATOM     25  CG  GLN A   2       7.848  -9.570  -0.236  1.00  0.00           C  
ATOM     26  CD  GLN A   2       9.187  -9.217   0.375  1.00  0.00           C  
ATOM     27  OE1 GLN A   2      10.237  -9.630  -0.100  1.00  0.00           O  
ATOM     28  NE2 GLN A   2       9.194  -8.444   1.437  1.00  0.00           N  
ATOM     29  H   GLN A   2       6.411 -12.786   1.835  1.00  0.00           H  
ATOM     30  HA  GLN A   2       6.867  -9.919   2.223  1.00  0.00           H  
ATOM     31  HB2 GLN A   2       8.115 -11.535   0.597  1.00  0.00           H  
ATOM     32  HB3 GLN A   2       6.696 -11.381  -0.431  1.00  0.00           H  
ATOM     33  HG2 GLN A   2       8.009  -9.678  -1.308  1.00  0.00           H  
ATOM     34  HG3 GLN A   2       7.147  -8.752  -0.096  1.00  0.00           H  
ATOM     35 HE21 GLN A   2       8.318  -8.132   1.834  1.00  0.00           H  
ATOM     36 HE22 GLN A   2      10.080  -8.213   1.857  1.00  0.00           H  
ATOM     37  N   TYR A   3       4.747  -8.856   1.318  1.00  0.00           N  
ATOM     38  CA  TYR A   3       3.582  -8.124   0.793  1.00  0.00           C  
ATOM     39  C   TYR A   3       4.013  -6.903  -0.042  1.00  0.00           C  
ATOM     40  O   TYR A   3       5.125  -6.394   0.137  1.00  0.00           O  
ATOM     41  CB  TYR A   3       2.678  -7.711   1.961  1.00  0.00           C  
ATOM     42  CG  TYR A   3       2.081  -8.881   2.725  1.00  0.00           C  
ATOM     43  CD1 TYR A   3       2.771  -9.445   3.815  1.00  0.00           C  
ATOM     44  CD2 TYR A   3       0.842  -9.421   2.330  1.00  0.00           C  
ATOM     45  CE1 TYR A   3       2.240 -10.562   4.486  1.00  0.00           C  
ATOM     46  CE2 TYR A   3       0.322 -10.548   2.994  1.00  0.00           C  
ATOM     47  CZ  TYR A   3       1.030 -11.126   4.059  1.00  0.00           C  
ATOM     48  OH  TYR A   3       0.547 -12.242   4.674  1.00  0.00           O  
ATOM     49  H   TYR A   3       5.505  -8.278   1.634  1.00  0.00           H  
ATOM     50  HA  TYR A   3       3.007  -8.778   0.140  1.00  0.00           H  
ATOM     51  HB2 TYR A   3       3.263  -7.095   2.645  1.00  0.00           H  
ATOM     52  HB3 TYR A   3       1.862  -7.099   1.576  1.00  0.00           H  
ATOM     53  HD1 TYR A   3       3.720  -9.030   4.127  1.00  0.00           H  
ATOM     54  HD2 TYR A   3       0.302  -8.984   1.501  1.00  0.00           H  
ATOM     55  HE1 TYR A   3       2.775 -10.997   5.318  1.00  0.00           H  
ATOM     56  HE2 TYR A   3      -0.621 -10.971   2.685  1.00  0.00           H  
ATOM     57  HH  TYR A   3      -0.220 -12.608   4.221  1.00  0.00           H  
ATOM     58  N   LYS A   4       3.134  -6.388  -0.905  1.00  0.00           N  
ATOM     59  CA  LYS A   4       3.424  -5.287  -1.841  1.00  0.00           C  
ATOM     60  C   LYS A   4       2.310  -4.213  -1.878  1.00  0.00           C  
ATOM     61  O   LYS A   4       1.138  -4.516  -1.663  1.00  0.00           O  
ATOM     62  CB  LYS A   4       3.657  -5.918  -3.228  1.00  0.00           C  
ATOM     63  CG  LYS A   4       4.113  -4.913  -4.297  1.00  0.00           C  
ATOM     64  CD  LYS A   4       4.321  -5.569  -5.665  1.00  0.00           C  
ATOM     65  CE  LYS A   4       4.726  -4.466  -6.648  1.00  0.00           C  
ATOM     66  NZ  LYS A   4       4.855  -4.953  -8.032  1.00  0.00           N  
ATOM     67  H   LYS A   4       2.246  -6.867  -1.010  1.00  0.00           H  
ATOM     68  HA  LYS A   4       4.344  -4.790  -1.539  1.00  0.00           H  
ATOM     69  HB2 LYS A   4       4.422  -6.691  -3.137  1.00  0.00           H  
ATOM     70  HB3 LYS A   4       2.733  -6.392  -3.557  1.00  0.00           H  
ATOM     71  HG2 LYS A   4       3.361  -4.135  -4.416  1.00  0.00           H  
ATOM     72  HG3 LYS A   4       5.051  -4.459  -3.979  1.00  0.00           H  
ATOM     73  HD2 LYS A   4       5.105  -6.324  -5.605  1.00  0.00           H  
ATOM     74  HD3 LYS A   4       3.388  -6.033  -5.993  1.00  0.00           H  
ATOM     75  HE2 LYS A   4       3.969  -3.680  -6.620  1.00  0.00           H  
ATOM     76  HE3 LYS A   4       5.676  -4.037  -6.323  1.00  0.00           H  
ATOM     77  HZ1 LYS A   4       5.039  -4.155  -8.634  1.00  0.00           H  
ATOM     78  HZ2 LYS A   4       4.000  -5.392  -8.339  1.00  0.00           H  
ATOM     79  HZ3 LYS A   4       5.617  -5.609  -8.116  1.00  0.00           H  
ATOM     80  N   LEU A   5       2.670  -2.970  -2.213  1.00  0.00           N  
ATOM     81  CA  LEU A   5       1.803  -1.788  -2.318  1.00  0.00           C  
ATOM     82  C   LEU A   5       2.051  -1.066  -3.656  1.00  0.00           C  
ATOM     83  O   LEU A   5       3.194  -0.758  -4.001  1.00  0.00           O  
ATOM     84  CB  LEU A   5       2.142  -0.873  -1.123  1.00  0.00           C  
ATOM     85  CG  LEU A   5       1.200   0.279  -0.724  1.00  0.00           C  
ATOM     86  CD1 LEU A   5       1.134   1.423  -1.731  1.00  0.00           C  
ATOM     87  CD2 LEU A   5      -0.217  -0.205  -0.434  1.00  0.00           C  
ATOM     88  H   LEU A   5       3.661  -2.806  -2.362  1.00  0.00           H  
ATOM     89  HA  LEU A   5       0.761  -2.094  -2.254  1.00  0.00           H  
ATOM     90  HB2 LEU A   5       2.223  -1.509  -0.249  1.00  0.00           H  
ATOM     91  HB3 LEU A   5       3.125  -0.440  -1.302  1.00  0.00           H  
ATOM     92  HG  LEU A   5       1.596   0.700   0.200  1.00  0.00           H  
ATOM     93 HD11 LEU A   5       0.657   2.284  -1.263  1.00  0.00           H  
ATOM     94 HD12 LEU A   5       0.546   1.134  -2.595  1.00  0.00           H  
ATOM     95 HD13 LEU A   5       2.140   1.706  -2.040  1.00  0.00           H  
ATOM     96 HD21 LEU A   5      -0.181  -1.021   0.285  1.00  0.00           H  
ATOM     97 HD22 LEU A   5      -0.697  -0.544  -1.351  1.00  0.00           H  
ATOM     98 HD23 LEU A   5      -0.796   0.610  -0.003  1.00  0.00           H  
ATOM     99  N   ILE A   6       0.986  -0.769  -4.399  1.00  0.00           N  
ATOM    100  CA  ILE A   6       1.005   0.021  -5.640  1.00  0.00           C  
ATOM    101  C   ILE A   6       0.318   1.366  -5.374  1.00  0.00           C  
ATOM    102  O   ILE A   6      -0.804   1.403  -4.861  1.00  0.00           O  
ATOM    103  CB  ILE A   6       0.308  -0.744  -6.789  1.00  0.00           C  
ATOM    104  CG1 ILE A   6       0.941  -2.142  -6.982  1.00  0.00           C  
ATOM    105  CG2 ILE A   6       0.367   0.089  -8.089  1.00  0.00           C  
ATOM    106  CD1 ILE A   6       0.223  -3.017  -8.014  1.00  0.00           C  
ATOM    107  H   ILE A   6       0.091  -1.135  -4.091  1.00  0.00           H  
ATOM    108  HA  ILE A   6       2.037   0.216  -5.938  1.00  0.00           H  
ATOM    109  HB  ILE A   6      -0.738  -0.885  -6.521  1.00  0.00           H  
ATOM    110 HG12 ILE A   6       1.989  -2.035  -7.267  1.00  0.00           H  
ATOM    111 HG13 ILE A   6       0.897  -2.681  -6.037  1.00  0.00           H  
ATOM    112 HG21 ILE A   6      -0.106   1.063  -7.958  1.00  0.00           H  
ATOM    113 HG22 ILE A   6       1.404   0.238  -8.394  1.00  0.00           H  
ATOM    114 HG23 ILE A   6      -0.171  -0.415  -8.891  1.00  0.00           H  
ATOM    115 HD11 ILE A   6       0.670  -4.011  -8.014  1.00  0.00           H  
ATOM    116 HD12 ILE A   6      -0.832  -3.101  -7.751  1.00  0.00           H  
ATOM    117 HD13 ILE A   6       0.324  -2.597  -9.014  1.00  0.00           H  
ATOM    118  N   LEU A   7       0.987   2.464  -5.717  1.00  0.00           N  
ATOM    119  CA  LEU A   7       0.570   3.829  -5.420  1.00  0.00           C  
ATOM    120  C   LEU A   7       0.223   4.595  -6.713  1.00  0.00           C  
ATOM    121  O   LEU A   7       1.056   4.790  -7.604  1.00  0.00           O  
ATOM    122  CB  LEU A   7       1.670   4.483  -4.567  1.00  0.00           C  
ATOM    123  CG  LEU A   7       1.335   5.880  -4.023  1.00  0.00           C  
ATOM    124  CD1 LEU A   7       0.106   5.895  -3.113  1.00  0.00           C  
ATOM    125  CD2 LEU A   7       2.519   6.372  -3.200  1.00  0.00           C  
ATOM    126  H   LEU A   7       1.889   2.357  -6.168  1.00  0.00           H  
ATOM    127  HA  LEU A   7      -0.329   3.782  -4.805  1.00  0.00           H  
ATOM    128  HB2 LEU A   7       1.881   3.828  -3.720  1.00  0.00           H  
ATOM    129  HB3 LEU A   7       2.578   4.554  -5.165  1.00  0.00           H  
ATOM    130  HG  LEU A   7       1.173   6.566  -4.852  1.00  0.00           H  
ATOM    131 HD11 LEU A   7      -0.006   6.886  -2.675  1.00  0.00           H  
ATOM    132 HD12 LEU A   7       0.224   5.164  -2.313  1.00  0.00           H  
ATOM    133 HD13 LEU A   7      -0.792   5.670  -3.684  1.00  0.00           H  
ATOM    134 HD21 LEU A   7       3.413   6.381  -3.820  1.00  0.00           H  
ATOM    135 HD22 LEU A   7       2.684   5.711  -2.350  1.00  0.00           H  
ATOM    136 HD23 LEU A   7       2.322   7.380  -2.841  1.00  0.00           H  
ATOM    137  N   ASN A   8      -1.037   5.019  -6.766  1.00  0.00           N  
ATOM    138  CA  ASN A   8      -1.633   5.792  -7.848  1.00  0.00           C  
ATOM    139  C   ASN A   8      -2.152   7.143  -7.328  1.00  0.00           C  
ATOM    140  O   ASN A   8      -3.076   7.215  -6.513  1.00  0.00           O  
ATOM    141  CB  ASN A   8      -2.709   4.980  -8.582  1.00  0.00           C  
ATOM    142  CG  ASN A   8      -2.355   3.529  -8.855  1.00  0.00           C  
ATOM    143  OD1 ASN A   8      -1.903   3.156  -9.932  1.00  0.00           O  
ATOM    144  ND2 ASN A   8      -2.600   2.682  -7.883  1.00  0.00           N  
ATOM    145  H   ASN A   8      -1.423   4.994  -5.822  1.00  0.00           H  
ATOM    146  HA  ASN A   8      -0.854   5.998  -8.585  1.00  0.00           H  
ATOM    147  HB2 ASN A   8      -3.630   4.994  -8.011  1.00  0.00           H  
ATOM    148  HB3 ASN A   8      -2.900   5.460  -9.531  1.00  0.00           H  
ATOM    149 HD21 ASN A   8      -2.916   3.076  -7.002  1.00  0.00           H  
ATOM    150 HD22 ASN A   8      -2.525   1.693  -8.035  1.00  0.00           H  
ATOM    151  N   GLY A   9      -1.540   8.218  -7.812  1.00  0.00           N  
ATOM    152  CA  GLY A   9      -1.858   9.597  -7.437  1.00  0.00           C  
ATOM    153  C   GLY A   9      -1.491  10.645  -8.488  1.00  0.00           C  
ATOM    154  O   GLY A   9      -0.950  10.327  -9.551  1.00  0.00           O  
ATOM    155  H   GLY A   9      -0.753   8.058  -8.421  1.00  0.00           H  
ATOM    156  HA2 GLY A   9      -2.926   9.682  -7.251  1.00  0.00           H  
ATOM    157  HA3 GLY A   9      -1.340   9.845  -6.510  1.00  0.00           H  
ATOM    158  N   LYS A  10      -1.819  11.901  -8.199  1.00  0.00           N  
ATOM    159  CA  LYS A  10      -1.633  13.054  -9.092  1.00  0.00           C  
ATOM    160  C   LYS A  10      -0.372  13.863  -8.718  1.00  0.00           C  
ATOM    161  O   LYS A  10       0.386  14.294  -9.590  1.00  0.00           O  
ATOM    162  CB  LYS A  10      -2.886  13.950  -9.032  1.00  0.00           C  
ATOM    163  CG  LYS A  10      -4.229  13.244  -9.310  1.00  0.00           C  
ATOM    164  CD  LYS A  10      -4.293  12.565 -10.691  1.00  0.00           C  
ATOM    165  CE  LYS A  10      -5.709  12.090 -11.056  1.00  0.00           C  
ATOM    166  NZ  LYS A  10      -6.198  10.998 -10.186  1.00  0.00           N  
ATOM    167  H   LYS A  10      -2.262  12.058  -7.294  1.00  0.00           H  
ATOM    168  HA  LYS A  10      -1.512  12.706 -10.119  1.00  0.00           H  
ATOM    169  HB2 LYS A  10      -2.947  14.400  -8.039  1.00  0.00           H  
ATOM    170  HB3 LYS A  10      -2.764  14.760  -9.753  1.00  0.00           H  
ATOM    171  HG2 LYS A  10      -4.418  12.504  -8.530  1.00  0.00           H  
ATOM    172  HG3 LYS A  10      -5.017  13.996  -9.254  1.00  0.00           H  
ATOM    173  HD2 LYS A  10      -3.978  13.285 -11.448  1.00  0.00           H  
ATOM    174  HD3 LYS A  10      -3.609  11.715 -10.722  1.00  0.00           H  
ATOM    175  HE2 LYS A  10      -6.393  12.938 -10.993  1.00  0.00           H  
ATOM    176  HE3 LYS A  10      -5.699  11.739 -12.088  1.00  0.00           H  
ATOM    177  HZ1 LYS A  10      -7.115  10.699 -10.485  1.00  0.00           H  
ATOM    178  HZ2 LYS A  10      -6.273  11.304  -9.228  1.00  0.00           H  
ATOM    179  HZ3 LYS A  10      -5.583  10.200 -10.230  1.00  0.00           H  
ATOM    180  N   THR A  11      -0.107  14.009  -7.417  1.00  0.00           N  
ATOM    181  CA  THR A  11       1.121  14.612  -6.856  1.00  0.00           C  
ATOM    182  C   THR A  11       2.324  13.650  -6.903  1.00  0.00           C  
ATOM    183  O   THR A  11       3.473  14.070  -7.057  1.00  0.00           O  
ATOM    184  CB  THR A  11       0.868  14.980  -5.376  1.00  0.00           C  
ATOM    185  OG1 THR A  11      -0.239  15.850  -5.264  1.00  0.00           O  
ATOM    186  CG2 THR A  11       2.045  15.655  -4.671  1.00  0.00           C  
ATOM    187  H   THR A  11      -0.807  13.687  -6.762  1.00  0.00           H  
ATOM    188  HA  THR A  11       1.369  15.517  -7.410  1.00  0.00           H  
ATOM    189  HB  THR A  11       0.619  14.073  -4.828  1.00  0.00           H  
ATOM    190  HG1 THR A  11      -0.442  15.920  -4.323  1.00  0.00           H  
ATOM    191 HG21 THR A  11       2.865  14.947  -4.563  1.00  0.00           H  
ATOM    192 HG22 THR A  11       1.743  15.976  -3.673  1.00  0.00           H  
ATOM    193 HG23 THR A  11       2.381  16.519  -5.246  1.00  0.00           H  
ATOM    194  N   LEU A  12       2.060  12.349  -6.744  1.00  0.00           N  
ATOM    195  CA  LEU A  12       3.066  11.284  -6.684  1.00  0.00           C  
ATOM    196  C   LEU A  12       2.504   9.933  -7.185  1.00  0.00           C  
ATOM    197  O   LEU A  12       1.310   9.662  -7.050  1.00  0.00           O  
ATOM    198  CB  LEU A  12       3.606  11.260  -5.237  1.00  0.00           C  
ATOM    199  CG  LEU A  12       4.770  10.286  -4.970  1.00  0.00           C  
ATOM    200  CD1 LEU A  12       5.763  10.892  -3.979  1.00  0.00           C  
ATOM    201  CD2 LEU A  12       4.259   8.983  -4.370  1.00  0.00           C  
ATOM    202  H   LEU A  12       1.078  12.100  -6.908  1.00  0.00           H  
ATOM    203  HA  LEU A  12       3.889  11.558  -7.344  1.00  0.00           H  
ATOM    204  HB2 LEU A  12       3.956  12.268  -5.011  1.00  0.00           H  
ATOM    205  HB3 LEU A  12       2.785  11.049  -4.549  1.00  0.00           H  
ATOM    206  HG  LEU A  12       5.301  10.068  -5.892  1.00  0.00           H  
ATOM    207 HD11 LEU A  12       5.250  11.170  -3.059  1.00  0.00           H  
ATOM    208 HD12 LEU A  12       6.217  11.778  -4.421  1.00  0.00           H  
ATOM    209 HD13 LEU A  12       6.547  10.173  -3.752  1.00  0.00           H  
ATOM    210 HD21 LEU A  12       3.775   9.184  -3.417  1.00  0.00           H  
ATOM    211 HD22 LEU A  12       5.086   8.298  -4.201  1.00  0.00           H  
ATOM    212 HD23 LEU A  12       3.545   8.513  -5.041  1.00  0.00           H  
ATOM    213  N   LYS A  13       3.367   9.072  -7.723  1.00  0.00           N  
ATOM    214  CA  LYS A  13       3.078   7.679  -8.118  1.00  0.00           C  
ATOM    215  C   LYS A  13       4.230   6.757  -7.663  1.00  0.00           C  
ATOM    216  O   LYS A  13       5.349   7.239  -7.491  1.00  0.00           O  
ATOM    217  CB  LYS A  13       2.937   7.588  -9.650  1.00  0.00           C  
ATOM    218  CG  LYS A  13       1.882   8.522 -10.267  1.00  0.00           C  
ATOM    219  CD  LYS A  13       1.817   8.317 -11.790  1.00  0.00           C  
ATOM    220  CE  LYS A  13       0.985   9.383 -12.518  1.00  0.00           C  
ATOM    221  NZ  LYS A  13      -0.451   9.327 -12.177  1.00  0.00           N  
ATOM    222  H   LYS A  13       4.331   9.384  -7.823  1.00  0.00           H  
ATOM    223  HA  LYS A  13       2.153   7.341  -7.651  1.00  0.00           H  
ATOM    224  HB2 LYS A  13       3.905   7.817 -10.099  1.00  0.00           H  
ATOM    225  HB3 LYS A  13       2.681   6.559  -9.908  1.00  0.00           H  
ATOM    226  HG2 LYS A  13       0.909   8.308  -9.822  1.00  0.00           H  
ATOM    227  HG3 LYS A  13       2.148   9.560 -10.062  1.00  0.00           H  
ATOM    228  HD2 LYS A  13       2.829   8.367 -12.192  1.00  0.00           H  
ATOM    229  HD3 LYS A  13       1.417   7.326 -12.011  1.00  0.00           H  
ATOM    230  HE2 LYS A  13       1.380  10.370 -12.274  1.00  0.00           H  
ATOM    231  HE3 LYS A  13       1.097   9.227 -13.593  1.00  0.00           H  
ATOM    232  HZ1 LYS A  13      -0.592   9.573 -11.205  1.00  0.00           H  
ATOM    233  HZ2 LYS A  13      -0.822   8.404 -12.348  1.00  0.00           H  
ATOM    234  HZ3 LYS A  13      -0.963   9.989 -12.743  1.00  0.00           H  
ATOM    235  N   GLY A  14       4.014   5.450  -7.488  1.00  0.00           N  
ATOM    236  CA  GLY A  14       5.098   4.533  -7.080  1.00  0.00           C  
ATOM    237  C   GLY A  14       4.703   3.086  -6.759  1.00  0.00           C  
ATOM    238  O   GLY A  14       3.553   2.681  -6.929  1.00  0.00           O  
ATOM    239  H   GLY A  14       3.080   5.074  -7.633  1.00  0.00           H  
ATOM    240  HA2 GLY A  14       5.849   4.501  -7.871  1.00  0.00           H  
ATOM    241  HA3 GLY A  14       5.579   4.940  -6.192  1.00  0.00           H  
ATOM    242  N   GLU A  15       5.678   2.311  -6.271  1.00  0.00           N  
ATOM    243  CA  GLU A  15       5.542   0.910  -5.805  1.00  0.00           C  
ATOM    244  C   GLU A  15       6.478   0.617  -4.629  1.00  0.00           C  
ATOM    245  O   GLU A  15       7.651   0.996  -4.657  1.00  0.00           O  
ATOM    246  CB  GLU A  15       5.883  -0.094  -6.921  1.00  0.00           C  
ATOM    247  CG  GLU A  15       4.876  -0.107  -8.070  1.00  0.00           C  
ATOM    248  CD  GLU A  15       5.318  -1.100  -9.134  1.00  0.00           C  
ATOM    249  OE1 GLU A  15       5.022  -2.306  -8.982  1.00  0.00           O  
ATOM    250  OE2 GLU A  15       5.955  -0.671 -10.121  1.00  0.00           O  
ATOM    251  H   GLU A  15       6.599   2.737  -6.189  1.00  0.00           H  
ATOM    252  HA  GLU A  15       4.517   0.734  -5.483  1.00  0.00           H  
ATOM    253  HB2 GLU A  15       6.875   0.136  -7.314  1.00  0.00           H  
ATOM    254  HB3 GLU A  15       5.912  -1.092  -6.484  1.00  0.00           H  
ATOM    255  HG2 GLU A  15       3.895  -0.386  -7.690  1.00  0.00           H  
ATOM    256  HG3 GLU A  15       4.812   0.883  -8.518  1.00  0.00           H  
ATOM    257  N   THR A  16       5.969  -0.078  -3.614  1.00  0.00           N  
ATOM    258  CA  THR A  16       6.728  -0.453  -2.401  1.00  0.00           C  
ATOM    259  C   THR A  16       6.445  -1.884  -1.914  1.00  0.00           C  
ATOM    260  O   THR A  16       5.466  -2.521  -2.307  1.00  0.00           O  
ATOM    261  CB  THR A  16       6.525   0.540  -1.231  1.00  0.00           C  
ATOM    262  OG1 THR A  16       5.328   0.305  -0.539  1.00  0.00           O  
ATOM    263  CG2 THR A  16       6.495   2.018  -1.625  1.00  0.00           C  
ATOM    264  H   THR A  16       4.956  -0.265  -3.678  1.00  0.00           H  
ATOM    265  HA  THR A  16       7.785  -0.422  -2.658  1.00  0.00           H  
ATOM    266  HB  THR A  16       7.336   0.400  -0.519  1.00  0.00           H  
ATOM    267  HG1 THR A  16       5.281   0.957   0.167  1.00  0.00           H  
ATOM    268 HG21 THR A  16       5.577   2.234  -2.175  1.00  0.00           H  
ATOM    269 HG22 THR A  16       7.361   2.260  -2.238  1.00  0.00           H  
ATOM    270 HG23 THR A  16       6.525   2.633  -0.728  1.00  0.00           H  
ATOM    271  N   THR A  17       7.334  -2.429  -1.083  1.00  0.00           N  
ATOM    272  CA  THR A  17       7.326  -3.835  -0.635  1.00  0.00           C  
ATOM    273  C   THR A  17       7.847  -3.966   0.804  1.00  0.00           C  
ATOM    274  O   THR A  17       8.798  -3.277   1.193  1.00  0.00           O  
ATOM    275  CB  THR A  17       8.198  -4.720  -1.563  1.00  0.00           C  
ATOM    276  OG1 THR A  17       8.154  -4.309  -2.916  1.00  0.00           O  
ATOM    277  CG2 THR A  17       7.782  -6.186  -1.557  1.00  0.00           C  
ATOM    278  H   THR A  17       8.169  -1.910  -0.975  1.00  0.00           H  
ATOM    279  HA  THR A  17       6.301  -4.202  -0.661  1.00  0.00           H  
ATOM    280  HB  THR A  17       9.237  -4.671  -1.241  1.00  0.00           H  
ATOM    281  HG1 THR A  17       7.225  -4.289  -3.172  1.00  0.00           H  
ATOM    282 HG21 THR A  17       6.767  -6.290  -1.941  1.00  0.00           H  
ATOM    283 HG22 THR A  17       7.832  -6.573  -0.540  1.00  0.00           H  
ATOM    284 HG23 THR A  17       8.464  -6.763  -2.183  1.00  0.00           H  
ATOM    285  N   THR A  18       7.244  -4.851   1.606  1.00  0.00           N  
ATOM    286  CA  THR A  18       7.561  -5.094   3.029  1.00  0.00           C  
ATOM    287  C   THR A  18       7.363  -6.582   3.383  1.00  0.00           C  
ATOM    288  O   THR A  18       6.753  -7.330   2.618  1.00  0.00           O  
ATOM    289  CB  THR A  18       6.644  -4.242   3.945  1.00  0.00           C  
ATOM    290  OG1 THR A  18       7.134  -4.197   5.265  1.00  0.00           O  
ATOM    291  CG2 THR A  18       5.197  -4.744   4.033  1.00  0.00           C  
ATOM    292  H   THR A  18       6.488  -5.405   1.312  1.00  0.00           H  
ATOM    293  HA  THR A  18       8.600  -4.822   3.219  1.00  0.00           H  
ATOM    294  HB  THR A  18       6.627  -3.222   3.571  1.00  0.00           H  
ATOM    295  HG1 THR A  18       7.733  -3.432   5.345  1.00  0.00           H  
ATOM    296 HG21 THR A  18       4.563  -3.958   4.443  1.00  0.00           H  
ATOM    297 HG22 THR A  18       5.132  -5.623   4.678  1.00  0.00           H  
ATOM    298 HG23 THR A  18       4.834  -5.013   3.044  1.00  0.00           H  
ATOM    299  N   GLU A  19       7.870  -7.026   4.535  1.00  0.00           N  
ATOM    300  CA  GLU A  19       7.599  -8.353   5.133  1.00  0.00           C  
ATOM    301  C   GLU A  19       6.974  -8.208   6.518  1.00  0.00           C  
ATOM    302  O   GLU A  19       7.504  -7.509   7.384  1.00  0.00           O  
ATOM    303  CB  GLU A  19       8.847  -9.250   5.145  1.00  0.00           C  
ATOM    304  CG  GLU A  19       8.629 -10.543   5.942  1.00  0.00           C  
ATOM    305  CD  GLU A  19       9.443 -11.701   5.391  1.00  0.00           C  
ATOM    306  OE1 GLU A  19      10.688 -11.598   5.335  1.00  0.00           O  
ATOM    307  OE2 GLU A  19       8.813 -12.729   5.050  1.00  0.00           O  
ATOM    308  H   GLU A  19       8.501  -6.391   4.950  1.00  0.00           H  
ATOM    309  HA  GLU A  19       6.863  -8.863   4.511  1.00  0.00           H  
ATOM    310  HB2 GLU A  19       9.080  -9.501   4.110  1.00  0.00           H  
ATOM    311  HB3 GLU A  19       9.689  -8.705   5.571  1.00  0.00           H  
ATOM    312  HG2 GLU A  19       8.896 -10.375   6.984  1.00  0.00           H  
ATOM    313  HG3 GLU A  19       7.579 -10.823   5.905  1.00  0.00           H  
ATOM    314  N   ALA A  20       5.827  -8.860   6.704  1.00  0.00           N  
ATOM    315  CA  ALA A  20       5.003  -8.818   7.899  1.00  0.00           C  
ATOM    316  C   ALA A  20       4.511 -10.223   8.288  1.00  0.00           C  
ATOM    317  O   ALA A  20       4.603 -11.180   7.509  1.00  0.00           O  
ATOM    318  CB  ALA A  20       3.828  -7.885   7.615  1.00  0.00           C  
ATOM    319  H   ALA A  20       5.502  -9.504   5.998  1.00  0.00           H  
ATOM    320  HA  ALA A  20       5.578  -8.411   8.731  1.00  0.00           H  
ATOM    321  HB1 ALA A  20       3.155  -8.355   6.897  1.00  0.00           H  
ATOM    322  HB2 ALA A  20       3.291  -7.700   8.536  1.00  0.00           H  
ATOM    323  HB3 ALA A  20       4.184  -6.932   7.221  1.00  0.00           H  
ATOM    324  N   VAL A  21       3.961 -10.331   9.499  1.00  0.00           N  
ATOM    325  CA  VAL A  21       3.396 -11.606   9.992  1.00  0.00           C  
ATOM    326  C   VAL A  21       2.160 -12.020   9.177  1.00  0.00           C  
ATOM    327  O   VAL A  21       2.031 -13.193   8.817  1.00  0.00           O  
ATOM    328  CB  VAL A  21       3.125 -11.574  11.506  1.00  0.00           C  
ATOM    329  CG1 VAL A  21       2.194 -10.429  11.890  1.00  0.00           C  
ATOM    330  CG2 VAL A  21       2.562 -12.896  12.042  1.00  0.00           C  
ATOM    331  H   VAL A  21       4.038  -9.504  10.068  1.00  0.00           H  
ATOM    332  HA  VAL A  21       4.149 -12.378   9.831  1.00  0.00           H  
ATOM    333  HB  VAL A  21       4.081 -11.401  12.001  1.00  0.00           H  
ATOM    334 HG11 VAL A  21       2.597  -9.497  11.495  1.00  0.00           H  
ATOM    335 HG12 VAL A  21       1.201 -10.595  11.478  1.00  0.00           H  
ATOM    336 HG13 VAL A  21       2.129 -10.357  12.975  1.00  0.00           H  
ATOM    337 HG21 VAL A  21       2.509 -12.855  13.130  1.00  0.00           H  
ATOM    338 HG22 VAL A  21       1.562 -13.078  11.647  1.00  0.00           H  
ATOM    339 HG23 VAL A  21       3.218 -13.718  11.753  1.00  0.00           H  
ATOM    340  N   ASP A  22       1.296 -11.065   8.807  1.00  0.00           N  
ATOM    341  CA  ASP A  22       0.088 -11.280   8.001  1.00  0.00           C  
ATOM    342  C   ASP A  22      -0.318 -10.024   7.202  1.00  0.00           C  
ATOM    343  O   ASP A  22       0.206  -8.926   7.411  1.00  0.00           O  
ATOM    344  CB  ASP A  22      -1.067 -11.677   8.949  1.00  0.00           C  
ATOM    345  CG  ASP A  22      -1.767 -10.467   9.604  1.00  0.00           C  
ATOM    346  OD1 ASP A  22      -1.081  -9.604  10.207  1.00  0.00           O  
ATOM    347  OD2 ASP A  22      -2.999 -10.346   9.431  1.00  0.00           O  
ATOM    348  H   ASP A  22       1.272 -10.162   9.277  1.00  0.00           H  
ATOM    349  HA  ASP A  22       0.261 -12.097   7.302  1.00  0.00           H  
ATOM    350  HB2 ASP A  22      -1.801 -12.232   8.363  1.00  0.00           H  
ATOM    351  HB3 ASP A  22      -0.703 -12.352   9.726  1.00  0.00           H  
ATOM    352  N   ALA A  23      -1.309 -10.197   6.331  1.00  0.00           N  
ATOM    353  CA  ALA A  23      -1.869  -9.148   5.480  1.00  0.00           C  
ATOM    354  C   ALA A  23      -2.362  -7.912   6.250  1.00  0.00           C  
ATOM    355  O   ALA A  23      -2.250  -6.807   5.729  1.00  0.00           O  
ATOM    356  CB  ALA A  23      -2.996  -9.743   4.628  1.00  0.00           C  
ATOM    357  H   ALA A  23      -1.475 -11.170   6.097  1.00  0.00           H  
ATOM    358  HA  ALA A  23      -1.079  -8.809   4.808  1.00  0.00           H  
ATOM    359  HB1 ALA A  23      -3.819 -10.065   5.267  1.00  0.00           H  
ATOM    360  HB2 ALA A  23      -3.364  -8.989   3.930  1.00  0.00           H  
ATOM    361  HB3 ALA A  23      -2.627 -10.596   4.057  1.00  0.00           H  
ATOM    362  N   ALA A  24      -2.861  -8.045   7.485  1.00  0.00           N  
ATOM    363  CA  ALA A  24      -3.316  -6.917   8.281  1.00  0.00           C  
ATOM    364  C   ALA A  24      -2.139  -6.158   8.908  1.00  0.00           C  
ATOM    365  O   ALA A  24      -2.195  -4.935   9.016  1.00  0.00           O  
ATOM    366  CB  ALA A  24      -4.318  -7.369   9.348  1.00  0.00           C  
ATOM    367  H   ALA A  24      -2.822  -8.935   7.944  1.00  0.00           H  
ATOM    368  HA  ALA A  24      -3.838  -6.253   7.599  1.00  0.00           H  
ATOM    369  HB1 ALA A  24      -3.820  -7.969  10.107  1.00  0.00           H  
ATOM    370  HB2 ALA A  24      -4.753  -6.491   9.829  1.00  0.00           H  
ATOM    371  HB3 ALA A  24      -5.119  -7.948   8.886  1.00  0.00           H  
ATOM    372  N   THR A  25      -1.033  -6.821   9.264  1.00  0.00           N  
ATOM    373  CA  THR A  25       0.214  -6.150   9.669  1.00  0.00           C  
ATOM    374  C   THR A  25       0.884  -5.430   8.489  1.00  0.00           C  
ATOM    375  O   THR A  25       1.226  -4.256   8.609  1.00  0.00           O  
ATOM    376  CB  THR A  25       1.172  -7.143  10.334  1.00  0.00           C  
ATOM    377  OG1 THR A  25       0.516  -7.809  11.391  1.00  0.00           O  
ATOM    378  CG2 THR A  25       2.403  -6.454  10.932  1.00  0.00           C  
ATOM    379  H   THR A  25      -0.958  -7.824   9.305  1.00  0.00           H  
ATOM    380  HA  THR A  25       0.000  -5.422  10.439  1.00  0.00           H  
ATOM    381  HB  THR A  25       1.484  -7.879   9.603  1.00  0.00           H  
ATOM    382  HG1 THR A  25      -0.086  -8.471  10.989  1.00  0.00           H  
ATOM    383 HG21 THR A  25       2.988  -5.969  10.150  1.00  0.00           H  
ATOM    384 HG22 THR A  25       3.036  -7.194  11.425  1.00  0.00           H  
ATOM    385 HG23 THR A  25       2.095  -5.705  11.662  1.00  0.00           H  
ATOM    386  N   ALA A  26       0.993  -6.051   7.307  1.00  0.00           N  
ATOM    387  CA  ALA A  26       1.487  -5.360   6.103  1.00  0.00           C  
ATOM    388  C   ALA A  26       0.590  -4.184   5.653  1.00  0.00           C  
ATOM    389  O   ALA A  26       1.095  -3.126   5.281  1.00  0.00           O  
ATOM    390  CB  ALA A  26       1.627  -6.369   4.967  1.00  0.00           C  
ATOM    391  H   ALA A  26       0.896  -7.064   7.287  1.00  0.00           H  
ATOM    392  HA  ALA A  26       2.479  -4.963   6.317  1.00  0.00           H  
ATOM    393  HB1 ALA A  26       1.934  -5.842   4.063  1.00  0.00           H  
ATOM    394  HB2 ALA A  26       2.394  -7.098   5.218  1.00  0.00           H  
ATOM    395  HB3 ALA A  26       0.680  -6.877   4.787  1.00  0.00           H  
ATOM    396  N   GLU A  27      -0.730  -4.351   5.803  1.00  0.00           N  
ATOM    397  CA  GLU A  27      -1.714  -3.257   5.628  1.00  0.00           C  
ATOM    398  C   GLU A  27      -1.488  -2.148   6.648  1.00  0.00           C  
ATOM    399  O   GLU A  27      -1.493  -0.972   6.289  1.00  0.00           O  
ATOM    400  CB  GLU A  27      -3.181  -3.719   5.702  1.00  0.00           C  
ATOM    401  CG  GLU A  27      -4.137  -2.645   5.173  1.00  0.00           C  
ATOM    402  CD  GLU A  27      -5.578  -2.995   5.515  1.00  0.00           C  
ATOM    403  OE1 GLU A  27      -6.166  -3.872   4.847  1.00  0.00           O  
ATOM    404  OE2 GLU A  27      -6.128  -2.352   6.439  1.00  0.00           O  
ATOM    405  H   GLU A  27      -0.861  -5.170   6.367  1.00  0.00           H  
ATOM    406  HA  GLU A  27      -1.558  -2.826   4.638  1.00  0.00           H  
ATOM    407  HB2 GLU A  27      -3.314  -4.606   5.090  1.00  0.00           H  
ATOM    408  HB3 GLU A  27      -3.434  -3.957   6.735  1.00  0.00           H  
ATOM    409  HG2 GLU A  27      -3.904  -1.679   5.614  1.00  0.00           H  
ATOM    410  HG3 GLU A  27      -4.027  -2.563   4.092  1.00  0.00           H  
ATOM    411  N   LYS A  28      -1.212  -2.495   7.908  1.00  0.00           N  
ATOM    412  CA  LYS A  28      -0.889  -1.497   8.941  1.00  0.00           C  
ATOM    413  C   LYS A  28       0.418  -0.736   8.629  1.00  0.00           C  
ATOM    414  O   LYS A  28       0.440   0.496   8.701  1.00  0.00           O  
ATOM    415  CB  LYS A  28      -0.846  -2.202  10.310  1.00  0.00           C  
ATOM    416  CG  LYS A  28      -0.510  -1.271  11.486  1.00  0.00           C  
ATOM    417  CD  LYS A  28      -0.593  -1.997  12.841  1.00  0.00           C  
ATOM    418  CE  LYS A  28       0.412  -3.151  12.966  1.00  0.00           C  
ATOM    419  NZ  LYS A  28       0.327  -3.814  14.285  1.00  0.00           N  
ATOM    420  H   LYS A  28      -0.969  -3.422   8.140  1.00  0.00           H  
ATOM    421  HA  LYS A  28      -1.693  -0.761   8.971  1.00  0.00           H  
ATOM    422  HB2 LYS A  28      -1.822  -2.650  10.493  1.00  0.00           H  
ATOM    423  HB3 LYS A  28      -0.107  -2.997  10.276  1.00  0.00           H  
ATOM    424  HG2 LYS A  28       0.496  -0.867  11.366  1.00  0.00           H  
ATOM    425  HG3 LYS A  28      -1.217  -0.441  11.494  1.00  0.00           H  
ATOM    426  HD2 LYS A  28      -0.394  -1.270  13.631  1.00  0.00           H  
ATOM    427  HD3 LYS A  28      -1.605  -2.383  12.976  1.00  0.00           H  
ATOM    428  HE2 LYS A  28       0.210  -3.887  12.187  1.00  0.00           H  
ATOM    429  HE3 LYS A  28       1.420  -2.761  12.822  1.00  0.00           H  
ATOM    430  HZ1 LYS A  28       0.998  -4.566  14.344  1.00  0.00           H  
ATOM    431  HZ2 LYS A  28      -0.594  -4.199  14.430  1.00  0.00           H  
ATOM    432  HZ3 LYS A  28       0.523  -3.156  15.025  1.00  0.00           H  
ATOM    433  N   VAL A  29       1.499  -1.422   8.233  1.00  0.00           N  
ATOM    434  CA  VAL A  29       2.758  -0.779   7.794  1.00  0.00           C  
ATOM    435  C   VAL A  29       2.521   0.149   6.598  1.00  0.00           C  
ATOM    436  O   VAL A  29       2.839   1.335   6.665  1.00  0.00           O  
ATOM    437  CB  VAL A  29       3.835  -1.839   7.469  1.00  0.00           C  
ATOM    438  CG1 VAL A  29       5.110  -1.241   6.858  1.00  0.00           C  
ATOM    439  CG2 VAL A  29       4.255  -2.587   8.743  1.00  0.00           C  
ATOM    440  H   VAL A  29       1.540  -2.426   8.362  1.00  0.00           H  
ATOM    441  HA  VAL A  29       3.132  -0.166   8.615  1.00  0.00           H  
ATOM    442  HB  VAL A  29       3.420  -2.557   6.761  1.00  0.00           H  
ATOM    443 HG11 VAL A  29       5.511  -0.466   7.512  1.00  0.00           H  
ATOM    444 HG12 VAL A  29       5.859  -2.024   6.730  1.00  0.00           H  
ATOM    445 HG13 VAL A  29       4.901  -0.816   5.877  1.00  0.00           H  
ATOM    446 HG21 VAL A  29       4.726  -1.895   9.444  1.00  0.00           H  
ATOM    447 HG22 VAL A  29       3.394  -3.040   9.229  1.00  0.00           H  
ATOM    448 HG23 VAL A  29       4.962  -3.378   8.490  1.00  0.00           H  
ATOM    449  N   PHE A  30       1.893  -0.346   5.530  1.00  0.00           N  
ATOM    450  CA  PHE A  30       1.601   0.478   4.354  1.00  0.00           C  
ATOM    451  C   PHE A  30       0.693   1.692   4.655  1.00  0.00           C  
ATOM    452  O   PHE A  30       0.904   2.778   4.110  1.00  0.00           O  
ATOM    453  CB  PHE A  30       0.966  -0.370   3.249  1.00  0.00           C  
ATOM    454  CG  PHE A  30       1.816  -1.478   2.649  1.00  0.00           C  
ATOM    455  CD1 PHE A  30       3.172  -1.264   2.325  1.00  0.00           C  
ATOM    456  CD2 PHE A  30       1.223  -2.723   2.359  1.00  0.00           C  
ATOM    457  CE1 PHE A  30       3.921  -2.285   1.714  1.00  0.00           C  
ATOM    458  CE2 PHE A  30       1.975  -3.744   1.754  1.00  0.00           C  
ATOM    459  CZ  PHE A  30       3.321  -3.518   1.423  1.00  0.00           C  
ATOM    460  H   PHE A  30       1.876  -1.360   5.459  1.00  0.00           H  
ATOM    461  HA  PHE A  30       2.550   0.870   3.993  1.00  0.00           H  
ATOM    462  HB2 PHE A  30       0.040  -0.799   3.635  1.00  0.00           H  
ATOM    463  HB3 PHE A  30       0.701   0.313   2.444  1.00  0.00           H  
ATOM    464  HD1 PHE A  30       3.641  -0.310   2.520  1.00  0.00           H  
ATOM    465  HD2 PHE A  30       0.188  -2.904   2.623  1.00  0.00           H  
ATOM    466  HE1 PHE A  30       4.954  -2.122   1.449  1.00  0.00           H  
ATOM    467  HE2 PHE A  30       1.520  -4.699   1.541  1.00  0.00           H  
ATOM    468  HZ  PHE A  30       3.899  -4.292   0.947  1.00  0.00           H  
ATOM    469  N   LYS A  31      -0.274   1.541   5.566  1.00  0.00           N  
ATOM    470  CA  LYS A  31      -1.088   2.669   6.030  1.00  0.00           C  
ATOM    471  C   LYS A  31      -0.295   3.697   6.852  1.00  0.00           C  
ATOM    472  O   LYS A  31      -0.653   4.874   6.844  1.00  0.00           O  
ATOM    473  CB  LYS A  31      -2.316   2.183   6.814  1.00  0.00           C  
ATOM    474  CG  LYS A  31      -3.403   1.723   5.836  1.00  0.00           C  
ATOM    475  CD  LYS A  31      -4.656   1.219   6.550  1.00  0.00           C  
ATOM    476  CE  LYS A  31      -5.734   0.933   5.498  1.00  0.00           C  
ATOM    477  NZ  LYS A  31      -6.941   0.331   6.095  1.00  0.00           N  
ATOM    478  H   LYS A  31      -0.231   0.702   6.112  1.00  0.00           H  
ATOM    479  HA  LYS A  31      -1.449   3.206   5.150  1.00  0.00           H  
ATOM    480  HB2 LYS A  31      -2.039   1.377   7.494  1.00  0.00           H  
ATOM    481  HB3 LYS A  31      -2.717   3.009   7.403  1.00  0.00           H  
ATOM    482  HG2 LYS A  31      -3.676   2.569   5.201  1.00  0.00           H  
ATOM    483  HG3 LYS A  31      -3.012   0.924   5.207  1.00  0.00           H  
ATOM    484  HD2 LYS A  31      -4.413   0.309   7.102  1.00  0.00           H  
ATOM    485  HD3 LYS A  31      -5.013   1.980   7.244  1.00  0.00           H  
ATOM    486  HE2 LYS A  31      -6.000   1.871   5.006  1.00  0.00           H  
ATOM    487  HE3 LYS A  31      -5.327   0.254   4.746  1.00  0.00           H  
ATOM    488  HZ1 LYS A  31      -7.289   0.901   6.851  1.00  0.00           H  
ATOM    489  HZ2 LYS A  31      -6.721  -0.597   6.445  1.00  0.00           H  
ATOM    490  HZ3 LYS A  31      -7.664   0.238   5.397  1.00  0.00           H  
ATOM    491  N   GLN A  32       0.800   3.320   7.522  1.00  0.00           N  
ATOM    492  CA  GLN A  32       1.652   4.266   8.266  1.00  0.00           C  
ATOM    493  C   GLN A  32       2.338   5.297   7.348  1.00  0.00           C  
ATOM    494  O   GLN A  32       2.398   6.483   7.678  1.00  0.00           O  
ATOM    495  CB  GLN A  32       2.699   3.464   9.074  1.00  0.00           C  
ATOM    496  CG  GLN A  32       2.711   3.770  10.576  1.00  0.00           C  
ATOM    497  CD  GLN A  32       1.378   3.546  11.271  1.00  0.00           C  
ATOM    498  OE1 GLN A  32       0.943   4.364  12.071  1.00  0.00           O  
ATOM    499  NE2 GLN A  32       0.694   2.451  11.015  1.00  0.00           N  
ATOM    500  H   GLN A  32       1.102   2.391   7.601  1.00  0.00           H  
ATOM    501  HA  GLN A  32       1.014   4.814   8.961  1.00  0.00           H  
ATOM    502  HB2 GLN A  32       2.513   2.395   8.969  1.00  0.00           H  
ATOM    503  HB3 GLN A  32       3.697   3.652   8.676  1.00  0.00           H  
ATOM    504  HG2 GLN A  32       3.446   3.125  11.053  1.00  0.00           H  
ATOM    505  HG3 GLN A  32       3.012   4.805  10.727  1.00  0.00           H  
ATOM    506 HE21 GLN A  32       1.003   1.800  10.304  1.00  0.00           H  
ATOM    507 HE22 GLN A  32      -0.189   2.320  11.480  1.00  0.00           H  
ATOM    508  N   TYR A  33       2.819   4.855   6.180  1.00  0.00           N  
ATOM    509  CA  TYR A  33       3.440   5.711   5.153  1.00  0.00           C  
ATOM    510  C   TYR A  33       2.411   6.395   4.219  1.00  0.00           C  
ATOM    511  O   TYR A  33       2.615   7.543   3.820  1.00  0.00           O  
ATOM    512  CB  TYR A  33       4.375   4.855   4.272  1.00  0.00           C  
ATOM    513  CG  TYR A  33       5.659   4.318   4.897  1.00  0.00           C  
ATOM    514  CD1 TYR A  33       5.613   3.326   5.899  1.00  0.00           C  
ATOM    515  CD2 TYR A  33       6.914   4.734   4.404  1.00  0.00           C  
ATOM    516  CE1 TYR A  33       6.797   2.768   6.413  1.00  0.00           C  
ATOM    517  CE2 TYR A  33       8.102   4.167   4.912  1.00  0.00           C  
ATOM    518  CZ  TYR A  33       8.040   3.184   5.914  1.00  0.00           C  
ATOM    519  OH  TYR A  33       9.182   2.638   6.410  1.00  0.00           O  
ATOM    520  H   TYR A  33       2.867   3.854   6.055  1.00  0.00           H  
ATOM    521  HA  TYR A  33       4.036   6.488   5.633  1.00  0.00           H  
ATOM    522  HB2 TYR A  33       3.810   4.004   3.890  1.00  0.00           H  
ATOM    523  HB3 TYR A  33       4.656   5.456   3.406  1.00  0.00           H  
ATOM    524  HD1 TYR A  33       4.667   2.969   6.269  1.00  0.00           H  
ATOM    525  HD2 TYR A  33       6.969   5.469   3.611  1.00  0.00           H  
ATOM    526  HE1 TYR A  33       6.748   2.007   7.178  1.00  0.00           H  
ATOM    527  HE2 TYR A  33       9.061   4.478   4.527  1.00  0.00           H  
ATOM    528  HH  TYR A  33       9.048   2.257   7.282  1.00  0.00           H  
ATOM    529  N   PHE A  34       1.307   5.699   3.912  1.00  0.00           N  
ATOM    530  CA  PHE A  34       0.335   6.090   2.870  1.00  0.00           C  
ATOM    531  C   PHE A  34      -1.138   6.313   3.294  1.00  0.00           C  
ATOM    532  O   PHE A  34      -2.055   5.755   2.684  1.00  0.00           O  
ATOM    533  CB  PHE A  34       0.477   5.142   1.662  1.00  0.00           C  
ATOM    534  CG  PHE A  34       1.904   4.971   1.165  1.00  0.00           C  
ATOM    535  CD1 PHE A  34       2.600   6.068   0.620  1.00  0.00           C  
ATOM    536  CD2 PHE A  34       2.556   3.729   1.291  1.00  0.00           C  
ATOM    537  CE1 PHE A  34       3.944   5.932   0.230  1.00  0.00           C  
ATOM    538  CE2 PHE A  34       3.899   3.593   0.900  1.00  0.00           C  
ATOM    539  CZ  PHE A  34       4.596   4.696   0.375  1.00  0.00           C  
ATOM    540  H   PHE A  34       1.407   4.771   4.248  1.00  0.00           H  
ATOM    541  HA  PHE A  34       0.646   7.065   2.502  1.00  0.00           H  
ATOM    542  HB2 PHE A  34       0.069   4.166   1.926  1.00  0.00           H  
ATOM    543  HB3 PHE A  34      -0.119   5.534   0.836  1.00  0.00           H  
ATOM    544  HD1 PHE A  34       2.108   7.024   0.511  1.00  0.00           H  
ATOM    545  HD2 PHE A  34       2.033   2.881   1.708  1.00  0.00           H  
ATOM    546  HE1 PHE A  34       4.482   6.777  -0.177  1.00  0.00           H  
ATOM    547  HE2 PHE A  34       4.399   2.645   1.020  1.00  0.00           H  
ATOM    548  HZ  PHE A  34       5.632   4.598   0.087  1.00  0.00           H  
ATOM    549  N   ASN A  35      -1.391   7.171   4.295  1.00  0.00           N  
ATOM    550  CA  ASN A  35      -2.753   7.574   4.700  1.00  0.00           C  
ATOM    551  C   ASN A  35      -3.110   9.076   4.536  1.00  0.00           C  
ATOM    552  O   ASN A  35      -4.218   9.371   4.079  1.00  0.00           O  
ATOM    553  CB  ASN A  35      -3.029   7.082   6.127  1.00  0.00           C  
ATOM    554  CG  ASN A  35      -2.263   7.847   7.198  1.00  0.00           C  
ATOM    555  OD1 ASN A  35      -1.078   8.134   7.078  1.00  0.00           O  
ATOM    556  ND2 ASN A  35      -2.944   8.238   8.253  1.00  0.00           N  
ATOM    557  H   ASN A  35      -0.633   7.386   4.927  1.00  0.00           H  
ATOM    558  HA  ASN A  35      -3.474   7.042   4.084  1.00  0.00           H  
ATOM    559  HB2 ASN A  35      -4.097   7.189   6.316  1.00  0.00           H  
ATOM    560  HB3 ASN A  35      -2.798   6.022   6.205  1.00  0.00           H  
ATOM    561 HD21 ASN A  35      -3.925   8.017   8.321  1.00  0.00           H  
ATOM    562 HD22 ASN A  35      -2.471   8.769   8.967  1.00  0.00           H  
ATOM    563  N   ASP A  36      -2.225  10.025   4.884  1.00  0.00           N  
ATOM    564  CA  ASP A  36      -2.559  11.474   4.953  1.00  0.00           C  
ATOM    565  C   ASP A  36      -1.449  12.463   4.547  1.00  0.00           C  
ATOM    566  O   ASP A  36      -1.573  13.669   4.776  1.00  0.00           O  
ATOM    567  CB  ASP A  36      -3.150  11.822   6.336  1.00  0.00           C  
ATOM    568  CG  ASP A  36      -2.143  11.991   7.500  1.00  0.00           C  
ATOM    569  OD1 ASP A  36      -0.957  11.602   7.378  1.00  0.00           O  
ATOM    570  OD2 ASP A  36      -2.559  12.522   8.560  1.00  0.00           O  
ATOM    571  H   ASP A  36      -1.365   9.715   5.322  1.00  0.00           H  
ATOM    572  HA  ASP A  36      -3.355  11.652   4.229  1.00  0.00           H  
ATOM    573  HB2 ASP A  36      -3.695  12.760   6.219  1.00  0.00           H  
ATOM    574  HB3 ASP A  36      -3.886  11.062   6.603  1.00  0.00           H  
ATOM    575  N   ASN A  37      -0.387  11.968   3.910  1.00  0.00           N  
ATOM    576  CA  ASN A  37       0.644  12.807   3.270  1.00  0.00           C  
ATOM    577  C   ASN A  37       0.020  13.778   2.219  1.00  0.00           C  
ATOM    578  O   ASN A  37       0.414  14.939   2.081  1.00  0.00           O  
ATOM    579  CB  ASN A  37       1.720  11.872   2.672  1.00  0.00           C  
ATOM    580  CG  ASN A  37       1.184  10.745   1.789  1.00  0.00           C  
ATOM    581  OD1 ASN A  37       0.298  10.918   0.964  1.00  0.00           O  
ATOM    582  ND2 ASN A  37       1.643   9.528   1.966  1.00  0.00           N  
ATOM    583  H   ASN A  37      -0.398  10.974   3.739  1.00  0.00           H  
ATOM    584  HA  ASN A  37       1.118  13.418   4.039  1.00  0.00           H  
ATOM    585  HB2 ASN A  37       2.430  12.457   2.089  1.00  0.00           H  
ATOM    586  HB3 ASN A  37       2.272  11.424   3.500  1.00  0.00           H  
ATOM    587 HD21 ASN A  37       2.315   9.308   2.689  1.00  0.00           H  
ATOM    588 HD22 ASN A  37       1.278   8.803   1.376  1.00  0.00           H  
ATOM    589  N   GLY A  38      -0.988  13.257   1.522  1.00  0.00           N  
ATOM    590  CA  GLY A  38      -1.759  13.886   0.446  1.00  0.00           C  
ATOM    591  C   GLY A  38      -2.631  12.923  -0.369  1.00  0.00           C  
ATOM    592  O   GLY A  38      -3.635  13.355  -0.939  1.00  0.00           O  
ATOM    593  H   GLY A  38      -0.935  12.266   1.651  1.00  0.00           H  
ATOM    594  HA2 GLY A  38      -2.401  14.658   0.871  1.00  0.00           H  
ATOM    595  HA3 GLY A  38      -1.064  14.362  -0.246  1.00  0.00           H  
ATOM    596  N   VAL A  39      -2.282  11.629  -0.418  1.00  0.00           N  
ATOM    597  CA  VAL A  39      -3.000  10.618  -1.224  1.00  0.00           C  
ATOM    598  C   VAL A  39      -4.491  10.474  -0.857  1.00  0.00           C  
ATOM    599  O   VAL A  39      -5.344  10.630  -1.730  1.00  0.00           O  
ATOM    600  CB  VAL A  39      -2.258   9.261  -1.216  1.00  0.00           C  
ATOM    601  CG1 VAL A  39      -2.183   8.557   0.146  1.00  0.00           C  
ATOM    602  CG2 VAL A  39      -2.856   8.284  -2.234  1.00  0.00           C  
ATOM    603  H   VAL A  39      -1.412  11.356   0.026  1.00  0.00           H  
ATOM    604  HA  VAL A  39      -2.970  10.975  -2.256  1.00  0.00           H  
ATOM    605  HB  VAL A  39      -1.231   9.458  -1.529  1.00  0.00           H  
ATOM    606 HG11 VAL A  39      -1.834   9.247   0.915  1.00  0.00           H  
ATOM    607 HG12 VAL A  39      -3.154   8.155   0.432  1.00  0.00           H  
ATOM    608 HG13 VAL A  39      -1.477   7.729   0.084  1.00  0.00           H  
ATOM    609 HG21 VAL A  39      -3.896   8.062  -1.995  1.00  0.00           H  
ATOM    610 HG22 VAL A  39      -2.801   8.715  -3.232  1.00  0.00           H  
ATOM    611 HG23 VAL A  39      -2.292   7.352  -2.226  1.00  0.00           H  
ATOM    612  N   ASP A  40      -4.823  10.222   0.422  1.00  0.00           N  
ATOM    613  CA  ASP A  40      -6.185   9.941   0.945  1.00  0.00           C  
ATOM    614  C   ASP A  40      -7.087   9.125  -0.024  1.00  0.00           C  
ATOM    615  O   ASP A  40      -8.259   9.444  -0.246  1.00  0.00           O  
ATOM    616  CB  ASP A  40      -6.820  11.274   1.407  1.00  0.00           C  
ATOM    617  CG  ASP A  40      -8.145  11.126   2.192  1.00  0.00           C  
ATOM    618  OD1 ASP A  40      -8.267  10.203   3.034  1.00  0.00           O  
ATOM    619  OD2 ASP A  40      -9.055  11.971   1.999  1.00  0.00           O  
ATOM    620  H   ASP A  40      -4.059  10.173   1.083  1.00  0.00           H  
ATOM    621  HA  ASP A  40      -6.054   9.326   1.836  1.00  0.00           H  
ATOM    622  HB2 ASP A  40      -6.106  11.792   2.051  1.00  0.00           H  
ATOM    623  HB3 ASP A  40      -6.984  11.904   0.530  1.00  0.00           H  
ATOM    624  N   GLY A  41      -6.514   8.091  -0.653  1.00  0.00           N  
ATOM    625  CA  GLY A  41      -7.120   7.330  -1.761  1.00  0.00           C  
ATOM    626  C   GLY A  41      -7.894   6.059  -1.384  1.00  0.00           C  
ATOM    627  O   GLY A  41      -7.927   5.635  -0.225  1.00  0.00           O  
ATOM    628  H   GLY A  41      -5.564   7.874  -0.390  1.00  0.00           H  
ATOM    629  HA2 GLY A  41      -7.795   7.980  -2.318  1.00  0.00           H  
ATOM    630  HA3 GLY A  41      -6.327   7.037  -2.450  1.00  0.00           H  
ATOM    631  N   GLU A  42      -8.521   5.437  -2.392  1.00  0.00           N  
ATOM    632  CA  GLU A  42      -9.308   4.186  -2.290  1.00  0.00           C  
ATOM    633  C   GLU A  42      -8.423   2.937  -2.338  1.00  0.00           C  
ATOM    634  O   GLU A  42      -7.738   2.692  -3.329  1.00  0.00           O  
ATOM    635  CB  GLU A  42     -10.339   4.127  -3.430  1.00  0.00           C  
ATOM    636  CG  GLU A  42     -11.228   2.884  -3.369  1.00  0.00           C  
ATOM    637  CD  GLU A  42     -12.292   2.956  -4.455  1.00  0.00           C  
ATOM    638  OE1 GLU A  42     -11.995   2.573  -5.608  1.00  0.00           O  
ATOM    639  OE2 GLU A  42     -13.429   3.383  -4.148  1.00  0.00           O  
ATOM    640  H   GLU A  42      -8.423   5.851  -3.315  1.00  0.00           H  
ATOM    641  HA  GLU A  42      -9.858   4.190  -1.347  1.00  0.00           H  
ATOM    642  HB2 GLU A  42     -10.974   5.011  -3.359  1.00  0.00           H  
ATOM    643  HB3 GLU A  42      -9.822   4.155  -4.390  1.00  0.00           H  
ATOM    644  HG2 GLU A  42     -10.630   1.985  -3.520  1.00  0.00           H  
ATOM    645  HG3 GLU A  42     -11.707   2.824  -2.391  1.00  0.00           H  
ATOM    646  N   TRP A  43      -8.452   2.140  -1.272  1.00  0.00           N  
ATOM    647  CA  TRP A  43      -7.711   0.874  -1.163  1.00  0.00           C  
ATOM    648  C   TRP A  43      -8.412  -0.314  -1.859  1.00  0.00           C  
ATOM    649  O   TRP A  43      -9.639  -0.447  -1.841  1.00  0.00           O  
ATOM    650  CB  TRP A  43      -7.461   0.559   0.321  1.00  0.00           C  
ATOM    651  CG  TRP A  43      -6.427   1.423   0.982  1.00  0.00           C  
ATOM    652  CD1 TRP A  43      -6.532   2.753   1.202  1.00  0.00           C  
ATOM    653  CD2 TRP A  43      -5.103   1.046   1.479  1.00  0.00           C  
ATOM    654  NE1 TRP A  43      -5.366   3.232   1.765  1.00  0.00           N  
ATOM    655  CE2 TRP A  43      -4.445   2.226   1.944  1.00  0.00           C  
ATOM    656  CE3 TRP A  43      -4.382  -0.167   1.570  1.00  0.00           C  
ATOM    657  CZ2 TRP A  43      -3.138   2.209   2.449  1.00  0.00           C  
ATOM    658  CZ3 TRP A  43      -3.075  -0.198   2.095  1.00  0.00           C  
ATOM    659  CH2 TRP A  43      -2.455   0.987   2.526  1.00  0.00           C  
ATOM    660  H   TRP A  43      -8.951   2.467  -0.455  1.00  0.00           H  
ATOM    661  HA  TRP A  43      -6.736   1.007  -1.633  1.00  0.00           H  
ATOM    662  HB2 TRP A  43      -8.399   0.635   0.873  1.00  0.00           H  
ATOM    663  HB3 TRP A  43      -7.123  -0.476   0.399  1.00  0.00           H  
ATOM    664  HD1 TRP A  43      -7.389   3.362   0.947  1.00  0.00           H  
ATOM    665  HE1 TRP A  43      -5.217   4.210   1.984  1.00  0.00           H  
ATOM    666  HE3 TRP A  43      -4.845  -1.084   1.234  1.00  0.00           H  
ATOM    667  HZ2 TRP A  43      -2.672   3.124   2.784  1.00  0.00           H  
ATOM    668  HZ3 TRP A  43      -2.542  -1.138   2.167  1.00  0.00           H  
ATOM    669  HH2 TRP A  43      -1.457   0.961   2.933  1.00  0.00           H  
ATOM    670  N   THR A  44      -7.604  -1.204  -2.439  1.00  0.00           N  
ATOM    671  CA  THR A  44      -7.969  -2.515  -3.017  1.00  0.00           C  
ATOM    672  C   THR A  44      -6.895  -3.557  -2.639  1.00  0.00           C  
ATOM    673  O   THR A  44      -5.744  -3.176  -2.408  1.00  0.00           O  
ATOM    674  CB  THR A  44      -8.057  -2.427  -4.559  1.00  0.00           C  
ATOM    675  OG1 THR A  44      -8.724  -1.258  -4.988  1.00  0.00           O  
ATOM    676  CG2 THR A  44      -8.788  -3.608  -5.203  1.00  0.00           C  
ATOM    677  H   THR A  44      -6.603  -1.029  -2.361  1.00  0.00           H  
ATOM    678  HA  THR A  44      -8.931  -2.837  -2.618  1.00  0.00           H  
ATOM    679  HB  THR A  44      -7.051  -2.381  -4.968  1.00  0.00           H  
ATOM    680  HG1 THR A  44      -8.200  -0.516  -4.658  1.00  0.00           H  
ATOM    681 HG21 THR A  44      -8.905  -3.428  -6.271  1.00  0.00           H  
ATOM    682 HG22 THR A  44      -9.773  -3.729  -4.749  1.00  0.00           H  
ATOM    683 HG23 THR A  44      -8.211  -4.523  -5.075  1.00  0.00           H  
ATOM    684  N   TYR A  45      -7.217  -4.858  -2.589  1.00  0.00           N  
ATOM    685  CA  TYR A  45      -6.253  -5.941  -2.305  1.00  0.00           C  
ATOM    686  C   TYR A  45      -6.543  -7.234  -3.095  1.00  0.00           C  
ATOM    687  O   TYR A  45      -7.696  -7.666  -3.199  1.00  0.00           O  
ATOM    688  CB  TYR A  45      -6.283  -6.247  -0.799  1.00  0.00           C  
ATOM    689  CG  TYR A  45      -5.393  -7.397  -0.346  1.00  0.00           C  
ATOM    690  CD1 TYR A  45      -3.995  -7.260  -0.388  1.00  0.00           C  
ATOM    691  CD2 TYR A  45      -5.955  -8.597   0.133  1.00  0.00           C  
ATOM    692  CE1 TYR A  45      -3.159  -8.300   0.059  1.00  0.00           C  
ATOM    693  CE2 TYR A  45      -5.120  -9.633   0.590  1.00  0.00           C  
ATOM    694  CZ  TYR A  45      -3.724  -9.483   0.557  1.00  0.00           C  
ATOM    695  OH  TYR A  45      -2.920 -10.480   1.019  1.00  0.00           O  
ATOM    696  H   TYR A  45      -8.171  -5.135  -2.631  1.00  0.00           H  
ATOM    697  HA  TYR A  45      -5.249  -5.607  -2.567  1.00  0.00           H  
ATOM    698  HB2 TYR A  45      -5.981  -5.351  -0.257  1.00  0.00           H  
ATOM    699  HB3 TYR A  45      -7.312  -6.468  -0.509  1.00  0.00           H  
ATOM    700  HD1 TYR A  45      -3.558  -6.342  -0.745  1.00  0.00           H  
ATOM    701  HD2 TYR A  45      -7.030  -8.721   0.165  1.00  0.00           H  
ATOM    702  HE1 TYR A  45      -2.086  -8.173   0.038  1.00  0.00           H  
ATOM    703  HE2 TYR A  45      -5.548 -10.545   0.979  1.00  0.00           H  
ATOM    704  HH  TYR A  45      -1.999 -10.208   1.050  1.00  0.00           H  
ATOM    705  N   ASP A  46      -5.484  -7.868  -3.610  1.00  0.00           N  
ATOM    706  CA  ASP A  46      -5.468  -9.189  -4.259  1.00  0.00           C  
ATOM    707  C   ASP A  46      -4.582 -10.167  -3.484  1.00  0.00           C  
ATOM    708  O   ASP A  46      -3.349 -10.100  -3.549  1.00  0.00           O  
ATOM    709  CB  ASP A  46      -4.981  -9.058  -5.718  1.00  0.00           C  
ATOM    710  CG  ASP A  46      -5.950  -8.282  -6.634  1.00  0.00           C  
ATOM    711  OD1 ASP A  46      -6.931  -8.890  -7.127  1.00  0.00           O  
ATOM    712  OD2 ASP A  46      -5.712  -7.076  -6.892  1.00  0.00           O  
ATOM    713  H   ASP A  46      -4.606  -7.386  -3.553  1.00  0.00           H  
ATOM    714  HA  ASP A  46      -6.472  -9.618  -4.265  1.00  0.00           H  
ATOM    715  HB2 ASP A  46      -4.003  -8.571  -5.725  1.00  0.00           H  
ATOM    716  HB3 ASP A  46      -4.844 -10.062  -6.123  1.00  0.00           H  
ATOM    717  N   ASP A  47      -5.200 -11.094  -2.746  1.00  0.00           N  
ATOM    718  CA  ASP A  47      -4.537 -12.122  -1.942  1.00  0.00           C  
ATOM    719  C   ASP A  47      -3.698 -13.116  -2.757  1.00  0.00           C  
ATOM    720  O   ASP A  47      -2.632 -13.537  -2.312  1.00  0.00           O  
ATOM    721  CB  ASP A  47      -5.642 -12.847  -1.147  1.00  0.00           C  
ATOM    722  CG  ASP A  47      -6.553 -13.770  -1.987  1.00  0.00           C  
ATOM    723  OD1 ASP A  47      -7.349 -13.250  -2.803  1.00  0.00           O  
ATOM    724  OD2 ASP A  47      -6.456 -15.011  -1.839  1.00  0.00           O  
ATOM    725  H   ASP A  47      -6.167 -11.189  -2.685  1.00  0.00           H  
ATOM    726  HA  ASP A  47      -3.873 -11.629  -1.233  1.00  0.00           H  
ATOM    727  HB2 ASP A  47      -5.155 -13.429  -0.375  1.00  0.00           H  
ATOM    728  HB3 ASP A  47      -6.264 -12.108  -0.641  1.00  0.00           H  
ATOM    729  N   ALA A  48      -4.141 -13.450  -3.966  1.00  0.00           N  
ATOM    730  CA  ALA A  48      -3.469 -14.414  -4.853  1.00  0.00           C  
ATOM    731  C   ALA A  48      -2.035 -14.003  -5.269  1.00  0.00           C  
ATOM    732  O   ALA A  48      -1.244 -14.829  -5.729  1.00  0.00           O  
ATOM    733  CB  ALA A  48      -4.351 -14.631  -6.088  1.00  0.00           C  
ATOM    734  H   ALA A  48      -5.125 -13.285  -4.093  1.00  0.00           H  
ATOM    735  HA  ALA A  48      -3.401 -15.363  -4.319  1.00  0.00           H  
ATOM    736  HB1 ALA A  48      -3.905 -15.393  -6.727  1.00  0.00           H  
ATOM    737  HB2 ALA A  48      -5.342 -14.966  -5.782  1.00  0.00           H  
ATOM    738  HB3 ALA A  48      -4.441 -13.698  -6.650  1.00  0.00           H  
ATOM    739  N   THR A  49      -1.714 -12.718  -5.104  1.00  0.00           N  
ATOM    740  CA  THR A  49      -0.408 -12.096  -5.368  1.00  0.00           C  
ATOM    741  C   THR A  49       0.128 -11.255  -4.186  1.00  0.00           C  
ATOM    742  O   THR A  49       1.037 -10.443  -4.376  1.00  0.00           O  
ATOM    743  CB  THR A  49      -0.446 -11.334  -6.713  1.00  0.00           C  
ATOM    744  OG1 THR A  49       0.826 -10.871  -7.114  1.00  0.00           O  
ATOM    745  CG2 THR A  49      -1.433 -10.166  -6.722  1.00  0.00           C  
ATOM    746  H   THR A  49      -2.437 -12.151  -4.679  1.00  0.00           H  
ATOM    747  HA  THR A  49       0.314 -12.904  -5.493  1.00  0.00           H  
ATOM    748  HB  THR A  49      -0.771 -12.033  -7.482  1.00  0.00           H  
ATOM    749  HG1 THR A  49       1.205 -10.406  -6.353  1.00  0.00           H  
ATOM    750 HG21 THR A  49      -2.450 -10.549  -6.642  1.00  0.00           H  
ATOM    751 HG22 THR A  49      -1.342  -9.614  -7.657  1.00  0.00           H  
ATOM    752 HG23 THR A  49      -1.240  -9.502  -5.885  1.00  0.00           H  
ATOM    753  N   LYS A  50      -0.463 -11.367  -2.985  1.00  0.00           N  
ATOM    754  CA  LYS A  50      -0.129 -10.583  -1.778  1.00  0.00           C  
ATOM    755  C   LYS A  50       0.100  -9.075  -2.030  1.00  0.00           C  
ATOM    756  O   LYS A  50       1.072  -8.484  -1.551  1.00  0.00           O  
ATOM    757  CB  LYS A  50       1.043 -11.249  -1.019  1.00  0.00           C  
ATOM    758  CG  LYS A  50       0.869 -12.745  -0.712  1.00  0.00           C  
ATOM    759  CD  LYS A  50      -0.430 -13.073   0.035  1.00  0.00           C  
ATOM    760  CE  LYS A  50      -0.586 -14.590   0.199  1.00  0.00           C  
ATOM    761  NZ  LYS A  50      -1.990 -14.969   0.459  1.00  0.00           N  
ATOM    762  H   LYS A  50      -1.138 -12.130  -2.862  1.00  0.00           H  
ATOM    763  HA  LYS A  50      -1.003 -10.624  -1.130  1.00  0.00           H  
ATOM    764  HB2 LYS A  50       1.956 -11.127  -1.604  1.00  0.00           H  
ATOM    765  HB3 LYS A  50       1.186 -10.727  -0.074  1.00  0.00           H  
ATOM    766  HG2 LYS A  50       0.900 -13.306  -1.647  1.00  0.00           H  
ATOM    767  HG3 LYS A  50       1.713 -13.065  -0.099  1.00  0.00           H  
ATOM    768  HD2 LYS A  50      -0.429 -12.586   1.004  1.00  0.00           H  
ATOM    769  HD3 LYS A  50      -1.278 -12.686  -0.519  1.00  0.00           H  
ATOM    770  HE2 LYS A  50      -0.260 -15.078  -0.720  1.00  0.00           H  
ATOM    771  HE3 LYS A  50       0.053 -14.930   1.018  1.00  0.00           H  
ATOM    772  HZ1 LYS A  50      -2.331 -14.526   1.298  1.00  0.00           H  
ATOM    773  HZ2 LYS A  50      -2.065 -15.970   0.568  1.00  0.00           H  
ATOM    774  HZ3 LYS A  50      -2.566 -14.689  -0.322  1.00  0.00           H  
ATOM    775  N   THR A  51      -0.788  -8.454  -2.815  1.00  0.00           N  
ATOM    776  CA  THR A  51      -0.601  -7.059  -3.283  1.00  0.00           C  
ATOM    777  C   THR A  51      -1.806  -6.153  -3.006  1.00  0.00           C  
ATOM    778  O   THR A  51      -2.958  -6.527  -3.230  1.00  0.00           O  
ATOM    779  CB  THR A  51      -0.219  -7.004  -4.776  1.00  0.00           C  
ATOM    780  OG1 THR A  51       0.948  -7.756  -5.039  1.00  0.00           O  
ATOM    781  CG2 THR A  51       0.091  -5.590  -5.278  1.00  0.00           C  
ATOM    782  H   THR A  51      -1.631  -8.963  -3.007  1.00  0.00           H  
ATOM    783  HA  THR A  51       0.239  -6.626  -2.742  1.00  0.00           H  
ATOM    784  HB  THR A  51      -1.031  -7.410  -5.373  1.00  0.00           H  
ATOM    785  HG1 THR A  51       0.839  -8.637  -4.644  1.00  0.00           H  
ATOM    786 HG21 THR A  51       0.811  -5.105  -4.619  1.00  0.00           H  
ATOM    787 HG22 THR A  51      -0.822  -4.997  -5.319  1.00  0.00           H  
ATOM    788 HG23 THR A  51       0.507  -5.645  -6.284  1.00  0.00           H  
ATOM    789  N   PHE A  52      -1.514  -4.934  -2.551  1.00  0.00           N  
ATOM    790  CA  PHE A  52      -2.418  -3.827  -2.230  1.00  0.00           C  
ATOM    791  C   PHE A  52      -2.294  -2.727  -3.305  1.00  0.00           C  
ATOM    792  O   PHE A  52      -1.207  -2.507  -3.844  1.00  0.00           O  
ATOM    793  CB  PHE A  52      -2.066  -3.240  -0.855  1.00  0.00           C  
ATOM    794  CG  PHE A  52      -2.372  -4.131   0.333  1.00  0.00           C  
ATOM    795  CD1 PHE A  52      -3.639  -4.072   0.944  1.00  0.00           C  
ATOM    796  CD2 PHE A  52      -1.396  -5.014   0.833  1.00  0.00           C  
ATOM    797  CE1 PHE A  52      -3.930  -4.899   2.043  1.00  0.00           C  
ATOM    798  CE2 PHE A  52      -1.683  -5.835   1.939  1.00  0.00           C  
ATOM    799  CZ  PHE A  52      -2.955  -5.783   2.536  1.00  0.00           C  
ATOM    800  H   PHE A  52      -0.581  -4.647  -2.617  1.00  0.00           H  
ATOM    801  HA  PHE A  52      -3.444  -4.191  -2.205  1.00  0.00           H  
ATOM    802  HB2 PHE A  52      -1.005  -2.991  -0.839  1.00  0.00           H  
ATOM    803  HB3 PHE A  52      -2.618  -2.309  -0.724  1.00  0.00           H  
ATOM    804  HD1 PHE A  52      -4.396  -3.402   0.562  1.00  0.00           H  
ATOM    805  HD2 PHE A  52      -0.426  -5.068   0.363  1.00  0.00           H  
ATOM    806  HE1 PHE A  52      -4.907  -4.864   2.505  1.00  0.00           H  
ATOM    807  HE2 PHE A  52      -0.934  -6.513   2.323  1.00  0.00           H  
ATOM    808  HZ  PHE A  52      -3.186  -6.426   3.372  1.00  0.00           H  
ATOM    809  N   THR A  53      -3.390  -2.041  -3.620  1.00  0.00           N  
ATOM    810  CA  THR A  53      -3.430  -0.971  -4.637  1.00  0.00           C  
ATOM    811  C   THR A  53      -4.214   0.249  -4.130  1.00  0.00           C  
ATOM    812  O   THR A  53      -5.380   0.132  -3.751  1.00  0.00           O  
ATOM    813  CB  THR A  53      -4.049  -1.476  -5.957  1.00  0.00           C  
ATOM    814  OG1 THR A  53      -3.396  -2.638  -6.423  1.00  0.00           O  
ATOM    815  CG2 THR A  53      -3.964  -0.442  -7.082  1.00  0.00           C  
ATOM    816  H   THR A  53      -4.184  -2.104  -2.944  1.00  0.00           H  
ATOM    817  HA  THR A  53      -2.412  -0.648  -4.853  1.00  0.00           H  
ATOM    818  HB  THR A  53      -5.095  -1.731  -5.795  1.00  0.00           H  
ATOM    819  HG1 THR A  53      -3.917  -2.974  -7.163  1.00  0.00           H  
ATOM    820 HG21 THR A  53      -4.546   0.443  -6.823  1.00  0.00           H  
ATOM    821 HG22 THR A  53      -4.370  -0.861  -8.002  1.00  0.00           H  
ATOM    822 HG23 THR A  53      -2.924  -0.157  -7.244  1.00  0.00           H  
ATOM    823  N   VAL A  54      -3.557   1.413  -4.116  1.00  0.00           N  
ATOM    824  CA  VAL A  54      -4.073   2.692  -3.568  1.00  0.00           C  
ATOM    825  C   VAL A  54      -4.227   3.735  -4.684  1.00  0.00           C  
ATOM    826  O   VAL A  54      -3.272   3.995  -5.417  1.00  0.00           O  
ATOM    827  CB  VAL A  54      -3.171   3.223  -2.434  1.00  0.00           C  
ATOM    828  CG1 VAL A  54      -3.800   4.447  -1.752  1.00  0.00           C  
ATOM    829  CG2 VAL A  54      -2.960   2.155  -1.353  1.00  0.00           C  
ATOM    830  H   VAL A  54      -2.545   1.317  -4.293  1.00  0.00           H  
ATOM    831  HA  VAL A  54      -5.056   2.510  -3.137  1.00  0.00           H  
ATOM    832  HB  VAL A  54      -2.197   3.505  -2.838  1.00  0.00           H  
ATOM    833 HG11 VAL A  54      -3.164   4.776  -0.930  1.00  0.00           H  
ATOM    834 HG12 VAL A  54      -3.892   5.270  -2.459  1.00  0.00           H  
ATOM    835 HG13 VAL A  54      -4.785   4.190  -1.356  1.00  0.00           H  
ATOM    836 HG21 VAL A  54      -3.923   1.796  -0.995  1.00  0.00           H  
ATOM    837 HG22 VAL A  54      -2.397   1.318  -1.760  1.00  0.00           H  
ATOM    838 HG23 VAL A  54      -2.396   2.570  -0.519  1.00  0.00           H  
ATOM    839  N   THR A  55      -5.439   4.284  -4.816  1.00  0.00           N  
ATOM    840  CA  THR A  55      -5.827   5.140  -5.964  1.00  0.00           C  
ATOM    841  C   THR A  55      -6.596   6.444  -5.674  1.00  0.00           C  
ATOM    842  O   THR A  55      -7.728   6.402  -5.181  1.00  0.00           O  
ATOM    843  CB  THR A  55      -6.550   4.304  -7.045  1.00  0.00           C  
ATOM    844  OG1 THR A  55      -5.758   3.209  -7.455  1.00  0.00           O  
ATOM    845  CG2 THR A  55      -6.868   5.095  -8.317  1.00  0.00           C  
ATOM    846  H   THR A  55      -5.809   4.428  -3.882  1.00  0.00           H  
ATOM    847  HA  THR A  55      -4.900   5.468  -6.422  1.00  0.00           H  
ATOM    848  HB  THR A  55      -7.468   3.892  -6.638  1.00  0.00           H  
ATOM    849  HG1 THR A  55      -6.308   2.672  -8.036  1.00  0.00           H  
ATOM    850 HG21 THR A  55      -7.265   4.426  -9.081  1.00  0.00           H  
ATOM    851 HG22 THR A  55      -5.967   5.579  -8.693  1.00  0.00           H  
ATOM    852 HG23 THR A  55      -7.622   5.853  -8.105  1.00  0.00           H  
ATOM    853  N   GLU A  56      -5.975   7.595  -5.991  1.00  0.00           N  
ATOM    854  CA  GLU A  56      -6.622   8.934  -5.999  1.00  0.00           C  
ATOM    855  C   GLU A  56      -7.761   8.998  -7.027  1.00  0.00           C  
ATOM    856  O   GLU A  56      -7.481   8.872  -8.239  1.00  0.00           O  
ATOM    857  CB  GLU A  56      -5.660  10.091  -6.301  1.00  0.00           C  
ATOM    858  CG  GLU A  56      -4.743  10.428  -5.130  1.00  0.00           C  
ATOM    859  CD  GLU A  56      -4.141  11.818  -5.297  1.00  0.00           C  
ATOM    860  OE1 GLU A  56      -4.882  12.813  -5.133  1.00  0.00           O  
ATOM    861  OE2 GLU A  56      -2.934  11.912  -5.606  1.00  0.00           O  
ATOM    862  OXT GLU A  56      -8.920   9.209  -6.610  1.00  0.00           O  
ATOM    863  H   GLU A  56      -4.958   7.458  -5.933  1.00  0.00           H  
ATOM    864  HA  GLU A  56      -7.070   9.115  -5.022  1.00  0.00           H  
ATOM    865  HB2 GLU A  56      -5.069   9.868  -7.189  1.00  0.00           H  
ATOM    866  HB3 GLU A  56      -6.265  10.972  -6.517  1.00  0.00           H  
ATOM    867  HG2 GLU A  56      -5.327  10.417  -4.216  1.00  0.00           H  
ATOM    868  HG3 GLU A  56      -3.956   9.681  -5.053  1.00  0.00           H  
TER     869      GLU A  56                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
