
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   56 (  862),  selected   56 , name 1p7e_A
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 1p7e_A.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      T       1          0.932
LGA    Q     2_A      T       2          1.131
LGA    Y     3_A      Y       3          0.692
LGA    K     4_A      K       4          0.705
LGA    L     5_A      L       5          0.750
LGA    V     6_A      I       6          0.967
LGA    I     7_A      L       7          1.036
LGA    N     8_A      N       8          1.310
LGA    G     9_A      L       9          1.274
LGA    K    10_A      K      10          1.120
LGA    T    11_A      Q      11          2.535
LGA    L    12_A      A      12          2.625
LGA    K    13_A      K      13          0.651
LGA    G    14_A      E      14          2.670
LGA    E    15_A      E      15          1.570
LGA    T    16_A      A      16          2.519
LGA    T    17_A      I      17          1.232
LGA    T    18_A      K      18          0.816
LGA    K    19_A      E      19          1.074
LGA    A    20_A      A      20          1.456
LGA    V    21_A      V      21          1.429
LGA    D    22_A      D      22          1.011
LGA    A    23_A      A      23          1.397
LGA    E    24_A      G      24          2.145
LGA    T    25_A      T      25          1.680
LGA    A    26_A      A      26          0.451
LGA    E    27_A      E      27          0.758
LGA    K    28_A      K      28          0.836
LGA    A    29_A      Y      29          0.692
LGA    F    30_A      F      30          0.720
LGA    K    31_A      K      31          0.892
LGA    Q    32_A      L      32          1.034
LGA    Y    33_A      I      33          0.646
LGA    A    34_A      A      34          1.131
LGA    N    35_A      N      35          1.175
LGA    D    36_A      A      36          0.954
LGA    N    37_A      K      37          1.185
LGA    G    38_A      T      38          2.434
LGA    V    39_A      V      39          3.152
LGA    D    40_A      E      40          1.589
LGA    G    41_A      G      41          1.208
LGA    V    42_A      V      42          1.610
LGA    W    43_A      W      43          0.759
LGA    T    44_A      T      44          0.864
LGA    Y    45_A      Y      45          1.183
LGA    D    46_A      K      46          1.912
LGA    D    47_A      D      47          2.876
LGA    A    48_A      E      48          1.221
LGA    T    49_A      I      49          2.131
LGA    K    50_A      K      50          1.013
LGA    T    51_A      T      51          1.158
LGA    F    52_A      F      52          0.782
LGA    T    53_A      T      53          0.906
LGA    V    54_A      V      54          0.802
LGA    T    55_A      T      55          0.556
LGA    E    56_A      E      56          0.742

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   56   56    5.0     56    1.44    58.93     93.382     3.638

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.899716 * X  +  -0.418534 * Y  +   0.123852 * Z  +  -0.380133
  Y_new =  -0.404130 * X  +   0.905999 * Y  +   0.125873 * Z  +  -0.073025
  Z_new =  -0.164892 * X  +   0.063198 * Y  +  -0.984285 * Z  +   0.242344 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.077474   -0.064119  [ DEG:   176.3263     -3.6737 ]
  Theta =   0.165649    2.975944  [ DEG:     9.4910    170.5090 ]
  Phi   =  -2.719425    0.422167  [ DEG:  -155.8116     24.1884 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1p7e_A                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1p7e_A.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   56   56   5.0   56   1.44   58.93  93.382
REMARK  ---------------------------------------------------------- 
MOLECULE 1p7e_A
HEADER    IMMUNE SYSTEM                           01-MAY-03   1P7E              
TITLE     GB3 SOLUTION STRUCTURE OBTAINED BY REFINEMENT OF X-RAY                
TITLE    2 STRUCTURE WITH DIPOLAR COUPLINGS                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: IMMUNOGLOBULIN G BINDING PROTEIN G;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: THIRD IGG-BINDING DOMAIN;                                  
COMPND   5 SYNONYM: IGG BINDING PROTEIN G, GB3;                                 
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS SP. GROUP G;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: HMS174;                                    
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET-11A                                   
KEYWDS    IMMUNE SYSTEM                                                         
EXPDTA    NMR                                                                   
AUTHOR    T.S.ULMER,B.E.RAMIREZ,F.DELAGLIO,A.BAX                                
REVDAT   1   05-AUG-03 1P7E    0                                                
JRNL        AUTH   T.S.ULMER,B.E.RAMIREZ,F.DELAGLIO,A.BAX                       
JRNL        TITL   EVALUATION OF BACKBONE PROTON POSITIONS AND                  
JRNL        TITL 2 DYNAMICS IN A SMALL PROTEIN BY LIQUID CRYSTAL NMR            
JRNL        TITL 3 SPECTROSCOPY.                                                
JRNL        REF    J.AM.CHEM.SOC.                V. 125  9179 2003              
JRNL        REFN   ASTM JACSAT  US ISSN 0002-7863                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1P7E A    3    56  UNP    P19909   SPG2_STRSG     444    497             
SEQRES   1 A   56  MET GLN TYR LYS LEU VAL ILE ASN GLY LYS THR LEU LYS          
SEQRES   2 A   56  GLY GLU THR THR THR LYS ALA VAL ASP ALA GLU THR ALA          
SEQRES   3 A   56  GLU LYS ALA PHE LYS GLN TYR ALA ASN ASP ASN GLY VAL          
SEQRES   4 A   56  ASP GLY VAL TRP THR TYR ASP ASP ALA THR LYS THR PHE          
SEQRES   5 A   56  THR VAL THR GLU                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
ATOM      1  N   MET A   1       6.022 -12.698   4.964  1.00  0.00           N  
ATOM      2  CA  MET A   1       5.716 -12.538   3.548  1.00  0.00           C  
ATOM      3  C   MET A   1       6.013 -11.109   3.107  1.00  0.00           C  
ATOM      4  O   MET A   1       5.808 -10.163   3.869  1.00  0.00           O  
ATOM      5  CB  MET A   1       4.236 -12.857   3.285  1.00  0.00           C  
ATOM      6  CG  MET A   1       4.099 -13.745   2.045  1.00  0.00           C  
ATOM      7  SD  MET A   1       4.739 -12.870   0.596  1.00  0.00           S  
ATOM      8  CE  MET A   1       4.860 -14.306  -0.499  1.00  0.00           C  
ATOM      9  HA  MET A   1       6.333 -13.216   2.979  1.00  0.00           H  
ATOM     10  HB2 MET A   1       3.828 -13.375   4.140  1.00  0.00           H  
ATOM     11  HB3 MET A   1       3.687 -11.939   3.129  1.00  0.00           H  
ATOM     12  HG2 MET A   1       4.660 -14.657   2.191  1.00  0.00           H  
ATOM     13  HG3 MET A   1       3.057 -13.985   1.890  1.00  0.00           H  
ATOM     14  HE1 MET A   1       3.899 -14.793  -0.562  1.00  0.00           H  
ATOM     15  HE2 MET A   1       5.590 -14.997  -0.105  1.00  0.00           H  
ATOM     16  HE3 MET A   1       5.166 -13.982  -1.484  1.00  0.00           H  
ATOM     17  H1  MET A   1       7.050 -12.629   5.108  1.00  0.00           H  
ATOM     18  H2  MET A   1       5.688 -13.629   5.288  1.00  0.00           H  
ATOM     19  H3  MET A   1       5.549 -11.950   5.509  1.00  0.00           H  
ATOM     20  N   GLN A   2       6.448 -10.955   1.871  1.00  0.00           N  
ATOM     21  CA  GLN A   2       6.698  -9.625   1.330  1.00  0.00           C  
ATOM     22  C   GLN A   2       5.402  -9.163   0.677  1.00  0.00           C  
ATOM     23  O   GLN A   2       4.886  -9.832  -0.221  1.00  0.00           O  
ATOM     24  CB  GLN A   2       7.847  -9.650   0.308  1.00  0.00           C  
ATOM     25  CG  GLN A   2       8.190 -11.096  -0.061  1.00  0.00           C  
ATOM     26  CD  GLN A   2       9.402 -11.115  -0.994  1.00  0.00           C  
ATOM     27  OE1 GLN A   2      10.516 -11.319  -0.557  1.00  0.00           O  
ATOM     28  NE2 GLN A   2       9.231 -10.910  -2.272  1.00  0.00           N  
ATOM     29  H   GLN A   2       6.605 -11.744   1.310  1.00  0.00           H  
ATOM     30  HA  GLN A   2       6.945  -8.952   2.140  1.00  0.00           H  
ATOM     31  HB2 GLN A   2       7.554  -9.114  -0.583  1.00  0.00           H  
ATOM     32  HB3 GLN A   2       8.719  -9.178   0.736  1.00  0.00           H  
ATOM     33  HG2 GLN A   2       8.422 -11.652   0.835  1.00  0.00           H  
ATOM     34  HG3 GLN A   2       7.346 -11.550  -0.560  1.00  0.00           H  
ATOM     35 HE21 GLN A   2       8.332 -10.746  -2.626  1.00  0.00           H  
ATOM     36 HE22 GLN A   2      10.001 -10.921  -2.877  1.00  0.00           H  
ATOM     37  N   TYR A   3       4.928  -8.003   1.080  1.00  0.00           N  
ATOM     38  CA  TYR A   3       3.725  -7.429   0.488  1.00  0.00           C  
ATOM     39  C   TYR A   3       4.151  -6.217  -0.322  1.00  0.00           C  
ATOM     40  O   TYR A   3       5.148  -5.573   0.004  1.00  0.00           O  
ATOM     41  CB  TYR A   3       2.726  -7.007   1.571  1.00  0.00           C  
ATOM     42  CG  TYR A   3       2.193  -8.211   2.310  1.00  0.00           C  
ATOM     43  CD1 TYR A   3       2.886  -8.709   3.421  1.00  0.00           C  
ATOM     44  CD2 TYR A   3       0.999  -8.821   1.899  1.00  0.00           C  
ATOM     45  CE1 TYR A   3       2.387  -9.814   4.122  1.00  0.00           C  
ATOM     46  CE2 TYR A   3       0.503  -9.930   2.596  1.00  0.00           C  
ATOM     47  CZ  TYR A   3       1.197 -10.425   3.707  1.00  0.00           C  
ATOM     48  OH  TYR A   3       0.700 -11.508   4.399  1.00  0.00           O  
ATOM     49  H   TYR A   3       5.485  -7.471   1.686  1.00  0.00           H  
ATOM     50  HA  TYR A   3       3.259  -8.136  -0.184  1.00  0.00           H  
ATOM     51  HB2 TYR A   3       3.218  -6.349   2.272  1.00  0.00           H  
ATOM     52  HB3 TYR A   3       1.904  -6.480   1.108  1.00  0.00           H  
ATOM     53  HD1 TYR A   3       3.806  -8.238   3.738  1.00  0.00           H  
ATOM     54  HD2 TYR A   3       0.464  -8.438   1.042  1.00  0.00           H  
ATOM     55  HE1 TYR A   3       2.922 -10.197   4.978  1.00  0.00           H  
ATOM     56  HE2 TYR A   3      -0.415 -10.402   2.277  1.00  0.00           H  
ATOM     57  HH  TYR A   3       0.460 -12.184   3.760  1.00  0.00           H  
ATOM     58  N   LYS A   4       3.394  -5.912  -1.352  1.00  0.00           N  
ATOM     59  CA  LYS A   4       3.698  -4.801  -2.242  1.00  0.00           C  
ATOM     60  C   LYS A   4       2.548  -3.802  -2.207  1.00  0.00           C  
ATOM     61  O   LYS A   4       1.382  -4.185  -2.129  1.00  0.00           O  
ATOM     62  CB  LYS A   4       3.876  -5.331  -3.668  1.00  0.00           C  
ATOM     63  CG  LYS A   4       4.151  -4.205  -4.664  1.00  0.00           C  
ATOM     64  CD  LYS A   4       4.495  -4.812  -6.027  1.00  0.00           C  
ATOM     65  CE  LYS A   4       5.925  -5.358  -6.016  1.00  0.00           C  
ATOM     66  NZ  LYS A   4       6.243  -5.924  -7.358  1.00  0.00           N  
ATOM     67  H   LYS A   4       2.615  -6.454  -1.598  1.00  0.00           H  
ATOM     68  HA  LYS A   4       4.616  -4.339  -1.913  1.00  0.00           H  
ATOM     69  HB2 LYS A   4       4.701  -6.025  -3.677  1.00  0.00           H  
ATOM     70  HB3 LYS A   4       2.977  -5.850  -3.962  1.00  0.00           H  
ATOM     71  HG2 LYS A   4       3.274  -3.582  -4.756  1.00  0.00           H  
ATOM     72  HG3 LYS A   4       4.982  -3.609  -4.316  1.00  0.00           H  
ATOM     73  HD2 LYS A   4       3.805  -5.615  -6.248  1.00  0.00           H  
ATOM     74  HD3 LYS A   4       4.411  -4.051  -6.788  1.00  0.00           H  
ATOM     75  HE2 LYS A   4       6.615  -4.560  -5.790  1.00  0.00           H  
ATOM     76  HE3 LYS A   4       6.017  -6.136  -5.273  1.00  0.00           H  
ATOM     77  HZ1 LYS A   4       7.251  -6.175  -7.400  1.00  0.00           H  
ATOM     78  HZ2 LYS A   4       6.031  -5.217  -8.091  1.00  0.00           H  
ATOM     79  HZ3 LYS A   4       5.669  -6.776  -7.521  1.00  0.00           H  
ATOM     80  N   LEU A   5       2.904  -2.537  -2.330  1.00  0.00           N  
ATOM     81  CA  LEU A   5       1.925  -1.458  -2.415  1.00  0.00           C  
ATOM     82  C   LEU A   5       2.169  -0.747  -3.739  1.00  0.00           C  
ATOM     83  O   LEU A   5       3.275  -0.269  -4.009  1.00  0.00           O  
ATOM     84  CB  LEU A   5       2.077  -0.457  -1.260  1.00  0.00           C  
ATOM     85  CG  LEU A   5       1.126   0.739  -1.429  1.00  0.00           C  
ATOM     86  CD1 LEU A   5      -0.336   0.298  -1.301  1.00  0.00           C  
ATOM     87  CD2 LEU A   5       1.432   1.784  -0.350  1.00  0.00           C  
ATOM     88  H   LEU A   5       3.858  -2.312  -2.332  1.00  0.00           H  
ATOM     89  HA  LEU A   5       0.923  -1.869  -2.408  1.00  0.00           H  
ATOM     90  HB2 LEU A   5       1.857  -0.956  -0.328  1.00  0.00           H  
ATOM     91  HB3 LEU A   5       3.096  -0.099  -1.236  1.00  0.00           H  
ATOM     92  HG  LEU A   5       1.276   1.180  -2.401  1.00  0.00           H  
ATOM     93 HD11 LEU A   5      -0.958   1.159  -1.099  1.00  0.00           H  
ATOM     94 HD12 LEU A   5      -0.431  -0.411  -0.491  1.00  0.00           H  
ATOM     95 HD13 LEU A   5      -0.655  -0.166  -2.223  1.00  0.00           H  
ATOM     96 HD21 LEU A   5       1.133   1.401   0.615  1.00  0.00           H  
ATOM     97 HD22 LEU A   5       0.885   2.691  -0.562  1.00  0.00           H  
ATOM     98 HD23 LEU A   5       2.490   1.995  -0.341  1.00  0.00           H  
ATOM     99  N   VAL A   6       1.132  -0.634  -4.539  1.00  0.00           N  
ATOM    100  CA  VAL A   6       1.151   0.054  -5.817  1.00  0.00           C  
ATOM    101  C   VAL A   6       0.368   1.333  -5.557  1.00  0.00           C  
ATOM    102  O   VAL A   6      -0.775   1.279  -5.108  1.00  0.00           O  
ATOM    103  CB  VAL A   6       0.487  -0.803  -6.920  1.00  0.00           C  
ATOM    104  CG1 VAL A   6       0.372  -0.029  -8.233  1.00  0.00           C  
ATOM    105  CG2 VAL A   6       1.290  -2.092  -7.136  1.00  0.00           C  
ATOM    106  H   VAL A   6       0.270  -1.039  -4.304  1.00  0.00           H  
ATOM    107  HA  VAL A   6       2.167   0.314  -6.088  1.00  0.00           H  
ATOM    108  HB  VAL A   6      -0.507  -1.067  -6.591  1.00  0.00           H  
ATOM    109 HG11 VAL A   6       1.314   0.453  -8.450  1.00  0.00           H  
ATOM    110 HG12 VAL A   6      -0.402   0.718  -8.144  1.00  0.00           H  
ATOM    111 HG13 VAL A   6       0.123  -0.711  -9.033  1.00  0.00           H  
ATOM    112 HG21 VAL A   6       2.163  -1.876  -7.733  1.00  0.00           H  
ATOM    113 HG22 VAL A   6       0.674  -2.816  -7.649  1.00  0.00           H  
ATOM    114 HG23 VAL A   6       1.596  -2.491  -6.181  1.00  0.00           H  
ATOM    115  N   ILE A   7       1.017   2.465  -5.767  1.00  0.00           N  
ATOM    116  CA  ILE A   7       0.405   3.770  -5.498  1.00  0.00           C  
ATOM    117  C   ILE A   7       0.114   4.506  -6.801  1.00  0.00           C  
ATOM    118  O   ILE A   7       1.023   4.900  -7.530  1.00  0.00           O  
ATOM    119  CB  ILE A   7       1.342   4.668  -4.667  1.00  0.00           C  
ATOM    120  CG1 ILE A   7       1.873   3.891  -3.455  1.00  0.00           C  
ATOM    121  CG2 ILE A   7       0.581   5.911  -4.196  1.00  0.00           C  
ATOM    122  CD1 ILE A   7       3.364   4.181  -3.258  1.00  0.00           C  
ATOM    123  H   ILE A   7       1.928   2.457  -6.127  1.00  0.00           H  
ATOM    124  HA  ILE A   7      -0.505   3.607  -4.942  1.00  0.00           H  
ATOM    125  HB  ILE A   7       2.170   4.980  -5.289  1.00  0.00           H  
ATOM    126 HG12 ILE A   7       1.333   4.183  -2.566  1.00  0.00           H  
ATOM    127 HG13 ILE A   7       1.743   2.833  -3.618  1.00  0.00           H  
ATOM    128 HG21 ILE A   7      -0.276   5.609  -3.613  1.00  0.00           H  
ATOM    129 HG22 ILE A   7       0.251   6.479  -5.054  1.00  0.00           H  
ATOM    130 HG23 ILE A   7       1.231   6.522  -3.589  1.00  0.00           H  
ATOM    131 HD11 ILE A   7       3.735   3.614  -2.418  1.00  0.00           H  
ATOM    132 HD12 ILE A   7       3.504   5.236  -3.072  1.00  0.00           H  
ATOM    133 HD13 ILE A   7       3.907   3.898  -4.149  1.00  0.00           H  
ATOM    134  N   ASN A   8      -1.168   4.706  -7.025  1.00  0.00           N  
ATOM    135  CA  ASN A   8      -1.600   5.469  -8.190  1.00  0.00           C  
ATOM    136  C   ASN A   8      -2.232   6.792  -7.747  1.00  0.00           C  
ATOM    137  O   ASN A   8      -3.453   6.953  -7.774  1.00  0.00           O  
ATOM    138  CB  ASN A   8      -2.612   4.672  -9.017  1.00  0.00           C  
ATOM    139  CG  ASN A   8      -1.926   3.474  -9.677  1.00  0.00           C  
ATOM    140  OD1 ASN A   8      -2.415   2.362  -9.596  1.00  0.00           O  
ATOM    141  ND2 ASN A   8      -0.809   3.663 -10.327  1.00  0.00           N  
ATOM    142  H   ASN A   8      -1.828   4.419  -6.359  1.00  0.00           H  
ATOM    143  HA  ASN A   8      -0.733   5.681  -8.799  1.00  0.00           H  
ATOM    144  HB2 ASN A   8      -3.403   4.321  -8.371  1.00  0.00           H  
ATOM    145  HB3 ASN A   8      -3.030   5.309  -9.782  1.00  0.00           H  
ATOM    146 HD21 ASN A   8      -0.423   4.561 -10.386  1.00  0.00           H  
ATOM    147 HD22 ASN A   8      -0.358   2.906 -10.755  1.00  0.00           H  
ATOM    148  N   GLY A   9      -1.390   7.679  -7.237  1.00  0.00           N  
ATOM    149  CA  GLY A   9      -1.830   8.954  -6.691  1.00  0.00           C  
ATOM    150  C   GLY A   9      -1.870  10.039  -7.747  1.00  0.00           C  
ATOM    151  O   GLY A   9      -1.387   9.852  -8.863  1.00  0.00           O  
ATOM    152  H   GLY A   9      -0.420   7.549  -7.300  1.00  0.00           H  
ATOM    153  HA2 GLY A   9      -2.816   8.836  -6.269  1.00  0.00           H  
ATOM    154  HA3 GLY A   9      -1.149   9.253  -5.909  1.00  0.00           H  
ATOM    155  N   LYS A  10      -2.442  11.171  -7.389  1.00  0.00           N  
ATOM    156  CA  LYS A  10      -2.543  12.315  -8.286  1.00  0.00           C  
ATOM    157  C   LYS A  10      -1.151  12.843  -8.614  1.00  0.00           C  
ATOM    158  O   LYS A  10      -0.871  13.296  -9.724  1.00  0.00           O  
ATOM    159  CB  LYS A  10      -3.298  13.463  -7.600  1.00  0.00           C  
ATOM    160  CG  LYS A  10      -4.819  13.251  -7.625  1.00  0.00           C  
ATOM    161  CD  LYS A  10      -5.455  13.847  -6.355  1.00  0.00           C  
ATOM    162  CE  LYS A  10      -6.421  14.986  -6.694  1.00  0.00           C  
ATOM    163  NZ  LYS A  10      -6.930  15.590  -5.428  1.00  0.00           N  
ATOM    164  H   LYS A  10      -2.813  11.247  -6.485  1.00  0.00           H  
ATOM    165  HA  LYS A  10      -3.061  12.037  -9.190  1.00  0.00           H  
ATOM    166  HB2 LYS A  10      -2.959  13.527  -6.577  1.00  0.00           H  
ATOM    167  HB3 LYS A  10      -3.064  14.391  -8.103  1.00  0.00           H  
ATOM    168  HG2 LYS A  10      -5.232  13.731  -8.499  1.00  0.00           H  
ATOM    169  HG3 LYS A  10      -5.031  12.192  -7.668  1.00  0.00           H  
ATOM    170  HD2 LYS A  10      -6.001  13.074  -5.835  1.00  0.00           H  
ATOM    171  HD3 LYS A  10      -4.685  14.228  -5.700  1.00  0.00           H  
ATOM    172  HE2 LYS A  10      -5.903  15.737  -7.272  1.00  0.00           H  
ATOM    173  HE3 LYS A  10      -7.250  14.597  -7.267  1.00  0.00           H  
ATOM    174  HZ1 LYS A  10      -7.920  15.882  -5.557  1.00  0.00           H  
ATOM    175  HZ2 LYS A  10      -6.351  16.420  -5.184  1.00  0.00           H  
ATOM    176  HZ3 LYS A  10      -6.874  14.891  -4.661  1.00  0.00           H  
ATOM    177  N   THR A  11      -0.336  12.876  -7.586  1.00  0.00           N  
ATOM    178  CA  THR A  11       0.975  13.487  -7.676  1.00  0.00           C  
ATOM    179  C   THR A  11       2.099  12.481  -7.384  1.00  0.00           C  
ATOM    180  O   THR A  11       3.195  12.578  -7.949  1.00  0.00           O  
ATOM    181  CB  THR A  11       0.976  14.742  -6.776  1.00  0.00           C  
ATOM    182  OG1 THR A  11       0.946  15.880  -7.625  1.00  0.00           O  
ATOM    183  CG2 THR A  11       2.120  14.806  -5.764  1.00  0.00           C  
ATOM    184  H   THR A  11      -0.621  12.478  -6.737  1.00  0.00           H  
ATOM    185  HA  THR A  11       1.113  13.798  -8.700  1.00  0.00           H  
ATOM    186  HB  THR A  11       0.047  14.738  -6.222  1.00  0.00           H  
ATOM    187  HG1 THR A  11       0.079  16.284  -7.547  1.00  0.00           H  
ATOM    188 HG21 THR A  11       2.013  14.002  -5.050  1.00  0.00           H  
ATOM    189 HG22 THR A  11       2.090  15.753  -5.247  1.00  0.00           H  
ATOM    190 HG23 THR A  11       3.063  14.705  -6.279  1.00  0.00           H  
ATOM    191  N   LEU A  12       1.814  11.499  -6.547  1.00  0.00           N  
ATOM    192  CA  LEU A  12       2.797  10.473  -6.199  1.00  0.00           C  
ATOM    193  C   LEU A  12       2.428   9.135  -6.840  1.00  0.00           C  
ATOM    194  O   LEU A  12       1.291   8.690  -6.698  1.00  0.00           O  
ATOM    195  CB  LEU A  12       2.886  10.413  -4.665  1.00  0.00           C  
ATOM    196  CG  LEU A  12       3.596   9.172  -4.118  1.00  0.00           C  
ATOM    197  CD1 LEU A  12       5.085   9.259  -4.449  1.00  0.00           C  
ATOM    198  CD2 LEU A  12       3.426   9.139  -2.595  1.00  0.00           C  
ATOM    199  H   LEU A  12       0.930  11.347  -6.150  1.00  0.00           H  
ATOM    200  HA  LEU A  12       3.737  10.780  -6.624  1.00  0.00           H  
ATOM    201  HB2 LEU A  12       3.414  11.288  -4.317  1.00  0.00           H  
ATOM    202  HB3 LEU A  12       1.882  10.441  -4.267  1.00  0.00           H  
ATOM    203  HG  LEU A  12       3.174   8.279  -4.554  1.00  0.00           H  
ATOM    204 HD11 LEU A  12       5.480  10.200  -4.093  1.00  0.00           H  
ATOM    205 HD12 LEU A  12       5.222   9.193  -5.518  1.00  0.00           H  
ATOM    206 HD13 LEU A  12       5.608   8.446  -3.968  1.00  0.00           H  
ATOM    207 HD21 LEU A  12       2.374   9.128  -2.350  1.00  0.00           H  
ATOM    208 HD22 LEU A  12       3.887  10.015  -2.162  1.00  0.00           H  
ATOM    209 HD23 LEU A  12       3.898   8.252  -2.199  1.00  0.00           H  
ATOM    210  N   LYS A  13       3.332   8.530  -7.592  1.00  0.00           N  
ATOM    211  CA  LYS A  13       3.028   7.276  -8.286  1.00  0.00           C  
ATOM    212  C   LYS A  13       4.217   6.339  -8.195  1.00  0.00           C  
ATOM    213  O   LYS A  13       5.352   6.795  -8.341  1.00  0.00           O  
ATOM    214  CB  LYS A  13       2.771   7.531  -9.766  1.00  0.00           C  
ATOM    215  CG  LYS A  13       1.617   8.513  -9.950  1.00  0.00           C  
ATOM    216  CD  LYS A  13       1.339   8.626 -11.447  1.00  0.00           C  
ATOM    217  CE  LYS A  13       0.324   9.732 -11.722  1.00  0.00           C  
ATOM    218  NZ  LYS A  13       0.299   9.990 -13.190  1.00  0.00           N  
ATOM    219  H   LYS A  13       4.150   9.002  -7.856  1.00  0.00           H  
ATOM    220  HA  LYS A  13       2.141   6.860  -7.836  1.00  0.00           H  
ATOM    221  HB2 LYS A  13       3.663   7.942 -10.216  1.00  0.00           H  
ATOM    222  HB3 LYS A  13       2.525   6.598 -10.251  1.00  0.00           H  
ATOM    223  HG2 LYS A  13       0.739   8.144  -9.439  1.00  0.00           H  
ATOM    224  HG3 LYS A  13       1.892   9.480  -9.558  1.00  0.00           H  
ATOM    225  HD2 LYS A  13       2.260   8.853 -11.965  1.00  0.00           H  
ATOM    226  HD3 LYS A  13       0.948   7.687 -11.810  1.00  0.00           H  
ATOM    227  HE2 LYS A  13      -0.655   9.419 -11.390  1.00  0.00           H  
ATOM    228  HE3 LYS A  13       0.615  10.633 -11.202  1.00  0.00           H  
ATOM    229  HZ1 LYS A  13       0.382  11.012 -13.365  1.00  0.00           H  
ATOM    230  HZ2 LYS A  13      -0.596   9.641 -13.588  1.00  0.00           H  
ATOM    231  HZ3 LYS A  13       1.095   9.498 -13.641  1.00  0.00           H  
ATOM    232  N   GLY A  14       4.036   5.061  -7.958  1.00  0.00           N  
ATOM    233  CA  GLY A  14       5.135   4.127  -7.927  1.00  0.00           C  
ATOM    234  C   GLY A  14       4.744   2.870  -7.194  1.00  0.00           C  
ATOM    235  O   GLY A  14       3.571   2.491  -7.127  1.00  0.00           O  
ATOM    236  H   GLY A  14       3.130   4.722  -7.805  1.00  0.00           H  
ATOM    237  HA2 GLY A  14       5.416   3.875  -8.940  1.00  0.00           H  
ATOM    238  HA3 GLY A  14       5.977   4.582  -7.428  1.00  0.00           H  
ATOM    239  N   GLU A  15       5.750   2.274  -6.589  1.00  0.00           N  
ATOM    240  CA  GLU A  15       5.571   1.083  -5.778  1.00  0.00           C  
ATOM    241  C   GLU A  15       6.535   1.058  -4.594  1.00  0.00           C  
ATOM    242  O   GLU A  15       7.630   1.620  -4.676  1.00  0.00           O  
ATOM    243  CB  GLU A  15       5.945  -0.181  -6.568  1.00  0.00           C  
ATOM    244  CG  GLU A  15       5.022  -0.439  -7.758  1.00  0.00           C  
ATOM    245  CD  GLU A  15       5.400  -1.772  -8.421  1.00  0.00           C  
ATOM    246  OE1 GLU A  15       6.445  -2.310  -8.091  1.00  0.00           O  
ATOM    247  OE2 GLU A  15       4.635  -2.235  -9.251  1.00  0.00           O  
ATOM    248  H   GLU A  15       6.650   2.647  -6.691  1.00  0.00           H  
ATOM    249  HA  GLU A  15       4.550   0.997  -5.448  1.00  0.00           H  
ATOM    250  HB2 GLU A  15       6.956  -0.078  -6.930  1.00  0.00           H  
ATOM    251  HB3 GLU A  15       5.897  -1.033  -5.907  1.00  0.00           H  
ATOM    252  HG2 GLU A  15       3.998  -0.482  -7.417  1.00  0.00           H  
ATOM    253  HG3 GLU A  15       5.129   0.360  -8.477  1.00  0.00           H  
ATOM    254  N   THR A  16       6.136   0.373  -3.543  1.00  0.00           N  
ATOM    255  CA  THR A  16       6.983   0.193  -2.369  1.00  0.00           C  
ATOM    256  C   THR A  16       6.613  -1.166  -1.784  1.00  0.00           C  
ATOM    257  O   THR A  16       5.673  -1.810  -2.255  1.00  0.00           O  
ATOM    258  CB  THR A  16       6.820   1.344  -1.347  1.00  0.00           C  
ATOM    259  OG1 THR A  16       7.800   1.166  -0.332  1.00  0.00           O  
ATOM    260  CG2 THR A  16       5.423   1.394  -0.726  1.00  0.00           C  
ATOM    261  H   THR A  16       5.252  -0.049  -3.541  1.00  0.00           H  
ATOM    262  HA  THR A  16       8.010   0.175  -2.718  1.00  0.00           H  
ATOM    263  HB  THR A  16       7.013   2.282  -1.852  1.00  0.00           H  
ATOM    264  HG1 THR A  16       8.660   1.121  -0.754  1.00  0.00           H  
ATOM    265 HG21 THR A  16       5.390   2.170   0.025  1.00  0.00           H  
ATOM    266 HG22 THR A  16       5.198   0.441  -0.269  1.00  0.00           H  
ATOM    267 HG23 THR A  16       4.695   1.606  -1.494  1.00  0.00           H  
ATOM    268  N   THR A  17       7.386  -1.637  -0.825  1.00  0.00           N  
ATOM    269  CA  THR A  17       7.139  -2.956  -0.235  1.00  0.00           C  
ATOM    270  C   THR A  17       7.313  -2.911   1.280  1.00  0.00           C  
ATOM    271  O   THR A  17       7.942  -2.007   1.832  1.00  0.00           O  
ATOM    272  CB  THR A  17       8.129  -4.006  -0.763  1.00  0.00           C  
ATOM    273  OG1 THR A  17       9.434  -3.628  -0.340  1.00  0.00           O  
ATOM    274  CG2 THR A  17       8.090  -4.104  -2.291  1.00  0.00           C  
ATOM    275  H   THR A  17       8.115  -1.093  -0.463  1.00  0.00           H  
ATOM    276  HA  THR A  17       6.129  -3.259  -0.458  1.00  0.00           H  
ATOM    277  HB  THR A  17       7.883  -4.968  -0.337  1.00  0.00           H  
ATOM    278  HG1 THR A  17       9.349  -2.864   0.236  1.00  0.00           H  
ATOM    279 HG21 THR A  17       7.065  -4.197  -2.619  1.00  0.00           H  
ATOM    280 HG22 THR A  17       8.651  -4.969  -2.611  1.00  0.00           H  
ATOM    281 HG23 THR A  17       8.526  -3.214  -2.720  1.00  0.00           H  
ATOM    282  N   THR A  18       6.804  -3.942   1.922  1.00  0.00           N  
ATOM    283  CA  THR A  18       6.962  -4.099   3.363  1.00  0.00           C  
ATOM    284  C   THR A  18       6.894  -5.587   3.685  1.00  0.00           C  
ATOM    285  O   THR A  18       6.288  -6.350   2.931  1.00  0.00           O  
ATOM    286  CB  THR A  18       5.886  -3.304   4.145  1.00  0.00           C  
ATOM    287  OG1 THR A  18       6.332  -3.122   5.484  1.00  0.00           O  
ATOM    288  CG2 THR A  18       4.537  -4.032   4.148  1.00  0.00           C  
ATOM    289  H   THR A  18       6.287  -4.628   1.452  1.00  0.00           H  
ATOM    290  HA  THR A  18       7.942  -3.721   3.623  1.00  0.00           H  
ATOM    291  HB  THR A  18       5.762  -2.336   3.683  1.00  0.00           H  
ATOM    292  HG1 THR A  18       7.206  -3.513   5.561  1.00  0.00           H  
ATOM    293 HG21 THR A  18       4.560  -4.826   4.880  1.00  0.00           H  
ATOM    294 HG22 THR A  18       4.350  -4.450   3.170  1.00  0.00           H  
ATOM    295 HG23 THR A  18       3.751  -3.335   4.399  1.00  0.00           H  
ATOM    296  N   LYS A  19       7.509  -6.000   4.782  1.00  0.00           N  
ATOM    297  CA  LYS A  19       7.463  -7.405   5.190  1.00  0.00           C  
ATOM    298  C   LYS A  19       6.565  -7.499   6.417  1.00  0.00           C  
ATOM    299  O   LYS A  19       6.679  -6.671   7.320  1.00  0.00           O  
ATOM    300  CB  LYS A  19       8.850  -7.941   5.579  1.00  0.00           C  
ATOM    301  CG  LYS A  19      10.021  -7.306   4.815  1.00  0.00           C  
ATOM    302  CD  LYS A  19      10.403  -8.149   3.592  1.00  0.00           C  
ATOM    303  CE  LYS A  19      10.633  -9.619   3.971  1.00  0.00           C  
ATOM    304  NZ  LYS A  19      11.974 -10.065   3.502  1.00  0.00           N  
ATOM    305  H   LYS A  19       8.026  -5.349   5.301  1.00  0.00           H  
ATOM    306  HA  LYS A  19       7.037  -8.019   4.408  1.00  0.00           H  
ATOM    307  HB2 LYS A  19       9.002  -7.756   6.634  1.00  0.00           H  
ATOM    308  HB3 LYS A  19       8.848  -9.007   5.422  1.00  0.00           H  
ATOM    309  HG2 LYS A  19       9.744  -6.315   4.487  1.00  0.00           H  
ATOM    310  HG3 LYS A  19      10.876  -7.232   5.470  1.00  0.00           H  
ATOM    311  HD2 LYS A  19       9.609  -8.089   2.862  1.00  0.00           H  
ATOM    312  HD3 LYS A  19      11.308  -7.750   3.160  1.00  0.00           H  
ATOM    313  HE2 LYS A  19      10.597  -9.733   5.045  1.00  0.00           H  
ATOM    314  HE3 LYS A  19       9.872 -10.236   3.518  1.00  0.00           H  
ATOM    315  HZ1 LYS A  19      12.712  -9.541   4.012  1.00  0.00           H  
ATOM    316  HZ2 LYS A  19      12.061  -9.883   2.482  1.00  0.00           H  
ATOM    317  HZ3 LYS A  19      12.085 -11.082   3.685  1.00  0.00           H  
ATOM    318  N   ALA A  20       5.692  -8.487   6.466  1.00  0.00           N  
ATOM    319  CA  ALA A  20       4.821  -8.659   7.627  1.00  0.00           C  
ATOM    320  C   ALA A  20       4.405 -10.120   7.778  1.00  0.00           C  
ATOM    321  O   ALA A  20       4.475 -10.907   6.833  1.00  0.00           O  
ATOM    322  CB  ALA A  20       3.583  -7.790   7.483  1.00  0.00           C  
ATOM    323  H   ALA A  20       5.661  -9.151   5.746  1.00  0.00           H  
ATOM    324  HA  ALA A  20       5.348  -8.376   8.525  1.00  0.00           H  
ATOM    325  HB1 ALA A  20       3.879  -6.766   7.314  1.00  0.00           H  
ATOM    326  HB2 ALA A  20       2.995  -7.852   8.385  1.00  0.00           H  
ATOM    327  HB3 ALA A  20       2.997  -8.138   6.645  1.00  0.00           H  
ATOM    328  N   VAL A  21       3.979 -10.469   8.979  1.00  0.00           N  
ATOM    329  CA  VAL A  21       3.562 -11.842   9.250  1.00  0.00           C  
ATOM    330  C   VAL A  21       2.170 -12.141   8.696  1.00  0.00           C  
ATOM    331  O   VAL A  21       1.849 -13.297   8.432  1.00  0.00           O  
ATOM    332  CB  VAL A  21       3.548 -12.155  10.763  1.00  0.00           C  
ATOM    333  CG1 VAL A  21       4.979 -12.127  11.307  1.00  0.00           C  
ATOM    334  CG2 VAL A  21       2.665 -11.177  11.534  1.00  0.00           C  
ATOM    335  H   VAL A  21       4.096  -9.842   9.722  1.00  0.00           H  
ATOM    336  HA  VAL A  21       4.249 -12.536   8.788  1.00  0.00           H  
ATOM    337  HB  VAL A  21       3.157 -13.154  10.896  1.00  0.00           H  
ATOM    338 HG11 VAL A  21       4.963 -12.296  12.373  1.00  0.00           H  
ATOM    339 HG12 VAL A  21       5.424 -11.165  11.102  1.00  0.00           H  
ATOM    340 HG13 VAL A  21       5.561 -12.902  10.828  1.00  0.00           H  
ATOM    341 HG21 VAL A  21       2.679 -11.430  12.584  1.00  0.00           H  
ATOM    342 HG22 VAL A  21       1.653 -11.237  11.163  1.00  0.00           H  
ATOM    343 HG23 VAL A  21       3.038 -10.173  11.401  1.00  0.00           H  
ATOM    344  N   ASP A  22       1.344 -11.123   8.519  1.00  0.00           N  
ATOM    345  CA  ASP A  22       0.002 -11.311   7.969  1.00  0.00           C  
ATOM    346  C   ASP A  22      -0.443 -10.053   7.227  1.00  0.00           C  
ATOM    347  O   ASP A  22       0.207  -9.009   7.289  1.00  0.00           O  
ATOM    348  CB  ASP A  22      -0.989 -11.722   9.064  1.00  0.00           C  
ATOM    349  CG  ASP A  22      -1.092 -10.665  10.167  1.00  0.00           C  
ATOM    350  OD1 ASP A  22      -1.016  -9.489   9.856  1.00  0.00           O  
ATOM    351  OD2 ASP A  22      -1.264 -11.051  11.313  1.00  0.00           O  
ATOM    352  H   ASP A  22       1.659 -10.206   8.661  1.00  0.00           H  
ATOM    353  HA  ASP A  22       0.033 -12.081   7.213  1.00  0.00           H  
ATOM    354  HB2 ASP A  22      -1.965 -11.861   8.622  1.00  0.00           H  
ATOM    355  HB3 ASP A  22      -0.664 -12.655   9.500  1.00  0.00           H  
ATOM    356  N   ALA A  23      -1.529 -10.193   6.489  1.00  0.00           N  
ATOM    357  CA  ALA A  23      -2.031  -9.093   5.670  1.00  0.00           C  
ATOM    358  C   ALA A  23      -2.541  -7.919   6.500  1.00  0.00           C  
ATOM    359  O   ALA A  23      -2.387  -6.772   6.080  1.00  0.00           O  
ATOM    360  CB  ALA A  23      -3.112  -9.589   4.722  1.00  0.00           C  
ATOM    361  H   ALA A  23      -1.978 -11.061   6.416  1.00  0.00           H  
ATOM    362  HA  ALA A  23      -1.211  -8.703   5.090  1.00  0.00           H  
ATOM    363  HB1 ALA A  23      -3.965  -9.926   5.293  1.00  0.00           H  
ATOM    364  HB2 ALA A  23      -2.726 -10.408   4.134  1.00  0.00           H  
ATOM    365  HB3 ALA A  23      -3.413  -8.786   4.066  1.00  0.00           H  
ATOM    366  N   GLU A  24      -3.161  -8.175   7.636  1.00  0.00           N  
ATOM    367  CA  GLU A  24      -3.687  -7.068   8.430  1.00  0.00           C  
ATOM    368  C   GLU A  24      -2.547  -6.210   8.979  1.00  0.00           C  
ATOM    369  O   GLU A  24      -2.672  -4.986   9.035  1.00  0.00           O  
ATOM    370  CB  GLU A  24      -4.677  -7.586   9.493  1.00  0.00           C  
ATOM    371  CG  GLU A  24      -4.115  -7.701  10.914  1.00  0.00           C  
ATOM    372  CD  GLU A  24      -5.265  -7.897  11.917  1.00  0.00           C  
ATOM    373  OE1 GLU A  24      -5.799  -6.905  12.397  1.00  0.00           O  
ATOM    374  OE2 GLU A  24      -5.583  -9.042  12.196  1.00  0.00           O  
ATOM    375  H   GLU A  24      -3.268  -9.099   7.945  1.00  0.00           H  
ATOM    376  HA  GLU A  24      -4.222  -6.433   7.737  1.00  0.00           H  
ATOM    377  HB2 GLU A  24      -5.528  -6.922   9.518  1.00  0.00           H  
ATOM    378  HB3 GLU A  24      -5.020  -8.563   9.187  1.00  0.00           H  
ATOM    379  HG2 GLU A  24      -3.443  -8.544  10.968  1.00  0.00           H  
ATOM    380  HG3 GLU A  24      -3.578  -6.798  11.166  1.00  0.00           H  
ATOM    381  N   THR A  25      -1.428  -6.818   9.324  1.00  0.00           N  
ATOM    382  CA  THR A  25      -0.286  -6.049   9.814  1.00  0.00           C  
ATOM    383  C   THR A  25       0.299  -5.212   8.679  1.00  0.00           C  
ATOM    384  O   THR A  25       0.682  -4.059   8.886  1.00  0.00           O  
ATOM    385  CB  THR A  25       0.806  -6.969  10.397  1.00  0.00           C  
ATOM    386  OG1 THR A  25       0.254  -7.681  11.497  1.00  0.00           O  
ATOM    387  CG2 THR A  25       2.012  -6.145  10.863  1.00  0.00           C  
ATOM    388  H   THR A  25      -1.362  -7.794   9.251  1.00  0.00           H  
ATOM    389  HA  THR A  25      -0.634  -5.379  10.587  1.00  0.00           H  
ATOM    390  HB  THR A  25       1.122  -7.673   9.641  1.00  0.00           H  
ATOM    391  HG1 THR A  25       0.738  -8.506  11.589  1.00  0.00           H  
ATOM    392 HG21 THR A  25       2.525  -6.674  11.653  1.00  0.00           H  
ATOM    393 HG22 THR A  25       1.676  -5.187  11.233  1.00  0.00           H  
ATOM    394 HG23 THR A  25       2.689  -5.992  10.034  1.00  0.00           H  
ATOM    395  N   ALA A  26       0.342  -5.779   7.488  1.00  0.00           N  
ATOM    396  CA  ALA A  26       0.860  -5.046   6.339  1.00  0.00           C  
ATOM    397  C   ALA A  26      -0.071  -3.880   6.018  1.00  0.00           C  
ATOM    398  O   ALA A  26       0.391  -2.780   5.712  1.00  0.00           O  
ATOM    399  CB  ALA A  26       0.987  -5.965   5.131  1.00  0.00           C  
ATOM    400  H   ALA A  26       0.023  -6.699   7.375  1.00  0.00           H  
ATOM    401  HA  ALA A  26       1.832  -4.652   6.591  1.00  0.00           H  
ATOM    402  HB1 ALA A  26       1.518  -6.860   5.412  1.00  0.00           H  
ATOM    403  HB2 ALA A  26       1.529  -5.455   4.348  1.00  0.00           H  
ATOM    404  HB3 ALA A  26       0.002  -6.228   4.773  1.00  0.00           H  
ATOM    405  N   GLU A  27      -1.371  -4.110   6.101  1.00  0.00           N  
ATOM    406  CA  GLU A  27      -2.341  -3.052   5.818  1.00  0.00           C  
ATOM    407  C   GLU A  27      -2.126  -1.856   6.742  1.00  0.00           C  
ATOM    408  O   GLU A  27      -2.143  -0.714   6.281  1.00  0.00           O  
ATOM    409  CB  GLU A  27      -3.775  -3.572   5.950  1.00  0.00           C  
ATOM    410  CG  GLU A  27      -4.769  -2.444   5.653  1.00  0.00           C  
ATOM    411  CD  GLU A  27      -6.193  -2.933   5.916  1.00  0.00           C  
ATOM    412  OE1 GLU A  27      -6.544  -3.947   5.336  1.00  0.00           O  
ATOM    413  OE2 GLU A  27      -6.898  -2.296   6.686  1.00  0.00           O  
ATOM    414  H   GLU A  27      -1.688  -5.002   6.354  1.00  0.00           H  
ATOM    415  HA  GLU A  27      -2.178  -2.688   4.816  1.00  0.00           H  
ATOM    416  HB2 GLU A  27      -3.928  -4.379   5.250  1.00  0.00           H  
ATOM    417  HB3 GLU A  27      -3.932  -3.935   6.955  1.00  0.00           H  
ATOM    418  HG2 GLU A  27      -4.561  -1.602   6.295  1.00  0.00           H  
ATOM    419  HG3 GLU A  27      -4.678  -2.143   4.620  1.00  0.00           H  
ATOM    420  N   LYS A  28      -1.936  -2.101   8.025  1.00  0.00           N  
ATOM    421  CA  LYS A  28      -1.723  -1.006   8.969  1.00  0.00           C  
ATOM    422  C   LYS A  28      -0.464  -0.226   8.600  1.00  0.00           C  
ATOM    423  O   LYS A  28      -0.481   1.005   8.630  1.00  0.00           O  
ATOM    424  CB  LYS A  28      -1.598  -1.532  10.407  1.00  0.00           C  
ATOM    425  CG  LYS A  28      -2.973  -1.805  11.020  1.00  0.00           C  
ATOM    426  CD  LYS A  28      -2.817  -2.582  12.334  1.00  0.00           C  
ATOM    427  CE  LYS A  28      -4.193  -3.046  12.829  1.00  0.00           C  
ATOM    428  NZ  LYS A  28      -4.117  -4.458  13.303  1.00  0.00           N  
ATOM    429  H   LYS A  28      -1.931  -3.030   8.338  1.00  0.00           H  
ATOM    430  HA  LYS A  28      -2.535  -0.301   8.906  1.00  0.00           H  
ATOM    431  HB2 LYS A  28      -1.026  -2.447  10.398  1.00  0.00           H  
ATOM    432  HB3 LYS A  28      -1.083  -0.800  11.011  1.00  0.00           H  
ATOM    433  HG2 LYS A  28      -3.471  -0.867  11.214  1.00  0.00           H  
ATOM    434  HG3 LYS A  28      -3.561  -2.387  10.326  1.00  0.00           H  
ATOM    435  HD2 LYS A  28      -2.188  -3.445  12.168  1.00  0.00           H  
ATOM    436  HD3 LYS A  28      -2.363  -1.944  13.077  1.00  0.00           H  
ATOM    437  HE2 LYS A  28      -4.513  -2.416  13.646  1.00  0.00           H  
ATOM    438  HE3 LYS A  28      -4.916  -2.979  12.029  1.00  0.00           H  
ATOM    439  HZ1 LYS A  28      -5.039  -4.745  13.688  1.00  0.00           H  
ATOM    440  HZ2 LYS A  28      -3.392  -4.534  14.045  1.00  0.00           H  
ATOM    441  HZ3 LYS A  28      -3.866  -5.078  12.506  1.00  0.00           H  
ATOM    442  N   ALA A  29       0.603  -0.915   8.243  1.00  0.00           N  
ATOM    443  CA  ALA A  29       1.840  -0.236   7.867  1.00  0.00           C  
ATOM    444  C   ALA A  29       1.634   0.608   6.614  1.00  0.00           C  
ATOM    445  O   ALA A  29       2.113   1.740   6.539  1.00  0.00           O  
ATOM    446  CB  ALA A  29       2.971  -1.232   7.656  1.00  0.00           C  
ATOM    447  H   ALA A  29       0.536  -1.890   8.168  1.00  0.00           H  
ATOM    448  HA  ALA A  29       2.117   0.460   8.643  1.00  0.00           H  
ATOM    449  HB1 ALA A  29       3.177  -1.745   8.585  1.00  0.00           H  
ATOM    450  HB2 ALA A  29       3.857  -0.707   7.331  1.00  0.00           H  
ATOM    451  HB3 ALA A  29       2.682  -1.951   6.904  1.00  0.00           H  
ATOM    452  N   PHE A  30       0.943   0.054   5.634  1.00  0.00           N  
ATOM    453  CA  PHE A  30       0.706   0.772   4.384  1.00  0.00           C  
ATOM    454  C   PHE A  30      -0.278   1.927   4.582  1.00  0.00           C  
ATOM    455  O   PHE A  30      -0.097   2.976   3.963  1.00  0.00           O  
ATOM    456  CB  PHE A  30       0.178  -0.176   3.303  1.00  0.00           C  
ATOM    457  CG  PHE A  30       1.253  -1.064   2.707  1.00  0.00           C  
ATOM    458  CD1 PHE A  30       2.577  -0.626   2.540  1.00  0.00           C  
ATOM    459  CD2 PHE A  30       0.892  -2.350   2.278  1.00  0.00           C  
ATOM    460  CE1 PHE A  30       3.526  -1.469   1.947  1.00  0.00           C  
ATOM    461  CE2 PHE A  30       1.843  -3.195   1.694  1.00  0.00           C  
ATOM    462  CZ  PHE A  30       3.162  -2.755   1.527  1.00  0.00           C  
ATOM    463  H   PHE A  30       0.616  -0.868   5.695  1.00  0.00           H  
ATOM    464  HA  PHE A  30       1.633   1.206   4.051  1.00  0.00           H  
ATOM    465  HB2 PHE A  30      -0.588  -0.801   3.737  1.00  0.00           H  
ATOM    466  HB3 PHE A  30      -0.265   0.411   2.511  1.00  0.00           H  
ATOM    467  HD1 PHE A  30       2.870   0.362   2.862  1.00  0.00           H  
ATOM    468  HD2 PHE A  30      -0.124  -2.693   2.404  1.00  0.00           H  
ATOM    469  HE1 PHE A  30       4.544  -1.130   1.820  1.00  0.00           H  
ATOM    470  HE2 PHE A  30       1.559  -4.185   1.371  1.00  0.00           H  
ATOM    471  HZ  PHE A  30       3.862  -3.356   0.967  1.00  0.00           H  
ATOM    472  N   LYS A  31      -1.280   1.776   5.432  1.00  0.00           N  
ATOM    473  CA  LYS A  31      -2.211   2.877   5.673  1.00  0.00           C  
ATOM    474  C   LYS A  31      -1.472   4.017   6.374  1.00  0.00           C  
ATOM    475  O   LYS A  31      -1.722   5.184   6.075  1.00  0.00           O  
ATOM    476  CB  LYS A  31      -3.408   2.414   6.517  1.00  0.00           C  
ATOM    477  CG  LYS A  31      -4.272   1.395   5.758  1.00  0.00           C  
ATOM    478  CD  LYS A  31      -5.539   2.066   5.210  1.00  0.00           C  
ATOM    479  CE  LYS A  31      -6.336   1.093   4.331  1.00  0.00           C  
ATOM    480  NZ  LYS A  31      -7.514   0.572   5.081  1.00  0.00           N  
ATOM    481  H   LYS A  31      -1.452   0.917   5.869  1.00  0.00           H  
ATOM    482  HA  LYS A  31      -2.565   3.276   4.734  1.00  0.00           H  
ATOM    483  HB2 LYS A  31      -3.039   1.959   7.425  1.00  0.00           H  
ATOM    484  HB3 LYS A  31      -4.009   3.274   6.776  1.00  0.00           H  
ATOM    485  HG2 LYS A  31      -3.705   0.977   4.940  1.00  0.00           H  
ATOM    486  HG3 LYS A  31      -4.560   0.603   6.432  1.00  0.00           H  
ATOM    487  HD2 LYS A  31      -6.157   2.385   6.035  1.00  0.00           H  
ATOM    488  HD3 LYS A  31      -5.257   2.928   4.624  1.00  0.00           H  
ATOM    489  HE2 LYS A  31      -6.679   1.607   3.446  1.00  0.00           H  
ATOM    490  HE3 LYS A  31      -5.706   0.265   4.036  1.00  0.00           H  
ATOM    491  HZ1 LYS A  31      -7.243  -0.287   5.600  1.00  0.00           H  
ATOM    492  HZ2 LYS A  31      -8.279   0.348   4.412  1.00  0.00           H  
ATOM    493  HZ3 LYS A  31      -7.842   1.293   5.755  1.00  0.00           H  
ATOM    494  N   GLN A  32      -0.532   3.702   7.251  1.00  0.00           N  
ATOM    495  CA  GLN A  32       0.261   4.734   7.922  1.00  0.00           C  
ATOM    496  C   GLN A  32       1.150   5.424   6.891  1.00  0.00           C  
ATOM    497  O   GLN A  32       1.261   6.649   6.880  1.00  0.00           O  
ATOM    498  CB  GLN A  32       1.094   4.130   9.054  1.00  0.00           C  
ATOM    499  CG  GLN A  32       1.854   5.242   9.783  1.00  0.00           C  
ATOM    500  CD  GLN A  32       0.859   6.115  10.549  1.00  0.00           C  
ATOM    501  OE1 GLN A  32       0.312   5.692  11.549  1.00  0.00           O  
ATOM    502  NE2 GLN A  32       0.597   7.319  10.115  1.00  0.00           N  
ATOM    503  H   GLN A  32      -0.410   2.764   7.505  1.00  0.00           H  
ATOM    504  HA  GLN A  32      -0.364   5.526   8.306  1.00  0.00           H  
ATOM    505  HB2 GLN A  32       0.440   3.624   9.750  1.00  0.00           H  
ATOM    506  HB3 GLN A  32       1.800   3.423   8.644  1.00  0.00           H  
ATOM    507  HG2 GLN A  32       2.554   4.800  10.477  1.00  0.00           H  
ATOM    508  HG3 GLN A  32       2.389   5.848   9.068  1.00  0.00           H  
ATOM    509 HE21 GLN A  32       1.035   7.655   9.306  1.00  0.00           H  
ATOM    510 HE22 GLN A  32      -0.038   7.887  10.599  1.00  0.00           H  
ATOM    511  N   TYR A  33       1.761   4.637   6.032  1.00  0.00           N  
ATOM    512  CA  TYR A  33       2.631   5.146   4.978  1.00  0.00           C  
ATOM    513  C   TYR A  33       1.851   6.102   4.079  1.00  0.00           C  
ATOM    514  O   TYR A  33       2.323   7.193   3.752  1.00  0.00           O  
ATOM    515  CB  TYR A  33       3.220   3.969   4.191  1.00  0.00           C  
ATOM    516  CG  TYR A  33       3.817   4.360   2.859  1.00  0.00           C  
ATOM    517  CD1 TYR A  33       5.165   4.730   2.771  1.00  0.00           C  
ATOM    518  CD2 TYR A  33       3.039   4.282   1.697  1.00  0.00           C  
ATOM    519  CE1 TYR A  33       5.734   5.019   1.524  1.00  0.00           C  
ATOM    520  CE2 TYR A  33       3.601   4.590   0.453  1.00  0.00           C  
ATOM    521  CZ  TYR A  33       4.947   4.959   0.365  1.00  0.00           C  
ATOM    522  OH  TYR A  33       5.505   5.214  -0.870  1.00  0.00           O  
ATOM    523  H   TYR A  33       1.632   3.668   6.097  1.00  0.00           H  
ATOM    524  HA  TYR A  33       3.432   5.725   5.411  1.00  0.00           H  
ATOM    525  HB2 TYR A  33       3.990   3.505   4.789  1.00  0.00           H  
ATOM    526  HB3 TYR A  33       2.435   3.247   4.023  1.00  0.00           H  
ATOM    527  HD1 TYR A  33       5.767   4.791   3.666  1.00  0.00           H  
ATOM    528  HD2 TYR A  33       1.999   3.998   1.763  1.00  0.00           H  
ATOM    529  HE1 TYR A  33       6.773   5.305   1.456  1.00  0.00           H  
ATOM    530  HE2 TYR A  33       2.993   4.546  -0.439  1.00  0.00           H  
ATOM    531  HH  TYR A  33       5.660   6.159  -0.936  1.00  0.00           H  
ATOM    532  N   ALA A  34       0.657   5.709   3.677  1.00  0.00           N  
ATOM    533  CA  ALA A  34      -0.174   6.545   2.821  1.00  0.00           C  
ATOM    534  C   ALA A  34      -0.529   7.848   3.533  1.00  0.00           C  
ATOM    535  O   ALA A  34      -0.423   8.923   2.941  1.00  0.00           O  
ATOM    536  CB  ALA A  34      -1.432   5.796   2.402  1.00  0.00           C  
ATOM    537  H   ALA A  34       0.337   4.813   3.913  1.00  0.00           H  
ATOM    538  HA  ALA A  34       0.381   6.819   1.937  1.00  0.00           H  
ATOM    539  HB1 ALA A  34      -2.130   6.487   1.953  1.00  0.00           H  
ATOM    540  HB2 ALA A  34      -1.884   5.339   3.270  1.00  0.00           H  
ATOM    541  HB3 ALA A  34      -1.172   5.031   1.685  1.00  0.00           H  
ATOM    542  N   ASN A  35      -0.941   7.758   4.789  1.00  0.00           N  
ATOM    543  CA  ASN A  35      -1.297   8.967   5.533  1.00  0.00           C  
ATOM    544  C   ASN A  35      -0.090   9.894   5.647  1.00  0.00           C  
ATOM    545  O   ASN A  35      -0.229  11.104   5.461  1.00  0.00           O  
ATOM    546  CB  ASN A  35      -1.795   8.639   6.946  1.00  0.00           C  
ATOM    547  CG  ASN A  35      -3.195   8.024   7.003  1.00  0.00           C  
ATOM    548  OD1 ASN A  35      -3.861   7.818   6.005  1.00  0.00           O  
ATOM    549  ND2 ASN A  35      -3.667   7.714   8.182  1.00  0.00           N  
ATOM    550  H   ASN A  35      -1.007   6.881   5.220  1.00  0.00           H  
ATOM    551  HA  ASN A  35      -2.053   9.505   4.985  1.00  0.00           H  
ATOM    552  HB2 ASN A  35      -1.103   7.947   7.401  1.00  0.00           H  
ATOM    553  HB3 ASN A  35      -1.797   9.550   7.529  1.00  0.00           H  
ATOM    554 HD21 ASN A  35      -3.128   7.880   8.984  1.00  0.00           H  
ATOM    555 HD22 ASN A  35      -4.558   7.317   8.265  1.00  0.00           H  
ATOM    556  N   ASP A  36       1.073   9.345   5.954  1.00  0.00           N  
ATOM    557  CA  ASP A  36       2.285  10.148   6.099  1.00  0.00           C  
ATOM    558  C   ASP A  36       2.634  10.859   4.791  1.00  0.00           C  
ATOM    559  O   ASP A  36       3.244  11.928   4.818  1.00  0.00           O  
ATOM    560  CB  ASP A  36       3.469   9.284   6.557  1.00  0.00           C  
ATOM    561  CG  ASP A  36       3.335   8.799   8.004  1.00  0.00           C  
ATOM    562  OD1 ASP A  36       2.509   9.340   8.720  1.00  0.00           O  
ATOM    563  OD2 ASP A  36       4.077   7.900   8.376  1.00  0.00           O  
ATOM    564  H   ASP A  36       1.098   8.387   6.159  1.00  0.00           H  
ATOM    565  HA  ASP A  36       2.105  10.942   6.804  1.00  0.00           H  
ATOM    566  HB2 ASP A  36       3.542   8.422   5.910  1.00  0.00           H  
ATOM    567  HB3 ASP A  36       4.378   9.862   6.466  1.00  0.00           H  
ATOM    568  N   ASN A  37       2.257  10.275   3.671  1.00  0.00           N  
ATOM    569  CA  ASN A  37       2.560  10.848   2.361  1.00  0.00           C  
ATOM    570  C   ASN A  37       1.373  11.582   1.746  1.00  0.00           C  
ATOM    571  O   ASN A  37       1.443  11.985   0.585  1.00  0.00           O  
ATOM    572  CB  ASN A  37       3.031   9.750   1.411  1.00  0.00           C  
ATOM    573  CG  ASN A  37       4.441   9.340   1.836  1.00  0.00           C  
ATOM    574  OD1 ASN A  37       5.383  10.088   1.646  1.00  0.00           O  
ATOM    575  ND2 ASN A  37       4.613   8.191   2.432  1.00  0.00           N  
ATOM    576  H   ASN A  37       1.759   9.432   3.718  1.00  0.00           H  
ATOM    577  HA  ASN A  37       3.340  11.588   2.441  1.00  0.00           H  
ATOM    578  HB2 ASN A  37       2.366   8.902   1.474  1.00  0.00           H  
ATOM    579  HB3 ASN A  37       3.056  10.125   0.398  1.00  0.00           H  
ATOM    580 HD21 ASN A  37       3.845   7.606   2.601  1.00  0.00           H  
ATOM    581 HD22 ASN A  37       5.511   7.913   2.711  1.00  0.00           H  
ATOM    582  N   GLY A  38       0.329  11.812   2.518  1.00  0.00           N  
ATOM    583  CA  GLY A  38      -0.816  12.573   2.056  1.00  0.00           C  
ATOM    584  C   GLY A  38      -1.691  11.903   1.018  1.00  0.00           C  
ATOM    585  O   GLY A  38      -2.416  12.596   0.302  1.00  0.00           O  
ATOM    586  H   GLY A  38       0.270  11.440   3.423  1.00  0.00           H  
ATOM    587  HA2 GLY A  38      -1.431  12.805   2.912  1.00  0.00           H  
ATOM    588  HA3 GLY A  38      -0.454  13.501   1.639  1.00  0.00           H  
ATOM    589  N   VAL A  39      -1.668  10.588   0.908  1.00  0.00           N  
ATOM    590  CA  VAL A  39      -2.480   9.873  -0.067  1.00  0.00           C  
ATOM    591  C   VAL A  39      -3.813   9.492   0.579  1.00  0.00           C  
ATOM    592  O   VAL A  39      -3.847   8.895   1.656  1.00  0.00           O  
ATOM    593  CB  VAL A  39      -1.747   8.614  -0.583  1.00  0.00           C  
ATOM    594  CG1 VAL A  39      -2.671   7.775  -1.468  1.00  0.00           C  
ATOM    595  CG2 VAL A  39      -0.515   9.030  -1.396  1.00  0.00           C  
ATOM    596  H   VAL A  39      -1.083  10.075   1.504  1.00  0.00           H  
ATOM    597  HA  VAL A  39      -2.682  10.533  -0.898  1.00  0.00           H  
ATOM    598  HB  VAL A  39      -1.430   8.018   0.261  1.00  0.00           H  
ATOM    599 HG11 VAL A  39      -3.436   7.317  -0.858  1.00  0.00           H  
ATOM    600 HG12 VAL A  39      -2.097   7.006  -1.964  1.00  0.00           H  
ATOM    601 HG13 VAL A  39      -3.134   8.412  -2.207  1.00  0.00           H  
ATOM    602 HG21 VAL A  39      -0.822   9.672  -2.209  1.00  0.00           H  
ATOM    603 HG22 VAL A  39      -0.032   8.151  -1.794  1.00  0.00           H  
ATOM    604 HG23 VAL A  39       0.175   9.562  -0.758  1.00  0.00           H  
ATOM    605  N   ASP A  40      -4.893   9.863  -0.086  1.00  0.00           N  
ATOM    606  CA  ASP A  40      -6.255   9.588   0.370  1.00  0.00           C  
ATOM    607  C   ASP A  40      -7.014   8.963  -0.796  1.00  0.00           C  
ATOM    608  O   ASP A  40      -7.562   9.676  -1.640  1.00  0.00           O  
ATOM    609  CB  ASP A  40      -6.943  10.889   0.812  1.00  0.00           C  
ATOM    610  CG  ASP A  40      -8.398  10.630   1.224  1.00  0.00           C  
ATOM    611  OD1 ASP A  40      -8.669   9.578   1.785  1.00  0.00           O  
ATOM    612  OD2 ASP A  40      -9.219  11.502   0.976  1.00  0.00           O  
ATOM    613  H   ASP A  40      -4.775  10.347  -0.929  1.00  0.00           H  
ATOM    614  HA  ASP A  40      -6.230   8.892   1.196  1.00  0.00           H  
ATOM    615  HB2 ASP A  40      -6.406  11.305   1.652  1.00  0.00           H  
ATOM    616  HB3 ASP A  40      -6.925  11.595  -0.004  1.00  0.00           H  
ATOM    617  N   GLY A  41      -7.001   7.645  -0.880  1.00  0.00           N  
ATOM    618  CA  GLY A  41      -7.657   6.969  -1.989  1.00  0.00           C  
ATOM    619  C   GLY A  41      -8.482   5.773  -1.558  1.00  0.00           C  
ATOM    620  O   GLY A  41      -8.770   5.598  -0.373  1.00  0.00           O  
ATOM    621  H   GLY A  41      -6.547   7.118  -0.190  1.00  0.00           H  
ATOM    622  HA2 GLY A  41      -8.305   7.667  -2.498  1.00  0.00           H  
ATOM    623  HA3 GLY A  41      -6.898   6.633  -2.680  1.00  0.00           H  
ATOM    624  N   VAL A  42      -8.846   4.952  -2.527  1.00  0.00           N  
ATOM    625  CA  VAL A  42      -9.612   3.742  -2.254  1.00  0.00           C  
ATOM    626  C   VAL A  42      -8.641   2.575  -2.390  1.00  0.00           C  
ATOM    627  O   VAL A  42      -7.682   2.662  -3.169  1.00  0.00           O  
ATOM    628  CB  VAL A  42     -10.817   3.614  -3.199  1.00  0.00           C  
ATOM    629  CG1 VAL A  42     -11.784   4.750  -2.838  1.00  0.00           C  
ATOM    630  CG2 VAL A  42     -10.426   3.713  -4.663  1.00  0.00           C  
ATOM    631  H   VAL A  42      -8.583   5.220  -3.432  1.00  0.00           H  
ATOM    632  HA  VAL A  42     -10.014   3.872  -1.252  1.00  0.00           H  
ATOM    633  HB  VAL A  42     -11.306   2.667  -3.016  1.00  0.00           H  
ATOM    634 HG11 VAL A  42     -12.602   4.763  -3.543  1.00  0.00           H  
ATOM    635 HG12 VAL A  42     -11.261   5.695  -2.875  1.00  0.00           H  
ATOM    636 HG13 VAL A  42     -12.171   4.592  -1.843  1.00  0.00           H  
ATOM    637 HG21 VAL A  42      -9.858   2.838  -4.942  1.00  0.00           H  
ATOM    638 HG22 VAL A  42      -9.829   4.601  -4.812  1.00  0.00           H  
ATOM    639 HG23 VAL A  42     -11.317   3.772  -5.271  1.00  0.00           H  
ATOM    640  N   TRP A  43      -8.823   1.539  -1.613  1.00  0.00           N  
ATOM    641  CA  TRP A  43      -7.909   0.403  -1.582  1.00  0.00           C  
ATOM    642  C   TRP A  43      -8.497  -0.922  -2.075  1.00  0.00           C  
ATOM    643  O   TRP A  43      -9.636  -1.273  -1.769  1.00  0.00           O  
ATOM    644  CB  TRP A  43      -7.529   0.139  -0.136  1.00  0.00           C  
ATOM    645  CG  TRP A  43      -6.779   1.300   0.418  1.00  0.00           C  
ATOM    646  CD1 TRP A  43      -7.259   2.530   0.732  1.00  0.00           C  
ATOM    647  CD2 TRP A  43      -5.373   1.308   0.749  1.00  0.00           C  
ATOM    648  NE1 TRP A  43      -6.222   3.295   1.236  1.00  0.00           N  
ATOM    649  CE2 TRP A  43      -5.040   2.583   1.265  1.00  0.00           C  
ATOM    650  CE3 TRP A  43      -4.373   0.330   0.644  1.00  0.00           C  
ATOM    651  CZ2 TRP A  43      -3.738   2.876   1.669  1.00  0.00           C  
ATOM    652  CZ3 TRP A  43      -3.066   0.622   1.049  1.00  0.00           C  
ATOM    653  CH2 TRP A  43      -2.751   1.890   1.558  1.00  0.00           C  
ATOM    654  H   TRP A  43      -9.544   1.639  -0.956  1.00  0.00           H  
ATOM    655  HA  TRP A  43      -7.010   0.607  -2.134  1.00  0.00           H  
ATOM    656  HB2 TRP A  43      -8.426  -0.016   0.445  1.00  0.00           H  
ATOM    657  HB3 TRP A  43      -6.911  -0.745  -0.081  1.00  0.00           H  
ATOM    658  HD1 TRP A  43      -8.281   2.857   0.608  1.00  0.00           H  
ATOM    659  HE1 TRP A  43      -6.296   4.224   1.539  1.00  0.00           H  
ATOM    660  HE3 TRP A  43      -4.610  -0.647   0.252  1.00  0.00           H  
ATOM    661  HZ2 TRP A  43      -3.493   3.852   2.061  1.00  0.00           H  
ATOM    662  HZ3 TRP A  43      -2.298  -0.131   0.968  1.00  0.00           H  
ATOM    663  HH2 TRP A  43      -1.740   2.107   1.868  1.00  0.00           H  
ATOM    664  N   THR A  44      -7.615  -1.719  -2.668  1.00  0.00           N  
ATOM    665  CA  THR A  44      -7.911  -3.121  -2.962  1.00  0.00           C  
ATOM    666  C   THR A  44      -6.728  -3.952  -2.468  1.00  0.00           C  
ATOM    667  O   THR A  44      -5.618  -3.458  -2.259  1.00  0.00           O  
ATOM    668  CB  THR A  44      -8.058  -3.437  -4.472  1.00  0.00           C  
ATOM    669  OG1 THR A  44      -6.825  -3.185  -5.138  1.00  0.00           O  
ATOM    670  CG2 THR A  44      -9.181  -2.639  -5.132  1.00  0.00           C  
ATOM    671  H   THR A  44      -6.730  -1.387  -2.927  1.00  0.00           H  
ATOM    672  HA  THR A  44      -8.789  -3.431  -2.418  1.00  0.00           H  
ATOM    673  HB  THR A  44      -8.284  -4.489  -4.574  1.00  0.00           H  
ATOM    674  HG1 THR A  44      -6.308  -3.993  -5.123  1.00  0.00           H  
ATOM    675 HG21 THR A  44      -9.144  -2.783  -6.201  1.00  0.00           H  
ATOM    676 HG22 THR A  44      -9.059  -1.590  -4.904  1.00  0.00           H  
ATOM    677 HG23 THR A  44     -10.134  -2.980  -4.755  1.00  0.00           H  
ATOM    678  N   TYR A  45      -7.010  -5.225  -2.307  1.00  0.00           N  
ATOM    679  CA  TYR A  45      -5.995  -6.183  -1.895  1.00  0.00           C  
ATOM    680  C   TYR A  45      -6.255  -7.447  -2.696  1.00  0.00           C  
ATOM    681  O   TYR A  45      -7.387  -7.934  -2.738  1.00  0.00           O  
ATOM    682  CB  TYR A  45      -6.082  -6.478  -0.388  1.00  0.00           C  
ATOM    683  CG  TYR A  45      -5.111  -7.595  -0.052  1.00  0.00           C  
ATOM    684  CD1 TYR A  45      -3.734  -7.415  -0.251  1.00  0.00           C  
ATOM    685  CD2 TYR A  45      -5.587  -8.824   0.428  1.00  0.00           C  
ATOM    686  CE1 TYR A  45      -2.840  -8.458   0.026  1.00  0.00           C  
ATOM    687  CE2 TYR A  45      -4.693  -9.864   0.711  1.00  0.00           C  
ATOM    688  CZ  TYR A  45      -3.320  -9.681   0.509  1.00  0.00           C  
ATOM    689  OH  TYR A  45      -2.447 -10.724   0.741  1.00  0.00           O  
ATOM    690  H   TYR A  45      -7.924  -5.537  -2.469  1.00  0.00           H  
ATOM    691  HA  TYR A  45      -5.020  -5.773  -2.128  1.00  0.00           H  
ATOM    692  HB2 TYR A  45      -5.819  -5.590   0.169  1.00  0.00           H  
ATOM    693  HB3 TYR A  45      -7.087  -6.781  -0.136  1.00  0.00           H  
ATOM    694  HD1 TYR A  45      -3.361  -6.471  -0.620  1.00  0.00           H  
ATOM    695  HD2 TYR A  45      -6.647  -8.967   0.585  1.00  0.00           H  
ATOM    696  HE1 TYR A  45      -1.780  -8.316  -0.127  1.00  0.00           H  
ATOM    697  HE2 TYR A  45      -5.063 -10.808   1.083  1.00  0.00           H  
ATOM    698  HH  TYR A  45      -2.650 -11.427   0.119  1.00  0.00           H  
ATOM    699  N   ASP A  46      -5.210  -7.975  -3.306  1.00  0.00           N  
ATOM    700  CA  ASP A  46      -5.302  -9.214  -4.068  1.00  0.00           C  
ATOM    701  C   ASP A  46      -4.424 -10.241  -3.368  1.00  0.00           C  
ATOM    702  O   ASP A  46      -3.200 -10.115  -3.336  1.00  0.00           O  
ATOM    703  CB  ASP A  46      -4.812  -9.016  -5.505  1.00  0.00           C  
ATOM    704  CG  ASP A  46      -5.051 -10.307  -6.299  1.00  0.00           C  
ATOM    705  OD1 ASP A  46      -4.894 -11.381  -5.737  1.00  0.00           O  
ATOM    706  OD2 ASP A  46      -5.400 -10.196  -7.463  1.00  0.00           O  
ATOM    707  H   ASP A  46      -4.342  -7.522  -3.269  1.00  0.00           H  
ATOM    708  HA  ASP A  46      -6.330  -9.546  -4.079  1.00  0.00           H  
ATOM    709  HB2 ASP A  46      -5.355  -8.202  -5.963  1.00  0.00           H  
ATOM    710  HB3 ASP A  46      -3.756  -8.788  -5.499  1.00  0.00           H  
ATOM    711  N   ASP A  47      -5.076 -11.204  -2.758  1.00  0.00           N  
ATOM    712  CA  ASP A  47      -4.365 -12.218  -1.994  1.00  0.00           C  
ATOM    713  C   ASP A  47      -3.473 -13.090  -2.883  1.00  0.00           C  
ATOM    714  O   ASP A  47      -2.508 -13.678  -2.396  1.00  0.00           O  
ATOM    715  CB  ASP A  47      -5.359 -13.073  -1.204  1.00  0.00           C  
ATOM    716  CG  ASP A  47      -4.651 -13.787  -0.041  1.00  0.00           C  
ATOM    717  OD1 ASP A  47      -3.947 -13.150   0.735  1.00  0.00           O  
ATOM    718  OD2 ASP A  47      -4.830 -14.988   0.049  1.00  0.00           O  
ATOM    719  H   ASP A  47      -6.055 -11.213  -2.735  1.00  0.00           H  
ATOM    720  HA  ASP A  47      -3.710 -11.736  -1.282  1.00  0.00           H  
ATOM    721  HB2 ASP A  47      -6.141 -12.439  -0.811  1.00  0.00           H  
ATOM    722  HB3 ASP A  47      -5.797 -13.811  -1.861  1.00  0.00           H  
ATOM    723  N   ALA A  48      -3.793 -13.235  -4.160  1.00  0.00           N  
ATOM    724  CA  ALA A  48      -3.001 -14.080  -5.055  1.00  0.00           C  
ATOM    725  C   ALA A  48      -1.612 -13.497  -5.322  1.00  0.00           C  
ATOM    726  O   ALA A  48      -0.654 -14.249  -5.511  1.00  0.00           O  
ATOM    727  CB  ALA A  48      -3.732 -14.320  -6.368  1.00  0.00           C  
ATOM    728  H   ALA A  48      -4.591 -12.853  -4.583  1.00  0.00           H  
ATOM    729  HA  ALA A  48      -2.848 -15.019  -4.549  1.00  0.00           H  
ATOM    730  HB1 ALA A  48      -3.086 -14.857  -7.047  1.00  0.00           H  
ATOM    731  HB2 ALA A  48      -4.005 -13.372  -6.806  1.00  0.00           H  
ATOM    732  HB3 ALA A  48      -4.622 -14.901  -6.184  1.00  0.00           H  
ATOM    733  N   THR A  49      -1.514 -12.183  -5.378  1.00  0.00           N  
ATOM    734  CA  THR A  49      -0.232 -11.532  -5.659  1.00  0.00           C  
ATOM    735  C   THR A  49       0.281 -10.760  -4.442  1.00  0.00           C  
ATOM    736  O   THR A  49       1.321 -10.106  -4.526  1.00  0.00           O  
ATOM    737  CB  THR A  49      -0.348 -10.560  -6.852  1.00  0.00           C  
ATOM    738  OG1 THR A  49      -1.314  -9.566  -6.534  1.00  0.00           O  
ATOM    739  CG2 THR A  49      -0.776 -11.303  -8.123  1.00  0.00           C  
ATOM    740  H   THR A  49      -2.343 -11.661  -5.342  1.00  0.00           H  
ATOM    741  HA  THR A  49       0.512 -12.280  -5.883  1.00  0.00           H  
ATOM    742  HB  THR A  49       0.608 -10.087  -7.021  1.00  0.00           H  
ATOM    743  HG1 THR A  49      -1.485  -9.053  -7.328  1.00  0.00           H  
ATOM    744 HG21 THR A  49      -1.057 -10.587  -8.881  1.00  0.00           H  
ATOM    745 HG22 THR A  49      -1.620 -11.940  -7.901  1.00  0.00           H  
ATOM    746 HG23 THR A  49       0.045 -11.905  -8.482  1.00  0.00           H  
ATOM    747  N   LYS A  50      -0.433 -10.836  -3.337  1.00  0.00           N  
ATOM    748  CA  LYS A  50      -0.057 -10.139  -2.104  1.00  0.00           C  
ATOM    749  C   LYS A  50       0.232  -8.663  -2.363  1.00  0.00           C  
ATOM    750  O   LYS A  50       1.223  -8.104  -1.887  1.00  0.00           O  
ATOM    751  CB  LYS A  50       1.178 -10.778  -1.455  1.00  0.00           C  
ATOM    752  CG  LYS A  50       1.099 -12.304  -1.462  1.00  0.00           C  
ATOM    753  CD  LYS A  50       0.033 -12.767  -0.472  1.00  0.00           C  
ATOM    754  CE  LYS A  50      -0.142 -14.280  -0.597  1.00  0.00           C  
ATOM    755  NZ  LYS A  50      -1.238 -14.713   0.314  1.00  0.00           N  
ATOM    756  H   LYS A  50      -1.285 -11.315  -3.274  1.00  0.00           H  
ATOM    757  HA  LYS A  50      -0.901 -10.222  -1.441  1.00  0.00           H  
ATOM    758  HB2 LYS A  50       2.060 -10.472  -1.997  1.00  0.00           H  
ATOM    759  HB3 LYS A  50       1.257 -10.433  -0.434  1.00  0.00           H  
ATOM    760  HG2 LYS A  50       0.844 -12.647  -2.453  1.00  0.00           H  
ATOM    761  HG3 LYS A  50       2.055 -12.713  -1.174  1.00  0.00           H  
ATOM    762  HD2 LYS A  50       0.342 -12.520   0.534  1.00  0.00           H  
ATOM    763  HD3 LYS A  50      -0.906 -12.283  -0.691  1.00  0.00           H  
ATOM    764  HE2 LYS A  50      -0.397 -14.532  -1.616  1.00  0.00           H  
ATOM    765  HE3 LYS A  50       0.776 -14.776  -0.319  1.00  0.00           H  
ATOM    766  HZ1 LYS A  50      -1.357 -15.743   0.248  1.00  0.00           H  
ATOM    767  HZ2 LYS A  50      -2.123 -14.241   0.039  1.00  0.00           H  
ATOM    768  HZ3 LYS A  50      -0.996 -14.456   1.293  1.00  0.00           H  
ATOM    769  N   THR A  51      -0.627  -8.070  -3.171  1.00  0.00           N  
ATOM    770  CA  THR A  51      -0.461  -6.682  -3.581  1.00  0.00           C  
ATOM    771  C   THR A  51      -1.677  -5.842  -3.201  1.00  0.00           C  
ATOM    772  O   THR A  51      -2.817  -6.185  -3.522  1.00  0.00           O  
ATOM    773  CB  THR A  51      -0.270  -6.584  -5.109  1.00  0.00           C  
ATOM    774  OG1 THR A  51       0.892  -7.319  -5.471  1.00  0.00           O  
ATOM    775  CG2 THR A  51      -0.112  -5.127  -5.553  1.00  0.00           C  
ATOM    776  H   THR A  51      -1.421  -8.601  -3.392  1.00  0.00           H  
ATOM    777  HA  THR A  51       0.422  -6.301  -3.093  1.00  0.00           H  
ATOM    778  HB  THR A  51      -1.129  -7.013  -5.602  1.00  0.00           H  
ATOM    779  HG1 THR A  51       0.733  -8.243  -5.268  1.00  0.00           H  
ATOM    780 HG21 THR A  51       0.565  -4.618  -4.883  1.00  0.00           H  
ATOM    781 HG22 THR A  51      -1.074  -4.638  -5.531  1.00  0.00           H  
ATOM    782 HG23 THR A  51       0.284  -5.098  -6.557  1.00  0.00           H  
ATOM    783  N   PHE A  52      -1.381  -4.702  -2.606  1.00  0.00           N  
ATOM    784  CA  PHE A  52      -2.380  -3.697  -2.271  1.00  0.00           C  
ATOM    785  C   PHE A  52      -2.237  -2.599  -3.316  1.00  0.00           C  
ATOM    786  O   PHE A  52      -1.129  -2.323  -3.780  1.00  0.00           O  
ATOM    787  CB  PHE A  52      -2.077  -3.038  -0.921  1.00  0.00           C  
ATOM    788  CG  PHE A  52      -2.262  -3.960   0.254  1.00  0.00           C  
ATOM    789  CD1 PHE A  52      -1.236  -4.833   0.633  1.00  0.00           C  
ATOM    790  CD2 PHE A  52      -3.445  -3.893   1.001  1.00  0.00           C  
ATOM    791  CE1 PHE A  52      -1.391  -5.641   1.767  1.00  0.00           C  
ATOM    792  CE2 PHE A  52      -3.607  -4.710   2.125  1.00  0.00           C  
ATOM    793  CZ  PHE A  52      -2.579  -5.584   2.508  1.00  0.00           C  
ATOM    794  H   PHE A  52      -0.425  -4.498  -2.535  1.00  0.00           H  
ATOM    795  HA  PHE A  52      -3.380  -4.102  -2.277  1.00  0.00           H  
ATOM    796  HB2 PHE A  52      -1.052  -2.696  -0.928  1.00  0.00           H  
ATOM    797  HB3 PHE A  52      -2.724  -2.182  -0.803  1.00  0.00           H  
ATOM    798  HD1 PHE A  52      -0.325  -4.881   0.056  1.00  0.00           H  
ATOM    799  HD2 PHE A  52      -4.235  -3.219   0.704  1.00  0.00           H  
ATOM    800  HE1 PHE A  52      -0.601  -6.315   2.064  1.00  0.00           H  
ATOM    801  HE2 PHE A  52      -4.521  -4.668   2.698  1.00  0.00           H  
ATOM    802  HZ  PHE A  52      -2.700  -6.207   3.381  1.00  0.00           H  
ATOM    803  N   THR A  53      -3.342  -1.970  -3.660  1.00  0.00           N  
ATOM    804  CA  THR A  53      -3.325  -0.870  -4.620  1.00  0.00           C  
ATOM    805  C   THR A  53      -4.131   0.259  -3.994  1.00  0.00           C  
ATOM    806  O   THR A  53      -5.215   0.029  -3.462  1.00  0.00           O  
ATOM    807  CB  THR A  53      -3.962  -1.287  -5.964  1.00  0.00           C  
ATOM    808  OG1 THR A  53      -3.323  -2.467  -6.433  1.00  0.00           O  
ATOM    809  CG2 THR A  53      -3.821  -0.172  -7.004  1.00  0.00           C  
ATOM    810  H   THR A  53      -4.214  -2.288  -3.348  1.00  0.00           H  
ATOM    811  HA  THR A  53      -2.298  -0.571  -4.773  1.00  0.00           H  
ATOM    812  HB  THR A  53      -5.011  -1.493  -5.808  1.00  0.00           H  
ATOM    813  HG1 THR A  53      -2.518  -2.207  -6.887  1.00  0.00           H  
ATOM    814 HG21 THR A  53      -4.209  -0.514  -7.953  1.00  0.00           H  
ATOM    815 HG22 THR A  53      -2.779   0.089  -7.114  1.00  0.00           H  
ATOM    816 HG23 THR A  53      -4.378   0.695  -6.680  1.00  0.00           H  
ATOM    817  N   VAL A  54      -3.624   1.472  -4.127  1.00  0.00           N  
ATOM    818  CA  VAL A  54      -4.350   2.648  -3.660  1.00  0.00           C  
ATOM    819  C   VAL A  54      -4.445   3.655  -4.806  1.00  0.00           C  
ATOM    820  O   VAL A  54      -3.453   3.952  -5.475  1.00  0.00           O  
ATOM    821  CB  VAL A  54      -3.671   3.307  -2.442  1.00  0.00           C  
ATOM    822  CG1 VAL A  54      -2.249   3.765  -2.767  1.00  0.00           C  
ATOM    823  CG2 VAL A  54      -4.515   4.508  -2.001  1.00  0.00           C  
ATOM    824  H   VAL A  54      -2.756   1.585  -4.568  1.00  0.00           H  
ATOM    825  HA  VAL A  54      -5.340   2.320  -3.367  1.00  0.00           H  
ATOM    826  HB  VAL A  54      -3.631   2.592  -1.633  1.00  0.00           H  
ATOM    827 HG11 VAL A  54      -1.805   4.213  -1.891  1.00  0.00           H  
ATOM    828 HG12 VAL A  54      -2.279   4.490  -3.566  1.00  0.00           H  
ATOM    829 HG13 VAL A  54      -1.659   2.913  -3.073  1.00  0.00           H  
ATOM    830 HG21 VAL A  54      -5.542   4.198  -1.874  1.00  0.00           H  
ATOM    831 HG22 VAL A  54      -4.463   5.281  -2.754  1.00  0.00           H  
ATOM    832 HG23 VAL A  54      -4.136   4.890  -1.066  1.00  0.00           H  
ATOM    833  N   THR A  55      -5.656   4.118  -5.034  1.00  0.00           N  
ATOM    834  CA  THR A  55      -5.850   5.091  -6.111  1.00  0.00           C  
ATOM    835  C   THR A  55      -6.574   6.350  -5.639  1.00  0.00           C  
ATOM    836  O   THR A  55      -7.548   6.278  -4.880  1.00  0.00           O  
ATOM    837  CB  THR A  55      -6.725   4.519  -7.253  1.00  0.00           C  
ATOM    838  OG1 THR A  55      -6.817   5.525  -8.261  1.00  0.00           O  
ATOM    839  CG2 THR A  55      -8.128   4.109  -6.820  1.00  0.00           C  
ATOM    840  H   THR A  55      -6.392   3.773  -4.488  1.00  0.00           H  
ATOM    841  HA  THR A  55      -4.902   5.338  -6.570  1.00  0.00           H  
ATOM    842  HB  THR A  55      -6.221   3.659  -7.672  1.00  0.00           H  
ATOM    843  HG1 THR A  55      -6.778   5.092  -9.117  1.00  0.00           H  
ATOM    844 HG21 THR A  55      -8.749   4.987  -6.741  1.00  0.00           H  
ATOM    845 HG22 THR A  55      -8.068   3.616  -5.861  1.00  0.00           H  
ATOM    846 HG23 THR A  55      -8.549   3.432  -7.548  1.00  0.00           H  
ATOM    847  N   GLU A  56      -6.051   7.491  -6.041  1.00  0.00           N  
ATOM    848  CA  GLU A  56      -6.685   8.760  -5.698  1.00  0.00           C  
ATOM    849  C   GLU A  56      -7.590   9.164  -6.860  1.00  0.00           C  
ATOM    850  O   GLU A  56      -7.921   8.300  -7.653  1.00  0.00           O  
ATOM    851  CB  GLU A  56      -5.639   9.855  -5.482  1.00  0.00           C  
ATOM    852  CG  GLU A  56      -4.966   9.641  -4.127  1.00  0.00           C  
ATOM    853  CD  GLU A  56      -4.045  10.815  -3.799  1.00  0.00           C  
ATOM    854  OE1 GLU A  56      -3.146  11.090  -4.578  1.00  0.00           O  
ATOM    855  OE2 GLU A  56      -4.261  11.404  -2.753  1.00  0.00           O  
ATOM    856  OXT GLU A  56      -8.023  10.305  -6.875  1.00  0.00           O  
ATOM    857  H   GLU A  56      -5.229   7.487  -6.574  1.00  0.00           H  
ATOM    858  HA  GLU A  56      -7.279   8.645  -4.803  1.00  0.00           H  
ATOM    859  HB2 GLU A  56      -4.899   9.810  -6.267  1.00  0.00           H  
ATOM    860  HB3 GLU A  56      -6.120  10.821  -5.494  1.00  0.00           H  
ATOM    861  HG2 GLU A  56      -5.723   9.557  -3.361  1.00  0.00           H  
ATOM    862  HG3 GLU A  56      -4.386   8.731  -4.158  1.00  0.00           H  
TER     863      GLU A  56                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
