
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   65 (  492),  selected   65 , name 1kh0_A
# Molecule2: number of CA atoms   56 ( 1061),  selected   56 , name T0499.pdb
# PARAMETERS: 1kh0_A.T0499.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     2_A      -       -           -
LGA    E     3_A      -       -           -
LGA    V     4_A      T       1          1.633
LGA    T     5_A      T       2          0.999
LGA    I     6_A      Y       3          0.655
LGA    K     7_A      K       4          1.098
LGA    A     8_A      L       5          0.945
LGA    N     9_A      I       6          0.985
LGA    L    10_A      L       7          0.974
LGA    I    11_A      N       8          0.845
LGA    F    12_A      L       9          1.312
LGA    A    13_A      K      10          1.607
LGA    N    14_A      Q      11          1.989
LGA    G    15_A      -       -           -
LGA    S    16_A      A      12          2.744
LGA    T    17_A      K      13          1.322
LGA    Q    18_A      E      14          1.892
LGA    T    19_A      E      15          1.582
LGA    A    20_A      A      16          2.637
LGA    E    21_A      I      17          2.143
LGA    F    22_A      K      18          1.217
LGA    K    23_A      E      19          0.832
LGA    G    24_A      A      20          0.581
LGA    T    25_A      V      21          2.064
LGA    K    26_A      D      22          1.571
LGA    E    27_A      A      23          3.445
LGA    -       -      G      24           -
LGA    K    28_A      T      25          1.540
LGA    A    29_A      A      26          1.875
LGA    L    30_A      E      27          1.628
LGA    S    31_A      K      28          1.467
LGA    E    32_A      Y      29          1.194
LGA    V    33_A      F      30          0.698
LGA    L    34_A      K      31          1.210
LGA    A    35_A      L      32          2.109
LGA    Y    36_A      I      33          1.769
LGA    A    37_A      A      34          0.988
LGA    D    38_A      N      35          1.307
LGA    T    39_A      A      36          1.101
LGA    L    40_A      K      37          1.845
LGA    K    41_A      T      38          2.882
LGA    K    42_A      -       -           -
LGA    D    43_A      -       -           -
LGA    N    44_A      -       -           -
LGA    G    45_A      V      39          3.825
LGA    E    46_A      E      40          1.669
LGA    W    47_A      G      41          2.657
LGA    T    48_A      V      42          2.234
LGA    I    49_A      W      43          0.869
LGA    D    50_A      T      44          0.394
LGA    K    51_A      Y      45          0.430
LGA    R    52_A      K      46          1.005
LGA    V    53_A      D      47          1.669
LGA    T    54_A      E      48          1.611
LGA    N    55_A      -       -           -
LGA    G    56_A      -       -           -
LGA    V    57_A      I      49          1.252
LGA    I    58_A      K      50          0.929
LGA    I    59_A      T      51          1.605
LGA    L    60_A      F      52          1.112
LGA    N    61_A      T      53          1.275
LGA    I    62_A      V      54          1.543
LGA    K    63_A      T      55          1.796
LGA    F    64_A      E      56          3.252
LGA    A    65_A      -       -           -
LGA    G    66_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   65   56    5.0     55    1.72    12.73     88.698     3.016

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.286613 * X  +   0.847383 * Y  +   0.446984 * Z  + -44.696888
  Y_new =  -0.536274 * X  +   0.528519 * Y  +  -0.658087 * Z  + -12.430485
  Z_new =  -0.793891 * X  +  -0.051090 * Y  +   0.605910 * Z  +  -1.437557 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.084120    3.057472  [ DEG:    -4.8197    175.1803 ]
  Theta =   0.917181    2.224411  [ DEG:    52.5506    127.4494 ]
  Phi   =  -1.079968    2.061625  [ DEG:   -61.8776    118.1224 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1kh0_A                                        
REMARK     2: T0499.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1kh0_A.T0499.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   65   56   5.0   55   1.72   12.73  88.698
REMARK  ---------------------------------------------------------- 
MOLECULE 1kh0_A
HEADER    PROTEIN BINDING                         28-NOV-01   1KH0              
TITLE     ACCURATE COMPUTER BASE DESIGN OF A NEW BACKBONE                       
TITLE    2 CONFORMATION IN THE SECOND TURN OF PROTEIN L                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN L;                                                 
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: B1 DOMAIN (RESIDUES 111-173);                              
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PEPTOSTREPTOCOCCUS MAGNUS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET3A                                     
KEYWDS    PROTEIN L B1 DOMAIN, COMPUTATIONAL BASED PROTEIN DESIGN,              
KEYWDS   2 TYPE 1' BETA TURN, EXTENSIVE AMINO ACID MUTATIONS.                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.W.O'NEILL,B.KUHLMAN,D.E.KIM,K.Y.ZHANG,D.BAKER                       
REVDAT   3   01-APR-03 1KH0    1       JRNL                                     
REVDAT   2   07-AUG-02 1KH0    1       SEQADV                                   
REVDAT   1   23-JAN-02 1KH0    0                                                
JRNL        AUTH   B.KUHLMAN,J.W.O'NEILL,D.E.KIM,K.Y.ZHANG,D.BAKER              
JRNL        TITL   ACCURATE COMPUTER-BASED DESIGN OF A NEW BACKBONE             
JRNL        TITL 2 CONFORMATION IN THE SECOND TURN OF PROTEIN L.                
JRNL        REF    J.MOL.BIOL.                   V. 315   471 2002              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1KH0 A    2    66  UNP    Q51912   Q51912_PEPMA   111    173             
DBREF  1KH0 B    2    66  UNP    Q51912   Q51912_PEPMA   111    173             
SEQRES   1 A   65  GLU GLU VAL THR ILE LYS ALA ASN LEU ILE PHE ALA ASN          
SEQRES   2 A   65  GLY SER THR GLN THR ALA GLU PHE LYS GLY THR LYS GLU          
SEQRES   3 A   65  LYS ALA LEU SER GLU VAL LEU ALA TYR ALA ASP THR LEU          
SEQRES   4 A   65  LYS LYS ASP ASN GLY GLU TRP THR ILE ASP LYS ARG VAL          
SEQRES   5 A   65  THR ASN GLY VAL ILE ILE LEU ASN ILE LYS PHE ALA GLY          
SEQRES   1 B   65  GLU GLU VAL THR ILE LYS ALA ASN LEU ILE PHE ALA ASN          
SEQRES   2 B   65  GLY SER THR GLN THR ALA GLU PHE LYS GLY THR LYS GLU          
SEQRES   3 B   65  LYS ALA LEU SER GLU VAL LEU ALA TYR ALA ASP THR LEU          
SEQRES   4 B   65  LYS LYS ASP ASN GLY GLU TRP THR ILE ASP LYS ARG VAL          
SEQRES   5 B   65  THR ASN GLY VAL ILE ILE LEU ASN ILE LYS PHE ALA GLY          
FORMUL   3  HOH   *80(H2 O)                                                     
CRYST1   38.622   55.542   67.382  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   GLU A   2       1.490 -16.980   7.579  1.00 56.49           N  
ATOM      2  CA  GLU A   2       1.630 -15.792   8.472  1.00 55.16           C  
ATOM      3  C   GLU A   2       2.524 -14.748   7.809  1.00 52.97           C  
ATOM      4  O   GLU A   2       2.103 -13.609   7.631  1.00 53.48           O  
ATOM      5  CB  GLU A   2       2.224 -16.209   9.820  1.00 56.71           C  
ATOM      6  CG  GLU A   2       2.213 -15.121  10.889  1.00 59.96           C  
ATOM      7  CD  GLU A   2       0.808 -14.733  11.343  1.00 62.66           C  
ATOM      8  OE1 GLU A   2      -0.045 -14.420  10.479  1.00 63.95           O  
ATOM      9  OE2 GLU A   2       0.563 -14.732  12.572  1.00 63.11           O  
ATOM     10  N   GLU A   3       3.746 -15.136   7.446  1.00 50.27           N  
ATOM     11  CA  GLU A   3       4.688 -14.221   6.796  1.00 48.95           C  
ATOM     12  C   GLU A   3       4.301 -14.016   5.336  1.00 45.55           C  
ATOM     13  O   GLU A   3       4.217 -14.979   4.575  1.00 45.07           O  
ATOM     14  CB  GLU A   3       6.111 -14.774   6.853  1.00 51.87           C  
ATOM     15  CG  GLU A   3       7.155 -13.782   6.343  1.00 56.79           C  
ATOM     16  CD  GLU A   3       7.925 -13.098   7.468  1.00 59.41           C  
ATOM     17  OE1 GLU A   3       7.348 -12.918   8.566  1.00 60.33           O  
ATOM     18  OE2 GLU A   3       9.105 -12.730   7.244  1.00 60.34           O  
ATOM     19  N   VAL A   4       4.086 -12.761   4.945  1.00 40.67           N  
ATOM     20  CA  VAL A   4       3.678 -12.440   3.583  1.00 37.10           C  
ATOM     21  C   VAL A   4       4.444 -11.279   2.966  1.00 34.84           C  
ATOM     22  O   VAL A   4       5.096 -10.507   3.670  1.00 32.26           O  
ATOM     23  CB  VAL A   4       2.172 -12.062   3.533  1.00 38.49           C  
ATOM     24  CG1 VAL A   4       1.319 -13.257   3.911  1.00 39.57           C  
ATOM     25  CG2 VAL A   4       1.888 -10.891   4.478  1.00 38.08           C  
ATOM     26  N   THR A   5       4.354 -11.167   1.643  1.00 31.85           N  
ATOM     27  CA  THR A   5       4.973 -10.076   0.903  1.00 31.00           C  
ATOM     28  C   THR A   5       3.820  -9.207   0.403  1.00 30.96           C  
ATOM     29  O   THR A   5       2.868  -9.720  -0.177  1.00 30.13           O  
ATOM     30  CB  THR A   5       5.784 -10.586  -0.321  1.00 33.29           C  
ATOM     31  OG1 THR A   5       6.927 -11.316   0.134  1.00 34.51           O  
ATOM     32  CG2 THR A   5       6.267  -9.422  -1.175  1.00 34.25           C  
ATOM     33  N   ILE A   6       3.895  -7.898   0.658  1.00 28.46           N  
ATOM     34  CA  ILE A   6       2.870  -6.965   0.223  1.00 27.89           C  
ATOM     35  C   ILE A   6       3.531  -6.014  -0.744  1.00 27.62           C  
ATOM     36  O   ILE A   6       4.584  -5.430  -0.444  1.00 28.50           O  
ATOM     37  CB  ILE A   6       2.307  -6.125   1.384  1.00 30.02           C  
ATOM     38  CG1 ILE A   6       1.589  -7.027   2.388  1.00 31.27           C  
ATOM     39  CG2 ILE A   6       1.341  -5.056   0.833  1.00 28.30           C  
ATOM     40  CD1 ILE A   6       1.026  -6.276   3.606  1.00 33.99           C  
ATOM     41  N   LYS A   7       2.934  -5.883  -1.916  1.00 25.86           N  
ATOM     42  CA  LYS A   7       3.445  -4.986  -2.929  1.00 26.19           C  
ATOM     43  C   LYS A   7       2.447  -3.845  -2.976  1.00 27.46           C  
ATOM     44  O   LYS A   7       1.255  -4.071  -3.244  1.00 26.98           O  
ATOM     45  CB  LYS A   7       3.482  -5.695  -4.278  1.00 30.71           C  
ATOM     46  CG  LYS A   7       4.265  -4.981  -5.352  1.00 39.70           C  
ATOM     47  CD  LYS A   7       5.536  -5.774  -5.699  1.00 46.02           C  
ATOM     48  CE  LYS A   7       5.211  -7.234  -6.050  1.00 47.93           C  
ATOM     49  NZ  LYS A   7       6.436  -8.073  -6.273  1.00 51.35           N  
ATOM     50  N   ALA A   8       2.915  -2.630  -2.705  1.00 24.60           N  
ATOM     51  CA  ALA A   8       2.031  -1.465  -2.706  1.00 24.81           C  
ATOM     52  C   ALA A   8       2.288  -0.568  -3.894  1.00 26.43           C  
ATOM     53  O   ALA A   8       3.393  -0.046  -4.042  1.00 28.64           O  
ATOM     54  CB  ALA A   8       2.223  -0.653  -1.436  1.00 24.73           C  
ATOM     55  N   ASN A   9       1.274  -0.394  -4.736  1.00 23.62           N  
ATOM     56  CA  ASN A   9       1.378   0.507  -5.875  1.00 26.04           C  
ATOM     57  C   ASN A   9       0.732   1.794  -5.440  1.00 26.78           C  
ATOM     58  O   ASN A   9      -0.474   1.822  -5.167  1.00 26.56           O  
ATOM     59  CB  ASN A   9       0.622  -0.041  -7.081  1.00 27.28           C  
ATOM     60  CG  ASN A   9       1.211  -1.325  -7.569  1.00 31.72           C  
ATOM     61  OD1 ASN A   9       2.419  -1.399  -7.819  1.00 32.99           O  
ATOM     62  ND2 ASN A   9       0.384  -2.358  -7.684  1.00 29.41           N  
ATOM     63  N   LEU A  10       1.536   2.848  -5.382  1.00 25.56           N  
ATOM     64  CA  LEU A  10       1.081   4.159  -4.968  1.00 27.04           C  
ATOM     65  C   LEU A  10       0.782   4.930  -6.243  1.00 27.94           C  
ATOM     66  O   LEU A  10       1.692   5.301  -6.999  1.00 28.01           O  
ATOM     67  CB  LEU A  10       2.174   4.852  -4.160  1.00 29.42           C  
ATOM     68  CG  LEU A  10       2.614   4.019  -2.939  1.00 31.51           C  
ATOM     69  CD1 LEU A  10       3.937   4.524  -2.409  1.00 35.66           C  
ATOM     70  CD2 LEU A  10       1.556   4.108  -1.872  1.00 33.98           C  
ATOM     71  N   ILE A  11      -0.503   5.149  -6.482  1.00 26.81           N  
ATOM     72  CA  ILE A  11      -0.955   5.843  -7.679  1.00 24.41           C  
ATOM     73  C   ILE A  11      -1.390   7.257  -7.318  1.00 25.96           C  
ATOM     74  O   ILE A  11      -2.405   7.444  -6.646  1.00 26.04           O  
ATOM     75  CB  ILE A  11      -2.101   5.039  -8.309  1.00 28.10           C  
ATOM     76  CG1 ILE A  11      -1.620   3.597  -8.536  1.00 29.02           C  
ATOM     77  CG2 ILE A  11      -2.526   5.661  -9.651  1.00 28.24           C  
ATOM     78  CD1 ILE A  11      -2.736   2.561  -8.717  1.00 31.61           C  
ATOM     79  N   PHE A  12      -0.619   8.248  -7.768  1.00 25.29           N  
ATOM     80  CA  PHE A  12      -0.909   9.653  -7.499  1.00 26.24           C  
ATOM     81  C   PHE A  12      -1.738  10.283  -8.618  1.00 26.53           C  
ATOM     82  O   PHE A  12      -1.678   9.840  -9.764  1.00 27.73           O  
ATOM     83  CB  PHE A  12       0.405  10.410  -7.287  1.00 27.99           C  
ATOM     84  CG  PHE A  12       1.217   9.861  -6.150  1.00 31.02           C  
ATOM     85  CD1 PHE A  12       0.755   9.971  -4.838  1.00 31.79           C  
ATOM     86  CD2 PHE A  12       2.403   9.174  -6.387  1.00 32.66           C  
ATOM     87  CE1 PHE A  12       1.471   9.401  -3.768  1.00 31.84           C  
ATOM     88  CE2 PHE A  12       3.125   8.602  -5.327  1.00 34.99           C  
ATOM     89  CZ  PHE A  12       2.650   8.720  -4.013  1.00 32.66           C  
ATOM     90  N   ALA A  13      -2.500  11.314  -8.256  1.00 26.62           N  
ATOM     91  CA  ALA A  13      -3.409  12.004  -9.170  1.00 29.35           C  
ATOM     92  C   ALA A  13      -2.724  12.819 -10.268  1.00 30.39           C  
ATOM     93  O   ALA A  13      -3.373  13.220 -11.252  1.00 30.80           O  
ATOM     94  CB  ALA A  13      -4.346  12.901  -8.371  1.00 28.86           C  
ATOM     95  N   ASN A  14      -1.429  13.061 -10.104  1.00 29.71           N  
ATOM     96  CA  ASN A  14      -0.683  13.826 -11.096  1.00 32.22           C  
ATOM     97  C   ASN A  14      -0.152  12.902 -12.187  1.00 30.87           C  
ATOM     98  O   ASN A  14       0.532  13.347 -13.105  1.00 31.86           O  
ATOM     99  CB  ASN A  14       0.463  14.584 -10.419  1.00 33.25           C  
ATOM    100  CG  ASN A  14       1.628  13.682 -10.027  1.00 36.23           C  
ATOM    101  OD1 ASN A  14       1.467  12.487  -9.777  1.00 33.58           O  
ATOM    102  ND2 ASN A  14       2.821  14.272  -9.964  1.00 40.85           N  
ATOM    103  N   GLY A  15      -0.465  11.609 -12.063  1.00 29.82           N  
ATOM    104  CA  GLY A  15      -0.039  10.643 -13.052  1.00 29.71           C  
ATOM    105  C   GLY A  15       1.194   9.831 -12.693  1.00 31.22           C  
ATOM    106  O   GLY A  15       1.504   8.881 -13.395  1.00 31.86           O  
ATOM    107  N   SER A  16       1.918  10.203 -11.643  1.00 29.26           N  
ATOM    108  CA  SER A  16       3.093   9.417 -11.279  1.00 31.67           C  
ATOM    109  C   SER A  16       2.683   8.245 -10.384  1.00 32.37           C  
ATOM    110  O   SER A  16       1.629   8.266  -9.751  1.00 30.12           O  
ATOM    111  CB  SER A  16       4.127  10.282 -10.556  1.00 33.04           C  
ATOM    112  OG  SER A  16       3.611  10.781  -9.344  1.00 35.14           O  
ATOM    113  N   THR A  17       3.508   7.206 -10.363  1.00 33.12           N  
ATOM    114  CA  THR A  17       3.234   6.049  -9.535  1.00 34.04           C  
ATOM    115  C   THR A  17       4.551   5.568  -8.965  1.00 35.88           C  
ATOM    116  O   THR A  17       5.602   5.675  -9.607  1.00 35.51           O  
ATOM    117  CB  THR A  17       2.629   4.890 -10.339  1.00 36.13           C  
ATOM    118  OG1 THR A  17       3.523   4.543 -11.402  1.00 42.40           O  
ATOM    119  CG2 THR A  17       1.286   5.275 -10.926  1.00 38.03           C  
ATOM    120  N   GLN A  18       4.518   5.083  -7.736  1.00 34.79           N  
ATOM    121  CA  GLN A  18       5.731   4.534  -7.163  1.00 34.12           C  
ATOM    122  C   GLN A  18       5.311   3.240  -6.485  1.00 33.71           C  
ATOM    123  O   GLN A  18       4.121   3.037  -6.199  1.00 33.01           O  
ATOM    124  CB  GLN A  18       6.398   5.523  -6.206  1.00 36.94           C  
ATOM    125  CG  GLN A  18       5.807   5.671  -4.836  1.00 44.13           C  
ATOM    126  CD  GLN A  18       6.690   6.541  -3.939  1.00 49.95           C  
ATOM    127  OE1 GLN A  18       6.933   7.718  -4.238  1.00 52.29           O  
ATOM    128  NE2 GLN A  18       7.186   5.961  -2.836  1.00 52.55           N  
ATOM    129  N   THR A  19       6.265   2.338  -6.283  1.00 30.28           N  
ATOM    130  CA  THR A  19       5.956   1.066  -5.653  1.00 31.79           C  
ATOM    131  C   THR A  19       6.878   0.850  -4.461  1.00 32.30           C  
ATOM    132  O   THR A  19       8.015   1.333  -4.428  1.00 32.92           O  
ATOM    133  CB  THR A  19       6.138  -0.107  -6.637  1.00 34.63           C  
ATOM    134  OG1 THR A  19       7.514  -0.172  -7.035  1.00 41.65           O  
ATOM    135  CG2 THR A  19       5.270   0.088  -7.886  1.00 36.83           C  
ATOM    136  N   ALA A  20       6.363   0.156  -3.461  1.00 29.33           N  
ATOM    137  CA  ALA A  20       7.143  -0.139  -2.270  1.00 28.81           C  
ATOM    138  C   ALA A  20       6.767  -1.571  -1.952  1.00 28.07           C  
ATOM    139  O   ALA A  20       5.659  -2.007  -2.266  1.00 26.20           O  
ATOM    140  CB  ALA A  20       6.740   0.796  -1.124  1.00 28.15           C  
ATOM    141  N   GLU A  21       7.684  -2.306  -1.341  1.00 26.41           N  
ATOM    142  CA  GLU A  21       7.419  -3.694  -0.997  1.00 26.12           C  
ATOM    143  C   GLU A  21       7.721  -3.901   0.484  1.00 25.70           C  
ATOM    144  O   GLU A  21       8.697  -3.352   1.000  1.00 24.02           O  
ATOM    145  CB  GLU A  21       8.286  -4.594  -1.864  1.00 27.92           C  
ATOM    146  CG  GLU A  21       8.183  -6.054  -1.528  1.00 36.79           C  
ATOM    147  CD  GLU A  21       8.947  -6.905  -2.526  1.00 41.39           C  
ATOM    148  OE1 GLU A  21       8.577  -6.880  -3.722  1.00 42.96           O  
ATOM    149  OE2 GLU A  21       9.920  -7.578  -2.110  1.00 45.82           O  
ATOM    150  N   PHE A  22       6.863  -4.667   1.146  1.00 22.88           N  
ATOM    151  CA  PHE A  22       6.981  -4.936   2.577  1.00 24.72           C  
ATOM    152  C   PHE A  22       6.808  -6.428   2.839  1.00 26.90           C  
ATOM    153  O   PHE A  22       6.004  -7.086   2.179  1.00 28.23           O  
ATOM    154  CB  PHE A  22       5.871  -4.194   3.332  1.00 24.02           C  
ATOM    155  CG  PHE A  22       5.796  -2.726   3.022  1.00 26.22           C  
ATOM    156  CD1 PHE A  22       5.055  -2.266   1.947  1.00 27.30           C  
ATOM    157  CD2 PHE A  22       6.471  -1.802   3.809  1.00 27.82           C  
ATOM    158  CE1 PHE A  22       4.989  -0.898   1.663  1.00 29.83           C  
ATOM    159  CE2 PHE A  22       6.410  -0.439   3.534  1.00 29.01           C  
ATOM    160  CZ  PHE A  22       5.668   0.012   2.459  1.00 29.12           C  
ATOM    161  N   LYS A  23       7.557  -6.967   3.796  1.00 27.17           N  
ATOM    162  CA  LYS A  23       7.420  -8.371   4.157  1.00 29.02           C  
ATOM    163  C   LYS A  23       7.381  -8.457   5.669  1.00 29.92           C  
ATOM    164  O   LYS A  23       8.175  -7.807   6.355  1.00 27.80           O  
ATOM    165  CB  LYS A  23       8.582  -9.205   3.608  1.00 31.87           C  
ATOM    166  CG  LYS A  23       8.618  -9.251   2.085  1.00 37.71           C  
ATOM    167  CD  LYS A  23       9.598 -10.299   1.556  1.00 44.29           C  
ATOM    168  CE  LYS A  23      11.052  -9.883   1.738  1.00 45.88           C  
ATOM    169  NZ  LYS A  23      11.972 -10.947   1.223  1.00 50.07           N  
ATOM    170  N   GLY A  24       6.432  -9.238   6.178  1.00 29.63           N  
ATOM    171  CA  GLY A  24       6.277  -9.426   7.616  1.00 30.30           C  
ATOM    172  C   GLY A  24       5.049 -10.283   7.856  1.00 31.46           C  
ATOM    173  O   GLY A  24       4.498 -10.832   6.906  1.00 31.37           O  
ATOM    174  N   THR A  25       4.611 -10.405   9.100  1.00 32.12           N  
ATOM    175  CA  THR A  25       3.432 -11.201   9.390  1.00 34.34           C  
ATOM    176  C   THR A  25       2.209 -10.437   8.875  1.00 34.85           C  
ATOM    177  O   THR A  25       2.090  -9.222   9.052  1.00 30.87           O  
ATOM    178  CB  THR A  25       3.327 -11.502  10.898  1.00 36.42           C  
ATOM    179  OG1 THR A  25       3.282 -10.280  11.640  1.00 41.33           O  
ATOM    180  CG2 THR A  25       4.549 -12.302  11.347  1.00 39.82           C  
ATOM    181  N   LYS A  26       1.311 -11.171   8.227  1.00 34.63           N  
ATOM    182  CA  LYS A  26       0.128 -10.608   7.593  1.00 35.93           C  
ATOM    183  C   LYS A  26      -0.647  -9.503   8.318  1.00 34.44           C  
ATOM    184  O   LYS A  26      -0.807  -8.406   7.771  1.00 31.50           O  
ATOM    185  CB  LYS A  26      -0.834 -11.740   7.208  1.00 38.77           C  
ATOM    186  CG  LYS A  26      -1.996 -11.287   6.337  1.00 41.61           C  
ATOM    187  CD  LYS A  26      -2.932 -12.459   6.018  1.00 44.56           C  
ATOM    188  CE  LYS A  26      -4.193 -11.974   5.304  1.00 48.22           C  
ATOM    189  NZ  LYS A  26      -5.108 -13.092   4.897  1.00 48.97           N  
ATOM    190  N   GLU A  27      -1.129  -9.787   9.523  1.00 32.14           N  
ATOM    191  CA  GLU A  27      -1.915  -8.823  10.289  1.00 33.96           C  
ATOM    192  C   GLU A  27      -1.200  -7.519  10.526  1.00 32.39           C  
ATOM    193  O   GLU A  27      -1.722  -6.444  10.231  1.00 32.85           O  
ATOM    194  CB  GLU A  27      -2.313  -9.407  11.649  1.00 37.59           C  
ATOM    195  CG  GLU A  27      -3.688 -10.058  11.643  1.00 46.05           C  
ATOM    196  CD  GLU A  27      -4.050 -10.697  12.980  1.00 49.52           C  
ATOM    197  OE1 GLU A  27      -3.394 -10.382  14.009  1.00 49.71           O  
ATOM    198  OE2 GLU A  27      -5.004 -11.514  13.002  1.00 52.83           O  
ATOM    199  N   LYS A  28       0.006  -7.625  11.059  1.00 31.93           N  
ATOM    200  CA  LYS A  28       0.803  -6.460  11.374  1.00 32.43           C  
ATOM    201  C   LYS A  28       1.223  -5.681  10.129  1.00 30.16           C  
ATOM    202  O   LYS A  28       1.083  -4.460  10.084  1.00 29.13           O  
ATOM    203  CB  LYS A  28       2.029  -6.898  12.187  1.00 34.28           C  
ATOM    204  CG  LYS A  28       2.870  -5.764  12.751  1.00 40.22           C  
ATOM    205  CD  LYS A  28       3.804  -6.302  13.840  1.00 44.55           C  
ATOM    206  CE  LYS A  28       5.207  -5.714  13.749  1.00 46.17           C  
ATOM    207  NZ  LYS A  28       5.272  -4.251  14.008  1.00 48.27           N  
ATOM    208  N   ALA A  29       1.708  -6.382   9.110  1.00 27.39           N  
ATOM    209  CA  ALA A  29       2.154  -5.716   7.892  1.00 28.10           C  
ATOM    210  C   ALA A  29       1.079  -4.872   7.208  1.00 28.10           C  
ATOM    211  O   ALA A  29       1.349  -3.741   6.796  1.00 26.47           O  
ATOM    212  CB  ALA A  29       2.716  -6.749   6.907  1.00 27.74           C  
ATOM    213  N   LEU A  30      -0.131  -5.413   7.080  1.00 26.88           N  
ATOM    214  CA  LEU A  30      -1.225  -4.680   6.430  1.00 29.40           C  
ATOM    215  C   LEU A  30      -1.566  -3.407   7.187  1.00 27.57           C  
ATOM    216  O   LEU A  30      -1.746  -2.340   6.599  1.00 26.41           O  
ATOM    217  CB  LEU A  30      -2.481  -5.547   6.348  1.00 32.99           C  
ATOM    218  CG  LEU A  30      -2.615  -6.466   5.142  1.00 36.22           C  
ATOM    219  CD1 LEU A  30      -3.797  -7.409   5.372  1.00 40.82           C  
ATOM    220  CD2 LEU A  30      -2.831  -5.633   3.885  1.00 37.92           C  
ATOM    221  N   SER A  31      -1.681  -3.534   8.501  1.00 24.60           N  
ATOM    222  CA  SER A  31      -1.986  -2.389   9.332  1.00 25.39           C  
ATOM    223  C   SER A  31      -0.910  -1.310   9.169  1.00 24.18           C  
ATOM    224  O   SER A  31      -1.214  -0.113   9.090  1.00 22.08           O  
ATOM    225  CB  SER A  31      -2.069  -2.838  10.794  1.00 27.87           C  
ATOM    226  OG  SER A  31      -2.311  -1.738  11.639  1.00 32.90           O  
ATOM    227  N   GLU A  32       0.352  -1.738   9.125  1.00 24.25           N  
ATOM    228  CA  GLU A  32       1.475  -0.817   8.989  1.00 23.40           C  
ATOM    229  C   GLU A  32       1.493  -0.083   7.657  1.00 23.14           C  
ATOM    230  O   GLU A  32       1.801   1.118   7.599  1.00 22.31           O  
ATOM    231  CB  GLU A  32       2.792  -1.576   9.178  1.00 26.95           C  
ATOM    232  CG  GLU A  32       3.044  -1.961  10.646  1.00 30.67           C  
ATOM    233  CD  GLU A  32       4.180  -2.969  10.818  1.00 32.44           C  
ATOM    234  OE1 GLU A  32       4.738  -3.453   9.820  1.00 34.37           O  
ATOM    235  OE2 GLU A  32       4.511  -3.282  11.970  1.00 35.46           O  
ATOM    236  N   VAL A  33       1.164  -0.795   6.582  1.00 23.68           N  
ATOM    237  CA  VAL A  33       1.144  -0.159   5.277  1.00 23.84           C  
ATOM    238  C   VAL A  33       0.022   0.879   5.247  1.00 24.87           C  
ATOM    239  O   VAL A  33       0.199   1.972   4.708  1.00 26.88           O  
ATOM    240  CB  VAL A  33       0.948  -1.190   4.143  1.00 26.18           C  
ATOM    241  CG1 VAL A  33       0.752  -0.464   2.822  1.00 28.44           C  
ATOM    242  CG2 VAL A  33       2.162  -2.100   4.055  1.00 27.98           C  
ATOM    243  N   LEU A  34      -1.133   0.575   5.825  1.00 23.51           N  
ATOM    244  CA  LEU A  34      -2.207   1.584   5.822  1.00 23.56           C  
ATOM    245  C   LEU A  34      -1.814   2.832   6.619  1.00 23.95           C  
ATOM    246  O   LEU A  34      -2.164   3.955   6.233  1.00 23.89           O  
ATOM    247  CB  LEU A  34      -3.515   1.016   6.384  1.00 26.24           C  
ATOM    248  CG  LEU A  34      -4.525   0.474   5.362  1.00 31.31           C  
ATOM    249  CD1 LEU A  34      -3.877  -0.555   4.494  1.00 32.52           C  
ATOM    250  CD2 LEU A  34      -5.714  -0.127   6.103  1.00 34.09           C  
ATOM    251  N   ALA A  35      -1.110   2.643   7.735  1.00 24.06           N  
ATOM    252  CA  ALA A  35      -0.669   3.779   8.543  1.00 24.68           C  
ATOM    253  C   ALA A  35       0.305   4.638   7.736  1.00 25.43           C  
ATOM    254  O   ALA A  35       0.318   5.860   7.864  1.00 26.23           O  
ATOM    255  CB  ALA A  35       0.003   3.291   9.837  1.00 25.37           C  
ATOM    256  N   TYR A  36       1.125   4.001   6.906  1.00 25.47           N  
ATOM    257  CA  TYR A  36       2.075   4.734   6.067  1.00 26.37           C  
ATOM    258  C   TYR A  36       1.318   5.503   4.982  1.00 26.83           C  
ATOM    259  O   TYR A  36       1.623   6.672   4.695  1.00 25.44           O  
ATOM    260  CB  TYR A  36       3.090   3.766   5.441  1.00 27.14           C  
ATOM    261  CG  TYR A  36       3.971   4.420   4.395  1.00 31.21           C  
ATOM    262  CD1 TYR A  36       4.871   5.431   4.745  1.00 29.47           C  
ATOM    263  CD2 TYR A  36       3.871   4.059   3.051  1.00 30.57           C  
ATOM    264  CE1 TYR A  36       5.650   6.074   3.764  1.00 32.82           C  
ATOM    265  CE2 TYR A  36       4.642   4.696   2.068  1.00 34.18           C  
ATOM    266  CZ  TYR A  36       5.520   5.699   2.439  1.00 33.61           C  
ATOM    267  OH  TYR A  36       6.252   6.348   1.478  1.00 38.83           O  
ATOM    268  N   ALA A  37       0.310   4.861   4.399  1.00 25.13           N  
ATOM    269  CA  ALA A  37      -0.494   5.510   3.366  1.00 25.19           C  
ATOM    270  C   ALA A  37      -1.100   6.782   3.952  1.00 24.92           C  
ATOM    271  O   ALA A  37      -1.219   7.797   3.271  1.00 26.39           O  
ATOM    272  CB  ALA A  37      -1.619   4.591   2.904  1.00 23.55           C  
ATOM    273  N   ASP A  38      -1.494   6.711   5.220  1.00 25.80           N  
ATOM    274  CA  ASP A  38      -2.082   7.867   5.877  1.00 28.73           C  
ATOM    275  C   ASP A  38      -1.111   9.050   5.930  1.00 29.03           C  
ATOM    276  O   ASP A  38      -1.542  10.192   5.814  1.00 29.13           O  
ATOM    277  CB  ASP A  38      -2.561   7.517   7.297  1.00 28.22           C  
ATOM    278  CG  ASP A  38      -3.923   6.827   7.316  1.00 30.60           C  
ATOM    279  OD1 ASP A  38      -4.630   6.846   6.285  1.00 29.35           O  
ATOM    280  OD2 ASP A  38      -4.295   6.264   8.375  1.00 30.14           O  
ATOM    281  N   THR A  39       0.188   8.799   6.087  1.00 29.97           N  
ATOM    282  CA  THR A  39       1.143   9.919   6.131  1.00 31.87           C  
ATOM    283  C   THR A  39       1.242  10.642   4.773  1.00 32.92           C  
ATOM    284  O   THR A  39       1.693  11.785   4.704  1.00 32.91           O  
ATOM    285  CB  THR A  39       2.581   9.473   6.516  1.00 33.36           C  
ATOM    286  OG1 THR A  39       3.165   8.748   5.426  1.00 35.91           O  
ATOM    287  CG2 THR A  39       2.576   8.601   7.774  1.00 34.46           C  
ATOM    288  N   LEU A  40       0.829   9.980   3.698  1.00 31.74           N  
ATOM    289  CA  LEU A  40       0.908  10.578   2.367  1.00 32.74           C  
ATOM    290  C   LEU A  40      -0.288  11.468   2.025  1.00 32.94           C  
ATOM    291  O   LEU A  40      -0.242  12.234   1.069  1.00 33.20           O  
ATOM    292  CB  LEU A  40       1.041   9.472   1.307  1.00 32.92           C  
ATOM    293  CG  LEU A  40       2.381   8.738   1.323  1.00 35.42           C  
ATOM    294  CD1 LEU A  40       2.391   7.555   0.353  1.00 34.99           C  
ATOM    295  CD2 LEU A  40       3.463   9.745   0.958  1.00 36.78           C  
ATOM    296  N   LYS A  41      -1.354  11.367   2.808  1.00 34.01           N  
ATOM    297  CA  LYS A  41      -2.556  12.153   2.553  1.00 36.99           C  
ATOM    298  C   LYS A  41      -2.398  13.673   2.529  1.00 38.42           C  
ATOM    299  O   LYS A  41      -3.009  14.345   1.704  1.00 38.24           O  
ATOM    300  CB  LYS A  41      -3.641  11.787   3.557  1.00 37.13           C  
ATOM    301  CG  LYS A  41      -4.337  10.469   3.262  1.00 39.16           C  
ATOM    302  CD  LYS A  41      -5.089  10.007   4.506  1.00 42.77           C  
ATOM    303  CE  LYS A  41      -5.981  11.092   5.070  1.00 45.74           C  
ATOM    304  NZ  LYS A  41      -6.903  10.541   6.103  1.00 46.77           N  
ATOM    305  N   LYS A  42      -1.589  14.217   3.432  1.00 40.29           N  
ATOM    306  CA  LYS A  42      -1.406  15.660   3.482  1.00 42.51           C  
ATOM    307  C   LYS A  42      -0.953  16.244   2.148  1.00 43.71           C  
ATOM    308  O   LYS A  42      -1.500  17.245   1.691  1.00 44.88           O  
ATOM    309  CB  LYS A  42      -0.385  16.005   4.549  1.00 45.57           C  
ATOM    310  N   ASP A  43       0.027  15.622   1.502  1.00 43.10           N  
ATOM    311  CA  ASP A  43       0.508  16.129   0.224  1.00 43.10           C  
ATOM    312  C   ASP A  43      -0.149  15.549  -1.025  1.00 43.08           C  
ATOM    313  O   ASP A  43      -0.011  16.113  -2.117  1.00 41.77           O  
ATOM    314  CB  ASP A  43       2.021  15.924   0.123  1.00 46.64           C  
ATOM    315  CG  ASP A  43       2.801  16.879   1.011  1.00 50.81           C  
ATOM    316  OD1 ASP A  43       2.914  16.629   2.230  1.00 53.21           O  
ATOM    317  OD2 ASP A  43       3.302  17.895   0.482  1.00 55.02           O  
ATOM    318  N   ASN A  44      -0.880  14.446  -0.875  1.00 39.36           N  
ATOM    319  CA  ASN A  44      -1.461  13.816  -2.040  1.00 37.16           C  
ATOM    320  C   ASN A  44      -2.964  13.571  -2.056  1.00 35.46           C  
ATOM    321  O   ASN A  44      -3.481  13.037  -3.037  1.00 34.60           O  
ATOM    322  CB  ASN A  44      -0.728  12.500  -2.300  1.00 38.61           C  
ATOM    323  CG  ASN A  44       0.783  12.675  -2.336  1.00 40.49           C  
ATOM    324  OD1 ASN A  44       1.480  12.424  -1.348  1.00 41.18           O  
ATOM    325  ND2 ASN A  44       1.293  13.124  -3.473  1.00 41.53           N  
ATOM    326  N   GLY A  45      -3.669  13.955  -0.993  1.00 32.58           N  
ATOM    327  CA  GLY A  45      -5.103  13.733  -0.971  1.00 31.26           C  
ATOM    328  C   GLY A  45      -5.546  12.410  -0.356  1.00 31.71           C  
ATOM    329  O   GLY A  45      -4.719  11.582   0.052  1.00 30.36           O  
ATOM    330  N   GLU A  46      -6.858  12.212  -0.289  1.00 31.25           N  
ATOM    331  CA  GLU A  46      -7.436  10.995   0.293  1.00 31.65           C  
ATOM    332  C   GLU A  46      -7.147   9.783  -0.570  1.00 29.75           C  
ATOM    333  O   GLU A  46      -7.161   9.875  -1.794  1.00 28.68           O  
ATOM    334  CB  GLU A  46      -8.958  11.135   0.416  1.00 34.98           C  
ATOM    335  CG  GLU A  46      -9.408  12.349   1.225  1.00 40.58           C  
ATOM    336  CD  GLU A  46      -9.126  12.203   2.705  1.00 45.12           C  
ATOM    337  OE1 GLU A  46      -9.080  11.049   3.196  1.00 45.88           O  
ATOM    338  OE2 GLU A  46      -8.960  13.247   3.382  1.00 48.44           O  
ATOM    339  N   TRP A  47      -6.928   8.638   0.067  1.00 27.28           N  
ATOM    340  CA  TRP A  47      -6.667   7.414  -0.677  1.00 26.43           C  
ATOM    341  C   TRP A  47      -7.852   6.448  -0.685  1.00 26.25           C  
ATOM    342  O   TRP A  47      -8.785   6.534   0.131  1.00 24.48           O  
ATOM    343  CB  TRP A  47      -5.420   6.675  -0.140  1.00 26.62           C  
ATOM    344  CG  TRP A  47      -5.388   6.348   1.377  1.00 25.35           C  
ATOM    345  CD1 TRP A  47      -4.642   6.986   2.330  1.00 26.01           C  
ATOM    346  CD2 TRP A  47      -6.080   5.285   2.064  1.00 26.66           C  
ATOM    347  NE1 TRP A  47      -4.812   6.393   3.557  1.00 25.20           N  
ATOM    348  CE2 TRP A  47      -5.690   5.348   3.430  1.00 26.88           C  
ATOM    349  CE3 TRP A  47      -6.986   4.291   1.664  1.00 25.97           C  
ATOM    350  CZ2 TRP A  47      -6.181   4.457   4.393  1.00 24.79           C  
ATOM    351  CZ3 TRP A  47      -7.479   3.400   2.628  1.00 26.06           C  
ATOM    352  CH2 TRP A  47      -7.068   3.496   3.981  1.00 26.76           C  
ATOM    353  N   THR A  48      -7.815   5.546  -1.655  1.00 24.59           N  
ATOM    354  CA  THR A  48      -8.802   4.495  -1.804  1.00 25.80           C  
ATOM    355  C   THR A  48      -7.927   3.282  -2.102  1.00 26.40           C  
ATOM    356  O   THR A  48      -6.957   3.389  -2.856  1.00 26.86           O  
ATOM    357  CB  THR A  48      -9.757   4.781  -2.996  1.00 28.39           C  
ATOM    358  OG1 THR A  48     -10.560   5.938  -2.698  1.00 29.86           O  
ATOM    359  CG2 THR A  48     -10.676   3.598  -3.226  1.00 32.56           C  
ATOM    360  N   ILE A  49      -8.251   2.138  -1.516  1.00 22.78           N  
ATOM    361  CA  ILE A  49      -7.464   0.940  -1.724  1.00 24.52           C  
ATOM    362  C   ILE A  49      -8.258  -0.255  -2.224  1.00 24.57           C  
ATOM    363  O   ILE A  49      -9.416  -0.435  -1.859  1.00 24.51           O  
ATOM    364  CB  ILE A  49      -6.753   0.523  -0.393  1.00 26.72           C  
ATOM    365  CG1 ILE A  49      -5.582   1.456  -0.129  1.00 28.32           C  
ATOM    366  CG2 ILE A  49      -6.261  -0.931  -0.446  1.00 29.51           C  
ATOM    367  CD1 ILE A  49      -4.979   1.288   1.242  1.00 30.43           C  
ATOM    368  N   ASP A  50      -7.638  -1.054  -3.087  1.00 25.06           N  
ATOM    369  CA  ASP A  50      -8.253  -2.297  -3.539  1.00 26.75           C  
ATOM    370  C   ASP A  50      -7.117  -3.319  -3.408  1.00 27.01           C  
ATOM    371  O   ASP A  50      -5.922  -2.964  -3.413  1.00 26.69           O  
ATOM    372  CB  ASP A  50      -8.842  -2.203  -4.968  1.00 28.48           C  
ATOM    373  CG  ASP A  50      -7.806  -1.871  -6.025  1.00 29.88           C  
ATOM    374  OD1 ASP A  50      -7.004  -2.755  -6.373  1.00 32.87           O  
ATOM    375  OD2 ASP A  50      -7.799  -0.721  -6.513  1.00 32.25           O  
ATOM    376  N   LYS A  51      -7.495  -4.578  -3.258  1.00 25.52           N  
ATOM    377  CA  LYS A  51      -6.541  -5.649  -2.998  1.00 28.87           C  
ATOM    378  C   LYS A  51      -6.696  -6.844  -3.909  1.00 30.00           C  
ATOM    379  O   LYS A  51      -7.807  -7.220  -4.290  1.00 27.09           O  
ATOM    380  CB  LYS A  51      -6.728  -6.112  -1.544  1.00 29.64           C  
ATOM    381  CG  LYS A  51      -5.918  -7.321  -1.091  1.00 32.86           C  
ATOM    382  CD  LYS A  51      -6.140  -7.581   0.412  1.00 36.75           C  
ATOM    383  CE  LYS A  51      -7.504  -8.237   0.709  1.00 37.38           C  
ATOM    384  NZ  LYS A  51      -7.569  -9.680   0.316  1.00 35.45           N  
ATOM    385  N   ARG A  52      -5.563  -7.439  -4.249  1.00 29.74           N  
ATOM    386  CA  ARG A  52      -5.551  -8.634  -5.067  1.00 31.68           C  
ATOM    387  C   ARG A  52      -4.459  -9.548  -4.509  1.00 33.36           C  
ATOM    388  O   ARG A  52      -3.389  -9.081  -4.115  1.00 32.33           O  
ATOM    389  CB  ARG A  52      -5.239  -8.268  -6.524  1.00 31.86           C  
ATOM    390  N   VAL A  53      -4.725 -10.844  -4.432  1.00 35.18           N  
ATOM    391  CA  VAL A  53      -3.693 -11.757  -3.966  1.00 39.36           C  
ATOM    392  C   VAL A  53      -3.297 -12.545  -5.205  1.00 42.94           C  
ATOM    393  O   VAL A  53      -4.016 -13.463  -5.615  1.00 43.75           O  
ATOM    394  CB  VAL A  53      -4.210 -12.728  -2.895  1.00 39.65           C  
ATOM    395  CG1 VAL A  53      -3.092 -13.666  -2.477  1.00 43.07           C  
ATOM    396  CG2 VAL A  53      -4.717 -11.954  -1.689  1.00 40.79           C  
ATOM    397  N   THR A  54      -2.178 -12.167  -5.814  1.00 45.33           N  
ATOM    398  CA  THR A  54      -1.715 -12.833  -7.030  1.00 48.36           C  
ATOM    399  C   THR A  54      -0.457 -13.663  -6.798  1.00 48.88           C  
ATOM    400  O   THR A  54       0.582 -13.137  -6.388  1.00 48.92           O  
ATOM    401  CB  THR A  54      -1.415 -11.817  -8.147  1.00 49.15           C  
ATOM    402  OG1 THR A  54      -0.328 -10.975  -7.744  1.00 53.44           O  
ATOM    403  CG2 THR A  54      -2.636 -10.946  -8.430  1.00 50.83           C  
ATOM    404  N   ASN A  55      -0.557 -14.961  -7.063  1.00 50.59           N  
ATOM    405  CA  ASN A  55       0.576 -15.869  -6.896  1.00 51.15           C  
ATOM    406  C   ASN A  55       1.207 -15.738  -5.508  1.00 50.76           C  
ATOM    407  O   ASN A  55       2.431 -15.652  -5.381  1.00 50.54           O  
ATOM    408  CB  ASN A  55       1.627 -15.588  -7.985  1.00 52.52           C  
ATOM    409  CG  ASN A  55       1.176 -16.046  -9.377  1.00 54.11           C  
ATOM    410  OD1 ASN A  55       1.677 -15.560 -10.399  1.00 53.98           O  
ATOM    411  ND2 ASN A  55       0.243 -16.997  -9.420  1.00 53.72           N  
ATOM    412  N   GLY A  56       0.365 -15.707  -4.476  1.00 50.52           N  
ATOM    413  CA  GLY A  56       0.855 -15.609  -3.109  1.00 48.32           C  
ATOM    414  C   GLY A  56       1.202 -14.219  -2.590  1.00 47.05           C  
ATOM    415  O   GLY A  56       1.309 -14.019  -1.381  1.00 47.75           O  
ATOM    416  N   VAL A  57       1.384 -13.255  -3.485  1.00 43.98           N  
ATOM    417  CA  VAL A  57       1.726 -11.899  -3.071  1.00 40.37           C  
ATOM    418  C   VAL A  57       0.483 -11.015  -2.935  1.00 37.97           C  
ATOM    419  O   VAL A  57      -0.409 -11.042  -3.791  1.00 37.26           O  
ATOM    420  CB  VAL A  57       2.699 -11.260  -4.088  1.00 40.56           C  
ATOM    421  CG1 VAL A  57       2.973  -9.811  -3.728  1.00 41.01           C  
ATOM    422  CG2 VAL A  57       4.000 -12.060  -4.116  1.00 42.36           C  
ATOM    423  N   ILE A  58       0.414 -10.243  -1.854  1.00 33.28           N  
ATOM    424  CA  ILE A  58      -0.719  -9.339  -1.652  1.00 30.57           C  
ATOM    425  C   ILE A  58      -0.406  -8.038  -2.385  1.00 31.56           C  
ATOM    426  O   ILE A  58       0.592  -7.361  -2.085  1.00 31.36           O  
ATOM    427  CB  ILE A  58      -0.950  -9.013  -0.161  1.00 30.67           C  
ATOM    428  CG1 ILE A  58      -1.312 -10.294   0.599  1.00 31.57           C  
ATOM    429  CG2 ILE A  58      -2.064  -7.956  -0.015  1.00 26.91           C  
ATOM    430  CD1 ILE A  58      -1.480 -10.085   2.118  1.00 33.78           C  
ATOM    431  N   ILE A  59      -1.246  -7.695  -3.352  1.00 29.36           N  
ATOM    432  CA  ILE A  59      -1.047  -6.473  -4.123  1.00 30.51           C  
ATOM    433  C   ILE A  59      -2.050  -5.431  -3.660  1.00 28.94           C  
ATOM    434  O   ILE A  59      -3.252  -5.674  -3.690  1.00 29.02           O  
ATOM    435  CB  ILE A  59      -1.285  -6.698  -5.642  1.00 32.10           C  
ATOM    436  CG1 ILE A  59      -0.375  -7.815  -6.166  1.00 36.41           C  
ATOM    437  CG2 ILE A  59      -1.032  -5.393  -6.398  1.00 34.56           C  
ATOM    438  CD1 ILE A  59       1.074  -7.456  -6.258  1.00 38.53           C  
ATOM    439  N   LEU A  60      -1.556  -4.280  -3.225  1.00 26.77           N  
ATOM    440  CA  LEU A  60      -2.417  -3.196  -2.785  1.00 26.72           C  
ATOM    441  C   LEU A  60      -2.282  -2.017  -3.741  1.00 27.18           C  
ATOM    442  O   LEU A  60      -1.172  -1.503  -3.954  1.00 27.53           O  
ATOM    443  CB  LEU A  60      -2.017  -2.696  -1.393  1.00 27.86           C  
ATOM    444  CG  LEU A  60      -2.306  -3.587  -0.190  1.00 30.56           C  
ATOM    445  CD1 LEU A  60      -1.953  -2.795   1.078  1.00 31.36           C  
ATOM    446  CD2 LEU A  60      -3.788  -4.000  -0.180  1.00 32.33           C  
ATOM    447  N   ASN A  61      -3.394  -1.592  -4.328  1.00 24.36           N  
ATOM    448  CA  ASN A  61      -3.357  -0.429  -5.197  1.00 24.42           C  
ATOM    449  C   ASN A  61      -3.907   0.691  -4.348  1.00 23.64           C  
ATOM    450  O   ASN A  61      -5.072   0.664  -3.972  1.00 23.32           O  
ATOM    451  CB  ASN A  61      -4.238  -0.621  -6.430  1.00 26.91           C  
ATOM    452  CG  ASN A  61      -3.708  -1.692  -7.332  1.00 31.59           C  
ATOM    453  OD1 ASN A  61      -2.530  -1.689  -7.676  1.00 31.67           O  
ATOM    454  ND2 ASN A  61      -4.561  -2.627  -7.710  1.00 33.64           N  
ATOM    455  N   ILE A  62      -3.063   1.673  -4.063  1.00 23.25           N  
ATOM    456  CA  ILE A  62      -3.429   2.806  -3.225  1.00 25.26           C  
ATOM    457  C   ILE A  62      -3.506   4.034  -4.110  1.00 25.67           C  
ATOM    458  O   ILE A  62      -2.485   4.540  -4.577  1.00 26.06           O  
ATOM    459  CB  ILE A  62      -2.379   2.991  -2.133  1.00 24.79           C  
ATOM    460  CG1 ILE A  62      -2.115   1.626  -1.461  1.00 26.57           C  
ATOM    461  CG2 ILE A  62      -2.851   4.030  -1.132  1.00 26.42           C  
ATOM    462  CD1 ILE A  62      -1.085   1.657  -0.305  1.00 27.54           C  
ATOM    463  N   LYS A  63      -4.726   4.505  -4.333  1.00 25.40           N  
ATOM    464  CA  LYS A  63      -4.948   5.628  -5.239  1.00 28.38           C  
ATOM    465  C   LYS A  63      -5.269   6.889  -4.477  1.00 27.62           C  
ATOM    466  O   LYS A  63      -6.207   6.913  -3.677  1.00 28.79           O  
ATOM    467  CB  LYS A  63      -6.107   5.318  -6.204  1.00 30.50           C  
ATOM    468  CG  LYS A  63      -5.892   4.122  -7.137  1.00 38.60           C  
ATOM    469  CD  LYS A  63      -6.121   2.790  -6.434  1.00 43.80           C  
ATOM    470  CE  LYS A  63      -7.540   2.710  -5.851  1.00 46.80           C  
ATOM    471  NZ  LYS A  63      -7.848   1.406  -5.212  1.00 44.29           N  
ATOM    472  N   PHE A  64      -4.496   7.937  -4.742  1.00 27.89           N  
ATOM    473  CA  PHE A  64      -4.691   9.209  -4.084  1.00 27.71           C  
ATOM    474  C   PHE A  64      -5.486  10.150  -4.997  1.00 31.96           C  
ATOM    475  O   PHE A  64      -5.196  10.266  -6.193  1.00 30.87           O  
ATOM    476  CB  PHE A  64      -3.341   9.807  -3.717  1.00 26.51           C  
ATOM    477  CG  PHE A  64      -2.608   9.020  -2.681  1.00 27.75           C  
ATOM    478  CD1 PHE A  64      -1.781   7.968  -3.041  1.00 25.96           C  
ATOM    479  CD2 PHE A  64      -2.809   9.287  -1.331  1.00 27.43           C  
ATOM    480  CE1 PHE A  64      -1.153   7.179  -2.060  1.00 29.37           C  
ATOM    481  CE2 PHE A  64      -2.195   8.514  -0.346  1.00 28.62           C  
ATOM    482  CZ  PHE A  64      -1.373   7.466  -0.699  1.00 26.86           C  
ATOM    483  N   ALA A  65      -6.478  10.826  -4.419  1.00 33.45           N  
ATOM    484  CA  ALA A  65      -7.369  11.694  -5.188  1.00 35.71           C  
ATOM    485  C   ALA A  65      -6.798  13.043  -5.577  1.00 37.04           C  
ATOM    486  O   ALA A  65      -7.273  13.663  -6.537  1.00 35.15           O  
ATOM    487  CB  ALA A  65      -8.691  11.881  -4.428  1.00 35.51           C  
ATOM    488  N   GLY A  66      -5.778  13.486  -4.846  1.00 37.18           N  
ATOM    489  CA  GLY A  66      -5.162  14.766  -5.126  1.00 41.56           C  
ATOM    490  C   GLY A  66      -5.858  15.879  -4.360  1.00 44.11           C  
ATOM    491  O   GLY A  66      -6.843  15.590  -3.642  1.00 43.46           O  
ATOM    492  OXT GLY A  66      -5.425  17.048  -4.485  1.00 47.84           O  
TER     493      GLY A  66                                                      
END
MOLECULE T0499.pdb
ATOM      1  N   THR     1       5.864 -13.733   4.706  1.00  0.00
ATOM      2  H   THR     1       6.469 -13.084   5.188  1.00  0.00
ATOM      3  CA  THR     1       5.101 -13.239   3.530  1.00  0.00
ATOM      4  HA  THR     1       5.396 -13.812   2.663  1.00  0.00
ATOM      5  CB  THR     1       3.609 -13.450   3.792  1.00  0.00
ATOM      6  HB  THR     1       3.052 -12.679   3.280  1.00  0.00
ATOM      7  QG2 THR     1       2.979 -15.108   3.191  1.00  0.00
ATOM      8  OG1 THR     1       3.325 -13.358   5.177  1.00  0.00
ATOM      9 1HG  THR     1       2.380 -13.444   5.316  1.00  0.00
ATOM     10  CG2 THR     1       3.099 -14.789   3.307  1.00  0.00
ATOM     11 1HG2 THR     1       3.022 -14.776   2.230  1.00  0.00
ATOM     12 2HG2 THR     1       2.127 -14.982   3.735  1.00  0.00
ATOM     13 3HG2 THR     1       3.787 -15.567   3.608  1.00  0.00
ATOM     14  C   THR     1       5.385 -11.763   3.270  1.00  0.00
ATOM     15  O   THR     1       5.571 -10.983   4.205  1.00  0.00
ATOM     16 1HT  THR     1       6.860 -13.827   4.422  1.00  0.00
ATOM     17 2HT  THR     1       5.462 -14.654   4.979  1.00  0.00
ATOM     18 3HT  THR     1       5.757 -13.036   5.469  1.00  0.00
ATOM     19  N   THR     2       5.412 -11.387   1.997  1.00  0.00
ATOM     20  H   THR     2       5.254 -12.054   1.297  1.00  0.00
ATOM     21  CA  THR     2       5.670 -10.003   1.614  1.00  0.00
ATOM     22  HA  THR     2       5.900  -9.449   2.511  1.00  0.00
ATOM     23  CB  THR     2       6.868  -9.930   0.663  1.00  0.00
ATOM     24  HB  THR     2       6.859  -8.972   0.163  1.00  0.00
ATOM     25  QG2 THR     2       8.517 -10.106   1.535  1.00  0.00
ATOM     26  OG1 THR     2       6.791 -10.947  -0.320  1.00  0.00
ATOM     27 1HG  THR     2       6.034 -10.787  -0.888  1.00  0.00
ATOM     28  CG2 THR     2       8.200 -10.072   1.368  1.00  0.00
ATOM     29 1HG2 THR     2       8.613 -11.049   1.165  1.00  0.00
ATOM     30 2HG2 THR     2       8.059  -9.956   2.432  1.00  0.00
ATOM     31 3HG2 THR     2       8.879  -9.313   1.009  1.00  0.00
ATOM     32  C   THR     2       4.443  -9.384   0.953  1.00  0.00
ATOM     33  O   THR     2       3.731 -10.048   0.200  1.00  0.00
ATOM     34  N   TYR     3       4.202  -8.109   1.239  1.00  0.00
ATOM     35  H   TYR     3       4.806  -7.634   1.846  1.00  0.00
ATOM     36  CA  TYR     3       3.059  -7.401   0.674  1.00  0.00
ATOM     37  HA  TYR     3       2.555  -8.072  -0.004  1.00  0.00
ATOM     38  CB  TYR     3       2.088  -6.991   1.783  1.00  0.00
ATOM     39 1HB  TYR     3       1.225  -6.511   1.339  1.00  0.00
ATOM     40 2HB  TYR     3       2.583  -6.293   2.445  1.00  0.00
ATOM     41  QB  TYR     3       1.904  -6.402   1.892  1.00  0.00
ATOM     42  QD  TYR     3       1.541  -8.287   2.711  1.00  0.00
ATOM     43  QE  TYR     3       0.745 -10.173   4.072  1.00  0.00
ATOM     44  QR  TYR     3       1.143  -9.230   3.392  1.00  0.00
ATOM     45  CG  TYR     3       1.598  -8.152   2.617  1.00  0.00
ATOM     46  CD1 TYR     3       2.451  -8.811   3.494  1.00  0.00
ATOM     47 1HD  TYR     3       3.476  -8.482   3.574  1.00  0.00
ATOM     48  CE1 TYR     3       2.007  -9.872   4.260  1.00  0.00
ATOM     49 1HE  TYR     3       2.685 -10.371   4.935  1.00  0.00
ATOM     50  CZ  TYR     3       0.696 -10.287   4.155  1.00  0.00
ATOM     51  CE2 TYR     3      -0.169  -9.651   3.291  1.00  0.00
ATOM     52 2HE  TYR     3      -1.196  -9.976   3.210  1.00  0.00
ATOM     53  CD2 TYR     3       0.281  -8.590   2.529  1.00  0.00
ATOM     54 2HD  TYR     3      -0.394  -8.091   1.849  1.00  0.00
ATOM     55  OH  TYR     3       0.250 -11.344   4.914  1.00  0.00
ATOM     56  HH  TYR     3      -0.633 -11.153   5.242  1.00  0.00
ATOM     57  C   TYR     3       3.514  -6.168  -0.104  1.00  0.00
ATOM     58  O   TYR     3       4.537  -5.562   0.220  1.00  0.00
ATOM     59  N   LYS+    4       2.748  -5.803  -1.130  1.00  0.00
ATOM     60  H   LYS+    4       1.946  -6.329  -1.337  1.00  0.00
ATOM     61  CA  LYS+    4       3.074  -4.643  -1.954  1.00  0.00
ATOM     62  HA  LYS+    4       3.906  -4.132  -1.493  1.00  0.00
ATOM     63  CB  LYS+    4       3.476  -5.086  -3.363  1.00  0.00
ATOM     64 1HB  LYS+    4       2.858  -4.570  -4.084  1.00  0.00
ATOM     65 2HB  LYS+    4       3.309  -6.151  -3.455  1.00  0.00
ATOM     66  QB  LYS+    4       3.083  -5.360  -3.770  1.00  0.00
ATOM     67  CG  LYS+    4       4.932  -4.805  -3.697  1.00  0.00
ATOM     68 1HG  LYS+    4       5.556  -5.203  -2.910  1.00  0.00
ATOM     69 2HG  LYS+    4       5.074  -3.737  -3.768  1.00  0.00
ATOM     70  QG  LYS+    4       5.315  -4.470  -3.339  1.00  0.00
ATOM     71  CD  LYS+    4       5.335  -5.442  -5.017  1.00  0.00
ATOM     72 1HD  LYS+    4       6.099  -4.836  -5.480  1.00  0.00
ATOM     73 2HD  LYS+    4       4.470  -5.491  -5.662  1.00  0.00
ATOM     74  QD  LYS+    4       5.285  -5.163  -5.571  1.00  0.00
ATOM     75  CE  LYS+    4       5.876  -6.849  -4.815  1.00  0.00
ATOM     76 1HE  LYS+    4       5.509  -7.230  -3.872  1.00  0.00
ATOM     77 2HE  LYS+    4       6.955  -6.805  -4.787  1.00  0.00
ATOM     78  QE  LYS+    4       6.232  -7.017  -4.329  1.00  0.00
ATOM     79  NZ  LYS+    4       5.457  -7.769  -5.907  1.00  0.00
ATOM     80 1HZ  LYS+    4       5.531  -8.757  -5.591  1.00  0.00
ATOM     81 2HZ  LYS+    4       6.066  -7.637  -6.740  1.00  0.00
ATOM     82 3HZ  LYS+    4       4.470  -7.576  -6.178  1.00  0.00
ATOM     83  QZ  LYS+    4       5.356  -7.990  -6.169  1.00  0.00
ATOM     84  C   LYS+    4       1.899  -3.676  -2.024  1.00  0.00
ATOM     85  O   LYS+    4       0.742  -4.075  -1.913  1.00  0.00
ATOM     86  N   LEU     5       2.214  -2.398  -2.202  1.00  0.00
ATOM     87  H   LEU     5       3.157  -2.143  -2.278  1.00  0.00
ATOM     88  CA  LEU     5       1.194  -1.365  -2.279  1.00  0.00
ATOM     89  HA  LEU     5       0.246  -1.850  -2.421  1.00  0.00
ATOM     90  CB  LEU     5       1.156  -0.577  -0.966  1.00  0.00
ATOM     91 1HB  LEU     5       2.173  -0.483  -0.604  1.00  0.00
ATOM     92 2HB  LEU     5       0.583  -1.152  -0.248  1.00  0.00
ATOM     93  QB  LEU     5       1.378  -0.817  -0.426  1.00  0.00
ATOM     94  CG  LEU     5       0.537   0.824  -1.052  1.00  0.00
ATOM     95  HG  LEU     5       1.143   1.438  -1.704  1.00  0.00
ATOM     96  QD1 LEU     5      -1.195   0.739  -1.778  1.00  0.00
ATOM     97  QD2 LEU     5       0.494   1.639   0.643  1.00  0.00
ATOM     98  CD1 LEU     5      -0.863   0.755  -1.640  1.00  0.00
ATOM     99 1HD1 LEU     5      -1.034   1.618  -2.267  1.00  0.00
ATOM    100 2HD1 LEU     5      -1.588   0.743  -0.839  1.00  0.00
ATOM    101 3HD1 LEU     5      -0.963  -0.144  -2.228  1.00  0.00
ATOM    102  CD2 LEU     5       0.503   1.482   0.319  1.00  0.00
ATOM    103 1HD2 LEU     5       0.503   0.721   1.083  1.00  0.00
ATOM    104 2HD2 LEU     5      -0.393   2.083   0.407  1.00  0.00
ATOM    105 3HD2 LEU     5       1.372   2.113   0.438  1.00  0.00
ATOM    106  QQD LEU     5      -0.350   1.189  -0.568  1.00  0.00
ATOM    107  C   LEU     5       1.448  -0.426  -3.458  1.00  0.00
ATOM    108  O   LEU     5       2.553   0.089  -3.628  1.00  0.00
ATOM    109  N   ILE     6       0.414  -0.210  -4.264  1.00  0.00
ATOM    110  H   ILE     6      -0.441  -0.647  -4.073  1.00  0.00
ATOM    111  CA  ILE     6       0.518   0.669  -5.423  1.00  0.00
ATOM    112  HA  ILE     6       1.564   0.833  -5.623  1.00  0.00
ATOM    113  CB  ILE     6      -0.116   0.026  -6.673  1.00  0.00
ATOM    114  HB  ILE     6      -1.166  -0.085  -6.497  1.00  0.00
ATOM    115  QG2 ILE     6       0.114   1.131  -8.180  1.00  0.00
ATOM    116  CG2 ILE     6       0.070   0.920  -7.892  1.00  0.00
ATOM    117 1HG2 ILE     6      -0.857   0.974  -8.442  1.00  0.00
ATOM    118 2HG2 ILE     6       0.842   0.509  -8.525  1.00  0.00
ATOM    119 3HG2 ILE     6       0.358   1.910  -7.571  1.00  0.00
ATOM    120  CG1 ILE     6       0.490  -1.352  -6.921  1.00  0.00
ATOM    121 1HG1 ILE     6      -0.010  -1.815  -7.759  1.00  0.00
ATOM    122 2HG1 ILE     6       0.353  -1.965  -6.041  1.00  0.00
ATOM    123  QG1 ILE     6       0.172  -1.890  -6.900  1.00  0.00
ATOM    124  QD1 ILE     6       2.315  -1.290  -7.300  1.00  0.00
ATOM    125  CD1 ILE     6       1.964  -1.303  -7.228  1.00  0.00
ATOM    126 1HD1 ILE     6       2.299  -0.278  -7.191  1.00  0.00
ATOM    127 2HD1 ILE     6       2.141  -1.707  -8.212  1.00  0.00
ATOM    128 3HD1 ILE     6       2.505  -1.884  -6.495  1.00  0.00
ATOM    129  C   ILE     6      -0.144   2.015  -5.147  1.00  0.00
ATOM    130  O   ILE     6      -1.369   2.114  -5.083  1.00  0.00
ATOM    131  N   LEU     7       0.677   3.047  -4.976  1.00  0.00
ATOM    132  H   LEU     7       1.645   2.903  -5.034  1.00  0.00
ATOM    133  CA  LEU     7       0.174   4.388  -4.699  1.00  0.00
ATOM    134  HA  LEU     7      -0.807   4.288  -4.259  1.00  0.00
ATOM    135  CB  LEU     7       1.092   5.104  -3.707  1.00  0.00
ATOM    136 1HB  LEU     7       0.687   6.091  -3.522  1.00  0.00
ATOM    137 2HB  LEU     7       2.068   5.210  -4.164  1.00  0.00
ATOM    138  QB  LEU     7       1.377   5.651  -3.843  1.00  0.00
ATOM    139  CG  LEU     7       1.267   4.401  -2.361  1.00  0.00
ATOM    140  HG  LEU     7       1.348   3.336  -2.527  1.00  0.00
ATOM    141  QD1 LEU     7       2.842   4.979  -1.514  1.00  0.00
ATOM    142  QD2 LEU     7      -0.228   4.707  -1.260  1.00  0.00
ATOM    143  CD1 LEU     7       2.540   4.868  -1.676  1.00  0.00
ATOM    144 1HD1 LEU     7       2.391   4.878  -0.606  1.00  0.00
ATOM    145 2HD1 LEU     7       2.786   5.864  -2.014  1.00  0.00
ATOM    146 3HD1 LEU     7       3.349   4.196  -1.921  1.00  0.00
ATOM    147  CD2 LEU     7       0.058   4.648  -1.471  1.00  0.00
ATOM    148 1HD2 LEU     7      -0.138   5.709  -1.416  1.00  0.00
ATOM    149 2HD2 LEU     7       0.257   4.267  -0.480  1.00  0.00
ATOM    150 3HD2 LEU     7      -0.803   4.144  -1.884  1.00  0.00
ATOM    151  QQD LEU     7       1.307   4.843  -1.387  1.00  0.00
ATOM    152  C   LEU     7       0.056   5.208  -5.979  1.00  0.00
ATOM    153  O   LEU     7       1.034   5.386  -6.709  1.00  0.00
ATOM    154  N   ASN     8      -1.146   5.710  -6.243  1.00  0.00
ATOM    155  H   ASN     8      -1.882   5.536  -5.618  1.00  0.00
ATOM    156  CA  ASN     8      -1.397   6.518  -7.431  1.00  0.00
ATOM    157  HA  ASN     8      -0.445   6.720  -7.900  1.00  0.00
ATOM    158  CB  ASN     8      -2.288   5.757  -8.418  1.00  0.00
ATOM    159 1HB  ASN     8      -3.315   6.065  -8.274  1.00  0.00
ATOM    160 2HB  ASN     8      -2.202   4.697  -8.229  1.00  0.00
ATOM    161  QB  ASN     8      -2.759   5.381  -8.252  1.00  0.00
ATOM    162  CG  ASN     8      -1.908   6.018  -9.862  1.00  0.00
ATOM    163  OD1 ASN     8      -1.906   5.104 -10.688  1.00  0.00
ATOM    164  ND2 ASN     8      -1.584   7.262 -10.175  1.00  0.00
ATOM    165 1HD2 ASN     8      -1.606   7.938  -9.467  1.00  0.00
ATOM    166 2HD2 ASN     8      -1.333   7.456 -11.104  1.00  0.00
ATOM    167  QD2 ASN     8      -1.469   7.697 -10.286  1.00  0.00
ATOM    168  C   ASN     8      -2.051   7.844  -7.055  1.00  0.00
ATOM    169  O   ASN     8      -3.253   7.903  -6.796  1.00  0.00
ATOM    170  N   LEU     9      -1.253   8.906  -7.025  1.00  0.00
ATOM    171  H   LEU     9      -0.303   8.797  -7.243  1.00  0.00
ATOM    172  CA  LEU     9      -1.760  10.226  -6.680  1.00  0.00
ATOM    173  HA  LEU     9      -2.744  10.101  -6.256  1.00  0.00
ATOM    174  CB  LEU     9      -0.858  10.894  -5.640  1.00  0.00
ATOM    175 1HB  LEU     9      -0.829  10.269  -4.765  1.00  0.00
ATOM    176 2HB  LEU     9      -1.305  11.842  -5.366  1.00  0.00
ATOM    177  QB  LEU     9      -1.067  11.056  -5.066  1.00  0.00
ATOM    178  CG  LEU     9       0.584  11.157  -6.094  1.00  0.00
ATOM    179  HG  LEU     9       0.646  11.031  -7.166  1.00  0.00
ATOM    180  QD1 LEU     9       1.097  12.914  -5.680  1.00  0.00
ATOM    181  QD2 LEU     9       1.757   9.914  -5.293  1.00  0.00
ATOM    182  CD1 LEU     9       1.000  12.582  -5.761  1.00  0.00
ATOM    183 1HD1 LEU     9       2.035  12.588  -5.454  1.00  0.00
ATOM    184 2HD1 LEU     9       0.384  12.952  -4.954  1.00  0.00
ATOM    185 3HD1 LEU     9       0.874  13.203  -6.630  1.00  0.00
ATOM    186  CD2 LEU     9       1.533  10.156  -5.448  1.00  0.00
ATOM    187 1HD2 LEU     9       0.963   9.417  -4.894  1.00  0.00
ATOM    188 2HD2 LEU     9       2.200  10.668  -4.772  1.00  0.00
ATOM    189 3HD2 LEU     9       2.109   9.656  -6.214  1.00  0.00
ATOM    190  QQD LEU     9       1.427  11.414  -5.486  1.00  0.00
ATOM    191  C   LEU     9      -1.877  11.111  -7.924  1.00  0.00
ATOM    192  O   LEU     9      -1.568  10.678  -9.035  1.00  0.00
ATOM    193  N   LYS+   10      -2.339  12.340  -7.723  1.00  0.00
ATOM    194  H   LYS+   10      -2.573  12.620  -6.811  1.00  0.00
ATOM    195  CA  LYS+   10      -2.519  13.297  -8.824  1.00  0.00
ATOM    196  HA  LYS+   10      -3.432  13.037  -9.340  1.00  0.00
ATOM    197  CB  LYS+   10      -2.653  14.717  -8.271  1.00  0.00
ATOM    198 1HB  LYS+   10      -3.628  14.815  -7.811  1.00  0.00
ATOM    199 2HB  LYS+   10      -2.575  15.417  -9.089  1.00  0.00
ATOM    200  QB  LYS+   10      -3.101  15.116  -8.450  1.00  0.00
ATOM    201  CG  LYS+   10      -1.598  15.073  -7.235  1.00  0.00
ATOM    202 1HG  LYS+   10      -0.719  15.441  -7.745  1.00  0.00
ATOM    203 2HG  LYS+   10      -1.348  14.189  -6.674  1.00  0.00
ATOM    204  QG  LYS+   10      -1.034  14.815  -7.210  1.00  0.00
ATOM    205  CD  LYS+   10      -2.098  16.142  -6.277  1.00  0.00
ATOM    206 1HD  LYS+   10      -3.170  16.051  -6.181  1.00  0.00
ATOM    207 2HD  LYS+   10      -1.848  17.110  -6.672  1.00  0.00
ATOM    208  QD  LYS+   10      -2.509  16.581  -6.427  1.00  0.00
ATOM    209  CE  LYS+   10      -1.467  15.995  -4.901  1.00  0.00
ATOM    210 1HE  LYS+   10      -1.562  14.968  -4.585  1.00  0.00
ATOM    211 2HE  LYS+   10      -1.991  16.632  -4.207  1.00  0.00
ATOM    212  QE  LYS+   10      -1.777  15.800  -4.396  1.00  0.00
ATOM    213  NZ  LYS+   10      -0.025  16.364  -4.908  1.00  0.00
ATOM    214 1HZ  LYS+   10       0.285  16.615  -3.947  1.00  0.00
ATOM    215 2HZ  LYS+   10       0.129  17.182  -5.529  1.00  0.00
ATOM    216 3HZ  LYS+   10       0.547  15.564  -5.250  1.00  0.00
ATOM    217  QZ  LYS+   10       0.321  16.454  -4.909  1.00  0.00
ATOM    218  C   LYS+   10      -1.364  13.243  -9.827  1.00  0.00
ATOM    219  O   LYS+   10      -1.586  13.073 -11.026  1.00  0.00
ATOM    220  N   GLN    11      -0.136  13.388  -9.337  1.00  0.00
ATOM    221  H   GLN    11      -0.018  13.517  -8.370  1.00  0.00
ATOM    222  CA  GLN    11       1.034  13.356 -10.207  1.00  0.00
ATOM    223  HA  GLN    11       0.771  12.791 -11.089  1.00  0.00
ATOM    224  CB  GLN    11       1.419  14.779 -10.624  1.00  0.00
ATOM    225 1HB  GLN    11       2.504  14.855 -10.647  1.00  0.00
ATOM    226 2HB  GLN    11       1.031  15.470  -9.886  1.00  0.00
ATOM    227  QB  GLN    11       1.767  15.163 -10.266  1.00  0.00
ATOM    228  CG  GLN    11       0.871  15.181 -11.992  1.00  0.00
ATOM    229 1HG  GLN    11       0.182  16.006 -11.863  1.00  0.00
ATOM    230 2HG  GLN    11       0.342  14.338 -12.419  1.00  0.00
ATOM    231  QG  GLN    11       0.262  15.172 -12.141  1.00  0.00
ATOM    232  CD  GLN    11       1.964  15.606 -12.954  1.00  0.00
ATOM    233  OE1 GLN    11       2.515  16.695 -12.839  1.00  0.00
ATOM    234  NE2 GLN    11       2.280  14.733 -13.906  1.00  0.00
ATOM    235 1HE2 GLN    11       1.799  13.881 -13.935  1.00  0.00
ATOM    236 2HE2 GLN    11       2.984  14.985 -14.543  1.00  0.00
ATOM    237  QE2 GLN    11       2.392  14.433 -14.239  1.00  0.00
ATOM    238  C   GLN    11       2.218  12.667  -9.525  1.00  0.00
ATOM    239  O   GLN    11       3.179  13.333  -9.125  1.00  0.00
ATOM    240  N   ALA    12       2.148  11.350  -9.412  1.00  0.00
ATOM    241  H   ALA    12       1.359  10.880  -9.758  1.00  0.00
ATOM    242  CA  ALA    12       3.217  10.564  -8.789  1.00  0.00
ATOM    243  HA  ALA    12       4.057  10.556  -9.466  1.00  0.00
ATOM    244  QB  ALA    12       3.775  11.362  -7.176  1.00  0.00
ATOM    245  CB  ALA    12       3.667  11.208  -7.483  1.00  0.00
ATOM    246 1HB  ALA    12       2.904  11.885  -7.135  1.00  0.00
ATOM    247 2HB  ALA    12       4.584  11.753  -7.650  1.00  0.00
ATOM    248 3HB  ALA    12       3.835  10.447  -6.742  1.00  0.00
ATOM    249  C   ALA    12       2.773   9.129  -8.546  1.00  0.00
ATOM    250  O   ALA    12       1.605   8.866  -8.251  1.00  0.00
ATOM    251  N   LYS+   13       3.713   8.195  -8.662  1.00  0.00
ATOM    252  H   LYS+   13       4.626   8.468  -8.898  1.00  0.00
ATOM    253  CA  LYS+   13       3.423   6.787  -8.455  1.00  0.00
ATOM    254  HA  LYS+   13       2.490   6.717  -7.917  1.00  0.00
ATOM    255  CB  LYS+   13       3.278   6.068  -9.799  1.00  0.00
ATOM    256 1HB  LYS+   13       4.171   6.238 -10.382  1.00  0.00
ATOM    257 2HB  LYS+   13       2.431   6.487 -10.327  1.00  0.00
ATOM    258  QB  LYS+   13       3.301   6.362 -10.354  1.00  0.00
ATOM    259  CG  LYS+   13       3.070   4.575  -9.679  1.00  0.00
ATOM    260 1HG  LYS+   13       2.202   4.392  -9.062  1.00  0.00
ATOM    261 2HG  LYS+   13       3.941   4.141  -9.214  1.00  0.00
ATOM    262  QG  LYS+   13       3.072   4.266  -9.138  1.00  0.00
ATOM    263  CD  LYS+   13       2.861   3.925 -11.038  1.00  0.00
ATOM    264 1HD  LYS+   13       3.710   3.296 -11.260  1.00  0.00
ATOM    265 2HD  LYS+   13       2.778   4.698 -11.789  1.00  0.00
ATOM    266  QD  LYS+   13       3.244   3.997 -11.525  1.00  0.00
ATOM    267  CE  LYS+   13       1.598   3.078 -11.065  1.00  0.00
ATOM    268 1HE  LYS+   13       1.665   2.331 -10.288  1.00  0.00
ATOM    269 2HE  LYS+   13       1.528   2.590 -12.025  1.00  0.00
ATOM    270  QE  LYS+   13       1.596   2.461 -11.156  1.00  0.00
ATOM    271  NZ  LYS+   13       0.374   3.897 -10.847  1.00  0.00
ATOM    272 1HZ  LYS+   13       0.064   3.820  -9.857  1.00  0.00
ATOM    273 2HZ  LYS+   13      -0.394   3.564 -11.465  1.00  0.00
ATOM    274 3HZ  LYS+   13       0.568   4.896 -11.063  1.00  0.00
ATOM    275  QZ  LYS+   13       0.079   4.093 -10.795  1.00  0.00
ATOM    276  C   LYS+   13       4.522   6.127  -7.627  1.00  0.00
ATOM    277  O   LYS+   13       5.629   5.902  -8.115  1.00  0.00
ATOM    278  N   GLU    14       4.209   5.820  -6.371  1.00  0.00
ATOM    279  H   GLU    14       3.310   6.026  -6.039  1.00  0.00
ATOM    280  CA  GLU    14       5.173   5.187  -5.477  1.00  0.00
ATOM    281  HA  GLU    14       6.097   5.064  -6.020  1.00  0.00
ATOM    282  CB  GLU    14       5.428   6.078  -4.258  1.00  0.00
ATOM    283 1HB  GLU    14       4.905   5.662  -3.405  1.00  0.00
ATOM    284 2HB  GLU    14       5.042   7.067  -4.463  1.00  0.00
ATOM    285  QB  GLU    14       4.974   6.365  -3.934  1.00  0.00
ATOM    286  CG  GLU    14       6.899   6.207  -3.898  1.00  0.00
ATOM    287 1HG  GLU    14       7.265   5.242  -3.578  1.00  0.00
ATOM    288 2HG  GLU    14       6.997   6.914  -3.089  1.00  0.00
ATOM    289  QG  GLU    14       7.131   6.078  -3.333  1.00  0.00
ATOM    290  CD  GLU    14       7.744   6.684  -5.063  1.00  0.00
ATOM    291  OE1 GLU    14       7.199   7.378  -5.944  1.00  0.00
ATOM    292  OE2 GLU    14       8.950   6.361  -5.092  1.00  0.00
ATOM    293  C   GLU    14       4.681   3.815  -5.027  1.00  0.00
ATOM    294  O   GLU    14       3.477   3.575  -4.936  1.00  0.00
ATOM    295  N   GLU    15       5.621   2.916  -4.750  1.00  0.00
ATOM    296  H   GLU    15       6.564   3.164  -4.843  1.00  0.00
ATOM    297  CA  GLU    15       5.281   1.565  -4.312  1.00  0.00
ATOM    298  HA  GLU    15       4.206   1.468  -4.344  1.00  0.00
ATOM    299  CB  GLU    15       5.903   0.529  -5.249  1.00  0.00
ATOM    300 1HB  GLU    15       5.810  -0.449  -4.796  1.00  0.00
ATOM    301 2HB  GLU    15       6.949   0.760  -5.378  1.00  0.00
ATOM    302  QB  GLU    15       6.380   0.155  -5.087  1.00  0.00
ATOM    303  CG  GLU    15       5.252   0.483  -6.621  1.00  0.00
ATOM    304 1HG  GLU    15       5.597   1.329  -7.198  1.00  0.00
ATOM    305 2HG  GLU    15       4.181   0.544  -6.500  1.00  0.00
ATOM    306  QG  GLU    15       4.889   0.936  -6.849  1.00  0.00
ATOM    307  CD  GLU    15       5.581  -0.788  -7.379  1.00  0.00
ATOM    308  OE1 GLU    15       6.113  -0.687  -8.505  1.00  0.00
ATOM    309  OE2 GLU    15       5.307  -1.884  -6.847  1.00  0.00
ATOM    310  C   GLU    15       5.756   1.313  -2.886  1.00  0.00
ATOM    311  O   GLU    15       6.922   1.533  -2.559  1.00  0.00
ATOM    312  N   ALA    16       4.845   0.837  -2.046  1.00  0.00
ATOM    313  H   ALA    16       3.935   0.672  -2.370  1.00  0.00
ATOM    314  CA  ALA    16       5.168   0.534  -0.657  1.00  0.00
ATOM    315  HA  ALA    16       6.155   0.922  -0.450  1.00  0.00
ATOM    316  QB  ALA    16       3.946   1.377   0.499  1.00  0.00
ATOM    317  CB  ALA    16       4.180   1.216   0.278  1.00  0.00
ATOM    318 1HB  ALA    16       4.706   1.597   1.141  1.00  0.00
ATOM    319 2HB  ALA    16       3.435   0.502   0.597  1.00  0.00
ATOM    320 3HB  ALA    16       3.698   2.032  -0.240  1.00  0.00
ATOM    321  C   ALA    16       5.168  -0.971  -0.434  1.00  0.00
ATOM    322  O   ALA    16       4.306  -1.680  -0.949  1.00  0.00
ATOM    323  N   ILE    17       6.138  -1.461   0.328  1.00  0.00
ATOM    324  H   ILE    17       6.801  -0.851   0.713  1.00  0.00
ATOM    325  CA  ILE    17       6.232  -2.892   0.597  1.00  0.00
ATOM    326  HA  ILE    17       5.233  -3.300   0.537  1.00  0.00
ATOM    327  CB  ILE    17       7.106  -3.614  -0.458  1.00  0.00
ATOM    328  HB  ILE    17       6.943  -4.677  -0.357  1.00  0.00
ATOM    329  QG2 ILE    17       6.573  -3.111  -2.194  1.00  0.00
ATOM    330  CG2 ILE    17       6.674  -3.208  -1.861  1.00  0.00
ATOM    331 1HG2 ILE    17       5.597  -3.199  -1.918  1.00  0.00
ATOM    332 2HG2 ILE    17       7.067  -3.914  -2.578  1.00  0.00
ATOM    333 3HG2 ILE    17       7.054  -2.221  -2.084  1.00  0.00
ATOM    334  CG1 ILE    17       8.600  -3.317  -0.257  1.00  0.00
ATOM    335 1HG1 ILE    17       8.800  -3.168   0.793  1.00  0.00
ATOM    336 2HG1 ILE    17       8.860  -2.420  -0.800  1.00  0.00
ATOM    337  QG1 ILE    17       8.830  -2.794  -0.003  1.00  0.00
ATOM    338  QD1 ILE    17       9.715  -4.691  -0.865  1.00  0.00
ATOM    339  CD1 ILE    17       9.504  -4.427  -0.748  1.00  0.00
ATOM    340 1HD1 ILE    17       9.999  -4.880   0.093  1.00  0.00
ATOM    341 2HD1 ILE    17      10.231  -4.019  -1.429  1.00  0.00
ATOM    342 3HD1 ILE    17       8.914  -5.174  -1.258  1.00  0.00
ATOM    343  C   ILE    17       6.765  -3.170   1.995  1.00  0.00
ATOM    344  O   ILE    17       7.343  -2.293   2.640  1.00  0.00
ATOM    345  N   LYS+   18       6.554  -4.394   2.459  1.00  0.00
ATOM    346  H   LYS+   18       6.079  -5.043   1.899  1.00  0.00
ATOM    347  CA  LYS+   18       6.997  -4.795   3.786  1.00  0.00
ATOM    348  HA  LYS+   18       8.032  -4.509   3.894  1.00  0.00
ATOM    349  CB  LYS+   18       6.162  -4.061   4.841  1.00  0.00
ATOM    350 1HB  LYS+   18       5.118  -4.138   4.561  1.00  0.00
ATOM    351 2HB  LYS+   18       6.450  -3.016   4.840  1.00  0.00
ATOM    352  QB  LYS+   18       5.784  -3.577   4.701  1.00  0.00
ATOM    353  CG  LYS+   18       6.323  -4.595   6.258  1.00  0.00
ATOM    354 1HG  LYS+   18       6.830  -5.547   6.222  1.00  0.00
ATOM    355 2HG  LYS+   18       5.345  -4.724   6.697  1.00  0.00
ATOM    356  QG  LYS+   18       6.088  -5.136   6.459  1.00  0.00
ATOM    357  CD  LYS+   18       7.128  -3.640   7.126  1.00  0.00
ATOM    358 1HD  LYS+   18       6.741  -3.671   8.132  1.00  0.00
ATOM    359 2HD  LYS+   18       7.032  -2.640   6.731  1.00  0.00
ATOM    360  QD  LYS+   18       6.887  -3.156   7.432  1.00  0.00
ATOM    361  CE  LYS+   18       8.593  -4.020   7.150  1.00  0.00
ATOM    362 1HE  LYS+   18       8.681  -5.091   7.037  1.00  0.00
ATOM    363 2HE  LYS+   18       9.017  -3.728   8.103  1.00  0.00
ATOM    364  QE  LYS+   18       8.849  -4.409   7.570  1.00  0.00
ATOM    365  NZ  LYS+   18       9.359  -3.354   6.061  1.00  0.00
ATOM    366 1HZ  LYS+   18       9.843  -2.506   6.426  1.00  0.00
ATOM    367 2HZ  LYS+   18       8.724  -3.075   5.293  1.00  0.00
ATOM    368 3HZ  LYS+   18      10.074  -4.005   5.678  1.00  0.00
ATOM    369  QZ  LYS+   18       9.547  -3.195   5.799  1.00  0.00
ATOM    370  C   LYS+   18       6.878  -6.307   3.959  1.00  0.00
ATOM    371  O   LYS+   18       5.914  -6.921   3.499  1.00  0.00
ATOM    372  N   GLU    19       7.864  -6.903   4.624  1.00  0.00
ATOM    373  H   GLU    19       8.605  -6.361   4.965  1.00  0.00
ATOM    374  CA  GLU    19       7.869  -8.342   4.857  1.00  0.00
ATOM    375  HA  GLU    19       7.166  -8.792   4.171  1.00  0.00
ATOM    376  CB  GLU    19       9.252  -8.918   4.586  1.00  0.00
ATOM    377 1HB  GLU    19       9.533  -8.703   3.564  1.00  0.00
ATOM    378 2HB  GLU    19       9.220  -9.989   4.722  1.00  0.00
ATOM    379  QB  GLU    19       9.377  -9.346   4.143  1.00  0.00
ATOM    380  CG  GLU    19      10.336  -8.357   5.500  1.00  0.00
ATOM    381 1HG  GLU    19      10.650  -9.132   6.183  1.00  0.00
ATOM    382 2HG  GLU    19       9.914  -7.532   6.060  1.00  0.00
ATOM    383  QG  GLU    19      10.282  -8.332   6.121  1.00  0.00
ATOM    384  CD  GLU    19      11.545  -7.858   4.737  1.00  0.00
ATOM    385  OE1 GLU    19      12.339  -8.702   4.263  1.00  0.00
ATOM    386  OE2 GLU    19      11.701  -6.626   4.613  1.00  0.00
ATOM    387  C   GLU    19       7.441  -8.667   6.284  1.00  0.00
ATOM    388  O   GLU    19       8.118  -8.299   7.243  1.00  0.00
ATOM    389  N   ALA    20       6.314  -9.359   6.415  1.00  0.00
ATOM    390  H   ALA    20       5.818  -9.625   5.613  1.00  0.00
ATOM    391  CA  ALA    20       5.797  -9.734   7.726  1.00  0.00
ATOM    392  HA  ALA    20       6.615  -9.693   8.431  1.00  0.00
ATOM    393  QB  ALA    20       4.482  -8.508   8.283  1.00  0.00
ATOM    394  CB  ALA    20       4.734  -8.744   8.176  1.00  0.00
ATOM    395 1HB  ALA    20       4.900  -8.482   9.212  1.00  0.00
ATOM    396 2HB  ALA    20       3.755  -9.190   8.070  1.00  0.00
ATOM    397 3HB  ALA    20       4.791  -7.853   7.568  1.00  0.00
ATOM    398  C   ALA    20       5.233 -11.150   7.709  1.00  0.00
ATOM    399  O   ALA    20       5.104 -11.767   6.651  1.00  0.00
ATOM    400  N   VAL    21       4.900 -11.663   8.890  1.00  0.00
ATOM    401  H   VAL    21       5.029 -11.124   9.700  1.00  0.00
ATOM    402  CA  VAL    21       4.351 -13.010   9.014  1.00  0.00
ATOM    403  HA  VAL    21       4.718 -13.595   8.183  1.00  0.00
ATOM    404  CB  VAL    21       4.816 -13.685  10.317  1.00  0.00
ATOM    405  HB  VAL    21       4.271 -14.611  10.434  1.00  0.00
ATOM    406  QG1 VAL    21       6.650 -14.086  10.238  1.00  0.00
ATOM    407  QG2 VAL    21       4.434 -12.588  11.798  1.00  0.00
ATOM    408  CG1 VAL    21       6.299 -14.009  10.253  1.00  0.00
ATOM    409 1HG1 VAL    21       6.546 -14.722  11.027  1.00  0.00
ATOM    410 2HG1 VAL    21       6.872 -13.105  10.400  1.00  0.00
ATOM    411 3HG1 VAL    21       6.534 -14.431   9.287  1.00  0.00
ATOM    412  CG2 VAL    21       4.508 -12.797  11.514  1.00  0.00
ATOM    413 1HG2 VAL    21       3.518 -12.379  11.407  1.00  0.00
ATOM    414 2HG2 VAL    21       5.232 -11.999  11.568  1.00  0.00
ATOM    415 3HG2 VAL    21       4.553 -13.385  12.419  1.00  0.00
ATOM    416  QQG VAL    21       5.542 -13.337  11.018  1.00  0.00
ATOM    417  C   VAL    21       2.823 -13.003   8.976  1.00  0.00
ATOM    418  O   VAL    21       2.181 -13.947   9.437  1.00  0.00
ATOM    419  N   ASP    22       2.244 -11.939   8.426  1.00  0.00
ATOM    420  H   ASP    22       2.802 -11.217   8.073  1.00  0.00
ATOM    421  CA  ASP    22       0.793 -11.822   8.336  1.00  0.00
ATOM    422  HA  ASP    22       0.422 -12.698   7.823  1.00  0.00
ATOM    423  CB  ASP    22       0.177 -11.764   9.734  1.00  0.00
ATOM    424 1HB  ASP    22      -0.027 -10.735   9.988  1.00  0.00
ATOM    425 2HB  ASP    22       0.879 -12.174  10.446  1.00  0.00
ATOM    426  QB  ASP    22       0.426 -11.455  10.217  1.00  0.00
ATOM    427  CG  ASP    22      -1.117 -12.548   9.830  1.00  0.00
ATOM    428  OD1 ASP    22      -1.167 -13.678   9.298  1.00  0.00
ATOM    429  OD2 ASP    22      -2.080 -12.034  10.437  1.00  0.00
ATOM    430  C   ASP    22       0.401 -10.581   7.538  1.00  0.00
ATOM    431  O   ASP    22       1.237  -9.974   6.870  1.00  0.00
ATOM    432  N   ALA    23      -0.874 -10.205   7.613  1.00  0.00
ATOM    433  H   ALA    23      -1.496 -10.725   8.163  1.00  0.00
ATOM    434  CA  ALA    23      -1.363  -9.035   6.895  1.00  0.00
ATOM    435  HA  ALA    23      -0.627  -8.771   6.148  1.00  0.00
ATOM    436  QB  ALA    23      -2.973  -9.430   6.012  1.00  0.00
ATOM    437  CB  ALA    23      -2.665  -9.356   6.181  1.00  0.00
ATOM    438 1HB  ALA    23      -3.097  -8.443   5.796  1.00  0.00
ATOM    439 2HB  ALA    23      -3.352  -9.815   6.875  1.00  0.00
ATOM    440 3HB  ALA    23      -2.470 -10.032   5.364  1.00  0.00
ATOM    441  C   ALA    23      -1.556  -7.851   7.835  1.00  0.00
ATOM    442  O   ALA    23      -1.278  -6.708   7.472  1.00  0.00
ATOM    443  N   GLY    24      -2.030  -8.130   9.047  1.00  0.00
ATOM    444  H   GLY    24      -2.232  -9.059   9.283  1.00  0.00
ATOM    445  CA  GLY    24      -2.245  -7.071  10.018  1.00  0.00
ATOM    446 1HA  GLY    24      -2.444  -7.516  10.983  1.00  0.00
ATOM    447 2HA  GLY    24      -3.104  -6.489   9.718  1.00  0.00
ATOM    448  QA  GLY    24      -2.774  -7.003  10.351  1.00  0.00
ATOM    449  C   GLY    24      -1.047  -6.153  10.139  1.00  0.00
ATOM    450  O   GLY    24      -1.191  -4.953  10.377  1.00  0.00
ATOM    451  N   THR    25       0.141  -6.723   9.962  1.00  0.00
ATOM    452  H   THR    25       0.186  -7.681   9.767  1.00  0.00
ATOM    453  CA  THR    25       1.377  -5.956  10.037  1.00  0.00
ATOM    454  HA  THR    25       1.270  -5.230  10.830  1.00  0.00
ATOM    455  CB  THR    25       2.556  -6.876  10.360  1.00  0.00
ATOM    456  HB  THR    25       2.895  -7.340   9.446  1.00  0.00
ATOM    457  QG2 THR    25       4.010  -5.976  11.121  1.00  0.00
ATOM    458  OG1 THR    25       2.162  -7.898  11.260  1.00  0.00
ATOM    459 1HG  THR    25       1.790  -7.503  12.050  1.00  0.00
ATOM    460  CG2 THR    25       3.730  -6.148  10.975  1.00  0.00
ATOM    461 1HG2 THR    25       4.652  -6.574  10.604  1.00  0.00
ATOM    462 2HG2 THR    25       3.695  -6.250  12.049  1.00  0.00
ATOM    463 3HG2 THR    25       3.685  -5.102  10.710  1.00  0.00
ATOM    464  C   THR    25       1.632  -5.221   8.726  1.00  0.00
ATOM    465  O   THR    25       2.268  -4.168   8.708  1.00  0.00
ATOM    466  N   ALA    26       1.124  -5.780   7.630  1.00  0.00
ATOM    467  H   ALA    26       0.619  -6.619   7.706  1.00  0.00
ATOM    468  CA  ALA    26       1.293  -5.170   6.318  1.00  0.00
ATOM    469  HA  ALA    26       2.299  -4.777   6.260  1.00  0.00
ATOM    470  QB  ALA    26       1.086  -6.460   4.964  1.00  0.00
ATOM    471  CB  ALA    26       1.126  -6.214   5.223  1.00  0.00
ATOM    472 1HB  ALA    26       1.574  -7.143   5.539  1.00  0.00
ATOM    473 2HB  ALA    26       1.609  -5.869   4.321  1.00  0.00
ATOM    474 3HB  ALA    26       0.074  -6.367   5.032  1.00  0.00
ATOM    475  C   ALA    26       0.303  -4.030   6.126  1.00  0.00
ATOM    476  O   ALA    26       0.650  -2.976   5.593  1.00  0.00
ATOM    477  N   GLU    27      -0.931  -4.247   6.570  1.00  0.00
ATOM    478  H   GLU    27      -1.143  -5.106   6.991  1.00  0.00
ATOM    479  CA  GLU    27      -1.973  -3.234   6.455  1.00  0.00
ATOM    480  HA  GLU    27      -2.020  -2.920   5.423  1.00  0.00
ATOM    481  CB  GLU    27      -3.328  -3.817   6.863  1.00  0.00
ATOM    482 1HB  GLU    27      -3.271  -4.143   7.892  1.00  0.00
ATOM    483 2HB  GLU    27      -3.544  -4.668   6.236  1.00  0.00
ATOM    484  QB  GLU    27      -3.407  -4.406   7.064  1.00  0.00
ATOM    485  CG  GLU    27      -4.477  -2.830   6.740  1.00  0.00
ATOM    486 1HG  GLU    27      -4.696  -2.681   5.692  1.00  0.00
ATOM    487 2HG  GLU    27      -4.178  -1.890   7.181  1.00  0.00
ATOM    488  QG  GLU    27      -4.437  -2.285   6.436  1.00  0.00
ATOM    489  CD  GLU    27      -5.736  -3.310   7.435  1.00  0.00
ATOM    490  OE1 GLU    27      -6.556  -3.984   6.778  1.00  0.00
ATOM    491  OE2 GLU    27      -5.900  -3.014   8.637  1.00  0.00
ATOM    492  C   GLU    27      -1.642  -2.026   7.325  1.00  0.00
ATOM    493  O   GLU    27      -1.521  -0.906   6.828  1.00  0.00
ATOM    494  N   LYS+   28      -1.492  -2.262   8.626  1.00  0.00
ATOM    495  H   LYS+   28      -1.599  -3.178   8.961  1.00  0.00
ATOM    496  CA  LYS+   28      -1.168  -1.194   9.566  1.00  0.00
ATOM    497  HA  LYS+   28      -1.993  -0.495   9.570  1.00  0.00
ATOM    498  CB  LYS+   28      -0.990  -1.763  10.974  1.00  0.00
ATOM    499 1HB  LYS+   28      -0.213  -1.207  11.480  1.00  0.00
ATOM    500 2HB  LYS+   28      -0.688  -2.797  10.897  1.00  0.00
ATOM    501  QB  LYS+   28      -0.451  -2.002  11.189  1.00  0.00
ATOM    502  CG  LYS+   28      -2.251  -1.696  11.821  1.00  0.00
ATOM    503 1HG  LYS+   28      -3.105  -1.896  11.191  1.00  0.00
ATOM    504 2HG  LYS+   28      -2.338  -0.708  12.246  1.00  0.00
ATOM    505  QG  LYS+   28      -2.721  -1.302  11.719  1.00  0.00
ATOM    506  CD  LYS+   28      -2.219  -2.715  12.949  1.00  0.00
ATOM    507 1HD  LYS+   28      -1.409  -2.470  13.621  1.00  0.00
ATOM    508 2HD  LYS+   28      -2.056  -3.697  12.530  1.00  0.00
ATOM    509  QD  LYS+   28      -1.733  -3.083  13.075  1.00  0.00
ATOM    510  CE  LYS+   28      -3.524  -2.724  13.731  1.00  0.00
ATOM    511 1HE  LYS+   28      -4.142  -3.528  13.363  1.00  0.00
ATOM    512 2HE  LYS+   28      -4.028  -1.781  13.574  1.00  0.00
ATOM    513  QE  LYS+   28      -4.085  -2.655  13.468  1.00  0.00
ATOM    514  NZ  LYS+   28      -3.296  -2.913  15.189  1.00  0.00
ATOM    515 1HZ  LYS+   28      -2.675  -3.732  15.352  1.00  0.00
ATOM    516 2HZ  LYS+   28      -4.200  -3.075  15.675  1.00  0.00
ATOM    517 3HZ  LYS+   28      -2.846  -2.065  15.593  1.00  0.00
ATOM    518  QZ  LYS+   28      -3.240  -2.958  15.540  1.00  0.00
ATOM    519  C   LYS+   28       0.097  -0.451   9.138  1.00  0.00
ATOM    520  O   LYS+   28       0.177   0.772   9.250  1.00  0.00
ATOM    521  N   TYR    29       1.079  -1.196   8.638  1.00  0.00
ATOM    522  H   TYR    29       0.956  -2.166   8.564  1.00  0.00
ATOM    523  CA  TYR    29       2.334  -0.598   8.189  1.00  0.00
ATOM    524  HA  TYR    29       2.660   0.095   8.952  1.00  0.00
ATOM    525  CB  TYR    29       3.410  -1.673   7.992  1.00  0.00
ATOM    526 1HB  TYR    29       3.030  -2.436   7.325  1.00  0.00
ATOM    527 2HB  TYR    29       3.643  -2.120   8.951  1.00  0.00
ATOM    528  QB  TYR    29       3.336  -2.278   8.138  1.00  0.00
ATOM    529  QD  TYR    29       4.854  -1.082   7.343  1.00  0.00
ATOM    530  QE  TYR    29       6.956  -0.221   6.405  1.00  0.00
ATOM    531  QR  TYR    29       5.905  -0.652   6.874  1.00  0.00
ATOM    532  CG  TYR    29       4.702  -1.142   7.411  1.00  0.00
ATOM    533  CD1 TYR    29       4.854  -0.966   6.039  1.00  0.00
ATOM    534 1HD  TYR    29       4.034  -1.212   5.385  1.00  0.00
ATOM    535  CE1 TYR    29       6.035  -0.482   5.509  1.00  0.00
ATOM    536 1HE  TYR    29       6.134  -0.352   4.442  1.00  0.00
ATOM    537  CZ  TYR    29       7.083  -0.169   6.349  1.00  0.00
ATOM    538  CE2 TYR    29       6.958  -0.336   7.711  1.00  0.00
ATOM    539 2HE  TYR    29       7.779  -0.090   8.369  1.00  0.00
ATOM    540  CD2 TYR    29       5.774  -0.819   8.235  1.00  0.00
ATOM    541 2HD  TYR    29       5.674  -0.952   9.302  1.00  0.00
ATOM    542  OH  TYR    29       8.261   0.312   5.824  1.00  0.00
ATOM    543  HH  TYR    29       8.443   1.182   6.189  1.00  0.00
ATOM    544  C   TYR    29       2.113   0.176   6.892  1.00  0.00
ATOM    545  O   TYR    29       2.603   1.294   6.732  1.00  0.00
ATOM    546  N   PHE    30       1.353  -0.420   5.975  1.00  0.00
ATOM    547  H   PHE    30       0.977  -1.303   6.165  1.00  0.00
ATOM    548  CA  PHE    30       1.051   0.226   4.703  1.00  0.00
ATOM    549  HA  PHE    30       1.985   0.487   4.230  1.00  0.00
ATOM    550  CB  PHE    30       0.266  -0.723   3.788  1.00  0.00
ATOM    551 1HB  PHE    30      -0.392  -0.135   3.158  1.00  0.00
ATOM    552 2HB  PHE    30      -0.329  -1.389   4.398  1.00  0.00
ATOM    553  QB  PHE    30      -0.360  -0.762   3.778  1.00  0.00
ATOM    554  QD  PHE    30       1.219  -1.675   2.784  1.00  0.00
ATOM    555  QE  PHE    30       2.593  -3.077   1.299  1.00  0.00
ATOM    556  QR  PHE    30       2.180  -2.656   1.744  1.00  0.00
ATOM    557  CG  PHE    30       1.123  -1.577   2.886  1.00  0.00
ATOM    558  CD1 PHE    30       2.505  -1.610   3.019  1.00  0.00
ATOM    559 1HD  PHE    30       2.978  -1.012   3.782  1.00  0.00
ATOM    560  CE1 PHE    30       3.278  -2.396   2.186  1.00  0.00
ATOM    561 1HE  PHE    30       4.353  -2.413   2.298  1.00  0.00
ATOM    562  CZ  PHE    30       2.677  -3.164   1.208  1.00  0.00
ATOM    563  HZ  PHE    30       3.279  -3.777   0.555  1.00  0.00
ATOM    564  CE2 PHE    30       1.305  -3.142   1.064  1.00  0.00
ATOM    565 2HE  PHE    30       0.832  -3.741   0.300  1.00  0.00
ATOM    566  CD2 PHE    30       0.534  -2.353   1.900  1.00  0.00
ATOM    567 2HD  PHE    30      -0.540  -2.338   1.786  1.00  0.00
ATOM    568  C   PHE    30       0.252   1.497   4.949  1.00  0.00
ATOM    569  O   PHE    30       0.516   2.540   4.352  1.00  0.00
ATOM    570  N   LYS+   31      -0.726   1.401   5.845  1.00  0.00
ATOM    571  H   LYS+   31      -0.885   0.540   6.290  1.00  0.00
ATOM    572  CA  LYS+   31      -1.564   2.542   6.188  1.00  0.00
ATOM    573  HA  LYS+   31      -2.082   2.851   5.294  1.00  0.00
ATOM    574  CB  LYS+   31      -2.594   2.139   7.245  1.00  0.00
ATOM    575 1HB  LYS+   31      -2.132   2.192   8.221  1.00  0.00
ATOM    576 2HB  LYS+   31      -2.904   1.122   7.058  1.00  0.00
ATOM    577  QB  LYS+   31      -2.518   1.657   7.639  1.00  0.00
ATOM    578  CG  LYS+   31      -3.834   3.020   7.255  1.00  0.00
ATOM    579 1HG  LYS+   31      -4.700   2.406   7.052  1.00  0.00
ATOM    580 2HG  LYS+   31      -3.736   3.771   6.487  1.00  0.00
ATOM    581  QG  LYS+   31      -4.218   3.088   6.770  1.00  0.00
ATOM    582  CD  LYS+   31      -4.021   3.711   8.597  1.00  0.00
ATOM    583 1HD  LYS+   31      -4.323   4.734   8.424  1.00  0.00
ATOM    584 2HD  LYS+   31      -3.084   3.696   9.133  1.00  0.00
ATOM    585  QD  LYS+   31      -3.703   4.215   8.779  1.00  0.00
ATOM    586  CE  LYS+   31      -5.079   3.018   9.438  1.00  0.00
ATOM    587 1HE  LYS+   31      -4.943   1.949   9.357  1.00  0.00
ATOM    588 2HE  LYS+   31      -6.055   3.284   9.058  1.00  0.00
ATOM    589  QE  LYS+   31      -5.499   2.617   9.208  1.00  0.00
ATOM    590  NZ  LYS+   31      -4.994   3.411  10.872  1.00  0.00
ATOM    591 1HZ  LYS+   31      -4.590   4.364  10.958  1.00  0.00
ATOM    592 2HZ  LYS+   31      -4.390   2.743  11.391  1.00  0.00
ATOM    593 3HZ  LYS+   31      -5.943   3.407  11.301  1.00  0.00
ATOM    594  QZ  LYS+   31      -4.974   3.505  11.217  1.00  0.00
ATOM    595  C   LYS+   31      -0.720   3.711   6.697  1.00  0.00
ATOM    596  O   LYS+   31      -1.046   4.873   6.457  1.00  0.00
ATOM    597  N   LEU    32       0.366   3.399   7.405  1.00  0.00
ATOM    598  H   LEU    32       0.580   2.458   7.569  1.00  0.00
ATOM    599  CA  LEU    32       1.248   4.425   7.945  1.00  0.00
ATOM    600  HA  LEU    32       0.638   5.149   8.461  1.00  0.00
ATOM    601  CB  LEU    32       2.225   3.803   8.949  1.00  0.00
ATOM    602 1HB  LEU    32       2.966   4.551   9.202  1.00  0.00
ATOM    603 2HB  LEU    32       2.725   2.973   8.467  1.00  0.00
ATOM    604  QB  LEU    32       2.845   3.762   8.834  1.00  0.00
ATOM    605  CG  LEU    32       1.603   3.285  10.258  1.00  0.00
ATOM    606  HG  LEU    32       1.793   2.224  10.336  1.00  0.00
ATOM    607  QD1 LEU    32       2.404   4.125  11.732  1.00  0.00
ATOM    608  QD2 LEU    32      -0.263   3.546  10.297  1.00  0.00
ATOM    609  CD1 LEU    32       2.252   3.964  11.451  1.00  0.00
ATOM    610 1HD1 LEU    32       2.259   5.032  11.291  1.00  0.00
ATOM    611 2HD1 LEU    32       3.263   3.606  11.561  1.00  0.00
ATOM    612 3HD1 LEU    32       1.688   3.736  12.343  1.00  0.00
ATOM    613  CD2 LEU    32       0.094   3.496  10.290  1.00  0.00
ATOM    614 1HD2 LEU    32      -0.293   3.183  11.248  1.00  0.00
ATOM    615 2HD2 LEU    32      -0.370   2.912   9.508  1.00  0.00
ATOM    616 3HD2 LEU    32      -0.128   4.543  10.136  1.00  0.00
ATOM    617  QQD LEU    32       1.070   3.835  11.015  1.00  0.00
ATOM    618  C   LEU    32       2.017   5.135   6.831  1.00  0.00
ATOM    619  O   LEU    32       2.217   6.350   6.882  1.00  0.00
ATOM    620  N   ILE    33       2.441   4.375   5.822  1.00  0.00
ATOM    621  H   ILE    33       2.248   3.416   5.828  1.00  0.00
ATOM    622  CA  ILE    33       3.181   4.946   4.703  1.00  0.00
ATOM    623  HA  ILE    33       3.838   5.710   5.096  1.00  0.00
ATOM    624  CB  ILE    33       4.047   3.880   3.998  1.00  0.00
ATOM    625  HB  ILE    33       4.689   3.425   4.737  1.00  0.00
ATOM    626  QG2 ILE    33       2.968   2.530   3.259  1.00  0.00
ATOM    627  CG2 ILE    33       3.174   2.789   3.400  1.00  0.00
ATOM    628 1HG2 ILE    33       3.789   2.106   2.833  1.00  0.00
ATOM    629 2HG2 ILE    33       2.435   3.232   2.751  1.00  0.00
ATOM    630 3HG2 ILE    33       2.680   2.253   4.194  1.00  0.00
ATOM    631  CG1 ILE    33       4.917   4.529   2.917  1.00  0.00
ATOM    632 1HG1 ILE    33       4.482   5.475   2.635  1.00  0.00
ATOM    633 2HG1 ILE    33       4.951   3.880   2.055  1.00  0.00
ATOM    634  QG1 ILE    33       4.717   4.678   2.345  1.00  0.00
ATOM    635  QD1 ILE    33       6.680   4.845   3.466  1.00  0.00
ATOM    636  CD1 ILE    33       6.340   4.785   3.361  1.00  0.00
ATOM    637 1HD1 ILE    33       6.659   3.994   4.024  1.00  0.00
ATOM    638 2HD1 ILE    33       6.392   5.731   3.879  1.00  0.00
ATOM    639 3HD1 ILE    33       6.988   4.811   2.496  1.00  0.00
ATOM    640  C   ILE    33       2.236   5.582   3.692  1.00  0.00
ATOM    641  O   ILE    33       2.547   6.616   3.102  1.00  0.00
ATOM    642  N   ALA    34       1.077   4.962   3.501  1.00  0.00
ATOM    643  H   ALA    34       0.884   4.144   4.005  1.00  0.00
ATOM    644  CA  ALA    34       0.085   5.474   2.567  1.00  0.00
ATOM    645  HA  ALA    34       0.552   5.561   1.597  1.00  0.00
ATOM    646  QB  ALA    34      -1.358   4.276   2.421  1.00  0.00
ATOM    647  CB  ALA    34      -1.081   4.505   2.450  1.00  0.00
ATOM    648 1HB  ALA    34      -1.171   3.936   3.362  1.00  0.00
ATOM    649 2HB  ALA    34      -0.911   3.833   1.621  1.00  0.00
ATOM    650 3HB  ALA    34      -1.994   5.058   2.281  1.00  0.00
ATOM    651  C   ALA    34      -0.406   6.848   3.006  1.00  0.00
ATOM    652  O   ALA    34      -0.228   7.837   2.298  1.00  0.00
ATOM    653  N   ASN    35      -1.024   6.899   4.182  1.00  0.00
ATOM    654  H   ASN    35      -1.135   6.074   4.699  1.00  0.00
ATOM    655  CA  ASN    35      -1.540   8.152   4.722  1.00  0.00
ATOM    656  HA  ASN    35      -2.285   8.522   4.035  1.00  0.00
ATOM    657  CB  ASN    35      -2.196   7.909   6.084  1.00  0.00
ATOM    658 1HB  ASN    35      -1.752   8.569   6.816  1.00  0.00
ATOM    659 2HB  ASN    35      -2.021   6.885   6.380  1.00  0.00
ATOM    660  QB  ASN    35      -1.887   7.727   6.598  1.00  0.00
ATOM    661  CG  ASN    35      -3.695   8.150   6.062  1.00  0.00
ATOM    662  OD1 ASN    35      -4.460   7.406   6.677  1.00  0.00
ATOM    663  ND2 ASN    35      -4.127   9.191   5.355  1.00  0.00
ATOM    664 1HD2 ASN    35      -3.468   9.744   4.889  1.00  0.00
ATOM    665 2HD2 ASN    35      -5.092   9.362   5.330  1.00  0.00
ATOM    666  QD2 ASN    35      -4.280   9.553   5.109  1.00  0.00
ATOM    667  C   ASN    35      -0.429   9.195   4.852  1.00  0.00
ATOM    668  O   ASN    35      -0.656  10.384   4.627  1.00  0.00
ATOM    669  N   ALA    36       0.768   8.746   5.222  1.00  0.00
ATOM    670  H   ALA    36       0.891   7.789   5.392  1.00  0.00
ATOM    671  CA  ALA    36       1.903   9.647   5.383  1.00  0.00
ATOM    672  HA  ALA    36       1.589  10.466   6.013  1.00  0.00
ATOM    673  QB  ALA    36       3.320   8.760   6.245  1.00  0.00
ATOM    674  CB  ALA    36       3.049   8.930   6.081  1.00  0.00
ATOM    675 1HB  ALA    36       3.951   9.516   5.986  1.00  0.00
ATOM    676 2HB  ALA    36       3.198   7.962   5.624  1.00  0.00
ATOM    677 3HB  ALA    36       2.810   8.802   7.126  1.00  0.00
ATOM    678  C   ALA    36       2.368  10.209   4.041  1.00  0.00
ATOM    679  O   ALA    36       2.988  11.270   3.986  1.00  0.00
ATOM    680  N   LYS+   37       2.070   9.490   2.961  1.00  0.00
ATOM    681  H   LYS+   37       1.576   8.650   3.065  1.00  0.00
ATOM    682  CA  LYS+   37       2.466   9.923   1.626  1.00  0.00
ATOM    683  HA  LYS+   37       3.264  10.644   1.735  1.00  0.00
ATOM    684  CB  LYS+   37       2.983   8.733   0.814  1.00  0.00
ATOM    685 1HB  LYS+   37       3.034   9.018  -0.227  1.00  0.00
ATOM    686 2HB  LYS+   37       2.289   7.912   0.919  1.00  0.00
ATOM    687  QB  LYS+   37       2.662   8.465   0.346  1.00  0.00
ATOM    688  CG  LYS+   37       4.359   8.253   1.246  1.00  0.00
ATOM    689 1HG  LYS+   37       4.247   7.356   1.837  1.00  0.00
ATOM    690 2HG  LYS+   37       4.827   9.023   1.843  1.00  0.00
ATOM    691  QG  LYS+   37       4.537   8.189   1.840  1.00  0.00
ATOM    692  CD  LYS+   37       5.247   7.949   0.050  1.00  0.00
ATOM    693 1HD  LYS+   37       4.690   7.351  -0.657  1.00  0.00
ATOM    694 2HD  LYS+   37       6.113   7.399   0.387  1.00  0.00
ATOM    695  QD  LYS+   37       5.402   7.375  -0.135  1.00  0.00
ATOM    696  CE  LYS+   37       5.712   9.222  -0.638  1.00  0.00
ATOM    697 1HE  LYS+   37       4.880   9.639  -1.183  1.00  0.00
ATOM    698 2HE  LYS+   37       6.506   8.976  -1.326  1.00  0.00
ATOM    699  QE  LYS+   37       5.693   9.308  -1.255  1.00  0.00
ATOM    700  NZ  LYS+   37       6.211  10.229   0.337  1.00  0.00
ATOM    701 1HZ  LYS+   37       6.984  10.785  -0.087  1.00  0.00
ATOM    702 2HZ  LYS+   37       6.568   9.756   1.190  1.00  0.00
ATOM    703 3HZ  LYS+   37       5.444  10.875   0.608  1.00  0.00
ATOM    704  QZ  LYS+   37       6.332  10.472   0.570  1.00  0.00
ATOM    705  C   LYS+   37       1.305  10.588   0.892  1.00  0.00
ATOM    706  O   LYS+   37       1.506  11.485   0.083  1.00  0.00
ATOM    707  N   THR    38       0.089  10.135   1.179  1.00  0.00
ATOM    708  H   THR    38      -0.011   9.412   1.833  1.00  0.00
ATOM    709  CA  THR    38      -1.101  10.688   0.542  1.00  0.00
ATOM    710  HA  THR    38      -0.885  11.704   0.267  1.00  0.00
ATOM    711  CB  THR    38      -1.447   9.892  -0.717  1.00  0.00
ATOM    712  HB  THR    38      -2.516   9.930  -0.872  1.00  0.00
ATOM    713  QG2 THR    38      -0.622  10.551  -2.261  1.00  0.00
ATOM    714  OG1 THR    38      -1.065   8.536  -0.576  1.00  0.00
ATOM    715 1HG  THR    38      -1.413   8.028  -1.311  1.00  0.00
ATOM    716  CG2 THR    38      -0.780  10.426  -1.965  1.00  0.00
ATOM    717 1HG2 THR    38       0.118   9.859  -2.163  1.00  0.00
ATOM    718 2HG2 THR    38      -0.527  11.465  -1.819  1.00  0.00
ATOM    719 3HG2 THR    38      -1.457  10.330  -2.801  1.00  0.00
ATOM    720  C   THR    38      -2.287  10.681   1.502  1.00  0.00
ATOM    721  O   THR    38      -2.158  10.293   2.662  1.00  0.00
ATOM    722  N   VAL    39      -3.443  11.114   1.010  1.00  0.00
ATOM    723  H   VAL    39      -3.484  11.406   0.078  1.00  0.00
ATOM    724  CA  VAL    39      -4.652  11.159   1.822  1.00  0.00
ATOM    725  HA  VAL    39      -4.626  10.323   2.507  1.00  0.00
ATOM    726  CB  VAL    39      -4.723  12.457   2.650  1.00  0.00
ATOM    727  HB  VAL    39      -5.652  12.460   3.199  1.00  0.00
ATOM    728  QG1 VAL    39      -3.310  12.529   3.890  1.00  0.00
ATOM    729  QG2 VAL    39      -4.700  13.956   1.525  1.00  0.00
ATOM    730  CG1 VAL    39      -3.580  12.517   3.652  1.00  0.00
ATOM    731 1HG1 VAL    39      -3.404  11.532   4.058  1.00  0.00
ATOM    732 2HG1 VAL    39      -3.838  13.196   4.452  1.00  0.00
ATOM    733 3HG1 VAL    39      -2.688  12.860   3.161  1.00  0.00
ATOM    734  CG2 VAL    39      -4.705  13.666   1.742  1.00  0.00
ATOM    735 1HG2 VAL    39      -4.785  14.566   2.337  1.00  0.00
ATOM    736 2HG2 VAL    39      -5.536  13.615   1.054  1.00  0.00
ATOM    737 3HG2 VAL    39      -3.779  13.687   1.185  1.00  0.00
ATOM    738  QQG VAL    39      -4.005  13.243   2.708  1.00  0.00
ATOM    739  C   VAL    39      -5.903  11.050   0.957  1.00  0.00
ATOM    740  O   VAL    39      -6.912  11.704   1.222  1.00  0.00
ATOM    741  N   GLU    40      -5.832  10.222  -0.079  1.00  0.00
ATOM    742  H   GLU    40      -5.001   9.728  -0.242  1.00  0.00
ATOM    743  CA  GLU    40      -6.960  10.031  -0.984  1.00  0.00
ATOM    744  HA  GLU    40      -7.812   9.731  -0.392  1.00  0.00
ATOM    745  CB  GLU    40      -7.291  11.338  -1.701  1.00  0.00
ATOM    746 1HB  GLU    40      -6.881  11.301  -2.703  1.00  0.00
ATOM    747 2HB  GLU    40      -6.835  12.155  -1.159  1.00  0.00
ATOM    748  QB  GLU    40      -6.858  11.728  -1.931  1.00  0.00
ATOM    749  CG  GLU    40      -8.782  11.610  -1.808  1.00  0.00
ATOM    750 1HG  GLU    40      -9.234  11.458  -0.841  1.00  0.00
ATOM    751 2HG  GLU    40      -9.211  10.927  -2.522  1.00  0.00
ATOM    752  QG  GLU    40      -9.223  11.193  -1.682  1.00  0.00
ATOM    753  CD  GLU    40      -9.084  13.025  -2.259  1.00  0.00
ATOM    754  OE1 GLU    40      -8.242  13.914  -2.020  1.00  0.00
ATOM    755  OE2 GLU    40     -10.162  13.242  -2.850  1.00  0.00
ATOM    756  C   GLU    40      -6.664   8.939  -2.007  1.00  0.00
ATOM    757  O   GLU    40      -5.578   8.900  -2.588  1.00  0.00
ATOM    758  N   GLY    41      -7.632   8.058  -2.223  1.00  0.00
ATOM    759  H   GLY    41      -8.477   8.138  -1.728  1.00  0.00
ATOM    760  CA  GLY    41      -7.450   6.978  -3.179  1.00  0.00
ATOM    761 1HA  GLY    41      -6.452   6.578  -3.061  1.00  0.00
ATOM    762 2HA  GLY    41      -7.555   7.373  -4.182  1.00  0.00
ATOM    763  QA  GLY    41      -7.003   6.975  -3.622  1.00  0.00
ATOM    764  C   GLY    41      -8.451   5.855  -2.987  1.00  0.00
ATOM    765  O   GLY    41      -9.208   5.845  -2.016  1.00  0.00
ATOM    766  N   VAL    42      -8.446   4.901  -3.912  1.00  0.00
ATOM    767  H   VAL    42      -7.812   4.961  -4.654  1.00  0.00
ATOM    768  CA  VAL    42      -9.346   3.759  -3.842  1.00  0.00
ATOM    769  HA  VAL    42     -10.138   3.999  -3.146  1.00  0.00
ATOM    770  CB  VAL    42      -9.979   3.436  -5.211  1.00  0.00
ATOM    771  HB  VAL    42      -9.238   2.939  -5.821  1.00  0.00
ATOM    772  QG1 VAL    42     -11.439   2.268  -5.002  1.00  0.00
ATOM    773  QG2 VAL    42     -10.507   5.014  -6.091  1.00  0.00
ATOM    774  CG1 VAL    42     -11.160   2.492  -5.041  1.00  0.00
ATOM    775 1HG1 VAL    42     -11.615   2.308  -6.004  1.00  0.00
ATOM    776 2HG1 VAL    42     -11.886   2.939  -4.381  1.00  0.00
ATOM    777 3HG1 VAL    42     -10.817   1.558  -4.622  1.00  0.00
ATOM    778  CG2 VAL    42     -10.405   4.712  -5.922  1.00  0.00
ATOM    779 1HG2 VAL    42      -9.690   4.950  -6.695  1.00  0.00
ATOM    780 2HG2 VAL    42     -10.450   5.524  -5.211  1.00  0.00
ATOM    781 3HG2 VAL    42     -11.380   4.570  -6.367  1.00  0.00
ATOM    782  QQG VAL    42     -10.973   3.641  -5.546  1.00  0.00
ATOM    783  C   VAL    42      -8.601   2.540  -3.331  1.00  0.00
ATOM    784  O   VAL    42      -7.770   1.962  -4.031  1.00  0.00
ATOM    785  N   TRP    43      -8.900   2.174  -2.094  1.00  0.00
ATOM    786  H   TRP    43      -9.559   2.688  -1.592  1.00  0.00
ATOM    787  CA  TRP    43      -8.277   1.051  -1.439  1.00  0.00
ATOM    788  HA  TRP    43      -7.204   1.156  -1.532  1.00  0.00
ATOM    789  CB  TRP    43      -8.662   1.098   0.034  1.00  0.00
ATOM    790 1HB  TRP    43      -8.802   0.101   0.393  1.00  0.00
ATOM    791 2HB  TRP    43      -9.598   1.632   0.124  1.00  0.00
ATOM    792  QB  TRP    43      -9.200   0.867   0.258  1.00  0.00
ATOM    793  CG  TRP    43      -7.645   1.792   0.903  1.00  0.00
ATOM    794  CD1 TRP    43      -7.558   3.140   1.151  1.00  0.00
ATOM    795  CD2 TRP    43      -6.565   1.186   1.635  1.00  0.00
ATOM    796  CE3 TRP    43      -6.110  -0.132   1.795  1.00  0.00
ATOM    797  CE2 TRP    43      -5.881   2.223   2.301  1.00  0.00
ATOM    798  NE1 TRP    43      -6.506   3.400   1.989  1.00  0.00
ATOM    799  HD  TRP    43      -8.227   3.885   0.741  1.00  0.00
ATOM    800 3HE  TRP    43      -6.618  -0.954   1.293  1.00  0.00
ATOM    801  CZ3 TRP    43      -4.991  -0.358   2.614  1.00  0.00
ATOM    802  CZ2 TRP    43      -4.774   1.994   3.109  1.00  0.00
ATOM    803 1HE  TRP    43      -6.243   4.288   2.313  1.00  0.00
ATOM    804 3HZ  TRP    43      -4.600  -1.365   2.771  1.00  0.00
ATOM    805  CH2 TRP    43      -4.347   0.705   3.254  1.00  0.00
ATOM    806 2HZ  TRP    43      -4.262   2.799   3.613  1.00  0.00
ATOM    807  HH  TRP    43      -3.489   0.488   3.875  1.00  0.00
ATOM    808  C   TRP    43      -8.713  -0.271  -2.061  1.00  0.00
ATOM    809  O   TRP    43      -9.896  -0.615  -2.050  1.00  0.00
ATOM    810  N   THR    44      -7.750  -1.012  -2.595  1.00  0.00
ATOM    811  H   THR    44      -6.826  -0.685  -2.567  1.00  0.00
ATOM    812  CA  THR    44      -8.026  -2.303  -3.217  1.00  0.00
ATOM    813  HA  THR    44      -8.945  -2.684  -2.798  1.00  0.00
ATOM    814  CB  THR    44      -8.190  -2.144  -4.729  1.00  0.00
ATOM    815  HB  THR    44      -7.874  -3.056  -5.212  1.00  0.00
ATOM    816  QG2 THR    44      -9.957  -1.800  -5.250  1.00  0.00
ATOM    817  OG1 THR    44      -7.387  -1.083  -5.211  1.00  0.00
ATOM    818 1HG  THR    44      -7.235  -1.198  -6.152  1.00  0.00
ATOM    819  CG2 THR    44      -9.618  -1.866  -5.149  1.00  0.00
ATOM    820 1HG2 THR    44      -9.650  -1.686  -6.215  1.00  0.00
ATOM    821 2HG2 THR    44      -9.984  -0.997  -4.625  1.00  0.00
ATOM    822 3HG2 THR    44     -10.236  -2.718  -4.909  1.00  0.00
ATOM    823  C   THR    44      -6.899  -3.284  -2.914  1.00  0.00
ATOM    824  O   THR    44      -5.828  -2.883  -2.467  1.00  0.00
ATOM    825  N   TYR    45      -7.141  -4.569  -3.159  1.00  0.00
ATOM    826  H   TYR    45      -8.014  -4.834  -3.520  1.00  0.00
ATOM    827  CA  TYR    45      -6.125  -5.586  -2.907  1.00  0.00
ATOM    828  HA  TYR    45      -5.167  -5.098  -2.972  1.00  0.00
ATOM    829  CB  TYR    45      -6.279  -6.173  -1.489  1.00  0.00
ATOM    830 1HB  TYR    45      -7.321  -6.139  -1.199  1.00  0.00
ATOM    831 2HB  TYR    45      -5.699  -5.570  -0.803  1.00  0.00
ATOM    832  QB  TYR    45      -6.510  -5.855  -1.001  1.00  0.00
ATOM    833  QD  TYR    45      -5.748  -7.769  -1.321  1.00  0.00
ATOM    834  QE  TYR    45      -4.977 -10.090  -1.066  1.00  0.00
ATOM    835  QR  TYR    45      -5.363  -8.930  -1.194  1.00  0.00
ATOM    836  CG  TYR    45      -5.803  -7.604  -1.340  1.00  0.00
ATOM    837  CD1 TYR    45      -4.587  -7.891  -0.729  1.00  0.00
ATOM    838 1HD  TYR    45      -3.979  -7.077  -0.364  1.00  0.00
ATOM    839  CE1 TYR    45      -4.151  -9.194  -0.584  1.00  0.00
ATOM    840 1HE  TYR    45      -3.205  -9.395  -0.104  1.00  0.00
ATOM    841  CZ  TYR    45      -4.930 -10.230  -1.050  1.00  0.00
ATOM    842  CE2 TYR    45      -6.139  -9.973  -1.661  1.00  0.00
ATOM    843 2HE  TYR    45      -6.750 -10.785  -2.028  1.00  0.00
ATOM    844  CD2 TYR    45      -6.570  -8.668  -1.802  1.00  0.00
ATOM    845 2HD  TYR    45      -7.516  -8.462  -2.279  1.00  0.00
ATOM    846  OH  TYR    45      -4.499 -11.530  -0.908  1.00  0.00
ATOM    847  HH  TYR    45      -4.442 -11.945  -1.771  1.00  0.00
ATOM    848  C   TYR    45      -6.164  -6.684  -3.965  1.00  0.00
ATOM    849  O   TYR    45      -7.224  -7.223  -4.284  1.00  0.00
ATOM    850  N   LYS+   46      -4.991  -7.010  -4.500  1.00  0.00
ATOM    851  H   LYS+   46      -4.185  -6.543  -4.197  1.00  0.00
ATOM    852  CA  LYS+   46      -4.873  -8.045  -5.519  1.00  0.00
ATOM    853  HA  LYS+   46      -5.820  -8.113  -6.032  1.00  0.00
ATOM    854  CB  LYS+   46      -3.778  -7.693  -6.533  1.00  0.00
ATOM    855 1HB  LYS+   46      -3.945  -8.269  -7.434  1.00  0.00
ATOM    856 2HB  LYS+   46      -2.815  -7.958  -6.116  1.00  0.00
ATOM    857  QB  LYS+   46      -3.380  -8.113  -6.775  1.00  0.00
ATOM    858  CG  LYS+   46      -3.742  -6.219  -6.913  1.00  0.00
ATOM    859 1HG  LYS+   46      -2.715  -5.922  -7.064  1.00  0.00
ATOM    860 2HG  LYS+   46      -4.173  -5.637  -6.114  1.00  0.00
ATOM    861  QG  LYS+   46      -3.444  -5.780  -6.589  1.00  0.00
ATOM    862  CD  LYS+   46      -4.524  -5.956  -8.191  1.00  0.00
ATOM    863 1HD  LYS+   46      -4.565  -4.891  -8.363  1.00  0.00
ATOM    864 2HD  LYS+   46      -5.526  -6.342  -8.074  1.00  0.00
ATOM    865  QD  LYS+   46      -5.045  -5.617  -8.218  1.00  0.00
ATOM    866  CE  LYS+   46      -3.875  -6.627  -9.390  1.00  0.00
ATOM    867 1HE  LYS+   46      -3.166  -7.358  -9.030  1.00  0.00
ATOM    868 2HE  LYS+   46      -3.356  -5.876  -9.969  1.00  0.00
ATOM    869  QE  LYS+   46      -3.261  -6.617  -9.499  1.00  0.00
ATOM    870  NZ  LYS+   46      -4.880  -7.298 -10.253  1.00  0.00
ATOM    871 1HZ  LYS+   46      -5.754  -6.736 -10.290  1.00  0.00
ATOM    872 2HZ  LYS+   46      -5.101  -8.243  -9.881  1.00  0.00
ATOM    873 3HZ  LYS+   46      -4.503  -7.403 -11.221  1.00  0.00
ATOM    874  QZ  LYS+   46      -5.120  -7.461 -10.464  1.00  0.00
ATOM    875  C   LYS+   46      -4.566  -9.393  -4.875  1.00  0.00
ATOM    876  O   LYS+   46      -3.638  -9.512  -4.068  1.00  0.00
ATOM    877  N   ASP    47      -5.356 -10.400  -5.241  1.00  0.00
ATOM    878  H   ASP    47      -6.075 -10.231  -5.886  1.00  0.00
ATOM    879  CA  ASP    47      -5.187 -11.748  -4.710  1.00  0.00
ATOM    880  HA  ASP    47      -4.774 -11.661  -3.715  1.00  0.00
ATOM    881  CB  ASP    47      -6.538 -12.459  -4.628  1.00  0.00
ATOM    882 1HB  ASP    47      -6.704 -13.009  -5.545  1.00  0.00
ATOM    883 2HB  ASP    47      -7.320 -11.724  -4.504  1.00  0.00
ATOM    884  QB  ASP    47      -7.012 -12.366  -5.025  1.00  0.00
ATOM    885  CG  ASP    47      -6.609 -13.432  -3.467  1.00  0.00
ATOM    886  OD1 ASP    47      -7.666 -13.488  -2.803  1.00  0.00
ATOM    887  OD2 ASP    47      -5.609 -14.139  -3.222  1.00  0.00
ATOM    888  C   ASP    47      -4.224 -12.555  -5.572  1.00  0.00
ATOM    889  O   ASP    47      -4.517 -12.868  -6.725  1.00  0.00
ATOM    890  N   GLU    48      -3.074 -12.889  -4.996  1.00  0.00
ATOM    891  H   GLU    48      -2.911 -12.605  -4.069  1.00  0.00
ATOM    892  CA  GLU    48      -2.045 -13.661  -5.688  1.00  0.00
ATOM    893  HA  GLU    48      -2.370 -14.695  -5.720  1.00  0.00
ATOM    894  CB  GLU    48      -1.844 -13.164  -7.128  1.00  0.00
ATOM    895 1HB  GLU    48      -2.644 -13.554  -7.741  1.00  0.00
ATOM    896 2HB  GLU    48      -0.904 -13.543  -7.497  1.00  0.00
ATOM    897  QB  GLU    48      -1.774 -13.548  -7.619  1.00  0.00
ATOM    898  CG  GLU    48      -1.831 -11.649  -7.274  1.00  0.00
ATOM    899 1HG  GLU    48      -0.806 -11.310  -7.274  1.00  0.00
ATOM    900 2HG  GLU    48      -2.354 -11.213  -6.440  1.00  0.00
ATOM    901  QG  GLU    48      -1.580 -11.262  -6.857  1.00  0.00
ATOM    902  CD  GLU    48      -2.494 -11.183  -8.558  1.00  0.00
ATOM    903  OE1 GLU    48      -3.630 -10.668  -8.484  1.00  0.00
ATOM    904  OE2 GLU    48      -1.875 -11.330  -9.634  1.00  0.00
ATOM    905  C   GLU    48      -0.729 -13.593  -4.927  1.00  0.00
ATOM    906  O   GLU    48      -0.233 -14.604  -4.429  1.00  0.00
ATOM    907  N   ILE    49      -0.178 -12.388  -4.820  1.00  0.00
ATOM    908  H   ILE    49      -0.624 -11.619  -5.226  1.00  0.00
ATOM    909  CA  ILE    49       1.067 -12.178  -4.098  1.00  0.00
ATOM    910  HA  ILE    49       1.411 -13.135  -3.735  1.00  0.00
ATOM    911  CB  ILE    49       2.158 -11.584  -5.008  1.00  0.00
ATOM    912  HB  ILE    49       3.002 -11.315  -4.391  1.00  0.00
ATOM    913  QG2 ILE    49       2.735 -12.866  -6.255  1.00  0.00
ATOM    914  CG2 ILE    49       2.624 -12.618  -6.012  1.00  0.00
ATOM    915 1HG2 ILE    49       2.410 -13.611  -5.641  1.00  0.00
ATOM    916 2HG2 ILE    49       3.689 -12.519  -6.175  1.00  0.00
ATOM    917 3HG2 ILE    49       2.106 -12.468  -6.948  1.00  0.00
ATOM    918  CG1 ILE    49       1.639 -10.334  -5.719  1.00  0.00
ATOM    919 1HG1 ILE    49       0.720 -10.014  -5.249  1.00  0.00
ATOM    920 2HG1 ILE    49       1.445 -10.568  -6.752  1.00  0.00
ATOM    921  QG1 ILE    49       1.082 -10.291  -6.000  1.00  0.00
ATOM    922  QD1 ILE    49       2.842  -8.902  -5.670  1.00  0.00
ATOM    923  CD1 ILE    49       2.611  -9.176  -5.680  1.00  0.00
ATOM    924 1HD1 ILE    49       3.489  -9.424  -6.259  1.00  0.00
ATOM    925 2HD1 ILE    49       2.897  -8.984  -4.657  1.00  0.00
ATOM    926 3HD1 ILE    49       2.140  -8.298  -6.095  1.00  0.00
ATOM    927  C   ILE    49       0.847 -11.248  -2.906  1.00  0.00
ATOM    928  O   ILE    49       1.797 -10.693  -2.354  1.00  0.00
ATOM    929  N   LYS+   50      -0.417 -11.086  -2.512  1.00  0.00
ATOM    930  H   LYS+   50      -1.131 -11.557  -2.990  1.00  0.00
ATOM    931  CA  LYS+   50      -0.766 -10.228  -1.386  1.00  0.00
ATOM    932  HA  LYS+   50      -1.837 -10.261  -1.261  1.00  0.00
ATOM    933  CB  LYS+   50      -0.099 -10.744  -0.110  1.00  0.00
ATOM    934 1HB  LYS+   50       0.198  -9.900   0.493  1.00  0.00
ATOM    935 2HB  LYS+   50       0.780 -11.310  -0.380  1.00  0.00
ATOM    936  QB  LYS+   50       0.489 -10.605   0.056  1.00  0.00
ATOM    937  CG  LYS+   50      -1.003 -11.636   0.728  1.00  0.00
ATOM    938 1HG  LYS+   50      -1.842 -11.949   0.125  1.00  0.00
ATOM    939 2HG  LYS+   50      -1.357 -11.075   1.579  1.00  0.00
ATOM    940  QG  LYS+   50      -1.600 -11.512   0.852  1.00  0.00
ATOM    941  CD  LYS+   50      -0.265 -12.868   1.226  1.00  0.00
ATOM    942 1HD  LYS+   50      -0.760 -13.240   2.111  1.00  0.00
ATOM    943 2HD  LYS+   50       0.752 -12.595   1.467  1.00  0.00
ATOM    944  QD  LYS+   50      -0.004 -12.917   1.789  1.00  0.00
ATOM    945  CE  LYS+   50      -0.242 -13.967   0.175  1.00  0.00
ATOM    946 1HE  LYS+   50       0.630 -13.834  -0.447  1.00  0.00
ATOM    947 2HE  LYS+   50      -1.132 -13.885  -0.431  1.00  0.00
ATOM    948  QE  LYS+   50      -0.251 -13.859  -0.439  1.00  0.00
ATOM    949  NZ  LYS+   50      -0.198 -15.322   0.789  1.00  0.00
ATOM    950 1HZ  LYS+   50      -1.163 -15.674   0.952  1.00  0.00
ATOM    951 2HZ  LYS+   50       0.302 -15.285   1.701  1.00  0.00
ATOM    952 3HZ  LYS+   50       0.300 -15.983   0.160  1.00  0.00
ATOM    953  QZ  LYS+   50      -0.187 -15.647   0.937  1.00  0.00
ATOM    954  C   LYS+   50      -0.347  -8.785  -1.648  1.00  0.00
ATOM    955  O   LYS+   50       0.774  -8.388  -1.327  1.00  0.00
ATOM    956  N   THR    51      -1.247  -7.999  -2.235  1.00  0.00
ATOM    957  H   THR    51      -2.127  -8.360  -2.473  1.00  0.00
ATOM    958  CA  THR    51      -0.936  -6.604  -2.527  1.00  0.00
ATOM    959  HA  THR    51      -0.243  -6.261  -1.777  1.00  0.00
ATOM    960  CB  THR    51      -0.275  -6.485  -3.900  1.00  0.00
ATOM    961  HB  THR    51      -0.047  -5.446  -4.090  1.00  0.00
ATOM    962  QG2 THR    51       1.321  -7.456  -4.038  1.00  0.00
ATOM    963  OG1 THR    51      -1.145  -6.942  -4.918  1.00  0.00
ATOM    964 1HG  THR    51      -1.293  -7.886  -4.814  1.00  0.00
ATOM    965  CG2 THR    51       1.014  -7.269  -4.012  1.00  0.00
ATOM    966 1HG2 THR    51       0.789  -8.304  -4.220  1.00  0.00
ATOM    967 2HG2 THR    51       1.560  -7.200  -3.082  1.00  0.00
ATOM    968 3HG2 THR    51       1.614  -6.864  -4.813  1.00  0.00
ATOM    969  C   THR    51      -2.176  -5.718  -2.471  1.00  0.00
ATOM    970  O   THR    51      -3.274  -6.140  -2.826  1.00  0.00
ATOM    971  N   PHE    52      -1.976  -4.479  -2.030  1.00  0.00
ATOM    972  H   PHE    52      -1.069  -4.210  -1.771  1.00  0.00
ATOM    973  CA  PHE    52      -3.056  -3.505  -1.929  1.00  0.00
ATOM    974  HA  PHE    52      -3.957  -3.968  -2.292  1.00  0.00
ATOM    975  CB  PHE    52      -3.262  -3.075  -0.476  1.00  0.00
ATOM    976 1HB  PHE    52      -4.238  -2.622  -0.378  1.00  0.00
ATOM    977 2HB  PHE    52      -2.507  -2.348  -0.212  1.00  0.00
ATOM    978  QB  PHE    52      -3.372  -2.485  -0.295  1.00  0.00
ATOM    979  QD  PHE    52      -3.164  -4.331   0.617  1.00  0.00
ATOM    980  QE  PHE    52      -3.020  -6.182   2.231  1.00  0.00
ATOM    981  QR  PHE    52      -3.063  -5.628   1.747  1.00  0.00
ATOM    982  CG  PHE    52      -3.174  -4.207   0.509  1.00  0.00
ATOM    983  CD1 PHE    52      -4.319  -4.731   1.087  1.00  0.00
ATOM    984 1HD  PHE    52      -5.282  -4.319   0.822  1.00  0.00
ATOM    985  CE1 PHE    52      -4.241  -5.771   1.993  1.00  0.00
ATOM    986 1HE  PHE    52      -5.141  -6.170   2.437  1.00  0.00
ATOM    987  CZ  PHE    52      -3.011  -6.297   2.332  1.00  0.00
ATOM    988  HZ  PHE    52      -2.947  -7.111   3.040  1.00  0.00
ATOM    989  CE2 PHE    52      -1.862  -5.785   1.763  1.00  0.00
ATOM    990 2HE  PHE    52      -0.899  -6.195   2.025  1.00  0.00
ATOM    991  CD2 PHE    52      -1.947  -4.745   0.856  1.00  0.00
ATOM    992 2HD  PHE    52      -1.047  -4.344   0.412  1.00  0.00
ATOM    993  C   PHE    52      -2.744  -2.285  -2.792  1.00  0.00
ATOM    994  O   PHE    52      -1.596  -2.061  -3.160  1.00  0.00
ATOM    995  N   THR    53      -3.763  -1.500  -3.120  1.00  0.00
ATOM    996  H   THR    53      -4.667  -1.721  -2.809  1.00  0.00
ATOM    997  CA  THR    53      -3.555  -0.314  -3.943  1.00  0.00
ATOM    998  HA  THR    53      -2.543   0.021  -3.765  1.00  0.00
ATOM    999  CB  THR    53      -3.712  -0.666  -5.430  1.00  0.00
ATOM   1000  HB  THR    53      -4.663  -1.161  -5.570  1.00  0.00
ATOM   1001  QG2 THR    53      -3.670   0.819  -6.589  1.00  0.00
ATOM   1002  OG1 THR    53      -2.689  -1.555  -5.841  1.00  0.00
ATOM   1003 1HG  THR    53      -2.713  -2.345  -5.297  1.00  0.00
ATOM   1004  CG2 THR    53      -3.677   0.535  -6.365  1.00  0.00
ATOM   1005 1HG2 THR    53      -4.340   1.303  -5.994  1.00  0.00
ATOM   1006 2HG2 THR    53      -4.000   0.230  -7.349  1.00  0.00
ATOM   1007 3HG2 THR    53      -2.669   0.926  -6.424  1.00  0.00
ATOM   1008  C   THR    53      -4.515   0.811  -3.560  1.00  0.00
ATOM   1009  O   THR    53      -5.621   0.567  -3.080  1.00  0.00
ATOM   1010  N   VAL    54      -4.080   2.044  -3.798  1.00  0.00
ATOM   1011  H   VAL    54      -3.192   2.163  -4.196  1.00  0.00
ATOM   1012  CA  VAL    54      -4.889   3.221  -3.504  1.00  0.00
ATOM   1013  HA  VAL    54      -5.919   2.894  -3.402  1.00  0.00
ATOM   1014  CB  VAL    54      -4.465   3.892  -2.165  1.00  0.00
ATOM   1015  HB  VAL    54      -4.021   3.130  -1.538  1.00  0.00
ATOM   1016  QG1 VAL    54      -3.185   5.257  -2.404  1.00  0.00
ATOM   1017  QG2 VAL    54      -5.980   4.560  -1.266  1.00  0.00
ATOM   1018  CG1 VAL    54      -3.429   4.996  -2.360  1.00  0.00
ATOM   1019 1HG1 VAL    54      -3.027   5.284  -1.399  1.00  0.00
ATOM   1020 2HG1 VAL    54      -3.897   5.851  -2.824  1.00  0.00
ATOM   1021 3HG1 VAL    54      -2.629   4.637  -2.990  1.00  0.00
ATOM   1022  CG2 VAL    54      -5.689   4.432  -1.438  1.00  0.00
ATOM   1023 1HG2 VAL    54      -6.551   4.373  -2.088  1.00  0.00
ATOM   1024 2HG2 VAL    54      -5.520   5.463  -1.161  1.00  0.00
ATOM   1025 3HG2 VAL    54      -5.869   3.844  -0.550  1.00  0.00
ATOM   1026  QQG VAL    54      -4.582   4.909  -1.835  1.00  0.00
ATOM   1027  C   VAL    54      -4.819   4.212  -4.670  1.00  0.00
ATOM   1028  O   VAL    54      -3.838   4.940  -4.833  1.00  0.00
ATOM   1029  N   THR    55      -5.855   4.212  -5.500  1.00  0.00
ATOM   1030  H   THR    55      -6.598   3.596  -5.337  1.00  0.00
ATOM   1031  CA  THR    55      -5.899   5.092  -6.665  1.00  0.00
ATOM   1032  HA  THR    55      -4.892   5.423  -6.866  1.00  0.00
ATOM   1033  CB  THR    55      -6.419   4.327  -7.884  1.00  0.00
ATOM   1034  HB  THR    55      -6.878   5.027  -8.567  1.00  0.00
ATOM   1035  QG2 THR    55      -5.071   3.416  -8.815  1.00  0.00
ATOM   1036  OG1 THR    55      -7.394   3.374  -7.499  1.00  0.00
ATOM   1037 1HG  THR    55      -7.801   2.997  -8.283  1.00  0.00
ATOM   1038  CG2 THR    55      -5.330   3.591  -8.636  1.00  0.00
ATOM   1039 1HG2 THR    55      -4.676   4.306  -9.113  1.00  0.00
ATOM   1040 2HG2 THR    55      -5.778   2.955  -9.386  1.00  0.00
ATOM   1041 3HG2 THR    55      -4.761   2.987  -7.945  1.00  0.00
ATOM   1042  C   THR    55      -6.775   6.317  -6.411  1.00  0.00
ATOM   1043  O   THR    55      -7.947   6.192  -6.058  1.00  0.00
ATOM   1044  N   GLU    56      -6.199   7.500  -6.601  1.00  0.00
ATOM   1045  H   GLU    56      -5.261   7.535  -6.889  1.00  0.00
ATOM   1046  CA  GLU    56      -6.927   8.747  -6.399  1.00  0.00
ATOM   1047  HA  GLU    56      -7.770   8.537  -5.760  1.00  0.00
ATOM   1048  CB  GLU    56      -6.030   9.777  -5.713  1.00  0.00
ATOM   1049 1HB  GLU    56      -5.149   9.927  -6.318  1.00  0.00
ATOM   1050 2HB  GLU    56      -5.733   9.403  -4.749  1.00  0.00
ATOM   1051  QB  GLU    56      -5.441   9.665  -5.534  1.00  0.00
ATOM   1052  CG  GLU    56      -6.701  11.127  -5.507  1.00  0.00
ATOM   1053 1HG  GLU    56      -7.558  10.991  -4.862  1.00  0.00
ATOM   1054 2HG  GLU    56      -7.026  11.507  -6.468  1.00  0.00
ATOM   1055  QG  GLU    56      -7.292  11.249  -5.665  1.00  0.00
ATOM   1056  CD  GLU    56      -5.774  12.152  -4.879  1.00  0.00
ATOM   1057  OE1 GLU    56      -5.765  13.304  -5.340  1.00  0.00
ATOM   1058  OE2 GLU    56      -5.057  11.787  -3.920  1.00  0.00
ATOM   1059  C   GLU    56      -7.440   9.292  -7.725  1.00  0.00
ATOM   1060  OT1 GLU    56      -6.622   9.833  -8.495  1.00  0.00
ATOM   1061  OT2 GLU    56      -8.657   9.170  -7.983  1.00  0.00
END
