
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  186 ( 1518),  selected  186 , name 2ol5_B
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2ol5_B.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N    10_B      M       1           #
LGA    -       -      A       2           -
LGA    -       -      D       3           -
LGA    -       -      P       4           -
LGA    -       -      K       5           -
LGA    -       -      E       6           -
LGA    D    11_B      L       7          1.310
LGA    P    12_B      Q       8          1.416
LGA    D    13_B      D       9          1.071
LGA    V    14_B      K      10          1.421
LGA    A    15_B      F      11          1.432
LGA    Y    16_B      W      12          1.318
LGA    Q    17_B      K      13          1.501
LGA    V    18_B      A      14          1.556
LGA    I    19_B      L      15          1.140
LGA    E    20_B      K      16          1.722
LGA    E    21_B      S      17          2.135
LGA    N    22_B      D      18          1.097
LGA    S    23_B      R      19          0.631
LGA    F    24_B      T      20          1.996
LGA    A    25_B      V      21          2.019
LGA    T    26_B      M      22          1.360
LGA    L    27_B      L      23          1.533
LGA    V    28_B      G      24          1.564
LGA    S    29_B      L      25          1.462
LGA    X    30_B      D      26          4.243
LGA    H    31_B      G      27           -
LGA    Q    32_B      V      28           #
LGA    R    33_B      E      29          3.512
LGA    E    34_B      D      30          1.494
LGA    L    35_B      G      31          1.526
LGA    F    36_B      H      32          1.423
LGA    A    37_B      A      33          1.499
LGA    T    38_B      R      34          2.170
LGA    H    39_B      P      35          1.440
LGA    L    40_B      M      36          1.694
LGA    P    41_B      T      37          0.842
LGA    L    42_B      A      38          0.454
LGA    L    43_B      Q      39          1.178
LGA    L    44_B      I      40          2.049
LGA    D    45_B      E      41          2.372
LGA    R    46_B      G      42          1.852
LGA    E    47_B      D      43           #
LGA    K    48_B      S      44          3.224
LGA    T    49_B      G      45          3.121
LGA    C    50_B      G      46          1.628
LGA    -       -      P      47           -
LGA    L    51_B      I      48          0.316
LGA    Y    52_B      W      49          0.706
LGA    G    53_B      F      50          0.878
LGA    H    54_B      F      51          1.712
LGA    F    55_B      T      52          1.488
LGA    A    56_B      S      53          1.215
LGA    R    57_B      K      54          1.360
LGA    S    58_B      D      55          1.517
LGA    N    59_B      N      56          1.337
LGA    P    60_B      A      57          1.603
LGA    Q    61_B      L      58          0.978
LGA    W    62_B      I      59          1.308
LGA    N    63_B      A      60          1.036
LGA    D    64_B      M      61          1.116
LGA    I    65_B      L      62          3.003
LGA    Q    66_B      G      63          4.652
LGA    -       -      Q      64           -
LGA    H    67_B      G      65          3.292
LGA    Q    68_B      R      66          2.617
LGA    T    69_B      R      67          2.028
LGA    V    70_B      V      68          0.987
LGA    L    71_B      I      69          1.638
LGA    A    72_B      G      70          1.961
LGA    I    73_B      A      71          2.388
LGA    F    74_B      F      72          2.136
LGA    H    75_B      S      73          1.564
LGA    G    76_B      S      74          1.894
LGA    -       -      K      75           -
LGA    P    77_B      G      76          2.120
LGA    H    78_B      H      77          3.760
LGA    C    79_B      -       -           -
LGA    Y    80_B      -       -           -
LGA    I    81_B      -       -           -
LGA    S    82_B      -       -           -
LGA    P    83_B      -       -           -
LGA    S    84_B      -       -           -
LGA    W    85_B      -       -           -
LGA    Y    86_B      -       -           -
LGA    E    87_B      -       -           -
LGA    T    88_B      -       -           -
LGA    N    89_B      -       -           -
LGA    Q    90_B      -       -           -
LGA    A    91_B      -       -           -
LGA    V    92_B      -       -           -
LGA    P    93_B      -       -           -
LGA    T    94_B      -       -           -
LGA    W    95_B      -       -           -
LGA    N    96_B      -       -           -
LGA    Y    97_B      D      78          4.806
LGA    V    98_B      L      79          2.470
LGA    A    99_B      F      80          1.228
LGA    V   100_B      A      81          1.784
LGA    H   101_B      S      82          2.028
LGA    V   102_B      I      83          1.584
LGA    Y   103_B      S      84          1.303
LGA    G   104_B      G      85          0.921
LGA    N   105_B      S      86          0.530
LGA    V   106_B      L      87          1.607
LGA    E   107_B      R      88          2.903
LGA    L   108_B      E      89          1.659
LGA    I   109_B      D      90          1.321
LGA    N   110_B      T      91          2.709
LGA    D   111_B      D      92          2.713
LGA    Q   112_B      P      93          1.923
LGA    G   113_B      A      94          2.434
LGA    E   114_B      V      95          2.049
LGA    V   115_B      V      96          1.794
LGA    X   116_B      D      97          2.469
LGA    Q   117_B      R      98          2.217
LGA    S   118_B      L      99          1.977
LGA    L   119_B      W     100          1.960
LGA    H   120_B      N     101          3.705
LGA    D   121_B      -       -           -
LGA    X   122_B      -       -           -
LGA    V   123_B      P     102          3.816
LGA    E   124_B      -       -           -
LGA    K   125_B      -       -           -
LGA    Y   126_B      -       -           -
LGA    E   127_B      Y     103           #
LGA    A   128_B      V     104           -
LGA    P   129_B      -       -           -
LGA    G   130_B      -       -           -
LGA    S   131_B      -       -           -
LGA    R   132_B      -       -           -
LGA    Y   133_B      -       -           -
LGA    Q   134_B      -       -           -
LGA    L   135_B      A     105           #
LGA    S   136_B      A     106           -
LGA    E   137_B      W     107           -
LGA    V   138_B      Y     108           -
LGA    X   142_B      E     109           #
LGA    L   143_B      G     110          3.790
LGA    -       -      G     111           -
LGA    S   144_B      K     112          5.157
LGA    G   145_B      D     113          4.731
LGA    X   146_B      D     114          2.266
LGA    N   147_B      -       -           -
LGA    K   148_B      P     115          1.018
LGA    G   149_B      K     116          0.599
LGA    I   150_B      L     117          1.515
LGA    Q   151_B      A     118          1.084
LGA    A   152_B      L     119          0.647
LGA    F   153_B      L     120          1.681
LGA    K   154_B      R     121          1.170
LGA    I   155_B      L     122          0.981
LGA    I   156_B      D     123          0.877
LGA    I   157_B      A     124          1.196
LGA    K   158_B      D     125          0.526
LGA    R   159_B      H     126          0.307
LGA    I   160_B      A     127          1.862
LGA    E   161_B      Q     128          1.791
LGA    G   162_B      I     129          1.242
LGA    K   163_B      W     130          1.444
LGA    A   164_B      L     131          2.246
LGA    K   165_B      N     132          2.732
LGA    L   166_B      G     133          1.997
LGA    S   167_B      S     134          1.630
LGA    Q   168_B      -       -           -
LGA    N   169_B      S     135          3.811
LGA    H   170_B      L     136          2.337
LGA    P   171_B      -       -           -
LGA    A   172_B      -       -           -
LGA    H   173_B      -       -           -
LGA    R   174_B      -       -           -
LGA    Q   175_B      L     137           #
LGA    E   176_B      A     138           -
LGA    R   177_B      G     139           -
LGA    I   178_B      I     140           -
LGA    I   179_B      K     141           -
LGA    K   180_B      V     142           -
LGA    Q   181_B      L     143           -
LGA    L   182_B      L     144           -
LGA    E   183_B      G     145           -
LGA    Q   184_B      -       -           -
LGA    X   185_B      -       -           -
LGA    P   186_B      -       -           -
LGA    F   187_B      -       -           -
LGA    E   188_B      -       -           -
LGA    N   189_B      -       -           -
LGA    E   190_B      -       -           -
LGA    K   191_B      -       -           -
LGA    R   192_B      -       -           -
LGA    I   193_B      -       -           -
LGA    A   194_B      -       -           -
LGA    S   195_B      -       -           -
LGA    L   196_B      -       -           -
LGA    X   197_B      -       -           -
LGA    K   198_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  186  145    5.0    116    2.11     9.48     56.733     5.257

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.710075 * X  +   0.134956 * Y  +   0.691072 * Z  +  14.106397
  Y_new =   0.091675 * X  +  -0.990826 * Y  +   0.099297 * Z  +  19.255795
  Z_new =   0.698133 * X  +  -0.007154 * Y  +  -0.715933 * Z  +  13.634231 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.131600    0.009993  [ DEG:  -179.4275      0.5725 ]
  Theta =  -0.772786   -2.368807  [ DEG:   -44.2774   -135.7226 ]
  Phi   =   0.128396   -3.013196  [ DEG:     7.3566   -172.6434 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ol5_B                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ol5_B.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  186  145   5.0  116   2.11    9.48  56.733
REMARK  ---------------------------------------------------------- 
MOLECULE 2ol5_B
HEADER    TRANSCRIPTION REGULATOR                 18-JAN-07   2OL5              
TITLE     CRYSTAL STRUCTURE OF A PROTEASE SYNTHASE AND SPORULATION              
TITLE    2 NEGATIVE REGULATORY PROTEIN PAI 2 FROM BACILLUS                      
TITLE    3 STEAROTHERMOPHILUS                                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PAI 2 PROTEIN;                                             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS STEAROTHERMOPHILUS;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    PAI 2 PROTEIN, STRUCTURAL GENOMICS, PSI-2, PROTEIN                    
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.S.BRUNZELLE,M.E.CUFF,G.MINASOV,H.LI,A.JOACHIMIAK,                   
AUTHOR   2 W.F.ANDERSON,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   1   20-FEB-07 2OL5    0                                                
JRNL        AUTH   J.S.BRUNZELLE,M.E.CUFF,G.MINASOV,H.LI,S.MOY,                 
JRNL        AUTH 2 S.RAJAN,F.COLLART,A.JOACHIMIAK,W.F.ANDERSON                  
JRNL        TITL   CRYSTAL STRUCTURE OF A PROTEASE SYNTHASE AND                 
JRNL        TITL 2 SPORULATION NEGATIVE REGULATORY PROTEIN PAI 2 FROM           
JRNL        TITL 3 BACILLUS STEAROTHERMOPHILUS                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
SEQRES   1 A  202  MSE TYR ILE PRO LYS HIS PHE ALA VAL ASN ASP PRO ASP          
SEQRES   2 A  202  VAL ALA TYR GLN VAL ILE GLU GLU ASN SER PHE ALA THR          
SEQRES   3 A  202  LEU VAL SER MSE HIS GLN ARG GLU LEU PHE ALA THR HIS          
SEQRES   4 A  202  LEU PRO LEU LEU LEU ASP ARG GLU LYS THR CYS LEU TYR          
SEQRES   5 A  202  GLY HIS PHE ALA ARG SER ASN PRO GLN TRP ASN ASP ILE          
SEQRES   6 A  202  GLN HIS GLN THR VAL LEU ALA ILE PHE HIS GLY PRO HIS          
SEQRES   7 A  202  CYS TYR ILE SER PRO SER TRP TYR GLU THR ASN GLN ALA          
SEQRES   8 A  202  VAL PRO THR TRP ASN TYR VAL ALA VAL HIS VAL TYR GLY          
SEQRES   9 A  202  ASN VAL GLU LEU ILE ASN ASP GLN GLY GLU VAL MSE GLN          
SEQRES  10 A  202  SER LEU HIS ASP MSE VAL GLU LYS TYR GLU ALA PRO GLY          
SEQRES  11 A  202  SER ARG TYR GLN LEU SER GLU VAL ASP ALA GLY MSE LEU          
SEQRES  12 A  202  SER GLY MSE ASN LYS GLY ILE GLN ALA PHE LYS ILE ILE          
SEQRES  13 A  202  ILE LYS ARG ILE GLU GLY LYS ALA LYS LEU SER GLN ASN          
SEQRES  14 A  202  HIS PRO ALA HIS ARG GLN GLU ARG ILE ILE LYS GLN LEU          
SEQRES  15 A  202  GLU GLN MSE PRO PHE GLU ASN GLU LYS ARG ILE ALA SER          
SEQRES  16 A  202  LEU MSE LYS LYS GLN ARG GLN                                  
SEQRES   1 B  202  MSE TYR ILE PRO LYS HIS PHE ALA VAL ASN ASP PRO ASP          
SEQRES   2 B  202  VAL ALA TYR GLN VAL ILE GLU GLU ASN SER PHE ALA THR          
SEQRES   3 B  202  LEU VAL SER MSE HIS GLN ARG GLU LEU PHE ALA THR HIS          
SEQRES   4 B  202  LEU PRO LEU LEU LEU ASP ARG GLU LYS THR CYS LEU TYR          
SEQRES   5 B  202  GLY HIS PHE ALA ARG SER ASN PRO GLN TRP ASN ASP ILE          
SEQRES   6 B  202  GLN HIS GLN THR VAL LEU ALA ILE PHE HIS GLY PRO HIS          
SEQRES   7 B  202  CYS TYR ILE SER PRO SER TRP TYR GLU THR ASN GLN ALA          
SEQRES   8 B  202  VAL PRO THR TRP ASN TYR VAL ALA VAL HIS VAL TYR GLY          
SEQRES   9 B  202  ASN VAL GLU LEU ILE ASN ASP GLN GLY GLU VAL MSE GLN          
SEQRES  10 B  202  SER LEU HIS ASP MSE VAL GLU LYS TYR GLU ALA PRO GLY          
SEQRES  11 B  202  SER ARG TYR GLN LEU SER GLU VAL ASP ALA GLY MSE LEU          
SEQRES  12 B  202  SER GLY MSE ASN LYS GLY ILE GLN ALA PHE LYS ILE ILE          
SEQRES  13 B  202  ILE LYS ARG ILE GLU GLY LYS ALA LYS LEU SER GLN ASN          
SEQRES  14 B  202  HIS PRO ALA HIS ARG GLN GLU ARG ILE ILE LYS GLN LEU          
SEQRES  15 B  202  GLU GLN MSE PRO PHE GLU ASN GLU LYS ARG ILE ALA SER          
SEQRES  16 B  202  LEU MSE LYS LYS GLN ARG GLN                                  
HET    MSE  A  30       8                                                       
HET    MSE  A 116       8                                                       
HET    MSE  A 122       8                                                       
HET    MSE  A 142       8                                                       
HET    MSE  A 146       8                                                       
HET    MSE  A 185       8                                                       
HET    MSE  A 197       8                                                       
HET    MSE  B  30       8                                                       
HET    MSE  B 116       8                                                       
HET    MSE  B 122       8                                                       
HET    MSE  B 142       8                                                       
HET    MSE  B 146       8                                                       
HET    MSE  B 185       8                                                       
HET    MSE  B 197       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    14(C5 H11 N O2 SE)                                           
FORMUL   3  HOH   *108(H2 O)                                                    
CRYST1   62.601   77.949   89.453  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1496  N   ASN B  10      13.434  36.123  19.515  1.00 45.83           N  
ATOM   1497  CA  ASN B  10      13.650  37.348  18.754  1.00 46.01           C  
ATOM   1498  C   ASN B  10      12.613  38.418  19.078  1.00 46.02           C  
ATOM   1499  O   ASN B  10      12.919  39.414  19.732  1.00 46.13           O  
ATOM   1500  CB  ASN B  10      13.649  37.053  17.252  1.00 46.01           C  
ATOM   1501  CG  ASN B  10      14.718  36.053  16.855  1.00 46.58           C  
ATOM   1502  OD1 ASN B  10      15.899  36.239  17.151  1.00 46.65           O  
ATOM   1503  ND2 ASN B  10      14.309  34.986  16.180  1.00 46.76           N  
ATOM   1504  N   ASP B  11      11.385  38.205  18.615  1.00 46.13           N  
ATOM   1505  CA  ASP B  11      10.348  39.227  18.693  1.00 45.92           C  
ATOM   1506  C   ASP B  11       9.023  38.712  18.142  1.00 46.11           C  
ATOM   1507  O   ASP B  11       8.871  38.531  16.934  1.00 46.39           O  
ATOM   1508  CB  ASP B  11      10.780  40.485  17.937  1.00 45.77           C  
ATOM   1509  CG  ASP B  11       9.601  41.307  17.453  1.00 45.32           C  
ATOM   1510  OD1 ASP B  11       8.499  41.162  18.024  1.00 45.14           O  
ATOM   1511  OD2 ASP B  11       9.680  42.122  16.510  1.00 43.70           O  
ATOM   1512  N   PRO B  12       8.068  38.477  19.035  1.00 46.19           N  
ATOM   1513  CA  PRO B  12       6.899  37.651  18.714  1.00 46.02           C  
ATOM   1514  C   PRO B  12       6.764  37.420  17.213  1.00 46.04           C  
ATOM   1515  O   PRO B  12       6.925  36.293  16.746  1.00 45.79           O  
ATOM   1516  CB  PRO B  12       5.730  38.495  19.224  1.00 45.89           C  
ATOM   1517  CG  PRO B  12       6.310  39.303  20.329  1.00 45.88           C  
ATOM   1518  CD  PRO B  12       7.725  39.603  19.921  1.00 46.15           C  
ATOM   1519  N   ASP B  13       6.472  38.483  16.470  1.00 45.89           N  
ATOM   1520  CA  ASP B  13       6.248  38.375  15.031  1.00 45.89           C  
ATOM   1521  C   ASP B  13       7.328  37.679  14.238  1.00 45.53           C  
ATOM   1522  O   ASP B  13       7.021  36.782  13.455  1.00 45.79           O  
ATOM   1523  CB  ASP B  13       6.004  39.759  14.434  1.00 46.36           C  
ATOM   1524  CG  ASP B  13       4.533  40.072  14.281  1.00 47.09           C  
ATOM   1525  OD1 ASP B  13       3.680  39.251  14.732  1.00 47.61           O  
ATOM   1526  OD2 ASP B  13       4.235  41.131  13.679  1.00 47.54           O  
ATOM   1527  N   VAL B  14       8.584  38.085  14.408  1.00 44.77           N  
ATOM   1528  CA  VAL B  14       9.679  37.417  13.698  1.00 44.32           C  
ATOM   1529  C   VAL B  14       9.689  35.889  13.982  1.00 43.98           C  
ATOM   1530  O   VAL B  14       9.935  35.063  13.080  1.00 43.50           O  
ATOM   1531  CB  VAL B  14      11.042  38.071  14.026  1.00 44.29           C  
ATOM   1532  CG1 VAL B  14      12.187  37.394  13.259  1.00 43.37           C  
ATOM   1533  CG2 VAL B  14      11.000  39.599  13.737  1.00 44.62           C  
ATOM   1534  N   ALA B  15       9.389  35.522  15.232  1.00 43.90           N  
ATOM   1535  CA  ALA B  15       9.362  34.111  15.620  1.00 43.44           C  
ATOM   1536  C   ALA B  15       8.300  33.346  14.850  1.00 42.99           C  
ATOM   1537  O   ALA B  15       8.612  32.343  14.245  1.00 42.93           O  
ATOM   1538  CB  ALA B  15       9.179  33.956  17.127  1.00 43.31           C  
ATOM   1539  N   TYR B  16       7.061  33.832  14.833  1.00 42.49           N  
ATOM   1540  CA  TYR B  16       5.993  33.103  14.151  1.00 42.18           C  
ATOM   1541  C   TYR B  16       6.298  32.970  12.674  1.00 42.29           C  
ATOM   1542  O   TYR B  16       6.068  31.918  12.086  1.00 42.54           O  
ATOM   1543  CB  TYR B  16       4.628  33.730  14.348  1.00 42.12           C  
ATOM   1544  CG  TYR B  16       4.175  33.879  15.782  1.00 42.32           C  
ATOM   1545  CD1 TYR B  16       3.762  35.121  16.287  1.00 43.33           C  
ATOM   1546  CD2 TYR B  16       4.109  32.784  16.619  1.00 41.15           C  
ATOM   1547  CE1 TYR B  16       3.319  35.242  17.618  1.00 43.58           C  
ATOM   1548  CE2 TYR B  16       3.689  32.896  17.930  1.00 39.89           C  
ATOM   1549  CZ  TYR B  16       3.303  34.108  18.434  1.00 43.19           C  
ATOM   1550  OH  TYR B  16       2.882  34.159  19.752  1.00 42.17           O  
ATOM   1551  N   GLN B  17       6.845  34.013  12.075  1.00 41.61           N  
ATOM   1552  CA  GLN B  17       7.231  33.940  10.672  1.00 41.31           C  
ATOM   1553  C   GLN B  17       8.189  32.741  10.453  1.00 40.65           C  
ATOM   1554  O   GLN B  17       7.938  31.892   9.611  1.00 40.87           O  
ATOM   1555  CB  GLN B  17       7.843  35.278  10.227  1.00 41.52           C  
ATOM   1556  CG  GLN B  17       7.924  35.471   8.716  1.00 42.56           C  
ATOM   1557  CD  GLN B  17       8.898  36.570   8.329  1.00 43.62           C  
ATOM   1558  OE1 GLN B  17      10.006  36.293   7.861  1.00 44.10           O  
ATOM   1559  NE2 GLN B  17       8.497  37.833   8.549  1.00 43.89           N  
ATOM   1560  N   VAL B  18       9.248  32.631  11.253  1.00 39.50           N  
ATOM   1561  CA  VAL B  18      10.147  31.478  11.175  1.00 38.42           C  
ATOM   1562  C   VAL B  18       9.410  30.128  11.390  1.00 38.74           C  
ATOM   1563  O   VAL B  18       9.691  29.128  10.675  1.00 39.03           O  
ATOM   1564  CB  VAL B  18      11.319  31.598  12.175  1.00 38.20           C  
ATOM   1565  CG1 VAL B  18      12.187  30.333  12.146  1.00 37.53           C  
ATOM   1566  CG2 VAL B  18      12.160  32.823  11.886  1.00 37.32           C  
ATOM   1567  N   ILE B  19       8.527  30.069  12.392  1.00 38.12           N  
ATOM   1568  CA  ILE B  19       7.705  28.892  12.593  1.00 38.54           C  
ATOM   1569  C   ILE B  19       6.832  28.620  11.348  1.00 38.47           C  
ATOM   1570  O   ILE B  19       6.649  27.467  10.968  1.00 38.20           O  
ATOM   1571  CB  ILE B  19       6.786  29.007  13.853  1.00 39.14           C  
ATOM   1572  CG1 ILE B  19       7.632  29.204  15.127  1.00 39.23           C  
ATOM   1573  CG2 ILE B  19       5.889  27.761  13.986  1.00 39.51           C  
ATOM   1574  CD1 ILE B  19       6.834  29.363  16.397  1.00 38.19           C  
ATOM   1575  N   GLU B  20       6.314  29.671  10.707  1.00 38.09           N  
ATOM   1576  CA  GLU B  20       5.404  29.457   9.601  1.00 38.63           C  
ATOM   1577  C   GLU B  20       6.100  29.019   8.349  1.00 38.52           C  
ATOM   1578  O   GLU B  20       5.539  28.241   7.580  1.00 38.55           O  
ATOM   1579  CB  GLU B  20       4.520  30.674   9.343  1.00 39.16           C  
ATOM   1580  CG  GLU B  20       3.272  30.637  10.195  1.00 41.26           C  
ATOM   1581  CD  GLU B  20       2.410  31.854  10.078  1.00 45.04           C  
ATOM   1582  OE1 GLU B  20       2.933  32.987  10.170  1.00 46.69           O  
ATOM   1583  OE2 GLU B  20       1.184  31.673   9.949  1.00 46.61           O  
ATOM   1584  N   GLU B  21       7.336  29.483   8.174  1.00 38.14           N  
ATOM   1585  CA  GLU B  21       8.103  29.193   6.976  1.00 37.82           C  
ATOM   1586  C   GLU B  21       8.986  27.929   7.006  1.00 38.03           C  
ATOM   1587  O   GLU B  21       9.436  27.460   5.956  1.00 36.93           O  
ATOM   1588  CB  GLU B  21       8.926  30.402   6.624  1.00 37.84           C  
ATOM   1589  CG  GLU B  21       8.030  31.548   6.261  1.00 38.28           C  
ATOM   1590  CD  GLU B  21       8.751  32.852   6.107  1.00 38.90           C  
ATOM   1591  OE1 GLU B  21       9.913  32.977   6.563  1.00 39.64           O  
ATOM   1592  OE2 GLU B  21       8.139  33.763   5.529  1.00 40.62           O  
ATOM   1593  N   ASN B  22       9.229  27.393   8.196  1.00 38.44           N  
ATOM   1594  CA  ASN B  22       9.995  26.163   8.334  1.00 38.86           C  
ATOM   1595  C   ASN B  22       9.222  25.228   9.239  1.00 38.90           C  
ATOM   1596  O   ASN B  22       9.669  24.924  10.357  1.00 39.34           O  
ATOM   1597  CB  ASN B  22      11.341  26.468   8.995  1.00 38.81           C  
ATOM   1598  CG  ASN B  22      12.020  27.634   8.375  1.00 37.79           C  
ATOM   1599  OD1 ASN B  22      11.891  28.758   8.860  1.00 36.96           O  
ATOM   1600  ND2 ASN B  22      12.717  27.394   7.268  1.00 35.17           N  
ATOM   1601  N   SER B  23       8.061  24.783   8.790  1.00 38.36           N  
ATOM   1602  CA  SER B  23       7.190  24.053   9.687  1.00 38.60           C  
ATOM   1603  C   SER B  23       7.611  22.601   9.957  1.00 38.75           C  
ATOM   1604  O   SER B  23       6.971  21.919  10.779  1.00 38.39           O  
ATOM   1605  CB  SER B  23       5.764  24.103   9.170  1.00 38.48           C  
ATOM   1606  OG  SER B  23       5.678  23.385   7.958  1.00 39.35           O  
ATOM   1607  N   PHE B  24       8.646  22.121   9.268  1.00 39.27           N  
ATOM   1608  CA  PHE B  24       9.057  20.728   9.457  1.00 40.24           C  
ATOM   1609  C   PHE B  24       9.949  20.673  10.677  1.00 40.24           C  
ATOM   1610  O   PHE B  24      11.137  20.870  10.585  1.00 39.83           O  
ATOM   1611  CB  PHE B  24       9.759  20.145   8.223  1.00 39.85           C  
ATOM   1612  CG  PHE B  24       9.930  18.657   8.284  1.00 40.08           C  
ATOM   1613  CD1 PHE B  24       8.839  17.811   8.131  1.00 39.19           C  
ATOM   1614  CD2 PHE B  24      11.178  18.095   8.498  1.00 40.64           C  
ATOM   1615  CE1 PHE B  24       8.973  16.417   8.196  1.00 37.16           C  
ATOM   1616  CE2 PHE B  24      11.321  16.717   8.566  1.00 37.88           C  
ATOM   1617  CZ  PHE B  24      10.199  15.882   8.411  1.00 37.96           C  
ATOM   1618  N   ALA B  25       9.336  20.406  11.818  1.00 40.82           N  
ATOM   1619  CA  ALA B  25       9.983  20.574  13.096  1.00 40.88           C  
ATOM   1620  C   ALA B  25      10.538  19.316  13.732  1.00 40.89           C  
ATOM   1621  O   ALA B  25      10.279  18.213  13.273  1.00 41.70           O  
ATOM   1622  CB  ALA B  25       9.014  21.243  14.022  1.00 40.69           C  
ATOM   1623  N   THR B  26      11.336  19.509  14.773  1.00 40.12           N  
ATOM   1624  CA  THR B  26      11.856  18.449  15.606  1.00 39.83           C  
ATOM   1625  C   THR B  26      11.077  18.555  16.961  1.00 39.73           C  
ATOM   1626  O   THR B  26      11.126  19.552  17.669  1.00 39.98           O  
ATOM   1627  CB  THR B  26      13.423  18.568  15.727  1.00 40.16           C  
ATOM   1628  OG1 THR B  26      14.044  18.459  14.417  1.00 40.76           O  
ATOM   1629  CG2 THR B  26      14.023  17.465  16.613  1.00 39.73           C  
ATOM   1630  N   LEU B  27      10.299  17.550  17.297  1.00 38.71           N  
ATOM   1631  CA  LEU B  27       9.524  17.601  18.516  1.00 37.89           C  
ATOM   1632  C   LEU B  27      10.161  16.647  19.498  1.00 38.24           C  
ATOM   1633  O   LEU B  27      10.246  15.415  19.222  1.00 38.22           O  
ATOM   1634  CB  LEU B  27       8.074  17.229  18.238  1.00 37.42           C  
ATOM   1635  CG  LEU B  27       7.197  17.021  19.464  1.00 37.81           C  
ATOM   1636  CD1 LEU B  27       7.056  18.297  20.278  1.00 38.94           C  
ATOM   1637  CD2 LEU B  27       5.816  16.484  18.996  1.00 38.78           C  
ATOM   1638  N   VAL B  28      10.609  17.174  20.633  1.00 36.52           N  
ATOM   1639  CA  VAL B  28      11.341  16.376  21.611  1.00 36.62           C  
ATOM   1640  C   VAL B  28      10.572  16.275  22.925  1.00 37.64           C  
ATOM   1641  O   VAL B  28      10.202  17.288  23.518  1.00 37.26           O  
ATOM   1642  CB  VAL B  28      12.737  16.963  21.887  1.00 36.60           C  
ATOM   1643  CG1 VAL B  28      13.565  15.998  22.723  1.00 36.04           C  
ATOM   1644  CG2 VAL B  28      13.445  17.291  20.582  1.00 36.13           C  
ATOM   1645  N   SER B  29      10.336  15.046  23.373  1.00 39.02           N  
ATOM   1646  CA  SER B  29       9.764  14.809  24.693  1.00 39.94           C  
ATOM   1647  C   SER B  29      10.678  13.931  25.541  1.00 39.45           C  
ATOM   1648  O   SER B  29      11.704  13.443  25.065  1.00 39.06           O  
ATOM   1649  CB  SER B  29       8.382  14.165  24.570  1.00 40.48           C  
ATOM   1650  OG  SER B  29       8.446  12.957  23.833  1.00 41.62           O  
HETATM 1651  N   MSE B  30      10.299  13.733  26.799  1.00 39.20           N  
HETATM 1652  CA  MSE B  30      10.852  12.651  27.605  1.00 39.88           C  
HETATM 1653  C   MSE B  30      10.013  11.383  27.476  1.00 38.41           C  
HETATM 1654  O   MSE B  30       8.821  11.383  27.782  1.00 37.55           O  
HETATM 1655  CB  MSE B  30      10.949  13.070  29.073  1.00 41.62           C  
HETATM 1656  CG  MSE B  30      11.728  12.101  29.946  1.00 47.75           C  
HETATM 1657 SE   MSE B  30      13.649  12.435  29.913  1.00 57.14          SE  
HETATM 1658  CE  MSE B  30      14.096  11.808  31.704  1.00 47.40           C  
ATOM   1659  N   HIS B  31      10.645  10.306  27.022  1.00 37.85           N  
ATOM   1660  CA  HIS B  31       9.948   9.038  26.817  1.00 37.26           C  
ATOM   1661  C   HIS B  31      10.612   7.901  27.565  1.00 36.85           C  
ATOM   1662  O   HIS B  31      11.787   7.632  27.344  1.00 37.13           O  
ATOM   1663  CB  HIS B  31       9.903   8.731  25.327  1.00 37.40           C  
ATOM   1664  CG  HIS B  31       9.319   7.403  25.015  1.00 38.53           C  
ATOM   1665  ND1 HIS B  31       7.977   7.132  25.162  1.00 39.82           N  
ATOM   1666  CD2 HIS B  31       9.895   6.259  24.579  1.00 39.11           C  
ATOM   1667  CE1 HIS B  31       7.751   5.876  24.826  1.00 40.10           C  
ATOM   1668  NE2 HIS B  31       8.898   5.327  24.468  1.00 39.84           N  
ATOM   1669  N   GLN B  32       9.850   7.213  28.424  1.00 35.86           N  
ATOM   1670  CA  GLN B  32      10.404   6.214  29.336  1.00 35.20           C  
ATOM   1671  C   GLN B  32      11.806   6.632  29.832  1.00 34.97           C  
ATOM   1672  O   GLN B  32      12.764   5.865  29.726  1.00 35.07           O  
ATOM   1673  CB  GLN B  32      10.466   4.826  28.697  1.00 35.45           C  
ATOM   1674  CG  GLN B  32       9.139   4.196  28.360  1.00 36.33           C  
ATOM   1675  CD  GLN B  32       8.108   4.289  29.490  1.00 37.57           C  
ATOM   1676  OE1 GLN B  32       8.166   3.563  30.496  1.00 38.37           O  
ATOM   1677  NE2 GLN B  32       7.131   5.181  29.301  1.00 38.86           N  
ATOM   1678  N   ARG B  33      11.922   7.860  30.334  1.00 34.26           N  
ATOM   1679  CA  ARG B  33      13.182   8.390  30.908  1.00 33.13           C  
ATOM   1680  C   ARG B  33      14.305   8.686  29.910  1.00 33.85           C  
ATOM   1681  O   ARG B  33      15.437   8.933  30.324  1.00 33.75           O  
ATOM   1682  CB  ARG B  33      13.702   7.543  32.096  1.00 32.54           C  
ATOM   1683  CG  ARG B  33      12.946   7.820  33.370  1.00 31.65           C  
ATOM   1684  CD  ARG B  33      13.355   6.947  34.576  1.00 31.26           C  
ATOM   1685  NE  ARG B  33      12.220   6.796  35.487  1.00 27.43           N  
ATOM   1686  CZ  ARG B  33      12.194   6.064  36.602  1.00 25.94           C  
ATOM   1687  NH1 ARG B  33      13.262   5.393  37.023  1.00 24.52           N  
ATOM   1688  NH2 ARG B  33      11.076   6.021  37.310  1.00 26.17           N  
ATOM   1689  N   GLU B  34      13.993   8.657  28.619  1.00 34.04           N  
ATOM   1690  CA  GLU B  34      14.968   8.953  27.588  1.00 34.42           C  
ATOM   1691  C   GLU B  34      14.482  10.087  26.701  1.00 34.59           C  
ATOM   1692  O   GLU B  34      13.266  10.301  26.536  1.00 34.28           O  
ATOM   1693  CB  GLU B  34      15.214   7.711  26.739  1.00 34.63           C  
ATOM   1694  CG  GLU B  34      15.855   6.544  27.461  1.00 36.35           C  
ATOM   1695  CD  GLU B  34      17.363   6.717  27.683  1.00 38.40           C  
ATOM   1696  OE1 GLU B  34      17.969   7.649  27.110  1.00 39.54           O  
ATOM   1697  OE2 GLU B  34      17.941   5.903  28.425  1.00 37.74           O  
ATOM   1698  N   LEU B  35      15.434  10.821  26.117  1.00 35.48           N  
ATOM   1699  CA  LEU B  35      15.066  11.942  25.220  1.00 35.73           C  
ATOM   1700  C   LEU B  35      14.675  11.344  23.883  1.00 35.80           C  
ATOM   1701  O   LEU B  35      15.322  10.425  23.394  1.00 35.61           O  
ATOM   1702  CB  LEU B  35      16.202  12.971  25.071  1.00 35.85           C  
ATOM   1703  CG  LEU B  35      16.828  13.562  26.349  1.00 35.20           C  
ATOM   1704  CD1 LEU B  35      18.173  14.211  26.060  1.00 34.19           C  
ATOM   1705  CD2 LEU B  35      15.886  14.554  27.036  1.00 36.84           C  
ATOM   1706  N   PHE B  36      13.609  11.871  23.304  1.00 35.78           N  
ATOM   1707  CA  PHE B  36      13.027  11.317  22.106  1.00 36.36           C  
ATOM   1708  C   PHE B  36      12.650  12.456  21.183  1.00 36.89           C  
ATOM   1709  O   PHE B  36      12.136  13.496  21.641  1.00 36.74           O  
ATOM   1710  CB  PHE B  36      11.765  10.568  22.488  1.00 36.48           C  
ATOM   1711  CG  PHE B  36      11.410   9.409  21.569  1.00 37.51           C  
ATOM   1712  CD1 PHE B  36      11.703   8.091  21.955  1.00 38.38           C  
ATOM   1713  CD2 PHE B  36      10.748   9.628  20.350  1.00 36.53           C  
ATOM   1714  CE1 PHE B  36      11.359   7.026  21.140  1.00 38.35           C  
ATOM   1715  CE2 PHE B  36      10.393   8.586  19.531  1.00 34.78           C  
ATOM   1716  CZ  PHE B  36      10.684   7.281  19.918  1.00 37.14           C  
ATOM   1717  N   ALA B  37      12.931  12.280  19.893  1.00 36.61           N  
ATOM   1718  CA  ALA B  37      12.563  13.293  18.896  1.00 36.76           C  
ATOM   1719  C   ALA B  37      11.933  12.713  17.655  1.00 36.59           C  
ATOM   1720  O   ALA B  37      12.365  11.689  17.111  1.00 36.70           O  
ATOM   1721  CB  ALA B  37      13.765  14.164  18.513  1.00 36.29           C  
ATOM   1722  N   THR B  38      10.929  13.426  17.198  1.00 37.48           N  
ATOM   1723  CA  THR B  38      10.212  13.094  15.991  1.00 38.01           C  
ATOM   1724  C   THR B  38      10.273  14.303  15.075  1.00 37.69           C  
ATOM   1725  O   THR B  38      10.188  15.466  15.500  1.00 37.78           O  
ATOM   1726  CB  THR B  38       8.792  12.695  16.334  1.00 38.64           C  
ATOM   1727  OG1 THR B  38       8.866  11.431  16.978  1.00 41.52           O  
ATOM   1728  CG2 THR B  38       7.920  12.508  15.110  1.00 39.70           C  
ATOM   1729  N   HIS B  39      10.446  14.010  13.804  1.00 37.05           N  
ATOM   1730  CA  HIS B  39      10.553  15.018  12.818  1.00 37.02           C  
ATOM   1731  C   HIS B  39       9.239  15.012  12.074  1.00 36.76           C  
ATOM   1732  O   HIS B  39       8.942  14.059  11.356  1.00 36.60           O  
ATOM   1733  CB  HIS B  39      11.727  14.672  11.898  1.00 36.87           C  
ATOM   1734  CG  HIS B  39      13.047  14.734  12.594  1.00 38.22           C  
ATOM   1735  ND1 HIS B  39      13.763  13.610  12.942  1.00 39.50           N  
ATOM   1736  CD2 HIS B  39      13.763  15.790  13.049  1.00 40.14           C  
ATOM   1737  CE1 HIS B  39      14.889  13.972  13.527  1.00 39.44           C  
ATOM   1738  NE2 HIS B  39      14.906  15.287  13.620  1.00 40.86           N  
ATOM   1739  N   LEU B  40       8.464  16.089  12.219  1.00 37.13           N  
ATOM   1740  CA  LEU B  40       7.124  16.142  11.581  1.00 37.07           C  
ATOM   1741  C   LEU B  40       6.687  17.608  11.381  1.00 37.75           C  
ATOM   1742  O   LEU B  40       7.246  18.521  11.995  1.00 37.06           O  
ATOM   1743  CB  LEU B  40       6.093  15.373  12.423  1.00 36.23           C  
ATOM   1744  CG  LEU B  40       5.790  16.017  13.778  1.00 35.78           C  
ATOM   1745  CD1 LEU B  40       4.857  15.152  14.623  1.00 37.25           C  
ATOM   1746  CD2 LEU B  40       7.038  16.301  14.581  1.00 33.16           C  
ATOM   1747  N   PRO B  41       5.735  17.837  10.485  1.00 38.32           N  
ATOM   1748  CA  PRO B  41       5.313  19.218  10.370  1.00 39.00           C  
ATOM   1749  C   PRO B  41       4.454  19.621  11.554  1.00 39.90           C  
ATOM   1750  O   PRO B  41       3.666  18.807  12.041  1.00 40.27           O  
ATOM   1751  CB  PRO B  41       4.493  19.235   9.081  1.00 38.85           C  
ATOM   1752  CG  PRO B  41       4.060  17.839   8.889  1.00 38.45           C  
ATOM   1753  CD  PRO B  41       5.064  16.957   9.529  1.00 38.50           C  
ATOM   1754  N   LEU B  42       4.640  20.846  12.040  1.00 39.60           N  
ATOM   1755  CA  LEU B  42       3.797  21.357  13.092  1.00 39.55           C  
ATOM   1756  C   LEU B  42       3.239  22.676  12.628  1.00 39.77           C  
ATOM   1757  O   LEU B  42       3.987  23.614  12.391  1.00 39.32           O  
ATOM   1758  CB  LEU B  42       4.587  21.549  14.373  1.00 39.92           C  
ATOM   1759  CG  LEU B  42       5.128  20.298  15.076  1.00 39.49           C  
ATOM   1760  CD1 LEU B  42       6.133  20.700  16.138  1.00 37.27           C  
ATOM   1761  CD2 LEU B  42       3.974  19.447  15.682  1.00 39.46           C  
ATOM   1762  N   LEU B  43       1.918  22.738  12.487  1.00 39.97           N  
ATOM   1763  CA  LEU B  43       1.247  23.961  12.081  1.00 40.52           C  
ATOM   1764  C   LEU B  43       0.693  24.802  13.235  1.00 40.41           C  
ATOM   1765  O   LEU B  43       0.139  24.266  14.191  1.00 40.64           O  
ATOM   1766  CB  LEU B  43       0.098  23.614  11.142  1.00 40.62           C  
ATOM   1767  CG  LEU B  43       0.356  22.728   9.922  1.00 41.70           C  
ATOM   1768  CD1 LEU B  43      -0.841  22.818   8.973  1.00 44.62           C  
ATOM   1769  CD2 LEU B  43       1.573  23.196   9.210  1.00 42.87           C  
ATOM   1770  N   LEU B  44       0.826  26.125  13.117  1.00 40.54           N  
ATOM   1771  CA  LEU B  44       0.179  27.064  14.041  1.00 40.20           C  
ATOM   1772  C   LEU B  44      -1.269  27.268  13.665  1.00 40.98           C  
ATOM   1773  O   LEU B  44      -1.582  27.412  12.497  1.00 41.27           O  
ATOM   1774  CB  LEU B  44       0.840  28.424  13.979  1.00 39.73           C  
ATOM   1775  CG  LEU B  44       2.053  28.752  14.825  1.00 38.73           C  
ATOM   1776  CD1 LEU B  44       2.648  30.020  14.317  1.00 38.03           C  
ATOM   1777  CD2 LEU B  44       1.659  28.896  16.266  1.00 38.29           C  
ATOM   1778  N   ASP B  45      -2.168  27.285  14.644  1.00 41.59           N  
ATOM   1779  CA  ASP B  45      -3.561  27.584  14.359  1.00 42.28           C  
ATOM   1780  C   ASP B  45      -3.688  29.073  14.025  1.00 42.66           C  
ATOM   1781  O   ASP B  45      -2.768  29.853  14.306  1.00 42.60           O  
ATOM   1782  CB  ASP B  45      -4.462  27.216  15.544  1.00 42.61           C  
ATOM   1783  CG  ASP B  45      -3.960  27.782  16.866  1.00 43.65           C  
ATOM   1784  OD1 ASP B  45      -2.812  28.345  16.896  1.00 45.25           O  
ATOM   1785  OD2 ASP B  45      -4.709  27.652  17.878  1.00 44.19           O  
ATOM   1786  N   ARG B  46      -4.814  29.456  13.432  1.00 42.86           N  
ATOM   1787  CA  ARG B  46      -5.008  30.825  12.968  1.00 43.35           C  
ATOM   1788  C   ARG B  46      -4.850  31.822  14.112  1.00 43.75           C  
ATOM   1789  O   ARG B  46      -4.469  32.973  13.896  1.00 43.95           O  
ATOM   1790  CB  ARG B  46      -6.385  30.981  12.322  1.00 42.89           C  
ATOM   1791  CG  ARG B  46      -6.571  30.167  11.052  1.00 43.04           C  
ATOM   1792  CD  ARG B  46      -7.889  30.419  10.338  1.00 43.37           C  
ATOM   1793  NE  ARG B  46      -8.221  29.346   9.406  1.00 44.30           N  
ATOM   1794  CZ  ARG B  46      -9.408  29.196   8.836  1.00 45.22           C  
ATOM   1795  NH1 ARG B  46     -10.387  30.051   9.100  1.00 45.27           N  
ATOM   1796  NH2 ARG B  46      -9.622  28.189   7.999  1.00 45.50           N  
ATOM   1797  N   GLU B  47      -5.145  31.374  15.327  1.00 44.61           N  
ATOM   1798  CA  GLU B  47      -5.032  32.223  16.506  1.00 45.00           C  
ATOM   1799  C   GLU B  47      -3.624  32.174  17.090  1.00 44.96           C  
ATOM   1800  O   GLU B  47      -3.253  33.009  17.914  1.00 45.01           O  
ATOM   1801  CB  GLU B  47      -6.055  31.809  17.565  1.00 45.44           C  
ATOM   1802  CG  GLU B  47      -5.726  32.293  18.969  1.00 45.88           C  
ATOM   1803  CD  GLU B  47      -6.632  33.420  19.424  1.00 48.79           C  
ATOM   1804  OE1 GLU B  47      -6.679  33.691  20.642  1.00 50.18           O  
ATOM   1805  OE2 GLU B  47      -7.295  34.035  18.563  1.00 50.28           O  
ATOM   1806  N   LYS B  48      -2.844  31.190  16.655  1.00 45.25           N  
ATOM   1807  CA  LYS B  48      -1.425  31.133  16.989  1.00 45.79           C  
ATOM   1808  C   LYS B  48      -1.219  30.929  18.486  1.00 45.44           C  
ATOM   1809  O   LYS B  48      -0.243  31.412  19.059  1.00 45.61           O  
ATOM   1810  CB  LYS B  48      -0.715  32.407  16.529  1.00 46.23           C  
ATOM   1811  CG  LYS B  48      -0.487  32.484  15.027  1.00 46.79           C  
ATOM   1812  CD  LYS B  48      -0.102  33.890  14.598  1.00 46.22           C  
ATOM   1813  CE  LYS B  48       0.149  33.961  13.101  1.00 47.65           C  
ATOM   1814  NZ  LYS B  48       0.219  35.367  12.615  1.00 48.78           N  
ATOM   1815  N   THR B  49      -2.144  30.210  19.113  1.00 44.43           N  
ATOM   1816  CA  THR B  49      -1.972  29.777  20.496  1.00 43.95           C  
ATOM   1817  C   THR B  49      -1.460  28.345  20.565  1.00 44.16           C  
ATOM   1818  O   THR B  49      -1.030  27.913  21.620  1.00 44.33           O  
ATOM   1819  CB  THR B  49      -3.301  29.812  21.350  1.00 43.96           C  
ATOM   1820  OG1 THR B  49      -4.322  29.025  20.704  1.00 42.98           O  
ATOM   1821  CG2 THR B  49      -3.791  31.261  21.639  1.00 42.81           C  
ATOM   1822  N   CYS B  50      -1.471  27.648  19.427  1.00 43.99           N  
ATOM   1823  CA  CYS B  50      -1.299  26.195  19.397  1.00 44.13           C  
ATOM   1824  C   CYS B  50      -0.517  25.685  18.177  1.00 43.54           C  
ATOM   1825  O   CYS B  50      -0.512  26.311  17.117  1.00 43.56           O  
ATOM   1826  CB  CYS B  50      -2.656  25.494  19.483  1.00 44.40           C  
ATOM   1827  SG  CYS B  50      -3.494  25.684  21.073  1.00 47.37           S  
ATOM   1828  N   LEU B  51       0.137  24.539  18.354  1.00 42.68           N  
ATOM   1829  CA  LEU B  51       0.762  23.777  17.283  1.00 41.96           C  
ATOM   1830  C   LEU B  51       0.049  22.440  17.155  1.00 42.48           C  
ATOM   1831  O   LEU B  51      -0.029  21.701  18.129  1.00 43.28           O  
ATOM   1832  CB  LEU B  51       2.228  23.515  17.595  1.00 41.22           C  
ATOM   1833  CG  LEU B  51       3.095  24.768  17.454  1.00 40.38           C  
ATOM   1834  CD1 LEU B  51       4.481  24.660  18.085  1.00 37.84           C  
ATOM   1835  CD2 LEU B  51       3.171  25.250  16.002  1.00 42.24           C  
ATOM   1836  N   TYR B  52      -0.470  22.137  15.965  1.00 41.97           N  
ATOM   1837  CA  TYR B  52      -1.068  20.833  15.668  1.00 41.47           C  
ATOM   1838  C   TYR B  52      -0.114  19.925  14.901  1.00 41.32           C  
ATOM   1839  O   TYR B  52       0.674  20.373  14.070  1.00 40.79           O  
ATOM   1840  CB  TYR B  52      -2.349  21.005  14.861  1.00 41.54           C  
ATOM   1841  CG  TYR B  52      -3.449  21.684  15.623  1.00 41.59           C  
ATOM   1842  CD1 TYR B  52      -3.422  23.057  15.848  1.00 41.40           C  
ATOM   1843  CD2 TYR B  52      -4.535  20.958  16.110  1.00 42.47           C  
ATOM   1844  CE1 TYR B  52      -4.423  23.682  16.564  1.00 42.83           C  
ATOM   1845  CE2 TYR B  52      -5.589  21.588  16.823  1.00 42.67           C  
ATOM   1846  CZ  TYR B  52      -5.514  22.947  17.041  1.00 42.99           C  
ATOM   1847  OH  TYR B  52      -6.512  23.601  17.717  1.00 42.88           O  
ATOM   1848  N   GLY B  53      -0.197  18.638  15.180  1.00 41.49           N  
ATOM   1849  CA  GLY B  53       0.612  17.664  14.485  1.00 41.71           C  
ATOM   1850  C   GLY B  53      -0.043  16.304  14.523  1.00 42.34           C  
ATOM   1851  O   GLY B  53      -1.098  16.123  15.133  1.00 42.11           O  
ATOM   1852  N   HIS B  54       0.558  15.340  13.843  1.00 43.49           N  
ATOM   1853  CA  HIS B  54       0.132  13.970  14.032  1.00 44.80           C  
ATOM   1854  C   HIS B  54       1.260  12.976  13.944  1.00 44.69           C  
ATOM   1855  O   HIS B  54       2.226  13.162  13.184  1.00 44.74           O  
ATOM   1856  CB  HIS B  54      -1.044  13.590  13.153  1.00 45.79           C  
ATOM   1857  CG  HIS B  54      -0.727  13.459  11.698  1.00 49.26           C  
ATOM   1858  ND1 HIS B  54      -1.271  14.294  10.749  1.00 52.06           N  
ATOM   1859  CD2 HIS B  54       0.023  12.552  11.022  1.00 51.93           C  
ATOM   1860  CE1 HIS B  54      -0.846  13.926   9.550  1.00 53.81           C  
ATOM   1861  NE2 HIS B  54      -0.065  12.868   9.687  1.00 53.57           N  
ATOM   1862  N   PHE B  55       1.152  11.905  14.723  1.00 44.52           N  
ATOM   1863  CA  PHE B  55       2.077  10.784  14.616  1.00 44.64           C  
ATOM   1864  C   PHE B  55       1.503   9.677  13.736  1.00 44.39           C  
ATOM   1865  O   PHE B  55       0.288   9.573  13.569  1.00 44.32           O  
ATOM   1866  CB  PHE B  55       2.414  10.231  16.003  1.00 44.79           C  
ATOM   1867  CG  PHE B  55       3.123  11.213  16.890  1.00 45.03           C  
ATOM   1868  CD1 PHE B  55       2.415  11.993  17.789  1.00 45.89           C  
ATOM   1869  CD2 PHE B  55       4.499  11.358  16.826  1.00 45.72           C  
ATOM   1870  CE1 PHE B  55       3.064  12.897  18.607  1.00 45.06           C  
ATOM   1871  CE2 PHE B  55       5.155  12.261  17.642  1.00 47.55           C  
ATOM   1872  CZ  PHE B  55       4.436  13.032  18.534  1.00 45.99           C  
ATOM   1873  N   ALA B  56       2.385   8.855  13.178  1.00 44.11           N  
ATOM   1874  CA  ALA B  56       2.169   7.414  13.135  1.00 44.16           C  
ATOM   1875  C   ALA B  56       1.790   6.873  14.509  1.00 44.55           C  
ATOM   1876  O   ALA B  56       2.386   7.244  15.520  1.00 44.35           O  
ATOM   1877  CB  ALA B  56       3.407   6.707  12.606  1.00 44.13           C  
ATOM   1878  N   ARG B  57       0.795   5.992  14.539  1.00 45.18           N  
ATOM   1879  CA  ARG B  57       0.373   5.354  15.781  1.00 45.90           C  
ATOM   1880  C   ARG B  57       1.479   4.475  16.352  1.00 45.78           C  
ATOM   1881  O   ARG B  57       1.730   4.481  17.557  1.00 46.09           O  
ATOM   1882  CB  ARG B  57      -0.894   4.527  15.553  1.00 46.18           C  
ATOM   1883  CG  ARG B  57      -2.185   5.320  15.675  1.00 46.90           C  
ATOM   1884  CD  ARG B  57      -3.331   4.548  16.308  1.00 48.54           C  
ATOM   1885  NE  ARG B  57      -4.509   5.387  16.509  1.00 48.27           N  
ATOM   1886  CZ  ARG B  57      -4.736   6.103  17.601  1.00 47.64           C  
ATOM   1887  NH1 ARG B  57      -3.864   6.087  18.599  1.00 47.59           N  
ATOM   1888  NH2 ARG B  57      -5.835   6.838  17.699  1.00 47.32           N  
ATOM   1889  N   SER B  58       2.136   3.718  15.479  1.00 45.85           N  
ATOM   1890  CA  SER B  58       3.181   2.791  15.902  1.00 45.71           C  
ATOM   1891  C   SER B  58       4.375   3.480  16.581  1.00 45.46           C  
ATOM   1892  O   SER B  58       5.286   2.812  17.061  1.00 45.61           O  
ATOM   1893  CB  SER B  58       3.634   1.953  14.694  1.00 45.92           C  
ATOM   1894  OG  SER B  58       4.061   2.789  13.630  1.00 45.50           O  
ATOM   1895  N   ASN B  59       4.342   4.814  16.627  1.00 45.04           N  
ATOM   1896  CA  ASN B  59       5.382   5.653  17.247  1.00 44.20           C  
ATOM   1897  C   ASN B  59       5.105   5.810  18.760  1.00 44.84           C  
ATOM   1898  O   ASN B  59       4.126   6.474  19.154  1.00 45.46           O  
ATOM   1899  CB  ASN B  59       5.439   7.010  16.535  1.00 43.61           C  
ATOM   1900  CG  ASN B  59       6.536   7.926  17.076  1.00 42.04           C  
ATOM   1901  OD1 ASN B  59       7.111   7.651  18.132  1.00 40.64           O  
ATOM   1902  ND2 ASN B  59       6.830   9.015  16.358  1.00 35.57           N  
ATOM   1903  N   PRO B  60       5.976   5.232  19.617  1.00 44.49           N  
ATOM   1904  CA  PRO B  60       5.628   5.186  21.045  1.00 43.82           C  
ATOM   1905  C   PRO B  60       5.692   6.524  21.753  1.00 43.47           C  
ATOM   1906  O   PRO B  60       5.313   6.596  22.920  1.00 43.49           O  
ATOM   1907  CB  PRO B  60       6.679   4.235  21.623  1.00 43.44           C  
ATOM   1908  CG  PRO B  60       7.900   4.511  20.787  1.00 44.13           C  
ATOM   1909  CD  PRO B  60       7.305   4.626  19.375  1.00 44.75           C  
ATOM   1910  N   GLN B  61       6.140   7.572  21.064  1.00 43.26           N  
ATOM   1911  CA  GLN B  61       6.345   8.869  21.728  1.00 43.16           C  
ATOM   1912  C   GLN B  61       5.064   9.449  22.344  1.00 43.00           C  
ATOM   1913  O   GLN B  61       5.109  10.045  23.422  1.00 43.36           O  
ATOM   1914  CB  GLN B  61       7.025   9.885  20.812  1.00 42.69           C  
ATOM   1915  CG  GLN B  61       7.488  11.151  21.512  1.00 44.03           C  
ATOM   1916  CD  GLN B  61       8.144  12.180  20.554  1.00 44.76           C  
ATOM   1917  OE1 GLN B  61       8.634  13.239  20.981  1.00 45.85           O  
ATOM   1918  NE2 GLN B  61       8.130  11.875  19.262  1.00 45.12           N  
ATOM   1919  N   TRP B  62       3.919   9.282  21.696  1.00 42.29           N  
ATOM   1920  CA  TRP B  62       2.708   9.847  22.291  1.00 41.46           C  
ATOM   1921  C   TRP B  62       2.218   9.081  23.526  1.00 41.54           C  
ATOM   1922  O   TRP B  62       1.522   9.652  24.383  1.00 41.58           O  
ATOM   1923  CB  TRP B  62       1.599  10.025  21.266  1.00 40.63           C  
ATOM   1924  CG  TRP B  62       1.161   8.764  20.686  1.00 40.21           C  
ATOM   1925  CD1 TRP B  62       1.632   8.179  19.543  1.00 39.90           C  
ATOM   1926  CD2 TRP B  62       0.131   7.903  21.190  1.00 39.71           C  
ATOM   1927  NE1 TRP B  62       0.955   7.001  19.307  1.00 39.89           N  
ATOM   1928  CE2 TRP B  62       0.026   6.815  20.300  1.00 39.93           C  
ATOM   1929  CE3 TRP B  62      -0.726   7.956  22.299  1.00 39.53           C  
ATOM   1930  CZ2 TRP B  62      -0.871   5.782  20.502  1.00 40.22           C  
ATOM   1931  CZ3 TRP B  62      -1.625   6.935  22.493  1.00 39.50           C  
ATOM   1932  CH2 TRP B  62      -1.690   5.860  21.601  1.00 39.94           C  
ATOM   1933  N   ASN B  63       2.587   7.803  23.629  1.00 41.28           N  
ATOM   1934  CA  ASN B  63       2.169   6.997  24.773  1.00 41.23           C  
ATOM   1935  C   ASN B  63       2.227   7.796  26.067  1.00 41.26           C  
ATOM   1936  O   ASN B  63       1.325   7.685  26.875  1.00 41.29           O  
ATOM   1937  CB  ASN B  63       3.018   5.731  24.948  1.00 41.32           C  
ATOM   1938  CG  ASN B  63       2.887   4.738  23.793  1.00 41.87           C  
ATOM   1939  OD1 ASN B  63       2.020   4.843  22.919  1.00 42.43           O  
ATOM   1940  ND2 ASN B  63       3.765   3.747  23.801  1.00 43.60           N  
ATOM   1941  N   ASP B  64       3.279   8.608  26.254  1.00 41.01           N  
ATOM   1942  CA  ASP B  64       3.493   9.311  27.535  1.00 40.45           C  
ATOM   1943  C   ASP B  64       3.934  10.781  27.394  1.00 40.25           C  
ATOM   1944  O   ASP B  64       4.609  11.351  28.279  1.00 39.99           O  
ATOM   1945  CB  ASP B  64       4.497   8.525  28.403  1.00 40.43           C  
ATOM   1946  CG  ASP B  64       5.921   8.499  27.805  1.00 39.97           C  
ATOM   1947  OD1 ASP B  64       6.076   8.671  26.562  1.00 39.29           O  
ATOM   1948  OD2 ASP B  64       6.880   8.272  28.590  1.00 38.46           O  
ATOM   1949  N   ILE B  65       3.549  11.393  26.280  1.00 40.12           N  
ATOM   1950  CA  ILE B  65       4.046  12.717  25.922  1.00 40.36           C  
ATOM   1951  C   ILE B  65       3.350  13.804  26.734  1.00 40.47           C  
ATOM   1952  O   ILE B  65       3.699  14.981  26.640  1.00 40.20           O  
ATOM   1953  CB  ILE B  65       3.852  12.976  24.416  1.00 40.02           C  
ATOM   1954  CG1 ILE B  65       4.549  14.275  24.005  1.00 39.55           C  
ATOM   1955  CG2 ILE B  65       2.373  13.027  24.069  1.00 41.34           C  
ATOM   1956  CD1 ILE B  65       4.867  14.356  22.528  1.00 39.90           C  
ATOM   1957  N   GLN B  66       2.365  13.402  27.531  1.00 40.98           N  
ATOM   1958  CA  GLN B  66       1.137  14.174  27.680  1.00 41.60           C  
ATOM   1959  C   GLN B  66       1.181  15.044  28.932  1.00 41.98           C  
ATOM   1960  O   GLN B  66       0.398  15.982  29.076  1.00 42.15           O  
ATOM   1961  CB  GLN B  66      -0.078  13.246  27.727  1.00 41.83           C  
ATOM   1962  CG  GLN B  66      -1.213  13.662  26.808  1.00 41.75           C  
ATOM   1963  CD  GLN B  66      -2.526  12.990  27.161  1.00 41.83           C  
ATOM   1964  OE1 GLN B  66      -2.537  11.865  27.661  1.00 42.85           O  
ATOM   1965  NE2 GLN B  66      -3.633  13.676  26.904  1.00 44.49           N  
ATOM   1966  N   HIS B  67       2.103  14.726  29.835  1.00 40.89           N  
ATOM   1967  CA  HIS B  67       2.189  15.415  31.117  1.00 40.54           C  
ATOM   1968  C   HIS B  67       3.588  15.974  31.350  1.00 39.96           C  
ATOM   1969  O   HIS B  67       4.214  15.700  32.374  1.00 39.52           O  
ATOM   1970  CB  HIS B  67       1.802  14.472  32.259  1.00 40.50           C  
ATOM   1971  CG  HIS B  67       0.427  13.897  32.128  1.00 41.19           C  
ATOM   1972  ND1 HIS B  67      -0.712  14.671  32.183  1.00 42.48           N  
ATOM   1973  CD2 HIS B  67       0.007  12.622  31.944  1.00 41.61           C  
ATOM   1974  CE1 HIS B  67      -1.775  13.899  32.039  1.00 41.84           C  
ATOM   1975  NE2 HIS B  67      -1.366  12.652  31.893  1.00 42.37           N  
ATOM   1976  N   GLN B  68       4.072  16.760  30.394  1.00 39.09           N  
ATOM   1977  CA  GLN B  68       5.388  17.358  30.494  1.00 38.11           C  
ATOM   1978  C   GLN B  68       5.474  18.552  29.579  1.00 37.83           C  
ATOM   1979  O   GLN B  68       4.633  18.699  28.696  1.00 37.83           O  
ATOM   1980  CB  GLN B  68       6.424  16.327  30.062  1.00 37.77           C  
ATOM   1981  CG  GLN B  68       6.034  15.538  28.809  1.00 37.43           C  
ATOM   1982  CD  GLN B  68       7.173  14.678  28.252  1.00 37.92           C  
ATOM   1983  OE1 GLN B  68       8.309  15.144  28.080  1.00 37.62           O  
ATOM   1984  NE2 GLN B  68       6.858  13.432  27.921  1.00 36.83           N  
ATOM   1985  N   THR B  69       6.491  19.390  29.778  1.00 37.39           N  
ATOM   1986  CA  THR B  69       6.790  20.482  28.853  1.00 37.07           C  
ATOM   1987  C   THR B  69       7.666  19.891  27.733  1.00 37.48           C  
ATOM   1988  O   THR B  69       8.817  19.445  27.998  1.00 37.36           O  
ATOM   1989  CB  THR B  69       7.561  21.670  29.541  1.00 36.91           C  
ATOM   1990  OG1 THR B  69       6.770  22.286  30.577  1.00 36.75           O  
ATOM   1991  CG2 THR B  69       7.900  22.726  28.509  1.00 37.39           C  
ATOM   1992  N   VAL B  70       7.137  19.862  26.506  1.00 37.00           N  
ATOM   1993  CA  VAL B  70       7.895  19.358  25.357  1.00 36.89           C  
ATOM   1994  C   VAL B  70       8.544  20.542  24.623  1.00 37.40           C  
ATOM   1995  O   VAL B  70       8.161  21.729  24.841  1.00 37.33           O  
ATOM   1996  CB  VAL B  70       7.022  18.575  24.321  1.00 36.88           C  
ATOM   1997  CG1 VAL B  70       6.378  17.301  24.901  1.00 35.60           C  
ATOM   1998  CG2 VAL B  70       5.989  19.484  23.628  1.00 37.56           C  
ATOM   1999  N   LEU B  71       9.470  20.232  23.712  1.00 36.75           N  
ATOM   2000  CA  LEU B  71      10.210  21.247  23.007  1.00 36.92           C  
ATOM   2001  C   LEU B  71      10.017  21.051  21.525  1.00 37.28           C  
ATOM   2002  O   LEU B  71      10.425  20.003  20.967  1.00 37.83           O  
ATOM   2003  CB  LEU B  71      11.678  21.104  23.345  1.00 37.04           C  
ATOM   2004  CG  LEU B  71      12.708  22.025  22.671  1.00 37.49           C  
ATOM   2005  CD1 LEU B  71      12.302  23.483  22.635  1.00 37.76           C  
ATOM   2006  CD2 LEU B  71      14.060  21.899  23.394  1.00 37.97           C  
ATOM   2007  N   ALA B  72       9.390  22.024  20.876  1.00 36.11           N  
ATOM   2008  CA  ALA B  72       9.222  21.960  19.425  1.00 35.89           C  
ATOM   2009  C   ALA B  72      10.255  22.889  18.799  1.00 35.69           C  
ATOM   2010  O   ALA B  72      10.300  24.086  19.109  1.00 35.58           O  
ATOM   2011  CB  ALA B  72       7.820  22.371  19.012  1.00 36.06           C  
ATOM   2012  N   ILE B  73      11.128  22.332  17.977  1.00 35.46           N  
ATOM   2013  CA  ILE B  73      12.202  23.118  17.380  1.00 35.74           C  
ATOM   2014  C   ILE B  73      11.952  23.338  15.908  1.00 36.23           C  
ATOM   2015  O   ILE B  73      11.710  22.373  15.173  1.00 35.97           O  
ATOM   2016  CB  ILE B  73      13.534  22.434  17.556  1.00 36.06           C  
ATOM   2017  CG1 ILE B  73      13.821  22.230  19.062  1.00 37.00           C  
ATOM   2018  CG2 ILE B  73      14.643  23.213  16.897  1.00 36.30           C  
ATOM   2019  CD1 ILE B  73      15.175  21.406  19.394  1.00 34.97           C  
ATOM   2020  N   PHE B  74      11.915  24.620  15.521  1.00 36.22           N  
ATOM   2021  CA  PHE B  74      11.842  25.066  14.139  1.00 36.64           C  
ATOM   2022  C   PHE B  74      13.176  25.704  13.674  1.00 37.44           C  
ATOM   2023  O   PHE B  74      13.702  26.631  14.281  1.00 37.91           O  
ATOM   2024  CB  PHE B  74      10.710  26.024  13.974  1.00 35.98           C  
ATOM   2025  CG  PHE B  74       9.407  25.470  14.461  1.00 36.08           C  
ATOM   2026  CD1 PHE B  74       9.075  25.533  15.811  1.00 32.86           C  
ATOM   2027  CD2 PHE B  74       8.525  24.883  13.573  1.00 35.20           C  
ATOM   2028  CE1 PHE B  74       7.882  25.026  16.271  1.00 34.43           C  
ATOM   2029  CE2 PHE B  74       7.321  24.367  14.029  1.00 34.69           C  
ATOM   2030  CZ  PHE B  74       6.996  24.436  15.379  1.00 35.18           C  
ATOM   2031  N   HIS B  75      13.666  25.207  12.558  1.00 37.84           N  
ATOM   2032  CA  HIS B  75      14.983  25.514  12.071  1.00 38.91           C  
ATOM   2033  C   HIS B  75      14.944  26.506  10.938  1.00 39.42           C  
ATOM   2034  O   HIS B  75      14.427  26.207   9.870  1.00 40.76           O  
ATOM   2035  CB  HIS B  75      15.620  24.201  11.556  1.00 38.46           C  
ATOM   2036  CG  HIS B  75      15.614  23.095  12.567  1.00 38.68           C  
ATOM   2037  ND1 HIS B  75      16.655  22.875  13.440  1.00 37.84           N  
ATOM   2038  CD2 HIS B  75      14.670  22.164  12.865  1.00 37.71           C  
ATOM   2039  CE1 HIS B  75      16.360  21.845  14.212  1.00 36.62           C  
ATOM   2040  NE2 HIS B  75      15.155  21.407  13.891  1.00 35.32           N  
ATOM   2041  N   GLY B  76      15.494  27.693  11.172  1.00 39.63           N  
ATOM   2042  CA  GLY B  76      15.831  28.603  10.094  1.00 39.24           C  
ATOM   2043  C   GLY B  76      17.122  28.221   9.397  1.00 39.06           C  
ATOM   2044  O   GLY B  76      17.666  27.140   9.623  1.00 39.93           O  
ATOM   2045  N   PRO B  77      17.614  29.114   8.544  1.00 38.40           N  
ATOM   2046  CA  PRO B  77      18.854  28.867   7.801  1.00 37.70           C  
ATOM   2047  C   PRO B  77      20.070  28.844   8.720  1.00 37.58           C  
ATOM   2048  O   PRO B  77      19.990  29.300   9.861  1.00 37.25           O  
ATOM   2049  CB  PRO B  77      18.933  30.067   6.854  1.00 37.87           C  
ATOM   2050  CG  PRO B  77      18.206  31.150   7.569  1.00 36.50           C  
ATOM   2051  CD  PRO B  77      17.094  30.474   8.319  1.00 36.81           C  
ATOM   2052  N   HIS B  78      21.184  28.316   8.223  1.00 37.77           N  
ATOM   2053  CA  HIS B  78      22.415  28.250   9.001  1.00 37.70           C  
ATOM   2054  C   HIS B  78      23.628  28.055   8.099  1.00 36.55           C  
ATOM   2055  O   HIS B  78      23.561  27.340   7.098  1.00 36.42           O  
ATOM   2056  CB  HIS B  78      22.338  27.120  10.029  1.00 38.55           C  
ATOM   2057  CG  HIS B  78      22.066  25.775   9.430  1.00 42.77           C  
ATOM   2058  ND1 HIS B  78      20.791  25.299   9.217  1.00 46.37           N  
ATOM   2059  CD2 HIS B  78      22.908  24.805   8.999  1.00 44.12           C  
ATOM   2060  CE1 HIS B  78      20.857  24.094   8.679  1.00 47.13           C  
ATOM   2061  NE2 HIS B  78      22.131  23.771   8.537  1.00 45.42           N  
ATOM   2062  N   CYS B  79      24.736  28.696   8.456  1.00 34.76           N  
ATOM   2063  CA  CYS B  79      25.986  28.559   7.697  1.00 34.03           C  
ATOM   2064  C   CYS B  79      27.236  28.867   8.499  1.00 33.51           C  
ATOM   2065  O   CYS B  79      27.203  29.525   9.552  1.00 33.49           O  
ATOM   2066  CB  CYS B  79      25.987  29.340   6.372  1.00 33.48           C  
ATOM   2067  SG  CYS B  79      26.055  31.085   6.547  1.00 36.37           S  
ATOM   2068  N   TYR B  80      28.339  28.348   7.984  1.00 33.41           N  
ATOM   2069  CA  TYR B  80      29.648  28.625   8.505  1.00 33.37           C  
ATOM   2070  C   TYR B  80      30.000  30.068   8.133  1.00 32.90           C  
ATOM   2071  O   TYR B  80      29.663  30.549   7.056  1.00 33.19           O  
ATOM   2072  CB  TYR B  80      30.635  27.651   7.892  1.00 34.28           C  
ATOM   2073  CG  TYR B  80      32.047  27.757   8.434  1.00 35.96           C  
ATOM   2074  CD1 TYR B  80      32.331  27.490   9.790  1.00 36.78           C  
ATOM   2075  CD2 TYR B  80      33.097  28.148   7.589  1.00 35.65           C  
ATOM   2076  CE1 TYR B  80      33.641  27.618  10.280  1.00 37.60           C  
ATOM   2077  CE2 TYR B  80      34.382  28.284   8.056  1.00 36.86           C  
ATOM   2078  CZ  TYR B  80      34.675  28.015   9.383  1.00 36.88           C  
ATOM   2079  OH  TYR B  80      35.995  28.148   9.799  1.00 34.87           O  
ATOM   2080  N   ILE B  81      30.596  30.780   9.071  1.00 31.16           N  
ATOM   2081  CA  ILE B  81      31.170  32.070   8.809  1.00 29.52           C  
ATOM   2082  C   ILE B  81      32.691  31.941   8.954  1.00 28.97           C  
ATOM   2083  O   ILE B  81      33.205  31.631  10.025  1.00 28.81           O  
ATOM   2084  CB  ILE B  81      30.608  33.115   9.748  1.00 28.94           C  
ATOM   2085  CG1 ILE B  81      29.084  33.095   9.649  1.00 29.24           C  
ATOM   2086  CG2 ILE B  81      31.183  34.454   9.400  1.00 27.33           C  
ATOM   2087  CD1 ILE B  81      28.508  33.360   8.222  1.00 27.59           C  
ATOM   2088  N   SER B  82      33.413  32.178   7.875  1.00 28.24           N  
ATOM   2089  CA  SER B  82      34.846  31.982   7.919  1.00 28.07           C  
ATOM   2090  C   SER B  82      35.600  33.227   8.302  1.00 27.42           C  
ATOM   2091  O   SER B  82      35.397  34.289   7.713  1.00 27.53           O  
ATOM   2092  CB  SER B  82      35.356  31.461   6.582  1.00 28.22           C  
ATOM   2093  OG  SER B  82      36.782  31.456   6.509  1.00 30.34           O  
ATOM   2094  N   PRO B  83      36.520  33.081   9.271  1.00 27.39           N  
ATOM   2095  CA  PRO B  83      37.456  34.121   9.708  1.00 27.14           C  
ATOM   2096  C   PRO B  83      38.477  34.429   8.635  1.00 27.55           C  
ATOM   2097  O   PRO B  83      39.442  35.176   8.883  1.00 27.31           O  
ATOM   2098  CB  PRO B  83      38.166  33.483  10.899  1.00 26.99           C  
ATOM   2099  CG  PRO B  83      37.351  32.269  11.275  1.00 27.04           C  
ATOM   2100  CD  PRO B  83      36.713  31.817  10.005  1.00 27.29           C  
ATOM   2101  N   SER B  84      38.312  33.843   7.458  1.00 27.61           N  
ATOM   2102  CA  SER B  84      39.230  34.160   6.388  1.00 28.43           C  
ATOM   2103  C   SER B  84      38.618  35.298   5.573  1.00 28.92           C  
ATOM   2104  O   SER B  84      39.283  35.863   4.713  1.00 28.63           O  
ATOM   2105  CB  SER B  84      39.513  32.964   5.477  1.00 28.36           C  
ATOM   2106  OG  SER B  84      38.516  32.888   4.465  1.00 28.52           O  
ATOM   2107  N   TRP B  85      37.362  35.636   5.838  1.00 29.73           N  
ATOM   2108  CA  TRP B  85      36.715  36.648   5.026  1.00 30.95           C  
ATOM   2109  C   TRP B  85      36.958  38.050   5.560  1.00 31.60           C  
ATOM   2110  O   TRP B  85      36.447  39.026   5.008  1.00 32.20           O  
ATOM   2111  CB  TRP B  85      35.208  36.372   4.796  1.00 30.98           C  
ATOM   2112  CG  TRP B  85      34.914  35.038   4.243  1.00 31.58           C  
ATOM   2113  CD1 TRP B  85      35.750  34.236   3.484  1.00 31.58           C  
ATOM   2114  CD2 TRP B  85      33.691  34.329   4.373  1.00 31.37           C  
ATOM   2115  NE1 TRP B  85      35.124  33.035   3.180  1.00 31.44           N  
ATOM   2116  CE2 TRP B  85      33.863  33.061   3.720  1.00 31.53           C  
ATOM   2117  CE3 TRP B  85      32.480  34.604   5.026  1.00 31.14           C  
ATOM   2118  CZ2 TRP B  85      32.853  32.093   3.679  1.00 31.25           C  
ATOM   2119  CZ3 TRP B  85      31.464  33.621   4.999  1.00 31.02           C  
ATOM   2120  CH2 TRP B  85      31.660  32.386   4.327  1.00 32.02           C  
ATOM   2121  N   TYR B  86      37.743  38.129   6.636  1.00 32.17           N  
ATOM   2122  CA  TYR B  86      38.141  39.395   7.268  1.00 32.53           C  
ATOM   2123  C   TYR B  86      39.510  39.226   7.901  1.00 33.00           C  
ATOM   2124  O   TYR B  86      39.981  38.117   8.033  1.00 32.98           O  
ATOM   2125  CB  TYR B  86      37.098  39.872   8.299  1.00 32.53           C  
ATOM   2126  CG  TYR B  86      36.496  38.763   9.072  1.00 32.31           C  
ATOM   2127  CD1 TYR B  86      37.116  38.262  10.208  1.00 31.87           C  
ATOM   2128  CD2 TYR B  86      35.322  38.164   8.637  1.00 31.08           C  
ATOM   2129  CE1 TYR B  86      36.554  37.192  10.897  1.00 32.39           C  
ATOM   2130  CE2 TYR B  86      34.766  37.122   9.309  1.00 31.33           C  
ATOM   2131  CZ  TYR B  86      35.372  36.632  10.439  1.00 32.70           C  
ATOM   2132  OH  TYR B  86      34.779  35.550  11.108  1.00 33.06           O  
ATOM   2133  N   GLU B  87      40.127  40.340   8.284  1.00 34.14           N  
ATOM   2134  CA  GLU B  87      41.478  40.390   8.827  1.00 35.36           C  
ATOM   2135  C   GLU B  87      41.720  39.619  10.104  1.00 35.68           C  
ATOM   2136  O   GLU B  87      40.837  39.450  10.920  1.00 35.75           O  
ATOM   2137  CB  GLU B  87      41.910  41.846   9.034  1.00 35.75           C  
ATOM   2138  CG  GLU B  87      43.093  42.319   8.153  1.00 37.38           C  
ATOM   2139  CD  GLU B  87      42.756  42.512   6.673  1.00 38.95           C  
ATOM   2140  OE1 GLU B  87      43.674  42.939   5.933  1.00 39.07           O  
ATOM   2141  OE2 GLU B  87      41.598  42.257   6.257  1.00 38.95           O  
ATOM   2142  N   THR B  88      42.964  39.184  10.263  1.00 36.66           N  
ATOM   2143  CA  THR B  88      43.424  38.474  11.444  1.00 37.44           C  
ATOM   2144  C   THR B  88      42.936  39.124  12.732  1.00 38.00           C  
ATOM   2145  O   THR B  88      43.025  40.352  12.887  1.00 38.02           O  
ATOM   2146  CB  THR B  88      44.966  38.510  11.532  1.00 37.31           C  
ATOM   2147  OG1 THR B  88      45.539  38.250  10.252  1.00 37.59           O  
ATOM   2148  CG2 THR B  88      45.467  37.480  12.539  1.00 37.87           C  
ATOM   2149  N   ASN B  89      42.448  38.284  13.649  1.00 38.71           N  
ATOM   2150  CA  ASN B  89      42.090  38.675  15.024  1.00 39.20           C  
ATOM   2151  C   ASN B  89      40.706  39.279  15.198  1.00 39.99           C  
ATOM   2152  O   ASN B  89      40.211  39.416  16.334  1.00 40.08           O  
ATOM   2153  CB  ASN B  89      43.053  39.745  15.623  1.00 38.94           C  
ATOM   2154  CG  ASN B  89      44.469  39.206  15.928  1.00 38.22           C  
ATOM   2155  OD1 ASN B  89      44.658  38.051  16.318  1.00 37.09           O  
ATOM   2156  ND2 ASN B  89      45.467  40.079  15.782  1.00 37.76           N  
ATOM   2157  N   GLN B  90      40.087  39.622  14.070  1.00 40.59           N  
ATOM   2158  CA  GLN B  90      38.801  40.319  14.050  1.00 41.32           C  
ATOM   2159  C   GLN B  90      37.714  39.363  14.520  1.00 41.62           C  
ATOM   2160  O   GLN B  90      36.698  39.792  15.085  1.00 41.60           O  
ATOM   2161  CB  GLN B  90      38.450  40.809  12.646  1.00 41.36           C  
ATOM   2162  CG  GLN B  90      37.552  42.026  12.632  1.00 42.53           C  
ATOM   2163  CD  GLN B  90      38.379  43.308  12.525  1.00 44.46           C  
ATOM   2164  OE1 GLN B  90      39.004  43.562  11.474  1.00 44.50           O  
ATOM   2165  NE2 GLN B  90      38.394  44.126  13.614  1.00 44.37           N  
ATOM   2166  N   ALA B  91      37.927  38.071  14.287  1.00 42.02           N  
ATOM   2167  CA  ALA B  91      36.910  37.093  14.630  1.00 42.43           C  
ATOM   2168  C   ALA B  91      37.421  35.679  14.861  1.00 42.68           C  
ATOM   2169  O   ALA B  91      38.631  35.410  14.753  1.00 42.65           O  
ATOM   2170  CB  ALA B  91      35.801  37.100  13.596  1.00 42.41           C  
ATOM   2171  N   VAL B  92      36.471  34.800  15.206  1.00 42.71           N  
ATOM   2172  CA  VAL B  92      36.738  33.392  15.515  1.00 42.32           C  
ATOM   2173  C   VAL B  92      35.836  32.488  14.639  1.00 41.56           C  
ATOM   2174  O   VAL B  92      34.874  32.987  14.041  1.00 41.57           O  
ATOM   2175  CB  VAL B  92      36.538  33.116  17.037  1.00 42.26           C  
ATOM   2176  CG1 VAL B  92      37.162  34.250  17.863  1.00 41.74           C  
ATOM   2177  CG2 VAL B  92      35.024  32.908  17.395  1.00 42.61           C  
ATOM   2178  N   PRO B  93      36.134  31.164  14.561  1.00 40.86           N  
ATOM   2179  CA  PRO B  93      35.324  30.361  13.663  1.00 40.24           C  
ATOM   2180  C   PRO B  93      33.954  30.143  14.288  1.00 39.99           C  
ATOM   2181  O   PRO B  93      33.867  29.721  15.441  1.00 39.73           O  
ATOM   2182  CB  PRO B  93      36.108  29.046  13.557  1.00 40.02           C  
ATOM   2183  CG  PRO B  93      37.392  29.260  14.255  1.00 40.20           C  
ATOM   2184  CD  PRO B  93      37.150  30.343  15.240  1.00 40.84           C  
ATOM   2185  N   THR B  94      32.890  30.427  13.537  1.00 39.59           N  
ATOM   2186  CA  THR B  94      31.540  30.316  14.078  1.00 39.51           C  
ATOM   2187  C   THR B  94      30.521  30.002  13.019  1.00 39.12           C  
ATOM   2188  O   THR B  94      30.811  30.094  11.830  1.00 39.25           O  
ATOM   2189  CB  THR B  94      31.092  31.654  14.690  1.00 39.79           C  
ATOM   2190  OG1 THR B  94      29.808  31.491  15.293  1.00 41.06           O  
ATOM   2191  CG2 THR B  94      30.967  32.740  13.605  1.00 39.36           C  
ATOM   2192  N   TRP B  95      29.307  29.657  13.459  1.00 38.97           N  
ATOM   2193  CA  TRP B  95      28.169  29.494  12.549  1.00 38.48           C  
ATOM   2194  C   TRP B  95      27.169  30.597  12.796  1.00 38.97           C  
ATOM   2195  O   TRP B  95      27.065  31.127  13.926  1.00 39.32           O  
ATOM   2196  CB  TRP B  95      27.503  28.147  12.727  1.00 38.36           C  
ATOM   2197  CG  TRP B  95      28.228  27.034  12.027  1.00 38.04           C  
ATOM   2198  CD1 TRP B  95      29.484  26.576  12.302  1.00 37.99           C  
ATOM   2199  CD2 TRP B  95      27.741  26.247  10.916  1.00 38.75           C  
ATOM   2200  NE1 TRP B  95      29.817  25.553  11.433  1.00 37.81           N  
ATOM   2201  CE2 TRP B  95      28.767  25.323  10.577  1.00 37.86           C  
ATOM   2202  CE3 TRP B  95      26.531  26.226  10.181  1.00 38.76           C  
ATOM   2203  CZ2 TRP B  95      28.623  24.364   9.532  1.00 38.63           C  
ATOM   2204  CZ3 TRP B  95      26.386  25.274   9.108  1.00 38.72           C  
ATOM   2205  CH2 TRP B  95      27.438  24.350   8.809  1.00 38.17           C  
ATOM   2206  N   ASN B  96      26.489  31.001  11.726  1.00 38.53           N  
ATOM   2207  CA  ASN B  96      25.374  31.906  11.852  1.00 38.03           C  
ATOM   2208  C   ASN B  96      24.128  31.063  11.670  1.00 37.23           C  
ATOM   2209  O   ASN B  96      24.123  30.119  10.906  1.00 37.71           O  
ATOM   2210  CB  ASN B  96      25.444  33.028  10.822  1.00 38.21           C  
ATOM   2211  CG  ASN B  96      26.211  34.254  11.335  1.00 38.45           C  
ATOM   2212  OD1 ASN B  96      26.772  34.226  12.420  1.00 38.01           O  
ATOM   2213  ND2 ASN B  96      26.214  35.342  10.549  1.00 39.15           N  
ATOM   2214  N   TYR B  97      23.078  31.361  12.412  1.00 36.84           N  
ATOM   2215  CA  TYR B  97      21.840  30.610  12.266  1.00 35.41           C  
ATOM   2216  C   TYR B  97      20.686  31.300  12.985  1.00 34.43           C  
ATOM   2217  O   TYR B  97      20.875  32.129  13.883  1.00 33.96           O  
ATOM   2218  CB  TYR B  97      21.991  29.197  12.846  1.00 35.02           C  
ATOM   2219  CG  TYR B  97      21.988  29.210  14.354  1.00 34.51           C  
ATOM   2220  CD1 TYR B  97      20.802  29.063  15.052  1.00 34.99           C  
ATOM   2221  CD2 TYR B  97      23.152  29.433  15.075  1.00 33.33           C  
ATOM   2222  CE1 TYR B  97      20.766  29.114  16.405  1.00 32.67           C  
ATOM   2223  CE2 TYR B  97      23.128  29.474  16.459  1.00 32.02           C  
ATOM   2224  CZ  TYR B  97      21.925  29.307  17.092  1.00 33.07           C  
ATOM   2225  OH  TYR B  97      21.844  29.341  18.436  1.00 35.13           O  
ATOM   2226  N   VAL B  98      19.494  30.880  12.578  1.00 34.25           N  
ATOM   2227  CA  VAL B  98      18.232  31.217  13.206  1.00 33.54           C  
ATOM   2228  C   VAL B  98      17.411  29.985  13.564  1.00 33.76           C  
ATOM   2229  O   VAL B  98      17.126  29.155  12.722  1.00 34.06           O  
ATOM   2230  CB  VAL B  98      17.386  32.032  12.260  1.00 32.76           C  
ATOM   2231  CG1 VAL B  98      15.970  32.041  12.717  1.00 32.91           C  
ATOM   2232  CG2 VAL B  98      17.928  33.411  12.142  1.00 35.42           C  
ATOM   2233  N   ALA B  99      17.018  29.893  14.832  1.00 32.89           N  
ATOM   2234  CA  ALA B  99      16.017  28.920  15.258  1.00 32.08           C  
ATOM   2235  C   ALA B  99      14.971  29.530  16.193  1.00 31.67           C  
ATOM   2236  O   ALA B  99      15.208  30.565  16.815  1.00 31.19           O  
ATOM   2237  CB  ALA B  99      16.685  27.724  15.918  1.00 32.47           C  
ATOM   2238  N   VAL B 100      13.815  28.879  16.281  1.00 30.71           N  
ATOM   2239  CA  VAL B 100      12.835  29.174  17.301  1.00 30.88           C  
ATOM   2240  C   VAL B 100      12.500  27.914  18.076  1.00 31.44           C  
ATOM   2241  O   VAL B 100      12.282  26.872  17.495  1.00 31.24           O  
ATOM   2242  CB  VAL B 100      11.551  29.755  16.673  1.00 30.38           C  
ATOM   2243  CG1 VAL B 100      10.570  30.163  17.720  1.00 30.05           C  
ATOM   2244  CG2 VAL B 100      11.870  30.911  15.779  1.00 31.41           C  
ATOM   2245  N   HIS B 101      12.465  28.019  19.397  1.00 32.29           N  
ATOM   2246  CA  HIS B 101      12.132  26.893  20.259  1.00 32.75           C  
ATOM   2247  C   HIS B 101      10.795  27.180  20.926  1.00 32.95           C  
ATOM   2248  O   HIS B 101      10.661  28.205  21.562  1.00 33.24           O  
ATOM   2249  CB  HIS B 101      13.162  26.750  21.367  1.00 32.31           C  
ATOM   2250  CG  HIS B 101      14.511  26.320  20.905  1.00 32.27           C  
ATOM   2251  ND1 HIS B 101      15.469  25.848  21.776  1.00 33.13           N  
ATOM   2252  CD2 HIS B 101      15.062  26.258  19.672  1.00 32.67           C  
ATOM   2253  CE1 HIS B 101      16.558  25.524  21.098  1.00 32.63           C  
ATOM   2254  NE2 HIS B 101      16.342  25.772  19.821  1.00 30.93           N  
ATOM   2255  N   VAL B 102       9.843  26.257  20.817  1.00 33.38           N  
ATOM   2256  CA  VAL B 102       8.532  26.387  21.478  1.00 33.85           C  
ATOM   2257  C   VAL B 102       8.327  25.341  22.571  1.00 33.54           C  
ATOM   2258  O   VAL B 102       8.406  24.133  22.322  1.00 33.54           O  
ATOM   2259  CB  VAL B 102       7.335  26.181  20.496  1.00 34.10           C  
ATOM   2260  CG1 VAL B 102       6.034  26.469  21.191  1.00 32.63           C  
ATOM   2261  CG2 VAL B 102       7.470  27.044  19.220  1.00 36.01           C  
ATOM   2262  N   TYR B 103       7.996  25.812  23.765  1.00 33.09           N  
ATOM   2263  CA  TYR B 103       7.680  24.938  24.887  1.00 32.59           C  
ATOM   2264  C   TYR B 103       6.183  24.861  25.110  1.00 32.73           C  
ATOM   2265  O   TYR B 103       5.484  25.841  24.965  1.00 33.06           O  
ATOM   2266  CB  TYR B 103       8.388  25.406  26.154  1.00 32.20           C  
ATOM   2267  CG  TYR B 103       9.885  25.420  26.009  1.00 33.09           C  
ATOM   2268  CD1 TYR B 103      10.545  26.526  25.456  1.00 33.14           C  
ATOM   2269  CD2 TYR B 103      10.660  24.317  26.410  1.00 34.38           C  
ATOM   2270  CE1 TYR B 103      11.943  26.550  25.334  1.00 34.39           C  
ATOM   2271  CE2 TYR B 103      12.062  24.312  26.274  1.00 35.41           C  
ATOM   2272  CZ  TYR B 103      12.686  25.434  25.738  1.00 34.90           C  
ATOM   2273  OH  TYR B 103      14.050  25.458  25.620  1.00 34.38           O  
ATOM   2274  N   GLY B 104       5.691  23.693  25.479  1.00 33.33           N  
ATOM   2275  CA  GLY B 104       4.282  23.539  25.768  1.00 34.32           C  
ATOM   2276  C   GLY B 104       3.895  22.173  26.273  1.00 35.29           C  
ATOM   2277  O   GLY B 104       4.725  21.336  26.517  1.00 35.52           O  
ATOM   2278  N   ASN B 105       2.613  21.956  26.457  1.00 36.52           N  
ATOM   2279  CA  ASN B 105       2.161  20.669  26.935  1.00 37.79           C  
ATOM   2280  C   ASN B 105       1.265  20.125  25.868  1.00 38.04           C  
ATOM   2281  O   ASN B 105       0.615  20.903  25.173  1.00 38.35           O  
ATOM   2282  CB  ASN B 105       1.510  20.771  28.320  1.00 38.24           C  
ATOM   2283  CG  ASN B 105       0.631  22.009  28.479  1.00 40.49           C  
ATOM   2284  OD1 ASN B 105       0.842  22.830  29.391  1.00 43.49           O  
ATOM   2285  ND2 ASN B 105      -0.368  22.146  27.610  1.00 41.91           N  
ATOM   2286  N   VAL B 106       1.285  18.808  25.694  1.00 38.25           N  
ATOM   2287  CA  VAL B 106       0.562  18.140  24.607  1.00 38.49           C  
ATOM   2288  C   VAL B 106      -0.823  17.676  25.009  1.00 39.18           C  
ATOM   2289  O   VAL B 106      -1.067  17.304  26.181  1.00 39.59           O  
ATOM   2290  CB  VAL B 106       1.381  16.933  24.049  1.00 38.69           C  
ATOM   2291  CG1 VAL B 106       0.518  16.056  23.136  1.00 37.86           C  
ATOM   2292  CG2 VAL B 106       2.672  17.425  23.324  1.00 37.12           C  
ATOM   2293  N   GLU B 107      -1.739  17.740  24.053  1.00 39.31           N  
ATOM   2294  CA  GLU B 107      -3.083  17.202  24.229  1.00 39.96           C  
ATOM   2295  C   GLU B 107      -3.432  16.347  23.048  1.00 39.42           C  
ATOM   2296  O   GLU B 107      -3.220  16.755  21.901  1.00 39.45           O  
ATOM   2297  CB  GLU B 107      -4.133  18.299  24.360  1.00 40.34           C  
ATOM   2298  CG  GLU B 107      -4.445  18.713  25.785  1.00 43.90           C  
ATOM   2299  CD  GLU B 107      -5.772  19.432  25.848  1.00 49.12           C  
ATOM   2300  OE1 GLU B 107      -6.031  20.275  24.949  1.00 51.94           O  
ATOM   2301  OE2 GLU B 107      -6.573  19.136  26.772  1.00 50.70           O  
ATOM   2302  N   LEU B 108      -3.965  15.164  23.325  1.00 39.19           N  
ATOM   2303  CA  LEU B 108      -4.352  14.264  22.256  1.00 38.85           C  
ATOM   2304  C   LEU B 108      -5.727  14.617  21.698  1.00 38.71           C  
ATOM   2305  O   LEU B 108      -6.697  14.738  22.444  1.00 38.47           O  
ATOM   2306  CB  LEU B 108      -4.265  12.793  22.668  1.00 38.78           C  
ATOM   2307  CG  LEU B 108      -2.908  12.215  23.107  1.00 39.09           C  
ATOM   2308  CD1 LEU B 108      -2.985  10.692  23.153  1.00 38.99           C  
ATOM   2309  CD2 LEU B 108      -1.744  12.624  22.218  1.00 39.95           C  
ATOM   2310  N   ILE B 109      -5.773  14.809  20.376  1.00 38.66           N  
ATOM   2311  CA  ILE B 109      -7.003  15.071  19.655  1.00 38.42           C  
ATOM   2312  C   ILE B 109      -7.499  13.747  19.103  1.00 38.35           C  
ATOM   2313  O   ILE B 109      -6.776  13.067  18.364  1.00 38.38           O  
ATOM   2314  CB  ILE B 109      -6.800  16.072  18.498  1.00 38.49           C  
ATOM   2315  CG1 ILE B 109      -6.346  17.429  19.038  1.00 38.39           C  
ATOM   2316  CG2 ILE B 109      -8.094  16.253  17.710  1.00 37.75           C  
ATOM   2317  CD1 ILE B 109      -5.863  18.391  17.940  1.00 38.14           C  
ATOM   2318  N   ASN B 110      -8.737  13.414  19.458  1.00 38.62           N  
ATOM   2319  CA  ASN B 110      -9.366  12.153  19.079  1.00 38.92           C  
ATOM   2320  C   ASN B 110     -10.660  12.266  18.288  1.00 39.32           C  
ATOM   2321  O   ASN B 110     -11.070  11.299  17.669  1.00 39.38           O  
ATOM   2322  CB  ASN B 110      -9.522  11.236  20.301  1.00 38.63           C  
ATOM   2323  CG  ASN B 110      -8.212  10.565  20.677  1.00 37.61           C  
ATOM   2324  OD1 ASN B 110      -7.955  10.280  21.844  1.00 36.02           O  
ATOM   2325  ND2 ASN B 110      -7.362  10.334  19.677  1.00 35.60           N  
ATOM   2326  N   ASP B 111     -11.292  13.439  18.294  1.00 40.07           N  
ATOM   2327  CA  ASP B 111     -12.475  13.673  17.458  1.00 40.85           C  
ATOM   2328  C   ASP B 111     -12.039  13.701  16.003  1.00 41.34           C  
ATOM   2329  O   ASP B 111     -11.142  14.456  15.636  1.00 41.30           O  
ATOM   2330  CB  ASP B 111     -13.170  14.995  17.819  1.00 41.07           C  
ATOM   2331  CG  ASP B 111     -14.309  15.355  16.849  1.00 41.68           C  
ATOM   2332  OD1 ASP B 111     -15.333  14.615  16.782  1.00 41.88           O  
ATOM   2333  OD2 ASP B 111     -14.186  16.399  16.157  1.00 41.83           O  
ATOM   2334  N   GLN B 112     -12.673  12.879  15.174  1.00 42.20           N  
ATOM   2335  CA  GLN B 112     -12.343  12.830  13.746  1.00 42.93           C  
ATOM   2336  C   GLN B 112     -12.621  14.133  13.003  1.00 43.13           C  
ATOM   2337  O   GLN B 112     -11.899  14.463  12.063  1.00 43.17           O  
ATOM   2338  CB  GLN B 112     -12.996  11.630  13.048  1.00 42.99           C  
ATOM   2339  CG  GLN B 112     -14.491  11.483  13.257  1.00 43.91           C  
ATOM   2340  CD  GLN B 112     -14.967  10.043  13.064  1.00 44.27           C  
ATOM   2341  OE1 GLN B 112     -16.066   9.790  12.504  1.00 44.16           O  
ATOM   2342  NE2 GLN B 112     -14.138   9.086  13.534  1.00 44.88           N  
ATOM   2343  N   GLY B 113     -13.634  14.884  13.438  1.00 43.10           N  
ATOM   2344  CA  GLY B 113     -13.926  16.196  12.854  1.00 43.37           C  
ATOM   2345  C   GLY B 113     -12.730  17.135  12.945  1.00 43.62           C  
ATOM   2346  O   GLY B 113     -12.305  17.709  11.948  1.00 43.47           O  
ATOM   2347  N   GLU B 114     -12.187  17.275  14.152  1.00 44.03           N  
ATOM   2348  CA  GLU B 114     -11.005  18.103  14.406  1.00 44.52           C  
ATOM   2349  C   GLU B 114      -9.747  17.539  13.733  1.00 44.36           C  
ATOM   2350  O   GLU B 114      -8.915  18.308  13.266  1.00 44.24           O  
ATOM   2351  CB  GLU B 114     -10.774  18.278  15.917  1.00 44.39           C  
ATOM   2352  CG  GLU B 114     -11.793  19.175  16.627  1.00 45.58           C  
ATOM   2353  CD  GLU B 114     -11.866  18.931  18.145  1.00 45.45           C  
ATOM   2354  OE1 GLU B 114     -13.022  18.886  18.671  1.00 45.07           O  
ATOM   2355  OE2 GLU B 114     -10.781  18.770  18.792  1.00 45.95           O  
ATOM   2356  N   VAL B 115      -9.624  16.208  13.688  1.00 44.44           N  
ATOM   2357  CA  VAL B 115      -8.495  15.519  13.046  1.00 44.57           C  
ATOM   2358  C   VAL B 115      -8.525  15.775  11.541  1.00 45.00           C  
ATOM   2359  O   VAL B 115      -7.507  16.164  10.958  1.00 44.95           O  
ATOM   2360  CB  VAL B 115      -8.483  13.982  13.343  1.00 44.42           C  
ATOM   2361  CG1 VAL B 115      -7.521  13.229  12.423  1.00 44.19           C  
ATOM   2362  CG2 VAL B 115      -8.115  13.707  14.797  1.00 44.04           C  
HETATM 2363  N   MSE B 116      -9.697  15.546  10.936  1.00 45.72           N  
HETATM 2364  CA  MSE B 116      -9.966  15.822   9.524  1.00 46.47           C  
HETATM 2365  C   MSE B 116      -9.682  17.273   9.202  1.00 45.87           C  
HETATM 2366  O   MSE B 116      -9.117  17.585   8.152  1.00 45.96           O  
HETATM 2367  CB  MSE B 116     -11.429  15.531   9.160  1.00 47.47           C  
HETATM 2368  CG  MSE B 116     -11.722  14.103   8.802  1.00 51.00           C  
HETATM 2369 SE   MSE B 116     -10.470  13.411   7.467  1.00 56.76          SE  
HETATM 2370  CE  MSE B 116     -11.567  11.901   6.848  1.00 52.14           C  
ATOM   2371  N   GLN B 117     -10.099  18.150  10.105  1.00 45.16           N  
ATOM   2372  CA  GLN B 117      -9.891  19.575   9.976  1.00 44.72           C  
ATOM   2373  C   GLN B 117      -8.382  19.906   9.928  1.00 44.52           C  
ATOM   2374  O   GLN B 117      -7.915  20.589   9.007  1.00 44.34           O  
ATOM   2375  CB  GLN B 117     -10.638  20.298  11.110  1.00 44.64           C  
ATOM   2376  CG  GLN B 117     -10.458  21.791  11.202  1.00 44.93           C  
ATOM   2377  CD  GLN B 117     -10.484  22.466   9.856  1.00 45.85           C  
ATOM   2378  OE1 GLN B 117     -11.390  22.252   9.039  1.00 45.88           O  
ATOM   2379  NE2 GLN B 117      -9.471  23.294   9.608  1.00 46.54           N  
ATOM   2380  N   SER B 118      -7.614  19.399  10.892  1.00 44.35           N  
ATOM   2381  CA  SER B 118      -6.181  19.670  10.904  1.00 44.30           C  
ATOM   2382  C   SER B 118      -5.518  19.089   9.643  1.00 44.01           C  
ATOM   2383  O   SER B 118      -4.616  19.700   9.074  1.00 43.43           O  
ATOM   2384  CB  SER B 118      -5.510  19.168  12.192  1.00 44.46           C  
ATOM   2385  OG  SER B 118      -5.478  17.754  12.249  1.00 44.78           O  
ATOM   2386  N   LEU B 119      -5.995  17.939   9.187  1.00 43.89           N  
ATOM   2387  CA  LEU B 119      -5.462  17.359   7.973  1.00 44.32           C  
ATOM   2388  C   LEU B 119      -5.714  18.237   6.728  1.00 44.56           C  
ATOM   2389  O   LEU B 119      -4.830  18.349   5.874  1.00 44.30           O  
ATOM   2390  CB  LEU B 119      -6.005  15.957   7.765  1.00 44.35           C  
ATOM   2391  CG  LEU B 119      -5.069  15.069   6.945  1.00 44.66           C  
ATOM   2392  CD1 LEU B 119      -3.867  14.586   7.820  1.00 43.56           C  
ATOM   2393  CD2 LEU B 119      -5.873  13.895   6.365  1.00 44.61           C  
ATOM   2394  N   HIS B 120      -6.901  18.855   6.643  1.00 44.91           N  
ATOM   2395  CA  HIS B 120      -7.245  19.779   5.546  1.00 45.39           C  
ATOM   2396  C   HIS B 120      -6.351  21.019   5.502  1.00 45.53           C  
ATOM   2397  O   HIS B 120      -5.940  21.462   4.433  1.00 44.92           O  
ATOM   2398  CB  HIS B 120      -8.697  20.270   5.647  1.00 45.27           C  
ATOM   2399  CG  HIS B 120      -9.716  19.341   5.064  1.00 46.22           C  
ATOM   2400  ND1 HIS B 120      -9.681  18.920   3.750  1.00 46.69           N  
ATOM   2401  CD2 HIS B 120     -10.855  18.823   5.591  1.00 46.61           C  
ATOM   2402  CE1 HIS B 120     -10.725  18.145   3.509  1.00 46.41           C  
ATOM   2403  NE2 HIS B 120     -11.457  18.074   4.608  1.00 46.78           N  
ATOM   2404  N   ASP B 121      -6.096  21.592   6.670  1.00 46.61           N  
ATOM   2405  CA  ASP B 121      -5.273  22.788   6.796  1.00 48.16           C  
ATOM   2406  C   ASP B 121      -3.834  22.530   6.340  1.00 49.20           C  
ATOM   2407  O   ASP B 121      -3.155  23.415   5.822  1.00 48.80           O  
ATOM   2408  CB  ASP B 121      -5.294  23.276   8.256  1.00 48.13           C  
ATOM   2409  CG  ASP B 121      -6.679  23.742   8.701  1.00 48.72           C  
ATOM   2410  OD1 ASP B 121      -7.498  24.119   7.832  1.00 49.08           O  
ATOM   2411  OD2 ASP B 121      -6.958  23.742   9.920  1.00 48.93           O  
HETATM 2412  N   MSE B 122      -3.401  21.291   6.547  1.00 50.96           N  
HETATM 2413  CA  MSE B 122      -2.069  20.810   6.235  1.00 54.38           C  
HETATM 2414  C   MSE B 122      -1.913  20.754   4.712  1.00 50.63           C  
HETATM 2415  O   MSE B 122      -0.936  21.254   4.155  1.00 50.35           O  
HETATM 2416  CB  MSE B 122      -1.889  19.441   6.918  1.00 54.07           C  
HETATM 2417  CG  MSE B 122      -0.470  18.927   7.033  1.00 63.53           C  
HETATM 2418 SE   MSE B 122      -0.178  17.687   8.585  1.00 65.69          SE  
HETATM 2419  CE  MSE B 122      -0.189  18.861  10.199  1.00 63.29           C  
ATOM   2420  N   VAL B 123      -2.909  20.173   4.044  1.00 48.52           N  
ATOM   2421  CA  VAL B 123      -2.970  20.117   2.587  1.00 46.10           C  
ATOM   2422  C   VAL B 123      -2.982  21.528   2.003  1.00 44.92           C  
ATOM   2423  O   VAL B 123      -2.193  21.843   1.108  1.00 44.12           O  
ATOM   2424  CB  VAL B 123      -4.218  19.349   2.133  1.00 46.10           C  
ATOM   2425  CG1 VAL B 123      -4.450  19.506   0.646  1.00 46.24           C  
ATOM   2426  CG2 VAL B 123      -4.097  17.885   2.494  1.00 45.62           C  
ATOM   2427  N   GLU B 124      -3.869  22.367   2.530  1.00 43.50           N  
ATOM   2428  CA  GLU B 124      -4.017  23.744   2.120  1.00 43.09           C  
ATOM   2429  C   GLU B 124      -2.670  24.474   2.100  1.00 42.74           C  
ATOM   2430  O   GLU B 124      -2.289  25.064   1.084  1.00 42.77           O  
ATOM   2431  CB  GLU B 124      -4.951  24.432   3.090  1.00 43.60           C  
ATOM   2432  CG  GLU B 124      -5.940  25.385   2.455  1.00 45.54           C  
ATOM   2433  CD  GLU B 124      -6.882  25.957   3.490  1.00 47.09           C  
ATOM   2434  OE1 GLU B 124      -8.065  25.559   3.505  1.00 47.78           O  
ATOM   2435  OE2 GLU B 124      -6.421  26.761   4.332  1.00 48.58           O  
ATOM   2436  N   LYS B 125      -1.947  24.405   3.223  1.00 41.78           N  
ATOM   2437  CA  LYS B 125      -0.649  25.038   3.377  1.00 40.97           C  
ATOM   2438  C   LYS B 125       0.464  24.521   2.451  1.00 40.16           C  
ATOM   2439  O   LYS B 125       1.304  25.308   2.013  1.00 39.84           O  
ATOM   2440  CB  LYS B 125      -0.194  24.941   4.841  1.00 40.98           C  
ATOM   2441  CG  LYS B 125       1.203  25.542   5.152  1.00 41.25           C  
ATOM   2442  CD  LYS B 125       1.564  25.351   6.643  1.00 41.77           C  
ATOM   2443  CE  LYS B 125       2.976  25.875   7.006  1.00 41.86           C  
ATOM   2444  NZ  LYS B 125       3.140  27.311   6.582  1.00 41.56           N  
ATOM   2445  N   TYR B 126       0.487  23.223   2.157  1.00 39.24           N  
ATOM   2446  CA  TYR B 126       1.630  22.654   1.406  1.00 38.53           C  
ATOM   2447  C   TYR B 126       1.404  22.366  -0.072  1.00 37.84           C  
ATOM   2448  O   TYR B 126       2.374  22.190  -0.808  1.00 37.69           O  
ATOM   2449  CB  TYR B 126       2.220  21.386   2.066  1.00 38.45           C  
ATOM   2450  CG  TYR B 126       2.693  21.547   3.489  1.00 38.95           C  
ATOM   2451  CD1 TYR B 126       2.067  20.852   4.518  1.00 39.41           C  
ATOM   2452  CD2 TYR B 126       3.765  22.381   3.815  1.00 39.53           C  
ATOM   2453  CE1 TYR B 126       2.468  20.980   5.825  1.00 39.57           C  
ATOM   2454  CE2 TYR B 126       4.177  22.537   5.153  1.00 40.04           C  
ATOM   2455  CZ  TYR B 126       3.517  21.818   6.138  1.00 39.68           C  
ATOM   2456  OH  TYR B 126       3.870  21.927   7.449  1.00 39.23           O  
ATOM   2457  N   GLU B 127       0.153  22.274  -0.501  1.00 37.71           N  
ATOM   2458  CA  GLU B 127      -0.125  22.062  -1.926  1.00 37.61           C  
ATOM   2459  C   GLU B 127       0.120  23.344  -2.695  1.00 37.71           C  
ATOM   2460  O   GLU B 127      -0.118  24.423  -2.158  1.00 38.18           O  
ATOM   2461  CB  GLU B 127      -1.558  21.572  -2.179  1.00 37.36           C  
ATOM   2462  CG  GLU B 127      -1.788  20.080  -1.900  1.00 36.25           C  
ATOM   2463  CD  GLU B 127      -0.969  19.130  -2.780  1.00 34.08           C  
ATOM   2464  OE1 GLU B 127      -1.031  19.236  -4.022  1.00 33.70           O  
ATOM   2465  OE2 GLU B 127      -0.290  18.245  -2.219  1.00 32.00           O  
ATOM   2466  N   ALA B 128       0.586  23.209  -3.940  1.00 37.24           N  
ATOM   2467  CA  ALA B 128       0.854  24.336  -4.839  1.00 36.96           C  
ATOM   2468  C   ALA B 128      -0.423  25.143  -5.132  1.00 37.02           C  
ATOM   2469  O   ALA B 128      -1.531  24.604  -5.054  1.00 37.29           O  
ATOM   2470  CB  ALA B 128       1.490  23.835  -6.143  1.00 36.49           C  
ATOM   2471  N   PRO B 129      -0.277  26.442  -5.482  1.00 37.25           N  
ATOM   2472  CA  PRO B 129      -1.524  27.234  -5.708  1.00 36.84           C  
ATOM   2473  C   PRO B 129      -2.372  26.642  -6.835  1.00 36.57           C  
ATOM   2474  O   PRO B 129      -3.603  26.805  -6.853  1.00 36.81           O  
ATOM   2475  CB  PRO B 129      -1.017  28.633  -6.078  1.00 37.03           C  
ATOM   2476  CG  PRO B 129       0.455  28.444  -6.444  1.00 37.77           C  
ATOM   2477  CD  PRO B 129       0.959  27.235  -5.698  1.00 37.22           C  
ATOM   2478  N   GLY B 130      -1.717  25.960  -7.768  1.00 35.83           N  
ATOM   2479  CA  GLY B 130      -2.411  25.300  -8.858  1.00 34.22           C  
ATOM   2480  C   GLY B 130      -3.577  24.459  -8.381  1.00 32.79           C  
ATOM   2481  O   GLY B 130      -4.631  24.422  -9.016  1.00 32.27           O  
ATOM   2482  N   SER B 131      -3.389  23.781  -7.253  1.00 31.20           N  
ATOM   2483  CA  SER B 131      -3.566  22.335  -7.189  1.00 30.24           C  
ATOM   2484  C   SER B 131      -5.031  21.952  -7.367  1.00 29.89           C  
ATOM   2485  O   SER B 131      -5.923  22.791  -7.239  1.00 29.69           O  
ATOM   2486  CB  SER B 131      -3.037  21.788  -5.862  1.00 30.22           C  
ATOM   2487  OG  SER B 131      -2.911  20.377  -5.907  1.00 29.55           O  
ATOM   2488  N   ARG B 132      -5.273  20.679  -7.663  1.00 29.37           N  
ATOM   2489  CA  ARG B 132      -6.632  20.172  -7.813  1.00 28.96           C  
ATOM   2490  C   ARG B 132      -6.902  19.023  -6.848  1.00 29.53           C  
ATOM   2491  O   ARG B 132      -7.942  18.369  -6.921  1.00 29.51           O  
ATOM   2492  CB  ARG B 132      -6.878  19.717  -9.253  1.00 28.36           C  
ATOM   2493  CG  ARG B 132      -6.952  20.853 -10.259  1.00 26.58           C  
ATOM   2494  CD  ARG B 132      -7.225  20.405 -11.685  1.00 22.76           C  
ATOM   2495  NE  ARG B 132      -7.350  21.535 -12.601  1.00 20.47           N  
ATOM   2496  CZ  ARG B 132      -7.597  21.419 -13.899  1.00 20.20           C  
ATOM   2497  NH1 ARG B 132      -7.749  20.219 -14.443  1.00 20.68           N  
ATOM   2498  NH2 ARG B 132      -7.693  22.503 -14.656  1.00 19.35           N  
ATOM   2499  N   TYR B 133      -5.960  18.784  -5.941  1.00 30.32           N  
ATOM   2500  CA  TYR B 133      -6.034  17.647  -5.046  1.00 31.39           C  
ATOM   2501  C   TYR B 133      -6.958  17.912  -3.874  1.00 32.83           C  
ATOM   2502  O   TYR B 133      -6.794  18.891  -3.143  1.00 32.96           O  
ATOM   2503  CB  TYR B 133      -4.661  17.244  -4.534  1.00 30.70           C  
ATOM   2504  CG  TYR B 133      -4.705  16.215  -3.426  1.00 29.58           C  
ATOM   2505  CD1 TYR B 133      -4.998  14.879  -3.689  1.00 27.74           C  
ATOM   2506  CD2 TYR B 133      -4.445  16.580  -2.122  1.00 29.47           C  
ATOM   2507  CE1 TYR B 133      -5.037  13.935  -2.677  1.00 28.25           C  
ATOM   2508  CE2 TYR B 133      -4.474  15.638  -1.088  1.00 29.92           C  
ATOM   2509  CZ  TYR B 133      -4.776  14.321  -1.381  1.00 29.86           C  
ATOM   2510  OH  TYR B 133      -4.787  13.405  -0.360  1.00 30.44           O  
ATOM   2511  N   GLN B 134      -7.903  16.996  -3.693  1.00 34.62           N  
ATOM   2512  CA  GLN B 134      -8.906  17.099  -2.661  1.00 36.31           C  
ATOM   2513  C   GLN B 134      -8.880  15.949  -1.655  1.00 37.28           C  
ATOM   2514  O   GLN B 134      -8.091  15.009  -1.772  1.00 37.55           O  
ATOM   2515  CB  GLN B 134     -10.258  17.341  -3.331  1.00 36.04           C  
ATOM   2516  CG  GLN B 134     -10.502  18.736  -3.870  1.00 36.90           C  
ATOM   2517  CD  GLN B 134     -11.949  18.831  -4.393  1.00 37.36           C  
ATOM   2518  OE1 GLN B 134     -12.799  19.532  -3.800  1.00 38.54           O  
ATOM   2519  NE2 GLN B 134     -12.254  18.078  -5.479  1.00 37.92           N  
ATOM   2520  N   LEU B 135      -9.873  16.082  -0.716  1.00 38.29           N  
ATOM   2521  CA  LEU B 135     -10.483  15.041   0.135  1.00 39.03           C  
ATOM   2522  C   LEU B 135     -11.460  14.242  -0.785  1.00 39.60           C  
ATOM   2523  O   LEU B 135     -12.675  14.209  -0.547  1.00 39.48           O  
ATOM   2524  CB  LEU B 135     -11.402  15.880   1.024  1.00 39.11           C  
ATOM   2525  CG  LEU B 135     -12.203  16.868   0.122  1.00 38.95           C  
ATOM   2526  CD1 LEU B 135     -13.670  16.450  -0.124  1.00 38.42           C  
ATOM   2527  CD2 LEU B 135     -12.129  18.326   0.608  1.00 39.27           C  
ATOM   2528  N   SER B 136     -10.938  13.611  -1.833  1.00 40.54           N  
ATOM   2529  CA  SER B 136     -11.741  12.745  -2.696  1.00 41.47           C  
ATOM   2530  C   SER B 136     -11.354  11.242  -2.574  1.00 42.19           C  
ATOM   2531  O   SER B 136     -10.918  10.577  -3.532  1.00 42.38           O  
ATOM   2532  CB  SER B 136     -11.695  13.245  -4.157  1.00 41.40           C  
ATOM   2533  OG  SER B 136     -12.779  12.738  -4.944  1.00 41.77           O  
ATOM   2534  N   GLU B 137     -11.483  10.743  -1.284  1.00 43.04           N  
ATOM   2535  CA  GLU B 137     -11.453   9.284  -1.036  1.00 43.88           C  
ATOM   2536  C   GLU B 137     -12.418   8.877   0.081  1.00 44.41           C  
ATOM   2537  O   GLU B 137     -12.882   9.746   0.854  1.00 44.73           O  
ATOM   2538  CB  GLU B 137     -10.047   8.719  -0.799  1.00 43.84           C  
ATOM   2539  CG  GLU B 137      -9.206   9.539   0.132  1.00 44.76           C  
ATOM   2540  CD  GLU B 137      -8.741  10.808  -0.534  1.00 46.06           C  
ATOM   2541  OE1 GLU B 137      -8.387  10.717  -1.754  1.00 47.05           O  
ATOM   2542  OE2 GLU B 137      -8.741  11.890   0.142  1.00 46.54           O  
ATOM   2543  N   VAL B 138     -12.685   7.549   0.160  1.00 44.84           N  
ATOM   2544  CA  VAL B 138     -13.759   6.989   1.020  1.00 45.07           C  
ATOM   2545  C   VAL B 138     -13.844   7.528   2.483  1.00 45.11           C  
ATOM   2546  O   VAL B 138     -13.060   7.130   3.376  1.00 45.04           O  
ATOM   2547  CB  VAL B 138     -13.770   5.419   0.955  1.00 45.14           C  
ATOM   2548  CG1 VAL B 138     -13.844   4.933  -0.532  1.00 45.05           C  
ATOM   2549  CG2 VAL B 138     -12.464   4.803   1.548  1.00 45.57           C  
HETATM 2550  N   MSE B 142     -10.218   3.666   3.318  1.00 65.49           N  
HETATM 2551  CA  MSE B 142      -9.056   4.358   2.755  1.00 65.59           C  
HETATM 2552  C   MSE B 142      -8.745   5.598   3.595  1.00 65.09           C  
HETATM 2553  O   MSE B 142      -7.613   5.766   4.050  1.00 65.11           O  
HETATM 2554  CB  MSE B 142      -9.298   4.723   1.285  1.00 66.11           C  
HETATM 2555  CG  MSE B 142      -8.093   4.550   0.346  1.00 67.68           C  
HETATM 2556 SE   MSE B 142      -6.784   6.028   0.262  1.00 70.24          SE  
HETATM 2557  CE  MSE B 142      -5.524   5.259  -1.039  1.00 68.40           C  
ATOM   2558  N   LEU B 143      -9.746   6.460   3.804  1.00 64.45           N  
ATOM   2559  CA  LEU B 143      -9.599   7.608   4.713  1.00 63.79           C  
ATOM   2560  C   LEU B 143      -9.718   7.173   6.170  1.00 63.32           C  
ATOM   2561  O   LEU B 143      -8.997   7.667   7.040  1.00 63.36           O  
ATOM   2562  CB  LEU B 143     -10.663   8.666   4.447  1.00 63.82           C  
ATOM   2563  CG  LEU B 143     -10.438   9.783   3.442  1.00 63.81           C  
ATOM   2564  CD1 LEU B 143     -11.743  10.539   3.292  1.00 63.85           C  
ATOM   2565  CD2 LEU B 143      -9.330  10.719   3.906  1.00 63.42           C  
ATOM   2566  N   SER B 144     -10.660   6.266   6.419  1.00 62.73           N  
ATOM   2567  CA  SER B 144     -10.905   5.705   7.741  1.00 61.99           C  
ATOM   2568  C   SER B 144      -9.685   4.933   8.236  1.00 61.51           C  
ATOM   2569  O   SER B 144      -9.230   5.145   9.359  1.00 61.56           O  
ATOM   2570  CB  SER B 144     -12.127   4.786   7.693  1.00 62.03           C  
ATOM   2571  OG  SER B 144     -12.362   4.182   8.952  1.00 61.89           O  
ATOM   2572  N   GLY B 145      -9.165   4.046   7.384  1.00 60.89           N  
ATOM   2573  CA  GLY B 145      -7.991   3.226   7.696  1.00 59.94           C  
ATOM   2574  C   GLY B 145      -6.755   4.042   8.020  1.00 59.32           C  
ATOM   2575  O   GLY B 145      -6.084   3.795   9.023  1.00 59.23           O  
HETATM 2576  N   MSE B 146      -6.479   5.028   7.173  1.00 58.62           N  
HETATM 2577  CA  MSE B 146      -5.363   5.947   7.354  1.00 58.47           C  
HETATM 2578  C   MSE B 146      -5.425   6.612   8.716  1.00 55.91           C  
HETATM 2579  O   MSE B 146      -4.404   6.998   9.278  1.00 55.81           O  
HETATM 2580  CB  MSE B 146      -5.374   7.009   6.250  1.00 58.57           C  
HETATM 2581  CG  MSE B 146      -4.225   8.009   6.303  1.00 62.65           C  
HETATM 2582 SE   MSE B 146      -4.732   9.797   5.746  1.00 62.64          SE  
HETATM 2583  CE  MSE B 146      -5.916  10.193   7.123  1.00 62.52           C  
ATOM   2584  N   ASN B 147      -6.635   6.732   9.240  1.00 53.41           N  
ATOM   2585  CA  ASN B 147      -6.897   7.554  10.404  1.00 50.86           C  
ATOM   2586  C   ASN B 147      -6.797   6.743  11.684  1.00 48.82           C  
ATOM   2587  O   ASN B 147      -6.643   7.290  12.769  1.00 48.67           O  
ATOM   2588  CB  ASN B 147      -8.290   8.150  10.289  1.00 51.10           C  
ATOM   2589  CG  ASN B 147      -8.355   9.566  10.779  1.00 51.51           C  
ATOM   2590  OD1 ASN B 147      -8.275  10.509   9.999  1.00 51.39           O  
ATOM   2591  ND2 ASN B 147      -8.512   9.729  12.082  1.00 51.70           N  
ATOM   2592  N   LYS B 148      -6.899   5.428  11.547  1.00 46.34           N  
ATOM   2593  CA  LYS B 148      -6.681   4.518  12.658  1.00 43.62           C  
ATOM   2594  C   LYS B 148      -5.209   4.177  12.740  1.00 41.72           C  
ATOM   2595  O   LYS B 148      -4.798   3.317  13.509  1.00 41.30           O  
ATOM   2596  CB  LYS B 148      -7.494   3.240  12.457  1.00 43.70           C  
ATOM   2597  CG  LYS B 148      -8.971   3.404  12.743  1.00 43.70           C  
ATOM   2598  CD  LYS B 148      -9.796   2.319  12.068  1.00 43.53           C  
ATOM   2599  CE  LYS B 148     -11.218   2.798  11.785  1.00 42.65           C  
ATOM   2600  NZ  LYS B 148     -12.186   1.678  11.635  1.00 42.15           N  
ATOM   2601  N   GLY B 149      -4.425   4.858  11.924  1.00 39.43           N  
ATOM   2602  CA  GLY B 149      -2.994   4.627  11.859  1.00 36.84           C  
ATOM   2603  C   GLY B 149      -2.223   5.848  12.289  1.00 35.00           C  
ATOM   2604  O   GLY B 149      -0.993   5.852  12.270  1.00 34.74           O  
ATOM   2605  N   ILE B 150      -2.943   6.902  12.660  1.00 33.38           N  
ATOM   2606  CA  ILE B 150      -2.294   8.115  13.155  1.00 31.78           C  
ATOM   2607  C   ILE B 150      -2.868   8.559  14.503  1.00 30.33           C  
ATOM   2608  O   ILE B 150      -3.986   8.166  14.868  1.00 29.84           O  
ATOM   2609  CB  ILE B 150      -2.372   9.273  12.133  1.00 31.82           C  
ATOM   2610  CG1 ILE B 150      -3.699  10.017  12.258  1.00 31.67           C  
ATOM   2611  CG2 ILE B 150      -2.082   8.765  10.686  1.00 31.30           C  
ATOM   2612  CD1 ILE B 150      -3.898  11.096  11.224  1.00 31.54           C  
ATOM   2613  N   GLN B 151      -2.075   9.323  15.256  1.00 29.23           N  
ATOM   2614  CA  GLN B 151      -2.528   9.951  16.514  1.00 28.24           C  
ATOM   2615  C   GLN B 151      -2.341  11.471  16.497  1.00 27.55           C  
ATOM   2616  O   GLN B 151      -1.242  11.960  16.657  1.00 27.50           O  
ATOM   2617  CB  GLN B 151      -1.839   9.356  17.750  1.00 28.00           C  
ATOM   2618  CG  GLN B 151      -2.214  10.060  19.038  1.00 27.13           C  
ATOM   2619  CD  GLN B 151      -3.691   9.854  19.420  1.00 27.24           C  
ATOM   2620  OE1 GLN B 151      -4.431  10.824  19.604  1.00 26.78           O  
ATOM   2621  NE2 GLN B 151      -4.109   8.592  19.565  1.00 24.33           N  
ATOM   2622  N   ALA B 152      -3.432  12.198  16.311  1.00 27.17           N  
ATOM   2623  CA  ALA B 152      -3.417  13.651  16.258  1.00 26.73           C  
ATOM   2624  C   ALA B 152      -3.219  14.239  17.620  1.00 26.83           C  
ATOM   2625  O   ALA B 152      -3.647  13.661  18.639  1.00 27.06           O  
ATOM   2626  CB  ALA B 152      -4.696  14.157  15.695  1.00 26.83           C  
ATOM   2627  N   PHE B 153      -2.622  15.417  17.647  1.00 26.32           N  
ATOM   2628  CA  PHE B 153      -2.380  16.083  18.899  1.00 26.42           C  
ATOM   2629  C   PHE B 153      -2.192  17.581  18.656  1.00 26.65           C  
ATOM   2630  O   PHE B 153      -2.026  18.037  17.513  1.00 26.12           O  
ATOM   2631  CB  PHE B 153      -1.136  15.486  19.569  1.00 26.30           C  
ATOM   2632  CG  PHE B 153       0.122  15.784  18.829  1.00 25.59           C  
ATOM   2633  CD1 PHE B 153       0.863  16.891  19.139  1.00 26.41           C  
ATOM   2634  CD2 PHE B 153       0.511  15.015  17.754  1.00 27.59           C  
ATOM   2635  CE1 PHE B 153       2.008  17.199  18.445  1.00 26.72           C  
ATOM   2636  CE2 PHE B 153       1.660  15.338  17.025  1.00 27.42           C  
ATOM   2637  CZ  PHE B 153       2.411  16.414  17.390  1.00 26.67           C  
ATOM   2638  N   LYS B 154      -2.136  18.306  19.766  1.00 27.60           N  
ATOM   2639  CA  LYS B 154      -2.100  19.755  19.820  1.00 28.68           C  
ATOM   2640  C   LYS B 154      -1.025  20.162  20.882  1.00 29.75           C  
ATOM   2641  O   LYS B 154      -0.928  19.526  21.935  1.00 29.70           O  
ATOM   2642  CB  LYS B 154      -3.527  20.151  20.242  1.00 28.88           C  
ATOM   2643  CG  LYS B 154      -3.812  21.569  20.725  1.00 28.94           C  
ATOM   2644  CD  LYS B 154      -5.061  21.619  21.615  1.00 28.89           C  
ATOM   2645  CE  LYS B 154      -6.370  21.695  20.813  1.00 31.39           C  
ATOM   2646  NZ  LYS B 154      -7.596  22.089  21.661  1.00 30.06           N  
ATOM   2647  N   ILE B 155      -0.189  21.161  20.619  1.00 30.60           N  
ATOM   2648  CA  ILE B 155       0.701  21.651  21.678  1.00 32.33           C  
ATOM   2649  C   ILE B 155       0.168  22.974  22.234  1.00 33.04           C  
ATOM   2650  O   ILE B 155       0.076  23.957  21.483  1.00 33.46           O  
ATOM   2651  CB  ILE B 155       2.173  21.917  21.191  1.00 32.50           C  
ATOM   2652  CG1 ILE B 155       2.914  20.627  20.881  1.00 31.18           C  
ATOM   2653  CG2 ILE B 155       2.991  22.578  22.299  1.00 33.65           C  
ATOM   2654  CD1 ILE B 155       4.199  20.877  20.128  1.00 32.63           C  
ATOM   2655  N   ILE B 156      -0.210  23.031  23.512  1.00 33.74           N  
ATOM   2656  CA  ILE B 156      -0.617  24.340  24.068  1.00 33.94           C  
ATOM   2657  C   ILE B 156       0.657  25.145  24.377  1.00 33.84           C  
ATOM   2658  O   ILE B 156       1.434  24.766  25.265  1.00 33.72           O  
ATOM   2659  CB  ILE B 156      -1.576  24.264  25.294  1.00 34.50           C  
ATOM   2660  CG1 ILE B 156      -2.941  23.676  24.898  1.00 35.11           C  
ATOM   2661  CG2 ILE B 156      -1.807  25.693  25.933  1.00 34.01           C  
ATOM   2662  CD1 ILE B 156      -3.061  22.171  25.075  1.00 36.95           C  
ATOM   2663  N   ILE B 157       0.873  26.231  23.634  1.00 33.63           N  
ATOM   2664  CA  ILE B 157       2.122  27.017  23.732  1.00 33.66           C  
ATOM   2665  C   ILE B 157       2.248  27.766  25.055  1.00 34.60           C  
ATOM   2666  O   ILE B 157       1.301  28.378  25.492  1.00 34.41           O  
ATOM   2667  CB  ILE B 157       2.257  27.977  22.531  1.00 33.25           C  
ATOM   2668  CG1 ILE B 157       2.238  27.159  21.231  1.00 31.90           C  
ATOM   2669  CG2 ILE B 157       3.530  28.817  22.627  1.00 32.32           C  
ATOM   2670  CD1 ILE B 157       2.496  27.955  20.008  1.00 30.25           C  
ATOM   2671  N   LYS B 158       3.401  27.689  25.712  1.00 35.55           N  
ATOM   2672  CA  LYS B 158       3.576  28.399  26.987  1.00 36.26           C  
ATOM   2673  C   LYS B 158       4.605  29.495  26.834  1.00 36.82           C  
ATOM   2674  O   LYS B 158       4.493  30.551  27.425  1.00 36.71           O  
ATOM   2675  CB  LYS B 158       4.011  27.449  28.110  1.00 36.13           C  
ATOM   2676  CG  LYS B 158       3.043  26.302  28.358  1.00 37.66           C  
ATOM   2677  CD  LYS B 158       1.586  26.789  28.625  1.00 38.95           C  
ATOM   2678  CE  LYS B 158       0.742  25.697  29.252  1.00 38.62           C  
ATOM   2679  NZ  LYS B 158      -0.629  26.145  29.545  1.00 40.10           N  
ATOM   2680  N   ARG B 159       5.604  29.229  26.006  1.00 37.71           N  
ATOM   2681  CA  ARG B 159       6.691  30.142  25.834  1.00 38.66           C  
ATOM   2682  C   ARG B 159       7.375  29.862  24.492  1.00 38.95           C  
ATOM   2683  O   ARG B 159       7.405  28.732  24.003  1.00 38.94           O  
ATOM   2684  CB  ARG B 159       7.635  29.979  27.032  1.00 38.84           C  
ATOM   2685  CG  ARG B 159       8.943  30.745  26.991  1.00 39.72           C  
ATOM   2686  CD  ARG B 159       9.620  30.674  28.352  1.00 41.53           C  
ATOM   2687  NE  ARG B 159       9.703  29.291  28.813  1.00 43.96           N  
ATOM   2688  CZ  ARG B 159      10.724  28.464  28.579  1.00 43.66           C  
ATOM   2689  NH1 ARG B 159      11.807  28.867  27.910  1.00 40.74           N  
ATOM   2690  NH2 ARG B 159      10.659  27.226  29.054  1.00 45.50           N  
ATOM   2691  N   ILE B 160       7.879  30.933  23.895  1.00 39.79           N  
ATOM   2692  CA  ILE B 160       8.602  30.918  22.636  1.00 40.05           C  
ATOM   2693  C   ILE B 160       9.932  31.632  22.845  1.00 40.95           C  
ATOM   2694  O   ILE B 160       9.966  32.755  23.370  1.00 40.90           O  
ATOM   2695  CB  ILE B 160       7.794  31.663  21.564  1.00 40.09           C  
ATOM   2696  CG1 ILE B 160       6.436  30.986  21.377  1.00 40.18           C  
ATOM   2697  CG2 ILE B 160       8.545  31.733  20.260  1.00 38.87           C  
ATOM   2698  CD1 ILE B 160       5.630  31.510  20.202  1.00 40.40           C  
ATOM   2699  N   GLU B 161      11.019  30.973  22.472  1.00 41.45           N  
ATOM   2700  CA  GLU B 161      12.348  31.572  22.477  1.00 42.98           C  
ATOM   2701  C   GLU B 161      12.900  31.568  21.062  1.00 42.95           C  
ATOM   2702  O   GLU B 161      12.893  30.538  20.385  1.00 43.12           O  
ATOM   2703  CB  GLU B 161      13.314  30.791  23.354  1.00 43.00           C  
ATOM   2704  CG  GLU B 161      12.972  30.780  24.834  1.00 44.92           C  
ATOM   2705  CD  GLU B 161      13.757  29.710  25.640  1.00 45.19           C  
ATOM   2706  OE1 GLU B 161      14.450  28.817  25.037  1.00 45.80           O  
ATOM   2707  OE2 GLU B 161      13.632  29.760  26.895  1.00 47.26           O  
ATOM   2708  N   GLY B 162      13.366  32.728  20.620  1.00 43.23           N  
ATOM   2709  CA  GLY B 162      14.045  32.873  19.347  1.00 43.40           C  
ATOM   2710  C   GLY B 162      15.528  32.760  19.599  1.00 44.12           C  
ATOM   2711  O   GLY B 162      16.020  33.154  20.645  1.00 44.32           O  
ATOM   2712  N   LYS B 163      16.245  32.208  18.636  1.00 44.89           N  
ATOM   2713  CA  LYS B 163      17.677  32.005  18.765  1.00 45.49           C  
ATOM   2714  C   LYS B 163      18.230  32.518  17.458  1.00 45.71           C  
ATOM   2715  O   LYS B 163      17.776  32.126  16.402  1.00 45.80           O  
ATOM   2716  CB  LYS B 163      17.995  30.508  18.911  1.00 45.77           C  
ATOM   2717  CG  LYS B 163      17.210  29.741  19.994  1.00 45.99           C  
ATOM   2718  CD  LYS B 163      17.832  29.806  21.381  1.00 48.20           C  
ATOM   2719  CE  LYS B 163      16.996  28.971  22.376  1.00 48.74           C  
ATOM   2720  NZ  LYS B 163      17.683  28.638  23.674  1.00 48.40           N  
ATOM   2721  N   ALA B 164      19.220  33.401  17.540  1.00 46.12           N  
ATOM   2722  CA  ALA B 164      19.851  33.958  16.350  1.00 46.71           C  
ATOM   2723  C   ALA B 164      21.346  34.166  16.564  1.00 47.33           C  
ATOM   2724  O   ALA B 164      21.766  34.730  17.573  1.00 47.62           O  
ATOM   2725  CB  ALA B 164      19.183  35.268  15.961  1.00 46.90           C  
ATOM   2726  N   LYS B 165      22.146  33.703  15.608  1.00 46.93           N  
ATOM   2727  CA  LYS B 165      23.533  34.134  15.495  1.00 46.73           C  
ATOM   2728  C   LYS B 165      23.838  34.652  14.093  1.00 46.44           C  
ATOM   2729  O   LYS B 165      23.912  33.879  13.138  1.00 46.27           O  
ATOM   2730  CB  LYS B 165      24.482  32.987  15.850  1.00 46.92           C  
ATOM   2731  CG  LYS B 165      25.209  33.169  17.172  1.00 47.49           C  
ATOM   2732  CD  LYS B 165      26.716  33.195  16.975  1.00 48.99           C  
ATOM   2733  CE  LYS B 165      27.411  32.218  17.908  1.00 48.87           C  
ATOM   2734  NZ  LYS B 165      28.886  32.422  17.926  1.00 47.73           N  
ATOM   2735  N   LEU B 166      24.014  35.964  13.977  1.00 46.13           N  
ATOM   2736  CA  LEU B 166      24.060  36.618  12.675  1.00 45.88           C  
ATOM   2737  C   LEU B 166      25.266  37.547  12.568  1.00 46.22           C  
ATOM   2738  O   LEU B 166      25.383  38.322  11.619  1.00 46.32           O  
ATOM   2739  CB  LEU B 166      22.770  37.401  12.422  1.00 45.41           C  
ATOM   2740  CG  LEU B 166      21.565  36.585  11.950  1.00 44.95           C  
ATOM   2741  CD1 LEU B 166      20.326  37.463  11.856  1.00 43.59           C  
ATOM   2742  CD2 LEU B 166      21.856  35.919  10.614  1.00 41.48           C  
ATOM   2743  N   SER B 167      26.160  37.463  13.548  1.00 46.09           N  
ATOM   2744  CA  SER B 167      27.414  38.240  13.523  1.00 46.08           C  
ATOM   2745  C   SER B 167      27.156  39.727  13.392  1.00 46.03           C  
ATOM   2746  O   SER B 167      27.736  40.409  12.554  1.00 46.06           O  
ATOM   2747  CB  SER B 167      28.395  37.734  12.444  1.00 46.12           C  
ATOM   2748  OG  SER B 167      27.938  38.027  11.140  1.00 45.72           O  
ATOM   2749  N   GLN B 168      26.259  40.211  14.249  1.00 46.37           N  
ATOM   2750  CA  GLN B 168      25.885  41.613  14.317  1.00 46.28           C  
ATOM   2751  C   GLN B 168      26.785  42.371  15.298  1.00 46.77           C  
ATOM   2752  O   GLN B 168      26.528  43.541  15.621  1.00 47.04           O  
ATOM   2753  CB  GLN B 168      24.438  41.732  14.761  1.00 46.03           C  
ATOM   2754  CG  GLN B 168      23.442  41.071  13.855  1.00 45.58           C  
ATOM   2755  CD  GLN B 168      22.117  40.858  14.576  1.00 46.23           C  
ATOM   2756  OE1 GLN B 168      21.460  41.839  14.966  1.00 47.49           O  
ATOM   2757  NE2 GLN B 168      21.720  39.581  14.778  1.00 43.75           N  
ATOM   2758  N   ASN B 169      27.841  41.705  15.766  1.00 46.89           N  
ATOM   2759  CA  ASN B 169      28.818  42.309  16.694  1.00 46.79           C  
ATOM   2760  C   ASN B 169      30.123  42.721  15.987  1.00 45.95           C  
ATOM   2761  O   ASN B 169      31.116  43.064  16.640  1.00 45.94           O  
ATOM   2762  CB  ASN B 169      29.121  41.349  17.869  1.00 47.27           C  
ATOM   2763  CG  ASN B 169      27.858  40.785  18.525  1.00 48.03           C  
ATOM   2764  OD1 ASN B 169      27.562  41.086  19.689  1.00 48.26           O  
ATOM   2765  ND2 ASN B 169      27.114  39.958  17.778  1.00 48.42           N  
ATOM   2766  N   HIS B 170      30.123  42.634  14.657  1.00 45.03           N  
ATOM   2767  CA  HIS B 170      31.235  43.116  13.840  1.00 44.10           C  
ATOM   2768  C   HIS B 170      30.744  44.417  13.213  1.00 43.35           C  
ATOM   2769  O   HIS B 170      29.545  44.546  12.963  1.00 43.15           O  
ATOM   2770  CB  HIS B 170      31.586  42.121  12.724  1.00 44.12           C  
ATOM   2771  CG  HIS B 170      31.939  40.751  13.210  1.00 43.89           C  
ATOM   2772  ND1 HIS B 170      31.022  39.722  13.263  1.00 43.85           N  
ATOM   2773  CD2 HIS B 170      33.109  40.235  13.655  1.00 43.75           C  
ATOM   2774  CE1 HIS B 170      31.610  38.633  13.723  1.00 43.75           C  
ATOM   2775  NE2 HIS B 170      32.875  38.917  13.970  1.00 43.85           N  
ATOM   2776  N   PRO B 171      31.650  45.378  12.948  1.00 42.68           N  
ATOM   2777  CA  PRO B 171      31.158  46.625  12.348  1.00 42.30           C  
ATOM   2778  C   PRO B 171      30.642  46.475  10.908  1.00 41.87           C  
ATOM   2779  O   PRO B 171      30.628  45.375  10.366  1.00 41.87           O  
ATOM   2780  CB  PRO B 171      32.367  47.582  12.432  1.00 42.25           C  
ATOM   2781  CG  PRO B 171      33.553  46.718  12.606  1.00 42.41           C  
ATOM   2782  CD  PRO B 171      33.103  45.402  13.196  1.00 42.51           C  
ATOM   2783  N   ALA B 172      30.207  47.591  10.327  1.00 41.42           N  
ATOM   2784  CA  ALA B 172      29.669  47.682   8.961  1.00 40.95           C  
ATOM   2785  C   ALA B 172      30.374  46.826   7.902  1.00 40.57           C  
ATOM   2786  O   ALA B 172      29.854  45.775   7.519  1.00 40.52           O  
ATOM   2787  CB  ALA B 172      29.625  49.157   8.511  1.00 41.01           C  
ATOM   2788  N   HIS B 173      31.541  47.290   7.433  1.00 40.19           N  
ATOM   2789  CA  HIS B 173      32.317  46.599   6.385  1.00 39.82           C  
ATOM   2790  C   HIS B 173      32.512  45.100   6.621  1.00 39.43           C  
ATOM   2791  O   HIS B 173      32.319  44.300   5.702  1.00 39.38           O  
ATOM   2792  CB  HIS B 173      33.659  47.293   6.081  1.00 39.95           C  
ATOM   2793  CG  HIS B 173      34.426  47.728   7.295  1.00 40.50           C  
ATOM   2794  ND1 HIS B 173      34.862  49.026   7.471  1.00 40.97           N  
ATOM   2795  CD2 HIS B 173      34.842  47.042   8.387  1.00 40.72           C  
ATOM   2796  CE1 HIS B 173      35.513  49.119   8.618  1.00 41.04           C  
ATOM   2797  NE2 HIS B 173      35.511  47.929   9.196  1.00 40.78           N  
ATOM   2798  N   ARG B 174      32.873  44.720   7.847  1.00 38.94           N  
ATOM   2799  CA  ARG B 174      33.052  43.304   8.192  1.00 38.44           C  
ATOM   2800  C   ARG B 174      31.761  42.506   7.928  1.00 37.84           C  
ATOM   2801  O   ARG B 174      31.831  41.343   7.523  1.00 37.81           O  
ATOM   2802  CB  ARG B 174      33.502  43.116   9.649  1.00 38.69           C  
ATOM   2803  CG  ARG B 174      34.651  44.016  10.137  1.00 39.29           C  
ATOM   2804  CD  ARG B 174      36.065  43.511   9.822  1.00 39.70           C  
ATOM   2805  NE  ARG B 174      36.427  43.623   8.410  1.00 39.82           N  
ATOM   2806  CZ  ARG B 174      37.654  43.431   7.939  1.00 39.82           C  
ATOM   2807  NH1 ARG B 174      38.653  43.127   8.765  1.00 39.91           N  
ATOM   2808  NH2 ARG B 174      37.887  43.554   6.640  1.00 40.12           N  
ATOM   2809  N   GLN B 175      30.600  43.123   8.167  1.00 37.00           N  
ATOM   2810  CA  GLN B 175      29.312  42.495   7.844  1.00 36.09           C  
ATOM   2811  C   GLN B 175      29.022  42.687   6.367  1.00 35.84           C  
ATOM   2812  O   GLN B 175      28.383  41.853   5.744  1.00 35.90           O  
ATOM   2813  CB  GLN B 175      28.161  43.083   8.665  1.00 35.98           C  
ATOM   2814  CG  GLN B 175      28.086  42.581  10.105  1.00 35.63           C  
ATOM   2815  CD  GLN B 175      26.931  43.200  10.923  1.00 35.47           C  
ATOM   2816  OE1 GLN B 175      27.149  43.762  12.003  1.00 33.72           O  
ATOM   2817  NE2 GLN B 175      25.710  43.102  10.403  1.00 33.89           N  
ATOM   2818  N   GLU B 176      29.511  43.785   5.807  1.00 35.42           N  
ATOM   2819  CA  GLU B 176      29.233  44.125   4.417  1.00 34.93           C  
ATOM   2820  C   GLU B 176      29.954  43.169   3.463  1.00 34.58           C  
ATOM   2821  O   GLU B 176      29.427  42.808   2.406  1.00 34.57           O  
ATOM   2822  CB  GLU B 176      29.645  45.567   4.160  1.00 34.90           C  
ATOM   2823  CG  GLU B 176      28.865  46.270   3.086  1.00 35.17           C  
ATOM   2824  CD  GLU B 176      29.214  47.755   3.005  1.00 35.40           C  
ATOM   2825  OE1 GLU B 176      29.860  48.279   3.945  1.00 35.40           O  
ATOM   2826  OE2 GLU B 176      28.839  48.400   2.002  1.00 36.00           O  
ATOM   2827  N   ARG B 177      31.154  42.755   3.859  1.00 34.21           N  
ATOM   2828  CA  ARG B 177      31.967  41.848   3.053  1.00 33.69           C  
ATOM   2829  C   ARG B 177      31.599  40.393   3.303  1.00 33.33           C  
ATOM   2830  O   ARG B 177      31.817  39.546   2.435  1.00 33.42           O  
ATOM   2831  CB  ARG B 177      33.468  42.114   3.267  1.00 33.75           C  
ATOM   2832  CG  ARG B 177      33.875  43.529   2.820  1.00 33.45           C  
ATOM   2833  CD  ARG B 177      35.357  43.775   2.926  1.00 33.65           C  
ATOM   2834  NE  ARG B 177      35.615  45.156   3.332  1.00 33.24           N  
ATOM   2835  CZ  ARG B 177      36.785  45.607   3.770  1.00 32.96           C  
ATOM   2836  NH1 ARG B 177      37.824  44.789   3.851  1.00 33.07           N  
ATOM   2837  NH2 ARG B 177      36.910  46.875   4.131  1.00 32.62           N  
ATOM   2838  N   ILE B 178      31.044  40.106   4.483  1.00 32.67           N  
ATOM   2839  CA  ILE B 178      30.551  38.772   4.800  1.00 32.13           C  
ATOM   2840  C   ILE B 178      29.335  38.502   3.926  1.00 31.84           C  
ATOM   2841  O   ILE B 178      29.164  37.395   3.433  1.00 31.47           O  
ATOM   2842  CB  ILE B 178      30.291  38.564   6.331  1.00 32.05           C  
ATOM   2843  CG1 ILE B 178      31.629  38.339   7.051  1.00 31.95           C  
ATOM   2844  CG2 ILE B 178      29.450  37.320   6.603  1.00 31.62           C  
ATOM   2845  CD1 ILE B 178      31.504  37.982   8.536  1.00 32.51           C  
ATOM   2846  N   ILE B 179      28.537  39.539   3.694  1.00 32.02           N  
ATOM   2847  CA  ILE B 179      27.345  39.461   2.842  1.00 32.37           C  
ATOM   2848  C   ILE B 179      27.707  39.112   1.388  1.00 32.73           C  
ATOM   2849  O   ILE B 179      27.140  38.188   0.799  1.00 32.96           O  
ATOM   2850  CB  ILE B 179      26.517  40.795   2.903  1.00 32.44           C  
ATOM   2851  CG1 ILE B 179      25.805  40.914   4.255  1.00 32.36           C  
ATOM   2852  CG2 ILE B 179      25.490  40.889   1.756  1.00 31.82           C  
ATOM   2853  CD1 ILE B 179      25.269  42.306   4.583  1.00 31.97           C  
ATOM   2854  N   LYS B 180      28.661  39.834   0.817  1.00 32.95           N  
ATOM   2855  CA  LYS B 180      29.014  39.603  -0.575  1.00 33.16           C  
ATOM   2856  C   LYS B 180      29.552  38.188  -0.744  1.00 33.24           C  
ATOM   2857  O   LYS B 180      29.107  37.464  -1.623  1.00 33.22           O  
ATOM   2858  CB  LYS B 180      29.932  40.715  -1.172  1.00 33.13           C  
ATOM   2859  CG  LYS B 180      31.385  40.768  -0.665  1.00 33.11           C  
ATOM   2860  CD  LYS B 180      32.276  41.630  -1.579  1.00 33.13           C  
ATOM   2861  CE  LYS B 180      33.771  41.438  -1.293  1.00 32.86           C  
ATOM   2862  NZ  LYS B 180      34.667  42.189  -2.246  1.00 32.14           N  
ATOM   2863  N   GLN B 181      30.466  37.781   0.130  1.00 33.59           N  
ATOM   2864  CA  GLN B 181      30.998  36.429   0.082  1.00 33.90           C  
ATOM   2865  C   GLN B 181      29.858  35.394   0.136  1.00 34.31           C  
ATOM   2866  O   GLN B 181      29.753  34.527  -0.729  1.00 34.70           O  
ATOM   2867  CB  GLN B 181      31.976  36.225   1.220  1.00 33.96           C  
ATOM   2868  CG  GLN B 181      32.805  34.983   1.081  1.00 33.81           C  
ATOM   2869  CD  GLN B 181      33.653  34.977  -0.168  1.00 33.07           C  
ATOM   2870  OE1 GLN B 181      34.400  35.927  -0.462  1.00 32.38           O  
ATOM   2871  NE2 GLN B 181      33.553  33.881  -0.913  1.00 34.12           N  
ATOM   2872  N   LEU B 182      28.974  35.527   1.114  1.00 34.46           N  
ATOM   2873  CA  LEU B 182      27.813  34.640   1.240  1.00 34.64           C  
ATOM   2874  C   LEU B 182      26.938  34.583  -0.000  1.00 35.88           C  
ATOM   2875  O   LEU B 182      26.523  33.500  -0.406  1.00 36.17           O  
ATOM   2876  CB  LEU B 182      26.938  35.031   2.442  1.00 33.68           C  
ATOM   2877  CG  LEU B 182      27.552  34.754   3.805  1.00 30.90           C  
ATOM   2878  CD1 LEU B 182      26.721  35.371   4.932  1.00 28.74           C  
ATOM   2879  CD2 LEU B 182      27.743  33.260   3.996  1.00 26.72           C  
ATOM   2880  N   GLU B 183      26.646  35.726  -0.608  1.00 36.84           N  
ATOM   2881  CA  GLU B 183      25.721  35.703  -1.739  1.00 38.10           C  
ATOM   2882  C   GLU B 183      26.342  35.241  -3.057  1.00 38.89           C  
ATOM   2883  O   GLU B 183      25.629  34.851  -3.973  1.00 38.99           O  
ATOM   2884  CB  GLU B 183      24.945  37.022  -1.877  1.00 37.98           C  
ATOM   2885  CG  GLU B 183      25.754  38.247  -2.254  1.00 38.65           C  
ATOM   2886  CD  GLU B 183      24.970  39.514  -1.989  1.00 40.09           C  
ATOM   2887  OE1 GLU B 183      24.024  39.453  -1.164  1.00 40.12           O  
ATOM   2888  OE2 GLU B 183      25.284  40.558  -2.593  1.00 39.04           O  
ATOM   2889  N   GLN B 184      27.667  35.277  -3.147  1.00 40.10           N  
ATOM   2890  CA  GLN B 184      28.357  34.723  -4.309  1.00 41.54           C  
ATOM   2891  C   GLN B 184      28.305  33.193  -4.262  1.00 42.15           C  
ATOM   2892  O   GLN B 184      28.426  32.527  -5.283  1.00 42.08           O  
ATOM   2893  CB  GLN B 184      29.800  35.251  -4.415  1.00 41.56           C  
ATOM   2894  CG  GLN B 184      29.853  36.747  -4.757  1.00 42.23           C  
ATOM   2895  CD  GLN B 184      31.212  37.220  -5.274  1.00 42.31           C  
ATOM   2896  OE1 GLN B 184      32.223  37.156  -4.557  1.00 43.08           O  
ATOM   2897  NE2 GLN B 184      31.237  37.729  -6.520  1.00 42.12           N  
HETATM 2898  N   MSE B 185      28.085  32.644  -3.071  1.00 42.92           N  
HETATM 2899  CA  MSE B 185      28.016  31.201  -2.893  1.00 44.15           C  
HETATM 2900  C   MSE B 185      26.712  30.578  -3.428  1.00 43.16           C  
HETATM 2901  O   MSE B 185      25.629  31.128  -3.225  1.00 43.19           O  
HETATM 2902  CB  MSE B 185      28.252  30.868  -1.428  1.00 43.78           C  
HETATM 2903  CG  MSE B 185      29.606  31.355  -0.992  1.00 46.74           C  
HETATM 2904 SE   MSE B 185      30.003  31.053   0.870  1.00 47.87          SE  
HETATM 2905  CE  MSE B 185      30.363  29.107   0.800  1.00 46.82           C  
ATOM   2906  N   PRO B 186      26.822  29.426  -4.118  1.00 42.70           N  
ATOM   2907  CA  PRO B 186      25.700  28.755  -4.758  1.00 42.33           C  
ATOM   2908  C   PRO B 186      24.909  27.885  -3.793  1.00 42.18           C  
ATOM   2909  O   PRO B 186      24.525  26.775  -4.152  1.00 42.02           O  
ATOM   2910  CB  PRO B 186      26.394  27.860  -5.773  1.00 42.31           C  
ATOM   2911  CG  PRO B 186      27.642  27.461  -5.073  1.00 42.38           C  
ATOM   2912  CD  PRO B 186      28.080  28.686  -4.329  1.00 42.61           C  
ATOM   2913  N   PHE B 187      24.659  28.371  -2.586  1.00 41.99           N  
ATOM   2914  CA  PHE B 187      23.951  27.558  -1.600  1.00 42.03           C  
ATOM   2915  C   PHE B 187      22.804  28.277  -0.885  1.00 41.58           C  
ATOM   2916  O   PHE B 187      22.938  29.402  -0.374  1.00 41.76           O  
ATOM   2917  CB  PHE B 187      24.918  26.929  -0.576  1.00 42.57           C  
ATOM   2918  CG  PHE B 187      25.815  25.863  -1.147  1.00 43.25           C  
ATOM   2919  CD1 PHE B 187      27.192  26.037  -1.164  1.00 44.55           C  
ATOM   2920  CD2 PHE B 187      25.284  24.683  -1.663  1.00 43.84           C  
ATOM   2921  CE1 PHE B 187      28.032  25.049  -1.689  1.00 45.17           C  
ATOM   2922  CE2 PHE B 187      26.106  23.692  -2.178  1.00 44.83           C  
ATOM   2923  CZ  PHE B 187      27.489  23.873  -2.200  1.00 44.96           C  
ATOM   2924  N   GLU B 188      21.677  27.582  -0.841  1.00 40.61           N  
ATOM   2925  CA  GLU B 188      20.469  28.084  -0.230  1.00 39.34           C  
ATOM   2926  C   GLU B 188      20.749  28.648   1.134  1.00 38.79           C  
ATOM   2927  O   GLU B 188      20.337  29.733   1.435  1.00 39.07           O  
ATOM   2928  CB  GLU B 188      19.432  26.970  -0.142  1.00 39.12           C  
ATOM   2929  CG  GLU B 188      18.004  27.410  -0.144  1.00 37.21           C  
ATOM   2930  CD  GLU B 188      17.060  26.259  -0.475  1.00 35.94           C  
ATOM   2931  OE1 GLU B 188      17.072  25.809  -1.649  1.00 34.91           O  
ATOM   2932  OE2 GLU B 188      16.303  25.820   0.427  1.00 33.52           O  
ATOM   2933  N   ASN B 189      21.494  27.951   1.958  1.00 38.29           N  
ATOM   2934  CA  ASN B 189      21.659  28.451   3.328  1.00 37.74           C  
ATOM   2935  C   ASN B 189      22.388  29.779   3.437  1.00 37.77           C  
ATOM   2936  O   ASN B 189      21.990  30.630   4.224  1.00 37.69           O  
ATOM   2937  CB  ASN B 189      22.307  27.406   4.244  1.00 37.17           C  
ATOM   2938  CG  ASN B 189      21.306  26.411   4.805  1.00 36.58           C  
ATOM   2939  OD1 ASN B 189      20.449  26.751   5.623  1.00 36.19           O  
ATOM   2940  ND2 ASN B 189      21.458  25.153   4.417  1.00 38.16           N  
ATOM   2941  N   GLU B 190      23.442  29.938   2.640  1.00 37.40           N  
ATOM   2942  CA  GLU B 190      24.264  31.121   2.676  1.00 37.78           C  
ATOM   2943  C   GLU B 190      23.504  32.321   2.172  1.00 38.17           C  
ATOM   2944  O   GLU B 190      23.607  33.417   2.753  1.00 38.08           O  
ATOM   2945  CB  GLU B 190      25.552  30.903   1.876  1.00 38.09           C  
ATOM   2946  CG  GLU B 190      26.685  30.130   2.612  1.00 38.54           C  
ATOM   2947  CD  GLU B 190      26.476  28.618   2.779  1.00 39.22           C  
ATOM   2948  OE1 GLU B 190      25.395  28.101   2.458  1.00 40.16           O  
ATOM   2949  OE2 GLU B 190      27.415  27.938   3.249  1.00 40.90           O  
ATOM   2950  N   LYS B 191      22.747  32.133   1.085  1.00 37.85           N  
ATOM   2951  CA  LYS B 191      21.938  33.199   0.557  1.00 38.00           C  
ATOM   2952  C   LYS B 191      20.883  33.535   1.585  1.00 37.84           C  
ATOM   2953  O   LYS B 191      20.563  34.717   1.790  1.00 37.80           O  
ATOM   2954  CB  LYS B 191      21.261  32.798  -0.745  1.00 38.49           C  
ATOM   2955  CG  LYS B 191      22.185  32.319  -1.842  1.00 38.40           C  
ATOM   2956  CD  LYS B 191      21.385  31.910  -3.081  1.00 38.21           C  
ATOM   2957  CE  LYS B 191      22.328  31.444  -4.186  1.00 37.98           C  
ATOM   2958  NZ  LYS B 191      23.499  32.375  -4.343  1.00 37.50           N  
ATOM   2959  N   ARG B 192      20.330  32.515   2.250  1.00 37.62           N  
ATOM   2960  CA  ARG B 192      19.301  32.820   3.253  1.00 38.05           C  
ATOM   2961  C   ARG B 192      19.897  33.662   4.375  1.00 38.04           C  
ATOM   2962  O   ARG B 192      19.373  34.738   4.712  1.00 37.66           O  
ATOM   2963  CB  ARG B 192      18.519  31.608   3.752  1.00 37.40           C  
ATOM   2964  CG  ARG B 192      17.495  31.089   2.736  1.00 38.46           C  
ATOM   2965  CD  ARG B 192      16.812  29.800   3.249  1.00 39.52           C  
ATOM   2966  NE  ARG B 192      15.837  30.090   4.312  1.00 43.04           N  
ATOM   2967  CZ  ARG B 192      15.357  29.191   5.168  1.00 43.22           C  
ATOM   2968  NH1 ARG B 192      15.755  27.926   5.120  1.00 43.48           N  
ATOM   2969  NH2 ARG B 192      14.471  29.565   6.078  1.00 44.67           N  
ATOM   2970  N   ILE B 193      21.025  33.196   4.896  1.00 38.52           N  
ATOM   2971  CA  ILE B 193      21.754  33.970   5.882  1.00 38.98           C  
ATOM   2972  C   ILE B 193      22.078  35.384   5.362  1.00 39.37           C  
ATOM   2973  O   ILE B 193      21.933  36.356   6.093  1.00 39.45           O  
ATOM   2974  CB  ILE B 193      23.005  33.244   6.341  1.00 39.15           C  
ATOM   2975  CG1 ILE B 193      22.595  32.087   7.235  1.00 40.13           C  
ATOM   2976  CG2 ILE B 193      23.925  34.179   7.103  1.00 38.73           C  
ATOM   2977  CD1 ILE B 193      21.788  32.502   8.456  1.00 39.00           C  
ATOM   2978  N   ALA B 194      22.471  35.499   4.099  1.00 39.52           N  
ATOM   2979  CA  ALA B 194      22.836  36.787   3.563  1.00 40.01           C  
ATOM   2980  C   ALA B 194      21.685  37.799   3.591  1.00 40.12           C  
ATOM   2981  O   ALA B 194      21.930  38.987   3.714  1.00 40.31           O  
ATOM   2982  CB  ALA B 194      23.387  36.637   2.141  1.00 40.09           C  
ATOM   2983  N   SER B 195      20.441  37.339   3.456  1.00 39.88           N  
ATOM   2984  CA  SER B 195      19.304  38.252   3.396  1.00 39.53           C  
ATOM   2985  C   SER B 195      19.049  38.811   4.750  1.00 39.98           C  
ATOM   2986  O   SER B 195      18.915  40.040   4.930  1.00 39.44           O  
ATOM   2987  CB  SER B 195      18.052  37.521   2.969  1.00 39.45           C  
ATOM   2988  OG  SER B 195      18.153  37.183   1.621  1.00 39.77           O  
ATOM   2989  N   LEU B 196      18.958  37.874   5.682  1.00 40.34           N  
ATOM   2990  CA  LEU B 196      18.763  38.122   7.085  1.00 41.06           C  
ATOM   2991  C   LEU B 196      19.821  39.060   7.589  1.00 41.77           C  
ATOM   2992  O   LEU B 196      19.635  39.711   8.604  1.00 41.76           O  
ATOM   2993  CB  LEU B 196      18.827  36.791   7.883  1.00 41.07           C  
ATOM   2994  CG  LEU B 196      17.735  35.742   7.572  1.00 41.00           C  
ATOM   2995  CD1 LEU B 196      17.830  34.510   8.486  1.00 40.51           C  
ATOM   2996  CD2 LEU B 196      16.299  36.359   7.598  1.00 39.61           C  
HETATM 2997  N   MSE B 197      20.951  39.123   6.907  1.00 42.73           N  
HETATM 2998  CA  MSE B 197      21.973  40.051   7.354  1.00 44.09           C  
HETATM 2999  C   MSE B 197      21.660  41.491   6.923  1.00 42.98           C  
HETATM 3000  O   MSE B 197      22.411  42.095   6.180  1.00 42.77           O  
HETATM 3001  CB  MSE B 197      23.384  39.573   6.952  1.00 43.79           C  
HETATM 3002  CG  MSE B 197      23.876  38.459   7.844  1.00 47.05           C  
HETATM 3003 SE   MSE B 197      25.730  37.850   7.634  1.00 46.87          SE  
HETATM 3004  CE  MSE B 197      26.715  39.507   8.018  1.00 42.65           C  
ATOM   3005  N   LYS B 198      20.522  42.003   7.399  1.00 43.68           N  
ATOM   3006  CA  LYS B 198      20.049  43.381   7.120  1.00 43.63           C  
ATOM   3007  C   LYS B 198      19.625  44.148   8.375  1.00 43.67           C  
ATOM   3008  O   LYS B 198      18.449  44.461   8.565  1.00 43.86           O  
ATOM   3009  CB  LYS B 198      18.936  43.409   6.049  1.00 43.46           C  
ATOM   3010  CG  LYS B 198      19.442  43.661   4.612  1.00 43.96           C  
ATOM   3011  CD  LYS B 198      20.373  42.527   4.093  1.00 44.15           C  
ATOM   3012  CE  LYS B 198      21.036  42.876   2.761  1.00 43.32           C  
ATOM   3013  NZ  LYS B 198      22.057  41.871   2.367  1.00 42.58           N  
TER    3014      LYS B 198                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
