
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  131 ( 1004),  selected  131 , name 2ozn_B
# Molecule2: number of CA atoms  119 ( 1007),  selected  119 , name T0496_4_122.pdb
# PARAMETERS: 2ozn_B.T0496_4_122.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D  1498_B      -       -           -
LGA    K  1499_B      -       -           -
LGA    T  1500_B      -       -           -
LGA    N  1501_B      P       4          6.145
LGA    -       -      V       5           -
LGA    -       -      S       6           -
LGA    L  1502_B      V       7          1.401
LGA    G  1503_B      N       8          1.417
LGA    E  1504_B      E       9          1.156
LGA    L  1505_B      K      10          1.318
LGA    I  1506_B      K      11          1.320
LGA    N  1507_B      D      12          1.456
LGA    Q  1508_B      F      13          1.185
LGA    G  1509_B      V      14          1.335
LGA    K  1510_B      K      15          1.020
LGA    S  1511_B      W      16          0.983
LGA    L  1512_B      F      17          0.939
LGA    L  1513_B      L      18          1.397
LGA    D  1514_B      N      19          1.258
LGA    E  1515_B      N      20          0.954
LGA    S  1516_B      Y      21          1.926
LGA    V  1517_B      Q      22          1.918
LGA    E  1518_B      L      23          4.078
LGA    G  1519_B      K      24          4.736
LGA    F  1520_B      -       -           -
LGA    N  1521_B      -       -           -
LGA    V  1522_B      -       -           -
LGA    G  1523_B      -       -           -
LGA    E  1524_B      -       -           -
LGA    Y  1525_B      -       -           -
LGA    H  1526_B      Q      25          0.840
LGA    K  1527_B      R      26          1.257
LGA    G  1528_B      E      27          1.423
LGA    A  1529_B      C      28          1.508
LGA    K  1530_B      V      29          1.402
LGA    D  1531_B      W      30          1.551
LGA    G  1532_B      I      31          1.260
LGA    L  1533_B      L      32          0.527
LGA    T  1534_B      N      33          0.947
LGA    V  1535_B      Y      34          0.991
LGA    E  1536_B      L      35          0.513
LGA    I  1537_B      M      36          0.833
LGA    N  1538_B      S      37          1.178
LGA    K  1539_B      H      38          0.645
LGA    A  1540_B      D      39          1.641
LGA    E  1541_B      -       -           -
LGA    E  1542_B      -       -           -
LGA    V  1543_B      -       -           -
LGA    F  1544_B      -       -           -
LGA    N  1545_B      -       -           -
LGA    K  1546_B      -       -           -
LGA    E  1547_B      -       -           -
LGA    D  1548_B      -       -           -
LGA    A  1549_B      -       -           -
LGA    T  1550_B      -       -           -
LGA    E  1551_B      -       -           -
LGA    E  1552_B      -       -           -
LGA    E  1553_B      -       -           -
LGA    I  1554_B      -       -           -
LGA    N  1555_B      Q      40           #
LGA    L  1556_B      L      41           #
LGA    A  1557_B      M      42          3.623
LGA    K  1558_B      H      43          2.192
LGA    E  1559_B      K      44          1.951
LGA    S  1560_B      V      45          2.664
LGA    L  1561_B      H      46          5.778
LGA    E  1562_B      F      47          4.115
LGA    G  1563_B      V      48           #
LGA    A  1564_B      E      49           -
LGA    I  1565_B      H      50           -
LGA    -       -      A      51           -
LGA    -       -      K      52           -
LGA    -       -      Y      53           -
LGA    -       -      C      54           -
LGA    -       -      P      55           -
LGA    -       -      R      56           -
LGA    A  1566_B      G      57           #
LGA    R  1567_B      L      58          3.170
LGA    F  1568_B      -       -           -
LGA    N  1569_B      V      59           #
LGA    S  1570_B      M      60          2.024
LGA    L  1571_B      S      61          3.474
LGA    L  1572_B      A      62          3.174
LGA    I  1573_B      N      63          4.440
LGA    -       -      C      64           -
LGA    E  1574_B      V      65          3.698
LGA    E  1575_B      K      66          2.365
LGA    S  1576_B      D      67          5.286
LGA    T  1577_B      T      68          3.518
LGA    G  1578_B      P      69           #
LGA    D  1579_B      F      70           -
LGA    F  1580_B      H      71           -
LGA    N  1581_B      F      72           -
LGA    G  1582_B      F      73           -
LGA    N  1583_B      K      74           -
LGA    G  1584_B      Q      75           -
LGA    K  1585_B      N      76           -
LGA    I  1586_B      -       -           -
LGA    D  1587_B      -       -           -
LGA    I  1588_B      -       -           -
LGA    G  1589_B      -       -           -
LGA    D  1590_B      -       -           -
LGA    L  1591_B      -       -           -
LGA    A  1592_B      -       -           -
LGA    M  1593_B      -       -           -
LGA    V  1594_B      -       -           -
LGA    S  1595_B      -       -           -
LGA    K  1596_B      -       -           -
LGA    N  1597_B      -       -           -
LGA    I  1598_B      -       -           -
LGA    G  1599_B      -       -           -
LGA    S  1600_B      -       -           -
LGA    T  1601_B      -       -           -
LGA    T  1602_B      V      77           #
LGA    N  1603_B      M      78           #
LGA    T  1604_B      T      79          2.965
LGA    S  1605_B      -       -           -
LGA    L  1606_B      -       -           -
LGA    D  1607_B      T      80          2.167
LGA    L  1608_B      -       -           -
LGA    N  1609_B      D      81           #
LGA    K  1610_B      A      82          3.066
LGA    D  1611_B      E      83          3.144
LGA    G  1612_B      K      84          3.801
LGA    S  1613_B      S      85           -
LGA    I  1614_B      F      86           -
LGA    D  1615_B      H      87           -
LGA    E  1616_B      D      88           -
LGA    Y  1617_B      I      89           -
LGA    E  1618_B      R      90           -
LGA    I  1619_B      L      91           -
LGA    S  1620_B      N      92           -
LGA    F  1621_B      R      93           -
LGA    I  1622_B      D      94           -
LGA    N  1623_B      E      95           -
LGA    H  1624_B      D      96           -
LGA    R  1625_B      I      97           -
LGA    I  1626_B      Y      98           -
LGA    L  1627_B      I      99           -
LGA    N  1628_B      Q     100           -
LGA    -       -      L     101           -
LGA    -       -      N     102           -
LGA    -       -      F     103           -
LGA    -       -      K     104           -
LGA    -       -      S     105           -
LGA    -       -      S     106           -
LGA    -       -      F     107           -
LGA    -       -      Q     108           -
LGA    -       -      N     109           -
LGA    -       -      A     110           -
LGA    -       -      N     111           -
LGA    -       -      Y     112           -
LGA    -       -      V     113           -
LGA    -       -      A     114           -
LGA    -       -      V     115           -
LGA    -       -      L     116           -
LGA    -       -      E     117           -
LGA    -       -      E     118           -
LGA    -       -      N     119           -
LGA    -       -      P     120           -
LGA    -       -      Y     121           -
LGA    -       -      L     122           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  131  119    5.0     54    2.61    11.11     32.709     1.993

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.870727 * X  +   0.491541 * Y  +   0.014917 * Z  +  49.618263
  Y_new =   0.262657 * X  +   0.439203 * Y  +   0.859135 * Z  +   9.722503
  Z_new =   0.415748 * X  +   0.751989 * Y  +  -0.511532 * Z  +  91.260971 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.168136   -0.973457  [ DEG:   124.2251    -55.7749 ]
  Theta =  -0.428765   -2.712827  [ DEG:   -24.5664   -155.4336 ]
  Phi   =   2.848621   -0.292972  [ DEG:   163.2140    -16.7860 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ozn_B                                        
REMARK     2: T0496_4_122.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ozn_B.T0496_4_122.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  131  119   5.0   54   2.61   11.11  32.709
REMARK  ---------------------------------------------------------- 
MOLECULE 2ozn_B
HEADER    TOXIN                                   26-FEB-07   2OZN              
TITLE     THE COHESIN-DOCKERIN COMPLEX OF NAGJ AND NAGH FROM                    
TITLE    2 CLOSTRIDIUM PERFRINGENS                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: O-GLCNACASE NAGJ;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: COHESIN MODULE (RESIDUES 768-909);                         
COMPND   5 SYNONYM: BETA-HEXOSAMINIDASE, N-ACETYL-BETA-                         
COMPND   6 GLUCOSAMINIDASE, BETA-N-ACETYLHEXOSAMINIDASE,                        
COMPND   7 HEXOSAMINIDASE B, GH84;                                              
COMPND   8 ENGINEERED: YES;                                                     
COMPND   9 MOL_ID: 2;                                                           
COMPND  10 MOLECULE: HYALURONONGLUCOSAMINIDASE;                                 
COMPND  11 CHAIN: B;                                                            
COMPND  12 FRAGMENT: FIVAR-DOCKERIN MODULAR PAIR (RESIDUES 1498-1628);          
COMPND  13 SYNONYM: HYALURONIDASE, MU TOXIN;                                    
COMPND  14 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CLOSTRIDIUM PERFRINGENS;                        
SOURCE   3 STRAIN: ATCC 13124;                                                  
SOURCE   4 GENE: NAGJ;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   7 MOL_ID: 2;                                                           
SOURCE   8 ORGANISM_SCIENTIFIC: CLOSTRIDIUM PERFRINGENS;                        
SOURCE   9 STRAIN: STRAIN 13;                                                   
SOURCE  10 GENE: NAGH;                                                          
SOURCE  11 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  12 EXPRESSION_SYSTEM_STRAIN: BL21                                       
KEYWDS    EF HAND, TOXIN                                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.J.ADAMS,A.BORASTON,S.P.SMITH                                        
REVDAT   1   06-MAY-08 2OZN    0                                                
JRNL        AUTH   J.J.ADAMS,A.BORASTON,S.P.SMITH                               
JRNL        TITL   COHESIN AND DOCKERIN MEDIATED ASSEMBLIES OF THE              
JRNL        TITL 2 NAGH AND NANJ VIRULENCE FACTORS IN CLOSTRIDIUM               
JRNL        TITL 3 PERFRINGENS                                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2OZN A  768   909  UNP    Q0TR53   OGA_CLOP1      768    909             
DBREF  2OZN B 1498  1628  UNP    P26831   NAGH_CLOPE    1498   1628             
SEQRES   1 A  165  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  165  LEU VAL PRO ARG GLY SER HIS MET ALA SER LYS LEU LYS          
SEQRES   3 A  165  GLU ASN ALA GLU VAL THR GLY SER VAL SER LEU GLU ALA          
SEQRES   4 A  165  LEU GLU GLU VAL GLN VAL GLY GLU ASN LEU GLU VAL GLY          
SEQRES   5 A  165  VAL GLY ILE ASP GLU LEU VAL ASN ALA GLU ALA PHE ALA          
SEQRES   6 A  165  TYR ASP PHE THR LEU ASN TYR ASP GLU ASN ALA PHE GLU          
SEQRES   7 A  165  TYR VAL GLU ALA ILE SER ASP ASP GLY VAL PHE VAL ASN          
SEQRES   8 A  165  ALA LYS LYS ILE GLU ASP GLY LYS VAL ARG VAL LEU VAL          
SEQRES   9 A  165  SER SER LEU THR GLY GLU PRO LEU PRO ALA LYS GLU VAL          
SEQRES  10 A  165  LEU ALA LYS VAL VAL LEU ARG ALA GLU ALA LYS ALA GLU          
SEQRES  11 A  165  GLY SER ASN LEU SER VAL THR ASN SER SER VAL GLY ASP          
SEQRES  12 A  165  GLY GLU GLY LEU VAL HIS GLU ILE ALA GLY THR GLU LYS          
SEQRES  13 A  165  THR VAL ASN ILE ILE GLU GLY THR SER                          
SEQRES   1 B  140  MET ASP LYS THR ASN LEU GLY GLU LEU ILE ASN GLN GLY          
SEQRES   2 B  140  LYS SER LEU LEU ASP GLU SER VAL GLU GLY PHE ASN VAL          
SEQRES   3 B  140  GLY GLU TYR HIS LYS GLY ALA LYS ASP GLY LEU THR VAL          
SEQRES   4 B  140  GLU ILE ASN LYS ALA GLU GLU VAL PHE ASN LYS GLU ASP          
SEQRES   5 B  140  ALA THR GLU GLU GLU ILE ASN LEU ALA LYS GLU SER LEU          
SEQRES   6 B  140  GLU GLY ALA ILE ALA ARG PHE ASN SER LEU LEU ILE GLU          
SEQRES   7 B  140  GLU SER THR GLY ASP PHE ASN GLY ASN GLY LYS ILE ASP          
SEQRES   8 B  140  ILE GLY ASP LEU ALA MET VAL SER LYS ASN ILE GLY SER          
SEQRES   9 B  140  THR THR ASN THR SER LEU ASP LEU ASN LYS ASP GLY SER          
SEQRES  10 B  140  ILE ASP GLU TYR GLU ILE SER PHE ILE ASN HIS ARG ILE          
SEQRES  11 B  140  LEU ASN LEU GLU HIS HIS HIS HIS HIS HIS                      
HET     CL  A 403       1                                                       
HET     CA  B 401       1                                                       
HET     CA  B 402       1                                                       
HETNAM      CL CHLORIDE ION                                                     
HETNAM      CA CALCIUM ION                                                      
FORMUL   3   CL    CL 1-                                                        
FORMUL   4   CA    2(CA 2+)                                                     
FORMUL   6  HOH   *315(H2 O)                                                    
CRYST1   35.487   74.590   94.791  90.00  90.00  90.00 P 21 21 21    4          
ATOM    993  N   ASP B1498      42.573  19.368 109.513  1.00 33.01           N  
ATOM    994  CA  ASP B1498      42.753  19.466 108.029  1.00 32.32           C  
ATOM    995  C   ASP B1498      42.429  20.869 107.515  1.00 31.41           C  
ATOM    996  O   ASP B1498      41.297  21.352 107.630  1.00 31.91           O  
ATOM    997  CB  ASP B1498      41.898  18.422 107.303  1.00 32.99           C  
ATOM    998  CG  ASP B1498      41.988  18.529 105.793  1.00 34.16           C  
ATOM    999  OD1 ASP B1498      41.050  18.036 105.124  1.00 37.11           O  
ATOM   1000  OD2 ASP B1498      42.980  19.089 105.263  1.00 33.80           O  
ATOM   1001  N   LYS B1499      43.436  21.503 106.934  1.00 29.67           N  
ATOM   1002  CA  LYS B1499      43.295  22.872 106.440  1.00 28.07           C  
ATOM   1003  C   LYS B1499      43.486  22.999 104.933  1.00 26.55           C  
ATOM   1004  O   LYS B1499      43.576  24.114 104.410  1.00 25.32           O  
ATOM   1005  CB  LYS B1499      44.274  23.788 107.173  1.00 28.47           C  
ATOM   1006  CG  LYS B1499      43.984  23.939 108.637  1.00 30.36           C  
ATOM   1007  CD  LYS B1499      45.156  24.580 109.336  1.00 32.83           C  
ATOM   1008  CE  LYS B1499      44.780  25.032 110.728  1.00 32.57           C  
ATOM   1009  NZ  LYS B1499      46.002  25.461 111.443  1.00 34.43           N  
ATOM   1010  N   THR B1500      43.547  21.871 104.227  1.00 24.83           N  
ATOM   1011  CA  THR B1500      43.762  21.891 102.780  1.00 24.00           C  
ATOM   1012  C   THR B1500      42.796  22.840 102.052  1.00 22.05           C  
ATOM   1013  O   THR B1500      43.237  23.705 101.298  1.00 22.11           O  
ATOM   1014  CB  THR B1500      43.701  20.481 102.165  1.00 24.29           C  
ATOM   1015  OG1 THR B1500      44.645  19.640 102.847  1.00 26.12           O  
ATOM   1016  CG2 THR B1500      44.044  20.515 100.674  1.00 24.96           C  
ATOM   1017  N   ASN B1501      41.498  22.697 102.293  1.00 20.95           N  
ATOM   1018  CA  ASN B1501      40.516  23.497 101.543  1.00 20.12           C  
ATOM   1019  C   ASN B1501      40.573  24.975 101.923  1.00 19.50           C  
ATOM   1020  O   ASN B1501      40.403  25.856 101.060  1.00 18.76           O  
ATOM   1021  CB  ASN B1501      39.086  22.948 101.697  1.00 20.39           C  
ATOM   1022  CG  ASN B1501      38.941  21.539 101.140  1.00 21.12           C  
ATOM   1023  OD1 ASN B1501      39.673  21.120 100.229  1.00 20.72           O  
ATOM   1024  ND2 ASN B1501      38.003  20.796 101.696  1.00 21.12           N  
ATOM   1025  N   LEU B1502      40.841  25.244 103.203  1.00 19.48           N  
ATOM   1026  CA  LEU B1502      41.024  26.631 103.648  1.00 19.54           C  
ATOM   1027  C   LEU B1502      42.210  27.268 102.913  1.00 19.03           C  
ATOM   1028  O   LEU B1502      42.112  28.410 102.398  1.00 18.02           O  
ATOM   1029  CB  LEU B1502      41.196  26.696 105.174  1.00 19.73           C  
ATOM   1030  CG  LEU B1502      41.450  28.093 105.770  1.00 20.43           C  
ATOM   1031  CD1 LEU B1502      40.383  29.114 105.383  1.00 20.46           C  
ATOM   1032  CD2 LEU B1502      41.551  27.993 107.291  1.00 20.43           C  
ATOM   1033  N   GLY B1503      43.318  26.527 102.824  1.00 17.77           N  
ATOM   1034  CA  GLY B1503      44.496  26.995 102.086  1.00 17.97           C  
ATOM   1035  C   GLY B1503      44.229  27.180 100.606  1.00 16.99           C  
ATOM   1036  O   GLY B1503      44.731  28.107  99.974  1.00 17.52           O  
ATOM   1037  N   GLU B1504      43.456  26.268 100.030  1.00 17.40           N  
ATOM   1038  CA  GLU B1504      43.051  26.415  98.642  1.00 16.66           C  
ATOM   1039  C   GLU B1504      42.236  27.692  98.401  1.00 16.45           C  
ATOM   1040  O   GLU B1504      42.445  28.395  97.400  1.00 16.55           O  
ATOM   1041  CB  GLU B1504      42.273  25.174  98.196  1.00 16.68           C  
ATOM   1042  CG  GLU B1504      43.187  23.965  98.003  1.00 17.34           C  
ATOM   1043  CD  GLU B1504      42.441  22.649  97.904  1.00 16.83           C  
ATOM   1044  OE1 GLU B1504      41.226  22.616  98.198  1.00 16.29           O  
ATOM   1045  OE2 GLU B1504      43.113  21.645  97.588  1.00 19.08           O  
ATOM   1046  N   LEU B1505      41.311  27.996  99.306  1.00 16.01           N  
ATOM   1047  CA  LEU B1505      40.535  29.248  99.192  1.00 16.26           C  
ATOM   1048  C   LEU B1505      41.436  30.489  99.356  1.00 15.43           C  
ATOM   1049  O   LEU B1505      41.266  31.486  98.649  1.00 15.42           O  
ATOM   1050  CB  LEU B1505      39.362  29.262 100.176  1.00 16.24           C  
ATOM   1051  CG  LEU B1505      38.257  28.225  99.933  1.00 18.56           C  
ATOM   1052  CD1 LEU B1505      37.229  28.277 101.076  1.00 18.22           C  
ATOM   1053  CD2 LEU B1505      37.576  28.431  98.585  1.00 19.71           C  
ATOM   1054  N   ILE B1506      42.386  30.423 100.290  1.00 16.36           N  
ATOM   1055  CA  ILE B1506      43.342  31.525 100.478  1.00 16.04           C  
ATOM   1056  C   ILE B1506      44.102  31.766  99.167  1.00 16.35           C  
ATOM   1057  O   ILE B1506      44.255  32.909  98.720  1.00 16.65           O  
ATOM   1058  CB  ILE B1506      44.311  31.222 101.652  1.00 15.92           C  
ATOM   1059  CG1 ILE B1506      43.552  31.294 102.970  1.00 16.28           C  
ATOM   1060  CG2 ILE B1506      45.504  32.209 101.641  1.00 16.91           C  
ATOM   1061  CD1 ILE B1506      44.357  30.789 104.197  1.00 15.67           C  
ATOM   1062  N   ASN B1507      44.551  30.691  98.526  1.00 16.79           N  
ATOM   1063  CA  ASN B1507      45.283  30.816  97.278  1.00 17.36           C  
ATOM   1064  C   ASN B1507      44.409  31.335  96.128  1.00 17.16           C  
ATOM   1065  O   ASN B1507      44.867  32.093  95.287  1.00 16.52           O  
ATOM   1066  CB  ASN B1507      45.986  29.498  96.931  1.00 19.47           C  
ATOM   1067  CG  ASN B1507      47.171  29.215  97.867  1.00 21.90           C  
ATOM   1068  OD1 ASN B1507      47.613  30.094  98.613  1.00 25.67           O  
ATOM   1069  ND2 ASN B1507      47.693  27.993  97.815  1.00 25.69           N  
ATOM   1070  N   GLN B1508      43.136  30.940  96.114  1.00 16.21           N  
ATOM   1071  CA  GLN B1508      42.187  31.531  95.172  1.00 15.47           C  
ATOM   1072  C   GLN B1508      42.109  33.038  95.368  1.00 15.99           C  
ATOM   1073  O   GLN B1508      42.117  33.800  94.402  1.00 15.88           O  
ATOM   1074  CB  GLN B1508      40.786  30.933  95.383  1.00 15.96           C  
ATOM   1075  CG  GLN B1508      40.549  29.611  94.664  1.00 15.92           C  
ATOM   1076  CD  GLN B1508      39.097  29.176  94.780  1.00 15.52           C  
ATOM   1077  OE1 GLN B1508      38.182  30.006  94.874  1.00 17.17           O  
ATOM   1078  NE2 GLN B1508      38.878  27.876  94.805  1.00 18.04           N  
ATOM   1079  N   GLY B1509      42.018  33.466  96.617  1.00 15.57           N  
ATOM   1080  CA  GLY B1509      41.929  34.895  96.914  1.00 15.96           C  
ATOM   1081  C   GLY B1509      43.148  35.679  96.480  1.00 16.21           C  
ATOM   1082  O   GLY B1509      43.021  36.754  95.875  1.00 16.49           O  
ATOM   1083  N   LYS B1510      44.327  35.129  96.772  1.00 17.07           N  
ATOM   1084  CA  LYS B1510      45.589  35.762  96.386  1.00 17.03           C  
ATOM   1085  C   LYS B1510      45.715  35.825  94.876  1.00 17.40           C  
ATOM   1086  O   LYS B1510      46.167  36.816  94.335  1.00 17.27           O  
ATOM   1087  CB  LYS B1510      46.786  35.036  97.025  1.00 16.98           C  
ATOM   1088  CG  LYS B1510      46.852  35.233  98.521  1.00 17.01           C  
ATOM   1089  CD  LYS B1510      48.044  34.523  99.144  1.00 18.29           C  
ATOM   1090  CE  LYS B1510      48.035  34.748 100.614  1.00 20.62           C  
ATOM   1091  NZ  LYS B1510      49.096  33.949 101.292  1.00 22.86           N  
ATOM   1092  N   SER B1511      45.295  34.774  94.179  1.00 16.98           N  
ATOM   1093  CA  SER B1511      45.306  34.813  92.733  1.00 18.22           C  
ATOM   1094  C   SER B1511      44.403  35.926  92.178  1.00 17.87           C  
ATOM   1095  O   SER B1511      44.794  36.636  91.249  1.00 18.94           O  
ATOM   1096  CB  SER B1511      44.938  33.456  92.160  1.00 19.08           C  
ATOM   1097  OG  SER B1511      45.942  32.521  92.521  1.00 22.70           O  
ATOM   1098  N   LEU B1512      43.216  36.093  92.762  1.00 17.89           N  
ATOM   1099  CA  LEU B1512      42.338  37.193  92.366  1.00 17.88           C  
ATOM   1100  C   LEU B1512      43.016  38.543  92.543  1.00 18.36           C  
ATOM   1101  O   LEU B1512      42.901  39.399  91.677  1.00 18.25           O  
ATOM   1102  CB  LEU B1512      41.047  37.176  93.178  1.00 17.77           C  
ATOM   1103  CG  LEU B1512      39.984  36.173  92.746  1.00 17.96           C  
ATOM   1104  CD1 LEU B1512      38.897  36.085  93.839  1.00 16.84           C  
ATOM   1105  CD2 LEU B1512      39.367  36.540  91.397  1.00 17.82           C  
ATOM   1106  N   LEU B1513      43.698  38.730  93.669  1.00 18.44           N  
ATOM   1107  CA  LEU B1513      44.457  39.973  93.902  1.00 19.63           C  
ATOM   1108  C   LEU B1513      45.560  40.182  92.880  1.00 21.03           C  
ATOM   1109  O   LEU B1513      45.731  41.302  92.360  1.00 21.37           O  
ATOM   1110  CB  LEU B1513      45.072  39.980  95.303  1.00 19.81           C  
ATOM   1111  CG  LEU B1513      44.099  40.175  96.453  1.00 18.99           C  
ATOM   1112  CD1 LEU B1513      44.837  40.028  97.781  1.00 20.58           C  
ATOM   1113  CD2 LEU B1513      43.421  41.556  96.341  1.00 20.05           C  
ATOM   1114  N   ASP B1514      46.323  39.122  92.600  1.00 21.57           N  
ATOM   1115  CA  ASP B1514      47.450  39.189  91.664  1.00 23.58           C  
ATOM   1116  C   ASP B1514      47.013  39.652  90.275  1.00 23.59           C  
ATOM   1117  O   ASP B1514      47.769  40.333  89.588  1.00 24.64           O  
ATOM   1118  CB  ASP B1514      48.113  37.808  91.489  1.00 24.47           C  
ATOM   1119  CG  ASP B1514      48.862  37.329  92.714  1.00 27.78           C  
ATOM   1120  OD1 ASP B1514      49.188  38.137  93.609  1.00 27.77           O  
ATOM   1121  OD2 ASP B1514      49.139  36.103  92.776  1.00 31.13           O  
ATOM   1122  N   GLU B1515      45.805  39.252  89.877  1.00 23.90           N  
ATOM   1123  CA  GLU B1515      45.312  39.373  88.514  1.00 24.99           C  
ATOM   1124  C   GLU B1515      44.438  40.602  88.260  1.00 23.72           C  
ATOM   1125  O   GLU B1515      44.071  40.867  87.113  1.00 25.04           O  
ATOM   1126  CB  GLU B1515      44.492  38.127  88.163  1.00 25.06           C  
ATOM   1127  CG  GLU B1515      45.287  36.831  88.114  1.00 27.83           C  
ATOM   1128  CD  GLU B1515      44.398  35.592  87.996  1.00 28.41           C  
ATOM   1129  OE1 GLU B1515      43.187  35.736  87.708  1.00 34.96           O  
ATOM   1130  OE2 GLU B1515      44.916  34.469  88.196  1.00 34.41           O  
ATOM   1131  N   SER B1516      44.114  41.342  89.320  1.00 22.60           N  
ATOM   1132  CA  SER B1516      43.075  42.379  89.256  1.00 21.91           C  
ATOM   1133  C   SER B1516      43.632  43.794  89.376  1.00 21.29           C  
ATOM   1134  O   SER B1516      44.651  44.030  90.015  1.00 21.36           O  
ATOM   1135  CB  SER B1516      42.049  42.160  90.375  1.00 22.13           C  
ATOM   1136  OG  SER B1516      42.691  42.204  91.641  1.00 23.98           O  
ATOM   1137  N   VAL B1517      42.919  44.738  88.770  1.00 21.92           N  
ATOM   1138  CA  VAL B1517      43.265  46.138  88.905  1.00 22.34           C  
ATOM   1139  C   VAL B1517      41.977  46.917  89.168  1.00 21.21           C  
ATOM   1140  O   VAL B1517      40.903  46.534  88.679  1.00 20.89           O  
ATOM   1141  CB  VAL B1517      44.033  46.661  87.667  1.00 23.38           C  
ATOM   1142  CG1 VAL B1517      43.187  46.522  86.406  1.00 24.50           C  
ATOM   1143  CG2 VAL B1517      44.522  48.094  87.879  1.00 25.23           C  
ATOM   1144  N   GLU B1518      42.116  47.969  89.972  1.00 21.54           N  
ATOM   1145  CA  GLU B1518      41.003  48.847  90.340  1.00 21.31           C  
ATOM   1146  C   GLU B1518      40.961  50.054  89.432  1.00 21.39           C  
ATOM   1147  O   GLU B1518      41.997  50.596  89.061  1.00 22.05           O  
ATOM   1148  CB  GLU B1518      41.147  49.321  91.783  1.00 21.67           C  
ATOM   1149  CG  GLU B1518      40.886  48.235  92.817  1.00 21.39           C  
ATOM   1150  CD  GLU B1518      41.010  48.753  94.227  1.00 23.09           C  
ATOM   1151  OE1 GLU B1518      41.339  49.951  94.401  1.00 22.99           O  
ATOM   1152  OE2 GLU B1518      40.750  47.974  95.156  1.00 24.19           O  
ATOM   1153  N   GLY B1519      39.755  50.478  89.079  1.00 21.03           N  
ATOM   1154  CA  GLY B1519      39.608  51.615  88.180  1.00 21.24           C  
ATOM   1155  C   GLY B1519      38.165  51.822  87.800  1.00 21.16           C  
ATOM   1156  O   GLY B1519      37.259  51.341  88.488  1.00 21.40           O  
ATOM   1157  N   PHE B1520      37.956  52.537  86.697  1.00 22.25           N  
ATOM   1158  CA  PHE B1520      36.612  52.896  86.266  1.00 23.16           C  
ATOM   1159  C   PHE B1520      36.198  52.142  84.997  1.00 23.58           C  
ATOM   1160  O   PHE B1520      35.052  52.247  84.558  1.00 24.17           O  
ATOM   1161  CB  PHE B1520      36.520  54.419  86.002  1.00 22.95           C  
ATOM   1162  CG  PHE B1520      36.332  55.279  87.238  1.00 24.03           C  
ATOM   1163  CD1 PHE B1520      35.418  54.944  88.235  1.00 24.72           C  
ATOM   1164  CD2 PHE B1520      37.004  56.498  87.352  1.00 25.89           C  
ATOM   1165  CE1 PHE B1520      35.227  55.764  89.356  1.00 25.74           C  
ATOM   1166  CE2 PHE B1520      36.806  57.325  88.483  1.00 26.05           C  
ATOM   1167  CZ  PHE B1520      35.923  56.956  89.475  1.00 25.06           C  
ATOM   1168  N   ASN B1521      37.134  51.391  84.414  1.00 24.21           N  
ATOM   1169  CA  ASN B1521      36.922  50.752  83.116  1.00 24.63           C  
ATOM   1170  C   ASN B1521      36.407  49.319  83.201  1.00 24.50           C  
ATOM   1171  O   ASN B1521      36.581  48.636  84.218  1.00 23.99           O  
ATOM   1172  CB  ASN B1521      38.202  50.827  82.268  1.00 25.61           C  
ATOM   1173  CG  ASN B1521      38.709  52.261  82.099  1.00 27.34           C  
ATOM   1174  OD1 ASN B1521      37.952  53.173  81.771  1.00 30.86           O  
ATOM   1175  ND2 ASN B1521      39.992  52.457  82.340  1.00 29.85           N  
ATOM   1176  N   VAL B1522      35.749  48.881  82.131  1.00 24.21           N  
ATOM   1177  CA  VAL B1522      35.235  47.507  82.020  1.00 24.08           C  
ATOM   1178  C   VAL B1522      36.393  46.515  82.219  1.00 23.81           C  
ATOM   1179  O   VAL B1522      37.464  46.665  81.622  1.00 24.27           O  
ATOM   1180  CB  VAL B1522      34.492  47.295  80.659  1.00 24.61           C  
ATOM   1181  CG1 VAL B1522      34.054  45.847  80.485  1.00 24.38           C  
ATOM   1182  CG2 VAL B1522      33.284  48.205  80.579  1.00 25.06           C  
ATOM   1183  N   GLY B1523      36.188  45.538  83.101  1.00 22.83           N  
ATOM   1184  CA  GLY B1523      37.206  44.534  83.402  1.00 22.25           C  
ATOM   1185  C   GLY B1523      38.024  44.875  84.630  1.00 22.14           C  
ATOM   1186  O   GLY B1523      38.756  44.035  85.155  1.00 22.27           O  
ATOM   1187  N   GLU B1524      37.927  46.129  85.068  1.00 20.33           N  
ATOM   1188  CA  GLU B1524      38.521  46.557  86.334  1.00 20.96           C  
ATOM   1189  C   GLU B1524      37.522  46.386  87.486  1.00 19.13           C  
ATOM   1190  O   GLU B1524      36.365  46.045  87.267  1.00 19.47           O  
ATOM   1191  CB  GLU B1524      38.995  48.016  86.233  1.00 20.82           C  
ATOM   1192  CG  GLU B1524      40.153  48.234  85.240  1.00 22.90           C  
ATOM   1193  CD  GLU B1524      40.646  49.666  85.213  1.00 24.19           C  
ATOM   1194  OE1 GLU B1524      39.815  50.578  85.115  1.00 25.67           O  
ATOM   1195  OE2 GLU B1524      41.879  49.883  85.278  1.00 29.10           O  
ATOM   1196  N   TYR B1525      37.983  46.623  88.713  1.00 19.16           N  
ATOM   1197  CA  TYR B1525      37.154  46.491  89.903  1.00 18.46           C  
ATOM   1198  C   TYR B1525      36.979  47.853  90.573  1.00 17.69           C  
ATOM   1199  O   TYR B1525      37.851  48.720  90.494  1.00 18.00           O  
ATOM   1200  CB  TYR B1525      37.781  45.483  90.884  1.00 18.64           C  
ATOM   1201  CG  TYR B1525      37.763  44.060  90.364  1.00 18.71           C  
ATOM   1202  CD1 TYR B1525      36.815  43.142  90.815  1.00 18.50           C  
ATOM   1203  CD2 TYR B1525      38.695  43.644  89.403  1.00 18.26           C  
ATOM   1204  CE1 TYR B1525      36.792  41.843  90.321  1.00 19.93           C  
ATOM   1205  CE2 TYR B1525      38.674  42.363  88.900  1.00 19.90           C  
ATOM   1206  CZ  TYR B1525      37.738  41.467  89.362  1.00 19.68           C  
ATOM   1207  OH  TYR B1525      37.739  40.186  88.858  1.00 22.25           O  
ATOM   1208  N   HIS B1526      35.842  48.059  91.218  1.00 18.38           N  
ATOM   1209  CA  HIS B1526      35.613  49.311  91.940  1.00 17.55           C  
ATOM   1210  C   HIS B1526      36.643  49.524  93.026  1.00 18.17           C  
ATOM   1211  O   HIS B1526      37.035  48.584  93.729  1.00 17.72           O  
ATOM   1212  CB  HIS B1526      34.204  49.337  92.554  1.00 17.67           C  
ATOM   1213  CG  HIS B1526      33.114  49.278  91.535  1.00 17.29           C  
ATOM   1214  ND1 HIS B1526      32.762  50.364  90.758  1.00 18.12           N  
ATOM   1215  CD2 HIS B1526      32.294  48.267  91.164  1.00 16.93           C  
ATOM   1216  CE1 HIS B1526      31.786  50.014  89.938  1.00 18.19           C  
ATOM   1217  NE2 HIS B1526      31.484  48.749  90.165  1.00 17.09           N  
ATOM   1218  N   LYS B1527      37.068  50.777  93.156  1.00 18.70           N  
ATOM   1219  CA  LYS B1527      37.956  51.207  94.239  1.00 20.91           C  
ATOM   1220  C   LYS B1527      37.558  50.575  95.570  1.00 20.62           C  
ATOM   1221  O   LYS B1527      36.398  50.617  95.972  1.00 19.92           O  
ATOM   1222  CB  LYS B1527      37.936  52.736  94.336  1.00 21.36           C  
ATOM   1223  CG  LYS B1527      38.690  53.338  95.518  1.00 24.68           C  
ATOM   1224  CD  LYS B1527      38.253  54.799  95.779  1.00 24.71           C  
ATOM   1225  CE  LYS B1527      36.780  54.921  96.208  1.00 28.85           C  
ATOM   1226  NZ  LYS B1527      36.428  56.278  96.732  1.00 29.65           N  
ATOM   1227  N   GLY B1528      38.536  49.978  96.245  1.00 20.59           N  
ATOM   1228  CA  GLY B1528      38.308  49.353  97.532  1.00 21.17           C  
ATOM   1229  C   GLY B1528      38.148  47.839  97.505  1.00 20.63           C  
ATOM   1230  O   GLY B1528      38.289  47.180  98.541  1.00 21.82           O  
ATOM   1231  N   ALA B1529      37.809  47.291  96.334  1.00 19.47           N  
ATOM   1232  CA  ALA B1529      37.584  45.851  96.199  1.00 18.67           C  
ATOM   1233  C   ALA B1529      38.788  45.033  96.669  1.00 17.92           C  
ATOM   1234  O   ALA B1529      38.631  44.052  97.403  1.00 17.99           O  
ATOM   1235  CB  ALA B1529      37.225  45.489  94.755  1.00 19.27           C  
ATOM   1236  N   LYS B1530      39.982  45.437  96.241  1.00 17.87           N  
ATOM   1237  CA  LYS B1530      41.200  44.705  96.597  1.00 18.08           C  
ATOM   1238  C   LYS B1530      41.525  44.824  98.091  1.00 17.73           C  
ATOM   1239  O   LYS B1530      41.892  43.827  98.712  1.00 17.79           O  
ATOM   1240  CB  LYS B1530      42.385  45.153  95.735  1.00 17.41           C  
ATOM   1241  CG  LYS B1530      42.233  44.762  94.263  1.00 16.96           C  
ATOM   1242  CD  LYS B1530      43.492  45.049  93.438  1.00 18.74           C  
ATOM   1243  CE  LYS B1530      44.579  44.014  93.721  1.00 19.38           C  
ATOM   1244  NZ  LYS B1530      45.697  44.191  92.754  1.00 21.84           N  
ATOM   1245  N   ASP B1531      41.392  46.021  98.677  1.00 18.11           N  
ATOM   1246  CA  ASP B1531      41.557  46.195 100.135  1.00 18.92           C  
ATOM   1247  C   ASP B1531      40.620  45.278 100.943  1.00 17.61           C  
ATOM   1248  O   ASP B1531      41.059  44.597 101.874  1.00 17.48           O  
ATOM   1249  CB  ASP B1531      41.323  47.667 100.542  1.00 20.25           C  
ATOM   1250  CG  ASP B1531      41.638  47.948 102.018  1.00 25.11           C  
ATOM   1251  OD1 ASP B1531      42.822  47.859 102.430  1.00 28.97           O  
ATOM   1252  OD2 ASP B1531      40.704  48.311 102.767  1.00 30.78           O  
ATOM   1253  N   GLY B1532      39.334  45.267 100.568  1.00 17.65           N  
ATOM   1254  CA  GLY B1532      38.346  44.442 101.227  1.00 17.48           C  
ATOM   1255  C   GLY B1532      38.687  42.968 101.204  1.00 17.14           C  
ATOM   1256  O   GLY B1532      38.558  42.288 102.218  1.00 17.93           O  
ATOM   1257  N   LEU B1533      39.106  42.472 100.036  1.00 16.30           N  
ATOM   1258  CA  LEU B1533      39.465  41.062  99.889  1.00 15.38           C  
ATOM   1259  C   LEU B1533      40.712  40.753 100.724  1.00 15.16           C  
ATOM   1260  O   LEU B1533      40.779  39.730 101.388  1.00 15.37           O  
ATOM   1261  CB  LEU B1533      39.682  40.690  98.411  1.00 15.16           C  
ATOM   1262  CG  LEU B1533      40.091  39.230  98.151  1.00 15.56           C  
ATOM   1263  CD1 LEU B1533      39.072  38.247  98.744  1.00 17.07           C  
ATOM   1264  CD2 LEU B1533      40.248  39.022  96.658  1.00 16.21           C  
ATOM   1265  N   THR B1534      41.657  41.691 100.745  1.00 15.24           N  
ATOM   1266  CA  THR B1534      42.890  41.523 101.541  1.00 15.26           C  
ATOM   1267  C   THR B1534      42.594  41.349 103.026  1.00 15.81           C  
ATOM   1268  O   THR B1534      43.146  40.470 103.662  1.00 15.03           O  
ATOM   1269  CB  THR B1534      43.873  42.702 101.313  1.00 15.59           C  
ATOM   1270  OG1 THR B1534      44.196  42.781  99.917  1.00 15.10           O  
ATOM   1271  CG2 THR B1534      45.156  42.561 102.152  1.00 16.75           C  
ATOM   1272  N   VAL B1535      41.716  42.186 103.566  1.00 15.64           N  
ATOM   1273  CA  VAL B1535      41.306  42.065 104.968  1.00 17.17           C  
ATOM   1274  C   VAL B1535      40.776  40.648 105.240  1.00 17.22           C  
ATOM   1275  O   VAL B1535      41.124  40.025 106.240  1.00 17.81           O  
ATOM   1276  CB  VAL B1535      40.236  43.123 105.328  1.00 17.24           C  
ATOM   1277  CG1 VAL B1535      39.598  42.791 106.691  1.00 19.40           C  
ATOM   1278  CG2 VAL B1535      40.850  44.508 105.326  1.00 19.26           C  
ATOM   1279  N   GLU B1536      39.969  40.127 104.321  1.00 17.59           N  
ATOM   1280  CA  GLU B1536      39.380  38.806 104.523  1.00 17.36           C  
ATOM   1281  C   GLU B1536      40.370  37.663 104.341  1.00 16.81           C  
ATOM   1282  O   GLU B1536      40.284  36.653 105.027  1.00 16.88           O  
ATOM   1283  CB  GLU B1536      38.134  38.642 103.659  1.00 19.19           C  
ATOM   1284  CG  GLU B1536      36.982  39.559 104.116  1.00 21.07           C  
ATOM   1285  CD  GLU B1536      36.447  39.197 105.506  1.00 26.14           C  
ATOM   1286  OE1 GLU B1536      36.318  37.995 105.818  1.00 25.55           O  
ATOM   1287  OE2 GLU B1536      36.161  40.124 106.296  1.00 30.43           O  
ATOM   1288  N   ILE B1537      41.302  37.817 103.400  1.00 16.11           N  
ATOM   1289  CA  ILE B1537      42.335  36.810 103.244  1.00 16.06           C  
ATOM   1290  C   ILE B1537      43.168  36.733 104.517  1.00 15.88           C  
ATOM   1291  O   ILE B1537      43.470  35.647 104.987  1.00 15.78           O  
ATOM   1292  CB  ILE B1537      43.214  37.066 102.005  1.00 15.65           C  
ATOM   1293  CG1 ILE B1537      42.407  36.822 100.727  1.00 15.78           C  
ATOM   1294  CG2 ILE B1537      44.448  36.157 102.037  1.00 16.42           C  
ATOM   1295  CD1 ILE B1537      43.093  37.432  99.466  1.00 15.37           C  
ATOM   1296  N   ASN B1538      43.505  37.886 105.094  1.00 15.73           N  
ATOM   1297  CA  ASN B1538      44.281  37.890 106.326  1.00 16.22           C  
ATOM   1298  C   ASN B1538      43.532  37.219 107.460  1.00 17.61           C  
ATOM   1299  O   ASN B1538      44.135  36.475 108.228  1.00 18.00           O  
ATOM   1300  CB  ASN B1538      44.670  39.315 106.699  1.00 15.93           C  
ATOM   1301  CG  ASN B1538      45.750  39.864 105.792  1.00 15.93           C  
ATOM   1302  OD1 ASN B1538      46.425  39.113 105.065  1.00 17.95           O  
ATOM   1303  ND2 ASN B1538      45.936  41.198 105.842  1.00 15.41           N  
ATOM   1304  N   LYS B1539      42.224  37.444 107.563  1.00 19.02           N  
ATOM   1305  CA  LYS B1539      41.436  36.739 108.591  1.00 20.30           C  
ATOM   1306  C   LYS B1539      41.565  35.233 108.416  1.00 20.87           C  
ATOM   1307  O   LYS B1539      41.799  34.491 109.378  1.00 20.82           O  
ATOM   1308  CB  LYS B1539      39.953  37.141 108.557  1.00 20.54           C  
ATOM   1309  CG  LYS B1539      39.654  38.506 109.136  1.00 22.35           C  
ATOM   1310  CD  LYS B1539      38.149  38.794 109.089  1.00 22.64           C  
ATOM   1311  CE  LYS B1539      37.837  40.277 109.230  1.00 28.22           C  
ATOM   1312  NZ  LYS B1539      36.369  40.501 109.069  1.00 31.08           N  
ATOM   1313  N   ALA B1540      41.428  34.783 107.175  1.00 19.83           N  
ATOM   1314  CA  ALA B1540      41.519  33.367 106.873  1.00 20.69           C  
ATOM   1315  C   ALA B1540      42.923  32.831 107.146  1.00 20.94           C  
ATOM   1316  O   ALA B1540      43.094  31.716 107.663  1.00 21.72           O  
ATOM   1317  CB  ALA B1540      41.114  33.123 105.415  1.00 20.03           C  
ATOM   1318  N   GLU B1541      43.928  33.642 106.820  1.00 21.82           N  
ATOM   1319  CA  GLU B1541      45.332  33.274 107.007  1.00 22.87           C  
ATOM   1320  C   GLU B1541      45.618  33.019 108.493  1.00 23.16           C  
ATOM   1321  O   GLU B1541      46.386  32.118 108.839  1.00 23.58           O  
ATOM   1322  CB  GLU B1541      46.242  34.391 106.490  1.00 23.23           C  
ATOM   1323  CG  GLU B1541      47.690  33.961 106.266  1.00 25.16           C  
ATOM   1324  CD  GLU B1541      47.899  33.270 104.936  1.00 27.32           C  
ATOM   1325  OE1 GLU B1541      48.026  32.031 104.930  1.00 30.28           O  
ATOM   1326  OE2 GLU B1541      47.941  33.965 103.902  1.00 26.75           O  
ATOM   1327  N   GLU B1542      45.000  33.819 109.358  1.00 23.83           N  
ATOM   1328  CA  GLU B1542      45.217  33.693 110.796  1.00 24.97           C  
ATOM   1329  C   GLU B1542      44.779  32.318 111.288  1.00 25.71           C  
ATOM   1330  O   GLU B1542      45.539  31.636 111.995  1.00 26.70           O  
ATOM   1331  CB  GLU B1542      44.511  34.815 111.543  1.00 25.07           C  
ATOM   1332  CG  GLU B1542      45.167  36.157 111.326  1.00 27.90           C  
ATOM   1333  CD  GLU B1542      44.679  37.198 112.306  1.00 32.31           C  
ATOM   1334  OE1 GLU B1542      43.482  37.548 112.255  1.00 34.85           O  
ATOM   1335  OE2 GLU B1542      45.493  37.667 113.128  1.00 35.68           O  
ATOM   1336  N   VAL B1543      43.580  31.901 110.867  1.00 25.86           N  
ATOM   1337  CA  VAL B1543      43.050  30.570 111.186  1.00 26.54           C  
ATOM   1338  C   VAL B1543      43.916  29.475 110.554  1.00 27.05           C  
ATOM   1339  O   VAL B1543      44.248  28.475 111.204  1.00 27.04           O  
ATOM   1340  CB  VAL B1543      41.561  30.430 110.750  1.00 26.56           C  
ATOM   1341  CG1 VAL B1543      41.027  29.011 111.000  1.00 26.57           C  
ATOM   1342  CG2 VAL B1543      40.704  31.466 111.449  1.00 26.29           C  
ATOM   1343  N   PHE B1544      44.309  29.681 109.298  1.00 27.60           N  
ATOM   1344  CA  PHE B1544      45.158  28.733 108.580  1.00 29.04           C  
ATOM   1345  C   PHE B1544      46.454  28.438 109.323  1.00 30.75           C  
ATOM   1346  O   PHE B1544      46.927  27.300 109.335  1.00 30.56           O  
ATOM   1347  CB  PHE B1544      45.472  29.244 107.164  1.00 28.78           C  
ATOM   1348  CG  PHE B1544      46.291  28.286 106.335  1.00 28.18           C  
ATOM   1349  CD1 PHE B1544      45.714  27.142 105.783  1.00 27.19           C  
ATOM   1350  CD2 PHE B1544      47.647  28.521 106.108  1.00 29.34           C  
ATOM   1351  CE1 PHE B1544      46.480  26.242 105.019  1.00 27.14           C  
ATOM   1352  CE2 PHE B1544      48.416  27.635 105.350  1.00 29.37           C  
ATOM   1353  CZ  PHE B1544      47.827  26.490 104.798  1.00 28.15           C  
ATOM   1354  N   ASN B1545      47.026  29.461 109.947  1.00 33.06           N  
ATOM   1355  CA  ASN B1545      48.345  29.290 110.533  1.00 35.71           C  
ATOM   1356  C   ASN B1545      48.412  28.472 111.821  1.00 37.82           C  
ATOM   1357  O   ASN B1545      48.237  28.981 112.927  1.00 38.45           O  
ATOM   1358  CB  ASN B1545      49.122  30.598 110.560  1.00 35.36           C  
ATOM   1359  CG  ASN B1545      49.755  30.894 109.220  1.00 35.51           C  
ATOM   1360  OD1 ASN B1545      50.231  29.984 108.544  1.00 35.49           O  
ATOM   1361  ND2 ASN B1545      49.756  32.161 108.818  1.00 34.64           N  
ATOM   1362  N   LYS B1546      48.632  27.171 111.606  1.00 40.31           N  
ATOM   1363  CA  LYS B1546      48.999  26.178 112.620  1.00 42.13           C  
ATOM   1364  C   LYS B1546      48.134  26.177 113.882  1.00 43.06           C  
ATOM   1365  O   LYS B1546      46.922  26.441 113.831  1.00 43.05           O  
ATOM   1366  CB  LYS B1546      50.491  26.312 112.977  1.00 42.33           C  
ATOM   1367  CG  LYS B1546      51.422  26.305 111.773  1.00 43.68           C  
ATOM   1368  CD  LYS B1546      52.720  27.048 112.073  1.00 45.28           C  
ATOM   1369  CE  LYS B1546      53.491  27.356 110.798  1.00 46.31           C  
ATOM   1370  NZ  LYS B1546      52.728  28.247 109.865  1.00 46.75           N  
ATOM   1371  N   GLU B1547      48.791  25.868 115.004  1.00 44.14           N  
ATOM   1372  CA  GLU B1547      48.201  25.853 116.343  1.00 45.08           C  
ATOM   1373  C   GLU B1547      46.970  24.946 116.423  1.00 45.02           C  
ATOM   1374  O   GLU B1547      46.862  23.964 115.686  1.00 45.31           O  
ATOM   1375  CB  GLU B1547      47.891  27.281 116.851  1.00 45.50           C  
ATOM   1376  CG  GLU B1547      48.937  28.360 116.503  1.00 46.67           C  
ATOM   1377  CD  GLU B1547      50.320  28.075 117.067  1.00 48.72           C  
ATOM   1378  OE1 GLU B1547      50.435  27.774 118.277  1.00 48.89           O  
ATOM   1379  OE2 GLU B1547      51.296  28.162 116.293  1.00 50.06           O  
ATOM   1380  N   ASP B1548      46.041  25.295 117.306  1.00 45.03           N  
ATOM   1381  CA  ASP B1548      44.941  24.408 117.668  1.00 44.99           C  
ATOM   1382  C   ASP B1548      43.580  24.874 117.156  1.00 44.57           C  
ATOM   1383  O   ASP B1548      42.578  24.781 117.872  1.00 44.29           O  
ATOM   1384  CB  ASP B1548      44.907  24.242 119.191  1.00 45.33           C  
ATOM   1385  CG  ASP B1548      45.265  25.523 119.926  1.00 46.32           C  
ATOM   1386  OD1 ASP B1548      44.777  26.601 119.526  1.00 47.10           O  
ATOM   1387  OD2 ASP B1548      46.042  25.452 120.904  1.00 47.57           O  
ATOM   1388  N   ALA B1549      43.547  25.376 115.918  1.00 44.08           N  
ATOM   1389  CA  ALA B1549      42.291  25.759 115.289  1.00 43.49           C  
ATOM   1390  C   ALA B1549      41.387  24.536 115.237  1.00 43.17           C  
ATOM   1391  O   ALA B1549      41.806  23.470 114.781  1.00 42.99           O  
ATOM   1392  CB  ALA B1549      42.527  26.317 113.885  1.00 43.36           C  
ATOM   1393  N   THR B1550      40.166  24.686 115.738  1.00 42.78           N  
ATOM   1394  CA  THR B1550      39.191  23.601 115.725  1.00 42.54           C  
ATOM   1395  C   THR B1550      38.557  23.495 114.330  1.00 42.43           C  
ATOM   1396  O   THR B1550      38.598  24.462 113.544  1.00 41.82           O  
ATOM   1397  CB  THR B1550      38.091  23.826 116.777  1.00 42.65           C  
ATOM   1398  OG1 THR B1550      37.512  25.120 116.582  1.00 43.11           O  
ATOM   1399  CG2 THR B1550      38.666  23.745 118.190  1.00 42.69           C  
ATOM   1400  N   GLU B1551      37.976  22.339 114.024  1.00 41.93           N  
ATOM   1401  CA  GLU B1551      37.351  22.148 112.719  1.00 41.70           C  
ATOM   1402  C   GLU B1551      36.213  23.144 112.456  1.00 40.88           C  
ATOM   1403  O   GLU B1551      35.968  23.511 111.308  1.00 40.52           O  
ATOM   1404  CB  GLU B1551      36.918  20.695 112.482  1.00 41.59           C  
ATOM   1405  CG  GLU B1551      35.969  20.104 113.511  1.00 42.94           C  
ATOM   1406  CD  GLU B1551      35.308  18.829 113.006  1.00 42.82           C  
ATOM   1407  OE1 GLU B1551      34.893  18.808 111.827  1.00 45.63           O  
ATOM   1408  OE2 GLU B1551      35.206  17.849 113.777  1.00 45.49           O  
ATOM   1409  N   GLU B1552      35.549  23.605 113.514  1.00 40.17           N  
ATOM   1410  CA  GLU B1552      34.529  24.639 113.357  1.00 39.62           C  
ATOM   1411  C   GLU B1552      35.115  26.018 113.047  1.00 38.56           C  
ATOM   1412  O   GLU B1552      34.534  26.777 112.272  1.00 38.48           O  
ATOM   1413  CB  GLU B1552      33.568  24.694 114.551  1.00 40.06           C  
ATOM   1414  CG  GLU B1552      32.567  23.520 114.619  1.00 41.94           C  
ATOM   1415  CD  GLU B1552      31.996  23.104 113.255  1.00 44.65           C  
ATOM   1416  OE1 GLU B1552      31.628  23.988 112.448  1.00 45.63           O  
ATOM   1417  OE2 GLU B1552      31.902  21.882 112.996  1.00 45.48           O  
ATOM   1418  N   GLU B1553      36.257  26.337 113.657  1.00 37.08           N  
ATOM   1419  CA  GLU B1553      36.973  27.574 113.340  1.00 36.03           C  
ATOM   1420  C   GLU B1553      37.385  27.584 111.873  1.00 34.39           C  
ATOM   1421  O   GLU B1553      37.269  28.609 111.200  1.00 33.64           O  
ATOM   1422  CB  GLU B1553      38.210  27.741 114.226  1.00 36.17           C  
ATOM   1423  CG  GLU B1553      37.950  28.535 115.497  1.00 37.48           C  
ATOM   1424  CD  GLU B1553      39.169  28.599 116.400  1.00 37.41           C  
ATOM   1425  OE1 GLU B1553      39.809  27.549 116.618  1.00 39.05           O  
ATOM   1426  OE2 GLU B1553      39.482  29.701 116.900  1.00 40.71           O  
ATOM   1427  N   ILE B1554      37.863  26.432 111.399  1.00 32.81           N  
ATOM   1428  CA  ILE B1554      38.310  26.254 110.018  1.00 31.49           C  
ATOM   1429  C   ILE B1554      37.105  26.377 109.083  1.00 30.79           C  
ATOM   1430  O   ILE B1554      37.181  27.038 108.051  1.00 29.69           O  
ATOM   1431  CB  ILE B1554      39.058  24.898 109.811  1.00 31.31           C  
ATOM   1432  CG1 ILE B1554      40.359  24.865 110.633  1.00 31.96           C  
ATOM   1433  CG2 ILE B1554      39.331  24.629 108.306  1.00 30.40           C  
ATOM   1434  CD1 ILE B1554      40.922  23.452 110.904  1.00 31.89           C  
ATOM   1435  N   ASN B1555      35.981  25.780 109.470  1.00 29.98           N  
ATOM   1436  CA  ASN B1555      34.770  25.866 108.663  1.00 29.58           C  
ATOM   1437  C   ASN B1555      34.191  27.272 108.550  1.00 29.04           C  
ATOM   1438  O   ASN B1555      33.792  27.695 107.455  1.00 28.71           O  
ATOM   1439  CB  ASN B1555      33.705  24.873 109.161  1.00 30.13           C  
ATOM   1440  CG  ASN B1555      34.062  23.428 108.842  1.00 31.26           C  
ATOM   1441  OD1 ASN B1555      34.898  23.153 107.979  1.00 31.49           O  
ATOM   1442  ND2 ASN B1555      33.430  22.492 109.551  1.00 32.97           N  
ATOM   1443  N   LEU B1556      34.155  27.997 109.669  1.00 28.30           N  
ATOM   1444  CA  LEU B1556      33.719  29.393 109.668  1.00 28.11           C  
ATOM   1445  C   LEU B1556      34.625  30.257 108.785  1.00 26.82           C  
ATOM   1446  O   LEU B1556      34.145  31.152 108.087  1.00 26.97           O  
ATOM   1447  CB  LEU B1556      33.697  29.970 111.089  1.00 28.76           C  
ATOM   1448  CG  LEU B1556      32.463  29.767 111.975  1.00 30.59           C  
ATOM   1449  CD1 LEU B1556      32.703  30.393 113.342  1.00 32.33           C  
ATOM   1450  CD2 LEU B1556      31.203  30.350 111.344  1.00 33.63           C  
ATOM   1451  N   ALA B1557      35.928  29.986 108.839  1.00 25.85           N  
ATOM   1452  CA  ALA B1557      36.921  30.730 108.055  1.00 24.70           C  
ATOM   1453  C   ALA B1557      36.745  30.494 106.561  1.00 23.93           C  
ATOM   1454  O   ALA B1557      36.818  31.434 105.777  1.00 23.25           O  
ATOM   1455  CB  ALA B1557      38.335  30.367 108.482  1.00 25.05           C  
ATOM   1456  N   LYS B1558      36.527  29.237 106.183  1.00 23.36           N  
ATOM   1457  CA  LYS B1558      36.218  28.889 104.794  1.00 23.13           C  
ATOM   1458  C   LYS B1558      34.968  29.611 104.292  1.00 23.23           C  
ATOM   1459  O   LYS B1558      34.947  30.160 103.179  1.00 21.90           O  
ATOM   1460  CB  LYS B1558      36.033  27.367 104.653  1.00 23.30           C  
ATOM   1461  CG  LYS B1558      37.319  26.573 104.744  1.00 24.60           C  
ATOM   1462  CD  LYS B1558      37.118  25.151 104.219  1.00 26.44           C  
ATOM   1463  CE  LYS B1558      36.076  24.379 104.994  1.00 28.68           C  
ATOM   1464  NZ  LYS B1558      35.811  23.082 104.307  1.00 31.09           N  
ATOM   1465  N   GLU B1559      33.935  29.609 105.127  1.00 23.28           N  
ATOM   1466  CA  GLU B1559      32.670  30.236 104.814  1.00 24.57           C  
ATOM   1467  C   GLU B1559      32.851  31.739 104.618  1.00 22.94           C  
ATOM   1468  O   GLU B1559      32.357  32.304 103.649  1.00 22.66           O  
ATOM   1469  CB  GLU B1559      31.656  29.942 105.930  1.00 24.90           C  
ATOM   1470  CG  GLU B1559      30.282  30.567 105.732  1.00 29.07           C  
ATOM   1471  CD  GLU B1559      29.314  30.204 106.860  1.00 29.10           C  
ATOM   1472  OE1 GLU B1559      29.116  28.991 107.112  1.00 34.46           O  
ATOM   1473  OE2 GLU B1559      28.761  31.136 107.492  1.00 34.96           O  
ATOM   1474  N   SER B1560      33.570  32.380 105.535  1.00 21.75           N  
ATOM   1475  CA  SER B1560      33.752  33.825 105.451  1.00 21.64           C  
ATOM   1476  C   SER B1560      34.576  34.197 104.226  1.00 20.63           C  
ATOM   1477  O   SER B1560      34.236  35.146 103.516  1.00 20.19           O  
ATOM   1478  CB  SER B1560      34.382  34.368 106.735  1.00 22.17           C  
ATOM   1479  OG  SER B1560      33.520  34.107 107.820  1.00 26.23           O  
ATOM   1480  N   LEU B1561      35.647  33.442 103.975  1.00 19.19           N  
ATOM   1481  CA  LEU B1561      36.489  33.722 102.815  1.00 18.46           C  
ATOM   1482  C   LEU B1561      35.747  33.455 101.491  1.00 18.08           C  
ATOM   1483  O   LEU B1561      35.868  34.222 100.528  1.00 17.83           O  
ATOM   1484  CB  LEU B1561      37.824  32.983 102.900  1.00 18.59           C  
ATOM   1485  CG  LEU B1561      38.753  33.198 101.715  1.00 17.42           C  
ATOM   1486  CD1 LEU B1561      39.083  34.699 101.514  1.00 16.41           C  
ATOM   1487  CD2 LEU B1561      40.035  32.437 101.920  1.00 18.76           C  
ATOM   1488  N   GLU B1562      34.930  32.403 101.457  1.00 18.26           N  
ATOM   1489  CA  GLU B1562      34.105  32.172 100.261  1.00 18.68           C  
ATOM   1490  C   GLU B1562      33.160  33.355  99.984  1.00 18.01           C  
ATOM   1491  O   GLU B1562      32.993  33.775  98.827  1.00 18.07           O  
ATOM   1492  CB  GLU B1562      33.332  30.853 100.390  1.00 19.16           C  
ATOM   1493  CG  GLU B1562      32.489  30.498  99.184  1.00 21.60           C  
ATOM   1494  CD  GLU B1562      33.317  30.147  97.946  1.00 25.04           C  
ATOM   1495  OE1 GLU B1562      34.572  30.259  97.979  1.00 23.19           O  
ATOM   1496  OE2 GLU B1562      32.698  29.772  96.925  1.00 28.40           O  
ATOM   1497  N   GLY B1563      32.560  33.895 101.049  1.00 17.97           N  
ATOM   1498  CA  GLY B1563      31.722  35.098 100.953  1.00 18.45           C  
ATOM   1499  C   GLY B1563      32.506  36.301 100.464  1.00 18.34           C  
ATOM   1500  O   GLY B1563      32.001  37.110  99.668  1.00 19.93           O  
ATOM   1501  N   ALA B1564      33.747  36.423 100.940  1.00 18.22           N  
ATOM   1502  CA  ALA B1564      34.627  37.507 100.516  1.00 17.16           C  
ATOM   1503  C   ALA B1564      34.995  37.407  99.020  1.00 16.83           C  
ATOM   1504  O   ALA B1564      35.050  38.418  98.304  1.00 16.52           O  
ATOM   1505  CB  ALA B1564      35.878  37.516 101.358  1.00 17.21           C  
ATOM   1506  N   ILE B1565      35.252  36.191  98.557  1.00 16.16           N  
ATOM   1507  CA  ILE B1565      35.526  35.960  97.140  1.00 16.76           C  
ATOM   1508  C   ILE B1565      34.302  36.355  96.303  1.00 17.33           C  
ATOM   1509  O   ILE B1565      34.432  37.064  95.301  1.00 17.02           O  
ATOM   1510  CB  ILE B1565      35.971  34.499  96.887  1.00 16.42           C  
ATOM   1511  CG1 ILE B1565      37.395  34.274  97.427  1.00 15.71           C  
ATOM   1512  CG2 ILE B1565      35.928  34.162  95.406  1.00 17.07           C  
ATOM   1513  CD1 ILE B1565      37.750  32.786  97.603  1.00 16.85           C  
ATOM   1514  N   ALA B1566      33.111  35.937  96.748  1.00 18.34           N  
ATOM   1515  CA  ALA B1566      31.872  36.329  96.062  1.00 19.16           C  
ATOM   1516  C   ALA B1566      31.694  37.847  95.983  1.00 19.04           C  
ATOM   1517  O   ALA B1566      31.322  38.382  94.927  1.00 20.35           O  
ATOM   1518  CB  ALA B1566      30.651  35.671  96.730  1.00 19.61           C  
ATOM   1519  N   ARG B1567      31.971  38.529  97.090  1.00 19.50           N  
ATOM   1520  CA  ARG B1567      31.858  39.983  97.167  1.00 19.52           C  
ATOM   1521  C   ARG B1567      32.860  40.631  96.196  1.00 18.95           C  
ATOM   1522  O   ARG B1567      32.506  41.521  95.409  1.00 18.67           O  
ATOM   1523  CB  ARG B1567      32.067  40.479  98.595  1.00 19.13           C  
ATOM   1524  CG  ARG B1567      32.032  41.999  98.678  1.00 20.91           C  
ATOM   1525  CD  ARG B1567      32.083  42.538 100.091  1.00 24.23           C  
ATOM   1526  NE  ARG B1567      32.320  43.980 100.047  1.00 27.16           N  
ATOM   1527  CZ  ARG B1567      31.360  44.902 100.035  1.00 28.47           C  
ATOM   1528  NH1 ARG B1567      30.083  44.544 100.080  1.00 29.50           N  
ATOM   1529  NH2 ARG B1567      31.682  46.185  99.969  1.00 30.09           N  
ATOM   1530  N   PHE B1568      34.102  40.150  96.224  1.00 18.25           N  
ATOM   1531  CA  PHE B1568      35.106  40.661  95.285  1.00 17.70           C  
ATOM   1532  C   PHE B1568      34.623  40.533  93.839  1.00 18.39           C  
ATOM   1533  O   PHE B1568      34.655  41.498  93.070  1.00 18.22           O  
ATOM   1534  CB  PHE B1568      36.462  39.965  95.461  1.00 17.05           C  
ATOM   1535  CG  PHE B1568      37.540  40.528  94.582  1.00 16.00           C  
ATOM   1536  CD1 PHE B1568      38.174  41.724  94.919  1.00 16.90           C  
ATOM   1537  CD2 PHE B1568      37.906  39.876  93.406  1.00 16.61           C  
ATOM   1538  CE1 PHE B1568      39.162  42.253  94.102  1.00 18.09           C  
ATOM   1539  CE2 PHE B1568      38.894  40.415  92.583  1.00 15.64           C  
ATOM   1540  CZ  PHE B1568      39.515  41.594  92.935  1.00 17.24           C  
ATOM   1541  N   ASN B1569      34.150  39.347  93.467  1.00 18.92           N  
ATOM   1542  CA  ASN B1569      33.718  39.124  92.082  1.00 20.68           C  
ATOM   1543  C   ASN B1569      32.545  40.021  91.688  1.00 20.71           C  
ATOM   1544  O   ASN B1569      32.457  40.453  90.533  1.00 21.40           O  
ATOM   1545  CB  ASN B1569      33.365  37.648  91.860  1.00 21.39           C  
ATOM   1546  CG  ASN B1569      34.586  36.737  91.912  1.00 22.18           C  
ATOM   1547  OD1 ASN B1569      35.677  37.102  91.472  1.00 25.95           O  
ATOM   1548  ND2 ASN B1569      34.395  35.534  92.432  1.00 25.03           N  
ATOM   1549  N   SER B1570      31.675  40.316  92.655  1.00 20.72           N  
ATOM   1550  CA  SER B1570      30.501  41.187  92.465  1.00 20.81           C  
ATOM   1551  C   SER B1570      30.889  42.655  92.192  1.00 20.48           C  
ATOM   1552  O   SER B1570      30.061  43.471  91.737  1.00 21.10           O  
ATOM   1553  CB  SER B1570      29.564  41.081  93.678  1.00 21.44           C  
ATOM   1554  OG  SER B1570      29.968  41.910  94.764  1.00 22.12           O  
ATOM   1555  N   LEU B1571      32.152  42.984  92.474  1.00 18.63           N  
ATOM   1556  CA  LEU B1571      32.676  44.331  92.273  1.00 18.41           C  
ATOM   1557  C   LEU B1571      33.406  44.517  90.937  1.00 18.32           C  
ATOM   1558  O   LEU B1571      34.038  45.550  90.689  1.00 17.30           O  
ATOM   1559  CB  LEU B1571      33.548  44.744  93.469  1.00 18.47           C  
ATOM   1560  CG  LEU B1571      32.763  44.902  94.782  1.00 19.45           C  
ATOM   1561  CD1 LEU B1571      33.713  44.958  95.983  1.00 20.87           C  
ATOM   1562  CD2 LEU B1571      31.939  46.170  94.739  1.00 20.70           C  
ATOM   1563  N   LEU B1572      33.287  43.513  90.073  1.00 17.89           N  
ATOM   1564  CA  LEU B1572      33.813  43.569  88.718  1.00 19.23           C  
ATOM   1565  C   LEU B1572      32.969  44.534  87.910  1.00 19.01           C  
ATOM   1566  O   LEU B1572      31.742  44.453  87.935  1.00 20.24           O  
ATOM   1567  CB  LEU B1572      33.754  42.178  88.073  1.00 19.51           C  
ATOM   1568  CG  LEU B1572      34.169  42.126  86.596  1.00 21.17           C  
ATOM   1569  CD1 LEU B1572      35.653  42.354  86.428  1.00 22.87           C  
ATOM   1570  CD2 LEU B1572      33.732  40.801  85.976  1.00 22.51           C  
ATOM   1571  N   ILE B1573      33.628  45.437  87.194  1.00 19.06           N  
ATOM   1572  CA  ILE B1573      32.906  46.363  86.316  1.00 18.81           C  
ATOM   1573  C   ILE B1573      32.630  45.665  84.984  1.00 19.64           C  
ATOM   1574  O   ILE B1573      33.551  45.188  84.313  1.00 20.00           O  
ATOM   1575  CB  ILE B1573      33.680  47.673  86.107  1.00 18.82           C  
ATOM   1576  CG1 ILE B1573      33.916  48.354  87.460  1.00 18.02           C  
ATOM   1577  CG2 ILE B1573      32.916  48.597  85.150  1.00 18.64           C  
ATOM   1578  CD1 ILE B1573      35.021  49.420  87.460  1.00 18.57           C  
ATOM   1579  N   GLU B1574      31.349  45.597  84.633  1.00 20.50           N  
ATOM   1580  CA  GLU B1574      30.881  44.967  83.400  1.00 21.73           C  
ATOM   1581  C   GLU B1574      30.370  46.025  82.419  1.00 22.39           C  
ATOM   1582  O   GLU B1574      30.157  47.188  82.798  1.00 22.46           O  
ATOM   1583  CB  GLU B1574      29.775  43.965  83.715  1.00 21.92           C  
ATOM   1584  CG  GLU B1574      30.223  42.913  84.732  1.00 24.15           C  
ATOM   1585  CD  GLU B1574      29.205  41.816  84.972  1.00 27.40           C  
ATOM   1586  OE1 GLU B1574      28.028  42.125  85.252  1.00 28.83           O  
ATOM   1587  OE2 GLU B1574      29.604  40.634  84.905  1.00 30.08           O  
ATOM   1588  N   GLU B1575      30.174  45.617  81.167  1.00 23.48           N  
ATOM   1589  CA  GLU B1575      29.656  46.516  80.134  1.00 24.34           C  
ATOM   1590  C   GLU B1575      28.411  47.277  80.588  1.00 23.64           C  
ATOM   1591  O   GLU B1575      28.288  48.500  80.368  1.00 24.34           O  
ATOM   1592  CB  GLU B1575      29.336  45.714  78.863  1.00 25.01           C  
ATOM   1593  CG  GLU B1575      30.573  45.356  78.045  1.00 29.45           C  
ATOM   1594  CD  GLU B1575      31.228  46.573  77.415  1.00 32.64           C  
ATOM   1595  OE1 GLU B1575      32.410  46.475  77.012  1.00 36.90           O  
ATOM   1596  OE2 GLU B1575      30.572  47.631  77.333  1.00 35.48           O  
ATOM   1597  N   SER B1576      27.503  46.550  81.232  1.00 22.98           N  
ATOM   1598  CA  SER B1576      26.201  47.061  81.668  1.00 23.39           C  
ATOM   1599  C   SER B1576      26.199  47.750  83.039  1.00 22.15           C  
ATOM   1600  O   SER B1576      25.156  48.233  83.468  1.00 22.05           O  
ATOM   1601  CB  SER B1576      25.207  45.902  81.737  1.00 23.38           C  
ATOM   1602  OG  SER B1576      25.630  44.994  82.738  1.00 28.11           O  
ATOM   1603  N   THR B1577      27.334  47.744  83.741  1.00 21.98           N  
ATOM   1604  CA  THR B1577      27.428  48.384  85.060  1.00 21.37           C  
ATOM   1605  C   THR B1577      27.129  49.865  84.932  1.00 20.92           C  
ATOM   1606  O   THR B1577      27.818  50.584  84.208  1.00 22.00           O  
ATOM   1607  CB  THR B1577      28.821  48.193  85.676  1.00 21.35           C  
ATOM   1608  OG1 THR B1577      29.107  46.791  85.732  1.00 21.91           O  
ATOM   1609  CG2 THR B1577      28.898  48.773  87.085  1.00 20.78           C  
ATOM   1610  N   GLY B1578      26.095  50.293  85.640  1.00 20.81           N  
ATOM   1611  CA  GLY B1578      25.668  51.686  85.621  1.00 21.91           C  
ATOM   1612  C   GLY B1578      24.553  51.970  84.631  1.00 22.13           C  
ATOM   1613  O   GLY B1578      24.106  53.108  84.519  1.00 21.35           O  
ATOM   1614  N   ASP B1579      24.120  50.944  83.900  1.00 23.93           N  
ATOM   1615  CA  ASP B1579      22.921  51.039  83.074  1.00 26.20           C  
ATOM   1616  C   ASP B1579      21.729  50.591  83.910  1.00 27.33           C  
ATOM   1617  O   ASP B1579      21.373  49.411  83.906  1.00 28.62           O  
ATOM   1618  CB  ASP B1579      23.055  50.183  81.802  1.00 26.40           C  
ATOM   1619  CG  ASP B1579      21.835  50.288  80.897  1.00 28.92           C  
ATOM   1620  OD1 ASP B1579      21.623  49.378  80.067  1.00 30.01           O  
ATOM   1621  OD2 ASP B1579      21.070  51.264  81.039  1.00 28.37           O  
ATOM   1622  N   PHE B1580      21.108  51.529  84.624  1.00 28.03           N  
ATOM   1623  CA  PHE B1580      20.150  51.181  85.683  1.00 29.67           C  
ATOM   1624  C   PHE B1580      18.732  50.851  85.229  1.00 31.70           C  
ATOM   1625  O   PHE B1580      18.138  49.863  85.685  1.00 32.78           O  
ATOM   1626  CB  PHE B1580      20.105  52.272  86.745  1.00 28.49           C  
ATOM   1627  CG  PHE B1580      21.423  52.529  87.393  1.00 27.73           C  
ATOM   1628  CD1 PHE B1580      22.106  51.502  88.049  1.00 27.13           C  
ATOM   1629  CD2 PHE B1580      21.992  53.799  87.364  1.00 25.80           C  
ATOM   1630  CE1 PHE B1580      23.331  51.747  88.665  1.00 27.51           C  
ATOM   1631  CE2 PHE B1580      23.206  54.042  87.967  1.00 25.72           C  
ATOM   1632  CZ  PHE B1580      23.883  53.016  88.623  1.00 26.20           C  
ATOM   1633  N   ASN B1581      18.180  51.686  84.359  1.00 33.96           N  
ATOM   1634  CA  ASN B1581      16.858  51.425  83.801  1.00 35.70           C  
ATOM   1635  C   ASN B1581      16.921  50.203  82.887  1.00 36.59           C  
ATOM   1636  O   ASN B1581      15.888  49.648  82.507  1.00 37.44           O  
ATOM   1637  CB  ASN B1581      16.324  52.657  83.061  1.00 36.07           C  
ATOM   1638  CG  ASN B1581      17.429  53.448  82.361  1.00 36.65           C  
ATOM   1639  OD1 ASN B1581      18.341  52.871  81.761  1.00 35.74           O  
ATOM   1640  ND2 ASN B1581      17.353  54.776  82.447  1.00 37.73           N  
ATOM   1641  N   GLY B1582      18.151  49.792  82.561  1.00 37.25           N  
ATOM   1642  CA  GLY B1582      18.407  48.597  81.764  1.00 37.31           C  
ATOM   1643  C   GLY B1582      17.928  48.747  80.337  1.00 37.49           C  
ATOM   1644  O   GLY B1582      17.276  47.846  79.796  1.00 37.85           O  
ATOM   1645  N   ASN B1583      18.253  49.887  79.727  1.00 36.87           N  
ATOM   1646  CA  ASN B1583      17.847  50.167  78.347  1.00 36.68           C  
ATOM   1647  C   ASN B1583      18.999  50.025  77.337  1.00 36.35           C  
ATOM   1648  O   ASN B1583      18.905  50.493  76.189  1.00 36.48           O  
ATOM   1649  CB  ASN B1583      17.177  51.549  78.249  1.00 36.71           C  
ATOM   1650  CG  ASN B1583      18.152  52.699  78.457  1.00 36.98           C  
ATOM   1651  OD1 ASN B1583      19.203  52.538  79.075  1.00 35.37           O  
ATOM   1652  ND2 ASN B1583      17.803  53.873  77.940  1.00 37.60           N  
ATOM   1653  N   GLY B1584      20.084  49.388  77.778  1.00 35.76           N  
ATOM   1654  CA  GLY B1584      21.169  49.005  76.886  1.00 35.11           C  
ATOM   1655  C   GLY B1584      22.279  50.017  76.696  1.00 34.46           C  
ATOM   1656  O   GLY B1584      23.247  49.738  75.989  1.00 35.03           O  
ATOM   1657  N   LYS B1585      22.149  51.189  77.318  1.00 33.17           N  
ATOM   1658  CA  LYS B1585      23.224  52.193  77.270  1.00 31.70           C  
ATOM   1659  C   LYS B1585      23.328  53.014  78.556  1.00 29.83           C  
ATOM   1660  O   LYS B1585      22.365  53.125  79.317  1.00 30.38           O  
ATOM   1661  CB  LYS B1585      23.072  53.109  76.049  1.00 32.59           C  
ATOM   1662  CG  LYS B1585      21.830  53.985  76.060  1.00 34.27           C  
ATOM   1663  CD  LYS B1585      21.977  55.156  75.097  1.00 37.49           C  
ATOM   1664  CE  LYS B1585      20.674  55.933  74.991  1.00 38.86           C  
ATOM   1665  NZ  LYS B1585      20.876  57.273  74.366  1.00 40.17           N  
ATOM   1666  N   ILE B1586      24.505  53.577  78.794  1.00 26.83           N  
ATOM   1667  CA  ILE B1586      24.707  54.419  79.975  1.00 24.04           C  
ATOM   1668  C   ILE B1586      24.657  55.883  79.540  1.00 22.47           C  
ATOM   1669  O   ILE B1586      25.429  56.318  78.682  1.00 22.52           O  
ATOM   1670  CB  ILE B1586      25.984  54.022  80.749  1.00 24.49           C  
ATOM   1671  CG1 ILE B1586      25.886  52.545  81.166  1.00 25.38           C  
ATOM   1672  CG2 ILE B1586      26.127  54.869  82.019  1.00 22.15           C  
ATOM   1673  CD1 ILE B1586      27.189  51.755  81.150  1.00 28.91           C  
ATOM   1674  N   ASP B1587      23.699  56.626  80.092  1.00 19.86           N  
ATOM   1675  CA  ASP B1587      23.465  58.000  79.636  1.00 18.40           C  
ATOM   1676  C   ASP B1587      23.027  58.904  80.773  1.00 17.24           C  
ATOM   1677  O   ASP B1587      23.074  58.515  81.945  1.00 16.67           O  
ATOM   1678  CB  ASP B1587      22.477  58.038  78.452  1.00 19.04           C  
ATOM   1679  CG  ASP B1587      21.055  57.639  78.826  1.00 19.67           C  
ATOM   1680  OD1 ASP B1587      20.244  57.437  77.889  1.00 24.11           O  
ATOM   1681  OD2 ASP B1587      20.694  57.538  80.021  1.00 21.16           O  
ATOM   1682  N   ILE B1588      22.623  60.129  80.427  1.00 16.01           N  
ATOM   1683  CA  ILE B1588      22.277  61.117  81.432  1.00 14.86           C  
ATOM   1684  C   ILE B1588      21.088  60.710  82.335  1.00 14.60           C  
ATOM   1685  O   ILE B1588      20.964  61.219  83.454  1.00 15.21           O  
ATOM   1686  CB  ILE B1588      22.040  62.502  80.752  1.00 15.15           C  
ATOM   1687  CG1 ILE B1588      22.256  63.648  81.736  1.00 15.43           C  
ATOM   1688  CG2 ILE B1588      20.671  62.590  80.034  1.00 16.36           C  
ATOM   1689  CD1 ILE B1588      23.690  63.797  82.187  1.00 15.79           C  
ATOM   1690  N   GLY B1589      20.235  59.796  81.861  1.00 14.83           N  
ATOM   1691  CA  GLY B1589      19.145  59.274  82.674  1.00 15.40           C  
ATOM   1692  C   GLY B1589      19.716  58.452  83.821  1.00 15.75           C  
ATOM   1693  O   GLY B1589      19.264  58.582  84.958  1.00 15.45           O  
ATOM   1694  N   ASP B1590      20.744  57.651  83.530  1.00 15.60           N  
ATOM   1695  CA  ASP B1590      21.377  56.844  84.584  1.00 15.54           C  
ATOM   1696  C   ASP B1590      22.081  57.739  85.603  1.00 15.48           C  
ATOM   1697  O   ASP B1590      22.000  57.501  86.820  1.00 15.24           O  
ATOM   1698  CB  ASP B1590      22.342  55.816  83.987  1.00 15.99           C  
ATOM   1699  CG  ASP B1590      21.658  54.904  82.984  1.00 17.61           C  
ATOM   1700  OD1 ASP B1590      20.818  54.065  83.384  1.00 19.69           O  
ATOM   1701  OD2 ASP B1590      21.932  55.049  81.781  1.00 17.59           O  
ATOM   1702  N   LEU B1591      22.749  58.787  85.119  1.00 14.58           N  
ATOM   1703  CA  LEU B1591      23.377  59.756  86.035  1.00 14.63           C  
ATOM   1704  C   LEU B1591      22.320  60.434  86.903  1.00 15.19           C  
ATOM   1705  O   LEU B1591      22.511  60.646  88.101  1.00 15.06           O  
ATOM   1706  CB  LEU B1591      24.194  60.807  85.261  1.00 15.17           C  
ATOM   1707  CG  LEU B1591      24.953  61.828  86.101  1.00 15.56           C  
ATOM   1708  CD1 LEU B1591      25.820  61.144  87.163  1.00 16.44           C  
ATOM   1709  CD2 LEU B1591      25.778  62.729  85.155  1.00 14.76           C  
ATOM   1710  N   ALA B1592      21.196  60.781  86.288  1.00 15.32           N  
ATOM   1711  CA  ALA B1592      20.100  61.383  87.042  1.00 15.23           C  
ATOM   1712  C   ALA B1592      19.530  60.474  88.134  1.00 15.94           C  
ATOM   1713  O   ALA B1592      19.139  60.964  89.190  1.00 15.92           O  
ATOM   1714  CB  ALA B1592      18.999  61.821  86.094  1.00 16.29           C  
ATOM   1715  N   MET B1593      19.475  59.169  87.880  1.00 16.30           N  
ATOM   1716  CA  MET B1593      18.992  58.241  88.912  1.00 18.21           C  
ATOM   1717  C   MET B1593      19.913  58.243  90.128  1.00 17.26           C  
ATOM   1718  O   MET B1593      19.445  58.273  91.267  1.00 18.41           O  
ATOM   1719  CB  MET B1593      18.864  56.838  88.354  1.00 17.43           C  
ATOM   1720  CG  MET B1593      17.730  56.723  87.432  1.00 20.70           C  
ATOM   1721  SD  MET B1593      17.670  55.141  86.619  1.00 25.18           S  
ATOM   1722  CE  MET B1593      16.997  54.108  87.924  1.00 26.39           C  
ATOM   1723  N   VAL B1594      21.222  58.231  89.894  1.00 16.11           N  
ATOM   1724  CA  VAL B1594      22.185  58.316  91.014  1.00 16.62           C  
ATOM   1725  C   VAL B1594      21.981  59.635  91.780  1.00 16.52           C  
ATOM   1726  O   VAL B1594      21.851  59.660  93.004  1.00 16.49           O  
ATOM   1727  CB  VAL B1594      23.658  58.212  90.508  1.00 16.55           C  
ATOM   1728  CG1 VAL B1594      24.663  58.494  91.650  1.00 16.91           C  
ATOM   1729  CG2 VAL B1594      23.923  56.833  89.898  1.00 19.80           C  
ATOM   1730  N   SER B1595      21.895  60.742  91.047  1.00 16.08           N  
ATOM   1731  CA  SER B1595      21.709  62.050  91.672  1.00 16.32           C  
ATOM   1732  C   SER B1595      20.454  62.130  92.539  1.00 16.35           C  
ATOM   1733  O   SER B1595      20.511  62.549  93.709  1.00 17.47           O  
ATOM   1734  CB  SER B1595      21.666  63.147  90.600  1.00 15.59           C  
ATOM   1735  OG  SER B1595      21.539  64.421  91.174  1.00 19.00           O  
ATOM   1736  N   LYS B1596      19.331  61.714  91.980  1.00 16.75           N  
ATOM   1737  CA  LYS B1596      18.069  61.734  92.735  1.00 18.26           C  
ATOM   1738  C   LYS B1596      18.191  60.905  94.018  1.00 18.48           C  
ATOM   1739  O   LYS B1596      17.641  61.273  95.075  1.00 19.38           O  
ATOM   1740  CB  LYS B1596      16.926  61.241  91.852  1.00 19.09           C  
ATOM   1741  CG  LYS B1596      15.548  61.399  92.465  1.00 22.99           C  
ATOM   1742  CD  LYS B1596      15.146  60.151  93.203  1.00 28.65           C  
ATOM   1743  CE  LYS B1596      14.133  60.474  94.292  1.00 30.90           C  
ATOM   1744  NZ  LYS B1596      12.970  61.208  93.741  1.00 34.66           N  
ATOM   1745  N   ASN B1597      18.954  59.822  93.927  1.00 17.95           N  
ATOM   1746  CA  ASN B1597      19.074  58.889  95.044  1.00 18.11           C  
ATOM   1747  C   ASN B1597      20.302  59.106  95.927  1.00 18.00           C  
ATOM   1748  O   ASN B1597      20.633  58.268  96.754  1.00 17.62           O  
ATOM   1749  CB  ASN B1597      18.951  57.449  94.543  1.00 18.50           C  
ATOM   1750  CG  ASN B1597      17.557  57.142  94.049  1.00 20.11           C  
ATOM   1751  OD1 ASN B1597      17.307  57.085  92.835  1.00 20.72           O  
ATOM   1752  ND2 ASN B1597      16.620  56.997  94.981  1.00 22.34           N  
ATOM   1753  N   ILE B1598      20.962  60.250  95.783  1.00 18.08           N  
ATOM   1754  CA  ILE B1598      22.113  60.529  96.638  1.00 19.21           C  
ATOM   1755  C   ILE B1598      21.702  60.450  98.108  1.00 18.91           C  
ATOM   1756  O   ILE B1598      20.661  60.983  98.504  1.00 18.62           O  
ATOM   1757  CB  ILE B1598      22.833  61.854  96.265  1.00 19.99           C  
ATOM   1758  CG1 ILE B1598      23.835  61.550  95.141  1.00 24.26           C  
ATOM   1759  CG2 ILE B1598      23.608  62.433  97.459  1.00 22.21           C  
ATOM   1760  CD1 ILE B1598      24.953  62.575  94.942  1.00 28.16           C  
ATOM   1761  N   GLY B1599      22.507  59.717  98.878  1.00 19.01           N  
ATOM   1762  CA  GLY B1599      22.238  59.530 100.297  1.00 19.97           C  
ATOM   1763  C   GLY B1599      21.374  58.329 100.594  1.00 20.75           C  
ATOM   1764  O   GLY B1599      21.202  57.984 101.762  1.00 20.66           O  
ATOM   1765  N   SER B1600      20.824  57.677  99.572  1.00 21.10           N  
ATOM   1766  CA  SER B1600      19.971  56.497  99.811  1.00 21.93           C  
ATOM   1767  C   SER B1600      20.756  55.328 100.402  1.00 22.90           C  
ATOM   1768  O   SER B1600      21.878  55.042  99.977  1.00 22.96           O  
ATOM   1769  CB  SER B1600      19.304  56.032  98.525  1.00 22.10           C  
ATOM   1770  OG  SER B1600      18.590  54.821  98.741  1.00 21.84           O  
ATOM   1771  N   THR B1601      20.143  54.641 101.359  1.00 24.52           N  
ATOM   1772  CA  THR B1601      20.727  53.437 101.935  1.00 25.68           C  
ATOM   1773  C   THR B1601      19.841  52.242 101.590  1.00 26.98           C  
ATOM   1774  O   THR B1601      20.055  51.137 102.079  1.00 27.33           O  
ATOM   1775  CB  THR B1601      20.892  53.555 103.473  1.00 26.15           C  
ATOM   1776  OG1 THR B1601      19.638  53.922 104.064  1.00 26.29           O  
ATOM   1777  CG2 THR B1601      21.953  54.588 103.826  1.00 25.58           C  
ATOM   1778  N   THR B1602      18.870  52.472 100.709  1.00 27.86           N  
ATOM   1779  CA  THR B1602      17.851  51.472 100.383  1.00 28.92           C  
ATOM   1780  C   THR B1602      17.893  51.038  98.915  1.00 30.14           C  
ATOM   1781  O   THR B1602      17.220  50.077  98.522  1.00 30.78           O  
ATOM   1782  CB  THR B1602      16.452  52.008 100.714  1.00 28.82           C  
ATOM   1783  OG1 THR B1602      16.223  53.223  99.986  1.00 27.91           O  
ATOM   1784  CG2 THR B1602      16.327  52.300 102.208  1.00 28.52           C  
ATOM   1785  N   ASN B1603      18.682  51.752  98.119  1.00 30.95           N  
ATOM   1786  CA  ASN B1603      18.816  51.492  96.690  1.00 32.35           C  
ATOM   1787  C   ASN B1603      20.053  50.645  96.410  1.00 32.70           C  
ATOM   1788  O   ASN B1603      21.085  51.153  95.949  1.00 32.92           O  
ATOM   1789  CB  ASN B1603      18.897  52.815  95.927  1.00 32.46           C  
ATOM   1790  CG  ASN B1603      17.535  53.386  95.605  1.00 34.12           C  
ATOM   1791  OD1 ASN B1603      16.912  53.012  94.606  1.00 36.88           O  
ATOM   1792  ND2 ASN B1603      17.073  54.315  96.430  1.00 35.36           N  
ATOM   1793  N   THR B1604      19.940  49.350  96.693  1.00 32.87           N  
ATOM   1794  CA  THR B1604      21.067  48.426  96.589  1.00 33.42           C  
ATOM   1795  C   THR B1604      21.176  47.765  95.209  1.00 33.09           C  
ATOM   1796  O   THR B1604      21.554  46.575  95.104  1.00 34.52           O  
ATOM   1797  CB  THR B1604      20.984  47.318  97.657  1.00 33.65           C  
ATOM   1798  OG1 THR B1604      19.687  46.723  97.605  1.00 35.43           O  
ATOM   1799  CG2 THR B1604      21.229  47.890  99.062  1.00 35.25           C  
ATOM   1800  N   SER B1605      20.807  48.513  94.169  1.00 31.37           N  
ATOM   1801  CA  SER B1605      21.196  48.215  92.787  1.00 30.09           C  
ATOM   1802  C   SER B1605      22.000  49.404  92.244  1.00 28.44           C  
ATOM   1803  O   SER B1605      22.792  49.258  91.307  1.00 29.04           O  
ATOM   1804  CB  SER B1605      19.981  47.936  91.903  1.00 30.26           C  
ATOM   1805  OG  SER B1605      19.145  49.080  91.802  1.00 32.50           O  
ATOM   1806  N   LEU B1606      21.803  50.570  92.852  1.00 25.96           N  
ATOM   1807  CA  LEU B1606      22.521  51.793  92.458  1.00 24.29           C  
ATOM   1808  C   LEU B1606      23.862  51.921  93.183  1.00 23.07           C  
ATOM   1809  O   LEU B1606      24.679  52.775  92.851  1.00 21.94           O  
ATOM   1810  CB  LEU B1606      21.662  53.040  92.747  1.00 24.27           C  
ATOM   1811  CG  LEU B1606      20.650  53.594  91.726  1.00 26.47           C  
ATOM   1812  CD1 LEU B1606      20.013  52.549  90.807  1.00 28.67           C  
ATOM   1813  CD2 LEU B1606      19.571  54.463  92.418  1.00 25.71           C  
ATOM   1814  N   ASP B1607      24.077  51.076  94.186  1.00 21.88           N  
ATOM   1815  CA  ASP B1607      25.271  51.165  95.022  1.00 21.87           C  
ATOM   1816  C   ASP B1607      26.399  50.358  94.402  1.00 21.79           C  
ATOM   1817  O   ASP B1607      26.688  49.229  94.810  1.00 21.62           O  
ATOM   1818  CB  ASP B1607      24.953  50.681  96.445  1.00 21.77           C  
ATOM   1819  CG  ASP B1607      26.134  50.814  97.406  1.00 22.62           C  
ATOM   1820  OD1 ASP B1607      26.082  50.130  98.448  1.00 22.20           O  
ATOM   1821  OD2 ASP B1607      27.127  51.538  97.141  1.00 21.12           O  
ATOM   1822  N   LEU B1608      27.039  50.955  93.405  1.00 21.46           N  
ATOM   1823  CA  LEU B1608      28.040  50.258  92.586  1.00 21.86           C  
ATOM   1824  C   LEU B1608      29.256  49.710  93.351  1.00 21.98           C  
ATOM   1825  O   LEU B1608      29.664  48.569  93.114  1.00 22.39           O  
ATOM   1826  CB  LEU B1608      28.484  51.156  91.428  1.00 21.81           C  
ATOM   1827  CG  LEU B1608      27.361  51.599  90.472  1.00 22.28           C  
ATOM   1828  CD1 LEU B1608      27.911  52.549  89.409  1.00 23.93           C  
ATOM   1829  CD2 LEU B1608      26.627  50.433  89.835  1.00 24.57           C  
ATOM   1830  N   ASN B1609      29.839  50.509  94.241  1.00 21.81           N  
ATOM   1831  CA  ASN B1609      30.964  50.039  95.065  1.00 21.75           C  
ATOM   1832  C   ASN B1609      30.539  49.269  96.333  1.00 22.23           C  
ATOM   1833  O   ASN B1609      31.391  48.859  97.133  1.00 22.99           O  
ATOM   1834  CB  ASN B1609      31.995  51.144  95.356  1.00 21.55           C  
ATOM   1835  CG  ASN B1609      31.472  52.246  96.288  1.00 19.63           C  
ATOM   1836  OD1 ASN B1609      32.248  53.087  96.750  1.00 22.28           O  
ATOM   1837  ND2 ASN B1609      30.174  52.230  96.582  1.00 18.77           N  
ATOM   1838  N   LYS B1610      29.230  49.076  96.493  1.00 22.94           N  
ATOM   1839  CA  LYS B1610      28.667  48.214  97.542  1.00 23.91           C  
ATOM   1840  C   LYS B1610      29.122  48.613  98.951  1.00 23.78           C  
ATOM   1841  O   LYS B1610      29.377  47.747  99.806  1.00 24.56           O  
ATOM   1842  CB  LYS B1610      28.967  46.733  97.255  1.00 23.46           C  
ATOM   1843  CG  LYS B1610      28.248  46.206  96.040  1.00 26.35           C  
ATOM   1844  CD  LYS B1610      28.423  44.712  95.889  1.00 29.04           C  
ATOM   1845  CE  LYS B1610      27.823  44.230  94.582  1.00 31.10           C  
ATOM   1846  NZ  LYS B1610      26.338  44.392  94.573  1.00 33.47           N  
ATOM   1847  N   ASP B1611      29.213  49.923  99.192  1.00 23.31           N  
ATOM   1848  CA  ASP B1611      29.665  50.440 100.481  1.00 23.05           C  
ATOM   1849  C   ASP B1611      28.514  50.857 101.402  1.00 23.12           C  
ATOM   1850  O   ASP B1611      28.741  51.329 102.516  1.00 23.43           O  
ATOM   1851  CB  ASP B1611      30.679  51.578 100.306  1.00 22.98           C  
ATOM   1852  CG  ASP B1611      30.073  52.839  99.710  1.00 22.08           C  
ATOM   1853  OD1 ASP B1611      30.788  53.856  99.728  1.00 23.48           O  
ATOM   1854  OD2 ASP B1611      28.908  52.830  99.237  1.00 19.64           O  
ATOM   1855  N   GLY B1612      27.290  50.676 100.921  1.00 23.37           N  
ATOM   1856  CA  GLY B1612      26.105  50.923 101.722  1.00 24.16           C  
ATOM   1857  C   GLY B1612      25.353  52.208 101.442  1.00 24.69           C  
ATOM   1858  O   GLY B1612      24.282  52.422 102.003  1.00 25.39           O  
ATOM   1859  N   SER B1613      25.904  53.073 100.596  1.00 24.26           N  
ATOM   1860  CA  SER B1613      25.178  54.302 100.241  1.00 24.08           C  
ATOM   1861  C   SER B1613      25.513  54.820  98.849  1.00 23.16           C  
ATOM   1862  O   SER B1613      26.496  54.407  98.232  1.00 21.95           O  
ATOM   1863  CB  SER B1613      25.415  55.409 101.274  1.00 24.80           C  
ATOM   1864  OG  SER B1613      26.780  55.802 101.306  1.00 27.84           O  
ATOM   1865  N   ILE B1614      24.686  55.755  98.390  1.00 21.91           N  
ATOM   1866  CA  ILE B1614      24.857  56.379  97.075  1.00 20.78           C  
ATOM   1867  C   ILE B1614      25.515  57.737  97.291  1.00 20.98           C  
ATOM   1868  O   ILE B1614      24.972  58.589  97.984  1.00 21.12           O  
ATOM   1869  CB  ILE B1614      23.486  56.524  96.364  1.00 20.22           C  
ATOM   1870  CG1 ILE B1614      22.699  55.190  96.358  1.00 20.24           C  
ATOM   1871  CG2 ILE B1614      23.667  57.112  94.960  1.00 18.96           C  
ATOM   1872  CD1 ILE B1614      23.488  53.996  95.900  1.00 21.86           C  
ATOM   1873  N   ASP B1615      26.707  57.935  96.743  1.00 20.41           N  
ATOM   1874  CA  ASP B1615      27.402  59.208  96.934  1.00 20.71           C  
ATOM   1875  C   ASP B1615      28.243  59.607  95.729  1.00 20.63           C  
ATOM   1876  O   ASP B1615      27.999  59.136  94.615  1.00 20.38           O  
ATOM   1877  CB  ASP B1615      28.248  59.194  98.230  1.00 21.03           C  
ATOM   1878  CG  ASP B1615      29.374  58.169  98.199  1.00 22.03           C  
ATOM   1879  OD1 ASP B1615      29.715  57.652  97.109  1.00 21.35           O  
ATOM   1880  OD2 ASP B1615      29.934  57.873  99.279  1.00 23.49           O  
ATOM   1881  N   GLU B1616      29.234  60.461  95.939  1.00 20.33           N  
ATOM   1882  CA  GLU B1616      30.043  60.961  94.830  1.00 19.96           C  
ATOM   1883  C   GLU B1616      30.805  59.871  94.078  1.00 18.28           C  
ATOM   1884  O   GLU B1616      31.181  60.081  92.928  1.00 18.54           O  
ATOM   1885  CB  GLU B1616      31.011  62.052  95.294  1.00 21.35           C  
ATOM   1886  CG  GLU B1616      30.841  63.334  94.540  1.00 25.92           C  
ATOM   1887  CD  GLU B1616      31.647  64.472  95.106  1.00 28.23           C  
ATOM   1888  OE1 GLU B1616      31.042  65.415  95.673  1.00 33.93           O  
ATOM   1889  OE2 GLU B1616      32.885  64.426  94.974  1.00 32.13           O  
ATOM   1890  N   TYR B1617      31.044  58.720  94.702  1.00 17.19           N  
ATOM   1891  CA  TYR B1617      31.672  57.621  93.952  1.00 16.04           C  
ATOM   1892  C   TYR B1617      30.815  57.261  92.730  1.00 16.16           C  
ATOM   1893  O   TYR B1617      31.309  57.218  91.603  1.00 16.02           O  
ATOM   1894  CB  TYR B1617      31.928  56.354  94.789  1.00 16.66           C  
ATOM   1895  CG  TYR B1617      32.490  55.321  93.853  1.00 16.07           C  
ATOM   1896  CD1 TYR B1617      33.828  55.385  93.469  1.00 17.27           C  
ATOM   1897  CD2 TYR B1617      31.667  54.331  93.270  1.00 14.27           C  
ATOM   1898  CE1 TYR B1617      34.353  54.484  92.567  1.00 18.27           C  
ATOM   1899  CE2 TYR B1617      32.194  53.418  92.346  1.00 14.45           C  
ATOM   1900  CZ  TYR B1617      33.543  53.519  92.003  1.00 16.07           C  
ATOM   1901  OH  TYR B1617      34.094  52.657  91.100  1.00 19.01           O  
ATOM   1902  N   GLU B1618      29.532  57.024  92.965  1.00 15.45           N  
ATOM   1903  CA  GLU B1618      28.646  56.596  91.880  1.00 14.97           C  
ATOM   1904  C   GLU B1618      28.531  57.684  90.815  1.00 15.62           C  
ATOM   1905  O   GLU B1618      28.552  57.394  89.610  1.00 16.30           O  
ATOM   1906  CB  GLU B1618      27.286  56.231  92.430  1.00 15.63           C  
ATOM   1907  CG  GLU B1618      27.199  54.801  92.995  1.00 16.84           C  
ATOM   1908  CD  GLU B1618      27.815  54.622  94.405  1.00 20.11           C  
ATOM   1909  OE1 GLU B1618      28.233  53.488  94.714  1.00 21.68           O  
ATOM   1910  OE2 GLU B1618      27.870  55.590  95.207  1.00 20.89           O  
ATOM   1911  N   ILE B1619      28.453  58.927  91.270  1.00 15.68           N  
ATOM   1912  CA  ILE B1619      28.435  60.086  90.369  1.00 16.14           C  
ATOM   1913  C   ILE B1619      29.685  60.080  89.484  1.00 16.34           C  
ATOM   1914  O   ILE B1619      29.595  60.141  88.248  1.00 16.18           O  
ATOM   1915  CB  ILE B1619      28.340  61.414  91.168  1.00 16.30           C  
ATOM   1916  CG1 ILE B1619      27.007  61.497  91.927  1.00 17.50           C  
ATOM   1917  CG2 ILE B1619      28.523  62.633  90.252  1.00 17.19           C  
ATOM   1918  CD1 ILE B1619      25.774  61.826  91.038  1.00 20.35           C  
ATOM   1919  N   SER B1620      30.848  59.961  90.121  1.00 16.63           N  
ATOM   1920  CA  SER B1620      32.122  59.970  89.399  1.00 17.36           C  
ATOM   1921  C   SER B1620      32.205  58.802  88.408  1.00 16.88           C  
ATOM   1922  O   SER B1620      32.655  58.978  87.271  1.00 16.49           O  
ATOM   1923  CB  SER B1620      33.302  59.928  90.366  1.00 17.89           C  
ATOM   1924  OG  SER B1620      33.325  61.094  91.168  1.00 23.47           O  
ATOM   1925  N   PHE B1621      31.749  57.616  88.825  1.00 16.50           N  
ATOM   1926  CA  PHE B1621      31.775  56.455  87.946  1.00 16.55           C  
ATOM   1927  C   PHE B1621      30.957  56.678  86.681  1.00 15.93           C  
ATOM   1928  O   PHE B1621      31.406  56.370  85.569  1.00 15.77           O  
ATOM   1929  CB  PHE B1621      31.247  55.208  88.683  1.00 16.52           C  
ATOM   1930  CG  PHE B1621      31.190  53.985  87.812  1.00 16.71           C  
ATOM   1931  CD1 PHE B1621      32.297  53.149  87.697  1.00 20.63           C  
ATOM   1932  CD2 PHE B1621      30.042  53.695  87.072  1.00 17.04           C  
ATOM   1933  CE1 PHE B1621      32.253  52.015  86.871  1.00 21.50           C  
ATOM   1934  CE2 PHE B1621      29.986  52.568  86.233  1.00 18.25           C  
ATOM   1935  CZ  PHE B1621      31.098  51.730  86.142  1.00 19.24           C  
ATOM   1936  N   ILE B1622      29.731  57.168  86.862  1.00 14.85           N  
ATOM   1937  CA  ILE B1622      28.810  57.321  85.734  1.00 14.93           C  
ATOM   1938  C   ILE B1622      29.325  58.414  84.782  1.00 14.37           C  
ATOM   1939  O   ILE B1622      29.286  58.218  83.569  1.00 15.08           O  
ATOM   1940  CB  ILE B1622      27.360  57.609  86.193  1.00 15.24           C  
ATOM   1941  CG1 ILE B1622      26.781  56.432  87.007  1.00 16.42           C  
ATOM   1942  CG2 ILE B1622      26.466  57.944  84.990  1.00 15.38           C  
ATOM   1943  CD1 ILE B1622      26.643  55.165  86.229  1.00 16.88           C  
ATOM   1944  N   ASN B1623      29.802  59.539  85.329  1.00 14.42           N  
ATOM   1945  CA  ASN B1623      30.427  60.596  84.500  1.00 14.21           C  
ATOM   1946  C   ASN B1623      31.566  60.035  83.652  1.00 15.82           C  
ATOM   1947  O   ASN B1623      31.663  60.294  82.447  1.00 16.32           O  
ATOM   1948  CB  ASN B1623      30.968  61.742  85.364  1.00 14.30           C  
ATOM   1949  CG  ASN B1623      29.905  62.760  85.728  1.00 15.38           C  
ATOM   1950  OD1 ASN B1623      29.792  63.791  85.083  1.00 18.21           O  
ATOM   1951  ND2 ASN B1623      29.102  62.464  86.757  1.00 17.44           N  
ATOM   1952  N   HIS B1624      32.429  59.248  84.291  1.00 16.06           N  
ATOM   1953  CA  HIS B1624      33.541  58.647  83.559  1.00 18.31           C  
ATOM   1954  C   HIS B1624      33.076  57.720  82.434  1.00 17.98           C  
ATOM   1955  O   HIS B1624      33.601  57.797  81.321  1.00 18.44           O  
ATOM   1956  CB  HIS B1624      34.490  57.899  84.498  1.00 18.41           C  
ATOM   1957  CG  HIS B1624      35.795  57.545  83.859  1.00 23.57           C  
ATOM   1958  ND1 HIS B1624      36.906  58.358  83.933  1.00 27.33           N  
ATOM   1959  CD2 HIS B1624      36.162  56.472  83.122  1.00 26.38           C  
ATOM   1960  CE1 HIS B1624      37.903  57.797  83.274  1.00 26.46           C  
ATOM   1961  NE2 HIS B1624      37.480  56.648  82.778  1.00 27.19           N  
ATOM   1962  N   ARG B1625      32.100  56.855  82.716  1.00 17.89           N  
ATOM   1963  CA  ARG B1625      31.637  55.882  81.713  1.00 18.86           C  
ATOM   1964  C   ARG B1625      30.971  56.582  80.529  1.00 19.19           C  
ATOM   1965  O   ARG B1625      31.204  56.215  79.381  1.00 20.17           O  
ATOM   1966  CB  ARG B1625      30.669  54.841  82.294  1.00 20.33           C  
ATOM   1967  CG  ARG B1625      31.249  53.829  83.256  1.00 24.34           C  
ATOM   1968  CD  ARG B1625      32.052  52.696  82.601  1.00 28.97           C  
ATOM   1969  NE  ARG B1625      31.451  52.109  81.400  1.00 31.35           N  
ATOM   1970  CZ  ARG B1625      30.733  50.988  81.365  1.00 33.16           C  
ATOM   1971  NH1 ARG B1625      30.455  50.280  82.483  1.00 31.78           N  
ATOM   1972  NH2 ARG B1625      30.276  50.573  80.189  1.00 34.42           N  
ATOM   1973  N   ILE B1626      30.148  57.590  80.811  1.00 18.63           N  
ATOM   1974  CA  ILE B1626      29.485  58.321  79.723  1.00 18.33           C  
ATOM   1975  C   ILE B1626      30.502  58.988  78.788  1.00 18.85           C  
ATOM   1976  O   ILE B1626      30.359  58.942  77.551  1.00 18.80           O  
ATOM   1977  CB  ILE B1626      28.446  59.350  80.251  1.00 18.32           C  
ATOM   1978  CG1 ILE B1626      27.265  58.615  80.908  1.00 18.34           C  
ATOM   1979  CG2 ILE B1626      27.949  60.257  79.097  1.00 20.08           C  
ATOM   1980  CD1 ILE B1626      26.341  59.520  81.760  1.00 17.65           C  
ATOM   1981  N   LEU B1627      31.531  59.597  79.360  1.00 19.51           N  
ATOM   1982  CA  LEU B1627      32.434  60.413  78.555  1.00 20.72           C  
ATOM   1983  C   LEU B1627      33.575  59.623  77.937  1.00 22.40           C  
ATOM   1984  O   LEU B1627      34.280  60.135  77.061  1.00 23.53           O  
ATOM   1985  CB  LEU B1627      32.988  61.581  79.372  1.00 20.60           C  
ATOM   1986  CG  LEU B1627      32.014  62.658  79.840  1.00 19.76           C  
ATOM   1987  CD1 LEU B1627      32.734  63.567  80.839  1.00 19.02           C  
ATOM   1988  CD2 LEU B1627      31.425  63.463  78.683  1.00 19.85           C  
ATOM   1989  N   ASN B1628      33.766  58.394  78.403  1.00 23.99           N  
ATOM   1990  CA  ASN B1628      34.843  57.540  77.909  1.00 26.07           C  
ATOM   1991  C   ASN B1628      34.293  56.245  77.339  1.00 26.89           C  
ATOM   1992  O   ASN B1628      33.456  56.268  76.438  1.00 29.59           O  
ATOM   1993  CB  ASN B1628      35.826  57.242  79.027  1.00 25.93           C  
ATOM   1994  CG  ASN B1628      36.556  58.480  79.499  1.00 27.50           C  
ATOM   1995  OD1 ASN B1628      36.184  59.104  80.497  1.00 29.83           O  
ATOM   1996  ND2 ASN B1628      37.599  58.854  78.775  1.00 29.93           N  
TER    1997      ASN B1628                                                      
END
MOLECULE T0496_4_122.pdb
ATOM      1  N   PRO     4      36.250  18.877 100.419  1.00126.33           N  
ATOM      2  CA  PRO     4      36.001  19.915  99.413  1.00124.51           C  
ATOM      3  C   PRO     4      37.048  21.022  99.469  1.00125.13           C  
ATOM      4  O   PRO     4      38.211  20.787  99.138  1.00127.61           O  
ATOM      5  CB  PRO     4      34.632  20.466  99.818  1.00125.32           C  
ATOM      6  CG  PRO     4      33.962  19.327 100.500  1.00121.87           C  
ATOM      7  CD  PRO     4      35.049  18.581 101.220  1.00130.35           C  
ATOM      8  N   VAL     5      36.635  22.214  99.886  1.00119.84           N  
ATOM      9  CA  VAL     5      37.466  23.415  99.734  1.00107.77           C  
ATOM     10  C   VAL     5      38.099  23.855 101.061  1.00100.94           C  
ATOM     11  O   VAL     5      37.438  23.869 102.102  1.00 94.89           O  
ATOM     12  CB  VAL     5      36.652  24.587  99.107  1.00107.75           C  
ATOM     13  CG1 VAL     5      37.577  25.679  98.576  1.00 88.65           C  
ATOM     14  CG2 VAL     5      35.760  24.081  97.980  1.00101.53           C  
ATOM     15  N   SER     6      39.384  24.211 101.004  1.00 99.68           N  
ATOM     16  CA  SER     6      40.148  24.635 102.180  1.00 91.17           C  
ATOM     17  C   SER     6      40.377  26.152 102.243  1.00 85.27           C  
ATOM     18  O   SER     6      40.045  26.881 101.305  1.00 80.81           O  
ATOM     19  CB  SER     6      41.485  23.887 102.244  1.00 92.89           C  
ATOM     20  OG  SER     6      42.256  24.108 101.075  1.00 94.88           O  
ATOM     21  N   VAL     7      40.955  26.603 103.357  1.00 77.69           N  
ATOM     22  CA  VAL     7      41.146  28.027 103.663  1.00 67.00           C  
ATOM     23  C   VAL     7      42.287  28.655 102.855  1.00 73.76           C  
ATOM     24  O   VAL     7      42.125  29.739 102.284  1.00 70.86           O  
ATOM     25  CB  VAL     7      41.386  28.239 105.189  1.00 56.84           C  
ATOM     26  CG1 VAL     7      41.504  29.720 105.535  1.00 44.52           C  
ATOM     27  CG2 VAL     7      40.260  27.609 105.996  1.00 60.50           C  
ATOM     28  N   ASN     8      43.429  27.964 102.811  1.00 79.15           N  
ATOM     29  CA  ASN     8      44.614  28.407 102.064  1.00 82.93           C  
ATOM     30  C   ASN     8      44.353  28.483 100.565  1.00 82.41           C  
ATOM     31  O   ASN     8      44.933  29.314  99.868  1.00 69.82           O  
ATOM     32  CB  ASN     8      45.797  27.466 102.313  1.00 88.19           C  
ATOM     33  CG  ASN     8      45.839  26.934 103.733  1.00114.21           C  
ATOM     34  OD1 ASN     8      46.100  27.681 104.683  1.00130.04           O  
ATOM     35  ND2 ASN     8      45.591  25.630 103.881  1.00130.36           N  
ATOM     36  N   GLU     9      43.480  27.595 100.092  1.00 83.32           N  
ATOM     37  CA  GLU     9      43.007  27.568  98.713  1.00 85.50           C  
ATOM     38  C   GLU     9      42.250  28.849  98.365  1.00 71.59           C  
ATOM     39  O   GLU     9      42.421  29.397  97.276  1.00 49.75           O  
ATOM     40  CB  GLU     9      42.100  26.354  98.514  1.00 91.21           C  
ATOM     41  CG  GLU     9      41.941  25.894  97.075  1.00105.16           C  
ATOM     42  CD  GLU     9      41.154  24.600  96.967  1.00104.81           C  
ATOM     43  OE1 GLU     9      41.478  23.634  97.694  1.00128.20           O  
ATOM     44  OE2 GLU     9      40.215  24.543  96.146  1.00128.75           O  
ATOM     45  N   LYS    10      41.422  29.316  99.301  1.00 64.67           N  
ATOM     46  CA  LYS    10      40.664  30.558  99.143  1.00 50.06           C  
ATOM     47  C   LYS    10      41.562  31.786  99.278  1.00 55.22           C  
ATOM     48  O   LYS    10      41.451  32.721  98.484  1.00 39.45           O  
ATOM     49  CB  LYS    10      39.520  30.630 100.159  1.00 46.21           C  
ATOM     50  CG  LYS    10      38.442  29.572  99.977  1.00 55.81           C  
ATOM     51  CD  LYS    10      37.454  29.599 101.131  1.00 24.13           C  
ATOM     52  CE  LYS    10      36.592  28.342 101.154  1.00 39.89           C  
ATOM     53  NZ  LYS    10      35.728  28.288 102.368  1.00 67.89           N  
ATOM     54  N   LYS    11      42.441  31.767 100.285  1.00 48.64           N  
ATOM     55  CA  LYS    11      43.408  32.842 100.546  1.00 45.25           C  
ATOM     56  C   LYS    11      44.308  33.122  99.349  1.00 49.17           C  
ATOM     57  O   LYS    11      44.501  34.277  98.962  1.00 43.86           O  
ATOM     58  CB  LYS    11      44.301  32.484 101.735  1.00 39.85           C  
ATOM     59  CG  LYS    11      43.695  32.691 103.103  1.00 57.76           C  
ATOM     60  CD  LYS    11      44.805  32.720 104.140  1.00  5.48           C  
ATOM     61  CE  LYS    11      44.286  32.363 105.520  1.00 66.84           C  
ATOM     62  NZ  LYS    11      45.381  32.369 106.532  1.00 74.77           N  
ATOM     63  N   ASP    12      44.853  32.051  98.775  1.00 52.53           N  
ATOM     64  CA  ASP    12      45.754  32.147  97.633  1.00 66.79           C  
ATOM     65  C   ASP    12      45.012  32.497  96.345  1.00 62.97           C  
ATOM     66  O   ASP    12      45.597  33.094  95.440  1.00 55.08           O  
ATOM     67  CB  ASP    12      46.544  30.850  97.456  1.00 73.82           C  
ATOM     68  CG  ASP    12      47.718  31.008  96.517  1.00102.22           C  
ATOM     69  OD1 ASP    12      47.613  30.542  95.362  1.00130.59           O  
ATOM     70  OD2 ASP    12      48.736  31.612  96.923  1.00119.67           O  
ATOM     71  N   PHE    13      43.734  32.119  96.267  1.00 66.99           N  
ATOM     72  CA  PHE    13      42.888  32.486  95.130  1.00 56.84           C  
ATOM     73  C   PHE    13      42.672  33.996  95.059  1.00 54.17           C  
ATOM     74  O   PHE    13      42.798  34.584  93.985  1.00 38.21           O  
ATOM     75  CB  PHE    13      41.537  31.755  95.161  1.00 35.95           C  
ATOM     76  CG  PHE    13      40.511  32.338  94.224  1.00 61.09           C  
ATOM     77  CD1 PHE    13      40.651  32.202  92.844  1.00 70.08           C  
ATOM     78  CD2 PHE    13      39.413  33.037  94.720  1.00 81.31           C  
ATOM     79  CE1 PHE    13      39.715  32.753  91.977  1.00 61.10           C  
ATOM     80  CE2 PHE    13      38.471  33.588  93.858  1.00 74.91           C  
ATOM     81  CZ  PHE    13      38.622  33.444  92.486  1.00 61.44           C  
ATOM     82  N   VAL    14      42.344  34.606  96.199  1.00 49.01           N  
ATOM     83  CA  VAL    14      42.154  36.059  96.301  1.00 48.53           C  
ATOM     84  C   VAL    14      43.472  36.787  96.023  1.00 51.26           C  
ATOM     85  O   VAL    14      43.491  37.814  95.335  1.00 35.61           O  
ATOM     86  CB  VAL    14      41.587  36.474  97.689  1.00 49.32           C  
ATOM     87  CG1 VAL    14      41.388  37.982  97.783  1.00 40.40           C  
ATOM     88  CG2 VAL    14      40.276  35.779  97.958  1.00 45.96           C  
ATOM     89  N   LYS    15      44.565  36.228  96.546  1.00 53.00           N  
ATOM     90  CA  LYS    15      45.920  36.723  96.294  1.00 57.32           C  
ATOM     91  C   LYS    15      46.273  36.674  94.803  1.00 57.75           C  
ATOM     92  O   LYS    15      46.907  37.596  94.283  1.00 61.78           O  
ATOM     93  CB  LYS    15      46.940  35.919  97.110  1.00 54.99           C  
ATOM     94  CG  LYS    15      48.342  36.520  97.148  1.00 70.96           C  
ATOM     95  CD  LYS    15      49.350  35.544  97.737  1.00 94.48           C  
ATOM     96  CE  LYS    15      50.767  36.092  97.648  1.00102.05           C  
ATOM     97  NZ  LYS    15      51.775  35.124  98.168  1.00 93.67           N  
ATOM     98  N   TRP    16      45.853  35.603  94.126  1.00 58.07           N  
ATOM     99  CA  TRP    16      46.032  35.474  92.679  1.00 64.97           C  
ATOM    100  C   TRP    16      45.142  36.446  91.907  1.00 55.53           C  
ATOM    101  O   TRP    16      45.617  37.138  91.003  1.00 49.84           O  
ATOM    102  CB  TRP    16      45.759  34.038  92.213  1.00 77.49           C  
ATOM    103  CG  TRP    16      45.646  33.907  90.716  1.00 93.75           C  
ATOM    104  CD1 TRP    16      46.675  33.872  89.818  1.00 94.66           C  
ATOM    105  CD2 TRP    16      44.438  33.804  89.946  1.00110.74           C  
ATOM    106  NE1 TRP    16      46.186  33.752  88.539  1.00 85.41           N  
ATOM    107  CE2 TRP    16      44.817  33.709  88.588  1.00106.09           C  
ATOM    108  CE3 TRP    16      43.073  33.788  90.272  1.00108.96           C  
ATOM    109  CZ2 TRP    16      43.882  33.593  87.554  1.00 92.48           C  
ATOM    110  CZ3 TRP    16      42.143  33.670  89.243  1.00 88.27           C  
ATOM    111  CH2 TRP    16      42.554  33.575  87.900  1.00 91.46           C  
ATOM    112  N   PHE    17      43.857  36.477  92.268  1.00 52.15           N  
ATOM    113  CA  PHE    17      42.840  37.278  91.577  1.00 46.03           C  
ATOM    114  C   PHE    17      43.159  38.772  91.558  1.00 45.00           C  
ATOM    115  O   PHE    17      43.011  39.429  90.525  1.00 39.80           O  
ATOM    116  CB  PHE    17      41.450  37.032  92.190  1.00 37.75           C  
ATOM    117  CG  PHE    17      40.401  38.012  91.736  1.00 44.98           C  
ATOM    118  CD1 PHE    17      39.874  37.940  90.451  1.00 34.59           C  
ATOM    119  CD2 PHE    17      39.940  39.008  92.595  1.00 52.39           C  
ATOM    120  CE1 PHE    17      38.912  38.849  90.024  1.00 36.78           C  
ATOM    121  CE2 PHE    17      38.978  39.920  92.176  1.00 46.87           C  
ATOM    122  CZ  PHE    17      38.461  39.839  90.888  1.00 46.11           C  
ATOM    123  N   LEU    18      43.600  39.292  92.702  1.00 48.42           N  
ATOM    124  CA  LEU    18      43.920  40.713  92.846  1.00 54.75           C  
ATOM    125  C   LEU    18      45.206  41.112  92.125  1.00 64.57           C  
ATOM    126  O   LEU    18      45.377  42.274  91.748  1.00 70.78           O  
ATOM    127  CB  LEU    18      44.001  41.100  94.327  1.00 53.04           C  
ATOM    128  CG  LEU    18      42.683  41.160  95.107  1.00 47.69           C  
ATOM    129  CD1 LEU    18      42.960  41.302  96.595  1.00 23.90           C  
ATOM    130  CD2 LEU    18      41.809  42.310  94.614  1.00 37.79           C  
ATOM    131  N   ASN    19      46.100  40.145  91.934  1.00 71.72           N  
ATOM    132  CA  ASN    19      47.373  40.376  91.254  1.00 74.85           C  
ATOM    133  C   ASN    19      47.278  40.265  89.729  1.00 67.96           C  
ATOM    134  O   ASN    19      48.226  40.604  89.015  1.00 75.30           O  
ATOM    135  CB  ASN    19      48.447  39.421  91.793  1.00 75.25           C  
ATOM    136  CG  ASN    19      49.049  39.894  93.110  1.00105.13           C  
ATOM    137  OD1 ASN    19      50.229  40.248  93.166  1.00124.46           O  
ATOM    138  ND2 ASN    19      48.242  39.905  94.174  1.00113.30           N  
ATOM    139  N   ASN    20      46.130  39.801  89.239  1.00 68.40           N  
ATOM    140  CA  ASN    20      45.927  39.568  87.810  1.00 67.61           C  
ATOM    141  C   ASN    20      44.795  40.397  87.201  1.00 72.51           C  
ATOM    142  O   ASN    20      44.790  40.656  85.994  1.00 70.43           O  
ATOM    143  CB  ASN    20      45.693  38.077  87.538  1.00 59.20           C  
ATOM    144  CG  ASN    20      46.964  37.248  87.658  1.00 75.65           C  
ATOM    145  OD1 ASN    20      47.535  36.826  86.652  1.00101.51           O  
ATOM    146  ND2 ASN    20      47.412  37.011  88.887  1.00 92.03           N  
ATOM    147  N   TYR    21      43.845  40.809  88.038  1.00 72.03           N  
ATOM    148  CA  TYR    21      42.660  41.533  87.576  1.00 63.08           C  
ATOM    149  C   TYR    21      42.437  42.823  88.360  1.00 62.42           C  
ATOM    150  O   TYR    21      42.660  42.873  89.573  1.00 73.78           O  
ATOM    151  CB  TYR    21      41.415  40.639  87.653  1.00 66.80           C  
ATOM    152  CG  TYR    21      41.537  39.350  86.866  1.00 63.40           C  
ATOM    153  CD1 TYR    21      41.920  38.163  87.492  1.00 63.16           C  
ATOM    154  CD2 TYR    21      41.280  39.319  85.495  1.00 52.50           C  
ATOM    155  CE1 TYR    21      42.041  36.979  86.775  1.00 62.89           C  
ATOM    156  CE2 TYR    21      41.398  38.137  84.769  1.00 69.94           C  
ATOM    157  CZ  TYR    21      41.780  36.973  85.416  1.00 76.20           C  
ATOM    158  OH  TYR    21      41.898  35.800  84.708  1.00 81.40           O  
ATOM    159  N   GLN    22      41.995  43.861  87.653  1.00 51.11           N  
ATOM    160  CA  GLN    22      41.745  45.169  88.250  1.00 52.42           C  
ATOM    161  C   GLN    22      40.249  45.389  88.468  1.00 57.96           C  
ATOM    162  O   GLN    22      39.487  45.488  87.504  1.00 53.40           O  
ATOM    163  CB  GLN    22      42.336  46.276  87.365  1.00 47.18           C  
ATOM    164  CG  GLN    22      42.085  47.709  87.842  1.00 69.65           C  
ATOM    165  CD  GLN    22      43.001  48.131  88.978  1.00102.66           C  
ATOM    166  OE1 GLN    22      42.801  47.750  90.132  1.00106.07           O  
ATOM    167  NE2 GLN    22      44.004  48.940  88.656  1.00112.87           N  
ATOM    168  N   LEU    23      39.844  45.461  89.735  1.00 57.15           N  
ATOM    169  CA  LEU    23      38.442  45.683  90.103  1.00 50.60           C  
ATOM    170  C   LEU    23      37.989  47.107  89.782  1.00 48.31           C  
ATOM    171  O   LEU    23      38.782  48.049  89.859  1.00 46.36           O  
ATOM    172  CB  LEU    23      38.205  45.361  91.586  1.00 37.08           C  
ATOM    173  CG  LEU    23      38.211  43.888  92.022  1.00 29.17           C  
ATOM    174  CD1 LEU    23      38.286  43.767  93.536  1.00 27.93           C  
ATOM    175  CD2 LEU    23      36.996  43.131  91.492  1.00 49.92           C  
ATOM    176  N   LYS    24      36.715  47.242  89.409  1.00 42.88           N  
ATOM    177  CA  LYS    24      36.118  48.529  89.034  1.00 60.04           C  
ATOM    178  C   LYS    24      36.082  49.526  90.187  1.00 66.54           C  
ATOM    179  O   LYS    24      36.366  50.712  90.000  1.00 67.76           O  
ATOM    180  CB  LYS    24      34.702  48.329  88.489  1.00 60.30           C  
ATOM    181  CG  LYS    24      34.637  48.073  86.999  1.00 65.66           C  
ATOM    182  CD  LYS    24      33.203  47.933  86.519  1.00 74.26           C  
ATOM    183  CE  LYS    24      33.144  47.745  85.013  1.00 60.22           C  
ATOM    184  NZ  LYS    24      31.741  47.687  84.520  1.00 63.42           N  
ATOM    185  N   GLN    25      35.730  49.037  91.372  1.00 64.06           N  
ATOM    186  CA  GLN    25      35.673  49.873  92.562  1.00 54.75           C  
ATOM    187  C   GLN    25      36.805  49.501  93.519  1.00 55.82           C  
ATOM    188  O   GLN    25      37.046  48.321  93.786  1.00 55.35           O  
ATOM    189  CB  GLN    25      34.301  49.761  93.229  1.00 61.23           C  
ATOM    190  CG  GLN    25      33.994  50.859  94.234  1.00 68.73           C  
ATOM    191  CD  GLN    25      32.516  51.197  94.290  1.00 73.24           C  
ATOM    192  OE1 GLN    25      31.818  50.831  95.235  1.00103.95           O  
ATOM    193  NE2 GLN    25      32.030  51.896  93.268  1.00 97.79           N  
ATOM    194  N   ARG    26      37.491  50.529  94.014  1.00 40.57           N  
ATOM    195  CA  ARG    26      38.721  50.380  94.795  1.00 27.79           C  
ATOM    196  C   ARG    26      38.507  49.778  96.185  1.00 33.96           C  
ATOM    197  O   ARG    26      39.371  49.067  96.700  1.00 47.26           O  
ATOM    198  CB  ARG    26      39.425  51.735  94.905  1.00 25.04           C  
ATOM    199  CG  ARG    26      40.865  51.676  95.394  1.00 27.91           C  
ATOM    200  CD  ARG    26      41.569  53.000  95.184  1.00 53.62           C  
ATOM    201  NE  ARG    26      40.876  54.113  95.832  1.00 72.82           N  
ATOM    202  CZ  ARG    26      41.003  55.383  95.462  1.00 63.56           C  
ATOM    203  NH1 ARG    26      41.793  55.698  94.445  1.00 19.76           N  
ATOM    204  NH2 ARG    26      40.339  56.336  96.103  1.00 56.62           N  
ATOM    205  N   GLU    27      37.352  50.059  96.782  1.00 24.81           N  
ATOM    206  CA  GLU    27      37.032  49.564  98.126  1.00 28.34           C  
ATOM    207  C   GLU    27      36.711  48.069  98.165  1.00 20.31           C  
ATOM    208  O   GLU    27      36.733  47.457  99.232  1.00  8.99           O  
ATOM    209  CB  GLU    27      35.923  50.398  98.793  1.00 15.34           C  
ATOM    210  CG  GLU    27      35.043  51.220  97.848  1.00 60.22           C  
ATOM    211  CD  GLU    27      35.609  52.602  97.542  1.00 74.48           C  
ATOM    212  OE1 GLU    27      35.664  52.969  96.349  1.00 78.12           O  
ATOM    213  OE2 GLU    27      36.002  53.317  98.489  1.00 62.62           O  
ATOM    214  N   CYS    28      36.439  47.490  96.996  1.00  3.93           N  
ATOM    215  CA  CYS    28      36.234  46.049  96.841  1.00 36.87           C  
ATOM    216  C   CYS    28      37.543  45.272  96.980  1.00 39.48           C  
ATOM    217  O   CYS    28      37.543  44.112  97.402  1.00 40.62           O  
ATOM    218  CB  CYS    28      35.604  45.752  95.483  1.00 32.52           C  
ATOM    219  SG  CYS    28      34.088  46.672  95.157  1.00 64.11           S  
ATOM    220  N   VAL    29      38.647  45.920  96.603  1.00 26.07           N  
ATOM    221  CA  VAL    29      40.000  45.398  96.811  1.00 33.41           C  
ATOM    222  C   VAL    29      40.289  45.353  98.313  1.00 40.89           C  
ATOM    223  O   VAL    29      40.858  44.381  98.816  1.00 29.88           O  
ATOM    224  CB  VAL    29      41.071  46.276  96.090  1.00 18.96           C  
ATOM    225  CG1 VAL    29      42.470  45.681  96.219  1.00 42.64           C  
ATOM    226  CG2 VAL    29      40.717  46.479  94.621  1.00 12.99           C  
ATOM    227  N   TRP    30      39.866  46.402  99.018  1.00 35.56           N  
ATOM    228  CA  TRP    30      40.076  46.520 100.461  1.00 28.30           C  
ATOM    229  C   TRP    30      39.164  45.602 101.267  1.00 34.00           C  
ATOM    230  O   TRP    30      39.520  45.204 102.376  1.00 24.65           O  
ATOM    231  CB  TRP    30      39.916  47.971 100.929  1.00 19.25           C  
ATOM    232  CG  TRP    30      40.816  48.950 100.224  1.00 39.94           C  
ATOM    233  CD1 TRP    30      42.044  48.696  99.675  1.00 32.48           C  
ATOM    234  CD2 TRP    30      40.568  50.347 100.017  1.00 35.28           C  
ATOM    235  NE1 TRP    30      42.563  49.839  99.122  1.00 33.05           N  
ATOM    236  CE2 TRP    30      41.683  50.870  99.323  1.00 36.64           C  
ATOM    237  CE3 TRP    30      39.512  51.207 100.348  1.00  9.12           C  
ATOM    238  CZ2 TRP    30      41.772  52.215  98.952  1.00 32.40           C  
ATOM    239  CZ3 TRP    30      39.600  52.546  99.976  1.00 19.31           C  
ATOM    240  CH2 TRP    30      40.723  53.035  99.285  1.00 42.28           C  
ATOM    241  N   ILE    31      37.991  45.286 100.712  1.00 32.16           N  
ATOM    242  CA  ILE    31      37.098  44.271 101.279  1.00 29.88           C  
ATOM    243  C   ILE    31      37.771  42.895 101.188  1.00 29.23           C  
ATOM    244  O   ILE    31      37.806  42.149 102.170  1.00 29.23           O  
ATOM    245  CB  ILE    31      35.701  44.267 100.576  1.00 37.41           C  
ATOM    246  CG1 ILE    31      34.868  45.475 101.018  1.00 31.27           C  
ATOM    247  CG2 ILE    31      34.924  42.980 100.874  1.00  2.00           C  
ATOM    248  CD1 ILE    31      33.747  45.854 100.060  1.00 38.02           C  
ATOM    249  N   LEU    32      38.329  42.591 100.015  1.00 36.37           N  
ATOM    250  CA  LEU    32      39.024  41.323  99.766  1.00 28.05           C  
ATOM    251  C   LEU    32      40.318  41.163 100.564  1.00 32.19           C  
ATOM    252  O   LEU    32      40.619  40.065 101.043  1.00 25.56           O  
ATOM    253  CB  LEU    32      39.316  41.145  98.272  1.00 11.59           C  
ATOM    254  CG  LEU    32      38.190  40.639  97.368  1.00 40.82           C  
ATOM    255  CD1 LEU    32      38.606  40.702  95.907  1.00 31.11           C  
ATOM    256  CD2 LEU    32      37.744  39.224  97.735  1.00 16.32           C  
ATOM    257  N   ASN    33      41.076  42.253 100.694  1.00 33.88           N  
ATOM    258  CA  ASN    33      42.309  42.269 101.487  1.00 41.02           C  
ATOM    259  C   ASN    33      42.045  42.119 102.982  1.00 48.35           C  
ATOM    260  O   ASN    33      42.861  41.544 103.708  1.00 42.87           O  
ATOM    261  CB  ASN    33      43.105  43.553 101.236  1.00 38.12           C  
ATOM    262  CG  ASN    33      43.837  43.545  99.906  1.00 28.78           C  
ATOM    263  OD1 ASN    33      44.367  42.520  99.475  1.00 60.55           O  
ATOM    264  ND2 ASN    33      43.887  44.702  99.258  1.00 57.45           N  
ATOM    265  N   TYR    34      40.908  42.656 103.427  1.00 42.24           N  
ATOM    266  CA  TYR    34      40.432  42.500 104.800  1.00 36.83           C  
ATOM    267  C   TYR    34      40.098  41.038 105.079  1.00 23.18           C  
ATOM    268  O   TYR    34      40.462  40.503 106.126  1.00 16.66           O  
ATOM    269  CB  TYR    34      39.197  43.378 105.027  1.00 41.90           C  
ATOM    270  CG  TYR    34      38.520  43.229 106.374  1.00 22.34           C  
ATOM    271  CD1 TYR    34      38.973  43.939 107.484  1.00 28.54           C  
ATOM    272  CD2 TYR    34      37.408  42.398 106.533  1.00 27.86           C  
ATOM    273  CE1 TYR    34      38.350  43.812 108.720  1.00  4.43           C  
ATOM    274  CE2 TYR    34      36.781  42.262 107.766  1.00 43.11           C  
ATOM    275  CZ  TYR    34      37.257  42.972 108.855  1.00 35.09           C  
ATOM    276  OH  TYR    34      36.639  42.845 110.078  1.00 54.06           O  
ATOM    277  N   LEU    35      39.403  40.407 104.134  1.00 24.05           N  
ATOM    278  CA  LEU    35      38.988  39.012 104.264  1.00 40.94           C  
ATOM    279  C   LEU    35      40.166  38.045 104.184  1.00 38.13           C  
ATOM    280  O   LEU    35      40.156  37.005 104.841  1.00 37.34           O  
ATOM    281  CB  LEU    35      37.922  38.662 103.220  1.00 42.89           C  
ATOM    282  CG  LEU    35      36.547  39.306 103.438  1.00 42.92           C  
ATOM    283  CD1 LEU    35      35.752  39.347 102.143  1.00 49.87           C  
ATOM    284  CD2 LEU    35      35.763  38.605 104.543  1.00 59.35           C  
ATOM    285  N   MET    36      41.175  38.399 103.385  1.00 34.40           N  
ATOM    286  CA  MET    36      42.427  37.636 103.305  1.00 46.16           C  
ATOM    287  C   MET    36      43.219  37.656 104.610  1.00 50.13           C  
ATOM    288  O   MET    36      43.874  36.672 104.960  1.00 60.87           O  
ATOM    289  CB  MET    36      43.315  38.160 102.175  1.00 42.82           C  
ATOM    290  CG  MET    36      43.368  37.261 100.955  1.00 48.71           C  
ATOM    291  SD  MET    36      44.881  37.467  99.986  1.00 60.10           S  
ATOM    292  CE  MET    36      44.640  39.097  99.278  1.00 16.43           C  
ATOM    293  N   SER    37      43.153  38.781 105.317  1.00 42.11           N  
ATOM    294  CA  SER    37      43.859  38.960 106.582  1.00 36.76           C  
ATOM    295  C   SER    37      43.206  38.197 107.734  1.00 37.15           C  
ATOM    296  O   SER    37      43.880  37.823 108.697  1.00 53.92           O  
ATOM    297  CB  SER    37      43.943  40.445 106.928  1.00 18.16           C  
ATOM    298  OG  SER    37      44.692  40.659 108.113  1.00 32.55           O  
ATOM    299  N   HIS    38      41.899  37.971 107.629  1.00 44.07           N  
ATOM    300  CA  HIS    38      41.138  37.305 108.681  1.00 38.86           C  
ATOM    301  C   HIS    38      40.825  35.861 108.290  1.00 42.18           C  
ATOM    302  O   HIS    38      39.936  35.604 107.473  1.00 55.60           O  
ATOM    303  CB  HIS    38      39.861  38.094 108.994  1.00 26.86           C  
ATOM    304  CG  HIS    38      40.118  39.468 109.535  1.00 33.91           C  
ATOM    305  ND1 HIS    38      40.550  40.511 108.745  1.00 26.80           N  
ATOM    306  CD2 HIS    38      40.005  39.969 110.788  1.00 16.28           C  
ATOM    307  CE1 HIS    38      40.698  41.592 109.488  1.00 39.50           C  
ATOM    308  NE2 HIS    38      40.369  41.292 110.731  1.00 34.08           N  
ATOM    309  N   ASP    39      41.570  34.926 108.877  1.00 42.22           N  
ATOM    310  CA  ASP    39      41.487  33.505 108.508  1.00 57.50           C  
ATOM    311  C   ASP    39      40.239  32.755 108.989  1.00 50.55           C  
ATOM    312  O   ASP    39      39.903  31.705 108.434  1.00 54.74           O  
ATOM    313  CB  ASP    39      42.773  32.732 108.877  1.00 58.09           C  
ATOM    314  CG  ASP    39      43.669  33.483 109.855  1.00101.47           C  
ATOM    315  OD1 ASP    39      44.908  33.492 109.630  1.00113.01           O  
ATOM    316  OD2 ASP    39      43.151  34.059 110.842  1.00137.21           O  
ATOM    317  N   GLN    40      39.555  33.273 110.007  1.00 52.26           N  
ATOM    318  CA  GLN    40      38.258  32.696 110.392  1.00 59.48           C  
ATOM    319  C   GLN    40      37.060  33.448 109.802  1.00 61.27           C  
ATOM    320  O   GLN    40      35.904  33.139 110.110  1.00 51.95           O  
ATOM    321  CB  GLN    40      38.134  32.455 111.912  1.00 52.01           C  
ATOM    322  CG  GLN    40      38.868  33.458 112.809  1.00 76.20           C  
ATOM    323  CD  GLN    40      39.624  32.719 113.944  1.00 91.61           C  
ATOM    324  OE1 GLN    40      40.507  33.294 114.589  1.00 83.79           O  
ATOM    325  NE2 GLN    40      39.287  31.442 114.185  1.00106.56           N  
ATOM    326  N   LEU    41      37.353  34.431 108.953  1.00 66.52           N  
ATOM    327  CA  LEU    41      36.367  34.944 108.006  1.00 67.80           C  
ATOM    328  C   LEU    41      36.392  34.058 106.766  1.00 70.55           C  
ATOM    329  O   LEU    41      35.342  33.755 106.197  1.00 75.93           O  
ATOM    330  CB  LEU    41      36.654  36.403 107.621  1.00 78.53           C  
ATOM    331  CG  LEU    41      35.895  37.555 108.301  1.00 73.60           C  
ATOM    332  CD1 LEU    41      34.390  37.484 108.038  1.00 46.01           C  
ATOM    333  CD2 LEU    41      36.183  37.616 109.797  1.00 73.23           C  
ATOM    334  N   MET    42      37.595  33.627 106.378  1.00 56.00           N  
ATOM    335  CA  MET    42      37.808  32.775 105.199  1.00 57.81           C  
ATOM    336  C   MET    42      37.240  31.360 105.324  1.00 69.74           C  
ATOM    337  O   MET    42      37.038  30.683 104.313  1.00 74.92           O  
ATOM    338  CB  MET    42      39.293  32.719 104.825  1.00 48.73           C  
ATOM    339  CG  MET    42      39.756  33.857 103.932  1.00 26.11           C  
ATOM    340  SD  MET    42      38.932  33.896 102.326  1.00 46.81           S  
ATOM    341  CE  MET    42      39.502  35.472 101.695  1.00 20.11           C  
ATOM    342  N   HIS    43      37.006  30.916 106.560  1.00 77.46           N  
ATOM    343  CA  HIS    43      36.227  29.708 106.828  1.00 81.40           C  
ATOM    344  C   HIS    43      34.802  29.904 106.332  1.00 77.35           C  
ATOM    345  O   HIS    43      34.234  29.036 105.665  1.00 81.45           O  
ATOM    346  CB  HIS    43      36.169  29.422 108.331  1.00 92.98           C  
ATOM    347  CG  HIS    43      37.329  28.635 108.852  1.00115.47           C  
ATOM    348  ND1 HIS    43      38.190  29.129 109.810  1.00123.92           N  
ATOM    349  CD2 HIS    43      37.760  27.384 108.565  1.00132.13           C  
ATOM    350  CE1 HIS    43      39.108  28.220 110.081  1.00129.28           C  
ATOM    351  NE2 HIS    43      38.871  27.152 109.340  1.00131.76           N  
ATOM    352  N   LYS    44      34.243  31.066 106.666  1.00 73.33           N  
ATOM    353  CA  LYS    44      32.857  31.404 106.366  1.00 61.04           C  
ATOM    354  C   LYS    44      32.678  32.023 104.976  1.00 57.30           C  
ATOM    355  O   LYS    44      31.551  32.189 104.508  1.00 69.14           O  
ATOM    356  CB  LYS    44      32.298  32.335 107.448  1.00 58.50           C  
ATOM    357  CG  LYS    44      32.146  31.683 108.818  1.00 46.12           C  
ATOM    358  CD  LYS    44      31.729  32.697 109.876  1.00 62.71           C  
ATOM    359  CE  LYS    44      31.584  32.047 111.249  1.00 86.47           C  
ATOM    360  NZ  LYS    44      32.894  31.607 111.823  1.00104.81           N  
ATOM    361  N   VAL    45      33.789  32.365 104.325  1.00 47.83           N  
ATOM    362  CA  VAL    45      33.767  32.889 102.957  1.00 54.28           C  
ATOM    363  C   VAL    45      33.536  31.748 101.963  1.00 57.64           C  
ATOM    364  O   VAL    45      34.229  30.726 102.003  1.00 64.15           O  
ATOM    365  CB  VAL    45      35.068  33.693 102.629  1.00 44.32           C  
ATOM    366  CG1 VAL    45      35.346  33.757 101.125  1.00 51.43           C  
ATOM    367  CG2 VAL    45      34.979  35.101 103.199  1.00 59.36           C  
ATOM    368  N   HIS    46      32.541  31.921 101.094  1.00 52.06           N  
ATOM    369  CA  HIS    46      32.242  30.946 100.051  1.00 44.49           C  
ATOM    370  C   HIS    46      32.204  31.604  98.678  1.00 53.29           C  
ATOM    371  O   HIS    46      31.514  32.606  98.478  1.00 65.04           O  
ATOM    372  CB  HIS    46      30.912  30.242 100.331  1.00 36.82           C  
ATOM    373  CG  HIS    46      30.851  29.573 101.668  1.00 36.12           C  
ATOM    374  ND1 HIS    46      31.564  28.430 101.960  1.00 72.73           N  
ATOM    375  CD2 HIS    46      30.161  29.883 102.791  1.00 67.78           C  
ATOM    376  CE1 HIS    46      31.318  28.067 103.206  1.00 76.73           C  
ATOM    377  NE2 HIS    46      30.470  28.932 103.733  1.00 68.01           N  
ATOM    378  N   PHE    47      32.956  31.037  97.738  1.00 56.48           N  
ATOM    379  CA  PHE    47      32.956  31.526  96.363  1.00 61.28           C  
ATOM    380  C   PHE    47      31.879  30.823  95.549  1.00 58.84           C  
ATOM    381  O   PHE    47      31.816  29.594  95.506  1.00 62.21           O  
ATOM    382  CB  PHE    47      34.349  31.429  95.740  1.00 65.70           C  
ATOM    383  CG  PHE    47      35.332  32.390  96.345  1.00 59.38           C  
ATOM    384  CD1 PHE    47      36.184  31.983  97.368  1.00 64.32           C  
ATOM    385  CD2 PHE    47      35.381  33.715  95.919  1.00 51.39           C  
ATOM    386  CE1 PHE    47      37.083  32.874  97.941  1.00 82.12           C  
ATOM    387  CE2 PHE    47      36.275  34.611  96.490  1.00 40.37           C  
ATOM    388  CZ  PHE    47      37.125  34.189  97.501  1.00 63.01           C  
ATOM    389  N   VAL    48      31.027  31.628  94.918  1.00 55.73           N  
ATOM    390  CA  VAL    48      29.686  31.201  94.521  1.00 48.33           C  
ATOM    391  C   VAL    48      29.289  31.869  93.194  1.00 46.26           C  
ATOM    392  O   VAL    48      29.760  32.964  92.892  1.00 54.94           O  
ATOM    393  CB  VAL    48      28.691  31.499  95.719  1.00 51.09           C  
ATOM    394  CG1 VAL    48      27.323  32.038  95.289  1.00 66.36           C  
ATOM    395  CG2 VAL    48      28.538  30.277  96.614  1.00 25.83           C  
ATOM    396  N   GLU    49      28.443  31.203  92.407  0.50 40.44           N  
ATOM    398  CA  GLU    49      27.781  31.851  91.274  0.50 38.59           C  
ATOM    400  C   GLU    49      26.316  32.151  91.594  0.50 38.61           C  
ATOM    402  O   GLU    49      25.588  31.292  92.094  0.50 23.18           O  
ATOM    404  CB  GLU    49      27.906  31.014  89.999  0.50 39.79           C  
ATOM    406  CG  GLU    49      29.260  31.147  89.313  0.50 32.47           C  
ATOM    408  CD  GLU    49      29.242  30.675  87.871  0.50 47.37           C  
ATOM    410  OE1 GLU    49      28.857  29.512  87.621  0.50 67.13           O  
ATOM    412  OE2 GLU    49      29.625  31.468  86.984  0.50 41.08           O  
ATOM    414  N   HIS    50      25.893  33.378  91.305  0.50 35.51           N  
ATOM    416  CA  HIS    50      24.555  33.838  91.665  0.50 37.04           C  
ATOM    418  C   HIS    50      24.477  34.066  93.175  0.50 39.05           C  
ATOM    420  O   HIS    50      23.753  33.370  93.889  0.50 45.49           O  
ATOM    422  CB  HIS    50      23.483  32.836  91.220  0.50 33.33           C  
ATOM    424  CG  HIS    50      23.660  32.328  89.823  0.50 30.55           C  
ATOM    426  ND1 HIS    50      23.963  31.012  89.545  0.50 43.39           N  
ATOM    428  CD2 HIS    50      23.575  32.956  88.625  0.50 24.25           C  
ATOM    430  CE1 HIS    50      24.057  30.850  88.238  0.50 47.64           C  
ATOM    432  NE2 HIS    50      23.826  32.015  87.656  0.50 42.44           N  
ATOM    434  N   ALA    51      25.227  35.053  93.655  0.50 45.35           N  
ATOM    436  CA  ALA    51      25.294  35.347  95.086  0.50 48.89           C  
ATOM    438  C   ALA    51      24.154  36.246  95.576  0.50 51.83           C  
ATOM    440  O   ALA    51      24.079  36.574  96.762  0.50 53.16           O  
ATOM    442  CB  ALA    51      26.649  35.958  95.435  0.50 49.32           C  
ATOM    444  N   LYS    52      23.264  36.625  94.660  1.00 58.57           N  
ATOM    445  CA  LYS    52      22.124  37.506  94.966  1.00 54.64           C  
ATOM    446  C   LYS    52      21.017  36.826  95.781  1.00 46.90           C  
ATOM    447  O   LYS    52      20.208  37.496  96.427  1.00 46.97           O  
ATOM    448  CB  LYS    52      21.546  38.104  93.674  1.00 44.05           C  
ATOM    449  CG  LYS    52      21.045  37.074  92.661  1.00 66.73           C  
ATOM    450  CD  LYS    52      20.582  37.740  91.380  1.00 82.91           C  
ATOM    451  CE  LYS    52      19.977  36.734  90.415  1.00 97.19           C  
ATOM    452  NZ  LYS    52      19.523  37.389  89.153  1.00115.97           N  
ATOM    453  N   TYR    53      21.001  35.495  95.745  1.00 37.98           N  
ATOM    454  CA  TYR    53      20.046  34.682  96.491  1.00 37.72           C  
ATOM    455  C   TYR    53      20.497  34.436  97.934  1.00 45.31           C  
ATOM    456  O   TYR    53      19.725  33.933  98.754  1.00 54.77           O  
ATOM    457  CB  TYR    53      19.845  33.337  95.786  1.00 46.24           C  
ATOM    458  CG  TYR    53      19.406  33.437  94.341  1.00 72.72           C  
ATOM    459  CD1 TYR    53      18.073  33.684  94.014  1.00 81.57           C  
ATOM    460  CD2 TYR    53      20.320  33.270  93.300  1.00 82.33           C  
ATOM    461  CE1 TYR    53      17.662  33.773  92.688  1.00 71.14           C  
ATOM    462  CE2 TYR    53      19.918  33.357  91.970  1.00 86.46           C  
ATOM    463  CZ  TYR    53      18.588  33.608  91.672  1.00 63.48           C  
ATOM    464  OH  TYR    53      18.186  33.695  90.359  1.00 81.98           O  
ATOM    465  N   CYS    54      21.742  34.800  98.236  1.00 49.67           N  
ATOM    466  CA  CYS    54      22.366  34.482  99.519  1.00 56.54           C  
ATOM    467  C   CYS    54      22.061  35.511 100.615  1.00 60.03           C  
ATOM    468  O   CYS    54      21.984  36.708 100.328  1.00 67.34           O  
ATOM    469  CB  CYS    54      23.878  34.329  99.335  1.00 51.50           C  
ATOM    470  SG  CYS    54      24.343  33.106  98.085  1.00 97.57           S  
ATOM    471  N   PRO    55      21.869  35.038 101.870  1.00 58.20           N  
ATOM    472  CA  PRO    55      21.696  35.838 103.093  1.00 59.98           C  
ATOM    473  C   PRO    55      22.735  36.943 103.312  1.00 67.06           C  
ATOM    474  O   PRO    55      22.407  37.977 103.897  1.00 85.49           O  
ATOM    475  CB  PRO    55      21.791  34.793 104.223  1.00 66.59           C  
ATOM    476  CG  PRO    55      22.246  33.520 103.566  1.00 67.66           C  
ATOM    477  CD  PRO    55      21.746  33.602 102.171  1.00 69.20           C  
ATOM    478  N   ARG    56      23.968  36.722 102.861  1.00 48.08           N  
ATOM    479  CA  ARG    56      24.998  37.754 102.905  1.00 42.87           C  
ATOM    480  C   ARG    56      25.850  37.682 101.637  1.00 45.44           C  
ATOM    481  O   ARG    56      26.996  37.221 101.659  1.00 49.24           O  
ATOM    482  CB  ARG    56      25.839  37.621 104.175  1.00 49.88           C  
ATOM    483  CG  ARG    56      26.133  38.946 104.852  1.00 18.97           C  
ATOM    484  CD  ARG    56      26.176  38.798 106.364  1.00 24.76           C  
ATOM    485  NE  ARG    56      27.468  38.313 106.845  1.00 40.44           N  
ATOM    486  CZ  ARG    56      28.460  39.097 107.256  1.00 53.66           C  
ATOM    487  NH1 ARG    56      28.323  40.416 107.240  1.00 58.73           N  
ATOM    488  NH2 ARG    56      29.596  38.562 107.684  1.00 45.76           N  
ATOM    489  N   GLY    57      25.264  38.142 100.534  1.00 45.31           N  
ATOM    490  CA  GLY    57      25.861  38.009  99.209  1.00 39.80           C  
ATOM    491  C   GLY    57      26.650  39.214  98.741  1.00 40.11           C  
ATOM    492  O   GLY    57      26.211  40.353  98.890  1.00 39.59           O  
ATOM    493  N   LEU    58      27.814  38.943  98.156  1.00 34.25           N  
ATOM    494  CA  LEU    58      28.733  39.975  97.700  1.00 24.42           C  
ATOM    495  C   LEU    58      29.002  39.793  96.207  1.00 27.60           C  
ATOM    496  O   LEU    58      29.446  38.728  95.774  1.00 43.01           O  
ATOM    497  CB  LEU    58      30.037  39.878  98.501  1.00 39.75           C  
ATOM    498  CG  LEU    58      30.890  41.113  98.805  1.00 23.91           C  
ATOM    499  CD1 LEU    58      30.151  42.118  99.666  1.00 58.63           C  
ATOM    500  CD2 LEU    58      32.169  40.683  99.500  1.00 14.12           C  
ATOM    501  N   VAL    59      28.705  40.826  95.420  1.00 32.14           N  
ATOM    502  CA  VAL    59      28.933  40.795  93.972  1.00 31.60           C  
ATOM    503  C   VAL    59      29.955  41.865  93.602  1.00 51.55           C  
ATOM    504  O   VAL    59      29.745  43.049  93.870  1.00 58.66           O  
ATOM    505  CB  VAL    59      27.618  41.013  93.169  1.00 28.84           C  
ATOM    506  CG1 VAL    59      27.883  41.002  91.664  1.00 11.97           C  
ATOM    507  CG2 VAL    59      26.581  39.957  93.525  1.00 28.33           C  
ATOM    508  N   MET    60      31.063  41.442  92.998  1.00 46.21           N  
ATOM    509  CA  MET    60      32.144  42.357  92.635  1.00 43.37           C  
ATOM    510  C   MET    60      32.669  42.100  91.227  1.00 44.35           C  
ATOM    511  O   MET    60      32.773  40.951  90.797  1.00 52.83           O  
ATOM    512  CB  MET    60      33.269  42.275  93.662  1.00 44.96           C  
ATOM    513  CG  MET    60      33.034  43.154  94.879  1.00 48.21           C  
ATOM    514  SD  MET    60      33.481  42.433  96.469  1.00 46.13           S  
ATOM    515  CE  MET    60      34.825  41.344  96.023  1.00  4.14           C  
ATOM    516  N   SER    61      33.001  43.177  90.518  1.00 33.48           N  
ATOM    517  CA  SER    61      33.352  43.085  89.102  1.00 36.37           C  
ATOM    518  C   SER    61      34.679  43.747  88.754  1.00 44.79           C  
ATOM    519  O   SER    61      34.992  44.836  89.243  1.00 57.16           O  
ATOM    520  CB  SER    61      32.236  43.683  88.243  1.00 41.88           C  
ATOM    521  OG  SER    61      30.989  43.082  88.542  1.00 61.05           O  
ATOM    522  N   ALA    62      35.450  43.073  87.905  1.00 58.28           N  
ATOM    523  CA  ALA    62      36.674  43.634  87.346  1.00 58.50           C  
ATOM    524  C   ALA    62      36.339  44.552  86.170  1.00 64.19           C  
ATOM    525  O   ALA    62      35.240  44.478  85.613  1.00 75.24           O  
ATOM    526  CB  ALA    62      37.620  42.523  86.917  1.00 58.97           C  
ATOM    527  N   ASN    63      37.287  45.408  85.793  1.00 68.09           N  
ATOM    528  CA  ASN    63      37.062  46.432  84.756  1.00 69.47           C  
ATOM    529  C   ASN    63      36.980  45.953  83.296  1.00 64.12           C  
ATOM    530  O   ASN    63      36.721  46.748  82.388  1.00 58.40           O  
ATOM    531  CB  ASN    63      38.022  47.635  84.920  1.00 65.01           C  
ATOM    532  CG  ASN    63      39.505  47.293  84.677  1.00 91.40           C  
ATOM    533  OD1 ASN    63      40.339  48.201  84.624  1.00107.59           O  
ATOM    534  ND2 ASN    63      39.836  46.010  84.532  1.00 94.71           N  
ATOM    535  N   CYS    64      37.195  44.657  83.089  1.00 60.02           N  
ATOM    536  CA  CYS    64      37.081  44.040  81.771  1.00 75.98           C  
ATOM    537  C   CYS    64      35.619  43.849  81.359  1.00 79.71           C  
ATOM    538  O   CYS    64      35.171  44.435  80.369  1.00 80.65           O  
ATOM    539  CB  CYS    64      37.841  42.712  81.738  1.00 82.49           C  
ATOM    540  SG  CYS    64      37.673  41.726  83.249  1.00 98.58           S  
ATOM    541  N   VAL    65      34.882  43.036  82.119  1.00 73.13           N  
ATOM    542  CA  VAL    65      33.457  42.808  81.857  1.00 69.48           C  
ATOM    543  C   VAL    65      32.646  43.994  82.365  1.00 68.33           C  
ATOM    544  O   VAL    65      33.004  44.620  83.367  1.00 62.17           O  
ATOM    545  CB  VAL    65      32.921  41.516  82.520  1.00 68.74           C  
ATOM    546  CG1 VAL    65      31.853  40.870  81.643  1.00 97.15           C  
ATOM    547  CG2 VAL    65      34.032  40.537  82.757  1.00 69.93           C  
ATOM    548  N   LYS    66      31.545  44.287  81.676  1.00 78.50           N  
ATOM    549  CA  LYS    66      30.731  45.469  81.961  1.00 86.16           C  
ATOM    550  C   LYS    66      29.637  45.258  83.018  1.00 84.47           C  
ATOM    551  O   LYS    66      28.615  45.951  83.007  1.00 77.59           O  
ATOM    552  CB  LYS    66      30.125  46.021  80.662  1.00 95.79           C  
ATOM    553  CG  LYS    66      31.095  46.834  79.801  1.00113.77           C  
ATOM    554  CD  LYS    66      31.301  48.254  80.336  1.00122.57           C  
ATOM    555  CE  LYS    66      30.109  49.156  80.032  1.00120.31           C  
ATOM    556  NZ  LYS    66      30.291  50.525  80.592  1.00115.46           N  
ATOM    557  N   ASP    67      29.858  44.310  83.927  1.00 80.20           N  
ATOM    558  CA  ASP    67      28.968  44.109  85.069  1.00 71.67           C  
ATOM    559  C   ASP    67      29.181  45.216  86.103  1.00 72.53           C  
ATOM    560  O   ASP    67      30.254  45.827  86.154  1.00 74.41           O  
ATOM    561  CB  ASP    67      29.193  42.729  85.700  1.00 61.88           C  
ATOM    562  CG  ASP    67      28.744  41.588  84.798  1.00 67.35           C  
ATOM    563  OD1 ASP    67      29.148  41.555  83.614  1.00 65.09           O  
ATOM    564  OD2 ASP    67      27.991  40.714  85.281  1.00 60.45           O  
ATOM    565  N   THR    68      28.149  45.468  86.908  1.00 72.93           N  
ATOM    566  CA  THR    68      28.159  46.508  87.945  1.00 74.31           C  
ATOM    567  C   THR    68      29.237  46.251  89.007  1.00 64.76           C  
ATOM    568  O   THR    68      29.387  45.113  89.458  1.00 60.99           O  
ATOM    569  CB  THR    68      26.781  46.617  88.633  1.00 75.76           C  
ATOM    570  OG1 THR    68      26.394  45.326  89.135  1.00 61.69           O  
ATOM    571  CG2 THR    68      25.723  47.125  87.656  1.00 77.58           C  
ATOM    572  N   PRO    69      29.992  47.306  89.397  1.00 58.71           N  
ATOM    573  CA  PRO    69      31.149  47.214  90.301  1.00 51.46           C  
ATOM    574  C   PRO    69      30.899  46.539  91.652  1.00 52.55           C  
ATOM    575  O   PRO    69      31.702  45.703  92.070  1.00 54.61           O  
ATOM    576  CB  PRO    69      31.536  48.681  90.523  1.00 34.40           C  
ATOM    577  CG  PRO    69      31.056  49.379  89.317  1.00 27.54           C  
ATOM    578  CD  PRO    69      29.773  48.699  88.957  1.00 48.11           C  
ATOM    579  N   PHE    70      29.806  46.897  92.325  1.00 47.73           N  
ATOM    580  CA  PHE    70      29.535  46.373  93.665  1.00 38.96           C  
ATOM    581  C   PHE    70      28.051  46.180  93.972  1.00 47.67           C  
ATOM    582  O   PHE    70      27.218  47.019  93.621  1.00 44.07           O  
ATOM    583  CB  PHE    70      30.181  47.268  94.736  1.00 27.56           C  
ATOM    584  CG  PHE    70      30.034  46.741  96.142  1.00 35.59           C  
ATOM    585  CD1 PHE    70      29.015  47.203  96.975  1.00 28.02           C  
ATOM    586  CD2 PHE    70      30.909  45.777  96.630  1.00 26.65           C  
ATOM    587  CE1 PHE    70      28.868  46.705  98.265  1.00 55.54           C  
ATOM    588  CE2 PHE    70      30.777  45.284  97.922  1.00 13.83           C  
ATOM    589  CZ  PHE    70      29.756  45.748  98.741  1.00 52.02           C  
ATOM    590  N   HIS    71      27.747  45.070  94.645  1.00 38.09           N  
ATOM    591  CA  HIS    71      26.436  44.824  95.244  1.00 41.20           C  
ATOM    592  C   HIS    71      26.564  44.016  96.533  1.00 51.31           C  
ATOM    593  O   HIS    71      27.296  43.025  96.583  1.00 60.30           O  
ATOM    594  CB  HIS    71      25.515  44.095  94.267  1.00 36.38           C  
ATOM    595  CG  HIS    71      24.807  45.004  93.316  1.00 61.41           C  
ATOM    596  ND1 HIS    71      25.370  45.420  92.129  1.00 74.55           N  
ATOM    597  CD2 HIS    71      23.586  45.585  93.378  1.00 41.09           C  
ATOM    598  CE1 HIS    71      24.526  46.217  91.500  1.00 57.77           C  
ATOM    599  NE2 HIS    71      23.435  46.333  92.236  1.00 43.51           N  
ATOM    600  N   PHE    72      25.852  44.449  97.571  1.00 46.42           N  
ATOM    601  CA  PHE    72      25.787  43.703  98.824  1.00 42.49           C  
ATOM    602  C   PHE    72      24.352  43.284  99.128  1.00 41.28           C  
ATOM    603  O   PHE    72      23.463  44.125  99.290  1.00 41.05           O  
ATOM    604  CB  PHE    72      26.398  44.503  99.982  1.00 33.96           C  
ATOM    605  CG  PHE    72      26.478  43.742 101.286  1.00 53.39           C  
ATOM    606  CD1 PHE    72      26.960  42.434 101.324  1.00 63.75           C  
ATOM    607  CD2 PHE    72      26.092  44.346 102.480  1.00 28.53           C  
ATOM    608  CE1 PHE    72      27.042  41.737 102.526  1.00 53.03           C  
ATOM    609  CE2 PHE    72      26.173  43.659 103.688  1.00 64.73           C  
ATOM    610  CZ  PHE    72      26.649  42.353 103.710  1.00 46.99           C  
ATOM    611  N   PHE    73      24.145  41.972  99.194  1.00 42.22           N  
ATOM    612  CA  PHE    73      22.824  41.395  99.393  1.00 32.18           C  
ATOM    613  C   PHE    73      22.647  40.823 100.795  1.00 47.36           C  
ATOM    614  O   PHE    73      22.866  39.630 101.020  1.00 50.59           O  
ATOM    615  CB  PHE    73      22.550  40.302  98.352  1.00 16.68           C  
ATOM    616  CG  PHE    73      22.437  40.812  96.945  1.00 46.08           C  
ATOM    617  CD1 PHE    73      21.241  41.350  96.479  1.00 36.49           C  
ATOM    618  CD2 PHE    73      23.520  40.740  96.078  1.00 49.46           C  
ATOM    619  CE1 PHE    73      21.129  41.818  95.173  1.00 47.29           C  
ATOM    620  CE2 PHE    73      23.414  41.201  94.770  1.00 41.84           C  
ATOM    621  CZ  PHE    73      22.219  41.743  94.317  1.00 24.14           C  
ATOM    622  N   LYS    74      22.252  41.677 101.736  1.00 63.57           N  
ATOM    623  CA  LYS    74      21.788  41.203 103.037  1.00 65.79           C  
ATOM    624  C   LYS    74      20.345  40.710 102.925  1.00 64.36           C  
ATOM    625  O   LYS    74      19.711  40.873 101.878  1.00 57.86           O  
ATOM    626  CB  LYS    74      21.931  42.278 104.118  1.00 69.06           C  
ATOM    627  CG  LYS    74      23.118  42.045 105.040  1.00 62.10           C  
ATOM    628  CD  LYS    74      22.904  42.709 106.402  1.00 94.79           C  
ATOM    629  CE  LYS    74      23.653  41.967 107.509  1.00 98.09           C  
ATOM    630  NZ  LYS    74      25.141  42.013 107.336  1.00 73.68           N  
ATOM    631  N   GLN    75      19.837  40.112 104.004  1.00 73.63           N  
ATOM    632  CA  GLN    75      18.522  39.451 104.008  1.00 83.30           C  
ATOM    633  C   GLN    75      17.328  40.317 103.591  1.00 66.97           C  
ATOM    634  O   GLN    75      16.366  39.806 103.014  1.00 64.86           O  
ATOM    635  CB  GLN    75      18.241  38.802 105.366  1.00 97.58           C  
ATOM    636  CG  GLN    75      18.763  37.378 105.494  1.00119.01           C  
ATOM    637  CD  GLN    75      17.893  36.504 106.388  1.00132.39           C  
ATOM    638  OE1 GLN    75      16.774  36.875 106.751  1.00122.34           O  
ATOM    639  NE2 GLN    75      18.404  35.330 106.741  1.00128.61           N  
ATOM    640  N   ASN    76      17.394  41.616 103.877  1.00 70.77           N  
ATOM    641  CA  ASN    76      16.306  42.534 103.534  1.00 73.19           C  
ATOM    642  C   ASN    76      16.680  43.674 102.581  1.00 67.26           C  
ATOM    643  O   ASN    76      15.802  44.257 101.937  1.00 74.46           O  
ATOM    644  CB  ASN    76      15.649  43.092 104.804  1.00 80.64           C  
ATOM    645  CG  ASN    76      14.540  42.193 105.339  1.00 94.09           C  
ATOM    646  OD1 ASN    76      14.310  41.091 104.836  1.00116.49           O  
ATOM    647  ND2 ASN    76      13.844  42.667 106.366  1.00109.69           N  
ATOM    648  N   VAL    77      17.974  43.990 102.491  1.00 69.09           N  
ATOM    649  CA  VAL    77      18.442  45.125 101.684  1.00 62.67           C  
ATOM    650  C   VAL    77      19.398  44.696 100.564  1.00 61.27           C  
ATOM    651  O   VAL    77      20.153  43.732 100.715  1.00 62.47           O  
ATOM    652  CB  VAL    77      19.153  46.216 102.547  1.00 64.53           C  
ATOM    653  CG1 VAL    77      18.833  47.612 102.020  1.00 55.69           C  
ATOM    654  CG2 VAL    77      18.772  46.111 104.024  1.00 82.06           C  
ATOM    655  N   MET    78      19.349  45.419  99.445  1.00 42.50           N  
ATOM    656  CA  MET    78      20.336  45.285  98.371  1.00 50.14           C  
ATOM    657  C   MET    78      21.078  46.613  98.143  1.00 38.69           C  
ATOM    658  O   MET    78      20.716  47.413  97.274  1.00 48.81           O  
ATOM    659  CB  MET    78      19.703  44.737  97.077  1.00 47.97           C  
ATOM    660  CG  MET    78      18.332  45.317  96.706  1.00 69.92           C  
ATOM    661  SD  MET    78      17.692  44.689  95.138  1.00 61.78           S  
ATOM    662  CE  MET    78      17.085  43.063  95.638  1.00 74.72           C  
ATOM    663  N   THR    79      22.115  46.838  98.946  1.00 47.80           N  
ATOM    664  CA  THR    79      22.876  48.092  98.914  1.00 52.87           C  
ATOM    665  C   THR    79      24.004  48.084  97.879  1.00 52.91           C  
ATOM    666  O   THR    79      24.603  47.041  97.602  1.00 52.97           O  
ATOM    667  CB  THR    79      23.424  48.482 100.320  1.00 54.82           C  
ATOM    668  OG1 THR    79      24.399  49.528 100.192  1.00 68.46           O  
ATOM    669  CG2 THR    79      24.060  47.285 101.023  1.00 70.18           C  
ATOM    670  N   THR    80      24.279  49.260  97.318  1.00 51.14           N  
ATOM    671  CA  THR    80      25.340  49.434  96.323  1.00 51.08           C  
ATOM    672  C   THR    80      26.563  50.161  96.894  1.00 55.47           C  
ATOM    673  O   THR    80      27.634  50.164  96.279  1.00 58.74           O  
ATOM    674  CB  THR    80      24.820  50.154  95.045  1.00 47.82           C  
ATOM    675  OG1 THR    80      25.865  50.215  94.064  1.00 74.38           O  
ATOM    676  CG2 THR    80      24.325  51.569  95.356  1.00 61.08           C  
ATOM    677  N   ASP    81      26.394  50.771  98.068  1.00 55.83           N  
ATOM    678  CA  ASP    81      27.473  51.496  98.737  1.00 46.86           C  
ATOM    679  C   ASP    81      28.443  50.518  99.392  1.00 48.86           C  
ATOM    680  O   ASP    81      28.072  49.776 100.305  1.00 38.32           O  
ATOM    681  CB  ASP    81      26.906  52.473  99.775  1.00 52.86           C  
ATOM    682  CG  ASP    81      27.947  53.459 100.286  1.00 63.92           C  
ATOM    683  OD1 ASP    81      27.945  53.746 101.502  1.00 77.56           O  
ATOM    684  OD2 ASP    81      28.764  53.952  99.478  1.00108.65           O  
ATOM    685  N   ALA    82      29.684  50.524  98.912  1.00 49.02           N  
ATOM    686  CA  ALA    82      30.701  49.585  99.380  1.00 37.82           C  
ATOM    687  C   ALA    82      31.286  49.960 100.737  1.00 47.96           C  
ATOM    688  O   ALA    82      31.702  49.083 101.489  1.00 56.08           O  
ATOM    689  CB  ALA    82      31.800  49.430  98.345  1.00 43.64           C  
ATOM    690  N   GLU    83      31.309  51.258 101.037  1.00 37.70           N  
ATOM    691  CA  GLU    83      31.862  51.775 102.292  1.00 37.91           C  
ATOM    692  C   GLU    83      31.017  51.418 103.512  1.00 49.17           C  
ATOM    693  O   GLU    83      31.561  51.067 104.562  1.00 63.96           O  
ATOM    694  CB  GLU    83      32.046  53.293 102.220  1.00 28.88           C  
ATOM    695  CG  GLU    83      33.246  53.744 101.401  1.00 39.60           C  
ATOM    696  CD  GLU    83      33.449  55.251 101.436  1.00 80.26           C  
ATOM    697  OE1 GLU    83      33.713  55.837 100.365  1.00105.07           O  
ATOM    698  OE2 GLU    83      33.345  55.852 102.528  1.00 70.49           O  
ATOM    699  N   LYS    84      29.695  51.520 103.368  1.00 47.28           N  
ATOM    700  CA  LYS    84      28.765  51.139 104.429  1.00 53.19           C  
ATOM    701  C   LYS    84      28.750  49.623 104.603  1.00 56.27           C  
ATOM    702  O   LYS    84      28.696  49.127 105.728  1.00 61.84           O  
ATOM    703  CB  LYS    84      27.355  51.676 104.139  1.00 62.44           C  
ATOM    704  CG  LYS    84      26.317  51.460 105.256  1.00 75.22           C  
ATOM    705  CD  LYS    84      26.762  52.016 106.617  1.00111.96           C  
ATOM    706  CE  LYS    84      26.751  53.544 106.663  1.00115.36           C  
ATOM    707  NZ  LYS    84      25.373  54.111 106.606  1.00122.53           N  
ATOM    708  N   SER    85      28.824  48.904 103.483  1.00 52.57           N  
ATOM    709  CA  SER    85      28.869  47.442 103.478  1.00 49.61           C  
ATOM    710  C   SER    85      30.157  46.897 104.095  1.00 47.01           C  
ATOM    711  O   SER    85      30.130  45.872 104.774  1.00 52.71           O  
ATOM    712  CB  SER    85      28.703  46.911 102.054  1.00 45.25           C  
ATOM    713  OG  SER    85      27.475  47.341 101.493  1.00 55.42           O  
ATOM    714  N   PHE    86      31.271  47.591 103.855  1.00 40.80           N  
ATOM    715  CA  PHE    86      32.565  47.250 104.453  1.00 37.95           C  
ATOM    716  C   PHE    86      32.561  47.534 105.954  1.00 39.94           C  
ATOM    717  O   PHE    86      33.125  46.763 106.733  1.00 42.91           O  
ATOM    718  CB  PHE    86      33.703  48.009 103.754  1.00 43.18           C  
ATOM    719  CG  PHE    86      35.089  47.585 104.178  1.00 36.61           C  
ATOM    720  CD1 PHE    86      35.374  46.255 104.496  1.00 27.09           C  
ATOM    721  CD2 PHE    86      36.123  48.521 104.224  1.00 21.57           C  
ATOM    722  CE1 PHE    86      36.649  45.876 104.881  1.00 27.27           C  
ATOM    723  CE2 PHE    86      37.408  48.145 104.603  1.00 13.85           C  
ATOM    724  CZ  PHE    86      37.671  46.820 104.931  1.00 37.04           C  
ATOM    725  N   HIS    87      31.913  48.632 106.346  1.00 43.45           N  
ATOM    726  CA  HIS    87      31.733  48.990 107.755  1.00 33.20           C  
ATOM    727  C   HIS    87      30.821  47.992 108.483  1.00 26.92           C  
ATOM    728  O   HIS    87      30.957  47.782 109.694  1.00 38.35           O  
ATOM    729  CB  HIS    87      31.187  50.423 107.869  1.00 47.79           C  
ATOM    730  CG  HIS    87      30.780  50.816 109.256  1.00 77.67           C  
ATOM    731  ND1 HIS    87      31.689  51.004 110.276  1.00 95.54           N  
ATOM    732  CD2 HIS    87      29.560  51.056 109.791  1.00 62.79           C  
ATOM    733  CE1 HIS    87      31.046  51.341 111.380  1.00 68.04           C  
ATOM    734  NE2 HIS    87      29.753  51.381 111.113  1.00 57.51           N  
ATOM    735  N   ASP    88      29.913  47.373 107.727  1.00 37.53           N  
ATOM    736  CA  ASP    88      28.997  46.413 108.322  0.50 28.64           C  
ATOM    738  C   ASP    88      29.578  45.004 108.437  1.00 28.85           C  
ATOM    739  O   ASP    88      29.406  44.370 109.478  1.00 26.48           O  
ATOM    740  CB  ASP    88      27.622  46.450 107.604  0.50 29.14           C  
ATOM    742  CG  ASP    88      26.892  47.808 107.904  0.50 35.28           C  
ATOM    744  OD1 ASP    88      27.128  48.454 108.977  0.50 49.49           O  
ATOM    746  OD2 ASP    88      26.073  48.216 107.050  0.50 20.40           O  
ATOM    748  N   ILE    89      30.290  44.529 107.409  1.00 34.25           N  
ATOM    749  CA  ILE    89      30.942  43.200 107.451  1.00 50.45           C  
ATOM    750  C   ILE    89      32.134  43.168 108.418  1.00 46.38           C  
ATOM    751  O   ILE    89      32.570  42.095 108.855  1.00 54.94           O  
ATOM    752  CB  ILE    89      31.356  42.663 106.032  1.00 56.41           C  
ATOM    753  CG1 ILE    89      32.425  43.541 105.363  1.00 54.06           C  
ATOM    754  CG2 ILE    89      30.136  42.497 105.129  1.00 53.34           C  
ATOM    755  CD1 ILE    89      33.822  42.934 105.343  1.00 46.88           C  
ATOM    756  N   ARG    90      32.647  44.364 108.718  1.00 36.15           N  
ATOM    757  CA  ARG    90      33.648  44.613 109.751  1.00 33.44           C  
ATOM    758  C   ARG    90      33.174  44.112 111.112  1.00 35.88           C  
ATOM    759  O   ARG    90      33.923  43.464 111.846  1.00 32.69           O  
ATOM    760  CB  ARG    90      33.873  46.124 109.851  1.00 50.53           C  
ATOM    761  CG  ARG    90      35.309  46.587 109.914  1.00 49.31           C  
ATOM    762  CD  ARG    90      35.980  46.545 108.546  1.00 11.36           C  
ATOM    763  NE  ARG    90      36.812  47.723 108.294  1.00 39.72           N  
ATOM    764  CZ  ARG    90      38.043  47.915 108.768  1.00 44.50           C  
ATOM    765  NH1 ARG    90      38.630  47.013 109.548  1.00 21.11           N  
ATOM    766  NH2 ARG    90      38.693  49.029 108.462  1.00 41.44           N  
ATOM    767  N   LEU    91      31.919  44.426 111.428  1.00 49.46           N  
ATOM    768  CA  LEU    91      31.334  44.160 112.737  1.00 39.94           C  
ATOM    769  C   LEU    91      30.506  42.877 112.775  1.00 52.25           C  
ATOM    770  O   LEU    91      30.407  42.235 113.824  1.00 68.83           O  
ATOM    771  CB  LEU    91      30.465  45.347 113.181  1.00 31.54           C  
ATOM    772  CG  LEU    91      31.063  46.545 113.937  1.00 53.08           C  
ATOM    773  CD1 LEU    91      32.020  47.394 113.065  1.00 64.99           C  
ATOM    774  CD2 LEU    91      29.928  47.422 114.518  1.00 42.90           C  
ATOM    775  N   ASN    92      29.920  42.512 111.639  1.00 56.70           N  
ATOM    776  CA  ASN    92      28.881  41.490 111.607  1.00 67.96           C  
ATOM    777  C   ASN    92      29.457  40.080 111.686  1.00 72.93           C  
ATOM    778  O   ASN    92      28.842  39.179 112.256  1.00 76.53           O  
ATOM    779  CB  ASN    92      28.023  41.637 110.350  1.00 78.08           C  
ATOM    780  CG  ASN    92      26.855  42.584 110.549  1.00 88.02           C  
ATOM    781  OD1 ASN    92      25.957  42.665 109.711  1.00131.72           O  
ATOM    782  ND2 ASN    92      26.863  43.307 111.663  1.00 59.87           N  
ATOM    783  N   ARG    93      30.641  39.896 111.111  1.00 71.19           N  
ATOM    784  CA  ARG    93      31.543  38.834 111.538  1.00 73.30           C  
ATOM    785  C   ARG    93      30.928  37.458 111.301  1.00 77.32           C  
ATOM    786  O   ARG    93      31.088  36.872 110.231  1.00 84.52           O  
ATOM    787  CB  ARG    93      31.907  39.000 113.015  1.00 74.54           C  
ATOM    788  CG  ARG    93      33.069  39.947 113.265  1.00 81.79           C  
ATOM    789  CD  ARG    93      34.170  39.755 112.235  1.00 42.00           C  
ATOM    790  NE  ARG    93      35.213  40.770 112.353  1.00 52.63           N  
ATOM    791  CZ  ARG    93      36.415  40.548 112.873  1.00 69.36           C  
ATOM    792  NH1 ARG    93      36.732  39.343 113.327  1.00 79.09           N  
ATOM    793  NH2 ARG    93      37.302  41.532 112.940  1.00 90.19           N  
ATOM    794  N   ASP    94      30.224  36.950 112.307  1.00 76.75           N  
ATOM    795  CA  ASP    94      30.181  35.515 112.563  1.00 75.47           C  
ATOM    796  C   ASP    94      29.214  34.814 111.614  1.00 70.61           C  
ATOM    797  O   ASP    94      28.876  33.646 111.808  1.00 77.92           O  
ATOM    798  CB  ASP    94      29.782  35.242 114.015  1.00 74.90           C  
ATOM    799  CG  ASP    94      28.643  36.126 114.483  1.00 99.50           C  
ATOM    800  OD1 ASP    94      28.572  37.291 114.039  1.00125.90           O  
ATOM    801  OD2 ASP    94      27.818  35.656 115.295  1.00115.48           O  
ATOM    802  N   GLU    95      28.774  35.534 110.588  1.00 67.83           N  
ATOM    803  CA  GLU    95      27.934  34.949 109.541  1.00 72.63           C  
ATOM    804  C   GLU    95      28.752  34.584 108.303  1.00 69.46           C  
ATOM    805  O   GLU    95      29.844  35.120 108.089  1.00 62.78           O  
ATOM    806  CB  GLU    95      26.792  35.897 109.161  1.00 84.56           C  
ATOM    807  CG  GLU    95      25.454  35.587 109.828  1.00103.34           C  
ATOM    808  CD  GLU    95      25.446  35.870 111.321  1.00131.10           C  
ATOM    809  OE1 GLU    95      24.975  34.999 112.083  1.00149.05           O  
ATOM    810  OE2 GLU    95      25.907  36.956 111.734  1.00120.75           O  
ATOM    811  N   ASP    96      28.218  33.662 107.502  1.00 67.14           N  
ATOM    812  CA  ASP    96      28.824  33.275 106.229  1.00 61.36           C  
ATOM    813  C   ASP    96      28.684  34.390 105.199  1.00 57.82           C  
ATOM    814  O   ASP    96      27.626  35.014 105.096  1.00 58.90           O  
ATOM    815  CB  ASP    96      28.166  32.001 105.686  1.00 63.82           C  
ATOM    816  CG  ASP    96      28.538  30.760 106.478  1.00 83.76           C  
ATOM    817  OD1 ASP    96      29.690  30.294 106.361  1.00 83.72           O  
ATOM    818  OD2 ASP    96      27.668  30.237 107.206  1.00 94.54           O  
ATOM    819  N   ILE    97      29.754  34.640 104.446  1.00 50.57           N  
ATOM    820  CA  ILE    97      29.721  35.600 103.340  1.00 42.35           C  
ATOM    821  C   ILE    97      29.851  34.847 102.017  1.00 48.41           C  
ATOM    822  O   ILE    97      30.668  33.930 101.892  1.00 61.71           O  
ATOM    823  CB  ILE    97      30.836  36.681 103.452  1.00 38.51           C  
ATOM    824  CG1 ILE    97      30.998  37.146 104.905  1.00 56.20           C  
ATOM    825  CG2 ILE    97      30.543  37.866 102.519  1.00 36.70           C  
ATOM    826  CD1 ILE    97      32.017  38.258 105.111  1.00 36.92           C  
ATOM    827  N   TYR    98      29.036  35.235 101.038  1.00 43.37           N  
ATOM    828  CA  TYR    98      29.033  34.593  99.728  1.00 41.55           C  
ATOM    829  C   TYR    98      29.468  35.571  98.639  1.00 45.44           C  
ATOM    830  O   TYR    98      28.735  36.499  98.298  1.00 53.75           O  
ATOM    831  CB  TYR    98      27.649  34.019  99.419  1.00 43.75           C  
ATOM    832  CG  TYR    98      27.234  32.868 100.314  1.00 46.05           C  
ATOM    833  CD1 TYR    98      27.502  31.550  99.950  1.00 57.34           C  
ATOM    834  CD2 TYR    98      26.568  33.095 101.521  1.00 43.28           C  
ATOM    835  CE1 TYR    98      27.125  30.486 100.764  1.00 67.21           C  
ATOM    836  CE2 TYR    98      26.186  32.038 102.343  1.00 73.75           C  
ATOM    837  CZ  TYR    98      26.468  30.737 101.957  1.00 66.92           C  
ATOM    838  OH  TYR    98      26.093  29.688 102.765  1.00 54.52           O  
ATOM    839  N   ILE    99      30.663  35.352  98.098  1.00 37.68           N  
ATOM    840  CA  ILE    99      31.256  36.271  97.125  1.00 28.08           C  
ATOM    841  C   ILE    99      31.253  35.693  95.710  1.00 42.24           C  
ATOM    842  O   ILE    99      31.662  34.549  95.497  1.00 51.89           O  
ATOM    843  CB  ILE    99      32.712  36.664  97.512  1.00 32.23           C  
ATOM    844  CG1 ILE    99      32.817  36.961  99.014  1.00 42.55           C  
ATOM    845  CG2 ILE    99      33.200  37.863  96.683  1.00 37.46           C  
ATOM    846  CD1 ILE    99      34.240  37.035  99.531  1.00 44.76           C  
ATOM    847  N   GLN   100      30.778  36.487  94.752  1.00 41.82           N  
ATOM    848  CA  GLN   100      30.997  36.194  93.339  1.00 50.21           C  
ATOM    849  C   GLN   100      31.923  37.230  92.706  1.00 54.68           C  
ATOM    850  O   GLN   100      31.944  38.398  93.113  1.00 54.28           O  
ATOM    851  CB  GLN   100      29.678  36.066  92.560  1.00 50.15           C  
ATOM    852  CG  GLN   100      28.947  37.353  92.243  1.00 46.68           C  
ATOM    853  CD  GLN   100      27.981  37.186  91.088  1.00 48.67           C  
ATOM    854  OE1 GLN   100      28.382  37.188  89.922  1.00 30.74           O  
ATOM    855  NE2 GLN   100      26.702  37.039  91.406  1.00 37.98           N  
ATOM    856  N   LEU   101      32.703  36.784  91.724  1.00 50.71           N  
ATOM    857  CA  LEU   101      33.607  37.672  91.003  1.00 52.79           C  
ATOM    858  C   LEU   101      33.303  37.675  89.512  1.00 48.52           C  
ATOM    859  O   LEU   101      33.158  36.615  88.895  1.00 54.98           O  
ATOM    860  CB  LEU   101      35.076  37.300  91.253  1.00 57.78           C  
ATOM    861  CG  LEU   101      35.778  37.766  92.539  1.00 45.95           C  
ATOM    862  CD1 LEU   101      35.421  39.206  92.898  1.00 44.26           C  
ATOM    863  CD2 LEU   101      35.496  36.844  93.713  1.00 51.41           C  
ATOM    864  N   ASN   102      33.203  38.874  88.944  1.00 44.83           N  
ATOM    865  CA  ASN   102      32.942  39.035  87.518  1.00 54.17           C  
ATOM    866  C   ASN   102      34.192  39.484  86.763  1.00 63.67           C  
ATOM    867  O   ASN   102      34.495  40.678  86.690  1.00 68.06           O  
ATOM    868  CB  ASN   102      31.780  40.012  87.282  1.00 52.28           C  
ATOM    869  CG  ASN   102      30.482  39.560  87.940  1.00 52.25           C  
ATOM    870  OD1 ASN   102      29.761  40.367  88.527  1.00 64.12           O  
ATOM    871  ND2 ASN   102      30.180  38.268  87.842  1.00 50.03           N  
ATOM    872  N   PHE   103      34.917  38.512  86.213  1.00 64.90           N  
ATOM    873  CA  PHE   103      36.127  38.782  85.431  1.00 71.60           C  
ATOM    874  C   PHE   103      36.130  38.030  84.095  1.00 72.29           C  
ATOM    875  O   PHE   103      35.446  37.014  83.956  1.00 67.27           O  
ATOM    876  CB  PHE   103      37.415  38.570  86.256  1.00 69.00           C  
ATOM    877  CG  PHE   103      37.562  37.193  86.863  1.00 58.28           C  
ATOM    878  CD1 PHE   103      36.832  36.817  87.992  1.00 59.61           C  
ATOM    879  CD2 PHE   103      38.478  36.291  86.336  1.00 44.98           C  
ATOM    880  CE1 PHE   103      36.987  35.554  88.558  1.00 62.83           C  
ATOM    881  CE2 PHE   103      38.647  35.029  86.901  1.00 79.49           C  
ATOM    882  CZ  PHE   103      37.896  34.659  88.011  1.00 69.92           C  
ATOM    883  N   LYS   104      36.894  38.532  83.130  1.00 79.77           N  
ATOM    884  CA  LYS   104      36.661  38.217  81.726  1.00 77.85           C  
ATOM    885  C   LYS   104      36.767  36.717  81.472  1.00 80.76           C  
ATOM    886  O   LYS   104      35.888  36.119  80.852  1.00 89.35           O  
ATOM    887  CB  LYS   104      37.649  38.972  80.836  1.00 72.34           C  
ATOM    888  CG  LYS   104      37.514  38.660  79.354  1.00 89.58           C  
ATOM    889  CD  LYS   104      37.651  39.917  78.511  1.00108.84           C  
ATOM    890  CE  LYS   104      36.312  40.613  78.335  1.00111.27           C  
ATOM    891  NZ  LYS   104      36.408  41.778  77.412  1.00106.29           N  
ATOM    892  N   SER   105      37.849  36.115  81.956  1.00 79.14           N  
ATOM    893  CA  SER   105      38.225  34.768  81.544  1.00 84.89           C  
ATOM    894  C   SER   105      37.589  33.717  82.448  1.00 82.17           C  
ATOM    895  O   SER   105      37.340  32.589  82.023  1.00 88.04           O  
ATOM    896  CB  SER   105      39.747  34.613  81.548  1.00 93.30           C  
ATOM    897  OG  SER   105      40.275  34.793  82.850  1.00 90.41           O  
ATOM    898  N   SER   106      37.328  34.096  83.695  1.00 73.03           N  
ATOM    899  CA  SER   106      36.538  33.267  84.597  1.00 75.36           C  
ATOM    900  C   SER   106      36.819  31.785  84.373  1.00 81.22           C  
ATOM    901  O   SER   106      37.758  31.228  84.942  1.00 72.87           O  
ATOM    902  CB  SER   106      35.046  33.552  84.419  1.00 64.71           C  
ATOM    903  OG  SER   106      34.653  34.698  85.155  1.00 77.91           O  
ATOM    904  N   PHE   107      35.999  31.151  83.541  1.00 83.20           N  
ATOM    905  CA  PHE   107      35.974  29.697  83.449  1.00 84.24           C  
ATOM    906  C   PHE   107      37.065  29.184  82.516  1.00 86.74           C  
ATOM    907  O   PHE   107      37.000  28.055  82.029  1.00 85.34           O  
ATOM    908  CB  PHE   107      34.603  29.213  82.971  1.00 81.07           C  
ATOM    909  CG  PHE   107      33.671  28.836  84.087  1.00 80.14           C  
ATOM    910  CD1 PHE   107      33.679  27.555  84.611  1.00 79.45           C  
ATOM    911  CD2 PHE   107      32.785  29.763  84.611  1.00 81.77           C  
ATOM    912  CE1 PHE   107      32.822  27.205  85.638  1.00 73.72           C  
ATOM    913  CE2 PHE   107      31.926  29.419  85.637  1.00 86.27           C  
ATOM    914  CZ  PHE   107      31.945  28.138  86.151  1.00 81.88           C  
ATOM    915  N   GLN   108      38.068  30.021  82.269  1.00 81.83           N  
ATOM    916  CA  GLN   108      39.314  29.567  81.664  1.00 71.50           C  
ATOM    917  C   GLN   108      40.315  29.128  82.727  1.00 73.51           C  
ATOM    918  O   GLN   108      41.228  28.350  82.450  1.00 84.63           O  
ATOM    919  CB  GLN   108      39.920  30.670  80.794  1.00 60.92           C  
ATOM    920  CG  GLN   108      41.374  30.435  80.417  1.00 65.78           C  
ATOM    921  CD  GLN   108      42.133  31.727  80.189  1.00 78.37           C  
ATOM    922  OE1 GLN   108      41.699  32.589  79.424  1.00 89.24           O  
ATOM    923  NE2 GLN   108      43.274  31.869  80.853  1.00 93.78           N  
ATOM    924  N   ASN   109      40.138  29.632  83.944  1.00 61.06           N  
ATOM    925  CA  ASN   109      41.099  29.402  85.016  1.00 56.97           C  
ATOM    926  C   ASN   109      40.647  28.313  85.986  1.00 59.09           C  
ATOM    927  O   ASN   109      39.636  28.468  86.676  1.00 75.42           O  
ATOM    928  CB  ASN   109      41.355  30.715  85.760  1.00 60.45           C  
ATOM    929  CG  ASN   109      41.531  31.894  84.820  1.00 74.41           C  
ATOM    930  OD1 ASN   109      42.538  31.999  84.117  1.00 79.56           O  
ATOM    931  ND2 ASN   109      40.550  32.791  84.809  1.00 59.82           N  
ATOM    932  N   ALA   110      41.421  27.226  86.034  1.00 59.44           N  
ATOM    933  CA  ALA   110      41.104  26.024  86.820  1.00 76.50           C  
ATOM    934  C   ALA   110      40.965  26.262  88.322  1.00 85.33           C  
ATOM    935  O   ALA   110      40.127  25.641  88.974  1.00 92.26           O  
ATOM    936  CB  ALA   110      42.139  24.935  86.554  1.00 82.37           C  
ATOM    937  N   ASN   111      41.793  27.159  88.852  1.00 82.09           N  
ATOM    938  CA  ASN   111      41.751  27.555  90.263  1.00 78.31           C  
ATOM    939  C   ASN   111      40.481  28.279  90.704  1.00 81.26           C  
ATOM    940  O   ASN   111      40.028  28.098  91.838  1.00 72.89           O  
ATOM    941  CB  ASN   111      43.003  28.352  90.673  1.00 74.33           C  
ATOM    942  CG  ASN   111      43.195  29.661  89.888  1.00 91.41           C  
ATOM    943  OD1 ASN   111      43.724  30.630  90.433  1.00100.72           O  
ATOM    944  ND2 ASN   111      42.798  29.687  88.621  1.00 89.07           N  
ATOM    945  N   TYR   112      39.919  29.097  89.812  1.00 79.02           N  
ATOM    946  CA  TYR   112      38.642  29.763  90.070  1.00 74.72           C  
ATOM    947  C   TYR   112      37.493  28.757  90.073  1.00 69.62           C  
ATOM    948  O   TYR   112      36.572  28.866  90.882  1.00 78.78           O  
ATOM    949  CB  TYR   112      38.386  30.890  89.057  1.00 72.88           C  
ATOM    950  CG  TYR   112      36.951  31.392  89.019  1.00 74.65           C  
ATOM    951  CD1 TYR   112      36.144  31.159  87.905  1.00 79.19           C  
ATOM    952  CD2 TYR   112      36.398  32.089  90.098  1.00 68.23           C  
ATOM    953  CE1 TYR   112      34.829  31.611  87.860  1.00 84.25           C  
ATOM    954  CE2 TYR   112      35.082  32.543  90.065  1.00 59.00           C  
ATOM    955  CZ  TYR   112      34.305  32.301  88.942  1.00 78.44           C  
ATOM    956  OH  TYR   112      33.004  32.748  88.902  1.00 73.48           O  
ATOM    957  N   VAL   113      37.558  27.778  89.172  1.00 62.73           N  
ATOM    958  CA  VAL   113      36.542  26.726  89.111  1.00 67.82           C  
ATOM    959  C   VAL   113      36.683  25.765  90.301  1.00 71.35           C  
ATOM    960  O   VAL   113      35.686  25.234  90.801  1.00 73.33           O  
ATOM    961  CB  VAL   113      36.566  25.959  87.761  1.00 63.65           C  
ATOM    962  CG1 VAL   113      35.270  25.182  87.569  1.00 54.93           C  
ATOM    963  CG2 VAL   113      36.724  26.935  86.605  1.00 60.95           C  
ATOM    964  N   ALA   114      37.919  25.572  90.765  1.00 76.69           N  
ATOM    965  CA  ALA   114      38.192  24.758  91.953  1.00 80.97           C  
ATOM    966  C   ALA   114      37.709  25.418  93.245  1.00 78.44           C  
ATOM    967  O   ALA   114      37.286  24.727  94.175  1.00 66.02           O  
ATOM    968  CB  ALA   114      39.676  24.435  92.051  1.00 92.18           C  
ATOM    969  N   VAL   115      37.770  26.748  93.296  1.00 75.18           N  
ATOM    970  CA  VAL   115      37.393  27.499  94.499  1.00 59.72           C  
ATOM    971  C   VAL   115      35.870  27.702  94.617  1.00 56.76           C  
ATOM    972  O   VAL   115      35.364  28.046  95.692  1.00 50.37           O  
ATOM    973  CB  VAL   115      38.187  28.845  94.612  1.00 58.85           C  
ATOM    974  CG1 VAL   115      37.478  29.989  93.887  1.00 60.87           C  
ATOM    975  CG2 VAL   115      38.449  29.205  96.073  1.00 56.17           C  
ATOM    976  N   LEU   116      35.151  27.466  93.517  1.00 48.29           N  
ATOM    977  CA  LEU   116      33.690  27.584  93.485  1.00 47.06           C  
ATOM    978  C   LEU   116      33.000  26.504  94.314  1.00 54.39           C  
ATOM    979  O   LEU   116      33.454  25.358  94.365  1.00 65.36           O  
ATOM    980  CB  LEU   116      33.167  27.548  92.044  1.00 49.10           C  
ATOM    981  CG  LEU   116      33.228  28.833  91.208  1.00 59.28           C  
ATOM    982  CD1 LEU   116      33.046  28.512  89.730  1.00 80.25           C  
ATOM    983  CD2 LEU   116      32.196  29.866  91.670  1.00 67.83           C  
ATOM    984  N   GLU   117      31.901  26.889  94.962  1.00 54.18           N  
ATOM    985  CA  GLU   117      31.165  26.003  95.862  1.00 65.51           C  
ATOM    986  C   GLU   117      29.683  25.931  95.498  1.00 73.86           C  
ATOM    987  O   GLU   117      29.170  26.787  94.769  1.00 82.41           O  
ATOM    988  CB  GLU   117      31.321  26.465  97.317  1.00 59.45           C  
ATOM    989  CG  GLU   117      32.745  26.386  97.860  1.00 68.90           C  
ATOM    990  CD  GLU   117      32.862  26.863  99.295  1.00 78.47           C  
ATOM    991  OE1 GLU   117      33.674  27.777  99.552  1.00104.50           O  
ATOM    992  OE2 GLU   117      32.145  26.326 100.167  1.00 96.20           O  
ATOM    993  N   GLU   118      29.011  24.898  96.008  1.00 83.47           N  
ATOM    994  CA  GLU   118      27.568  24.732  95.846  1.00 86.27           C  
ATOM    995  C   GLU   118      26.795  25.804  96.608  1.00 80.52           C  
ATOM    996  O   GLU   118      26.851  25.872  97.838  1.00 81.70           O  
ATOM    997  CB  GLU   118      27.133  23.336  96.304  1.00 92.70           C  
ATOM    998  CG  GLU   118      26.780  22.378  95.173  1.00116.45           C  
ATOM    999  CD  GLU   118      25.311  22.451  94.776  1.00132.68           C  
ATOM   1000  OE1 GLU   118      24.438  22.359  95.671  1.00133.96           O  
ATOM   1001  OE2 GLU   118      25.029  22.589  93.566  1.00138.23           O  
ATOM   1002  N   ASN   119      26.096  26.646  95.853  1.00 71.42           N  
ATOM   1003  CA  ASN   119      25.233  27.688  96.397  1.00 67.20           C  
ATOM   1004  C   ASN   119      23.840  27.099  96.645  1.00 66.23           C  
ATOM   1005  O   ASN   119      23.119  26.792  95.692  1.00 71.02           O  
ATOM   1006  CB  ASN   119      25.201  28.882  95.423  1.00 71.74           C  
ATOM   1007  CG  ASN   119      24.132  29.926  95.778  1.00 54.24           C  
ATOM   1008  OD1 ASN   119      23.699  30.063  96.934  1.00 63.35           O  
ATOM   1009  ND2 ASN   119      23.721  30.686  94.767  1.00 50.59           N  
ATOM   1010  N   PRO   120      23.458  26.941  97.930  1.00 67.17           N  
ATOM   1011  CA  PRO   120      22.210  26.271  98.289  1.00 72.55           C  
ATOM   1012  C   PRO   120      21.014  27.218  98.461  1.00 70.30           C  
ATOM   1013  O   PRO   120      20.143  26.969  99.300  1.00 79.44           O  
ATOM   1014  CB  PRO   120      22.561  25.599  99.621  1.00 75.47           C  
ATOM   1015  CG  PRO   120      23.674  26.451 100.210  1.00 68.75           C  
ATOM   1016  CD  PRO   120      24.189  27.380  99.133  1.00 60.87           C  
ATOM   1017  N   TYR   121      20.976  28.287  97.668  1.00 66.26           N  
ATOM   1018  CA  TYR   121      19.871  29.248  97.703  1.00 70.81           C  
ATOM   1019  C   TYR   121      19.294  29.470  96.308  1.00 75.80           C  
ATOM   1020  O   TYR   121      18.388  30.288  96.117  1.00 86.93           O  
ATOM   1021  CB  TYR   121      20.316  30.569  98.340  1.00 77.51           C  
ATOM   1022  CG  TYR   121      20.838  30.401  99.748  1.00 92.01           C  
ATOM   1023  CD1 TYR   121      22.207  30.339  99.998  1.00102.48           C  
ATOM   1024  CD2 TYR   121      19.964  30.284 100.828  1.00102.41           C  
ATOM   1025  CE1 TYR   121      22.697  30.169 101.288  1.00 93.63           C  
ATOM   1026  CE2 TYR   121      20.443  30.118 102.122  1.00 97.11           C  
ATOM   1027  CZ  TYR   121      21.809  30.060 102.345  1.00 87.71           C  
ATOM   1028  OH  TYR   121      22.287  29.899 103.625  1.00 82.59           O  
ATOM   1029  N   LEU   122      19.823  28.737  95.334  1.00 74.94           N  
ATOM   1030  CA  LEU   122      19.115  28.503  94.081  1.00 73.34           C  
ATOM   1031  C   LEU   122      17.804  27.762  94.319  1.00 73.93           C  
ATOM   1032  O   LEU   122      17.756  26.793  95.077  1.00 74.38           O  
ATOM   1033  CB  LEU   122      19.995  27.716  93.107  1.00 79.27           C  
ATOM   1034  CG  LEU   122      20.942  28.540  92.233  1.00 62.59           C  
ATOM   1035  CD1 LEU   122      20.590  28.382  90.761  1.00104.35           C  
ATOM   1036  CD2 LEU   122      20.914  30.004  92.641  1.00 57.43           C  
END
