
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   78 (  627),  selected   78 , name 2fu2_A
# Molecule2: number of CA atoms  119 ( 1007),  selected  119 , name T0496_4_122.pdb
# PARAMETERS: 2fu2_A.T0496_4_122.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      P       4           -
LGA    P     2_A      V       5          1.454
LGA    S     3_A      S       6          1.449
LGA    E     4_A      V       7          1.291
LGA    K     5_A      N       8          0.891
LGA    E     6_A      E       9          0.686
LGA    I     7_A      K      10          0.848
LGA    L     8_A      K      11          0.685
LGA    D     9_A      D      12          0.763
LGA    A    10_A      F      13          0.889
LGA    L    11_A      V      14          1.199
LGA    S    12_A      K      15          0.974
LGA    K    13_A      W      16          1.598
LGA    V    14_A      F      17          1.864
LGA    Y    15_A      L      18          1.818
LGA    S    16_A      N      19          1.679
LGA    E    17_A      N      20          3.388
LGA    Q    18_A      Y      21          3.402
LGA    V    19_A      Q      22          2.111
LGA    I    20_A      L      23          2.020
LGA    Q    21_A      -       -           -
LGA    A    22_A      K      24          5.168
LGA    D    23_A      Q      25          2.526
LGA    D    24_A      R      26          0.972
LGA    Y    25_A      E      27          1.650
LGA    F    26_A      C      28          1.077
LGA    R    27_A      V      29          0.579
LGA    Q    28_A      W      30          0.457
LGA    A    29_A      I      31          0.623
LGA    I    30_A      L      32          0.619
LGA    F    31_A      N      33          0.561
LGA    E    32_A      Y      34          0.556
LGA    L    33_A      L      35          0.544
LGA    A    34_A      M      36          0.671
LGA    S    35_A      S      37          0.695
LGA    Q    36_A      H      38          0.590
LGA    L    37_A      D      39          1.963
LGA    E    38_A      -       -           -
LGA    K    39_A      -       -           -
LGA    E    40_A      -       -           -
LGA    G    41_A      Q      40          4.025
LGA    X    42_A      L      41           #
LGA    S    43_A      M      42           #
LGA    S    44_A      H      43          5.170
LGA    L    45_A      K      44          3.469
LGA    L    46_A      V      45          3.689
LGA    A    47_A      -       -           -
LGA    T    48_A      -       -           -
LGA    K    49_A      H      46           #
LGA    I    50_A      F      47           #
LGA    D    51_A      V      48           #
LGA    -       -      E      49           -
LGA    -       -      H      50           -
LGA    -       -      A      51           -
LGA    -       -      K      52           -
LGA    -       -      Y      53           -
LGA    -       -      C      54           -
LGA    -       -      P      55           -
LGA    S    52_A      R      56          4.776
LGA    L    53_A      G      57           #
LGA    I    54_A      L      58          4.613
LGA    N    55_A      -       -           -
LGA    Q    56_A      V      59          1.244
LGA    Y    57_A      M      60          1.618
LGA    I    58_A      S      61           #
LGA    L    59_A      A      62           -
LGA    -       -      N      63           -
LGA    -       -      C      64           -
LGA    -       -      V      65           -
LGA    -       -      K      66           -
LGA    T    60_A      D      67          4.686
LGA    H    61_A      T      68          3.774
LGA    Q    62_A      P      69           -
LGA    F    63_A      F      70           -
LGA    -       -      H      71           -
LGA    -       -      F      72           -
LGA    -       -      F      73           -
LGA    -       -      K      74           -
LGA    -       -      Q      75           -
LGA    -       -      N      76           -
LGA    -       -      V      77           -
LGA    -       -      M      78           -
LGA    -       -      T      79           -
LGA    -       -      T      80           -
LGA    -       -      D      81           -
LGA    -       -      A      82           -
LGA    -       -      E      83           -
LGA    -       -      K      84           -
LGA    -       -      S      85           -
LGA    -       -      F      86           -
LGA    -       -      H      87           -
LGA    -       -      D      88           -
LGA    -       -      I      89           -
LGA    -       -      R      90           -
LGA    -       -      L      91           -
LGA    -       -      N      92           -
LGA    -       -      R      93           -
LGA    -       -      D      94           -
LGA    -       -      E      95           -
LGA    -       -      D      96           -
LGA    -       -      I      97           -
LGA    -       -      Y      98           -
LGA    -       -      I      99           -
LGA    -       -      Q     100           -
LGA    D    64_A      L     101           #
LGA    A    65_A      N     102          2.421
LGA    P    66_A      F     103          2.211
LGA    -       -      K     104           -
LGA    -       -      S     105           -
LGA    K    67_A      S     106          1.705
LGA    -       -      F     107           -
LGA    -       -      Q     108           -
LGA    S    68_A      N     109           #
LGA    I    69_A      A     110           -
LGA    -       -      N     111           -
LGA    F    70_A      Y     112          5.176
LGA    D    71_A      V     113          3.714
LGA    L    72_A      A     114           #
LGA    S    73_A      V     115           #
LGA    R    74_A      L     116          0.923
LGA    L    75_A      -       -           -
LGA    V    76_A      -       -           -
LGA    K    77_A      E     117          2.582
LGA    T    78_A      E     118          4.426
LGA    K    79_A      N     119           -
LGA    -       -      P     120           -
LGA    -       -      Y     121           -
LGA    -       -      L     122           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   78  119    5.0     53    2.52     9.43     33.254     2.026

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.590110 * X  +  -0.023396 * Y  +  -0.806983 * Z  +  34.991615
  Y_new =   0.448738 * X  +  -0.821438 * Y  +   0.351957 * Z  +  20.769068
  Z_new =  -0.671121 * X  +  -0.569818 * Y  +  -0.474240 * Z  + 105.075996 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.264904    0.876689  [ DEG:  -129.7694     50.2306 ]
  Theta =   0.735720    2.405873  [ DEG:    42.1537    137.8463 ]
  Phi   =   0.650144   -2.491449  [ DEG:    37.2505   -142.7495 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fu2_A                                        
REMARK     2: T0496_4_122.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fu2_A.T0496_4_122.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   78  119   5.0   53   2.52    9.43  33.254
REMARK  ---------------------------------------------------------- 
MOLECULE 2fu2_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-JAN-06   2FU2              
TITLE     CRYSTAL STRUCTURE OF PROTEIN SPY2152 FROM STREPTOCOCCUS               
TITLE    2 PYOGENES                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN SPY2152;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PYOGENES;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) DERIVATIVES;                     
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PMCSG                                     
KEYWDS    STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE,               
KEYWDS   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.CHANG,M.CYMBOROWSKI,Z.OTWINOWSKI,W.MINOR,L.-E.LEZONDRA,             
AUTHOR   2 S.CLANCY,A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL                  
AUTHOR   3 GENOMICS (MCSG)                                                      
REVDAT   2   19-DEC-06 2FU2    1       TITLE                                    
REVDAT   1   07-MAR-06 2FU2    0                                                
JRNL        AUTH   C.CHANG,M.CYMBOROWSKI,Z.OTWINOWSKI,W.MINOR,                  
JRNL        AUTH 2 L.-E.LEZONDRA,S.CLANCY,A.JOACHIMIAK                          
JRNL        TITL   CRYSTAL STRUCTURE OF PROTEIN SPY2152 FROM                    
JRNL        TITL 2 STREPTOCOCCUS PYOGENES                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.15 ANGSTROMS.                                          
DBREF  2FU2 A    1   102  UNP    Q99XL4   Q99XL4_STRP1     1    102             
SEQRES   1 A  102  MSE PRO SER GLU LYS GLU ILE LEU ASP ALA LEU SER LYS          
SEQRES   2 A  102  VAL TYR SER GLU GLN VAL ILE GLN ALA ASP ASP TYR PHE          
SEQRES   3 A  102  ARG GLN ALA ILE PHE GLU LEU ALA SER GLN LEU GLU LYS          
SEQRES   4 A  102  GLU GLY MSE SER SER LEU LEU ALA THR LYS ILE ASP SER          
SEQRES   5 A  102  LEU ILE ASN GLN TYR ILE LEU THR HIS GLN PHE ASP ALA          
SEQRES   6 A  102  PRO LYS SER ILE PHE ASP LEU SER ARG LEU VAL LYS THR          
SEQRES   7 A  102  LYS ALA SER HIS TYR LYS GLY THR ALA ILE SER ALA ILE          
SEQRES   8 A  102  MSE LEU GLY SER PHE LEU SER GLY GLY PRO LYS                  
HET    MSE  A  42       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    C5 H11 N O2 SE                                               
FORMUL   2  HOH   *67(H2 O)                                                     
CRYST1   76.087   30.280   35.855  90.00 113.26  90.00 C 1 2 1       4          
ATOM      1  N   PRO A   2      38.789  21.012  99.771  1.00 34.36           N  
ATOM      2  CA  PRO A   2      38.585  22.492  99.630  1.00 34.77           C  
ATOM      3  C   PRO A   2      39.214  23.291 100.818  1.00 34.17           C  
ATOM      4  O   PRO A   2      38.499  23.713 101.707  1.00 34.72           O  
ATOM      5  CB  PRO A   2      37.057  22.629  99.587  1.00 34.09           C  
ATOM      6  CG  PRO A   2      36.582  21.435 100.451  1.00 36.01           C  
ATOM      7  CD  PRO A   2      37.548  20.294 100.140  1.00 34.67           C  
ATOM      8  N   SER A   3      40.541  23.457 100.822  1.00 33.66           N  
ATOM      9  CA  SER A   3      41.342  23.833 102.007  1.00 32.68           C  
ATOM     10  C   SER A   3      41.436  25.342 102.260  1.00 32.99           C  
ATOM     11  O   SER A   3      41.141  26.183 101.361  1.00 33.10           O  
ATOM     12  CB  SER A   3      42.764  23.293 101.853  1.00 32.36           C  
ATOM     13  OG  SER A   3      43.582  24.179 101.094  1.00 32.08           O  
ATOM     14  N   GLU A   4      41.877  25.690 103.469  1.00 32.36           N  
ATOM     15  CA  GLU A   4      42.025  27.104 103.870  1.00 32.45           C  
ATOM     16  C   GLU A   4      42.978  27.858 102.978  1.00 32.20           C  
ATOM     17  O   GLU A   4      42.705  29.024 102.616  1.00 31.28           O  
ATOM     18  CB  GLU A   4      42.520  27.241 105.305  1.00 33.37           C  
ATOM     19  CG  GLU A   4      41.529  26.827 106.355  1.00 34.58           C  
ATOM     20  CD  GLU A   4      42.005  27.169 107.733  1.00 32.93           C  
ATOM     21  OE1 GLU A   4      43.221  27.138 107.980  1.00 35.92           O  
ATOM     22  OE2 GLU A   4      41.155  27.488 108.568  1.00 34.49           O  
ATOM     23  N   LYS A   5      44.096  27.193 102.636  1.00 31.50           N  
ATOM     24  CA  LYS A   5      45.089  27.745 101.702  1.00 31.93           C  
ATOM     25  C   LYS A   5      44.635  27.953 100.228  1.00 31.80           C  
ATOM     26  O   LYS A   5      45.018  28.927  99.602  1.00 32.07           O  
ATOM     27  CB  LYS A   5      46.348  26.900 101.777  1.00 31.69           C  
ATOM     28  CG  LYS A   5      47.042  27.018 103.119  1.00 33.92           C  
ATOM     29  CD  LYS A   5      47.580  25.655 103.525  1.00 42.01           C  
ATOM     30  CE  LYS A   5      48.605  25.736 104.664  1.00 45.12           C  
ATOM     31  NZ  LYS A   5      49.063  24.324 105.059  1.00 46.94           N  
ATOM     32  N   GLU A   6      43.820  27.039  99.704  1.00 31.89           N  
ATOM     33  CA  GLU A   6      43.357  27.120  98.328  1.00 33.15           C  
ATOM     34  C   GLU A   6      42.444  28.339  98.234  1.00 32.40           C  
ATOM     35  O   GLU A   6      42.498  29.083  97.248  1.00 32.83           O  
ATOM     36  CB  GLU A   6      42.612  25.838  97.892  1.00 32.25           C  
ATOM     37  CG  GLU A   6      43.501  24.644  97.863  1.00 34.75           C  
ATOM     38  CD  GLU A   6      42.791  23.269  97.687  1.00 34.91           C  
ATOM     39  OE1 GLU A   6      41.822  22.960  98.429  1.00 36.20           O  
ATOM     40  OE2 GLU A   6      43.255  22.478  96.826  1.00 36.26           O  
ATOM     41  N   ILE A   7      41.611  28.548  99.253  1.00 31.01           N  
ATOM     42  CA  ILE A   7      40.721  29.719  99.250  1.00 30.52           C  
ATOM     43  C   ILE A   7      41.539  31.031  99.396  1.00 30.86           C  
ATOM     44  O   ILE A   7      41.270  32.036  98.688  1.00 30.45           O  
ATOM     45  CB  ILE A   7      39.613  29.579 100.317  1.00 30.86           C  
ATOM     46  CG1 ILE A   7      38.843  28.253 100.073  1.00 28.77           C  
ATOM     47  CG2 ILE A   7      38.693  30.907 100.413  1.00 29.29           C  
ATOM     48  CD1 ILE A   7      37.701  28.047 100.954  1.00 26.71           C  
ATOM     49  N   LEU A   8      42.548  30.999 100.260  1.00 29.53           N  
ATOM     50  CA  LEU A   8      43.401  32.163 100.459  1.00 30.42           C  
ATOM     51  C   LEU A   8      44.122  32.492  99.153  1.00 30.67           C  
ATOM     52  O   LEU A   8      44.113  33.662  98.714  1.00 30.46           O  
ATOM     53  CB  LEU A   8      44.386  31.936 101.588  1.00 29.58           C  
ATOM     54  CG  LEU A   8      45.331  33.103 101.969  1.00 33.32           C  
ATOM     55  CD1 LEU A   8      44.657  34.446 102.357  1.00 29.74           C  
ATOM     56  CD2 LEU A   8      46.248  32.660 103.150  1.00 32.50           C  
ATOM     57  N   ASP A   9      44.677  31.463  98.488  1.00 29.74           N  
ATOM     58  CA  ASP A   9      45.302  31.702  97.209  1.00 30.28           C  
ATOM     59  C   ASP A   9      44.345  32.247  96.113  1.00 31.44           C  
ATOM     60  O   ASP A   9      44.688  33.252  95.416  1.00 32.46           O  
ATOM     61  CB  ASP A   9      46.030  30.454  96.718  1.00 30.14           C  
ATOM     62  CG  ASP A   9      47.288  30.150  97.527  1.00 29.09           C  
ATOM     63  OD1 ASP A   9      47.705  31.010  98.327  1.00 27.71           O  
ATOM     64  OD2 ASP A   9      47.839  29.037  97.364  1.00 25.74           O  
ATOM     65  N   ALA A  10      43.159  31.602  95.977  1.00 31.15           N  
ATOM     66  CA  ALA A  10      42.081  32.112  95.151  1.00 31.02           C  
ATOM     67  C   ALA A  10      41.704  33.568  95.426  1.00 30.56           C  
ATOM     68  O   ALA A  10      41.537  34.342  94.467  1.00 31.53           O  
ATOM     69  CB  ALA A  10      40.832  31.198  95.223  1.00 31.48           C  
ATOM     70  N   LEU A  11      41.559  33.960  96.687  1.00 29.30           N  
ATOM     71  CA  LEU A  11      41.440  35.422  97.024  1.00 28.21           C  
ATOM     72  C   LEU A  11      42.573  36.251  96.491  1.00 28.96           C  
ATOM     73  O   LEU A  11      42.318  37.380  96.011  1.00 28.57           O  
ATOM     74  CB  LEU A  11      41.413  35.673  98.517  1.00 25.99           C  
ATOM     75  CG  LEU A  11      40.072  35.215  99.028  1.00 26.36           C  
ATOM     76  CD1 LEU A  11      40.111  34.766 100.448  1.00 28.23           C  
ATOM     77  CD2 LEU A  11      39.021  36.364  98.841  1.00 23.50           C  
ATOM     78  N   SER A  12      43.809  35.722  96.544  1.00 30.21           N  
ATOM     79  CA  SER A  12      44.971  36.542  96.172  1.00 32.27           C  
ATOM     80  C   SER A  12      44.978  36.733  94.671  1.00 32.78           C  
ATOM     81  O   SER A  12      45.349  37.810  94.175  1.00 33.89           O  
ATOM     82  CB  SER A  12      46.300  35.914  96.613  1.00 32.80           C  
ATOM     83  OG  SER A  12      46.318  35.900  98.026  1.00 36.04           O  
ATOM     84  N   LYS A  13      44.598  35.662  93.969  1.00 32.76           N  
ATOM     85  CA  LYS A  13      44.455  35.669  92.518  1.00 32.25           C  
ATOM     86  C   LYS A  13      43.437  36.707  92.083  1.00 31.76           C  
ATOM     87  O   LYS A  13      43.701  37.501  91.198  1.00 33.11           O  
ATOM     88  CB  LYS A  13      44.040  34.301  92.008  1.00 30.82           C  
ATOM     89  CG  LYS A  13      44.401  34.140  90.504  1.00 34.05           C  
ATOM     90  CD  LYS A  13      43.720  32.967  89.861  1.00 36.49           C  
ATOM     91  CE  LYS A  13      44.705  31.985  89.523  1.00 40.28           C  
ATOM     92  NZ  LYS A  13      45.806  32.827  88.998  1.00 44.89           N  
ATOM     93  N   VAL A  14      42.270  36.699  92.702  1.00 31.54           N  
ATOM     94  CA  VAL A  14      41.276  37.762  92.469  1.00 31.65           C  
ATOM     95  C   VAL A  14      41.814  39.188  92.801  1.00 32.99           C  
ATOM     96  O   VAL A  14      41.748  40.132  91.964  1.00 34.08           O  
ATOM     97  CB  VAL A  14      39.972  37.491  93.268  1.00 30.90           C  
ATOM     98  CG1 VAL A  14      39.090  38.703  93.268  1.00 28.99           C  
ATOM     99  CG2 VAL A  14      39.244  36.258  92.689  1.00 26.34           C  
ATOM    100  N   TYR A  15      42.357  39.333  93.999  1.00 31.80           N  
ATOM    101  CA  TYR A  15      42.993  40.599  94.406  1.00 32.26           C  
ATOM    102  C   TYR A  15      43.975  41.152  93.352  1.00 32.94           C  
ATOM    103  O   TYR A  15      43.912  42.301  93.034  1.00 32.33           O  
ATOM    104  CB  TYR A  15      43.674  40.410  95.774  1.00 31.46           C  
ATOM    105  CG  TYR A  15      44.458  41.594  96.270  1.00 31.16           C  
ATOM    106  CD1 TYR A  15      43.841  42.595  96.999  1.00 28.73           C  
ATOM    107  CD2 TYR A  15      45.840  41.654  96.078  1.00 30.38           C  
ATOM    108  CE1 TYR A  15      44.531  43.678  97.417  1.00 30.81           C  
ATOM    109  CE2 TYR A  15      46.582  42.729  96.538  1.00 31.63           C  
ATOM    110  CZ  TYR A  15      45.919  43.750  97.210  1.00 31.61           C  
ATOM    111  OH  TYR A  15      46.636  44.834  97.661  1.00 31.74           O  
ATOM    112  N   SER A  16      44.876  40.314  92.823  1.00 33.23           N  
ATOM    113  CA  SER A  16      45.851  40.771  91.845  1.00 34.95           C  
ATOM    114  C   SER A  16      45.238  41.240  90.510  1.00 35.15           C  
ATOM    115  O   SER A  16      45.989  41.747  89.691  1.00 34.71           O  
ATOM    116  CB  SER A  16      46.917  39.677  91.554  1.00 34.47           C  
ATOM    117  OG  SER A  16      46.302  38.556  90.870  1.00 40.95           O  
ATOM    118  N   GLU A  17      43.913  41.063  90.288  1.00 35.39           N  
ATOM    119  CA  GLU A  17      43.300  41.347  88.999  1.00 36.23           C  
ATOM    120  C   GLU A  17      43.235  42.853  88.784  1.00 36.95           C  
ATOM    121  O   GLU A  17      42.719  43.573  89.652  1.00 37.78           O  
ATOM    122  CB  GLU A  17      41.868  40.787  88.933  1.00 36.29           C  
ATOM    123  CG  GLU A  17      41.780  39.283  88.758  1.00 37.48           C  
ATOM    124  CD  GLU A  17      42.167  38.819  87.348  1.00 41.39           C  
ATOM    125  OE1 GLU A  17      42.164  39.604  86.364  1.00 41.45           O  
ATOM    126  OE2 GLU A  17      42.454  37.633  87.209  1.00 42.47           O  
ATOM    127  N   GLN A  18      43.689  43.319  87.615  1.00 38.09           N  
ATOM    128  CA  GLN A  18      43.665  44.768  87.263  1.00 39.15           C  
ATOM    129  C   GLN A  18      42.292  45.400  87.489  1.00 37.54           C  
ATOM    130  O   GLN A  18      42.220  46.489  88.052  1.00 37.72           O  
ATOM    131  CB  GLN A  18      44.219  45.065  85.844  1.00 39.12           C  
ATOM    132  CG  GLN A  18      45.789  45.284  85.782  1.00 42.26           C  
ATOM    133  CD  GLN A  18      46.414  45.154  84.351  1.00 43.87           C  
ATOM    134  OE1 GLN A  18      46.420  46.117  83.536  1.00 50.10           O  
ATOM    135  NE2 GLN A  18      46.961  43.965  84.052  1.00 48.09           N  
ATOM    136  N   VAL A  19      41.209  44.701  87.110  1.00 36.85           N  
ATOM    137  CA  VAL A  19      39.845  45.221  87.331  1.00 35.64           C  
ATOM    138  C   VAL A  19      39.453  45.301  88.817  1.00 34.99           C  
ATOM    139  O   VAL A  19      38.669  46.181  89.202  1.00 35.99           O  
ATOM    140  CB  VAL A  19      38.732  44.499  86.479  1.00 35.78           C  
ATOM    141  CG1 VAL A  19      39.025  44.574  84.971  1.00 35.94           C  
ATOM    142  CG2 VAL A  19      38.537  43.056  86.893  1.00 35.97           C  
ATOM    143  N   ILE A  20      39.990  44.429  89.660  1.00 34.18           N  
ATOM    144  CA  ILE A  20      39.791  44.561  91.104  1.00 33.32           C  
ATOM    145  C   ILE A  20      40.697  45.643  91.660  1.00 33.74           C  
ATOM    146  O   ILE A  20      40.246  46.435  92.507  1.00 34.17           O  
ATOM    147  CB  ILE A  20      40.081  43.267  91.853  1.00 33.91           C  
ATOM    148  CG1 ILE A  20      39.096  42.189  91.412  1.00 35.50           C  
ATOM    149  CG2 ILE A  20      40.083  43.479  93.383  1.00 30.21           C  
ATOM    150  CD1 ILE A  20      37.743  42.329  92.070  1.00 37.04           C  
ATOM    151  N   GLN A  21      41.955  45.697  91.212  1.00 32.76           N  
ATOM    152  CA  GLN A  21      42.849  46.780  91.678  1.00 34.14           C  
ATOM    153  C   GLN A  21      42.358  48.211  91.375  1.00 34.47           C  
ATOM    154  O   GLN A  21      42.616  49.166  92.123  1.00 34.32           O  
ATOM    155  CB  GLN A  21      44.276  46.612  91.130  1.00 33.67           C  
ATOM    156  CG  GLN A  21      45.008  45.465  91.758  1.00 33.37           C  
ATOM    157  CD  GLN A  21      45.604  45.782  93.092  1.00 35.43           C  
ATOM    158  OE1 GLN A  21      45.364  45.053  94.057  1.00 37.64           O  
ATOM    159  NE2 GLN A  21      46.404  46.849  93.170  1.00 31.53           N  
ATOM    160  N   ALA A  22      41.676  48.333  90.244  1.00 35.02           N  
ATOM    161  CA  ALA A  22      41.122  49.598  89.756  1.00 34.52           C  
ATOM    162  C   ALA A  22      39.866  50.049  90.532  1.00 34.58           C  
ATOM    163  O   ALA A  22      39.333  51.113  90.253  1.00 34.35           O  
ATOM    164  CB  ALA A  22      40.783  49.438  88.275  1.00 34.15           C  
ATOM    165  N   ASP A  23      39.381  49.227  91.465  1.00 33.96           N  
ATOM    166  CA  ASP A  23      38.142  49.492  92.188  1.00 34.73           C  
ATOM    167  C   ASP A  23      38.362  49.420  93.687  1.00 35.45           C  
ATOM    168  O   ASP A  23      38.494  48.305  94.266  1.00 35.70           O  
ATOM    169  CB  ASP A  23      37.059  48.494  91.816  1.00 35.14           C  
ATOM    170  CG  ASP A  23      35.744  48.847  92.442  1.00 37.19           C  
ATOM    171  OD1 ASP A  23      34.772  49.139  91.715  1.00 43.45           O  
ATOM    172  OD2 ASP A  23      35.665  48.867  93.667  1.00 39.48           O  
ATOM    173  N   ASP A  24      38.360  50.599  94.320  1.00 35.16           N  
ATOM    174  CA  ASP A  24      38.766  50.728  95.702  1.00 34.43           C  
ATOM    175  C   ASP A  24      37.917  49.914  96.687  1.00 34.04           C  
ATOM    176  O   ASP A  24      38.446  49.421  97.672  1.00 31.90           O  
ATOM    177  CB  ASP A  24      38.799  52.194  96.056  1.00 34.35           C  
ATOM    178  CG  ASP A  24      39.887  52.939  95.297  1.00 38.16           C  
ATOM    179  OD1 ASP A  24      40.853  52.296  94.782  1.00 40.68           O  
ATOM    180  OD2 ASP A  24      39.814  54.188  95.236  1.00 41.41           O  
ATOM    181  N   TYR A  25      36.605  49.765  96.419  1.00 34.50           N  
ATOM    182  CA  TYR A  25      35.724  48.974  97.311  1.00 33.10           C  
ATOM    183  C   TYR A  25      35.987  47.452  97.237  1.00 32.95           C  
ATOM    184  O   TYR A  25      36.215  46.791  98.253  1.00 31.85           O  
ATOM    185  CB  TYR A  25      34.255  49.297  97.078  1.00 32.63           C  
ATOM    186  CG  TYR A  25      33.355  48.290  97.725  1.00 31.54           C  
ATOM    187  CD1 TYR A  25      33.105  48.350  99.079  1.00 30.84           C  
ATOM    188  CD2 TYR A  25      32.823  47.228  97.002  1.00 30.19           C  
ATOM    189  CE1 TYR A  25      32.292  47.407  99.699  1.00 28.74           C  
ATOM    190  CE2 TYR A  25      31.982  46.299  97.589  1.00 30.22           C  
ATOM    191  CZ  TYR A  25      31.729  46.393  98.945  1.00 32.64           C  
ATOM    192  OH  TYR A  25      30.932  45.477  99.587  1.00 32.25           O  
ATOM    193  N   PHE A  26      35.992  46.899  96.041  1.00 31.64           N  
ATOM    194  CA  PHE A  26      36.300  45.480  95.928  1.00 31.86           C  
ATOM    195  C   PHE A  26      37.732  45.149  96.339  1.00 31.56           C  
ATOM    196  O   PHE A  26      37.955  44.151  97.013  1.00 31.80           O  
ATOM    197  CB  PHE A  26      35.949  44.903  94.536  1.00 29.61           C  
ATOM    198  CG  PHE A  26      34.457  44.851  94.272  1.00 30.18           C  
ATOM    199  CD1 PHE A  26      33.664  43.890  94.895  1.00 25.78           C  
ATOM    200  CD2 PHE A  26      33.826  45.801  93.422  1.00 25.44           C  
ATOM    201  CE1 PHE A  26      32.301  43.835  94.650  1.00 25.70           C  
ATOM    202  CE2 PHE A  26      32.445  45.723  93.185  1.00 24.56           C  
ATOM    203  CZ  PHE A  26      31.698  44.754  93.802  1.00 23.58           C  
ATOM    204  N   ARG A  27      38.696  45.982  95.954  1.00 31.99           N  
ATOM    205  CA  ARG A  27      40.108  45.693  96.324  1.00 31.34           C  
ATOM    206  C   ARG A  27      40.302  45.545  97.837  1.00 32.36           C  
ATOM    207  O   ARG A  27      41.001  44.606  98.286  1.00 32.08           O  
ATOM    208  CB  ARG A  27      41.070  46.737  95.818  1.00 31.11           C  
ATOM    209  CG  ARG A  27      42.519  46.277  95.841  1.00 32.06           C  
ATOM    210  CD  ARG A  27      43.517  47.404  96.091  1.00 36.49           C  
ATOM    211  NE  ARG A  27      43.011  48.306  97.121  1.00 42.93           N  
ATOM    212  CZ  ARG A  27      43.671  49.325  97.654  1.00 50.24           C  
ATOM    213  NH1 ARG A  27      44.934  49.597  97.321  1.00 51.55           N  
ATOM    214  NH2 ARG A  27      43.063  50.072  98.559  1.00 54.50           N  
ATOM    215  N   GLN A  28      39.743  46.499  98.601  1.00 32.07           N  
ATOM    216  CA  GLN A  28      39.856  46.556 100.062  1.00 32.33           C  
ATOM    217  C   GLN A  28      39.080  45.411 100.735  1.00 31.83           C  
ATOM    218  O   GLN A  28      39.565  44.716 101.607  1.00 32.26           O  
ATOM    219  CB  GLN A  28      39.295  47.892 100.543  1.00 33.20           C  
ATOM    220  CG  GLN A  28      39.472  48.124 102.056  1.00 36.36           C  
ATOM    221  CD  GLN A  28      38.897  49.430 102.474  1.00 41.27           C  
ATOM    222  OE1 GLN A  28      38.880  50.411 101.693  1.00 42.43           O  
ATOM    223  NE2 GLN A  28      38.392  49.471 103.691  1.00 39.55           N  
ATOM    224  N   ALA A  29      37.849  45.240 100.299  1.00 30.69           N  
ATOM    225  CA  ALA A  29      37.025  44.113 100.681  1.00 30.53           C  
ATOM    226  C   ALA A  29      37.755  42.769 100.539  1.00 30.76           C  
ATOM    227  O   ALA A  29      37.868  41.981 101.524  1.00 30.17           O  
ATOM    228  CB  ALA A  29      35.719  44.127  99.876  1.00 29.31           C  
ATOM    229  N   ILE A  30      38.249  42.485  99.338  1.00 30.64           N  
ATOM    230  CA  ILE A  30      38.997  41.219  99.157  1.00 31.37           C  
ATOM    231  C   ILE A  30      40.210  41.170 100.104  1.00 31.99           C  
ATOM    232  O   ILE A  30      40.490  40.134 100.790  1.00 31.96           O  
ATOM    233  CB  ILE A  30      39.436  41.004  97.655  1.00 32.17           C  
ATOM    234  CG1 ILE A  30      38.205  40.864  96.714  1.00 30.21           C  
ATOM    235  CG2 ILE A  30      40.502  39.854  97.539  1.00 31.03           C  
ATOM    236  CD1 ILE A  30      37.332  39.650  97.059  1.00 31.86           C  
ATOM    237  N   PHE A  31      40.880  42.319 100.203  1.00 31.66           N  
ATOM    238  CA  PHE A  31      42.059  42.411 101.006  1.00 31.03           C  
ATOM    239  C   PHE A  31      41.711  42.067 102.472  1.00 31.34           C  
ATOM    240  O   PHE A  31      42.481  41.377 103.167  1.00 30.65           O  
ATOM    241  CB  PHE A  31      42.689  43.789 100.874  1.00 31.02           C  
ATOM    242  CG  PHE A  31      43.683  44.072 101.951  1.00 34.04           C  
ATOM    243  CD1 PHE A  31      44.929  43.456 101.937  1.00 32.56           C  
ATOM    244  CD2 PHE A  31      43.337  44.887 103.030  1.00 37.08           C  
ATOM    245  CE1 PHE A  31      45.851  43.666 102.971  1.00 33.22           C  
ATOM    246  CE2 PHE A  31      44.268  45.133 104.087  1.00 36.04           C  
ATOM    247  CZ  PHE A  31      45.519  44.506 104.042  1.00 34.64           C  
ATOM    248  N   GLU A  32      40.553  42.526 102.937  1.00 30.46           N  
ATOM    249  CA  GLU A  32      40.198  42.336 104.323  1.00 30.89           C  
ATOM    250  C   GLU A  32      39.779  40.921 104.653  1.00 30.58           C  
ATOM    251  O   GLU A  32      40.111  40.404 105.686  1.00 30.85           O  
ATOM    252  CB  GLU A  32      39.103  43.299 104.734  1.00 29.54           C  
ATOM    253  CG  GLU A  32      39.590  44.685 104.834  1.00 34.48           C  
ATOM    254  CD  GLU A  32      38.586  45.660 105.482  1.00 42.53           C  
ATOM    255  OE1 GLU A  32      37.710  45.201 106.271  1.00 45.56           O  
ATOM    256  OE2 GLU A  32      38.699  46.891 105.225  1.00 43.47           O  
ATOM    257  N   LEU A  33      38.995  40.325 103.772  1.00 31.20           N  
ATOM    258  CA  LEU A  33      38.604  38.959 103.883  1.00 32.03           C  
ATOM    259  C   LEU A  33      39.857  38.057 103.857  1.00 32.30           C  
ATOM    260  O   LEU A  33      40.019  37.177 104.738  1.00 31.26           O  
ATOM    261  CB  LEU A  33      37.613  38.620 102.746  1.00 32.34           C  
ATOM    262  CG  LEU A  33      36.350  39.507 102.793  1.00 34.22           C  
ATOM    263  CD1 LEU A  33      35.291  39.269 101.679  1.00 30.18           C  
ATOM    264  CD2 LEU A  33      35.665  39.367 104.170  1.00 37.60           C  
ATOM    265  N   ALA A  34      40.750  38.266 102.884  1.00 32.32           N  
ATOM    266  CA  ALA A  34      42.002  37.442 102.823  1.00 32.80           C  
ATOM    267  C   ALA A  34      42.816  37.617 104.099  1.00 34.90           C  
ATOM    268  O   ALA A  34      43.353  36.628 104.603  1.00 35.83           O  
ATOM    269  CB  ALA A  34      42.830  37.755 101.639  1.00 31.49           C  
ATOM    270  N   SER A  35      42.885  38.830 104.676  1.00 35.42           N  
ATOM    271  CA  SER A  35      43.611  38.996 105.934  1.00 35.87           C  
ATOM    272  C   SER A  35      42.955  38.272 107.090  1.00 36.21           C  
ATOM    273  O   SER A  35      43.650  37.766 107.978  1.00 36.00           O  
ATOM    274  CB  SER A  35      43.755  40.454 106.329  1.00 36.31           C  
ATOM    275  OG  SER A  35      44.180  41.186 105.186  1.00 41.98           O  
ATOM    276  N   GLN A  36      41.628  38.258 107.121  1.00 35.89           N  
ATOM    277  CA  GLN A  36      40.944  37.591 108.203  1.00 36.43           C  
ATOM    278  C   GLN A  36      41.206  36.087 108.132  1.00 36.18           C  
ATOM    279  O   GLN A  36      41.453  35.442 109.139  1.00 34.62           O  
ATOM    280  CB  GLN A  36      39.462  37.938 108.181  1.00 35.03           C  
ATOM    281  CG  GLN A  36      38.641  37.146 109.200  1.00 37.52           C  
ATOM    282  CD  GLN A  36      37.105  37.416 109.107  1.00 39.50           C  
ATOM    283  OE1 GLN A  36      36.283  36.680 109.714  1.00 41.50           O  
ATOM    284  NE2 GLN A  36      36.720  38.465 108.348  1.00 38.95           N  
ATOM    285  N   LEU A  37      41.139  35.543 106.923  1.00 36.69           N  
ATOM    286  CA  LEU A  37      41.440  34.144 106.653  1.00 38.03           C  
ATOM    287  C   LEU A  37      42.861  33.825 107.070  1.00 39.32           C  
ATOM    288  O   LEU A  37      43.114  32.922 107.869  1.00 39.39           O  
ATOM    289  CB  LEU A  37      41.362  33.874 105.158  1.00 36.53           C  
ATOM    290  CG  LEU A  37      40.734  32.594 104.632  1.00 37.34           C  
ATOM    291  CD1 LEU A  37      41.177  32.338 103.213  1.00 37.49           C  
ATOM    292  CD2 LEU A  37      41.008  31.390 105.491  1.00 36.00           C  
ATOM    293  N   GLU A  38      43.801  34.547 106.501  1.00 40.87           N  
ATOM    294  CA  GLU A  38      45.177  34.314 106.868  1.00 43.83           C  
ATOM    295  C   GLU A  38      45.365  34.295 108.379  1.00 45.07           C  
ATOM    296  O   GLU A  38      46.039  33.411 108.918  1.00 45.44           O  
ATOM    297  CB  GLU A  38      46.045  35.377 106.264  1.00 44.14           C  
ATOM    298  CG  GLU A  38      47.489  35.008 106.276  1.00 47.95           C  
ATOM    299  CD  GLU A  38      48.230  35.867 105.300  1.00 53.32           C  
ATOM    300  OE1 GLU A  38      47.660  36.932 104.930  1.00 54.77           O  
ATOM    301  OE2 GLU A  38      49.357  35.482 104.904  1.00 55.94           O  
ATOM    302  N   LYS A  39      44.771  35.278 109.056  1.00 46.04           N  
ATOM    303  CA  LYS A  39      44.943  35.454 110.488  1.00 47.85           C  
ATOM    304  C   LYS A  39      44.212  34.347 111.254  1.00 47.67           C  
ATOM    305  O   LYS A  39      44.863  33.541 111.886  1.00 48.31           O  
ATOM    306  CB  LYS A  39      44.494  36.856 110.945  1.00 47.56           C  
ATOM    307  CG  LYS A  39      44.257  36.993 112.483  1.00 50.59           C  
ATOM    308  CD  LYS A  39      43.241  38.139 112.828  1.00 50.52           C  
ATOM    309  CE  LYS A  39      41.871  37.975 112.099  1.00 53.00           C  
ATOM    310  NZ  LYS A  39      41.094  39.245 111.800  1.00 53.35           N  
ATOM    311  N   GLU A  40      42.879  34.296 111.186  1.00 47.51           N  
ATOM    312  CA  GLU A  40      42.074  33.384 112.015  1.00 46.80           C  
ATOM    313  C   GLU A  40      41.828  32.018 111.381  1.00 45.49           C  
ATOM    314  O   GLU A  40      41.333  31.122 112.065  1.00 45.81           O  
ATOM    315  CB  GLU A  40      40.689  33.985 112.293  1.00 47.08           C  
ATOM    316  CG  GLU A  40      40.558  35.058 113.397  1.00 49.51           C  
ATOM    317  CD  GLU A  40      39.178  35.794 113.369  1.00 49.78           C  
ATOM    318  OE1 GLU A  40      38.250  35.374 112.624  1.00 51.51           O  
ATOM    319  OE2 GLU A  40      39.025  36.793 114.113  1.00 52.97           O  
ATOM    320  N   GLY A  41      42.108  31.843 110.091  1.00 43.17           N  
ATOM    321  CA  GLY A  41      41.584  30.658 109.401  1.00 41.76           C  
ATOM    322  C   GLY A  41      40.138  30.770 108.877  1.00 40.43           C  
ATOM    323  O   GLY A  41      39.514  31.810 108.965  1.00 39.95           O  
HETATM  324  N   MSE A  42      39.612  29.683 108.319  1.00 39.72           N  
HETATM  325  CA  MSE A  42      38.317  29.677 107.610  1.00 39.23           C  
HETATM  326  C   MSE A  42      37.177  29.510 108.566  1.00 38.41           C  
HETATM  327  O   MSE A  42      37.310  28.917 109.635  1.00 38.83           O  
HETATM  328  CB  MSE A  42      38.288  28.513 106.605  1.00 39.80           C  
HETATM  329  CG  MSE A  42      37.203  28.543 105.613  1.00 41.69           C  
HETATM  330 SE   MSE A  42      37.232  30.147 104.427  1.00 52.14          SE  
HETATM  331  CE  MSE A  42      35.659  30.501 104.714  1.00 38.31           C  
ATOM    332  N   SER A  43      36.018  29.973 108.171  1.00 37.92           N  
ATOM    333  CA  SER A  43      34.842  29.761 108.988  1.00 37.49           C  
ATOM    334  C   SER A  43      33.640  29.867 108.080  1.00 36.66           C  
ATOM    335  O   SER A  43      33.737  30.422 106.995  1.00 36.75           O  
ATOM    336  CB  SER A  43      34.778  30.806 110.116  1.00 37.41           C  
ATOM    337  OG  SER A  43      34.780  32.106 109.560  1.00 37.21           O  
ATOM    338  N   SER A  44      32.550  29.266 108.527  1.00 36.16           N  
ATOM    339  CA  SER A  44      31.204  29.389 108.012  1.00 36.63           C  
ATOM    340  C   SER A  44      30.881  30.839 107.702  1.00 37.36           C  
ATOM    341  O   SER A  44      30.506  31.179 106.568  1.00 38.13           O  
ATOM    342  CB  SER A  44      30.268  28.936 109.126  1.00 36.60           C  
ATOM    343  OG  SER A  44      28.996  28.566 108.653  1.00 38.10           O  
ATOM    344  N   LEU A  45      31.042  31.692 108.717  1.00 36.75           N  
ATOM    345  CA  LEU A  45      30.824  33.113 108.598  1.00 36.81           C  
ATOM    346  C   LEU A  45      31.597  33.752 107.452  1.00 35.96           C  
ATOM    347  O   LEU A  45      31.020  34.458 106.612  1.00 36.31           O  
ATOM    348  CB  LEU A  45      31.232  33.754 109.899  1.00 37.35           C  
ATOM    349  CG  LEU A  45      30.551  35.082 110.140  1.00 41.15           C  
ATOM    350  CD1 LEU A  45      29.039  34.897 110.143  1.00 43.76           C  
ATOM    351  CD2 LEU A  45      31.042  35.659 111.474  1.00 43.56           C  
ATOM    352  N   LEU A  46      32.901  33.491 107.418  1.00 35.21           N  
ATOM    353  CA  LEU A  46      33.800  34.091 106.445  1.00 34.63           C  
ATOM    354  C   LEU A  46      33.439  33.615 105.013  1.00 33.97           C  
ATOM    355  O   LEU A  46      33.491  34.386 104.046  1.00 33.64           O  
ATOM    356  CB  LEU A  46      35.266  33.802 106.824  1.00 34.22           C  
ATOM    357  CG  LEU A  46      36.431  34.304 105.934  1.00 35.70           C  
ATOM    358  CD1 LEU A  46      36.356  35.780 105.648  1.00 34.53           C  
ATOM    359  CD2 LEU A  46      37.759  34.044 106.582  1.00 34.45           C  
ATOM    360  N   ALA A  47      33.062  32.343 104.917  1.00 32.20           N  
ATOM    361  CA  ALA A  47      32.653  31.744 103.675  1.00 32.87           C  
ATOM    362  C   ALA A  47      31.502  32.579 103.144  1.00 31.75           C  
ATOM    363  O   ALA A  47      31.492  32.987 101.991  1.00 31.32           O  
ATOM    364  CB  ALA A  47      32.176  30.300 103.933  1.00 32.46           C  
ATOM    365  N   THR A  48      30.562  32.849 104.046  1.00 32.09           N  
ATOM    366  CA  THR A  48      29.342  33.605 103.768  1.00 31.33           C  
ATOM    367  C   THR A  48      29.635  34.978 103.288  1.00 30.95           C  
ATOM    368  O   THR A  48      29.023  35.379 102.278  1.00 31.80           O  
ATOM    369  CB  THR A  48      28.476  33.651 104.975  1.00 31.45           C  
ATOM    370  OG1 THR A  48      27.920  32.345 105.114  1.00 33.01           O  
ATOM    371  CG2 THR A  48      27.291  34.597 104.758  1.00 32.56           C  
ATOM    372  N   LYS A  49      30.588  35.662 103.976  1.00 29.39           N  
ATOM    373  CA  LYS A  49      31.037  36.981 103.609  1.00 29.70           C  
ATOM    374  C   LYS A  49      31.720  37.020 102.251  1.00 28.68           C  
ATOM    375  O   LYS A  49      31.417  37.879 101.451  1.00 29.40           O  
ATOM    376  CB  LYS A  49      31.925  37.630 104.667  1.00 29.20           C  
ATOM    377  CG  LYS A  49      31.298  37.767 106.028  1.00 31.66           C  
ATOM    378  CD  LYS A  49      32.310  38.352 107.004  1.00 31.75           C  
ATOM    379  CE  LYS A  49      31.804  38.305 108.463  1.00 35.31           C  
ATOM    380  NZ  LYS A  49      30.338  38.692 108.669  1.00 37.23           N  
ATOM    381  N   ILE A  50      32.631  36.112 101.970  1.00 28.22           N  
ATOM    382  CA  ILE A  50      33.247  36.117 100.629  1.00 27.81           C  
ATOM    383  C   ILE A  50      32.191  35.803  99.569  1.00 27.96           C  
ATOM    384  O   ILE A  50      32.075  36.480  98.566  1.00 28.80           O  
ATOM    385  CB  ILE A  50      34.408  35.100 100.538  1.00 28.56           C  
ATOM    386  CG1 ILE A  50      35.599  35.454 101.488  1.00 27.60           C  
ATOM    387  CG2 ILE A  50      34.907  34.928  99.030  1.00 29.56           C  
ATOM    388  CD1 ILE A  50      36.420  34.214 102.035  1.00 28.01           C  
ATOM    389  N   ASP A  51      31.378  34.798  99.816  1.00 27.97           N  
ATOM    390  CA  ASP A  51      30.269  34.494  98.899  1.00 29.51           C  
ATOM    391  C   ASP A  51      29.435  35.746  98.531  1.00 29.36           C  
ATOM    392  O   ASP A  51      29.255  36.029  97.320  1.00 29.96           O  
ATOM    393  CB  ASP A  51      29.390  33.379  99.452  1.00 29.24           C  
ATOM    394  CG  ASP A  51      28.492  32.779  98.409  1.00 31.40           C  
ATOM    395  OD1 ASP A  51      28.937  32.544  97.286  1.00 36.37           O  
ATOM    396  OD2 ASP A  51      27.319  32.538  98.707  1.00 35.99           O  
ATOM    397  N   SER A  52      28.986  36.484  99.556  1.00 28.52           N  
ATOM    398  CA  SER A  52      28.196  37.673  99.359  1.00 30.36           C  
ATOM    399  C   SER A  52      28.966  38.691  98.536  1.00 31.49           C  
ATOM    400  O   SER A  52      28.368  39.300  97.636  1.00 32.04           O  
ATOM    401  CB  SER A  52      27.810  38.328 100.685  1.00 30.00           C  
ATOM    402  OG  SER A  52      26.939  37.491 101.465  1.00 33.96           O  
ATOM    403  N   LEU A  53      30.258  38.897  98.858  1.00 31.15           N  
ATOM    404  CA  LEU A  53      31.062  39.883  98.127  1.00 31.40           C  
ATOM    405  C   LEU A  53      31.245  39.474  96.632  1.00 31.52           C  
ATOM    406  O   LEU A  53      31.041  40.287  95.726  1.00 32.33           O  
ATOM    407  CB  LEU A  53      32.409  40.129  98.839  1.00 31.03           C  
ATOM    408  CG  LEU A  53      33.380  41.098  98.184  1.00 29.82           C  
ATOM    409  CD1 LEU A  53      32.835  42.511  98.286  1.00 27.19           C  
ATOM    410  CD2 LEU A  53      34.779  41.034  98.767  1.00 32.55           C  
ATOM    411  N   ILE A  54      31.545  38.201  96.376  1.00 31.44           N  
ATOM    412  CA  ILE A  54      31.724  37.713  95.013  1.00 31.10           C  
ATOM    413  C   ILE A  54      30.411  37.664  94.243  1.00 30.41           C  
ATOM    414  O   ILE A  54      30.371  38.083  93.082  1.00 30.82           O  
ATOM    415  CB  ILE A  54      32.483  36.342  94.967  1.00 31.36           C  
ATOM    416  CG1 ILE A  54      33.846  36.446  95.661  1.00 33.36           C  
ATOM    417  CG2 ILE A  54      32.744  35.948  93.531  1.00 31.28           C  
ATOM    418  CD1 ILE A  54      34.842  37.425  94.918  1.00 33.02           C  
ATOM    419  N   ASN A  55      29.326  37.217  94.871  1.00 29.38           N  
ATOM    420  CA  ASN A  55      28.002  37.379  94.205  1.00 30.00           C  
ATOM    421  C   ASN A  55      27.764  38.816  93.755  1.00 30.78           C  
ATOM    422  O   ASN A  55      27.358  39.038  92.599  1.00 30.84           O  
ATOM    423  CB  ASN A  55      26.848  36.922  95.077  1.00 28.15           C  
ATOM    424  CG  ASN A  55      26.924  35.480  95.368  1.00 29.05           C  
ATOM    425  OD1 ASN A  55      27.677  34.746  94.715  1.00 28.60           O  
ATOM    426  ND2 ASN A  55      26.153  35.034  96.333  1.00 29.27           N  
ATOM    427  N   GLN A  56      28.029  39.766  94.674  1.00 30.97           N  
ATOM    428  CA  GLN A  56      27.850  41.175  94.451  1.00 32.21           C  
ATOM    429  C   GLN A  56      28.719  41.616  93.283  1.00 32.07           C  
ATOM    430  O   GLN A  56      28.255  42.326  92.409  1.00 32.35           O  
ATOM    431  CB  GLN A  56      28.220  41.934  95.711  1.00 32.67           C  
ATOM    432  CG  GLN A  56      28.670  43.388  95.486  1.00 34.94           C  
ATOM    433  CD  GLN A  56      28.815  44.196  96.788  1.00 34.23           C  
ATOM    434  OE1 GLN A  56      29.367  43.721  97.787  1.00 38.19           O  
ATOM    435  NE2 GLN A  56      28.334  45.412  96.773  1.00 34.67           N  
ATOM    436  N   TYR A  57      29.983  41.167  93.246  1.00 32.16           N  
ATOM    437  CA  TYR A  57      30.853  41.527  92.124  1.00 31.50           C  
ATOM    438  C   TYR A  57      30.283  40.972  90.785  1.00 31.81           C  
ATOM    439  O   TYR A  57      30.112  41.702  89.748  1.00 30.22           O  
ATOM    440  CB  TYR A  57      32.280  41.041  92.349  1.00 30.90           C  
ATOM    441  CG  TYR A  57      33.137  41.550  91.283  1.00 30.75           C  
ATOM    442  CD1 TYR A  57      33.829  42.730  91.450  1.00 29.31           C  
ATOM    443  CD2 TYR A  57      33.168  40.912  90.031  1.00 33.72           C  
ATOM    444  CE1 TYR A  57      34.599  43.274  90.392  1.00 32.76           C  
ATOM    445  CE2 TYR A  57      33.930  41.434  88.957  1.00 35.22           C  
ATOM    446  CZ  TYR A  57      34.649  42.623  89.147  1.00 34.15           C  
ATOM    447  OH  TYR A  57      35.391  43.159  88.114  1.00 33.17           O  
ATOM    448  N   ILE A  58      29.950  39.681  90.810  1.00 31.45           N  
ATOM    449  CA  ILE A  58      29.443  39.022  89.556  1.00 31.38           C  
ATOM    450  C   ILE A  58      28.167  39.716  89.037  1.00 31.95           C  
ATOM    451  O   ILE A  58      28.067  40.110  87.858  1.00 31.28           O  
ATOM    452  CB  ILE A  58      29.241  37.484  89.737  1.00 31.06           C  
ATOM    453  CG1 ILE A  58      30.581  36.828  90.102  1.00 30.23           C  
ATOM    454  CG2 ILE A  58      28.711  36.882  88.490  1.00 29.97           C  
ATOM    455  CD1 ILE A  58      30.510  35.341  90.466  1.00 29.31           C  
ATOM    456  N   LEU A  59      27.202  39.898  89.931  1.00 31.94           N  
ATOM    457  CA  LEU A  59      25.931  40.484  89.509  1.00 32.14           C  
ATOM    458  C   LEU A  59      26.130  41.957  89.042  1.00 32.71           C  
ATOM    459  O   LEU A  59      25.466  42.413  88.099  1.00 32.69           O  
ATOM    460  CB  LEU A  59      24.951  40.364  90.638  1.00 30.85           C  
ATOM    461  CG  LEU A  59      24.504  38.935  91.030  1.00 31.48           C  
ATOM    462  CD1 LEU A  59      23.446  39.011  92.143  1.00 30.25           C  
ATOM    463  CD2 LEU A  59      23.879  38.179  89.834  1.00 30.75           C  
ATOM    464  N   THR A  60      27.061  42.681  89.689  1.00 31.80           N  
ATOM    465  CA  THR A  60      27.230  44.090  89.421  1.00 31.50           C  
ATOM    466  C   THR A  60      27.795  44.213  88.019  1.00 30.94           C  
ATOM    467  O   THR A  60      27.529  45.169  87.327  1.00 28.32           O  
ATOM    468  CB  THR A  60      28.154  44.789  90.469  1.00 31.40           C  
ATOM    469  OG1 THR A  60      27.516  44.800  91.748  1.00 35.50           O  
ATOM    470  CG2 THR A  60      28.390  46.246  90.119  1.00 31.81           C  
ATOM    471  N   HIS A  61      28.603  43.230  87.624  1.00 31.70           N  
ATOM    472  CA  HIS A  61      29.268  43.279  86.336  1.00 31.73           C  
ATOM    473  C   HIS A  61      28.628  42.428  85.279  1.00 32.02           C  
ATOM    474  O   HIS A  61      29.263  42.105  84.312  1.00 32.51           O  
ATOM    475  CB  HIS A  61      30.692  42.879  86.509  1.00 30.85           C  
ATOM    476  CG  HIS A  61      31.490  43.915  87.202  1.00 32.92           C  
ATOM    477  ND1 HIS A  61      32.126  44.931  86.514  1.00 33.75           N  
ATOM    478  CD2 HIS A  61      31.701  44.145  88.523  1.00 31.84           C  
ATOM    479  CE1 HIS A  61      32.729  45.722  87.387  1.00 37.04           C  
ATOM    480  NE2 HIS A  61      32.502  45.257  88.609  1.00 37.09           N  
ATOM    481  N   GLN A  62      27.383  42.041  85.492  1.00 33.48           N  
ATOM    482  CA  GLN A  62      26.606  41.271  84.491  1.00 35.82           C  
ATOM    483  C   GLN A  62      27.295  39.997  83.994  1.00 35.62           C  
ATOM    484  O   GLN A  62      27.204  39.664  82.827  1.00 35.48           O  
ATOM    485  CB  GLN A  62      26.193  42.170  83.320  1.00 36.19           C  
ATOM    486  CG  GLN A  62      25.549  43.509  83.798  1.00 42.20           C  
ATOM    487  CD  GLN A  62      24.270  43.287  84.632  1.00 49.33           C  
ATOM    488  OE1 GLN A  62      24.143  43.817  85.744  1.00 53.59           O  
ATOM    489  NE2 GLN A  62      23.340  42.462  84.108  1.00 50.50           N  
ATOM    490  N   PHE A  63      27.956  39.282  84.920  1.00 35.60           N  
ATOM    491  CA  PHE A  63      28.607  38.016  84.652  1.00 35.03           C  
ATOM    492  C   PHE A  63      29.860  38.229  83.800  1.00 35.71           C  
ATOM    493  O   PHE A  63      30.462  37.284  83.321  1.00 36.03           O  
ATOM    494  CB  PHE A  63      27.598  37.015  84.065  1.00 34.92           C  
ATOM    495  CG  PHE A  63      26.389  36.852  84.929  1.00 35.28           C  
ATOM    496  CD1 PHE A  63      26.399  35.956  85.989  1.00 35.43           C  
ATOM    497  CD2 PHE A  63      25.277  37.678  84.764  1.00 36.49           C  
ATOM    498  CE1 PHE A  63      25.307  35.848  86.849  1.00 33.53           C  
ATOM    499  CE2 PHE A  63      24.172  37.574  85.600  1.00 34.75           C  
ATOM    500  CZ  PHE A  63      24.202  36.640  86.661  1.00 36.31           C  
ATOM    501  N   ASP A  64      30.272  39.479  83.662  1.00 36.52           N  
ATOM    502  CA  ASP A  64      31.513  39.811  82.959  1.00 37.84           C  
ATOM    503  C   ASP A  64      32.599  40.020  84.017  1.00 38.00           C  
ATOM    504  O   ASP A  64      32.848  41.142  84.479  1.00 38.85           O  
ATOM    505  CB  ASP A  64      31.326  41.075  82.077  1.00 37.42           C  
ATOM    506  CG  ASP A  64      32.522  41.361  81.184  1.00 39.83           C  
ATOM    507  OD1 ASP A  64      33.498  40.545  81.172  1.00 39.93           O  
ATOM    508  OD2 ASP A  64      32.477  42.413  80.488  1.00 39.58           O  
ATOM    509  N   ALA A  65      33.224  38.918  84.416  1.00 37.11           N  
ATOM    510  CA  ALA A  65      34.238  38.903  85.477  1.00 35.95           C  
ATOM    511  C   ALA A  65      35.302  37.902  85.015  1.00 34.62           C  
ATOM    512  O   ALA A  65      34.972  36.918  84.315  1.00 33.87           O  
ATOM    513  CB  ALA A  65      33.623  38.465  86.800  1.00 34.97           C  
ATOM    514  N   PRO A  66      36.575  38.159  85.376  1.00 33.26           N  
ATOM    515  CA  PRO A  66      37.693  37.275  85.026  1.00 32.13           C  
ATOM    516  C   PRO A  66      37.487  35.857  85.608  1.00 32.25           C  
ATOM    517  O   PRO A  66      36.739  35.703  86.606  1.00 31.87           O  
ATOM    518  CB  PRO A  66      38.874  37.968  85.685  1.00 32.14           C  
ATOM    519  CG  PRO A  66      38.438  39.388  85.866  1.00 31.99           C  
ATOM    520  CD  PRO A  66      37.006  39.338  86.150  1.00 32.11           C  
ATOM    521  N   LYS A  67      38.140  34.849  85.017  1.00 31.23           N  
ATOM    522  CA  LYS A  67      38.001  33.467  85.450  1.00 31.57           C  
ATOM    523  C   LYS A  67      38.207  33.328  86.959  1.00 31.14           C  
ATOM    524  O   LYS A  67      37.473  32.585  87.623  1.00 29.84           O  
ATOM    525  CB  LYS A  67      38.961  32.525  84.678  1.00 31.91           C  
ATOM    526  CG  LYS A  67      38.907  30.983  85.064  1.00 33.04           C  
ATOM    527  CD  LYS A  67      39.351  29.935  83.971  1.00 33.71           C  
ATOM    528  CE  LYS A  67      40.785  30.193  83.324  1.00 39.56           C  
ATOM    529  NZ  LYS A  67      41.465  29.156  82.340  1.00 36.51           N  
ATOM    530  N   SER A  68      39.202  34.054  87.492  1.00 30.85           N  
ATOM    531  CA  SER A  68      39.571  33.901  88.904  1.00 31.09           C  
ATOM    532  C   SER A  68      38.405  34.183  89.846  1.00 29.98           C  
ATOM    533  O   SER A  68      38.281  33.592  90.906  1.00 30.10           O  
ATOM    534  CB  SER A  68      40.764  34.792  89.251  1.00 31.05           C  
ATOM    535  OG  SER A  68      40.475  36.159  89.034  1.00 33.34           O  
ATOM    536  N   ILE A  69      37.533  35.069  89.433  1.00 30.96           N  
ATOM    537  CA  ILE A  69      36.353  35.463  90.225  1.00 31.86           C  
ATOM    538  C   ILE A  69      35.394  34.298  90.273  1.00 31.63           C  
ATOM    539  O   ILE A  69      34.908  33.900  91.336  1.00 31.07           O  
ATOM    540  CB  ILE A  69      35.736  36.722  89.630  1.00 32.65           C  
ATOM    541  CG1 ILE A  69      36.767  37.869  89.745  1.00 34.81           C  
ATOM    542  CG2 ILE A  69      34.355  37.056  90.274  1.00 33.52           C  
ATOM    543  CD1 ILE A  69      36.313  39.114  90.494  1.00 38.57           C  
ATOM    544  N   PHE A  70      35.182  33.698  89.124  1.00 31.58           N  
ATOM    545  CA  PHE A  70      34.363  32.500  89.076  1.00 32.18           C  
ATOM    546  C   PHE A  70      34.988  31.317  89.786  1.00 32.53           C  
ATOM    547  O   PHE A  70      34.260  30.518  90.407  1.00 32.60           O  
ATOM    548  CB  PHE A  70      34.023  32.148  87.645  1.00 32.82           C  
ATOM    549  CG  PHE A  70      32.987  33.076  87.018  1.00 34.33           C  
ATOM    550  CD1 PHE A  70      31.653  33.079  87.468  1.00 35.11           C  
ATOM    551  CD2 PHE A  70      33.352  33.957  85.980  1.00 32.83           C  
ATOM    552  CE1 PHE A  70      30.680  33.957  86.861  1.00 38.49           C  
ATOM    553  CE2 PHE A  70      32.411  34.798  85.363  1.00 31.59           C  
ATOM    554  CZ  PHE A  70      31.082  34.813  85.798  1.00 33.49           C  
ATOM    555  N   ASP A  71      36.316  31.178  89.665  1.00 31.41           N  
ATOM    556  CA  ASP A  71      37.041  30.176  90.391  1.00 31.64           C  
ATOM    557  C   ASP A  71      36.870  30.270  91.931  1.00 31.39           C  
ATOM    558  O   ASP A  71      36.407  29.323  92.570  1.00 31.92           O  
ATOM    559  CB  ASP A  71      38.527  30.267  90.047  1.00 32.97           C  
ATOM    560  CG  ASP A  71      38.860  29.713  88.672  1.00 36.12           C  
ATOM    561  OD1 ASP A  71      37.997  29.134  87.964  1.00 41.36           O  
ATOM    562  OD2 ASP A  71      40.034  29.890  88.294  1.00 40.06           O  
ATOM    563  N   LEU A  72      37.268  31.404  92.514  1.00 29.92           N  
ATOM    564  CA  LEU A  72      36.927  31.762  93.878  1.00 29.53           C  
ATOM    565  C   LEU A  72      35.460  31.545  94.215  1.00 29.30           C  
ATOM    566  O   LEU A  72      35.114  30.905  95.217  1.00 30.68           O  
ATOM    567  CB  LEU A  72      37.273  33.244  94.159  1.00 29.15           C  
ATOM    568  CG  LEU A  72      36.958  33.754  95.553  1.00 27.50           C  
ATOM    569  CD1 LEU A  72      37.552  32.829  96.685  1.00 31.87           C  
ATOM    570  CD2 LEU A  72      37.519  35.169  95.694  1.00 28.02           C  
ATOM    571  N   SER A  73      34.587  32.097  93.433  1.00 27.95           N  
ATOM    572  CA  SER A  73      33.140  31.883  93.725  1.00 28.82           C  
ATOM    573  C   SER A  73      32.811  30.398  93.927  1.00 29.07           C  
ATOM    574  O   SER A  73      32.128  30.047  94.864  1.00 27.24           O  
ATOM    575  CB  SER A  73      32.283  32.386  92.579  1.00 27.53           C  
ATOM    576  OG  SER A  73      30.918  32.193  92.873  1.00 32.10           O  
ATOM    577  N   ARG A  74      33.342  29.541  93.029  1.00 29.43           N  
ATOM    578  CA  ARG A  74      33.106  28.145  93.041  1.00 29.54           C  
ATOM    579  C   ARG A  74      33.576  27.493  94.353  1.00 30.44           C  
ATOM    580  O   ARG A  74      32.861  26.691  94.984  1.00 29.70           O  
ATOM    581  CB  ARG A  74      33.823  27.523  91.841  1.00 30.35           C  
ATOM    582  CG  ARG A  74      33.736  26.041  91.859  1.00 29.51           C  
ATOM    583  CD  ARG A  74      34.918  25.367  91.284  1.00 27.46           C  
ATOM    584  NE  ARG A  74      34.654  23.939  91.331  1.00 26.55           N  
ATOM    585  CZ  ARG A  74      35.294  23.053  90.585  1.00 28.77           C  
ATOM    586  NH1 ARG A  74      36.232  23.473  89.742  1.00 27.84           N  
ATOM    587  NH2 ARG A  74      34.988  21.769  90.673  1.00 26.33           N  
ATOM    588  N   LEU A  75      34.795  27.840  94.740  1.00 29.94           N  
ATOM    589  CA  LEU A  75      35.385  27.333  95.934  1.00 30.81           C  
ATOM    590  C   LEU A  75      34.609  27.650  97.217  1.00 31.87           C  
ATOM    591  O   LEU A  75      34.473  26.768  98.069  1.00 32.62           O  
ATOM    592  CB  LEU A  75      36.848  27.821  96.062  1.00 31.10           C  
ATOM    593  CG  LEU A  75      37.835  27.318  95.004  1.00 32.12           C  
ATOM    594  CD1 LEU A  75      39.264  27.686  95.380  1.00 30.38           C  
ATOM    595  CD2 LEU A  75      37.747  25.806  94.860  1.00 35.57           C  
ATOM    596  N   VAL A  76      34.183  28.900  97.409  1.00 32.19           N  
ATOM    597  CA  VAL A  76      33.471  29.252  98.634  1.00 33.29           C  
ATOM    598  C   VAL A  76      32.046  28.764  98.559  1.00 34.46           C  
ATOM    599  O   VAL A  76      31.450  28.489  99.621  1.00 35.47           O  
ATOM    600  CB  VAL A  76      33.488  30.793  99.020  1.00 32.17           C  
ATOM    601  CG1 VAL A  76      34.863  31.223  99.261  1.00 32.63           C  
ATOM    602  CG2 VAL A  76      32.941  31.599  97.925  1.00 34.10           C  
ATOM    603  N   LYS A  77      31.481  28.628  97.353  1.00 34.57           N  
ATOM    604  CA  LYS A  77      30.160  27.921  97.268  1.00 36.07           C  
ATOM    605  C   LYS A  77      30.200  26.459  97.752  1.00 38.24           C  
ATOM    606  O   LYS A  77      29.282  26.000  98.406  1.00 38.11           O  
ATOM    607  CB  LYS A  77      29.457  28.081  95.910  1.00 34.84           C  
ATOM    608  CG  LYS A  77      28.697  29.461  95.768  1.00 36.47           C  
ATOM    609  CD  LYS A  77      28.177  29.792  94.329  1.00 35.27           C  
ATOM    610  CE  LYS A  77      27.978  31.304  94.138  1.00 31.33           C  
ATOM    611  NZ  LYS A  77      27.149  31.870  95.256  1.00 31.05           N  
ATOM    612  N   THR A  78      31.274  25.740  97.442  1.00 41.01           N  
ATOM    613  CA  THR A  78      31.457  24.363  97.926  1.00 43.66           C  
ATOM    614  C   THR A  78      31.427  24.272  99.477  1.00 44.40           C  
ATOM    615  O   THR A  78      30.608  23.531 100.014  1.00 45.95           O  
ATOM    616  CB  THR A  78      32.744  23.778  97.313  1.00 43.84           C  
ATOM    617  OG1 THR A  78      32.683  23.960  95.897  1.00 45.13           O  
ATOM    618  CG2 THR A  78      32.886  22.297  97.599  1.00 44.40           C  
ATOM    619  N   LYS A  79      32.316  24.989 100.181  1.00 45.93           N  
ATOM    620  CA  LYS A  79      32.094  25.475 101.598  1.00 47.02           C  
ATOM    621  C   LYS A  79      33.332  26.266 101.856  1.00 48.04           C  
ATOM    622  O   LYS A  79      34.317  26.089 101.134  1.00 49.01           O  
ATOM    623  CB  LYS A  79      31.998  24.404 102.726  1.00 46.92           C  
ATOM    624  CG  LYS A  79      31.329  22.976 102.433  1.00 49.09           C  
ATOM    625  CD  LYS A  79      31.775  21.834 103.414  1.00 46.24           C  
ATOM    626  CE  LYS A  79      32.088  20.545 102.614  1.00 46.07           C  
ATOM    627  NZ  LYS A  79      33.060  20.717 101.446  1.00 42.91           N  
TER     628      LYS A  79                                                      
END
MOLECULE T0496_4_122.pdb
ATOM      1  N   PRO     4      36.250  18.877 100.419  1.00126.33           N  
ATOM      2  CA  PRO     4      36.001  19.915  99.413  1.00124.51           C  
ATOM      3  C   PRO     4      37.048  21.022  99.469  1.00125.13           C  
ATOM      4  O   PRO     4      38.211  20.787  99.138  1.00127.61           O  
ATOM      5  CB  PRO     4      34.632  20.466  99.818  1.00125.32           C  
ATOM      6  CG  PRO     4      33.962  19.327 100.500  1.00121.87           C  
ATOM      7  CD  PRO     4      35.049  18.581 101.220  1.00130.35           C  
ATOM      8  N   VAL     5      36.635  22.214  99.886  1.00119.84           N  
ATOM      9  CA  VAL     5      37.466  23.415  99.734  1.00107.77           C  
ATOM     10  C   VAL     5      38.099  23.855 101.061  1.00100.94           C  
ATOM     11  O   VAL     5      37.438  23.869 102.102  1.00 94.89           O  
ATOM     12  CB  VAL     5      36.652  24.587  99.107  1.00107.75           C  
ATOM     13  CG1 VAL     5      37.577  25.679  98.576  1.00 88.65           C  
ATOM     14  CG2 VAL     5      35.760  24.081  97.980  1.00101.53           C  
ATOM     15  N   SER     6      39.384  24.211 101.004  1.00 99.68           N  
ATOM     16  CA  SER     6      40.148  24.635 102.180  1.00 91.17           C  
ATOM     17  C   SER     6      40.377  26.152 102.243  1.00 85.27           C  
ATOM     18  O   SER     6      40.045  26.881 101.305  1.00 80.81           O  
ATOM     19  CB  SER     6      41.485  23.887 102.244  1.00 92.89           C  
ATOM     20  OG  SER     6      42.256  24.108 101.075  1.00 94.88           O  
ATOM     21  N   VAL     7      40.955  26.603 103.357  1.00 77.69           N  
ATOM     22  CA  VAL     7      41.146  28.027 103.663  1.00 67.00           C  
ATOM     23  C   VAL     7      42.287  28.655 102.855  1.00 73.76           C  
ATOM     24  O   VAL     7      42.125  29.739 102.284  1.00 70.86           O  
ATOM     25  CB  VAL     7      41.386  28.239 105.189  1.00 56.84           C  
ATOM     26  CG1 VAL     7      41.504  29.720 105.535  1.00 44.52           C  
ATOM     27  CG2 VAL     7      40.260  27.609 105.996  1.00 60.50           C  
ATOM     28  N   ASN     8      43.429  27.964 102.811  1.00 79.15           N  
ATOM     29  CA  ASN     8      44.614  28.407 102.064  1.00 82.93           C  
ATOM     30  C   ASN     8      44.353  28.483 100.565  1.00 82.41           C  
ATOM     31  O   ASN     8      44.933  29.314  99.868  1.00 69.82           O  
ATOM     32  CB  ASN     8      45.797  27.466 102.313  1.00 88.19           C  
ATOM     33  CG  ASN     8      45.839  26.934 103.733  1.00114.21           C  
ATOM     34  OD1 ASN     8      46.100  27.681 104.683  1.00130.04           O  
ATOM     35  ND2 ASN     8      45.591  25.630 103.881  1.00130.36           N  
ATOM     36  N   GLU     9      43.480  27.595 100.092  1.00 83.32           N  
ATOM     37  CA  GLU     9      43.007  27.568  98.713  1.00 85.50           C  
ATOM     38  C   GLU     9      42.250  28.849  98.365  1.00 71.59           C  
ATOM     39  O   GLU     9      42.421  29.397  97.276  1.00 49.75           O  
ATOM     40  CB  GLU     9      42.100  26.354  98.514  1.00 91.21           C  
ATOM     41  CG  GLU     9      41.941  25.894  97.075  1.00105.16           C  
ATOM     42  CD  GLU     9      41.154  24.600  96.967  1.00104.81           C  
ATOM     43  OE1 GLU     9      41.478  23.634  97.694  1.00128.20           O  
ATOM     44  OE2 GLU     9      40.215  24.543  96.146  1.00128.75           O  
ATOM     45  N   LYS    10      41.422  29.316  99.301  1.00 64.67           N  
ATOM     46  CA  LYS    10      40.664  30.558  99.143  1.00 50.06           C  
ATOM     47  C   LYS    10      41.562  31.786  99.278  1.00 55.22           C  
ATOM     48  O   LYS    10      41.451  32.721  98.484  1.00 39.45           O  
ATOM     49  CB  LYS    10      39.520  30.630 100.159  1.00 46.21           C  
ATOM     50  CG  LYS    10      38.442  29.572  99.977  1.00 55.81           C  
ATOM     51  CD  LYS    10      37.454  29.599 101.131  1.00 24.13           C  
ATOM     52  CE  LYS    10      36.592  28.342 101.154  1.00 39.89           C  
ATOM     53  NZ  LYS    10      35.728  28.288 102.368  1.00 67.89           N  
ATOM     54  N   LYS    11      42.441  31.767 100.285  1.00 48.64           N  
ATOM     55  CA  LYS    11      43.408  32.842 100.546  1.00 45.25           C  
ATOM     56  C   LYS    11      44.308  33.122  99.349  1.00 49.17           C  
ATOM     57  O   LYS    11      44.501  34.277  98.962  1.00 43.86           O  
ATOM     58  CB  LYS    11      44.301  32.484 101.735  1.00 39.85           C  
ATOM     59  CG  LYS    11      43.695  32.691 103.103  1.00 57.76           C  
ATOM     60  CD  LYS    11      44.805  32.720 104.140  1.00  5.48           C  
ATOM     61  CE  LYS    11      44.286  32.363 105.520  1.00 66.84           C  
ATOM     62  NZ  LYS    11      45.381  32.369 106.532  1.00 74.77           N  
ATOM     63  N   ASP    12      44.853  32.051  98.775  1.00 52.53           N  
ATOM     64  CA  ASP    12      45.754  32.147  97.633  1.00 66.79           C  
ATOM     65  C   ASP    12      45.012  32.497  96.345  1.00 62.97           C  
ATOM     66  O   ASP    12      45.597  33.094  95.440  1.00 55.08           O  
ATOM     67  CB  ASP    12      46.544  30.850  97.456  1.00 73.82           C  
ATOM     68  CG  ASP    12      47.718  31.008  96.517  1.00102.22           C  
ATOM     69  OD1 ASP    12      47.613  30.542  95.362  1.00130.59           O  
ATOM     70  OD2 ASP    12      48.736  31.612  96.923  1.00119.67           O  
ATOM     71  N   PHE    13      43.734  32.119  96.267  1.00 66.99           N  
ATOM     72  CA  PHE    13      42.888  32.486  95.130  1.00 56.84           C  
ATOM     73  C   PHE    13      42.672  33.996  95.059  1.00 54.17           C  
ATOM     74  O   PHE    13      42.798  34.584  93.985  1.00 38.21           O  
ATOM     75  CB  PHE    13      41.537  31.755  95.161  1.00 35.95           C  
ATOM     76  CG  PHE    13      40.511  32.338  94.224  1.00 61.09           C  
ATOM     77  CD1 PHE    13      40.651  32.202  92.844  1.00 70.08           C  
ATOM     78  CD2 PHE    13      39.413  33.037  94.720  1.00 81.31           C  
ATOM     79  CE1 PHE    13      39.715  32.753  91.977  1.00 61.10           C  
ATOM     80  CE2 PHE    13      38.471  33.588  93.858  1.00 74.91           C  
ATOM     81  CZ  PHE    13      38.622  33.444  92.486  1.00 61.44           C  
ATOM     82  N   VAL    14      42.344  34.606  96.199  1.00 49.01           N  
ATOM     83  CA  VAL    14      42.154  36.059  96.301  1.00 48.53           C  
ATOM     84  C   VAL    14      43.472  36.787  96.023  1.00 51.26           C  
ATOM     85  O   VAL    14      43.491  37.814  95.335  1.00 35.61           O  
ATOM     86  CB  VAL    14      41.587  36.474  97.689  1.00 49.32           C  
ATOM     87  CG1 VAL    14      41.388  37.982  97.783  1.00 40.40           C  
ATOM     88  CG2 VAL    14      40.276  35.779  97.958  1.00 45.96           C  
ATOM     89  N   LYS    15      44.565  36.228  96.546  1.00 53.00           N  
ATOM     90  CA  LYS    15      45.920  36.723  96.294  1.00 57.32           C  
ATOM     91  C   LYS    15      46.273  36.674  94.803  1.00 57.75           C  
ATOM     92  O   LYS    15      46.907  37.596  94.283  1.00 61.78           O  
ATOM     93  CB  LYS    15      46.940  35.919  97.110  1.00 54.99           C  
ATOM     94  CG  LYS    15      48.342  36.520  97.148  1.00 70.96           C  
ATOM     95  CD  LYS    15      49.350  35.544  97.737  1.00 94.48           C  
ATOM     96  CE  LYS    15      50.767  36.092  97.648  1.00102.05           C  
ATOM     97  NZ  LYS    15      51.775  35.124  98.168  1.00 93.67           N  
ATOM     98  N   TRP    16      45.853  35.603  94.126  1.00 58.07           N  
ATOM     99  CA  TRP    16      46.032  35.474  92.679  1.00 64.97           C  
ATOM    100  C   TRP    16      45.142  36.446  91.907  1.00 55.53           C  
ATOM    101  O   TRP    16      45.617  37.138  91.003  1.00 49.84           O  
ATOM    102  CB  TRP    16      45.759  34.038  92.213  1.00 77.49           C  
ATOM    103  CG  TRP    16      45.646  33.907  90.716  1.00 93.75           C  
ATOM    104  CD1 TRP    16      46.675  33.872  89.818  1.00 94.66           C  
ATOM    105  CD2 TRP    16      44.438  33.804  89.946  1.00110.74           C  
ATOM    106  NE1 TRP    16      46.186  33.752  88.539  1.00 85.41           N  
ATOM    107  CE2 TRP    16      44.817  33.709  88.588  1.00106.09           C  
ATOM    108  CE3 TRP    16      43.073  33.788  90.272  1.00108.96           C  
ATOM    109  CZ2 TRP    16      43.882  33.593  87.554  1.00 92.48           C  
ATOM    110  CZ3 TRP    16      42.143  33.670  89.243  1.00 88.27           C  
ATOM    111  CH2 TRP    16      42.554  33.575  87.900  1.00 91.46           C  
ATOM    112  N   PHE    17      43.857  36.477  92.268  1.00 52.15           N  
ATOM    113  CA  PHE    17      42.840  37.278  91.577  1.00 46.03           C  
ATOM    114  C   PHE    17      43.159  38.772  91.558  1.00 45.00           C  
ATOM    115  O   PHE    17      43.011  39.429  90.525  1.00 39.80           O  
ATOM    116  CB  PHE    17      41.450  37.032  92.190  1.00 37.75           C  
ATOM    117  CG  PHE    17      40.401  38.012  91.736  1.00 44.98           C  
ATOM    118  CD1 PHE    17      39.874  37.940  90.451  1.00 34.59           C  
ATOM    119  CD2 PHE    17      39.940  39.008  92.595  1.00 52.39           C  
ATOM    120  CE1 PHE    17      38.912  38.849  90.024  1.00 36.78           C  
ATOM    121  CE2 PHE    17      38.978  39.920  92.176  1.00 46.87           C  
ATOM    122  CZ  PHE    17      38.461  39.839  90.888  1.00 46.11           C  
ATOM    123  N   LEU    18      43.600  39.292  92.702  1.00 48.42           N  
ATOM    124  CA  LEU    18      43.920  40.713  92.846  1.00 54.75           C  
ATOM    125  C   LEU    18      45.206  41.112  92.125  1.00 64.57           C  
ATOM    126  O   LEU    18      45.377  42.274  91.748  1.00 70.78           O  
ATOM    127  CB  LEU    18      44.001  41.100  94.327  1.00 53.04           C  
ATOM    128  CG  LEU    18      42.683  41.160  95.107  1.00 47.69           C  
ATOM    129  CD1 LEU    18      42.960  41.302  96.595  1.00 23.90           C  
ATOM    130  CD2 LEU    18      41.809  42.310  94.614  1.00 37.79           C  
ATOM    131  N   ASN    19      46.100  40.145  91.934  1.00 71.72           N  
ATOM    132  CA  ASN    19      47.373  40.376  91.254  1.00 74.85           C  
ATOM    133  C   ASN    19      47.278  40.265  89.729  1.00 67.96           C  
ATOM    134  O   ASN    19      48.226  40.604  89.015  1.00 75.30           O  
ATOM    135  CB  ASN    19      48.447  39.421  91.793  1.00 75.25           C  
ATOM    136  CG  ASN    19      49.049  39.894  93.110  1.00105.13           C  
ATOM    137  OD1 ASN    19      50.229  40.248  93.166  1.00124.46           O  
ATOM    138  ND2 ASN    19      48.242  39.905  94.174  1.00113.30           N  
ATOM    139  N   ASN    20      46.130  39.801  89.239  1.00 68.40           N  
ATOM    140  CA  ASN    20      45.927  39.568  87.810  1.00 67.61           C  
ATOM    141  C   ASN    20      44.795  40.397  87.201  1.00 72.51           C  
ATOM    142  O   ASN    20      44.790  40.656  85.994  1.00 70.43           O  
ATOM    143  CB  ASN    20      45.693  38.077  87.538  1.00 59.20           C  
ATOM    144  CG  ASN    20      46.964  37.248  87.658  1.00 75.65           C  
ATOM    145  OD1 ASN    20      47.535  36.826  86.652  1.00101.51           O  
ATOM    146  ND2 ASN    20      47.412  37.011  88.887  1.00 92.03           N  
ATOM    147  N   TYR    21      43.845  40.809  88.038  1.00 72.03           N  
ATOM    148  CA  TYR    21      42.660  41.533  87.576  1.00 63.08           C  
ATOM    149  C   TYR    21      42.437  42.823  88.360  1.00 62.42           C  
ATOM    150  O   TYR    21      42.660  42.873  89.573  1.00 73.78           O  
ATOM    151  CB  TYR    21      41.415  40.639  87.653  1.00 66.80           C  
ATOM    152  CG  TYR    21      41.537  39.350  86.866  1.00 63.40           C  
ATOM    153  CD1 TYR    21      41.920  38.163  87.492  1.00 63.16           C  
ATOM    154  CD2 TYR    21      41.280  39.319  85.495  1.00 52.50           C  
ATOM    155  CE1 TYR    21      42.041  36.979  86.775  1.00 62.89           C  
ATOM    156  CE2 TYR    21      41.398  38.137  84.769  1.00 69.94           C  
ATOM    157  CZ  TYR    21      41.780  36.973  85.416  1.00 76.20           C  
ATOM    158  OH  TYR    21      41.898  35.800  84.708  1.00 81.40           O  
ATOM    159  N   GLN    22      41.995  43.861  87.653  1.00 51.11           N  
ATOM    160  CA  GLN    22      41.745  45.169  88.250  1.00 52.42           C  
ATOM    161  C   GLN    22      40.249  45.389  88.468  1.00 57.96           C  
ATOM    162  O   GLN    22      39.487  45.488  87.504  1.00 53.40           O  
ATOM    163  CB  GLN    22      42.336  46.276  87.365  1.00 47.18           C  
ATOM    164  CG  GLN    22      42.085  47.709  87.842  1.00 69.65           C  
ATOM    165  CD  GLN    22      43.001  48.131  88.978  1.00102.66           C  
ATOM    166  OE1 GLN    22      42.801  47.750  90.132  1.00106.07           O  
ATOM    167  NE2 GLN    22      44.004  48.940  88.656  1.00112.87           N  
ATOM    168  N   LEU    23      39.844  45.461  89.735  1.00 57.15           N  
ATOM    169  CA  LEU    23      38.442  45.683  90.103  1.00 50.60           C  
ATOM    170  C   LEU    23      37.989  47.107  89.782  1.00 48.31           C  
ATOM    171  O   LEU    23      38.782  48.049  89.859  1.00 46.36           O  
ATOM    172  CB  LEU    23      38.205  45.361  91.586  1.00 37.08           C  
ATOM    173  CG  LEU    23      38.211  43.888  92.022  1.00 29.17           C  
ATOM    174  CD1 LEU    23      38.286  43.767  93.536  1.00 27.93           C  
ATOM    175  CD2 LEU    23      36.996  43.131  91.492  1.00 49.92           C  
ATOM    176  N   LYS    24      36.715  47.242  89.409  1.00 42.88           N  
ATOM    177  CA  LYS    24      36.118  48.529  89.034  1.00 60.04           C  
ATOM    178  C   LYS    24      36.082  49.526  90.187  1.00 66.54           C  
ATOM    179  O   LYS    24      36.366  50.712  90.000  1.00 67.76           O  
ATOM    180  CB  LYS    24      34.702  48.329  88.489  1.00 60.30           C  
ATOM    181  CG  LYS    24      34.637  48.073  86.999  1.00 65.66           C  
ATOM    182  CD  LYS    24      33.203  47.933  86.519  1.00 74.26           C  
ATOM    183  CE  LYS    24      33.144  47.745  85.013  1.00 60.22           C  
ATOM    184  NZ  LYS    24      31.741  47.687  84.520  1.00 63.42           N  
ATOM    185  N   GLN    25      35.730  49.037  91.372  1.00 64.06           N  
ATOM    186  CA  GLN    25      35.673  49.873  92.562  1.00 54.75           C  
ATOM    187  C   GLN    25      36.805  49.501  93.519  1.00 55.82           C  
ATOM    188  O   GLN    25      37.046  48.321  93.786  1.00 55.35           O  
ATOM    189  CB  GLN    25      34.301  49.761  93.229  1.00 61.23           C  
ATOM    190  CG  GLN    25      33.994  50.859  94.234  1.00 68.73           C  
ATOM    191  CD  GLN    25      32.516  51.197  94.290  1.00 73.24           C  
ATOM    192  OE1 GLN    25      31.818  50.831  95.235  1.00103.95           O  
ATOM    193  NE2 GLN    25      32.030  51.896  93.268  1.00 97.79           N  
ATOM    194  N   ARG    26      37.491  50.529  94.014  1.00 40.57           N  
ATOM    195  CA  ARG    26      38.721  50.380  94.795  1.00 27.79           C  
ATOM    196  C   ARG    26      38.507  49.778  96.185  1.00 33.96           C  
ATOM    197  O   ARG    26      39.371  49.067  96.700  1.00 47.26           O  
ATOM    198  CB  ARG    26      39.425  51.735  94.905  1.00 25.04           C  
ATOM    199  CG  ARG    26      40.865  51.676  95.394  1.00 27.91           C  
ATOM    200  CD  ARG    26      41.569  53.000  95.184  1.00 53.62           C  
ATOM    201  NE  ARG    26      40.876  54.113  95.832  1.00 72.82           N  
ATOM    202  CZ  ARG    26      41.003  55.383  95.462  1.00 63.56           C  
ATOM    203  NH1 ARG    26      41.793  55.698  94.445  1.00 19.76           N  
ATOM    204  NH2 ARG    26      40.339  56.336  96.103  1.00 56.62           N  
ATOM    205  N   GLU    27      37.352  50.059  96.782  1.00 24.81           N  
ATOM    206  CA  GLU    27      37.032  49.564  98.126  1.00 28.34           C  
ATOM    207  C   GLU    27      36.711  48.069  98.165  1.00 20.31           C  
ATOM    208  O   GLU    27      36.733  47.457  99.232  1.00  8.99           O  
ATOM    209  CB  GLU    27      35.923  50.398  98.793  1.00 15.34           C  
ATOM    210  CG  GLU    27      35.043  51.220  97.848  1.00 60.22           C  
ATOM    211  CD  GLU    27      35.609  52.602  97.542  1.00 74.48           C  
ATOM    212  OE1 GLU    27      35.664  52.969  96.349  1.00 78.12           O  
ATOM    213  OE2 GLU    27      36.002  53.317  98.489  1.00 62.62           O  
ATOM    214  N   CYS    28      36.439  47.490  96.996  1.00  3.93           N  
ATOM    215  CA  CYS    28      36.234  46.049  96.841  1.00 36.87           C  
ATOM    216  C   CYS    28      37.543  45.272  96.980  1.00 39.48           C  
ATOM    217  O   CYS    28      37.543  44.112  97.402  1.00 40.62           O  
ATOM    218  CB  CYS    28      35.604  45.752  95.483  1.00 32.52           C  
ATOM    219  SG  CYS    28      34.088  46.672  95.157  1.00 64.11           S  
ATOM    220  N   VAL    29      38.647  45.920  96.603  1.00 26.07           N  
ATOM    221  CA  VAL    29      40.000  45.398  96.811  1.00 33.41           C  
ATOM    222  C   VAL    29      40.289  45.353  98.313  1.00 40.89           C  
ATOM    223  O   VAL    29      40.858  44.381  98.816  1.00 29.88           O  
ATOM    224  CB  VAL    29      41.071  46.276  96.090  1.00 18.96           C  
ATOM    225  CG1 VAL    29      42.470  45.681  96.219  1.00 42.64           C  
ATOM    226  CG2 VAL    29      40.717  46.479  94.621  1.00 12.99           C  
ATOM    227  N   TRP    30      39.866  46.402  99.018  1.00 35.56           N  
ATOM    228  CA  TRP    30      40.076  46.520 100.461  1.00 28.30           C  
ATOM    229  C   TRP    30      39.164  45.602 101.267  1.00 34.00           C  
ATOM    230  O   TRP    30      39.520  45.204 102.376  1.00 24.65           O  
ATOM    231  CB  TRP    30      39.916  47.971 100.929  1.00 19.25           C  
ATOM    232  CG  TRP    30      40.816  48.950 100.224  1.00 39.94           C  
ATOM    233  CD1 TRP    30      42.044  48.696  99.675  1.00 32.48           C  
ATOM    234  CD2 TRP    30      40.568  50.347 100.017  1.00 35.28           C  
ATOM    235  NE1 TRP    30      42.563  49.839  99.122  1.00 33.05           N  
ATOM    236  CE2 TRP    30      41.683  50.870  99.323  1.00 36.64           C  
ATOM    237  CE3 TRP    30      39.512  51.207 100.348  1.00  9.12           C  
ATOM    238  CZ2 TRP    30      41.772  52.215  98.952  1.00 32.40           C  
ATOM    239  CZ3 TRP    30      39.600  52.546  99.976  1.00 19.31           C  
ATOM    240  CH2 TRP    30      40.723  53.035  99.285  1.00 42.28           C  
ATOM    241  N   ILE    31      37.991  45.286 100.712  1.00 32.16           N  
ATOM    242  CA  ILE    31      37.098  44.271 101.279  1.00 29.88           C  
ATOM    243  C   ILE    31      37.771  42.895 101.188  1.00 29.23           C  
ATOM    244  O   ILE    31      37.806  42.149 102.170  1.00 29.23           O  
ATOM    245  CB  ILE    31      35.701  44.267 100.576  1.00 37.41           C  
ATOM    246  CG1 ILE    31      34.868  45.475 101.018  1.00 31.27           C  
ATOM    247  CG2 ILE    31      34.924  42.980 100.874  1.00  2.00           C  
ATOM    248  CD1 ILE    31      33.747  45.854 100.060  1.00 38.02           C  
ATOM    249  N   LEU    32      38.329  42.591 100.015  1.00 36.37           N  
ATOM    250  CA  LEU    32      39.024  41.323  99.766  1.00 28.05           C  
ATOM    251  C   LEU    32      40.318  41.163 100.564  1.00 32.19           C  
ATOM    252  O   LEU    32      40.619  40.065 101.043  1.00 25.56           O  
ATOM    253  CB  LEU    32      39.316  41.145  98.272  1.00 11.59           C  
ATOM    254  CG  LEU    32      38.190  40.639  97.368  1.00 40.82           C  
ATOM    255  CD1 LEU    32      38.606  40.702  95.907  1.00 31.11           C  
ATOM    256  CD2 LEU    32      37.744  39.224  97.735  1.00 16.32           C  
ATOM    257  N   ASN    33      41.076  42.253 100.694  1.00 33.88           N  
ATOM    258  CA  ASN    33      42.309  42.269 101.487  1.00 41.02           C  
ATOM    259  C   ASN    33      42.045  42.119 102.982  1.00 48.35           C  
ATOM    260  O   ASN    33      42.861  41.544 103.708  1.00 42.87           O  
ATOM    261  CB  ASN    33      43.105  43.553 101.236  1.00 38.12           C  
ATOM    262  CG  ASN    33      43.837  43.545  99.906  1.00 28.78           C  
ATOM    263  OD1 ASN    33      44.367  42.520  99.475  1.00 60.55           O  
ATOM    264  ND2 ASN    33      43.887  44.702  99.258  1.00 57.45           N  
ATOM    265  N   TYR    34      40.908  42.656 103.427  1.00 42.24           N  
ATOM    266  CA  TYR    34      40.432  42.500 104.800  1.00 36.83           C  
ATOM    267  C   TYR    34      40.098  41.038 105.079  1.00 23.18           C  
ATOM    268  O   TYR    34      40.462  40.503 106.126  1.00 16.66           O  
ATOM    269  CB  TYR    34      39.197  43.378 105.027  1.00 41.90           C  
ATOM    270  CG  TYR    34      38.520  43.229 106.374  1.00 22.34           C  
ATOM    271  CD1 TYR    34      38.973  43.939 107.484  1.00 28.54           C  
ATOM    272  CD2 TYR    34      37.408  42.398 106.533  1.00 27.86           C  
ATOM    273  CE1 TYR    34      38.350  43.812 108.720  1.00  4.43           C  
ATOM    274  CE2 TYR    34      36.781  42.262 107.766  1.00 43.11           C  
ATOM    275  CZ  TYR    34      37.257  42.972 108.855  1.00 35.09           C  
ATOM    276  OH  TYR    34      36.639  42.845 110.078  1.00 54.06           O  
ATOM    277  N   LEU    35      39.403  40.407 104.134  1.00 24.05           N  
ATOM    278  CA  LEU    35      38.988  39.012 104.264  1.00 40.94           C  
ATOM    279  C   LEU    35      40.166  38.045 104.184  1.00 38.13           C  
ATOM    280  O   LEU    35      40.156  37.005 104.841  1.00 37.34           O  
ATOM    281  CB  LEU    35      37.922  38.662 103.220  1.00 42.89           C  
ATOM    282  CG  LEU    35      36.547  39.306 103.438  1.00 42.92           C  
ATOM    283  CD1 LEU    35      35.752  39.347 102.143  1.00 49.87           C  
ATOM    284  CD2 LEU    35      35.763  38.605 104.543  1.00 59.35           C  
ATOM    285  N   MET    36      41.175  38.399 103.385  1.00 34.40           N  
ATOM    286  CA  MET    36      42.427  37.636 103.305  1.00 46.16           C  
ATOM    287  C   MET    36      43.219  37.656 104.610  1.00 50.13           C  
ATOM    288  O   MET    36      43.874  36.672 104.960  1.00 60.87           O  
ATOM    289  CB  MET    36      43.315  38.160 102.175  1.00 42.82           C  
ATOM    290  CG  MET    36      43.368  37.261 100.955  1.00 48.71           C  
ATOM    291  SD  MET    36      44.881  37.467  99.986  1.00 60.10           S  
ATOM    292  CE  MET    36      44.640  39.097  99.278  1.00 16.43           C  
ATOM    293  N   SER    37      43.153  38.781 105.317  1.00 42.11           N  
ATOM    294  CA  SER    37      43.859  38.960 106.582  1.00 36.76           C  
ATOM    295  C   SER    37      43.206  38.197 107.734  1.00 37.15           C  
ATOM    296  O   SER    37      43.880  37.823 108.697  1.00 53.92           O  
ATOM    297  CB  SER    37      43.943  40.445 106.928  1.00 18.16           C  
ATOM    298  OG  SER    37      44.692  40.659 108.113  1.00 32.55           O  
ATOM    299  N   HIS    38      41.899  37.971 107.629  1.00 44.07           N  
ATOM    300  CA  HIS    38      41.138  37.305 108.681  1.00 38.86           C  
ATOM    301  C   HIS    38      40.825  35.861 108.290  1.00 42.18           C  
ATOM    302  O   HIS    38      39.936  35.604 107.473  1.00 55.60           O  
ATOM    303  CB  HIS    38      39.861  38.094 108.994  1.00 26.86           C  
ATOM    304  CG  HIS    38      40.118  39.468 109.535  1.00 33.91           C  
ATOM    305  ND1 HIS    38      40.550  40.511 108.745  1.00 26.80           N  
ATOM    306  CD2 HIS    38      40.005  39.969 110.788  1.00 16.28           C  
ATOM    307  CE1 HIS    38      40.698  41.592 109.488  1.00 39.50           C  
ATOM    308  NE2 HIS    38      40.369  41.292 110.731  1.00 34.08           N  
ATOM    309  N   ASP    39      41.570  34.926 108.877  1.00 42.22           N  
ATOM    310  CA  ASP    39      41.487  33.505 108.508  1.00 57.50           C  
ATOM    311  C   ASP    39      40.239  32.755 108.989  1.00 50.55           C  
ATOM    312  O   ASP    39      39.903  31.705 108.434  1.00 54.74           O  
ATOM    313  CB  ASP    39      42.773  32.732 108.877  1.00 58.09           C  
ATOM    314  CG  ASP    39      43.669  33.483 109.855  1.00101.47           C  
ATOM    315  OD1 ASP    39      44.908  33.492 109.630  1.00113.01           O  
ATOM    316  OD2 ASP    39      43.151  34.059 110.842  1.00137.21           O  
ATOM    317  N   GLN    40      39.555  33.273 110.007  1.00 52.26           N  
ATOM    318  CA  GLN    40      38.258  32.696 110.392  1.00 59.48           C  
ATOM    319  C   GLN    40      37.060  33.448 109.802  1.00 61.27           C  
ATOM    320  O   GLN    40      35.904  33.139 110.110  1.00 51.95           O  
ATOM    321  CB  GLN    40      38.134  32.455 111.912  1.00 52.01           C  
ATOM    322  CG  GLN    40      38.868  33.458 112.809  1.00 76.20           C  
ATOM    323  CD  GLN    40      39.624  32.719 113.944  1.00 91.61           C  
ATOM    324  OE1 GLN    40      40.507  33.294 114.589  1.00 83.79           O  
ATOM    325  NE2 GLN    40      39.287  31.442 114.185  1.00106.56           N  
ATOM    326  N   LEU    41      37.353  34.431 108.953  1.00 66.52           N  
ATOM    327  CA  LEU    41      36.367  34.944 108.006  1.00 67.80           C  
ATOM    328  C   LEU    41      36.392  34.058 106.766  1.00 70.55           C  
ATOM    329  O   LEU    41      35.342  33.755 106.197  1.00 75.93           O  
ATOM    330  CB  LEU    41      36.654  36.403 107.621  1.00 78.53           C  
ATOM    331  CG  LEU    41      35.895  37.555 108.301  1.00 73.60           C  
ATOM    332  CD1 LEU    41      34.390  37.484 108.038  1.00 46.01           C  
ATOM    333  CD2 LEU    41      36.183  37.616 109.797  1.00 73.23           C  
ATOM    334  N   MET    42      37.595  33.627 106.378  1.00 56.00           N  
ATOM    335  CA  MET    42      37.808  32.775 105.199  1.00 57.81           C  
ATOM    336  C   MET    42      37.240  31.360 105.324  1.00 69.74           C  
ATOM    337  O   MET    42      37.038  30.683 104.313  1.00 74.92           O  
ATOM    338  CB  MET    42      39.293  32.719 104.825  1.00 48.73           C  
ATOM    339  CG  MET    42      39.756  33.857 103.932  1.00 26.11           C  
ATOM    340  SD  MET    42      38.932  33.896 102.326  1.00 46.81           S  
ATOM    341  CE  MET    42      39.502  35.472 101.695  1.00 20.11           C  
ATOM    342  N   HIS    43      37.006  30.916 106.560  1.00 77.46           N  
ATOM    343  CA  HIS    43      36.227  29.708 106.828  1.00 81.40           C  
ATOM    344  C   HIS    43      34.802  29.904 106.332  1.00 77.35           C  
ATOM    345  O   HIS    43      34.234  29.036 105.665  1.00 81.45           O  
ATOM    346  CB  HIS    43      36.169  29.422 108.331  1.00 92.98           C  
ATOM    347  CG  HIS    43      37.329  28.635 108.852  1.00115.47           C  
ATOM    348  ND1 HIS    43      38.190  29.129 109.810  1.00123.92           N  
ATOM    349  CD2 HIS    43      37.760  27.384 108.565  1.00132.13           C  
ATOM    350  CE1 HIS    43      39.108  28.220 110.081  1.00129.28           C  
ATOM    351  NE2 HIS    43      38.871  27.152 109.340  1.00131.76           N  
ATOM    352  N   LYS    44      34.243  31.066 106.666  1.00 73.33           N  
ATOM    353  CA  LYS    44      32.857  31.404 106.366  1.00 61.04           C  
ATOM    354  C   LYS    44      32.678  32.023 104.976  1.00 57.30           C  
ATOM    355  O   LYS    44      31.551  32.189 104.508  1.00 69.14           O  
ATOM    356  CB  LYS    44      32.298  32.335 107.448  1.00 58.50           C  
ATOM    357  CG  LYS    44      32.146  31.683 108.818  1.00 46.12           C  
ATOM    358  CD  LYS    44      31.729  32.697 109.876  1.00 62.71           C  
ATOM    359  CE  LYS    44      31.584  32.047 111.249  1.00 86.47           C  
ATOM    360  NZ  LYS    44      32.894  31.607 111.823  1.00104.81           N  
ATOM    361  N   VAL    45      33.789  32.365 104.325  1.00 47.83           N  
ATOM    362  CA  VAL    45      33.767  32.889 102.957  1.00 54.28           C  
ATOM    363  C   VAL    45      33.536  31.748 101.963  1.00 57.64           C  
ATOM    364  O   VAL    45      34.229  30.726 102.003  1.00 64.15           O  
ATOM    365  CB  VAL    45      35.068  33.693 102.629  1.00 44.32           C  
ATOM    366  CG1 VAL    45      35.346  33.757 101.125  1.00 51.43           C  
ATOM    367  CG2 VAL    45      34.979  35.101 103.199  1.00 59.36           C  
ATOM    368  N   HIS    46      32.541  31.921 101.094  1.00 52.06           N  
ATOM    369  CA  HIS    46      32.242  30.946 100.051  1.00 44.49           C  
ATOM    370  C   HIS    46      32.204  31.604  98.678  1.00 53.29           C  
ATOM    371  O   HIS    46      31.514  32.606  98.478  1.00 65.04           O  
ATOM    372  CB  HIS    46      30.912  30.242 100.331  1.00 36.82           C  
ATOM    373  CG  HIS    46      30.851  29.573 101.668  1.00 36.12           C  
ATOM    374  ND1 HIS    46      31.564  28.430 101.960  1.00 72.73           N  
ATOM    375  CD2 HIS    46      30.161  29.883 102.791  1.00 67.78           C  
ATOM    376  CE1 HIS    46      31.318  28.067 103.206  1.00 76.73           C  
ATOM    377  NE2 HIS    46      30.470  28.932 103.733  1.00 68.01           N  
ATOM    378  N   PHE    47      32.956  31.037  97.738  1.00 56.48           N  
ATOM    379  CA  PHE    47      32.956  31.526  96.363  1.00 61.28           C  
ATOM    380  C   PHE    47      31.879  30.823  95.549  1.00 58.84           C  
ATOM    381  O   PHE    47      31.816  29.594  95.506  1.00 62.21           O  
ATOM    382  CB  PHE    47      34.349  31.429  95.740  1.00 65.70           C  
ATOM    383  CG  PHE    47      35.332  32.390  96.345  1.00 59.38           C  
ATOM    384  CD1 PHE    47      36.184  31.983  97.368  1.00 64.32           C  
ATOM    385  CD2 PHE    47      35.381  33.715  95.919  1.00 51.39           C  
ATOM    386  CE1 PHE    47      37.083  32.874  97.941  1.00 82.12           C  
ATOM    387  CE2 PHE    47      36.275  34.611  96.490  1.00 40.37           C  
ATOM    388  CZ  PHE    47      37.125  34.189  97.501  1.00 63.01           C  
ATOM    389  N   VAL    48      31.027  31.628  94.918  1.00 55.73           N  
ATOM    390  CA  VAL    48      29.686  31.201  94.521  1.00 48.33           C  
ATOM    391  C   VAL    48      29.289  31.869  93.194  1.00 46.26           C  
ATOM    392  O   VAL    48      29.760  32.964  92.892  1.00 54.94           O  
ATOM    393  CB  VAL    48      28.691  31.499  95.719  1.00 51.09           C  
ATOM    394  CG1 VAL    48      27.323  32.038  95.289  1.00 66.36           C  
ATOM    395  CG2 VAL    48      28.538  30.277  96.614  1.00 25.83           C  
ATOM    396  N   GLU    49      28.443  31.203  92.407  0.50 40.44           N  
ATOM    398  CA  GLU    49      27.781  31.851  91.274  0.50 38.59           C  
ATOM    400  C   GLU    49      26.316  32.151  91.594  0.50 38.61           C  
ATOM    402  O   GLU    49      25.588  31.292  92.094  0.50 23.18           O  
ATOM    404  CB  GLU    49      27.906  31.014  89.999  0.50 39.79           C  
ATOM    406  CG  GLU    49      29.260  31.147  89.313  0.50 32.47           C  
ATOM    408  CD  GLU    49      29.242  30.675  87.871  0.50 47.37           C  
ATOM    410  OE1 GLU    49      28.857  29.512  87.621  0.50 67.13           O  
ATOM    412  OE2 GLU    49      29.625  31.468  86.984  0.50 41.08           O  
ATOM    414  N   HIS    50      25.893  33.378  91.305  0.50 35.51           N  
ATOM    416  CA  HIS    50      24.555  33.838  91.665  0.50 37.04           C  
ATOM    418  C   HIS    50      24.477  34.066  93.175  0.50 39.05           C  
ATOM    420  O   HIS    50      23.753  33.370  93.889  0.50 45.49           O  
ATOM    422  CB  HIS    50      23.483  32.836  91.220  0.50 33.33           C  
ATOM    424  CG  HIS    50      23.660  32.328  89.823  0.50 30.55           C  
ATOM    426  ND1 HIS    50      23.963  31.012  89.545  0.50 43.39           N  
ATOM    428  CD2 HIS    50      23.575  32.956  88.625  0.50 24.25           C  
ATOM    430  CE1 HIS    50      24.057  30.850  88.238  0.50 47.64           C  
ATOM    432  NE2 HIS    50      23.826  32.015  87.656  0.50 42.44           N  
ATOM    434  N   ALA    51      25.227  35.053  93.655  0.50 45.35           N  
ATOM    436  CA  ALA    51      25.294  35.347  95.086  0.50 48.89           C  
ATOM    438  C   ALA    51      24.154  36.246  95.576  0.50 51.83           C  
ATOM    440  O   ALA    51      24.079  36.574  96.762  0.50 53.16           O  
ATOM    442  CB  ALA    51      26.649  35.958  95.435  0.50 49.32           C  
ATOM    444  N   LYS    52      23.264  36.625  94.660  1.00 58.57           N  
ATOM    445  CA  LYS    52      22.124  37.506  94.966  1.00 54.64           C  
ATOM    446  C   LYS    52      21.017  36.826  95.781  1.00 46.90           C  
ATOM    447  O   LYS    52      20.208  37.496  96.427  1.00 46.97           O  
ATOM    448  CB  LYS    52      21.546  38.104  93.674  1.00 44.05           C  
ATOM    449  CG  LYS    52      21.045  37.074  92.661  1.00 66.73           C  
ATOM    450  CD  LYS    52      20.582  37.740  91.380  1.00 82.91           C  
ATOM    451  CE  LYS    52      19.977  36.734  90.415  1.00 97.19           C  
ATOM    452  NZ  LYS    52      19.523  37.389  89.153  1.00115.97           N  
ATOM    453  N   TYR    53      21.001  35.495  95.745  1.00 37.98           N  
ATOM    454  CA  TYR    53      20.046  34.682  96.491  1.00 37.72           C  
ATOM    455  C   TYR    53      20.497  34.436  97.934  1.00 45.31           C  
ATOM    456  O   TYR    53      19.725  33.933  98.754  1.00 54.77           O  
ATOM    457  CB  TYR    53      19.845  33.337  95.786  1.00 46.24           C  
ATOM    458  CG  TYR    53      19.406  33.437  94.341  1.00 72.72           C  
ATOM    459  CD1 TYR    53      18.073  33.684  94.014  1.00 81.57           C  
ATOM    460  CD2 TYR    53      20.320  33.270  93.300  1.00 82.33           C  
ATOM    461  CE1 TYR    53      17.662  33.773  92.688  1.00 71.14           C  
ATOM    462  CE2 TYR    53      19.918  33.357  91.970  1.00 86.46           C  
ATOM    463  CZ  TYR    53      18.588  33.608  91.672  1.00 63.48           C  
ATOM    464  OH  TYR    53      18.186  33.695  90.359  1.00 81.98           O  
ATOM    465  N   CYS    54      21.742  34.800  98.236  1.00 49.67           N  
ATOM    466  CA  CYS    54      22.366  34.482  99.519  1.00 56.54           C  
ATOM    467  C   CYS    54      22.061  35.511 100.615  1.00 60.03           C  
ATOM    468  O   CYS    54      21.984  36.708 100.328  1.00 67.34           O  
ATOM    469  CB  CYS    54      23.878  34.329  99.335  1.00 51.50           C  
ATOM    470  SG  CYS    54      24.343  33.106  98.085  1.00 97.57           S  
ATOM    471  N   PRO    55      21.869  35.038 101.870  1.00 58.20           N  
ATOM    472  CA  PRO    55      21.696  35.838 103.093  1.00 59.98           C  
ATOM    473  C   PRO    55      22.735  36.943 103.312  1.00 67.06           C  
ATOM    474  O   PRO    55      22.407  37.977 103.897  1.00 85.49           O  
ATOM    475  CB  PRO    55      21.791  34.793 104.223  1.00 66.59           C  
ATOM    476  CG  PRO    55      22.246  33.520 103.566  1.00 67.66           C  
ATOM    477  CD  PRO    55      21.746  33.602 102.171  1.00 69.20           C  
ATOM    478  N   ARG    56      23.968  36.722 102.861  1.00 48.08           N  
ATOM    479  CA  ARG    56      24.998  37.754 102.905  1.00 42.87           C  
ATOM    480  C   ARG    56      25.850  37.682 101.637  1.00 45.44           C  
ATOM    481  O   ARG    56      26.996  37.221 101.659  1.00 49.24           O  
ATOM    482  CB  ARG    56      25.839  37.621 104.175  1.00 49.88           C  
ATOM    483  CG  ARG    56      26.133  38.946 104.852  1.00 18.97           C  
ATOM    484  CD  ARG    56      26.176  38.798 106.364  1.00 24.76           C  
ATOM    485  NE  ARG    56      27.468  38.313 106.845  1.00 40.44           N  
ATOM    486  CZ  ARG    56      28.460  39.097 107.256  1.00 53.66           C  
ATOM    487  NH1 ARG    56      28.323  40.416 107.240  1.00 58.73           N  
ATOM    488  NH2 ARG    56      29.596  38.562 107.684  1.00 45.76           N  
ATOM    489  N   GLY    57      25.264  38.142 100.534  1.00 45.31           N  
ATOM    490  CA  GLY    57      25.861  38.009  99.209  1.00 39.80           C  
ATOM    491  C   GLY    57      26.650  39.214  98.741  1.00 40.11           C  
ATOM    492  O   GLY    57      26.211  40.353  98.890  1.00 39.59           O  
ATOM    493  N   LEU    58      27.814  38.943  98.156  1.00 34.25           N  
ATOM    494  CA  LEU    58      28.733  39.975  97.700  1.00 24.42           C  
ATOM    495  C   LEU    58      29.002  39.793  96.207  1.00 27.60           C  
ATOM    496  O   LEU    58      29.446  38.728  95.774  1.00 43.01           O  
ATOM    497  CB  LEU    58      30.037  39.878  98.501  1.00 39.75           C  
ATOM    498  CG  LEU    58      30.890  41.113  98.805  1.00 23.91           C  
ATOM    499  CD1 LEU    58      30.151  42.118  99.666  1.00 58.63           C  
ATOM    500  CD2 LEU    58      32.169  40.683  99.500  1.00 14.12           C  
ATOM    501  N   VAL    59      28.705  40.826  95.420  1.00 32.14           N  
ATOM    502  CA  VAL    59      28.933  40.795  93.972  1.00 31.60           C  
ATOM    503  C   VAL    59      29.955  41.865  93.602  1.00 51.55           C  
ATOM    504  O   VAL    59      29.745  43.049  93.870  1.00 58.66           O  
ATOM    505  CB  VAL    59      27.618  41.013  93.169  1.00 28.84           C  
ATOM    506  CG1 VAL    59      27.883  41.002  91.664  1.00 11.97           C  
ATOM    507  CG2 VAL    59      26.581  39.957  93.525  1.00 28.33           C  
ATOM    508  N   MET    60      31.063  41.442  92.998  1.00 46.21           N  
ATOM    509  CA  MET    60      32.144  42.357  92.635  1.00 43.37           C  
ATOM    510  C   MET    60      32.669  42.100  91.227  1.00 44.35           C  
ATOM    511  O   MET    60      32.773  40.951  90.797  1.00 52.83           O  
ATOM    512  CB  MET    60      33.269  42.275  93.662  1.00 44.96           C  
ATOM    513  CG  MET    60      33.034  43.154  94.879  1.00 48.21           C  
ATOM    514  SD  MET    60      33.481  42.433  96.469  1.00 46.13           S  
ATOM    515  CE  MET    60      34.825  41.344  96.023  1.00  4.14           C  
ATOM    516  N   SER    61      33.001  43.177  90.518  1.00 33.48           N  
ATOM    517  CA  SER    61      33.352  43.085  89.102  1.00 36.37           C  
ATOM    518  C   SER    61      34.679  43.747  88.754  1.00 44.79           C  
ATOM    519  O   SER    61      34.992  44.836  89.243  1.00 57.16           O  
ATOM    520  CB  SER    61      32.236  43.683  88.243  1.00 41.88           C  
ATOM    521  OG  SER    61      30.989  43.082  88.542  1.00 61.05           O  
ATOM    522  N   ALA    62      35.450  43.073  87.905  1.00 58.28           N  
ATOM    523  CA  ALA    62      36.674  43.634  87.346  1.00 58.50           C  
ATOM    524  C   ALA    62      36.339  44.552  86.170  1.00 64.19           C  
ATOM    525  O   ALA    62      35.240  44.478  85.613  1.00 75.24           O  
ATOM    526  CB  ALA    62      37.620  42.523  86.917  1.00 58.97           C  
ATOM    527  N   ASN    63      37.287  45.408  85.793  1.00 68.09           N  
ATOM    528  CA  ASN    63      37.062  46.432  84.756  1.00 69.47           C  
ATOM    529  C   ASN    63      36.980  45.953  83.296  1.00 64.12           C  
ATOM    530  O   ASN    63      36.721  46.748  82.388  1.00 58.40           O  
ATOM    531  CB  ASN    63      38.022  47.635  84.920  1.00 65.01           C  
ATOM    532  CG  ASN    63      39.505  47.293  84.677  1.00 91.40           C  
ATOM    533  OD1 ASN    63      40.339  48.201  84.624  1.00107.59           O  
ATOM    534  ND2 ASN    63      39.836  46.010  84.532  1.00 94.71           N  
ATOM    535  N   CYS    64      37.195  44.657  83.089  1.00 60.02           N  
ATOM    536  CA  CYS    64      37.081  44.040  81.771  1.00 75.98           C  
ATOM    537  C   CYS    64      35.619  43.849  81.359  1.00 79.71           C  
ATOM    538  O   CYS    64      35.171  44.435  80.369  1.00 80.65           O  
ATOM    539  CB  CYS    64      37.841  42.712  81.738  1.00 82.49           C  
ATOM    540  SG  CYS    64      37.673  41.726  83.249  1.00 98.58           S  
ATOM    541  N   VAL    65      34.882  43.036  82.119  1.00 73.13           N  
ATOM    542  CA  VAL    65      33.457  42.808  81.857  1.00 69.48           C  
ATOM    543  C   VAL    65      32.646  43.994  82.365  1.00 68.33           C  
ATOM    544  O   VAL    65      33.004  44.620  83.367  1.00 62.17           O  
ATOM    545  CB  VAL    65      32.921  41.516  82.520  1.00 68.74           C  
ATOM    546  CG1 VAL    65      31.853  40.870  81.643  1.00 97.15           C  
ATOM    547  CG2 VAL    65      34.032  40.537  82.757  1.00 69.93           C  
ATOM    548  N   LYS    66      31.545  44.287  81.676  1.00 78.50           N  
ATOM    549  CA  LYS    66      30.731  45.469  81.961  1.00 86.16           C  
ATOM    550  C   LYS    66      29.637  45.258  83.018  1.00 84.47           C  
ATOM    551  O   LYS    66      28.615  45.951  83.007  1.00 77.59           O  
ATOM    552  CB  LYS    66      30.125  46.021  80.662  1.00 95.79           C  
ATOM    553  CG  LYS    66      31.095  46.834  79.801  1.00113.77           C  
ATOM    554  CD  LYS    66      31.301  48.254  80.336  1.00122.57           C  
ATOM    555  CE  LYS    66      30.109  49.156  80.032  1.00120.31           C  
ATOM    556  NZ  LYS    66      30.291  50.525  80.592  1.00115.46           N  
ATOM    557  N   ASP    67      29.858  44.310  83.927  1.00 80.20           N  
ATOM    558  CA  ASP    67      28.968  44.109  85.069  1.00 71.67           C  
ATOM    559  C   ASP    67      29.181  45.216  86.103  1.00 72.53           C  
ATOM    560  O   ASP    67      30.254  45.827  86.154  1.00 74.41           O  
ATOM    561  CB  ASP    67      29.193  42.729  85.700  1.00 61.88           C  
ATOM    562  CG  ASP    67      28.744  41.588  84.798  1.00 67.35           C  
ATOM    563  OD1 ASP    67      29.148  41.555  83.614  1.00 65.09           O  
ATOM    564  OD2 ASP    67      27.991  40.714  85.281  1.00 60.45           O  
ATOM    565  N   THR    68      28.149  45.468  86.908  1.00 72.93           N  
ATOM    566  CA  THR    68      28.159  46.508  87.945  1.00 74.31           C  
ATOM    567  C   THR    68      29.237  46.251  89.007  1.00 64.76           C  
ATOM    568  O   THR    68      29.387  45.113  89.458  1.00 60.99           O  
ATOM    569  CB  THR    68      26.781  46.617  88.633  1.00 75.76           C  
ATOM    570  OG1 THR    68      26.394  45.326  89.135  1.00 61.69           O  
ATOM    571  CG2 THR    68      25.723  47.125  87.656  1.00 77.58           C  
ATOM    572  N   PRO    69      29.992  47.306  89.397  1.00 58.71           N  
ATOM    573  CA  PRO    69      31.149  47.214  90.301  1.00 51.46           C  
ATOM    574  C   PRO    69      30.899  46.539  91.652  1.00 52.55           C  
ATOM    575  O   PRO    69      31.702  45.703  92.070  1.00 54.61           O  
ATOM    576  CB  PRO    69      31.536  48.681  90.523  1.00 34.40           C  
ATOM    577  CG  PRO    69      31.056  49.379  89.317  1.00 27.54           C  
ATOM    578  CD  PRO    69      29.773  48.699  88.957  1.00 48.11           C  
ATOM    579  N   PHE    70      29.806  46.897  92.325  1.00 47.73           N  
ATOM    580  CA  PHE    70      29.535  46.373  93.665  1.00 38.96           C  
ATOM    581  C   PHE    70      28.051  46.180  93.972  1.00 47.67           C  
ATOM    582  O   PHE    70      27.218  47.019  93.621  1.00 44.07           O  
ATOM    583  CB  PHE    70      30.181  47.268  94.736  1.00 27.56           C  
ATOM    584  CG  PHE    70      30.034  46.741  96.142  1.00 35.59           C  
ATOM    585  CD1 PHE    70      29.015  47.203  96.975  1.00 28.02           C  
ATOM    586  CD2 PHE    70      30.909  45.777  96.630  1.00 26.65           C  
ATOM    587  CE1 PHE    70      28.868  46.705  98.265  1.00 55.54           C  
ATOM    588  CE2 PHE    70      30.777  45.284  97.922  1.00 13.83           C  
ATOM    589  CZ  PHE    70      29.756  45.748  98.741  1.00 52.02           C  
ATOM    590  N   HIS    71      27.747  45.070  94.645  1.00 38.09           N  
ATOM    591  CA  HIS    71      26.436  44.824  95.244  1.00 41.20           C  
ATOM    592  C   HIS    71      26.564  44.016  96.533  1.00 51.31           C  
ATOM    593  O   HIS    71      27.296  43.025  96.583  1.00 60.30           O  
ATOM    594  CB  HIS    71      25.515  44.095  94.267  1.00 36.38           C  
ATOM    595  CG  HIS    71      24.807  45.004  93.316  1.00 61.41           C  
ATOM    596  ND1 HIS    71      25.370  45.420  92.129  1.00 74.55           N  
ATOM    597  CD2 HIS    71      23.586  45.585  93.378  1.00 41.09           C  
ATOM    598  CE1 HIS    71      24.526  46.217  91.500  1.00 57.77           C  
ATOM    599  NE2 HIS    71      23.435  46.333  92.236  1.00 43.51           N  
ATOM    600  N   PHE    72      25.852  44.449  97.571  1.00 46.42           N  
ATOM    601  CA  PHE    72      25.787  43.703  98.824  1.00 42.49           C  
ATOM    602  C   PHE    72      24.352  43.284  99.128  1.00 41.28           C  
ATOM    603  O   PHE    72      23.463  44.125  99.290  1.00 41.05           O  
ATOM    604  CB  PHE    72      26.398  44.503  99.982  1.00 33.96           C  
ATOM    605  CG  PHE    72      26.478  43.742 101.286  1.00 53.39           C  
ATOM    606  CD1 PHE    72      26.960  42.434 101.324  1.00 63.75           C  
ATOM    607  CD2 PHE    72      26.092  44.346 102.480  1.00 28.53           C  
ATOM    608  CE1 PHE    72      27.042  41.737 102.526  1.00 53.03           C  
ATOM    609  CE2 PHE    72      26.173  43.659 103.688  1.00 64.73           C  
ATOM    610  CZ  PHE    72      26.649  42.353 103.710  1.00 46.99           C  
ATOM    611  N   PHE    73      24.145  41.972  99.194  1.00 42.22           N  
ATOM    612  CA  PHE    73      22.824  41.395  99.393  1.00 32.18           C  
ATOM    613  C   PHE    73      22.647  40.823 100.795  1.00 47.36           C  
ATOM    614  O   PHE    73      22.866  39.630 101.020  1.00 50.59           O  
ATOM    615  CB  PHE    73      22.550  40.302  98.352  1.00 16.68           C  
ATOM    616  CG  PHE    73      22.437  40.812  96.945  1.00 46.08           C  
ATOM    617  CD1 PHE    73      21.241  41.350  96.479  1.00 36.49           C  
ATOM    618  CD2 PHE    73      23.520  40.740  96.078  1.00 49.46           C  
ATOM    619  CE1 PHE    73      21.129  41.818  95.173  1.00 47.29           C  
ATOM    620  CE2 PHE    73      23.414  41.201  94.770  1.00 41.84           C  
ATOM    621  CZ  PHE    73      22.219  41.743  94.317  1.00 24.14           C  
ATOM    622  N   LYS    74      22.252  41.677 101.736  1.00 63.57           N  
ATOM    623  CA  LYS    74      21.788  41.203 103.037  1.00 65.79           C  
ATOM    624  C   LYS    74      20.345  40.710 102.925  1.00 64.36           C  
ATOM    625  O   LYS    74      19.711  40.873 101.878  1.00 57.86           O  
ATOM    626  CB  LYS    74      21.931  42.278 104.118  1.00 69.06           C  
ATOM    627  CG  LYS    74      23.118  42.045 105.040  1.00 62.10           C  
ATOM    628  CD  LYS    74      22.904  42.709 106.402  1.00 94.79           C  
ATOM    629  CE  LYS    74      23.653  41.967 107.509  1.00 98.09           C  
ATOM    630  NZ  LYS    74      25.141  42.013 107.336  1.00 73.68           N  
ATOM    631  N   GLN    75      19.837  40.112 104.004  1.00 73.63           N  
ATOM    632  CA  GLN    75      18.522  39.451 104.008  1.00 83.30           C  
ATOM    633  C   GLN    75      17.328  40.317 103.591  1.00 66.97           C  
ATOM    634  O   GLN    75      16.366  39.806 103.014  1.00 64.86           O  
ATOM    635  CB  GLN    75      18.241  38.802 105.366  1.00 97.58           C  
ATOM    636  CG  GLN    75      18.763  37.378 105.494  1.00119.01           C  
ATOM    637  CD  GLN    75      17.893  36.504 106.388  1.00132.39           C  
ATOM    638  OE1 GLN    75      16.774  36.875 106.751  1.00122.34           O  
ATOM    639  NE2 GLN    75      18.404  35.330 106.741  1.00128.61           N  
ATOM    640  N   ASN    76      17.394  41.616 103.877  1.00 70.77           N  
ATOM    641  CA  ASN    76      16.306  42.534 103.534  1.00 73.19           C  
ATOM    642  C   ASN    76      16.680  43.674 102.581  1.00 67.26           C  
ATOM    643  O   ASN    76      15.802  44.257 101.937  1.00 74.46           O  
ATOM    644  CB  ASN    76      15.649  43.092 104.804  1.00 80.64           C  
ATOM    645  CG  ASN    76      14.540  42.193 105.339  1.00 94.09           C  
ATOM    646  OD1 ASN    76      14.310  41.091 104.836  1.00116.49           O  
ATOM    647  ND2 ASN    76      13.844  42.667 106.366  1.00109.69           N  
ATOM    648  N   VAL    77      17.974  43.990 102.491  1.00 69.09           N  
ATOM    649  CA  VAL    77      18.442  45.125 101.684  1.00 62.67           C  
ATOM    650  C   VAL    77      19.398  44.696 100.564  1.00 61.27           C  
ATOM    651  O   VAL    77      20.153  43.732 100.715  1.00 62.47           O  
ATOM    652  CB  VAL    77      19.153  46.216 102.547  1.00 64.53           C  
ATOM    653  CG1 VAL    77      18.833  47.612 102.020  1.00 55.69           C  
ATOM    654  CG2 VAL    77      18.772  46.111 104.024  1.00 82.06           C  
ATOM    655  N   MET    78      19.349  45.419  99.445  1.00 42.50           N  
ATOM    656  CA  MET    78      20.336  45.285  98.371  1.00 50.14           C  
ATOM    657  C   MET    78      21.078  46.613  98.143  1.00 38.69           C  
ATOM    658  O   MET    78      20.716  47.413  97.274  1.00 48.81           O  
ATOM    659  CB  MET    78      19.703  44.737  97.077  1.00 47.97           C  
ATOM    660  CG  MET    78      18.332  45.317  96.706  1.00 69.92           C  
ATOM    661  SD  MET    78      17.692  44.689  95.138  1.00 61.78           S  
ATOM    662  CE  MET    78      17.085  43.063  95.638  1.00 74.72           C  
ATOM    663  N   THR    79      22.115  46.838  98.946  1.00 47.80           N  
ATOM    664  CA  THR    79      22.876  48.092  98.914  1.00 52.87           C  
ATOM    665  C   THR    79      24.004  48.084  97.879  1.00 52.91           C  
ATOM    666  O   THR    79      24.603  47.041  97.602  1.00 52.97           O  
ATOM    667  CB  THR    79      23.424  48.482 100.320  1.00 54.82           C  
ATOM    668  OG1 THR    79      24.399  49.528 100.192  1.00 68.46           O  
ATOM    669  CG2 THR    79      24.060  47.285 101.023  1.00 70.18           C  
ATOM    670  N   THR    80      24.279  49.260  97.318  1.00 51.14           N  
ATOM    671  CA  THR    80      25.340  49.434  96.323  1.00 51.08           C  
ATOM    672  C   THR    80      26.563  50.161  96.894  1.00 55.47           C  
ATOM    673  O   THR    80      27.634  50.164  96.279  1.00 58.74           O  
ATOM    674  CB  THR    80      24.820  50.154  95.045  1.00 47.82           C  
ATOM    675  OG1 THR    80      25.865  50.215  94.064  1.00 74.38           O  
ATOM    676  CG2 THR    80      24.325  51.569  95.356  1.00 61.08           C  
ATOM    677  N   ASP    81      26.394  50.771  98.068  1.00 55.83           N  
ATOM    678  CA  ASP    81      27.473  51.496  98.737  1.00 46.86           C  
ATOM    679  C   ASP    81      28.443  50.518  99.392  1.00 48.86           C  
ATOM    680  O   ASP    81      28.072  49.776 100.305  1.00 38.32           O  
ATOM    681  CB  ASP    81      26.906  52.473  99.775  1.00 52.86           C  
ATOM    682  CG  ASP    81      27.947  53.459 100.286  1.00 63.92           C  
ATOM    683  OD1 ASP    81      27.945  53.746 101.502  1.00 77.56           O  
ATOM    684  OD2 ASP    81      28.764  53.952  99.478  1.00108.65           O  
ATOM    685  N   ALA    82      29.684  50.524  98.912  1.00 49.02           N  
ATOM    686  CA  ALA    82      30.701  49.585  99.380  1.00 37.82           C  
ATOM    687  C   ALA    82      31.286  49.960 100.737  1.00 47.96           C  
ATOM    688  O   ALA    82      31.702  49.083 101.489  1.00 56.08           O  
ATOM    689  CB  ALA    82      31.800  49.430  98.345  1.00 43.64           C  
ATOM    690  N   GLU    83      31.309  51.258 101.037  1.00 37.70           N  
ATOM    691  CA  GLU    83      31.862  51.775 102.292  1.00 37.91           C  
ATOM    692  C   GLU    83      31.017  51.418 103.512  1.00 49.17           C  
ATOM    693  O   GLU    83      31.561  51.067 104.562  1.00 63.96           O  
ATOM    694  CB  GLU    83      32.046  53.293 102.220  1.00 28.88           C  
ATOM    695  CG  GLU    83      33.246  53.744 101.401  1.00 39.60           C  
ATOM    696  CD  GLU    83      33.449  55.251 101.436  1.00 80.26           C  
ATOM    697  OE1 GLU    83      33.713  55.837 100.365  1.00105.07           O  
ATOM    698  OE2 GLU    83      33.345  55.852 102.528  1.00 70.49           O  
ATOM    699  N   LYS    84      29.695  51.520 103.368  1.00 47.28           N  
ATOM    700  CA  LYS    84      28.765  51.139 104.429  1.00 53.19           C  
ATOM    701  C   LYS    84      28.750  49.623 104.603  1.00 56.27           C  
ATOM    702  O   LYS    84      28.696  49.127 105.728  1.00 61.84           O  
ATOM    703  CB  LYS    84      27.355  51.676 104.139  1.00 62.44           C  
ATOM    704  CG  LYS    84      26.317  51.460 105.256  1.00 75.22           C  
ATOM    705  CD  LYS    84      26.762  52.016 106.617  1.00111.96           C  
ATOM    706  CE  LYS    84      26.751  53.544 106.663  1.00115.36           C  
ATOM    707  NZ  LYS    84      25.373  54.111 106.606  1.00122.53           N  
ATOM    708  N   SER    85      28.824  48.904 103.483  1.00 52.57           N  
ATOM    709  CA  SER    85      28.869  47.442 103.478  1.00 49.61           C  
ATOM    710  C   SER    85      30.157  46.897 104.095  1.00 47.01           C  
ATOM    711  O   SER    85      30.130  45.872 104.774  1.00 52.71           O  
ATOM    712  CB  SER    85      28.703  46.911 102.054  1.00 45.25           C  
ATOM    713  OG  SER    85      27.475  47.341 101.493  1.00 55.42           O  
ATOM    714  N   PHE    86      31.271  47.591 103.855  1.00 40.80           N  
ATOM    715  CA  PHE    86      32.565  47.250 104.453  1.00 37.95           C  
ATOM    716  C   PHE    86      32.561  47.534 105.954  1.00 39.94           C  
ATOM    717  O   PHE    86      33.125  46.763 106.733  1.00 42.91           O  
ATOM    718  CB  PHE    86      33.703  48.009 103.754  1.00 43.18           C  
ATOM    719  CG  PHE    86      35.089  47.585 104.178  1.00 36.61           C  
ATOM    720  CD1 PHE    86      35.374  46.255 104.496  1.00 27.09           C  
ATOM    721  CD2 PHE    86      36.123  48.521 104.224  1.00 21.57           C  
ATOM    722  CE1 PHE    86      36.649  45.876 104.881  1.00 27.27           C  
ATOM    723  CE2 PHE    86      37.408  48.145 104.603  1.00 13.85           C  
ATOM    724  CZ  PHE    86      37.671  46.820 104.931  1.00 37.04           C  
ATOM    725  N   HIS    87      31.913  48.632 106.346  1.00 43.45           N  
ATOM    726  CA  HIS    87      31.733  48.990 107.755  1.00 33.20           C  
ATOM    727  C   HIS    87      30.821  47.992 108.483  1.00 26.92           C  
ATOM    728  O   HIS    87      30.957  47.782 109.694  1.00 38.35           O  
ATOM    729  CB  HIS    87      31.187  50.423 107.869  1.00 47.79           C  
ATOM    730  CG  HIS    87      30.780  50.816 109.256  1.00 77.67           C  
ATOM    731  ND1 HIS    87      31.689  51.004 110.276  1.00 95.54           N  
ATOM    732  CD2 HIS    87      29.560  51.056 109.791  1.00 62.79           C  
ATOM    733  CE1 HIS    87      31.046  51.341 111.380  1.00 68.04           C  
ATOM    734  NE2 HIS    87      29.753  51.381 111.113  1.00 57.51           N  
ATOM    735  N   ASP    88      29.913  47.373 107.727  1.00 37.53           N  
ATOM    736  CA  ASP    88      28.997  46.413 108.322  0.50 28.64           C  
ATOM    738  C   ASP    88      29.578  45.004 108.437  1.00 28.85           C  
ATOM    739  O   ASP    88      29.406  44.370 109.478  1.00 26.48           O  
ATOM    740  CB  ASP    88      27.622  46.450 107.604  0.50 29.14           C  
ATOM    742  CG  ASP    88      26.892  47.808 107.904  0.50 35.28           C  
ATOM    744  OD1 ASP    88      27.128  48.454 108.977  0.50 49.49           O  
ATOM    746  OD2 ASP    88      26.073  48.216 107.050  0.50 20.40           O  
ATOM    748  N   ILE    89      30.290  44.529 107.409  1.00 34.25           N  
ATOM    749  CA  ILE    89      30.942  43.200 107.451  1.00 50.45           C  
ATOM    750  C   ILE    89      32.134  43.168 108.418  1.00 46.38           C  
ATOM    751  O   ILE    89      32.570  42.095 108.855  1.00 54.94           O  
ATOM    752  CB  ILE    89      31.356  42.663 106.032  1.00 56.41           C  
ATOM    753  CG1 ILE    89      32.425  43.541 105.363  1.00 54.06           C  
ATOM    754  CG2 ILE    89      30.136  42.497 105.129  1.00 53.34           C  
ATOM    755  CD1 ILE    89      33.822  42.934 105.343  1.00 46.88           C  
ATOM    756  N   ARG    90      32.647  44.364 108.718  1.00 36.15           N  
ATOM    757  CA  ARG    90      33.648  44.613 109.751  1.00 33.44           C  
ATOM    758  C   ARG    90      33.174  44.112 111.112  1.00 35.88           C  
ATOM    759  O   ARG    90      33.923  43.464 111.846  1.00 32.69           O  
ATOM    760  CB  ARG    90      33.873  46.124 109.851  1.00 50.53           C  
ATOM    761  CG  ARG    90      35.309  46.587 109.914  1.00 49.31           C  
ATOM    762  CD  ARG    90      35.980  46.545 108.546  1.00 11.36           C  
ATOM    763  NE  ARG    90      36.812  47.723 108.294  1.00 39.72           N  
ATOM    764  CZ  ARG    90      38.043  47.915 108.768  1.00 44.50           C  
ATOM    765  NH1 ARG    90      38.630  47.013 109.548  1.00 21.11           N  
ATOM    766  NH2 ARG    90      38.693  49.029 108.462  1.00 41.44           N  
ATOM    767  N   LEU    91      31.919  44.426 111.428  1.00 49.46           N  
ATOM    768  CA  LEU    91      31.334  44.160 112.737  1.00 39.94           C  
ATOM    769  C   LEU    91      30.506  42.877 112.775  1.00 52.25           C  
ATOM    770  O   LEU    91      30.407  42.235 113.824  1.00 68.83           O  
ATOM    771  CB  LEU    91      30.465  45.347 113.181  1.00 31.54           C  
ATOM    772  CG  LEU    91      31.063  46.545 113.937  1.00 53.08           C  
ATOM    773  CD1 LEU    91      32.020  47.394 113.065  1.00 64.99           C  
ATOM    774  CD2 LEU    91      29.928  47.422 114.518  1.00 42.90           C  
ATOM    775  N   ASN    92      29.920  42.512 111.639  1.00 56.70           N  
ATOM    776  CA  ASN    92      28.881  41.490 111.607  1.00 67.96           C  
ATOM    777  C   ASN    92      29.457  40.080 111.686  1.00 72.93           C  
ATOM    778  O   ASN    92      28.842  39.179 112.256  1.00 76.53           O  
ATOM    779  CB  ASN    92      28.023  41.637 110.350  1.00 78.08           C  
ATOM    780  CG  ASN    92      26.855  42.584 110.549  1.00 88.02           C  
ATOM    781  OD1 ASN    92      25.957  42.665 109.711  1.00131.72           O  
ATOM    782  ND2 ASN    92      26.863  43.307 111.663  1.00 59.87           N  
ATOM    783  N   ARG    93      30.641  39.896 111.111  1.00 71.19           N  
ATOM    784  CA  ARG    93      31.543  38.834 111.538  1.00 73.30           C  
ATOM    785  C   ARG    93      30.928  37.458 111.301  1.00 77.32           C  
ATOM    786  O   ARG    93      31.088  36.872 110.231  1.00 84.52           O  
ATOM    787  CB  ARG    93      31.907  39.000 113.015  1.00 74.54           C  
ATOM    788  CG  ARG    93      33.069  39.947 113.265  1.00 81.79           C  
ATOM    789  CD  ARG    93      34.170  39.755 112.235  1.00 42.00           C  
ATOM    790  NE  ARG    93      35.213  40.770 112.353  1.00 52.63           N  
ATOM    791  CZ  ARG    93      36.415  40.548 112.873  1.00 69.36           C  
ATOM    792  NH1 ARG    93      36.732  39.343 113.327  1.00 79.09           N  
ATOM    793  NH2 ARG    93      37.302  41.532 112.940  1.00 90.19           N  
ATOM    794  N   ASP    94      30.224  36.950 112.307  1.00 76.75           N  
ATOM    795  CA  ASP    94      30.181  35.515 112.563  1.00 75.47           C  
ATOM    796  C   ASP    94      29.214  34.814 111.614  1.00 70.61           C  
ATOM    797  O   ASP    94      28.876  33.646 111.808  1.00 77.92           O  
ATOM    798  CB  ASP    94      29.782  35.242 114.015  1.00 74.90           C  
ATOM    799  CG  ASP    94      28.643  36.126 114.483  1.00 99.50           C  
ATOM    800  OD1 ASP    94      28.572  37.291 114.039  1.00125.90           O  
ATOM    801  OD2 ASP    94      27.818  35.656 115.295  1.00115.48           O  
ATOM    802  N   GLU    95      28.774  35.534 110.588  1.00 67.83           N  
ATOM    803  CA  GLU    95      27.934  34.949 109.541  1.00 72.63           C  
ATOM    804  C   GLU    95      28.752  34.584 108.303  1.00 69.46           C  
ATOM    805  O   GLU    95      29.844  35.120 108.089  1.00 62.78           O  
ATOM    806  CB  GLU    95      26.792  35.897 109.161  1.00 84.56           C  
ATOM    807  CG  GLU    95      25.454  35.587 109.828  1.00103.34           C  
ATOM    808  CD  GLU    95      25.446  35.870 111.321  1.00131.10           C  
ATOM    809  OE1 GLU    95      24.975  34.999 112.083  1.00149.05           O  
ATOM    810  OE2 GLU    95      25.907  36.956 111.734  1.00120.75           O  
ATOM    811  N   ASP    96      28.218  33.662 107.502  1.00 67.14           N  
ATOM    812  CA  ASP    96      28.824  33.275 106.229  1.00 61.36           C  
ATOM    813  C   ASP    96      28.684  34.390 105.199  1.00 57.82           C  
ATOM    814  O   ASP    96      27.626  35.014 105.096  1.00 58.90           O  
ATOM    815  CB  ASP    96      28.166  32.001 105.686  1.00 63.82           C  
ATOM    816  CG  ASP    96      28.538  30.760 106.478  1.00 83.76           C  
ATOM    817  OD1 ASP    96      29.690  30.294 106.361  1.00 83.72           O  
ATOM    818  OD2 ASP    96      27.668  30.237 107.206  1.00 94.54           O  
ATOM    819  N   ILE    97      29.754  34.640 104.446  1.00 50.57           N  
ATOM    820  CA  ILE    97      29.721  35.600 103.340  1.00 42.35           C  
ATOM    821  C   ILE    97      29.851  34.847 102.017  1.00 48.41           C  
ATOM    822  O   ILE    97      30.668  33.930 101.892  1.00 61.71           O  
ATOM    823  CB  ILE    97      30.836  36.681 103.452  1.00 38.51           C  
ATOM    824  CG1 ILE    97      30.998  37.146 104.905  1.00 56.20           C  
ATOM    825  CG2 ILE    97      30.543  37.866 102.519  1.00 36.70           C  
ATOM    826  CD1 ILE    97      32.017  38.258 105.111  1.00 36.92           C  
ATOM    827  N   TYR    98      29.036  35.235 101.038  1.00 43.37           N  
ATOM    828  CA  TYR    98      29.033  34.593  99.728  1.00 41.55           C  
ATOM    829  C   TYR    98      29.468  35.571  98.639  1.00 45.44           C  
ATOM    830  O   TYR    98      28.735  36.499  98.298  1.00 53.75           O  
ATOM    831  CB  TYR    98      27.649  34.019  99.419  1.00 43.75           C  
ATOM    832  CG  TYR    98      27.234  32.868 100.314  1.00 46.05           C  
ATOM    833  CD1 TYR    98      27.502  31.550  99.950  1.00 57.34           C  
ATOM    834  CD2 TYR    98      26.568  33.095 101.521  1.00 43.28           C  
ATOM    835  CE1 TYR    98      27.125  30.486 100.764  1.00 67.21           C  
ATOM    836  CE2 TYR    98      26.186  32.038 102.343  1.00 73.75           C  
ATOM    837  CZ  TYR    98      26.468  30.737 101.957  1.00 66.92           C  
ATOM    838  OH  TYR    98      26.093  29.688 102.765  1.00 54.52           O  
ATOM    839  N   ILE    99      30.663  35.352  98.098  1.00 37.68           N  
ATOM    840  CA  ILE    99      31.256  36.271  97.125  1.00 28.08           C  
ATOM    841  C   ILE    99      31.253  35.693  95.710  1.00 42.24           C  
ATOM    842  O   ILE    99      31.662  34.549  95.497  1.00 51.89           O  
ATOM    843  CB  ILE    99      32.712  36.664  97.512  1.00 32.23           C  
ATOM    844  CG1 ILE    99      32.817  36.961  99.014  1.00 42.55           C  
ATOM    845  CG2 ILE    99      33.200  37.863  96.683  1.00 37.46           C  
ATOM    846  CD1 ILE    99      34.240  37.035  99.531  1.00 44.76           C  
ATOM    847  N   GLN   100      30.778  36.487  94.752  1.00 41.82           N  
ATOM    848  CA  GLN   100      30.997  36.194  93.339  1.00 50.21           C  
ATOM    849  C   GLN   100      31.923  37.230  92.706  1.00 54.68           C  
ATOM    850  O   GLN   100      31.944  38.398  93.113  1.00 54.28           O  
ATOM    851  CB  GLN   100      29.678  36.066  92.560  1.00 50.15           C  
ATOM    852  CG  GLN   100      28.947  37.353  92.243  1.00 46.68           C  
ATOM    853  CD  GLN   100      27.981  37.186  91.088  1.00 48.67           C  
ATOM    854  OE1 GLN   100      28.382  37.188  89.922  1.00 30.74           O  
ATOM    855  NE2 GLN   100      26.702  37.039  91.406  1.00 37.98           N  
ATOM    856  N   LEU   101      32.703  36.784  91.724  1.00 50.71           N  
ATOM    857  CA  LEU   101      33.607  37.672  91.003  1.00 52.79           C  
ATOM    858  C   LEU   101      33.303  37.675  89.512  1.00 48.52           C  
ATOM    859  O   LEU   101      33.158  36.615  88.895  1.00 54.98           O  
ATOM    860  CB  LEU   101      35.076  37.300  91.253  1.00 57.78           C  
ATOM    861  CG  LEU   101      35.778  37.766  92.539  1.00 45.95           C  
ATOM    862  CD1 LEU   101      35.421  39.206  92.898  1.00 44.26           C  
ATOM    863  CD2 LEU   101      35.496  36.844  93.713  1.00 51.41           C  
ATOM    864  N   ASN   102      33.203  38.874  88.944  1.00 44.83           N  
ATOM    865  CA  ASN   102      32.942  39.035  87.518  1.00 54.17           C  
ATOM    866  C   ASN   102      34.192  39.484  86.763  1.00 63.67           C  
ATOM    867  O   ASN   102      34.495  40.678  86.690  1.00 68.06           O  
ATOM    868  CB  ASN   102      31.780  40.012  87.282  1.00 52.28           C  
ATOM    869  CG  ASN   102      30.482  39.560  87.940  1.00 52.25           C  
ATOM    870  OD1 ASN   102      29.761  40.367  88.527  1.00 64.12           O  
ATOM    871  ND2 ASN   102      30.180  38.268  87.842  1.00 50.03           N  
ATOM    872  N   PHE   103      34.917  38.512  86.213  1.00 64.90           N  
ATOM    873  CA  PHE   103      36.127  38.782  85.431  1.00 71.60           C  
ATOM    874  C   PHE   103      36.130  38.030  84.095  1.00 72.29           C  
ATOM    875  O   PHE   103      35.446  37.014  83.956  1.00 67.27           O  
ATOM    876  CB  PHE   103      37.415  38.570  86.256  1.00 69.00           C  
ATOM    877  CG  PHE   103      37.562  37.193  86.863  1.00 58.28           C  
ATOM    878  CD1 PHE   103      36.832  36.817  87.992  1.00 59.61           C  
ATOM    879  CD2 PHE   103      38.478  36.291  86.336  1.00 44.98           C  
ATOM    880  CE1 PHE   103      36.987  35.554  88.558  1.00 62.83           C  
ATOM    881  CE2 PHE   103      38.647  35.029  86.901  1.00 79.49           C  
ATOM    882  CZ  PHE   103      37.896  34.659  88.011  1.00 69.92           C  
ATOM    883  N   LYS   104      36.894  38.532  83.130  1.00 79.77           N  
ATOM    884  CA  LYS   104      36.661  38.217  81.726  1.00 77.85           C  
ATOM    885  C   LYS   104      36.767  36.717  81.472  1.00 80.76           C  
ATOM    886  O   LYS   104      35.888  36.119  80.852  1.00 89.35           O  
ATOM    887  CB  LYS   104      37.649  38.972  80.836  1.00 72.34           C  
ATOM    888  CG  LYS   104      37.514  38.660  79.354  1.00 89.58           C  
ATOM    889  CD  LYS   104      37.651  39.917  78.511  1.00108.84           C  
ATOM    890  CE  LYS   104      36.312  40.613  78.335  1.00111.27           C  
ATOM    891  NZ  LYS   104      36.408  41.778  77.412  1.00106.29           N  
ATOM    892  N   SER   105      37.849  36.115  81.956  1.00 79.14           N  
ATOM    893  CA  SER   105      38.225  34.768  81.544  1.00 84.89           C  
ATOM    894  C   SER   105      37.589  33.717  82.448  1.00 82.17           C  
ATOM    895  O   SER   105      37.340  32.589  82.023  1.00 88.04           O  
ATOM    896  CB  SER   105      39.747  34.613  81.548  1.00 93.30           C  
ATOM    897  OG  SER   105      40.275  34.793  82.850  1.00 90.41           O  
ATOM    898  N   SER   106      37.328  34.096  83.695  1.00 73.03           N  
ATOM    899  CA  SER   106      36.538  33.267  84.597  1.00 75.36           C  
ATOM    900  C   SER   106      36.819  31.785  84.373  1.00 81.22           C  
ATOM    901  O   SER   106      37.758  31.228  84.942  1.00 72.87           O  
ATOM    902  CB  SER   106      35.046  33.552  84.419  1.00 64.71           C  
ATOM    903  OG  SER   106      34.653  34.698  85.155  1.00 77.91           O  
ATOM    904  N   PHE   107      35.999  31.151  83.541  1.00 83.20           N  
ATOM    905  CA  PHE   107      35.974  29.697  83.449  1.00 84.24           C  
ATOM    906  C   PHE   107      37.065  29.184  82.516  1.00 86.74           C  
ATOM    907  O   PHE   107      37.000  28.055  82.029  1.00 85.34           O  
ATOM    908  CB  PHE   107      34.603  29.213  82.971  1.00 81.07           C  
ATOM    909  CG  PHE   107      33.671  28.836  84.087  1.00 80.14           C  
ATOM    910  CD1 PHE   107      33.679  27.555  84.611  1.00 79.45           C  
ATOM    911  CD2 PHE   107      32.785  29.763  84.611  1.00 81.77           C  
ATOM    912  CE1 PHE   107      32.822  27.205  85.638  1.00 73.72           C  
ATOM    913  CE2 PHE   107      31.926  29.419  85.637  1.00 86.27           C  
ATOM    914  CZ  PHE   107      31.945  28.138  86.151  1.00 81.88           C  
ATOM    915  N   GLN   108      38.068  30.021  82.269  1.00 81.83           N  
ATOM    916  CA  GLN   108      39.314  29.567  81.664  1.00 71.50           C  
ATOM    917  C   GLN   108      40.315  29.128  82.727  1.00 73.51           C  
ATOM    918  O   GLN   108      41.228  28.350  82.450  1.00 84.63           O  
ATOM    919  CB  GLN   108      39.920  30.670  80.794  1.00 60.92           C  
ATOM    920  CG  GLN   108      41.374  30.435  80.417  1.00 65.78           C  
ATOM    921  CD  GLN   108      42.133  31.727  80.189  1.00 78.37           C  
ATOM    922  OE1 GLN   108      41.699  32.589  79.424  1.00 89.24           O  
ATOM    923  NE2 GLN   108      43.274  31.869  80.853  1.00 93.78           N  
ATOM    924  N   ASN   109      40.138  29.632  83.944  1.00 61.06           N  
ATOM    925  CA  ASN   109      41.099  29.402  85.016  1.00 56.97           C  
ATOM    926  C   ASN   109      40.647  28.313  85.986  1.00 59.09           C  
ATOM    927  O   ASN   109      39.636  28.468  86.676  1.00 75.42           O  
ATOM    928  CB  ASN   109      41.355  30.715  85.760  1.00 60.45           C  
ATOM    929  CG  ASN   109      41.531  31.894  84.820  1.00 74.41           C  
ATOM    930  OD1 ASN   109      42.538  31.999  84.117  1.00 79.56           O  
ATOM    931  ND2 ASN   109      40.550  32.791  84.809  1.00 59.82           N  
ATOM    932  N   ALA   110      41.421  27.226  86.034  1.00 59.44           N  
ATOM    933  CA  ALA   110      41.104  26.024  86.820  1.00 76.50           C  
ATOM    934  C   ALA   110      40.965  26.262  88.322  1.00 85.33           C  
ATOM    935  O   ALA   110      40.127  25.641  88.974  1.00 92.26           O  
ATOM    936  CB  ALA   110      42.139  24.935  86.554  1.00 82.37           C  
ATOM    937  N   ASN   111      41.793  27.159  88.852  1.00 82.09           N  
ATOM    938  CA  ASN   111      41.751  27.555  90.263  1.00 78.31           C  
ATOM    939  C   ASN   111      40.481  28.279  90.704  1.00 81.26           C  
ATOM    940  O   ASN   111      40.028  28.098  91.838  1.00 72.89           O  
ATOM    941  CB  ASN   111      43.003  28.352  90.673  1.00 74.33           C  
ATOM    942  CG  ASN   111      43.195  29.661  89.888  1.00 91.41           C  
ATOM    943  OD1 ASN   111      43.724  30.630  90.433  1.00100.72           O  
ATOM    944  ND2 ASN   111      42.798  29.687  88.621  1.00 89.07           N  
ATOM    945  N   TYR   112      39.919  29.097  89.812  1.00 79.02           N  
ATOM    946  CA  TYR   112      38.642  29.763  90.070  1.00 74.72           C  
ATOM    947  C   TYR   112      37.493  28.757  90.073  1.00 69.62           C  
ATOM    948  O   TYR   112      36.572  28.866  90.882  1.00 78.78           O  
ATOM    949  CB  TYR   112      38.386  30.890  89.057  1.00 72.88           C  
ATOM    950  CG  TYR   112      36.951  31.392  89.019  1.00 74.65           C  
ATOM    951  CD1 TYR   112      36.144  31.159  87.905  1.00 79.19           C  
ATOM    952  CD2 TYR   112      36.398  32.089  90.098  1.00 68.23           C  
ATOM    953  CE1 TYR   112      34.829  31.611  87.860  1.00 84.25           C  
ATOM    954  CE2 TYR   112      35.082  32.543  90.065  1.00 59.00           C  
ATOM    955  CZ  TYR   112      34.305  32.301  88.942  1.00 78.44           C  
ATOM    956  OH  TYR   112      33.004  32.748  88.902  1.00 73.48           O  
ATOM    957  N   VAL   113      37.558  27.778  89.172  1.00 62.73           N  
ATOM    958  CA  VAL   113      36.542  26.726  89.111  1.00 67.82           C  
ATOM    959  C   VAL   113      36.683  25.765  90.301  1.00 71.35           C  
ATOM    960  O   VAL   113      35.686  25.234  90.801  1.00 73.33           O  
ATOM    961  CB  VAL   113      36.566  25.959  87.761  1.00 63.65           C  
ATOM    962  CG1 VAL   113      35.270  25.182  87.569  1.00 54.93           C  
ATOM    963  CG2 VAL   113      36.724  26.935  86.605  1.00 60.95           C  
ATOM    964  N   ALA   114      37.919  25.572  90.765  1.00 76.69           N  
ATOM    965  CA  ALA   114      38.192  24.758  91.953  1.00 80.97           C  
ATOM    966  C   ALA   114      37.709  25.418  93.245  1.00 78.44           C  
ATOM    967  O   ALA   114      37.286  24.727  94.175  1.00 66.02           O  
ATOM    968  CB  ALA   114      39.676  24.435  92.051  1.00 92.18           C  
ATOM    969  N   VAL   115      37.770  26.748  93.296  1.00 75.18           N  
ATOM    970  CA  VAL   115      37.393  27.499  94.499  1.00 59.72           C  
ATOM    971  C   VAL   115      35.870  27.702  94.617  1.00 56.76           C  
ATOM    972  O   VAL   115      35.364  28.046  95.692  1.00 50.37           O  
ATOM    973  CB  VAL   115      38.187  28.845  94.612  1.00 58.85           C  
ATOM    974  CG1 VAL   115      37.478  29.989  93.887  1.00 60.87           C  
ATOM    975  CG2 VAL   115      38.449  29.205  96.073  1.00 56.17           C  
ATOM    976  N   LEU   116      35.151  27.466  93.517  1.00 48.29           N  
ATOM    977  CA  LEU   116      33.690  27.584  93.485  1.00 47.06           C  
ATOM    978  C   LEU   116      33.000  26.504  94.314  1.00 54.39           C  
ATOM    979  O   LEU   116      33.454  25.358  94.365  1.00 65.36           O  
ATOM    980  CB  LEU   116      33.167  27.548  92.044  1.00 49.10           C  
ATOM    981  CG  LEU   116      33.228  28.833  91.208  1.00 59.28           C  
ATOM    982  CD1 LEU   116      33.046  28.512  89.730  1.00 80.25           C  
ATOM    983  CD2 LEU   116      32.196  29.866  91.670  1.00 67.83           C  
ATOM    984  N   GLU   117      31.901  26.889  94.962  1.00 54.18           N  
ATOM    985  CA  GLU   117      31.165  26.003  95.862  1.00 65.51           C  
ATOM    986  C   GLU   117      29.683  25.931  95.498  1.00 73.86           C  
ATOM    987  O   GLU   117      29.170  26.787  94.769  1.00 82.41           O  
ATOM    988  CB  GLU   117      31.321  26.465  97.317  1.00 59.45           C  
ATOM    989  CG  GLU   117      32.745  26.386  97.860  1.00 68.90           C  
ATOM    990  CD  GLU   117      32.862  26.863  99.295  1.00 78.47           C  
ATOM    991  OE1 GLU   117      33.674  27.777  99.552  1.00104.50           O  
ATOM    992  OE2 GLU   117      32.145  26.326 100.167  1.00 96.20           O  
ATOM    993  N   GLU   118      29.011  24.898  96.008  1.00 83.47           N  
ATOM    994  CA  GLU   118      27.568  24.732  95.846  1.00 86.27           C  
ATOM    995  C   GLU   118      26.795  25.804  96.608  1.00 80.52           C  
ATOM    996  O   GLU   118      26.851  25.872  97.838  1.00 81.70           O  
ATOM    997  CB  GLU   118      27.133  23.336  96.304  1.00 92.70           C  
ATOM    998  CG  GLU   118      26.780  22.378  95.173  1.00116.45           C  
ATOM    999  CD  GLU   118      25.311  22.451  94.776  1.00132.68           C  
ATOM   1000  OE1 GLU   118      24.438  22.359  95.671  1.00133.96           O  
ATOM   1001  OE2 GLU   118      25.029  22.589  93.566  1.00138.23           O  
ATOM   1002  N   ASN   119      26.096  26.646  95.853  1.00 71.42           N  
ATOM   1003  CA  ASN   119      25.233  27.688  96.397  1.00 67.20           C  
ATOM   1004  C   ASN   119      23.840  27.099  96.645  1.00 66.23           C  
ATOM   1005  O   ASN   119      23.119  26.792  95.692  1.00 71.02           O  
ATOM   1006  CB  ASN   119      25.201  28.882  95.423  1.00 71.74           C  
ATOM   1007  CG  ASN   119      24.132  29.926  95.778  1.00 54.24           C  
ATOM   1008  OD1 ASN   119      23.699  30.063  96.934  1.00 63.35           O  
ATOM   1009  ND2 ASN   119      23.721  30.686  94.767  1.00 50.59           N  
ATOM   1010  N   PRO   120      23.458  26.941  97.930  1.00 67.17           N  
ATOM   1011  CA  PRO   120      22.210  26.271  98.289  1.00 72.55           C  
ATOM   1012  C   PRO   120      21.014  27.218  98.461  1.00 70.30           C  
ATOM   1013  O   PRO   120      20.143  26.969  99.300  1.00 79.44           O  
ATOM   1014  CB  PRO   120      22.561  25.599  99.621  1.00 75.47           C  
ATOM   1015  CG  PRO   120      23.674  26.451 100.210  1.00 68.75           C  
ATOM   1016  CD  PRO   120      24.189  27.380  99.133  1.00 60.87           C  
ATOM   1017  N   TYR   121      20.976  28.287  97.668  1.00 66.26           N  
ATOM   1018  CA  TYR   121      19.871  29.248  97.703  1.00 70.81           C  
ATOM   1019  C   TYR   121      19.294  29.470  96.308  1.00 75.80           C  
ATOM   1020  O   TYR   121      18.388  30.288  96.117  1.00 86.93           O  
ATOM   1021  CB  TYR   121      20.316  30.569  98.340  1.00 77.51           C  
ATOM   1022  CG  TYR   121      20.838  30.401  99.748  1.00 92.01           C  
ATOM   1023  CD1 TYR   121      22.207  30.339  99.998  1.00102.48           C  
ATOM   1024  CD2 TYR   121      19.964  30.284 100.828  1.00102.41           C  
ATOM   1025  CE1 TYR   121      22.697  30.169 101.288  1.00 93.63           C  
ATOM   1026  CE2 TYR   121      20.443  30.118 102.122  1.00 97.11           C  
ATOM   1027  CZ  TYR   121      21.809  30.060 102.345  1.00 87.71           C  
ATOM   1028  OH  TYR   121      22.287  29.899 103.625  1.00 82.59           O  
ATOM   1029  N   LEU   122      19.823  28.737  95.334  1.00 74.94           N  
ATOM   1030  CA  LEU   122      19.115  28.503  94.081  1.00 73.34           C  
ATOM   1031  C   LEU   122      17.804  27.762  94.319  1.00 73.93           C  
ATOM   1032  O   LEU   122      17.756  26.793  95.077  1.00 74.38           O  
ATOM   1033  CB  LEU   122      19.995  27.716  93.107  1.00 79.27           C  
ATOM   1034  CG  LEU   122      20.942  28.540  92.233  1.00 62.59           C  
ATOM   1035  CD1 LEU   122      20.590  28.382  90.761  1.00104.35           C  
ATOM   1036  CD2 LEU   122      20.914  30.004  92.641  1.00 57.43           C  
END
