
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   87 (  702),  selected   87 , name 2ip6_A
# Molecule2: number of CA atoms  119 ( 1007),  selected  119 , name T0496_4_122.pdb
# PARAMETERS: 2ip6_A.T0496_4_122.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     7_A      -       -           -
LGA    H     8_A      P       4           #
LGA    -       -      V       5           -
LGA    I     9_A      S       6          1.424
LGA    K    10_A      V       7          1.633
LGA    Q    11_A      N       8          1.218
LGA    Q    12_A      E       9          0.916
LGA    A    13_A      K      10          1.077
LGA    L    14_A      K      11          0.908
LGA    D    15_A      D      12          1.077
LGA    L    16_A      F      13          0.783
LGA    F    17_A      V      14          0.940
LGA    T    18_A      K      15          0.568
LGA    R    19_A      W      16          0.712
LGA    L    20_A      F      17          0.560
LGA    Q    21_A      L      18          0.745
LGA    F    22_A      N      19          0.798
LGA    L    23_A      N      20          1.247
LGA    L    24_A      Y      21          1.400
LGA    Q    25_A      Q      22          3.719
LGA    K    26_A      -       -           -
LGA    H    27_A      -       -           -
LGA    D    28_A      -       -           -
LGA    T    29_A      -       -           -
LGA    I    30_A      -       -           -
LGA    E    31_A      -       -           -
LGA    P    32_A      L      23          5.176
LGA    Y    33_A      K      24          2.936
LGA    -       -      Q      25           -
LGA    Q    34_A      R      26          1.787
LGA    Y    35_A      E      27          3.061
LGA    V    36_A      C      28          2.878
LGA    L    37_A      V      29          1.470
LGA    D    38_A      W      30          1.970
LGA    I    39_A      I      31          2.688
LGA    L    40_A      L      32          1.682
LGA    E    41_A      N      33          0.765
LGA    T    42_A      Y      34          2.050
LGA    G    43_A      L      35          1.987
LGA    I    44_A      M      36          0.557
LGA    S    45_A      S      37          1.619
LGA    K    46_A      H      38          2.136
LGA    T    47_A      D      39          2.125
LGA    K    48_A      -       -           -
LGA    H    49_A      -       -           -
LGA    N    50_A      Q      40          2.540
LGA    Q    51_A      L      41          3.655
LGA    Q    52_A      M      42           #
LGA    T    53_A      H      43          1.572
LGA    P    54_A      -       -           -
LGA    E    55_A      -       -           -
LGA    R    56_A      K      44          2.376
LGA    Q    57_A      V      45          1.212
LGA    A    58_A      H      46          2.931
LGA    R    59_A      F      47          3.842
LGA    V    60_A      V      48           -
LGA    V    61_A      E      49           -
LGA    -       -      H      50           -
LGA    Y    62_A      A      51           #
LGA    N    63_A      K      52           #
LGA    -       -      Y      53           -
LGA    -       -      C      54           -
LGA    -       -      P      55           -
LGA    -       -      R      56           -
LGA    K    64_A      G      57          5.232
LGA    I    65_A      L      58          5.056
LGA    A    66_A      V      59          2.691
LGA    S    67_A      -       -           -
LGA    Q    68_A      M      60          3.276
LGA    A    69_A      S      61          3.161
LGA    L    70_A      A      62           -
LGA    V    71_A      -       -           -
LGA    D    72_A      -       -           -
LGA    K    73_A      -       -           -
LGA    L    74_A      N      63          4.686
LGA    H    75_A      C      64          3.567
LGA    F    76_A      V      65          4.195
LGA    -       -      K      66           -
LGA    -       -      D      67           -
LGA    -       -      T      68           -
LGA    -       -      P      69           -
LGA    -       -      F      70           -
LGA    -       -      H      71           -
LGA    -       -      F      72           -
LGA    -       -      F      73           -
LGA    -       -      K      74           -
LGA    -       -      Q      75           -
LGA    -       -      N      76           -
LGA    -       -      V      77           -
LGA    -       -      M      78           -
LGA    -       -      T      79           -
LGA    -       -      T      80           -
LGA    -       -      D      81           -
LGA    -       -      A      82           -
LGA    -       -      E      83           -
LGA    -       -      K      84           -
LGA    -       -      S      85           -
LGA    -       -      F      86           -
LGA    -       -      H      87           -
LGA    -       -      D      88           -
LGA    -       -      I      89           -
LGA    -       -      R      90           -
LGA    -       -      L      91           -
LGA    -       -      N      92           -
LGA    -       -      R      93           -
LGA    -       -      D      94           -
LGA    -       -      E      95           -
LGA    -       -      D      96           -
LGA    -       -      I      97           -
LGA    -       -      Y      98           -
LGA    -       -      I      99           -
LGA    -       -      Q     100           -
LGA    -       -      L     101           -
LGA    -       -      N     102           -
LGA    T    77_A      F     103          4.477
LGA    A    78_A      K     104          4.076
LGA    E    79_A      S     105          3.579
LGA    E    80_A      S     106          4.319
LGA    N    81_A      F     107          5.118
LGA    K    82_A      Q     108          4.731
LGA    V    83_A      N     109          5.338
LGA    -       -      A     110           -
LGA    -       -      N     111           -
LGA    L    84_A      Y     112          4.500
LGA    A    85_A      V     113          4.071
LGA    A    86_A      A     114          3.682
LGA    I    87_A      V     115          3.068
LGA    N    88_A      L     116          2.462
LGA    E    89_A      E     117          2.893
LGA    L    90_A      -       -           -
LGA    A    91_A      -       -           -
LGA    H    92_A      E     118          3.292
LGA    S    93_A      N     119           -
LGA    -       -      P     120           -
LGA    -       -      Y     121           -
LGA    -       -      L     122           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   87  119    5.0     62    2.95    11.29     34.075     2.031

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.930925 * X  +   0.280186 * Y  +  -0.234252 * Z  + 102.302498
  Y_new =  -0.160976 * X  +  -0.890550 * Y  +  -0.425450 * Z  +  19.143784
  Z_new =  -0.327818 * X  +  -0.358354 * Y  +   0.874138 * Z  + 123.585312 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.389055    2.752538  [ DEG:   -22.2912    157.7088 ]
  Theta =   0.333993    2.807600  [ DEG:    19.1364    160.8636 ]
  Phi   =  -2.970365    0.171228  [ DEG:  -170.1894      9.8106 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ip6_A                                        
REMARK     2: T0496_4_122.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ip6_A.T0496_4_122.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   87  119   5.0   62   2.95   11.29  34.075
REMARK  ---------------------------------------------------------- 
MOLECULE 2ip6_A
HEADER    ANTIMICROBIAL PROTEIN                   12-OCT-06   2IP6              
TITLE     CRYSTAL STRUCTURE OF PEDB                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PAPB;                                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: PEDB;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PEDIOCOCCUS PENTOSACEUS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PGEX-4T-1                                 
KEYWDS    IMMUNITY PROTEIN TO THE PEDIOCIN PP-1, ANTIMICROBIAL PROTEIN          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.O.KANG,I.K.KIM,M.K.KIM,J.H.KIM,H.S.YIM,S.S.CHA                      
REVDAT   1   02-OCT-07 2IP6    0                                                
JRNL        AUTH   I.K.KIM,M.K.KIM,J.H.KIM,H.S.YIM,S.S.CHA,S.O.KANG             
JRNL        TITL   HIGH RESOLUTION CRYSTAL STRUCTURE OF PEDB: A                 
JRNL        TITL 2 STRUCTURAL BASIS FOR THE CLASSIFICATION OF                   
JRNL        TITL 3 PEDIOCIN-LIKE IMMUNITY PROTEINS                              
JRNL        REF    BMC STRUCT.BIOL.              V.   7    35 2007              
JRNL        REFN                UK ESSN 1472-6807                               
REMARK   2 RESOLUTION. 1.35 ANGSTROMS.                                          
DBREF  2IP6 A    1   112  UNP    Q79IK2   Q79IK2_PEDPE     1    112             
SEQRES   1 A  112  MET ASN LYS THR LYS SER GLU HIS ILE LYS GLN GLN ALA          
SEQRES   2 A  112  LEU ASP LEU PHE THR ARG LEU GLN PHE LEU LEU GLN LYS          
SEQRES   3 A  112  HIS ASP THR ILE GLU PRO TYR GLN TYR VAL LEU ASP ILE          
SEQRES   4 A  112  LEU GLU THR GLY ILE SER LYS THR LYS HIS ASN GLN GLN          
SEQRES   5 A  112  THR PRO GLU ARG GLN ALA ARG VAL VAL TYR ASN LYS ILE          
SEQRES   6 A  112  ALA SER GLN ALA LEU VAL ASP LYS LEU HIS PHE THR ALA          
SEQRES   7 A  112  GLU GLU ASN LYS VAL LEU ALA ALA ILE ASN GLU LEU ALA          
SEQRES   8 A  112  HIS SER GLN LYS GLY TRP GLY GLU PHE ASN MET LEU ASP          
SEQRES   9 A  112  THR THR ASN THR TRP PRO SER GLN                              
HET    SO4  A 113       5                                                       
HETNAM     SO4 SULFATE ION                                                      
FORMUL   2  SO4    O4 S 2-                                                      
FORMUL   3  HOH   *160(H2 O)                                                    
CRYST1   62.189   62.189   39.898  90.00  90.00 120.00 P 62          6          
ATOM      1  N   GLU A   7      43.146  21.516 107.623  1.00 33.44           N  
ATOM      2  CA  GLU A   7      43.169  21.071 106.203  1.00 32.55           C  
ATOM      3  C   GLU A   7      43.837  22.127 105.333  1.00 32.09           C  
ATOM      4  O   GLU A   7      44.017  23.272 105.754  1.00 32.62           O  
ATOM      5  CB  GLU A   7      41.752  20.816 105.719  1.00 32.53           C  
ATOM      6  N   HIS A   8      44.204  21.734 104.118  1.00 30.53           N  
ATOM      7  CA  HIS A   8      44.855  22.641 103.182  1.00 27.41           C  
ATOM      8  C   HIS A   8      43.820  23.527 102.504  1.00 25.06           C  
ATOM      9  O   HIS A   8      44.159  24.345 101.649  1.00 24.88           O  
ATOM     10  CB  HIS A   8      45.624  21.847 102.138  1.00 28.20           C  
ATOM     11  N   ILE A   9      42.558  23.358 102.886  1.00 21.95           N  
ATOM     12  CA  ILE A   9      41.480  24.147 102.306  1.00 19.69           C  
ATOM     13  C   ILE A   9      41.724  25.630 102.573  1.00 17.44           C  
ATOM     14  O   ILE A   9      41.421  26.477 101.732  1.00 16.96           O  
ATOM     15  CB  ILE A   9      40.105  23.737 102.887  1.00 20.91           C  
ATOM     16  CG1 ILE A   9      38.985  24.439 102.117  1.00 22.43           C  
ATOM     17  CG2 ILE A   9      40.027  24.086 104.365  1.00 21.52           C  
ATOM     18  CD1 ILE A   9      38.930  24.060 100.651  1.00 24.20           C  
ATOM     19  N   LYS A  10      42.279  25.941 103.739  1.00 15.37           N  
ATOM     20  CA  LYS A  10      42.562  27.328 104.079  1.00 14.03           C  
ATOM     21  C   LYS A  10      43.531  27.939 103.077  1.00 13.77           C  
ATOM     22  O   LYS A  10      43.280  29.015 102.542  1.00 11.96           O  
ATOM     23  CB  LYS A  10      43.163  27.442 105.480  1.00 13.67           C  
ATOM     24  CG  LYS A  10      43.551  28.872 105.833  1.00 10.94           C  
ATOM     25  CD  LYS A  10      44.140  28.993 107.235  1.00 11.85           C  
ATOM     26  CE  LYS A  10      44.500  30.439 107.548  1.00 11.83           C  
ATOM     27  NZ  LYS A  10      44.943  30.632 108.962  1.00 11.89           N  
ATOM     28  N   GLN A  11      44.642  27.253 102.818  1.00 14.26           N  
ATOM     29  CA  GLN A  11      45.632  27.764 101.877  1.00 15.36           C  
ATOM     30  C   GLN A  11      45.050  27.832 100.465  1.00 14.79           C  
ATOM     31  O   GLN A  11      45.376  28.735  99.700  1.00 14.20           O  
ATOM     32  CB  GLN A  11      46.892  26.889 101.892  1.00 16.58           C  
ATOM     33  CG  GLN A  11      48.070  27.514 101.160  1.00 20.49           C  
ATOM     34  CD  GLN A  11      48.439  28.875 101.718  1.00 21.62           C  
ATOM     35  OE1 GLN A  11      48.495  29.865 100.985  1.00 24.31           O  
ATOM     36  NE2 GLN A  11      48.693  28.934 103.021  1.00 21.64           N  
ATOM     37  N   GLN A  12      44.194  26.873 100.127  1.00 14.82           N  
ATOM     38  CA  GLN A  12      43.549  26.837  98.817  1.00 15.78           C  
ATOM     39  C   GLN A  12      42.761  28.129  98.615  1.00 14.28           C  
ATOM     40  O   GLN A  12      42.839  28.764  97.565  1.00 15.06           O  
ATOM     41  CB  GLN A  12      42.587  25.650  98.732  1.00 19.58           C  
ATOM     42  CG  GLN A  12      43.247  24.283  98.827  1.00 24.66           C  
ATOM     43  CD  GLN A  12      43.711  23.759  97.484  1.00 27.39           C  
ATOM     44  OE1 GLN A  12      44.233  22.646  97.387  1.00 29.97           O  
ATOM     45  NE2 GLN A  12      43.521  24.554  96.437  1.00 30.56           N  
ATOM     46  N   ALA A  13      41.995  28.507  99.633  1.00 12.92           N  
ATOM     47  CA  ALA A  13      41.192  29.722  99.570  1.00 12.29           C  
ATOM     48  C   ALA A  13      42.082  30.955  99.441  1.00 11.94           C  
ATOM     49  O   ALA A  13      41.867  31.795  98.566  1.00 11.02           O  
ATOM     50  CB  ALA A  13      40.319  29.831 100.811  1.00 12.71           C  
ATOM     51  N   LEU A  14      43.082  31.063 100.308  1.00 11.20           N  
ATOM     52  CA  LEU A  14      43.988  32.203 100.262  1.00 11.14           C  
ATOM     53  C   LEU A  14      44.635  32.349  98.892  1.00 11.77           C  
ATOM     54  O   LEU A  14      44.721  33.452  98.357  1.00 13.03           O  
ATOM     55  CB  LEU A  14      45.072  32.066 101.331  1.00 11.01           C  
ATOM     56  CG  LEU A  14      44.584  32.207 102.774  1.00 11.15           C  
ATOM     57  CD1 LEU A  14      45.696  31.820 103.727  1.00 11.01           C  
ATOM     58  CD2 LEU A  14      44.121  33.639 103.030  1.00 12.57           C  
ATOM     59  N   ASP A  15      45.083  31.234  98.320  1.00 12.42           N  
ATOM     60  CA  ASP A  15      45.727  31.268  97.012  1.00 13.40           C  
ATOM     61  C   ASP A  15      44.782  31.749  95.915  1.00 12.83           C  
ATOM     62  O   ASP A  15      45.202  32.457  94.996  1.00 12.49           O  
ATOM     63  CB  ASP A  15      46.280  29.889  96.641  1.00 15.31           C  
ATOM     64  CG  ASP A  15      47.401  29.446  97.554  1.00 18.75           C  
ATOM     65  OD1 ASP A  15      48.081  30.322  98.130  1.00 19.23           O  
ATOM     66  OD2 ASP A  15      47.611  28.223  97.682  1.00 22.55           O  
ATOM     67  N   LEU A  16      43.513  31.353  95.991  1.00 11.35           N  
ATOM     68  CA  LEU A  16      42.545  31.796  94.992  1.00 11.48           C  
ATOM     69  C   LEU A  16      42.312  33.297  95.146  1.00 10.75           C  
ATOM     70  O   LEU A  16      42.236  34.018  94.155  1.00 10.64           O  
ATOM     71  CB  LEU A  16      41.217  31.052  95.144  1.00 11.38           C  
ATOM     72  CG  LEU A  16      41.178  29.599  94.658  1.00 11.60           C  
ATOM     73  CD1 LEU A  16      39.876  28.953  95.087  1.00 11.82           C  
ATOM     74  CD2 LEU A  16      41.332  29.555  93.142  1.00 13.82           C  
ATOM     75  N   PHE A  17      42.220  33.769  96.387  1.00 10.00           N  
ATOM     76  CA  PHE A  17      41.997  35.193  96.630  1.00  9.53           C  
ATOM     77  C   PHE A  17      43.158  36.052  96.131  1.00 10.76           C  
ATOM     78  O   PHE A  17      42.944  37.085  95.498  1.00  9.65           O  
ATOM     79  CB  PHE A  17      41.790  35.483  98.126  1.00  9.72           C  
ATOM     80  CG  PHE A  17      40.600  34.787  98.741  1.00  8.02           C  
ATOM     81  CD1 PHE A  17      39.512  34.385  97.971  1.00  9.98           C  
ATOM     82  CD2 PHE A  17      40.564  34.556 100.114  1.00  9.81           C  
ATOM     83  CE1 PHE A  17      38.407  33.761  98.563  1.00  9.01           C  
ATOM     84  CE2 PHE A  17      39.471  33.939 100.714  1.00  9.10           C  
ATOM     85  CZ  PHE A  17      38.389  33.538  99.936  1.00 10.12           C  
ATOM     86  N   THR A  18      44.388  35.638  96.429  1.00 11.11           N  
ATOM     87  CA  THR A  18      45.555  36.406  95.997  1.00 12.16           C  
ATOM     88  C   THR A  18      45.740  36.321  94.485  1.00 10.31           C  
ATOM     89  O   THR A  18      46.184  37.276  93.851  1.00 11.32           O  
ATOM     90  CB  THR A  18      46.856  35.936  96.703  1.00 13.43           C  
ATOM     91  OG1 THR A  18      47.079  34.549  96.437  1.00 15.28           O  
ATOM     92  CG2 THR A  18      46.755  36.165  98.207  1.00 15.94           C  
ATOM     93  N   ARG A  19      45.405  35.176  93.904  1.00 11.18           N  
ATOM     94  CA  ARG A  19      45.518  35.032  92.462  1.00 11.21           C  
ATOM     95  C   ARG A  19      44.566  36.020  91.794  1.00 10.30           C  
ATOM     96  O   ARG A  19      44.942  36.711  90.852  1.00 10.38           O  
ATOM     97  CB  ARG A  19      45.167  33.608  92.025  1.00 13.65           C  
ATOM     98  CG  ARG A  19      45.120  33.429  90.511  1.00 19.08           C  
ATOM     99  CD  ARG A  19      46.493  33.636  89.878  1.00 24.18           C  
ATOM    100  NE  ARG A  19      46.451  33.574  88.418  1.00 29.39           N  
ATOM    101  CZ  ARG A  19      45.993  32.536  87.723  1.00 29.37           C  
ATOM    102  NH1 ARG A  19      45.535  31.464  88.352  1.00 30.95           N  
ATOM    103  NH2 ARG A  19      45.987  32.575  86.397  1.00 30.05           N  
ATOM    104  N   LEU A  20      43.331  36.093  92.287  1.00  8.77           N  
ATOM    105  CA  LEU A  20      42.361  37.015  91.699  1.00  8.36           C  
ATOM    106  C   LEU A  20      42.801  38.468  91.891  1.00 10.13           C  
ATOM    107  O   LEU A  20      42.662  39.286  90.985  1.00 10.26           O  
ATOM    108  CB  LEU A  20      40.963  36.789  92.293  1.00  9.89           C  
ATOM    109  CG  LEU A  20      39.835  37.591  91.625  1.00  8.36           C  
ATOM    110  CD1 LEU A  20      39.830  37.320  90.129  1.00  9.79           C  
ATOM    111  CD2 LEU A  20      38.497  37.218  92.236  1.00  9.20           C  
ATOM    112  N   GLN A  21      43.326  38.792  93.067  1.00 10.66           N  
ATOM    113  CA  GLN A  21      43.798  40.153  93.322  1.00 12.55           C  
ATOM    114  C   GLN A  21      44.856  40.551  92.294  1.00 12.67           C  
ATOM    115  O   GLN A  21      44.862  41.676  91.788  1.00 14.53           O  
ATOM    116  CB  GLN A  21      44.391  40.266  94.725  1.00 16.57           C  
ATOM    117  CG  GLN A  21      43.375  40.531  95.812  1.00 20.73           C  
ATOM    118  CD  GLN A  21      44.025  40.743  97.161  1.00 23.29           C  
ATOM    119  OE1 GLN A  21      43.372  41.148  98.120  1.00 26.14           O  
ATOM    120  NE2 GLN A  21      45.318  40.461  97.244  1.00 21.80           N  
ATOM    121  N   PHE A  22      45.753  39.620  91.988  1.00 13.18           N  
ATOM    122  CA  PHE A  22      46.807  39.866  91.017  1.00 12.44           C  
ATOM    123  C   PHE A  22      46.216  40.138  89.640  1.00 12.00           C  
ATOM    124  O   PHE A  22      46.568  41.118  88.981  1.00 11.99           O  
ATOM    125  CB  PHE A  22      47.745  38.655  90.939  1.00 14.31           C  
ATOM    126  CG  PHE A  22      48.725  38.723  89.805  1.00 16.65           C  
ATOM    127  CD1 PHE A  22      49.762  39.647  89.821  1.00 19.87           C  
ATOM    128  CD2 PHE A  22      48.589  37.883  88.706  1.00 19.18           C  
ATOM    129  CE1 PHE A  22      50.653  39.737  88.758  1.00 20.63           C  
ATOM    130  CE2 PHE A  22      49.474  37.962  87.637  1.00 20.31           C  
ATOM    131  CZ  PHE A  22      50.507  38.891  87.663  1.00 21.17           C  
ATOM    132  N   LEU A  23      45.310  39.267  89.208  1.00 10.82           N  
ATOM    133  CA  LEU A  23      44.693  39.409  87.897  1.00  9.40           C  
ATOM    134  C   LEU A  23      43.931  40.717  87.721  1.00  9.96           C  
ATOM    135  O   LEU A  23      44.018  41.352  86.668  1.00 10.08           O  
ATOM    136  CB  LEU A  23      43.754  38.229  87.621  1.00  8.52           C  
ATOM    137  CG  LEU A  23      44.396  36.846  87.483  1.00  9.43           C  
ATOM    138  CD1 LEU A  23      43.305  35.800  87.311  1.00 10.91           C  
ATOM    139  CD2 LEU A  23      45.345  36.830  86.293  1.00 10.88           C  
ATOM    140  N   LEU A  24      43.197  41.122  88.752  1.00 10.12           N  
ATOM    141  CA  LEU A  24      42.407  42.346  88.687  1.00 11.35           C  
ATOM    142  C   LEU A  24      43.221  43.626  88.562  1.00 12.91           C  
ATOM    143  O   LEU A  24      42.666  44.690  88.281  1.00 13.21           O  
ATOM    144  CB  LEU A  24      41.479  42.438  89.900  1.00 12.87           C  
ATOM    145  CG  LEU A  24      40.368  41.387  89.951  1.00 13.19           C  
ATOM    146  CD1 LEU A  24      39.604  41.524  91.250  1.00 15.00           C  
ATOM    147  CD2 LEU A  24      39.442  41.546  88.751  1.00 16.00           C  
ATOM    148  N   GLN A  25      44.528  43.527  88.772  1.00 11.77           N  
ATOM    149  CA  GLN A  25      45.408  44.685  88.665  1.00 11.66           C  
ATOM    150  C   GLN A  25      46.026  44.788  87.270  1.00 11.89           C  
ATOM    151  O   GLN A  25      46.894  45.632  87.026  1.00 13.21           O  
ATOM    152  CB  GLN A  25      46.522  44.601  89.715  1.00 14.12           C  
ATOM    153  CG  GLN A  25      46.023  44.731  91.144  1.00 16.02           C  
ATOM    154  CD  GLN A  25      47.121  44.551  92.174  1.00 18.96           C  
ATOM    155  OE1 GLN A  25      48.077  45.329  92.229  1.00 21.91           O  
ATOM    156  NE2 GLN A  25      46.987  43.522  93.003  1.00 20.17           N  
ATOM    157  N   LYS A  26      45.572  43.942  86.350  1.00 11.98           N  
ATOM    158  CA  LYS A  26      46.100  43.937  84.988  1.00 12.11           C  
ATOM    159  C   LYS A  26      45.291  44.768  83.998  1.00 13.27           C  
ATOM    160  O   LYS A  26      45.568  44.749  82.801  1.00 15.02           O  
ATOM    161  CB  LYS A  26      46.195  42.498  84.468  1.00 15.21           C  
ATOM    162  CG  LYS A  26      47.165  41.615  85.236  1.00 17.33           C  
ATOM    163  CD  LYS A  26      47.166  40.182  84.707  1.00 21.34           C  
ATOM    164  CE  LYS A  26      47.504  40.128  83.223  1.00 23.33           C  
ATOM    165  NZ  LYS A  26      47.488  38.735  82.695  1.00 25.70           N  
ATOM    166  N   HIS A  27      44.296  45.496  84.490  1.00 12.96           N  
ATOM    167  CA  HIS A  27      43.459  46.319  83.616  1.00 12.77           C  
ATOM    168  C   HIS A  27      44.088  47.687  83.376  1.00 11.59           C  
ATOM    169  O   HIS A  27      45.073  48.042  84.023  1.00 11.92           O  
ATOM    170  CB  HIS A  27      42.069  46.467  84.235  1.00 14.92           C  
ATOM    171  CG  HIS A  27      41.335  45.168  84.367  1.00 17.51           C  
ATOM    172  ND1 HIS A  27      40.640  44.600  83.324  1.00 21.59           N  
ATOM    173  CD2 HIS A  27      41.229  44.308  85.407  1.00 19.76           C  
ATOM    174  CE1 HIS A  27      40.135  43.443  83.714  1.00 20.84           C  
ATOM    175  NE2 HIS A  27      40.477  43.242  84.973  1.00 21.73           N  
ATOM    176  N   ASP A  28      43.526  48.457  82.450  1.00 10.67           N  
ATOM    177  CA  ASP A  28      44.079  49.777  82.154  1.00 11.04           C  
ATOM    178  C   ASP A  28      43.932  50.790  83.282  1.00 10.48           C  
ATOM    179  O   ASP A  28      44.668  51.772  83.338  1.00 11.24           O  
ATOM    180  CB  ASP A  28      43.482  50.340  80.865  1.00 11.38           C  
ATOM    181  CG  ASP A  28      44.033  49.662  79.629  1.00 14.11           C  
ATOM    182  OD1 ASP A  28      45.099  49.017  79.725  1.00 14.87           O  
ATOM    183  OD2 ASP A  28      43.404  49.788  78.556  1.00 16.08           O  
ATOM    184  N   THR A  29      42.964  50.570  84.163  1.00 10.44           N  
ATOM    185  CA  THR A  29      42.776  51.438  85.317  1.00 10.65           C  
ATOM    186  C   THR A  29      42.498  50.507  86.482  1.00  9.37           C  
ATOM    187  O   THR A  29      42.249  49.316  86.278  1.00 11.27           O  
ATOM    188  CB  THR A  29      41.592  52.420  85.155  1.00 12.17           C  
ATOM    189  OG1 THR A  29      40.377  51.685  84.975  1.00 11.92           O  
ATOM    190  CG2 THR A  29      41.821  53.342  83.969  1.00 12.73           C  
ATOM    191  N   ILE A  30      42.558  51.027  87.700  1.00  9.60           N  
ATOM    192  CA  ILE A  30      42.308  50.179  88.852  1.00  9.58           C  
ATOM    193  C   ILE A  30      41.133  50.671  89.702  1.00  9.83           C  
ATOM    194  O   ILE A  30      40.526  49.895  90.433  1.00  9.43           O  
ATOM    195  CB  ILE A  30      43.604  50.024  89.702  1.00 11.67           C  
ATOM    196  CG1 ILE A  30      43.383  49.002  90.821  1.00 11.62           C  
ATOM    197  CG2 ILE A  30      44.037  51.367  90.237  1.00 12.77           C  
ATOM    198  CD1 ILE A  30      44.651  48.635  91.577  1.00 15.76           C  
ATOM    199  N   GLU A  31      40.781  51.947  89.576  1.00  8.65           N  
ATOM    200  CA  GLU A  31      39.667  52.491  90.354  1.00  8.94           C  
ATOM    201  C   GLU A  31      38.380  51.659  90.298  1.00  8.53           C  
ATOM    202  O   GLU A  31      37.778  51.383  91.333  1.00  9.68           O  
ATOM    203  CB  GLU A  31      39.348  53.926  89.924  1.00 10.39           C  
ATOM    204  CG  GLU A  31      38.181  54.524  90.702  1.00  9.77           C  
ATOM    205  CD  GLU A  31      37.775  55.906  90.220  1.00 11.80           C  
ATOM    206  OE1 GLU A  31      37.845  56.152  88.999  1.00 14.22           O  
ATOM    207  OE2 GLU A  31      37.368  56.732  91.062  1.00 13.63           O  
ATOM    208  N   PRO A  32      37.945  51.238  89.098  1.00  9.00           N  
ATOM    209  CA  PRO A  32      36.709  50.445  89.050  1.00  9.67           C  
ATOM    210  C   PRO A  32      36.793  49.096  89.761  1.00  9.63           C  
ATOM    211  O   PRO A  32      35.768  48.486  90.057  1.00  9.70           O  
ATOM    212  CB  PRO A  32      36.449  50.296  87.555  1.00 12.02           C  
ATOM    213  CG  PRO A  32      37.825  50.301  86.974  1.00 15.95           C  
ATOM    214  CD  PRO A  32      38.532  51.384  87.754  1.00 10.09           C  
ATOM    215  N   TYR A  33      38.011  48.648  90.043  1.00  8.00           N  
ATOM    216  CA  TYR A  33      38.233  47.362  90.703  1.00  7.31           C  
ATOM    217  C   TYR A  33      38.601  47.464  92.173  1.00  7.65           C  
ATOM    218  O   TYR A  33      38.693  46.448  92.856  1.00  8.07           O  
ATOM    219  CB  TYR A  33      39.348  46.606  89.976  1.00  8.62           C  
ATOM    220  CG  TYR A  33      39.035  46.358  88.523  1.00 10.33           C  
ATOM    221  CD1 TYR A  33      38.168  45.338  88.147  1.00 13.65           C  
ATOM    222  CD2 TYR A  33      39.559  47.185  87.530  1.00 12.85           C  
ATOM    223  CE1 TYR A  33      37.826  45.141  86.813  1.00 16.72           C  
ATOM    224  CE2 TYR A  33      39.221  47.002  86.189  1.00 16.68           C  
ATOM    225  CZ  TYR A  33      38.354  45.976  85.841  1.00 18.00           C  
ATOM    226  OH  TYR A  33      38.015  45.775  84.521  1.00 22.27           O  
ATOM    227  N   GLN A  34      38.801  48.676  92.677  1.00  8.26           N  
ATOM    228  CA  GLN A  34      39.212  48.822  94.071  1.00  7.95           C  
ATOM    229  C   GLN A  34      38.262  48.220  95.097  1.00  7.44           C  
ATOM    230  O   GLN A  34      38.714  47.634  96.073  1.00  8.11           O  
ATOM    231  CB  GLN A  34      39.470  50.290  94.412  1.00  9.53           C  
ATOM    232  CG  GLN A  34      40.157  50.485  95.765  1.00 10.95           C  
ATOM    233  CD  GLN A  34      41.473  49.725  95.868  1.00 12.73           C  
ATOM    234  OE1 GLN A  34      42.367  49.894  95.037  1.00 13.96           O  
ATOM    235  NE2 GLN A  34      41.597  48.884  96.889  1.00 12.43           N  
ATOM    236  N   TYR A  35      36.957  48.356  94.893  1.00  7.49           N  
ATOM    237  CA  TYR A  35      36.011  47.791  95.849  1.00  7.65           C  
ATOM    238  C   TYR A  35      36.200  46.271  95.888  1.00  6.52           C  
ATOM    239  O   TYR A  35      36.264  45.672  96.965  1.00  7.75           O  
ATOM    240  CB  TYR A  35      34.579  48.146  95.442  1.00  7.23           C  
ATOM    241  CG  TYR A  35      33.518  47.855  96.491  1.00  7.37           C  
ATOM    242  CD1 TYR A  35      33.283  46.557  96.934  1.00  8.14           C  
ATOM    243  CD2 TYR A  35      32.706  48.874  96.988  1.00  8.15           C  
ATOM    244  CE1 TYR A  35      32.263  46.276  97.840  1.00  8.88           C  
ATOM    245  CE2 TYR A  35      31.680  48.606  97.890  1.00  9.02           C  
ATOM    246  CZ  TYR A  35      31.460  47.303  98.310  1.00  9.11           C  
ATOM    247  OH  TYR A  35      30.416  47.019  99.165  1.00 11.33           O  
ATOM    248  N   VAL A  36      36.301  45.647  94.717  1.00  6.93           N  
ATOM    249  CA  VAL A  36      36.498  44.206  94.647  1.00  8.16           C  
ATOM    250  C   VAL A  36      37.826  43.823  95.302  1.00  8.05           C  
ATOM    251  O   VAL A  36      37.919  42.781  95.951  1.00  7.76           O  
ATOM    252  CB  VAL A  36      36.452  43.696  93.177  1.00  9.03           C  
ATOM    253  CG1 VAL A  36      36.917  42.244  93.102  1.00 12.26           C  
ATOM    254  CG2 VAL A  36      35.027  43.804  92.641  1.00 12.59           C  
ATOM    255  N   LEU A  37      38.849  44.660  95.141  1.00  7.56           N  
ATOM    256  CA  LEU A  37      40.138  44.376  95.764  1.00  6.55           C  
ATOM    257  C   LEU A  37      39.992  44.452  97.290  1.00  7.83           C  
ATOM    258  O   LEU A  37      40.617  43.670  98.010  1.00  8.99           O  
ATOM    259  CB  LEU A  37      41.206  45.359  95.267  1.00  8.91           C  
ATOM    260  CG  LEU A  37      41.634  45.175  93.804  1.00 10.18           C  
ATOM    261  CD1 LEU A  37      42.492  46.339  93.356  1.00 12.26           C  
ATOM    262  CD2 LEU A  37      42.392  43.862  93.656  1.00 12.04           C  
ATOM    263  N   ASP A  38      39.173  45.388  97.782  1.00  6.50           N  
ATOM    264  CA  ASP A  38      38.919  45.514  99.224  1.00  8.15           C  
ATOM    265  C   ASP A  38      38.247  44.234  99.718  1.00  8.14           C  
ATOM    266  O   ASP A  38      38.581  43.719 100.778  1.00  9.21           O  
ATOM    267  CB  ASP A  38      37.970  46.673  99.542  1.00  7.63           C  
ATOM    268  CG  ASP A  38      38.615  48.035  99.418  1.00  9.77           C  
ATOM    269  OD1 ASP A  38      39.840  48.130  99.205  1.00 10.50           O  
ATOM    270  OD2 ASP A  38      37.864  49.027  99.548  1.00 10.17           O  
ATOM    271  N   ILE A  39      37.279  43.740  98.951  1.00  6.53           N  
ATOM    272  CA  ILE A  39      36.568  42.516  99.313  1.00  7.30           C  
ATOM    273  C   ILE A  39      37.550  41.357  99.470  1.00  6.88           C  
ATOM    274  O   ILE A  39      37.450  40.557 100.408  1.00  8.80           O  
ATOM    275  CB  ILE A  39      35.513  42.144  98.241  1.00  7.26           C  
ATOM    276  CG1 ILE A  39      34.376  43.165  98.257  1.00  8.37           C  
ATOM    277  CG2 ILE A  39      34.960  40.743  98.504  1.00  8.65           C  
ATOM    278  CD1 ILE A  39      33.439  43.051  97.066  1.00 10.11           C  
ATOM    279  N   LEU A  40      38.504  41.268  98.551  1.00  7.53           N  
ATOM    280  CA  LEU A  40      39.492  40.205  98.600  1.00  8.60           C  
ATOM    281  C   LEU A  40      40.439  40.372  99.782  1.00  7.75           C  
ATOM    282  O   LEU A  40      40.795  39.390 100.443  1.00  7.74           O  
ATOM    283  CB  LEU A  40      40.260  40.162  97.279  1.00  7.76           C  
ATOM    284  CG  LEU A  40      39.440  39.569  96.129  1.00  8.22           C  
ATOM    285  CD1 LEU A  40      40.064  39.936  94.791  1.00  8.79           C  
ATOM    286  CD2 LEU A  40      39.368  38.056  96.295  1.00  9.01           C  
ATOM    287  N   GLU A  41      40.837  41.606 100.068  1.00  9.55           N  
ATOM    288  CA  GLU A  41      41.741  41.851 101.190  1.00 11.02           C  
ATOM    289  C   GLU A  41      41.053  41.465 102.498  1.00 10.12           C  
ATOM    290  O   GLU A  41      41.670  40.896 103.403  1.00 10.70           O  
ATOM    291  CB  GLU A  41      42.149  43.323 101.228  1.00 12.35           C  
ATOM    292  CG  GLU A  41      43.367  43.604 102.090  1.00 18.80           C  
ATOM    293  CD  GLU A  41      44.602  42.863 101.602  1.00 22.37           C  
ATOM    294  OE1 GLU A  41      44.878  42.906 100.384  1.00 24.40           O  
ATOM    295  OE2 GLU A  41      45.298  42.242 102.436  1.00 27.05           O  
ATOM    296  N   THR A  42      39.765  41.772 102.596  1.00  9.86           N  
ATOM    297  CA  THR A  42      38.997  41.443 103.786  1.00  8.68           C  
ATOM    298  C   THR A  42      38.815  39.928 103.892  1.00  8.97           C  
ATOM    299  O   THR A  42      38.920  39.363 104.983  1.00  9.64           O  
ATOM    300  CB  THR A  42      37.631  42.158 103.768  1.00  9.29           C  
ATOM    301  OG1 THR A  42      37.844  43.568 103.913  1.00 12.28           O  
ATOM    302  CG2 THR A  42      36.730  41.657 104.890  1.00 11.10           C  
ATOM    303  N   GLY A  43      38.549  39.268 102.767  1.00  8.53           N  
ATOM    304  CA  GLY A  43      38.398  37.822 102.787  1.00  8.90           C  
ATOM    305  C   GLY A  43      39.699  37.181 103.236  1.00  8.01           C  
ATOM    306  O   GLY A  43      39.703  36.216 104.000  1.00  8.35           O  
ATOM    307  N   ILE A  44      40.813  37.718 102.760  1.00  8.56           N  
ATOM    308  CA  ILE A  44      42.121  37.202 103.138  1.00  9.19           C  
ATOM    309  C   ILE A  44      42.364  37.400 104.639  1.00  9.51           C  
ATOM    310  O   ILE A  44      42.822  36.481 105.323  1.00  8.56           O  
ATOM    311  CB  ILE A  44      43.236  37.894 102.323  1.00  7.97           C  
ATOM    312  CG1 ILE A  44      43.150  37.445 100.861  1.00 10.43           C  
ATOM    313  CG2 ILE A  44      44.600  37.569 102.910  1.00 10.36           C  
ATOM    314  CD1 ILE A  44      44.019  38.235  99.910  1.00 10.99           C  
ATOM    315  N   SER A  45      42.048  38.585 105.154  1.00 10.13           N  
ATOM    316  CA  SER A  45      42.243  38.869 106.576  1.00  9.97           C  
ATOM    317  C   SER A  45      41.386  37.961 107.453  1.00  9.33           C  
ATOM    318  O   SER A  45      41.867  37.395 108.436  1.00  9.99           O  
ATOM    319  CB  SER A  45      41.909  40.334 106.871  1.00 10.90           C  
ATOM    320  OG  SER A  45      42.126  40.637 108.241  1.00 14.46           O  
ATOM    321  N   LYS A  46      40.114  37.821 107.095  1.00  8.17           N  
ATOM    322  CA  LYS A  46      39.196  36.983 107.852  1.00  8.48           C  
ATOM    323  C   LYS A  46      39.658  35.529 107.860  1.00  8.66           C  
ATOM    324  O   LYS A  46      39.577  34.850 108.885  1.00 10.42           O  
ATOM    325  CB  LYS A  46      37.789  37.074 107.256  1.00  9.84           C  
ATOM    326  CG  LYS A  46      37.052  38.370 107.560  1.00 10.96           C  
ATOM    327  CD  LYS A  46      35.815  38.497 106.674  1.00 11.12           C  
ATOM    328  CE  LYS A  46      34.942  39.673 107.086  1.00  9.99           C  
ATOM    329  NZ  LYS A  46      34.235  39.410 108.368  1.00 12.24           N  
ATOM    330  N   THR A  47      40.140  35.060 106.711  1.00  7.15           N  
ATOM    331  CA  THR A  47      40.617  33.692 106.578  1.00  8.14           C  
ATOM    332  C   THR A  47      41.917  33.518 107.370  1.00  8.79           C  
ATOM    333  O   THR A  47      42.080  32.534 108.090  1.00  9.09           O  
ATOM    334  CB  THR A  47      40.818  33.340 105.084  1.00  8.56           C  
ATOM    335  OG1 THR A  47      39.564  33.467 104.396  1.00 10.18           O  
ATOM    336  CG2 THR A  47      41.332  31.908 104.922  1.00  9.73           C  
ATOM    337  N   LYS A  48      42.833  34.475 107.257  1.00  8.82           N  
ATOM    338  CA  LYS A  48      44.090  34.396 108.002  1.00 10.55           C  
ATOM    339  C   LYS A  48      43.823  34.343 109.507  1.00 10.69           C  
ATOM    340  O   LYS A  48      44.505  33.620 110.238  1.00 12.67           O  
ATOM    341  CB  LYS A  48      44.989  35.592 107.666  1.00 11.49           C  
ATOM    342  CG  LYS A  48      45.674  35.473 106.313  1.00 17.17           C  
ATOM    343  CD  LYS A  48      46.631  36.623 106.044  1.00 20.46           C  
ATOM    344  CE  LYS A  48      47.387  36.402 104.739  1.00 23.53           C  
ATOM    345  NZ  LYS A  48      48.305  37.528 104.413  1.00 24.84           N  
ATOM    346  N   HIS A  49      42.824  35.096 109.965  1.00 10.39           N  
ATOM    347  CA  HIS A  49      42.465  35.124 111.383  1.00  9.59           C  
ATOM    348  C   HIS A  49      41.508  34.007 111.784  1.00  9.27           C  
ATOM    349  O   HIS A  49      40.899  34.051 112.855  1.00 10.96           O  
ATOM    350  CB  HIS A  49      41.855  36.476 111.759  1.00 10.65           C  
ATOM    351  CG  HIS A  49      42.843  37.600 111.774  1.00 12.92           C  
ATOM    352  ND1 HIS A  49      44.003  37.560 112.519  1.00 13.40           N  
ATOM    353  CD2 HIS A  49      42.837  38.800 111.149  1.00 14.00           C  
ATOM    354  CE1 HIS A  49      44.669  38.689 112.351  1.00 13.85           C  
ATOM    355  NE2 HIS A  49      43.984  39.458 111.525  1.00 15.82           N  
ATOM    356  N   ASN A  50      41.363  33.017 110.910  1.00 10.12           N  
ATOM    357  CA  ASN A  50      40.523  31.854 111.175  1.00  9.93           C  
ATOM    358  C   ASN A  50      39.079  32.127 111.610  1.00 10.40           C  
ATOM    359  O   ASN A  50      38.567  31.493 112.538  1.00 11.64           O  
ATOM    360  CB  ASN A  50      41.226  30.974 112.212  1.00 10.77           C  
ATOM    361  CG  ASN A  50      42.613  30.551 111.760  1.00 11.96           C  
ATOM    362  OD1 ASN A  50      43.571  30.559 112.540  1.00 14.68           O  
ATOM    363  ND2 ASN A  50      42.728  30.179 110.487  1.00 10.54           N  
ATOM    364  N   GLN A  51      38.418  33.058 110.929  1.00 10.49           N  
ATOM    365  CA  GLN A  51      37.028  33.380 111.243  1.00 11.29           C  
ATOM    366  C   GLN A  51      36.105  32.489 110.416  1.00 11.68           C  
ATOM    367  O   GLN A  51      36.339  32.289 109.220  1.00 12.00           O  
ATOM    368  CB  GLN A  51      36.757  34.855 110.953  1.00 10.47           C  
ATOM    369  CG  GLN A  51      37.591  35.791 111.814  1.00 11.47           C  
ATOM    370  CD  GLN A  51      37.321  35.601 113.293  1.00  9.96           C  
ATOM    371  OE1 GLN A  51      36.204  35.824 113.758  1.00 11.07           O  
ATOM    372  NE2 GLN A  51      38.340  35.175 114.039  1.00 11.94           N  
ATOM    373  N   GLN A  52      35.060  31.961 111.055  1.00 11.30           N  
ATOM    374  CA  GLN A  52      34.119  31.062 110.396  1.00 12.66           C  
ATOM    375  C   GLN A  52      34.921  29.934 109.766  1.00 12.76           C  
ATOM    376  O   GLN A  52      35.679  29.262 110.460  1.00 13.15           O  
ATOM    377  CB  GLN A  52      33.306  31.824 109.349  1.00 15.24           C  
ATOM    378  CG  GLN A  52      32.286  32.766 109.973  1.00 20.34           C  
ATOM    379  CD  GLN A  52      32.206  34.098 109.259  1.00 24.88           C  
ATOM    380  OE1 GLN A  52      33.154  34.884 109.283  1.00 28.81           O  
ATOM    381  NE2 GLN A  52      31.073  34.362 108.620  1.00 26.95           N  
ATOM    382  N   THR A  53      34.759  29.716 108.466  1.00 11.89           N  
ATOM    383  CA  THR A  53      35.516  28.677 107.778  1.00 12.24           C  
ATOM    384  C   THR A  53      36.007  29.255 106.458  1.00 12.30           C  
ATOM    385  O   THR A  53      35.461  30.250 105.973  1.00 10.97           O  
ATOM    386  CB  THR A  53      34.653  27.434 107.468  1.00 14.30           C  
ATOM    387  OG1 THR A  53      33.625  27.787 106.535  1.00 14.78           O  
ATOM    388  CG2 THR A  53      34.016  26.892 108.733  1.00 15.28           C  
ATOM    389  N   PRO A  54      37.055  28.658 105.869  1.00 11.40           N  
ATOM    390  CA  PRO A  54      37.538  29.193 104.593  1.00 13.01           C  
ATOM    391  C   PRO A  54      36.433  29.112 103.538  1.00 12.74           C  
ATOM    392  O   PRO A  54      36.293  30.004 102.704  1.00 11.70           O  
ATOM    393  CB  PRO A  54      38.723  28.291 104.267  1.00 12.62           C  
ATOM    394  CG  PRO A  54      39.247  27.921 105.623  1.00 14.69           C  
ATOM    395  CD  PRO A  54      37.983  27.640 106.400  1.00 12.51           C  
ATOM    396  N   GLU A  55      35.644  28.041 103.581  1.00 12.89           N  
ATOM    397  CA  GLU A  55      34.553  27.862 102.630  1.00 12.17           C  
ATOM    398  C   GLU A  55      33.531  28.985 102.771  1.00 11.44           C  
ATOM    399  O   GLU A  55      33.032  29.508 101.774  1.00 12.47           O  
ATOM    400  CB  GLU A  55      33.877  26.499 102.829  1.00 14.39           C  
ATOM    401  CG  GLU A  55      34.793  25.318 102.532  1.00 16.57           C  
ATOM    402  CD  GLU A  55      35.492  24.774 103.768  1.00 18.44           C  
ATOM    403  OE1 GLU A  55      35.865  25.569 104.654  1.00 17.89           O  
ATOM    404  OE2 GLU A  55      35.678  23.542 103.846  1.00 17.51           O  
ATOM    405  N   ARG A  56      33.225  29.362 104.008  1.00 11.10           N  
ATOM    406  CA  ARG A  56      32.284  30.448 104.268  1.00 12.44           C  
ATOM    407  C   ARG A  56      32.847  31.785 103.774  1.00 11.17           C  
ATOM    408  O   ARG A  56      32.121  32.606 103.202  1.00 11.62           O  
ATOM    409  CB  ARG A  56      31.977  30.535 105.767  1.00 14.28           C  
ATOM    410  CG  ARG A  56      31.317  31.837 106.210  1.00 19.10           C  
ATOM    411  CD  ARG A  56      30.015  32.106 105.481  1.00 23.58           C  
ATOM    412  NE  ARG A  56      29.412  33.366 105.909  1.00 26.25           N  
ATOM    413  CZ  ARG A  56      28.275  33.853 105.421  1.00 27.66           C  
ATOM    414  NH1 ARG A  56      27.611  33.189 104.484  1.00 29.54           N  
ATOM    415  NH2 ARG A  56      27.798  35.002 105.875  1.00 29.13           N  
ATOM    416  N   GLN A  57      34.139  32.010 103.997  1.00 10.98           N  
ATOM    417  CA  GLN A  57      34.761  33.252 103.548  1.00  9.77           C  
ATOM    418  C   GLN A  57      34.772  33.302 102.023  1.00  9.60           C  
ATOM    419  O   GLN A  57      34.641  34.371 101.432  1.00 10.37           O  
ATOM    420  CB  GLN A  57      36.189  33.380 104.083  1.00 10.14           C  
ATOM    421  CG  GLN A  57      36.299  33.414 105.609  1.00 10.20           C  
ATOM    422  CD  GLN A  57      35.455  34.504 106.245  1.00 13.16           C  
ATOM    423  OE1 GLN A  57      34.993  35.423 105.572  1.00 12.17           O  
ATOM    424  NE2 GLN A  57      35.262  34.411 107.559  1.00 13.73           N  
ATOM    425  N   ALA A  58      34.934  32.146 101.385  1.00  9.96           N  
ATOM    426  CA  ALA A  58      34.937  32.091  99.929  1.00  9.88           C  
ATOM    427  C   ALA A  58      33.544  32.427  99.396  1.00 10.38           C  
ATOM    428  O   ALA A  58      33.410  33.105  98.377  1.00  9.84           O  
ATOM    429  CB  ALA A  58      35.369  30.711  99.458  1.00  9.93           C  
ATOM    430  N   ARG A  59      32.511  31.956 100.086  1.00 10.38           N  
ATOM    431  CA  ARG A  59      31.141  32.237  99.674  1.00 11.30           C  
ATOM    432  C   ARG A  59      30.887  33.737  99.720  1.00 11.26           C  
ATOM    433  O   ARG A  59      30.350  34.314  98.778  1.00 12.24           O  
ATOM    434  CB  ARG A  59      30.138  31.533 100.590  1.00 13.03           C  
ATOM    435  CG  ARG A  59      28.692  31.915 100.293  1.00 18.79           C  
ATOM    436  CD  ARG A  59      27.700  31.226 101.218  1.00 22.81           C  
ATOM    437  NE  ARG A  59      26.329  31.685 100.990  1.00 28.90           N  
ATOM    438  CZ  ARG A  59      25.686  31.596  99.828  1.00 29.80           C  
ATOM    439  NH1 ARG A  59      26.283  31.062  98.771  1.00 31.67           N  
ATOM    440  NH2 ARG A  59      24.440  32.042  99.722  1.00 31.34           N  
ATOM    441  N   VAL A  60      31.268  34.360 100.830  1.00 10.44           N  
ATOM    442  CA  VAL A  60      31.086  35.793 101.001  1.00 11.12           C  
ATOM    443  C   VAL A  60      31.847  36.591  99.944  1.00 10.98           C  
ATOM    444  O   VAL A  60      31.311  37.538  99.367  1.00  9.88           O  
ATOM    445  CB  VAL A  60      31.530  36.244 102.411  1.00 12.07           C  
ATOM    446  CG1 VAL A  60      31.526  37.761 102.503  1.00 13.20           C  
ATOM    447  CG2 VAL A  60      30.593  35.658 103.455  1.00 14.18           C  
ATOM    448  N   VAL A  61      33.098  36.211  99.694  1.00  8.92           N  
ATOM    449  CA  VAL A  61      33.912  36.893  98.697  1.00  8.63           C  
ATOM    450  C   VAL A  61      33.244  36.787  97.330  1.00  8.78           C  
ATOM    451  O   VAL A  61      33.084  37.787  96.630  1.00  7.63           O  
ATOM    452  CB  VAL A  61      35.336  36.286  98.634  1.00  8.23           C  
ATOM    453  CG1 VAL A  61      36.030  36.691  97.341  1.00  9.92           C  
ATOM    454  CG2 VAL A  61      36.150  36.769  99.835  1.00  9.19           C  
ATOM    455  N   TYR A  62      32.839  35.578  96.958  1.00  8.25           N  
ATOM    456  CA  TYR A  62      32.199  35.381  95.663  1.00  8.48           C  
ATOM    457  C   TYR A  62      30.925  36.202  95.527  1.00  9.24           C  
ATOM    458  O   TYR A  62      30.755  36.927  94.548  1.00  7.94           O  
ATOM    459  CB  TYR A  62      31.857  33.908  95.434  1.00  8.98           C  
ATOM    460  CG  TYR A  62      31.230  33.674  94.079  1.00  8.33           C  
ATOM    461  CD1 TYR A  62      32.019  33.563  92.938  1.00  8.99           C  
ATOM    462  CD2 TYR A  62      29.841  33.622  93.927  1.00  8.75           C  
ATOM    463  CE1 TYR A  62      31.450  33.409  91.684  1.00  9.47           C  
ATOM    464  CE2 TYR A  62      29.258  33.469  92.671  1.00  9.24           C  
ATOM    465  CZ  TYR A  62      30.071  33.363  91.554  1.00  8.06           C  
ATOM    466  OH  TYR A  62      29.521  33.214  90.302  1.00  9.73           O  
ATOM    467  N   ASN A  63      30.028  36.079  96.503  1.00  8.25           N  
ATOM    468  CA  ASN A  63      28.766  36.810  96.458  1.00  8.96           C  
ATOM    469  C   ASN A  63      28.980  38.317  96.425  1.00  8.52           C  
ATOM    470  O   ASN A  63      28.313  39.023  95.673  1.00  9.58           O  
ATOM    471  CB  ASN A  63      27.884  36.437  97.658  1.00 11.02           C  
ATOM    472  CG  ASN A  63      27.301  35.031  97.554  1.00 13.07           C  
ATOM    473  OD1 ASN A  63      26.646  34.555  98.482  1.00 18.78           O  
ATOM    474  ND2 ASN A  63      27.533  34.365  96.429  1.00 14.56           N  
ATOM    475  N   LYS A  64      29.912  38.819  97.227  1.00  8.40           N  
ATOM    476  CA  LYS A  64      30.157  40.255  97.240  1.00  7.62           C  
ATOM    477  C   LYS A  64      30.736  40.751  95.920  1.00  7.10           C  
ATOM    478  O   LYS A  64      30.387  41.838  95.463  1.00  7.13           O  
ATOM    479  CB  LYS A  64      31.071  40.636  98.405  1.00  9.24           C  
ATOM    480  CG  LYS A  64      30.342  40.683  99.737  1.00 11.23           C  
ATOM    481  CD  LYS A  64      31.277  41.074 100.869  1.00 14.40           C  
ATOM    482  CE  LYS A  64      30.495  41.623 102.048  1.00 19.88           C  
ATOM    483  NZ  LYS A  64      29.336  40.763 102.396  1.00 23.35           N  
ATOM    484  N   ILE A  65      31.602  39.956  95.299  1.00  6.78           N  
ATOM    485  CA  ILE A  65      32.184  40.359  94.025  1.00  7.26           C  
ATOM    486  C   ILE A  65      31.137  40.300  92.910  1.00  6.21           C  
ATOM    487  O   ILE A  65      31.071  41.194  92.067  1.00  7.68           O  
ATOM    488  CB  ILE A  65      33.406  39.481  93.657  1.00  6.59           C  
ATOM    489  CG1 ILE A  65      34.551  39.760  94.642  1.00  8.70           C  
ATOM    490  CG2 ILE A  65      33.823  39.762  92.221  1.00  8.69           C  
ATOM    491  CD1 ILE A  65      35.811  38.951  94.391  1.00  8.52           C  
ATOM    492  N   ALA A  66      30.320  39.251  92.902  1.00  7.74           N  
ATOM    493  CA  ALA A  66      29.278  39.136  91.882  1.00  7.48           C  
ATOM    494  C   ALA A  66      28.342  40.344  91.974  1.00  8.02           C  
ATOM    495  O   ALA A  66      27.911  40.902  90.961  1.00  8.80           O  
ATOM    496  CB  ALA A  66      28.491  37.847  92.083  1.00  8.16           C  
ATOM    497  N   SER A  67      28.022  40.739  93.199  1.00  8.38           N  
ATOM    498  CA  SER A  67      27.149  41.879  93.430  1.00  6.74           C  
ATOM    499  C   SER A  67      27.811  43.172  92.962  1.00  6.85           C  
ATOM    500  O   SER A  67      27.194  43.979  92.263  1.00  7.34           O  
ATOM    501  CB  SER A  67      26.812  41.981  94.920  1.00  6.69           C  
ATOM    502  OG  SER A  67      25.980  43.098  95.183  1.00  9.66           O  
ATOM    503  N   GLN A  68      29.069  43.372  93.344  1.00  7.84           N  
ATOM    504  CA  GLN A  68      29.765  44.587  92.956  1.00  7.94           C  
ATOM    505  C   GLN A  68      29.933  44.674  91.444  1.00  8.93           C  
ATOM    506  O   GLN A  68      29.916  45.767  90.880  1.00  9.19           O  
ATOM    507  CB  GLN A  68      31.130  44.664  93.646  1.00  9.05           C  
ATOM    508  CG  GLN A  68      31.649  46.087  93.831  1.00 10.73           C  
ATOM    509  CD  GLN A  68      30.657  46.981  94.558  1.00 10.91           C  
ATOM    510  OE1 GLN A  68      29.840  46.507  95.352  1.00 14.10           O  
ATOM    511  NE2 GLN A  68      30.731  48.277  94.299  1.00 11.29           N  
ATOM    512  N   ALA A  69      30.090  43.530  90.784  1.00  8.10           N  
ATOM    513  CA  ALA A  69      30.232  43.534  89.334  1.00  8.04           C  
ATOM    514  C   ALA A  69      28.974  44.137  88.706  1.00  8.78           C  
ATOM    515  O   ALA A  69      29.040  44.733  87.636  1.00 10.56           O  
ATOM    516  CB  ALA A  69      30.476  42.121  88.818  1.00  8.24           C  
ATOM    517  N   LEU A  70      27.831  43.992  89.372  1.00 10.54           N  
ATOM    518  CA  LEU A  70      26.595  44.585  88.865  1.00 11.54           C  
ATOM    519  C   LEU A  70      26.650  46.082  89.155  1.00 12.49           C  
ATOM    520  O   LEU A  70      26.420  46.912  88.274  1.00 13.30           O  
ATOM    521  CB  LEU A  70      25.374  43.998  89.575  1.00 12.12           C  
ATOM    522  CG  LEU A  70      25.065  42.518  89.388  1.00 10.80           C  
ATOM    523  CD1 LEU A  70      23.827  42.165  90.195  1.00 13.80           C  
ATOM    524  CD2 LEU A  70      24.847  42.216  87.914  1.00 14.19           C  
ATOM    525  N   VAL A  71      26.970  46.413  90.401  1.00 13.28           N  
ATOM    526  CA  VAL A  71      27.052  47.798  90.863  1.00 13.87           C  
ATOM    527  C   VAL A  71      28.081  48.653  90.125  1.00 13.66           C  
ATOM    528  O   VAL A  71      27.800  49.803  89.779  1.00 15.32           O  
ATOM    529  CB  VAL A  71      27.365  47.849  92.378  1.00 14.10           C  
ATOM    530  CG1 VAL A  71      27.520  49.292  92.835  1.00 14.76           C  
ATOM    531  CG2 VAL A  71      26.247  47.157  93.166  1.00 15.29           C  
ATOM    532  N   ASP A  72      29.272  48.107  89.894  1.00 12.01           N  
ATOM    533  CA  ASP A  72      30.316  48.856  89.203  1.00 11.54           C  
ATOM    534  C   ASP A  72      30.450  48.508  87.725  1.00 13.77           C  
ATOM    535  O   ASP A  72      31.407  48.932  87.078  1.00 14.16           O  
ATOM    536  CB  ASP A  72      31.669  48.669  89.904  1.00 13.80           C  
ATOM    537  CG  ASP A  72      31.714  49.328  91.270  1.00 13.83           C  
ATOM    538  OD1 ASP A  72      31.009  50.336  91.455  1.00 15.15           O  
ATOM    539  OD2 ASP A  72      32.462  48.851  92.150  1.00 14.34           O  
ATOM    540  N   LYS A  73      29.489  47.750  87.201  1.00 13.62           N  
ATOM    541  CA  LYS A  73      29.474  47.339  85.794  1.00 13.28           C  
ATOM    542  C   LYS A  73      30.848  46.833  85.357  1.00 13.08           C  
ATOM    543  O   LYS A  73      31.456  47.362  84.421  1.00 14.62           O  
ATOM    544  CB  LYS A  73      29.053  48.515  84.906  1.00 14.93           C  
ATOM    545  CG  LYS A  73      28.636  48.104  83.505  1.00 21.05           C  
ATOM    546  CD  LYS A  73      27.253  47.459  83.513  1.00 23.18           C  
ATOM    547  CE  LYS A  73      26.147  48.505  83.418  1.00 24.89           C  
ATOM    548  NZ  LYS A  73      26.312  49.622  84.388  1.00 27.37           N  
ATOM    549  N   LEU A  74      31.330  45.796  86.034  1.00 12.25           N  
ATOM    550  CA  LEU A  74      32.642  45.232  85.748  1.00 13.25           C  
ATOM    551  C   LEU A  74      32.620  44.117  84.710  1.00 15.55           C  
ATOM    552  O   LEU A  74      31.697  43.308  84.675  1.00 16.23           O  
ATOM    553  CB  LEU A  74      33.267  44.723  87.048  1.00 11.42           C  
ATOM    554  CG  LEU A  74      33.405  45.796  88.136  1.00 11.58           C  
ATOM    555  CD1 LEU A  74      34.079  45.198  89.365  1.00 11.58           C  
ATOM    556  CD2 LEU A  74      34.213  46.978  87.608  1.00 14.05           C  
ATOM    557  N   HIS A  75      33.655  44.093  83.871  1.00 16.01           N  
ATOM    558  CA  HIS A  75      33.802  43.098  82.810  1.00 19.01           C  
ATOM    559  C   HIS A  75      35.082  42.290  83.024  1.00 18.48           C  
ATOM    560  O   HIS A  75      36.176  42.744  82.678  1.00 21.81           O  
ATOM    561  CB  HIS A  75      33.857  43.802  81.452  1.00 22.10           C  
ATOM    562  CG  HIS A  75      32.673  44.676  81.179  1.00 25.30           C  
ATOM    563  ND1 HIS A  75      31.406  44.171  80.978  1.00 28.03           N  
ATOM    564  CD2 HIS A  75      32.561  46.023  81.089  1.00 27.02           C  
ATOM    565  CE1 HIS A  75      30.565  45.170  80.777  1.00 28.50           C  
ATOM    566  NE2 HIS A  75      31.241  46.304  80.839  1.00 28.16           N  
ATOM    567  N   PHE A  76      34.938  41.090  83.582  1.00 17.22           N  
ATOM    568  CA  PHE A  76      36.084  40.230  83.869  1.00 14.62           C  
ATOM    569  C   PHE A  76      36.583  39.421  82.678  1.00 13.83           C  
ATOM    570  O   PHE A  76      35.830  39.106  81.759  1.00 14.87           O  
ATOM    571  CB  PHE A  76      35.753  39.263  85.011  1.00 13.48           C  
ATOM    572  CG  PHE A  76      35.335  39.941  86.288  1.00 11.78           C  
ATOM    573  CD1 PHE A  76      36.181  40.842  86.929  1.00 14.51           C  
ATOM    574  CD2 PHE A  76      34.093  39.666  86.855  1.00 13.45           C  
ATOM    575  CE1 PHE A  76      35.790  41.464  88.122  1.00 12.52           C  
ATOM    576  CE2 PHE A  76      33.695  40.279  88.042  1.00 13.16           C  
ATOM    577  CZ  PHE A  76      34.544  41.178  88.677  1.00 11.63           C  
ATOM    578  N   THR A  77      37.868  39.084  82.716  1.00 12.34           N  
ATOM    579  CA  THR A  77      38.497  38.296  81.664  1.00 12.06           C  
ATOM    580  C   THR A  77      38.194  36.817  81.883  1.00 12.12           C  
ATOM    581  O   THR A  77      37.659  36.430  82.922  1.00 12.35           O  
ATOM    582  CB  THR A  77      40.016  38.475  81.683  1.00 13.10           C  
ATOM    583  OG1 THR A  77      40.539  37.910  82.892  1.00 14.11           O  
ATOM    584  CG2 THR A  77      40.378  39.954  81.615  1.00 13.93           C  
ATOM    585  N   ALA A  78      38.530  35.990  80.899  1.00 13.12           N  
ATOM    586  CA  ALA A  78      38.303  34.555  81.012  1.00 12.70           C  
ATOM    587  C   ALA A  78      39.061  33.999  82.217  1.00 11.62           C  
ATOM    588  O   ALA A  78      38.546  33.161  82.955  1.00 14.20           O  
ATOM    589  CB  ALA A  78      38.762  33.852  79.732  1.00 12.50           C  
ATOM    590  N   GLU A  79      40.282  34.479  82.414  1.00 13.16           N  
ATOM    591  CA  GLU A  79      41.114  34.033  83.525  1.00 13.55           C  
ATOM    592  C   GLU A  79      40.496  34.430  84.871  1.00 11.50           C  
ATOM    593  O   GLU A  79      40.469  33.641  85.814  1.00 11.61           O  
ATOM    594  CB  GLU A  79      42.519  34.623  83.377  1.00 16.65           C  
ATOM    595  CG  GLU A  79      43.540  34.078  84.352  1.00 22.75           C  
ATOM    596  CD  GLU A  79      44.962  34.268  83.856  1.00 24.48           C  
ATOM    597  OE1 GLU A  79      45.292  35.388  83.409  1.00 27.23           O  
ATOM    598  OE2 GLU A  79      45.747  33.297  83.916  1.00 28.91           O  
ATOM    599  N   GLU A  80      39.990  35.654  84.953  1.00 10.61           N  
ATOM    600  CA  GLU A  80      39.363  36.125  86.181  1.00 10.57           C  
ATOM    601  C   GLU A  80      38.093  35.327  86.471  1.00 10.75           C  
ATOM    602  O   GLU A  80      37.851  34.924  87.607  1.00 10.39           O  
ATOM    603  CB  GLU A  80      39.044  37.617  86.059  1.00 10.87           C  
ATOM    604  CG  GLU A  80      40.284  38.504  86.142  1.00 12.16           C  
ATOM    605  CD  GLU A  80      40.067  39.909  85.606  1.00 14.55           C  
ATOM    606  OE1 GLU A  80      41.000  40.729  85.734  1.00 18.22           O  
ATOM    607  OE2 GLU A  80      38.984  40.195  85.055  1.00 12.72           O  
ATOM    608  N   ASN A  81      37.282  35.095  85.443  1.00 10.69           N  
ATOM    609  CA  ASN A  81      36.057  34.328  85.628  1.00 11.28           C  
ATOM    610  C   ASN A  81      36.372  32.905  86.071  1.00 11.40           C  
ATOM    611  O   ASN A  81      35.631  32.313  86.854  1.00 11.36           O  
ATOM    612  CB  ASN A  81      35.240  34.318  84.331  1.00 11.72           C  
ATOM    613  CG  ASN A  81      34.377  35.553  84.185  1.00 15.17           C  
ATOM    614  OD1 ASN A  81      34.277  36.138  83.106  1.00 16.61           O  
ATOM    615  ND2 ASN A  81      33.735  35.953  85.277  1.00 15.68           N  
ATOM    616  N   LYS A  82      37.482  32.365  85.578  1.00 11.94           N  
ATOM    617  CA  LYS A  82      37.891  31.015  85.937  1.00 13.33           C  
ATOM    618  C   LYS A  82      38.207  30.939  87.427  1.00 11.64           C  
ATOM    619  O   LYS A  82      37.785  30.010  88.111  1.00 13.28           O  
ATOM    620  CB  LYS A  82      39.111  30.602  85.108  1.00 15.77           C  
ATOM    621  CG  LYS A  82      39.650  29.215  85.411  1.00 18.94           C  
ATOM    622  CD  LYS A  82      40.568  28.751  84.293  1.00 21.47           C  
ATOM    623  CE  LYS A  82      41.445  27.593  84.734  1.00 24.79           C  
ATOM    624  NZ  LYS A  82      42.405  28.016  85.795  1.00 28.64           N  
ATOM    625  N   VAL A  83      38.942  31.922  87.934  1.00 10.89           N  
ATOM    626  CA  VAL A  83      39.284  31.935  89.350  1.00  9.67           C  
ATOM    627  C   VAL A  83      38.029  32.162  90.194  1.00  9.88           C  
ATOM    628  O   VAL A  83      37.849  31.519  91.226  1.00  9.86           O  
ATOM    629  CB  VAL A  83      40.344  33.012  89.654  1.00 10.69           C  
ATOM    630  CG1 VAL A  83      40.618  33.074  91.147  1.00 11.88           C  
ATOM    631  CG2 VAL A  83      41.630  32.686  88.906  1.00 12.56           C  
ATOM    632  N   LEU A  84      37.152  33.058  89.749  1.00  8.69           N  
ATOM    633  CA  LEU A  84      35.915  33.319  90.477  1.00 10.21           C  
ATOM    634  C   LEU A  84      35.069  32.058  90.562  1.00 10.55           C  
ATOM    635  O   LEU A  84      34.474  31.770  91.594  1.00 11.26           O  
ATOM    636  CB  LEU A  84      35.118  34.429  89.796  1.00  9.71           C  
ATOM    637  CG  LEU A  84      35.604  35.837  90.144  1.00 10.32           C  
ATOM    638  CD1 LEU A  84      35.087  36.838  89.125  1.00 12.61           C  
ATOM    639  CD2 LEU A  84      35.136  36.188  91.547  1.00 12.61           C  
ATOM    640  N   ALA A  85      35.018  31.300  89.471  1.00 11.36           N  
ATOM    641  CA  ALA A  85      34.241  30.066  89.462  1.00 11.70           C  
ATOM    642  C   ALA A  85      34.846  29.063  90.445  1.00 11.22           C  
ATOM    643  O   ALA A  85      34.126  28.314  91.104  1.00 12.55           O  
ATOM    644  CB  ALA A  85      34.209  29.479  88.054  1.00 14.17           C  
ATOM    645  N   ALA A  86      36.173  29.058  90.537  1.00 11.47           N  
ATOM    646  CA  ALA A  86      36.878  28.161  91.449  1.00 12.40           C  
ATOM    647  C   ALA A  86      36.556  28.524  92.900  1.00 11.68           C  
ATOM    648  O   ALA A  86      36.433  27.647  93.757  1.00 12.48           O  
ATOM    649  CB  ALA A  86      38.373  28.247  91.210  1.00 14.28           C  
ATOM    650  N   ILE A  87      36.426  29.820  93.174  1.00 11.69           N  
ATOM    651  CA  ILE A  87      36.094  30.279  94.519  1.00 10.34           C  
ATOM    652  C   ILE A  87      34.665  29.838  94.853  1.00 10.91           C  
ATOM    653  O   ILE A  87      34.388  29.375  95.960  1.00 11.33           O  
ATOM    654  CB  ILE A  87      36.218  31.827  94.623  1.00  8.96           C  
ATOM    655  CG1 ILE A  87      37.691  32.239  94.491  1.00 10.15           C  
ATOM    656  CG2 ILE A  87      35.647  32.321  95.954  1.00 10.42           C  
ATOM    657  CD1 ILE A  87      37.913  33.739  94.369  1.00  8.99           C  
ATOM    658  N   ASN A  88      33.764  29.975  93.883  1.00 10.86           N  
ATOM    659  CA  ASN A  88      32.368  29.579  94.064  1.00 11.92           C  
ATOM    660  C   ASN A  88      32.308  28.073  94.339  1.00 12.61           C  
ATOM    661  O   ASN A  88      31.567  27.618  95.212  1.00 13.16           O  
ATOM    662  CB  ASN A  88      31.567  29.914  92.798  1.00 13.37           C  
ATOM    663  CG  ASN A  88      30.063  29.932  93.030  1.00 14.05           C  
ATOM    664  OD1 ASN A  88      29.280  29.936  92.077  1.00 19.87           O  
ATOM    665  ND2 ASN A  88      29.652  29.960  94.287  1.00 14.96           N  
ATOM    666  N   GLU A  89      33.103  27.307  93.596  1.00 12.54           N  
ATOM    667  CA  GLU A  89      33.143  25.855  93.756  1.00 14.80           C  
ATOM    668  C   GLU A  89      33.630  25.486  95.147  1.00 15.42           C  
ATOM    669  O   GLU A  89      33.027  24.657  95.828  1.00 15.23           O  
ATOM    670  CB  GLU A  89      34.069  25.227  92.714  1.00 16.37           C  
ATOM    671  CG  GLU A  89      34.019  23.709  92.698  1.00 19.48           C  
ATOM    672  CD  GLU A  89      34.981  23.106  91.694  1.00 24.25           C  
ATOM    673  OE1 GLU A  89      34.991  23.563  90.531  1.00 25.78           O  
ATOM    674  OE2 GLU A  89      35.721  22.170  92.065  1.00 28.23           O  
ATOM    675  N   LEU A  90      34.735  26.098  95.561  1.00 14.68           N  
ATOM    676  CA  LEU A  90      35.298  25.830  96.875  1.00 15.20           C  
ATOM    677  C   LEU A  90      34.256  26.118  97.951  1.00 15.04           C  
ATOM    678  O   LEU A  90      34.138  25.377  98.927  1.00 16.78           O  
ATOM    679  CB  LEU A  90      36.540  26.699  97.093  1.00 15.70           C  
ATOM    680  CG  LEU A  90      37.343  26.488  98.382  1.00 16.31           C  
ATOM    681  CD1 LEU A  90      38.749  27.026  98.187  1.00 17.42           C  
ATOM    682  CD2 LEU A  90      36.658  27.170  99.553  1.00 18.28           C  
ATOM    683  N   ALA A  91      33.497  27.191  97.755  1.00 16.45           N  
ATOM    684  CA  ALA A  91      32.462  27.605  98.695  1.00 17.77           C  
ATOM    685  C   ALA A  91      31.282  26.638  98.740  1.00 20.57           C  
ATOM    686  O   ALA A  91      30.383  26.788  99.570  1.00 22.60           O  
ATOM    687  CB  ALA A  91      31.975  29.008  98.343  1.00 17.96           C  
ATOM    688  N   HIS A  92      31.286  25.652  97.846  1.00 21.33           N  
ATOM    689  CA  HIS A  92      30.216  24.659  97.800  1.00 24.89           C  
ATOM    690  C   HIS A  92      30.692  23.276  98.231  1.00 26.71           C  
ATOM    691  O   HIS A  92      29.883  22.365  98.418  1.00 27.79           O  
ATOM    692  CB  HIS A  92      29.618  24.570  96.393  1.00 25.74           C  
ATOM    693  CG  HIS A  92      28.697  25.700  96.054  1.00 27.01           C  
ATOM    694  ND1 HIS A  92      29.124  27.006  95.950  1.00 27.57           N  
ATOM    695  CD2 HIS A  92      27.369  25.718  95.790  1.00 27.46           C  
ATOM    696  CE1 HIS A  92      28.100  27.778  95.635  1.00 28.00           C  
ATOM    697  NE2 HIS A  92      27.023  27.022  95.532  1.00 28.38           N  
ATOM    698  N   SER A  93      32.004  23.121  98.384  1.00 28.81           N  
ATOM    699  CA  SER A  93      32.594  21.852  98.801  1.00 30.07           C  
ATOM    700  C   SER A  93      34.118  21.945  98.815  1.00 31.44           C  
ATOM    701  O   SER A  93      34.766  21.114  98.143  1.00 33.05           O  
ATOM    702  CB  SER A  93      32.147  20.730  97.868  1.00 30.26           C  
TER     703      SER A  93                                                      
END
MOLECULE T0496_4_122.pdb
ATOM      1  N   PRO     4      36.250  18.877 100.419  1.00126.33           N  
ATOM      2  CA  PRO     4      36.001  19.915  99.413  1.00124.51           C  
ATOM      3  C   PRO     4      37.048  21.022  99.469  1.00125.13           C  
ATOM      4  O   PRO     4      38.211  20.787  99.138  1.00127.61           O  
ATOM      5  CB  PRO     4      34.632  20.466  99.818  1.00125.32           C  
ATOM      6  CG  PRO     4      33.962  19.327 100.500  1.00121.87           C  
ATOM      7  CD  PRO     4      35.049  18.581 101.220  1.00130.35           C  
ATOM      8  N   VAL     5      36.635  22.214  99.886  1.00119.84           N  
ATOM      9  CA  VAL     5      37.466  23.415  99.734  1.00107.77           C  
ATOM     10  C   VAL     5      38.099  23.855 101.061  1.00100.94           C  
ATOM     11  O   VAL     5      37.438  23.869 102.102  1.00 94.89           O  
ATOM     12  CB  VAL     5      36.652  24.587  99.107  1.00107.75           C  
ATOM     13  CG1 VAL     5      37.577  25.679  98.576  1.00 88.65           C  
ATOM     14  CG2 VAL     5      35.760  24.081  97.980  1.00101.53           C  
ATOM     15  N   SER     6      39.384  24.211 101.004  1.00 99.68           N  
ATOM     16  CA  SER     6      40.148  24.635 102.180  1.00 91.17           C  
ATOM     17  C   SER     6      40.377  26.152 102.243  1.00 85.27           C  
ATOM     18  O   SER     6      40.045  26.881 101.305  1.00 80.81           O  
ATOM     19  CB  SER     6      41.485  23.887 102.244  1.00 92.89           C  
ATOM     20  OG  SER     6      42.256  24.108 101.075  1.00 94.88           O  
ATOM     21  N   VAL     7      40.955  26.603 103.357  1.00 77.69           N  
ATOM     22  CA  VAL     7      41.146  28.027 103.663  1.00 67.00           C  
ATOM     23  C   VAL     7      42.287  28.655 102.855  1.00 73.76           C  
ATOM     24  O   VAL     7      42.125  29.739 102.284  1.00 70.86           O  
ATOM     25  CB  VAL     7      41.386  28.239 105.189  1.00 56.84           C  
ATOM     26  CG1 VAL     7      41.504  29.720 105.535  1.00 44.52           C  
ATOM     27  CG2 VAL     7      40.260  27.609 105.996  1.00 60.50           C  
ATOM     28  N   ASN     8      43.429  27.964 102.811  1.00 79.15           N  
ATOM     29  CA  ASN     8      44.614  28.407 102.064  1.00 82.93           C  
ATOM     30  C   ASN     8      44.353  28.483 100.565  1.00 82.41           C  
ATOM     31  O   ASN     8      44.933  29.314  99.868  1.00 69.82           O  
ATOM     32  CB  ASN     8      45.797  27.466 102.313  1.00 88.19           C  
ATOM     33  CG  ASN     8      45.839  26.934 103.733  1.00114.21           C  
ATOM     34  OD1 ASN     8      46.100  27.681 104.683  1.00130.04           O  
ATOM     35  ND2 ASN     8      45.591  25.630 103.881  1.00130.36           N  
ATOM     36  N   GLU     9      43.480  27.595 100.092  1.00 83.32           N  
ATOM     37  CA  GLU     9      43.007  27.568  98.713  1.00 85.50           C  
ATOM     38  C   GLU     9      42.250  28.849  98.365  1.00 71.59           C  
ATOM     39  O   GLU     9      42.421  29.397  97.276  1.00 49.75           O  
ATOM     40  CB  GLU     9      42.100  26.354  98.514  1.00 91.21           C  
ATOM     41  CG  GLU     9      41.941  25.894  97.075  1.00105.16           C  
ATOM     42  CD  GLU     9      41.154  24.600  96.967  1.00104.81           C  
ATOM     43  OE1 GLU     9      41.478  23.634  97.694  1.00128.20           O  
ATOM     44  OE2 GLU     9      40.215  24.543  96.146  1.00128.75           O  
ATOM     45  N   LYS    10      41.422  29.316  99.301  1.00 64.67           N  
ATOM     46  CA  LYS    10      40.664  30.558  99.143  1.00 50.06           C  
ATOM     47  C   LYS    10      41.562  31.786  99.278  1.00 55.22           C  
ATOM     48  O   LYS    10      41.451  32.721  98.484  1.00 39.45           O  
ATOM     49  CB  LYS    10      39.520  30.630 100.159  1.00 46.21           C  
ATOM     50  CG  LYS    10      38.442  29.572  99.977  1.00 55.81           C  
ATOM     51  CD  LYS    10      37.454  29.599 101.131  1.00 24.13           C  
ATOM     52  CE  LYS    10      36.592  28.342 101.154  1.00 39.89           C  
ATOM     53  NZ  LYS    10      35.728  28.288 102.368  1.00 67.89           N  
ATOM     54  N   LYS    11      42.441  31.767 100.285  1.00 48.64           N  
ATOM     55  CA  LYS    11      43.408  32.842 100.546  1.00 45.25           C  
ATOM     56  C   LYS    11      44.308  33.122  99.349  1.00 49.17           C  
ATOM     57  O   LYS    11      44.501  34.277  98.962  1.00 43.86           O  
ATOM     58  CB  LYS    11      44.301  32.484 101.735  1.00 39.85           C  
ATOM     59  CG  LYS    11      43.695  32.691 103.103  1.00 57.76           C  
ATOM     60  CD  LYS    11      44.805  32.720 104.140  1.00  5.48           C  
ATOM     61  CE  LYS    11      44.286  32.363 105.520  1.00 66.84           C  
ATOM     62  NZ  LYS    11      45.381  32.369 106.532  1.00 74.77           N  
ATOM     63  N   ASP    12      44.853  32.051  98.775  1.00 52.53           N  
ATOM     64  CA  ASP    12      45.754  32.147  97.633  1.00 66.79           C  
ATOM     65  C   ASP    12      45.012  32.497  96.345  1.00 62.97           C  
ATOM     66  O   ASP    12      45.597  33.094  95.440  1.00 55.08           O  
ATOM     67  CB  ASP    12      46.544  30.850  97.456  1.00 73.82           C  
ATOM     68  CG  ASP    12      47.718  31.008  96.517  1.00102.22           C  
ATOM     69  OD1 ASP    12      47.613  30.542  95.362  1.00130.59           O  
ATOM     70  OD2 ASP    12      48.736  31.612  96.923  1.00119.67           O  
ATOM     71  N   PHE    13      43.734  32.119  96.267  1.00 66.99           N  
ATOM     72  CA  PHE    13      42.888  32.486  95.130  1.00 56.84           C  
ATOM     73  C   PHE    13      42.672  33.996  95.059  1.00 54.17           C  
ATOM     74  O   PHE    13      42.798  34.584  93.985  1.00 38.21           O  
ATOM     75  CB  PHE    13      41.537  31.755  95.161  1.00 35.95           C  
ATOM     76  CG  PHE    13      40.511  32.338  94.224  1.00 61.09           C  
ATOM     77  CD1 PHE    13      40.651  32.202  92.844  1.00 70.08           C  
ATOM     78  CD2 PHE    13      39.413  33.037  94.720  1.00 81.31           C  
ATOM     79  CE1 PHE    13      39.715  32.753  91.977  1.00 61.10           C  
ATOM     80  CE2 PHE    13      38.471  33.588  93.858  1.00 74.91           C  
ATOM     81  CZ  PHE    13      38.622  33.444  92.486  1.00 61.44           C  
ATOM     82  N   VAL    14      42.344  34.606  96.199  1.00 49.01           N  
ATOM     83  CA  VAL    14      42.154  36.059  96.301  1.00 48.53           C  
ATOM     84  C   VAL    14      43.472  36.787  96.023  1.00 51.26           C  
ATOM     85  O   VAL    14      43.491  37.814  95.335  1.00 35.61           O  
ATOM     86  CB  VAL    14      41.587  36.474  97.689  1.00 49.32           C  
ATOM     87  CG1 VAL    14      41.388  37.982  97.783  1.00 40.40           C  
ATOM     88  CG2 VAL    14      40.276  35.779  97.958  1.00 45.96           C  
ATOM     89  N   LYS    15      44.565  36.228  96.546  1.00 53.00           N  
ATOM     90  CA  LYS    15      45.920  36.723  96.294  1.00 57.32           C  
ATOM     91  C   LYS    15      46.273  36.674  94.803  1.00 57.75           C  
ATOM     92  O   LYS    15      46.907  37.596  94.283  1.00 61.78           O  
ATOM     93  CB  LYS    15      46.940  35.919  97.110  1.00 54.99           C  
ATOM     94  CG  LYS    15      48.342  36.520  97.148  1.00 70.96           C  
ATOM     95  CD  LYS    15      49.350  35.544  97.737  1.00 94.48           C  
ATOM     96  CE  LYS    15      50.767  36.092  97.648  1.00102.05           C  
ATOM     97  NZ  LYS    15      51.775  35.124  98.168  1.00 93.67           N  
ATOM     98  N   TRP    16      45.853  35.603  94.126  1.00 58.07           N  
ATOM     99  CA  TRP    16      46.032  35.474  92.679  1.00 64.97           C  
ATOM    100  C   TRP    16      45.142  36.446  91.907  1.00 55.53           C  
ATOM    101  O   TRP    16      45.617  37.138  91.003  1.00 49.84           O  
ATOM    102  CB  TRP    16      45.759  34.038  92.213  1.00 77.49           C  
ATOM    103  CG  TRP    16      45.646  33.907  90.716  1.00 93.75           C  
ATOM    104  CD1 TRP    16      46.675  33.872  89.818  1.00 94.66           C  
ATOM    105  CD2 TRP    16      44.438  33.804  89.946  1.00110.74           C  
ATOM    106  NE1 TRP    16      46.186  33.752  88.539  1.00 85.41           N  
ATOM    107  CE2 TRP    16      44.817  33.709  88.588  1.00106.09           C  
ATOM    108  CE3 TRP    16      43.073  33.788  90.272  1.00108.96           C  
ATOM    109  CZ2 TRP    16      43.882  33.593  87.554  1.00 92.48           C  
ATOM    110  CZ3 TRP    16      42.143  33.670  89.243  1.00 88.27           C  
ATOM    111  CH2 TRP    16      42.554  33.575  87.900  1.00 91.46           C  
ATOM    112  N   PHE    17      43.857  36.477  92.268  1.00 52.15           N  
ATOM    113  CA  PHE    17      42.840  37.278  91.577  1.00 46.03           C  
ATOM    114  C   PHE    17      43.159  38.772  91.558  1.00 45.00           C  
ATOM    115  O   PHE    17      43.011  39.429  90.525  1.00 39.80           O  
ATOM    116  CB  PHE    17      41.450  37.032  92.190  1.00 37.75           C  
ATOM    117  CG  PHE    17      40.401  38.012  91.736  1.00 44.98           C  
ATOM    118  CD1 PHE    17      39.874  37.940  90.451  1.00 34.59           C  
ATOM    119  CD2 PHE    17      39.940  39.008  92.595  1.00 52.39           C  
ATOM    120  CE1 PHE    17      38.912  38.849  90.024  1.00 36.78           C  
ATOM    121  CE2 PHE    17      38.978  39.920  92.176  1.00 46.87           C  
ATOM    122  CZ  PHE    17      38.461  39.839  90.888  1.00 46.11           C  
ATOM    123  N   LEU    18      43.600  39.292  92.702  1.00 48.42           N  
ATOM    124  CA  LEU    18      43.920  40.713  92.846  1.00 54.75           C  
ATOM    125  C   LEU    18      45.206  41.112  92.125  1.00 64.57           C  
ATOM    126  O   LEU    18      45.377  42.274  91.748  1.00 70.78           O  
ATOM    127  CB  LEU    18      44.001  41.100  94.327  1.00 53.04           C  
ATOM    128  CG  LEU    18      42.683  41.160  95.107  1.00 47.69           C  
ATOM    129  CD1 LEU    18      42.960  41.302  96.595  1.00 23.90           C  
ATOM    130  CD2 LEU    18      41.809  42.310  94.614  1.00 37.79           C  
ATOM    131  N   ASN    19      46.100  40.145  91.934  1.00 71.72           N  
ATOM    132  CA  ASN    19      47.373  40.376  91.254  1.00 74.85           C  
ATOM    133  C   ASN    19      47.278  40.265  89.729  1.00 67.96           C  
ATOM    134  O   ASN    19      48.226  40.604  89.015  1.00 75.30           O  
ATOM    135  CB  ASN    19      48.447  39.421  91.793  1.00 75.25           C  
ATOM    136  CG  ASN    19      49.049  39.894  93.110  1.00105.13           C  
ATOM    137  OD1 ASN    19      50.229  40.248  93.166  1.00124.46           O  
ATOM    138  ND2 ASN    19      48.242  39.905  94.174  1.00113.30           N  
ATOM    139  N   ASN    20      46.130  39.801  89.239  1.00 68.40           N  
ATOM    140  CA  ASN    20      45.927  39.568  87.810  1.00 67.61           C  
ATOM    141  C   ASN    20      44.795  40.397  87.201  1.00 72.51           C  
ATOM    142  O   ASN    20      44.790  40.656  85.994  1.00 70.43           O  
ATOM    143  CB  ASN    20      45.693  38.077  87.538  1.00 59.20           C  
ATOM    144  CG  ASN    20      46.964  37.248  87.658  1.00 75.65           C  
ATOM    145  OD1 ASN    20      47.535  36.826  86.652  1.00101.51           O  
ATOM    146  ND2 ASN    20      47.412  37.011  88.887  1.00 92.03           N  
ATOM    147  N   TYR    21      43.845  40.809  88.038  1.00 72.03           N  
ATOM    148  CA  TYR    21      42.660  41.533  87.576  1.00 63.08           C  
ATOM    149  C   TYR    21      42.437  42.823  88.360  1.00 62.42           C  
ATOM    150  O   TYR    21      42.660  42.873  89.573  1.00 73.78           O  
ATOM    151  CB  TYR    21      41.415  40.639  87.653  1.00 66.80           C  
ATOM    152  CG  TYR    21      41.537  39.350  86.866  1.00 63.40           C  
ATOM    153  CD1 TYR    21      41.920  38.163  87.492  1.00 63.16           C  
ATOM    154  CD2 TYR    21      41.280  39.319  85.495  1.00 52.50           C  
ATOM    155  CE1 TYR    21      42.041  36.979  86.775  1.00 62.89           C  
ATOM    156  CE2 TYR    21      41.398  38.137  84.769  1.00 69.94           C  
ATOM    157  CZ  TYR    21      41.780  36.973  85.416  1.00 76.20           C  
ATOM    158  OH  TYR    21      41.898  35.800  84.708  1.00 81.40           O  
ATOM    159  N   GLN    22      41.995  43.861  87.653  1.00 51.11           N  
ATOM    160  CA  GLN    22      41.745  45.169  88.250  1.00 52.42           C  
ATOM    161  C   GLN    22      40.249  45.389  88.468  1.00 57.96           C  
ATOM    162  O   GLN    22      39.487  45.488  87.504  1.00 53.40           O  
ATOM    163  CB  GLN    22      42.336  46.276  87.365  1.00 47.18           C  
ATOM    164  CG  GLN    22      42.085  47.709  87.842  1.00 69.65           C  
ATOM    165  CD  GLN    22      43.001  48.131  88.978  1.00102.66           C  
ATOM    166  OE1 GLN    22      42.801  47.750  90.132  1.00106.07           O  
ATOM    167  NE2 GLN    22      44.004  48.940  88.656  1.00112.87           N  
ATOM    168  N   LEU    23      39.844  45.461  89.735  1.00 57.15           N  
ATOM    169  CA  LEU    23      38.442  45.683  90.103  1.00 50.60           C  
ATOM    170  C   LEU    23      37.989  47.107  89.782  1.00 48.31           C  
ATOM    171  O   LEU    23      38.782  48.049  89.859  1.00 46.36           O  
ATOM    172  CB  LEU    23      38.205  45.361  91.586  1.00 37.08           C  
ATOM    173  CG  LEU    23      38.211  43.888  92.022  1.00 29.17           C  
ATOM    174  CD1 LEU    23      38.286  43.767  93.536  1.00 27.93           C  
ATOM    175  CD2 LEU    23      36.996  43.131  91.492  1.00 49.92           C  
ATOM    176  N   LYS    24      36.715  47.242  89.409  1.00 42.88           N  
ATOM    177  CA  LYS    24      36.118  48.529  89.034  1.00 60.04           C  
ATOM    178  C   LYS    24      36.082  49.526  90.187  1.00 66.54           C  
ATOM    179  O   LYS    24      36.366  50.712  90.000  1.00 67.76           O  
ATOM    180  CB  LYS    24      34.702  48.329  88.489  1.00 60.30           C  
ATOM    181  CG  LYS    24      34.637  48.073  86.999  1.00 65.66           C  
ATOM    182  CD  LYS    24      33.203  47.933  86.519  1.00 74.26           C  
ATOM    183  CE  LYS    24      33.144  47.745  85.013  1.00 60.22           C  
ATOM    184  NZ  LYS    24      31.741  47.687  84.520  1.00 63.42           N  
ATOM    185  N   GLN    25      35.730  49.037  91.372  1.00 64.06           N  
ATOM    186  CA  GLN    25      35.673  49.873  92.562  1.00 54.75           C  
ATOM    187  C   GLN    25      36.805  49.501  93.519  1.00 55.82           C  
ATOM    188  O   GLN    25      37.046  48.321  93.786  1.00 55.35           O  
ATOM    189  CB  GLN    25      34.301  49.761  93.229  1.00 61.23           C  
ATOM    190  CG  GLN    25      33.994  50.859  94.234  1.00 68.73           C  
ATOM    191  CD  GLN    25      32.516  51.197  94.290  1.00 73.24           C  
ATOM    192  OE1 GLN    25      31.818  50.831  95.235  1.00103.95           O  
ATOM    193  NE2 GLN    25      32.030  51.896  93.268  1.00 97.79           N  
ATOM    194  N   ARG    26      37.491  50.529  94.014  1.00 40.57           N  
ATOM    195  CA  ARG    26      38.721  50.380  94.795  1.00 27.79           C  
ATOM    196  C   ARG    26      38.507  49.778  96.185  1.00 33.96           C  
ATOM    197  O   ARG    26      39.371  49.067  96.700  1.00 47.26           O  
ATOM    198  CB  ARG    26      39.425  51.735  94.905  1.00 25.04           C  
ATOM    199  CG  ARG    26      40.865  51.676  95.394  1.00 27.91           C  
ATOM    200  CD  ARG    26      41.569  53.000  95.184  1.00 53.62           C  
ATOM    201  NE  ARG    26      40.876  54.113  95.832  1.00 72.82           N  
ATOM    202  CZ  ARG    26      41.003  55.383  95.462  1.00 63.56           C  
ATOM    203  NH1 ARG    26      41.793  55.698  94.445  1.00 19.76           N  
ATOM    204  NH2 ARG    26      40.339  56.336  96.103  1.00 56.62           N  
ATOM    205  N   GLU    27      37.352  50.059  96.782  1.00 24.81           N  
ATOM    206  CA  GLU    27      37.032  49.564  98.126  1.00 28.34           C  
ATOM    207  C   GLU    27      36.711  48.069  98.165  1.00 20.31           C  
ATOM    208  O   GLU    27      36.733  47.457  99.232  1.00  8.99           O  
ATOM    209  CB  GLU    27      35.923  50.398  98.793  1.00 15.34           C  
ATOM    210  CG  GLU    27      35.043  51.220  97.848  1.00 60.22           C  
ATOM    211  CD  GLU    27      35.609  52.602  97.542  1.00 74.48           C  
ATOM    212  OE1 GLU    27      35.664  52.969  96.349  1.00 78.12           O  
ATOM    213  OE2 GLU    27      36.002  53.317  98.489  1.00 62.62           O  
ATOM    214  N   CYS    28      36.439  47.490  96.996  1.00  3.93           N  
ATOM    215  CA  CYS    28      36.234  46.049  96.841  1.00 36.87           C  
ATOM    216  C   CYS    28      37.543  45.272  96.980  1.00 39.48           C  
ATOM    217  O   CYS    28      37.543  44.112  97.402  1.00 40.62           O  
ATOM    218  CB  CYS    28      35.604  45.752  95.483  1.00 32.52           C  
ATOM    219  SG  CYS    28      34.088  46.672  95.157  1.00 64.11           S  
ATOM    220  N   VAL    29      38.647  45.920  96.603  1.00 26.07           N  
ATOM    221  CA  VAL    29      40.000  45.398  96.811  1.00 33.41           C  
ATOM    222  C   VAL    29      40.289  45.353  98.313  1.00 40.89           C  
ATOM    223  O   VAL    29      40.858  44.381  98.816  1.00 29.88           O  
ATOM    224  CB  VAL    29      41.071  46.276  96.090  1.00 18.96           C  
ATOM    225  CG1 VAL    29      42.470  45.681  96.219  1.00 42.64           C  
ATOM    226  CG2 VAL    29      40.717  46.479  94.621  1.00 12.99           C  
ATOM    227  N   TRP    30      39.866  46.402  99.018  1.00 35.56           N  
ATOM    228  CA  TRP    30      40.076  46.520 100.461  1.00 28.30           C  
ATOM    229  C   TRP    30      39.164  45.602 101.267  1.00 34.00           C  
ATOM    230  O   TRP    30      39.520  45.204 102.376  1.00 24.65           O  
ATOM    231  CB  TRP    30      39.916  47.971 100.929  1.00 19.25           C  
ATOM    232  CG  TRP    30      40.816  48.950 100.224  1.00 39.94           C  
ATOM    233  CD1 TRP    30      42.044  48.696  99.675  1.00 32.48           C  
ATOM    234  CD2 TRP    30      40.568  50.347 100.017  1.00 35.28           C  
ATOM    235  NE1 TRP    30      42.563  49.839  99.122  1.00 33.05           N  
ATOM    236  CE2 TRP    30      41.683  50.870  99.323  1.00 36.64           C  
ATOM    237  CE3 TRP    30      39.512  51.207 100.348  1.00  9.12           C  
ATOM    238  CZ2 TRP    30      41.772  52.215  98.952  1.00 32.40           C  
ATOM    239  CZ3 TRP    30      39.600  52.546  99.976  1.00 19.31           C  
ATOM    240  CH2 TRP    30      40.723  53.035  99.285  1.00 42.28           C  
ATOM    241  N   ILE    31      37.991  45.286 100.712  1.00 32.16           N  
ATOM    242  CA  ILE    31      37.098  44.271 101.279  1.00 29.88           C  
ATOM    243  C   ILE    31      37.771  42.895 101.188  1.00 29.23           C  
ATOM    244  O   ILE    31      37.806  42.149 102.170  1.00 29.23           O  
ATOM    245  CB  ILE    31      35.701  44.267 100.576  1.00 37.41           C  
ATOM    246  CG1 ILE    31      34.868  45.475 101.018  1.00 31.27           C  
ATOM    247  CG2 ILE    31      34.924  42.980 100.874  1.00  2.00           C  
ATOM    248  CD1 ILE    31      33.747  45.854 100.060  1.00 38.02           C  
ATOM    249  N   LEU    32      38.329  42.591 100.015  1.00 36.37           N  
ATOM    250  CA  LEU    32      39.024  41.323  99.766  1.00 28.05           C  
ATOM    251  C   LEU    32      40.318  41.163 100.564  1.00 32.19           C  
ATOM    252  O   LEU    32      40.619  40.065 101.043  1.00 25.56           O  
ATOM    253  CB  LEU    32      39.316  41.145  98.272  1.00 11.59           C  
ATOM    254  CG  LEU    32      38.190  40.639  97.368  1.00 40.82           C  
ATOM    255  CD1 LEU    32      38.606  40.702  95.907  1.00 31.11           C  
ATOM    256  CD2 LEU    32      37.744  39.224  97.735  1.00 16.32           C  
ATOM    257  N   ASN    33      41.076  42.253 100.694  1.00 33.88           N  
ATOM    258  CA  ASN    33      42.309  42.269 101.487  1.00 41.02           C  
ATOM    259  C   ASN    33      42.045  42.119 102.982  1.00 48.35           C  
ATOM    260  O   ASN    33      42.861  41.544 103.708  1.00 42.87           O  
ATOM    261  CB  ASN    33      43.105  43.553 101.236  1.00 38.12           C  
ATOM    262  CG  ASN    33      43.837  43.545  99.906  1.00 28.78           C  
ATOM    263  OD1 ASN    33      44.367  42.520  99.475  1.00 60.55           O  
ATOM    264  ND2 ASN    33      43.887  44.702  99.258  1.00 57.45           N  
ATOM    265  N   TYR    34      40.908  42.656 103.427  1.00 42.24           N  
ATOM    266  CA  TYR    34      40.432  42.500 104.800  1.00 36.83           C  
ATOM    267  C   TYR    34      40.098  41.038 105.079  1.00 23.18           C  
ATOM    268  O   TYR    34      40.462  40.503 106.126  1.00 16.66           O  
ATOM    269  CB  TYR    34      39.197  43.378 105.027  1.00 41.90           C  
ATOM    270  CG  TYR    34      38.520  43.229 106.374  1.00 22.34           C  
ATOM    271  CD1 TYR    34      38.973  43.939 107.484  1.00 28.54           C  
ATOM    272  CD2 TYR    34      37.408  42.398 106.533  1.00 27.86           C  
ATOM    273  CE1 TYR    34      38.350  43.812 108.720  1.00  4.43           C  
ATOM    274  CE2 TYR    34      36.781  42.262 107.766  1.00 43.11           C  
ATOM    275  CZ  TYR    34      37.257  42.972 108.855  1.00 35.09           C  
ATOM    276  OH  TYR    34      36.639  42.845 110.078  1.00 54.06           O  
ATOM    277  N   LEU    35      39.403  40.407 104.134  1.00 24.05           N  
ATOM    278  CA  LEU    35      38.988  39.012 104.264  1.00 40.94           C  
ATOM    279  C   LEU    35      40.166  38.045 104.184  1.00 38.13           C  
ATOM    280  O   LEU    35      40.156  37.005 104.841  1.00 37.34           O  
ATOM    281  CB  LEU    35      37.922  38.662 103.220  1.00 42.89           C  
ATOM    282  CG  LEU    35      36.547  39.306 103.438  1.00 42.92           C  
ATOM    283  CD1 LEU    35      35.752  39.347 102.143  1.00 49.87           C  
ATOM    284  CD2 LEU    35      35.763  38.605 104.543  1.00 59.35           C  
ATOM    285  N   MET    36      41.175  38.399 103.385  1.00 34.40           N  
ATOM    286  CA  MET    36      42.427  37.636 103.305  1.00 46.16           C  
ATOM    287  C   MET    36      43.219  37.656 104.610  1.00 50.13           C  
ATOM    288  O   MET    36      43.874  36.672 104.960  1.00 60.87           O  
ATOM    289  CB  MET    36      43.315  38.160 102.175  1.00 42.82           C  
ATOM    290  CG  MET    36      43.368  37.261 100.955  1.00 48.71           C  
ATOM    291  SD  MET    36      44.881  37.467  99.986  1.00 60.10           S  
ATOM    292  CE  MET    36      44.640  39.097  99.278  1.00 16.43           C  
ATOM    293  N   SER    37      43.153  38.781 105.317  1.00 42.11           N  
ATOM    294  CA  SER    37      43.859  38.960 106.582  1.00 36.76           C  
ATOM    295  C   SER    37      43.206  38.197 107.734  1.00 37.15           C  
ATOM    296  O   SER    37      43.880  37.823 108.697  1.00 53.92           O  
ATOM    297  CB  SER    37      43.943  40.445 106.928  1.00 18.16           C  
ATOM    298  OG  SER    37      44.692  40.659 108.113  1.00 32.55           O  
ATOM    299  N   HIS    38      41.899  37.971 107.629  1.00 44.07           N  
ATOM    300  CA  HIS    38      41.138  37.305 108.681  1.00 38.86           C  
ATOM    301  C   HIS    38      40.825  35.861 108.290  1.00 42.18           C  
ATOM    302  O   HIS    38      39.936  35.604 107.473  1.00 55.60           O  
ATOM    303  CB  HIS    38      39.861  38.094 108.994  1.00 26.86           C  
ATOM    304  CG  HIS    38      40.118  39.468 109.535  1.00 33.91           C  
ATOM    305  ND1 HIS    38      40.550  40.511 108.745  1.00 26.80           N  
ATOM    306  CD2 HIS    38      40.005  39.969 110.788  1.00 16.28           C  
ATOM    307  CE1 HIS    38      40.698  41.592 109.488  1.00 39.50           C  
ATOM    308  NE2 HIS    38      40.369  41.292 110.731  1.00 34.08           N  
ATOM    309  N   ASP    39      41.570  34.926 108.877  1.00 42.22           N  
ATOM    310  CA  ASP    39      41.487  33.505 108.508  1.00 57.50           C  
ATOM    311  C   ASP    39      40.239  32.755 108.989  1.00 50.55           C  
ATOM    312  O   ASP    39      39.903  31.705 108.434  1.00 54.74           O  
ATOM    313  CB  ASP    39      42.773  32.732 108.877  1.00 58.09           C  
ATOM    314  CG  ASP    39      43.669  33.483 109.855  1.00101.47           C  
ATOM    315  OD1 ASP    39      44.908  33.492 109.630  1.00113.01           O  
ATOM    316  OD2 ASP    39      43.151  34.059 110.842  1.00137.21           O  
ATOM    317  N   GLN    40      39.555  33.273 110.007  1.00 52.26           N  
ATOM    318  CA  GLN    40      38.258  32.696 110.392  1.00 59.48           C  
ATOM    319  C   GLN    40      37.060  33.448 109.802  1.00 61.27           C  
ATOM    320  O   GLN    40      35.904  33.139 110.110  1.00 51.95           O  
ATOM    321  CB  GLN    40      38.134  32.455 111.912  1.00 52.01           C  
ATOM    322  CG  GLN    40      38.868  33.458 112.809  1.00 76.20           C  
ATOM    323  CD  GLN    40      39.624  32.719 113.944  1.00 91.61           C  
ATOM    324  OE1 GLN    40      40.507  33.294 114.589  1.00 83.79           O  
ATOM    325  NE2 GLN    40      39.287  31.442 114.185  1.00106.56           N  
ATOM    326  N   LEU    41      37.353  34.431 108.953  1.00 66.52           N  
ATOM    327  CA  LEU    41      36.367  34.944 108.006  1.00 67.80           C  
ATOM    328  C   LEU    41      36.392  34.058 106.766  1.00 70.55           C  
ATOM    329  O   LEU    41      35.342  33.755 106.197  1.00 75.93           O  
ATOM    330  CB  LEU    41      36.654  36.403 107.621  1.00 78.53           C  
ATOM    331  CG  LEU    41      35.895  37.555 108.301  1.00 73.60           C  
ATOM    332  CD1 LEU    41      34.390  37.484 108.038  1.00 46.01           C  
ATOM    333  CD2 LEU    41      36.183  37.616 109.797  1.00 73.23           C  
ATOM    334  N   MET    42      37.595  33.627 106.378  1.00 56.00           N  
ATOM    335  CA  MET    42      37.808  32.775 105.199  1.00 57.81           C  
ATOM    336  C   MET    42      37.240  31.360 105.324  1.00 69.74           C  
ATOM    337  O   MET    42      37.038  30.683 104.313  1.00 74.92           O  
ATOM    338  CB  MET    42      39.293  32.719 104.825  1.00 48.73           C  
ATOM    339  CG  MET    42      39.756  33.857 103.932  1.00 26.11           C  
ATOM    340  SD  MET    42      38.932  33.896 102.326  1.00 46.81           S  
ATOM    341  CE  MET    42      39.502  35.472 101.695  1.00 20.11           C  
ATOM    342  N   HIS    43      37.006  30.916 106.560  1.00 77.46           N  
ATOM    343  CA  HIS    43      36.227  29.708 106.828  1.00 81.40           C  
ATOM    344  C   HIS    43      34.802  29.904 106.332  1.00 77.35           C  
ATOM    345  O   HIS    43      34.234  29.036 105.665  1.00 81.45           O  
ATOM    346  CB  HIS    43      36.169  29.422 108.331  1.00 92.98           C  
ATOM    347  CG  HIS    43      37.329  28.635 108.852  1.00115.47           C  
ATOM    348  ND1 HIS    43      38.190  29.129 109.810  1.00123.92           N  
ATOM    349  CD2 HIS    43      37.760  27.384 108.565  1.00132.13           C  
ATOM    350  CE1 HIS    43      39.108  28.220 110.081  1.00129.28           C  
ATOM    351  NE2 HIS    43      38.871  27.152 109.340  1.00131.76           N  
ATOM    352  N   LYS    44      34.243  31.066 106.666  1.00 73.33           N  
ATOM    353  CA  LYS    44      32.857  31.404 106.366  1.00 61.04           C  
ATOM    354  C   LYS    44      32.678  32.023 104.976  1.00 57.30           C  
ATOM    355  O   LYS    44      31.551  32.189 104.508  1.00 69.14           O  
ATOM    356  CB  LYS    44      32.298  32.335 107.448  1.00 58.50           C  
ATOM    357  CG  LYS    44      32.146  31.683 108.818  1.00 46.12           C  
ATOM    358  CD  LYS    44      31.729  32.697 109.876  1.00 62.71           C  
ATOM    359  CE  LYS    44      31.584  32.047 111.249  1.00 86.47           C  
ATOM    360  NZ  LYS    44      32.894  31.607 111.823  1.00104.81           N  
ATOM    361  N   VAL    45      33.789  32.365 104.325  1.00 47.83           N  
ATOM    362  CA  VAL    45      33.767  32.889 102.957  1.00 54.28           C  
ATOM    363  C   VAL    45      33.536  31.748 101.963  1.00 57.64           C  
ATOM    364  O   VAL    45      34.229  30.726 102.003  1.00 64.15           O  
ATOM    365  CB  VAL    45      35.068  33.693 102.629  1.00 44.32           C  
ATOM    366  CG1 VAL    45      35.346  33.757 101.125  1.00 51.43           C  
ATOM    367  CG2 VAL    45      34.979  35.101 103.199  1.00 59.36           C  
ATOM    368  N   HIS    46      32.541  31.921 101.094  1.00 52.06           N  
ATOM    369  CA  HIS    46      32.242  30.946 100.051  1.00 44.49           C  
ATOM    370  C   HIS    46      32.204  31.604  98.678  1.00 53.29           C  
ATOM    371  O   HIS    46      31.514  32.606  98.478  1.00 65.04           O  
ATOM    372  CB  HIS    46      30.912  30.242 100.331  1.00 36.82           C  
ATOM    373  CG  HIS    46      30.851  29.573 101.668  1.00 36.12           C  
ATOM    374  ND1 HIS    46      31.564  28.430 101.960  1.00 72.73           N  
ATOM    375  CD2 HIS    46      30.161  29.883 102.791  1.00 67.78           C  
ATOM    376  CE1 HIS    46      31.318  28.067 103.206  1.00 76.73           C  
ATOM    377  NE2 HIS    46      30.470  28.932 103.733  1.00 68.01           N  
ATOM    378  N   PHE    47      32.956  31.037  97.738  1.00 56.48           N  
ATOM    379  CA  PHE    47      32.956  31.526  96.363  1.00 61.28           C  
ATOM    380  C   PHE    47      31.879  30.823  95.549  1.00 58.84           C  
ATOM    381  O   PHE    47      31.816  29.594  95.506  1.00 62.21           O  
ATOM    382  CB  PHE    47      34.349  31.429  95.740  1.00 65.70           C  
ATOM    383  CG  PHE    47      35.332  32.390  96.345  1.00 59.38           C  
ATOM    384  CD1 PHE    47      36.184  31.983  97.368  1.00 64.32           C  
ATOM    385  CD2 PHE    47      35.381  33.715  95.919  1.00 51.39           C  
ATOM    386  CE1 PHE    47      37.083  32.874  97.941  1.00 82.12           C  
ATOM    387  CE2 PHE    47      36.275  34.611  96.490  1.00 40.37           C  
ATOM    388  CZ  PHE    47      37.125  34.189  97.501  1.00 63.01           C  
ATOM    389  N   VAL    48      31.027  31.628  94.918  1.00 55.73           N  
ATOM    390  CA  VAL    48      29.686  31.201  94.521  1.00 48.33           C  
ATOM    391  C   VAL    48      29.289  31.869  93.194  1.00 46.26           C  
ATOM    392  O   VAL    48      29.760  32.964  92.892  1.00 54.94           O  
ATOM    393  CB  VAL    48      28.691  31.499  95.719  1.00 51.09           C  
ATOM    394  CG1 VAL    48      27.323  32.038  95.289  1.00 66.36           C  
ATOM    395  CG2 VAL    48      28.538  30.277  96.614  1.00 25.83           C  
ATOM    396  N   GLU    49      28.443  31.203  92.407  0.50 40.44           N  
ATOM    398  CA  GLU    49      27.781  31.851  91.274  0.50 38.59           C  
ATOM    400  C   GLU    49      26.316  32.151  91.594  0.50 38.61           C  
ATOM    402  O   GLU    49      25.588  31.292  92.094  0.50 23.18           O  
ATOM    404  CB  GLU    49      27.906  31.014  89.999  0.50 39.79           C  
ATOM    406  CG  GLU    49      29.260  31.147  89.313  0.50 32.47           C  
ATOM    408  CD  GLU    49      29.242  30.675  87.871  0.50 47.37           C  
ATOM    410  OE1 GLU    49      28.857  29.512  87.621  0.50 67.13           O  
ATOM    412  OE2 GLU    49      29.625  31.468  86.984  0.50 41.08           O  
ATOM    414  N   HIS    50      25.893  33.378  91.305  0.50 35.51           N  
ATOM    416  CA  HIS    50      24.555  33.838  91.665  0.50 37.04           C  
ATOM    418  C   HIS    50      24.477  34.066  93.175  0.50 39.05           C  
ATOM    420  O   HIS    50      23.753  33.370  93.889  0.50 45.49           O  
ATOM    422  CB  HIS    50      23.483  32.836  91.220  0.50 33.33           C  
ATOM    424  CG  HIS    50      23.660  32.328  89.823  0.50 30.55           C  
ATOM    426  ND1 HIS    50      23.963  31.012  89.545  0.50 43.39           N  
ATOM    428  CD2 HIS    50      23.575  32.956  88.625  0.50 24.25           C  
ATOM    430  CE1 HIS    50      24.057  30.850  88.238  0.50 47.64           C  
ATOM    432  NE2 HIS    50      23.826  32.015  87.656  0.50 42.44           N  
ATOM    434  N   ALA    51      25.227  35.053  93.655  0.50 45.35           N  
ATOM    436  CA  ALA    51      25.294  35.347  95.086  0.50 48.89           C  
ATOM    438  C   ALA    51      24.154  36.246  95.576  0.50 51.83           C  
ATOM    440  O   ALA    51      24.079  36.574  96.762  0.50 53.16           O  
ATOM    442  CB  ALA    51      26.649  35.958  95.435  0.50 49.32           C  
ATOM    444  N   LYS    52      23.264  36.625  94.660  1.00 58.57           N  
ATOM    445  CA  LYS    52      22.124  37.506  94.966  1.00 54.64           C  
ATOM    446  C   LYS    52      21.017  36.826  95.781  1.00 46.90           C  
ATOM    447  O   LYS    52      20.208  37.496  96.427  1.00 46.97           O  
ATOM    448  CB  LYS    52      21.546  38.104  93.674  1.00 44.05           C  
ATOM    449  CG  LYS    52      21.045  37.074  92.661  1.00 66.73           C  
ATOM    450  CD  LYS    52      20.582  37.740  91.380  1.00 82.91           C  
ATOM    451  CE  LYS    52      19.977  36.734  90.415  1.00 97.19           C  
ATOM    452  NZ  LYS    52      19.523  37.389  89.153  1.00115.97           N  
ATOM    453  N   TYR    53      21.001  35.495  95.745  1.00 37.98           N  
ATOM    454  CA  TYR    53      20.046  34.682  96.491  1.00 37.72           C  
ATOM    455  C   TYR    53      20.497  34.436  97.934  1.00 45.31           C  
ATOM    456  O   TYR    53      19.725  33.933  98.754  1.00 54.77           O  
ATOM    457  CB  TYR    53      19.845  33.337  95.786  1.00 46.24           C  
ATOM    458  CG  TYR    53      19.406  33.437  94.341  1.00 72.72           C  
ATOM    459  CD1 TYR    53      18.073  33.684  94.014  1.00 81.57           C  
ATOM    460  CD2 TYR    53      20.320  33.270  93.300  1.00 82.33           C  
ATOM    461  CE1 TYR    53      17.662  33.773  92.688  1.00 71.14           C  
ATOM    462  CE2 TYR    53      19.918  33.357  91.970  1.00 86.46           C  
ATOM    463  CZ  TYR    53      18.588  33.608  91.672  1.00 63.48           C  
ATOM    464  OH  TYR    53      18.186  33.695  90.359  1.00 81.98           O  
ATOM    465  N   CYS    54      21.742  34.800  98.236  1.00 49.67           N  
ATOM    466  CA  CYS    54      22.366  34.482  99.519  1.00 56.54           C  
ATOM    467  C   CYS    54      22.061  35.511 100.615  1.00 60.03           C  
ATOM    468  O   CYS    54      21.984  36.708 100.328  1.00 67.34           O  
ATOM    469  CB  CYS    54      23.878  34.329  99.335  1.00 51.50           C  
ATOM    470  SG  CYS    54      24.343  33.106  98.085  1.00 97.57           S  
ATOM    471  N   PRO    55      21.869  35.038 101.870  1.00 58.20           N  
ATOM    472  CA  PRO    55      21.696  35.838 103.093  1.00 59.98           C  
ATOM    473  C   PRO    55      22.735  36.943 103.312  1.00 67.06           C  
ATOM    474  O   PRO    55      22.407  37.977 103.897  1.00 85.49           O  
ATOM    475  CB  PRO    55      21.791  34.793 104.223  1.00 66.59           C  
ATOM    476  CG  PRO    55      22.246  33.520 103.566  1.00 67.66           C  
ATOM    477  CD  PRO    55      21.746  33.602 102.171  1.00 69.20           C  
ATOM    478  N   ARG    56      23.968  36.722 102.861  1.00 48.08           N  
ATOM    479  CA  ARG    56      24.998  37.754 102.905  1.00 42.87           C  
ATOM    480  C   ARG    56      25.850  37.682 101.637  1.00 45.44           C  
ATOM    481  O   ARG    56      26.996  37.221 101.659  1.00 49.24           O  
ATOM    482  CB  ARG    56      25.839  37.621 104.175  1.00 49.88           C  
ATOM    483  CG  ARG    56      26.133  38.946 104.852  1.00 18.97           C  
ATOM    484  CD  ARG    56      26.176  38.798 106.364  1.00 24.76           C  
ATOM    485  NE  ARG    56      27.468  38.313 106.845  1.00 40.44           N  
ATOM    486  CZ  ARG    56      28.460  39.097 107.256  1.00 53.66           C  
ATOM    487  NH1 ARG    56      28.323  40.416 107.240  1.00 58.73           N  
ATOM    488  NH2 ARG    56      29.596  38.562 107.684  1.00 45.76           N  
ATOM    489  N   GLY    57      25.264  38.142 100.534  1.00 45.31           N  
ATOM    490  CA  GLY    57      25.861  38.009  99.209  1.00 39.80           C  
ATOM    491  C   GLY    57      26.650  39.214  98.741  1.00 40.11           C  
ATOM    492  O   GLY    57      26.211  40.353  98.890  1.00 39.59           O  
ATOM    493  N   LEU    58      27.814  38.943  98.156  1.00 34.25           N  
ATOM    494  CA  LEU    58      28.733  39.975  97.700  1.00 24.42           C  
ATOM    495  C   LEU    58      29.002  39.793  96.207  1.00 27.60           C  
ATOM    496  O   LEU    58      29.446  38.728  95.774  1.00 43.01           O  
ATOM    497  CB  LEU    58      30.037  39.878  98.501  1.00 39.75           C  
ATOM    498  CG  LEU    58      30.890  41.113  98.805  1.00 23.91           C  
ATOM    499  CD1 LEU    58      30.151  42.118  99.666  1.00 58.63           C  
ATOM    500  CD2 LEU    58      32.169  40.683  99.500  1.00 14.12           C  
ATOM    501  N   VAL    59      28.705  40.826  95.420  1.00 32.14           N  
ATOM    502  CA  VAL    59      28.933  40.795  93.972  1.00 31.60           C  
ATOM    503  C   VAL    59      29.955  41.865  93.602  1.00 51.55           C  
ATOM    504  O   VAL    59      29.745  43.049  93.870  1.00 58.66           O  
ATOM    505  CB  VAL    59      27.618  41.013  93.169  1.00 28.84           C  
ATOM    506  CG1 VAL    59      27.883  41.002  91.664  1.00 11.97           C  
ATOM    507  CG2 VAL    59      26.581  39.957  93.525  1.00 28.33           C  
ATOM    508  N   MET    60      31.063  41.442  92.998  1.00 46.21           N  
ATOM    509  CA  MET    60      32.144  42.357  92.635  1.00 43.37           C  
ATOM    510  C   MET    60      32.669  42.100  91.227  1.00 44.35           C  
ATOM    511  O   MET    60      32.773  40.951  90.797  1.00 52.83           O  
ATOM    512  CB  MET    60      33.269  42.275  93.662  1.00 44.96           C  
ATOM    513  CG  MET    60      33.034  43.154  94.879  1.00 48.21           C  
ATOM    514  SD  MET    60      33.481  42.433  96.469  1.00 46.13           S  
ATOM    515  CE  MET    60      34.825  41.344  96.023  1.00  4.14           C  
ATOM    516  N   SER    61      33.001  43.177  90.518  1.00 33.48           N  
ATOM    517  CA  SER    61      33.352  43.085  89.102  1.00 36.37           C  
ATOM    518  C   SER    61      34.679  43.747  88.754  1.00 44.79           C  
ATOM    519  O   SER    61      34.992  44.836  89.243  1.00 57.16           O  
ATOM    520  CB  SER    61      32.236  43.683  88.243  1.00 41.88           C  
ATOM    521  OG  SER    61      30.989  43.082  88.542  1.00 61.05           O  
ATOM    522  N   ALA    62      35.450  43.073  87.905  1.00 58.28           N  
ATOM    523  CA  ALA    62      36.674  43.634  87.346  1.00 58.50           C  
ATOM    524  C   ALA    62      36.339  44.552  86.170  1.00 64.19           C  
ATOM    525  O   ALA    62      35.240  44.478  85.613  1.00 75.24           O  
ATOM    526  CB  ALA    62      37.620  42.523  86.917  1.00 58.97           C  
ATOM    527  N   ASN    63      37.287  45.408  85.793  1.00 68.09           N  
ATOM    528  CA  ASN    63      37.062  46.432  84.756  1.00 69.47           C  
ATOM    529  C   ASN    63      36.980  45.953  83.296  1.00 64.12           C  
ATOM    530  O   ASN    63      36.721  46.748  82.388  1.00 58.40           O  
ATOM    531  CB  ASN    63      38.022  47.635  84.920  1.00 65.01           C  
ATOM    532  CG  ASN    63      39.505  47.293  84.677  1.00 91.40           C  
ATOM    533  OD1 ASN    63      40.339  48.201  84.624  1.00107.59           O  
ATOM    534  ND2 ASN    63      39.836  46.010  84.532  1.00 94.71           N  
ATOM    535  N   CYS    64      37.195  44.657  83.089  1.00 60.02           N  
ATOM    536  CA  CYS    64      37.081  44.040  81.771  1.00 75.98           C  
ATOM    537  C   CYS    64      35.619  43.849  81.359  1.00 79.71           C  
ATOM    538  O   CYS    64      35.171  44.435  80.369  1.00 80.65           O  
ATOM    539  CB  CYS    64      37.841  42.712  81.738  1.00 82.49           C  
ATOM    540  SG  CYS    64      37.673  41.726  83.249  1.00 98.58           S  
ATOM    541  N   VAL    65      34.882  43.036  82.119  1.00 73.13           N  
ATOM    542  CA  VAL    65      33.457  42.808  81.857  1.00 69.48           C  
ATOM    543  C   VAL    65      32.646  43.994  82.365  1.00 68.33           C  
ATOM    544  O   VAL    65      33.004  44.620  83.367  1.00 62.17           O  
ATOM    545  CB  VAL    65      32.921  41.516  82.520  1.00 68.74           C  
ATOM    546  CG1 VAL    65      31.853  40.870  81.643  1.00 97.15           C  
ATOM    547  CG2 VAL    65      34.032  40.537  82.757  1.00 69.93           C  
ATOM    548  N   LYS    66      31.545  44.287  81.676  1.00 78.50           N  
ATOM    549  CA  LYS    66      30.731  45.469  81.961  1.00 86.16           C  
ATOM    550  C   LYS    66      29.637  45.258  83.018  1.00 84.47           C  
ATOM    551  O   LYS    66      28.615  45.951  83.007  1.00 77.59           O  
ATOM    552  CB  LYS    66      30.125  46.021  80.662  1.00 95.79           C  
ATOM    553  CG  LYS    66      31.095  46.834  79.801  1.00113.77           C  
ATOM    554  CD  LYS    66      31.301  48.254  80.336  1.00122.57           C  
ATOM    555  CE  LYS    66      30.109  49.156  80.032  1.00120.31           C  
ATOM    556  NZ  LYS    66      30.291  50.525  80.592  1.00115.46           N  
ATOM    557  N   ASP    67      29.858  44.310  83.927  1.00 80.20           N  
ATOM    558  CA  ASP    67      28.968  44.109  85.069  1.00 71.67           C  
ATOM    559  C   ASP    67      29.181  45.216  86.103  1.00 72.53           C  
ATOM    560  O   ASP    67      30.254  45.827  86.154  1.00 74.41           O  
ATOM    561  CB  ASP    67      29.193  42.729  85.700  1.00 61.88           C  
ATOM    562  CG  ASP    67      28.744  41.588  84.798  1.00 67.35           C  
ATOM    563  OD1 ASP    67      29.148  41.555  83.614  1.00 65.09           O  
ATOM    564  OD2 ASP    67      27.991  40.714  85.281  1.00 60.45           O  
ATOM    565  N   THR    68      28.149  45.468  86.908  1.00 72.93           N  
ATOM    566  CA  THR    68      28.159  46.508  87.945  1.00 74.31           C  
ATOM    567  C   THR    68      29.237  46.251  89.007  1.00 64.76           C  
ATOM    568  O   THR    68      29.387  45.113  89.458  1.00 60.99           O  
ATOM    569  CB  THR    68      26.781  46.617  88.633  1.00 75.76           C  
ATOM    570  OG1 THR    68      26.394  45.326  89.135  1.00 61.69           O  
ATOM    571  CG2 THR    68      25.723  47.125  87.656  1.00 77.58           C  
ATOM    572  N   PRO    69      29.992  47.306  89.397  1.00 58.71           N  
ATOM    573  CA  PRO    69      31.149  47.214  90.301  1.00 51.46           C  
ATOM    574  C   PRO    69      30.899  46.539  91.652  1.00 52.55           C  
ATOM    575  O   PRO    69      31.702  45.703  92.070  1.00 54.61           O  
ATOM    576  CB  PRO    69      31.536  48.681  90.523  1.00 34.40           C  
ATOM    577  CG  PRO    69      31.056  49.379  89.317  1.00 27.54           C  
ATOM    578  CD  PRO    69      29.773  48.699  88.957  1.00 48.11           C  
ATOM    579  N   PHE    70      29.806  46.897  92.325  1.00 47.73           N  
ATOM    580  CA  PHE    70      29.535  46.373  93.665  1.00 38.96           C  
ATOM    581  C   PHE    70      28.051  46.180  93.972  1.00 47.67           C  
ATOM    582  O   PHE    70      27.218  47.019  93.621  1.00 44.07           O  
ATOM    583  CB  PHE    70      30.181  47.268  94.736  1.00 27.56           C  
ATOM    584  CG  PHE    70      30.034  46.741  96.142  1.00 35.59           C  
ATOM    585  CD1 PHE    70      29.015  47.203  96.975  1.00 28.02           C  
ATOM    586  CD2 PHE    70      30.909  45.777  96.630  1.00 26.65           C  
ATOM    587  CE1 PHE    70      28.868  46.705  98.265  1.00 55.54           C  
ATOM    588  CE2 PHE    70      30.777  45.284  97.922  1.00 13.83           C  
ATOM    589  CZ  PHE    70      29.756  45.748  98.741  1.00 52.02           C  
ATOM    590  N   HIS    71      27.747  45.070  94.645  1.00 38.09           N  
ATOM    591  CA  HIS    71      26.436  44.824  95.244  1.00 41.20           C  
ATOM    592  C   HIS    71      26.564  44.016  96.533  1.00 51.31           C  
ATOM    593  O   HIS    71      27.296  43.025  96.583  1.00 60.30           O  
ATOM    594  CB  HIS    71      25.515  44.095  94.267  1.00 36.38           C  
ATOM    595  CG  HIS    71      24.807  45.004  93.316  1.00 61.41           C  
ATOM    596  ND1 HIS    71      25.370  45.420  92.129  1.00 74.55           N  
ATOM    597  CD2 HIS    71      23.586  45.585  93.378  1.00 41.09           C  
ATOM    598  CE1 HIS    71      24.526  46.217  91.500  1.00 57.77           C  
ATOM    599  NE2 HIS    71      23.435  46.333  92.236  1.00 43.51           N  
ATOM    600  N   PHE    72      25.852  44.449  97.571  1.00 46.42           N  
ATOM    601  CA  PHE    72      25.787  43.703  98.824  1.00 42.49           C  
ATOM    602  C   PHE    72      24.352  43.284  99.128  1.00 41.28           C  
ATOM    603  O   PHE    72      23.463  44.125  99.290  1.00 41.05           O  
ATOM    604  CB  PHE    72      26.398  44.503  99.982  1.00 33.96           C  
ATOM    605  CG  PHE    72      26.478  43.742 101.286  1.00 53.39           C  
ATOM    606  CD1 PHE    72      26.960  42.434 101.324  1.00 63.75           C  
ATOM    607  CD2 PHE    72      26.092  44.346 102.480  1.00 28.53           C  
ATOM    608  CE1 PHE    72      27.042  41.737 102.526  1.00 53.03           C  
ATOM    609  CE2 PHE    72      26.173  43.659 103.688  1.00 64.73           C  
ATOM    610  CZ  PHE    72      26.649  42.353 103.710  1.00 46.99           C  
ATOM    611  N   PHE    73      24.145  41.972  99.194  1.00 42.22           N  
ATOM    612  CA  PHE    73      22.824  41.395  99.393  1.00 32.18           C  
ATOM    613  C   PHE    73      22.647  40.823 100.795  1.00 47.36           C  
ATOM    614  O   PHE    73      22.866  39.630 101.020  1.00 50.59           O  
ATOM    615  CB  PHE    73      22.550  40.302  98.352  1.00 16.68           C  
ATOM    616  CG  PHE    73      22.437  40.812  96.945  1.00 46.08           C  
ATOM    617  CD1 PHE    73      21.241  41.350  96.479  1.00 36.49           C  
ATOM    618  CD2 PHE    73      23.520  40.740  96.078  1.00 49.46           C  
ATOM    619  CE1 PHE    73      21.129  41.818  95.173  1.00 47.29           C  
ATOM    620  CE2 PHE    73      23.414  41.201  94.770  1.00 41.84           C  
ATOM    621  CZ  PHE    73      22.219  41.743  94.317  1.00 24.14           C  
ATOM    622  N   LYS    74      22.252  41.677 101.736  1.00 63.57           N  
ATOM    623  CA  LYS    74      21.788  41.203 103.037  1.00 65.79           C  
ATOM    624  C   LYS    74      20.345  40.710 102.925  1.00 64.36           C  
ATOM    625  O   LYS    74      19.711  40.873 101.878  1.00 57.86           O  
ATOM    626  CB  LYS    74      21.931  42.278 104.118  1.00 69.06           C  
ATOM    627  CG  LYS    74      23.118  42.045 105.040  1.00 62.10           C  
ATOM    628  CD  LYS    74      22.904  42.709 106.402  1.00 94.79           C  
ATOM    629  CE  LYS    74      23.653  41.967 107.509  1.00 98.09           C  
ATOM    630  NZ  LYS    74      25.141  42.013 107.336  1.00 73.68           N  
ATOM    631  N   GLN    75      19.837  40.112 104.004  1.00 73.63           N  
ATOM    632  CA  GLN    75      18.522  39.451 104.008  1.00 83.30           C  
ATOM    633  C   GLN    75      17.328  40.317 103.591  1.00 66.97           C  
ATOM    634  O   GLN    75      16.366  39.806 103.014  1.00 64.86           O  
ATOM    635  CB  GLN    75      18.241  38.802 105.366  1.00 97.58           C  
ATOM    636  CG  GLN    75      18.763  37.378 105.494  1.00119.01           C  
ATOM    637  CD  GLN    75      17.893  36.504 106.388  1.00132.39           C  
ATOM    638  OE1 GLN    75      16.774  36.875 106.751  1.00122.34           O  
ATOM    639  NE2 GLN    75      18.404  35.330 106.741  1.00128.61           N  
ATOM    640  N   ASN    76      17.394  41.616 103.877  1.00 70.77           N  
ATOM    641  CA  ASN    76      16.306  42.534 103.534  1.00 73.19           C  
ATOM    642  C   ASN    76      16.680  43.674 102.581  1.00 67.26           C  
ATOM    643  O   ASN    76      15.802  44.257 101.937  1.00 74.46           O  
ATOM    644  CB  ASN    76      15.649  43.092 104.804  1.00 80.64           C  
ATOM    645  CG  ASN    76      14.540  42.193 105.339  1.00 94.09           C  
ATOM    646  OD1 ASN    76      14.310  41.091 104.836  1.00116.49           O  
ATOM    647  ND2 ASN    76      13.844  42.667 106.366  1.00109.69           N  
ATOM    648  N   VAL    77      17.974  43.990 102.491  1.00 69.09           N  
ATOM    649  CA  VAL    77      18.442  45.125 101.684  1.00 62.67           C  
ATOM    650  C   VAL    77      19.398  44.696 100.564  1.00 61.27           C  
ATOM    651  O   VAL    77      20.153  43.732 100.715  1.00 62.47           O  
ATOM    652  CB  VAL    77      19.153  46.216 102.547  1.00 64.53           C  
ATOM    653  CG1 VAL    77      18.833  47.612 102.020  1.00 55.69           C  
ATOM    654  CG2 VAL    77      18.772  46.111 104.024  1.00 82.06           C  
ATOM    655  N   MET    78      19.349  45.419  99.445  1.00 42.50           N  
ATOM    656  CA  MET    78      20.336  45.285  98.371  1.00 50.14           C  
ATOM    657  C   MET    78      21.078  46.613  98.143  1.00 38.69           C  
ATOM    658  O   MET    78      20.716  47.413  97.274  1.00 48.81           O  
ATOM    659  CB  MET    78      19.703  44.737  97.077  1.00 47.97           C  
ATOM    660  CG  MET    78      18.332  45.317  96.706  1.00 69.92           C  
ATOM    661  SD  MET    78      17.692  44.689  95.138  1.00 61.78           S  
ATOM    662  CE  MET    78      17.085  43.063  95.638  1.00 74.72           C  
ATOM    663  N   THR    79      22.115  46.838  98.946  1.00 47.80           N  
ATOM    664  CA  THR    79      22.876  48.092  98.914  1.00 52.87           C  
ATOM    665  C   THR    79      24.004  48.084  97.879  1.00 52.91           C  
ATOM    666  O   THR    79      24.603  47.041  97.602  1.00 52.97           O  
ATOM    667  CB  THR    79      23.424  48.482 100.320  1.00 54.82           C  
ATOM    668  OG1 THR    79      24.399  49.528 100.192  1.00 68.46           O  
ATOM    669  CG2 THR    79      24.060  47.285 101.023  1.00 70.18           C  
ATOM    670  N   THR    80      24.279  49.260  97.318  1.00 51.14           N  
ATOM    671  CA  THR    80      25.340  49.434  96.323  1.00 51.08           C  
ATOM    672  C   THR    80      26.563  50.161  96.894  1.00 55.47           C  
ATOM    673  O   THR    80      27.634  50.164  96.279  1.00 58.74           O  
ATOM    674  CB  THR    80      24.820  50.154  95.045  1.00 47.82           C  
ATOM    675  OG1 THR    80      25.865  50.215  94.064  1.00 74.38           O  
ATOM    676  CG2 THR    80      24.325  51.569  95.356  1.00 61.08           C  
ATOM    677  N   ASP    81      26.394  50.771  98.068  1.00 55.83           N  
ATOM    678  CA  ASP    81      27.473  51.496  98.737  1.00 46.86           C  
ATOM    679  C   ASP    81      28.443  50.518  99.392  1.00 48.86           C  
ATOM    680  O   ASP    81      28.072  49.776 100.305  1.00 38.32           O  
ATOM    681  CB  ASP    81      26.906  52.473  99.775  1.00 52.86           C  
ATOM    682  CG  ASP    81      27.947  53.459 100.286  1.00 63.92           C  
ATOM    683  OD1 ASP    81      27.945  53.746 101.502  1.00 77.56           O  
ATOM    684  OD2 ASP    81      28.764  53.952  99.478  1.00108.65           O  
ATOM    685  N   ALA    82      29.684  50.524  98.912  1.00 49.02           N  
ATOM    686  CA  ALA    82      30.701  49.585  99.380  1.00 37.82           C  
ATOM    687  C   ALA    82      31.286  49.960 100.737  1.00 47.96           C  
ATOM    688  O   ALA    82      31.702  49.083 101.489  1.00 56.08           O  
ATOM    689  CB  ALA    82      31.800  49.430  98.345  1.00 43.64           C  
ATOM    690  N   GLU    83      31.309  51.258 101.037  1.00 37.70           N  
ATOM    691  CA  GLU    83      31.862  51.775 102.292  1.00 37.91           C  
ATOM    692  C   GLU    83      31.017  51.418 103.512  1.00 49.17           C  
ATOM    693  O   GLU    83      31.561  51.067 104.562  1.00 63.96           O  
ATOM    694  CB  GLU    83      32.046  53.293 102.220  1.00 28.88           C  
ATOM    695  CG  GLU    83      33.246  53.744 101.401  1.00 39.60           C  
ATOM    696  CD  GLU    83      33.449  55.251 101.436  1.00 80.26           C  
ATOM    697  OE1 GLU    83      33.713  55.837 100.365  1.00105.07           O  
ATOM    698  OE2 GLU    83      33.345  55.852 102.528  1.00 70.49           O  
ATOM    699  N   LYS    84      29.695  51.520 103.368  1.00 47.28           N  
ATOM    700  CA  LYS    84      28.765  51.139 104.429  1.00 53.19           C  
ATOM    701  C   LYS    84      28.750  49.623 104.603  1.00 56.27           C  
ATOM    702  O   LYS    84      28.696  49.127 105.728  1.00 61.84           O  
ATOM    703  CB  LYS    84      27.355  51.676 104.139  1.00 62.44           C  
ATOM    704  CG  LYS    84      26.317  51.460 105.256  1.00 75.22           C  
ATOM    705  CD  LYS    84      26.762  52.016 106.617  1.00111.96           C  
ATOM    706  CE  LYS    84      26.751  53.544 106.663  1.00115.36           C  
ATOM    707  NZ  LYS    84      25.373  54.111 106.606  1.00122.53           N  
ATOM    708  N   SER    85      28.824  48.904 103.483  1.00 52.57           N  
ATOM    709  CA  SER    85      28.869  47.442 103.478  1.00 49.61           C  
ATOM    710  C   SER    85      30.157  46.897 104.095  1.00 47.01           C  
ATOM    711  O   SER    85      30.130  45.872 104.774  1.00 52.71           O  
ATOM    712  CB  SER    85      28.703  46.911 102.054  1.00 45.25           C  
ATOM    713  OG  SER    85      27.475  47.341 101.493  1.00 55.42           O  
ATOM    714  N   PHE    86      31.271  47.591 103.855  1.00 40.80           N  
ATOM    715  CA  PHE    86      32.565  47.250 104.453  1.00 37.95           C  
ATOM    716  C   PHE    86      32.561  47.534 105.954  1.00 39.94           C  
ATOM    717  O   PHE    86      33.125  46.763 106.733  1.00 42.91           O  
ATOM    718  CB  PHE    86      33.703  48.009 103.754  1.00 43.18           C  
ATOM    719  CG  PHE    86      35.089  47.585 104.178  1.00 36.61           C  
ATOM    720  CD1 PHE    86      35.374  46.255 104.496  1.00 27.09           C  
ATOM    721  CD2 PHE    86      36.123  48.521 104.224  1.00 21.57           C  
ATOM    722  CE1 PHE    86      36.649  45.876 104.881  1.00 27.27           C  
ATOM    723  CE2 PHE    86      37.408  48.145 104.603  1.00 13.85           C  
ATOM    724  CZ  PHE    86      37.671  46.820 104.931  1.00 37.04           C  
ATOM    725  N   HIS    87      31.913  48.632 106.346  1.00 43.45           N  
ATOM    726  CA  HIS    87      31.733  48.990 107.755  1.00 33.20           C  
ATOM    727  C   HIS    87      30.821  47.992 108.483  1.00 26.92           C  
ATOM    728  O   HIS    87      30.957  47.782 109.694  1.00 38.35           O  
ATOM    729  CB  HIS    87      31.187  50.423 107.869  1.00 47.79           C  
ATOM    730  CG  HIS    87      30.780  50.816 109.256  1.00 77.67           C  
ATOM    731  ND1 HIS    87      31.689  51.004 110.276  1.00 95.54           N  
ATOM    732  CD2 HIS    87      29.560  51.056 109.791  1.00 62.79           C  
ATOM    733  CE1 HIS    87      31.046  51.341 111.380  1.00 68.04           C  
ATOM    734  NE2 HIS    87      29.753  51.381 111.113  1.00 57.51           N  
ATOM    735  N   ASP    88      29.913  47.373 107.727  1.00 37.53           N  
ATOM    736  CA  ASP    88      28.997  46.413 108.322  0.50 28.64           C  
ATOM    738  C   ASP    88      29.578  45.004 108.437  1.00 28.85           C  
ATOM    739  O   ASP    88      29.406  44.370 109.478  1.00 26.48           O  
ATOM    740  CB  ASP    88      27.622  46.450 107.604  0.50 29.14           C  
ATOM    742  CG  ASP    88      26.892  47.808 107.904  0.50 35.28           C  
ATOM    744  OD1 ASP    88      27.128  48.454 108.977  0.50 49.49           O  
ATOM    746  OD2 ASP    88      26.073  48.216 107.050  0.50 20.40           O  
ATOM    748  N   ILE    89      30.290  44.529 107.409  1.00 34.25           N  
ATOM    749  CA  ILE    89      30.942  43.200 107.451  1.00 50.45           C  
ATOM    750  C   ILE    89      32.134  43.168 108.418  1.00 46.38           C  
ATOM    751  O   ILE    89      32.570  42.095 108.855  1.00 54.94           O  
ATOM    752  CB  ILE    89      31.356  42.663 106.032  1.00 56.41           C  
ATOM    753  CG1 ILE    89      32.425  43.541 105.363  1.00 54.06           C  
ATOM    754  CG2 ILE    89      30.136  42.497 105.129  1.00 53.34           C  
ATOM    755  CD1 ILE    89      33.822  42.934 105.343  1.00 46.88           C  
ATOM    756  N   ARG    90      32.647  44.364 108.718  1.00 36.15           N  
ATOM    757  CA  ARG    90      33.648  44.613 109.751  1.00 33.44           C  
ATOM    758  C   ARG    90      33.174  44.112 111.112  1.00 35.88           C  
ATOM    759  O   ARG    90      33.923  43.464 111.846  1.00 32.69           O  
ATOM    760  CB  ARG    90      33.873  46.124 109.851  1.00 50.53           C  
ATOM    761  CG  ARG    90      35.309  46.587 109.914  1.00 49.31           C  
ATOM    762  CD  ARG    90      35.980  46.545 108.546  1.00 11.36           C  
ATOM    763  NE  ARG    90      36.812  47.723 108.294  1.00 39.72           N  
ATOM    764  CZ  ARG    90      38.043  47.915 108.768  1.00 44.50           C  
ATOM    765  NH1 ARG    90      38.630  47.013 109.548  1.00 21.11           N  
ATOM    766  NH2 ARG    90      38.693  49.029 108.462  1.00 41.44           N  
ATOM    767  N   LEU    91      31.919  44.426 111.428  1.00 49.46           N  
ATOM    768  CA  LEU    91      31.334  44.160 112.737  1.00 39.94           C  
ATOM    769  C   LEU    91      30.506  42.877 112.775  1.00 52.25           C  
ATOM    770  O   LEU    91      30.407  42.235 113.824  1.00 68.83           O  
ATOM    771  CB  LEU    91      30.465  45.347 113.181  1.00 31.54           C  
ATOM    772  CG  LEU    91      31.063  46.545 113.937  1.00 53.08           C  
ATOM    773  CD1 LEU    91      32.020  47.394 113.065  1.00 64.99           C  
ATOM    774  CD2 LEU    91      29.928  47.422 114.518  1.00 42.90           C  
ATOM    775  N   ASN    92      29.920  42.512 111.639  1.00 56.70           N  
ATOM    776  CA  ASN    92      28.881  41.490 111.607  1.00 67.96           C  
ATOM    777  C   ASN    92      29.457  40.080 111.686  1.00 72.93           C  
ATOM    778  O   ASN    92      28.842  39.179 112.256  1.00 76.53           O  
ATOM    779  CB  ASN    92      28.023  41.637 110.350  1.00 78.08           C  
ATOM    780  CG  ASN    92      26.855  42.584 110.549  1.00 88.02           C  
ATOM    781  OD1 ASN    92      25.957  42.665 109.711  1.00131.72           O  
ATOM    782  ND2 ASN    92      26.863  43.307 111.663  1.00 59.87           N  
ATOM    783  N   ARG    93      30.641  39.896 111.111  1.00 71.19           N  
ATOM    784  CA  ARG    93      31.543  38.834 111.538  1.00 73.30           C  
ATOM    785  C   ARG    93      30.928  37.458 111.301  1.00 77.32           C  
ATOM    786  O   ARG    93      31.088  36.872 110.231  1.00 84.52           O  
ATOM    787  CB  ARG    93      31.907  39.000 113.015  1.00 74.54           C  
ATOM    788  CG  ARG    93      33.069  39.947 113.265  1.00 81.79           C  
ATOM    789  CD  ARG    93      34.170  39.755 112.235  1.00 42.00           C  
ATOM    790  NE  ARG    93      35.213  40.770 112.353  1.00 52.63           N  
ATOM    791  CZ  ARG    93      36.415  40.548 112.873  1.00 69.36           C  
ATOM    792  NH1 ARG    93      36.732  39.343 113.327  1.00 79.09           N  
ATOM    793  NH2 ARG    93      37.302  41.532 112.940  1.00 90.19           N  
ATOM    794  N   ASP    94      30.224  36.950 112.307  1.00 76.75           N  
ATOM    795  CA  ASP    94      30.181  35.515 112.563  1.00 75.47           C  
ATOM    796  C   ASP    94      29.214  34.814 111.614  1.00 70.61           C  
ATOM    797  O   ASP    94      28.876  33.646 111.808  1.00 77.92           O  
ATOM    798  CB  ASP    94      29.782  35.242 114.015  1.00 74.90           C  
ATOM    799  CG  ASP    94      28.643  36.126 114.483  1.00 99.50           C  
ATOM    800  OD1 ASP    94      28.572  37.291 114.039  1.00125.90           O  
ATOM    801  OD2 ASP    94      27.818  35.656 115.295  1.00115.48           O  
ATOM    802  N   GLU    95      28.774  35.534 110.588  1.00 67.83           N  
ATOM    803  CA  GLU    95      27.934  34.949 109.541  1.00 72.63           C  
ATOM    804  C   GLU    95      28.752  34.584 108.303  1.00 69.46           C  
ATOM    805  O   GLU    95      29.844  35.120 108.089  1.00 62.78           O  
ATOM    806  CB  GLU    95      26.792  35.897 109.161  1.00 84.56           C  
ATOM    807  CG  GLU    95      25.454  35.587 109.828  1.00103.34           C  
ATOM    808  CD  GLU    95      25.446  35.870 111.321  1.00131.10           C  
ATOM    809  OE1 GLU    95      24.975  34.999 112.083  1.00149.05           O  
ATOM    810  OE2 GLU    95      25.907  36.956 111.734  1.00120.75           O  
ATOM    811  N   ASP    96      28.218  33.662 107.502  1.00 67.14           N  
ATOM    812  CA  ASP    96      28.824  33.275 106.229  1.00 61.36           C  
ATOM    813  C   ASP    96      28.684  34.390 105.199  1.00 57.82           C  
ATOM    814  O   ASP    96      27.626  35.014 105.096  1.00 58.90           O  
ATOM    815  CB  ASP    96      28.166  32.001 105.686  1.00 63.82           C  
ATOM    816  CG  ASP    96      28.538  30.760 106.478  1.00 83.76           C  
ATOM    817  OD1 ASP    96      29.690  30.294 106.361  1.00 83.72           O  
ATOM    818  OD2 ASP    96      27.668  30.237 107.206  1.00 94.54           O  
ATOM    819  N   ILE    97      29.754  34.640 104.446  1.00 50.57           N  
ATOM    820  CA  ILE    97      29.721  35.600 103.340  1.00 42.35           C  
ATOM    821  C   ILE    97      29.851  34.847 102.017  1.00 48.41           C  
ATOM    822  O   ILE    97      30.668  33.930 101.892  1.00 61.71           O  
ATOM    823  CB  ILE    97      30.836  36.681 103.452  1.00 38.51           C  
ATOM    824  CG1 ILE    97      30.998  37.146 104.905  1.00 56.20           C  
ATOM    825  CG2 ILE    97      30.543  37.866 102.519  1.00 36.70           C  
ATOM    826  CD1 ILE    97      32.017  38.258 105.111  1.00 36.92           C  
ATOM    827  N   TYR    98      29.036  35.235 101.038  1.00 43.37           N  
ATOM    828  CA  TYR    98      29.033  34.593  99.728  1.00 41.55           C  
ATOM    829  C   TYR    98      29.468  35.571  98.639  1.00 45.44           C  
ATOM    830  O   TYR    98      28.735  36.499  98.298  1.00 53.75           O  
ATOM    831  CB  TYR    98      27.649  34.019  99.419  1.00 43.75           C  
ATOM    832  CG  TYR    98      27.234  32.868 100.314  1.00 46.05           C  
ATOM    833  CD1 TYR    98      27.502  31.550  99.950  1.00 57.34           C  
ATOM    834  CD2 TYR    98      26.568  33.095 101.521  1.00 43.28           C  
ATOM    835  CE1 TYR    98      27.125  30.486 100.764  1.00 67.21           C  
ATOM    836  CE2 TYR    98      26.186  32.038 102.343  1.00 73.75           C  
ATOM    837  CZ  TYR    98      26.468  30.737 101.957  1.00 66.92           C  
ATOM    838  OH  TYR    98      26.093  29.688 102.765  1.00 54.52           O  
ATOM    839  N   ILE    99      30.663  35.352  98.098  1.00 37.68           N  
ATOM    840  CA  ILE    99      31.256  36.271  97.125  1.00 28.08           C  
ATOM    841  C   ILE    99      31.253  35.693  95.710  1.00 42.24           C  
ATOM    842  O   ILE    99      31.662  34.549  95.497  1.00 51.89           O  
ATOM    843  CB  ILE    99      32.712  36.664  97.512  1.00 32.23           C  
ATOM    844  CG1 ILE    99      32.817  36.961  99.014  1.00 42.55           C  
ATOM    845  CG2 ILE    99      33.200  37.863  96.683  1.00 37.46           C  
ATOM    846  CD1 ILE    99      34.240  37.035  99.531  1.00 44.76           C  
ATOM    847  N   GLN   100      30.778  36.487  94.752  1.00 41.82           N  
ATOM    848  CA  GLN   100      30.997  36.194  93.339  1.00 50.21           C  
ATOM    849  C   GLN   100      31.923  37.230  92.706  1.00 54.68           C  
ATOM    850  O   GLN   100      31.944  38.398  93.113  1.00 54.28           O  
ATOM    851  CB  GLN   100      29.678  36.066  92.560  1.00 50.15           C  
ATOM    852  CG  GLN   100      28.947  37.353  92.243  1.00 46.68           C  
ATOM    853  CD  GLN   100      27.981  37.186  91.088  1.00 48.67           C  
ATOM    854  OE1 GLN   100      28.382  37.188  89.922  1.00 30.74           O  
ATOM    855  NE2 GLN   100      26.702  37.039  91.406  1.00 37.98           N  
ATOM    856  N   LEU   101      32.703  36.784  91.724  1.00 50.71           N  
ATOM    857  CA  LEU   101      33.607  37.672  91.003  1.00 52.79           C  
ATOM    858  C   LEU   101      33.303  37.675  89.512  1.00 48.52           C  
ATOM    859  O   LEU   101      33.158  36.615  88.895  1.00 54.98           O  
ATOM    860  CB  LEU   101      35.076  37.300  91.253  1.00 57.78           C  
ATOM    861  CG  LEU   101      35.778  37.766  92.539  1.00 45.95           C  
ATOM    862  CD1 LEU   101      35.421  39.206  92.898  1.00 44.26           C  
ATOM    863  CD2 LEU   101      35.496  36.844  93.713  1.00 51.41           C  
ATOM    864  N   ASN   102      33.203  38.874  88.944  1.00 44.83           N  
ATOM    865  CA  ASN   102      32.942  39.035  87.518  1.00 54.17           C  
ATOM    866  C   ASN   102      34.192  39.484  86.763  1.00 63.67           C  
ATOM    867  O   ASN   102      34.495  40.678  86.690  1.00 68.06           O  
ATOM    868  CB  ASN   102      31.780  40.012  87.282  1.00 52.28           C  
ATOM    869  CG  ASN   102      30.482  39.560  87.940  1.00 52.25           C  
ATOM    870  OD1 ASN   102      29.761  40.367  88.527  1.00 64.12           O  
ATOM    871  ND2 ASN   102      30.180  38.268  87.842  1.00 50.03           N  
ATOM    872  N   PHE   103      34.917  38.512  86.213  1.00 64.90           N  
ATOM    873  CA  PHE   103      36.127  38.782  85.431  1.00 71.60           C  
ATOM    874  C   PHE   103      36.130  38.030  84.095  1.00 72.29           C  
ATOM    875  O   PHE   103      35.446  37.014  83.956  1.00 67.27           O  
ATOM    876  CB  PHE   103      37.415  38.570  86.256  1.00 69.00           C  
ATOM    877  CG  PHE   103      37.562  37.193  86.863  1.00 58.28           C  
ATOM    878  CD1 PHE   103      36.832  36.817  87.992  1.00 59.61           C  
ATOM    879  CD2 PHE   103      38.478  36.291  86.336  1.00 44.98           C  
ATOM    880  CE1 PHE   103      36.987  35.554  88.558  1.00 62.83           C  
ATOM    881  CE2 PHE   103      38.647  35.029  86.901  1.00 79.49           C  
ATOM    882  CZ  PHE   103      37.896  34.659  88.011  1.00 69.92           C  
ATOM    883  N   LYS   104      36.894  38.532  83.130  1.00 79.77           N  
ATOM    884  CA  LYS   104      36.661  38.217  81.726  1.00 77.85           C  
ATOM    885  C   LYS   104      36.767  36.717  81.472  1.00 80.76           C  
ATOM    886  O   LYS   104      35.888  36.119  80.852  1.00 89.35           O  
ATOM    887  CB  LYS   104      37.649  38.972  80.836  1.00 72.34           C  
ATOM    888  CG  LYS   104      37.514  38.660  79.354  1.00 89.58           C  
ATOM    889  CD  LYS   104      37.651  39.917  78.511  1.00108.84           C  
ATOM    890  CE  LYS   104      36.312  40.613  78.335  1.00111.27           C  
ATOM    891  NZ  LYS   104      36.408  41.778  77.412  1.00106.29           N  
ATOM    892  N   SER   105      37.849  36.115  81.956  1.00 79.14           N  
ATOM    893  CA  SER   105      38.225  34.768  81.544  1.00 84.89           C  
ATOM    894  C   SER   105      37.589  33.717  82.448  1.00 82.17           C  
ATOM    895  O   SER   105      37.340  32.589  82.023  1.00 88.04           O  
ATOM    896  CB  SER   105      39.747  34.613  81.548  1.00 93.30           C  
ATOM    897  OG  SER   105      40.275  34.793  82.850  1.00 90.41           O  
ATOM    898  N   SER   106      37.328  34.096  83.695  1.00 73.03           N  
ATOM    899  CA  SER   106      36.538  33.267  84.597  1.00 75.36           C  
ATOM    900  C   SER   106      36.819  31.785  84.373  1.00 81.22           C  
ATOM    901  O   SER   106      37.758  31.228  84.942  1.00 72.87           O  
ATOM    902  CB  SER   106      35.046  33.552  84.419  1.00 64.71           C  
ATOM    903  OG  SER   106      34.653  34.698  85.155  1.00 77.91           O  
ATOM    904  N   PHE   107      35.999  31.151  83.541  1.00 83.20           N  
ATOM    905  CA  PHE   107      35.974  29.697  83.449  1.00 84.24           C  
ATOM    906  C   PHE   107      37.065  29.184  82.516  1.00 86.74           C  
ATOM    907  O   PHE   107      37.000  28.055  82.029  1.00 85.34           O  
ATOM    908  CB  PHE   107      34.603  29.213  82.971  1.00 81.07           C  
ATOM    909  CG  PHE   107      33.671  28.836  84.087  1.00 80.14           C  
ATOM    910  CD1 PHE   107      33.679  27.555  84.611  1.00 79.45           C  
ATOM    911  CD2 PHE   107      32.785  29.763  84.611  1.00 81.77           C  
ATOM    912  CE1 PHE   107      32.822  27.205  85.638  1.00 73.72           C  
ATOM    913  CE2 PHE   107      31.926  29.419  85.637  1.00 86.27           C  
ATOM    914  CZ  PHE   107      31.945  28.138  86.151  1.00 81.88           C  
ATOM    915  N   GLN   108      38.068  30.021  82.269  1.00 81.83           N  
ATOM    916  CA  GLN   108      39.314  29.567  81.664  1.00 71.50           C  
ATOM    917  C   GLN   108      40.315  29.128  82.727  1.00 73.51           C  
ATOM    918  O   GLN   108      41.228  28.350  82.450  1.00 84.63           O  
ATOM    919  CB  GLN   108      39.920  30.670  80.794  1.00 60.92           C  
ATOM    920  CG  GLN   108      41.374  30.435  80.417  1.00 65.78           C  
ATOM    921  CD  GLN   108      42.133  31.727  80.189  1.00 78.37           C  
ATOM    922  OE1 GLN   108      41.699  32.589  79.424  1.00 89.24           O  
ATOM    923  NE2 GLN   108      43.274  31.869  80.853  1.00 93.78           N  
ATOM    924  N   ASN   109      40.138  29.632  83.944  1.00 61.06           N  
ATOM    925  CA  ASN   109      41.099  29.402  85.016  1.00 56.97           C  
ATOM    926  C   ASN   109      40.647  28.313  85.986  1.00 59.09           C  
ATOM    927  O   ASN   109      39.636  28.468  86.676  1.00 75.42           O  
ATOM    928  CB  ASN   109      41.355  30.715  85.760  1.00 60.45           C  
ATOM    929  CG  ASN   109      41.531  31.894  84.820  1.00 74.41           C  
ATOM    930  OD1 ASN   109      42.538  31.999  84.117  1.00 79.56           O  
ATOM    931  ND2 ASN   109      40.550  32.791  84.809  1.00 59.82           N  
ATOM    932  N   ALA   110      41.421  27.226  86.034  1.00 59.44           N  
ATOM    933  CA  ALA   110      41.104  26.024  86.820  1.00 76.50           C  
ATOM    934  C   ALA   110      40.965  26.262  88.322  1.00 85.33           C  
ATOM    935  O   ALA   110      40.127  25.641  88.974  1.00 92.26           O  
ATOM    936  CB  ALA   110      42.139  24.935  86.554  1.00 82.37           C  
ATOM    937  N   ASN   111      41.793  27.159  88.852  1.00 82.09           N  
ATOM    938  CA  ASN   111      41.751  27.555  90.263  1.00 78.31           C  
ATOM    939  C   ASN   111      40.481  28.279  90.704  1.00 81.26           C  
ATOM    940  O   ASN   111      40.028  28.098  91.838  1.00 72.89           O  
ATOM    941  CB  ASN   111      43.003  28.352  90.673  1.00 74.33           C  
ATOM    942  CG  ASN   111      43.195  29.661  89.888  1.00 91.41           C  
ATOM    943  OD1 ASN   111      43.724  30.630  90.433  1.00100.72           O  
ATOM    944  ND2 ASN   111      42.798  29.687  88.621  1.00 89.07           N  
ATOM    945  N   TYR   112      39.919  29.097  89.812  1.00 79.02           N  
ATOM    946  CA  TYR   112      38.642  29.763  90.070  1.00 74.72           C  
ATOM    947  C   TYR   112      37.493  28.757  90.073  1.00 69.62           C  
ATOM    948  O   TYR   112      36.572  28.866  90.882  1.00 78.78           O  
ATOM    949  CB  TYR   112      38.386  30.890  89.057  1.00 72.88           C  
ATOM    950  CG  TYR   112      36.951  31.392  89.019  1.00 74.65           C  
ATOM    951  CD1 TYR   112      36.144  31.159  87.905  1.00 79.19           C  
ATOM    952  CD2 TYR   112      36.398  32.089  90.098  1.00 68.23           C  
ATOM    953  CE1 TYR   112      34.829  31.611  87.860  1.00 84.25           C  
ATOM    954  CE2 TYR   112      35.082  32.543  90.065  1.00 59.00           C  
ATOM    955  CZ  TYR   112      34.305  32.301  88.942  1.00 78.44           C  
ATOM    956  OH  TYR   112      33.004  32.748  88.902  1.00 73.48           O  
ATOM    957  N   VAL   113      37.558  27.778  89.172  1.00 62.73           N  
ATOM    958  CA  VAL   113      36.542  26.726  89.111  1.00 67.82           C  
ATOM    959  C   VAL   113      36.683  25.765  90.301  1.00 71.35           C  
ATOM    960  O   VAL   113      35.686  25.234  90.801  1.00 73.33           O  
ATOM    961  CB  VAL   113      36.566  25.959  87.761  1.00 63.65           C  
ATOM    962  CG1 VAL   113      35.270  25.182  87.569  1.00 54.93           C  
ATOM    963  CG2 VAL   113      36.724  26.935  86.605  1.00 60.95           C  
ATOM    964  N   ALA   114      37.919  25.572  90.765  1.00 76.69           N  
ATOM    965  CA  ALA   114      38.192  24.758  91.953  1.00 80.97           C  
ATOM    966  C   ALA   114      37.709  25.418  93.245  1.00 78.44           C  
ATOM    967  O   ALA   114      37.286  24.727  94.175  1.00 66.02           O  
ATOM    968  CB  ALA   114      39.676  24.435  92.051  1.00 92.18           C  
ATOM    969  N   VAL   115      37.770  26.748  93.296  1.00 75.18           N  
ATOM    970  CA  VAL   115      37.393  27.499  94.499  1.00 59.72           C  
ATOM    971  C   VAL   115      35.870  27.702  94.617  1.00 56.76           C  
ATOM    972  O   VAL   115      35.364  28.046  95.692  1.00 50.37           O  
ATOM    973  CB  VAL   115      38.187  28.845  94.612  1.00 58.85           C  
ATOM    974  CG1 VAL   115      37.478  29.989  93.887  1.00 60.87           C  
ATOM    975  CG2 VAL   115      38.449  29.205  96.073  1.00 56.17           C  
ATOM    976  N   LEU   116      35.151  27.466  93.517  1.00 48.29           N  
ATOM    977  CA  LEU   116      33.690  27.584  93.485  1.00 47.06           C  
ATOM    978  C   LEU   116      33.000  26.504  94.314  1.00 54.39           C  
ATOM    979  O   LEU   116      33.454  25.358  94.365  1.00 65.36           O  
ATOM    980  CB  LEU   116      33.167  27.548  92.044  1.00 49.10           C  
ATOM    981  CG  LEU   116      33.228  28.833  91.208  1.00 59.28           C  
ATOM    982  CD1 LEU   116      33.046  28.512  89.730  1.00 80.25           C  
ATOM    983  CD2 LEU   116      32.196  29.866  91.670  1.00 67.83           C  
ATOM    984  N   GLU   117      31.901  26.889  94.962  1.00 54.18           N  
ATOM    985  CA  GLU   117      31.165  26.003  95.862  1.00 65.51           C  
ATOM    986  C   GLU   117      29.683  25.931  95.498  1.00 73.86           C  
ATOM    987  O   GLU   117      29.170  26.787  94.769  1.00 82.41           O  
ATOM    988  CB  GLU   117      31.321  26.465  97.317  1.00 59.45           C  
ATOM    989  CG  GLU   117      32.745  26.386  97.860  1.00 68.90           C  
ATOM    990  CD  GLU   117      32.862  26.863  99.295  1.00 78.47           C  
ATOM    991  OE1 GLU   117      33.674  27.777  99.552  1.00104.50           O  
ATOM    992  OE2 GLU   117      32.145  26.326 100.167  1.00 96.20           O  
ATOM    993  N   GLU   118      29.011  24.898  96.008  1.00 83.47           N  
ATOM    994  CA  GLU   118      27.568  24.732  95.846  1.00 86.27           C  
ATOM    995  C   GLU   118      26.795  25.804  96.608  1.00 80.52           C  
ATOM    996  O   GLU   118      26.851  25.872  97.838  1.00 81.70           O  
ATOM    997  CB  GLU   118      27.133  23.336  96.304  1.00 92.70           C  
ATOM    998  CG  GLU   118      26.780  22.378  95.173  1.00116.45           C  
ATOM    999  CD  GLU   118      25.311  22.451  94.776  1.00132.68           C  
ATOM   1000  OE1 GLU   118      24.438  22.359  95.671  1.00133.96           O  
ATOM   1001  OE2 GLU   118      25.029  22.589  93.566  1.00138.23           O  
ATOM   1002  N   ASN   119      26.096  26.646  95.853  1.00 71.42           N  
ATOM   1003  CA  ASN   119      25.233  27.688  96.397  1.00 67.20           C  
ATOM   1004  C   ASN   119      23.840  27.099  96.645  1.00 66.23           C  
ATOM   1005  O   ASN   119      23.119  26.792  95.692  1.00 71.02           O  
ATOM   1006  CB  ASN   119      25.201  28.882  95.423  1.00 71.74           C  
ATOM   1007  CG  ASN   119      24.132  29.926  95.778  1.00 54.24           C  
ATOM   1008  OD1 ASN   119      23.699  30.063  96.934  1.00 63.35           O  
ATOM   1009  ND2 ASN   119      23.721  30.686  94.767  1.00 50.59           N  
ATOM   1010  N   PRO   120      23.458  26.941  97.930  1.00 67.17           N  
ATOM   1011  CA  PRO   120      22.210  26.271  98.289  1.00 72.55           C  
ATOM   1012  C   PRO   120      21.014  27.218  98.461  1.00 70.30           C  
ATOM   1013  O   PRO   120      20.143  26.969  99.300  1.00 79.44           O  
ATOM   1014  CB  PRO   120      22.561  25.599  99.621  1.00 75.47           C  
ATOM   1015  CG  PRO   120      23.674  26.451 100.210  1.00 68.75           C  
ATOM   1016  CD  PRO   120      24.189  27.380  99.133  1.00 60.87           C  
ATOM   1017  N   TYR   121      20.976  28.287  97.668  1.00 66.26           N  
ATOM   1018  CA  TYR   121      19.871  29.248  97.703  1.00 70.81           C  
ATOM   1019  C   TYR   121      19.294  29.470  96.308  1.00 75.80           C  
ATOM   1020  O   TYR   121      18.388  30.288  96.117  1.00 86.93           O  
ATOM   1021  CB  TYR   121      20.316  30.569  98.340  1.00 77.51           C  
ATOM   1022  CG  TYR   121      20.838  30.401  99.748  1.00 92.01           C  
ATOM   1023  CD1 TYR   121      22.207  30.339  99.998  1.00102.48           C  
ATOM   1024  CD2 TYR   121      19.964  30.284 100.828  1.00102.41           C  
ATOM   1025  CE1 TYR   121      22.697  30.169 101.288  1.00 93.63           C  
ATOM   1026  CE2 TYR   121      20.443  30.118 102.122  1.00 97.11           C  
ATOM   1027  CZ  TYR   121      21.809  30.060 102.345  1.00 87.71           C  
ATOM   1028  OH  TYR   121      22.287  29.899 103.625  1.00 82.59           O  
ATOM   1029  N   LEU   122      19.823  28.737  95.334  1.00 74.94           N  
ATOM   1030  CA  LEU   122      19.115  28.503  94.081  1.00 73.34           C  
ATOM   1031  C   LEU   122      17.804  27.762  94.319  1.00 73.93           C  
ATOM   1032  O   LEU   122      17.756  26.793  95.077  1.00 74.38           O  
ATOM   1033  CB  LEU   122      19.995  27.716  93.107  1.00 79.27           C  
ATOM   1034  CG  LEU   122      20.942  28.540  92.233  1.00 62.59           C  
ATOM   1035  CD1 LEU   122      20.590  28.382  90.761  1.00104.35           C  
ATOM   1036  CD2 LEU   122      20.914  30.004  92.641  1.00 57.43           C  
END
