
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  160 ( 1252),  selected  160 , name 2p6n_A
# Molecule2: number of CA atoms  161 ( 1246),  selected  161 , name T0493.pdb
# PARAMETERS: 2p6n_A.T0493.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       3           -
LGA    -       -      S       4           -
LGA    -       -      Y       5           -
LGA    -       -      R       6           -
LGA    -       -      S       7           -
LGA    -       -      T       8           -
LGA    -       -      Q       9           -
LGA    -       -      Q      10           -
LGA    -       -      I      11           -
LGA    L   406_A      T      12          1.091
LGA    -       -      D      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      K      16           -
LGA    -       -      E      17           -
LGA    -       -      I      18           -
LGA    -       -      L      19           -
LGA    -       -      V      20           -
LGA    -       -      N      21           -
LGA    D   407_A      R      30           #
LGA    V   408_A      Q      31           #
LGA    -       -      G      32           -
LGA    -       -      D      33           -
LGA    I   409_A      L      34          2.541
LGA    Q   410_A      P      35          0.559
LGA    E   411_A      N      36          0.324
LGA    V   412_A      V      37          0.769
LGA    E   413_A      V      38          1.404
LGA    Y   414_A      V      39          1.219
LGA    V   415_A      T      40          0.937
LGA    K   416_A      P      41          1.910
LGA    E   417_A      N      42          3.076
LGA    E   418_A      F      43          2.876
LGA    A   419_A      E      44          3.221
LGA    -       -      A      45           -
LGA    K   420_A      G      46          1.221
LGA    M   421_A      V      47          1.833
LGA    V   422_A      D      48          2.426
LGA    Y   423_A      Q      49          2.405
LGA    L   424_A      V      50          1.731
LGA    L   425_A      V      51          1.344
LGA    E   426_A      D      52          1.644
LGA    C   427_A      Q      53          1.865
LGA    L   428_A      L      54          1.098
LGA    Q   429_A      A      55          1.210
LGA    K   430_A      M      56          1.604
LGA    T   431_A      N      57          0.741
LGA    P   432_A      D      58          1.860
LGA    P   433_A      S      59           -
LGA    -       -      E      60           -
LGA    -       -      R      61           -
LGA    -       -      D      62           -
LGA    P   434_A      T      63          1.885
LGA    V   435_A      T      64          1.337
LGA    L   436_A      A      65          1.040
LGA    I   437_A      I      66          0.942
LGA    F   438_A      I      67          1.447
LGA    A   439_A      G      68          1.475
LGA    E   440_A      K      69          1.512
LGA    K   441_A      S      70          2.484
LGA    K   442_A      L      71          1.734
LGA    A   443_A      A      72          1.881
LGA    D   444_A      E      73          1.694
LGA    V   445_A      C      74          0.617
LGA    D   446_A      E      75          0.924
LGA    A   447_A      A      76          1.847
LGA    I   448_A      L      77          1.678
LGA    H   449_A      T      78          1.618
LGA    E   450_A      K      79          2.105
LGA    Y   451_A      A      80          2.409
LGA    L   452_A      L      81          2.271
LGA    L   453_A      K      82          2.376
LGA    L   454_A      A      83          2.931
LGA    K   455_A      R      84          2.744
LGA    G   456_A      G      85          2.859
LGA    V   457_A      E      86          2.198
LGA    E   458_A      Q      87          2.491
LGA    A   459_A      V      88          1.643
LGA    V   460_A      T      89          0.752
LGA    A   461_A      L      90          0.985
LGA    I   462_A      I      91          2.774
LGA    H   463_A      -       -           -
LGA    G   464_A      -       -           -
LGA    G   465_A      -       -           -
LGA    K   466_A      -       -           -
LGA    D   467_A      -       -           -
LGA    Q   468_A      -       -           -
LGA    E   469_A      -       -           -
LGA    E   470_A      Q      92          5.036
LGA    R   471_A      T      93          3.126
LGA    T   472_A      E      94           #
LGA    -       -      N      95           -
LGA    K   473_A      R      97          2.397
LGA    A   474_A      L      98           #
LGA    I   475_A      -       -           -
LGA    E   476_A      -       -           -
LGA    A   477_A      -       -           -
LGA    F   478_A      -       -           -
LGA    R   479_A      -       -           -
LGA    E   480_A      -       -           -
LGA    G   481_A      -       -           -
LGA    K   482_A      A      99          5.057
LGA    K   483_A      P     100          0.956
LGA    D   484_A      G     101          2.137
LGA    V   485_A      V     102          1.452
LGA    L   486_A      I     103          0.970
LGA    V   487_A      V     104          0.533
LGA    A   488_A      V     105          1.318
LGA    T   489_A      P     106          1.349
LGA    D   490_A      S     107          0.862
LGA    V   491_A      F     108          0.984
LGA    A   492_A      L     109          1.940
LGA    S   493_A      A     110          1.654
LGA    K   494_A      K     111          1.452
LGA    G   495_A      G     112          2.369
LGA    L   496_A      L     113          4.051
LGA    D   497_A      -       -           -
LGA    F   498_A      E     114          4.658
LGA    P   499_A      -       -           -
LGA    A   500_A      F     115          4.579
LGA    I   501_A      D     116          1.908
LGA    Q   502_A      -       -           -
LGA    H   503_A      A     117          2.202
LGA    V   504_A      V     118          1.044
LGA    I   505_A      I     119          0.925
LGA    N   506_A      V     120          1.038
LGA    Y   507_A      W     121          1.263
LGA    D   508_A      N     122          2.005
LGA    M   509_A      A     123          1.532
LGA    -       -      N     124           -
LGA    -       -      Q     125           -
LGA    -       -      E     126           -
LGA    -       -      N     127           -
LGA    P   510_A      Y     128          3.476
LGA    -       -      Q     129           -
LGA    -       -      R     130           -
LGA    -       -      E     131           -
LGA    E   511_A      D     132           #
LGA    E   512_A      E     133          3.276
LGA    I   513_A      R     134          3.617
LGA    E   514_A      Q     135          3.462
LGA    N   515_A      L     136          2.986
LGA    Y   516_A      L     137          2.974
LGA    V   517_A      Y     138          2.897
LGA    H   518_A      T     139          2.128
LGA    R   519_A      I     140          1.923
LGA    I   520_A      C     141          2.286
LGA    G   521_A      S     142          1.639
LGA    R   522_A      R     143          1.540
LGA    T   523_A      A     144          1.941
LGA    G   524_A      M     145          2.058
LGA    C   525_A      -       -           -
LGA    T   529_A      -       -           -
LGA    G   530_A      H     146          2.489
LGA    I   531_A      E     147          2.024
LGA    A   532_A      L     148          1.249
LGA    T   533_A      T     149          1.309
LGA    T   534_A      L     150          0.984
LGA    F   535_A      V     151          1.988
LGA    I   536_A      A     152          2.983
LGA    -       -      V     153           -
LGA    N   537_A      G     154          3.090
LGA    K   538_A      S     155          3.047
LGA    A   539_A      L     156           #
LGA    C   540_A      S     157          3.412
LGA    D   541_A      P     158          3.517
LGA    E   542_A      -       -           -
LGA    S   543_A      -       -           -
LGA    V   544_A      L     159          1.040
LGA    L   545_A      L     160          3.235
LGA    M   546_A      A     161          1.601
LGA    D   547_A      R     162          2.267
LGA    L   548_A      V     163          3.546
LGA    K   549_A      -       -           -
LGA    A   550_A      -       -           -
LGA    L   551_A      N     164          4.227
LGA    L   552_A      H     165          4.360
LGA    L   553_A      A     166          2.903
LGA    E   554_A      -       -           -
LGA    A   555_A      -       -           -
LGA    K   556_A      L     167          3.469
LGA    Q   557_A      Y     168          3.000
LGA    K   558_A      T     169          2.633
LGA    V   559_A      L     170          4.495
LGA    P   560_A      N     171          5.020
LGA    P   561_A      E     172           #
LGA    V   562_A      -       -           -
LGA    L   563_A      -       -           -
LGA    Q   564_A      -       -           -
LGA    V   565_A      -       -           -
LGA    L   566_A      -       -           -
LGA    H   567_A      -       -           -
LGA    C   568_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  160  161    5.0    120    2.39    15.83     51.818     4.825

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.680383 * X  +   0.553221 * Y  +   0.480651 * Z  + -77.701920
  Y_new =  -0.718264 * X  +  -0.373151 * Y  +  -0.587243 * Z  + 163.643082
  Z_new =  -0.145520 * X  +  -0.744785 * Y  +   0.651244 * Z  + -97.034866 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.852303    2.289290  [ DEG:   -48.8334    131.1666 ]
  Theta =   0.146038    2.995554  [ DEG:     8.3674    171.6326 ]
  Phi   =  -2.329117    0.812476  [ DEG:  -133.4486     46.5514 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p6n_A                                        
REMARK     2: T0493.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p6n_A.T0493.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  160  161   5.0  120   2.39   15.83  51.818
REMARK  ---------------------------------------------------------- 
MOLECULE 2p6n_A
HEADER    HYDROLASE                               19-MAR-07   2P6N              
TITLE     HUMAN DEAD-BOX RNA HELICASE DDX41, HELICASE DOMAIN                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ATP-DEPENDENT RNA HELICASE DDX41;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: HELICASE DOMAIN;                                           
COMPND   5 SYNONYM: DEAD BOX PROTEIN 41, DEAD BOX PROTEIN ABSTRAKT              
COMPND   6 HOMOLOG;                                                             
COMPND   7 EC: 3.6.1.-;                                                         
COMPND   8 ENGINEERED: YES;                                                     
COMPND   9 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: DDX41, ABS;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) GOLD PRARE2;                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC-BSA4                                 
KEYWDS    RNA, HELICASE, DEAD, STRUCTURAL GENOMICS, STRUCTURAL                  
KEYWDS   2 GENOMICS CONSORTIUM, SGC                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.KARLBERG,D.OGG,C.H.ARROWSMITH,H.BERGLUND,R.D.BUSAM,                 
AUTHOR   2 R.COLLINS,L.G.DAHLGREN,A.EDWARDS,S.FLODIN,A.FLORES,                  
AUTHOR   3 S.GRASLUND,B.M.HALLBERG,M.HAMMARSTROM,I.JOHANSSON,                   
AUTHOR   4 T.KOTENYOVA,L.LEHTIO,M.MOCHE,P.NORDLUND,T.NYMAN,C.PERSSON,           
AUTHOR   5 J.SAGEMARK,P.STENMARK,M.SUNDSTROM,A.G.THORSELL,S.VAN DEN             
AUTHOR   6 BERG,J.WEIGELT,L.HOLMBERG-SCHIAVONE,STRUCTURAL GENOMICS              
AUTHOR   7 CONSORTIUM (SGC)                                                     
REVDAT   1   03-APR-07 2P6N    0                                                
JRNL        AUTH   T.KARLBERG,D.OGG,C.H.ARROWSMITH,H.BERGLUND,                  
JRNL        AUTH 2 R.D.BUSAM,R.COLLINS,L.G.DAHLGREN,A.EDWARDS,                  
JRNL        AUTH 3 S.FLODIN,A.FLORES,S.GRASLUND,B.M.HALLBERG,                   
JRNL        AUTH 4 M.HAMMARSTROM,I.JOHANSSON,T.KOTENYOVA,L.LEHTIO,              
JRNL        AUTH 5 M.MOCHE,P.NORDLUND,T.NYMAN,C.PERSSON,J.SAGEMARK,             
JRNL        AUTH 6 P.STENMARK,M.SUNDSTROM,A.G.THORSELL,S.VAN DEN BERG,          
JRNL        AUTH 7 J.WEIGELT,L.HOLMBERG-SCHIAVONE                               
JRNL        TITL   HUMAN DEAD-BOX RNA HELICASE DDX41                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2P6N A  402   569  UNP    Q9UJV9   DDX41_HUMAN    402    569             
DBREF  2P6N B  402   569  UNP    Q9UJV9   DDX41_HUMAN    402    569             
SEQRES   1 A  191  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  191  GLY THR GLU ASN LEU TYR PHE GLN SER MET GLY ALA ALA          
SEQRES   3 A  191  SER LEU ASP VAL ILE GLN GLU VAL GLU TYR VAL LYS GLU          
SEQRES   4 A  191  GLU ALA LYS MET VAL TYR LEU LEU GLU CYS LEU GLN LYS          
SEQRES   5 A  191  THR PRO PRO PRO VAL LEU ILE PHE ALA GLU LYS LYS ALA          
SEQRES   6 A  191  ASP VAL ASP ALA ILE HIS GLU TYR LEU LEU LEU LYS GLY          
SEQRES   7 A  191  VAL GLU ALA VAL ALA ILE HIS GLY GLY LYS ASP GLN GLU          
SEQRES   8 A  191  GLU ARG THR LYS ALA ILE GLU ALA PHE ARG GLU GLY LYS          
SEQRES   9 A  191  LYS ASP VAL LEU VAL ALA THR ASP VAL ALA SER LYS GLY          
SEQRES  10 A  191  LEU ASP PHE PRO ALA ILE GLN HIS VAL ILE ASN TYR ASP          
SEQRES  11 A  191  MET PRO GLU GLU ILE GLU ASN TYR VAL HIS ARG ILE GLY          
SEQRES  12 A  191  ARG THR GLY CYS SER GLY ASN THR GLY ILE ALA THR THR          
SEQRES  13 A  191  PHE ILE ASN LYS ALA CYS ASP GLU SER VAL LEU MET ASP          
SEQRES  14 A  191  LEU LYS ALA LEU LEU LEU GLU ALA LYS GLN LYS VAL PRO          
SEQRES  15 A  191  PRO VAL LEU GLN VAL LEU HIS CYS GLY                          
SEQRES   1 B  191  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  191  GLY THR GLU ASN LEU TYR PHE GLN SER MET GLY ALA ALA          
SEQRES   3 B  191  SER LEU ASP VAL ILE GLN GLU VAL GLU TYR VAL LYS GLU          
SEQRES   4 B  191  GLU ALA LYS MET VAL TYR LEU LEU GLU CYS LEU GLN LYS          
SEQRES   5 B  191  THR PRO PRO PRO VAL LEU ILE PHE ALA GLU LYS LYS ALA          
SEQRES   6 B  191  ASP VAL ASP ALA ILE HIS GLU TYR LEU LEU LEU LYS GLY          
SEQRES   7 B  191  VAL GLU ALA VAL ALA ILE HIS GLY GLY LYS ASP GLN GLU          
SEQRES   8 B  191  GLU ARG THR LYS ALA ILE GLU ALA PHE ARG GLU GLY LYS          
SEQRES   9 B  191  LYS ASP VAL LEU VAL ALA THR ASP VAL ALA SER LYS GLY          
SEQRES  10 B  191  LEU ASP PHE PRO ALA ILE GLN HIS VAL ILE ASN TYR ASP          
SEQRES  11 B  191  MET PRO GLU GLU ILE GLU ASN TYR VAL HIS ARG ILE GLY          
SEQRES  12 B  191  ARG THR GLY CYS SER GLY ASN THR GLY ILE ALA THR THR          
SEQRES  13 B  191  PHE ILE ASN LYS ALA CYS ASP GLU SER VAL LEU MET ASP          
SEQRES  14 B  191  LEU LYS ALA LEU LEU LEU GLU ALA LYS GLN LYS VAL PRO          
SEQRES  15 B  191  PRO VAL LEU GLN VAL LEU HIS CYS GLY                          
CRYST1   68.013   68.013  305.604  90.00  90.00 120.00 P 65 2 2     24          
ATOM      1  N   LEU A 406      29.157  48.220  -0.357  1.00 63.96           N  
ATOM      2  CA  LEU A 406      28.886  46.789  -0.034  1.00 63.59           C  
ATOM      3  C   LEU A 406      29.865  45.852  -0.779  1.00 63.68           C  
ATOM      4  O   LEU A 406      30.192  44.778  -0.261  1.00 64.72           O  
ATOM      5  CB  LEU A 406      27.407  46.415  -0.338  1.00 63.72           C  
ATOM      6  CG  LEU A 406      26.660  45.528   0.695  1.00 63.50           C  
ATOM      7  CD1 LEU A 406      25.272  45.095   0.193  1.00 62.61           C  
ATOM      8  CD2 LEU A 406      27.502  44.317   1.131  1.00 62.27           C  
ATOM      9  N   ASP A 407      30.319  46.238  -1.979  1.00 62.89           N  
ATOM     10  CA  ASP A 407      31.171  45.367  -2.798  1.00 62.10           C  
ATOM     11  C   ASP A 407      32.497  46.054  -3.182  1.00 61.84           C  
ATOM     12  O   ASP A 407      32.731  46.443  -4.342  1.00 62.13           O  
ATOM     13  CB  ASP A 407      30.373  44.840  -3.992  1.00 62.40           C  
ATOM     14  CG  ASP A 407      29.249  43.855  -3.556  1.00 62.72           C  
ATOM     15  OD1 ASP A 407      28.416  44.218  -2.690  1.00 62.89           O  
ATOM     16  OD2 ASP A 407      29.200  42.712  -4.069  1.00 62.35           O  
ATOM     17  N   VAL A 408      33.332  46.190  -2.137  1.00 60.71           N  
ATOM     18  CA  VAL A 408      34.703  46.747  -2.133  1.00 59.75           C  
ATOM     19  C   VAL A 408      35.591  45.930  -1.144  1.00 58.77           C  
ATOM     20  O   VAL A 408      35.074  45.399  -0.152  1.00 58.50           O  
ATOM     21  CB  VAL A 408      34.713  48.248  -1.652  1.00 60.01           C  
ATOM     22  CG1 VAL A 408      33.759  48.475  -0.470  1.00 59.86           C  
ATOM     23  CG2 VAL A 408      36.126  48.688  -1.252  1.00 59.99           C  
ATOM     24  N   ILE A 409      36.904  45.825  -1.385  1.00 57.37           N  
ATOM     25  CA  ILE A 409      37.747  45.126  -0.417  1.00 56.88           C  
ATOM     26  C   ILE A 409      38.278  46.120   0.611  1.00 55.56           C  
ATOM     27  O   ILE A 409      39.104  46.962   0.296  1.00 54.86           O  
ATOM     28  CB  ILE A 409      38.853  44.187  -1.033  1.00 56.66           C  
ATOM     29  CG1 ILE A 409      39.809  44.883  -1.992  1.00 57.27           C  
ATOM     30  CG2 ILE A 409      38.217  42.998  -1.789  1.00 55.78           C  
ATOM     31  CD1 ILE A 409      40.537  43.840  -2.925  1.00 56.81           C  
ATOM     32  N   GLN A 410      37.726  46.028   1.826  1.00 54.71           N  
ATOM     33  CA  GLN A 410      38.085  46.902   2.955  1.00 54.77           C  
ATOM     34  C   GLN A 410      39.290  46.368   3.720  1.00 54.94           C  
ATOM     35  O   GLN A 410      39.269  45.244   4.214  1.00 54.95           O  
ATOM     36  CB  GLN A 410      36.942  47.033   3.963  1.00 54.32           C  
ATOM     37  CG  GLN A 410      35.677  47.523   3.398  1.00 52.99           C  
ATOM     38  CD  GLN A 410      34.578  47.449   4.401  1.00 51.92           C  
ATOM     39  OE1 GLN A 410      33.629  46.697   4.227  1.00 49.25           O  
ATOM     40  NE2 GLN A 410      34.704  48.208   5.476  1.00 51.93           N  
ATOM     41  N   GLU A 411      40.313  47.205   3.823  1.00 55.65           N  
ATOM     42  CA  GLU A 411      41.601  46.851   4.412  1.00 56.13           C  
ATOM     43  C   GLU A 411      41.789  47.889   5.518  1.00 56.79           C  
ATOM     44  O   GLU A 411      42.150  49.029   5.258  1.00 57.44           O  
ATOM     45  CB  GLU A 411      42.744  46.880   3.346  1.00 56.27           C  
ATOM     46  CG  GLU A 411      42.648  45.733   2.238  1.00 55.44           C  
ATOM     47  CD  GLU A 411      43.934  45.508   1.376  1.00 55.41           C  
ATOM     48  OE1 GLU A 411      44.808  46.389   1.286  1.00 54.95           O  
ATOM     49  OE2 GLU A 411      44.061  44.432   0.758  1.00 55.15           O  
ATOM     50  N   VAL A 412      41.448  47.505   6.739  1.00 57.49           N  
ATOM     51  CA  VAL A 412      41.500  48.390   7.908  1.00 57.90           C  
ATOM     52  C   VAL A 412      42.764  48.062   8.691  1.00 58.06           C  
ATOM     53  O   VAL A 412      43.073  46.903   8.889  1.00 57.88           O  
ATOM     54  CB  VAL A 412      40.272  48.164   8.810  1.00 58.56           C  
ATOM     55  CG1 VAL A 412      40.434  48.914  10.164  1.00 58.07           C  
ATOM     56  CG2 VAL A 412      38.939  48.507   8.040  1.00 55.93           C  
ATOM     57  N   GLU A 413      43.496  49.085   9.129  1.00 58.94           N  
ATOM     58  CA  GLU A 413      44.867  48.897   9.665  1.00 59.32           C  
ATOM     59  C   GLU A 413      45.160  49.867  10.823  1.00 58.80           C  
ATOM     60  O   GLU A 413      44.721  51.036  10.793  1.00 58.79           O  
ATOM     61  CB  GLU A 413      45.853  49.131   8.533  1.00 59.91           C  
ATOM     62  CG  GLU A 413      47.213  48.597   8.775  1.00 62.89           C  
ATOM     63  CD  GLU A 413      47.451  47.208   8.210  1.00 67.37           C  
ATOM     64  OE1 GLU A 413      46.607  46.675   7.449  1.00 70.33           O  
ATOM     65  OE2 GLU A 413      48.525  46.645   8.529  1.00 70.54           O  
ATOM     66  N   TYR A 414      45.870  49.382  11.851  1.00 58.06           N  
ATOM     67  CA  TYR A 414      46.244  50.222  12.994  1.00 57.30           C  
ATOM     68  C   TYR A 414      47.471  50.986  12.621  1.00 56.70           C  
ATOM     69  O   TYR A 414      48.465  50.383  12.290  1.00 56.08           O  
ATOM     70  CB  TYR A 414      46.543  49.396  14.245  1.00 57.74           C  
ATOM     71  CG  TYR A 414      46.627  50.223  15.514  1.00 57.59           C  
ATOM     72  CD1 TYR A 414      47.750  50.986  15.818  1.00 58.37           C  
ATOM     73  CD2 TYR A 414      45.573  50.255  16.397  1.00 58.71           C  
ATOM     74  CE1 TYR A 414      47.814  51.754  16.991  1.00 58.59           C  
ATOM     75  CE2 TYR A 414      45.623  51.008  17.566  1.00 59.52           C  
ATOM     76  CZ  TYR A 414      46.737  51.757  17.865  1.00 59.22           C  
ATOM     77  OH  TYR A 414      46.734  52.499  19.046  1.00 58.12           O  
ATOM     78  N   VAL A 415      47.400  52.313  12.673  1.00 56.18           N  
ATOM     79  CA  VAL A 415      48.535  53.145  12.329  1.00 55.96           C  
ATOM     80  C   VAL A 415      48.589  54.253  13.346  1.00 56.21           C  
ATOM     81  O   VAL A 415      47.633  55.003  13.477  1.00 56.18           O  
ATOM     82  CB  VAL A 415      48.351  53.781  10.950  1.00 56.07           C  
ATOM     83  CG1 VAL A 415      49.563  54.603  10.575  1.00 56.76           C  
ATOM     84  CG2 VAL A 415      48.077  52.725   9.929  1.00 56.63           C  
ATOM     85  N   LYS A 416      49.693  54.356  14.088  1.00 56.58           N  
ATOM     86  CA  LYS A 416      49.865  55.466  15.034  1.00 56.23           C  
ATOM     87  C   LYS A 416      49.814  56.753  14.225  1.00 55.74           C  
ATOM     88  O   LYS A 416      50.300  56.804  13.091  1.00 56.06           O  
ATOM     89  CB  LYS A 416      51.181  55.352  15.871  1.00 56.41           C  
ATOM     90  CG  LYS A 416      50.973  54.757  17.301  1.00 56.23           C  
ATOM     91  CD  LYS A 416      52.232  54.661  18.181  1.00 56.34           C  
ATOM     92  CE  LYS A 416      51.860  54.336  19.649  1.00 56.07           C  
ATOM     93  NZ  LYS A 416      52.981  54.611  20.598  1.00 55.23           N  
ATOM     94  N   GLU A 417      49.203  57.775  14.804  1.00 55.37           N  
ATOM     95  CA  GLU A 417      49.048  59.088  14.174  1.00 55.31           C  
ATOM     96  C   GLU A 417      50.348  59.567  13.574  1.00 54.90           C  
ATOM     97  O   GLU A 417      50.397  60.030  12.454  1.00 55.63           O  
ATOM     98  CB  GLU A 417      48.556  60.090  15.233  1.00 55.42           C  
ATOM     99  CG  GLU A 417      48.024  61.374  14.693  1.00 57.05           C  
ATOM    100  CD  GLU A 417      46.882  61.194  13.695  1.00 60.04           C  
ATOM    101  OE1 GLU A 417      46.219  60.123  13.725  1.00 60.98           O  
ATOM    102  OE2 GLU A 417      46.657  62.130  12.879  1.00 60.92           O  
ATOM    103  N   GLU A 418      51.417  59.388  14.328  1.00 54.83           N  
ATOM    104  CA  GLU A 418      52.747  59.839  13.947  1.00 54.71           C  
ATOM    105  C   GLU A 418      53.384  58.957  12.867  1.00 53.56           C  
ATOM    106  O   GLU A 418      54.503  59.183  12.477  1.00 52.38           O  
ATOM    107  CB  GLU A 418      53.663  59.895  15.192  1.00 55.11           C  
ATOM    108  CG  GLU A 418      53.101  60.699  16.404  1.00 57.91           C  
ATOM    109  CD  GLU A 418      52.151  59.896  17.336  1.00 61.75           C  
ATOM    110  OE1 GLU A 418      52.132  58.640  17.283  1.00 64.96           O  
ATOM    111  OE2 GLU A 418      51.420  60.529  18.136  1.00 63.83           O  
ATOM    112  N   ALA A 419      52.681  57.952  12.379  1.00 53.45           N  
ATOM    113  CA  ALA A 419      53.242  57.082  11.358  1.00 53.51           C  
ATOM    114  C   ALA A 419      52.432  57.072  10.057  1.00 53.18           C  
ATOM    115  O   ALA A 419      52.831  56.437   9.085  1.00 52.77           O  
ATOM    116  CB  ALA A 419      53.360  55.679  11.916  1.00 53.28           C  
ATOM    117  N   LYS A 420      51.308  57.771  10.024  1.00 53.36           N  
ATOM    118  CA  LYS A 420      50.409  57.664   8.864  1.00 54.20           C  
ATOM    119  C   LYS A 420      50.975  58.217   7.573  1.00 54.20           C  
ATOM    120  O   LYS A 420      50.723  57.703   6.483  1.00 55.11           O  
ATOM    121  CB  LYS A 420      49.116  58.412   9.132  1.00 54.42           C  
ATOM    122  CG  LYS A 420      48.228  57.818  10.208  1.00 55.02           C  
ATOM    123  CD  LYS A 420      47.134  58.803  10.513  1.00 55.11           C  
ATOM    124  CE  LYS A 420      45.991  58.207  11.298  1.00 56.05           C  
ATOM    125  NZ  LYS A 420      44.873  59.216  11.384  1.00 54.36           N  
ATOM    126  N   MET A 421      51.708  59.301   7.674  1.00 54.77           N  
ATOM    127  CA  MET A 421      52.137  59.956   6.481  1.00 55.91           C  
ATOM    128  C   MET A 421      53.026  59.003   5.692  1.00 56.28           C  
ATOM    129  O   MET A 421      52.822  58.787   4.500  1.00 57.08           O  
ATOM    130  CB  MET A 421      52.846  61.274   6.795  1.00 56.14           C  
ATOM    131  CG  MET A 421      52.393  62.375   5.820  1.00 58.18           C  
ATOM    132  SD  MET A 421      50.731  62.992   6.163  1.00 57.86           S  
ATOM    133  CE  MET A 421      51.021  64.680   6.637  1.00 56.43           C  
ATOM    134  N   VAL A 422      53.986  58.406   6.366  1.00 56.50           N  
ATOM    135  CA  VAL A 422      54.871  57.467   5.713  1.00 56.89           C  
ATOM    136  C   VAL A 422      54.104  56.259   5.155  1.00 57.59           C  
ATOM    137  O   VAL A 422      54.284  55.850   4.016  1.00 57.79           O  
ATOM    138  CB  VAL A 422      55.961  57.011   6.696  1.00 56.81           C  
ATOM    139  CG1 VAL A 422      56.642  55.761   6.182  1.00 56.52           C  
ATOM    140  CG2 VAL A 422      56.948  58.140   6.898  1.00 54.78           C  
ATOM    141  N   TYR A 423      53.221  55.711   5.961  1.00 58.20           N  
ATOM    142  CA  TYR A 423      52.461  54.580   5.539  1.00 58.92           C  
ATOM    143  C   TYR A 423      51.600  54.895   4.342  1.00 59.86           C  
ATOM    144  O   TYR A 423      51.337  54.015   3.512  1.00 59.99           O  
ATOM    145  CB  TYR A 423      51.564  54.173   6.669  1.00 59.59           C  
ATOM    146  CG  TYR A 423      50.901  52.849   6.458  1.00 60.47           C  
ATOM    147  CD1 TYR A 423      49.554  52.709   6.653  1.00 60.10           C  
ATOM    148  CD2 TYR A 423      51.635  51.728   6.090  1.00 61.30           C  
ATOM    149  CE1 TYR A 423      48.933  51.504   6.461  1.00 60.74           C  
ATOM    150  CE2 TYR A 423      51.032  50.514   5.915  1.00 61.01           C  
ATOM    151  CZ  TYR A 423      49.667  50.412   6.098  1.00 61.38           C  
ATOM    152  OH  TYR A 423      49.017  49.207   5.927  1.00 62.37           O  
ATOM    153  N   LEU A 424      51.134  56.144   4.272  1.00 60.19           N  
ATOM    154  CA  LEU A 424      50.239  56.554   3.209  1.00 60.27           C  
ATOM    155  C   LEU A 424      50.927  56.391   1.875  1.00 60.36           C  
ATOM    156  O   LEU A 424      50.337  55.872   0.929  1.00 60.34           O  
ATOM    157  CB  LEU A 424      49.853  58.010   3.402  1.00 60.31           C  
ATOM    158  CG  LEU A 424      48.841  58.552   2.412  1.00 59.36           C  
ATOM    159  CD1 LEU A 424      47.512  57.936   2.658  1.00 58.53           C  
ATOM    160  CD2 LEU A 424      48.773  60.029   2.588  1.00 59.31           C  
ATOM    161  N   LEU A 425      52.174  56.856   1.807  1.00 60.73           N  
ATOM    162  CA  LEU A 425      52.969  56.721   0.598  1.00 61.15           C  
ATOM    163  C   LEU A 425      52.924  55.275   0.178  1.00 62.02           C  
ATOM    164  O   LEU A 425      52.484  54.968  -0.919  1.00 63.00           O  
ATOM    165  CB  LEU A 425      54.420  57.098   0.823  1.00 60.76           C  
ATOM    166  CG  LEU A 425      54.854  58.520   0.546  1.00 60.51           C  
ATOM    167  CD1 LEU A 425      56.400  58.605   0.630  1.00 57.04           C  
ATOM    168  CD2 LEU A 425      54.329  58.986  -0.800  1.00 59.29           C  
ATOM    169  N   GLU A 426      53.338  54.381   1.066  1.00 62.42           N  
ATOM    170  CA  GLU A 426      53.309  52.943   0.770  1.00 63.17           C  
ATOM    171  C   GLU A 426      51.943  52.471   0.255  1.00 62.27           C  
ATOM    172  O   GLU A 426      51.866  51.715  -0.718  1.00 61.74           O  
ATOM    173  CB  GLU A 426      53.727  52.114   1.998  1.00 63.14           C  
ATOM    174  CG  GLU A 426      55.236  52.131   2.254  1.00 64.92           C  
ATOM    175  CD  GLU A 426      55.657  51.582   3.647  1.00 65.83           C  
ATOM    176  OE1 GLU A 426      54.903  50.789   4.273  1.00 69.34           O  
ATOM    177  OE2 GLU A 426      56.774  51.942   4.109  1.00 70.00           O  
ATOM    178  N   CYS A 427      50.874  52.926   0.899  1.00 61.87           N  
ATOM    179  CA  CYS A 427      49.537  52.536   0.486  1.00 61.91           C  
ATOM    180  C   CYS A 427      49.233  52.894  -0.967  1.00 61.61           C  
ATOM    181  O   CYS A 427      48.724  52.059  -1.703  1.00 61.58           O  
ATOM    182  CB  CYS A 427      48.503  53.143   1.403  1.00 62.00           C  
ATOM    183  SG  CYS A 427      48.538  52.350   2.955  1.00 63.67           S  
ATOM    184  N   LEU A 428      49.586  54.102  -1.401  1.00 61.17           N  
ATOM    185  CA  LEU A 428      49.228  54.523  -2.754  1.00 60.54           C  
ATOM    186  C   LEU A 428      49.512  53.428  -3.775  1.00 60.39           C  
ATOM    187  O   LEU A 428      48.812  53.320  -4.779  1.00 60.66           O  
ATOM    188  CB  LEU A 428      49.931  55.832  -3.133  1.00 60.31           C  
ATOM    189  CG  LEU A 428      49.539  57.066  -2.310  1.00 59.07           C  
ATOM    190  CD1 LEU A 428      50.470  58.220  -2.637  1.00 57.03           C  
ATOM    191  CD2 LEU A 428      48.099  57.429  -2.549  1.00 56.92           C  
ATOM    192  N   GLN A 429      50.483  52.572  -3.482  1.00 60.37           N  
ATOM    193  CA  GLN A 429      50.890  51.509  -4.413  1.00 60.74           C  
ATOM    194  C   GLN A 429      50.018  50.228  -4.483  1.00 60.55           C  
ATOM    195  O   GLN A 429      50.357  49.328  -5.258  1.00 60.71           O  
ATOM    196  CB  GLN A 429      52.339  51.080  -4.111  1.00 61.02           C  
ATOM    197  CG  GLN A 429      53.391  52.188  -4.239  1.00 62.44           C  
ATOM    198  CD  GLN A 429      54.316  51.995  -5.431  1.00 64.73           C  
ATOM    199  OE1 GLN A 429      54.448  50.895  -5.975  1.00 67.59           O  
ATOM    200  NE2 GLN A 429      54.983  53.068  -5.838  1.00 66.02           N  
ATOM    201  N   LYS A 430      48.923  50.105  -3.728  1.00 60.04           N  
ATOM    202  CA  LYS A 430      48.098  48.879  -3.858  1.00 60.28           C  
ATOM    203  C   LYS A 430      47.297  48.836  -5.166  1.00 59.16           C  
ATOM    204  O   LYS A 430      46.595  47.875  -5.430  1.00 58.75           O  
ATOM    205  CB  LYS A 430      47.095  48.732  -2.717  1.00 60.21           C  
ATOM    206  CG  LYS A 430      47.671  48.714  -1.334  1.00 61.65           C  
ATOM    207  CD  LYS A 430      46.527  48.606  -0.304  1.00 61.89           C  
ATOM    208  CE  LYS A 430      47.023  48.369   1.131  1.00 62.14           C  
ATOM    209  NZ  LYS A 430      45.874  48.537   2.082  1.00 62.86           N  
ATOM    210  N   THR A 431      47.428  49.876  -5.975  1.00 58.58           N  
ATOM    211  CA  THR A 431      46.416  50.235  -6.935  1.00 57.98           C  
ATOM    212  C   THR A 431      46.989  51.197  -7.943  1.00 57.55           C  
ATOM    213  O   THR A 431      47.780  52.070  -7.595  1.00 57.08           O  
ATOM    214  CB  THR A 431      45.289  50.963  -6.208  1.00 58.06           C  
ATOM    215  OG1 THR A 431      44.419  50.016  -5.584  1.00 58.72           O  
ATOM    216  CG2 THR A 431      44.506  51.793  -7.124  1.00 57.78           C  
ATOM    217  N   PRO A 432      46.598  51.044  -9.204  1.00 57.23           N  
ATOM    218  CA  PRO A 432      46.834  52.141 -10.113  1.00 57.18           C  
ATOM    219  C   PRO A 432      45.873  53.265  -9.756  1.00 57.00           C  
ATOM    220  O   PRO A 432      44.880  53.019  -9.076  1.00 56.94           O  
ATOM    221  CB  PRO A 432      46.456  51.560 -11.469  1.00 57.18           C  
ATOM    222  CG  PRO A 432      45.457  50.521 -11.165  1.00 57.33           C  
ATOM    223  CD  PRO A 432      45.921  49.922  -9.869  1.00 57.75           C  
ATOM    224  N   PRO A 433      46.144  54.490 -10.228  1.00 56.52           N  
ATOM    225  CA  PRO A 433      45.211  55.565  -9.939  1.00 56.11           C  
ATOM    226  C   PRO A 433      43.882  55.319 -10.639  1.00 55.71           C  
ATOM    227  O   PRO A 433      43.766  54.413 -11.459  1.00 55.44           O  
ATOM    228  CB  PRO A 433      45.903  56.808 -10.505  1.00 56.25           C  
ATOM    229  CG  PRO A 433      47.278  56.403 -10.843  1.00 56.36           C  
ATOM    230  CD  PRO A 433      47.277  54.941 -11.044  1.00 56.35           C  
ATOM    231  N   PRO A 434      42.875  56.121 -10.321  1.00 55.49           N  
ATOM    232  CA  PRO A 434      42.879  57.259  -9.381  1.00 55.47           C  
ATOM    233  C   PRO A 434      42.606  56.880  -7.950  1.00 55.16           C  
ATOM    234  O   PRO A 434      41.840  55.939  -7.725  1.00 55.17           O  
ATOM    235  CB  PRO A 434      41.731  58.143  -9.878  1.00 55.18           C  
ATOM    236  CG  PRO A 434      41.032  57.309 -11.004  1.00 55.88           C  
ATOM    237  CD  PRO A 434      41.571  55.930 -10.964  1.00 55.06           C  
ATOM    238  N   VAL A 435      43.187  57.673  -7.029  1.00 55.30           N  
ATOM    239  CA  VAL A 435      43.091  57.523  -5.566  1.00 55.21           C  
ATOM    240  C   VAL A 435      42.484  58.757  -4.837  1.00 55.62           C  
ATOM    241  O   VAL A 435      42.902  59.895  -5.036  1.00 56.31           O  
ATOM    242  CB  VAL A 435      44.504  57.263  -4.963  1.00 55.52           C  
ATOM    243  CG1 VAL A 435      44.469  57.231  -3.406  1.00 54.54           C  
ATOM    244  CG2 VAL A 435      45.113  55.980  -5.557  1.00 54.15           C  
ATOM    245  N   LEU A 436      41.508  58.502  -3.976  1.00 56.00           N  
ATOM    246  CA  LEU A 436      40.856  59.532  -3.204  1.00 56.36           C  
ATOM    247  C   LEU A 436      41.265  59.351  -1.757  1.00 56.84           C  
ATOM    248  O   LEU A 436      41.003  58.276  -1.184  1.00 57.53           O  
ATOM    249  CB  LEU A 436      39.330  59.415  -3.342  1.00 56.59           C  
ATOM    250  CG  LEU A 436      38.460  60.502  -2.669  1.00 57.26           C  
ATOM    251  CD1 LEU A 436      38.734  61.894  -3.250  1.00 56.90           C  
ATOM    252  CD2 LEU A 436      36.977  60.134  -2.796  1.00 56.20           C  
ATOM    253  N   ILE A 437      41.922  60.358  -1.169  1.00 56.03           N  
ATOM    254  CA  ILE A 437      42.258  60.310   0.244  1.00 55.01           C  
ATOM    255  C   ILE A 437      41.332  61.256   0.972  1.00 54.53           C  
ATOM    256  O   ILE A 437      41.236  62.447   0.636  1.00 54.83           O  
ATOM    257  CB  ILE A 437      43.690  60.750   0.484  1.00 55.49           C  
ATOM    258  CG1 ILE A 437      44.654  59.941  -0.408  1.00 55.83           C  
ATOM    259  CG2 ILE A 437      44.038  60.614   1.957  1.00 54.03           C  
ATOM    260  CD1 ILE A 437      46.044  60.583  -0.531  1.00 55.17           C  
ATOM    261  N   PHE A 438      40.630  60.719   1.945  1.00 53.62           N  
ATOM    262  CA  PHE A 438      39.751  61.491   2.803  1.00 53.67           C  
ATOM    263  C   PHE A 438      40.356  61.778   4.191  1.00 53.28           C  
ATOM    264  O   PHE A 438      40.913  60.890   4.809  1.00 53.37           O  
ATOM    265  CB  PHE A 438      38.476  60.698   3.086  1.00 54.18           C  
ATOM    266  CG  PHE A 438      37.479  60.691   1.982  1.00 54.72           C  
ATOM    267  CD1 PHE A 438      36.793  61.849   1.636  1.00 55.27           C  
ATOM    268  CD2 PHE A 438      37.155  59.501   1.325  1.00 56.50           C  
ATOM    269  CE1 PHE A 438      35.831  61.840   0.634  1.00 55.47           C  
ATOM    270  CE2 PHE A 438      36.175  59.483   0.306  1.00 57.14           C  
ATOM    271  CZ  PHE A 438      35.507  60.660  -0.026  1.00 55.94           C  
ATOM    272  N   ALA A 439      40.187  62.996   4.693  1.00 53.21           N  
ATOM    273  CA  ALA A 439      40.541  63.350   6.068  1.00 53.30           C  
ATOM    274  C   ALA A 439      39.556  64.397   6.599  1.00 54.06           C  
ATOM    275  O   ALA A 439      39.126  65.297   5.852  1.00 54.88           O  
ATOM    276  CB  ALA A 439      41.928  63.878   6.104  1.00 52.84           C  
ATOM    277  N   GLU A 440      39.172  64.305   7.870  1.00 54.83           N  
ATOM    278  CA  GLU A 440      38.117  65.197   8.406  1.00 55.90           C  
ATOM    279  C   GLU A 440      38.493  66.689   8.353  1.00 55.75           C  
ATOM    280  O   GLU A 440      37.634  67.528   8.155  1.00 55.45           O  
ATOM    281  CB  GLU A 440      37.768  64.869   9.862  1.00 56.61           C  
ATOM    282  CG  GLU A 440      37.441  63.379  10.207  1.00 59.70           C  
ATOM    283  CD  GLU A 440      35.960  63.096  10.249  1.00 61.06           C  
ATOM    284  OE1 GLU A 440      35.324  63.487   9.266  1.00 63.15           O  
ATOM    285  OE2 GLU A 440      35.442  62.498  11.238  1.00 61.88           O  
ATOM    286  N   LYS A 441      39.776  67.000   8.554  1.00 55.97           N  
ATOM    287  CA  LYS A 441      40.234  68.362   8.809  1.00 55.37           C  
ATOM    288  C   LYS A 441      41.041  68.948   7.680  1.00 54.36           C  
ATOM    289  O   LYS A 441      41.775  68.248   6.986  1.00 53.47           O  
ATOM    290  CB  LYS A 441      41.101  68.376  10.069  1.00 55.38           C  
ATOM    291  CG  LYS A 441      40.387  67.891  11.319  1.00 56.44           C  
ATOM    292  CD  LYS A 441      41.386  67.580  12.476  1.00 56.78           C  
ATOM    293  CE  LYS A 441      40.835  66.566  13.496  1.00 57.14           C  
ATOM    294  NZ  LYS A 441      41.357  66.864  14.905  1.00 59.27           N  
ATOM    295  N   LYS A 442      40.937  70.265   7.556  1.00 54.05           N  
ATOM    296  CA  LYS A 442      41.536  71.018   6.448  1.00 54.01           C  
ATOM    297  C   LYS A 442      43.041  70.958   6.576  1.00 53.16           C  
ATOM    298  O   LYS A 442      43.745  70.595   5.632  1.00 52.41           O  
ATOM    299  CB  LYS A 442      41.046  72.483   6.463  1.00 53.47           C  
ATOM    300  CG  LYS A 442      39.534  72.592   6.253  1.00 55.30           C  
ATOM    301  CD  LYS A 442      39.043  74.000   5.859  1.00 55.22           C  
ATOM    302  CE  LYS A 442      38.378  74.706   7.029  1.00 56.06           C  
ATOM    303  NZ  LYS A 442      39.210  74.685   8.282  1.00 55.76           N  
ATOM    304  N   ALA A 443      43.511  71.330   7.762  1.00 52.70           N  
ATOM    305  CA  ALA A 443      44.908  71.194   8.141  1.00 52.71           C  
ATOM    306  C   ALA A 443      45.456  69.866   7.632  1.00 52.37           C  
ATOM    307  O   ALA A 443      46.500  69.831   6.986  1.00 52.12           O  
ATOM    308  CB  ALA A 443      45.059  71.285   9.652  1.00 52.27           C  
ATOM    309  N   ASP A 444      44.732  68.779   7.861  1.00 52.29           N  
ATOM    310  CA  ASP A 444      45.225  67.475   7.425  1.00 52.34           C  
ATOM    311  C   ASP A 444      45.315  67.383   5.935  1.00 52.48           C  
ATOM    312  O   ASP A 444      46.361  66.966   5.408  1.00 52.46           O  
ATOM    313  CB  ASP A 444      44.321  66.334   7.880  1.00 52.99           C  
ATOM    314  CG  ASP A 444      44.456  65.989   9.369  1.00 52.51           C  
ATOM    315  OD1 ASP A 444      45.521  66.235   9.981  1.00 52.33           O  
ATOM    316  OD2 ASP A 444      43.453  65.437   9.896  1.00 56.51           O  
ATOM    317  N   VAL A 445      44.210  67.730   5.255  1.00 52.33           N  
ATOM    318  CA  VAL A 445      44.136  67.635   3.783  1.00 51.62           C  
ATOM    319  C   VAL A 445      45.317  68.399   3.215  1.00 52.22           C  
ATOM    320  O   VAL A 445      46.042  67.884   2.345  1.00 52.44           O  
ATOM    321  CB  VAL A 445      42.770  68.155   3.208  1.00 51.50           C  
ATOM    322  CG1 VAL A 445      42.867  68.395   1.708  1.00 50.09           C  
ATOM    323  CG2 VAL A 445      41.624  67.175   3.546  1.00 49.25           C  
ATOM    324  N   ASP A 446      45.551  69.606   3.743  1.00 52.63           N  
ATOM    325  CA  ASP A 446      46.759  70.409   3.382  1.00 52.69           C  
ATOM    326  C   ASP A 446      48.102  69.671   3.638  1.00 52.47           C  
ATOM    327  O   ASP A 446      48.952  69.600   2.764  1.00 53.06           O  
ATOM    328  CB  ASP A 446      46.756  71.770   4.101  1.00 52.45           C  
ATOM    329  CG  ASP A 446      45.769  72.773   3.496  1.00 54.85           C  
ATOM    330  OD1 ASP A 446      45.414  72.652   2.291  1.00 56.96           O  
ATOM    331  OD2 ASP A 446      45.360  73.713   4.230  1.00 57.10           O  
ATOM    332  N   ALA A 447      48.291  69.103   4.820  1.00 52.38           N  
ATOM    333  CA  ALA A 447      49.537  68.331   5.124  1.00 52.22           C  
ATOM    334  C   ALA A 447      49.792  67.198   4.118  1.00 52.51           C  
ATOM    335  O   ALA A 447      50.906  67.061   3.585  1.00 51.71           O  
ATOM    336  CB  ALA A 447      49.466  67.760   6.528  1.00 50.80           C  
ATOM    337  N   ILE A 448      48.740  66.402   3.862  1.00 53.04           N  
ATOM    338  CA  ILE A 448      48.862  65.212   3.029  1.00 54.06           C  
ATOM    339  C   ILE A 448      49.205  65.625   1.597  1.00 55.02           C  
ATOM    340  O   ILE A 448      50.027  64.985   0.932  1.00 56.33           O  
ATOM    341  CB  ILE A 448      47.560  64.376   3.007  1.00 53.99           C  
ATOM    342  CG1 ILE A 448      47.257  63.810   4.398  1.00 54.17           C  
ATOM    343  CG2 ILE A 448      47.639  63.249   1.955  1.00 51.87           C  
ATOM    344  CD1 ILE A 448      45.797  63.330   4.548  1.00 54.79           C  
ATOM    345  N   HIS A 449      48.582  66.697   1.127  1.00 54.76           N  
ATOM    346  CA  HIS A 449      48.823  67.163  -0.219  1.00 54.95           C  
ATOM    347  C   HIS A 449      50.275  67.627  -0.328  1.00 55.03           C  
ATOM    348  O   HIS A 449      50.966  67.272  -1.267  1.00 55.30           O  
ATOM    349  CB  HIS A 449      47.802  68.268  -0.544  1.00 55.06           C  
ATOM    350  CG  HIS A 449      47.962  68.891  -1.890  1.00 54.44           C  
ATOM    351  ND1 HIS A 449      47.856  70.252  -2.087  1.00 53.70           N  
ATOM    352  CD2 HIS A 449      48.208  68.348  -3.103  1.00 54.88           C  
ATOM    353  CE1 HIS A 449      48.046  70.521  -3.367  1.00 53.58           C  
ATOM    354  NE2 HIS A 449      48.276  69.385  -4.003  1.00 54.73           N  
ATOM    355  N   GLU A 450      50.752  68.376   0.656  1.00 54.93           N  
ATOM    356  CA  GLU A 450      52.131  68.868   0.609  1.00 55.53           C  
ATOM    357  C   GLU A 450      53.129  67.746   0.675  1.00 54.11           C  
ATOM    358  O   GLU A 450      54.161  67.800   0.014  1.00 53.63           O  
ATOM    359  CB  GLU A 450      52.403  69.843   1.735  1.00 55.34           C  
ATOM    360  CG  GLU A 450      52.021  71.284   1.415  1.00 57.63           C  
ATOM    361  CD  GLU A 450      52.449  72.211   2.546  1.00 59.92           C  
ATOM    362  OE1 GLU A 450      53.448  72.973   2.361  1.00 64.30           O  
ATOM    363  OE2 GLU A 450      51.824  72.111   3.647  1.00 65.44           O  
ATOM    364  N   TYR A 451      52.816  66.732   1.474  1.00 53.56           N  
ATOM    365  CA  TYR A 451      53.694  65.589   1.605  1.00 53.09           C  
ATOM    366  C   TYR A 451      53.754  64.837   0.290  1.00 53.18           C  
ATOM    367  O   TYR A 451      54.844  64.550  -0.207  1.00 53.34           O  
ATOM    368  CB  TYR A 451      53.216  64.647   2.693  1.00 52.69           C  
ATOM    369  CG  TYR A 451      54.218  63.580   3.061  1.00 51.97           C  
ATOM    370  CD1 TYR A 451      55.459  63.914   3.621  1.00 52.69           C  
ATOM    371  CD2 TYR A 451      53.942  62.248   2.862  1.00 50.89           C  
ATOM    372  CE1 TYR A 451      56.377  62.933   3.972  1.00 51.65           C  
ATOM    373  CE2 TYR A 451      54.862  61.258   3.202  1.00 51.65           C  
ATOM    374  CZ  TYR A 451      56.068  61.598   3.760  1.00 51.93           C  
ATOM    375  OH  TYR A 451      56.964  60.595   4.106  1.00 51.47           O  
ATOM    376  N   LEU A 452      52.588  64.527  -0.273  1.00 52.92           N  
ATOM    377  CA  LEU A 452      52.522  63.780  -1.521  1.00 52.87           C  
ATOM    378  C   LEU A 452      53.317  64.502  -2.618  1.00 53.85           C  
ATOM    379  O   LEU A 452      54.037  63.864  -3.400  1.00 53.80           O  
ATOM    380  CB  LEU A 452      51.073  63.558  -1.933  1.00 52.38           C  
ATOM    381  CG  LEU A 452      50.371  62.458  -1.143  1.00 51.35           C  
ATOM    382  CD1 LEU A 452      48.949  62.312  -1.617  1.00 48.09           C  
ATOM    383  CD2 LEU A 452      51.136  61.109  -1.227  1.00 50.26           C  
ATOM    384  N   LEU A 453      53.212  65.836  -2.637  1.00 54.78           N  
ATOM    385  CA  LEU A 453      53.922  66.669  -3.604  1.00 55.27           C  
ATOM    386  C   LEU A 453      55.409  66.548  -3.378  1.00 55.93           C  
ATOM    387  O   LEU A 453      56.160  66.265  -4.310  1.00 56.26           O  
ATOM    388  CB  LEU A 453      53.499  68.148  -3.511  1.00 55.13           C  
ATOM    389  CG  LEU A 453      52.145  68.662  -4.050  1.00 55.17           C  
ATOM    390  CD1 LEU A 453      52.195  70.174  -4.205  1.00 54.03           C  
ATOM    391  CD2 LEU A 453      51.726  68.032  -5.389  1.00 53.93           C  
ATOM    392  N   LEU A 454      55.834  66.738  -2.132  1.00 56.77           N  
ATOM    393  CA  LEU A 454      57.249  66.621  -1.780  1.00 56.93           C  
ATOM    394  C   LEU A 454      57.817  65.242  -2.155  1.00 57.24           C  
ATOM    395  O   LEU A 454      59.004  65.127  -2.399  1.00 58.24           O  
ATOM    396  CB  LEU A 454      57.432  66.871  -0.286  1.00 56.92           C  
ATOM    397  CG  LEU A 454      58.844  66.835   0.294  1.00 56.95           C  
ATOM    398  CD1 LEU A 454      59.613  68.128  -0.063  1.00 57.34           C  
ATOM    399  CD2 LEU A 454      58.768  66.628   1.801  1.00 56.53           C  
ATOM    400  N   LYS A 455      56.990  64.203  -2.200  1.00 57.24           N  
ATOM    401  CA  LYS A 455      57.455  62.874  -2.618  1.00 57.38           C  
ATOM    402  C   LYS A 455      57.232  62.603  -4.107  1.00 57.74           C  
ATOM    403  O   LYS A 455      57.656  61.568  -4.615  1.00 57.93           O  
ATOM    404  CB  LYS A 455      56.797  61.767  -1.763  1.00 57.13           C  
ATOM    405  CG  LYS A 455      57.213  61.783  -0.277  1.00 56.97           C  
ATOM    406  CD  LYS A 455      58.710  61.513  -0.054  1.00 55.84           C  
ATOM    407  CE  LYS A 455      59.054  61.475   1.425  1.00 55.29           C  
ATOM    408  NZ  LYS A 455      60.405  60.932   1.692  1.00 55.18           N  
ATOM    409  N   GLY A 456      56.568  63.527  -4.797  1.00 58.13           N  
ATOM    410  CA  GLY A 456      56.436  63.479  -6.254  1.00 58.14           C  
ATOM    411  C   GLY A 456      55.226  62.725  -6.760  1.00 58.48           C  
ATOM    412  O   GLY A 456      55.314  61.970  -7.723  1.00 58.62           O  
ATOM    413  N   VAL A 457      54.087  62.933  -6.119  1.00 58.78           N  
ATOM    414  CA  VAL A 457      52.854  62.288  -6.542  1.00 58.72           C  
ATOM    415  C   VAL A 457      51.961  63.335  -7.150  1.00 58.47           C  
ATOM    416  O   VAL A 457      51.816  64.411  -6.599  1.00 58.55           O  
ATOM    417  CB  VAL A 457      52.135  61.630  -5.356  1.00 58.72           C  
ATOM    418  CG1 VAL A 457      50.808  61.039  -5.802  1.00 58.33           C  
ATOM    419  CG2 VAL A 457      53.025  60.568  -4.738  1.00 58.50           C  
ATOM    420  N   GLU A 458      51.364  63.016  -8.286  1.00 58.26           N  
ATOM    421  CA  GLU A 458      50.458  63.937  -8.944  1.00 58.34           C  
ATOM    422  C   GLU A 458      49.244  64.117  -8.078  1.00 57.48           C  
ATOM    423  O   GLU A 458      48.284  63.362  -8.188  1.00 58.41           O  
ATOM    424  CB  GLU A 458      50.018  63.360 -10.283  1.00 58.82           C  
ATOM    425  CG  GLU A 458      51.147  63.193 -11.268  1.00 61.23           C  
ATOM    426  CD  GLU A 458      51.757  64.525 -11.682  1.00 64.69           C  
ATOM    427  OE1 GLU A 458      52.997  64.667 -11.578  1.00 66.16           O  
ATOM    428  OE2 GLU A 458      50.992  65.434 -12.099  1.00 68.22           O  
ATOM    429  N   ALA A 459      49.263  65.111  -7.219  1.00 56.36           N  
ATOM    430  CA  ALA A 459      48.259  65.157  -6.184  1.00 56.37           C  
ATOM    431  C   ALA A 459      47.601  66.508  -6.118  1.00 55.95           C  
ATOM    432  O   ALA A 459      48.279  67.527  -6.184  1.00 56.32           O  
ATOM    433  CB  ALA A 459      48.865  64.794  -4.828  1.00 55.92           C  
ATOM    434  N   VAL A 460      46.281  66.497  -5.970  1.00 55.50           N  
ATOM    435  CA  VAL A 460      45.503  67.712  -5.824  1.00 55.22           C  
ATOM    436  C   VAL A 460      44.623  67.580  -4.601  1.00 55.59           C  
ATOM    437  O   VAL A 460      44.378  66.483  -4.120  1.00 56.06           O  
ATOM    438  CB  VAL A 460      44.638  68.044  -7.114  1.00 55.29           C  
ATOM    439  CG1 VAL A 460      45.545  68.369  -8.301  1.00 53.01           C  
ATOM    440  CG2 VAL A 460      43.651  66.915  -7.452  1.00 53.87           C  
ATOM    441  N   ALA A 461      44.147  68.713  -4.108  1.00 56.10           N  
ATOM    442  CA  ALA A 461      43.403  68.783  -2.851  1.00 56.78           C  
ATOM    443  C   ALA A 461      42.171  69.686  -2.955  1.00 56.53           C  
ATOM    444  O   ALA A 461      42.200  70.653  -3.679  1.00 56.57           O  
ATOM    445  CB  ALA A 461      44.329  69.297  -1.743  1.00 55.85           C  
ATOM    446  N   ILE A 462      41.110  69.367  -2.215  1.00 57.30           N  
ATOM    447  CA  ILE A 462      39.871  70.174  -2.171  1.00 57.64           C  
ATOM    448  C   ILE A 462      39.397  70.281  -0.727  1.00 57.05           C  
ATOM    449  O   ILE A 462      39.192  69.260  -0.084  1.00 57.35           O  
ATOM    450  CB  ILE A 462      38.646  69.498  -2.889  1.00 58.29           C  
ATOM    451  CG1 ILE A 462      38.992  68.801  -4.200  1.00 59.84           C  
ATOM    452  CG2 ILE A 462      37.540  70.488  -3.151  1.00 57.77           C  
ATOM    453  CD1 ILE A 462      38.111  67.526  -4.405  1.00 58.44           C  
ATOM    454  N   HIS A 463      39.182  71.491  -0.224  1.00 56.52           N  
ATOM    455  CA  HIS A 463      38.448  71.662   1.028  1.00 55.56           C  
ATOM    456  C   HIS A 463      37.807  73.029   1.106  1.00 55.44           C  
ATOM    457  O   HIS A 463      38.105  73.880   0.290  1.00 55.60           O  
ATOM    458  CB  HIS A 463      39.341  71.395   2.230  1.00 55.46           C  
ATOM    459  CG  HIS A 463      40.578  72.236   2.298  1.00 55.08           C  
ATOM    460  ND1 HIS A 463      40.551  73.582   2.586  1.00 54.18           N  
ATOM    461  CD2 HIS A 463      41.888  71.907   2.188  1.00 55.24           C  
ATOM    462  CE1 HIS A 463      41.785  74.057   2.607  1.00 52.53           C  
ATOM    463  NE2 HIS A 463      42.618  73.057   2.389  1.00 53.40           N  
ATOM    464  N   GLY A 464      36.935  73.236   2.090  1.00 55.48           N  
ATOM    465  CA  GLY A 464      36.212  74.496   2.271  1.00 55.25           C  
ATOM    466  C   GLY A 464      37.025  75.785   2.237  1.00 55.88           C  
ATOM    467  O   GLY A 464      36.478  76.865   1.987  1.00 57.09           O  
ATOM    468  N   GLY A 465      38.324  75.703   2.479  1.00 55.77           N  
ATOM    469  CA  GLY A 465      39.185  76.871   2.456  1.00 55.68           C  
ATOM    470  C   GLY A 465      39.837  77.186   1.118  1.00 56.04           C  
ATOM    471  O   GLY A 465      40.428  78.259   0.958  1.00 56.35           O  
ATOM    472  N   LYS A 466      39.777  76.271   0.154  1.00 56.18           N  
ATOM    473  CA  LYS A 466      40.247  76.591  -1.206  1.00 56.36           C  
ATOM    474  C   LYS A 466      39.290  77.560  -1.892  1.00 56.31           C  
ATOM    475  O   LYS A 466      38.078  77.437  -1.723  1.00 56.31           O  
ATOM    476  CB  LYS A 466      40.358  75.323  -2.052  1.00 56.48           C  
ATOM    477  CG  LYS A 466      41.327  74.308  -1.522  1.00 56.65           C  
ATOM    478  CD  LYS A 466      42.745  74.851  -1.446  1.00 56.63           C  
ATOM    479  CE  LYS A 466      43.629  73.858  -0.718  1.00 56.64           C  
ATOM    480  NZ  LYS A 466      44.962  73.740  -1.338  1.00 56.17           N  
ATOM    481  N   ASP A 467      39.815  78.511  -2.664  1.00 56.44           N  
ATOM    482  CA  ASP A 467      38.946  79.412  -3.439  1.00 57.13           C  
ATOM    483  C   ASP A 467      38.319  78.643  -4.627  1.00 57.51           C  
ATOM    484  O   ASP A 467      38.567  77.445  -4.810  1.00 57.23           O  
ATOM    485  CB  ASP A 467      39.696  80.679  -3.897  1.00 56.98           C  
ATOM    486  CG  ASP A 467      40.674  80.419  -5.059  1.00 57.70           C  
ATOM    487  OD1 ASP A 467      40.394  79.577  -5.946  1.00 57.41           O  
ATOM    488  OD2 ASP A 467      41.739  81.073  -5.088  1.00 58.54           O  
ATOM    489  N   GLN A 468      37.519  79.328  -5.433  1.00 58.31           N  
ATOM    490  CA  GLN A 468      36.765  78.651  -6.486  1.00 59.54           C  
ATOM    491  C   GLN A 468      37.641  78.198  -7.643  1.00 59.54           C  
ATOM    492  O   GLN A 468      37.398  77.152  -8.235  1.00 58.82           O  
ATOM    493  CB  GLN A 468      35.652  79.543  -7.028  1.00 59.27           C  
ATOM    494  CG  GLN A 468      34.574  78.713  -7.709  1.00 60.94           C  
ATOM    495  CD  GLN A 468      33.524  79.526  -8.463  1.00 61.71           C  
ATOM    496  OE1 GLN A 468      33.723  80.705  -8.836  1.00 64.74           O  
ATOM    497  NE2 GLN A 468      32.387  78.881  -8.716  1.00 64.25           N  
ATOM    498  N   GLU A 469      38.621  79.030  -7.969  1.00 60.60           N  
ATOM    499  CA  GLU A 469      39.627  78.736  -8.975  1.00 61.79           C  
ATOM    500  C   GLU A 469      40.234  77.383  -8.662  1.00 62.27           C  
ATOM    501  O   GLU A 469      40.165  76.455  -9.474  1.00 62.12           O  
ATOM    502  CB  GLU A 469      40.725  79.828  -8.979  1.00 62.48           C  
ATOM    503  CG  GLU A 469      40.748  80.730 -10.197  1.00 63.69           C  
ATOM    504  CD  GLU A 469      41.179  79.984 -11.454  1.00 65.82           C  
ATOM    505  OE1 GLU A 469      41.844  78.916 -11.300  1.00 64.54           O  
ATOM    506  OE2 GLU A 469      40.854  80.468 -12.582  1.00 65.26           O  
ATOM    507  N   GLU A 470      40.781  77.259  -7.458  1.00 62.78           N  
ATOM    508  CA  GLU A 470      41.517  76.052  -7.081  1.00 63.65           C  
ATOM    509  C   GLU A 470      40.625  74.815  -7.074  1.00 63.23           C  
ATOM    510  O   GLU A 470      40.987  73.791  -7.638  1.00 62.90           O  
ATOM    511  CB  GLU A 470      42.193  76.175  -5.702  1.00 63.75           C  
ATOM    512  CG  GLU A 470      42.356  77.575  -5.157  1.00 65.37           C  
ATOM    513  CD  GLU A 470      43.382  77.691  -4.045  1.00 65.93           C  
ATOM    514  OE1 GLU A 470      43.122  78.426  -3.060  1.00 69.47           O  
ATOM    515  OE2 GLU A 470      44.454  77.064  -4.158  1.00 70.56           O  
ATOM    516  N   ARG A 471      39.468  74.907  -6.429  1.00 63.60           N  
ATOM    517  CA  ARG A 471      38.561  73.756  -6.333  1.00 63.89           C  
ATOM    518  C   ARG A 471      38.247  73.204  -7.715  1.00 63.47           C  
ATOM    519  O   ARG A 471      38.364  71.989  -7.976  1.00 62.32           O  
ATOM    520  CB  ARG A 471      37.254  74.155  -5.634  1.00 64.05           C  
ATOM    521  CG  ARG A 471      36.425  72.961  -5.068  1.00 65.08           C  
ATOM    522  CD  ARG A 471      34.868  73.222  -4.940  1.00 66.32           C  
ATOM    523  NE  ARG A 471      34.514  74.653  -4.867  1.00 67.89           N  
ATOM    524  CZ  ARG A 471      34.960  75.516  -3.940  1.00 68.20           C  
ATOM    525  NH1 ARG A 471      35.798  75.126  -2.980  1.00 67.68           N  
ATOM    526  NH2 ARG A 471      34.590  76.801  -3.987  1.00 68.12           N  
ATOM    527  N   THR A 472      37.866  74.126  -8.604  1.00 63.52           N  
ATOM    528  CA  THR A 472      37.418  73.771  -9.928  1.00 63.55           C  
ATOM    529  C   THR A 472      38.566  73.081 -10.684  1.00 63.37           C  
ATOM    530  O   THR A 472      38.390  71.963 -11.186  1.00 63.14           O  
ATOM    531  CB  THR A 472      36.760  75.006 -10.654  1.00 64.09           C  
ATOM    532  OG1 THR A 472      35.703  74.547 -11.502  1.00 64.73           O  
ATOM    533  CG2 THR A 472      37.764  75.880 -11.484  1.00 64.15           C  
ATOM    534  N   LYS A 473      39.749  73.707 -10.664  1.00 63.32           N  
ATOM    535  CA  LYS A 473      40.963  73.187 -11.330  1.00 63.73           C  
ATOM    536  C   LYS A 473      41.336  71.763 -10.878  1.00 63.40           C  
ATOM    537  O   LYS A 473      41.881  70.971 -11.650  1.00 63.17           O  
ATOM    538  CB  LYS A 473      42.178  74.125 -11.084  1.00 63.97           C  
ATOM    539  CG  LYS A 473      42.920  74.588 -12.364  1.00 64.80           C  
ATOM    540  CD  LYS A 473      44.349  75.083 -12.098  1.00 64.78           C  
ATOM    541  CE  LYS A 473      44.906  75.875 -13.309  1.00 65.29           C  
ATOM    542  NZ  LYS A 473      46.390  76.034 -13.195  1.00 66.03           N  
ATOM    543  N   ALA A 474      41.053  71.454  -9.621  1.00 63.18           N  
ATOM    544  CA  ALA A 474      41.429  70.180  -9.053  1.00 62.90           C  
ATOM    545  C   ALA A 474      40.324  69.162  -9.287  1.00 62.77           C  
ATOM    546  O   ALA A 474      40.605  68.032  -9.699  1.00 62.36           O  
ATOM    547  CB  ALA A 474      41.714  70.343  -7.576  1.00 62.56           C  
ATOM    548  N   ILE A 475      39.074  69.554  -9.032  1.00 62.79           N  
ATOM    549  CA  ILE A 475      37.966  68.621  -9.185  1.00 63.09           C  
ATOM    550  C   ILE A 475      38.008  68.109 -10.601  1.00 63.25           C  
ATOM    551  O   ILE A 475      37.551  67.008 -10.876  1.00 63.26           O  
ATOM    552  CB  ILE A 475      36.571  69.255  -9.014  1.00 63.34           C  
ATOM    553  CG1 ILE A 475      36.292  69.684  -7.570  1.00 63.66           C  
ATOM    554  CG2 ILE A 475      35.492  68.256  -9.439  1.00 63.04           C  
ATOM    555  CD1 ILE A 475      34.980  70.514  -7.445  1.00 63.43           C  
ATOM    556  N   GLU A 476      38.547  68.911 -11.513  1.00 63.09           N  
ATOM    557  CA  GLU A 476      38.526  68.521 -12.902  1.00 63.26           C  
ATOM    558  C   GLU A 476      39.798  67.891 -13.456  1.00 62.63           C  
ATOM    559  O   GLU A 476      39.701  67.023 -14.314  1.00 62.41           O  
ATOM    560  CB  GLU A 476      38.045  69.683 -13.747  1.00 63.75           C  
ATOM    561  CG  GLU A 476      36.524  69.713 -13.755  1.00 65.63           C  
ATOM    562  CD  GLU A 476      35.984  71.019 -14.236  1.00 70.16           C  
ATOM    563  OE1 GLU A 476      36.378  72.050 -13.635  1.00 73.64           O  
ATOM    564  OE2 GLU A 476      35.173  71.028 -15.210  1.00 72.96           O  
ATOM    565  N   ALA A 477      40.977  68.285 -12.975  1.00 61.84           N  
ATOM    566  CA  ALA A 477      42.212  67.554 -13.329  1.00 61.00           C  
ATOM    567  C   ALA A 477      42.075  66.099 -12.889  1.00 60.50           C  
ATOM    568  O   ALA A 477      42.456  65.159 -13.594  1.00 59.89           O  
ATOM    569  CB  ALA A 477      43.401  68.181 -12.676  1.00 60.77           C  
ATOM    570  N   PHE A 478      41.508  65.935 -11.701  1.00 59.69           N  
ATOM    571  CA  PHE A 478      41.222  64.624 -11.180  1.00 59.09           C  
ATOM    572  C   PHE A 478      40.216  63.936 -12.075  1.00 59.07           C  
ATOM    573  O   PHE A 478      40.494  62.871 -12.599  1.00 58.87           O  
ATOM    574  CB  PHE A 478      40.681  64.748  -9.762  1.00 58.67           C  
ATOM    575  CG  PHE A 478      40.538  63.453  -9.056  1.00 57.42           C  
ATOM    576  CD1 PHE A 478      41.628  62.626  -8.891  1.00 56.53           C  
ATOM    577  CD2 PHE A 478      39.320  63.087  -8.507  1.00 57.43           C  
ATOM    578  CE1 PHE A 478      41.505  61.450  -8.227  1.00 56.79           C  
ATOM    579  CE2 PHE A 478      39.172  61.919  -7.847  1.00 55.75           C  
ATOM    580  CZ  PHE A 478      40.271  61.085  -7.702  1.00 57.74           C  
ATOM    581  N   ARG A 479      39.061  64.565 -12.273  1.00 59.01           N  
ATOM    582  CA  ARG A 479      38.019  64.008 -13.137  1.00 59.03           C  
ATOM    583  C   ARG A 479      38.449  63.719 -14.585  1.00 59.39           C  
ATOM    584  O   ARG A 479      37.773  62.972 -15.266  1.00 59.72           O  
ATOM    585  CB  ARG A 479      36.797  64.935 -13.174  1.00 59.12           C  
ATOM    586  CG  ARG A 479      35.985  64.967 -11.886  1.00 59.05           C  
ATOM    587  CD  ARG A 479      34.726  65.786 -12.031  1.00 57.61           C  
ATOM    588  NE  ARG A 479      33.822  65.175 -13.018  1.00 57.55           N  
ATOM    589  CZ  ARG A 479      33.495  65.701 -14.203  1.00 54.52           C  
ATOM    590  NH1 ARG A 479      33.969  66.864 -14.587  1.00 54.08           N  
ATOM    591  NH2 ARG A 479      32.688  65.050 -15.017  1.00 54.38           N  
ATOM    592  N   GLU A 480      39.531  64.319 -15.080  1.00 59.88           N  
ATOM    593  CA  GLU A 480      40.049  63.983 -16.429  1.00 59.82           C  
ATOM    594  C   GLU A 480      41.097  62.892 -16.405  1.00 60.25           C  
ATOM    595  O   GLU A 480      41.374  62.288 -17.426  1.00 60.46           O  
ATOM    596  CB  GLU A 480      40.695  65.185 -17.093  1.00 60.04           C  
ATOM    597  CG  GLU A 480      39.909  66.471 -16.977  1.00 60.99           C  
ATOM    598  CD  GLU A 480      40.115  67.382 -18.144  1.00 61.08           C  
ATOM    599  OE1 GLU A 480      40.607  68.515 -17.940  1.00 60.91           O  
ATOM    600  OE2 GLU A 480      39.792  66.953 -19.266  1.00 63.28           O  
ATOM    601  N   GLY A 481      41.703  62.667 -15.243  1.00 60.67           N  
ATOM    602  CA  GLY A 481      42.813  61.745 -15.112  1.00 60.91           C  
ATOM    603  C   GLY A 481      44.151  62.441 -15.256  1.00 61.12           C  
ATOM    604  O   GLY A 481      45.148  61.793 -15.534  1.00 61.85           O  
ATOM    605  N   LYS A 482      44.198  63.752 -15.069  1.00 60.96           N  
ATOM    606  CA  LYS A 482      45.455  64.469 -15.233  1.00 61.01           C  
ATOM    607  C   LYS A 482      46.191  64.474 -13.919  1.00 60.27           C  
ATOM    608  O   LYS A 482      47.327  64.914 -13.855  1.00 60.02           O  
ATOM    609  CB  LYS A 482      45.216  65.896 -15.713  1.00 61.05           C  
ATOM    610  CG  LYS A 482      44.941  66.015 -17.203  1.00 62.11           C  
ATOM    611  CD  LYS A 482      44.467  67.426 -17.581  1.00 63.16           C  
ATOM    612  CE  LYS A 482      45.613  68.467 -17.573  1.00 66.08           C  
ATOM    613  NZ  LYS A 482      45.178  69.867 -17.172  1.00 67.65           N  
ATOM    614  N   LYS A 483      45.532  63.986 -12.875  1.00 59.79           N  
ATOM    615  CA  LYS A 483      46.109  63.928 -11.556  1.00 59.31           C  
ATOM    616  C   LYS A 483      45.710  62.618 -10.956  1.00 58.90           C  
ATOM    617  O   LYS A 483      44.567  62.204 -11.099  1.00 59.56           O  
ATOM    618  CB  LYS A 483      45.569  65.067 -10.710  1.00 59.55           C  
ATOM    619  CG  LYS A 483      46.077  66.450 -11.135  1.00 59.54           C  
ATOM    620  CD  LYS A 483      47.587  66.585 -10.973  1.00 59.04           C  
ATOM    621  CE  LYS A 483      47.991  68.052 -10.878  1.00 59.64           C  
ATOM    622  NZ  LYS A 483      49.206  68.336 -11.669  1.00 58.71           N  
ATOM    623  N   ASP A 484      46.643  61.973 -10.268  1.00 57.99           N  
ATOM    624  CA  ASP A 484      46.461  60.603  -9.826  1.00 56.92           C  
ATOM    625  C   ASP A 484      45.712  60.580  -8.517  1.00 56.13           C  
ATOM    626  O   ASP A 484      44.877  59.701  -8.281  1.00 55.31           O  
ATOM    627  CB  ASP A 484      47.823  59.935  -9.653  1.00 56.90           C  
ATOM    628  CG  ASP A 484      48.589  59.864 -10.945  1.00 57.57           C  
ATOM    629  OD1 ASP A 484      49.789  59.533 -10.934  1.00 58.97           O  
ATOM    630  OD2 ASP A 484      47.989  60.160 -11.986  1.00 58.10           O  
ATOM    631  N   VAL A 485      46.029  61.547  -7.659  1.00 54.92           N  
ATOM    632  CA  VAL A 485      45.498  61.548  -6.323  1.00 54.02           C  
ATOM    633  C   VAL A 485      44.760  62.846  -6.043  1.00 53.68           C  
ATOM    634  O   VAL A 485      45.288  63.944  -6.266  1.00 52.71           O  
ATOM    635  CB  VAL A 485      46.617  61.358  -5.281  1.00 54.10           C  
ATOM    636  CG1 VAL A 485      46.028  61.147  -3.889  1.00 51.08           C  
ATOM    637  CG2 VAL A 485      47.525  60.184  -5.704  1.00 53.87           C  
ATOM    638  N   LEU A 486      43.536  62.683  -5.549  1.00 52.89           N  
ATOM    639  CA  LEU A 486      42.781  63.772  -4.960  1.00 52.56           C  
ATOM    640  C   LEU A 486      42.673  63.555  -3.482  1.00 51.81           C  
ATOM    641  O   LEU A 486      42.211  62.522  -3.048  1.00 52.19           O  
ATOM    642  CB  LEU A 486      41.354  63.820  -5.521  1.00 52.71           C  
ATOM    643  CG  LEU A 486      40.450  64.849  -4.836  1.00 52.36           C  
ATOM    644  CD1 LEU A 486      40.908  66.197  -5.242  1.00 51.52           C  
ATOM    645  CD2 LEU A 486      39.000  64.650  -5.190  1.00 52.24           C  
ATOM    646  N   VAL A 487      43.032  64.571  -2.720  1.00 51.71           N  
ATOM    647  CA  VAL A 487      42.891  64.554  -1.279  1.00 51.08           C  
ATOM    648  C   VAL A 487      41.778  65.515  -0.947  1.00 51.23           C  
ATOM    649  O   VAL A 487      41.875  66.665  -1.344  1.00 51.19           O  
ATOM    650  CB  VAL A 487      44.197  65.066  -0.594  1.00 51.26           C  
ATOM    651  CG1 VAL A 487      44.068  65.008   0.927  1.00 47.87           C  
ATOM    652  CG2 VAL A 487      45.433  64.289  -1.104  1.00 49.68           C  
ATOM    653  N   ALA A 488      40.787  65.070  -0.170  1.00 50.95           N  
ATOM    654  CA  ALA A 488      39.559  65.829   0.066  1.00 50.88           C  
ATOM    655  C   ALA A 488      39.045  65.693   1.489  1.00 51.01           C  
ATOM    656  O   ALA A 488      39.292  64.701   2.159  1.00 50.64           O  
ATOM    657  CB  ALA A 488      38.454  65.330  -0.919  1.00 50.50           C  
ATOM    658  N   THR A 489      38.292  66.680   1.947  1.00 51.61           N  
ATOM    659  CA  THR A 489      37.432  66.492   3.126  1.00 52.26           C  
ATOM    660  C   THR A 489      36.121  65.881   2.656  1.00 53.33           C  
ATOM    661  O   THR A 489      35.778  65.973   1.475  1.00 53.93           O  
ATOM    662  CB  THR A 489      37.060  67.805   3.819  1.00 51.90           C  
ATOM    663  OG1 THR A 489      36.493  68.702   2.850  1.00 52.80           O  
ATOM    664  CG2 THR A 489      38.252  68.457   4.459  1.00 50.17           C  
ATOM    665  N   ASP A 490      35.385  65.266   3.578  1.00 54.63           N  
ATOM    666  CA  ASP A 490      34.098  64.654   3.263  1.00 55.60           C  
ATOM    667  C   ASP A 490      33.222  65.776   2.641  1.00 55.64           C  
ATOM    668  O   ASP A 490      32.730  65.648   1.520  1.00 54.87           O  
ATOM    669  CB  ASP A 490      33.389  64.093   4.532  1.00 56.54           C  
ATOM    670  CG  ASP A 490      34.102  62.849   5.185  1.00 60.87           C  
ATOM    671  OD1 ASP A 490      34.952  62.220   4.526  1.00 68.11           O  
ATOM    672  OD2 ASP A 490      33.792  62.467   6.366  1.00 63.52           O  
ATOM    673  N   VAL A 491      33.074  66.882   3.385  1.00 55.47           N  
ATOM    674  CA  VAL A 491      32.144  67.969   3.036  1.00 55.11           C  
ATOM    675  C   VAL A 491      32.501  68.640   1.697  1.00 54.89           C  
ATOM    676  O   VAL A 491      31.612  68.944   0.933  1.00 54.94           O  
ATOM    677  CB  VAL A 491      31.992  69.010   4.211  1.00 55.23           C  
ATOM    678  CG1 VAL A 491      33.215  69.909   4.301  1.00 54.31           C  
ATOM    679  CG2 VAL A 491      30.681  69.822   4.078  1.00 55.08           C  
ATOM    680  N   ALA A 492      33.789  68.795   1.380  1.00 54.75           N  
ATOM    681  CA  ALA A 492      34.202  69.359   0.076  1.00 54.20           C  
ATOM    682  C   ALA A 492      33.964  68.421  -1.130  1.00 53.64           C  
ATOM    683  O   ALA A 492      33.807  68.876  -2.262  1.00 53.74           O  
ATOM    684  CB  ALA A 492      35.657  69.753   0.137  1.00 53.61           C  
ATOM    685  N   SER A 493      33.965  67.117  -0.886  1.00 53.39           N  
ATOM    686  CA  SER A 493      33.851  66.127  -1.947  1.00 53.18           C  
ATOM    687  C   SER A 493      32.431  65.742  -2.207  1.00 53.73           C  
ATOM    688  O   SER A 493      32.147  65.100  -3.214  1.00 54.09           O  
ATOM    689  CB  SER A 493      34.514  64.857  -1.515  1.00 53.36           C  
ATOM    690  OG  SER A 493      33.718  64.278  -0.504  1.00 52.10           O  
ATOM    691  N   LYS A 494      31.538  66.065  -1.277  1.00 54.04           N  
ATOM    692  CA  LYS A 494      30.125  65.723  -1.435  1.00 55.01           C  
ATOM    693  C   LYS A 494      29.535  66.253  -2.748  1.00 55.09           C  
ATOM    694  O   LYS A 494      29.608  67.439  -3.042  1.00 54.76           O  
ATOM    695  CB  LYS A 494      29.296  66.297  -0.283  1.00 54.87           C  
ATOM    696  CG  LYS A 494      28.934  65.342   0.798  1.00 55.04           C  
ATOM    697  CD  LYS A 494      28.115  66.085   1.877  1.00 57.15           C  
ATOM    698  CE  LYS A 494      28.427  65.627   3.339  1.00 59.13           C  
ATOM    699  NZ  LYS A 494      27.877  64.261   3.671  1.00 60.27           N  
ATOM    700  N   GLY A 495      28.951  65.360  -3.532  1.00 55.76           N  
ATOM    701  CA  GLY A 495      28.253  65.748  -4.746  1.00 56.10           C  
ATOM    702  C   GLY A 495      29.147  65.874  -5.954  1.00 56.70           C  
ATOM    703  O   GLY A 495      28.643  66.007  -7.064  1.00 57.11           O  
ATOM    704  N   LEU A 496      30.466  65.839  -5.768  1.00 57.14           N  
ATOM    705  CA  LEU A 496      31.355  65.875  -6.909  1.00 57.44           C  
ATOM    706  C   LEU A 496      31.133  64.611  -7.744  1.00 57.92           C  
ATOM    707  O   LEU A 496      30.650  63.597  -7.262  1.00 57.13           O  
ATOM    708  CB  LEU A 496      32.802  65.994  -6.463  1.00 57.44           C  
ATOM    709  CG  LEU A 496      33.143  67.255  -5.686  1.00 57.13           C  
ATOM    710  CD1 LEU A 496      34.595  67.196  -5.400  1.00 56.12           C  
ATOM    711  CD2 LEU A 496      32.775  68.511  -6.491  1.00 58.94           C  
ATOM    712  N   ASP A 497      31.434  64.705  -9.023  1.00 59.28           N  
ATOM    713  CA  ASP A 497      31.272  63.577  -9.914  1.00 60.34           C  
ATOM    714  C   ASP A 497      32.637  63.049 -10.124  1.00 60.22           C  
ATOM    715  O   ASP A 497      33.447  63.661 -10.788  1.00 60.30           O  
ATOM    716  CB  ASP A 497      30.692  63.980 -11.259  1.00 60.83           C  
ATOM    717  CG  ASP A 497      30.594  62.801 -12.210  1.00 62.88           C  
ATOM    718  OD1 ASP A 497      29.590  62.049 -12.140  1.00 63.65           O  
ATOM    719  OD2 ASP A 497      31.536  62.627 -13.024  1.00 65.73           O  
ATOM    720  N   PHE A 498      32.916  61.922  -9.515  1.00 60.60           N  
ATOM    721  CA  PHE A 498      34.258  61.396  -9.562  1.00 60.24           C  
ATOM    722  C   PHE A 498      34.254  60.291 -10.580  1.00 59.54           C  
ATOM    723  O   PHE A 498      33.207  59.738 -10.912  1.00 58.55           O  
ATOM    724  CB  PHE A 498      34.690  60.873  -8.199  1.00 60.33           C  
ATOM    725  CG  PHE A 498      35.019  61.955  -7.210  1.00 60.37           C  
ATOM    726  CD1 PHE A 498      34.607  61.845  -5.901  1.00 59.72           C  
ATOM    727  CD2 PHE A 498      35.744  63.077  -7.590  1.00 61.62           C  
ATOM    728  CE1 PHE A 498      34.899  62.816  -4.984  1.00 59.56           C  
ATOM    729  CE2 PHE A 498      36.050  64.060  -6.670  1.00 61.71           C  
ATOM    730  CZ  PHE A 498      35.620  63.925  -5.361  1.00 61.11           C  
ATOM    731  N   PRO A 499      35.434  59.965 -11.084  1.00 59.01           N  
ATOM    732  CA  PRO A 499      35.497  58.869 -12.016  1.00 58.55           C  
ATOM    733  C   PRO A 499      35.598  57.543 -11.254  1.00 57.90           C  
ATOM    734  O   PRO A 499      35.461  57.516 -10.031  1.00 57.97           O  
ATOM    735  CB  PRO A 499      36.785  59.166 -12.802  1.00 58.53           C  
ATOM    736  CG  PRO A 499      37.329  60.454 -12.240  1.00 58.92           C  
ATOM    737  CD  PRO A 499      36.767  60.535 -10.862  1.00 59.04           C  
ATOM    738  N   ALA A 500      35.819  56.456 -11.979  1.00 57.37           N  
ATOM    739  CA  ALA A 500      36.035  55.149 -11.371  1.00 56.85           C  
ATOM    740  C   ALA A 500      37.271  55.195 -10.449  1.00 56.41           C  
ATOM    741  O   ALA A 500      38.392  55.184 -10.929  1.00 56.49           O  
ATOM    742  CB  ALA A 500      36.194  54.078 -12.471  1.00 56.64           C  
ATOM    743  N   ILE A 501      37.057  55.287  -9.138  1.00 56.00           N  
ATOM    744  CA  ILE A 501      38.166  55.306  -8.152  1.00 55.86           C  
ATOM    745  C   ILE A 501      38.653  53.873  -7.796  1.00 55.37           C  
ATOM    746  O   ILE A 501      37.844  53.011  -7.451  1.00 54.46           O  
ATOM    747  CB  ILE A 501      37.746  56.070  -6.867  1.00 56.06           C  
ATOM    748  CG1 ILE A 501      37.386  57.532  -7.211  1.00 55.64           C  
ATOM    749  CG2 ILE A 501      38.877  56.018  -5.796  1.00 55.95           C  
ATOM    750  CD1 ILE A 501      36.549  58.229  -6.140  1.00 55.46           C  
ATOM    751  N   GLN A 502      39.957  53.617  -7.922  1.00 55.34           N  
ATOM    752  CA  GLN A 502      40.487  52.251  -7.733  1.00 55.48           C  
ATOM    753  C   GLN A 502      40.737  51.956  -6.229  1.00 55.46           C  
ATOM    754  O   GLN A 502      40.785  50.792  -5.820  1.00 55.39           O  
ATOM    755  CB  GLN A 502      41.767  52.033  -8.559  1.00 55.40           C  
ATOM    756  CG  GLN A 502      41.559  51.999 -10.076  1.00 56.56           C  
ATOM    757  CD  GLN A 502      41.319  50.596 -10.611  1.00 57.97           C  
ATOM    758  OE1 GLN A 502      42.246  49.790 -10.725  1.00 60.31           O  
ATOM    759  NE2 GLN A 502      40.080  50.298 -10.938  1.00 57.50           N  
ATOM    760  N   HIS A 503      40.822  53.019  -5.420  1.00 55.08           N  
ATOM    761  CA  HIS A 503      41.310  52.952  -4.041  1.00 54.75           C  
ATOM    762  C   HIS A 503      40.873  54.178  -3.205  1.00 54.30           C  
ATOM    763  O   HIS A 503      41.276  55.296  -3.521  1.00 53.73           O  
ATOM    764  CB  HIS A 503      42.842  52.920  -4.113  1.00 55.54           C  
ATOM    765  CG  HIS A 503      43.526  52.585  -2.829  1.00 54.77           C  
ATOM    766  ND1 HIS A 503      44.895  52.621  -2.707  1.00 54.83           N  
ATOM    767  CD2 HIS A 503      43.046  52.176  -1.631  1.00 55.16           C  
ATOM    768  CE1 HIS A 503      45.232  52.253  -1.483  1.00 55.08           C  
ATOM    769  NE2 HIS A 503      44.130  51.973  -0.813  1.00 55.23           N  
ATOM    770  N   VAL A 504      40.045  53.975  -2.177  1.00 53.66           N  
ATOM    771  CA  VAL A 504      39.751  55.009  -1.165  1.00 53.23           C  
ATOM    772  C   VAL A 504      40.761  54.841  -0.003  1.00 53.10           C  
ATOM    773  O   VAL A 504      40.946  53.730   0.467  1.00 52.78           O  
ATOM    774  CB  VAL A 504      38.282  54.848  -0.638  1.00 53.01           C  
ATOM    775  CG1 VAL A 504      37.984  55.783   0.546  1.00 51.62           C  
ATOM    776  CG2 VAL A 504      37.316  55.102  -1.748  1.00 52.83           C  
ATOM    777  N   ILE A 505      41.448  55.905   0.414  1.00 53.03           N  
ATOM    778  CA  ILE A 505      42.320  55.851   1.589  1.00 53.08           C  
ATOM    779  C   ILE A 505      41.725  56.738   2.646  1.00 53.41           C  
ATOM    780  O   ILE A 505      41.750  57.943   2.511  1.00 53.97           O  
ATOM    781  CB  ILE A 505      43.769  56.320   1.312  1.00 53.27           C  
ATOM    782  CG1 ILE A 505      44.423  55.442   0.226  1.00 52.79           C  
ATOM    783  CG2 ILE A 505      44.622  56.252   2.610  1.00 52.66           C  
ATOM    784  CD1 ILE A 505      45.929  55.603   0.168  1.00 52.15           C  
ATOM    785  N   ASN A 506      41.170  56.145   3.694  1.00 53.80           N  
ATOM    786  CA  ASN A 506      40.651  56.926   4.799  1.00 54.56           C  
ATOM    787  C   ASN A 506      41.786  57.222   5.767  1.00 55.17           C  
ATOM    788  O   ASN A 506      42.152  56.358   6.548  1.00 55.69           O  
ATOM    789  CB  ASN A 506      39.557  56.167   5.529  1.00 54.44           C  
ATOM    790  CG  ASN A 506      38.261  56.080   4.739  1.00 55.13           C  
ATOM    791  OD1 ASN A 506      37.887  57.019   4.062  1.00 55.25           O  
ATOM    792  ND2 ASN A 506      37.552  54.951   4.858  1.00 55.97           N  
ATOM    793  N   TYR A 507      42.364  58.417   5.697  1.00 55.51           N  
ATOM    794  CA  TYR A 507      43.432  58.818   6.619  1.00 55.99           C  
ATOM    795  C   TYR A 507      42.914  58.962   8.051  1.00 56.15           C  
ATOM    796  O   TYR A 507      43.663  58.789   9.013  1.00 55.74           O  
ATOM    797  CB  TYR A 507      44.012  60.143   6.145  1.00 56.30           C  
ATOM    798  CG  TYR A 507      45.216  60.665   6.902  1.00 55.56           C  
ATOM    799  CD1 TYR A 507      46.508  60.446   6.433  1.00 54.71           C  
ATOM    800  CD2 TYR A 507      45.053  61.436   8.033  1.00 54.57           C  
ATOM    801  CE1 TYR A 507      47.598  60.950   7.093  1.00 53.75           C  
ATOM    802  CE2 TYR A 507      46.133  61.936   8.707  1.00 55.89           C  
ATOM    803  CZ  TYR A 507      47.402  61.696   8.222  1.00 55.75           C  
ATOM    804  OH  TYR A 507      48.474  62.203   8.911  1.00 57.48           O  
ATOM    805  N   ASP A 508      41.622  59.268   8.165  1.00 57.12           N  
ATOM    806  CA  ASP A 508      40.878  59.342   9.444  1.00 57.41           C  
ATOM    807  C   ASP A 508      39.842  58.229   9.514  1.00 57.47           C  
ATOM    808  O   ASP A 508      39.308  57.822   8.483  1.00 58.41           O  
ATOM    809  CB  ASP A 508      40.077  60.660   9.503  1.00 57.86           C  
ATOM    810  CG  ASP A 508      40.939  61.844   9.772  1.00 59.84           C  
ATOM    811  OD1 ASP A 508      42.074  61.648  10.221  1.00 65.23           O  
ATOM    812  OD2 ASP A 508      40.501  62.986   9.560  1.00 64.41           O  
ATOM    813  N   MET A 509      39.501  57.783  10.713  1.00 56.92           N  
ATOM    814  CA  MET A 509      38.269  57.041  10.888  1.00 56.71           C  
ATOM    815  C   MET A 509      37.171  58.029  11.277  1.00 56.34           C  
ATOM    816  O   MET A 509      37.331  58.795  12.177  1.00 56.52           O  
ATOM    817  CB  MET A 509      38.409  55.944  11.937  1.00 56.25           C  
ATOM    818  CG  MET A 509      37.124  55.086  12.120  1.00 56.59           C  
ATOM    819  SD  MET A 509      36.795  54.075  10.692  1.00 55.93           S  
ATOM    820  CE  MET A 509      35.143  53.441  11.059  1.00 54.84           C  
ATOM    821  N   PRO A 510      36.047  58.021  10.577  1.00 56.73           N  
ATOM    822  CA  PRO A 510      35.001  58.946  11.014  1.00 56.65           C  
ATOM    823  C   PRO A 510      34.414  58.538  12.343  1.00 56.85           C  
ATOM    824  O   PRO A 510      34.433  57.365  12.697  1.00 56.56           O  
ATOM    825  CB  PRO A 510      33.927  58.846   9.916  1.00 56.31           C  
ATOM    826  CG  PRO A 510      34.548  58.087   8.803  1.00 56.81           C  
ATOM    827  CD  PRO A 510      35.651  57.251   9.385  1.00 56.83           C  
ATOM    828  N   GLU A 511      33.880  59.514  13.062  1.00 57.31           N  
ATOM    829  CA  GLU A 511      33.230  59.244  14.327  1.00 57.90           C  
ATOM    830  C   GLU A 511      31.990  58.330  14.099  1.00 57.85           C  
ATOM    831  O   GLU A 511      31.758  57.417  14.874  1.00 58.03           O  
ATOM    832  CB  GLU A 511      32.914  60.573  15.056  1.00 57.71           C  
ATOM    833  CG  GLU A 511      34.182  61.453  15.343  1.00 58.82           C  
ATOM    834  CD  GLU A 511      33.916  62.739  16.157  1.00 60.12           C  
ATOM    835  OE1 GLU A 511      32.753  62.983  16.577  1.00 64.36           O  
ATOM    836  OE2 GLU A 511      34.876  63.524  16.382  1.00 63.08           O  
ATOM    837  N   GLU A 512      31.231  58.537  13.019  1.00 57.81           N  
ATOM    838  CA  GLU A 512      30.029  57.722  12.733  1.00 57.69           C  
ATOM    839  C   GLU A 512      30.273  56.649  11.678  1.00 56.82           C  
ATOM    840  O   GLU A 512      30.887  56.931  10.658  1.00 57.07           O  
ATOM    841  CB  GLU A 512      28.910  58.614  12.214  1.00 57.97           C  
ATOM    842  CG  GLU A 512      28.464  59.679  13.166  1.00 59.97           C  
ATOM    843  CD  GLU A 512      27.970  59.106  14.461  1.00 62.90           C  
ATOM    844  OE1 GLU A 512      26.742  58.857  14.596  1.00 65.64           O  
ATOM    845  OE2 GLU A 512      28.830  58.896  15.343  1.00 65.61           O  
ATOM    846  N   ILE A 513      29.779  55.432  11.892  1.00 55.68           N  
ATOM    847  CA  ILE A 513      30.051  54.357  10.946  1.00 55.21           C  
ATOM    848  C   ILE A 513      29.346  54.619   9.598  1.00 55.79           C  
ATOM    849  O   ILE A 513      29.883  54.299   8.529  1.00 55.62           O  
ATOM    850  CB  ILE A 513      29.663  53.018  11.525  1.00 54.87           C  
ATOM    851  CG1 ILE A 513      30.292  51.890  10.683  1.00 55.26           C  
ATOM    852  CG2 ILE A 513      28.115  52.918  11.692  1.00 52.24           C  
ATOM    853  CD1 ILE A 513      31.803  51.752  10.814  1.00 54.09           C  
ATOM    854  N   GLU A 514      28.155  55.217   9.693  1.00 56.26           N  
ATOM    855  CA  GLU A 514      27.409  55.826   8.585  1.00 56.84           C  
ATOM    856  C   GLU A 514      28.296  56.528   7.560  1.00 56.65           C  
ATOM    857  O   GLU A 514      28.137  56.349   6.357  1.00 56.77           O  
ATOM    858  CB  GLU A 514      26.453  56.887   9.148  1.00 57.39           C  
ATOM    859  CG  GLU A 514      25.185  56.365   9.875  1.00 60.09           C  
ATOM    860  CD  GLU A 514      25.417  55.912  11.324  1.00 62.86           C  
ATOM    861  OE1 GLU A 514      26.522  56.168  11.893  1.00 62.20           O  
ATOM    862  OE2 GLU A 514      24.470  55.290  11.878  1.00 63.90           O  
ATOM    863  N   ASN A 515      29.210  57.354   8.067  1.00 56.31           N  
ATOM    864  CA  ASN A 515      30.162  58.087   7.250  1.00 55.73           C  
ATOM    865  C   ASN A 515      31.253  57.200   6.674  1.00 55.60           C  
ATOM    866  O   ASN A 515      31.761  57.512   5.608  1.00 56.11           O  
ATOM    867  CB  ASN A 515      30.835  59.233   8.043  1.00 56.13           C  
ATOM    868  CG  ASN A 515      29.843  60.298   8.556  1.00 56.43           C  
ATOM    869  OD1 ASN A 515      28.695  60.343   8.144  1.00 57.74           O  
ATOM    870  ND2 ASN A 515      30.307  61.161   9.462  1.00 57.81           N  
ATOM    871  N   TYR A 516      31.647  56.132   7.378  1.00 55.15           N  
ATOM    872  CA  TYR A 516      32.718  55.239   6.902  1.00 54.58           C  
ATOM    873  C   TYR A 516      32.237  54.622   5.602  1.00 54.20           C  
ATOM    874  O   TYR A 516      32.975  54.565   4.610  1.00 53.63           O  
ATOM    875  CB  TYR A 516      33.021  54.141   7.937  1.00 54.43           C  
ATOM    876  CG  TYR A 516      33.869  53.000   7.402  1.00 53.92           C  
ATOM    877  CD1 TYR A 516      35.246  53.113   7.365  1.00 53.24           C  
ATOM    878  CD2 TYR A 516      33.296  51.831   6.949  1.00 50.85           C  
ATOM    879  CE1 TYR A 516      36.026  52.118   6.887  1.00 54.07           C  
ATOM    880  CE2 TYR A 516      34.073  50.824   6.456  1.00 52.78           C  
ATOM    881  CZ  TYR A 516      35.457  50.970   6.425  1.00 53.78           C  
ATOM    882  OH  TYR A 516      36.304  49.995   5.947  1.00 52.34           O  
ATOM    883  N   VAL A 517      30.984  54.164   5.656  1.00 53.86           N  
ATOM    884  CA  VAL A 517      30.288  53.571   4.538  1.00 54.15           C  
ATOM    885  C   VAL A 517      30.252  54.507   3.327  1.00 54.98           C  
ATOM    886  O   VAL A 517      30.646  54.147   2.217  1.00 55.31           O  
ATOM    887  CB  VAL A 517      28.823  53.295   4.921  1.00 53.94           C  
ATOM    888  CG1 VAL A 517      28.014  52.986   3.699  1.00 52.31           C  
ATOM    889  CG2 VAL A 517      28.753  52.171   5.906  1.00 53.95           C  
ATOM    890  N   HIS A 518      29.768  55.718   3.535  1.00 55.47           N  
ATOM    891  CA  HIS A 518      29.721  56.673   2.442  1.00 56.16           C  
ATOM    892  C   HIS A 518      31.091  56.893   1.795  1.00 55.47           C  
ATOM    893  O   HIS A 518      31.192  57.011   0.576  1.00 55.33           O  
ATOM    894  CB  HIS A 518      29.132  58.000   2.908  1.00 56.67           C  
ATOM    895  CG  HIS A 518      27.646  57.957   3.120  1.00 59.54           C  
ATOM    896  ND1 HIS A 518      27.028  58.517   4.225  1.00 61.24           N  
ATOM    897  CD2 HIS A 518      26.654  57.417   2.368  1.00 60.86           C  
ATOM    898  CE1 HIS A 518      25.724  58.323   4.143  1.00 61.21           C  
ATOM    899  NE2 HIS A 518      25.471  57.656   3.028  1.00 62.07           N  
ATOM    900  N   ARG A 519      32.140  56.956   2.602  1.00 54.57           N  
ATOM    901  CA  ARG A 519      33.443  57.144   2.033  1.00 54.60           C  
ATOM    902  C   ARG A 519      33.799  55.923   1.202  1.00 53.95           C  
ATOM    903  O   ARG A 519      34.104  56.045   0.021  1.00 53.04           O  
ATOM    904  CB  ARG A 519      34.484  57.375   3.105  1.00 54.66           C  
ATOM    905  CG  ARG A 519      34.374  58.715   3.858  1.00 55.39           C  
ATOM    906  CD  ARG A 519      35.634  58.876   4.711  1.00 56.90           C  
ATOM    907  NE  ARG A 519      35.698  60.007   5.640  1.00 57.75           N  
ATOM    908  CZ  ARG A 519      36.794  60.309   6.353  1.00 58.11           C  
ATOM    909  NH1 ARG A 519      37.892  59.572   6.244  1.00 58.33           N  
ATOM    910  NH2 ARG A 519      36.805  61.361   7.181  1.00 58.92           N  
ATOM    911  N   ILE A 520      33.735  54.743   1.812  1.00 53.47           N  
ATOM    912  CA  ILE A 520      34.143  53.546   1.102  1.00 52.89           C  
ATOM    913  C   ILE A 520      33.179  53.366  -0.076  1.00 53.51           C  
ATOM    914  O   ILE A 520      33.564  52.852  -1.141  1.00 53.84           O  
ATOM    915  CB  ILE A 520      34.290  52.290   2.034  1.00 53.10           C  
ATOM    916  CG1 ILE A 520      32.948  51.850   2.620  1.00 51.86           C  
ATOM    917  CG2 ILE A 520      35.322  52.568   3.198  1.00 51.34           C  
ATOM    918  CD1 ILE A 520      32.976  50.441   3.129  1.00 51.39           C  
ATOM    919  N   GLY A 521      31.955  53.876   0.080  1.00 53.28           N  
ATOM    920  CA  GLY A 521      30.981  53.902  -1.010  1.00 52.85           C  
ATOM    921  C   GLY A 521      31.395  54.734  -2.203  1.00 53.09           C  
ATOM    922  O   GLY A 521      30.647  54.864  -3.149  1.00 53.36           O  
ATOM    923  N   ARG A 522      32.588  55.304  -2.166  1.00 53.60           N  
ATOM    924  CA  ARG A 522      33.105  56.042  -3.300  1.00 54.08           C  
ATOM    925  C   ARG A 522      33.963  55.177  -4.198  1.00 54.26           C  
ATOM    926  O   ARG A 522      34.600  55.685  -5.106  1.00 54.73           O  
ATOM    927  CB  ARG A 522      33.897  57.240  -2.822  1.00 54.32           C  
ATOM    928  CG  ARG A 522      33.010  58.357  -2.330  1.00 56.28           C  
ATOM    929  CD  ARG A 522      32.339  58.993  -3.510  1.00 59.73           C  
ATOM    930  NE  ARG A 522      31.904  60.366  -3.265  1.00 62.30           N  
ATOM    931  CZ  ARG A 522      31.620  61.253  -4.233  1.00 63.32           C  
ATOM    932  NH1 ARG A 522      31.740  60.916  -5.515  1.00 64.11           N  
ATOM    933  NH2 ARG A 522      31.210  62.491  -3.931  1.00 62.80           N  
ATOM    934  N   THR A 523      33.946  53.871  -3.977  1.00 54.50           N  
ATOM    935  CA  THR A 523      34.631  52.920  -4.848  1.00 54.88           C  
ATOM    936  C   THR A 523      33.793  51.622  -4.891  1.00 55.25           C  
ATOM    937  O   THR A 523      33.131  51.300  -3.923  1.00 55.51           O  
ATOM    938  CB  THR A 523      36.059  52.676  -4.320  1.00 54.83           C  
ATOM    939  OG1 THR A 523      36.726  51.723  -5.142  1.00 54.87           O  
ATOM    940  CG2 THR A 523      36.054  52.178  -2.845  1.00 53.92           C  
ATOM    941  N   GLY A 524      33.782  50.896  -6.005  1.00 55.99           N  
ATOM    942  CA  GLY A 524      32.873  49.733  -6.164  1.00 56.46           C  
ATOM    943  C   GLY A 524      32.179  49.763  -7.512  1.00 57.19           C  
ATOM    944  O   GLY A 524      32.666  50.442  -8.417  1.00 58.05           O  
ATOM    945  N   CYS A 525      31.058  49.033  -7.660  1.00 57.69           N  
ATOM    946  CA  CYS A 525      30.224  48.978  -8.919  1.00 57.59           C  
ATOM    947  C   CYS A 525      30.719  48.018  -9.999  1.00 57.33           C  
ATOM    948  O   CYS A 525      30.108  47.910 -11.077  1.00 57.00           O  
ATOM    949  CB  CYS A 525      30.038  50.367  -9.539  1.00 57.64           C  
ATOM    950  SG  CYS A 525      29.885  51.683  -8.303  1.00 61.44           S  
ATOM    951  N   THR A 529      35.202  46.420  -8.812  1.00 53.19           N  
ATOM    952  CA  THR A 529      35.559  46.311  -7.393  1.00 53.50           C  
ATOM    953  C   THR A 529      36.476  47.504  -7.039  1.00 53.41           C  
ATOM    954  O   THR A 529      36.427  48.553  -7.708  1.00 53.82           O  
ATOM    955  CB  THR A 529      36.220  44.917  -7.058  1.00 53.57           C  
ATOM    956  OG1 THR A 529      37.633  44.978  -7.278  1.00 54.45           O  
ATOM    957  CG2 THR A 529      35.628  43.768  -7.918  1.00 53.34           C  
ATOM    958  N   GLY A 530      37.305  47.353  -6.017  1.00 52.94           N  
ATOM    959  CA  GLY A 530      38.207  48.432  -5.585  1.00 52.87           C  
ATOM    960  C   GLY A 530      38.612  48.213  -4.136  1.00 52.51           C  
ATOM    961  O   GLY A 530      38.050  47.360  -3.465  1.00 52.18           O  
ATOM    962  N   ILE A 531      39.583  48.980  -3.656  1.00 52.34           N  
ATOM    963  CA  ILE A 531      40.100  48.827  -2.308  1.00 52.43           C  
ATOM    964  C   ILE A 531      39.770  50.042  -1.457  1.00 52.60           C  
ATOM    965  O   ILE A 531      39.950  51.159  -1.914  1.00 53.06           O  
ATOM    966  CB  ILE A 531      41.640  48.639  -2.329  1.00 52.43           C  
ATOM    967  CG1 ILE A 531      42.032  47.452  -3.234  1.00 53.14           C  
ATOM    968  CG2 ILE A 531      42.174  48.436  -0.913  1.00 52.03           C  
ATOM    969  CD1 ILE A 531      43.388  46.806  -2.904  1.00 52.76           C  
ATOM    970  N   ALA A 532      39.309  49.833  -0.215  1.00 53.01           N  
ATOM    971  CA  ALA A 532      39.223  50.910   0.812  1.00 52.70           C  
ATOM    972  C   ALA A 532      40.178  50.655   2.004  1.00 52.89           C  
ATOM    973  O   ALA A 532      40.006  49.691   2.767  1.00 52.55           O  
ATOM    974  CB  ALA A 532      37.770  51.092   1.319  1.00 52.44           C  
ATOM    975  N   THR A 533      41.178  51.531   2.166  1.00 53.07           N  
ATOM    976  CA  THR A 533      42.102  51.475   3.321  1.00 53.07           C  
ATOM    977  C   THR A 533      41.740  52.511   4.381  1.00 53.30           C  
ATOM    978  O   THR A 533      41.562  53.677   4.068  1.00 54.43           O  
ATOM    979  CB  THR A 533      43.581  51.636   2.908  1.00 53.13           C  
ATOM    980  OG1 THR A 533      43.878  50.731   1.839  1.00 51.75           O  
ATOM    981  CG2 THR A 533      44.522  51.343   4.103  1.00 52.39           C  
ATOM    982  N   THR A 534      41.623  52.073   5.629  1.00 53.25           N  
ATOM    983  CA  THR A 534      41.184  52.922   6.738  1.00 52.95           C  
ATOM    984  C   THR A 534      42.170  52.795   7.909  1.00 52.94           C  
ATOM    985  O   THR A 534      42.480  51.712   8.376  1.00 53.28           O  
ATOM    986  CB  THR A 534      39.785  52.531   7.167  1.00 52.88           C  
ATOM    987  OG1 THR A 534      38.899  52.685   6.054  1.00 53.09           O  
ATOM    988  CG2 THR A 534      39.303  53.388   8.299  1.00 53.85           C  
ATOM    989  N   PHE A 535      42.731  53.916   8.313  1.00 52.88           N  
ATOM    990  CA  PHE A 535      43.709  53.961   9.384  1.00 52.10           C  
ATOM    991  C   PHE A 535      42.907  54.140  10.678  1.00 52.07           C  
ATOM    992  O   PHE A 535      42.141  55.095  10.819  1.00 52.02           O  
ATOM    993  CB  PHE A 535      44.665  55.146   9.191  1.00 51.66           C  
ATOM    994  CG  PHE A 535      45.552  55.075   7.945  1.00 51.12           C  
ATOM    995  CD1 PHE A 535      45.853  53.875   7.315  1.00 51.06           C  
ATOM    996  CD2 PHE A 535      46.121  56.225   7.443  1.00 49.80           C  
ATOM    997  CE1 PHE A 535      46.654  53.848   6.196  1.00 48.56           C  
ATOM    998  CE2 PHE A 535      46.924  56.181   6.345  1.00 49.95           C  
ATOM    999  CZ  PHE A 535      47.198  54.979   5.728  1.00 49.57           C  
ATOM   1000  N   ILE A 536      43.045  53.204  11.602  1.00 52.08           N  
ATOM   1001  CA  ILE A 536      42.386  53.337  12.895  1.00 51.68           C  
ATOM   1002  C   ILE A 536      43.483  53.378  13.959  1.00 52.23           C  
ATOM   1003  O   ILE A 536      44.602  52.877  13.720  1.00 52.85           O  
ATOM   1004  CB  ILE A 536      41.307  52.201  13.151  1.00 52.14           C  
ATOM   1005  CG1 ILE A 536      41.945  50.842  13.398  1.00 50.22           C  
ATOM   1006  CG2 ILE A 536      40.252  52.094  11.973  1.00 49.81           C  
ATOM   1007  CD1 ILE A 536      40.895  49.770  13.725  1.00 49.78           C  
ATOM   1008  N   ASN A 537      43.182  53.990  15.105  1.00 52.06           N  
ATOM   1009  CA  ASN A 537      44.072  53.917  16.278  1.00 52.91           C  
ATOM   1010  C   ASN A 537      43.412  54.314  17.641  1.00 53.08           C  
ATOM   1011  O   ASN A 537      42.189  54.400  17.764  1.00 52.46           O  
ATOM   1012  CB  ASN A 537      45.342  54.745  16.011  1.00 52.63           C  
ATOM   1013  CG  ASN A 537      45.049  56.221  15.850  1.00 52.44           C  
ATOM   1014  OD1 ASN A 537      44.076  56.725  16.420  1.00 53.16           O  
ATOM   1015  ND2 ASN A 537      45.883  56.931  15.067  1.00 49.61           N  
ATOM   1016  N   LYS A 538      44.241  54.572  18.643  1.00 53.30           N  
ATOM   1017  CA  LYS A 538      43.800  54.803  20.015  1.00 53.93           C  
ATOM   1018  C   LYS A 538      42.597  55.742  20.123  1.00 54.43           C  
ATOM   1019  O   LYS A 538      41.691  55.509  20.922  1.00 54.77           O  
ATOM   1020  CB  LYS A 538      44.970  55.402  20.826  1.00 54.11           C  
ATOM   1021  CG  LYS A 538      45.238  54.760  22.167  1.00 54.24           C  
ATOM   1022  CD  LYS A 538      46.485  55.425  22.813  1.00 54.44           C  
ATOM   1023  CE  LYS A 538      46.533  55.208  24.331  1.00 55.05           C  
ATOM   1024  NZ  LYS A 538      47.716  55.839  25.000  1.00 54.60           N  
ATOM   1025  N   ALA A 539      42.592  56.810  19.330  1.00 54.83           N  
ATOM   1026  CA  ALA A 539      41.593  57.856  19.481  1.00 55.12           C  
ATOM   1027  C   ALA A 539      40.161  57.386  19.174  1.00 55.70           C  
ATOM   1028  O   ALA A 539      39.228  57.871  19.755  1.00 56.14           O  
ATOM   1029  CB  ALA A 539      41.967  59.053  18.643  1.00 54.89           C  
ATOM   1030  N   CYS A 540      39.975  56.426  18.294  1.00 56.71           N  
ATOM   1031  CA  CYS A 540      38.623  55.929  18.046  1.00 58.59           C  
ATOM   1032  C   CYS A 540      37.925  55.405  19.286  1.00 59.02           C  
ATOM   1033  O   CYS A 540      38.501  54.635  20.065  1.00 58.84           O  
ATOM   1034  CB  CYS A 540      38.610  54.786  17.033  1.00 58.61           C  
ATOM   1035  SG  CYS A 540      39.543  55.159  15.549  1.00 63.03           S  
ATOM   1036  N   ASP A 541      36.659  55.791  19.428  1.00 59.90           N  
ATOM   1037  CA  ASP A 541      35.804  55.237  20.464  1.00 60.47           C  
ATOM   1038  C   ASP A 541      35.460  53.791  20.129  1.00 60.27           C  
ATOM   1039  O   ASP A 541      35.370  53.403  18.958  1.00 59.59           O  
ATOM   1040  CB  ASP A 541      34.524  56.071  20.656  1.00 60.78           C  
ATOM   1041  CG  ASP A 541      34.758  57.335  21.483  1.00 62.67           C  
ATOM   1042  OD1 ASP A 541      35.842  57.481  22.107  1.00 66.28           O  
ATOM   1043  OD2 ASP A 541      33.848  58.199  21.519  1.00 66.10           O  
ATOM   1044  N   GLU A 542      35.297  53.014  21.195  1.00 60.32           N  
ATOM   1045  CA  GLU A 542      34.919  51.602  21.132  1.00 60.65           C  
ATOM   1046  C   GLU A 542      33.769  51.349  20.137  1.00 60.18           C  
ATOM   1047  O   GLU A 542      33.851  50.482  19.257  1.00 60.35           O  
ATOM   1048  CB  GLU A 542      34.517  51.140  22.550  1.00 60.68           C  
ATOM   1049  CG  GLU A 542      35.069  49.774  22.938  1.00 62.10           C  
ATOM   1050  CD  GLU A 542      34.502  49.242  24.248  1.00 62.07           C  
ATOM   1051  OE1 GLU A 542      34.231  50.059  25.151  1.00 64.82           O  
ATOM   1052  OE2 GLU A 542      34.340  48.003  24.372  1.00 63.44           O  
ATOM   1053  N   SER A 543      32.710  52.144  20.285  1.00 59.84           N  
ATOM   1054  CA  SER A 543      31.482  52.022  19.505  1.00 59.40           C  
ATOM   1055  C   SER A 543      31.696  51.966  17.999  1.00 59.02           C  
ATOM   1056  O   SER A 543      31.169  51.068  17.343  1.00 59.55           O  
ATOM   1057  CB  SER A 543      30.571  53.188  19.847  1.00 59.48           C  
ATOM   1058  OG  SER A 543      31.333  54.380  19.921  1.00 60.49           O  
ATOM   1059  N   VAL A 544      32.461  52.908  17.444  1.00 58.48           N  
ATOM   1060  CA  VAL A 544      32.737  52.891  15.993  1.00 58.18           C  
ATOM   1061  C   VAL A 544      33.569  51.678  15.612  1.00 57.88           C  
ATOM   1062  O   VAL A 544      33.385  51.092  14.527  1.00 57.70           O  
ATOM   1063  CB  VAL A 544      33.504  54.151  15.432  1.00 58.30           C  
ATOM   1064  CG1 VAL A 544      32.847  54.589  14.093  1.00 57.52           C  
ATOM   1065  CG2 VAL A 544      33.545  55.281  16.412  1.00 57.18           C  
ATOM   1066  N   LEU A 545      34.489  51.307  16.501  1.00 57.44           N  
ATOM   1067  CA  LEU A 545      35.325  50.136  16.247  1.00 57.31           C  
ATOM   1068  C   LEU A 545      34.488  48.870  16.210  1.00 57.51           C  
ATOM   1069  O   LEU A 545      34.731  47.995  15.371  1.00 57.74           O  
ATOM   1070  CB  LEU A 545      36.427  50.027  17.277  1.00 56.66           C  
ATOM   1071  CG  LEU A 545      37.349  51.240  17.247  1.00 54.86           C  
ATOM   1072  CD1 LEU A 545      38.318  51.169  18.422  1.00 52.35           C  
ATOM   1073  CD2 LEU A 545      38.064  51.293  15.932  1.00 52.15           C  
ATOM   1074  N   MET A 546      33.480  48.793  17.081  1.00 57.66           N  
ATOM   1075  CA  MET A 546      32.582  47.627  17.084  1.00 58.65           C  
ATOM   1076  C   MET A 546      31.766  47.586  15.812  1.00 58.14           C  
ATOM   1077  O   MET A 546      31.550  46.515  15.255  1.00 58.71           O  
ATOM   1078  CB  MET A 546      31.599  47.628  18.249  1.00 58.58           C  
ATOM   1079  CG  MET A 546      32.187  48.065  19.552  1.00 60.27           C  
ATOM   1080  SD  MET A 546      32.007  46.834  20.823  1.00 60.97           S  
ATOM   1081  CE  MET A 546      33.402  45.821  20.275  1.00 61.46           C  
ATOM   1082  N   ASP A 547      31.285  48.748  15.388  1.00 57.24           N  
ATOM   1083  CA  ASP A 547      30.549  48.846  14.142  1.00 57.12           C  
ATOM   1084  C   ASP A 547      31.451  48.613  12.954  1.00 56.53           C  
ATOM   1085  O   ASP A 547      31.059  47.949  12.020  1.00 56.14           O  
ATOM   1086  CB  ASP A 547      29.839  50.192  14.042  1.00 57.54           C  
ATOM   1087  CG  ASP A 547      28.854  50.395  15.172  1.00 58.26           C  
ATOM   1088  OD1 ASP A 547      28.936  49.612  16.142  1.00 60.01           O  
ATOM   1089  OD2 ASP A 547      28.008  51.305  15.102  1.00 58.29           O  
ATOM   1090  N   LEU A 548      32.686  49.093  12.990  1.00 56.45           N  
ATOM   1091  CA  LEU A 548      33.590  48.720  11.911  1.00 56.53           C  
ATOM   1092  C   LEU A 548      33.785  47.203  11.922  1.00 56.88           C  
ATOM   1093  O   LEU A 548      33.789  46.554  10.866  1.00 57.46           O  
ATOM   1094  CB  LEU A 548      34.914  49.440  12.023  1.00 56.03           C  
ATOM   1095  CG  LEU A 548      35.891  49.242  10.870  1.00 55.82           C  
ATOM   1096  CD1 LEU A 548      35.270  49.386   9.456  1.00 53.69           C  
ATOM   1097  CD2 LEU A 548      37.018  50.250  11.109  1.00 54.77           C  
ATOM   1098  N   LYS A 549      33.904  46.633  13.119  1.00 56.75           N  
ATOM   1099  CA  LYS A 549      34.158  45.215  13.222  1.00 56.87           C  
ATOM   1100  C   LYS A 549      32.956  44.473  12.717  1.00 56.19           C  
ATOM   1101  O   LYS A 549      33.064  43.529  11.965  1.00 56.66           O  
ATOM   1102  CB  LYS A 549      34.431  44.786  14.668  1.00 57.05           C  
ATOM   1103  CG  LYS A 549      35.029  43.382  14.738  1.00 56.68           C  
ATOM   1104  CD  LYS A 549      34.871  42.756  16.129  1.00 57.56           C  
ATOM   1105  CE  LYS A 549      35.842  41.572  16.258  1.00 57.46           C  
ATOM   1106  NZ  LYS A 549      35.586  40.780  17.507  1.00 57.81           N  
ATOM   1107  N   ALA A 550      31.794  44.898  13.165  1.00 55.84           N  
ATOM   1108  CA  ALA A 550      30.560  44.269  12.763  1.00 55.18           C  
ATOM   1109  C   ALA A 550      30.430  44.310  11.249  1.00 55.00           C  
ATOM   1110  O   ALA A 550      29.951  43.366  10.641  1.00 54.43           O  
ATOM   1111  CB  ALA A 550      29.416  44.983  13.400  1.00 55.34           C  
ATOM   1112  N   LEU A 551      30.878  45.410  10.643  1.00 54.95           N  
ATOM   1113  CA  LEU A 551      30.761  45.610   9.204  1.00 54.53           C  
ATOM   1114  C   LEU A 551      31.723  44.711   8.442  1.00 54.11           C  
ATOM   1115  O   LEU A 551      31.338  44.071   7.463  1.00 54.28           O  
ATOM   1116  CB  LEU A 551      31.053  47.064   8.877  1.00 55.07           C  
ATOM   1117  CG  LEU A 551      30.650  47.642   7.534  1.00 54.71           C  
ATOM   1118  CD1 LEU A 551      29.182  47.973   7.627  1.00 55.25           C  
ATOM   1119  CD2 LEU A 551      31.476  48.902   7.190  1.00 54.58           C  
ATOM   1120  N   LEU A 552      32.972  44.638   8.877  1.00 53.23           N  
ATOM   1121  CA  LEU A 552      33.933  43.823   8.132  1.00 53.49           C  
ATOM   1122  C   LEU A 552      33.481  42.362   8.085  1.00 53.82           C  
ATOM   1123  O   LEU A 552      33.599  41.655   7.069  1.00 53.43           O  
ATOM   1124  CB  LEU A 552      35.300  43.913   8.765  1.00 53.44           C  
ATOM   1125  CG  LEU A 552      35.930  45.302   8.644  1.00 53.81           C  
ATOM   1126  CD1 LEU A 552      36.929  45.529   9.773  1.00 54.52           C  
ATOM   1127  CD2 LEU A 552      36.587  45.454   7.276  1.00 52.38           C  
ATOM   1128  N   LEU A 553      32.933  41.927   9.212  1.00 53.46           N  
ATOM   1129  CA  LEU A 553      32.499  40.569   9.368  1.00 52.86           C  
ATOM   1130  C   LEU A 553      31.315  40.253   8.469  1.00 52.89           C  
ATOM   1131  O   LEU A 553      31.267  39.185   7.807  1.00 53.45           O  
ATOM   1132  CB  LEU A 553      32.168  40.320  10.852  1.00 53.17           C  
ATOM   1133  CG  LEU A 553      33.388  40.067  11.752  1.00 51.51           C  
ATOM   1134  CD1 LEU A 553      33.008  40.098  13.222  1.00 49.26           C  
ATOM   1135  CD2 LEU A 553      33.995  38.735  11.341  1.00 47.76           C  
ATOM   1136  N   GLU A 554      30.346  41.165   8.448  1.00 52.62           N  
ATOM   1137  CA  GLU A 554      29.178  41.040   7.537  1.00 51.94           C  
ATOM   1138  C   GLU A 554      29.630  41.129   6.091  1.00 51.20           C  
ATOM   1139  O   GLU A 554      29.159  40.398   5.240  1.00 51.15           O  
ATOM   1140  CB  GLU A 554      28.166  42.147   7.818  1.00 51.51           C  
ATOM   1141  CG  GLU A 554      27.321  41.914   9.042  1.00 52.21           C  
ATOM   1142  CD  GLU A 554      26.842  43.195   9.743  1.00 53.25           C  
ATOM   1143  OE1 GLU A 554      27.237  44.318   9.345  1.00 52.13           O  
ATOM   1144  OE2 GLU A 554      26.049  43.055  10.714  1.00 56.12           O  
ATOM   1145  N   ALA A 555      30.567  42.036   5.826  1.00 51.31           N  
ATOM   1146  CA  ALA A 555      31.150  42.167   4.500  1.00 50.93           C  
ATOM   1147  C   ALA A 555      32.028  40.990   4.141  1.00 51.02           C  
ATOM   1148  O   ALA A 555      32.432  40.883   3.011  1.00 51.42           O  
ATOM   1149  CB  ALA A 555      31.934  43.409   4.418  1.00 50.47           C  
ATOM   1150  N   LYS A 556      32.344  40.121   5.095  1.00 51.29           N  
ATOM   1151  CA  LYS A 556      33.198  38.978   4.844  1.00 51.78           C  
ATOM   1152  C   LYS A 556      34.597  39.430   4.519  1.00 52.37           C  
ATOM   1153  O   LYS A 556      35.212  38.908   3.608  1.00 51.76           O  
ATOM   1154  CB  LYS A 556      32.643  38.112   3.718  1.00 51.75           C  
ATOM   1155  CG  LYS A 556      31.225  37.650   3.963  1.00 51.79           C  
ATOM   1156  CD  LYS A 556      30.601  37.072   2.706  1.00 53.54           C  
ATOM   1157  CE  LYS A 556      30.502  38.086   1.516  1.00 55.45           C  
ATOM   1158  NZ  LYS A 556      29.978  39.475   1.863  1.00 56.51           N  
ATOM   1159  N   GLN A 557      35.093  40.389   5.304  1.00 53.91           N  
ATOM   1160  CA  GLN A 557      36.420  40.972   5.130  1.00 55.33           C  
ATOM   1161  C   GLN A 557      37.394  40.585   6.236  1.00 56.71           C  
ATOM   1162  O   GLN A 557      36.993  40.149   7.308  1.00 58.16           O  
ATOM   1163  CB  GLN A 557      36.332  42.497   5.154  1.00 55.48           C  
ATOM   1164  CG  GLN A 557      35.259  43.074   4.271  1.00 54.49           C  
ATOM   1165  CD  GLN A 557      35.475  42.712   2.854  1.00 53.05           C  
ATOM   1166  OE1 GLN A 557      36.423  43.170   2.214  1.00 51.11           O  
ATOM   1167  NE2 GLN A 557      34.609  41.865   2.342  1.00 52.06           N  
ATOM   1168  N   LYS A 558      38.673  40.809   5.975  1.00 57.39           N  
ATOM   1169  CA  LYS A 558      39.696  40.643   6.981  1.00 58.16           C  
ATOM   1170  C   LYS A 558      39.440  41.617   8.120  1.00 58.51           C  
ATOM   1171  O   LYS A 558      39.195  42.813   7.904  1.00 58.95           O  
ATOM   1172  CB  LYS A 558      41.089  40.868   6.385  1.00 58.11           C  
ATOM   1173  CG  LYS A 558      41.511  39.748   5.422  1.00 58.17           C  
ATOM   1174  CD  LYS A 558      42.827  40.084   4.716  1.00 58.56           C  
ATOM   1175  CE  LYS A 558      43.160  39.067   3.616  1.00 59.49           C  
ATOM   1176  NZ  LYS A 558      42.865  37.637   4.022  1.00 62.07           N  
ATOM   1177  N   VAL A 559      39.463  41.082   9.333  1.00 58.73           N  
ATOM   1178  CA  VAL A 559      39.430  41.894  10.530  1.00 58.54           C  
ATOM   1179  C   VAL A 559      40.846  42.002  11.046  1.00 58.28           C  
ATOM   1180  O   VAL A 559      41.485  40.991  11.301  1.00 58.32           O  
ATOM   1181  CB  VAL A 559      38.593  41.235  11.623  1.00 58.75           C  
ATOM   1182  CG1 VAL A 559      38.531  42.182  12.838  1.00 58.68           C  
ATOM   1183  CG2 VAL A 559      37.197  40.832  11.075  1.00 57.54           C  
ATOM   1184  N   PRO A 560      41.340  43.222  11.246  1.00 58.21           N  
ATOM   1185  CA  PRO A 560      42.728  43.304  11.703  1.00 58.33           C  
ATOM   1186  C   PRO A 560      42.806  42.833  13.156  1.00 58.41           C  
ATOM   1187  O   PRO A 560      41.786  42.847  13.839  1.00 58.59           O  
ATOM   1188  CB  PRO A 560      43.027  44.805  11.612  1.00 57.90           C  
ATOM   1189  CG  PRO A 560      41.701  45.450  11.845  1.00 57.68           C  
ATOM   1190  CD  PRO A 560      40.710  44.549  11.156  1.00 57.96           C  
ATOM   1191  N   PRO A 561      43.999  42.476  13.643  1.00 58.85           N  
ATOM   1192  CA  PRO A 561      44.175  41.905  14.993  1.00 58.97           C  
ATOM   1193  C   PRO A 561      43.559  42.739  16.102  1.00 59.09           C  
ATOM   1194  O   PRO A 561      42.743  42.259  16.870  1.00 58.79           O  
ATOM   1195  CB  PRO A 561      45.698  41.865  15.153  1.00 58.98           C  
ATOM   1196  CG  PRO A 561      46.207  41.729  13.760  1.00 59.26           C  
ATOM   1197  CD  PRO A 561      45.290  42.620  12.950  1.00 59.27           C  
ATOM   1198  N   VAL A 562      43.935  44.003  16.128  1.00 59.78           N  
ATOM   1199  CA  VAL A 562      43.434  44.983  17.074  1.00 60.27           C  
ATOM   1200  C   VAL A 562      41.923  44.962  17.315  1.00 60.95           C  
ATOM   1201  O   VAL A 562      41.467  45.284  18.414  1.00 61.14           O  
ATOM   1202  CB  VAL A 562      43.812  46.365  16.544  1.00 60.88           C  
ATOM   1203  CG1 VAL A 562      43.195  47.474  17.403  1.00 60.98           C  
ATOM   1204  CG2 VAL A 562      45.364  46.480  16.442  1.00 60.18           C  
ATOM   1205  N   LEU A 563      41.152  44.614  16.285  1.00 61.57           N  
ATOM   1206  CA  LEU A 563      39.701  44.446  16.424  1.00 62.49           C  
ATOM   1207  C   LEU A 563      39.319  43.008  16.770  1.00 63.19           C  
ATOM   1208  O   LEU A 563      38.272  42.742  17.368  1.00 63.76           O  
ATOM   1209  CB  LEU A 563      38.992  44.850  15.135  1.00 62.24           C  
ATOM   1210  CG  LEU A 563      38.557  46.297  15.077  1.00 62.11           C  
ATOM   1211  CD1 LEU A 563      39.621  47.167  15.638  1.00 61.49           C  
ATOM   1212  CD2 LEU A 563      38.177  46.709  13.622  1.00 63.20           C  
ATOM   1213  N   GLN A 564      40.177  42.075  16.409  1.00 63.81           N  
ATOM   1214  CA  GLN A 564      39.896  40.674  16.653  1.00 64.56           C  
ATOM   1215  C   GLN A 564      39.803  40.386  18.130  1.00 64.39           C  
ATOM   1216  O   GLN A 564      39.259  39.372  18.523  1.00 63.82           O  
ATOM   1217  CB  GLN A 564      40.977  39.794  16.024  1.00 64.86           C  
ATOM   1218  CG  GLN A 564      40.411  38.593  15.267  1.00 67.15           C  
ATOM   1219  CD  GLN A 564      40.955  38.480  13.837  1.00 70.78           C  
ATOM   1220  OE1 GLN A 564      42.110  38.844  13.560  1.00 73.46           O  
ATOM   1221  NE2 GLN A 564      40.122  37.974  12.922  1.00 72.03           N  
ATOM   1222  N   VAL A 565      40.339  41.275  18.955  1.00 64.77           N  
ATOM   1223  CA  VAL A 565      40.196  41.078  20.376  1.00 65.33           C  
ATOM   1224  C   VAL A 565      38.868  41.620  20.858  1.00 65.50           C  
ATOM   1225  O   VAL A 565      38.283  41.044  21.770  1.00 65.64           O  
ATOM   1226  CB  VAL A 565      41.328  41.709  21.210  1.00 65.57           C  
ATOM   1227  CG1 VAL A 565      41.423  40.983  22.536  1.00 64.68           C  
ATOM   1228  CG2 VAL A 565      42.657  41.636  20.484  1.00 65.55           C  
ATOM   1229  N   LEU A 566      38.383  42.700  20.249  1.00 65.55           N  
ATOM   1230  CA  LEU A 566      37.270  43.432  20.834  1.00 65.90           C  
ATOM   1231  C   LEU A 566      36.357  42.542  21.643  1.00 66.47           C  
ATOM   1232  O   LEU A 566      36.265  42.712  22.867  1.00 67.07           O  
ATOM   1233  CB  LEU A 566      36.485  44.219  19.803  1.00 66.02           C  
ATOM   1234  CG  LEU A 566      36.740  45.707  20.016  1.00 65.11           C  
ATOM   1235  CD1 LEU A 566      38.209  45.954  20.090  1.00 65.61           C  
ATOM   1236  CD2 LEU A 566      36.112  46.521  18.911  1.00 65.62           C  
ATOM   1237  N   HIS A 567      35.706  41.573  21.012  1.00 66.56           N  
ATOM   1238  CA  HIS A 567      34.991  40.550  21.806  1.00 66.53           C  
ATOM   1239  C   HIS A 567      35.412  39.161  21.385  1.00 66.36           C  
ATOM   1240  O   HIS A 567      34.955  38.674  20.366  1.00 66.66           O  
ATOM   1241  CB  HIS A 567      33.467  40.684  21.655  1.00 66.53           C  
ATOM   1242  CG  HIS A 567      32.903  41.965  22.200  1.00 66.59           C  
ATOM   1243  ND1 HIS A 567      32.069  42.011  23.298  1.00 65.84           N  
ATOM   1244  CD2 HIS A 567      33.041  43.246  21.783  1.00 66.23           C  
ATOM   1245  CE1 HIS A 567      31.726  43.263  23.540  1.00 64.88           C  
ATOM   1246  NE2 HIS A 567      32.302  44.033  22.635  1.00 65.19           N  
ATOM   1247  N   CYS A 568      36.279  38.532  22.160  1.00 66.35           N  
ATOM   1248  CA  CYS A 568      36.629  37.129  21.951  1.00 66.74           C  
ATOM   1249  C   CYS A 568      35.644  36.244  22.705  1.00 66.19           C  
ATOM   1250  O   CYS A 568      36.006  35.547  23.657  1.00 65.75           O  
ATOM   1251  CB  CYS A 568      38.059  36.845  22.439  1.00 67.06           C  
ATOM   1252  SG  CYS A 568      39.187  38.264  22.334  1.00 69.36           S  
TER    1253      CYS A 568                                                      
END
MOLECULE T0493.pdb
ATOM      1  N   ALA     3      23.401  57.599  -8.026  1.00 52.44           N  
ATOM      2  CA  ALA     3      22.280  56.642  -7.749  1.00 52.03           C  
ATOM      3  C   ALA     3      22.285  55.493  -8.753  1.00 51.73           C  
ATOM      4  O   ALA     3      21.653  54.454  -8.529  1.00 52.23           O  
ATOM      5  CB  ALA     3      20.926  57.364  -7.768  1.00 52.53           C  
ATOM      6  N   SER     4      22.988  55.695  -9.867  1.00 50.50           N  
ATOM      7  CA  SER     4      23.166  54.655 -10.884  1.00 48.89           C  
ATOM      8  C   SER     4      24.388  53.791 -10.566  1.00 48.11           C  
ATOM      9  O   SER     4      24.427  52.605 -10.904  1.00 47.53           O  
ATOM     10  CB  SER     4      23.323  55.285 -12.269  1.00 49.13           C  
ATOM     11  OG  SER     4      22.194  56.066 -12.603  1.00 48.13           O  
ATOM     12  N   TYR     5      25.380  54.406  -9.923  1.00 46.98           N  
ATOM     13  CA  TYR     5      26.605  53.705  -9.531  1.00 46.69           C  
ATOM     14  C   TYR     5      26.361  52.806  -8.328  1.00 46.91           C  
ATOM     15  O   TYR     5      25.677  53.204  -7.375  1.00 48.01           O  
ATOM     16  CB  TYR     5      27.703  54.703  -9.152  1.00 46.13           C  
ATOM     17  CG  TYR     5      28.294  55.433 -10.331  1.00 45.34           C  
ATOM     18  CD1 TYR     5      29.316  54.856 -11.091  1.00 46.08           C  
ATOM     19  CD2 TYR     5      27.813  56.695 -10.702  1.00 46.11           C  
ATOM     20  CE1 TYR     5      29.867  55.532 -12.191  1.00 44.81           C  
ATOM     21  CE2 TYR     5      28.343  57.375 -11.783  1.00 44.56           C  
ATOM     22  CZ  TYR     5      29.373  56.789 -12.530  1.00 45.80           C  
ATOM     23  OH  TYR     5      29.901  57.464 -13.612  1.00 42.86           O  
ATOM     24  N   ARG     6      26.965  51.619  -8.353  1.00 45.73           N  
ATOM     25  CA  ARG     6      26.926  50.711  -7.199  1.00 44.82           C  
ATOM     26  C   ARG     6      28.313  50.148  -6.897  1.00 42.16           C  
ATOM     27  O   ARG     6      29.076  49.831  -7.829  1.00 42.87           O  
ATOM     28  CB  ARG     6      25.938  49.587  -7.455  1.00 45.46           C  
ATOM     29  CG  ARG     6      24.543  49.931  -7.000  1.00 49.70           C  
ATOM     30  CD  ARG     6      23.490  49.496  -7.997  1.00 54.87           C  
ATOM     31  NE  ARG     6      22.194  49.262  -7.353  1.00 60.25           N  
ATOM     32  CZ  ARG     6      21.451  50.193  -6.749  1.00 61.64           C  
ATOM     33  NH1 ARG     6      20.288  49.850  -6.203  1.00 62.66           N  
ATOM     34  NH2 ARG     6      21.859  51.458  -6.679  1.00 62.66           N  
ATOM     35  N   SER     7      28.633  50.040  -5.607  1.00 40.44           N  
ATOM     36  CA  SER     7      29.901  49.481  -5.187  1.00 37.38           C  
ATOM     37  C   SER     7      29.824  47.966  -5.225  1.00 34.65           C  
ATOM     38  O   SER     7      28.749  47.364  -5.449  1.00 34.03           O  
ATOM     39  CB  SER     7      30.302  49.894  -3.765  1.00 37.76           C  
ATOM     40  OG  SER     7      30.267  51.294  -3.532  1.00 43.12           O  
ATOM     41  N   THR     8      30.977  47.353  -5.003  1.00 30.63           N  
ATOM     42  CA  THR     8      31.060  45.900  -4.883  1.00 28.67           C  
ATOM     43  C   THR     8      30.276  45.477  -3.653  1.00 27.45           C  
ATOM     44  O   THR     8      30.089  46.259  -2.722  1.00 27.39           O  
ATOM     45  CB  THR     8      32.505  45.447  -4.649  1.00 28.34           C  
ATOM     46  OG1 THR     8      32.987  46.023  -3.437  1.00 28.77           O  
ATOM     47  CG2 THR     8      33.419  45.819  -5.868  1.00 28.61           C  
ATOM     48  N   GLN     9      29.839  44.218  -3.657  1.00 26.98           N  
ATOM     49  CA  GLN     9      29.210  43.680  -2.442  1.00 25.83           C  
ATOM     50  C   GLN     9      30.078  43.839  -1.189  1.00 26.06           C  
ATOM     51  O   GLN     9      29.558  44.057  -0.092  1.00 25.99           O  
ATOM     52  CB  GLN     9      28.931  42.204  -2.647  1.00 26.34           C  
ATOM     53  CG  GLN     9      28.262  41.594  -1.406  1.00 26.68           C  
ATOM     54  CD  GLN     9      27.711  40.223  -1.694  1.00 26.31           C  
ATOM     55  OE1 GLN     9      28.304  39.434  -2.445  1.00 27.31           O  
ATOM     56  NE2 GLN     9      26.561  39.927  -1.100  1.00 28.33           N  
ATOM     57  N   GLN    10      31.388  43.697  -1.348  1.00 26.07           N  
ATOM     58  CA  GLN    10      32.318  43.781  -0.211  1.00 26.63           C  
ATOM     59  C   GLN    10      32.240  45.169   0.423  1.00 27.17           C  
ATOM     60  O   GLN    10      32.144  45.301   1.650  1.00 28.40           O  
ATOM     61  CB  GLN    10      33.741  43.454  -0.677  1.00 28.52           C  
ATOM     62  CG  GLN    10      33.959  41.941  -0.882  1.00 29.61           C  
ATOM     63  CD  GLN    10      33.297  41.361  -2.098  1.00 32.71           C  
ATOM     64  OE1 GLN    10      32.935  42.059  -3.052  1.00 30.40           O  
ATOM     65  NE2 GLN    10      33.126  40.058  -2.066  1.00 35.11           N  
ATOM     66  N   ILE    11      32.307  46.203  -0.413  1.00 26.17           N  
ATOM     67  CA  ILE    11      32.245  47.587   0.101  1.00 26.61           C  
ATOM     68  C   ILE    11      30.853  47.893   0.661  1.00 26.84           C  
ATOM     69  O   ILE    11      30.741  48.492   1.724  1.00 27.77           O  
ATOM     70  CB  ILE    11      32.682  48.578  -1.024  1.00 27.26           C  
ATOM     71  CG1 ILE    11      34.173  48.377  -1.254  1.00 28.78           C  
ATOM     72  CG2 ILE    11      32.368  50.027  -0.676  1.00 28.17           C  
ATOM     73  CD1 ILE    11      34.674  49.060  -2.462  1.00 30.15           C  
ATOM     74  N   THR    12      29.803  47.462  -0.048  1.00 27.97           N  
ATOM     75  CA  THR    12      28.425  47.681   0.395  1.00 28.47           C  
ATOM     76  C   THR    12      28.179  47.075   1.781  1.00 28.17           C  
ATOM     77  O   THR    12      27.598  47.702   2.663  1.00 28.31           O  
ATOM     78  CB  THR    12      27.470  47.064  -0.648  1.00 28.90           C  
ATOM     79  OG1 THR    12      27.615  47.801  -1.876  1.00 33.88           O  
ATOM     80  CG2 THR    12      26.034  47.099  -0.145  1.00 32.17           C  
ATOM     81  N   ASP    13      28.632  45.841   1.957  1.00 26.82           N  
ATOM     82  CA  ASP    13      28.428  45.156   3.212  1.00 26.86           C  
ATOM     83  C   ASP    13      29.213  45.757   4.386  1.00 27.51           C  
ATOM     84  O   ASP    13      28.688  45.861   5.487  1.00 28.39           O  
ATOM     85  CB  ASP    13      28.782  43.680   3.074  1.00 25.89           C  
ATOM     86  CG  ASP    13      27.709  42.898   2.381  1.00 27.70           C  
ATOM     87  OD1 ASP    13      26.612  43.439   2.053  1.00 27.09           O  
ATOM     88  OD2 ASP    13      27.949  41.684   2.123  1.00 28.54           O  
ATOM     89  N   PHE    14      30.474  46.084   4.146  1.00 27.45           N  
ATOM     90  CA  PHE    14      31.265  46.782   5.153  1.00 28.16           C  
ATOM     91  C   PHE    14      30.615  48.139   5.524  1.00 28.21           C  
ATOM     92  O   PHE    14      30.364  48.439   6.721  1.00 28.31           O  
ATOM     93  CB  PHE    14      32.675  46.986   4.612  1.00 27.51           C  
ATOM     94  CG  PHE    14      33.532  47.847   5.512  1.00 28.17           C  
ATOM     95  CD1 PHE    14      34.274  47.261   6.534  1.00 29.96           C  
ATOM     96  CD2 PHE    14      33.658  49.205   5.273  1.00 29.46           C  
ATOM     97  CE1 PHE    14      35.096  48.048   7.394  1.00 30.68           C  
ATOM     98  CE2 PHE    14      34.457  50.005   6.098  1.00 27.95           C  
ATOM     99  CZ  PHE    14      35.200  49.439   7.140  1.00 28.47           C  
ATOM    100  N   THR    15      30.283  48.943   4.505  1.00 28.84           N  
ATOM    101  CA  THR    15      29.765  50.261   4.814  1.00 29.34           C  
ATOM    102  C   THR    15      28.397  50.255   5.490  1.00 29.68           C  
ATOM    103  O   THR    15      28.132  51.096   6.351  1.00 29.38           O  
ATOM    104  CB  THR    15      29.749  51.174   3.578  1.00 29.94           C  
ATOM    105  OG1 THR    15      28.857  50.635   2.583  1.00 32.54           O  
ATOM    106  CG2 THR    15      31.148  51.322   3.003  1.00 29.85           C  
ATOM    107  N   LYS    16      27.525  49.312   5.117  1.00 28.55           N  
ATOM    108  CA  LYS    16      26.176  49.306   5.689  1.00 30.01           C  
ATOM    109  C   LYS    16      26.248  49.189   7.225  1.00 29.93           C  
ATOM    110  O   LYS    16      25.403  49.712   7.929  1.00 29.63           O  
ATOM    111  CB  LYS    16      25.313  48.190   5.082  1.00 30.44           C  
ATOM    112  CG  LYS    16      25.663  46.803   5.574  1.00 35.20           C  
ATOM    113  CD  LYS    16      25.015  45.723   4.761  1.00 39.23           C  
ATOM    114  CE  LYS    16      25.507  44.375   5.271  1.00 39.43           C  
ATOM    115  NZ  LYS    16      24.716  43.343   4.422  1.00 40.41           N  
ATOM    116  N   GLU    17      27.274  48.508   7.735  1.00 28.62           N  
ATOM    117  CA  GLU    17      27.337  48.200   9.166  1.00 29.00           C  
ATOM    118  C   GLU    17      27.886  49.381   9.953  1.00 28.85           C  
ATOM    119  O   GLU    17      27.931  49.337  11.194  1.00 29.26           O  
ATOM    120  CB  GLU    17      28.186  46.954   9.390  1.00 29.41           C  
ATOM    121  CG  GLU    17      27.555  45.719   8.717  1.00 28.74           C  
ATOM    122  CD  GLU    17      27.869  44.402   9.414  1.00 30.24           C  
ATOM    123  OE1 GLU    17      28.772  44.329  10.248  1.00 29.26           O  
ATOM    124  OE2 GLU    17      27.242  43.383   9.026  1.00 29.26           O  
ATOM    125  N   ILE    18      28.312  50.430   9.235  1.00 27.91           N  
ATOM    126  CA  ILE    18      28.758  51.675   9.932  1.00 28.91           C  
ATOM    127  C   ILE    18      27.551  52.408  10.542  1.00 29.56           C  
ATOM    128  O   ILE    18      27.669  53.103  11.575  1.00 30.26           O  
ATOM    129  CB  ILE    18      29.527  52.600   8.995  1.00 27.93           C  
ATOM    130  CG1 ILE    18      30.780  51.889   8.498  1.00 29.55           C  
ATOM    131  CG2 ILE    18      29.953  53.923   9.729  1.00 29.06           C  
ATOM    132  CD1 ILE    18      31.574  52.591   7.399  1.00 29.60           C  
ATOM    133  N   LEU    19      26.407  52.280   9.878  1.00 31.41           N  
ATOM    134  CA  LEU    19      25.173  52.919  10.345  1.00 32.91           C  
ATOM    135  C   LEU    19      24.494  52.079  11.416  1.00 35.65           C  
ATOM    136  O   LEU    19      24.540  50.864  11.366  1.00 35.98           O  
ATOM    137  CB  LEU    19      24.190  53.114   9.185  1.00 32.71           C  
ATOM    138  CG  LEU    19      24.755  54.000   8.070  1.00 31.21           C  
ATOM    139  CD1 LEU    19      23.744  54.168   6.933  1.00 34.69           C  
ATOM    140  CD2 LEU    19      25.163  55.388   8.603  1.00 34.71           C  
ATOM    141  N   VAL    20      23.880  52.736  12.383  1.00 37.78           N  
ATOM    142  CA  VAL    20      22.991  52.053  13.329  1.00 42.64           C  
ATOM    143  C   VAL    20      21.570  52.516  12.940  1.00 45.75           C  
ATOM    144  O   VAL    20      21.182  53.647  13.205  1.00 47.61           O  
ATOM    145  CB  VAL    20      23.402  52.348  14.801  1.00 42.32           C  
ATOM    146  CG1 VAL    20      24.821  51.892  15.026  1.00 42.84           C  
ATOM    147  CG2 VAL    20      23.335  53.817  15.121  1.00 44.10           C  
ATOM    148  N   ASN    21      20.833  51.659  12.249  1.00 49.44           N  
ATOM    149  CA  ASN    21      19.663  52.112  11.475  1.00 51.70           C  
ATOM    150  C   ASN    21      18.342  52.025  12.233  1.00 52.61           C  
ATOM    151  O   ASN    21      17.631  53.027  12.385  1.00 54.40           O  
ATOM    152  CB  ASN    21      19.561  51.341  10.146  1.00 52.55           C  
ATOM    153  CG  ASN    21      20.582  51.814   9.098  1.00 54.02           C  
ATOM    154  OD1 ASN    21      21.369  51.016   8.583  1.00 54.60           O  
ATOM    155  ND2 ASN    21      20.542  53.106   8.755  1.00 55.63           N  
ATOM    156  N   ARG    30      28.631  42.922  -8.409  1.00 38.27           N  
ATOM    157  CA  ARG    30      29.961  43.479  -8.344  1.00 36.19           C  
ATOM    158  C   ARG    30      30.712  42.833  -7.183  1.00 35.23           C  
ATOM    159  O   ARG    30      30.336  43.012  -6.044  1.00 33.66           O  
ATOM    160  CB  ARG    30      29.880  44.997  -8.149  1.00 37.73           C  
ATOM    161  N   GLN    31      31.760  42.078  -7.489  1.00 34.39           N  
ATOM    162  CA  GLN    31      32.645  41.498  -6.466  1.00 34.32           C  
ATOM    163  C   GLN    31      34.013  42.147  -6.514  1.00 34.46           C  
ATOM    164  O   GLN    31      34.534  42.407  -7.594  1.00 34.89           O  
ATOM    165  CB  GLN    31      32.837  39.999  -6.698  1.00 34.19           C  
ATOM    166  CG  GLN    31      31.554  39.170  -6.608  1.00 34.34           C  
ATOM    167  CD  GLN    31      30.984  39.177  -5.190  1.00 32.72           C  
ATOM    168  OE1 GLN    31      31.681  38.823  -4.234  1.00 34.47           O  
ATOM    169  NE2 GLN    31      29.722  39.597  -5.049  1.00 30.84           N  
ATOM    170  N   GLY    32      34.604  42.365  -5.344  1.00 33.71           N  
ATOM    171  CA  GLY    32      35.937  42.919  -5.240  1.00 33.83           C  
ATOM    172  C   GLY    32      36.623  42.526  -3.941  1.00 34.41           C  
ATOM    173  O   GLY    32      36.130  41.652  -3.203  1.00 34.60           O  
ATOM    174  N   ASP    33      37.758  43.167  -3.671  1.00 33.50           N  
ATOM    175  CA  ASP    33      38.566  42.883  -2.480  1.00 34.03           C  
ATOM    176  C   ASP    33      37.811  43.331  -1.232  1.00 33.04           C  
ATOM    177  O   ASP    33      37.116  44.363  -1.244  1.00 32.12           O  
ATOM    178  CB  ASP    33      39.869  43.702  -2.502  1.00 35.14           C  
ATOM    179  CG  ASP    33      40.862  43.228  -3.529  1.00 40.01           C  
ATOM    180  OD1 ASP    33      40.786  42.069  -3.990  1.00 41.81           O  
ATOM    181  OD2 ASP    33      41.752  44.041  -3.848  1.00 45.63           O  
ATOM    182  N   LEU    34      38.003  42.609  -0.131  1.00 32.93           N  
ATOM    183  CA  LEU    34      37.530  43.143   1.157  1.00 31.92           C  
ATOM    184  C   LEU    34      38.221  44.481   1.434  1.00 31.89           C  
ATOM    185  O   LEU    34      39.422  44.616   1.155  1.00 30.87           O  
ATOM    186  CB  LEU    34      37.870  42.206   2.312  1.00 33.15           C  
ATOM    187  CG  LEU    34      37.117  40.880   2.353  1.00 35.07           C  
ATOM    188  CD1 LEU    34      37.693  39.994   3.470  1.00 36.02           C  
ATOM    189  CD2 LEU    34      35.627  41.090   2.512  1.00 38.24           C  
ATOM    190  N   PRO    35      37.469  45.473   1.973  1.00 31.28           N  
ATOM    191  CA  PRO    35      38.162  46.712   2.435  1.00 29.76           C  
ATOM    192  C   PRO    35      39.307  46.371   3.358  1.00 30.65           C  
ATOM    193  O   PRO    35      39.237  45.401   4.124  1.00 29.39           O  
ATOM    194  CB  PRO    35      37.074  47.475   3.188  1.00 30.31           C  
ATOM    195  CG  PRO    35      35.771  47.010   2.483  1.00 30.47           C  
ATOM    196  CD  PRO    35      36.011  45.533   2.184  1.00 30.61           C  
ATOM    197  N   ASN    36      40.400  47.104   3.213  1.00 29.90           N  
ATOM    198  CA  ASN    36      41.563  46.878   4.091  1.00 29.42           C  
ATOM    199  C   ASN    36      41.737  48.025   5.047  1.00 30.11           C  
ATOM    200  O   ASN    36      41.796  49.178   4.634  1.00 30.01           O  
ATOM    201  CB  ASN    36      42.860  46.526   3.327  1.00 30.51           C  
ATOM    202  CG  ASN    36      43.407  47.658   2.480  1.00 31.39           C  
ATOM    203  OD1 ASN    36      44.605  48.000   2.594  1.00 37.37           O  
ATOM    204  ND2 ASN    36      42.586  48.212   1.611  1.00 27.08           N  
ATOM    205  N   VAL    37      41.806  47.679   6.330  1.00 29.75           N  
ATOM    206  CA  VAL    37      41.995  48.669   7.390  1.00 29.27           C  
ATOM    207  C   VAL    37      43.424  48.511   7.918  1.00 29.72           C  
ATOM    208  O   VAL    37      43.891  47.384   8.180  1.00 29.41           O  
ATOM    209  CB  VAL    37      40.973  48.414   8.531  1.00 29.79           C  
ATOM    210  CG1 VAL    37      41.220  49.362   9.719  1.00 31.11           C  
ATOM    211  CG2 VAL    37      39.543  48.585   7.972  1.00 30.87           C  
ATOM    212  N   VAL    38      44.108  49.645   8.076  1.00 28.48           N  
ATOM    213  CA  VAL    38      45.482  49.590   8.609  1.00 30.26           C  
ATOM    214  C   VAL    38      45.566  50.597   9.708  1.00 29.13           C  
ATOM    215  O   VAL    38      45.288  51.773   9.496  1.00 29.96           O  
ATOM    216  CB  VAL    38      46.544  49.872   7.539  1.00 30.19           C  
ATOM    217  CG1 VAL    38      47.934  49.653   8.122  1.00 33.01           C  
ATOM    218  CG2 VAL    38      46.340  48.961   6.342  1.00 32.53           C  
ATOM    219  N   VAL    39      45.956  50.115  10.891  1.00 29.22           N  
ATOM    220  CA  VAL    39      46.112  50.992  12.058  1.00 28.47           C  
ATOM    221  C   VAL    39      47.595  51.207  12.274  1.00 29.64           C  
ATOM    222  O   VAL    39      48.358  50.233  12.336  1.00 31.22           O  
ATOM    223  CB  VAL    39      45.454  50.405  13.311  1.00 29.04           C  
ATOM    224  CG1 VAL    39      45.747  51.285  14.557  1.00 29.29           C  
ATOM    225  CG2 VAL    39      43.929  50.261  13.076  1.00 28.84           C  
ATOM    226  N   THR    40      48.002  52.473  12.347  1.00 28.59           N  
ATOM    227  CA  THR    40      49.419  52.838  12.379  1.00 28.56           C  
ATOM    228  C   THR    40      49.711  53.634  13.647  1.00 28.15           C  
ATOM    229  O   THR    40      48.811  54.244  14.208  1.00 28.16           O  
ATOM    230  CB  THR    40      49.779  53.693  11.156  1.00 28.70           C  
ATOM    231  OG1 THR    40      49.099  54.956  11.211  1.00 28.47           O  
ATOM    232  CG2 THR    40      49.400  52.955   9.831  1.00 29.08           C  
ATOM    233  N   PRO    41      50.963  53.597  14.134  1.00 27.77           N  
ATOM    234  CA  PRO    41      51.258  54.220  15.429  1.00 27.58           C  
ATOM    235  C   PRO    41      51.388  55.715  15.465  1.00 27.91           C  
ATOM    236  O   PRO    41      51.349  56.292  16.554  1.00 28.18           O  
ATOM    237  CB  PRO    41      52.618  53.593  15.822  1.00 27.02           C  
ATOM    238  CG  PRO    41      53.269  53.296  14.432  1.00 27.63           C  
ATOM    239  CD  PRO    41      52.102  52.816  13.615  1.00 27.09           C  
ATOM    240  N   ASN    42      51.625  56.357  14.317  1.00 27.94           N  
ATOM    241  CA  ASN    42      51.838  57.798  14.304  1.00 27.19           C  
ATOM    242  C   ASN    42      51.592  58.326  12.907  1.00 27.47           C  
ATOM    243  O   ASN    42      51.430  57.524  11.951  1.00 27.15           O  
ATOM    244  CB  ASN    42      53.237  58.198  14.813  1.00 27.28           C  
ATOM    245  CG  ASN    42      54.325  57.371  14.159  1.00 27.56           C  
ATOM    246  OD1 ASN    42      54.410  57.339  12.924  1.00 27.47           O  
ATOM    247  ND2 ASN    42      55.122  56.670  14.959  1.00 31.36           N  
ATOM    248  N   PHE    43      51.604  59.662  12.805  1.00 27.24           N  
ATOM    249  CA  PHE    43      51.237  60.333  11.550  1.00 27.35           C  
ATOM    250  C   PHE    43      52.131  59.883  10.377  1.00 27.11           C  
ATOM    251  O   PHE    43      51.598  59.514   9.325  1.00 26.47           O  
ATOM    252  CB  PHE    43      51.329  61.823  11.755  1.00 27.79           C  
ATOM    253  CG  PHE    43      51.070  62.629  10.520  1.00 28.03           C  
ATOM    254  CD1 PHE    43      49.788  62.991  10.183  1.00 30.77           C  
ATOM    255  CD2 PHE    43      52.146  63.030   9.712  1.00 29.40           C  
ATOM    256  CE1 PHE    43      49.553  63.766   9.031  1.00 29.55           C  
ATOM    257  CE2 PHE    43      51.937  63.802   8.571  1.00 32.39           C  
ATOM    258  CZ  PHE    43      50.643  64.141   8.210  1.00 30.77           C  
ATOM    259  N   GLU    44      53.444  59.860  10.601  1.00 27.44           N  
ATOM    260  CA  GLU    44      54.406  59.481   9.552  1.00 27.51           C  
ATOM    261  C   GLU    44      54.211  58.023   9.129  1.00 27.15           C  
ATOM    262  O   GLU    44      54.283  57.702   7.932  1.00 27.38           O  
ATOM    263  CB  GLU    44      55.846  59.775   9.986  1.00 29.65           C  
ATOM    264  CG  GLU    44      56.126  61.280  10.151  1.00 31.96           C  
ATOM    265  CD  GLU    44      55.997  62.122   8.860  1.00 39.55           C  
ATOM    266  OE1 GLU    44      56.223  61.616   7.732  1.00 40.81           O  
ATOM    267  OE2 GLU    44      55.671  63.330   8.981  1.00 41.40           O  
ATOM    268  N   ALA    45      53.900  57.132  10.088  1.00 26.38           N  
ATOM    269  CA  ALA    45      53.584  55.758   9.700  1.00 26.12           C  
ATOM    270  C   ALA    45      52.275  55.654   8.897  1.00 26.37           C  
ATOM    271  O   ALA    45      52.114  54.805   7.986  1.00 26.62           O  
ATOM    272  CB  ALA    45      53.528  54.876  10.911  1.00 25.52           C  
ATOM    273  N   GLY    46      51.304  56.498   9.260  1.00 26.42           N  
ATOM    274  CA  GLY    46      50.068  56.564   8.458  1.00 27.98           C  
ATOM    275  C   GLY    46      50.360  56.980   7.036  1.00 27.21           C  
ATOM    276  O   GLY    46      49.843  56.385   6.095  1.00 26.51           O  
ATOM    277  N   VAL    47      51.206  58.007   6.880  1.00 26.62           N  
ATOM    278  CA  VAL    47      51.563  58.489   5.545  1.00 26.36           C  
ATOM    279  C   VAL    47      52.308  57.365   4.776  1.00 26.49           C  
ATOM    280  O   VAL    47      52.054  57.164   3.591  1.00 27.42           O  
ATOM    281  CB  VAL    47      52.411  59.753   5.665  1.00 27.05           C  
ATOM    282  CG1 VAL    47      52.938  60.174   4.302  1.00 27.03           C  
ATOM    283  CG2 VAL    47      51.564  60.903   6.291  1.00 27.75           C  
ATOM    284  N   ASP    48      53.199  56.621   5.451  1.00 25.79           N  
ATOM    285  CA  ASP    48      53.847  55.462   4.809  1.00 25.78           C  
ATOM    286  C   ASP    48      52.771  54.541   4.187  1.00 26.24           C  
ATOM    287  O   ASP    48      52.913  54.026   3.058  1.00 27.65           O  
ATOM    288  CB  ASP    48      54.583  54.608   5.844  1.00 24.53           C  
ATOM    289  CG  ASP    48      55.889  55.244   6.363  1.00 24.70           C  
ATOM    290  OD1 ASP    48      56.320  56.316   5.863  1.00 26.68           O  
ATOM    291  OD2 ASP    48      56.571  54.582   7.199  1.00 26.76           O  
ATOM    292  N   GLN    49      51.712  54.283   4.958  1.00 26.49           N  
ATOM    293  CA  GLN    49      50.703  53.354   4.448  0.50 27.37           C  
ATOM    295  C   GLN    49      49.949  53.929   3.269  1.00 27.51           C  
ATOM    296  O   GLN    49      49.578  53.183   2.342  1.00 28.34           O  
ATOM    297  CB  GLN    49      49.736  52.872   5.539  0.50 26.94           C  
ATOM    299  CG  GLN    49      48.676  51.900   5.013  0.50 28.63           C  
ATOM    301  CD  GLN    49      49.218  50.647   4.316  0.50 26.90           C  
ATOM    303  OE1 GLN    49      50.290  50.122   4.648  0.50 31.26           O  
ATOM    305  NE2 GLN    49      48.452  50.151   3.342  0.50 28.35           N  
ATOM    307  N   VAL    50      49.695  55.234   3.287  1.00 26.98           N  
ATOM    308  CA  VAL    50      49.056  55.889   2.134  1.00 26.02           C  
ATOM    309  C   VAL    50      49.947  55.745   0.877  1.00 26.05           C  
ATOM    310  O   VAL    50      49.470  55.418  -0.217  1.00 26.38           O  
ATOM    311  CB  VAL    50      48.766  57.361   2.411  1.00 26.97           C  
ATOM    312  CG1 VAL    50      48.238  58.027   1.185  1.00 26.87           C  
ATOM    313  CG2 VAL    50      47.740  57.482   3.572  1.00 28.51           C  
ATOM    314  N   VAL    51      51.237  56.006   1.036  1.00 25.74           N  
ATOM    315  CA  VAL    51      52.181  55.882  -0.096  1.00 27.33           C  
ATOM    316  C   VAL    51      52.147  54.453  -0.669  1.00 27.45           C  
ATOM    317  O   VAL    51      52.049  54.225  -1.896  1.00 27.57           O  
ATOM    318  CB  VAL    51      53.599  56.268   0.366  1.00 27.07           C  
ATOM    319  CG1 VAL    51      54.658  55.859  -0.656  1.00 28.60           C  
ATOM    320  CG2 VAL    51      53.665  57.787   0.576  1.00 30.06           C  
ATOM    321  N   ASP    52      52.184  53.492   0.246  1.00 27.09           N  
ATOM    322  CA  ASP    52      52.201  52.088  -0.093  1.00 28.13           C  
ATOM    323  C   ASP    52      50.894  51.661  -0.786  1.00 28.54           C  
ATOM    324  O   ASP    52      50.927  50.929  -1.808  1.00 30.23           O  
ATOM    325  CB  ASP    52      52.423  51.248   1.140  1.00 28.96           C  
ATOM    326  CG  ASP    52      53.809  51.393   1.703  1.00 29.27           C  
ATOM    327  OD1 ASP    52      54.644  52.104   1.111  1.00 29.90           O  
ATOM    328  OD2 ASP    52      54.067  50.733   2.739  1.00 30.79           O  
ATOM    329  N   GLN    53      49.763  52.122  -0.249  1.00 27.74           N  
ATOM    330  CA  GLN    53      48.472  51.821  -0.868  1.00 28.46           C  
ATOM    331  C   GLN    53      48.329  52.439  -2.262  1.00 28.73           C  
ATOM    332  O   GLN    53      47.787  51.825  -3.177  1.00 29.18           O  
ATOM    333  CB  GLN    53      47.324  52.269   0.036  1.00 28.55           C  
ATOM    334  CG  GLN    53      45.958  51.733  -0.460  1.00 30.01           C  
ATOM    335  CD  GLN    53      45.847  50.239  -0.294  1.00 30.81           C  
ATOM    336  OE1 GLN    53      45.447  49.518  -1.226  1.00 35.57           O  
ATOM    337  NE2 GLN    53      46.235  49.757   0.859  1.00 29.10           N  
ATOM    338  N   LEU    54      48.840  53.655  -2.427  1.00 28.47           N  
ATOM    339  CA  LEU    54      48.777  54.311  -3.732  1.00 29.64           C  
ATOM    340  C   LEU    54      49.571  53.492  -4.746  1.00 29.85           C  
ATOM    341  O   LEU    54      49.123  53.282  -5.869  1.00 30.60           O  
ATOM    342  CB  LEU    54      49.327  55.720  -3.619  1.00 29.22           C  
ATOM    343  CG  LEU    54      48.395  56.732  -2.916  1.00 29.23           C  
ATOM    344  CD1 LEU    54      49.146  58.014  -2.693  1.00 31.77           C  
ATOM    345  CD2 LEU    54      47.125  56.998  -3.747  1.00 31.60           C  
ATOM    346  N   ALA    55      50.724  52.977  -4.322  1.00 30.15           N  
ATOM    347  CA  ALA    55      51.550  52.142  -5.205  1.00 31.94           C  
ATOM    348  C   ALA    55      50.809  50.848  -5.539  1.00 32.39           C  
ATOM    349  O   ALA    55      50.821  50.424  -6.693  1.00 34.20           O  
ATOM    350  CB  ALA    55      52.898  51.857  -4.573  1.00 32.39           C  
ATOM    351  N   MET    56      50.184  50.218  -4.538  1.00 32.54           N  
ATOM    352  CA  MET    56      49.411  48.996  -4.772  0.50 33.61           C  
ATOM    354  C   MET    56      48.268  49.264  -5.740  1.00 33.55           C  
ATOM    355  O   MET    56      48.110  48.545  -6.724  1.00 34.34           O  
ATOM    356  CB  MET    56      48.847  48.435  -3.481  0.50 34.02           C  
ATOM    358  CG  MET    56      47.933  47.239  -3.680  0.50 37.03           C  
ATOM    360  SD  MET    56      48.898  45.682  -4.358  0.30 42.24          SE  
ATOM    362  CE  MET    56      50.299  45.629  -2.993  0.50 41.17           C  
ATOM    364  N   ASN    57      47.471  50.295  -5.467  1.00 33.02           N  
ATOM    365  CA  ASN    57      46.339  50.645  -6.323  1.00 33.09           C  
ATOM    366  C   ASN    57      46.790  50.953  -7.750  1.00 33.98           C  
ATOM    367  O   ASN    57      46.195  50.450  -8.708  1.00 33.63           O  
ATOM    368  CB  ASN    57      45.551  51.825  -5.727  1.00 32.63           C  
ATOM    369  CG  ASN    57      44.821  51.452  -4.465  1.00 33.26           C  
ATOM    370  OD1 ASN    57      44.902  50.298  -3.988  1.00 30.93           O  
ATOM    371  ND2 ASN    57      44.118  52.432  -3.892  1.00 31.01           N  
ATOM    372  N   ASP    58      47.863  51.738  -7.883  1.00 34.28           N  
ATOM    373  CA  ASP    58      48.454  52.041  -9.203  1.00 35.30           C  
ATOM    374  C   ASP    58      48.793  50.769  -9.964  1.00 34.62           C  
ATOM    375  O   ASP    58      48.591  50.687 -11.167  1.00 35.23           O  
ATOM    376  CB  ASP    58      49.748  52.827  -9.018  1.00 35.27           C  
ATOM    377  CG  ASP    58      49.523  54.274  -8.664  1.00 37.33           C  
ATOM    378  OD1 ASP    58      48.366  54.725  -8.612  1.00 39.12           O  
ATOM    379  OD2 ASP    58      50.537  54.974  -8.431  1.00 39.24           O  
ATOM    380  N   SER    59      49.325  49.786  -9.254  1.00 35.56           N  
ATOM    381  CA  SER    59      49.777  48.535  -9.865  1.00 36.38           C  
ATOM    382  C   SER    59      48.609  47.694 -10.405  1.00 37.32           C  
ATOM    383  O   SER    59      48.782  46.841 -11.316  1.00 37.69           O  
ATOM    384  CB  SER    59      50.634  47.750  -8.873  1.00 35.69           C  
ATOM    385  OG  SER    59      49.847  46.914  -8.054  1.00 38.55           O  
ATOM    386  N   GLU    60      47.418  47.954  -9.866  1.00 38.51           N  
ATOM    387  CA  GLU    60      46.200  47.263 -10.277  1.00 39.77           C  
ATOM    388  C   GLU    60      45.401  48.137 -11.230  1.00 39.46           C  
ATOM    389  O   GLU    60      44.288  47.783 -11.629  1.00 39.61           O  
ATOM    390  CB  GLU    60      45.384  46.856  -9.056  1.00 40.93           C  
ATOM    391  CG  GLU    60      46.224  46.004  -8.113  1.00 45.64           C  
ATOM    392  CD  GLU    60      45.413  44.950  -7.404  1.00 51.91           C  
ATOM    393  OE1 GLU    60      45.846  43.768  -7.405  1.00 55.04           O  
ATOM    394  OE2 GLU    60      44.343  45.303  -6.855  1.00 54.05           O  
ATOM    395  N   ARG    61      45.993  49.277 -11.582  1.00 38.55           N  
ATOM    396  CA  ARG    61      45.437  50.230 -12.542  1.00 39.08           C  
ATOM    397  C   ARG    61      44.173  50.893 -12.022  1.00 38.15           C  
ATOM    398  O   ARG    61      43.265  51.222 -12.798  1.00 37.67           O  
ATOM    399  CB  ARG    61      45.202  49.575 -13.918  1.00 39.17           C  
ATOM    400  CG  ARG    61      46.422  48.869 -14.503  1.00 41.21           C  
ATOM    401  CD  ARG    61      46.069  48.231 -15.830  1.00 42.58           C  
ATOM    402  NE  ARG    61      45.291  47.004 -15.631  1.00 50.43           N  
ATOM    403  CZ  ARG    61      45.696  45.783 -15.979  1.00 53.04           C  
ATOM    404  NH1 ARG    61      46.871  45.603 -16.577  1.00 54.54           N  
ATOM    405  NH2 ARG    61      44.911  44.737 -15.749  1.00 55.26           N  
ATOM    406  N   ASP    62      44.128  51.105 -10.703  1.00 36.66           N  
ATOM    407  CA  ASP    62      43.036  51.843 -10.068  1.00 37.27           C  
ATOM    408  C   ASP    62      43.297  53.326 -10.190  1.00 37.10           C  
ATOM    409  O   ASP    62      44.456  53.752 -10.343  1.00 37.72           O  
ATOM    410  CB  ASP    62      42.954  51.530  -8.569  1.00 37.09           C  
ATOM    411  CG  ASP    62      42.603  50.092  -8.290  1.00 40.27           C  
ATOM    412  OD1 ASP    62      42.017  49.422  -9.187  1.00 41.38           O  
ATOM    413  OD2 ASP    62      42.938  49.653  -7.164  1.00 41.17           O  
ATOM    414  N   THR    63      42.219  54.102 -10.108  1.00 36.34           N  
ATOM    415  CA  THR    63      42.319  55.537  -9.903  1.00 36.30           C  
ATOM    416  C   THR    63      41.829  55.802  -8.483  1.00 34.94           C  
ATOM    417  O   THR    63      40.671  55.509  -8.167  1.00 33.31           O  
ATOM    418  CB  THR    63      41.420  56.287 -10.857  1.00 37.09           C  
ATOM    419  OG1 THR    63      41.810  55.987 -12.211  1.00 39.88           O  
ATOM    420  CG2 THR    63      41.540  57.794 -10.609  1.00 37.84           C  
ATOM    421  N   THR    64      42.727  56.335  -7.660  1.00 34.99           N  
ATOM    422  CA  THR    64      42.480  56.544  -6.241  1.00 34.95           C  
ATOM    423  C   THR    64      42.203  58.002  -5.830  1.00 35.03           C  
ATOM    424  O   THR    64      42.932  58.918  -6.276  1.00 37.22           O  
ATOM    425  CB  THR    64      43.678  55.999  -5.423  1.00 35.38           C  
ATOM    426  OG1 THR    64      43.989  54.644  -5.852  1.00 35.96           O  
ATOM    427  CG2 THR    64      43.373  56.075  -3.945  1.00 35.82           C  
ATOM    428  N   ALA    65      41.186  58.214  -4.982  1.00 31.08           N  
ATOM    429  CA  ALA    65      41.024  59.479  -4.229  1.00 30.74           C  
ATOM    430  C   ALA    65      41.271  59.248  -2.761  1.00 30.11           C  
ATOM    431  O   ALA    65      40.850  58.226  -2.225  1.00 29.59           O  
ATOM    432  CB  ALA    65      39.662  60.052  -4.411  1.00 31.71           C  
ATOM    433  N   ILE    66      41.970  60.171  -2.111  1.00 28.15           N  
ATOM    434  CA  ILE    66      42.123  60.116  -0.668  1.00 28.59           C  
ATOM    435  C   ILE    66      41.144  61.115  -0.068  1.00 29.00           C  
ATOM    436  O   ILE    66      41.135  62.296  -0.471  1.00 30.18           O  
ATOM    437  CB  ILE    66      43.507  60.566  -0.253  1.00 29.08           C  
ATOM    438  CG1 ILE    66      44.551  59.702  -0.970  1.00 28.82           C  
ATOM    439  CG2 ILE    66      43.599  60.519   1.280  1.00 30.11           C  
ATOM    440  CD1 ILE    66      46.013  60.216  -0.743  1.00 29.84           C  
ATOM    441  N   ILE    67      40.259  60.623   0.799  1.00 26.98           N  
ATOM    442  CA  ILE    67      39.259  61.520   1.442  1.00 28.66           C  
ATOM    443  C   ILE    67      39.623  61.761   2.897  1.00 29.81           C  
ATOM    444  O   ILE    67      39.721  60.793   3.685  1.00 29.66           O  
ATOM    445  CB  ILE    67      37.821  60.945   1.353  1.00 28.87           C  
ATOM    446  CG1 ILE    67      37.522  60.604  -0.109  1.00 29.34           C  
ATOM    447  CG2 ILE    67      36.826  61.958   1.933  1.00 28.41           C  
ATOM    448  CD1 ILE    67      36.114  59.998  -0.401  1.00 30.51           C  
ATOM    449  N   GLY    68      39.871  63.018   3.235  1.00 30.76           N  
ATOM    450  CA  GLY    68      40.165  63.434   4.644  1.00 30.11           C  
ATOM    451  C   GLY    68      38.901  64.111   5.201  1.00 29.17           C  
ATOM    452  O   GLY    68      38.054  64.565   4.457  1.00 29.97           O  
ATOM    453  N   LYS    69      38.781  64.183   6.506  1.00 28.07           N  
ATOM    454  CA  LYS    69      37.545  64.686   7.103  1.00 28.47           C  
ATOM    455  C   LYS    69      37.389  66.168   6.861  1.00 28.85           C  
ATOM    456  O   LYS    69      36.279  66.624   6.531  1.00 28.08           O  
ATOM    457  CB  LYS    69      37.519  64.393   8.599  1.00 28.96           C  
ATOM    458  CG  LYS    69      36.231  64.880   9.264  1.00 28.51           C  
ATOM    459  CD  LYS    69      36.137  64.465  10.765  1.00 30.08           C  
ATOM    460  CE  LYS    69      37.246  65.079  11.588  1.00 27.70           C  
ATOM    461  NZ  LYS    69      37.003  64.832  13.077  1.00 30.16           N  
ATOM    462  N   SER    70      38.465  66.915   7.138  1.00 28.47           N  
ATOM    463  CA  SER    70      38.389  68.356   7.147  1.00 27.07           C  
ATOM    464  C   SER    70      39.465  68.937   6.265  1.00 27.33           C  
ATOM    465  O   SER    70      40.459  68.255   5.954  1.00 26.51           O  
ATOM    466  CB  SER    70      38.640  68.867   8.588  1.00 28.55           C  
ATOM    467  OG  SER    70      39.998  68.595   8.959  1.00 28.42           O  
ATOM    468  N   LEU    71      39.326  70.226   5.911  1.00 26.80           N  
ATOM    469  CA  LEU    71      40.403  70.858   5.146  1.00 27.00           C  
ATOM    470  C   LEU    71      41.748  70.794   5.885  1.00 27.95           C  
ATOM    471  O   LEU    71      42.767  70.543   5.261  1.00 27.17           O  
ATOM    472  CB  LEU    71      40.066  72.302   4.779  1.00 27.53           C  
ATOM    473  CG  LEU    71      41.166  73.006   4.002  1.00 28.95           C  
ATOM    474  CD1 LEU    71      41.364  72.320   2.629  1.00 32.67           C  
ATOM    475  CD2 LEU    71      40.833  74.470   3.851  1.00 31.11           C  
ATOM    476  N   ALA    72      41.761  71.079   7.186  1.00 27.78           N  
ATOM    477  CA  ALA    72      43.039  71.185   7.928  1.00 29.00           C  
ATOM    478  C   ALA    72      43.765  69.822   7.839  1.00 28.10           C  
ATOM    479  O   ALA    72      44.996  69.741   7.610  1.00 28.44           O  
ATOM    480  CB  ALA    72      42.768  71.530   9.369  1.00 29.70           C  
ATOM    481  N   GLU    73      43.018  68.738   8.018  1.00 27.94           N  
ATOM    482  CA  GLU    73      43.625  67.383   7.974  1.00 28.74           C  
ATOM    483  C   GLU    73      44.118  67.054   6.568  1.00 28.31           C  
ATOM    484  O   GLU    73      45.191  66.495   6.400  1.00 28.75           O  
ATOM    485  CB  GLU    73      42.649  66.350   8.510  1.00 30.42           C  
ATOM    486  CG  GLU    73      42.457  66.644   9.985  1.00 28.49           C  
ATOM    487  CD  GLU    73      41.533  65.666  10.701  1.00 31.05           C  
ATOM    488  OE1 GLU    73      40.946  64.791  10.020  1.00 32.95           O  
ATOM    489  OE2 GLU    73      41.452  65.793  11.975  1.00 29.84           O  
ATOM    490  N   CYS    74      43.335  67.437   5.566  1.00 27.48           N  
ATOM    491  CA  CYS    74      43.777  67.308   4.164  1.00 27.34           C  
ATOM    492  C   CYS    74      45.017  68.094   3.841  1.00 27.85           C  
ATOM    493  O   CYS    74      45.876  67.582   3.112  1.00 28.07           O  
ATOM    494  CB  CYS    74      42.647  67.721   3.202  1.00 27.57           C  
ATOM    495  SG  CYS    74      41.274  66.520   3.187  1.00 29.32           S  
ATOM    496  N   GLU    75      45.128  69.318   4.375  1.00 27.03           N  
ATOM    497  CA  GLU    75      46.336  70.127   4.153  1.00 27.31           C  
ATOM    498  C   GLU    75      47.556  69.432   4.765  1.00 27.58           C  
ATOM    499  O   GLU    75      48.617  69.404   4.149  1.00 28.49           O  
ATOM    500  CB  GLU    75      46.129  71.510   4.782  1.00 27.63           C  
ATOM    501  CG  GLU    75      45.247  72.324   3.904  1.00 28.64           C  
ATOM    502  CD  GLU    75      44.812  73.622   4.531  1.00 34.42           C  
ATOM    503  OE1 GLU    75      44.866  73.732   5.774  1.00 39.41           O  
ATOM    504  OE2 GLU    75      44.409  74.533   3.764  1.00 35.89           O  
ATOM    505  N   ALA    76      47.405  68.908   5.987  1.00 28.61           N  
ATOM    506  CA  ALA    76      48.549  68.267   6.683  1.00 28.88           C  
ATOM    507  C   ALA    76      48.988  67.031   5.878  1.00 28.54           C  
ATOM    508  O   ALA    76      50.180  66.800   5.694  1.00 29.25           O  
ATOM    509  CB  ALA    76      48.155  67.863   8.073  1.00 28.69           C  
ATOM    510  N   LEU    77      48.021  66.259   5.378  1.00 27.87           N  
ATOM    511  CA  LEU    77      48.358  65.036   4.619  1.00 28.14           C  
ATOM    512  C   LEU    77      49.025  65.416   3.318  1.00 28.04           C  
ATOM    513  O   LEU    77      49.987  64.768   2.895  1.00 28.24           O  
ATOM    514  CB  LEU    77      47.109  64.187   4.366  1.00 28.00           C  
ATOM    515  CG  LEU    77      47.404  62.956   3.509  1.00 28.70           C  
ATOM    516  CD1 LEU    77      48.416  62.036   4.219  1.00 29.72           C  
ATOM    517  CD2 LEU    77      46.125  62.206   3.121  1.00 29.70           C  
ATOM    518  N   THR    78      48.475  66.436   2.662  1.00 26.40           N  
ATOM    519  CA  THR    78      48.997  66.892   1.367  1.00 26.92           C  
ATOM    520  C   THR    78      50.460  67.305   1.500  1.00 27.08           C  
ATOM    521  O   THR    78      51.296  66.883   0.683  1.00 27.94           O  
ATOM    522  CB  THR    78      48.106  68.012   0.793  1.00 28.12           C  
ATOM    523  OG1 THR    78      46.818  67.470   0.499  1.00 28.53           O  
ATOM    524  CG2 THR    78      48.765  68.595  -0.487  1.00 29.17           C  
ATOM    525  N   LYS    79      50.765  68.138   2.490  1.00 27.45           N  
ATOM    526  CA  LYS    79      52.153  68.591   2.696  1.00 27.58           C  
ATOM    527  C   LYS    79      53.048  67.355   2.873  1.00 27.42           C  
ATOM    528  O   LYS    79      54.126  67.267   2.288  1.00 27.52           O  
ATOM    529  CB  LYS    79      52.218  69.479   3.934  1.00 28.34           C  
ATOM    530  CG  LYS    79      53.641  69.889   4.271  1.00 30.40           C  
ATOM    531  CD  LYS    79      53.689  70.745   5.532  1.00 35.68           C  
ATOM    532  CE  LYS    79      55.138  70.958   5.966  1.00 38.78           C  
ATOM    533  NZ  LYS    79      55.277  71.779   7.213  1.00 44.07           N  
ATOM    534  N   ALA    80      52.593  66.394   3.684  1.00 27.03           N  
ATOM    535  CA  ALA    80      53.404  65.200   3.964  1.00 27.35           C  
ATOM    536  C   ALA    80      53.593  64.368   2.683  1.00 27.20           C  
ATOM    537  O   ALA    80      54.704  63.923   2.383  1.00 28.05           O  
ATOM    538  CB  ALA    80      52.760  64.368   5.027  1.00 28.54           C  
ATOM    539  N   LEU    81      52.529  64.205   1.890  1.00 26.54           N  
ATOM    540  CA  LEU    81      52.650  63.368   0.709  1.00 26.16           C  
ATOM    541  C   LEU    81      53.572  64.012  -0.328  1.00 25.00           C  
ATOM    542  O   LEU    81      54.352  63.330  -1.016  1.00 25.39           O  
ATOM    543  CB  LEU    81      51.286  63.123   0.098  1.00 27.15           C  
ATOM    544  CG  LEU    81      50.421  62.120   0.875  1.00 27.18           C  
ATOM    545  CD1 LEU    81      49.041  62.169   0.185  1.00 31.18           C  
ATOM    546  CD2 LEU    81      51.010  60.685   0.829  1.00 29.51           C  
ATOM    547  N   LYS    82      53.519  65.337  -0.438  1.00 25.13           N  
ATOM    548  CA  LYS    82      54.449  66.004  -1.385  1.00 25.34           C  
ATOM    549  C   LYS    82      55.895  65.767  -0.958  1.00 25.02           C  
ATOM    550  O   LYS    82      56.770  65.583  -1.790  1.00 24.32           O  
ATOM    551  CB  LYS    82      54.142  67.500  -1.481  1.00 26.60           C  
ATOM    552  CG  LYS    82      52.834  67.754  -2.242  1.00 27.13           C  
ATOM    553  CD  LYS    82      52.646  69.258  -2.456  1.00 30.01           C  
ATOM    554  CE  LYS    82      51.334  69.599  -3.193  1.00 29.78           C  
ATOM    555  NZ  LYS    82      51.127  71.119  -3.299  1.00 31.49           N  
ATOM    556  N   ALA    83      56.130  65.754   0.354  1.00 25.32           N  
ATOM    557  CA  ALA    83      57.458  65.447   0.897  1.00 24.90           C  
ATOM    558  C   ALA    83      57.822  63.961   0.766  1.00 25.68           C  
ATOM    559  O   ALA    83      58.962  63.573   1.075  1.00 27.05           O  
ATOM    560  CB  ALA    83      57.529  65.939   2.387  1.00 26.26           C  
ATOM    561  N   ARG    84      56.902  63.143   0.248  1.00 24.58           N  
ATOM    562  CA  ARG    84      57.244  61.758  -0.120  1.00 25.75           C  
ATOM    563  C   ARG    84      57.421  61.600  -1.611  1.00 26.80           C  
ATOM    564  O   ARG    84      57.561  60.459  -2.112  1.00 26.43           O  
ATOM    565  CB  ARG    84      56.161  60.750   0.333  1.00 26.26           C  
ATOM    566  CG  ARG    84      55.900  60.770   1.825  1.00 27.34           C  
ATOM    567  CD  ARG    84      57.175  60.739   2.708  1.00 27.09           C  
ATOM    568  NE  ARG    84      56.728  60.594   4.115  1.00 29.94           N  
ATOM    569  CZ  ARG    84      56.324  59.443   4.675  1.00 29.04           C  
ATOM    570  NH1 ARG    84      56.337  58.294   3.968  1.00 28.29           N  
ATOM    571  NH2 ARG    84      55.905  59.470   5.961  1.00 28.58           N  
ATOM    572  N   GLY    85      57.453  62.722  -2.338  1.00 26.01           N  
ATOM    573  CA  GLY    85      57.649  62.721  -3.778  1.00 26.32           C  
ATOM    574  C   GLY    85      56.388  62.447  -4.580  1.00 25.64           C  
ATOM    575  O   GLY    85      56.494  62.211  -5.795  1.00 27.54           O  
ATOM    576  N   GLU    86      55.219  62.492  -3.926  1.00 25.38           N  
ATOM    577  CA  GLU    86      53.953  62.218  -4.640  1.00 26.80           C  
ATOM    578  C   GLU    86      53.550  63.469  -5.398  1.00 27.66           C  
ATOM    579  O   GLU    86      53.785  64.602  -4.924  1.00 27.88           O  
ATOM    580  CB  GLU    86      52.830  61.881  -3.664  1.00 28.13           C  
ATOM    581  CG  GLU    86      53.088  60.622  -2.829  1.00 29.16           C  
ATOM    582  CD  GLU    86      52.892  59.285  -3.567  1.00 32.81           C  
ATOM    583  OE1 GLU    86      52.563  59.245  -4.777  1.00 34.54           O  
ATOM    584  OE2 GLU    86      53.046  58.239  -2.887  1.00 35.12           O  
ATOM    585  N   GLN    87      52.854  63.271  -6.521  1.00 27.44           N  
ATOM    586  CA  GLN    87      52.167  64.387  -7.189  1.00 28.90           C  
ATOM    587  C   GLN    87      50.820  64.480  -6.507  1.00 28.15           C  
ATOM    588  O   GLN    87      50.090  63.495  -6.505  1.00 30.27           O  
ATOM    589  CB  GLN    87      51.953  64.071  -8.678  1.00 29.60           C  
ATOM    590  CG  GLN    87      51.520  65.262  -9.512  1.00 32.69           C  
ATOM    591  CD  GLN    87      51.463  64.927 -11.015  1.00 30.87           C  
ATOM    592  OE1 GLN    87      51.238  63.777 -11.407  1.00 37.50           O  
ATOM    593  NE2 GLN    87      51.682  65.931 -11.840  1.00 37.57           N  
ATOM    594  N   VAL    88      50.536  65.607  -5.875  1.00 27.67           N  
ATOM    595  CA  VAL    88      49.300  65.734  -5.051  1.00 28.62           C  
ATOM    596  C   VAL    88      48.496  66.951  -5.469  1.00 29.30           C  
ATOM    597  O   VAL    88      49.050  68.060  -5.716  1.00 30.06           O  
ATOM    598  CB  VAL    88      49.611  65.868  -3.570  1.00 28.48           C  
ATOM    599  CG1 VAL    88      48.283  65.706  -2.735  1.00 28.49           C  
ATOM    600  CG2 VAL    88      50.613  64.807  -3.182  1.00 30.48           C  
ATOM    601  N   THR    89      47.182  66.732  -5.570  1.00 29.17           N  
ATOM    602  CA  THR    89      46.247  67.819  -5.835  1.00 29.50           C  
ATOM    603  C   THR    89      45.237  67.832  -4.692  1.00 29.61           C  
ATOM    604  O   THR    89      44.413  66.916  -4.574  1.00 29.82           O  
ATOM    605  CB  THR    89      45.534  67.606  -7.165  1.00 28.72           C  
ATOM    606  OG1 THR    89      46.500  67.667  -8.216  1.00 30.09           O  
ATOM    607  CG2 THR    89      44.465  68.687  -7.389  1.00 31.74           C  
ATOM    608  N   LEU    90      45.320  68.865  -3.856  1.00 29.77           N  
ATOM    609  CA  LEU    90      44.353  69.036  -2.791  1.00 31.46           C  
ATOM    610  C   LEU    90      43.207  69.794  -3.435  1.00 32.63           C  
ATOM    611  O   LEU    90      43.341  70.994  -3.791  1.00 31.86           O  
ATOM    612  CB  LEU    90      44.982  69.760  -1.603  1.00 31.54           C  
ATOM    613  CG  LEU    90      44.029  70.218  -0.494  1.00 35.17           C  
ATOM    614  CD1 LEU    90      43.212  69.072  -0.104  1.00 34.70           C  
ATOM    615  CD2 LEU    90      44.798  70.762   0.677  1.00 39.40           C  
ATOM    616  N   ILE    91      42.126  69.041  -3.695  1.00 35.09           N  
ATOM    617  CA  ILE    91      41.048  69.522  -4.597  1.00 37.92           C  
ATOM    618  C   ILE    91      40.224  70.575  -3.932  1.00 38.76           C  
ATOM    619  O   ILE    91      40.005  70.545  -2.714  1.00 39.84           O  
ATOM    620  CB  ILE    91      40.136  68.401  -5.252  1.00 36.99           C  
ATOM    621  CG1 ILE    91      39.179  67.756  -4.240  1.00 38.56           C  
ATOM    622  CG2 ILE    91      40.993  67.385  -6.066  1.00 39.13           C  
ATOM    623  CD1 ILE    91      37.908  67.161  -4.869  1.00 39.08           C  
ATOM    624  N   GLN    92      39.814  71.560  -4.759  1.00 39.65           N  
ATOM    625  CA  GLN    92      38.996  72.700  -4.293  1.00 41.73           C  
ATOM    626  C   GLN    92      37.625  72.701  -4.984  1.00 41.64           C  
ATOM    627  O   GLN    92      36.716  73.463  -4.610  1.00 41.15           O  
ATOM    628  CB  GLN    92      39.696  74.036  -4.584  1.00 41.30           C  
ATOM    629  CG  GLN    92      41.173  74.136  -4.142  1.00 43.70           C  
ATOM    630  CD  GLN    92      41.659  75.576  -3.995  1.00 45.01           C  
ATOM    631  OE1 GLN    92      40.874  76.522  -4.102  1.00 50.13           O  
ATOM    632  NE2 GLN    92      42.963  75.746  -3.760  1.00 49.34           N  
ATOM    633  N   THR    93      37.495  71.847  -6.001  1.00 41.02           N  
ATOM    634  CA  THR    93      36.235  71.706  -6.726  1.00 41.21           C  
ATOM    635  C   THR    93      36.198  70.306  -7.348  1.00 41.43           C  
ATOM    636  O   THR    93      37.243  69.717  -7.562  1.00 41.08           O  
ATOM    637  CB  THR    93      36.081  72.872  -7.739  1.00 41.87           C  
ATOM    638  OG1 THR    93      34.698  73.021  -8.067  1.00 42.32           O  
ATOM    639  CG2 THR    93      36.967  72.673  -9.008  1.00 39.94           C  
ATOM    640  N   GLU    94      35.016  69.763  -7.618  1.00 41.55           N  
ATOM    641  CA  GLU    94      34.920  68.351  -8.033  1.00 42.69           C  
ATOM    642  C   GLU    94      35.704  68.047  -9.327  1.00 41.56           C  
ATOM    643  O   GLU    94      36.366  67.009  -9.492  1.00 39.70           O  
ATOM    644  CB  GLU    94      33.436  67.905  -8.097  1.00 42.20           C  
ATOM    645  CG  GLU    94      32.718  68.121  -9.423  1.00 45.46           C  
ATOM    646  CD  GLU    94      31.197  67.883  -9.363  1.00 46.48           C  
ATOM    647  OE1 GLU    94      30.700  67.249  -8.391  1.00 52.48           O  
ATOM    648  OE2 GLU    94      30.503  68.344 -10.305  1.00 52.70           O  
ATOM    649  N   ASN    95      35.687  69.015 -10.226  1.00 41.54           N  
ATOM    650  CA  ASN    95      35.911  68.711 -11.604  1.00 42.22           C  
ATOM    651  C   ASN    95      36.463  67.404 -12.229  1.00 42.37           C  
ATOM    652  O   ASN    95      35.922  67.008 -13.297  1.00 43.92           O  
ATOM    653  CB  ASN    95      36.093  69.932 -12.465  1.00 41.45           C  
ATOM    654  CG  ASN    95      34.878  70.144 -13.245  1.00 42.54           C  
ATOM    655  OD1 ASN    95      34.061  69.213 -13.312  1.00 41.36           O  
ATOM    656  ND2 ASN    95      34.681  71.328 -13.789  1.00 39.43           N  
ATOM    657  N   ARG    97      42.194  70.775 -10.029  1.00 60.54           N  
ATOM    658  CA  ARG    97      42.851  71.801 -10.821  1.00 60.25           C  
ATOM    659  C   ARG    97      43.989  71.242 -11.668  1.00 59.19           C  
ATOM    660  O   ARG    97      43.951  71.332 -12.901  1.00 59.41           O  
ATOM    661  CB  ARG    97      43.353  72.949  -9.937  1.00 60.79           C  
ATOM    662  CG  ARG    97      44.048  74.064 -10.699  1.00 61.49           C  
ATOM    663  CD  ARG    97      44.684  75.092  -9.769  1.00 62.15           C  
ATOM    664  NE  ARG    97      43.939  76.352  -9.562  1.00 65.46           N  
ATOM    665  CZ  ARG    97      42.628  76.568  -9.730  1.00 65.77           C  
ATOM    666  NH1 ARG    97      42.150  77.776  -9.479  1.00 66.41           N  
ATOM    667  NH2 ARG    97      41.787  75.618 -10.130  1.00 65.58           N  
ATOM    668  N   LEU    98      45.010  70.698 -11.006  1.00 57.47           N  
ATOM    669  CA  LEU    98      46.197  70.173 -11.700  1.00 56.22           C  
ATOM    670  C   LEU    98      46.402  68.683 -11.424  1.00 54.72           C  
ATOM    671  O   LEU    98      45.696  68.093 -10.605  1.00 53.68           O  
ATOM    672  CB  LEU    98      47.460  70.947 -11.269  1.00 56.46           C  
ATOM    673  CG  LEU    98      48.105  72.001 -12.186  1.00 57.16           C  
ATOM    674  CD1 LEU    98      47.300  73.291 -12.243  1.00 57.93           C  
ATOM    675  CD2 LEU    98      49.557  72.301 -11.753  1.00 56.98           C  
ATOM    676  N   ALA    99      47.326  68.077 -12.171  1.00 53.45           N  
ATOM    677  CA  ALA    99      48.113  66.924 -11.701  1.00 52.70           C  
ATOM    678  C   ALA    99      47.467  65.547 -11.564  1.00 52.71           C  
ATOM    679  O   ALA    99      47.696  64.880 -10.552  1.00 50.85           O  
ATOM    680  CB  ALA    99      48.788  67.278 -10.388  1.00 51.46           C  
ATOM    681  N   PRO   100      46.670  65.096 -12.563  1.00 52.51           N  
ATOM    682  CA  PRO   100      46.154  63.719 -12.488  1.00 51.81           C  
ATOM    683  C   PRO   100      47.205  62.680 -12.140  1.00 51.49           C  
ATOM    684  O   PRO   100      47.746  61.974 -13.017  1.00 52.58           O  
ATOM    685  CB  PRO   100      45.527  63.524 -13.848  1.00 52.97           C  
ATOM    686  CG  PRO   100      44.959  64.871 -14.080  1.00 52.75           C  
ATOM    687  CD  PRO   100      46.113  65.773 -13.736  1.00 52.76           C  
ATOM    688  N   GLY   101      47.509  62.707 -10.839  1.00 49.07           N  
ATOM    689  CA  GLY   101      48.253  61.751 -10.019  1.00 45.84           C  
ATOM    690  C   GLY   101      47.361  61.558  -8.788  1.00 44.10           C  
ATOM    691  O   GLY   101      46.368  60.854  -8.896  1.00 43.43           O  
ATOM    692  N   VAL   102      47.637  62.238  -7.657  1.00 41.33           N  
ATOM    693  CA  VAL   102      46.896  61.931  -6.401  1.00 39.68           C  
ATOM    694  C   VAL   102      45.888  63.025  -5.997  1.00 37.04           C  
ATOM    695  O   VAL   102      46.289  64.153  -5.726  1.00 37.50           O  
ATOM    696  CB  VAL   102      47.903  61.690  -5.234  1.00 39.87           C  
ATOM    697  CG1 VAL   102      47.215  61.268  -3.961  1.00 41.23           C  
ATOM    698  CG2 VAL   102      48.962  60.654  -5.625  1.00 41.49           C  
ATOM    699  N   ILE   103      44.594  62.702  -5.883  1.00 34.73           N  
ATOM    700  CA  ILE   103      43.642  63.720  -5.403  1.00 33.48           C  
ATOM    701  C   ILE   103      43.409  63.513  -3.911  1.00 31.01           C  
ATOM    702  O   ILE   103      43.212  62.379  -3.464  1.00 29.83           O  
ATOM    703  CB  ILE   103      42.234  63.777  -6.126  1.00 34.62           C  
ATOM    704  CG1 ILE   103      41.514  62.461  -6.037  1.00 39.25           C  
ATOM    705  CG2 ILE   103      42.353  64.299  -7.569  1.00 37.60           C  
ATOM    706  CD1 ILE   103      40.177  62.472  -6.736  1.00 38.21           C  
ATOM    707  N   VAL   104      43.457  64.620  -3.170  1.00 29.13           N  
ATOM    708  CA  VAL   104      43.111  64.648  -1.755  1.00 29.30           C  
ATOM    709  C   VAL   104      41.862  65.531  -1.662  1.00 29.64           C  
ATOM    710  O   VAL   104      41.893  66.709  -2.108  1.00 30.16           O  
ATOM    711  CB  VAL   104      44.287  65.234  -0.887  1.00 28.97           C  
ATOM    712  CG1 VAL   104      43.791  65.334   0.544  1.00 29.81           C  
ATOM    713  CG2 VAL   104      45.486  64.291  -0.935  1.00 29.13           C  
ATOM    714  N   VAL   105      40.803  64.974  -1.082  1.00 29.44           N  
ATOM    715  CA  VAL   105      39.445  65.493  -1.204  1.00 30.72           C  
ATOM    716  C   VAL   105      38.928  65.670   0.234  1.00 29.44           C  
ATOM    717  O   VAL   105      38.777  64.692   0.948  1.00 30.21           O  
ATOM    718  CB  VAL   105      38.475  64.393  -1.942  1.00 30.01           C  
ATOM    719  CG1 VAL   105      37.032  64.887  -2.108  1.00 34.93           C  
ATOM    720  CG2 VAL   105      39.021  63.941  -3.305  1.00 34.25           C  
ATOM    721  N   PRO   106      38.634  66.918   0.658  1.00 29.62           N  
ATOM    722  CA  PRO   106      37.901  66.990   1.963  1.00 29.39           C  
ATOM    723  C   PRO   106      36.504  66.389   1.845  1.00 28.28           C  
ATOM    724  O   PRO   106      35.874  66.512   0.794  1.00 28.44           O  
ATOM    725  CB  PRO   106      37.750  68.487   2.196  1.00 31.07           C  
ATOM    726  CG  PRO   106      38.792  69.112   1.313  1.00 31.66           C  
ATOM    727  CD  PRO   106      38.908  68.253   0.104  1.00 31.36           C  
ATOM    728  N   SER   107      36.011  65.783   2.916  1.00 27.63           N  
ATOM    729  CA  SER   107      34.761  65.024   2.855  1.00 27.11           C  
ATOM    730  C   SER   107      33.649  65.833   2.227  1.00 28.07           C  
ATOM    731  O   SER   107      32.872  65.332   1.400  1.00 29.30           O  
ATOM    732  CB  SER   107      34.317  64.541   4.240  1.00 27.43           C  
ATOM    733  OG  SER   107      34.112  65.639   5.141  1.00 28.30           O  
ATOM    734  N   PHE   108      33.564  67.101   2.619  1.00 26.81           N  
ATOM    735  CA  PHE   108      32.495  67.985   2.116  1.00 28.73           C  
ATOM    736  C   PHE   108      32.567  68.317   0.630  1.00 30.35           C  
ATOM    737  O   PHE   108      31.613  68.939   0.084  1.00 33.22           O  
ATOM    738  CB  PHE   108      32.424  69.285   2.962  1.00 28.90           C  
ATOM    739  CG  PHE   108      33.707  70.042   3.027  1.00 28.97           C  
ATOM    740  CD1 PHE   108      34.543  69.929   4.154  1.00 28.11           C  
ATOM    741  CD2 PHE   108      34.107  70.863   1.974  1.00 30.56           C  
ATOM    742  CE1 PHE   108      35.736  70.639   4.256  1.00 27.36           C  
ATOM    743  CE2 PHE   108      35.304  71.581   2.037  1.00 29.79           C  
ATOM    744  CZ  PHE   108      36.135  71.480   3.210  1.00 30.53           C  
ATOM    745  N   LEU   109      33.675  67.974  -0.018  1.00 31.42           N  
ATOM    746  CA  LEU   109      33.772  68.247  -1.454  1.00 34.23           C  
ATOM    747  C   LEU   109      33.567  67.003  -2.256  1.00 36.48           C  
ATOM    748  O   LEU   109      33.619  67.055  -3.492  1.00 38.12           O  
ATOM    749  CB  LEU   109      35.079  68.896  -1.867  1.00 34.37           C  
ATOM    750  CG  LEU   109      35.282  70.342  -1.450  1.00 35.16           C  
ATOM    751  CD1 LEU   109      36.625  70.853  -1.999  1.00 37.37           C  
ATOM    752  CD2 LEU   109      34.107  71.245  -1.856  1.00 38.27           C  
ATOM    753  N   ALA   110      33.343  65.895  -1.574  1.00 36.83           N  
ATOM    754  CA  ALA   110      33.217  64.636  -2.279  1.00 38.84           C  
ATOM    755  C   ALA   110      31.763  64.445  -2.738  1.00 39.68           C  
ATOM    756  O   ALA   110      31.418  63.426  -3.347  1.00 40.16           O  
ATOM    757  CB  ALA   110      33.719  63.498  -1.417  1.00 37.94           C  
ATOM    758  N   LYS   111      30.914  65.437  -2.434  1.00 40.43           N  
ATOM    759  CA  LYS   111      29.475  65.366  -2.683  1.00 42.30           C  
ATOM    760  C   LYS   111      29.197  65.055  -4.144  1.00 41.25           C  
ATOM    761  O   LYS   111      29.689  65.763  -5.036  1.00 42.39           O  
ATOM    762  CB  LYS   111      28.820  66.708  -2.296  1.00 42.90           C  
ATOM    763  CG  LYS   111      27.312  66.800  -2.525  1.00 44.98           C  
ATOM    764  CD  LYS   111      26.837  68.245  -2.342  1.00 45.69           C  
ATOM    765  CE  LYS   111      25.317  68.345  -2.439  1.00 48.97           C  
ATOM    766  NZ  LYS   111      24.913  69.536  -3.246  1.00 50.80           N  
ATOM    767  N   GLY   112      28.414  64.006  -4.373  1.00 41.02           N  
ATOM    768  CA  GLY   112      28.011  63.602  -5.720  1.00 40.80           C  
ATOM    769  C   GLY   112      29.116  62.919  -6.489  1.00 40.02           C  
ATOM    770  O   GLY   112      29.038  62.832  -7.722  1.00 41.60           O  
ATOM    771  N   LEU   113      30.150  62.447  -5.779  1.00 37.99           N  
ATOM    772  CA  LEU   113      31.315  61.850  -6.455  1.00 35.87           C  
ATOM    773  C   LEU   113      31.435  60.377  -6.124  1.00 35.16           C  
ATOM    774  O   LEU   113      31.081  59.954  -5.043  1.00 35.23           O  
ATOM    775  CB  LEU   113      32.614  62.565  -6.075  1.00 36.38           C  
ATOM    776  CG  LEU   113      32.699  64.072  -6.420  1.00 36.50           C  
ATOM    777  CD1 LEU   113      34.093  64.607  -6.099  1.00 36.69           C  
ATOM    778  CD2 LEU   113      32.300  64.348  -7.855  1.00 39.22           C  
ATOM    779  N   GLU   114      31.926  59.601  -7.082  1.00 33.46           N  
ATOM    780  CA  GLU   114      32.276  58.198  -6.816  1.00 32.67           C  
ATOM    781  C   GLU   114      33.682  58.014  -7.386  1.00 31.11           C  
ATOM    782  O   GLU   114      34.034  58.658  -8.386  1.00 31.86           O  
ATOM    783  CB  GLU   114      31.273  57.224  -7.479  1.00 33.27           C  
ATOM    784  CG  GLU   114      30.999  57.471  -8.966  1.00 37.84           C  
ATOM    785  CD  GLU   114      32.147  57.043  -9.922  1.00 40.29           C  
ATOM    786  OE1 GLU   114      32.273  57.663 -11.000  1.00 41.61           O  
ATOM    787  OE2 GLU   114      32.924  56.118  -9.594  1.00 42.34           O  
ATOM    788  N   PHE   115      34.478  57.160  -6.730  1.00 29.83           N  
ATOM    789  CA  PHE   115      35.830  56.910  -7.149  1.00 29.08           C  
ATOM    790  C   PHE   115      36.056  55.404  -7.250  1.00 29.50           C  
ATOM    791  O   PHE   115      35.464  54.637  -6.495  1.00 31.61           O  
ATOM    792  CB  PHE   115      36.794  57.490  -6.100  1.00 30.72           C  
ATOM    793  CG  PHE   115      36.579  58.963  -5.854  1.00 30.38           C  
ATOM    794  CD1 PHE   115      37.044  59.898  -6.767  1.00 35.11           C  
ATOM    795  CD2 PHE   115      35.933  59.400  -4.692  1.00 34.22           C  
ATOM    796  CE1 PHE   115      36.850  61.267  -6.529  1.00 35.07           C  
ATOM    797  CE2 PHE   115      35.743  60.768  -4.449  1.00 36.21           C  
ATOM    798  CZ  PHE   115      36.208  61.684  -5.363  1.00 35.83           C  
ATOM    799  N   ASP   116      36.914  54.987  -8.185  1.00 29.97           N  
ATOM    800  CA  ASP   116      37.321  53.602  -8.303  1.00 29.86           C  
ATOM    801  C   ASP   116      37.866  53.079  -6.970  1.00 30.02           C  
ATOM    802  O   ASP   116      37.397  52.070  -6.444  1.00 29.83           O  
ATOM    803  CB  ASP   116      38.421  53.579  -9.358  1.00 30.94           C  
ATOM    804  CG  ASP   116      38.841  52.199  -9.746  1.00 34.85           C  
ATOM    805  OD1 ASP   116      38.043  51.249  -9.577  1.00 36.80           O  
ATOM    806  OD2 ASP   116      39.981  52.093 -10.268  1.00 37.88           O  
ATOM    807  N   ALA   117      38.842  53.793  -6.423  1.00 28.84           N  
ATOM    808  CA  ALA   117      39.465  53.419  -5.147  1.00 27.87           C  
ATOM    809  C   ALA   117      39.464  54.646  -4.244  1.00 28.35           C  
ATOM    810  O   ALA   117      39.668  55.790  -4.698  1.00 28.17           O  
ATOM    811  CB  ALA   117      40.882  52.965  -5.389  1.00 28.40           C  
ATOM    812  N   VAL   118      39.234  54.399  -2.962  1.00 28.36           N  
ATOM    813  CA  VAL   118      39.279  55.470  -1.975  1.00 27.52           C  
ATOM    814  C   VAL   118      40.232  55.034  -0.880  1.00 28.77           C  
ATOM    815  O   VAL   118      40.196  53.888  -0.441  1.00 28.95           O  
ATOM    816  CB  VAL   118      37.865  55.722  -1.343  1.00 28.89           C  
ATOM    817  CG1 VAL   118      37.972  56.644  -0.109  1.00 30.19           C  
ATOM    818  CG2 VAL   118      36.929  56.360  -2.413  1.00 29.50           C  
ATOM    819  N   ILE   119      41.036  55.984  -0.429  1.00 27.26           N  
ATOM    820  CA  ILE   119      41.774  55.798   0.844  1.00 27.65           C  
ATOM    821  C   ILE   119      41.199  56.790   1.848  1.00 27.78           C  
ATOM    822  O   ILE   119      41.242  57.993   1.590  1.00 28.53           O  
ATOM    823  CB  ILE   119      43.255  56.055   0.647  1.00 27.34           C  
ATOM    824  CG1 ILE   119      43.853  55.049  -0.344  1.00 29.20           C  
ATOM    825  CG2 ILE   119      44.035  56.035   2.020  1.00 28.61           C  
ATOM    826  CD1 ILE   119      45.302  55.448  -0.840  1.00 28.93           C  
ATOM    827  N   VAL   120      40.591  56.296   2.936  1.00 27.27           N  
ATOM    828  CA  VAL   120      40.062  57.167   3.979  1.00 26.74           C  
ATOM    829  C   VAL   120      41.206  57.548   4.896  1.00 27.37           C  
ATOM    830  O   VAL   120      41.788  56.707   5.579  1.00 28.83           O  
ATOM    831  CB  VAL   120      38.933  56.469   4.794  1.00 27.80           C  
ATOM    832  CG1 VAL   120      38.358  57.423   5.801  1.00 26.73           C  
ATOM    833  CG2 VAL   120      37.855  55.979   3.833  1.00 29.25           C  
ATOM    834  N   TRP   121      41.492  58.852   4.955  1.00 26.99           N  
ATOM    835  CA  TRP   121      42.633  59.292   5.764  1.00 27.72           C  
ATOM    836  C   TRP   121      42.243  59.513   7.227  1.00 28.96           C  
ATOM    837  O   TRP   121      41.392  60.370   7.589  1.00 28.42           O  
ATOM    838  CB  TRP   121      43.285  60.576   5.176  1.00 28.13           C  
ATOM    839  CG  TRP   121      44.288  61.158   6.092  1.00 27.78           C  
ATOM    840  CD1 TRP   121      44.221  62.388   6.727  1.00 30.05           C  
ATOM    841  CD2 TRP   121      45.485  60.528   6.560  1.00 29.07           C  
ATOM    842  NE1 TRP   121      45.343  62.576   7.531  1.00 28.63           N  
ATOM    843  CE2 TRP   121      46.119  61.437   7.460  1.00 27.59           C  
ATOM    844  CE3 TRP   121      46.109  59.300   6.285  1.00 30.22           C  
ATOM    845  CZ2 TRP   121      47.335  61.139   8.072  1.00 28.61           C  
ATOM    846  CZ3 TRP   121      47.323  58.993   6.936  1.00 27.83           C  
ATOM    847  CH2 TRP   121      47.902  59.916   7.812  1.00 27.84           C  
ATOM    848  N   ASN   122      42.901  58.729   8.073  1.00 28.25           N  
ATOM    849  CA  ASN   122      42.835  58.912   9.531  1.00 27.68           C  
ATOM    850  C   ASN   122      41.443  58.666  10.105  1.00 27.35           C  
ATOM    851  O   ASN   122      40.862  59.523  10.797  1.00 28.34           O  
ATOM    852  CB  ASN   122      43.429  60.226  10.012  1.00 27.53           C  
ATOM    853  CG  ASN   122      44.095  60.048  11.380  1.00 28.17           C  
ATOM    854  OD1 ASN   122      44.025  58.948  11.919  1.00 29.64           O  
ATOM    855  ND2 ASN   122      44.679  61.114  11.955  1.00 32.02           N  
ATOM    856  N   ALA   123      40.975  57.460   9.852  1.00 27.61           N  
ATOM    857  CA  ALA   123      39.713  56.954  10.385  1.00 28.03           C  
ATOM    858  C   ALA   123      39.897  56.488  11.835  1.00 28.18           C  
ATOM    859  O   ALA   123      39.619  55.312  12.156  1.00 28.50           O  
ATOM    860  CB  ALA   123      39.239  55.754   9.524  1.00 29.82           C  
ATOM    861  N   ASN   124      40.347  57.404  12.691  1.00 27.59           N  
ATOM    862  CA  ASN   124      40.777  57.011  14.016  1.00 28.53           C  
ATOM    863  C   ASN   124      39.774  57.432  15.090  1.00 29.14           C  
ATOM    864  O   ASN   124      38.653  57.883  14.780  1.00 29.75           O  
ATOM    865  CB  ASN   124      42.181  57.549  14.332  1.00 28.00           C  
ATOM    866  CG  ASN   124      42.206  59.065  14.491  1.00 29.92           C  
ATOM    867  OD1 ASN   124      41.204  59.735  14.250  1.00 29.55           O  
ATOM    868  ND2 ASN   124      43.367  59.612  14.909  1.00 29.97           N  
ATOM    869  N   GLN   125      40.142  57.235  16.346  1.00 28.40           N  
ATOM    870  CA  GLN   125      39.217  57.516  17.446  1.00 29.52           C  
ATOM    871  C   GLN   125      39.000  59.019  17.563  1.00 30.46           C  
ATOM    872  O   GLN   125      37.857  59.471  17.741  1.00 30.50           O  
ATOM    873  CB  GLN   125      39.859  56.949  18.713  1.00 29.92           C  
ATOM    874  CG  GLN   125      39.101  57.118  19.911  1.00 33.94           C  
ATOM    875  CD  GLN   125      39.872  56.474  21.046  1.00 41.32           C  
ATOM    876  OE1 GLN   125      39.942  55.251  21.133  1.00 45.19           O  
ATOM    877  NE2 GLN   125      40.528  57.295  21.857  1.00 46.09           N  
ATOM    878  N   GLU   126      40.077  59.798  17.450  1.00 30.55           N  
ATOM    879  CA  GLU   126      39.926  61.234  17.645  1.00 32.78           C  
ATOM    880  C   GLU   126      39.010  61.838  16.596  1.00 31.60           C  
ATOM    881  O   GLU   126      38.198  62.727  16.908  1.00 32.96           O  
ATOM    882  CB  GLU   126      41.276  61.932  17.606  1.00 33.79           C  
ATOM    883  CG  GLU   126      41.081  63.372  18.049  1.00 39.53           C  
ATOM    884  CD  GLU   126      42.365  64.105  18.215  1.00 46.40           C  
ATOM    885  OE1 GLU   126      43.439  63.467  18.112  1.00 49.13           O  
ATOM    886  OE2 GLU   126      42.278  65.333  18.430  1.00 49.46           O  
ATOM    887  N   ASN   127      39.152  61.364  15.361  1.00 30.09           N  
ATOM    888  CA  ASN   127      38.416  61.950  14.241  1.00 29.75           C  
ATOM    889  C   ASN   127      36.983  61.441  14.119  1.00 30.22           C  
ATOM    890  O   ASN   127      36.102  62.156  13.546  1.00 31.63           O  
ATOM    891  CB  ASN   127      39.160  61.685  12.914  1.00 28.44           C  
ATOM    892  CG  ASN   127      40.308  62.661  12.701  1.00 32.49           C  
ATOM    893  OD1 ASN   127      41.369  62.284  12.170  1.00 40.71           O  
ATOM    894  ND2 ASN   127      40.083  63.909  13.054  1.00 28.89           N  
ATOM    895  N   TYR   128      36.744  60.200  14.569  1.00 30.27           N  
ATOM    896  CA  TYR   128      35.433  59.613  14.398  1.00 30.46           C  
ATOM    897  C   TYR   128      35.044  58.932  15.691  1.00 31.11           C  
ATOM    898  O   TYR   128      35.067  57.710  15.780  1.00 30.85           O  
ATOM    899  CB  TYR   128      35.456  58.626  13.212  1.00 31.39           C  
ATOM    900  CG  TYR   128      35.723  59.308  11.894  1.00 31.77           C  
ATOM    901  CD1 TYR   128      34.675  59.902  11.152  1.00 29.39           C  
ATOM    902  CD2 TYR   128      37.010  59.350  11.355  1.00 30.74           C  
ATOM    903  CE1 TYR   128      34.926  60.539   9.943  1.00 30.63           C  
ATOM    904  CE2 TYR   128      37.281  60.005  10.109  1.00 31.04           C  
ATOM    905  CZ  TYR   128      36.224  60.583   9.411  1.00 30.95           C  
ATOM    906  OH  TYR   128      36.485  61.212   8.193  1.00 32.09           O  
ATOM    907  N   GLN   129      34.645  59.752  16.680  1.00 31.62           N  
ATOM    908  CA  GLN   129      34.394  59.303  18.016  1.00 33.63           C  
ATOM    909  C   GLN   129      32.892  59.261  18.310  1.00 32.29           C  
ATOM    910  O   GLN   129      32.420  58.428  19.077  1.00 32.43           O  
ATOM    911  CB  GLN   129      35.050  60.317  18.988  1.00 35.02           C  
ATOM    912  CG  GLN   129      34.664  60.183  20.428  1.00 41.13           C  
ATOM    913  CD  GLN   129      35.514  59.160  21.128  1.00 48.48           C  
ATOM    914  OE1 GLN   129      36.700  59.400  21.393  1.00 50.81           O  
ATOM    915  NE2 GLN   129      34.927  58.017  21.439  1.00 50.85           N  
ATOM    916  N   ARG   130      32.134  60.147  17.669  1.00 30.50           N  
ATOM    917  CA  ARG   130      30.756  60.371  18.089  1.00 30.88           C  
ATOM    918  C   ARG   130      29.786  59.564  17.269  1.00 29.03           C  
ATOM    919  O   ARG   130      29.978  59.383  16.067  1.00 29.11           O  
ATOM    920  CB  ARG   130      30.387  61.863  17.961  1.00 30.43           C  
ATOM    921  CG  ARG   130      31.286  62.743  18.779  1.00 31.17           C  
ATOM    922  CD  ARG   130      30.727  64.170  18.817  1.00 29.95           C  
ATOM    923  NE  ARG   130      29.436  64.261  19.482  1.00 31.37           N  
ATOM    924  CZ  ARG   130      29.245  64.283  20.793  1.00 32.44           C  
ATOM    925  NH1 ARG   130      30.294  64.210  21.636  1.00 32.97           N  
ATOM    926  NH2 ARG   130      28.009  64.393  21.268  1.00 32.91           N  
ATOM    927  N   GLU   131      28.699  59.121  17.915  1.00 28.84           N  
ATOM    928  CA  GLU   131      27.638  58.442  17.194  1.00 28.48           C  
ATOM    929  C   GLU   131      27.124  59.275  16.037  1.00 28.38           C  
ATOM    930  O   GLU   131      26.767  58.728  14.980  1.00 28.12           O  
ATOM    931  CB  GLU   131      26.480  58.071  18.094  1.00 30.46           C  
ATOM    932  CG  GLU   131      26.880  56.972  19.073  1.00 32.46           C  
ATOM    933  CD  GLU   131      27.129  55.631  18.376  1.00 34.22           C  
ATOM    934  OE1 GLU   131      26.216  55.119  17.704  1.00 34.57           O  
ATOM    935  OE2 GLU   131      28.256  55.128  18.503  1.00 38.12           O  
ATOM    936  N   ASP   132      27.107  60.581  16.235  1.00 27.49           N  
ATOM    937  CA  ASP   132      26.602  61.455  15.179  1.00 27.32           C  
ATOM    938  C   ASP   132      27.496  61.481  13.957  1.00 27.67           C  
ATOM    939  O   ASP   132      27.053  61.992  12.911  1.00 28.64           O  
ATOM    940  CB  ASP   132      26.394  62.885  15.718  1.00 26.75           C  
ATOM    941  CG  ASP   132      25.547  63.722  14.782  1.00 27.24           C  
ATOM    942  OD1 ASP   132      24.363  63.342  14.645  1.00 27.96           O  
ATOM    943  OD2 ASP   132      26.053  64.741  14.236  1.00 27.34           O  
ATOM    944  N   GLU   133      28.744  61.010  14.093  1.00 25.77           N  
ATOM    945  CA  GLU   133      29.705  60.973  12.970  1.00 26.67           C  
ATOM    946  C   GLU   133      29.570  59.694  12.126  1.00 27.44           C  
ATOM    947  O   GLU   133      30.304  59.530  11.167  1.00 28.55           O  
ATOM    948  CB  GLU   133      31.138  61.128  13.493  1.00 27.03           C  
ATOM    949  CG  GLU   133      31.349  62.609  13.856  1.00 28.49           C  
ATOM    950  CD  GLU   133      32.645  62.877  14.578  1.00 32.97           C  
ATOM    951  OE1 GLU   133      33.048  62.051  15.431  1.00 34.48           O  
ATOM    952  OE2 GLU   133      33.241  63.950  14.301  1.00 32.24           O  
ATOM    953  N   ARG   134      28.678  58.773  12.511  1.00 27.97           N  
ATOM    954  CA  ARG   134      28.517  57.545  11.696  1.00 28.23           C  
ATOM    955  C   ARG   134      28.100  57.897  10.266  1.00 27.92           C  
ATOM    956  O   ARG   134      28.589  57.280   9.281  1.00 28.58           O  
ATOM    957  CB  ARG   134      27.462  56.634  12.322  1.00 28.08           C  
ATOM    958  CG  ARG   134      27.997  55.908  13.554  1.00 28.12           C  
ATOM    959  CD  ARG   134      26.973  54.944  14.103  1.00 26.86           C  
ATOM    960  NE  ARG   134      27.535  54.332  15.303  1.00 28.27           N  
ATOM    961  CZ  ARG   134      28.424  53.343  15.306  1.00 30.41           C  
ATOM    962  NH1 ARG   134      28.820  52.785  14.149  1.00 30.05           N  
ATOM    963  NH2 ARG   134      28.921  52.929  16.479  1.00 29.65           N  
ATOM    964  N   GLN   135      27.195  58.869  10.125  1.00 28.59           N  
ATOM    965  CA  GLN   135      26.674  59.203   8.783  1.00 29.02           C  
ATOM    966  C   GLN   135      27.837  59.676   7.900  1.00 29.14           C  
ATOM    967  O   GLN   135      27.975  59.263   6.745  1.00 29.03           O  
ATOM    968  CB  GLN   135      25.609  60.291   8.883  1.00 30.77           C  
ATOM    969  CG  GLN   135      25.079  60.708   7.537  1.00 34.30           C  
ATOM    970  CD  GLN   135      24.412  59.541   6.826  1.00 39.47           C  
ATOM    971  OE1 GLN   135      23.690  58.761   7.442  1.00 41.28           O  
ATOM    972  NE2 GLN   135      24.641  59.431   5.530  1.00 44.92           N  
ATOM    973  N   LEU   136      28.683  60.539   8.461  1.00 28.43           N  
ATOM    974  CA  LEU   136      29.870  61.020   7.728  1.00 29.03           C  
ATOM    975  C   LEU   136      30.804  59.880   7.316  1.00 28.46           C  
ATOM    976  O   LEU   136      31.188  59.785   6.144  1.00 27.61           O  
ATOM    977  CB  LEU   136      30.623  62.039   8.597  1.00 29.21           C  
ATOM    978  CG  LEU   136      31.937  62.514   7.979  1.00 31.83           C  
ATOM    979  CD1 LEU   136      31.681  63.344   6.744  1.00 33.64           C  
ATOM    980  CD2 LEU   136      32.728  63.339   9.014  1.00 33.41           C  
ATOM    981  N   LEU   137      31.181  59.018   8.267  1.00 27.95           N  
ATOM    982  CA  LEU   137      32.112  57.957   7.948  1.00 28.06           C  
ATOM    983  C   LEU   137      31.509  57.013   6.919  1.00 28.06           C  
ATOM    984  O   LEU   137      32.189  56.613   5.974  1.00 27.97           O  
ATOM    985  CB  LEU   137      32.505  57.202   9.226  1.00 27.39           C  
ATOM    986  CG  LEU   137      33.552  56.115   9.045  1.00 28.66           C  
ATOM    987  CD1 LEU   137      34.860  56.692   8.480  1.00 27.53           C  
ATOM    988  CD2 LEU   137      33.782  55.441  10.405  1.00 31.02           C  
ATOM    989  N   TYR   138      30.222  56.706   7.074  1.00 27.25           N  
ATOM    990  CA  TYR   138      29.507  55.890   6.088  1.00 27.48           C  
ATOM    991  C   TYR   138      29.574  56.534   4.690  1.00 28.57           C  
ATOM    992  O   TYR   138      29.905  55.888   3.691  1.00 28.17           O  
ATOM    993  CB  TYR   138      28.052  55.788   6.525  1.00 28.78           C  
ATOM    994  CG  TYR   138      27.168  55.208   5.456  1.00 27.70           C  
ATOM    995  CD1 TYR   138      27.163  53.838   5.228  1.00 30.78           C  
ATOM    996  CD2 TYR   138      26.360  56.023   4.694  1.00 28.90           C  
ATOM    997  CE1 TYR   138      26.308  53.285   4.237  1.00 30.18           C  
ATOM    998  CE2 TYR   138      25.535  55.508   3.713  1.00 30.12           C  
ATOM    999  CZ  TYR   138      25.518  54.145   3.484  1.00 31.03           C  
ATOM   1000  OH  TYR   138      24.675  53.661   2.491  1.00 35.00           O  
ATOM   1001  N   THR   139      29.213  57.804   4.635  1.00 28.14           N  
ATOM   1002  CA  THR   139      29.211  58.525   3.358  1.00 28.97           C  
ATOM   1003  C   THR   139      30.592  58.529   2.694  1.00 28.60           C  
ATOM   1004  O   THR   139      30.707  58.317   1.510  1.00 30.49           O  
ATOM   1005  CB  THR   139      28.693  59.939   3.562  1.00 29.12           C  
ATOM   1006  OG1 THR   139      27.361  59.834   4.066  1.00 30.06           O  
ATOM   1007  CG2 THR   139      28.661  60.695   2.244  1.00 30.44           C  
ATOM   1008  N   ILE   140      31.633  58.794   3.466  1.00 29.03           N  
ATOM   1009  CA  ILE   140      32.988  58.794   2.910  1.00 28.61           C  
ATOM   1010  C   ILE   140      33.340  57.425   2.337  1.00 29.48           C  
ATOM   1011  O   ILE   140      33.814  57.305   1.207  1.00 29.65           O  
ATOM   1012  CB  ILE   140      33.983  59.182   3.982  1.00 29.00           C  
ATOM   1013  CG1 ILE   140      33.763  60.660   4.372  1.00 28.88           C  
ATOM   1014  CG2 ILE   140      35.421  58.937   3.508  1.00 31.15           C  
ATOM   1015  CD1 ILE   140      34.650  61.091   5.580  1.00 31.36           C  
ATOM   1016  N   CYS   141      33.116  56.392   3.129  1.00 29.07           N  
ATOM   1017  CA  CYS   141      33.514  55.058   2.697  1.00 29.13           C  
ATOM   1018  C   CYS   141      32.696  54.631   1.476  1.00 29.19           C  
ATOM   1019  O   CYS   141      33.222  53.925   0.601  1.00 29.54           O  
ATOM   1020  CB  CYS   141      33.313  54.071   3.846  1.00 30.06           C  
ATOM   1021  SG  CYS   141      34.497  54.243   5.167  1.00 30.78           S  
ATOM   1022  N   SER   142      31.439  55.081   1.407  1.00 28.43           N  
ATOM   1023  CA  SER   142      30.517  54.678   0.357  0.50 28.65           C  
ATOM   1025  C   SER   142      30.868  55.309  -1.011  1.00 28.50           C  
ATOM   1026  O   SER   142      30.279  54.947  -2.029  1.00 30.12           O  
ATOM   1027  CB  SER   142      29.061  54.956   0.773  0.50 28.43           C  
ATOM   1029  OG  SER   142      28.696  54.145   1.890  0.50 25.91           O  
ATOM   1031  N   ARG   143      31.826  56.251  -1.018  1.00 29.82           N  
ATOM   1032  CA  ARG   143      32.303  56.863  -2.273  1.00 30.89           C  
ATOM   1033  C   ARG   143      33.132  55.874  -3.082  1.00 29.99           C  
ATOM   1034  O   ARG   143      33.363  56.107  -4.261  1.00 31.24           O  
ATOM   1035  CB  ARG   143      33.153  58.093  -2.011  1.00 31.47           C  
ATOM   1036  CG  ARG   143      32.463  59.143  -1.150  1.00 34.66           C  
ATOM   1037  CD  ARG   143      31.698  60.079  -1.977  1.00 35.87           C  
ATOM   1038  NE  ARG   143      30.948  61.043  -1.174  1.00 40.42           N  
ATOM   1039  CZ  ARG   143      29.799  61.568  -1.580  1.00 41.14           C  
ATOM   1040  NH1 ARG   143      29.297  61.222  -2.769  1.00 41.61           N  
ATOM   1041  NH2 ARG   143      29.144  62.436  -0.800  1.00 42.42           N  
ATOM   1042  N   ALA   144      33.629  54.810  -2.430  1.00 28.33           N  
ATOM   1043  CA  ALA   144      34.470  53.812  -3.132  1.00 27.96           C  
ATOM   1044  C   ALA   144      33.628  52.841  -3.900  1.00 28.12           C  
ATOM   1045  O   ALA   144      32.713  52.194  -3.336  1.00 27.80           O  
ATOM   1046  CB  ALA   144      35.328  52.989  -2.116  1.00 28.28           C  
ATOM   1047  N   MET   145      33.982  52.676  -5.169  1.00 27.99           N  
ATOM   1048  CA  MET   145      33.250  51.751  -6.027  1.00 29.45           C  
ATOM   1049  C   MET   145      33.880  50.368  -5.968  1.00 29.26           C  
ATOM   1050  O   MET   145      33.152  49.361  -5.869  1.00 31.39           O  
ATOM   1051  CB  MET   145      33.155  52.275  -7.467  1.00 29.97           C  
ATOM   1052  CG  MET   145      32.339  53.530  -7.585  1.00 30.96           C  
ATOM   1053  SD  MET   145      30.449  53.319  -7.012  0.60 37.90          SE  
ATOM   1054  CE  MET   145      30.502  54.220  -5.253  1.00 36.23           C  
ATOM   1055  N   HIS   146      35.208  50.297  -6.017  1.00 28.77           N  
ATOM   1056  CA  HIS   146      35.887  49.014  -6.275  1.00 28.01           C  
ATOM   1057  C   HIS   146      36.922  48.631  -5.199  1.00 28.21           C  
ATOM   1058  O   HIS   146      37.033  47.466  -4.840  1.00 29.52           O  
ATOM   1059  CB  HIS   146      36.492  48.999  -7.699  1.00 29.10           C  
ATOM   1060  CG  HIS   146      35.469  49.301  -8.774  1.00 30.83           C  
ATOM   1061  ND1 HIS   146      35.625  50.307  -9.715  1.00 37.42           N  
ATOM   1062  CD2 HIS   146      34.247  48.764  -9.009  1.00 35.68           C  
ATOM   1063  CE1 HIS   146      34.553  50.361 -10.486  1.00 36.32           C  
ATOM   1064  NE2 HIS   146      33.706  49.428 -10.088  1.00 37.00           N  
ATOM   1065  N   GLU   147      37.643  49.617  -4.664  1.00 27.29           N  
ATOM   1066  CA  GLU   147      38.665  49.370  -3.628  1.00 27.59           C  
ATOM   1067  C   GLU   147      38.511  50.406  -2.519  1.00 27.75           C  
ATOM   1068  O   GLU   147      38.353  51.573  -2.787  1.00 27.59           O  
ATOM   1069  CB  GLU   147      40.059  49.495  -4.240  1.00 30.02           C  
ATOM   1070  CG  GLU   147      41.159  48.843  -3.400  1.00 34.07           C  
ATOM   1071  CD  GLU   147      41.190  47.305  -3.560  1.00 40.81           C  
ATOM   1072  OE1 GLU   147      40.620  46.793  -4.557  1.00 46.13           O  
ATOM   1073  OE2 GLU   147      41.813  46.619  -2.715  1.00 47.95           O  
ATOM   1074  N   LEU   148      38.548  49.928  -1.286  1.00 26.42           N  
ATOM   1075  CA  LEU   148      38.403  50.814  -0.126  1.00 25.96           C  
ATOM   1076  C   LEU   148      39.460  50.466   0.908  1.00 27.78           C  
ATOM   1077  O   LEU   148      39.574  49.308   1.332  1.00 28.11           O  
ATOM   1078  CB  LEU   148      37.001  50.664   0.466  1.00 26.47           C  
ATOM   1079  CG  LEU   148      36.747  51.375   1.797  1.00 26.48           C  
ATOM   1080  CD1 LEU   148      36.870  52.907   1.632  1.00 27.80           C  
ATOM   1081  CD2 LEU   148      35.359  50.950   2.424  1.00 27.09           C  
ATOM   1082  N   THR   149      40.199  51.491   1.324  1.00 26.92           N  
ATOM   1083  CA  THR   149      41.289  51.336   2.304  1.00 26.77           C  
ATOM   1084  C   THR   149      41.017  52.372   3.364  1.00 27.55           C  
ATOM   1085  O   THR   149      40.668  53.485   3.064  1.00 28.02           O  
ATOM   1086  CB  THR   149      42.678  51.660   1.680  1.00 27.25           C  
ATOM   1087  OG1 THR   149      42.946  50.751   0.618  1.00 28.29           O  
ATOM   1088  CG2 THR   149      43.786  51.511   2.753  1.00 30.04           C  
ATOM   1089  N   LEU   150      41.175  51.978   4.627  1.00 27.28           N  
ATOM   1090  CA  LEU   150      41.090  52.935   5.759  1.00 27.57           C  
ATOM   1091  C   LEU   150      42.405  52.905   6.480  1.00 27.94           C  
ATOM   1092  O   LEU   150      42.878  51.841   6.884  1.00 29.36           O  
ATOM   1093  CB  LEU   150      39.954  52.603   6.751  1.00 28.59           C  
ATOM   1094  CG  LEU   150      38.527  52.831   6.268  1.00 29.04           C  
ATOM   1095  CD1 LEU   150      38.100  51.752   5.316  1.00 31.77           C  
ATOM   1096  CD2 LEU   150      37.600  52.774   7.507  1.00 31.38           C  
ATOM   1097  N   VAL   151      42.966  54.092   6.682  1.00 26.84           N  
ATOM   1098  CA  VAL   151      44.207  54.237   7.479  1.00 27.14           C  
ATOM   1099  C   VAL   151      43.886  55.000   8.729  1.00 27.99           C  
ATOM   1100  O   VAL   151      43.296  56.061   8.649  1.00 27.88           O  
ATOM   1101  CB  VAL   151      45.342  54.965   6.676  1.00 27.80           C  
ATOM   1102  CG1 VAL   151      46.597  55.160   7.545  1.00 29.25           C  
ATOM   1103  CG2 VAL   151      45.702  54.189   5.404  1.00 28.21           C  
ATOM   1104  N   ALA   152      44.283  54.472   9.896  1.00 27.13           N  
ATOM   1105  CA  ALA   152      43.986  55.167  11.166  1.00 27.57           C  
ATOM   1106  C   ALA   152      45.299  55.376  11.868  1.00 28.83           C  
ATOM   1107  O   ALA   152      46.133  54.478  11.869  1.00 30.16           O  
ATOM   1108  CB  ALA   152      43.064  54.286  12.061  1.00 29.53           C  
ATOM   1109  N   VAL   153      45.467  56.542  12.470  1.00 26.26           N  
ATOM   1110  CA  VAL   153      46.665  56.853  13.269  1.00 27.40           C  
ATOM   1111  C   VAL   153      46.252  56.755  14.738  1.00 28.00           C  
ATOM   1112  O   VAL   153      45.386  57.522  15.231  1.00 28.69           O  
ATOM   1113  CB  VAL   153      47.172  58.256  12.982  1.00 27.93           C  
ATOM   1114  CG1 VAL   153      48.375  58.567  13.902  1.00 29.47           C  
ATOM   1115  CG2 VAL   153      47.607  58.334  11.508  1.00 29.89           C  
ATOM   1116  N   GLY   154      46.849  55.801  15.431  1.00 26.87           N  
ATOM   1117  CA  GLY   154      46.602  55.596  16.854  1.00 28.31           C  
ATOM   1118  C   GLY   154      45.728  54.385  17.042  1.00 29.41           C  
ATOM   1119  O   GLY   154      46.203  53.252  17.092  1.00 29.07           O  
ATOM   1120  N   SER   155      44.417  54.626  17.110  1.00 29.57           N  
ATOM   1121  CA  SER   155      43.431  53.556  17.260  1.00 29.03           C  
ATOM   1122  C   SER   155      42.369  53.688  16.202  1.00 29.44           C  
ATOM   1123  O   SER   155      42.079  54.792  15.762  1.00 29.49           O  
ATOM   1124  CB  SER   155      42.712  53.640  18.608  1.00 29.42           C  
ATOM   1125  OG  SER   155      43.621  53.314  19.675  1.00 31.86           O  
ATOM   1126  N   LEU   156      41.808  52.553  15.807  1.00 28.60           N  
ATOM   1127  CA  LEU   156      40.697  52.587  14.855  1.00 29.01           C  
ATOM   1128  C   LEU   156      39.481  53.279  15.475  1.00 29.11           C  
ATOM   1129  O   LEU   156      39.189  53.136  16.663  1.00 30.21           O  
ATOM   1130  CB  LEU   156      40.351  51.157  14.420  1.00 28.63           C  
ATOM   1131  CG  LEU   156      39.383  51.028  13.243  1.00 29.53           C  
ATOM   1132  CD1 LEU   156      39.922  51.650  11.944  1.00 29.39           C  
ATOM   1133  CD2 LEU   156      39.045  49.536  13.054  1.00 30.45           C  
ATOM   1134  N   SER   157      38.729  54.005  14.628  1.00 29.06           N  
ATOM   1135  CA  SER   157      37.492  54.627  15.102  1.00 29.30           C  
ATOM   1136  C   SER   157      36.636  53.596  15.868  1.00 27.87           C  
ATOM   1137  O   SER   157      36.374  52.496  15.346  1.00 29.69           O  
ATOM   1138  CB  SER   157      36.681  55.117  13.898  1.00 28.77           C  
ATOM   1139  OG  SER   157      35.371  55.440  14.387  1.00 30.08           O  
ATOM   1140  N   PRO   158      36.106  53.979  17.029  1.00 29.52           N  
ATOM   1141  CA  PRO   158      35.204  53.071  17.760  1.00 29.78           C  
ATOM   1142  C   PRO   158      33.903  52.832  16.994  1.00 30.01           C  
ATOM   1143  O   PRO   158      33.196  51.851  17.266  1.00 30.42           O  
ATOM   1144  CB  PRO   158      34.911  53.834  19.051  1.00 31.64           C  
ATOM   1145  CG  PRO   158      35.116  55.310  18.694  1.00 31.24           C  
ATOM   1146  CD  PRO   158      36.340  55.227  17.791  1.00 28.97           C  
ATOM   1147  N   LEU   159      33.601  53.720  16.059  1.00 28.10           N  
ATOM   1148  CA  LEU   159      32.371  53.544  15.271  1.00 27.17           C  
ATOM   1149  C   LEU   159      32.467  52.257  14.427  1.00 28.07           C  
ATOM   1150  O   LEU   159      31.454  51.770  13.937  1.00 28.47           O  
ATOM   1151  CB  LEU   159      32.097  54.774  14.393  1.00 28.70           C  
ATOM   1152  CG  LEU   159      32.062  56.094  15.186  1.00 27.54           C  
ATOM   1153  CD1 LEU   159      31.769  57.229  14.191  1.00 28.76           C  
ATOM   1154  CD2 LEU   159      30.994  56.019  16.322  1.00 29.15           C  
ATOM   1155  N   LEU   160      33.710  51.807  14.193  1.00 27.99           N  
ATOM   1156  CA  LEU   160      33.923  50.611  13.371  1.00 28.46           C  
ATOM   1157  C   LEU   160      33.909  49.335  14.187  1.00 29.01           C  
ATOM   1158  O   LEU   160      33.928  48.234  13.611  1.00 29.27           O  
ATOM   1159  CB  LEU   160      35.192  50.731  12.512  1.00 27.82           C  
ATOM   1160  CG  LEU   160      35.145  51.907  11.501  1.00 28.15           C  
ATOM   1161  CD1 LEU   160      36.517  52.039  10.825  1.00 29.93           C  
ATOM   1162  CD2 LEU   160      34.047  51.686  10.464  1.00 28.61           C  
ATOM   1163  N   ALA   161      33.805  49.460  15.521  1.00 28.42           N  
ATOM   1164  CA  ALA   161      33.876  48.262  16.388  1.00 28.64           C  
ATOM   1165  C   ALA   161      32.721  47.299  16.065  1.00 28.77           C  
ATOM   1166  O   ALA   161      32.878  46.090  16.140  1.00 30.01           O  
ATOM   1167  CB  ALA   161      33.857  48.657  17.870  1.00 30.35           C  
ATOM   1168  N   ARG   162      31.571  47.847  15.723  1.00 28.40           N  
ATOM   1169  CA  ARG   162      30.374  47.030  15.488  1.00 29.87           C  
ATOM   1170  C   ARG   162      30.458  46.241  14.202  1.00 29.92           C  
ATOM   1171  O   ARG   162      29.705  45.290  14.024  1.00 32.54           O  
ATOM   1172  CB  ARG   162      29.098  47.875  15.483  1.00 28.55           C  
ATOM   1173  CG  ARG   162      28.905  48.838  14.284  1.00 29.50           C  
ATOM   1174  CD  ARG   162      27.596  49.639  14.418  1.00 29.29           C  
ATOM   1175  NE  ARG   162      26.461  48.764  14.799  1.00 36.22           N  
ATOM   1176  CZ  ARG   162      25.832  47.963  13.943  1.00 37.88           C  
ATOM   1177  NH1 ARG   162      26.207  47.906  12.671  1.00 38.48           N  
ATOM   1178  NH2 ARG   162      24.823  47.197  14.346  1.00 39.58           N  
ATOM   1179  N   VAL   163      31.352  46.624  13.301  1.00 28.88           N  
ATOM   1180  CA  VAL   163      31.402  45.931  11.987  1.00 29.09           C  
ATOM   1181  C   VAL   163      31.909  44.507  12.160  1.00 29.90           C  
ATOM   1182  O   VAL   163      32.877  44.268  12.851  1.00 30.57           O  
ATOM   1183  CB  VAL   163      32.291  46.697  10.993  1.00 29.82           C  
ATOM   1184  CG1 VAL   163      32.328  45.983   9.654  1.00 29.99           C  
ATOM   1185  CG2 VAL   163      31.752  48.121  10.796  1.00 30.12           C  
ATOM   1186  N   ASN   164      31.252  43.565  11.490  1.00 28.00           N  
ATOM   1187  CA  ASN   164      31.656  42.178  11.503  1.00 29.01           C  
ATOM   1188  C   ASN   164      33.102  42.068  11.007  1.00 28.96           C  
ATOM   1189  O   ASN   164      33.424  42.518   9.886  1.00 28.98           O  
ATOM   1190  CB  ASN   164      30.655  41.438  10.601  1.00 27.50           C  
ATOM   1191  CG  ASN   164      30.844  39.939  10.570  1.00 28.60           C  
ATOM   1192  OD1 ASN   164      31.936  39.413  10.839  1.00 30.57           O  
ATOM   1193  ND2 ASN   164      29.786  39.236  10.177  1.00 28.16           N  
ATOM   1194  N   HIS   165      33.966  41.437  11.811  1.00 29.81           N  
ATOM   1195  CA  HIS   165      35.387  41.352  11.417  1.00 30.12           C  
ATOM   1196  C   HIS   165      35.620  40.598  10.113  1.00 29.79           C  
ATOM   1197  O   HIS   165      36.648  40.809   9.455  1.00 30.40           O  
ATOM   1198  CB  HIS   165      36.241  40.723  12.504  1.00 31.36           C  
ATOM   1199  CG  HIS   165      36.426  41.604  13.702  1.00 35.08           C  
ATOM   1200  ND1 HIS   165      37.389  41.361  14.662  1.00 40.78           N  
ATOM   1201  CD2 HIS   165      35.777  42.727  14.094  1.00 37.29           C  
ATOM   1202  CE1 HIS   165      37.316  42.298  15.598  1.00 42.17           C  
ATOM   1203  NE2 HIS   165      36.339  43.132  15.282  1.00 38.86           N  
ATOM   1204  N   ALA   166      34.670  39.761   9.713  1.00 29.21           N  
ATOM   1205  CA  ALA   166      34.785  39.039   8.440  1.00 27.78           C  
ATOM   1206  C   ALA   166      34.761  39.972   7.202  1.00 28.12           C  
ATOM   1207  O   ALA   166      35.191  39.590   6.101  1.00 27.64           O  
ATOM   1208  CB  ALA   166      33.657  38.013   8.319  1.00 28.16           C  
ATOM   1209  N   LEU   167      34.181  41.154   7.385  1.00 27.76           N  
ATOM   1210  CA  LEU   167      33.909  42.072   6.243  1.00 28.29           C  
ATOM   1211  C   LEU   167      35.089  42.928   5.838  1.00 28.89           C  
ATOM   1212  O   LEU   167      34.996  43.721   4.893  1.00 29.42           O  
ATOM   1213  CB  LEU   167      32.699  42.972   6.559  1.00 28.23           C  
ATOM   1214  CG  LEU   167      31.377  42.198   6.723  1.00 29.16           C  
ATOM   1215  CD1 LEU   167      30.264  43.157   7.141  1.00 30.86           C  
ATOM   1216  CD2 LEU   167      30.974  41.514   5.433  1.00 31.02           C  
ATOM   1217  N   TYR   168      36.181  42.851   6.584  1.00 29.08           N  
ATOM   1218  CA  TYR   168      37.362  43.610   6.203  1.00 29.16           C  
ATOM   1219  C   TYR   168      38.611  42.933   6.682  1.00 30.65           C  
ATOM   1220  O   TYR   168      38.532  42.041   7.556  1.00 31.20           O  
ATOM   1221  CB  TYR   168      37.283  45.045   6.777  1.00 29.77           C  
ATOM   1222  CG  TYR   168      37.267  45.129   8.286  1.00 30.36           C  
ATOM   1223  CD1 TYR   168      38.448  45.434   8.984  1.00 31.45           C  
ATOM   1224  CD2 TYR   168      36.073  44.983   9.019  1.00 29.24           C  
ATOM   1225  CE1 TYR   168      38.446  45.562  10.390  1.00 33.32           C  
ATOM   1226  CE2 TYR   168      36.067  45.097  10.426  1.00 31.57           C  
ATOM   1227  CZ  TYR   168      37.261  45.403  11.091  1.00 31.30           C  
ATOM   1228  OH  TYR   168      37.331  45.560  12.468  1.00 33.59           O  
ATOM   1229  N   THR   169      39.767  43.351   6.137  1.00 30.96           N  
ATOM   1230  CA  THR   169      41.046  42.882   6.671  1.00 32.22           C  
ATOM   1231  C   THR   169      41.658  43.951   7.574  1.00 33.24           C  
ATOM   1232  O   THR   169      41.421  45.152   7.383  1.00 32.67           O  
ATOM   1233  CB  THR   169      42.040  42.489   5.574  1.00 33.05           C  
ATOM   1234  OG1 THR   169      42.441  43.657   4.848  1.00 34.24           O  
ATOM   1235  CG2 THR   169      41.399  41.430   4.630  1.00 33.19           C  
ATOM   1236  N   LEU   170      42.417  43.493   8.572  1.00 34.33           N  
ATOM   1237  CA  LEU   170      43.034  44.390   9.538  1.00 35.86           C  
ATOM   1238  C   LEU   170      44.534  44.142   9.567  1.00 37.59           C  
ATOM   1239  O   LEU   170      44.989  43.014   9.849  1.00 37.52           O  
ATOM   1240  CB  LEU   170      42.428  44.186  10.932  1.00 35.38           C  
ATOM   1241  CG  LEU   170      42.996  45.080  12.035  1.00 37.37           C  
ATOM   1242  CD1 LEU   170      42.654  46.542  11.761  1.00 36.76           C  
ATOM   1243  CD2 LEU   170      42.461  44.622  13.416  1.00 37.52           C  
ATOM   1244  N   ASN   171      45.299  45.201   9.310  1.00 38.99           N  
ATOM   1245  CA  ASN   171      46.771  45.129   9.352  1.00 41.68           C  
ATOM   1246  C   ASN   171      47.330  43.921   8.606  1.00 44.00           C  
ATOM   1247  O   ASN   171      48.196  43.205   9.137  1.00 44.05           O  
ATOM   1248  CB  ASN   171      47.273  45.147  10.791  1.00 41.73           C  
ATOM   1249  CG  ASN   171      46.874  46.388  11.510  1.00 43.18           C  
ATOM   1250  OD1 ASN   171      46.695  47.411  10.892  1.00 39.27           O  
ATOM   1251  ND2 ASN   171      46.738  46.310  12.844  1.00 48.21           N  
ATOM   1252  N   GLU   172      46.830  43.701   7.382  1.00 45.89           N  
ATOM   1253  CA  GLU   172      47.212  42.528   6.598  1.00 48.27           C  
ATOM   1254  C   GLU   172      48.677  42.607   6.140  1.00 49.04           C  
ATOM   1255  O   GLU   172      49.118  43.613   5.574  1.00 50.25           O  
ATOM   1256  CB  GLU   172      46.252  42.340   5.419  1.00 49.19           C  
ATOM   1257  CG  GLU   172      46.557  41.146   4.528  1.00 52.20           C  
ATOM   1258  CD  GLU   172      45.302  40.564   3.907  1.00 56.27           C  
ATOM   1259  OE1 GLU   172      45.081  40.756   2.691  1.00 56.29           O  
ATOM   1260  OE2 GLU   172      44.534  39.908   4.647  1.00 59.80           O  
END
