
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   78 ( 1243),  selected   78 , name 1k1z_A
# Molecule2: number of CA atoms   70 ( 1132),  selected   70 , name T0492.pdb
# PARAMETERS: 1k1z_A.T0492.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R     1_A      F       2           -
LGA    A     2_A      S       3           -
LGA    Q     3_A      L       4           -
LGA    D     4_A      R       5           -
LGA    K     5_A      D       6           -
LGA    K     6_A      A       7           -
LGA    R     7_A      K       8           -
LGA    N     8_A      C       9           -
LGA    E     9_A      -       -           -
LGA    L    10_A      -       -           -
LGA    G    11_A      G      10           #
LGA    L    12_A      Q      11          3.798
LGA    P    13_A      T      12          2.136
LGA    K    14_A      V      13          1.558
LGA    M    15_A      K      14          3.079
LGA    E    16_A      V      15          1.150
LGA    V    17_A      V      16          5.316
LGA    F    18_A      K      17          3.105
LGA    Q    19_A      L      18          3.462
LGA    -       -      H      19           -
LGA    -       -      G      20           -
LGA    -       -      T      21           -
LGA    -       -      G      22           -
LGA    -       -      A      23           -
LGA    -       -      L      24           -
LGA    -       -      K      25           -
LGA    -       -      R      26           -
LGA    -       -      R      27           -
LGA    E    20_A      I      28          4.289
LGA    Y    21_A      M      29          2.561
LGA    Y    22_A      D      30          1.257
LGA    G    23_A      M      31          3.307
LGA    I    24_A      -       -           -
LGA    P    25_A      -       -           -
LGA    P    26_A      -       -           -
LGA    P    27_A      -       -           -
LGA    P    28_A      -       -           -
LGA    G    29_A      -       -           -
LGA    A    30_A      -       -           -
LGA    F    31_A      -       -           -
LGA    G    32_A      -       -           -
LGA    G    33_A      -       -           -
LGA    F    34_A      -       -           -
LGA    L    35_A      -       -           -
LGA    R    36_A      G      32          1.231
LGA    L    37_A      I      33          0.880
LGA    N    38_A      T      34          1.025
LGA    P    39_A      R      35          1.557
LGA    G    40_A      G      36          1.677
LGA    D    41_A      C      37          1.298
LGA    I    42_A      E      38          1.376
LGA    V    43_A      I      39          0.423
LGA    E    44_A      Y      40          0.872
LGA    L    45_A      I      41          0.436
LGA    T    46_A      R      42          0.487
LGA    K    47_A      K      43          0.581
LGA    A    48_A      V      44          0.389
LGA    E    49_A      A      45          1.304
LGA    A    50_A      G      48          3.079
LGA    E    51_A      -       -           -
LGA    H    52_A      -       -           -
LGA    N    53_A      D      49          2.910
LGA    W    54_A      P      50          2.125
LGA    W    55_A      I      51          0.879
LGA    E    56_A      Q      52          1.129
LGA    G    57_A      I      53          0.414
LGA    R    58_A      N      54          0.889
LGA    N    59_A      V      55          1.421
LGA    T    60_A      R      56          4.465
LGA    A    61_A      -       -           -
LGA    T    62_A      -       -           -
LGA    N    63_A      G      57          1.259
LGA    E    64_A      Y      58          1.132
LGA    V    65_A      E      59          1.162
LGA    G    66_A      L      60          1.585
LGA    W    67_A      S      61          1.811
LGA    F    68_A      L      62          1.544
LGA    P    69_A      R      63          3.563
LGA    -       -      K      64           -
LGA    -       -      S      65           -
LGA    -       -      A      66           -
LGA    C    70_A      A      67          1.958
LGA    N    71_A      E      68          1.240
LGA    R    72_A      M      69          3.106
LGA    V    73_A      I      70          2.136
LGA    H    74_A      E      71          2.552
LGA    P    75_A      V      72          3.121
LGA    Y    76_A      E      73          1.509
LGA    V    77_A      -       -           -
LGA    H    78_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   78   70    5.0     49    2.24     6.12     56.765     2.094

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.981673 * X  +  -0.092965 * Y  +   0.166358 * Z  +  -0.923026
  Y_new =   0.160403 * X  +  -0.874420 * Y  +   0.457888 * Z  +  -1.887468
  Z_new =   0.102900 * X  +   0.476181 * Y  +   0.873306 * Z  +  -2.161576 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.499198   -2.642394  [ DEG:    28.6020   -151.3980 ]
  Theta =  -0.103082   -3.038511  [ DEG:    -5.9062   -174.0938 ]
  Phi   =   2.979626   -0.161967  [ DEG:   170.7200     -9.2800 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1k1z_A                                        
REMARK     2: T0492.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1k1z_A.T0492.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   78   70   5.0   49   2.24    6.12  56.765
REMARK  ---------------------------------------------------------- 
MOLECULE 1k1z_A
HEADER    SIGNALING PROTEIN                       26-SEP-01   1K1Z              
TITLE     SOLUTION STRUCTURE OF N-TERMINAL SH3 DOMAIN MUTANT(P33G) OF           
TITLE    2 MURINE VAV                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: VAV;                                                       
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: N-TERMINAL SH3 DOMAIN;                                     
COMPND   5 SYNONYM: VAV PROTO-ONCOGENE;                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PHT-1                                     
KEYWDS    SH3, PROTO-ONCOGENE                                                   
EXPDTA    NMR, MINIMIZED AVERAGE STRUCTURE                                      
AUTHOR    K.OGURA,K.NAGATA,M.HORIUCHI,E.EBISUI,T.HASUDA,S.YUZAWA,               
AUTHOR   2 M.NISHIDA,H.HATANAKA,F.INAGAKI                                       
REVDAT   2   24-JUN-03 1K1Z    1       JRNL                                     
REVDAT   1   10-OCT-01 1K1Z    0                                                
JRNL        AUTH   K.OGURA,K.NAGATA,M.HORIUCHI,E.EBISUI,T.HASUDA,               
JRNL        AUTH 2 S.YUZAWA,M.NISHIDA,H.HATANAKA,F.INAGAKI                      
JRNL        TITL   SOLUTION STRUCTURE OF N-TERMINAL SH3 DOMAIN OF VAV           
JRNL        TITL 2 AND THE RECOGNITION SITE FOR GRB2 C-TERMINAL SH3             
JRNL        TITL 3 DOMAIN                                                       
JRNL        REF    J.BIOMOL.NMR                  V.  22    37 2002              
JRNL        REFN   ASTM JBNME9  NE ISSN 0925-2738                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1K1Z A    1    78  UNP    P27870   VAV_MOUSE      583    660             
SEQRES   1 A   78  ARG ALA GLN ASP LYS LYS ARG ASN GLU LEU GLY LEU PRO          
SEQRES   2 A   78  LYS MET GLU VAL PHE GLN GLU TYR TYR GLY ILE PRO PRO          
SEQRES   3 A   78  PRO PRO GLY ALA PHE GLY GLY PHE LEU ARG LEU ASN PRO          
SEQRES   4 A   78  GLY ASP ILE VAL GLU LEU THR LYS ALA GLU ALA GLU HIS          
SEQRES   5 A   78  ASN TRP TRP GLU GLY ARG ASN THR ALA THR ASN GLU VAL          
SEQRES   6 A   78  GLY TRP PHE PRO CYS ASN ARG VAL HIS PRO TYR VAL HIS          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
ATOM      1  N   ARG A   1     -10.566   3.827 -22.348  0.00 18.71           N  
ATOM      2  CA  ARG A   1     -12.033   3.842 -22.584  0.00 18.36           C  
ATOM      3  C   ARG A   1     -12.727   2.717 -21.822  0.00 17.55           C  
ATOM      4  O   ARG A   1     -13.703   2.137 -22.301  0.00 17.58           O  
ATOM      5  CB  ARG A   1     -12.286   3.696 -24.088  0.00 19.06           C  
ATOM      6  CG  ARG A   1     -12.822   4.960 -24.741  0.00 19.68           C  
ATOM      7  CD  ARG A   1     -12.965   4.793 -26.245  0.00 20.41           C  
ATOM      8  NE  ARG A   1     -13.820   5.824 -26.831  0.00 20.87           N  
ATOM      9  CZ  ARG A   1     -13.762   6.191 -28.108  0.00 21.55           C  
ATOM     10  NH1 ARG A   1     -12.900   5.614 -28.934  0.00 21.83           N  
ATOM     11  NH2 ARG A   1     -14.572   7.139 -28.562  0.00 22.04           N  
ATOM     12  H2  ARG A   1     -10.142   2.986 -22.787  0.00 18.91           H  
ATOM     13  HA  ARG A   1     -12.427   4.790 -22.249  0.00 18.34           H  
ATOM     14  HB2 ARG A   1     -11.358   3.432 -24.573  0.00 19.28           H  
ATOM     15  HB3 ARG A   1     -13.002   2.903 -24.246  0.00 19.04           H  
ATOM     16  HG2 ARG A   1     -13.791   5.187 -24.320  0.00 19.68           H  
ATOM     17  HG3 ARG A   1     -12.142   5.773 -24.540  0.00 19.71           H  
ATOM     18  HD2 ARG A   1     -11.985   4.852 -26.695  0.00 20.52           H  
ATOM     19  HD3 ARG A   1     -13.397   3.823 -26.448  0.00 20.60           H  
ATOM     20  HE  ARG A   1     -14.467   6.263 -26.243  0.00 20.75           H  
ATOM     21 HH11 ARG A   1     -12.287   4.898 -28.597  0.00 21.54           H  
ATOM     22 HH12 ARG A   1     -12.860   5.895 -29.892  0.00 22.39           H  
ATOM     23 HH21 ARG A   1     -15.226   7.577 -27.943  0.00 21.91           H  
ATOM     24 HH22 ARG A   1     -14.529   7.418 -29.521  0.00 22.60           H  
ATOM     25  H1  ARG A   1     -10.129   4.677 -22.759  0.00 18.92           H  
ATOM     26  H3  ARG A   1     -10.369   3.809 -21.327  0.00 18.67           H  
ATOM     27  N   ALA A   2     -12.216   2.414 -20.633  0.00 16.96           N  
ATOM     28  CA  ALA A   2     -12.787   1.359 -19.802  0.00 16.27           C  
ATOM     29  C   ALA A   2     -13.386   1.934 -18.523  0.00 15.40           C  
ATOM     30  O   ALA A   2     -13.271   1.342 -17.450  0.00 15.13           O  
ATOM     31  CB  ALA A   2     -11.729   0.317 -19.475  0.00 16.51           C  
ATOM     32  H   ALA A   2     -11.438   2.912 -20.306  0.00 17.07           H  
ATOM     33  HA  ALA A   2     -13.570   0.877 -20.369  0.00 16.37           H  
ATOM     34  HB1 ALA A   2     -11.026   0.726 -18.764  0.00 16.87           H  
ATOM     35  HB2 ALA A   2     -12.202  -0.557 -19.051  0.00 16.29           H  
ATOM     36  HB3 ALA A   2     -11.205   0.038 -20.378  0.00 16.67           H  
ATOM     37  N   GLN A   3     -14.026   3.093 -18.649  0.00 15.13           N  
ATOM     38  CA  GLN A   3     -14.645   3.752 -17.505  0.00 14.45           C  
ATOM     39  C   GLN A   3     -15.851   2.964 -17.008  0.00 13.57           C  
ATOM     40  O   GLN A   3     -16.640   2.450 -17.801  0.00 13.37           O  
ATOM     41  CB  GLN A   3     -15.071   5.174 -17.880  0.00 14.77           C  
ATOM     42  CG  GLN A   3     -15.161   6.114 -16.689  0.00 15.14           C  
ATOM     43  CD  GLN A   3     -15.875   7.410 -17.021  0.00 15.54           C  
ATOM     44  OE1 GLN A   3     -16.789   7.437 -17.846  0.00 15.91           O  
ATOM     45  NE2 GLN A   3     -15.459   8.496 -16.379  0.00 15.64           N  
ATOM     46  H   GLN A   3     -14.083   3.513 -19.531  0.00 15.49           H  
ATOM     47  HA  GLN A   3     -13.911   3.804 -16.715  0.00 14.53           H  
ATOM     48  HB2 GLN A   3     -14.355   5.580 -18.578  0.00 15.17           H  
ATOM     49  HB3 GLN A   3     -16.040   5.133 -18.354  0.00 14.52           H  
ATOM     50  HG2 GLN A   3     -15.700   5.619 -15.895  0.00 15.08           H  
ATOM     51  HG3 GLN A   3     -14.160   6.346 -16.354  0.00 15.34           H  
ATOM     52 HE21 GLN A   3     -14.726   8.401 -15.736  0.00 15.43           H  
ATOM     53 HE22 GLN A   3     -15.902   9.348 -16.573  0.00 16.00           H  
ATOM     54  N   ASP A   4     -15.987   2.874 -15.686  0.00 13.21           N  
ATOM     55  CA  ASP A   4     -17.095   2.150 -15.073  0.00 12.52           C  
ATOM     56  C   ASP A   4     -17.160   0.711 -15.581  0.00 12.67           C  
ATOM     57  O   ASP A   4     -18.238   0.128 -15.691  0.00 12.92           O  
ATOM     58  CB  ASP A   4     -18.420   2.865 -15.351  0.00 12.18           C  
ATOM     59  CG  ASP A   4     -19.350   2.845 -14.155  0.00 12.02           C  
ATOM     60  OD1 ASP A   4     -20.120   1.872 -14.017  0.00 12.03           O  
ATOM     61  OD2 ASP A   4     -19.308   3.804 -13.354  0.00 12.06           O  
ATOM     62  H   ASP A   4     -15.323   3.307 -15.109  0.00 13.53           H  
ATOM     63  HA  ASP A   4     -16.925   2.131 -14.005  0.00 12.35           H  
ATOM     64  HB2 ASP A   4     -18.218   3.893 -15.610  0.00 12.45           H  
ATOM     65  HB3 ASP A   4     -18.916   2.381 -16.178  0.00 11.98           H  
ATOM     66  N   LYS A   5     -15.995   0.147 -15.886  0.00 12.71           N  
ATOM     67  CA  LYS A   5     -15.914  -1.224 -16.381  0.00 13.07           C  
ATOM     68  C   LYS A   5     -14.694  -1.935 -15.807  0.00 12.50           C  
ATOM     69  O   LYS A   5     -14.607  -3.162 -15.834  0.00 12.61           O  
ATOM     70  CB  LYS A   5     -15.855  -1.235 -17.909  0.00 13.84           C  
ATOM     71  CG  LYS A   5     -16.620  -2.386 -18.541  0.00 14.81           C  
ATOM     72  CD  LYS A   5     -15.720  -3.238 -19.420  0.00 15.56           C  
ATOM     73  CE  LYS A   5     -16.500  -3.891 -20.548  0.00 16.28           C  
ATOM     74  NZ  LYS A   5     -16.889  -5.290 -20.217  0.00 17.01           N  
ATOM     75  H   LYS A   5     -15.170   0.663 -15.775  0.00 12.62           H  
ATOM     76  HA  LYS A   5     -16.805  -1.744 -16.060  0.00 13.38           H  
ATOM     77  HB2 LYS A   5     -16.270  -0.309 -18.282  0.00 13.81           H  
ATOM     78  HB3 LYS A   5     -14.822  -1.306 -18.218  0.00 13.88           H  
ATOM     79  HG2 LYS A   5     -17.032  -3.007 -17.757  0.00 15.11           H  
ATOM     80  HG3 LYS A   5     -17.423  -1.985 -19.143  0.00 14.82           H  
ATOM     81  HD2 LYS A   5     -14.950  -2.611 -19.845  0.00 15.57           H  
ATOM     82  HD3 LYS A   5     -15.265  -4.008 -18.813  0.00 15.71           H  
ATOM     83  HE2 LYS A   5     -17.393  -3.313 -20.734  0.00 16.16           H  
ATOM     84  HE3 LYS A   5     -15.885  -3.898 -21.437  0.00 16.51           H  
ATOM     85  HZ1 LYS A   5     -17.285  -5.332 -19.256  0.00 17.15           H  
ATOM     86  HZ2 LYS A   5     -16.058  -5.913 -20.265  0.00 17.35           H  
ATOM     87  HZ3 LYS A   5     -17.604  -5.632 -20.892  0.00 17.18           H  
ATOM     88  N   LYS A   6     -13.753  -1.153 -15.283  0.00 12.10           N  
ATOM     89  CA  LYS A   6     -12.537  -1.703 -14.696  0.00 11.74           C  
ATOM     90  C   LYS A   6     -12.431  -1.324 -13.223  0.00 10.62           C  
ATOM     91  O   LYS A   6     -11.816  -2.038 -12.429  0.00 10.48           O  
ATOM     92  CB  LYS A   6     -11.305  -1.203 -15.454  0.00 12.36           C  
ATOM     93  CG  LYS A   6     -10.396  -2.318 -15.940  0.00 13.02           C  
ATOM     94  CD  LYS A   6     -10.437  -2.449 -17.454  0.00 13.52           C  
ATOM     95  CE  LYS A   6      -9.546  -3.581 -17.942  0.00 14.35           C  
ATOM     96  NZ  LYS A   6      -9.951  -4.895 -17.372  0.00 14.98           N  
ATOM     97  H   LYS A   6     -13.883  -0.181 -15.289  0.00 12.17           H  
ATOM     98  HA  LYS A   6     -12.587  -2.778 -14.775  0.00 12.03           H  
ATOM     99  HB2 LYS A   6     -11.632  -0.634 -16.312  0.00 12.86           H  
ATOM    100  HB3 LYS A   6     -10.733  -0.559 -14.802  0.00 12.01           H  
ATOM    101  HG2 LYS A   6      -9.382  -2.101 -15.637  0.00 12.83           H  
ATOM    102  HG3 LYS A   6     -10.716  -3.250 -15.497  0.00 13.48           H  
ATOM    103  HD2 LYS A   6     -11.453  -2.649 -17.759  0.00 13.62           H  
ATOM    104  HD3 LYS A   6     -10.103  -1.523 -17.895  0.00 13.35           H  
ATOM    105  HE2 LYS A   6      -9.608  -3.631 -19.019  0.00 14.39           H  
ATOM    106  HE3 LYS A   6      -8.528  -3.369 -17.650  0.00 14.60           H  
ATOM    107  HZ1 LYS A   6     -10.259  -4.778 -16.385  0.00 15.16           H  
ATOM    108  HZ2 LYS A   6      -9.151  -5.557 -17.395  0.00 15.33           H  
ATOM    109  HZ3 LYS A   6     -10.736  -5.297 -17.924  0.00 15.04           H  
ATOM    110  N   ARG A   7     -13.035  -0.194 -12.866  0.00 10.01           N  
ATOM    111  CA  ARG A   7     -13.013   0.285 -11.490  0.00  9.04           C  
ATOM    112  C   ARG A   7     -14.124  -0.368 -10.672  0.00  8.35           C  
ATOM    113  O   ARG A   7     -15.305  -0.087 -10.876  0.00  8.47           O  
ATOM    114  CB  ARG A   7     -13.170   1.807 -11.456  0.00  9.22           C  
ATOM    115  CG  ARG A   7     -11.996   2.528 -10.815  0.00  9.63           C  
ATOM    116  CD  ARG A   7     -11.602   3.763 -11.607  0.00 10.08           C  
ATOM    117  NE  ARG A   7     -12.178   4.982 -11.044  0.00 10.48           N  
ATOM    118  CZ  ARG A   7     -12.926   5.835 -11.739  0.00 11.07           C  
ATOM    119  NH1 ARG A   7     -13.184   5.601 -13.020  0.00 11.32           N  
ATOM    120  NH2 ARG A   7     -13.414   6.919 -11.155  0.00 11.61           N  
ATOM    121  H   ARG A   7     -13.508   0.328 -13.547  0.00 10.34           H  
ATOM    122  HA  ARG A   7     -12.060   0.019 -11.059  0.00  8.93           H  
ATOM    123  HB2 ARG A   7     -13.277   2.168 -12.469  0.00  9.62           H  
ATOM    124  HB3 ARG A   7     -14.063   2.053 -10.901  0.00  8.91           H  
ATOM    125  HG2 ARG A   7     -12.273   2.826  -9.815  0.00  9.51           H  
ATOM    126  HG3 ARG A   7     -11.152   1.853 -10.772  0.00  9.98           H  
ATOM    127  HD2 ARG A   7     -10.526   3.851 -11.601  0.00 10.28           H  
ATOM    128  HD3 ARG A   7     -11.948   3.650 -12.623  0.00 10.16           H  
ATOM    129  HE  ARG A   7     -12.000   5.174 -10.100  0.00 10.46           H  
ATOM    130 HH11 ARG A   7     -12.816   4.785 -13.464  0.00 11.07           H  
ATOM    131 HH12 ARG A   7     -13.746   6.245 -13.540  0.00 11.88           H  
ATOM    132 HH21 ARG A   7     -13.221   7.099 -10.191  0.00 11.59           H  
ATOM    133 HH22 ARG A   7     -13.975   7.559 -11.681  0.00 12.16           H  
ATOM    134  N   ASN A   8     -13.737  -1.241  -9.748  0.00  7.89           N  
ATOM    135  CA  ASN A   8     -14.702  -1.935  -8.902  0.00  7.45           C  
ATOM    136  C   ASN A   8     -14.414  -1.682  -7.425  0.00  6.50           C  
ATOM    137  O   ASN A   8     -13.390  -2.117  -6.898  0.00  6.42           O  
ATOM    138  CB  ASN A   8     -14.675  -3.438  -9.188  0.00  8.24           C  
ATOM    139  CG  ASN A   8     -14.717  -3.743 -10.673  0.00  9.08           C  
ATOM    140  OD1 ASN A   8     -13.979  -4.597 -11.164  0.00  9.44           O  
ATOM    141  ND2 ASN A   8     -15.586  -3.045 -11.395  0.00  9.62           N  
ATOM    142  H   ASN A   8     -12.780  -1.425  -9.633  0.00  8.03           H  
ATOM    143  HA  ASN A   8     -15.683  -1.551  -9.135  0.00  7.50           H  
ATOM    144  HB2 ASN A   8     -13.770  -3.861  -8.779  0.00  8.58           H  
ATOM    145  HB3 ASN A   8     -15.529  -3.902  -8.718  0.00  8.11           H  
ATOM    146 HD21 ASN A   8     -16.142  -2.380 -10.937  0.00  9.47           H  
ATOM    147 HD22 ASN A   8     -15.634  -3.223 -12.358  0.00 10.28           H  
ATOM    148  N   GLU A   9     -15.327  -0.976  -6.763  0.00  6.08           N  
ATOM    149  CA  GLU A   9     -15.176  -0.664  -5.346  0.00  5.41           C  
ATOM    150  C   GLU A   9     -16.347  -1.221  -4.540  0.00  4.74           C  
ATOM    151  O   GLU A   9     -17.309  -0.509  -4.251  0.00  5.10           O  
ATOM    152  CB  GLU A   9     -15.071   0.850  -5.141  0.00  5.89           C  
ATOM    153  CG  GLU A   9     -15.903   1.660  -6.123  0.00  6.45           C  
ATOM    154  CD  GLU A   9     -15.072   2.654  -6.911  0.00  7.14           C  
ATOM    155  OE1 GLU A   9     -14.649   3.672  -6.324  0.00  7.28           O  
ATOM    156  OE2 GLU A   9     -14.843   2.412  -8.114  0.00  7.78           O  
ATOM    157  H   GLU A   9     -16.122  -0.659  -7.240  0.00  6.45           H  
ATOM    158  HA  GLU A   9     -14.265  -1.128  -5.002  0.00  5.42           H  
ATOM    159  HB2 GLU A   9     -15.403   1.089  -4.141  0.00  6.18           H  
ATOM    160  HB3 GLU A   9     -14.039   1.146  -5.249  0.00  5.91           H  
ATOM    161  HG2 GLU A   9     -16.379   0.982  -6.817  0.00  6.46           H  
ATOM    162  HG3 GLU A   9     -16.660   2.201  -5.574  0.00  6.71           H  
ATOM    163  N   LEU A  10     -16.254  -2.498  -4.179  0.00  4.10           N  
ATOM    164  CA  LEU A  10     -17.306  -3.151  -3.407  0.00  3.85           C  
ATOM    165  C   LEU A  10     -16.717  -3.946  -2.244  0.00  3.22           C  
ATOM    166  O   LEU A  10     -16.722  -5.179  -2.253  0.00  2.99           O  
ATOM    167  CB  LEU A  10     -18.133  -4.073  -4.308  0.00  4.41           C  
ATOM    168  CG  LEU A  10     -17.319  -4.956  -5.255  0.00  5.05           C  
ATOM    169  CD1 LEU A  10     -17.709  -6.417  -5.089  0.00  5.63           C  
ATOM    170  CD2 LEU A  10     -17.514  -4.511  -6.696  0.00  5.72           C  
ATOM    171  H   LEU A  10     -15.463  -3.013  -4.440  0.00  4.10           H  
ATOM    172  HA  LEU A  10     -17.950  -2.381  -3.009  0.00  4.15           H  
ATOM    173  HB2 LEU A  10     -18.732  -4.713  -3.676  0.00  4.45           H  
ATOM    174  HB3 LEU A  10     -18.795  -3.461  -4.901  0.00  4.79           H  
ATOM    175  HG  LEU A  10     -16.271  -4.862  -5.013  0.00  5.05           H  
ATOM    176 HD11 LEU A  10     -16.829  -7.036  -5.171  0.00  5.87           H  
ATOM    177 HD12 LEU A  10     -18.162  -6.561  -4.119  0.00  5.89           H  
ATOM    178 HD13 LEU A  10     -18.415  -6.691  -5.860  0.00  5.93           H  
ATOM    179 HD21 LEU A  10     -16.752  -4.959  -7.317  0.00  5.90           H  
ATOM    180 HD22 LEU A  10     -18.489  -4.823  -7.039  0.00  5.76           H  
ATOM    181 HD23 LEU A  10     -17.439  -3.435  -6.753  0.00  6.32           H  
ATOM    182  N   GLY A  11     -16.213  -3.231  -1.242  0.00  3.08           N  
ATOM    183  CA  GLY A  11     -15.631  -3.884  -0.083  0.00  2.66           C  
ATOM    184  C   GLY A  11     -14.173  -4.245  -0.289  0.00  2.02           C  
ATOM    185  O   GLY A  11     -13.617  -5.052   0.456  0.00  1.77           O  
ATOM    186  H   GLY A  11     -16.239  -2.253  -1.289  0.00  3.38           H  
ATOM    187  HA2 GLY A  11     -15.710  -3.221   0.766  0.00  2.87           H  
ATOM    188  HA3 GLY A  11     -16.188  -4.786   0.126  0.00  2.74           H  
ATOM    189  N   LEU A  12     -13.553  -3.648  -1.301  0.00  1.95           N  
ATOM    190  CA  LEU A  12     -12.151  -3.913  -1.603  0.00  1.49           C  
ATOM    191  C   LEU A  12     -11.239  -2.950  -0.846  0.00  1.07           C  
ATOM    192  O   LEU A  12     -11.480  -1.742  -0.830  0.00  1.33           O  
ATOM    193  CB  LEU A  12     -11.899  -3.793  -3.109  0.00  1.91           C  
ATOM    194  CG  LEU A  12     -11.991  -5.105  -3.895  0.00  2.47           C  
ATOM    195  CD1 LEU A  12     -10.979  -6.116  -3.374  0.00  3.14           C  
ATOM    196  CD2 LEU A  12     -13.401  -5.673  -3.823  0.00  2.97           C  
ATOM    197  H   LEU A  12     -14.051  -3.015  -1.860  0.00  2.34           H  
ATOM    198  HA  LEU A  12     -11.931  -4.921  -1.289  0.00  1.35           H  
ATOM    199  HB2 LEU A  12     -12.622  -3.102  -3.518  0.00  2.21           H  
ATOM    200  HB3 LEU A  12     -10.911  -3.382  -3.255  0.00  1.97           H  
ATOM    201  HG  LEU A  12     -11.761  -4.912  -4.932  0.00  2.77           H  
ATOM    202 HD11 LEU A  12     -11.301  -7.113  -3.633  0.00  3.56           H  
ATOM    203 HD12 LEU A  12     -10.015  -5.922  -3.819  0.00  3.41           H  
ATOM    204 HD13 LEU A  12     -10.904  -6.030  -2.300  0.00  3.57           H  
ATOM    205 HD21 LEU A  12     -14.109  -4.921  -4.138  0.00  3.32           H  
ATOM    206 HD22 LEU A  12     -13.476  -6.533  -4.473  0.00  3.46           H  
ATOM    207 HD23 LEU A  12     -13.619  -5.969  -2.809  0.00  3.16           H  
ATOM    208  N   PRO A  13     -10.174  -3.468  -0.207  0.00  0.64           N  
ATOM    209  CA  PRO A  13      -9.229  -2.641   0.552  0.00  0.61           C  
ATOM    210  C   PRO A  13      -8.560  -1.587  -0.323  0.00  0.47           C  
ATOM    211  O   PRO A  13      -8.316  -1.814  -1.509  0.00  0.48           O  
ATOM    212  CB  PRO A  13      -8.192  -3.647   1.065  0.00  0.91           C  
ATOM    213  CG  PRO A  13      -8.876  -4.971   1.006  0.00  1.06           C  
ATOM    214  CD  PRO A  13      -9.809  -4.895  -0.166  0.00  0.76           C  
ATOM    215  HA  PRO A  13      -9.711  -2.158   1.388  0.00  0.94           H  
ATOM    216  HB2 PRO A  13      -7.319  -3.624   0.429  0.00  1.09           H  
ATOM    217  HB3 PRO A  13      -7.913  -3.395   2.078  0.00  1.26           H  
ATOM    218  HG2 PRO A  13      -8.147  -5.755   0.858  0.00  1.60           H  
ATOM    219  HG3 PRO A  13      -9.431  -5.140   1.917  0.00  1.39           H  
ATOM    220  HD2 PRO A  13      -9.301  -5.190  -1.074  0.00  1.18           H  
ATOM    221  HD3 PRO A  13     -10.679  -5.512   0.000  0.00  0.77           H  
ATOM    222  N   LYS A  14      -8.266  -0.433   0.268  0.00  0.44           N  
ATOM    223  CA  LYS A  14      -7.629   0.660  -0.459  1.00  0.35           C  
ATOM    224  C   LYS A  14      -6.618   1.384   0.427  1.00  0.33           C  
ATOM    225  O   LYS A  14      -6.874   1.625   1.606  0.00  0.37           O  
ATOM    226  CB  LYS A  14      -8.684   1.647  -0.957  0.00  0.40           C  
ATOM    227  CG  LYS A  14      -9.470   1.143  -2.158  0.00  0.42           C  
ATOM    228  CD  LYS A  14     -10.923   1.587  -2.098  0.00  0.69           C  
ATOM    229  CE  LYS A  14     -11.111   2.966  -2.710  0.00  0.90           C  
ATOM    230  NZ  LYS A  14     -11.191   4.029  -1.670  0.00  1.58           N  
ATOM    231  H   LYS A  14      -8.487  -0.311   1.215  0.00  0.54           H  
ATOM    232  HA  LYS A  14      -7.111   0.238  -1.306  0.00  0.33           H  
ATOM    233  HB2 LYS A  14      -9.380   1.848  -0.156  0.00  0.48           H  
ATOM    234  HB3 LYS A  14      -8.195   2.568  -1.237  0.00  0.47           H  
ATOM    235  HG2 LYS A  14      -9.022   1.533  -3.058  0.00  0.67           H  
ATOM    236  HG3 LYS A  14      -9.433   0.063  -2.170  0.00  0.61           H  
ATOM    237  HD2 LYS A  14     -11.529   0.878  -2.641  0.00  1.31           H  
ATOM    238  HD3 LYS A  14     -11.240   1.615  -1.065  0.00  1.25           H  
ATOM    239  HE2 LYS A  14     -10.274   3.174  -3.359  0.00  1.56           H  
ATOM    240  HE3 LYS A  14     -12.023   2.969  -3.287  0.00  1.51           H  
ATOM    241  HZ1 LYS A  14     -11.135   3.607  -0.722  0.00  2.05           H  
ATOM    242  HZ2 LYS A  14     -12.090   4.545  -1.756  0.00  2.10           H  
ATOM    243  HZ3 LYS A  14     -10.406   4.703  -1.786  0.00  2.11           H  
ATOM    244  N   MET A  15      -5.469   1.731  -0.148  1.00  0.30           N  
ATOM    245  CA  MET A  15      -4.426   2.428   0.597  1.00  0.31           C  
ATOM    246  C   MET A  15      -3.756   3.489  -0.266  1.00  0.27           C  
ATOM    247  O   MET A  15      -3.663   3.343  -1.481  0.00  0.29           O  
ATOM    248  CB  MET A  15      -3.374   1.437   1.106  0.00  0.34           C  
ATOM    249  CG  MET A  15      -3.952   0.293   1.925  0.00  0.53           C  
ATOM    250  SD  MET A  15      -3.217   0.177   3.568  0.00  1.03           S  
ATOM    251  CE  MET A  15      -3.750  -1.459   4.065  0.00  1.11           C  
ATOM    252  H   MET A  15      -5.319   1.515  -1.096  0.00  0.29           H  
ATOM    253  HA  MET A  15      -4.891   2.911   1.443  0.00  0.35           H  
ATOM    254  HB2 MET A  15      -2.855   1.017   0.258  0.00  0.41           H  
ATOM    255  HB3 MET A  15      -2.667   1.969   1.724  0.00  0.39           H  
ATOM    256  HG2 MET A  15      -5.017   0.447   2.033  0.00  0.78           H  
ATOM    257  HG3 MET A  15      -3.775  -0.633   1.400  0.00  0.79           H  
ATOM    258  HE1 MET A  15      -4.823  -1.463   4.196  0.00  1.69           H  
ATOM    259  HE2 MET A  15      -3.478  -2.173   3.304  0.00  1.51           H  
ATOM    260  HE3 MET A  15      -3.273  -1.724   4.996  0.00  1.57           H  
ATOM    261  N   GLU A  16      -3.280   4.552   0.373  1.00  0.23           N  
ATOM    262  CA  GLU A  16      -2.613   5.634  -0.339  1.00  0.22           C  
ATOM    263  C   GLU A  16      -1.115   5.615  -0.055  1.00  0.20           C  
ATOM    264  O   GLU A  16      -0.688   5.688   1.097  0.00  0.20           O  
ATOM    265  CB  GLU A  16      -3.208   6.986   0.062  0.00  0.24           C  
ATOM    266  CG  GLU A  16      -3.300   7.194   1.566  0.00  1.26           C  
ATOM    267  CD  GLU A  16      -3.844   8.561   1.932  0.00  1.37           C  
ATOM    268  OE1 GLU A  16      -3.088   9.549   1.825  0.00  1.67           O  
ATOM    269  OE2 GLU A  16      -5.029   8.644   2.322  0.00  1.78           O  
ATOM    270  H   GLU A  16      -3.380   4.609   1.346  0.00  0.23           H  
ATOM    271  HA  GLU A  16      -2.769   5.480  -1.397  0.00  0.24           H  
ATOM    272  HB2 GLU A  16      -2.592   7.773  -0.350  0.00  0.91           H  
ATOM    273  HB3 GLU A  16      -4.201   7.066  -0.353  0.00  0.90           H  
ATOM    274  HG2 GLU A  16      -3.954   6.440   1.980  0.00  1.89           H  
ATOM    275  HG3 GLU A  16      -2.314   7.089   1.993  0.00  1.82           H  
ATOM    276  N   VAL A  17      -0.322   5.506  -1.116  1.00  0.22           N  
ATOM    277  CA  VAL A  17       1.129   5.465  -0.986  1.00  0.24           C  
ATOM    278  C   VAL A  17       1.669   6.774  -0.419  1.00  0.27           C  
ATOM    279  O   VAL A  17       1.182   7.855  -0.750  0.00  0.29           O  
ATOM    280  CB  VAL A  17       1.811   5.186  -2.339  0.00  0.25           C  
ATOM    281  CG1 VAL A  17       3.268   4.806  -2.129  0.00  0.34           C  
ATOM    282  CG2 VAL A  17       1.073   4.092  -3.098  0.00  0.33           C  
ATOM    283  H   VAL A  17      -0.724   5.445  -2.009  0.00  0.23           H  
ATOM    284  HA  VAL A  17       1.379   4.662  -0.308  0.00  0.31           H  
ATOM    285  HB  VAL A  17       1.779   6.090  -2.929  0.00  0.24           H  
ATOM    286 HG11 VAL A  17       3.345   3.739  -1.987  0.00  1.14           H  
ATOM    287 HG12 VAL A  17       3.843   5.095  -2.998  0.00  0.99           H  
ATOM    288 HG13 VAL A  17       3.651   5.315  -1.258  0.00  1.09           H  
ATOM    289 HG21 VAL A  17       1.670   3.779  -3.943  0.00  1.03           H  
ATOM    290 HG22 VAL A  17       0.904   3.249  -2.444  0.00  1.08           H  
ATOM    291 HG23 VAL A  17       0.126   4.473  -3.448  0.00  1.10           H  
ATOM    292  N   PHE A  18       2.682   6.665   0.436  1.00  0.35           N  
ATOM    293  CA  PHE A  18       3.295   7.837   1.050  0.00  0.42           C  
ATOM    294  C   PHE A  18       4.652   8.132   0.423  0.00  0.40           C  
ATOM    295  O   PHE A  18       5.079   9.285   0.358  0.00  0.46           O  
ATOM    296  CB  PHE A  18       3.450   7.627   2.557  0.00  0.57           C  
ATOM    297  CG  PHE A  18       2.592   8.543   3.381  0.00  1.08           C  
ATOM    298  CD1 PHE A  18       2.920   9.883   3.517  0.00  1.60           C  
ATOM    299  CD2 PHE A  18       1.460   8.065   4.021  0.00  1.81           C  
ATOM    300  CE1 PHE A  18       2.132  10.728   4.276  0.00  2.76           C  
ATOM    301  CE2 PHE A  18       0.670   8.907   4.780  0.00  2.95           C  
ATOM    302  CZ  PHE A  18       1.004  10.240   4.905  0.00  3.42           C  
ATOM    303  H   PHE A  18       3.027   5.777   0.658  0.00  0.39           H  
ATOM    304  HA  PHE A  18       2.641   8.680   0.879  0.00  0.44           H  
ATOM    305  HB2 PHE A  18       3.179   6.610   2.801  0.00  1.48           H  
ATOM    306  HB3 PHE A  18       4.479   7.796   2.833  0.00  1.18           H  
ATOM    307  HD1 PHE A  18       3.799  10.266   3.023  0.00  1.25           H  
ATOM    308  HD2 PHE A  18       1.196   7.023   3.922  0.00  1.60           H  
ATOM    309  HE1 PHE A  18       2.398  11.772   4.375  0.00  3.20           H  
ATOM    310  HE2 PHE A  18      -0.210   8.521   5.274  0.00  3.54           H  
ATOM    311  HZ  PHE A  18       0.387  10.901   5.497  0.00  4.35           H  
ATOM    312  N   GLN A  19       5.328   7.083  -0.037  0.00  0.40           N  
ATOM    313  CA  GLN A  19       6.640   7.232  -0.660  0.00  0.41           C  
ATOM    314  C   GLN A  19       6.543   7.099  -2.178  1.00  0.33           C  
ATOM    315  O   GLN A  19       5.506   6.704  -2.709  0.00  0.35           O  
ATOM    316  CB  GLN A  19       7.621   6.199  -0.084  0.00  0.54           C  
ATOM    317  CG  GLN A  19       7.818   4.965  -0.953  0.00  1.07           C  
ATOM    318  CD  GLN A  19       6.566   4.116  -1.061  0.00  1.71           C  
ATOM    319  OE1 GLN A  19       6.180   3.694  -2.151  0.00  2.82           O  
ATOM    320  NE2 GLN A  19       5.925   3.861   0.073  0.00  1.38           N  
ATOM    321  H   GLN A  19       4.935   6.187   0.044  0.00  0.44           H  
ATOM    322  HA  GLN A  19       7.000   8.222  -0.424  0.00  0.47           H  
ATOM    323  HB2 GLN A  19       8.582   6.672   0.048  0.00  1.30           H  
ATOM    324  HB3 GLN A  19       7.256   5.877   0.881  0.00  1.15           H  
ATOM    325  HG2 GLN A  19       8.104   5.281  -1.945  0.00  1.51           H  
ATOM    326  HG3 GLN A  19       8.606   4.363  -0.527  0.00  1.57           H  
ATOM    327 HE21 GLN A  19       6.290   4.230   0.904  0.00  1.19           H  
ATOM    328 HE22 GLN A  19       5.111   3.315   0.033  0.00  1.86           H  
ATOM    329  N   GLU A  20       7.627   7.433  -2.872  1.00  0.34           N  
ATOM    330  CA  GLU A  20       7.658   7.351  -4.328  1.00  0.34           C  
ATOM    331  C   GLU A  20       8.768   6.415  -4.800  1.00  0.37           C  
ATOM    332  O   GLU A  20       9.904   6.840  -5.017  0.00  0.53           O  
ATOM    333  CB  GLU A  20       7.854   8.742  -4.938  0.00  0.42           C  
ATOM    334  CG  GLU A  20       8.850   9.606  -4.180  0.00  0.59           C  
ATOM    335  CD  GLU A  20       9.854  10.276  -5.097  0.00  1.13           C  
ATOM    336  OE1 GLU A  20      10.720   9.566  -5.650  0.00  1.61           O  
ATOM    337  OE2 GLU A  20       9.775  11.512  -5.260  0.00  1.95           O  
ATOM    338  H   GLU A  20       8.425   7.744  -2.392  0.00  0.41           H  
ATOM    339  HA  GLU A  20       6.709   6.956  -4.656  0.00  0.34           H  
ATOM    340  HB2 GLU A  20       8.205   8.631  -5.954  0.00  0.64           H  
ATOM    341  HB3 GLU A  20       6.903   9.254  -4.950  0.00  0.64           H  
ATOM    342  HG2 GLU A  20       8.310  10.371  -3.644  0.00  1.17           H  
ATOM    343  HG3 GLU A  20       9.385   8.984  -3.478  0.00  1.20           H  
ATOM    344  N   TYR A  21       8.431   5.137  -4.954  1.00  0.36           N  
ATOM    345  CA  TYR A  21       9.399   4.140  -5.400  0.00  0.42           C  
ATOM    346  C   TYR A  21       9.227   3.839  -6.886  1.00  0.36           C  
ATOM    347  O   TYR A  21       8.106   3.730  -7.382  0.00  0.37           O  
ATOM    348  CB  TYR A  21       9.248   2.849  -4.589  0.00  0.56           C  
ATOM    349  CG  TYR A  21       9.917   2.888  -3.228  0.00  0.66           C  
ATOM    350  CD1 TYR A  21      11.008   3.716  -2.982  0.00  0.96           C  
ATOM    351  CD2 TYR A  21       9.456   2.090  -2.187  0.00  0.99           C  
ATOM    352  CE1 TYR A  21      11.616   3.748  -1.741  0.00  1.11           C  
ATOM    353  CE2 TYR A  21      10.059   2.117  -0.944  0.00  1.09           C  
ATOM    354  CZ  TYR A  21      11.137   2.947  -0.726  0.00  0.98           C  
ATOM    355  OH  TYR A  21      11.741   2.976   0.509  0.00  1.16           O  
ATOM    356  H   TYR A  21       7.510   4.860  -4.766  0.00  0.42           H  
ATOM    357  HA  TYR A  21      10.387   4.543  -5.239  0.00  0.49           H  
ATOM    358  HB2 TYR A  21       8.198   2.651  -4.433  0.00  0.58           H  
ATOM    359  HB3 TYR A  21       9.683   2.031  -5.146  0.00  0.65           H  
ATOM    360  HD1 TYR A  21      11.380   4.344  -3.778  0.00  1.30           H  
ATOM    361  HD2 TYR A  21       8.609   1.442  -2.359  0.00  1.36           H  
ATOM    362  HE1 TYR A  21      12.461   4.398  -1.570  0.00  1.51           H  
ATOM    363  HE2 TYR A  21       9.685   1.489  -0.149  0.00  1.48           H  
ATOM    364  HH  TYR A  21      11.957   2.080   0.781  0.00  1.49           H  
ATOM    365  N   TYR A  22      10.348   3.705  -7.591  1.00  0.37           N  
ATOM    366  CA  TYR A  22      10.323   3.414  -9.020  0.00  0.39           C  
ATOM    367  C   TYR A  22      11.080   2.125  -9.325  0.00  0.42           C  
ATOM    368  O   TYR A  22      12.071   2.131 -10.056  0.00  0.50           O  
ATOM    369  CB  TYR A  22      10.929   4.576  -9.812  0.00  0.45           C  
ATOM    370  CG  TYR A  22      10.292   5.915  -9.515  0.00  0.68           C  
ATOM    371  CD1 TYR A  22       8.946   6.142  -9.772  0.00  1.02           C  
ATOM    372  CD2 TYR A  22      11.041   6.956  -8.979  0.00  1.07           C  
ATOM    373  CE1 TYR A  22       8.363   7.367  -9.503  0.00  1.40           C  
ATOM    374  CE2 TYR A  22      10.468   8.183  -8.707  0.00  1.44           C  
ATOM    375  CZ  TYR A  22       9.129   8.384  -8.970  0.00  1.52           C  
ATOM    376  OH  TYR A  22       8.553   9.604  -8.702  0.00  1.98           O  
ATOM    377  H   TYR A  22      11.212   3.802  -7.138  0.00  0.42           H  
ATOM    378  HA  TYR A  22       9.291   3.289  -9.314  0.00  0.41           H  
ATOM    379  HB2 TYR A  22      11.981   4.651  -9.580  0.00  0.65           H  
ATOM    380  HB3 TYR A  22      10.812   4.379 -10.869  0.00  0.62           H  
ATOM    381  HD1 TYR A  22       8.349   5.345 -10.188  0.00  1.22           H  
ATOM    382  HD2 TYR A  22      12.091   6.796  -8.773  0.00  1.29           H  
ATOM    383  HE1 TYR A  22       7.316   7.523  -9.708  0.00  1.77           H  
ATOM    384  HE2 TYR A  22      11.067   8.979  -8.290  0.00  1.82           H  
ATOM    385  HH  TYR A  22       8.855   9.920  -7.847  0.00  2.20           H  
ATOM    386  N   GLY A  23      10.606   1.019  -8.759  0.00  0.43           N  
ATOM    387  CA  GLY A  23      11.245  -0.264  -8.978  0.00  0.49           C  
ATOM    388  C   GLY A  23      12.473  -0.461  -8.109  0.00  0.50           C  
ATOM    389  O   GLY A  23      13.208  -1.435  -8.272  0.00  0.56           O  
ATOM    390  H   GLY A  23       9.812   1.077  -8.185  0.00  0.46           H  
ATOM    391  HA2 GLY A  23      10.536  -1.050  -8.759  0.00  0.52           H  
ATOM    392  HA3 GLY A  23      11.537  -0.338 -10.015  0.00  0.57           H  
ATOM    393  N   ILE A  24      12.695   0.469  -7.183  0.00  0.52           N  
ATOM    394  CA  ILE A  24      13.839   0.399  -6.282  0.00  0.65           C  
ATOM    395  C   ILE A  24      13.422   0.726  -4.848  0.00  0.73           C  
ATOM    396  O   ILE A  24      12.714   1.706  -4.613  0.00  0.80           O  
ATOM    397  CB  ILE A  24      14.959   1.371  -6.717  0.00  0.80           C  
ATOM    398  CG1 ILE A  24      15.407   1.069  -8.151  0.00  0.99           C  
ATOM    399  CG2 ILE A  24      16.140   1.296  -5.756  0.00  0.84           C  
ATOM    400  CD1 ILE A  24      16.064  -0.287  -8.316  0.00  1.57           C  
ATOM    401  H   ILE A  24      12.071   1.221  -7.104  0.00  0.50           H  
ATOM    402  HA  ILE A  24      14.231  -0.608  -6.316  0.00  0.65           H  
ATOM    403  HB  ILE A  24      14.564   2.375  -6.678  0.00  0.91           H  
ATOM    404 HG12 ILE A  24      14.547   1.098  -8.803  0.00  1.19           H  
ATOM    405 HG13 ILE A  24      16.115   1.821  -8.465  0.00  1.28           H  
ATOM    406 HG21 ILE A  24      16.454   0.267  -5.651  0.00  1.26           H  
ATOM    407 HG22 ILE A  24      16.958   1.883  -6.147  0.00  1.24           H  
ATOM    408 HG23 ILE A  24      15.846   1.683  -4.793  0.00  1.46           H  
ATOM    409 HD11 ILE A  24      15.390  -1.059  -7.972  0.00  2.01           H  
ATOM    410 HD12 ILE A  24      16.295  -0.452  -9.358  0.00  2.13           H  
ATOM    411 HD13 ILE A  24      16.975  -0.320  -7.736  0.00  1.91           H  
ATOM    412  N   PRO A  25      13.849  -0.090  -3.863  0.00  0.79           N  
ATOM    413  CA  PRO A  25      14.690  -1.266  -4.091  0.00  0.76           C  
ATOM    414  C   PRO A  25      13.876  -2.509  -4.449  0.00  0.58           C  
ATOM    415  O   PRO A  25      12.770  -2.702  -3.945  0.00  0.55           O  
ATOM    416  CB  PRO A  25      15.376  -1.446  -2.743  0.00  0.92           C  
ATOM    417  CG  PRO A  25      14.365  -0.981  -1.748  0.00  0.98           C  
ATOM    418  CD  PRO A  25      13.539   0.084  -2.431  0.00  0.93           C  
ATOM    419  HA  PRO A  25      15.430  -1.084  -4.856  0.00  0.82           H  
ATOM    420  HB2 PRO A  25      15.627  -2.487  -2.598  0.00  0.94           H  
ATOM    421  HB3 PRO A  25      16.270  -0.844  -2.706  0.00  1.07           H  
ATOM    422  HG2 PRO A  25      13.736  -1.808  -1.453  0.00  1.07           H  
ATOM    423  HG3 PRO A  25      14.866  -0.568  -0.885  0.00  1.16           H  
ATOM    424  HD2 PRO A  25      12.488  -0.079  -2.244  0.00  0.93           H  
ATOM    425  HD3 PRO A  25      13.836   1.064  -2.092  0.00  1.07           H  
ATOM    426  N   PRO A  26      14.417  -3.375  -5.328  0.00  0.55           N  
ATOM    427  CA  PRO A  26      13.735  -4.605  -5.748  0.00  0.46           C  
ATOM    428  C   PRO A  26      13.538  -5.578  -4.589  0.00  0.41           C  
ATOM    429  O   PRO A  26      14.298  -5.563  -3.621  0.00  0.47           O  
ATOM    430  CB  PRO A  26      14.677  -5.212  -6.798  0.00  0.60           C  
ATOM    431  CG  PRO A  26      15.604  -4.110  -7.185  0.00  0.80           C  
ATOM    432  CD  PRO A  26      15.727  -3.227  -5.979  0.00  0.71           C  
ATOM    433  HA  PRO A  26      12.777  -4.389  -6.201  0.00  0.45           H  
ATOM    434  HB2 PRO A  26      15.212  -6.043  -6.362  0.00  0.82           H  
ATOM    435  HB3 PRO A  26      14.100  -5.555  -7.643  0.00  0.70           H  
ATOM    436  HG2 PRO A  26      16.568  -4.520  -7.449  0.00  1.14           H  
ATOM    437  HG3 PRO A  26      15.191  -3.557  -8.014  0.00  1.14           H  
ATOM    438  HD2 PRO A  26      16.522  -3.574  -5.333  0.00  0.78           H  
ATOM    439  HD3 PRO A  26      15.897  -2.203  -6.274  0.00  0.90           H  
ATOM    440  N   PRO A  27      12.509  -6.442  -4.669  1.00  0.37           N  
ATOM    441  CA  PRO A  27      12.215  -7.422  -3.620  0.00  0.42           C  
ATOM    442  C   PRO A  27      13.280  -8.516  -3.538  0.00  0.44           C  
ATOM    443  O   PRO A  27      13.873  -8.889  -4.550  0.00  0.40           O  
ATOM    444  CB  PRO A  27      10.865  -8.025  -4.041  0.00  0.48           C  
ATOM    445  CG  PRO A  27      10.343  -7.128  -5.115  0.00  0.48           C  
ATOM    446  CD  PRO A  27      11.549  -6.530  -5.776  0.00  0.39           C  
ATOM    447  HA  PRO A  27      12.114  -6.948  -2.655  0.00  0.47           H  
ATOM    448  HB2 PRO A  27      11.019  -9.030  -4.409  0.00  0.69           H  
ATOM    449  HB3 PRO A  27      10.200  -8.049  -3.191  0.00  0.67           H  
ATOM    450  HG2 PRO A  27       9.771  -7.703  -5.828  0.00  0.81           H  
ATOM    451  HG3 PRO A  27       9.732  -6.351  -4.679  0.00  0.71           H  
ATOM    452  HD2 PRO A  27      11.915  -7.180  -6.559  0.00  0.51           H  
ATOM    453  HD3 PRO A  27      11.321  -5.551  -6.170  0.00  0.50           H  
ATOM    454  N   PRO A  28      13.539  -9.042  -2.327  0.00  0.60           N  
ATOM    455  CA  PRO A  28      14.541 -10.093  -2.122  0.00  0.70           C  
ATOM    456  C   PRO A  28      14.067 -11.459  -2.608  0.00  0.77           C  
ATOM    457  O   PRO A  28      12.879 -11.776  -2.535  0.00  0.97           O  
ATOM    458  CB  PRO A  28      14.727 -10.104  -0.605  0.00  1.03           C  
ATOM    459  CG  PRO A  28      13.414  -9.651  -0.069  0.00  0.84           C  
ATOM    460  CD  PRO A  28      12.883  -8.654  -1.064  0.00  0.74           C  
ATOM    461  HA  PRO A  28      15.479  -9.847  -2.600  0.00  0.65           H  
ATOM    462  HB2 PRO A  28      14.967 -11.104  -0.276  0.00  1.38           H  
ATOM    463  HB3 PRO A  28      15.520  -9.427  -0.331  0.00  1.31           H  
ATOM    464  HG2 PRO A  28      12.741 -10.491   0.016  0.00  1.00           H  
ATOM    465  HG3 PRO A  28      13.552  -9.182   0.895  0.00  0.96           H  
ATOM    466  HD2 PRO A  28      11.809  -8.739  -1.146  0.00  0.80           H  
ATOM    467  HD3 PRO A  28      13.161  -7.651  -0.777  0.00  0.81           H  
ATOM    468  N   GLY A  29      15.005 -12.262  -3.100  0.00  0.78           N  
ATOM    469  CA  GLY A  29      14.672 -13.588  -3.588  0.00  0.97           C  
ATOM    470  C   GLY A  29      13.677 -13.556  -4.732  0.00  1.03           C  
ATOM    471  O   GLY A  29      13.385 -12.494  -5.281  0.00  1.87           O  
ATOM    472  H   GLY A  29      15.935 -11.952  -3.128  0.00  0.77           H  
ATOM    473  HA2 GLY A  29      15.577 -14.071  -3.927  0.00  1.50           H  
ATOM    474  HA3 GLY A  29      14.252 -14.162  -2.776  0.00  1.28           H  
ATOM    475  N   ALA A  30      13.158 -14.726  -5.092  0.00  1.14           N  
ATOM    476  CA  ALA A  30      12.190 -14.832  -6.177  0.00  1.51           C  
ATOM    477  C   ALA A  30      10.763 -14.694  -5.656  0.00  1.30           C  
ATOM    478  O   ALA A  30      10.079 -15.690  -5.416  0.00  1.92           O  
ATOM    479  CB  ALA A  30      12.364 -16.156  -6.909  0.00  1.97           C  
ATOM    480  H   ALA A  30      13.432 -15.538  -4.615  0.00  1.60           H  
ATOM    481  HA  ALA A  30      12.385 -14.034  -6.877  0.00  1.98           H  
ATOM    482  HB1 ALA A  30      12.184 -16.971  -6.225  0.00  2.23           H  
ATOM    483  HB2 ALA A  30      11.661 -16.209  -7.727  0.00  2.36           H  
ATOM    484  HB3 ALA A  30      13.370 -16.224  -7.295  0.00  2.43           H  
ATOM    485  N   PHE A  31      10.320 -13.453  -5.483  0.00  0.94           N  
ATOM    486  CA  PHE A  31       8.974 -13.180  -4.991  0.00  0.71           C  
ATOM    487  C   PHE A  31       8.094 -12.611  -6.099  0.00  0.69           C  
ATOM    488  O   PHE A  31       6.920 -12.963  -6.216  0.00  1.26           O  
ATOM    489  CB  PHE A  31       9.029 -12.202  -3.816  0.00  0.69           C  
ATOM    490  CG  PHE A  31       9.029 -12.875  -2.471  0.00  0.72           C  
ATOM    491  CD1 PHE A  31      10.129 -13.605  -2.050  0.00  0.94           C  
ATOM    492  CD2 PHE A  31       7.932 -12.777  -1.632  0.00  0.78           C  
ATOM    493  CE1 PHE A  31      10.132 -14.224  -0.813  0.00  1.04           C  
ATOM    494  CE2 PHE A  31       7.930 -13.394  -0.396  0.00  0.90           C  
ATOM    495  CZ  PHE A  31       9.031 -14.119   0.014  0.00  0.95           C  
ATOM    496  H   PHE A  31      10.914 -12.701  -5.693  0.00  1.33           H  
ATOM    497  HA  PHE A  31       8.548 -14.113  -4.653  0.00  0.77           H  
ATOM    498  HB2 PHE A  31       9.929 -11.609  -3.890  0.00  0.83           H  
ATOM    499  HB3 PHE A  31       8.169 -11.549  -3.860  0.00  0.70           H  
ATOM    500  HD1 PHE A  31      10.990 -13.689  -2.695  0.00  1.15           H  
ATOM    501  HD2 PHE A  31       7.070 -12.211  -1.952  0.00  0.91           H  
ATOM    502  HE1 PHE A  31      10.996 -14.791  -0.496  0.00  1.29           H  
ATOM    503  HE2 PHE A  31       7.068 -13.309   0.249  0.00  1.09           H  
ATOM    504  HZ  PHE A  31       9.033 -14.603   0.980  0.00  1.08           H  
ATOM    505  N   GLY A  32       8.669 -11.729  -6.912  0.00  0.45           N  
ATOM    506  CA  GLY A  32       7.923 -11.123  -8.001  0.00  0.48           C  
ATOM    507  C   GLY A  32       8.444  -9.748  -8.366  0.00  0.61           C  
ATOM    508  O   GLY A  32       9.295  -9.197  -7.668  0.00  1.51           O  
ATOM    509  H   GLY A  32       9.608 -11.486  -6.770  0.00  0.78           H  
ATOM    510  HA2 GLY A  32       7.990 -11.764  -8.869  0.00  0.54           H  
ATOM    511  HA3 GLY A  32       6.887 -11.039  -7.709  0.00  0.51           H  
ATOM    512  N   GLY A  33       7.931  -9.192  -9.459  0.00  0.58           N  
ATOM    513  CA  GLY A  33       8.361  -7.876  -9.892  0.00  0.49           C  
ATOM    514  C   GLY A  33       7.899  -6.779  -8.955  0.00  0.45           C  
ATOM    515  O   GLY A  33       6.946  -6.963  -8.197  0.00  0.56           O  
ATOM    516  H   GLY A  33       7.254  -9.678  -9.974  0.00  1.26           H  
ATOM    517  HA2 GLY A  33       9.440  -7.860  -9.943  0.00  0.46           H  
ATOM    518  HA3 GLY A  33       7.963  -7.683 -10.878  0.00  0.52           H  
ATOM    519  N   PHE A  34       8.572  -5.635  -9.008  1.00  0.35           N  
ATOM    520  CA  PHE A  34       8.223  -4.504  -8.157  1.00  0.31           C  
ATOM    521  C   PHE A  34       7.123  -3.663  -8.797  1.00  0.30           C  
ATOM    522  O   PHE A  34       6.871  -3.764  -9.998  0.00  0.35           O  
ATOM    523  CB  PHE A  34       9.454  -3.637  -7.888  0.00  0.31           C  
ATOM    524  CG  PHE A  34       9.380  -2.868  -6.600  0.00  0.31           C  
ATOM    525  CD1 PHE A  34       9.697  -3.476  -5.396  0.00  0.38           C  
ATOM    526  CD2 PHE A  34       8.990  -1.539  -6.592  0.00  0.34           C  
ATOM    527  CE1 PHE A  34       9.628  -2.772  -4.208  0.00  0.42           C  
ATOM    528  CE2 PHE A  34       8.918  -0.830  -5.407  0.00  0.37           C  
ATOM    529  CZ  PHE A  34       9.239  -1.447  -4.215  0.00  0.38           C  
ATOM    530  H   PHE A  34       9.322  -5.549  -9.634  0.00  0.37           H  
ATOM    531  HA  PHE A  34       7.859  -4.897  -7.218  0.00  0.32           H  
ATOM    532  HB2 PHE A  34      10.329  -4.269  -7.848  0.00  0.33           H  
ATOM    533  HB3 PHE A  34       9.566  -2.926  -8.696  0.00  0.32           H  
ATOM    534  HD1 PHE A  34      10.003  -4.513  -5.390  0.00  0.45           H  
ATOM    535  HD2 PHE A  34       8.740  -1.054  -7.525  0.00  0.41           H  
ATOM    536  HE1 PHE A  34       9.878  -3.258  -3.276  0.00  0.52           H  
ATOM    537  HE2 PHE A  34       8.613   0.207  -5.415  0.00  0.44           H  
ATOM    538  HZ  PHE A  34       9.183  -0.897  -3.287  0.00  0.43           H  
ATOM    539  N   LEU A  35       6.471  -2.835  -7.988  1.00  0.28           N  
ATOM    540  CA  LEU A  35       5.396  -1.977  -8.472  1.00  0.28           C  
ATOM    541  C   LEU A  35       5.729  -0.505  -8.247  1.00  0.26           C  
ATOM    542  O   LEU A  35       6.292  -0.138  -7.215  0.00  0.29           O  
ATOM    543  CB  LEU A  35       4.081  -2.330  -7.773  0.00  0.32           C  
ATOM    544  CG  LEU A  35       2.965  -1.293  -7.920  0.00  0.30           C  
ATOM    545  CD1 LEU A  35       2.175  -1.533  -9.197  0.00  0.39           C  
ATOM    546  CD2 LEU A  35       2.047  -1.324  -6.707  0.00  0.39           C  
ATOM    547  H   LEU A  35       6.718  -2.801  -7.039  0.00  0.29           H  
ATOM    548  HA  LEU A  35       5.288  -2.150  -9.533  0.00  0.31           H  
ATOM    549  HB2 LEU A  35       3.727  -3.269  -8.175  0.00  0.40           H  
ATOM    550  HB3 LEU A  35       4.282  -2.463  -6.721  0.00  0.37           H  
ATOM    551  HG  LEU A  35       3.405  -0.308  -7.982  0.00  0.31           H  
ATOM    552 HD11 LEU A  35       1.137  -1.707  -8.952  0.00  0.90           H  
ATOM    553 HD12 LEU A  35       2.253  -0.667  -9.837  0.00  0.95           H  
ATOM    554 HD13 LEU A  35       2.573  -2.397  -9.710  0.00  0.98           H  
ATOM    555 HD21 LEU A  35       1.160  -0.744  -6.913  0.00  1.03           H  
ATOM    556 HD22 LEU A  35       1.767  -2.345  -6.494  0.00  0.85           H  
ATOM    557 HD23 LEU A  35       2.562  -0.907  -5.855  0.00  1.03           H  
ATOM    558  N   ARG A  36       5.377   0.331  -9.216  1.00  0.29           N  
ATOM    559  CA  ARG A  36       5.635   1.763  -9.122  1.00  0.29           C  
ATOM    560  C   ARG A  36       4.622   2.433  -8.201  1.00  0.31           C  
ATOM    561  O   ARG A  36       3.433   2.503  -8.516  0.00  0.41           O  
ATOM    562  CB  ARG A  36       5.588   2.405 -10.509  0.00  0.38           C  
ATOM    563  CG  ARG A  36       6.936   2.434 -11.209  0.00  0.92           C  
ATOM    564  CD  ARG A  36       6.811   2.927 -12.641  0.00  1.37           C  
ATOM    565  NE  ARG A  36       7.704   4.050 -12.912  0.00  1.90           N  
ATOM    566  CZ  ARG A  36       8.927   3.914 -13.417  0.00  2.59           C  
ATOM    567  NH1 ARG A  36       9.398   2.708 -13.711  0.00  3.01           N  
ATOM    568  NH2 ARG A  36       9.681   4.983 -13.629  0.00  3.39           N  
ATOM    569  H   ARG A  36       4.930  -0.021 -10.014  0.00  0.36           H  
ATOM    570  HA  ARG A  36       6.624   1.894  -8.707  0.00  0.29           H  
ATOM    571  HB2 ARG A  36       4.897   1.850 -11.127  0.00  0.81           H  
ATOM    572  HB3 ARG A  36       5.234   3.420 -10.411  0.00  0.90           H  
ATOM    573  HG2 ARG A  36       7.597   3.096 -10.670  0.00  1.44           H  
ATOM    574  HG3 ARG A  36       7.349   1.436 -11.216  0.00  1.40           H  
ATOM    575  HD2 ARG A  36       7.055   2.115 -13.311  0.00  1.84           H  
ATOM    576  HD3 ARG A  36       5.791   3.241 -12.814  0.00  1.96           H  
ATOM    577  HE  ARG A  36       7.378   4.949 -12.707  0.00  2.27           H  
ATOM    578 HH11 ARG A  36       8.833   1.898 -13.553  0.00  2.95           H  
ATOM    579 HH12 ARG A  36      10.318   2.611 -14.089  0.00  3.72           H  
ATOM    580 HH21 ARG A  36       9.331   5.894 -13.411  0.00  3.67           H  
ATOM    581 HH22 ARG A  36      10.601   4.879 -14.008  0.00  3.96           H  
ATOM    582  N   LEU A  37       5.099   2.918  -7.060  1.00  0.32           N  
ATOM    583  CA  LEU A  37       4.234   3.577  -6.089  0.00  0.43           C  
ATOM    584  C   LEU A  37       4.512   5.076  -6.032  1.00  0.28           C  
ATOM    585  O   LEU A  37       5.667   5.503  -6.003  0.00  0.36           O  
ATOM    586  CB  LEU A  37       4.427   2.955  -4.705  0.00  0.64           C  
ATOM    587  CG  LEU A  37       4.554   1.431  -4.691  0.00  0.84           C  
ATOM    588  CD1 LEU A  37       5.960   1.017  -4.282  0.00  1.09           C  
ATOM    589  CD2 LEU A  37       3.522   0.818  -3.756  0.00  1.48           C  
ATOM    590  H   LEU A  37       6.055   2.826  -6.863  0.00  0.35           H  
ATOM    591  HA  LEU A  37       3.211   3.424  -6.402  0.00  0.55           H  
ATOM    592  HB2 LEU A  37       5.321   3.375  -4.268  0.00  0.67           H  
ATOM    593  HB3 LEU A  37       3.583   3.229  -4.089  0.00  0.82           H  
ATOM    594  HG  LEU A  37       4.372   1.052  -5.686  0.00  1.35           H  
ATOM    595 HD11 LEU A  37       5.919   0.483  -3.344  0.00  1.66           H  
ATOM    596 HD12 LEU A  37       6.382   0.376  -5.042  0.00  1.70           H  
ATOM    597 HD13 LEU A  37       6.577   1.897  -4.169  0.00  1.51           H  
ATOM    598 HD21 LEU A  37       2.931   1.602  -3.308  0.00  1.86           H  
ATOM    599 HD22 LEU A  37       2.879   0.156  -4.316  0.00  2.07           H  
ATOM    600 HD23 LEU A  37       4.026   0.258  -2.981  0.00  1.98           H  
ATOM    601  N   ASN A  38       3.445   5.869  -6.014  1.00  0.27           N  
ATOM    602  CA  ASN A  38       3.567   7.322  -5.957  1.00  0.29           C  
ATOM    603  C   ASN A  38       2.642   7.902  -4.890  1.00  0.28           C  
ATOM    604  O   ASN A  38       1.538   7.400  -4.678  0.00  0.31           O  
ATOM    605  CB  ASN A  38       3.242   7.938  -7.319  0.00  0.45           C  
ATOM    606  CG  ASN A  38       4.209   7.500  -8.400  0.00  1.26           C  
ATOM    607  OD1 ASN A  38       5.393   7.834  -8.362  0.00  2.09           O  
ATOM    608  ND2 ASN A  38       3.709   6.746  -9.372  0.00  1.75           N  
ATOM    609  H   ASN A  38       2.551   5.467  -6.037  0.00  0.38           H  
ATOM    610  HA  ASN A  38       4.589   7.559  -5.699  0.00  0.32           H  
ATOM    611  HB2 ASN A  38       2.246   7.643  -7.613  0.00  1.19           H  
ATOM    612  HB3 ASN A  38       3.284   9.015  -7.239  0.00  1.00           H  
ATOM    613 HD21 ASN A  38       2.756   6.519  -9.337  0.00  1.73           H  
ATOM    614 HD22 ASN A  38       4.312   6.450 -10.085  0.00  2.47           H  
ATOM    615  N   PRO A  39       3.079   8.973  -4.201  1.00  0.30           N  
ATOM    616  CA  PRO A  39       2.279   9.617  -3.152  1.00  0.32           C  
ATOM    617  C   PRO A  39       0.932  10.110  -3.673  1.00  0.32           C  
ATOM    618  O   PRO A  39       0.822  11.230  -4.173  0.00  0.39           O  
ATOM    619  CB  PRO A  39       3.146  10.802  -2.708  0.00  0.37           C  
ATOM    620  CG  PRO A  39       4.530  10.453  -3.135  0.00  0.42           C  
ATOM    621  CD  PRO A  39       4.381   9.637  -4.387  0.00  0.35           C  
ATOM    622  HA  PRO A  39       2.118   8.953  -2.316  0.00  0.33           H  
ATOM    623  HB2 PRO A  39       2.799  11.704  -3.192  0.00  0.53           H  
ATOM    624  HB3 PRO A  39       3.082  10.914  -1.636  0.00  0.52           H  
ATOM    625  HG2 PRO A  39       5.089  11.354  -3.339  0.00  0.69           H  
ATOM    626  HG3 PRO A  39       5.016   9.873  -2.366  0.00  0.67           H  
ATOM    627  HD2 PRO A  39       4.367  10.278  -5.256  0.00  0.42           H  
ATOM    628  HD3 PRO A  39       5.176   8.911  -4.462  0.00  0.44           H  
ATOM    629  N   GLY A  40      -0.088   9.264  -3.556  1.00  0.28           N  
ATOM    630  CA  GLY A  40      -1.412   9.631  -4.021  1.00  0.30           C  
ATOM    631  C   GLY A  40      -2.052   8.534  -4.849  1.00  0.26           C  
ATOM    632  O   GLY A  40      -3.065   8.758  -5.514  0.00  0.28           O  
ATOM    633  H   GLY A  40       0.058   8.383  -3.154  0.00  0.27           H  
ATOM    634  HA2 GLY A  40      -2.039   9.835  -3.166  0.00  0.34           H  
ATOM    635  HA3 GLY A  40      -1.338  10.525  -4.623  0.00  0.34           H  
ATOM    636  N   ASP A  41      -1.456   7.348  -4.809  1.00  0.25           N  
ATOM    637  CA  ASP A  41      -1.968   6.208  -5.560  1.00  0.24           C  
ATOM    638  C   ASP A  41      -2.650   5.206  -4.636  1.00  0.20           C  
ATOM    639  O   ASP A  41      -2.119   4.854  -3.582  0.00  0.21           O  
ATOM    640  CB  ASP A  41      -0.832   5.518  -6.320  0.00  0.30           C  
ATOM    641  CG  ASP A  41      -0.293   6.363  -7.457  0.00  0.93           C  
ATOM    642  OD1 ASP A  41      -0.690   7.543  -7.559  0.00  1.53           O  
ATOM    643  OD2 ASP A  41       0.526   5.847  -8.246  0.00  1.49           O  
ATOM    644  H   ASP A  41      -0.651   7.236  -4.262  0.00  0.29           H  
ATOM    645  HA  ASP A  41      -2.693   6.576  -6.270  0.00  0.28           H  
ATOM    646  HB2 ASP A  41      -0.024   5.311  -5.635  0.00  0.70           H  
ATOM    647  HB3 ASP A  41      -1.198   4.587  -6.730  0.00  0.63           H  
ATOM    648  N   ILE A  42      -3.829   4.749  -5.042  1.00  0.22           N  
ATOM    649  CA  ILE A  42      -4.587   3.782  -4.262  1.00  0.24           C  
ATOM    650  C   ILE A  42      -4.253   2.357  -4.690  1.00  0.23           C  
ATOM    651  O   ILE A  42      -4.284   2.033  -5.877  0.00  0.32           O  
ATOM    652  CB  ILE A  42      -6.106   4.009  -4.407  0.00  0.37           C  
ATOM    653  CG1 ILE A  42      -6.465   5.467  -4.102  0.00  0.59           C  
ATOM    654  CG2 ILE A  42      -6.874   3.063  -3.493  0.00  0.57           C  
ATOM    655  CD1 ILE A  42      -6.139   5.897  -2.686  0.00  0.82           C  
ATOM    656  H   ILE A  42      -4.193   5.065  -5.890  0.00  0.28           H  
ATOM    657  HA  ILE A  42      -4.322   3.909  -3.224  0.00  0.27           H  
ATOM    658  HB  ILE A  42      -6.384   3.784  -5.426  0.00  0.49           H  
ATOM    659 HG12 ILE A  42      -5.919   6.112  -4.775  0.00  1.41           H  
ATOM    660 HG13 ILE A  42      -7.524   5.609  -4.256  0.00  1.31           H  
ATOM    661 HG21 ILE A  42      -6.741   3.369  -2.465  0.00  1.11           H  
ATOM    662 HG22 ILE A  42      -7.925   3.096  -3.743  0.00  1.25           H  
ATOM    663 HG23 ILE A  42      -6.505   2.058  -3.621  0.00  1.23           H  
ATOM    664 HD11 ILE A  42      -6.417   6.932  -2.550  0.00  1.35           H  
ATOM    665 HD12 ILE A  42      -6.688   5.282  -1.989  0.00  1.52           H  
ATOM    666 HD13 ILE A  42      -5.079   5.784  -2.509  0.00  1.55           H  
ATOM    667  N   VAL A  43      -3.932   1.512  -3.718  1.00  0.22           N  
ATOM    668  CA  VAL A  43      -3.592   0.122  -3.996  1.00  0.23           C  
ATOM    669  C   VAL A  43      -4.472  -0.826  -3.187  1.00  0.22           C  
ATOM    670  O   VAL A  43      -4.789  -0.557  -2.028  0.00  0.27           O  
ATOM    671  CB  VAL A  43      -2.108  -0.164  -3.691  0.00  0.34           C  
ATOM    672  CG1 VAL A  43      -1.736   0.343  -2.306  0.00  1.23           C  
ATOM    673  CG2 VAL A  43      -1.804  -1.650  -3.821  0.00  1.41           C  
ATOM    674  H   VAL A  43      -3.926   1.828  -2.791  0.00  0.27           H  
ATOM    675  HA  VAL A  43      -3.762  -0.057  -5.048  0.00  0.28           H  
ATOM    676  HB  VAL A  43      -1.506   0.368  -4.413  0.00  1.23           H  
ATOM    677 HG11 VAL A  43      -0.720   0.061  -2.081  0.00  1.88           H  
ATOM    678 HG12 VAL A  43      -1.823   1.420  -2.283  0.00  1.74           H  
ATOM    679 HG13 VAL A  43      -2.402  -0.088  -1.574  0.00  1.85           H  
ATOM    680 HG21 VAL A  43      -0.910  -1.784  -4.412  0.00  2.04           H  
ATOM    681 HG22 VAL A  43      -1.652  -2.074  -2.839  0.00  1.97           H  
ATOM    682 HG23 VAL A  43      -2.633  -2.145  -4.304  0.00  2.00           H  
ATOM    683  N   GLU A  44      -4.863  -1.932  -3.812  1.00  0.23           N  
ATOM    684  CA  GLU A  44      -5.709  -2.926  -3.157  1.00  0.25           C  
ATOM    685  C   GLU A  44      -4.871  -4.073  -2.603  1.00  0.23           C  
ATOM    686  O   GLU A  44      -3.939  -4.547  -3.256  0.00  0.28           O  
ATOM    687  CB  GLU A  44      -6.745  -3.468  -4.143  0.00  0.32           C  
ATOM    688  CG  GLU A  44      -7.523  -2.383  -4.871  0.00  0.93           C  
ATOM    689  CD  GLU A  44      -7.903  -2.784  -6.283  0.00  1.42           C  
ATOM    690  OE1 GLU A  44      -7.034  -2.700  -7.177  0.00  2.12           O  
ATOM    691  OE2 GLU A  44      -9.068  -3.181  -6.494  0.00  1.74           O  
ATOM    692  H   GLU A  44      -4.578  -2.086  -4.736  0.00  0.27           H  
ATOM    693  HA  GLU A  44      -6.220  -2.440  -2.341  0.00  0.27           H  
ATOM    694  HB2 GLU A  44      -6.240  -4.074  -4.881  0.00  0.69           H  
ATOM    695  HB3 GLU A  44      -7.448  -4.086  -3.605  0.00  0.75           H  
ATOM    696  HG2 GLU A  44      -8.427  -2.175  -4.316  0.00  1.52           H  
ATOM    697  HG3 GLU A  44      -6.917  -1.491  -4.915  0.00  1.48           H  
ATOM    698  N   LEU A  45      -5.209  -4.518  -1.396  1.00  0.26           N  
ATOM    699  CA  LEU A  45      -4.489  -5.613  -0.758  1.00  0.28           C  
ATOM    700  C   LEU A  45      -4.796  -6.938  -1.446  1.00  0.27           C  
ATOM    701  O   LEU A  45      -5.834  -7.552  -1.195  0.00  0.41           O  
ATOM    702  CB  LEU A  45      -4.855  -5.698   0.726  0.00  0.36           C  
ATOM    703  CG  LEU A  45      -4.450  -4.485   1.566  0.00  0.97           C  
ATOM    704  CD1 LEU A  45      -5.082  -4.556   2.947  0.00  1.52           C  
ATOM    705  CD2 LEU A  45      -2.935  -4.393   1.675  0.00  1.58           C  
ATOM    706  H   LEU A  45      -5.961  -4.101  -0.927  0.00  0.34           H  
ATOM    707  HA  LEU A  45      -3.431  -5.411  -0.845  0.00  0.29           H  
ATOM    708  HB2 LEU A  45      -5.926  -5.822   0.804  0.00  1.04           H  
ATOM    709  HB3 LEU A  45      -4.378  -6.572   1.144  0.00  0.97           H  
ATOM    710  HG  LEU A  45      -4.806  -3.586   1.083  0.00  1.36           H  
ATOM    711 HD11 LEU A  45      -6.157  -4.601   2.850  0.00  1.97           H  
ATOM    712 HD12 LEU A  45      -4.730  -5.440   3.459  0.00  1.90           H  
ATOM    713 HD13 LEU A  45      -4.807  -3.680   3.514  0.00  2.01           H  
ATOM    714 HD21 LEU A  45      -2.492  -4.595   0.710  0.00  2.05           H  
ATOM    715 HD22 LEU A  45      -2.656  -3.402   1.998  0.00  2.22           H  
ATOM    716 HD23 LEU A  45      -2.581  -5.118   2.392  0.00  1.84           H  
ATOM    717  N   THR A  46      -3.889  -7.372  -2.316  1.00  0.23           N  
ATOM    718  CA  THR A  46      -4.067  -8.623  -3.042  1.00  0.24           C  
ATOM    719  C   THR A  46      -3.792  -9.826  -2.145  1.00  0.25           C  
ATOM    720  O   THR A  46      -4.646 -10.695  -1.979  0.00  0.40           O  
ATOM    721  CB  THR A  46      -3.145  -8.693  -4.276  0.00  0.24           C  
ATOM    722  OG1 THR A  46      -1.773  -8.691  -3.867  0.00  0.37           O  
ATOM    723  CG2 THR A  46      -3.404  -7.521  -5.210  0.00  0.39           C  
ATOM    724  H   THR A  46      -3.083  -6.838  -2.473  0.00  0.31           H  
ATOM    725  HA  THR A  46      -5.092  -8.669  -3.382  0.00  0.26           H  
ATOM    726  HB  THR A  46      -3.353  -9.610  -4.810  0.00  0.29           H  
ATOM    727  HG1 THR A  46      -1.418  -9.579  -3.932  0.00  1.01           H  
ATOM    728 HG21 THR A  46      -2.463  -7.145  -5.583  0.00  1.14           H  
ATOM    729 HG22 THR A  46      -3.916  -6.738  -4.670  0.00  1.20           H  
ATOM    730 HG23 THR A  46      -4.015  -7.848  -6.038  0.00  0.98           H  
ATOM    731  N   LYS A  47      -2.593  -9.869  -1.570  1.00  0.22           N  
ATOM    732  CA  LYS A  47      -2.205 -10.966  -0.690  1.00  0.25           C  
ATOM    733  C   LYS A  47      -1.376 -10.456   0.486  1.00  0.21           C  
ATOM    734  O   LYS A  47      -0.340  -9.818   0.294  0.00  0.26           O  
ATOM    735  CB  LYS A  47      -1.412 -12.015  -1.471  0.00  0.36           C  
ATOM    736  CG  LYS A  47      -1.254 -13.334  -0.732  0.00  0.79           C  
ATOM    737  CD  LYS A  47      -0.959 -14.479  -1.690  0.00  1.06           C  
ATOM    738  CE  LYS A  47      -1.933 -15.628  -1.499  0.00  1.60           C  
ATOM    739  NZ  LYS A  47      -3.161 -15.459  -2.325  0.00  2.26           N  
ATOM    740  H   LYS A  47      -1.955  -9.147  -1.743  0.00  0.28           H  
ATOM    741  HA  LYS A  47      -3.108 -11.421  -0.309  0.00  0.30           H  
ATOM    742  HB2 LYS A  47      -1.916 -12.209  -2.407  0.00  0.66           H  
ATOM    743  HB3 LYS A  47      -0.427 -11.623  -1.679  0.00  0.59           H  
ATOM    744  HG2 LYS A  47      -0.438 -13.246  -0.030  0.00  1.32           H  
ATOM    745  HG3 LYS A  47      -2.169 -13.549  -0.200  0.00  1.29           H  
ATOM    746  HD2 LYS A  47      -1.036 -14.116  -2.703  0.00  1.53           H  
ATOM    747  HD3 LYS A  47       0.045 -14.835  -1.508  0.00  1.51           H  
ATOM    748  HE2 LYS A  47      -1.445 -16.549  -1.783  0.00  1.92           H  
ATOM    749  HE3 LYS A  47      -2.215 -15.678  -0.457  0.00  2.22           H  
ATOM    750  HZ1 LYS A  47      -3.658 -14.587  -2.052  0.00  2.69           H  
ATOM    751  HZ2 LYS A  47      -3.800 -16.266  -2.186  0.00  2.66           H  
ATOM    752  HZ3 LYS A  47      -2.908 -15.400  -3.334  0.00  2.69           H  
ATOM    753  N   ALA A  48      -1.839 -10.741   1.698  1.00  0.21           N  
ATOM    754  CA  ALA A  48      -1.140 -10.313   2.904  1.00  0.25           C  
ATOM    755  C   ALA A  48      -0.722 -11.511   3.751  1.00  0.22           C  
ATOM    756  O   ALA A  48      -1.452 -12.496   3.854  0.00  0.33           O  
ATOM    757  CB  ALA A  48      -2.019  -9.372   3.715  0.00  0.37           C  
ATOM    758  H   ALA A  48      -2.670 -11.254   1.784  0.00  0.26           H  
ATOM    759  HA  ALA A  48      -0.256  -9.771   2.602  0.00  0.28           H  
ATOM    760  HB1 ALA A  48      -2.952  -9.861   3.948  0.00  1.02           H  
ATOM    761  HB2 ALA A  48      -1.511  -9.108   4.632  0.00  1.21           H  
ATOM    762  HB3 ALA A  48      -2.213  -8.477   3.142  0.00  0.99           H  
ATOM    763  N   GLU A  49       0.461 -11.419   4.353  1.00  0.26           N  
ATOM    764  CA  GLU A  49       0.978 -12.496   5.190  1.00  0.28           C  
ATOM    765  C   GLU A  49       1.286 -11.996   6.597  1.00  0.30           C  
ATOM    766  O   GLU A  49       1.239 -10.795   6.865  0.00  0.32           O  
ATOM    767  CB  GLU A  49       2.237 -13.098   4.563  0.00  0.30           C  
ATOM    768  CG  GLU A  49       1.949 -14.241   3.602  0.00  0.60           C  
ATOM    769  CD  GLU A  49       1.794 -15.575   4.308  0.00  1.04           C  
ATOM    770  OE1 GLU A  49       1.776 -15.588   5.556  0.00  1.97           O  
ATOM    771  OE2 GLU A  49       1.691 -16.608   3.611  0.00  1.49           O  
ATOM    772  H   GLU A  49       0.997 -10.608   4.231  0.00  0.37           H  
ATOM    773  HA  GLU A  49       0.219 -13.260   5.252  0.00  0.31           H  
ATOM    774  HB2 GLU A  49       2.761 -12.325   4.021  0.00  0.41           H  
ATOM    775  HB3 GLU A  49       2.874 -13.471   5.350  0.00  0.51           H  
ATOM    776  HG2 GLU A  49       1.034 -14.024   3.070  0.00  1.26           H  
ATOM    777  HG3 GLU A  49       2.764 -14.315   2.897  0.00  1.14           H  
ATOM    778  N   ALA A  50       1.600 -12.925   7.494  1.00  0.33           N  
ATOM    779  CA  ALA A  50       1.914 -12.582   8.875  1.00  0.37           C  
ATOM    780  C   ALA A  50       3.382 -12.849   9.192  0.00  0.39           C  
ATOM    781  O   ALA A  50       4.040 -12.047   9.854  0.00  0.47           O  
ATOM    782  CB  ALA A  50       1.019 -13.359   9.828  0.00  0.43           C  
ATOM    783  H   ALA A  50       1.621 -13.867   7.219  0.00  0.34           H  
ATOM    784  HA  ALA A  50       1.714 -11.529   9.011  0.00  0.37           H  
ATOM    785  HB1 ALA A  50       1.618 -13.779  10.624  0.00  1.03           H  
ATOM    786  HB2 ALA A  50       0.276 -12.697  10.248  0.00  1.01           H  
ATOM    787  HB3 ALA A  50       0.527 -14.157   9.291  0.00  1.17           H  
ATOM    788  N   GLU A  51       3.889 -13.982   8.716  1.00  0.38           N  
ATOM    789  CA  GLU A  51       5.280 -14.355   8.951  0.00  0.41           C  
ATOM    790  C   GLU A  51       6.188 -13.818   7.847  1.00  0.37           C  
ATOM    791  O   GLU A  51       7.348 -14.214   7.738  0.00  0.40           O  
ATOM    792  CB  GLU A  51       5.414 -15.877   9.040  0.00  0.46           C  
ATOM    793  CG  GLU A  51       5.640 -16.386  10.455  0.00  1.43           C  
ATOM    794  CD  GLU A  51       6.516 -17.623  10.496  0.00  1.94           C  
ATOM    795  OE1 GLU A  51       6.090 -18.670   9.964  0.00  2.60           O  
ATOM    796  OE2 GLU A  51       7.627 -17.544  11.060  0.00  2.36           O  
ATOM    797  H   GLU A  51       3.315 -14.583   8.196  0.00  0.40           H  
ATOM    798  HA  GLU A  51       5.584 -13.922   9.892  0.00  0.44           H  
ATOM    799  HB2 GLU A  51       4.510 -16.330   8.658  0.00  1.07           H  
ATOM    800  HB3 GLU A  51       6.248 -16.190   8.430  0.00  1.03           H  
ATOM    801  HG2 GLU A  51       6.115 -15.608  11.033  0.00  2.09           H  
ATOM    802  HG3 GLU A  51       4.683 -16.626  10.894  0.00  2.07           H  
ATOM    803  N   HIS A  52       5.650 -12.915   7.032  1.00  0.35           N  
ATOM    804  CA  HIS A  52       6.413 -12.323   5.938  1.00  0.32           C  
ATOM    805  C   HIS A  52       6.565 -10.817   6.128  1.00  0.30           C  
ATOM    806  O   HIS A  52       5.601 -10.122   6.452  0.00  0.39           O  
ATOM    807  CB  HIS A  52       5.736 -12.614   4.597  0.00  0.29           C  
ATOM    808  CG  HIS A  52       5.981 -14.001   4.091  0.00  0.40           C  
ATOM    809  ND1 HIS A  52       6.962 -14.306   3.169  0.00  0.85           N  
ATOM    810  CD2 HIS A  52       5.367 -15.172   4.383  0.00  0.97           C  
ATOM    811  CE1 HIS A  52       6.940 -15.603   2.917  0.00  0.81           C  
ATOM    812  NE2 HIS A  52       5.982 -16.151   3.641  0.00  0.85           N  
ATOM    813  H   HIS A  52       4.720 -12.638   7.171  0.00  0.39           H  
ATOM    814  HA  HIS A  52       7.394 -12.774   5.939  0.00  0.35           H  
ATOM    815  HB2 HIS A  52       4.668 -12.483   4.705  0.00  0.32           H  
ATOM    816  HB3 HIS A  52       6.104 -11.919   3.857  0.00  0.38           H  
ATOM    817  HD1 HIS A  52       7.581 -13.665   2.760  0.00  1.41           H  
ATOM    818  HD2 HIS A  52       4.546 -15.311   5.074  0.00  1.63           H  
ATOM    819  HE1 HIS A  52       7.593 -16.125   2.235  0.00  1.21           H  
ATOM    820  HE2 HIS A  52       5.747 -17.102   3.644  0.00  1.22           H  
ATOM    821  N   ASN A  53       7.780 -10.318   5.920  1.00  0.28           N  
ATOM    822  CA  ASN A  53       8.059  -8.893   6.065  1.00  0.28           C  
ATOM    823  C   ASN A  53       7.727  -8.141   4.779  1.00  0.26           C  
ATOM    824  O   ASN A  53       8.002  -6.947   4.656  0.00  0.46           O  
ATOM    825  CB  ASN A  53       9.527  -8.672   6.434  0.00  0.32           C  
ATOM    826  CG  ASN A  53       9.828  -9.059   7.870  0.00  0.72           C  
ATOM    827  OD1 ASN A  53      10.757  -9.820   8.137  0.00  1.53           O  
ATOM    828  ND2 ASN A  53       9.040  -8.535   8.802  0.00  1.34           N  
ATOM    829  H   ASN A  53       8.507 -10.922   5.662  0.00  0.32           H  
ATOM    830  HA  ASN A  53       7.436  -8.513   6.862  0.00  0.31           H  
ATOM    831  HB2 ASN A  53      10.148  -9.268   5.782  0.00  0.55           H  
ATOM    832  HB3 ASN A  53       9.772  -7.628   6.303  0.00  0.56           H  
ATOM    833 HD21 ASN A  53       8.319  -7.936   8.514  0.00  1.96           H  
ATOM    834 HD22 ASN A  53       9.212  -8.768   9.737  0.00  1.55           H  
ATOM    835  N   TRP A  54       7.131  -8.849   3.823  1.00  0.21           N  
ATOM    836  CA  TRP A  54       6.757  -8.253   2.545  1.00  0.19           C  
ATOM    837  C   TRP A  54       5.322  -8.617   2.180  1.00  0.18           C  
ATOM    838  O   TRP A  54       4.861  -9.723   2.466  0.00  0.23           O  
ATOM    839  CB  TRP A  54       7.709  -8.720   1.444  0.00  0.23           C  
ATOM    840  CG  TRP A  54       9.113  -8.226   1.624  0.00  0.27           C  
ATOM    841  CD1 TRP A  54      10.083  -8.785   2.406  0.00  0.36           C  
ATOM    842  CD2 TRP A  54       9.704  -7.076   1.010  0.00  0.33           C  
ATOM    843  NE1 TRP A  54      11.241  -8.051   2.316  0.00  0.43           N  
ATOM    844  CE2 TRP A  54      11.035  -6.997   1.465  0.00  0.40           C  
ATOM    845  CE3 TRP A  54       9.239  -6.105   0.119  0.00  0.41           C  
ATOM    846  CZ2 TRP A  54      11.904  -5.988   1.059  0.00  0.49           C  
ATOM    847  CZ3 TRP A  54      10.103  -5.102  -0.283  0.00  0.53           C  
ATOM    848  CH2 TRP A  54      11.422  -5.050   0.186  0.00  0.54           C  
ATOM    849  H   TRP A  54       6.937  -9.796   3.982  0.00  0.35           H  
ATOM    850  HA  TRP A  54       6.830  -7.182   2.645  0.00  0.20           H  
ATOM    851  HB2 TRP A  54       7.734  -9.800   1.431  0.00  0.27           H  
ATOM    852  HB3 TRP A  54       7.349  -8.362   0.491  0.00  0.28           H  
ATOM    853  HD1 TRP A  54       9.945  -9.673   3.005  0.00  0.42           H  
ATOM    854  HE1 TRP A  54      12.080  -8.251   2.785  0.00  0.52           H  
ATOM    855  HE3 TRP A  54       8.227  -6.128  -0.255  0.00  0.44           H  
ATOM    856  HZ2 TRP A  54      12.922  -5.934   1.412  0.00  0.56           H  
ATOM    857  HZ3 TRP A  54       9.761  -4.343  -0.971  0.00  0.63           H  
ATOM    858  HH2 TRP A  54      12.061  -4.248  -0.154  0.00  0.64           H  
ATOM    859  N   TRP A  55       4.616  -7.682   1.552  1.00  0.18           N  
ATOM    860  CA  TRP A  55       3.231  -7.911   1.153  1.00  0.18           C  
ATOM    861  C   TRP A  55       3.023  -7.589  -0.321  1.00  0.21           C  
ATOM    862  O   TRP A  55       3.783  -6.824  -0.914  0.00  0.35           O  
ATOM    863  CB  TRP A  55       2.288  -7.066   2.012  0.00  0.18           C  
ATOM    864  CG  TRP A  55       2.377  -7.376   3.476  0.00  0.17           C  
ATOM    865  CD1 TRP A  55       1.539  -8.179   4.196  0.00  0.20           C  
ATOM    866  CD2 TRP A  55       3.358  -6.891   4.399  0.00  0.19           C  
ATOM    867  NE1 TRP A  55       1.938  -8.220   5.510  0.00  0.20           N  
ATOM    868  CE2 TRP A  55       3.052  -7.437   5.660  0.00  0.20           C  
ATOM    869  CE3 TRP A  55       4.465  -6.045   4.283  0.00  0.24           C  
ATOM    870  CZ2 TRP A  55       3.814  -7.166   6.794  0.00  0.25           C  
ATOM    871  CZ3 TRP A  55       5.220  -5.778   5.409  0.00  0.31           C  
ATOM    872  CH2 TRP A  55       4.892  -6.337   6.650  0.00  0.31           C  
ATOM    873  H   TRP A  55       5.035  -6.817   1.350  0.00  0.23           H  
ATOM    874  HA  TRP A  55       3.011  -8.955   1.313  0.00  0.18           H  
ATOM    875  HB2 TRP A  55       2.528  -6.022   1.878  0.00  0.21           H  
ATOM    876  HB3 TRP A  55       1.270  -7.239   1.695  0.00  0.20           H  
ATOM    877  HD1 TRP A  55       0.689  -8.699   3.780  0.00  0.24           H  
ATOM    878  HE1 TRP A  55       1.496  -8.727   6.223  0.00  0.22           H  
ATOM    879  HE3 TRP A  55       4.735  -5.605   3.335  0.00  0.26           H  
ATOM    880  HZ2 TRP A  55       3.573  -7.590   7.757  0.00  0.26           H  
ATOM    881  HZ3 TRP A  55       6.080  -5.128   5.339  0.00  0.37           H  
ATOM    882  HH2 TRP A  55       5.510  -6.100   7.504  0.00  0.36           H  
ATOM    883  N   GLU A  56       1.990  -8.183  -0.911  1.00  0.19           N  
ATOM    884  CA  GLU A  56       1.684  -7.962  -2.321  1.00  0.21           C  
ATOM    885  C   GLU A  56       0.414  -7.134  -2.483  1.00  0.20           C  
ATOM    886  O   GLU A  56      -0.528  -7.262  -1.701  0.00  0.22           O  
ATOM    887  CB  GLU A  56       1.532  -9.298  -3.048  0.00  0.24           C  
ATOM    888  CG  GLU A  56       2.281  -9.359  -4.368  0.00  0.33           C  
ATOM    889  CD  GLU A  56       1.459  -9.985  -5.478  0.00  0.97           C  
ATOM    890  OE1 GLU A  56       0.457  -9.368  -5.896  0.00  1.56           O  
ATOM    891  OE2 GLU A  56       1.819 -11.093  -5.929  0.00  1.46           O  
ATOM    892  H   GLU A  56       1.422  -8.785  -0.388  0.00  0.27           H  
ATOM    893  HA  GLU A  56       2.510  -7.419  -2.756  0.00  0.22           H  
ATOM    894  HB2 GLU A  56       1.906 -10.088  -2.410  0.00  0.27           H  
ATOM    895  HB3 GLU A  56       0.485  -9.472  -3.244  0.00  0.28           H  
ATOM    896  HG2 GLU A  56       2.547  -8.355  -4.661  0.00  0.61           H  
ATOM    897  HG3 GLU A  56       3.179  -9.943  -4.233  0.00  0.65           H  
ATOM    898  N   GLY A  57       0.397  -6.285  -3.507  1.00  0.19           N  
ATOM    899  CA  GLY A  57      -0.761  -5.446  -3.762  1.00  0.21           C  
ATOM    900  C   GLY A  57      -0.940  -5.146  -5.238  1.00  0.23           C  
ATOM    901  O   GLY A  57      -0.147  -5.593  -6.066  0.00  0.38           O  
ATOM    902  H   GLY A  57       1.178  -6.228  -4.097  0.00  0.19           H  
ATOM    903  HA2 GLY A  57      -1.643  -5.949  -3.398  0.00  0.22           H  
ATOM    904  HA3 GLY A  57      -0.642  -4.515  -3.228  0.00  0.23           H  
ATOM    905  N   ARG A  58      -1.983  -4.390  -5.570  1.00  0.19           N  
ATOM    906  CA  ARG A  58      -2.257  -4.037  -6.961  1.00  0.20           C  
ATOM    907  C   ARG A  58      -2.634  -2.565  -7.091  1.00  0.21           C  
ATOM    908  O   ARG A  58      -3.654  -2.124  -6.561  0.00  0.26           O  
ATOM    909  CB  ARG A  58      -3.378  -4.913  -7.522  0.00  0.24           C  
ATOM    910  CG  ARG A  58      -3.760  -4.572  -8.954  0.00  0.30           C  
ATOM    911  CD  ARG A  58      -4.777  -5.557  -9.507  0.00  0.41           C  
ATOM    912  NE  ARG A  58      -5.972  -5.637  -8.672  0.00  1.19           N  
ATOM    913  CZ  ARG A  58      -6.559  -6.779  -8.330  0.00  1.73           C  
ATOM    914  NH1 ARG A  58      -6.062  -7.936  -8.751  0.00  1.89           N  
ATOM    915  NH2 ARG A  58      -7.642  -6.769  -7.567  0.00  2.65           N  
ATOM    916  H   ARG A  58      -2.580  -4.062  -4.866  0.00  0.24           H  
ATOM    917  HA  ARG A  58      -1.356  -4.215  -7.529  0.00  0.22           H  
ATOM    918  HB2 ARG A  58      -3.063  -5.946  -7.493  0.00  0.26           H  
ATOM    919  HB3 ARG A  58      -4.255  -4.797  -6.902  0.00  0.28           H  
ATOM    920  HG2 ARG A  58      -4.185  -3.580  -8.977  0.00  0.43           H  
ATOM    921  HG3 ARG A  58      -2.872  -4.601  -9.569  0.00  0.36           H  
ATOM    922  HD2 ARG A  58      -5.063  -5.239 -10.500  0.00  0.94           H  
ATOM    923  HD3 ARG A  58      -4.321  -6.535  -9.562  0.00  1.02           H  
ATOM    924  HE  ARG A  58      -6.357  -4.795  -8.349  0.00  1.77           H  
ATOM    925 HH11 ARG A  58      -5.245  -7.949  -9.327  0.00  1.78           H  
ATOM    926 HH12 ARG A  58      -6.506  -8.794  -8.491  0.00  2.50           H  
ATOM    927 HH21 ARG A  58      -8.019  -5.899  -7.247  0.00  3.06           H  
ATOM    928 HH22 ARG A  58      -8.083  -7.629  -7.312  0.00  3.10           H  
ATOM    929  N   ASN A  59      -1.807  -1.811  -7.809  1.00  0.20           N  
ATOM    930  CA  ASN A  59      -2.052  -0.390  -8.020  1.00  0.23           C  
ATOM    931  C   ASN A  59      -3.128  -0.180  -9.083  1.00  0.25           C  
ATOM    932  O   ASN A  59      -3.122  -0.839 -10.121  0.00  0.30           O  
ATOM    933  CB  ASN A  59      -0.760   0.310  -8.441  0.00  0.29           C  
ATOM    934  CG  ASN A  59      -0.736   1.774  -8.047  0.00  0.62           C  
ATOM    935  OD1 ASN A  59      -1.763   2.452  -8.069  0.00  1.23           O  
ATOM    936  ND2 ASN A  59       0.442   2.269  -7.683  0.00  0.64           N  
ATOM    937  H   ASN A  59      -1.014  -2.223  -8.210  0.00  0.22           H  
ATOM    938  HA  ASN A  59      -2.394   0.032  -7.087  0.00  0.24           H  
ATOM    939  HB2 ASN A  59       0.078  -0.181  -7.968  0.00  0.54           H  
ATOM    940  HB3 ASN A  59      -0.653   0.242  -9.514  0.00  0.68           H  
ATOM    941 HD21 ASN A  59       1.217   1.670  -7.690  0.00  0.67           H  
ATOM    942 HD22 ASN A  59       0.487   3.214  -7.426  0.00  0.98           H  
ATOM    943  N   THR A  60      -4.050   0.740  -8.813  1.00  0.28           N  
ATOM    944  CA  THR A  60      -5.132   1.032  -9.748  1.00  0.33           C  
ATOM    945  C   THR A  60      -4.668   1.985 -10.843  1.00  0.35           C  
ATOM    946  O   THR A  60      -5.340   2.152 -11.861  0.00  0.46           O  
ATOM    947  CB  THR A  60      -6.347   1.648  -9.029  0.00  0.39           C  
ATOM    948  OG1 THR A  60      -7.379   1.943  -9.978  0.00  1.28           O  
ATOM    949  CG2 THR A  60      -5.954   2.919  -8.291  0.00  1.28           C  
ATOM    950  H   THR A  60      -4.002   1.233  -7.968  0.00  0.30           H  
ATOM    951  HA  THR A  60      -5.441   0.102 -10.201  0.00  0.35           H  
ATOM    952  HB  THR A  60      -6.721   0.934  -8.311  0.00  1.00           H  
ATOM    953  HG1 THR A  60      -7.730   1.123 -10.335  0.00  1.73           H  
ATOM    954 HG21 THR A  60      -6.424   3.769  -8.764  0.00  1.80           H  
ATOM    955 HG22 THR A  60      -4.881   3.036  -8.322  0.00  1.80           H  
ATOM    956 HG23 THR A  60      -6.280   2.854  -7.263  0.00  1.97           H  
ATOM    957  N   ALA A  61      -3.515   2.609 -10.627  1.00  0.34           N  
ATOM    958  CA  ALA A  61      -2.961   3.548 -11.593  0.00  0.40           C  
ATOM    959  C   ALA A  61      -2.120   2.829 -12.644  1.00  0.35           C  
ATOM    960  O   ALA A  61      -2.186   3.151 -13.830  0.00  0.42           O  
ATOM    961  CB  ALA A  61      -2.129   4.603 -10.880  0.00  0.52           C  
ATOM    962  H   ALA A  61      -3.028   2.435  -9.795  0.00  0.37           H  
ATOM    963  HA  ALA A  61      -3.785   4.045 -12.084  0.00  0.46           H  
ATOM    964  HB1 ALA A  61      -2.783   5.359 -10.470  0.00  1.30           H  
ATOM    965  HB2 ALA A  61      -1.567   4.140 -10.083  0.00  1.03           H  
ATOM    966  HB3 ALA A  61      -1.447   5.059 -11.584  0.00  1.09           H  
ATOM    967  N   THR A  62      -1.331   1.856 -12.199  1.00  0.30           N  
ATOM    968  CA  THR A  62      -0.473   1.095 -13.100  1.00  0.31           C  
ATOM    969  C   THR A  62      -1.122  -0.228 -13.498  1.00  0.26           C  
ATOM    970  O   THR A  62      -0.694  -0.878 -14.452  0.00  0.29           O  
ATOM    971  CB  THR A  62       0.897   0.807 -12.459  0.00  0.37           C  
ATOM    972  OG1 THR A  62       1.051   1.583 -11.264  0.00  0.79           O  
ATOM    973  CG2 THR A  62       2.024   1.128 -13.428  0.00  0.80           C  
ATOM    974  H   THR A  62      -1.321   1.648 -11.242  0.00  0.33           H  
ATOM    975  HA  THR A  62      -0.314   1.686 -13.990  0.00  0.35           H  
ATOM    976  HB  THR A  62       0.948  -0.242 -12.207  0.00  0.79           H  
ATOM    977  HG1 THR A  62       1.246   1.000 -10.527  0.00  1.34           H  
ATOM    978 HG21 THR A  62       2.856   0.464 -13.246  0.00  1.35           H  
ATOM    979 HG22 THR A  62       2.343   2.151 -13.285  0.00  1.34           H  
ATOM    980 HG23 THR A  62       1.676   0.999 -14.442  0.00  1.47           H  
ATOM    981  N   ASN A  63      -2.160  -0.619 -12.759  1.00  0.23           N  
ATOM    982  CA  ASN A  63      -2.872  -1.864 -13.031  1.00  0.23           C  
ATOM    983  C   ASN A  63      -1.921  -3.056 -13.014  1.00  0.23           C  
ATOM    984  O   ASN A  63      -2.008  -3.947 -13.860  0.00  0.31           O  
ATOM    985  CB  ASN A  63      -3.588  -1.784 -14.382  0.00  0.28           C  
ATOM    986  CG  ASN A  63      -4.858  -2.611 -14.413  0.00  0.75           C  
ATOM    987  OD1 ASN A  63      -4.955  -3.594 -15.146  0.00  1.47           O  
ATOM    988  ND2 ASN A  63      -5.841  -2.216 -13.613  0.00  1.49           N  
ATOM    989  H   ASN A  63      -2.452  -0.055 -12.014  0.00  0.23           H  
ATOM    990  HA  ASN A  63      -3.610  -1.999 -12.253  0.00  0.24           H  
ATOM    991  HB2 ASN A  63      -3.846  -0.756 -14.586  0.00  0.53           H  
ATOM    992  HB3 ASN A  63      -2.925  -2.146 -15.154  0.00  0.52           H  
ATOM    993 HD21 ASN A  63      -5.695  -1.423 -13.054  0.00  2.07           H  
ATOM    994 HD22 ASN A  63      -6.673  -2.734 -13.612  0.00  1.79           H  
ATOM    995  N   GLU A  64      -1.013  -3.068 -12.044  1.00  0.21           N  
ATOM    996  CA  GLU A  64      -0.044  -4.151 -11.913  1.00  0.21           C  
ATOM    997  C   GLU A  64       0.182  -4.499 -10.446  1.00  0.19           C  
ATOM    998  O   GLU A  64      -0.051  -3.677  -9.561  0.00  0.18           O  
ATOM    999  CB  GLU A  64       1.282  -3.761 -12.572  0.00  0.26           C  
ATOM   1000  CG  GLU A  64       1.891  -4.870 -13.412  0.00  0.50           C  
ATOM   1001  CD  GLU A  64       2.263  -4.407 -14.807  0.00  1.21           C  
ATOM   1002  OE1 GLU A  64       3.150  -3.538 -14.928  0.00  1.67           O  
ATOM   1003  OE2 GLU A  64       1.667  -4.916 -15.780  0.00  1.99           O  
ATOM   1004  H   GLU A  64      -0.994  -2.331 -11.398  0.00  0.25           H  
ATOM   1005  HA  GLU A  64      -0.446  -5.017 -12.418  0.00  0.24           H  
ATOM   1006  HB2 GLU A  64       1.114  -2.905 -13.209  0.00  0.40           H  
ATOM   1007  HB3 GLU A  64       1.988  -3.492 -11.800  0.00  0.42           H  
ATOM   1008  HG2 GLU A  64       2.784  -5.229 -12.920  0.00  1.04           H  
ATOM   1009  HG3 GLU A  64       1.177  -5.677 -13.495  0.00  1.05           H  
ATOM   1010  N   VAL A  65       0.632  -5.725 -10.194  1.00  0.20           N  
ATOM   1011  CA  VAL A  65       0.883  -6.178  -8.829  1.00  0.19           C  
ATOM   1012  C   VAL A  65       2.377  -6.218  -8.524  1.00  0.20           C  
ATOM   1013  O   VAL A  65       3.198  -6.460  -9.410  0.00  0.25           O  
ATOM   1014  CB  VAL A  65       0.275  -7.573  -8.578  0.00  0.24           C  
ATOM   1015  CG1 VAL A  65      -1.201  -7.589  -8.946  0.00  0.95           C  
ATOM   1016  CG2 VAL A  65       1.032  -8.642  -9.352  0.00  1.08           C  
ATOM   1017  H   VAL A  65       0.797  -6.338 -10.940  0.00  0.23           H  
ATOM   1018  HA  VAL A  65       0.409  -5.479  -8.156  0.00  0.19           H  
ATOM   1019  HB  VAL A  65       0.360  -7.795  -7.524  0.00  0.76           H  
ATOM   1020 HG11 VAL A  65      -1.637  -6.623  -8.729  0.00  1.59           H  
ATOM   1021 HG12 VAL A  65      -1.308  -7.802  -9.999  0.00  1.61           H  
ATOM   1022 HG13 VAL A  65      -1.708  -8.349  -8.371  0.00  1.42           H  
ATOM   1023 HG21 VAL A  65       1.532  -9.302  -8.657  0.00  1.73           H  
ATOM   1024 HG22 VAL A  65       0.339  -9.212  -9.953  0.00  1.59           H  
ATOM   1025 HG23 VAL A  65       1.763  -8.174  -9.994  0.00  1.63           H  
ATOM   1026  N   GLY A  66       2.722  -5.976  -7.262  1.00  0.18           N  
ATOM   1027  CA  GLY A  66       4.116  -5.986  -6.856  1.00  0.21           C  
ATOM   1028  C   GLY A  66       4.283  -6.169  -5.360  1.00  0.21           C  
ATOM   1029  O   GLY A  66       3.307  -6.134  -4.611  0.00  0.32           O  
ATOM   1030  H   GLY A  66       2.024  -5.787  -6.602  0.00  0.18           H  
ATOM   1031  HA2 GLY A  66       4.621  -6.793  -7.365  0.00  0.25           H  
ATOM   1032  HA3 GLY A  66       4.571  -5.050  -7.146  0.00  0.24           H  
ATOM   1033  N   TRP A  67       5.523  -6.366  -4.924  1.00  0.21           N  
ATOM   1034  CA  TRP A  67       5.818  -6.557  -3.509  1.00  0.21           C  
ATOM   1035  C   TRP A  67       6.341  -5.267  -2.882  1.00  0.23           C  
ATOM   1036  O   TRP A  67       7.146  -4.557  -3.482  0.00  0.30           O  
ATOM   1037  CB  TRP A  67       6.838  -7.683  -3.325  0.00  0.24           C  
ATOM   1038  CG  TRP A  67       6.268  -9.045  -3.578  0.00  0.23           C  
ATOM   1039  CD1 TRP A  67       6.267  -9.728  -4.761  0.00  0.28           C  
ATOM   1040  CD2 TRP A  67       5.612  -9.892  -2.625  0.00  0.23           C  
ATOM   1041  NE1 TRP A  67       5.650 -10.945  -4.602  0.00  0.29           N  
ATOM   1042  CE2 TRP A  67       5.239 -11.070  -3.300  0.00  0.26           C  
ATOM   1043  CE3 TRP A  67       5.305  -9.769  -1.269  0.00  0.27           C  
ATOM   1044  CZ2 TRP A  67       4.576 -12.115  -2.664  0.00  0.30           C  
ATOM   1045  CZ3 TRP A  67       4.645 -10.806  -0.637  0.00  0.33           C  
ATOM   1046  CH2 TRP A  67       4.287 -11.967  -1.334  0.00  0.34           C  
ATOM   1047  H   TRP A  67       6.261  -6.383  -5.571  0.00  0.31           H  
ATOM   1048  HA  TRP A  67       4.898  -6.835  -3.015  0.00  0.19           H  
ATOM   1049  HB2 TRP A  67       7.656  -7.531  -4.013  0.00  0.27           H  
ATOM   1050  HB3 TRP A  67       7.215  -7.658  -2.313  0.00  0.27           H  
ATOM   1051  HD1 TRP A  67       6.692  -9.352  -5.680  0.00  0.34           H  
ATOM   1052  HE1 TRP A  67       5.524 -11.615  -5.307  0.00  0.34           H  
ATOM   1053  HE3 TRP A  67       5.573  -8.882  -0.713  0.00  0.29           H  
ATOM   1054  HZ2 TRP A  67       4.293 -13.017  -3.186  0.00  0.34           H  
ATOM   1055  HZ3 TRP A  67       4.399 -10.728   0.412  0.00  0.40           H  
ATOM   1056  HH2 TRP A  67       3.771 -12.752  -0.800  0.00  0.40           H  
ATOM   1057  N   PHE A  68       5.874  -4.973  -1.670  1.00  0.19           N  
ATOM   1058  CA  PHE A  68       6.290  -3.771  -0.959  1.00  0.22           C  
ATOM   1059  C   PHE A  68       5.848  -3.824   0.505  1.00  0.19           C  
ATOM   1060  O   PHE A  68       4.910  -4.546   0.850  0.00  0.17           O  
ATOM   1061  CB  PHE A  68       5.711  -2.524  -1.638  0.00  0.27           C  
ATOM   1062  CG  PHE A  68       4.213  -2.536  -1.749  0.00  0.26           C  
ATOM   1063  CD1 PHE A  68       3.589  -3.138  -2.830  0.00  0.28           C  
ATOM   1064  CD2 PHE A  68       3.428  -1.943  -0.773  0.00  0.38           C  
ATOM   1065  CE1 PHE A  68       2.211  -3.149  -2.936  0.00  0.35           C  
ATOM   1066  CE2 PHE A  68       2.050  -1.951  -0.873  0.00  0.46           C  
ATOM   1067  CZ  PHE A  68       1.441  -2.555  -1.955  0.00  0.42           C  
ATOM   1068  H   PHE A  68       5.234  -5.581  -1.246  0.00  0.17           H  
ATOM   1069  HA  PHE A  68       7.369  -3.721  -0.995  0.00  0.27           H  
ATOM   1070  HB2 PHE A  68       5.993  -1.651  -1.069  0.00  0.35           H  
ATOM   1071  HB3 PHE A  68       6.120  -2.445  -2.635  0.00  0.30           H  
ATOM   1072  HD1 PHE A  68       4.192  -3.604  -3.596  0.00  0.34           H  
ATOM   1073  HD2 PHE A  68       3.902  -1.470   0.074  0.00  0.47           H  
ATOM   1074  HE1 PHE A  68       1.739  -3.622  -3.784  0.00  0.43           H  
ATOM   1075  HE2 PHE A  68       1.449  -1.485  -0.105  0.00  0.59           H  
ATOM   1076  HZ  PHE A  68       0.363  -2.562  -2.036  0.00  0.51           H  
ATOM   1077  N   PRO A  69       6.522  -3.064   1.391  1.00  0.23           N  
ATOM   1078  CA  PRO A  69       6.195  -3.033   2.820  1.00  0.23           C  
ATOM   1079  C   PRO A  69       4.870  -2.333   3.096  1.00  0.22           C  
ATOM   1080  O   PRO A  69       4.505  -1.377   2.410  0.00  0.24           O  
ATOM   1081  CB  PRO A  69       7.354  -2.242   3.449  0.00  0.29           C  
ATOM   1082  CG  PRO A  69       8.393  -2.125   2.382  0.00  0.33           C  
ATOM   1083  CD  PRO A  69       7.655  -2.184   1.077  0.00  0.31           C  
ATOM   1084  HA  PRO A  69       6.168  -4.028   3.239  0.00  0.24           H  
ATOM   1085  HB2 PRO A  69       6.998  -1.270   3.759  0.00  0.31           H  
ATOM   1086  HB3 PRO A  69       7.731  -2.778   4.307  0.00  0.31           H  
ATOM   1087  HG2 PRO A  69       8.911  -1.183   2.476  0.00  0.38           H  
ATOM   1088  HG3 PRO A  69       9.089  -2.947   2.456  0.00  0.35           H  
ATOM   1089  HD2 PRO A  69       7.316  -1.200   0.789  0.00  0.35           H  
ATOM   1090  HD3 PRO A  69       8.278  -2.614   0.308  0.00  0.34           H  
ATOM   1091  N   CYS A  70       4.151  -2.814   4.107  1.00  0.24           N  
ATOM   1092  CA  CYS A  70       2.865  -2.236   4.479  1.00  0.27           C  
ATOM   1093  C   CYS A  70       3.050  -0.918   5.225  1.00  0.27           C  
ATOM   1094  O   CYS A  70       2.179  -0.050   5.195  0.00  0.30           O  
ATOM   1095  CB  CYS A  70       2.077  -3.218   5.349  0.00  0.33           C  
ATOM   1096  SG  CYS A  70       0.413  -3.575   4.736  0.00  1.06           S  
ATOM   1097  H   CYS A  70       4.497  -3.576   4.617  0.00  0.27           H  
ATOM   1098  HA  CYS A  70       2.310  -2.049   3.572  0.00  0.28           H  
ATOM   1099  HB2 CYS A  70       2.614  -4.152   5.402  0.00  0.63           H  
ATOM   1100  HB3 CYS A  70       1.980  -2.807   6.343  0.00  0.54           H  
ATOM   1101  HG  CYS A  70      -0.365  -2.547   5.046  0.00  1.71           H  
ATOM   1102  N   ASN A  71       4.189  -0.780   5.898  1.00  0.29           N  
ATOM   1103  CA  ASN A  71       4.485   0.431   6.657  1.00  0.33           C  
ATOM   1104  C   ASN A  71       4.789   1.603   5.731  1.00  0.32           C  
ATOM   1105  O   ASN A  71       4.503   2.756   6.059  0.00  0.37           O  
ATOM   1106  CB  ASN A  71       5.670   0.195   7.599  0.00  0.41           C  
ATOM   1107  CG  ASN A  71       6.585  -0.914   7.117  0.00  1.27           C  
ATOM   1108  OD1 ASN A  71       6.497  -2.053   7.578  0.00  2.07           O  
ATOM   1109  ND2 ASN A  71       7.472  -0.586   6.184  0.00  1.98           N  
ATOM   1110  H   ASN A  71       4.841  -1.509   5.886  0.00  0.30           H  
ATOM   1111  HA  ASN A  71       3.615   0.671   7.247  0.00  0.34           H  
ATOM   1112  HB2 ASN A  71       6.247   1.103   7.676  0.00  0.97           H  
ATOM   1113  HB3 ASN A  71       5.294  -0.072   8.576  0.00  1.02           H  
ATOM   1114 HD21 ASN A  71       7.487   0.339   5.864  0.00  2.20           H  
ATOM   1115 HD22 ASN A  71       8.075  -1.285   5.855  0.00  2.65           H  
ATOM   1116  N   ARG A  72       5.369   1.304   4.573  1.00  0.31           N  
ATOM   1117  CA  ARG A  72       5.713   2.337   3.602  1.00  0.35           C  
ATOM   1118  C   ARG A  72       4.463   3.029   3.067  1.00  0.32           C  
ATOM   1119  O   ARG A  72       4.549   4.081   2.432  0.00  0.42           O  
ATOM   1120  CB  ARG A  72       6.510   1.730   2.445  0.00  0.38           C  
ATOM   1121  CG  ARG A  72       8.015   1.815   2.634  0.00  0.48           C  
ATOM   1122  CD  ARG A  72       8.543   3.202   2.297  0.00  0.79           C  
ATOM   1123  NE  ARG A  72       8.651   4.049   3.482  0.00  1.54           N  
ATOM   1124  CZ  ARG A  72       9.472   5.093   3.569  0.00  1.86           C  
ATOM   1125  NH1 ARG A  72      10.255   5.415   2.547  0.00  2.01           N  
ATOM   1126  NH2 ARG A  72       9.510   5.816   4.680  0.00  2.58           N  
ATOM   1127  H   ARG A  72       5.574   0.369   4.369  0.00  0.30           H  
ATOM   1128  HA  ARG A  72       6.329   3.070   4.103  0.00  0.40           H  
ATOM   1129  HB2 ARG A  72       6.239   0.689   2.344  0.00  0.53           H  
ATOM   1130  HB3 ARG A  72       6.252   2.250   1.534  0.00  0.38           H  
ATOM   1131  HG2 ARG A  72       8.253   1.590   3.662  0.00  0.51           H  
ATOM   1132  HG3 ARG A  72       8.491   1.092   1.987  0.00  0.66           H  
ATOM   1133  HD2 ARG A  72       9.519   3.101   1.847  0.00  0.91           H  
ATOM   1134  HD3 ARG A  72       7.867   3.667   1.594  0.00  1.00           H  
ATOM   1135  HE  ARG A  72       8.085   3.831   4.251  0.00  2.13           H  
ATOM   1136 HH11 ARG A  72      10.228   4.873   1.708  0.00  1.93           H  
ATOM   1137 HH12 ARG A  72      10.869   6.200   2.617  0.00  2.56           H  
ATOM   1138 HH21 ARG A  72       8.923   5.576   5.454  0.00  3.02           H  
ATOM   1139 HH22 ARG A  72      10.127   6.601   4.744  0.00  2.88           H  
ATOM   1140  N   VAL A  73       3.301   2.437   3.328  1.00  0.24           N  
ATOM   1141  CA  VAL A  73       2.037   3.002   2.869  1.00  0.24           C  
ATOM   1142  C   VAL A  73       1.062   3.190   4.026  1.00  0.20           C  
ATOM   1143  O   VAL A  73       1.246   2.628   5.106  0.00  0.21           O  
ATOM   1144  CB  VAL A  73       1.377   2.111   1.800  0.00  0.28           C  
ATOM   1145  CG1 VAL A  73       2.232   2.060   0.544  0.00  0.33           C  
ATOM   1146  CG2 VAL A  73       1.131   0.712   2.343  0.00  0.30           C  
ATOM   1147  H   VAL A  73       3.294   1.601   3.839  0.00  0.21           H  
ATOM   1148  HA  VAL A  73       2.244   3.965   2.426  0.00  0.28           H  
ATOM   1149  HB  VAL A  73       0.422   2.545   1.539  0.00  0.33           H  
ATOM   1150 HG11 VAL A  73       2.098   2.970  -0.022  0.00  1.11           H  
ATOM   1151 HG12 VAL A  73       3.271   1.959   0.821  0.00  0.99           H  
ATOM   1152 HG13 VAL A  73       1.937   1.214  -0.059  0.00  1.08           H  
ATOM   1153 HG21 VAL A  73       2.028   0.348   2.821  0.00  1.07           H  
ATOM   1154 HG22 VAL A  73       0.326   0.742   3.065  0.00  0.98           H  
ATOM   1155 HG23 VAL A  73       0.861   0.052   1.532  0.00  1.05           H  
ATOM   1156  N   HIS A  74       0.025   3.986   3.789  1.00  0.21           N  
ATOM   1157  CA  HIS A  74      -0.985   4.253   4.807  1.00  0.21           C  
ATOM   1158  C   HIS A  74      -2.390   4.078   4.227  1.00  0.21           C  
ATOM   1159  O   HIS A  74      -2.670   4.534   3.120  0.00  0.31           O  
ATOM   1160  CB  HIS A  74      -0.804   5.672   5.364  0.00  0.24           C  
ATOM   1161  CG  HIS A  74      -2.071   6.306   5.852  0.00  1.09           C  
ATOM   1162  ND1 HIS A  74      -2.692   5.944   7.027  0.00  2.19           N  
ATOM   1163  CD2 HIS A  74      -2.833   7.288   5.313  0.00  1.60           C  
ATOM   1164  CE1 HIS A  74      -3.781   6.674   7.192  0.00  2.90           C  
ATOM   1165  NE2 HIS A  74      -3.888   7.498   6.166  0.00  2.50           N  
ATOM   1166  H   HIS A  74      -0.065   4.404   2.907  0.00  0.26           H  
ATOM   1167  HA  HIS A  74      -0.846   3.541   5.607  0.00  0.23           H  
ATOM   1168  HB2 HIS A  74      -0.112   5.639   6.192  0.00  0.86           H  
ATOM   1169  HB3 HIS A  74      -0.395   6.303   4.587  0.00  0.90           H  
ATOM   1170  HD1 HIS A  74      -2.382   5.252   7.649  0.00  2.60           H  
ATOM   1171  HD2 HIS A  74      -2.643   7.806   4.383  0.00  1.84           H  
ATOM   1172  HE1 HIS A  74      -4.466   6.609   8.024  0.00  3.84           H  
ATOM   1173  HE2 HIS A  74      -4.552   8.213   6.083  0.00  2.99           H  
ATOM   1174  N   PRO A  75      -3.295   3.412   4.970  1.00  0.30           N  
ATOM   1175  CA  PRO A  75      -4.672   3.178   4.519  1.00  0.34           C  
ATOM   1176  C   PRO A  75      -5.382   4.468   4.122  1.00  0.28           C  
ATOM   1177  O   PRO A  75      -5.335   5.464   4.844  0.00  0.40           O  
ATOM   1178  CB  PRO A  75      -5.359   2.538   5.735  0.00  0.49           C  
ATOM   1179  CG  PRO A  75      -4.433   2.762   6.883  0.00  0.72           C  
ATOM   1180  CD  PRO A  75      -3.053   2.833   6.298  0.00  0.49           C  
ATOM   1181  HA  PRO A  75      -4.698   2.489   3.687  0.00  0.38           H  
ATOM   1182  HB2 PRO A  75      -6.314   3.016   5.902  0.00  0.70           H  
ATOM   1183  HB3 PRO A  75      -5.508   1.484   5.550  0.00  0.73           H  
ATOM   1184  HG2 PRO A  75      -4.676   3.691   7.377  0.00  1.10           H  
ATOM   1185  HG3 PRO A  75      -4.502   1.938   7.578  0.00  1.09           H  
ATOM   1186  HD2 PRO A  75      -2.420   3.476   6.893  0.00  0.60           H  
ATOM   1187  HD3 PRO A  75      -2.623   1.845   6.217  0.00  0.62           H  
ATOM   1188  N   TYR A  76      -6.036   4.442   2.964  1.00  0.27           N  
ATOM   1189  CA  TYR A  76      -6.755   5.606   2.460  1.00  0.27           C  
ATOM   1190  C   TYR A  76      -7.977   5.911   3.322  0.00  0.42           C  
ATOM   1191  O   TYR A  76      -8.251   7.069   3.640  0.00  0.66           O  
ATOM   1192  CB  TYR A  76      -7.180   5.369   1.009  0.00  0.39           C  
ATOM   1193  CG  TYR A  76      -8.002   6.495   0.420  0.00  0.53           C  
ATOM   1194  CD1 TYR A  76      -7.430   7.734   0.163  0.00  0.61           C  
ATOM   1195  CD2 TYR A  76      -9.348   6.320   0.124  0.00  0.72           C  
ATOM   1196  CE1 TYR A  76      -8.176   8.767  -0.371  0.00  0.80           C  
ATOM   1197  CE2 TYR A  76     -10.101   7.347  -0.410  0.00  0.88           C  
ATOM   1198  CZ  TYR A  76      -9.515   8.558  -0.671  0.00  0.90           C  
ATOM   1199  OH  TYR A  76     -10.256   9.595  -1.187  0.00  1.11           O  
ATOM   1200  H   TYR A  76      -6.033   3.616   2.435  0.00  0.38           H  
ATOM   1201  HA  TYR A  76      -6.084   6.450   2.496  0.00  0.32           H  
ATOM   1202  HB2 TYR A  76      -6.298   5.252   0.398  0.00  0.44           H  
ATOM   1203  HB3 TYR A  76      -7.770   4.466   0.959  0.00  0.51           H  
ATOM   1204  HD1 TYR A  76      -6.384   7.887   0.386  0.00  0.62           H  
ATOM   1205  HD2 TYR A  76      -9.807   5.362   0.319  0.00  0.79           H  
ATOM   1206  HE1 TYR A  76      -7.713   9.724  -0.565  0.00  0.93           H  
ATOM   1207  HE2 TYR A  76     -11.146   7.191  -0.633  0.00  1.05           H  
ATOM   1208  HH  TYR A  76     -10.292  10.323  -0.563  0.00  1.47           H  
ATOM   1209  N   VAL A  77      -8.709   4.867   3.695  0.00  0.64           N  
ATOM   1210  CA  VAL A  77      -9.902   5.023   4.518  0.00  0.83           C  
ATOM   1211  C   VAL A  77     -10.157   3.775   5.359  0.00  1.47           C  
ATOM   1212  O   VAL A  77      -9.940   2.652   4.902  0.00  2.27           O  
ATOM   1213  CB  VAL A  77     -11.144   5.319   3.652  0.00  1.73           C  
ATOM   1214  CG1 VAL A  77     -11.419   4.171   2.694  0.00  2.20           C  
ATOM   1215  CG2 VAL A  77     -12.358   5.594   4.529  0.00  2.63           C  
ATOM   1216  H   VAL A  77      -8.440   3.969   3.409  0.00  0.82           H  
ATOM   1217  HA  VAL A  77      -9.741   5.863   5.179  0.00  1.22           H  
ATOM   1218  HB  VAL A  77     -10.944   6.205   3.067  0.00  2.33           H  
ATOM   1219 HG11 VAL A  77     -11.387   4.536   1.677  0.00  2.58           H  
ATOM   1220 HG12 VAL A  77     -10.668   3.405   2.824  0.00  2.75           H  
ATOM   1221 HG13 VAL A  77     -12.393   3.756   2.898  0.00  2.40           H  
ATOM   1222 HG21 VAL A  77     -12.097   6.317   5.288  0.00  3.05           H  
ATOM   1223 HG22 VAL A  77     -13.160   5.984   3.921  0.00  3.15           H  
ATOM   1224 HG23 VAL A  77     -12.677   4.676   5.001  0.00  3.04           H  
ATOM   1225  N   HIS A  78     -10.615   3.979   6.589  0.00  1.89           N  
ATOM   1226  CA  HIS A  78     -10.897   2.872   7.495  0.00  2.91           C  
ATOM   1227  C   HIS A  78     -12.152   3.146   8.318  0.00  2.89           C  
ATOM   1228  O   HIS A  78     -12.426   2.365   9.254  0.00  3.13           O  
ATOM   1229  CB  HIS A  78      -9.704   2.633   8.423  0.00  3.84           C  
ATOM   1230  CG  HIS A  78      -8.791   1.540   7.958  0.00  4.32           C  
ATOM   1231  ND1 HIS A  78      -9.026   0.792   6.823  0.00  4.11           N  
ATOM   1232  CD2 HIS A  78      -7.633   1.069   8.481  0.00  5.34           C  
ATOM   1233  CE1 HIS A  78      -8.056  -0.089   6.669  0.00  4.94           C  
ATOM   1234  NE2 HIS A  78      -7.197   0.058   7.661  0.00  5.68           N  
ATOM   1235  OXT HIS A  78     -12.850   4.137   8.020  0.00  3.09           O  
ATOM   1236  H   HIS A  78     -10.765   4.898   6.896  0.00  1.90           H  
ATOM   1237  HA  HIS A  78     -11.057   1.988   6.897  0.00  3.36           H  
ATOM   1238  HB2 HIS A  78      -9.124   3.541   8.494  0.00  4.00           H  
ATOM   1239  HB3 HIS A  78     -10.069   2.366   9.406  0.00  4.45           H  
ATOM   1240  HD1 HIS A  78      -9.793   0.894   6.220  0.00  3.65           H  
ATOM   1241  HD2 HIS A  78      -7.144   1.425   9.378  0.00  5.92           H  
ATOM   1242  HE1 HIS A  78      -7.975  -0.808   5.867  0.00  5.15           H  
ATOM   1243  HE2 HIS A  78      -6.436  -0.532   7.841  0.00  6.49           H  
TER    1244      HIS A  78                                                      
END
MOLECULE T0492.pdb
ATOM     18  N   PHE     2      -1.543   4.722  10.626  1.00 74.01
ATOM     19  HN  PHE     2      -1.545   5.677  10.295  1.00  0.00
ATOM     20  CA  PHE     2      -2.153   3.701   9.795  1.00  3.52
ATOM     21  HA  PHE     2      -2.214   2.774  10.364  1.00  0.00
ATOM     22  CB  PHE     2      -3.570   4.116   9.379  1.00 43.40
ATOM     23 2HB  PHE     2      -4.130   4.382  10.276  1.00  0.00
ATOM     24 3HB  PHE     2      -3.499   4.995   8.737  1.00  0.00
ATOM     25  CG  PHE     2      -4.330   3.046   8.642  1.00 20.11
ATOM     26  CD1 PHE     2      -4.372   3.032   7.256  1.00 62.52
ATOM     27 1HD  PHE     2      -3.855   3.800   6.699  1.00  0.00
ATOM     28  CE1 PHE     2      -5.067   2.049   6.579  1.00 34.45
ATOM     29 1HE  PHE     2      -5.093   2.052   5.499  1.00  0.00
ATOM     30  CZ  PHE     2      -5.728   1.064   7.284  1.00 62.44
ATOM     31  HZ  PHE     2      -6.269   0.293   6.756  1.00  0.00
ATOM     32  CE2 PHE     2      -5.698   1.066   8.665  1.00 65.21
ATOM     33 2HE  PHE     2      -6.220   0.300   9.218  1.00  0.00
ATOM     34  CD2 PHE     2      -4.999   2.051   9.338  1.00  5.40
ATOM     35 2HD  PHE     2      -4.974   2.046  10.418  1.00  0.00
ATOM     36  C   PHE     2      -1.276   3.477   8.572  1.00 11.34
ATOM     37  O   PHE     2      -1.121   4.368   7.734  1.00 25.11
ATOM     38  N   SER     3      -0.684   2.301   8.493  1.00 64.43
ATOM     39  HN  SER     3      -0.879   1.592   9.184  1.00  0.00
ATOM     40  CA  SER     3       0.249   1.991   7.431  1.00 24.31
ATOM     41  HA  SER     3       0.539   2.917   6.933  1.00  0.00
ATOM     42  CB  SER     3       1.493   1.334   8.027  1.00 64.20
ATOM     43 2HB  SER     3       1.287   0.280   8.213  1.00  0.00
ATOM     44 3HB  SER     3       2.318   1.424   7.320  1.00  0.00
ATOM     45  OG  SER     3       1.856   1.959   9.247  1.00 35.21
ATOM     46  HG  SER     3       2.639   1.527   9.597  1.00  0.00
ATOM     47  C   SER     3      -0.397   1.063   6.412  1.00 60.05
ATOM     48  O   SER     3      -1.528   0.612   6.597  1.00  3.21
ATOM     49  N   LEU     4       0.328   0.765   5.345  1.00 12.31
ATOM     50  HN  LEU     4       1.247   1.169   5.233  1.00  0.00
ATOM     51  CA  LEU     4      -0.162  -0.138   4.314  1.00 14.12
ATOM     52  HA  LEU     4      -1.150   0.198   4.000  1.00  0.00
ATOM     53  CB  LEU     4       0.773  -0.115   3.101  1.00 12.03
ATOM     54 2HB  LEU     4       0.891   0.923   2.787  1.00  0.00
ATOM     55 3HB  LEU     4       1.739  -0.512   3.413  1.00  0.00
ATOM     56  CG  LEU     4       0.298  -0.924   1.891  1.00 23.03
ATOM     57  HG  LEU     4       0.144  -1.956   2.206  1.00  0.00
ATOM     58  CD1 LEU     4      -1.022  -0.380   1.370  1.00 51.12
ATOM     59 1HD1 LEU     4      -1.358  -0.976   0.522  1.00  0.00
ATOM     60 2HD1 LEU     4      -1.770  -0.424   2.162  1.00  0.00
ATOM     61 3HD1 LEU     4      -0.888   0.655   1.054  1.00  0.00
ATOM     62  CD2 LEU     4       1.353  -0.909   0.796  1.00 63.44
ATOM     63 1HD2 LEU     4       1.014  -1.505  -0.051  1.00  0.00
ATOM     64 2HD2 LEU     4       1.524   0.118   0.470  1.00  0.00
ATOM     65 3HD2 LEU     4       2.283  -1.326   1.182  1.00  0.00
ATOM     66  C   LEU     4      -0.277  -1.556   4.867  1.00 33.11
ATOM     67  O   LEU     4      -1.097  -2.351   4.413  1.00 44.21
ATOM     68  N   ARG     5       0.537  -1.858   5.872  1.00 30.21
ATOM     69  HN  ARG     5       1.184  -1.165   6.222  1.00  0.00
ATOM     70  CA  ARG     5       0.527  -3.177   6.493  1.00 63.40
ATOM     71  HA  ARG     5       0.383  -3.914   5.703  1.00  0.00
ATOM     72  CB  ARG     5       1.875  -3.467   7.172  1.00 74.52
ATOM     73 2HB  ARG     5       1.804  -4.437   7.663  1.00  0.00
ATOM     74 3HB  ARG     5       2.642  -3.506   6.398  1.00  0.00
ATOM     75  CG  ARG     5       2.309  -2.440   8.214  1.00  4.51
ATOM     76 2HG  ARG     5       3.389  -2.511   8.347  1.00  0.00
ATOM     77 3HG  ARG     5       2.052  -1.444   7.852  1.00  0.00
ATOM     78  CD  ARG     5       1.636  -2.660   9.559  1.00 60.41
ATOM     79 2HD  ARG     5       0.561  -2.522   9.442  1.00  0.00
ATOM     80 3HD  ARG     5       1.833  -3.680   9.889  1.00  0.00
ATOM     81  NE  ARG     5       2.123  -1.732  10.576  1.00 53.25
ATOM     82  HE  ARG     5       2.750  -1.000  10.273  1.00  0.00
ATOM     83  CZ  ARG     5       1.788  -1.799  11.863  1.00 31.32
ATOM     84  NH1 ARG     5       0.974  -2.752  12.297  1.00 42.13
ATOM     85 1HH1 ARG     5       0.725  -2.799  13.274  1.00  0.00
ATOM     86 2HH1 ARG     5       0.603  -3.431  11.649  1.00  0.00
ATOM     87  NH2 ARG     5       2.275  -0.912  12.719  1.00  5.31
ATOM     88 1HH2 ARG     5       2.024  -0.962  13.696  1.00  0.00
ATOM     89 2HH2 ARG     5       2.898  -0.185  12.394  1.00  0.00
ATOM     90  C   ARG     5      -0.629  -3.317   7.482  1.00 10.22
ATOM     91  O   ARG     5      -0.864  -4.396   8.028  1.00 64.31
ATOM     92  N   ASP     6      -1.337  -2.219   7.719  1.00 63.24
ATOM     93  HN  ASP     6      -1.079  -1.348   7.276  1.00  0.00
ATOM     94  CA  ASP     6      -2.490  -2.231   8.612  1.00 35.34
ATOM     95  HA  ASP     6      -2.323  -2.992   9.374  1.00  0.00
ATOM     96  CB  ASP     6      -2.667  -0.876   9.304  1.00 22.10
ATOM     97 2HB  ASP     6      -2.603  -0.090   8.551  1.00  0.00
ATOM     98 3HB  ASP     6      -3.653  -0.848   9.767  1.00  0.00
ATOM     99  CG  ASP     6      -1.625  -0.608  10.371  1.00 45.42
ATOM    100  OD1 ASP     6      -1.739  -1.182  11.475  1.00 64.32
ATOM    101  OD2 ASP     6      -0.704   0.198  10.124  1.00 21.34
ATOM    102 2HD  ASP     6      -0.086   0.324  10.848  1.00  0.00
ATOM    103  C   ASP     6      -3.756  -2.578   7.839  1.00 55.21
ATOM    104  O   ASP     6      -4.831  -2.744   8.422  1.00 30.54
ATOM    105  N   ALA     7      -3.625  -2.680   6.524  1.00 72.34
ATOM    106  HN  ALA     7      -2.728  -2.503   6.093  1.00  0.00
ATOM    107  CA  ALA     7      -4.743  -3.041   5.669  1.00 22.13
ATOM    108  HA  ALA     7      -5.659  -2.672   6.130  1.00  0.00
ATOM    109  CB  ALA     7      -4.595  -2.392   4.302  1.00 22.42
ATOM    110 1HB  ALA     7      -5.451  -2.648   3.677  1.00  0.00
ATOM    111 2HB  ALA     7      -4.544  -1.309   4.418  1.00  0.00
ATOM    112 3HB  ALA     7      -3.681  -2.749   3.828  1.00  0.00
ATOM    113  C   ALA     7      -4.843  -4.555   5.534  1.00 53.13
ATOM    114  O   ALA     7      -3.841  -5.264   5.629  1.00 30.50
ATOM    115  N   LYS     8      -6.054  -5.046   5.322  1.00 32.51
ATOM    116  HN  LYS     8      -6.843  -4.420   5.247  1.00  0.00
ATOM    117  CA  LYS     8      -6.289  -6.477   5.191  1.00 22.44
ATOM    118  HA  LYS     8      -5.454  -7.012   5.645  1.00  0.00
ATOM    119  CB  LYS     8      -7.584  -6.872   5.910  1.00 13.25
ATOM    120 2HB  LYS     8      -8.423  -6.441   5.364  1.00  0.00
ATOM    121 3HB  LYS     8      -7.663  -7.959   5.899  1.00  0.00
ATOM    122  CG  LYS     8      -7.664  -6.403   7.354  1.00 65.44
ATOM    123 2HG  LYS     8      -7.546  -5.319   7.379  1.00  0.00
ATOM    124 3HG  LYS     8      -8.640  -6.671   7.758  1.00  0.00
ATOM    125  CD  LYS     8      -6.584  -7.035   8.217  1.00 11.52
ATOM    126 2HD  LYS     8      -6.700  -8.118   8.196  1.00  0.00
ATOM    127 3HD  LYS     8      -5.606  -6.767   7.816  1.00  0.00
ATOM    128  CE  LYS     8      -6.680  -6.553   9.654  1.00 44.24
ATOM    129 2HE  LYS     8      -6.530  -5.473   9.674  1.00  0.00
ATOM    130 3HE  LYS     8      -7.674  -6.784  10.037  1.00  0.00
ATOM    131  NZ  LYS     8      -5.665  -7.196  10.531  1.00  4.24
ATOM    132 1HZ  LYS     8      -5.760  -6.850  11.475  1.00  0.00
ATOM    133 2HZ  LYS     8      -5.801  -8.196  10.525  1.00  0.00
ATOM    134 3HZ  LYS     8      -4.740  -6.980  10.188  1.00  0.00
ATOM    135  C   LYS     8      -6.383  -6.857   3.718  1.00 42.14
ATOM    136  O   LYS     8      -6.815  -6.049   2.891  1.00 20.55
ATOM    137  N   CYS     9      -5.980  -8.076   3.388  1.00 41.51
ATOM    138  HN  CYS     9      -5.610  -8.695   4.094  1.00  0.00
ATOM    139  CA  CYS     9      -6.058  -8.552   2.015  1.00  2.35
ATOM    140  HA  CYS     9      -5.629  -7.787   1.367  1.00  0.00
ATOM    141  CB  CYS     9      -5.243  -9.834   1.843  1.00 21.02
ATOM    142 2HB  CYS     9      -5.616 -10.355   0.961  1.00  0.00
ATOM    143 3HB  CYS     9      -4.201  -9.552   1.687  1.00  0.00
ATOM    144  SG  CYS     9      -5.327 -10.961   3.252  1.00 72.52
ATOM    145  HG  CYS     9      -4.531 -11.912   2.755  1.00  0.00
ATOM    146  C   CYS     9      -7.512  -8.761   1.608  1.00 15.30
ATOM    147  O   CYS     9      -8.192  -9.663   2.102  1.00 13.32
ATOM    148  N   GLY    10      -7.978  -7.908   0.711  1.00 51.22
ATOM    149  HN  GLY    10      -7.355  -7.248   0.267  1.00  0.00
ATOM    150  CA  GLY    10      -9.376  -7.897   0.346  1.00  3.45
ATOM    151 1HA  GLY    10      -9.478  -8.244  -0.682  1.00  0.00
ATOM    152 2HA  GLY    10      -9.922  -8.567   1.009  1.00  0.00
ATOM    153  C   GLY    10      -9.962  -6.506   0.458  1.00 12.24
ATOM    154  O   GLY    10     -11.091  -6.256   0.029  1.00 13.34
ATOM    155  N   GLN    11      -9.191  -5.600   1.045  1.00 41.41
ATOM    156  HN  GLN    11      -8.285  -5.870   1.401  1.00  0.00
ATOM    157  CA  GLN    11      -9.605  -4.213   1.198  1.00 43.31
ATOM    158  HA  GLN    11     -10.686  -4.162   1.069  1.00  0.00
ATOM    159  CB  GLN    11      -9.253  -3.704   2.597  1.00 35.22
ATOM    160 2HB  GLN    11      -8.178  -3.812   2.741  1.00  0.00
ATOM    161 3HB  GLN    11      -9.523  -2.649   2.657  1.00  0.00
ATOM    162  CG  GLN    11      -9.963  -4.445   3.718  1.00 24.45
ATOM    163 2HG  GLN    11     -11.038  -4.302   3.607  1.00  0.00
ATOM    164 3HG  GLN    11      -9.731  -5.507   3.638  1.00  0.00
ATOM    165  CD  GLN    11      -9.544  -3.956   5.092  1.00 53.41
ATOM    166  OE1 GLN    11      -8.414  -3.504   5.288  1.00 54.04
ATOM    167  NE2 GLN    11     -10.448  -4.036   6.053  1.00 44.33
ATOM    168 1HE2 GLN    11     -11.363  -4.411   5.850  1.00  0.00
ATOM    169 2HE2 GLN    11     -10.222  -3.722   6.986  1.00  0.00
ATOM    170  C   GLN    11      -8.945  -3.330   0.142  1.00  4.23
ATOM    171  O   GLN    11      -7.996  -3.743  -0.527  1.00 30.34
ATOM    172  N   THR    12      -9.461  -2.119  -0.008  1.00  5.22
ATOM    173  HN  THR    12     -10.253  -1.839   0.553  1.00  0.00
ATOM    174  CA  THR    12      -8.921  -1.166  -0.962  1.00 72.31
ATOM    175  HA  THR    12      -8.091  -1.639  -1.488  1.00  0.00
ATOM    176  CB  THR    12      -9.989  -0.754  -1.992  1.00 24.54
ATOM    177  HB  THR    12     -10.761  -0.176  -1.484  1.00  0.00
ATOM    178  OG1 THR    12     -10.582  -1.926  -2.562  1.00 13.33
ATOM    179 1HG  THR    12     -11.256  -1.655  -3.189  1.00  0.00
ATOM    180  CG2 THR    12      -9.387   0.100  -3.099  1.00  4.01
ATOM    181 1HG2 THR    12     -10.161   0.386  -3.812  1.00  0.00
ATOM    182 2HG2 THR    12      -8.948   0.999  -2.665  1.00  0.00
ATOM    183 3HG2 THR    12      -8.613  -0.469  -3.615  1.00  0.00
ATOM    184  C   THR    12      -8.405   0.076  -0.241  1.00 11.14
ATOM    185  O   THR    12      -9.153   0.749   0.471  1.00 21.50
ATOM    186  N   VAL    13      -7.125   0.365  -0.412  1.00 64.12
ATOM    187  HN  VAL    13      -6.544  -0.236  -0.979  1.00  0.00
ATOM    188  CA  VAL    13      -6.521   1.536   0.199  1.00 41.30
ATOM    189  HA  VAL    13      -7.285   2.035   0.796  1.00  0.00
ATOM    190  CB  VAL    13      -5.340   1.166   1.121  1.00 62.24
ATOM    191  HB  VAL    13      -4.903   2.090   1.500  1.00  0.00
ATOM    192  CG1 VAL    13      -5.810   0.344   2.308  1.00 31.14
ATOM    193 1HG1 VAL    13      -4.965   0.114   2.957  1.00  0.00
ATOM    194 2HG1 VAL    13      -6.553   0.911   2.869  1.00  0.00
ATOM    195 3HG1 VAL    13      -6.255  -0.585   1.951  1.00  0.00
ATOM    196  CG2 VAL    13      -4.269   0.420   0.344  1.00  1.13
ATOM    197 1HG2 VAL    13      -3.430   0.189   1.000  1.00  0.00
ATOM    198 2HG2 VAL    13      -4.686  -0.506  -0.050  1.00  0.00
ATOM    199 3HG2 VAL    13      -3.921   1.042  -0.482  1.00  0.00
ATOM    200  C   VAL    13      -6.022   2.500  -0.866  1.00 61.23
ATOM    201  O   VAL    13      -5.900   2.144  -2.036  1.00 43.41
ATOM    202  N   LYS    14      -5.745   3.721  -0.452  1.00 54.14
ATOM    203  HN  LYS    14      -5.945   3.983   0.502  1.00  0.00
ATOM    204  CA  LYS    14      -5.155   4.717  -1.328  1.00 51.51
ATOM    205  HA  LYS    14      -4.765   4.211  -2.211  1.00  0.00
ATOM    206  CB  LYS    14      -6.208   5.727  -1.778  1.00 14.21
ATOM    207 2HB  LYS    14      -6.942   5.841  -0.981  1.00  0.00
ATOM    208 3HB  LYS    14      -5.716   6.684  -1.959  1.00  0.00
ATOM    209  CG  LYS    14      -6.932   5.308  -3.046  1.00 34.22
ATOM    210 2HG  LYS    14      -6.291   5.518  -3.903  1.00  0.00
ATOM    211 3HG  LYS    14      -7.136   4.239  -2.998  1.00  0.00
ATOM    212  CD  LYS    14      -8.243   6.050  -3.222  1.00 32.42
ATOM    213 2HD  LYS    14      -8.659   5.803  -4.199  1.00  0.00
ATOM    214 3HD  LYS    14      -8.934   5.733  -2.442  1.00  0.00
ATOM    215  CE  LYS    14      -8.062   7.556  -3.134  1.00 65.41
ATOM    216 2HE  LYS    14      -7.710   7.813  -2.135  1.00  0.00
ATOM    217 3HE  LYS    14      -7.317   7.867  -3.867  1.00  0.00
ATOM    218  NZ  LYS    14      -9.330   8.278  -3.400  1.00 21.43
ATOM    219 1HZ  LYS    14      -9.175   9.274  -3.334  1.00  0.00
ATOM    220 2HZ  LYS    14      -9.657   8.051  -4.328  1.00  0.00
ATOM    221 3HZ  LYS    14     -10.023   8.001  -2.721  1.00  0.00
ATOM    222  C   LYS    14      -4.006   5.413  -0.624  1.00 53.31
ATOM    223  O   LYS    14      -4.100   5.736   0.560  1.00 40.05
ATOM    224  N   VAL    15      -2.921   5.620  -1.351  1.00 31.31
ATOM    225  HN  VAL    15      -2.912   5.364  -2.328  1.00  0.00
ATOM    226  CA  VAL    15      -1.723   6.214  -0.779  1.00 74.25
ATOM    227  HA  VAL    15      -1.564   5.774   0.205  1.00  0.00
ATOM    228  CB  VAL    15      -0.481   5.931  -1.651  1.00 55.30
ATOM    229  HB  VAL    15      -0.611   6.440  -2.606  1.00  0.00
ATOM    230  CG1 VAL    15       0.778   6.475  -0.991  1.00 60.13
ATOM    231 1HG1 VAL    15       1.641   6.287  -1.630  1.00  0.00
ATOM    232 2HG1 VAL    15       0.671   7.549  -0.836  1.00  0.00
ATOM    233 3HG1 VAL    15       0.926   5.982  -0.030  1.00  0.00
ATOM    234  CG2 VAL    15      -0.345   4.442  -1.921  1.00  4.15
ATOM    235 1HG2 VAL    15       0.522   4.260  -2.557  1.00  0.00
ATOM    236 2HG2 VAL    15      -0.218   3.913  -0.977  1.00  0.00
ATOM    237 3HG2 VAL    15      -1.243   4.082  -2.422  1.00  0.00
ATOM    238  C   VAL    15      -1.890   7.716  -0.621  1.00  1.34
ATOM    239  O   VAL    15      -2.316   8.401  -1.552  1.00 64.13
ATOM    240  N   VAL    16      -1.568   8.222   0.556  1.00 40.44
ATOM    241  HN  VAL    16      -1.280   7.613   1.309  1.00  0.00
ATOM    242  CA  VAL    16      -1.618   9.653   0.797  1.00 52.11
ATOM    243  HA  VAL    16      -1.981  10.122  -0.118  1.00  0.00
ATOM    244  CB  VAL    16      -2.600  10.025   1.935  1.00 74.41
ATOM    245  HB  VAL    16      -2.405  11.057   2.229  1.00  0.00
ATOM    246  CG1 VAL    16      -4.034   9.925   1.446  1.00 32.42
ATOM    247 1HG1 VAL    16      -4.717  10.214   2.244  1.00  0.00
ATOM    248 2HG1 VAL    16      -4.173  10.590   0.593  1.00  0.00
ATOM    249 3HG1 VAL    16      -4.243   8.899   1.144  1.00  0.00
ATOM    250  CG2 VAL    16      -2.406   9.136   3.156  1.00 60.05
ATOM    251 1HG2 VAL    16      -3.096   9.432   3.946  1.00  0.00
ATOM    252 2HG2 VAL    16      -2.595   8.099   2.881  1.00  0.00
ATOM    253 3HG2 VAL    16      -1.382   9.235   3.516  1.00  0.00
ATOM    254  C   VAL    16      -0.230  10.206   1.086  1.00  3.43
ATOM    255  O   VAL    16       0.258  11.073   0.364  1.00 72.51
ATOM    256  N   LYS    17       0.420   9.684   2.111  1.00 33.10
ATOM    257  HN  LYS    17      -0.011   8.959   2.665  1.00  0.00
ATOM    258  CA  LYS    17       1.756  10.131   2.468  1.00 73.35
ATOM    259  HA  LYS    17       2.045  10.925   1.779  1.00  0.00
ATOM    260  CB  LYS    17       1.793  10.682   3.894  1.00 53.01
ATOM    261 2HB  LYS    17       1.381   9.926   4.562  1.00  0.00
ATOM    262 3HB  LYS    17       2.833  10.873   4.159  1.00  0.00
ATOM    263  CG  LYS    17       1.009  11.969   4.091  1.00 34.34
ATOM    264 2HG  LYS    17       1.380  12.723   3.395  1.00  0.00
ATOM    265 3HG  LYS    17      -0.045  11.779   3.892  1.00  0.00
ATOM    266  CD  LYS    17       1.162  12.485   5.510  1.00 73.01
ATOM    267 2HD  LYS    17       0.785  11.732   6.202  1.00  0.00
ATOM    268 3HD  LYS    17       2.219  12.664   5.708  1.00  0.00
ATOM    269  CE  LYS    17       0.397  13.778   5.726  1.00 72.44
ATOM    270 2HE  LYS    17       0.783  14.537   5.044  1.00  0.00
ATOM    271 3HE  LYS    17      -0.657  13.606   5.511  1.00  0.00
ATOM    272  NZ  LYS    17       0.532  14.270   7.122  1.00 74.42
ATOM    273 1HZ  LYS    17       0.013  15.130   7.232  1.00  0.00
ATOM    274 2HZ  LYS    17       0.170  13.576   7.759  1.00  0.00
ATOM    275 3HZ  LYS    17       1.507  14.439   7.326  1.00  0.00
ATOM    276  C   LYS    17       2.750   8.992   2.350  1.00 74.25
ATOM    277  O   LYS    17       2.376   7.820   2.348  1.00 52.02
ATOM    278  N   LEU    18       4.017   9.343   2.254  1.00 42.21
ATOM    279  HN  LEU    18       4.264  10.322   2.204  1.00  0.00
ATOM    280  CA  LEU    18       5.081   8.363   2.217  1.00 13.22
ATOM    281  HA  LEU    18       4.671   7.391   2.491  1.00  0.00
ATOM    282  CB  LEU    18       5.677   8.265   0.810  1.00 61.32
ATOM    283 2HB  LEU    18       5.975   9.267   0.499  1.00  0.00
ATOM    284 3HB  LEU    18       6.557   7.624   0.860  1.00  0.00
ATOM    285  CG  LEU    18       4.738   7.698  -0.258  1.00 65.15
ATOM    286  HG  LEU    18       3.824   8.292  -0.268  1.00  0.00
ATOM    287  CD1 LEU    18       5.386   7.783  -1.627  1.00 22.25
ATOM    288 1HD1 LEU    18       4.704   7.393  -2.382  1.00  0.00
ATOM    289 2HD1 LEU    18       5.619   8.824  -1.854  1.00  0.00
ATOM    290 3HD1 LEU    18       6.305   7.197  -1.631  1.00  0.00
ATOM    291  CD2 LEU    18       4.378   6.256   0.065  1.00 71.20
ATOM    292 1HD2 LEU    18       3.697   5.869  -0.693  1.00  0.00
ATOM    293 2HD2 LEU    18       5.285   5.651   0.080  1.00  0.00
ATOM    294 3HD2 LEU    18       3.896   6.213   1.041  1.00  0.00
ATOM    295  C   LEU    18       6.152   8.749   3.221  1.00 42.33
ATOM    296  O   LEU    18       6.836   9.754   3.048  1.00 73.24
ATOM    297  N   HIS    19       6.265   7.978   4.287  1.00 41.13
ATOM    298  HN  HIS    19       5.664   7.175   4.397  1.00  0.00
ATOM    299  CA  HIS    19       7.248   8.262   5.321  1.00 64.44
ATOM    300  HA  HIS    19       7.383   9.343   5.380  1.00  0.00
ATOM    301  CB  HIS    19       6.772   7.752   6.689  1.00 21.33
ATOM    302 2HB  HIS    19       6.602   6.678   6.615  1.00  0.00
ATOM    303 3HB  HIS    19       7.562   7.936   7.418  1.00  0.00
ATOM    304  CG  HIS    19       5.512   8.397   7.186  1.00 62.22
ATOM    305  ND1 HIS    19       5.494   9.362   8.169  1.00 53.41
ATOM    306  CD2 HIS    19       4.217   8.192   6.844  1.00 31.35
ATOM    307 1HD  HIS    19       6.309   9.737   8.634  1.00  0.00
ATOM    308  CE1 HIS    19       4.247   9.721   8.409  1.00 52.24
ATOM    309  NE2 HIS    19       3.450   9.027   7.619  1.00 64.53
ATOM    310 2HD  HIS    19       3.855   7.500   6.099  1.00  0.00
ATOM    311 1HE  HIS    19       3.932  10.460   9.131  1.00  0.00
ATOM    312 2HE  HIS    19       2.443   9.098   7.589  1.00  0.00
ATOM    313  C   HIS    19       8.580   7.618   4.964  1.00 43.41
ATOM    314  O   HIS    19       8.642   6.745   4.098  1.00 51.35
ATOM    315  N   GLY    20       9.643   8.056   5.620  1.00  2.20
ATOM    316  HN  GLY    20       9.559   8.812   6.285  1.00  0.00
ATOM    317  CA  GLY    20      10.943   7.462   5.397  1.00 72.45
ATOM    318 1HA  GLY    20      11.172   6.798   6.231  1.00  0.00
ATOM    319 2HA  GLY    20      10.909   6.884   4.474  1.00  0.00
ATOM    320  C   GLY    20      12.042   8.495   5.283  1.00 54.34
ATOM    321  O   GLY    20      11.782   9.697   5.320  1.00 10.33
ATOM    322  N   THR    21      13.267   8.020   5.119  1.00 54.33
ATOM    323  HN  THR    21      13.405   7.022   5.054  1.00  0.00
ATOM    324  CA  THR    21      14.442   8.881   5.026  1.00  4.12
ATOM    325  HA  THR    21      14.319   9.703   5.731  1.00  0.00
ATOM    326  CB  THR    21      15.700   8.083   5.402  1.00 61.42
ATOM    327  HB  THR    21      16.579   8.634   5.067  1.00  0.00
ATOM    328  OG1 THR    21      15.667   6.809   4.743  1.00 21.03
ATOM    329 1HG  THR    21      16.465   6.326   4.972  1.00  0.00
ATOM    330  CG2 THR    21      15.792   7.884   6.909  1.00 20.30
ATOM    331 1HG2 THR    21      16.693   7.322   7.154  1.00  0.00
ATOM    332 2HG2 THR    21      15.829   8.856   7.401  1.00  0.00
ATOM    333 3HG2 THR    21      14.918   7.334   7.255  1.00  0.00
ATOM    334  C   THR    21      14.623   9.464   3.621  1.00 30.23
ATOM    335  O   THR    21      15.746   9.711   3.182  1.00 75.23
ATOM    336  N   GLY    22      13.518   9.692   2.923  1.00 32.25
ATOM    337  HN  GLY    22      12.614   9.471   3.314  1.00  0.00
ATOM    338  CA  GLY    22      13.583  10.262   1.589  1.00 22.11
ATOM    339 1HA  GLY    22      12.614  10.698   1.348  1.00  0.00
ATOM    340 2HA  GLY    22      14.343  11.044   1.580  1.00  0.00
ATOM    341  C   GLY    22      13.931   9.233   0.531  1.00 74.52
ATOM    342  O   GLY    22      13.140   8.977  -0.377  1.00 73.21
ATOM    343  N   ALA    23      15.110   8.634   0.661  1.00 20.51
ATOM    344  HN  ALA    23      15.708   8.875   1.439  1.00  0.00
ATOM    345  CA  ALA    23      15.584   7.630  -0.287  1.00 74.44
ATOM    346  HA  ALA    23      15.664   8.101  -1.267  1.00  0.00
ATOM    347  CB  ALA    23      16.961   7.132   0.122  1.00 64.42
ATOM    348 1HB  ALA    23      17.322   6.407  -0.607  1.00  0.00
ATOM    349 2HB  ALA    23      17.653   7.974   0.167  1.00  0.00
ATOM    350 3HB  ALA    23      16.900   6.660   1.102  1.00  0.00
ATOM    351  C   ALA    23      14.605   6.465  -0.391  1.00 45.31
ATOM    352  O   ALA    23      14.386   5.915  -1.473  1.00 25.24
ATOM    353  N   LEU    24      14.015   6.101   0.741  1.00 14.13
ATOM    354  HN  LEU    24      14.259   6.564   1.605  1.00  0.00
ATOM    355  CA  LEU    24      13.015   5.043   0.780  1.00 61.23
ATOM    356  HA  LEU    24      13.452   4.138   0.358  1.00  0.00
ATOM    357  CB  LEU    24      12.599   4.760   2.230  1.00 63.32
ATOM    358 2HB  LEU    24      13.497   4.510   2.794  1.00  0.00
ATOM    359 3HB  LEU    24      12.156   5.670   2.636  1.00  0.00
ATOM    360  CG  LEU    24      11.592   3.621   2.414  1.00 32.01
ATOM    361  HG  LEU    24      10.713   3.839   1.807  1.00  0.00
ATOM    362  CD1 LEU    24      12.184   2.300   1.942  1.00 12.44
ATOM    363 1HD1 LEU    24      11.450   1.503   2.059  1.00  0.00
ATOM    364 2HD1 LEU    24      12.462   2.383   0.891  1.00  0.00
ATOM    365 3HD1 LEU    24      13.069   2.067   2.534  1.00  0.00
ATOM    366  CD2 LEU    24      11.159   3.523   3.866  1.00 51.42
ATOM    367 1HD2 LEU    24      10.427   2.724   3.980  1.00  0.00
ATOM    368 2HD2 LEU    24      12.027   3.309   4.489  1.00  0.00
ATOM    369 3HD2 LEU    24      10.714   4.469   4.176  1.00  0.00
ATOM    370  C   LEU    24      11.799   5.439  -0.057  1.00  1.54
ATOM    371  O   LEU    24      11.283   4.637  -0.835  1.00  3.43
ATOM    372  N   LYS    25      11.374   6.692   0.088  1.00 73.40
ATOM    373  HN  LYS    25      11.853   7.311   0.726  1.00  0.00
ATOM    374  CA  LYS    25      10.227   7.213  -0.650  1.00 74.22
ATOM    375  HA  LYS    25       9.353   6.610  -0.405  1.00  0.00
ATOM    376  CB  LYS    25       9.951   8.670  -0.266  1.00 62.33
ATOM    377 2HB  LYS    25      10.752   9.288  -0.673  1.00  0.00
ATOM    378 3HB  LYS    25       9.002   8.967  -0.711  1.00  0.00
ATOM    379  CG  LYS    25       9.873   8.915   1.232  1.00 12.02
ATOM    380 2HG  LYS    25       9.042   8.343   1.643  1.00  0.00
ATOM    381 3HG  LYS    25      10.804   8.589   1.695  1.00  0.00
ATOM    382  CD  LYS    25       9.658  10.389   1.535  1.00 54.14
ATOM    383 2HD  LYS    25      10.428  10.971   1.028  1.00  0.00
ATOM    384 3HD  LYS    25       8.677  10.687   1.166  1.00  0.00
ATOM    385  CE  LYS    25       9.730  10.668   3.025  1.00 61.02
ATOM    386 2HE  LYS    25       8.994  10.049   3.536  1.00  0.00
ATOM    387 3HE  LYS    25      10.727  10.411   3.385  1.00  0.00
ATOM    388  NZ  LYS    25       9.459  12.095   3.337  1.00 24.04
ATOM    389 1HZ  LYS    25       9.515  12.244   4.334  1.00  0.00
ATOM    390 2HZ  LYS    25      10.143  12.676   2.873  1.00  0.00
ATOM    391 3HZ  LYS    25       8.534  12.340   3.013  1.00  0.00
ATOM    392  C   LYS    25      10.485   7.132  -2.149  1.00 70.34
ATOM    393  O   LYS    25       9.607   6.757  -2.924  1.00 31.33
ATOM    394  N   ARG    26      11.706   7.480  -2.540  1.00 33.41
ATOM    395  HN  ARG    26      12.385   7.772  -1.852  1.00  0.00
ATOM    396  CA  ARG    26      12.112   7.459  -3.940  1.00 75.34
ATOM    397  HA  ARG    26      11.446   8.111  -4.505  1.00  0.00
ATOM    398  CB  ARG    26      13.544   7.987  -4.064  1.00 32.11
ATOM    399 2HB  ARG    26      13.577   8.987  -3.630  1.00  0.00
ATOM    400 3HB  ARG    26      14.201   7.324  -3.501  1.00  0.00
ATOM    401  CG  ARG    26      14.066   8.072  -5.490  1.00 13.24
ATOM    402 2HG  ARG    26      15.118   8.359  -5.464  1.00  0.00
ATOM    403 3HG  ARG    26      13.968   7.094  -5.961  1.00  0.00
ATOM    404  CD  ARG    26      13.299   9.092  -6.313  1.00 22.45
ATOM    405 2HD  ARG    26      12.303   8.702  -6.523  1.00  0.00
ATOM    406 3HD  ARG    26      13.209  10.015  -5.740  1.00  0.00
ATOM    407  NE  ARG    26      13.972   9.382  -7.579  1.00 22.31
ATOM    408  HE  ARG    26      14.692   8.740  -7.879  1.00  0.00
ATOM    409  CZ  ARG    26      13.691  10.432  -8.347  1.00 31.33
ATOM    410  NH1 ARG    26      12.691  11.244  -8.027  1.00 22.21
ATOM    411 1HH1 ARG    26      12.477  12.037  -8.615  1.00  0.00
ATOM    412 2HH1 ARG    26      12.145  11.069  -7.196  1.00  0.00
ATOM    413  NH2 ARG    26      14.399  10.655  -9.444  1.00 51.44
ATOM    414 1HH2 ARG    26      14.184  11.449 -10.031  1.00  0.00
ATOM    415 2HH2 ARG    26      15.154  10.032  -9.694  1.00  0.00
ATOM    416  C   ARG    26      12.016   6.050  -4.512  1.00 35.02
ATOM    417  O   ARG    26      11.545   5.859  -5.629  1.00 22.34
ATOM    418  N   ARG    27      12.457   5.069  -3.735  1.00 44.44
ATOM    419  HN  ARG    27      12.856   5.284  -2.832  1.00  0.00
ATOM    420  CA  ARG    27      12.385   3.673  -4.149  1.00 12.51
ATOM    421  HA  ARG    27      12.882   3.573  -5.114  1.00  0.00
ATOM    422  CB  ARG    27      13.107   2.783  -3.131  1.00 31.11
ATOM    423 2HB  ARG    27      14.164   3.050  -3.131  1.00  0.00
ATOM    424 3HB  ARG    27      12.683   2.976  -2.146  1.00  0.00
ATOM    425  CG  ARG    27      12.989   1.294  -3.420  1.00 32.35
ATOM    426 2HG  ARG    27      11.940   1.005  -3.366  1.00  0.00
ATOM    427 3HG  ARG    27      13.369   1.097  -4.423  1.00  0.00
ATOM    428  CD  ARG    27      13.781   0.468  -2.420  1.00 60.11
ATOM    429 2HD  ARG    27      14.843   0.677  -2.551  1.00  0.00
ATOM    430 3HD  ARG    27      13.482   0.753  -1.411  1.00  0.00
ATOM    431  NE  ARG    27      13.556  -0.964  -2.594  1.00  3.31
ATOM    432  HE  ARG    27      12.608  -1.263  -2.773  1.00  0.00
ATOM    433  CZ  ARG    27      14.515  -1.886  -2.532  1.00 50.51
ATOM    434  NH1 ARG    27      15.778  -1.533  -2.323  1.00 44.43
ATOM    435 1HH1 ARG    27      16.501  -2.237  -2.277  1.00  0.00
ATOM    436 2HH1 ARG    27      16.017  -0.558  -2.210  1.00  0.00
ATOM    437  NH2 ARG    27      14.207  -3.166  -2.680  1.00 61.44
ATOM    438 1HH2 ARG    27      14.932  -3.868  -2.634  1.00  0.00
ATOM    439 2HH2 ARG    27      13.248  -3.439  -2.840  1.00  0.00
ATOM    440  C   ARG    27      10.929   3.241  -4.302  1.00 45.42
ATOM    441  O   ARG    27      10.558   2.608  -5.291  1.00  0.02
ATOM    442  N   ILE    28      10.112   3.600  -3.319  1.00 44.23
ATOM    443  HN  ILE    28      10.482   4.097  -2.521  1.00  0.00
ATOM    444  CA  ILE    28       8.687   3.305  -3.346  1.00  2.21
ATOM    445  HA  ILE    28       8.567   2.223  -3.392  1.00  0.00
ATOM    446  CB  ILE    28       8.003   3.822  -2.059  1.00  5.03
ATOM    447  HB  ILE    28       8.209   4.889  -1.966  1.00  0.00
ATOM    448  CG2 ILE    28       6.496   3.631  -2.123  1.00 64.14
ATOM    449 1HG2 ILE    28       6.035   4.020  -1.215  1.00  0.00
ATOM    450 2HG2 ILE    28       6.100   4.166  -2.986  1.00  0.00
ATOM    451 3HG2 ILE    28       6.269   2.570  -2.218  1.00  0.00
ATOM    452  CG1 ILE    28       8.581   3.106  -0.835  1.00 34.04
ATOM    453 2HG1 ILE    28       8.331   2.048  -0.907  1.00  0.00
ATOM    454 3HG1 ILE    28       9.665   3.226  -0.848  1.00  0.00
ATOM    455  CD1 ILE    28       8.059   3.631   0.487  1.00 51.31
ATOM    456 1HD1 ILE    28       8.504   3.085   1.318  1.00  0.00
ATOM    457 2HD1 ILE    28       8.311   4.688   0.579  1.00  0.00
ATOM    458 3HD1 ILE    28       6.976   3.512   0.519  1.00  0.00
ATOM    459  C   ILE    28       8.017   3.920  -4.578  1.00 52.21
ATOM    460  O   ILE    28       7.316   3.230  -5.323  1.00 25.22
ATOM    461  N   MET    29       8.265   5.207  -4.799  1.00 11.03
ATOM    462  HN  MET    29       8.898   5.706  -4.190  1.00  0.00
ATOM    463  CA  MET    29       7.646   5.938  -5.905  1.00 64.11
ATOM    464  HA  MET    29       6.571   5.767  -5.858  1.00  0.00
ATOM    465  CB  MET    29       7.902   7.441  -5.774  1.00 73.02
ATOM    466 2HB  MET    29       8.976   7.600  -5.671  1.00  0.00
ATOM    467 3HB  MET    29       7.549   7.931  -6.682  1.00  0.00
ATOM    468  CG  MET    29       7.205   8.079  -4.583  1.00 55.12
ATOM    469 2HG  MET    29       6.136   7.880  -4.654  1.00  0.00
ATOM    470 3HG  MET    29       7.585   7.625  -3.668  1.00  0.00
ATOM    471  SD  MET    29       7.457   9.864  -4.491  1.00 72.11
ATOM    472  CE  MET    29       9.242   9.944  -4.348  1.00 32.31
ATOM    473 1HE  MET    29       9.563  10.984  -4.281  1.00  0.00
ATOM    474 2HE  MET    29       9.558   9.411  -3.452  1.00  0.00
ATOM    475 3HE  MET    29       9.697   9.483  -5.225  1.00  0.00
ATOM    476  C   MET    29       8.151   5.448  -7.255  1.00 70.22
ATOM    477  O   MET    29       7.423   5.487  -8.248  1.00 54.45
ATOM    478  N   ASP    30       9.393   4.986  -7.286  1.00 72.31
ATOM    479  HN  ASP    30       9.934   4.946  -6.434  1.00  0.00
ATOM    480  CA  ASP    30      10.016   4.528  -8.525  1.00 42.24
ATOM    481  HA  ASP    30       9.899   5.308  -9.278  1.00  0.00
ATOM    482  CB  ASP    30      11.510   4.276  -8.303  1.00 64.10
ATOM    483 2HB  ASP    30      11.918   5.094  -7.709  1.00  0.00
ATOM    484 3HB  ASP    30      11.630   3.341  -7.757  1.00  0.00
ATOM    485  CG  ASP    30      12.288   4.183  -9.599  1.00  0.52
ATOM    486  OD1 ASP    30      12.325   3.097 -10.207  1.00 34.42
ATOM    487  OD2 ASP    30      12.880   5.204 -10.012  1.00 31.43
ATOM    488 2HD  ASP    30      13.356   5.076 -10.836  1.00  0.00
ATOM    489  C   ASP    30       9.346   3.253  -9.030  1.00  2.22
ATOM    490  O   ASP    30       9.196   3.049 -10.237  1.00 50.42
ATOM    491  N   MET    31       8.927   2.407  -8.095  1.00 23.14
ATOM    492  HN  MET    31       9.043   2.641  -7.120  1.00  0.00
ATOM    493  CA  MET    31       8.298   1.134  -8.434  1.00 53.13
ATOM    494  HA  MET    31       8.886   0.665  -9.224  1.00  0.00
ATOM    495  CB  MET    31       8.279   0.205  -7.219  1.00 21.22
ATOM    496 2HB  MET    31       7.761   0.714  -6.406  1.00  0.00
ATOM    497 3HB  MET    31       7.734  -0.699  -7.488  1.00  0.00
ATOM    498  CG  MET    31       9.658  -0.197  -6.730  1.00 14.11
ATOM    499 2HG  MET    31      10.172  -0.737  -7.525  1.00  0.00
ATOM    500 3HG  MET    31      10.227   0.703  -6.495  1.00  0.00
ATOM    501  SD  MET    31       9.589  -1.245  -5.261  1.00 33.41
ATOM    502  CE  MET    31       8.790  -0.144  -4.094  1.00 40.45
ATOM    503 1HE  MET    31       8.673  -0.642  -3.132  1.00  0.00
ATOM    504 2HE  MET    31       9.400   0.751  -3.964  1.00  0.00
ATOM    505 3HE  MET    31       7.809   0.138  -4.476  1.00  0.00
ATOM    506  C   MET    31       6.874   1.336  -8.942  1.00 30.23
ATOM    507  O   MET    31       6.298   0.443  -9.563  1.00  3.40
ATOM    508  N   GLY    32       6.306   2.503  -8.668  1.00 21.22
ATOM    509  HN  GLY    32       6.813   3.211  -8.155  1.00  0.00
ATOM    510  CA  GLY    32       4.950   2.785  -9.099  1.00  3.34
ATOM    511 1HA  GLY    32       4.975   3.601  -9.822  1.00  0.00
ATOM    512 2HA  GLY    32       4.541   1.894  -9.575  1.00  0.00
ATOM    513  C   GLY    32       4.051   3.180  -7.947  1.00 64.11
ATOM    514  O   GLY    32       3.007   3.807  -8.151  1.00 43.22
ATOM    515  N   ILE    33       4.459   2.820  -6.733  1.00 63.23
ATOM    516  HN  ILE    33       5.320   2.304  -6.623  1.00  0.00
ATOM    517  CA  ILE    33       3.691   3.155  -5.540  1.00 55.11
ATOM    518  HA  ILE    33       2.652   2.875  -5.711  1.00  0.00
ATOM    519  CB  ILE    33       4.204   2.405  -4.292  1.00  3.13
ATOM    520  HB  ILE    33       5.160   2.840  -3.998  1.00  0.00
ATOM    521  CG2 ILE    33       3.223   2.571  -3.138  1.00 72.10
ATOM    522 1HG2 ILE    33       3.605   2.060  -2.255  1.00  0.00
ATOM    523 2HG2 ILE    33       3.100   3.632  -2.917  1.00  0.00
ATOM    524 3HG2 ILE    33       2.260   2.144  -3.417  1.00  0.00
ATOM    525  CG1 ILE    33       4.425   0.918  -4.599  1.00 61.44
ATOM    526 2HG1 ILE    33       5.148   0.840  -5.411  1.00  0.00
ATOM    527 3HG1 ILE    33       4.829   0.441  -3.706  1.00  0.00
ATOM    528  CD1 ILE    33       3.170   0.175  -5.008  1.00 31.52
ATOM    529 1HD1 ILE    33       3.393  -0.872  -5.213  1.00  0.00
ATOM    530 2HD1 ILE    33       2.439   0.233  -4.202  1.00  0.00
ATOM    531 3HD1 ILE    33       2.757   0.634  -5.907  1.00  0.00
ATOM    532  C   ILE    33       3.770   4.657  -5.294  1.00 33.21
ATOM    533  O   ILE    33       4.781   5.170  -4.817  1.00 62.34
ATOM    534  N   THR    34       2.709   5.360  -5.635  1.00 25.14
ATOM    535  HN  THR    34       1.854   4.892  -5.898  1.00  0.00
ATOM    536  CA  THR    34       2.738   6.808  -5.642  1.00 12.13
ATOM    537  HA  THR    34       3.684   7.128  -5.204  1.00  0.00
ATOM    538  CB  THR    34       2.672   7.320  -7.091  1.00  4.45
ATOM    539  HB  THR    34       2.235   8.319  -7.092  1.00  0.00
ATOM    540  OG1 THR    34       1.844   6.445  -7.875  1.00  0.23
ATOM    541 1HG  THR    34       1.801   6.785  -8.772  1.00  0.00
ATOM    542  CG2 THR    34       4.063   7.392  -7.704  1.00 51.22
ATOM    543 1HG2 THR    34       3.999   7.763  -8.727  1.00  0.00
ATOM    544 2HG2 THR    34       4.684   8.067  -7.114  1.00  0.00
ATOM    545 3HG2 THR    34       4.509   6.398  -7.708  1.00  0.00
ATOM    546  C   THR    34       1.605   7.409  -4.819  1.00 63.04
ATOM    547  O   THR    34       0.579   6.769  -4.591  1.00 72.21
ATOM    548  N   ARG    35       1.806   8.637  -4.362  1.00 70.22
ATOM    549  HN  ARG    35       2.674   9.112  -4.564  1.00  0.00
ATOM    550  CA  ARG    35       0.805   9.333  -3.567  1.00 21.30
ATOM    551  HA  ARG    35       0.503   8.682  -2.747  1.00  0.00
ATOM    552  CB  ARG    35       1.396  10.617  -2.978  1.00 35.44
ATOM    553 2HB  ARG    35       1.725  11.254  -3.800  1.00  0.00
ATOM    554 3HB  ARG    35       0.617  11.128  -2.412  1.00  0.00
ATOM    555  CG  ARG    35       2.581  10.373  -2.053  1.00 21.51
ATOM    556 2HG  ARG    35       2.245   9.789  -1.197  1.00  0.00
ATOM    557 3HG  ARG    35       3.344   9.816  -2.597  1.00  0.00
ATOM    558  CD  ARG    35       3.185  11.676  -1.553  1.00 62.41
ATOM    559 2HD  ARG    35       4.070  11.449  -0.958  1.00  0.00
ATOM    560 3HD  ARG    35       3.477  12.282  -2.411  1.00  0.00
ATOM    561  NE  ARG    35       2.248  12.441  -0.732  1.00 44.11
ATOM    562  HE  ARG    35       1.453  11.945  -0.356  1.00  0.00
ATOM    563  CZ  ARG    35       2.381  13.737  -0.455  1.00 13.24
ATOM    564  NH1 ARG    35       3.423  14.417  -0.922  1.00 23.11
ATOM    565 1HH1 ARG    35       3.524  15.399  -0.708  1.00  0.00
ATOM    566 2HH1 ARG    35       4.115  13.952  -1.492  1.00  0.00
ATOM    567  NH2 ARG    35       1.479  14.352   0.301  1.00 72.23
ATOM    568 1HH2 ARG    35       1.583  15.334   0.514  1.00  0.00
ATOM    569 2HH2 ARG    35       0.690  13.838   0.664  1.00  0.00
ATOM    570  C   ARG    35      -0.422   9.648  -4.415  1.00 73.33
ATOM    571  O   ARG    35      -0.386  10.523  -5.282  1.00 41.54
ATOM    572  N   GLY    36      -1.497   8.912  -4.177  1.00 30.55
ATOM    573  HN  GLY    36      -1.479   8.204  -3.457  1.00  0.00
ATOM    574  CA  GLY    36      -2.714   9.102  -4.936  1.00 74.03
ATOM    575 1HA  GLY    36      -3.494   9.458  -4.263  1.00  0.00
ATOM    576 2HA  GLY    36      -2.532   9.853  -5.706  1.00  0.00
ATOM    577  C   GLY    36      -3.188   7.826  -5.601  1.00 15.42
ATOM    578  O   GLY    36      -4.382   7.663  -5.855  1.00 54.02
ATOM    579  N   CYS    37      -2.265   6.913  -5.880  1.00  1.00
ATOM    580  HN  CYS    37      -1.298   7.074  -5.638  1.00  0.00
ATOM    581  CA  CYS    37      -2.627   5.665  -6.538  1.00  3.31
ATOM    582  HA  CYS    37      -3.274   5.903  -7.383  1.00  0.00
ATOM    583  CB  CYS    37      -1.384   4.936  -7.069  1.00 30.24
ATOM    584 2HB  CYS    37      -1.722   4.109  -7.693  1.00  0.00
ATOM    585 3HB  CYS    37      -0.815   5.642  -7.675  1.00  0.00
ATOM    586  SG  CYS    37      -0.291   4.275  -5.788  1.00  4.05
ATOM    587  HG  CYS    37       0.626   3.744  -6.603  1.00  0.00
ATOM    588  C   CYS    37      -3.393   4.765  -5.578  1.00 25.11
ATOM    589  O   CYS    37      -3.124   4.750  -4.371  1.00 71.03
ATOM    590  N   GLU    38      -4.357   4.035  -6.116  1.00 43.32
ATOM    591  HN  GLU    38      -4.556   4.116  -7.103  1.00  0.00
ATOM    592  CA  GLU    38      -5.146   3.110  -5.325  1.00  1.43
ATOM    593  HA  GLU    38      -5.216   3.496  -4.308  1.00  0.00
ATOM    594  CB  GLU    38      -6.561   2.992  -5.899  1.00 52.23
ATOM    595 2HB  GLU    38      -7.131   2.308  -5.271  1.00  0.00
ATOM    596 3HB  GLU    38      -7.025   3.978  -5.877  1.00  0.00
ATOM    597  CG  GLU    38      -6.598   2.477  -7.326  1.00 14.30
ATOM    598 2HG  GLU    38      -5.896   3.056  -7.927  1.00  0.00
ATOM    599 3HG  GLU    38      -6.294   1.431  -7.330  1.00  0.00
ATOM    600  CD  GLU    38      -7.974   2.587  -7.944  1.00 25.15
ATOM    601  OE1 GLU    38      -8.745   1.608  -7.881  1.00 65.40
ATOM    602  OE2 GLU    38      -8.290   3.663  -8.502  1.00 43.44
ATOM    603 2HE  GLU    38      -9.175   3.666  -8.874  1.00  0.00
ATOM    604  C   GLU    38      -4.465   1.751  -5.285  1.00  3.11
ATOM    605  O   GLU    38      -3.884   1.305  -6.279  1.00 71.51
ATOM    606  N   ILE    39      -4.520   1.108  -4.134  1.00 33.21
ATOM    607  HN  ILE    39      -5.015   1.516  -3.354  1.00  0.00
ATOM    608  CA  ILE    39      -3.887  -0.179  -3.950  1.00  2.24
ATOM    609  HA  ILE    39      -3.491  -0.503  -4.913  1.00  0.00
ATOM    610  CB  ILE    39      -2.723  -0.103  -2.938  1.00 41.43
ATOM    611  HB  ILE    39      -3.119   0.242  -1.983  1.00  0.00
ATOM    612  CG2 ILE    39      -2.109  -1.481  -2.735  1.00 50.33
ATOM    613 1HG2 ILE    39      -1.304  -1.420  -2.003  1.00  0.00
ATOM    614 2HG2 ILE    39      -2.874  -2.169  -2.376  1.00  0.00
ATOM    615 3HG2 ILE    39      -1.710  -1.843  -3.682  1.00  0.00
ATOM    616  CG1 ILE    39      -1.661   0.896  -3.409  1.00 52.30
ATOM    617 2HG1 ILE    39      -1.313   0.590  -4.396  1.00  0.00
ATOM    618 3HG1 ILE    39      -2.121   1.882  -3.476  1.00  0.00
ATOM    619  CD1 ILE    39      -0.463   0.989  -2.487  1.00 54.01
ATOM    620 1HD1 ILE    39       0.259   1.711  -2.870  1.00  0.00
ATOM    621 2HD1 ILE    39      -0.793   1.306  -1.498  1.00  0.00
ATOM    622 3HD1 ILE    39       0.014   0.012  -2.416  1.00  0.00
ATOM    623  C   ILE    39      -4.903  -1.201  -3.465  1.00 44.01
ATOM    624  O   ILE    39      -5.476  -1.061  -2.381  1.00  1.54
ATOM    625  N   TYR    40      -5.141  -2.214  -4.279  1.00  3.30
ATOM    626  HN  TYR    40      -4.721  -2.235  -5.197  1.00  0.00
ATOM    627  CA  TYR    40      -6.003  -3.309  -3.883  1.00 63.32
ATOM    628  HA  TYR    40      -6.730  -2.941  -3.159  1.00  0.00
ATOM    629  CB  TYR    40      -6.755  -3.872  -5.092  1.00 45.44
ATOM    630 2HB  TYR    40      -7.108  -3.039  -5.700  1.00  0.00
ATOM    631 3HB  TYR    40      -6.062  -4.469  -5.685  1.00  0.00
ATOM    632  CG  TYR    40      -7.942  -4.736  -4.723  1.00 73.12
ATOM    633  CD1 TYR    40      -9.180  -4.163  -4.471  1.00 62.21
ATOM    634 1HD  TYR    40      -9.292  -3.091  -4.539  1.00  0.00
ATOM    635  CE1 TYR    40     -10.271  -4.938  -4.135  1.00  3.24
ATOM    636 1HE  TYR    40     -11.227  -4.474  -3.944  1.00  0.00
ATOM    637  CZ  TYR    40     -10.135  -6.306  -4.044  1.00 43.21
ATOM    638  CE2 TYR    40      -8.916  -6.902  -4.291  1.00 70.42
ATOM    639 2HE  TYR    40      -8.812  -7.974  -4.223  1.00  0.00
ATOM    640  CD2 TYR    40      -7.827  -6.119  -4.627  1.00 10.11
ATOM    641 2HD  TYR    40      -6.873  -6.588  -4.818  1.00  0.00
ATOM    642  OH  TYR    40     -11.226  -7.077  -3.711  1.00 44.11
ATOM    643  HH  TYR    40     -11.024  -8.015  -3.677  1.00  0.00
ATOM    644  C   TYR    40      -5.154  -4.390  -3.234  1.00 13.02
ATOM    645  O   TYR    40      -4.362  -5.053  -3.909  1.00 51.30
ATOM    646  N   ILE    41      -5.290  -4.538  -1.924  1.00 21.31
ATOM    647  HN  ILE    41      -5.957  -3.972  -1.419  1.00  0.00
ATOM    648  CA  ILE    41      -4.495  -5.508  -1.181  1.00 62.32
ATOM    649  HA  ILE    41      -3.448  -5.366  -1.450  1.00  0.00
ATOM    650  CB  ILE    41      -4.637  -5.328   0.349  1.00 20.44
ATOM    651  HB  ILE    41      -5.601  -5.731   0.657  1.00  0.00
ATOM    652  CG2 ILE    41      -3.533  -6.093   1.074  1.00  2.14
ATOM    653 1HG2 ILE    41      -3.652  -5.978   2.151  1.00  0.00
ATOM    654 2HG2 ILE    41      -3.593  -7.149   0.814  1.00  0.00
ATOM    655 3HG2 ILE    41      -2.562  -5.699   0.773  1.00  0.00
ATOM    656  CG1 ILE    41      -4.584  -3.843   0.731  1.00 64.40
ATOM    657 2HG1 ILE    41      -5.380  -3.323   0.198  1.00  0.00
ATOM    658 3HG1 ILE    41      -4.750  -3.759   1.805  1.00  0.00
ATOM    659  CD1 ILE    41      -3.270  -3.168   0.399  1.00 63.01
ATOM    660 1HD1 ILE    41      -3.293  -2.118   0.691  1.00  0.00
ATOM    661 2HD1 ILE    41      -2.463  -3.669   0.933  1.00  0.00
ATOM    662 3HD1 ILE    41      -3.092  -3.235  -0.674  1.00  0.00
ATOM    663  C   ILE    41      -4.919  -6.920  -1.568  1.00 13.20
ATOM    664  O   ILE    41      -6.043  -7.337  -1.286  1.00 12.23
ATOM    665  N   ARG    42      -4.018  -7.644  -2.216  1.00 23.12
ATOM    666  HN  ARG    42      -3.074  -7.298  -2.317  1.00  0.00
ATOM    667  CA  ARG    42      -4.347  -8.938  -2.797  1.00 33.32
ATOM    668  HA  ARG    42      -5.398  -8.926  -3.084  1.00  0.00
ATOM    669  CB  ARG    42      -3.499  -9.179  -4.053  1.00 51.44
ATOM    670 2HB  ARG    42      -2.452  -9.240  -3.756  1.00  0.00
ATOM    671 3HB  ARG    42      -3.806 -10.124  -4.501  1.00  0.00
ATOM    672  CG  ARG    42      -3.640  -8.082  -5.100  1.00 53.22
ATOM    673 2HG  ARG    42      -3.470  -7.116  -4.624  1.00  0.00
ATOM    674 3HG  ARG    42      -2.893  -8.239  -5.879  1.00  0.00
ATOM    675  CD  ARG    42      -5.020  -8.080  -5.736  1.00  0.31
ATOM    676 2HD  ARG    42      -5.770  -8.205  -4.955  1.00  0.00
ATOM    677 3HD  ARG    42      -5.178  -7.123  -6.235  1.00  0.00
ATOM    678  NE  ARG    42      -5.171  -9.154  -6.713  1.00 34.30
ATOM    679  HE  ARG    42      -4.334  -9.472  -7.180  1.00  0.00
ATOM    680  CZ  ARG    42      -6.331  -9.732  -7.021  1.00 35.42
ATOM    681  NH1 ARG    42      -7.449  -9.360  -6.411  1.00 62.03
ATOM    682 1HH1 ARG    42      -8.326  -9.801  -6.647  1.00  0.00
ATOM    683 2HH1 ARG    42      -7.423  -8.633  -5.710  1.00  0.00
ATOM    684  NH2 ARG    42      -6.371 -10.690  -7.939  1.00 63.43
ATOM    685 1HH2 ARG    42      -7.249 -11.130  -8.173  1.00  0.00
ATOM    686 2HH2 ARG    42      -5.522 -10.979  -8.404  1.00  0.00
ATOM    687  C   ARG    42      -4.132 -10.064  -1.789  1.00 23.04
ATOM    688  O   ARG    42      -5.055 -10.819  -1.484  1.00 30.54
ATOM    689  N   LYS    43      -2.924 -10.163  -1.259  1.00 21.21
ATOM    690  HN  LYS    43      -2.216  -9.477  -1.480  1.00  0.00
ATOM    691  CA  LYS    43      -2.583 -11.250  -0.353  1.00 23.34
ATOM    692  HA  LYS    43      -3.489 -11.562   0.166  1.00  0.00
ATOM    693  CB  LYS    43      -2.038 -12.441  -1.153  1.00 24.53
ATOM    694 2HB  LYS    43      -2.839 -12.821  -1.786  1.00  0.00
ATOM    695 3HB  LYS    43      -1.218 -12.085  -1.778  1.00  0.00
ATOM    696  CG  LYS    43      -1.521 -13.589  -0.299  1.00  2.03
ATOM    697 2HG  LYS    43      -1.134 -14.369  -0.955  1.00  0.00
ATOM    698 3HG  LYS    43      -0.718 -13.219   0.339  1.00  0.00
ATOM    699  CD  LYS    43      -2.612 -14.181   0.577  1.00 65.05
ATOM    700 2HD  LYS    43      -2.981 -13.411   1.255  1.00  0.00
ATOM    701 3HD  LYS    43      -3.427 -14.528  -0.057  1.00  0.00
ATOM    702  CE  LYS    43      -2.085 -15.348   1.392  1.00 31.24
ATOM    703 2HE  LYS    43      -1.771 -16.140   0.712  1.00  0.00
ATOM    704 3HE  LYS    43      -1.226 -15.013   1.973  1.00  0.00
ATOM    705  NZ  LYS    43      -3.111 -15.889   2.319  1.00 73.11
ATOM    706 1HZ  LYS    43      -2.725 -16.661   2.842  1.00  0.00
ATOM    707 2HZ  LYS    43      -3.402 -15.163   2.958  1.00  0.00
ATOM    708 3HZ  LYS    43      -3.908 -16.209   1.787  1.00  0.00
ATOM    709  C   LYS    43      -1.562 -10.798   0.684  1.00 65.14
ATOM    710  O   LYS    43      -0.491 -10.307   0.339  1.00 52.44
ATOM    711  N   VAL    44      -1.904 -10.951   1.953  1.00 34.22
ATOM    712  HN  VAL    44      -2.826 -11.288   2.190  1.00  0.00
ATOM    713  CA  VAL    44      -0.980 -10.644   3.030  1.00 11.25
ATOM    714  HA  VAL    44      -0.116 -10.132   2.606  1.00  0.00
ATOM    715  CB  VAL    44      -1.624  -9.729   4.095  1.00 33.34
ATOM    716  HB  VAL    44      -2.470 -10.260   4.531  1.00  0.00
ATOM    717  CG1 VAL    44      -0.638  -9.411   5.210  1.00 31.30
ATOM    718 1HG1 VAL    44      -1.117  -8.785   5.962  1.00  0.00
ATOM    719 2HG1 VAL    44      -0.303 -10.339   5.673  1.00  0.00
ATOM    720 3HG1 VAL    44       0.220  -8.882   4.795  1.00  0.00
ATOM    721  CG2 VAL    44      -2.143  -8.448   3.463  1.00 31.24
ATOM    722 1HG2 VAL    44      -2.616  -7.825   4.222  1.00  0.00
ATOM    723 2HG2 VAL    44      -1.312  -7.902   3.016  1.00  0.00
ATOM    724 3HG2 VAL    44      -2.872  -8.694   2.691  1.00  0.00
ATOM    725  C   VAL    44      -0.521 -11.935   3.689  1.00  1.33
ATOM    726  O   VAL    44      -1.344 -12.719   4.171  1.00 75.45
ATOM    727  N   ALA    45       0.784 -12.167   3.682  1.00 33.23
ATOM    728  HN  ALA    45       1.411 -11.505   3.246  1.00  0.00
ATOM    729  CA  ALA    45       1.350 -13.362   4.289  1.00  4.52
ATOM    730  HA  ALA    45       0.819 -14.228   3.896  1.00  0.00
ATOM    731  CB  ALA    45       2.821 -13.490   3.924  1.00 33.24
ATOM    732 1HB  ALA    45       3.231 -14.401   4.359  1.00  0.00
ATOM    733 2HB  ALA    45       2.924 -13.529   2.839  1.00  0.00
ATOM    734 3HB  ALA    45       3.367 -12.628   4.309  1.00  0.00
ATOM    735  C   ALA    45       1.174 -13.333   5.806  1.00 31.22
ATOM    736  O   ALA    45       1.238 -12.270   6.420  1.00 73.05
ATOM    770  N   GLY    48       3.404 -11.491   7.989  1.00 30.10
ATOM    771  HN  GLY    48       2.708 -12.044   7.511  1.00  0.00
ATOM    772  CA  GLY    48       3.350 -10.052   7.866  1.00 74.31
ATOM    773 1HA  GLY    48       2.307  -9.737   7.830  1.00  0.00
ATOM    774 2HA  GLY    48       3.833  -9.603   8.734  1.00  0.00
ATOM    775  C   GLY    48       4.051  -9.579   6.613  1.00 24.03
ATOM    776  O   GLY    48       3.814  -8.472   6.133  1.00 15.43
ATOM    777  N   ASP    49       4.903 -10.440   6.079  1.00 11.02
ATOM    778  HN  ASP    49       5.015 -11.352   6.498  1.00  0.00
ATOM    779  CA  ASP    49       5.695 -10.127   4.902  1.00 52.24
ATOM    780  HA  ASP    49       5.179  -9.360   4.324  1.00  0.00
ATOM    781  CB  ASP    49       7.062  -9.593   5.329  1.00 50.22
ATOM    782 2HB  ASP    49       6.916  -8.690   5.922  1.00  0.00
ATOM    783 3HB  ASP    49       7.558 -10.347   5.940  1.00  0.00
ATOM    784  CG  ASP    49       7.950  -9.263   4.152  1.00 14.31
ATOM    785  OD1 ASP    49       7.699  -8.239   3.491  1.00  4.41
ATOM    786  OD2 ASP    49       8.911 -10.016   3.892  1.00 61.05
ATOM    787 2HD  ASP    49       9.432  -9.741   3.134  1.00  0.00
ATOM    788  C   ASP    49       5.863 -11.371   4.037  1.00 11.41
ATOM    789  O   ASP    49       6.006 -12.478   4.563  1.00 62.34
ATOM    790  N   PRO    50       5.823 -11.222   2.702  1.00 53.04
ATOM    791  CD  PRO    50       6.050 -12.295   1.724  1.00  2.02
ATOM    792  CA  PRO    50       5.574  -9.945   2.041  1.00 31.54
ATOM    793  HA  PRO    50       5.968  -9.118   2.633  1.00  0.00
ATOM    794  CB  PRO    50       6.353 -10.099   0.737  1.00 11.21
ATOM    795 2HB  PRO    50       5.927  -9.493  -0.063  1.00  0.00
ATOM    796 3HB  PRO    50       7.393  -9.825   0.916  1.00  0.00
ATOM    797  CG  PRO    50       6.292 -11.561   0.421  1.00 50.44
ATOM    798 2HG  PRO    50       5.435 -11.730  -0.230  1.00  0.00
ATOM    799 3HG  PRO    50       7.212 -11.899  -0.056  1.00  0.00
ATOM    800 2HD  PRO    50       5.190 -12.960   1.646  1.00  0.00
ATOM    801 3HD  PRO    50       6.940 -12.857   2.006  1.00  0.00
ATOM    802  C   PRO    50       4.092  -9.703   1.765  1.00 62.31
ATOM    803  O   PRO    50       3.257 -10.595   1.941  1.00 32.31
ATOM    804  N   ILE    51       3.769  -8.496   1.332  1.00 72.31
ATOM    805  HN  ILE    51       4.486  -7.795   1.205  1.00  0.00
ATOM    806  CA  ILE    51       2.393  -8.145   1.028  1.00 32.51
ATOM    807  HA  ILE    51       1.750  -8.940   1.405  1.00  0.00
ATOM    808  CB  ILE    51       1.989  -6.822   1.716  1.00 15.23
ATOM    809  HB  ILE    51       2.664  -6.036   1.376  1.00  0.00
ATOM    810  CG2 ILE    51       0.565  -6.425   1.342  1.00 14.23
ATOM    811 1HG2 ILE    51       0.306  -5.481   1.822  1.00  0.00
ATOM    812 2HG2 ILE    51       0.493  -6.311   0.260  1.00  0.00
ATOM    813 3HG2 ILE    51      -0.126  -7.200   1.672  1.00  0.00
ATOM    814  CG1 ILE    51       2.127  -6.960   3.234  1.00 60.52
ATOM    815 2HG1 ILE    51       1.470  -7.763   3.567  1.00  0.00
ATOM    816 3HG1 ILE    51       3.161  -7.217   3.463  1.00  0.00
ATOM    817  CD1 ILE    51       1.768  -5.703   3.996  1.00 22.22
ATOM    818 1HD1 ILE    51       1.884  -5.859   5.068  1.00  0.00
ATOM    819 2HD1 ILE    51       2.424  -4.891   3.681  1.00  0.00
ATOM    820 3HD1 ILE    51       0.733  -5.436   3.783  1.00  0.00
ATOM    821  C   ILE    51       2.190  -8.028  -0.481  1.00 72.54
ATOM    822  O   ILE    51       2.812  -7.192  -1.138  1.00 22.10
ATOM    823  N   GLN    52       1.333  -8.884  -1.025  1.00 34.43
ATOM    824  HN  GLN    52       0.876  -9.571  -0.443  1.00  0.00
ATOM    825  CA  GLN    52       1.024  -8.869  -2.448  1.00 15.41
ATOM    826  HA  GLN    52       1.927  -8.589  -2.991  1.00  0.00
ATOM    827  CB  GLN    52       0.566 -10.252  -2.938  1.00 71.34
ATOM    828 2HB  GLN    52      -0.198 -10.618  -2.252  1.00  0.00
ATOM    829 3HB  GLN    52       0.135 -10.133  -3.932  1.00  0.00
ATOM    830  CG  GLN    52       1.670 -11.305  -3.023  1.00  4.11
ATOM    831 2HG  GLN    52       1.285 -12.166  -3.569  1.00  0.00
ATOM    832 3HG  GLN    52       2.511 -10.880  -3.571  1.00  0.00
ATOM    833  CD  GLN    52       2.168 -11.777  -1.668  1.00 53.41
ATOM    834  OE1 GLN    52       1.624 -12.713  -1.088  1.00  5.20
ATOM    835  NE2 GLN    52       3.228 -11.162  -1.176  1.00 34.13
ATOM    836 1HE2 GLN    52       3.653 -10.405  -1.692  1.00  0.00
ATOM    837 2HE2 GLN    52       3.611 -11.449  -0.287  1.00  0.00
ATOM    838  C   GLN    52      -0.063  -7.842  -2.733  1.00 61.21
ATOM    839  O   GLN    52      -1.165  -7.916  -2.182  1.00  0.50
ATOM    840  N   ILE    53       0.252  -6.888  -3.590  1.00 42.44
ATOM    841  HN  ILE    53       1.160  -6.894  -4.034  1.00  0.00
ATOM    842  CA  ILE    53      -0.670  -5.816  -3.924  1.00 13.15
ATOM    843  HA  ILE    53      -1.668  -6.117  -3.607  1.00  0.00
ATOM    844  CB  ILE    53      -0.298  -4.502  -3.199  1.00 55.32
ATOM    845  HB  ILE    53      -0.931  -3.705  -3.590  1.00  0.00
ATOM    846  CG2 ILE    53      -0.555  -4.625  -1.703  1.00 54.10
ATOM    847 1HG2 ILE    53      -0.312  -3.684  -1.209  1.00  0.00
ATOM    848 2HG2 ILE    53      -1.605  -4.861  -1.534  1.00  0.00
ATOM    849 3HG2 ILE    53       0.067  -5.420  -1.293  1.00  0.00
ATOM    850  CG1 ILE    53       1.165  -4.130  -3.471  1.00 73.23
ATOM    851 2HG1 ILE    53       1.800  -4.927  -3.085  1.00  0.00
ATOM    852 3HG1 ILE    53       1.304  -4.044  -4.549  1.00  0.00
ATOM    853  CD1 ILE    53       1.594  -2.826  -2.830  1.00 42.51
ATOM    854 1HD1 ILE    53       2.640  -2.614  -3.056  1.00  0.00
ATOM    855 2HD1 ILE    53       0.975  -2.015  -3.214  1.00  0.00
ATOM    856 3HD1 ILE    53       1.470  -2.897  -1.750  1.00  0.00
ATOM    857  C   ILE    53      -0.685  -5.570  -5.426  1.00  4.23
ATOM    858  O   ILE    53       0.305  -5.821  -6.114  1.00 23.24
ATOM    859  N   ASN    54      -1.813  -5.098  -5.931  1.00  5.12
ATOM    860  HN  ASN    54      -2.615  -4.958  -5.334  1.00  0.00
ATOM    861  CA  ASN    54      -1.930  -4.769  -7.343  1.00 30.22
ATOM    862  HA  ASN    54      -1.030  -5.111  -7.855  1.00  0.00
ATOM    863  CB  ASN    54      -3.142  -5.471  -7.968  1.00 62.43
ATOM    864 2HB  ASN    54      -3.110  -6.526  -7.697  1.00  0.00
ATOM    865 3HB  ASN    54      -4.050  -5.023  -7.564  1.00  0.00
ATOM    866  CG  ASN    54      -3.182  -5.360  -9.486  1.00 23.35
ATOM    867  OD1 ASN    54      -2.770  -4.358 -10.072  1.00 35.11
ATOM    868  ND2 ASN    54      -3.672  -6.405 -10.138  1.00 41.54
ATOM    869 1HD2 ASN    54      -3.996  -7.211  -9.624  1.00  0.00
ATOM    870 2HD2 ASN    54      -3.719  -6.393 -11.147  1.00  0.00
ATOM    871  C   ASN    54      -2.039  -3.262  -7.502  1.00 22.34
ATOM    872  O   ASN    54      -3.026  -2.650  -7.083  1.00 73.05
ATOM    873  N   VAL    55      -1.006  -2.671  -8.082  1.00 75.43
ATOM    874  HN  VAL    55      -0.240  -3.232  -8.426  1.00  0.00
ATOM    875  CA  VAL    55      -0.928  -1.229  -8.246  1.00 71.34
ATOM    876  HA  VAL    55      -1.902  -0.804  -8.003  1.00  0.00
ATOM    877  CB  VAL    55       0.133  -0.606  -7.310  1.00 33.34
ATOM    878  HB  VAL    55       1.113  -0.967  -7.622  1.00  0.00
ATOM    879  CG1 VAL    55       0.132   0.912  -7.419  1.00 22.32
ATOM    880 1HG1 VAL    55       0.903   1.331  -6.772  1.00  0.00
ATOM    881 2HG1 VAL    55       0.331   1.202  -8.451  1.00  0.00
ATOM    882 3HG1 VAL    55      -0.842   1.297  -7.116  1.00  0.00
ATOM    883  CG2 VAL    55      -0.094  -1.039  -5.872  1.00 73.44
ATOM    884 1HG2 VAL    55       0.678  -0.612  -5.231  1.00  0.00
ATOM    885 2HG2 VAL    55      -1.072  -0.692  -5.540  1.00  0.00
ATOM    886 3HG2 VAL    55      -0.054  -2.126  -5.811  1.00  0.00
ATOM    887  C   VAL    55      -0.581  -0.881  -9.688  1.00 52.14
ATOM    888  O   VAL    55       0.349  -1.448 -10.263  1.00 20.40
ATOM    889  N   ARG    56      -1.348   0.041 -10.269  1.00 30.54
ATOM    890  HN  ARG    56      -2.121   0.437  -9.754  1.00  0.00
ATOM    891  CA  ARG    56      -1.120   0.514 -11.639  1.00 51.31
ATOM    892  HA  ARG    56      -1.862   1.282 -11.857  1.00  0.00
ATOM    893  CB  ARG    56       0.277   1.135 -11.773  1.00 23.31
ATOM    894 2HB  ARG    56       1.016   0.360 -11.570  1.00  0.00
ATOM    895 3HB  ARG    56       0.395   1.490 -12.797  1.00  0.00
ATOM    896  CG  ARG    56       0.541   2.303 -10.832  1.00 62.31
ATOM    897 2HG  ARG    56       0.416   1.963  -9.804  1.00  0.00
ATOM    898 3HG  ARG    56       1.564   2.650 -10.978  1.00  0.00
ATOM    899  CD  ARG    56      -0.411   3.460 -11.087  1.00 42.41
ATOM    900 2HD  ARG    56      -0.399   3.701 -12.150  1.00  0.00
ATOM    901 3HD  ARG    56      -1.418   3.160 -10.800  1.00  0.00
ATOM    902  NE  ARG    56      -0.036   4.653 -10.326  1.00  4.24
ATOM    903  HE  ARG    56       0.587   4.524  -9.541  1.00  0.00
ATOM    904  CZ  ARG    56      -0.465   5.885 -10.609  1.00 43.14
ATOM    905  NH1 ARG    56      -1.314   6.077 -11.610  1.00 63.41
ATOM    906 1HH1 ARG    56      -1.640   7.009 -11.825  1.00  0.00
ATOM    907 2HH1 ARG    56      -1.634   5.292 -12.158  1.00  0.00
ATOM    908  NH2 ARG    56      -0.049   6.924  -9.892  1.00 51.54
ATOM    909 1HH2 ARG    56      -0.377   7.855 -10.110  1.00  0.00
ATOM    910 2HH2 ARG    56       0.597   6.784  -9.128  1.00  0.00
ATOM    911  C   ARG    56      -1.282  -0.618 -12.658  1.00  4.53
ATOM    912  O   ARG    56      -0.865  -0.492 -13.809  1.00 23.23
ATOM    913  N   GLY    57      -1.895  -1.715 -12.233  1.00 73.14
ATOM    914  HN  GLY    57      -2.234  -1.773 -11.284  1.00  0.00
ATOM    915  CA  GLY    57      -2.091  -2.848 -13.115  1.00 35.31
ATOM    916 1HA  GLY    57      -3.079  -3.269 -12.931  1.00  0.00
ATOM    917 2HA  GLY    57      -2.032  -2.503 -14.148  1.00  0.00
ATOM    918  C   GLY    57      -1.051  -3.927 -12.900  1.00 64.14
ATOM    919  O   GLY    57      -1.142  -5.016 -13.474  1.00 42.35
ATOM    920  N   TYR    58      -0.058  -3.632 -12.072  1.00  2.31
ATOM    921  HN  TYR    58      -0.016  -2.720 -11.639  1.00  0.00
ATOM    922  CA  TYR    58       0.987  -4.594 -11.767  1.00 75.35
ATOM    923  HA  TYR    58       0.988  -5.367 -12.535  1.00  0.00
ATOM    924  CB  TYR    58       2.360  -3.910 -11.743  1.00 75.12
ATOM    925 2HB  TYR    58       2.411  -3.270 -10.862  1.00  0.00
ATOM    926 3HB  TYR    58       3.128  -4.679 -11.662  1.00  0.00
ATOM    927  CG  TYR    58       2.658  -3.066 -12.963  1.00 71.43
ATOM    928  CD1 TYR    58       2.429  -1.695 -12.953  1.00 24.05
ATOM    929 1HD  TYR    58       2.032  -1.230 -12.063  1.00  0.00
ATOM    930  CE1 TYR    58       2.701  -0.916 -14.061  1.00 21.41
ATOM    931 1HE  TYR    58       2.519   0.149 -14.035  1.00  0.00
ATOM    932  CZ  TYR    58       3.206  -1.504 -15.198  1.00 52.22
ATOM    933  CE2 TYR    58       3.443  -2.864 -15.233  1.00 71.21
ATOM    934 2HE  TYR    58       3.842  -3.322 -16.126  1.00  0.00
ATOM    935  CD2 TYR    58       3.168  -3.636 -14.120  1.00 63.43
ATOM    936 2HD  TYR    58       3.354  -4.699 -14.152  1.00  0.00
ATOM    937  OH  TYR    58       3.481  -0.729 -16.301  1.00  1.03
ATOM    938  HH  TYR    58       3.830  -1.236 -17.038  1.00  0.00
ATOM    939  C   TYR    58       0.718  -5.230 -10.411  1.00 14.14
ATOM    940  O   TYR    58       0.517  -4.528  -9.421  1.00 11.24
ATOM    941  N   GLU    59       0.726  -6.549 -10.364  1.00 53.21
ATOM    942  HN  GLU    59       0.863  -7.086 -11.208  1.00  0.00
ATOM    943  CA  GLU    59       0.542  -7.253  -9.111  1.00 72.32
ATOM    944  HA  GLU    59       0.152  -6.552  -8.373  1.00  0.00
ATOM    945  CB  GLU    59      -0.464  -8.384  -9.277  1.00 21.34
ATOM    946 2HB  GLU    59      -1.363  -7.975  -9.737  1.00  0.00
ATOM    947 3HB  GLU    59      -0.028  -9.135  -9.936  1.00  0.00
ATOM    948  CG  GLU    59      -0.860  -9.063  -7.978  1.00 50.34
ATOM    949 2HG  GLU    59       0.004  -9.596  -7.582  1.00  0.00
ATOM    950 3HG  GLU    59      -1.169  -8.301  -7.263  1.00  0.00
ATOM    951  CD  GLU    59      -1.997 -10.046  -8.169  1.00 11.43
ATOM    952  OE1 GLU    59      -1.748 -11.270  -8.169  1.00 32.42
ATOM    953  OE2 GLU    59      -3.148  -9.597  -8.329  1.00 24.44
ATOM    954 2HE  GLU    59      -3.819 -10.272  -8.447  1.00  0.00
ATOM    955  C   GLU    59       1.883  -7.773  -8.626  1.00 14.44
ATOM    956  O   GLU    59       2.507  -8.630  -9.254  1.00 31.01
ATOM    957  N   LEU    60       2.317  -7.241  -7.510  1.00 74.52
ATOM    958  HN  LEU    60       1.712  -6.636  -6.972  1.00  0.00
ATOM    959  CA  LEU    60       3.660  -7.496  -7.014  1.00 72.24
ATOM    960  HA  LEU    60       4.021  -8.417  -7.471  1.00  0.00
ATOM    961  CB  LEU    60       4.599  -6.347  -7.428  1.00 22.23
ATOM    962 2HB  LEU    60       5.542  -6.478  -6.896  1.00  0.00
ATOM    963 3HB  LEU    60       4.773  -6.429  -8.501  1.00  0.00
ATOM    964  CG  LEU    60       4.092  -4.922  -7.141  1.00 32.14
ATOM    965  HG  LEU    60       3.029  -4.886  -7.378  1.00  0.00
ATOM    966  CD1 LEU    60       4.262  -4.554  -5.672  1.00 70.41
ATOM    967 1HD1 LEU    60       3.877  -3.550  -5.492  1.00  0.00
ATOM    968 2HD1 LEU    60       3.714  -5.266  -5.055  1.00  0.00
ATOM    969 3HD1 LEU    60       5.320  -4.585  -5.411  1.00  0.00
ATOM    970  CD2 LEU    60       4.813  -3.917  -8.025  1.00 62.34
ATOM    971 1HD2 LEU    60       4.428  -2.915  -7.836  1.00  0.00
ATOM    972 2HD2 LEU    60       5.881  -3.940  -7.805  1.00  0.00
ATOM    973 3HD2 LEU    60       4.652  -4.174  -9.072  1.00  0.00
ATOM    974  C   LEU    60       3.667  -7.679  -5.505  1.00  2.23
ATOM    975  O   LEU    60       2.642  -7.519  -4.844  1.00 52.31
ATOM    976  N   SER    61       4.828  -8.020  -4.972  1.00 74.25
ATOM    977  HN  SER    61       5.627  -8.181  -5.569  1.00  0.00
ATOM    978  CA  SER    61       4.995  -8.170  -3.542  1.00 63.23
ATOM    979  HA  SER    61       4.012  -8.161  -3.072  1.00  0.00
ATOM    980  CB  SER    61       5.683  -9.497  -3.229  1.00 42.21
ATOM    981 2HB  SER    61       6.687  -9.486  -3.654  1.00  0.00
ATOM    982 3HB  SER    61       5.748  -9.618  -2.148  1.00  0.00
ATOM    983  OG  SER    61       4.962 -10.591  -3.774  1.00 23.41
ATOM    984  HG  SER    61       5.421 -11.406  -3.559  1.00  0.00
ATOM    985  C   SER    61       5.819  -7.015  -2.991  1.00 23.22
ATOM    986  O   SER    61       6.931  -6.758  -3.455  1.00 22.24
ATOM    987  N   LEU    62       5.266  -6.313  -2.021  1.00 12.43
ATOM    988  HN  LEU    62       4.330  -6.531  -1.711  1.00  0.00
ATOM    989  CA  LEU    62       5.971  -5.222  -1.377  1.00 51.32
ATOM    990  HA  LEU    62       6.855  -4.980  -1.968  1.00  0.00
ATOM    991  CB  LEU    62       5.083  -3.979  -1.295  1.00 61.11
ATOM    992 2HB  LEU    62       4.769  -3.723  -2.307  1.00  0.00
ATOM    993 3HB  LEU    62       4.209  -4.229  -0.695  1.00  0.00
ATOM    994  CG  LEU    62       5.742  -2.741  -0.677  1.00 32.54
ATOM    995  HG  LEU    62       6.151  -3.019   0.294  1.00  0.00
ATOM    996  CD1 LEU    62       6.885  -2.240  -1.549  1.00 41.21
ATOM    997 1HD1 LEU    62       7.354  -1.372  -1.084  1.00  0.00
ATOM    998 2HD1 LEU    62       7.626  -3.031  -1.665  1.00  0.00
ATOM    999 3HD1 LEU    62       6.498  -1.959  -2.529  1.00  0.00
ATOM   1000  CD2 LEU    62       4.713  -1.644  -0.467  1.00 23.13
ATOM   1001 1HD2 LEU    62       5.186  -0.777  -0.005  1.00  0.00
ATOM   1002 2HD2 LEU    62       4.291  -1.354  -1.429  1.00  0.00
ATOM   1003 3HD2 LEU    62       3.919  -2.011   0.183  1.00  0.00
ATOM   1004  C   LEU    62       6.408  -5.654   0.011  1.00 31.25
ATOM   1005  O   LEU    62       5.637  -6.276   0.748  1.00 74.34
ATOM   1006  N   ARG    63       7.653  -5.354   0.346  1.00 72.31
ATOM   1007  HN  ARG    63       8.242  -4.855  -0.306  1.00  0.00
ATOM   1008  CA  ARG    63       8.209  -5.723   1.634  1.00  1.32
ATOM   1009  HA  ARG    63       8.070  -6.794   1.778  1.00  0.00
ATOM   1010  CB  ARG    63       9.705  -5.411   1.673  1.00 14.24
ATOM   1011 2HB  ARG    63      10.103  -5.508   0.663  1.00  0.00
ATOM   1012 3HB  ARG    63       9.833  -4.384   2.017  1.00  0.00
ATOM   1013  CG  ARG    63      10.497  -6.325   2.590  1.00 34.41
ATOM   1014 2HG  ARG    63      11.554  -6.068   2.522  1.00  0.00
ATOM   1015 3HG  ARG    63      10.155  -6.184   3.615  1.00  0.00
ATOM   1016  CD  ARG    63      10.315  -7.783   2.201  1.00 15.20
ATOM   1017 2HD  ARG    63      10.006  -8.343   3.083  1.00  0.00
ATOM   1018 3HD  ARG    63       9.534  -7.846   1.444  1.00  0.00
ATOM   1019  NE  ARG    63      11.532  -8.390   1.667  1.00 23.14
ATOM   1020  HE  ARG    63      12.225  -7.771   1.268  1.00  0.00
ATOM   1021  CZ  ARG    63      11.769  -9.703   1.681  1.00 34.00
ATOM   1022  NH1 ARG    63      10.905 -10.538   2.250  1.00 30.12
ATOM   1023 1HH1 ARG    63      11.093 -11.530   2.262  1.00  0.00
ATOM   1024 2HH1 ARG    63      10.060 -10.179   2.670  1.00  0.00
ATOM   1025  NH2 ARG    63      12.885 -10.177   1.142  1.00 65.32
ATOM   1026 1HH2 ARG    63      13.070 -11.169   1.156  1.00  0.00
ATOM   1027 2HH2 ARG    63      13.550  -9.545   0.718  1.00  0.00
ATOM   1028  C   ARG    63       7.490  -4.979   2.751  1.00 54.04
ATOM   1029  O   ARG    63       7.207  -3.782   2.631  1.00 41.32
ATOM   1030  N   LYS    64       7.194  -5.697   3.826  1.00 42.41
ATOM   1031  HN  LYS    64       7.451  -6.673   3.857  1.00  0.00
ATOM   1032  CA  LYS    64       6.506  -5.131   4.978  1.00 13.22
ATOM   1033  HA  LYS    64       5.521  -4.794   4.656  1.00  0.00
ATOM   1034  CB  LYS    64       6.322  -6.207   6.060  1.00 51.34
ATOM   1035 2HB  LYS    64       5.863  -7.080   5.597  1.00  0.00
ATOM   1036 3HB  LYS    64       7.306  -6.474   6.446  1.00  0.00
ATOM   1037  CG  LYS    64       5.451  -5.776   7.233  1.00 41.41
ATOM   1038 2HG  LYS    64       4.672  -5.108   6.865  1.00  0.00
ATOM   1039 3HG  LYS    64       4.993  -6.660   7.674  1.00  0.00
ATOM   1040  CD  LYS    64       6.251  -5.053   8.304  1.00 32.31
ATOM   1041 2HD  LYS    64       7.058  -4.497   7.826  1.00  0.00
ATOM   1042 3HD  LYS    64       5.593  -4.359   8.827  1.00  0.00
ATOM   1043  CE  LYS    64       6.850  -6.018   9.314  1.00 34.43
ATOM   1044 2HE  LYS    64       6.045  -6.569   9.799  1.00  0.00
ATOM   1045 3HE  LYS    64       7.501  -6.719   8.792  1.00  0.00
ATOM   1046  NZ  LYS    64       7.640  -5.305  10.350  1.00 21.10
ATOM   1047 1HZ  LYS    64       8.024  -5.972  11.004  1.00  0.00
ATOM   1048 2HZ  LYS    64       8.393  -4.797   9.908  1.00  0.00
ATOM   1049 3HZ  LYS    64       7.042  -4.658  10.843  1.00  0.00
ATOM   1050  C   LYS    64       7.270  -3.928   5.525  1.00 20.34
ATOM   1051  O   LYS    64       6.670  -3.002   6.063  1.00 13.53
ATOM   1052  N   SER    65       8.588  -3.943   5.363  1.00 44.33
ATOM   1053  HN  SER    65       9.030  -4.744   4.935  1.00  0.00
ATOM   1054  CA  SER    65       9.431  -2.832   5.783  1.00 15.40
ATOM   1055  HA  SER    65       9.404  -2.762   6.870  1.00  0.00
ATOM   1056  CB  SER    65      10.867  -3.094   5.338  1.00  2.23
ATOM   1057 2HB  SER    65      10.933  -2.985   4.255  1.00  0.00
ATOM   1058 3HB  SER    65      11.529  -2.372   5.817  1.00  0.00
ATOM   1059  OG  SER    65      11.268  -4.405   5.700  1.00 32.21
ATOM   1060  HG  SER    65      12.173  -4.543   5.409  1.00  0.00
ATOM   1061  C   SER    65       8.924  -1.516   5.191  1.00 13.15
ATOM   1062  O   SER    65       8.802  -0.514   5.895  1.00 62.15
ATOM   1063  N   ALA    66       8.615  -1.536   3.898  1.00 34.10
ATOM   1064  HN  ALA    66       8.753  -2.380   3.362  1.00  0.00
ATOM   1065  CA  ALA    66       8.079  -0.366   3.220  1.00 54.22
ATOM   1066  HA  ALA    66       8.640   0.508   3.552  1.00  0.00
ATOM   1067  CB  ALA    66       8.249  -0.505   1.715  1.00 24.42
ATOM   1068 1HB  ALA    66       7.870   0.388   1.217  1.00  0.00
ATOM   1069 2HB  ALA    66       9.306  -0.628   1.479  1.00  0.00
ATOM   1070 3HB  ALA    66       7.695  -1.376   1.366  1.00  0.00
ATOM   1071  C   ALA    66       6.610  -0.163   3.576  1.00 45.41
ATOM   1072  O   ALA    66       6.182   0.951   3.870  1.00 32.23
ATOM   1073  N   ALA    67       5.848  -1.255   3.566  1.00 75.31
ATOM   1074  HN  ALA    67       6.265  -2.150   3.353  1.00  0.00
ATOM   1075  CA  ALA    67       4.412  -1.212   3.853  1.00  4.20
ATOM   1076  HA  ALA    67       3.935  -0.590   3.095  1.00  0.00
ATOM   1077  CB  ALA    67       3.818  -2.609   3.784  1.00 33.13
ATOM   1078 1HB  ALA    67       2.745  -2.564   3.967  1.00  0.00
ATOM   1079 2HB  ALA    67       3.998  -3.030   2.795  1.00  0.00
ATOM   1080 3HB  ALA    67       4.288  -3.240   4.538  1.00  0.00
ATOM   1081  C   ALA    67       4.131  -0.608   5.223  1.00 73.35
ATOM   1082  O   ALA    67       3.103   0.033   5.438  1.00 14.33
ATOM   1083  N   GLU    68       5.055  -0.821   6.144  1.00 44.23
ATOM   1084  HN  GLU    68       5.899  -1.318   5.897  1.00  0.00
ATOM   1085  CA  GLU    68       4.904  -0.361   7.514  1.00 44.40
ATOM   1086  HA  GLU    68       3.871  -0.520   7.823  1.00  0.00
ATOM   1087  CB  GLU    68       5.824  -1.174   8.424  1.00 14.11
ATOM   1088 2HB  GLU    68       5.845  -2.202   8.063  1.00  0.00
ATOM   1089 3HB  GLU    68       6.827  -0.749   8.368  1.00  0.00
ATOM   1090  CG  GLU    68       5.390  -1.185   9.873  1.00 61.13
ATOM   1091 2HG  GLU    68       5.224  -0.157  10.197  1.00  0.00
ATOM   1092 3HG  GLU    68       4.458  -1.743   9.956  1.00  0.00
ATOM   1093  CD  GLU    68       6.421  -1.821  10.779  1.00 20.11
ATOM   1094  OE1 GLU    68       6.416  -3.060  10.913  1.00 34.45
ATOM   1095  OE2 GLU    68       7.250  -1.081  11.348  1.00 62.33
ATOM   1096 2HE  GLU    68       7.877  -1.550  11.904  1.00  0.00
ATOM   1097  C   GLU    68       5.227   1.129   7.630  1.00 75.25
ATOM   1098  O   GLU    68       4.959   1.757   8.653  1.00 10.11
ATOM   1099  N   MET    69       5.792   1.690   6.570  1.00 20.45
ATOM   1100  HN  MET    69       5.949   1.146   5.734  1.00  0.00
ATOM   1101  CA  MET    69       6.201   3.088   6.577  1.00 54.12
ATOM   1102  HA  MET    69       6.113   3.468   7.595  1.00  0.00
ATOM   1103  CB  MET    69       7.663   3.203   6.133  1.00 20.41
ATOM   1104 2HB  MET    69       8.232   2.415   6.625  1.00  0.00
ATOM   1105 3HB  MET    69       7.704   3.061   5.053  1.00  0.00
ATOM   1106  CG  MET    69       8.317   4.539   6.462  1.00 42.02
ATOM   1107 2HG  MET    69       9.191   4.667   5.822  1.00  0.00
ATOM   1108 3HG  MET    69       7.607   5.338   6.246  1.00  0.00
ATOM   1109  SD  MET    69       8.840   4.681   8.189  1.00  4.42
ATOM   1110  CE  MET    69       7.274   4.758   9.061  1.00 63.43
ATOM   1111 1HE  MET    69       7.440   4.847  10.134  1.00  0.00
ATOM   1112 2HE  MET    69       6.710   5.624   8.714  1.00  0.00
ATOM   1113 3HE  MET    69       6.705   3.851   8.861  1.00  0.00
ATOM   1114  C   MET    69       5.301   3.925   5.664  1.00 71.11
ATOM   1115  O   MET    69       5.238   5.151   5.783  1.00 34.42
ATOM   1116  N   ILE    70       4.608   3.255   4.751  1.00 71.51
ATOM   1117  HN  ILE    70       4.694   2.250   4.696  1.00  0.00
ATOM   1118  CA  ILE    70       3.716   3.924   3.814  1.00 12.23
ATOM   1119  HA  ILE    70       4.222   4.819   3.449  1.00  0.00
ATOM   1120  CB  ILE    70       3.390   3.017   2.604  1.00 13.04
ATOM   1121  HB  ILE    70       2.984   2.078   2.979  1.00  0.00
ATOM   1122  CG2 ILE    70       2.346   3.661   1.701  1.00 31.32
ATOM   1123 1HG2 ILE    70       2.117   2.997   0.867  1.00  0.00
ATOM   1124 2HG2 ILE    70       1.438   3.848   2.274  1.00  0.00
ATOM   1125 3HG2 ILE    70       2.733   4.605   1.315  1.00  0.00
ATOM   1126  CG1 ILE    70       4.666   2.712   1.818  1.00 34.52
ATOM   1127 2HG1 ILE    70       5.076   3.653   1.449  1.00  0.00
ATOM   1128 3HG1 ILE    70       5.382   2.244   2.493  1.00  0.00
ATOM   1129  CD1 ILE    70       4.452   1.790   0.637  1.00 53.12
ATOM   1130 1HD1 ILE    70       5.393   1.611   0.116  1.00  0.00
ATOM   1131 2HD1 ILE    70       4.053   0.840   0.990  1.00  0.00
ATOM   1132 3HD1 ILE    70       3.744   2.248  -0.054  1.00  0.00
ATOM   1133  C   ILE    70       2.420   4.343   4.499  1.00 22.13
ATOM   1134  O   ILE    70       1.825   3.569   5.249  1.00  5.50
ATOM   1135  N   GLU    71       1.996   5.573   4.234  1.00 74.54
ATOM   1136  HN  GLU    71       2.534   6.165   3.617  1.00  0.00
ATOM   1137  CA  GLU    71       0.770   6.106   4.805  1.00 62.40
ATOM   1138  HA  GLU    71       0.511   5.522   5.688  1.00  0.00
ATOM   1139  CB  GLU    71       0.975   7.565   5.218  1.00  4.32
ATOM   1140 2HB  GLU    71       1.811   7.610   5.916  1.00  0.00
ATOM   1141 3HB  GLU    71       1.217   8.144   4.326  1.00  0.00
ATOM   1142  CG  GLU    71      -0.237   8.195   5.882  1.00  4.43
ATOM   1143 2HG  GLU    71      -0.751   8.822   5.153  1.00  0.00
ATOM   1144 3HG  GLU    71      -0.909   7.403   6.211  1.00  0.00
ATOM   1145  CD  GLU    71       0.136   9.044   7.076  1.00 71.52
ATOM   1146  OE1 GLU    71       0.853   8.545   7.968  1.00 64.22
ATOM   1147  OE2 GLU    71      -0.289  10.214   7.135  1.00 11.53
ATOM   1148 2HE  GLU    71      -0.014  10.694   7.920  1.00  0.00
ATOM   1149  C   GLU    71      -0.366   6.006   3.792  1.00 30.13
ATOM   1150  O   GLU    71      -0.350   6.672   2.752  1.00 22.31
ATOM   1151  N   VAL    72      -1.343   5.166   4.091  1.00 24.24
ATOM   1152  HN  VAL    72      -1.307   4.640   4.952  1.00  0.00
ATOM   1153  CA  VAL    72      -2.481   4.974   3.208  1.00 73.40
ATOM   1154  HA  VAL    72      -2.415   5.715   2.411  1.00  0.00
ATOM   1155  CB  VAL    72      -2.490   3.566   2.570  1.00 61.32
ATOM   1156  HB  VAL    72      -3.380   3.484   1.946  1.00  0.00
ATOM   1157  CG1 VAL    72      -1.272   3.362   1.683  1.00 52.44
ATOM   1158 1HG1 VAL    72      -1.309   2.375   1.222  1.00  0.00
ATOM   1159 2HG1 VAL    72      -1.260   4.124   0.903  1.00  0.00
ATOM   1160 3HG1 VAL    72      -0.367   3.445   2.285  1.00  0.00
ATOM   1161  CG2 VAL    72      -2.562   2.485   3.642  1.00  5.02
ATOM   1162 1HG2 VAL    72      -2.594   1.501   3.174  1.00  0.00
ATOM   1163 2HG2 VAL    72      -1.682   2.552   4.283  1.00  0.00
ATOM   1164 3HG2 VAL    72      -3.460   2.630   4.242  1.00  0.00
ATOM   1165  C   VAL    72      -3.783   5.181   3.964  1.00 64.04
ATOM   1166  O   VAL    72      -3.787   5.310   5.188  1.00 22.25
ATOM   1167  N   GLU    73      -4.880   5.220   3.230  1.00 45.33
ATOM   1168  HN  GLU    73      -4.815   5.170   2.223  1.00  0.00
ATOM   1169  CA  GLU    73      -6.195   5.333   3.835  1.00 65.41
ATOM   1170  HA  GLU    73      -6.083   5.265   4.917  1.00  0.00
ATOM   1171  CB  GLU    73      -6.847   6.673   3.492  1.00 65.44
ATOM   1172 2HB  GLU    73      -6.995   6.717   2.413  1.00  0.00
ATOM   1173 3HB  GLU    73      -7.813   6.724   3.994  1.00  0.00
ATOM   1174  CG  GLU    73      -6.029   7.877   3.910  1.00  3.41
ATOM   1175 2HG  GLU    73      -5.702   7.739   4.940  1.00  0.00
ATOM   1176 3HG  GLU    73      -5.154   7.950   3.263  1.00  0.00
ATOM   1177  CD  GLU    73      -6.812   9.168   3.816  1.00 44.43
ATOM   1178  OE1 GLU    73      -7.138   9.745   4.877  1.00 73.24
ATOM   1179  OE2 GLU    73      -7.111   9.610   2.689  1.00 41.01
ATOM   1180 2HE  GLU    73      -7.608  10.431   2.707  1.00  0.00
ATOM   1181  C   GLU    73      -7.089   4.205   3.357  1.00 53.54
ATOM   1182  O   GLU    73      -7.093   3.870   2.170  1.00 75.24
END
