
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   59 (  467),  selected   59 , name 2drk_A
# Molecule2: number of CA atoms   70 ( 1132),  selected   70 , name T0492.pdb
# PARAMETERS: 2drk_A.T0492.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      F       2           -
LGA    S     2_A      S       3           -
LGA    P     3_A      L       4           -
LGA    -       -      R       5           -
LGA    -       -      D       6           -
LGA    -       -      A       7           -
LGA    -       -      K       8           -
LGA    G     4_A      C       9           #
LGA    I     5_A      G      10          3.422
LGA    -       -      Q      11           -
LGA    Q     6_A      T      12          0.870
LGA    V     7_A      V      13          0.763
LGA    K     8_A      K      14          1.365
LGA    A     9_A      V      15          1.760
LGA    -       -      V      16           -
LGA    L    10_A      K      17          3.010
LGA    Y    11_A      L      18          2.276
LGA    -       -      H      19           -
LGA    -       -      G      20           -
LGA    -       -      T      21           -
LGA    -       -      G      22           -
LGA    -       -      A      23           -
LGA    -       -      L      24           -
LGA    -       -      K      25           -
LGA    -       -      R      26           -
LGA    -       -      R      27           -
LGA    D    12_A      I      28          5.149
LGA    Y    13_A      M      29          2.790
LGA    D    14_A      D      30          2.352
LGA    A    15_A      M      31          2.880
LGA    Q    16_A      -       -           -
LGA    T    17_A      -       -           -
LGA    G    18_A      -       -           -
LGA    D    19_A      -       -           -
LGA    E    20_A      -       -           -
LGA    L    21_A      -       -           -
LGA    T    22_A      G      32          1.923
LGA    F    23_A      I      33          1.658
LGA    K    24_A      T      34          0.782
LGA    E    25_A      R      35          0.943
LGA    G    26_A      G      36          1.570
LGA    D    27_A      C      37          0.972
LGA    T    28_A      E      38          0.558
LGA    I    29_A      I      39          0.513
LGA    I    30_A      Y      40          0.695
LGA    V    31_A      I      41          0.515
LGA    H    32_A      R      42          0.674
LGA    Q    33_A      K      43          1.166
LGA    K    34_A      V      44          1.654
LGA    D    35_A      A      45          1.810
LGA    P    36_A      G      48          2.035
LGA    A    37_A      D      49          2.359
LGA    G    38_A      -       -           -
LGA    W    39_A      P      50          3.009
LGA    W    40_A      I      51          0.762
LGA    E    41_A      Q      52          0.245
LGA    G    42_A      I      53          0.406
LGA    E    43_A      N      54          0.245
LGA    L    44_A      V      55          1.364
LGA    N    45_A      R      56          2.080
LGA    G    46_A      G      57          1.612
LGA    K    47_A      Y      58          0.977
LGA    R    48_A      E      59          0.625
LGA    G    49_A      L      60          0.438
LGA    W    50_A      S      61          1.609
LGA    V    51_A      L      62          2.654
LGA    P    52_A      R      63          4.085
LGA    -       -      K      64           -
LGA    -       -      S      65           -
LGA    -       -      A      66           -
LGA    A    53_A      A      67          1.965
LGA    N    54_A      E      68          1.959
LGA    -       -      M      69           -
LGA    Y    55_A      I      70          1.646
LGA    -       -      E      71           -
LGA    V    56_A      V      72          3.763
LGA    Q    57_A      E      73          4.054
LGA    D    58_A      -       -           -
LGA    I    59_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   59   70    5.0     46    2.08    17.39     57.040     2.114

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.873966 * X  +   0.481923 * Y  +   0.062720 * Z  +  -6.814153
  Y_new =  -0.441410 * X  +   0.841156 * Y  +  -0.312433 * Z  +   4.745667
  Z_new =  -0.203326 * X  +   0.245371 * Y  +   0.947867 * Z  +  -7.669590 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.253306   -2.888287  [ DEG:    14.5133   -165.4867 ]
  Theta =   0.204753    2.936839  [ DEG:    11.7315    168.2685 ]
  Phi   =  -0.467692    2.673901  [ DEG:   -26.7968    153.2032 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2drk_A                                        
REMARK     2: T0492.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2drk_A.T0492.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   59   70   5.0   46   2.08   17.39  57.040
REMARK  ---------------------------------------------------------- 
MOLECULE 2drk_A
HEADER    CONTRACTILE PROTEIN                     09-JUN-06   2DRK              
TITLE     ACANTHAMOEBA MYOSIN I SH3 DOMAIN BOUND TO ACAN125                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MYOSIN HEAVY CHAIN IB;                                     
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SH3 DOMAIN;                                                
COMPND   5 SYNONYM: MYOSIN HEAVY CHAIN IL;                                      
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: 10-MER PEPTIDE FROM MYOSIN-I BINDING PROTEIN               
COMPND   9 ACAN125;                                                             
COMPND  10 CHAIN: B;                                                            
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ACANTHAMOEBA CASTELLANII;                       
SOURCE   3 ORGANISM_COMMON: AMOEBA;                                             
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PGEX;                                     
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 SYNTHETIC: YES;                                                      
SOURCE  11 OTHER_DETAILS: THIS SEQUENCE OCCURS NATURALLY IN                     
SOURCE  12 ACANTHAMOEBA                                                         
KEYWDS    SH3 DOMAIN                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.HOUDUSSE,A.BAHLOUL,E.M.OSTAP                                        
REVDAT   1   29-MAY-07 2DRK    0                                                
JRNL        AUTH   A.HOUDUSSE,A.BAHLOUL,E.M.OSTAP                               
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE SH3 DOMAIN OF                   
JRNL        TITL 2 ACANTHAMOEBA MYOSIN IB BOUND TO ACAN125                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.42 ANGSTROMS.                                          
DBREF  2DRK A    6    59  UNP    P19706   MYSB_ACACA    1094   1147             
DBREF  2DRK B    1    10  UNP    P90630   P90630_ACACA   977    986             
SEQRES   1 A   59  GLY SER PRO GLY ILE GLN VAL LYS ALA LEU TYR ASP TYR          
SEQRES   2 A   59  ASP ALA GLN THR GLY ASP GLU LEU THR PHE LYS GLU GLY          
SEQRES   3 A   59  ASP THR ILE ILE VAL HIS GLN LYS ASP PRO ALA GLY TRP          
SEQRES   4 A   59  TRP GLU GLY GLU LEU ASN GLY LYS ARG GLY TRP VAL PRO          
SEQRES   5 A   59  ALA ASN TYR VAL GLN ASP ILE                                  
SEQRES   1 B   10  ARG PRO LYS PRO VAL PRO PRO PRO ARG GLY                      
HET    SO4      1       5                                                       
HET    GOL    100       8                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   3  SO4    O4 S 2-                                                      
FORMUL   4  GOL    C3 H8 O3                                                     
FORMUL   5  HOH   *77(H2 O)                                                     
CRYST1   32.701   37.362   43.836  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   GLY A   1     -18.222  -7.387  -4.434  1.00 10.22           N  
ATOM      2  CA  GLY A   1     -17.394  -6.210  -4.063  1.00 10.37           C  
ATOM      3  C   GLY A   1     -16.137  -6.152  -4.890  1.00 10.78           C  
ATOM      4  O   GLY A   1     -15.993  -6.875  -5.863  1.00 10.63           O  
ATOM      5  N   SER A   2     -15.226  -5.281  -4.478  1.00 11.08           N  
ATOM      6  CA  SER A   2     -13.974  -5.073  -5.190  1.00 11.70           C  
ATOM      7  C   SER A   2     -13.152  -6.358  -5.140  1.00 12.35           C  
ATOM      8  O   SER A   2     -13.317  -7.154  -4.216  1.00 11.54           O  
ATOM      9  CB  SER A   2     -13.212  -3.908  -4.541  0.50 11.94           C  
ATOM     11  OG  SER A   2     -11.818  -3.987  -4.762  0.50 11.91           O  
ATOM     13  N   PRO A   3     -12.294  -6.595  -6.133  1.00 13.55           N  
ATOM     14  CA  PRO A   3     -11.478  -7.819  -6.151  1.00 14.05           C  
ATOM     15  C   PRO A   3     -10.527  -7.968  -4.962  1.00 14.37           C  
ATOM     16  O   PRO A   3     -10.028  -9.059  -4.715  1.00 15.33           O  
ATOM     17  CB  PRO A   3     -10.687  -7.700  -7.453  1.00 14.43           C  
ATOM     18  CG  PRO A   3     -11.437  -6.723  -8.272  1.00 14.88           C  
ATOM     19  CD  PRO A   3     -12.048  -5.756  -7.323  1.00 13.77           C  
ATOM     20  N   GLY A   4     -10.278  -6.888  -4.238  1.00 14.57           N  
ATOM     21  CA  GLY A   4      -9.531  -6.964  -3.003  1.00 15.06           C  
ATOM     22  C   GLY A   4      -9.725  -5.733  -2.151  1.00 15.29           C  
ATOM     23  O   GLY A   4     -10.552  -4.868  -2.437  1.00 15.74           O  
ATOM     24  N   ILE A   5      -8.922  -5.663  -1.102  1.00 15.48           N  
ATOM     25  CA  ILE A   5      -8.905  -4.548  -0.174  1.00 15.76           C  
ATOM     26  C   ILE A   5      -8.245  -3.345  -0.853  1.00 14.78           C  
ATOM     27  O   ILE A   5      -7.063  -3.379  -1.137  1.00 15.27           O  
ATOM     28  CB  ILE A   5      -8.086  -4.960   1.089  1.00 16.26           C  
ATOM     29  CG1 ILE A   5      -8.670  -6.225   1.736  1.00 18.02           C  
ATOM     30  CG2 ILE A   5      -8.020  -3.835   2.096  1.00 17.10           C  
ATOM     31  CD1 ILE A   5      -7.760  -7.440   1.641  1.00 19.69           C  
ATOM     32  N   GLN A   6      -8.992  -2.272  -1.085  1.00 13.94           N  
ATOM     33  CA  GLN A   6      -8.410  -1.061  -1.658  1.00 13.62           C  
ATOM     34  C   GLN A   6      -7.853  -0.155  -0.561  1.00 12.60           C  
ATOM     35  O   GLN A   6      -8.572   0.210   0.360  1.00 13.24           O  
ATOM     36  CB  GLN A   6      -9.448  -0.289  -2.456  1.00 14.23           C  
ATOM     37  CG  GLN A   6      -9.974  -1.018  -3.664  1.00 16.48           C  
ATOM     38  CD  GLN A   6     -10.996  -0.190  -4.399  1.00 19.53           C  
ATOM     39  OE1 GLN A   6     -12.119  -0.031  -3.927  1.00 23.44           O  
ATOM     40  NE2 GLN A   6     -10.608   0.367  -5.532  1.00 21.51           N  
ATOM     41  N   VAL A   7      -6.580   0.210  -0.666  1.00 11.03           N  
ATOM     42  CA  VAL A   7      -5.929   1.071   0.322  1.00 10.99           C  
ATOM     43  C   VAL A   7      -5.160   2.188  -0.369  1.00 10.48           C  
ATOM     44  O   VAL A   7      -4.683   2.019  -1.482  1.00 10.53           O  
ATOM     45  CB  VAL A   7      -4.948   0.280   1.227  1.00 11.37           C  
ATOM     46  CG1 VAL A   7      -5.699  -0.774   2.044  1.00 12.46           C  
ATOM     47  CG2 VAL A   7      -3.835  -0.355   0.420  1.00 12.25           C  
ATOM     48  N   LYS A   8      -5.022   3.322   0.301  1.00 10.08           N  
ATOM     49  CA  LYS A   8      -4.320   4.464  -0.278  1.00 10.15           C  
ATOM     50  C   LYS A   8      -2.836   4.411   0.060  1.00  9.31           C  
ATOM     51  O   LYS A   8      -2.460   4.103   1.186  1.00  9.03           O  
ATOM     52  CB  LYS A   8      -4.917   5.779   0.231  1.00 10.98           C  
ATOM     53  CG  LYS A   8      -6.300   6.105  -0.346  1.00 14.33           C  
ATOM     54  CD  LYS A   8      -6.255   6.258  -1.868  1.00 17.36           C  
ATOM     55  CE  LYS A   8      -7.420   7.065  -2.418  1.00 19.76           C  
ATOM     56  NZ  LYS A   8      -6.933   8.137  -3.339  1.00 22.22           N  
ATOM     57  N   ALA A   9      -1.994   4.717  -0.919  1.00  8.61           N  
ATOM     58  CA  ALA A   9      -0.564   4.893  -0.684  1.00  8.16           C  
ATOM     59  C   ALA A   9      -0.337   6.209   0.043  1.00  8.59           C  
ATOM     60  O   ALA A   9      -0.868   7.245  -0.350  1.00  8.50           O  
ATOM     61  CB  ALA A   9       0.189   4.883  -1.999  1.00  7.99           C  
ATOM     62  N   LEU A  10       0.468   6.161   1.096  1.00  8.44           N  
ATOM     63  CA  LEU A  10       0.796   7.335   1.903  1.00  8.76           C  
ATOM     64  C   LEU A  10       2.035   8.076   1.419  1.00  8.50           C  
ATOM     65  O   LEU A  10       2.236   9.230   1.772  1.00  8.60           O  
ATOM     66  CB  LEU A  10       1.037   6.910   3.353  1.00  9.27           C  
ATOM     67  CG  LEU A  10      -0.125   6.295   4.129  1.00 10.72           C  
ATOM     68  CD1 LEU A  10       0.367   5.799   5.483  1.00 12.98           C  
ATOM     69  CD2 LEU A  10      -1.250   7.292   4.299  1.00 12.15           C  
ATOM     70  N   TYR A  11       2.899   7.394   0.670  1.00  7.84           N  
ATOM     71  CA  TYR A  11       4.148   7.976   0.177  1.00  7.83           C  
ATOM     72  C   TYR A  11       4.459   7.410  -1.194  1.00  7.58           C  
ATOM     73  O   TYR A  11       3.964   6.340  -1.558  1.00  7.64           O  
ATOM     74  CB  TYR A  11       5.342   7.666   1.107  1.00  7.73           C  
ATOM     75  CG  TYR A  11       5.009   7.558   2.574  1.00  8.27           C  
ATOM     76  CD1 TYR A  11       4.618   6.347   3.112  1.00  7.86           C  
ATOM     77  CD2 TYR A  11       5.081   8.663   3.417  1.00  8.39           C  
ATOM     78  CE1 TYR A  11       4.292   6.226   4.446  1.00  9.40           C  
ATOM     79  CE2 TYR A  11       4.756   8.553   4.767  1.00  9.40           C  
ATOM     80  CZ  TYR A  11       4.360   7.327   5.265  1.00  9.50           C  
ATOM     81  OH  TYR A  11       4.013   7.171   6.588  1.00 11.24           O  
ATOM     82  N   ASP A  12       5.289   8.121  -1.946  1.00  7.81           N  
ATOM     83  CA  ASP A  12       5.836   7.590  -3.190  1.00  7.94           C  
ATOM     84  C   ASP A  12       6.795   6.438  -2.886  1.00  7.71           C  
ATOM     85  O   ASP A  12       7.553   6.490  -1.911  1.00  8.18           O  
ATOM     86  CB  ASP A  12       6.652   8.637  -3.951  1.00  8.39           C  
ATOM     87  CG  ASP A  12       5.850   9.830  -4.428  1.00  9.31           C  
ATOM     88  OD1 ASP A  12       4.612   9.890  -4.313  1.00  9.66           O  
ATOM     89  OD2 ASP A  12       6.435  10.785  -4.969  1.00 13.57           O  
ATOM     90  N   TYR A  13       6.766   5.406  -3.725  1.00  7.29           N  
ATOM     91  CA  TYR A  13       7.727   4.307  -3.643  1.00  7.29           C  
ATOM     92  C   TYR A  13       8.171   3.904  -5.048  1.00  7.38           C  
ATOM     93  O   TYR A  13       7.335   3.679  -5.926  1.00  7.17           O  
ATOM     94  CB  TYR A  13       7.128   3.096  -2.916  1.00  7.31           C  
ATOM     95  CG  TYR A  13       8.123   1.962  -2.837  1.00  7.18           C  
ATOM     96  CD1 TYR A  13       9.228   2.046  -1.995  1.00  7.40           C  
ATOM     97  CD2 TYR A  13       7.999   0.839  -3.644  1.00  7.30           C  
ATOM     98  CE1 TYR A  13      10.170   1.024  -1.943  1.00  8.39           C  
ATOM     99  CE2 TYR A  13       8.930  -0.182  -3.603  1.00  8.36           C  
ATOM    100  CZ  TYR A  13      10.015  -0.080  -2.751  1.00  7.80           C  
ATOM    101  OH  TYR A  13      10.963  -1.073  -2.702  1.00  9.12           O  
ATOM    102  N   ASP A  14       9.487   3.816  -5.246  1.00  7.79           N  
ATOM    103  CA  ASP A  14      10.072   3.339  -6.496  1.00  8.36           C  
ATOM    104  C   ASP A  14      10.530   1.898  -6.332  1.00  8.03           C  
ATOM    105  O   ASP A  14      11.378   1.604  -5.508  1.00  8.32           O  
ATOM    106  CB  ASP A  14      11.260   4.214  -6.901  1.00  8.89           C  
ATOM    107  CG  ASP A  14      10.853   5.636  -7.197  1.00 11.93           C  
ATOM    108  OD1 ASP A  14       9.850   5.836  -7.913  1.00 13.84           O  
ATOM    109  OD2 ASP A  14      11.473   6.617  -6.733  1.00 15.98           O  
ATOM    110  N   ALA A  15       9.956   0.998  -7.123  1.00  8.09           N  
ATOM    111  CA  ALA A  15      10.312  -0.418  -7.081  1.00  8.33           C  
ATOM    112  C   ALA A  15      11.814  -0.632  -7.224  1.00  9.02           C  
ATOM    113  O   ALA A  15      12.454  -0.034  -8.090  1.00  9.61           O  
ATOM    114  CB  ALA A  15       9.605  -1.157  -8.181  1.00  8.29           C  
ATOM    115  N   GLN A  16      12.355  -1.501  -6.379  1.00  9.62           N  
ATOM    116  CA  GLN A  16      13.767  -1.863  -6.408  1.00 10.36           C  
ATOM    117  C   GLN A  16      13.996  -3.258  -6.999  1.00 10.45           C  
ATOM    118  O   GLN A  16      15.136  -3.684  -7.149  1.00 10.82           O  
ATOM    119  CB  GLN A  16      14.353  -1.761  -4.999  1.00 10.44           C  
ATOM    120  CG  GLN A  16      14.307  -0.346  -4.431  1.00 12.01           C  
ATOM    121  CD  GLN A  16      15.084   0.633  -5.287  1.00 14.01           C  
ATOM    122  OE1 GLN A  16      16.300   0.723  -5.163  1.00 15.68           O  
ATOM    123  NE2 GLN A  16      14.391   1.339  -6.182  1.00 15.03           N  
ATOM    124  N   THR A  17      12.909  -3.964  -7.311  1.00 10.26           N  
ATOM    125  CA  THR A  17      12.948  -5.175  -8.139  1.00  9.90           C  
ATOM    126  C   THR A  17      11.789  -5.165  -9.130  1.00  9.96           C  
ATOM    127  O   THR A  17      10.842  -4.389  -8.993  1.00  9.75           O  
ATOM    128  CB  THR A  17      12.834  -6.469  -7.301  1.00 10.38           C  
ATOM    129  OG1 THR A  17      11.447  -6.735  -7.018  1.00  9.90           O  
ATOM    130  CG2 THR A  17      13.507  -6.357  -5.947  1.00 10.78           C  
ATOM    131  N   GLY A  18      11.842  -6.060 -10.106  1.00 10.03           N  
ATOM    132  CA  GLY A  18      10.787  -6.184 -11.095  1.00  9.88           C  
ATOM    133  C   GLY A  18       9.462  -6.699 -10.552  1.00  9.70           C  
ATOM    134  O   GLY A  18       8.427  -6.535 -11.200  1.00 10.12           O  
ATOM    135  N   ASP A  19       9.500  -7.343  -9.385  1.00  9.59           N  
ATOM    136  CA  ASP A  19       8.300  -7.899  -8.766  1.00  9.48           C  
ATOM    137  C   ASP A  19       7.702  -6.995  -7.701  1.00  8.59           C  
ATOM    138  O   ASP A  19       6.712  -7.378  -7.089  1.00  8.92           O  
ATOM    139  CB  ASP A  19       8.581  -9.281  -8.165  1.00 10.24           C  
ATOM    140  CG  ASP A  19       8.472 -10.383  -9.191  1.00 12.56           C  
ATOM    141  OD1 ASP A  19       9.456 -10.584  -9.925  1.00 17.04           O  
ATOM    142  OD2 ASP A  19       7.444 -11.084  -9.334  1.00 14.92           O  
ATOM    143  N   GLU A  20       8.289  -5.818  -7.490  1.00  7.72           N  
ATOM    144  CA  GLU A  20       7.683  -4.783  -6.656  1.00  7.26           C  
ATOM    145  C   GLU A  20       6.894  -3.798  -7.508  1.00  7.64           C  
ATOM    146  O   GLU A  20       7.141  -3.651  -8.704  1.00  8.05           O  
ATOM    147  CB  GLU A  20       8.745  -4.018  -5.871  1.00  7.02           C  
ATOM    148  CG  GLU A  20       9.489  -4.872  -4.854  1.00  6.44           C  
ATOM    149  CD  GLU A  20      10.623  -4.137  -4.168  1.00  6.99           C  
ATOM    150  OE1 GLU A  20      10.848  -2.954  -4.477  1.00  7.09           O  
ATOM    151  OE2 GLU A  20      11.298  -4.760  -3.326  1.00  8.03           O  
ATOM    152  N   LEU A  21       5.939  -3.128  -6.872  1.00  7.45           N  
ATOM    153  CA  LEU A  21       5.173  -2.064  -7.506  1.00  7.25           C  
ATOM    154  C   LEU A  21       5.803  -0.705  -7.257  1.00  7.21           C  
ATOM    155  O   LEU A  21       6.287  -0.433  -6.166  1.00  8.92           O  
ATOM    156  CB  LEU A  21       3.744  -2.056  -6.961  1.00  7.47           C  
ATOM    157  CG  LEU A  21       2.957  -3.345  -7.195  1.00  8.47           C  
ATOM    158  CD1 LEU A  21       1.513  -3.168  -6.734  1.00 10.04           C  
ATOM    159  CD2 LEU A  21       2.998  -3.786  -8.652  1.00 10.09           C  
ATOM    160  N   THR A  22       5.789   0.138  -8.282  1.00  6.86           N  
ATOM    161  CA  THR A  22       6.084   1.552  -8.153  1.00  6.63           C  
ATOM    162  C   THR A  22       4.754   2.292  -8.037  1.00  6.42           C  
ATOM    163  O   THR A  22       3.813   1.996  -8.759  1.00  6.94           O  
ATOM    164  CB  THR A  22       6.840   2.035  -9.402  1.00  6.36           C  
ATOM    165  OG1 THR A  22       8.172   1.507  -9.392  1.00  8.00           O  
ATOM    166  CG2 THR A  22       7.019   3.539  -9.403  1.00  6.06           C  
ATOM    167  N   PHE A  23       4.686   3.252  -7.124  1.00  6.45           N  
ATOM    168  CA  PHE A  23       3.467   4.020  -6.937  1.00  6.53           C  
ATOM    169  C   PHE A  23       3.751   5.390  -6.350  1.00  7.00           C  
ATOM    170  O   PHE A  23       4.873   5.700  -5.954  1.00  6.65           O  
ATOM    171  CB  PHE A  23       2.470   3.227  -6.072  1.00  6.59           C  
ATOM    172  CG  PHE A  23       3.021   2.771  -4.751  1.00  6.40           C  
ATOM    173  CD1 PHE A  23       3.032   3.621  -3.656  1.00  6.89           C  
ATOM    174  CD2 PHE A  23       3.496   1.474  -4.596  1.00  7.27           C  
ATOM    175  CE1 PHE A  23       3.525   3.190  -2.433  1.00  6.12           C  
ATOM    176  CE2 PHE A  23       3.988   1.035  -3.376  1.00  6.31           C  
ATOM    177  CZ  PHE A  23       4.012   1.900  -2.291  1.00  6.96           C  
ATOM    178  N   LYS A  24       2.718   6.219  -6.330  1.00  7.44           N  
ATOM    179  CA  LYS A  24       2.811   7.571  -5.799  1.00  8.12           C  
ATOM    180  C   LYS A  24       1.835   7.737  -4.658  1.00  8.16           C  
ATOM    181  O   LYS A  24       0.816   7.053  -4.589  1.00  7.60           O  
ATOM    182  CB  LYS A  24       2.497   8.602  -6.890  1.00  8.61           C  
ATOM    183  CG  LYS A  24       3.555   8.687  -7.987  1.00 10.96           C  
ATOM    184  CD  LYS A  24       3.526  10.024  -8.718  1.00 14.21           C  
ATOM    185  CE  LYS A  24       4.573  10.073  -9.822  1.00 15.74           C  
ATOM    186  NZ  LYS A  24       4.567  11.378 -10.561  1.00 18.78           N  
ATOM    187  N   GLU A  25       2.150   8.649  -3.748  1.00  8.45           N  
ATOM    188  CA  GLU A  25       1.190   9.071  -2.746  1.00  8.35           C  
ATOM    189  C   GLU A  25      -0.152   9.334  -3.426  1.00  7.93           C  
ATOM    190  O   GLU A  25      -0.218  10.019  -4.452  1.00  8.24           O  
ATOM    191  CB  GLU A  25       1.673  10.327  -2.025  1.00  8.77           C  
ATOM    192  CG  GLU A  25       0.739  10.784  -0.918  1.00 10.53           C  
ATOM    193  CD  GLU A  25       1.209  12.031  -0.195  1.00 13.74           C  
ATOM    194  OE1 GLU A  25       2.273  12.580  -0.551  1.00 16.52           O  
ATOM    195  OE2 GLU A  25       0.501  12.455   0.746  1.00 16.22           O  
ATOM    196  N   GLY A  26      -1.210   8.757  -2.859  1.00  8.12           N  
ATOM    197  CA  GLY A  26      -2.551   8.910  -3.387  1.00  8.08           C  
ATOM    198  C   GLY A  26      -3.019   7.821  -4.328  1.00  7.82           C  
ATOM    199  O   GLY A  26      -4.200   7.752  -4.632  1.00  9.03           O  
ATOM    200  N   ASP A  27      -2.119   6.962  -4.796  1.00  7.10           N  
ATOM    201  CA  ASP A  27      -2.536   5.803  -5.580  1.00  7.07           C  
ATOM    202  C   ASP A  27      -3.411   4.880  -4.743  1.00  7.39           C  
ATOM    203  O   ASP A  27      -3.241   4.788  -3.531  1.00  7.55           O  
ATOM    204  CB  ASP A  27      -1.326   5.023  -6.094  1.00  6.88           C  
ATOM    205  CG  ASP A  27      -0.939   5.408  -7.500  1.00  7.44           C  
ATOM    206  OD1 ASP A  27       0.257   5.672  -7.750  1.00  6.78           O  
ATOM    207  OD2 ASP A  27      -1.786   5.437  -8.412  1.00  7.43           O  
ATOM    208  N   THR A  28      -4.360   4.220  -5.396  1.00  8.05           N  
ATOM    209  CA  THR A  28      -5.160   3.181  -4.772  1.00  8.86           C  
ATOM    210  C   THR A  28      -4.567   1.822  -5.116  1.00  8.83           C  
ATOM    211  O   THR A  28      -4.551   1.415  -6.273  1.00  9.32           O  
ATOM    212  CB  THR A  28      -6.614   3.269  -5.260  1.00  9.26           C  
ATOM    213  OG1 THR A  28      -7.154   4.548  -4.901  1.00 11.76           O  
ATOM    214  CG2 THR A  28      -7.495   2.269  -4.529  1.00 10.70           C  
ATOM    215  N   ILE A  29      -4.052   1.138  -4.105  1.00  8.82           N  
ATOM    216  CA  ILE A  29      -3.487  -0.194  -4.270  1.00  9.13           C  
ATOM    217  C   ILE A  29      -4.547  -1.228  -3.908  1.00  8.82           C  
ATOM    218  O   ILE A  29      -5.202  -1.113  -2.877  1.00  8.37           O  
ATOM    219  CB  ILE A  29      -2.268  -0.379  -3.343  1.00  9.82           C  
ATOM    220  CG1 ILE A  29      -1.231   0.742  -3.511  1.00 12.34           C  
ATOM    221  CG2 ILE A  29      -1.643  -1.746  -3.556  1.00  9.96           C  
ATOM    222  CD1 ILE A  29      -0.701   0.924  -4.876  1.00 14.36           C  
ATOM    223  N   ILE A  30      -4.713  -2.238  -4.751  1.00  8.69           N  
ATOM    224  CA  ILE A  30      -5.571  -3.373  -4.424  1.00  9.50           C  
ATOM    225  C   ILE A  30      -4.719  -4.401  -3.698  1.00  9.09           C  
ATOM    226  O   ILE A  30      -3.788  -4.948  -4.270  1.00  9.95           O  
ATOM    227  CB  ILE A  30      -6.173  -4.006  -5.687  1.00 10.07           C  
ATOM    228  CG1 ILE A  30      -7.005  -2.982  -6.456  1.00 11.71           C  
ATOM    229  CG2 ILE A  30      -7.015  -5.230  -5.314  1.00 10.87           C  
ATOM    230  CD1 ILE A  30      -7.236  -3.358  -7.911  1.00 13.96           C  
ATOM    231  N   VAL A  31      -5.048  -4.668  -2.442  1.00  8.71           N  
ATOM    232  CA  VAL A  31      -4.335  -5.659  -1.647  1.00  8.77           C  
ATOM    233  C   VAL A  31      -4.990  -7.024  -1.804  1.00  8.23           C  
ATOM    234  O   VAL A  31      -6.180  -7.201  -1.548  1.00  8.19           O  
ATOM    235  CB  VAL A  31      -4.276  -5.262  -0.161  1.00  9.10           C  
ATOM    236  CG1 VAL A  31      -3.628  -6.364   0.666  1.00  8.52           C  
ATOM    237  CG2 VAL A  31      -3.514  -3.956   0.004  1.00 10.32           C  
ATOM    238  N   HIS A  32      -4.192  -7.994  -2.227  1.00  7.39           N  
ATOM    239  CA  HIS A  32      -4.650  -9.369  -2.376  1.00  7.09           C  
ATOM    240  C   HIS A  32      -4.365 -10.227  -1.142  1.00  6.74           C  
ATOM    241  O   HIS A  32      -5.203 -11.033  -0.733  1.00  7.44           O  
ATOM    242  CB  HIS A  32      -4.012  -9.976  -3.622  1.00  6.88           C  
ATOM    243  CG  HIS A  32      -4.549  -9.404  -4.889  1.00  7.78           C  
ATOM    244  ND1 HIS A  32      -5.844  -9.621  -5.302  1.00 11.11           N  
ATOM    245  CD2 HIS A  32      -3.987  -8.593  -5.817  1.00 10.50           C  
ATOM    246  CE1 HIS A  32      -6.056  -8.975  -6.436  1.00 10.86           C  
ATOM    247  NE2 HIS A  32      -4.943  -8.350  -6.771  1.00 10.79           N  
ATOM    248  N   GLN A  33      -3.178 -10.074  -0.561  1.00  6.39           N  
ATOM    249  CA  GLN A  33      -2.839 -10.768   0.677  1.00  6.55           C  
ATOM    250  C   GLN A  33      -1.980  -9.891   1.566  1.00  6.65           C  
ATOM    251  O   GLN A  33      -1.100  -9.172   1.086  1.00  6.72           O  
ATOM    252  CB  GLN A  33      -2.083 -12.066   0.395  1.00  6.28           C  
ATOM    253  CG  GLN A  33      -2.767 -13.040  -0.565  1.00  7.15           C  
ATOM    254  CD  GLN A  33      -4.018 -13.691  -0.005  1.00  7.97           C  
ATOM    255  OE1 GLN A  33      -4.201 -13.777   1.207  1.00  9.76           O  
ATOM    256  NE2 GLN A  33      -4.877 -14.161  -0.898  1.00  9.26           N  
ATOM    257  N   LYS A  34      -2.237  -9.974   2.868  1.00  7.18           N  
ATOM    258  CA  LYS A  34      -1.434  -9.304   3.887  1.00  7.34           C  
ATOM    259  C   LYS A  34      -0.366 -10.271   4.393  1.00  7.23           C  
ATOM    260  O   LYS A  34      -0.360 -10.690   5.555  1.00  7.51           O  
ATOM    261  CB  LYS A  34      -2.328  -8.815   5.025  1.00  7.57           C  
ATOM    262  CG  LYS A  34      -3.333  -7.762   4.598  1.00  7.98           C  
ATOM    263  CD  LYS A  34      -4.041  -7.168   5.813  1.00  9.38           C  
ATOM    264  CE  LYS A  34      -5.032  -6.089   5.443  1.00 10.30           C  
ATOM    265  NZ  LYS A  34      -5.774  -5.617   6.645  1.00 12.07           N  
ATOM    266  N   ASP A  35       0.563 -10.614   3.513  1.00  7.18           N  
ATOM    267  CA  ASP A  35       1.563 -11.624   3.832  1.00  7.00           C  
ATOM    268  C   ASP A  35       2.381 -11.192   5.037  1.00  6.94           C  
ATOM    269  O   ASP A  35       2.682 -10.013   5.191  1.00  6.96           O  
ATOM    270  CB  ASP A  35       2.539 -11.838   2.678  1.00  6.87           C  
ATOM    271  CG  ASP A  35       1.856 -12.093   1.363  1.00  7.27           C  
ATOM    272  OD1 ASP A  35       1.126 -11.203   0.869  1.00  7.53           O  
ATOM    273  OD2 ASP A  35       2.040 -13.146   0.733  1.00  7.71           O  
ATOM    274  N   PRO A  36       2.785 -12.146   5.868  1.00  7.07           N  
ATOM    275  CA  PRO A  36       3.715 -11.830   6.946  1.00  7.36           C  
ATOM    276  C   PRO A  36       5.067 -11.445   6.364  1.00  7.26           C  
ATOM    277  O   PRO A  36       5.413 -11.912   5.274  1.00  7.61           O  
ATOM    278  CB  PRO A  36       3.788 -13.131   7.745  1.00  7.44           C  
ATOM    279  CG  PRO A  36       3.385 -14.196   6.788  1.00  7.73           C  
ATOM    280  CD  PRO A  36       2.418 -13.571   5.844  1.00  6.91           C  
ATOM    281  N   ALA A  37       5.784 -10.573   7.066  1.00  7.63           N  
ATOM    282  CA  ALA A  37       7.168 -10.208   6.743  1.00  8.11           C  
ATOM    283  C   ALA A  37       7.328  -8.806   6.156  1.00  7.76           C  
ATOM    284  O   ALA A  37       8.409  -8.461   5.700  1.00  8.78           O  
ATOM    285  CB  ALA A  37       7.844 -11.236   5.833  1.00 10.33           C  
ATOM    286  N   GLY A  38       6.262  -8.007   6.148  1.00  6.78           N  
ATOM    287  CA  GLY A  38       6.375  -6.596   5.826  1.00  6.64           C  
ATOM    288  C   GLY A  38       6.031  -6.194   4.408  1.00  6.58           C  
ATOM    289  O   GLY A  38       5.900  -5.010   4.121  1.00  6.30           O  
ATOM    290  N   TRP A  39       5.910  -7.174   3.514  1.00  6.23           N  
ATOM    291  CA  TRP A  39       5.572  -6.937   2.107  1.00  6.23           C  
ATOM    292  C   TRP A  39       4.275  -7.672   1.789  1.00  6.13           C  
ATOM    293  O   TRP A  39       4.136  -8.869   2.074  1.00  6.55           O  
ATOM    294  CB  TRP A  39       6.688  -7.418   1.175  1.00  6.14           C  
ATOM    295  CG  TRP A  39       7.967  -6.652   1.338  1.00  5.93           C  
ATOM    296  CD1 TRP A  39       8.955  -6.880   2.260  1.00  6.77           C  
ATOM    297  CD2 TRP A  39       8.385  -5.518   0.577  1.00  5.19           C  
ATOM    298  NE1 TRP A  39       9.960  -5.954   2.106  1.00  7.24           N  
ATOM    299  CE2 TRP A  39       9.631  -5.102   1.088  1.00  6.18           C  
ATOM    300  CE3 TRP A  39       7.828  -4.801  -0.486  1.00  4.90           C  
ATOM    301  CZ2 TRP A  39      10.327  -4.014   0.565  1.00  6.87           C  
ATOM    302  CZ3 TRP A  39       8.520  -3.729  -1.005  1.00  6.28           C  
ATOM    303  CH2 TRP A  39       9.751  -3.338  -0.478  1.00  7.30           C  
ATOM    304  N   TRP A  40       3.328  -6.950   1.204  1.00  5.87           N  
ATOM    305  CA  TRP A  40       2.027  -7.498   0.864  1.00  5.78           C  
ATOM    306  C   TRP A  40       1.909  -7.726  -0.639  1.00  5.62           C  
ATOM    307  O   TRP A  40       2.517  -7.019  -1.429  1.00  5.28           O  
ATOM    308  CB  TRP A  40       0.934  -6.529   1.305  1.00  5.73           C  
ATOM    309  CG  TRP A  40       0.718  -6.431   2.779  1.00  7.49           C  
ATOM    310  CD1 TRP A  40       1.318  -7.161   3.770  1.00  9.55           C  
ATOM    311  CD2 TRP A  40      -0.214  -5.568   3.420  1.00  9.06           C  
ATOM    312  NE1 TRP A  40       0.816  -6.780   4.994  1.00  9.90           N  
ATOM    313  CE2 TRP A  40      -0.130  -5.807   4.807  1.00  9.11           C  
ATOM    314  CE3 TRP A  40      -1.119  -4.607   2.961  1.00  9.69           C  
ATOM    315  CZ2 TRP A  40      -0.925  -5.112   5.732  1.00 10.57           C  
ATOM    316  CZ3 TRP A  40      -1.904  -3.928   3.875  1.00 11.35           C  
ATOM    317  CH2 TRP A  40      -1.793  -4.181   5.242  1.00 11.90           C  
ATOM    318  N   GLU A  41       1.101  -8.708  -1.020  1.00  5.28           N  
ATOM    319  CA  GLU A  41       0.798  -8.958  -2.418  1.00  5.42           C  
ATOM    320  C   GLU A  41      -0.274  -7.983  -2.840  1.00  5.78           C  
ATOM    321  O   GLU A  41      -1.388  -8.031  -2.325  1.00  5.80           O  
ATOM    322  CB  GLU A  41       0.295 -10.382  -2.623  1.00  5.39           C  
ATOM    323  CG  GLU A  41       1.341 -11.452  -2.337  1.00  5.64           C  
ATOM    324  CD  GLU A  41       0.767 -12.845  -2.393  1.00  6.83           C  
ATOM    325  OE1 GLU A  41       0.097 -13.160  -3.390  1.00  7.74           O  
ATOM    326  OE2 GLU A  41       0.971 -13.628  -1.442  1.00  7.40           O  
ATOM    327  N   GLY A  42       0.069  -7.079  -3.749  1.00  6.49           N  
ATOM    328  CA  GLY A  42      -0.852  -6.052  -4.200  1.00  6.68           C  
ATOM    329  C   GLY A  42      -0.939  -5.971  -5.708  1.00  6.98           C  
ATOM    330  O   GLY A  42      -0.348  -6.750  -6.444  1.00  7.04           O  
ATOM    331  N   GLU A  43      -1.703  -5.001  -6.164  1.00  7.64           N  
ATOM    332  CA  GLU A  43      -1.932  -4.812  -7.584  1.00  8.00           C  
ATOM    333  C   GLU A  43      -2.194  -3.342  -7.817  1.00  7.65           C  
ATOM    334  O   GLU A  43      -2.945  -2.719  -7.079  1.00  7.48           O  
ATOM    335  CB  GLU A  43      -3.129  -5.628  -8.044  1.00  8.80           C  
ATOM    336  CG  GLU A  43      -3.439  -5.493  -9.520  1.00 11.04           C  
ATOM    337  CD  GLU A  43      -4.748  -6.152  -9.888  1.00 15.13           C  
ATOM    338  OE1 GLU A  43      -5.171  -7.095  -9.182  1.00 17.84           O  
ATOM    339  OE2 GLU A  43      -5.358  -5.727 -10.886  1.00 16.86           O  
ATOM    340  N   LEU A  44      -1.575  -2.810  -8.858  1.00  7.01           N  
ATOM    341  CA  LEU A  44      -1.792  -1.438  -9.280  1.00  7.04           C  
ATOM    342  C   LEU A  44      -1.627  -1.332 -10.781  1.00  7.19           C  
ATOM    343  O   LEU A  44      -0.640  -1.795 -11.332  1.00  6.71           O  
ATOM    344  CB  LEU A  44      -0.803  -0.494  -8.588  1.00  7.22           C  
ATOM    345  CG  LEU A  44      -0.838   0.972  -9.052  1.00  7.05           C  
ATOM    346  CD1 LEU A  44      -2.194   1.601  -8.832  1.00  7.85           C  
ATOM    347  CD2 LEU A  44       0.223   1.792  -8.358  1.00  8.75           C  
ATOM    348  N   ASN A  45      -2.602  -0.704 -11.433  1.00  6.97           N  
ATOM    349  CA  ASN A  45      -2.521  -0.416 -12.863  1.00  7.19           C  
ATOM    350  C   ASN A  45      -2.119  -1.625 -13.688  1.00  7.32           C  
ATOM    351  O   ASN A  45      -1.301  -1.531 -14.599  1.00  7.45           O  
ATOM    352  CB  ASN A  45      -1.586   0.774 -13.101  1.00  7.23           C  
ATOM    353  CG  ASN A  45      -2.125   2.043 -12.483  1.00  7.06           C  
ATOM    354  OD1 ASN A  45      -3.341   2.185 -12.333  1.00  8.11           O  
ATOM    355  ND2 ASN A  45      -1.237   2.950 -12.090  1.00  8.16           N  
ATOM    356  N   GLY A  46      -2.721  -2.764 -13.361  1.00  7.90           N  
ATOM    357  CA  GLY A  46      -2.588  -3.967 -14.163  1.00  8.12           C  
ATOM    358  C   GLY A  46      -1.374  -4.820 -13.855  1.00  8.48           C  
ATOM    359  O   GLY A  46      -1.181  -5.855 -14.493  1.00  9.57           O  
ATOM    360  N   LYS A  47      -0.562  -4.394 -12.887  1.00  8.33           N  
ATOM    361  CA  LYS A  47       0.592  -5.164 -12.455  1.00  8.22           C  
ATOM    362  C   LYS A  47       0.392  -5.684 -11.044  1.00  8.12           C  
ATOM    363  O   LYS A  47       0.006  -4.944 -10.141  1.00  8.11           O  
ATOM    364  CB  LYS A  47       1.874  -4.341 -12.499  1.00  8.44           C  
ATOM    365  CG  LYS A  47       3.110  -5.180 -12.215  1.00  9.19           C  
ATOM    366  CD  LYS A  47       4.370  -4.352 -12.222  1.00 10.81           C  
ATOM    367  CE  LYS A  47       5.601  -5.203 -11.932  1.00 11.07           C  
ATOM    368  NZ  LYS A  47       6.844  -4.392 -11.968  1.00 13.92           N  
ATOM    369  N   ARG A  48       0.658  -6.972 -10.879  1.00  7.76           N  
ATOM    370  CA  ARG A  48       0.706  -7.620  -9.590  1.00  7.88           C  
ATOM    371  C   ARG A  48       2.131  -7.553  -9.064  1.00  7.26           C  
ATOM    372  O   ARG A  48       3.083  -7.801  -9.791  1.00  7.43           O  
ATOM    373  CB  ARG A  48       0.267  -9.064  -9.767  1.00  8.15           C  
ATOM    374  CG  ARG A  48       0.084  -9.831  -8.517  1.00  9.48           C  
ATOM    375  CD  ARG A  48      -0.266 -11.274  -8.798  1.00 11.30           C  
ATOM    376  NE  ARG A  48      -0.462 -12.029  -7.568  1.00 12.31           N  
ATOM    377  CZ  ARG A  48      -1.618 -12.146  -6.922  1.00 12.78           C  
ATOM    378  NH1 ARG A  48      -2.727 -11.551  -7.353  1.00 12.51           N  
ATOM    379  NH2 ARG A  48      -1.657 -12.867  -5.812  1.00 14.30           N  
ATOM    380  N   GLY A  49       2.278  -7.210  -7.792  1.00  6.76           N  
ATOM    381  CA  GLY A  49       3.603  -7.108  -7.208  1.00  6.46           C  
ATOM    382  C   GLY A  49       3.577  -6.829  -5.725  1.00  6.42           C  
ATOM    383  O   GLY A  49       2.526  -6.607  -5.135  1.00  6.45           O  
ATOM    384  N   TRP A  50       4.760  -6.834  -5.133  1.00  5.97           N  
ATOM    385  CA  TRP A  50       4.928  -6.571  -3.714  1.00  6.15           C  
ATOM    386  C   TRP A  50       4.822  -5.081  -3.405  1.00  6.30           C  
ATOM    387  O   TRP A  50       5.328  -4.230  -4.149  1.00  6.60           O  
ATOM    388  CB  TRP A  50       6.287  -7.062  -3.242  1.00  5.96           C  
ATOM    389  CG  TRP A  50       6.511  -8.537  -3.327  1.00  5.54           C  
ATOM    390  CD1 TRP A  50       7.349  -9.185  -4.184  1.00  6.23           C  
ATOM    391  CD2 TRP A  50       5.944  -9.542  -2.478  1.00  5.61           C  
ATOM    392  NE1 TRP A  50       7.322 -10.532  -3.931  1.00  6.80           N  
ATOM    393  CE2 TRP A  50       6.465 -10.780  -2.892  1.00  6.34           C  
ATOM    394  CE3 TRP A  50       5.040  -9.522  -1.407  1.00  6.93           C  
ATOM    395  CZ2 TRP A  50       6.122 -11.979  -2.274  1.00  7.04           C  
ATOM    396  CZ3 TRP A  50       4.695 -10.717  -0.795  1.00  7.82           C  
ATOM    397  CH2 TRP A  50       5.238 -11.931  -1.233  1.00  7.02           C  
ATOM    398  N   VAL A  51       4.185  -4.792  -2.278  1.00  6.60           N  
ATOM    399  CA  VAL A  51       4.038  -3.442  -1.754  1.00  6.95           C  
ATOM    400  C   VAL A  51       4.568  -3.442  -0.318  1.00  6.22           C  
ATOM    401  O   VAL A  51       4.218  -4.323   0.460  1.00  5.95           O  
ATOM    402  CB  VAL A  51       2.553  -3.025  -1.777  1.00  8.05           C  
ATOM    403  CG1 VAL A  51       2.342  -1.652  -1.150  1.00  9.58           C  
ATOM    404  CG2 VAL A  51       2.044  -3.048  -3.189  1.00  9.33           C  
ATOM    405  N   PRO A  52       5.400  -2.468   0.055  1.00  5.74           N  
ATOM    406  CA  PRO A  52       5.849  -2.393   1.448  1.00  5.96           C  
ATOM    407  C   PRO A  52       4.658  -1.940   2.291  1.00  6.12           C  
ATOM    408  O   PRO A  52       4.101  -0.870   2.044  1.00  6.05           O  
ATOM    409  CB  PRO A  52       6.991  -1.374   1.403  1.00  6.09           C  
ATOM    410  CG  PRO A  52       6.699  -0.511   0.213  1.00  6.32           C  
ATOM    411  CD  PRO A  52       5.931  -1.353  -0.758  1.00  6.25           C  
ATOM    412  N   ALA A  53       4.235  -2.771   3.237  1.00  5.86           N  
ATOM    413  CA  ALA A  53       2.970  -2.544   3.941  1.00  6.07           C  
ATOM    414  C   ALA A  53       2.976  -1.253   4.753  1.00  6.25           C  
ATOM    415  O   ALA A  53       1.921  -0.676   5.000  1.00  7.08           O  
ATOM    416  CB  ALA A  53       2.629  -3.727   4.822  1.00  6.32           C  
ATOM    417  N   ASN A  54       4.155  -0.786   5.146  1.00  6.21           N  
ATOM    418  CA  ASN A  54       4.268   0.484   5.864  1.00  6.03           C  
ATOM    419  C   ASN A  54       4.060   1.735   5.005  1.00  6.16           C  
ATOM    420  O   ASN A  54       4.012   2.851   5.531  1.00  6.09           O  
ATOM    421  CB  ASN A  54       5.565   0.569   6.701  1.00  5.79           C  
ATOM    422  CG  ASN A  54       6.848   0.364   5.898  1.00  5.84           C  
ATOM    423  OD1 ASN A  54       6.843   0.072   4.705  1.00  6.38           O  
ATOM    424  ND2 ASN A  54       7.971   0.515   6.584  1.00  6.55           N  
ATOM    425  N   TYR A  55       3.903   1.542   3.695  1.00  6.23           N  
ATOM    426  CA  TYR A  55       3.635   2.649   2.775  1.00  6.45           C  
ATOM    427  C   TYR A  55       2.153   2.842   2.464  1.00  6.93           C  
ATOM    428  O   TYR A  55       1.814   3.799   1.783  1.00  7.57           O  
ATOM    429  CB  TYR A  55       4.395   2.466   1.454  1.00  6.80           C  
ATOM    430  CG  TYR A  55       5.827   2.939   1.502  1.00  6.33           C  
ATOM    431  CD1 TYR A  55       6.722   2.410   2.428  1.00  6.05           C  
ATOM    432  CD2 TYR A  55       6.293   3.913   0.628  1.00  5.93           C  
ATOM    433  CE1 TYR A  55       8.025   2.838   2.479  1.00  7.05           C  
ATOM    434  CE2 TYR A  55       7.606   4.343   0.668  1.00  6.70           C  
ATOM    435  CZ  TYR A  55       8.467   3.796   1.596  1.00  7.12           C  
ATOM    436  OH  TYR A  55       9.775   4.216   1.657  1.00  7.95           O  
ATOM    437  N   VAL A  56       1.287   1.939   2.915  1.00  7.55           N  
ATOM    438  CA  VAL A  56      -0.155   2.067   2.662  1.00  8.34           C  
ATOM    439  C   VAL A  56      -0.883   2.376   3.962  1.00  9.04           C  
ATOM    440  O   VAL A  56      -0.390   2.078   5.050  1.00  9.70           O  
ATOM    441  CB  VAL A  56      -0.755   0.819   1.958  1.00  8.73           C  
ATOM    442  CG1 VAL A  56      -0.153   0.663   0.563  1.00  9.19           C  
ATOM    443  CG2 VAL A  56      -0.554  -0.448   2.781  1.00  9.29           C  
ATOM    444  N   GLN A  57      -2.063   2.972   3.845  1.00  9.53           N  
ATOM    445  CA  GLN A  57      -2.785   3.478   5.004  1.00 10.42           C  
ATOM    446  C   GLN A  57      -3.339   2.342   5.851  1.00 10.83           C  
ATOM    447  O   GLN A  57      -4.038   1.468   5.351  1.00 11.47           O  
ATOM    448  CB  GLN A  57      -3.914   4.391   4.548  1.00 10.76           C  
ATOM    449  CG  GLN A  57      -4.615   5.126   5.679  1.00 11.86           C  
ATOM    450  CD  GLN A  57      -5.619   6.149   5.169  1.00 14.94           C  
ATOM    451  OE1 GLN A  57      -5.944   6.177   3.978  1.00 17.06           O  
ATOM    452  NE2 GLN A  57      -6.113   6.986   6.067  1.00 16.15           N  
ATOM    453  N   ASP A  58      -3.001   2.373   7.137  1.00 11.57           N  
ATOM    454  CA  ASP A  58      -3.395   1.362   8.118  1.00 12.36           C  
ATOM    455  C   ASP A  58      -2.788  -0.014   7.812  1.00 12.45           C  
ATOM    456  O   ASP A  58      -1.987  -0.151   6.876  1.00 12.67           O  
ATOM    457  CB  ASP A  58      -4.920   1.276   8.240  1.00 12.85           C  
ATOM    458  CG  ASP A  58      -5.388   1.325   9.683  1.00 15.08           C  
ATOM    459  OD1 ASP A  58      -4.828   0.598  10.541  1.00 15.08           O  
ATOM    460  OD2 ASP A  58      -6.314   2.080  10.059  1.00 20.91           O  
ATOM    461  N   ILE A  59      -3.138  -1.010   8.627  1.00 12.93           N  
ATOM    462  CA  ILE A  59      -2.761  -2.410   8.393  1.00 13.34           C  
ATOM    463  C   ILE A  59      -3.920  -3.358   8.689  1.00 13.86           C  
ATOM    464  O   ILE A  59      -4.913  -2.988   9.332  1.00 15.85           O  
ATOM    465  CB  ILE A  59      -1.540  -2.831   9.250  1.00 13.23           C  
ATOM    466  CG1 ILE A  59      -1.908  -2.963  10.739  1.00 13.73           C  
ATOM    467  CG2 ILE A  59      -0.387  -1.857   9.069  1.00 12.80           C  
ATOM    468  CD1 ILE A  59      -0.830  -3.638  11.567  1.00 14.71           C  
ATOM    469  OXT ILE A  59      -3.885  -4.536   8.333  1.00 12.75           O  
TER     470      ILE A  59                                                      
END
MOLECULE T0492.pdb
ATOM     18  N   PHE     2      -1.543   4.722  10.626  1.00 74.01
ATOM     19  HN  PHE     2      -1.545   5.677  10.295  1.00  0.00
ATOM     20  CA  PHE     2      -2.153   3.701   9.795  1.00  3.52
ATOM     21  HA  PHE     2      -2.214   2.774  10.364  1.00  0.00
ATOM     22  CB  PHE     2      -3.570   4.116   9.379  1.00 43.40
ATOM     23 2HB  PHE     2      -4.130   4.382  10.276  1.00  0.00
ATOM     24 3HB  PHE     2      -3.499   4.995   8.737  1.00  0.00
ATOM     25  CG  PHE     2      -4.330   3.046   8.642  1.00 20.11
ATOM     26  CD1 PHE     2      -4.372   3.032   7.256  1.00 62.52
ATOM     27 1HD  PHE     2      -3.855   3.800   6.699  1.00  0.00
ATOM     28  CE1 PHE     2      -5.067   2.049   6.579  1.00 34.45
ATOM     29 1HE  PHE     2      -5.093   2.052   5.499  1.00  0.00
ATOM     30  CZ  PHE     2      -5.728   1.064   7.284  1.00 62.44
ATOM     31  HZ  PHE     2      -6.269   0.293   6.756  1.00  0.00
ATOM     32  CE2 PHE     2      -5.698   1.066   8.665  1.00 65.21
ATOM     33 2HE  PHE     2      -6.220   0.300   9.218  1.00  0.00
ATOM     34  CD2 PHE     2      -4.999   2.051   9.338  1.00  5.40
ATOM     35 2HD  PHE     2      -4.974   2.046  10.418  1.00  0.00
ATOM     36  C   PHE     2      -1.276   3.477   8.572  1.00 11.34
ATOM     37  O   PHE     2      -1.121   4.368   7.734  1.00 25.11
ATOM     38  N   SER     3      -0.684   2.301   8.493  1.00 64.43
ATOM     39  HN  SER     3      -0.879   1.592   9.184  1.00  0.00
ATOM     40  CA  SER     3       0.249   1.991   7.431  1.00 24.31
ATOM     41  HA  SER     3       0.539   2.917   6.933  1.00  0.00
ATOM     42  CB  SER     3       1.493   1.334   8.027  1.00 64.20
ATOM     43 2HB  SER     3       1.287   0.280   8.213  1.00  0.00
ATOM     44 3HB  SER     3       2.318   1.424   7.320  1.00  0.00
ATOM     45  OG  SER     3       1.856   1.959   9.247  1.00 35.21
ATOM     46  HG  SER     3       2.639   1.527   9.597  1.00  0.00
ATOM     47  C   SER     3      -0.397   1.063   6.412  1.00 60.05
ATOM     48  O   SER     3      -1.528   0.612   6.597  1.00  3.21
ATOM     49  N   LEU     4       0.328   0.765   5.345  1.00 12.31
ATOM     50  HN  LEU     4       1.247   1.169   5.233  1.00  0.00
ATOM     51  CA  LEU     4      -0.162  -0.138   4.314  1.00 14.12
ATOM     52  HA  LEU     4      -1.150   0.198   4.000  1.00  0.00
ATOM     53  CB  LEU     4       0.773  -0.115   3.101  1.00 12.03
ATOM     54 2HB  LEU     4       0.891   0.923   2.787  1.00  0.00
ATOM     55 3HB  LEU     4       1.739  -0.512   3.413  1.00  0.00
ATOM     56  CG  LEU     4       0.298  -0.924   1.891  1.00 23.03
ATOM     57  HG  LEU     4       0.144  -1.956   2.206  1.00  0.00
ATOM     58  CD1 LEU     4      -1.022  -0.380   1.370  1.00 51.12
ATOM     59 1HD1 LEU     4      -1.358  -0.976   0.522  1.00  0.00
ATOM     60 2HD1 LEU     4      -1.770  -0.424   2.162  1.00  0.00
ATOM     61 3HD1 LEU     4      -0.888   0.655   1.054  1.00  0.00
ATOM     62  CD2 LEU     4       1.353  -0.909   0.796  1.00 63.44
ATOM     63 1HD2 LEU     4       1.014  -1.505  -0.051  1.00  0.00
ATOM     64 2HD2 LEU     4       1.524   0.118   0.470  1.00  0.00
ATOM     65 3HD2 LEU     4       2.283  -1.326   1.182  1.00  0.00
ATOM     66  C   LEU     4      -0.277  -1.556   4.867  1.00 33.11
ATOM     67  O   LEU     4      -1.097  -2.351   4.413  1.00 44.21
ATOM     68  N   ARG     5       0.537  -1.858   5.872  1.00 30.21
ATOM     69  HN  ARG     5       1.184  -1.165   6.222  1.00  0.00
ATOM     70  CA  ARG     5       0.527  -3.177   6.493  1.00 63.40
ATOM     71  HA  ARG     5       0.383  -3.914   5.703  1.00  0.00
ATOM     72  CB  ARG     5       1.875  -3.467   7.172  1.00 74.52
ATOM     73 2HB  ARG     5       1.804  -4.437   7.663  1.00  0.00
ATOM     74 3HB  ARG     5       2.642  -3.506   6.398  1.00  0.00
ATOM     75  CG  ARG     5       2.309  -2.440   8.214  1.00  4.51
ATOM     76 2HG  ARG     5       3.389  -2.511   8.347  1.00  0.00
ATOM     77 3HG  ARG     5       2.052  -1.444   7.852  1.00  0.00
ATOM     78  CD  ARG     5       1.636  -2.660   9.559  1.00 60.41
ATOM     79 2HD  ARG     5       0.561  -2.522   9.442  1.00  0.00
ATOM     80 3HD  ARG     5       1.833  -3.680   9.889  1.00  0.00
ATOM     81  NE  ARG     5       2.123  -1.732  10.576  1.00 53.25
ATOM     82  HE  ARG     5       2.750  -1.000  10.273  1.00  0.00
ATOM     83  CZ  ARG     5       1.788  -1.799  11.863  1.00 31.32
ATOM     84  NH1 ARG     5       0.974  -2.752  12.297  1.00 42.13
ATOM     85 1HH1 ARG     5       0.725  -2.799  13.274  1.00  0.00
ATOM     86 2HH1 ARG     5       0.603  -3.431  11.649  1.00  0.00
ATOM     87  NH2 ARG     5       2.275  -0.912  12.719  1.00  5.31
ATOM     88 1HH2 ARG     5       2.024  -0.962  13.696  1.00  0.00
ATOM     89 2HH2 ARG     5       2.898  -0.185  12.394  1.00  0.00
ATOM     90  C   ARG     5      -0.629  -3.317   7.482  1.00 10.22
ATOM     91  O   ARG     5      -0.864  -4.396   8.028  1.00 64.31
ATOM     92  N   ASP     6      -1.337  -2.219   7.719  1.00 63.24
ATOM     93  HN  ASP     6      -1.079  -1.348   7.276  1.00  0.00
ATOM     94  CA  ASP     6      -2.490  -2.231   8.612  1.00 35.34
ATOM     95  HA  ASP     6      -2.323  -2.992   9.374  1.00  0.00
ATOM     96  CB  ASP     6      -2.667  -0.876   9.304  1.00 22.10
ATOM     97 2HB  ASP     6      -2.603  -0.090   8.551  1.00  0.00
ATOM     98 3HB  ASP     6      -3.653  -0.848   9.767  1.00  0.00
ATOM     99  CG  ASP     6      -1.625  -0.608  10.371  1.00 45.42
ATOM    100  OD1 ASP     6      -1.739  -1.182  11.475  1.00 64.32
ATOM    101  OD2 ASP     6      -0.704   0.198  10.124  1.00 21.34
ATOM    102 2HD  ASP     6      -0.086   0.324  10.848  1.00  0.00
ATOM    103  C   ASP     6      -3.756  -2.578   7.839  1.00 55.21
ATOM    104  O   ASP     6      -4.831  -2.744   8.422  1.00 30.54
ATOM    105  N   ALA     7      -3.625  -2.680   6.524  1.00 72.34
ATOM    106  HN  ALA     7      -2.728  -2.503   6.093  1.00  0.00
ATOM    107  CA  ALA     7      -4.743  -3.041   5.669  1.00 22.13
ATOM    108  HA  ALA     7      -5.659  -2.672   6.130  1.00  0.00
ATOM    109  CB  ALA     7      -4.595  -2.392   4.302  1.00 22.42
ATOM    110 1HB  ALA     7      -5.451  -2.648   3.677  1.00  0.00
ATOM    111 2HB  ALA     7      -4.544  -1.309   4.418  1.00  0.00
ATOM    112 3HB  ALA     7      -3.681  -2.749   3.828  1.00  0.00
ATOM    113  C   ALA     7      -4.843  -4.555   5.534  1.00 53.13
ATOM    114  O   ALA     7      -3.841  -5.264   5.629  1.00 30.50
ATOM    115  N   LYS     8      -6.054  -5.046   5.322  1.00 32.51
ATOM    116  HN  LYS     8      -6.843  -4.420   5.247  1.00  0.00
ATOM    117  CA  LYS     8      -6.289  -6.477   5.191  1.00 22.44
ATOM    118  HA  LYS     8      -5.454  -7.012   5.645  1.00  0.00
ATOM    119  CB  LYS     8      -7.584  -6.872   5.910  1.00 13.25
ATOM    120 2HB  LYS     8      -8.423  -6.441   5.364  1.00  0.00
ATOM    121 3HB  LYS     8      -7.663  -7.959   5.899  1.00  0.00
ATOM    122  CG  LYS     8      -7.664  -6.403   7.354  1.00 65.44
ATOM    123 2HG  LYS     8      -7.546  -5.319   7.379  1.00  0.00
ATOM    124 3HG  LYS     8      -8.640  -6.671   7.758  1.00  0.00
ATOM    125  CD  LYS     8      -6.584  -7.035   8.217  1.00 11.52
ATOM    126 2HD  LYS     8      -6.700  -8.118   8.196  1.00  0.00
ATOM    127 3HD  LYS     8      -5.606  -6.767   7.816  1.00  0.00
ATOM    128  CE  LYS     8      -6.680  -6.553   9.654  1.00 44.24
ATOM    129 2HE  LYS     8      -6.530  -5.473   9.674  1.00  0.00
ATOM    130 3HE  LYS     8      -7.674  -6.784  10.037  1.00  0.00
ATOM    131  NZ  LYS     8      -5.665  -7.196  10.531  1.00  4.24
ATOM    132 1HZ  LYS     8      -5.760  -6.850  11.475  1.00  0.00
ATOM    133 2HZ  LYS     8      -5.801  -8.196  10.525  1.00  0.00
ATOM    134 3HZ  LYS     8      -4.740  -6.980  10.188  1.00  0.00
ATOM    135  C   LYS     8      -6.383  -6.857   3.718  1.00 42.14
ATOM    136  O   LYS     8      -6.815  -6.049   2.891  1.00 20.55
ATOM    137  N   CYS     9      -5.980  -8.076   3.388  1.00 41.51
ATOM    138  HN  CYS     9      -5.610  -8.695   4.094  1.00  0.00
ATOM    139  CA  CYS     9      -6.058  -8.552   2.015  1.00  2.35
ATOM    140  HA  CYS     9      -5.629  -7.787   1.367  1.00  0.00
ATOM    141  CB  CYS     9      -5.243  -9.834   1.843  1.00 21.02
ATOM    142 2HB  CYS     9      -5.616 -10.355   0.961  1.00  0.00
ATOM    143 3HB  CYS     9      -4.201  -9.552   1.687  1.00  0.00
ATOM    144  SG  CYS     9      -5.327 -10.961   3.252  1.00 72.52
ATOM    145  HG  CYS     9      -4.531 -11.912   2.755  1.00  0.00
ATOM    146  C   CYS     9      -7.512  -8.761   1.608  1.00 15.30
ATOM    147  O   CYS     9      -8.192  -9.663   2.102  1.00 13.32
ATOM    148  N   GLY    10      -7.978  -7.908   0.711  1.00 51.22
ATOM    149  HN  GLY    10      -7.355  -7.248   0.267  1.00  0.00
ATOM    150  CA  GLY    10      -9.376  -7.897   0.346  1.00  3.45
ATOM    151 1HA  GLY    10      -9.478  -8.244  -0.682  1.00  0.00
ATOM    152 2HA  GLY    10      -9.922  -8.567   1.009  1.00  0.00
ATOM    153  C   GLY    10      -9.962  -6.506   0.458  1.00 12.24
ATOM    154  O   GLY    10     -11.091  -6.256   0.029  1.00 13.34
ATOM    155  N   GLN    11      -9.191  -5.600   1.045  1.00 41.41
ATOM    156  HN  GLN    11      -8.285  -5.870   1.401  1.00  0.00
ATOM    157  CA  GLN    11      -9.605  -4.213   1.198  1.00 43.31
ATOM    158  HA  GLN    11     -10.686  -4.162   1.069  1.00  0.00
ATOM    159  CB  GLN    11      -9.253  -3.704   2.597  1.00 35.22
ATOM    160 2HB  GLN    11      -8.178  -3.812   2.741  1.00  0.00
ATOM    161 3HB  GLN    11      -9.523  -2.649   2.657  1.00  0.00
ATOM    162  CG  GLN    11      -9.963  -4.445   3.718  1.00 24.45
ATOM    163 2HG  GLN    11     -11.038  -4.302   3.607  1.00  0.00
ATOM    164 3HG  GLN    11      -9.731  -5.507   3.638  1.00  0.00
ATOM    165  CD  GLN    11      -9.544  -3.956   5.092  1.00 53.41
ATOM    166  OE1 GLN    11      -8.414  -3.504   5.288  1.00 54.04
ATOM    167  NE2 GLN    11     -10.448  -4.036   6.053  1.00 44.33
ATOM    168 1HE2 GLN    11     -11.363  -4.411   5.850  1.00  0.00
ATOM    169 2HE2 GLN    11     -10.222  -3.722   6.986  1.00  0.00
ATOM    170  C   GLN    11      -8.945  -3.330   0.142  1.00  4.23
ATOM    171  O   GLN    11      -7.996  -3.743  -0.527  1.00 30.34
ATOM    172  N   THR    12      -9.461  -2.119  -0.008  1.00  5.22
ATOM    173  HN  THR    12     -10.253  -1.839   0.553  1.00  0.00
ATOM    174  CA  THR    12      -8.921  -1.166  -0.962  1.00 72.31
ATOM    175  HA  THR    12      -8.091  -1.639  -1.488  1.00  0.00
ATOM    176  CB  THR    12      -9.989  -0.754  -1.992  1.00 24.54
ATOM    177  HB  THR    12     -10.761  -0.176  -1.484  1.00  0.00
ATOM    178  OG1 THR    12     -10.582  -1.926  -2.562  1.00 13.33
ATOM    179 1HG  THR    12     -11.256  -1.655  -3.189  1.00  0.00
ATOM    180  CG2 THR    12      -9.387   0.100  -3.099  1.00  4.01
ATOM    181 1HG2 THR    12     -10.161   0.386  -3.812  1.00  0.00
ATOM    182 2HG2 THR    12      -8.948   0.999  -2.665  1.00  0.00
ATOM    183 3HG2 THR    12      -8.613  -0.469  -3.615  1.00  0.00
ATOM    184  C   THR    12      -8.405   0.076  -0.241  1.00 11.14
ATOM    185  O   THR    12      -9.153   0.749   0.471  1.00 21.50
ATOM    186  N   VAL    13      -7.125   0.365  -0.412  1.00 64.12
ATOM    187  HN  VAL    13      -6.544  -0.236  -0.979  1.00  0.00
ATOM    188  CA  VAL    13      -6.521   1.536   0.199  1.00 41.30
ATOM    189  HA  VAL    13      -7.285   2.035   0.796  1.00  0.00
ATOM    190  CB  VAL    13      -5.340   1.166   1.121  1.00 62.24
ATOM    191  HB  VAL    13      -4.903   2.090   1.500  1.00  0.00
ATOM    192  CG1 VAL    13      -5.810   0.344   2.308  1.00 31.14
ATOM    193 1HG1 VAL    13      -4.965   0.114   2.957  1.00  0.00
ATOM    194 2HG1 VAL    13      -6.553   0.911   2.869  1.00  0.00
ATOM    195 3HG1 VAL    13      -6.255  -0.585   1.951  1.00  0.00
ATOM    196  CG2 VAL    13      -4.269   0.420   0.344  1.00  1.13
ATOM    197 1HG2 VAL    13      -3.430   0.189   1.000  1.00  0.00
ATOM    198 2HG2 VAL    13      -4.686  -0.506  -0.050  1.00  0.00
ATOM    199 3HG2 VAL    13      -3.921   1.042  -0.482  1.00  0.00
ATOM    200  C   VAL    13      -6.022   2.500  -0.866  1.00 61.23
ATOM    201  O   VAL    13      -5.900   2.144  -2.036  1.00 43.41
ATOM    202  N   LYS    14      -5.745   3.721  -0.452  1.00 54.14
ATOM    203  HN  LYS    14      -5.945   3.983   0.502  1.00  0.00
ATOM    204  CA  LYS    14      -5.155   4.717  -1.328  1.00 51.51
ATOM    205  HA  LYS    14      -4.765   4.211  -2.211  1.00  0.00
ATOM    206  CB  LYS    14      -6.208   5.727  -1.778  1.00 14.21
ATOM    207 2HB  LYS    14      -6.942   5.841  -0.981  1.00  0.00
ATOM    208 3HB  LYS    14      -5.716   6.684  -1.959  1.00  0.00
ATOM    209  CG  LYS    14      -6.932   5.308  -3.046  1.00 34.22
ATOM    210 2HG  LYS    14      -6.291   5.518  -3.903  1.00  0.00
ATOM    211 3HG  LYS    14      -7.136   4.239  -2.998  1.00  0.00
ATOM    212  CD  LYS    14      -8.243   6.050  -3.222  1.00 32.42
ATOM    213 2HD  LYS    14      -8.659   5.803  -4.199  1.00  0.00
ATOM    214 3HD  LYS    14      -8.934   5.733  -2.442  1.00  0.00
ATOM    215  CE  LYS    14      -8.062   7.556  -3.134  1.00 65.41
ATOM    216 2HE  LYS    14      -7.710   7.813  -2.135  1.00  0.00
ATOM    217 3HE  LYS    14      -7.317   7.867  -3.867  1.00  0.00
ATOM    218  NZ  LYS    14      -9.330   8.278  -3.400  1.00 21.43
ATOM    219 1HZ  LYS    14      -9.175   9.274  -3.334  1.00  0.00
ATOM    220 2HZ  LYS    14      -9.657   8.051  -4.328  1.00  0.00
ATOM    221 3HZ  LYS    14     -10.023   8.001  -2.721  1.00  0.00
ATOM    222  C   LYS    14      -4.006   5.413  -0.624  1.00 53.31
ATOM    223  O   LYS    14      -4.100   5.736   0.560  1.00 40.05
ATOM    224  N   VAL    15      -2.921   5.620  -1.351  1.00 31.31
ATOM    225  HN  VAL    15      -2.912   5.364  -2.328  1.00  0.00
ATOM    226  CA  VAL    15      -1.723   6.214  -0.779  1.00 74.25
ATOM    227  HA  VAL    15      -1.564   5.774   0.205  1.00  0.00
ATOM    228  CB  VAL    15      -0.481   5.931  -1.651  1.00 55.30
ATOM    229  HB  VAL    15      -0.611   6.440  -2.606  1.00  0.00
ATOM    230  CG1 VAL    15       0.778   6.475  -0.991  1.00 60.13
ATOM    231 1HG1 VAL    15       1.641   6.287  -1.630  1.00  0.00
ATOM    232 2HG1 VAL    15       0.671   7.549  -0.836  1.00  0.00
ATOM    233 3HG1 VAL    15       0.926   5.982  -0.030  1.00  0.00
ATOM    234  CG2 VAL    15      -0.345   4.442  -1.921  1.00  4.15
ATOM    235 1HG2 VAL    15       0.522   4.260  -2.557  1.00  0.00
ATOM    236 2HG2 VAL    15      -0.218   3.913  -0.977  1.00  0.00
ATOM    237 3HG2 VAL    15      -1.243   4.082  -2.422  1.00  0.00
ATOM    238  C   VAL    15      -1.890   7.716  -0.621  1.00  1.34
ATOM    239  O   VAL    15      -2.316   8.401  -1.552  1.00 64.13
ATOM    240  N   VAL    16      -1.568   8.222   0.556  1.00 40.44
ATOM    241  HN  VAL    16      -1.280   7.613   1.309  1.00  0.00
ATOM    242  CA  VAL    16      -1.618   9.653   0.797  1.00 52.11
ATOM    243  HA  VAL    16      -1.981  10.122  -0.118  1.00  0.00
ATOM    244  CB  VAL    16      -2.600  10.025   1.935  1.00 74.41
ATOM    245  HB  VAL    16      -2.405  11.057   2.229  1.00  0.00
ATOM    246  CG1 VAL    16      -4.034   9.925   1.446  1.00 32.42
ATOM    247 1HG1 VAL    16      -4.717  10.214   2.244  1.00  0.00
ATOM    248 2HG1 VAL    16      -4.173  10.590   0.593  1.00  0.00
ATOM    249 3HG1 VAL    16      -4.243   8.899   1.144  1.00  0.00
ATOM    250  CG2 VAL    16      -2.406   9.136   3.156  1.00 60.05
ATOM    251 1HG2 VAL    16      -3.096   9.432   3.946  1.00  0.00
ATOM    252 2HG2 VAL    16      -2.595   8.099   2.881  1.00  0.00
ATOM    253 3HG2 VAL    16      -1.382   9.235   3.516  1.00  0.00
ATOM    254  C   VAL    16      -0.230  10.206   1.086  1.00  3.43
ATOM    255  O   VAL    16       0.258  11.073   0.364  1.00 72.51
ATOM    256  N   LYS    17       0.420   9.684   2.111  1.00 33.10
ATOM    257  HN  LYS    17      -0.011   8.959   2.665  1.00  0.00
ATOM    258  CA  LYS    17       1.756  10.131   2.468  1.00 73.35
ATOM    259  HA  LYS    17       2.045  10.925   1.779  1.00  0.00
ATOM    260  CB  LYS    17       1.793  10.682   3.894  1.00 53.01
ATOM    261 2HB  LYS    17       1.381   9.926   4.562  1.00  0.00
ATOM    262 3HB  LYS    17       2.833  10.873   4.159  1.00  0.00
ATOM    263  CG  LYS    17       1.009  11.969   4.091  1.00 34.34
ATOM    264 2HG  LYS    17       1.380  12.723   3.395  1.00  0.00
ATOM    265 3HG  LYS    17      -0.045  11.779   3.892  1.00  0.00
ATOM    266  CD  LYS    17       1.162  12.485   5.510  1.00 73.01
ATOM    267 2HD  LYS    17       0.785  11.732   6.202  1.00  0.00
ATOM    268 3HD  LYS    17       2.219  12.664   5.708  1.00  0.00
ATOM    269  CE  LYS    17       0.397  13.778   5.726  1.00 72.44
ATOM    270 2HE  LYS    17       0.783  14.537   5.044  1.00  0.00
ATOM    271 3HE  LYS    17      -0.657  13.606   5.511  1.00  0.00
ATOM    272  NZ  LYS    17       0.532  14.270   7.122  1.00 74.42
ATOM    273 1HZ  LYS    17       0.013  15.130   7.232  1.00  0.00
ATOM    274 2HZ  LYS    17       0.170  13.576   7.759  1.00  0.00
ATOM    275 3HZ  LYS    17       1.507  14.439   7.326  1.00  0.00
ATOM    276  C   LYS    17       2.750   8.992   2.350  1.00 74.25
ATOM    277  O   LYS    17       2.376   7.820   2.348  1.00 52.02
ATOM    278  N   LEU    18       4.017   9.343   2.254  1.00 42.21
ATOM    279  HN  LEU    18       4.264  10.322   2.204  1.00  0.00
ATOM    280  CA  LEU    18       5.081   8.363   2.217  1.00 13.22
ATOM    281  HA  LEU    18       4.671   7.391   2.491  1.00  0.00
ATOM    282  CB  LEU    18       5.677   8.265   0.810  1.00 61.32
ATOM    283 2HB  LEU    18       5.975   9.267   0.499  1.00  0.00
ATOM    284 3HB  LEU    18       6.557   7.624   0.860  1.00  0.00
ATOM    285  CG  LEU    18       4.738   7.698  -0.258  1.00 65.15
ATOM    286  HG  LEU    18       3.824   8.292  -0.268  1.00  0.00
ATOM    287  CD1 LEU    18       5.386   7.783  -1.627  1.00 22.25
ATOM    288 1HD1 LEU    18       4.704   7.393  -2.382  1.00  0.00
ATOM    289 2HD1 LEU    18       5.619   8.824  -1.854  1.00  0.00
ATOM    290 3HD1 LEU    18       6.305   7.197  -1.631  1.00  0.00
ATOM    291  CD2 LEU    18       4.378   6.256   0.065  1.00 71.20
ATOM    292 1HD2 LEU    18       3.697   5.869  -0.693  1.00  0.00
ATOM    293 2HD2 LEU    18       5.285   5.651   0.080  1.00  0.00
ATOM    294 3HD2 LEU    18       3.896   6.213   1.041  1.00  0.00
ATOM    295  C   LEU    18       6.152   8.749   3.221  1.00 42.33
ATOM    296  O   LEU    18       6.836   9.754   3.048  1.00 73.24
ATOM    297  N   HIS    19       6.265   7.978   4.287  1.00 41.13
ATOM    298  HN  HIS    19       5.664   7.175   4.397  1.00  0.00
ATOM    299  CA  HIS    19       7.248   8.262   5.321  1.00 64.44
ATOM    300  HA  HIS    19       7.383   9.343   5.380  1.00  0.00
ATOM    301  CB  HIS    19       6.772   7.752   6.689  1.00 21.33
ATOM    302 2HB  HIS    19       6.602   6.678   6.615  1.00  0.00
ATOM    303 3HB  HIS    19       7.562   7.936   7.418  1.00  0.00
ATOM    304  CG  HIS    19       5.512   8.397   7.186  1.00 62.22
ATOM    305  ND1 HIS    19       5.494   9.362   8.169  1.00 53.41
ATOM    306  CD2 HIS    19       4.217   8.192   6.844  1.00 31.35
ATOM    307 1HD  HIS    19       6.309   9.737   8.634  1.00  0.00
ATOM    308  CE1 HIS    19       4.247   9.721   8.409  1.00 52.24
ATOM    309  NE2 HIS    19       3.450   9.027   7.619  1.00 64.53
ATOM    310 2HD  HIS    19       3.855   7.500   6.099  1.00  0.00
ATOM    311 1HE  HIS    19       3.932  10.460   9.131  1.00  0.00
ATOM    312 2HE  HIS    19       2.443   9.098   7.589  1.00  0.00
ATOM    313  C   HIS    19       8.580   7.618   4.964  1.00 43.41
ATOM    314  O   HIS    19       8.642   6.745   4.098  1.00 51.35
ATOM    315  N   GLY    20       9.643   8.056   5.620  1.00  2.20
ATOM    316  HN  GLY    20       9.559   8.812   6.285  1.00  0.00
ATOM    317  CA  GLY    20      10.943   7.462   5.397  1.00 72.45
ATOM    318 1HA  GLY    20      11.172   6.798   6.231  1.00  0.00
ATOM    319 2HA  GLY    20      10.909   6.884   4.474  1.00  0.00
ATOM    320  C   GLY    20      12.042   8.495   5.283  1.00 54.34
ATOM    321  O   GLY    20      11.782   9.697   5.320  1.00 10.33
ATOM    322  N   THR    21      13.267   8.020   5.119  1.00 54.33
ATOM    323  HN  THR    21      13.405   7.022   5.054  1.00  0.00
ATOM    324  CA  THR    21      14.442   8.881   5.026  1.00  4.12
ATOM    325  HA  THR    21      14.319   9.703   5.731  1.00  0.00
ATOM    326  CB  THR    21      15.700   8.083   5.402  1.00 61.42
ATOM    327  HB  THR    21      16.579   8.634   5.067  1.00  0.00
ATOM    328  OG1 THR    21      15.667   6.809   4.743  1.00 21.03
ATOM    329 1HG  THR    21      16.465   6.326   4.972  1.00  0.00
ATOM    330  CG2 THR    21      15.792   7.884   6.909  1.00 20.30
ATOM    331 1HG2 THR    21      16.693   7.322   7.154  1.00  0.00
ATOM    332 2HG2 THR    21      15.829   8.856   7.401  1.00  0.00
ATOM    333 3HG2 THR    21      14.918   7.334   7.255  1.00  0.00
ATOM    334  C   THR    21      14.623   9.464   3.621  1.00 30.23
ATOM    335  O   THR    21      15.746   9.711   3.182  1.00 75.23
ATOM    336  N   GLY    22      13.518   9.692   2.923  1.00 32.25
ATOM    337  HN  GLY    22      12.614   9.471   3.314  1.00  0.00
ATOM    338  CA  GLY    22      13.583  10.262   1.589  1.00 22.11
ATOM    339 1HA  GLY    22      12.614  10.698   1.348  1.00  0.00
ATOM    340 2HA  GLY    22      14.343  11.044   1.580  1.00  0.00
ATOM    341  C   GLY    22      13.931   9.233   0.531  1.00 74.52
ATOM    342  O   GLY    22      13.140   8.977  -0.377  1.00 73.21
ATOM    343  N   ALA    23      15.110   8.634   0.661  1.00 20.51
ATOM    344  HN  ALA    23      15.708   8.875   1.439  1.00  0.00
ATOM    345  CA  ALA    23      15.584   7.630  -0.287  1.00 74.44
ATOM    346  HA  ALA    23      15.664   8.101  -1.267  1.00  0.00
ATOM    347  CB  ALA    23      16.961   7.132   0.122  1.00 64.42
ATOM    348 1HB  ALA    23      17.322   6.407  -0.607  1.00  0.00
ATOM    349 2HB  ALA    23      17.653   7.974   0.167  1.00  0.00
ATOM    350 3HB  ALA    23      16.900   6.660   1.102  1.00  0.00
ATOM    351  C   ALA    23      14.605   6.465  -0.391  1.00 45.31
ATOM    352  O   ALA    23      14.386   5.915  -1.473  1.00 25.24
ATOM    353  N   LEU    24      14.015   6.101   0.741  1.00 14.13
ATOM    354  HN  LEU    24      14.259   6.564   1.605  1.00  0.00
ATOM    355  CA  LEU    24      13.015   5.043   0.780  1.00 61.23
ATOM    356  HA  LEU    24      13.452   4.138   0.358  1.00  0.00
ATOM    357  CB  LEU    24      12.599   4.760   2.230  1.00 63.32
ATOM    358 2HB  LEU    24      13.497   4.510   2.794  1.00  0.00
ATOM    359 3HB  LEU    24      12.156   5.670   2.636  1.00  0.00
ATOM    360  CG  LEU    24      11.592   3.621   2.414  1.00 32.01
ATOM    361  HG  LEU    24      10.713   3.839   1.807  1.00  0.00
ATOM    362  CD1 LEU    24      12.184   2.300   1.942  1.00 12.44
ATOM    363 1HD1 LEU    24      11.450   1.503   2.059  1.00  0.00
ATOM    364 2HD1 LEU    24      12.462   2.383   0.891  1.00  0.00
ATOM    365 3HD1 LEU    24      13.069   2.067   2.534  1.00  0.00
ATOM    366  CD2 LEU    24      11.159   3.523   3.866  1.00 51.42
ATOM    367 1HD2 LEU    24      10.427   2.724   3.980  1.00  0.00
ATOM    368 2HD2 LEU    24      12.027   3.309   4.489  1.00  0.00
ATOM    369 3HD2 LEU    24      10.714   4.469   4.176  1.00  0.00
ATOM    370  C   LEU    24      11.799   5.439  -0.057  1.00  1.54
ATOM    371  O   LEU    24      11.283   4.637  -0.835  1.00  3.43
ATOM    372  N   LYS    25      11.374   6.692   0.088  1.00 73.40
ATOM    373  HN  LYS    25      11.853   7.311   0.726  1.00  0.00
ATOM    374  CA  LYS    25      10.227   7.213  -0.650  1.00 74.22
ATOM    375  HA  LYS    25       9.353   6.610  -0.405  1.00  0.00
ATOM    376  CB  LYS    25       9.951   8.670  -0.266  1.00 62.33
ATOM    377 2HB  LYS    25      10.752   9.288  -0.673  1.00  0.00
ATOM    378 3HB  LYS    25       9.002   8.967  -0.711  1.00  0.00
ATOM    379  CG  LYS    25       9.873   8.915   1.232  1.00 12.02
ATOM    380 2HG  LYS    25       9.042   8.343   1.643  1.00  0.00
ATOM    381 3HG  LYS    25      10.804   8.589   1.695  1.00  0.00
ATOM    382  CD  LYS    25       9.658  10.389   1.535  1.00 54.14
ATOM    383 2HD  LYS    25      10.428  10.971   1.028  1.00  0.00
ATOM    384 3HD  LYS    25       8.677  10.687   1.166  1.00  0.00
ATOM    385  CE  LYS    25       9.730  10.668   3.025  1.00 61.02
ATOM    386 2HE  LYS    25       8.994  10.049   3.536  1.00  0.00
ATOM    387 3HE  LYS    25      10.727  10.411   3.385  1.00  0.00
ATOM    388  NZ  LYS    25       9.459  12.095   3.337  1.00 24.04
ATOM    389 1HZ  LYS    25       9.515  12.244   4.334  1.00  0.00
ATOM    390 2HZ  LYS    25      10.143  12.676   2.873  1.00  0.00
ATOM    391 3HZ  LYS    25       8.534  12.340   3.013  1.00  0.00
ATOM    392  C   LYS    25      10.485   7.132  -2.149  1.00 70.34
ATOM    393  O   LYS    25       9.607   6.757  -2.924  1.00 31.33
ATOM    394  N   ARG    26      11.706   7.480  -2.540  1.00 33.41
ATOM    395  HN  ARG    26      12.385   7.772  -1.852  1.00  0.00
ATOM    396  CA  ARG    26      12.112   7.459  -3.940  1.00 75.34
ATOM    397  HA  ARG    26      11.446   8.111  -4.505  1.00  0.00
ATOM    398  CB  ARG    26      13.544   7.987  -4.064  1.00 32.11
ATOM    399 2HB  ARG    26      13.577   8.987  -3.630  1.00  0.00
ATOM    400 3HB  ARG    26      14.201   7.324  -3.501  1.00  0.00
ATOM    401  CG  ARG    26      14.066   8.072  -5.490  1.00 13.24
ATOM    402 2HG  ARG    26      15.118   8.359  -5.464  1.00  0.00
ATOM    403 3HG  ARG    26      13.968   7.094  -5.961  1.00  0.00
ATOM    404  CD  ARG    26      13.299   9.092  -6.313  1.00 22.45
ATOM    405 2HD  ARG    26      12.303   8.702  -6.523  1.00  0.00
ATOM    406 3HD  ARG    26      13.209  10.015  -5.740  1.00  0.00
ATOM    407  NE  ARG    26      13.972   9.382  -7.579  1.00 22.31
ATOM    408  HE  ARG    26      14.692   8.740  -7.879  1.00  0.00
ATOM    409  CZ  ARG    26      13.691  10.432  -8.347  1.00 31.33
ATOM    410  NH1 ARG    26      12.691  11.244  -8.027  1.00 22.21
ATOM    411 1HH1 ARG    26      12.477  12.037  -8.615  1.00  0.00
ATOM    412 2HH1 ARG    26      12.145  11.069  -7.196  1.00  0.00
ATOM    413  NH2 ARG    26      14.399  10.655  -9.444  1.00 51.44
ATOM    414 1HH2 ARG    26      14.184  11.449 -10.031  1.00  0.00
ATOM    415 2HH2 ARG    26      15.154  10.032  -9.694  1.00  0.00
ATOM    416  C   ARG    26      12.016   6.050  -4.512  1.00 35.02
ATOM    417  O   ARG    26      11.545   5.859  -5.629  1.00 22.34
ATOM    418  N   ARG    27      12.457   5.069  -3.735  1.00 44.44
ATOM    419  HN  ARG    27      12.856   5.284  -2.832  1.00  0.00
ATOM    420  CA  ARG    27      12.385   3.673  -4.149  1.00 12.51
ATOM    421  HA  ARG    27      12.882   3.573  -5.114  1.00  0.00
ATOM    422  CB  ARG    27      13.107   2.783  -3.131  1.00 31.11
ATOM    423 2HB  ARG    27      14.164   3.050  -3.131  1.00  0.00
ATOM    424 3HB  ARG    27      12.683   2.976  -2.146  1.00  0.00
ATOM    425  CG  ARG    27      12.989   1.294  -3.420  1.00 32.35
ATOM    426 2HG  ARG    27      11.940   1.005  -3.366  1.00  0.00
ATOM    427 3HG  ARG    27      13.369   1.097  -4.423  1.00  0.00
ATOM    428  CD  ARG    27      13.781   0.468  -2.420  1.00 60.11
ATOM    429 2HD  ARG    27      14.843   0.677  -2.551  1.00  0.00
ATOM    430 3HD  ARG    27      13.482   0.753  -1.411  1.00  0.00
ATOM    431  NE  ARG    27      13.556  -0.964  -2.594  1.00  3.31
ATOM    432  HE  ARG    27      12.608  -1.263  -2.773  1.00  0.00
ATOM    433  CZ  ARG    27      14.515  -1.886  -2.532  1.00 50.51
ATOM    434  NH1 ARG    27      15.778  -1.533  -2.323  1.00 44.43
ATOM    435 1HH1 ARG    27      16.501  -2.237  -2.277  1.00  0.00
ATOM    436 2HH1 ARG    27      16.017  -0.558  -2.210  1.00  0.00
ATOM    437  NH2 ARG    27      14.207  -3.166  -2.680  1.00 61.44
ATOM    438 1HH2 ARG    27      14.932  -3.868  -2.634  1.00  0.00
ATOM    439 2HH2 ARG    27      13.248  -3.439  -2.840  1.00  0.00
ATOM    440  C   ARG    27      10.929   3.241  -4.302  1.00 45.42
ATOM    441  O   ARG    27      10.558   2.608  -5.291  1.00  0.02
ATOM    442  N   ILE    28      10.112   3.600  -3.319  1.00 44.23
ATOM    443  HN  ILE    28      10.482   4.097  -2.521  1.00  0.00
ATOM    444  CA  ILE    28       8.687   3.305  -3.346  1.00  2.21
ATOM    445  HA  ILE    28       8.567   2.223  -3.392  1.00  0.00
ATOM    446  CB  ILE    28       8.003   3.822  -2.059  1.00  5.03
ATOM    447  HB  ILE    28       8.209   4.889  -1.966  1.00  0.00
ATOM    448  CG2 ILE    28       6.496   3.631  -2.123  1.00 64.14
ATOM    449 1HG2 ILE    28       6.035   4.020  -1.215  1.00  0.00
ATOM    450 2HG2 ILE    28       6.100   4.166  -2.986  1.00  0.00
ATOM    451 3HG2 ILE    28       6.269   2.570  -2.218  1.00  0.00
ATOM    452  CG1 ILE    28       8.581   3.106  -0.835  1.00 34.04
ATOM    453 2HG1 ILE    28       8.331   2.048  -0.907  1.00  0.00
ATOM    454 3HG1 ILE    28       9.665   3.226  -0.848  1.00  0.00
ATOM    455  CD1 ILE    28       8.059   3.631   0.487  1.00 51.31
ATOM    456 1HD1 ILE    28       8.504   3.085   1.318  1.00  0.00
ATOM    457 2HD1 ILE    28       8.311   4.688   0.579  1.00  0.00
ATOM    458 3HD1 ILE    28       6.976   3.512   0.519  1.00  0.00
ATOM    459  C   ILE    28       8.017   3.920  -4.578  1.00 52.21
ATOM    460  O   ILE    28       7.316   3.230  -5.323  1.00 25.22
ATOM    461  N   MET    29       8.265   5.207  -4.799  1.00 11.03
ATOM    462  HN  MET    29       8.898   5.706  -4.190  1.00  0.00
ATOM    463  CA  MET    29       7.646   5.938  -5.905  1.00 64.11
ATOM    464  HA  MET    29       6.571   5.767  -5.858  1.00  0.00
ATOM    465  CB  MET    29       7.902   7.441  -5.774  1.00 73.02
ATOM    466 2HB  MET    29       8.976   7.600  -5.671  1.00  0.00
ATOM    467 3HB  MET    29       7.549   7.931  -6.682  1.00  0.00
ATOM    468  CG  MET    29       7.205   8.079  -4.583  1.00 55.12
ATOM    469 2HG  MET    29       6.136   7.880  -4.654  1.00  0.00
ATOM    470 3HG  MET    29       7.585   7.625  -3.668  1.00  0.00
ATOM    471  SD  MET    29       7.457   9.864  -4.491  1.00 72.11
ATOM    472  CE  MET    29       9.242   9.944  -4.348  1.00 32.31
ATOM    473 1HE  MET    29       9.563  10.984  -4.281  1.00  0.00
ATOM    474 2HE  MET    29       9.558   9.411  -3.452  1.00  0.00
ATOM    475 3HE  MET    29       9.697   9.483  -5.225  1.00  0.00
ATOM    476  C   MET    29       8.151   5.448  -7.255  1.00 70.22
ATOM    477  O   MET    29       7.423   5.487  -8.248  1.00 54.45
ATOM    478  N   ASP    30       9.393   4.986  -7.286  1.00 72.31
ATOM    479  HN  ASP    30       9.934   4.946  -6.434  1.00  0.00
ATOM    480  CA  ASP    30      10.016   4.528  -8.525  1.00 42.24
ATOM    481  HA  ASP    30       9.899   5.308  -9.278  1.00  0.00
ATOM    482  CB  ASP    30      11.510   4.276  -8.303  1.00 64.10
ATOM    483 2HB  ASP    30      11.918   5.094  -7.709  1.00  0.00
ATOM    484 3HB  ASP    30      11.630   3.341  -7.757  1.00  0.00
ATOM    485  CG  ASP    30      12.288   4.183  -9.599  1.00  0.52
ATOM    486  OD1 ASP    30      12.325   3.097 -10.207  1.00 34.42
ATOM    487  OD2 ASP    30      12.880   5.204 -10.012  1.00 31.43
ATOM    488 2HD  ASP    30      13.356   5.076 -10.836  1.00  0.00
ATOM    489  C   ASP    30       9.346   3.253  -9.030  1.00  2.22
ATOM    490  O   ASP    30       9.196   3.049 -10.237  1.00 50.42
ATOM    491  N   MET    31       8.927   2.407  -8.095  1.00 23.14
ATOM    492  HN  MET    31       9.043   2.641  -7.120  1.00  0.00
ATOM    493  CA  MET    31       8.298   1.134  -8.434  1.00 53.13
ATOM    494  HA  MET    31       8.886   0.665  -9.224  1.00  0.00
ATOM    495  CB  MET    31       8.279   0.205  -7.219  1.00 21.22
ATOM    496 2HB  MET    31       7.761   0.714  -6.406  1.00  0.00
ATOM    497 3HB  MET    31       7.734  -0.699  -7.488  1.00  0.00
ATOM    498  CG  MET    31       9.658  -0.197  -6.730  1.00 14.11
ATOM    499 2HG  MET    31      10.172  -0.737  -7.525  1.00  0.00
ATOM    500 3HG  MET    31      10.227   0.703  -6.495  1.00  0.00
ATOM    501  SD  MET    31       9.589  -1.245  -5.261  1.00 33.41
ATOM    502  CE  MET    31       8.790  -0.144  -4.094  1.00 40.45
ATOM    503 1HE  MET    31       8.673  -0.642  -3.132  1.00  0.00
ATOM    504 2HE  MET    31       9.400   0.751  -3.964  1.00  0.00
ATOM    505 3HE  MET    31       7.809   0.138  -4.476  1.00  0.00
ATOM    506  C   MET    31       6.874   1.336  -8.942  1.00 30.23
ATOM    507  O   MET    31       6.298   0.443  -9.563  1.00  3.40
ATOM    508  N   GLY    32       6.306   2.503  -8.668  1.00 21.22
ATOM    509  HN  GLY    32       6.813   3.211  -8.155  1.00  0.00
ATOM    510  CA  GLY    32       4.950   2.785  -9.099  1.00  3.34
ATOM    511 1HA  GLY    32       4.975   3.601  -9.822  1.00  0.00
ATOM    512 2HA  GLY    32       4.541   1.894  -9.575  1.00  0.00
ATOM    513  C   GLY    32       4.051   3.180  -7.947  1.00 64.11
ATOM    514  O   GLY    32       3.007   3.807  -8.151  1.00 43.22
ATOM    515  N   ILE    33       4.459   2.820  -6.733  1.00 63.23
ATOM    516  HN  ILE    33       5.320   2.304  -6.623  1.00  0.00
ATOM    517  CA  ILE    33       3.691   3.155  -5.540  1.00 55.11
ATOM    518  HA  ILE    33       2.652   2.875  -5.711  1.00  0.00
ATOM    519  CB  ILE    33       4.204   2.405  -4.292  1.00  3.13
ATOM    520  HB  ILE    33       5.160   2.840  -3.998  1.00  0.00
ATOM    521  CG2 ILE    33       3.223   2.571  -3.138  1.00 72.10
ATOM    522 1HG2 ILE    33       3.605   2.060  -2.255  1.00  0.00
ATOM    523 2HG2 ILE    33       3.100   3.632  -2.917  1.00  0.00
ATOM    524 3HG2 ILE    33       2.260   2.144  -3.417  1.00  0.00
ATOM    525  CG1 ILE    33       4.425   0.918  -4.599  1.00 61.44
ATOM    526 2HG1 ILE    33       5.148   0.840  -5.411  1.00  0.00
ATOM    527 3HG1 ILE    33       4.829   0.441  -3.706  1.00  0.00
ATOM    528  CD1 ILE    33       3.170   0.175  -5.008  1.00 31.52
ATOM    529 1HD1 ILE    33       3.393  -0.872  -5.213  1.00  0.00
ATOM    530 2HD1 ILE    33       2.439   0.233  -4.202  1.00  0.00
ATOM    531 3HD1 ILE    33       2.757   0.634  -5.907  1.00  0.00
ATOM    532  C   ILE    33       3.770   4.657  -5.294  1.00 33.21
ATOM    533  O   ILE    33       4.781   5.170  -4.817  1.00 62.34
ATOM    534  N   THR    34       2.709   5.360  -5.635  1.00 25.14
ATOM    535  HN  THR    34       1.854   4.892  -5.898  1.00  0.00
ATOM    536  CA  THR    34       2.738   6.808  -5.642  1.00 12.13
ATOM    537  HA  THR    34       3.684   7.128  -5.204  1.00  0.00
ATOM    538  CB  THR    34       2.672   7.320  -7.091  1.00  4.45
ATOM    539  HB  THR    34       2.235   8.319  -7.092  1.00  0.00
ATOM    540  OG1 THR    34       1.844   6.445  -7.875  1.00  0.23
ATOM    541 1HG  THR    34       1.801   6.785  -8.772  1.00  0.00
ATOM    542  CG2 THR    34       4.063   7.392  -7.704  1.00 51.22
ATOM    543 1HG2 THR    34       3.999   7.763  -8.727  1.00  0.00
ATOM    544 2HG2 THR    34       4.684   8.067  -7.114  1.00  0.00
ATOM    545 3HG2 THR    34       4.509   6.398  -7.708  1.00  0.00
ATOM    546  C   THR    34       1.605   7.409  -4.819  1.00 63.04
ATOM    547  O   THR    34       0.579   6.769  -4.591  1.00 72.21
ATOM    548  N   ARG    35       1.806   8.637  -4.362  1.00 70.22
ATOM    549  HN  ARG    35       2.674   9.112  -4.564  1.00  0.00
ATOM    550  CA  ARG    35       0.805   9.333  -3.567  1.00 21.30
ATOM    551  HA  ARG    35       0.503   8.682  -2.747  1.00  0.00
ATOM    552  CB  ARG    35       1.396  10.617  -2.978  1.00 35.44
ATOM    553 2HB  ARG    35       1.725  11.254  -3.800  1.00  0.00
ATOM    554 3HB  ARG    35       0.617  11.128  -2.412  1.00  0.00
ATOM    555  CG  ARG    35       2.581  10.373  -2.053  1.00 21.51
ATOM    556 2HG  ARG    35       2.245   9.789  -1.197  1.00  0.00
ATOM    557 3HG  ARG    35       3.344   9.816  -2.597  1.00  0.00
ATOM    558  CD  ARG    35       3.185  11.676  -1.553  1.00 62.41
ATOM    559 2HD  ARG    35       4.070  11.449  -0.958  1.00  0.00
ATOM    560 3HD  ARG    35       3.477  12.282  -2.411  1.00  0.00
ATOM    561  NE  ARG    35       2.248  12.441  -0.732  1.00 44.11
ATOM    562  HE  ARG    35       1.453  11.945  -0.356  1.00  0.00
ATOM    563  CZ  ARG    35       2.381  13.737  -0.455  1.00 13.24
ATOM    564  NH1 ARG    35       3.423  14.417  -0.922  1.00 23.11
ATOM    565 1HH1 ARG    35       3.524  15.399  -0.708  1.00  0.00
ATOM    566 2HH1 ARG    35       4.115  13.952  -1.492  1.00  0.00
ATOM    567  NH2 ARG    35       1.479  14.352   0.301  1.00 72.23
ATOM    568 1HH2 ARG    35       1.583  15.334   0.514  1.00  0.00
ATOM    569 2HH2 ARG    35       0.690  13.838   0.664  1.00  0.00
ATOM    570  C   ARG    35      -0.422   9.648  -4.415  1.00 73.33
ATOM    571  O   ARG    35      -0.386  10.523  -5.282  1.00 41.54
ATOM    572  N   GLY    36      -1.497   8.912  -4.177  1.00 30.55
ATOM    573  HN  GLY    36      -1.479   8.204  -3.457  1.00  0.00
ATOM    574  CA  GLY    36      -2.714   9.102  -4.936  1.00 74.03
ATOM    575 1HA  GLY    36      -3.494   9.458  -4.263  1.00  0.00
ATOM    576 2HA  GLY    36      -2.532   9.853  -5.706  1.00  0.00
ATOM    577  C   GLY    36      -3.188   7.826  -5.601  1.00 15.42
ATOM    578  O   GLY    36      -4.382   7.663  -5.855  1.00 54.02
ATOM    579  N   CYS    37      -2.265   6.913  -5.880  1.00  1.00
ATOM    580  HN  CYS    37      -1.298   7.074  -5.638  1.00  0.00
ATOM    581  CA  CYS    37      -2.627   5.665  -6.538  1.00  3.31
ATOM    582  HA  CYS    37      -3.274   5.903  -7.383  1.00  0.00
ATOM    583  CB  CYS    37      -1.384   4.936  -7.069  1.00 30.24
ATOM    584 2HB  CYS    37      -1.722   4.109  -7.693  1.00  0.00
ATOM    585 3HB  CYS    37      -0.815   5.642  -7.675  1.00  0.00
ATOM    586  SG  CYS    37      -0.291   4.275  -5.788  1.00  4.05
ATOM    587  HG  CYS    37       0.626   3.744  -6.603  1.00  0.00
ATOM    588  C   CYS    37      -3.393   4.765  -5.578  1.00 25.11
ATOM    589  O   CYS    37      -3.124   4.750  -4.371  1.00 71.03
ATOM    590  N   GLU    38      -4.357   4.035  -6.116  1.00 43.32
ATOM    591  HN  GLU    38      -4.556   4.116  -7.103  1.00  0.00
ATOM    592  CA  GLU    38      -5.146   3.110  -5.325  1.00  1.43
ATOM    593  HA  GLU    38      -5.216   3.496  -4.308  1.00  0.00
ATOM    594  CB  GLU    38      -6.561   2.992  -5.899  1.00 52.23
ATOM    595 2HB  GLU    38      -7.131   2.308  -5.271  1.00  0.00
ATOM    596 3HB  GLU    38      -7.025   3.978  -5.877  1.00  0.00
ATOM    597  CG  GLU    38      -6.598   2.477  -7.326  1.00 14.30
ATOM    598 2HG  GLU    38      -5.896   3.056  -7.927  1.00  0.00
ATOM    599 3HG  GLU    38      -6.294   1.431  -7.330  1.00  0.00
ATOM    600  CD  GLU    38      -7.974   2.587  -7.944  1.00 25.15
ATOM    601  OE1 GLU    38      -8.745   1.608  -7.881  1.00 65.40
ATOM    602  OE2 GLU    38      -8.290   3.663  -8.502  1.00 43.44
ATOM    603 2HE  GLU    38      -9.175   3.666  -8.874  1.00  0.00
ATOM    604  C   GLU    38      -4.465   1.751  -5.285  1.00  3.11
ATOM    605  O   GLU    38      -3.884   1.305  -6.279  1.00 71.51
ATOM    606  N   ILE    39      -4.520   1.108  -4.134  1.00 33.21
ATOM    607  HN  ILE    39      -5.015   1.516  -3.354  1.00  0.00
ATOM    608  CA  ILE    39      -3.887  -0.179  -3.950  1.00  2.24
ATOM    609  HA  ILE    39      -3.491  -0.503  -4.913  1.00  0.00
ATOM    610  CB  ILE    39      -2.723  -0.103  -2.938  1.00 41.43
ATOM    611  HB  ILE    39      -3.119   0.242  -1.983  1.00  0.00
ATOM    612  CG2 ILE    39      -2.109  -1.481  -2.735  1.00 50.33
ATOM    613 1HG2 ILE    39      -1.304  -1.420  -2.003  1.00  0.00
ATOM    614 2HG2 ILE    39      -2.874  -2.169  -2.376  1.00  0.00
ATOM    615 3HG2 ILE    39      -1.710  -1.843  -3.682  1.00  0.00
ATOM    616  CG1 ILE    39      -1.661   0.896  -3.409  1.00 52.30
ATOM    617 2HG1 ILE    39      -1.313   0.590  -4.396  1.00  0.00
ATOM    618 3HG1 ILE    39      -2.121   1.882  -3.476  1.00  0.00
ATOM    619  CD1 ILE    39      -0.463   0.989  -2.487  1.00 54.01
ATOM    620 1HD1 ILE    39       0.259   1.711  -2.870  1.00  0.00
ATOM    621 2HD1 ILE    39      -0.793   1.306  -1.498  1.00  0.00
ATOM    622 3HD1 ILE    39       0.014   0.012  -2.416  1.00  0.00
ATOM    623  C   ILE    39      -4.903  -1.201  -3.465  1.00 44.01
ATOM    624  O   ILE    39      -5.476  -1.061  -2.381  1.00  1.54
ATOM    625  N   TYR    40      -5.141  -2.214  -4.279  1.00  3.30
ATOM    626  HN  TYR    40      -4.721  -2.235  -5.197  1.00  0.00
ATOM    627  CA  TYR    40      -6.003  -3.309  -3.883  1.00 63.32
ATOM    628  HA  TYR    40      -6.730  -2.941  -3.159  1.00  0.00
ATOM    629  CB  TYR    40      -6.755  -3.872  -5.092  1.00 45.44
ATOM    630 2HB  TYR    40      -7.108  -3.039  -5.700  1.00  0.00
ATOM    631 3HB  TYR    40      -6.062  -4.469  -5.685  1.00  0.00
ATOM    632  CG  TYR    40      -7.942  -4.736  -4.723  1.00 73.12
ATOM    633  CD1 TYR    40      -9.180  -4.163  -4.471  1.00 62.21
ATOM    634 1HD  TYR    40      -9.292  -3.091  -4.539  1.00  0.00
ATOM    635  CE1 TYR    40     -10.271  -4.938  -4.135  1.00  3.24
ATOM    636 1HE  TYR    40     -11.227  -4.474  -3.944  1.00  0.00
ATOM    637  CZ  TYR    40     -10.135  -6.306  -4.044  1.00 43.21
ATOM    638  CE2 TYR    40      -8.916  -6.902  -4.291  1.00 70.42
ATOM    639 2HE  TYR    40      -8.812  -7.974  -4.223  1.00  0.00
ATOM    640  CD2 TYR    40      -7.827  -6.119  -4.627  1.00 10.11
ATOM    641 2HD  TYR    40      -6.873  -6.588  -4.818  1.00  0.00
ATOM    642  OH  TYR    40     -11.226  -7.077  -3.711  1.00 44.11
ATOM    643  HH  TYR    40     -11.024  -8.015  -3.677  1.00  0.00
ATOM    644  C   TYR    40      -5.154  -4.390  -3.234  1.00 13.02
ATOM    645  O   TYR    40      -4.362  -5.053  -3.909  1.00 51.30
ATOM    646  N   ILE    41      -5.290  -4.538  -1.924  1.00 21.31
ATOM    647  HN  ILE    41      -5.957  -3.972  -1.419  1.00  0.00
ATOM    648  CA  ILE    41      -4.495  -5.508  -1.181  1.00 62.32
ATOM    649  HA  ILE    41      -3.448  -5.366  -1.450  1.00  0.00
ATOM    650  CB  ILE    41      -4.637  -5.328   0.349  1.00 20.44
ATOM    651  HB  ILE    41      -5.601  -5.731   0.657  1.00  0.00
ATOM    652  CG2 ILE    41      -3.533  -6.093   1.074  1.00  2.14
ATOM    653 1HG2 ILE    41      -3.652  -5.978   2.151  1.00  0.00
ATOM    654 2HG2 ILE    41      -3.593  -7.149   0.814  1.00  0.00
ATOM    655 3HG2 ILE    41      -2.562  -5.699   0.773  1.00  0.00
ATOM    656  CG1 ILE    41      -4.584  -3.843   0.731  1.00 64.40
ATOM    657 2HG1 ILE    41      -5.380  -3.323   0.198  1.00  0.00
ATOM    658 3HG1 ILE    41      -4.750  -3.759   1.805  1.00  0.00
ATOM    659  CD1 ILE    41      -3.270  -3.168   0.399  1.00 63.01
ATOM    660 1HD1 ILE    41      -3.293  -2.118   0.691  1.00  0.00
ATOM    661 2HD1 ILE    41      -2.463  -3.669   0.933  1.00  0.00
ATOM    662 3HD1 ILE    41      -3.092  -3.235  -0.674  1.00  0.00
ATOM    663  C   ILE    41      -4.919  -6.920  -1.568  1.00 13.20
ATOM    664  O   ILE    41      -6.043  -7.337  -1.286  1.00 12.23
ATOM    665  N   ARG    42      -4.018  -7.644  -2.216  1.00 23.12
ATOM    666  HN  ARG    42      -3.074  -7.298  -2.317  1.00  0.00
ATOM    667  CA  ARG    42      -4.347  -8.938  -2.797  1.00 33.32
ATOM    668  HA  ARG    42      -5.398  -8.926  -3.084  1.00  0.00
ATOM    669  CB  ARG    42      -3.499  -9.179  -4.053  1.00 51.44
ATOM    670 2HB  ARG    42      -2.452  -9.240  -3.756  1.00  0.00
ATOM    671 3HB  ARG    42      -3.806 -10.124  -4.501  1.00  0.00
ATOM    672  CG  ARG    42      -3.640  -8.082  -5.100  1.00 53.22
ATOM    673 2HG  ARG    42      -3.470  -7.116  -4.624  1.00  0.00
ATOM    674 3HG  ARG    42      -2.893  -8.239  -5.879  1.00  0.00
ATOM    675  CD  ARG    42      -5.020  -8.080  -5.736  1.00  0.31
ATOM    676 2HD  ARG    42      -5.770  -8.205  -4.955  1.00  0.00
ATOM    677 3HD  ARG    42      -5.178  -7.123  -6.235  1.00  0.00
ATOM    678  NE  ARG    42      -5.171  -9.154  -6.713  1.00 34.30
ATOM    679  HE  ARG    42      -4.334  -9.472  -7.180  1.00  0.00
ATOM    680  CZ  ARG    42      -6.331  -9.732  -7.021  1.00 35.42
ATOM    681  NH1 ARG    42      -7.449  -9.360  -6.411  1.00 62.03
ATOM    682 1HH1 ARG    42      -8.326  -9.801  -6.647  1.00  0.00
ATOM    683 2HH1 ARG    42      -7.423  -8.633  -5.710  1.00  0.00
ATOM    684  NH2 ARG    42      -6.371 -10.690  -7.939  1.00 63.43
ATOM    685 1HH2 ARG    42      -7.249 -11.130  -8.173  1.00  0.00
ATOM    686 2HH2 ARG    42      -5.522 -10.979  -8.404  1.00  0.00
ATOM    687  C   ARG    42      -4.132 -10.064  -1.789  1.00 23.04
ATOM    688  O   ARG    42      -5.055 -10.819  -1.484  1.00 30.54
ATOM    689  N   LYS    43      -2.924 -10.163  -1.259  1.00 21.21
ATOM    690  HN  LYS    43      -2.216  -9.477  -1.480  1.00  0.00
ATOM    691  CA  LYS    43      -2.583 -11.250  -0.353  1.00 23.34
ATOM    692  HA  LYS    43      -3.489 -11.562   0.166  1.00  0.00
ATOM    693  CB  LYS    43      -2.038 -12.441  -1.153  1.00 24.53
ATOM    694 2HB  LYS    43      -2.839 -12.821  -1.786  1.00  0.00
ATOM    695 3HB  LYS    43      -1.218 -12.085  -1.778  1.00  0.00
ATOM    696  CG  LYS    43      -1.521 -13.589  -0.299  1.00  2.03
ATOM    697 2HG  LYS    43      -1.134 -14.369  -0.955  1.00  0.00
ATOM    698 3HG  LYS    43      -0.718 -13.219   0.339  1.00  0.00
ATOM    699  CD  LYS    43      -2.612 -14.181   0.577  1.00 65.05
ATOM    700 2HD  LYS    43      -2.981 -13.411   1.255  1.00  0.00
ATOM    701 3HD  LYS    43      -3.427 -14.528  -0.057  1.00  0.00
ATOM    702  CE  LYS    43      -2.085 -15.348   1.392  1.00 31.24
ATOM    703 2HE  LYS    43      -1.771 -16.140   0.712  1.00  0.00
ATOM    704 3HE  LYS    43      -1.226 -15.013   1.973  1.00  0.00
ATOM    705  NZ  LYS    43      -3.111 -15.889   2.319  1.00 73.11
ATOM    706 1HZ  LYS    43      -2.725 -16.661   2.842  1.00  0.00
ATOM    707 2HZ  LYS    43      -3.402 -15.163   2.958  1.00  0.00
ATOM    708 3HZ  LYS    43      -3.908 -16.209   1.787  1.00  0.00
ATOM    709  C   LYS    43      -1.562 -10.798   0.684  1.00 65.14
ATOM    710  O   LYS    43      -0.491 -10.307   0.339  1.00 52.44
ATOM    711  N   VAL    44      -1.904 -10.951   1.953  1.00 34.22
ATOM    712  HN  VAL    44      -2.826 -11.288   2.190  1.00  0.00
ATOM    713  CA  VAL    44      -0.980 -10.644   3.030  1.00 11.25
ATOM    714  HA  VAL    44      -0.116 -10.132   2.606  1.00  0.00
ATOM    715  CB  VAL    44      -1.624  -9.729   4.095  1.00 33.34
ATOM    716  HB  VAL    44      -2.470 -10.260   4.531  1.00  0.00
ATOM    717  CG1 VAL    44      -0.638  -9.411   5.210  1.00 31.30
ATOM    718 1HG1 VAL    44      -1.117  -8.785   5.962  1.00  0.00
ATOM    719 2HG1 VAL    44      -0.303 -10.339   5.673  1.00  0.00
ATOM    720 3HG1 VAL    44       0.220  -8.882   4.795  1.00  0.00
ATOM    721  CG2 VAL    44      -2.143  -8.448   3.463  1.00 31.24
ATOM    722 1HG2 VAL    44      -2.616  -7.825   4.222  1.00  0.00
ATOM    723 2HG2 VAL    44      -1.312  -7.902   3.016  1.00  0.00
ATOM    724 3HG2 VAL    44      -2.872  -8.694   2.691  1.00  0.00
ATOM    725  C   VAL    44      -0.521 -11.935   3.689  1.00  1.33
ATOM    726  O   VAL    44      -1.344 -12.719   4.171  1.00 75.45
ATOM    727  N   ALA    45       0.784 -12.167   3.682  1.00 33.23
ATOM    728  HN  ALA    45       1.411 -11.505   3.246  1.00  0.00
ATOM    729  CA  ALA    45       1.350 -13.362   4.289  1.00  4.52
ATOM    730  HA  ALA    45       0.819 -14.228   3.896  1.00  0.00
ATOM    731  CB  ALA    45       2.821 -13.490   3.924  1.00 33.24
ATOM    732 1HB  ALA    45       3.231 -14.401   4.359  1.00  0.00
ATOM    733 2HB  ALA    45       2.924 -13.529   2.839  1.00  0.00
ATOM    734 3HB  ALA    45       3.367 -12.628   4.309  1.00  0.00
ATOM    735  C   ALA    45       1.174 -13.333   5.806  1.00 31.22
ATOM    736  O   ALA    45       1.238 -12.270   6.420  1.00 73.05
ATOM    770  N   GLY    48       3.404 -11.491   7.989  1.00 30.10
ATOM    771  HN  GLY    48       2.708 -12.044   7.511  1.00  0.00
ATOM    772  CA  GLY    48       3.350 -10.052   7.866  1.00 74.31
ATOM    773 1HA  GLY    48       2.307  -9.737   7.830  1.00  0.00
ATOM    774 2HA  GLY    48       3.833  -9.603   8.734  1.00  0.00
ATOM    775  C   GLY    48       4.051  -9.579   6.613  1.00 24.03
ATOM    776  O   GLY    48       3.814  -8.472   6.133  1.00 15.43
ATOM    777  N   ASP    49       4.903 -10.440   6.079  1.00 11.02
ATOM    778  HN  ASP    49       5.015 -11.352   6.498  1.00  0.00
ATOM    779  CA  ASP    49       5.695 -10.127   4.902  1.00 52.24
ATOM    780  HA  ASP    49       5.179  -9.360   4.324  1.00  0.00
ATOM    781  CB  ASP    49       7.062  -9.593   5.329  1.00 50.22
ATOM    782 2HB  ASP    49       6.916  -8.690   5.922  1.00  0.00
ATOM    783 3HB  ASP    49       7.558 -10.347   5.940  1.00  0.00
ATOM    784  CG  ASP    49       7.950  -9.263   4.152  1.00 14.31
ATOM    785  OD1 ASP    49       7.699  -8.239   3.491  1.00  4.41
ATOM    786  OD2 ASP    49       8.911 -10.016   3.892  1.00 61.05
ATOM    787 2HD  ASP    49       9.432  -9.741   3.134  1.00  0.00
ATOM    788  C   ASP    49       5.863 -11.371   4.037  1.00 11.41
ATOM    789  O   ASP    49       6.006 -12.478   4.563  1.00 62.34
ATOM    790  N   PRO    50       5.823 -11.222   2.702  1.00 53.04
ATOM    791  CD  PRO    50       6.050 -12.295   1.724  1.00  2.02
ATOM    792  CA  PRO    50       5.574  -9.945   2.041  1.00 31.54
ATOM    793  HA  PRO    50       5.968  -9.118   2.633  1.00  0.00
ATOM    794  CB  PRO    50       6.353 -10.099   0.737  1.00 11.21
ATOM    795 2HB  PRO    50       5.927  -9.493  -0.063  1.00  0.00
ATOM    796 3HB  PRO    50       7.393  -9.825   0.916  1.00  0.00
ATOM    797  CG  PRO    50       6.292 -11.561   0.421  1.00 50.44
ATOM    798 2HG  PRO    50       5.435 -11.730  -0.230  1.00  0.00
ATOM    799 3HG  PRO    50       7.212 -11.899  -0.056  1.00  0.00
ATOM    800 2HD  PRO    50       5.190 -12.960   1.646  1.00  0.00
ATOM    801 3HD  PRO    50       6.940 -12.857   2.006  1.00  0.00
ATOM    802  C   PRO    50       4.092  -9.703   1.765  1.00 62.31
ATOM    803  O   PRO    50       3.257 -10.595   1.941  1.00 32.31
ATOM    804  N   ILE    51       3.769  -8.496   1.332  1.00 72.31
ATOM    805  HN  ILE    51       4.486  -7.795   1.205  1.00  0.00
ATOM    806  CA  ILE    51       2.393  -8.145   1.028  1.00 32.51
ATOM    807  HA  ILE    51       1.750  -8.940   1.405  1.00  0.00
ATOM    808  CB  ILE    51       1.989  -6.822   1.716  1.00 15.23
ATOM    809  HB  ILE    51       2.664  -6.036   1.376  1.00  0.00
ATOM    810  CG2 ILE    51       0.565  -6.425   1.342  1.00 14.23
ATOM    811 1HG2 ILE    51       0.306  -5.481   1.822  1.00  0.00
ATOM    812 2HG2 ILE    51       0.493  -6.311   0.260  1.00  0.00
ATOM    813 3HG2 ILE    51      -0.126  -7.200   1.672  1.00  0.00
ATOM    814  CG1 ILE    51       2.127  -6.960   3.234  1.00 60.52
ATOM    815 2HG1 ILE    51       1.470  -7.763   3.567  1.00  0.00
ATOM    816 3HG1 ILE    51       3.161  -7.217   3.463  1.00  0.00
ATOM    817  CD1 ILE    51       1.768  -5.703   3.996  1.00 22.22
ATOM    818 1HD1 ILE    51       1.884  -5.859   5.068  1.00  0.00
ATOM    819 2HD1 ILE    51       2.424  -4.891   3.681  1.00  0.00
ATOM    820 3HD1 ILE    51       0.733  -5.436   3.783  1.00  0.00
ATOM    821  C   ILE    51       2.190  -8.028  -0.481  1.00 72.54
ATOM    822  O   ILE    51       2.812  -7.192  -1.138  1.00 22.10
ATOM    823  N   GLN    52       1.333  -8.884  -1.025  1.00 34.43
ATOM    824  HN  GLN    52       0.876  -9.571  -0.443  1.00  0.00
ATOM    825  CA  GLN    52       1.024  -8.869  -2.448  1.00 15.41
ATOM    826  HA  GLN    52       1.927  -8.589  -2.991  1.00  0.00
ATOM    827  CB  GLN    52       0.566 -10.252  -2.938  1.00 71.34
ATOM    828 2HB  GLN    52      -0.198 -10.618  -2.252  1.00  0.00
ATOM    829 3HB  GLN    52       0.135 -10.133  -3.932  1.00  0.00
ATOM    830  CG  GLN    52       1.670 -11.305  -3.023  1.00  4.11
ATOM    831 2HG  GLN    52       1.285 -12.166  -3.569  1.00  0.00
ATOM    832 3HG  GLN    52       2.511 -10.880  -3.571  1.00  0.00
ATOM    833  CD  GLN    52       2.168 -11.777  -1.668  1.00 53.41
ATOM    834  OE1 GLN    52       1.624 -12.713  -1.088  1.00  5.20
ATOM    835  NE2 GLN    52       3.228 -11.162  -1.176  1.00 34.13
ATOM    836 1HE2 GLN    52       3.653 -10.405  -1.692  1.00  0.00
ATOM    837 2HE2 GLN    52       3.611 -11.449  -0.287  1.00  0.00
ATOM    838  C   GLN    52      -0.063  -7.842  -2.733  1.00 61.21
ATOM    839  O   GLN    52      -1.165  -7.916  -2.182  1.00  0.50
ATOM    840  N   ILE    53       0.252  -6.888  -3.590  1.00 42.44
ATOM    841  HN  ILE    53       1.160  -6.894  -4.034  1.00  0.00
ATOM    842  CA  ILE    53      -0.670  -5.816  -3.924  1.00 13.15
ATOM    843  HA  ILE    53      -1.668  -6.117  -3.607  1.00  0.00
ATOM    844  CB  ILE    53      -0.298  -4.502  -3.199  1.00 55.32
ATOM    845  HB  ILE    53      -0.931  -3.705  -3.590  1.00  0.00
ATOM    846  CG2 ILE    53      -0.555  -4.625  -1.703  1.00 54.10
ATOM    847 1HG2 ILE    53      -0.312  -3.684  -1.209  1.00  0.00
ATOM    848 2HG2 ILE    53      -1.605  -4.861  -1.534  1.00  0.00
ATOM    849 3HG2 ILE    53       0.067  -5.420  -1.293  1.00  0.00
ATOM    850  CG1 ILE    53       1.165  -4.130  -3.471  1.00 73.23
ATOM    851 2HG1 ILE    53       1.800  -4.927  -3.085  1.00  0.00
ATOM    852 3HG1 ILE    53       1.304  -4.044  -4.549  1.00  0.00
ATOM    853  CD1 ILE    53       1.594  -2.826  -2.830  1.00 42.51
ATOM    854 1HD1 ILE    53       2.640  -2.614  -3.056  1.00  0.00
ATOM    855 2HD1 ILE    53       0.975  -2.015  -3.214  1.00  0.00
ATOM    856 3HD1 ILE    53       1.470  -2.897  -1.750  1.00  0.00
ATOM    857  C   ILE    53      -0.685  -5.570  -5.426  1.00  4.23
ATOM    858  O   ILE    53       0.305  -5.821  -6.114  1.00 23.24
ATOM    859  N   ASN    54      -1.813  -5.098  -5.931  1.00  5.12
ATOM    860  HN  ASN    54      -2.615  -4.958  -5.334  1.00  0.00
ATOM    861  CA  ASN    54      -1.930  -4.769  -7.343  1.00 30.22
ATOM    862  HA  ASN    54      -1.030  -5.111  -7.855  1.00  0.00
ATOM    863  CB  ASN    54      -3.142  -5.471  -7.968  1.00 62.43
ATOM    864 2HB  ASN    54      -3.110  -6.526  -7.697  1.00  0.00
ATOM    865 3HB  ASN    54      -4.050  -5.023  -7.564  1.00  0.00
ATOM    866  CG  ASN    54      -3.182  -5.360  -9.486  1.00 23.35
ATOM    867  OD1 ASN    54      -2.770  -4.358 -10.072  1.00 35.11
ATOM    868  ND2 ASN    54      -3.672  -6.405 -10.138  1.00 41.54
ATOM    869 1HD2 ASN    54      -3.996  -7.211  -9.624  1.00  0.00
ATOM    870 2HD2 ASN    54      -3.719  -6.393 -11.147  1.00  0.00
ATOM    871  C   ASN    54      -2.039  -3.262  -7.502  1.00 22.34
ATOM    872  O   ASN    54      -3.026  -2.650  -7.083  1.00 73.05
ATOM    873  N   VAL    55      -1.006  -2.671  -8.082  1.00 75.43
ATOM    874  HN  VAL    55      -0.240  -3.232  -8.426  1.00  0.00
ATOM    875  CA  VAL    55      -0.928  -1.229  -8.246  1.00 71.34
ATOM    876  HA  VAL    55      -1.902  -0.804  -8.003  1.00  0.00
ATOM    877  CB  VAL    55       0.133  -0.606  -7.310  1.00 33.34
ATOM    878  HB  VAL    55       1.113  -0.967  -7.622  1.00  0.00
ATOM    879  CG1 VAL    55       0.132   0.912  -7.419  1.00 22.32
ATOM    880 1HG1 VAL    55       0.903   1.331  -6.772  1.00  0.00
ATOM    881 2HG1 VAL    55       0.331   1.202  -8.451  1.00  0.00
ATOM    882 3HG1 VAL    55      -0.842   1.297  -7.116  1.00  0.00
ATOM    883  CG2 VAL    55      -0.094  -1.039  -5.872  1.00 73.44
ATOM    884 1HG2 VAL    55       0.678  -0.612  -5.231  1.00  0.00
ATOM    885 2HG2 VAL    55      -1.072  -0.692  -5.540  1.00  0.00
ATOM    886 3HG2 VAL    55      -0.054  -2.126  -5.811  1.00  0.00
ATOM    887  C   VAL    55      -0.581  -0.881  -9.688  1.00 52.14
ATOM    888  O   VAL    55       0.349  -1.448 -10.263  1.00 20.40
ATOM    889  N   ARG    56      -1.348   0.041 -10.269  1.00 30.54
ATOM    890  HN  ARG    56      -2.121   0.437  -9.754  1.00  0.00
ATOM    891  CA  ARG    56      -1.120   0.514 -11.639  1.00 51.31
ATOM    892  HA  ARG    56      -1.862   1.282 -11.857  1.00  0.00
ATOM    893  CB  ARG    56       0.277   1.135 -11.773  1.00 23.31
ATOM    894 2HB  ARG    56       1.016   0.360 -11.570  1.00  0.00
ATOM    895 3HB  ARG    56       0.395   1.490 -12.797  1.00  0.00
ATOM    896  CG  ARG    56       0.541   2.303 -10.832  1.00 62.31
ATOM    897 2HG  ARG    56       0.416   1.963  -9.804  1.00  0.00
ATOM    898 3HG  ARG    56       1.564   2.650 -10.978  1.00  0.00
ATOM    899  CD  ARG    56      -0.411   3.460 -11.087  1.00 42.41
ATOM    900 2HD  ARG    56      -0.399   3.701 -12.150  1.00  0.00
ATOM    901 3HD  ARG    56      -1.418   3.160 -10.800  1.00  0.00
ATOM    902  NE  ARG    56      -0.036   4.653 -10.326  1.00  4.24
ATOM    903  HE  ARG    56       0.587   4.524  -9.541  1.00  0.00
ATOM    904  CZ  ARG    56      -0.465   5.885 -10.609  1.00 43.14
ATOM    905  NH1 ARG    56      -1.314   6.077 -11.610  1.00 63.41
ATOM    906 1HH1 ARG    56      -1.640   7.009 -11.825  1.00  0.00
ATOM    907 2HH1 ARG    56      -1.634   5.292 -12.158  1.00  0.00
ATOM    908  NH2 ARG    56      -0.049   6.924  -9.892  1.00 51.54
ATOM    909 1HH2 ARG    56      -0.377   7.855 -10.110  1.00  0.00
ATOM    910 2HH2 ARG    56       0.597   6.784  -9.128  1.00  0.00
ATOM    911  C   ARG    56      -1.282  -0.618 -12.658  1.00  4.53
ATOM    912  O   ARG    56      -0.865  -0.492 -13.809  1.00 23.23
ATOM    913  N   GLY    57      -1.895  -1.715 -12.233  1.00 73.14
ATOM    914  HN  GLY    57      -2.234  -1.773 -11.284  1.00  0.00
ATOM    915  CA  GLY    57      -2.091  -2.848 -13.115  1.00 35.31
ATOM    916 1HA  GLY    57      -3.079  -3.269 -12.931  1.00  0.00
ATOM    917 2HA  GLY    57      -2.032  -2.503 -14.148  1.00  0.00
ATOM    918  C   GLY    57      -1.051  -3.927 -12.900  1.00 64.14
ATOM    919  O   GLY    57      -1.142  -5.016 -13.474  1.00 42.35
ATOM    920  N   TYR    58      -0.058  -3.632 -12.072  1.00  2.31
ATOM    921  HN  TYR    58      -0.016  -2.720 -11.639  1.00  0.00
ATOM    922  CA  TYR    58       0.987  -4.594 -11.767  1.00 75.35
ATOM    923  HA  TYR    58       0.988  -5.367 -12.535  1.00  0.00
ATOM    924  CB  TYR    58       2.360  -3.910 -11.743  1.00 75.12
ATOM    925 2HB  TYR    58       2.411  -3.270 -10.862  1.00  0.00
ATOM    926 3HB  TYR    58       3.128  -4.679 -11.662  1.00  0.00
ATOM    927  CG  TYR    58       2.658  -3.066 -12.963  1.00 71.43
ATOM    928  CD1 TYR    58       2.429  -1.695 -12.953  1.00 24.05
ATOM    929 1HD  TYR    58       2.032  -1.230 -12.063  1.00  0.00
ATOM    930  CE1 TYR    58       2.701  -0.916 -14.061  1.00 21.41
ATOM    931 1HE  TYR    58       2.519   0.149 -14.035  1.00  0.00
ATOM    932  CZ  TYR    58       3.206  -1.504 -15.198  1.00 52.22
ATOM    933  CE2 TYR    58       3.443  -2.864 -15.233  1.00 71.21
ATOM    934 2HE  TYR    58       3.842  -3.322 -16.126  1.00  0.00
ATOM    935  CD2 TYR    58       3.168  -3.636 -14.120  1.00 63.43
ATOM    936 2HD  TYR    58       3.354  -4.699 -14.152  1.00  0.00
ATOM    937  OH  TYR    58       3.481  -0.729 -16.301  1.00  1.03
ATOM    938  HH  TYR    58       3.830  -1.236 -17.038  1.00  0.00
ATOM    939  C   TYR    58       0.718  -5.230 -10.411  1.00 14.14
ATOM    940  O   TYR    58       0.517  -4.528  -9.421  1.00 11.24
ATOM    941  N   GLU    59       0.726  -6.549 -10.364  1.00 53.21
ATOM    942  HN  GLU    59       0.863  -7.086 -11.208  1.00  0.00
ATOM    943  CA  GLU    59       0.542  -7.253  -9.111  1.00 72.32
ATOM    944  HA  GLU    59       0.152  -6.552  -8.373  1.00  0.00
ATOM    945  CB  GLU    59      -0.464  -8.384  -9.277  1.00 21.34
ATOM    946 2HB  GLU    59      -1.363  -7.975  -9.737  1.00  0.00
ATOM    947 3HB  GLU    59      -0.028  -9.135  -9.936  1.00  0.00
ATOM    948  CG  GLU    59      -0.860  -9.063  -7.978  1.00 50.34
ATOM    949 2HG  GLU    59       0.004  -9.596  -7.582  1.00  0.00
ATOM    950 3HG  GLU    59      -1.169  -8.301  -7.263  1.00  0.00
ATOM    951  CD  GLU    59      -1.997 -10.046  -8.169  1.00 11.43
ATOM    952  OE1 GLU    59      -1.748 -11.270  -8.169  1.00 32.42
ATOM    953  OE2 GLU    59      -3.148  -9.597  -8.329  1.00 24.44
ATOM    954 2HE  GLU    59      -3.819 -10.272  -8.447  1.00  0.00
ATOM    955  C   GLU    59       1.883  -7.773  -8.626  1.00 14.44
ATOM    956  O   GLU    59       2.507  -8.630  -9.254  1.00 31.01
ATOM    957  N   LEU    60       2.317  -7.241  -7.510  1.00 74.52
ATOM    958  HN  LEU    60       1.712  -6.636  -6.972  1.00  0.00
ATOM    959  CA  LEU    60       3.660  -7.496  -7.014  1.00 72.24
ATOM    960  HA  LEU    60       4.021  -8.417  -7.471  1.00  0.00
ATOM    961  CB  LEU    60       4.599  -6.347  -7.428  1.00 22.23
ATOM    962 2HB  LEU    60       5.542  -6.478  -6.896  1.00  0.00
ATOM    963 3HB  LEU    60       4.773  -6.429  -8.501  1.00  0.00
ATOM    964  CG  LEU    60       4.092  -4.922  -7.141  1.00 32.14
ATOM    965  HG  LEU    60       3.029  -4.886  -7.378  1.00  0.00
ATOM    966  CD1 LEU    60       4.262  -4.554  -5.672  1.00 70.41
ATOM    967 1HD1 LEU    60       3.877  -3.550  -5.492  1.00  0.00
ATOM    968 2HD1 LEU    60       3.714  -5.266  -5.055  1.00  0.00
ATOM    969 3HD1 LEU    60       5.320  -4.585  -5.411  1.00  0.00
ATOM    970  CD2 LEU    60       4.813  -3.917  -8.025  1.00 62.34
ATOM    971 1HD2 LEU    60       4.428  -2.915  -7.836  1.00  0.00
ATOM    972 2HD2 LEU    60       5.881  -3.940  -7.805  1.00  0.00
ATOM    973 3HD2 LEU    60       4.652  -4.174  -9.072  1.00  0.00
ATOM    974  C   LEU    60       3.667  -7.679  -5.505  1.00  2.23
ATOM    975  O   LEU    60       2.642  -7.519  -4.844  1.00 52.31
ATOM    976  N   SER    61       4.828  -8.020  -4.972  1.00 74.25
ATOM    977  HN  SER    61       5.627  -8.181  -5.569  1.00  0.00
ATOM    978  CA  SER    61       4.995  -8.170  -3.542  1.00 63.23
ATOM    979  HA  SER    61       4.012  -8.161  -3.072  1.00  0.00
ATOM    980  CB  SER    61       5.683  -9.497  -3.229  1.00 42.21
ATOM    981 2HB  SER    61       6.687  -9.486  -3.654  1.00  0.00
ATOM    982 3HB  SER    61       5.748  -9.618  -2.148  1.00  0.00
ATOM    983  OG  SER    61       4.962 -10.591  -3.774  1.00 23.41
ATOM    984  HG  SER    61       5.421 -11.406  -3.559  1.00  0.00
ATOM    985  C   SER    61       5.819  -7.015  -2.991  1.00 23.22
ATOM    986  O   SER    61       6.931  -6.758  -3.455  1.00 22.24
ATOM    987  N   LEU    62       5.266  -6.313  -2.021  1.00 12.43
ATOM    988  HN  LEU    62       4.330  -6.531  -1.711  1.00  0.00
ATOM    989  CA  LEU    62       5.971  -5.222  -1.377  1.00 51.32
ATOM    990  HA  LEU    62       6.855  -4.980  -1.968  1.00  0.00
ATOM    991  CB  LEU    62       5.083  -3.979  -1.295  1.00 61.11
ATOM    992 2HB  LEU    62       4.769  -3.723  -2.307  1.00  0.00
ATOM    993 3HB  LEU    62       4.209  -4.229  -0.695  1.00  0.00
ATOM    994  CG  LEU    62       5.742  -2.741  -0.677  1.00 32.54
ATOM    995  HG  LEU    62       6.151  -3.019   0.294  1.00  0.00
ATOM    996  CD1 LEU    62       6.885  -2.240  -1.549  1.00 41.21
ATOM    997 1HD1 LEU    62       7.354  -1.372  -1.084  1.00  0.00
ATOM    998 2HD1 LEU    62       7.626  -3.031  -1.665  1.00  0.00
ATOM    999 3HD1 LEU    62       6.498  -1.959  -2.529  1.00  0.00
ATOM   1000  CD2 LEU    62       4.713  -1.644  -0.467  1.00 23.13
ATOM   1001 1HD2 LEU    62       5.186  -0.777  -0.005  1.00  0.00
ATOM   1002 2HD2 LEU    62       4.291  -1.354  -1.429  1.00  0.00
ATOM   1003 3HD2 LEU    62       3.919  -2.011   0.183  1.00  0.00
ATOM   1004  C   LEU    62       6.408  -5.654   0.011  1.00 31.25
ATOM   1005  O   LEU    62       5.637  -6.276   0.748  1.00 74.34
ATOM   1006  N   ARG    63       7.653  -5.354   0.346  1.00 72.31
ATOM   1007  HN  ARG    63       8.242  -4.855  -0.306  1.00  0.00
ATOM   1008  CA  ARG    63       8.209  -5.723   1.634  1.00  1.32
ATOM   1009  HA  ARG    63       8.070  -6.794   1.778  1.00  0.00
ATOM   1010  CB  ARG    63       9.705  -5.411   1.673  1.00 14.24
ATOM   1011 2HB  ARG    63      10.103  -5.508   0.663  1.00  0.00
ATOM   1012 3HB  ARG    63       9.833  -4.384   2.017  1.00  0.00
ATOM   1013  CG  ARG    63      10.497  -6.325   2.590  1.00 34.41
ATOM   1014 2HG  ARG    63      11.554  -6.068   2.522  1.00  0.00
ATOM   1015 3HG  ARG    63      10.155  -6.184   3.615  1.00  0.00
ATOM   1016  CD  ARG    63      10.315  -7.783   2.201  1.00 15.20
ATOM   1017 2HD  ARG    63      10.006  -8.343   3.083  1.00  0.00
ATOM   1018 3HD  ARG    63       9.534  -7.846   1.444  1.00  0.00
ATOM   1019  NE  ARG    63      11.532  -8.390   1.667  1.00 23.14
ATOM   1020  HE  ARG    63      12.225  -7.771   1.268  1.00  0.00
ATOM   1021  CZ  ARG    63      11.769  -9.703   1.681  1.00 34.00
ATOM   1022  NH1 ARG    63      10.905 -10.538   2.250  1.00 30.12
ATOM   1023 1HH1 ARG    63      11.093 -11.530   2.262  1.00  0.00
ATOM   1024 2HH1 ARG    63      10.060 -10.179   2.670  1.00  0.00
ATOM   1025  NH2 ARG    63      12.885 -10.177   1.142  1.00 65.32
ATOM   1026 1HH2 ARG    63      13.070 -11.169   1.156  1.00  0.00
ATOM   1027 2HH2 ARG    63      13.550  -9.545   0.718  1.00  0.00
ATOM   1028  C   ARG    63       7.490  -4.979   2.751  1.00 54.04
ATOM   1029  O   ARG    63       7.207  -3.782   2.631  1.00 41.32
ATOM   1030  N   LYS    64       7.194  -5.697   3.826  1.00 42.41
ATOM   1031  HN  LYS    64       7.451  -6.673   3.857  1.00  0.00
ATOM   1032  CA  LYS    64       6.506  -5.131   4.978  1.00 13.22
ATOM   1033  HA  LYS    64       5.521  -4.794   4.656  1.00  0.00
ATOM   1034  CB  LYS    64       6.322  -6.207   6.060  1.00 51.34
ATOM   1035 2HB  LYS    64       5.863  -7.080   5.597  1.00  0.00
ATOM   1036 3HB  LYS    64       7.306  -6.474   6.446  1.00  0.00
ATOM   1037  CG  LYS    64       5.451  -5.776   7.233  1.00 41.41
ATOM   1038 2HG  LYS    64       4.672  -5.108   6.865  1.00  0.00
ATOM   1039 3HG  LYS    64       4.993  -6.660   7.674  1.00  0.00
ATOM   1040  CD  LYS    64       6.251  -5.053   8.304  1.00 32.31
ATOM   1041 2HD  LYS    64       7.058  -4.497   7.826  1.00  0.00
ATOM   1042 3HD  LYS    64       5.593  -4.359   8.827  1.00  0.00
ATOM   1043  CE  LYS    64       6.850  -6.018   9.314  1.00 34.43
ATOM   1044 2HE  LYS    64       6.045  -6.569   9.799  1.00  0.00
ATOM   1045 3HE  LYS    64       7.501  -6.719   8.792  1.00  0.00
ATOM   1046  NZ  LYS    64       7.640  -5.305  10.350  1.00 21.10
ATOM   1047 1HZ  LYS    64       8.024  -5.972  11.004  1.00  0.00
ATOM   1048 2HZ  LYS    64       8.393  -4.797   9.908  1.00  0.00
ATOM   1049 3HZ  LYS    64       7.042  -4.658  10.843  1.00  0.00
ATOM   1050  C   LYS    64       7.270  -3.928   5.525  1.00 20.34
ATOM   1051  O   LYS    64       6.670  -3.002   6.063  1.00 13.53
ATOM   1052  N   SER    65       8.588  -3.943   5.363  1.00 44.33
ATOM   1053  HN  SER    65       9.030  -4.744   4.935  1.00  0.00
ATOM   1054  CA  SER    65       9.431  -2.832   5.783  1.00 15.40
ATOM   1055  HA  SER    65       9.404  -2.762   6.870  1.00  0.00
ATOM   1056  CB  SER    65      10.867  -3.094   5.338  1.00  2.23
ATOM   1057 2HB  SER    65      10.933  -2.985   4.255  1.00  0.00
ATOM   1058 3HB  SER    65      11.529  -2.372   5.817  1.00  0.00
ATOM   1059  OG  SER    65      11.268  -4.405   5.700  1.00 32.21
ATOM   1060  HG  SER    65      12.173  -4.543   5.409  1.00  0.00
ATOM   1061  C   SER    65       8.924  -1.516   5.191  1.00 13.15
ATOM   1062  O   SER    65       8.802  -0.514   5.895  1.00 62.15
ATOM   1063  N   ALA    66       8.615  -1.536   3.898  1.00 34.10
ATOM   1064  HN  ALA    66       8.753  -2.380   3.362  1.00  0.00
ATOM   1065  CA  ALA    66       8.079  -0.366   3.220  1.00 54.22
ATOM   1066  HA  ALA    66       8.640   0.508   3.552  1.00  0.00
ATOM   1067  CB  ALA    66       8.249  -0.505   1.715  1.00 24.42
ATOM   1068 1HB  ALA    66       7.870   0.388   1.217  1.00  0.00
ATOM   1069 2HB  ALA    66       9.306  -0.628   1.479  1.00  0.00
ATOM   1070 3HB  ALA    66       7.695  -1.376   1.366  1.00  0.00
ATOM   1071  C   ALA    66       6.610  -0.163   3.576  1.00 45.41
ATOM   1072  O   ALA    66       6.182   0.951   3.870  1.00 32.23
ATOM   1073  N   ALA    67       5.848  -1.255   3.566  1.00 75.31
ATOM   1074  HN  ALA    67       6.265  -2.150   3.353  1.00  0.00
ATOM   1075  CA  ALA    67       4.412  -1.212   3.853  1.00  4.20
ATOM   1076  HA  ALA    67       3.935  -0.590   3.095  1.00  0.00
ATOM   1077  CB  ALA    67       3.818  -2.609   3.784  1.00 33.13
ATOM   1078 1HB  ALA    67       2.745  -2.564   3.967  1.00  0.00
ATOM   1079 2HB  ALA    67       3.998  -3.030   2.795  1.00  0.00
ATOM   1080 3HB  ALA    67       4.288  -3.240   4.538  1.00  0.00
ATOM   1081  C   ALA    67       4.131  -0.608   5.223  1.00 73.35
ATOM   1082  O   ALA    67       3.103   0.033   5.438  1.00 14.33
ATOM   1083  N   GLU    68       5.055  -0.821   6.144  1.00 44.23
ATOM   1084  HN  GLU    68       5.899  -1.318   5.897  1.00  0.00
ATOM   1085  CA  GLU    68       4.904  -0.361   7.514  1.00 44.40
ATOM   1086  HA  GLU    68       3.871  -0.520   7.823  1.00  0.00
ATOM   1087  CB  GLU    68       5.824  -1.174   8.424  1.00 14.11
ATOM   1088 2HB  GLU    68       5.845  -2.202   8.063  1.00  0.00
ATOM   1089 3HB  GLU    68       6.827  -0.749   8.368  1.00  0.00
ATOM   1090  CG  GLU    68       5.390  -1.185   9.873  1.00 61.13
ATOM   1091 2HG  GLU    68       5.224  -0.157  10.197  1.00  0.00
ATOM   1092 3HG  GLU    68       4.458  -1.743   9.956  1.00  0.00
ATOM   1093  CD  GLU    68       6.421  -1.821  10.779  1.00 20.11
ATOM   1094  OE1 GLU    68       6.416  -3.060  10.913  1.00 34.45
ATOM   1095  OE2 GLU    68       7.250  -1.081  11.348  1.00 62.33
ATOM   1096 2HE  GLU    68       7.877  -1.550  11.904  1.00  0.00
ATOM   1097  C   GLU    68       5.227   1.129   7.630  1.00 75.25
ATOM   1098  O   GLU    68       4.959   1.757   8.653  1.00 10.11
ATOM   1099  N   MET    69       5.792   1.690   6.570  1.00 20.45
ATOM   1100  HN  MET    69       5.949   1.146   5.734  1.00  0.00
ATOM   1101  CA  MET    69       6.201   3.088   6.577  1.00 54.12
ATOM   1102  HA  MET    69       6.113   3.468   7.595  1.00  0.00
ATOM   1103  CB  MET    69       7.663   3.203   6.133  1.00 20.41
ATOM   1104 2HB  MET    69       8.232   2.415   6.625  1.00  0.00
ATOM   1105 3HB  MET    69       7.704   3.061   5.053  1.00  0.00
ATOM   1106  CG  MET    69       8.317   4.539   6.462  1.00 42.02
ATOM   1107 2HG  MET    69       9.191   4.667   5.822  1.00  0.00
ATOM   1108 3HG  MET    69       7.607   5.338   6.246  1.00  0.00
ATOM   1109  SD  MET    69       8.840   4.681   8.189  1.00  4.42
ATOM   1110  CE  MET    69       7.274   4.758   9.061  1.00 63.43
ATOM   1111 1HE  MET    69       7.440   4.847  10.134  1.00  0.00
ATOM   1112 2HE  MET    69       6.710   5.624   8.714  1.00  0.00
ATOM   1113 3HE  MET    69       6.705   3.851   8.861  1.00  0.00
ATOM   1114  C   MET    69       5.301   3.925   5.664  1.00 71.11
ATOM   1115  O   MET    69       5.238   5.151   5.783  1.00 34.42
ATOM   1116  N   ILE    70       4.608   3.255   4.751  1.00 71.51
ATOM   1117  HN  ILE    70       4.694   2.250   4.696  1.00  0.00
ATOM   1118  CA  ILE    70       3.716   3.924   3.814  1.00 12.23
ATOM   1119  HA  ILE    70       4.222   4.819   3.449  1.00  0.00
ATOM   1120  CB  ILE    70       3.390   3.017   2.604  1.00 13.04
ATOM   1121  HB  ILE    70       2.984   2.078   2.979  1.00  0.00
ATOM   1122  CG2 ILE    70       2.346   3.661   1.701  1.00 31.32
ATOM   1123 1HG2 ILE    70       2.117   2.997   0.867  1.00  0.00
ATOM   1124 2HG2 ILE    70       1.438   3.848   2.274  1.00  0.00
ATOM   1125 3HG2 ILE    70       2.733   4.605   1.315  1.00  0.00
ATOM   1126  CG1 ILE    70       4.666   2.712   1.818  1.00 34.52
ATOM   1127 2HG1 ILE    70       5.076   3.653   1.449  1.00  0.00
ATOM   1128 3HG1 ILE    70       5.382   2.244   2.493  1.00  0.00
ATOM   1129  CD1 ILE    70       4.452   1.790   0.637  1.00 53.12
ATOM   1130 1HD1 ILE    70       5.393   1.611   0.116  1.00  0.00
ATOM   1131 2HD1 ILE    70       4.053   0.840   0.990  1.00  0.00
ATOM   1132 3HD1 ILE    70       3.744   2.248  -0.054  1.00  0.00
ATOM   1133  C   ILE    70       2.420   4.343   4.499  1.00 22.13
ATOM   1134  O   ILE    70       1.825   3.569   5.249  1.00  5.50
ATOM   1135  N   GLU    71       1.996   5.573   4.234  1.00 74.54
ATOM   1136  HN  GLU    71       2.534   6.165   3.617  1.00  0.00
ATOM   1137  CA  GLU    71       0.770   6.106   4.805  1.00 62.40
ATOM   1138  HA  GLU    71       0.511   5.522   5.688  1.00  0.00
ATOM   1139  CB  GLU    71       0.975   7.565   5.218  1.00  4.32
ATOM   1140 2HB  GLU    71       1.811   7.610   5.916  1.00  0.00
ATOM   1141 3HB  GLU    71       1.217   8.144   4.326  1.00  0.00
ATOM   1142  CG  GLU    71      -0.237   8.195   5.882  1.00  4.43
ATOM   1143 2HG  GLU    71      -0.751   8.822   5.153  1.00  0.00
ATOM   1144 3HG  GLU    71      -0.909   7.403   6.211  1.00  0.00
ATOM   1145  CD  GLU    71       0.136   9.044   7.076  1.00 71.52
ATOM   1146  OE1 GLU    71       0.853   8.545   7.968  1.00 64.22
ATOM   1147  OE2 GLU    71      -0.289  10.214   7.135  1.00 11.53
ATOM   1148 2HE  GLU    71      -0.014  10.694   7.920  1.00  0.00
ATOM   1149  C   GLU    71      -0.366   6.006   3.792  1.00 30.13
ATOM   1150  O   GLU    71      -0.350   6.672   2.752  1.00 22.31
ATOM   1151  N   VAL    72      -1.343   5.166   4.091  1.00 24.24
ATOM   1152  HN  VAL    72      -1.307   4.640   4.952  1.00  0.00
ATOM   1153  CA  VAL    72      -2.481   4.974   3.208  1.00 73.40
ATOM   1154  HA  VAL    72      -2.415   5.715   2.411  1.00  0.00
ATOM   1155  CB  VAL    72      -2.490   3.566   2.570  1.00 61.32
ATOM   1156  HB  VAL    72      -3.380   3.484   1.946  1.00  0.00
ATOM   1157  CG1 VAL    72      -1.272   3.362   1.683  1.00 52.44
ATOM   1158 1HG1 VAL    72      -1.309   2.375   1.222  1.00  0.00
ATOM   1159 2HG1 VAL    72      -1.260   4.124   0.903  1.00  0.00
ATOM   1160 3HG1 VAL    72      -0.367   3.445   2.285  1.00  0.00
ATOM   1161  CG2 VAL    72      -2.562   2.485   3.642  1.00  5.02
ATOM   1162 1HG2 VAL    72      -2.594   1.501   3.174  1.00  0.00
ATOM   1163 2HG2 VAL    72      -1.682   2.552   4.283  1.00  0.00
ATOM   1164 3HG2 VAL    72      -3.460   2.630   4.242  1.00  0.00
ATOM   1165  C   VAL    72      -3.783   5.181   3.964  1.00 64.04
ATOM   1166  O   VAL    72      -3.787   5.310   5.188  1.00 22.25
ATOM   1167  N   GLU    73      -4.880   5.220   3.230  1.00 45.33
ATOM   1168  HN  GLU    73      -4.815   5.170   2.223  1.00  0.00
ATOM   1169  CA  GLU    73      -6.195   5.333   3.835  1.00 65.41
ATOM   1170  HA  GLU    73      -6.083   5.265   4.917  1.00  0.00
ATOM   1171  CB  GLU    73      -6.847   6.673   3.492  1.00 65.44
ATOM   1172 2HB  GLU    73      -6.995   6.717   2.413  1.00  0.00
ATOM   1173 3HB  GLU    73      -7.813   6.724   3.994  1.00  0.00
ATOM   1174  CG  GLU    73      -6.029   7.877   3.910  1.00  3.41
ATOM   1175 2HG  GLU    73      -5.702   7.739   4.940  1.00  0.00
ATOM   1176 3HG  GLU    73      -5.154   7.950   3.263  1.00  0.00
ATOM   1177  CD  GLU    73      -6.812   9.168   3.816  1.00 44.43
ATOM   1178  OE1 GLU    73      -7.138   9.745   4.877  1.00 73.24
ATOM   1179  OE2 GLU    73      -7.111   9.610   2.689  1.00 41.01
ATOM   1180 2HE  GLU    73      -7.608  10.431   2.707  1.00  0.00
ATOM   1181  C   GLU    73      -7.089   4.205   3.357  1.00 53.54
ATOM   1182  O   GLU    73      -7.093   3.870   2.170  1.00 75.24
END
