
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   87 ( 1351),  selected   87 , name 1qvp_A
# Molecule2: number of CA atoms   70 ( 1132),  selected   70 , name T0492.pdb
# PARAMETERS: 1qvp_A.T0492.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   140_A      -       -           -
LGA    S   141_A      -       -           -
LGA    H   142_A      -       -           -
LGA    M   143_A      -       -           -
LGA    D   144_A      -       -           -
LGA    A   145_A      -       -           -
LGA    A   146_A      -       -           -
LGA    A   147_A      -       -           -
LGA    P   148_A      -       -           -
LGA    G   149_A      -       -           -
LGA    T   150_A      F       2          3.424
LGA    R   151_A      S       3          2.777
LGA    V   152_A      L       4          1.749
LGA    I   153_A      R       5          1.991
LGA    D   154_A      D       6          2.055
LGA    A   155_A      A       7          1.630
LGA    A   156_A      K       8          2.587
LGA    T   157_A      -       -           -
LGA    S   158_A      -       -           -
LGA    M   159_A      C       9          4.504
LGA    P   160_A      G      10          2.248
LGA    R   161_A      Q      11          1.077
LGA    K   162_A      T      12          1.127
LGA    V   163_A      V      13          0.306
LGA    R   164_A      K      14          0.782
LGA    I   165_A      V      15          0.694
LGA    V   166_A      V      16          0.839
LGA    Q   167_A      K      17          0.905
LGA    I   168_A      L      18          0.427
LGA    N   169_A      H      19          0.988
LGA    E   170_A      G      20          1.879
LGA    I   171_A      T      21          2.697
LGA    F   172_A      G      22           #
LGA    Q   173_A      A      23          4.833
LGA    V   174_A      L      24          5.158
LGA    E   175_A      K      25           -
LGA    T   176_A      R      26           -
LGA    D   177_A      -       -           -
LGA    Q   178_A      R      27          4.940
LGA    F   179_A      I      28           #
LGA    T   180_A      M      29           -
LGA    Q   181_A      D      30           #
LGA    L   182_A      M      31          0.907
LGA    L   183_A      -       -           -
LGA    D   184_A      -       -           -
LGA    A   185_A      -       -           -
LGA    D   186_A      G      32          3.126
LGA    I   187_A      I      33          3.138
LGA    R   188_A      T      34          1.013
LGA    V   189_A      R      35          0.530
LGA    G   190_A      G      36          0.433
LGA    S   191_A      C      37          1.690
LGA    E   192_A      E      38          1.116
LGA    V   193_A      I      39          1.135
LGA    E   194_A      Y      40          1.156
LGA    I   195_A      I      41          1.976
LGA    V   196_A      R      42          3.656
LGA    -       -      K      43           -
LGA    D   197_A      V      44          1.271
LGA    R   198_A      A      45          1.817
LGA    D   199_A      G      48          5.327
LGA    G   200_A      D      49          3.121
LGA    H   201_A      P      50          0.715
LGA    I   202_A      I      51          1.067
LGA    T   203_A      Q      52          1.876
LGA    L   204_A      I      53          1.402
LGA    S   205_A      N      54          0.703
LGA    H   206_A      V      55          2.195
LGA    N   207_A      R      56          5.239
LGA    G   208_A      G      57          2.839
LGA    K   209_A      Y      58          0.928
LGA    D   210_A      E      59          2.067
LGA    V   211_A      L      60          3.238
LGA    E   212_A      S      61          2.510
LGA    L   213_A      L      62          3.368
LGA    L   214_A      R      63          3.708
LGA    -       -      K      64           -
LGA    D   215_A      S      65           #
LGA    D   216_A      A      66          4.797
LGA    L   217_A      -       -           -
LGA    A   218_A      A      67          1.384
LGA    H   219_A      E      68          1.245
LGA    T   220_A      M      69          2.533
LGA    I   221_A      I      70          2.196
LGA    R   222_A      E      71          1.753
LGA    I   223_A      V      72          1.401
LGA    E   224_A      E      73          2.115
LGA    E   225_A      -       -           -
LGA    L   226_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   87   70    5.0     61    2.52    22.95     58.869     2.326

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.330147 * X  +   0.563003 * Y  +   0.757648 * Z  + -42.563610
  Y_new =  -0.518065 * X  +   0.779035 * Y  +  -0.353148 * Z  +  69.288437
  Z_new =  -0.789057 * X  +  -0.275920 * Y  +   0.548868 * Z  + 104.819298 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.465811    2.675782  [ DEG:   -26.6890    153.3110 ]
  Theta =   0.909273    2.232319  [ DEG:    52.0975    127.9025 ]
  Phi   =  -1.003422    2.138171  [ DEG:   -57.4918    122.5081 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1qvp_A                                        
REMARK     2: T0492.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1qvp_A.T0492.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   87   70   5.0   61   2.52   22.95  58.869
REMARK  ---------------------------------------------------------- 
MOLECULE 1qvp_A
HEADER    DNA BINDING PROTEIN                     28-AUG-03   1QVP              
TITLE     C TERMINAL SH3-LIKE DOMAIN FROM DIPHTHERIA TOXIN REPRESSOR            
TITLE    2 RESIDUES 144-226.                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DIPHTHERIA TOXIN REPRESSOR;                                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 144-226;                                          
COMPND   5 SYNONYM: IRON-DEPENDENT DIPHTHERIA TOX REGULATORY ELEMENT,           
COMPND   6 TOX REGULATORY FACTOR;                                               
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CORYNEBACTERIUM DIPHTHERIAE;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: DTXR;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL-21(DE3);                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PET-15B                               
KEYWDS    REPRESSOR, DTXR, C-TERMINAL DOMAIN, PROKARYOTIC SH3 DOMAIN,           
KEYWDS   2 TRANSCRIPTION REGULATION, PEPTIDE-BINDING, GENE REGULATION           
EXPDTA    NMR, 13 STRUCTURES                                                    
AUTHOR    G.P.WYLIE,V.RANGACHARI,E.A.BIENKIEWICZ,V.MARIN,                       
AUTHOR   2 N.BHATTACHARYA,J.F.LOVE,J.R.MURPHY,T.M.LOGAN                         
REVDAT   2   15-MAR-05 1QVP    1       JRNL                                     
REVDAT   1   02-NOV-04 1QVP    0                                                
JRNL        AUTH   G.P.WYLIE,V.RANGACHARI,E.A.BIENKIEWICZ,V.MARIN,              
JRNL        AUTH 2 N.BHATTACHARYA,J.F.LOVE,J.R.MURPHY,T.M.LOGAN                 
JRNL        TITL   PROLYLPEPTIDE BINDING BY THE PROKARYOTIC SH3-LIKE            
JRNL        TITL 2 DOMAIN OF THE DIPHTHERIA TOXIN REPRESSOR: A                  
JRNL        TITL 3 REGULATORY SWITCH.                                           
JRNL        REF    BIOCHEMISTRY                  V.  44    40 2005              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1QVP A  144   226  UNP    P33120   DTXR_CORDI     144    226             
SEQRES   1 A   87  GLY SER HIS MET ASP ALA ALA ALA PRO GLY THR ARG VAL          
SEQRES   2 A   87  ILE ASP ALA ALA THR SER MET PRO ARG LYS VAL ARG ILE          
SEQRES   3 A   87  VAL GLN ILE ASN GLU ILE PHE GLN VAL GLU THR ASP GLN          
SEQRES   4 A   87  PHE THR GLN LEU LEU ASP ALA ASP ILE ARG VAL GLY SER          
SEQRES   5 A   87  GLU VAL GLU ILE VAL ASP ARG ASP GLY HIS ILE THR LEU          
SEQRES   6 A   87  SER HIS ASN GLY LYS ASP VAL GLU LEU LEU ASP ASP LEU          
SEQRES   7 A   87  ALA HIS THR ILE ARG ILE GLU GLU LEU                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A 140     -13.483  19.337  11.156  1.00 10.47           N  
ATOM      2  CA  GLY A 140     -13.273  17.955  11.669  1.00 10.56           C  
ATOM      3  C   GLY A 140     -11.864  17.454  11.427  1.00 10.04           C  
ATOM      4  O   GLY A 140     -11.661  16.473  10.711  1.00 10.08           O  
ATOM      5  HA2 GLY A 140     -13.470  17.943  12.731  1.00 10.83           H  
ATOM      6  HA3 GLY A 140     -13.969  17.292  11.177  1.00 10.96           H  
ATOM      7  H1  GLY A 140     -12.797  19.987  11.590  1.00 10.29           H  
ATOM      8  H2  GLY A 140     -14.444  19.662  11.387  1.00 10.45           H  
ATOM      9  H3  GLY A 140     -13.361  19.358  10.124  1.00 10.82           H  
ATOM     10  N   SER A 141     -10.886  18.128  12.024  1.00  9.76           N  
ATOM     11  CA  SER A 141      -9.487  17.747  11.869  1.00  9.42           C  
ATOM     12  C   SER A 141      -9.075  16.746  12.943  1.00  8.54           C  
ATOM     13  O   SER A 141      -9.163  17.030  14.138  1.00  8.54           O  
ATOM     14  CB  SER A 141      -8.588  18.983  11.936  1.00  9.90           C  
ATOM     15  OG  SER A 141      -7.278  18.687  11.486  1.00 10.72           O  
ATOM     16  H   SER A 141     -11.111  18.902  12.583  1.00  9.91           H  
ATOM     17  HA  SER A 141      -9.375  17.284  10.900  1.00  9.69           H  
ATOM     18  HB2 SER A 141      -9.002  19.761  11.312  1.00  9.80           H  
ATOM     19  HB3 SER A 141      -8.535  19.331  12.957  1.00  9.94           H  
ATOM     20  HG  SER A 141      -7.043  19.281  10.771  1.00 10.83           H  
ATOM     21  N   HIS A 142      -8.625  15.572  12.511  1.00  8.03           N  
ATOM     22  CA  HIS A 142      -8.200  14.527  13.434  1.00  7.37           C  
ATOM     23  C   HIS A 142      -6.712  14.650  13.747  1.00  6.35           C  
ATOM     24  O   HIS A 142      -5.870  14.550  12.854  1.00  6.43           O  
ATOM     25  CB  HIS A 142      -8.496  13.146  12.847  1.00  7.68           C  
ATOM     26  CG  HIS A 142      -8.789  12.104  13.882  1.00  8.57           C  
ATOM     27  ND1 HIS A 142      -8.094  12.007  15.068  1.00  8.98           N  
ATOM     28  CD2 HIS A 142      -9.710  11.111  13.904  1.00  9.35           C  
ATOM     29  CE1 HIS A 142      -8.574  10.998  15.775  1.00  9.92           C  
ATOM     30  NE2 HIS A 142      -9.554  10.439  15.090  1.00 10.14           N  
ATOM     31  H   HIS A 142      -8.578  15.404  11.546  1.00  8.28           H  
ATOM     32  HA  HIS A 142      -8.759  14.646  14.350  1.00  7.69           H  
ATOM     33  HB2 HIS A 142      -9.355  13.216  12.196  1.00  7.85           H  
ATOM     34  HB3 HIS A 142      -7.642  12.815  12.274  1.00  7.36           H  
ATOM     35  HD1 HIS A 142      -7.359  12.589  15.351  1.00  8.76           H  
ATOM     36  HD2 HIS A 142     -10.432  10.889  13.130  1.00  9.48           H  
ATOM     37  HE1 HIS A 142      -8.223  10.685  16.748  1.00 10.54           H  
ATOM     38  HE2 HIS A 142     -10.022   9.616  15.345  1.00 10.87           H  
ATOM     39  N   MET A 143      -6.394  14.867  15.020  1.00  5.69           N  
ATOM     40  CA  MET A 143      -5.007  15.003  15.449  1.00  4.93           C  
ATOM     41  C   MET A 143      -4.271  13.672  15.335  1.00  4.49           C  
ATOM     42  O   MET A 143      -3.481  13.466  14.414  1.00  4.78           O  
ATOM     43  CB  MET A 143      -4.944  15.514  16.890  1.00  5.11           C  
ATOM     44  CG  MET A 143      -5.174  17.012  17.014  1.00  5.84           C  
ATOM     45  SD  MET A 143      -3.762  17.981  16.449  1.00  6.33           S  
ATOM     46  CE  MET A 143      -4.448  19.634  16.491  1.00  6.97           C  
ATOM     47  H   MET A 143      -7.110  14.937  15.686  1.00  5.95           H  
ATOM     48  HA  MET A 143      -4.529  15.722  14.800  1.00  5.02           H  
ATOM     49  HB2 MET A 143      -5.698  15.006  17.473  1.00  5.46           H  
ATOM     50  HB3 MET A 143      -3.971  15.286  17.298  1.00  4.76           H  
ATOM     51  HG2 MET A 143      -6.036  17.281  16.422  1.00  5.89           H  
ATOM     52  HG3 MET A 143      -5.364  17.248  18.051  1.00  6.40           H  
ATOM     53  HE1 MET A 143      -5.501  19.593  16.253  1.00  6.91           H  
ATOM     54  HE2 MET A 143      -3.940  20.254  15.766  1.00  7.42           H  
ATOM     55  HE3 MET A 143      -4.317  20.054  17.477  1.00  7.27           H  
ATOM     56  N   ASP A 144      -4.537  12.770  16.275  1.00  4.21           N  
ATOM     57  CA  ASP A 144      -3.902  11.455  16.281  1.00  4.18           C  
ATOM     58  C   ASP A 144      -2.433  11.557  16.681  1.00  4.00           C  
ATOM     59  O   ASP A 144      -1.995  10.919  17.639  1.00  4.54           O  
ATOM     60  CB  ASP A 144      -4.024  10.799  14.905  1.00  4.57           C  
ATOM     61  CG  ASP A 144      -3.950   9.287  14.976  1.00  4.73           C  
ATOM     62  OD1 ASP A 144      -2.828   8.752  15.102  1.00  5.01           O  
ATOM     63  OD2 ASP A 144      -5.014   8.636  14.906  1.00  5.01           O  
ATOM     64  H   ASP A 144      -5.178  12.992  16.983  1.00  4.36           H  
ATOM     65  HA  ASP A 144      -4.417  10.843  17.007  1.00  4.53           H  
ATOM     66  HB2 ASP A 144      -4.971  11.074  14.463  1.00  4.73           H  
ATOM     67  HB3 ASP A 144      -3.221  11.152  14.272  1.00  4.77           H  
ATOM     68  N   ALA A 145      -1.675  12.360  15.939  1.00  3.65           N  
ATOM     69  CA  ALA A 145      -0.253  12.544  16.212  1.00  4.12           C  
ATOM     70  C   ALA A 145       0.559  11.360  15.699  1.00  4.40           C  
ATOM     71  O   ALA A 145       1.677  11.115  16.154  1.00  5.09           O  
ATOM     72  CB  ALA A 145      -0.021  12.740  17.704  1.00  4.56           C  
ATOM     73  H   ALA A 145      -2.081  12.840  15.186  1.00  3.39           H  
ATOM     74  HA  ALA A 145       0.070  13.438  15.701  1.00  4.48           H  
ATOM     75  HB1 ALA A 145       0.133  11.779  18.174  1.00  4.51           H  
ATOM     76  HB2 ALA A 145      -0.883  13.220  18.142  1.00  4.95           H  
ATOM     77  HB3 ALA A 145       0.851  13.359  17.854  1.00  4.98           H  
ATOM     78  N   ALA A 146      -0.009  10.629  14.745  1.00  4.14           N  
ATOM     79  CA  ALA A 146       0.660   9.470  14.164  1.00  4.78           C  
ATOM     80  C   ALA A 146      -0.145   8.906  12.998  1.00  4.41           C  
ATOM     81  O   ALA A 146      -0.616   7.770  13.047  1.00  4.64           O  
ATOM     82  CB  ALA A 146       0.879   8.401  15.224  1.00  5.54           C  
ATOM     83  H   ALA A 146      -0.901  10.875  14.422  1.00  3.69           H  
ATOM     84  HA  ALA A 146       1.625   9.789  13.802  1.00  5.26           H  
ATOM     85  HB1 ALA A 146       1.596   8.755  15.950  1.00  5.88           H  
ATOM     86  HB2 ALA A 146       1.254   7.502  14.757  1.00  5.78           H  
ATOM     87  HB3 ALA A 146      -0.058   8.186  15.718  1.00  5.86           H  
ATOM     88  N   ALA A 147      -0.299   9.709  11.950  1.00  4.14           N  
ATOM     89  CA  ALA A 147      -1.048   9.294  10.769  1.00  3.87           C  
ATOM     90  C   ALA A 147      -2.531   9.136  11.089  1.00  3.09           C  
ATOM     91  O   ALA A 147      -2.923   8.243  11.841  1.00  3.48           O  
ATOM     92  CB  ALA A 147      -0.487   7.994  10.214  1.00  4.53           C  
ATOM     93  H   ALA A 147       0.099  10.604  11.971  1.00  4.34           H  
ATOM     94  HA  ALA A 147      -0.931  10.058  10.016  1.00  4.03           H  
ATOM     95  HB1 ALA A 147       0.589   8.064  10.153  1.00  4.89           H  
ATOM     96  HB2 ALA A 147      -0.893   7.819   9.229  1.00  5.01           H  
ATOM     97  HB3 ALA A 147      -0.759   7.177  10.866  1.00  4.56           H  
ATOM     98  N   PRO A 148      -3.377  10.007  10.519  1.00  2.31           N  
ATOM     99  CA  PRO A 148      -4.825   9.967  10.745  1.00  2.16           C  
ATOM    100  C   PRO A 148      -5.480   8.755  10.089  1.00  1.90           C  
ATOM    101  O   PRO A 148      -6.366   8.126  10.668  1.00  2.05           O  
ATOM    102  CB  PRO A 148      -5.322  11.260  10.096  1.00  2.11           C  
ATOM    103  CG  PRO A 148      -4.301  11.582   9.061  1.00  2.00           C  
ATOM    104  CD  PRO A 148      -2.988  11.101   9.612  1.00  2.20           C  
ATOM    105  HA  PRO A 148      -5.062   9.975  11.798  1.00  2.87           H  
ATOM    106  HB2 PRO A 148      -6.294  11.094   9.655  1.00  2.18           H  
ATOM    107  HB3 PRO A 148      -5.387  12.038  10.841  1.00  2.75           H  
ATOM    108  HG2 PRO A 148      -4.533  11.064   8.141  1.00  2.24           H  
ATOM    109  HG3 PRO A 148      -4.270  12.648   8.895  1.00  2.36           H  
ATOM    110  HD2 PRO A 148      -2.356  10.735   8.816  1.00  2.42           H  
ATOM    111  HD3 PRO A 148      -2.493  11.893  10.154  1.00  2.68           H  
ATOM    112  N   GLY A 149      -5.039   8.432   8.877  1.00  1.76           N  
ATOM    113  CA  GLY A 149      -5.593   7.298   8.163  1.00  1.80           C  
ATOM    114  C   GLY A 149      -5.199   5.972   8.784  1.00  1.59           C  
ATOM    115  O   GLY A 149      -4.448   5.935   9.759  1.00  1.67           O  
ATOM    116  H   GLY A 149      -4.331   8.970   8.464  1.00  1.84           H  
ATOM    117  HA2 GLY A 149      -6.671   7.376   8.165  1.00  2.01           H  
ATOM    118  HA3 GLY A 149      -5.243   7.322   7.142  1.00  2.03           H  
ATOM    119  N   THR A 150      -5.707   4.881   8.219  1.00  1.65           N  
ATOM    120  CA  THR A 150      -5.402   3.547   8.723  1.00  1.56           C  
ATOM    121  C   THR A 150      -3.948   3.179   8.446  1.00  1.57           C  
ATOM    122  O   THR A 150      -3.216   3.940   7.811  1.00  1.70           O  
ATOM    123  CB  THR A 150      -6.334   2.512   8.087  1.00  1.57           C  
ATOM    124  OG1 THR A 150      -7.468   3.142   7.517  1.00  1.89           O  
ATOM    125  CG2 THR A 150      -6.830   1.471   9.067  1.00  1.60           C  
ATOM    126  H   THR A 150      -6.298   4.975   7.444  1.00  1.95           H  
ATOM    127  HA  THR A 150      -5.561   3.552   9.792  1.00  1.75           H  
ATOM    128  HB  THR A 150      -5.800   1.998   7.300  1.00  1.56           H  
ATOM    129  HG1 THR A 150      -7.321   3.278   6.579  1.00  1.86           H  
ATOM    130 HG21 THR A 150      -7.802   1.761   9.439  1.00  1.71           H  
ATOM    131 HG22 THR A 150      -6.138   1.394   9.892  1.00  1.86           H  
ATOM    132 HG23 THR A 150      -6.906   0.515   8.570  1.00  2.10           H  
ATOM    133  N   ARG A 151      -3.534   2.010   8.924  1.00  1.91           N  
ATOM    134  CA  ARG A 151      -2.166   1.543   8.727  1.00  2.32           C  
ATOM    135  C   ARG A 151      -2.094   0.536   7.585  1.00  1.84           C  
ATOM    136  O   ARG A 151      -3.098  -0.076   7.218  1.00  1.63           O  
ATOM    137  CB  ARG A 151      -1.629   0.912  10.013  1.00  3.22           C  
ATOM    138  CG  ARG A 151      -1.984   1.693  11.268  1.00  3.87           C  
ATOM    139  CD  ARG A 151      -1.217   1.183  12.478  1.00  4.30           C  
ATOM    140  NE  ARG A 151      -1.709   1.765  13.724  1.00  4.96           N  
ATOM    141  CZ  ARG A 151      -1.048   1.709  14.876  1.00  5.54           C  
ATOM    142  NH1 ARG A 151       0.129   1.100  14.941  1.00  5.82           N  
ATOM    143  NH2 ARG A 151      -1.563   2.262  15.965  1.00  6.09           N  
ATOM    144  H   ARG A 151      -4.164   1.448   9.422  1.00  2.12           H  
ATOM    145  HA  ARG A 151      -1.558   2.399   8.476  1.00  2.61           H  
ATOM    146  HB2 ARG A 151      -2.034  -0.084  10.109  1.00  3.42           H  
ATOM    147  HB3 ARG A 151      -0.553   0.850   9.947  1.00  3.55           H  
ATOM    148  HG2 ARG A 151      -1.742   2.735  11.114  1.00  4.39           H  
ATOM    149  HG3 ARG A 151      -3.043   1.592  11.456  1.00  3.88           H  
ATOM    150  HD2 ARG A 151      -1.320   0.110  12.527  1.00  4.05           H  
ATOM    151  HD3 ARG A 151      -0.174   1.439  12.359  1.00  4.72           H  
ATOM    152  HE  ARG A 151      -2.576   2.220  13.701  1.00  5.18           H  
ATOM    153 HH11 ARG A 151       0.521   0.682  14.121  1.00  5.64           H  
ATOM    154 HH12 ARG A 151       0.624   1.060  15.808  1.00  6.37           H  
ATOM    155 HH21 ARG A 151      -2.450   2.723  15.921  1.00  6.07           H  
ATOM    156 HH22 ARG A 151      -1.065   2.219  16.831  1.00  6.65           H  
ATOM    157  N   VAL A 152      -0.899   0.368   7.025  1.00  1.82           N  
ATOM    158  CA  VAL A 152      -0.695  -0.566   5.924  1.00  1.50           C  
ATOM    159  C   VAL A 152      -0.491  -1.989   6.436  1.00  1.32           C  
ATOM    160  O   VAL A 152      -0.492  -2.944   5.659  1.00  1.28           O  
ATOM    161  CB  VAL A 152       0.518  -0.164   5.064  1.00  1.78           C  
ATOM    162  CG1 VAL A 152       0.278   1.180   4.395  1.00  2.17           C  
ATOM    163  CG2 VAL A 152       1.784  -0.129   5.907  1.00  2.36           C  
ATOM    164  H   VAL A 152      -0.138   0.884   7.361  1.00  2.13           H  
ATOM    165  HA  VAL A 152      -1.576  -0.542   5.299  1.00  1.41           H  
ATOM    166  HB  VAL A 152       0.647  -0.907   4.290  1.00  1.94           H  
ATOM    167 HG11 VAL A 152       1.153   1.463   3.831  1.00  2.54           H  
ATOM    168 HG12 VAL A 152       0.079   1.927   5.150  1.00  2.62           H  
ATOM    169 HG13 VAL A 152      -0.571   1.105   3.731  1.00  2.37           H  
ATOM    170 HG21 VAL A 152       1.931  -1.091   6.375  1.00  2.60           H  
ATOM    171 HG22 VAL A 152       1.689   0.631   6.668  1.00  2.77           H  
ATOM    172 HG23 VAL A 152       2.631   0.097   5.276  1.00  2.84           H  
ATOM    173  N   ILE A 153      -0.318  -2.125   7.748  1.00  1.51           N  
ATOM    174  CA  ILE A 153      -0.115  -3.432   8.360  1.00  1.59           C  
ATOM    175  C   ILE A 153      -1.325  -3.848   9.191  1.00  1.41           C  
ATOM    176  O   ILE A 153      -1.401  -4.979   9.672  1.00  1.73           O  
ATOM    177  CB  ILE A 153       1.141  -3.450   9.257  1.00  2.05           C  
ATOM    178  CG1 ILE A 153       1.422  -2.055   9.820  1.00  2.53           C  
ATOM    179  CG2 ILE A 153       2.342  -3.962   8.476  1.00  2.29           C  
ATOM    180  CD1 ILE A 153       0.376  -1.577  10.804  1.00  2.76           C  
ATOM    181  H   ILE A 153      -0.329  -1.327   8.316  1.00  1.76           H  
ATOM    182  HA  ILE A 153       0.026  -4.152   7.568  1.00  1.67           H  
ATOM    183  HB  ILE A 153       0.961  -4.130  10.076  1.00  2.43           H  
ATOM    184 HG12 ILE A 153       2.374  -2.064  10.328  1.00  3.02           H  
ATOM    185 HG13 ILE A 153       1.460  -1.346   9.006  1.00  2.89           H  
ATOM    186 HG21 ILE A 153       3.202  -4.008   9.128  1.00  2.71           H  
ATOM    187 HG22 ILE A 153       2.548  -3.292   7.654  1.00  2.62           H  
ATOM    188 HG23 ILE A 153       2.127  -4.948   8.092  1.00  2.55           H  
ATOM    189 HD11 ILE A 153       0.615  -0.574  11.125  1.00  3.06           H  
ATOM    190 HD12 ILE A 153       0.361  -2.235  11.660  1.00  3.11           H  
ATOM    191 HD13 ILE A 153      -0.594  -1.581  10.329  1.00  2.97           H  
ATOM    192  N   ASP A 154      -2.271  -2.927   9.357  1.00  1.22           N  
ATOM    193  CA  ASP A 154      -3.478  -3.202  10.130  1.00  1.21           C  
ATOM    194  C   ASP A 154      -4.694  -3.329   9.217  1.00  1.15           C  
ATOM    195  O   ASP A 154      -5.729  -3.860   9.616  1.00  1.30           O  
ATOM    196  CB  ASP A 154      -3.713  -2.095  11.160  1.00  1.37           C  
ATOM    197  CG  ASP A 154      -2.789  -2.211  12.356  1.00  1.55           C  
ATOM    198  OD1 ASP A 154      -1.769  -2.924  12.251  1.00  2.12           O  
ATOM    199  OD2 ASP A 154      -3.084  -1.589  13.398  1.00  2.02           O  
ATOM    200  H   ASP A 154      -2.156  -2.044   8.950  1.00  1.36           H  
ATOM    201  HA  ASP A 154      -3.334  -4.138  10.648  1.00  1.33           H  
ATOM    202  HB2 ASP A 154      -3.548  -1.136  10.692  1.00  1.66           H  
ATOM    203  HB3 ASP A 154      -4.734  -2.150  11.510  1.00  1.58           H  
ATOM    204  N   ALA A 155      -4.560  -2.838   7.988  1.00  1.10           N  
ATOM    205  CA  ALA A 155      -5.647  -2.896   7.018  1.00  1.18           C  
ATOM    206  C   ALA A 155      -5.360  -3.926   5.929  1.00  1.19           C  
ATOM    207  O   ALA A 155      -6.154  -4.101   5.005  1.00  1.34           O  
ATOM    208  CB  ALA A 155      -5.877  -1.524   6.403  1.00  1.27           C  
ATOM    209  H   ALA A 155      -3.710  -2.426   7.729  1.00  1.12           H  
ATOM    210  HA  ALA A 155      -6.546  -3.184   7.543  1.00  1.29           H  
ATOM    211  HB1 ALA A 155      -6.701  -1.576   5.707  1.00  1.78           H  
ATOM    212  HB2 ALA A 155      -4.986  -1.209   5.882  1.00  1.69           H  
ATOM    213  HB3 ALA A 155      -6.109  -0.814   7.182  1.00  1.48           H  
ATOM    214  N   ALA A 156      -4.228  -4.612   6.049  1.00  1.15           N  
ATOM    215  CA  ALA A 156      -3.846  -5.635   5.082  1.00  1.22           C  
ATOM    216  C   ALA A 156      -3.916  -7.006   5.729  1.00  1.32           C  
ATOM    217  O   ALA A 156      -4.069  -8.028   5.058  1.00  1.62           O  
ATOM    218  CB  ALA A 156      -2.447  -5.365   4.546  1.00  1.26           C  
ATOM    219  H   ALA A 156      -3.641  -4.442   6.820  1.00  1.14           H  
ATOM    220  HA  ALA A 156      -4.543  -5.596   4.258  1.00  1.30           H  
ATOM    221  HB1 ALA A 156      -2.406  -4.368   4.133  1.00  1.43           H  
ATOM    222  HB2 ALA A 156      -2.214  -6.084   3.774  1.00  1.76           H  
ATOM    223  HB3 ALA A 156      -1.731  -5.453   5.348  1.00  1.61           H  
ATOM    224  N   THR A 157      -3.800  -7.002   7.047  1.00  1.58           N  
ATOM    225  CA  THR A 157      -3.844  -8.215   7.843  1.00  1.75           C  
ATOM    226  C   THR A 157      -5.170  -8.948   7.653  1.00  2.17           C  
ATOM    227  O   THR A 157      -5.203 -10.174   7.548  1.00  2.51           O  
ATOM    228  CB  THR A 157      -3.637  -7.845   9.310  1.00  1.68           C  
ATOM    229  OG1 THR A 157      -2.443  -8.422   9.810  1.00  1.88           O  
ATOM    230  CG2 THR A 157      -4.771  -8.277  10.215  1.00  2.01           C  
ATOM    231  H   THR A 157      -3.682  -6.145   7.506  1.00  1.89           H  
ATOM    232  HA  THR A 157      -3.037  -8.856   7.523  1.00  1.89           H  
ATOM    233  HB  THR A 157      -3.550  -6.765   9.378  1.00  1.53           H  
ATOM    234  HG1 THR A 157      -1.694  -7.876   9.559  1.00  2.19           H  
ATOM    235 HG21 THR A 157      -4.539  -8.012  11.235  1.00  2.12           H  
ATOM    236 HG22 THR A 157      -4.903  -9.346  10.142  1.00  2.50           H  
ATOM    237 HG23 THR A 157      -5.682  -7.781   9.913  1.00  2.35           H  
ATOM    238  N   SER A 158      -6.259  -8.187   7.610  1.00  2.41           N  
ATOM    239  CA  SER A 158      -7.587  -8.761   7.431  1.00  2.97           C  
ATOM    240  C   SER A 158      -8.026  -8.669   5.972  1.00  2.86           C  
ATOM    241  O   SER A 158      -7.192  -8.598   5.069  1.00  3.34           O  
ATOM    242  CB  SER A 158      -8.599  -8.044   8.329  1.00  3.64           C  
ATOM    243  OG  SER A 158      -8.030  -7.729   9.589  1.00  4.28           O  
ATOM    244  H   SER A 158      -6.166  -7.216   7.698  1.00  2.36           H  
ATOM    245  HA  SER A 158      -7.540  -9.802   7.716  1.00  3.29           H  
ATOM    246  HB2 SER A 158      -8.914  -7.129   7.853  1.00  3.54           H  
ATOM    247  HB3 SER A 158      -9.455  -8.684   8.484  1.00  4.18           H  
ATOM    248  HG  SER A 158      -7.903  -8.536  10.093  1.00  4.59           H  
ATOM    249  N   MET A 159      -9.337  -8.671   5.747  1.00  2.75           N  
ATOM    250  CA  MET A 159      -9.881  -8.586   4.396  1.00  2.81           C  
ATOM    251  C   MET A 159      -9.215  -7.460   3.611  1.00  2.48           C  
ATOM    252  O   MET A 159      -9.272  -6.297   4.007  1.00  2.51           O  
ATOM    253  CB  MET A 159     -11.395  -8.363   4.446  1.00  3.35           C  
ATOM    254  CG  MET A 159     -12.159  -9.513   5.082  1.00  4.03           C  
ATOM    255  SD  MET A 159     -13.765  -9.007   5.728  1.00  4.68           S  
ATOM    256  CE  MET A 159     -14.844 -10.171   4.900  1.00  5.03           C  
ATOM    257  H   MET A 159      -9.953  -8.729   6.508  1.00  2.98           H  
ATOM    258  HA  MET A 159      -9.681  -9.524   3.900  1.00  2.99           H  
ATOM    259  HB2 MET A 159     -11.595  -7.467   5.015  1.00  3.61           H  
ATOM    260  HB3 MET A 159     -11.760  -8.230   3.439  1.00  3.31           H  
ATOM    261  HG2 MET A 159     -12.312 -10.280   4.337  1.00  4.17           H  
ATOM    262  HG3 MET A 159     -11.569  -9.914   5.894  1.00  4.33           H  
ATOM    263  HE1 MET A 159     -14.574 -11.177   5.183  1.00  5.36           H  
ATOM    264  HE2 MET A 159     -14.743 -10.059   3.831  1.00  5.00           H  
ATOM    265  HE3 MET A 159     -15.868  -9.979   5.187  1.00  5.32           H  
ATOM    266  N   PRO A 160      -8.572  -7.796   2.481  1.00  2.75           N  
ATOM    267  CA  PRO A 160      -7.890  -6.810   1.636  1.00  2.83           C  
ATOM    268  C   PRO A 160      -8.868  -5.869   0.940  1.00  1.83           C  
ATOM    269  O   PRO A 160      -9.873  -6.306   0.379  1.00  2.20           O  
ATOM    270  CB  PRO A 160      -7.152  -7.671   0.608  1.00  3.94           C  
ATOM    271  CG  PRO A 160      -7.922  -8.943   0.553  1.00  4.45           C  
ATOM    272  CD  PRO A 160      -8.458  -9.162   1.941  1.00  3.56           C  
ATOM    273  HA  PRO A 160      -7.176  -6.230   2.202  1.00  3.30           H  
ATOM    274  HB2 PRO A 160      -7.147  -7.169  -0.350  1.00  3.96           H  
ATOM    275  HB3 PRO A 160      -6.137  -7.838   0.937  1.00  4.60           H  
ATOM    276  HG2 PRO A 160      -8.735  -8.851  -0.152  1.00  5.01           H  
ATOM    277  HG3 PRO A 160      -7.271  -9.757   0.271  1.00  5.09           H  
ATOM    278  HD2 PRO A 160      -9.424  -9.643   1.901  1.00  3.43           H  
ATOM    279  HD3 PRO A 160      -7.766  -9.751   2.525  1.00  3.99           H  
ATOM    280  N   ARG A 161      -8.566  -4.576   0.980  1.00  1.37           N  
ATOM    281  CA  ARG A 161      -9.418  -3.572   0.353  1.00  1.21           C  
ATOM    282  C   ARG A 161      -8.580  -2.521  -0.368  1.00  1.06           C  
ATOM    283  O   ARG A 161      -7.356  -2.494  -0.240  1.00  1.57           O  
ATOM    284  CB  ARG A 161     -10.306  -2.899   1.402  1.00  2.07           C  
ATOM    285  CG  ARG A 161     -11.193  -3.873   2.162  1.00  2.81           C  
ATOM    286  CD  ARG A 161     -12.294  -4.433   1.275  1.00  3.76           C  
ATOM    287  NE  ARG A 161     -13.002  -5.540   1.915  1.00  4.31           N  
ATOM    288  CZ  ARG A 161     -13.873  -6.321   1.284  1.00  4.96           C  
ATOM    289  NH1 ARG A 161     -14.144  -6.118   0.001  1.00  5.52           N  
ATOM    290  NH2 ARG A 161     -14.476  -7.306   1.936  1.00  5.25           N  
ATOM    291  H   ARG A 161      -7.751  -4.289   1.443  1.00  1.96           H  
ATOM    292  HA  ARG A 161     -10.045  -4.072  -0.368  1.00  1.80           H  
ATOM    293  HB2 ARG A 161      -9.678  -2.388   2.115  1.00  2.43           H  
ATOM    294  HB3 ARG A 161     -10.941  -2.177   0.909  1.00  2.63           H  
ATOM    295  HG2 ARG A 161     -10.587  -4.689   2.525  1.00  3.11           H  
ATOM    296  HG3 ARG A 161     -11.644  -3.356   2.998  1.00  2.99           H  
ATOM    297  HD2 ARG A 161     -13.000  -3.646   1.058  1.00  3.99           H  
ATOM    298  HD3 ARG A 161     -11.853  -4.785   0.354  1.00  4.21           H  
ATOM    299  HE  ARG A 161     -12.819  -5.708   2.863  1.00  4.41           H  
ATOM    300 HH11 ARG A 161     -13.691  -5.376  -0.495  1.00  5.46           H  
ATOM    301 HH12 ARG A 161     -14.800  -6.707  -0.471  1.00  6.10           H  
ATOM    302 HH21 ARG A 161     -14.275  -7.462   2.902  1.00  5.02           H  
ATOM    303 HH22 ARG A 161     -15.131  -7.893   1.460  1.00  5.83           H  
ATOM    304  N   LYS A 162      -9.247  -1.659  -1.129  1.00  1.13           N  
ATOM    305  CA  LYS A 162      -8.563  -0.607  -1.872  1.00  0.97           C  
ATOM    306  C   LYS A 162      -8.202   0.561  -0.958  1.00  0.96           C  
ATOM    307  O   LYS A 162      -9.079   1.281  -0.481  1.00  1.12           O  
ATOM    308  CB  LYS A 162      -9.442  -0.114  -3.024  1.00  0.96           C  
ATOM    309  CG  LYS A 162      -9.882  -1.221  -3.969  1.00  1.47           C  
ATOM    310  CD  LYS A 162     -11.011  -0.762  -4.877  1.00  1.77           C  
ATOM    311  CE  LYS A 162     -11.736  -1.942  -5.505  1.00  2.44           C  
ATOM    312  NZ  LYS A 162     -12.871  -1.504  -6.364  1.00  2.89           N  
ATOM    313  H   LYS A 162     -10.223  -1.732  -1.191  1.00  1.67           H  
ATOM    314  HA  LYS A 162      -7.654  -1.025  -2.278  1.00  0.98           H  
ATOM    315  HB2 LYS A 162     -10.325   0.353  -2.614  1.00  1.28           H  
ATOM    316  HB3 LYS A 162      -8.890   0.618  -3.594  1.00  1.47           H  
ATOM    317  HG2 LYS A 162      -9.041  -1.517  -4.578  1.00  2.20           H  
ATOM    318  HG3 LYS A 162     -10.221  -2.065  -3.385  1.00  1.83           H  
ATOM    319  HD2 LYS A 162     -11.717  -0.187  -4.296  1.00  1.97           H  
ATOM    320  HD3 LYS A 162     -10.600  -0.143  -5.662  1.00  2.25           H  
ATOM    321  HE2 LYS A 162     -11.034  -2.498  -6.108  1.00  2.91           H  
ATOM    322  HE3 LYS A 162     -12.114  -2.576  -4.718  1.00  2.77           H  
ATOM    323  HZ1 LYS A 162     -13.495  -0.865  -5.832  1.00  3.00           H  
ATOM    324  HZ2 LYS A 162     -13.423  -2.329  -6.676  1.00  3.35           H  
ATOM    325  HZ3 LYS A 162     -12.513  -1.004  -7.203  1.00  3.19           H  
ATOM    326  N   VAL A 163      -6.908   0.741  -0.720  1.00  0.89           N  
ATOM    327  CA  VAL A 163      -6.431   1.822   0.136  1.00  0.91           C  
ATOM    328  C   VAL A 163      -5.775   2.925  -0.686  1.00  0.87           C  
ATOM    329  O   VAL A 163      -4.921   2.659  -1.532  1.00  0.89           O  
ATOM    330  CB  VAL A 163      -5.424   1.309   1.183  1.00  0.98           C  
ATOM    331  CG1 VAL A 163      -6.110   0.388   2.179  1.00  1.09           C  
ATOM    332  CG2 VAL A 163      -4.260   0.602   0.505  1.00  0.94           C  
ATOM    333  H   VAL A 163      -6.257   0.134  -1.130  1.00  0.93           H  
ATOM    334  HA  VAL A 163      -7.283   2.234   0.659  1.00  0.96           H  
ATOM    335  HB  VAL A 163      -5.034   2.160   1.724  1.00  1.01           H  
ATOM    336 HG11 VAL A 163      -6.901   0.925   2.682  1.00  1.60           H  
ATOM    337 HG12 VAL A 163      -5.390   0.044   2.908  1.00  1.40           H  
ATOM    338 HG13 VAL A 163      -6.526  -0.460   1.657  1.00  1.46           H  
ATOM    339 HG21 VAL A 163      -4.628  -0.252  -0.044  1.00  1.45           H  
ATOM    340 HG22 VAL A 163      -3.554   0.272   1.252  1.00  1.16           H  
ATOM    341 HG23 VAL A 163      -3.771   1.283  -0.176  1.00  1.39           H  
ATOM    342  N   ARG A 164      -6.181   4.166  -0.434  1.00  0.88           N  
ATOM    343  CA  ARG A 164      -5.632   5.311  -1.152  1.00  0.87           C  
ATOM    344  C   ARG A 164      -4.450   5.910  -0.398  1.00  0.85           C  
ATOM    345  O   ARG A 164      -4.535   6.174   0.800  1.00  1.01           O  
ATOM    346  CB  ARG A 164      -6.712   6.375  -1.358  1.00  0.99           C  
ATOM    347  CG  ARG A 164      -6.392   7.358  -2.472  1.00  1.19           C  
ATOM    348  CD  ARG A 164      -7.272   8.596  -2.394  1.00  1.56           C  
ATOM    349  NE  ARG A 164      -8.016   8.818  -3.631  1.00  1.98           N  
ATOM    350  CZ  ARG A 164      -8.873   9.819  -3.806  1.00  2.17           C  
ATOM    351  NH1 ARG A 164      -9.093  10.687  -2.829  1.00  2.36           N  
ATOM    352  NH2 ARG A 164      -9.510   9.952  -4.962  1.00  2.62           N  
ATOM    353  H   ARG A 164      -6.865   4.315   0.252  1.00  0.93           H  
ATOM    354  HA  ARG A 164      -5.292   4.964  -2.117  1.00  0.83           H  
ATOM    355  HB2 ARG A 164      -7.644   5.884  -1.598  1.00  1.00           H  
ATOM    356  HB3 ARG A 164      -6.834   6.930  -0.441  1.00  1.16           H  
ATOM    357  HG2 ARG A 164      -5.358   7.658  -2.387  1.00  1.46           H  
ATOM    358  HG3 ARG A 164      -6.551   6.873  -3.424  1.00  1.32           H  
ATOM    359  HD2 ARG A 164      -7.972   8.473  -1.582  1.00  2.10           H  
ATOM    360  HD3 ARG A 164      -6.646   9.455  -2.203  1.00  1.75           H  
ATOM    361  HE  ARG A 164      -7.869   8.189  -4.368  1.00  2.46           H  
ATOM    362 HH11 ARG A 164      -8.614  10.591  -1.957  1.00  2.52           H  
ATOM    363 HH12 ARG A 164      -9.737  11.440  -2.964  1.00  2.61           H  
ATOM    364 HH21 ARG A 164      -9.347   9.300  -5.701  1.00  2.94           H  
ATOM    365 HH22 ARG A 164     -10.155  10.707  -5.093  1.00  2.83           H  
ATOM    366  N   ILE A 165      -3.347   6.123  -1.110  1.00  0.87           N  
ATOM    367  CA  ILE A 165      -2.147   6.692  -0.509  1.00  0.95           C  
ATOM    368  C   ILE A 165      -2.117   8.208  -0.676  1.00  0.96           C  
ATOM    369  O   ILE A 165      -2.411   8.728  -1.753  1.00  1.34           O  
ATOM    370  CB  ILE A 165      -0.868   6.092  -1.124  1.00  1.53           C  
ATOM    371  CG1 ILE A 165      -0.948   4.564  -1.134  1.00  1.92           C  
ATOM    372  CG2 ILE A 165       0.360   6.558  -0.356  1.00  1.97           C  
ATOM    373  CD1 ILE A 165      -1.634   4.003  -2.361  1.00  2.47           C  
ATOM    374  H   ILE A 165      -3.341   5.892  -2.063  1.00  0.98           H  
ATOM    375  HA  ILE A 165      -2.159   6.457   0.546  1.00  1.12           H  
ATOM    376  HB  ILE A 165      -0.783   6.448  -2.140  1.00  1.64           H  
ATOM    377 HG12 ILE A 165       0.052   4.157  -1.099  1.00  2.48           H  
ATOM    378 HG13 ILE A 165      -1.497   4.233  -0.265  1.00  1.91           H  
ATOM    379 HG21 ILE A 165       0.445   7.632  -0.433  1.00  2.41           H  
ATOM    380 HG22 ILE A 165       1.242   6.096  -0.774  1.00  2.16           H  
ATOM    381 HG23 ILE A 165       0.263   6.278   0.682  1.00  2.40           H  
ATOM    382 HD11 ILE A 165      -1.238   3.021  -2.577  1.00  2.69           H  
ATOM    383 HD12 ILE A 165      -1.457   4.655  -3.203  1.00  2.85           H  
ATOM    384 HD13 ILE A 165      -2.696   3.929  -2.177  1.00  3.04           H  
ATOM    385  N   VAL A 166      -1.762   8.911   0.395  1.00  1.19           N  
ATOM    386  CA  VAL A 166      -1.697  10.368   0.365  1.00  1.72           C  
ATOM    387  C   VAL A 166      -0.291  10.868   0.684  1.00  1.87           C  
ATOM    388  O   VAL A 166       0.039  12.026   0.421  1.00  2.44           O  
ATOM    389  CB  VAL A 166      -2.691  10.995   1.361  1.00  2.25           C  
ATOM    390  CG1 VAL A 166      -4.115  10.874   0.843  1.00  2.38           C  
ATOM    391  CG2 VAL A 166      -2.557  10.346   2.730  1.00  2.44           C  
ATOM    392  H   VAL A 166      -1.542   8.440   1.225  1.00  1.31           H  
ATOM    393  HA  VAL A 166      -1.965  10.692  -0.629  1.00  1.87           H  
ATOM    394  HB  VAL A 166      -2.456  12.045   1.460  1.00  2.51           H  
ATOM    395 HG11 VAL A 166      -4.394   9.832   0.796  1.00  2.48           H  
ATOM    396 HG12 VAL A 166      -4.177  11.308  -0.144  1.00  2.45           H  
ATOM    397 HG13 VAL A 166      -4.786  11.397   1.508  1.00  2.86           H  
ATOM    398 HG21 VAL A 166      -2.887   9.319   2.675  1.00  2.81           H  
ATOM    399 HG22 VAL A 166      -3.166  10.882   3.443  1.00  2.68           H  
ATOM    400 HG23 VAL A 166      -1.524  10.375   3.043  1.00  2.54           H  
ATOM    401  N   GLN A 167       0.533   9.993   1.250  1.00  1.46           N  
ATOM    402  CA  GLN A 167       1.903  10.352   1.603  1.00  1.62           C  
ATOM    403  C   GLN A 167       2.723   9.111   1.943  1.00  1.42           C  
ATOM    404  O   GLN A 167       2.188   8.117   2.433  1.00  1.30           O  
ATOM    405  CB  GLN A 167       1.909  11.322   2.786  1.00  1.84           C  
ATOM    406  CG  GLN A 167       3.174  12.158   2.880  1.00  2.13           C  
ATOM    407  CD  GLN A 167       3.206  13.030   4.121  1.00  2.30           C  
ATOM    408  OE1 GLN A 167       2.199  13.631   4.498  1.00  2.30           O  
ATOM    409  NE2 GLN A 167       4.366  13.104   4.763  1.00  3.05           N  
ATOM    410  H   GLN A 167       0.215   9.086   1.435  1.00  1.16           H  
ATOM    411  HA  GLN A 167       2.348  10.840   0.749  1.00  1.96           H  
ATOM    412  HB2 GLN A 167       1.066  11.991   2.694  1.00  2.09           H  
ATOM    413  HB3 GLN A 167       1.809  10.756   3.701  1.00  2.04           H  
ATOM    414  HG2 GLN A 167       4.027  11.497   2.902  1.00  2.57           H  
ATOM    415  HG3 GLN A 167       3.235  12.794   2.009  1.00  2.34           H  
ATOM    416 HE21 GLN A 167       5.126  12.599   4.406  1.00  3.49           H  
ATOM    417 HE22 GLN A 167       4.414  13.661   5.569  1.00  3.37           H  
ATOM    418  N   ILE A 168       4.025   9.180   1.680  1.00  1.63           N  
ATOM    419  CA  ILE A 168       4.921   8.063   1.958  1.00  1.73           C  
ATOM    420  C   ILE A 168       5.659   8.268   3.277  1.00  1.97           C  
ATOM    421  O   ILE A 168       5.463   9.273   3.960  1.00  2.41           O  
ATOM    422  CB  ILE A 168       5.953   7.876   0.828  1.00  2.50           C  
ATOM    423  CG1 ILE A 168       6.702   9.184   0.567  1.00  2.81           C  
ATOM    424  CG2 ILE A 168       5.267   7.389  -0.439  1.00  3.17           C  
ATOM    425  CD1 ILE A 168       8.006   8.996  -0.176  1.00  3.72           C  
ATOM    426  H   ILE A 168       4.390  10.001   1.290  1.00  1.84           H  
ATOM    427  HA  ILE A 168       4.325   7.165   2.026  1.00  1.66           H  
ATOM    428  HB  ILE A 168       6.659   7.120   1.139  1.00  3.04           H  
ATOM    429 HG12 ILE A 168       6.077   9.838  -0.023  1.00  3.02           H  
ATOM    430 HG13 ILE A 168       6.922   9.660   1.511  1.00  2.89           H  
ATOM    431 HG21 ILE A 168       6.013   7.148  -1.182  1.00  3.48           H  
ATOM    432 HG22 ILE A 168       4.619   8.166  -0.818  1.00  3.55           H  
ATOM    433 HG23 ILE A 168       4.682   6.509  -0.217  1.00  3.55           H  
ATOM    434 HD11 ILE A 168       8.353   9.950  -0.543  1.00  4.25           H  
ATOM    435 HD12 ILE A 168       7.853   8.324  -1.007  1.00  4.03           H  
ATOM    436 HD13 ILE A 168       8.745   8.578   0.493  1.00  4.05           H  
ATOM    437  N   ASN A 169       6.509   7.307   3.631  1.00  1.98           N  
ATOM    438  CA  ASN A 169       7.276   7.384   4.870  1.00  2.48           C  
ATOM    439  C   ASN A 169       8.458   6.420   4.840  1.00  2.44           C  
ATOM    440  O   ASN A 169       8.557   5.572   3.954  1.00  2.58           O  
ATOM    441  CB  ASN A 169       6.378   7.071   6.069  1.00  3.01           C  
ATOM    442  CG  ASN A 169       6.821   7.792   7.327  1.00  3.88           C  
ATOM    443  OD1 ASN A 169       7.621   7.273   8.106  1.00  4.38           O  
ATOM    444  ND2 ASN A 169       6.301   8.997   7.533  1.00  4.49           N  
ATOM    445  H   ASN A 169       6.623   6.529   3.046  1.00  1.85           H  
ATOM    446  HA  ASN A 169       7.651   8.392   4.966  1.00  3.11           H  
ATOM    447  HB2 ASN A 169       5.366   7.373   5.842  1.00  3.22           H  
ATOM    448  HB3 ASN A 169       6.399   6.008   6.259  1.00  3.18           H  
ATOM    449 HD21 ASN A 169       5.670   9.349   6.872  1.00  4.45           H  
ATOM    450 HD22 ASN A 169       6.571   9.486   8.339  1.00  5.18           H  
ATOM    451  N   GLU A 170       9.351   6.558   5.815  1.00  2.90           N  
ATOM    452  CA  GLU A 170      10.529   5.701   5.904  1.00  3.24           C  
ATOM    453  C   GLU A 170      11.406   5.848   4.664  1.00  2.92           C  
ATOM    454  O   GLU A 170      11.060   5.368   3.585  1.00  3.14           O  
ATOM    455  CB  GLU A 170      10.110   4.239   6.075  1.00  4.18           C  
ATOM    456  CG  GLU A 170       9.446   3.948   7.411  1.00  4.96           C  
ATOM    457  CD  GLU A 170      10.422   3.417   8.443  1.00  5.24           C  
ATOM    458  OE1 GLU A 170      10.898   2.274   8.276  1.00  5.61           O  
ATOM    459  OE2 GLU A 170      10.709   4.143   9.418  1.00  5.45           O  
ATOM    460  H   GLU A 170       9.216   7.253   6.492  1.00  3.32           H  
ATOM    461  HA  GLU A 170      11.097   6.006   6.769  1.00  3.53           H  
ATOM    462  HB2 GLU A 170       9.416   3.980   5.289  1.00  4.33           H  
ATOM    463  HB3 GLU A 170      10.986   3.613   5.989  1.00  4.57           H  
ATOM    464  HG2 GLU A 170       9.011   4.861   7.788  1.00  5.36           H  
ATOM    465  HG3 GLU A 170       8.669   3.214   7.260  1.00  5.30           H  
ATOM    466  N   ILE A 171      12.544   6.517   4.827  1.00  2.99           N  
ATOM    467  CA  ILE A 171      13.472   6.729   3.721  1.00  3.09           C  
ATOM    468  C   ILE A 171      14.917   6.735   4.209  1.00  3.06           C  
ATOM    469  O   ILE A 171      15.645   5.758   4.033  1.00  3.39           O  
ATOM    470  CB  ILE A 171      13.182   8.053   2.985  1.00  3.86           C  
ATOM    471  CG1 ILE A 171      12.425   9.020   3.899  1.00  4.61           C  
ATOM    472  CG2 ILE A 171      12.389   7.790   1.713  1.00  4.26           C  
ATOM    473  CD1 ILE A 171      12.594  10.474   3.512  1.00  5.46           C  
ATOM    474  H   ILE A 171      12.764   6.877   5.711  1.00  3.34           H  
ATOM    475  HA  ILE A 171      13.343   5.916   3.020  1.00  3.13           H  
ATOM    476  HB  ILE A 171      14.125   8.497   2.704  1.00  4.14           H  
ATOM    477 HG12 ILE A 171      11.372   8.789   3.865  1.00  4.98           H  
ATOM    478 HG13 ILE A 171      12.783   8.903   4.912  1.00  4.61           H  
ATOM    479 HG21 ILE A 171      12.253   8.716   1.176  1.00  4.30           H  
ATOM    480 HG22 ILE A 171      11.425   7.377   1.969  1.00  4.62           H  
ATOM    481 HG23 ILE A 171      12.928   7.089   1.092  1.00  4.66           H  
ATOM    482 HD11 ILE A 171      12.106  10.653   2.565  1.00  5.59           H  
ATOM    483 HD12 ILE A 171      13.645  10.704   3.425  1.00  6.01           H  
ATOM    484 HD13 ILE A 171      12.149  11.102   4.270  1.00  5.75           H  
ATOM    485  N   PHE A 172      15.326   7.842   4.823  1.00  3.20           N  
ATOM    486  CA  PHE A 172      16.685   7.976   5.338  1.00  3.66           C  
ATOM    487  C   PHE A 172      17.710   7.834   4.216  1.00  3.40           C  
ATOM    488  O   PHE A 172      18.170   8.830   3.655  1.00  3.92           O  
ATOM    489  CB  PHE A 172      16.949   6.929   6.423  1.00  4.43           C  
ATOM    490  CG  PHE A 172      16.578   7.390   7.804  1.00  5.10           C  
ATOM    491  CD1 PHE A 172      15.248   7.479   8.185  1.00  5.69           C  
ATOM    492  CD2 PHE A 172      17.557   7.735   8.722  1.00  5.46           C  
ATOM    493  CE1 PHE A 172      14.902   7.903   9.454  1.00  6.52           C  
ATOM    494  CE2 PHE A 172      17.218   8.159   9.992  1.00  6.37           C  
ATOM    495  CZ  PHE A 172      15.889   8.243  10.359  1.00  6.85           C  
ATOM    496  H   PHE A 172      14.699   8.586   4.934  1.00  3.33           H  
ATOM    497  HA  PHE A 172      16.779   8.959   5.771  1.00  4.07           H  
ATOM    498  HB2 PHE A 172      16.375   6.042   6.205  1.00  4.70           H  
ATOM    499  HB3 PHE A 172      18.000   6.681   6.427  1.00  4.62           H  
ATOM    500  HD1 PHE A 172      14.475   7.213   7.479  1.00  5.69           H  
ATOM    501  HD2 PHE A 172      18.597   7.670   8.435  1.00  5.23           H  
ATOM    502  HE1 PHE A 172      13.862   7.968   9.738  1.00  7.06           H  
ATOM    503  HE2 PHE A 172      17.992   8.425  10.698  1.00  6.86           H  
ATOM    504  HZ  PHE A 172      15.622   8.574  11.352  1.00  7.63           H  
ATOM    505  N   GLN A 173      18.064   6.594   3.892  1.00  3.03           N  
ATOM    506  CA  GLN A 173      19.034   6.326   2.836  1.00  3.19           C  
ATOM    507  C   GLN A 173      18.990   4.860   2.415  1.00  2.85           C  
ATOM    508  O   GLN A 173      19.883   4.081   2.747  1.00  3.40           O  
ATOM    509  CB  GLN A 173      20.445   6.692   3.303  1.00  3.78           C  
ATOM    510  CG  GLN A 173      20.663   6.507   4.797  1.00  4.50           C  
ATOM    511  CD  GLN A 173      20.544   5.059   5.228  1.00  5.27           C  
ATOM    512  OE1 GLN A 173      19.522   4.643   5.773  1.00  5.57           O  
ATOM    513  NE2 GLN A 173      21.593   4.281   4.987  1.00  5.95           N  
ATOM    514  H   GLN A 173      17.662   5.841   4.374  1.00  2.98           H  
ATOM    515  HA  GLN A 173      18.776   6.940   1.986  1.00  3.60           H  
ATOM    516  HB2 GLN A 173      21.159   6.074   2.778  1.00  3.93           H  
ATOM    517  HB3 GLN A 173      20.634   7.728   3.061  1.00  4.09           H  
ATOM    518  HG2 GLN A 173      21.651   6.862   5.050  1.00  4.55           H  
ATOM    519  HG3 GLN A 173      19.925   7.088   5.330  1.00  4.89           H  
ATOM    520 HE21 GLN A 173      22.375   4.679   4.549  1.00  5.97           H  
ATOM    521 HE22 GLN A 173      21.543   3.339   5.256  1.00  6.58           H  
ATOM    522  N   VAL A 174      17.943   4.492   1.681  1.00  2.39           N  
ATOM    523  CA  VAL A 174      17.782   3.120   1.214  1.00  2.41           C  
ATOM    524  C   VAL A 174      18.002   3.022  -0.292  1.00  2.24           C  
ATOM    525  O   VAL A 174      17.201   3.523  -1.081  1.00  2.67           O  
ATOM    526  CB  VAL A 174      16.384   2.570   1.554  1.00  3.06           C  
ATOM    527  CG1 VAL A 174      16.309   2.168   3.019  1.00  3.87           C  
ATOM    528  CG2 VAL A 174      15.308   3.593   1.219  1.00  3.63           C  
ATOM    529  H   VAL A 174      17.265   5.159   1.448  1.00  2.47           H  
ATOM    530  HA  VAL A 174      18.518   2.509   1.715  1.00  2.75           H  
ATOM    531  HB  VAL A 174      16.210   1.689   0.954  1.00  3.25           H  
ATOM    532 HG11 VAL A 174      16.992   1.353   3.203  1.00  4.23           H  
ATOM    533 HG12 VAL A 174      15.302   1.855   3.256  1.00  4.22           H  
ATOM    534 HG13 VAL A 174      16.579   3.011   3.637  1.00  4.19           H  
ATOM    535 HG21 VAL A 174      15.400   4.442   1.881  1.00  3.88           H  
ATOM    536 HG22 VAL A 174      14.334   3.144   1.342  1.00  3.90           H  
ATOM    537 HG23 VAL A 174      15.428   3.919   0.196  1.00  4.08           H  
ATOM    538  N   GLU A 175      19.095   2.373  -0.684  1.00  2.28           N  
ATOM    539  CA  GLU A 175      19.421   2.207  -2.096  1.00  2.36           C  
ATOM    540  C   GLU A 175      19.407   0.733  -2.488  1.00  2.18           C  
ATOM    541  O   GLU A 175      20.230   0.284  -3.284  1.00  2.69           O  
ATOM    542  CB  GLU A 175      20.794   2.814  -2.397  1.00  3.09           C  
ATOM    543  CG  GLU A 175      20.815   4.332  -2.330  1.00  3.69           C  
ATOM    544  CD  GLU A 175      22.218   4.900  -2.420  1.00  3.89           C  
ATOM    545  OE1 GLU A 175      22.876   4.696  -3.462  1.00  4.25           O  
ATOM    546  OE2 GLU A 175      22.660   5.549  -1.448  1.00  4.09           O  
ATOM    547  H   GLU A 175      19.694   1.996  -0.007  1.00  2.65           H  
ATOM    548  HA  GLU A 175      18.673   2.728  -2.673  1.00  2.63           H  
ATOM    549  HB2 GLU A 175      21.508   2.434  -1.681  1.00  3.38           H  
ATOM    550  HB3 GLU A 175      21.097   2.515  -3.389  1.00  3.50           H  
ATOM    551  HG2 GLU A 175      20.232   4.725  -3.150  1.00  4.07           H  
ATOM    552  HG3 GLU A 175      20.375   4.646  -1.395  1.00  4.05           H  
ATOM    553  N   THR A 176      18.465  -0.015  -1.920  1.00  2.13           N  
ATOM    554  CA  THR A 176      18.343  -1.440  -2.209  1.00  2.32           C  
ATOM    555  C   THR A 176      17.417  -1.676  -3.399  1.00  2.11           C  
ATOM    556  O   THR A 176      17.151  -0.762  -4.181  1.00  2.16           O  
ATOM    557  CB  THR A 176      17.817  -2.185  -0.980  1.00  2.91           C  
ATOM    558  OG1 THR A 176      17.944  -1.387   0.184  1.00  3.35           O  
ATOM    559  CG2 THR A 176      18.535  -3.493  -0.719  1.00  3.49           C  
ATOM    560  H   THR A 176      17.839   0.401  -1.292  1.00  2.43           H  
ATOM    561  HA  THR A 176      19.326  -1.814  -2.453  1.00  2.76           H  
ATOM    562  HB  THR A 176      16.769  -2.407  -1.127  1.00  3.35           H  
ATOM    563  HG1 THR A 176      17.155  -1.482   0.724  1.00  3.69           H  
ATOM    564 HG21 THR A 176      19.432  -3.302  -0.150  1.00  3.70           H  
ATOM    565 HG22 THR A 176      18.797  -3.953  -1.661  1.00  3.82           H  
ATOM    566 HG23 THR A 176      17.888  -4.154  -0.163  1.00  3.91           H  
ATOM    567  N   ASP A 177      16.930  -2.906  -3.530  1.00  2.26           N  
ATOM    568  CA  ASP A 177      16.033  -3.262  -4.626  1.00  2.29           C  
ATOM    569  C   ASP A 177      14.734  -2.466  -4.552  1.00  2.06           C  
ATOM    570  O   ASP A 177      13.991  -2.383  -5.529  1.00  1.92           O  
ATOM    571  CB  ASP A 177      15.729  -4.761  -4.597  1.00  2.83           C  
ATOM    572  CG  ASP A 177      16.945  -5.605  -4.927  1.00  2.93           C  
ATOM    573  OD1 ASP A 177      17.921  -5.569  -4.149  1.00  3.30           O  
ATOM    574  OD2 ASP A 177      16.920  -6.301  -5.963  1.00  3.24           O  
ATOM    575  H   ASP A 177      17.178  -3.592  -2.876  1.00  2.57           H  
ATOM    576  HA  ASP A 177      16.534  -3.024  -5.552  1.00  2.32           H  
ATOM    577  HB2 ASP A 177      15.384  -5.032  -3.610  1.00  2.99           H  
ATOM    578  HB3 ASP A 177      14.955  -4.979  -5.317  1.00  3.00           H  
ATOM    579  N   GLN A 178      14.465  -1.883  -3.386  1.00  2.15           N  
ATOM    580  CA  GLN A 178      13.254  -1.093  -3.185  1.00  2.12           C  
ATOM    581  C   GLN A 178      13.059  -0.092  -4.320  1.00  1.88           C  
ATOM    582  O   GLN A 178      11.931   0.229  -4.692  1.00  1.98           O  
ATOM    583  CB  GLN A 178      13.317  -0.358  -1.846  1.00  2.47           C  
ATOM    584  CG  GLN A 178      13.357  -1.286  -0.643  1.00  3.14           C  
ATOM    585  CD  GLN A 178      14.040  -0.658   0.556  1.00  3.74           C  
ATOM    586  OE1 GLN A 178      15.032  -1.181   1.063  1.00  4.04           O  
ATOM    587  NE2 GLN A 178      13.511   0.471   1.016  1.00  4.40           N  
ATOM    588  H   GLN A 178      15.096  -1.986  -2.643  1.00  2.34           H  
ATOM    589  HA  GLN A 178      12.415  -1.772  -3.173  1.00  2.12           H  
ATOM    590  HB2 GLN A 178      14.204   0.257  -1.828  1.00  2.63           H  
ATOM    591  HB3 GLN A 178      12.448   0.277  -1.755  1.00  2.67           H  
ATOM    592  HG2 GLN A 178      12.344  -1.541  -0.367  1.00  3.25           H  
ATOM    593  HG3 GLN A 178      13.892  -2.184  -0.914  1.00  3.68           H  
ATOM    594 HE21 GLN A 178      12.720   0.829   0.562  1.00  4.53           H  
ATOM    595 HE22 GLN A 178      13.933   0.898   1.790  1.00  4.96           H  
ATOM    596  N   PHE A 179      14.167   0.399  -4.866  1.00  1.73           N  
ATOM    597  CA  PHE A 179      14.119   1.364  -5.959  1.00  1.67           C  
ATOM    598  C   PHE A 179      14.455   0.697  -7.289  1.00  1.57           C  
ATOM    599  O   PHE A 179      15.268   1.204  -8.062  1.00  1.70           O  
ATOM    600  CB  PHE A 179      15.090   2.517  -5.691  1.00  1.80           C  
ATOM    601  CG  PHE A 179      14.513   3.871  -5.996  1.00  2.18           C  
ATOM    602  CD1 PHE A 179      13.628   4.475  -5.117  1.00  2.59           C  
ATOM    603  CD2 PHE A 179      14.856   4.538  -7.160  1.00  2.48           C  
ATOM    604  CE1 PHE A 179      13.096   5.720  -5.394  1.00  3.25           C  
ATOM    605  CE2 PHE A 179      14.328   5.784  -7.443  1.00  3.12           C  
ATOM    606  CZ  PHE A 179      13.447   6.376  -6.558  1.00  3.49           C  
ATOM    607  H   PHE A 179      15.039   0.106  -4.527  1.00  1.79           H  
ATOM    608  HA  PHE A 179      13.114   1.757  -6.010  1.00  1.74           H  
ATOM    609  HB2 PHE A 179      15.373   2.505  -4.650  1.00  2.14           H  
ATOM    610  HB3 PHE A 179      15.971   2.386  -6.301  1.00  1.63           H  
ATOM    611  HD1 PHE A 179      13.355   3.964  -4.206  1.00  2.56           H  
ATOM    612  HD2 PHE A 179      15.545   4.076  -7.853  1.00  2.41           H  
ATOM    613  HE1 PHE A 179      12.407   6.180  -4.701  1.00  3.68           H  
ATOM    614  HE2 PHE A 179      14.603   6.294  -8.354  1.00  3.46           H  
ATOM    615  HZ  PHE A 179      13.032   7.348  -6.778  1.00  4.09           H  
ATOM    616  N   THR A 180      13.823  -0.443  -7.550  1.00  1.47           N  
ATOM    617  CA  THR A 180      14.054  -1.182  -8.786  1.00  1.53           C  
ATOM    618  C   THR A 180      12.735  -1.540  -9.462  1.00  1.45           C  
ATOM    619  O   THR A 180      12.465  -1.109 -10.583  1.00  1.46           O  
ATOM    620  CB  THR A 180      14.857  -2.452  -8.502  1.00  1.72           C  
ATOM    621  OG1 THR A 180      15.967  -2.168  -7.669  1.00  2.16           O  
ATOM    622  CG2 THR A 180      15.383  -3.121  -9.755  1.00  2.16           C  
ATOM    623  H   THR A 180      13.185  -0.797  -6.893  1.00  1.44           H  
ATOM    624  HA  THR A 180      14.623  -0.547  -9.448  1.00  1.64           H  
ATOM    625  HB  THR A 180      14.222  -3.161  -7.991  1.00  2.18           H  
ATOM    626  HG1 THR A 180      16.524  -1.509  -8.090  1.00  2.46           H  
ATOM    627 HG21 THR A 180      14.560  -3.563 -10.298  1.00  2.53           H  
ATOM    628 HG22 THR A 180      16.090  -3.891  -9.482  1.00  2.69           H  
ATOM    629 HG23 THR A 180      15.871  -2.386 -10.377  1.00  2.45           H  
ATOM    630  N   GLN A 181      11.917  -2.330  -8.775  1.00  1.44           N  
ATOM    631  CA  GLN A 181      10.626  -2.748  -9.311  1.00  1.41           C  
ATOM    632  C   GLN A 181       9.640  -1.584  -9.327  1.00  1.29           C  
ATOM    633  O   GLN A 181       8.781  -1.497 -10.204  1.00  1.26           O  
ATOM    634  CB  GLN A 181      10.055  -3.902  -8.486  1.00  1.54           C  
ATOM    635  CG  GLN A 181      10.993  -5.094  -8.377  1.00  1.77           C  
ATOM    636  CD  GLN A 181      10.290  -6.346  -7.892  1.00  1.91           C  
ATOM    637  OE1 GLN A 181      10.207  -6.599  -6.690  1.00  2.41           O  
ATOM    638  NE2 GLN A 181       9.780  -7.139  -8.827  1.00  2.44           N  
ATOM    639  H   GLN A 181      12.189  -2.642  -7.886  1.00  1.51           H  
ATOM    640  HA  GLN A 181      10.782  -3.084 -10.325  1.00  1.46           H  
ATOM    641  HB2 GLN A 181       9.842  -3.547  -7.489  1.00  1.64           H  
ATOM    642  HB3 GLN A 181       9.136  -4.237  -8.944  1.00  1.70           H  
ATOM    643  HG2 GLN A 181      11.417  -5.292  -9.351  1.00  2.39           H  
ATOM    644  HG3 GLN A 181      11.784  -4.850  -7.684  1.00  2.13           H  
ATOM    645 HE21 GLN A 181       9.884  -6.876  -9.766  1.00  2.71           H  
ATOM    646 HE22 GLN A 181       9.319  -7.957  -8.541  1.00  2.94           H  
ATOM    647  N   LEU A 182       9.769  -0.689  -8.350  1.00  1.32           N  
ATOM    648  CA  LEU A 182       8.888   0.469  -8.254  1.00  1.33           C  
ATOM    649  C   LEU A 182       9.175   1.470  -9.370  1.00  1.38           C  
ATOM    650  O   LEU A 182       8.336   2.308  -9.696  1.00  1.48           O  
ATOM    651  CB  LEU A 182       9.047   1.149  -6.892  1.00  1.48           C  
ATOM    652  CG  LEU A 182       9.086   0.199  -5.692  1.00  1.79           C  
ATOM    653  CD1 LEU A 182       9.192   0.984  -4.394  1.00  2.43           C  
ATOM    654  CD2 LEU A 182       7.854  -0.695  -5.680  1.00  1.91           C  
ATOM    655  H   LEU A 182      10.473  -0.812  -7.680  1.00  1.41           H  
ATOM    656  HA  LEU A 182       7.870   0.120  -8.355  1.00  1.30           H  
ATOM    657  HB2 LEU A 182       9.964   1.719  -6.904  1.00  1.99           H  
ATOM    658  HB3 LEU A 182       8.221   1.829  -6.755  1.00  1.42           H  
ATOM    659  HG  LEU A 182       9.959  -0.433  -5.771  1.00  2.14           H  
ATOM    660 HD11 LEU A 182       9.329   0.300  -3.570  1.00  2.56           H  
ATOM    661 HD12 LEU A 182       8.286   1.552  -4.243  1.00  2.87           H  
ATOM    662 HD13 LEU A 182      10.034   1.657  -4.447  1.00  2.92           H  
ATOM    663 HD21 LEU A 182       7.896  -1.376  -6.516  1.00  2.37           H  
ATOM    664 HD22 LEU A 182       6.967  -0.085  -5.755  1.00  2.19           H  
ATOM    665 HD23 LEU A 182       7.828  -1.256  -4.758  1.00  2.20           H  
ATOM    666  N   LEU A 183      10.367   1.375  -9.952  1.00  1.42           N  
ATOM    667  CA  LEU A 183      10.764   2.273 -11.032  1.00  1.53           C  
ATOM    668  C   LEU A 183       9.801   2.166 -12.211  1.00  1.48           C  
ATOM    669  O   LEU A 183       9.230   3.165 -12.649  1.00  1.55           O  
ATOM    670  CB  LEU A 183      12.189   1.955 -11.492  1.00  1.74           C  
ATOM    671  CG  LEU A 183      13.289   2.317 -10.493  1.00  1.93           C  
ATOM    672  CD1 LEU A 183      14.636   1.800 -10.973  1.00  2.27           C  
ATOM    673  CD2 LEU A 183      13.338   3.823 -10.280  1.00  2.15           C  
ATOM    674  H   LEU A 183      10.995   0.685  -9.650  1.00  1.44           H  
ATOM    675  HA  LEU A 183      10.736   3.282 -10.650  1.00  1.62           H  
ATOM    676  HB2 LEU A 183      12.250   0.895 -11.696  1.00  1.76           H  
ATOM    677  HB3 LEU A 183      12.376   2.491 -12.410  1.00  1.84           H  
ATOM    678  HG  LEU A 183      13.071   1.850  -9.544  1.00  1.80           H  
ATOM    679 HD11 LEU A 183      14.889   2.271 -11.911  1.00  2.52           H  
ATOM    680 HD12 LEU A 183      14.583   0.731 -11.110  1.00  2.64           H  
ATOM    681 HD13 LEU A 183      15.393   2.032 -10.238  1.00  2.54           H  
ATOM    682 HD21 LEU A 183      13.391   4.320 -11.237  1.00  2.52           H  
ATOM    683 HD22 LEU A 183      14.211   4.075  -9.695  1.00  2.52           H  
ATOM    684 HD23 LEU A 183      12.450   4.141  -9.755  1.00  2.19           H  
ATOM    685  N   ASP A 184       9.627   0.951 -12.718  1.00  1.47           N  
ATOM    686  CA  ASP A 184       8.732   0.715 -13.846  1.00  1.55           C  
ATOM    687  C   ASP A 184       7.280   0.955 -13.446  1.00  1.48           C  
ATOM    688  O   ASP A 184       6.500   1.519 -14.215  1.00  1.85           O  
ATOM    689  CB  ASP A 184       8.900  -0.714 -14.367  1.00  1.74           C  
ATOM    690  CG  ASP A 184      10.245  -0.934 -15.029  1.00  1.99           C  
ATOM    691  OD1 ASP A 184      11.245  -1.108 -14.302  1.00  2.35           O  
ATOM    692  OD2 ASP A 184      10.299  -0.933 -16.278  1.00  2.40           O  
ATOM    693  H   ASP A 184      10.110   0.194 -12.325  1.00  1.49           H  
ATOM    694  HA  ASP A 184       8.997   1.407 -14.630  1.00  1.62           H  
ATOM    695  HB2 ASP A 184       8.810  -1.404 -13.541  1.00  1.80           H  
ATOM    696  HB3 ASP A 184       8.124  -0.922 -15.089  1.00  1.94           H  
ATOM    697  N   ALA A 185       6.923   0.525 -12.241  1.00  1.24           N  
ATOM    698  CA  ALA A 185       5.565   0.694 -11.738  1.00  1.20           C  
ATOM    699  C   ALA A 185       5.334   2.123 -11.254  1.00  1.23           C  
ATOM    700  O   ALA A 185       5.692   2.472 -10.130  1.00  1.26           O  
ATOM    701  CB  ALA A 185       5.291  -0.296 -10.617  1.00  1.20           C  
ATOM    702  H   ALA A 185       7.591   0.084 -11.674  1.00  1.29           H  
ATOM    703  HA  ALA A 185       4.881   0.485 -12.548  1.00  1.25           H  
ATOM    704  HB1 ALA A 185       5.434  -1.302 -10.981  1.00  1.43           H  
ATOM    705  HB2 ALA A 185       4.272  -0.179 -10.275  1.00  1.29           H  
ATOM    706  HB3 ALA A 185       5.969  -0.109  -9.798  1.00  1.95           H  
ATOM    707  N   ASP A 186       4.732   2.942 -12.110  1.00  1.34           N  
ATOM    708  CA  ASP A 186       4.452   4.332 -11.769  1.00  1.47           C  
ATOM    709  C   ASP A 186       3.356   4.421 -10.712  1.00  1.48           C  
ATOM    710  O   ASP A 186       2.245   4.875 -10.990  1.00  1.64           O  
ATOM    711  CB  ASP A 186       4.038   5.112 -13.018  1.00  1.66           C  
ATOM    712  CG  ASP A 186       5.197   5.337 -13.970  1.00  1.75           C  
ATOM    713  OD1 ASP A 186       6.191   5.968 -13.557  1.00  1.82           O  
ATOM    714  OD2 ASP A 186       5.109   4.881 -15.130  1.00  2.43           O  
ATOM    715  H   ASP A 186       4.469   2.605 -12.992  1.00  1.39           H  
ATOM    716  HA  ASP A 186       5.356   4.764 -11.369  1.00  1.48           H  
ATOM    717  HB2 ASP A 186       3.269   4.563 -13.540  1.00  1.76           H  
ATOM    718  HB3 ASP A 186       3.647   6.075 -12.721  1.00  1.63           H  
ATOM    719  N   ILE A 187       3.675   3.982  -9.499  1.00  1.35           N  
ATOM    720  CA  ILE A 187       2.719   4.008  -8.399  1.00  1.38           C  
ATOM    721  C   ILE A 187       3.114   5.045  -7.352  1.00  1.50           C  
ATOM    722  O   ILE A 187       3.931   4.774  -6.471  1.00  2.13           O  
ATOM    723  CB  ILE A 187       2.599   2.627  -7.726  1.00  1.37           C  
ATOM    724  CG1 ILE A 187       1.508   2.648  -6.653  1.00  1.47           C  
ATOM    725  CG2 ILE A 187       3.933   2.207  -7.125  1.00  1.61           C  
ATOM    726  CD1 ILE A 187       1.142   1.275  -6.134  1.00  1.71           C  
ATOM    727  H   ILE A 187       4.576   3.630  -9.339  1.00  1.28           H  
ATOM    728  HA  ILE A 187       1.753   4.273  -8.804  1.00  1.40           H  
ATOM    729  HB  ILE A 187       2.333   1.905  -8.483  1.00  1.45           H  
ATOM    730 HG12 ILE A 187       1.848   3.239  -5.815  1.00  1.66           H  
ATOM    731 HG13 ILE A 187       0.615   3.096  -7.066  1.00  1.47           H  
ATOM    732 HG21 ILE A 187       4.735   2.712  -7.643  1.00  2.01           H  
ATOM    733 HG22 ILE A 187       4.055   1.140  -7.228  1.00  2.00           H  
ATOM    734 HG23 ILE A 187       3.957   2.474  -6.079  1.00  1.88           H  
ATOM    735 HD11 ILE A 187       0.911   1.338  -5.080  1.00  1.85           H  
ATOM    736 HD12 ILE A 187       1.973   0.601  -6.280  1.00  2.08           H  
ATOM    737 HD13 ILE A 187       0.281   0.905  -6.669  1.00  2.14           H  
ATOM    738  N   ARG A 188       2.529   6.234  -7.453  1.00  1.20           N  
ATOM    739  CA  ARG A 188       2.819   7.313  -6.516  1.00  1.26           C  
ATOM    740  C   ARG A 188       1.625   7.576  -5.604  1.00  1.32           C  
ATOM    741  O   ARG A 188       0.565   6.969  -5.762  1.00  1.65           O  
ATOM    742  CB  ARG A 188       3.189   8.590  -7.273  1.00  1.24           C  
ATOM    743  CG  ARG A 188       4.605   8.582  -7.823  1.00  1.76           C  
ATOM    744  CD  ARG A 188       5.026   9.963  -8.299  1.00  1.81           C  
ATOM    745  NE  ARG A 188       6.434  10.233  -8.019  1.00  2.14           N  
ATOM    746  CZ  ARG A 188       7.090  11.291  -8.488  1.00  2.47           C  
ATOM    747  NH1 ARG A 188       6.467  12.173  -9.258  1.00  2.99           N  
ATOM    748  NH2 ARG A 188       8.371  11.466  -8.188  1.00  2.79           N  
ATOM    749  H   ARG A 188       1.886   6.390  -8.177  1.00  1.29           H  
ATOM    750  HA  ARG A 188       3.659   7.008  -5.910  1.00  1.43           H  
ATOM    751  HB2 ARG A 188       2.505   8.714  -8.100  1.00  1.46           H  
ATOM    752  HB3 ARG A 188       3.089   9.433  -6.604  1.00  1.58           H  
ATOM    753  HG2 ARG A 188       5.281   8.260  -7.045  1.00  2.30           H  
ATOM    754  HG3 ARG A 188       4.655   7.894  -8.653  1.00  2.20           H  
ATOM    755  HD2 ARG A 188       4.863  10.028  -9.364  1.00  1.86           H  
ATOM    756  HD3 ARG A 188       4.421  10.703  -7.796  1.00  2.20           H  
ATOM    757  HE  ARG A 188       6.915   9.594  -7.453  1.00  2.57           H  
ATOM    758 HH11 ARG A 188       5.503  12.045  -9.486  1.00  3.17           H  
ATOM    759 HH12 ARG A 188       6.964  12.968  -9.608  1.00  3.44           H  
ATOM    760 HH21 ARG A 188       8.843  10.802  -7.609  1.00  2.84           H  
ATOM    761 HH22 ARG A 188       8.863  12.260  -8.542  1.00  3.26           H  
ATOM    762  N   VAL A 189       1.803   8.485  -4.650  1.00  1.27           N  
ATOM    763  CA  VAL A 189       0.740   8.828  -3.712  1.00  1.39           C  
ATOM    764  C   VAL A 189      -0.416   9.523  -4.423  1.00  1.68           C  
ATOM    765  O   VAL A 189      -0.231  10.554  -5.070  1.00  2.11           O  
ATOM    766  CB  VAL A 189       1.258   9.739  -2.583  1.00  1.43           C  
ATOM    767  CG1 VAL A 189       2.346   9.036  -1.786  1.00  1.54           C  
ATOM    768  CG2 VAL A 189       1.767  11.056  -3.148  1.00  1.61           C  
ATOM    769  H   VAL A 189       2.670   8.935  -4.575  1.00  1.35           H  
ATOM    770  HA  VAL A 189       0.378   7.911  -3.270  1.00  1.53           H  
ATOM    771  HB  VAL A 189       0.436   9.952  -1.915  1.00  1.48           H  
ATOM    772 HG11 VAL A 189       2.437   9.498  -0.814  1.00  1.87           H  
ATOM    773 HG12 VAL A 189       3.286   9.116  -2.312  1.00  1.93           H  
ATOM    774 HG13 VAL A 189       2.089   7.994  -1.667  1.00  1.84           H  
ATOM    775 HG21 VAL A 189       0.930  11.692  -3.392  1.00  1.98           H  
ATOM    776 HG22 VAL A 189       2.347  10.866  -4.039  1.00  1.70           H  
ATOM    777 HG23 VAL A 189       2.390  11.547  -2.414  1.00  2.13           H  
ATOM    778  N   GLY A 190      -1.610   8.952  -4.300  1.00  2.12           N  
ATOM    779  CA  GLY A 190      -2.780   9.530  -4.935  1.00  2.55           C  
ATOM    780  C   GLY A 190      -3.794   8.480  -5.348  1.00  1.98           C  
ATOM    781  O   GLY A 190      -4.994   8.652  -5.138  1.00  2.29           O  
ATOM    782  H   GLY A 190      -1.697   8.130  -3.771  1.00  2.49           H  
ATOM    783  HA2 GLY A 190      -3.249  10.216  -4.246  1.00  3.02           H  
ATOM    784  HA3 GLY A 190      -2.466  10.076  -5.813  1.00  3.04           H  
ATOM    785  N   SER A 191      -3.309   7.391  -5.936  1.00  1.32           N  
ATOM    786  CA  SER A 191      -4.181   6.310  -6.379  1.00  1.13           C  
ATOM    787  C   SER A 191      -4.316   5.242  -5.299  1.00  0.88           C  
ATOM    788  O   SER A 191      -3.452   5.110  -4.432  1.00  0.99           O  
ATOM    789  CB  SER A 191      -3.639   5.683  -7.666  1.00  1.29           C  
ATOM    790  OG  SER A 191      -3.522   6.652  -8.694  1.00  1.81           O  
ATOM    791  H   SER A 191      -2.342   7.313  -6.076  1.00  1.25           H  
ATOM    792  HA  SER A 191      -5.156   6.730  -6.578  1.00  1.51           H  
ATOM    793  HB2 SER A 191      -2.663   5.260  -7.475  1.00  1.52           H  
ATOM    794  HB3 SER A 191      -4.311   4.905  -7.997  1.00  1.64           H  
ATOM    795  HG  SER A 191      -2.885   6.350  -9.348  1.00  2.14           H  
ATOM    796  N   GLU A 192      -5.405   4.482  -5.357  1.00  0.84           N  
ATOM    797  CA  GLU A 192      -5.655   3.425  -4.384  1.00  0.74           C  
ATOM    798  C   GLU A 192      -5.414   2.051  -4.998  1.00  0.74           C  
ATOM    799  O   GLU A 192      -5.544   1.869  -6.210  1.00  0.99           O  
ATOM    800  CB  GLU A 192      -7.088   3.517  -3.857  1.00  0.91           C  
ATOM    801  CG  GLU A 192      -8.143   3.494  -4.952  1.00  1.71           C  
ATOM    802  CD  GLU A 192      -8.556   4.884  -5.394  1.00  1.93           C  
ATOM    803  OE1 GLU A 192      -9.263   5.566  -4.623  1.00  2.33           O  
ATOM    804  OE2 GLU A 192      -8.171   5.291  -6.510  1.00  2.37           O  
ATOM    805  H   GLU A 192      -6.057   4.636  -6.072  1.00  1.06           H  
ATOM    806  HA  GLU A 192      -4.969   3.564  -3.561  1.00  0.80           H  
ATOM    807  HB2 GLU A 192      -7.270   2.682  -3.195  1.00  1.24           H  
ATOM    808  HB3 GLU A 192      -7.198   4.436  -3.301  1.00  1.45           H  
ATOM    809  HG2 GLU A 192      -7.745   2.964  -5.806  1.00  2.32           H  
ATOM    810  HG3 GLU A 192      -9.015   2.974  -4.583  1.00  2.34           H  
ATOM    811  N   VAL A 193      -5.061   1.085  -4.155  1.00  0.71           N  
ATOM    812  CA  VAL A 193      -4.802  -0.276  -4.614  1.00  0.76           C  
ATOM    813  C   VAL A 193      -5.031  -1.286  -3.495  1.00  0.70           C  
ATOM    814  O   VAL A 193      -5.022  -0.934  -2.316  1.00  0.74           O  
ATOM    815  CB  VAL A 193      -3.362  -0.427  -5.139  1.00  0.93           C  
ATOM    816  CG1 VAL A 193      -3.239   0.153  -6.541  1.00  1.00           C  
ATOM    817  CG2 VAL A 193      -2.374   0.238  -4.191  1.00  1.03           C  
ATOM    818  H   VAL A 193      -4.975   1.291  -3.201  1.00  0.85           H  
ATOM    819  HA  VAL A 193      -5.483  -0.489  -5.425  1.00  0.78           H  
ATOM    820  HB  VAL A 193      -3.127  -1.480  -5.188  1.00  1.01           H  
ATOM    821 HG11 VAL A 193      -4.043  -0.223  -7.157  1.00  1.58           H  
ATOM    822 HG12 VAL A 193      -2.291  -0.137  -6.969  1.00  1.35           H  
ATOM    823 HG13 VAL A 193      -3.298   1.230  -6.490  1.00  1.35           H  
ATOM    824 HG21 VAL A 193      -2.587  -0.067  -3.178  1.00  1.26           H  
ATOM    825 HG22 VAL A 193      -2.465   1.311  -4.271  1.00  1.63           H  
ATOM    826 HG23 VAL A 193      -1.369  -0.059  -4.453  1.00  1.48           H  
ATOM    827  N   GLU A 194      -5.237  -2.544  -3.874  1.00  0.69           N  
ATOM    828  CA  GLU A 194      -5.468  -3.607  -2.902  1.00  0.70           C  
ATOM    829  C   GLU A 194      -4.155  -4.270  -2.498  1.00  0.66           C  
ATOM    830  O   GLU A 194      -3.392  -4.727  -3.349  1.00  0.77           O  
ATOM    831  CB  GLU A 194      -6.424  -4.654  -3.478  1.00  0.79           C  
ATOM    832  CG  GLU A 194      -7.824  -4.122  -3.739  1.00  1.44           C  
ATOM    833  CD  GLU A 194      -8.720  -5.143  -4.409  1.00  1.48           C  
ATOM    834  OE1 GLU A 194      -8.981  -6.199  -3.793  1.00  1.63           O  
ATOM    835  OE2 GLU A 194      -9.161  -4.890  -5.549  1.00  2.03           O  
ATOM    836  H   GLU A 194      -5.232  -2.762  -4.829  1.00  0.71           H  
ATOM    837  HA  GLU A 194      -5.919  -3.164  -2.027  1.00  0.74           H  
ATOM    838  HB2 GLU A 194      -6.021  -5.018  -4.411  1.00  1.39           H  
ATOM    839  HB3 GLU A 194      -6.499  -5.477  -2.783  1.00  1.22           H  
ATOM    840  HG2 GLU A 194      -8.268  -3.838  -2.797  1.00  1.99           H  
ATOM    841  HG3 GLU A 194      -7.751  -3.253  -4.377  1.00  2.10           H  
ATOM    842  N   ILE A 195      -3.898  -4.316  -1.194  1.00  0.81           N  
ATOM    843  CA  ILE A 195      -2.676  -4.922  -0.677  1.00  0.81           C  
ATOM    844  C   ILE A 195      -2.853  -6.421  -0.463  1.00  0.83           C  
ATOM    845  O   ILE A 195      -3.975  -6.912  -0.335  1.00  0.97           O  
ATOM    846  CB  ILE A 195      -2.243  -4.274   0.653  1.00  1.06           C  
ATOM    847  CG1 ILE A 195      -2.571  -2.780   0.654  1.00  0.93           C  
ATOM    848  CG2 ILE A 195      -0.757  -4.497   0.891  1.00  1.49           C  
ATOM    849  CD1 ILE A 195      -3.820  -2.433   1.435  1.00  1.44           C  
ATOM    850  H   ILE A 195      -4.545  -3.934  -0.565  1.00  1.07           H  
ATOM    851  HA  ILE A 195      -1.892  -4.762  -1.403  1.00  0.74           H  
ATOM    852  HB  ILE A 195      -2.784  -4.755   1.454  1.00  1.38           H  
ATOM    853 HG12 ILE A 195      -1.746  -2.236   1.091  1.00  1.32           H  
ATOM    854 HG13 ILE A 195      -2.713  -2.448  -0.365  1.00  1.10           H  
ATOM    855 HG21 ILE A 195      -0.210  -4.261  -0.010  1.00  1.94           H  
ATOM    856 HG22 ILE A 195      -0.585  -5.529   1.158  1.00  2.01           H  
ATOM    857 HG23 ILE A 195      -0.421  -3.856   1.694  1.00  1.72           H  
ATOM    858 HD11 ILE A 195      -4.611  -2.168   0.750  1.00  1.70           H  
ATOM    859 HD12 ILE A 195      -3.615  -1.600   2.090  1.00  1.86           H  
ATOM    860 HD13 ILE A 195      -4.124  -3.287   2.024  1.00  2.04           H  
ATOM    861  N   VAL A 196      -1.738  -7.144  -0.427  1.00  0.80           N  
ATOM    862  CA  VAL A 196      -1.768  -8.589  -0.229  1.00  0.94           C  
ATOM    863  C   VAL A 196      -0.830  -9.004   0.900  1.00  1.04           C  
ATOM    864  O   VAL A 196       0.355  -9.252   0.677  1.00  1.39           O  
ATOM    865  CB  VAL A 196      -1.373  -9.342  -1.514  1.00  1.00           C  
ATOM    866  CG1 VAL A 196      -1.652 -10.830  -1.369  1.00  1.21           C  
ATOM    867  CG2 VAL A 196      -2.110  -8.769  -2.716  1.00  1.93           C  
ATOM    868  H   VAL A 196      -0.874  -6.695  -0.536  1.00  0.75           H  
ATOM    869  HA  VAL A 196      -2.778  -8.869   0.033  1.00  1.17           H  
ATOM    870  HB  VAL A 196      -0.313  -9.210  -1.672  1.00  1.44           H  
ATOM    871 HG11 VAL A 196      -1.385 -11.337  -2.284  1.00  1.75           H  
ATOM    872 HG12 VAL A 196      -2.702 -10.982  -1.166  1.00  1.71           H  
ATOM    873 HG13 VAL A 196      -1.066 -11.228  -0.553  1.00  1.67           H  
ATOM    874 HG21 VAL A 196      -1.886  -9.362  -3.590  1.00  2.49           H  
ATOM    875 HG22 VAL A 196      -1.793  -7.750  -2.880  1.00  2.24           H  
ATOM    876 HG23 VAL A 196      -3.173  -8.790  -2.530  1.00  2.40           H  
ATOM    877  N   ASP A 197      -1.369  -9.079   2.113  1.00  1.16           N  
ATOM    878  CA  ASP A 197      -0.580  -9.464   3.277  1.00  1.28           C  
ATOM    879  C   ASP A 197      -0.202 -10.940   3.216  1.00  1.27           C  
ATOM    880  O   ASP A 197      -0.996 -11.810   3.573  1.00  1.71           O  
ATOM    881  CB  ASP A 197      -1.357  -9.178   4.564  1.00  1.80           C  
ATOM    882  CG  ASP A 197      -0.465  -9.174   5.790  1.00  1.92           C  
ATOM    883  OD1 ASP A 197       0.351  -8.238   5.928  1.00  2.52           O  
ATOM    884  OD2 ASP A 197      -0.583 -10.106   6.613  1.00  2.35           O  
ATOM    885  H   ASP A 197      -2.319  -8.868   2.228  1.00  1.40           H  
ATOM    886  HA  ASP A 197       0.324  -8.873   3.275  1.00  1.48           H  
ATOM    887  HB2 ASP A 197      -1.830  -8.211   4.484  1.00  2.01           H  
ATOM    888  HB3 ASP A 197      -2.115  -9.935   4.695  1.00  2.08           H  
ATOM    889  N   ARG A 198       1.017 -11.216   2.761  1.00  1.21           N  
ATOM    890  CA  ARG A 198       1.502 -12.587   2.653  1.00  1.60           C  
ATOM    891  C   ARG A 198       2.373 -12.951   3.850  1.00  1.52           C  
ATOM    892  O   ARG A 198       2.995 -12.084   4.463  1.00  1.63           O  
ATOM    893  CB  ARG A 198       2.292 -12.770   1.356  1.00  2.17           C  
ATOM    894  CG  ARG A 198       2.471 -14.225   0.953  1.00  2.74           C  
ATOM    895  CD  ARG A 198       3.149 -14.348  -0.402  1.00  3.44           C  
ATOM    896  NE  ARG A 198       3.029 -15.696  -0.953  1.00  4.13           N  
ATOM    897  CZ  ARG A 198       1.901 -16.189  -1.455  1.00  4.78           C  
ATOM    898  NH1 ARG A 198       0.800 -15.449  -1.476  1.00  5.28           N  
ATOM    899  NH2 ARG A 198       1.873 -17.424  -1.937  1.00  5.17           N  
ATOM    900  H   ARG A 198       1.604 -10.479   2.493  1.00  1.21           H  
ATOM    901  HA  ARG A 198       0.643 -13.242   2.636  1.00  1.85           H  
ATOM    902  HB2 ARG A 198       1.775 -12.259   0.557  1.00  2.54           H  
ATOM    903  HB3 ARG A 198       3.270 -12.330   1.479  1.00  2.43           H  
ATOM    904  HG2 ARG A 198       3.079 -14.721   1.694  1.00  2.91           H  
ATOM    905  HG3 ARG A 198       1.501 -14.697   0.905  1.00  3.13           H  
ATOM    906  HD2 ARG A 198       2.690 -13.648  -1.084  1.00  3.55           H  
ATOM    907  HD3 ARG A 198       4.196 -14.107  -0.290  1.00  3.75           H  
ATOM    908  HE  ARG A 198       3.829 -16.260  -0.948  1.00  4.33           H  
ATOM    909 HH11 ARG A 198       0.817 -14.517  -1.114  1.00  5.15           H  
ATOM    910 HH12 ARG A 198      -0.046 -15.823  -1.855  1.00  5.91           H  
ATOM    911 HH21 ARG A 198       2.700 -17.985  -1.923  1.00  5.02           H  
ATOM    912 HH22 ARG A 198       1.024 -17.795  -2.315  1.00  5.74           H  
ATOM    913  N   ASP A 199       2.414 -14.239   4.176  1.00  1.54           N  
ATOM    914  CA  ASP A 199       3.210 -14.718   5.300  1.00  1.51           C  
ATOM    915  C   ASP A 199       4.701 -14.570   5.013  1.00  1.55           C  
ATOM    916  O   ASP A 199       5.369 -15.529   4.627  1.00  2.34           O  
ATOM    917  CB  ASP A 199       2.880 -16.182   5.600  1.00  1.63           C  
ATOM    918  CG  ASP A 199       1.473 -16.359   6.134  1.00  1.68           C  
ATOM    919  OD1 ASP A 199       1.266 -16.146   7.347  1.00  2.48           O  
ATOM    920  OD2 ASP A 199       0.576 -16.710   5.339  1.00  1.84           O  
ATOM    921  H   ASP A 199       1.896 -14.882   3.648  1.00  1.69           H  
ATOM    922  HA  ASP A 199       2.961 -14.119   6.163  1.00  1.83           H  
ATOM    923  HB2 ASP A 199       2.975 -16.760   4.692  1.00  1.78           H  
ATOM    924  HB3 ASP A 199       3.575 -16.559   6.336  1.00  1.86           H  
ATOM    925  N   GLY A 200       5.217 -13.359   5.204  1.00  1.31           N  
ATOM    926  CA  GLY A 200       6.626 -13.105   4.961  1.00  1.53           C  
ATOM    927  C   GLY A 200       6.857 -11.839   4.160  1.00  1.30           C  
ATOM    928  O   GLY A 200       7.868 -11.158   4.342  1.00  1.69           O  
ATOM    929  H   GLY A 200       4.636 -12.632   5.512  1.00  1.54           H  
ATOM    930  HA2 GLY A 200       7.133 -13.017   5.910  1.00  2.07           H  
ATOM    931  HA3 GLY A 200       7.043 -13.941   4.419  1.00  1.76           H  
ATOM    932  N   HIS A 201       5.920 -11.520   3.273  1.00  1.04           N  
ATOM    933  CA  HIS A 201       6.028 -10.327   2.442  1.00  1.15           C  
ATOM    934  C   HIS A 201       4.657  -9.700   2.208  1.00  0.99           C  
ATOM    935  O   HIS A 201       3.635 -10.242   2.630  1.00  0.96           O  
ATOM    936  CB  HIS A 201       6.679 -10.670   1.101  1.00  1.60           C  
ATOM    937  CG  HIS A 201       8.091 -11.151   1.227  1.00  1.96           C  
ATOM    938  ND1 HIS A 201       9.185 -10.339   1.012  1.00  2.18           N  
ATOM    939  CD2 HIS A 201       8.587 -12.370   1.549  1.00  2.72           C  
ATOM    940  CE1 HIS A 201      10.292 -11.037   1.194  1.00  2.56           C  
ATOM    941  NE2 HIS A 201       9.958 -12.271   1.521  1.00  2.90           N  
ATOM    942  H   HIS A 201       5.138 -12.102   3.174  1.00  1.14           H  
ATOM    943  HA  HIS A 201       6.651  -9.615   2.962  1.00  1.34           H  
ATOM    944  HB2 HIS A 201       6.106 -11.448   0.619  1.00  1.75           H  
ATOM    945  HB3 HIS A 201       6.681  -9.791   0.474  1.00  1.91           H  
ATOM    946  HD1 HIS A 201       9.154  -9.392   0.762  1.00  2.48           H  
ATOM    947  HD2 HIS A 201       8.013 -13.254   1.782  1.00  3.38           H  
ATOM    948  HE1 HIS A 201      11.299 -10.661   1.095  1.00  2.93           H  
ATOM    949  HE2 HIS A 201      10.584 -12.973   1.795  1.00  3.48           H  
ATOM    950  N   ILE A 202       4.642  -8.555   1.533  1.00  1.00           N  
ATOM    951  CA  ILE A 202       3.397  -7.854   1.242  1.00  0.92           C  
ATOM    952  C   ILE A 202       3.369  -7.362  -0.201  1.00  0.92           C  
ATOM    953  O   ILE A 202       4.044  -6.394  -0.551  1.00  1.22           O  
ATOM    954  CB  ILE A 202       3.191  -6.652   2.186  1.00  1.01           C  
ATOM    955  CG1 ILE A 202       4.513  -5.912   2.407  1.00  1.22           C  
ATOM    956  CG2 ILE A 202       2.605  -7.115   3.512  1.00  1.11           C  
ATOM    957  CD1 ILE A 202       5.418  -6.574   3.426  1.00  1.54           C  
ATOM    958  H   ILE A 202       5.489  -8.172   1.222  1.00  1.14           H  
ATOM    959  HA  ILE A 202       2.581  -8.547   1.391  1.00  0.91           H  
ATOM    960  HB  ILE A 202       2.484  -5.980   1.726  1.00  0.98           H  
ATOM    961 HG12 ILE A 202       5.050  -5.862   1.473  1.00  1.15           H  
ATOM    962 HG13 ILE A 202       4.303  -4.910   2.750  1.00  1.56           H  
ATOM    963 HG21 ILE A 202       1.535  -7.231   3.412  1.00  1.64           H  
ATOM    964 HG22 ILE A 202       2.817  -6.380   4.276  1.00  1.42           H  
ATOM    965 HG23 ILE A 202       3.045  -8.060   3.792  1.00  1.48           H  
ATOM    966 HD11 ILE A 202       5.422  -5.990   4.335  1.00  1.90           H  
ATOM    967 HD12 ILE A 202       6.422  -6.632   3.031  1.00  2.00           H  
ATOM    968 HD13 ILE A 202       5.056  -7.568   3.638  1.00  1.92           H  
ATOM    969  N   THR A 203       2.581  -8.034  -1.035  1.00  0.79           N  
ATOM    970  CA  THR A 203       2.464  -7.665  -2.441  1.00  0.79           C  
ATOM    971  C   THR A 203       1.351  -6.641  -2.644  1.00  0.77           C  
ATOM    972  O   THR A 203       0.467  -6.496  -1.800  1.00  0.94           O  
ATOM    973  CB  THR A 203       2.192  -8.906  -3.294  1.00  0.84           C  
ATOM    974  OG1 THR A 203       3.009  -9.986  -2.882  1.00  0.93           O  
ATOM    975  CG2 THR A 203       2.436  -8.682  -4.770  1.00  0.95           C  
ATOM    976  H   THR A 203       2.067  -8.797  -0.697  1.00  0.88           H  
ATOM    977  HA  THR A 203       3.401  -7.227  -2.748  1.00  0.86           H  
ATOM    978  HB  THR A 203       1.158  -9.195  -3.170  1.00  0.87           H  
ATOM    979  HG1 THR A 203       2.554 -10.493  -2.206  1.00  1.35           H  
ATOM    980 HG21 THR A 203       3.268  -8.005  -4.900  1.00  1.26           H  
ATOM    981 HG22 THR A 203       1.552  -8.257  -5.222  1.00  1.44           H  
ATOM    982 HG23 THR A 203       2.664  -9.626  -5.244  1.00  1.12           H  
ATOM    983  N   LEU A 204       1.403  -5.934  -3.768  1.00  0.73           N  
ATOM    984  CA  LEU A 204       0.398  -4.922  -4.082  1.00  0.74           C  
ATOM    985  C   LEU A 204      -0.178  -5.142  -5.477  1.00  0.74           C  
ATOM    986  O   LEU A 204       0.558  -5.402  -6.430  1.00  0.84           O  
ATOM    987  CB  LEU A 204       1.007  -3.521  -3.984  1.00  0.85           C  
ATOM    988  CG  LEU A 204       0.366  -2.608  -2.937  1.00  1.52           C  
ATOM    989  CD1 LEU A 204       1.015  -1.233  -2.960  1.00  2.51           C  
ATOM    990  CD2 LEU A 204      -1.133  -2.496  -3.176  1.00  1.97           C  
ATOM    991  H   LEU A 204       2.132  -6.095  -4.402  1.00  0.82           H  
ATOM    992  HA  LEU A 204      -0.398  -5.011  -3.358  1.00  0.76           H  
ATOM    993  HB2 LEU A 204       2.056  -3.624  -3.748  1.00  1.34           H  
ATOM    994  HB3 LEU A 204       0.917  -3.044  -4.948  1.00  1.16           H  
ATOM    995  HG  LEU A 204       0.519  -3.033  -1.955  1.00  2.10           H  
ATOM    996 HD11 LEU A 204       2.050  -1.328  -3.251  1.00  2.84           H  
ATOM    997 HD12 LEU A 204       0.957  -0.791  -1.976  1.00  3.23           H  
ATOM    998 HD13 LEU A 204       0.499  -0.602  -3.669  1.00  2.77           H  
ATOM    999 HD21 LEU A 204      -1.541  -1.722  -2.541  1.00  2.57           H  
ATOM   1000 HD22 LEU A 204      -1.606  -3.438  -2.944  1.00  2.09           H  
ATOM   1001 HD23 LEU A 204      -1.316  -2.246  -4.210  1.00  2.52           H  
ATOM   1002  N   SER A 205      -1.498  -5.038  -5.590  1.00  0.75           N  
ATOM   1003  CA  SER A 205      -2.175  -5.225  -6.868  1.00  0.85           C  
ATOM   1004  C   SER A 205      -2.647  -3.890  -7.434  1.00  0.90           C  
ATOM   1005  O   SER A 205      -3.432  -3.180  -6.805  1.00  0.97           O  
ATOM   1006  CB  SER A 205      -3.364  -6.174  -6.706  1.00  0.99           C  
ATOM   1007  OG  SER A 205      -2.932  -7.484  -6.385  1.00  1.35           O  
ATOM   1008  H   SER A 205      -2.031  -4.830  -4.794  1.00  0.77           H  
ATOM   1009  HA  SER A 205      -1.468  -5.664  -7.557  1.00  0.85           H  
ATOM   1010  HB2 SER A 205      -4.002  -5.814  -5.913  1.00  1.60           H  
ATOM   1011  HB3 SER A 205      -3.923  -6.207  -7.630  1.00  1.49           H  
ATOM   1012  HG  SER A 205      -3.457  -8.123  -6.873  1.00  1.58           H  
ATOM   1013  N   HIS A 206      -2.165  -3.554  -8.628  1.00  0.94           N  
ATOM   1014  CA  HIS A 206      -2.538  -2.304  -9.279  1.00  1.05           C  
ATOM   1015  C   HIS A 206      -3.058  -2.561 -10.690  1.00  1.22           C  
ATOM   1016  O   HIS A 206      -2.286  -2.612 -11.648  1.00  1.23           O  
ATOM   1017  CB  HIS A 206      -1.341  -1.353  -9.329  1.00  1.04           C  
ATOM   1018  CG  HIS A 206      -1.690   0.025  -9.798  1.00  1.20           C  
ATOM   1019  ND1 HIS A 206      -0.815   0.825 -10.503  1.00  1.64           N  
ATOM   1020  CD2 HIS A 206      -2.828   0.747  -9.663  1.00  1.73           C  
ATOM   1021  CE1 HIS A 206      -1.398   1.978 -10.778  1.00  1.60           C  
ATOM   1022  NE2 HIS A 206      -2.620   1.956 -10.280  1.00  1.56           N  
ATOM   1023  H   HIS A 206      -1.543  -4.162  -9.080  1.00  0.94           H  
ATOM   1024  HA  HIS A 206      -3.324  -1.849  -8.697  1.00  1.06           H  
ATOM   1025  HB2 HIS A 206      -0.916  -1.269  -8.340  1.00  0.95           H  
ATOM   1026  HB3 HIS A 206      -0.598  -1.756 -10.002  1.00  1.06           H  
ATOM   1027  HD1 HIS A 206       0.100   0.583 -10.762  1.00  2.31           H  
ATOM   1028  HD2 HIS A 206      -3.732   0.430  -9.161  1.00  2.54           H  
ATOM   1029  HE1 HIS A 206      -0.951   2.798 -11.320  1.00  2.09           H  
ATOM   1030  HE2 HIS A 206      -3.240   2.714 -10.270  1.00  1.88           H  
ATOM   1031  N   ASN A 207      -4.373  -2.722 -10.810  1.00  1.43           N  
ATOM   1032  CA  ASN A 207      -5.000  -2.975 -12.103  1.00  1.65           C  
ATOM   1033  C   ASN A 207      -4.529  -4.302 -12.690  1.00  1.61           C  
ATOM   1034  O   ASN A 207      -5.260  -5.292 -12.678  1.00  1.77           O  
ATOM   1035  CB  ASN A 207      -4.693  -1.833 -13.076  1.00  1.75           C  
ATOM   1036  CG  ASN A 207      -5.819  -0.821 -13.154  1.00  2.02           C  
ATOM   1037  OD1 ASN A 207      -6.346  -0.381 -12.132  1.00  2.82           O  
ATOM   1038  ND2 ASN A 207      -6.194  -0.444 -14.372  1.00  2.05           N  
ATOM   1039  H   ASN A 207      -4.935  -2.670 -10.010  1.00  1.47           H  
ATOM   1040  HA  ASN A 207      -6.068  -3.024 -11.948  1.00  1.83           H  
ATOM   1041  HB2 ASN A 207      -3.798  -1.324 -12.754  1.00  2.00           H  
ATOM   1042  HB3 ASN A 207      -4.533  -2.243 -14.064  1.00  1.83           H  
ATOM   1043 HD21 ASN A 207      -5.730  -0.836 -15.141  1.00  2.16           H  
ATOM   1044 HD22 ASN A 207      -6.920   0.210 -14.451  1.00  2.44           H  
ATOM   1045  N   GLY A 208      -3.302  -4.315 -13.201  1.00  1.47           N  
ATOM   1046  CA  GLY A 208      -2.754  -5.526 -13.785  1.00  1.50           C  
ATOM   1047  C   GLY A 208      -1.360  -5.837 -13.276  1.00  1.34           C  
ATOM   1048  O   GLY A 208      -1.016  -7.000 -13.058  1.00  1.47           O  
ATOM   1049  H   GLY A 208      -2.764  -3.497 -13.183  1.00  1.40           H  
ATOM   1050  HA2 GLY A 208      -3.406  -6.354 -13.546  1.00  1.60           H  
ATOM   1051  HA3 GLY A 208      -2.715  -5.411 -14.858  1.00  1.60           H  
ATOM   1052  N   LYS A 209      -0.554  -4.797 -13.086  1.00  1.21           N  
ATOM   1053  CA  LYS A 209       0.810  -4.965 -12.600  1.00  1.09           C  
ATOM   1054  C   LYS A 209       0.839  -5.060 -11.077  1.00  0.93           C  
ATOM   1055  O   LYS A 209      -0.075  -4.590 -10.399  1.00  0.90           O  
ATOM   1056  CB  LYS A 209       1.687  -3.801 -13.065  1.00  1.14           C  
ATOM   1057  CG  LYS A 209       1.944  -3.795 -14.563  1.00  1.47           C  
ATOM   1058  CD  LYS A 209       2.899  -2.681 -14.961  1.00  1.54           C  
ATOM   1059  CE  LYS A 209       3.372  -2.839 -16.397  1.00  2.04           C  
ATOM   1060  NZ  LYS A 209       4.021  -1.599 -16.907  1.00  2.63           N  
ATOM   1061  H   LYS A 209      -0.886  -3.894 -13.277  1.00  1.29           H  
ATOM   1062  HA  LYS A 209       1.198  -5.884 -13.012  1.00  1.19           H  
ATOM   1063  HB2 LYS A 209       1.204  -2.873 -12.801  1.00  1.42           H  
ATOM   1064  HB3 LYS A 209       2.639  -3.858 -12.559  1.00  1.13           H  
ATOM   1065  HG2 LYS A 209       2.375  -4.743 -14.850  1.00  1.64           H  
ATOM   1066  HG3 LYS A 209       1.005  -3.654 -15.079  1.00  1.84           H  
ATOM   1067  HD2 LYS A 209       2.392  -1.734 -14.861  1.00  1.65           H  
ATOM   1068  HD3 LYS A 209       3.756  -2.704 -14.304  1.00  1.40           H  
ATOM   1069  HE2 LYS A 209       4.084  -3.650 -16.441  1.00  2.39           H  
ATOM   1070  HE3 LYS A 209       2.521  -3.072 -17.019  1.00  2.29           H  
ATOM   1071  HZ1 LYS A 209       3.326  -0.827 -16.958  1.00  2.80           H  
ATOM   1072  HZ2 LYS A 209       4.409  -1.764 -17.858  1.00  3.03           H  
ATOM   1073  HZ3 LYS A 209       4.795  -1.314 -16.273  1.00  3.13           H  
ATOM   1074  N   ASP A 210       1.894  -5.671 -10.547  1.00  0.91           N  
ATOM   1075  CA  ASP A 210       2.041  -5.829  -9.104  1.00  0.80           C  
ATOM   1076  C   ASP A 210       3.477  -5.549  -8.671  1.00  0.76           C  
ATOM   1077  O   ASP A 210       4.428  -5.951  -9.342  1.00  0.96           O  
ATOM   1078  CB  ASP A 210       1.635  -7.242  -8.680  1.00  0.89           C  
ATOM   1079  CG  ASP A 210       0.140  -7.473  -8.795  1.00  1.08           C  
ATOM   1080  OD1 ASP A 210      -0.391  -7.368  -9.921  1.00  1.93           O  
ATOM   1081  OD2 ASP A 210      -0.497  -7.759  -7.760  1.00  1.22           O  
ATOM   1082  H   ASP A 210       2.589  -6.026 -11.140  1.00  1.04           H  
ATOM   1083  HA  ASP A 210       1.388  -5.116  -8.624  1.00  0.78           H  
ATOM   1084  HB2 ASP A 210       2.140  -7.959  -9.309  1.00  1.15           H  
ATOM   1085  HB3 ASP A 210       1.928  -7.400  -7.652  1.00  1.20           H  
ATOM   1086  N   VAL A 211       3.626  -4.858  -7.545  1.00  0.66           N  
ATOM   1087  CA  VAL A 211       4.945  -4.525  -7.022  1.00  0.73           C  
ATOM   1088  C   VAL A 211       5.066  -4.912  -5.551  1.00  0.77           C  
ATOM   1089  O   VAL A 211       4.217  -4.555  -4.734  1.00  0.89           O  
ATOM   1090  CB  VAL A 211       5.249  -3.021  -7.171  1.00  0.86           C  
ATOM   1091  CG1 VAL A 211       6.452  -2.805  -8.078  1.00  0.94           C  
ATOM   1092  CG2 VAL A 211       4.033  -2.275  -7.700  1.00  1.10           C  
ATOM   1093  H   VAL A 211       2.830  -4.566  -7.055  1.00  0.68           H  
ATOM   1094  HA  VAL A 211       5.679  -5.078  -7.590  1.00  0.81           H  
ATOM   1095  HB  VAL A 211       5.490  -2.624  -6.195  1.00  1.12           H  
ATOM   1096 HG11 VAL A 211       6.617  -1.746  -8.210  1.00  1.28           H  
ATOM   1097 HG12 VAL A 211       6.263  -3.262  -9.038  1.00  1.44           H  
ATOM   1098 HG13 VAL A 211       7.325  -3.253  -7.630  1.00  1.52           H  
ATOM   1099 HG21 VAL A 211       3.191  -2.448  -7.046  1.00  1.41           H  
ATOM   1100 HG22 VAL A 211       3.797  -2.631  -8.692  1.00  1.62           H  
ATOM   1101 HG23 VAL A 211       4.247  -1.218  -7.740  1.00  1.64           H  
ATOM   1102  N   GLU A 212       6.124  -5.646  -5.222  1.00  0.91           N  
ATOM   1103  CA  GLU A 212       6.355  -6.083  -3.850  1.00  1.03           C  
ATOM   1104  C   GLU A 212       7.752  -5.692  -3.381  1.00  1.19           C  
ATOM   1105  O   GLU A 212       8.742  -6.323  -3.752  1.00  1.53           O  
ATOM   1106  CB  GLU A 212       6.172  -7.599  -3.739  1.00  1.25           C  
ATOM   1107  CG  GLU A 212       6.149  -8.105  -2.306  1.00  1.53           C  
ATOM   1108  CD  GLU A 212       6.685  -9.518  -2.178  1.00  1.92           C  
ATOM   1109  OE1 GLU A 212       5.968 -10.463  -2.569  1.00  2.29           O  
ATOM   1110  OE2 GLU A 212       7.822  -9.679  -1.687  1.00  2.44           O  
ATOM   1111  H   GLU A 212       6.765  -5.899  -5.918  1.00  1.05           H  
ATOM   1112  HA  GLU A 212       5.626  -5.595  -3.219  1.00  0.98           H  
ATOM   1113  HB2 GLU A 212       5.239  -7.873  -4.209  1.00  1.50           H  
ATOM   1114  HB3 GLU A 212       6.983  -8.086  -4.258  1.00  1.64           H  
ATOM   1115  HG2 GLU A 212       6.755  -7.451  -1.696  1.00  2.01           H  
ATOM   1116  HG3 GLU A 212       5.131  -8.088  -1.947  1.00  1.95           H  
ATOM   1117  N   LEU A 213       7.825  -4.648  -2.561  1.00  1.18           N  
ATOM   1118  CA  LEU A 213       9.102  -4.173  -2.039  1.00  1.41           C  
ATOM   1119  C   LEU A 213       8.919  -3.513  -0.675  1.00  1.59           C  
ATOM   1120  O   LEU A 213       7.796  -3.353  -0.198  1.00  2.24           O  
ATOM   1121  CB  LEU A 213       9.740  -3.185  -3.017  1.00  1.96           C  
ATOM   1122  CG  LEU A 213      10.475  -3.826  -4.197  1.00  3.16           C  
ATOM   1123  CD1 LEU A 213      10.799  -2.782  -5.254  1.00  3.97           C  
ATOM   1124  CD2 LEU A 213      11.743  -4.519  -3.722  1.00  3.78           C  
ATOM   1125  H   LEU A 213       7.001  -4.187  -2.300  1.00  1.19           H  
ATOM   1126  HA  LEU A 213       9.752  -5.027  -1.928  1.00  1.76           H  
ATOM   1127  HB2 LEU A 213       8.963  -2.545  -3.408  1.00  2.09           H  
ATOM   1128  HB3 LEU A 213      10.445  -2.576  -2.472  1.00  2.03           H  
ATOM   1129  HG  LEU A 213       9.834  -4.570  -4.648  1.00  3.58           H  
ATOM   1130 HD11 LEU A 213      11.247  -1.920  -4.784  1.00  4.29           H  
ATOM   1131 HD12 LEU A 213       9.891  -2.486  -5.758  1.00  4.24           H  
ATOM   1132 HD13 LEU A 213      11.489  -3.200  -5.972  1.00  4.42           H  
ATOM   1133 HD21 LEU A 213      12.310  -4.858  -4.576  1.00  4.27           H  
ATOM   1134 HD22 LEU A 213      11.481  -5.365  -3.103  1.00  4.09           H  
ATOM   1135 HD23 LEU A 213      12.339  -3.824  -3.147  1.00  3.95           H  
ATOM   1136  N   LEU A 214      10.031  -3.136  -0.052  1.00  1.68           N  
ATOM   1137  CA  LEU A 214       9.992  -2.494   1.258  1.00  2.24           C  
ATOM   1138  C   LEU A 214       9.758  -0.993   1.125  1.00  1.83           C  
ATOM   1139  O   LEU A 214       9.975  -0.412   0.061  1.00  2.05           O  
ATOM   1140  CB  LEU A 214      11.297  -2.754   2.014  1.00  3.20           C  
ATOM   1141  CG  LEU A 214      11.762  -4.212   2.024  1.00  4.22           C  
ATOM   1142  CD1 LEU A 214      13.159  -4.322   2.616  1.00  5.11           C  
ATOM   1143  CD2 LEU A 214      10.782  -5.078   2.801  1.00  4.85           C  
ATOM   1144  H   LEU A 214      10.898  -3.291  -0.483  1.00  1.81           H  
ATOM   1145  HA  LEU A 214       9.173  -2.926   1.813  1.00  2.78           H  
ATOM   1146  HB2 LEU A 214      12.074  -2.152   1.566  1.00  3.24           H  
ATOM   1147  HB3 LEU A 214      11.164  -2.436   3.037  1.00  3.52           H  
ATOM   1148  HG  LEU A 214      11.800  -4.577   1.008  1.00  4.28           H  
ATOM   1149 HD11 LEU A 214      13.817  -3.625   2.117  1.00  5.46           H  
ATOM   1150 HD12 LEU A 214      13.529  -5.327   2.479  1.00  5.36           H  
ATOM   1151 HD13 LEU A 214      13.123  -4.091   3.670  1.00  5.51           H  
ATOM   1152 HD21 LEU A 214      11.135  -6.097   2.813  1.00  5.29           H  
ATOM   1153 HD22 LEU A 214       9.813  -5.038   2.327  1.00  5.12           H  
ATOM   1154 HD23 LEU A 214      10.703  -4.712   3.814  1.00  5.03           H  
ATOM   1155  N   ASP A 215       9.315  -0.371   2.214  1.00  1.93           N  
ATOM   1156  CA  ASP A 215       9.050   1.065   2.224  1.00  1.64           C  
ATOM   1157  C   ASP A 215       7.979   1.430   1.201  1.00  1.62           C  
ATOM   1158  O   ASP A 215       7.619   0.619   0.348  1.00  2.38           O  
ATOM   1159  CB  ASP A 215      10.334   1.846   1.935  1.00  1.83           C  
ATOM   1160  CG  ASP A 215      11.415   1.582   2.965  1.00  1.63           C  
ATOM   1161  OD1 ASP A 215      11.781   0.403   3.155  1.00  2.20           O  
ATOM   1162  OD2 ASP A 215      11.898   2.556   3.582  1.00  1.74           O  
ATOM   1163  H   ASP A 215       9.162  -0.889   3.032  1.00  2.53           H  
ATOM   1164  HA  ASP A 215       8.694   1.328   3.209  1.00  1.77           H  
ATOM   1165  HB2 ASP A 215      10.710   1.561   0.964  1.00  1.98           H  
ATOM   1166  HB3 ASP A 215      10.111   2.903   1.935  1.00  2.21           H  
ATOM   1167  N   ASP A 216       7.475   2.658   1.293  1.00  1.54           N  
ATOM   1168  CA  ASP A 216       6.445   3.136   0.378  1.00  1.77           C  
ATOM   1169  C   ASP A 216       5.186   2.277   0.475  1.00  1.53           C  
ATOM   1170  O   ASP A 216       4.219   2.651   1.140  1.00  1.70           O  
ATOM   1171  CB  ASP A 216       6.969   3.135  -1.061  1.00  2.53           C  
ATOM   1172  CG  ASP A 216       7.953   4.259  -1.317  1.00  2.61           C  
ATOM   1173  OD1 ASP A 216       7.600   5.429  -1.055  1.00  3.12           O  
ATOM   1174  OD2 ASP A 216       9.077   3.971  -1.778  1.00  2.84           O  
ATOM   1175  H   ASP A 216       7.804   3.257   1.996  1.00  1.91           H  
ATOM   1176  HA  ASP A 216       6.197   4.148   0.660  1.00  1.92           H  
ATOM   1177  HB2 ASP A 216       7.466   2.197  -1.255  1.00  3.09           H  
ATOM   1178  HB3 ASP A 216       6.138   3.247  -1.740  1.00  2.83           H  
ATOM   1179  N   LEU A 217       5.205   1.128  -0.192  1.00  1.55           N  
ATOM   1180  CA  LEU A 217       4.065   0.218  -0.180  1.00  1.74           C  
ATOM   1181  C   LEU A 217       4.385  -1.047   0.610  1.00  1.76           C  
ATOM   1182  O   LEU A 217       4.568  -2.121   0.036  1.00  2.18           O  
ATOM   1183  CB  LEU A 217       3.660  -0.148  -1.611  1.00  2.16           C  
ATOM   1184  CG  LEU A 217       4.796  -0.124  -2.634  1.00  2.99           C  
ATOM   1185  CD1 LEU A 217       5.811  -1.215  -2.332  1.00  3.78           C  
ATOM   1186  CD2 LEU A 217       4.246  -0.281  -4.044  1.00  3.33           C  
ATOM   1187  H   LEU A 217       6.005   0.885  -0.704  1.00  1.70           H  
ATOM   1188  HA  LEU A 217       3.240   0.726   0.298  1.00  1.87           H  
ATOM   1189  HB2 LEU A 217       3.235  -1.141  -1.600  1.00  2.50           H  
ATOM   1190  HB3 LEU A 217       2.899   0.547  -1.936  1.00  2.16           H  
ATOM   1191  HG  LEU A 217       5.304   0.829  -2.577  1.00  3.30           H  
ATOM   1192 HD11 LEU A 217       5.327  -2.179  -2.380  1.00  3.99           H  
ATOM   1193 HD12 LEU A 217       6.218  -1.065  -1.343  1.00  4.12           H  
ATOM   1194 HD13 LEU A 217       6.609  -1.177  -3.059  1.00  4.24           H  
ATOM   1195 HD21 LEU A 217       5.021  -0.051  -4.761  1.00  3.05           H  
ATOM   1196 HD22 LEU A 217       3.415   0.395  -4.183  1.00  3.82           H  
ATOM   1197 HD23 LEU A 217       3.912  -1.297  -4.189  1.00  3.89           H  
ATOM   1198  N   ALA A 218       4.450  -0.914   1.932  1.00  1.74           N  
ATOM   1199  CA  ALA A 218       4.747  -2.046   2.801  1.00  1.90           C  
ATOM   1200  C   ALA A 218       4.401  -1.732   4.252  1.00  1.95           C  
ATOM   1201  O   ALA A 218       3.392  -2.205   4.775  1.00  2.36           O  
ATOM   1202  CB  ALA A 218       6.214  -2.435   2.677  1.00  2.03           C  
ATOM   1203  H   ALA A 218       4.293  -0.032   2.331  1.00  1.90           H  
ATOM   1204  HA  ALA A 218       4.149  -2.883   2.472  1.00  2.08           H  
ATOM   1205  HB1 ALA A 218       6.829  -1.550   2.754  1.00  2.45           H  
ATOM   1206  HB2 ALA A 218       6.381  -2.909   1.721  1.00  2.30           H  
ATOM   1207  HB3 ALA A 218       6.471  -3.122   3.469  1.00  2.21           H  
ATOM   1208  N   HIS A 219       5.243  -0.930   4.897  1.00  1.89           N  
ATOM   1209  CA  HIS A 219       5.024  -0.552   6.289  1.00  2.08           C  
ATOM   1210  C   HIS A 219       4.810   0.952   6.417  1.00  1.82           C  
ATOM   1211  O   HIS A 219       5.133   1.714   5.506  1.00  1.76           O  
ATOM   1212  CB  HIS A 219       6.215  -0.983   7.149  1.00  2.52           C  
ATOM   1213  CG  HIS A 219       6.102  -2.381   7.671  1.00  2.88           C  
ATOM   1214  ND1 HIS A 219       5.319  -3.348   7.076  1.00  3.29           N  
ATOM   1215  CD2 HIS A 219       6.681  -2.977   8.740  1.00  3.43           C  
ATOM   1216  CE1 HIS A 219       5.419  -4.476   7.757  1.00  3.73           C  
ATOM   1217  NE2 HIS A 219       6.240  -4.277   8.771  1.00  3.86           N  
ATOM   1218  H   HIS A 219       6.029  -0.584   4.426  1.00  1.96           H  
ATOM   1219  HA  HIS A 219       4.138  -1.061   6.637  1.00  2.36           H  
ATOM   1220  HB2 HIS A 219       7.117  -0.921   6.559  1.00  2.55           H  
ATOM   1221  HB3 HIS A 219       6.298  -0.317   7.995  1.00  2.88           H  
ATOM   1222  HD1 HIS A 219       4.770  -3.225   6.273  1.00  3.56           H  
ATOM   1223  HD2 HIS A 219       7.364  -2.514   9.441  1.00  3.81           H  
ATOM   1224  HE1 HIS A 219       4.917  -5.402   7.522  1.00  4.21           H  
ATOM   1225  HE2 HIS A 219       6.558  -4.972   9.385  1.00  4.45           H  
ATOM   1226  N   THR A 220       4.261   1.374   7.553  1.00  2.31           N  
ATOM   1227  CA  THR A 220       4.003   2.788   7.800  1.00  2.30           C  
ATOM   1228  C   THR A 220       3.207   3.405   6.651  1.00  1.60           C  
ATOM   1229  O   THR A 220       2.323   2.763   6.084  1.00  2.19           O  
ATOM   1230  CB  THR A 220       5.321   3.541   7.998  1.00  3.06           C  
ATOM   1231  OG1 THR A 220       5.985   3.727   6.760  1.00  3.65           O  
ATOM   1232  CG2 THR A 220       6.281   2.835   8.932  1.00  4.07           C  
ATOM   1233  H   THR A 220       4.025   0.717   8.241  1.00  2.92           H  
ATOM   1234  HA  THR A 220       3.419   2.863   8.706  1.00  2.79           H  
ATOM   1235  HB  THR A 220       5.109   4.514   8.417  1.00  3.06           H  
ATOM   1236  HG1 THR A 220       6.383   2.899   6.481  1.00  3.97           H  
ATOM   1237 HG21 THR A 220       5.761   2.553   9.836  1.00  4.43           H  
ATOM   1238 HG22 THR A 220       7.098   3.496   9.176  1.00  4.38           H  
ATOM   1239 HG23 THR A 220       6.666   1.948   8.448  1.00  4.55           H  
ATOM   1240  N   ILE A 221       3.523   4.653   6.313  1.00  1.30           N  
ATOM   1241  CA  ILE A 221       2.836   5.351   5.232  1.00  1.43           C  
ATOM   1242  C   ILE A 221       1.366   5.577   5.573  1.00  1.38           C  
ATOM   1243  O   ILE A 221       0.721   4.724   6.185  1.00  1.78           O  
ATOM   1244  CB  ILE A 221       2.939   4.571   3.905  1.00  2.35           C  
ATOM   1245  CG1 ILE A 221       4.285   4.843   3.232  1.00  3.31           C  
ATOM   1246  CG2 ILE A 221       1.792   4.941   2.975  1.00  2.89           C  
ATOM   1247  CD1 ILE A 221       5.345   3.815   3.561  1.00  4.04           C  
ATOM   1248  H   ILE A 221       4.236   5.115   6.799  1.00  1.84           H  
ATOM   1249  HA  ILE A 221       3.314   6.311   5.099  1.00  1.92           H  
ATOM   1250  HB  ILE A 221       2.863   3.519   4.127  1.00  2.71           H  
ATOM   1251 HG12 ILE A 221       4.150   4.848   2.161  1.00  3.74           H  
ATOM   1252 HG13 ILE A 221       4.650   5.810   3.548  1.00  3.61           H  
ATOM   1253 HG21 ILE A 221       1.640   6.010   2.998  1.00  3.11           H  
ATOM   1254 HG22 ILE A 221       0.890   4.443   3.299  1.00  3.21           H  
ATOM   1255 HG23 ILE A 221       2.031   4.633   1.968  1.00  3.42           H  
ATOM   1256 HD11 ILE A 221       5.619   3.901   4.602  1.00  4.25           H  
ATOM   1257 HD12 ILE A 221       6.214   3.985   2.944  1.00  4.48           H  
ATOM   1258 HD13 ILE A 221       4.957   2.825   3.372  1.00  4.35           H  
ATOM   1259  N   ARG A 222       0.841   6.730   5.171  1.00  1.36           N  
ATOM   1260  CA  ARG A 222      -0.553   7.070   5.432  1.00  1.63           C  
ATOM   1261  C   ARG A 222      -1.459   6.550   4.320  1.00  1.46           C  
ATOM   1262  O   ARG A 222      -1.076   6.538   3.150  1.00  1.56           O  
ATOM   1263  CB  ARG A 222      -0.714   8.585   5.569  1.00  2.19           C  
ATOM   1264  CG  ARG A 222       0.270   9.217   6.540  1.00  2.56           C  
ATOM   1265  CD  ARG A 222      -0.203  10.588   7.000  1.00  2.84           C  
ATOM   1266  NE  ARG A 222       0.840  11.601   6.865  1.00  3.62           N  
ATOM   1267  CZ  ARG A 222       1.888  11.694   7.680  1.00  4.30           C  
ATOM   1268  NH1 ARG A 222       2.032  10.836   8.681  1.00  4.99           N  
ATOM   1269  NH2 ARG A 222       2.792  12.645   7.492  1.00  4.63           N  
ATOM   1270  H   ARG A 222       1.405   7.370   4.687  1.00  1.50           H  
ATOM   1271  HA  ARG A 222      -0.839   6.602   6.362  1.00  1.82           H  
ATOM   1272  HB2 ARG A 222      -0.572   9.039   4.599  1.00  2.44           H  
ATOM   1273  HB3 ARG A 222      -1.715   8.799   5.913  1.00  2.61           H  
ATOM   1274  HG2 ARG A 222       0.372   8.576   7.402  1.00  3.10           H  
ATOM   1275  HG3 ARG A 222       1.227   9.323   6.050  1.00  2.77           H  
ATOM   1276  HD2 ARG A 222      -1.054  10.881   6.402  1.00  2.89           H  
ATOM   1277  HD3 ARG A 222      -0.499  10.523   8.036  1.00  3.01           H  
ATOM   1278  HE  ARG A 222       0.756  12.245   6.132  1.00  3.96           H  
ATOM   1279 HH11 ARG A 222       1.352  10.117   8.825  1.00  4.96           H  
ATOM   1280 HH12 ARG A 222       2.821  10.909   9.291  1.00  5.70           H  
ATOM   1281 HH21 ARG A 222       2.688  13.293   6.737  1.00  4.36           H  
ATOM   1282 HH22 ARG A 222       3.580  12.714   8.105  1.00  5.33           H  
ATOM   1283  N   ILE A 223      -2.661   6.121   4.694  1.00  1.34           N  
ATOM   1284  CA  ILE A 223      -3.622   5.600   3.728  1.00  1.20           C  
ATOM   1285  C   ILE A 223      -5.054   5.889   4.167  1.00  1.26           C  
ATOM   1286  O   ILE A 223      -5.590   5.218   5.049  1.00  1.55           O  
ATOM   1287  CB  ILE A 223      -3.453   4.081   3.530  1.00  1.18           C  
ATOM   1288  CG1 ILE A 223      -3.361   3.373   4.883  1.00  1.44           C  
ATOM   1289  CG2 ILE A 223      -2.221   3.790   2.687  1.00  1.12           C  
ATOM   1290  CD1 ILE A 223      -4.101   2.054   4.927  1.00  1.52           C  
ATOM   1291  H   ILE A 223      -2.907   6.157   5.641  1.00  1.45           H  
ATOM   1292  HA  ILE A 223      -3.440   6.088   2.782  1.00  1.15           H  
ATOM   1293  HB  ILE A 223      -4.318   3.713   2.998  1.00  1.24           H  
ATOM   1294 HG12 ILE A 223      -2.323   3.178   5.109  1.00  1.65           H  
ATOM   1295 HG13 ILE A 223      -3.776   4.014   5.647  1.00  1.79           H  
ATOM   1296 HG21 ILE A 223      -2.176   2.734   2.467  1.00  1.16           H  
ATOM   1297 HG22 ILE A 223      -1.336   4.083   3.231  1.00  1.89           H  
ATOM   1298 HG23 ILE A 223      -2.276   4.348   1.764  1.00  1.41           H  
ATOM   1299 HD11 ILE A 223      -5.088   2.181   4.508  1.00  1.49           H  
ATOM   1300 HD12 ILE A 223      -4.186   1.723   5.951  1.00  1.98           H  
ATOM   1301 HD13 ILE A 223      -3.559   1.317   4.354  1.00  2.10           H  
ATOM   1302  N   GLU A 224      -5.665   6.893   3.547  1.00  1.20           N  
ATOM   1303  CA  GLU A 224      -7.035   7.273   3.874  1.00  1.26           C  
ATOM   1304  C   GLU A 224      -8.004   6.794   2.796  1.00  1.29           C  
ATOM   1305  O   GLU A 224      -7.656   5.959   1.962  1.00  1.22           O  
ATOM   1306  CB  GLU A 224      -7.140   8.792   4.035  1.00  1.38           C  
ATOM   1307  CG  GLU A 224      -7.926   9.221   5.263  1.00  1.78           C  
ATOM   1308  CD  GLU A 224      -8.339  10.679   5.210  1.00  2.05           C  
ATOM   1309  OE1 GLU A 224      -7.457  11.539   5.006  1.00  2.27           O  
ATOM   1310  OE2 GLU A 224      -9.544  10.960   5.375  1.00  2.59           O  
ATOM   1311  H   GLU A 224      -5.184   7.391   2.854  1.00  1.26           H  
ATOM   1312  HA  GLU A 224      -7.296   6.803   4.809  1.00  1.39           H  
ATOM   1313  HB2 GLU A 224      -6.145   9.204   4.108  1.00  1.54           H  
ATOM   1314  HB3 GLU A 224      -7.626   9.202   3.162  1.00  1.50           H  
ATOM   1315  HG2 GLU A 224      -8.815   8.614   5.337  1.00  1.99           H  
ATOM   1316  HG3 GLU A 224      -7.312   9.067   6.139  1.00  2.06           H  
ATOM   1317  N   GLU A 225      -9.222   7.328   2.822  1.00  1.94           N  
ATOM   1318  CA  GLU A 225     -10.243   6.954   1.848  1.00  2.33           C  
ATOM   1319  C   GLU A 225     -10.689   5.510   2.053  1.00  1.59           C  
ATOM   1320  O   GLU A 225     -10.368   4.890   3.066  1.00  1.88           O  
ATOM   1321  CB  GLU A 225      -9.713   7.142   0.424  1.00  3.41           C  
ATOM   1322  CG  GLU A 225     -10.641   7.949  -0.470  1.00  4.30           C  
ATOM   1323  CD  GLU A 225     -10.675   7.432  -1.895  1.00  4.56           C  
ATOM   1324  OE1 GLU A 225      -9.631   6.938  -2.372  1.00  4.91           O  
ATOM   1325  OE2 GLU A 225     -11.744   7.522  -2.534  1.00  4.77           O  
ATOM   1326  H   GLU A 225      -9.441   7.988   3.512  1.00  2.36           H  
ATOM   1327  HA  GLU A 225     -11.093   7.605   1.994  1.00  2.87           H  
ATOM   1328  HB2 GLU A 225      -8.761   7.651   0.471  1.00  3.55           H  
ATOM   1329  HB3 GLU A 225      -9.570   6.170  -0.026  1.00  3.87           H  
ATOM   1330  HG2 GLU A 225     -11.640   7.904  -0.063  1.00  4.67           H  
ATOM   1331  HG3 GLU A 225     -10.304   8.976  -0.482  1.00  4.73           H  
ATOM   1332  N   LEU A 226     -11.432   4.981   1.085  1.00  1.53           N  
ATOM   1333  CA  LEU A 226     -11.923   3.609   1.159  1.00  1.36           C  
ATOM   1334  C   LEU A 226     -10.780   2.632   1.419  1.00  2.06           C  
ATOM   1335  O   LEU A 226     -11.067   1.467   1.765  1.00  2.74           O  
ATOM   1336  CB  LEU A 226     -12.648   3.234  -0.136  1.00  1.49           C  
ATOM   1337  CG  LEU A 226     -11.735   2.891  -1.316  1.00  1.23           C  
ATOM   1338  CD1 LEU A 226     -12.560   2.515  -2.537  1.00  1.91           C  
ATOM   1339  CD2 LEU A 226     -10.813   4.059  -1.633  1.00  1.37           C  
ATOM   1340  OXT LEU A 226      -9.609   3.041   1.275  1.00  2.56           O  
ATOM   1341  H   LEU A 226     -11.655   5.526   0.302  1.00  2.16           H  
ATOM   1342  HA  LEU A 226     -12.623   3.553   1.980  1.00  1.72           H  
ATOM   1343  HB2 LEU A 226     -13.279   2.379   0.065  1.00  2.10           H  
ATOM   1344  HB3 LEU A 226     -13.276   4.063  -0.426  1.00  2.09           H  
ATOM   1345  HG  LEU A 226     -11.122   2.041  -1.053  1.00  1.57           H  
ATOM   1346 HD11 LEU A 226     -11.901   2.218  -3.339  1.00  2.29           H  
ATOM   1347 HD12 LEU A 226     -13.148   3.364  -2.850  1.00  2.34           H  
ATOM   1348 HD13 LEU A 226     -13.217   1.694  -2.288  1.00  2.38           H  
ATOM   1349 HD21 LEU A 226     -10.295   3.867  -2.561  1.00  1.90           H  
ATOM   1350 HD22 LEU A 226     -10.093   4.175  -0.836  1.00  1.80           H  
ATOM   1351 HD23 LEU A 226     -11.396   4.964  -1.725  1.00  1.74           H  
TER    1352      LEU A 226                                                      
END
MOLECULE T0492.pdb
ATOM     18  N   PHE     2      -1.543   4.722  10.626  1.00 74.01
ATOM     19  HN  PHE     2      -1.545   5.677  10.295  1.00  0.00
ATOM     20  CA  PHE     2      -2.153   3.701   9.795  1.00  3.52
ATOM     21  HA  PHE     2      -2.214   2.774  10.364  1.00  0.00
ATOM     22  CB  PHE     2      -3.570   4.116   9.379  1.00 43.40
ATOM     23 2HB  PHE     2      -4.130   4.382  10.276  1.00  0.00
ATOM     24 3HB  PHE     2      -3.499   4.995   8.737  1.00  0.00
ATOM     25  CG  PHE     2      -4.330   3.046   8.642  1.00 20.11
ATOM     26  CD1 PHE     2      -4.372   3.032   7.256  1.00 62.52
ATOM     27 1HD  PHE     2      -3.855   3.800   6.699  1.00  0.00
ATOM     28  CE1 PHE     2      -5.067   2.049   6.579  1.00 34.45
ATOM     29 1HE  PHE     2      -5.093   2.052   5.499  1.00  0.00
ATOM     30  CZ  PHE     2      -5.728   1.064   7.284  1.00 62.44
ATOM     31  HZ  PHE     2      -6.269   0.293   6.756  1.00  0.00
ATOM     32  CE2 PHE     2      -5.698   1.066   8.665  1.00 65.21
ATOM     33 2HE  PHE     2      -6.220   0.300   9.218  1.00  0.00
ATOM     34  CD2 PHE     2      -4.999   2.051   9.338  1.00  5.40
ATOM     35 2HD  PHE     2      -4.974   2.046  10.418  1.00  0.00
ATOM     36  C   PHE     2      -1.276   3.477   8.572  1.00 11.34
ATOM     37  O   PHE     2      -1.121   4.368   7.734  1.00 25.11
ATOM     38  N   SER     3      -0.684   2.301   8.493  1.00 64.43
ATOM     39  HN  SER     3      -0.879   1.592   9.184  1.00  0.00
ATOM     40  CA  SER     3       0.249   1.991   7.431  1.00 24.31
ATOM     41  HA  SER     3       0.539   2.917   6.933  1.00  0.00
ATOM     42  CB  SER     3       1.493   1.334   8.027  1.00 64.20
ATOM     43 2HB  SER     3       1.287   0.280   8.213  1.00  0.00
ATOM     44 3HB  SER     3       2.318   1.424   7.320  1.00  0.00
ATOM     45  OG  SER     3       1.856   1.959   9.247  1.00 35.21
ATOM     46  HG  SER     3       2.639   1.527   9.597  1.00  0.00
ATOM     47  C   SER     3      -0.397   1.063   6.412  1.00 60.05
ATOM     48  O   SER     3      -1.528   0.612   6.597  1.00  3.21
ATOM     49  N   LEU     4       0.328   0.765   5.345  1.00 12.31
ATOM     50  HN  LEU     4       1.247   1.169   5.233  1.00  0.00
ATOM     51  CA  LEU     4      -0.162  -0.138   4.314  1.00 14.12
ATOM     52  HA  LEU     4      -1.150   0.198   4.000  1.00  0.00
ATOM     53  CB  LEU     4       0.773  -0.115   3.101  1.00 12.03
ATOM     54 2HB  LEU     4       0.891   0.923   2.787  1.00  0.00
ATOM     55 3HB  LEU     4       1.739  -0.512   3.413  1.00  0.00
ATOM     56  CG  LEU     4       0.298  -0.924   1.891  1.00 23.03
ATOM     57  HG  LEU     4       0.144  -1.956   2.206  1.00  0.00
ATOM     58  CD1 LEU     4      -1.022  -0.380   1.370  1.00 51.12
ATOM     59 1HD1 LEU     4      -1.358  -0.976   0.522  1.00  0.00
ATOM     60 2HD1 LEU     4      -1.770  -0.424   2.162  1.00  0.00
ATOM     61 3HD1 LEU     4      -0.888   0.655   1.054  1.00  0.00
ATOM     62  CD2 LEU     4       1.353  -0.909   0.796  1.00 63.44
ATOM     63 1HD2 LEU     4       1.014  -1.505  -0.051  1.00  0.00
ATOM     64 2HD2 LEU     4       1.524   0.118   0.470  1.00  0.00
ATOM     65 3HD2 LEU     4       2.283  -1.326   1.182  1.00  0.00
ATOM     66  C   LEU     4      -0.277  -1.556   4.867  1.00 33.11
ATOM     67  O   LEU     4      -1.097  -2.351   4.413  1.00 44.21
ATOM     68  N   ARG     5       0.537  -1.858   5.872  1.00 30.21
ATOM     69  HN  ARG     5       1.184  -1.165   6.222  1.00  0.00
ATOM     70  CA  ARG     5       0.527  -3.177   6.493  1.00 63.40
ATOM     71  HA  ARG     5       0.383  -3.914   5.703  1.00  0.00
ATOM     72  CB  ARG     5       1.875  -3.467   7.172  1.00 74.52
ATOM     73 2HB  ARG     5       1.804  -4.437   7.663  1.00  0.00
ATOM     74 3HB  ARG     5       2.642  -3.506   6.398  1.00  0.00
ATOM     75  CG  ARG     5       2.309  -2.440   8.214  1.00  4.51
ATOM     76 2HG  ARG     5       3.389  -2.511   8.347  1.00  0.00
ATOM     77 3HG  ARG     5       2.052  -1.444   7.852  1.00  0.00
ATOM     78  CD  ARG     5       1.636  -2.660   9.559  1.00 60.41
ATOM     79 2HD  ARG     5       0.561  -2.522   9.442  1.00  0.00
ATOM     80 3HD  ARG     5       1.833  -3.680   9.889  1.00  0.00
ATOM     81  NE  ARG     5       2.123  -1.732  10.576  1.00 53.25
ATOM     82  HE  ARG     5       2.750  -1.000  10.273  1.00  0.00
ATOM     83  CZ  ARG     5       1.788  -1.799  11.863  1.00 31.32
ATOM     84  NH1 ARG     5       0.974  -2.752  12.297  1.00 42.13
ATOM     85 1HH1 ARG     5       0.725  -2.799  13.274  1.00  0.00
ATOM     86 2HH1 ARG     5       0.603  -3.431  11.649  1.00  0.00
ATOM     87  NH2 ARG     5       2.275  -0.912  12.719  1.00  5.31
ATOM     88 1HH2 ARG     5       2.024  -0.962  13.696  1.00  0.00
ATOM     89 2HH2 ARG     5       2.898  -0.185  12.394  1.00  0.00
ATOM     90  C   ARG     5      -0.629  -3.317   7.482  1.00 10.22
ATOM     91  O   ARG     5      -0.864  -4.396   8.028  1.00 64.31
ATOM     92  N   ASP     6      -1.337  -2.219   7.719  1.00 63.24
ATOM     93  HN  ASP     6      -1.079  -1.348   7.276  1.00  0.00
ATOM     94  CA  ASP     6      -2.490  -2.231   8.612  1.00 35.34
ATOM     95  HA  ASP     6      -2.323  -2.992   9.374  1.00  0.00
ATOM     96  CB  ASP     6      -2.667  -0.876   9.304  1.00 22.10
ATOM     97 2HB  ASP     6      -2.603  -0.090   8.551  1.00  0.00
ATOM     98 3HB  ASP     6      -3.653  -0.848   9.767  1.00  0.00
ATOM     99  CG  ASP     6      -1.625  -0.608  10.371  1.00 45.42
ATOM    100  OD1 ASP     6      -1.739  -1.182  11.475  1.00 64.32
ATOM    101  OD2 ASP     6      -0.704   0.198  10.124  1.00 21.34
ATOM    102 2HD  ASP     6      -0.086   0.324  10.848  1.00  0.00
ATOM    103  C   ASP     6      -3.756  -2.578   7.839  1.00 55.21
ATOM    104  O   ASP     6      -4.831  -2.744   8.422  1.00 30.54
ATOM    105  N   ALA     7      -3.625  -2.680   6.524  1.00 72.34
ATOM    106  HN  ALA     7      -2.728  -2.503   6.093  1.00  0.00
ATOM    107  CA  ALA     7      -4.743  -3.041   5.669  1.00 22.13
ATOM    108  HA  ALA     7      -5.659  -2.672   6.130  1.00  0.00
ATOM    109  CB  ALA     7      -4.595  -2.392   4.302  1.00 22.42
ATOM    110 1HB  ALA     7      -5.451  -2.648   3.677  1.00  0.00
ATOM    111 2HB  ALA     7      -4.544  -1.309   4.418  1.00  0.00
ATOM    112 3HB  ALA     7      -3.681  -2.749   3.828  1.00  0.00
ATOM    113  C   ALA     7      -4.843  -4.555   5.534  1.00 53.13
ATOM    114  O   ALA     7      -3.841  -5.264   5.629  1.00 30.50
ATOM    115  N   LYS     8      -6.054  -5.046   5.322  1.00 32.51
ATOM    116  HN  LYS     8      -6.843  -4.420   5.247  1.00  0.00
ATOM    117  CA  LYS     8      -6.289  -6.477   5.191  1.00 22.44
ATOM    118  HA  LYS     8      -5.454  -7.012   5.645  1.00  0.00
ATOM    119  CB  LYS     8      -7.584  -6.872   5.910  1.00 13.25
ATOM    120 2HB  LYS     8      -8.423  -6.441   5.364  1.00  0.00
ATOM    121 3HB  LYS     8      -7.663  -7.959   5.899  1.00  0.00
ATOM    122  CG  LYS     8      -7.664  -6.403   7.354  1.00 65.44
ATOM    123 2HG  LYS     8      -7.546  -5.319   7.379  1.00  0.00
ATOM    124 3HG  LYS     8      -8.640  -6.671   7.758  1.00  0.00
ATOM    125  CD  LYS     8      -6.584  -7.035   8.217  1.00 11.52
ATOM    126 2HD  LYS     8      -6.700  -8.118   8.196  1.00  0.00
ATOM    127 3HD  LYS     8      -5.606  -6.767   7.816  1.00  0.00
ATOM    128  CE  LYS     8      -6.680  -6.553   9.654  1.00 44.24
ATOM    129 2HE  LYS     8      -6.530  -5.473   9.674  1.00  0.00
ATOM    130 3HE  LYS     8      -7.674  -6.784  10.037  1.00  0.00
ATOM    131  NZ  LYS     8      -5.665  -7.196  10.531  1.00  4.24
ATOM    132 1HZ  LYS     8      -5.760  -6.850  11.475  1.00  0.00
ATOM    133 2HZ  LYS     8      -5.801  -8.196  10.525  1.00  0.00
ATOM    134 3HZ  LYS     8      -4.740  -6.980  10.188  1.00  0.00
ATOM    135  C   LYS     8      -6.383  -6.857   3.718  1.00 42.14
ATOM    136  O   LYS     8      -6.815  -6.049   2.891  1.00 20.55
ATOM    137  N   CYS     9      -5.980  -8.076   3.388  1.00 41.51
ATOM    138  HN  CYS     9      -5.610  -8.695   4.094  1.00  0.00
ATOM    139  CA  CYS     9      -6.058  -8.552   2.015  1.00  2.35
ATOM    140  HA  CYS     9      -5.629  -7.787   1.367  1.00  0.00
ATOM    141  CB  CYS     9      -5.243  -9.834   1.843  1.00 21.02
ATOM    142 2HB  CYS     9      -5.616 -10.355   0.961  1.00  0.00
ATOM    143 3HB  CYS     9      -4.201  -9.552   1.687  1.00  0.00
ATOM    144  SG  CYS     9      -5.327 -10.961   3.252  1.00 72.52
ATOM    145  HG  CYS     9      -4.531 -11.912   2.755  1.00  0.00
ATOM    146  C   CYS     9      -7.512  -8.761   1.608  1.00 15.30
ATOM    147  O   CYS     9      -8.192  -9.663   2.102  1.00 13.32
ATOM    148  N   GLY    10      -7.978  -7.908   0.711  1.00 51.22
ATOM    149  HN  GLY    10      -7.355  -7.248   0.267  1.00  0.00
ATOM    150  CA  GLY    10      -9.376  -7.897   0.346  1.00  3.45
ATOM    151 1HA  GLY    10      -9.478  -8.244  -0.682  1.00  0.00
ATOM    152 2HA  GLY    10      -9.922  -8.567   1.009  1.00  0.00
ATOM    153  C   GLY    10      -9.962  -6.506   0.458  1.00 12.24
ATOM    154  O   GLY    10     -11.091  -6.256   0.029  1.00 13.34
ATOM    155  N   GLN    11      -9.191  -5.600   1.045  1.00 41.41
ATOM    156  HN  GLN    11      -8.285  -5.870   1.401  1.00  0.00
ATOM    157  CA  GLN    11      -9.605  -4.213   1.198  1.00 43.31
ATOM    158  HA  GLN    11     -10.686  -4.162   1.069  1.00  0.00
ATOM    159  CB  GLN    11      -9.253  -3.704   2.597  1.00 35.22
ATOM    160 2HB  GLN    11      -8.178  -3.812   2.741  1.00  0.00
ATOM    161 3HB  GLN    11      -9.523  -2.649   2.657  1.00  0.00
ATOM    162  CG  GLN    11      -9.963  -4.445   3.718  1.00 24.45
ATOM    163 2HG  GLN    11     -11.038  -4.302   3.607  1.00  0.00
ATOM    164 3HG  GLN    11      -9.731  -5.507   3.638  1.00  0.00
ATOM    165  CD  GLN    11      -9.544  -3.956   5.092  1.00 53.41
ATOM    166  OE1 GLN    11      -8.414  -3.504   5.288  1.00 54.04
ATOM    167  NE2 GLN    11     -10.448  -4.036   6.053  1.00 44.33
ATOM    168 1HE2 GLN    11     -11.363  -4.411   5.850  1.00  0.00
ATOM    169 2HE2 GLN    11     -10.222  -3.722   6.986  1.00  0.00
ATOM    170  C   GLN    11      -8.945  -3.330   0.142  1.00  4.23
ATOM    171  O   GLN    11      -7.996  -3.743  -0.527  1.00 30.34
ATOM    172  N   THR    12      -9.461  -2.119  -0.008  1.00  5.22
ATOM    173  HN  THR    12     -10.253  -1.839   0.553  1.00  0.00
ATOM    174  CA  THR    12      -8.921  -1.166  -0.962  1.00 72.31
ATOM    175  HA  THR    12      -8.091  -1.639  -1.488  1.00  0.00
ATOM    176  CB  THR    12      -9.989  -0.754  -1.992  1.00 24.54
ATOM    177  HB  THR    12     -10.761  -0.176  -1.484  1.00  0.00
ATOM    178  OG1 THR    12     -10.582  -1.926  -2.562  1.00 13.33
ATOM    179 1HG  THR    12     -11.256  -1.655  -3.189  1.00  0.00
ATOM    180  CG2 THR    12      -9.387   0.100  -3.099  1.00  4.01
ATOM    181 1HG2 THR    12     -10.161   0.386  -3.812  1.00  0.00
ATOM    182 2HG2 THR    12      -8.948   0.999  -2.665  1.00  0.00
ATOM    183 3HG2 THR    12      -8.613  -0.469  -3.615  1.00  0.00
ATOM    184  C   THR    12      -8.405   0.076  -0.241  1.00 11.14
ATOM    185  O   THR    12      -9.153   0.749   0.471  1.00 21.50
ATOM    186  N   VAL    13      -7.125   0.365  -0.412  1.00 64.12
ATOM    187  HN  VAL    13      -6.544  -0.236  -0.979  1.00  0.00
ATOM    188  CA  VAL    13      -6.521   1.536   0.199  1.00 41.30
ATOM    189  HA  VAL    13      -7.285   2.035   0.796  1.00  0.00
ATOM    190  CB  VAL    13      -5.340   1.166   1.121  1.00 62.24
ATOM    191  HB  VAL    13      -4.903   2.090   1.500  1.00  0.00
ATOM    192  CG1 VAL    13      -5.810   0.344   2.308  1.00 31.14
ATOM    193 1HG1 VAL    13      -4.965   0.114   2.957  1.00  0.00
ATOM    194 2HG1 VAL    13      -6.553   0.911   2.869  1.00  0.00
ATOM    195 3HG1 VAL    13      -6.255  -0.585   1.951  1.00  0.00
ATOM    196  CG2 VAL    13      -4.269   0.420   0.344  1.00  1.13
ATOM    197 1HG2 VAL    13      -3.430   0.189   1.000  1.00  0.00
ATOM    198 2HG2 VAL    13      -4.686  -0.506  -0.050  1.00  0.00
ATOM    199 3HG2 VAL    13      -3.921   1.042  -0.482  1.00  0.00
ATOM    200  C   VAL    13      -6.022   2.500  -0.866  1.00 61.23
ATOM    201  O   VAL    13      -5.900   2.144  -2.036  1.00 43.41
ATOM    202  N   LYS    14      -5.745   3.721  -0.452  1.00 54.14
ATOM    203  HN  LYS    14      -5.945   3.983   0.502  1.00  0.00
ATOM    204  CA  LYS    14      -5.155   4.717  -1.328  1.00 51.51
ATOM    205  HA  LYS    14      -4.765   4.211  -2.211  1.00  0.00
ATOM    206  CB  LYS    14      -6.208   5.727  -1.778  1.00 14.21
ATOM    207 2HB  LYS    14      -6.942   5.841  -0.981  1.00  0.00
ATOM    208 3HB  LYS    14      -5.716   6.684  -1.959  1.00  0.00
ATOM    209  CG  LYS    14      -6.932   5.308  -3.046  1.00 34.22
ATOM    210 2HG  LYS    14      -6.291   5.518  -3.903  1.00  0.00
ATOM    211 3HG  LYS    14      -7.136   4.239  -2.998  1.00  0.00
ATOM    212  CD  LYS    14      -8.243   6.050  -3.222  1.00 32.42
ATOM    213 2HD  LYS    14      -8.659   5.803  -4.199  1.00  0.00
ATOM    214 3HD  LYS    14      -8.934   5.733  -2.442  1.00  0.00
ATOM    215  CE  LYS    14      -8.062   7.556  -3.134  1.00 65.41
ATOM    216 2HE  LYS    14      -7.710   7.813  -2.135  1.00  0.00
ATOM    217 3HE  LYS    14      -7.317   7.867  -3.867  1.00  0.00
ATOM    218  NZ  LYS    14      -9.330   8.278  -3.400  1.00 21.43
ATOM    219 1HZ  LYS    14      -9.175   9.274  -3.334  1.00  0.00
ATOM    220 2HZ  LYS    14      -9.657   8.051  -4.328  1.00  0.00
ATOM    221 3HZ  LYS    14     -10.023   8.001  -2.721  1.00  0.00
ATOM    222  C   LYS    14      -4.006   5.413  -0.624  1.00 53.31
ATOM    223  O   LYS    14      -4.100   5.736   0.560  1.00 40.05
ATOM    224  N   VAL    15      -2.921   5.620  -1.351  1.00 31.31
ATOM    225  HN  VAL    15      -2.912   5.364  -2.328  1.00  0.00
ATOM    226  CA  VAL    15      -1.723   6.214  -0.779  1.00 74.25
ATOM    227  HA  VAL    15      -1.564   5.774   0.205  1.00  0.00
ATOM    228  CB  VAL    15      -0.481   5.931  -1.651  1.00 55.30
ATOM    229  HB  VAL    15      -0.611   6.440  -2.606  1.00  0.00
ATOM    230  CG1 VAL    15       0.778   6.475  -0.991  1.00 60.13
ATOM    231 1HG1 VAL    15       1.641   6.287  -1.630  1.00  0.00
ATOM    232 2HG1 VAL    15       0.671   7.549  -0.836  1.00  0.00
ATOM    233 3HG1 VAL    15       0.926   5.982  -0.030  1.00  0.00
ATOM    234  CG2 VAL    15      -0.345   4.442  -1.921  1.00  4.15
ATOM    235 1HG2 VAL    15       0.522   4.260  -2.557  1.00  0.00
ATOM    236 2HG2 VAL    15      -0.218   3.913  -0.977  1.00  0.00
ATOM    237 3HG2 VAL    15      -1.243   4.082  -2.422  1.00  0.00
ATOM    238  C   VAL    15      -1.890   7.716  -0.621  1.00  1.34
ATOM    239  O   VAL    15      -2.316   8.401  -1.552  1.00 64.13
ATOM    240  N   VAL    16      -1.568   8.222   0.556  1.00 40.44
ATOM    241  HN  VAL    16      -1.280   7.613   1.309  1.00  0.00
ATOM    242  CA  VAL    16      -1.618   9.653   0.797  1.00 52.11
ATOM    243  HA  VAL    16      -1.981  10.122  -0.118  1.00  0.00
ATOM    244  CB  VAL    16      -2.600  10.025   1.935  1.00 74.41
ATOM    245  HB  VAL    16      -2.405  11.057   2.229  1.00  0.00
ATOM    246  CG1 VAL    16      -4.034   9.925   1.446  1.00 32.42
ATOM    247 1HG1 VAL    16      -4.717  10.214   2.244  1.00  0.00
ATOM    248 2HG1 VAL    16      -4.173  10.590   0.593  1.00  0.00
ATOM    249 3HG1 VAL    16      -4.243   8.899   1.144  1.00  0.00
ATOM    250  CG2 VAL    16      -2.406   9.136   3.156  1.00 60.05
ATOM    251 1HG2 VAL    16      -3.096   9.432   3.946  1.00  0.00
ATOM    252 2HG2 VAL    16      -2.595   8.099   2.881  1.00  0.00
ATOM    253 3HG2 VAL    16      -1.382   9.235   3.516  1.00  0.00
ATOM    254  C   VAL    16      -0.230  10.206   1.086  1.00  3.43
ATOM    255  O   VAL    16       0.258  11.073   0.364  1.00 72.51
ATOM    256  N   LYS    17       0.420   9.684   2.111  1.00 33.10
ATOM    257  HN  LYS    17      -0.011   8.959   2.665  1.00  0.00
ATOM    258  CA  LYS    17       1.756  10.131   2.468  1.00 73.35
ATOM    259  HA  LYS    17       2.045  10.925   1.779  1.00  0.00
ATOM    260  CB  LYS    17       1.793  10.682   3.894  1.00 53.01
ATOM    261 2HB  LYS    17       1.381   9.926   4.562  1.00  0.00
ATOM    262 3HB  LYS    17       2.833  10.873   4.159  1.00  0.00
ATOM    263  CG  LYS    17       1.009  11.969   4.091  1.00 34.34
ATOM    264 2HG  LYS    17       1.380  12.723   3.395  1.00  0.00
ATOM    265 3HG  LYS    17      -0.045  11.779   3.892  1.00  0.00
ATOM    266  CD  LYS    17       1.162  12.485   5.510  1.00 73.01
ATOM    267 2HD  LYS    17       0.785  11.732   6.202  1.00  0.00
ATOM    268 3HD  LYS    17       2.219  12.664   5.708  1.00  0.00
ATOM    269  CE  LYS    17       0.397  13.778   5.726  1.00 72.44
ATOM    270 2HE  LYS    17       0.783  14.537   5.044  1.00  0.00
ATOM    271 3HE  LYS    17      -0.657  13.606   5.511  1.00  0.00
ATOM    272  NZ  LYS    17       0.532  14.270   7.122  1.00 74.42
ATOM    273 1HZ  LYS    17       0.013  15.130   7.232  1.00  0.00
ATOM    274 2HZ  LYS    17       0.170  13.576   7.759  1.00  0.00
ATOM    275 3HZ  LYS    17       1.507  14.439   7.326  1.00  0.00
ATOM    276  C   LYS    17       2.750   8.992   2.350  1.00 74.25
ATOM    277  O   LYS    17       2.376   7.820   2.348  1.00 52.02
ATOM    278  N   LEU    18       4.017   9.343   2.254  1.00 42.21
ATOM    279  HN  LEU    18       4.264  10.322   2.204  1.00  0.00
ATOM    280  CA  LEU    18       5.081   8.363   2.217  1.00 13.22
ATOM    281  HA  LEU    18       4.671   7.391   2.491  1.00  0.00
ATOM    282  CB  LEU    18       5.677   8.265   0.810  1.00 61.32
ATOM    283 2HB  LEU    18       5.975   9.267   0.499  1.00  0.00
ATOM    284 3HB  LEU    18       6.557   7.624   0.860  1.00  0.00
ATOM    285  CG  LEU    18       4.738   7.698  -0.258  1.00 65.15
ATOM    286  HG  LEU    18       3.824   8.292  -0.268  1.00  0.00
ATOM    287  CD1 LEU    18       5.386   7.783  -1.627  1.00 22.25
ATOM    288 1HD1 LEU    18       4.704   7.393  -2.382  1.00  0.00
ATOM    289 2HD1 LEU    18       5.619   8.824  -1.854  1.00  0.00
ATOM    290 3HD1 LEU    18       6.305   7.197  -1.631  1.00  0.00
ATOM    291  CD2 LEU    18       4.378   6.256   0.065  1.00 71.20
ATOM    292 1HD2 LEU    18       3.697   5.869  -0.693  1.00  0.00
ATOM    293 2HD2 LEU    18       5.285   5.651   0.080  1.00  0.00
ATOM    294 3HD2 LEU    18       3.896   6.213   1.041  1.00  0.00
ATOM    295  C   LEU    18       6.152   8.749   3.221  1.00 42.33
ATOM    296  O   LEU    18       6.836   9.754   3.048  1.00 73.24
ATOM    297  N   HIS    19       6.265   7.978   4.287  1.00 41.13
ATOM    298  HN  HIS    19       5.664   7.175   4.397  1.00  0.00
ATOM    299  CA  HIS    19       7.248   8.262   5.321  1.00 64.44
ATOM    300  HA  HIS    19       7.383   9.343   5.380  1.00  0.00
ATOM    301  CB  HIS    19       6.772   7.752   6.689  1.00 21.33
ATOM    302 2HB  HIS    19       6.602   6.678   6.615  1.00  0.00
ATOM    303 3HB  HIS    19       7.562   7.936   7.418  1.00  0.00
ATOM    304  CG  HIS    19       5.512   8.397   7.186  1.00 62.22
ATOM    305  ND1 HIS    19       5.494   9.362   8.169  1.00 53.41
ATOM    306  CD2 HIS    19       4.217   8.192   6.844  1.00 31.35
ATOM    307 1HD  HIS    19       6.309   9.737   8.634  1.00  0.00
ATOM    308  CE1 HIS    19       4.247   9.721   8.409  1.00 52.24
ATOM    309  NE2 HIS    19       3.450   9.027   7.619  1.00 64.53
ATOM    310 2HD  HIS    19       3.855   7.500   6.099  1.00  0.00
ATOM    311 1HE  HIS    19       3.932  10.460   9.131  1.00  0.00
ATOM    312 2HE  HIS    19       2.443   9.098   7.589  1.00  0.00
ATOM    313  C   HIS    19       8.580   7.618   4.964  1.00 43.41
ATOM    314  O   HIS    19       8.642   6.745   4.098  1.00 51.35
ATOM    315  N   GLY    20       9.643   8.056   5.620  1.00  2.20
ATOM    316  HN  GLY    20       9.559   8.812   6.285  1.00  0.00
ATOM    317  CA  GLY    20      10.943   7.462   5.397  1.00 72.45
ATOM    318 1HA  GLY    20      11.172   6.798   6.231  1.00  0.00
ATOM    319 2HA  GLY    20      10.909   6.884   4.474  1.00  0.00
ATOM    320  C   GLY    20      12.042   8.495   5.283  1.00 54.34
ATOM    321  O   GLY    20      11.782   9.697   5.320  1.00 10.33
ATOM    322  N   THR    21      13.267   8.020   5.119  1.00 54.33
ATOM    323  HN  THR    21      13.405   7.022   5.054  1.00  0.00
ATOM    324  CA  THR    21      14.442   8.881   5.026  1.00  4.12
ATOM    325  HA  THR    21      14.319   9.703   5.731  1.00  0.00
ATOM    326  CB  THR    21      15.700   8.083   5.402  1.00 61.42
ATOM    327  HB  THR    21      16.579   8.634   5.067  1.00  0.00
ATOM    328  OG1 THR    21      15.667   6.809   4.743  1.00 21.03
ATOM    329 1HG  THR    21      16.465   6.326   4.972  1.00  0.00
ATOM    330  CG2 THR    21      15.792   7.884   6.909  1.00 20.30
ATOM    331 1HG2 THR    21      16.693   7.322   7.154  1.00  0.00
ATOM    332 2HG2 THR    21      15.829   8.856   7.401  1.00  0.00
ATOM    333 3HG2 THR    21      14.918   7.334   7.255  1.00  0.00
ATOM    334  C   THR    21      14.623   9.464   3.621  1.00 30.23
ATOM    335  O   THR    21      15.746   9.711   3.182  1.00 75.23
ATOM    336  N   GLY    22      13.518   9.692   2.923  1.00 32.25
ATOM    337  HN  GLY    22      12.614   9.471   3.314  1.00  0.00
ATOM    338  CA  GLY    22      13.583  10.262   1.589  1.00 22.11
ATOM    339 1HA  GLY    22      12.614  10.698   1.348  1.00  0.00
ATOM    340 2HA  GLY    22      14.343  11.044   1.580  1.00  0.00
ATOM    341  C   GLY    22      13.931   9.233   0.531  1.00 74.52
ATOM    342  O   GLY    22      13.140   8.977  -0.377  1.00 73.21
ATOM    343  N   ALA    23      15.110   8.634   0.661  1.00 20.51
ATOM    344  HN  ALA    23      15.708   8.875   1.439  1.00  0.00
ATOM    345  CA  ALA    23      15.584   7.630  -0.287  1.00 74.44
ATOM    346  HA  ALA    23      15.664   8.101  -1.267  1.00  0.00
ATOM    347  CB  ALA    23      16.961   7.132   0.122  1.00 64.42
ATOM    348 1HB  ALA    23      17.322   6.407  -0.607  1.00  0.00
ATOM    349 2HB  ALA    23      17.653   7.974   0.167  1.00  0.00
ATOM    350 3HB  ALA    23      16.900   6.660   1.102  1.00  0.00
ATOM    351  C   ALA    23      14.605   6.465  -0.391  1.00 45.31
ATOM    352  O   ALA    23      14.386   5.915  -1.473  1.00 25.24
ATOM    353  N   LEU    24      14.015   6.101   0.741  1.00 14.13
ATOM    354  HN  LEU    24      14.259   6.564   1.605  1.00  0.00
ATOM    355  CA  LEU    24      13.015   5.043   0.780  1.00 61.23
ATOM    356  HA  LEU    24      13.452   4.138   0.358  1.00  0.00
ATOM    357  CB  LEU    24      12.599   4.760   2.230  1.00 63.32
ATOM    358 2HB  LEU    24      13.497   4.510   2.794  1.00  0.00
ATOM    359 3HB  LEU    24      12.156   5.670   2.636  1.00  0.00
ATOM    360  CG  LEU    24      11.592   3.621   2.414  1.00 32.01
ATOM    361  HG  LEU    24      10.713   3.839   1.807  1.00  0.00
ATOM    362  CD1 LEU    24      12.184   2.300   1.942  1.00 12.44
ATOM    363 1HD1 LEU    24      11.450   1.503   2.059  1.00  0.00
ATOM    364 2HD1 LEU    24      12.462   2.383   0.891  1.00  0.00
ATOM    365 3HD1 LEU    24      13.069   2.067   2.534  1.00  0.00
ATOM    366  CD2 LEU    24      11.159   3.523   3.866  1.00 51.42
ATOM    367 1HD2 LEU    24      10.427   2.724   3.980  1.00  0.00
ATOM    368 2HD2 LEU    24      12.027   3.309   4.489  1.00  0.00
ATOM    369 3HD2 LEU    24      10.714   4.469   4.176  1.00  0.00
ATOM    370  C   LEU    24      11.799   5.439  -0.057  1.00  1.54
ATOM    371  O   LEU    24      11.283   4.637  -0.835  1.00  3.43
ATOM    372  N   LYS    25      11.374   6.692   0.088  1.00 73.40
ATOM    373  HN  LYS    25      11.853   7.311   0.726  1.00  0.00
ATOM    374  CA  LYS    25      10.227   7.213  -0.650  1.00 74.22
ATOM    375  HA  LYS    25       9.353   6.610  -0.405  1.00  0.00
ATOM    376  CB  LYS    25       9.951   8.670  -0.266  1.00 62.33
ATOM    377 2HB  LYS    25      10.752   9.288  -0.673  1.00  0.00
ATOM    378 3HB  LYS    25       9.002   8.967  -0.711  1.00  0.00
ATOM    379  CG  LYS    25       9.873   8.915   1.232  1.00 12.02
ATOM    380 2HG  LYS    25       9.042   8.343   1.643  1.00  0.00
ATOM    381 3HG  LYS    25      10.804   8.589   1.695  1.00  0.00
ATOM    382  CD  LYS    25       9.658  10.389   1.535  1.00 54.14
ATOM    383 2HD  LYS    25      10.428  10.971   1.028  1.00  0.00
ATOM    384 3HD  LYS    25       8.677  10.687   1.166  1.00  0.00
ATOM    385  CE  LYS    25       9.730  10.668   3.025  1.00 61.02
ATOM    386 2HE  LYS    25       8.994  10.049   3.536  1.00  0.00
ATOM    387 3HE  LYS    25      10.727  10.411   3.385  1.00  0.00
ATOM    388  NZ  LYS    25       9.459  12.095   3.337  1.00 24.04
ATOM    389 1HZ  LYS    25       9.515  12.244   4.334  1.00  0.00
ATOM    390 2HZ  LYS    25      10.143  12.676   2.873  1.00  0.00
ATOM    391 3HZ  LYS    25       8.534  12.340   3.013  1.00  0.00
ATOM    392  C   LYS    25      10.485   7.132  -2.149  1.00 70.34
ATOM    393  O   LYS    25       9.607   6.757  -2.924  1.00 31.33
ATOM    394  N   ARG    26      11.706   7.480  -2.540  1.00 33.41
ATOM    395  HN  ARG    26      12.385   7.772  -1.852  1.00  0.00
ATOM    396  CA  ARG    26      12.112   7.459  -3.940  1.00 75.34
ATOM    397  HA  ARG    26      11.446   8.111  -4.505  1.00  0.00
ATOM    398  CB  ARG    26      13.544   7.987  -4.064  1.00 32.11
ATOM    399 2HB  ARG    26      13.577   8.987  -3.630  1.00  0.00
ATOM    400 3HB  ARG    26      14.201   7.324  -3.501  1.00  0.00
ATOM    401  CG  ARG    26      14.066   8.072  -5.490  1.00 13.24
ATOM    402 2HG  ARG    26      15.118   8.359  -5.464  1.00  0.00
ATOM    403 3HG  ARG    26      13.968   7.094  -5.961  1.00  0.00
ATOM    404  CD  ARG    26      13.299   9.092  -6.313  1.00 22.45
ATOM    405 2HD  ARG    26      12.303   8.702  -6.523  1.00  0.00
ATOM    406 3HD  ARG    26      13.209  10.015  -5.740  1.00  0.00
ATOM    407  NE  ARG    26      13.972   9.382  -7.579  1.00 22.31
ATOM    408  HE  ARG    26      14.692   8.740  -7.879  1.00  0.00
ATOM    409  CZ  ARG    26      13.691  10.432  -8.347  1.00 31.33
ATOM    410  NH1 ARG    26      12.691  11.244  -8.027  1.00 22.21
ATOM    411 1HH1 ARG    26      12.477  12.037  -8.615  1.00  0.00
ATOM    412 2HH1 ARG    26      12.145  11.069  -7.196  1.00  0.00
ATOM    413  NH2 ARG    26      14.399  10.655  -9.444  1.00 51.44
ATOM    414 1HH2 ARG    26      14.184  11.449 -10.031  1.00  0.00
ATOM    415 2HH2 ARG    26      15.154  10.032  -9.694  1.00  0.00
ATOM    416  C   ARG    26      12.016   6.050  -4.512  1.00 35.02
ATOM    417  O   ARG    26      11.545   5.859  -5.629  1.00 22.34
ATOM    418  N   ARG    27      12.457   5.069  -3.735  1.00 44.44
ATOM    419  HN  ARG    27      12.856   5.284  -2.832  1.00  0.00
ATOM    420  CA  ARG    27      12.385   3.673  -4.149  1.00 12.51
ATOM    421  HA  ARG    27      12.882   3.573  -5.114  1.00  0.00
ATOM    422  CB  ARG    27      13.107   2.783  -3.131  1.00 31.11
ATOM    423 2HB  ARG    27      14.164   3.050  -3.131  1.00  0.00
ATOM    424 3HB  ARG    27      12.683   2.976  -2.146  1.00  0.00
ATOM    425  CG  ARG    27      12.989   1.294  -3.420  1.00 32.35
ATOM    426 2HG  ARG    27      11.940   1.005  -3.366  1.00  0.00
ATOM    427 3HG  ARG    27      13.369   1.097  -4.423  1.00  0.00
ATOM    428  CD  ARG    27      13.781   0.468  -2.420  1.00 60.11
ATOM    429 2HD  ARG    27      14.843   0.677  -2.551  1.00  0.00
ATOM    430 3HD  ARG    27      13.482   0.753  -1.411  1.00  0.00
ATOM    431  NE  ARG    27      13.556  -0.964  -2.594  1.00  3.31
ATOM    432  HE  ARG    27      12.608  -1.263  -2.773  1.00  0.00
ATOM    433  CZ  ARG    27      14.515  -1.886  -2.532  1.00 50.51
ATOM    434  NH1 ARG    27      15.778  -1.533  -2.323  1.00 44.43
ATOM    435 1HH1 ARG    27      16.501  -2.237  -2.277  1.00  0.00
ATOM    436 2HH1 ARG    27      16.017  -0.558  -2.210  1.00  0.00
ATOM    437  NH2 ARG    27      14.207  -3.166  -2.680  1.00 61.44
ATOM    438 1HH2 ARG    27      14.932  -3.868  -2.634  1.00  0.00
ATOM    439 2HH2 ARG    27      13.248  -3.439  -2.840  1.00  0.00
ATOM    440  C   ARG    27      10.929   3.241  -4.302  1.00 45.42
ATOM    441  O   ARG    27      10.558   2.608  -5.291  1.00  0.02
ATOM    442  N   ILE    28      10.112   3.600  -3.319  1.00 44.23
ATOM    443  HN  ILE    28      10.482   4.097  -2.521  1.00  0.00
ATOM    444  CA  ILE    28       8.687   3.305  -3.346  1.00  2.21
ATOM    445  HA  ILE    28       8.567   2.223  -3.392  1.00  0.00
ATOM    446  CB  ILE    28       8.003   3.822  -2.059  1.00  5.03
ATOM    447  HB  ILE    28       8.209   4.889  -1.966  1.00  0.00
ATOM    448  CG2 ILE    28       6.496   3.631  -2.123  1.00 64.14
ATOM    449 1HG2 ILE    28       6.035   4.020  -1.215  1.00  0.00
ATOM    450 2HG2 ILE    28       6.100   4.166  -2.986  1.00  0.00
ATOM    451 3HG2 ILE    28       6.269   2.570  -2.218  1.00  0.00
ATOM    452  CG1 ILE    28       8.581   3.106  -0.835  1.00 34.04
ATOM    453 2HG1 ILE    28       8.331   2.048  -0.907  1.00  0.00
ATOM    454 3HG1 ILE    28       9.665   3.226  -0.848  1.00  0.00
ATOM    455  CD1 ILE    28       8.059   3.631   0.487  1.00 51.31
ATOM    456 1HD1 ILE    28       8.504   3.085   1.318  1.00  0.00
ATOM    457 2HD1 ILE    28       8.311   4.688   0.579  1.00  0.00
ATOM    458 3HD1 ILE    28       6.976   3.512   0.519  1.00  0.00
ATOM    459  C   ILE    28       8.017   3.920  -4.578  1.00 52.21
ATOM    460  O   ILE    28       7.316   3.230  -5.323  1.00 25.22
ATOM    461  N   MET    29       8.265   5.207  -4.799  1.00 11.03
ATOM    462  HN  MET    29       8.898   5.706  -4.190  1.00  0.00
ATOM    463  CA  MET    29       7.646   5.938  -5.905  1.00 64.11
ATOM    464  HA  MET    29       6.571   5.767  -5.858  1.00  0.00
ATOM    465  CB  MET    29       7.902   7.441  -5.774  1.00 73.02
ATOM    466 2HB  MET    29       8.976   7.600  -5.671  1.00  0.00
ATOM    467 3HB  MET    29       7.549   7.931  -6.682  1.00  0.00
ATOM    468  CG  MET    29       7.205   8.079  -4.583  1.00 55.12
ATOM    469 2HG  MET    29       6.136   7.880  -4.654  1.00  0.00
ATOM    470 3HG  MET    29       7.585   7.625  -3.668  1.00  0.00
ATOM    471  SD  MET    29       7.457   9.864  -4.491  1.00 72.11
ATOM    472  CE  MET    29       9.242   9.944  -4.348  1.00 32.31
ATOM    473 1HE  MET    29       9.563  10.984  -4.281  1.00  0.00
ATOM    474 2HE  MET    29       9.558   9.411  -3.452  1.00  0.00
ATOM    475 3HE  MET    29       9.697   9.483  -5.225  1.00  0.00
ATOM    476  C   MET    29       8.151   5.448  -7.255  1.00 70.22
ATOM    477  O   MET    29       7.423   5.487  -8.248  1.00 54.45
ATOM    478  N   ASP    30       9.393   4.986  -7.286  1.00 72.31
ATOM    479  HN  ASP    30       9.934   4.946  -6.434  1.00  0.00
ATOM    480  CA  ASP    30      10.016   4.528  -8.525  1.00 42.24
ATOM    481  HA  ASP    30       9.899   5.308  -9.278  1.00  0.00
ATOM    482  CB  ASP    30      11.510   4.276  -8.303  1.00 64.10
ATOM    483 2HB  ASP    30      11.918   5.094  -7.709  1.00  0.00
ATOM    484 3HB  ASP    30      11.630   3.341  -7.757  1.00  0.00
ATOM    485  CG  ASP    30      12.288   4.183  -9.599  1.00  0.52
ATOM    486  OD1 ASP    30      12.325   3.097 -10.207  1.00 34.42
ATOM    487  OD2 ASP    30      12.880   5.204 -10.012  1.00 31.43
ATOM    488 2HD  ASP    30      13.356   5.076 -10.836  1.00  0.00
ATOM    489  C   ASP    30       9.346   3.253  -9.030  1.00  2.22
ATOM    490  O   ASP    30       9.196   3.049 -10.237  1.00 50.42
ATOM    491  N   MET    31       8.927   2.407  -8.095  1.00 23.14
ATOM    492  HN  MET    31       9.043   2.641  -7.120  1.00  0.00
ATOM    493  CA  MET    31       8.298   1.134  -8.434  1.00 53.13
ATOM    494  HA  MET    31       8.886   0.665  -9.224  1.00  0.00
ATOM    495  CB  MET    31       8.279   0.205  -7.219  1.00 21.22
ATOM    496 2HB  MET    31       7.761   0.714  -6.406  1.00  0.00
ATOM    497 3HB  MET    31       7.734  -0.699  -7.488  1.00  0.00
ATOM    498  CG  MET    31       9.658  -0.197  -6.730  1.00 14.11
ATOM    499 2HG  MET    31      10.172  -0.737  -7.525  1.00  0.00
ATOM    500 3HG  MET    31      10.227   0.703  -6.495  1.00  0.00
ATOM    501  SD  MET    31       9.589  -1.245  -5.261  1.00 33.41
ATOM    502  CE  MET    31       8.790  -0.144  -4.094  1.00 40.45
ATOM    503 1HE  MET    31       8.673  -0.642  -3.132  1.00  0.00
ATOM    504 2HE  MET    31       9.400   0.751  -3.964  1.00  0.00
ATOM    505 3HE  MET    31       7.809   0.138  -4.476  1.00  0.00
ATOM    506  C   MET    31       6.874   1.336  -8.942  1.00 30.23
ATOM    507  O   MET    31       6.298   0.443  -9.563  1.00  3.40
ATOM    508  N   GLY    32       6.306   2.503  -8.668  1.00 21.22
ATOM    509  HN  GLY    32       6.813   3.211  -8.155  1.00  0.00
ATOM    510  CA  GLY    32       4.950   2.785  -9.099  1.00  3.34
ATOM    511 1HA  GLY    32       4.975   3.601  -9.822  1.00  0.00
ATOM    512 2HA  GLY    32       4.541   1.894  -9.575  1.00  0.00
ATOM    513  C   GLY    32       4.051   3.180  -7.947  1.00 64.11
ATOM    514  O   GLY    32       3.007   3.807  -8.151  1.00 43.22
ATOM    515  N   ILE    33       4.459   2.820  -6.733  1.00 63.23
ATOM    516  HN  ILE    33       5.320   2.304  -6.623  1.00  0.00
ATOM    517  CA  ILE    33       3.691   3.155  -5.540  1.00 55.11
ATOM    518  HA  ILE    33       2.652   2.875  -5.711  1.00  0.00
ATOM    519  CB  ILE    33       4.204   2.405  -4.292  1.00  3.13
ATOM    520  HB  ILE    33       5.160   2.840  -3.998  1.00  0.00
ATOM    521  CG2 ILE    33       3.223   2.571  -3.138  1.00 72.10
ATOM    522 1HG2 ILE    33       3.605   2.060  -2.255  1.00  0.00
ATOM    523 2HG2 ILE    33       3.100   3.632  -2.917  1.00  0.00
ATOM    524 3HG2 ILE    33       2.260   2.144  -3.417  1.00  0.00
ATOM    525  CG1 ILE    33       4.425   0.918  -4.599  1.00 61.44
ATOM    526 2HG1 ILE    33       5.148   0.840  -5.411  1.00  0.00
ATOM    527 3HG1 ILE    33       4.829   0.441  -3.706  1.00  0.00
ATOM    528  CD1 ILE    33       3.170   0.175  -5.008  1.00 31.52
ATOM    529 1HD1 ILE    33       3.393  -0.872  -5.213  1.00  0.00
ATOM    530 2HD1 ILE    33       2.439   0.233  -4.202  1.00  0.00
ATOM    531 3HD1 ILE    33       2.757   0.634  -5.907  1.00  0.00
ATOM    532  C   ILE    33       3.770   4.657  -5.294  1.00 33.21
ATOM    533  O   ILE    33       4.781   5.170  -4.817  1.00 62.34
ATOM    534  N   THR    34       2.709   5.360  -5.635  1.00 25.14
ATOM    535  HN  THR    34       1.854   4.892  -5.898  1.00  0.00
ATOM    536  CA  THR    34       2.738   6.808  -5.642  1.00 12.13
ATOM    537  HA  THR    34       3.684   7.128  -5.204  1.00  0.00
ATOM    538  CB  THR    34       2.672   7.320  -7.091  1.00  4.45
ATOM    539  HB  THR    34       2.235   8.319  -7.092  1.00  0.00
ATOM    540  OG1 THR    34       1.844   6.445  -7.875  1.00  0.23
ATOM    541 1HG  THR    34       1.801   6.785  -8.772  1.00  0.00
ATOM    542  CG2 THR    34       4.063   7.392  -7.704  1.00 51.22
ATOM    543 1HG2 THR    34       3.999   7.763  -8.727  1.00  0.00
ATOM    544 2HG2 THR    34       4.684   8.067  -7.114  1.00  0.00
ATOM    545 3HG2 THR    34       4.509   6.398  -7.708  1.00  0.00
ATOM    546  C   THR    34       1.605   7.409  -4.819  1.00 63.04
ATOM    547  O   THR    34       0.579   6.769  -4.591  1.00 72.21
ATOM    548  N   ARG    35       1.806   8.637  -4.362  1.00 70.22
ATOM    549  HN  ARG    35       2.674   9.112  -4.564  1.00  0.00
ATOM    550  CA  ARG    35       0.805   9.333  -3.567  1.00 21.30
ATOM    551  HA  ARG    35       0.503   8.682  -2.747  1.00  0.00
ATOM    552  CB  ARG    35       1.396  10.617  -2.978  1.00 35.44
ATOM    553 2HB  ARG    35       1.725  11.254  -3.800  1.00  0.00
ATOM    554 3HB  ARG    35       0.617  11.128  -2.412  1.00  0.00
ATOM    555  CG  ARG    35       2.581  10.373  -2.053  1.00 21.51
ATOM    556 2HG  ARG    35       2.245   9.789  -1.197  1.00  0.00
ATOM    557 3HG  ARG    35       3.344   9.816  -2.597  1.00  0.00
ATOM    558  CD  ARG    35       3.185  11.676  -1.553  1.00 62.41
ATOM    559 2HD  ARG    35       4.070  11.449  -0.958  1.00  0.00
ATOM    560 3HD  ARG    35       3.477  12.282  -2.411  1.00  0.00
ATOM    561  NE  ARG    35       2.248  12.441  -0.732  1.00 44.11
ATOM    562  HE  ARG    35       1.453  11.945  -0.356  1.00  0.00
ATOM    563  CZ  ARG    35       2.381  13.737  -0.455  1.00 13.24
ATOM    564  NH1 ARG    35       3.423  14.417  -0.922  1.00 23.11
ATOM    565 1HH1 ARG    35       3.524  15.399  -0.708  1.00  0.00
ATOM    566 2HH1 ARG    35       4.115  13.952  -1.492  1.00  0.00
ATOM    567  NH2 ARG    35       1.479  14.352   0.301  1.00 72.23
ATOM    568 1HH2 ARG    35       1.583  15.334   0.514  1.00  0.00
ATOM    569 2HH2 ARG    35       0.690  13.838   0.664  1.00  0.00
ATOM    570  C   ARG    35      -0.422   9.648  -4.415  1.00 73.33
ATOM    571  O   ARG    35      -0.386  10.523  -5.282  1.00 41.54
ATOM    572  N   GLY    36      -1.497   8.912  -4.177  1.00 30.55
ATOM    573  HN  GLY    36      -1.479   8.204  -3.457  1.00  0.00
ATOM    574  CA  GLY    36      -2.714   9.102  -4.936  1.00 74.03
ATOM    575 1HA  GLY    36      -3.494   9.458  -4.263  1.00  0.00
ATOM    576 2HA  GLY    36      -2.532   9.853  -5.706  1.00  0.00
ATOM    577  C   GLY    36      -3.188   7.826  -5.601  1.00 15.42
ATOM    578  O   GLY    36      -4.382   7.663  -5.855  1.00 54.02
ATOM    579  N   CYS    37      -2.265   6.913  -5.880  1.00  1.00
ATOM    580  HN  CYS    37      -1.298   7.074  -5.638  1.00  0.00
ATOM    581  CA  CYS    37      -2.627   5.665  -6.538  1.00  3.31
ATOM    582  HA  CYS    37      -3.274   5.903  -7.383  1.00  0.00
ATOM    583  CB  CYS    37      -1.384   4.936  -7.069  1.00 30.24
ATOM    584 2HB  CYS    37      -1.722   4.109  -7.693  1.00  0.00
ATOM    585 3HB  CYS    37      -0.815   5.642  -7.675  1.00  0.00
ATOM    586  SG  CYS    37      -0.291   4.275  -5.788  1.00  4.05
ATOM    587  HG  CYS    37       0.626   3.744  -6.603  1.00  0.00
ATOM    588  C   CYS    37      -3.393   4.765  -5.578  1.00 25.11
ATOM    589  O   CYS    37      -3.124   4.750  -4.371  1.00 71.03
ATOM    590  N   GLU    38      -4.357   4.035  -6.116  1.00 43.32
ATOM    591  HN  GLU    38      -4.556   4.116  -7.103  1.00  0.00
ATOM    592  CA  GLU    38      -5.146   3.110  -5.325  1.00  1.43
ATOM    593  HA  GLU    38      -5.216   3.496  -4.308  1.00  0.00
ATOM    594  CB  GLU    38      -6.561   2.992  -5.899  1.00 52.23
ATOM    595 2HB  GLU    38      -7.131   2.308  -5.271  1.00  0.00
ATOM    596 3HB  GLU    38      -7.025   3.978  -5.877  1.00  0.00
ATOM    597  CG  GLU    38      -6.598   2.477  -7.326  1.00 14.30
ATOM    598 2HG  GLU    38      -5.896   3.056  -7.927  1.00  0.00
ATOM    599 3HG  GLU    38      -6.294   1.431  -7.330  1.00  0.00
ATOM    600  CD  GLU    38      -7.974   2.587  -7.944  1.00 25.15
ATOM    601  OE1 GLU    38      -8.745   1.608  -7.881  1.00 65.40
ATOM    602  OE2 GLU    38      -8.290   3.663  -8.502  1.00 43.44
ATOM    603 2HE  GLU    38      -9.175   3.666  -8.874  1.00  0.00
ATOM    604  C   GLU    38      -4.465   1.751  -5.285  1.00  3.11
ATOM    605  O   GLU    38      -3.884   1.305  -6.279  1.00 71.51
ATOM    606  N   ILE    39      -4.520   1.108  -4.134  1.00 33.21
ATOM    607  HN  ILE    39      -5.015   1.516  -3.354  1.00  0.00
ATOM    608  CA  ILE    39      -3.887  -0.179  -3.950  1.00  2.24
ATOM    609  HA  ILE    39      -3.491  -0.503  -4.913  1.00  0.00
ATOM    610  CB  ILE    39      -2.723  -0.103  -2.938  1.00 41.43
ATOM    611  HB  ILE    39      -3.119   0.242  -1.983  1.00  0.00
ATOM    612  CG2 ILE    39      -2.109  -1.481  -2.735  1.00 50.33
ATOM    613 1HG2 ILE    39      -1.304  -1.420  -2.003  1.00  0.00
ATOM    614 2HG2 ILE    39      -2.874  -2.169  -2.376  1.00  0.00
ATOM    615 3HG2 ILE    39      -1.710  -1.843  -3.682  1.00  0.00
ATOM    616  CG1 ILE    39      -1.661   0.896  -3.409  1.00 52.30
ATOM    617 2HG1 ILE    39      -1.313   0.590  -4.396  1.00  0.00
ATOM    618 3HG1 ILE    39      -2.121   1.882  -3.476  1.00  0.00
ATOM    619  CD1 ILE    39      -0.463   0.989  -2.487  1.00 54.01
ATOM    620 1HD1 ILE    39       0.259   1.711  -2.870  1.00  0.00
ATOM    621 2HD1 ILE    39      -0.793   1.306  -1.498  1.00  0.00
ATOM    622 3HD1 ILE    39       0.014   0.012  -2.416  1.00  0.00
ATOM    623  C   ILE    39      -4.903  -1.201  -3.465  1.00 44.01
ATOM    624  O   ILE    39      -5.476  -1.061  -2.381  1.00  1.54
ATOM    625  N   TYR    40      -5.141  -2.214  -4.279  1.00  3.30
ATOM    626  HN  TYR    40      -4.721  -2.235  -5.197  1.00  0.00
ATOM    627  CA  TYR    40      -6.003  -3.309  -3.883  1.00 63.32
ATOM    628  HA  TYR    40      -6.730  -2.941  -3.159  1.00  0.00
ATOM    629  CB  TYR    40      -6.755  -3.872  -5.092  1.00 45.44
ATOM    630 2HB  TYR    40      -7.108  -3.039  -5.700  1.00  0.00
ATOM    631 3HB  TYR    40      -6.062  -4.469  -5.685  1.00  0.00
ATOM    632  CG  TYR    40      -7.942  -4.736  -4.723  1.00 73.12
ATOM    633  CD1 TYR    40      -9.180  -4.163  -4.471  1.00 62.21
ATOM    634 1HD  TYR    40      -9.292  -3.091  -4.539  1.00  0.00
ATOM    635  CE1 TYR    40     -10.271  -4.938  -4.135  1.00  3.24
ATOM    636 1HE  TYR    40     -11.227  -4.474  -3.944  1.00  0.00
ATOM    637  CZ  TYR    40     -10.135  -6.306  -4.044  1.00 43.21
ATOM    638  CE2 TYR    40      -8.916  -6.902  -4.291  1.00 70.42
ATOM    639 2HE  TYR    40      -8.812  -7.974  -4.223  1.00  0.00
ATOM    640  CD2 TYR    40      -7.827  -6.119  -4.627  1.00 10.11
ATOM    641 2HD  TYR    40      -6.873  -6.588  -4.818  1.00  0.00
ATOM    642  OH  TYR    40     -11.226  -7.077  -3.711  1.00 44.11
ATOM    643  HH  TYR    40     -11.024  -8.015  -3.677  1.00  0.00
ATOM    644  C   TYR    40      -5.154  -4.390  -3.234  1.00 13.02
ATOM    645  O   TYR    40      -4.362  -5.053  -3.909  1.00 51.30
ATOM    646  N   ILE    41      -5.290  -4.538  -1.924  1.00 21.31
ATOM    647  HN  ILE    41      -5.957  -3.972  -1.419  1.00  0.00
ATOM    648  CA  ILE    41      -4.495  -5.508  -1.181  1.00 62.32
ATOM    649  HA  ILE    41      -3.448  -5.366  -1.450  1.00  0.00
ATOM    650  CB  ILE    41      -4.637  -5.328   0.349  1.00 20.44
ATOM    651  HB  ILE    41      -5.601  -5.731   0.657  1.00  0.00
ATOM    652  CG2 ILE    41      -3.533  -6.093   1.074  1.00  2.14
ATOM    653 1HG2 ILE    41      -3.652  -5.978   2.151  1.00  0.00
ATOM    654 2HG2 ILE    41      -3.593  -7.149   0.814  1.00  0.00
ATOM    655 3HG2 ILE    41      -2.562  -5.699   0.773  1.00  0.00
ATOM    656  CG1 ILE    41      -4.584  -3.843   0.731  1.00 64.40
ATOM    657 2HG1 ILE    41      -5.380  -3.323   0.198  1.00  0.00
ATOM    658 3HG1 ILE    41      -4.750  -3.759   1.805  1.00  0.00
ATOM    659  CD1 ILE    41      -3.270  -3.168   0.399  1.00 63.01
ATOM    660 1HD1 ILE    41      -3.293  -2.118   0.691  1.00  0.00
ATOM    661 2HD1 ILE    41      -2.463  -3.669   0.933  1.00  0.00
ATOM    662 3HD1 ILE    41      -3.092  -3.235  -0.674  1.00  0.00
ATOM    663  C   ILE    41      -4.919  -6.920  -1.568  1.00 13.20
ATOM    664  O   ILE    41      -6.043  -7.337  -1.286  1.00 12.23
ATOM    665  N   ARG    42      -4.018  -7.644  -2.216  1.00 23.12
ATOM    666  HN  ARG    42      -3.074  -7.298  -2.317  1.00  0.00
ATOM    667  CA  ARG    42      -4.347  -8.938  -2.797  1.00 33.32
ATOM    668  HA  ARG    42      -5.398  -8.926  -3.084  1.00  0.00
ATOM    669  CB  ARG    42      -3.499  -9.179  -4.053  1.00 51.44
ATOM    670 2HB  ARG    42      -2.452  -9.240  -3.756  1.00  0.00
ATOM    671 3HB  ARG    42      -3.806 -10.124  -4.501  1.00  0.00
ATOM    672  CG  ARG    42      -3.640  -8.082  -5.100  1.00 53.22
ATOM    673 2HG  ARG    42      -3.470  -7.116  -4.624  1.00  0.00
ATOM    674 3HG  ARG    42      -2.893  -8.239  -5.879  1.00  0.00
ATOM    675  CD  ARG    42      -5.020  -8.080  -5.736  1.00  0.31
ATOM    676 2HD  ARG    42      -5.770  -8.205  -4.955  1.00  0.00
ATOM    677 3HD  ARG    42      -5.178  -7.123  -6.235  1.00  0.00
ATOM    678  NE  ARG    42      -5.171  -9.154  -6.713  1.00 34.30
ATOM    679  HE  ARG    42      -4.334  -9.472  -7.180  1.00  0.00
ATOM    680  CZ  ARG    42      -6.331  -9.732  -7.021  1.00 35.42
ATOM    681  NH1 ARG    42      -7.449  -9.360  -6.411  1.00 62.03
ATOM    682 1HH1 ARG    42      -8.326  -9.801  -6.647  1.00  0.00
ATOM    683 2HH1 ARG    42      -7.423  -8.633  -5.710  1.00  0.00
ATOM    684  NH2 ARG    42      -6.371 -10.690  -7.939  1.00 63.43
ATOM    685 1HH2 ARG    42      -7.249 -11.130  -8.173  1.00  0.00
ATOM    686 2HH2 ARG    42      -5.522 -10.979  -8.404  1.00  0.00
ATOM    687  C   ARG    42      -4.132 -10.064  -1.789  1.00 23.04
ATOM    688  O   ARG    42      -5.055 -10.819  -1.484  1.00 30.54
ATOM    689  N   LYS    43      -2.924 -10.163  -1.259  1.00 21.21
ATOM    690  HN  LYS    43      -2.216  -9.477  -1.480  1.00  0.00
ATOM    691  CA  LYS    43      -2.583 -11.250  -0.353  1.00 23.34
ATOM    692  HA  LYS    43      -3.489 -11.562   0.166  1.00  0.00
ATOM    693  CB  LYS    43      -2.038 -12.441  -1.153  1.00 24.53
ATOM    694 2HB  LYS    43      -2.839 -12.821  -1.786  1.00  0.00
ATOM    695 3HB  LYS    43      -1.218 -12.085  -1.778  1.00  0.00
ATOM    696  CG  LYS    43      -1.521 -13.589  -0.299  1.00  2.03
ATOM    697 2HG  LYS    43      -1.134 -14.369  -0.955  1.00  0.00
ATOM    698 3HG  LYS    43      -0.718 -13.219   0.339  1.00  0.00
ATOM    699  CD  LYS    43      -2.612 -14.181   0.577  1.00 65.05
ATOM    700 2HD  LYS    43      -2.981 -13.411   1.255  1.00  0.00
ATOM    701 3HD  LYS    43      -3.427 -14.528  -0.057  1.00  0.00
ATOM    702  CE  LYS    43      -2.085 -15.348   1.392  1.00 31.24
ATOM    703 2HE  LYS    43      -1.771 -16.140   0.712  1.00  0.00
ATOM    704 3HE  LYS    43      -1.226 -15.013   1.973  1.00  0.00
ATOM    705  NZ  LYS    43      -3.111 -15.889   2.319  1.00 73.11
ATOM    706 1HZ  LYS    43      -2.725 -16.661   2.842  1.00  0.00
ATOM    707 2HZ  LYS    43      -3.402 -15.163   2.958  1.00  0.00
ATOM    708 3HZ  LYS    43      -3.908 -16.209   1.787  1.00  0.00
ATOM    709  C   LYS    43      -1.562 -10.798   0.684  1.00 65.14
ATOM    710  O   LYS    43      -0.491 -10.307   0.339  1.00 52.44
ATOM    711  N   VAL    44      -1.904 -10.951   1.953  1.00 34.22
ATOM    712  HN  VAL    44      -2.826 -11.288   2.190  1.00  0.00
ATOM    713  CA  VAL    44      -0.980 -10.644   3.030  1.00 11.25
ATOM    714  HA  VAL    44      -0.116 -10.132   2.606  1.00  0.00
ATOM    715  CB  VAL    44      -1.624  -9.729   4.095  1.00 33.34
ATOM    716  HB  VAL    44      -2.470 -10.260   4.531  1.00  0.00
ATOM    717  CG1 VAL    44      -0.638  -9.411   5.210  1.00 31.30
ATOM    718 1HG1 VAL    44      -1.117  -8.785   5.962  1.00  0.00
ATOM    719 2HG1 VAL    44      -0.303 -10.339   5.673  1.00  0.00
ATOM    720 3HG1 VAL    44       0.220  -8.882   4.795  1.00  0.00
ATOM    721  CG2 VAL    44      -2.143  -8.448   3.463  1.00 31.24
ATOM    722 1HG2 VAL    44      -2.616  -7.825   4.222  1.00  0.00
ATOM    723 2HG2 VAL    44      -1.312  -7.902   3.016  1.00  0.00
ATOM    724 3HG2 VAL    44      -2.872  -8.694   2.691  1.00  0.00
ATOM    725  C   VAL    44      -0.521 -11.935   3.689  1.00  1.33
ATOM    726  O   VAL    44      -1.344 -12.719   4.171  1.00 75.45
ATOM    727  N   ALA    45       0.784 -12.167   3.682  1.00 33.23
ATOM    728  HN  ALA    45       1.411 -11.505   3.246  1.00  0.00
ATOM    729  CA  ALA    45       1.350 -13.362   4.289  1.00  4.52
ATOM    730  HA  ALA    45       0.819 -14.228   3.896  1.00  0.00
ATOM    731  CB  ALA    45       2.821 -13.490   3.924  1.00 33.24
ATOM    732 1HB  ALA    45       3.231 -14.401   4.359  1.00  0.00
ATOM    733 2HB  ALA    45       2.924 -13.529   2.839  1.00  0.00
ATOM    734 3HB  ALA    45       3.367 -12.628   4.309  1.00  0.00
ATOM    735  C   ALA    45       1.174 -13.333   5.806  1.00 31.22
ATOM    736  O   ALA    45       1.238 -12.270   6.420  1.00 73.05
ATOM    770  N   GLY    48       3.404 -11.491   7.989  1.00 30.10
ATOM    771  HN  GLY    48       2.708 -12.044   7.511  1.00  0.00
ATOM    772  CA  GLY    48       3.350 -10.052   7.866  1.00 74.31
ATOM    773 1HA  GLY    48       2.307  -9.737   7.830  1.00  0.00
ATOM    774 2HA  GLY    48       3.833  -9.603   8.734  1.00  0.00
ATOM    775  C   GLY    48       4.051  -9.579   6.613  1.00 24.03
ATOM    776  O   GLY    48       3.814  -8.472   6.133  1.00 15.43
ATOM    777  N   ASP    49       4.903 -10.440   6.079  1.00 11.02
ATOM    778  HN  ASP    49       5.015 -11.352   6.498  1.00  0.00
ATOM    779  CA  ASP    49       5.695 -10.127   4.902  1.00 52.24
ATOM    780  HA  ASP    49       5.179  -9.360   4.324  1.00  0.00
ATOM    781  CB  ASP    49       7.062  -9.593   5.329  1.00 50.22
ATOM    782 2HB  ASP    49       6.916  -8.690   5.922  1.00  0.00
ATOM    783 3HB  ASP    49       7.558 -10.347   5.940  1.00  0.00
ATOM    784  CG  ASP    49       7.950  -9.263   4.152  1.00 14.31
ATOM    785  OD1 ASP    49       7.699  -8.239   3.491  1.00  4.41
ATOM    786  OD2 ASP    49       8.911 -10.016   3.892  1.00 61.05
ATOM    787 2HD  ASP    49       9.432  -9.741   3.134  1.00  0.00
ATOM    788  C   ASP    49       5.863 -11.371   4.037  1.00 11.41
ATOM    789  O   ASP    49       6.006 -12.478   4.563  1.00 62.34
ATOM    790  N   PRO    50       5.823 -11.222   2.702  1.00 53.04
ATOM    791  CD  PRO    50       6.050 -12.295   1.724  1.00  2.02
ATOM    792  CA  PRO    50       5.574  -9.945   2.041  1.00 31.54
ATOM    793  HA  PRO    50       5.968  -9.118   2.633  1.00  0.00
ATOM    794  CB  PRO    50       6.353 -10.099   0.737  1.00 11.21
ATOM    795 2HB  PRO    50       5.927  -9.493  -0.063  1.00  0.00
ATOM    796 3HB  PRO    50       7.393  -9.825   0.916  1.00  0.00
ATOM    797  CG  PRO    50       6.292 -11.561   0.421  1.00 50.44
ATOM    798 2HG  PRO    50       5.435 -11.730  -0.230  1.00  0.00
ATOM    799 3HG  PRO    50       7.212 -11.899  -0.056  1.00  0.00
ATOM    800 2HD  PRO    50       5.190 -12.960   1.646  1.00  0.00
ATOM    801 3HD  PRO    50       6.940 -12.857   2.006  1.00  0.00
ATOM    802  C   PRO    50       4.092  -9.703   1.765  1.00 62.31
ATOM    803  O   PRO    50       3.257 -10.595   1.941  1.00 32.31
ATOM    804  N   ILE    51       3.769  -8.496   1.332  1.00 72.31
ATOM    805  HN  ILE    51       4.486  -7.795   1.205  1.00  0.00
ATOM    806  CA  ILE    51       2.393  -8.145   1.028  1.00 32.51
ATOM    807  HA  ILE    51       1.750  -8.940   1.405  1.00  0.00
ATOM    808  CB  ILE    51       1.989  -6.822   1.716  1.00 15.23
ATOM    809  HB  ILE    51       2.664  -6.036   1.376  1.00  0.00
ATOM    810  CG2 ILE    51       0.565  -6.425   1.342  1.00 14.23
ATOM    811 1HG2 ILE    51       0.306  -5.481   1.822  1.00  0.00
ATOM    812 2HG2 ILE    51       0.493  -6.311   0.260  1.00  0.00
ATOM    813 3HG2 ILE    51      -0.126  -7.200   1.672  1.00  0.00
ATOM    814  CG1 ILE    51       2.127  -6.960   3.234  1.00 60.52
ATOM    815 2HG1 ILE    51       1.470  -7.763   3.567  1.00  0.00
ATOM    816 3HG1 ILE    51       3.161  -7.217   3.463  1.00  0.00
ATOM    817  CD1 ILE    51       1.768  -5.703   3.996  1.00 22.22
ATOM    818 1HD1 ILE    51       1.884  -5.859   5.068  1.00  0.00
ATOM    819 2HD1 ILE    51       2.424  -4.891   3.681  1.00  0.00
ATOM    820 3HD1 ILE    51       0.733  -5.436   3.783  1.00  0.00
ATOM    821  C   ILE    51       2.190  -8.028  -0.481  1.00 72.54
ATOM    822  O   ILE    51       2.812  -7.192  -1.138  1.00 22.10
ATOM    823  N   GLN    52       1.333  -8.884  -1.025  1.00 34.43
ATOM    824  HN  GLN    52       0.876  -9.571  -0.443  1.00  0.00
ATOM    825  CA  GLN    52       1.024  -8.869  -2.448  1.00 15.41
ATOM    826  HA  GLN    52       1.927  -8.589  -2.991  1.00  0.00
ATOM    827  CB  GLN    52       0.566 -10.252  -2.938  1.00 71.34
ATOM    828 2HB  GLN    52      -0.198 -10.618  -2.252  1.00  0.00
ATOM    829 3HB  GLN    52       0.135 -10.133  -3.932  1.00  0.00
ATOM    830  CG  GLN    52       1.670 -11.305  -3.023  1.00  4.11
ATOM    831 2HG  GLN    52       1.285 -12.166  -3.569  1.00  0.00
ATOM    832 3HG  GLN    52       2.511 -10.880  -3.571  1.00  0.00
ATOM    833  CD  GLN    52       2.168 -11.777  -1.668  1.00 53.41
ATOM    834  OE1 GLN    52       1.624 -12.713  -1.088  1.00  5.20
ATOM    835  NE2 GLN    52       3.228 -11.162  -1.176  1.00 34.13
ATOM    836 1HE2 GLN    52       3.653 -10.405  -1.692  1.00  0.00
ATOM    837 2HE2 GLN    52       3.611 -11.449  -0.287  1.00  0.00
ATOM    838  C   GLN    52      -0.063  -7.842  -2.733  1.00 61.21
ATOM    839  O   GLN    52      -1.165  -7.916  -2.182  1.00  0.50
ATOM    840  N   ILE    53       0.252  -6.888  -3.590  1.00 42.44
ATOM    841  HN  ILE    53       1.160  -6.894  -4.034  1.00  0.00
ATOM    842  CA  ILE    53      -0.670  -5.816  -3.924  1.00 13.15
ATOM    843  HA  ILE    53      -1.668  -6.117  -3.607  1.00  0.00
ATOM    844  CB  ILE    53      -0.298  -4.502  -3.199  1.00 55.32
ATOM    845  HB  ILE    53      -0.931  -3.705  -3.590  1.00  0.00
ATOM    846  CG2 ILE    53      -0.555  -4.625  -1.703  1.00 54.10
ATOM    847 1HG2 ILE    53      -0.312  -3.684  -1.209  1.00  0.00
ATOM    848 2HG2 ILE    53      -1.605  -4.861  -1.534  1.00  0.00
ATOM    849 3HG2 ILE    53       0.067  -5.420  -1.293  1.00  0.00
ATOM    850  CG1 ILE    53       1.165  -4.130  -3.471  1.00 73.23
ATOM    851 2HG1 ILE    53       1.800  -4.927  -3.085  1.00  0.00
ATOM    852 3HG1 ILE    53       1.304  -4.044  -4.549  1.00  0.00
ATOM    853  CD1 ILE    53       1.594  -2.826  -2.830  1.00 42.51
ATOM    854 1HD1 ILE    53       2.640  -2.614  -3.056  1.00  0.00
ATOM    855 2HD1 ILE    53       0.975  -2.015  -3.214  1.00  0.00
ATOM    856 3HD1 ILE    53       1.470  -2.897  -1.750  1.00  0.00
ATOM    857  C   ILE    53      -0.685  -5.570  -5.426  1.00  4.23
ATOM    858  O   ILE    53       0.305  -5.821  -6.114  1.00 23.24
ATOM    859  N   ASN    54      -1.813  -5.098  -5.931  1.00  5.12
ATOM    860  HN  ASN    54      -2.615  -4.958  -5.334  1.00  0.00
ATOM    861  CA  ASN    54      -1.930  -4.769  -7.343  1.00 30.22
ATOM    862  HA  ASN    54      -1.030  -5.111  -7.855  1.00  0.00
ATOM    863  CB  ASN    54      -3.142  -5.471  -7.968  1.00 62.43
ATOM    864 2HB  ASN    54      -3.110  -6.526  -7.697  1.00  0.00
ATOM    865 3HB  ASN    54      -4.050  -5.023  -7.564  1.00  0.00
ATOM    866  CG  ASN    54      -3.182  -5.360  -9.486  1.00 23.35
ATOM    867  OD1 ASN    54      -2.770  -4.358 -10.072  1.00 35.11
ATOM    868  ND2 ASN    54      -3.672  -6.405 -10.138  1.00 41.54
ATOM    869 1HD2 ASN    54      -3.996  -7.211  -9.624  1.00  0.00
ATOM    870 2HD2 ASN    54      -3.719  -6.393 -11.147  1.00  0.00
ATOM    871  C   ASN    54      -2.039  -3.262  -7.502  1.00 22.34
ATOM    872  O   ASN    54      -3.026  -2.650  -7.083  1.00 73.05
ATOM    873  N   VAL    55      -1.006  -2.671  -8.082  1.00 75.43
ATOM    874  HN  VAL    55      -0.240  -3.232  -8.426  1.00  0.00
ATOM    875  CA  VAL    55      -0.928  -1.229  -8.246  1.00 71.34
ATOM    876  HA  VAL    55      -1.902  -0.804  -8.003  1.00  0.00
ATOM    877  CB  VAL    55       0.133  -0.606  -7.310  1.00 33.34
ATOM    878  HB  VAL    55       1.113  -0.967  -7.622  1.00  0.00
ATOM    879  CG1 VAL    55       0.132   0.912  -7.419  1.00 22.32
ATOM    880 1HG1 VAL    55       0.903   1.331  -6.772  1.00  0.00
ATOM    881 2HG1 VAL    55       0.331   1.202  -8.451  1.00  0.00
ATOM    882 3HG1 VAL    55      -0.842   1.297  -7.116  1.00  0.00
ATOM    883  CG2 VAL    55      -0.094  -1.039  -5.872  1.00 73.44
ATOM    884 1HG2 VAL    55       0.678  -0.612  -5.231  1.00  0.00
ATOM    885 2HG2 VAL    55      -1.072  -0.692  -5.540  1.00  0.00
ATOM    886 3HG2 VAL    55      -0.054  -2.126  -5.811  1.00  0.00
ATOM    887  C   VAL    55      -0.581  -0.881  -9.688  1.00 52.14
ATOM    888  O   VAL    55       0.349  -1.448 -10.263  1.00 20.40
ATOM    889  N   ARG    56      -1.348   0.041 -10.269  1.00 30.54
ATOM    890  HN  ARG    56      -2.121   0.437  -9.754  1.00  0.00
ATOM    891  CA  ARG    56      -1.120   0.514 -11.639  1.00 51.31
ATOM    892  HA  ARG    56      -1.862   1.282 -11.857  1.00  0.00
ATOM    893  CB  ARG    56       0.277   1.135 -11.773  1.00 23.31
ATOM    894 2HB  ARG    56       1.016   0.360 -11.570  1.00  0.00
ATOM    895 3HB  ARG    56       0.395   1.490 -12.797  1.00  0.00
ATOM    896  CG  ARG    56       0.541   2.303 -10.832  1.00 62.31
ATOM    897 2HG  ARG    56       0.416   1.963  -9.804  1.00  0.00
ATOM    898 3HG  ARG    56       1.564   2.650 -10.978  1.00  0.00
ATOM    899  CD  ARG    56      -0.411   3.460 -11.087  1.00 42.41
ATOM    900 2HD  ARG    56      -0.399   3.701 -12.150  1.00  0.00
ATOM    901 3HD  ARG    56      -1.418   3.160 -10.800  1.00  0.00
ATOM    902  NE  ARG    56      -0.036   4.653 -10.326  1.00  4.24
ATOM    903  HE  ARG    56       0.587   4.524  -9.541  1.00  0.00
ATOM    904  CZ  ARG    56      -0.465   5.885 -10.609  1.00 43.14
ATOM    905  NH1 ARG    56      -1.314   6.077 -11.610  1.00 63.41
ATOM    906 1HH1 ARG    56      -1.640   7.009 -11.825  1.00  0.00
ATOM    907 2HH1 ARG    56      -1.634   5.292 -12.158  1.00  0.00
ATOM    908  NH2 ARG    56      -0.049   6.924  -9.892  1.00 51.54
ATOM    909 1HH2 ARG    56      -0.377   7.855 -10.110  1.00  0.00
ATOM    910 2HH2 ARG    56       0.597   6.784  -9.128  1.00  0.00
ATOM    911  C   ARG    56      -1.282  -0.618 -12.658  1.00  4.53
ATOM    912  O   ARG    56      -0.865  -0.492 -13.809  1.00 23.23
ATOM    913  N   GLY    57      -1.895  -1.715 -12.233  1.00 73.14
ATOM    914  HN  GLY    57      -2.234  -1.773 -11.284  1.00  0.00
ATOM    915  CA  GLY    57      -2.091  -2.848 -13.115  1.00 35.31
ATOM    916 1HA  GLY    57      -3.079  -3.269 -12.931  1.00  0.00
ATOM    917 2HA  GLY    57      -2.032  -2.503 -14.148  1.00  0.00
ATOM    918  C   GLY    57      -1.051  -3.927 -12.900  1.00 64.14
ATOM    919  O   GLY    57      -1.142  -5.016 -13.474  1.00 42.35
ATOM    920  N   TYR    58      -0.058  -3.632 -12.072  1.00  2.31
ATOM    921  HN  TYR    58      -0.016  -2.720 -11.639  1.00  0.00
ATOM    922  CA  TYR    58       0.987  -4.594 -11.767  1.00 75.35
ATOM    923  HA  TYR    58       0.988  -5.367 -12.535  1.00  0.00
ATOM    924  CB  TYR    58       2.360  -3.910 -11.743  1.00 75.12
ATOM    925 2HB  TYR    58       2.411  -3.270 -10.862  1.00  0.00
ATOM    926 3HB  TYR    58       3.128  -4.679 -11.662  1.00  0.00
ATOM    927  CG  TYR    58       2.658  -3.066 -12.963  1.00 71.43
ATOM    928  CD1 TYR    58       2.429  -1.695 -12.953  1.00 24.05
ATOM    929 1HD  TYR    58       2.032  -1.230 -12.063  1.00  0.00
ATOM    930  CE1 TYR    58       2.701  -0.916 -14.061  1.00 21.41
ATOM    931 1HE  TYR    58       2.519   0.149 -14.035  1.00  0.00
ATOM    932  CZ  TYR    58       3.206  -1.504 -15.198  1.00 52.22
ATOM    933  CE2 TYR    58       3.443  -2.864 -15.233  1.00 71.21
ATOM    934 2HE  TYR    58       3.842  -3.322 -16.126  1.00  0.00
ATOM    935  CD2 TYR    58       3.168  -3.636 -14.120  1.00 63.43
ATOM    936 2HD  TYR    58       3.354  -4.699 -14.152  1.00  0.00
ATOM    937  OH  TYR    58       3.481  -0.729 -16.301  1.00  1.03
ATOM    938  HH  TYR    58       3.830  -1.236 -17.038  1.00  0.00
ATOM    939  C   TYR    58       0.718  -5.230 -10.411  1.00 14.14
ATOM    940  O   TYR    58       0.517  -4.528  -9.421  1.00 11.24
ATOM    941  N   GLU    59       0.726  -6.549 -10.364  1.00 53.21
ATOM    942  HN  GLU    59       0.863  -7.086 -11.208  1.00  0.00
ATOM    943  CA  GLU    59       0.542  -7.253  -9.111  1.00 72.32
ATOM    944  HA  GLU    59       0.152  -6.552  -8.373  1.00  0.00
ATOM    945  CB  GLU    59      -0.464  -8.384  -9.277  1.00 21.34
ATOM    946 2HB  GLU    59      -1.363  -7.975  -9.737  1.00  0.00
ATOM    947 3HB  GLU    59      -0.028  -9.135  -9.936  1.00  0.00
ATOM    948  CG  GLU    59      -0.860  -9.063  -7.978  1.00 50.34
ATOM    949 2HG  GLU    59       0.004  -9.596  -7.582  1.00  0.00
ATOM    950 3HG  GLU    59      -1.169  -8.301  -7.263  1.00  0.00
ATOM    951  CD  GLU    59      -1.997 -10.046  -8.169  1.00 11.43
ATOM    952  OE1 GLU    59      -1.748 -11.270  -8.169  1.00 32.42
ATOM    953  OE2 GLU    59      -3.148  -9.597  -8.329  1.00 24.44
ATOM    954 2HE  GLU    59      -3.819 -10.272  -8.447  1.00  0.00
ATOM    955  C   GLU    59       1.883  -7.773  -8.626  1.00 14.44
ATOM    956  O   GLU    59       2.507  -8.630  -9.254  1.00 31.01
ATOM    957  N   LEU    60       2.317  -7.241  -7.510  1.00 74.52
ATOM    958  HN  LEU    60       1.712  -6.636  -6.972  1.00  0.00
ATOM    959  CA  LEU    60       3.660  -7.496  -7.014  1.00 72.24
ATOM    960  HA  LEU    60       4.021  -8.417  -7.471  1.00  0.00
ATOM    961  CB  LEU    60       4.599  -6.347  -7.428  1.00 22.23
ATOM    962 2HB  LEU    60       5.542  -6.478  -6.896  1.00  0.00
ATOM    963 3HB  LEU    60       4.773  -6.429  -8.501  1.00  0.00
ATOM    964  CG  LEU    60       4.092  -4.922  -7.141  1.00 32.14
ATOM    965  HG  LEU    60       3.029  -4.886  -7.378  1.00  0.00
ATOM    966  CD1 LEU    60       4.262  -4.554  -5.672  1.00 70.41
ATOM    967 1HD1 LEU    60       3.877  -3.550  -5.492  1.00  0.00
ATOM    968 2HD1 LEU    60       3.714  -5.266  -5.055  1.00  0.00
ATOM    969 3HD1 LEU    60       5.320  -4.585  -5.411  1.00  0.00
ATOM    970  CD2 LEU    60       4.813  -3.917  -8.025  1.00 62.34
ATOM    971 1HD2 LEU    60       4.428  -2.915  -7.836  1.00  0.00
ATOM    972 2HD2 LEU    60       5.881  -3.940  -7.805  1.00  0.00
ATOM    973 3HD2 LEU    60       4.652  -4.174  -9.072  1.00  0.00
ATOM    974  C   LEU    60       3.667  -7.679  -5.505  1.00  2.23
ATOM    975  O   LEU    60       2.642  -7.519  -4.844  1.00 52.31
ATOM    976  N   SER    61       4.828  -8.020  -4.972  1.00 74.25
ATOM    977  HN  SER    61       5.627  -8.181  -5.569  1.00  0.00
ATOM    978  CA  SER    61       4.995  -8.170  -3.542  1.00 63.23
ATOM    979  HA  SER    61       4.012  -8.161  -3.072  1.00  0.00
ATOM    980  CB  SER    61       5.683  -9.497  -3.229  1.00 42.21
ATOM    981 2HB  SER    61       6.687  -9.486  -3.654  1.00  0.00
ATOM    982 3HB  SER    61       5.748  -9.618  -2.148  1.00  0.00
ATOM    983  OG  SER    61       4.962 -10.591  -3.774  1.00 23.41
ATOM    984  HG  SER    61       5.421 -11.406  -3.559  1.00  0.00
ATOM    985  C   SER    61       5.819  -7.015  -2.991  1.00 23.22
ATOM    986  O   SER    61       6.931  -6.758  -3.455  1.00 22.24
ATOM    987  N   LEU    62       5.266  -6.313  -2.021  1.00 12.43
ATOM    988  HN  LEU    62       4.330  -6.531  -1.711  1.00  0.00
ATOM    989  CA  LEU    62       5.971  -5.222  -1.377  1.00 51.32
ATOM    990  HA  LEU    62       6.855  -4.980  -1.968  1.00  0.00
ATOM    991  CB  LEU    62       5.083  -3.979  -1.295  1.00 61.11
ATOM    992 2HB  LEU    62       4.769  -3.723  -2.307  1.00  0.00
ATOM    993 3HB  LEU    62       4.209  -4.229  -0.695  1.00  0.00
ATOM    994  CG  LEU    62       5.742  -2.741  -0.677  1.00 32.54
ATOM    995  HG  LEU    62       6.151  -3.019   0.294  1.00  0.00
ATOM    996  CD1 LEU    62       6.885  -2.240  -1.549  1.00 41.21
ATOM    997 1HD1 LEU    62       7.354  -1.372  -1.084  1.00  0.00
ATOM    998 2HD1 LEU    62       7.626  -3.031  -1.665  1.00  0.00
ATOM    999 3HD1 LEU    62       6.498  -1.959  -2.529  1.00  0.00
ATOM   1000  CD2 LEU    62       4.713  -1.644  -0.467  1.00 23.13
ATOM   1001 1HD2 LEU    62       5.186  -0.777  -0.005  1.00  0.00
ATOM   1002 2HD2 LEU    62       4.291  -1.354  -1.429  1.00  0.00
ATOM   1003 3HD2 LEU    62       3.919  -2.011   0.183  1.00  0.00
ATOM   1004  C   LEU    62       6.408  -5.654   0.011  1.00 31.25
ATOM   1005  O   LEU    62       5.637  -6.276   0.748  1.00 74.34
ATOM   1006  N   ARG    63       7.653  -5.354   0.346  1.00 72.31
ATOM   1007  HN  ARG    63       8.242  -4.855  -0.306  1.00  0.00
ATOM   1008  CA  ARG    63       8.209  -5.723   1.634  1.00  1.32
ATOM   1009  HA  ARG    63       8.070  -6.794   1.778  1.00  0.00
ATOM   1010  CB  ARG    63       9.705  -5.411   1.673  1.00 14.24
ATOM   1011 2HB  ARG    63      10.103  -5.508   0.663  1.00  0.00
ATOM   1012 3HB  ARG    63       9.833  -4.384   2.017  1.00  0.00
ATOM   1013  CG  ARG    63      10.497  -6.325   2.590  1.00 34.41
ATOM   1014 2HG  ARG    63      11.554  -6.068   2.522  1.00  0.00
ATOM   1015 3HG  ARG    63      10.155  -6.184   3.615  1.00  0.00
ATOM   1016  CD  ARG    63      10.315  -7.783   2.201  1.00 15.20
ATOM   1017 2HD  ARG    63      10.006  -8.343   3.083  1.00  0.00
ATOM   1018 3HD  ARG    63       9.534  -7.846   1.444  1.00  0.00
ATOM   1019  NE  ARG    63      11.532  -8.390   1.667  1.00 23.14
ATOM   1020  HE  ARG    63      12.225  -7.771   1.268  1.00  0.00
ATOM   1021  CZ  ARG    63      11.769  -9.703   1.681  1.00 34.00
ATOM   1022  NH1 ARG    63      10.905 -10.538   2.250  1.00 30.12
ATOM   1023 1HH1 ARG    63      11.093 -11.530   2.262  1.00  0.00
ATOM   1024 2HH1 ARG    63      10.060 -10.179   2.670  1.00  0.00
ATOM   1025  NH2 ARG    63      12.885 -10.177   1.142  1.00 65.32
ATOM   1026 1HH2 ARG    63      13.070 -11.169   1.156  1.00  0.00
ATOM   1027 2HH2 ARG    63      13.550  -9.545   0.718  1.00  0.00
ATOM   1028  C   ARG    63       7.490  -4.979   2.751  1.00 54.04
ATOM   1029  O   ARG    63       7.207  -3.782   2.631  1.00 41.32
ATOM   1030  N   LYS    64       7.194  -5.697   3.826  1.00 42.41
ATOM   1031  HN  LYS    64       7.451  -6.673   3.857  1.00  0.00
ATOM   1032  CA  LYS    64       6.506  -5.131   4.978  1.00 13.22
ATOM   1033  HA  LYS    64       5.521  -4.794   4.656  1.00  0.00
ATOM   1034  CB  LYS    64       6.322  -6.207   6.060  1.00 51.34
ATOM   1035 2HB  LYS    64       5.863  -7.080   5.597  1.00  0.00
ATOM   1036 3HB  LYS    64       7.306  -6.474   6.446  1.00  0.00
ATOM   1037  CG  LYS    64       5.451  -5.776   7.233  1.00 41.41
ATOM   1038 2HG  LYS    64       4.672  -5.108   6.865  1.00  0.00
ATOM   1039 3HG  LYS    64       4.993  -6.660   7.674  1.00  0.00
ATOM   1040  CD  LYS    64       6.251  -5.053   8.304  1.00 32.31
ATOM   1041 2HD  LYS    64       7.058  -4.497   7.826  1.00  0.00
ATOM   1042 3HD  LYS    64       5.593  -4.359   8.827  1.00  0.00
ATOM   1043  CE  LYS    64       6.850  -6.018   9.314  1.00 34.43
ATOM   1044 2HE  LYS    64       6.045  -6.569   9.799  1.00  0.00
ATOM   1045 3HE  LYS    64       7.501  -6.719   8.792  1.00  0.00
ATOM   1046  NZ  LYS    64       7.640  -5.305  10.350  1.00 21.10
ATOM   1047 1HZ  LYS    64       8.024  -5.972  11.004  1.00  0.00
ATOM   1048 2HZ  LYS    64       8.393  -4.797   9.908  1.00  0.00
ATOM   1049 3HZ  LYS    64       7.042  -4.658  10.843  1.00  0.00
ATOM   1050  C   LYS    64       7.270  -3.928   5.525  1.00 20.34
ATOM   1051  O   LYS    64       6.670  -3.002   6.063  1.00 13.53
ATOM   1052  N   SER    65       8.588  -3.943   5.363  1.00 44.33
ATOM   1053  HN  SER    65       9.030  -4.744   4.935  1.00  0.00
ATOM   1054  CA  SER    65       9.431  -2.832   5.783  1.00 15.40
ATOM   1055  HA  SER    65       9.404  -2.762   6.870  1.00  0.00
ATOM   1056  CB  SER    65      10.867  -3.094   5.338  1.00  2.23
ATOM   1057 2HB  SER    65      10.933  -2.985   4.255  1.00  0.00
ATOM   1058 3HB  SER    65      11.529  -2.372   5.817  1.00  0.00
ATOM   1059  OG  SER    65      11.268  -4.405   5.700  1.00 32.21
ATOM   1060  HG  SER    65      12.173  -4.543   5.409  1.00  0.00
ATOM   1061  C   SER    65       8.924  -1.516   5.191  1.00 13.15
ATOM   1062  O   SER    65       8.802  -0.514   5.895  1.00 62.15
ATOM   1063  N   ALA    66       8.615  -1.536   3.898  1.00 34.10
ATOM   1064  HN  ALA    66       8.753  -2.380   3.362  1.00  0.00
ATOM   1065  CA  ALA    66       8.079  -0.366   3.220  1.00 54.22
ATOM   1066  HA  ALA    66       8.640   0.508   3.552  1.00  0.00
ATOM   1067  CB  ALA    66       8.249  -0.505   1.715  1.00 24.42
ATOM   1068 1HB  ALA    66       7.870   0.388   1.217  1.00  0.00
ATOM   1069 2HB  ALA    66       9.306  -0.628   1.479  1.00  0.00
ATOM   1070 3HB  ALA    66       7.695  -1.376   1.366  1.00  0.00
ATOM   1071  C   ALA    66       6.610  -0.163   3.576  1.00 45.41
ATOM   1072  O   ALA    66       6.182   0.951   3.870  1.00 32.23
ATOM   1073  N   ALA    67       5.848  -1.255   3.566  1.00 75.31
ATOM   1074  HN  ALA    67       6.265  -2.150   3.353  1.00  0.00
ATOM   1075  CA  ALA    67       4.412  -1.212   3.853  1.00  4.20
ATOM   1076  HA  ALA    67       3.935  -0.590   3.095  1.00  0.00
ATOM   1077  CB  ALA    67       3.818  -2.609   3.784  1.00 33.13
ATOM   1078 1HB  ALA    67       2.745  -2.564   3.967  1.00  0.00
ATOM   1079 2HB  ALA    67       3.998  -3.030   2.795  1.00  0.00
ATOM   1080 3HB  ALA    67       4.288  -3.240   4.538  1.00  0.00
ATOM   1081  C   ALA    67       4.131  -0.608   5.223  1.00 73.35
ATOM   1082  O   ALA    67       3.103   0.033   5.438  1.00 14.33
ATOM   1083  N   GLU    68       5.055  -0.821   6.144  1.00 44.23
ATOM   1084  HN  GLU    68       5.899  -1.318   5.897  1.00  0.00
ATOM   1085  CA  GLU    68       4.904  -0.361   7.514  1.00 44.40
ATOM   1086  HA  GLU    68       3.871  -0.520   7.823  1.00  0.00
ATOM   1087  CB  GLU    68       5.824  -1.174   8.424  1.00 14.11
ATOM   1088 2HB  GLU    68       5.845  -2.202   8.063  1.00  0.00
ATOM   1089 3HB  GLU    68       6.827  -0.749   8.368  1.00  0.00
ATOM   1090  CG  GLU    68       5.390  -1.185   9.873  1.00 61.13
ATOM   1091 2HG  GLU    68       5.224  -0.157  10.197  1.00  0.00
ATOM   1092 3HG  GLU    68       4.458  -1.743   9.956  1.00  0.00
ATOM   1093  CD  GLU    68       6.421  -1.821  10.779  1.00 20.11
ATOM   1094  OE1 GLU    68       6.416  -3.060  10.913  1.00 34.45
ATOM   1095  OE2 GLU    68       7.250  -1.081  11.348  1.00 62.33
ATOM   1096 2HE  GLU    68       7.877  -1.550  11.904  1.00  0.00
ATOM   1097  C   GLU    68       5.227   1.129   7.630  1.00 75.25
ATOM   1098  O   GLU    68       4.959   1.757   8.653  1.00 10.11
ATOM   1099  N   MET    69       5.792   1.690   6.570  1.00 20.45
ATOM   1100  HN  MET    69       5.949   1.146   5.734  1.00  0.00
ATOM   1101  CA  MET    69       6.201   3.088   6.577  1.00 54.12
ATOM   1102  HA  MET    69       6.113   3.468   7.595  1.00  0.00
ATOM   1103  CB  MET    69       7.663   3.203   6.133  1.00 20.41
ATOM   1104 2HB  MET    69       8.232   2.415   6.625  1.00  0.00
ATOM   1105 3HB  MET    69       7.704   3.061   5.053  1.00  0.00
ATOM   1106  CG  MET    69       8.317   4.539   6.462  1.00 42.02
ATOM   1107 2HG  MET    69       9.191   4.667   5.822  1.00  0.00
ATOM   1108 3HG  MET    69       7.607   5.338   6.246  1.00  0.00
ATOM   1109  SD  MET    69       8.840   4.681   8.189  1.00  4.42
ATOM   1110  CE  MET    69       7.274   4.758   9.061  1.00 63.43
ATOM   1111 1HE  MET    69       7.440   4.847  10.134  1.00  0.00
ATOM   1112 2HE  MET    69       6.710   5.624   8.714  1.00  0.00
ATOM   1113 3HE  MET    69       6.705   3.851   8.861  1.00  0.00
ATOM   1114  C   MET    69       5.301   3.925   5.664  1.00 71.11
ATOM   1115  O   MET    69       5.238   5.151   5.783  1.00 34.42
ATOM   1116  N   ILE    70       4.608   3.255   4.751  1.00 71.51
ATOM   1117  HN  ILE    70       4.694   2.250   4.696  1.00  0.00
ATOM   1118  CA  ILE    70       3.716   3.924   3.814  1.00 12.23
ATOM   1119  HA  ILE    70       4.222   4.819   3.449  1.00  0.00
ATOM   1120  CB  ILE    70       3.390   3.017   2.604  1.00 13.04
ATOM   1121  HB  ILE    70       2.984   2.078   2.979  1.00  0.00
ATOM   1122  CG2 ILE    70       2.346   3.661   1.701  1.00 31.32
ATOM   1123 1HG2 ILE    70       2.117   2.997   0.867  1.00  0.00
ATOM   1124 2HG2 ILE    70       1.438   3.848   2.274  1.00  0.00
ATOM   1125 3HG2 ILE    70       2.733   4.605   1.315  1.00  0.00
ATOM   1126  CG1 ILE    70       4.666   2.712   1.818  1.00 34.52
ATOM   1127 2HG1 ILE    70       5.076   3.653   1.449  1.00  0.00
ATOM   1128 3HG1 ILE    70       5.382   2.244   2.493  1.00  0.00
ATOM   1129  CD1 ILE    70       4.452   1.790   0.637  1.00 53.12
ATOM   1130 1HD1 ILE    70       5.393   1.611   0.116  1.00  0.00
ATOM   1131 2HD1 ILE    70       4.053   0.840   0.990  1.00  0.00
ATOM   1132 3HD1 ILE    70       3.744   2.248  -0.054  1.00  0.00
ATOM   1133  C   ILE    70       2.420   4.343   4.499  1.00 22.13
ATOM   1134  O   ILE    70       1.825   3.569   5.249  1.00  5.50
ATOM   1135  N   GLU    71       1.996   5.573   4.234  1.00 74.54
ATOM   1136  HN  GLU    71       2.534   6.165   3.617  1.00  0.00
ATOM   1137  CA  GLU    71       0.770   6.106   4.805  1.00 62.40
ATOM   1138  HA  GLU    71       0.511   5.522   5.688  1.00  0.00
ATOM   1139  CB  GLU    71       0.975   7.565   5.218  1.00  4.32
ATOM   1140 2HB  GLU    71       1.811   7.610   5.916  1.00  0.00
ATOM   1141 3HB  GLU    71       1.217   8.144   4.326  1.00  0.00
ATOM   1142  CG  GLU    71      -0.237   8.195   5.882  1.00  4.43
ATOM   1143 2HG  GLU    71      -0.751   8.822   5.153  1.00  0.00
ATOM   1144 3HG  GLU    71      -0.909   7.403   6.211  1.00  0.00
ATOM   1145  CD  GLU    71       0.136   9.044   7.076  1.00 71.52
ATOM   1146  OE1 GLU    71       0.853   8.545   7.968  1.00 64.22
ATOM   1147  OE2 GLU    71      -0.289  10.214   7.135  1.00 11.53
ATOM   1148 2HE  GLU    71      -0.014  10.694   7.920  1.00  0.00
ATOM   1149  C   GLU    71      -0.366   6.006   3.792  1.00 30.13
ATOM   1150  O   GLU    71      -0.350   6.672   2.752  1.00 22.31
ATOM   1151  N   VAL    72      -1.343   5.166   4.091  1.00 24.24
ATOM   1152  HN  VAL    72      -1.307   4.640   4.952  1.00  0.00
ATOM   1153  CA  VAL    72      -2.481   4.974   3.208  1.00 73.40
ATOM   1154  HA  VAL    72      -2.415   5.715   2.411  1.00  0.00
ATOM   1155  CB  VAL    72      -2.490   3.566   2.570  1.00 61.32
ATOM   1156  HB  VAL    72      -3.380   3.484   1.946  1.00  0.00
ATOM   1157  CG1 VAL    72      -1.272   3.362   1.683  1.00 52.44
ATOM   1158 1HG1 VAL    72      -1.309   2.375   1.222  1.00  0.00
ATOM   1159 2HG1 VAL    72      -1.260   4.124   0.903  1.00  0.00
ATOM   1160 3HG1 VAL    72      -0.367   3.445   2.285  1.00  0.00
ATOM   1161  CG2 VAL    72      -2.562   2.485   3.642  1.00  5.02
ATOM   1162 1HG2 VAL    72      -2.594   1.501   3.174  1.00  0.00
ATOM   1163 2HG2 VAL    72      -1.682   2.552   4.283  1.00  0.00
ATOM   1164 3HG2 VAL    72      -3.460   2.630   4.242  1.00  0.00
ATOM   1165  C   VAL    72      -3.783   5.181   3.964  1.00 64.04
ATOM   1166  O   VAL    72      -3.787   5.310   5.188  1.00 22.25
ATOM   1167  N   GLU    73      -4.880   5.220   3.230  1.00 45.33
ATOM   1168  HN  GLU    73      -4.815   5.170   2.223  1.00  0.00
ATOM   1169  CA  GLU    73      -6.195   5.333   3.835  1.00 65.41
ATOM   1170  HA  GLU    73      -6.083   5.265   4.917  1.00  0.00
ATOM   1171  CB  GLU    73      -6.847   6.673   3.492  1.00 65.44
ATOM   1172 2HB  GLU    73      -6.995   6.717   2.413  1.00  0.00
ATOM   1173 3HB  GLU    73      -7.813   6.724   3.994  1.00  0.00
ATOM   1174  CG  GLU    73      -6.029   7.877   3.910  1.00  3.41
ATOM   1175 2HG  GLU    73      -5.702   7.739   4.940  1.00  0.00
ATOM   1176 3HG  GLU    73      -5.154   7.950   3.263  1.00  0.00
ATOM   1177  CD  GLU    73      -6.812   9.168   3.816  1.00 44.43
ATOM   1178  OE1 GLU    73      -7.138   9.745   4.877  1.00 73.24
ATOM   1179  OE2 GLU    73      -7.111   9.610   2.689  1.00 41.01
ATOM   1180 2HE  GLU    73      -7.608  10.431   2.707  1.00  0.00
ATOM   1181  C   GLU    73      -7.089   4.205   3.357  1.00 53.54
ATOM   1182  O   GLU    73      -7.093   3.870   2.170  1.00 75.24
END
