
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   79 ( 1160),  selected   79 , name 2yun_A
# Molecule2: number of CA atoms   70 ( 1132),  selected   70 , name T0492.pdb
# PARAMETERS: 2yun_A.T0492.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      F       2           -
LGA    S     2_A      S       3           -
LGA    S     3_A      L       4           -
LGA    G     4_A      R       5           -
LGA    S     5_A      D       6           -
LGA    S     6_A      A       7           -
LGA    G     7_A      K       8           #
LGA    -       -      C       9           -
LGA    -       -      G      10           -
LGA    R     8_A      Q      11          0.870
LGA    L     9_A      T      12          1.064
LGA    C    10_A      V      13          1.261
LGA    K    11_A      K      14          1.664
LGA    A    12_A      V      15          2.022
LGA    L    13_A      V      16          3.211
LGA    -       -      K      17           -
LGA    Y    14_A      L      18          2.376
LGA    -       -      H      19           -
LGA    -       -      G      20           -
LGA    -       -      T      21           -
LGA    -       -      G      22           -
LGA    -       -      A      23           -
LGA    -       -      L      24           -
LGA    -       -      K      25           -
LGA    -       -      R      26           -
LGA    -       -      R      27           -
LGA    S    15_A      I      28          4.902
LGA    F    16_A      M      29          2.942
LGA    Q    17_A      D      30          2.589
LGA    A    18_A      M      31          3.000
LGA    R    19_A      -       -           -
LGA    Q    20_A      -       -           -
LGA    D    21_A      -       -           -
LGA    D    22_A      -       -           -
LGA    E    23_A      -       -           -
LGA    L    24_A      -       -           -
LGA    N    25_A      G      32          2.558
LGA    L    26_A      I      33          0.370
LGA    E    27_A      T      34          0.815
LGA    K    28_A      R      35          0.969
LGA    G    29_A      G      36          1.280
LGA    D    30_A      C      37          0.988
LGA    I    31_A      E      38          0.574
LGA    V    32_A      I      39          0.696
LGA    I    33_A      Y      40          0.646
LGA    I    34_A      I      41          0.399
LGA    H    35_A      R      42          0.271
LGA    E    36_A      K      43          0.816
LGA    K    37_A      V      44          1.284
LGA    K    38_A      A      45          1.004
LGA    E    39_A      G      48          2.720
LGA    E    40_A      D      49          3.449
LGA    G    41_A      -       -           -
LGA    W    42_A      P      50          3.511
LGA    W    43_A      I      51          1.964
LGA    F    44_A      Q      52          1.186
LGA    G    45_A      I      53          1.216
LGA    S    46_A      N      54          0.750
LGA    L    47_A      V      55          1.085
LGA    N    48_A      R      56          1.774
LGA    G    49_A      G      57          1.133
LGA    K    50_A      Y      58          0.872
LGA    K    51_A      E      59          0.615
LGA    G    52_A      L      60          0.697
LGA    H    53_A      S      61          1.609
LGA    F    54_A      L      62          2.321
LGA    -       -      R      63           -
LGA    -       -      K      64           -
LGA    -       -      S      65           -
LGA    P    55_A      A      66          3.246
LGA    A    56_A      A      67          1.556
LGA    A    57_A      E      68          2.780
LGA    -       -      M      69           -
LGA    Y    58_A      I      70          1.404
LGA    V    59_A      E      71          4.430
LGA    E    60_A      V      72          2.264
LGA    E    61_A      E      73          4.723
LGA    L    62_A      -       -           -
LGA    P    63_A      -       -           -
LGA    S    64_A      -       -           -
LGA    N    65_A      -       -           -
LGA    A    66_A      -       -           -
LGA    G    67_A      -       -           -
LGA    N    68_A      -       -           -
LGA    T    69_A      -       -           -
LGA    A    70_A      -       -           -
LGA    T    71_A      -       -           -
LGA    K    72_A      -       -           -
LGA    A    73_A      -       -           -
LGA    S    74_A      -       -           -
LGA    G    75_A      -       -           -
LGA    P    76_A      -       -           -
LGA    S    77_A      -       -           -
LGA    S    78_A      -       -           -
LGA    G    79_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   79   70    5.0     47    2.13    12.77     57.679     2.103

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.831960 * X  +   0.504627 * Y  +   0.230640 * Z  +  -0.972778
  Y_new =  -0.030347 * X  +   0.456455 * Y  +  -0.889229 * Z  +   0.547798
  Z_new =  -0.554005 * X  +   0.732804 * Y  +   0.395066 * Z  +  -3.120879 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.076348   -2.065245  [ DEG:    61.6702   -118.3298 ]
  Theta =   0.587168    2.554425  [ DEG:    33.6422    146.3578 ]
  Phi   =  -0.036461    3.105132  [ DEG:    -2.0891    177.9109 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2yun_A                                        
REMARK     2: T0492.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2yun_A.T0492.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   79   70   5.0   47   2.13   12.77  57.679
REMARK  ---------------------------------------------------------- 
MOLECULE 2yun_A
HEADER    PROTEIN TRANSPORT                       06-APR-07   2YUN              
TITLE     SOLUTION STRUCTURE OF THE SH3 DOMAIN OF HUMAN NOSTRIN                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NOSTRIN;                                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SH3 DOMAIN;                                                
COMPND   5 SYNONYM: ENOS TRAFFICKING INDUCER, NITRIC OXIDE SYNTHASE             
COMPND   6 TRAFFICKER, NITRIC OXIDE SYNTHASE TRAFFIC INDUCER, BM247             
COMPND   7 HOMOLOG;                                                             
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: NOSTRIN;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050620-15;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    NITRIC OXIDE SYNTHASE TRAFFICKER, STRUCTURAL GENOMICS,                
KEYWDS   2 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   3 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   4 INITIATIVE, RSGI, PROTEIN TRANSPORT                                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.ABE,N.TOCHIO,K.MIYAMOTO,S.KOSHIBA,M.INOUE,T.KIGAWA,                 
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   09-OCT-07 2YUN    0                                                
JRNL        AUTH   H.ABE,K.MIYAMOTO,N.TOCHIO,S.KOSHIBA,M.INOUE,                 
JRNL        AUTH 2 T.KIGAWA,S.YOKOYAMA                                          
JRNL        TITL   SOLUTION STRUCTURE OF THE SH3 DOMAIN OF HUMAN                
JRNL        TITL 2 NOSTRIN                                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2YUN A    8    73  UNP    Q8IVI9   NOSTN_HUMAN    441    506             
SEQRES   1 A   79  GLY SER SER GLY SER SER GLY ARG LEU CYS LYS ALA LEU          
SEQRES   2 A   79  TYR SER PHE GLN ALA ARG GLN ASP ASP GLU LEU ASN LEU          
SEQRES   3 A   79  GLU LYS GLY ASP ILE VAL ILE ILE HIS GLU LYS LYS GLU          
SEQRES   4 A   79  GLU GLY TRP TRP PHE GLY SER LEU ASN GLY LYS LYS GLY          
SEQRES   5 A   79  HIS PHE PRO ALA ALA TYR VAL GLU GLU LEU PRO SER ASN          
SEQRES   6 A   79  ALA GLY ASN THR ALA THR LYS ALA SER GLY PRO SER SER          
SEQRES   7 A   79  GLY                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1     -22.566  -2.797  -1.207  1.00  0.00           N  
ATOM      2  CA  GLY A   1     -22.798  -2.324  -2.559  1.00  0.00           C  
ATOM      3  C   GLY A   1     -22.974  -3.459  -3.548  1.00  0.00           C  
ATOM      4  O   GLY A   1     -24.093  -3.915  -3.788  1.00  0.00           O  
ATOM      5  H1  GLY A   1     -21.651  -2.844  -0.857  1.00  0.00           H  
ATOM      6  HA2 GLY A   1     -23.689  -1.713  -2.567  1.00  0.00           H  
ATOM      7  HA3 GLY A   1     -21.956  -1.721  -2.868  1.00  0.00           H  
ATOM      8  N   SER A   2     -21.868  -3.916  -4.126  1.00  0.00           N  
ATOM      9  CA  SER A   2     -21.905  -5.002  -5.098  1.00  0.00           C  
ATOM     10  C   SER A   2     -21.210  -6.245  -4.553  1.00  0.00           C  
ATOM     11  O   SER A   2     -20.166  -6.153  -3.907  1.00  0.00           O  
ATOM     12  CB  SER A   2     -21.241  -4.566  -6.407  1.00  0.00           C  
ATOM     13  OG  SER A   2     -19.830  -4.661  -6.319  1.00  0.00           O  
ATOM     14  H   SER A   2     -21.005  -3.511  -3.894  1.00  0.00           H  
ATOM     15  HA  SER A   2     -22.941  -5.238  -5.293  1.00  0.00           H  
ATOM     16  HB2 SER A   2     -21.583  -5.200  -7.210  1.00  0.00           H  
ATOM     17  HB3 SER A   2     -21.509  -3.540  -6.618  1.00  0.00           H  
ATOM     18  HG  SER A   2     -19.455  -4.675  -7.202  1.00  0.00           H  
ATOM     19  N   SER A   3     -21.798  -7.408  -4.816  1.00  0.00           N  
ATOM     20  CA  SER A   3     -21.239  -8.670  -4.348  1.00  0.00           C  
ATOM     21  C   SER A   3     -19.717  -8.659  -4.445  1.00  0.00           C  
ATOM     22  O   SER A   3     -19.152  -8.714  -5.537  1.00  0.00           O  
ATOM     23  CB  SER A   3     -21.804  -9.837  -5.162  1.00  0.00           C  
ATOM     24  OG  SER A   3     -23.088 -10.210  -4.692  1.00  0.00           O  
ATOM     25  H   SER A   3     -22.629  -7.416  -5.335  1.00  0.00           H  
ATOM     26  HA  SER A   3     -21.521  -8.795  -3.313  1.00  0.00           H  
ATOM     27  HB2 SER A   3     -21.885  -9.542  -6.198  1.00  0.00           H  
ATOM     28  HB3 SER A   3     -21.142 -10.685  -5.077  1.00  0.00           H  
ATOM     29  HG  SER A   3     -23.155 -10.017  -3.755  1.00  0.00           H  
ATOM     30  N   GLY A   4     -19.057  -8.589  -3.292  1.00  0.00           N  
ATOM     31  CA  GLY A   4     -17.605  -8.571  -3.269  1.00  0.00           C  
ATOM     32  C   GLY A   4     -17.047  -8.705  -1.866  1.00  0.00           C  
ATOM     33  O   GLY A   4     -17.227  -9.734  -1.214  1.00  0.00           O  
ATOM     34  H   GLY A   4     -19.560  -8.547  -2.452  1.00  0.00           H  
ATOM     35  HA2 GLY A   4     -17.237  -9.388  -3.871  1.00  0.00           H  
ATOM     36  HA3 GLY A   4     -17.261  -7.640  -3.693  1.00  0.00           H  
ATOM     37  N   SER A   5     -16.368  -7.662  -1.399  1.00  0.00           N  
ATOM     38  CA  SER A   5     -15.777  -7.669  -0.067  1.00  0.00           C  
ATOM     39  C   SER A   5     -14.741  -8.781   0.063  1.00  0.00           C  
ATOM     40  O   SER A   5     -14.705  -9.499   1.061  1.00  0.00           O  
ATOM     41  CB  SER A   5     -16.864  -7.845   0.996  1.00  0.00           C  
ATOM     42  OG  SER A   5     -17.833  -6.814   0.908  1.00  0.00           O  
ATOM     43  H   SER A   5     -16.260  -6.870  -1.966  1.00  0.00           H  
ATOM     44  HA  SER A   5     -15.288  -6.718   0.085  1.00  0.00           H  
ATOM     45  HB2 SER A   5     -17.353  -8.795   0.853  1.00  0.00           H  
ATOM     46  HB3 SER A   5     -16.412  -7.814   1.978  1.00  0.00           H  
ATOM     47  HG  SER A   5     -18.421  -6.861   1.666  1.00  0.00           H  
ATOM     48  N   SER A   6     -13.898  -8.918  -0.957  1.00  0.00           N  
ATOM     49  CA  SER A   6     -12.862  -9.944  -0.961  1.00  0.00           C  
ATOM     50  C   SER A   6     -11.479  -9.322  -0.800  1.00  0.00           C  
ATOM     51  O   SER A   6     -10.667  -9.783   0.001  1.00  0.00           O  
ATOM     52  CB  SER A   6     -12.922 -10.754  -2.257  1.00  0.00           C  
ATOM     53  OG  SER A   6     -13.968 -11.710  -2.214  1.00  0.00           O  
ATOM     54  H   SER A   6     -13.977  -8.314  -1.726  1.00  0.00           H  
ATOM     55  HA  SER A   6     -13.047 -10.604  -0.126  1.00  0.00           H  
ATOM     56  HB2 SER A   6     -13.097 -10.086  -3.088  1.00  0.00           H  
ATOM     57  HB3 SER A   6     -11.984 -11.270  -2.400  1.00  0.00           H  
ATOM     58  HG  SER A   6     -14.184 -11.989  -3.106  1.00  0.00           H  
ATOM     59  N   GLY A   7     -11.218  -8.269  -1.569  1.00  0.00           N  
ATOM     60  CA  GLY A   7      -9.933  -7.598  -1.499  1.00  0.00           C  
ATOM     61  C   GLY A   7     -10.026  -6.232  -0.849  1.00  0.00           C  
ATOM     62  O   GLY A   7     -10.962  -5.476  -1.108  1.00  0.00           O  
ATOM     63  H   GLY A   7     -11.904  -7.944  -2.189  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      -9.251  -8.211  -0.927  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      -9.545  -7.482  -2.500  1.00  0.00           H  
ATOM     66  N   ARG A   8      -9.055  -5.915   0.000  1.00  0.00           N  
ATOM     67  CA  ARG A   8      -9.033  -4.630   0.692  1.00  0.00           C  
ATOM     68  C   ARG A   8      -8.368  -3.561  -0.169  1.00  0.00           C  
ATOM     69  O   ARG A   8      -7.714  -3.869  -1.167  1.00  0.00           O  
ATOM     70  CB  ARG A   8      -8.295  -4.759   2.025  1.00  0.00           C  
ATOM     71  CG  ARG A   8      -8.828  -5.872   2.912  1.00  0.00           C  
ATOM     72  CD  ARG A   8     -10.260  -5.599   3.349  1.00  0.00           C  
ATOM     73  NE  ARG A   8     -10.765  -6.635   4.246  1.00  0.00           N  
ATOM     74  CZ  ARG A   8     -11.965  -6.594   4.814  1.00  0.00           C  
ATOM     75  NH1 ARG A   8     -12.779  -5.573   4.579  1.00  0.00           N  
ATOM     76  NH2 ARG A   8     -12.354  -7.574   5.619  1.00  0.00           N  
ATOM     77  H   ARG A   8      -8.335  -6.559   0.167  1.00  0.00           H  
ATOM     78  HA  ARG A   8     -10.055  -4.339   0.881  1.00  0.00           H  
ATOM     79  HB2 ARG A   8      -7.252  -4.953   1.829  1.00  0.00           H  
ATOM     80  HB3 ARG A   8      -8.385  -3.826   2.562  1.00  0.00           H  
ATOM     81  HG2 ARG A   8      -8.803  -6.801   2.363  1.00  0.00           H  
ATOM     82  HG3 ARG A   8      -8.203  -5.952   3.789  1.00  0.00           H  
ATOM     83  HD2 ARG A   8     -10.291  -4.648   3.859  1.00  0.00           H  
ATOM     84  HD3 ARG A   8     -10.887  -5.558   2.471  1.00  0.00           H  
ATOM     85  HE  ARG A   8     -10.180  -7.397   4.433  1.00  0.00           H  
ATOM     86 HH11 ARG A   8     -12.489  -4.833   3.972  1.00  0.00           H  
ATOM     87 HH12 ARG A   8     -13.682  -5.545   5.008  1.00  0.00           H  
ATOM     88 HH21 ARG A   8     -11.743  -8.345   5.798  1.00  0.00           H  
ATOM     89 HH22 ARG A   8     -13.256  -7.542   6.046  1.00  0.00           H  
ATOM     90  N   LEU A   9      -8.539  -2.303   0.221  1.00  0.00           N  
ATOM     91  CA  LEU A   9      -7.956  -1.186  -0.515  1.00  0.00           C  
ATOM     92  C   LEU A   9      -7.039  -0.363   0.383  1.00  0.00           C  
ATOM     93  O   LEU A   9      -7.058  -0.506   1.606  1.00  0.00           O  
ATOM     94  CB  LEU A   9      -9.059  -0.297  -1.089  1.00  0.00           C  
ATOM     95  CG  LEU A   9      -9.832  -0.868  -2.279  1.00  0.00           C  
ATOM     96  CD1 LEU A   9      -8.928  -0.979  -3.497  1.00  0.00           C  
ATOM     97  CD2 LEU A   9     -10.425  -2.224  -1.928  1.00  0.00           C  
ATOM     98  H   LEU A   9      -9.070  -2.120   1.024  1.00  0.00           H  
ATOM     99  HA  LEU A   9      -7.374  -1.594  -1.328  1.00  0.00           H  
ATOM    100  HB2 LEU A   9      -9.769  -0.099  -0.300  1.00  0.00           H  
ATOM    101  HB3 LEU A   9      -8.605   0.632  -1.403  1.00  0.00           H  
ATOM    102  HG  LEU A   9     -10.645  -0.200  -2.527  1.00  0.00           H  
ATOM    103 HD11 LEU A   9      -8.483  -0.017  -3.704  1.00  0.00           H  
ATOM    104 HD12 LEU A   9      -9.510  -1.295  -4.350  1.00  0.00           H  
ATOM    105 HD13 LEU A   9      -8.150  -1.702  -3.304  1.00  0.00           H  
ATOM    106 HD21 LEU A   9      -9.687  -2.994  -2.096  1.00  0.00           H  
ATOM    107 HD22 LEU A   9     -11.288  -2.412  -2.550  1.00  0.00           H  
ATOM    108 HD23 LEU A   9     -10.722  -2.230  -0.890  1.00  0.00           H  
ATOM    109  N   CYS A  10      -6.238   0.501  -0.231  1.00  0.00           N  
ATOM    110  CA  CYS A  10      -5.313   1.348   0.512  1.00  0.00           C  
ATOM    111  C   CYS A  10      -4.759   2.457  -0.377  1.00  0.00           C  
ATOM    112  O   CYS A  10      -4.762   2.346  -1.603  1.00  0.00           O  
ATOM    113  CB  CYS A  10      -4.166   0.513   1.082  1.00  0.00           C  
ATOM    114  SG  CYS A  10      -3.179  -0.336  -0.172  1.00  0.00           S  
ATOM    115  H   CYS A  10      -6.268   0.569  -1.208  1.00  0.00           H  
ATOM    116  HA  CYS A  10      -5.860   1.798   1.327  1.00  0.00           H  
ATOM    117  HB2 CYS A  10      -3.504   1.158   1.640  1.00  0.00           H  
ATOM    118  HB3 CYS A  10      -4.573  -0.236   1.745  1.00  0.00           H  
ATOM    119  HG  CYS A  10      -2.096   0.391  -0.400  1.00  0.00           H  
ATOM    120  N   LYS A  11      -4.282   3.528   0.249  1.00  0.00           N  
ATOM    121  CA  LYS A  11      -3.723   4.658  -0.482  1.00  0.00           C  
ATOM    122  C   LYS A  11      -2.236   4.817  -0.186  1.00  0.00           C  
ATOM    123  O   LYS A  11      -1.815   4.759   0.969  1.00  0.00           O  
ATOM    124  CB  LYS A  11      -4.467   5.946  -0.119  1.00  0.00           C  
ATOM    125  CG  LYS A  11      -3.764   7.207  -0.589  1.00  0.00           C  
ATOM    126  CD  LYS A  11      -4.706   8.399  -0.601  1.00  0.00           C  
ATOM    127  CE  LYS A  11      -5.165   8.761   0.803  1.00  0.00           C  
ATOM    128  NZ  LYS A  11      -5.577  10.189   0.902  1.00  0.00           N  
ATOM    129  H   LYS A  11      -4.306   3.558   1.230  1.00  0.00           H  
ATOM    130  HA  LYS A  11      -3.849   4.465  -1.537  1.00  0.00           H  
ATOM    131  HB2 LYS A  11      -5.450   5.918  -0.568  1.00  0.00           H  
ATOM    132  HB3 LYS A  11      -4.572   5.995   0.955  1.00  0.00           H  
ATOM    133  HG2 LYS A  11      -2.942   7.420   0.078  1.00  0.00           H  
ATOM    134  HG3 LYS A  11      -3.388   7.048  -1.589  1.00  0.00           H  
ATOM    135  HD2 LYS A  11      -4.194   9.248  -1.029  1.00  0.00           H  
ATOM    136  HD3 LYS A  11      -5.571   8.157  -1.202  1.00  0.00           H  
ATOM    137  HE2 LYS A  11      -6.004   8.135   1.067  1.00  0.00           H  
ATOM    138  HE3 LYS A  11      -4.353   8.581   1.491  1.00  0.00           H  
ATOM    139  HZ1 LYS A  11      -5.301  10.701   0.039  1.00  0.00           H  
ATOM    140  HZ2 LYS A  11      -5.118  10.637   1.720  1.00  0.00           H  
ATOM    141  HZ3 LYS A  11      -6.609  10.256   1.017  1.00  0.00           H  
ATOM    142  N   ALA A  12      -1.446   5.020  -1.235  1.00  0.00           N  
ATOM    143  CA  ALA A  12      -0.006   5.191  -1.086  1.00  0.00           C  
ATOM    144  C   ALA A  12       0.332   6.594  -0.594  1.00  0.00           C  
ATOM    145  O   ALA A  12       0.233   7.567  -1.343  1.00  0.00           O  
ATOM    146  CB  ALA A  12       0.698   4.908  -2.404  1.00  0.00           C  
ATOM    147  H   ALA A  12      -1.841   5.057  -2.130  1.00  0.00           H  
ATOM    148  HA  ALA A  12       0.342   4.472  -0.358  1.00  0.00           H  
ATOM    149  HB1 ALA A  12       1.748   5.139  -2.308  1.00  0.00           H  
ATOM    150  HB2 ALA A  12       0.581   3.865  -2.657  1.00  0.00           H  
ATOM    151  HB3 ALA A  12       0.265   5.519  -3.182  1.00  0.00           H  
ATOM    152  N   LEU A  13       0.730   6.693   0.670  1.00  0.00           N  
ATOM    153  CA  LEU A  13       1.082   7.979   1.262  1.00  0.00           C  
ATOM    154  C   LEU A  13       2.382   8.514   0.670  1.00  0.00           C  
ATOM    155  O   LEU A  13       2.507   9.708   0.398  1.00  0.00           O  
ATOM    156  CB  LEU A  13       1.219   7.842   2.780  1.00  0.00           C  
ATOM    157  CG  LEU A  13       0.030   7.214   3.507  1.00  0.00           C  
ATOM    158  CD1 LEU A  13       0.355   7.001   4.977  1.00  0.00           C  
ATOM    159  CD2 LEU A  13      -1.209   8.084   3.354  1.00  0.00           C  
ATOM    160  H   LEU A  13       0.790   5.883   1.217  1.00  0.00           H  
ATOM    161  HA  LEU A  13       0.287   8.674   1.042  1.00  0.00           H  
ATOM    162  HB2 LEU A  13       2.087   7.234   2.980  1.00  0.00           H  
ATOM    163  HB3 LEU A  13       1.373   8.832   3.188  1.00  0.00           H  
ATOM    164  HG  LEU A  13      -0.183   6.248   3.069  1.00  0.00           H  
ATOM    165 HD11 LEU A  13       0.336   7.950   5.492  1.00  0.00           H  
ATOM    166 HD12 LEU A  13       1.337   6.561   5.069  1.00  0.00           H  
ATOM    167 HD13 LEU A  13      -0.377   6.339   5.416  1.00  0.00           H  
ATOM    168 HD21 LEU A  13      -2.011   7.677   3.951  1.00  0.00           H  
ATOM    169 HD22 LEU A  13      -1.508   8.105   2.317  1.00  0.00           H  
ATOM    170 HD23 LEU A  13      -0.987   9.088   3.684  1.00  0.00           H  
ATOM    171  N   TYR A  14       3.347   7.623   0.471  1.00  0.00           N  
ATOM    172  CA  TYR A  14       4.637   8.005  -0.090  1.00  0.00           C  
ATOM    173  C   TYR A  14       4.941   7.205  -1.354  1.00  0.00           C  
ATOM    174  O   TYR A  14       4.716   5.996  -1.405  1.00  0.00           O  
ATOM    175  CB  TYR A  14       5.747   7.793   0.940  1.00  0.00           C  
ATOM    176  CG  TYR A  14       5.346   8.169   2.348  1.00  0.00           C  
ATOM    177  CD1 TYR A  14       4.495   7.358   3.090  1.00  0.00           C  
ATOM    178  CD2 TYR A  14       5.819   9.335   2.939  1.00  0.00           C  
ATOM    179  CE1 TYR A  14       4.126   7.698   4.377  1.00  0.00           C  
ATOM    180  CE2 TYR A  14       5.456   9.682   4.226  1.00  0.00           C  
ATOM    181  CZ  TYR A  14       4.609   8.860   4.940  1.00  0.00           C  
ATOM    182  OH  TYR A  14       4.245   9.202   6.222  1.00  0.00           O  
ATOM    183  H   TYR A  14       3.187   6.685   0.708  1.00  0.00           H  
ATOM    184  HA  TYR A  14       4.591   9.054  -0.344  1.00  0.00           H  
ATOM    185  HB2 TYR A  14       6.032   6.752   0.943  1.00  0.00           H  
ATOM    186  HB3 TYR A  14       6.603   8.395   0.667  1.00  0.00           H  
ATOM    187  HD1 TYR A  14       4.119   6.448   2.645  1.00  0.00           H  
ATOM    188  HD2 TYR A  14       6.482   9.976   2.376  1.00  0.00           H  
ATOM    189  HE1 TYR A  14       3.463   7.055   4.937  1.00  0.00           H  
ATOM    190  HE2 TYR A  14       5.834  10.592   4.668  1.00  0.00           H  
ATOM    191  HH  TYR A  14       4.543   8.523   6.832  1.00  0.00           H  
ATOM    192  N   SER A  15       5.453   7.891  -2.371  1.00  0.00           N  
ATOM    193  CA  SER A  15       5.786   7.246  -3.636  1.00  0.00           C  
ATOM    194  C   SER A  15       6.947   6.273  -3.462  1.00  0.00           C  
ATOM    195  O   SER A  15       8.027   6.651  -3.008  1.00  0.00           O  
ATOM    196  CB  SER A  15       6.141   8.297  -4.690  1.00  0.00           C  
ATOM    197  OG  SER A  15       7.171   9.155  -4.228  1.00  0.00           O  
ATOM    198  H   SER A  15       5.610   8.853  -2.269  1.00  0.00           H  
ATOM    199  HA  SER A  15       4.917   6.697  -3.967  1.00  0.00           H  
ATOM    200  HB2 SER A  15       6.476   7.803  -5.589  1.00  0.00           H  
ATOM    201  HB3 SER A  15       5.266   8.892  -4.911  1.00  0.00           H  
ATOM    202  HG  SER A  15       7.146   9.978  -4.721  1.00  0.00           H  
ATOM    203  N   PHE A  16       6.716   5.015  -3.824  1.00  0.00           N  
ATOM    204  CA  PHE A  16       7.741   3.985  -3.707  1.00  0.00           C  
ATOM    205  C   PHE A  16       8.336   3.652  -5.072  1.00  0.00           C  
ATOM    206  O   PHE A  16       7.616   3.556  -6.066  1.00  0.00           O  
ATOM    207  CB  PHE A  16       7.156   2.722  -3.071  1.00  0.00           C  
ATOM    208  CG  PHE A  16       8.185   1.671  -2.769  1.00  0.00           C  
ATOM    209  CD1 PHE A  16       9.161   1.894  -1.811  1.00  0.00           C  
ATOM    210  CD2 PHE A  16       8.176   0.461  -3.443  1.00  0.00           C  
ATOM    211  CE1 PHE A  16      10.109   0.927  -1.530  1.00  0.00           C  
ATOM    212  CE2 PHE A  16       9.121  -0.509  -3.166  1.00  0.00           C  
ATOM    213  CZ  PHE A  16      10.090  -0.275  -2.210  1.00  0.00           C  
ATOM    214  H   PHE A  16       5.834   4.774  -4.179  1.00  0.00           H  
ATOM    215  HA  PHE A  16       8.524   4.368  -3.071  1.00  0.00           H  
ATOM    216  HB2 PHE A  16       6.670   2.987  -2.144  1.00  0.00           H  
ATOM    217  HB3 PHE A  16       6.429   2.293  -3.744  1.00  0.00           H  
ATOM    218  HD1 PHE A  16       9.177   2.834  -1.279  1.00  0.00           H  
ATOM    219  HD2 PHE A  16       7.420   0.276  -4.192  1.00  0.00           H  
ATOM    220  HE1 PHE A  16      10.865   1.114  -0.782  1.00  0.00           H  
ATOM    221  HE2 PHE A  16       9.104  -1.449  -3.699  1.00  0.00           H  
ATOM    222  HZ  PHE A  16      10.829  -1.031  -1.991  1.00  0.00           H  
ATOM    223  N   GLN A  17       9.653   3.476  -5.112  1.00  0.00           N  
ATOM    224  CA  GLN A  17      10.343   3.155  -6.354  1.00  0.00           C  
ATOM    225  C   GLN A  17      10.806   1.702  -6.360  1.00  0.00           C  
ATOM    226  O   GLN A  17      11.853   1.372  -5.803  1.00  0.00           O  
ATOM    227  CB  GLN A  17      11.542   4.085  -6.551  1.00  0.00           C  
ATOM    228  CG  GLN A  17      12.117   4.046  -7.958  1.00  0.00           C  
ATOM    229  CD  GLN A  17      13.188   5.096  -8.180  1.00  0.00           C  
ATOM    230  OE1 GLN A  17      12.892   6.285  -8.305  1.00  0.00           O  
ATOM    231  NE2 GLN A  17      14.442   4.663  -8.227  1.00  0.00           N  
ATOM    232  H   GLN A  17      10.172   3.565  -4.285  1.00  0.00           H  
ATOM    233  HA  GLN A  17       9.649   3.302  -7.167  1.00  0.00           H  
ATOM    234  HB2 GLN A  17      11.236   5.098  -6.338  1.00  0.00           H  
ATOM    235  HB3 GLN A  17      12.321   3.800  -5.860  1.00  0.00           H  
ATOM    236  HG2 GLN A  17      12.550   3.073  -8.130  1.00  0.00           H  
ATOM    237  HG3 GLN A  17      11.318   4.213  -8.664  1.00  0.00           H  
ATOM    238 HE21 GLN A  17      14.603   3.701  -8.121  1.00  0.00           H  
ATOM    239 HE22 GLN A  17      15.154   5.320  -8.371  1.00  0.00           H  
ATOM    240  N   ALA A  18      10.020   0.838  -6.993  1.00  0.00           N  
ATOM    241  CA  ALA A  18      10.349  -0.580  -7.072  1.00  0.00           C  
ATOM    242  C   ALA A  18      11.683  -0.794  -7.781  1.00  0.00           C  
ATOM    243  O   ALA A  18      11.770  -0.689  -9.005  1.00  0.00           O  
ATOM    244  CB  ALA A  18       9.242  -1.340  -7.786  1.00  0.00           C  
ATOM    245  H   ALA A  18       9.198   1.162  -7.418  1.00  0.00           H  
ATOM    246  HA  ALA A  18      10.423  -0.962  -6.065  1.00  0.00           H  
ATOM    247  HB1 ALA A  18       9.644  -1.821  -8.666  1.00  0.00           H  
ATOM    248  HB2 ALA A  18       8.834  -2.088  -7.123  1.00  0.00           H  
ATOM    249  HB3 ALA A  18       8.462  -0.652  -8.076  1.00  0.00           H  
ATOM    250  N   ARG A  19      12.719  -1.093  -7.004  1.00  0.00           N  
ATOM    251  CA  ARG A  19      14.048  -1.321  -7.559  1.00  0.00           C  
ATOM    252  C   ARG A  19      13.990  -2.302  -8.725  1.00  0.00           C  
ATOM    253  O   ARG A  19      14.630  -2.092  -9.756  1.00  0.00           O  
ATOM    254  CB  ARG A  19      14.990  -1.852  -6.477  1.00  0.00           C  
ATOM    255  CG  ARG A  19      15.379  -0.810  -5.442  1.00  0.00           C  
ATOM    256  CD  ARG A  19      16.514  -1.300  -4.557  1.00  0.00           C  
ATOM    257  NE  ARG A  19      17.351  -0.201  -4.081  1.00  0.00           N  
ATOM    258  CZ  ARG A  19      18.075   0.572  -4.882  1.00  0.00           C  
ATOM    259  NH1 ARG A  19      18.065   0.367  -6.192  1.00  0.00           N  
ATOM    260  NH2 ARG A  19      18.810   1.552  -4.374  1.00  0.00           N  
ATOM    261  H   ARG A  19      12.587  -1.163  -6.036  1.00  0.00           H  
ATOM    262  HA  ARG A  19      14.424  -0.374  -7.917  1.00  0.00           H  
ATOM    263  HB2 ARG A  19      14.507  -2.673  -5.967  1.00  0.00           H  
ATOM    264  HB3 ARG A  19      15.892  -2.214  -6.948  1.00  0.00           H  
ATOM    265  HG2 ARG A  19      15.696   0.089  -5.950  1.00  0.00           H  
ATOM    266  HG3 ARG A  19      14.521  -0.593  -4.824  1.00  0.00           H  
ATOM    267  HD2 ARG A  19      16.095  -1.814  -3.706  1.00  0.00           H  
ATOM    268  HD3 ARG A  19      17.126  -1.985  -5.125  1.00  0.00           H  
ATOM    269  HE  ARG A  19      17.373  -0.033  -3.117  1.00  0.00           H  
ATOM    270 HH11 ARG A  19      17.511  -0.370  -6.578  1.00  0.00           H  
ATOM    271 HH12 ARG A  19      18.610   0.952  -6.794  1.00  0.00           H  
ATOM    272 HH21 ARG A  19      18.820   1.709  -3.387  1.00  0.00           H  
ATOM    273 HH22 ARG A  19      19.355   2.133  -4.977  1.00  0.00           H  
ATOM    274  N   GLN A  20      13.221  -3.373  -8.555  1.00  0.00           N  
ATOM    275  CA  GLN A  20      13.081  -4.386  -9.593  1.00  0.00           C  
ATOM    276  C   GLN A  20      11.616  -4.753  -9.803  1.00  0.00           C  
ATOM    277  O   GLN A  20      10.731  -4.213  -9.140  1.00  0.00           O  
ATOM    278  CB  GLN A  20      13.885  -5.635  -9.228  1.00  0.00           C  
ATOM    279  CG  GLN A  20      13.801  -6.003  -7.755  1.00  0.00           C  
ATOM    280  CD  GLN A  20      15.008  -6.787  -7.280  1.00  0.00           C  
ATOM    281  OE1 GLN A  20      15.446  -7.733  -7.933  1.00  0.00           O  
ATOM    282  NE2 GLN A  20      15.554  -6.395  -6.134  1.00  0.00           N  
ATOM    283  H   GLN A  20      12.737  -3.483  -7.711  1.00  0.00           H  
ATOM    284  HA  GLN A  20      13.471  -3.975 -10.512  1.00  0.00           H  
ATOM    285  HB2 GLN A  20      13.516  -6.468  -9.807  1.00  0.00           H  
ATOM    286  HB3 GLN A  20      14.923  -5.466  -9.475  1.00  0.00           H  
ATOM    287  HG2 GLN A  20      13.728  -5.096  -7.174  1.00  0.00           H  
ATOM    288  HG3 GLN A  20      12.916  -6.603  -7.598  1.00  0.00           H  
ATOM    289 HE21 GLN A  20      15.152  -5.633  -5.667  1.00  0.00           H  
ATOM    290 HE22 GLN A  20      16.335  -6.883  -5.803  1.00  0.00           H  
ATOM    291  N   ASP A  21      11.368  -5.673 -10.729  1.00  0.00           N  
ATOM    292  CA  ASP A  21      10.010  -6.112 -11.026  1.00  0.00           C  
ATOM    293  C   ASP A  21       9.385  -6.799  -9.816  1.00  0.00           C  
ATOM    294  O   ASP A  21       8.165  -6.793  -9.647  1.00  0.00           O  
ATOM    295  CB  ASP A  21      10.009  -7.063 -12.224  1.00  0.00           C  
ATOM    296  CG  ASP A  21       8.810  -7.990 -12.226  1.00  0.00           C  
ATOM    297  OD1 ASP A  21       7.737  -7.573 -12.711  1.00  0.00           O  
ATOM    298  OD2 ASP A  21       8.945  -9.134 -11.744  1.00  0.00           O  
ATOM    299  H   ASP A  21      12.117  -6.066 -11.224  1.00  0.00           H  
ATOM    300  HA  ASP A  21       9.424  -5.238 -11.270  1.00  0.00           H  
ATOM    301  HB2 ASP A  21       9.993  -6.482 -13.135  1.00  0.00           H  
ATOM    302  HB3 ASP A  21      10.907  -7.663 -12.200  1.00  0.00           H  
ATOM    303  N   ASP A  22      10.228  -7.390  -8.976  1.00  0.00           N  
ATOM    304  CA  ASP A  22       9.758  -8.083  -7.782  1.00  0.00           C  
ATOM    305  C   ASP A  22       8.842  -7.182  -6.958  1.00  0.00           C  
ATOM    306  O   ASP A  22       7.748  -7.587  -6.567  1.00  0.00           O  
ATOM    307  CB  ASP A  22      10.944  -8.539  -6.931  1.00  0.00           C  
ATOM    308  CG  ASP A  22      11.957  -9.335  -7.730  1.00  0.00           C  
ATOM    309  OD1 ASP A  22      11.690 -10.522  -8.012  1.00  0.00           O  
ATOM    310  OD2 ASP A  22      13.017  -8.772  -8.074  1.00  0.00           O  
ATOM    311  H   ASP A  22      11.189  -7.361  -9.165  1.00  0.00           H  
ATOM    312  HA  ASP A  22       9.199  -8.950  -8.099  1.00  0.00           H  
ATOM    313  HB2 ASP A  22      11.440  -7.672  -6.520  1.00  0.00           H  
ATOM    314  HB3 ASP A  22      10.583  -9.158  -6.123  1.00  0.00           H  
ATOM    315  N   GLU A  23       9.298  -5.961  -6.697  1.00  0.00           N  
ATOM    316  CA  GLU A  23       8.520  -5.006  -5.918  1.00  0.00           C  
ATOM    317  C   GLU A  23       7.526  -4.262  -6.806  1.00  0.00           C  
ATOM    318  O   GLU A  23       7.548  -4.396  -8.029  1.00  0.00           O  
ATOM    319  CB  GLU A  23       9.447  -4.007  -5.222  1.00  0.00           C  
ATOM    320  CG  GLU A  23      10.254  -4.614  -4.087  1.00  0.00           C  
ATOM    321  CD  GLU A  23       9.438  -4.792  -2.821  1.00  0.00           C  
ATOM    322  OE1 GLU A  23       9.242  -3.792  -2.097  1.00  0.00           O  
ATOM    323  OE2 GLU A  23       8.996  -5.928  -2.554  1.00  0.00           O  
ATOM    324  H   GLU A  23      10.179  -5.697  -7.037  1.00  0.00           H  
ATOM    325  HA  GLU A  23       7.973  -5.557  -5.169  1.00  0.00           H  
ATOM    326  HB2 GLU A  23      10.134  -3.604  -5.950  1.00  0.00           H  
ATOM    327  HB3 GLU A  23       8.850  -3.201  -4.820  1.00  0.00           H  
ATOM    328  HG2 GLU A  23      10.620  -5.580  -4.399  1.00  0.00           H  
ATOM    329  HG3 GLU A  23      11.091  -3.966  -3.871  1.00  0.00           H  
ATOM    330  N   LEU A  24       6.655  -3.477  -6.179  1.00  0.00           N  
ATOM    331  CA  LEU A  24       5.653  -2.712  -6.911  1.00  0.00           C  
ATOM    332  C   LEU A  24       5.826  -1.215  -6.669  1.00  0.00           C  
ATOM    333  O   LEU A  24       5.883  -0.764  -5.525  1.00  0.00           O  
ATOM    334  CB  LEU A  24       4.246  -3.147  -6.495  1.00  0.00           C  
ATOM    335  CG  LEU A  24       3.151  -2.977  -7.548  1.00  0.00           C  
ATOM    336  CD1 LEU A  24       1.944  -3.835  -7.207  1.00  0.00           C  
ATOM    337  CD2 LEU A  24       2.751  -1.514  -7.670  1.00  0.00           C  
ATOM    338  H   LEU A  24       6.688  -3.410  -5.203  1.00  0.00           H  
ATOM    339  HA  LEU A  24       5.786  -2.911  -7.964  1.00  0.00           H  
ATOM    340  HB2 LEU A  24       4.289  -4.191  -6.228  1.00  0.00           H  
ATOM    341  HB3 LEU A  24       3.965  -2.567  -5.628  1.00  0.00           H  
ATOM    342  HG  LEU A  24       3.531  -3.302  -8.508  1.00  0.00           H  
ATOM    343 HD11 LEU A  24       2.190  -4.492  -6.386  1.00  0.00           H  
ATOM    344 HD12 LEU A  24       1.666  -4.425  -8.068  1.00  0.00           H  
ATOM    345 HD13 LEU A  24       1.118  -3.199  -6.925  1.00  0.00           H  
ATOM    346 HD21 LEU A  24       3.199  -1.091  -8.557  1.00  0.00           H  
ATOM    347 HD22 LEU A  24       3.094  -0.974  -6.801  1.00  0.00           H  
ATOM    348 HD23 LEU A  24       1.676  -1.440  -7.739  1.00  0.00           H  
ATOM    349  N   ASN A  25       5.908  -0.451  -7.753  1.00  0.00           N  
ATOM    350  CA  ASN A  25       6.074   0.995  -7.658  1.00  0.00           C  
ATOM    351  C   ASN A  25       4.764   1.667  -7.258  1.00  0.00           C  
ATOM    352  O   ASN A  25       3.698   1.335  -7.779  1.00  0.00           O  
ATOM    353  CB  ASN A  25       6.564   1.562  -8.993  1.00  0.00           C  
ATOM    354  CG  ASN A  25       6.929   3.030  -8.898  1.00  0.00           C  
ATOM    355  OD1 ASN A  25       6.058   3.890  -8.766  1.00  0.00           O  
ATOM    356  ND2 ASN A  25       8.223   3.324  -8.965  1.00  0.00           N  
ATOM    357  H   ASN A  25       5.856  -0.869  -8.638  1.00  0.00           H  
ATOM    358  HA  ASN A  25       6.814   1.195  -6.899  1.00  0.00           H  
ATOM    359  HB2 ASN A  25       7.439   1.012  -9.310  1.00  0.00           H  
ATOM    360  HB3 ASN A  25       5.786   1.449  -9.733  1.00  0.00           H  
ATOM    361 HD21 ASN A  25       8.860   2.587  -9.071  1.00  0.00           H  
ATOM    362 HD22 ASN A  25       8.487   4.266  -8.906  1.00  0.00           H  
ATOM    363  N   LEU A  26       4.850   2.615  -6.332  1.00  0.00           N  
ATOM    364  CA  LEU A  26       3.673   3.336  -5.862  1.00  0.00           C  
ATOM    365  C   LEU A  26       3.847   4.840  -6.044  1.00  0.00           C  
ATOM    366  O   LEU A  26       4.963   5.356  -5.995  1.00  0.00           O  
ATOM    367  CB  LEU A  26       3.409   3.016  -4.389  1.00  0.00           C  
ATOM    368  CG  LEU A  26       3.510   1.543  -3.994  1.00  0.00           C  
ATOM    369  CD1 LEU A  26       3.879   1.407  -2.526  1.00  0.00           C  
ATOM    370  CD2 LEU A  26       2.201   0.822  -4.284  1.00  0.00           C  
ATOM    371  H   LEU A  26       5.727   2.836  -5.954  1.00  0.00           H  
ATOM    372  HA  LEU A  26       2.828   3.010  -6.450  1.00  0.00           H  
ATOM    373  HB2 LEU A  26       4.124   3.566  -3.798  1.00  0.00           H  
ATOM    374  HB3 LEU A  26       2.410   3.356  -4.152  1.00  0.00           H  
ATOM    375  HG  LEU A  26       4.289   1.072  -4.579  1.00  0.00           H  
ATOM    376 HD11 LEU A  26       3.644   2.326  -2.009  1.00  0.00           H  
ATOM    377 HD12 LEU A  26       4.937   1.206  -2.439  1.00  0.00           H  
ATOM    378 HD13 LEU A  26       3.321   0.594  -2.087  1.00  0.00           H  
ATOM    379 HD21 LEU A  26       1.582   1.440  -4.918  1.00  0.00           H  
ATOM    380 HD22 LEU A  26       1.686   0.625  -3.357  1.00  0.00           H  
ATOM    381 HD23 LEU A  26       2.409  -0.113  -4.786  1.00  0.00           H  
ATOM    382  N   GLU A  27       2.735   5.539  -6.251  1.00  0.00           N  
ATOM    383  CA  GLU A  27       2.765   6.985  -6.438  1.00  0.00           C  
ATOM    384  C   GLU A  27       1.911   7.688  -5.387  1.00  0.00           C  
ATOM    385  O   GLU A  27       0.865   7.181  -4.978  1.00  0.00           O  
ATOM    386  CB  GLU A  27       2.271   7.350  -7.840  1.00  0.00           C  
ATOM    387  CG  GLU A  27       2.041   8.839  -8.034  1.00  0.00           C  
ATOM    388  CD  GLU A  27       3.311   9.584  -8.394  1.00  0.00           C  
ATOM    389  OE1 GLU A  27       4.386   9.210  -7.880  1.00  0.00           O  
ATOM    390  OE2 GLU A  27       3.230  10.544  -9.190  1.00  0.00           O  
ATOM    391  H   GLU A  27       1.874   5.071  -6.279  1.00  0.00           H  
ATOM    392  HA  GLU A  27       3.788   7.311  -6.330  1.00  0.00           H  
ATOM    393  HB2 GLU A  27       3.004   7.022  -8.563  1.00  0.00           H  
ATOM    394  HB3 GLU A  27       1.341   6.835  -8.026  1.00  0.00           H  
ATOM    395  HG2 GLU A  27       1.323   8.978  -8.828  1.00  0.00           H  
ATOM    396  HG3 GLU A  27       1.646   9.252  -7.118  1.00  0.00           H  
ATOM    397  N   LYS A  28       2.363   8.859  -4.953  1.00  0.00           N  
ATOM    398  CA  LYS A  28       1.642   9.634  -3.949  1.00  0.00           C  
ATOM    399  C   LYS A  28       0.169   9.768  -4.321  1.00  0.00           C  
ATOM    400  O   LYS A  28      -0.178  10.440  -5.292  1.00  0.00           O  
ATOM    401  CB  LYS A  28       2.269  11.022  -3.799  1.00  0.00           C  
ATOM    402  CG  LYS A  28       1.551  11.909  -2.798  1.00  0.00           C  
ATOM    403  CD  LYS A  28       2.493  12.926  -2.177  1.00  0.00           C  
ATOM    404  CE  LYS A  28       3.589  12.251  -1.368  1.00  0.00           C  
ATOM    405  NZ  LYS A  28       4.240  13.196  -0.419  1.00  0.00           N  
ATOM    406  H   LYS A  28       3.203   9.211  -5.316  1.00  0.00           H  
ATOM    407  HA  LYS A  28       1.717   9.110  -3.009  1.00  0.00           H  
ATOM    408  HB2 LYS A  28       3.294  10.907  -3.478  1.00  0.00           H  
ATOM    409  HB3 LYS A  28       2.255  11.516  -4.760  1.00  0.00           H  
ATOM    410  HG2 LYS A  28       0.753  12.433  -3.302  1.00  0.00           H  
ATOM    411  HG3 LYS A  28       1.138  11.290  -2.013  1.00  0.00           H  
ATOM    412  HD2 LYS A  28       2.950  13.508  -2.964  1.00  0.00           H  
ATOM    413  HD3 LYS A  28       1.927  13.579  -1.527  1.00  0.00           H  
ATOM    414  HE2 LYS A  28       3.156  11.435  -0.810  1.00  0.00           H  
ATOM    415  HE3 LYS A  28       4.335  11.866  -2.048  1.00  0.00           H  
ATOM    416  HZ1 LYS A  28       3.561  13.496   0.308  1.00  0.00           H  
ATOM    417  HZ2 LYS A  28       4.582  14.035  -0.928  1.00  0.00           H  
ATOM    418  HZ3 LYS A  28       5.048  12.735   0.047  1.00  0.00           H  
ATOM    419  N   GLY A  29      -0.695   9.124  -3.541  1.00  0.00           N  
ATOM    420  CA  GLY A  29      -2.121   9.186  -3.805  1.00  0.00           C  
ATOM    421  C   GLY A  29      -2.567   8.155  -4.822  1.00  0.00           C  
ATOM    422  O   GLY A  29      -3.342   8.462  -5.728  1.00  0.00           O  
ATOM    423  H   GLY A  29      -0.361   8.604  -2.781  1.00  0.00           H  
ATOM    424  HA2 GLY A  29      -2.654   9.020  -2.880  1.00  0.00           H  
ATOM    425  HA3 GLY A  29      -2.364  10.170  -4.178  1.00  0.00           H  
ATOM    426  N   ASP A  30      -2.077   6.928  -4.674  1.00  0.00           N  
ATOM    427  CA  ASP A  30      -2.430   5.849  -5.587  1.00  0.00           C  
ATOM    428  C   ASP A  30      -3.165   4.733  -4.851  1.00  0.00           C  
ATOM    429  O   ASP A  30      -2.698   4.242  -3.823  1.00  0.00           O  
ATOM    430  CB  ASP A  30      -1.176   5.292  -6.261  1.00  0.00           C  
ATOM    431  CG  ASP A  30      -0.830   6.029  -7.540  1.00  0.00           C  
ATOM    432  OD1 ASP A  30      -0.864   7.278  -7.532  1.00  0.00           O  
ATOM    433  OD2 ASP A  30      -0.524   5.358  -8.548  1.00  0.00           O  
ATOM    434  H   ASP A  30      -1.463   6.746  -3.931  1.00  0.00           H  
ATOM    435  HA  ASP A  30      -3.084   6.254  -6.344  1.00  0.00           H  
ATOM    436  HB2 ASP A  30      -0.341   5.378  -5.581  1.00  0.00           H  
ATOM    437  HB3 ASP A  30      -1.335   4.250  -6.499  1.00  0.00           H  
ATOM    438  N   ILE A  31      -4.316   4.337  -5.384  1.00  0.00           N  
ATOM    439  CA  ILE A  31      -5.115   3.280  -4.777  1.00  0.00           C  
ATOM    440  C   ILE A  31      -4.652   1.905  -5.246  1.00  0.00           C  
ATOM    441  O   ILE A  31      -4.722   1.585  -6.432  1.00  0.00           O  
ATOM    442  CB  ILE A  31      -6.611   3.445  -5.106  1.00  0.00           C  
ATOM    443  CG1 ILE A  31      -7.116   4.803  -4.614  1.00  0.00           C  
ATOM    444  CG2 ILE A  31      -7.418   2.316  -4.482  1.00  0.00           C  
ATOM    445  CD1 ILE A  31      -6.791   5.079  -3.162  1.00  0.00           C  
ATOM    446  H   ILE A  31      -4.636   4.767  -6.205  1.00  0.00           H  
ATOM    447  HA  ILE A  31      -4.993   3.343  -3.705  1.00  0.00           H  
ATOM    448  HB  ILE A  31      -6.729   3.391  -6.178  1.00  0.00           H  
ATOM    449 HG12 ILE A  31      -6.667   5.584  -5.208  1.00  0.00           H  
ATOM    450 HG13 ILE A  31      -8.189   4.842  -4.728  1.00  0.00           H  
ATOM    451 HG21 ILE A  31      -8.335   2.714  -4.072  1.00  0.00           H  
ATOM    452 HG22 ILE A  31      -7.652   1.581  -5.238  1.00  0.00           H  
ATOM    453 HG23 ILE A  31      -6.842   1.854  -3.695  1.00  0.00           H  
ATOM    454 HD11 ILE A  31      -5.959   5.767  -3.105  1.00  0.00           H  
ATOM    455 HD12 ILE A  31      -7.651   5.516  -2.677  1.00  0.00           H  
ATOM    456 HD13 ILE A  31      -6.529   4.156  -2.670  1.00  0.00           H  
ATOM    457  N   VAL A  32      -4.183   1.092  -4.305  1.00  0.00           N  
ATOM    458  CA  VAL A  32      -3.711  -0.251  -4.619  1.00  0.00           C  
ATOM    459  C   VAL A  32      -4.667  -1.310  -4.082  1.00  0.00           C  
ATOM    460  O   VAL A  32      -5.157  -1.204  -2.957  1.00  0.00           O  
ATOM    461  CB  VAL A  32      -2.306  -0.504  -4.041  1.00  0.00           C  
ATOM    462  CG1 VAL A  32      -1.745  -1.821  -4.554  1.00  0.00           C  
ATOM    463  CG2 VAL A  32      -1.375   0.650  -4.382  1.00  0.00           C  
ATOM    464  H   VAL A  32      -4.152   1.403  -3.376  1.00  0.00           H  
ATOM    465  HA  VAL A  32      -3.657  -0.343  -5.695  1.00  0.00           H  
ATOM    466  HB  VAL A  32      -2.388  -0.566  -2.966  1.00  0.00           H  
ATOM    467 HG11 VAL A  32      -2.560  -2.471  -4.841  1.00  0.00           H  
ATOM    468 HG12 VAL A  32      -1.114  -1.636  -5.410  1.00  0.00           H  
ATOM    469 HG13 VAL A  32      -1.167  -2.293  -3.773  1.00  0.00           H  
ATOM    470 HG21 VAL A  32      -1.305   0.750  -5.456  1.00  0.00           H  
ATOM    471 HG22 VAL A  32      -1.765   1.564  -3.960  1.00  0.00           H  
ATOM    472 HG23 VAL A  32      -0.394   0.455  -3.974  1.00  0.00           H  
ATOM    473  N   ILE A  33      -4.929  -2.330  -4.891  1.00  0.00           N  
ATOM    474  CA  ILE A  33      -5.825  -3.409  -4.496  1.00  0.00           C  
ATOM    475  C   ILE A  33      -5.097  -4.446  -3.648  1.00  0.00           C  
ATOM    476  O   ILE A  33      -4.273  -5.208  -4.155  1.00  0.00           O  
ATOM    477  CB  ILE A  33      -6.443  -4.106  -5.723  1.00  0.00           C  
ATOM    478  CG1 ILE A  33      -7.331  -3.132  -6.498  1.00  0.00           C  
ATOM    479  CG2 ILE A  33      -7.239  -5.329  -5.292  1.00  0.00           C  
ATOM    480  CD1 ILE A  33      -7.594  -3.558  -7.925  1.00  0.00           C  
ATOM    481  H   ILE A  33      -4.508  -2.358  -5.776  1.00  0.00           H  
ATOM    482  HA  ILE A  33      -6.625  -2.979  -3.911  1.00  0.00           H  
ATOM    483  HB  ILE A  33      -5.639  -4.437  -6.363  1.00  0.00           H  
ATOM    484 HG12 ILE A  33      -8.282  -3.044  -5.998  1.00  0.00           H  
ATOM    485 HG13 ILE A  33      -6.852  -2.163  -6.524  1.00  0.00           H  
ATOM    486 HG21 ILE A  33      -7.195  -5.427  -4.217  1.00  0.00           H  
ATOM    487 HG22 ILE A  33      -8.267  -5.215  -5.600  1.00  0.00           H  
ATOM    488 HG23 ILE A  33      -6.821  -6.212  -5.751  1.00  0.00           H  
ATOM    489 HD11 ILE A  33      -8.323  -4.356  -7.933  1.00  0.00           H  
ATOM    490 HD12 ILE A  33      -7.975  -2.718  -8.488  1.00  0.00           H  
ATOM    491 HD13 ILE A  33      -6.676  -3.906  -8.373  1.00  0.00           H  
ATOM    492  N   ILE A  34      -5.408  -4.470  -2.357  1.00  0.00           N  
ATOM    493  CA  ILE A  34      -4.785  -5.417  -1.439  1.00  0.00           C  
ATOM    494  C   ILE A  34      -5.203  -6.848  -1.758  1.00  0.00           C  
ATOM    495  O   ILE A  34      -6.353  -7.234  -1.541  1.00  0.00           O  
ATOM    496  CB  ILE A  34      -5.146  -5.102   0.024  1.00  0.00           C  
ATOM    497  CG1 ILE A  34      -4.696  -3.686   0.391  1.00  0.00           C  
ATOM    498  CG2 ILE A  34      -4.511  -6.123   0.957  1.00  0.00           C  
ATOM    499  CD1 ILE A  34      -5.436  -3.105   1.575  1.00  0.00           C  
ATOM    500  H   ILE A  34      -6.073  -3.839  -2.013  1.00  0.00           H  
ATOM    501  HA  ILE A  34      -3.714  -5.333  -1.551  1.00  0.00           H  
ATOM    502  HB  ILE A  34      -6.218  -5.170   0.130  1.00  0.00           H  
ATOM    503 HG12 ILE A  34      -3.644  -3.700   0.630  1.00  0.00           H  
ATOM    504 HG13 ILE A  34      -4.860  -3.035  -0.456  1.00  0.00           H  
ATOM    505 HG21 ILE A  34      -4.437  -7.075   0.453  1.00  0.00           H  
ATOM    506 HG22 ILE A  34      -3.525  -5.788   1.239  1.00  0.00           H  
ATOM    507 HG23 ILE A  34      -5.123  -6.231   1.841  1.00  0.00           H  
ATOM    508 HD11 ILE A  34      -5.451  -3.827   2.379  1.00  0.00           H  
ATOM    509 HD12 ILE A  34      -4.934  -2.208   1.909  1.00  0.00           H  
ATOM    510 HD13 ILE A  34      -6.448  -2.866   1.287  1.00  0.00           H  
ATOM    511  N   HIS A  35      -4.262  -7.633  -2.273  1.00  0.00           N  
ATOM    512  CA  HIS A  35      -4.533  -9.023  -2.620  1.00  0.00           C  
ATOM    513  C   HIS A  35      -4.204  -9.948  -1.451  1.00  0.00           C  
ATOM    514  O   HIS A  35      -5.033 -10.759  -1.038  1.00  0.00           O  
ATOM    515  CB  HIS A  35      -3.722  -9.431  -3.851  1.00  0.00           C  
ATOM    516  CG  HIS A  35      -4.404  -9.119  -5.147  1.00  0.00           C  
ATOM    517  ND1 HIS A  35      -5.029 -10.076  -5.918  1.00  0.00           N  
ATOM    518  CD2 HIS A  35      -4.559  -7.947  -5.806  1.00  0.00           C  
ATOM    519  CE1 HIS A  35      -5.537  -9.507  -6.997  1.00  0.00           C  
ATOM    520  NE2 HIS A  35      -5.266  -8.215  -6.953  1.00  0.00           N  
ATOM    521  H   HIS A  35      -3.366  -7.268  -2.423  1.00  0.00           H  
ATOM    522  HA  HIS A  35      -5.584  -9.110  -2.847  1.00  0.00           H  
ATOM    523  HB2 HIS A  35      -2.776  -8.910  -3.840  1.00  0.00           H  
ATOM    524  HB3 HIS A  35      -3.541 -10.496  -3.818  1.00  0.00           H  
ATOM    525  HD1 HIS A  35      -5.090 -11.031  -5.707  1.00  0.00           H  
ATOM    526  HD2 HIS A  35      -4.194  -6.980  -5.489  1.00  0.00           H  
ATOM    527  HE1 HIS A  35      -6.082 -10.011  -7.780  1.00  0.00           H  
ATOM    528  HE2 HIS A  35      -5.453  -7.574  -7.670  1.00  0.00           H  
ATOM    529  N   GLU A  36      -2.991  -9.820  -0.924  1.00  0.00           N  
ATOM    530  CA  GLU A  36      -2.554 -10.647   0.196  1.00  0.00           C  
ATOM    531  C   GLU A  36      -1.513  -9.915   1.038  1.00  0.00           C  
ATOM    532  O   GLU A  36      -0.638  -9.230   0.508  1.00  0.00           O  
ATOM    533  CB  GLU A  36      -1.976 -11.970  -0.312  1.00  0.00           C  
ATOM    534  CG  GLU A  36      -2.936 -12.756  -1.189  1.00  0.00           C  
ATOM    535  CD  GLU A  36      -2.274 -13.942  -1.860  1.00  0.00           C  
ATOM    536  OE1 GLU A  36      -1.326 -13.727  -2.645  1.00  0.00           O  
ATOM    537  OE2 GLU A  36      -2.703 -15.087  -1.604  1.00  0.00           O  
ATOM    538  H   GLU A  36      -2.374  -9.156  -1.297  1.00  0.00           H  
ATOM    539  HA  GLU A  36      -3.416 -10.853   0.811  1.00  0.00           H  
ATOM    540  HB2 GLU A  36      -1.085 -11.763  -0.886  1.00  0.00           H  
ATOM    541  HB3 GLU A  36      -1.713 -12.582   0.537  1.00  0.00           H  
ATOM    542  HG2 GLU A  36      -3.750 -13.116  -0.577  1.00  0.00           H  
ATOM    543  HG3 GLU A  36      -3.326 -12.100  -1.953  1.00  0.00           H  
ATOM    544  N   LYS A  37      -1.614 -10.063   2.354  1.00  0.00           N  
ATOM    545  CA  LYS A  37      -0.683  -9.419   3.272  1.00  0.00           C  
ATOM    546  C   LYS A  37      -0.150 -10.416   4.296  1.00  0.00           C  
ATOM    547  O   LYS A  37      -0.120 -10.134   5.494  1.00  0.00           O  
ATOM    548  CB  LYS A  37      -1.367  -8.251   3.988  1.00  0.00           C  
ATOM    549  CG  LYS A  37      -2.151  -7.343   3.058  1.00  0.00           C  
ATOM    550  CD  LYS A  37      -2.899  -6.268   3.828  1.00  0.00           C  
ATOM    551  CE  LYS A  37      -4.231  -6.783   4.353  1.00  0.00           C  
ATOM    552  NZ  LYS A  37      -4.051  -7.737   5.483  1.00  0.00           N  
ATOM    553  H   LYS A  37      -2.334 -10.623   2.718  1.00  0.00           H  
ATOM    554  HA  LYS A  37       0.145  -9.040   2.693  1.00  0.00           H  
ATOM    555  HB2 LYS A  37      -2.045  -8.647   4.729  1.00  0.00           H  
ATOM    556  HB3 LYS A  37      -0.612  -7.658   4.485  1.00  0.00           H  
ATOM    557  HG2 LYS A  37      -1.467  -6.868   2.371  1.00  0.00           H  
ATOM    558  HG3 LYS A  37      -2.865  -7.939   2.505  1.00  0.00           H  
ATOM    559  HD2 LYS A  37      -2.295  -5.950   4.665  1.00  0.00           H  
ATOM    560  HD3 LYS A  37      -3.082  -5.428   3.173  1.00  0.00           H  
ATOM    561  HE2 LYS A  37      -4.818  -5.944   4.693  1.00  0.00           H  
ATOM    562  HE3 LYS A  37      -4.750  -7.284   3.549  1.00  0.00           H  
ATOM    563  HZ1 LYS A  37      -3.950  -8.707   5.119  1.00  0.00           H  
ATOM    564  HZ2 LYS A  37      -4.874  -7.700   6.117  1.00  0.00           H  
ATOM    565  HZ3 LYS A  37      -3.199  -7.492   6.025  1.00  0.00           H  
ATOM    566  N   LYS A  38       0.270 -11.582   3.818  1.00  0.00           N  
ATOM    567  CA  LYS A  38       0.804 -12.620   4.690  1.00  0.00           C  
ATOM    568  C   LYS A  38       2.286 -12.389   4.967  1.00  0.00           C  
ATOM    569  O   LYS A  38       3.061 -13.338   5.080  1.00  0.00           O  
ATOM    570  CB  LYS A  38       0.602 -14.000   4.059  1.00  0.00           C  
ATOM    571  CG  LYS A  38       1.499 -14.258   2.861  1.00  0.00           C  
ATOM    572  CD  LYS A  38       0.868 -13.758   1.573  1.00  0.00           C  
ATOM    573  CE  LYS A  38       1.308 -14.588   0.377  1.00  0.00           C  
ATOM    574  NZ  LYS A  38       2.616 -14.128  -0.166  1.00  0.00           N  
ATOM    575  H   LYS A  38       0.219 -11.748   2.852  1.00  0.00           H  
ATOM    576  HA  LYS A  38       0.265 -12.579   5.625  1.00  0.00           H  
ATOM    577  HB2 LYS A  38       0.804 -14.756   4.804  1.00  0.00           H  
ATOM    578  HB3 LYS A  38      -0.427 -14.088   3.738  1.00  0.00           H  
ATOM    579  HG2 LYS A  38       2.439 -13.749   3.010  1.00  0.00           H  
ATOM    580  HG3 LYS A  38       1.673 -15.322   2.776  1.00  0.00           H  
ATOM    581  HD2 LYS A  38      -0.207 -13.816   1.662  1.00  0.00           H  
ATOM    582  HD3 LYS A  38       1.162 -12.730   1.415  1.00  0.00           H  
ATOM    583  HE2 LYS A  38       1.398 -15.619   0.685  1.00  0.00           H  
ATOM    584  HE3 LYS A  38       0.557 -14.507  -0.396  1.00  0.00           H  
ATOM    585  HZ1 LYS A  38       3.392 -14.463   0.440  1.00  0.00           H  
ATOM    586  HZ2 LYS A  38       2.641 -13.090  -0.203  1.00  0.00           H  
ATOM    587  HZ3 LYS A  38       2.755 -14.502  -1.127  1.00  0.00           H  
ATOM    588  N   GLU A  39       2.673 -11.121   5.076  1.00  0.00           N  
ATOM    589  CA  GLU A  39       4.062 -10.767   5.340  1.00  0.00           C  
ATOM    590  C   GLU A  39       4.149  -9.556   6.264  1.00  0.00           C  
ATOM    591  O   GLU A  39       3.183  -8.808   6.415  1.00  0.00           O  
ATOM    592  CB  GLU A  39       4.795 -10.475   4.029  1.00  0.00           C  
ATOM    593  CG  GLU A  39       6.278 -10.803   4.075  1.00  0.00           C  
ATOM    594  CD  GLU A  39       6.547 -12.295   4.066  1.00  0.00           C  
ATOM    595  OE1 GLU A  39       5.956 -13.010   4.902  1.00  0.00           O  
ATOM    596  OE2 GLU A  39       7.347 -12.749   3.221  1.00  0.00           O  
ATOM    597  H   GLU A  39       2.008 -10.408   4.975  1.00  0.00           H  
ATOM    598  HA  GLU A  39       4.533 -11.609   5.825  1.00  0.00           H  
ATOM    599  HB2 GLU A  39       4.343 -11.057   3.240  1.00  0.00           H  
ATOM    600  HB3 GLU A  39       4.687  -9.426   3.797  1.00  0.00           H  
ATOM    601  HG2 GLU A  39       6.759 -10.361   3.215  1.00  0.00           H  
ATOM    602  HG3 GLU A  39       6.699 -10.383   4.977  1.00  0.00           H  
ATOM    603  N   GLU A  40       5.311  -9.371   6.881  1.00  0.00           N  
ATOM    604  CA  GLU A  40       5.523  -8.253   7.792  1.00  0.00           C  
ATOM    605  C   GLU A  40       5.827  -6.972   7.020  1.00  0.00           C  
ATOM    606  O   GLU A  40       6.970  -6.717   6.644  1.00  0.00           O  
ATOM    607  CB  GLU A  40       6.669  -8.562   8.758  1.00  0.00           C  
ATOM    608  CG  GLU A  40       6.705 -10.011   9.214  1.00  0.00           C  
ATOM    609  CD  GLU A  40       7.496 -10.899   8.275  1.00  0.00           C  
ATOM    610  OE1 GLU A  40       8.741 -10.914   8.380  1.00  0.00           O  
ATOM    611  OE2 GLU A  40       6.872 -11.580   7.436  1.00  0.00           O  
ATOM    612  H   GLU A  40       6.044 -10.002   6.720  1.00  0.00           H  
ATOM    613  HA  GLU A  40       4.615  -8.109   8.358  1.00  0.00           H  
ATOM    614  HB2 GLU A  40       7.605  -8.335   8.271  1.00  0.00           H  
ATOM    615  HB3 GLU A  40       6.566  -7.934   9.631  1.00  0.00           H  
ATOM    616  HG2 GLU A  40       7.157 -10.054  10.194  1.00  0.00           H  
ATOM    617  HG3 GLU A  40       5.692 -10.383   9.270  1.00  0.00           H  
ATOM    618  N   GLY A  41       4.793  -6.169   6.784  1.00  0.00           N  
ATOM    619  CA  GLY A  41       4.969  -4.926   6.058  1.00  0.00           C  
ATOM    620  C   GLY A  41       4.881  -5.114   4.556  1.00  0.00           C  
ATOM    621  O   GLY A  41       4.285  -4.296   3.855  1.00  0.00           O  
ATOM    622  H   GLY A  41       3.903  -6.424   7.107  1.00  0.00           H  
ATOM    623  HA2 GLY A  41       4.205  -4.229   6.367  1.00  0.00           H  
ATOM    624  HA3 GLY A  41       5.937  -4.514   6.300  1.00  0.00           H  
ATOM    625  N   TRP A  42       5.475  -6.194   4.062  1.00  0.00           N  
ATOM    626  CA  TRP A  42       5.463  -6.486   2.632  1.00  0.00           C  
ATOM    627  C   TRP A  42       4.070  -6.902   2.174  1.00  0.00           C  
ATOM    628  O   TRP A  42       3.671  -8.054   2.338  1.00  0.00           O  
ATOM    629  CB  TRP A  42       6.471  -7.591   2.308  1.00  0.00           C  
ATOM    630  CG  TRP A  42       7.852  -7.302   2.814  1.00  0.00           C  
ATOM    631  CD1 TRP A  42       8.321  -7.510   4.079  1.00  0.00           C  
ATOM    632  CD2 TRP A  42       8.941  -6.752   2.065  1.00  0.00           C  
ATOM    633  NE1 TRP A  42       9.636  -7.122   4.162  1.00  0.00           N  
ATOM    634  CE2 TRP A  42      10.040  -6.653   2.940  1.00  0.00           C  
ATOM    635  CE3 TRP A  42       9.095  -6.334   0.740  1.00  0.00           C  
ATOM    636  CZ2 TRP A  42      11.274  -6.154   2.531  1.00  0.00           C  
ATOM    637  CZ3 TRP A  42      10.319  -5.838   0.337  1.00  0.00           C  
ATOM    638  CH2 TRP A  42      11.397  -5.753   1.229  1.00  0.00           C  
ATOM    639  H   TRP A  42       5.934  -6.810   4.671  1.00  0.00           H  
ATOM    640  HA  TRP A  42       5.749  -5.586   2.109  1.00  0.00           H  
ATOM    641  HB2 TRP A  42       6.139  -8.515   2.756  1.00  0.00           H  
ATOM    642  HB3 TRP A  42       6.526  -7.714   1.236  1.00  0.00           H  
ATOM    643  HD1 TRP A  42       7.733  -7.918   4.887  1.00  0.00           H  
ATOM    644  HE1 TRP A  42      10.195  -7.173   4.966  1.00  0.00           H  
ATOM    645  HE3 TRP A  42       8.277  -6.393   0.038  1.00  0.00           H  
ATOM    646  HZ2 TRP A  42      12.114  -6.082   3.207  1.00  0.00           H  
ATOM    647  HZ3 TRP A  42      10.457  -5.510  -0.683  1.00  0.00           H  
ATOM    648  HH2 TRP A  42      12.335  -5.359   0.870  1.00  0.00           H  
ATOM    649  N   TRP A  43       3.335  -5.956   1.600  1.00  0.00           N  
ATOM    650  CA  TRP A  43       1.985  -6.226   1.117  1.00  0.00           C  
ATOM    651  C   TRP A  43       2.001  -6.613  -0.357  1.00  0.00           C  
ATOM    652  O   TRP A  43       2.946  -6.299  -1.081  1.00  0.00           O  
ATOM    653  CB  TRP A  43       1.093  -5.002   1.326  1.00  0.00           C  
ATOM    654  CG  TRP A  43       0.644  -4.828   2.746  1.00  0.00           C  
ATOM    655  CD1 TRP A  43       1.180  -5.422   3.853  1.00  0.00           C  
ATOM    656  CD2 TRP A  43      -0.434  -4.009   3.210  1.00  0.00           C  
ATOM    657  NE1 TRP A  43       0.500  -5.021   4.977  1.00  0.00           N  
ATOM    658  CE2 TRP A  43      -0.494  -4.152   4.610  1.00  0.00           C  
ATOM    659  CE3 TRP A  43      -1.353  -3.165   2.580  1.00  0.00           C  
ATOM    660  CZ2 TRP A  43      -1.438  -3.486   5.387  1.00  0.00           C  
ATOM    661  CZ3 TRP A  43      -2.289  -2.504   3.353  1.00  0.00           C  
ATOM    662  CH2 TRP A  43      -2.325  -2.666   4.744  1.00  0.00           C  
ATOM    663  H   TRP A  43       3.708  -5.056   1.498  1.00  0.00           H  
ATOM    664  HA  TRP A  43       1.587  -7.051   1.690  1.00  0.00           H  
ATOM    665  HB2 TRP A  43       1.636  -4.114   1.038  1.00  0.00           H  
ATOM    666  HB3 TRP A  43       0.213  -5.097   0.707  1.00  0.00           H  
ATOM    667  HD1 TRP A  43       2.014  -6.107   3.832  1.00  0.00           H  
ATOM    668  HE1 TRP A  43       0.696  -5.309   5.894  1.00  0.00           H  
ATOM    669  HE3 TRP A  43      -1.341  -3.027   1.509  1.00  0.00           H  
ATOM    670  HZ2 TRP A  43      -1.478  -3.600   6.461  1.00  0.00           H  
ATOM    671  HZ3 TRP A  43      -3.007  -1.848   2.883  1.00  0.00           H  
ATOM    672  HH2 TRP A  43      -3.073  -2.131   5.307  1.00  0.00           H  
ATOM    673  N   PHE A  44       0.949  -7.296  -0.796  1.00  0.00           N  
ATOM    674  CA  PHE A  44       0.843  -7.726  -2.186  1.00  0.00           C  
ATOM    675  C   PHE A  44      -0.475  -7.265  -2.799  1.00  0.00           C  
ATOM    676  O   PHE A  44      -1.544  -7.461  -2.223  1.00  0.00           O  
ATOM    677  CB  PHE A  44       0.956  -9.249  -2.280  1.00  0.00           C  
ATOM    678  CG  PHE A  44       0.971  -9.764  -3.691  1.00  0.00           C  
ATOM    679  CD1 PHE A  44       2.088  -9.591  -4.493  1.00  0.00           C  
ATOM    680  CD2 PHE A  44      -0.132 -10.417  -4.216  1.00  0.00           C  
ATOM    681  CE1 PHE A  44       2.106 -10.064  -5.792  1.00  0.00           C  
ATOM    682  CE2 PHE A  44      -0.120 -10.892  -5.514  1.00  0.00           C  
ATOM    683  CZ  PHE A  44       0.999 -10.714  -6.304  1.00  0.00           C  
ATOM    684  H   PHE A  44       0.227  -7.516  -0.171  1.00  0.00           H  
ATOM    685  HA  PHE A  44       1.658  -7.279  -2.733  1.00  0.00           H  
ATOM    686  HB2 PHE A  44       1.872  -9.566  -1.803  1.00  0.00           H  
ATOM    687  HB3 PHE A  44       0.116  -9.698  -1.771  1.00  0.00           H  
ATOM    688  HD1 PHE A  44       2.954  -9.083  -4.093  1.00  0.00           H  
ATOM    689  HD2 PHE A  44      -1.008 -10.557  -3.600  1.00  0.00           H  
ATOM    690  HE1 PHE A  44       2.982  -9.923  -6.406  1.00  0.00           H  
ATOM    691  HE2 PHE A  44      -0.985 -11.400  -5.911  1.00  0.00           H  
ATOM    692  HZ  PHE A  44       1.011 -11.084  -7.318  1.00  0.00           H  
ATOM    693  N   GLY A  45      -0.390  -6.648  -3.974  1.00  0.00           N  
ATOM    694  CA  GLY A  45      -1.583  -6.167  -4.647  1.00  0.00           C  
ATOM    695  C   GLY A  45      -1.268  -5.468  -5.955  1.00  0.00           C  
ATOM    696  O   GLY A  45      -0.102  -5.287  -6.306  1.00  0.00           O  
ATOM    697  H   GLY A  45       0.489  -6.519  -4.387  1.00  0.00           H  
ATOM    698  HA2 GLY A  45      -2.234  -7.004  -4.846  1.00  0.00           H  
ATOM    699  HA3 GLY A  45      -2.094  -5.472  -3.996  1.00  0.00           H  
ATOM    700  N   SER A  46      -2.311  -5.074  -6.679  1.00  0.00           N  
ATOM    701  CA  SER A  46      -2.140  -4.397  -7.960  1.00  0.00           C  
ATOM    702  C   SER A  46      -2.481  -2.915  -7.839  1.00  0.00           C  
ATOM    703  O   SER A  46      -3.507  -2.546  -7.264  1.00  0.00           O  
ATOM    704  CB  SER A  46      -3.019  -5.049  -9.028  1.00  0.00           C  
ATOM    705  OG  SER A  46      -3.042  -4.272 -10.214  1.00  0.00           O  
ATOM    706  H   SER A  46      -3.216  -5.247  -6.347  1.00  0.00           H  
ATOM    707  HA  SER A  46      -1.105  -4.492  -8.250  1.00  0.00           H  
ATOM    708  HB2 SER A  46      -2.631  -6.029  -9.261  1.00  0.00           H  
ATOM    709  HB3 SER A  46      -4.028  -5.141  -8.652  1.00  0.00           H  
ATOM    710  HG  SER A  46      -3.361  -3.390 -10.013  1.00  0.00           H  
ATOM    711  N   LEU A  47      -1.616  -2.068  -8.386  1.00  0.00           N  
ATOM    712  CA  LEU A  47      -1.824  -0.625  -8.341  1.00  0.00           C  
ATOM    713  C   LEU A  47      -2.706  -0.166  -9.497  1.00  0.00           C  
ATOM    714  O   LEU A  47      -3.883   0.140  -9.310  1.00  0.00           O  
ATOM    715  CB  LEU A  47      -0.481   0.106  -8.387  1.00  0.00           C  
ATOM    716  CG  LEU A  47      -0.531   1.575  -8.807  1.00  0.00           C  
ATOM    717  CD1 LEU A  47      -1.660   2.298  -8.090  1.00  0.00           C  
ATOM    718  CD2 LEU A  47       0.801   2.256  -8.529  1.00  0.00           C  
ATOM    719  H   LEU A  47      -0.817  -2.421  -8.830  1.00  0.00           H  
ATOM    720  HA  LEU A  47      -2.320  -0.391  -7.411  1.00  0.00           H  
ATOM    721  HB2 LEU A  47      -0.046   0.060  -7.400  1.00  0.00           H  
ATOM    722  HB3 LEU A  47       0.155  -0.418  -9.085  1.00  0.00           H  
ATOM    723  HG  LEU A  47      -0.721   1.632  -9.871  1.00  0.00           H  
ATOM    724 HD11 LEU A  47      -1.594   2.109  -7.031  1.00  0.00           H  
ATOM    725 HD12 LEU A  47      -2.610   1.940  -8.461  1.00  0.00           H  
ATOM    726 HD13 LEU A  47      -1.581   3.360  -8.273  1.00  0.00           H  
ATOM    727 HD21 LEU A  47       1.604   1.648  -8.920  1.00  0.00           H  
ATOM    728 HD22 LEU A  47       0.926   2.377  -7.463  1.00  0.00           H  
ATOM    729 HD23 LEU A  47       0.817   3.224  -9.005  1.00  0.00           H  
ATOM    730  N   ASN A  48      -2.129  -0.123 -10.694  1.00  0.00           N  
ATOM    731  CA  ASN A  48      -2.864   0.298 -11.882  1.00  0.00           C  
ATOM    732  C   ASN A  48      -2.903  -0.819 -12.920  1.00  0.00           C  
ATOM    733  O   ASN A  48      -2.768  -0.574 -14.117  1.00  0.00           O  
ATOM    734  CB  ASN A  48      -2.223   1.548 -12.487  1.00  0.00           C  
ATOM    735  CG  ASN A  48      -2.805   2.828 -11.918  1.00  0.00           C  
ATOM    736  OD1 ASN A  48      -4.005   2.917 -11.660  1.00  0.00           O  
ATOM    737  ND2 ASN A  48      -1.953   3.829 -11.720  1.00  0.00           N  
ATOM    738  H   ASN A  48      -1.187  -0.379 -10.780  1.00  0.00           H  
ATOM    739  HA  ASN A  48      -3.874   0.530 -11.581  1.00  0.00           H  
ATOM    740  HB2 ASN A  48      -1.162   1.537 -12.283  1.00  0.00           H  
ATOM    741  HB3 ASN A  48      -2.381   1.546 -13.555  1.00  0.00           H  
ATOM    742 HD21 ASN A  48      -1.011   3.686 -11.949  1.00  0.00           H  
ATOM    743 HD22 ASN A  48      -2.302   4.667 -11.353  1.00  0.00           H  
ATOM    744  N   GLY A  49      -3.092  -2.050 -12.451  1.00  0.00           N  
ATOM    745  CA  GLY A  49      -3.146  -3.187 -13.351  1.00  0.00           C  
ATOM    746  C   GLY A  49      -1.921  -4.072 -13.242  1.00  0.00           C  
ATOM    747  O   GLY A  49      -1.833  -5.108 -13.903  1.00  0.00           O  
ATOM    748  H   GLY A  49      -3.193  -2.187 -11.485  1.00  0.00           H  
ATOM    749  HA2 GLY A  49      -4.023  -3.773 -13.120  1.00  0.00           H  
ATOM    750  HA3 GLY A  49      -3.225  -2.825 -14.365  1.00  0.00           H  
ATOM    751  N   LYS A  50      -0.972  -3.666 -12.406  1.00  0.00           N  
ATOM    752  CA  LYS A  50       0.256  -4.429 -12.212  1.00  0.00           C  
ATOM    753  C   LYS A  50       0.416  -4.838 -10.752  1.00  0.00           C  
ATOM    754  O   LYS A  50       0.427  -3.994  -9.857  1.00  0.00           O  
ATOM    755  CB  LYS A  50       1.468  -3.608 -12.659  1.00  0.00           C  
ATOM    756  CG  LYS A  50       1.454  -3.259 -14.137  1.00  0.00           C  
ATOM    757  CD  LYS A  50       2.862  -3.104 -14.686  1.00  0.00           C  
ATOM    758  CE  LYS A  50       3.660  -2.079 -13.895  1.00  0.00           C  
ATOM    759  NZ  LYS A  50       3.416  -0.692 -14.380  1.00  0.00           N  
ATOM    760  H   LYS A  50      -1.099  -2.832 -11.907  1.00  0.00           H  
ATOM    761  HA  LYS A  50       0.192  -5.320 -12.819  1.00  0.00           H  
ATOM    762  HB2 LYS A  50       1.492  -2.687 -12.095  1.00  0.00           H  
ATOM    763  HB3 LYS A  50       2.366  -4.171 -12.452  1.00  0.00           H  
ATOM    764  HG2 LYS A  50       0.954  -4.048 -14.680  1.00  0.00           H  
ATOM    765  HG3 LYS A  50       0.920  -2.330 -14.275  1.00  0.00           H  
ATOM    766  HD2 LYS A  50       3.368  -4.057 -14.631  1.00  0.00           H  
ATOM    767  HD3 LYS A  50       2.805  -2.785 -15.718  1.00  0.00           H  
ATOM    768  HE2 LYS A  50       3.373  -2.143 -12.857  1.00  0.00           H  
ATOM    769  HE3 LYS A  50       4.711  -2.306 -13.992  1.00  0.00           H  
ATOM    770  HZ1 LYS A  50       3.394  -0.032 -13.578  1.00  0.00           H  
ATOM    771  HZ2 LYS A  50       2.506  -0.644 -14.882  1.00  0.00           H  
ATOM    772  HZ3 LYS A  50       4.173  -0.405 -15.032  1.00  0.00           H  
ATOM    773  N   LYS A  51       0.543  -6.140 -10.518  1.00  0.00           N  
ATOM    774  CA  LYS A  51       0.706  -6.663  -9.166  1.00  0.00           C  
ATOM    775  C   LYS A  51       2.180  -6.716  -8.778  1.00  0.00           C  
ATOM    776  O   LYS A  51       3.059  -6.716  -9.639  1.00  0.00           O  
ATOM    777  CB  LYS A  51       0.090  -8.059  -9.059  1.00  0.00           C  
ATOM    778  CG  LYS A  51      -1.361  -8.049  -8.609  1.00  0.00           C  
ATOM    779  CD  LYS A  51      -1.739  -9.350  -7.919  1.00  0.00           C  
ATOM    780  CE  LYS A  51      -2.269 -10.374  -8.912  1.00  0.00           C  
ATOM    781  NZ  LYS A  51      -1.170 -11.163  -9.533  1.00  0.00           N  
ATOM    782  H   LYS A  51       0.527  -6.765 -11.273  1.00  0.00           H  
ATOM    783  HA  LYS A  51       0.192  -5.998  -8.490  1.00  0.00           H  
ATOM    784  HB2 LYS A  51       0.141  -8.538 -10.026  1.00  0.00           H  
ATOM    785  HB3 LYS A  51       0.661  -8.638  -8.349  1.00  0.00           H  
ATOM    786  HG2 LYS A  51      -1.509  -7.232  -7.919  1.00  0.00           H  
ATOM    787  HG3 LYS A  51      -1.996  -7.913  -9.473  1.00  0.00           H  
ATOM    788  HD2 LYS A  51      -0.866  -9.756  -7.432  1.00  0.00           H  
ATOM    789  HD3 LYS A  51      -2.503  -9.147  -7.183  1.00  0.00           H  
ATOM    790  HE2 LYS A  51      -2.936 -11.046  -8.394  1.00  0.00           H  
ATOM    791  HE3 LYS A  51      -2.811  -9.855  -9.689  1.00  0.00           H  
ATOM    792  HZ1 LYS A  51      -1.369 -11.321 -10.541  1.00  0.00           H  
ATOM    793  HZ2 LYS A  51      -1.082 -12.087  -9.061  1.00  0.00           H  
ATOM    794  HZ3 LYS A  51      -0.268 -10.654  -9.442  1.00  0.00           H  
ATOM    795  N   GLY A  52       2.444  -6.762  -7.476  1.00  0.00           N  
ATOM    796  CA  GLY A  52       3.813  -6.817  -6.997  1.00  0.00           C  
ATOM    797  C   GLY A  52       3.903  -6.729  -5.487  1.00  0.00           C  
ATOM    798  O   GLY A  52       2.882  -6.704  -4.797  1.00  0.00           O  
ATOM    799  H   GLY A  52       1.703  -6.760  -6.835  1.00  0.00           H  
ATOM    800  HA2 GLY A  52       4.259  -7.745  -7.321  1.00  0.00           H  
ATOM    801  HA3 GLY A  52       4.365  -5.994  -7.427  1.00  0.00           H  
ATOM    802  N   HIS A  53       5.126  -6.684  -4.970  1.00  0.00           N  
ATOM    803  CA  HIS A  53       5.346  -6.600  -3.530  1.00  0.00           C  
ATOM    804  C   HIS A  53       5.714  -5.177  -3.119  1.00  0.00           C  
ATOM    805  O   HIS A  53       6.786  -4.679  -3.463  1.00  0.00           O  
ATOM    806  CB  HIS A  53       6.449  -7.569  -3.104  1.00  0.00           C  
ATOM    807  CG  HIS A  53       6.070  -9.010  -3.248  1.00  0.00           C  
ATOM    808  ND1 HIS A  53       6.563  -9.822  -4.247  1.00  0.00           N  
ATOM    809  CD2 HIS A  53       5.241  -9.785  -2.510  1.00  0.00           C  
ATOM    810  CE1 HIS A  53       6.052 -11.034  -4.121  1.00  0.00           C  
ATOM    811  NE2 HIS A  53       5.248 -11.038  -3.073  1.00  0.00           N  
ATOM    812  H   HIS A  53       5.900  -6.707  -5.570  1.00  0.00           H  
ATOM    813  HA  HIS A  53       4.426  -6.877  -3.038  1.00  0.00           H  
ATOM    814  HB2 HIS A  53       7.326  -7.395  -3.710  1.00  0.00           H  
ATOM    815  HB3 HIS A  53       6.694  -7.392  -2.066  1.00  0.00           H  
ATOM    816  HD1 HIS A  53       7.191  -9.550  -4.948  1.00  0.00           H  
ATOM    817  HD2 HIS A  53       4.679  -9.477  -1.640  1.00  0.00           H  
ATOM    818  HE1 HIS A  53       6.258 -11.877  -4.762  1.00  0.00           H  
ATOM    819  HE2 HIS A  53       4.675 -11.786  -2.805  1.00  0.00           H  
ATOM    820  N   PHE A  54       4.818  -4.530  -2.381  1.00  0.00           N  
ATOM    821  CA  PHE A  54       5.048  -3.164  -1.924  1.00  0.00           C  
ATOM    822  C   PHE A  54       4.966  -3.079  -0.403  1.00  0.00           C  
ATOM    823  O   PHE A  54       4.292  -3.872   0.252  1.00  0.00           O  
ATOM    824  CB  PHE A  54       4.029  -2.214  -2.556  1.00  0.00           C  
ATOM    825  CG  PHE A  54       2.603  -2.620  -2.318  1.00  0.00           C  
ATOM    826  CD1 PHE A  54       1.948  -2.250  -1.155  1.00  0.00           C  
ATOM    827  CD2 PHE A  54       1.917  -3.373  -3.258  1.00  0.00           C  
ATOM    828  CE1 PHE A  54       0.636  -2.622  -0.932  1.00  0.00           C  
ATOM    829  CE2 PHE A  54       0.604  -3.748  -3.041  1.00  0.00           C  
ATOM    830  CZ  PHE A  54      -0.037  -3.373  -1.876  1.00  0.00           C  
ATOM    831  H   PHE A  54       3.982  -4.981  -2.138  1.00  0.00           H  
ATOM    832  HA  PHE A  54       6.040  -2.873  -2.236  1.00  0.00           H  
ATOM    833  HB2 PHE A  54       4.165  -1.226  -2.144  1.00  0.00           H  
ATOM    834  HB3 PHE A  54       4.192  -2.181  -3.623  1.00  0.00           H  
ATOM    835  HD1 PHE A  54       2.474  -1.662  -0.414  1.00  0.00           H  
ATOM    836  HD2 PHE A  54       2.418  -3.669  -4.168  1.00  0.00           H  
ATOM    837  HE1 PHE A  54       0.137  -2.327  -0.020  1.00  0.00           H  
ATOM    838  HE2 PHE A  54       0.081  -4.335  -3.780  1.00  0.00           H  
ATOM    839  HZ  PHE A  54      -1.062  -3.664  -1.705  1.00  0.00           H  
ATOM    840  N   PRO A  55       5.668  -2.091   0.172  1.00  0.00           N  
ATOM    841  CA  PRO A  55       5.691  -1.877   1.622  1.00  0.00           C  
ATOM    842  C   PRO A  55       4.356  -1.368   2.154  1.00  0.00           C  
ATOM    843  O   PRO A  55       3.566  -0.781   1.416  1.00  0.00           O  
ATOM    844  CB  PRO A  55       6.780  -0.816   1.807  1.00  0.00           C  
ATOM    845  CG  PRO A  55       6.824  -0.089   0.508  1.00  0.00           C  
ATOM    846  CD  PRO A  55       6.495  -1.108  -0.548  1.00  0.00           C  
ATOM    847  HA  PRO A  55       5.970  -2.776   2.152  1.00  0.00           H  
ATOM    848  HB2 PRO A  55       6.509  -0.157   2.621  1.00  0.00           H  
ATOM    849  HB3 PRO A  55       7.722  -1.296   2.023  1.00  0.00           H  
ATOM    850  HG2 PRO A  55       6.092   0.704   0.505  1.00  0.00           H  
ATOM    851  HG3 PRO A  55       7.814   0.311   0.345  1.00  0.00           H  
ATOM    852  HD2 PRO A  55       5.937  -0.651  -1.352  1.00  0.00           H  
ATOM    853  HD3 PRO A  55       7.397  -1.566  -0.925  1.00  0.00           H  
ATOM    854  N   ALA A  56       4.110  -1.599   3.440  1.00  0.00           N  
ATOM    855  CA  ALA A  56       2.872  -1.162   4.071  1.00  0.00           C  
ATOM    856  C   ALA A  56       2.997   0.264   4.598  1.00  0.00           C  
ATOM    857  O   ALA A  56       2.156   1.117   4.314  1.00  0.00           O  
ATOM    858  CB  ALA A  56       2.490  -2.111   5.198  1.00  0.00           C  
ATOM    859  H   ALA A  56       4.779  -2.072   3.977  1.00  0.00           H  
ATOM    860  HA  ALA A  56       2.089  -1.192   3.327  1.00  0.00           H  
ATOM    861  HB1 ALA A  56       3.182  -2.939   5.221  1.00  0.00           H  
ATOM    862  HB2 ALA A  56       2.527  -1.582   6.140  1.00  0.00           H  
ATOM    863  HB3 ALA A  56       1.489  -2.481   5.032  1.00  0.00           H  
ATOM    864  N   ALA A  57       4.051   0.516   5.366  1.00  0.00           N  
ATOM    865  CA  ALA A  57       4.287   1.839   5.931  1.00  0.00           C  
ATOM    866  C   ALA A  57       4.087   2.927   4.882  1.00  0.00           C  
ATOM    867  O   ALA A  57       3.845   4.087   5.215  1.00  0.00           O  
ATOM    868  CB  ALA A  57       5.687   1.920   6.518  1.00  0.00           C  
ATOM    869  H   ALA A  57       4.687  -0.205   5.556  1.00  0.00           H  
ATOM    870  HA  ALA A  57       3.577   1.991   6.732  1.00  0.00           H  
ATOM    871  HB1 ALA A  57       5.684   2.587   7.368  1.00  0.00           H  
ATOM    872  HB2 ALA A  57       6.002   0.935   6.835  1.00  0.00           H  
ATOM    873  HB3 ALA A  57       6.370   2.293   5.771  1.00  0.00           H  
ATOM    874  N   TYR A  58       4.192   2.546   3.613  1.00  0.00           N  
ATOM    875  CA  TYR A  58       4.027   3.490   2.515  1.00  0.00           C  
ATOM    876  C   TYR A  58       2.551   3.692   2.187  1.00  0.00           C  
ATOM    877  O   TYR A  58       2.125   4.790   1.830  1.00  0.00           O  
ATOM    878  CB  TYR A  58       4.774   2.998   1.274  1.00  0.00           C  
ATOM    879  CG  TYR A  58       6.263   3.262   1.320  1.00  0.00           C  
ATOM    880  CD1 TYR A  58       7.068   2.646   2.271  1.00  0.00           C  
ATOM    881  CD2 TYR A  58       6.863   4.126   0.413  1.00  0.00           C  
ATOM    882  CE1 TYR A  58       8.428   2.884   2.316  1.00  0.00           C  
ATOM    883  CE2 TYR A  58       8.222   4.369   0.451  1.00  0.00           C  
ATOM    884  CZ  TYR A  58       9.001   3.746   1.403  1.00  0.00           C  
ATOM    885  OH  TYR A  58      10.354   3.986   1.445  1.00  0.00           O  
ATOM    886  H   TYR A  58       4.388   1.607   3.411  1.00  0.00           H  
ATOM    887  HA  TYR A  58       4.447   4.437   2.825  1.00  0.00           H  
ATOM    888  HB2 TYR A  58       4.629   1.933   1.174  1.00  0.00           H  
ATOM    889  HB3 TYR A  58       4.375   3.495   0.403  1.00  0.00           H  
ATOM    890  HD1 TYR A  58       6.617   1.972   2.984  1.00  0.00           H  
ATOM    891  HD2 TYR A  58       6.250   4.613  -0.332  1.00  0.00           H  
ATOM    892  HE1 TYR A  58       9.038   2.396   3.062  1.00  0.00           H  
ATOM    893  HE2 TYR A  58       8.671   5.044  -0.264  1.00  0.00           H  
ATOM    894  HH  TYR A  58      10.518   4.921   1.306  1.00  0.00           H  
ATOM    895  N   VAL A  59       1.772   2.621   2.312  1.00  0.00           N  
ATOM    896  CA  VAL A  59       0.343   2.678   2.032  1.00  0.00           C  
ATOM    897  C   VAL A  59      -0.473   2.632   3.319  1.00  0.00           C  
ATOM    898  O   VAL A  59       0.030   2.235   4.369  1.00  0.00           O  
ATOM    899  CB  VAL A  59      -0.096   1.519   1.117  1.00  0.00           C  
ATOM    900  CG1 VAL A  59       0.727   1.507  -0.162  1.00  0.00           C  
ATOM    901  CG2 VAL A  59       0.019   0.190   1.849  1.00  0.00           C  
ATOM    902  H   VAL A  59       2.169   1.773   2.601  1.00  0.00           H  
ATOM    903  HA  VAL A  59       0.140   3.608   1.521  1.00  0.00           H  
ATOM    904  HB  VAL A  59      -1.132   1.670   0.850  1.00  0.00           H  
ATOM    905 HG11 VAL A  59       0.529   0.596  -0.708  1.00  0.00           H  
ATOM    906 HG12 VAL A  59       0.460   2.358  -0.771  1.00  0.00           H  
ATOM    907 HG13 VAL A  59       1.778   1.556   0.086  1.00  0.00           H  
ATOM    908 HG21 VAL A  59       0.891   0.204   2.485  1.00  0.00           H  
ATOM    909 HG22 VAL A  59      -0.864   0.033   2.450  1.00  0.00           H  
ATOM    910 HG23 VAL A  59       0.113  -0.610   1.129  1.00  0.00           H  
ATOM    911  N   GLU A  60      -1.734   3.041   3.229  1.00  0.00           N  
ATOM    912  CA  GLU A  60      -2.619   3.046   4.388  1.00  0.00           C  
ATOM    913  C   GLU A  60      -3.973   2.433   4.041  1.00  0.00           C  
ATOM    914  O   GLU A  60      -4.669   2.908   3.144  1.00  0.00           O  
ATOM    915  CB  GLU A  60      -2.810   4.474   4.905  1.00  0.00           C  
ATOM    916  CG  GLU A  60      -3.860   4.590   5.997  1.00  0.00           C  
ATOM    917  CD  GLU A  60      -3.311   4.255   7.371  1.00  0.00           C  
ATOM    918  OE1 GLU A  60      -3.150   3.053   7.669  1.00  0.00           O  
ATOM    919  OE2 GLU A  60      -3.042   5.195   8.148  1.00  0.00           O  
ATOM    920  H   GLU A  60      -2.077   3.347   2.363  1.00  0.00           H  
ATOM    921  HA  GLU A  60      -2.157   2.453   5.161  1.00  0.00           H  
ATOM    922  HB2 GLU A  60      -1.870   4.831   5.297  1.00  0.00           H  
ATOM    923  HB3 GLU A  60      -3.109   5.105   4.080  1.00  0.00           H  
ATOM    924  HG2 GLU A  60      -4.234   5.602   6.013  1.00  0.00           H  
ATOM    925  HG3 GLU A  60      -4.669   3.911   5.775  1.00  0.00           H  
ATOM    926  N   GLU A  61      -4.339   1.376   4.759  1.00  0.00           N  
ATOM    927  CA  GLU A  61      -5.609   0.697   4.527  1.00  0.00           C  
ATOM    928  C   GLU A  61      -6.778   1.668   4.665  1.00  0.00           C  
ATOM    929  O   GLU A  61      -6.826   2.470   5.599  1.00  0.00           O  
ATOM    930  CB  GLU A  61      -5.777  -0.465   5.506  1.00  0.00           C  
ATOM    931  CG  GLU A  61      -6.637  -1.596   4.967  1.00  0.00           C  
ATOM    932  CD  GLU A  61      -7.165  -2.502   6.063  1.00  0.00           C  
ATOM    933  OE1 GLU A  61      -8.219  -2.175   6.646  1.00  0.00           O  
ATOM    934  OE2 GLU A  61      -6.523  -3.538   6.335  1.00  0.00           O  
ATOM    935  H   GLU A  61      -3.740   1.045   5.461  1.00  0.00           H  
ATOM    936  HA  GLU A  61      -5.597   0.308   3.520  1.00  0.00           H  
ATOM    937  HB2 GLU A  61      -4.803  -0.864   5.746  1.00  0.00           H  
ATOM    938  HB3 GLU A  61      -6.236  -0.094   6.411  1.00  0.00           H  
ATOM    939  HG2 GLU A  61      -7.477  -1.171   4.436  1.00  0.00           H  
ATOM    940  HG3 GLU A  61      -6.044  -2.187   4.285  1.00  0.00           H  
ATOM    941  N   LEU A  62      -7.717   1.591   3.730  1.00  0.00           N  
ATOM    942  CA  LEU A  62      -8.887   2.462   3.746  1.00  0.00           C  
ATOM    943  C   LEU A  62     -10.174   1.646   3.806  1.00  0.00           C  
ATOM    944  O   LEU A  62     -10.244   0.514   3.325  1.00  0.00           O  
ATOM    945  CB  LEU A  62      -8.896   3.360   2.507  1.00  0.00           C  
ATOM    946  CG  LEU A  62      -7.681   4.270   2.329  1.00  0.00           C  
ATOM    947  CD1 LEU A  62      -7.685   4.902   0.945  1.00  0.00           C  
ATOM    948  CD2 LEU A  62      -7.654   5.343   3.407  1.00  0.00           C  
ATOM    949  H   LEU A  62      -7.624   0.933   3.011  1.00  0.00           H  
ATOM    950  HA  LEU A  62      -8.827   3.082   4.628  1.00  0.00           H  
ATOM    951  HB2 LEU A  62      -8.963   2.723   1.639  1.00  0.00           H  
ATOM    952  HB3 LEU A  62      -9.775   3.987   2.560  1.00  0.00           H  
ATOM    953  HG  LEU A  62      -6.780   3.679   2.422  1.00  0.00           H  
ATOM    954 HD11 LEU A  62      -6.969   5.709   0.916  1.00  0.00           H  
ATOM    955 HD12 LEU A  62      -8.671   5.286   0.729  1.00  0.00           H  
ATOM    956 HD13 LEU A  62      -7.420   4.157   0.209  1.00  0.00           H  
ATOM    957 HD21 LEU A  62      -7.261   4.926   4.321  1.00  0.00           H  
ATOM    958 HD22 LEU A  62      -8.658   5.704   3.579  1.00  0.00           H  
ATOM    959 HD23 LEU A  62      -7.028   6.163   3.085  1.00  0.00           H  
ATOM    960  N   PRO A  63     -11.219   2.232   4.409  1.00  0.00           N  
ATOM    961  CA  PRO A  63     -12.524   1.577   4.543  1.00  0.00           C  
ATOM    962  C   PRO A  63     -13.245   1.442   3.207  1.00  0.00           C  
ATOM    963  O   PRO A  63     -13.923   0.446   2.954  1.00  0.00           O  
ATOM    964  CB  PRO A  63     -13.297   2.514   5.475  1.00  0.00           C  
ATOM    965  CG  PRO A  63     -12.661   3.848   5.283  1.00  0.00           C  
ATOM    966  CD  PRO A  63     -11.208   3.578   5.005  1.00  0.00           C  
ATOM    967  HA  PRO A  63     -12.434   0.604   5.002  1.00  0.00           H  
ATOM    968  HB2 PRO A  63     -14.339   2.529   5.192  1.00  0.00           H  
ATOM    969  HB3 PRO A  63     -13.199   2.174   6.495  1.00  0.00           H  
ATOM    970  HG2 PRO A  63     -13.116   4.354   4.445  1.00  0.00           H  
ATOM    971  HG3 PRO A  63     -12.767   4.437   6.182  1.00  0.00           H  
ATOM    972  HD2 PRO A  63     -10.816   4.305   4.308  1.00  0.00           H  
ATOM    973  HD3 PRO A  63     -10.640   3.588   5.923  1.00  0.00           H  
ATOM    974  N   SER A  64     -13.094   2.450   2.354  1.00  0.00           N  
ATOM    975  CA  SER A  64     -13.734   2.444   1.043  1.00  0.00           C  
ATOM    976  C   SER A  64     -12.897   3.214   0.026  1.00  0.00           C  
ATOM    977  O   SER A  64     -12.106   4.084   0.389  1.00  0.00           O  
ATOM    978  CB  SER A  64     -15.135   3.054   1.133  1.00  0.00           C  
ATOM    979  OG  SER A  64     -15.962   2.587   0.082  1.00  0.00           O  
ATOM    980  H   SER A  64     -12.540   3.216   2.612  1.00  0.00           H  
ATOM    981  HA  SER A  64     -13.818   1.418   0.719  1.00  0.00           H  
ATOM    982  HB2 SER A  64     -15.583   2.781   2.076  1.00  0.00           H  
ATOM    983  HB3 SER A  64     -15.061   4.129   1.068  1.00  0.00           H  
ATOM    984  HG  SER A  64     -15.931   3.208  -0.649  1.00  0.00           H  
ATOM    985  N   ASN A  65     -13.077   2.887  -1.249  1.00  0.00           N  
ATOM    986  CA  ASN A  65     -12.339   3.546  -2.320  1.00  0.00           C  
ATOM    987  C   ASN A  65     -12.547   5.056  -2.274  1.00  0.00           C  
ATOM    988  O   ASN A  65     -13.209   5.575  -1.375  1.00  0.00           O  
ATOM    989  CB  ASN A  65     -12.776   3.001  -3.681  1.00  0.00           C  
ATOM    990  CG  ASN A  65     -11.670   3.074  -4.716  1.00  0.00           C  
ATOM    991  OD1 ASN A  65     -10.506   3.292  -4.382  1.00  0.00           O  
ATOM    992  ND2 ASN A  65     -12.031   2.894  -5.981  1.00  0.00           N  
ATOM    993  H   ASN A  65     -13.722   2.185  -1.476  1.00  0.00           H  
ATOM    994  HA  ASN A  65     -11.289   3.335  -2.178  1.00  0.00           H  
ATOM    995  HB2 ASN A  65     -13.070   1.967  -3.570  1.00  0.00           H  
ATOM    996  HB3 ASN A  65     -13.618   3.574  -4.038  1.00  0.00           H  
ATOM    997 HD21 ASN A  65     -12.978   2.726  -6.174  1.00  0.00           H  
ATOM    998 HD22 ASN A  65     -11.337   2.937  -6.671  1.00  0.00           H  
ATOM    999  N   ALA A  66     -11.977   5.757  -3.249  1.00  0.00           N  
ATOM   1000  CA  ALA A  66     -12.102   7.208  -3.321  1.00  0.00           C  
ATOM   1001  C   ALA A  66     -13.219   7.615  -4.276  1.00  0.00           C  
ATOM   1002  O   ALA A  66     -13.303   7.117  -5.398  1.00  0.00           O  
ATOM   1003  CB  ALA A  66     -10.783   7.830  -3.754  1.00  0.00           C  
ATOM   1004  H   ALA A  66     -11.461   5.287  -3.936  1.00  0.00           H  
ATOM   1005  HA  ALA A  66     -12.337   7.573  -2.332  1.00  0.00           H  
ATOM   1006  HB1 ALA A  66     -10.922   8.358  -4.685  1.00  0.00           H  
ATOM   1007  HB2 ALA A  66     -10.446   8.522  -2.996  1.00  0.00           H  
ATOM   1008  HB3 ALA A  66     -10.045   7.053  -3.887  1.00  0.00           H  
ATOM   1009  N   GLY A  67     -14.077   8.524  -3.822  1.00  0.00           N  
ATOM   1010  CA  GLY A  67     -15.180   8.982  -4.649  1.00  0.00           C  
ATOM   1011  C   GLY A  67     -15.788   7.865  -5.473  1.00  0.00           C  
ATOM   1012  O   GLY A  67     -16.194   6.837  -4.933  1.00  0.00           O  
ATOM   1013  H   GLY A  67     -13.961   8.887  -2.919  1.00  0.00           H  
ATOM   1014  HA2 GLY A  67     -15.941   9.403  -4.011  1.00  0.00           H  
ATOM   1015  HA3 GLY A  67     -14.818   9.751  -5.317  1.00  0.00           H  
ATOM   1016  N   ASN A  68     -15.855   8.069  -6.785  1.00  0.00           N  
ATOM   1017  CA  ASN A  68     -16.423   7.072  -7.685  1.00  0.00           C  
ATOM   1018  C   ASN A  68     -15.735   7.114  -9.046  1.00  0.00           C  
ATOM   1019  O   ASN A  68     -15.949   8.034  -9.836  1.00  0.00           O  
ATOM   1020  CB  ASN A  68     -17.926   7.302  -7.854  1.00  0.00           C  
ATOM   1021  CG  ASN A  68     -18.585   7.776  -6.573  1.00  0.00           C  
ATOM   1022  OD1 ASN A  68     -18.472   8.942  -6.197  1.00  0.00           O  
ATOM   1023  ND2 ASN A  68     -19.279   6.869  -5.895  1.00  0.00           N  
ATOM   1024  H   ASN A  68     -15.515   8.910  -7.156  1.00  0.00           H  
ATOM   1025  HA  ASN A  68     -16.264   6.099  -7.244  1.00  0.00           H  
ATOM   1026  HB2 ASN A  68     -18.086   8.051  -8.615  1.00  0.00           H  
ATOM   1027  HB3 ASN A  68     -18.394   6.380  -8.159  1.00  0.00           H  
ATOM   1028 HD21 ASN A  68     -19.326   5.957  -6.254  1.00  0.00           H  
ATOM   1029 HD22 ASN A  68     -19.716   7.148  -5.063  1.00  0.00           H  
ATOM   1030  N   THR A  69     -14.906   6.109  -9.315  1.00  0.00           N  
ATOM   1031  CA  THR A  69     -14.186   6.031 -10.580  1.00  0.00           C  
ATOM   1032  C   THR A  69     -14.956   5.202 -11.601  1.00  0.00           C  
ATOM   1033  O   THR A  69     -15.093   3.987 -11.453  1.00  0.00           O  
ATOM   1034  CB  THR A  69     -12.784   5.420 -10.391  1.00  0.00           C  
ATOM   1035  OG1 THR A  69     -12.061   6.151  -9.396  1.00  0.00           O  
ATOM   1036  CG2 THR A  69     -12.008   5.431 -11.699  1.00  0.00           C  
ATOM   1037  H   THR A  69     -14.776   5.406  -8.646  1.00  0.00           H  
ATOM   1038  HA  THR A  69     -14.069   7.035 -10.960  1.00  0.00           H  
ATOM   1039  HB  THR A  69     -12.896   4.396 -10.065  1.00  0.00           H  
ATOM   1040  HG1 THR A  69     -11.711   6.957  -9.781  1.00  0.00           H  
ATOM   1041 HG21 THR A  69     -10.956   5.558 -11.493  1.00  0.00           H  
ATOM   1042 HG22 THR A  69     -12.354   6.247 -12.316  1.00  0.00           H  
ATOM   1043 HG23 THR A  69     -12.163   4.497 -12.218  1.00  0.00           H  
ATOM   1044  N   ALA A  70     -15.457   5.865 -12.638  1.00  0.00           N  
ATOM   1045  CA  ALA A  70     -16.211   5.189 -13.685  1.00  0.00           C  
ATOM   1046  C   ALA A  70     -16.153   5.967 -14.995  1.00  0.00           C  
ATOM   1047  O   ALA A  70     -15.786   7.143 -15.015  1.00  0.00           O  
ATOM   1048  CB  ALA A  70     -17.657   4.990 -13.251  1.00  0.00           C  
ATOM   1049  H   ALA A  70     -15.315   6.832 -12.701  1.00  0.00           H  
ATOM   1050  HA  ALA A  70     -15.770   4.213 -13.837  1.00  0.00           H  
ATOM   1051  HB1 ALA A  70     -18.094   4.181 -13.816  1.00  0.00           H  
ATOM   1052  HB2 ALA A  70     -17.685   4.752 -12.198  1.00  0.00           H  
ATOM   1053  HB3 ALA A  70     -18.213   5.898 -13.431  1.00  0.00           H  
ATOM   1054  N   THR A  71     -16.515   5.305 -16.089  1.00  0.00           N  
ATOM   1055  CA  THR A  71     -16.501   5.933 -17.403  1.00  0.00           C  
ATOM   1056  C   THR A  71     -17.745   5.562 -18.203  1.00  0.00           C  
ATOM   1057  O   THR A  71     -18.501   4.669 -17.818  1.00  0.00           O  
ATOM   1058  CB  THR A  71     -15.250   5.531 -18.206  1.00  0.00           C  
ATOM   1059  OG1 THR A  71     -15.137   6.347 -19.378  1.00  0.00           O  
ATOM   1060  CG2 THR A  71     -15.310   4.066 -18.605  1.00  0.00           C  
ATOM   1061  H   THR A  71     -16.797   4.369 -16.010  1.00  0.00           H  
ATOM   1062  HA  THR A  71     -16.484   7.004 -17.261  1.00  0.00           H  
ATOM   1063  HB  THR A  71     -14.379   5.686 -17.585  1.00  0.00           H  
ATOM   1064  HG1 THR A  71     -14.540   5.927 -20.003  1.00  0.00           H  
ATOM   1065 HG21 THR A  71     -15.123   3.449 -17.738  1.00  0.00           H  
ATOM   1066 HG22 THR A  71     -14.561   3.865 -19.356  1.00  0.00           H  
ATOM   1067 HG23 THR A  71     -16.289   3.841 -19.002  1.00  0.00           H  
ATOM   1068  N   LYS A  72     -17.952   6.253 -19.320  1.00  0.00           N  
ATOM   1069  CA  LYS A  72     -19.103   5.994 -20.177  1.00  0.00           C  
ATOM   1070  C   LYS A  72     -18.676   5.858 -21.635  1.00  0.00           C  
ATOM   1071  O   LYS A  72     -18.416   6.853 -22.311  1.00  0.00           O  
ATOM   1072  CB  LYS A  72     -20.130   7.121 -20.039  1.00  0.00           C  
ATOM   1073  CG  LYS A  72     -21.556   6.681 -20.321  1.00  0.00           C  
ATOM   1074  CD  LYS A  72     -21.859   6.690 -21.809  1.00  0.00           C  
ATOM   1075  CE  LYS A  72     -23.311   6.331 -22.085  1.00  0.00           C  
ATOM   1076  NZ  LYS A  72     -24.246   7.373 -21.579  1.00  0.00           N  
ATOM   1077  H   LYS A  72     -17.314   6.953 -19.575  1.00  0.00           H  
ATOM   1078  HA  LYS A  72     -19.553   5.067 -19.858  1.00  0.00           H  
ATOM   1079  HB2 LYS A  72     -20.088   7.508 -19.031  1.00  0.00           H  
ATOM   1080  HB3 LYS A  72     -19.877   7.910 -20.730  1.00  0.00           H  
ATOM   1081  HG2 LYS A  72     -21.696   5.679 -19.942  1.00  0.00           H  
ATOM   1082  HG3 LYS A  72     -22.237   7.355 -19.819  1.00  0.00           H  
ATOM   1083  HD2 LYS A  72     -21.664   7.677 -22.202  1.00  0.00           H  
ATOM   1084  HD3 LYS A  72     -21.219   5.972 -22.303  1.00  0.00           H  
ATOM   1085  HE2 LYS A  72     -23.446   6.225 -23.151  1.00  0.00           H  
ATOM   1086  HE3 LYS A  72     -23.534   5.392 -21.601  1.00  0.00           H  
ATOM   1087  HZ1 LYS A  72     -24.085   7.535 -20.564  1.00  0.00           H  
ATOM   1088  HZ2 LYS A  72     -25.231   7.066 -21.718  1.00  0.00           H  
ATOM   1089  HZ3 LYS A  72     -24.098   8.265 -22.090  1.00  0.00           H  
ATOM   1090  N   ALA A  73     -18.608   4.620 -22.114  1.00  0.00           N  
ATOM   1091  CA  ALA A  73     -18.216   4.354 -23.492  1.00  0.00           C  
ATOM   1092  C   ALA A  73     -19.404   3.871 -24.317  1.00  0.00           C  
ATOM   1093  O   ALA A  73     -20.507   3.708 -23.797  1.00  0.00           O  
ATOM   1094  CB  ALA A  73     -17.091   3.331 -23.532  1.00  0.00           C  
ATOM   1095  H   ALA A  73     -18.826   3.868 -21.526  1.00  0.00           H  
ATOM   1096  HA  ALA A  73     -17.846   5.276 -23.917  1.00  0.00           H  
ATOM   1097  HB1 ALA A  73     -17.423   2.452 -24.065  1.00  0.00           H  
ATOM   1098  HB2 ALA A  73     -16.236   3.756 -24.038  1.00  0.00           H  
ATOM   1099  HB3 ALA A  73     -16.815   3.058 -22.525  1.00  0.00           H  
ATOM   1100  N   SER A  74     -19.170   3.645 -25.605  1.00  0.00           N  
ATOM   1101  CA  SER A  74     -20.223   3.184 -26.504  1.00  0.00           C  
ATOM   1102  C   SER A  74     -19.685   2.145 -27.483  1.00  0.00           C  
ATOM   1103  O   SER A  74     -18.550   2.243 -27.947  1.00  0.00           O  
ATOM   1104  CB  SER A  74     -20.820   4.365 -27.271  1.00  0.00           C  
ATOM   1105  OG  SER A  74     -22.060   4.015 -27.861  1.00  0.00           O  
ATOM   1106  H   SER A  74     -18.269   3.793 -25.961  1.00  0.00           H  
ATOM   1107  HA  SER A  74     -20.995   2.729 -25.903  1.00  0.00           H  
ATOM   1108  HB2 SER A  74     -20.978   5.189 -26.593  1.00  0.00           H  
ATOM   1109  HB3 SER A  74     -20.135   4.666 -28.051  1.00  0.00           H  
ATOM   1110  HG  SER A  74     -21.907   3.653 -28.737  1.00  0.00           H  
ATOM   1111  N   GLY A  75     -20.512   1.151 -27.794  1.00  0.00           N  
ATOM   1112  CA  GLY A  75     -20.102   0.107 -28.715  1.00  0.00           C  
ATOM   1113  C   GLY A  75     -21.272  -0.717 -29.214  1.00  0.00           C  
ATOM   1114  O   GLY A  75     -22.428  -0.297 -29.150  1.00  0.00           O  
ATOM   1115  H   GLY A  75     -21.406   1.125 -27.393  1.00  0.00           H  
ATOM   1116  HA2 GLY A  75     -19.610   0.563 -29.562  1.00  0.00           H  
ATOM   1117  HA3 GLY A  75     -19.403  -0.546 -28.215  1.00  0.00           H  
ATOM   1118  N   PRO A  76     -20.977  -1.921 -29.726  1.00  0.00           N  
ATOM   1119  CA  PRO A  76     -22.000  -2.832 -30.248  1.00  0.00           C  
ATOM   1120  C   PRO A  76     -22.882  -3.408 -29.145  1.00  0.00           C  
ATOM   1121  O   PRO A  76     -22.595  -4.475 -28.602  1.00  0.00           O  
ATOM   1122  CB  PRO A  76     -21.182  -3.942 -30.912  1.00  0.00           C  
ATOM   1123  CG  PRO A  76     -19.872  -3.923 -30.203  1.00  0.00           C  
ATOM   1124  CD  PRO A  76     -19.622  -2.487 -29.833  1.00  0.00           C  
ATOM   1125  HA  PRO A  76     -22.622  -2.349 -30.988  1.00  0.00           H  
ATOM   1126  HB2 PRO A  76     -21.687  -4.889 -30.788  1.00  0.00           H  
ATOM   1127  HB3 PRO A  76     -21.064  -3.726 -31.964  1.00  0.00           H  
ATOM   1128  HG2 PRO A  76     -19.927  -4.535 -29.315  1.00  0.00           H  
ATOM   1129  HG3 PRO A  76     -19.094  -4.282 -30.861  1.00  0.00           H  
ATOM   1130  HD2 PRO A  76     -19.103  -2.426 -28.888  1.00  0.00           H  
ATOM   1131  HD3 PRO A  76     -19.058  -1.990 -30.609  1.00  0.00           H  
ATOM   1132  N   SER A  77     -23.955  -2.695 -28.819  1.00  0.00           N  
ATOM   1133  CA  SER A  77     -24.877  -3.134 -27.777  1.00  0.00           C  
ATOM   1134  C   SER A  77     -24.189  -3.153 -26.416  1.00  0.00           C  
ATOM   1135  O   SER A  77     -24.402  -4.059 -25.611  1.00  0.00           O  
ATOM   1136  CB  SER A  77     -25.423  -4.526 -28.103  1.00  0.00           C  
ATOM   1137  OG  SER A  77     -26.717  -4.708 -27.554  1.00  0.00           O  
ATOM   1138  H   SER A  77     -24.129  -1.852 -29.288  1.00  0.00           H  
ATOM   1139  HA  SER A  77     -25.697  -2.433 -27.744  1.00  0.00           H  
ATOM   1140  HB2 SER A  77     -25.479  -4.645 -29.174  1.00  0.00           H  
ATOM   1141  HB3 SER A  77     -24.761  -5.275 -27.692  1.00  0.00           H  
ATOM   1142  HG  SER A  77     -27.314  -4.050 -27.917  1.00  0.00           H  
ATOM   1143  N   SER A  78     -23.362  -2.142 -26.164  1.00  0.00           N  
ATOM   1144  CA  SER A  78     -22.639  -2.043 -24.902  1.00  0.00           C  
ATOM   1145  C   SER A  78     -23.574  -2.279 -23.719  1.00  0.00           C  
ATOM   1146  O   SER A  78     -23.315  -3.129 -22.869  1.00  0.00           O  
ATOM   1147  CB  SER A  78     -21.976  -0.669 -24.776  1.00  0.00           C  
ATOM   1148  OG  SER A  78     -21.337  -0.525 -23.519  1.00  0.00           O  
ATOM   1149  H   SER A  78     -23.233  -1.449 -26.846  1.00  0.00           H  
ATOM   1150  HA  SER A  78     -21.873  -2.804 -24.897  1.00  0.00           H  
ATOM   1151  HB2 SER A  78     -21.240  -0.555 -25.556  1.00  0.00           H  
ATOM   1152  HB3 SER A  78     -22.729   0.100 -24.874  1.00  0.00           H  
ATOM   1153  HG  SER A  78     -20.684  -1.220 -23.410  1.00  0.00           H  
ATOM   1154  N   GLY A  79     -24.664  -1.518 -23.674  1.00  0.00           N  
ATOM   1155  CA  GLY A  79     -25.623  -1.659 -22.594  1.00  0.00           C  
ATOM   1156  C   GLY A  79     -26.828  -0.758 -22.767  1.00  0.00           C  
ATOM   1157  O   GLY A  79     -27.465  -0.367 -21.789  1.00  0.00           O  
ATOM   1158  H   GLY A  79     -24.819  -0.857 -24.381  1.00  0.00           H  
ATOM   1159  HA2 GLY A  79     -25.956  -2.685 -22.554  1.00  0.00           H  
ATOM   1160  HA3 GLY A  79     -25.135  -1.414 -21.661  1.00  0.00           H  
TER    1161      GLY A  79                                                      
END
MOLECULE T0492.pdb
ATOM     18  N   PHE     2      -1.543   4.722  10.626  1.00 74.01
ATOM     19  HN  PHE     2      -1.545   5.677  10.295  1.00  0.00
ATOM     20  CA  PHE     2      -2.153   3.701   9.795  1.00  3.52
ATOM     21  HA  PHE     2      -2.214   2.774  10.364  1.00  0.00
ATOM     22  CB  PHE     2      -3.570   4.116   9.379  1.00 43.40
ATOM     23 2HB  PHE     2      -4.130   4.382  10.276  1.00  0.00
ATOM     24 3HB  PHE     2      -3.499   4.995   8.737  1.00  0.00
ATOM     25  CG  PHE     2      -4.330   3.046   8.642  1.00 20.11
ATOM     26  CD1 PHE     2      -4.372   3.032   7.256  1.00 62.52
ATOM     27 1HD  PHE     2      -3.855   3.800   6.699  1.00  0.00
ATOM     28  CE1 PHE     2      -5.067   2.049   6.579  1.00 34.45
ATOM     29 1HE  PHE     2      -5.093   2.052   5.499  1.00  0.00
ATOM     30  CZ  PHE     2      -5.728   1.064   7.284  1.00 62.44
ATOM     31  HZ  PHE     2      -6.269   0.293   6.756  1.00  0.00
ATOM     32  CE2 PHE     2      -5.698   1.066   8.665  1.00 65.21
ATOM     33 2HE  PHE     2      -6.220   0.300   9.218  1.00  0.00
ATOM     34  CD2 PHE     2      -4.999   2.051   9.338  1.00  5.40
ATOM     35 2HD  PHE     2      -4.974   2.046  10.418  1.00  0.00
ATOM     36  C   PHE     2      -1.276   3.477   8.572  1.00 11.34
ATOM     37  O   PHE     2      -1.121   4.368   7.734  1.00 25.11
ATOM     38  N   SER     3      -0.684   2.301   8.493  1.00 64.43
ATOM     39  HN  SER     3      -0.879   1.592   9.184  1.00  0.00
ATOM     40  CA  SER     3       0.249   1.991   7.431  1.00 24.31
ATOM     41  HA  SER     3       0.539   2.917   6.933  1.00  0.00
ATOM     42  CB  SER     3       1.493   1.334   8.027  1.00 64.20
ATOM     43 2HB  SER     3       1.287   0.280   8.213  1.00  0.00
ATOM     44 3HB  SER     3       2.318   1.424   7.320  1.00  0.00
ATOM     45  OG  SER     3       1.856   1.959   9.247  1.00 35.21
ATOM     46  HG  SER     3       2.639   1.527   9.597  1.00  0.00
ATOM     47  C   SER     3      -0.397   1.063   6.412  1.00 60.05
ATOM     48  O   SER     3      -1.528   0.612   6.597  1.00  3.21
ATOM     49  N   LEU     4       0.328   0.765   5.345  1.00 12.31
ATOM     50  HN  LEU     4       1.247   1.169   5.233  1.00  0.00
ATOM     51  CA  LEU     4      -0.162  -0.138   4.314  1.00 14.12
ATOM     52  HA  LEU     4      -1.150   0.198   4.000  1.00  0.00
ATOM     53  CB  LEU     4       0.773  -0.115   3.101  1.00 12.03
ATOM     54 2HB  LEU     4       0.891   0.923   2.787  1.00  0.00
ATOM     55 3HB  LEU     4       1.739  -0.512   3.413  1.00  0.00
ATOM     56  CG  LEU     4       0.298  -0.924   1.891  1.00 23.03
ATOM     57  HG  LEU     4       0.144  -1.956   2.206  1.00  0.00
ATOM     58  CD1 LEU     4      -1.022  -0.380   1.370  1.00 51.12
ATOM     59 1HD1 LEU     4      -1.358  -0.976   0.522  1.00  0.00
ATOM     60 2HD1 LEU     4      -1.770  -0.424   2.162  1.00  0.00
ATOM     61 3HD1 LEU     4      -0.888   0.655   1.054  1.00  0.00
ATOM     62  CD2 LEU     4       1.353  -0.909   0.796  1.00 63.44
ATOM     63 1HD2 LEU     4       1.014  -1.505  -0.051  1.00  0.00
ATOM     64 2HD2 LEU     4       1.524   0.118   0.470  1.00  0.00
ATOM     65 3HD2 LEU     4       2.283  -1.326   1.182  1.00  0.00
ATOM     66  C   LEU     4      -0.277  -1.556   4.867  1.00 33.11
ATOM     67  O   LEU     4      -1.097  -2.351   4.413  1.00 44.21
ATOM     68  N   ARG     5       0.537  -1.858   5.872  1.00 30.21
ATOM     69  HN  ARG     5       1.184  -1.165   6.222  1.00  0.00
ATOM     70  CA  ARG     5       0.527  -3.177   6.493  1.00 63.40
ATOM     71  HA  ARG     5       0.383  -3.914   5.703  1.00  0.00
ATOM     72  CB  ARG     5       1.875  -3.467   7.172  1.00 74.52
ATOM     73 2HB  ARG     5       1.804  -4.437   7.663  1.00  0.00
ATOM     74 3HB  ARG     5       2.642  -3.506   6.398  1.00  0.00
ATOM     75  CG  ARG     5       2.309  -2.440   8.214  1.00  4.51
ATOM     76 2HG  ARG     5       3.389  -2.511   8.347  1.00  0.00
ATOM     77 3HG  ARG     5       2.052  -1.444   7.852  1.00  0.00
ATOM     78  CD  ARG     5       1.636  -2.660   9.559  1.00 60.41
ATOM     79 2HD  ARG     5       0.561  -2.522   9.442  1.00  0.00
ATOM     80 3HD  ARG     5       1.833  -3.680   9.889  1.00  0.00
ATOM     81  NE  ARG     5       2.123  -1.732  10.576  1.00 53.25
ATOM     82  HE  ARG     5       2.750  -1.000  10.273  1.00  0.00
ATOM     83  CZ  ARG     5       1.788  -1.799  11.863  1.00 31.32
ATOM     84  NH1 ARG     5       0.974  -2.752  12.297  1.00 42.13
ATOM     85 1HH1 ARG     5       0.725  -2.799  13.274  1.00  0.00
ATOM     86 2HH1 ARG     5       0.603  -3.431  11.649  1.00  0.00
ATOM     87  NH2 ARG     5       2.275  -0.912  12.719  1.00  5.31
ATOM     88 1HH2 ARG     5       2.024  -0.962  13.696  1.00  0.00
ATOM     89 2HH2 ARG     5       2.898  -0.185  12.394  1.00  0.00
ATOM     90  C   ARG     5      -0.629  -3.317   7.482  1.00 10.22
ATOM     91  O   ARG     5      -0.864  -4.396   8.028  1.00 64.31
ATOM     92  N   ASP     6      -1.337  -2.219   7.719  1.00 63.24
ATOM     93  HN  ASP     6      -1.079  -1.348   7.276  1.00  0.00
ATOM     94  CA  ASP     6      -2.490  -2.231   8.612  1.00 35.34
ATOM     95  HA  ASP     6      -2.323  -2.992   9.374  1.00  0.00
ATOM     96  CB  ASP     6      -2.667  -0.876   9.304  1.00 22.10
ATOM     97 2HB  ASP     6      -2.603  -0.090   8.551  1.00  0.00
ATOM     98 3HB  ASP     6      -3.653  -0.848   9.767  1.00  0.00
ATOM     99  CG  ASP     6      -1.625  -0.608  10.371  1.00 45.42
ATOM    100  OD1 ASP     6      -1.739  -1.182  11.475  1.00 64.32
ATOM    101  OD2 ASP     6      -0.704   0.198  10.124  1.00 21.34
ATOM    102 2HD  ASP     6      -0.086   0.324  10.848  1.00  0.00
ATOM    103  C   ASP     6      -3.756  -2.578   7.839  1.00 55.21
ATOM    104  O   ASP     6      -4.831  -2.744   8.422  1.00 30.54
ATOM    105  N   ALA     7      -3.625  -2.680   6.524  1.00 72.34
ATOM    106  HN  ALA     7      -2.728  -2.503   6.093  1.00  0.00
ATOM    107  CA  ALA     7      -4.743  -3.041   5.669  1.00 22.13
ATOM    108  HA  ALA     7      -5.659  -2.672   6.130  1.00  0.00
ATOM    109  CB  ALA     7      -4.595  -2.392   4.302  1.00 22.42
ATOM    110 1HB  ALA     7      -5.451  -2.648   3.677  1.00  0.00
ATOM    111 2HB  ALA     7      -4.544  -1.309   4.418  1.00  0.00
ATOM    112 3HB  ALA     7      -3.681  -2.749   3.828  1.00  0.00
ATOM    113  C   ALA     7      -4.843  -4.555   5.534  1.00 53.13
ATOM    114  O   ALA     7      -3.841  -5.264   5.629  1.00 30.50
ATOM    115  N   LYS     8      -6.054  -5.046   5.322  1.00 32.51
ATOM    116  HN  LYS     8      -6.843  -4.420   5.247  1.00  0.00
ATOM    117  CA  LYS     8      -6.289  -6.477   5.191  1.00 22.44
ATOM    118  HA  LYS     8      -5.454  -7.012   5.645  1.00  0.00
ATOM    119  CB  LYS     8      -7.584  -6.872   5.910  1.00 13.25
ATOM    120 2HB  LYS     8      -8.423  -6.441   5.364  1.00  0.00
ATOM    121 3HB  LYS     8      -7.663  -7.959   5.899  1.00  0.00
ATOM    122  CG  LYS     8      -7.664  -6.403   7.354  1.00 65.44
ATOM    123 2HG  LYS     8      -7.546  -5.319   7.379  1.00  0.00
ATOM    124 3HG  LYS     8      -8.640  -6.671   7.758  1.00  0.00
ATOM    125  CD  LYS     8      -6.584  -7.035   8.217  1.00 11.52
ATOM    126 2HD  LYS     8      -6.700  -8.118   8.196  1.00  0.00
ATOM    127 3HD  LYS     8      -5.606  -6.767   7.816  1.00  0.00
ATOM    128  CE  LYS     8      -6.680  -6.553   9.654  1.00 44.24
ATOM    129 2HE  LYS     8      -6.530  -5.473   9.674  1.00  0.00
ATOM    130 3HE  LYS     8      -7.674  -6.784  10.037  1.00  0.00
ATOM    131  NZ  LYS     8      -5.665  -7.196  10.531  1.00  4.24
ATOM    132 1HZ  LYS     8      -5.760  -6.850  11.475  1.00  0.00
ATOM    133 2HZ  LYS     8      -5.801  -8.196  10.525  1.00  0.00
ATOM    134 3HZ  LYS     8      -4.740  -6.980  10.188  1.00  0.00
ATOM    135  C   LYS     8      -6.383  -6.857   3.718  1.00 42.14
ATOM    136  O   LYS     8      -6.815  -6.049   2.891  1.00 20.55
ATOM    137  N   CYS     9      -5.980  -8.076   3.388  1.00 41.51
ATOM    138  HN  CYS     9      -5.610  -8.695   4.094  1.00  0.00
ATOM    139  CA  CYS     9      -6.058  -8.552   2.015  1.00  2.35
ATOM    140  HA  CYS     9      -5.629  -7.787   1.367  1.00  0.00
ATOM    141  CB  CYS     9      -5.243  -9.834   1.843  1.00 21.02
ATOM    142 2HB  CYS     9      -5.616 -10.355   0.961  1.00  0.00
ATOM    143 3HB  CYS     9      -4.201  -9.552   1.687  1.00  0.00
ATOM    144  SG  CYS     9      -5.327 -10.961   3.252  1.00 72.52
ATOM    145  HG  CYS     9      -4.531 -11.912   2.755  1.00  0.00
ATOM    146  C   CYS     9      -7.512  -8.761   1.608  1.00 15.30
ATOM    147  O   CYS     9      -8.192  -9.663   2.102  1.00 13.32
ATOM    148  N   GLY    10      -7.978  -7.908   0.711  1.00 51.22
ATOM    149  HN  GLY    10      -7.355  -7.248   0.267  1.00  0.00
ATOM    150  CA  GLY    10      -9.376  -7.897   0.346  1.00  3.45
ATOM    151 1HA  GLY    10      -9.478  -8.244  -0.682  1.00  0.00
ATOM    152 2HA  GLY    10      -9.922  -8.567   1.009  1.00  0.00
ATOM    153  C   GLY    10      -9.962  -6.506   0.458  1.00 12.24
ATOM    154  O   GLY    10     -11.091  -6.256   0.029  1.00 13.34
ATOM    155  N   GLN    11      -9.191  -5.600   1.045  1.00 41.41
ATOM    156  HN  GLN    11      -8.285  -5.870   1.401  1.00  0.00
ATOM    157  CA  GLN    11      -9.605  -4.213   1.198  1.00 43.31
ATOM    158  HA  GLN    11     -10.686  -4.162   1.069  1.00  0.00
ATOM    159  CB  GLN    11      -9.253  -3.704   2.597  1.00 35.22
ATOM    160 2HB  GLN    11      -8.178  -3.812   2.741  1.00  0.00
ATOM    161 3HB  GLN    11      -9.523  -2.649   2.657  1.00  0.00
ATOM    162  CG  GLN    11      -9.963  -4.445   3.718  1.00 24.45
ATOM    163 2HG  GLN    11     -11.038  -4.302   3.607  1.00  0.00
ATOM    164 3HG  GLN    11      -9.731  -5.507   3.638  1.00  0.00
ATOM    165  CD  GLN    11      -9.544  -3.956   5.092  1.00 53.41
ATOM    166  OE1 GLN    11      -8.414  -3.504   5.288  1.00 54.04
ATOM    167  NE2 GLN    11     -10.448  -4.036   6.053  1.00 44.33
ATOM    168 1HE2 GLN    11     -11.363  -4.411   5.850  1.00  0.00
ATOM    169 2HE2 GLN    11     -10.222  -3.722   6.986  1.00  0.00
ATOM    170  C   GLN    11      -8.945  -3.330   0.142  1.00  4.23
ATOM    171  O   GLN    11      -7.996  -3.743  -0.527  1.00 30.34
ATOM    172  N   THR    12      -9.461  -2.119  -0.008  1.00  5.22
ATOM    173  HN  THR    12     -10.253  -1.839   0.553  1.00  0.00
ATOM    174  CA  THR    12      -8.921  -1.166  -0.962  1.00 72.31
ATOM    175  HA  THR    12      -8.091  -1.639  -1.488  1.00  0.00
ATOM    176  CB  THR    12      -9.989  -0.754  -1.992  1.00 24.54
ATOM    177  HB  THR    12     -10.761  -0.176  -1.484  1.00  0.00
ATOM    178  OG1 THR    12     -10.582  -1.926  -2.562  1.00 13.33
ATOM    179 1HG  THR    12     -11.256  -1.655  -3.189  1.00  0.00
ATOM    180  CG2 THR    12      -9.387   0.100  -3.099  1.00  4.01
ATOM    181 1HG2 THR    12     -10.161   0.386  -3.812  1.00  0.00
ATOM    182 2HG2 THR    12      -8.948   0.999  -2.665  1.00  0.00
ATOM    183 3HG2 THR    12      -8.613  -0.469  -3.615  1.00  0.00
ATOM    184  C   THR    12      -8.405   0.076  -0.241  1.00 11.14
ATOM    185  O   THR    12      -9.153   0.749   0.471  1.00 21.50
ATOM    186  N   VAL    13      -7.125   0.365  -0.412  1.00 64.12
ATOM    187  HN  VAL    13      -6.544  -0.236  -0.979  1.00  0.00
ATOM    188  CA  VAL    13      -6.521   1.536   0.199  1.00 41.30
ATOM    189  HA  VAL    13      -7.285   2.035   0.796  1.00  0.00
ATOM    190  CB  VAL    13      -5.340   1.166   1.121  1.00 62.24
ATOM    191  HB  VAL    13      -4.903   2.090   1.500  1.00  0.00
ATOM    192  CG1 VAL    13      -5.810   0.344   2.308  1.00 31.14
ATOM    193 1HG1 VAL    13      -4.965   0.114   2.957  1.00  0.00
ATOM    194 2HG1 VAL    13      -6.553   0.911   2.869  1.00  0.00
ATOM    195 3HG1 VAL    13      -6.255  -0.585   1.951  1.00  0.00
ATOM    196  CG2 VAL    13      -4.269   0.420   0.344  1.00  1.13
ATOM    197 1HG2 VAL    13      -3.430   0.189   1.000  1.00  0.00
ATOM    198 2HG2 VAL    13      -4.686  -0.506  -0.050  1.00  0.00
ATOM    199 3HG2 VAL    13      -3.921   1.042  -0.482  1.00  0.00
ATOM    200  C   VAL    13      -6.022   2.500  -0.866  1.00 61.23
ATOM    201  O   VAL    13      -5.900   2.144  -2.036  1.00 43.41
ATOM    202  N   LYS    14      -5.745   3.721  -0.452  1.00 54.14
ATOM    203  HN  LYS    14      -5.945   3.983   0.502  1.00  0.00
ATOM    204  CA  LYS    14      -5.155   4.717  -1.328  1.00 51.51
ATOM    205  HA  LYS    14      -4.765   4.211  -2.211  1.00  0.00
ATOM    206  CB  LYS    14      -6.208   5.727  -1.778  1.00 14.21
ATOM    207 2HB  LYS    14      -6.942   5.841  -0.981  1.00  0.00
ATOM    208 3HB  LYS    14      -5.716   6.684  -1.959  1.00  0.00
ATOM    209  CG  LYS    14      -6.932   5.308  -3.046  1.00 34.22
ATOM    210 2HG  LYS    14      -6.291   5.518  -3.903  1.00  0.00
ATOM    211 3HG  LYS    14      -7.136   4.239  -2.998  1.00  0.00
ATOM    212  CD  LYS    14      -8.243   6.050  -3.222  1.00 32.42
ATOM    213 2HD  LYS    14      -8.659   5.803  -4.199  1.00  0.00
ATOM    214 3HD  LYS    14      -8.934   5.733  -2.442  1.00  0.00
ATOM    215  CE  LYS    14      -8.062   7.556  -3.134  1.00 65.41
ATOM    216 2HE  LYS    14      -7.710   7.813  -2.135  1.00  0.00
ATOM    217 3HE  LYS    14      -7.317   7.867  -3.867  1.00  0.00
ATOM    218  NZ  LYS    14      -9.330   8.278  -3.400  1.00 21.43
ATOM    219 1HZ  LYS    14      -9.175   9.274  -3.334  1.00  0.00
ATOM    220 2HZ  LYS    14      -9.657   8.051  -4.328  1.00  0.00
ATOM    221 3HZ  LYS    14     -10.023   8.001  -2.721  1.00  0.00
ATOM    222  C   LYS    14      -4.006   5.413  -0.624  1.00 53.31
ATOM    223  O   LYS    14      -4.100   5.736   0.560  1.00 40.05
ATOM    224  N   VAL    15      -2.921   5.620  -1.351  1.00 31.31
ATOM    225  HN  VAL    15      -2.912   5.364  -2.328  1.00  0.00
ATOM    226  CA  VAL    15      -1.723   6.214  -0.779  1.00 74.25
ATOM    227  HA  VAL    15      -1.564   5.774   0.205  1.00  0.00
ATOM    228  CB  VAL    15      -0.481   5.931  -1.651  1.00 55.30
ATOM    229  HB  VAL    15      -0.611   6.440  -2.606  1.00  0.00
ATOM    230  CG1 VAL    15       0.778   6.475  -0.991  1.00 60.13
ATOM    231 1HG1 VAL    15       1.641   6.287  -1.630  1.00  0.00
ATOM    232 2HG1 VAL    15       0.671   7.549  -0.836  1.00  0.00
ATOM    233 3HG1 VAL    15       0.926   5.982  -0.030  1.00  0.00
ATOM    234  CG2 VAL    15      -0.345   4.442  -1.921  1.00  4.15
ATOM    235 1HG2 VAL    15       0.522   4.260  -2.557  1.00  0.00
ATOM    236 2HG2 VAL    15      -0.218   3.913  -0.977  1.00  0.00
ATOM    237 3HG2 VAL    15      -1.243   4.082  -2.422  1.00  0.00
ATOM    238  C   VAL    15      -1.890   7.716  -0.621  1.00  1.34
ATOM    239  O   VAL    15      -2.316   8.401  -1.552  1.00 64.13
ATOM    240  N   VAL    16      -1.568   8.222   0.556  1.00 40.44
ATOM    241  HN  VAL    16      -1.280   7.613   1.309  1.00  0.00
ATOM    242  CA  VAL    16      -1.618   9.653   0.797  1.00 52.11
ATOM    243  HA  VAL    16      -1.981  10.122  -0.118  1.00  0.00
ATOM    244  CB  VAL    16      -2.600  10.025   1.935  1.00 74.41
ATOM    245  HB  VAL    16      -2.405  11.057   2.229  1.00  0.00
ATOM    246  CG1 VAL    16      -4.034   9.925   1.446  1.00 32.42
ATOM    247 1HG1 VAL    16      -4.717  10.214   2.244  1.00  0.00
ATOM    248 2HG1 VAL    16      -4.173  10.590   0.593  1.00  0.00
ATOM    249 3HG1 VAL    16      -4.243   8.899   1.144  1.00  0.00
ATOM    250  CG2 VAL    16      -2.406   9.136   3.156  1.00 60.05
ATOM    251 1HG2 VAL    16      -3.096   9.432   3.946  1.00  0.00
ATOM    252 2HG2 VAL    16      -2.595   8.099   2.881  1.00  0.00
ATOM    253 3HG2 VAL    16      -1.382   9.235   3.516  1.00  0.00
ATOM    254  C   VAL    16      -0.230  10.206   1.086  1.00  3.43
ATOM    255  O   VAL    16       0.258  11.073   0.364  1.00 72.51
ATOM    256  N   LYS    17       0.420   9.684   2.111  1.00 33.10
ATOM    257  HN  LYS    17      -0.011   8.959   2.665  1.00  0.00
ATOM    258  CA  LYS    17       1.756  10.131   2.468  1.00 73.35
ATOM    259  HA  LYS    17       2.045  10.925   1.779  1.00  0.00
ATOM    260  CB  LYS    17       1.793  10.682   3.894  1.00 53.01
ATOM    261 2HB  LYS    17       1.381   9.926   4.562  1.00  0.00
ATOM    262 3HB  LYS    17       2.833  10.873   4.159  1.00  0.00
ATOM    263  CG  LYS    17       1.009  11.969   4.091  1.00 34.34
ATOM    264 2HG  LYS    17       1.380  12.723   3.395  1.00  0.00
ATOM    265 3HG  LYS    17      -0.045  11.779   3.892  1.00  0.00
ATOM    266  CD  LYS    17       1.162  12.485   5.510  1.00 73.01
ATOM    267 2HD  LYS    17       0.785  11.732   6.202  1.00  0.00
ATOM    268 3HD  LYS    17       2.219  12.664   5.708  1.00  0.00
ATOM    269  CE  LYS    17       0.397  13.778   5.726  1.00 72.44
ATOM    270 2HE  LYS    17       0.783  14.537   5.044  1.00  0.00
ATOM    271 3HE  LYS    17      -0.657  13.606   5.511  1.00  0.00
ATOM    272  NZ  LYS    17       0.532  14.270   7.122  1.00 74.42
ATOM    273 1HZ  LYS    17       0.013  15.130   7.232  1.00  0.00
ATOM    274 2HZ  LYS    17       0.170  13.576   7.759  1.00  0.00
ATOM    275 3HZ  LYS    17       1.507  14.439   7.326  1.00  0.00
ATOM    276  C   LYS    17       2.750   8.992   2.350  1.00 74.25
ATOM    277  O   LYS    17       2.376   7.820   2.348  1.00 52.02
ATOM    278  N   LEU    18       4.017   9.343   2.254  1.00 42.21
ATOM    279  HN  LEU    18       4.264  10.322   2.204  1.00  0.00
ATOM    280  CA  LEU    18       5.081   8.363   2.217  1.00 13.22
ATOM    281  HA  LEU    18       4.671   7.391   2.491  1.00  0.00
ATOM    282  CB  LEU    18       5.677   8.265   0.810  1.00 61.32
ATOM    283 2HB  LEU    18       5.975   9.267   0.499  1.00  0.00
ATOM    284 3HB  LEU    18       6.557   7.624   0.860  1.00  0.00
ATOM    285  CG  LEU    18       4.738   7.698  -0.258  1.00 65.15
ATOM    286  HG  LEU    18       3.824   8.292  -0.268  1.00  0.00
ATOM    287  CD1 LEU    18       5.386   7.783  -1.627  1.00 22.25
ATOM    288 1HD1 LEU    18       4.704   7.393  -2.382  1.00  0.00
ATOM    289 2HD1 LEU    18       5.619   8.824  -1.854  1.00  0.00
ATOM    290 3HD1 LEU    18       6.305   7.197  -1.631  1.00  0.00
ATOM    291  CD2 LEU    18       4.378   6.256   0.065  1.00 71.20
ATOM    292 1HD2 LEU    18       3.697   5.869  -0.693  1.00  0.00
ATOM    293 2HD2 LEU    18       5.285   5.651   0.080  1.00  0.00
ATOM    294 3HD2 LEU    18       3.896   6.213   1.041  1.00  0.00
ATOM    295  C   LEU    18       6.152   8.749   3.221  1.00 42.33
ATOM    296  O   LEU    18       6.836   9.754   3.048  1.00 73.24
ATOM    297  N   HIS    19       6.265   7.978   4.287  1.00 41.13
ATOM    298  HN  HIS    19       5.664   7.175   4.397  1.00  0.00
ATOM    299  CA  HIS    19       7.248   8.262   5.321  1.00 64.44
ATOM    300  HA  HIS    19       7.383   9.343   5.380  1.00  0.00
ATOM    301  CB  HIS    19       6.772   7.752   6.689  1.00 21.33
ATOM    302 2HB  HIS    19       6.602   6.678   6.615  1.00  0.00
ATOM    303 3HB  HIS    19       7.562   7.936   7.418  1.00  0.00
ATOM    304  CG  HIS    19       5.512   8.397   7.186  1.00 62.22
ATOM    305  ND1 HIS    19       5.494   9.362   8.169  1.00 53.41
ATOM    306  CD2 HIS    19       4.217   8.192   6.844  1.00 31.35
ATOM    307 1HD  HIS    19       6.309   9.737   8.634  1.00  0.00
ATOM    308  CE1 HIS    19       4.247   9.721   8.409  1.00 52.24
ATOM    309  NE2 HIS    19       3.450   9.027   7.619  1.00 64.53
ATOM    310 2HD  HIS    19       3.855   7.500   6.099  1.00  0.00
ATOM    311 1HE  HIS    19       3.932  10.460   9.131  1.00  0.00
ATOM    312 2HE  HIS    19       2.443   9.098   7.589  1.00  0.00
ATOM    313  C   HIS    19       8.580   7.618   4.964  1.00 43.41
ATOM    314  O   HIS    19       8.642   6.745   4.098  1.00 51.35
ATOM    315  N   GLY    20       9.643   8.056   5.620  1.00  2.20
ATOM    316  HN  GLY    20       9.559   8.812   6.285  1.00  0.00
ATOM    317  CA  GLY    20      10.943   7.462   5.397  1.00 72.45
ATOM    318 1HA  GLY    20      11.172   6.798   6.231  1.00  0.00
ATOM    319 2HA  GLY    20      10.909   6.884   4.474  1.00  0.00
ATOM    320  C   GLY    20      12.042   8.495   5.283  1.00 54.34
ATOM    321  O   GLY    20      11.782   9.697   5.320  1.00 10.33
ATOM    322  N   THR    21      13.267   8.020   5.119  1.00 54.33
ATOM    323  HN  THR    21      13.405   7.022   5.054  1.00  0.00
ATOM    324  CA  THR    21      14.442   8.881   5.026  1.00  4.12
ATOM    325  HA  THR    21      14.319   9.703   5.731  1.00  0.00
ATOM    326  CB  THR    21      15.700   8.083   5.402  1.00 61.42
ATOM    327  HB  THR    21      16.579   8.634   5.067  1.00  0.00
ATOM    328  OG1 THR    21      15.667   6.809   4.743  1.00 21.03
ATOM    329 1HG  THR    21      16.465   6.326   4.972  1.00  0.00
ATOM    330  CG2 THR    21      15.792   7.884   6.909  1.00 20.30
ATOM    331 1HG2 THR    21      16.693   7.322   7.154  1.00  0.00
ATOM    332 2HG2 THR    21      15.829   8.856   7.401  1.00  0.00
ATOM    333 3HG2 THR    21      14.918   7.334   7.255  1.00  0.00
ATOM    334  C   THR    21      14.623   9.464   3.621  1.00 30.23
ATOM    335  O   THR    21      15.746   9.711   3.182  1.00 75.23
ATOM    336  N   GLY    22      13.518   9.692   2.923  1.00 32.25
ATOM    337  HN  GLY    22      12.614   9.471   3.314  1.00  0.00
ATOM    338  CA  GLY    22      13.583  10.262   1.589  1.00 22.11
ATOM    339 1HA  GLY    22      12.614  10.698   1.348  1.00  0.00
ATOM    340 2HA  GLY    22      14.343  11.044   1.580  1.00  0.00
ATOM    341  C   GLY    22      13.931   9.233   0.531  1.00 74.52
ATOM    342  O   GLY    22      13.140   8.977  -0.377  1.00 73.21
ATOM    343  N   ALA    23      15.110   8.634   0.661  1.00 20.51
ATOM    344  HN  ALA    23      15.708   8.875   1.439  1.00  0.00
ATOM    345  CA  ALA    23      15.584   7.630  -0.287  1.00 74.44
ATOM    346  HA  ALA    23      15.664   8.101  -1.267  1.00  0.00
ATOM    347  CB  ALA    23      16.961   7.132   0.122  1.00 64.42
ATOM    348 1HB  ALA    23      17.322   6.407  -0.607  1.00  0.00
ATOM    349 2HB  ALA    23      17.653   7.974   0.167  1.00  0.00
ATOM    350 3HB  ALA    23      16.900   6.660   1.102  1.00  0.00
ATOM    351  C   ALA    23      14.605   6.465  -0.391  1.00 45.31
ATOM    352  O   ALA    23      14.386   5.915  -1.473  1.00 25.24
ATOM    353  N   LEU    24      14.015   6.101   0.741  1.00 14.13
ATOM    354  HN  LEU    24      14.259   6.564   1.605  1.00  0.00
ATOM    355  CA  LEU    24      13.015   5.043   0.780  1.00 61.23
ATOM    356  HA  LEU    24      13.452   4.138   0.358  1.00  0.00
ATOM    357  CB  LEU    24      12.599   4.760   2.230  1.00 63.32
ATOM    358 2HB  LEU    24      13.497   4.510   2.794  1.00  0.00
ATOM    359 3HB  LEU    24      12.156   5.670   2.636  1.00  0.00
ATOM    360  CG  LEU    24      11.592   3.621   2.414  1.00 32.01
ATOM    361  HG  LEU    24      10.713   3.839   1.807  1.00  0.00
ATOM    362  CD1 LEU    24      12.184   2.300   1.942  1.00 12.44
ATOM    363 1HD1 LEU    24      11.450   1.503   2.059  1.00  0.00
ATOM    364 2HD1 LEU    24      12.462   2.383   0.891  1.00  0.00
ATOM    365 3HD1 LEU    24      13.069   2.067   2.534  1.00  0.00
ATOM    366  CD2 LEU    24      11.159   3.523   3.866  1.00 51.42
ATOM    367 1HD2 LEU    24      10.427   2.724   3.980  1.00  0.00
ATOM    368 2HD2 LEU    24      12.027   3.309   4.489  1.00  0.00
ATOM    369 3HD2 LEU    24      10.714   4.469   4.176  1.00  0.00
ATOM    370  C   LEU    24      11.799   5.439  -0.057  1.00  1.54
ATOM    371  O   LEU    24      11.283   4.637  -0.835  1.00  3.43
ATOM    372  N   LYS    25      11.374   6.692   0.088  1.00 73.40
ATOM    373  HN  LYS    25      11.853   7.311   0.726  1.00  0.00
ATOM    374  CA  LYS    25      10.227   7.213  -0.650  1.00 74.22
ATOM    375  HA  LYS    25       9.353   6.610  -0.405  1.00  0.00
ATOM    376  CB  LYS    25       9.951   8.670  -0.266  1.00 62.33
ATOM    377 2HB  LYS    25      10.752   9.288  -0.673  1.00  0.00
ATOM    378 3HB  LYS    25       9.002   8.967  -0.711  1.00  0.00
ATOM    379  CG  LYS    25       9.873   8.915   1.232  1.00 12.02
ATOM    380 2HG  LYS    25       9.042   8.343   1.643  1.00  0.00
ATOM    381 3HG  LYS    25      10.804   8.589   1.695  1.00  0.00
ATOM    382  CD  LYS    25       9.658  10.389   1.535  1.00 54.14
ATOM    383 2HD  LYS    25      10.428  10.971   1.028  1.00  0.00
ATOM    384 3HD  LYS    25       8.677  10.687   1.166  1.00  0.00
ATOM    385  CE  LYS    25       9.730  10.668   3.025  1.00 61.02
ATOM    386 2HE  LYS    25       8.994  10.049   3.536  1.00  0.00
ATOM    387 3HE  LYS    25      10.727  10.411   3.385  1.00  0.00
ATOM    388  NZ  LYS    25       9.459  12.095   3.337  1.00 24.04
ATOM    389 1HZ  LYS    25       9.515  12.244   4.334  1.00  0.00
ATOM    390 2HZ  LYS    25      10.143  12.676   2.873  1.00  0.00
ATOM    391 3HZ  LYS    25       8.534  12.340   3.013  1.00  0.00
ATOM    392  C   LYS    25      10.485   7.132  -2.149  1.00 70.34
ATOM    393  O   LYS    25       9.607   6.757  -2.924  1.00 31.33
ATOM    394  N   ARG    26      11.706   7.480  -2.540  1.00 33.41
ATOM    395  HN  ARG    26      12.385   7.772  -1.852  1.00  0.00
ATOM    396  CA  ARG    26      12.112   7.459  -3.940  1.00 75.34
ATOM    397  HA  ARG    26      11.446   8.111  -4.505  1.00  0.00
ATOM    398  CB  ARG    26      13.544   7.987  -4.064  1.00 32.11
ATOM    399 2HB  ARG    26      13.577   8.987  -3.630  1.00  0.00
ATOM    400 3HB  ARG    26      14.201   7.324  -3.501  1.00  0.00
ATOM    401  CG  ARG    26      14.066   8.072  -5.490  1.00 13.24
ATOM    402 2HG  ARG    26      15.118   8.359  -5.464  1.00  0.00
ATOM    403 3HG  ARG    26      13.968   7.094  -5.961  1.00  0.00
ATOM    404  CD  ARG    26      13.299   9.092  -6.313  1.00 22.45
ATOM    405 2HD  ARG    26      12.303   8.702  -6.523  1.00  0.00
ATOM    406 3HD  ARG    26      13.209  10.015  -5.740  1.00  0.00
ATOM    407  NE  ARG    26      13.972   9.382  -7.579  1.00 22.31
ATOM    408  HE  ARG    26      14.692   8.740  -7.879  1.00  0.00
ATOM    409  CZ  ARG    26      13.691  10.432  -8.347  1.00 31.33
ATOM    410  NH1 ARG    26      12.691  11.244  -8.027  1.00 22.21
ATOM    411 1HH1 ARG    26      12.477  12.037  -8.615  1.00  0.00
ATOM    412 2HH1 ARG    26      12.145  11.069  -7.196  1.00  0.00
ATOM    413  NH2 ARG    26      14.399  10.655  -9.444  1.00 51.44
ATOM    414 1HH2 ARG    26      14.184  11.449 -10.031  1.00  0.00
ATOM    415 2HH2 ARG    26      15.154  10.032  -9.694  1.00  0.00
ATOM    416  C   ARG    26      12.016   6.050  -4.512  1.00 35.02
ATOM    417  O   ARG    26      11.545   5.859  -5.629  1.00 22.34
ATOM    418  N   ARG    27      12.457   5.069  -3.735  1.00 44.44
ATOM    419  HN  ARG    27      12.856   5.284  -2.832  1.00  0.00
ATOM    420  CA  ARG    27      12.385   3.673  -4.149  1.00 12.51
ATOM    421  HA  ARG    27      12.882   3.573  -5.114  1.00  0.00
ATOM    422  CB  ARG    27      13.107   2.783  -3.131  1.00 31.11
ATOM    423 2HB  ARG    27      14.164   3.050  -3.131  1.00  0.00
ATOM    424 3HB  ARG    27      12.683   2.976  -2.146  1.00  0.00
ATOM    425  CG  ARG    27      12.989   1.294  -3.420  1.00 32.35
ATOM    426 2HG  ARG    27      11.940   1.005  -3.366  1.00  0.00
ATOM    427 3HG  ARG    27      13.369   1.097  -4.423  1.00  0.00
ATOM    428  CD  ARG    27      13.781   0.468  -2.420  1.00 60.11
ATOM    429 2HD  ARG    27      14.843   0.677  -2.551  1.00  0.00
ATOM    430 3HD  ARG    27      13.482   0.753  -1.411  1.00  0.00
ATOM    431  NE  ARG    27      13.556  -0.964  -2.594  1.00  3.31
ATOM    432  HE  ARG    27      12.608  -1.263  -2.773  1.00  0.00
ATOM    433  CZ  ARG    27      14.515  -1.886  -2.532  1.00 50.51
ATOM    434  NH1 ARG    27      15.778  -1.533  -2.323  1.00 44.43
ATOM    435 1HH1 ARG    27      16.501  -2.237  -2.277  1.00  0.00
ATOM    436 2HH1 ARG    27      16.017  -0.558  -2.210  1.00  0.00
ATOM    437  NH2 ARG    27      14.207  -3.166  -2.680  1.00 61.44
ATOM    438 1HH2 ARG    27      14.932  -3.868  -2.634  1.00  0.00
ATOM    439 2HH2 ARG    27      13.248  -3.439  -2.840  1.00  0.00
ATOM    440  C   ARG    27      10.929   3.241  -4.302  1.00 45.42
ATOM    441  O   ARG    27      10.558   2.608  -5.291  1.00  0.02
ATOM    442  N   ILE    28      10.112   3.600  -3.319  1.00 44.23
ATOM    443  HN  ILE    28      10.482   4.097  -2.521  1.00  0.00
ATOM    444  CA  ILE    28       8.687   3.305  -3.346  1.00  2.21
ATOM    445  HA  ILE    28       8.567   2.223  -3.392  1.00  0.00
ATOM    446  CB  ILE    28       8.003   3.822  -2.059  1.00  5.03
ATOM    447  HB  ILE    28       8.209   4.889  -1.966  1.00  0.00
ATOM    448  CG2 ILE    28       6.496   3.631  -2.123  1.00 64.14
ATOM    449 1HG2 ILE    28       6.035   4.020  -1.215  1.00  0.00
ATOM    450 2HG2 ILE    28       6.100   4.166  -2.986  1.00  0.00
ATOM    451 3HG2 ILE    28       6.269   2.570  -2.218  1.00  0.00
ATOM    452  CG1 ILE    28       8.581   3.106  -0.835  1.00 34.04
ATOM    453 2HG1 ILE    28       8.331   2.048  -0.907  1.00  0.00
ATOM    454 3HG1 ILE    28       9.665   3.226  -0.848  1.00  0.00
ATOM    455  CD1 ILE    28       8.059   3.631   0.487  1.00 51.31
ATOM    456 1HD1 ILE    28       8.504   3.085   1.318  1.00  0.00
ATOM    457 2HD1 ILE    28       8.311   4.688   0.579  1.00  0.00
ATOM    458 3HD1 ILE    28       6.976   3.512   0.519  1.00  0.00
ATOM    459  C   ILE    28       8.017   3.920  -4.578  1.00 52.21
ATOM    460  O   ILE    28       7.316   3.230  -5.323  1.00 25.22
ATOM    461  N   MET    29       8.265   5.207  -4.799  1.00 11.03
ATOM    462  HN  MET    29       8.898   5.706  -4.190  1.00  0.00
ATOM    463  CA  MET    29       7.646   5.938  -5.905  1.00 64.11
ATOM    464  HA  MET    29       6.571   5.767  -5.858  1.00  0.00
ATOM    465  CB  MET    29       7.902   7.441  -5.774  1.00 73.02
ATOM    466 2HB  MET    29       8.976   7.600  -5.671  1.00  0.00
ATOM    467 3HB  MET    29       7.549   7.931  -6.682  1.00  0.00
ATOM    468  CG  MET    29       7.205   8.079  -4.583  1.00 55.12
ATOM    469 2HG  MET    29       6.136   7.880  -4.654  1.00  0.00
ATOM    470 3HG  MET    29       7.585   7.625  -3.668  1.00  0.00
ATOM    471  SD  MET    29       7.457   9.864  -4.491  1.00 72.11
ATOM    472  CE  MET    29       9.242   9.944  -4.348  1.00 32.31
ATOM    473 1HE  MET    29       9.563  10.984  -4.281  1.00  0.00
ATOM    474 2HE  MET    29       9.558   9.411  -3.452  1.00  0.00
ATOM    475 3HE  MET    29       9.697   9.483  -5.225  1.00  0.00
ATOM    476  C   MET    29       8.151   5.448  -7.255  1.00 70.22
ATOM    477  O   MET    29       7.423   5.487  -8.248  1.00 54.45
ATOM    478  N   ASP    30       9.393   4.986  -7.286  1.00 72.31
ATOM    479  HN  ASP    30       9.934   4.946  -6.434  1.00  0.00
ATOM    480  CA  ASP    30      10.016   4.528  -8.525  1.00 42.24
ATOM    481  HA  ASP    30       9.899   5.308  -9.278  1.00  0.00
ATOM    482  CB  ASP    30      11.510   4.276  -8.303  1.00 64.10
ATOM    483 2HB  ASP    30      11.918   5.094  -7.709  1.00  0.00
ATOM    484 3HB  ASP    30      11.630   3.341  -7.757  1.00  0.00
ATOM    485  CG  ASP    30      12.288   4.183  -9.599  1.00  0.52
ATOM    486  OD1 ASP    30      12.325   3.097 -10.207  1.00 34.42
ATOM    487  OD2 ASP    30      12.880   5.204 -10.012  1.00 31.43
ATOM    488 2HD  ASP    30      13.356   5.076 -10.836  1.00  0.00
ATOM    489  C   ASP    30       9.346   3.253  -9.030  1.00  2.22
ATOM    490  O   ASP    30       9.196   3.049 -10.237  1.00 50.42
ATOM    491  N   MET    31       8.927   2.407  -8.095  1.00 23.14
ATOM    492  HN  MET    31       9.043   2.641  -7.120  1.00  0.00
ATOM    493  CA  MET    31       8.298   1.134  -8.434  1.00 53.13
ATOM    494  HA  MET    31       8.886   0.665  -9.224  1.00  0.00
ATOM    495  CB  MET    31       8.279   0.205  -7.219  1.00 21.22
ATOM    496 2HB  MET    31       7.761   0.714  -6.406  1.00  0.00
ATOM    497 3HB  MET    31       7.734  -0.699  -7.488  1.00  0.00
ATOM    498  CG  MET    31       9.658  -0.197  -6.730  1.00 14.11
ATOM    499 2HG  MET    31      10.172  -0.737  -7.525  1.00  0.00
ATOM    500 3HG  MET    31      10.227   0.703  -6.495  1.00  0.00
ATOM    501  SD  MET    31       9.589  -1.245  -5.261  1.00 33.41
ATOM    502  CE  MET    31       8.790  -0.144  -4.094  1.00 40.45
ATOM    503 1HE  MET    31       8.673  -0.642  -3.132  1.00  0.00
ATOM    504 2HE  MET    31       9.400   0.751  -3.964  1.00  0.00
ATOM    505 3HE  MET    31       7.809   0.138  -4.476  1.00  0.00
ATOM    506  C   MET    31       6.874   1.336  -8.942  1.00 30.23
ATOM    507  O   MET    31       6.298   0.443  -9.563  1.00  3.40
ATOM    508  N   GLY    32       6.306   2.503  -8.668  1.00 21.22
ATOM    509  HN  GLY    32       6.813   3.211  -8.155  1.00  0.00
ATOM    510  CA  GLY    32       4.950   2.785  -9.099  1.00  3.34
ATOM    511 1HA  GLY    32       4.975   3.601  -9.822  1.00  0.00
ATOM    512 2HA  GLY    32       4.541   1.894  -9.575  1.00  0.00
ATOM    513  C   GLY    32       4.051   3.180  -7.947  1.00 64.11
ATOM    514  O   GLY    32       3.007   3.807  -8.151  1.00 43.22
ATOM    515  N   ILE    33       4.459   2.820  -6.733  1.00 63.23
ATOM    516  HN  ILE    33       5.320   2.304  -6.623  1.00  0.00
ATOM    517  CA  ILE    33       3.691   3.155  -5.540  1.00 55.11
ATOM    518  HA  ILE    33       2.652   2.875  -5.711  1.00  0.00
ATOM    519  CB  ILE    33       4.204   2.405  -4.292  1.00  3.13
ATOM    520  HB  ILE    33       5.160   2.840  -3.998  1.00  0.00
ATOM    521  CG2 ILE    33       3.223   2.571  -3.138  1.00 72.10
ATOM    522 1HG2 ILE    33       3.605   2.060  -2.255  1.00  0.00
ATOM    523 2HG2 ILE    33       3.100   3.632  -2.917  1.00  0.00
ATOM    524 3HG2 ILE    33       2.260   2.144  -3.417  1.00  0.00
ATOM    525  CG1 ILE    33       4.425   0.918  -4.599  1.00 61.44
ATOM    526 2HG1 ILE    33       5.148   0.840  -5.411  1.00  0.00
ATOM    527 3HG1 ILE    33       4.829   0.441  -3.706  1.00  0.00
ATOM    528  CD1 ILE    33       3.170   0.175  -5.008  1.00 31.52
ATOM    529 1HD1 ILE    33       3.393  -0.872  -5.213  1.00  0.00
ATOM    530 2HD1 ILE    33       2.439   0.233  -4.202  1.00  0.00
ATOM    531 3HD1 ILE    33       2.757   0.634  -5.907  1.00  0.00
ATOM    532  C   ILE    33       3.770   4.657  -5.294  1.00 33.21
ATOM    533  O   ILE    33       4.781   5.170  -4.817  1.00 62.34
ATOM    534  N   THR    34       2.709   5.360  -5.635  1.00 25.14
ATOM    535  HN  THR    34       1.854   4.892  -5.898  1.00  0.00
ATOM    536  CA  THR    34       2.738   6.808  -5.642  1.00 12.13
ATOM    537  HA  THR    34       3.684   7.128  -5.204  1.00  0.00
ATOM    538  CB  THR    34       2.672   7.320  -7.091  1.00  4.45
ATOM    539  HB  THR    34       2.235   8.319  -7.092  1.00  0.00
ATOM    540  OG1 THR    34       1.844   6.445  -7.875  1.00  0.23
ATOM    541 1HG  THR    34       1.801   6.785  -8.772  1.00  0.00
ATOM    542  CG2 THR    34       4.063   7.392  -7.704  1.00 51.22
ATOM    543 1HG2 THR    34       3.999   7.763  -8.727  1.00  0.00
ATOM    544 2HG2 THR    34       4.684   8.067  -7.114  1.00  0.00
ATOM    545 3HG2 THR    34       4.509   6.398  -7.708  1.00  0.00
ATOM    546  C   THR    34       1.605   7.409  -4.819  1.00 63.04
ATOM    547  O   THR    34       0.579   6.769  -4.591  1.00 72.21
ATOM    548  N   ARG    35       1.806   8.637  -4.362  1.00 70.22
ATOM    549  HN  ARG    35       2.674   9.112  -4.564  1.00  0.00
ATOM    550  CA  ARG    35       0.805   9.333  -3.567  1.00 21.30
ATOM    551  HA  ARG    35       0.503   8.682  -2.747  1.00  0.00
ATOM    552  CB  ARG    35       1.396  10.617  -2.978  1.00 35.44
ATOM    553 2HB  ARG    35       1.725  11.254  -3.800  1.00  0.00
ATOM    554 3HB  ARG    35       0.617  11.128  -2.412  1.00  0.00
ATOM    555  CG  ARG    35       2.581  10.373  -2.053  1.00 21.51
ATOM    556 2HG  ARG    35       2.245   9.789  -1.197  1.00  0.00
ATOM    557 3HG  ARG    35       3.344   9.816  -2.597  1.00  0.00
ATOM    558  CD  ARG    35       3.185  11.676  -1.553  1.00 62.41
ATOM    559 2HD  ARG    35       4.070  11.449  -0.958  1.00  0.00
ATOM    560 3HD  ARG    35       3.477  12.282  -2.411  1.00  0.00
ATOM    561  NE  ARG    35       2.248  12.441  -0.732  1.00 44.11
ATOM    562  HE  ARG    35       1.453  11.945  -0.356  1.00  0.00
ATOM    563  CZ  ARG    35       2.381  13.737  -0.455  1.00 13.24
ATOM    564  NH1 ARG    35       3.423  14.417  -0.922  1.00 23.11
ATOM    565 1HH1 ARG    35       3.524  15.399  -0.708  1.00  0.00
ATOM    566 2HH1 ARG    35       4.115  13.952  -1.492  1.00  0.00
ATOM    567  NH2 ARG    35       1.479  14.352   0.301  1.00 72.23
ATOM    568 1HH2 ARG    35       1.583  15.334   0.514  1.00  0.00
ATOM    569 2HH2 ARG    35       0.690  13.838   0.664  1.00  0.00
ATOM    570  C   ARG    35      -0.422   9.648  -4.415  1.00 73.33
ATOM    571  O   ARG    35      -0.386  10.523  -5.282  1.00 41.54
ATOM    572  N   GLY    36      -1.497   8.912  -4.177  1.00 30.55
ATOM    573  HN  GLY    36      -1.479   8.204  -3.457  1.00  0.00
ATOM    574  CA  GLY    36      -2.714   9.102  -4.936  1.00 74.03
ATOM    575 1HA  GLY    36      -3.494   9.458  -4.263  1.00  0.00
ATOM    576 2HA  GLY    36      -2.532   9.853  -5.706  1.00  0.00
ATOM    577  C   GLY    36      -3.188   7.826  -5.601  1.00 15.42
ATOM    578  O   GLY    36      -4.382   7.663  -5.855  1.00 54.02
ATOM    579  N   CYS    37      -2.265   6.913  -5.880  1.00  1.00
ATOM    580  HN  CYS    37      -1.298   7.074  -5.638  1.00  0.00
ATOM    581  CA  CYS    37      -2.627   5.665  -6.538  1.00  3.31
ATOM    582  HA  CYS    37      -3.274   5.903  -7.383  1.00  0.00
ATOM    583  CB  CYS    37      -1.384   4.936  -7.069  1.00 30.24
ATOM    584 2HB  CYS    37      -1.722   4.109  -7.693  1.00  0.00
ATOM    585 3HB  CYS    37      -0.815   5.642  -7.675  1.00  0.00
ATOM    586  SG  CYS    37      -0.291   4.275  -5.788  1.00  4.05
ATOM    587  HG  CYS    37       0.626   3.744  -6.603  1.00  0.00
ATOM    588  C   CYS    37      -3.393   4.765  -5.578  1.00 25.11
ATOM    589  O   CYS    37      -3.124   4.750  -4.371  1.00 71.03
ATOM    590  N   GLU    38      -4.357   4.035  -6.116  1.00 43.32
ATOM    591  HN  GLU    38      -4.556   4.116  -7.103  1.00  0.00
ATOM    592  CA  GLU    38      -5.146   3.110  -5.325  1.00  1.43
ATOM    593  HA  GLU    38      -5.216   3.496  -4.308  1.00  0.00
ATOM    594  CB  GLU    38      -6.561   2.992  -5.899  1.00 52.23
ATOM    595 2HB  GLU    38      -7.131   2.308  -5.271  1.00  0.00
ATOM    596 3HB  GLU    38      -7.025   3.978  -5.877  1.00  0.00
ATOM    597  CG  GLU    38      -6.598   2.477  -7.326  1.00 14.30
ATOM    598 2HG  GLU    38      -5.896   3.056  -7.927  1.00  0.00
ATOM    599 3HG  GLU    38      -6.294   1.431  -7.330  1.00  0.00
ATOM    600  CD  GLU    38      -7.974   2.587  -7.944  1.00 25.15
ATOM    601  OE1 GLU    38      -8.745   1.608  -7.881  1.00 65.40
ATOM    602  OE2 GLU    38      -8.290   3.663  -8.502  1.00 43.44
ATOM    603 2HE  GLU    38      -9.175   3.666  -8.874  1.00  0.00
ATOM    604  C   GLU    38      -4.465   1.751  -5.285  1.00  3.11
ATOM    605  O   GLU    38      -3.884   1.305  -6.279  1.00 71.51
ATOM    606  N   ILE    39      -4.520   1.108  -4.134  1.00 33.21
ATOM    607  HN  ILE    39      -5.015   1.516  -3.354  1.00  0.00
ATOM    608  CA  ILE    39      -3.887  -0.179  -3.950  1.00  2.24
ATOM    609  HA  ILE    39      -3.491  -0.503  -4.913  1.00  0.00
ATOM    610  CB  ILE    39      -2.723  -0.103  -2.938  1.00 41.43
ATOM    611  HB  ILE    39      -3.119   0.242  -1.983  1.00  0.00
ATOM    612  CG2 ILE    39      -2.109  -1.481  -2.735  1.00 50.33
ATOM    613 1HG2 ILE    39      -1.304  -1.420  -2.003  1.00  0.00
ATOM    614 2HG2 ILE    39      -2.874  -2.169  -2.376  1.00  0.00
ATOM    615 3HG2 ILE    39      -1.710  -1.843  -3.682  1.00  0.00
ATOM    616  CG1 ILE    39      -1.661   0.896  -3.409  1.00 52.30
ATOM    617 2HG1 ILE    39      -1.313   0.590  -4.396  1.00  0.00
ATOM    618 3HG1 ILE    39      -2.121   1.882  -3.476  1.00  0.00
ATOM    619  CD1 ILE    39      -0.463   0.989  -2.487  1.00 54.01
ATOM    620 1HD1 ILE    39       0.259   1.711  -2.870  1.00  0.00
ATOM    621 2HD1 ILE    39      -0.793   1.306  -1.498  1.00  0.00
ATOM    622 3HD1 ILE    39       0.014   0.012  -2.416  1.00  0.00
ATOM    623  C   ILE    39      -4.903  -1.201  -3.465  1.00 44.01
ATOM    624  O   ILE    39      -5.476  -1.061  -2.381  1.00  1.54
ATOM    625  N   TYR    40      -5.141  -2.214  -4.279  1.00  3.30
ATOM    626  HN  TYR    40      -4.721  -2.235  -5.197  1.00  0.00
ATOM    627  CA  TYR    40      -6.003  -3.309  -3.883  1.00 63.32
ATOM    628  HA  TYR    40      -6.730  -2.941  -3.159  1.00  0.00
ATOM    629  CB  TYR    40      -6.755  -3.872  -5.092  1.00 45.44
ATOM    630 2HB  TYR    40      -7.108  -3.039  -5.700  1.00  0.00
ATOM    631 3HB  TYR    40      -6.062  -4.469  -5.685  1.00  0.00
ATOM    632  CG  TYR    40      -7.942  -4.736  -4.723  1.00 73.12
ATOM    633  CD1 TYR    40      -9.180  -4.163  -4.471  1.00 62.21
ATOM    634 1HD  TYR    40      -9.292  -3.091  -4.539  1.00  0.00
ATOM    635  CE1 TYR    40     -10.271  -4.938  -4.135  1.00  3.24
ATOM    636 1HE  TYR    40     -11.227  -4.474  -3.944  1.00  0.00
ATOM    637  CZ  TYR    40     -10.135  -6.306  -4.044  1.00 43.21
ATOM    638  CE2 TYR    40      -8.916  -6.902  -4.291  1.00 70.42
ATOM    639 2HE  TYR    40      -8.812  -7.974  -4.223  1.00  0.00
ATOM    640  CD2 TYR    40      -7.827  -6.119  -4.627  1.00 10.11
ATOM    641 2HD  TYR    40      -6.873  -6.588  -4.818  1.00  0.00
ATOM    642  OH  TYR    40     -11.226  -7.077  -3.711  1.00 44.11
ATOM    643  HH  TYR    40     -11.024  -8.015  -3.677  1.00  0.00
ATOM    644  C   TYR    40      -5.154  -4.390  -3.234  1.00 13.02
ATOM    645  O   TYR    40      -4.362  -5.053  -3.909  1.00 51.30
ATOM    646  N   ILE    41      -5.290  -4.538  -1.924  1.00 21.31
ATOM    647  HN  ILE    41      -5.957  -3.972  -1.419  1.00  0.00
ATOM    648  CA  ILE    41      -4.495  -5.508  -1.181  1.00 62.32
ATOM    649  HA  ILE    41      -3.448  -5.366  -1.450  1.00  0.00
ATOM    650  CB  ILE    41      -4.637  -5.328   0.349  1.00 20.44
ATOM    651  HB  ILE    41      -5.601  -5.731   0.657  1.00  0.00
ATOM    652  CG2 ILE    41      -3.533  -6.093   1.074  1.00  2.14
ATOM    653 1HG2 ILE    41      -3.652  -5.978   2.151  1.00  0.00
ATOM    654 2HG2 ILE    41      -3.593  -7.149   0.814  1.00  0.00
ATOM    655 3HG2 ILE    41      -2.562  -5.699   0.773  1.00  0.00
ATOM    656  CG1 ILE    41      -4.584  -3.843   0.731  1.00 64.40
ATOM    657 2HG1 ILE    41      -5.380  -3.323   0.198  1.00  0.00
ATOM    658 3HG1 ILE    41      -4.750  -3.759   1.805  1.00  0.00
ATOM    659  CD1 ILE    41      -3.270  -3.168   0.399  1.00 63.01
ATOM    660 1HD1 ILE    41      -3.293  -2.118   0.691  1.00  0.00
ATOM    661 2HD1 ILE    41      -2.463  -3.669   0.933  1.00  0.00
ATOM    662 3HD1 ILE    41      -3.092  -3.235  -0.674  1.00  0.00
ATOM    663  C   ILE    41      -4.919  -6.920  -1.568  1.00 13.20
ATOM    664  O   ILE    41      -6.043  -7.337  -1.286  1.00 12.23
ATOM    665  N   ARG    42      -4.018  -7.644  -2.216  1.00 23.12
ATOM    666  HN  ARG    42      -3.074  -7.298  -2.317  1.00  0.00
ATOM    667  CA  ARG    42      -4.347  -8.938  -2.797  1.00 33.32
ATOM    668  HA  ARG    42      -5.398  -8.926  -3.084  1.00  0.00
ATOM    669  CB  ARG    42      -3.499  -9.179  -4.053  1.00 51.44
ATOM    670 2HB  ARG    42      -2.452  -9.240  -3.756  1.00  0.00
ATOM    671 3HB  ARG    42      -3.806 -10.124  -4.501  1.00  0.00
ATOM    672  CG  ARG    42      -3.640  -8.082  -5.100  1.00 53.22
ATOM    673 2HG  ARG    42      -3.470  -7.116  -4.624  1.00  0.00
ATOM    674 3HG  ARG    42      -2.893  -8.239  -5.879  1.00  0.00
ATOM    675  CD  ARG    42      -5.020  -8.080  -5.736  1.00  0.31
ATOM    676 2HD  ARG    42      -5.770  -8.205  -4.955  1.00  0.00
ATOM    677 3HD  ARG    42      -5.178  -7.123  -6.235  1.00  0.00
ATOM    678  NE  ARG    42      -5.171  -9.154  -6.713  1.00 34.30
ATOM    679  HE  ARG    42      -4.334  -9.472  -7.180  1.00  0.00
ATOM    680  CZ  ARG    42      -6.331  -9.732  -7.021  1.00 35.42
ATOM    681  NH1 ARG    42      -7.449  -9.360  -6.411  1.00 62.03
ATOM    682 1HH1 ARG    42      -8.326  -9.801  -6.647  1.00  0.00
ATOM    683 2HH1 ARG    42      -7.423  -8.633  -5.710  1.00  0.00
ATOM    684  NH2 ARG    42      -6.371 -10.690  -7.939  1.00 63.43
ATOM    685 1HH2 ARG    42      -7.249 -11.130  -8.173  1.00  0.00
ATOM    686 2HH2 ARG    42      -5.522 -10.979  -8.404  1.00  0.00
ATOM    687  C   ARG    42      -4.132 -10.064  -1.789  1.00 23.04
ATOM    688  O   ARG    42      -5.055 -10.819  -1.484  1.00 30.54
ATOM    689  N   LYS    43      -2.924 -10.163  -1.259  1.00 21.21
ATOM    690  HN  LYS    43      -2.216  -9.477  -1.480  1.00  0.00
ATOM    691  CA  LYS    43      -2.583 -11.250  -0.353  1.00 23.34
ATOM    692  HA  LYS    43      -3.489 -11.562   0.166  1.00  0.00
ATOM    693  CB  LYS    43      -2.038 -12.441  -1.153  1.00 24.53
ATOM    694 2HB  LYS    43      -2.839 -12.821  -1.786  1.00  0.00
ATOM    695 3HB  LYS    43      -1.218 -12.085  -1.778  1.00  0.00
ATOM    696  CG  LYS    43      -1.521 -13.589  -0.299  1.00  2.03
ATOM    697 2HG  LYS    43      -1.134 -14.369  -0.955  1.00  0.00
ATOM    698 3HG  LYS    43      -0.718 -13.219   0.339  1.00  0.00
ATOM    699  CD  LYS    43      -2.612 -14.181   0.577  1.00 65.05
ATOM    700 2HD  LYS    43      -2.981 -13.411   1.255  1.00  0.00
ATOM    701 3HD  LYS    43      -3.427 -14.528  -0.057  1.00  0.00
ATOM    702  CE  LYS    43      -2.085 -15.348   1.392  1.00 31.24
ATOM    703 2HE  LYS    43      -1.771 -16.140   0.712  1.00  0.00
ATOM    704 3HE  LYS    43      -1.226 -15.013   1.973  1.00  0.00
ATOM    705  NZ  LYS    43      -3.111 -15.889   2.319  1.00 73.11
ATOM    706 1HZ  LYS    43      -2.725 -16.661   2.842  1.00  0.00
ATOM    707 2HZ  LYS    43      -3.402 -15.163   2.958  1.00  0.00
ATOM    708 3HZ  LYS    43      -3.908 -16.209   1.787  1.00  0.00
ATOM    709  C   LYS    43      -1.562 -10.798   0.684  1.00 65.14
ATOM    710  O   LYS    43      -0.491 -10.307   0.339  1.00 52.44
ATOM    711  N   VAL    44      -1.904 -10.951   1.953  1.00 34.22
ATOM    712  HN  VAL    44      -2.826 -11.288   2.190  1.00  0.00
ATOM    713  CA  VAL    44      -0.980 -10.644   3.030  1.00 11.25
ATOM    714  HA  VAL    44      -0.116 -10.132   2.606  1.00  0.00
ATOM    715  CB  VAL    44      -1.624  -9.729   4.095  1.00 33.34
ATOM    716  HB  VAL    44      -2.470 -10.260   4.531  1.00  0.00
ATOM    717  CG1 VAL    44      -0.638  -9.411   5.210  1.00 31.30
ATOM    718 1HG1 VAL    44      -1.117  -8.785   5.962  1.00  0.00
ATOM    719 2HG1 VAL    44      -0.303 -10.339   5.673  1.00  0.00
ATOM    720 3HG1 VAL    44       0.220  -8.882   4.795  1.00  0.00
ATOM    721  CG2 VAL    44      -2.143  -8.448   3.463  1.00 31.24
ATOM    722 1HG2 VAL    44      -2.616  -7.825   4.222  1.00  0.00
ATOM    723 2HG2 VAL    44      -1.312  -7.902   3.016  1.00  0.00
ATOM    724 3HG2 VAL    44      -2.872  -8.694   2.691  1.00  0.00
ATOM    725  C   VAL    44      -0.521 -11.935   3.689  1.00  1.33
ATOM    726  O   VAL    44      -1.344 -12.719   4.171  1.00 75.45
ATOM    727  N   ALA    45       0.784 -12.167   3.682  1.00 33.23
ATOM    728  HN  ALA    45       1.411 -11.505   3.246  1.00  0.00
ATOM    729  CA  ALA    45       1.350 -13.362   4.289  1.00  4.52
ATOM    730  HA  ALA    45       0.819 -14.228   3.896  1.00  0.00
ATOM    731  CB  ALA    45       2.821 -13.490   3.924  1.00 33.24
ATOM    732 1HB  ALA    45       3.231 -14.401   4.359  1.00  0.00
ATOM    733 2HB  ALA    45       2.924 -13.529   2.839  1.00  0.00
ATOM    734 3HB  ALA    45       3.367 -12.628   4.309  1.00  0.00
ATOM    735  C   ALA    45       1.174 -13.333   5.806  1.00 31.22
ATOM    736  O   ALA    45       1.238 -12.270   6.420  1.00 73.05
ATOM    770  N   GLY    48       3.404 -11.491   7.989  1.00 30.10
ATOM    771  HN  GLY    48       2.708 -12.044   7.511  1.00  0.00
ATOM    772  CA  GLY    48       3.350 -10.052   7.866  1.00 74.31
ATOM    773 1HA  GLY    48       2.307  -9.737   7.830  1.00  0.00
ATOM    774 2HA  GLY    48       3.833  -9.603   8.734  1.00  0.00
ATOM    775  C   GLY    48       4.051  -9.579   6.613  1.00 24.03
ATOM    776  O   GLY    48       3.814  -8.472   6.133  1.00 15.43
ATOM    777  N   ASP    49       4.903 -10.440   6.079  1.00 11.02
ATOM    778  HN  ASP    49       5.015 -11.352   6.498  1.00  0.00
ATOM    779  CA  ASP    49       5.695 -10.127   4.902  1.00 52.24
ATOM    780  HA  ASP    49       5.179  -9.360   4.324  1.00  0.00
ATOM    781  CB  ASP    49       7.062  -9.593   5.329  1.00 50.22
ATOM    782 2HB  ASP    49       6.916  -8.690   5.922  1.00  0.00
ATOM    783 3HB  ASP    49       7.558 -10.347   5.940  1.00  0.00
ATOM    784  CG  ASP    49       7.950  -9.263   4.152  1.00 14.31
ATOM    785  OD1 ASP    49       7.699  -8.239   3.491  1.00  4.41
ATOM    786  OD2 ASP    49       8.911 -10.016   3.892  1.00 61.05
ATOM    787 2HD  ASP    49       9.432  -9.741   3.134  1.00  0.00
ATOM    788  C   ASP    49       5.863 -11.371   4.037  1.00 11.41
ATOM    789  O   ASP    49       6.006 -12.478   4.563  1.00 62.34
ATOM    790  N   PRO    50       5.823 -11.222   2.702  1.00 53.04
ATOM    791  CD  PRO    50       6.050 -12.295   1.724  1.00  2.02
ATOM    792  CA  PRO    50       5.574  -9.945   2.041  1.00 31.54
ATOM    793  HA  PRO    50       5.968  -9.118   2.633  1.00  0.00
ATOM    794  CB  PRO    50       6.353 -10.099   0.737  1.00 11.21
ATOM    795 2HB  PRO    50       5.927  -9.493  -0.063  1.00  0.00
ATOM    796 3HB  PRO    50       7.393  -9.825   0.916  1.00  0.00
ATOM    797  CG  PRO    50       6.292 -11.561   0.421  1.00 50.44
ATOM    798 2HG  PRO    50       5.435 -11.730  -0.230  1.00  0.00
ATOM    799 3HG  PRO    50       7.212 -11.899  -0.056  1.00  0.00
ATOM    800 2HD  PRO    50       5.190 -12.960   1.646  1.00  0.00
ATOM    801 3HD  PRO    50       6.940 -12.857   2.006  1.00  0.00
ATOM    802  C   PRO    50       4.092  -9.703   1.765  1.00 62.31
ATOM    803  O   PRO    50       3.257 -10.595   1.941  1.00 32.31
ATOM    804  N   ILE    51       3.769  -8.496   1.332  1.00 72.31
ATOM    805  HN  ILE    51       4.486  -7.795   1.205  1.00  0.00
ATOM    806  CA  ILE    51       2.393  -8.145   1.028  1.00 32.51
ATOM    807  HA  ILE    51       1.750  -8.940   1.405  1.00  0.00
ATOM    808  CB  ILE    51       1.989  -6.822   1.716  1.00 15.23
ATOM    809  HB  ILE    51       2.664  -6.036   1.376  1.00  0.00
ATOM    810  CG2 ILE    51       0.565  -6.425   1.342  1.00 14.23
ATOM    811 1HG2 ILE    51       0.306  -5.481   1.822  1.00  0.00
ATOM    812 2HG2 ILE    51       0.493  -6.311   0.260  1.00  0.00
ATOM    813 3HG2 ILE    51      -0.126  -7.200   1.672  1.00  0.00
ATOM    814  CG1 ILE    51       2.127  -6.960   3.234  1.00 60.52
ATOM    815 2HG1 ILE    51       1.470  -7.763   3.567  1.00  0.00
ATOM    816 3HG1 ILE    51       3.161  -7.217   3.463  1.00  0.00
ATOM    817  CD1 ILE    51       1.768  -5.703   3.996  1.00 22.22
ATOM    818 1HD1 ILE    51       1.884  -5.859   5.068  1.00  0.00
ATOM    819 2HD1 ILE    51       2.424  -4.891   3.681  1.00  0.00
ATOM    820 3HD1 ILE    51       0.733  -5.436   3.783  1.00  0.00
ATOM    821  C   ILE    51       2.190  -8.028  -0.481  1.00 72.54
ATOM    822  O   ILE    51       2.812  -7.192  -1.138  1.00 22.10
ATOM    823  N   GLN    52       1.333  -8.884  -1.025  1.00 34.43
ATOM    824  HN  GLN    52       0.876  -9.571  -0.443  1.00  0.00
ATOM    825  CA  GLN    52       1.024  -8.869  -2.448  1.00 15.41
ATOM    826  HA  GLN    52       1.927  -8.589  -2.991  1.00  0.00
ATOM    827  CB  GLN    52       0.566 -10.252  -2.938  1.00 71.34
ATOM    828 2HB  GLN    52      -0.198 -10.618  -2.252  1.00  0.00
ATOM    829 3HB  GLN    52       0.135 -10.133  -3.932  1.00  0.00
ATOM    830  CG  GLN    52       1.670 -11.305  -3.023  1.00  4.11
ATOM    831 2HG  GLN    52       1.285 -12.166  -3.569  1.00  0.00
ATOM    832 3HG  GLN    52       2.511 -10.880  -3.571  1.00  0.00
ATOM    833  CD  GLN    52       2.168 -11.777  -1.668  1.00 53.41
ATOM    834  OE1 GLN    52       1.624 -12.713  -1.088  1.00  5.20
ATOM    835  NE2 GLN    52       3.228 -11.162  -1.176  1.00 34.13
ATOM    836 1HE2 GLN    52       3.653 -10.405  -1.692  1.00  0.00
ATOM    837 2HE2 GLN    52       3.611 -11.449  -0.287  1.00  0.00
ATOM    838  C   GLN    52      -0.063  -7.842  -2.733  1.00 61.21
ATOM    839  O   GLN    52      -1.165  -7.916  -2.182  1.00  0.50
ATOM    840  N   ILE    53       0.252  -6.888  -3.590  1.00 42.44
ATOM    841  HN  ILE    53       1.160  -6.894  -4.034  1.00  0.00
ATOM    842  CA  ILE    53      -0.670  -5.816  -3.924  1.00 13.15
ATOM    843  HA  ILE    53      -1.668  -6.117  -3.607  1.00  0.00
ATOM    844  CB  ILE    53      -0.298  -4.502  -3.199  1.00 55.32
ATOM    845  HB  ILE    53      -0.931  -3.705  -3.590  1.00  0.00
ATOM    846  CG2 ILE    53      -0.555  -4.625  -1.703  1.00 54.10
ATOM    847 1HG2 ILE    53      -0.312  -3.684  -1.209  1.00  0.00
ATOM    848 2HG2 ILE    53      -1.605  -4.861  -1.534  1.00  0.00
ATOM    849 3HG2 ILE    53       0.067  -5.420  -1.293  1.00  0.00
ATOM    850  CG1 ILE    53       1.165  -4.130  -3.471  1.00 73.23
ATOM    851 2HG1 ILE    53       1.800  -4.927  -3.085  1.00  0.00
ATOM    852 3HG1 ILE    53       1.304  -4.044  -4.549  1.00  0.00
ATOM    853  CD1 ILE    53       1.594  -2.826  -2.830  1.00 42.51
ATOM    854 1HD1 ILE    53       2.640  -2.614  -3.056  1.00  0.00
ATOM    855 2HD1 ILE    53       0.975  -2.015  -3.214  1.00  0.00
ATOM    856 3HD1 ILE    53       1.470  -2.897  -1.750  1.00  0.00
ATOM    857  C   ILE    53      -0.685  -5.570  -5.426  1.00  4.23
ATOM    858  O   ILE    53       0.305  -5.821  -6.114  1.00 23.24
ATOM    859  N   ASN    54      -1.813  -5.098  -5.931  1.00  5.12
ATOM    860  HN  ASN    54      -2.615  -4.958  -5.334  1.00  0.00
ATOM    861  CA  ASN    54      -1.930  -4.769  -7.343  1.00 30.22
ATOM    862  HA  ASN    54      -1.030  -5.111  -7.855  1.00  0.00
ATOM    863  CB  ASN    54      -3.142  -5.471  -7.968  1.00 62.43
ATOM    864 2HB  ASN    54      -3.110  -6.526  -7.697  1.00  0.00
ATOM    865 3HB  ASN    54      -4.050  -5.023  -7.564  1.00  0.00
ATOM    866  CG  ASN    54      -3.182  -5.360  -9.486  1.00 23.35
ATOM    867  OD1 ASN    54      -2.770  -4.358 -10.072  1.00 35.11
ATOM    868  ND2 ASN    54      -3.672  -6.405 -10.138  1.00 41.54
ATOM    869 1HD2 ASN    54      -3.996  -7.211  -9.624  1.00  0.00
ATOM    870 2HD2 ASN    54      -3.719  -6.393 -11.147  1.00  0.00
ATOM    871  C   ASN    54      -2.039  -3.262  -7.502  1.00 22.34
ATOM    872  O   ASN    54      -3.026  -2.650  -7.083  1.00 73.05
ATOM    873  N   VAL    55      -1.006  -2.671  -8.082  1.00 75.43
ATOM    874  HN  VAL    55      -0.240  -3.232  -8.426  1.00  0.00
ATOM    875  CA  VAL    55      -0.928  -1.229  -8.246  1.00 71.34
ATOM    876  HA  VAL    55      -1.902  -0.804  -8.003  1.00  0.00
ATOM    877  CB  VAL    55       0.133  -0.606  -7.310  1.00 33.34
ATOM    878  HB  VAL    55       1.113  -0.967  -7.622  1.00  0.00
ATOM    879  CG1 VAL    55       0.132   0.912  -7.419  1.00 22.32
ATOM    880 1HG1 VAL    55       0.903   1.331  -6.772  1.00  0.00
ATOM    881 2HG1 VAL    55       0.331   1.202  -8.451  1.00  0.00
ATOM    882 3HG1 VAL    55      -0.842   1.297  -7.116  1.00  0.00
ATOM    883  CG2 VAL    55      -0.094  -1.039  -5.872  1.00 73.44
ATOM    884 1HG2 VAL    55       0.678  -0.612  -5.231  1.00  0.00
ATOM    885 2HG2 VAL    55      -1.072  -0.692  -5.540  1.00  0.00
ATOM    886 3HG2 VAL    55      -0.054  -2.126  -5.811  1.00  0.00
ATOM    887  C   VAL    55      -0.581  -0.881  -9.688  1.00 52.14
ATOM    888  O   VAL    55       0.349  -1.448 -10.263  1.00 20.40
ATOM    889  N   ARG    56      -1.348   0.041 -10.269  1.00 30.54
ATOM    890  HN  ARG    56      -2.121   0.437  -9.754  1.00  0.00
ATOM    891  CA  ARG    56      -1.120   0.514 -11.639  1.00 51.31
ATOM    892  HA  ARG    56      -1.862   1.282 -11.857  1.00  0.00
ATOM    893  CB  ARG    56       0.277   1.135 -11.773  1.00 23.31
ATOM    894 2HB  ARG    56       1.016   0.360 -11.570  1.00  0.00
ATOM    895 3HB  ARG    56       0.395   1.490 -12.797  1.00  0.00
ATOM    896  CG  ARG    56       0.541   2.303 -10.832  1.00 62.31
ATOM    897 2HG  ARG    56       0.416   1.963  -9.804  1.00  0.00
ATOM    898 3HG  ARG    56       1.564   2.650 -10.978  1.00  0.00
ATOM    899  CD  ARG    56      -0.411   3.460 -11.087  1.00 42.41
ATOM    900 2HD  ARG    56      -0.399   3.701 -12.150  1.00  0.00
ATOM    901 3HD  ARG    56      -1.418   3.160 -10.800  1.00  0.00
ATOM    902  NE  ARG    56      -0.036   4.653 -10.326  1.00  4.24
ATOM    903  HE  ARG    56       0.587   4.524  -9.541  1.00  0.00
ATOM    904  CZ  ARG    56      -0.465   5.885 -10.609  1.00 43.14
ATOM    905  NH1 ARG    56      -1.314   6.077 -11.610  1.00 63.41
ATOM    906 1HH1 ARG    56      -1.640   7.009 -11.825  1.00  0.00
ATOM    907 2HH1 ARG    56      -1.634   5.292 -12.158  1.00  0.00
ATOM    908  NH2 ARG    56      -0.049   6.924  -9.892  1.00 51.54
ATOM    909 1HH2 ARG    56      -0.377   7.855 -10.110  1.00  0.00
ATOM    910 2HH2 ARG    56       0.597   6.784  -9.128  1.00  0.00
ATOM    911  C   ARG    56      -1.282  -0.618 -12.658  1.00  4.53
ATOM    912  O   ARG    56      -0.865  -0.492 -13.809  1.00 23.23
ATOM    913  N   GLY    57      -1.895  -1.715 -12.233  1.00 73.14
ATOM    914  HN  GLY    57      -2.234  -1.773 -11.284  1.00  0.00
ATOM    915  CA  GLY    57      -2.091  -2.848 -13.115  1.00 35.31
ATOM    916 1HA  GLY    57      -3.079  -3.269 -12.931  1.00  0.00
ATOM    917 2HA  GLY    57      -2.032  -2.503 -14.148  1.00  0.00
ATOM    918  C   GLY    57      -1.051  -3.927 -12.900  1.00 64.14
ATOM    919  O   GLY    57      -1.142  -5.016 -13.474  1.00 42.35
ATOM    920  N   TYR    58      -0.058  -3.632 -12.072  1.00  2.31
ATOM    921  HN  TYR    58      -0.016  -2.720 -11.639  1.00  0.00
ATOM    922  CA  TYR    58       0.987  -4.594 -11.767  1.00 75.35
ATOM    923  HA  TYR    58       0.988  -5.367 -12.535  1.00  0.00
ATOM    924  CB  TYR    58       2.360  -3.910 -11.743  1.00 75.12
ATOM    925 2HB  TYR    58       2.411  -3.270 -10.862  1.00  0.00
ATOM    926 3HB  TYR    58       3.128  -4.679 -11.662  1.00  0.00
ATOM    927  CG  TYR    58       2.658  -3.066 -12.963  1.00 71.43
ATOM    928  CD1 TYR    58       2.429  -1.695 -12.953  1.00 24.05
ATOM    929 1HD  TYR    58       2.032  -1.230 -12.063  1.00  0.00
ATOM    930  CE1 TYR    58       2.701  -0.916 -14.061  1.00 21.41
ATOM    931 1HE  TYR    58       2.519   0.149 -14.035  1.00  0.00
ATOM    932  CZ  TYR    58       3.206  -1.504 -15.198  1.00 52.22
ATOM    933  CE2 TYR    58       3.443  -2.864 -15.233  1.00 71.21
ATOM    934 2HE  TYR    58       3.842  -3.322 -16.126  1.00  0.00
ATOM    935  CD2 TYR    58       3.168  -3.636 -14.120  1.00 63.43
ATOM    936 2HD  TYR    58       3.354  -4.699 -14.152  1.00  0.00
ATOM    937  OH  TYR    58       3.481  -0.729 -16.301  1.00  1.03
ATOM    938  HH  TYR    58       3.830  -1.236 -17.038  1.00  0.00
ATOM    939  C   TYR    58       0.718  -5.230 -10.411  1.00 14.14
ATOM    940  O   TYR    58       0.517  -4.528  -9.421  1.00 11.24
ATOM    941  N   GLU    59       0.726  -6.549 -10.364  1.00 53.21
ATOM    942  HN  GLU    59       0.863  -7.086 -11.208  1.00  0.00
ATOM    943  CA  GLU    59       0.542  -7.253  -9.111  1.00 72.32
ATOM    944  HA  GLU    59       0.152  -6.552  -8.373  1.00  0.00
ATOM    945  CB  GLU    59      -0.464  -8.384  -9.277  1.00 21.34
ATOM    946 2HB  GLU    59      -1.363  -7.975  -9.737  1.00  0.00
ATOM    947 3HB  GLU    59      -0.028  -9.135  -9.936  1.00  0.00
ATOM    948  CG  GLU    59      -0.860  -9.063  -7.978  1.00 50.34
ATOM    949 2HG  GLU    59       0.004  -9.596  -7.582  1.00  0.00
ATOM    950 3HG  GLU    59      -1.169  -8.301  -7.263  1.00  0.00
ATOM    951  CD  GLU    59      -1.997 -10.046  -8.169  1.00 11.43
ATOM    952  OE1 GLU    59      -1.748 -11.270  -8.169  1.00 32.42
ATOM    953  OE2 GLU    59      -3.148  -9.597  -8.329  1.00 24.44
ATOM    954 2HE  GLU    59      -3.819 -10.272  -8.447  1.00  0.00
ATOM    955  C   GLU    59       1.883  -7.773  -8.626  1.00 14.44
ATOM    956  O   GLU    59       2.507  -8.630  -9.254  1.00 31.01
ATOM    957  N   LEU    60       2.317  -7.241  -7.510  1.00 74.52
ATOM    958  HN  LEU    60       1.712  -6.636  -6.972  1.00  0.00
ATOM    959  CA  LEU    60       3.660  -7.496  -7.014  1.00 72.24
ATOM    960  HA  LEU    60       4.021  -8.417  -7.471  1.00  0.00
ATOM    961  CB  LEU    60       4.599  -6.347  -7.428  1.00 22.23
ATOM    962 2HB  LEU    60       5.542  -6.478  -6.896  1.00  0.00
ATOM    963 3HB  LEU    60       4.773  -6.429  -8.501  1.00  0.00
ATOM    964  CG  LEU    60       4.092  -4.922  -7.141  1.00 32.14
ATOM    965  HG  LEU    60       3.029  -4.886  -7.378  1.00  0.00
ATOM    966  CD1 LEU    60       4.262  -4.554  -5.672  1.00 70.41
ATOM    967 1HD1 LEU    60       3.877  -3.550  -5.492  1.00  0.00
ATOM    968 2HD1 LEU    60       3.714  -5.266  -5.055  1.00  0.00
ATOM    969 3HD1 LEU    60       5.320  -4.585  -5.411  1.00  0.00
ATOM    970  CD2 LEU    60       4.813  -3.917  -8.025  1.00 62.34
ATOM    971 1HD2 LEU    60       4.428  -2.915  -7.836  1.00  0.00
ATOM    972 2HD2 LEU    60       5.881  -3.940  -7.805  1.00  0.00
ATOM    973 3HD2 LEU    60       4.652  -4.174  -9.072  1.00  0.00
ATOM    974  C   LEU    60       3.667  -7.679  -5.505  1.00  2.23
ATOM    975  O   LEU    60       2.642  -7.519  -4.844  1.00 52.31
ATOM    976  N   SER    61       4.828  -8.020  -4.972  1.00 74.25
ATOM    977  HN  SER    61       5.627  -8.181  -5.569  1.00  0.00
ATOM    978  CA  SER    61       4.995  -8.170  -3.542  1.00 63.23
ATOM    979  HA  SER    61       4.012  -8.161  -3.072  1.00  0.00
ATOM    980  CB  SER    61       5.683  -9.497  -3.229  1.00 42.21
ATOM    981 2HB  SER    61       6.687  -9.486  -3.654  1.00  0.00
ATOM    982 3HB  SER    61       5.748  -9.618  -2.148  1.00  0.00
ATOM    983  OG  SER    61       4.962 -10.591  -3.774  1.00 23.41
ATOM    984  HG  SER    61       5.421 -11.406  -3.559  1.00  0.00
ATOM    985  C   SER    61       5.819  -7.015  -2.991  1.00 23.22
ATOM    986  O   SER    61       6.931  -6.758  -3.455  1.00 22.24
ATOM    987  N   LEU    62       5.266  -6.313  -2.021  1.00 12.43
ATOM    988  HN  LEU    62       4.330  -6.531  -1.711  1.00  0.00
ATOM    989  CA  LEU    62       5.971  -5.222  -1.377  1.00 51.32
ATOM    990  HA  LEU    62       6.855  -4.980  -1.968  1.00  0.00
ATOM    991  CB  LEU    62       5.083  -3.979  -1.295  1.00 61.11
ATOM    992 2HB  LEU    62       4.769  -3.723  -2.307  1.00  0.00
ATOM    993 3HB  LEU    62       4.209  -4.229  -0.695  1.00  0.00
ATOM    994  CG  LEU    62       5.742  -2.741  -0.677  1.00 32.54
ATOM    995  HG  LEU    62       6.151  -3.019   0.294  1.00  0.00
ATOM    996  CD1 LEU    62       6.885  -2.240  -1.549  1.00 41.21
ATOM    997 1HD1 LEU    62       7.354  -1.372  -1.084  1.00  0.00
ATOM    998 2HD1 LEU    62       7.626  -3.031  -1.665  1.00  0.00
ATOM    999 3HD1 LEU    62       6.498  -1.959  -2.529  1.00  0.00
ATOM   1000  CD2 LEU    62       4.713  -1.644  -0.467  1.00 23.13
ATOM   1001 1HD2 LEU    62       5.186  -0.777  -0.005  1.00  0.00
ATOM   1002 2HD2 LEU    62       4.291  -1.354  -1.429  1.00  0.00
ATOM   1003 3HD2 LEU    62       3.919  -2.011   0.183  1.00  0.00
ATOM   1004  C   LEU    62       6.408  -5.654   0.011  1.00 31.25
ATOM   1005  O   LEU    62       5.637  -6.276   0.748  1.00 74.34
ATOM   1006  N   ARG    63       7.653  -5.354   0.346  1.00 72.31
ATOM   1007  HN  ARG    63       8.242  -4.855  -0.306  1.00  0.00
ATOM   1008  CA  ARG    63       8.209  -5.723   1.634  1.00  1.32
ATOM   1009  HA  ARG    63       8.070  -6.794   1.778  1.00  0.00
ATOM   1010  CB  ARG    63       9.705  -5.411   1.673  1.00 14.24
ATOM   1011 2HB  ARG    63      10.103  -5.508   0.663  1.00  0.00
ATOM   1012 3HB  ARG    63       9.833  -4.384   2.017  1.00  0.00
ATOM   1013  CG  ARG    63      10.497  -6.325   2.590  1.00 34.41
ATOM   1014 2HG  ARG    63      11.554  -6.068   2.522  1.00  0.00
ATOM   1015 3HG  ARG    63      10.155  -6.184   3.615  1.00  0.00
ATOM   1016  CD  ARG    63      10.315  -7.783   2.201  1.00 15.20
ATOM   1017 2HD  ARG    63      10.006  -8.343   3.083  1.00  0.00
ATOM   1018 3HD  ARG    63       9.534  -7.846   1.444  1.00  0.00
ATOM   1019  NE  ARG    63      11.532  -8.390   1.667  1.00 23.14
ATOM   1020  HE  ARG    63      12.225  -7.771   1.268  1.00  0.00
ATOM   1021  CZ  ARG    63      11.769  -9.703   1.681  1.00 34.00
ATOM   1022  NH1 ARG    63      10.905 -10.538   2.250  1.00 30.12
ATOM   1023 1HH1 ARG    63      11.093 -11.530   2.262  1.00  0.00
ATOM   1024 2HH1 ARG    63      10.060 -10.179   2.670  1.00  0.00
ATOM   1025  NH2 ARG    63      12.885 -10.177   1.142  1.00 65.32
ATOM   1026 1HH2 ARG    63      13.070 -11.169   1.156  1.00  0.00
ATOM   1027 2HH2 ARG    63      13.550  -9.545   0.718  1.00  0.00
ATOM   1028  C   ARG    63       7.490  -4.979   2.751  1.00 54.04
ATOM   1029  O   ARG    63       7.207  -3.782   2.631  1.00 41.32
ATOM   1030  N   LYS    64       7.194  -5.697   3.826  1.00 42.41
ATOM   1031  HN  LYS    64       7.451  -6.673   3.857  1.00  0.00
ATOM   1032  CA  LYS    64       6.506  -5.131   4.978  1.00 13.22
ATOM   1033  HA  LYS    64       5.521  -4.794   4.656  1.00  0.00
ATOM   1034  CB  LYS    64       6.322  -6.207   6.060  1.00 51.34
ATOM   1035 2HB  LYS    64       5.863  -7.080   5.597  1.00  0.00
ATOM   1036 3HB  LYS    64       7.306  -6.474   6.446  1.00  0.00
ATOM   1037  CG  LYS    64       5.451  -5.776   7.233  1.00 41.41
ATOM   1038 2HG  LYS    64       4.672  -5.108   6.865  1.00  0.00
ATOM   1039 3HG  LYS    64       4.993  -6.660   7.674  1.00  0.00
ATOM   1040  CD  LYS    64       6.251  -5.053   8.304  1.00 32.31
ATOM   1041 2HD  LYS    64       7.058  -4.497   7.826  1.00  0.00
ATOM   1042 3HD  LYS    64       5.593  -4.359   8.827  1.00  0.00
ATOM   1043  CE  LYS    64       6.850  -6.018   9.314  1.00 34.43
ATOM   1044 2HE  LYS    64       6.045  -6.569   9.799  1.00  0.00
ATOM   1045 3HE  LYS    64       7.501  -6.719   8.792  1.00  0.00
ATOM   1046  NZ  LYS    64       7.640  -5.305  10.350  1.00 21.10
ATOM   1047 1HZ  LYS    64       8.024  -5.972  11.004  1.00  0.00
ATOM   1048 2HZ  LYS    64       8.393  -4.797   9.908  1.00  0.00
ATOM   1049 3HZ  LYS    64       7.042  -4.658  10.843  1.00  0.00
ATOM   1050  C   LYS    64       7.270  -3.928   5.525  1.00 20.34
ATOM   1051  O   LYS    64       6.670  -3.002   6.063  1.00 13.53
ATOM   1052  N   SER    65       8.588  -3.943   5.363  1.00 44.33
ATOM   1053  HN  SER    65       9.030  -4.744   4.935  1.00  0.00
ATOM   1054  CA  SER    65       9.431  -2.832   5.783  1.00 15.40
ATOM   1055  HA  SER    65       9.404  -2.762   6.870  1.00  0.00
ATOM   1056  CB  SER    65      10.867  -3.094   5.338  1.00  2.23
ATOM   1057 2HB  SER    65      10.933  -2.985   4.255  1.00  0.00
ATOM   1058 3HB  SER    65      11.529  -2.372   5.817  1.00  0.00
ATOM   1059  OG  SER    65      11.268  -4.405   5.700  1.00 32.21
ATOM   1060  HG  SER    65      12.173  -4.543   5.409  1.00  0.00
ATOM   1061  C   SER    65       8.924  -1.516   5.191  1.00 13.15
ATOM   1062  O   SER    65       8.802  -0.514   5.895  1.00 62.15
ATOM   1063  N   ALA    66       8.615  -1.536   3.898  1.00 34.10
ATOM   1064  HN  ALA    66       8.753  -2.380   3.362  1.00  0.00
ATOM   1065  CA  ALA    66       8.079  -0.366   3.220  1.00 54.22
ATOM   1066  HA  ALA    66       8.640   0.508   3.552  1.00  0.00
ATOM   1067  CB  ALA    66       8.249  -0.505   1.715  1.00 24.42
ATOM   1068 1HB  ALA    66       7.870   0.388   1.217  1.00  0.00
ATOM   1069 2HB  ALA    66       9.306  -0.628   1.479  1.00  0.00
ATOM   1070 3HB  ALA    66       7.695  -1.376   1.366  1.00  0.00
ATOM   1071  C   ALA    66       6.610  -0.163   3.576  1.00 45.41
ATOM   1072  O   ALA    66       6.182   0.951   3.870  1.00 32.23
ATOM   1073  N   ALA    67       5.848  -1.255   3.566  1.00 75.31
ATOM   1074  HN  ALA    67       6.265  -2.150   3.353  1.00  0.00
ATOM   1075  CA  ALA    67       4.412  -1.212   3.853  1.00  4.20
ATOM   1076  HA  ALA    67       3.935  -0.590   3.095  1.00  0.00
ATOM   1077  CB  ALA    67       3.818  -2.609   3.784  1.00 33.13
ATOM   1078 1HB  ALA    67       2.745  -2.564   3.967  1.00  0.00
ATOM   1079 2HB  ALA    67       3.998  -3.030   2.795  1.00  0.00
ATOM   1080 3HB  ALA    67       4.288  -3.240   4.538  1.00  0.00
ATOM   1081  C   ALA    67       4.131  -0.608   5.223  1.00 73.35
ATOM   1082  O   ALA    67       3.103   0.033   5.438  1.00 14.33
ATOM   1083  N   GLU    68       5.055  -0.821   6.144  1.00 44.23
ATOM   1084  HN  GLU    68       5.899  -1.318   5.897  1.00  0.00
ATOM   1085  CA  GLU    68       4.904  -0.361   7.514  1.00 44.40
ATOM   1086  HA  GLU    68       3.871  -0.520   7.823  1.00  0.00
ATOM   1087  CB  GLU    68       5.824  -1.174   8.424  1.00 14.11
ATOM   1088 2HB  GLU    68       5.845  -2.202   8.063  1.00  0.00
ATOM   1089 3HB  GLU    68       6.827  -0.749   8.368  1.00  0.00
ATOM   1090  CG  GLU    68       5.390  -1.185   9.873  1.00 61.13
ATOM   1091 2HG  GLU    68       5.224  -0.157  10.197  1.00  0.00
ATOM   1092 3HG  GLU    68       4.458  -1.743   9.956  1.00  0.00
ATOM   1093  CD  GLU    68       6.421  -1.821  10.779  1.00 20.11
ATOM   1094  OE1 GLU    68       6.416  -3.060  10.913  1.00 34.45
ATOM   1095  OE2 GLU    68       7.250  -1.081  11.348  1.00 62.33
ATOM   1096 2HE  GLU    68       7.877  -1.550  11.904  1.00  0.00
ATOM   1097  C   GLU    68       5.227   1.129   7.630  1.00 75.25
ATOM   1098  O   GLU    68       4.959   1.757   8.653  1.00 10.11
ATOM   1099  N   MET    69       5.792   1.690   6.570  1.00 20.45
ATOM   1100  HN  MET    69       5.949   1.146   5.734  1.00  0.00
ATOM   1101  CA  MET    69       6.201   3.088   6.577  1.00 54.12
ATOM   1102  HA  MET    69       6.113   3.468   7.595  1.00  0.00
ATOM   1103  CB  MET    69       7.663   3.203   6.133  1.00 20.41
ATOM   1104 2HB  MET    69       8.232   2.415   6.625  1.00  0.00
ATOM   1105 3HB  MET    69       7.704   3.061   5.053  1.00  0.00
ATOM   1106  CG  MET    69       8.317   4.539   6.462  1.00 42.02
ATOM   1107 2HG  MET    69       9.191   4.667   5.822  1.00  0.00
ATOM   1108 3HG  MET    69       7.607   5.338   6.246  1.00  0.00
ATOM   1109  SD  MET    69       8.840   4.681   8.189  1.00  4.42
ATOM   1110  CE  MET    69       7.274   4.758   9.061  1.00 63.43
ATOM   1111 1HE  MET    69       7.440   4.847  10.134  1.00  0.00
ATOM   1112 2HE  MET    69       6.710   5.624   8.714  1.00  0.00
ATOM   1113 3HE  MET    69       6.705   3.851   8.861  1.00  0.00
ATOM   1114  C   MET    69       5.301   3.925   5.664  1.00 71.11
ATOM   1115  O   MET    69       5.238   5.151   5.783  1.00 34.42
ATOM   1116  N   ILE    70       4.608   3.255   4.751  1.00 71.51
ATOM   1117  HN  ILE    70       4.694   2.250   4.696  1.00  0.00
ATOM   1118  CA  ILE    70       3.716   3.924   3.814  1.00 12.23
ATOM   1119  HA  ILE    70       4.222   4.819   3.449  1.00  0.00
ATOM   1120  CB  ILE    70       3.390   3.017   2.604  1.00 13.04
ATOM   1121  HB  ILE    70       2.984   2.078   2.979  1.00  0.00
ATOM   1122  CG2 ILE    70       2.346   3.661   1.701  1.00 31.32
ATOM   1123 1HG2 ILE    70       2.117   2.997   0.867  1.00  0.00
ATOM   1124 2HG2 ILE    70       1.438   3.848   2.274  1.00  0.00
ATOM   1125 3HG2 ILE    70       2.733   4.605   1.315  1.00  0.00
ATOM   1126  CG1 ILE    70       4.666   2.712   1.818  1.00 34.52
ATOM   1127 2HG1 ILE    70       5.076   3.653   1.449  1.00  0.00
ATOM   1128 3HG1 ILE    70       5.382   2.244   2.493  1.00  0.00
ATOM   1129  CD1 ILE    70       4.452   1.790   0.637  1.00 53.12
ATOM   1130 1HD1 ILE    70       5.393   1.611   0.116  1.00  0.00
ATOM   1131 2HD1 ILE    70       4.053   0.840   0.990  1.00  0.00
ATOM   1132 3HD1 ILE    70       3.744   2.248  -0.054  1.00  0.00
ATOM   1133  C   ILE    70       2.420   4.343   4.499  1.00 22.13
ATOM   1134  O   ILE    70       1.825   3.569   5.249  1.00  5.50
ATOM   1135  N   GLU    71       1.996   5.573   4.234  1.00 74.54
ATOM   1136  HN  GLU    71       2.534   6.165   3.617  1.00  0.00
ATOM   1137  CA  GLU    71       0.770   6.106   4.805  1.00 62.40
ATOM   1138  HA  GLU    71       0.511   5.522   5.688  1.00  0.00
ATOM   1139  CB  GLU    71       0.975   7.565   5.218  1.00  4.32
ATOM   1140 2HB  GLU    71       1.811   7.610   5.916  1.00  0.00
ATOM   1141 3HB  GLU    71       1.217   8.144   4.326  1.00  0.00
ATOM   1142  CG  GLU    71      -0.237   8.195   5.882  1.00  4.43
ATOM   1143 2HG  GLU    71      -0.751   8.822   5.153  1.00  0.00
ATOM   1144 3HG  GLU    71      -0.909   7.403   6.211  1.00  0.00
ATOM   1145  CD  GLU    71       0.136   9.044   7.076  1.00 71.52
ATOM   1146  OE1 GLU    71       0.853   8.545   7.968  1.00 64.22
ATOM   1147  OE2 GLU    71      -0.289  10.214   7.135  1.00 11.53
ATOM   1148 2HE  GLU    71      -0.014  10.694   7.920  1.00  0.00
ATOM   1149  C   GLU    71      -0.366   6.006   3.792  1.00 30.13
ATOM   1150  O   GLU    71      -0.350   6.672   2.752  1.00 22.31
ATOM   1151  N   VAL    72      -1.343   5.166   4.091  1.00 24.24
ATOM   1152  HN  VAL    72      -1.307   4.640   4.952  1.00  0.00
ATOM   1153  CA  VAL    72      -2.481   4.974   3.208  1.00 73.40
ATOM   1154  HA  VAL    72      -2.415   5.715   2.411  1.00  0.00
ATOM   1155  CB  VAL    72      -2.490   3.566   2.570  1.00 61.32
ATOM   1156  HB  VAL    72      -3.380   3.484   1.946  1.00  0.00
ATOM   1157  CG1 VAL    72      -1.272   3.362   1.683  1.00 52.44
ATOM   1158 1HG1 VAL    72      -1.309   2.375   1.222  1.00  0.00
ATOM   1159 2HG1 VAL    72      -1.260   4.124   0.903  1.00  0.00
ATOM   1160 3HG1 VAL    72      -0.367   3.445   2.285  1.00  0.00
ATOM   1161  CG2 VAL    72      -2.562   2.485   3.642  1.00  5.02
ATOM   1162 1HG2 VAL    72      -2.594   1.501   3.174  1.00  0.00
ATOM   1163 2HG2 VAL    72      -1.682   2.552   4.283  1.00  0.00
ATOM   1164 3HG2 VAL    72      -3.460   2.630   4.242  1.00  0.00
ATOM   1165  C   VAL    72      -3.783   5.181   3.964  1.00 64.04
ATOM   1166  O   VAL    72      -3.787   5.310   5.188  1.00 22.25
ATOM   1167  N   GLU    73      -4.880   5.220   3.230  1.00 45.33
ATOM   1168  HN  GLU    73      -4.815   5.170   2.223  1.00  0.00
ATOM   1169  CA  GLU    73      -6.195   5.333   3.835  1.00 65.41
ATOM   1170  HA  GLU    73      -6.083   5.265   4.917  1.00  0.00
ATOM   1171  CB  GLU    73      -6.847   6.673   3.492  1.00 65.44
ATOM   1172 2HB  GLU    73      -6.995   6.717   2.413  1.00  0.00
ATOM   1173 3HB  GLU    73      -7.813   6.724   3.994  1.00  0.00
ATOM   1174  CG  GLU    73      -6.029   7.877   3.910  1.00  3.41
ATOM   1175 2HG  GLU    73      -5.702   7.739   4.940  1.00  0.00
ATOM   1176 3HG  GLU    73      -5.154   7.950   3.263  1.00  0.00
ATOM   1177  CD  GLU    73      -6.812   9.168   3.816  1.00 44.43
ATOM   1178  OE1 GLU    73      -7.138   9.745   4.877  1.00 73.24
ATOM   1179  OE2 GLU    73      -7.111   9.610   2.689  1.00 41.01
ATOM   1180 2HE  GLU    73      -7.608  10.431   2.707  1.00  0.00
ATOM   1181  C   GLU    73      -7.089   4.205   3.357  1.00 53.54
ATOM   1182  O   GLU    73      -7.093   3.870   2.170  1.00 75.24
END
