
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  121 (  882),  selected  121 , name 2ccz_A
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 2ccz_A.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M    -6_A      -       -           -
LGA    D    -5_A      -       -           -
LGA    P    -4_A      -       -           -
LGA    N    -3_A      -       -           -
LGA    S    -2_A      -       -           -
LGA    L    -1_A      -       -           -
LGA    M     1_A      -       -           -
LGA    T     2_A      M       1          0.685
LGA    N     3_A      N       2          0.816
LGA    R     4_A      T       3          0.609
LGA    L     5_A      L       4          0.336
LGA    V     6_A      E       5          0.643
LGA    L     7_A      L       6          0.954
LGA    S     8_A      S       7          0.783
LGA    G     9_A      A       8          0.815
LGA    T    10_A      R       9          0.709
LGA    V    11_A      V      10          0.975
LGA    C    12_A      L      11          0.758
LGA    R    13_A      E      12          1.043
LGA    A    14_A      C      13          1.730
LGA    P    15_A      G      14          2.766
LGA    L    16_A      A      15          2.769
LGA    R    17_A      M      16          1.793
LGA    K    18_A      R      17          0.934
LGA    V    19_A      H      18          0.719
LGA    S    20_A      T      19          1.192
LGA    P    21_A      P      20          0.827
LGA    S    22_A      A      21          1.327
LGA    G    23_A      G      22          1.069
LGA    I    24_A      L      23          0.958
LGA    P    25_A      P      24          0.971
LGA    H    26_A      A      25          0.480
LGA    C    27_A      L      26          0.468
LGA    Q    28_A      E      27          0.568
LGA    F    29_A      L      28          0.873
LGA    V    30_A      L      29          0.479
LGA    L    31_A      L      30          0.060
LGA    E    32_A      V      31          0.526
LGA    H    33_A      H      32          0.671
LGA    R    34_A      E      33          1.114
LGA    S    35_A      S      34          0.986
LGA    V    36_A      E      35          0.685
LGA    Q    37_A      V      36          0.830
LGA    E    38_A      V      37          0.706
LGA    E    39_A      E      38          0.645
LGA    A    40_A      A      39          1.017
LGA    G    41_A      G      40          1.238
LGA    F    42_A      H      41          1.193
LGA    H    43_A      P      42          0.747
LGA    R    44_A      R      43          0.417
LGA    Q    45_A      R      44          1.011
LGA    A    46_A      V      45          1.056
LGA    W    47_A      E      46          1.174
LGA    C    48_A      L      47          1.019
LGA    Q    49_A      T      48          0.945
LGA    M    50_A      I      49          1.005
LGA    P    51_A      S      50          0.299
LGA    V    52_A      A      51          0.324
LGA    I    53_A      V      52          0.826
LGA    V    54_A      A      53          0.478
LGA    S    55_A      L      54          0.083
LGA    G    56_A      G      55          1.508
LGA    H    57_A      D      56          3.339
LGA    E    58_A      -       -           -
LGA    N    59_A      L      57          1.910
LGA    Q    60_A      A      58          2.872
LGA    A    61_A      L      59          3.017
LGA    I    62_A      L      60          1.806
LGA    T    63_A      L      61          0.755
LGA    H    64_A      A      62          2.480
LGA    S    65_A      D      63          5.171
LGA    I    66_A      T      64          1.531
LGA    T    67_A      P      65          0.957
LGA    V    68_A      L      66          0.735
LGA    G    69_A      G      67          0.791
LGA    S    70_A      T      68          0.896
LGA    R    71_A      E      69          0.694
LGA    I    72_A      M      70          0.551
LGA    T    73_A      Q      71          1.184
LGA    V    74_A      V      72          1.134
LGA    Q    75_A      Q      73          0.815
LGA    G    76_A      G      74          0.815
LGA    F    77_A      F      75          0.778
LGA    I    78_A      L      76          0.804
LGA    S    79_A      A      77          0.623
LGA    C    80_A      P      78          1.029
LGA    H    81_A      A      79          5.048
LGA    -       -      R      80           -
LGA    -       -      K      81           -
LGA    K    82_A      D      82          4.816
LGA    A    83_A      S      83          4.403
LGA    K    84_A      -       -           -
LGA    N    85_A      -       -           -
LGA    G    86_A      -       -           -
LGA    L    87_A      -       -           -
LGA    S    88_A      V      84           #
LGA    K    89_A      K      85          3.073
LGA    M    90_A      V      86          0.963
LGA    V    91_A      K      87          0.717
LGA    L    92_A      L      88          0.581
LGA    H    93_A      H      89          0.513
LGA    A    94_A      L      90          0.436
LGA    E    95_A      Q      91          1.040
LGA    Q    96_A      Q      92          0.781
LGA    I    97_A      A      93          0.789
LGA    E    98_A      R      94          0.929
LGA    L    99_A      R      95          1.444
LGA    I   100_A      I      96          1.988
LGA    D   101_A      A      97          3.129
LGA    S   102_A      G      98          2.900
LGA    V   103_A      -       -           -
LGA    D   104_A      -       -           -
LGA    K   105_A      -       -           -
LGA    L   106_A      -       -           -
LGA    A   107_A      -       -           -
LGA    A   108_A      -       -           -
LGA    A   109_A      -       -           -
LGA    L   110_A      -       -           -
LGA    E   111_A      -       -           -
LGA    H   112_A      -       -           -
LGA    H   113_A      -       -           -
LGA    H   114_A      -       -           -
LGA    H   115_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  121   98    5.0     95    1.61    27.37     91.707     5.545

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.948578 * X  +   0.163855 * Y  +   0.270833 * Z  +   6.603489
  Y_new =   0.275463 * X  +  -0.005783 * Y  +  -0.961294 * Z  +  30.950472
  Z_new =  -0.155947 * X  +   0.986467 * Y  +  -0.050621 * Z  +  17.776693 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.622067   -1.519526  [ DEG:    92.9376    -87.0624 ]
  Theta =   0.156586    2.985007  [ DEG:     8.9717    171.0283 ]
  Phi   =   0.282622   -2.858971  [ DEG:    16.1930   -163.8070 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ccz_A                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ccz_A.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  121   98   5.0   95   1.61   27.37  91.707
REMARK  ---------------------------------------------------------- 
MOLECULE 2ccz_A
HEADER    DNA/PROTEIN COMPLEX                     19-JAN-06   2CCZ              
TITLE     CRYSTAL STRUCTURE OF E. COLI PRIMOSOMOL PROTEIN PRIB BOUND            
TITLE    2 TO SSDNA                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 5'-D(*TP*TP*TP*TP*TP*TP*TP*TP*TP*TP                        
COMPND   3 *TP*TP*TP*TP*T)-3';                                                  
COMPND   4 CHAIN: C;                                                            
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: PRIMOSOMAL REPLICATION PROTEIN N;                          
COMPND   8 CHAIN: A, B;                                                         
COMPND   9 SYNONYM: PRIB;                                                       
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 SYNTHETIC: YES;                                                      
SOURCE   3 MOL_ID: 2;                                                           
SOURCE   4 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   5 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   6 STRAIN: K12;                                                         
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE  10 EXPRESSION_SYSTEM_VECTOR: PET21B                                     
KEYWDS    PRIMOSOME,PRIB,DNA REPLICATION,DNA REPAIR,DNA RECOMBINATION,          
KEYWDS   2 SSDNA,SINGLE-STRANDED DNA,DNA/PROTEIN COMPLEX                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.-Y.HUANG,C.-H.HSU,H.-N.WU,Y.-J.SUN,C.-D.HSIAO                       
REVDAT   1   18-SEP-06 2CCZ    0                                                
JRNL        AUTH   C.Y.HUANG,C.H.HSU,Y.J.SUN,H.N.WU,C.D.HSIAO                   
JRNL        TITL   COMPLEXED CRYSTAL STRUCTURE OF REPLICATION RESTART           
JRNL        TITL 2 PRIMOSOME PROTEIN PRIB REVEALS A NOVEL                       
JRNL        TITL 3 SINGLE-STRANDED DNA-BINDING MODE.                            
JRNL        REF    NUCLEIC ACIDS RES.            V.  34  3878 2006              
JRNL        REFN   ASTM NARHAD  UK ISSN 0305-1048                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  2CCZ A   -6    -1  PDB    2CCZ     2CCZ            -6     -1             
DBREF  2CCZ A    1     1  PDB    2CCZ     2CCZ             1      1             
DBREF  2CCZ A    2   104  UNP    P07013   PRIB_ECOLI       1    103             
DBREF  2CCZ A  105   117  PDB    2CCZ     2CCZ           105    117             
DBREF  2CCZ B   -6    -1  PDB    2CCZ     2CCZ            -6     -1             
DBREF  2CCZ B    1     1  PDB    2CCZ     2CCZ             1      1             
DBREF  2CCZ B    2   104  UNP    P07013   PRIB_ECOLI       1    103             
DBREF  2CCZ B  105   117  PDB    2CCZ     2CCZ           105    117             
DBREF  2CCZ C    1    15  PDB    2CCZ     2CCZ             1     15             
SEQRES   1 C   15   DT  DT  DT  DT  DT  DT  DT  DT  DT  DT  DT  DT  DT          
SEQRES   2 C   15   DT  DT                                                      
SEQRES   1 A  123  MET ASP PRO ASN SER LEU MET THR ASN ARG LEU VAL LEU          
SEQRES   2 A  123  SER GLY THR VAL CYS ARG ALA PRO LEU ARG LYS VAL SER          
SEQRES   3 A  123  PRO SER GLY ILE PRO HIS CYS GLN PHE VAL LEU GLU HIS          
SEQRES   4 A  123  ARG SER VAL GLN GLU GLU ALA GLY PHE HIS ARG GLN ALA          
SEQRES   5 A  123  TRP CYS GLN MET PRO VAL ILE VAL SER GLY HIS GLU ASN          
SEQRES   6 A  123  GLN ALA ILE THR HIS SER ILE THR VAL GLY SER ARG ILE          
SEQRES   7 A  123  THR VAL GLN GLY PHE ILE SER CYS HIS LYS ALA LYS ASN          
SEQRES   8 A  123  GLY LEU SER LYS MET VAL LEU HIS ALA GLU GLN ILE GLU          
SEQRES   9 A  123  LEU ILE ASP SER VAL ASP LYS LEU ALA ALA ALA LEU GLU          
SEQRES  10 A  123  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 B  123  MET ASP PRO ASN SER LEU MET THR ASN ARG LEU VAL LEU          
SEQRES   2 B  123  SER GLY THR VAL CYS ARG ALA PRO LEU ARG LYS VAL SER          
SEQRES   3 B  123  PRO SER GLY ILE PRO HIS CYS GLN PHE VAL LEU GLU HIS          
SEQRES   4 B  123  ARG SER VAL GLN GLU GLU ALA GLY PHE HIS ARG GLN ALA          
SEQRES   5 B  123  TRP CYS GLN MET PRO VAL ILE VAL SER GLY HIS GLU ASN          
SEQRES   6 B  123  GLN ALA ILE THR HIS SER ILE THR VAL GLY SER ARG ILE          
SEQRES   7 B  123  THR VAL GLN GLY PHE ILE SER CYS HIS LYS ALA LYS ASN          
SEQRES   8 B  123  GLY LEU SER LYS MET VAL LEU HIS ALA GLU GLN ILE GLU          
SEQRES   9 B  123  LEU ILE ASP SER VAL ASP LYS LEU ALA ALA ALA LEU GLU          
SEQRES  10 B  123  HIS HIS HIS HIS HIS HIS                                      
FORMUL   4  HOH   *119(H2 O)                                                    
CRYST1   45.537   51.148   99.096  90.00  90.00  90.00 P 21 21 21    8          
ATOM    299  N   MET A  -6      36.610  28.636  16.465  1.00 51.61           N  
ATOM    300  CA  MET A  -6      35.258  28.543  17.100  1.00 52.72           C  
ATOM    301  C   MET A  -6      34.271  27.793  16.202  1.00 52.91           C  
ATOM    302  O   MET A  -6      33.407  28.415  15.575  1.00 53.71           O  
ATOM    303  CB  MET A  -6      34.717  29.951  17.407  1.00 52.59           C  
ATOM    304  N   ASP A  -5      34.390  26.469  16.139  1.00 52.56           N  
ATOM    305  CA  ASP A  -5      33.487  25.694  15.300  1.00 52.71           C  
ATOM    306  C   ASP A  -5      32.543  24.766  16.072  1.00 52.58           C  
ATOM    307  O   ASP A  -5      31.321  24.937  16.003  1.00 53.63           O  
ATOM    308  CB  ASP A  -5      34.287  24.910  14.243  1.00 53.33           C  
ATOM    309  N   PRO A  -4      33.078  23.777  16.824  1.00 51.74           N  
ATOM    310  CA  PRO A  -4      32.177  22.883  17.566  1.00 51.05           C  
ATOM    311  C   PRO A  -4      31.338  23.606  18.638  1.00 51.03           C  
ATOM    312  O   PRO A  -4      30.186  23.224  18.868  1.00 51.22           O  
ATOM    313  CB  PRO A  -4      33.129  21.840  18.161  1.00 50.41           C  
ATOM    314  CG  PRO A  -4      34.264  21.836  17.204  1.00 49.93           C  
ATOM    315  CD  PRO A  -4      34.465  23.303  16.947  1.00 50.67           C  
ATOM    316  N   ASN A  -3      31.907  24.632  19.292  1.00 50.08           N  
ATOM    317  CA  ASN A  -3      31.150  25.393  20.296  1.00 47.92           C  
ATOM    318  C   ASN A  -3      30.081  26.127  19.516  1.00 45.48           C  
ATOM    319  O   ASN A  -3      29.953  27.334  19.605  1.00 44.13           O  
ATOM    320  CB  ASN A  -3      32.002  26.435  21.032  1.00 48.92           C  
ATOM    321  CG  ASN A  -3      33.402  26.559  20.472  1.00 49.19           C  
ATOM    322  OD1 ASN A  -3      34.308  25.830  20.877  1.00 48.50           O  
ATOM    323  ND2 ASN A  -3      33.590  27.485  19.528  1.00 49.62           N  
ATOM    324  N   SER A  -2      29.322  25.374  18.740  1.00 43.73           N  
ATOM    325  CA  SER A  -2      28.266  25.916  17.918  1.00 42.24           C  
ATOM    326  C   SER A  -2      27.015  25.314  18.490  1.00 40.54           C  
ATOM    327  O   SER A  -2      25.928  25.438  17.907  1.00 41.79           O  
ATOM    328  CB  SER A  -2      28.499  25.478  16.471  1.00 42.44           C  
ATOM    329  OG  SER A  -2      27.525  26.026  15.599  1.00 45.19           O  
ATOM    330  N   LEU A  -1      27.218  24.648  19.640  1.00 38.88           N  
ATOM    331  CA  LEU A  -1      26.172  23.933  20.404  1.00 36.75           C  
ATOM    332  C   LEU A  -1      26.738  23.413  21.737  1.00 36.04           C  
ATOM    333  O   LEU A  -1      26.366  22.327  22.185  1.00 33.87           O  
ATOM    334  CB  LEU A  -1      25.639  22.727  19.586  1.00 35.70           C  
ATOM    335  N   MET A   1      27.634  24.180  22.351  1.00 35.88           N  
ATOM    336  CA  MET A   1      28.262  23.785  23.610  1.00 37.60           C  
ATOM    337  C   MET A   1      27.947  24.704  24.767  1.00 37.77           C  
ATOM    338  O   MET A   1      28.745  24.873  25.684  1.00 37.24           O  
ATOM    339  CB  MET A   1      29.763  23.766  23.436  1.00 39.42           C  
ATOM    340  CG  MET A   1      30.267  22.680  22.542  1.00 43.14           C  
ATOM    341  SD  MET A   1      32.068  22.696  22.510  1.00 45.03           S  
ATOM    342  CE  MET A   1      32.415  20.966  22.171  1.00 43.45           C  
ATOM    343  N   THR A   2      26.790  25.334  24.687  1.00 36.93           N  
ATOM    344  CA  THR A   2      26.374  26.268  25.694  1.00 35.21           C  
ATOM    345  C   THR A   2      25.529  25.599  26.741  1.00 35.98           C  
ATOM    346  O   THR A   2      24.457  25.048  26.462  1.00 36.50           O  
ATOM    347  CB  THR A   2      25.573  27.424  25.075  1.00 34.48           C  
ATOM    348  OG1 THR A   2      24.549  27.848  25.983  1.00 33.52           O  
ATOM    349  CG2 THR A   2      24.938  26.980  23.775  1.00 33.80           C  
ATOM    350  N   ASN A   3      26.027  25.612  27.961  1.00 35.18           N  
ATOM    351  CA  ASN A   3      25.235  25.059  29.013  1.00 35.11           C  
ATOM    352  C   ASN A   3      25.783  25.561  30.333  1.00 34.08           C  
ATOM    353  O   ASN A   3      26.933  25.306  30.699  1.00 34.60           O  
ATOM    354  CB  ASN A   3      25.179  23.540  28.892  1.00 35.03           C  
ATOM    355  CG  ASN A   3      26.252  22.866  29.653  1.00 33.63           C  
ATOM    356  OD1 ASN A   3      27.375  22.762  29.189  1.00 35.76           O  
ATOM    357  ND2 ASN A   3      25.920  22.397  30.844  1.00 31.81           N  
ATOM    358  N   ARG A   4      24.939  26.351  30.991  1.00 32.29           N  
ATOM    359  CA  ARG A   4      25.209  26.972  32.276  1.00 31.59           C  
ATOM    360  C   ARG A   4      24.004  26.695  33.127  1.00 29.37           C  
ATOM    361  O   ARG A   4      22.868  26.818  32.679  1.00 28.10           O  
ATOM    362  CB  ARG A   4      25.310  28.491  32.156  1.00 35.53           C  
ATOM    363  CG  ARG A   4      26.596  29.125  32.653  1.00 40.72           C  
ATOM    364  CD  ARG A   4      27.666  29.084  31.576  1.00 44.68           C  
ATOM    365  NE  ARG A   4      28.270  27.759  31.418  1.00 48.95           N  
ATOM    366  CZ  ARG A   4      28.718  27.272  30.256  1.00 51.01           C  
ATOM    367  NH1 ARG A   4      28.612  27.995  29.147  1.00 50.68           N  
ATOM    368  NH2 ARG A   4      29.306  26.078  30.199  1.00 50.21           N  
ATOM    369  N   LEU A   5      24.238  26.343  34.372  1.00 28.07           N  
ATOM    370  CA  LEU A   5      23.135  26.095  35.272  1.00 25.18           C  
ATOM    371  C   LEU A   5      23.450  27.023  36.410  1.00 24.00           C  
ATOM    372  O   LEU A   5      24.615  27.203  36.768  1.00 22.36           O  
ATOM    373  CB  LEU A   5      23.140  24.642  35.757  1.00 26.07           C  
ATOM    374  CG  LEU A   5      22.001  24.156  36.680  1.00 26.97           C  
ATOM    375  CD1 LEU A   5      22.460  24.059  38.133  1.00 28.26           C  
ATOM    376  CD2 LEU A   5      20.803  25.093  36.578  1.00 26.76           C  
ATOM    377  N   VAL A   6      22.431  27.687  36.919  1.00 22.09           N  
ATOM    378  CA  VAL A   6      22.627  28.548  38.072  1.00 20.18           C  
ATOM    379  C   VAL A   6      21.580  28.048  39.034  1.00 18.46           C  
ATOM    380  O   VAL A   6      20.379  28.145  38.759  1.00 17.88           O  
ATOM    381  CB  VAL A   6      22.365  30.035  37.794  1.00 20.89           C  
ATOM    382  CG1 VAL A   6      22.279  30.800  39.144  1.00 19.75           C  
ATOM    383  CG2 VAL A   6      23.480  30.606  36.902  1.00 18.28           C  
ATOM    384  N   LEU A   7      22.029  27.469  40.136  1.00 17.60           N  
ATOM    385  CA  LEU A   7      21.092  26.979  41.134  1.00 18.27           C  
ATOM    386  C   LEU A   7      21.503  27.508  42.535  1.00 19.43           C  
ATOM    387  O   LEU A   7      22.678  27.487  42.922  1.00 19.90           O  
ATOM    388  CB  LEU A   7      21.075  25.450  41.095  1.00 13.23           C  
ATOM    389  CG  LEU A   7      19.964  24.639  41.760  1.00 15.03           C  
ATOM    390  CD1 LEU A   7      18.657  24.865  41.050  1.00  9.32           C  
ATOM    391  CD2 LEU A   7      20.280  23.160  41.729  1.00 16.25           C  
ATOM    392  N   SER A   8      20.540  28.060  43.256  1.00 20.60           N  
ATOM    393  CA  SER A   8      20.773  28.559  44.602  1.00 22.97           C  
ATOM    394  C   SER A   8      20.112  27.441  45.391  1.00 23.97           C  
ATOM    395  O   SER A   8      19.253  26.759  44.853  1.00 24.38           O  
ATOM    396  CB  SER A   8      20.022  29.880  44.861  1.00 22.72           C  
ATOM    397  OG  SER A   8      20.767  31.033  44.494  1.00 21.91           O  
ATOM    398  N   GLY A   9      20.510  27.243  46.639  1.00 25.08           N  
ATOM    399  CA  GLY A   9      19.925  26.194  47.452  1.00 27.04           C  
ATOM    400  C   GLY A   9      20.694  26.000  48.742  1.00 27.97           C  
ATOM    401  O   GLY A   9      21.731  26.643  48.972  1.00 28.58           O  
ATOM    402  N   THR A  10      20.176  25.132  49.603  1.00 27.65           N  
ATOM    403  CA  THR A  10      20.833  24.874  50.880  1.00 28.43           C  
ATOM    404  C   THR A  10      21.591  23.566  50.754  1.00 28.73           C  
ATOM    405  O   THR A  10      21.042  22.591  50.274  1.00 31.84           O  
ATOM    406  CB  THR A  10      19.803  24.754  52.060  1.00 27.94           C  
ATOM    407  OG1 THR A  10      19.068  23.531  51.948  1.00 27.69           O  
ATOM    408  CG2 THR A  10      18.816  25.919  52.034  1.00 27.69           C  
ATOM    409  N   VAL A  11      22.853  23.517  51.147  1.00 27.76           N  
ATOM    410  CA  VAL A  11      23.557  22.241  51.036  1.00 29.51           C  
ATOM    411  C   VAL A  11      23.081  21.254  52.121  1.00 30.86           C  
ATOM    412  O   VAL A  11      23.030  21.588  53.299  1.00 31.00           O  
ATOM    413  CB  VAL A  11      25.072  22.444  51.132  1.00 28.93           C  
ATOM    414  CG1 VAL A  11      25.378  23.925  51.398  1.00 28.45           C  
ATOM    415  CG2 VAL A  11      25.652  21.543  52.201  1.00 27.20           C  
ATOM    416  N   CYS A  12      22.725  20.040  51.716  1.00 33.21           N  
ATOM    417  CA  CYS A  12      22.241  19.044  52.667  1.00 35.47           C  
ATOM    418  C   CYS A  12      23.220  17.910  52.970  1.00 35.68           C  
ATOM    419  O   CYS A  12      23.008  17.117  53.902  1.00 35.53           O  
ATOM    420  CB  CYS A  12      20.921  18.473  52.166  1.00 37.85           C  
ATOM    421  SG  CYS A  12      20.847  18.366  50.371  1.00 41.84           S  
ATOM    422  N   ARG A  13      24.270  17.826  52.155  1.00 35.45           N  
ATOM    423  CA  ARG A  13      25.308  16.819  52.325  1.00 35.51           C  
ATOM    424  C   ARG A  13      26.626  17.601  52.352  1.00 36.07           C  
ATOM    425  O   ARG A  13      26.974  18.291  51.388  1.00 35.67           O  
ATOM    426  CB  ARG A  13      25.306  15.828  51.164  1.00 35.02           C  
ATOM    427  CG  ARG A  13      25.678  14.377  51.525  1.00 33.78           C  
ATOM    428  CD  ARG A  13      24.410  13.511  51.482  1.00 33.19           C  
ATOM    429  NE  ARG A  13      24.667  12.073  51.493  1.00 33.62           N  
ATOM    430  CZ  ARG A  13      23.874  11.156  50.935  1.00 33.97           C  
ATOM    431  NH1 ARG A  13      24.190   9.871  51.009  1.00 34.87           N  
ATOM    432  NH2 ARG A  13      22.776  11.516  50.283  1.00 32.62           N  
ATOM    433  N   ALA A  14      27.316  17.515  53.488  1.00 36.28           N  
ATOM    434  CA  ALA A  14      28.582  18.181  53.738  1.00 35.44           C  
ATOM    435  C   ALA A  14      29.658  17.882  52.697  1.00 35.46           C  
ATOM    436  O   ALA A  14      29.652  16.838  52.047  1.00 36.13           O  
ATOM    437  CB  ALA A  14      29.077  17.792  55.110  1.00 35.69           C  
ATOM    438  N   PRO A  15      30.621  18.792  52.550  1.00 35.10           N  
ATOM    439  CA  PRO A  15      31.701  18.615  51.583  1.00 34.80           C  
ATOM    440  C   PRO A  15      32.628  17.442  51.821  1.00 35.59           C  
ATOM    441  O   PRO A  15      33.403  17.448  52.768  1.00 35.20           O  
ATOM    442  CB  PRO A  15      32.446  19.948  51.641  1.00 34.89           C  
ATOM    443  CG  PRO A  15      32.132  20.480  52.990  1.00 35.95           C  
ATOM    444  CD  PRO A  15      30.680  20.131  53.158  1.00 34.89           C  
ATOM    445  N   LEU A  16      32.544  16.443  50.941  1.00 36.99           N  
ATOM    446  CA  LEU A  16      33.382  15.242  50.984  1.00 36.87           C  
ATOM    447  C   LEU A  16      34.622  15.535  50.129  1.00 37.13           C  
ATOM    448  O   LEU A  16      34.572  15.460  48.893  1.00 36.57           O  
ATOM    449  CB  LEU A  16      32.620  14.045  50.400  1.00 36.02           C  
ATOM    450  N   ARG A  17      35.736  15.888  50.762  1.00 38.02           N  
ATOM    451  CA  ARG A  17      36.932  16.184  49.979  1.00 40.02           C  
ATOM    452  C   ARG A  17      37.778  14.966  49.623  1.00 39.91           C  
ATOM    453  O   ARG A  17      37.826  13.991  50.361  1.00 40.32           O  
ATOM    454  CB  ARG A  17      37.779  17.238  50.706  1.00 42.10           C  
ATOM    455  CG  ARG A  17      37.091  18.604  50.803  1.00 44.25           C  
ATOM    456  CD  ARG A  17      37.910  19.590  51.610  1.00 46.17           C  
ATOM    457  NE  ARG A  17      37.201  20.854  51.824  1.00 48.76           N  
ATOM    458  CZ  ARG A  17      36.069  20.976  52.516  1.00 49.25           C  
ATOM    459  NH1 ARG A  17      35.498  19.909  53.080  1.00 49.42           N  
ATOM    460  NH2 ARG A  17      35.501  22.170  52.633  1.00 49.95           N  
ATOM    461  N   LYS A  18      38.411  15.014  48.459  1.00 40.80           N  
ATOM    462  CA  LYS A  18      39.274  13.934  48.015  1.00 40.89           C  
ATOM    463  C   LYS A  18      40.243  14.537  47.031  1.00 41.13           C  
ATOM    464  O   LYS A  18      40.037  15.662  46.572  1.00 41.56           O  
ATOM    465  CB  LYS A  18      38.471  12.817  47.358  1.00 41.49           C  
ATOM    466  CG  LYS A  18      39.056  11.436  47.670  1.00 43.23           C  
ATOM    467  CD  LYS A  18      38.204  10.273  47.166  1.00 41.93           C  
ATOM    468  CE  LYS A  18      38.410   9.026  48.031  1.00 40.91           C  
ATOM    469  NZ  LYS A  18      37.667   9.067  49.340  1.00 38.40           N  
ATOM    470  N   VAL A  19      41.311  13.814  46.721  1.00 41.75           N  
ATOM    471  CA  VAL A  19      42.299  14.325  45.772  1.00 42.95           C  
ATOM    472  C   VAL A  19      42.705  13.276  44.750  1.00 43.86           C  
ATOM    473  O   VAL A  19      43.278  12.244  45.096  1.00 44.57           O  
ATOM    474  CB  VAL A  19      43.558  14.823  46.500  1.00 42.93           C  
ATOM    475  CG1 VAL A  19      44.592  15.294  45.504  1.00 41.90           C  
ATOM    476  CG2 VAL A  19      43.177  15.939  47.433  1.00 44.10           C  
ATOM    477  N   SER A  20      42.419  13.539  43.485  1.00 44.08           N  
ATOM    478  CA  SER A  20      42.775  12.576  42.469  1.00 44.00           C  
ATOM    479  C   SER A  20      44.231  12.630  42.030  1.00 44.71           C  
ATOM    480  O   SER A  20      44.824  13.695  41.835  1.00 42.04           O  
ATOM    481  CB  SER A  20      41.879  12.721  41.277  1.00 44.23           C  
ATOM    482  N   PRO A  21      44.820  11.442  41.871  1.00 45.99           N  
ATOM    483  CA  PRO A  21      46.177  11.118  41.462  1.00 47.86           C  
ATOM    484  C   PRO A  21      47.030  12.280  40.995  1.00 49.22           C  
ATOM    485  O   PRO A  21      48.177  12.419  41.409  1.00 50.06           O  
ATOM    486  CB  PRO A  21      45.933  10.097  40.356  1.00 47.43           C  
ATOM    487  CG  PRO A  21      44.790   9.276  40.936  1.00 46.74           C  
ATOM    488  CD  PRO A  21      44.000  10.215  41.853  1.00 46.74           C  
ATOM    489  N   SER A  22      46.465  13.114  40.137  1.00 50.25           N  
ATOM    490  CA  SER A  22      47.209  14.226  39.584  1.00 51.53           C  
ATOM    491  C   SER A  22      47.378  15.323  40.606  1.00 51.55           C  
ATOM    492  O   SER A  22      47.906  16.389  40.298  1.00 51.83           O  
ATOM    493  CB  SER A  22      46.503  14.738  38.328  1.00 53.26           C  
ATOM    494  OG  SER A  22      46.064  13.642  37.532  1.00 52.05           O  
ATOM    495  N   GLY A  23      46.942  15.054  41.831  1.00 51.23           N  
ATOM    496  CA  GLY A  23      47.094  16.038  42.889  1.00 50.99           C  
ATOM    497  C   GLY A  23      46.028  17.117  42.927  1.00 50.94           C  
ATOM    498  O   GLY A  23      46.173  18.108  43.636  1.00 50.53           O  
ATOM    499  N   ILE A  24      44.962  16.933  42.154  1.00 50.86           N  
ATOM    500  CA  ILE A  24      43.873  17.908  42.114  1.00 48.93           C  
ATOM    501  C   ILE A  24      42.899  17.664  43.264  1.00 48.02           C  
ATOM    502  O   ILE A  24      42.501  16.526  43.513  1.00 47.60           O  
ATOM    503  CB  ILE A  24      42.998  17.808  40.833  1.00 49.10           C  
ATOM    504  CG1 ILE A  24      43.815  18.099  39.570  1.00 50.62           C  
ATOM    505  CG2 ILE A  24      41.791  18.760  41.000  1.00 49.00           C  
ATOM    506  CD1 ILE A  24      44.450  19.504  39.457  1.00 52.78           C  
ATOM    507  N   PRO A  25      42.457  18.726  43.956  1.00 47.28           N  
ATOM    508  CA  PRO A  25      41.525  18.470  45.054  1.00 46.46           C  
ATOM    509  C   PRO A  25      40.088  18.708  44.654  1.00 46.37           C  
ATOM    510  O   PRO A  25      39.813  19.700  43.978  1.00 47.59           O  
ATOM    511  CB  PRO A  25      41.941  19.504  46.081  1.00 45.47           C  
ATOM    512  CG  PRO A  25      42.129  20.690  45.238  1.00 45.51           C  
ATOM    513  CD  PRO A  25      42.967  20.106  44.064  1.00 46.14           C  
ATOM    514  N   HIS A  26      39.172  17.821  45.043  1.00 44.78           N  
ATOM    515  CA  HIS A  26      37.753  18.065  44.775  1.00 43.71           C  
ATOM    516  C   HIS A  26      36.875  17.829  45.996  1.00 42.30           C  
ATOM    517  O   HIS A  26      37.184  17.042  46.888  1.00 41.69           O  
ATOM    518  CB  HIS A  26      37.221  17.275  43.573  1.00 45.18           C  
ATOM    519  CG  HIS A  26      37.967  16.023  43.300  1.00 46.83           C  
ATOM    520  ND1 HIS A  26      37.982  15.432  42.058  1.00 48.10           N  
ATOM    521  CD2 HIS A  26      38.753  15.259  44.092  1.00 48.21           C  
ATOM    522  CE1 HIS A  26      38.751  14.360  42.095  1.00 48.58           C  
ATOM    523  NE2 HIS A  26      39.232  14.231  43.319  1.00 48.25           N  
ATOM    524  N   CYS A  27      35.749  18.510  46.000  1.00 40.87           N  
ATOM    525  CA  CYS A  27      34.851  18.436  47.106  1.00 40.55           C  
ATOM    526  C   CYS A  27      33.378  18.386  46.673  1.00 38.62           C  
ATOM    527  O   CYS A  27      32.882  19.303  46.038  1.00 41.02           O  
ATOM    528  CB  CYS A  27      35.195  19.638  47.997  1.00 42.28           C  
ATOM    529  SG  CYS A  27      33.854  20.599  48.681  1.00 46.48           S  
ATOM    530  N   GLN A  28      32.675  17.308  47.003  1.00 36.72           N  
ATOM    531  CA  GLN A  28      31.271  17.175  46.622  1.00 36.28           C  
ATOM    532  C   GLN A  28      30.338  17.527  47.751  1.00 36.22           C  
ATOM    533  O   GLN A  28      30.777  17.749  48.872  1.00 37.06           O  
ATOM    534  CB  GLN A  28      30.944  15.733  46.220  1.00 37.25           C  
ATOM    535  CG  GLN A  28      29.440  15.470  45.998  1.00 39.27           C  
ATOM    536  CD  GLN A  28      29.122  14.025  45.639  1.00 40.51           C  
ATOM    537  OE1 GLN A  28      29.982  13.150  45.768  1.00 43.41           O  
ATOM    538  NE2 GLN A  28      27.882  13.763  45.201  1.00 37.20           N  
ATOM    539  N   PHE A  29      29.048  17.575  47.434  1.00 34.74           N  
ATOM    540  CA  PHE A  29      27.969  17.818  48.382  1.00 32.41           C  
ATOM    541  C   PHE A  29      26.659  17.829  47.616  1.00 33.28           C  
ATOM    542  O   PHE A  29      26.657  17.900  46.373  1.00 33.05           O  
ATOM    543  CB  PHE A  29      28.166  19.110  49.211  1.00 30.10           C  
ATOM    544  CG  PHE A  29      28.200  20.391  48.419  1.00 28.96           C  
ATOM    545  CD1 PHE A  29      29.405  20.905  47.929  1.00 29.36           C  
ATOM    546  CD2 PHE A  29      27.045  21.154  48.275  1.00 27.61           C  
ATOM    547  CE1 PHE A  29      29.449  22.172  47.313  1.00 26.73           C  
ATOM    548  CE2 PHE A  29      27.078  22.404  47.665  1.00 25.65           C  
ATOM    549  CZ  PHE A  29      28.279  22.918  47.190  1.00 24.02           C  
ATOM    550  N   VAL A  30      25.547  17.723  48.334  1.00 32.08           N  
ATOM    551  CA  VAL A  30      24.256  17.706  47.667  1.00 31.53           C  
ATOM    552  C   VAL A  30      23.457  18.940  48.038  1.00 32.78           C  
ATOM    553  O   VAL A  30      23.038  19.075  49.168  1.00 34.03           O  
ATOM    554  CB  VAL A  30      23.427  16.464  48.040  1.00 30.36           C  
ATOM    555  CG1 VAL A  30      22.189  16.396  47.145  1.00 29.94           C  
ATOM    556  CG2 VAL A  30      24.279  15.201  47.928  1.00 27.87           C  
ATOM    557  N   LEU A  31      23.235  19.832  47.073  1.00 32.12           N  
ATOM    558  CA  LEU A  31      22.500  21.084  47.293  1.00 28.60           C  
ATOM    559  C   LEU A  31      21.029  20.804  47.189  1.00 26.76           C  
ATOM    560  O   LEU A  31      20.620  20.098  46.291  1.00 28.01           O  
ATOM    561  CB  LEU A  31      22.888  22.092  46.219  1.00 28.35           C  
ATOM    562  CG  LEU A  31      22.330  23.517  46.165  1.00 29.31           C  
ATOM    563  CD1 LEU A  31      23.159  24.461  47.085  1.00 27.02           C  
ATOM    564  CD2 LEU A  31      22.392  24.014  44.691  1.00 28.54           C  
ATOM    565  N   GLU A  32      20.227  21.300  48.120  1.00 25.00           N  
ATOM    566  CA  GLU A  32      18.790  21.080  48.002  1.00 23.59           C  
ATOM    567  C   GLU A  32      18.205  22.418  47.584  1.00 25.68           C  
ATOM    568  O   GLU A  32      18.365  23.449  48.268  1.00 27.57           O  
ATOM    569  CB  GLU A  32      18.133  20.609  49.305  1.00 20.97           C  
ATOM    570  CG  GLU A  32      16.711  20.008  49.113  1.00 19.58           C  
ATOM    571  CD  GLU A  32      15.964  19.818  50.443  1.00 18.47           C  
ATOM    572  OE1 GLU A  32      15.138  18.883  50.550  1.00 16.94           O  
ATOM    573  OE2 GLU A  32      16.195  20.621  51.381  1.00 21.55           O  
ATOM    574  N   HIS A  33      17.577  22.417  46.419  1.00 23.80           N  
ATOM    575  CA  HIS A  33      16.997  23.626  45.922  1.00 22.75           C  
ATOM    576  C   HIS A  33      15.497  23.463  46.048  1.00 23.47           C  
ATOM    577  O   HIS A  33      14.972  22.371  45.861  1.00 25.28           O  
ATOM    578  CB  HIS A  33      17.437  23.854  44.466  1.00 21.76           C  
ATOM    579  CG  HIS A  33      16.641  24.912  43.758  1.00 22.21           C  
ATOM    580  ND1 HIS A  33      15.324  24.711  43.403  1.00 19.05           N  
ATOM    581  CD2 HIS A  33      16.910  26.216  43.499  1.00 21.32           C  
ATOM    582  CE1 HIS A  33      14.805  25.848  42.978  1.00 20.60           C  
ATOM    583  NE2 HIS A  33      15.742  26.776  43.029  1.00 21.39           N  
ATOM    584  N   ARG A  34      14.804  24.540  46.394  1.00 23.48           N  
ATOM    585  CA  ARG A  34      13.355  24.503  46.539  1.00 23.81           C  
ATOM    586  C   ARG A  34      12.930  25.906  46.207  1.00 23.75           C  
ATOM    587  O   ARG A  34      13.548  26.863  46.654  1.00 25.50           O  
ATOM    588  CB  ARG A  34      12.975  24.174  47.983  1.00 26.95           C  
ATOM    589  CG  ARG A  34      11.928  23.055  48.150  1.00 29.25           C  
ATOM    590  CD  ARG A  34      10.606  23.491  47.535  1.00 31.57           C  
ATOM    591  NE  ARG A  34       9.664  22.408  47.281  1.00 31.41           N  
ATOM    592  CZ  ARG A  34       8.379  22.628  47.044  1.00 31.98           C  
ATOM    593  NH1 ARG A  34       7.551  21.612  46.813  1.00 29.02           N  
ATOM    594  NH2 ARG A  34       7.926  23.879  47.046  1.00 30.85           N  
ATOM    595  N   SER A  35      11.902  26.034  45.385  1.00 23.38           N  
ATOM    596  CA  SER A  35      11.414  27.351  44.991  1.00 22.95           C  
ATOM    597  C   SER A  35      10.035  27.277  44.377  1.00 22.87           C  
ATOM    598  O   SER A  35       9.529  26.196  44.085  1.00 24.01           O  
ATOM    599  CB  SER A  35      12.355  27.992  43.957  1.00 21.67           C  
ATOM    600  OG  SER A  35      12.404  27.267  42.729  1.00 15.71           O  
ATOM    601  N   VAL A  36       9.429  28.443  44.202  1.00 21.95           N  
ATOM    602  CA  VAL A  36       8.123  28.571  43.579  1.00 21.27           C  
ATOM    603  C   VAL A  36       8.571  29.034  42.212  1.00 20.80           C  
ATOM    604  O   VAL A  36       9.432  29.914  42.139  1.00 18.31           O  
ATOM    605  CB  VAL A  36       7.299  29.699  44.226  1.00 21.03           C  
ATOM    606  CG1 VAL A  36       6.243  29.136  45.144  1.00 23.29           C  
ATOM    607  CG2 VAL A  36       8.209  30.584  45.014  1.00 22.69           C  
ATOM    608  N   GLN A  37       8.047  28.412  41.150  1.00 20.42           N  
ATOM    609  CA  GLN A  37       8.373  28.789  39.764  1.00 21.48           C  
ATOM    610  C   GLN A  37       7.085  28.993  38.988  1.00 22.71           C  
ATOM    611  O   GLN A  37       6.133  28.234  39.174  1.00 22.27           O  
ATOM    612  CB  GLN A  37       9.199  27.704  39.076  1.00 20.23           C  
ATOM    613  CG  GLN A  37      10.649  27.571  39.611  1.00 16.79           C  
ATOM    614  CD  GLN A  37      11.392  28.885  39.586  1.00 15.62           C  
ATOM    615  OE1 GLN A  37      12.529  28.973  40.016  1.00 17.84           O  
ATOM    616  NE2 GLN A  37      10.747  29.908  39.081  1.00 17.21           N  
ATOM    617  N   GLU A  38       7.029  30.030  38.146  1.00 24.41           N  
ATOM    618  CA  GLU A  38       5.815  30.271  37.345  1.00 25.76           C  
ATOM    619  C   GLU A  38       5.940  29.659  35.935  1.00 24.11           C  
ATOM    620  O   GLU A  38       6.934  29.847  35.234  1.00 23.42           O  
ATOM    621  CB  GLU A  38       5.488  31.767  37.231  1.00 26.58           C  
ATOM    622  CG  GLU A  38       6.429  32.527  36.324  1.00 30.78           C  
ATOM    623  CD  GLU A  38       5.725  33.194  35.163  1.00 33.20           C  
ATOM    624  OE1 GLU A  38       5.831  32.713  34.016  1.00 33.02           O  
ATOM    625  OE2 GLU A  38       5.057  34.214  35.400  1.00 37.63           O  
ATOM    626  N   GLU A  39       4.910  28.928  35.540  1.00 24.15           N  
ATOM    627  CA  GLU A  39       4.863  28.235  34.257  1.00 25.37           C  
ATOM    628  C   GLU A  39       3.445  28.309  33.690  1.00 24.40           C  
ATOM    629  O   GLU A  39       2.494  27.893  34.350  1.00 24.12           O  
ATOM    630  CB  GLU A  39       5.201  26.763  34.487  1.00 26.41           C  
ATOM    631  CG  GLU A  39       6.372  26.222  33.712  1.00 30.07           C  
ATOM    632  CD  GLU A  39       6.048  24.854  33.139  1.00 31.70           C  
ATOM    633  OE1 GLU A  39       5.798  23.934  33.947  1.00 33.89           O  
ATOM    634  OE2 GLU A  39       6.016  24.701  31.891  1.00 31.16           O  
ATOM    635  N   ALA A  40       3.274  28.822  32.482  1.00 22.70           N  
ATOM    636  CA  ALA A  40       1.920  28.857  31.944  1.00 23.24           C  
ATOM    637  C   ALA A  40       1.039  29.878  32.660  1.00 22.34           C  
ATOM    638  O   ALA A  40      -0.187  29.695  32.762  1.00 21.72           O  
ATOM    639  CB  ALA A  40       1.295  27.465  32.036  1.00 21.98           C  
ATOM    640  N   GLY A  41       1.678  30.955  33.134  1.00 22.71           N  
ATOM    641  CA  GLY A  41       0.998  32.044  33.826  1.00 23.98           C  
ATOM    642  C   GLY A  41       0.553  31.643  35.213  1.00 24.49           C  
ATOM    643  O   GLY A  41      -0.245  32.319  35.847  1.00 26.40           O  
ATOM    644  N   PHE A  42       1.045  30.508  35.669  1.00 24.26           N  
ATOM    645  CA  PHE A  42       0.689  30.026  36.976  1.00 24.04           C  
ATOM    646  C   PHE A  42       1.961  29.645  37.679  1.00 23.66           C  
ATOM    647  O   PHE A  42       3.033  29.768  37.100  1.00 24.13           O  
ATOM    648  CB  PHE A  42      -0.216  28.828  36.850  1.00 26.24           C  
ATOM    649  CG  PHE A  42      -1.640  29.180  36.610  1.00 26.94           C  
ATOM    650  CD1 PHE A  42      -2.507  29.347  37.685  1.00 27.35           C  
ATOM    651  CD2 PHE A  42      -2.130  29.295  35.320  1.00 28.26           C  
ATOM    652  CE1 PHE A  42      -3.853  29.612  37.485  1.00 28.38           C  
ATOM    653  CE2 PHE A  42      -3.480  29.562  35.099  1.00 29.25           C  
ATOM    654  CZ  PHE A  42      -4.351  29.720  36.190  1.00 28.96           C  
ATOM    655  N   HIS A  43       1.845  29.181  38.920  1.00 22.63           N  
ATOM    656  CA  HIS A  43       3.008  28.813  39.735  1.00 22.82           C  
ATOM    657  C   HIS A  43       2.968  27.382  40.244  1.00 24.09           C  
ATOM    658  O   HIS A  43       1.903  26.791  40.485  1.00 24.42           O  
ATOM    659  CB  HIS A  43       3.146  29.764  40.933  1.00 21.90           C  
ATOM    660  CG  HIS A  43       3.380  31.192  40.553  1.00 18.53           C  
ATOM    661  ND1 HIS A  43       2.373  32.025  40.102  1.00 15.73           N  
ATOM    662  CD2 HIS A  43       4.507  31.940  40.587  1.00 16.63           C  
ATOM    663  CE1 HIS A  43       2.874  33.227  39.884  1.00 17.97           C  
ATOM    664  NE2 HIS A  43       4.167  33.203  40.169  1.00 18.14           N  
ATOM    665  N   ARG A  44       4.155  26.840  40.441  1.00 25.62           N  
ATOM    666  CA  ARG A  44       4.281  25.466  40.875  1.00 27.66           C  
ATOM    667  C   ARG A  44       5.618  25.375  41.565  1.00 27.41           C  
ATOM    668  O   ARG A  44       6.534  26.145  41.268  1.00 27.40           O  
ATOM    669  CB  ARG A  44       4.314  24.576  39.650  1.00 31.65           C  
ATOM    670  CG  ARG A  44       5.411  25.066  38.707  1.00 36.43           C  
ATOM    671  CD  ARG A  44       5.533  24.293  37.444  1.00 41.10           C  
ATOM    672  NE  ARG A  44       4.244  24.238  36.787  1.00 45.94           N  
ATOM    673  CZ  ARG A  44       3.346  23.283  37.019  1.00 47.52           C  
ATOM    674  NH1 ARG A  44       3.623  22.306  37.890  1.00 44.89           N  
ATOM    675  NH2 ARG A  44       2.170  23.314  36.385  1.00 46.71           N  
ATOM    676  N   GLN A  45       5.748  24.412  42.463  1.00 28.65           N  
ATOM    677  CA  GLN A  45       7.000  24.229  43.195  1.00 27.79           C  
ATOM    678  C   GLN A  45       8.109  23.549  42.394  1.00 26.51           C  
ATOM    679  O   GLN A  45       7.842  22.652  41.596  1.00 25.85           O  
ATOM    680  CB  GLN A  45       6.733  23.446  44.447  1.00 27.67           C  
ATOM    681  N   ALA A  46       9.351  23.975  42.619  1.00 25.83           N  
ATOM    682  CA  ALA A  46      10.517  23.398  41.941  1.00 27.47           C  
ATOM    683  C   ALA A  46      11.513  22.915  42.999  1.00 28.56           C  
ATOM    684  O   ALA A  46      12.259  23.707  43.574  1.00 31.59           O  
ATOM    685  CB  ALA A  46      11.182  24.429  41.004  1.00 25.85           C  
ATOM    686  N   TRP A  47      11.514  21.605  43.246  1.00 30.33           N  
ATOM    687  CA  TRP A  47      12.374  20.977  44.258  1.00 32.20           C  
ATOM    688  C   TRP A  47      13.394  20.020  43.628  1.00 31.94           C  
ATOM    689  O   TRP A  47      13.020  19.114  42.886  1.00 30.58           O  
ATOM    690  CB  TRP A  47      11.496  20.203  45.278  1.00 33.71           C  
ATOM    691  CG  TRP A  47      12.320  19.273  46.141  1.00 35.03           C  
ATOM    692  CD1 TRP A  47      13.072  19.617  47.234  1.00 35.16           C  
ATOM    693  CD2 TRP A  47      12.655  17.910  45.852  1.00 35.75           C  
ATOM    694  NE1 TRP A  47      13.865  18.574  47.619  1.00 35.29           N  
ATOM    695  CE2 TRP A  47      13.629  17.509  46.780  1.00 36.94           C  
ATOM    696  CE3 TRP A  47      12.237  16.987  44.878  1.00 35.03           C  
ATOM    697  CZ2 TRP A  47      14.189  16.225  46.771  1.00 37.00           C  
ATOM    698  CZ3 TRP A  47      12.794  15.713  44.873  1.00 33.87           C  
ATOM    699  CH2 TRP A  47      13.755  15.348  45.800  1.00 34.81           C  
ATOM    700  N   CYS A  48      14.675  20.193  43.945  1.00 32.94           N  
ATOM    701  CA  CYS A  48      15.674  19.320  43.358  1.00 34.22           C  
ATOM    702  C   CYS A  48      16.971  19.169  44.147  1.00 33.49           C  
ATOM    703  O   CYS A  48      17.453  20.130  44.767  1.00 34.68           O  
ATOM    704  CB  CYS A  48      16.004  19.807  41.934  1.00 36.86           C  
ATOM    705  SG  CYS A  48      16.588  18.458  40.851  1.00 43.03           S  
ATOM    706  N   GLN A  49      17.531  17.958  44.142  1.00 32.03           N  
ATOM    707  CA  GLN A  49      18.804  17.728  44.820  1.00 31.47           C  
ATOM    708  C   GLN A  49      19.868  17.620  43.740  1.00 30.22           C  
ATOM    709  O   GLN A  49      19.868  16.736  42.897  1.00 30.99           O  
ATOM    710  CB  GLN A  49      18.758  16.476  45.703  1.00 30.59           C  
ATOM    711  CG  GLN A  49      17.865  16.687  46.926  1.00 31.62           C  
ATOM    712  CD  GLN A  49      17.834  15.500  47.878  1.00 31.85           C  
ATOM    713  OE1 GLN A  49      16.792  14.873  48.073  1.00 31.43           O  
ATOM    714  NE2 GLN A  49      18.980  15.193  48.480  1.00 32.78           N  
ATOM    715  N   MET A  50      20.767  18.574  43.754  1.00 29.29           N  
ATOM    716  CA  MET A  50      21.801  18.618  42.757  1.00 28.80           C  
ATOM    717  C   MET A  50      23.137  18.270  43.363  1.00 29.89           C  
ATOM    718  O   MET A  50      23.662  18.982  44.216  1.00 32.85           O  
ATOM    719  CB  MET A  50      21.831  20.024  42.110  1.00 29.46           C  
ATOM    720  CG  MET A  50      22.758  20.162  40.911  1.00 29.92           C  
ATOM    721  SD  MET A  50      22.506  18.936  39.594  1.00 31.67           S  
ATOM    722  CE  MET A  50      21.026  19.574  38.797  1.00 28.60           C  
ATOM    723  N   PRO A  51      23.707  17.152  42.935  1.00 28.95           N  
ATOM    724  CA  PRO A  51      25.001  16.771  43.481  1.00 27.34           C  
ATOM    725  C   PRO A  51      26.031  17.652  42.833  1.00 25.97           C  
ATOM    726  O   PRO A  51      26.390  17.408  41.720  1.00 27.31           O  
ATOM    727  CB  PRO A  51      25.162  15.315  43.039  1.00 26.79           C  
ATOM    728  CG  PRO A  51      23.759  14.853  42.874  1.00 27.77           C  
ATOM    729  CD  PRO A  51      23.098  16.038  42.207  1.00 29.82           C  
ATOM    730  N   VAL A  52      26.512  18.678  43.504  1.00 25.70           N  
ATOM    731  CA  VAL A  52      27.518  19.495  42.871  1.00 26.84           C  
ATOM    732  C   VAL A  52      28.910  19.090  43.341  1.00 28.43           C  
ATOM    733  O   VAL A  52      29.068  18.400  44.338  1.00 30.17           O  
ATOM    734  CB  VAL A  52      27.260  20.955  43.161  1.00 28.94           C  
ATOM    735  CG1 VAL A  52      25.762  21.233  43.020  1.00 28.68           C  
ATOM    736  CG2 VAL A  52      27.755  21.296  44.537  1.00 29.77           C  
ATOM    737  N   ILE A  53      29.930  19.510  42.616  1.00 30.59           N  
ATOM    738  CA  ILE A  53      31.293  19.154  42.975  1.00 32.39           C  
ATOM    739  C   ILE A  53      32.137  20.292  42.470  1.00 32.04           C  
ATOM    740  O   ILE A  53      31.864  20.832  41.401  1.00 31.62           O  
ATOM    741  CB  ILE A  53      31.726  17.827  42.271  1.00 34.28           C  
ATOM    742  CG1 ILE A  53      33.255  17.610  42.362  1.00 33.18           C  
ATOM    743  CG2 ILE A  53      31.313  17.875  40.814  1.00 34.51           C  
ATOM    744  CD1 ILE A  53      34.202  18.476  41.485  1.00 37.05           C  
ATOM    745  N   VAL A  54      33.150  20.656  43.241  1.00 30.75           N  
ATOM    746  CA  VAL A  54      34.023  21.740  42.864  1.00 33.87           C  
ATOM    747  C   VAL A  54      35.417  21.150  42.813  1.00 35.24           C  
ATOM    748  O   VAL A  54      35.876  20.531  43.756  1.00 35.52           O  
ATOM    749  CB  VAL A  54      33.868  22.896  43.886  1.00 34.60           C  
ATOM    750  CG1 VAL A  54      34.000  22.354  45.288  1.00 35.59           C  
ATOM    751  CG2 VAL A  54      34.872  24.014  43.615  1.00 34.50           C  
ATOM    752  N   SER A  55      36.100  21.336  41.696  1.00 37.23           N  
ATOM    753  CA  SER A  55      37.414  20.745  41.537  1.00 38.80           C  
ATOM    754  C   SER A  55      38.469  21.803  41.267  1.00 39.30           C  
ATOM    755  O   SER A  55      38.123  22.944  40.950  1.00 38.72           O  
ATOM    756  CB  SER A  55      37.341  19.725  40.386  1.00 40.47           C  
ATOM    757  OG  SER A  55      38.594  19.121  40.113  1.00 45.45           O  
ATOM    758  N   GLY A  56      39.747  21.421  41.389  1.00 40.65           N  
ATOM    759  CA  GLY A  56      40.826  22.364  41.142  1.00 41.73           C  
ATOM    760  C   GLY A  56      41.095  23.277  42.323  1.00 43.61           C  
ATOM    761  O   GLY A  56      40.272  23.392  43.244  1.00 43.17           O  
ATOM    762  N   HIS A  57      42.232  23.961  42.281  1.00 44.52           N  
ATOM    763  CA  HIS A  57      42.638  24.843  43.369  1.00 46.70           C  
ATOM    764  C   HIS A  57      41.790  26.085  43.714  1.00 47.89           C  
ATOM    765  O   HIS A  57      41.129  26.112  44.750  1.00 48.77           O  
ATOM    766  CB  HIS A  57      44.111  25.226  43.155  1.00 47.68           C  
ATOM    767  CG  HIS A  57      45.054  24.056  43.273  1.00 48.70           C  
ATOM    768  ND1 HIS A  57      45.094  23.240  44.385  1.00 50.02           N  
ATOM    769  CD2 HIS A  57      46.001  23.572  42.430  1.00 49.57           C  
ATOM    770  CE1 HIS A  57      46.022  22.309  44.229  1.00 49.29           C  
ATOM    771  NE2 HIS A  57      46.590  22.489  43.050  1.00 49.06           N  
ATOM    772  N   GLU A  58      41.792  27.102  42.860  1.00 48.43           N  
ATOM    773  CA  GLU A  58      41.051  28.350  43.127  1.00 49.51           C  
ATOM    774  C   GLU A  58      39.852  28.252  44.064  1.00 47.51           C  
ATOM    775  O   GLU A  58      39.829  28.888  45.119  1.00 47.57           O  
ATOM    776  CB  GLU A  58      40.572  28.992  41.804  1.00 53.53           C  
ATOM    777  CG  GLU A  58      39.977  30.421  41.907  1.00 57.27           C  
ATOM    778  CD  GLU A  58      39.324  30.904  40.576  1.00 61.51           C  
ATOM    779  OE1 GLU A  58      39.206  32.144  40.349  1.00 62.92           O  
ATOM    780  OE2 GLU A  58      38.910  30.036  39.763  1.00 62.95           O  
ATOM    781  N   ASN A  59      38.870  27.440  43.682  1.00 46.26           N  
ATOM    782  CA  ASN A  59      37.629  27.314  44.448  1.00 44.29           C  
ATOM    783  C   ASN A  59      37.552  26.359  45.643  1.00 41.89           C  
ATOM    784  O   ASN A  59      36.469  26.123  46.189  1.00 40.48           O  
ATOM    785  CB  ASN A  59      36.466  27.019  43.475  1.00 45.31           C  
ATOM    786  N   GLN A  60      38.679  25.816  46.078  1.00 39.25           N  
ATOM    787  CA  GLN A  60      38.603  24.903  47.199  1.00 38.27           C  
ATOM    788  C   GLN A  60      38.306  25.682  48.460  1.00 37.67           C  
ATOM    789  O   GLN A  60      37.485  25.272  49.269  1.00 36.78           O  
ATOM    790  CB  GLN A  60      39.900  24.111  47.341  1.00 39.16           C  
ATOM    791  CG  GLN A  60      40.085  23.050  46.272  1.00 37.66           C  
ATOM    792  CD  GLN A  60      38.920  22.089  46.202  1.00 37.70           C  
ATOM    793  OE1 GLN A  60      38.409  21.804  45.118  1.00 40.89           O  
ATOM    794  NE2 GLN A  60      38.495  21.579  47.346  1.00 36.81           N  
ATOM    795  N   ALA A  61      38.949  26.836  48.599  1.00 36.51           N  
ATOM    796  CA  ALA A  61      38.766  27.680  49.770  1.00 34.86           C  
ATOM    797  C   ALA A  61      37.306  27.945  50.074  1.00 34.40           C  
ATOM    798  O   ALA A  61      36.804  27.556  51.115  1.00 34.14           O  
ATOM    799  CB  ALA A  61      39.506  28.975  49.574  1.00 34.81           C  
ATOM    800  N   ILE A  62      36.610  28.605  49.167  1.00 36.02           N  
ATOM    801  CA  ILE A  62      35.201  28.891  49.417  1.00 38.06           C  
ATOM    802  C   ILE A  62      34.402  27.697  50.017  1.00 38.50           C  
ATOM    803  O   ILE A  62      33.456  27.918  50.776  1.00 38.90           O  
ATOM    804  CB  ILE A  62      34.493  29.411  48.115  1.00 39.34           C  
ATOM    805  CG1 ILE A  62      32.996  29.664  48.373  1.00 41.53           C  
ATOM    806  CG2 ILE A  62      34.663  28.416  46.991  1.00 38.00           C  
ATOM    807  CD1 ILE A  62      32.695  30.883  49.237  1.00 42.84           C  
ATOM    808  N   THR A  63      34.776  26.452  49.695  1.00 39.01           N  
ATOM    809  CA  THR A  63      34.063  25.286  50.233  1.00 40.01           C  
ATOM    810  C   THR A  63      34.408  24.992  51.694  1.00 42.17           C  
ATOM    811  O   THR A  63      33.545  24.602  52.496  1.00 42.74           O  
ATOM    812  CB  THR A  63      34.359  23.974  49.458  1.00 39.29           C  
ATOM    813  OG1 THR A  63      33.510  22.944  49.975  1.00 39.57           O  
ATOM    814  CG2 THR A  63      35.795  23.494  49.680  1.00 39.44           C  
ATOM    815  N   HIS A  64      35.680  25.135  52.043  1.00 43.61           N  
ATOM    816  CA  HIS A  64      36.067  24.872  53.414  1.00 45.76           C  
ATOM    817  C   HIS A  64      35.206  25.725  54.320  1.00 46.01           C  
ATOM    818  O   HIS A  64      35.116  25.459  55.518  1.00 47.63           O  
ATOM    819  CB  HIS A  64      37.557  25.171  53.624  1.00 47.58           C  
ATOM    820  CG  HIS A  64      38.461  24.159  52.984  1.00 49.25           C  
ATOM    821  ND1 HIS A  64      39.187  24.421  51.840  1.00 50.13           N  
ATOM    822  CD2 HIS A  64      38.685  22.856  53.278  1.00 48.83           C  
ATOM    823  CE1 HIS A  64      39.812  23.322  51.454  1.00 49.62           C  
ATOM    824  NE2 HIS A  64      39.525  22.357  52.309  1.00 49.74           N  
ATOM    825  N   SER A  65      34.558  26.732  53.727  1.00 45.53           N  
ATOM    826  CA  SER A  65      33.683  27.654  54.449  1.00 44.83           C  
ATOM    827  C   SER A  65      32.186  27.393  54.309  1.00 46.33           C  
ATOM    828  O   SER A  65      31.392  28.187  54.830  1.00 47.47           O  
ATOM    829  CB  SER A  65      33.959  29.100  54.032  1.00 44.08           C  
ATOM    830  OG  SER A  65      35.170  29.581  54.575  1.00 42.34           O  
ATOM    831  N   ILE A  66      31.787  26.311  53.627  1.00 46.70           N  
ATOM    832  CA  ILE A  66      30.352  25.991  53.470  1.00 46.65           C  
ATOM    833  C   ILE A  66      29.857  24.859  54.391  1.00 46.99           C  
ATOM    834  O   ILE A  66      30.092  23.667  54.160  1.00 47.31           O  
ATOM    835  CB  ILE A  66      30.000  25.673  52.003  1.00 46.18           C  
ATOM    836  CG1 ILE A  66      30.962  24.648  51.408  1.00 46.20           C  
ATOM    837  CG2 ILE A  66      30.074  26.939  51.199  1.00 47.37           C  
ATOM    838  CD1 ILE A  66      30.476  23.977  50.122  1.00 48.01           C  
ATOM    839  N   THR A  67      29.171  25.278  55.451  1.00 46.05           N  
ATOM    840  CA  THR A  67      28.644  24.388  56.475  1.00 43.80           C  
ATOM    841  C   THR A  67      27.404  23.692  55.946  1.00 42.64           C  
ATOM    842  O   THR A  67      26.962  23.968  54.830  1.00 43.73           O  
ATOM    843  CB  THR A  67      28.279  25.205  57.750  1.00 44.74           C  
ATOM    844  OG1 THR A  67      29.079  26.395  57.817  1.00 42.42           O  
ATOM    845  CG2 THR A  67      28.548  24.390  58.999  1.00 46.15           C  
ATOM    846  N   VAL A  68      26.861  22.752  56.708  1.00 41.27           N  
ATOM    847  CA  VAL A  68      25.646  22.098  56.255  1.00 38.91           C  
ATOM    848  C   VAL A  68      24.563  23.145  56.489  1.00 39.67           C  
ATOM    849  O   VAL A  68      24.716  24.011  57.359  1.00 38.99           O  
ATOM    850  CB  VAL A  68      25.342  20.822  57.066  1.00 37.82           C  
ATOM    851  CG1 VAL A  68      23.891  20.357  56.863  1.00 34.81           C  
ATOM    852  CG2 VAL A  68      26.316  19.745  56.648  1.00 37.20           C  
ATOM    853  N   GLY A  69      23.486  23.087  55.708  1.00 39.70           N  
ATOM    854  CA  GLY A  69      22.415  24.051  55.878  1.00 38.45           C  
ATOM    855  C   GLY A  69      22.924  25.407  55.466  1.00 37.28           C  
ATOM    856  O   GLY A  69      22.515  26.442  55.996  1.00 38.26           O  
ATOM    857  N   SER A  70      23.864  25.407  54.539  1.00 35.04           N  
ATOM    858  CA  SER A  70      24.389  26.672  54.066  1.00 34.87           C  
ATOM    859  C   SER A  70      23.438  27.174  52.975  1.00 34.67           C  
ATOM    860  O   SER A  70      22.797  26.374  52.306  1.00 34.99           O  
ATOM    861  CB  SER A  70      25.789  26.477  53.499  1.00 34.50           C  
ATOM    862  OG  SER A  70      26.767  26.834  54.446  1.00 36.48           O  
ATOM    863  N   ARG A  71      23.307  28.484  52.819  1.00 34.79           N  
ATOM    864  CA  ARG A  71      22.448  29.010  51.760  1.00 36.83           C  
ATOM    865  C   ARG A  71      23.382  29.608  50.723  1.00 36.40           C  
ATOM    866  O   ARG A  71      23.936  30.678  50.885  1.00 36.27           O  
ATOM    867  CB  ARG A  71      21.460  30.045  52.287  1.00 38.02           C  
ATOM    868  CG  ARG A  71      20.086  29.439  52.570  1.00 40.57           C  
ATOM    869  CD  ARG A  71      19.182  30.424  53.290  1.00 44.00           C  
ATOM    870  NE  ARG A  71      19.036  31.690  52.570  1.00 46.45           N  
ATOM    871  CZ  ARG A  71      18.499  32.788  53.098  1.00 49.02           C  
ATOM    872  NH1 ARG A  71      18.057  32.774  54.357  1.00 50.49           N  
ATOM    873  NH2 ARG A  71      18.408  33.899  52.371  1.00 49.05           N  
ATOM    874  N   ILE A  72      23.556  28.880  49.637  1.00 36.00           N  
ATOM    875  CA  ILE A  72      24.469  29.303  48.593  1.00 37.00           C  
ATOM    876  C   ILE A  72      23.848  29.243  47.186  1.00 36.87           C  
ATOM    877  O   ILE A  72      22.795  28.643  46.975  1.00 36.14           O  
ATOM    878  CB  ILE A  72      25.717  28.375  48.671  1.00 37.27           C  
ATOM    879  CG1 ILE A  72      26.735  28.697  47.584  1.00 37.85           C  
ATOM    880  CG2 ILE A  72      25.289  26.927  48.524  1.00 35.86           C  
ATOM    881  CD1 ILE A  72      28.138  28.141  47.830  1.00 40.73           C  
ATOM    882  N   THR A  73      24.503  29.902  46.242  1.00 36.08           N  
ATOM    883  CA  THR A  73      24.082  29.860  44.854  1.00 36.02           C  
ATOM    884  C   THR A  73      25.288  29.378  44.051  1.00 34.17           C  
ATOM    885  O   THR A  73      26.325  30.031  44.031  1.00 32.43           O  
ATOM    886  CB  THR A  73      23.653  31.233  44.348  1.00 36.02           C  
ATOM    887  OG1 THR A  73      23.463  31.175  42.930  1.00 39.24           O  
ATOM    888  CG2 THR A  73      24.710  32.270  44.664  1.00 35.40           C  
ATOM    889  N   VAL A  74      25.174  28.234  43.392  1.00 33.06           N  
ATOM    890  CA  VAL A  74      26.333  27.789  42.659  1.00 32.70           C  
ATOM    891  C   VAL A  74      26.090  27.978  41.181  1.00 31.11           C  
ATOM    892  O   VAL A  74      24.952  28.081  40.746  1.00 29.56           O  
ATOM    893  CB  VAL A  74      26.735  26.335  43.034  1.00 33.00           C  
ATOM    894  CG1 VAL A  74      26.356  26.055  44.497  1.00 32.66           C  
ATOM    895  CG2 VAL A  74      26.089  25.344  42.116  1.00 34.85           C  
ATOM    896  N   GLN A  75      27.173  28.009  40.417  1.00 30.71           N  
ATOM    897  CA  GLN A  75      27.102  28.298  39.001  1.00 30.52           C  
ATOM    898  C   GLN A  75      28.203  27.604  38.226  1.00 31.82           C  
ATOM    899  O   GLN A  75      29.386  27.749  38.565  1.00 32.93           O  
ATOM    900  CB  GLN A  75      27.249  29.808  38.888  1.00 29.67           C  
ATOM    901  CG  GLN A  75      27.267  30.450  37.559  1.00 30.37           C  
ATOM    902  CD  GLN A  75      27.047  31.947  37.737  1.00 31.40           C  
ATOM    903  OE1 GLN A  75      27.374  32.757  36.871  1.00 33.91           O  
ATOM    904  NE2 GLN A  75      26.481  32.320  38.881  1.00 31.11           N  
ATOM    905  N   GLY A  76      27.821  26.861  37.184  1.00 31.04           N  
ATOM    906  CA  GLY A  76      28.794  26.136  36.361  1.00 28.76           C  
ATOM    907  C   GLY A  76      28.079  25.208  35.401  1.00 29.13           C  
ATOM    908  O   GLY A  76      26.855  25.260  35.311  1.00 28.99           O  
ATOM    909  N   PHE A  77      28.805  24.334  34.711  1.00 29.42           N  
ATOM    910  CA  PHE A  77      28.145  23.443  33.744  1.00 29.03           C  
ATOM    911  C   PHE A  77      27.546  22.174  34.321  1.00 29.38           C  
ATOM    912  O   PHE A  77      27.915  21.750  35.404  1.00 30.12           O  
ATOM    913  CB  PHE A  77      29.087  23.071  32.584  1.00 26.78           C  
ATOM    914  CG  PHE A  77      30.329  22.348  33.010  1.00 23.54           C  
ATOM    915  CD1 PHE A  77      31.493  23.053  33.309  1.00 21.80           C  
ATOM    916  CD2 PHE A  77      30.352  20.948  33.072  1.00 23.45           C  
ATOM    917  CE1 PHE A  77      32.676  22.375  33.656  1.00 20.61           C  
ATOM    918  CE2 PHE A  77      31.521  20.260  33.419  1.00 19.57           C  
ATOM    919  CZ  PHE A  77      32.689  20.979  33.710  1.00 20.17           C  
ATOM    920  N   ILE A  78      26.603  21.585  33.590  1.00 30.68           N  
ATOM    921  CA  ILE A  78      25.928  20.354  34.005  1.00 31.52           C  
ATOM    922  C   ILE A  78      26.459  19.171  33.209  1.00 33.14           C  
ATOM    923  O   ILE A  78      26.801  19.307  32.036  1.00 32.23           O  
ATOM    924  CB  ILE A  78      24.396  20.422  33.769  1.00 31.52           C  
ATOM    925  CG1 ILE A  78      23.662  19.821  34.956  1.00 31.18           C  
ATOM    926  CG2 ILE A  78      23.981  19.580  32.555  1.00 32.70           C  
ATOM    927  CD1 ILE A  78      23.644  20.695  36.208  1.00 35.60           C  
ATOM    928  N   SER A  79      26.493  18.001  33.833  1.00 35.36           N  
ATOM    929  CA  SER A  79      26.984  16.818  33.151  1.00 37.76           C  
ATOM    930  C   SER A  79      26.328  15.582  33.741  1.00 38.65           C  
ATOM    931  O   SER A  79      26.100  15.521  34.948  1.00 38.59           O  
ATOM    932  CB  SER A  79      28.493  16.729  33.298  1.00 37.67           C  
ATOM    933  OG  SER A  79      28.825  16.308  34.593  1.00 39.19           O  
ATOM    934  N   CYS A  80      26.041  14.575  32.918  1.00 40.18           N  
ATOM    935  CA  CYS A  80      25.383  13.406  33.481  1.00 41.52           C  
ATOM    936  C   CYS A  80      25.602  12.042  32.832  1.00 42.94           C  
ATOM    937  O   CYS A  80      26.638  11.827  32.227  1.00 42.54           O  
ATOM    938  CB  CYS A  80      23.888  13.690  33.616  1.00 40.86           C  
ATOM    939  SG  CYS A  80      22.879  13.751  32.097  1.00 39.32           S  
ATOM    940  N   HIS A  81      24.656  11.108  33.019  1.00 45.76           N  
ATOM    941  CA  HIS A  81      24.727   9.736  32.452  1.00 48.72           C  
ATOM    942  C   HIS A  81      24.001   8.663  33.279  1.00 49.83           C  
ATOM    943  O   HIS A  81      24.097   8.652  34.507  1.00 49.68           O  
ATOM    944  CB  HIS A  81      26.194   9.298  32.249  1.00 48.21           C  
ATOM    945  N   LYS A  82      23.284   7.763  32.601  1.00 51.80           N  
ATOM    946  CA  LYS A  82      22.568   6.681  33.283  1.00 54.21           C  
ATOM    947  C   LYS A  82      22.255   5.482  32.368  1.00 56.28           C  
ATOM    948  O   LYS A  82      21.099   5.036  32.259  1.00 56.41           O  
ATOM    949  CB  LYS A  82      21.273   7.207  33.912  1.00 54.02           C  
ATOM    950  CG  LYS A  82      21.470   8.330  34.923  1.00 54.96           C  
ATOM    951  CD  LYS A  82      21.683   7.833  36.337  1.00 54.42           C  
ATOM    952  CE  LYS A  82      20.406   7.254  36.896  1.00 53.87           C  
ATOM    953  NZ  LYS A  82      19.279   8.219  36.799  1.00 53.01           N  
ATOM    954  N   ALA A  83      23.303   4.976  31.714  1.00 58.17           N  
ATOM    955  CA  ALA A  83      23.207   3.818  30.837  1.00 59.78           C  
ATOM    956  C   ALA A  83      22.987   2.606  31.739  1.00 61.16           C  
ATOM    957  O   ALA A  83      23.583   2.524  32.810  1.00 61.26           O  
ATOM    958  CB  ALA A  83      24.494   3.664  30.057  1.00 59.83           C  
ATOM    959  N   LYS A  84      22.144   1.670  31.314  1.00 62.88           N  
ATOM    960  CA  LYS A  84      21.848   0.491  32.129  1.00 65.10           C  
ATOM    961  C   LYS A  84      23.010  -0.466  32.376  1.00 65.88           C  
ATOM    962  O   LYS A  84      22.797  -1.646  32.632  1.00 66.58           O  
ATOM    963  CB  LYS A  84      20.665  -0.280  31.532  1.00 65.99           C  
ATOM    964  CG  LYS A  84      19.343   0.439  31.690  1.00 68.03           C  
ATOM    965  CD  LYS A  84      18.942   0.537  33.159  1.00 67.98           C  
ATOM    966  CE  LYS A  84      18.122   1.791  33.425  1.00 69.00           C  
ATOM    967  NZ  LYS A  84      16.982   1.953  32.479  1.00 68.46           N  
ATOM    968  N   ASN A  85      24.188   0.016  32.252  1.00 66.12           N  
ATOM    969  CA  ASN A  85      25.439  -0.677  32.536  1.00 65.33           C  
ATOM    970  C   ASN A  85      26.374   0.199  33.363  1.00 64.33           C  
ATOM    971  O   ASN A  85      27.480   0.450  33.004  1.00 63.31           O  
ATOM    972  CB  ASN A  85      25.939  -1.403  31.285  1.00 66.34           C  
ATOM    973  CG  ASN A  85      26.671  -2.690  31.611  1.00 67.08           C  
ATOM    974  OD1 ASN A  85      27.898  -2.752  31.551  1.00 67.05           O  
ATOM    975  ND2 ASN A  85      25.917  -3.728  31.956  1.00 67.16           N  
ATOM    976  N   GLY A  86      25.726   0.774  34.400  1.00 63.83           N  
ATOM    977  CA  GLY A  86      26.415   1.725  35.253  1.00 62.77           C  
ATOM    978  C   GLY A  86      25.697   3.073  35.198  1.00 62.07           C  
ATOM    979  O   GLY A  86      26.176   4.003  34.545  1.00 62.54           O  
ATOM    980  N   LEU A  87      24.552   3.183  35.867  1.00 61.08           N  
ATOM    981  CA  LEU A  87      23.799   4.432  35.889  1.00 60.72           C  
ATOM    982  C   LEU A  87      24.428   5.335  36.938  1.00 60.30           C  
ATOM    983  O   LEU A  87      24.241   5.116  38.139  1.00 62.72           O  
ATOM    984  CB  LEU A  87      22.346   4.196  36.309  1.00 60.81           C  
ATOM    985  CG  LEU A  87      21.733   2.825  36.156  1.00 60.20           C  
ATOM    986  CD1 LEU A  87      20.602   2.690  37.156  1.00 60.05           C  
ATOM    987  CD2 LEU A  87      21.260   2.633  34.736  1.00 60.71           C  
ATOM    988  N   SER A  88      25.153   6.356  36.508  1.00 58.46           N  
ATOM    989  CA  SER A  88      25.790   7.275  37.441  1.00 57.86           C  
ATOM    990  C   SER A  88      24.835   8.339  37.925  1.00 56.69           C  
ATOM    991  O   SER A  88      23.964   8.027  38.734  1.00 56.40           O  
ATOM    992  CB  SER A  88      27.005   7.891  36.784  1.00 58.56           C  
ATOM    993  OG  SER A  88      28.034   6.905  36.640  1.00 60.61           O  
ATOM    994  N   LYS A  89      24.967   9.578  37.450  1.00 54.49           N  
ATOM    995  CA  LYS A  89      24.046  10.609  37.904  1.00 52.30           C  
ATOM    996  C   LYS A  89      24.331  12.008  37.351  1.00 49.91           C  
ATOM    997  O   LYS A  89      25.397  12.265  36.799  1.00 50.43           O  
ATOM    998  CB  LYS A  89      24.056  10.660  39.438  1.00 53.01           C  
ATOM    999  CG  LYS A  89      22.713  10.279  40.123  1.00 55.68           C  
ATOM   1000  CD  LYS A  89      22.721   8.880  40.791  1.00 56.39           C  
ATOM   1001  CE  LYS A  89      23.777   8.780  41.894  1.00 58.34           C  
ATOM   1002  NZ  LYS A  89      24.347   7.389  42.082  1.00 59.99           N  
ATOM   1003  N   MET A  90      23.361  12.907  37.510  1.00 46.53           N  
ATOM   1004  CA  MET A  90      23.479  14.285  37.046  1.00 43.20           C  
ATOM   1005  C   MET A  90      24.300  15.062  38.076  1.00 41.12           C  
ATOM   1006  O   MET A  90      24.117  14.924  39.281  1.00 40.22           O  
ATOM   1007  CB  MET A  90      22.119  14.884  36.903  1.00 44.33           C  
ATOM   1008  N   VAL A  91      25.207  15.890  37.585  1.00 38.32           N  
ATOM   1009  CA  VAL A  91      26.091  16.657  38.451  1.00 34.48           C  
ATOM   1010  C   VAL A  91      26.480  18.030  37.899  1.00 32.19           C  
ATOM   1011  O   VAL A  91      26.875  18.173  36.756  1.00 31.07           O  
ATOM   1012  CB  VAL A  91      27.393  15.844  38.745  1.00 34.04           C  
ATOM   1013  CG1 VAL A  91      27.973  15.272  37.444  1.00 33.71           C  
ATOM   1014  CG2 VAL A  91      28.431  16.738  39.441  1.00 33.37           C  
ATOM   1015  N   LEU A  92      26.378  19.035  38.752  1.00 28.89           N  
ATOM   1016  CA  LEU A  92      26.716  20.395  38.389  1.00 27.11           C  
ATOM   1017  C   LEU A  92      28.171  20.730  38.693  1.00 28.30           C  
ATOM   1018  O   LEU A  92      28.510  21.059  39.817  1.00 29.33           O  
ATOM   1019  CB  LEU A  92      25.807  21.354  39.151  1.00 25.19           C  
ATOM   1020  CG  LEU A  92      26.181  22.842  39.262  1.00 24.39           C  
ATOM   1021  CD1 LEU A  92      26.440  23.467  37.914  1.00 23.53           C  
ATOM   1022  CD2 LEU A  92      25.050  23.583  39.959  1.00 22.84           C  
ATOM   1023  N   HIS A  93      29.045  20.652  37.707  1.00 27.36           N  
ATOM   1024  CA  HIS A  93      30.420  20.999  37.983  1.00 26.72           C  
ATOM   1025  C   HIS A  93      30.385  22.491  38.167  1.00 26.95           C  
ATOM   1026  O   HIS A  93      29.952  23.207  37.281  1.00 28.70           O  
ATOM   1027  CB  HIS A  93      31.303  20.573  36.830  1.00 26.07           C  
ATOM   1028  CG  HIS A  93      31.337  19.093  36.661  1.00 25.54           C  
ATOM   1029  ND1 HIS A  93      32.425  18.329  37.035  1.00 25.86           N  
ATOM   1030  CD2 HIS A  93      30.375  18.223  36.277  1.00 23.91           C  
ATOM   1031  CE1 HIS A  93      32.127  17.052  36.894  1.00 22.72           C  
ATOM   1032  NE2 HIS A  93      30.886  16.962  36.440  1.00 23.99           N  
ATOM   1033  N   ALA A  94      30.839  22.944  39.334  1.00 26.26           N  
ATOM   1034  CA  ALA A  94      30.816  24.352  39.690  1.00 24.27           C  
ATOM   1035  C   ALA A  94      32.066  25.117  39.361  1.00 22.77           C  
ATOM   1036  O   ALA A  94      33.151  24.622  39.551  1.00 23.22           O  
ATOM   1037  CB  ALA A  94      30.519  24.474  41.161  1.00 25.21           C  
ATOM   1038  N   GLU A  95      31.918  26.333  38.860  1.00 23.30           N  
ATOM   1039  CA  GLU A  95      33.099  27.137  38.579  1.00 23.73           C  
ATOM   1040  C   GLU A  95      33.033  28.356  39.503  1.00 23.82           C  
ATOM   1041  O   GLU A  95      34.068  28.967  39.824  1.00 23.07           O  
ATOM   1042  CB  GLU A  95      33.172  27.601  37.087  1.00 24.88           C  
ATOM   1043  CG  GLU A  95      32.038  28.540  36.589  1.00 25.91           C  
ATOM   1044  CD  GLU A  95      32.470  29.516  35.469  1.00 26.66           C  
ATOM   1045  OE1 GLU A  95      33.344  29.165  34.641  1.00 27.38           O  
ATOM   1046  OE2 GLU A  95      31.914  30.633  35.404  1.00 23.21           O  
ATOM   1047  N   GLN A  96      31.824  28.670  39.972  1.00 23.21           N  
ATOM   1048  CA  GLN A  96      31.632  29.845  40.810  1.00 25.42           C  
ATOM   1049  C   GLN A  96      30.555  29.711  41.898  1.00 26.28           C  
ATOM   1050  O   GLN A  96      29.492  29.145  41.647  1.00 27.73           O  
ATOM   1051  CB  GLN A  96      31.367  31.049  39.876  1.00 24.45           C  
ATOM   1052  CG  GLN A  96      30.271  32.009  40.265  1.00 26.10           C  
ATOM   1053  CD  GLN A  96      30.560  33.447  39.797  1.00 28.15           C  
ATOM   1054  OE1 GLN A  96      31.518  34.099  40.280  1.00 29.22           O  
ATOM   1055  NE2 GLN A  96      29.741  33.947  38.855  1.00 26.53           N  
ATOM   1056  N   ILE A  97      30.869  30.210  43.104  1.00 25.16           N  
ATOM   1057  CA  ILE A  97      29.970  30.195  44.267  1.00 26.58           C  
ATOM   1058  C   ILE A  97      30.149  31.400  45.205  1.00 28.59           C  
ATOM   1059  O   ILE A  97      31.269  31.794  45.578  1.00 27.11           O  
ATOM   1060  CB  ILE A  97      30.158  28.932  45.077  1.00 26.61           C  
ATOM   1061  N   GLU A  98      29.015  31.976  45.581  1.00 29.51           N  
ATOM   1062  CA  GLU A  98      28.973  33.088  46.493  1.00 30.94           C  
ATOM   1063  C   GLU A  98      27.928  32.650  47.512  1.00 31.45           C  
ATOM   1064  O   GLU A  98      27.004  31.915  47.172  1.00 29.78           O  
ATOM   1065  CB  GLU A  98      28.582  34.363  45.748  1.00 32.78           C  
ATOM   1066  CG  GLU A  98      27.775  34.156  44.443  1.00 32.79           C  
ATOM   1067  CD  GLU A  98      28.195  35.117  43.322  1.00 34.44           C  
ATOM   1068  OE1 GLU A  98      29.277  34.915  42.735  1.00 35.30           O  
ATOM   1069  OE2 GLU A  98      27.448  36.081  43.032  1.00 32.46           O  
ATOM   1070  N   LEU A  99      28.100  33.056  48.768  1.00 33.17           N  
ATOM   1071  CA  LEU A  99      27.182  32.673  49.850  1.00 34.01           C  
ATOM   1072  C   LEU A  99      25.984  33.614  49.875  1.00 34.67           C  
ATOM   1073  O   LEU A  99      26.150  34.789  49.589  1.00 36.41           O  
ATOM   1074  CB  LEU A  99      27.954  32.697  51.170  1.00 34.06           C  
ATOM   1075  CG  LEU A  99      29.291  31.947  51.058  1.00 34.00           C  
ATOM   1076  CD1 LEU A  99      30.091  32.117  52.335  1.00 34.23           C  
ATOM   1077  CD2 LEU A  99      29.029  30.469  50.750  1.00 32.90           C  
ATOM   1078  N   ILE A 100      24.800  33.120  50.238  1.00 35.11           N  
ATOM   1079  CA  ILE A 100      23.597  33.957  50.209  1.00 35.22           C  
ATOM   1080  C   ILE A 100      22.928  34.479  51.486  1.00 35.81           C  
ATOM   1081  O   ILE A 100      21.888  35.129  51.421  1.00 36.27           O  
ATOM   1082  CB  ILE A 100      22.553  33.283  49.317  1.00 33.98           C  
ATOM   1083  N   ASP A 101      23.482  34.188  52.653  1.00 38.35           N  
ATOM   1084  CA  ASP A 101      22.913  34.738  53.907  1.00 39.98           C  
ATOM   1085  C   ASP A 101      23.802  35.947  54.214  1.00 40.41           C  
ATOM   1086  O   ASP A 101      25.020  35.786  54.311  1.00 40.35           O  
ATOM   1087  CB  ASP A 101      23.005  33.729  55.054  1.00 39.60           C  
ATOM   1088  N   SER A 102      23.230  37.148  54.333  1.00 41.23           N  
ATOM   1089  CA  SER A 102      24.046  38.349  54.595  1.00 41.53           C  
ATOM   1090  C   SER A 102      24.609  38.425  56.038  1.00 42.24           C  
ATOM   1091  O   SER A 102      23.968  37.981  56.996  1.00 41.52           O  
ATOM   1092  CB  SER A 102      23.223  39.612  54.279  1.00 42.17           C  
ATOM   1093  OG  SER A 102      24.013  40.795  54.271  1.00 42.15           O  
ATOM   1094  N   VAL A 103      25.816  38.977  56.186  1.00 42.44           N  
ATOM   1095  CA  VAL A 103      26.420  39.106  57.514  1.00 43.14           C  
ATOM   1096  C   VAL A 103      25.456  39.787  58.508  1.00 43.37           C  
ATOM   1097  O   VAL A 103      25.188  39.249  59.578  1.00 43.04           O  
ATOM   1098  CB  VAL A 103      27.799  39.888  57.485  1.00 42.69           C  
ATOM   1099  CG1 VAL A 103      28.190  40.233  56.074  1.00 41.23           C  
ATOM   1100  CG2 VAL A 103      27.730  41.152  58.351  1.00 43.55           C  
ATOM   1101  N   ASP A 104      24.912  40.946  58.151  1.00 43.70           N  
ATOM   1102  CA  ASP A 104      24.001  41.634  59.053  1.00 44.67           C  
ATOM   1103  C   ASP A 104      22.891  40.677  59.423  1.00 44.94           C  
ATOM   1104  O   ASP A 104      22.244  40.828  60.453  1.00 44.59           O  
ATOM   1105  CB  ASP A 104      23.354  42.860  58.387  1.00 45.26           C  
ATOM   1106  CG  ASP A 104      24.214  43.469  57.289  1.00 47.78           C  
ATOM   1107  OD1 ASP A 104      24.548  44.672  57.389  1.00 46.85           O  
ATOM   1108  OD2 ASP A 104      24.548  42.745  56.316  1.00 50.49           O  
ATOM   1109  N   LYS A 105      22.656  39.686  58.577  1.00 45.15           N  
ATOM   1110  CA  LYS A 105      21.572  38.757  58.855  1.00 45.33           C  
ATOM   1111  C   LYS A 105      21.875  37.745  59.956  1.00 45.00           C  
ATOM   1112  O   LYS A 105      21.181  37.686  60.970  1.00 45.02           O  
ATOM   1113  CB  LYS A 105      21.180  38.022  57.574  1.00 44.31           C  
ATOM   1114  CG  LYS A 105      19.692  37.823  57.410  1.00 43.84           C  
ATOM   1115  CD  LYS A 105      19.204  36.499  57.957  1.00 44.36           C  
ATOM   1116  CE  LYS A 105      18.375  36.670  59.214  1.00 44.03           C  
ATOM   1117  NZ  LYS A 105      19.209  36.914  60.425  1.00 44.02           N  
ATOM   1118  N   LEU A 106      22.912  36.947  59.733  1.00 44.57           N  
ATOM   1119  CA  LEU A 106      23.339  35.909  60.656  1.00 44.50           C  
ATOM   1120  C   LEU A 106      23.713  36.482  62.020  1.00 45.12           C  
ATOM   1121  O   LEU A 106      23.352  35.924  63.058  1.00 45.59           O  
ATOM   1122  CB  LEU A 106      24.514  35.162  60.052  1.00 44.75           C  
ATOM   1123  N   ALA A 107      24.455  37.589  62.004  1.00 45.23           N  
ATOM   1124  CA  ALA A 107      24.881  38.286  63.223  1.00 44.78           C  
ATOM   1125  C   ALA A 107      23.670  38.567  64.109  1.00 44.09           C  
ATOM   1126  O   ALA A 107      23.747  38.517  65.340  1.00 45.07           O  
ATOM   1127  CB  ALA A 107      25.581  39.602  62.865  1.00 44.41           C  
ATOM   1128  N   ALA A 108      22.549  38.866  63.481  1.00 43.56           N  
ATOM   1129  CA  ALA A 108      21.349  39.121  64.235  1.00 45.04           C  
ATOM   1130  C   ALA A 108      21.085  37.961  65.183  1.00 45.40           C  
ATOM   1131  O   ALA A 108      20.834  38.170  66.370  1.00 45.00           O  
ATOM   1132  CB  ALA A 108      20.162  39.300  63.285  1.00 45.29           C  
ATOM   1133  N   ALA A 109      21.160  36.744  64.645  1.00 47.24           N  
ATOM   1134  CA  ALA A 109      20.882  35.518  65.411  1.00 49.14           C  
ATOM   1135  C   ALA A 109      21.990  34.996  66.303  1.00 50.22           C  
ATOM   1136  O   ALA A 109      21.914  33.873  66.805  1.00 50.81           O  
ATOM   1137  CB  ALA A 109      20.435  34.404  64.471  1.00 48.66           C  
ATOM   1138  N   LEU A 110      23.011  35.807  66.512  1.00 51.00           N  
ATOM   1139  CA  LEU A 110      24.112  35.383  67.354  1.00 52.64           C  
ATOM   1140  C   LEU A 110      24.233  36.302  68.589  1.00 54.89           C  
ATOM   1141  O   LEU A 110      24.598  35.850  69.678  1.00 55.25           O  
ATOM   1142  CB  LEU A 110      25.398  35.375  66.510  1.00 49.81           C  
ATOM   1143  CG  LEU A 110      26.679  34.645  66.916  1.00 47.40           C  
ATOM   1144  CD1 LEU A 110      26.505  33.150  66.930  1.00 44.57           C  
ATOM   1145  CD2 LEU A 110      27.751  35.025  65.917  1.00 47.01           C  
ATOM   1146  N   GLU A 111      23.854  37.569  68.438  1.00 57.12           N  
ATOM   1147  CA  GLU A 111      23.952  38.534  69.536  1.00 59.78           C  
ATOM   1148  C   GLU A 111      22.657  38.931  70.263  1.00 60.67           C  
ATOM   1149  O   GLU A 111      22.720  39.503  71.357  1.00 62.17           O  
ATOM   1150  CB  GLU A 111      24.604  39.809  69.006  1.00 60.76           C  
ATOM   1151  CG  GLU A 111      23.795  40.438  67.908  1.00 63.26           C  
ATOM   1152  CD  GLU A 111      24.479  41.629  67.297  1.00 65.02           C  
ATOM   1153  OE1 GLU A 111      24.233  41.883  66.091  1.00 65.34           O  
ATOM   1154  OE2 GLU A 111      25.250  42.307  68.016  1.00 65.88           O  
ATOM   1155  N   HIS A 112      21.498  38.628  69.676  1.00 61.05           N  
ATOM   1156  CA  HIS A 112      20.200  39.028  70.249  1.00 61.61           C  
ATOM   1157  C   HIS A 112      19.651  38.400  71.538  1.00 61.53           C  
ATOM   1158  O   HIS A 112      19.155  39.099  72.419  1.00 61.00           O  
ATOM   1159  CB  HIS A 112      19.119  38.942  69.156  1.00 62.01           C  
ATOM   1160  N   HIS A 113      19.733  37.089  71.652  1.00 62.17           N  
ATOM   1161  CA  HIS A 113      19.194  36.397  72.814  1.00 62.60           C  
ATOM   1162  C   HIS A 113      19.624  36.935  74.188  1.00 62.21           C  
ATOM   1163  O   HIS A 113      18.816  36.972  75.124  1.00 61.61           O  
ATOM   1164  CB  HIS A 113      19.518  34.897  72.716  1.00 64.45           C  
ATOM   1165  CG  HIS A 113      20.987  34.586  72.731  1.00 66.77           C  
ATOM   1166  ND1 HIS A 113      21.840  35.097  73.688  1.00 67.34           N  
ATOM   1167  CD2 HIS A 113      21.753  33.806  71.928  1.00 67.85           C  
ATOM   1168  CE1 HIS A 113      23.062  34.648  73.474  1.00 67.29           C  
ATOM   1169  NE2 HIS A 113      23.039  33.861  72.411  1.00 67.61           N  
ATOM   1170  N   HIS A 114      20.871  37.400  74.294  1.00 61.13           N  
ATOM   1171  CA  HIS A 114      21.454  37.911  75.561  1.00 59.56           C  
ATOM   1172  C   HIS A 114      20.723  38.894  76.490  1.00 58.70           C  
ATOM   1173  O   HIS A 114      19.726  38.520  77.126  1.00 57.90           O  
ATOM   1174  CB  HIS A 114      22.893  38.431  75.287  1.00 59.42           C  
ATOM   1175  N   HIS A 115      21.219  40.136  76.534  1.00 58.40           N  
ATOM   1176  CA  HIS A 115      20.732  41.234  77.395  1.00 57.68           C  
ATOM   1177  C   HIS A 115      19.270  41.704  77.370  1.00 57.35           C  
ATOM   1178  O   HIS A 115      19.001  42.880  77.701  1.00 56.77           O  
ATOM   1179  CB  HIS A 115      21.657  42.474  77.190  1.00 56.87           C  
ATOM   1180  N   HIS A 116      18.398  40.889  77.033  1.00 58.12           N  
TER    1181      HIS A 116                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
