
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  106 (  751),  selected  106 , name 1ue6_B
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1ue6_B.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     3_B      -       -           -
LGA    D     4_B      M       1          2.078
LGA    T     5_B      N       2          0.958
LGA    T     6_B      T       3          0.424
LGA    I     7_B      L       4          0.796
LGA    T     8_B      E       5          0.542
LGA    I     9_B      L       6          0.612
LGA    V    10_B      S       7          0.334
LGA    G    11_B      A       8          1.047
LGA    N    12_B      R       9          0.448
LGA    L    13_B      V      10          0.712
LGA    T    14_B      L      11          0.742
LGA    A    15_B      E      12          1.323
LGA    D    16_B      C      13          2.405
LGA    P    17_B      G      14          3.906
LGA    E    18_B      A      15          2.789
LGA    L    19_B      M      16          1.602
LGA    R    20_B      R      17          0.740
LGA    F    21_B      H      18          0.955
LGA    T    22_B      T      19          1.247
LGA    P    23_B      P      20          1.491
LGA    S    24_B      A      21          1.442
LGA    G    25_B      G      22          0.716
LGA    A    26_B      L      23          0.761
LGA    A    27_B      P      24          0.616
LGA    V    28_B      A      25          0.398
LGA    A    29_B      L      26          1.199
LGA    N    30_B      E      27          1.229
LGA    F    31_B      L      28          0.150
LGA    T    32_B      L      29          1.375
LGA    V    33_B      L      30          0.894
LGA    A    34_B      V      31          0.370
LGA    S    35_B      H      32          0.489
LGA    T    36_B      E      33          1.595
LGA    P    37_B      S      34          1.879
LGA    R    38_B      E      35          1.952
LGA    -       -      V      36           -
LGA    -       -      V      37           -
LGA    -       -      E      38           -
LGA    -       -      A      39           -
LGA    -       -      G      40           -
LGA    -       -      H      41           -
LGA    -       -      P      42           -
LGA    I    39_B      R      43          2.673
LGA    E    51_B      R      44          4.321
LGA    -       -      V      45           -
LGA    A    52_B      E      46          1.926
LGA    L    53_B      L      47          0.787
LGA    F    54_B      T      48          0.647
LGA    L    55_B      I      49          1.148
LGA    R    56_B      S      50          0.732
LGA    C    57_B      A      51          0.653
LGA    N    58_B      V      52          0.783
LGA    I    59_B      A      53          0.956
LGA    W    60_B      L      54          0.989
LGA    R    61_B      G      55          1.089
LGA    E    62_B      D      56          2.779
LGA    A    63_B      L      57          2.238
LGA    A    64_B      A      58          0.730
LGA    E    65_B      L      59          1.701
LGA    N    66_B      L      60          1.875
LGA    V    67_B      L      61          0.835
LGA    A    68_B      A      62          0.641
LGA    E    69_B      D      63          3.943
LGA    S    70_B      -       -           -
LGA    L    71_B      T      64          1.284
LGA    T    72_B      P      65          1.552
LGA    R    73_B      L      66          1.103
LGA    G    74_B      G      67          0.745
LGA    A    75_B      T      68          0.699
LGA    R    76_B      E      69          0.604
LGA    V    77_B      M      70          0.277
LGA    I    78_B      Q      71          0.321
LGA    V    79_B      V      72          0.433
LGA    S    80_B      Q      73          0.751
LGA    G    81_B      G      74          0.604
LGA    R    82_B      F      75          0.755
LGA    L    83_B      L      76          0.872
LGA    K    84_B      A      77          0.785
LGA    Q    85_B      P      78          0.854
LGA    R    86_B      A      79          2.906
LGA    S    87_B      R      80          2.983
LGA    F    88_B      K      81           -
LGA    E    89_B      D      82           -
LGA    T    90_B      -       -           -
LGA    T    97_B      S      83          1.908
LGA    -       -      V      84           -
LGA    V    98_B      K      85          0.561
LGA    I    99_B      V      86          0.989
LGA    E   100_B      K      87          0.898
LGA    V   101_B      L      88          0.475
LGA    E   102_B      H      89          0.781
LGA    V   103_B      L      90          0.388
LGA    D   104_B      Q      91          0.675
LGA    E   105_B      Q      92          0.964
LGA    I   106_B      A      93          0.722
LGA    G   107_B      R      94          0.887
LGA    P   108_B      R      95          1.071
LGA    S   109_B      I      96          1.758
LGA    L   110_B      A      97          3.970
LGA    R   111_B      -       -           -
LGA    Y   112_B      -       -           -
LGA    A   113_B      G      98          0.685
LGA    T   114_B      -       -           -
LGA    A   115_B      -       -           -
LGA    K   116_B      -       -           -
LGA    V   117_B      -       -           -
LGA    N   118_B      -       -           -
LGA    K   119_B      -       -           -
LGA    A   120_B      -       -           -
LGA    S   121_B      -       -           -
LGA    R   122_B      -       -           -
LGA    S   123_B      -       -           -
LGA    G   124_B      -       -           -
LGA    G   125_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  106   98    5.0     87    1.51    13.79     83.105     5.409

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.029877 * X  +  -0.892114 * Y  +  -0.450822 * Z  +  61.250175
  Y_new =  -0.943309 * X  +   0.174325 * Y  +  -0.282450 * Z  +  70.878571
  Z_new =   0.330568 * X  +   0.416825 * Y  +  -0.846748 * Z  + 102.064987 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.684151   -0.457442  [ DEG:   153.7905    -26.2095 ]
  Theta =  -0.336905   -2.804688  [ DEG:   -19.3032   -160.6968 ]
  Phi   =  -1.602458    1.539134  [ DEG:   -91.8141     88.1859 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ue6_B                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ue6_B.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  106   98   5.0   87   1.51   13.79  83.105
REMARK  ---------------------------------------------------------- 
MOLECULE 1ue6_B
HEADER    DNA BINDING PROTEIN                     09-MAY-03   1UE6              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM TUBERCULOSIS                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11D                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, TB           
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, TBSGC                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,K.SEKAR,            
AUTHOR   2 U.VARSHNEY,M.VIJAYAN,TB STRUCTURAL GENOMICS CONSORTIUM               
AUTHOR   3 (TBSGC)                                                              
REVDAT   2   01-FEB-05 1UE6    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   10-FEB-04 1UE6    0                                                
JRNL        AUTH   K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,           
JRNL        AUTH 2 K.SEKAR,U.VARSHNEY,M.VIJAYAN                                 
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS                      
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN. VARIABILITY             
JRNL        TITL 3 IN QUATERNARY STRUCTURE AND ITS IMPLICATIONS                 
JRNL        REF    J.MOL.BIOL.                   V. 331   385 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1UE6 A    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 B    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 C    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 D    1   164  UNP    P0A610   SSB_MYCTU        1    164             
SEQRES   1 A  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 A  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 A  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 A  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 A  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 A  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 A  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 A  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 B  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 B  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 B  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 B  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 B  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 B  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 B  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 B  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 C  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 C  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 C  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 C  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 C  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 C  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 C  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 C  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 C  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 C  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 C  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 C  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 C  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 D  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 D  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 D  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 D  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 D  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 D  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 D  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 D  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 D  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 D  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 D  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 D  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 D  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
FORMUL   5  HOH   *229(H2 O)                                                    
CRYST1   60.363  117.620  175.228  90.00  90.00  90.00 I 21 21 21   32          
ATOM    786  N   GLY B   3      26.521  21.588  21.290  1.00 83.89           N  
ATOM    787  CA  GLY B   3      25.870  22.808  21.844  1.00 81.72           C  
ATOM    788  C   GLY B   3      26.554  23.298  23.103  1.00 84.16           C  
ATOM    789  O   GLY B   3      27.782  23.411  23.140  1.00 92.79           O  
ATOM    790  N   ASP B   4      25.765  23.582  24.137  1.00 76.57           N  
ATOM    791  CA  ASP B   4      26.312  24.072  25.399  1.00 76.37           C  
ATOM    792  C   ASP B   4      25.186  24.280  26.423  1.00 72.54           C  
ATOM    793  O   ASP B   4      24.015  24.381  26.051  1.00 63.99           O  
ATOM    794  CB  ASP B   4      27.057  25.389  25.141  1.00 88.90           C  
ATOM    795  CG  ASP B   4      28.198  25.621  26.112  1.00101.97           C  
ATOM    796  OD1 ASP B   4      27.964  26.262  27.160  1.00113.00           O  
ATOM    797  OD2 ASP B   4      29.327  25.152  25.831  1.00103.98           O  
ATOM    798  N   THR B   5      25.533  24.320  27.708  1.00 59.18           N  
ATOM    799  CA  THR B   5      24.532  24.536  28.745  1.00 51.84           C  
ATOM    800  C   THR B   5      25.122  25.077  30.033  1.00 50.54           C  
ATOM    801  O   THR B   5      26.026  24.475  30.605  1.00 48.07           O  
ATOM    802  CB  THR B   5      23.793  23.253  29.133  1.00 37.50           C  
ATOM    803  OG1 THR B   5      24.687  22.404  29.855  1.00 56.71           O  
ATOM    804  CG2 THR B   5      23.281  22.525  27.911  1.00 59.34           C  
ATOM    805  N   THR B   6      24.596  26.209  30.492  1.00 47.20           N  
ATOM    806  CA  THR B   6      25.041  26.812  31.741  1.00 46.36           C  
ATOM    807  C   THR B   6      23.853  26.862  32.694  1.00 36.84           C  
ATOM    808  O   THR B   6      22.700  26.879  32.260  1.00 32.40           O  
ATOM    809  CB  THR B   6      25.598  28.231  31.518  1.00 55.40           C  
ATOM    810  OG1 THR B   6      24.737  28.949  30.623  1.00 55.37           O  
ATOM    811  CG2 THR B   6      27.009  28.157  30.937  1.00 64.79           C  
ATOM    812  N   ILE B   7      24.136  26.884  33.993  1.00 36.33           N  
ATOM    813  CA  ILE B   7      23.083  26.889  34.999  1.00 28.16           C  
ATOM    814  C   ILE B   7      23.475  27.653  36.246  1.00 32.28           C  
ATOM    815  O   ILE B   7      24.645  27.686  36.633  1.00 29.10           O  
ATOM    816  CB  ILE B   7      22.731  25.455  35.431  1.00 32.67           C  
ATOM    817  CG1 ILE B   7      21.658  25.474  36.513  1.00 24.48           C  
ATOM    818  CG2 ILE B   7      23.979  24.759  35.958  1.00 30.30           C  
ATOM    819  CD1 ILE B   7      21.260  24.106  36.975  1.00 32.53           C  
ATOM    820  N   THR B   8      22.475  28.251  36.878  1.00 28.80           N  
ATOM    821  CA  THR B   8      22.669  29.005  38.093  1.00 25.13           C  
ATOM    822  C   THR B   8      21.660  28.474  39.096  1.00 26.67           C  
ATOM    823  O   THR B   8      20.465  28.407  38.812  1.00 30.37           O  
ATOM    824  CB  THR B   8      22.435  30.504  37.842  1.00 24.30           C  
ATOM    825  OG1 THR B   8      23.257  30.925  36.753  1.00 31.90           O  
ATOM    826  CG2 THR B   8      22.818  31.328  39.062  1.00 18.69           C  
ATOM    827  N   ILE B   9      22.145  28.080  40.267  1.00 25.55           N  
ATOM    828  CA  ILE B   9      21.268  27.541  41.297  1.00 28.81           C  
ATOM    829  C   ILE B   9      21.430  28.258  42.625  1.00 37.40           C  
ATOM    830  O   ILE B   9      22.535  28.658  43.002  1.00 31.03           O  
ATOM    831  CB  ILE B   9      21.551  26.051  41.551  1.00 35.70           C  
ATOM    832  CG1 ILE B   9      21.828  25.336  40.227  1.00 54.34           C  
ATOM    833  CG2 ILE B   9      20.347  25.415  42.245  1.00 29.45           C  
ATOM    834  CD1 ILE B   9      22.438  23.954  40.383  1.00 63.88           C  
ATOM    835  N   VAL B  10      20.316  28.420  43.330  1.00 37.45           N  
ATOM    836  CA  VAL B  10      20.314  29.040  44.648  1.00 33.22           C  
ATOM    837  C   VAL B  10      19.561  28.087  45.552  1.00 34.23           C  
ATOM    838  O   VAL B  10      18.396  27.775  45.318  1.00 43.28           O  
ATOM    839  CB  VAL B  10      19.610  30.417  44.651  1.00 42.24           C  
ATOM    840  CG1 VAL B  10      19.391  30.888  46.076  1.00 32.69           C  
ATOM    841  CG2 VAL B  10      20.465  31.438  43.915  1.00 46.32           C  
ATOM    842  N   GLY B  11      20.240  27.608  46.580  1.00 40.76           N  
ATOM    843  CA  GLY B  11      19.610  26.684  47.496  1.00 44.49           C  
ATOM    844  C   GLY B  11      20.391  26.545  48.783  1.00 51.90           C  
ATOM    845  O   GLY B  11      21.138  27.445  49.171  1.00 52.70           O  
ATOM    846  N   ASN B  12      20.215  25.403  49.438  1.00 52.52           N  
ATOM    847  CA  ASN B  12      20.882  25.120  50.698  1.00 47.99           C  
ATOM    848  C   ASN B  12      21.636  23.801  50.621  1.00 46.80           C  
ATOM    849  O   ASN B  12      21.184  22.865  49.963  1.00 42.86           O  
ATOM    850  CB  ASN B  12      19.847  25.044  51.817  1.00 50.64           C  
ATOM    851  CG  ASN B  12      19.190  26.376  52.096  1.00 58.86           C  
ATOM    852  OD1 ASN B  12      19.768  27.233  52.767  1.00 55.86           O  
ATOM    853  ND2 ASN B  12      17.979  26.564  51.575  1.00 53.27           N  
ATOM    854  N   LEU B  13      22.788  23.734  51.282  1.00 33.77           N  
ATOM    855  CA  LEU B  13      23.559  22.507  51.289  1.00 40.73           C  
ATOM    856  C   LEU B  13      22.803  21.444  52.093  1.00 50.34           C  
ATOM    857  O   LEU B  13      22.161  21.746  53.103  1.00 45.76           O  
ATOM    858  CB  LEU B  13      24.942  22.755  51.896  1.00 43.79           C  
ATOM    859  CG  LEU B  13      25.843  23.717  51.107  1.00 59.71           C  
ATOM    860  CD1 LEU B  13      27.259  23.708  51.675  1.00 45.64           C  
ATOM    861  CD2 LEU B  13      25.879  23.297  49.643  1.00 57.00           C  
ATOM    862  N   THR B  14      22.857  20.202  51.625  1.00 53.18           N  
ATOM    863  CA  THR B  14      22.188  19.097  52.300  1.00 47.87           C  
ATOM    864  C   THR B  14      23.107  18.593  53.397  1.00 58.35           C  
ATOM    865  O   THR B  14      22.673  18.341  54.523  1.00 61.51           O  
ATOM    866  CB  THR B  14      21.919  17.948  51.332  1.00 51.37           C  
ATOM    867  OG1 THR B  14      23.164  17.517  50.761  1.00 49.09           O  
ATOM    868  CG2 THR B  14      20.958  18.396  50.227  1.00 37.71           C  
ATOM    869  N   ALA B  15      24.379  18.434  53.040  1.00 55.40           N  
ATOM    870  CA  ALA B  15      25.409  17.987  53.968  1.00 55.72           C  
ATOM    871  C   ALA B  15      26.565  18.956  53.814  1.00 57.42           C  
ATOM    872  O   ALA B  15      26.456  19.938  53.078  1.00 61.47           O  
ATOM    873  CB  ALA B  15      25.862  16.576  53.626  1.00 54.15           C  
ATOM    874  N   ASP B  16      27.668  18.687  54.506  1.00 48.61           N  
ATOM    875  CA  ASP B  16      28.837  19.548  54.418  1.00 52.78           C  
ATOM    876  C   ASP B  16      29.711  19.125  53.269  1.00 50.45           C  
ATOM    877  O   ASP B  16      29.788  17.949  52.931  1.00 53.58           O  
ATOM    878  CB  ASP B  16      29.652  19.495  55.703  1.00 52.75           C  
ATOM    879  CG  ASP B  16      28.975  20.213  56.834  1.00 65.52           C  
ATOM    880  OD1 ASP B  16      27.774  19.957  57.057  1.00 68.20           O  
ATOM    881  OD2 ASP B  16      29.639  21.030  57.501  1.00 69.43           O  
ATOM    882  N   PRO B  17      30.379  20.086  52.638  1.00 45.96           N  
ATOM    883  CA  PRO B  17      31.242  19.719  51.519  1.00 45.82           C  
ATOM    884  C   PRO B  17      32.262  18.642  51.888  1.00 35.45           C  
ATOM    885  O   PRO B  17      33.089  18.828  52.776  1.00 52.21           O  
ATOM    886  CB  PRO B  17      31.888  21.052  51.124  1.00 47.97           C  
ATOM    887  CG  PRO B  17      31.786  21.879  52.383  1.00 57.07           C  
ATOM    888  CD  PRO B  17      30.421  21.533  52.891  1.00 39.01           C  
ATOM    889  N   GLU B  18      32.180  17.507  51.209  1.00 39.94           N  
ATOM    890  CA  GLU B  18      33.109  16.415  51.429  1.00 53.24           C  
ATOM    891  C   GLU B  18      34.306  16.696  50.517  1.00 53.55           C  
ATOM    892  O   GLU B  18      34.134  16.893  49.318  1.00 61.75           O  
ATOM    893  CB  GLU B  18      32.441  15.090  51.050  1.00 63.21           C  
ATOM    894  CG  GLU B  18      33.254  13.850  51.392  1.00 95.15           C  
ATOM    895  CD  GLU B  18      33.514  13.710  52.882  1.00104.87           C  
ATOM    896  OE1 GLU B  18      32.534  13.586  53.650  1.00108.24           O  
ATOM    897  OE2 GLU B  18      34.699  13.726  53.283  1.00109.38           O  
ATOM    898  N   LEU B  19      35.512  16.738  51.079  1.00 53.57           N  
ATOM    899  CA  LEU B  19      36.706  17.005  50.276  1.00 47.38           C  
ATOM    900  C   LEU B  19      37.538  15.744  50.100  1.00 48.75           C  
ATOM    901  O   LEU B  19      37.593  14.899  50.989  1.00 63.37           O  
ATOM    902  CB  LEU B  19      37.579  18.070  50.943  1.00 35.69           C  
ATOM    903  CG  LEU B  19      38.373  19.042  50.064  1.00 48.56           C  
ATOM    904  CD1 LEU B  19      39.440  19.688  50.916  1.00 38.15           C  
ATOM    905  CD2 LEU B  19      39.020  18.337  48.886  1.00 50.91           C  
ATOM    906  N   ARG B  20      38.191  15.636  48.950  1.00 47.90           N  
ATOM    907  CA  ARG B  20      39.047  14.502  48.641  1.00 51.11           C  
ATOM    908  C   ARG B  20      40.082  14.958  47.623  1.00 55.87           C  
ATOM    909  O   ARG B  20      39.797  15.814  46.794  1.00 67.18           O  
ATOM    910  CB  ARG B  20      38.223  13.351  48.075  1.00 43.06           C  
ATOM    911  N   PHE B  21      41.287  14.406  47.690  1.00 55.91           N  
ATOM    912  CA  PHE B  21      42.327  14.781  46.745  1.00 50.45           C  
ATOM    913  C   PHE B  21      42.492  13.697  45.695  1.00 61.13           C  
ATOM    914  O   PHE B  21      42.168  12.536  45.931  1.00 73.59           O  
ATOM    915  CB  PHE B  21      43.652  15.040  47.465  1.00 49.25           C  
ATOM    916  CG  PHE B  21      43.646  16.287  48.293  1.00 48.14           C  
ATOM    917  CD1 PHE B  21      42.979  16.327  49.513  1.00 48.13           C  
ATOM    918  CD2 PHE B  21      44.243  17.452  47.818  1.00 61.65           C  
ATOM    919  CE1 PHE B  21      42.902  17.513  50.248  1.00 52.36           C  
ATOM    920  CE2 PHE B  21      44.172  18.644  48.540  1.00 51.97           C  
ATOM    921  CZ  PHE B  21      43.498  18.675  49.757  1.00 60.28           C  
ATOM    922  N   THR B  22      42.984  14.087  44.527  1.00 71.78           N  
ATOM    923  CA  THR B  22      43.168  13.158  43.423  1.00 70.87           C  
ATOM    924  C   THR B  22      44.587  12.620  43.382  1.00 70.18           C  
ATOM    925  O   THR B  22      45.498  13.212  43.952  1.00 65.73           O  
ATOM    926  CB  THR B  22      42.867  13.843  42.086  1.00 73.90           C  
ATOM    927  OG1 THR B  22      43.835  14.876  41.853  1.00 73.81           O  
ATOM    928  CG2 THR B  22      41.476  14.454  42.114  1.00 67.02           C  
ATOM    929  N   PRO B  23      44.796  11.489  42.694  1.00 68.92           N  
ATOM    930  CA  PRO B  23      46.139  10.918  42.613  1.00 72.53           C  
ATOM    931  C   PRO B  23      47.140  11.927  42.072  1.00 74.20           C  
ATOM    932  O   PRO B  23      48.327  11.881  42.395  1.00 76.55           O  
ATOM    933  CB  PRO B  23      45.947   9.726  41.683  1.00 75.52           C  
ATOM    934  CG  PRO B  23      44.811  10.172  40.802  1.00 76.72           C  
ATOM    935  CD  PRO B  23      43.869  10.768  41.806  1.00 67.85           C  
ATOM    936  N   SER B  24      46.648  12.841  41.246  1.00 68.66           N  
ATOM    937  CA  SER B  24      47.492  13.867  40.655  1.00 77.96           C  
ATOM    938  C   SER B  24      47.806  14.945  41.679  1.00 75.87           C  
ATOM    939  O   SER B  24      48.786  15.676  41.547  1.00 76.29           O  
ATOM    940  CB  SER B  24      46.788  14.489  39.450  1.00 85.54           C  
ATOM    941  OG  SER B  24      45.495  14.949  39.803  1.00 91.40           O  
ATOM    942  N   GLY B  25      46.961  15.034  42.701  1.00 74.58           N  
ATOM    943  CA  GLY B  25      47.150  16.030  43.738  1.00 69.08           C  
ATOM    944  C   GLY B  25      46.049  17.073  43.718  1.00 61.98           C  
ATOM    945  O   GLY B  25      45.857  17.802  44.690  1.00 62.84           O  
ATOM    946  N   ALA B  26      45.322  17.138  42.605  1.00 59.87           N  
ATOM    947  CA  ALA B  26      44.241  18.099  42.468  1.00 51.87           C  
ATOM    948  C   ALA B  26      43.105  17.877  43.451  1.00 51.67           C  
ATOM    949  O   ALA B  26      42.586  16.765  43.575  1.00 34.93           O  
ATOM    950  N   ALA B  27      42.718  18.940  44.152  1.00 45.75           N  
ATOM    951  CA  ALA B  27      41.630  18.862  45.126  1.00 51.79           C  
ATOM    952  C   ALA B  27      40.254  18.823  44.456  1.00 48.96           C  
ATOM    953  O   ALA B  27      40.026  19.468  43.428  1.00 49.30           O  
ATOM    954  CB  ALA B  27      41.707  20.046  46.089  1.00 53.48           C  
ATOM    955  N   VAL B  28      39.338  18.062  45.049  1.00 47.90           N  
ATOM    956  CA  VAL B  28      37.979  17.928  44.525  1.00 46.09           C  
ATOM    957  C   VAL B  28      36.928  17.973  45.621  1.00 42.64           C  
ATOM    958  O   VAL B  28      36.668  16.963  46.269  1.00 44.98           O  
ATOM    959  CB  VAL B  28      37.772  16.595  43.800  1.00 33.33           C  
ATOM    960  CG1 VAL B  28      36.412  16.575  43.180  1.00 22.74           C  
ATOM    961  CG2 VAL B  28      38.848  16.381  42.764  1.00 54.38           C  
ATOM    962  N   ALA B  29      36.323  19.132  45.838  1.00 44.39           N  
ATOM    963  CA  ALA B  29      35.287  19.222  46.850  1.00 41.32           C  
ATOM    964  C   ALA B  29      34.045  18.590  46.245  1.00 42.42           C  
ATOM    965  O   ALA B  29      34.002  18.302  45.054  1.00 38.61           O  
ATOM    966  CB  ALA B  29      35.018  20.667  47.219  1.00 51.32           C  
ATOM    967  N   ASN B  30      33.033  18.371  47.068  1.00 47.99           N  
ATOM    968  CA  ASN B  30      31.810  17.760  46.592  1.00 40.85           C  
ATOM    969  C   ASN B  30      30.675  18.071  47.556  1.00 42.69           C  
ATOM    970  O   ASN B  30      30.885  18.140  48.761  1.00 45.10           O  
ATOM    971  CB  ASN B  30      32.000  16.261  46.489  1.00 50.33           C  
ATOM    972  CG  ASN B  30      30.735  15.555  46.130  1.00 71.96           C  
ATOM    973  OD1 ASN B  30      30.216  15.722  45.028  1.00 92.22           O  
ATOM    974  ND2 ASN B  30      30.210  14.766  47.062  1.00 78.04           N  
ATOM    975  N   PHE B  31      29.473  18.261  47.026  1.00 29.71           N  
ATOM    976  CA  PHE B  31      28.327  18.592  47.861  1.00 35.96           C  
ATOM    977  C   PHE B  31      27.095  18.622  46.989  1.00 41.00           C  
ATOM    978  O   PHE B  31      27.206  18.632  45.760  1.00 50.92           O  
ATOM    979  CB  PHE B  31      28.500  19.979  48.479  1.00 35.15           C  
ATOM    980  CG  PHE B  31      28.572  21.094  47.459  1.00 48.99           C  
ATOM    981  CD1 PHE B  31      29.784  21.432  46.855  1.00 43.42           C  
ATOM    982  CD2 PHE B  31      27.421  21.787  47.084  1.00 53.01           C  
ATOM    983  CE1 PHE B  31      29.845  22.447  45.895  1.00 48.82           C  
ATOM    984  CE2 PHE B  31      27.475  22.804  46.123  1.00 51.66           C  
ATOM    985  CZ  PHE B  31      28.688  23.134  45.528  1.00 42.61           C  
ATOM    986  N   THR B  32      25.919  18.651  47.612  1.00 35.45           N  
ATOM    987  CA  THR B  32      24.694  18.714  46.829  1.00 40.96           C  
ATOM    988  C   THR B  32      23.745  19.774  47.361  1.00 36.08           C  
ATOM    989  O   THR B  32      23.400  19.797  48.543  1.00 29.54           O  
ATOM    990  CB  THR B  32      23.964  17.372  46.782  1.00 35.55           C  
ATOM    991  OG1 THR B  32      22.972  17.342  47.805  1.00 42.31           O  
ATOM    992  CG2 THR B  32      24.938  16.235  46.981  1.00 43.84           C  
ATOM    993  N   VAL B  33      23.330  20.646  46.452  1.00 42.66           N  
ATOM    994  CA  VAL B  33      22.444  21.766  46.739  1.00 35.23           C  
ATOM    995  C   VAL B  33      20.992  21.382  46.580  1.00 35.10           C  
ATOM    996  O   VAL B  33      20.592  20.890  45.524  1.00 36.18           O  
ATOM    997  CB  VAL B  33      22.725  22.933  45.761  1.00 34.47           C  
ATOM    998  CG1 VAL B  33      21.853  24.133  46.103  1.00 32.71           C  
ATOM    999  CG2 VAL B  33      24.195  23.295  45.796  1.00 20.15           C  
ATOM   1000  N   ALA B  34      20.198  21.618  47.619  1.00 40.40           N  
ATOM   1001  CA  ALA B  34      18.773  21.319  47.553  1.00 43.49           C  
ATOM   1002  C   ALA B  34      18.039  22.639  47.414  1.00 45.52           C  
ATOM   1003  O   ALA B  34      18.205  23.522  48.245  1.00 45.23           O  
ATOM   1004  CB  ALA B  34      18.325  20.606  48.805  1.00 42.33           C  
ATOM   1005  N   SER B  35      17.250  22.781  46.354  1.00 49.48           N  
ATOM   1006  CA  SER B  35      16.496  24.011  46.129  1.00 55.95           C  
ATOM   1007  C   SER B  35      15.026  23.702  45.898  1.00 54.73           C  
ATOM   1008  O   SER B  35      14.688  22.866  45.064  1.00 51.55           O  
ATOM   1009  CB  SER B  35      17.052  24.779  44.915  1.00 55.82           C  
ATOM   1010  OG  SER B  35      16.938  24.032  43.712  1.00 57.36           O  
ATOM   1011  N   THR B  36      14.153  24.367  46.648  1.00 68.50           N  
ATOM   1012  CA  THR B  36      12.716  24.160  46.486  1.00 79.40           C  
ATOM   1013  C   THR B  36      12.148  25.447  45.915  1.00 76.82           C  
ATOM   1014  O   THR B  36      12.124  26.470  46.594  1.00 73.25           O  
ATOM   1015  CB  THR B  36      11.997  23.878  47.826  1.00 80.19           C  
ATOM   1016  OG1 THR B  36      12.106  25.032  48.667  1.00 88.87           O  
ATOM   1017  CG2 THR B  36      12.594  22.666  48.532  1.00 81.45           C  
ATOM   1018  N   PRO B  37      11.693  25.416  44.654  1.00 79.99           N  
ATOM   1019  CA  PRO B  37      11.141  26.643  44.080  1.00 86.45           C  
ATOM   1020  C   PRO B  37       9.862  27.055  44.796  1.00 99.18           C  
ATOM   1021  O   PRO B  37       9.303  26.290  45.584  1.00110.04           O  
ATOM   1022  CB  PRO B  37      10.879  26.248  42.636  1.00 77.30           C  
ATOM   1023  CG  PRO B  37      10.487  24.803  42.766  1.00 67.81           C  
ATOM   1024  CD  PRO B  37      11.526  24.279  43.730  1.00 66.58           C  
ATOM   1025  N   ARG B  38       9.415  28.278  44.532  1.00107.50           N  
ATOM   1026  CA  ARG B  38       8.178  28.781  45.107  1.00110.15           C  
ATOM   1027  C   ARG B  38       7.194  28.699  43.942  1.00114.15           C  
ATOM   1028  O   ARG B  38       7.200  29.553  43.056  1.00115.13           O  
ATOM   1029  CB  ARG B  38       8.353  30.221  45.569  1.00103.96           C  
ATOM   1030  N   ILE B  39       6.382  27.642  43.941  1.00117.37           N  
ATOM   1031  CA  ILE B  39       5.394  27.382  42.889  1.00121.02           C  
ATOM   1032  C   ILE B  39       6.077  26.809  41.652  1.00120.21           C  
ATOM   1033  O   ILE B  39       6.129  27.523  40.631  1.00122.64           O  
ATOM   1034  CB  ILE B  39       4.631  28.663  42.522  1.00119.97           C  
ATOM   1035  N   GLU B  51       7.663  20.527  43.910  1.00 74.49           N  
ATOM   1036  CA  GLU B  51       8.879  21.206  44.435  1.00 76.28           C  
ATOM   1037  C   GLU B  51       9.909  20.195  44.935  1.00 75.24           C  
ATOM   1038  O   GLU B  51       9.734  18.982  44.771  1.00 77.18           O  
ATOM   1039  CB  GLU B  51       8.504  22.170  45.571  1.00 80.66           C  
ATOM   1040  CG  GLU B  51       7.974  23.531  45.110  1.00 90.88           C  
ATOM   1041  CD  GLU B  51       6.464  23.579  44.947  1.00100.69           C  
ATOM   1042  OE1 GLU B  51       5.911  22.726  44.221  1.00104.07           O  
ATOM   1043  OE2 GLU B  51       5.827  24.479  45.542  1.00 97.90           O  
ATOM   1044  N   ALA B  52      10.979  20.708  45.541  1.00 69.32           N  
ATOM   1045  CA  ALA B  52      12.068  19.891  46.080  1.00 68.76           C  
ATOM   1046  C   ALA B  52      12.918  19.296  44.959  1.00 65.64           C  
ATOM   1047  O   ALA B  52      12.549  18.296  44.342  1.00 73.62           O  
ATOM   1048  CB  ALA B  52      11.505  18.784  46.964  1.00 76.77           C  
ATOM   1049  N   LEU B  53      14.066  19.916  44.711  1.00 53.97           N  
ATOM   1050  CA  LEU B  53      14.972  19.487  43.655  1.00 46.08           C  
ATOM   1051  C   LEU B  53      16.399  19.452  44.195  1.00 50.08           C  
ATOM   1052  O   LEU B  53      16.926  20.481  44.620  1.00 59.42           O  
ATOM   1053  CB  LEU B  53      14.835  20.466  42.476  1.00 43.13           C  
ATOM   1054  CG  LEU B  53      15.823  20.603  41.313  1.00 42.32           C  
ATOM   1055  CD1 LEU B  53      16.918  21.569  41.710  1.00 42.32           C  
ATOM   1056  CD2 LEU B  53      16.379  19.244  40.907  1.00 47.12           C  
ATOM   1057  N   PHE B  54      17.014  18.267  44.181  1.00 49.98           N  
ATOM   1058  CA  PHE B  54      18.385  18.081  44.688  1.00 40.52           C  
ATOM   1059  C   PHE B  54      19.429  17.968  43.589  1.00 36.53           C  
ATOM   1060  O   PHE B  54      19.387  17.045  42.782  1.00 43.94           O  
ATOM   1061  CB  PHE B  54      18.480  16.820  45.561  1.00 39.91           C  
ATOM   1062  CG  PHE B  54      17.520  16.803  46.716  1.00 45.19           C  
ATOM   1063  CD1 PHE B  54      16.190  16.434  46.529  1.00 48.06           C  
ATOM   1064  CD2 PHE B  54      17.931  17.209  47.983  1.00 37.08           C  
ATOM   1065  CE1 PHE B  54      15.282  16.472  47.583  1.00 50.20           C  
ATOM   1066  CE2 PHE B  54      17.040  17.253  49.042  1.00 37.03           C  
ATOM   1067  CZ  PHE B  54      15.708  16.884  48.844  1.00 50.50           C  
ATOM   1068  N   LEU B  55      20.377  18.894  43.563  1.00 32.93           N  
ATOM   1069  CA  LEU B  55      21.426  18.848  42.554  1.00 32.33           C  
ATOM   1070  C   LEU B  55      22.798  18.672  43.198  1.00 36.31           C  
ATOM   1071  O   LEU B  55      23.198  19.448  44.062  1.00 35.80           O  
ATOM   1072  CB  LEU B  55      21.402  20.115  41.702  1.00 21.33           C  
ATOM   1073  CG  LEU B  55      20.203  20.210  40.764  1.00 34.37           C  
ATOM   1074  CD1 LEU B  55      20.098  21.604  40.191  1.00 42.83           C  
ATOM   1075  CD2 LEU B  55      20.349  19.178  39.664  1.00 35.25           C  
ATOM   1076  N   ARG B  56      23.504  17.633  42.770  1.00 28.15           N  
ATOM   1077  CA  ARG B  56      24.820  17.316  43.290  1.00 28.28           C  
ATOM   1078  C   ARG B  56      25.842  18.068  42.451  1.00 33.26           C  
ATOM   1079  O   ARG B  56      25.844  17.962  41.225  1.00 46.88           O  
ATOM   1080  CB  ARG B  56      25.035  15.803  43.201  1.00 33.50           C  
ATOM   1081  CG  ARG B  56      26.314  15.318  43.826  1.00 47.26           C  
ATOM   1082  CD  ARG B  56      26.438  13.817  43.722  1.00 66.79           C  
ATOM   1083  NE  ARG B  56      27.618  13.342  44.433  1.00 87.01           N  
ATOM   1084  CZ  ARG B  56      27.997  12.071  44.497  1.00 97.08           C  
ATOM   1085  NH1 ARG B  56      27.287  11.129  43.888  1.00103.94           N  
ATOM   1086  NH2 ARG B  56      29.086  11.741  45.179  1.00106.85           N  
ATOM   1087  N   CYS B  57      26.722  18.814  43.106  1.00 28.73           N  
ATOM   1088  CA  CYS B  57      27.713  19.612  42.392  1.00 28.71           C  
ATOM   1089  C   CYS B  57      29.141  19.114  42.594  1.00 32.25           C  
ATOM   1090  O   CYS B  57      29.401  18.314  43.481  1.00 39.32           O  
ATOM   1091  CB  CYS B  57      27.615  21.066  42.872  1.00 34.95           C  
ATOM   1092  SG  CYS B  57      25.921  21.785  42.922  1.00 36.22           S  
ATOM   1093  N   ASN B  58      30.066  19.599  41.767  1.00 37.27           N  
ATOM   1094  CA  ASN B  58      31.488  19.242  41.869  1.00 30.75           C  
ATOM   1095  C   ASN B  58      32.341  20.497  41.642  1.00 40.86           C  
ATOM   1096  O   ASN B  58      31.970  21.369  40.852  1.00 41.22           O  
ATOM   1097  CB  ASN B  58      31.870  18.206  40.810  1.00 41.29           C  
ATOM   1098  CG  ASN B  58      30.956  17.011  40.811  1.00 53.62           C  
ATOM   1099  OD1 ASN B  58      30.824  16.323  41.824  1.00 53.10           O  
ATOM   1100  ND2 ASN B  58      30.317  16.748  39.669  1.00 52.06           N  
ATOM   1101  N   ILE B  59      33.476  20.596  42.328  1.00 39.96           N  
ATOM   1102  CA  ILE B  59      34.370  21.742  42.161  1.00 37.06           C  
ATOM   1103  C   ILE B  59      35.786  21.221  42.213  1.00 49.34           C  
ATOM   1104  O   ILE B  59      36.049  20.202  42.844  1.00 58.55           O  
ATOM   1105  CB  ILE B  59      34.231  22.778  43.292  1.00 41.28           C  
ATOM   1106  CG1 ILE B  59      32.969  22.511  44.104  1.00 52.71           C  
ATOM   1107  CG2 ILE B  59      34.158  24.181  42.710  1.00 27.88           C  
ATOM   1108  CD1 ILE B  59      32.877  23.363  45.342  1.00 59.91           C  
ATOM   1109  N   TRP B  60      36.703  21.926  41.563  1.00 67.18           N  
ATOM   1110  CA  TRP B  60      38.102  21.518  41.543  1.00 67.03           C  
ATOM   1111  C   TRP B  60      39.061  22.609  42.010  1.00 73.09           C  
ATOM   1112  O   TRP B  60      38.651  23.707  42.393  1.00 71.84           O  
ATOM   1113  CB  TRP B  60      38.496  21.081  40.133  1.00 66.55           C  
ATOM   1114  CG  TRP B  60      38.155  19.665  39.812  1.00 82.91           C  
ATOM   1115  CD1 TRP B  60      39.004  18.592  39.812  1.00 85.18           C  
ATOM   1116  CD2 TRP B  60      36.870  19.159  39.448  1.00 83.31           C  
ATOM   1117  NE1 TRP B  60      38.323  17.449  39.466  1.00 77.79           N  
ATOM   1118  CE2 TRP B  60      37.014  17.771  39.234  1.00 84.92           C  
ATOM   1119  CE3 TRP B  60      35.613  19.747  39.275  1.00 92.74           C  
ATOM   1120  CZ2 TRP B  60      35.939  16.959  38.866  1.00101.85           C  
ATOM   1121  CZ3 TRP B  60      34.548  18.942  38.910  1.00100.42           C  
ATOM   1122  CH2 TRP B  60      34.717  17.561  38.703  1.00106.40           C  
ATOM   1123  N   ARG B  61      40.348  22.280  41.972  1.00 78.11           N  
ATOM   1124  CA  ARG B  61      41.414  23.193  42.357  1.00 78.51           C  
ATOM   1125  C   ARG B  61      41.150  23.795  43.736  1.00 72.41           C  
ATOM   1126  O   ARG B  61      40.273  23.321  44.455  1.00 72.36           O  
ATOM   1127  CB  ARG B  61      41.563  24.274  41.283  1.00 88.82           C  
ATOM   1128  CG  ARG B  61      41.514  23.724  39.845  1.00 97.48           C  
ATOM   1129  CD  ARG B  61      42.531  22.593  39.579  1.00111.82           C  
ATOM   1130  NE  ARG B  61      42.414  22.078  38.211  1.00121.94           N  
ATOM   1131  CZ  ARG B  61      43.181  21.127  37.681  1.00122.63           C  
ATOM   1132  NH1 ARG B  61      44.140  20.555  38.395  1.00120.36           N  
ATOM   1133  NH2 ARG B  61      42.985  20.747  36.423  1.00126.98           N  
ATOM   1134  N   GLU B  62      41.900  24.830  44.112  1.00 70.32           N  
ATOM   1135  CA  GLU B  62      41.740  25.429  45.438  1.00 67.81           C  
ATOM   1136  C   GLU B  62      40.324  25.823  45.823  1.00 56.81           C  
ATOM   1137  O   GLU B  62      39.962  25.776  46.997  1.00 58.20           O  
ATOM   1138  CB  GLU B  62      42.679  26.635  45.629  1.00 73.83           C  
ATOM   1139  CG  GLU B  62      42.795  27.600  44.461  1.00 77.50           C  
ATOM   1140  CD  GLU B  62      43.948  27.255  43.528  1.00 75.78           C  
ATOM   1141  OE1 GLU B  62      43.696  26.647  42.468  1.00 72.80           O  
ATOM   1142  OE2 GLU B  62      45.109  27.586  43.860  1.00 69.08           O  
ATOM   1143  N   ALA B  63      39.519  26.211  44.845  1.00 55.74           N  
ATOM   1144  CA  ALA B  63      38.145  26.586  45.133  1.00 42.86           C  
ATOM   1145  C   ALA B  63      37.440  25.411  45.810  1.00 37.09           C  
ATOM   1146  O   ALA B  63      36.435  25.580  46.487  1.00 32.79           O  
ATOM   1147  CB  ALA B  63      37.438  26.962  43.851  1.00 29.16           C  
ATOM   1148  N   ALA B  64      37.977  24.213  45.623  1.00 42.87           N  
ATOM   1149  CA  ALA B  64      37.391  23.033  46.234  1.00 34.06           C  
ATOM   1150  C   ALA B  64      37.649  23.120  47.723  1.00 35.48           C  
ATOM   1151  O   ALA B  64      36.740  22.974  48.544  1.00 42.37           O  
ATOM   1152  CB  ALA B  64      38.020  21.768  45.663  1.00 28.28           C  
ATOM   1153  N   GLU B  65      38.905  23.374  48.064  1.00 35.66           N  
ATOM   1154  CA  GLU B  65      39.318  23.478  49.455  1.00 32.76           C  
ATOM   1155  C   GLU B  65      38.654  24.651  50.156  1.00 39.75           C  
ATOM   1156  O   GLU B  65      38.317  24.561  51.333  1.00 42.96           O  
ATOM   1157  CB  GLU B  65      40.828  23.622  49.528  1.00 26.66           C  
ATOM   1158  CG  GLU B  65      41.549  22.666  48.601  1.00 45.39           C  
ATOM   1159  CD  GLU B  65      43.036  22.870  48.611  1.00 42.10           C  
ATOM   1160  OE1 GLU B  65      43.486  23.984  48.273  1.00 66.79           O  
ATOM   1161  OE2 GLU B  65      43.760  21.918  48.957  1.00 66.40           O  
ATOM   1162  N   ASN B  66      38.462  25.752  49.436  1.00 34.89           N  
ATOM   1163  CA  ASN B  66      37.828  26.918  50.036  1.00 45.10           C  
ATOM   1164  C   ASN B  66      36.406  26.594  50.450  1.00 33.96           C  
ATOM   1165  O   ASN B  66      35.951  26.982  51.525  1.00 39.73           O  
ATOM   1166  CB  ASN B  66      37.832  28.097  49.061  1.00 47.40           C  
ATOM   1167  CG  ASN B  66      39.215  28.677  48.868  1.00 37.27           C  
ATOM   1168  OD1 ASN B  66      39.928  28.904  49.836  1.00 35.16           O  
ATOM   1169  ND2 ASN B  66      39.598  28.925  47.620  1.00 39.22           N  
ATOM   1170  N   VAL B  67      35.714  25.863  49.591  1.00 41.06           N  
ATOM   1171  CA  VAL B  67      34.339  25.466  49.840  1.00 39.38           C  
ATOM   1172  C   VAL B  67      34.228  24.579  51.066  1.00 42.79           C  
ATOM   1173  O   VAL B  67      33.487  24.886  51.997  1.00 48.64           O  
ATOM   1174  CB  VAL B  67      33.776  24.736  48.615  1.00 39.40           C  
ATOM   1175  CG1 VAL B  67      32.583  23.869  48.996  1.00 27.93           C  
ATOM   1176  CG2 VAL B  67      33.395  25.767  47.569  1.00 34.90           C  
ATOM   1177  N   ALA B  68      34.968  23.478  51.064  1.00 45.96           N  
ATOM   1178  CA  ALA B  68      34.943  22.549  52.181  1.00 49.82           C  
ATOM   1179  C   ALA B  68      35.272  23.272  53.482  1.00 52.67           C  
ATOM   1180  O   ALA B  68      34.646  23.039  54.515  1.00 58.23           O  
ATOM   1181  CB  ALA B  68      35.939  21.429  51.938  1.00 50.36           C  
ATOM   1182  N   GLU B  69      36.248  24.166  53.413  1.00 53.43           N  
ATOM   1183  CA  GLU B  69      36.688  24.923  54.575  1.00 51.46           C  
ATOM   1184  C   GLU B  69      35.721  25.981  55.091  1.00 54.38           C  
ATOM   1185  O   GLU B  69      35.629  26.210  56.303  1.00 49.52           O  
ATOM   1186  CB  GLU B  69      38.029  25.592  54.274  1.00 61.90           C  
ATOM   1187  CG  GLU B  69      38.367  26.721  55.233  1.00 73.93           C  
ATOM   1188  CD  GLU B  69      39.811  27.151  55.159  1.00 70.79           C  
ATOM   1189  OE1 GLU B  69      40.174  28.085  55.904  1.00 77.42           O  
ATOM   1190  OE2 GLU B  69      40.578  26.559  54.367  1.00 80.31           O  
ATOM   1191  N   SER B  70      35.004  26.633  54.183  1.00 53.40           N  
ATOM   1192  CA  SER B  70      34.085  27.683  54.599  1.00 49.76           C  
ATOM   1193  C   SER B  70      32.592  27.361  54.628  1.00 39.65           C  
ATOM   1194  O   SER B  70      31.843  28.054  55.303  1.00 47.08           O  
ATOM   1195  CB  SER B  70      34.323  28.939  53.755  1.00 52.00           C  
ATOM   1196  OG  SER B  70      34.106  28.674  52.383  1.00 62.94           O  
ATOM   1197  N   LEU B  71      32.139  26.328  53.927  1.00 39.37           N  
ATOM   1198  CA  LEU B  71      30.707  26.035  53.955  1.00 41.55           C  
ATOM   1199  C   LEU B  71      30.312  24.848  54.838  1.00 44.06           C  
ATOM   1200  O   LEU B  71      31.141  23.996  55.168  1.00 37.56           O  
ATOM   1201  CB  LEU B  71      30.176  25.824  52.535  1.00 45.64           C  
ATOM   1202  CG  LEU B  71      30.322  26.961  51.520  1.00 53.64           C  
ATOM   1203  CD1 LEU B  71      29.450  26.643  50.316  1.00 45.09           C  
ATOM   1204  CD2 LEU B  71      29.907  28.293  52.128  1.00 47.80           C  
ATOM   1205  N   THR B  72      29.035  24.810  55.223  1.00 44.84           N  
ATOM   1206  CA  THR B  72      28.485  23.743  56.069  1.00 54.53           C  
ATOM   1207  C   THR B  72      27.045  23.414  55.661  1.00 50.77           C  
ATOM   1208  O   THR B  72      26.380  24.224  55.016  1.00 45.66           O  
ATOM   1209  CB  THR B  72      28.484  24.140  57.568  1.00 51.44           C  
ATOM   1210  OG1 THR B  72      27.641  25.279  57.761  1.00 65.45           O  
ATOM   1211  CG2 THR B  72      29.892  24.483  58.038  1.00 61.14           C  
ATOM   1212  N   ARG B  73      26.561  22.235  56.046  1.00 57.68           N  
ATOM   1213  CA  ARG B  73      25.202  21.820  55.692  1.00 57.51           C  
ATOM   1214  C   ARG B  73      24.167  22.830  56.159  1.00 46.59           C  
ATOM   1215  O   ARG B  73      24.246  23.336  57.274  1.00 46.68           O  
ATOM   1216  CB  ARG B  73      24.864  20.450  56.290  1.00 60.29           C  
ATOM   1217  CG  ARG B  73      24.709  20.445  57.802  1.00 84.93           C  
ATOM   1218  CD  ARG B  73      23.920  19.227  58.269  1.00 89.71           C  
ATOM   1219  NE  ARG B  73      22.606  19.159  57.632  1.00105.48           N  
ATOM   1220  CZ  ARG B  73      21.663  20.093  57.744  1.00108.97           C  
ATOM   1221  NH1 ARG B  73      21.878  21.179  58.477  1.00108.17           N  
ATOM   1222  NH2 ARG B  73      20.505  19.948  57.112  1.00102.31           N  
ATOM   1223  N   GLY B  74      23.194  23.112  55.298  1.00 45.99           N  
ATOM   1224  CA  GLY B  74      22.149  24.061  55.629  1.00 47.17           C  
ATOM   1225  C   GLY B  74      22.474  25.482  55.201  1.00 52.12           C  
ATOM   1226  O   GLY B  74      21.714  26.412  55.477  1.00 54.42           O  
ATOM   1227  N   ALA B  75      23.604  25.648  54.521  1.00 50.94           N  
ATOM   1228  CA  ALA B  75      24.031  26.962  54.063  1.00 44.62           C  
ATOM   1229  C   ALA B  75      23.402  27.331  52.718  1.00 40.70           C  
ATOM   1230  O   ALA B  75      23.300  26.495  51.819  1.00 49.35           O  
ATOM   1231  CB  ALA B  75      25.556  26.996  53.960  1.00 23.79           C  
ATOM   1232  N   ARG B  76      22.973  28.583  52.593  1.00 35.05           N  
ATOM   1233  CA  ARG B  76      22.376  29.066  51.351  1.00 38.97           C  
ATOM   1234  C   ARG B  76      23.508  29.472  50.409  1.00 44.16           C  
ATOM   1235  O   ARG B  76      24.371  30.295  50.747  1.00 31.44           O  
ATOM   1236  CB  ARG B  76      21.472  30.259  51.630  1.00 31.10           C  
ATOM   1237  CG  ARG B  76      20.407  30.479  50.589  1.00 56.57           C  
ATOM   1238  CD  ARG B  76      19.256  31.288  51.168  1.00 62.93           C  
ATOM   1239  NE  ARG B  76      18.140  31.372  50.236  1.00 73.76           N  
ATOM   1240  CZ  ARG B  76      18.196  32.012  49.075  1.00 67.91           C  
ATOM   1241  NH1 ARG B  76      19.314  32.622  48.713  1.00 62.99           N  
ATOM   1242  NH2 ARG B  76      17.141  32.028  48.274  1.00 73.34           N  
ATOM   1243  N   VAL B  77      23.497  28.893  49.217  1.00 38.57           N  
ATOM   1244  CA  VAL B  77      24.541  29.164  48.257  1.00 33.23           C  
ATOM   1245  C   VAL B  77      24.037  29.560  46.882  1.00 34.09           C  
ATOM   1246  O   VAL B  77      22.889  29.304  46.536  1.00 35.79           O  
ATOM   1247  CB  VAL B  77      25.438  27.932  48.115  1.00 43.21           C  
ATOM   1248  CG1 VAL B  77      26.260  27.762  49.369  1.00  9.94           C  
ATOM   1249  CG2 VAL B  77      24.582  26.687  47.879  1.00 32.09           C  
ATOM   1250  N   ILE B  78      24.915  30.202  46.115  1.00 41.14           N  
ATOM   1251  CA  ILE B  78      24.626  30.633  44.752  1.00 40.24           C  
ATOM   1252  C   ILE B  78      25.649  29.894  43.903  1.00 32.24           C  
ATOM   1253  O   ILE B  78      26.845  30.020  44.127  1.00 35.23           O  
ATOM   1254  CB  ILE B  78      24.837  32.145  44.577  1.00 39.27           C  
ATOM   1255  CG1 ILE B  78      24.222  32.886  45.758  1.00 52.81           C  
ATOM   1256  CG2 ILE B  78      24.182  32.622  43.281  1.00 31.52           C  
ATOM   1257  CD1 ILE B  78      24.374  34.386  45.695  1.00 74.21           C  
ATOM   1258  N   VAL B  79      25.178  29.122  42.933  1.00 30.94           N  
ATOM   1259  CA  VAL B  79      26.061  28.337  42.080  1.00 31.20           C  
ATOM   1260  C   VAL B  79      25.859  28.533  40.582  1.00 33.68           C  
ATOM   1261  O   VAL B  79      24.734  28.506  40.075  1.00 32.92           O  
ATOM   1262  CB  VAL B  79      25.897  26.822  42.369  1.00 29.68           C  
ATOM   1263  CG1 VAL B  79      26.752  25.997  41.413  1.00 39.09           C  
ATOM   1264  CG2 VAL B  79      26.272  26.527  43.796  1.00 31.84           C  
ATOM   1265  N   SER B  80      26.960  28.739  39.873  1.00 27.83           N  
ATOM   1266  CA  SER B  80      26.892  28.858  38.425  1.00 34.43           C  
ATOM   1267  C   SER B  80      27.840  27.786  37.886  1.00 30.78           C  
ATOM   1268  O   SER B  80      28.941  27.579  38.407  1.00 21.47           O  
ATOM   1269  CB  SER B  80      27.324  30.243  37.955  1.00  4.88           C  
ATOM   1270  OG  SER B  80      28.716  30.380  38.039  1.00 39.34           O  
ATOM   1271  N   GLY B  81      27.392  27.078  36.862  1.00 27.94           N  
ATOM   1272  CA  GLY B  81      28.210  26.033  36.289  1.00 19.38           C  
ATOM   1273  C   GLY B  81      27.522  25.395  35.104  1.00 26.71           C  
ATOM   1274  O   GLY B  81      26.553  25.924  34.575  1.00 29.80           O  
ATOM   1275  N   ARG B  82      28.028  24.243  34.696  1.00 38.79           N  
ATOM   1276  CA  ARG B  82      27.483  23.524  33.559  1.00 40.13           C  
ATOM   1277  C   ARG B  82      26.890  22.205  34.003  1.00 37.33           C  
ATOM   1278  O   ARG B  82      27.193  21.694  35.078  1.00 29.62           O  
ATOM   1279  CB  ARG B  82      28.587  23.263  32.533  1.00 42.52           C  
ATOM   1280  CG  ARG B  82      29.158  24.539  31.919  1.00 77.53           C  
ATOM   1281  CD  ARG B  82      30.554  24.314  31.362  1.00 82.09           C  
ATOM   1282  NE  ARG B  82      31.564  25.029  32.139  1.00 88.67           N  
ATOM   1283  CZ  ARG B  82      31.770  24.861  33.444  1.00 92.14           C  
ATOM   1284  NH1 ARG B  82      31.039  23.998  34.134  1.00 83.12           N  
ATOM   1285  NH2 ARG B  82      32.712  25.561  34.064  1.00 91.86           N  
ATOM   1286  N   LEU B  83      26.025  21.655  33.170  1.00 37.50           N  
ATOM   1287  CA  LEU B  83      25.428  20.386  33.497  1.00 39.32           C  
ATOM   1288  C   LEU B  83      26.373  19.263  33.088  1.00 43.86           C  
ATOM   1289  O   LEU B  83      27.289  19.451  32.290  1.00 49.46           O  
ATOM   1290  CB  LEU B  83      24.078  20.242  32.793  1.00 21.69           C  
ATOM   1291  CG  LEU B  83      22.971  21.157  33.319  1.00 27.88           C  
ATOM   1292  CD1 LEU B  83      21.630  20.578  32.921  1.00 32.83           C  
ATOM   1293  CD2 LEU B  83      23.036  21.270  34.837  1.00 11.49           C  
ATOM   1294  N   LYS B  84      26.158  18.097  33.669  1.00 41.06           N  
ATOM   1295  CA  LYS B  84      26.958  16.927  33.364  1.00 42.22           C  
ATOM   1296  C   LYS B  84      26.132  15.738  33.773  1.00 41.56           C  
ATOM   1297  O   LYS B  84      25.262  15.842  34.639  1.00 43.93           O  
ATOM   1298  CB  LYS B  84      28.285  16.931  34.136  1.00 20.32           C  
ATOM   1299  CG  LYS B  84      29.408  17.651  33.418  1.00 50.00           C  
ATOM   1300  CD  LYS B  84      30.769  17.203  33.935  1.00 64.63           C  
ATOM   1301  CE  LYS B  84      31.917  17.834  33.145  1.00 79.92           C  
ATOM   1302  NZ  LYS B  84      33.259  17.534  33.748  1.00 70.05           N  
ATOM   1303  N   GLN B  85      26.383  14.612  33.128  1.00 45.28           N  
ATOM   1304  CA  GLN B  85      25.666  13.389  33.446  1.00 49.22           C  
ATOM   1305  C   GLN B  85      26.666  12.273  33.470  1.00 50.47           C  
ATOM   1306  O   GLN B  85      27.719  12.352  32.843  1.00 60.78           O  
ATOM   1307  CB  GLN B  85      24.660  12.996  32.359  1.00 42.79           C  
ATOM   1308  CG  GLN B  85      23.614  13.990  31.944  1.00 54.57           C  
ATOM   1309  CD  GLN B  85      22.625  13.361  30.974  1.00 54.46           C  
ATOM   1310  OE1 GLN B  85      21.862  12.467  31.339  1.00 73.49           O  
ATOM   1311  NE2 GLN B  85      22.645  13.812  29.733  1.00 67.04           N  
ATOM   1312  N   ARG B  86      26.330  11.225  34.197  1.00 65.35           N  
ATOM   1313  CA  ARG B  86      27.155  10.041  34.190  1.00 81.63           C  
ATOM   1314  C   ARG B  86      26.319   8.860  34.629  1.00 75.99           C  
ATOM   1315  O   ARG B  86      25.323   9.016  35.337  1.00 65.92           O  
ATOM   1316  CB  ARG B  86      28.414  10.180  35.043  1.00 89.26           C  
ATOM   1317  CG  ARG B  86      29.482   9.182  34.576  1.00102.50           C  
ATOM   1318  CD  ARG B  86      29.736   9.314  33.059  1.00105.45           C  
ATOM   1319  NE  ARG B  86      30.204   8.070  32.444  1.00111.17           N  
ATOM   1320  CZ  ARG B  86      30.574   7.951  31.170  1.00112.46           C  
ATOM   1321  NH1 ARG B  86      30.539   9.004  30.363  1.00116.66           N  
ATOM   1322  NH2 ARG B  86      30.975   6.777  30.700  1.00109.19           N  
ATOM   1323  N   SER B  87      26.715   7.683  34.167  1.00 67.96           N  
ATOM   1324  CA  SER B  87      25.994   6.468  34.473  1.00 60.04           C  
ATOM   1325  C   SER B  87      26.230   5.951  35.880  1.00 54.53           C  
ATOM   1326  O   SER B  87      27.309   6.105  36.451  1.00 46.36           O  
ATOM   1327  CB  SER B  87      26.353   5.400  33.464  1.00 61.60           C  
ATOM   1328  N   PHE B  88      25.178   5.359  36.426  1.00 57.36           N  
ATOM   1329  CA  PHE B  88      25.174   4.749  37.747  1.00 64.36           C  
ATOM   1330  C   PHE B  88      24.458   3.426  37.481  1.00 65.02           C  
ATOM   1331  O   PHE B  88      23.767   3.284  36.469  1.00 63.05           O  
ATOM   1332  CB  PHE B  88      24.375   5.610  38.746  1.00 54.25           C  
ATOM   1333  N   GLU B  89      24.615   2.451  38.363  1.00 69.64           N  
ATOM   1334  CA  GLU B  89      23.958   1.180  38.130  1.00 72.27           C  
ATOM   1335  C   GLU B  89      22.858   0.885  39.146  1.00 74.15           C  
ATOM   1336  O   GLU B  89      23.097   0.870  40.349  1.00 79.24           O  
ATOM   1337  CB  GLU B  89      24.986   0.083  38.121  1.00 71.94           C  
ATOM   1338  N   THR B  90      21.650   0.653  38.643  1.00 86.12           N  
ATOM   1339  CA  THR B  90      20.489   0.362  39.479  1.00101.40           C  
ATOM   1340  C   THR B  90      20.652  -0.901  40.333  1.00102.78           C  
ATOM   1341  O   THR B  90      21.699  -1.574  40.212  1.00108.32           O  
ATOM   1342  CB  THR B  90      19.209   0.243  38.601  1.00108.66           C  
ATOM   1343  OG1 THR B  90      18.163  -0.389  39.350  1.00116.71           O  
ATOM   1344  CG2 THR B  90      19.496  -0.552  37.323  1.00112.75           C  
ATOM   1345  N   THR B  97      22.113   6.891  34.281  1.00 55.06           N  
ATOM   1346  CA  THR B  97      22.533   8.308  34.037  1.00 57.88           C  
ATOM   1347  C   THR B  97      21.741   9.332  34.856  1.00 52.70           C  
ATOM   1348  O   THR B  97      20.510   9.348  34.829  1.00 43.97           O  
ATOM   1349  CB  THR B  97      22.409   8.638  32.554  1.00 54.56           C  
ATOM   1350  N   VAL B  98      22.468  10.181  35.581  1.00 47.77           N  
ATOM   1351  CA  VAL B  98      21.879  11.232  36.405  1.00 47.29           C  
ATOM   1352  C   VAL B  98      22.530  12.567  36.049  1.00 51.65           C  
ATOM   1353  O   VAL B  98      23.703  12.603  35.684  1.00 48.54           O  
ATOM   1354  CB  VAL B  98      22.115  10.966  37.905  1.00 54.04           C  
ATOM   1355  CG1 VAL B  98      21.587  12.127  38.738  1.00 57.33           C  
ATOM   1356  CG2 VAL B  98      21.429   9.675  38.310  1.00 78.16           C  
ATOM   1357  N   ILE B  99      21.773  13.658  36.145  1.00 50.63           N  
ATOM   1358  CA  ILE B  99      22.321  14.980  35.842  1.00 48.31           C  
ATOM   1359  C   ILE B  99      23.118  15.459  37.041  1.00 42.03           C  
ATOM   1360  O   ILE B  99      22.779  15.164  38.186  1.00 40.82           O  
ATOM   1361  CB  ILE B  99      21.221  16.038  35.575  1.00 47.93           C  
ATOM   1362  CG1 ILE B  99      20.345  15.619  34.397  1.00 51.01           C  
ATOM   1363  CG2 ILE B  99      21.861  17.384  35.269  1.00 37.94           C  
ATOM   1364  CD1 ILE B  99      19.071  16.435  34.285  1.00 52.63           C  
ATOM   1365  N   GLU B 100      24.184  16.197  36.771  1.00 42.85           N  
ATOM   1366  CA  GLU B 100      25.014  16.743  37.828  1.00 48.32           C  
ATOM   1367  C   GLU B 100      25.541  18.089  37.388  1.00 46.71           C  
ATOM   1368  O   GLU B 100      25.490  18.424  36.205  1.00 44.37           O  
ATOM   1369  CB  GLU B 100      26.161  15.795  38.165  1.00 47.51           C  
ATOM   1370  CG  GLU B 100      25.890  14.976  39.409  1.00 60.51           C  
ATOM   1371  CD  GLU B 100      26.820  13.789  39.540  1.00 74.65           C  
ATOM   1372  OE1 GLU B 100      28.024  13.939  39.236  1.00 81.59           O  
ATOM   1373  OE2 GLU B 100      26.346  12.709  39.955  1.00 77.65           O  
ATOM   1374  N   VAL B 101      26.041  18.858  38.346  1.00 48.26           N  
ATOM   1375  CA  VAL B 101      26.548  20.186  38.067  1.00 38.75           C  
ATOM   1376  C   VAL B 101      28.033  20.389  38.282  1.00 34.30           C  
ATOM   1377  O   VAL B 101      28.564  20.089  39.350  1.00 42.07           O  
ATOM   1378  CB  VAL B 101      25.814  21.239  38.921  1.00 39.43           C  
ATOM   1379  CG1 VAL B 101      26.450  22.611  38.723  1.00 35.97           C  
ATOM   1380  CG2 VAL B 101      24.349  21.272  38.553  1.00 26.76           C  
ATOM   1381  N   GLU B 102      28.680  20.925  37.249  1.00 42.32           N  
ATOM   1382  CA  GLU B 102      30.101  21.275  37.269  1.00 43.07           C  
ATOM   1383  C   GLU B 102      30.145  22.731  37.719  1.00 38.27           C  
ATOM   1384  O   GLU B 102      29.781  23.629  36.966  1.00 46.33           O  
ATOM   1385  CB  GLU B 102      30.710  21.184  35.870  1.00 40.33           C  
ATOM   1386  CG  GLU B 102      31.365  19.872  35.552  1.00 56.67           C  
ATOM   1387  CD  GLU B 102      32.487  19.542  36.508  1.00 65.63           C  
ATOM   1388  OE1 GLU B 102      32.297  18.632  37.353  1.00 58.54           O  
ATOM   1389  OE2 GLU B 102      33.548  20.200  36.412  1.00 60.73           O  
ATOM   1390  N   VAL B 103      30.595  22.965  38.939  1.00 34.42           N  
ATOM   1391  CA  VAL B 103      30.637  24.312  39.466  1.00 36.49           C  
ATOM   1392  C   VAL B 103      31.685  25.200  38.827  1.00 45.58           C  
ATOM   1393  O   VAL B 103      32.859  24.840  38.757  1.00 53.94           O  
ATOM   1394  CB  VAL B 103      30.867  24.289  40.984  1.00 32.51           C  
ATOM   1395  CG1 VAL B 103      30.967  25.705  41.527  1.00 36.67           C  
ATOM   1396  CG2 VAL B 103      29.729  23.546  41.653  1.00 32.53           C  
ATOM   1397  N   ASP B 104      31.235  26.361  38.358  1.00 50.80           N  
ATOM   1398  CA  ASP B 104      32.102  27.368  37.752  1.00 50.19           C  
ATOM   1399  C   ASP B 104      32.597  28.221  38.921  1.00 45.94           C  
ATOM   1400  O   ASP B 104      33.796  28.417  39.114  1.00 38.57           O  
ATOM   1401  CB  ASP B 104      31.303  28.245  36.790  1.00 69.11           C  
ATOM   1402  CG  ASP B 104      31.855  28.221  35.387  1.00 86.82           C  
ATOM   1403  OD1 ASP B 104      33.069  28.437  35.225  1.00105.05           O  
ATOM   1404  OD2 ASP B 104      31.073  27.997  34.441  1.00108.22           O  
ATOM   1405  N   GLU B 105      31.646  28.732  39.695  1.00 42.71           N  
ATOM   1406  CA  GLU B 105      31.942  29.533  40.872  1.00 48.96           C  
ATOM   1407  C   GLU B 105      30.800  29.443  41.862  1.00 44.07           C  
ATOM   1408  O   GLU B 105      29.630  29.447  41.476  1.00 45.39           O  
ATOM   1409  CB  GLU B 105      32.203  30.986  40.494  1.00 45.98           C  
ATOM   1410  CG  GLU B 105      33.574  31.170  39.897  1.00 61.50           C  
ATOM   1411  CD  GLU B 105      33.964  32.608  39.763  1.00 63.88           C  
ATOM   1412  OE1 GLU B 105      34.070  33.289  40.804  1.00 69.41           O  
ATOM   1413  OE2 GLU B 105      34.168  33.053  38.614  1.00 71.74           O  
ATOM   1414  N   ILE B 106      31.158  29.350  43.138  1.00 44.86           N  
ATOM   1415  CA  ILE B 106      30.194  29.238  44.225  1.00 39.13           C  
ATOM   1416  C   ILE B 106      30.476  30.253  45.336  1.00 46.21           C  
ATOM   1417  O   ILE B 106      31.622  30.577  45.629  1.00 47.00           O  
ATOM   1418  CB  ILE B 106      30.216  27.804  44.816  1.00 40.57           C  
ATOM   1419  CG1 ILE B 106      29.481  27.757  46.156  1.00 40.78           C  
ATOM   1420  CG2 ILE B 106      31.650  27.347  45.015  1.00 31.95           C  
ATOM   1421  CD1 ILE B 106      28.037  28.144  46.077  1.00 47.39           C  
ATOM   1422  N   GLY B 107      29.412  30.763  45.942  1.00 51.19           N  
ATOM   1423  CA  GLY B 107      29.560  31.720  47.021  1.00 45.50           C  
ATOM   1424  C   GLY B 107      28.382  31.573  47.957  1.00 39.21           C  
ATOM   1425  O   GLY B 107      27.418  30.898  47.608  1.00 34.33           O  
ATOM   1426  N   PRO B 108      28.433  32.157  49.163  1.00 40.18           N  
ATOM   1427  CA  PRO B 108      27.301  32.031  50.077  1.00 42.49           C  
ATOM   1428  C   PRO B 108      26.414  33.260  49.925  1.00 34.70           C  
ATOM   1429  O   PRO B 108      26.907  34.383  49.865  1.00 35.94           O  
ATOM   1430  CB  PRO B 108      27.965  31.977  51.457  1.00 45.80           C  
ATOM   1431  CG  PRO B 108      29.419  31.741  51.175  1.00 40.27           C  
ATOM   1432  CD  PRO B 108      29.634  32.524  49.919  1.00 52.91           C  
ATOM   1433  N   SER B 109      25.109  33.041  49.855  1.00 27.17           N  
ATOM   1434  CA  SER B 109      24.168  34.140  49.712  1.00 35.08           C  
ATOM   1435  C   SER B 109      24.145  35.066  50.924  1.00 31.77           C  
ATOM   1436  O   SER B 109      24.293  34.628  52.061  1.00 41.31           O  
ATOM   1437  CB  SER B 109      22.761  33.596  49.474  1.00 24.97           C  
ATOM   1438  OG  SER B 109      21.797  34.624  49.572  1.00 45.28           O  
ATOM   1439  N   LEU B 110      23.971  36.355  50.665  1.00 26.52           N  
ATOM   1440  CA  LEU B 110      23.888  37.345  51.721  1.00 37.98           C  
ATOM   1441  C   LEU B 110      22.424  37.787  51.849  1.00 44.41           C  
ATOM   1442  O   LEU B 110      22.130  38.834  52.415  1.00 53.29           O  
ATOM   1443  CB  LEU B 110      24.781  38.548  51.405  1.00 30.10           C  
ATOM   1444  CG  LEU B 110      26.284  38.270  51.241  1.00 38.57           C  
ATOM   1445  CD1 LEU B 110      27.009  39.576  51.018  1.00 32.59           C  
ATOM   1446  CD2 LEU B 110      26.849  37.600  52.471  1.00 28.81           C  
ATOM   1447  N   ARG B 111      21.511  36.969  51.331  1.00 51.21           N  
ATOM   1448  CA  ARG B 111      20.080  37.275  51.383  1.00 62.40           C  
ATOM   1449  C   ARG B 111      19.543  37.176  52.801  1.00 60.32           C  
ATOM   1450  O   ARG B 111      18.667  37.938  53.199  1.00 57.90           O  
ATOM   1451  CB  ARG B 111      19.286  36.309  50.492  1.00 69.50           C  
ATOM   1452  CG  ARG B 111      17.812  36.681  50.334  1.00 72.97           C  
ATOM   1453  CD  ARG B 111      17.071  35.680  49.470  1.00 71.82           C  
ATOM   1454  NE  ARG B 111      15.835  36.224  48.916  1.00 76.72           N  
ATOM   1455  CZ  ARG B 111      15.010  35.538  48.130  1.00 89.42           C  
ATOM   1456  NH1 ARG B 111      15.292  34.284  47.809  1.00 89.44           N  
ATOM   1457  NH2 ARG B 111      13.906  36.103  47.660  1.00100.63           N  
ATOM   1458  N   TYR B 112      20.066  36.215  53.554  1.00 67.46           N  
ATOM   1459  CA  TYR B 112      19.644  36.003  54.929  1.00 53.41           C  
ATOM   1460  C   TYR B 112      20.858  35.847  55.832  1.00 52.78           C  
ATOM   1461  O   TYR B 112      20.724  35.443  56.985  1.00 57.86           O  
ATOM   1462  CB  TYR B 112      18.779  34.744  55.028  1.00 48.63           C  
ATOM   1463  CG  TYR B 112      17.509  34.785  54.207  1.00 51.61           C  
ATOM   1464  CD1 TYR B 112      17.252  33.811  53.233  1.00 55.72           C  
ATOM   1465  CD2 TYR B 112      16.554  35.782  54.408  1.00 47.39           C  
ATOM   1466  CE1 TYR B 112      16.074  33.833  52.476  1.00 41.11           C  
ATOM   1467  CE2 TYR B 112      15.374  35.815  53.658  1.00 47.05           C  
ATOM   1468  CZ  TYR B 112      15.141  34.836  52.699  1.00 49.11           C  
ATOM   1469  OH  TYR B 112      13.983  34.870  51.961  1.00 46.81           O  
ATOM   1470  N   ALA B 113      22.040  36.165  55.313  1.00 54.34           N  
ATOM   1471  CA  ALA B 113      23.263  36.042  56.102  1.00 55.80           C  
ATOM   1472  C   ALA B 113      24.327  37.084  55.774  1.00 53.54           C  
ATOM   1473  O   ALA B 113      24.155  37.915  54.883  1.00 59.38           O  
ATOM   1474  CB  ALA B 113      23.849  34.644  55.933  1.00 56.62           C  
ATOM   1475  N   THR B 114      25.422  37.033  56.522  1.00 43.41           N  
ATOM   1476  CA  THR B 114      26.546  37.937  56.335  1.00 46.21           C  
ATOM   1477  C   THR B 114      27.783  37.057  56.388  1.00 44.56           C  
ATOM   1478  O   THR B 114      27.730  35.930  56.875  1.00 46.51           O  
ATOM   1479  CB  THR B 114      26.647  39.010  57.464  1.00 48.75           C  
ATOM   1480  OG1 THR B 114      27.124  38.404  58.671  1.00 65.86           O  
ATOM   1481  CG2 THR B 114      25.296  39.635  57.735  1.00 41.75           C  
ATOM   1482  N   ALA B 115      28.901  37.562  55.896  1.00 32.57           N  
ATOM   1483  CA  ALA B 115      30.100  36.767  55.909  1.00 31.67           C  
ATOM   1484  C   ALA B 115      31.355  37.616  55.915  1.00 51.68           C  
ATOM   1485  O   ALA B 115      31.397  38.693  55.316  1.00 61.91           O  
ATOM   1486  CB  ALA B 115      30.103  35.843  54.704  1.00 49.16           C  
ATOM   1487  N   LYS B 116      32.370  37.125  56.616  1.00 56.71           N  
ATOM   1488  CA  LYS B 116      33.641  37.816  56.666  1.00 55.12           C  
ATOM   1489  C   LYS B 116      34.461  37.144  55.584  1.00 55.67           C  
ATOM   1490  O   LYS B 116      34.639  35.924  55.607  1.00 49.65           O  
ATOM   1491  N   VAL B 117      34.949  37.930  54.632  1.00 47.17           N  
ATOM   1492  CA  VAL B 117      35.727  37.385  53.531  1.00 45.42           C  
ATOM   1493  C   VAL B 117      37.222  37.680  53.602  1.00 51.79           C  
ATOM   1494  O   VAL B 117      37.633  38.827  53.799  1.00 55.64           O  
ATOM   1495  CB  VAL B 117      35.176  37.896  52.191  1.00 35.27           C  
ATOM   1496  CG1 VAL B 117      35.955  37.309  51.046  1.00 38.70           C  
ATOM   1497  CG2 VAL B 117      33.716  37.527  52.073  1.00 30.12           C  
ATOM   1498  N   ASN B 118      38.023  36.627  53.437  1.00 49.79           N  
ATOM   1499  CA  ASN B 118      39.477  36.723  53.460  1.00 45.53           C  
ATOM   1500  C   ASN B 118      40.059  36.165  52.161  1.00 48.05           C  
ATOM   1501  O   ASN B 118      40.261  34.955  52.017  1.00 40.91           O  
ATOM   1502  CB  ASN B 118      40.040  35.958  54.663  1.00 53.76           C  
ATOM   1503  N   LYS B 119      40.310  37.053  51.208  1.00 42.80           N  
ATOM   1504  CA  LYS B 119      40.875  36.636  49.939  1.00 44.89           C  
ATOM   1505  C   LYS B 119      42.258  36.076  50.224  1.00 56.65           C  
ATOM   1506  O   LYS B 119      42.770  36.211  51.329  1.00 67.60           O  
ATOM   1507  CB  LYS B 119      40.973  37.825  48.993  1.00 35.25           C  
ATOM   1508  N   ALA B 120      42.848  35.432  49.228  1.00 71.56           N  
ATOM   1509  CA  ALA B 120      44.185  34.863  49.339  1.00 77.69           C  
ATOM   1510  C   ALA B 120      44.932  35.421  48.137  1.00 89.94           C  
ATOM   1511  O   ALA B 120      44.512  35.223  46.998  1.00 99.48           O  
ATOM   1512  CB  ALA B 120      44.122  33.347  49.269  1.00 67.46           C  
ATOM   1513  N   SER B 121      46.033  36.122  48.381  1.00 98.49           N  
ATOM   1514  CA  SER B 121      46.777  36.726  47.289  1.00105.51           C  
ATOM   1515  C   SER B 121      47.856  35.890  46.606  1.00110.26           C  
ATOM   1516  O   SER B 121      48.641  35.194  47.242  1.00112.17           O  
ATOM   1517  CB  SER B 121      47.369  38.065  47.744  1.00106.58           C  
ATOM   1518  OG  SER B 121      46.350  39.044  47.889  1.00103.02           O  
ATOM   1519  N   ARG B 122      47.848  35.996  45.282  1.00114.49           N  
ATOM   1520  CA  ARG B 122      48.778  35.349  44.358  1.00115.21           C  
ATOM   1521  C   ARG B 122      47.992  35.184  43.062  1.00118.86           C  
ATOM   1522  O   ARG B 122      47.786  34.082  42.575  1.00122.40           O  
ATOM   1523  CB  ARG B 122      49.276  33.996  44.879  1.00108.82           C  
ATOM   1524  N   SER B 123      47.564  36.330  42.552  1.00121.27           N  
ATOM   1525  CA  SER B 123      46.743  36.487  41.335  1.00124.57           C  
ATOM   1526  C   SER B 123      46.836  35.382  40.312  1.00129.27           C  
ATOM   1527  O   SER B 123      45.895  34.614  40.160  1.00137.58           O  
ATOM   1528  CB  SER B 123      47.031  37.849  40.660  1.00120.96           C  
ATOM   1529  N   GLY B 124      47.968  35.295  39.618  1.00128.38           N  
ATOM   1530  CA  GLY B 124      48.129  34.268  38.599  1.00126.71           C  
ATOM   1531  C   GLY B 124      48.575  32.874  39.022  1.00125.93           C  
ATOM   1532  O   GLY B 124      49.698  32.465  38.723  1.00123.87           O  
ATOM   1533  N   GLY B 125      47.698  32.137  39.702  1.00124.42           N  
ATOM   1534  CA  GLY B 125      48.028  30.783  40.122  1.00120.88           C  
ATOM   1535  C   GLY B 125      48.139  30.563  41.619  1.00116.99           C  
ATOM   1536  O   GLY B 125      47.283  29.849  42.182  1.00110.32           O  
TER    1537      GLY B 125                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
