
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   84 (  661),  selected   84 , name 1txy_B
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1txy_B.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      -       -           -
LGA    T     2_B      M       1          0.472
LGA    N     3_B      N       2          0.433
LGA    R     4_B      T       3          0.227
LGA    L     5_B      L       4          0.450
LGA    V     6_B      E       5          0.625
LGA    L     7_B      L       6          0.877
LGA    S     8_B      S       7          0.778
LGA    G     9_B      A       8          0.646
LGA    T    10_B      R       9          0.586
LGA    V    11_B      V      10          0.670
LGA    C    12_B      L      11          0.682
LGA    R    13_B      E      12          0.878
LGA    A    14_B      C      13          2.141
LGA    P    15_B      G      14          3.084
LGA    L    16_B      A      15          2.209
LGA    R    17_B      M      16          1.479
LGA    K    18_B      R      17          2.217
LGA    P    25_B      H      18          2.916
LGA    -       -      T      19           -
LGA    -       -      P      20           -
LGA    -       -      A      21           -
LGA    -       -      G      22           -
LGA    -       -      L      23           -
LGA    -       -      P      24           -
LGA    H    26_B      A      25          0.646
LGA    C    27_B      L      26          0.525
LGA    Q    28_B      E      27          0.382
LGA    F    29_B      L      28          0.843
LGA    V    30_B      L      29          0.300
LGA    L    31_B      L      30          0.236
LGA    E    32_B      V      31          0.513
LGA    H    33_B      H      32          0.692
LGA    R    34_B      E      33          0.807
LGA    S    35_B      S      34          0.688
LGA    V    36_B      E      35          0.493
LGA    Q    37_B      V      36          0.634
LGA    E    38_B      V      37          1.039
LGA    E    39_B      E      38          1.060
LGA    A    40_B      A      39          1.253
LGA    G    41_B      G      40          1.297
LGA    F    42_B      H      41          1.258
LGA    H    43_B      P      42          1.035
LGA    R    44_B      R      43          0.651
LGA    Q    45_B      R      44          1.041
LGA    A    46_B      V      45          0.958
LGA    W    47_B      E      46          1.421
LGA    C    48_B      L      47          1.141
LGA    Q    49_B      T      48          0.740
LGA    X    50_B      I      49          0.515
LGA    P    51_B      S      50          0.311
LGA    V    52_B      A      51          0.268
LGA    I    53_B      V      52          0.168
LGA    V    54_B      A      53          0.260
LGA    S    55_B      L      54          0.409
LGA    G    56_B      G      55          1.513
LGA    H    57_B      D      56          2.775
LGA    E    58_B      -       -           -
LGA    N    59_B      L      57          1.730
LGA    Q    60_B      A      58          3.423
LGA    A    61_B      L      59          3.618
LGA    I    62_B      L      60          2.081
LGA    T    63_B      L      61          0.738
LGA    H    64_B      A      62          1.715
LGA    S    65_B      D      63          4.359
LGA    I    66_B      T      64          1.175
LGA    T    67_B      P      65          1.899
LGA    V    68_B      L      66          1.038
LGA    G    69_B      G      67          0.482
LGA    S    70_B      T      68          0.579
LGA    R    71_B      E      69          0.469
LGA    I    72_B      M      70          0.352
LGA    T    73_B      Q      71          1.029
LGA    V    74_B      V      72          1.176
LGA    Q    75_B      Q      73          0.591
LGA    G    76_B      G      74          0.308
LGA    F    77_B      F      75          0.245
LGA    I    78_B      L      76          0.329
LGA    S    79_B      A      77          0.659
LGA    C    80_B      P      78          1.191
LGA    H    81_B      A      79          2.141
LGA    -       -      R      80           -
LGA    -       -      K      81           -
LGA    -       -      D      82           -
LGA    -       -      S      83           -
LGA    -       -      V      84           -
LGA    -       -      K      85           -
LGA    X    90_B      V      86          0.998
LGA    V    91_B      K      87          0.371
LGA    L    92_B      L      88          0.143
LGA    H    93_B      H      89          0.289
LGA    A    94_B      L      90          0.249
LGA    E    95_B      Q      91          0.464
LGA    Q    96_B      Q      92          0.614
LGA    I    97_B      A      93          0.711
LGA    E    98_B      R      94          0.634
LGA    -       -      R      95           -
LGA    -       -      I      96           -
LGA    -       -      A      97           -
LGA    -       -      G      98           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   84   98    5.0     82    1.32    25.61     79.798     5.779

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.642891 * X  +   0.699127 * Y  +  -0.312908 * Z  +  -4.346444
  Y_new =  -0.205559 * X  +   0.551012 * Y  +   0.808784 * Z  +  17.633862
  Z_new =   0.737859 * X  +  -0.455639 * Y  +   0.497952 * Z  +   0.580874 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.741055    2.400538  [ DEG:   -42.4593    137.5407 ]
  Theta =  -0.829893   -2.311700  [ DEG:   -47.5494   -132.4506 ]
  Phi   =  -0.309468    2.832124  [ DEG:   -17.7312    162.2688 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1txy_B                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1txy_B.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   84   98   5.0   82   1.32   25.61  79.798
REMARK  ---------------------------------------------------------- 
MOLECULE 1txy_B
HEADER    DNA BINDING PROTEIN                     06-JUL-04   1TXY              
TITLE     E. COLI PRIB                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PRIMOSOMAL REPLICATION PROTEIN N;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PRIB, B4201;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    OB FOLD, DIMER                                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.L.KECK,M.LOPPER,J.M.HOLTON                                          
REVDAT   2   15-MAR-05 1TXY    1       JRNL                                     
REVDAT   1   16-NOV-04 1TXY    0                                                
JRNL        AUTH   M.LOPPER,J.M.HOLTON,J.L.KECK                                 
JRNL        TITL   CRYSTAL STRUCTURE OF PRIB, A COMPONENT OF THE                
JRNL        TITL 2 ESCHERICHIA COLI REPLICATION RESTART PRIMOSOME               
JRNL        REF    STRUCTURE                     V.  12  1967 2004              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1TXY A    2   104  UNP    P07013   PRIB_ECOLI       1    103             
DBREF  1TXY B    2   104  UNP    P07013   PRIB_ECOLI       1    103             
SEQRES   1 A  104  MSE THR ASN ARG LEU VAL LEU SER GLY THR VAL CYS ARG          
SEQRES   2 A  104  ALA PRO LEU ARG LYS VAL SER PRO SER GLY ILE PRO HIS          
SEQRES   3 A  104  CYS GLN PHE VAL LEU GLU HIS ARG SER VAL GLN GLU GLU          
SEQRES   4 A  104  ALA GLY PHE HIS ARG GLN ALA TRP CYS GLN MSE PRO VAL          
SEQRES   5 A  104  ILE VAL SER GLY HIS GLU ASN GLN ALA ILE THR HIS SER          
SEQRES   6 A  104  ILE THR VAL GLY SER ARG ILE THR VAL GLN GLY PHE ILE          
SEQRES   7 A  104  SER CYS HIS LYS ALA LYS ASN GLY LEU SER LYS MSE VAL          
SEQRES   8 A  104  LEU HIS ALA GLU GLN ILE GLU LEU ILE ASP SER GLY ASP          
SEQRES   1 B  104  MSE THR ASN ARG LEU VAL LEU SER GLY THR VAL CYS ARG          
SEQRES   2 B  104  ALA PRO LEU ARG LYS VAL SER PRO SER GLY ILE PRO HIS          
SEQRES   3 B  104  CYS GLN PHE VAL LEU GLU HIS ARG SER VAL GLN GLU GLU          
SEQRES   4 B  104  ALA GLY PHE HIS ARG GLN ALA TRP CYS GLN MSE PRO VAL          
SEQRES   5 B  104  ILE VAL SER GLY HIS GLU ASN GLN ALA ILE THR HIS SER          
SEQRES   6 B  104  ILE THR VAL GLY SER ARG ILE THR VAL GLN GLY PHE ILE          
SEQRES   7 B  104  SER CYS HIS LYS ALA LYS ASN GLY LEU SER LYS MSE VAL          
SEQRES   8 B  104  LEU HIS ALA GLU GLN ILE GLU LEU ILE ASP SER GLY ASP          
HET    MSE  A   1       8                                                       
HET    MSE  A  50       8                                                       
HET    MSE  A  90       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  50       8                                                       
HET    MSE  B  90       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *140(H2 O)                                                    
CRYST1   49.902   60.294   66.304  90.00  90.00  90.00 P 21 21 21    8          
HETATM  716  N   MSE B   1      28.283  22.742  22.806  1.00 22.74           N  
HETATM  717  CA  MSE B   1      27.219  23.786  22.797  1.00 21.39           C  
HETATM  718  C   MSE B   1      26.946  24.277  24.200  1.00 20.12           C  
HETATM  719  O   MSE B   1      27.676  23.947  25.142  1.00 20.69           O  
HETATM  720  CB  MSE B   1      25.942  23.237  22.187  1.00 22.03           C  
HETATM  721  CG  MSE B   1      26.152  22.321  21.003  1.00 22.78           C  
HETATM  722 SE   MSE B   1      24.475  21.794  20.294  1.00 29.09          SE  
HETATM  723  CE  MSE B   1      24.438  22.990  18.723  1.00 26.27           C  
ATOM    724  N   THR B   2      25.894  25.061  24.355  1.00 19.23           N  
ATOM    725  CA  THR B   2      25.561  25.625  25.663  1.00 16.99           C  
ATOM    726  C   THR B   2      25.166  24.571  26.706  1.00 15.54           C  
ATOM    727  O   THR B   2      24.394  23.685  26.437  1.00 14.64           O  
ATOM    728  CB  THR B   2      24.422  26.667  25.542  1.00 17.84           C  
ATOM    729  OG1 THR B   2      24.755  27.650  24.558  1.00 17.73           O  
ATOM    730  CG2 THR B   2      24.322  27.459  26.827  1.00 17.79           C  
ATOM    731  N   ASN B   3      25.763  24.680  27.889  1.00 13.50           N  
ATOM    732  CA  ASN B   3      25.449  23.851  29.029  1.00 13.32           C  
ATOM    733  C   ASN B   3      25.794  24.657  30.276  1.00 13.36           C  
ATOM    734  O   ASN B   3      26.951  24.620  30.762  1.00 12.08           O  
ATOM    735  CB  ASN B   3      26.246  22.539  28.995  1.00 13.17           C  
ATOM    736  CG  ASN B   3      25.917  21.602  30.174  1.00 12.87           C  
ATOM    737  OD1 ASN B   3      25.360  22.008  31.183  1.00  9.16           O  
ATOM    738  ND2 ASN B   3      26.274  20.312  30.023  1.00 11.27           N  
ATOM    739  N   ARG B   4      24.806  25.368  30.800  1.00 11.95           N  
ATOM    740  CA  ARG B   4      25.022  26.246  31.941  1.00 12.87           C  
ATOM    741  C   ARG B   4      23.846  26.212  32.923  1.00 12.74           C  
ATOM    742  O   ARG B   4      22.720  26.576  32.586  1.00 12.29           O  
ATOM    743  CB  ARG B   4      25.224  27.695  31.470  1.00 12.99           C  
ATOM    744  CG  ARG B   4      25.910  28.573  32.516  1.00 17.13           C  
ATOM    745  CD  ARG B   4      26.006  30.048  32.098  1.00 22.59           C  
ATOM    746  NE  ARG B   4      26.264  30.190  30.660  1.00 29.99           N  
ATOM    747  CZ  ARG B   4      25.349  30.575  29.761  1.00 29.19           C  
ATOM    748  NH1 ARG B   4      24.109  30.871  30.138  1.00 30.53           N  
ATOM    749  NH2 ARG B   4      25.671  30.648  28.501  1.00 30.46           N  
ATOM    750  N   LEU B   5      24.130  25.784  34.124  1.00 12.31           N  
ATOM    751  CA  LEU B   5      23.135  25.781  35.196  1.00 12.84           C  
ATOM    752  C   LEU B   5      23.554  26.723  36.298  1.00 13.55           C  
ATOM    753  O   LEU B   5      24.700  26.684  36.745  1.00 12.83           O  
ATOM    754  CB  LEU B   5      22.967  24.381  35.768  1.00 12.38           C  
ATOM    755  CG  LEU B   5      22.122  24.287  37.076  1.00 13.87           C  
ATOM    756  CD1 LEU B   5      20.631  24.705  36.830  1.00 13.40           C  
ATOM    757  CD2 LEU B   5      22.184  22.930  37.632  1.00 16.10           C  
ATOM    758  N   VAL B   6      22.639  27.618  36.692  1.00 13.78           N  
ATOM    759  CA  VAL B   6      22.834  28.479  37.846  1.00 14.70           C  
ATOM    760  C   VAL B   6      21.767  28.051  38.863  1.00 15.33           C  
ATOM    761  O   VAL B   6      20.560  28.094  38.572  1.00 15.57           O  
ATOM    762  CB  VAL B   6      22.706  29.982  37.505  1.00 14.52           C  
ATOM    763  CG1 VAL B   6      22.910  30.846  38.737  1.00 15.96           C  
ATOM    764  CG2 VAL B   6      23.713  30.372  36.439  1.00 15.87           C  
ATOM    765  N   LEU B   7      22.195  27.580  40.026  1.00 14.89           N  
ATOM    766  CA  LEU B   7      21.264  27.066  40.999  1.00 16.10           C  
ATOM    767  C   LEU B   7      21.583  27.530  42.413  1.00 17.46           C  
ATOM    768  O   LEU B   7      22.704  27.353  42.898  1.00 16.17           O  
ATOM    769  CB  LEU B   7      21.233  25.508  40.951  1.00 17.19           C  
ATOM    770  CG  LEU B   7      20.043  24.842  41.636  1.00 17.92           C  
ATOM    771  CD1 LEU B   7      18.742  25.220  40.956  1.00 17.30           C  
ATOM    772  CD2 LEU B   7      20.219  23.324  41.652  1.00 17.34           C  
ATOM    773  N   SER B   8      20.581  28.125  43.081  1.00 17.15           N  
ATOM    774  CA  SER B   8      20.749  28.521  44.469  1.00 19.00           C  
ATOM    775  C   SER B   8      20.093  27.472  45.345  1.00 19.61           C  
ATOM    776  O   SER B   8      19.086  26.881  44.975  1.00 20.31           O  
ATOM    777  CB  SER B   8      20.091  29.884  44.739  1.00 19.43           C  
ATOM    778  OG  SER B   8      20.808  30.924  44.077  1.00 21.22           O  
ATOM    779  N   GLY B   9      20.656  27.234  46.515  1.00 19.15           N  
ATOM    780  CA  GLY B   9      20.070  26.266  47.394  1.00 20.43           C  
ATOM    781  C   GLY B   9      20.747  26.172  48.737  1.00 21.35           C  
ATOM    782  O   GLY B   9      21.606  26.966  49.078  1.00 20.64           O  
ATOM    783  N   THR B  10      20.334  25.185  49.508  1.00 21.75           N  
ATOM    784  CA  THR B  10      20.927  24.926  50.791  1.00 23.84           C  
ATOM    785  C   THR B  10      21.698  23.623  50.753  1.00 23.69           C  
ATOM    786  O   THR B  10      21.287  22.640  50.152  1.00 24.14           O  
ATOM    787  CB  THR B  10      19.834  24.927  51.920  1.00 23.25           C  
ATOM    788  OG1 THR B  10      20.463  24.668  53.180  1.00 25.12           O  
ATOM    789  CG2 THR B  10      18.895  23.757  51.743  1.00 24.46           C  
ATOM    790  N   VAL B  11      22.859  23.635  51.366  1.00 24.61           N  
ATOM    791  CA  VAL B  11      23.671  22.451  51.411  1.00 25.52           C  
ATOM    792  C   VAL B  11      23.006  21.422  52.290  1.00 26.26           C  
ATOM    793  O   VAL B  11      22.776  21.660  53.496  1.00 26.01           O  
ATOM    794  CB  VAL B  11      25.066  22.772  51.936  1.00 25.77           C  
ATOM    795  CG1 VAL B  11      25.939  21.528  51.920  1.00 24.78           C  
ATOM    796  CG2 VAL B  11      25.682  23.894  51.092  1.00 25.66           C  
ATOM    797  N   CYS B  12      22.654  20.284  51.705  1.00 27.14           N  
ATOM    798  CA  CYS B  12      22.011  19.233  52.483  1.00 28.98           C  
ATOM    799  C   CYS B  12      22.960  18.112  52.846  1.00 29.19           C  
ATOM    800  O   CYS B  12      22.683  17.335  53.756  1.00 29.87           O  
ATOM    801  CB  CYS B  12      20.733  18.706  51.800  1.00 29.06           C  
ATOM    802  SG  CYS B  12      20.968  18.122  50.132  1.00 31.04           S  
ATOM    803  N   ARG B  13      24.082  18.035  52.148  1.00 30.02           N  
ATOM    804  CA  ARG B  13      25.127  17.063  52.479  1.00 30.71           C  
ATOM    805  C   ARG B  13      26.457  17.787  52.629  1.00 30.48           C  
ATOM    806  O   ARG B  13      26.950  18.392  51.678  1.00 30.79           O  
ATOM    807  CB  ARG B  13      25.244  15.979  51.408  1.00 30.68           C  
ATOM    808  CG  ARG B  13      25.938  14.717  51.894  1.00 33.40           C  
ATOM    809  CD  ARG B  13      24.999  13.527  52.086  1.00 36.56           C  
ATOM    810  NE  ARG B  13      24.837  12.794  50.832  1.00 38.46           N  
ATOM    811  CZ  ARG B  13      23.666  12.412  50.334  1.00 39.48           C  
ATOM    812  NH1 ARG B  13      22.539  12.678  50.987  1.00 38.21           N  
ATOM    813  NH2 ARG B  13      23.624  11.758  49.179  1.00 40.24           N  
ATOM    814  N   ALA B  14      27.032  17.720  53.827  1.00 30.40           N  
ATOM    815  CA  ALA B  14      28.310  18.383  54.115  1.00 30.58           C  
ATOM    816  C   ALA B  14      29.369  18.041  53.093  1.00 30.23           C  
ATOM    817  O   ALA B  14      29.459  16.903  52.638  1.00 29.85           O  
ATOM    818  CB  ALA B  14      28.788  18.040  55.508  1.00 29.97           C  
ATOM    819  N   PRO B  15      30.158  19.041  52.722  1.00 30.64           N  
ATOM    820  CA  PRO B  15      31.187  18.879  51.700  1.00 30.52           C  
ATOM    821  C   PRO B  15      32.254  17.902  52.148  1.00 30.32           C  
ATOM    822  O   PRO B  15      32.825  18.068  53.232  1.00 30.30           O  
ATOM    823  CB  PRO B  15      31.776  20.285  51.587  1.00 30.62           C  
ATOM    824  CG  PRO B  15      31.498  20.877  52.931  1.00 31.47           C  
ATOM    825  CD  PRO B  15      30.114  20.419  53.242  1.00 30.95           C  
ATOM    826  N   LEU B  16      32.476  16.862  51.354  1.00 29.62           N  
ATOM    827  CA  LEU B  16      33.558  15.934  51.633  1.00 30.00           C  
ATOM    828  C   LEU B  16      34.638  16.128  50.580  1.00 30.55           C  
ATOM    829  O   LEU B  16      34.371  16.040  49.367  1.00 29.99           O  
ATOM    830  CB  LEU B  16      33.058  14.492  51.697  1.00 30.50           C  
ATOM    831  CG  LEU B  16      32.178  13.932  50.595  1.00 30.00           C  
ATOM    832  CD1 LEU B  16      33.043  13.139  49.669  1.00 29.97           C  
ATOM    833  CD2 LEU B  16      31.084  13.042  51.174  1.00 29.26           C  
ATOM    834  N   ARG B  17      35.834  16.471  51.041  1.00 29.59           N  
ATOM    835  CA  ARG B  17      36.937  16.759  50.167  1.00 30.09           C  
ATOM    836  C   ARG B  17      37.604  15.464  49.717  1.00 29.99           C  
ATOM    837  O   ARG B  17      38.395  14.873  50.447  1.00 29.00           O  
ATOM    838  CB  ARG B  17      37.947  17.670  50.872  1.00 30.64           C  
ATOM    839  CG  ARG B  17      37.337  18.965  51.416  1.00 32.88           C  
ATOM    840  CD  ARG B  17      38.052  19.496  52.663  1.00 34.46           C  
ATOM    841  NE  ARG B  17      39.466  19.149  52.644  1.00 36.68           N  
ATOM    842  CZ  ARG B  17      40.436  19.874  53.186  1.00 35.78           C  
ATOM    843  NH1 ARG B  17      40.161  21.010  53.808  1.00 36.23           N  
ATOM    844  NH2 ARG B  17      41.687  19.465  53.100  1.00 36.93           N  
ATOM    845  N   LYS B  18      37.250  15.021  48.514  1.00 29.84           N  
ATOM    846  CA  LYS B  18      37.752  13.784  47.953  1.00 29.98           C  
ATOM    847  C   LYS B  18      39.100  13.985  47.280  1.00 30.35           C  
ATOM    848  O   LYS B  18      39.363  15.031  46.693  1.00 30.07           O  
ATOM    849  CB  LYS B  18      36.757  13.210  46.951  1.00 30.11           C  
ATOM    850  CG  LYS B  18      35.466  12.709  47.556  1.00 31.74           C  
ATOM    851  CD  LYS B  18      35.594  11.274  48.051  1.00 32.28           C  
ATOM    852  CE  LYS B  18      34.230  10.593  48.104  1.00 33.34           C  
ATOM    853  NZ  LYS B  18      34.364   9.111  48.042  1.00 36.25           N  
ATOM    854  N   PRO B  25      41.442  15.929  42.752  1.00 26.24           N  
ATOM    855  CA  PRO B  25      41.206  16.788  43.917  1.00 26.78           C  
ATOM    856  C   PRO B  25      39.905  17.556  43.798  1.00 26.01           C  
ATOM    857  O   PRO B  25      39.843  18.535  43.056  1.00 25.94           O  
ATOM    858  CB  PRO B  25      42.387  17.762  43.867  1.00 27.06           C  
ATOM    859  CG  PRO B  25      43.423  17.049  43.171  1.00 27.45           C  
ATOM    860  CD  PRO B  25      42.731  16.235  42.114  1.00 27.56           C  
ATOM    861  N   HIS B  26      38.870  17.123  44.517  1.00 25.34           N  
ATOM    862  CA  HIS B  26      37.580  17.780  44.413  1.00 24.50           C  
ATOM    863  C   HIS B  26      36.705  17.612  45.654  1.00 23.74           C  
ATOM    864  O   HIS B  26      36.785  16.599  46.353  1.00 22.88           O  
ATOM    865  CB  HIS B  26      36.820  17.274  43.180  1.00 24.35           C  
ATOM    866  CG  HIS B  26      36.392  15.843  43.275  1.00 25.06           C  
ATOM    867  ND1 HIS B  26      37.242  14.793  42.988  1.00 24.72           N  
ATOM    868  CD2 HIS B  26      35.207  15.284  43.628  1.00 24.89           C  
ATOM    869  CE1 HIS B  26      36.593  13.652  43.135  1.00 24.91           C  
ATOM    870  NE2 HIS B  26      35.356  13.919  43.526  1.00 26.23           N  
ATOM    871  N   CYS B  27      35.892  18.628  45.916  1.00 22.05           N  
ATOM    872  CA  CYS B  27      34.919  18.581  46.990  1.00 21.86           C  
ATOM    873  C   CYS B  27      33.581  18.202  46.399  1.00 21.68           C  
ATOM    874  O   CYS B  27      33.226  18.669  45.277  1.00 20.73           O  
ATOM    875  CB  CYS B  27      34.810  19.939  47.665  1.00 22.02           C  
ATOM    876  SG  CYS B  27      33.265  20.200  48.589  1.00 26.50           S  
ATOM    877  N   GLN B  28      32.853  17.351  47.099  1.00 19.87           N  
ATOM    878  CA  GLN B  28      31.532  16.916  46.642  1.00 20.73           C  
ATOM    879  C   GLN B  28      30.516  17.114  47.760  1.00 19.89           C  
ATOM    880  O   GLN B  28      30.830  16.924  48.951  1.00 18.48           O  
ATOM    881  CB  GLN B  28      31.560  15.452  46.210  1.00 21.60           C  
ATOM    882  CG  GLN B  28      30.274  15.000  45.483  1.00 24.25           C  
ATOM    883  CD  GLN B  28      30.355  13.556  44.987  1.00 28.08           C  
ATOM    884  OE1 GLN B  28      31.399  12.917  45.099  1.00 30.22           O  
ATOM    885  NE2 GLN B  28      29.240  13.043  44.437  1.00 32.03           N  
ATOM    886  N   PHE B  29      29.336  17.567  47.391  1.00 18.46           N  
ATOM    887  CA  PHE B  29      28.254  17.751  48.348  1.00 18.73           C  
ATOM    888  C   PHE B  29      26.931  17.735  47.586  1.00 19.53           C  
ATOM    889  O   PHE B  29      26.916  17.568  46.376  1.00 18.20           O  
ATOM    890  CB  PHE B  29      28.431  19.054  49.145  1.00 18.18           C  
ATOM    891  CG  PHE B  29      28.475  20.295  48.306  1.00 17.66           C  
ATOM    892  CD1 PHE B  29      27.304  21.024  48.047  1.00 19.53           C  
ATOM    893  CD2 PHE B  29      29.662  20.752  47.773  1.00 17.87           C  
ATOM    894  CE1 PHE B  29      27.342  22.172  47.249  1.00 17.58           C  
ATOM    895  CE2 PHE B  29      29.709  21.913  46.998  1.00 17.49           C  
ATOM    896  CZ  PHE B  29      28.547  22.617  46.735  1.00 18.10           C  
ATOM    897  N   VAL B  30      25.821  17.867  48.310  1.00 19.29           N  
ATOM    898  CA  VAL B  30      24.528  17.878  47.670  1.00 19.61           C  
ATOM    899  C   VAL B  30      23.842  19.202  47.953  1.00 19.56           C  
ATOM    900  O   VAL B  30      23.898  19.724  49.087  1.00 19.68           O  
ATOM    901  CB  VAL B  30      23.652  16.688  48.130  1.00 19.93           C  
ATOM    902  CG1 VAL B  30      22.287  16.723  47.444  1.00 19.84           C  
ATOM    903  CG2 VAL B  30      24.368  15.372  47.854  1.00 20.17           C  
ATOM    904  N   LEU B  31      23.257  19.779  46.921  1.00 18.88           N  
ATOM    905  CA  LEU B  31      22.560  21.036  47.060  1.00 19.39           C  
ATOM    906  C   LEU B  31      21.057  20.800  46.984  1.00 18.73           C  
ATOM    907  O   LEU B  31      20.569  20.251  46.018  1.00 18.57           O  
ATOM    908  CB  LEU B  31      22.988  22.008  45.947  1.00 19.17           C  
ATOM    909  CG  LEU B  31      22.513  23.447  46.104  1.00 19.62           C  
ATOM    910  CD1 LEU B  31      23.222  24.116  47.257  1.00 19.95           C  
ATOM    911  CD2 LEU B  31      22.738  24.217  44.800  1.00 22.54           C  
ATOM    912  N   GLU B  32      20.339  21.219  48.023  1.00 19.06           N  
ATOM    913  CA  GLU B  32      18.872  21.115  48.011  1.00 19.04           C  
ATOM    914  C   GLU B  32      18.266  22.430  47.545  1.00 17.64           C  
ATOM    915  O   GLU B  32      18.466  23.451  48.171  1.00 17.32           O  
ATOM    916  CB  GLU B  32      18.346  20.742  49.404  1.00 19.47           C  
ATOM    917  CG  GLU B  32      16.834  20.831  49.518  1.00 23.05           C  
ATOM    918  CD  GLU B  32      16.188  19.468  49.729  1.00 29.30           C  
ATOM    919  OE1 GLU B  32      14.976  19.330  49.505  1.00 30.38           O  
ATOM    920  OE2 GLU B  32      16.908  18.522  50.150  1.00 33.03           O  
ATOM    921  N   HIS B  33      17.535  22.402  46.442  1.00 16.71           N  
ATOM    922  CA  HIS B  33      16.917  23.593  45.909  1.00 16.36           C  
ATOM    923  C   HIS B  33      15.394  23.542  46.079  1.00 16.68           C  
ATOM    924  O   HIS B  33      14.769  22.512  45.834  1.00 15.27           O  
ATOM    925  CB  HIS B  33      17.214  23.752  44.399  1.00 16.15           C  
ATOM    926  CG  HIS B  33      16.454  24.873  43.768  1.00 15.26           C  
ATOM    927  ND1 HIS B  33      15.282  24.674  43.070  1.00 17.18           N  
ATOM    928  CD2 HIS B  33      16.667  26.210  43.763  1.00 15.44           C  
ATOM    929  CE1 HIS B  33      14.806  25.831  42.648  1.00 14.42           C  
ATOM    930  NE2 HIS B  33      15.620  26.788  43.061  1.00 17.26           N  
ATOM    931  N   ARG B  34      14.828  24.665  46.524  1.00 16.22           N  
ATOM    932  CA  ARG B  34      13.376  24.809  46.580  1.00 17.22           C  
ATOM    933  C   ARG B  34      13.025  26.251  46.253  1.00 16.95           C  
ATOM    934  O   ARG B  34      13.550  27.177  46.870  1.00 17.06           O  
ATOM    935  CB  ARG B  34      12.840  24.410  47.977  1.00 17.80           C  
ATOM    936  CG  ARG B  34      11.367  24.174  48.003  1.00 19.81           C  
ATOM    937  CD  ARG B  34      10.846  23.431  49.253  1.00 22.24           C  
ATOM    938  NE  ARG B  34      11.678  22.273  49.583  1.00 26.55           N  
ATOM    939  CZ  ARG B  34      11.204  21.076  49.838  1.00 23.99           C  
ATOM    940  NH1 ARG B  34       9.921  20.877  49.791  1.00 27.09           N  
ATOM    941  NH2 ARG B  34      12.013  20.078  50.129  1.00 26.29           N  
ATOM    942  N   SER B  35      12.164  26.439  45.261  1.00 16.67           N  
ATOM    943  CA  SER B  35      11.770  27.771  44.833  1.00 17.58           C  
ATOM    944  C   SER B  35      10.361  27.754  44.234  1.00 17.81           C  
ATOM    945  O   SER B  35       9.788  26.700  44.001  1.00 17.49           O  
ATOM    946  CB  SER B  35      12.746  28.302  43.784  1.00 17.46           C  
ATOM    947  OG  SER B  35      12.545  27.630  42.523  1.00 17.45           O  
ATOM    948  N   VAL B  36       9.825  28.931  43.980  1.00 17.63           N  
ATOM    949  CA  VAL B  36       8.566  29.051  43.272  1.00 18.74           C  
ATOM    950  C   VAL B  36       8.878  29.627  41.910  1.00 19.75           C  
ATOM    951  O   VAL B  36       9.570  30.626  41.805  1.00 20.18           O  
ATOM    952  CB  VAL B  36       7.579  29.982  44.014  1.00 18.81           C  
ATOM    953  CG1 VAL B  36       6.199  29.942  43.362  1.00 18.80           C  
ATOM    954  CG2 VAL B  36       7.499  29.597  45.470  1.00 18.88           C  
ATOM    955  N   GLN B  37       8.365  28.988  40.862  1.00 20.63           N  
ATOM    956  CA  GLN B  37       8.621  29.405  39.504  1.00 22.44           C  
ATOM    957  C   GLN B  37       7.308  29.677  38.788  1.00 23.73           C  
ATOM    958  O   GLN B  37       6.259  29.139  39.150  1.00 23.84           O  
ATOM    959  CB  GLN B  37       9.432  28.322  38.749  1.00 21.22           C  
ATOM    960  CG  GLN B  37      10.804  28.042  39.339  1.00 21.98           C  
ATOM    961  CD  GLN B  37      11.748  29.216  39.194  1.00 22.45           C  
ATOM    962  OE1 GLN B  37      11.606  30.007  38.260  1.00 22.84           O  
ATOM    963  NE2 GLN B  37      12.684  29.352  40.121  1.00 19.92           N  
ATOM    964  N   GLU B  38       7.364  30.514  37.767  1.00 25.74           N  
ATOM    965  CA  GLU B  38       6.175  30.904  37.024  1.00 27.16           C  
ATOM    966  C   GLU B  38       6.030  30.052  35.763  1.00 28.00           C  
ATOM    967  O   GLU B  38       6.997  29.845  35.037  1.00 28.78           O  
ATOM    968  CB  GLU B  38       6.246  32.379  36.658  1.00 27.63           C  
ATOM    969  CG  GLU B  38       4.965  32.909  36.017  1.00 29.75           C  
ATOM    970  CD  GLU B  38       5.060  34.383  35.638  1.00 32.20           C  
ATOM    971  OE1 GLU B  38       6.112  35.009  35.902  1.00 33.23           O  
ATOM    972  OE2 GLU B  38       4.081  34.916  35.078  1.00 33.11           O  
ATOM    973  N   GLU B  39       4.820  29.568  35.513  1.00 28.72           N  
ATOM    974  CA  GLU B  39       4.596  28.676  34.389  1.00 29.86           C  
ATOM    975  C   GLU B  39       3.160  28.619  33.940  1.00 28.92           C  
ATOM    976  O   GLU B  39       2.274  28.274  34.710  1.00 29.38           O  
ATOM    977  CB  GLU B  39       5.087  27.260  34.733  1.00 29.65           C  
ATOM    978  CG  GLU B  39       5.064  26.302  33.549  1.00 31.24           C  
ATOM    979  CD  GLU B  39       5.514  24.910  33.943  1.00 31.52           C  
ATOM    980  OE1 GLU B  39       5.777  24.705  35.136  1.00 35.67           O  
ATOM    981  OE2 GLU B  39       5.605  24.034  33.073  1.00 34.44           O  
ATOM    982  N   ALA B  40       2.935  28.929  32.671  1.00 29.77           N  
ATOM    983  CA  ALA B  40       1.596  28.860  32.087  1.00 29.24           C  
ATOM    984  C   ALA B  40       0.537  29.558  32.944  1.00 29.76           C  
ATOM    985  O   ALA B  40      -0.523  28.997  33.223  1.00 29.95           O  
ATOM    986  CB  ALA B  40       1.210  27.423  31.833  1.00 29.06           C  
ATOM    987  N   GLY B  41       0.838  30.780  33.361  1.00 30.00           N  
ATOM    988  CA  GLY B  41      -0.117  31.605  34.083  1.00 30.18           C  
ATOM    989  C   GLY B  41      -0.148  31.350  35.571  1.00 30.40           C  
ATOM    990  O   GLY B  41      -0.847  32.036  36.316  1.00 30.75           O  
ATOM    991  N   PHE B  42       0.673  30.398  36.010  1.00 30.45           N  
ATOM    992  CA  PHE B  42       0.594  29.904  37.371  1.00 30.52           C  
ATOM    993  C   PHE B  42       1.933  29.817  38.051  1.00 30.01           C  
ATOM    994  O   PHE B  42       2.974  29.809  37.407  1.00 30.32           O  
ATOM    995  CB  PHE B  42      -0.055  28.517  37.377  1.00 30.46           C  
ATOM    996  CG  PHE B  42      -1.446  28.497  36.816  1.00 31.80           C  
ATOM    997  CD1 PHE B  42      -1.658  28.309  35.463  1.00 33.14           C  
ATOM    998  CD2 PHE B  42      -2.540  28.662  37.639  1.00 33.02           C  
ATOM    999  CE1 PHE B  42      -2.937  28.290  34.941  1.00 33.62           C  
ATOM   1000  CE2 PHE B  42      -3.823  28.645  37.128  1.00 33.30           C  
ATOM   1001  CZ  PHE B  42      -4.023  28.462  35.774  1.00 34.30           C  
ATOM   1002  N   HIS B  43       1.896  29.752  39.378  1.00 29.88           N  
ATOM   1003  CA  HIS B  43       3.103  29.605  40.153  1.00 29.58           C  
ATOM   1004  C   HIS B  43       3.240  28.154  40.541  1.00 29.16           C  
ATOM   1005  O   HIS B  43       2.352  27.588  41.157  1.00 29.60           O  
ATOM   1006  CB  HIS B  43       3.063  30.509  41.372  1.00 29.71           C  
ATOM   1007  CG  HIS B  43       2.880  31.948  41.027  1.00 30.33           C  
ATOM   1008  ND1 HIS B  43       3.906  32.731  40.543  1.00 31.82           N  
ATOM   1009  CD2 HIS B  43       1.782  32.732  41.036  1.00 30.35           C  
ATOM   1010  CE1 HIS B  43       3.449  33.940  40.284  1.00 29.95           C  
ATOM   1011  NE2 HIS B  43       2.166  33.970  40.585  1.00 31.63           N  
ATOM   1012  N   ARG B  44       4.345  27.551  40.138  1.00 28.33           N  
ATOM   1013  CA  ARG B  44       4.585  26.147  40.411  1.00 27.79           C  
ATOM   1014  C   ARG B  44       5.885  26.002  41.177  1.00 25.50           C  
ATOM   1015  O   ARG B  44       6.892  26.593  40.823  1.00 26.18           O  
ATOM   1016  CB  ARG B  44       4.594  25.342  39.110  1.00 27.81           C  
ATOM   1017  CG  ARG B  44       3.281  25.401  38.344  1.00 30.00           C  
ATOM   1018  CD  ARG B  44       2.177  24.594  39.025  1.00 33.67           C  
ATOM   1019  NE  ARG B  44       1.138  25.456  39.580  1.00 36.25           N  
ATOM   1020  CZ  ARG B  44       0.072  25.018  40.241  1.00 37.79           C  
ATOM   1021  NH1 ARG B  44      -0.107  23.718  40.434  1.00 40.45           N  
ATOM   1022  NH2 ARG B  44      -0.821  25.878  40.706  1.00 37.58           N  
ATOM   1023  N   GLN B  45       5.846  25.240  42.252  1.00 23.62           N  
ATOM   1024  CA  GLN B  45       7.039  25.029  43.054  1.00 22.77           C  
ATOM   1025  C   GLN B  45       8.013  24.135  42.312  1.00 21.39           C  
ATOM   1026  O   GLN B  45       7.601  23.288  41.526  1.00 19.88           O  
ATOM   1027  CB  GLN B  45       6.671  24.448  44.413  1.00 23.80           C  
ATOM   1028  CG  GLN B  45       5.742  25.353  45.247  1.00 25.96           C  
ATOM   1029  CD  GLN B  45       5.532  24.830  46.645  1.00 29.40           C  
ATOM   1030  OE1 GLN B  45       6.072  23.794  47.005  1.00 33.78           O  
ATOM   1031  NE2 GLN B  45       4.759  25.569  47.454  1.00 33.35           N  
ATOM   1032  N   ALA B  46       9.312  24.340  42.564  1.00 19.49           N  
ATOM   1033  CA  ALA B  46      10.334  23.534  41.931  1.00 19.75           C  
ATOM   1034  C   ALA B  46      11.273  23.049  43.015  1.00 19.22           C  
ATOM   1035  O   ALA B  46      11.594  23.802  43.936  1.00 19.21           O  
ATOM   1036  CB  ALA B  46      11.100  24.359  40.892  1.00 18.89           C  
ATOM   1037  N   TRP B  47      11.685  21.810  42.921  1.00 18.15           N  
ATOM   1038  CA  TRP B  47      12.546  21.203  43.921  1.00 18.34           C  
ATOM   1039  C   TRP B  47      13.522  20.234  43.236  1.00 19.05           C  
ATOM   1040  O   TRP B  47      13.154  19.539  42.306  1.00 17.70           O  
ATOM   1041  CB  TRP B  47      11.706  20.439  44.937  1.00 18.65           C  
ATOM   1042  CG  TRP B  47      12.517  19.568  45.870  1.00 19.29           C  
ATOM   1043  CD1 TRP B  47      13.055  19.933  47.084  1.00 20.47           C  
ATOM   1044  CD2 TRP B  47      12.871  18.198  45.672  1.00 18.83           C  
ATOM   1045  NE1 TRP B  47      13.731  18.867  47.636  1.00 20.68           N  
ATOM   1046  CE2 TRP B  47      13.636  17.791  46.788  1.00 20.42           C  
ATOM   1047  CE3 TRP B  47      12.623  17.268  44.663  1.00 19.93           C  
ATOM   1048  CZ2 TRP B  47      14.145  16.500  46.916  1.00 22.02           C  
ATOM   1049  CZ3 TRP B  47      13.125  15.975  44.797  1.00 22.15           C  
ATOM   1050  CH2 TRP B  47      13.881  15.607  45.908  1.00 22.04           C  
ATOM   1051  N   CYS B  48      14.746  20.181  43.757  1.00 18.73           N  
ATOM   1052  CA  CYS B  48      15.760  19.257  43.260  1.00 21.49           C  
ATOM   1053  C   CYS B  48      16.798  19.048  44.358  1.00 21.05           C  
ATOM   1054  O   CYS B  48      17.039  19.944  45.167  1.00 21.79           O  
ATOM   1055  CB  CYS B  48      16.494  19.904  42.076  1.00 21.71           C  
ATOM   1056  SG  CYS B  48      16.226  19.269  40.376  1.00 32.31           S  
ATOM   1057  N   GLN B  49      17.385  17.869  44.398  1.00 20.53           N  
ATOM   1058  CA  GLN B  49      18.552  17.619  45.236  1.00 20.98           C  
ATOM   1059  C   GLN B  49      19.704  17.321  44.283  1.00 20.65           C  
ATOM   1060  O   GLN B  49      19.772  16.239  43.715  1.00 20.90           O  
ATOM   1061  CB  GLN B  49      18.320  16.451  46.182  1.00 20.93           C  
ATOM   1062  CG  GLN B  49      18.073  16.892  47.612  1.00 24.02           C  
ATOM   1063  CD  GLN B  49      17.711  15.747  48.541  1.00 25.73           C  
ATOM   1064  OE1 GLN B  49      17.557  14.604  48.100  1.00 25.34           O  
ATOM   1065  NE2 GLN B  49      17.556  16.054  49.835  1.00 26.25           N  
HETATM 1066  N   MSE B  50      20.579  18.296  44.101  1.00 18.98           N  
HETATM 1067  CA  MSE B  50      21.617  18.222  43.070  1.00 19.39           C  
HETATM 1068  C   MSE B  50      23.004  17.921  43.616  1.00 18.27           C  
HETATM 1069  O   MSE B  50      23.554  18.695  44.367  1.00 18.31           O  
HETATM 1070  CB  MSE B  50      21.680  19.561  42.321  1.00 19.60           C  
HETATM 1071  CG  MSE B  50      22.780  19.627  41.257  1.00 20.96           C  
HETATM 1072 SE   MSE B  50      22.278  18.719  39.608  1.00 20.44          SE  
HETATM 1073  CE  MSE B  50      20.852  19.892  39.124  1.00 22.18           C  
ATOM   1074  N   PRO B  51      23.574  16.801  43.198  1.00 18.17           N  
ATOM   1075  CA  PRO B  51      24.960  16.488  43.517  1.00 17.71           C  
ATOM   1076  C   PRO B  51      25.854  17.523  42.842  1.00 17.51           C  
ATOM   1077  O   PRO B  51      25.639  17.808  41.663  1.00 16.54           O  
ATOM   1078  CB  PRO B  51      25.169  15.110  42.882  1.00 17.94           C  
ATOM   1079  CG  PRO B  51      23.811  14.583  42.654  1.00 17.23           C  
ATOM   1080  CD  PRO B  51      22.955  15.778  42.348  1.00 18.20           C  
ATOM   1081  N   VAL B  52      26.835  18.074  43.579  1.00 16.02           N  
ATOM   1082  CA  VAL B  52      27.697  19.093  43.026  1.00 16.79           C  
ATOM   1083  C   VAL B  52      29.151  18.691  43.199  1.00 16.93           C  
ATOM   1084  O   VAL B  52      29.531  18.139  44.247  1.00 16.57           O  
ATOM   1085  CB  VAL B  52      27.494  20.482  43.716  1.00 17.36           C  
ATOM   1086  CG1 VAL B  52      28.556  21.482  43.242  1.00 16.33           C  
ATOM   1087  CG2 VAL B  52      26.092  21.016  43.445  1.00 18.05           C  
ATOM   1088  N   ILE B  53      29.944  18.904  42.165  1.00 17.01           N  
ATOM   1089  CA  ILE B  53      31.360  18.615  42.226  1.00 18.35           C  
ATOM   1090  C   ILE B  53      32.133  19.871  41.915  1.00 19.12           C  
ATOM   1091  O   ILE B  53      31.913  20.529  40.889  1.00 17.16           O  
ATOM   1092  CB  ILE B  53      31.727  17.483  41.242  1.00 18.72           C  
ATOM   1093  CG1 ILE B  53      31.256  16.138  41.808  1.00 19.02           C  
ATOM   1094  CG2 ILE B  53      33.228  17.471  40.989  1.00 19.16           C  
ATOM   1095  CD1 ILE B  53      31.302  15.015  40.849  1.00 20.96           C  
ATOM   1096  N   VAL B  54      33.042  20.216  42.822  1.00 19.16           N  
ATOM   1097  CA  VAL B  54      33.897  21.374  42.623  1.00 20.44           C  
ATOM   1098  C   VAL B  54      35.340  20.929  42.562  1.00 21.69           C  
ATOM   1099  O   VAL B  54      35.879  20.452  43.552  1.00 20.68           O  
ATOM   1100  CB  VAL B  54      33.744  22.367  43.768  1.00 21.05           C  
ATOM   1101  CG1 VAL B  54      34.506  23.663  43.464  1.00 21.59           C  
ATOM   1102  CG2 VAL B  54      32.282  22.659  44.016  1.00 21.13           C  
ATOM   1103  N   SER B  55      35.943  21.021  41.373  1.00 22.05           N  
ATOM   1104  CA  SER B  55      37.343  20.728  41.210  1.00 24.31           C  
ATOM   1105  C   SER B  55      38.027  21.986  40.708  1.00 25.00           C  
ATOM   1106  O   SER B  55      37.525  22.677  39.836  1.00 26.72           O  
ATOM   1107  CB  SER B  55      37.597  19.545  40.270  1.00 24.72           C  
ATOM   1108  OG  SER B  55      36.535  19.337  39.381  1.00 24.92           O  
ATOM   1109  N   GLY B  56      39.165  22.280  41.262  1.00 26.24           N  
ATOM   1110  CA  GLY B  56      39.825  23.528  40.973  1.00 27.37           C  
ATOM   1111  C   GLY B  56      40.182  24.146  42.292  1.00 27.00           C  
ATOM   1112  O   GLY B  56      39.296  24.451  43.096  1.00 27.19           O  
ATOM   1113  N   HIS B  57      41.472  24.322  42.514  1.00 27.18           N  
ATOM   1114  CA  HIS B  57      41.994  24.860  43.751  1.00 27.70           C  
ATOM   1115  C   HIS B  57      41.506  26.273  43.991  1.00 27.63           C  
ATOM   1116  O   HIS B  57      41.557  26.757  45.110  1.00 28.29           O  
ATOM   1117  CB  HIS B  57      43.521  24.845  43.720  1.00 27.77           C  
ATOM   1118  CG  HIS B  57      44.106  25.950  42.904  1.00 28.46           C  
ATOM   1119  ND1 HIS B  57      44.157  25.910  41.527  1.00 28.28           N  
ATOM   1120  CD2 HIS B  57      44.643  27.140  43.270  1.00 29.48           C  
ATOM   1121  CE1 HIS B  57      44.735  27.014  41.082  1.00 30.60           C  
ATOM   1122  NE2 HIS B  57      45.042  27.775  42.119  1.00 29.46           N  
ATOM   1123  N   GLU B  58      41.080  26.944  42.930  1.00 28.51           N  
ATOM   1124  CA  GLU B  58      40.572  28.315  43.025  1.00 29.81           C  
ATOM   1125  C   GLU B  58      39.382  28.373  43.982  1.00 30.42           C  
ATOM   1126  O   GLU B  58      39.265  29.290  44.766  1.00 30.40           O  
ATOM   1127  CB  GLU B  58      40.169  28.852  41.645  1.00 30.04           C  
ATOM   1128  CG  GLU B  58      39.033  28.105  40.968  1.00 30.67           C  
ATOM   1129  CD  GLU B  58      39.525  27.072  39.978  1.00 31.86           C  
ATOM   1130  OE1 GLU B  58      40.515  26.367  40.301  1.00 31.08           O  
ATOM   1131  OE2 GLU B  58      38.941  26.986  38.871  1.00 30.61           O  
ATOM   1132  N   ASN B  59      38.516  27.374  43.901  1.00 31.03           N  
ATOM   1133  CA  ASN B  59      37.363  27.288  44.771  1.00 32.98           C  
ATOM   1134  C   ASN B  59      37.544  26.180  45.792  1.00 33.87           C  
ATOM   1135  O   ASN B  59      36.843  25.159  45.740  1.00 35.06           O  
ATOM   1136  CB  ASN B  59      36.088  26.975  43.973  1.00 32.26           C  
ATOM   1137  CG  ASN B  59      35.850  27.928  42.866  1.00 33.31           C  
ATOM   1138  OD1 ASN B  59      35.725  27.523  41.706  1.00 36.27           O  
ATOM   1139  ND2 ASN B  59      35.759  29.209  43.195  1.00 33.30           N  
ATOM   1140  N   GLN B  60      38.491  26.343  46.696  1.00 34.40           N  
ATOM   1141  CA  GLN B  60      38.682  25.347  47.732  1.00 34.61           C  
ATOM   1142  C   GLN B  60      38.680  25.996  49.099  1.00 34.54           C  
ATOM   1143  O   GLN B  60      38.523  25.327  50.108  1.00 35.41           O  
ATOM   1144  CB  GLN B  60      39.940  24.506  47.479  1.00 35.00           C  
ATOM   1145  CG  GLN B  60      39.876  23.667  46.175  1.00 36.19           C  
ATOM   1146  CD  GLN B  60      39.215  22.294  46.364  1.00 38.04           C  
ATOM   1147  OE1 GLN B  60      39.010  21.845  47.491  1.00 39.47           O  
ATOM   1148  NE2 GLN B  60      38.889  21.637  45.263  1.00 38.89           N  
ATOM   1149  N   ALA B  61      38.835  27.312  49.134  1.00 34.77           N  
ATOM   1150  CA  ALA B  61      38.731  28.037  50.396  1.00 34.54           C  
ATOM   1151  C   ALA B  61      37.270  28.167  50.767  1.00 34.41           C  
ATOM   1152  O   ALA B  61      36.865  27.846  51.883  1.00 34.46           O  
ATOM   1153  CB  ALA B  61      39.380  29.414  50.283  1.00 34.93           C  
ATOM   1154  N   ILE B  62      36.468  28.627  49.809  1.00 34.16           N  
ATOM   1155  CA  ILE B  62      35.036  28.795  50.015  1.00 33.88           C  
ATOM   1156  C   ILE B  62      34.364  27.470  50.333  1.00 33.44           C  
ATOM   1157  O   ILE B  62      33.510  27.398  51.204  1.00 32.49           O  
ATOM   1158  CB  ILE B  62      34.388  29.420  48.765  1.00 34.41           C  
ATOM   1159  CG1 ILE B  62      34.987  28.824  47.498  1.00 34.72           C  
ATOM   1160  CG2 ILE B  62      34.571  30.915  48.758  1.00 34.02           C  
ATOM   1161  CD1 ILE B  62      34.453  29.442  46.238  1.00 35.98           C  
ATOM   1162  N   THR B  63      34.780  26.423  49.625  1.00 33.27           N  
ATOM   1163  CA  THR B  63      34.217  25.089  49.788  1.00 34.12           C  
ATOM   1164  C   THR B  63      34.296  24.575  51.222  1.00 34.28           C  
ATOM   1165  O   THR B  63      33.330  24.050  51.756  1.00 34.73           O  
ATOM   1166  CB  THR B  63      34.921  24.104  48.854  1.00 34.70           C  
ATOM   1167  OG1 THR B  63      34.302  24.140  47.562  1.00 34.60           O  
ATOM   1168  CG2 THR B  63      34.689  22.687  49.307  1.00 35.75           C  
ATOM   1169  N   HIS B  64      35.446  24.746  51.845  1.00 34.37           N  
ATOM   1170  CA  HIS B  64      35.677  24.171  53.167  1.00 34.92           C  
ATOM   1171  C   HIS B  64      35.059  24.975  54.313  1.00 34.76           C  
ATOM   1172  O   HIS B  64      35.100  24.560  55.464  1.00 34.65           O  
ATOM   1173  CB  HIS B  64      37.164  23.917  53.365  1.00 35.54           C  
ATOM   1174  CG  HIS B  64      37.798  23.221  52.199  1.00 35.77           C  
ATOM   1175  ND1 HIS B  64      38.773  22.255  52.342  1.00 36.63           N  
ATOM   1176  CD2 HIS B  64      37.567  23.328  50.869  1.00 36.95           C  
ATOM   1177  CE1 HIS B  64      39.135  21.817  51.147  1.00 36.99           C  
ATOM   1178  NE2 HIS B  64      38.411  22.447  50.237  1.00 38.34           N  
ATOM   1179  N   SER B  65      34.463  26.112  53.971  1.00 34.80           N  
ATOM   1180  CA  SER B  65      33.707  26.899  54.925  1.00 34.59           C  
ATOM   1181  C   SER B  65      32.294  26.331  54.931  1.00 34.63           C  
ATOM   1182  O   SER B  65      31.729  26.055  55.981  1.00 34.99           O  
ATOM   1183  CB  SER B  65      33.674  28.364  54.500  1.00 34.69           C  
ATOM   1184  OG  SER B  65      32.706  28.574  53.476  1.00 35.79           O  
ATOM   1185  N   ILE B  66      31.754  26.137  53.738  1.00 33.75           N  
ATOM   1186  CA  ILE B  66      30.424  25.582  53.547  1.00 33.76           C  
ATOM   1187  C   ILE B  66      30.130  24.414  54.482  1.00 33.49           C  
ATOM   1188  O   ILE B  66      30.930  23.493  54.622  1.00 32.72           O  
ATOM   1189  CB  ILE B  66      30.253  25.103  52.100  1.00 33.37           C  
ATOM   1190  CG1 ILE B  66      30.558  26.234  51.118  1.00 33.76           C  
ATOM   1191  CG2 ILE B  66      28.874  24.568  51.901  1.00 34.23           C  
ATOM   1192  CD1 ILE B  66      30.722  25.773  49.686  1.00 35.14           C  
ATOM   1193  N   THR B  67      28.957  24.459  55.105  1.00 33.26           N  
ATOM   1194  CA  THR B  67      28.474  23.366  55.923  1.00 33.41           C  
ATOM   1195  C   THR B  67      26.998  23.189  55.629  1.00 33.12           C  
ATOM   1196  O   THR B  67      26.368  24.071  55.054  1.00 33.06           O  
ATOM   1197  CB  THR B  67      28.672  23.671  57.418  1.00 33.97           C  
ATOM   1198  OG1 THR B  67      27.952  22.712  58.205  1.00 34.76           O  
ATOM   1199  CG2 THR B  67      28.002  24.991  57.793  1.00 33.70           C  
ATOM   1200  N   VAL B  68      26.451  22.045  56.006  1.00 32.76           N  
ATOM   1201  CA  VAL B  68      25.030  21.807  55.816  1.00 32.77           C  
ATOM   1202  C   VAL B  68      24.248  22.978  56.400  1.00 31.97           C  
ATOM   1203  O   VAL B  68      24.532  23.419  57.510  1.00 32.02           O  
ATOM   1204  CB  VAL B  68      24.583  20.500  56.500  1.00 32.89           C  
ATOM   1205  CG1 VAL B  68      23.089  20.282  56.317  1.00 34.19           C  
ATOM   1206  CG2 VAL B  68      25.370  19.323  55.946  1.00 33.11           C  
ATOM   1207  N   GLY B  69      23.286  23.491  55.641  1.00 31.15           N  
ATOM   1208  CA  GLY B  69      22.498  24.623  56.069  1.00 29.98           C  
ATOM   1209  C   GLY B  69      22.956  25.909  55.416  1.00 29.64           C  
ATOM   1210  O   GLY B  69      22.236  26.898  55.404  1.00 30.36           O  
ATOM   1211  N   SER B  70      24.172  25.904  54.891  1.00 29.10           N  
ATOM   1212  CA  SER B  70      24.699  27.081  54.204  1.00 28.60           C  
ATOM   1213  C   SER B  70      23.899  27.341  52.925  1.00 27.11           C  
ATOM   1214  O   SER B  70      23.596  26.412  52.204  1.00 27.04           O  
ATOM   1215  CB  SER B  70      26.173  26.881  53.841  1.00 28.57           C  
ATOM   1216  OG  SER B  70      27.015  26.960  54.986  1.00 29.47           O  
ATOM   1217  N   ARG B  71      23.558  28.606  52.681  1.00 26.42           N  
ATOM   1218  CA  ARG B  71      22.839  29.005  51.477  1.00 26.30           C  
ATOM   1219  C   ARG B  71      23.841  29.494  50.412  1.00 25.61           C  
ATOM   1220  O   ARG B  71      24.541  30.506  50.606  1.00 25.23           O  
ATOM   1221  CB  ARG B  71      21.821  30.088  51.790  1.00 26.65           C  
ATOM   1222  CG  ARG B  71      20.749  29.647  52.803  1.00 29.23           C  
ATOM   1223  CD  ARG B  71      19.954  28.429  52.345  1.00 33.04           C  
ATOM   1224  NE  ARG B  71      19.502  27.606  53.468  1.00 35.81           N  
ATOM   1225  CZ  ARG B  71      19.496  27.989  54.731  1.00 38.20           C  
ATOM   1226  NH1 ARG B  71      19.919  29.202  55.070  1.00 39.50           N  
ATOM   1227  NH2 ARG B  71      19.063  27.160  55.680  1.00 41.44           N  
ATOM   1228  N   ILE B  72      23.917  28.772  49.302  1.00 23.70           N  
ATOM   1229  CA  ILE B  72      24.855  29.101  48.254  1.00 22.54           C  
ATOM   1230  C   ILE B  72      24.205  29.195  46.875  1.00 21.78           C  
ATOM   1231  O   ILE B  72      23.093  28.714  46.667  1.00 20.93           O  
ATOM   1232  CB  ILE B  72      25.995  28.054  48.191  1.00 23.20           C  
ATOM   1233  CG1 ILE B  72      25.434  26.634  48.166  1.00 23.33           C  
ATOM   1234  CG2 ILE B  72      26.976  28.236  49.363  1.00 22.86           C  
ATOM   1235  CD1 ILE B  72      26.433  25.600  47.711  1.00 23.84           C  
ATOM   1236  N   THR B  73      24.916  29.848  45.959  1.00 20.37           N  
ATOM   1237  CA  THR B  73      24.523  29.899  44.550  1.00 20.58           C  
ATOM   1238  C   THR B  73      25.658  29.306  43.727  1.00 20.00           C  
ATOM   1239  O   THR B  73      26.803  29.757  43.822  1.00 20.43           O  
ATOM   1240  CB  THR B  73      24.249  31.334  44.133  1.00 20.94           C  
ATOM   1241  OG1 THR B  73      23.027  31.757  44.729  1.00 21.32           O  
ATOM   1242  CG2 THR B  73      23.939  31.399  42.614  1.00 22.28           C  
ATOM   1243  N   VAL B  74      25.360  28.269  42.951  1.00 18.90           N  
ATOM   1244  CA  VAL B  74      26.368  27.573  42.198  1.00 18.23           C  
ATOM   1245  C   VAL B  74      26.149  27.715  40.692  1.00 17.88           C  
ATOM   1246  O   VAL B  74      25.000  27.782  40.231  1.00 17.65           O  
ATOM   1247  CB  VAL B  74      26.381  26.079  42.568  1.00 18.57           C  
ATOM   1248  CG1 VAL B  74      27.381  25.325  41.733  1.00 19.08           C  
ATOM   1249  CG2 VAL B  74      26.693  25.901  44.065  1.00 18.59           C  
ATOM   1250  N   GLN B  75      27.255  27.786  39.937  1.00 15.84           N  
ATOM   1251  CA  GLN B  75      27.174  27.856  38.489  1.00 15.91           C  
ATOM   1252  C   GLN B  75      28.155  26.881  37.841  1.00 15.62           C  
ATOM   1253  O   GLN B  75      29.323  26.756  38.278  1.00 15.18           O  
ATOM   1254  CB  GLN B  75      27.439  29.263  37.987  1.00 16.29           C  
ATOM   1255  CG  GLN B  75      27.282  29.395  36.455  1.00 19.21           C  
ATOM   1256  CD  GLN B  75      27.844  30.698  35.937  1.00 21.74           C  
ATOM   1257  OE1 GLN B  75      27.501  31.765  36.430  1.00 22.92           O  
ATOM   1258  NE2 GLN B  75      28.734  30.606  34.957  1.00 25.44           N  
ATOM   1259  N   GLY B  76      27.694  26.175  36.826  1.00 13.61           N  
ATOM   1260  CA  GLY B  76      28.540  25.227  36.128  1.00 13.26           C  
ATOM   1261  C   GLY B  76      27.792  24.503  35.047  1.00 12.75           C  
ATOM   1262  O   GLY B  76      26.761  24.975  34.578  1.00 12.30           O  
ATOM   1263  N   PHE B  77      28.335  23.369  34.630  1.00 12.52           N  
ATOM   1264  CA  PHE B  77      27.691  22.566  33.589  1.00 12.86           C  
ATOM   1265  C   PHE B  77      27.201  21.266  34.192  1.00 13.47           C  
ATOM   1266  O   PHE B  77      27.735  20.807  35.223  1.00 13.40           O  
ATOM   1267  CB  PHE B  77      28.632  22.320  32.403  1.00 12.40           C  
ATOM   1268  CG  PHE B  77      29.789  21.418  32.706  1.00 13.23           C  
ATOM   1269  CD1 PHE B  77      29.689  20.053  32.547  1.00 13.73           C  
ATOM   1270  CD2 PHE B  77      31.017  21.959  33.105  1.00 15.53           C  
ATOM   1271  CE1 PHE B  77      30.753  19.221  32.799  1.00 16.01           C  
ATOM   1272  CE2 PHE B  77      32.100  21.137  33.370  1.00 16.02           C  
ATOM   1273  CZ  PHE B  77      31.984  19.757  33.201  1.00 16.04           C  
ATOM   1274  N   ILE B  78      26.170  20.677  33.590  1.00 13.07           N  
ATOM   1275  CA  ILE B  78      25.635  19.428  34.102  1.00 13.72           C  
ATOM   1276  C   ILE B  78      26.109  18.259  33.255  1.00 14.31           C  
ATOM   1277  O   ILE B  78      26.325  18.390  32.056  1.00 12.81           O  
ATOM   1278  CB  ILE B  78      24.097  19.450  34.131  1.00 14.80           C  
ATOM   1279  CG1 ILE B  78      23.555  19.776  32.727  1.00 15.42           C  
ATOM   1280  CG2 ILE B  78      23.610  20.460  35.185  1.00 14.24           C  
ATOM   1281  CD1 ILE B  78      22.043  19.571  32.593  1.00 18.52           C  
ATOM   1282  N   SER B  79      26.278  17.113  33.908  1.00 14.80           N  
ATOM   1283  CA  SER B  79      26.630  15.902  33.240  1.00 17.84           C  
ATOM   1284  C   SER B  79      25.910  14.731  33.906  1.00 19.43           C  
ATOM   1285  O   SER B  79      25.609  14.757  35.109  1.00 19.15           O  
ATOM   1286  CB  SER B  79      28.138  15.690  33.256  1.00 18.00           C  
ATOM   1287  OG  SER B  79      28.512  14.874  32.160  1.00 21.10           O  
ATOM   1288  N   CYS B  80      25.654  13.701  33.137  1.00 20.24           N  
ATOM   1289  CA  CYS B  80      24.897  12.575  33.652  1.00 23.40           C  
ATOM   1290  C   CYS B  80      25.753  11.338  33.764  1.00 23.79           C  
ATOM   1291  O   CYS B  80      26.231  10.832  32.774  1.00 24.18           O  
ATOM   1292  CB  CYS B  80      23.667  12.301  32.792  1.00 22.95           C  
ATOM   1293  SG  CYS B  80      22.340  13.477  33.115  1.00 31.18           S  
ATOM   1294  N   HIS B  81      25.954  10.887  35.004  1.00 25.13           N  
ATOM   1295  CA  HIS B  81      26.774   9.720  35.303  1.00 26.25           C  
ATOM   1296  C   HIS B  81      25.947   8.422  35.273  1.00 26.21           C  
ATOM   1297  O   HIS B  81      24.748   8.419  35.588  1.00 26.57           O  
ATOM   1298  CB  HIS B  81      27.440   9.889  36.675  1.00 26.06           C  
ATOM   1299  CG  HIS B  81      28.342  11.082  36.768  1.00 27.65           C  
ATOM   1300  ND1 HIS B  81      27.887  12.381  36.642  1.00 29.35           N  
ATOM   1301  CD2 HIS B  81      29.682  11.175  36.952  1.00 29.11           C  
ATOM   1302  CE1 HIS B  81      28.901  13.219  36.761  1.00 28.12           C  
ATOM   1303  NE2 HIS B  81      30.000  12.518  36.949  1.00 31.25           N  
HETATM 1304  N   MSE B  90      22.364  12.759  37.685  1.00 23.64           N  
HETATM 1305  CA  MSE B  90      22.899  13.998  37.147  1.00 23.74           C  
HETATM 1306  C   MSE B  90      23.694  14.787  38.181  1.00 22.29           C  
HETATM 1307  O   MSE B  90      23.276  14.908  39.334  1.00 22.34           O  
HETATM 1308  CB  MSE B  90      21.778  14.877  36.569  1.00 24.71           C  
HETATM 1309  CG  MSE B  90      21.807  14.924  35.031  1.00 29.43           C  
HETATM 1310 SE   MSE B  90      20.087  15.397  34.289  1.00 43.29          SE  
HETATM 1311  CE  MSE B  90      19.960  17.044  35.098  1.00 36.21           C  
ATOM   1312  N   VAL B  91      24.859  15.305  37.774  1.00 19.64           N  
ATOM   1313  CA  VAL B  91      25.623  16.146  38.672  1.00 18.99           C  
ATOM   1314  C   VAL B  91      25.993  17.481  38.053  1.00 17.76           C  
ATOM   1315  O   VAL B  91      26.162  17.589  36.826  1.00 17.96           O  
ATOM   1316  CB  VAL B  91      26.892  15.454  39.236  1.00 19.48           C  
ATOM   1317  CG1 VAL B  91      26.753  13.921  39.247  1.00 20.96           C  
ATOM   1318  CG2 VAL B  91      28.127  15.870  38.498  1.00 20.67           C  
ATOM   1319  N   LEU B  92      26.111  18.470  38.901  1.00 15.75           N  
ATOM   1320  CA  LEU B  92      26.490  19.831  38.510  1.00 16.87           C  
ATOM   1321  C   LEU B  92      27.983  20.015  38.758  1.00 17.07           C  
ATOM   1322  O   LEU B  92      28.439  19.994  39.922  1.00 16.60           O  
ATOM   1323  CB  LEU B  92      25.686  20.843  39.330  1.00 16.36           C  
ATOM   1324  CG  LEU B  92      26.159  22.284  39.441  1.00 17.32           C  
ATOM   1325  CD1 LEU B  92      26.520  22.855  38.078  1.00 18.87           C  
ATOM   1326  CD2 LEU B  92      25.085  23.161  40.103  1.00 17.12           C  
ATOM   1327  N   HIS B  93      28.747  20.159  37.698  1.00 15.55           N  
ATOM   1328  CA  HIS B  93      30.180  20.411  37.818  1.00 17.09           C  
ATOM   1329  C   HIS B  93      30.363  21.906  37.944  1.00 18.08           C  
ATOM   1330  O   HIS B  93      30.329  22.637  36.945  1.00 16.43           O  
ATOM   1331  CB  HIS B  93      30.940  19.888  36.596  1.00 16.82           C  
ATOM   1332  CG  HIS B  93      30.963  18.405  36.510  1.00 17.85           C  
ATOM   1333  ND1 HIS B  93      32.063  17.659  36.864  1.00 20.04           N  
ATOM   1334  CD2 HIS B  93      30.017  17.520  36.115  1.00 18.62           C  
ATOM   1335  CE1 HIS B  93      31.800  16.377  36.679  1.00 20.31           C  
ATOM   1336  NE2 HIS B  93      30.561  16.269  36.231  1.00 20.71           N  
ATOM   1337  N   ALA B  94      30.566  22.349  39.185  1.00 17.47           N  
ATOM   1338  CA  ALA B  94      30.564  23.759  39.504  1.00 19.53           C  
ATOM   1339  C   ALA B  94      31.857  24.498  39.116  1.00 21.10           C  
ATOM   1340  O   ALA B  94      32.950  24.042  39.387  1.00 22.11           O  
ATOM   1341  CB  ALA B  94      30.249  23.965  40.951  1.00 19.56           C  
ATOM   1342  N   GLU B  95      31.673  25.656  38.515  1.00 21.93           N  
ATOM   1343  CA  GLU B  95      32.731  26.536  38.088  1.00 23.52           C  
ATOM   1344  C   GLU B  95      32.837  27.695  39.087  1.00 24.15           C  
ATOM   1345  O   GLU B  95      33.943  28.157  39.404  1.00 22.91           O  
ATOM   1346  CB  GLU B  95      32.379  27.066  36.690  1.00 23.80           C  
ATOM   1347  CG  GLU B  95      33.131  28.292  36.250  1.00 27.42           C  
ATOM   1348  CD  GLU B  95      33.040  28.517  34.764  1.00 30.59           C  
ATOM   1349  OE1 GLU B  95      34.110  28.742  34.127  1.00 32.82           O  
ATOM   1350  OE2 GLU B  95      31.909  28.466  34.219  1.00 32.46           O  
ATOM   1351  N   GLN B  96      31.687  28.150  39.575  1.00 23.47           N  
ATOM   1352  CA  GLN B  96      31.595  29.236  40.522  1.00 25.14           C  
ATOM   1353  C   GLN B  96      30.646  28.843  41.647  1.00 25.52           C  
ATOM   1354  O   GLN B  96      29.693  28.095  41.432  1.00 24.62           O  
ATOM   1355  CB  GLN B  96      31.081  30.515  39.855  1.00 25.37           C  
ATOM   1356  CG  GLN B  96      32.097  31.198  38.974  1.00 29.63           C  
ATOM   1357  CD  GLN B  96      31.782  32.675  38.751  1.00 33.12           C  
ATOM   1358  OE1 GLN B  96      31.558  33.435  39.715  1.00 34.64           O  
ATOM   1359  NE2 GLN B  96      31.770  33.088  37.486  1.00 35.58           N  
ATOM   1360  N   ILE B  97      30.915  29.356  42.851  1.00 25.28           N  
ATOM   1361  CA  ILE B  97      30.063  29.059  44.003  1.00 26.80           C  
ATOM   1362  C   ILE B  97      30.113  30.175  45.042  1.00 28.01           C  
ATOM   1363  O   ILE B  97      31.180  30.443  45.625  1.00 27.54           O  
ATOM   1364  CB  ILE B  97      30.425  27.685  44.618  1.00 27.20           C  
ATOM   1365  CG1 ILE B  97      29.684  27.465  45.938  1.00 28.56           C  
ATOM   1366  CG2 ILE B  97      31.931  27.564  44.832  1.00 28.13           C  
ATOM   1367  CD1 ILE B  97      29.788  26.045  46.448  1.00 29.33           C  
ATOM   1368  N   GLU B  98      28.992  30.872  45.210  1.00 27.86           N  
ATOM   1369  CA  GLU B  98      28.882  31.969  46.149  1.00 29.22           C  
ATOM   1370  C   GLU B  98      28.148  31.510  47.399  1.00 29.39           C  
ATOM   1371  O   GLU B  98      26.963  31.166  47.334  1.00 27.66           O  
ATOM   1372  CB  GLU B  98      28.117  33.129  45.523  1.00 29.42           C  
ATOM   1373  CG  GLU B  98      28.977  34.329  45.175  1.00 33.17           C  
ATOM   1374  CD  GLU B  98      28.150  35.555  44.852  1.00 37.16           C  
ATOM   1375  OE1 GLU B  98      27.080  35.748  45.497  1.00 38.59           O  
ATOM   1376  OE2 GLU B  98      28.564  36.324  43.950  1.00 38.50           O  
TER    1377      GLU B  98                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
