
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  656 ( 5230),  selected  656 , name 1foh_C
# Molecule2: number of CA atoms  366 ( 2688),  selected  366 , name T0490.pdb
# PARAMETERS: 1foh_C.T0490.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     1_C      -       -           -
LGA    K     2_C      -       -           -
LGA    Y     3_C      -       -           -
LGA    S     4_C      -       -           -
LGA    E     5_C      -       -           -
LGA    S     6_C      T       3          4.717
LGA    Y     7_C      D       4          2.277
LGA    C     8_C      I       5          0.451
LGA    D     9_C      D       6          0.497
LGA    V    10_C      C       7          0.488
LGA    L    11_C      I       8          0.519
LGA    I    12_C      V       9          0.383
LGA    V    13_C      I      10          0.463
LGA    G    14_C      G      11          0.478
LGA    A    15_C      A      12          0.615
LGA    G    16_C      G      13          0.586
LGA    P    17_C      V      14          1.317
LGA    A    18_C      V      15          1.463
LGA    G    19_C      G      16          0.956
LGA    L    20_C      L      17          0.329
LGA    M    21_C      A      18          0.657
LGA    A    22_C      I      19          1.220
LGA    A    23_C      A      20          1.358
LGA    R    24_C      R      21          1.014
LGA    V    25_C      A      22          1.150
LGA    L    26_C      L      23          1.917
LGA    S    27_C      A      24          2.124
LGA    E    28_C      A      25          1.845
LGA    Y    29_C      G      26          3.006
LGA    V    30_C      G      27          3.270
LGA    R    31_C      H      28           -
LGA    Q    32_C      -       -           -
LGA    K    33_C      -       -           -
LGA    P    34_C      -       -           -
LGA    D    35_C      -       -           -
LGA    L    36_C      -       -           -
LGA    K    37_C      E      29          2.775
LGA    V    38_C      V      30          1.316
LGA    R    39_C      L      31          0.296
LGA    I    40_C      V      32          0.358
LGA    I    41_C      A      33          0.854
LGA    D    42_C      E      34          0.383
LGA    K    43_C      A      35          0.163
LGA    R    44_C      A      36          0.634
LGA    S    45_C      E      37          1.709
LGA    T    46_C      G      38          3.268
LGA    K    47_C      I      39           -
LGA    V    48_C      G      40           -
LGA    Y    49_C      T      41          4.382
LGA    N    50_C      G      42          3.448
LGA    -       -      T      43           -
LGA    -       -      S      44           -
LGA    G    51_C      S      45          1.571
LGA    Q    52_C      R      46          1.963
LGA    A    53_C      N      47          3.123
LGA    -       -      S      48           -
LGA    D    54_C      E      49          0.991
LGA    G    55_C      V      50          2.337
LGA    L    56_C      I      51          2.735
LGA    Q    57_C      H      52          4.153
LGA    C    58_C      A      53           #
LGA    -       -      G      54           -
LGA    -       -      I      55           -
LGA    -       -      Y      56           -
LGA    -       -      Y      57           -
LGA    -       -      P      58           -
LGA    -       -      A      59           -
LGA    -       -      D      60           -
LGA    -       -      S      61           -
LGA    -       -      L      62           -
LGA    -       -      K      63           -
LGA    -       -      A      64           -
LGA    -       -      R      65           -
LGA    -       -      L      66           -
LGA    -       -      C      67           -
LGA    -       -      V      68           -
LGA    R    59_C      R      69          2.196
LGA    T    60_C      G      70          1.729
LGA    L    61_C      K      71          3.973
LGA    E    62_C      H      72          2.910
LGA    S    63_C      L      73          2.465
LGA    L    64_C      L      74          3.897
LGA    K    65_C      Y      75           #
LGA    N    66_C      E      76           #
LGA    L    67_C      -       -           -
LGA    G    68_C      Y      77          4.815
LGA    L    69_C      C      78          4.445
LGA    A    70_C      A      79          3.792
LGA    D    71_C      A      80          3.378
LGA    K    72_C      R      81          3.684
LGA    I    73_C      G      82          5.115
LGA    L    74_C      V      83           #
LGA    S    75_C      -       -           -
LGA    E    76_C      P      84          2.400
LGA    A    77_C      H      85          1.371
LGA    N    78_C      Q      86          2.313
LGA    D    79_C      R      87          2.086
LGA    M    80_C      L      88          3.246
LGA    S    81_C      G      89          1.403
LGA    T    82_C      K      90          3.055
LGA    I    83_C      L      91          0.926
LGA    A    84_C      I      92          4.147
LGA    L    85_C      V      93          0.587
LGA    Y    86_C      A      94          4.010
LGA    N    87_C      T      95          1.702
LGA    P    88_C      S      96          4.774
LGA    D    89_C      D      97           #
LGA    E    90_C      A      98           -
LGA    N    91_C      E      99           -
LGA    G    92_C      A     100           -
LGA    H    93_C      S     101           -
LGA    I    94_C      Q     102           -
LGA    -       -      L     103           -
LGA    -       -      D     104           -
LGA    -       -      S     105           -
LGA    -       -      I     106           -
LGA    -       -      A     107           -
LGA    -       -      R     108           -
LGA    -       -      R     109           -
LGA    -       -      A     110           -
LGA    -       -      G     111           -
LGA    -       -      A     112           -
LGA    -       -      N     113           -
LGA    -       -      G     114           -
LGA    -       -      V     115           -
LGA    -       -      D     116           -
LGA    -       -      D     117           -
LGA    -       -      L     118           -
LGA    -       -      Q     119           -
LGA    -       -      H     120           -
LGA    -       -      I     121           -
LGA    -       -      D     122           -
LGA    -       -      G     123           -
LGA    -       -      A     124           -
LGA    -       -      A     125           -
LGA    -       -      A     126           -
LGA    -       -      R     127           -
LGA    -       -      R     128           -
LGA    -       -      L     129           -
LGA    -       -      E     130           -
LGA    -       -      P     131           -
LGA    -       -      A     132           -
LGA    R    95_C      L     133           #
LGA    -       -      H     134           -
LGA    R    96_C      C     135          0.652
LGA    T    97_C      T     136          1.252
LGA    D    98_C      A     137          1.461
LGA    R    99_C      A     138          2.124
LGA    I   100_C      L     139          1.195
LGA    P   101_C      V     140          2.377
LGA    D   102_C      S     141          1.621
LGA    T   103_C      P     142          4.444
LGA    L   104_C      -       -           -
LGA    P   105_C      -       -           -
LGA    G   106_C      -       -           -
LGA    I   107_C      -       -           -
LGA    S   108_C      -       -           -
LGA    R   109_C      -       -           -
LGA    Y   110_C      -       -           -
LGA    H   111_C      S     143          2.836
LGA    Q   112_C      T     144          3.177
LGA    V   113_C      G     145          1.884
LGA    V   114_C      I     146          1.043
LGA    L   115_C      V     147          1.699
LGA    H   116_C      D     148          2.811
LGA    Q   117_C      S     149          1.550
LGA    G   118_C      H     150          0.732
LGA    R   119_C      A     151          1.541
LGA    I   120_C      L     152          1.284
LGA    E   121_C      M     153          0.773
LGA    R   122_C      L     154          1.753
LGA    H   123_C      A     155          1.818
LGA    I   124_C      Y     156          1.464
LGA    L   125_C      Q     157          2.011
LGA    D   126_C      G     158          2.409
LGA    S   127_C      D     159          2.178
LGA    I   128_C      A     160          2.345
LGA    A   129_C      E     161          3.255
LGA    E   130_C      S     162          3.096
LGA    I   131_C      D     163          3.695
LGA    S   132_C      G     164          3.289
LGA    D   133_C      -       -           -
LGA    T   134_C      -       -           -
LGA    R   135_C      -       -           -
LGA    I   136_C      A     165          1.808
LGA    K   137_C      Q     166          2.827
LGA    V   138_C      L     167          1.696
LGA    E   139_C      V     168          0.420
LGA    R   140_C      F     169          0.718
LGA    P   141_C      H     170          0.515
LGA    L   142_C      T     171          0.437
LGA    I   143_C      P     172          0.994
LGA    P   144_C      L     173          1.266
LGA    E   145_C      I     174          1.754
LGA    K   146_C      A     175          1.523
LGA    M   147_C      G     176          0.886
LGA    E   148_C      R     177          0.982
LGA    I   149_C      V     178          0.711
LGA    D   150_C      R     179          2.584
LGA    S   151_C      P     180          4.682
LGA    S   152_C      -       -           -
LGA    K   153_C      E     181          2.717
LGA    A   154_C      G     182          3.845
LGA    E   155_C      -       -           -
LGA    D   156_C      -       -           -
LGA    P   157_C      -       -           -
LGA    E   158_C      -       -           -
LGA    A   159_C      -       -           -
LGA    Y   160_C      -       -           -
LGA    P   161_C      G     183          2.316
LGA    V   162_C      F     184          0.844
LGA    T   163_C      E     185          0.656
LGA    M   164_C      L     186          0.841
LGA    T   165_C      D     187          1.135
LGA    L   166_C      F     188          1.258
LGA    R   167_C      G     189          1.829
LGA    Y   168_C      G     190          3.691
LGA    M   169_C      A     191          3.496
LGA    S   170_C      -       -           -
LGA    D   171_C      -       -           -
LGA    H   172_C      -       -           -
LGA    E   173_C      -       -           -
LGA    S   174_C      -       -           -
LGA    T   175_C      -       -           -
LGA    P   176_C      -       -           -
LGA    L   177_C      -       -           -
LGA    Q   178_C      -       -           -
LGA    F   179_C      -       -           -
LGA    G   180_C      -       -           -
LGA    H   181_C      -       -           -
LGA    K   182_C      -       -           -
LGA    T   183_C      -       -           -
LGA    E   184_C      -       -           -
LGA    N   185_C      -       -           -
LGA    S   186_C      -       -           -
LGA    L   187_C      -       -           -
LGA    F   188_C      -       -           -
LGA    H   189_C      -       -           -
LGA    S   190_C      -       -           -
LGA    N   191_C      -       -           -
LGA    L   192_C      -       -           -
LGA    Q   193_C      -       -           -
LGA    T   194_C      -       -           -
LGA    Q   195_C      -       -           -
LGA    E   196_C      -       -           -
LGA    E   197_C      -       -           -
LGA    E   198_C      -       -           -
LGA    D   199_C      -       -           -
LGA    A   200_C      -       -           -
LGA    N   201_C      -       -           -
LGA    Y   202_C      -       -           -
LGA    R   203_C      -       -           -
LGA    L   204_C      -       -           -
LGA    P   205_C      -       -           -
LGA    E   206_C      -       -           -
LGA    G   207_C      -       -           -
LGA    K   208_C      -       -           -
LGA    E   209_C      -       -           -
LGA    A   210_C      -       -           -
LGA    G   211_C      -       -           -
LGA    E   212_C      E     192          2.694
LGA    I   213_C      P     193          2.363
LGA    E   214_C      M     194          1.704
LGA    T   215_C      T     195          1.645
LGA    V   216_C      L     196          1.007
LGA    H   217_C      S     197          1.408
LGA    C   218_C      C     198          0.705
LGA    K   219_C      R     199          0.615
LGA    Y   220_C      V     200          0.807
LGA    V   221_C      L     201          0.454
LGA    I   222_C      I     202          0.375
LGA    G   223_C      N     203          0.321
LGA    C   224_C      A     204          0.433
LGA    D   225_C      A     205          0.313
LGA    G   226_C      G     206          0.454
LGA    G   227_C      L     207          2.434
LGA    H   228_C      H     208          2.475
LGA    S   229_C      A     209          1.132
LGA    -       -      P     210           -
LGA    W   230_C      G     211          3.678
LGA    V   231_C      L     212          3.260
LGA    R   232_C      A     213          2.490
LGA    R   233_C      R     214          2.693
LGA    T   234_C      R     215          2.978
LGA    -       -      I     216           -
LGA    -       -      E     217           -
LGA    -       -      G     218           -
LGA    L   235_C      I     219          2.815
LGA    -       -      P     220           -
LGA    G   236_C      R     221          2.351
LGA    -       -      D     222           -
LGA    F   237_C      S     223          2.944
LGA    E   238_C      I     224          2.736
LGA    M   239_C      P     225          1.674
LGA    I   240_C      P     226           #
LGA    G   241_C      E     227           -
LGA    E   242_C      -       -           -
LGA    Q   243_C      Y     228           #
LGA    T   244_C      L     229           -
LGA    D   245_C      C     230           -
LGA    Y   246_C      -       -           -
LGA    I   247_C      K     231           #
LGA    W   248_C      G     232          5.041
LGA    G   249_C      S     233          2.695
LGA    V   250_C      Y     234          1.840
LGA    L   251_C      F     235          2.638
LGA    D   252_C      T     236          4.785
LGA    A   253_C      L     237          4.592
LGA    V   254_C      A     238          4.138
LGA    P   255_C      G     239           #
LGA    A   256_C      R     240           #
LGA    S   257_C      A     241           #
LGA    N   258_C      -       -           -
LGA    F   259_C      -       -           -
LGA    P   260_C      -       -           -
LGA    D   261_C      P     242           #
LGA    I   262_C      F     243          2.995
LGA    R   263_C      S     244          2.967
LGA    S   264_C      R     245          2.153
LGA    R   265_C      L     246          1.961
LGA    C   266_C      I     247          1.663
LGA    A   267_C      Y     248          2.670
LGA    I   268_C      P     249          3.842
LGA    -       -      V     250           -
LGA    -       -      P     251           -
LGA    -       -      Q     252           -
LGA    H   269_C      H     253          5.215
LGA    S   270_C      A     254           #
LGA    A   271_C      -       -           -
LGA    E   272_C      -       -           -
LGA    S   273_C      -       -           -
LGA    G   274_C      G     255          4.456
LGA    S   275_C      L     256          3.384
LGA    -       -      G     257           -
LGA    I   276_C      V     258          1.282
LGA    M   277_C      H     259          1.332
LGA    I   278_C      L     260          1.434
LGA    I   279_C      T     261          1.930
LGA    P   280_C      L     262          2.599
LGA    R   281_C      D     263          2.880
LGA    E   282_C      L     264          1.376
LGA    N   283_C      G     265          1.044
LGA    N   284_C      G     266          1.181
LGA    L   285_C      Q     267          2.223
LGA    V   286_C      A     268          2.278
LGA    R   287_C      K     269          3.102
LGA    F   288_C      F     270          1.434
LGA    Y   289_C      G     271          1.290
LGA    V   290_C      P     272          5.170
LGA    Q   291_C      D     273          4.133
LGA    L   292_C      T     274           #
LGA    -       -      E     275           -
LGA    R   301_C      W     276           #
LGA    V   302_C      I     277           #
LGA    D   303_C      A     278           -
LGA    -       -      T     279           -
LGA    -       -      E     280           -
LGA    -       -      D     281           -
LGA    R   304_C      Y     282           #
LGA    T   305_C      T     283          5.191
LGA    K   306_C      L     284           #
LGA    F   307_C      D     285          1.764
LGA    T   308_C      P     286          2.215
LGA    P   309_C      -       -           -
LGA    E   310_C      -       -           -
LGA    V   311_C      R     287          1.732
LGA    V   312_C      R     288          3.473
LGA    I   313_C      A     289          3.211
LGA    A   314_C      D     290          2.651
LGA    N   315_C      V     291          2.363
LGA    A   316_C      F     292          2.231
LGA    K   317_C      Y     293          2.140
LGA    K   318_C      A     294          2.578
LGA    I   319_C      A     295          2.185
LGA    F   320_C      V     296          3.021
LGA    H   321_C      R     297          3.355
LGA    -       -      S     298           -
LGA    -       -      Y     299           -
LGA    -       -      W     300           -
LGA    P   322_C      P     301          3.561
LGA    Y   323_C      A     302          2.148
LGA    T   324_C      L     303          1.755
LGA    F   325_C      P     304          3.912
LGA    -       -      D     305           -
LGA    -       -      G     306           -
LGA    D   326_C      A     307          1.829
LGA    V   327_C      L     308          4.654
LGA    Q   328_C      A     309           #
LGA    Q   329_C      -       -           -
LGA    L   330_C      -       -           -
LGA    D   331_C      -       -           -
LGA    W   332_C      P     310           #
LGA    F   333_C      G     311          3.465
LGA    -       -      Y     312           -
LGA    T   334_C      T     313          1.218
LGA    -       -      G     314           -
LGA    A   335_C      I     315           #
LGA    Y   336_C      R     316           #
LGA    H   337_C      P     317           -
LGA    I   338_C      -       -           -
LGA    G   339_C      -       -           -
LGA    Q   340_C      K     318           #
LGA    R   341_C      I     319          2.246
LGA    V   342_C      S     320           #
LGA    -       -      G     321           -
LGA    -       -      P     322           -
LGA    -       -      H     323           -
LGA    -       -      E     324           -
LGA    -       -      P     325           -
LGA    -       -      A     326           -
LGA    -       -      A     327           -
LGA    -       -      D     328           -
LGA    -       -      F     329           -
LGA    T   343_C      A     330          5.348
LGA    E   344_C      I     331           -
LGA    K   345_C      A     332          4.056
LGA    F   346_C      G     333          3.669
LGA    S   347_C      P     334          3.645
LGA    -       -      A     335           -
LGA    -       -      S     336           -
LGA    K   348_C      H     337          4.350
LGA    D   349_C      G     338          3.888
LGA    -       -      V     339           -
LGA    E   350_C      A     340          2.471
LGA    R   351_C      G     341          1.677
LGA    V   352_C      L     342          1.780
LGA    F   353_C      V     343          1.156
LGA    I   354_C      N     344          1.072
LGA    A   355_C      L     345          2.307
LGA    G   356_C      -       -           -
LGA    D   357_C      -       -           -
LGA    A   358_C      Y     346          2.514
LGA    C   359_C      G     347          4.407
LGA    H   360_C      I     348          4.479
LGA    T   361_C      E     349          4.508
LGA    H   362_C      -       -           -
LGA    S   363_C      -       -           -
LGA    P   364_C      -       -           -
LGA    K   365_C      -       -           -
LGA    A   366_C      -       -           -
LGA    G   367_C      S     350          3.858
LGA    Q   368_C      P     351          1.061
LGA    G   369_C      G     352          2.187
LGA    M   370_C      L     353          2.224
LGA    N   371_C      T     354          3.073
LGA    T   372_C      A     355          3.651
LGA    S   373_C      S     356          4.676
LGA    M   374_C      L     357          4.012
LGA    M   375_C      A     358          2.151
LGA    D   376_C      I     359          2.295
LGA    T   377_C      A     360          2.130
LGA    Y   378_C      E     361          2.269
LGA    N   379_C      E     362          2.456
LGA    L   380_C      T     363          2.659
LGA    G   381_C      L     364          3.363
LGA    W   382_C      A     365           #
LGA    K   383_C      R     366           #
LGA    L   384_C      L     367           #
LGA    G   385_C      -       -           -
LGA    L   386_C      -       -           -
LGA    V   387_C      -       -           -
LGA    L   388_C      -       -           -
LGA    T   389_C      -       -           -
LGA    G   390_C      -       -           -
LGA    R   391_C      -       -           -
LGA    A   392_C      -       -           -
LGA    K   393_C      -       -           -
LGA    R   394_C      -       -           -
LGA    D   395_C      -       -           -
LGA    I   396_C      -       -           -
LGA    L   397_C      A     368          1.175
LGA    K   398_C      -       -           -
LGA    T   399_C      -       -           -
LGA    Y   400_C      -       -           -
LGA    E   401_C      -       -           -
LGA    E   402_C      -       -           -
LGA    E   403_C      -       -           -
LGA    R   404_C      -       -           -
LGA    H   405_C      -       -           -
LGA    A   406_C      -       -           -
LGA    F   407_C      -       -           -
LGA    A   408_C      -       -           -
LGA    Q   409_C      -       -           -
LGA    A   410_C      -       -           -
LGA    L   411_C      -       -           -
LGA    I   412_C      -       -           -
LGA    D   413_C      -       -           -
LGA    F   414_C      -       -           -
LGA    D   415_C      -       -           -
LGA    H   416_C      -       -           -
LGA    Q   417_C      -       -           -
LGA    F   418_C      -       -           -
LGA    S   419_C      -       -           -
LGA    R   420_C      -       -           -
LGA    L   421_C      -       -           -
LGA    F   422_C      -       -           -
LGA    S   423_C      -       -           -
LGA    G   424_C      -       -           -
LGA    R   425_C      -       -           -
LGA    P   426_C      -       -           -
LGA    A   427_C      -       -           -
LGA    K   428_C      -       -           -
LGA    D   429_C      -       -           -
LGA    V   430_C      -       -           -
LGA    A   431_C      -       -           -
LGA    D   432_C      -       -           -
LGA    E   433_C      -       -           -
LGA    M   434_C      -       -           -
LGA    G   435_C      -       -           -
LGA    V   436_C      -       -           -
LGA    S   437_C      -       -           -
LGA    M   438_C      -       -           -
LGA    D   439_C      -       -           -
LGA    V   440_C      -       -           -
LGA    F   441_C      -       -           -
LGA    K   442_C      -       -           -
LGA    E   443_C      -       -           -
LGA    A   444_C      -       -           -
LGA    F   445_C      -       -           -
LGA    V   446_C      -       -           -
LGA    K   447_C      -       -           -
LGA    G   448_C      -       -           -
LGA    N   449_C      -       -           -
LGA    E   450_C      -       -           -
LGA    F   451_C      -       -           -
LGA    A   452_C      -       -           -
LGA    S   453_C      -       -           -
LGA    G   454_C      -       -           -
LGA    T   455_C      -       -           -
LGA    A   456_C      -       -           -
LGA    I   457_C      -       -           -
LGA    N   458_C      -       -           -
LGA    Y   459_C      -       -           -
LGA    D   460_C      -       -           -
LGA    E   461_C      -       -           -
LGA    N   462_C      -       -           -
LGA    L   463_C      -       -           -
LGA    V   464_C      -       -           -
LGA    T   465_C      -       -           -
LGA    D   466_C      -       -           -
LGA    K   467_C      -       -           -
LGA    K   468_C      -       -           -
LGA    S   469_C      -       -           -
LGA    S   470_C      -       -           -
LGA    K   471_C      -       -           -
LGA    Q   472_C      -       -           -
LGA    E   473_C      -       -           -
LGA    L   474_C      -       -           -
LGA    A   475_C      -       -           -
LGA    K   476_C      -       -           -
LGA    N   477_C      -       -           -
LGA    C   478_C      -       -           -
LGA    V   479_C      -       -           -
LGA    V   480_C      -       -           -
LGA    G   481_C      -       -           -
LGA    T   482_C      -       -           -
LGA    R   483_C      -       -           -
LGA    F   484_C      -       -           -
LGA    K   485_C      -       -           -
LGA    S   486_C      -       -           -
LGA    Q   487_C      -       -           -
LGA    P   488_C      -       -           -
LGA    V   489_C      -       -           -
LGA    V   490_C      -       -           -
LGA    R   491_C      -       -           -
LGA    H   492_C      -       -           -
LGA    S   493_C      -       -           -
LGA    E   494_C      -       -           -
LGA    G   495_C      -       -           -
LGA    L   496_C      -       -           -
LGA    W   497_C      -       -           -
LGA    M   498_C      -       -           -
LGA    H   499_C      -       -           -
LGA    F   500_C      -       -           -
LGA    G   501_C      -       -           -
LGA    D   502_C      -       -           -
LGA    R   503_C      -       -           -
LGA    L   504_C      -       -           -
LGA    V   505_C      -       -           -
LGA    T   506_C      -       -           -
LGA    D   507_C      -       -           -
LGA    G   508_C      -       -           -
LGA    R   509_C      -       -           -
LGA    F   510_C      -       -           -
LGA    R   511_C      -       -           -
LGA    I   512_C      -       -           -
LGA    I   513_C      -       -           -
LGA    V   514_C      -       -           -
LGA    F   515_C      -       -           -
LGA    A   516_C      -       -           -
LGA    G   517_C      -       -           -
LGA    K   518_C      -       -           -
LGA    A   519_C      -       -           -
LGA    T   520_C      -       -           -
LGA    D   521_C      -       -           -
LGA    A   522_C      -       -           -
LGA    T   523_C      -       -           -
LGA    Q   524_C      -       -           -
LGA    M   525_C      -       -           -
LGA    S   526_C      -       -           -
LGA    R   527_C      -       -           -
LGA    I   528_C      -       -           -
LGA    K   529_C      -       -           -
LGA    K   530_C      -       -           -
LGA    F   531_C      -       -           -
LGA    S   532_C      -       -           -
LGA    A   533_C      -       -           -
LGA    Y   534_C      -       -           -
LGA    L   535_C      -       -           -
LGA    D   536_C      -       -           -
LGA    S   537_C      -       -           -
LGA    E   538_C      -       -           -
LGA    N   539_C      -       -           -
LGA    S   540_C      -       -           -
LGA    V   541_C      -       -           -
LGA    I   542_C      -       -           -
LGA    S   543_C      -       -           -
LGA    L   544_C      -       -           -
LGA    Y   545_C      -       -           -
LGA    T   546_C      -       -           -
LGA    P   547_C      -       -           -
LGA    K   548_C      -       -           -
LGA    V   549_C      -       -           -
LGA    S   550_C      -       -           -
LGA    D   551_C      -       -           -
LGA    R   552_C      -       -           -
LGA    N   553_C      -       -           -
LGA    S   554_C      -       -           -
LGA    R   555_C      -       -           -
LGA    I   556_C      -       -           -
LGA    D   557_C      -       -           -
LGA    V   558_C      -       -           -
LGA    I   559_C      -       -           -
LGA    T   560_C      -       -           -
LGA    I   561_C      -       -           -
LGA    H   562_C      -       -           -
LGA    S   563_C      -       -           -
LGA    C   564_C      -       -           -
LGA    H   565_C      -       -           -
LGA    R   566_C      -       -           -
LGA    D   567_C      -       -           -
LGA    D   568_C      -       -           -
LGA    I   569_C      -       -           -
LGA    E   570_C      -       -           -
LGA    M   571_C      -       -           -
LGA    H   572_C      -       -           -
LGA    D   573_C      -       -           -
LGA    F   574_C      -       -           -
LGA    P   575_C      -       -           -
LGA    A   576_C      -       -           -
LGA    P   577_C      -       -           -
LGA    A   578_C      -       -           -
LGA    L   579_C      -       -           -
LGA    H   580_C      -       -           -
LGA    P   581_C      -       -           -
LGA    K   582_C      -       -           -
LGA    W   583_C      -       -           -
LGA    Q   584_C      -       -           -
LGA    Y   585_C      -       -           -
LGA    D   586_C      -       -           -
LGA    F   587_C      -       -           -
LGA    I   588_C      -       -           -
LGA    Y   589_C      -       -           -
LGA    A   590_C      -       -           -
LGA    D   591_C      -       -           -
LGA    C   592_C      -       -           -
LGA    D   593_C      -       -           -
LGA    S   594_C      -       -           -
LGA    W   595_C      -       -           -
LGA    H   596_C      -       -           -
LGA    H   597_C      -       -           -
LGA    P   598_C      -       -           -
LGA    H   599_C      -       -           -
LGA    P   600_C      -       -           -
LGA    K   601_C      -       -           -
LGA    S   602_C      -       -           -
LGA    Y   603_C      -       -           -
LGA    Q   604_C      -       -           -
LGA    A   605_C      -       -           -
LGA    W   606_C      -       -           -
LGA    G   607_C      -       -           -
LGA    V   608_C      -       -           -
LGA    D   609_C      -       -           -
LGA    E   610_C      -       -           -
LGA    T   611_C      -       -           -
LGA    K   612_C      -       -           -
LGA    G   613_C      -       -           -
LGA    A   614_C      -       -           -
LGA    V   615_C      -       -           -
LGA    V   616_C      -       -           -
LGA    V   617_C      -       -           -
LGA    V   618_C      -       -           -
LGA    R   619_C      -       -           -
LGA    P   620_C      -       -           -
LGA    D   621_C      -       -           -
LGA    G   622_C      -       -           -
LGA    Y   623_C      -       -           -
LGA    T   624_C      -       -           -
LGA    S   625_C      -       -           -
LGA    L   626_C      -       -           -
LGA    V   627_C      -       -           -
LGA    T   628_C      -       -           -
LGA    D   629_C      -       -           -
LGA    L   630_C      -       -           -
LGA    E   631_C      -       -           -
LGA    G   632_C      -       -           -
LGA    T   633_C      -       -           -
LGA    A   634_C      -       -           -
LGA    E   635_C      -       -           -
LGA    I   636_C      -       -           -
LGA    D   637_C      -       -           -
LGA    R   638_C      -       -           -
LGA    Y   639_C      -       -           -
LGA    F   640_C      -       -           -
LGA    S   641_C      -       -           -
LGA    G   642_C      -       -           -
LGA    I   643_C      -       -           -
LGA    L   644_C      -       -           -
LGA    V   645_C      -       -           -
LGA    E   646_C      -       -           -
LGA    P   647_C      -       -           -
LGA    K   648_C      -       -           -
LGA    E   649_C      -       -           -
LGA    K   650_C      -       -           -
LGA    S   651_C      -       -           -
LGA    G   652_C      -       -           -
LGA    A   653_C      -       -           -
LGA    Q   654_C      -       -           -
LGA    T   655_C      -       -           -
LGA    E   656_C      -       -           -
LGA    A   657_C      -       -           -
LGA    D   658_C      -       -           -
LGA    W   659_C      -       -           -
LGA    T   660_C      -       -           -
LGA    K   661_C      -       -           -
LGA    S   662_C      -       -           -
LGA    T   663_C      -       -           -
LGA    A   664_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  656  366    5.0    242    2.61    11.98     40.129     8.934

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.900157 * X  +   0.268556 * Y  +  -0.342920 * Z  +  32.545670
  Y_new =  -0.434007 * X  +  -0.619540 * Y  +   0.654070 * Z  +  72.288086
  Z_new =  -0.036799 * X  +   0.737596 * Y  +   0.674239 * Z  + -67.791786 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.830244   -2.311349  [ DEG:    47.5695   -132.4305 ]
  Theta =   0.036807    3.104785  [ DEG:     2.1089    177.8911 ]
  Phi   =  -2.692330    0.449263  [ DEG:  -154.2591     25.7409 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1foh_C                                        
REMARK     2: T0490.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1foh_C.T0490.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  656  366   5.0  242   2.61   11.98  40.129
REMARK  ---------------------------------------------------------- 
MOLECULE 1foh_C
HEADER    FLAVIN                                  26-MAR-98   1FOH              
TITLE     PHENOL HYDROXYLASE FROM TRICHOSPORON CUTANEUM                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHENOL HYDROXYLASE;                                        
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 EC: 1.14.13.7;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: TRICHOSPORON CUTANEUM;                          
SOURCE   3 ORGANISM_COMMON: SOIL-LIVING YEAST;                                  
SOURCE   4 CELL_LINE: 293;                                                      
SOURCE   5 COLLECTION: ATCC 46490;                                              
SOURCE   6 GENE: PHYA;                                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: XL1-BLUE;                                  
SOURCE   9 EXPRESSION_SYSTEM_VECTOR: PKK223-3 PELB;                             
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PRJ6C                                     
KEYWDS    FLAVIN, PHENOL HYDROXYLASE, MONOOXYGENASE, OXIDOREDUCTASE             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.ENROTH,H.NEUJAHR,G.SCHNEIDER,Y.LINDQVIST                            
REVDAT   1   17-JUN-98 1FOH    0                                                
JRNL        AUTH   C.ENROTH,H.NEUJAHR,G.SCHNEIDER,Y.LINDQVIST                   
JRNL        TITL   THE CRYSTAL STRUCTURE OF PHENOL HYDROXYLASE IN               
JRNL        TITL 2 COMPLEX WITH FAD AND PHENOL PROVIDES EVIDENCE FOR            
JRNL        TITL 3 A CONCERTED CONFORMATIONAL CHANGE IN THE ENZYME              
JRNL        TITL 4 AND ITS COFACTOR DURING CATALYSIS.                           
JRNL        REF    STRUCTURE                     V.   6   605 1998              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  1FOH A    1   664  UNP    P15245   PH2M_TRICU       1    664             
DBREF  1FOH B    1   664  UNP    P15245   PH2M_TRICU       1    664             
DBREF  1FOH C    1   664  UNP    P15245   PH2M_TRICU       1    664             
DBREF  1FOH D    1   664  UNP    P15245   PH2M_TRICU       1    664             
SEQRES   1 A  664  THR LYS TYR SER GLU SER TYR CYS ASP VAL LEU ILE VAL          
SEQRES   2 A  664  GLY ALA GLY PRO ALA GLY LEU MET ALA ALA ARG VAL LEU          
SEQRES   3 A  664  SER GLU TYR VAL ARG GLN LYS PRO ASP LEU LYS VAL ARG          
SEQRES   4 A  664  ILE ILE ASP LYS ARG SER THR LYS VAL TYR ASN GLY GLN          
SEQRES   5 A  664  ALA ASP GLY LEU GLN CYS ARG THR LEU GLU SER LEU LYS          
SEQRES   6 A  664  ASN LEU GLY LEU ALA ASP LYS ILE LEU SER GLU ALA ASN          
SEQRES   7 A  664  ASP MET SER THR ILE ALA LEU TYR ASN PRO ASP GLU ASN          
SEQRES   8 A  664  GLY HIS ILE ARG ARG THR ASP ARG ILE PRO ASP THR LEU          
SEQRES   9 A  664  PRO GLY ILE SER ARG TYR HIS GLN VAL VAL LEU HIS GLN          
SEQRES  10 A  664  GLY ARG ILE GLU ARG HIS ILE LEU ASP SER ILE ALA GLU          
SEQRES  11 A  664  ILE SER ASP THR ARG ILE LYS VAL GLU ARG PRO LEU ILE          
SEQRES  12 A  664  PRO GLU LYS MET GLU ILE ASP SER SER LYS ALA GLU ASP          
SEQRES  13 A  664  PRO GLU ALA TYR PRO VAL THR MET THR LEU ARG TYR MET          
SEQRES  14 A  664  SER ASP HIS GLU SER THR PRO LEU GLN PHE GLY HIS LYS          
SEQRES  15 A  664  THR GLU ASN SER LEU PHE HIS SER ASN LEU GLN THR GLN          
SEQRES  16 A  664  GLU GLU GLU ASP ALA ASN TYR ARG LEU PRO GLU GLY LYS          
SEQRES  17 A  664  GLU ALA GLY GLU ILE GLU THR VAL HIS CYS LYS TYR VAL          
SEQRES  18 A  664  ILE GLY CYS ASP GLY GLY HIS SER TRP VAL ARG ARG THR          
SEQRES  19 A  664  LEU GLY PHE GLU MET ILE GLY GLU GLN THR ASP TYR ILE          
SEQRES  20 A  664  TRP GLY VAL LEU ASP ALA VAL PRO ALA SER ASN PHE PRO          
SEQRES  21 A  664  ASP ILE ARG SER ARG CYS ALA ILE HIS SER ALA GLU SER          
SEQRES  22 A  664  GLY SER ILE MET ILE ILE PRO ARG GLU ASN ASN LEU VAL          
SEQRES  23 A  664  ARG PHE TYR VAL GLN LEU GLN ALA ARG ALA GLU LYS GLY          
SEQRES  24 A  664  GLY ARG VAL ASP ARG THR LYS PHE THR PRO GLU VAL VAL          
SEQRES  25 A  664  ILE ALA ASN ALA LYS LYS ILE PHE HIS PRO TYR THR PHE          
SEQRES  26 A  664  ASP VAL GLN GLN LEU ASP TRP PHE THR ALA TYR HIS ILE          
SEQRES  27 A  664  GLY GLN ARG VAL THR GLU LYS PHE SER LYS ASP GLU ARG          
SEQRES  28 A  664  VAL PHE ILE ALA GLY ASP ALA CYS HIS THR HIS SER PRO          
SEQRES  29 A  664  LYS ALA GLY GLN GLY MET ASN THR SER MET MET ASP THR          
SEQRES  30 A  664  TYR ASN LEU GLY TRP LYS LEU GLY LEU VAL LEU THR GLY          
SEQRES  31 A  664  ARG ALA LYS ARG ASP ILE LEU LYS THR TYR GLU GLU GLU          
SEQRES  32 A  664  ARG HIS ALA PHE ALA GLN ALA LEU ILE ASP PHE ASP HIS          
SEQRES  33 A  664  GLN PHE SER ARG LEU PHE SER GLY ARG PRO ALA LYS ASP          
SEQRES  34 A  664  VAL ALA ASP GLU MET GLY VAL SER MET ASP VAL PHE LYS          
SEQRES  35 A  664  GLU ALA PHE VAL LYS GLY ASN GLU PHE ALA SER GLY THR          
SEQRES  36 A  664  ALA ILE ASN TYR ASP GLU ASN LEU VAL THR ASP LYS LYS          
SEQRES  37 A  664  SER SER LYS GLN GLU LEU ALA LYS ASN CYS VAL VAL GLY          
SEQRES  38 A  664  THR ARG PHE LYS SER GLN PRO VAL VAL ARG HIS SER GLU          
SEQRES  39 A  664  GLY LEU TRP MET HIS PHE GLY ASP ARG LEU VAL THR ASP          
SEQRES  40 A  664  GLY ARG PHE ARG ILE ILE VAL PHE ALA GLY LYS ALA THR          
SEQRES  41 A  664  ASP ALA THR GLN MET SER ARG ILE LYS LYS PHE SER ALA          
SEQRES  42 A  664  TYR LEU ASP SER GLU ASN SER VAL ILE SER LEU TYR THR          
SEQRES  43 A  664  PRO LYS VAL SER ASP ARG ASN SER ARG ILE ASP VAL ILE          
SEQRES  44 A  664  THR ILE HIS SER CYS HIS ARG ASP ASP ILE GLU MET HIS          
SEQRES  45 A  664  ASP PHE PRO ALA PRO ALA LEU HIS PRO LYS TRP GLN TYR          
SEQRES  46 A  664  ASP PHE ILE TYR ALA ASP CYS ASP SER TRP HIS HIS PRO          
SEQRES  47 A  664  HIS PRO LYS SER TYR GLN ALA TRP GLY VAL ASP GLU THR          
SEQRES  48 A  664  LYS GLY ALA VAL VAL VAL VAL ARG PRO ASP GLY TYR THR          
SEQRES  49 A  664  SER LEU VAL THR ASP LEU GLU GLY THR ALA GLU ILE ASP          
SEQRES  50 A  664  ARG TYR PHE SER GLY ILE LEU VAL GLU PRO LYS GLU LYS          
SEQRES  51 A  664  SER GLY ALA GLN THR GLU ALA ASP TRP THR LYS SER THR          
SEQRES  52 A  664  ALA                                                          
SEQRES   1 B  664  THR LYS TYR SER GLU SER TYR CYS ASP VAL LEU ILE VAL          
SEQRES   2 B  664  GLY ALA GLY PRO ALA GLY LEU MET ALA ALA ARG VAL LEU          
SEQRES   3 B  664  SER GLU TYR VAL ARG GLN LYS PRO ASP LEU LYS VAL ARG          
SEQRES   4 B  664  ILE ILE ASP LYS ARG SER THR LYS VAL TYR ASN GLY GLN          
SEQRES   5 B  664  ALA ASP GLY LEU GLN CYS ARG THR LEU GLU SER LEU LYS          
SEQRES   6 B  664  ASN LEU GLY LEU ALA ASP LYS ILE LEU SER GLU ALA ASN          
SEQRES   7 B  664  ASP MET SER THR ILE ALA LEU TYR ASN PRO ASP GLU ASN          
SEQRES   8 B  664  GLY HIS ILE ARG ARG THR ASP ARG ILE PRO ASP THR LEU          
SEQRES   9 B  664  PRO GLY ILE SER ARG TYR HIS GLN VAL VAL LEU HIS GLN          
SEQRES  10 B  664  GLY ARG ILE GLU ARG HIS ILE LEU ASP SER ILE ALA GLU          
SEQRES  11 B  664  ILE SER ASP THR ARG ILE LYS VAL GLU ARG PRO LEU ILE          
SEQRES  12 B  664  PRO GLU LYS MET GLU ILE ASP SER SER LYS ALA GLU ASP          
SEQRES  13 B  664  PRO GLU ALA TYR PRO VAL THR MET THR LEU ARG TYR MET          
SEQRES  14 B  664  SER ASP HIS GLU SER THR PRO LEU GLN PHE GLY HIS LYS          
SEQRES  15 B  664  THR GLU ASN SER LEU PHE HIS SER ASN LEU GLN THR GLN          
SEQRES  16 B  664  GLU GLU GLU ASP ALA ASN TYR ARG LEU PRO GLU GLY LYS          
SEQRES  17 B  664  GLU ALA GLY GLU ILE GLU THR VAL HIS CYS LYS TYR VAL          
SEQRES  18 B  664  ILE GLY CYS ASP GLY GLY HIS SER TRP VAL ARG ARG THR          
SEQRES  19 B  664  LEU GLY PHE GLU MET ILE GLY GLU GLN THR ASP TYR ILE          
SEQRES  20 B  664  TRP GLY VAL LEU ASP ALA VAL PRO ALA SER ASN PHE PRO          
SEQRES  21 B  664  ASP ILE ARG SER ARG CYS ALA ILE HIS SER ALA GLU SER          
SEQRES  22 B  664  GLY SER ILE MET ILE ILE PRO ARG GLU ASN ASN LEU VAL          
SEQRES  23 B  664  ARG PHE TYR VAL GLN LEU GLN ALA ARG ALA GLU LYS GLY          
SEQRES  24 B  664  GLY ARG VAL ASP ARG THR LYS PHE THR PRO GLU VAL VAL          
SEQRES  25 B  664  ILE ALA ASN ALA LYS LYS ILE PHE HIS PRO TYR THR PHE          
SEQRES  26 B  664  ASP VAL GLN GLN LEU ASP TRP PHE THR ALA TYR HIS ILE          
SEQRES  27 B  664  GLY GLN ARG VAL THR GLU LYS PHE SER LYS ASP GLU ARG          
SEQRES  28 B  664  VAL PHE ILE ALA GLY ASP ALA CYS HIS THR HIS SER PRO          
SEQRES  29 B  664  LYS ALA GLY GLN GLY MET ASN THR SER MET MET ASP THR          
SEQRES  30 B  664  TYR ASN LEU GLY TRP LYS LEU GLY LEU VAL LEU THR GLY          
SEQRES  31 B  664  ARG ALA LYS ARG ASP ILE LEU LYS THR TYR GLU GLU GLU          
SEQRES  32 B  664  ARG HIS ALA PHE ALA GLN ALA LEU ILE ASP PHE ASP HIS          
SEQRES  33 B  664  GLN PHE SER ARG LEU PHE SER GLY ARG PRO ALA LYS ASP          
SEQRES  34 B  664  VAL ALA ASP GLU MET GLY VAL SER MET ASP VAL PHE LYS          
SEQRES  35 B  664  GLU ALA PHE VAL LYS GLY ASN GLU PHE ALA SER GLY THR          
SEQRES  36 B  664  ALA ILE ASN TYR ASP GLU ASN LEU VAL THR ASP LYS LYS          
SEQRES  37 B  664  SER SER LYS GLN GLU LEU ALA LYS ASN CYS VAL VAL GLY          
SEQRES  38 B  664  THR ARG PHE LYS SER GLN PRO VAL VAL ARG HIS SER GLU          
SEQRES  39 B  664  GLY LEU TRP MET HIS PHE GLY ASP ARG LEU VAL THR ASP          
SEQRES  40 B  664  GLY ARG PHE ARG ILE ILE VAL PHE ALA GLY LYS ALA THR          
SEQRES  41 B  664  ASP ALA THR GLN MET SER ARG ILE LYS LYS PHE SER ALA          
SEQRES  42 B  664  TYR LEU ASP SER GLU ASN SER VAL ILE SER LEU TYR THR          
SEQRES  43 B  664  PRO LYS VAL SER ASP ARG ASN SER ARG ILE ASP VAL ILE          
SEQRES  44 B  664  THR ILE HIS SER CYS HIS ARG ASP ASP ILE GLU MET HIS          
SEQRES  45 B  664  ASP PHE PRO ALA PRO ALA LEU HIS PRO LYS TRP GLN TYR          
SEQRES  46 B  664  ASP PHE ILE TYR ALA ASP CYS ASP SER TRP HIS HIS PRO          
SEQRES  47 B  664  HIS PRO LYS SER TYR GLN ALA TRP GLY VAL ASP GLU THR          
SEQRES  48 B  664  LYS GLY ALA VAL VAL VAL VAL ARG PRO ASP GLY TYR THR          
SEQRES  49 B  664  SER LEU VAL THR ASP LEU GLU GLY THR ALA GLU ILE ASP          
SEQRES  50 B  664  ARG TYR PHE SER GLY ILE LEU VAL GLU PRO LYS GLU LYS          
SEQRES  51 B  664  SER GLY ALA GLN THR GLU ALA ASP TRP THR LYS SER THR          
SEQRES  52 B  664  ALA                                                          
SEQRES   1 C  664  THR LYS TYR SER GLU SER TYR CYS ASP VAL LEU ILE VAL          
SEQRES   2 C  664  GLY ALA GLY PRO ALA GLY LEU MET ALA ALA ARG VAL LEU          
SEQRES   3 C  664  SER GLU TYR VAL ARG GLN LYS PRO ASP LEU LYS VAL ARG          
SEQRES   4 C  664  ILE ILE ASP LYS ARG SER THR LYS VAL TYR ASN GLY GLN          
SEQRES   5 C  664  ALA ASP GLY LEU GLN CYS ARG THR LEU GLU SER LEU LYS          
SEQRES   6 C  664  ASN LEU GLY LEU ALA ASP LYS ILE LEU SER GLU ALA ASN          
SEQRES   7 C  664  ASP MET SER THR ILE ALA LEU TYR ASN PRO ASP GLU ASN          
SEQRES   8 C  664  GLY HIS ILE ARG ARG THR ASP ARG ILE PRO ASP THR LEU          
SEQRES   9 C  664  PRO GLY ILE SER ARG TYR HIS GLN VAL VAL LEU HIS GLN          
SEQRES  10 C  664  GLY ARG ILE GLU ARG HIS ILE LEU ASP SER ILE ALA GLU          
SEQRES  11 C  664  ILE SER ASP THR ARG ILE LYS VAL GLU ARG PRO LEU ILE          
SEQRES  12 C  664  PRO GLU LYS MET GLU ILE ASP SER SER LYS ALA GLU ASP          
SEQRES  13 C  664  PRO GLU ALA TYR PRO VAL THR MET THR LEU ARG TYR MET          
SEQRES  14 C  664  SER ASP HIS GLU SER THR PRO LEU GLN PHE GLY HIS LYS          
SEQRES  15 C  664  THR GLU ASN SER LEU PHE HIS SER ASN LEU GLN THR GLN          
SEQRES  16 C  664  GLU GLU GLU ASP ALA ASN TYR ARG LEU PRO GLU GLY LYS          
SEQRES  17 C  664  GLU ALA GLY GLU ILE GLU THR VAL HIS CYS LYS TYR VAL          
SEQRES  18 C  664  ILE GLY CYS ASP GLY GLY HIS SER TRP VAL ARG ARG THR          
SEQRES  19 C  664  LEU GLY PHE GLU MET ILE GLY GLU GLN THR ASP TYR ILE          
SEQRES  20 C  664  TRP GLY VAL LEU ASP ALA VAL PRO ALA SER ASN PHE PRO          
SEQRES  21 C  664  ASP ILE ARG SER ARG CYS ALA ILE HIS SER ALA GLU SER          
SEQRES  22 C  664  GLY SER ILE MET ILE ILE PRO ARG GLU ASN ASN LEU VAL          
SEQRES  23 C  664  ARG PHE TYR VAL GLN LEU GLN ALA ARG ALA GLU LYS GLY          
SEQRES  24 C  664  GLY ARG VAL ASP ARG THR LYS PHE THR PRO GLU VAL VAL          
SEQRES  25 C  664  ILE ALA ASN ALA LYS LYS ILE PHE HIS PRO TYR THR PHE          
SEQRES  26 C  664  ASP VAL GLN GLN LEU ASP TRP PHE THR ALA TYR HIS ILE          
SEQRES  27 C  664  GLY GLN ARG VAL THR GLU LYS PHE SER LYS ASP GLU ARG          
SEQRES  28 C  664  VAL PHE ILE ALA GLY ASP ALA CYS HIS THR HIS SER PRO          
SEQRES  29 C  664  LYS ALA GLY GLN GLY MET ASN THR SER MET MET ASP THR          
SEQRES  30 C  664  TYR ASN LEU GLY TRP LYS LEU GLY LEU VAL LEU THR GLY          
SEQRES  31 C  664  ARG ALA LYS ARG ASP ILE LEU LYS THR TYR GLU GLU GLU          
SEQRES  32 C  664  ARG HIS ALA PHE ALA GLN ALA LEU ILE ASP PHE ASP HIS          
SEQRES  33 C  664  GLN PHE SER ARG LEU PHE SER GLY ARG PRO ALA LYS ASP          
SEQRES  34 C  664  VAL ALA ASP GLU MET GLY VAL SER MET ASP VAL PHE LYS          
SEQRES  35 C  664  GLU ALA PHE VAL LYS GLY ASN GLU PHE ALA SER GLY THR          
SEQRES  36 C  664  ALA ILE ASN TYR ASP GLU ASN LEU VAL THR ASP LYS LYS          
SEQRES  37 C  664  SER SER LYS GLN GLU LEU ALA LYS ASN CYS VAL VAL GLY          
SEQRES  38 C  664  THR ARG PHE LYS SER GLN PRO VAL VAL ARG HIS SER GLU          
SEQRES  39 C  664  GLY LEU TRP MET HIS PHE GLY ASP ARG LEU VAL THR ASP          
SEQRES  40 C  664  GLY ARG PHE ARG ILE ILE VAL PHE ALA GLY LYS ALA THR          
SEQRES  41 C  664  ASP ALA THR GLN MET SER ARG ILE LYS LYS PHE SER ALA          
SEQRES  42 C  664  TYR LEU ASP SER GLU ASN SER VAL ILE SER LEU TYR THR          
SEQRES  43 C  664  PRO LYS VAL SER ASP ARG ASN SER ARG ILE ASP VAL ILE          
SEQRES  44 C  664  THR ILE HIS SER CYS HIS ARG ASP ASP ILE GLU MET HIS          
SEQRES  45 C  664  ASP PHE PRO ALA PRO ALA LEU HIS PRO LYS TRP GLN TYR          
SEQRES  46 C  664  ASP PHE ILE TYR ALA ASP CYS ASP SER TRP HIS HIS PRO          
SEQRES  47 C  664  HIS PRO LYS SER TYR GLN ALA TRP GLY VAL ASP GLU THR          
SEQRES  48 C  664  LYS GLY ALA VAL VAL VAL VAL ARG PRO ASP GLY TYR THR          
SEQRES  49 C  664  SER LEU VAL THR ASP LEU GLU GLY THR ALA GLU ILE ASP          
SEQRES  50 C  664  ARG TYR PHE SER GLY ILE LEU VAL GLU PRO LYS GLU LYS          
SEQRES  51 C  664  SER GLY ALA GLN THR GLU ALA ASP TRP THR LYS SER THR          
SEQRES  52 C  664  ALA                                                          
SEQRES   1 D  664  THR LYS TYR SER GLU SER TYR CYS ASP VAL LEU ILE VAL          
SEQRES   2 D  664  GLY ALA GLY PRO ALA GLY LEU MET ALA ALA ARG VAL LEU          
SEQRES   3 D  664  SER GLU TYR VAL ARG GLN LYS PRO ASP LEU LYS VAL ARG          
SEQRES   4 D  664  ILE ILE ASP LYS ARG SER THR LYS VAL TYR ASN GLY GLN          
SEQRES   5 D  664  ALA ASP GLY LEU GLN CYS ARG THR LEU GLU SER LEU LYS          
SEQRES   6 D  664  ASN LEU GLY LEU ALA ASP LYS ILE LEU SER GLU ALA ASN          
SEQRES   7 D  664  ASP MET SER THR ILE ALA LEU TYR ASN PRO ASP GLU ASN          
SEQRES   8 D  664  GLY HIS ILE ARG ARG THR ASP ARG ILE PRO ASP THR LEU          
SEQRES   9 D  664  PRO GLY ILE SER ARG TYR HIS GLN VAL VAL LEU HIS GLN          
SEQRES  10 D  664  GLY ARG ILE GLU ARG HIS ILE LEU ASP SER ILE ALA GLU          
SEQRES  11 D  664  ILE SER ASP THR ARG ILE LYS VAL GLU ARG PRO LEU ILE          
SEQRES  12 D  664  PRO GLU LYS MET GLU ILE ASP SER SER LYS ALA GLU ASP          
SEQRES  13 D  664  PRO GLU ALA TYR PRO VAL THR MET THR LEU ARG TYR MET          
SEQRES  14 D  664  SER ASP HIS GLU SER THR PRO LEU GLN PHE GLY HIS LYS          
SEQRES  15 D  664  THR GLU ASN SER LEU PHE HIS SER ASN LEU GLN THR GLN          
SEQRES  16 D  664  GLU GLU GLU ASP ALA ASN TYR ARG LEU PRO GLU GLY LYS          
SEQRES  17 D  664  GLU ALA GLY GLU ILE GLU THR VAL HIS CYS LYS TYR VAL          
SEQRES  18 D  664  ILE GLY CYS ASP GLY GLY HIS SER TRP VAL ARG ARG THR          
SEQRES  19 D  664  LEU GLY PHE GLU MET ILE GLY GLU GLN THR ASP TYR ILE          
SEQRES  20 D  664  TRP GLY VAL LEU ASP ALA VAL PRO ALA SER ASN PHE PRO          
SEQRES  21 D  664  ASP ILE ARG SER ARG CYS ALA ILE HIS SER ALA GLU SER          
SEQRES  22 D  664  GLY SER ILE MET ILE ILE PRO ARG GLU ASN ASN LEU VAL          
SEQRES  23 D  664  ARG PHE TYR VAL GLN LEU GLN ALA ARG ALA GLU LYS GLY          
SEQRES  24 D  664  GLY ARG VAL ASP ARG THR LYS PHE THR PRO GLU VAL VAL          
SEQRES  25 D  664  ILE ALA ASN ALA LYS LYS ILE PHE HIS PRO TYR THR PHE          
SEQRES  26 D  664  ASP VAL GLN GLN LEU ASP TRP PHE THR ALA TYR HIS ILE          
SEQRES  27 D  664  GLY GLN ARG VAL THR GLU LYS PHE SER LYS ASP GLU ARG          
SEQRES  28 D  664  VAL PHE ILE ALA GLY ASP ALA CYS HIS THR HIS SER PRO          
SEQRES  29 D  664  LYS ALA GLY GLN GLY MET ASN THR SER MET MET ASP THR          
SEQRES  30 D  664  TYR ASN LEU GLY TRP LYS LEU GLY LEU VAL LEU THR GLY          
SEQRES  31 D  664  ARG ALA LYS ARG ASP ILE LEU LYS THR TYR GLU GLU GLU          
SEQRES  32 D  664  ARG HIS ALA PHE ALA GLN ALA LEU ILE ASP PHE ASP HIS          
SEQRES  33 D  664  GLN PHE SER ARG LEU PHE SER GLY ARG PRO ALA LYS ASP          
SEQRES  34 D  664  VAL ALA ASP GLU MET GLY VAL SER MET ASP VAL PHE LYS          
SEQRES  35 D  664  GLU ALA PHE VAL LYS GLY ASN GLU PHE ALA SER GLY THR          
SEQRES  36 D  664  ALA ILE ASN TYR ASP GLU ASN LEU VAL THR ASP LYS LYS          
SEQRES  37 D  664  SER SER LYS GLN GLU LEU ALA LYS ASN CYS VAL VAL GLY          
SEQRES  38 D  664  THR ARG PHE LYS SER GLN PRO VAL VAL ARG HIS SER GLU          
SEQRES  39 D  664  GLY LEU TRP MET HIS PHE GLY ASP ARG LEU VAL THR ASP          
SEQRES  40 D  664  GLY ARG PHE ARG ILE ILE VAL PHE ALA GLY LYS ALA THR          
SEQRES  41 D  664  ASP ALA THR GLN MET SER ARG ILE LYS LYS PHE SER ALA          
SEQRES  42 D  664  TYR LEU ASP SER GLU ASN SER VAL ILE SER LEU TYR THR          
SEQRES  43 D  664  PRO LYS VAL SER ASP ARG ASN SER ARG ILE ASP VAL ILE          
SEQRES  44 D  664  THR ILE HIS SER CYS HIS ARG ASP ASP ILE GLU MET HIS          
SEQRES  45 D  664  ASP PHE PRO ALA PRO ALA LEU HIS PRO LYS TRP GLN TYR          
SEQRES  46 D  664  ASP PHE ILE TYR ALA ASP CYS ASP SER TRP HIS HIS PRO          
SEQRES  47 D  664  HIS PRO LYS SER TYR GLN ALA TRP GLY VAL ASP GLU THR          
SEQRES  48 D  664  LYS GLY ALA VAL VAL VAL VAL ARG PRO ASP GLY TYR THR          
SEQRES  49 D  664  SER LEU VAL THR ASP LEU GLU GLY THR ALA GLU ILE ASP          
SEQRES  50 D  664  ARG TYR PHE SER GLY ILE LEU VAL GLU PRO LYS GLU LYS          
SEQRES  51 D  664  SER GLY ALA GLN THR GLU ALA ASP TRP THR LYS SER THR          
SEQRES  52 D  664  ALA                                                          
HET    FAD  A 801      53                                                       
HET    IPH  A 802       7                                                       
HET    FAD  B 801      53                                                       
HET    IPH  B 802       7                                                       
HET    FAD  C 801      53                                                       
HET    IPH  C 802       7                                                       
HET    FAD  D 801      53                                                       
HET    IPH  D 802       7                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
HETNAM     IPH PHENOL                                                           
FORMUL   5  FAD    4(C27 H33 N9 O15 P2)                                         
FORMUL   6  IPH    4(C6 H6 O)                                                   
FORMUL  13  HOH   *1189(H2 O)                                                   
CRYST1  100.030  150.680  114.920  90.00 114.68  90.00 P 1 21 1      8          
ATOM  10363  N   THR C   1      35.494  44.088   5.887  1.00 49.86           N  
ATOM  10364  CA  THR C   1      35.918  44.170   4.451  1.00 50.21           C  
ATOM  10365  C   THR C   1      35.373  45.377   3.715  1.00 48.70           C  
ATOM  10366  O   THR C   1      36.226  46.007   3.061  1.00 49.58           O  
ATOM  10367  CB  THR C   1      35.685  42.869   3.686  1.00 53.24           C  
ATOM  10368  OG1 THR C   1      36.887  42.059   3.842  1.00 54.68           O  
ATOM  10369  CG2 THR C   1      35.390  43.012   2.203  1.00 54.36           C  
ATOM  10370  N   LYS C   2      34.091  45.723   3.690  1.00 44.74           N  
ATOM  10371  CA  LYS C   2      33.762  47.011   3.067  1.00 42.45           C  
ATOM  10372  C   LYS C   2      33.462  48.053   4.159  1.00 42.17           C  
ATOM  10373  O   LYS C   2      32.715  47.813   5.079  1.00 37.88           O  
ATOM  10374  CB  LYS C   2      32.668  46.976   2.033  1.00 42.86           C  
ATOM  10375  CG  LYS C   2      32.382  48.364   1.493  1.00 42.96           C  
ATOM  10376  CD  LYS C   2      31.841  48.377   0.085  1.00 46.35           C  
ATOM  10377  CE  LYS C   2      30.318  48.300   0.070  1.00 49.62           C  
ATOM  10378  NZ  LYS C   2      29.822  48.972  -1.167  1.00 50.33           N  
ATOM  10379  N   TYR C   3      34.095  49.213   4.057  1.00 39.41           N  
ATOM  10380  CA  TYR C   3      33.941  50.315   4.993  1.00 40.96           C  
ATOM  10381  C   TYR C   3      33.176  51.443   4.320  1.00 38.51           C  
ATOM  10382  O   TYR C   3      33.613  51.806   3.227  1.00 37.36           O  
ATOM  10383  CB  TYR C   3      35.320  50.887   5.415  1.00 41.00           C  
ATOM  10384  CG  TYR C   3      35.981  49.849   6.299  1.00 41.51           C  
ATOM  10385  CD1 TYR C   3      35.676  49.846   7.654  1.00 40.43           C  
ATOM  10386  CD2 TYR C   3      36.785  48.857   5.784  1.00 39.28           C  
ATOM  10387  CE1 TYR C   3      36.163  48.853   8.488  1.00 39.78           C  
ATOM  10388  CE2 TYR C   3      37.274  47.860   6.612  1.00 39.89           C  
ATOM  10389  CZ  TYR C   3      36.966  47.874   7.960  1.00 41.67           C  
ATOM  10390  OH  TYR C   3      37.487  46.913   8.799  1.00 44.47           O  
ATOM  10391  N   SER C   4      32.059  51.865   4.912  1.00 36.98           N  
ATOM  10392  CA  SER C   4      31.304  52.915   4.212  1.00 37.30           C  
ATOM  10393  C   SER C   4      30.898  54.042   5.134  1.00 35.20           C  
ATOM  10394  O   SER C   4      31.029  53.928   6.333  1.00 33.06           O  
ATOM  10395  CB  SER C   4      30.077  52.308   3.519  1.00 37.06           C  
ATOM  10396  OG  SER C   4      29.227  51.743   4.512  1.00 41.99           O  
ATOM  10397  N   GLU C   5      30.435  55.143   4.545  1.00 34.07           N  
ATOM  10398  CA  GLU C   5      30.072  56.271   5.402  1.00 35.77           C  
ATOM  10399  C   GLU C   5      28.861  56.986   4.838  1.00 35.94           C  
ATOM  10400  O   GLU C   5      28.818  57.230   3.643  1.00 36.35           O  
ATOM  10401  CB  GLU C   5      31.293  57.161   5.582  1.00 36.67           C  
ATOM  10402  CG  GLU C   5      31.070  58.414   6.423  1.00 42.79           C  
ATOM  10403  CD  GLU C   5      32.374  59.157   6.684  1.00 45.45           C  
ATOM  10404  OE1 GLU C   5      33.297  59.071   5.847  1.00 52.82           O  
ATOM  10405  OE2 GLU C   5      32.441  59.839   7.737  1.00 44.58           O  
ATOM  10406  N   SER C   6      27.937  57.403   5.696  1.00 32.75           N  
ATOM  10407  CA  SER C   6      26.795  58.183   5.235  1.00 36.36           C  
ATOM  10408  C   SER C   6      26.144  58.962   6.360  1.00 38.13           C  
ATOM  10409  O   SER C   6      26.509  58.913   7.532  1.00 39.47           O  
ATOM  10410  CB  SER C   6      25.719  57.263   4.603  1.00 35.25           C  
ATOM  10411  OG  SER C   6      25.248  56.420   5.657  1.00 30.99           O  
ATOM  10412  N   TYR C   7      25.188  59.778   5.968  1.00 38.66           N  
ATOM  10413  CA  TYR C   7      24.448  60.652   6.863  1.00 41.65           C  
ATOM  10414  C   TYR C   7      22.949  60.340   6.880  1.00 41.58           C  
ATOM  10415  O   TYR C   7      22.420  59.986   5.829  1.00 39.66           O  
ATOM  10416  CB  TYR C   7      24.590  62.115   6.367  1.00 42.01           C  
ATOM  10417  CG  TYR C   7      26.013  62.599   6.569  1.00 46.93           C  
ATOM  10418  CD1 TYR C   7      27.017  62.306   5.657  1.00 45.57           C  
ATOM  10419  CD2 TYR C   7      26.341  63.355   7.692  1.00 48.08           C  
ATOM  10420  CE1 TYR C   7      28.315  62.719   5.841  1.00 46.06           C  
ATOM  10421  CE2 TYR C   7      27.643  63.794   7.887  1.00 47.30           C  
ATOM  10422  CZ  TYR C   7      28.612  63.463   6.964  1.00 48.82           C  
ATOM  10423  OH  TYR C   7      29.896  63.914   7.171  1.00 51.27           O  
ATOM  10424  N   CYS C   8      22.306  60.598   8.027  1.00 39.69           N  
ATOM  10425  CA  CYS C   8      20.849  60.459   8.057  1.00 40.05           C  
ATOM  10426  C   CYS C   8      20.227  61.268   9.191  1.00 38.42           C  
ATOM  10427  O   CYS C   8      20.805  61.471  10.259  1.00 37.57           O  
ATOM  10428  CB  CYS C   8      20.323  59.038   8.113  1.00 38.95           C  
ATOM  10429  SG  CYS C   8      20.392  58.220   9.708  1.00 37.71           S  
ATOM  10430  N   ASP C   9      19.029  61.748   8.900  1.00 37.30           N  
ATOM  10431  CA  ASP C   9      18.278  62.533   9.898  1.00 36.43           C  
ATOM  10432  C   ASP C   9      17.893  61.667  11.071  1.00 33.68           C  
ATOM  10433  O   ASP C   9      18.222  61.982  12.227  1.00 34.65           O  
ATOM  10434  CB  ASP C   9      17.056  63.144   9.217  1.00 35.88           C  
ATOM  10435  CG  ASP C   9      17.597  64.030   8.081  1.00 34.74           C  
ATOM  10436  OD1 ASP C   9      18.405  64.904   8.425  1.00 37.02           O  
ATOM  10437  OD2 ASP C   9      17.212  63.821   6.927  1.00 33.76           O  
ATOM  10438  N   VAL C  10      17.218  60.543  10.843  1.00 32.45           N  
ATOM  10439  CA  VAL C  10      16.864  59.664  11.962  1.00 31.51           C  
ATOM  10440  C   VAL C  10      17.298  58.231  11.708  1.00 32.70           C  
ATOM  10441  O   VAL C  10      17.105  57.746  10.598  1.00 34.02           O  
ATOM  10442  CB  VAL C  10      15.346  59.610  12.228  1.00 31.56           C  
ATOM  10443  CG1 VAL C  10      15.032  58.795  13.473  1.00 26.48           C  
ATOM  10444  CG2 VAL C  10      14.705  60.979  12.286  1.00 27.30           C  
ATOM  10445  N   LEU C  11      17.801  57.556  12.715  1.00 31.89           N  
ATOM  10446  CA  LEU C  11      18.114  56.152  12.689  1.00 31.70           C  
ATOM  10447  C   LEU C  11      17.272  55.451  13.774  1.00 32.76           C  
ATOM  10448  O   LEU C  11      17.412  55.765  14.956  1.00 30.74           O  
ATOM  10449  CB  LEU C  11      19.597  55.800  12.898  1.00 31.96           C  
ATOM  10450  CG  LEU C  11      19.905  54.293  12.923  1.00 33.97           C  
ATOM  10451  CD1 LEU C  11      19.518  53.638  11.600  1.00 30.27           C  
ATOM  10452  CD2 LEU C  11      21.368  53.988  13.256  1.00 32.25           C  
ATOM  10453  N   ILE C  12      16.417  54.518  13.377  1.00 30.99           N  
ATOM  10454  CA  ILE C  12      15.597  53.791  14.329  1.00 28.66           C  
ATOM  10455  C   ILE C  12      16.266  52.432  14.495  1.00 31.11           C  
ATOM  10456  O   ILE C  12      16.409  51.762  13.470  1.00 34.82           O  
ATOM  10457  CB  ILE C  12      14.158  53.607  13.816  1.00 30.48           C  
ATOM  10458  CG1 ILE C  12      13.476  54.980  13.640  1.00 27.53           C  
ATOM  10459  CG2 ILE C  12      13.344  52.682  14.699  1.00 21.57           C  
ATOM  10460  CD1 ILE C  12      12.331  54.941  12.640  1.00 25.58           C  
ATOM  10461  N   VAL C  13      16.729  52.064  15.674  1.00 29.95           N  
ATOM  10462  CA  VAL C  13      17.368  50.781  15.873  1.00 30.85           C  
ATOM  10463  C   VAL C  13      16.324  49.794  16.402  1.00 33.60           C  
ATOM  10464  O   VAL C  13      16.016  49.847  17.583  1.00 31.73           O  
ATOM  10465  CB  VAL C  13      18.533  50.889  16.882  1.00 32.16           C  
ATOM  10466  CG1 VAL C  13      19.228  49.546  17.113  1.00 26.42           C  
ATOM  10467  CG2 VAL C  13      19.557  51.918  16.410  1.00 27.96           C  
ATOM  10468  N   GLY C  14      15.799  48.887  15.578  1.00 32.77           N  
ATOM  10469  CA  GLY C  14      14.800  47.941  16.093  1.00 32.93           C  
ATOM  10470  C   GLY C  14      13.534  48.116  15.245  1.00 32.84           C  
ATOM  10471  O   GLY C  14      13.052  49.235  15.087  1.00 31.50           O  
ATOM  10472  N   ALA C  15      13.038  47.025  14.677  1.00 31.04           N  
ATOM  10473  CA  ALA C  15      11.852  47.122  13.841  1.00 33.39           C  
ATOM  10474  C   ALA C  15      10.719  46.271  14.408  1.00 31.65           C  
ATOM  10475  O   ALA C  15      10.022  45.570  13.692  1.00 32.12           O  
ATOM  10476  CB  ALA C  15      12.156  46.773  12.394  1.00 32.12           C  
ATOM  10477  N   GLY C  16      10.560  46.341  15.716  1.00 32.65           N  
ATOM  10478  CA  GLY C  16       9.441  45.704  16.405  1.00 31.75           C  
ATOM  10479  C   GLY C  16       8.328  46.767  16.414  1.00 30.21           C  
ATOM  10480  O   GLY C  16       8.450  47.809  15.744  1.00 29.73           O  
ATOM  10481  N   PRO C  17       7.300  46.554  17.209  1.00 29.40           N  
ATOM  10482  CA  PRO C  17       6.175  47.469  17.280  1.00 29.27           C  
ATOM  10483  C   PRO C  17       6.607  48.900  17.505  1.00 29.41           C  
ATOM  10484  O   PRO C  17       6.217  49.856  16.829  1.00 30.81           O  
ATOM  10485  CB  PRO C  17       5.340  46.914  18.451  1.00 31.17           C  
ATOM  10486  CG  PRO C  17       5.643  45.447  18.472  1.00 30.72           C  
ATOM  10487  CD  PRO C  17       7.106  45.356  18.063  1.00 29.16           C  
ATOM  10488  N   ALA C  18       7.458  49.196  18.474  1.00 30.91           N  
ATOM  10489  CA  ALA C  18       7.918  50.551  18.726  1.00 28.52           C  
ATOM  10490  C   ALA C  18       8.579  51.109  17.476  1.00 29.66           C  
ATOM  10491  O   ALA C  18       8.273  52.207  17.028  1.00 30.16           O  
ATOM  10492  CB  ALA C  18       8.933  50.548  19.873  1.00 29.96           C  
ATOM  10493  N   GLY C  19       9.576  50.402  16.932  1.00 29.32           N  
ATOM  10494  CA  GLY C  19      10.333  50.910  15.790  1.00 24.46           C  
ATOM  10495  C   GLY C  19       9.477  51.155  14.588  1.00 25.41           C  
ATOM  10496  O   GLY C  19       9.562  52.157  13.888  1.00 27.85           O  
ATOM  10497  N   LEU C  20       8.568  50.215  14.293  1.00 27.58           N  
ATOM  10498  CA  LEU C  20       7.677  50.356  13.150  1.00 28.59           C  
ATOM  10499  C   LEU C  20       6.704  51.516  13.297  1.00 29.27           C  
ATOM  10500  O   LEU C  20       6.406  52.216  12.318  1.00 29.58           O  
ATOM  10501  CB  LEU C  20       6.895  49.057  12.927  1.00 29.73           C  
ATOM  10502  CG  LEU C  20       7.699  47.840  12.473  1.00 31.37           C  
ATOM  10503  CD1 LEU C  20       6.791  46.628  12.507  1.00 29.69           C  
ATOM  10504  CD2 LEU C  20       8.365  48.121  11.122  1.00 26.63           C  
ATOM  10505  N   MET C  21       6.203  51.724  14.525  1.00 26.78           N  
ATOM  10506  CA  MET C  21       5.339  52.901  14.728  1.00 26.94           C  
ATOM  10507  C   MET C  21       6.166  54.173  14.504  1.00 27.44           C  
ATOM  10508  O   MET C  21       5.680  55.147  13.900  1.00 27.49           O  
ATOM  10509  CB  MET C  21       4.689  52.894  16.110  1.00 28.76           C  
ATOM  10510  CG  MET C  21       3.954  54.193  16.404  1.00 25.76           C  
ATOM  10511  SD  MET C  21       2.477  54.420  15.351  1.00 29.13           S  
ATOM  10512  CE  MET C  21       1.424  53.133  15.994  1.00 21.22           C  
ATOM  10513  N   ALA C  22       7.433  54.178  14.988  1.00 25.41           N  
ATOM  10514  CA  ALA C  22       8.265  55.345  14.764  1.00 28.46           C  
ATOM  10515  C   ALA C  22       8.366  55.568  13.262  1.00 28.29           C  
ATOM  10516  O   ALA C  22       8.188  56.686  12.800  1.00 30.63           O  
ATOM  10517  CB  ALA C  22       9.657  55.217  15.405  1.00 26.30           C  
ATOM  10518  N   ALA C  23       8.674  54.530  12.478  1.00 26.87           N  
ATOM  10519  CA  ALA C  23       8.794  54.705  11.040  1.00 27.43           C  
ATOM  10520  C   ALA C  23       7.514  55.182  10.378  1.00 27.40           C  
ATOM  10521  O   ALA C  23       7.481  56.039   9.460  1.00 25.86           O  
ATOM  10522  CB  ALA C  23       9.256  53.374  10.447  1.00 29.92           C  
ATOM  10523  N   ARG C  24       6.382  54.609  10.828  1.00 27.85           N  
ATOM  10524  CA  ARG C  24       5.081  54.966  10.248  1.00 26.28           C  
ATOM  10525  C   ARG C  24       4.771  56.422  10.520  1.00 26.51           C  
ATOM  10526  O   ARG C  24       4.280  57.138   9.632  1.00 26.84           O  
ATOM  10527  CB  ARG C  24       3.991  54.047  10.829  1.00 29.76           C  
ATOM  10528  CG  ARG C  24       2.549  54.479  10.655  1.00 27.51           C  
ATOM  10529  CD  ARG C  24       2.216  54.689   9.193  1.00 26.99           C  
ATOM  10530  NE  ARG C  24       0.874  55.232   8.930  1.00 29.20           N  
ATOM  10531  CZ  ARG C  24       0.545  56.513   8.907  1.00 32.20           C  
ATOM  10532  NH1 ARG C  24       1.404  57.517   9.137  1.00 27.18           N  
ATOM  10533  NH2 ARG C  24      -0.712  56.839   8.632  1.00 27.90           N  
ATOM  10534  N   VAL C  25       5.032  56.875  11.761  1.00 27.13           N  
ATOM  10535  CA  VAL C  25       4.766  58.289  12.048  1.00 30.12           C  
ATOM  10536  C   VAL C  25       5.726  59.156  11.251  1.00 30.20           C  
ATOM  10537  O   VAL C  25       5.281  60.089  10.605  1.00 29.01           O  
ATOM  10538  CB  VAL C  25       4.806  58.598  13.553  1.00 33.30           C  
ATOM  10539  CG1 VAL C  25       4.737  60.088  13.853  1.00 27.40           C  
ATOM  10540  CG2 VAL C  25       3.644  57.877  14.214  1.00 26.77           C  
ATOM  10541  N   LEU C  26       7.011  58.813  11.211  1.00 31.35           N  
ATOM  10542  CA  LEU C  26       7.979  59.658  10.497  1.00 31.74           C  
ATOM  10543  C   LEU C  26       7.743  59.697   9.016  1.00 31.58           C  
ATOM  10544  O   LEU C  26       7.996  60.712   8.328  1.00 30.99           O  
ATOM  10545  CB  LEU C  26       9.400  59.262  10.893  1.00 32.12           C  
ATOM  10546  CG  LEU C  26       9.738  59.593  12.359  1.00 32.86           C  
ATOM  10547  CD1 LEU C  26      11.039  58.941  12.778  1.00 28.81           C  
ATOM  10548  CD2 LEU C  26       9.764  61.123  12.491  1.00 27.46           C  
ATOM  10549  N   SER C  27       7.208  58.606   8.460  1.00 31.19           N  
ATOM  10550  CA  SER C  27       6.886  58.534   7.036  1.00 32.24           C  
ATOM  10551  C   SER C  27       6.103  59.720   6.524  1.00 31.57           C  
ATOM  10552  O   SER C  27       6.286  60.113   5.373  1.00 32.24           O  
ATOM  10553  CB  SER C  27       6.021  57.283   6.763  1.00 34.87           C  
ATOM  10554  OG  SER C  27       6.883  56.166   6.948  1.00 42.38           O  
ATOM  10555  N   GLU C  28       5.166  60.252   7.319  1.00 31.56           N  
ATOM  10556  CA  GLU C  28       4.368  61.387   6.924  1.00 29.81           C  
ATOM  10557  C   GLU C  28       5.224  62.615   6.690  1.00 29.20           C  
ATOM  10558  O   GLU C  28       5.082  63.329   5.706  1.00 29.34           O  
ATOM  10559  CB  GLU C  28       3.265  61.641   7.940  1.00 32.03           C  
ATOM  10560  CG  GLU C  28       2.290  62.771   7.546  1.00 28.44           C  
ATOM  10561  CD  GLU C  28       1.146  62.263   6.689  1.00 34.59           C  
ATOM  10562  OE1 GLU C  28       0.575  61.197   7.010  1.00 35.33           O  
ATOM  10563  OE2 GLU C  28       0.793  62.884   5.672  1.00 38.33           O  
ATOM  10564  N   TYR C  29       6.156  62.897   7.579  1.00 29.69           N  
ATOM  10565  CA  TYR C  29       7.046  64.053   7.428  1.00 31.19           C  
ATOM  10566  C   TYR C  29       8.005  63.823   6.265  1.00 31.44           C  
ATOM  10567  O   TYR C  29       8.271  64.757   5.498  1.00 31.86           O  
ATOM  10568  CB  TYR C  29       7.722  64.324   8.775  1.00 30.81           C  
ATOM  10569  CG  TYR C  29       6.682  64.467   9.883  1.00 32.53           C  
ATOM  10570  CD1 TYR C  29       6.090  65.705  10.162  1.00 32.00           C  
ATOM  10571  CD2 TYR C  29       6.307  63.360  10.628  1.00 31.54           C  
ATOM  10572  CE1 TYR C  29       5.127  65.830  11.142  1.00 31.10           C  
ATOM  10573  CE2 TYR C  29       5.359  63.489  11.641  1.00 33.52           C  
ATOM  10574  CZ  TYR C  29       4.771  64.720  11.877  1.00 33.44           C  
ATOM  10575  OH  TYR C  29       3.833  64.804  12.883  1.00 35.63           O  
ATOM  10576  N   VAL C  30       8.415  62.575   6.019  1.00 31.47           N  
ATOM  10577  CA  VAL C  30       9.259  62.262   4.865  1.00 33.36           C  
ATOM  10578  C   VAL C  30       8.481  62.541   3.593  1.00 34.14           C  
ATOM  10579  O   VAL C  30       9.024  63.147   2.693  1.00 34.31           O  
ATOM  10580  CB  VAL C  30       9.834  60.839   4.871  1.00 31.98           C  
ATOM  10581  CG1 VAL C  30      10.477  60.424   3.542  1.00 26.33           C  
ATOM  10582  CG2 VAL C  30      10.850  60.699   5.994  1.00 26.99           C  
ATOM  10583  N   ARG C  31       7.206  62.185   3.469  1.00 35.04           N  
ATOM  10584  CA  ARG C  31       6.419  62.528   2.297  1.00 34.83           C  
ATOM  10585  C   ARG C  31       6.277  64.033   2.119  1.00 36.03           C  
ATOM  10586  O   ARG C  31       6.221  64.545   1.003  1.00 37.69           O  
ATOM  10587  CB  ARG C  31       5.021  61.929   2.381  1.00 32.41           C  
ATOM  10588  CG  ARG C  31       4.058  62.263   1.268  1.00 33.67           C  
ATOM  10589  CD  ARG C  31       2.900  61.303   1.228  1.00 37.77           C  
ATOM  10590  NE  ARG C  31       2.010  61.405   2.384  1.00 46.41           N  
ATOM  10591  CZ  ARG C  31       0.845  60.774   2.508  1.00 46.99           C  
ATOM  10592  NH1 ARG C  31       0.430  59.980   1.531  1.00 45.82           N  
ATOM  10593  NH2 ARG C  31       0.093  60.877   3.578  1.00 42.57           N  
ATOM  10594  N   GLN C  32       6.217  64.804   3.197  1.00 35.64           N  
ATOM  10595  CA  GLN C  32       6.095  66.261   3.016  1.00 38.33           C  
ATOM  10596  C   GLN C  32       7.445  66.879   2.642  1.00 36.75           C  
ATOM  10597  O   GLN C  32       7.507  67.893   1.958  1.00 36.06           O  
ATOM  10598  CB  GLN C  32       5.532  66.879   4.282  1.00 39.17           C  
ATOM  10599  CG  GLN C  32       4.111  66.512   4.639  1.00 35.25           C  
ATOM  10600  CD  GLN C  32       3.802  66.678   6.122  1.00 40.50           C  
ATOM  10601  OE1 GLN C  32       4.670  67.007   6.925  1.00 41.73           O  
ATOM  10602  NE2 GLN C  32       2.551  66.424   6.506  1.00 37.51           N  
ATOM  10603  N   LYS C  33       8.543  66.296   3.115  1.00 34.84           N  
ATOM  10604  CA  LYS C  33       9.875  66.821   2.783  1.00 37.86           C  
ATOM  10605  C   LYS C  33      10.792  65.644   2.459  1.00 35.87           C  
ATOM  10606  O   LYS C  33      11.428  64.984   3.284  1.00 36.00           O  
ATOM  10607  CB  LYS C  33      10.402  67.778   3.815  1.00 38.36           C  
ATOM  10608  CG  LYS C  33      11.834  67.674   4.237  1.00 42.28           C  
ATOM  10609  CD  LYS C  33      12.136  68.761   5.276  1.00 45.95           C  
ATOM  10610  CE  LYS C  33      13.593  69.199   5.148  1.00 49.75           C  
ATOM  10611  NZ  LYS C  33      14.136  69.367   6.538  1.00 54.79           N  
ATOM  10612  N   PRO C  34      10.738  65.258   1.187  1.00 34.19           N  
ATOM  10613  CA  PRO C  34      11.427  64.102   0.664  1.00 36.34           C  
ATOM  10614  C   PRO C  34      12.924  64.129   0.804  1.00 36.61           C  
ATOM  10615  O   PRO C  34      13.455  63.013   0.826  1.00 39.82           O  
ATOM  10616  CB  PRO C  34      10.880  63.906  -0.734  1.00 34.17           C  
ATOM  10617  CG  PRO C  34      10.034  65.077  -1.071  1.00 33.03           C  
ATOM  10618  CD  PRO C  34       9.953  65.941   0.138  1.00 32.77           C  
ATOM  10619  N   ASP C  35      13.665  65.177   1.076  1.00 38.64           N  
ATOM  10620  CA  ASP C  35      15.104  65.091   1.337  1.00 40.42           C  
ATOM  10621  C   ASP C  35      15.412  64.382   2.652  1.00 38.77           C  
ATOM  10622  O   ASP C  35      16.533  63.976   2.939  1.00 38.38           O  
ATOM  10623  CB  ASP C  35      15.718  66.497   1.445  1.00 43.62           C  
ATOM  10624  CG  ASP C  35      15.654  67.299   0.169  1.00 49.51           C  
ATOM  10625  OD1 ASP C  35      15.299  66.754  -0.902  1.00 46.66           O  
ATOM  10626  OD2 ASP C  35      15.955  68.521   0.221  1.00 49.92           O  
ATOM  10627  N   LEU C  36      14.490  64.440   3.621  1.00 39.22           N  
ATOM  10628  CA  LEU C  36      14.708  63.848   4.934  1.00 36.59           C  
ATOM  10629  C   LEU C  36      15.002  62.365   4.772  1.00 36.85           C  
ATOM  10630  O   LEU C  36      14.323  61.643   4.024  1.00 37.37           O  
ATOM  10631  CB  LEU C  36      13.488  63.998   5.815  1.00 40.46           C  
ATOM  10632  CG  LEU C  36      13.199  65.337   6.481  1.00 41.64           C  
ATOM  10633  CD1 LEU C  36      11.953  65.178   7.327  1.00 38.51           C  
ATOM  10634  CD2 LEU C  36      14.414  65.798   7.287  1.00 37.45           C  
ATOM  10635  N   LYS C  37      15.997  61.897   5.514  1.00 35.31           N  
ATOM  10636  CA  LYS C  37      16.403  60.492   5.411  1.00 35.85           C  
ATOM  10637  C   LYS C  37      16.203  59.821   6.750  1.00 34.87           C  
ATOM  10638  O   LYS C  37      16.828  60.095   7.765  1.00 36.34           O  
ATOM  10639  CB  LYS C  37      17.839  60.455   4.882  1.00 37.86           C  
ATOM  10640  CG  LYS C  37      18.458  59.087   4.761  1.00 47.36           C  
ATOM  10641  CD  LYS C  37      19.715  59.078   3.874  1.00 54.47           C  
ATOM  10642  CE  LYS C  37      19.928  57.662   3.349  1.00 58.40           C  
ATOM  10643  NZ  LYS C  37      21.350  57.214   3.474  1.00 59.50           N  
ATOM  10644  N   VAL C  38      15.248  58.885   6.754  1.00 34.20           N  
ATOM  10645  CA  VAL C  38      14.869  58.114   7.925  1.00 30.07           C  
ATOM  10646  C   VAL C  38      15.124  56.649   7.645  1.00 30.07           C  
ATOM  10647  O   VAL C  38      14.541  56.070   6.740  1.00 32.95           O  
ATOM  10648  CB  VAL C  38      13.369  58.326   8.255  1.00 31.32           C  
ATOM  10649  CG1 VAL C  38      12.895  57.437   9.399  1.00 24.33           C  
ATOM  10650  CG2 VAL C  38      13.133  59.796   8.538  1.00 29.00           C  
ATOM  10651  N   ARG C  39      15.928  55.994   8.439  1.00 29.43           N  
ATOM  10652  CA  ARG C  39      16.302  54.617   8.299  1.00 29.52           C  
ATOM  10653  C   ARG C  39      15.880  53.868   9.546  1.00 31.31           C  
ATOM  10654  O   ARG C  39      15.801  54.440  10.647  1.00 32.34           O  
ATOM  10655  CB  ARG C  39      17.818  54.465   8.107  1.00 28.23           C  
ATOM  10656  CG  ARG C  39      18.315  55.045   6.802  1.00 31.18           C  
ATOM  10657  CD  ARG C  39      19.819  55.027   6.657  1.00 27.15           C  
ATOM  10658  NE  ARG C  39      20.393  53.695   6.732  1.00 30.77           N  
ATOM  10659  CZ  ARG C  39      21.680  53.405   6.699  1.00 32.15           C  
ATOM  10660  NH1 ARG C  39      22.613  54.334   6.565  1.00 26.71           N  
ATOM  10661  NH2 ARG C  39      22.075  52.140   6.809  1.00 31.07           N  
ATOM  10662  N   ILE C  40      15.600  52.604   9.339  1.00 28.96           N  
ATOM  10663  CA  ILE C  40      15.179  51.704  10.412  1.00 29.71           C  
ATOM  10664  C   ILE C  40      15.846  50.357  10.109  1.00 31.45           C  
ATOM  10665  O   ILE C  40      15.768  49.884   8.981  1.00 30.09           O  
ATOM  10666  CB  ILE C  40      13.654  51.609  10.476  1.00 28.99           C  
ATOM  10667  CG1 ILE C  40      13.169  50.422  11.288  1.00 27.92           C  
ATOM  10668  CG2 ILE C  40      13.035  51.539   9.094  1.00 29.05           C  
ATOM  10669  CD1 ILE C  40      11.757  50.620  11.822  1.00 29.92           C  
ATOM  10670  N   ILE C  41      16.579  49.833  11.071  1.00 29.93           N  
ATOM  10671  CA  ILE C  41      17.323  48.617  10.945  1.00 30.00           C  
ATOM  10672  C   ILE C  41      16.830  47.558  11.938  1.00 32.08           C  
ATOM  10673  O   ILE C  41      16.219  47.885  12.954  1.00 31.18           O  
ATOM  10674  CB  ILE C  41      18.844  48.840  11.189  1.00 31.68           C  
ATOM  10675  CG1 ILE C  41      19.161  49.104  12.650  1.00 27.11           C  
ATOM  10676  CG2 ILE C  41      19.369  49.985  10.315  1.00 25.88           C  
ATOM  10677  CD1 ILE C  41      20.632  49.395  12.957  1.00 30.76           C  
ATOM  10678  N   ASP C  42      17.101  46.292  11.564  1.00 32.28           N  
ATOM  10679  CA  ASP C  42      16.841  45.209  12.510  1.00 35.20           C  
ATOM  10680  C   ASP C  42      17.979  44.202  12.401  1.00 35.57           C  
ATOM  10681  O   ASP C  42      18.532  44.113  11.311  1.00 36.60           O  
ATOM  10682  CB  ASP C  42      15.523  44.468  12.310  1.00 32.81           C  
ATOM  10683  CG  ASP C  42      15.144  43.839  13.646  1.00 38.81           C  
ATOM  10684  OD1 ASP C  42      15.602  42.696  13.845  1.00 32.85           O  
ATOM  10685  OD2 ASP C  42      14.444  44.550  14.400  1.00 35.78           O  
ATOM  10686  N   LYS C  43      18.311  43.464  13.443  1.00 36.70           N  
ATOM  10687  CA  LYS C  43      19.471  42.559  13.320  1.00 36.35           C  
ATOM  10688  C   LYS C  43      19.032  41.122  13.068  1.00 37.76           C  
ATOM  10689  O   LYS C  43      19.868  40.221  12.874  1.00 37.81           O  
ATOM  10690  CB  LYS C  43      20.284  42.666  14.607  1.00 36.91           C  
ATOM  10691  CG  LYS C  43      19.462  42.091  15.771  1.00 37.79           C  
ATOM  10692  CD  LYS C  43      20.385  41.804  16.937  1.00 39.64           C  
ATOM  10693  CE  LYS C  43      19.586  41.269  18.097  1.00 40.77           C  
ATOM  10694  NZ  LYS C  43      20.027  41.835  19.394  1.00 42.92           N  
ATOM  10695  N   ARG C  44      17.715  40.910  13.065  1.00 36.35           N  
ATOM  10696  CA  ARG C  44      17.181  39.596  12.849  1.00 37.45           C  
ATOM  10697  C   ARG C  44      16.623  39.282  11.469  1.00 38.96           C  
ATOM  10698  O   ARG C  44      16.058  40.150  10.818  1.00 40.76           O  
ATOM  10699  CB  ARG C  44      16.033  39.304  13.846  1.00 33.86           C  
ATOM  10700  CG  ARG C  44      16.582  38.844  15.196  1.00 36.20           C  
ATOM  10701  CD  ARG C  44      15.395  38.814  16.176  1.00 36.83           C  
ATOM  10702  NE  ARG C  44      15.807  38.773  17.555  1.00 39.56           N  
ATOM  10703  CZ  ARG C  44      15.200  39.163  18.662  1.00 44.20           C  
ATOM  10704  NH1 ARG C  44      13.975  39.644  18.910  1.00 37.20           N  
ATOM  10705  NH2 ARG C  44      16.009  38.938  19.685  1.00 38.61           N  
ATOM  10706  N   SER C  45      16.723  37.985  11.110  1.00 38.36           N  
ATOM  10707  CA  SER C  45      16.085  37.598   9.850  1.00 40.71           C  
ATOM  10708  C   SER C  45      14.582  37.547  10.169  1.00 41.52           C  
ATOM  10709  O   SER C  45      14.197  37.578  11.334  1.00 42.66           O  
ATOM  10710  CB  SER C  45      16.501  36.215   9.375  1.00 41.50           C  
ATOM  10711  OG  SER C  45      16.291  35.258  10.408  1.00 45.28           O  
ATOM  10712  N   THR C  46      13.759  37.291   9.181  1.00 39.88           N  
ATOM  10713  CA  THR C  46      12.338  37.141   9.265  1.00 41.28           C  
ATOM  10714  C   THR C  46      11.944  35.691   9.118  1.00 44.84           C  
ATOM  10715  O   THR C  46      10.768  35.316   9.039  1.00 45.35           O  
ATOM  10716  CB  THR C  46      11.743  37.933   8.078  1.00 40.94           C  
ATOM  10717  OG1 THR C  46      12.482  37.473   6.924  1.00 37.73           O  
ATOM  10718  CG2 THR C  46      12.021  39.414   8.302  1.00 35.94           C  
ATOM  10719  N   LYS C  47      12.927  34.804   9.079  1.00 44.83           N  
ATOM  10720  CA  LYS C  47      12.667  33.368   8.936  1.00 42.94           C  
ATOM  10721  C   LYS C  47      12.256  32.683  10.223  1.00 42.75           C  
ATOM  10722  O   LYS C  47      11.570  31.650  10.167  1.00 42.00           O  
ATOM  10723  CB  LYS C  47      13.896  32.750   8.287  1.00 43.53           C  
ATOM  10724  CG  LYS C  47      13.915  32.795   6.768  1.00 48.53           C  
ATOM  10725  CD  LYS C  47      12.978  33.819   6.120  1.00 46.95           C  
ATOM  10726  CE  LYS C  47      13.801  35.040   5.701  1.00 48.94           C  
ATOM  10727  NZ  LYS C  47      13.816  35.179   4.211  1.00 43.33           N  
ATOM  10728  N   VAL C  48      12.620  33.200  11.394  1.00 41.07           N  
ATOM  10729  CA  VAL C  48      12.122  32.660  12.641  1.00 41.01           C  
ATOM  10730  C   VAL C  48      11.029  33.705  13.014  1.00 40.22           C  
ATOM  10731  O   VAL C  48      11.370  34.884  13.038  1.00 37.42           O  
ATOM  10732  CB  VAL C  48      12.954  32.616  13.915  1.00 42.80           C  
ATOM  10733  CG1 VAL C  48      12.117  31.910  14.993  1.00 39.26           C  
ATOM  10734  CG2 VAL C  48      14.275  31.877  13.802  1.00 43.05           C  
ATOM  10735  N   TYR C  49       9.813  33.254  13.272  1.00 39.51           N  
ATOM  10736  CA  TYR C  49       8.778  34.220  13.635  1.00 40.42           C  
ATOM  10737  C   TYR C  49       9.354  35.179  14.677  1.00 40.81           C  
ATOM  10738  O   TYR C  49       9.775  34.679  15.706  1.00 40.27           O  
ATOM  10739  CB  TYR C  49       7.555  33.530  14.210  1.00 39.68           C  
ATOM  10740  CG  TYR C  49       6.576  34.553  14.747  1.00 40.37           C  
ATOM  10741  CD1 TYR C  49       6.204  35.655  13.977  1.00 38.91           C  
ATOM  10742  CD2 TYR C  49       6.078  34.412  16.039  1.00 38.55           C  
ATOM  10743  CE1 TYR C  49       5.334  36.592  14.502  1.00 37.34           C  
ATOM  10744  CE2 TYR C  49       5.116  35.302  16.499  1.00 37.19           C  
ATOM  10745  CZ  TYR C  49       4.771  36.400  15.745  1.00 38.20           C  
ATOM  10746  OH  TYR C  49       3.864  37.315  16.244  1.00 36.68           O  
ATOM  10747  N   ASN C  50       9.407  36.463  14.429  1.00 40.41           N  
ATOM  10748  CA  ASN C  50       9.982  37.395  15.383  1.00 42.26           C  
ATOM  10749  C   ASN C  50       8.881  38.241  15.999  1.00 41.98           C  
ATOM  10750  O   ASN C  50       8.780  39.424  15.687  1.00 41.57           O  
ATOM  10751  CB  ASN C  50      10.960  38.263  14.592  1.00 37.33           C  
ATOM  10752  CG  ASN C  50      11.842  39.099  15.495  1.00 43.95           C  
ATOM  10753  OD1 ASN C  50      11.967  38.821  16.693  1.00 41.29           O  
ATOM  10754  ND2 ASN C  50      12.473  40.146  14.956  1.00 38.91           N  
ATOM  10755  N   GLY C  51       8.197  37.693  17.016  1.00 39.99           N  
ATOM  10756  CA  GLY C  51       7.112  38.428  17.687  1.00 38.51           C  
ATOM  10757  C   GLY C  51       6.585  37.575  18.842  1.00 39.17           C  
ATOM  10758  O   GLY C  51       7.159  36.526  19.148  1.00 38.14           O  
ATOM  10759  N   GLN C  52       5.561  38.083  19.542  1.00 39.49           N  
ATOM  10760  CA  GLN C  52       5.086  37.375  20.736  1.00 39.09           C  
ATOM  10761  C   GLN C  52       3.808  37.997  21.270  1.00 37.38           C  
ATOM  10762  O   GLN C  52       3.070  37.360  22.033  1.00 36.20           O  
ATOM  10763  CB  GLN C  52       6.172  37.437  21.809  1.00 40.84           C  
ATOM  10764  CG  GLN C  52       6.404  38.805  22.417  1.00 45.42           C  
ATOM  10765  CD  GLN C  52       7.660  38.838  23.289  1.00 45.95           C  
ATOM  10766  OE1 GLN C  52       8.377  37.845  23.385  1.00 45.31           O  
ATOM  10767  NE2 GLN C  52       7.917  39.979  23.919  1.00 42.55           N  
ATOM  10768  N   ALA C  53       3.531  39.205  20.762  1.00 34.94           N  
ATOM  10769  CA  ALA C  53       2.386  39.937  21.329  1.00 37.04           C  
ATOM  10770  C   ALA C  53       1.101  39.671  20.573  1.00 37.48           C  
ATOM  10771  O   ALA C  53       1.120  39.365  19.373  1.00 38.56           O  
ATOM  10772  CB  ALA C  53       2.685  41.424  21.319  1.00 30.67           C  
ATOM  10773  N   ASP C  54      -0.024  39.967  21.234  1.00 36.49           N  
ATOM  10774  CA  ASP C  54      -1.273  39.867  20.458  1.00 36.72           C  
ATOM  10775  C   ASP C  54      -2.350  40.845  20.849  1.00 35.38           C  
ATOM  10776  O   ASP C  54      -3.269  40.951  20.021  1.00 36.73           O  
ATOM  10777  CB  ASP C  54      -1.772  38.431  20.428  1.00 37.18           C  
ATOM  10778  CG  ASP C  54      -2.121  37.846  21.778  1.00 36.20           C  
ATOM  10779  OD1 ASP C  54      -2.040  38.596  22.762  1.00 37.59           O  
ATOM  10780  OD2 ASP C  54      -2.477  36.646  21.854  1.00 35.64           O  
ATOM  10781  N   GLY C  55      -2.270  41.525  21.988  1.00 36.22           N  
ATOM  10782  CA  GLY C  55      -3.348  42.426  22.363  1.00 32.36           C  
ATOM  10783  C   GLY C  55      -3.249  43.875  21.943  1.00 33.48           C  
ATOM  10784  O   GLY C  55      -2.201  44.489  22.105  1.00 35.07           O  
ATOM  10785  N   LEU C  56      -4.348  44.456  21.470  1.00 34.68           N  
ATOM  10786  CA  LEU C  56      -4.371  45.885  21.129  1.00 34.17           C  
ATOM  10787  C   LEU C  56      -5.469  46.520  21.993  1.00 34.50           C  
ATOM  10788  O   LEU C  56      -6.634  46.114  21.955  1.00 34.32           O  
ATOM  10789  CB  LEU C  56      -4.529  46.183  19.661  1.00 32.67           C  
ATOM  10790  CG  LEU C  56      -3.439  45.758  18.668  1.00 34.99           C  
ATOM  10791  CD1 LEU C  56      -3.940  45.873  17.223  1.00 31.60           C  
ATOM  10792  CD2 LEU C  56      -2.174  46.616  18.794  1.00 29.02           C  
ATOM  10793  N   GLN C  57      -5.072  47.491  22.811  1.00 34.00           N  
ATOM  10794  CA  GLN C  57      -5.969  48.175  23.718  1.00 31.30           C  
ATOM  10795  C   GLN C  57      -6.623  49.406  23.141  1.00 32.74           C  
ATOM  10796  O   GLN C  57      -6.186  49.880  22.082  1.00 31.94           O  
ATOM  10797  CB  GLN C  57      -5.176  48.498  25.013  1.00 30.84           C  
ATOM  10798  CG  GLN C  57      -5.385  47.314  25.986  1.00 32.89           C  
ATOM  10799  CD  GLN C  57      -6.779  47.390  26.621  1.00 33.19           C  
ATOM  10800  OE1 GLN C  57      -7.722  48.029  26.151  1.00 32.56           O  
ATOM  10801  NE2 GLN C  57      -6.916  46.746  27.759  1.00 33.24           N  
ATOM  10802  N   CYS C  58      -7.660  49.912  23.805  1.00 33.67           N  
ATOM  10803  CA  CYS C  58      -8.528  50.967  23.309  1.00 30.48           C  
ATOM  10804  C   CYS C  58      -7.871  52.202  22.720  1.00 31.35           C  
ATOM  10805  O   CYS C  58      -8.244  52.603  21.593  1.00 31.84           O  
ATOM  10806  CB  CYS C  58      -9.501  51.464  24.398  1.00 28.97           C  
ATOM  10807  SG  CYS C  58     -10.411  50.120  25.206  1.00 31.14           S  
ATOM  10808  N   ARG C  59      -6.908  52.788  23.427  1.00 29.60           N  
ATOM  10809  CA  ARG C  59      -6.269  54.014  22.906  1.00 27.14           C  
ATOM  10810  C   ARG C  59      -5.285  53.715  21.782  1.00 29.57           C  
ATOM  10811  O   ARG C  59      -5.117  54.550  20.881  1.00 27.97           O  
ATOM  10812  CB  ARG C  59      -5.641  54.808  24.014  1.00 20.96           C  
ATOM  10813  CG  ARG C  59      -4.978  56.125  23.678  1.00 23.78           C  
ATOM  10814  CD  ARG C  59      -5.889  57.120  22.973  1.00 20.07           C  
ATOM  10815  NE  ARG C  59      -5.084  58.120  22.310  1.00 20.88           N  
ATOM  10816  CZ  ARG C  59      -5.498  59.034  21.465  1.00 27.46           C  
ATOM  10817  NH1 ARG C  59      -6.797  59.069  21.175  1.00 25.33           N  
ATOM  10818  NH2 ARG C  59      -4.667  59.917  20.933  1.00 26.89           N  
ATOM  10819  N   THR C  60      -4.759  52.487  21.761  1.00 28.23           N  
ATOM  10820  CA  THR C  60      -3.899  52.061  20.652  1.00 30.72           C  
ATOM  10821  C   THR C  60      -4.710  51.991  19.372  1.00 31.37           C  
ATOM  10822  O   THR C  60      -4.283  52.574  18.363  1.00 29.19           O  
ATOM  10823  CB  THR C  60      -3.243  50.715  20.960  1.00 34.31           C  
ATOM  10824  OG1 THR C  60      -2.675  50.736  22.278  1.00 26.11           O  
ATOM  10825  CG2 THR C  60      -2.185  50.389  19.911  1.00 31.32           C  
ATOM  10826  N   LEU C  61      -5.911  51.401  19.462  1.00 29.85           N  
ATOM  10827  CA  LEU C  61      -6.838  51.344  18.331  1.00 27.33           C  
ATOM  10828  C   LEU C  61      -7.355  52.695  17.886  1.00 29.26           C  
ATOM  10829  O   LEU C  61      -7.535  52.946  16.691  1.00 27.23           O  
ATOM  10830  CB  LEU C  61      -8.042  50.405  18.649  1.00 23.77           C  
ATOM  10831  CG  LEU C  61      -7.596  48.944  18.804  1.00 27.54           C  
ATOM  10832  CD1 LEU C  61      -8.551  48.101  19.604  1.00 25.83           C  
ATOM  10833  CD2 LEU C  61      -7.323  48.290  17.423  1.00 22.12           C  
ATOM  10834  N   GLU C  62      -7.541  53.643  18.819  1.00 29.55           N  
ATOM  10835  CA  GLU C  62      -8.027  54.975  18.421  1.00 28.18           C  
ATOM  10836  C   GLU C  62      -6.914  55.630  17.596  1.00 28.19           C  
ATOM  10837  O   GLU C  62      -7.123  56.247  16.554  1.00 28.08           O  
ATOM  10838  CB  GLU C  62      -8.413  55.866  19.595  1.00 28.57           C  
ATOM  10839  CG  GLU C  62      -9.529  55.484  20.500  1.00 29.62           C  
ATOM  10840  CD  GLU C  62      -9.604  56.116  21.873  1.00 34.25           C  
ATOM  10841  OE1 GLU C  62      -9.069  57.202  22.187  1.00 33.02           O  
ATOM  10842  OE2 GLU C  62     -10.278  55.515  22.739  1.00 34.34           O  
ATOM  10843  N   SER C  63      -5.691  55.478  18.089  1.00 27.26           N  
ATOM  10844  CA  SER C  63      -4.491  55.951  17.384  1.00 29.46           C  
ATOM  10845  C   SER C  63      -4.259  55.244  16.060  1.00 29.36           C  
ATOM  10846  O   SER C  63      -4.125  55.932  15.045  1.00 26.98           O  
ATOM  10847  CB  SER C  63      -3.274  55.808  18.289  1.00 28.91           C  
ATOM  10848  OG  SER C  63      -3.671  56.516  19.478  1.00 27.95           O  
ATOM  10849  N   LEU C  64      -4.383  53.923  16.030  1.00 28.37           N  
ATOM  10850  CA  LEU C  64      -4.239  53.207  14.761  1.00 29.98           C  
ATOM  10851  C   LEU C  64      -5.309  53.651  13.778  1.00 31.11           C  
ATOM  10852  O   LEU C  64      -5.034  53.762  12.570  1.00 33.69           O  
ATOM  10853  CB  LEU C  64      -4.284  51.689  14.966  1.00 24.22           C  
ATOM  10854  CG  LEU C  64      -3.065  51.134  15.722  1.00 27.89           C  
ATOM  10855  CD1 LEU C  64      -3.340  49.701  16.184  1.00 26.16           C  
ATOM  10856  CD2 LEU C  64      -1.822  51.214  14.828  1.00 26.60           C  
ATOM  10857  N   LYS C  65      -6.499  54.011  14.272  1.00 29.70           N  
ATOM  10858  CA  LYS C  65      -7.589  54.483  13.437  1.00 28.70           C  
ATOM  10859  C   LYS C  65      -7.147  55.784  12.803  1.00 29.69           C  
ATOM  10860  O   LYS C  65      -7.221  55.937  11.579  1.00 32.28           O  
ATOM  10861  CB  LYS C  65      -8.920  54.612  14.200  1.00 26.10           C  
ATOM  10862  CG  LYS C  65     -10.028  55.367  13.476  1.00 25.09           C  
ATOM  10863  CD  LYS C  65     -10.443  54.670  12.204  1.00 31.69           C  
ATOM  10864  CE  LYS C  65     -11.519  55.319  11.342  1.00 30.87           C  
ATOM  10865  NZ  LYS C  65     -11.811  54.370  10.197  1.00 36.07           N  
ATOM  10866  N   ASN C  66      -6.587  56.694  13.600  1.00 28.45           N  
ATOM  10867  CA  ASN C  66      -6.063  57.962  13.098  1.00 26.33           C  
ATOM  10868  C   ASN C  66      -4.864  57.780  12.170  1.00 27.49           C  
ATOM  10869  O   ASN C  66      -4.641  58.722  11.397  1.00 27.51           O  
ATOM  10870  CB  ASN C  66      -5.766  58.956  14.240  1.00 22.59           C  
ATOM  10871  CG  ASN C  66      -7.009  59.364  15.047  1.00 28.81           C  
ATOM  10872  OD1 ASN C  66      -6.946  59.551  16.271  1.00 26.20           O  
ATOM  10873  ND2 ASN C  66      -8.197  59.474  14.429  1.00 22.39           N  
ATOM  10874  N   LEU C  67      -4.181  56.645  12.161  1.00 25.81           N  
ATOM  10875  CA  LEU C  67      -3.156  56.343  11.158  1.00 31.13           C  
ATOM  10876  C   LEU C  67      -3.688  55.548   9.968  1.00 30.96           C  
ATOM  10877  O   LEU C  67      -2.883  55.096   9.139  1.00 29.91           O  
ATOM  10878  CB  LEU C  67      -1.972  55.594  11.812  1.00 25.65           C  
ATOM  10879  CG  LEU C  67      -1.302  56.385  12.961  1.00 31.37           C  
ATOM  10880  CD1 LEU C  67      -0.500  55.431  13.849  1.00 26.47           C  
ATOM  10881  CD2 LEU C  67      -0.414  57.517  12.468  1.00 20.96           C  
ATOM  10882  N   GLY C  68      -4.999  55.254   9.940  1.00 29.46           N  
ATOM  10883  CA  GLY C  68      -5.589  54.460   8.845  1.00 26.80           C  
ATOM  10884  C   GLY C  68      -5.301  52.977   8.948  1.00 30.29           C  
ATOM  10885  O   GLY C  68      -5.434  52.274   7.956  1.00 31.05           O  
ATOM  10886  N   LEU C  69      -5.022  52.428  10.114  1.00 32.00           N  
ATOM  10887  CA  LEU C  69      -4.670  51.046  10.337  1.00 31.87           C  
ATOM  10888  C   LEU C  69      -5.649  50.170  11.090  1.00 34.55           C  
ATOM  10889  O   LEU C  69      -5.487  48.933  11.111  1.00 37.12           O  
ATOM  10890  CB  LEU C  69      -3.338  51.162  11.147  1.00 34.09           C  
ATOM  10891  CG  LEU C  69      -2.190  51.645  10.248  1.00 37.23           C  
ATOM  10892  CD1 LEU C  69      -0.938  52.047  10.996  1.00 33.01           C  
ATOM  10893  CD2 LEU C  69      -1.899  50.517   9.254  1.00 34.79           C  
ATOM  10894  N   ALA C  70      -6.661  50.737  11.744  1.00 33.09           N  
ATOM  10895  CA  ALA C  70      -7.564  50.001  12.604  1.00 32.66           C  
ATOM  10896  C   ALA C  70      -8.574  49.119  11.882  1.00 31.97           C  
ATOM  10897  O   ALA C  70      -8.709  47.962  12.273  1.00 32.77           O  
ATOM  10898  CB  ALA C  70      -8.336  50.937  13.529  1.00 32.13           C  
ATOM  10899  N   ASP C  71      -9.284  49.611  10.869  1.00 31.02           N  
ATOM  10900  CA  ASP C  71     -10.238  48.777  10.137  1.00 32.64           C  
ATOM  10901  C   ASP C  71      -9.627  47.515   9.518  1.00 33.35           C  
ATOM  10902  O   ASP C  71     -10.229  46.439   9.710  1.00 34.24           O  
ATOM  10903  CB  ASP C  71     -10.974  49.613   9.110  1.00 32.93           C  
ATOM  10904  CG  ASP C  71     -11.718  50.829   9.613  1.00 40.71           C  
ATOM  10905  OD1 ASP C  71     -11.607  51.276  10.779  1.00 39.20           O  
ATOM  10906  OD2 ASP C  71     -12.473  51.444   8.820  1.00 46.82           O  
ATOM  10907  N   LYS C  72      -8.402  47.545   9.008  1.00 33.30           N  
ATOM  10908  CA  LYS C  72      -7.806  46.302   8.486  1.00 36.17           C  
ATOM  10909  C   LYS C  72      -7.484  45.361   9.624  1.00 34.77           C  
ATOM  10910  O   LYS C  72      -7.801  44.170   9.475  1.00 35.53           O  
ATOM  10911  CB  LYS C  72      -6.679  46.625   7.505  1.00 39.79           C  
ATOM  10912  CG  LYS C  72      -7.144  47.464   6.309  1.00 42.25           C  
ATOM  10913  CD  LYS C  72      -6.083  48.504   5.933  1.00 45.62           C  
ATOM  10914  CE  LYS C  72      -6.525  49.406   4.775  1.00 46.38           C  
ATOM  10915  NZ  LYS C  72      -5.538  49.514   3.659  1.00 50.00           N  
ATOM  10916  N   ILE C  73      -6.945  45.822  10.739  1.00 34.55           N  
ATOM  10917  CA  ILE C  73      -6.626  44.997  11.898  1.00 32.29           C  
ATOM  10918  C   ILE C  73      -7.883  44.446  12.548  1.00 34.03           C  
ATOM  10919  O   ILE C  73      -7.931  43.259  12.901  1.00 35.30           O  
ATOM  10920  CB  ILE C  73      -5.841  45.817  12.942  1.00 35.64           C  
ATOM  10921  CG1 ILE C  73      -4.407  45.990  12.483  1.00 33.28           C  
ATOM  10922  CG2 ILE C  73      -5.900  45.242  14.366  1.00 27.31           C  
ATOM  10923  CD1 ILE C  73      -3.517  46.850  13.324  1.00 37.20           C  
ATOM  10924  N   LEU C  74      -8.918  45.273  12.685  1.00 31.16           N  
ATOM  10925  CA  LEU C  74     -10.184  44.878  13.232  1.00 34.49           C  
ATOM  10926  C   LEU C  74     -10.949  43.877  12.355  1.00 36.64           C  
ATOM  10927  O   LEU C  74     -11.842  43.189  12.887  1.00 32.99           O  
ATOM  10928  CB  LEU C  74     -11.093  46.086  13.540  1.00 30.82           C  
ATOM  10929  CG  LEU C  74     -10.593  46.965  14.715  1.00 39.65           C  
ATOM  10930  CD1 LEU C  74     -11.222  48.351  14.681  1.00 33.52           C  
ATOM  10931  CD2 LEU C  74     -10.843  46.277  16.034  1.00 28.24           C  
ATOM  10932  N   SER C  75     -10.634  43.781  11.058  1.00 33.10           N  
ATOM  10933  CA  SER C  75     -11.392  42.823  10.247  1.00 35.19           C  
ATOM  10934  C   SER C  75     -10.916  41.408  10.529  1.00 33.01           C  
ATOM  10935  O   SER C  75     -11.561  40.502  10.044  1.00 33.69           O  
ATOM  10936  CB  SER C  75     -11.319  43.244   8.766  1.00 33.46           C  
ATOM  10937  OG  SER C  75      -9.960  43.120   8.297  1.00 37.15           O  
ATOM  10938  N   GLU C  76      -9.828  41.195  11.257  1.00 33.92           N  
ATOM  10939  CA  GLU C  76      -9.293  39.886  11.554  1.00 33.49           C  
ATOM  10940  C   GLU C  76      -9.179  39.623  13.047  1.00 33.62           C  
ATOM  10941  O   GLU C  76      -9.134  38.481  13.480  1.00 33.71           O  
ATOM  10942  CB  GLU C  76      -7.867  39.795  10.961  1.00 35.43           C  
ATOM  10943  CG  GLU C  76      -7.731  40.064   9.457  1.00 38.58           C  
ATOM  10944  CD  GLU C  76      -6.269  40.304   9.067  1.00 45.08           C  
ATOM  10945  OE1 GLU C  76      -5.368  39.491   9.350  1.00 40.77           O  
ATOM  10946  OE2 GLU C  76      -5.955  41.380   8.508  1.00 50.16           O  
ATOM  10947  N   ALA C  77      -9.062  40.656  13.877  1.00 33.14           N  
ATOM  10948  CA  ALA C  77      -8.835  40.444  15.303  1.00 35.27           C  
ATOM  10949  C   ALA C  77     -10.098  39.971  16.007  1.00 34.74           C  
ATOM  10950  O   ALA C  77     -11.246  40.197  15.584  1.00 35.12           O  
ATOM  10951  CB  ALA C  77      -8.260  41.685  15.973  1.00 33.68           C  
ATOM  10952  N   ASN C  78      -9.861  39.377  17.166  1.00 31.40           N  
ATOM  10953  CA  ASN C  78     -10.916  38.844  18.001  1.00 31.13           C  
ATOM  10954  C   ASN C  78     -11.115  39.688  19.249  1.00 30.69           C  
ATOM  10955  O   ASN C  78     -10.181  39.969  19.996  1.00 31.76           O  
ATOM  10956  CB  ASN C  78     -10.557  37.412  18.453  1.00 27.40           C  
ATOM  10957  CG  ASN C  78     -11.658  36.752  19.244  1.00 34.84           C  
ATOM  10958  OD1 ASN C  78     -12.791  36.677  18.788  1.00 33.33           O  
ATOM  10959  ND2 ASN C  78     -11.357  36.301  20.447  1.00 34.01           N  
ATOM  10960  N   ASP C  79     -12.378  40.038  19.478  1.00 31.65           N  
ATOM  10961  CA  ASP C  79     -12.775  40.736  20.692  1.00 30.05           C  
ATOM  10962  C   ASP C  79     -13.160  39.679  21.727  1.00 32.36           C  
ATOM  10963  O   ASP C  79     -14.225  39.054  21.688  1.00 33.16           O  
ATOM  10964  CB  ASP C  79     -13.926  41.680  20.408  1.00 27.98           C  
ATOM  10965  CG  ASP C  79     -14.511  42.385  21.600  1.00 29.68           C  
ATOM  10966  OD1 ASP C  79     -14.091  42.082  22.756  1.00 30.53           O  
ATOM  10967  OD2 ASP C  79     -15.381  43.268  21.382  1.00 30.48           O  
ATOM  10968  N   MET C  80     -12.315  39.526  22.731  1.00 30.68           N  
ATOM  10969  CA  MET C  80     -12.513  38.577  23.813  1.00 30.72           C  
ATOM  10970  C   MET C  80     -13.769  38.860  24.638  1.00 32.19           C  
ATOM  10971  O   MET C  80     -14.305  37.917  25.239  1.00 29.46           O  
ATOM  10972  CB  MET C  80     -11.272  38.474  24.690  1.00 31.18           C  
ATOM  10973  CG  MET C  80      -9.972  38.331  23.907  1.00 29.05           C  
ATOM  10974  SD  MET C  80      -8.536  38.233  24.999  1.00 31.25           S  
ATOM  10975  CE  MET C  80      -8.351  39.947  25.488  1.00 30.28           C  
ATOM  10976  N   SER C  81     -14.318  40.062  24.608  1.00 30.41           N  
ATOM  10977  CA  SER C  81     -15.568  40.424  25.231  1.00 33.75           C  
ATOM  10978  C   SER C  81     -15.680  40.339  26.744  1.00 34.76           C  
ATOM  10979  O   SER C  81     -15.928  41.353  27.402  1.00 33.88           O  
ATOM  10980  CB  SER C  81     -16.679  39.567  24.619  1.00 32.00           C  
ATOM  10981  OG  SER C  81     -16.715  39.856  23.217  1.00 32.40           O  
ATOM  10982  N   THR C  82     -15.505  39.164  27.305  1.00 32.74           N  
ATOM  10983  CA  THR C  82     -15.674  38.861  28.697  1.00 34.97           C  
ATOM  10984  C   THR C  82     -14.410  38.338  29.369  1.00 36.32           C  
ATOM  10985  O   THR C  82     -13.677  37.549  28.756  1.00 35.43           O  
ATOM  10986  CB  THR C  82     -16.733  37.720  28.834  1.00 32.26           C  
ATOM  10987  OG1 THR C  82     -17.981  38.126  28.273  1.00 26.71           O  
ATOM  10988  CG2 THR C  82     -16.934  37.337  30.284  1.00 28.31           C  
ATOM  10989  N   ILE C  83     -14.246  38.658  30.644  1.00 36.24           N  
ATOM  10990  CA  ILE C  83     -13.255  38.011  31.488  1.00 36.98           C  
ATOM  10991  C   ILE C  83     -14.021  37.145  32.517  1.00 38.74           C  
ATOM  10992  O   ILE C  83     -14.835  37.657  33.310  1.00 39.67           O  
ATOM  10993  CB  ILE C  83     -12.371  38.992  32.256  1.00 36.37           C  
ATOM  10994  CG1 ILE C  83     -11.572  39.878  31.297  1.00 36.86           C  
ATOM  10995  CG2 ILE C  83     -11.433  38.213  33.170  1.00 36.89           C  
ATOM  10996  CD1 ILE C  83     -11.012  41.150  31.903  1.00 34.78           C  
ATOM  10997  N   ALA C  84     -13.852  35.841  32.437  1.00 36.88           N  
ATOM  10998  CA  ALA C  84     -14.483  34.928  33.370  1.00 38.89           C  
ATOM  10999  C   ALA C  84     -13.481  34.546  34.459  1.00 40.81           C  
ATOM  11000  O   ALA C  84     -12.383  34.110  34.132  1.00 41.28           O  
ATOM  11001  CB  ALA C  84     -14.971  33.683  32.659  1.00 37.71           C  
ATOM  11002  N   LEU C  85     -13.834  34.777  35.708  1.00 40.76           N  
ATOM  11003  CA  LEU C  85     -12.971  34.488  36.839  1.00 41.65           C  
ATOM  11004  C   LEU C  85     -13.267  33.134  37.461  1.00 43.40           C  
ATOM  11005  O   LEU C  85     -14.423  32.835  37.779  1.00 44.12           O  
ATOM  11006  CB  LEU C  85     -13.125  35.598  37.888  1.00 39.74           C  
ATOM  11007  CG  LEU C  85     -12.774  36.998  37.354  1.00 42.15           C  
ATOM  11008  CD1 LEU C  85     -13.105  38.039  38.417  1.00 42.59           C  
ATOM  11009  CD2 LEU C  85     -11.324  37.068  36.909  1.00 36.87           C  
ATOM  11010  N   TYR C  86     -12.253  32.280  37.574  1.00 43.41           N  
ATOM  11011  CA  TYR C  86     -12.458  30.945  38.118  1.00 43.18           C  
ATOM  11012  C   TYR C  86     -11.511  30.741  39.290  1.00 46.16           C  
ATOM  11013  O   TYR C  86     -10.314  31.017  39.159  1.00 46.97           O  
ATOM  11014  CB  TYR C  86     -12.174  29.864  37.086  1.00 41.43           C  
ATOM  11015  CG  TYR C  86     -13.227  29.465  36.105  1.00 39.68           C  
ATOM  11016  CD1 TYR C  86     -13.697  30.365  35.163  1.00 40.74           C  
ATOM  11017  CD2 TYR C  86     -13.762  28.185  36.075  1.00 40.32           C  
ATOM  11018  CE1 TYR C  86     -14.674  30.029  34.234  1.00 40.03           C  
ATOM  11019  CE2 TYR C  86     -14.742  27.821  35.167  1.00 40.01           C  
ATOM  11020  CZ  TYR C  86     -15.192  28.750  34.253  1.00 41.08           C  
ATOM  11021  OH  TYR C  86     -16.157  28.399  33.325  1.00 41.79           O  
ATOM  11022  N   ASN C  87     -12.034  30.223  40.395  1.00 46.16           N  
ATOM  11023  CA  ASN C  87     -11.198  29.953  41.581  1.00 49.78           C  
ATOM  11024  C   ASN C  87     -11.797  28.757  42.311  1.00 51.72           C  
ATOM  11025  O   ASN C  87     -12.936  28.378  42.048  1.00 51.40           O  
ATOM  11026  CB  ASN C  87     -11.060  31.193  42.442  1.00 48.51           C  
ATOM  11027  CG  ASN C  87     -12.429  31.819  42.685  1.00 50.55           C  
ATOM  11028  OD1 ASN C  87     -13.241  31.248  43.430  1.00 50.03           O  
ATOM  11029  ND2 ASN C  87     -12.706  32.907  41.983  1.00 47.66           N  
ATOM  11030  N   PRO C  88     -11.005  28.073  43.124  1.00 54.37           N  
ATOM  11031  CA  PRO C  88     -11.412  26.842  43.792  1.00 56.30           C  
ATOM  11032  C   PRO C  88     -12.521  27.027  44.795  1.00 58.28           C  
ATOM  11033  O   PRO C  88     -12.593  28.069  45.458  1.00 56.22           O  
ATOM  11034  CB  PRO C  88     -10.137  26.307  44.424  1.00 55.55           C  
ATOM  11035  CG  PRO C  88      -9.019  27.184  43.999  1.00 54.58           C  
ATOM  11036  CD  PRO C  88      -9.617  28.454  43.468  1.00 54.32           C  
ATOM  11037  N   ASP C  89     -13.465  26.092  44.900  1.00 62.62           N  
ATOM  11038  CA  ASP C  89     -14.573  26.250  45.859  1.00 67.51           C  
ATOM  11039  C   ASP C  89     -14.281  25.493  47.146  1.00 69.22           C  
ATOM  11040  O   ASP C  89     -13.161  24.999  47.291  1.00 68.39           O  
ATOM  11041  CB  ASP C  89     -15.910  25.784  45.286  1.00 67.74           C  
ATOM  11042  CG  ASP C  89     -15.931  24.324  44.899  1.00 69.28           C  
ATOM  11043  OD1 ASP C  89     -14.858  23.685  44.988  1.00 73.87           O  
ATOM  11044  OD2 ASP C  89     -17.008  23.834  44.498  1.00 70.84           O  
ATOM  11045  N   GLU C  90     -15.304  25.211  47.953  1.00 72.15           N  
ATOM  11046  CA  GLU C  90     -15.165  24.481  49.201  1.00 72.53           C  
ATOM  11047  C   GLU C  90     -14.193  23.308  49.122  1.00 73.12           C  
ATOM  11048  O   GLU C  90     -13.319  23.176  49.975  1.00 74.37           O  
ATOM  11049  CB  GLU C  90     -16.492  23.877  49.701  1.00 76.37           C  
ATOM  11050  CG  GLU C  90     -16.372  23.259  51.084  1.00 77.82           C  
ATOM  11051  CD  GLU C  90     -16.735  21.800  51.203  1.00 79.54           C  
ATOM  11052  OE1 GLU C  90     -17.626  21.320  50.466  1.00 81.82           O  
ATOM  11053  OE2 GLU C  90     -16.136  21.089  52.045  1.00 80.17           O  
ATOM  11054  N   ASN C  91     -14.419  22.454  48.133  1.00 72.21           N  
ATOM  11055  CA  ASN C  91     -13.632  21.256  47.909  1.00 72.39           C  
ATOM  11056  C   ASN C  91     -12.421  21.445  47.027  1.00 72.13           C  
ATOM  11057  O   ASN C  91     -11.769  20.458  46.662  1.00 71.00           O  
ATOM  11058  CB  ASN C  91     -14.576  20.211  47.267  1.00 75.45           C  
ATOM  11059  CG  ASN C  91     -15.815  20.141  48.157  1.00 75.84           C  
ATOM  11060  OD1 ASN C  91     -15.652  19.769  49.320  1.00 75.87           O  
ATOM  11061  ND2 ASN C  91     -16.948  20.582  47.636  1.00 75.97           N  
ATOM  11062  N   GLY C  92     -12.154  22.679  46.594  1.00 71.66           N  
ATOM  11063  CA  GLY C  92     -10.984  22.939  45.770  1.00 69.68           C  
ATOM  11064  C   GLY C  92     -11.186  22.695  44.290  1.00 67.41           C  
ATOM  11065  O   GLY C  92     -10.185  22.678  43.570  1.00 67.25           O  
ATOM  11066  N   HIS C  93     -12.411  22.526  43.811  1.00 67.79           N  
ATOM  11067  CA  HIS C  93     -12.635  22.394  42.368  1.00 66.61           C  
ATOM  11068  C   HIS C  93     -12.807  23.816  41.807  1.00 63.16           C  
ATOM  11069  O   HIS C  93     -13.440  24.623  42.492  1.00 61.66           O  
ATOM  11070  CB  HIS C  93     -13.869  21.592  41.996  1.00 69.66           C  
ATOM  11071  CG  HIS C  93     -13.658  20.150  41.672  1.00 71.50           C  
ATOM  11072  ND1 HIS C  93     -14.624  19.374  41.058  1.00 71.42           N  
ATOM  11073  CD2 HIS C  93     -12.599  19.329  41.887  1.00 71.91           C  
ATOM  11074  CE1 HIS C  93     -14.148  18.147  40.909  1.00 73.07           C  
ATOM  11075  NE2 HIS C  93     -12.918  18.089  41.401  1.00 71.96           N  
ATOM  11076  N   ILE C  94     -12.227  24.071  40.643  1.00 60.68           N  
ATOM  11077  CA  ILE C  94     -12.372  25.403  40.058  1.00 59.25           C  
ATOM  11078  C   ILE C  94     -13.778  25.601  39.492  1.00 56.78           C  
ATOM  11079  O   ILE C  94     -14.322  24.711  38.846  1.00 57.24           O  
ATOM  11080  CB  ILE C  94     -11.373  25.692  38.923  1.00 57.54           C  
ATOM  11081  CG1 ILE C  94     -11.306  24.538  37.923  1.00 58.99           C  
ATOM  11082  CG2 ILE C  94      -9.996  25.964  39.498  1.00 56.14           C  
ATOM  11083  CD1 ILE C  94     -10.868  24.951  36.524  1.00 57.16           C  
ATOM  11084  N   ARG C  95     -14.345  26.775  39.759  1.00 54.86           N  
ATOM  11085  CA  ARG C  95     -15.662  27.097  39.215  1.00 54.46           C  
ATOM  11086  C   ARG C  95     -15.727  28.603  38.966  1.00 52.74           C  
ATOM  11087  O   ARG C  95     -14.924  29.366  39.502  1.00 52.65           O  
ATOM  11088  CB  ARG C  95     -16.825  26.610  40.061  1.00 58.47           C  
ATOM  11089  CG  ARG C  95     -16.608  26.619  41.561  1.00 63.23           C  
ATOM  11090  CD  ARG C  95     -16.995  27.977  42.130  1.00 64.19           C  
ATOM  11091  NE  ARG C  95     -15.874  28.542  42.882  1.00 68.05           N  
ATOM  11092  CZ  ARG C  95     -15.936  28.900  44.161  1.00 67.42           C  
ATOM  11093  NH1 ARG C  95     -17.039  28.750  44.887  1.00 68.37           N  
ATOM  11094  NH2 ARG C  95     -14.861  29.410  44.724  1.00 69.26           N  
ATOM  11095  N   ARG C  96     -16.656  28.991  38.101  1.00 48.68           N  
ATOM  11096  CA  ARG C  96     -16.781  30.406  37.752  1.00 47.46           C  
ATOM  11097  C   ARG C  96     -17.489  31.191  38.831  1.00 47.45           C  
ATOM  11098  O   ARG C  96     -18.663  30.912  39.076  1.00 49.23           O  
ATOM  11099  CB  ARG C  96     -17.508  30.505  36.408  1.00 43.32           C  
ATOM  11100  CG  ARG C  96     -17.405  31.867  35.746  1.00 43.07           C  
ATOM  11101  CD  ARG C  96     -18.117  31.823  34.391  1.00 44.14           C  
ATOM  11102  NE  ARG C  96     -19.561  31.712  34.504  1.00 39.57           N  
ATOM  11103  CZ  ARG C  96     -20.262  30.825  33.801  1.00 42.50           C  
ATOM  11104  NH1 ARG C  96     -19.648  29.987  32.938  1.00 36.11           N  
ATOM  11105  NH2 ARG C  96     -21.580  30.744  33.920  1.00 39.31           N  
ATOM  11106  N   THR C  97     -16.833  32.176  39.451  1.00 46.77           N  
ATOM  11107  CA  THR C  97     -17.511  32.922  40.521  1.00 44.98           C  
ATOM  11108  C   THR C  97     -18.035  34.237  39.999  1.00 44.46           C  
ATOM  11109  O   THR C  97     -18.838  34.922  40.647  1.00 44.66           O  
ATOM  11110  CB  THR C  97     -16.607  33.101  41.754  1.00 45.93           C  
ATOM  11111  OG1 THR C  97     -15.439  33.865  41.479  1.00 44.49           O  
ATOM  11112  CG2 THR C  97     -16.104  31.739  42.246  1.00 43.68           C  
ATOM  11113  N   ASP C  98     -17.553  34.644  38.826  1.00 45.14           N  
ATOM  11114  CA  ASP C  98     -17.917  35.962  38.302  1.00 43.50           C  
ATOM  11115  C   ASP C  98     -17.476  36.173  36.866  1.00 42.80           C  
ATOM  11116  O   ASP C  98     -16.636  35.481  36.297  1.00 42.33           O  
ATOM  11117  CB  ASP C  98     -17.282  37.041  39.203  1.00 45.71           C  
ATOM  11118  CG  ASP C  98     -18.216  38.196  39.509  1.00 53.32           C  
ATOM  11119  OD1 ASP C  98     -19.110  38.508  38.686  1.00 50.24           O  
ATOM  11120  OD2 ASP C  98     -18.039  38.799  40.595  1.00 52.72           O  
ATOM  11121  N   ARG C  99     -17.995  37.217  36.253  1.00 39.79           N  
ATOM  11122  CA  ARG C  99     -17.630  37.654  34.918  1.00 37.63           C  
ATOM  11123  C   ARG C  99     -17.557  39.178  34.881  1.00 38.14           C  
ATOM  11124  O   ARG C  99     -18.437  39.811  35.453  1.00 37.63           O  
ATOM  11125  CB  ARG C  99     -18.665  37.176  33.918  1.00 35.40           C  
ATOM  11126  CG  ARG C  99     -18.444  35.795  33.339  1.00 32.78           C  
ATOM  11127  CD  ARG C  99     -19.617  35.426  32.451  1.00 32.89           C  
ATOM  11128  NE  ARG C  99     -19.375  34.137  31.754  1.00 36.53           N  
ATOM  11129  CZ  ARG C  99     -20.388  33.361  31.403  1.00 38.20           C  
ATOM  11130  NH1 ARG C  99     -21.620  33.770  31.718  1.00 39.16           N  
ATOM  11131  NH2 ARG C  99     -20.170  32.235  30.756  1.00 35.79           N  
ATOM  11132  N   ILE C 100     -16.479  39.753  34.352  1.00 36.26           N  
ATOM  11133  CA  ILE C 100     -16.396  41.221  34.246  1.00 35.07           C  
ATOM  11134  C   ILE C 100     -16.129  41.528  32.771  1.00 36.80           C  
ATOM  11135  O   ILE C 100     -15.672  40.644  32.045  1.00 37.16           O  
ATOM  11136  CB  ILE C 100     -15.268  41.782  35.113  1.00 36.76           C  
ATOM  11137  CG1 ILE C 100     -13.909  41.219  34.640  1.00 35.13           C  
ATOM  11138  CG2 ILE C 100     -15.442  41.434  36.598  1.00 32.46           C  
ATOM  11139  CD1 ILE C 100     -12.704  41.555  35.492  1.00 30.01           C  
ATOM  11140  N   PRO C 101     -16.419  42.731  32.310  1.00 36.73           N  
ATOM  11141  CA  PRO C 101     -16.219  43.118  30.936  1.00 34.98           C  
ATOM  11142  C   PRO C 101     -14.737  43.192  30.620  1.00 36.29           C  
ATOM  11143  O   PRO C 101     -13.946  43.662  31.442  1.00 34.65           O  
ATOM  11144  CB  PRO C 101     -16.862  44.498  30.811  1.00 34.95           C  
ATOM  11145  CG  PRO C 101     -16.927  45.007  32.209  1.00 31.50           C  
ATOM  11146  CD  PRO C 101     -17.057  43.824  33.122  1.00 33.88           C  
ATOM  11147  N   ASP C 102     -14.379  42.748  29.410  1.00 34.87           N  
ATOM  11148  CA  ASP C 102     -12.969  42.784  28.990  1.00 32.96           C  
ATOM  11149  C   ASP C 102     -12.568  44.215  28.664  1.00 31.62           C  
ATOM  11150  O   ASP C 102     -11.411  44.548  28.922  1.00 32.10           O  
ATOM  11151  CB  ASP C 102     -12.680  41.828  27.836  1.00 29.68           C  
ATOM  11152  CG  ASP C 102     -11.264  41.890  27.330  1.00 32.93           C  
ATOM  11153  OD1 ASP C 102     -10.390  41.328  28.037  1.00 33.57           O  
ATOM  11154  OD2 ASP C 102     -11.060  42.545  26.292  1.00 31.71           O  
ATOM  11155  N   THR C 103     -13.463  45.016  28.133  1.00 28.89           N  
ATOM  11156  CA  THR C 103     -13.260  46.448  27.945  1.00 30.32           C  
ATOM  11157  C   THR C 103     -14.323  47.135  28.838  1.00 33.19           C  
ATOM  11158  O   THR C 103     -15.424  46.596  28.936  1.00 31.86           O  
ATOM  11159  CB  THR C 103     -13.486  46.885  26.496  1.00 30.79           C  
ATOM  11160  OG1 THR C 103     -12.597  46.177  25.632  1.00 33.54           O  
ATOM  11161  CG2 THR C 103     -13.275  48.376  26.289  1.00 26.19           C  
ATOM  11162  N   LEU C 104     -14.045  48.261  29.487  1.00 35.09           N  
ATOM  11163  CA  LEU C 104     -15.025  48.920  30.357  1.00 33.76           C  
ATOM  11164  C   LEU C 104     -16.041  49.687  29.532  1.00 32.08           C  
ATOM  11165  O   LEU C 104     -15.679  50.557  28.744  1.00 35.34           O  
ATOM  11166  CB  LEU C 104     -14.393  49.882  31.354  1.00 33.93           C  
ATOM  11167  CG  LEU C 104     -13.486  49.295  32.425  1.00 39.64           C  
ATOM  11168  CD1 LEU C 104     -12.674  50.400  33.099  1.00 37.12           C  
ATOM  11169  CD2 LEU C 104     -14.248  48.506  33.468  1.00 33.74           C  
ATOM  11170  N   PRO C 105     -17.318  49.433  29.764  1.00 31.75           N  
ATOM  11171  CA  PRO C 105     -18.357  50.121  29.013  1.00 31.08           C  
ATOM  11172  C   PRO C 105     -18.095  51.614  29.001  1.00 31.04           C  
ATOM  11173  O   PRO C 105     -17.683  52.248  29.970  1.00 31.41           O  
ATOM  11174  CB  PRO C 105     -19.664  49.707  29.723  1.00 31.26           C  
ATOM  11175  CG  PRO C 105     -19.336  48.370  30.308  1.00 31.24           C  
ATOM  11176  CD  PRO C 105     -17.868  48.431  30.695  1.00 30.40           C  
ATOM  11177  N   GLY C 106     -18.343  52.233  27.849  1.00 32.82           N  
ATOM  11178  CA  GLY C 106     -18.224  53.653  27.624  1.00 29.38           C  
ATOM  11179  C   GLY C 106     -16.806  54.198  27.574  1.00 31.01           C  
ATOM  11180  O   GLY C 106     -16.673  55.360  27.206  1.00 30.85           O  
ATOM  11181  N   ILE C 107     -15.774  53.404  27.841  1.00 30.93           N  
ATOM  11182  CA  ILE C 107     -14.420  53.941  27.928  1.00 33.79           C  
ATOM  11183  C   ILE C 107     -13.855  54.424  26.598  1.00 35.58           C  
ATOM  11184  O   ILE C 107     -13.052  55.351  26.545  1.00 36.04           O  
ATOM  11185  CB  ILE C 107     -13.471  52.952  28.631  1.00 35.35           C  
ATOM  11186  CG1 ILE C 107     -12.384  53.767  29.342  1.00 32.26           C  
ATOM  11187  CG2 ILE C 107     -12.862  51.953  27.654  1.00 31.86           C  
ATOM  11188  CD1 ILE C 107     -11.460  52.939  30.217  1.00 29.17           C  
ATOM  11189  N   SER C 108     -14.275  53.795  25.516  1.00 33.88           N  
ATOM  11190  CA  SER C 108     -13.823  54.129  24.181  1.00 33.88           C  
ATOM  11191  C   SER C 108     -14.767  53.540  23.148  1.00 33.26           C  
ATOM  11192  O   SER C 108     -15.427  52.555  23.462  1.00 32.53           O  
ATOM  11193  CB  SER C 108     -12.438  53.474  23.974  1.00 36.17           C  
ATOM  11194  OG  SER C 108     -12.136  53.437  22.588  1.00 35.38           O  
ATOM  11195  N   ARG C 109     -14.825  54.009  21.929  1.00 33.00           N  
ATOM  11196  CA  ARG C 109     -15.650  53.391  20.904  1.00 31.73           C  
ATOM  11197  C   ARG C 109     -14.938  52.111  20.413  1.00 32.93           C  
ATOM  11198  O   ARG C 109     -15.548  51.287  19.720  1.00 31.65           O  
ATOM  11199  CB  ARG C 109     -15.870  54.329  19.735  1.00 30.80           C  
ATOM  11200  CG  ARG C 109     -14.665  54.595  18.832  1.00 35.23           C  
ATOM  11201  CD  ARG C 109     -14.977  55.807  17.973  1.00 35.54           C  
ATOM  11202  NE  ARG C 109     -14.020  56.190  16.982  1.00 33.12           N  
ATOM  11203  CZ  ARG C 109     -12.799  56.667  17.098  1.00 32.34           C  
ATOM  11204  NH1 ARG C 109     -12.254  56.834  18.289  1.00 28.65           N  
ATOM  11205  NH2 ARG C 109     -12.109  56.942  15.984  1.00 31.74           N  
ATOM  11206  N   TYR C 110     -13.662  51.890  20.724  1.00 31.36           N  
ATOM  11207  CA  TYR C 110     -12.971  50.671  20.347  1.00 33.20           C  
ATOM  11208  C   TYR C 110     -12.773  49.766  21.561  1.00 33.64           C  
ATOM  11209  O   TYR C 110     -12.511  50.241  22.677  1.00 39.24           O  
ATOM  11210  CB  TYR C 110     -11.560  50.898  19.778  1.00 31.21           C  
ATOM  11211  CG  TYR C 110     -11.674  51.527  18.401  1.00 29.00           C  
ATOM  11212  CD1 TYR C 110     -12.091  50.783  17.316  1.00 30.61           C  
ATOM  11213  CD2 TYR C 110     -11.376  52.869  18.233  1.00 26.25           C  
ATOM  11214  CE1 TYR C 110     -12.210  51.371  16.069  1.00 29.06           C  
ATOM  11215  CE2 TYR C 110     -11.493  53.473  16.995  1.00 29.46           C  
ATOM  11216  CZ  TYR C 110     -11.899  52.697  15.907  1.00 31.75           C  
ATOM  11217  OH  TYR C 110     -12.029  53.309  14.689  1.00 34.15           O  
ATOM  11218  N   HIS C 111     -12.943  48.488  21.328  1.00 32.69           N  
ATOM  11219  CA  HIS C 111     -12.766  47.522  22.396  1.00 33.80           C  
ATOM  11220  C   HIS C 111     -11.384  46.887  22.205  1.00 33.78           C  
ATOM  11221  O   HIS C 111     -10.959  46.677  21.057  1.00 33.45           O  
ATOM  11222  CB  HIS C 111     -13.798  46.407  22.349  1.00 36.20           C  
ATOM  11223  CG  HIS C 111     -15.233  46.765  22.477  1.00 41.00           C  
ATOM  11224  ND1 HIS C 111     -16.247  45.857  22.210  1.00 42.12           N  
ATOM  11225  CD2 HIS C 111     -15.839  47.912  22.845  1.00 39.53           C  
ATOM  11226  CE1 HIS C 111     -17.407  46.442  22.390  1.00 41.79           C  
ATOM  11227  NE2 HIS C 111     -17.194  47.686  22.766  1.00 42.54           N  
ATOM  11228  N   GLN C 112     -10.795  46.435  23.286  1.00 31.37           N  
ATOM  11229  CA  GLN C 112      -9.568  45.656  23.156  1.00 31.89           C  
ATOM  11230  C   GLN C 112      -9.851  44.500  22.206  1.00 33.67           C  
ATOM  11231  O   GLN C 112     -10.907  43.854  22.326  1.00 34.16           O  
ATOM  11232  CB  GLN C 112      -9.171  45.102  24.501  1.00 30.84           C  
ATOM  11233  CG  GLN C 112      -8.073  44.074  24.509  1.00 33.20           C  
ATOM  11234  CD  GLN C 112      -7.582  43.784  25.906  1.00 36.59           C  
ATOM  11235  OE1 GLN C 112      -6.399  43.917  26.171  1.00 34.58           O  
ATOM  11236  NE2 GLN C 112      -8.473  43.407  26.805  1.00 33.61           N  
ATOM  11237  N   VAL C 113      -8.918  44.187  21.330  1.00 32.48           N  
ATOM  11238  CA  VAL C 113      -9.002  43.048  20.436  1.00 31.94           C  
ATOM  11239  C   VAL C 113      -7.653  42.331  20.443  1.00 33.03           C  
ATOM  11240  O   VAL C 113      -6.635  42.863  20.891  1.00 33.56           O  
ATOM  11241  CB  VAL C 113      -9.331  43.377  18.983  1.00 31.14           C  
ATOM  11242  CG1 VAL C 113     -10.682  44.045  18.787  1.00 25.50           C  
ATOM  11243  CG2 VAL C 113      -8.211  44.231  18.385  1.00 26.96           C  
ATOM  11244  N   VAL C 114      -7.606  41.108  19.958  1.00 33.29           N  
ATOM  11245  CA  VAL C 114      -6.342  40.370  19.918  1.00 34.22           C  
ATOM  11246  C   VAL C 114      -6.111  39.846  18.497  1.00 33.91           C  
ATOM  11247  O   VAL C 114      -7.050  39.521  17.777  1.00 32.44           O  
ATOM  11248  CB  VAL C 114      -6.241  39.232  20.935  1.00 35.17           C  
ATOM  11249  CG1 VAL C 114      -6.134  39.751  22.376  1.00 34.84           C  
ATOM  11250  CG2 VAL C 114      -7.456  38.329  20.767  1.00 33.39           C  
ATOM  11251  N   LEU C 115      -4.845  39.851  18.107  1.00 31.98           N  
ATOM  11252  CA  LEU C 115      -4.433  39.406  16.783  1.00 30.85           C  
ATOM  11253  C   LEU C 115      -2.935  39.156  16.730  1.00 31.75           C  
ATOM  11254  O   LEU C 115      -2.113  39.873  17.295  1.00 32.35           O  
ATOM  11255  CB  LEU C 115      -4.785  40.463  15.731  1.00 30.32           C  
ATOM  11256  CG  LEU C 115      -4.435  40.146  14.263  1.00 31.78           C  
ATOM  11257  CD1 LEU C 115      -5.166  38.912  13.748  1.00 27.83           C  
ATOM  11258  CD2 LEU C 115      -4.693  41.349  13.370  1.00 27.02           C  
ATOM  11259  N   HIS C 116      -2.586  38.087  16.037  1.00 32.63           N  
ATOM  11260  CA  HIS C 116      -1.208  37.721  15.763  1.00 32.54           C  
ATOM  11261  C   HIS C 116      -0.350  38.949  15.485  1.00 31.17           C  
ATOM  11262  O   HIS C 116      -0.652  39.743  14.575  1.00 29.21           O  
ATOM  11263  CB  HIS C 116      -1.169  36.811  14.498  1.00 32.27           C  
ATOM  11264  CG  HIS C 116       0.151  36.129  14.382  1.00 37.53           C  
ATOM  11265  ND1 HIS C 116       1.038  36.395  13.375  1.00 40.16           N  
ATOM  11266  CD2 HIS C 116       0.768  35.243  15.202  1.00 37.81           C  
ATOM  11267  CE1 HIS C 116       2.136  35.660  13.509  1.00 37.88           C  
ATOM  11268  NE2 HIS C 116       1.992  34.977  14.637  1.00 40.49           N  
ATOM  11269  N   GLN C 117       0.733  39.127  16.219  1.00 33.58           N  
ATOM  11270  CA  GLN C 117       1.581  40.308  16.019  1.00 34.25           C  
ATOM  11271  C   GLN C 117       2.066  40.485  14.589  1.00 34.91           C  
ATOM  11272  O   GLN C 117       2.150  41.605  14.070  1.00 34.85           O  
ATOM  11273  CB  GLN C 117       2.763  40.282  16.994  1.00 32.10           C  
ATOM  11274  CG  GLN C 117       3.558  41.558  16.910  1.00 29.68           C  
ATOM  11275  CD  GLN C 117       4.729  41.504  17.878  1.00 34.07           C  
ATOM  11276  OE1 GLN C 117       4.689  40.764  18.862  1.00 31.75           O  
ATOM  11277  NE2 GLN C 117       5.728  42.316  17.511  1.00 32.87           N  
ATOM  11278  N   GLY C 118       2.360  39.385  13.898  1.00 35.87           N  
ATOM  11279  CA  GLY C 118       2.784  39.437  12.509  1.00 34.04           C  
ATOM  11280  C   GLY C 118       1.761  40.074  11.587  1.00 33.66           C  
ATOM  11281  O   GLY C 118       2.146  40.841  10.681  1.00 34.20           O  
ATOM  11282  N   ARG C 119       0.463  39.873  11.797  1.00 31.85           N  
ATOM  11283  CA  ARG C 119      -0.527  40.579  10.991  1.00 32.08           C  
ATOM  11284  C   ARG C 119      -0.591  42.055  11.348  1.00 33.90           C  
ATOM  11285  O   ARG C 119      -0.867  42.839  10.448  1.00 36.32           O  
ATOM  11286  CB  ARG C 119      -1.965  40.054  11.103  1.00 32.49           C  
ATOM  11287  CG  ARG C 119      -2.039  38.572  10.817  1.00 37.48           C  
ATOM  11288  CD  ARG C 119      -1.642  38.413   9.333  1.00 36.70           C  
ATOM  11289  NE  ARG C 119      -2.656  39.120   8.528  1.00 38.41           N  
ATOM  11290  CZ  ARG C 119      -2.429  39.521   7.285  1.00 46.34           C  
ATOM  11291  NH1 ARG C 119      -1.208  39.294   6.780  1.00 47.65           N  
ATOM  11292  NH2 ARG C 119      -3.382  40.135   6.590  1.00 44.77           N  
ATOM  11293  N   ILE C 120      -0.364  42.394  12.609  1.00 32.51           N  
ATOM  11294  CA  ILE C 120      -0.352  43.804  13.000  1.00 32.06           C  
ATOM  11295  C   ILE C 120       0.805  44.490  12.268  1.00 30.85           C  
ATOM  11296  O   ILE C 120       0.566  45.539  11.660  1.00 29.54           O  
ATOM  11297  CB  ILE C 120      -0.247  43.932  14.528  1.00 32.88           C  
ATOM  11298  CG1 ILE C 120      -1.501  43.275  15.148  1.00 31.43           C  
ATOM  11299  CG2 ILE C 120      -0.168  45.393  14.952  1.00 30.41           C  
ATOM  11300  CD1 ILE C 120      -1.506  43.226  16.670  1.00 32.97           C  
ATOM  11301  N   GLU C 121       1.994  43.878  12.307  1.00 30.71           N  
ATOM  11302  CA  GLU C 121       3.159  44.426  11.632  1.00 32.57           C  
ATOM  11303  C   GLU C 121       2.960  44.600  10.139  1.00 33.58           C  
ATOM  11304  O   GLU C 121       3.161  45.659   9.518  1.00 32.21           O  
ATOM  11305  CB  GLU C 121       4.391  43.547  11.927  1.00 31.93           C  
ATOM  11306  CG  GLU C 121       4.807  43.738  13.413  1.00 33.12           C  
ATOM  11307  CD  GLU C 121       6.179  43.203  13.724  1.00 32.49           C  
ATOM  11308  OE1 GLU C 121       6.917  42.758  12.825  1.00 36.84           O  
ATOM  11309  OE2 GLU C 121       6.638  43.221  14.883  1.00 34.56           O  
ATOM  11310  N   ARG C 122       2.396  43.560   9.512  1.00 34.15           N  
ATOM  11311  CA  ARG C 122       2.155  43.608   8.073  1.00 34.89           C  
ATOM  11312  C   ARG C 122       1.351  44.833   7.729  1.00 35.40           C  
ATOM  11313  O   ARG C 122       1.686  45.589   6.786  1.00 36.19           O  
ATOM  11314  CB  ARG C 122       1.531  42.320   7.549  1.00 34.55           C  
ATOM  11315  CG  ARG C 122       0.685  42.549   6.312  1.00 36.79           C  
ATOM  11316  CD  ARG C 122       1.423  42.371   5.029  1.00 41.55           C  
ATOM  11317  NE  ARG C 122       2.492  43.270   4.645  1.00 45.37           N  
ATOM  11318  CZ  ARG C 122       3.764  43.010   4.951  1.00 46.51           C  
ATOM  11319  NH1 ARG C 122       4.055  41.902   5.648  1.00 42.06           N  
ATOM  11320  NH2 ARG C 122       4.778  43.781   4.550  1.00 44.19           N  
ATOM  11321  N   HIS C 123       0.241  45.036   8.430  1.00 34.27           N  
ATOM  11322  CA  HIS C 123      -0.525  46.276   8.227  1.00 33.70           C  
ATOM  11323  C   HIS C 123       0.280  47.532   8.449  1.00 31.55           C  
ATOM  11324  O   HIS C 123       0.108  48.454   7.650  1.00 28.77           O  
ATOM  11325  CB  HIS C 123      -1.770  46.223   9.145  1.00 40.16           C  
ATOM  11326  CG  HIS C 123      -2.643  45.190   8.519  1.00 40.20           C  
ATOM  11327  ND1 HIS C 123      -2.787  43.919   8.991  1.00 50.59           N  
ATOM  11328  CD2 HIS C 123      -3.392  45.281   7.403  1.00 44.01           C  
ATOM  11329  CE1 HIS C 123      -3.635  43.263   8.170  1.00 46.64           C  
ATOM  11330  NE2 HIS C 123      -4.021  44.072   7.198  1.00 42.08           N  
ATOM  11331  N   ILE C 124       1.139  47.614   9.468  1.00 31.32           N  
ATOM  11332  CA  ILE C 124       1.958  48.813   9.669  1.00 31.24           C  
ATOM  11333  C   ILE C 124       2.990  48.927   8.546  1.00 30.03           C  
ATOM  11334  O   ILE C 124       3.124  49.947   7.894  1.00 27.69           O  
ATOM  11335  CB  ILE C 124       2.601  48.862  11.077  1.00 32.59           C  
ATOM  11336  CG1 ILE C 124       1.486  48.710  12.116  1.00 32.81           C  
ATOM  11337  CG2 ILE C 124       3.322  50.205  11.260  1.00 28.97           C  
ATOM  11338  CD1 ILE C 124       1.848  48.491  13.549  1.00 27.98           C  
ATOM  11339  N   LEU C 125       3.573  47.805   8.145  1.00 31.33           N  
ATOM  11340  CA  LEU C 125       4.510  47.736   7.008  1.00 32.13           C  
ATOM  11341  C   LEU C 125       3.856  48.191   5.713  1.00 31.72           C  
ATOM  11342  O   LEU C 125       4.406  49.080   5.036  1.00 32.22           O  
ATOM  11343  CB  LEU C 125       5.156  46.362   6.915  1.00 26.68           C  
ATOM  11344  CG  LEU C 125       6.157  46.074   8.048  1.00 29.67           C  
ATOM  11345  CD1 LEU C 125       6.454  44.578   8.192  1.00 26.10           C  
ATOM  11346  CD2 LEU C 125       7.423  46.897   7.839  1.00 23.43           C  
ATOM  11347  N   ASP C 126       2.621  47.773   5.422  1.00 31.45           N  
ATOM  11348  CA  ASP C 126       1.968  48.299   4.230  1.00 31.17           C  
ATOM  11349  C   ASP C 126       1.762  49.807   4.270  1.00 32.66           C  
ATOM  11350  O   ASP C 126       1.868  50.484   3.237  1.00 34.73           O  
ATOM  11351  CB  ASP C 126       0.645  47.591   3.969  1.00 31.03           C  
ATOM  11352  CG  ASP C 126       0.755  46.117   3.709  1.00 36.02           C  
ATOM  11353  OD1 ASP C 126       1.835  45.594   3.369  1.00 34.16           O  
ATOM  11354  OD2 ASP C 126      -0.277  45.426   3.842  1.00 33.93           O  
ATOM  11355  N   SER C 127       1.371  50.369   5.398  1.00 33.39           N  
ATOM  11356  CA  SER C 127       1.108  51.790   5.564  1.00 31.08           C  
ATOM  11357  C   SER C 127       2.372  52.611   5.382  1.00 30.23           C  
ATOM  11358  O   SER C 127       2.401  53.617   4.687  1.00 30.74           O  
ATOM  11359  CB  SER C 127       0.535  51.986   6.995  1.00 33.83           C  
ATOM  11360  OG  SER C 127       0.006  53.258   7.139  1.00 32.31           O  
ATOM  11361  N   ILE C 128       3.452  52.183   6.016  1.00 30.79           N  
ATOM  11362  CA  ILE C 128       4.761  52.802   5.809  1.00 32.30           C  
ATOM  11363  C   ILE C 128       5.085  52.785   4.311  1.00 32.25           C  
ATOM  11364  O   ILE C 128       5.466  53.813   3.788  1.00 31.77           O  
ATOM  11365  CB  ILE C 128       5.844  52.095   6.618  1.00 31.51           C  
ATOM  11366  CG1 ILE C 128       5.606  52.256   8.132  1.00 26.05           C  
ATOM  11367  CG2 ILE C 128       7.226  52.578   6.181  1.00 30.10           C  
ATOM  11368  CD1 ILE C 128       6.340  51.140   8.888  1.00 28.51           C  
ATOM  11369  N   ALA C 129       4.863  51.670   3.622  1.00 31.16           N  
ATOM  11370  CA  ALA C 129       5.126  51.600   2.185  1.00 34.20           C  
ATOM  11371  C   ALA C 129       4.330  52.667   1.439  1.00 32.83           C  
ATOM  11372  O   ALA C 129       4.891  53.463   0.691  1.00 31.53           O  
ATOM  11373  CB  ALA C 129       4.895  50.207   1.595  1.00 26.86           C  
ATOM  11374  N   GLU C 130       3.046  52.771   1.702  1.00 33.49           N  
ATOM  11375  CA  GLU C 130       2.207  53.789   1.118  1.00 35.04           C  
ATOM  11376  C   GLU C 130       2.604  55.221   1.496  1.00 36.42           C  
ATOM  11377  O   GLU C 130       2.873  56.037   0.608  1.00 36.54           O  
ATOM  11378  CB  GLU C 130       0.772  53.592   1.633  1.00 38.32           C  
ATOM  11379  CG  GLU C 130      -0.222  54.314   0.723  1.00 42.79           C  
ATOM  11380  CD  GLU C 130      -1.603  54.379   1.346  1.00 48.54           C  
ATOM  11381  OE1 GLU C 130      -1.873  53.624   2.294  1.00 50.51           O  
ATOM  11382  OE2 GLU C 130      -2.434  55.184   0.891  1.00 52.20           O  
ATOM  11383  N   ILE C 131       2.645  55.528   2.795  1.00 35.71           N  
ATOM  11384  CA  ILE C 131       2.941  56.897   3.192  1.00 37.09           C  
ATOM  11385  C   ILE C 131       4.340  57.318   2.731  1.00 39.52           C  
ATOM  11386  O   ILE C 131       4.500  58.439   2.218  1.00 38.23           O  
ATOM  11387  CB  ILE C 131       2.715  57.191   4.677  1.00 38.09           C  
ATOM  11388  CG1 ILE C 131       1.349  56.775   5.238  1.00 36.67           C  
ATOM  11389  CG2 ILE C 131       2.908  58.685   4.942  1.00 38.28           C  
ATOM  11390  CD1 ILE C 131       0.144  57.317   4.521  1.00 38.13           C  
ATOM  11391  N   SER C 132       5.349  56.457   2.775  1.00 39.76           N  
ATOM  11392  CA  SER C 132       6.659  56.930   2.313  1.00 41.22           C  
ATOM  11393  C   SER C 132       6.905  56.662   0.846  1.00 42.18           C  
ATOM  11394  O   SER C 132       8.022  56.837   0.372  1.00 41.81           O  
ATOM  11395  CB  SER C 132       7.752  56.301   3.172  1.00 39.86           C  
ATOM  11396  OG  SER C 132       7.927  54.962   2.755  1.00 31.82           O  
ATOM  11397  N   ASP C 133       5.914  56.199   0.089  1.00 43.77           N  
ATOM  11398  CA  ASP C 133       6.102  55.854  -1.308  1.00 45.90           C  
ATOM  11399  C   ASP C 133       7.213  54.836  -1.494  1.00 47.26           C  
ATOM  11400  O   ASP C 133       8.082  54.891  -2.377  1.00 50.19           O  
ATOM  11401  CB  ASP C 133       6.354  57.093  -2.183  1.00 44.34           C  
ATOM  11402  CG  ASP C 133       5.867  56.826  -3.602  1.00 50.83           C  
ATOM  11403  OD1 ASP C 133       4.730  56.306  -3.723  1.00 52.85           O  
ATOM  11404  OD2 ASP C 133       6.579  57.106  -4.580  1.00 51.83           O  
ATOM  11405  N   THR C 134       7.233  53.783  -0.687  1.00 45.75           N  
ATOM  11406  CA  THR C 134       8.208  52.720  -0.618  1.00 48.14           C  
ATOM  11407  C   THR C 134       9.624  53.151  -0.224  1.00 48.18           C  
ATOM  11408  O   THR C 134      10.557  52.362  -0.059  1.00 48.87           O  
ATOM  11409  CB  THR C 134       8.277  51.876  -1.908  1.00 48.69           C  
ATOM  11410  OG1 THR C 134       9.032  52.563  -2.899  1.00 51.72           O  
ATOM  11411  CG2 THR C 134       6.922  51.577  -2.534  1.00 47.14           C  
ATOM  11412  N   ARG C 135       9.858  54.424   0.036  1.00 46.84           N  
ATOM  11413  CA  ARG C 135      11.116  55.007   0.388  1.00 47.93           C  
ATOM  11414  C   ARG C 135      11.674  54.562   1.720  1.00 48.71           C  
ATOM  11415  O   ARG C 135      12.900  54.479   1.792  1.00 48.73           O  
ATOM  11416  CB  ARG C 135      10.994  56.536   0.345  1.00 53.33           C  
ATOM  11417  CG  ARG C 135      11.399  57.078  -1.024  1.00 59.07           C  
ATOM  11418  CD  ARG C 135      12.790  57.694  -0.875  1.00 66.45           C  
ATOM  11419  NE  ARG C 135      12.779  59.122  -0.701  1.00 69.95           N  
ATOM  11420  CZ  ARG C 135      11.933  59.920  -0.090  1.00 70.37           C  
ATOM  11421  NH1 ARG C 135      10.827  59.559   0.534  1.00 71.99           N  
ATOM  11422  NH2 ARG C 135      12.214  61.207  -0.147  1.00 70.43           N  
ATOM  11423  N   ILE C 136      10.888  54.287   2.740  1.00 45.70           N  
ATOM  11424  CA  ILE C 136      11.454  53.837   4.004  1.00 40.87           C  
ATOM  11425  C   ILE C 136      11.248  52.334   4.135  1.00 39.30           C  
ATOM  11426  O   ILE C 136      10.127  51.885   4.004  1.00 37.66           O  
ATOM  11427  CB  ILE C 136      10.829  54.540   5.214  1.00 38.82           C  
ATOM  11428  CG1 ILE C 136      11.083  56.048   5.223  1.00 39.90           C  
ATOM  11429  CG2 ILE C 136      11.278  53.906   6.528  1.00 35.75           C  
ATOM  11430  CD1 ILE C 136      10.199  56.791   6.214  1.00 34.50           C  
ATOM  11431  N   LYS C 137      12.298  51.544   4.345  1.00 37.93           N  
ATOM  11432  CA  LYS C 137      12.137  50.105   4.451  1.00 37.67           C  
ATOM  11433  C   LYS C 137      13.024  49.560   5.557  1.00 36.57           C  
ATOM  11434  O   LYS C 137      14.063  50.148   5.795  1.00 41.01           O  
ATOM  11435  CB  LYS C 137      12.464  49.360   3.174  1.00 38.63           C  
ATOM  11436  CG  LYS C 137      12.366  50.025   1.819  1.00 40.53           C  
ATOM  11437  CD  LYS C 137      13.336  49.339   0.842  1.00 43.12           C  
ATOM  11438  CE  LYS C 137      13.134  49.877  -0.568  1.00 44.39           C  
ATOM  11439  NZ  LYS C 137      11.774  49.499  -1.054  1.00 45.24           N  
ATOM  11440  N   VAL C 138      12.664  48.438   6.154  1.00 34.48           N  
ATOM  11441  CA  VAL C 138      13.525  47.877   7.174  1.00 34.77           C  
ATOM  11442  C   VAL C 138      14.784  47.276   6.550  1.00 35.71           C  
ATOM  11443  O   VAL C 138      14.743  46.387   5.693  1.00 36.86           O  
ATOM  11444  CB  VAL C 138      12.760  46.839   8.014  1.00 34.29           C  
ATOM  11445  CG1 VAL C 138      13.676  46.152   9.021  1.00 30.89           C  
ATOM  11446  CG2 VAL C 138      11.559  47.528   8.672  1.00 28.03           C  
ATOM  11447  N   GLU C 139      15.932  47.726   7.016  1.00 34.60           N  
ATOM  11448  CA  GLU C 139      17.211  47.192   6.566  1.00 33.85           C  
ATOM  11449  C   GLU C 139      17.640  46.105   7.551  1.00 32.58           C  
ATOM  11450  O   GLU C 139      17.751  46.419   8.725  1.00 35.95           O  
ATOM  11451  CB  GLU C 139      18.309  48.247   6.452  1.00 29.60           C  
ATOM  11452  CG  GLU C 139      18.033  49.384   5.503  1.00 29.62           C  
ATOM  11453  CD  GLU C 139      18.979  50.576   5.632  1.00 37.70           C  
ATOM  11454  OE1 GLU C 139      20.167  50.473   5.258  1.00 39.60           O  
ATOM  11455  OE2 GLU C 139      18.574  51.683   6.075  1.00 36.93           O  
ATOM  11456  N   ARG C 140      17.875  44.888   7.099  1.00 32.56           N  
ATOM  11457  CA  ARG C 140      18.335  43.800   7.936  1.00 32.83           C  
ATOM  11458  C   ARG C 140      19.113  42.777   7.112  1.00 32.74           C  
ATOM  11459  O   ARG C 140      18.908  42.656   5.900  1.00 34.96           O  
ATOM  11460  CB  ARG C 140      17.116  43.120   8.586  1.00 33.54           C  
ATOM  11461  CG  ARG C 140      16.096  42.589   7.584  1.00 30.93           C  
ATOM  11462  CD  ARG C 140      15.211  41.519   8.181  1.00 32.06           C  
ATOM  11463  NE  ARG C 140      14.521  41.850   9.452  1.00 32.65           N  
ATOM  11464  CZ  ARG C 140      13.368  42.510   9.464  1.00 31.04           C  
ATOM  11465  NH1 ARG C 140      12.876  42.909   8.292  1.00 31.96           N  
ATOM  11466  NH2 ARG C 140      12.739  42.775  10.596  1.00 29.98           N  
ATOM  11467  N   PRO C 141      19.964  41.988   7.745  1.00 32.75           N  
ATOM  11468  CA  PRO C 141      20.216  42.092   9.167  1.00 33.02           C  
ATOM  11469  C   PRO C 141      21.339  43.060   9.479  1.00 35.11           C  
ATOM  11470  O   PRO C 141      22.406  42.894   8.857  1.00 32.73           O  
ATOM  11471  CB  PRO C 141      20.616  40.669   9.561  1.00 33.22           C  
ATOM  11472  CG  PRO C 141      21.049  39.988   8.324  1.00 32.81           C  
ATOM  11473  CD  PRO C 141      20.736  40.869   7.149  1.00 30.21           C  
ATOM  11474  N   LEU C 142      21.098  44.093  10.305  1.00 34.16           N  
ATOM  11475  CA  LEU C 142      22.122  45.068  10.608  1.00 34.27           C  
ATOM  11476  C   LEU C 142      22.191  45.303  12.122  1.00 35.51           C  
ATOM  11477  O   LEU C 142      21.148  45.172  12.763  1.00 35.53           O  
ATOM  11478  CB  LEU C 142      22.073  46.410   9.968  1.00 31.87           C  
ATOM  11479  CG  LEU C 142      21.670  46.894   8.615  1.00 37.85           C  
ATOM  11480  CD1 LEU C 142      22.512  48.088   8.166  1.00 31.07           C  
ATOM  11481  CD2 LEU C 142      21.679  45.875   7.484  1.00 36.16           C  
ATOM  11482  N   ILE C 143      23.377  45.574  12.645  1.00 34.73           N  
ATOM  11483  CA  ILE C 143      23.543  45.728  14.080  1.00 37.29           C  
ATOM  11484  C   ILE C 143      24.570  46.779  14.440  1.00 38.56           C  
ATOM  11485  O   ILE C 143      25.706  46.792  13.962  1.00 40.17           O  
ATOM  11486  CB  ILE C 143      23.935  44.404  14.761  1.00 39.78           C  
ATOM  11487  CG1 ILE C 143      23.814  44.496  16.280  1.00 38.74           C  
ATOM  11488  CG2 ILE C 143      25.353  43.937  14.428  1.00 38.87           C  
ATOM  11489  CD1 ILE C 143      23.860  43.128  16.919  1.00 36.06           C  
ATOM  11490  N   PRO C 144      24.192  47.684  15.339  1.00 41.02           N  
ATOM  11491  CA  PRO C 144      25.088  48.720  15.809  1.00 40.59           C  
ATOM  11492  C   PRO C 144      26.236  48.093  16.594  1.00 39.71           C  
ATOM  11493  O   PRO C 144      26.031  47.166  17.352  1.00 38.34           O  
ATOM  11494  CB  PRO C 144      24.253  49.614  16.689  1.00 40.42           C  
ATOM  11495  CG  PRO C 144      22.866  49.133  16.615  1.00 39.61           C  
ATOM  11496  CD  PRO C 144      22.843  47.805  15.935  1.00 39.71           C  
ATOM  11497  N   GLU C 145      27.438  48.653  16.441  1.00 41.11           N  
ATOM  11498  CA  GLU C 145      28.611  48.159  17.160  1.00 43.13           C  
ATOM  11499  C   GLU C 145      29.229  49.230  18.032  1.00 42.86           C  
ATOM  11500  O   GLU C 145      29.961  48.969  18.979  1.00 44.85           O  
ATOM  11501  CB  GLU C 145      29.639  47.650  16.133  1.00 46.49           C  
ATOM  11502  CG  GLU C 145      29.695  46.134  16.236  1.00 53.58           C  
ATOM  11503  CD  GLU C 145      30.430  45.489  15.093  1.00 60.51           C  
ATOM  11504  OE1 GLU C 145      31.343  46.114  14.485  1.00 64.12           O  
ATOM  11505  OE2 GLU C 145      30.024  44.328  14.870  1.00 62.67           O  
ATOM  11506  N   LYS C 146      28.931  50.481  17.707  1.00 40.52           N  
ATOM  11507  CA  LYS C 146      29.454  51.606  18.470  1.00 40.45           C  
ATOM  11508  C   LYS C 146      28.557  52.837  18.309  1.00 38.71           C  
ATOM  11509  O   LYS C 146      27.893  52.978  17.302  1.00 36.44           O  
ATOM  11510  CB  LYS C 146      30.892  51.879  18.030  1.00 44.79           C  
ATOM  11511  CG  LYS C 146      31.601  52.919  18.882  1.00 49.21           C  
ATOM  11512  CD  LYS C 146      33.112  52.754  18.789  1.00 54.13           C  
ATOM  11513  CE  LYS C 146      33.776  54.038  18.303  1.00 54.88           C  
ATOM  11514  NZ  LYS C 146      33.635  54.102  16.810  1.00 61.59           N  
ATOM  11515  N   MET C 147      28.503  53.674  19.318  1.00 38.59           N  
ATOM  11516  CA  MET C 147      27.659  54.857  19.354  1.00 40.82           C  
ATOM  11517  C   MET C 147      28.449  55.956  20.056  1.00 39.83           C  
ATOM  11518  O   MET C 147      28.850  55.746  21.186  1.00 40.51           O  
ATOM  11519  CB  MET C 147      26.320  54.628  20.083  1.00 38.13           C  
ATOM  11520  CG  MET C 147      25.537  55.907  20.311  1.00 36.75           C  
ATOM  11521  SD  MET C 147      23.796  55.630  20.761  1.00 39.48           S  
ATOM  11522  CE  MET C 147      24.037  54.705  22.272  1.00 33.47           C  
ATOM  11523  N   GLU C 148      28.707  57.054  19.368  1.00 39.66           N  
ATOM  11524  CA  GLU C 148      29.468  58.158  19.919  1.00 41.93           C  
ATOM  11525  C   GLU C 148      28.614  59.425  19.868  1.00 41.77           C  
ATOM  11526  O   GLU C 148      28.128  59.758  18.789  1.00 40.80           O  
ATOM  11527  CB  GLU C 148      30.747  58.382  19.106  1.00 44.36           C  
ATOM  11528  CG  GLU C 148      31.580  57.127  18.863  1.00 55.01           C  
ATOM  11529  CD  GLU C 148      32.543  57.304  17.697  1.00 60.35           C  
ATOM  11530  OE1 GLU C 148      33.448  58.150  17.921  1.00 65.38           O  
ATOM  11531  OE2 GLU C 148      32.395  56.667  16.625  1.00 54.09           O  
ATOM  11532  N   ILE C 149      28.398  60.076  21.008  1.00 39.65           N  
ATOM  11533  CA  ILE C 149      27.560  61.258  21.035  1.00 40.68           C  
ATOM  11534  C   ILE C 149      28.369  62.507  21.365  1.00 41.86           C  
ATOM  11535  O   ILE C 149      29.115  62.540  22.343  1.00 43.97           O  
ATOM  11536  CB  ILE C 149      26.434  61.097  22.076  1.00 39.91           C  
ATOM  11537  CG1 ILE C 149      25.593  59.842  21.789  1.00 40.60           C  
ATOM  11538  CG2 ILE C 149      25.532  62.316  22.139  1.00 38.94           C  
ATOM  11539  CD1 ILE C 149      24.864  59.296  22.997  1.00 42.00           C  
ATOM  11540  N   ASP C 150      28.209  63.546  20.561  1.00 41.80           N  
ATOM  11541  CA  ASP C 150      28.892  64.798  20.818  1.00 41.46           C  
ATOM  11542  C   ASP C 150      27.839  65.743  21.418  1.00 42.04           C  
ATOM  11543  O   ASP C 150      27.176  66.477  20.701  1.00 39.93           O  
ATOM  11544  CB  ASP C 150      29.514  65.370  19.554  1.00 45.07           C  
ATOM  11545  CG  ASP C 150      30.291  66.661  19.724  1.00 49.33           C  
ATOM  11546  OD1 ASP C 150      30.247  67.364  20.747  1.00 49.25           O  
ATOM  11547  OD2 ASP C 150      30.988  67.020  18.751  1.00 49.59           O  
ATOM  11548  N   SER C 151      27.802  65.802  22.747  1.00 42.28           N  
ATOM  11549  CA  SER C 151      26.909  66.668  23.488  1.00 41.26           C  
ATOM  11550  C   SER C 151      27.116  68.140  23.196  1.00 42.40           C  
ATOM  11551  O   SER C 151      26.111  68.860  23.210  1.00 42.67           O  
ATOM  11552  CB  SER C 151      26.967  66.365  24.984  1.00 39.27           C  
ATOM  11553  OG  SER C 151      26.636  65.009  25.241  1.00 43.03           O  
ATOM  11554  N   SER C 152      28.244  68.635  22.718  1.00 42.80           N  
ATOM  11555  CA  SER C 152      28.444  70.013  22.309  1.00 42.50           C  
ATOM  11556  C   SER C 152      27.736  70.416  21.036  1.00 42.00           C  
ATOM  11557  O   SER C 152      27.567  71.621  20.741  1.00 42.40           O  
ATOM  11558  CB  SER C 152      29.965  70.246  22.148  1.00 42.83           C  
ATOM  11559  OG  SER C 152      30.392  69.949  20.826  1.00 42.02           O  
ATOM  11560  N   LYS C 153      27.300  69.489  20.183  1.00 44.05           N  
ATOM  11561  CA  LYS C 153      26.565  69.857  18.976  1.00 44.07           C  
ATOM  11562  C   LYS C 153      25.062  69.659  19.145  1.00 41.82           C  
ATOM  11563  O   LYS C 153      24.266  70.032  18.279  1.00 41.12           O  
ATOM  11564  CB  LYS C 153      27.093  69.116  17.749  1.00 49.72           C  
ATOM  11565  CG  LYS C 153      28.515  69.519  17.360  1.00 52.71           C  
ATOM  11566  CD  LYS C 153      28.941  68.890  16.041  1.00 57.91           C  
ATOM  11567  CE  LYS C 153      29.930  67.758  16.154  1.00 61.39           C  
ATOM  11568  NZ  LYS C 153      29.809  66.783  15.011  1.00 64.31           N  
ATOM  11569  N   ALA C 154      24.600  69.228  20.321  1.00 40.10           N  
ATOM  11570  CA  ALA C 154      23.224  68.933  20.621  1.00 42.99           C  
ATOM  11571  C   ALA C 154      22.173  69.934  20.171  1.00 42.50           C  
ATOM  11572  O   ALA C 154      21.115  69.513  19.678  1.00 44.35           O  
ATOM  11573  CB  ALA C 154      23.051  68.660  22.120  1.00 39.40           C  
ATOM  11574  N   GLU C 155      22.375  71.225  20.278  1.00 40.80           N  
ATOM  11575  CA  GLU C 155      21.376  72.195  19.878  1.00 41.86           C  
ATOM  11576  C   GLU C 155      21.594  72.760  18.500  1.00 42.49           C  
ATOM  11577  O   GLU C 155      20.891  73.708  18.136  1.00 43.39           O  
ATOM  11578  CB  GLU C 155      21.285  73.336  20.913  1.00 38.07           C  
ATOM  11579  CG  GLU C 155      21.037  72.762  22.318  1.00 37.56           C  
ATOM  11580  CD  GLU C 155      19.754  71.922  22.348  1.00 43.60           C  
ATOM  11581  OE1 GLU C 155      18.899  72.031  21.446  1.00 40.75           O  
ATOM  11582  OE2 GLU C 155      19.593  71.092  23.253  1.00 39.66           O  
ATOM  11583  N   ASP C 156      22.521  72.185  17.745  1.00 42.22           N  
ATOM  11584  CA  ASP C 156      22.803  72.717  16.413  1.00 43.60           C  
ATOM  11585  C   ASP C 156      21.941  71.962  15.439  1.00 44.94           C  
ATOM  11586  O   ASP C 156      22.103  70.751  15.310  1.00 46.67           O  
ATOM  11587  CB  ASP C 156      24.293  72.511  16.133  1.00 42.40           C  
ATOM  11588  CG  ASP C 156      24.766  72.938  14.764  1.00 41.43           C  
ATOM  11589  OD1 ASP C 156      23.957  73.252  13.861  1.00 38.78           O  
ATOM  11590  OD2 ASP C 156      26.022  72.956  14.636  1.00 50.99           O  
ATOM  11591  N   PRO C 157      21.065  72.649  14.726  1.00 47.48           N  
ATOM  11592  CA  PRO C 157      20.181  72.013  13.761  1.00 48.40           C  
ATOM  11593  C   PRO C 157      20.928  71.451  12.564  1.00 49.77           C  
ATOM  11594  O   PRO C 157      20.457  70.490  11.948  1.00 50.68           O  
ATOM  11595  CB  PRO C 157      19.199  73.097  13.346  1.00 47.04           C  
ATOM  11596  CG  PRO C 157      19.847  74.383  13.711  1.00 46.58           C  
ATOM  11597  CD  PRO C 157      20.809  74.100  14.828  1.00 46.46           C  
ATOM  11598  N   GLU C 158      22.099  71.975  12.232  1.00 48.20           N  
ATOM  11599  CA  GLU C 158      22.869  71.483  11.106  1.00 46.23           C  
ATOM  11600  C   GLU C 158      23.770  70.302  11.414  1.00 43.74           C  
ATOM  11601  O   GLU C 158      24.284  69.697  10.463  1.00 44.13           O  
ATOM  11602  CB  GLU C 158      23.737  72.639  10.590  1.00 46.23           C  
ATOM  11603  CG  GLU C 158      23.045  73.860  10.033  1.00 48.90           C  
ATOM  11604  CD  GLU C 158      21.757  73.602   9.311  1.00 54.37           C  
ATOM  11605  OE1 GLU C 158      21.550  72.513   8.731  1.00 59.09           O  
ATOM  11606  OE2 GLU C 158      20.875  74.489   9.283  1.00 57.37           O  
ATOM  11607  N   ALA C 159      24.083  70.043  12.671  1.00 41.34           N  
ATOM  11608  CA  ALA C 159      24.998  69.000  13.075  1.00 38.54           C  
ATOM  11609  C   ALA C 159      24.408  67.610  13.016  1.00 40.55           C  
ATOM  11610  O   ALA C 159      23.206  67.317  12.952  1.00 41.35           O  
ATOM  11611  CB  ALA C 159      25.470  69.271  14.510  1.00 36.63           C  
ATOM  11612  N   TYR C 160      25.307  66.635  13.123  1.00 38.32           N  
ATOM  11613  CA  TYR C 160      25.006  65.205  13.147  1.00 37.42           C  
ATOM  11614  C   TYR C 160      25.716  64.683  14.381  1.00 38.73           C  
ATOM  11615  O   TYR C 160      26.829  64.193  14.291  1.00 41.95           O  
ATOM  11616  CB  TYR C 160      25.545  64.518  11.891  1.00 35.65           C  
ATOM  11617  CG  TYR C 160      24.762  64.883  10.648  1.00 34.38           C  
ATOM  11618  CD1 TYR C 160      25.115  65.994   9.900  1.00 35.88           C  
ATOM  11619  CD2 TYR C 160      23.681  64.142  10.217  1.00 32.83           C  
ATOM  11620  CE1 TYR C 160      24.432  66.356   8.766  1.00 35.21           C  
ATOM  11621  CE2 TYR C 160      22.973  64.493   9.089  1.00 32.84           C  
ATOM  11622  CZ  TYR C 160      23.358  65.595   8.362  1.00 36.05           C  
ATOM  11623  OH  TYR C 160      22.661  65.969   7.226  1.00 36.48           O  
ATOM  11624  N   PRO C 161      25.180  64.962  15.562  1.00 41.07           N  
ATOM  11625  CA  PRO C 161      25.839  64.683  16.815  1.00 37.41           C  
ATOM  11626  C   PRO C 161      25.989  63.227  17.141  1.00 37.71           C  
ATOM  11627  O   PRO C 161      26.733  62.959  18.087  1.00 37.66           O  
ATOM  11628  CB  PRO C 161      24.924  65.294  17.870  1.00 37.41           C  
ATOM  11629  CG  PRO C 161      23.985  66.186  17.165  1.00 38.97           C  
ATOM  11630  CD  PRO C 161      23.848  65.611  15.788  1.00 39.79           C  
ATOM  11631  N   VAL C 162      25.235  62.330  16.494  1.00 37.97           N  
ATOM  11632  CA  VAL C 162      25.357  60.922  16.890  1.00 38.06           C  
ATOM  11633  C   VAL C 162      25.960  60.103  15.758  1.00 38.66           C  
ATOM  11634  O   VAL C 162      25.417  60.005  14.656  1.00 39.40           O  
ATOM  11635  CB  VAL C 162      24.016  60.323  17.314  1.00 37.72           C  
ATOM  11636  CG1 VAL C 162      24.231  58.991  18.026  1.00 33.38           C  
ATOM  11637  CG2 VAL C 162      23.174  61.244  18.207  1.00 38.92           C  
ATOM  11638  N   THR C 163      27.104  59.500  16.034  1.00 39.46           N  
ATOM  11639  CA  THR C 163      27.769  58.649  15.046  1.00 39.06           C  
ATOM  11640  C   THR C 163      27.528  57.188  15.392  1.00 37.68           C  
ATOM  11641  O   THR C 163      27.946  56.727  16.455  1.00 36.89           O  
ATOM  11642  CB  THR C 163      29.270  58.948  14.964  1.00 40.89           C  
ATOM  11643  OG1 THR C 163      29.469  60.382  14.985  1.00 42.66           O  
ATOM  11644  CG2 THR C 163      29.845  58.412  13.668  1.00 38.02           C  
ATOM  11645  N   MET C 164      26.836  56.503  14.481  1.00 35.47           N  
ATOM  11646  CA  MET C 164      26.525  55.096  14.668  1.00 35.44           C  
ATOM  11647  C   MET C 164      27.362  54.217  13.737  1.00 36.54           C  
ATOM  11648  O   MET C 164      27.494  54.518  12.538  1.00 39.26           O  
ATOM  11649  CB  MET C 164      25.036  54.827  14.432  1.00 34.65           C  
ATOM  11650  CG  MET C 164      24.089  55.670  15.298  1.00 32.89           C  
ATOM  11651  SD  MET C 164      24.187  55.262  17.065  1.00 34.13           S  
ATOM  11652  CE  MET C 164      23.444  53.636  17.050  1.00 31.18           C  
ATOM  11653  N   THR C 165      28.010  53.210  14.304  1.00 36.42           N  
ATOM  11654  CA  THR C 165      28.794  52.289  13.496  1.00 37.22           C  
ATOM  11655  C   THR C 165      27.983  51.002  13.378  1.00 37.55           C  
ATOM  11656  O   THR C 165      27.773  50.353  14.401  1.00 37.33           O  
ATOM  11657  CB  THR C 165      30.191  52.009  14.090  1.00 38.48           C  
ATOM  11658  OG1 THR C 165      30.824  53.260  14.311  1.00 37.18           O  
ATOM  11659  CG2 THR C 165      31.050  51.214  13.112  1.00 37.52           C  
ATOM  11660  N   LEU C 166      27.548  50.738  12.148  1.00 36.54           N  
ATOM  11661  CA  LEU C 166      26.747  49.561  11.865  1.00 36.00           C  
ATOM  11662  C   LEU C 166      27.516  48.458  11.149  1.00 38.91           C  
ATOM  11663  O   LEU C 166      28.323  48.646  10.232  1.00 38.18           O  
ATOM  11664  CB  LEU C 166      25.525  49.944  11.008  1.00 29.10           C  
ATOM  11665  CG  LEU C 166      24.696  51.110  11.595  1.00 32.12           C  
ATOM  11666  CD1 LEU C 166      23.561  51.453  10.645  1.00 32.92           C  
ATOM  11667  CD2 LEU C 166      24.187  50.820  12.990  1.00 21.37           C  
ATOM  11668  N   ARG C 167      27.200  47.229  11.548  1.00 40.50           N  
ATOM  11669  CA  ARG C 167      27.790  46.052  10.946  1.00 38.55           C  
ATOM  11670  C   ARG C 167      26.701  45.352  10.153  1.00 39.80           C  
ATOM  11671  O   ARG C 167      25.582  45.236  10.673  1.00 35.87           O  
ATOM  11672  CB  ARG C 167      28.355  45.048  11.946  1.00 36.75           C  
ATOM  11673  CG  ARG C 167      29.006  43.884  11.188  1.00 41.59           C  
ATOM  11674  CD  ARG C 167      29.823  43.016  12.131  1.00 41.17           C  
ATOM  11675  NE  ARG C 167      29.025  42.453  13.199  1.00 45.01           N  
ATOM  11676  CZ  ARG C 167      28.389  41.292  13.204  1.00 48.28           C  
ATOM  11677  NH1 ARG C 167      28.420  40.480  12.167  1.00 50.94           N  
ATOM  11678  NH2 ARG C 167      27.731  40.935  14.298  1.00 50.59           N  
ATOM  11679  N   TYR C 168      27.100  44.931   8.955  1.00 39.39           N  
ATOM  11680  CA  TYR C 168      26.183  44.175   8.095  1.00 38.69           C  
ATOM  11681  C   TYR C 168      26.361  42.702   8.388  1.00 39.66           C  
ATOM  11682  O   TYR C 168      27.472  42.202   8.201  1.00 44.47           O  
ATOM  11683  CB  TYR C 168      26.448  44.458   6.631  1.00 36.22           C  
ATOM  11684  CG  TYR C 168      25.917  45.813   6.208  1.00 34.67           C  
ATOM  11685  CD1 TYR C 168      26.418  46.966   6.790  1.00 34.08           C  
ATOM  11686  CD2 TYR C 168      24.925  45.927   5.248  1.00 32.13           C  
ATOM  11687  CE1 TYR C 168      25.965  48.218   6.413  1.00 33.48           C  
ATOM  11688  CE2 TYR C 168      24.460  47.168   4.872  1.00 30.45           C  
ATOM  11689  CZ  TYR C 168      24.975  48.311   5.456  1.00 32.49           C  
ATOM  11690  OH  TYR C 168      24.523  49.553   5.091  1.00 34.24           O  
ATOM  11691  N   MET C 169      25.372  42.070   9.006  1.00 40.51           N  
ATOM  11692  CA  MET C 169      25.531  40.681   9.413  1.00 39.76           C  
ATOM  11693  C   MET C 169      25.286  39.670   8.307  1.00 42.28           C  
ATOM  11694  O   MET C 169      24.810  39.921   7.209  1.00 40.96           O  
ATOM  11695  CB  MET C 169      24.559  40.372  10.560  1.00 38.05           C  
ATOM  11696  CG  MET C 169      24.749  41.255  11.789  1.00 41.48           C  
ATOM  11697  SD  MET C 169      23.148  41.475  12.662  1.00 39.71           S  
ATOM  11698  CE  MET C 169      23.075  39.804  13.340  1.00 35.30           C  
ATOM  11699  N   SER C 170      25.581  38.419   8.681  1.00 44.48           N  
ATOM  11700  CA  SER C 170      25.312  37.281   7.803  1.00 47.52           C  
ATOM  11701  C   SER C 170      23.963  36.689   8.202  1.00 49.81           C  
ATOM  11702  O   SER C 170      23.529  36.787   9.364  1.00 46.98           O  
ATOM  11703  CB  SER C 170      26.456  36.286   7.924  1.00 47.07           C  
ATOM  11704  OG  SER C 170      26.507  35.595   9.158  1.00 46.53           O  
ATOM  11705  N   ASP C 171      23.305  35.986   7.289  1.00 52.10           N  
ATOM  11706  CA  ASP C 171      22.017  35.348   7.526  1.00 56.77           C  
ATOM  11707  C   ASP C 171      22.050  34.452   8.765  1.00 58.24           C  
ATOM  11708  O   ASP C 171      21.089  34.406   9.535  1.00 57.58           O  
ATOM  11709  CB  ASP C 171      21.538  34.569   6.310  1.00 57.44           C  
ATOM  11710  CG  ASP C 171      20.175  33.930   6.387  1.00 63.98           C  
ATOM  11711  OD1 ASP C 171      19.118  34.616   6.334  1.00 64.17           O  
ATOM  11712  OD2 ASP C 171      20.087  32.677   6.480  1.00 66.38           O  
ATOM  11713  N   HIS C 172      23.155  33.761   8.983  1.00 59.35           N  
ATOM  11714  CA  HIS C 172      23.355  32.898  10.117  1.00 61.59           C  
ATOM  11715  C   HIS C 172      23.541  33.636  11.429  1.00 61.42           C  
ATOM  11716  O   HIS C 172      23.132  33.140  12.479  1.00 61.82           O  
ATOM  11717  CB  HIS C 172      24.586  31.986   9.905  1.00 67.84           C  
ATOM  11718  CG  HIS C 172      24.549  30.984  11.025  1.00 73.12           C  
ATOM  11719  ND1 HIS C 172      25.121  31.284  12.249  1.00 73.92           N  
ATOM  11720  CD2 HIS C 172      24.001  29.753  11.107  1.00 73.84           C  
ATOM  11721  CE1 HIS C 172      24.942  30.257  13.061  1.00 74.49           C  
ATOM  11722  NE2 HIS C 172      24.272  29.325  12.391  1.00 77.09           N  
ATOM  11723  N   GLU C 173      24.151  34.813  11.380  1.00 61.20           N  
ATOM  11724  CA  GLU C 173      24.349  35.615  12.579  1.00 60.83           C  
ATOM  11725  C   GLU C 173      22.994  36.129  13.063  1.00 60.72           C  
ATOM  11726  O   GLU C 173      22.648  36.138  14.239  1.00 60.29           O  
ATOM  11727  CB  GLU C 173      25.278  36.775  12.224  1.00 63.87           C  
ATOM  11728  CG  GLU C 173      26.780  36.533  12.249  1.00 64.16           C  
ATOM  11729  CD  GLU C 173      27.515  37.412  11.266  1.00 65.78           C  
ATOM  11730  OE1 GLU C 173      27.004  38.481  10.893  1.00 64.03           O  
ATOM  11731  OE2 GLU C 173      28.600  37.055  10.750  1.00 67.69           O  
ATOM  11732  N   SER C 174      22.149  36.508  12.121  1.00 58.99           N  
ATOM  11733  CA  SER C 174      20.839  37.065  12.324  1.00 58.65           C  
ATOM  11734  C   SER C 174      19.736  36.085  12.696  1.00 58.42           C  
ATOM  11735  O   SER C 174      18.600  36.509  12.928  1.00 55.53           O  
ATOM  11736  CB  SER C 174      20.411  37.732  11.006  1.00 57.42           C  
ATOM  11737  OG  SER C 174      19.909  36.740  10.131  1.00 59.48           O  
ATOM  11738  N   THR C 175      20.038  34.796  12.646  1.00 59.27           N  
ATOM  11739  CA  THR C 175      19.071  33.764  12.951  1.00 58.89           C  
ATOM  11740  C   THR C 175      19.133  33.305  14.399  1.00 58.83           C  
ATOM  11741  O   THR C 175      20.122  32.779  14.892  1.00 57.49           O  
ATOM  11742  CB  THR C 175      19.243  32.563  12.006  1.00 58.03           C  
ATOM  11743  OG1 THR C 175      19.108  33.030  10.657  1.00 58.39           O  
ATOM  11744  CG2 THR C 175      18.205  31.506  12.300  1.00 54.71           C  
ATOM  11745  N   PRO C 176      18.008  33.495  15.084  1.00 58.43           N  
ATOM  11746  CA  PRO C 176      17.881  33.108  16.468  1.00 59.62           C  
ATOM  11747  C   PRO C 176      17.705  31.609  16.635  1.00 59.68           C  
ATOM  11748  O   PRO C 176      17.231  30.887  15.765  1.00 59.80           O  
ATOM  11749  CB  PRO C 176      16.620  33.810  16.972  1.00 59.80           C  
ATOM  11750  CG  PRO C 176      15.870  34.223  15.771  1.00 59.00           C  
ATOM  11751  CD  PRO C 176      16.791  34.158  14.585  1.00 57.70           C  
ATOM  11752  N   LEU C 177      18.094  31.168  17.817  1.00 59.14           N  
ATOM  11753  CA  LEU C 177      17.977  29.791  18.249  1.00 57.32           C  
ATOM  11754  C   LEU C 177      16.515  29.403  18.471  1.00 56.51           C  
ATOM  11755  O   LEU C 177      15.682  30.289  18.655  1.00 56.84           O  
ATOM  11756  CB  LEU C 177      18.688  29.695  19.598  1.00 57.86           C  
ATOM  11757  CG  LEU C 177      20.162  30.098  19.608  1.00 58.40           C  
ATOM  11758  CD1 LEU C 177      20.748  29.702  20.959  1.00 55.43           C  
ATOM  11759  CD2 LEU C 177      20.957  29.461  18.491  1.00 57.52           C  
ATOM  11760  N   GLN C 178      16.263  28.104  18.462  1.00 55.34           N  
ATOM  11761  CA  GLN C 178      14.947  27.522  18.609  1.00 53.26           C  
ATOM  11762  C   GLN C 178      14.908  26.409  19.644  1.00 53.58           C  
ATOM  11763  O   GLN C 178      13.899  25.900  20.116  1.00 54.43           O  
ATOM  11764  CB  GLN C 178      14.484  27.043  17.241  1.00 52.58           C  
ATOM  11765  CG  GLN C 178      13.792  28.142  16.449  1.00 55.28           C  
ATOM  11766  CD  GLN C 178      12.634  28.786  17.201  1.00 55.23           C  
ATOM  11767  OE1 GLN C 178      11.496  28.339  17.138  1.00 57.62           O  
ATOM  11768  NE2 GLN C 178      12.903  29.857  17.918  1.00 49.43           N  
ATOM  11769  N   PHE C 179      16.078  26.157  20.221  1.00 54.07           N  
ATOM  11770  CA  PHE C 179      16.395  25.235  21.279  1.00 52.41           C  
ATOM  11771  C   PHE C 179      16.020  23.783  21.027  1.00 52.37           C  
ATOM  11772  O   PHE C 179      15.715  23.025  21.970  1.00 52.02           O  
ATOM  11773  CB  PHE C 179      15.733  25.700  22.594  1.00 54.56           C  
ATOM  11774  CG  PHE C 179      16.166  27.095  22.947  1.00 56.86           C  
ATOM  11775  CD1 PHE C 179      17.371  27.302  23.595  1.00 55.60           C  
ATOM  11776  CD2 PHE C 179      15.379  28.183  22.610  1.00 58.30           C  
ATOM  11777  CE1 PHE C 179      17.788  28.573  23.913  1.00 56.55           C  
ATOM  11778  CE2 PHE C 179      15.792  29.459  22.927  1.00 59.13           C  
ATOM  11779  CZ  PHE C 179      16.995  29.650  23.577  1.00 58.37           C  
ATOM  11780  N   GLY C 180      16.025  23.342  19.773  1.00 50.53           N  
ATOM  11781  CA  GLY C 180      15.684  21.977  19.476  1.00 48.77           C  
ATOM  11782  C   GLY C 180      14.216  21.693  19.299  1.00 50.68           C  
ATOM  11783  O   GLY C 180      13.956  20.510  18.983  1.00 49.18           O  
ATOM  11784  N   HIS C 181      13.305  22.664  19.407  1.00 50.58           N  
ATOM  11785  CA  HIS C 181      11.895  22.371  19.240  1.00 49.94           C  
ATOM  11786  C   HIS C 181      11.383  22.547  17.819  1.00 52.60           C  
ATOM  11787  O   HIS C 181      11.707  23.548  17.164  1.00 52.75           O  
ATOM  11788  CB  HIS C 181      11.085  23.289  20.165  1.00 46.81           C  
ATOM  11789  CG  HIS C 181      11.658  23.470  21.528  1.00 50.48           C  
ATOM  11790  ND1 HIS C 181      12.439  24.551  21.914  1.00 48.97           N  
ATOM  11791  CD2 HIS C 181      11.539  22.671  22.628  1.00 47.72           C  
ATOM  11792  CE1 HIS C 181      12.759  24.374  23.189  1.00 45.72           C  
ATOM  11793  NE2 HIS C 181      12.238  23.247  23.660  1.00 41.13           N  
ATOM  11794  N   LYS C 182      10.540  21.610  17.383  1.00 53.99           N  
ATOM  11795  CA  LYS C 182       9.980  21.662  16.046  1.00 56.68           C  
ATOM  11796  C   LYS C 182       9.019  22.824  15.839  1.00 56.93           C  
ATOM  11797  O   LYS C 182       9.071  23.530  14.818  1.00 56.84           O  
ATOM  11798  CB  LYS C 182       9.250  20.321  15.817  1.00 58.79           C  
ATOM  11799  CG  LYS C 182       8.182  20.012  16.837  1.00 64.15           C  
ATOM  11800  CD  LYS C 182       7.366  18.773  16.554  1.00 66.08           C  
ATOM  11801  CE  LYS C 182       6.313  19.005  15.485  1.00 69.30           C  
ATOM  11802  NZ  LYS C 182       5.055  18.261  15.780  1.00 71.00           N  
ATOM  11803  N   THR C 183       8.102  22.977  16.800  1.00 57.70           N  
ATOM  11804  CA  THR C 183       7.102  24.021  16.652  1.00 60.10           C  
ATOM  11805  C   THR C 183       7.750  25.407  16.635  1.00 60.18           C  
ATOM  11806  O   THR C 183       8.572  25.706  17.492  1.00 58.18           O  
ATOM  11807  CB  THR C 183       5.990  24.089  17.709  1.00 61.15           C  
ATOM  11808  OG1 THR C 183       5.566  22.806  18.144  1.00 61.83           O  
ATOM  11809  CG2 THR C 183       4.826  24.802  17.017  1.00 61.67           C  
ATOM  11810  N   GLU C 184       7.336  26.184  15.637  1.00 61.63           N  
ATOM  11811  CA  GLU C 184       7.873  27.545  15.547  1.00 64.06           C  
ATOM  11812  C   GLU C 184       7.683  28.142  16.940  1.00 66.35           C  
ATOM  11813  O   GLU C 184       6.591  28.047  17.524  1.00 66.57           O  
ATOM  11814  CB  GLU C 184       7.117  28.389  14.544  1.00 66.63           C  
ATOM  11815  CG  GLU C 184       7.751  29.716  14.144  1.00 69.36           C  
ATOM  11816  CD  GLU C 184       7.214  30.146  12.794  1.00 71.12           C  
ATOM  11817  OE1 GLU C 184       6.350  29.425  12.228  1.00 72.23           O  
ATOM  11818  OE2 GLU C 184       7.642  31.192  12.276  1.00 71.69           O  
ATOM  11819  N   ASN C 185       8.777  28.638  17.504  1.00 66.45           N  
ATOM  11820  CA  ASN C 185       8.627  29.163  18.865  1.00 65.79           C  
ATOM  11821  C   ASN C 185       9.453  30.422  19.022  1.00 66.41           C  
ATOM  11822  O   ASN C 185      10.412  30.691  18.311  1.00 66.66           O  
ATOM  11823  CB  ASN C 185       8.892  28.107  19.903  1.00 66.37           C  
ATOM  11824  CG  ASN C 185      10.319  27.652  20.054  1.00 70.16           C  
ATOM  11825  OD1 ASN C 185      11.151  28.293  20.678  1.00 66.09           O  
ATOM  11826  ND2 ASN C 185      10.630  26.505  19.446  1.00 70.90           N  
ATOM  11827  N   SER C 186       8.921  31.320  19.873  1.00 67.64           N  
ATOM  11828  CA  SER C 186       9.669  32.576  20.018  1.00 67.23           C  
ATOM  11829  C   SER C 186      10.302  32.619  21.383  1.00 65.86           C  
ATOM  11830  O   SER C 186      10.438  33.642  22.042  1.00 68.72           O  
ATOM  11831  CB  SER C 186       9.014  33.869  19.574  1.00 66.53           C  
ATOM  11832  OG  SER C 186       8.624  33.820  18.214  1.00 62.98           O  
ATOM  11833  N   LEU C 187      10.896  31.502  21.781  1.00 63.31           N  
ATOM  11834  CA  LEU C 187      11.688  31.438  23.002  1.00 61.34           C  
ATOM  11835  C   LEU C 187      12.989  32.217  22.788  1.00 62.26           C  
ATOM  11836  O   LEU C 187      13.692  32.481  23.772  1.00 60.74           O  
ATOM  11837  CB  LEU C 187      12.000  30.008  23.409  1.00 61.79           C  
ATOM  11838  CG  LEU C 187      10.909  28.948  23.469  1.00 66.78           C  
ATOM  11839  CD1 LEU C 187      11.462  27.531  23.299  1.00 63.30           C  
ATOM  11840  CD2 LEU C 187      10.167  29.002  24.790  1.00 65.95           C  
ATOM  11841  N   PHE C 188      13.387  32.554  21.555  1.00 60.92           N  
ATOM  11842  CA  PHE C 188      14.545  33.417  21.342  1.00 57.60           C  
ATOM  11843  C   PHE C 188      14.163  34.797  21.887  1.00 56.84           C  
ATOM  11844  O   PHE C 188      14.686  35.403  22.815  1.00 55.42           O  
ATOM  11845  CB  PHE C 188      14.850  33.611  19.877  1.00 52.75           C  
ATOM  11846  CG  PHE C 188      13.793  34.111  18.949  1.00 49.27           C  
ATOM  11847  CD1 PHE C 188      12.775  33.313  18.479  1.00 48.27           C  
ATOM  11848  CD2 PHE C 188      13.865  35.441  18.541  1.00 46.32           C  
ATOM  11849  CE1 PHE C 188      11.845  33.843  17.603  1.00 49.41           C  
ATOM  11850  CE2 PHE C 188      12.927  35.955  17.670  1.00 50.45           C  
ATOM  11851  CZ  PHE C 188      11.927  35.156  17.212  1.00 48.21           C  
ATOM  11852  N   HIS C 189      13.101  35.354  21.323  1.00 58.48           N  
ATOM  11853  CA  HIS C 189      12.510  36.649  21.566  1.00 58.98           C  
ATOM  11854  C   HIS C 189      12.253  36.725  23.064  1.00 61.28           C  
ATOM  11855  O   HIS C 189      12.456  37.719  23.740  1.00 60.79           O  
ATOM  11856  CB  HIS C 189      11.165  36.660  20.861  1.00 56.45           C  
ATOM  11857  CG  HIS C 189      10.655  37.922  20.285  1.00 61.88           C  
ATOM  11858  ND1 HIS C 189      10.233  39.052  20.950  1.00 61.55           N  
ATOM  11859  CD2 HIS C 189      10.456  38.203  18.979  1.00 66.18           C  
ATOM  11860  CE1 HIS C 189       9.809  39.963  20.103  1.00 59.60           C  
ATOM  11861  NE2 HIS C 189       9.934  39.480  18.879  1.00 66.94           N  
ATOM  11862  N   SER C 190      11.700  35.579  23.530  1.00 61.55           N  
ATOM  11863  CA  SER C 190      11.390  35.443  24.933  1.00 58.68           C  
ATOM  11864  C   SER C 190      12.385  36.222  25.765  1.00 57.96           C  
ATOM  11865  O   SER C 190      13.540  36.289  25.424  1.00 58.95           O  
ATOM  11866  CB  SER C 190      11.403  34.008  25.457  1.00 54.79           C  
ATOM  11867  OG  SER C 190      11.495  33.996  26.882  1.00 47.49           O  
ATOM  11868  N   ASN C 191      11.915  36.552  26.955  1.00 60.15           N  
ATOM  11869  CA  ASN C 191      12.637  37.289  27.968  1.00 58.81           C  
ATOM  11870  C   ASN C 191      13.432  36.391  28.875  1.00 60.65           C  
ATOM  11871  O   ASN C 191      13.837  36.797  29.972  1.00 63.70           O  
ATOM  11872  CB  ASN C 191      11.651  38.107  28.798  1.00 62.98           C  
ATOM  11873  CG  ASN C 191      11.167  37.703  30.160  1.00 63.74           C  
ATOM  11874  OD1 ASN C 191      11.284  36.607  30.722  1.00 63.64           O  
ATOM  11875  ND2 ASN C 191      10.544  38.686  30.813  1.00 64.50           N  
ATOM  11876  N   LEU C 192      13.637  35.156  28.459  1.00 60.14           N  
ATOM  11877  CA  LEU C 192      14.478  34.226  29.221  1.00 59.28           C  
ATOM  11878  C   LEU C 192      15.879  34.357  28.604  1.00 58.63           C  
ATOM  11879  O   LEU C 192      16.915  34.181  29.240  1.00 56.65           O  
ATOM  11880  CB  LEU C 192      13.999  32.802  29.019  1.00 60.97           C  
ATOM  11881  CG  LEU C 192      13.151  32.228  30.161  1.00 63.45           C  
ATOM  11882  CD1 LEU C 192      11.816  32.947  30.179  1.00 60.18           C  
ATOM  11883  CD2 LEU C 192      13.003  30.741  29.964  1.00 59.77           C  
ATOM  11884  N   GLN C 193      15.840  34.725  27.308  1.00 59.25           N  
ATOM  11885  CA  GLN C 193      17.096  35.046  26.624  1.00 59.52           C  
ATOM  11886  C   GLN C 193      17.819  36.017  27.546  1.00 57.33           C  
ATOM  11887  O   GLN C 193      17.194  36.683  28.379  1.00 58.25           O  
ATOM  11888  CB  GLN C 193      16.838  35.636  25.232  1.00 61.28           C  
ATOM  11889  CG  GLN C 193      18.111  35.916  24.446  1.00 59.83           C  
ATOM  11890  CD  GLN C 193      17.904  35.744  22.958  1.00 66.84           C  
ATOM  11891  OE1 GLN C 193      16.922  36.148  22.315  1.00 59.23           O  
ATOM  11892  NE2 GLN C 193      18.893  35.199  22.239  1.00 64.53           N  
ATOM  11893  N   THR C 194      19.127  36.089  27.412  1.00 58.54           N  
ATOM  11894  CA  THR C 194      19.924  36.982  28.267  1.00 57.69           C  
ATOM  11895  C   THR C 194      20.563  38.021  27.359  1.00 57.29           C  
ATOM  11896  O   THR C 194      20.886  37.681  26.212  1.00 58.21           O  
ATOM  11897  CB  THR C 194      20.947  36.193  29.066  1.00 62.10           C  
ATOM  11898  OG1 THR C 194      21.355  36.941  30.208  1.00 58.69           O  
ATOM  11899  CG2 THR C 194      22.207  35.930  28.253  1.00 61.63           C  
ATOM  11900  N   GLN C 195      20.772  39.248  27.839  1.00 58.40           N  
ATOM  11901  CA  GLN C 195      21.238  40.294  26.889  1.00 61.18           C  
ATOM  11902  C   GLN C 195      22.605  39.968  26.322  1.00 59.57           C  
ATOM  11903  O   GLN C 195      22.790  39.967  25.100  1.00 62.20           O  
ATOM  11904  CB  GLN C 195      21.101  41.683  27.377  1.00 61.99           C  
ATOM  11905  CG  GLN C 195      22.013  42.717  27.857  1.00 64.87           C  
ATOM  11906  CD  GLN C 195      22.386  42.464  29.307  1.00 68.69           C  
ATOM  11907  OE1 GLN C 195      22.693  41.297  29.552  1.00 68.88           O  
ATOM  11908  NE2 GLN C 195      22.339  43.459  30.178  1.00 64.47           N  
ATOM  11909  N   GLU C 196      23.446  39.397  27.165  1.00 59.41           N  
ATOM  11910  CA  GLU C 196      24.618  38.636  26.739  1.00 62.50           C  
ATOM  11911  C   GLU C 196      24.386  37.723  25.543  1.00 62.15           C  
ATOM  11912  O   GLU C 196      25.080  37.868  24.529  1.00 63.08           O  
ATOM  11913  CB  GLU C 196      24.949  37.756  27.960  1.00 61.44           C  
ATOM  11914  CG  GLU C 196      25.674  38.489  29.068  1.00 59.95           C  
ATOM  11915  CD  GLU C 196      24.842  38.966  30.235  1.00 60.70           C  
ATOM  11916  OE1 GLU C 196      23.846  38.316  30.621  1.00 65.71           O  
ATOM  11917  OE2 GLU C 196      25.155  40.012  30.858  1.00 56.95           O  
ATOM  11918  N   GLU C 197      23.427  36.793  25.638  1.00 62.91           N  
ATOM  11919  CA  GLU C 197      23.139  35.899  24.536  1.00 64.93           C  
ATOM  11920  C   GLU C 197      22.561  36.746  23.399  1.00 63.44           C  
ATOM  11921  O   GLU C 197      22.992  36.528  22.267  1.00 63.33           O  
ATOM  11922  CB  GLU C 197      22.103  34.824  24.774  1.00 68.42           C  
ATOM  11923  CG  GLU C 197      22.394  33.699  25.741  1.00 72.49           C  
ATOM  11924  CD  GLU C 197      21.143  33.435  26.586  1.00 76.41           C  
ATOM  11925  OE1 GLU C 197      20.055  33.845  26.101  1.00 78.13           O  
ATOM  11926  OE2 GLU C 197      21.264  32.918  27.712  1.00 74.66           O  
ATOM  11927  N   GLU C 198      21.706  37.731  23.735  1.00 62.12           N  
ATOM  11928  CA  GLU C 198      21.147  38.478  22.607  1.00 63.45           C  
ATOM  11929  C   GLU C 198      22.326  39.060  21.829  1.00 60.86           C  
ATOM  11930  O   GLU C 198      22.375  38.812  20.628  1.00 62.49           O  
ATOM  11931  CB  GLU C 198      20.071  39.509  22.907  1.00 65.17           C  
ATOM  11932  CG  GLU C 198      18.697  38.952  22.529  1.00 66.34           C  
ATOM  11933  CD  GLU C 198      18.001  39.774  21.477  1.00 71.77           C  
ATOM  11934  OE1 GLU C 198      18.647  40.142  20.489  1.00 72.19           O  
ATOM  11935  OE2 GLU C 198      16.760  39.991  21.577  1.00 75.50           O  
ATOM  11936  N   ASP C 199      23.279  39.683  22.508  1.00 56.87           N  
ATOM  11937  CA  ASP C 199      24.393  40.201  21.696  1.00 58.08           C  
ATOM  11938  C   ASP C 199      25.260  39.064  21.179  1.00 55.81           C  
ATOM  11939  O   ASP C 199      25.341  38.879  19.949  1.00 59.72           O  
ATOM  11940  CB  ASP C 199      25.127  41.308  22.445  1.00 59.36           C  
ATOM  11941  CG  ASP C 199      24.276  42.575  22.548  1.00 58.36           C  
ATOM  11942  OD1 ASP C 199      23.978  43.215  21.515  1.00 52.96           O  
ATOM  11943  OD2 ASP C 199      23.893  42.902  23.690  1.00 58.61           O  
ATOM  11944  N   ALA C 200      25.696  38.131  22.015  1.00 53.09           N  
ATOM  11945  CA  ALA C 200      26.485  36.990  21.583  1.00 53.45           C  
ATOM  11946  C   ALA C 200      25.890  36.197  20.435  1.00 52.71           C  
ATOM  11947  O   ALA C 200      26.690  35.826  19.558  1.00 55.21           O  
ATOM  11948  CB  ALA C 200      26.858  36.090  22.741  1.00 47.77           C  
ATOM  11949  N   ASN C 201      24.589  35.960  20.311  1.00 52.75           N  
ATOM  11950  CA  ASN C 201      24.096  35.208  19.172  1.00 52.84           C  
ATOM  11951  C   ASN C 201      24.149  35.958  17.861  1.00 50.94           C  
ATOM  11952  O   ASN C 201      23.903  35.244  16.873  1.00 53.19           O  
ATOM  11953  CB  ASN C 201      22.646  34.774  19.384  1.00 54.41           C  
ATOM  11954  CG  ASN C 201      22.464  34.160  20.755  1.00 58.37           C  
ATOM  11955  OD1 ASN C 201      23.396  33.628  21.363  1.00 59.64           O  
ATOM  11956  ND2 ASN C 201      21.257  34.336  21.299  1.00 58.26           N  
ATOM  11957  N   TYR C 202      24.289  37.284  17.797  1.00 50.20           N  
ATOM  11958  CA  TYR C 202      24.229  37.941  16.481  1.00 50.65           C  
ATOM  11959  C   TYR C 202      25.596  38.500  16.096  1.00 51.82           C  
ATOM  11960  O   TYR C 202      25.903  39.211  15.142  1.00 49.43           O  
ATOM  11961  CB  TYR C 202      23.173  39.041  16.486  1.00 48.53           C  
ATOM  11962  CG  TYR C 202      21.786  38.507  16.768  1.00 47.90           C  
ATOM  11963  CD1 TYR C 202      21.434  38.239  18.070  1.00 46.08           C  
ATOM  11964  CD2 TYR C 202      20.867  38.227  15.777  1.00 48.51           C  
ATOM  11965  CE1 TYR C 202      20.197  37.738  18.431  1.00 48.21           C  
ATOM  11966  CE2 TYR C 202      19.626  37.702  16.090  1.00 48.97           C  
ATOM  11967  CZ  TYR C 202      19.295  37.472  17.413  1.00 49.58           C  
ATOM  11968  OH  TYR C 202      18.060  36.968  17.740  1.00 50.64           O  
ATOM  11969  N   ARG C 203      26.528  38.094  16.957  1.00 52.31           N  
ATOM  11970  CA  ARG C 203      27.897  38.450  16.784  1.00 53.55           C  
ATOM  11971  C   ARG C 203      28.656  37.905  15.595  1.00 53.43           C  
ATOM  11972  O   ARG C 203      28.520  36.765  15.178  1.00 51.60           O  
ATOM  11973  CB  ARG C 203      28.716  38.230  18.053  1.00 55.94           C  
ATOM  11974  CG  ARG C 203      29.396  39.569  18.327  1.00 65.06           C  
ATOM  11975  CD  ARG C 203      28.606  40.816  17.904  1.00 68.62           C  
ATOM  11976  NE  ARG C 203      28.873  41.219  16.512  1.00 74.52           N  
ATOM  11977  CZ  ARG C 203      30.097  41.620  16.179  1.00 78.45           C  
ATOM  11978  NH1 ARG C 203      31.055  41.685  17.098  1.00 78.15           N  
ATOM  11979  NH2 ARG C 203      30.497  41.989  14.978  1.00 79.42           N  
ATOM  11980  N   LEU C 204      29.440  38.830  15.027  1.00 53.44           N  
ATOM  11981  CA  LEU C 204      30.317  38.472  13.936  1.00 52.73           C  
ATOM  11982  C   LEU C 204      31.206  37.349  14.487  1.00 53.47           C  
ATOM  11983  O   LEU C 204      31.984  37.524  15.435  1.00 51.23           O  
ATOM  11984  CB  LEU C 204      31.291  39.554  13.496  1.00 52.43           C  
ATOM  11985  CG  LEU C 204      32.143  39.301  12.250  1.00 52.73           C  
ATOM  11986  CD1 LEU C 204      31.312  38.788  11.092  1.00 48.75           C  
ATOM  11987  CD2 LEU C 204      32.821  40.616  11.868  1.00 50.08           C  
ATOM  11988  N   PRO C 205      31.014  36.185  13.907  1.00 54.35           N  
ATOM  11989  CA  PRO C 205      31.809  35.043  14.295  1.00 56.57           C  
ATOM  11990  C   PRO C 205      33.252  35.315  13.884  1.00 61.18           C  
ATOM  11991  O   PRO C 205      33.646  36.122  13.063  1.00 60.77           O  
ATOM  11992  CB  PRO C 205      31.254  33.901  13.473  1.00 54.87           C  
ATOM  11993  CG  PRO C 205      30.019  34.370  12.804  1.00 54.56           C  
ATOM  11994  CD  PRO C 205      30.116  35.865  12.788  1.00 55.23           C  
ATOM  11995  N   GLU C 206      34.113  34.556  14.483  1.00 64.24           N  
ATOM  11996  CA  GLU C 206      35.501  34.241  14.315  1.00 69.46           C  
ATOM  11997  C   GLU C 206      36.198  34.224  12.969  1.00 70.87           C  
ATOM  11998  O   GLU C 206      37.288  34.744  12.707  1.00 70.53           O  
ATOM  11999  CB  GLU C 206      35.497  32.710  14.671  1.00 70.91           C  
ATOM  12000  CG  GLU C 206      34.469  31.970  13.810  1.00 76.88           C  
ATOM  12001  CD  GLU C 206      33.641  30.977  14.565  1.00 79.60           C  
ATOM  12002  OE1 GLU C 206      32.752  31.413  15.327  1.00 81.40           O  
ATOM  12003  OE2 GLU C 206      33.937  29.787  14.335  1.00 81.16           O  
ATOM  12004  N   GLY C 207      35.558  33.606  11.983  1.00 71.84           N  
ATOM  12005  CA  GLY C 207      35.924  33.420  10.594  1.00 71.14           C  
ATOM  12006  C   GLY C 207      35.156  34.528   9.859  1.00 71.72           C  
ATOM  12007  O   GLY C 207      34.440  34.484   8.879  1.00 73.46           O  
ATOM  12008  N   LYS C 208      35.246  35.676  10.444  1.00 68.66           N  
ATOM  12009  CA  LYS C 208      34.873  36.996  10.483  1.00 67.17           C  
ATOM  12010  C   LYS C 208      35.290  38.068   9.522  1.00 66.10           C  
ATOM  12011  O   LYS C 208      36.228  38.833   9.756  1.00 64.47           O  
ATOM  12012  CB  LYS C 208      35.666  37.485  11.774  1.00 70.07           C  
ATOM  12013  CG  LYS C 208      35.412  38.864  12.287  1.00 70.79           C  
ATOM  12014  CD  LYS C 208      35.827  39.136  13.708  1.00 72.34           C  
ATOM  12015  CE  LYS C 208      34.596  39.296  14.605  1.00 73.75           C  
ATOM  12016  NZ  LYS C 208      34.732  38.406  15.797  1.00 73.11           N  
ATOM  12017  N   GLU C 209      34.590  38.185   8.422  1.00 65.67           N  
ATOM  12018  CA  GLU C 209      34.889  39.297   7.528  1.00 63.20           C  
ATOM  12019  C   GLU C 209      33.586  40.049   7.800  1.00 59.60           C  
ATOM  12020  O   GLU C 209      32.576  39.432   7.417  1.00 59.11           O  
ATOM  12021  CB  GLU C 209      34.932  38.850   6.076  1.00 69.27           C  
ATOM  12022  CG  GLU C 209      35.110  37.343   5.901  1.00 71.47           C  
ATOM  12023  CD  GLU C 209      35.982  37.040   4.690  1.00 74.31           C  
ATOM  12024  OE1 GLU C 209      37.230  37.044   4.794  1.00 76.15           O  
ATOM  12025  OE2 GLU C 209      35.361  36.814   3.625  1.00 73.18           O  
ATOM  12026  N   ALA C 210      33.627  41.179   8.492  1.00 55.35           N  
ATOM  12027  CA  ALA C 210      32.309  41.865   8.550  1.00 52.60           C  
ATOM  12028  C   ALA C 210      32.075  42.066   7.052  1.00 49.81           C  
ATOM  12029  O   ALA C 210      33.098  42.342   6.398  1.00 49.96           O  
ATOM  12030  CB  ALA C 210      32.480  43.193   9.234  1.00 50.95           C  
ATOM  12031  N   GLY C 211      30.918  41.851   6.489  1.00 45.30           N  
ATOM  12032  CA  GLY C 211      30.734  42.158   5.074  1.00 43.91           C  
ATOM  12033  C   GLY C 211      30.858  43.657   4.861  1.00 44.30           C  
ATOM  12034  O   GLY C 211      31.406  44.121   3.854  1.00 45.57           O  
ATOM  12035  N   GLU C 212      30.298  44.448   5.781  1.00 43.15           N  
ATOM  12036  CA  GLU C 212      30.401  45.896   5.662  1.00 41.28           C  
ATOM  12037  C   GLU C 212      30.231  46.536   7.020  1.00 40.58           C  
ATOM  12038  O   GLU C 212      29.510  46.032   7.854  1.00 40.65           O  
ATOM  12039  CB  GLU C 212      29.425  46.441   4.635  1.00 40.30           C  
ATOM  12040  CG  GLU C 212      29.176  47.936   4.747  1.00 40.20           C  
ATOM  12041  CD  GLU C 212      28.227  48.404   3.679  1.00 39.61           C  
ATOM  12042  OE1 GLU C 212      27.541  47.560   3.073  1.00 42.40           O  
ATOM  12043  OE2 GLU C 212      28.159  49.604   3.426  1.00 42.89           O  
ATOM  12044  N   ILE C 213      30.991  47.580   7.286  1.00 40.79           N  
ATOM  12045  CA  ILE C 213      30.906  48.306   8.557  1.00 39.89           C  
ATOM  12046  C   ILE C 213      30.653  49.751   8.141  1.00 36.72           C  
ATOM  12047  O   ILE C 213      31.462  50.282   7.389  1.00 37.57           O  
ATOM  12048  CB  ILE C 213      32.086  48.100   9.485  1.00 42.44           C  
ATOM  12049  CG1 ILE C 213      32.042  46.679  10.097  1.00 43.15           C  
ATOM  12050  CG2 ILE C 213      32.167  49.090  10.636  1.00 39.41           C  
ATOM  12051  CD1 ILE C 213      33.415  46.270  10.610  1.00 46.18           C  
ATOM  12052  N   GLU C 214      29.442  50.226   8.448  1.00 34.25           N  
ATOM  12053  CA  GLU C 214      29.053  51.556   7.991  1.00 35.61           C  
ATOM  12054  C   GLU C 214      29.086  52.575   9.119  1.00 36.11           C  
ATOM  12055  O   GLU C 214      28.586  52.299  10.208  1.00 39.03           O  
ATOM  12056  CB  GLU C 214      27.649  51.558   7.368  1.00 36.98           C  
ATOM  12057  CG  GLU C 214      27.160  52.884   6.797  1.00 34.51           C  
ATOM  12058  CD  GLU C 214      25.757  52.801   6.239  1.00 35.43           C  
ATOM  12059  OE1 GLU C 214      25.081  51.785   6.509  1.00 35.09           O  
ATOM  12060  OE2 GLU C 214      25.264  53.678   5.509  1.00 28.89           O  
ATOM  12061  N   THR C 215      29.624  53.739   8.850  1.00 35.84           N  
ATOM  12062  CA  THR C 215      29.711  54.831   9.801  1.00 33.95           C  
ATOM  12063  C   THR C 215      28.580  55.795   9.454  1.00 35.81           C  
ATOM  12064  O   THR C 215      28.587  56.348   8.354  1.00 32.17           O  
ATOM  12065  CB  THR C 215      31.091  55.500   9.808  1.00 35.53           C  
ATOM  12066  OG1 THR C 215      32.014  54.575  10.431  1.00 35.05           O  
ATOM  12067  CG2 THR C 215      31.119  56.808  10.602  1.00 33.87           C  
ATOM  12068  N   VAL C 216      27.554  55.788  10.328  1.00 35.32           N  
ATOM  12069  CA  VAL C 216      26.370  56.600   9.987  1.00 35.02           C  
ATOM  12070  C   VAL C 216      26.276  57.806  10.931  1.00 34.94           C  
ATOM  12071  O   VAL C 216      26.130  57.681  12.149  1.00 32.85           O  
ATOM  12072  CB  VAL C 216      25.046  55.817  10.017  1.00 35.45           C  
ATOM  12073  CG1 VAL C 216      23.858  56.662   9.561  1.00 25.69           C  
ATOM  12074  CG2 VAL C 216      25.160  54.542   9.169  1.00 33.90           C  
ATOM  12075  N   HIS C 217      26.428  58.964  10.301  1.00 33.44           N  
ATOM  12076  CA  HIS C 217      26.302  60.222  11.031  1.00 33.16           C  
ATOM  12077  C   HIS C 217      24.819  60.570  11.177  1.00 35.99           C  
ATOM  12078  O   HIS C 217      24.203  60.718  10.106  1.00 35.70           O  
ATOM  12079  CB  HIS C 217      26.995  61.340  10.244  1.00 32.78           C  
ATOM  12080  CG  HIS C 217      28.484  61.146  10.238  1.00 38.54           C  
ATOM  12081  ND1 HIS C 217      29.212  61.003  11.406  1.00 40.78           N  
ATOM  12082  CD2 HIS C 217      29.353  60.961   9.213  1.00 36.43           C  
ATOM  12083  CE1 HIS C 217      30.462  60.772  11.101  1.00 36.99           C  
ATOM  12084  NE2 HIS C 217      30.574  60.723   9.762  1.00 39.01           N  
ATOM  12085  N   CYS C 218      24.285  60.596  12.386  1.00 34.07           N  
ATOM  12086  CA  CYS C 218      22.839  60.832  12.505  1.00 37.04           C  
ATOM  12087  C   CYS C 218      22.494  62.111  13.269  1.00 36.42           C  
ATOM  12088  O   CYS C 218      23.125  62.411  14.276  1.00 37.24           O  
ATOM  12089  CB  CYS C 218      22.128  59.686  13.241  1.00 30.61           C  
ATOM  12090  SG  CYS C 218      22.702  58.030  12.777  1.00 33.50           S  
ATOM  12091  N   LYS C 219      21.427  62.781  12.829  1.00 35.25           N  
ATOM  12092  CA  LYS C 219      20.912  63.897  13.615  1.00 35.00           C  
ATOM  12093  C   LYS C 219      20.242  63.337  14.864  1.00 33.12           C  
ATOM  12094  O   LYS C 219      20.399  63.919  15.915  1.00 33.37           O  
ATOM  12095  CB  LYS C 219      19.920  64.776  12.865  1.00 32.65           C  
ATOM  12096  CG  LYS C 219      20.519  65.455  11.675  1.00 34.60           C  
ATOM  12097  CD  LYS C 219      19.737  66.653  11.188  1.00 35.45           C  
ATOM  12098  CE  LYS C 219      20.742  67.568  10.477  1.00 38.86           C  
ATOM  12099  NZ  LYS C 219      20.032  68.354   9.435  1.00 42.45           N  
ATOM  12100  N   TYR C 220      19.462  62.265  14.763  1.00 33.77           N  
ATOM  12101  CA  TYR C 220      18.735  61.650  15.867  1.00 32.92           C  
ATOM  12102  C   TYR C 220      18.763  60.136  15.806  1.00 34.95           C  
ATOM  12103  O   TYR C 220      18.886  59.568  14.710  1.00 37.51           O  
ATOM  12104  CB  TYR C 220      17.234  62.019  15.787  1.00 32.59           C  
ATOM  12105  CG  TYR C 220      17.044  63.506  16.017  1.00 30.51           C  
ATOM  12106  CD1 TYR C 220      17.064  63.981  17.315  1.00 27.20           C  
ATOM  12107  CD2 TYR C 220      16.962  64.398  14.969  1.00 31.22           C  
ATOM  12108  CE1 TYR C 220      16.962  65.320  17.547  1.00 29.19           C  
ATOM  12109  CE2 TYR C 220      16.865  65.770  15.206  1.00 32.46           C  
ATOM  12110  CZ  TYR C 220      16.845  66.211  16.509  1.00 31.83           C  
ATOM  12111  OH  TYR C 220      16.732  67.551  16.777  1.00 33.65           O  
ATOM  12112  N   VAL C 221      18.692  59.441  16.912  1.00 32.87           N  
ATOM  12113  CA  VAL C 221      18.688  57.998  16.982  1.00 32.94           C  
ATOM  12114  C   VAL C 221      17.574  57.565  17.939  1.00 34.51           C  
ATOM  12115  O   VAL C 221      17.400  58.175  18.988  1.00 33.55           O  
ATOM  12116  CB  VAL C 221      20.017  57.364  17.450  1.00 37.37           C  
ATOM  12117  CG1 VAL C 221      19.875  55.843  17.566  1.00 31.86           C  
ATOM  12118  CG2 VAL C 221      21.158  57.691  16.509  1.00 30.83           C  
ATOM  12119  N   ILE C 222      16.764  56.590  17.520  1.00 33.18           N  
ATOM  12120  CA  ILE C 222      15.705  56.086  18.386  1.00 32.17           C  
ATOM  12121  C   ILE C 222      15.957  54.599  18.638  1.00 30.57           C  
ATOM  12122  O   ILE C 222      16.013  53.790  17.714  1.00 32.07           O  
ATOM  12123  CB  ILE C 222      14.259  56.311  17.923  1.00 35.23           C  
ATOM  12124  CG1 ILE C 222      13.910  57.753  17.573  1.00 33.24           C  
ATOM  12125  CG2 ILE C 222      13.317  55.862  19.031  1.00 31.21           C  
ATOM  12126  CD1 ILE C 222      12.708  57.872  16.652  1.00 32.76           C  
ATOM  12127  N   GLY C 223      16.207  54.232  19.888  1.00 31.99           N  
ATOM  12128  CA  GLY C 223      16.515  52.854  20.270  1.00 31.17           C  
ATOM  12129  C   GLY C 223      15.224  52.122  20.631  1.00 33.64           C  
ATOM  12130  O   GLY C 223      14.587  52.356  21.668  1.00 32.06           O  
ATOM  12131  N   CYS C 224      14.774  51.257  19.739  1.00 33.41           N  
ATOM  12132  CA  CYS C 224      13.555  50.488  19.876  1.00 33.31           C  
ATOM  12133  C   CYS C 224      13.968  49.018  19.798  1.00 35.39           C  
ATOM  12134  O   CYS C 224      13.354  48.189  19.147  1.00 35.28           O  
ATOM  12135  CB  CYS C 224      12.575  50.828  18.762  1.00 30.04           C  
ATOM  12136  SG  CYS C 224      12.247  52.597  18.475  1.00 31.83           S  
ATOM  12137  N   ASP C 225      15.085  48.762  20.491  1.00 35.36           N  
ATOM  12138  CA  ASP C 225      15.769  47.473  20.433  1.00 33.67           C  
ATOM  12139  C   ASP C 225      15.499  46.520  21.574  1.00 34.39           C  
ATOM  12140  O   ASP C 225      16.176  45.518  21.749  1.00 31.57           O  
ATOM  12141  CB  ASP C 225      17.246  47.749  20.217  1.00 35.54           C  
ATOM  12142  CG  ASP C 225      17.972  48.680  21.159  1.00 36.62           C  
ATOM  12143  OD1 ASP C 225      17.377  49.635  21.708  1.00 37.82           O  
ATOM  12144  OD2 ASP C 225      19.194  48.503  21.412  1.00 37.25           O  
ATOM  12145  N   GLY C 226      14.355  46.653  22.235  1.00 33.69           N  
ATOM  12146  CA  GLY C 226      13.835  45.672  23.150  1.00 33.05           C  
ATOM  12147  C   GLY C 226      14.392  45.650  24.547  1.00 35.16           C  
ATOM  12148  O   GLY C 226      15.195  46.463  24.988  1.00 33.40           O  
ATOM  12149  N   GLY C 227      13.917  44.662  25.307  1.00 37.42           N  
ATOM  12150  CA  GLY C 227      14.184  44.404  26.688  1.00 38.57           C  
ATOM  12151  C   GLY C 227      15.609  44.546  27.180  1.00 41.05           C  
ATOM  12152  O   GLY C 227      15.870  45.072  28.269  1.00 40.66           O  
ATOM  12153  N   HIS C 228      16.525  44.055  26.363  1.00 40.48           N  
ATOM  12154  CA  HIS C 228      17.947  44.054  26.615  1.00 40.71           C  
ATOM  12155  C   HIS C 228      18.653  45.157  25.837  1.00 40.53           C  
ATOM  12156  O   HIS C 228      19.875  45.145  25.720  1.00 39.25           O  
ATOM  12157  CB  HIS C 228      18.487  42.695  26.120  1.00 40.12           C  
ATOM  12158  CG  HIS C 228      18.119  41.563  27.034  1.00 42.57           C  
ATOM  12159  ND1 HIS C 228      18.133  41.696  28.408  1.00 47.20           N  
ATOM  12160  CD2 HIS C 228      17.784  40.278  26.791  1.00 44.88           C  
ATOM  12161  CE1 HIS C 228      17.778  40.555  28.964  1.00 45.18           C  
ATOM  12162  NE2 HIS C 228      17.560  39.661  28.000  1.00 46.09           N  
ATOM  12163  N   SER C 229      17.895  46.151  25.403  1.00 40.52           N  
ATOM  12164  CA  SER C 229      18.364  47.230  24.564  1.00 37.28           C  
ATOM  12165  C   SER C 229      19.848  47.550  24.686  1.00 38.47           C  
ATOM  12166  O   SER C 229      20.321  48.013  25.724  1.00 41.97           O  
ATOM  12167  CB  SER C 229      17.586  48.506  24.821  1.00 31.58           C  
ATOM  12168  OG  SER C 229      18.168  49.608  24.150  1.00 32.87           O  
ATOM  12169  N   TRP C 230      20.528  47.477  23.552  1.00 38.26           N  
ATOM  12170  CA  TRP C 230      21.932  47.805  23.443  1.00 37.75           C  
ATOM  12171  C   TRP C 230      22.095  49.318  23.464  1.00 38.71           C  
ATOM  12172  O   TRP C 230      23.071  49.837  23.984  1.00 37.75           O  
ATOM  12173  CB  TRP C 230      22.462  47.239  22.113  1.00 35.31           C  
ATOM  12174  CG  TRP C 230      23.879  47.626  21.817  1.00 37.82           C  
ATOM  12175  CD1 TRP C 230      24.986  46.867  22.111  1.00 34.36           C  
ATOM  12176  CD2 TRP C 230      24.347  48.818  21.203  1.00 32.38           C  
ATOM  12177  NE1 TRP C 230      26.116  47.517  21.691  1.00 35.65           N  
ATOM  12178  CE2 TRP C 230      25.767  48.722  21.131  1.00 34.23           C  
ATOM  12179  CE3 TRP C 230      23.724  49.960  20.681  1.00 31.72           C  
ATOM  12180  CZ2 TRP C 230      26.572  49.711  20.567  1.00 26.98           C  
ATOM  12181  CZ3 TRP C 230      24.519  50.959  20.134  1.00 33.19           C  
ATOM  12182  CH2 TRP C 230      25.937  50.812  20.085  1.00 34.51           C  
ATOM  12183  N   VAL C 231      21.130  50.035  22.884  1.00 37.85           N  
ATOM  12184  CA  VAL C 231      21.139  51.485  22.893  1.00 38.27           C  
ATOM  12185  C   VAL C 231      21.068  51.971  24.336  1.00 40.10           C  
ATOM  12186  O   VAL C 231      21.804  52.886  24.670  1.00 41.62           O  
ATOM  12187  CB  VAL C 231      20.046  52.152  22.049  1.00 34.97           C  
ATOM  12188  CG1 VAL C 231      19.983  53.658  22.261  1.00 30.31           C  
ATOM  12189  CG2 VAL C 231      20.342  51.914  20.557  1.00 31.65           C  
ATOM  12190  N   ARG C 232      20.250  51.368  25.177  1.00 40.92           N  
ATOM  12191  CA  ARG C 232      20.081  51.756  26.571  1.00 41.87           C  
ATOM  12192  C   ARG C 232      21.321  51.418  27.397  1.00 42.19           C  
ATOM  12193  O   ARG C 232      21.781  52.215  28.216  1.00 40.11           O  
ATOM  12194  CB  ARG C 232      18.864  51.035  27.212  1.00 40.19           C  
ATOM  12195  CG  ARG C 232      18.750  51.222  28.715  1.00 35.00           C  
ATOM  12196  CD  ARG C 232      17.705  50.319  29.374  1.00 38.64           C  
ATOM  12197  NE  ARG C 232      18.212  48.952  29.493  1.00 35.84           N  
ATOM  12198  CZ  ARG C 232      17.652  47.829  29.057  1.00 39.77           C  
ATOM  12199  NH1 ARG C 232      16.480  47.770  28.418  1.00 34.36           N  
ATOM  12200  NH2 ARG C 232      18.336  46.696  29.276  1.00 35.56           N  
ATOM  12201  N   ARG C 233      21.830  50.197  27.205  1.00 41.52           N  
ATOM  12202  CA  ARG C 233      23.021  49.808  27.957  1.00 41.82           C  
ATOM  12203  C   ARG C 233      24.215  50.693  27.612  1.00 43.67           C  
ATOM  12204  O   ARG C 233      24.990  51.002  28.524  1.00 46.45           O  
ATOM  12205  CB  ARG C 233      23.287  48.325  27.777  1.00 38.15           C  
ATOM  12206  CG  ARG C 233      22.511  47.450  28.731  1.00 39.40           C  
ATOM  12207  CD  ARG C 233      22.616  45.973  28.429  1.00 40.54           C  
ATOM  12208  NE  ARG C 233      22.256  45.640  27.065  1.00 42.09           N  
ATOM  12209  CZ  ARG C 233      23.009  45.069  26.138  1.00 46.96           C  
ATOM  12210  NH1 ARG C 233      24.227  44.658  26.473  1.00 45.71           N  
ATOM  12211  NH2 ARG C 233      22.562  44.803  24.912  1.00 44.73           N  
ATOM  12212  N   THR C 234      24.396  51.156  26.388  1.00 42.68           N  
ATOM  12213  CA  THR C 234      25.462  52.017  25.931  1.00 41.16           C  
ATOM  12214  C   THR C 234      25.254  53.457  26.382  1.00 43.43           C  
ATOM  12215  O   THR C 234      26.212  54.251  26.517  1.00 45.56           O  
ATOM  12216  CB  THR C 234      25.527  52.047  24.384  1.00 41.46           C  
ATOM  12217  OG1 THR C 234      25.547  50.708  23.883  1.00 41.50           O  
ATOM  12218  CG2 THR C 234      26.716  52.846  23.851  1.00 34.04           C  
ATOM  12219  N   LEU C 235      24.011  53.861  26.688  1.00 42.79           N  
ATOM  12220  CA  LEU C 235      23.872  55.239  27.186  1.00 43.05           C  
ATOM  12221  C   LEU C 235      24.105  55.233  28.696  1.00 41.98           C  
ATOM  12222  O   LEU C 235      24.207  56.320  29.247  1.00 42.34           O  
ATOM  12223  CB  LEU C 235      22.589  55.953  26.869  1.00 42.54           C  
ATOM  12224  CG  LEU C 235      22.176  56.081  25.401  1.00 43.04           C  
ATOM  12225  CD1 LEU C 235      20.657  56.124  25.326  1.00 36.83           C  
ATOM  12226  CD2 LEU C 235      22.899  57.290  24.843  1.00 38.52           C  
ATOM  12227  N   GLY C 236      24.191  54.052  29.287  1.00 42.02           N  
ATOM  12228  CA  GLY C 236      24.396  53.942  30.718  1.00 45.16           C  
ATOM  12229  C   GLY C 236      23.092  54.166  31.483  1.00 47.35           C  
ATOM  12230  O   GLY C 236      23.140  54.713  32.591  1.00 47.61           O  
ATOM  12231  N   PHE C 237      21.928  53.862  30.912  1.00 47.42           N  
ATOM  12232  CA  PHE C 237      20.684  54.150  31.618  1.00 47.45           C  
ATOM  12233  C   PHE C 237      20.311  52.935  32.444  1.00 49.43           C  
ATOM  12234  O   PHE C 237      19.937  51.899  31.909  1.00 51.47           O  
ATOM  12235  CB  PHE C 237      19.536  54.588  30.720  1.00 43.50           C  
ATOM  12236  CG  PHE C 237      19.728  55.909  30.031  1.00 41.76           C  
ATOM  12237  CD1 PHE C 237      20.692  56.825  30.426  1.00 41.65           C  
ATOM  12238  CD2 PHE C 237      18.934  56.242  28.952  1.00 39.00           C  
ATOM  12239  CE1 PHE C 237      20.855  58.024  29.768  1.00 37.40           C  
ATOM  12240  CE2 PHE C 237      19.082  57.433  28.291  1.00 36.93           C  
ATOM  12241  CZ  PHE C 237      20.039  58.322  28.699  1.00 37.03           C  
ATOM  12242  N   GLU C 238      20.452  53.082  33.742  1.00 51.91           N  
ATOM  12243  CA  GLU C 238      20.146  51.995  34.664  1.00 55.68           C  
ATOM  12244  C   GLU C 238      18.694  51.601  34.468  1.00 55.11           C  
ATOM  12245  O   GLU C 238      17.899  52.328  33.906  1.00 54.24           O  
ATOM  12246  CB  GLU C 238      20.434  52.453  36.087  1.00 59.66           C  
ATOM  12247  CG  GLU C 238      19.830  51.657  37.219  1.00 66.79           C  
ATOM  12248  CD  GLU C 238      19.318  52.524  38.354  1.00 72.44           C  
ATOM  12249  OE1 GLU C 238      18.488  53.429  38.084  1.00 71.83           O  
ATOM  12250  OE2 GLU C 238      19.755  52.309  39.507  1.00 71.81           O  
ATOM  12251  N   MET C 239      18.338  50.437  34.953  1.00 55.94           N  
ATOM  12252  CA  MET C 239      16.971  49.946  34.898  1.00 56.54           C  
ATOM  12253  C   MET C 239      16.597  49.319  36.237  1.00 56.51           C  
ATOM  12254  O   MET C 239      17.172  48.263  36.534  1.00 56.78           O  
ATOM  12255  CB  MET C 239      16.950  48.872  33.817  1.00 57.64           C  
ATOM  12256  CG  MET C 239      15.522  48.595  33.361  1.00 53.99           C  
ATOM  12257  SD  MET C 239      15.625  48.129  31.633  1.00 54.70           S  
ATOM  12258  CE  MET C 239      13.893  48.246  31.200  1.00 52.27           C  
ATOM  12259  N   ILE C 240      15.794  49.987  37.049  1.00 55.56           N  
ATOM  12260  CA  ILE C 240      15.424  49.446  38.352  1.00 55.12           C  
ATOM  12261  C   ILE C 240      14.331  48.391  38.227  1.00 54.70           C  
ATOM  12262  O   ILE C 240      13.409  48.505  37.424  1.00 52.82           O  
ATOM  12263  CB  ILE C 240      14.972  50.551  39.327  1.00 55.20           C  
ATOM  12264  CG1 ILE C 240      16.152  51.469  39.662  1.00 55.34           C  
ATOM  12265  CG2 ILE C 240      14.423  49.989  40.618  1.00 52.08           C  
ATOM  12266  CD1 ILE C 240      15.762  52.782  40.302  1.00 56.99           C  
ATOM  12267  N   GLY C 241      14.438  47.365  39.054  1.00 55.74           N  
ATOM  12268  CA  GLY C 241      13.505  46.254  39.134  1.00 57.22           C  
ATOM  12269  C   GLY C 241      14.246  44.941  39.334  1.00 59.31           C  
ATOM  12270  O   GLY C 241      15.450  44.871  39.089  1.00 60.55           O  
ATOM  12271  N   GLU C 242      13.567  43.900  39.765  1.00 62.05           N  
ATOM  12272  CA  GLU C 242      14.147  42.579  39.991  1.00 64.19           C  
ATOM  12273  C   GLU C 242      13.150  41.502  39.570  1.00 64.74           C  
ATOM  12274  O   GLU C 242      11.943  41.583  39.760  1.00 64.74           O  
ATOM  12275  CB  GLU C 242      14.545  42.410  41.448  1.00 67.27           C  
ATOM  12276  CG  GLU C 242      15.988  42.226  41.812  1.00 74.29           C  
ATOM  12277  CD  GLU C 242      16.997  43.162  41.190  1.00 78.08           C  
ATOM  12278  OE1 GLU C 242      17.194  44.282  41.704  1.00 79.23           O  
ATOM  12279  OE2 GLU C 242      17.626  42.788  40.170  1.00 78.31           O  
ATOM  12280  N   GLN C 243      13.654  40.463  38.940  1.00 64.64           N  
ATOM  12281  CA  GLN C 243      12.930  39.333  38.392  1.00 64.93           C  
ATOM  12282  C   GLN C 243      12.618  38.268  39.428  1.00 64.18           C  
ATOM  12283  O   GLN C 243      13.571  37.782  40.040  1.00 65.21           O  
ATOM  12284  CB  GLN C 243      13.836  38.717  37.321  1.00 64.92           C  
ATOM  12285  CG  GLN C 243      13.339  37.505  36.563  1.00 68.89           C  
ATOM  12286  CD  GLN C 243      14.018  37.389  35.206  1.00 70.44           C  
ATOM  12287  OE1 GLN C 243      15.177  36.983  35.127  1.00 70.55           O  
ATOM  12288  NE2 GLN C 243      13.336  37.804  34.150  1.00 68.43           N  
ATOM  12289  N   THR C 244      11.366  37.885  39.600  1.00 61.22           N  
ATOM  12290  CA  THR C 244      10.997  36.792  40.495  1.00 59.66           C  
ATOM  12291  C   THR C 244      11.473  35.454  39.931  1.00 59.00           C  
ATOM  12292  O   THR C 244      12.279  35.391  38.993  1.00 58.13           O  
ATOM  12293  CB  THR C 244       9.465  36.766  40.710  1.00 59.88           C  
ATOM  12294  OG1 THR C 244       8.764  36.365  39.523  1.00 57.32           O  
ATOM  12295  CG2 THR C 244       8.955  38.154  41.078  1.00 58.72           C  
ATOM  12296  N   ASP C 245      10.986  34.330  40.467  1.00 59.91           N  
ATOM  12297  CA  ASP C 245      11.260  33.025  39.864  1.00 57.98           C  
ATOM  12298  C   ASP C 245       9.933  32.322  39.549  1.00 55.91           C  
ATOM  12299  O   ASP C 245       9.860  31.133  39.214  1.00 55.94           O  
ATOM  12300  CB  ASP C 245      12.236  32.110  40.570  1.00 61.73           C  
ATOM  12301  CG  ASP C 245      12.655  32.554  41.948  1.00 66.26           C  
ATOM  12302  OD1 ASP C 245      13.584  33.385  42.019  1.00 66.95           O  
ATOM  12303  OD2 ASP C 245      12.054  32.074  42.939  1.00 67.29           O  
ATOM  12304  N   TYR C 246       8.865  33.119  39.608  1.00 52.51           N  
ATOM  12305  CA  TYR C 246       7.566  32.638  39.146  1.00 51.01           C  
ATOM  12306  C   TYR C 246       7.839  32.463  37.631  1.00 50.02           C  
ATOM  12307  O   TYR C 246       8.464  33.345  37.055  1.00 47.84           O  
ATOM  12308  CB  TYR C 246       6.430  33.609  39.274  1.00 50.29           C  
ATOM  12309  CG  TYR C 246       5.788  33.850  40.613  1.00 49.67           C  
ATOM  12310  CD1 TYR C 246       5.157  32.844  41.333  1.00 48.66           C  
ATOM  12311  CD2 TYR C 246       5.803  35.137  41.162  1.00 49.00           C  
ATOM  12312  CE1 TYR C 246       4.544  33.101  42.542  1.00 46.73           C  
ATOM  12313  CE2 TYR C 246       5.191  35.399  42.367  1.00 49.53           C  
ATOM  12314  CZ  TYR C 246       4.567  34.374  43.049  1.00 50.56           C  
ATOM  12315  OH  TYR C 246       3.959  34.673  44.259  1.00 53.32           O  
ATOM  12316  N   ILE C 247       7.492  31.332  37.056  1.00 49.65           N  
ATOM  12317  CA  ILE C 247       7.734  31.112  35.634  1.00 49.98           C  
ATOM  12318  C   ILE C 247       6.445  30.607  35.017  1.00 49.21           C  
ATOM  12319  O   ILE C 247       5.675  29.841  35.595  1.00 49.37           O  
ATOM  12320  CB  ILE C 247       8.932  30.192  35.361  1.00 54.98           C  
ATOM  12321  CG1 ILE C 247       8.805  29.423  34.036  1.00 55.07           C  
ATOM  12322  CG2 ILE C 247       9.163  29.188  36.478  1.00 57.88           C  
ATOM  12323  CD1 ILE C 247       9.751  29.967  32.984  1.00 60.68           C  
ATOM  12324  N   TRP C 248       6.152  31.136  33.832  1.00 49.00           N  
ATOM  12325  CA  TRP C 248       4.922  30.834  33.115  1.00 44.80           C  
ATOM  12326  C   TRP C 248       5.271  30.370  31.711  1.00 45.21           C  
ATOM  12327  O   TRP C 248       6.352  30.652  31.203  1.00 43.28           O  
ATOM  12328  CB  TRP C 248       4.027  32.056  32.992  1.00 40.91           C  
ATOM  12329  CG  TRP C 248       3.372  32.586  34.227  1.00 44.53           C  
ATOM  12330  CD1 TRP C 248       3.929  33.064  35.375  1.00 46.74           C  
ATOM  12331  CD2 TRP C 248       1.948  32.711  34.414  1.00 44.32           C  
ATOM  12332  NE1 TRP C 248       2.957  33.474  36.270  1.00 45.46           N  
ATOM  12333  CE2 TRP C 248       1.732  33.270  35.686  1.00 46.34           C  
ATOM  12334  CE3 TRP C 248       0.848  32.412  33.613  1.00 42.48           C  
ATOM  12335  CZ2 TRP C 248       0.458  33.533  36.172  1.00 47.48           C  
ATOM  12336  CZ3 TRP C 248      -0.408  32.688  34.095  1.00 44.76           C  
ATOM  12337  CH2 TRP C 248      -0.595  33.229  35.368  1.00 45.39           C  
ATOM  12338  N   GLY C 249       4.315  29.676  31.114  1.00 44.17           N  
ATOM  12339  CA  GLY C 249       4.526  29.184  29.750  1.00 44.06           C  
ATOM  12340  C   GLY C 249       3.343  29.681  28.916  1.00 45.97           C  
ATOM  12341  O   GLY C 249       2.333  30.102  29.489  1.00 43.42           O  
ATOM  12342  N   VAL C 250       3.580  29.806  27.617  1.00 43.92           N  
ATOM  12343  CA  VAL C 250       2.573  30.316  26.715  1.00 42.91           C  
ATOM  12344  C   VAL C 250       2.339  29.314  25.579  1.00 41.76           C  
ATOM  12345  O   VAL C 250       3.312  28.915  24.984  1.00 41.09           O  
ATOM  12346  CB  VAL C 250       2.946  31.662  26.059  1.00 41.29           C  
ATOM  12347  CG1 VAL C 250       1.757  32.218  25.289  1.00 39.49           C  
ATOM  12348  CG2 VAL C 250       3.380  32.692  27.081  1.00 41.87           C  
ATOM  12349  N   LEU C 251       1.094  28.987  25.295  1.00 41.17           N  
ATOM  12350  CA  LEU C 251       0.740  28.130  24.185  1.00 42.06           C  
ATOM  12351  C   LEU C 251      -0.222  28.848  23.235  1.00 40.81           C  
ATOM  12352  O   LEU C 251      -1.279  29.221  23.733  1.00 43.07           O  
ATOM  12353  CB  LEU C 251      -0.002  26.864  24.627  1.00 39.86           C  
ATOM  12354  CG  LEU C 251       0.708  25.912  25.593  1.00 43.62           C  
ATOM  12355  CD1 LEU C 251      -0.291  24.951  26.206  1.00 40.95           C  
ATOM  12356  CD2 LEU C 251       1.837  25.181  24.884  1.00 42.54           C  
ATOM  12357  N   ASP C 252       0.064  28.930  21.943  1.00 40.27           N  
ATOM  12358  CA  ASP C 252      -0.945  29.437  20.998  1.00 38.97           C  
ATOM  12359  C   ASP C 252      -1.465  28.194  20.300  1.00 37.97           C  
ATOM  12360  O   ASP C 252      -0.708  27.601  19.541  1.00 40.04           O  
ATOM  12361  CB  ASP C 252      -0.419  30.450  19.996  1.00 39.32           C  
ATOM  12362  CG  ASP C 252      -0.182  31.816  20.620  1.00 44.51           C  
ATOM  12363  OD1 ASP C 252      -0.348  32.009  21.842  1.00 42.44           O  
ATOM  12364  OD2 ASP C 252       0.202  32.723  19.864  1.00 42.09           O  
ATOM  12365  N   ALA C 253      -2.678  27.777  20.611  1.00 38.92           N  
ATOM  12366  CA  ALA C 253      -3.184  26.509  20.070  1.00 35.98           C  
ATOM  12367  C   ALA C 253      -4.672  26.480  19.775  1.00 37.59           C  
ATOM  12368  O   ALA C 253      -5.445  27.316  20.253  1.00 36.04           O  
ATOM  12369  CB  ALA C 253      -3.011  25.473  21.189  1.00 33.34           C  
ATOM  12370  N   VAL C 254      -5.052  25.466  18.995  1.00 37.36           N  
ATOM  12371  CA  VAL C 254      -6.463  25.184  18.739  1.00 36.40           C  
ATOM  12372  C   VAL C 254      -6.786  24.127  19.805  1.00 37.76           C  
ATOM  12373  O   VAL C 254      -6.252  23.026  19.768  1.00 36.10           O  
ATOM  12374  CB  VAL C 254      -6.806  24.644  17.363  1.00 39.36           C  
ATOM  12375  CG1 VAL C 254      -8.309  24.374  17.204  1.00 35.38           C  
ATOM  12376  CG2 VAL C 254      -6.372  25.604  16.261  1.00 36.35           C  
ATOM  12377  N   PRO C 255      -7.507  24.528  20.844  1.00 37.93           N  
ATOM  12378  CA  PRO C 255      -7.786  23.664  21.963  1.00 37.29           C  
ATOM  12379  C   PRO C 255      -8.858  22.633  21.677  1.00 39.10           C  
ATOM  12380  O   PRO C 255      -9.629  22.720  20.724  1.00 38.65           O  
ATOM  12381  CB  PRO C 255      -8.286  24.655  23.024  1.00 38.91           C  
ATOM  12382  CG  PRO C 255      -8.990  25.699  22.228  1.00 38.08           C  
ATOM  12383  CD  PRO C 255      -8.175  25.848  20.959  1.00 36.26           C  
ATOM  12384  N   ALA C 256      -8.932  21.645  22.554  1.00 39.29           N  
ATOM  12385  CA  ALA C 256      -9.904  20.557  22.520  1.00 39.22           C  
ATOM  12386  C   ALA C 256     -10.215  20.309  24.007  1.00 40.28           C  
ATOM  12387  O   ALA C 256      -9.459  19.676  24.757  1.00 41.15           O  
ATOM  12388  CB  ALA C 256      -9.312  19.307  21.894  1.00 35.41           C  
ATOM  12389  N   SER C 257     -11.174  21.053  24.516  1.00 40.27           N  
ATOM  12390  CA  SER C 257     -11.439  21.080  25.942  1.00 40.48           C  
ATOM  12391  C   SER C 257     -12.935  21.119  26.184  1.00 41.51           C  
ATOM  12392  O   SER C 257     -13.604  21.761  25.365  1.00 43.72           O  
ATOM  12393  CB  SER C 257     -10.861  22.359  26.558  1.00 39.46           C  
ATOM  12394  OG  SER C 257     -11.317  22.508  27.896  1.00 42.18           O  
ATOM  12395  N   ASN C 258     -13.352  20.668  27.348  1.00 42.14           N  
ATOM  12396  CA  ASN C 258     -14.743  20.818  27.762  1.00 42.43           C  
ATOM  12397  C   ASN C 258     -14.895  22.005  28.700  1.00 41.49           C  
ATOM  12398  O   ASN C 258     -15.978  22.296  29.224  1.00 42.93           O  
ATOM  12399  CB  ASN C 258     -15.253  19.508  28.338  1.00 46.26           C  
ATOM  12400  CG  ASN C 258     -14.737  19.170  29.710  1.00 50.78           C  
ATOM  12401  OD1 ASN C 258     -13.750  19.693  30.242  1.00 48.54           O  
ATOM  12402  ND2 ASN C 258     -15.457  18.231  30.328  1.00 51.84           N  
ATOM  12403  N   PHE C 259     -13.830  22.754  28.940  1.00 40.47           N  
ATOM  12404  CA  PHE C 259     -13.915  23.976  29.752  1.00 39.06           C  
ATOM  12405  C   PHE C 259     -14.973  24.868  29.128  1.00 39.97           C  
ATOM  12406  O   PHE C 259     -14.879  25.276  27.964  1.00 40.20           O  
ATOM  12407  CB  PHE C 259     -12.556  24.674  29.805  1.00 39.13           C  
ATOM  12408  CG  PHE C 259     -12.451  25.733  30.868  1.00 36.92           C  
ATOM  12409  CD1 PHE C 259     -12.440  25.392  32.222  1.00 35.95           C  
ATOM  12410  CD2 PHE C 259     -12.390  27.069  30.519  1.00 34.61           C  
ATOM  12411  CE1 PHE C 259     -12.351  26.376  33.170  1.00 39.08           C  
ATOM  12412  CE2 PHE C 259     -12.323  28.053  31.477  1.00 34.41           C  
ATOM  12413  CZ  PHE C 259     -12.293  27.718  32.812  1.00 37.13           C  
ATOM  12414  N   PRO C 260     -16.023  25.201  29.885  1.00 39.67           N  
ATOM  12415  CA  PRO C 260     -17.127  25.983  29.379  1.00 37.23           C  
ATOM  12416  C   PRO C 260     -16.752  27.352  28.854  1.00 38.58           C  
ATOM  12417  O   PRO C 260     -17.446  27.833  27.933  1.00 36.95           O  
ATOM  12418  CB  PRO C 260     -18.100  26.098  30.555  1.00 37.18           C  
ATOM  12419  CG  PRO C 260     -17.651  25.104  31.543  1.00 37.09           C  
ATOM  12420  CD  PRO C 260     -16.179  24.868  31.327  1.00 37.95           C  
ATOM  12421  N   ASP C 261     -15.720  27.995  29.419  1.00 36.50           N  
ATOM  12422  CA  ASP C 261     -15.373  29.347  28.950  1.00 36.00           C  
ATOM  12423  C   ASP C 261     -14.049  29.388  28.210  1.00 37.14           C  
ATOM  12424  O   ASP C 261     -13.252  30.324  28.252  1.00 35.42           O  
ATOM  12425  CB  ASP C 261     -15.376  30.307  30.130  1.00 32.98           C  
ATOM  12426  CG  ASP C 261     -16.778  30.698  30.568  1.00 39.06           C  
ATOM  12427  OD1 ASP C 261     -17.436  31.497  29.865  1.00 39.67           O  
ATOM  12428  OD2 ASP C 261     -17.179  30.297  31.685  1.00 39.46           O  
ATOM  12429  N   ILE C 262     -13.794  28.383  27.383  1.00 37.06           N  
ATOM  12430  CA  ILE C 262     -12.562  28.213  26.630  1.00 36.10           C  
ATOM  12431  C   ILE C 262     -12.420  29.298  25.579  1.00 36.87           C  
ATOM  12432  O   ILE C 262     -11.313  29.638  25.183  1.00 36.84           O  
ATOM  12433  CB  ILE C 262     -12.483  26.804  26.029  1.00 35.81           C  
ATOM  12434  CG1 ILE C 262     -11.069  26.398  25.633  1.00 37.24           C  
ATOM  12435  CG2 ILE C 262     -13.376  26.643  24.801  1.00 32.00           C  
ATOM  12436  CD1 ILE C 262     -10.198  25.944  26.769  1.00 33.58           C  
ATOM  12437  N   ARG C 263     -13.502  29.908  25.128  1.00 36.24           N  
ATOM  12438  CA  ARG C 263     -13.484  30.936  24.110  1.00 35.66           C  
ATOM  12439  C   ARG C 263     -13.633  32.341  24.673  1.00 34.80           C  
ATOM  12440  O   ARG C 263     -13.774  33.300  23.902  1.00 33.12           O  
ATOM  12441  CB  ARG C 263     -14.639  30.752  23.117  1.00 33.76           C  
ATOM  12442  CG  ARG C 263     -14.489  29.613  22.153  1.00 39.14           C  
ATOM  12443  CD  ARG C 263     -13.372  29.741  21.139  1.00 35.38           C  
ATOM  12444  NE  ARG C 263     -13.252  31.066  20.550  1.00 36.38           N  
ATOM  12445  CZ  ARG C 263     -12.131  31.519  20.010  1.00 35.30           C  
ATOM  12446  NH1 ARG C 263     -11.025  30.767  19.926  1.00 33.57           N  
ATOM  12447  NH2 ARG C 263     -12.106  32.752  19.527  1.00 30.11           N  
ATOM  12448  N   SER C 264     -13.567  32.467  25.987  1.00 33.57           N  
ATOM  12449  CA  SER C 264     -13.696  33.734  26.684  1.00 31.41           C  
ATOM  12450  C   SER C 264     -12.370  34.084  27.316  1.00 32.22           C  
ATOM  12451  O   SER C 264     -11.580  33.164  27.536  1.00 32.93           O  
ATOM  12452  CB  SER C 264     -14.658  33.533  27.875  1.00 34.66           C  
ATOM  12453  OG  SER C 264     -14.827  34.697  28.686  1.00 29.84           O  
ATOM  12454  N   ARG C 265     -12.155  35.355  27.649  1.00 33.14           N  
ATOM  12455  CA  ARG C 265     -10.891  35.636  28.356  1.00 33.34           C  
ATOM  12456  C   ARG C 265     -11.194  35.050  29.747  1.00 35.89           C  
ATOM  12457  O   ARG C 265     -12.371  35.053  30.131  1.00 32.39           O  
ATOM  12458  CB  ARG C 265     -10.524  37.103  28.418  1.00 31.66           C  
ATOM  12459  CG  ARG C 265      -9.275  37.394  29.234  1.00 34.79           C  
ATOM  12460  CD  ARG C 265      -8.723  38.787  28.930  1.00 36.17           C  
ATOM  12461  NE  ARG C 265      -7.502  39.108  29.673  1.00 30.14           N  
ATOM  12462  CZ  ARG C 265      -7.199  40.354  30.020  1.00 30.66           C  
ATOM  12463  NH1 ARG C 265      -7.966  41.413  29.739  1.00 30.96           N  
ATOM  12464  NH2 ARG C 265      -6.078  40.573  30.691  1.00 28.88           N  
ATOM  12465  N   CYS C 266     -10.228  34.427  30.394  1.00 35.13           N  
ATOM  12466  CA  CYS C 266     -10.471  33.884  31.706  1.00 37.50           C  
ATOM  12467  C   CYS C 266      -9.226  34.040  32.590  1.00 38.26           C  
ATOM  12468  O   CYS C 266      -8.116  34.043  32.070  1.00 36.90           O  
ATOM  12469  CB  CYS C 266     -10.763  32.391  31.791  1.00 35.30           C  
ATOM  12470  SG  CYS C 266     -11.984  31.717  30.691  1.00 37.12           S  
ATOM  12471  N   ALA C 267      -9.533  34.072  33.873  1.00 36.44           N  
ATOM  12472  CA  ALA C 267      -8.487  33.986  34.889  1.00 39.11           C  
ATOM  12473  C   ALA C 267      -8.809  32.719  35.692  1.00 40.28           C  
ATOM  12474  O   ALA C 267      -9.962  32.515  36.131  1.00 40.92           O  
ATOM  12475  CB  ALA C 267      -8.416  35.226  35.750  1.00 38.06           C  
ATOM  12476  N   ILE C 268      -7.867  31.802  35.771  1.00 41.24           N  
ATOM  12477  CA  ILE C 268      -8.077  30.577  36.525  1.00 43.09           C  
ATOM  12478  C   ILE C 268      -7.033  30.474  37.635  1.00 44.62           C  
ATOM  12479  O   ILE C 268      -5.851  30.459  37.320  1.00 45.01           O  
ATOM  12480  CB  ILE C 268      -8.002  29.305  35.663  1.00 43.15           C  
ATOM  12481  CG1 ILE C 268      -8.930  29.364  34.459  1.00 43.81           C  
ATOM  12482  CG2 ILE C 268      -8.309  28.074  36.503  1.00 43.45           C  
ATOM  12483  CD1 ILE C 268      -8.709  28.328  33.393  1.00 39.74           C  
ATOM  12484  N   HIS C 269      -7.484  30.480  38.889  1.00 46.55           N  
ATOM  12485  CA  HIS C 269      -6.612  30.258  40.039  1.00 45.24           C  
ATOM  12486  C   HIS C 269      -6.896  28.833  40.536  1.00 46.73           C  
ATOM  12487  O   HIS C 269      -8.032  28.582  40.947  1.00 45.86           O  
ATOM  12488  CB  HIS C 269      -6.917  31.215  41.189  1.00 42.16           C  
ATOM  12489  CG  HIS C 269      -6.215  32.538  41.109  1.00 44.25           C  
ATOM  12490  ND1 HIS C 269      -6.784  33.631  40.504  1.00 39.32           N  
ATOM  12491  CD2 HIS C 269      -4.980  32.917  41.552  1.00 43.07           C  
ATOM  12492  CE1 HIS C 269      -5.940  34.640  40.579  1.00 43.70           C  
ATOM  12493  NE2 HIS C 269      -4.842  34.238  41.197  1.00 41.49           N  
ATOM  12494  N   SER C 270      -5.961  27.903  40.363  1.00 46.76           N  
ATOM  12495  CA  SER C 270      -6.201  26.541  40.844  1.00 45.93           C  
ATOM  12496  C   SER C 270      -5.792  26.474  42.309  1.00 47.79           C  
ATOM  12497  O   SER C 270      -5.035  27.318  42.774  1.00 46.83           O  
ATOM  12498  CB  SER C 270      -5.454  25.520  40.000  1.00 43.97           C  
ATOM  12499  OG  SER C 270      -4.109  25.353  40.420  1.00 42.91           O  
ATOM  12500  N   ALA C 271      -6.252  25.497  43.066  1.00 49.90           N  
ATOM  12501  CA  ALA C 271      -5.949  25.367  44.480  1.00 49.92           C  
ATOM  12502  C   ALA C 271      -4.466  25.300  44.767  1.00 52.30           C  
ATOM  12503  O   ALA C 271      -4.023  25.950  45.703  1.00 50.97           O  
ATOM  12504  CB  ALA C 271      -6.626  24.129  45.049  1.00 46.64           C  
ATOM  12505  N   GLU C 272      -3.697  24.460  44.061  1.00 54.18           N  
ATOM  12506  CA  GLU C 272      -2.279  24.359  44.353  1.00 55.80           C  
ATOM  12507  C   GLU C 272      -1.387  24.258  43.123  1.00 55.90           C  
ATOM  12508  O   GLU C 272      -0.184  24.141  43.370  1.00 57.66           O  
ATOM  12509  CB  GLU C 272      -1.902  23.152  45.215  1.00 60.74           C  
ATOM  12510  CG  GLU C 272      -2.953  22.269  45.824  1.00 64.17           C  
ATOM  12511  CD  GLU C 272      -3.410  22.762  47.184  1.00 69.46           C  
ATOM  12512  OE1 GLU C 272      -2.763  23.656  47.753  1.00 69.93           O  
ATOM  12513  OE2 GLU C 272      -4.440  22.251  47.686  1.00 74.11           O  
ATOM  12514  N   SER C 273      -1.907  24.225  41.911  1.00 53.74           N  
ATOM  12515  CA  SER C 273      -1.034  24.032  40.751  1.00 51.83           C  
ATOM  12516  C   SER C 273      -0.630  25.287  39.992  1.00 49.92           C  
ATOM  12517  O   SER C 273       0.072  25.183  38.983  1.00 51.02           O  
ATOM  12518  CB  SER C 273      -1.733  23.055  39.794  1.00 51.67           C  
ATOM  12519  OG  SER C 273      -2.255  21.964  40.540  1.00 57.80           O  
ATOM  12520  N   GLY C 274      -1.119  26.461  40.367  1.00 46.34           N  
ATOM  12521  CA  GLY C 274      -0.803  27.699  39.677  1.00 45.51           C  
ATOM  12522  C   GLY C 274      -2.033  28.266  38.973  1.00 46.18           C  
ATOM  12523  O   GLY C 274      -3.140  27.742  39.102  1.00 44.65           O  
ATOM  12524  N   SER C 275      -1.823  29.339  38.226  1.00 44.77           N  
ATOM  12525  CA  SER C 275      -2.874  29.992  37.480  1.00 44.30           C  
ATOM  12526  C   SER C 275      -2.757  29.809  35.970  1.00 45.04           C  
ATOM  12527  O   SER C 275      -1.681  29.607  35.419  1.00 44.76           O  
ATOM  12528  CB  SER C 275      -2.771  31.503  37.745  1.00 45.08           C  
ATOM  12529  OG  SER C 275      -3.241  31.820  39.038  1.00 46.80           O  
ATOM  12530  N   ILE C 276      -3.856  30.077  35.276  1.00 43.60           N  
ATOM  12531  CA  ILE C 276      -3.932  30.135  33.835  1.00 42.61           C  
ATOM  12532  C   ILE C 276      -4.656  31.431  33.447  1.00 42.96           C  
ATOM  12533  O   ILE C 276      -5.586  31.885  34.119  1.00 43.25           O  
ATOM  12534  CB  ILE C 276      -4.696  28.940  33.239  1.00 39.75           C  
ATOM  12535  CG1 ILE C 276      -3.698  27.818  32.909  1.00 42.92           C  
ATOM  12536  CG2 ILE C 276      -5.485  29.304  31.989  1.00 37.10           C  
ATOM  12537  CD1 ILE C 276      -4.313  26.494  32.460  1.00 35.91           C  
ATOM  12538  N   MET C 277      -4.228  32.014  32.328  1.00 41.62           N  
ATOM  12539  CA  MET C 277      -4.978  33.090  31.713  1.00 39.47           C  
ATOM  12540  C   MET C 277      -5.280  32.647  30.276  1.00 39.18           C  
ATOM  12541  O   MET C 277      -4.369  32.369  29.508  1.00 40.30           O  
ATOM  12542  CB  MET C 277      -4.301  34.446  31.664  1.00 40.56           C  
ATOM  12543  CG  MET C 277      -5.253  35.574  31.208  1.00 40.76           C  
ATOM  12544  SD  MET C 277      -4.335  37.136  31.095  1.00 46.45           S  
ATOM  12545  CE  MET C 277      -5.382  38.145  32.125  1.00 54.63           C  
ATOM  12546  N   ILE C 278      -6.546  32.617  29.945  1.00 37.02           N  
ATOM  12547  CA  ILE C 278      -6.981  32.283  28.612  1.00 36.55           C  
ATOM  12548  C   ILE C 278      -7.211  33.553  27.799  1.00 36.41           C  
ATOM  12549  O   ILE C 278      -7.965  34.414  28.217  1.00 35.15           O  
ATOM  12550  CB  ILE C 278      -8.286  31.462  28.662  1.00 36.05           C  
ATOM  12551  CG1 ILE C 278      -8.084  30.233  29.552  1.00 32.19           C  
ATOM  12552  CG2 ILE C 278      -8.695  31.137  27.232  1.00 31.87           C  
ATOM  12553  CD1 ILE C 278      -9.162  29.169  29.462  1.00 33.69           C  
ATOM  12554  N   ILE C 279      -6.612  33.628  26.609  1.00 36.61           N  
ATOM  12555  CA  ILE C 279      -6.769  34.762  25.691  1.00 34.54           C  
ATOM  12556  C   ILE C 279      -7.289  34.249  24.371  1.00 35.47           C  
ATOM  12557  O   ILE C 279      -6.541  33.743  23.519  1.00 37.20           O  
ATOM  12558  CB  ILE C 279      -5.394  35.437  25.517  1.00 33.60           C  
ATOM  12559  CG1 ILE C 279      -4.929  36.090  26.815  1.00 31.35           C  
ATOM  12560  CG2 ILE C 279      -5.392  36.479  24.408  1.00 28.80           C  
ATOM  12561  CD1 ILE C 279      -5.902  37.117  27.382  1.00 29.28           C  
ATOM  12562  N   PRO C 280      -8.592  34.255  24.169  1.00 36.64           N  
ATOM  12563  CA  PRO C 280      -9.177  33.703  22.949  1.00 35.20           C  
ATOM  12564  C   PRO C 280      -8.841  34.553  21.742  1.00 34.53           C  
ATOM  12565  O   PRO C 280      -9.122  35.757  21.704  1.00 34.22           O  
ATOM  12566  CB  PRO C 280     -10.647  33.667  23.277  1.00 35.36           C  
ATOM  12567  CG  PRO C 280     -10.841  34.869  24.151  1.00 33.19           C  
ATOM  12568  CD  PRO C 280      -9.624  34.833  25.051  1.00 35.97           C  
ATOM  12569  N   ARG C 281      -8.347  33.911  20.704  1.00 34.62           N  
ATOM  12570  CA  ARG C 281      -7.815  34.552  19.513  1.00 34.96           C  
ATOM  12571  C   ARG C 281      -8.640  34.308  18.260  1.00 36.31           C  
ATOM  12572  O   ARG C 281      -9.767  33.778  18.278  1.00 33.33           O  
ATOM  12573  CB  ARG C 281      -6.361  34.057  19.325  1.00 32.00           C  
ATOM  12574  CG  ARG C 281      -5.387  34.634  20.363  1.00 31.64           C  
ATOM  12575  CD  ARG C 281      -4.752  35.960  19.870  1.00 31.95           C  
ATOM  12576  NE  ARG C 281      -4.088  35.686  18.574  1.00 31.79           N  
ATOM  12577  CZ  ARG C 281      -2.892  35.091  18.617  1.00 36.09           C  
ATOM  12578  NH1 ARG C 281      -2.283  34.875  19.771  1.00 34.09           N  
ATOM  12579  NH2 ARG C 281      -2.290  34.730  17.489  1.00 36.78           N  
ATOM  12580  N   GLU C 282      -8.145  34.852  17.149  1.00 34.05           N  
ATOM  12581  CA  GLU C 282      -8.759  34.749  15.846  1.00 36.47           C  
ATOM  12582  C   GLU C 282      -8.638  33.321  15.304  1.00 36.09           C  
ATOM  12583  O   GLU C 282      -7.818  32.499  15.761  1.00 32.59           O  
ATOM  12584  CB  GLU C 282      -8.045  35.703  14.858  1.00 36.53           C  
ATOM  12585  CG  GLU C 282      -6.630  35.319  14.478  1.00 37.78           C  
ATOM  12586  CD  GLU C 282      -5.559  35.556  15.502  1.00 40.02           C  
ATOM  12587  OE1 GLU C 282      -5.783  36.056  16.630  1.00 38.49           O  
ATOM  12588  OE2 GLU C 282      -4.368  35.241  15.217  1.00 44.33           O  
ATOM  12589  N   ASN C 283      -9.400  33.031  14.277  1.00 39.37           N  
ATOM  12590  CA  ASN C 283      -9.357  31.752  13.565  1.00 41.47           C  
ATOM  12591  C   ASN C 283      -9.244  30.483  14.393  1.00 42.43           C  
ATOM  12592  O   ASN C 283      -8.386  29.606  14.153  1.00 44.35           O  
ATOM  12593  CB  ASN C 283      -8.159  31.755  12.621  1.00 44.22           C  
ATOM  12594  CG  ASN C 283      -8.119  32.799  11.552  1.00 49.55           C  
ATOM  12595  OD1 ASN C 283      -7.286  32.670  10.642  1.00 63.76           O  
ATOM  12596  ND2 ASN C 283      -8.898  33.850  11.533  1.00 57.06           N  
ATOM  12597  N   ASN C 284     -10.057  30.305  15.417  1.00 39.17           N  
ATOM  12598  CA  ASN C 284     -10.099  29.160  16.287  1.00 41.02           C  
ATOM  12599  C   ASN C 284      -8.904  28.993  17.201  1.00 40.84           C  
ATOM  12600  O   ASN C 284      -8.924  28.011  17.968  1.00 40.63           O  
ATOM  12601  CB  ASN C 284     -10.350  27.842  15.534  1.00 44.14           C  
ATOM  12602  CG  ASN C 284     -11.592  27.941  14.665  1.00 48.18           C  
ATOM  12603  OD1 ASN C 284     -12.636  28.285  15.178  1.00 45.76           O  
ATOM  12604  ND2 ASN C 284     -11.446  27.748  13.355  1.00 51.75           N  
ATOM  12605  N   LEU C 285      -7.907  29.877  17.160  1.00 37.99           N  
ATOM  12606  CA  LEU C 285      -6.810  29.731  18.112  1.00 36.89           C  
ATOM  12607  C   LEU C 285      -7.277  30.270  19.464  1.00 35.47           C  
ATOM  12608  O   LEU C 285      -8.232  31.051  19.608  1.00 33.27           O  
ATOM  12609  CB  LEU C 285      -5.565  30.517  17.716  1.00 37.34           C  
ATOM  12610  CG  LEU C 285      -4.798  29.960  16.516  1.00 45.92           C  
ATOM  12611  CD1 LEU C 285      -4.111  31.094  15.769  1.00 42.20           C  
ATOM  12612  CD2 LEU C 285      -3.832  28.876  16.989  1.00 39.08           C  
ATOM  12613  N   VAL C 286      -6.562  29.844  20.480  1.00 34.43           N  
ATOM  12614  CA  VAL C 286      -6.707  30.333  21.844  1.00 35.63           C  
ATOM  12615  C   VAL C 286      -5.283  30.404  22.419  1.00 36.16           C  
ATOM  12616  O   VAL C 286      -4.473  29.492  22.209  1.00 35.77           O  
ATOM  12617  CB  VAL C 286      -7.595  29.475  22.745  1.00 33.54           C  
ATOM  12618  CG1 VAL C 286      -7.636  30.014  24.178  1.00 30.60           C  
ATOM  12619  CG2 VAL C 286      -9.032  29.441  22.247  1.00 27.86           C  
ATOM  12620  N   ARG C 287      -5.007  31.525  23.091  1.00 34.14           N  
ATOM  12621  CA  ARG C 287      -3.691  31.662  23.699  1.00 34.32           C  
ATOM  12622  C   ARG C 287      -3.820  31.302  25.181  1.00 36.20           C  
ATOM  12623  O   ARG C 287      -4.756  31.788  25.831  1.00 36.16           O  
ATOM  12624  CB  ARG C 287      -3.107  33.070  23.581  1.00 33.75           C  
ATOM  12625  CG  ARG C 287      -1.925  33.255  24.527  1.00 34.03           C  
ATOM  12626  CD  ARG C 287      -1.123  34.489  24.200  1.00 34.06           C  
ATOM  12627  NE  ARG C 287      -0.292  34.345  23.011  1.00 35.76           N  
ATOM  12628  CZ  ARG C 287       0.513  35.325  22.577  1.00 33.76           C  
ATOM  12629  NH1 ARG C 287       0.570  36.507  23.188  1.00 33.30           N  
ATOM  12630  NH2 ARG C 287       1.213  35.144  21.493  1.00 29.71           N  
ATOM  12631  N   PHE C 288      -2.927  30.467  25.670  1.00 35.34           N  
ATOM  12632  CA  PHE C 288      -2.948  30.064  27.060  1.00 37.05           C  
ATOM  12633  C   PHE C 288      -1.687  30.475  27.799  1.00 37.10           C  
ATOM  12634  O   PHE C 288      -0.569  30.046  27.457  1.00 36.65           O  
ATOM  12635  CB  PHE C 288      -3.091  28.530  27.199  1.00 37.43           C  
ATOM  12636  CG  PHE C 288      -4.368  27.999  26.612  1.00 36.77           C  
ATOM  12637  CD1 PHE C 288      -5.500  27.928  27.399  1.00 34.63           C  
ATOM  12638  CD2 PHE C 288      -4.452  27.616  25.282  1.00 37.67           C  
ATOM  12639  CE1 PHE C 288      -6.690  27.459  26.897  1.00 36.59           C  
ATOM  12640  CE2 PHE C 288      -5.657  27.155  24.765  1.00 38.02           C  
ATOM  12641  CZ  PHE C 288      -6.758  27.059  25.586  1.00 38.74           C  
ATOM  12642  N   TYR C 289      -1.849  31.304  28.816  1.00 37.75           N  
ATOM  12643  CA  TYR C 289      -0.699  31.694  29.636  1.00 38.55           C  
ATOM  12644  C   TYR C 289      -0.819  30.745  30.827  1.00 38.98           C  
ATOM  12645  O   TYR C 289      -1.869  30.785  31.450  1.00 40.81           O  
ATOM  12646  CB  TYR C 289      -0.703  33.129  30.119  1.00 34.91           C  
ATOM  12647  CG  TYR C 289      -0.468  34.175  29.055  1.00 34.67           C  
ATOM  12648  CD1 TYR C 289      -1.515  34.581  28.241  1.00 32.49           C  
ATOM  12649  CD2 TYR C 289       0.761  34.775  28.868  1.00 35.94           C  
ATOM  12650  CE1 TYR C 289      -1.346  35.567  27.293  1.00 33.55           C  
ATOM  12651  CE2 TYR C 289       0.951  35.740  27.905  1.00 35.82           C  
ATOM  12652  CZ  TYR C 289      -0.105  36.139  27.117  1.00 36.49           C  
ATOM  12653  OH  TYR C 289       0.086  37.065  26.112  1.00 35.13           O  
ATOM  12654  N   VAL C 290       0.087  29.787  30.936  1.00 42.53           N  
ATOM  12655  CA  VAL C 290       0.011  28.732  31.948  1.00 42.55           C  
ATOM  12656  C   VAL C 290       1.154  28.812  32.945  1.00 43.38           C  
ATOM  12657  O   VAL C 290       2.317  28.815  32.522  1.00 43.20           O  
ATOM  12658  CB  VAL C 290       0.099  27.359  31.253  1.00 42.85           C  
ATOM  12659  CG1 VAL C 290      -0.045  26.256  32.296  1.00 40.45           C  
ATOM  12660  CG2 VAL C 290      -0.938  27.243  30.148  1.00 39.46           C  
ATOM  12661  N   GLN C 291       0.851  28.973  34.230  1.00 44.39           N  
ATOM  12662  CA  GLN C 291       1.920  29.098  35.240  1.00 44.57           C  
ATOM  12663  C   GLN C 291       2.600  27.757  35.418  1.00 45.90           C  
ATOM  12664  O   GLN C 291       1.938  26.717  35.298  1.00 44.37           O  
ATOM  12665  CB  GLN C 291       1.376  29.637  36.562  1.00 44.36           C  
ATOM  12666  CG  GLN C 291       2.387  29.981  37.627  1.00 41.91           C  
ATOM  12667  CD  GLN C 291       1.813  30.703  38.833  1.00 45.79           C  
ATOM  12668  OE1 GLN C 291       0.598  30.708  39.063  1.00 45.12           O  
ATOM  12669  NE2 GLN C 291       2.686  31.315  39.635  1.00 42.99           N  
ATOM  12670  N   LEU C 292       3.916  27.748  35.659  1.00 46.76           N  
ATOM  12671  CA  LEU C 292       4.629  26.477  35.807  1.00 49.79           C  
ATOM  12672  C   LEU C 292       5.257  26.226  37.171  1.00 50.93           C  
ATOM  12673  O   LEU C 292       5.186  27.138  37.978  1.00 48.25           O  
ATOM  12674  CB  LEU C 292       5.732  26.363  34.760  1.00 46.62           C  
ATOM  12675  CG  LEU C 292       5.268  26.440  33.310  1.00 49.16           C  
ATOM  12676  CD1 LEU C 292       6.405  25.992  32.411  1.00 49.32           C  
ATOM  12677  CD2 LEU C 292       4.040  25.576  33.069  1.00 46.79           C  
ATOM  12678  N   ARG C 301      19.661  28.016  36.531  1.00 68.93           N  
ATOM  12679  CA  ARG C 301      18.478  28.688  35.990  1.00 67.38           C  
ATOM  12680  C   ARG C 301      17.730  27.790  35.018  1.00 68.70           C  
ATOM  12681  O   ARG C 301      18.236  26.724  34.639  1.00 69.15           O  
ATOM  12682  CB  ARG C 301      18.903  30.028  35.411  1.00 66.58           C  
ATOM  12683  CG  ARG C 301      19.515  30.078  34.033  1.00 67.53           C  
ATOM  12684  CD  ARG C 301      20.666  31.069  33.930  1.00 65.74           C  
ATOM  12685  NE  ARG C 301      20.637  31.948  32.785  1.00 72.92           N  
ATOM  12686  CZ  ARG C 301      20.343  31.736  31.514  1.00 75.51           C  
ATOM  12687  NH1 ARG C 301      19.990  30.539  31.059  1.00 81.44           N  
ATOM  12688  NH2 ARG C 301      20.374  32.694  30.598  1.00 75.20           N  
ATOM  12689  N   VAL C 302      16.515  28.167  34.616  1.00 68.10           N  
ATOM  12690  CA  VAL C 302      15.702  27.371  33.708  1.00 66.44           C  
ATOM  12691  C   VAL C 302      16.427  26.983  32.418  1.00 66.37           C  
ATOM  12692  O   VAL C 302      16.799  27.862  31.645  1.00 65.09           O  
ATOM  12693  CB  VAL C 302      14.412  28.092  33.269  1.00 68.97           C  
ATOM  12694  CG1 VAL C 302      13.652  27.284  32.226  1.00 65.01           C  
ATOM  12695  CG2 VAL C 302      13.486  28.450  34.420  1.00 62.65           C  
ATOM  12696  N   ASP C 303      16.454  25.689  32.124  1.00 65.29           N  
ATOM  12697  CA  ASP C 303      17.034  25.162  30.895  1.00 62.04           C  
ATOM  12698  C   ASP C 303      15.991  25.090  29.788  1.00 59.33           C  
ATOM  12699  O   ASP C 303      15.200  24.170  29.597  1.00 57.62           O  
ATOM  12700  CB  ASP C 303      17.682  23.815  31.202  1.00 63.23           C  
ATOM  12701  CG  ASP C 303      18.108  22.968  30.032  1.00 65.47           C  
ATOM  12702  OD1 ASP C 303      18.233  23.506  28.913  1.00 72.19           O  
ATOM  12703  OD2 ASP C 303      18.315  21.745  30.193  1.00 66.59           O  
ATOM  12704  N   ARG C 304      15.998  26.087  28.919  1.00 58.50           N  
ATOM  12705  CA  ARG C 304      15.103  26.255  27.789  1.00 59.12           C  
ATOM  12706  C   ARG C 304      14.999  25.116  26.799  1.00 58.97           C  
ATOM  12707  O   ARG C 304      13.998  25.004  26.071  1.00 59.02           O  
ATOM  12708  CB  ARG C 304      15.456  27.566  27.064  1.00 58.14           C  
ATOM  12709  CG  ARG C 304      14.814  28.773  27.764  1.00 55.46           C  
ATOM  12710  CD  ARG C 304      15.258  30.043  27.032  1.00 54.16           C  
ATOM  12711  NE  ARG C 304      16.698  30.208  27.228  1.00 54.40           N  
ATOM  12712  CZ  ARG C 304      17.439  31.196  26.761  1.00 53.61           C  
ATOM  12713  NH1 ARG C 304      16.953  32.191  26.036  1.00 50.93           N  
ATOM  12714  NH2 ARG C 304      18.736  31.182  27.036  1.00 46.89           N  
ATOM  12715  N   THR C 305      15.976  24.236  26.745  1.00 58.00           N  
ATOM  12716  CA  THR C 305      16.026  23.032  25.928  1.00 59.26           C  
ATOM  12717  C   THR C 305      14.993  22.021  26.416  1.00 60.96           C  
ATOM  12718  O   THR C 305      14.336  21.267  25.711  1.00 61.03           O  
ATOM  12719  CB  THR C 305      17.440  22.446  26.142  1.00 59.89           C  
ATOM  12720  OG1 THR C 305      18.282  22.823  25.037  1.00 62.39           O  
ATOM  12721  CG2 THR C 305      17.469  20.952  26.348  1.00 58.87           C  
ATOM  12722  N   LYS C 306      14.871  21.973  27.741  1.00 62.55           N  
ATOM  12723  CA  LYS C 306      13.972  21.112  28.471  1.00 63.26           C  
ATOM  12724  C   LYS C 306      12.601  21.747  28.678  1.00 61.40           C  
ATOM  12725  O   LYS C 306      11.706  21.135  29.255  1.00 59.29           O  
ATOM  12726  CB  LYS C 306      14.586  20.809  29.845  1.00 69.89           C  
ATOM  12727  CG  LYS C 306      15.834  19.943  29.768  1.00 73.91           C  
ATOM  12728  CD  LYS C 306      16.209  19.444  31.157  1.00 74.39           C  
ATOM  12729  CE  LYS C 306      17.212  18.302  31.051  1.00 75.39           C  
ATOM  12730  NZ  LYS C 306      18.339  18.515  32.000  1.00 75.34           N  
ATOM  12731  N   PHE C 307      12.482  23.015  28.313  1.00 61.40           N  
ATOM  12732  CA  PHE C 307      11.196  23.707  28.389  1.00 61.61           C  
ATOM  12733  C   PHE C 307      10.381  23.365  27.151  1.00 59.14           C  
ATOM  12734  O   PHE C 307      10.510  24.049  26.146  1.00 60.47           O  
ATOM  12735  CB  PHE C 307      11.422  25.212  28.406  1.00 64.96           C  
ATOM  12736  CG  PHE C 307      10.465  25.936  29.306  1.00 66.55           C  
ATOM  12737  CD1 PHE C 307       9.148  26.163  28.943  1.00 66.42           C  
ATOM  12738  CD2 PHE C 307      10.937  26.408  30.516  1.00 67.50           C  
ATOM  12739  CE1 PHE C 307       8.317  26.863  29.800  1.00 70.62           C  
ATOM  12740  CE2 PHE C 307      10.108  27.098  31.378  1.00 68.71           C  
ATOM  12741  CZ  PHE C 307       8.809  27.333  31.008  1.00 69.55           C  
ATOM  12742  N   THR C 308       9.580  22.315  27.221  1.00 56.66           N  
ATOM  12743  CA  THR C 308       8.802  21.928  26.044  1.00 55.47           C  
ATOM  12744  C   THR C 308       7.319  22.224  26.207  1.00 51.36           C  
ATOM  12745  O   THR C 308       6.818  22.417  27.310  1.00 49.97           O  
ATOM  12746  CB  THR C 308       9.043  20.444  25.702  1.00 54.70           C  
ATOM  12747  OG1 THR C 308       8.435  19.573  26.649  1.00 56.55           O  
ATOM  12748  CG2 THR C 308      10.530  20.109  25.657  1.00 55.71           C  
ATOM  12749  N   PRO C 309       6.597  22.094  25.106  1.00 49.86           N  
ATOM  12750  CA  PRO C 309       5.154  22.285  25.106  1.00 50.51           C  
ATOM  12751  C   PRO C 309       4.539  21.336  26.122  1.00 51.00           C  
ATOM  12752  O   PRO C 309       3.693  21.691  26.938  1.00 50.20           O  
ATOM  12753  CB  PRO C 309       4.691  21.983  23.685  1.00 48.36           C  
ATOM  12754  CG  PRO C 309       5.911  22.155  22.855  1.00 47.93           C  
ATOM  12755  CD  PRO C 309       7.105  21.858  23.733  1.00 49.06           C  
ATOM  12756  N   GLU C 310       5.007  20.092  26.043  1.00 51.93           N  
ATOM  12757  CA  GLU C 310       4.550  19.002  26.887  1.00 52.05           C  
ATOM  12758  C   GLU C 310       4.535  19.401  28.348  1.00 51.68           C  
ATOM  12759  O   GLU C 310       3.528  19.254  29.036  1.00 51.38           O  
ATOM  12760  CB  GLU C 310       5.457  17.786  26.694  1.00 56.19           C  
ATOM  12761  CG  GLU C 310       5.351  17.098  25.354  1.00 60.21           C  
ATOM  12762  CD  GLU C 310       6.065  17.765  24.206  1.00 64.31           C  
ATOM  12763  OE1 GLU C 310       7.018  18.552  24.371  1.00 63.78           O  
ATOM  12764  OE2 GLU C 310       5.663  17.474  23.057  1.00 69.90           O  
ATOM  12765  N   VAL C 311       5.642  19.936  28.853  1.00 50.74           N  
ATOM  12766  CA  VAL C 311       5.685  20.400  30.238  1.00 49.89           C  
ATOM  12767  C   VAL C 311       4.603  21.436  30.486  1.00 48.59           C  
ATOM  12768  O   VAL C 311       3.936  21.353  31.523  1.00 49.28           O  
ATOM  12769  CB  VAL C 311       7.063  20.947  30.630  1.00 51.33           C  
ATOM  12770  CG1 VAL C 311       7.039  21.611  31.998  1.00 49.34           C  
ATOM  12771  CG2 VAL C 311       8.089  19.811  30.675  1.00 51.23           C  
ATOM  12772  N   VAL C 312       4.422  22.387  29.576  1.00 47.38           N  
ATOM  12773  CA  VAL C 312       3.387  23.402  29.693  1.00 46.48           C  
ATOM  12774  C   VAL C 312       2.001  22.791  29.646  1.00 46.73           C  
ATOM  12775  O   VAL C 312       1.146  23.159  30.453  1.00 46.50           O  
ATOM  12776  CB  VAL C 312       3.581  24.474  28.616  1.00 45.59           C  
ATOM  12777  CG1 VAL C 312       2.537  25.590  28.675  1.00 43.40           C  
ATOM  12778  CG2 VAL C 312       4.974  25.064  28.776  1.00 44.42           C  
ATOM  12779  N   ILE C 313       1.786  21.799  28.782  1.00 48.09           N  
ATOM  12780  CA  ILE C 313       0.490  21.140  28.640  1.00 49.27           C  
ATOM  12781  C   ILE C 313       0.127  20.332  29.876  1.00 49.58           C  
ATOM  12782  O   ILE C 313      -1.013  20.361  30.351  1.00 50.19           O  
ATOM  12783  CB  ILE C 313       0.477  20.243  27.392  1.00 49.85           C  
ATOM  12784  CG1 ILE C 313       0.438  21.119  26.126  1.00 50.66           C  
ATOM  12785  CG2 ILE C 313      -0.677  19.250  27.403  1.00 47.56           C  
ATOM  12786  CD1 ILE C 313       0.686  20.308  24.858  1.00 49.18           C  
ATOM  12787  N   ALA C 314       1.125  19.677  30.463  1.00 48.10           N  
ATOM  12788  CA  ALA C 314       0.921  18.855  31.654  1.00 47.39           C  
ATOM  12789  C   ALA C 314       0.465  19.721  32.815  1.00 48.44           C  
ATOM  12790  O   ALA C 314      -0.420  19.382  33.591  1.00 48.99           O  
ATOM  12791  CB  ALA C 314       2.191  18.116  32.007  1.00 43.17           C  
ATOM  12792  N   ASN C 315       1.059  20.894  32.936  1.00 48.62           N  
ATOM  12793  CA  ASN C 315       0.693  21.867  33.953  1.00 49.39           C  
ATOM  12794  C   ASN C 315      -0.668  22.488  33.685  1.00 49.54           C  
ATOM  12795  O   ASN C 315      -1.454  22.700  34.617  1.00 49.09           O  
ATOM  12796  CB  ASN C 315       1.790  22.940  33.984  1.00 51.96           C  
ATOM  12797  CG  ASN C 315       2.502  22.842  35.325  1.00 58.17           C  
ATOM  12798  OD1 ASN C 315       3.726  22.660  35.387  1.00 60.10           O  
ATOM  12799  ND2 ASN C 315       1.675  22.943  36.369  1.00 56.76           N  
ATOM  12800  N   ALA C 316      -1.019  22.702  32.414  1.00 48.54           N  
ATOM  12801  CA  ALA C 316      -2.326  23.271  32.092  1.00 47.99           C  
ATOM  12802  C   ALA C 316      -3.395  22.242  32.445  1.00 47.25           C  
ATOM  12803  O   ALA C 316      -4.451  22.596  32.966  1.00 44.60           O  
ATOM  12804  CB  ALA C 316      -2.422  23.753  30.650  1.00 42.89           C  
ATOM  12805  N   LYS C 317      -3.109  20.959  32.226  1.00 47.68           N  
ATOM  12806  CA  LYS C 317      -4.059  19.904  32.582  1.00 48.45           C  
ATOM  12807  C   LYS C 317      -4.333  19.903  34.080  1.00 50.50           C  
ATOM  12808  O   LYS C 317      -5.486  19.819  34.520  1.00 52.31           O  
ATOM  12809  CB  LYS C 317      -3.565  18.545  32.122  1.00 45.99           C  
ATOM  12810  CG  LYS C 317      -3.813  18.285  30.633  1.00 45.24           C  
ATOM  12811  CD  LYS C 317      -3.062  17.019  30.216  1.00 44.53           C  
ATOM  12812  CE  LYS C 317      -3.245  16.761  28.731  1.00 43.95           C  
ATOM  12813  NZ  LYS C 317      -4.621  16.260  28.459  1.00 44.49           N  
ATOM  12814  N   LYS C 318      -3.289  20.064  34.888  1.00 51.84           N  
ATOM  12815  CA  LYS C 318      -3.439  20.127  36.330  1.00 51.91           C  
ATOM  12816  C   LYS C 318      -4.298  21.323  36.719  1.00 51.58           C  
ATOM  12817  O   LYS C 318      -5.175  21.207  37.565  1.00 52.95           O  
ATOM  12818  CB  LYS C 318      -2.094  20.225  37.040  1.00 53.71           C  
ATOM  12819  CG  LYS C 318      -1.476  18.880  37.361  1.00 59.21           C  
ATOM  12820  CD  LYS C 318      -1.115  18.823  38.846  1.00 65.41           C  
ATOM  12821  CE  LYS C 318       0.352  19.176  39.051  1.00 67.63           C  
ATOM  12822  NZ  LYS C 318       0.727  19.137  40.499  1.00 70.13           N  
ATOM  12823  N   ILE C 319      -4.012  22.493  36.171  1.00 50.99           N  
ATOM  12824  CA  ILE C 319      -4.762  23.696  36.498  1.00 48.14           C  
ATOM  12825  C   ILE C 319      -6.227  23.628  36.071  1.00 48.46           C  
ATOM  12826  O   ILE C 319      -7.078  24.214  36.755  1.00 48.24           O  
ATOM  12827  CB  ILE C 319      -4.078  24.923  35.854  1.00 45.89           C  
ATOM  12828  CG1 ILE C 319      -2.680  25.065  36.450  1.00 46.71           C  
ATOM  12829  CG2 ILE C 319      -4.882  26.191  36.051  1.00 44.29           C  
ATOM  12830  CD1 ILE C 319      -1.792  26.082  35.740  1.00 48.95           C  
ATOM  12831  N   PHE C 320      -6.556  22.998  34.960  1.00 47.39           N  
ATOM  12832  CA  PHE C 320      -7.901  22.900  34.451  1.00 49.74           C  
ATOM  12833  C   PHE C 320      -8.751  21.859  35.170  1.00 51.31           C  
ATOM  12834  O   PHE C 320      -9.969  21.843  34.963  1.00 51.44           O  
ATOM  12835  CB  PHE C 320      -7.894  22.529  32.958  1.00 49.23           C  
ATOM  12836  CG  PHE C 320      -7.841  23.684  31.998  1.00 49.28           C  
ATOM  12837  CD1 PHE C 320      -8.890  24.582  31.906  1.00 45.16           C  
ATOM  12838  CD2 PHE C 320      -6.744  23.843  31.159  1.00 44.99           C  
ATOM  12839  CE1 PHE C 320      -8.845  25.634  31.015  1.00 45.90           C  
ATOM  12840  CE2 PHE C 320      -6.710  24.904  30.276  1.00 47.22           C  
ATOM  12841  CZ  PHE C 320      -7.756  25.794  30.191  1.00 43.93           C  
ATOM  12842  N   HIS C 321      -8.133  20.981  35.956  1.00 52.65           N  
ATOM  12843  CA  HIS C 321      -8.864  19.937  36.667  1.00 53.65           C  
ATOM  12844  C   HIS C 321     -10.106  20.506  37.337  1.00 53.94           C  
ATOM  12845  O   HIS C 321     -10.027  21.552  37.995  1.00 53.91           O  
ATOM  12846  CB  HIS C 321      -7.961  19.284  37.725  1.00 56.79           C  
ATOM  12847  CG  HIS C 321      -8.537  17.968  38.183  1.00 61.35           C  
ATOM  12848  ND1 HIS C 321      -8.604  16.866  37.337  1.00 60.88           N  
ATOM  12849  CD2 HIS C 321      -9.090  17.602  39.362  1.00 59.23           C  
ATOM  12850  CE1 HIS C 321      -9.176  15.879  37.986  1.00 61.10           C  
ATOM  12851  NE2 HIS C 321      -9.474  16.292  39.207  1.00 61.65           N  
ATOM  12852  N   PRO C 322     -11.238  19.864  37.123  1.00 53.29           N  
ATOM  12853  CA  PRO C 322     -11.334  18.627  36.390  1.00 53.96           C  
ATOM  12854  C   PRO C 322     -11.719  18.702  34.924  1.00 53.64           C  
ATOM  12855  O   PRO C 322     -12.052  17.680  34.310  1.00 54.42           O  
ATOM  12856  CB  PRO C 322     -12.471  17.918  37.149  1.00 54.25           C  
ATOM  12857  CG  PRO C 322     -13.410  19.022  37.506  1.00 54.33           C  
ATOM  12858  CD  PRO C 322     -12.554  20.243  37.713  1.00 54.38           C  
ATOM  12859  N   TYR C 323     -11.706  19.890  34.337  1.00 52.73           N  
ATOM  12860  CA  TYR C 323     -12.047  19.998  32.917  1.00 51.10           C  
ATOM  12861  C   TYR C 323     -10.897  19.413  32.107  1.00 50.89           C  
ATOM  12862  O   TYR C 323      -9.784  19.264  32.608  1.00 51.80           O  
ATOM  12863  CB  TYR C 323     -12.340  21.440  32.580  1.00 50.19           C  
ATOM  12864  CG  TYR C 323     -13.550  21.966  33.319  1.00 49.02           C  
ATOM  12865  CD1 TYR C 323     -14.832  21.688  32.891  1.00 48.11           C  
ATOM  12866  CD2 TYR C 323     -13.385  22.752  34.457  1.00 49.61           C  
ATOM  12867  CE1 TYR C 323     -15.920  22.188  33.575  1.00 49.27           C  
ATOM  12868  CE2 TYR C 323     -14.469  23.264  35.148  1.00 48.55           C  
ATOM  12869  CZ  TYR C 323     -15.734  22.972  34.689  1.00 50.47           C  
ATOM  12870  OH  TYR C 323     -16.841  23.460  35.349  1.00 52.10           O  
ATOM  12871  N   THR C 324     -11.187  19.019  30.884  1.00 51.06           N  
ATOM  12872  CA  THR C 324     -10.174  18.443  30.000  1.00 50.52           C  
ATOM  12873  C   THR C 324      -9.475  19.573  29.255  1.00 49.44           C  
ATOM  12874  O   THR C 324     -10.052  20.621  28.996  1.00 48.04           O  
ATOM  12875  CB  THR C 324     -10.886  17.578  28.944  1.00 50.98           C  
ATOM  12876  OG1 THR C 324     -11.810  18.434  28.249  1.00 53.51           O  
ATOM  12877  CG2 THR C 324     -11.667  16.470  29.631  1.00 51.93           C  
ATOM  12878  N   PHE C 325      -8.266  19.299  28.811  1.00 48.49           N  
ATOM  12879  CA  PHE C 325      -7.474  20.230  28.045  1.00 46.68           C  
ATOM  12880  C   PHE C 325      -6.526  19.460  27.140  1.00 45.98           C  
ATOM  12881  O   PHE C 325      -5.656  18.774  27.670  1.00 45.46           O  
ATOM  12882  CB  PHE C 325      -6.638  21.159  28.939  1.00 46.30           C  
ATOM  12883  CG  PHE C 325      -5.813  22.109  28.110  1.00 46.31           C  
ATOM  12884  CD1 PHE C 325      -6.429  23.157  27.455  1.00 45.71           C  
ATOM  12885  CD2 PHE C 325      -4.456  21.919  27.943  1.00 45.01           C  
ATOM  12886  CE1 PHE C 325      -5.698  24.055  26.712  1.00 46.76           C  
ATOM  12887  CE2 PHE C 325      -3.737  22.784  27.136  1.00 51.31           C  
ATOM  12888  CZ  PHE C 325      -4.336  23.858  26.521  1.00 47.71           C  
ATOM  12889  N   ASP C 326      -6.743  19.524  25.833  1.00 45.34           N  
ATOM  12890  CA  ASP C 326      -5.793  18.971  24.880  1.00 46.01           C  
ATOM  12891  C   ASP C 326      -5.607  19.972  23.733  1.00 47.47           C  
ATOM  12892  O   ASP C 326      -6.407  20.896  23.544  1.00 46.55           O  
ATOM  12893  CB  ASP C 326      -6.160  17.601  24.329  1.00 46.73           C  
ATOM  12894  CG  ASP C 326      -6.056  16.525  25.399  1.00 51.47           C  
ATOM  12895  OD1 ASP C 326      -4.934  16.137  25.773  1.00 49.74           O  
ATOM  12896  OD2 ASP C 326      -7.141  16.173  25.927  1.00 53.18           O  
ATOM  12897  N   VAL C 327      -4.474  19.818  23.070  1.00 46.47           N  
ATOM  12898  CA  VAL C 327      -4.080  20.703  21.973  1.00 46.98           C  
ATOM  12899  C   VAL C 327      -4.358  20.021  20.648  1.00 46.79           C  
ATOM  12900  O   VAL C 327      -3.841  18.926  20.408  1.00 47.63           O  
ATOM  12901  CB  VAL C 327      -2.581  21.020  22.145  1.00 48.38           C  
ATOM  12902  CG1 VAL C 327      -1.923  21.503  20.879  1.00 46.49           C  
ATOM  12903  CG2 VAL C 327      -2.386  22.048  23.257  1.00 47.30           C  
ATOM  12904  N   GLN C 328      -5.188  20.581  19.782  1.00 46.14           N  
ATOM  12905  CA  GLN C 328      -5.423  19.978  18.477  1.00 46.35           C  
ATOM  12906  C   GLN C 328      -4.286  20.372  17.527  1.00 47.86           C  
ATOM  12907  O   GLN C 328      -3.948  19.632  16.622  1.00 46.76           O  
ATOM  12908  CB  GLN C 328      -6.722  20.413  17.822  1.00 44.08           C  
ATOM  12909  CG  GLN C 328      -7.991  19.954  18.497  1.00 48.40           C  
ATOM  12910  CD  GLN C 328      -9.201  20.354  17.675  1.00 48.85           C  
ATOM  12911  OE1 GLN C 328      -9.381  19.800  16.590  1.00 53.96           O  
ATOM  12912  NE2 GLN C 328     -10.007  21.280  18.167  1.00 45.41           N  
ATOM  12913  N   GLN C 329      -3.770  21.580  17.707  1.00 48.66           N  
ATOM  12914  CA  GLN C 329      -2.685  22.079  16.850  1.00 48.81           C  
ATOM  12915  C   GLN C 329      -1.941  23.132  17.663  1.00 48.26           C  
ATOM  12916  O   GLN C 329      -2.593  23.856  18.427  1.00 48.22           O  
ATOM  12917  CB  GLN C 329      -3.280  22.606  15.559  1.00 48.26           C  
ATOM  12918  CG  GLN C 329      -2.654  23.834  14.932  1.00 53.82           C  
ATOM  12919  CD  GLN C 329      -3.573  24.502  13.929  1.00 56.00           C  
ATOM  12920  OE1 GLN C 329      -4.488  23.896  13.388  1.00 57.33           O  
ATOM  12921  NE2 GLN C 329      -3.328  25.784  13.672  1.00 55.20           N  
ATOM  12922  N   LEU C 330      -0.614  23.113  17.625  1.00 45.75           N  
ATOM  12923  CA  LEU C 330       0.130  24.119  18.375  1.00 45.09           C  
ATOM  12924  C   LEU C 330       0.987  24.935  17.408  1.00 43.32           C  
ATOM  12925  O   LEU C 330       1.812  24.387  16.687  1.00 42.95           O  
ATOM  12926  CB  LEU C 330       0.970  23.494  19.472  1.00 42.98           C  
ATOM  12927  CG  LEU C 330       1.741  24.480  20.364  1.00 46.35           C  
ATOM  12928  CD1 LEU C 330       0.826  25.222  21.312  1.00 41.41           C  
ATOM  12929  CD2 LEU C 330       2.809  23.677  21.108  1.00 44.81           C  
ATOM  12930  N   ASP C 331       0.676  26.216  17.305  1.00 41.36           N  
ATOM  12931  CA  ASP C 331       1.393  27.090  16.386  1.00 40.39           C  
ATOM  12932  C   ASP C 331       2.689  27.591  16.994  1.00 41.79           C  
ATOM  12933  O   ASP C 331       3.746  27.536  16.352  1.00 40.44           O  
ATOM  12934  CB  ASP C 331       0.493  28.258  15.954  1.00 39.29           C  
ATOM  12935  CG  ASP C 331      -0.603  27.759  15.033  1.00 40.18           C  
ATOM  12936  OD1 ASP C 331      -0.723  26.522  14.886  1.00 44.00           O  
ATOM  12937  OD2 ASP C 331      -1.373  28.536  14.437  1.00 46.25           O  
ATOM  12938  N   TRP C 332       2.663  27.949  18.283  1.00 41.20           N  
ATOM  12939  CA  TRP C 332       3.870  28.549  18.868  1.00 40.00           C  
ATOM  12940  C   TRP C 332       3.842  28.399  20.363  1.00 41.03           C  
ATOM  12941  O   TRP C 332       2.824  27.973  20.884  1.00 42.21           O  
ATOM  12942  CB  TRP C 332       3.850  29.993  18.382  1.00 35.95           C  
ATOM  12943  CG  TRP C 332       4.886  30.961  18.815  1.00 37.66           C  
ATOM  12944  CD1 TRP C 332       6.095  31.238  18.234  1.00 35.70           C  
ATOM  12945  CD2 TRP C 332       4.788  31.841  19.951  1.00 36.07           C  
ATOM  12946  NE1 TRP C 332       6.762  32.210  18.935  1.00 31.93           N  
ATOM  12947  CE2 TRP C 332       5.968  32.603  19.997  1.00 36.96           C  
ATOM  12948  CE3 TRP C 332       3.809  32.047  20.925  1.00 36.76           C  
ATOM  12949  CZ2 TRP C 332       6.176  33.548  21.003  1.00 31.80           C  
ATOM  12950  CZ3 TRP C 332       4.052  32.973  21.912  1.00 36.99           C  
ATOM  12951  CH2 TRP C 332       5.226  33.723  21.934  1.00 33.61           C  
ATOM  12952  N   PHE C 333       4.890  28.775  21.078  1.00 42.08           N  
ATOM  12953  CA  PHE C 333       4.886  28.700  22.528  1.00 41.66           C  
ATOM  12954  C   PHE C 333       6.097  29.503  23.003  1.00 43.53           C  
ATOM  12955  O   PHE C 333       6.934  29.813  22.141  1.00 42.19           O  
ATOM  12956  CB  PHE C 333       4.892  27.263  23.018  1.00 43.29           C  
ATOM  12957  CG  PHE C 333       6.233  26.580  22.978  1.00 46.74           C  
ATOM  12958  CD1 PHE C 333       6.708  26.051  21.790  1.00 49.51           C  
ATOM  12959  CD2 PHE C 333       7.020  26.496  24.103  1.00 50.16           C  
ATOM  12960  CE1 PHE C 333       7.936  25.418  21.726  1.00 51.11           C  
ATOM  12961  CE2 PHE C 333       8.255  25.888  24.055  1.00 51.90           C  
ATOM  12962  CZ  PHE C 333       8.703  25.327  22.871  1.00 51.00           C  
ATOM  12963  N   THR C 334       6.114  29.891  24.261  1.00 41.04           N  
ATOM  12964  CA  THR C 334       7.216  30.600  24.858  1.00 42.81           C  
ATOM  12965  C   THR C 334       7.224  30.310  26.374  1.00 41.54           C  
ATOM  12966  O   THR C 334       6.415  29.579  26.909  1.00 42.83           O  
ATOM  12967  CB  THR C 334       7.228  32.140  24.947  1.00 45.60           C  
ATOM  12968  OG1 THR C 334       5.969  32.771  24.677  1.00 48.64           O  
ATOM  12969  CG2 THR C 334       8.419  32.709  24.248  1.00 40.16           C  
ATOM  12970  N   ALA C 335       8.102  30.998  27.058  1.00 41.02           N  
ATOM  12971  CA  ALA C 335       8.202  30.993  28.500  1.00 39.91           C  
ATOM  12972  C   ALA C 335       8.665  32.399  28.905  1.00 40.20           C  
ATOM  12973  O   ALA C 335       9.301  33.096  28.102  1.00 38.03           O  
ATOM  12974  CB  ALA C 335       9.164  29.984  29.067  1.00 40.14           C  
ATOM  12975  N   TYR C 336       8.397  32.733  30.162  1.00 40.90           N  
ATOM  12976  CA  TYR C 336       8.856  33.990  30.739  1.00 41.44           C  
ATOM  12977  C   TYR C 336       8.772  33.889  32.264  1.00 43.11           C  
ATOM  12978  O   TYR C 336       7.953  33.133  32.806  1.00 43.42           O  
ATOM  12979  CB  TYR C 336       8.105  35.204  30.200  1.00 40.72           C  
ATOM  12980  CG  TYR C 336       6.622  35.121  30.496  1.00 43.88           C  
ATOM  12981  CD1 TYR C 336       5.767  34.467  29.624  1.00 43.28           C  
ATOM  12982  CD2 TYR C 336       6.089  35.656  31.664  1.00 45.40           C  
ATOM  12983  CE1 TYR C 336       4.419  34.371  29.891  1.00 44.28           C  
ATOM  12984  CE2 TYR C 336       4.742  35.544  31.953  1.00 45.65           C  
ATOM  12985  CZ  TYR C 336       3.911  34.909  31.056  1.00 44.87           C  
ATOM  12986  OH  TYR C 336       2.558  34.804  31.313  1.00 42.24           O  
ATOM  12987  N   HIS C 337       9.629  34.591  32.950  1.00 42.74           N  
ATOM  12988  CA  HIS C 337       9.667  34.748  34.383  1.00 45.24           C  
ATOM  12989  C   HIS C 337       8.846  36.021  34.674  1.00 45.90           C  
ATOM  12990  O   HIS C 337       8.567  36.818  33.769  1.00 44.63           O  
ATOM  12991  CB  HIS C 337      11.076  34.982  34.937  1.00 49.05           C  
ATOM  12992  CG  HIS C 337      11.843  33.692  35.058  1.00 54.23           C  
ATOM  12993  ND1 HIS C 337      11.390  32.632  35.829  1.00 54.57           N  
ATOM  12994  CD2 HIS C 337      12.984  33.274  34.466  1.00 53.32           C  
ATOM  12995  CE1 HIS C 337      12.242  31.641  35.736  1.00 53.95           C  
ATOM  12996  NE2 HIS C 337      13.203  31.991  34.902  1.00 54.17           N  
ATOM  12997  N   ILE C 338       8.343  36.172  35.875  1.00 45.22           N  
ATOM  12998  CA  ILE C 338       7.649  37.403  36.245  1.00 45.37           C  
ATOM  12999  C   ILE C 338       8.674  38.398  36.741  1.00 45.26           C  
ATOM  13000  O   ILE C 338       9.423  38.012  37.636  1.00 45.08           O  
ATOM  13001  CB  ILE C 338       6.616  37.162  37.363  1.00 43.61           C  
ATOM  13002  CG1 ILE C 338       5.510  36.262  36.833  1.00 45.24           C  
ATOM  13003  CG2 ILE C 338       6.098  38.527  37.833  1.00 43.09           C  
ATOM  13004  CD1 ILE C 338       4.801  36.801  35.606  1.00 43.64           C  
ATOM  13005  N   GLY C 339       8.699  39.597  36.187  1.00 45.58           N  
ATOM  13006  CA  GLY C 339       9.666  40.611  36.640  1.00 44.37           C  
ATOM  13007  C   GLY C 339       9.250  41.961  36.067  1.00 44.77           C  
ATOM  13008  O   GLY C 339       8.494  41.995  35.107  1.00 45.67           O  
ATOM  13009  N   GLN C 340       9.678  43.063  36.656  1.00 42.73           N  
ATOM  13010  CA  GLN C 340       9.324  44.400  36.203  1.00 44.28           C  
ATOM  13011  C   GLN C 340      10.590  45.225  36.083  1.00 46.13           C  
ATOM  13012  O   GLN C 340      11.440  45.096  36.964  1.00 47.82           O  
ATOM  13013  CB  GLN C 340       8.441  45.087  37.254  1.00 42.67           C  
ATOM  13014  CG  GLN C 340       6.966  44.748  37.230  1.00 45.47           C  
ATOM  13015  CD  GLN C 340       6.676  43.422  37.917  1.00 42.99           C  
ATOM  13016  OE1 GLN C 340       7.145  43.203  39.043  1.00 48.42           O  
ATOM  13017  NE2 GLN C 340       5.935  42.542  37.276  1.00 41.15           N  
ATOM  13018  N   ARG C 341      10.811  46.025  35.057  1.00 45.66           N  
ATOM  13019  CA  ARG C 341      12.008  46.856  34.960  1.00 46.18           C  
ATOM  13020  C   ARG C 341      11.671  48.182  34.302  1.00 46.22           C  
ATOM  13021  O   ARG C 341      10.832  48.199  33.395  1.00 46.53           O  
ATOM  13022  CB  ARG C 341      13.065  46.148  34.127  1.00 50.10           C  
ATOM  13023  CG  ARG C 341      13.583  44.817  34.648  1.00 49.03           C  
ATOM  13024  CD  ARG C 341      14.690  44.259  33.787  1.00 49.65           C  
ATOM  13025  NE  ARG C 341      15.994  44.778  34.190  1.00 53.07           N  
ATOM  13026  CZ  ARG C 341      16.943  44.995  33.277  1.00 58.38           C  
ATOM  13027  NH1 ARG C 341      16.682  44.741  31.994  1.00 57.36           N  
ATOM  13028  NH2 ARG C 341      18.157  45.437  33.584  1.00 55.63           N  
ATOM  13029  N   VAL C 342      12.267  49.287  34.720  1.00 45.57           N  
ATOM  13030  CA  VAL C 342      12.024  50.594  34.168  1.00 45.64           C  
ATOM  13031  C   VAL C 342      13.285  51.466  34.260  1.00 44.70           C  
ATOM  13032  O   VAL C 342      14.035  51.335  35.213  1.00 44.16           O  
ATOM  13033  CB  VAL C 342      10.973  51.483  34.877  1.00 48.21           C  
ATOM  13034  CG1 VAL C 342       9.690  51.561  34.070  1.00 46.13           C  
ATOM  13035  CG2 VAL C 342      10.756  51.102  36.314  1.00 43.83           C  
ATOM  13036  N   THR C 343      13.423  52.368  33.301  1.00 44.35           N  
ATOM  13037  CA  THR C 343      14.557  53.276  33.357  1.00 43.97           C  
ATOM  13038  C   THR C 343      14.046  54.629  33.865  1.00 42.81           C  
ATOM  13039  O   THR C 343      12.837  54.857  33.852  1.00 41.49           O  
ATOM  13040  CB  THR C 343      15.219  53.479  31.993  1.00 42.67           C  
ATOM  13041  OG1 THR C 343      14.323  54.235  31.166  1.00 45.11           O  
ATOM  13042  CG2 THR C 343      15.514  52.135  31.373  1.00 47.75           C  
ATOM  13043  N   GLU C 344      14.960  55.463  34.305  1.00 40.76           N  
ATOM  13044  CA  GLU C 344      14.624  56.802  34.761  1.00 42.49           C  
ATOM  13045  C   GLU C 344      14.724  57.771  33.592  1.00 41.80           C  
ATOM  13046  O   GLU C 344      14.035  58.770  33.487  1.00 39.52           O  
ATOM  13047  CB  GLU C 344      15.562  57.197  35.904  1.00 45.97           C  
ATOM  13048  CG  GLU C 344      15.159  56.610  37.252  1.00 54.43           C  
ATOM  13049  CD  GLU C 344      13.697  56.769  37.592  1.00 61.23           C  
ATOM  13050  OE1 GLU C 344      13.209  57.916  37.724  1.00 63.35           O  
ATOM  13051  OE2 GLU C 344      12.998  55.742  37.708  1.00 66.22           O  
ATOM  13052  N   LYS C 345      15.564  57.412  32.624  1.00 41.90           N  
ATOM  13053  CA  LYS C 345      15.868  58.285  31.499  1.00 43.49           C  
ATOM  13054  C   LYS C 345      15.491  57.658  30.170  1.00 43.19           C  
ATOM  13055  O   LYS C 345      15.676  56.459  29.922  1.00 42.75           O  
ATOM  13056  CB  LYS C 345      17.364  58.621  31.569  1.00 44.35           C  
ATOM  13057  CG  LYS C 345      17.773  59.518  32.721  1.00 45.43           C  
ATOM  13058  CD  LYS C 345      19.211  59.992  32.590  1.00 52.84           C  
ATOM  13059  CE  LYS C 345      19.332  61.509  32.608  1.00 57.07           C  
ATOM  13060  NZ  LYS C 345      19.017  62.117  33.940  1.00 57.71           N  
ATOM  13061  N   PHE C 346      14.898  58.477  29.306  1.00 41.25           N  
ATOM  13062  CA  PHE C 346      14.448  58.044  27.994  1.00 41.47           C  
ATOM  13063  C   PHE C 346      15.229  58.773  26.901  1.00 42.06           C  
ATOM  13064  O   PHE C 346      15.100  58.532  25.700  1.00 41.19           O  
ATOM  13065  CB  PHE C 346      12.954  58.348  27.847  1.00 37.69           C  
ATOM  13066  CG  PHE C 346      11.964  57.375  28.417  1.00 36.25           C  
ATOM  13067  CD1 PHE C 346      12.251  56.530  29.477  1.00 33.82           C  
ATOM  13068  CD2 PHE C 346      10.686  57.282  27.860  1.00 37.33           C  
ATOM  13069  CE1 PHE C 346      11.347  55.630  29.974  1.00 33.68           C  
ATOM  13070  CE2 PHE C 346       9.757  56.377  28.330  1.00 34.54           C  
ATOM  13071  CZ  PHE C 346      10.091  55.566  29.389  1.00 35.02           C  
ATOM  13072  N   SER C 347      16.024  59.747  27.332  1.00 40.13           N  
ATOM  13073  CA  SER C 347      16.758  60.588  26.400  1.00 40.58           C  
ATOM  13074  C   SER C 347      18.158  60.974  26.838  1.00 41.06           C  
ATOM  13075  O   SER C 347      18.446  61.178  28.005  1.00 42.60           O  
ATOM  13076  CB  SER C 347      15.961  61.892  26.245  1.00 42.49           C  
ATOM  13077  OG  SER C 347      16.814  62.940  25.792  1.00 48.06           O  
ATOM  13078  N   LYS C 348      19.037  61.043  25.849  1.00 40.48           N  
ATOM  13079  CA  LYS C 348      20.397  61.516  25.998  1.00 36.66           C  
ATOM  13080  C   LYS C 348      20.526  62.718  25.077  1.00 38.42           C  
ATOM  13081  O   LYS C 348      20.464  62.573  23.845  1.00 37.54           O  
ATOM  13082  CB  LYS C 348      21.414  60.445  25.682  1.00 41.08           C  
ATOM  13083  CG  LYS C 348      22.851  60.921  25.817  1.00 43.38           C  
ATOM  13084  CD  LYS C 348      23.117  61.702  27.092  1.00 42.44           C  
ATOM  13085  CE  LYS C 348      24.561  62.211  27.087  1.00 44.21           C  
ATOM  13086  NZ  LYS C 348      25.141  62.015  28.441  1.00 42.15           N  
ATOM  13087  N   ASP C 349      20.504  63.933  25.624  1.00 36.47           N  
ATOM  13088  CA  ASP C 349      20.581  65.196  24.938  1.00 36.84           C  
ATOM  13089  C   ASP C 349      19.399  65.532  24.036  1.00 38.23           C  
ATOM  13090  O   ASP C 349      19.405  66.476  23.226  1.00 35.91           O  
ATOM  13091  CB  ASP C 349      21.787  65.345  23.999  1.00 38.71           C  
ATOM  13092  CG  ASP C 349      23.121  65.362  24.679  1.00 39.24           C  
ATOM  13093  OD1 ASP C 349      23.315  66.018  25.724  1.00 44.19           O  
ATOM  13094  OD2 ASP C 349      24.078  64.739  24.167  1.00 39.72           O  
ATOM  13095  N   GLU C 350      18.339  64.739  24.097  1.00 37.79           N  
ATOM  13096  CA  GLU C 350      17.219  64.890  23.168  1.00 35.53           C  
ATOM  13097  C   GLU C 350      17.791  64.613  21.770  1.00 35.19           C  
ATOM  13098  O   GLU C 350      17.455  65.283  20.783  1.00 34.59           O  
ATOM  13099  CB  GLU C 350      16.539  66.256  23.300  1.00 33.01           C  
ATOM  13100  CG  GLU C 350      15.705  66.480  24.553  1.00 31.15           C  
ATOM  13101  CD  GLU C 350      16.528  66.702  25.805  1.00 36.72           C  
ATOM  13102  OE1 GLU C 350      17.271  67.696  25.986  1.00 37.46           O  
ATOM  13103  OE2 GLU C 350      16.491  65.881  26.740  1.00 41.31           O  
ATOM  13104  N   ARG C 351      18.702  63.626  21.699  1.00 32.53           N  
ATOM  13105  CA  ARG C 351      19.362  63.267  20.440  1.00 33.81           C  
ATOM  13106  C   ARG C 351      19.260  61.748  20.254  1.00 32.68           C  
ATOM  13107  O   ARG C 351      18.993  61.271  19.172  1.00 31.91           O  
ATOM  13108  CB  ARG C 351      20.826  63.705  20.376  1.00 30.54           C  
ATOM  13109  CG  ARG C 351      20.957  65.199  20.100  1.00 28.07           C  
ATOM  13110  CD  ARG C 351      20.684  65.465  18.620  1.00 30.28           C  
ATOM  13111  NE  ARG C 351      20.622  66.850  18.303  1.00 29.31           N  
ATOM  13112  CZ  ARG C 351      20.542  67.445  17.133  1.00 35.15           C  
ATOM  13113  NH1 ARG C 351      20.495  66.780  15.990  1.00 35.20           N  
ATOM  13114  NH2 ARG C 351      20.504  68.786  17.130  1.00 31.38           N  
ATOM  13115  N   VAL C 352      19.489  61.032  21.353  1.00 31.92           N  
ATOM  13116  CA  VAL C 352      19.382  59.589  21.371  1.00 33.04           C  
ATOM  13117  C   VAL C 352      18.231  59.226  22.305  1.00 35.17           C  
ATOM  13118  O   VAL C 352      18.291  59.551  23.498  1.00 36.02           O  
ATOM  13119  CB  VAL C 352      20.673  58.899  21.851  1.00 35.89           C  
ATOM  13120  CG1 VAL C 352      20.500  57.395  21.786  1.00 30.44           C  
ATOM  13121  CG2 VAL C 352      21.873  59.318  21.003  1.00 33.95           C  
ATOM  13122  N   PHE C 353      17.170  58.623  21.781  1.00 35.31           N  
ATOM  13123  CA  PHE C 353      16.024  58.259  22.605  1.00 32.99           C  
ATOM  13124  C   PHE C 353      15.862  56.754  22.697  1.00 35.82           C  
ATOM  13125  O   PHE C 353      16.329  55.993  21.840  1.00 39.15           O  
ATOM  13126  CB  PHE C 353      14.720  58.770  21.996  1.00 31.17           C  
ATOM  13127  CG  PHE C 353      14.673  60.251  21.790  1.00 32.37           C  
ATOM  13128  CD1 PHE C 353      14.225  61.073  22.830  1.00 29.36           C  
ATOM  13129  CD2 PHE C 353      15.065  60.808  20.598  1.00 28.88           C  
ATOM  13130  CE1 PHE C 353      14.184  62.449  22.667  1.00 26.92           C  
ATOM  13131  CE2 PHE C 353      14.996  62.189  20.414  1.00 30.78           C  
ATOM  13132  CZ  PHE C 353      14.537  62.987  21.454  1.00 29.98           C  
ATOM  13133  N   ILE C 354      15.227  56.308  23.758  1.00 35.69           N  
ATOM  13134  CA  ILE C 354      14.891  54.885  23.824  1.00 35.38           C  
ATOM  13135  C   ILE C 354      13.364  54.876  23.933  1.00 39.24           C  
ATOM  13136  O   ILE C 354      12.749  55.867  24.411  1.00 36.72           O  
ATOM  13137  CB  ILE C 354      15.595  54.106  24.919  1.00 34.26           C  
ATOM  13138  CG1 ILE C 354      15.729  54.923  26.214  1.00 33.19           C  
ATOM  13139  CG2 ILE C 354      17.009  53.719  24.433  1.00 26.99           C  
ATOM  13140  CD1 ILE C 354      16.103  54.053  27.407  1.00 29.52           C  
ATOM  13141  N   ALA C 355      12.778  53.769  23.458  1.00 36.95           N  
ATOM  13142  CA  ALA C 355      11.330  53.643  23.547  1.00 35.55           C  
ATOM  13143  C   ALA C 355      10.952  52.185  23.690  1.00 35.37           C  
ATOM  13144  O   ALA C 355      11.752  51.370  23.214  1.00 36.40           O  
ATOM  13145  CB  ALA C 355      10.730  54.174  22.251  1.00 30.49           C  
ATOM  13146  N   GLY C 356       9.743  51.884  24.159  1.00 33.76           N  
ATOM  13147  CA  GLY C 356       9.280  50.508  24.178  1.00 33.19           C  
ATOM  13148  C   GLY C 356       9.867  49.604  25.237  1.00 31.75           C  
ATOM  13149  O   GLY C 356      10.098  50.036  26.363  1.00 32.70           O  
ATOM  13150  N   ASP C 357      10.112  48.328  24.954  1.00 32.23           N  
ATOM  13151  CA  ASP C 357      10.633  47.400  25.944  1.00 33.14           C  
ATOM  13152  C   ASP C 357      12.013  47.860  26.395  1.00 36.07           C  
ATOM  13153  O   ASP C 357      12.422  47.482  27.473  1.00 36.36           O  
ATOM  13154  CB  ASP C 357      10.764  45.941  25.523  1.00 35.43           C  
ATOM  13155  CG  ASP C 357       9.555  45.060  25.744  1.00 39.66           C  
ATOM  13156  OD1 ASP C 357       8.508  45.573  26.189  1.00 35.57           O  
ATOM  13157  OD2 ASP C 357       9.668  43.836  25.438  1.00 40.29           O  
ATOM  13158  N   ALA C 358      12.774  48.583  25.579  1.00 34.35           N  
ATOM  13159  CA  ALA C 358      14.058  49.143  25.928  1.00 36.91           C  
ATOM  13160  C   ALA C 358      13.959  49.955  27.227  1.00 38.90           C  
ATOM  13161  O   ALA C 358      14.940  49.996  27.985  1.00 40.50           O  
ATOM  13162  CB  ALA C 358      14.596  50.065  24.840  1.00 30.97           C  
ATOM  13163  N   CYS C 359      12.832  50.602  27.483  1.00 37.85           N  
ATOM  13164  CA  CYS C 359      12.576  51.393  28.648  1.00 39.82           C  
ATOM  13165  C   CYS C 359      11.748  50.767  29.775  1.00 39.29           C  
ATOM  13166  O   CYS C 359      11.801  51.257  30.917  1.00 40.56           O  
ATOM  13167  CB  CYS C 359      11.688  52.584  28.249  1.00 34.74           C  
ATOM  13168  SG  CYS C 359      12.359  53.710  27.046  1.00 38.46           S  
ATOM  13169  N   HIS C 360      10.900  49.801  29.453  1.00 36.63           N  
ATOM  13170  CA  HIS C 360      10.036  49.192  30.450  1.00 35.94           C  
ATOM  13171  C   HIS C 360       9.732  47.747  30.123  1.00 36.64           C  
ATOM  13172  O   HIS C 360       9.328  47.406  29.001  1.00 37.54           O  
ATOM  13173  CB  HIS C 360       8.714  49.992  30.608  1.00 33.79           C  
ATOM  13174  CG  HIS C 360       8.144  50.402  29.278  1.00 33.40           C  
ATOM  13175  ND1 HIS C 360       7.568  49.507  28.422  1.00 37.74           N  
ATOM  13176  CD2 HIS C 360       8.078  51.606  28.643  1.00 32.86           C  
ATOM  13177  CE1 HIS C 360       7.167  50.117  27.338  1.00 35.94           C  
ATOM  13178  NE2 HIS C 360       7.470  51.406  27.432  1.00 36.06           N  
ATOM  13179  N   THR C 361       9.975  46.849  31.081  1.00 37.53           N  
ATOM  13180  CA  THR C 361       9.649  45.432  30.814  1.00 37.64           C  
ATOM  13181  C   THR C 361       8.833  44.993  32.019  1.00 37.50           C  
ATOM  13182  O   THR C 361       8.932  45.595  33.072  1.00 36.50           O  
ATOM  13183  CB  THR C 361      10.757  44.439  30.517  1.00 37.26           C  
ATOM  13184  OG1 THR C 361      11.807  44.577  31.496  1.00 36.91           O  
ATOM  13185  CG2 THR C 361      11.303  44.716  29.118  1.00 36.45           C  
ATOM  13186  N   HIS C 362       7.914  44.072  31.776  1.00 37.15           N  
ATOM  13187  CA  HIS C 362       6.942  43.664  32.791  1.00 37.79           C  
ATOM  13188  C   HIS C 362       6.232  42.423  32.307  1.00 38.27           C  
ATOM  13189  O   HIS C 362       6.487  42.019  31.164  1.00 38.86           O  
ATOM  13190  CB  HIS C 362       5.943  44.820  32.964  1.00 31.17           C  
ATOM  13191  CG  HIS C 362       5.456  45.290  31.624  1.00 37.14           C  
ATOM  13192  ND1 HIS C 362       4.588  44.584  30.853  1.00 35.03           N  
ATOM  13193  CD2 HIS C 362       5.775  46.399  30.912  1.00 35.21           C  
ATOM  13194  CE1 HIS C 362       4.352  45.240  29.733  1.00 36.15           C  
ATOM  13195  NE2 HIS C 362       5.076  46.353  29.743  1.00 37.35           N  
ATOM  13196  N   SER C 363       5.315  41.856  33.079  1.00 37.65           N  
ATOM  13197  CA  SER C 363       4.638  40.653  32.596  1.00 37.89           C  
ATOM  13198  C   SER C 363       3.552  40.984  31.584  1.00 36.40           C  
ATOM  13199  O   SER C 363       3.076  42.103  31.441  1.00 36.10           O  
ATOM  13200  CB  SER C 363       3.974  39.876  33.748  1.00 39.22           C  
ATOM  13201  OG  SER C 363       2.764  40.534  34.081  1.00 35.62           O  
ATOM  13202  N   PRO C 364       3.091  39.973  30.872  1.00 36.39           N  
ATOM  13203  CA  PRO C 364       2.058  40.076  29.877  1.00 36.99           C  
ATOM  13204  C   PRO C 364       0.657  39.854  30.409  1.00 38.21           C  
ATOM  13205  O   PRO C 364      -0.274  39.710  29.605  1.00 37.71           O  
ATOM  13206  CB  PRO C 364       2.342  38.921  28.912  1.00 35.32           C  
ATOM  13207  CG  PRO C 364       2.988  37.877  29.776  1.00 35.77           C  
ATOM  13208  CD  PRO C 364       3.629  38.579  30.939  1.00 35.11           C  
ATOM  13209  N   LYS C 365       0.424  39.873  31.720  1.00 37.97           N  
ATOM  13210  CA  LYS C 365      -0.911  39.636  32.283  1.00 36.19           C  
ATOM  13211  C   LYS C 365      -1.953  40.625  31.804  1.00 36.51           C  
ATOM  13212  O   LYS C 365      -3.167  40.330  31.725  1.00 38.01           O  
ATOM  13213  CB  LYS C 365      -0.807  39.588  33.799  1.00 37.38           C  
ATOM  13214  CG  LYS C 365      -0.275  38.337  34.498  1.00 34.05           C  
ATOM  13215  CD  LYS C 365      -0.883  37.069  33.933  1.00 35.21           C  
ATOM  13216  CE  LYS C 365       0.056  36.433  32.919  1.00 37.26           C  
ATOM  13217  NZ  LYS C 365       1.341  35.980  33.520  1.00 34.99           N  
ATOM  13218  N   ALA C 366      -1.577  41.836  31.432  1.00 36.52           N  
ATOM  13219  CA  ALA C 366      -2.548  42.803  30.919  1.00 35.69           C  
ATOM  13220  C   ALA C 366      -2.157  43.187  29.497  1.00 33.42           C  
ATOM  13221  O   ALA C 366      -2.658  44.174  28.974  1.00 33.32           O  
ATOM  13222  CB  ALA C 366      -2.660  43.917  31.924  1.00 23.27           C  
ATOM  13223  N   GLY C 367      -1.353  42.378  28.820  1.00 34.35           N  
ATOM  13224  CA  GLY C 367      -0.922  42.669  27.461  1.00 32.28           C  
ATOM  13225  C   GLY C 367      -0.740  44.167  27.217  1.00 34.81           C  
ATOM  13226  O   GLY C 367      -1.446  44.785  26.425  1.00 35.68           O  
ATOM  13227  N   GLN C 368       0.258  44.753  27.855  1.00 33.63           N  
ATOM  13228  CA  GLN C 368       0.578  46.156  27.768  1.00 32.54           C  
ATOM  13229  C   GLN C 368       1.804  46.521  26.956  1.00 32.95           C  
ATOM  13230  O   GLN C 368       1.932  47.695  26.591  1.00 30.70           O  
ATOM  13231  CB  GLN C 368       0.841  46.651  29.217  1.00 33.84           C  
ATOM  13232  CG  GLN C 368      -0.379  46.539  30.126  1.00 33.42           C  
ATOM  13233  CD  GLN C 368      -1.444  47.535  29.706  1.00 38.60           C  
ATOM  13234  OE1 GLN C 368      -1.419  48.697  30.113  1.00 36.70           O  
ATOM  13235  NE2 GLN C 368      -2.358  47.077  28.867  1.00 36.15           N  
ATOM  13236  N   GLY C 369       2.726  45.588  26.734  1.00 32.58           N  
ATOM  13237  CA  GLY C 369       3.982  45.877  26.070  1.00 34.31           C  
ATOM  13238  C   GLY C 369       3.920  46.544  24.710  1.00 33.77           C  
ATOM  13239  O   GLY C 369       4.339  47.698  24.524  1.00 33.36           O  
ATOM  13240  N   MET C 370       3.432  45.797  23.707  1.00 31.84           N  
ATOM  13241  CA  MET C 370       3.326  46.326  22.349  1.00 31.93           C  
ATOM  13242  C   MET C 370       2.495  47.604  22.406  1.00 32.25           C  
ATOM  13243  O   MET C 370       2.887  48.566  21.742  1.00 34.01           O  
ATOM  13244  CB  MET C 370       2.750  45.298  21.384  1.00 27.40           C  
ATOM  13245  CG  MET C 370       2.117  45.842  20.122  1.00 27.00           C  
ATOM  13246  SD  MET C 370       1.652  44.503  19.003  1.00 32.86           S  
ATOM  13247  CE  MET C 370       0.194  43.852  19.867  1.00 29.26           C  
ATOM  13248  N   ASN C 371       1.415  47.632  23.201  1.00 31.23           N  
ATOM  13249  CA  ASN C 371       0.619  48.852  23.290  1.00 32.96           C  
ATOM  13250  C   ASN C 371       1.425  50.069  23.729  1.00 31.05           C  
ATOM  13251  O   ASN C 371       1.490  51.095  23.049  1.00 32.03           O  
ATOM  13252  CB  ASN C 371      -0.546  48.709  24.313  1.00 32.50           C  
ATOM  13253  CG  ASN C 371      -1.644  47.824  23.776  1.00 30.75           C  
ATOM  13254  OD1 ASN C 371      -2.346  48.155  22.831  1.00 29.67           O  
ATOM  13255  ND2 ASN C 371      -1.772  46.667  24.395  1.00 33.51           N  
ATOM  13256  N   THR C 372       2.025  49.951  24.897  1.00 29.80           N  
ATOM  13257  CA  THR C 372       2.807  51.063  25.462  1.00 32.03           C  
ATOM  13258  C   THR C 372       3.953  51.472  24.539  1.00 31.51           C  
ATOM  13259  O   THR C 372       4.153  52.667  24.310  1.00 28.03           O  
ATOM  13260  CB  THR C 372       3.345  50.678  26.863  1.00 35.35           C  
ATOM  13261  OG1 THR C 372       2.256  50.256  27.700  1.00 34.82           O  
ATOM  13262  CG2 THR C 372       4.086  51.830  27.483  1.00 30.15           C  
ATOM  13263  N   SER C 373       4.651  50.484  23.998  1.00 28.64           N  
ATOM  13264  CA  SER C 373       5.790  50.693  23.097  1.00 29.25           C  
ATOM  13265  C   SER C 373       5.379  51.393  21.816  1.00 28.18           C  
ATOM  13266  O   SER C 373       6.087  52.324  21.417  1.00 28.78           O  
ATOM  13267  CB  SER C 373       6.508  49.376  22.786  1.00 28.52           C  
ATOM  13268  OG  SER C 373       6.848  48.636  23.964  1.00 27.60           O  
ATOM  13269  N   MET C 374       4.234  51.111  21.207  1.00 27.25           N  
ATOM  13270  CA  MET C 374       3.802  51.903  20.059  1.00 28.26           C  
ATOM  13271  C   MET C 374       3.370  53.306  20.468  1.00 26.81           C  
ATOM  13272  O   MET C 374       3.578  54.316  19.771  1.00 25.83           O  
ATOM  13273  CB  MET C 374       2.695  51.167  19.279  1.00 28.70           C  
ATOM  13274  CG  MET C 374       3.154  49.829  18.686  1.00 28.00           C  
ATOM  13275  SD  MET C 374       2.051  49.265  17.355  1.00 36.39           S  
ATOM  13276  CE  MET C 374       0.559  48.943  18.216  1.00 25.76           C  
ATOM  13277  N   MET C 375       2.763  53.444  21.649  1.00 26.37           N  
ATOM  13278  CA  MET C 375       2.281  54.755  22.113  1.00 27.91           C  
ATOM  13279  C   MET C 375       3.486  55.617  22.447  1.00 31.06           C  
ATOM  13280  O   MET C 375       3.398  56.830  22.217  1.00 32.28           O  
ATOM  13281  CB  MET C 375       1.243  54.663  23.224  1.00 25.98           C  
ATOM  13282  CG  MET C 375      -0.046  53.957  22.778  1.00 22.88           C  
ATOM  13283  SD  MET C 375      -0.890  54.850  21.466  1.00 26.71           S  
ATOM  13284  CE  MET C 375      -0.251  53.957  20.032  1.00 25.52           C  
ATOM  13285  N   ASP C 376       4.604  55.038  22.859  1.00 27.70           N  
ATOM  13286  CA  ASP C 376       5.825  55.810  23.091  1.00 30.48           C  
ATOM  13287  C   ASP C 376       6.293  56.474  21.797  1.00 31.49           C  
ATOM  13288  O   ASP C 376       6.485  57.692  21.742  1.00 33.26           O  
ATOM  13289  CB  ASP C 376       6.937  54.906  23.644  1.00 30.53           C  
ATOM  13290  CG  ASP C 376       6.769  54.465  25.078  1.00 33.30           C  
ATOM  13291  OD1 ASP C 376       6.010  55.119  25.851  1.00 33.79           O  
ATOM  13292  OD2 ASP C 376       7.381  53.467  25.531  1.00 31.69           O  
ATOM  13293  N   THR C 377       6.431  55.740  20.694  1.00 31.54           N  
ATOM  13294  CA  THR C 377       6.936  56.346  19.465  1.00 31.98           C  
ATOM  13295  C   THR C 377       5.856  57.123  18.732  1.00 32.28           C  
ATOM  13296  O   THR C 377       6.176  58.001  17.921  1.00 31.15           O  
ATOM  13297  CB  THR C 377       7.633  55.349  18.515  1.00 30.40           C  
ATOM  13298  OG1 THR C 377       6.812  54.214  18.323  1.00 28.31           O  
ATOM  13299  CG2 THR C 377       8.941  54.852  19.103  1.00 30.31           C  
ATOM  13300  N   TYR C 378       4.588  56.878  19.070  1.00 31.54           N  
ATOM  13301  CA  TYR C 378       3.494  57.708  18.543  1.00 30.97           C  
ATOM  13302  C   TYR C 378       3.635  59.105  19.135  1.00 30.74           C  
ATOM  13303  O   TYR C 378       3.383  60.125  18.485  1.00 28.64           O  
ATOM  13304  CB  TYR C 378       2.146  57.101  18.864  1.00 29.39           C  
ATOM  13305  CG  TYR C 378       0.911  57.741  18.291  1.00 30.79           C  
ATOM  13306  CD1 TYR C 378       0.524  57.540  16.974  1.00 27.64           C  
ATOM  13307  CD2 TYR C 378       0.094  58.525  19.102  1.00 29.03           C  
ATOM  13308  CE1 TYR C 378      -0.616  58.129  16.481  1.00 28.41           C  
ATOM  13309  CE2 TYR C 378      -1.110  59.049  18.622  1.00 27.01           C  
ATOM  13310  CZ  TYR C 378      -1.435  58.876  17.304  1.00 30.73           C  
ATOM  13311  OH  TYR C 378      -2.578  59.454  16.790  1.00 31.01           O  
ATOM  13312  N   ASN C 379       4.047  59.148  20.398  1.00 31.01           N  
ATOM  13313  CA  ASN C 379       4.300  60.391  21.100  1.00 30.72           C  
ATOM  13314  C   ASN C 379       5.580  61.053  20.585  1.00 32.43           C  
ATOM  13315  O   ASN C 379       5.526  62.183  20.076  1.00 29.66           O  
ATOM  13316  CB  ASN C 379       4.409  60.124  22.587  1.00 28.44           C  
ATOM  13317  CG  ASN C 379       4.621  61.396  23.391  1.00 35.81           C  
ATOM  13318  OD1 ASN C 379       5.706  61.991  23.359  1.00 35.29           O  
ATOM  13319  ND2 ASN C 379       3.575  61.767  24.137  1.00 32.86           N  
ATOM  13320  N   LEU C 380       6.713  60.335  20.632  1.00 31.25           N  
ATOM  13321  CA  LEU C 380       7.976  60.906  20.146  1.00 32.33           C  
ATOM  13322  C   LEU C 380       7.946  61.330  18.696  1.00 32.06           C  
ATOM  13323  O   LEU C 380       8.365  62.395  18.270  1.00 33.71           O  
ATOM  13324  CB  LEU C 380       9.110  59.914  20.394  1.00 31.25           C  
ATOM  13325  CG  LEU C 380      10.499  60.299  19.911  1.00 34.22           C  
ATOM  13326  CD1 LEU C 380      10.965  61.643  20.475  1.00 28.13           C  
ATOM  13327  CD2 LEU C 380      11.509  59.178  20.207  1.00 25.65           C  
ATOM  13328  N   GLY C 381       7.403  60.502  17.820  1.00 33.67           N  
ATOM  13329  CA  GLY C 381       7.314  60.688  16.398  1.00 29.94           C  
ATOM  13330  C   GLY C 381       6.870  62.022  15.888  1.00 31.78           C  
ATOM  13331  O   GLY C 381       7.497  62.539  14.971  1.00 32.20           O  
ATOM  13332  N   TRP C 382       5.723  62.539  16.362  1.00 29.82           N  
ATOM  13333  CA  TRP C 382       5.257  63.822  15.883  1.00 29.72           C  
ATOM  13334  C   TRP C 382       6.180  64.945  16.354  1.00 28.93           C  
ATOM  13335  O   TRP C 382       6.286  65.890  15.603  1.00 33.67           O  
ATOM  13336  CB  TRP C 382       3.824  64.094  16.273  1.00 32.21           C  
ATOM  13337  CG  TRP C 382       3.472  64.483  17.677  1.00 27.03           C  
ATOM  13338  CD1 TRP C 382       3.059  63.604  18.639  1.00 28.39           C  
ATOM  13339  CD2 TRP C 382       3.489  65.758  18.291  1.00 27.97           C  
ATOM  13340  NE1 TRP C 382       2.810  64.259  19.813  1.00 26.43           N  
ATOM  13341  CE2 TRP C 382       3.035  65.599  19.621  1.00 29.22           C  
ATOM  13342  CE3 TRP C 382       3.832  67.053  17.857  1.00 29.57           C  
ATOM  13343  CZ2 TRP C 382       2.913  66.666  20.534  1.00 27.20           C  
ATOM  13344  CZ3 TRP C 382       3.708  68.118  18.735  1.00 27.95           C  
ATOM  13345  CH2 TRP C 382       3.272  67.900  20.069  1.00 27.32           C  
ATOM  13346  N   LYS C 383       6.781  64.851  17.509  1.00 29.98           N  
ATOM  13347  CA  LYS C 383       7.665  65.883  18.033  1.00 32.91           C  
ATOM  13348  C   LYS C 383       8.949  65.955  17.204  1.00 32.65           C  
ATOM  13349  O   LYS C 383       9.225  67.008  16.640  1.00 30.68           O  
ATOM  13350  CB  LYS C 383       7.907  65.632  19.518  1.00 31.40           C  
ATOM  13351  CG  LYS C 383       6.571  65.669  20.301  1.00 31.25           C  
ATOM  13352  CD  LYS C 383       6.722  65.017  21.672  1.00 27.62           C  
ATOM  13353  CE  LYS C 383       5.473  65.146  22.517  1.00 28.72           C  
ATOM  13354  NZ  LYS C 383       5.682  64.581  23.881  1.00 29.83           N  
ATOM  13355  N   LEU C 384       9.533  64.802  16.932  1.00 31.53           N  
ATOM  13356  CA  LEU C 384      10.677  64.680  16.044  1.00 32.82           C  
ATOM  13357  C   LEU C 384      10.343  65.126  14.643  1.00 32.11           C  
ATOM  13358  O   LEU C 384      11.083  65.879  14.010  1.00 29.74           O  
ATOM  13359  CB  LEU C 384      11.180  63.227  16.095  1.00 36.05           C  
ATOM  13360  CG  LEU C 384      12.656  62.976  15.891  1.00 44.57           C  
ATOM  13361  CD1 LEU C 384      13.539  63.958  16.676  1.00 44.30           C  
ATOM  13362  CD2 LEU C 384      13.006  61.525  16.222  1.00 42.81           C  
ATOM  13363  N   GLY C 385       9.162  64.741  14.146  1.00 29.82           N  
ATOM  13364  CA  GLY C 385       8.786  65.140  12.789  1.00 30.67           C  
ATOM  13365  C   GLY C 385       8.696  66.641  12.619  1.00 33.22           C  
ATOM  13366  O   GLY C 385       9.082  67.160  11.550  1.00 33.17           O  
ATOM  13367  N   LEU C 386       8.124  67.345  13.612  1.00 30.74           N  
ATOM  13368  CA  LEU C 386       7.940  68.786  13.488  1.00 29.56           C  
ATOM  13369  C   LEU C 386       9.295  69.500  13.586  1.00 29.39           C  
ATOM  13370  O   LEU C 386       9.560  70.484  12.888  1.00 28.60           O  
ATOM  13371  CB  LEU C 386       6.901  69.340  14.448  1.00 30.71           C  
ATOM  13372  CG  LEU C 386       5.445  68.902  14.218  1.00 33.27           C  
ATOM  13373  CD1 LEU C 386       4.534  69.564  15.236  1.00 30.60           C  
ATOM  13374  CD2 LEU C 386       4.996  69.211  12.789  1.00 26.37           C  
ATOM  13375  N   VAL C 387      10.135  68.971  14.449  1.00 29.13           N  
ATOM  13376  CA  VAL C 387      11.494  69.462  14.594  1.00 33.27           C  
ATOM  13377  C   VAL C 387      12.233  69.288  13.262  1.00 35.49           C  
ATOM  13378  O   VAL C 387      12.645  70.296  12.669  1.00 35.98           O  
ATOM  13379  CB  VAL C 387      12.245  68.788  15.739  1.00 33.04           C  
ATOM  13380  CG1 VAL C 387      13.739  69.094  15.674  1.00 31.88           C  
ATOM  13381  CG2 VAL C 387      11.672  69.316  17.063  1.00 32.02           C  
ATOM  13382  N   LEU C 388      12.218  68.060  12.726  1.00 34.33           N  
ATOM  13383  CA  LEU C 388      12.905  67.763  11.489  1.00 35.46           C  
ATOM  13384  C   LEU C 388      12.440  68.541  10.278  1.00 36.29           C  
ATOM  13385  O   LEU C 388      13.310  68.749   9.434  1.00 37.70           O  
ATOM  13386  CB  LEU C 388      12.865  66.271  11.088  1.00 35.42           C  
ATOM  13387  CG  LEU C 388      13.748  65.434  12.028  1.00 36.00           C  
ATOM  13388  CD1 LEU C 388      13.412  63.957  11.840  1.00 40.22           C  
ATOM  13389  CD2 LEU C 388      15.209  65.726  11.791  1.00 39.69           C  
ATOM  13390  N   THR C 389      11.161  68.920  10.198  1.00 35.76           N  
ATOM  13391  CA  THR C 389      10.725  69.708   9.048  1.00 32.39           C  
ATOM  13392  C   THR C 389      10.809  71.198   9.292  1.00 31.05           C  
ATOM  13393  O   THR C 389      10.217  71.985   8.549  1.00 30.34           O  
ATOM  13394  CB  THR C 389       9.274  69.306   8.694  1.00 34.98           C  
ATOM  13395  OG1 THR C 389       8.440  69.403   9.860  1.00 33.18           O  
ATOM  13396  CG2 THR C 389       9.262  67.872   8.157  1.00 32.10           C  
ATOM  13397  N   GLY C 390      11.469  71.613  10.370  1.00 30.98           N  
ATOM  13398  CA  GLY C 390      11.593  73.038  10.698  1.00 34.20           C  
ATOM  13399  C   GLY C 390      10.285  73.690  11.159  1.00 35.32           C  
ATOM  13400  O   GLY C 390      10.094  74.910  11.019  1.00 35.09           O  
ATOM  13401  N   ARG C 391       9.346  72.901  11.649  1.00 34.47           N  
ATOM  13402  CA  ARG C 391       8.040  73.464  12.014  1.00 37.72           C  
ATOM  13403  C   ARG C 391       7.881  73.733  13.507  1.00 35.54           C  
ATOM  13404  O   ARG C 391       7.038  74.546  13.857  1.00 36.06           O  
ATOM  13405  CB  ARG C 391       6.967  72.497  11.506  1.00 35.33           C  
ATOM  13406  CG  ARG C 391       6.628  72.754  10.048  1.00 34.10           C  
ATOM  13407  CD  ARG C 391       5.972  71.565   9.385  1.00 35.76           C  
ATOM  13408  NE  ARG C 391       4.695  71.233  10.006  1.00 40.49           N  
ATOM  13409  CZ  ARG C 391       3.814  70.326   9.586  1.00 44.27           C  
ATOM  13410  NH1 ARG C 391       4.019  69.582   8.508  1.00 37.44           N  
ATOM  13411  NH2 ARG C 391       2.701  70.182  10.304  1.00 40.07           N  
ATOM  13412  N   ALA C 392       8.684  73.061  14.329  1.00 34.27           N  
ATOM  13413  CA  ALA C 392       8.604  73.211  15.762  1.00 37.86           C  
ATOM  13414  C   ALA C 392      10.012  73.349  16.342  1.00 39.12           C  
ATOM  13415  O   ALA C 392      10.984  72.935  15.720  1.00 40.57           O  
ATOM  13416  CB  ALA C 392       7.912  72.008  16.399  1.00 34.50           C  
ATOM  13417  N   LYS C 393      10.074  73.941  17.516  1.00 39.25           N  
ATOM  13418  CA  LYS C 393      11.352  74.143  18.188  1.00 37.56           C  
ATOM  13419  C   LYS C 393      11.818  72.881  18.854  1.00 35.44           C  
ATOM  13420  O   LYS C 393      11.007  72.136  19.384  1.00 39.55           O  
ATOM  13421  CB  LYS C 393      11.140  75.254  19.222  1.00 42.04           C  
ATOM  13422  CG  LYS C 393      10.498  76.489  18.625  1.00 42.71           C  
ATOM  13423  CD  LYS C 393      10.238  77.508  19.744  1.00 46.33           C  
ATOM  13424  CE  LYS C 393       9.272  78.567  19.256  1.00 49.06           C  
ATOM  13425  NZ  LYS C 393       9.703  79.942  19.638  1.00 54.31           N  
ATOM  13426  N   ARG C 394      13.109  72.710  19.019  1.00 37.11           N  
ATOM  13427  CA  ARG C 394      13.738  71.532  19.591  1.00 36.15           C  
ATOM  13428  C   ARG C 394      13.352  71.258  21.022  1.00 37.01           C  
ATOM  13429  O   ARG C 394      13.368  70.085  21.435  1.00 38.15           O  
ATOM  13430  CB  ARG C 394      15.267  71.642  19.442  1.00 35.27           C  
ATOM  13431  CG  ARG C 394      15.891  70.397  18.834  1.00 39.20           C  
ATOM  13432  CD  ARG C 394      17.396  70.389  18.880  1.00 37.32           C  
ATOM  13433  NE  ARG C 394      17.951  70.107  20.219  1.00 36.58           N  
ATOM  13434  CZ  ARG C 394      18.151  68.864  20.634  1.00 37.83           C  
ATOM  13435  NH1 ARG C 394      17.853  67.835  19.835  1.00 36.95           N  
ATOM  13436  NH2 ARG C 394      18.664  68.682  21.842  1.00 35.65           N  
ATOM  13437  N   ASP C 395      12.979  72.262  21.793  1.00 36.85           N  
ATOM  13438  CA  ASP C 395      12.552  72.123  23.172  1.00 39.01           C  
ATOM  13439  C   ASP C 395      11.351  71.203  23.334  1.00 38.81           C  
ATOM  13440  O   ASP C 395      11.287  70.539  24.373  1.00 37.69           O  
ATOM  13441  CB  ASP C 395      12.250  73.468  23.844  1.00 45.02           C  
ATOM  13442  CG  ASP C 395      13.497  74.272  24.162  1.00 53.10           C  
ATOM  13443  OD1 ASP C 395      14.612  73.704  24.262  1.00 55.90           O  
ATOM  13444  OD2 ASP C 395      13.394  75.509  24.303  1.00 53.14           O  
ATOM  13445  N   ILE C 396      10.471  71.029  22.355  1.00 36.55           N  
ATOM  13446  CA  ILE C 396       9.368  70.089  22.527  1.00 37.83           C  
ATOM  13447  C   ILE C 396       9.848  68.655  22.687  1.00 37.87           C  
ATOM  13448  O   ILE C 396       9.153  67.879  23.366  1.00 37.25           O  
ATOM  13449  CB  ILE C 396       8.304  70.159  21.434  1.00 37.74           C  
ATOM  13450  CG1 ILE C 396       8.826  69.653  20.083  1.00 39.59           C  
ATOM  13451  CG2 ILE C 396       7.804  71.599  21.301  1.00 35.89           C  
ATOM  13452  CD1 ILE C 396       7.707  69.507  19.064  1.00 42.02           C  
ATOM  13453  N   LEU C 397      11.071  68.300  22.277  1.00 37.15           N  
ATOM  13454  CA  LEU C 397      11.578  66.951  22.460  1.00 37.09           C  
ATOM  13455  C   LEU C 397      11.700  66.565  23.915  1.00 36.55           C  
ATOM  13456  O   LEU C 397      11.551  65.395  24.277  1.00 38.81           O  
ATOM  13457  CB  LEU C 397      12.858  66.667  21.674  1.00 36.53           C  
ATOM  13458  CG  LEU C 397      12.801  66.913  20.162  1.00 37.83           C  
ATOM  13459  CD1 LEU C 397      14.184  66.911  19.534  1.00 36.77           C  
ATOM  13460  CD2 LEU C 397      11.925  65.876  19.472  1.00 36.39           C  
ATOM  13461  N   LYS C 398      11.876  67.496  24.839  1.00 40.53           N  
ATOM  13462  CA  LYS C 398      11.928  67.202  26.269  1.00 37.87           C  
ATOM  13463  C   LYS C 398      10.611  66.631  26.756  1.00 36.31           C  
ATOM  13464  O   LYS C 398      10.596  65.861  27.723  1.00 36.74           O  
ATOM  13465  CB  LYS C 398      12.234  68.486  27.024  1.00 43.47           C  
ATOM  13466  CG  LYS C 398      13.683  68.937  26.951  1.00 47.39           C  
ATOM  13467  CD  LYS C 398      13.823  70.353  27.510  1.00 50.06           C  
ATOM  13468  CE  LYS C 398      15.262  70.838  27.466  1.00 54.91           C  
ATOM  13469  NZ  LYS C 398      15.391  72.048  26.623  1.00 55.52           N  
ATOM  13470  N   THR C 399       9.486  67.022  26.131  1.00 34.09           N  
ATOM  13471  CA  THR C 399       8.190  66.495  26.536  1.00 35.14           C  
ATOM  13472  C   THR C 399       8.033  65.002  26.293  1.00 36.77           C  
ATOM  13473  O   THR C 399       7.238  64.404  27.043  1.00 35.90           O  
ATOM  13474  CB  THR C 399       7.011  67.282  25.934  1.00 37.71           C  
ATOM  13475  OG1 THR C 399       6.864  67.050  24.543  1.00 33.96           O  
ATOM  13476  CG2 THR C 399       7.227  68.788  26.135  1.00 30.81           C  
ATOM  13477  N   TYR C 400       8.821  64.370  25.407  1.00 34.64           N  
ATOM  13478  CA  TYR C 400       8.746  62.940  25.246  1.00 34.38           C  
ATOM  13479  C   TYR C 400       8.973  62.234  26.576  1.00 34.82           C  
ATOM  13480  O   TYR C 400       8.139  61.475  27.070  1.00 36.78           O  
ATOM  13481  CB  TYR C 400       9.747  62.348  24.237  1.00 31.61           C  
ATOM  13482  CG  TYR C 400       9.849  60.842  24.233  1.00 28.13           C  
ATOM  13483  CD1 TYR C 400       8.744  60.027  24.020  1.00 28.40           C  
ATOM  13484  CD2 TYR C 400      11.074  60.231  24.480  1.00 27.60           C  
ATOM  13485  CE1 TYR C 400       8.861  58.647  24.007  1.00 27.09           C  
ATOM  13486  CE2 TYR C 400      11.197  58.850  24.483  1.00 31.00           C  
ATOM  13487  CZ  TYR C 400      10.090  58.055  24.247  1.00 32.34           C  
ATOM  13488  OH  TYR C 400      10.206  56.676  24.269  1.00 32.84           O  
ATOM  13489  N   GLU C 401      10.165  62.473  27.130  1.00 35.51           N  
ATOM  13490  CA  GLU C 401      10.486  61.863  28.415  1.00 37.46           C  
ATOM  13491  C   GLU C 401       9.570  62.337  29.533  1.00 36.01           C  
ATOM  13492  O   GLU C 401       9.199  61.550  30.398  1.00 37.57           O  
ATOM  13493  CB  GLU C 401      11.953  62.156  28.777  1.00 35.34           C  
ATOM  13494  CG  GLU C 401      12.330  61.428  30.055  1.00 40.34           C  
ATOM  13495  CD  GLU C 401      13.741  61.712  30.482  1.00 44.19           C  
ATOM  13496  OE1 GLU C 401      14.638  60.966  30.063  1.00 47.89           O  
ATOM  13497  OE2 GLU C 401      13.948  62.674  31.245  1.00 46.77           O  
ATOM  13498  N   GLU C 402       9.227  63.613  29.577  1.00 35.19           N  
ATOM  13499  CA  GLU C 402       8.327  64.128  30.610  1.00 36.85           C  
ATOM  13500  C   GLU C 402       6.984  63.392  30.624  1.00 37.73           C  
ATOM  13501  O   GLU C 402       6.476  63.134  31.692  1.00 34.06           O  
ATOM  13502  CB  GLU C 402       8.060  65.622  30.444  1.00 32.66           C  
ATOM  13503  CG  GLU C 402       9.212  66.452  30.957  1.00 39.25           C  
ATOM  13504  CD  GLU C 402       9.371  67.819  30.344  1.00 41.35           C  
ATOM  13505  OE1 GLU C 402       8.524  68.397  29.628  1.00 41.97           O  
ATOM  13506  OE2 GLU C 402      10.474  68.379  30.590  1.00 51.20           O  
ATOM  13507  N   GLU C 403       6.435  63.097  29.445  1.00 35.82           N  
ATOM  13508  CA  GLU C 403       5.178  62.390  29.340  1.00 34.25           C  
ATOM  13509  C   GLU C 403       5.310  60.888  29.433  1.00 36.31           C  
ATOM  13510  O   GLU C 403       4.577  60.283  30.223  1.00 37.52           O  
ATOM  13511  CB  GLU C 403       4.488  62.792  28.028  1.00 32.61           C  
ATOM  13512  CG  GLU C 403       4.176  64.281  27.997  1.00 30.24           C  
ATOM  13513  CD  GLU C 403       3.548  64.759  26.720  1.00 32.05           C  
ATOM  13514  OE1 GLU C 403       3.588  64.093  25.675  1.00 35.93           O  
ATOM  13515  OE2 GLU C 403       2.999  65.886  26.752  1.00 35.86           O  
ATOM  13516  N   ARG C 404       6.254  60.276  28.736  1.00 35.30           N  
ATOM  13517  CA  ARG C 404       6.275  58.814  28.651  1.00 35.03           C  
ATOM  13518  C   ARG C 404       6.970  58.085  29.772  1.00 32.00           C  
ATOM  13519  O   ARG C 404       6.587  56.942  30.044  1.00 31.51           O  
ATOM  13520  CB  ARG C 404       6.835  58.386  27.267  1.00 32.09           C  
ATOM  13521  CG  ARG C 404       6.079  59.004  26.101  1.00 31.26           C  
ATOM  13522  CD  ARG C 404       4.571  58.727  26.155  1.00 34.57           C  
ATOM  13523  NE  ARG C 404       4.282  57.320  26.135  1.00 33.36           N  
ATOM  13524  CZ  ARG C 404       3.155  56.650  26.227  1.00 31.02           C  
ATOM  13525  NH1 ARG C 404       2.003  57.285  26.358  1.00 29.11           N  
ATOM  13526  NH2 ARG C 404       3.149  55.304  26.193  1.00 24.18           N  
ATOM  13527  N   HIS C 405       7.957  58.690  30.435  1.00 35.23           N  
ATOM  13528  CA  HIS C 405       8.637  57.971  31.511  1.00 34.60           C  
ATOM  13529  C   HIS C 405       7.744  57.804  32.733  1.00 36.36           C  
ATOM  13530  O   HIS C 405       7.726  56.725  33.334  1.00 34.78           O  
ATOM  13531  CB  HIS C 405       9.971  58.634  31.862  1.00 39.39           C  
ATOM  13532  CG  HIS C 405      10.364  58.141  33.240  1.00 45.39           C  
ATOM  13533  ND1 HIS C 405       9.900  58.754  34.407  1.00 40.98           N  
ATOM  13534  CD2 HIS C 405      10.986  57.010  33.601  1.00 48.13           C  
ATOM  13535  CE1 HIS C 405      10.341  58.032  35.407  1.00 44.84           C  
ATOM  13536  NE2 HIS C 405      10.975  56.959  34.980  1.00 43.24           N  
ATOM  13537  N   ALA C 406       7.001  58.860  33.105  1.00 35.37           N  
ATOM  13538  CA  ALA C 406       6.083  58.699  34.264  1.00 41.38           C  
ATOM  13539  C   ALA C 406       5.078  57.611  33.925  1.00 39.82           C  
ATOM  13540  O   ALA C 406       4.774  56.719  34.722  1.00 40.82           O  
ATOM  13541  CB  ALA C 406       5.485  60.044  34.662  1.00 38.59           C  
ATOM  13542  N   PHE C 407       4.567  57.575  32.686  1.00 39.49           N  
ATOM  13543  CA  PHE C 407       3.670  56.515  32.285  1.00 39.54           C  
ATOM  13544  C   PHE C 407       4.281  55.115  32.456  1.00 40.85           C  
ATOM  13545  O   PHE C 407       3.612  54.191  32.971  1.00 40.32           O  
ATOM  13546  CB  PHE C 407       3.132  56.734  30.857  1.00 37.15           C  
ATOM  13547  CG  PHE C 407       2.103  55.639  30.625  1.00 39.81           C  
ATOM  13548  CD1 PHE C 407       0.797  55.769  31.076  1.00 34.52           C  
ATOM  13549  CD2 PHE C 407       2.517  54.467  29.991  1.00 35.58           C  
ATOM  13550  CE1 PHE C 407      -0.076  54.721  30.867  1.00 38.27           C  
ATOM  13551  CE2 PHE C 407       1.627  53.445  29.786  1.00 36.88           C  
ATOM  13552  CZ  PHE C 407       0.328  53.570  30.233  1.00 39.80           C  
ATOM  13553  N   ALA C 408       5.560  54.937  32.097  1.00 39.14           N  
ATOM  13554  CA  ALA C 408       6.207  53.632  32.244  1.00 38.33           C  
ATOM  13555  C   ALA C 408       6.300  53.213  33.709  1.00 40.20           C  
ATOM  13556  O   ALA C 408       6.135  52.047  34.074  1.00 39.90           O  
ATOM  13557  CB  ALA C 408       7.572  53.685  31.570  1.00 37.33           C  
ATOM  13558  N   GLN C 409       6.579  54.159  34.610  1.00 40.13           N  
ATOM  13559  CA  GLN C 409       6.630  53.886  36.026  1.00 38.19           C  
ATOM  13560  C   GLN C 409       5.247  53.434  36.495  1.00 35.26           C  
ATOM  13561  O   GLN C 409       5.128  52.378  37.126  1.00 35.93           O  
ATOM  13562  CB  GLN C 409       7.095  55.068  36.895  1.00 37.81           C  
ATOM  13563  CG  GLN C 409       7.152  54.631  38.366  1.00 34.91           C  
ATOM  13564  CD  GLN C 409       8.365  53.757  38.621  1.00 38.72           C  
ATOM  13565  OE1 GLN C 409       9.506  54.132  38.315  1.00 38.58           O  
ATOM  13566  NE2 GLN C 409       8.142  52.548  39.136  1.00 33.61           N  
ATOM  13567  N   ALA C 410       4.186  54.168  36.147  1.00 35.83           N  
ATOM  13568  CA  ALA C 410       2.831  53.699  36.502  1.00 34.29           C  
ATOM  13569  C   ALA C 410       2.544  52.321  35.917  1.00 36.31           C  
ATOM  13570  O   ALA C 410       1.880  51.515  36.559  1.00 39.56           O  
ATOM  13571  CB  ALA C 410       1.723  54.616  36.023  1.00 30.41           C  
ATOM  13572  N   LEU C 411       3.044  52.015  34.717  1.00 37.89           N  
ATOM  13573  CA  LEU C 411       2.853  50.689  34.120  1.00 36.30           C  
ATOM  13574  C   LEU C 411       3.512  49.599  34.939  1.00 35.76           C  
ATOM  13575  O   LEU C 411       2.928  48.551  35.228  1.00 35.40           O  
ATOM  13576  CB  LEU C 411       3.358  50.719  32.675  1.00 34.76           C  
ATOM  13577  CG  LEU C 411       3.600  49.382  31.980  1.00 38.25           C  
ATOM  13578  CD1 LEU C 411       2.328  48.535  32.037  1.00 32.65           C  
ATOM  13579  CD2 LEU C 411       4.078  49.583  30.554  1.00 36.60           C  
ATOM  13580  N   ILE C 412       4.752  49.830  35.349  1.00 36.74           N  
ATOM  13581  CA  ILE C 412       5.504  48.887  36.171  1.00 38.15           C  
ATOM  13582  C   ILE C 412       4.839  48.752  37.537  1.00 41.43           C  
ATOM  13583  O   ILE C 412       4.713  47.630  38.043  1.00 42.00           O  
ATOM  13584  CB  ILE C 412       6.973  49.317  36.285  1.00 40.41           C  
ATOM  13585  CG1 ILE C 412       7.840  48.650  35.188  1.00 35.67           C  
ATOM  13586  CG2 ILE C 412       7.568  49.012  37.651  1.00 34.42           C  
ATOM  13587  CD1 ILE C 412       7.416  49.018  33.784  1.00 32.86           C  
ATOM  13588  N   ASP C 413       4.336  49.852  38.107  1.00 39.43           N  
ATOM  13589  CA  ASP C 413       3.645  49.767  39.385  1.00 42.77           C  
ATOM  13590  C   ASP C 413       2.407  48.876  39.263  1.00 43.09           C  
ATOM  13591  O   ASP C 413       2.221  47.956  40.063  1.00 43.52           O  
ATOM  13592  CB  ASP C 413       3.303  51.139  39.936  1.00 41.13           C  
ATOM  13593  CG  ASP C 413       4.493  51.939  40.388  1.00 45.76           C  
ATOM  13594  OD1 ASP C 413       5.591  51.387  40.598  1.00 44.81           O  
ATOM  13595  OD2 ASP C 413       4.338  53.170  40.519  1.00 51.64           O  
ATOM  13596  N   PHE C 414       1.573  49.115  38.265  1.00 40.87           N  
ATOM  13597  CA  PHE C 414       0.410  48.281  38.051  1.00 40.04           C  
ATOM  13598  C   PHE C 414       0.819  46.826  37.839  1.00 41.54           C  
ATOM  13599  O   PHE C 414       0.322  45.939  38.538  1.00 41.05           O  
ATOM  13600  CB  PHE C 414      -0.418  48.858  36.901  1.00 40.59           C  
ATOM  13601  CG  PHE C 414      -1.328  47.880  36.229  1.00 44.13           C  
ATOM  13602  CD1 PHE C 414      -2.367  47.308  36.908  1.00 43.58           C  
ATOM  13603  CD2 PHE C 414      -1.118  47.512  34.909  1.00 45.40           C  
ATOM  13604  CE1 PHE C 414      -3.199  46.382  36.300  1.00 45.14           C  
ATOM  13605  CE2 PHE C 414      -1.942  46.600  34.284  1.00 45.83           C  
ATOM  13606  CZ  PHE C 414      -2.985  46.038  34.980  1.00 45.96           C  
ATOM  13607  N   ASP C 415       1.752  46.519  36.937  1.00 41.53           N  
ATOM  13608  CA  ASP C 415       2.145  45.136  36.705  1.00 41.65           C  
ATOM  13609  C   ASP C 415       2.739  44.470  37.942  1.00 42.54           C  
ATOM  13610  O   ASP C 415       2.537  43.279  38.197  1.00 40.13           O  
ATOM  13611  CB  ASP C 415       3.146  44.974  35.547  1.00 37.85           C  
ATOM  13612  CG  ASP C 415       3.177  43.523  35.110  1.00 40.87           C  
ATOM  13613  OD1 ASP C 415       2.137  43.039  34.621  1.00 40.44           O  
ATOM  13614  OD2 ASP C 415       4.181  42.798  35.242  1.00 39.93           O  
ATOM  13615  N   HIS C 416       3.495  45.234  38.729  1.00 44.02           N  
ATOM  13616  CA  HIS C 416       4.106  44.711  39.940  1.00 44.91           C  
ATOM  13617  C   HIS C 416       3.061  43.974  40.775  1.00 44.51           C  
ATOM  13618  O   HIS C 416       3.208  42.784  41.080  1.00 44.38           O  
ATOM  13619  CB  HIS C 416       4.771  45.839  40.721  1.00 45.44           C  
ATOM  13620  CG  HIS C 416       5.662  45.282  41.797  1.00 50.21           C  
ATOM  13621  ND1 HIS C 416       7.022  45.179  41.621  1.00 50.97           N  
ATOM  13622  CD2 HIS C 416       5.389  44.785  43.027  1.00 48.42           C  
ATOM  13623  CE1 HIS C 416       7.557  44.653  42.718  1.00 49.43           C  
ATOM  13624  NE2 HIS C 416       6.579  44.391  43.576  1.00 49.75           N  
ATOM  13625  N   GLN C 417       1.978  44.638  41.110  1.00 43.14           N  
ATOM  13626  CA  GLN C 417       0.911  44.050  41.891  1.00 45.96           C  
ATOM  13627  C   GLN C 417       0.064  43.042  41.123  1.00 46.40           C  
ATOM  13628  O   GLN C 417      -0.167  41.901  41.585  1.00 45.55           O  
ATOM  13629  CB  GLN C 417       0.061  45.212  42.408  1.00 45.99           C  
ATOM  13630  CG  GLN C 417      -1.210  44.752  43.077  1.00 56.09           C  
ATOM  13631  CD  GLN C 417      -2.367  45.644  42.651  1.00 60.70           C  
ATOM  13632  OE1 GLN C 417      -2.517  45.930  41.457  1.00 63.62           O  
ATOM  13633  NE2 GLN C 417      -3.110  46.039  43.674  1.00 57.74           N  
ATOM  13634  N   PHE C 418      -0.430  43.390  39.924  1.00 43.29           N  
ATOM  13635  CA  PHE C 418      -1.254  42.476  39.167  1.00 43.29           C  
ATOM  13636  C   PHE C 418      -0.592  41.133  38.869  1.00 43.70           C  
ATOM  13637  O   PHE C 418      -1.202  40.066  38.993  1.00 41.62           O  
ATOM  13638  CB  PHE C 418      -1.706  43.132  37.867  1.00 43.72           C  
ATOM  13639  CG  PHE C 418      -2.918  42.512  37.235  1.00 46.40           C  
ATOM  13640  CD1 PHE C 418      -4.055  42.195  37.955  1.00 45.57           C  
ATOM  13641  CD2 PHE C 418      -2.916  42.238  35.881  1.00 46.08           C  
ATOM  13642  CE1 PHE C 418      -5.155  41.641  37.345  1.00 46.29           C  
ATOM  13643  CE2 PHE C 418      -4.007  41.671  35.247  1.00 46.49           C  
ATOM  13644  CZ  PHE C 418      -5.139  41.378  35.991  1.00 46.02           C  
ATOM  13645  N   SER C 419       0.687  41.134  38.491  1.00 43.50           N  
ATOM  13646  CA  SER C 419       1.375  39.881  38.195  1.00 42.97           C  
ATOM  13647  C   SER C 419       1.510  39.013  39.437  1.00 42.36           C  
ATOM  13648  O   SER C 419       1.444  37.788  39.320  1.00 43.97           O  
ATOM  13649  CB  SER C 419       2.745  40.101  37.549  1.00 41.74           C  
ATOM  13650  OG  SER C 419       3.580  40.937  38.327  1.00 40.37           O  
ATOM  13651  N   ARG C 420       1.670  39.606  40.614  1.00 43.32           N  
ATOM  13652  CA  ARG C 420       1.820  38.824  41.838  1.00 44.80           C  
ATOM  13653  C   ARG C 420       0.493  38.270  42.310  1.00 44.34           C  
ATOM  13654  O   ARG C 420       0.346  37.093  42.665  1.00 44.28           O  
ATOM  13655  CB  ARG C 420       2.557  39.664  42.867  1.00 45.09           C  
ATOM  13656  CG  ARG C 420       4.038  39.847  42.547  1.00 43.47           C  
ATOM  13657  CD  ARG C 420       4.685  40.866  43.475  1.00 47.07           C  
ATOM  13658  NE  ARG C 420       6.126  40.912  43.242  1.00 52.61           N  
ATOM  13659  CZ  ARG C 420       6.712  41.446  42.168  1.00 54.59           C  
ATOM  13660  NH1 ARG C 420       6.027  42.015  41.180  1.00 50.30           N  
ATOM  13661  NH2 ARG C 420       8.033  41.444  42.076  1.00 48.95           N  
ATOM  13662  N   LEU C 421      -0.588  39.035  42.148  1.00 43.76           N  
ATOM  13663  CA  LEU C 421      -1.912  38.517  42.511  1.00 43.61           C  
ATOM  13664  C   LEU C 421      -2.241  37.343  41.590  1.00 45.34           C  
ATOM  13665  O   LEU C 421      -2.791  36.310  42.008  1.00 43.46           O  
ATOM  13666  CB  LEU C 421      -2.983  39.592  42.429  1.00 43.24           C  
ATOM  13667  CG  LEU C 421      -2.806  40.783  43.381  1.00 47.07           C  
ATOM  13668  CD1 LEU C 421      -3.712  41.937  42.950  1.00 42.83           C  
ATOM  13669  CD2 LEU C 421      -3.091  40.365  44.819  1.00 43.24           C  
ATOM  13670  N   PHE C 422      -1.898  37.509  40.310  1.00 44.36           N  
ATOM  13671  CA  PHE C 422      -2.111  36.477  39.312  1.00 42.84           C  
ATOM  13672  C   PHE C 422      -1.283  35.227  39.545  1.00 43.78           C  
ATOM  13673  O   PHE C 422      -1.784  34.158  39.211  1.00 41.76           O  
ATOM  13674  CB  PHE C 422      -1.810  36.980  37.894  1.00 41.48           C  
ATOM  13675  CG  PHE C 422      -2.910  36.700  36.902  1.00 40.01           C  
ATOM  13676  CD1 PHE C 422      -3.364  35.412  36.663  1.00 37.19           C  
ATOM  13677  CD2 PHE C 422      -3.489  37.741  36.201  1.00 38.37           C  
ATOM  13678  CE1 PHE C 422      -4.370  35.164  35.758  1.00 38.94           C  
ATOM  13679  CE2 PHE C 422      -4.494  37.500  35.294  1.00 38.09           C  
ATOM  13680  CZ  PHE C 422      -4.942  36.212  35.068  1.00 36.07           C  
ATOM  13681  N   SER C 423      -0.061  35.354  40.055  1.00 44.71           N  
ATOM  13682  CA  SER C 423       0.809  34.212  40.257  1.00 48.38           C  
ATOM  13683  C   SER C 423       0.754  33.541  41.625  1.00 50.93           C  
ATOM  13684  O   SER C 423       1.462  32.543  41.871  1.00 51.54           O  
ATOM  13685  CB  SER C 423       2.261  34.656  40.016  1.00 49.42           C  
ATOM  13686  OG  SER C 423       2.404  35.289  38.766  1.00 51.89           O  
ATOM  13687  N   GLY C 424       0.006  34.110  42.560  1.00 50.72           N  
ATOM  13688  CA  GLY C 424      -0.060  33.532  43.889  1.00 52.55           C  
ATOM  13689  C   GLY C 424      -1.144  32.465  44.011  1.00 52.74           C  
ATOM  13690  O   GLY C 424      -2.025  32.363  43.162  1.00 52.91           O  
ATOM  13691  N   ARG C 425      -1.037  31.700  45.091  1.00 53.29           N  
ATOM  13692  CA  ARG C 425      -2.034  30.667  45.392  1.00 53.15           C  
ATOM  13693  C   ARG C 425      -3.262  31.358  45.993  1.00 52.50           C  
ATOM  13694  O   ARG C 425      -3.138  32.289  46.794  1.00 50.24           O  
ATOM  13695  CB  ARG C 425      -1.396  29.668  46.337  1.00 54.59           C  
ATOM  13696  CG  ARG C 425      -2.168  28.401  46.627  1.00 59.53           C  
ATOM  13697  CD  ARG C 425      -1.434  27.566  47.687  1.00 61.73           C  
ATOM  13698  NE  ARG C 425      -2.032  27.902  48.981  1.00 67.04           N  
ATOM  13699  CZ  ARG C 425      -1.583  28.901  49.740  1.00 68.88           C  
ATOM  13700  NH1 ARG C 425      -0.530  29.604  49.320  1.00 71.69           N  
ATOM  13701  NH2 ARG C 425      -2.173  29.180  50.888  1.00 67.67           N  
ATOM  13702  N   PRO C 426      -4.459  30.960  45.592  1.00 50.75           N  
ATOM  13703  CA  PRO C 426      -5.680  31.544  46.094  1.00 51.81           C  
ATOM  13704  C   PRO C 426      -5.920  31.211  47.559  1.00 52.96           C  
ATOM  13705  O   PRO C 426      -5.636  30.095  47.993  1.00 50.92           O  
ATOM  13706  CB  PRO C 426      -6.776  30.938  45.224  1.00 50.81           C  
ATOM  13707  CG  PRO C 426      -6.199  29.638  44.757  1.00 50.54           C  
ATOM  13708  CD  PRO C 426      -4.719  29.853  44.639  1.00 50.36           C  
ATOM  13709  N   ALA C 427      -6.428  32.175  48.324  1.00 55.14           N  
ATOM  13710  CA  ALA C 427      -6.705  31.937  49.737  1.00 58.65           C  
ATOM  13711  C   ALA C 427      -7.749  30.823  49.874  1.00 60.27           C  
ATOM  13712  O   ALA C 427      -8.804  30.886  49.240  1.00 60.15           O  
ATOM  13713  CB  ALA C 427      -7.199  33.200  50.407  1.00 57.80           C  
ATOM  13714  N   LYS C 428      -7.425  29.803  50.662  1.00 62.72           N  
ATOM  13715  CA  LYS C 428      -8.319  28.672  50.889  1.00 65.46           C  
ATOM  13716  C   LYS C 428      -9.579  29.149  51.612  1.00 67.03           C  
ATOM  13717  O   LYS C 428     -10.732  28.996  51.186  1.00 65.97           O  
ATOM  13718  CB  LYS C 428      -7.609  27.603  51.718  1.00 65.93           C  
ATOM  13719  CG  LYS C 428      -7.340  26.297  50.988  1.00 65.56           C  
ATOM  13720  CD  LYS C 428      -5.857  25.971  50.941  1.00 66.64           C  
ATOM  13721  CE  LYS C 428      -5.544  24.983  49.830  1.00 67.87           C  
ATOM  13722  NZ  LYS C 428      -4.101  24.981  49.434  1.00 65.29           N  
ATOM  13723  N   ASP C 429      -9.307  29.773  52.753  1.00 68.13           N  
ATOM  13724  CA  ASP C 429     -10.357  30.405  53.547  1.00 71.66           C  
ATOM  13725  C   ASP C 429      -9.816  31.787  53.902  1.00 72.87           C  
ATOM  13726  O   ASP C 429      -8.644  32.046  53.637  1.00 73.80           O  
ATOM  13727  CB  ASP C 429     -10.739  29.632  54.798  1.00 71.33           C  
ATOM  13728  CG  ASP C 429      -9.528  29.317  55.662  1.00 73.11           C  
ATOM  13729  OD1 ASP C 429      -8.781  30.262  56.019  1.00 71.44           O  
ATOM  13730  OD2 ASP C 429      -9.338  28.116  55.975  1.00 72.52           O  
ATOM  13731  N   VAL C 430     -10.593  32.576  54.609  1.00 73.92           N  
ATOM  13732  CA  VAL C 430     -10.252  33.929  55.021  1.00 74.59           C  
ATOM  13733  C   VAL C 430      -9.061  34.030  55.956  1.00 75.26           C  
ATOM  13734  O   VAL C 430      -8.430  35.091  56.043  1.00 75.47           O  
ATOM  13735  CB  VAL C 430     -11.502  34.649  55.581  1.00 75.80           C  
ATOM  13736  CG1 VAL C 430     -12.737  33.749  55.617  1.00 74.24           C  
ATOM  13737  CG2 VAL C 430     -11.329  35.267  56.957  1.00 76.39           C  
ATOM  13738  N   ALA C 431      -8.709  32.975  56.683  1.00 75.74           N  
ATOM  13739  CA  ALA C 431      -7.596  32.988  57.617  1.00 75.55           C  
ATOM  13740  C   ALA C 431      -6.271  32.808  56.901  1.00 76.00           C  
ATOM  13741  O   ALA C 431      -5.232  33.290  57.364  1.00 75.98           O  
ATOM  13742  CB  ALA C 431      -7.760  31.891  58.659  1.00 73.56           C  
ATOM  13743  N   ASP C 432      -6.303  32.132  55.764  1.00 75.99           N  
ATOM  13744  CA  ASP C 432      -5.135  31.914  54.902  1.00 75.28           C  
ATOM  13745  C   ASP C 432      -4.593  33.234  54.377  1.00 75.55           C  
ATOM  13746  O   ASP C 432      -4.794  33.583  53.214  1.00 76.18           O  
ATOM  13747  CB  ASP C 432      -5.639  31.055  53.740  1.00 73.14           C  
ATOM  13748  CG  ASP C 432      -4.573  30.404  52.894  1.00 73.38           C  
ATOM  13749  OD1 ASP C 432      -3.387  30.485  53.276  1.00 72.70           O  
ATOM  13750  OD2 ASP C 432      -4.944  29.810  51.857  1.00 72.92           O  
ATOM  13751  N   GLU C 433      -3.903  34.008  55.199  1.00 75.31           N  
ATOM  13752  CA  GLU C 433      -3.374  35.312  54.883  1.00 75.63           C  
ATOM  13753  C   GLU C 433      -2.365  35.376  53.753  1.00 74.38           C  
ATOM  13754  O   GLU C 433      -2.297  36.388  53.058  1.00 74.16           O  
ATOM  13755  CB  GLU C 433      -2.771  35.950  56.143  1.00 77.33           C  
ATOM  13756  CG  GLU C 433      -1.275  35.813  56.302  1.00 78.88           C  
ATOM  13757  CD  GLU C 433      -0.866  34.858  57.400  1.00 79.91           C  
ATOM  13758  OE1 GLU C 433      -1.646  33.967  57.794  1.00 78.79           O  
ATOM  13759  OE2 GLU C 433       0.277  35.001  57.891  1.00 80.18           O  
ATOM  13760  N   MET C 434      -1.599  34.322  53.543  1.00 73.82           N  
ATOM  13761  CA  MET C 434      -0.551  34.261  52.541  1.00 72.83           C  
ATOM  13762  C   MET C 434      -1.050  33.728  51.200  1.00 70.99           C  
ATOM  13763  O   MET C 434      -0.277  33.413  50.290  1.00 71.20           O  
ATOM  13764  CB  MET C 434       0.617  33.415  53.040  1.00 76.74           C  
ATOM  13765  CG  MET C 434       0.559  33.095  54.528  1.00 82.01           C  
ATOM  13766  SD  MET C 434      -0.460  31.620  54.808  1.00 90.84           S  
ATOM  13767  CE  MET C 434       0.792  30.364  54.490  1.00 84.07           C  
ATOM  13768  N   GLY C 435      -2.364  33.590  51.091  1.00 67.49           N  
ATOM  13769  CA  GLY C 435      -3.004  33.194  49.845  1.00 65.24           C  
ATOM  13770  C   GLY C 435      -3.406  34.535  49.202  1.00 62.71           C  
ATOM  13771  O   GLY C 435      -3.208  35.572  49.803  1.00 62.60           O  
ATOM  13772  N   VAL C 436      -3.931  34.466  47.996  1.00 60.45           N  
ATOM  13773  CA  VAL C 436      -4.376  35.646  47.284  1.00 58.09           C  
ATOM  13774  C   VAL C 436      -5.886  35.746  47.482  1.00 55.96           C  
ATOM  13775  O   VAL C 436      -6.580  34.756  47.282  1.00 54.29           O  
ATOM  13776  CB  VAL C 436      -4.055  35.577  45.778  1.00 59.07           C  
ATOM  13777  CG1 VAL C 436      -4.649  36.773  45.041  1.00 59.26           C  
ATOM  13778  CG2 VAL C 436      -2.552  35.522  45.545  1.00 56.60           C  
ATOM  13779  N   SER C 437      -6.356  36.920  47.888  1.00 54.16           N  
ATOM  13780  CA  SER C 437      -7.803  37.087  48.052  1.00 52.10           C  
ATOM  13781  C   SER C 437      -8.426  37.220  46.663  1.00 52.06           C  
ATOM  13782  O   SER C 437      -8.068  38.120  45.890  1.00 51.62           O  
ATOM  13783  CB  SER C 437      -8.125  38.318  48.889  1.00 48.70           C  
ATOM  13784  OG  SER C 437      -9.439  38.732  48.566  1.00 47.62           O  
ATOM  13785  N   MET C 438      -9.354  36.338  46.337  1.00 50.68           N  
ATOM  13786  CA  MET C 438      -9.998  36.381  45.030  1.00 51.88           C  
ATOM  13787  C   MET C 438     -10.810  37.658  44.844  1.00 51.24           C  
ATOM  13788  O   MET C 438     -10.837  38.165  43.726  1.00 50.36           O  
ATOM  13789  CB  MET C 438     -10.823  35.149  44.727  1.00 48.79           C  
ATOM  13790  CG  MET C 438     -10.025  33.870  44.607  1.00 52.06           C  
ATOM  13791  SD  MET C 438      -8.551  33.959  43.584  1.00 56.21           S  
ATOM  13792  CE  MET C 438      -9.146  34.770  42.130  1.00 57.17           C  
ATOM  13793  N   ASP C 439     -11.327  38.243  45.904  1.00 52.08           N  
ATOM  13794  CA  ASP C 439     -12.009  39.523  45.872  1.00 52.71           C  
ATOM  13795  C   ASP C 439     -11.057  40.678  45.578  1.00 52.26           C  
ATOM  13796  O   ASP C 439     -11.457  41.606  44.889  1.00 51.41           O  
ATOM  13797  CB  ASP C 439     -12.762  39.765  47.201  1.00 55.90           C  
ATOM  13798  CG  ASP C 439     -13.704  38.592  47.419  1.00 63.93           C  
ATOM  13799  OD1 ASP C 439     -14.822  38.622  46.875  1.00 62.92           O  
ATOM  13800  OD2 ASP C 439     -13.290  37.622  48.087  1.00 69.59           O  
ATOM  13801  N   VAL C 440      -9.835  40.627  46.080  1.00 52.06           N  
ATOM  13802  CA  VAL C 440      -8.816  41.625  45.835  1.00 51.71           C  
ATOM  13803  C   VAL C 440      -8.408  41.522  44.360  1.00 51.80           C  
ATOM  13804  O   VAL C 440      -8.271  42.523  43.653  1.00 49.90           O  
ATOM  13805  CB  VAL C 440      -7.592  41.453  46.751  1.00 54.86           C  
ATOM  13806  CG1 VAL C 440      -6.397  42.294  46.331  1.00 47.66           C  
ATOM  13807  CG2 VAL C 440      -7.934  41.704  48.210  1.00 51.76           C  
ATOM  13808  N   PHE C 441      -8.279  40.283  43.897  1.00 49.18           N  
ATOM  13809  CA  PHE C 441      -7.933  39.983  42.515  1.00 48.99           C  
ATOM  13810  C   PHE C 441      -8.944  40.581  41.546  1.00 47.24           C  
ATOM  13811  O   PHE C 441      -8.596  41.303  40.601  1.00 44.81           O  
ATOM  13812  CB  PHE C 441      -7.860  38.466  42.264  1.00 46.36           C  
ATOM  13813  CG  PHE C 441      -7.394  38.141  40.875  1.00 50.44           C  
ATOM  13814  CD1 PHE C 441      -6.209  38.647  40.357  1.00 48.09           C  
ATOM  13815  CD2 PHE C 441      -8.182  37.322  40.065  1.00 50.17           C  
ATOM  13816  CE1 PHE C 441      -5.820  38.334  39.069  1.00 48.44           C  
ATOM  13817  CE2 PHE C 441      -7.799  37.009  38.781  1.00 49.82           C  
ATOM  13818  CZ  PHE C 441      -6.604  37.507  38.282  1.00 50.09           C  
ATOM  13819  N   LYS C 442     -10.226  40.367  41.836  1.00 46.76           N  
ATOM  13820  CA  LYS C 442     -11.285  40.916  40.988  1.00 48.39           C  
ATOM  13821  C   LYS C 442     -11.234  42.440  40.952  1.00 49.16           C  
ATOM  13822  O   LYS C 442     -11.382  43.072  39.911  1.00 48.41           O  
ATOM  13823  CB  LYS C 442     -12.660  40.443  41.453  1.00 47.55           C  
ATOM  13824  CG  LYS C 442     -13.761  40.990  40.564  1.00 46.55           C  
ATOM  13825  CD  LYS C 442     -15.135  40.528  40.982  1.00 49.66           C  
ATOM  13826  CE  LYS C 442     -16.179  41.374  40.273  1.00 52.93           C  
ATOM  13827  NZ  LYS C 442     -17.496  41.228  40.956  1.00 57.71           N  
ATOM  13828  N   GLU C 443     -10.990  43.023  42.120  1.00 49.24           N  
ATOM  13829  CA  GLU C 443     -10.850  44.451  42.286  1.00 48.30           C  
ATOM  13830  C   GLU C 443      -9.653  45.002  41.521  1.00 44.59           C  
ATOM  13831  O   GLU C 443      -9.751  46.015  40.834  1.00 44.07           O  
ATOM  13832  CB  GLU C 443     -10.714  44.782  43.764  1.00 54.86           C  
ATOM  13833  CG  GLU C 443     -11.283  46.165  44.091  1.00 63.36           C  
ATOM  13834  CD  GLU C 443     -12.391  46.052  45.127  1.00 69.51           C  
ATOM  13835  OE1 GLU C 443     -12.484  44.954  45.729  1.00 66.88           O  
ATOM  13836  OE2 GLU C 443     -13.110  47.072  45.308  1.00 70.17           O  
ATOM  13837  N   ALA C 444      -8.542  44.283  41.577  1.00 41.79           N  
ATOM  13838  CA  ALA C 444      -7.338  44.702  40.841  1.00 43.32           C  
ATOM  13839  C   ALA C 444      -7.610  44.608  39.339  1.00 43.29           C  
ATOM  13840  O   ALA C 444      -7.318  45.558  38.631  1.00 41.04           O  
ATOM  13841  CB  ALA C 444      -6.119  43.937  41.284  1.00 38.31           C  
ATOM  13842  N   PHE C 445      -8.237  43.523  38.887  1.00 43.54           N  
ATOM  13843  CA  PHE C 445      -8.556  43.376  37.469  1.00 44.14           C  
ATOM  13844  C   PHE C 445      -9.485  44.478  36.973  1.00 43.33           C  
ATOM  13845  O   PHE C 445      -9.158  45.138  35.978  1.00 42.27           O  
ATOM  13846  CB  PHE C 445      -9.120  41.989  37.182  1.00 43.38           C  
ATOM  13847  CG  PHE C 445      -8.648  41.310  35.929  1.00 44.34           C  
ATOM  13848  CD1 PHE C 445      -8.403  41.999  34.750  1.00 44.07           C  
ATOM  13849  CD2 PHE C 445      -8.459  39.930  35.945  1.00 43.06           C  
ATOM  13850  CE1 PHE C 445      -7.965  41.325  33.621  1.00 40.88           C  
ATOM  13851  CE2 PHE C 445      -7.998  39.265  34.824  1.00 43.72           C  
ATOM  13852  CZ  PHE C 445      -7.756  39.959  33.657  1.00 40.22           C  
ATOM  13853  N   VAL C 446     -10.598  44.735  37.633  1.00 42.69           N  
ATOM  13854  CA  VAL C 446     -11.505  45.791  37.214  1.00 41.08           C  
ATOM  13855  C   VAL C 446     -10.814  47.153  37.193  1.00 42.56           C  
ATOM  13856  O   VAL C 446     -10.986  47.933  36.261  1.00 42.30           O  
ATOM  13857  CB  VAL C 446     -12.752  45.917  38.109  1.00 41.06           C  
ATOM  13858  CG1 VAL C 446     -13.610  47.095  37.652  1.00 36.91           C  
ATOM  13859  CG2 VAL C 446     -13.572  44.638  38.131  1.00 34.93           C  
ATOM  13860  N   LYS C 447     -10.040  47.454  38.237  1.00 43.09           N  
ATOM  13861  CA  LYS C 447      -9.344  48.740  38.289  1.00 44.42           C  
ATOM  13862  C   LYS C 447      -8.246  48.799  37.231  1.00 43.39           C  
ATOM  13863  O   LYS C 447      -8.148  49.782  36.486  1.00 42.00           O  
ATOM  13864  CB  LYS C 447      -8.840  49.011  39.700  1.00 47.04           C  
ATOM  13865  CG  LYS C 447      -7.932  50.235  39.783  1.00 52.35           C  
ATOM  13866  CD  LYS C 447      -7.541  50.494  41.233  1.00 58.15           C  
ATOM  13867  CE  LYS C 447      -6.376  51.472  41.341  1.00 59.27           C  
ATOM  13868  NZ  LYS C 447      -6.356  52.160  42.667  1.00 63.66           N  
ATOM  13869  N   GLY C 448      -7.551  47.689  37.008  1.00 39.91           N  
ATOM  13870  CA  GLY C 448      -6.477  47.563  36.056  1.00 40.66           C  
ATOM  13871  C   GLY C 448      -6.960  47.757  34.628  1.00 43.50           C  
ATOM  13872  O   GLY C 448      -6.235  48.281  33.768  1.00 41.99           O  
ATOM  13873  N   ASN C 449      -8.211  47.368  34.373  1.00 41.31           N  
ATOM  13874  CA  ASN C 449      -8.790  47.513  33.045  1.00 40.76           C  
ATOM  13875  C   ASN C 449      -8.963  48.958  32.612  1.00 41.41           C  
ATOM  13876  O   ASN C 449      -8.989  49.243  31.410  1.00 42.34           O  
ATOM  13877  CB  ASN C 449     -10.144  46.792  32.990  1.00 38.95           C  
ATOM  13878  CG  ASN C 449      -9.966  45.306  32.900  1.00 38.96           C  
ATOM  13879  OD1 ASN C 449     -10.915  44.572  33.157  1.00 47.19           O  
ATOM  13880  ND2 ASN C 449      -8.772  44.833  32.585  1.00 34.59           N  
ATOM  13881  N   GLU C 450      -9.124  49.892  33.544  1.00 41.50           N  
ATOM  13882  CA  GLU C 450      -9.191  51.295  33.145  1.00 42.53           C  
ATOM  13883  C   GLU C 450      -7.778  51.709  32.695  1.00 38.82           C  
ATOM  13884  O   GLU C 450      -7.584  52.324  31.651  1.00 37.01           O  
ATOM  13885  CB  GLU C 450      -9.718  52.156  34.277  1.00 42.73           C  
ATOM  13886  CG  GLU C 450      -9.527  53.641  34.056  1.00 51.34           C  
ATOM  13887  CD  GLU C 450     -10.356  54.460  35.033  1.00 60.30           C  
ATOM  13888  OE1 GLU C 450     -10.678  53.888  36.106  1.00 64.26           O  
ATOM  13889  OE2 GLU C 450     -10.726  55.615  34.717  1.00 61.54           O  
ATOM  13890  N   PHE C 451      -6.784  51.426  33.541  1.00 36.57           N  
ATOM  13891  CA  PHE C 451      -5.409  51.796  33.265  1.00 37.66           C  
ATOM  13892  C   PHE C 451      -4.949  51.136  31.952  1.00 37.58           C  
ATOM  13893  O   PHE C 451      -4.543  51.800  31.004  1.00 34.65           O  
ATOM  13894  CB  PHE C 451      -4.487  51.372  34.417  1.00 35.19           C  
ATOM  13895  CG  PHE C 451      -3.042  51.642  34.107  1.00 39.88           C  
ATOM  13896  CD1 PHE C 451      -2.510  52.905  34.274  1.00 37.53           C  
ATOM  13897  CD2 PHE C 451      -2.232  50.622  33.619  1.00 36.79           C  
ATOM  13898  CE1 PHE C 451      -1.188  53.145  33.968  1.00 40.73           C  
ATOM  13899  CE2 PHE C 451      -0.904  50.873  33.314  1.00 38.63           C  
ATOM  13900  CZ  PHE C 451      -0.379  52.128  33.488  1.00 41.80           C  
ATOM  13901  N   ALA C 452      -5.121  49.829  31.840  1.00 35.13           N  
ATOM  13902  CA  ALA C 452      -4.747  49.041  30.690  1.00 38.39           C  
ATOM  13903  C   ALA C 452      -5.372  49.444  29.366  1.00 38.70           C  
ATOM  13904  O   ALA C 452      -4.747  49.244  28.320  1.00 36.06           O  
ATOM  13905  CB  ALA C 452      -5.006  47.548  30.905  1.00 33.12           C  
ATOM  13906  N   SER C 453      -6.516  50.125  29.350  1.00 37.17           N  
ATOM  13907  CA  SER C 453      -7.090  50.650  28.118  1.00 34.17           C  
ATOM  13908  C   SER C 453      -6.201  51.701  27.461  1.00 34.37           C  
ATOM  13909  O   SER C 453      -6.311  52.035  26.261  1.00 33.34           O  
ATOM  13910  CB  SER C 453      -8.460  51.284  28.438  1.00 33.88           C  
ATOM  13911  OG  SER C 453      -8.279  52.559  29.067  1.00 31.85           O  
ATOM  13912  N   GLY C 454      -5.343  52.361  28.222  1.00 32.83           N  
ATOM  13913  CA  GLY C 454      -4.436  53.394  27.749  1.00 31.17           C  
ATOM  13914  C   GLY C 454      -5.111  54.748  27.606  1.00 33.36           C  
ATOM  13915  O   GLY C 454      -4.488  55.718  27.149  1.00 33.33           O  
ATOM  13916  N   THR C 455      -6.392  54.817  27.978  1.00 31.19           N  
ATOM  13917  CA  THR C 455      -7.196  56.006  27.823  1.00 30.12           C  
ATOM  13918  C   THR C 455      -7.196  56.927  29.019  1.00 30.07           C  
ATOM  13919  O   THR C 455      -7.744  58.027  28.856  1.00 28.82           O  
ATOM  13920  CB  THR C 455      -8.691  55.654  27.544  1.00 33.35           C  
ATOM  13921  OG1 THR C 455      -9.229  55.026  28.700  1.00 31.62           O  
ATOM  13922  CG2 THR C 455      -8.831  54.738  26.338  1.00 29.11           C  
ATOM  13923  N   ALA C 456      -6.566  56.551  30.134  1.00 31.22           N  
ATOM  13924  CA  ALA C 456      -6.668  57.406  31.329  1.00 34.59           C  
ATOM  13925  C   ALA C 456      -5.463  58.300  31.559  1.00 36.26           C  
ATOM  13926  O   ALA C 456      -5.393  59.133  32.483  1.00 39.31           O  
ATOM  13927  CB  ALA C 456      -6.934  56.575  32.575  1.00 25.76           C  
ATOM  13928  N   ILE C 457      -4.465  58.176  30.708  1.00 36.37           N  
ATOM  13929  CA  ILE C 457      -3.264  58.996  30.791  1.00 34.81           C  
ATOM  13930  C   ILE C 457      -3.614  60.480  30.898  1.00 33.46           C  
ATOM  13931  O   ILE C 457      -4.408  60.973  30.130  1.00 33.00           O  
ATOM  13932  CB  ILE C 457      -2.439  58.826  29.498  1.00 31.49           C  
ATOM  13933  CG1 ILE C 457      -2.051  57.372  29.328  1.00 34.96           C  
ATOM  13934  CG2 ILE C 457      -1.281  59.807  29.454  1.00 28.66           C  
ATOM  13935  CD1 ILE C 457      -1.225  57.054  28.096  1.00 32.55           C  
ATOM  13936  N   ASN C 458      -2.962  61.197  31.782  1.00 34.18           N  
ATOM  13937  CA  ASN C 458      -3.129  62.618  31.979  1.00 36.47           C  
ATOM  13938  C   ASN C 458      -1.704  63.176  31.977  1.00 35.26           C  
ATOM  13939  O   ASN C 458      -1.004  62.897  32.945  1.00 37.00           O  
ATOM  13940  CB  ASN C 458      -3.808  62.985  33.308  1.00 33.47           C  
ATOM  13941  CG  ASN C 458      -4.092  64.482  33.365  1.00 39.53           C  
ATOM  13942  OD1 ASN C 458      -3.276  65.296  32.919  1.00 39.58           O  
ATOM  13943  ND2 ASN C 458      -5.252  64.875  33.844  1.00 33.15           N  
ATOM  13944  N   TYR C 459      -1.294  63.908  30.967  1.00 35.92           N  
ATOM  13945  CA  TYR C 459       0.070  64.427  30.950  1.00 36.25           C  
ATOM  13946  C   TYR C 459       0.169  65.670  31.834  1.00 36.59           C  
ATOM  13947  O   TYR C 459      -0.749  66.489  31.815  1.00 35.67           O  
ATOM  13948  CB  TYR C 459       0.608  64.745  29.544  1.00 35.22           C  
ATOM  13949  CG  TYR C 459       0.755  63.537  28.651  1.00 35.63           C  
ATOM  13950  CD1 TYR C 459       1.329  62.362  29.105  1.00 34.86           C  
ATOM  13951  CD2 TYR C 459       0.288  63.542  27.352  1.00 33.50           C  
ATOM  13952  CE1 TYR C 459       1.454  61.251  28.295  1.00 34.28           C  
ATOM  13953  CE2 TYR C 459       0.403  62.436  26.532  1.00 34.37           C  
ATOM  13954  CZ  TYR C 459       0.977  61.287  27.013  1.00 34.57           C  
ATOM  13955  OH  TYR C 459       1.071  60.175  26.198  1.00 33.54           O  
ATOM  13956  N   ASP C 460       1.260  65.759  32.582  1.00 35.13           N  
ATOM  13957  CA  ASP C 460       1.482  66.943  33.405  1.00 38.68           C  
ATOM  13958  C   ASP C 460       1.767  68.164  32.530  1.00 37.00           C  
ATOM  13959  O   ASP C 460       2.253  68.016  31.409  1.00 37.28           O  
ATOM  13960  CB  ASP C 460       2.650  66.776  34.380  1.00 37.90           C  
ATOM  13961  CG  ASP C 460       2.364  65.833  35.518  1.00 41.85           C  
ATOM  13962  OD1 ASP C 460       1.201  65.462  35.785  1.00 44.29           O  
ATOM  13963  OD2 ASP C 460       3.310  65.407  36.189  1.00 47.33           O  
ATOM  13964  N   GLU C 461       1.441  69.331  33.044  1.00 35.68           N  
ATOM  13965  CA  GLU C 461       1.737  70.596  32.353  1.00 36.05           C  
ATOM  13966  C   GLU C 461       3.147  70.537  31.752  1.00 34.93           C  
ATOM  13967  O   GLU C 461       4.094  70.013  32.375  1.00 34.10           O  
ATOM  13968  CB  GLU C 461       1.628  71.713  33.396  1.00 36.11           C  
ATOM  13969  CG  GLU C 461       2.039  73.095  32.986  1.00 43.09           C  
ATOM  13970  CD  GLU C 461       1.025  74.098  32.513  1.00 48.45           C  
ATOM  13971  OE1 GLU C 461      -0.117  74.169  32.986  1.00 53.94           O  
ATOM  13972  OE2 GLU C 461       1.342  74.908  31.614  1.00 49.22           O  
ATOM  13973  N   ASN C 462       3.310  70.994  30.522  1.00 30.74           N  
ATOM  13974  CA  ASN C 462       4.630  71.008  29.903  1.00 28.77           C  
ATOM  13975  C   ASN C 462       4.587  71.943  28.697  1.00 30.55           C  
ATOM  13976  O   ASN C 462       3.534  72.561  28.465  1.00 30.75           O  
ATOM  13977  CB  ASN C 462       5.219  69.671  29.468  1.00 29.44           C  
ATOM  13978  CG  ASN C 462       4.364  68.871  28.528  1.00 30.51           C  
ATOM  13979  OD1 ASN C 462       3.703  69.417  27.655  1.00 26.65           O  
ATOM  13980  ND2 ASN C 462       4.380  67.552  28.715  1.00 27.12           N  
ATOM  13981  N   LEU C 463       5.649  71.950  27.898  1.00 30.04           N  
ATOM  13982  CA  LEU C 463       5.637  72.922  26.799  1.00 30.39           C  
ATOM  13983  C   LEU C 463       4.493  72.722  25.830  1.00 31.02           C  
ATOM  13984  O   LEU C 463       4.050  73.719  25.256  1.00 33.39           O  
ATOM  13985  CB  LEU C 463       7.013  72.881  26.095  1.00 32.94           C  
ATOM  13986  CG  LEU C 463       7.156  73.919  24.977  1.00 34.95           C  
ATOM  13987  CD1 LEU C 463       7.022  75.337  25.532  1.00 32.94           C  
ATOM  13988  CD2 LEU C 463       8.446  73.766  24.198  1.00 27.46           C  
ATOM  13989  N   VAL C 464       4.020  71.515  25.562  1.00 29.56           N  
ATOM  13990  CA  VAL C 464       2.931  71.314  24.611  1.00 33.02           C  
ATOM  13991  C   VAL C 464       1.587  71.020  25.280  1.00 35.67           C  
ATOM  13992  O   VAL C 464       0.591  70.722  24.605  1.00 34.88           O  
ATOM  13993  CB  VAL C 464       3.317  70.275  23.523  1.00 33.01           C  
ATOM  13994  CG1 VAL C 464       4.647  70.624  22.841  1.00 28.90           C  
ATOM  13995  CG2 VAL C 464       3.428  68.855  24.046  1.00 27.78           C  
ATOM  13996  N   THR C 465       1.486  71.170  26.594  1.00 33.37           N  
ATOM  13997  CA  THR C 465       0.300  70.912  27.410  1.00 36.43           C  
ATOM  13998  C   THR C 465       0.005  72.057  28.375  1.00 36.96           C  
ATOM  13999  O   THR C 465       0.638  72.107  29.436  1.00 37.00           O  
ATOM  14000  CB  THR C 465       0.495  69.613  28.238  1.00 36.51           C  
ATOM  14001  OG1 THR C 465       1.143  68.645  27.397  1.00 31.97           O  
ATOM  14002  CG2 THR C 465      -0.820  69.040  28.724  1.00 31.86           C  
ATOM  14003  N   ASP C 466      -0.845  72.999  27.963  1.00 34.22           N  
ATOM  14004  CA  ASP C 466      -1.044  74.217  28.777  1.00 33.46           C  
ATOM  14005  C   ASP C 466      -2.320  74.233  29.617  1.00 34.19           C  
ATOM  14006  O   ASP C 466      -3.416  74.634  29.214  1.00 31.68           O  
ATOM  14007  CB  ASP C 466      -0.934  75.355  27.765  1.00 30.38           C  
ATOM  14008  CG  ASP C 466      -0.848  76.771  28.316  1.00 36.72           C  
ATOM  14009  OD1 ASP C 466      -0.873  76.979  29.546  1.00 40.91           O  
ATOM  14010  OD2 ASP C 466      -0.751  77.723  27.489  1.00 37.51           O  
ATOM  14011  N   LYS C 467      -2.232  73.771  30.847  1.00 33.99           N  
ATOM  14012  CA  LYS C 467      -3.280  73.851  31.854  1.00 36.81           C  
ATOM  14013  C   LYS C 467      -3.467  75.228  32.491  1.00 37.64           C  
ATOM  14014  O   LYS C 467      -4.581  75.724  32.615  1.00 39.69           O  
ATOM  14015  CB  LYS C 467      -2.933  72.853  32.964  1.00 33.11           C  
ATOM  14016  CG  LYS C 467      -2.770  71.455  32.404  1.00 34.24           C  
ATOM  14017  CD  LYS C 467      -2.600  70.437  33.523  1.00 31.57           C  
ATOM  14018  CE  LYS C 467      -2.193  69.134  32.869  1.00 31.99           C  
ATOM  14019  NZ  LYS C 467      -2.564  67.970  33.704  1.00 35.37           N  
ATOM  14020  N   LYS C 468      -2.347  75.865  32.837  1.00 39.08           N  
ATOM  14021  CA  LYS C 468      -2.315  77.181  33.457  1.00 40.17           C  
ATOM  14022  C   LYS C 468      -3.072  78.260  32.705  1.00 38.52           C  
ATOM  14023  O   LYS C 468      -3.663  79.113  33.330  1.00 39.14           O  
ATOM  14024  CB  LYS C 468      -0.884  77.694  33.664  1.00 45.17           C  
ATOM  14025  CG  LYS C 468      -0.234  77.093  34.879  1.00 49.53           C  
ATOM  14026  CD  LYS C 468       1.203  77.534  35.053  1.00 53.71           C  
ATOM  14027  CE  LYS C 468       1.721  76.955  36.372  1.00 56.27           C  
ATOM  14028  NZ  LYS C 468       3.173  77.288  36.519  1.00 60.97           N  
ATOM  14029  N   SER C 469      -3.054  78.266  31.389  1.00 36.76           N  
ATOM  14030  CA  SER C 469      -3.757  79.238  30.586  1.00 33.87           C  
ATOM  14031  C   SER C 469      -5.149  78.753  30.202  1.00 33.59           C  
ATOM  14032  O   SER C 469      -5.817  79.438  29.423  1.00 34.31           O  
ATOM  14033  CB  SER C 469      -2.984  79.536  29.296  1.00 34.97           C  
ATOM  14034  OG  SER C 469      -1.592  79.558  29.596  1.00 41.06           O  
ATOM  14035  N   SER C 470      -5.501  77.571  30.706  1.00 31.12           N  
ATOM  14036  CA  SER C 470      -6.816  77.066  30.327  1.00 37.35           C  
ATOM  14037  C   SER C 470      -7.904  77.450  31.327  1.00 37.27           C  
ATOM  14038  O   SER C 470      -7.706  77.394  32.530  1.00 37.32           O  
ATOM  14039  CB  SER C 470      -6.802  75.534  30.187  1.00 37.67           C  
ATOM  14040  OG  SER C 470      -5.963  75.144  29.098  1.00 40.87           O  
ATOM  14041  N   LYS C 471      -9.091  77.679  30.797  1.00 38.58           N  
ATOM  14042  CA  LYS C 471     -10.304  77.704  31.620  1.00 37.82           C  
ATOM  14043  C   LYS C 471     -10.914  76.314  31.466  1.00 38.01           C  
ATOM  14044  O   LYS C 471     -11.812  76.099  30.650  1.00 36.90           O  
ATOM  14045  CB  LYS C 471     -11.265  78.768  31.128  1.00 37.88           C  
ATOM  14046  CG  LYS C 471     -10.698  80.168  31.023  1.00 38.56           C  
ATOM  14047  CD  LYS C 471     -11.688  81.134  30.401  1.00 40.90           C  
ATOM  14048  CE  LYS C 471     -11.030  82.494  30.231  1.00 41.41           C  
ATOM  14049  NZ  LYS C 471     -12.013  83.517  29.758  1.00 44.06           N  
ATOM  14050  N   GLN C 472     -10.450  75.356  32.255  1.00 37.05           N  
ATOM  14051  CA  GLN C 472     -10.912  73.985  32.153  1.00 36.79           C  
ATOM  14052  C   GLN C 472     -12.410  73.826  32.234  1.00 39.05           C  
ATOM  14053  O   GLN C 472     -12.957  72.888  31.608  1.00 39.36           O  
ATOM  14054  CB  GLN C 472     -10.247  73.094  33.202  1.00 31.19           C  
ATOM  14055  CG  GLN C 472     -10.480  71.605  32.998  1.00 31.24           C  
ATOM  14056  CD  GLN C 472      -9.925  71.097  31.665  1.00 34.74           C  
ATOM  14057  OE1 GLN C 472      -8.728  70.971  31.424  1.00 31.40           O  
ATOM  14058  NE2 GLN C 472     -10.806  70.802  30.704  1.00 30.39           N  
ATOM  14059  N   GLU C 473     -13.101  74.680  32.986  1.00 38.26           N  
ATOM  14060  CA  GLU C 473     -14.525  74.546  33.201  1.00 36.18           C  
ATOM  14061  C   GLU C 473     -15.326  74.653  31.926  1.00 36.04           C  
ATOM  14062  O   GLU C 473     -16.424  74.049  31.834  1.00 36.26           O  
ATOM  14063  CB  GLU C 473     -15.024  75.538  34.273  1.00 35.35           C  
ATOM  14064  CG  GLU C 473     -15.015  76.991  33.881  1.00 34.16           C  
ATOM  14065  CD  GLU C 473     -13.650  77.668  33.942  1.00 43.81           C  
ATOM  14066  OE1 GLU C 473     -12.647  77.047  34.384  1.00 39.31           O  
ATOM  14067  OE2 GLU C 473     -13.605  78.858  33.532  1.00 45.53           O  
ATOM  14068  N   LEU C 474     -14.831  75.345  30.902  1.00 36.06           N  
ATOM  14069  CA  LEU C 474     -15.526  75.477  29.638  1.00 33.90           C  
ATOM  14070  C   LEU C 474     -15.642  74.174  28.859  1.00 35.10           C  
ATOM  14071  O   LEU C 474     -16.413  74.087  27.883  1.00 34.87           O  
ATOM  14072  CB  LEU C 474     -14.808  76.539  28.793  1.00 32.85           C  
ATOM  14073  CG  LEU C 474     -14.787  77.974  29.320  1.00 35.45           C  
ATOM  14074  CD1 LEU C 474     -14.249  78.907  28.244  1.00 32.02           C  
ATOM  14075  CD2 LEU C 474     -16.197  78.395  29.730  1.00 25.29           C  
ATOM  14076  N   ALA C 475     -14.885  73.148  29.220  1.00 32.85           N  
ATOM  14077  CA  ALA C 475     -14.952  71.854  28.533  1.00 34.11           C  
ATOM  14078  C   ALA C 475     -14.531  70.801  29.548  1.00 34.47           C  
ATOM  14079  O   ALA C 475     -13.367  70.370  29.496  1.00 34.16           O  
ATOM  14080  CB  ALA C 475     -14.047  71.752  27.310  1.00 29.83           C  
ATOM  14081  N   LYS C 476     -15.424  70.527  30.504  1.00 34.62           N  
ATOM  14082  CA  LYS C 476     -15.053  69.743  31.665  1.00 36.57           C  
ATOM  14083  C   LYS C 476     -14.622  68.323  31.394  1.00 36.97           C  
ATOM  14084  O   LYS C 476     -13.880  67.799  32.229  1.00 39.04           O  
ATOM  14085  CB  LYS C 476     -16.183  69.641  32.715  1.00 39.03           C  
ATOM  14086  CG  LYS C 476     -17.014  70.895  32.841  1.00 43.77           C  
ATOM  14087  CD  LYS C 476     -18.164  70.685  33.833  1.00 43.24           C  
ATOM  14088  CE  LYS C 476     -18.655  72.010  34.368  1.00 45.32           C  
ATOM  14089  NZ  LYS C 476     -17.833  73.198  34.021  1.00 42.10           N  
ATOM  14090  N   ASN C 477     -15.094  67.682  30.350  1.00 37.31           N  
ATOM  14091  CA  ASN C 477     -14.659  66.317  30.057  1.00 38.60           C  
ATOM  14092  C   ASN C 477     -13.638  66.333  28.919  1.00 39.11           C  
ATOM  14093  O   ASN C 477     -13.524  65.374  28.168  1.00 39.12           O  
ATOM  14094  CB  ASN C 477     -15.864  65.415  29.819  1.00 37.68           C  
ATOM  14095  CG  ASN C 477     -16.895  65.503  30.937  1.00 38.57           C  
ATOM  14096  OD1 ASN C 477     -16.533  65.632  32.101  1.00 38.16           O  
ATOM  14097  ND2 ASN C 477     -18.169  65.484  30.617  1.00 34.14           N  
ATOM  14098  N   CYS C 478     -12.926  67.443  28.746  1.00 33.81           N  
ATOM  14099  CA  CYS C 478     -11.825  67.598  27.807  1.00 33.27           C  
ATOM  14100  C   CYS C 478     -10.630  68.120  28.626  1.00 31.71           C  
ATOM  14101  O   CYS C 478     -10.093  69.192  28.423  1.00 30.90           O  
ATOM  14102  CB  CYS C 478     -12.080  68.529  26.634  1.00 31.81           C  
ATOM  14103  SG  CYS C 478     -13.405  67.976  25.550  1.00 35.32           S  
ATOM  14104  N   VAL C 479     -10.243  67.319  29.611  1.00 31.51           N  
ATOM  14105  CA  VAL C 479      -9.175  67.655  30.511  1.00 32.39           C  
ATOM  14106  C   VAL C 479      -7.840  67.769  29.792  1.00 35.13           C  
ATOM  14107  O   VAL C 479      -7.302  66.824  29.209  1.00 35.74           O  
ATOM  14108  CB  VAL C 479      -9.180  66.687  31.706  1.00 32.28           C  
ATOM  14109  CG1 VAL C 479      -8.060  66.968  32.694  1.00 29.48           C  
ATOM  14110  CG2 VAL C 479     -10.518  66.786  32.456  1.00 25.92           C  
ATOM  14111  N   VAL C 480      -7.288  68.985  29.845  1.00 34.14           N  
ATOM  14112  CA  VAL C 480      -5.984  69.250  29.271  1.00 32.02           C  
ATOM  14113  C   VAL C 480      -4.963  68.226  29.741  1.00 31.33           C  
ATOM  14114  O   VAL C 480      -4.767  68.017  30.926  1.00 31.83           O  
ATOM  14115  CB  VAL C 480      -5.479  70.673  29.570  1.00 31.46           C  
ATOM  14116  CG1 VAL C 480      -4.040  70.854  29.107  1.00 29.36           C  
ATOM  14117  CG2 VAL C 480      -6.418  71.654  28.855  1.00 27.23           C  
ATOM  14118  N   GLY C 481      -4.322  67.580  28.764  1.00 31.01           N  
ATOM  14119  CA  GLY C 481      -3.339  66.550  29.031  1.00 28.43           C  
ATOM  14120  C   GLY C 481      -3.888  65.138  28.857  1.00 30.55           C  
ATOM  14121  O   GLY C 481      -3.154  64.160  29.025  1.00 29.50           O  
ATOM  14122  N   THR C 482      -5.176  65.016  28.576  1.00 28.51           N  
ATOM  14123  CA  THR C 482      -5.782  63.707  28.404  1.00 30.64           C  
ATOM  14124  C   THR C 482      -6.143  63.605  26.918  1.00 30.87           C  
ATOM  14125  O   THR C 482      -6.160  64.631  26.211  1.00 28.66           O  
ATOM  14126  CB  THR C 482      -7.040  63.413  29.229  1.00 32.36           C  
ATOM  14127  OG1 THR C 482      -8.142  64.200  28.723  1.00 25.86           O  
ATOM  14128  CG2 THR C 482      -6.858  63.676  30.710  1.00 29.62           C  
ATOM  14129  N   ARG C 483      -6.437  62.374  26.479  1.00 28.49           N  
ATOM  14130  CA  ARG C 483      -6.777  62.236  25.062  1.00 29.20           C  
ATOM  14131  C   ARG C 483      -8.123  62.901  24.824  1.00 28.84           C  
ATOM  14132  O   ARG C 483      -8.995  62.845  25.680  1.00 30.52           O  
ATOM  14133  CB  ARG C 483      -6.755  60.794  24.590  1.00 27.26           C  
ATOM  14134  CG  ARG C 483      -7.726  59.775  25.201  1.00 26.66           C  
ATOM  14135  CD  ARG C 483      -9.048  59.829  24.426  1.00 24.55           C  
ATOM  14136  NE  ARG C 483      -9.728  58.554  24.433  1.00 23.01           N  
ATOM  14137  CZ  ARG C 483     -10.531  58.101  25.387  1.00 26.95           C  
ATOM  14138  NH1 ARG C 483     -10.831  58.845  26.480  1.00 24.41           N  
ATOM  14139  NH2 ARG C 483     -11.029  56.886  25.224  1.00 21.80           N  
ATOM  14140  N   PHE C 484      -8.238  63.596  23.723  1.00 28.29           N  
ATOM  14141  CA  PHE C 484      -9.471  64.173  23.245  1.00 28.95           C  
ATOM  14142  C   PHE C 484     -10.332  62.992  22.827  1.00 31.94           C  
ATOM  14143  O   PHE C 484     -10.057  62.233  21.852  1.00 32.98           O  
ATOM  14144  CB  PHE C 484      -9.176  65.136  22.096  1.00 28.65           C  
ATOM  14145  CG  PHE C 484     -10.457  65.805  21.678  1.00 33.09           C  
ATOM  14146  CD1 PHE C 484     -10.857  66.963  22.320  1.00 28.17           C  
ATOM  14147  CD2 PHE C 484     -11.248  65.229  20.685  1.00 29.94           C  
ATOM  14148  CE1 PHE C 484     -12.059  67.557  21.949  1.00 31.00           C  
ATOM  14149  CE2 PHE C 484     -12.424  65.842  20.326  1.00 31.06           C  
ATOM  14150  CZ  PHE C 484     -12.852  67.018  20.954  1.00 30.42           C  
ATOM  14151  N   LYS C 485     -11.358  62.761  23.631  1.00 30.61           N  
ATOM  14152  CA  LYS C 485     -12.230  61.625  23.459  1.00 30.09           C  
ATOM  14153  C   LYS C 485     -13.208  61.825  22.311  1.00 29.67           C  
ATOM  14154  O   LYS C 485     -13.806  62.878  22.173  1.00 31.62           O  
ATOM  14155  CB  LYS C 485     -12.993  61.343  24.755  1.00 33.48           C  
ATOM  14156  CG  LYS C 485     -13.880  60.111  24.665  1.00 38.10           C  
ATOM  14157  CD  LYS C 485     -14.380  59.726  26.063  1.00 38.66           C  
ATOM  14158  CE  LYS C 485     -15.333  58.550  25.899  1.00 42.40           C  
ATOM  14159  NZ  LYS C 485     -15.822  58.022  27.185  1.00 42.70           N  
ATOM  14160  N   SER C 486     -13.358  60.783  21.501  1.00 27.28           N  
ATOM  14161  CA  SER C 486     -14.293  60.830  20.394  1.00 26.13           C  
ATOM  14162  C   SER C 486     -15.738  60.877  20.913  1.00 28.15           C  
ATOM  14163  O   SER C 486     -16.021  60.219  21.911  1.00 22.81           O  
ATOM  14164  CB  SER C 486     -14.202  59.545  19.560  1.00 23.45           C  
ATOM  14165  OG  SER C 486     -15.142  59.653  18.495  1.00 24.17           O  
ATOM  14166  N   GLN C 487     -16.639  61.553  20.217  1.00 25.18           N  
ATOM  14167  CA  GLN C 487     -18.047  61.492  20.559  1.00 28.78           C  
ATOM  14168  C   GLN C 487     -18.777  61.566  19.218  1.00 28.81           C  
ATOM  14169  O   GLN C 487     -18.259  62.213  18.314  1.00 31.45           O  
ATOM  14170  CB  GLN C 487     -18.556  62.648  21.441  1.00 29.34           C  
ATOM  14171  CG  GLN C 487     -17.958  62.824  22.802  1.00 24.74           C  
ATOM  14172  CD  GLN C 487     -18.223  61.755  23.826  1.00 33.70           C  
ATOM  14173  OE1 GLN C 487     -19.194  60.996  23.719  1.00 32.48           O  
ATOM  14174  NE2 GLN C 487     -17.382  61.701  24.858  1.00 28.02           N  
ATOM  14175  N   PRO C 488     -19.942  60.941  19.141  1.00 29.49           N  
ATOM  14176  CA  PRO C 488     -20.753  60.987  17.922  1.00 29.43           C  
ATOM  14177  C   PRO C 488     -21.175  62.388  17.555  1.00 29.99           C  
ATOM  14178  O   PRO C 488     -21.429  63.258  18.395  1.00 30.06           O  
ATOM  14179  CB  PRO C 488     -21.969  60.115  18.257  1.00 26.12           C  
ATOM  14180  CG  PRO C 488     -21.472  59.218  19.331  1.00 25.04           C  
ATOM  14181  CD  PRO C 488     -20.588  60.126  20.192  1.00 23.04           C  
ATOM  14182  N   VAL C 489     -21.094  62.727  16.285  1.00 30.67           N  
ATOM  14183  CA  VAL C 489     -21.496  64.016  15.752  1.00 30.26           C  
ATOM  14184  C   VAL C 489     -22.190  63.751  14.427  1.00 29.59           C  
ATOM  14185  O   VAL C 489     -22.208  62.596  14.010  1.00 32.34           O  
ATOM  14186  CB  VAL C 489     -20.404  65.073  15.538  1.00 34.81           C  
ATOM  14187  CG1 VAL C 489     -19.804  65.486  16.876  1.00 32.23           C  
ATOM  14188  CG2 VAL C 489     -19.355  64.605  14.538  1.00 33.77           C  
ATOM  14189  N   VAL C 490     -22.811  64.732  13.826  1.00 28.55           N  
ATOM  14190  CA  VAL C 490     -23.529  64.611  12.576  1.00 28.14           C  
ATOM  14191  C   VAL C 490     -22.862  65.563  11.598  1.00 31.81           C  
ATOM  14192  O   VAL C 490     -22.809  66.764  11.867  1.00 31.68           O  
ATOM  14193  CB  VAL C 490     -25.008  64.998  12.749  1.00 30.50           C  
ATOM  14194  CG1 VAL C 490     -25.814  65.047  11.458  1.00 24.43           C  
ATOM  14195  CG2 VAL C 490     -25.681  64.025  13.697  1.00 27.83           C  
ATOM  14196  N   ARG C 491     -22.211  65.029  10.582  1.00 33.64           N  
ATOM  14197  CA  ARG C 491     -21.513  65.875   9.611  1.00 34.05           C  
ATOM  14198  C   ARG C 491     -22.615  66.722   8.988  1.00 34.08           C  
ATOM  14199  O   ARG C 491     -23.613  66.128   8.566  1.00 35.52           O  
ATOM  14200  CB  ARG C 491     -20.752  65.062   8.565  1.00 33.13           C  
ATOM  14201  CG  ARG C 491     -19.877  65.902   7.651  1.00 35.51           C  
ATOM  14202  CD  ARG C 491     -18.792  65.130   6.925  1.00 32.66           C  
ATOM  14203  NE  ARG C 491     -19.348  64.064   6.084  1.00 32.29           N  
ATOM  14204  CZ  ARG C 491     -18.713  62.933   5.789  1.00 33.28           C  
ATOM  14205  NH1 ARG C 491     -17.512  62.762   6.311  1.00 28.13           N  
ATOM  14206  NH2 ARG C 491     -19.260  61.995   5.035  1.00 32.31           N  
ATOM  14207  N   HIS C 492     -22.457  68.026   8.930  1.00 35.12           N  
ATOM  14208  CA  HIS C 492     -23.474  68.902   8.374  1.00 34.34           C  
ATOM  14209  C   HIS C 492     -23.708  68.779   6.893  1.00 36.57           C  
ATOM  14210  O   HIS C 492     -24.848  68.954   6.412  1.00 38.65           O  
ATOM  14211  CB  HIS C 492     -23.103  70.339   8.760  1.00 34.41           C  
ATOM  14212  CG  HIS C 492     -24.265  71.278   8.761  1.00 35.16           C  
ATOM  14213  ND1 HIS C 492     -24.704  71.907   9.912  1.00 36.90           N  
ATOM  14214  CD2 HIS C 492     -25.064  71.723   7.765  1.00 33.29           C  
ATOM  14215  CE1 HIS C 492     -25.694  72.708   9.638  1.00 34.64           C  
ATOM  14216  NE2 HIS C 492     -25.931  72.616   8.338  1.00 35.55           N  
ATOM  14217  N   SER C 493     -22.666  68.556   6.116  1.00 34.46           N  
ATOM  14218  CA  SER C 493     -22.763  68.415   4.665  1.00 33.34           C  
ATOM  14219  C   SER C 493     -23.895  67.508   4.225  1.00 32.68           C  
ATOM  14220  O   SER C 493     -24.682  67.947   3.372  1.00 35.31           O  
ATOM  14221  CB  SER C 493     -21.438  67.910   4.050  1.00 26.65           C  
ATOM  14222  OG  SER C 493     -21.078  66.673   4.656  1.00 35.67           O  
ATOM  14223  N   GLU C 494     -24.014  66.286   4.721  1.00 32.67           N  
ATOM  14224  CA  GLU C 494     -25.082  65.389   4.284  1.00 33.52           C  
ATOM  14225  C   GLU C 494     -25.853  64.756   5.432  1.00 32.29           C  
ATOM  14226  O   GLU C 494     -26.856  64.089   5.134  1.00 31.17           O  
ATOM  14227  CB  GLU C 494     -24.587  64.242   3.370  1.00 32.90           C  
ATOM  14228  CG  GLU C 494     -23.802  63.155   4.076  1.00 30.73           C  
ATOM  14229  CD  GLU C 494     -22.422  63.595   4.536  1.00 34.65           C  
ATOM  14230  OE1 GLU C 494     -21.460  63.517   3.756  1.00 33.10           O  
ATOM  14231  OE2 GLU C 494     -22.285  64.028   5.684  1.00 32.64           O  
ATOM  14232  N   GLY C 495     -25.437  65.016   6.677  1.00 32.00           N  
ATOM  14233  CA  GLY C 495     -26.216  64.468   7.793  1.00 31.62           C  
ATOM  14234  C   GLY C 495     -25.707  63.122   8.261  1.00 33.61           C  
ATOM  14235  O   GLY C 495     -26.441  62.443   8.992  1.00 33.51           O  
ATOM  14236  N   LEU C 496     -24.478  62.757   7.872  1.00 32.38           N  
ATOM  14237  CA  LEU C 496     -23.889  61.493   8.240  1.00 31.84           C  
ATOM  14238  C   LEU C 496     -23.556  61.467   9.725  1.00 32.77           C  
ATOM  14239  O   LEU C 496     -22.842  62.355  10.193  1.00 34.34           O  
ATOM  14240  CB  LEU C 496     -22.570  61.250   7.474  1.00 34.02           C  
ATOM  14241  CG  LEU C 496     -21.795  60.013   7.946  1.00 37.91           C  
ATOM  14242  CD1 LEU C 496     -22.490  58.725   7.519  1.00 35.30           C  
ATOM  14243  CD2 LEU C 496     -20.369  60.000   7.417  1.00 40.24           C  
ATOM  14244  N   TRP C 497     -24.051  60.476  10.437  1.00 33.15           N  
ATOM  14245  CA  TRP C 497     -23.759  60.328  11.858  1.00 34.85           C  
ATOM  14246  C   TRP C 497     -22.411  59.600  11.955  1.00 35.43           C  
ATOM  14247  O   TRP C 497     -22.220  58.547  11.336  1.00 34.54           O  
ATOM  14248  CB  TRP C 497     -24.830  59.508  12.568  1.00 26.75           C  
ATOM  14249  CG  TRP C 497     -24.583  59.166  14.003  1.00 28.32           C  
ATOM  14250  CD1 TRP C 497     -25.058  59.866  15.074  1.00 27.33           C  
ATOM  14251  CD2 TRP C 497     -23.905  58.040  14.561  1.00 30.97           C  
ATOM  14252  NE1 TRP C 497     -24.740  59.218  16.247  1.00 28.02           N  
ATOM  14253  CE2 TRP C 497     -24.042  58.092  15.952  1.00 28.12           C  
ATOM  14254  CE3 TRP C 497     -23.192  56.960  13.981  1.00 32.37           C  
ATOM  14255  CZ2 TRP C 497     -23.446  57.160  16.818  1.00 30.93           C  
ATOM  14256  CZ3 TRP C 497     -22.605  56.045  14.844  1.00 30.91           C  
ATOM  14257  CH2 TRP C 497     -22.725  56.139  16.252  1.00 33.71           C  
ATOM  14258  N   MET C 498     -21.487  60.174  12.708  1.00 36.66           N  
ATOM  14259  CA  MET C 498     -20.150  59.574  12.793  1.00 34.88           C  
ATOM  14260  C   MET C 498     -19.430  59.874  14.096  1.00 34.17           C  
ATOM  14261  O   MET C 498     -19.751  60.803  14.824  1.00 34.88           O  
ATOM  14262  CB  MET C 498     -19.238  60.068  11.652  1.00 28.24           C  
ATOM  14263  CG  MET C 498     -19.423  61.508  11.267  1.00 29.87           C  
ATOM  14264  SD  MET C 498     -17.922  62.287  10.577  1.00 35.05           S  
ATOM  14265  CE  MET C 498     -18.523  62.773   9.033  1.00 37.05           C  
ATOM  14266  N   HIS C 499     -18.471  58.994  14.376  1.00 31.35           N  
ATOM  14267  CA  HIS C 499     -17.590  59.220  15.511  1.00 30.96           C  
ATOM  14268  C   HIS C 499     -16.654  60.340  15.085  1.00 32.09           C  
ATOM  14269  O   HIS C 499     -15.879  60.230  14.126  1.00 33.34           O  
ATOM  14270  CB  HIS C 499     -16.880  57.910  15.825  1.00 28.16           C  
ATOM  14271  CG  HIS C 499     -17.853  56.889  16.317  1.00 33.45           C  
ATOM  14272  ND1 HIS C 499     -18.182  55.733  15.622  1.00 34.90           N  
ATOM  14273  CD2 HIS C 499     -18.577  56.855  17.453  1.00 32.05           C  
ATOM  14274  CE1 HIS C 499     -19.067  55.051  16.327  1.00 36.54           C  
ATOM  14275  NE2 HIS C 499     -19.314  55.710  17.456  1.00 35.66           N  
ATOM  14276  N   PHE C 500     -16.648  61.447  15.820  1.00 31.54           N  
ATOM  14277  CA  PHE C 500     -15.815  62.604  15.488  1.00 29.70           C  
ATOM  14278  C   PHE C 500     -14.342  62.287  15.530  1.00 29.68           C  
ATOM  14279  O   PHE C 500     -13.548  62.915  14.837  1.00 29.69           O  
ATOM  14280  CB  PHE C 500     -16.111  63.746  16.473  1.00 31.45           C  
ATOM  14281  CG  PHE C 500     -15.299  64.967  16.115  1.00 28.39           C  
ATOM  14282  CD1 PHE C 500     -15.652  65.750  15.025  1.00 31.08           C  
ATOM  14283  CD2 PHE C 500     -14.190  65.292  16.870  1.00 25.61           C  
ATOM  14284  CE1 PHE C 500     -14.881  66.861  14.693  1.00 28.84           C  
ATOM  14285  CE2 PHE C 500     -13.442  66.411  16.535  1.00 26.88           C  
ATOM  14286  CZ  PHE C 500     -13.792  67.191  15.460  1.00 28.79           C  
ATOM  14287  N   GLY C 501     -13.896  61.367  16.372  1.00 28.45           N  
ATOM  14288  CA  GLY C 501     -12.512  60.937  16.402  1.00 29.18           C  
ATOM  14289  C   GLY C 501     -11.994  60.434  15.070  1.00 29.82           C  
ATOM  14290  O   GLY C 501     -10.810  60.589  14.783  1.00 29.51           O  
ATOM  14291  N   ASP C 502     -12.833  59.950  14.164  1.00 31.17           N  
ATOM  14292  CA  ASP C 502     -12.409  59.576  12.825  1.00 31.85           C  
ATOM  14293  C   ASP C 502     -11.850  60.791  12.080  1.00 31.98           C  
ATOM  14294  O   ASP C 502     -11.051  60.636  11.169  1.00 31.71           O  
ATOM  14295  CB  ASP C 502     -13.545  59.025  11.958  1.00 28.10           C  
ATOM  14296  CG  ASP C 502     -14.036  57.667  12.455  1.00 29.36           C  
ATOM  14297  OD1 ASP C 502     -13.482  57.071  13.391  1.00 28.08           O  
ATOM  14298  OD2 ASP C 502     -15.047  57.227  11.829  1.00 35.01           O  
ATOM  14299  N   ARG C 503     -12.329  61.977  12.409  1.00 29.76           N  
ATOM  14300  CA  ARG C 503     -11.920  63.192  11.720  1.00 30.67           C  
ATOM  14301  C   ARG C 503     -10.517  63.654  12.086  1.00 29.87           C  
ATOM  14302  O   ARG C 503      -9.926  64.397  11.310  1.00 29.73           O  
ATOM  14303  CB  ARG C 503     -12.942  64.307  12.022  1.00 27.43           C  
ATOM  14304  CG  ARG C 503     -12.670  65.641  11.346  1.00 29.53           C  
ATOM  14305  CD  ARG C 503     -12.311  65.529   9.862  1.00 19.62           C  
ATOM  14306  NE  ARG C 503     -12.151  66.896   9.327  1.00 27.41           N  
ATOM  14307  CZ  ARG C 503     -10.997  67.559   9.463  1.00 28.00           C  
ATOM  14308  NH1 ARG C 503      -9.929  67.052  10.067  1.00 24.68           N  
ATOM  14309  NH2 ARG C 503     -10.907  68.796   8.997  1.00 24.48           N  
ATOM  14310  N   LEU C 504      -9.984  63.237  13.225  1.00 27.99           N  
ATOM  14311  CA  LEU C 504      -8.672  63.674  13.701  1.00 28.60           C  
ATOM  14312  C   LEU C 504      -7.517  62.857  13.153  1.00 29.86           C  
ATOM  14313  O   LEU C 504      -6.728  62.270  13.884  1.00 28.83           O  
ATOM  14314  CB  LEU C 504      -8.696  63.610  15.246  1.00 26.95           C  
ATOM  14315  CG  LEU C 504      -9.796  64.467  15.913  1.00 27.63           C  
ATOM  14316  CD1 LEU C 504      -9.795  64.365  17.419  1.00 26.25           C  
ATOM  14317  CD2 LEU C 504      -9.607  65.932  15.544  1.00 21.88           C  
ATOM  14318  N   VAL C 505      -7.405  62.817  11.820  1.00 29.61           N  
ATOM  14319  CA  VAL C 505      -6.360  62.055  11.147  1.00 29.43           C  
ATOM  14320  C   VAL C 505      -4.982  62.448  11.640  1.00 26.79           C  
ATOM  14321  O   VAL C 505      -4.635  63.623  11.569  1.00 28.85           O  
ATOM  14322  CB  VAL C 505      -6.445  62.281   9.615  1.00 33.09           C  
ATOM  14323  CG1 VAL C 505      -5.451  61.430   8.864  1.00 27.29           C  
ATOM  14324  CG2 VAL C 505      -7.835  61.942   9.111  1.00 33.82           C  
ATOM  14325  N   THR C 506      -4.160  61.505  12.086  1.00 28.32           N  
ATOM  14326  CA  THR C 506      -2.822  61.889  12.562  1.00 30.22           C  
ATOM  14327  C   THR C 506      -1.858  62.078  11.395  1.00 30.07           C  
ATOM  14328  O   THR C 506      -1.524  61.106  10.729  1.00 32.88           O  
ATOM  14329  CB  THR C 506      -2.284  60.838  13.534  1.00 31.91           C  
ATOM  14330  OG1 THR C 506      -3.118  60.868  14.677  1.00 26.70           O  
ATOM  14331  CG2 THR C 506      -0.832  61.097  13.915  1.00 26.54           C  
ATOM  14332  N   ASP C 507      -1.426  63.296  11.161  1.00 28.40           N  
ATOM  14333  CA  ASP C 507      -0.562  63.647  10.052  1.00 31.75           C  
ATOM  14334  C   ASP C 507       0.317  64.848  10.368  1.00 33.43           C  
ATOM  14335  O   ASP C 507       0.807  65.510   9.466  1.00 32.44           O  
ATOM  14336  CB  ASP C 507      -1.414  63.946   8.824  1.00 32.54           C  
ATOM  14337  CG  ASP C 507      -2.468  65.010   9.021  1.00 37.93           C  
ATOM  14338  OD1 ASP C 507      -2.413  65.790   9.988  1.00 37.29           O  
ATOM  14339  OD2 ASP C 507      -3.402  65.099   8.197  1.00 41.01           O  
ATOM  14340  N   GLY C 508       0.487  65.188  11.643  1.00 33.65           N  
ATOM  14341  CA  GLY C 508       1.295  66.319  12.045  1.00 34.13           C  
ATOM  14342  C   GLY C 508       0.544  67.612  12.299  1.00 33.73           C  
ATOM  14343  O   GLY C 508       1.147  68.554  12.839  1.00 32.56           O  
ATOM  14344  N   ARG C 509      -0.721  67.723  11.922  1.00 32.53           N  
ATOM  14345  CA  ARG C 509      -1.461  68.958  12.184  1.00 32.13           C  
ATOM  14346  C   ARG C 509      -1.977  69.003  13.634  1.00 30.69           C  
ATOM  14347  O   ARG C 509      -2.315  67.992  14.252  1.00 29.83           O  
ATOM  14348  CB  ARG C 509      -2.668  69.157  11.301  1.00 28.78           C  
ATOM  14349  CG  ARG C 509      -2.344  69.423   9.830  1.00 30.57           C  
ATOM  14350  CD  ARG C 509      -3.191  68.444   9.045  1.00 29.98           C  
ATOM  14351  NE  ARG C 509      -4.371  68.974   8.454  1.00 31.35           N  
ATOM  14352  CZ  ARG C 509      -5.405  68.229   8.075  1.00 31.30           C  
ATOM  14353  NH1 ARG C 509      -5.482  66.910   8.210  1.00 28.24           N  
ATOM  14354  NH2 ARG C 509      -6.386  68.959   7.561  1.00 30.84           N  
ATOM  14355  N   PHE C 510      -2.061  70.200  14.154  1.00 29.29           N  
ATOM  14356  CA  PHE C 510      -2.673  70.421  15.456  1.00 29.76           C  
ATOM  14357  C   PHE C 510      -4.138  70.695  15.085  1.00 30.15           C  
ATOM  14358  O   PHE C 510      -4.361  71.191  13.971  1.00 28.23           O  
ATOM  14359  CB  PHE C 510      -2.124  71.623  16.222  1.00 28.14           C  
ATOM  14360  CG  PHE C 510      -0.834  71.450  16.982  1.00 31.04           C  
ATOM  14361  CD1 PHE C 510       0.394  71.352  16.308  1.00 31.33           C  
ATOM  14362  CD2 PHE C 510      -0.834  71.429  18.362  1.00 28.42           C  
ATOM  14363  CE1 PHE C 510       1.590  71.223  16.991  1.00 29.03           C  
ATOM  14364  CE2 PHE C 510       0.344  71.281  19.056  1.00 31.85           C  
ATOM  14365  CZ  PHE C 510       1.550  71.208  18.369  1.00 32.38           C  
ATOM  14366  N   ARG C 511      -5.073  70.519  16.011  1.00 30.75           N  
ATOM  14367  CA  ARG C 511      -6.425  70.995  15.711  1.00 32.27           C  
ATOM  14368  C   ARG C 511      -6.848  72.109  16.677  1.00 32.99           C  
ATOM  14369  O   ARG C 511      -6.507  72.168  17.864  1.00 32.68           O  
ATOM  14370  CB  ARG C 511      -7.412  69.833  15.834  1.00 29.51           C  
ATOM  14371  CG  ARG C 511      -7.725  69.089  14.557  1.00 30.81           C  
ATOM  14372  CD  ARG C 511      -6.617  68.094  14.246  1.00 30.79           C  
ATOM  14373  NE  ARG C 511      -6.693  67.628  12.852  1.00 29.62           N  
ATOM  14374  CZ  ARG C 511      -6.140  66.469  12.479  1.00 28.79           C  
ATOM  14375  NH1 ARG C 511      -5.463  65.745  13.347  1.00 27.28           N  
ATOM  14376  NH2 ARG C 511      -6.216  66.036  11.237  1.00 27.18           N  
ATOM  14377  N   ILE C 512      -7.674  72.977  16.140  1.00 34.19           N  
ATOM  14378  CA  ILE C 512      -8.444  73.956  16.893  1.00 34.77           C  
ATOM  14379  C   ILE C 512      -9.921  73.558  16.800  1.00 33.91           C  
ATOM  14380  O   ILE C 512     -10.527  73.591  15.730  1.00 32.33           O  
ATOM  14381  CB  ILE C 512      -8.239  75.402  16.478  1.00 36.32           C  
ATOM  14382  CG1 ILE C 512      -6.799  75.873  16.809  1.00 30.08           C  
ATOM  14383  CG2 ILE C 512      -9.234  76.246  17.274  1.00 34.20           C  
ATOM  14384  CD1 ILE C 512      -6.558  77.289  16.345  1.00 25.99           C  
ATOM  14385  N   ILE C 513     -10.442  72.958  17.878  1.00 32.96           N  
ATOM  14386  CA  ILE C 513     -11.855  72.521  17.803  1.00 33.51           C  
ATOM  14387  C   ILE C 513     -12.716  73.697  18.292  1.00 34.85           C  
ATOM  14388  O   ILE C 513     -12.611  74.101  19.455  1.00 33.37           O  
ATOM  14389  CB  ILE C 513     -12.153  71.247  18.584  1.00 33.90           C  
ATOM  14390  CG1 ILE C 513     -11.266  70.071  18.202  1.00 33.42           C  
ATOM  14391  CG2 ILE C 513     -13.620  70.849  18.442  1.00 32.41           C  
ATOM  14392  CD1 ILE C 513     -11.203  69.681  16.735  1.00 30.42           C  
ATOM  14393  N   VAL C 514     -13.445  74.276  17.353  1.00 33.86           N  
ATOM  14394  CA  VAL C 514     -14.320  75.391  17.662  1.00 35.82           C  
ATOM  14395  C   VAL C 514     -15.711  74.929  18.046  1.00 37.42           C  
ATOM  14396  O   VAL C 514     -16.503  74.649  17.152  1.00 37.01           O  
ATOM  14397  CB  VAL C 514     -14.430  76.375  16.493  1.00 36.56           C  
ATOM  14398  CG1 VAL C 514     -15.341  77.543  16.881  1.00 36.02           C  
ATOM  14399  CG2 VAL C 514     -13.041  76.908  16.129  1.00 34.01           C  
ATOM  14400  N   PHE C 515     -16.015  74.845  19.336  1.00 37.61           N  
ATOM  14401  CA  PHE C 515     -17.372  74.502  19.773  1.00 35.83           C  
ATOM  14402  C   PHE C 515     -18.207  75.769  19.641  1.00 36.78           C  
ATOM  14403  O   PHE C 515     -18.332  76.544  20.591  1.00 36.44           O  
ATOM  14404  CB  PHE C 515     -17.383  73.991  21.202  1.00 32.75           C  
ATOM  14405  CG  PHE C 515     -16.853  72.608  21.377  1.00 36.56           C  
ATOM  14406  CD1 PHE C 515     -17.657  71.500  21.146  1.00 36.02           C  
ATOM  14407  CD2 PHE C 515     -15.524  72.397  21.749  1.00 35.43           C  
ATOM  14408  CE1 PHE C 515     -17.161  70.219  21.302  1.00 33.11           C  
ATOM  14409  CE2 PHE C 515     -15.034  71.107  21.904  1.00 33.41           C  
ATOM  14410  CZ  PHE C 515     -15.858  70.021  21.687  1.00 34.71           C  
ATOM  14411  N   ALA C 516     -18.805  75.962  18.459  1.00 35.80           N  
ATOM  14412  CA  ALA C 516     -19.550  77.179  18.174  1.00 38.73           C  
ATOM  14413  C   ALA C 516     -20.804  77.393  19.016  1.00 38.40           C  
ATOM  14414  O   ALA C 516     -21.300  78.511  18.937  1.00 36.03           O  
ATOM  14415  CB  ALA C 516     -19.916  77.276  16.694  1.00 33.18           C  
ATOM  14416  N   GLY C 517     -21.336  76.408  19.704  1.00 39.52           N  
ATOM  14417  CA  GLY C 517     -22.515  76.537  20.535  1.00 40.39           C  
ATOM  14418  C   GLY C 517     -23.794  76.783  19.757  1.00 41.85           C  
ATOM  14419  O   GLY C 517     -24.024  76.258  18.667  1.00 42.00           O  
ATOM  14420  N   LYS C 518     -24.679  77.624  20.295  1.00 43.26           N  
ATOM  14421  CA  LYS C 518     -25.964  77.879  19.649  1.00 42.33           C  
ATOM  14422  C   LYS C 518     -25.840  78.919  18.564  1.00 42.52           C  
ATOM  14423  O   LYS C 518     -26.299  80.059  18.694  1.00 44.12           O  
ATOM  14424  CB  LYS C 518     -26.989  78.285  20.701  1.00 44.25           C  
ATOM  14425  CG  LYS C 518     -28.392  78.444  20.128  1.00 48.81           C  
ATOM  14426  CD  LYS C 518     -29.391  78.528  21.269  1.00 51.60           C  
ATOM  14427  CE  LYS C 518     -30.761  78.946  20.757  1.00 55.25           C  
ATOM  14428  NZ  LYS C 518     -31.821  78.565  21.741  1.00 59.34           N  
ATOM  14429  N   ALA C 519     -25.369  78.528  17.403  1.00 41.88           N  
ATOM  14430  CA  ALA C 519     -24.999  79.432  16.327  1.00 43.25           C  
ATOM  14431  C   ALA C 519     -26.143  80.260  15.792  1.00 42.66           C  
ATOM  14432  O   ALA C 519     -25.882  81.269  15.129  1.00 42.00           O  
ATOM  14433  CB  ALA C 519     -24.293  78.645  15.211  1.00 43.16           C  
ATOM  14434  N   THR C 520     -27.396  79.872  15.982  1.00 42.29           N  
ATOM  14435  CA  THR C 520     -28.547  80.657  15.557  1.00 44.89           C  
ATOM  14436  C   THR C 520     -28.772  81.875  16.446  1.00 45.92           C  
ATOM  14437  O   THR C 520     -29.485  82.801  16.067  1.00 46.98           O  
ATOM  14438  CB  THR C 520     -29.848  79.834  15.579  1.00 42.29           C  
ATOM  14439  OG1 THR C 520     -29.834  79.051  16.782  1.00 42.47           O  
ATOM  14440  CG2 THR C 520     -29.888  78.909  14.380  1.00 43.50           C  
ATOM  14441  N   ASP C 521     -28.222  81.910  17.639  1.00 47.50           N  
ATOM  14442  CA  ASP C 521     -28.332  83.038  18.555  1.00 48.21           C  
ATOM  14443  C   ASP C 521     -27.496  84.187  18.014  1.00 49.35           C  
ATOM  14444  O   ASP C 521     -26.317  83.980  17.654  1.00 49.18           O  
ATOM  14445  CB  ASP C 521     -27.858  82.573  19.932  1.00 50.73           C  
ATOM  14446  CG  ASP C 521     -27.866  83.677  20.967  1.00 55.33           C  
ATOM  14447  OD1 ASP C 521     -28.989  84.081  21.337  1.00 60.72           O  
ATOM  14448  OD2 ASP C 521     -26.808  84.148  21.429  1.00 57.50           O  
ATOM  14449  N   ALA C 522     -28.066  85.370  17.892  1.00 47.81           N  
ATOM  14450  CA  ALA C 522     -27.362  86.538  17.374  1.00 48.02           C  
ATOM  14451  C   ALA C 522     -26.109  86.881  18.177  1.00 46.13           C  
ATOM  14452  O   ALA C 522     -25.059  87.140  17.604  1.00 48.52           O  
ATOM  14453  CB  ALA C 522     -28.229  87.773  17.295  1.00 44.30           C  
ATOM  14454  N   THR C 523     -26.164  86.846  19.485  1.00 46.32           N  
ATOM  14455  CA  THR C 523     -25.025  87.081  20.350  1.00 45.72           C  
ATOM  14456  C   THR C 523     -23.943  86.017  20.216  1.00 45.20           C  
ATOM  14457  O   THR C 523     -22.752  86.313  20.339  1.00 44.72           O  
ATOM  14458  CB  THR C 523     -25.534  87.165  21.807  1.00 48.22           C  
ATOM  14459  OG1 THR C 523     -26.513  88.227  21.836  1.00 52.09           O  
ATOM  14460  CG2 THR C 523     -24.420  87.478  22.789  1.00 41.65           C  
ATOM  14461  N   GLN C 524     -24.324  84.754  19.979  1.00 43.96           N  
ATOM  14462  CA  GLN C 524     -23.345  83.686  19.884  1.00 43.25           C  
ATOM  14463  C   GLN C 524     -22.631  83.732  18.542  1.00 43.11           C  
ATOM  14464  O   GLN C 524     -21.403  83.598  18.458  1.00 39.68           O  
ATOM  14465  CB  GLN C 524     -23.988  82.332  20.182  1.00 43.35           C  
ATOM  14466  CG  GLN C 524     -23.025  81.159  20.132  1.00 43.21           C  
ATOM  14467  CD  GLN C 524     -21.912  81.225  21.152  1.00 44.54           C  
ATOM  14468  OE1 GLN C 524     -21.918  82.036  22.075  1.00 43.34           O  
ATOM  14469  NE2 GLN C 524     -20.909  80.361  21.010  1.00 45.07           N  
ATOM  14470  N   MET C 525     -23.372  84.119  17.512  1.00 43.77           N  
ATOM  14471  CA  MET C 525     -22.835  84.245  16.160  1.00 45.41           C  
ATOM  14472  C   MET C 525     -21.914  85.452  16.080  1.00 47.89           C  
ATOM  14473  O   MET C 525     -21.029  85.461  15.217  1.00 48.39           O  
ATOM  14474  CB  MET C 525     -23.934  84.335  15.099  1.00 39.13           C  
ATOM  14475  CG  MET C 525     -23.465  84.431  13.665  1.00 42.66           C  
ATOM  14476  SD  MET C 525     -22.269  83.156  13.174  1.00 43.35           S  
ATOM  14477  CE  MET C 525     -23.404  81.830  12.741  1.00 39.36           C  
ATOM  14478  N   SER C 526     -22.118  86.430  16.967  1.00 47.66           N  
ATOM  14479  CA  SER C 526     -21.235  87.590  16.994  1.00 46.11           C  
ATOM  14480  C   SER C 526     -19.861  87.154  17.496  1.00 41.70           C  
ATOM  14481  O   SER C 526     -18.828  87.578  16.998  1.00 41.08           O  
ATOM  14482  CB  SER C 526     -21.815  88.663  17.930  1.00 49.79           C  
ATOM  14483  OG  SER C 526     -22.336  89.708  17.117  1.00 53.80           O  
ATOM  14484  N   ARG C 527     -19.889  86.312  18.535  1.00 39.44           N  
ATOM  14485  CA  ARG C 527     -18.646  85.785  19.090  1.00 41.04           C  
ATOM  14486  C   ARG C 527     -17.958  84.896  18.053  1.00 42.44           C  
ATOM  14487  O   ARG C 527     -16.741  84.982  17.849  1.00 42.94           O  
ATOM  14488  CB  ARG C 527     -18.886  85.054  20.395  1.00 42.27           C  
ATOM  14489  CG  ARG C 527     -19.459  85.886  21.554  1.00 35.75           C  
ATOM  14490  CD  ARG C 527     -19.917  84.927  22.670  1.00 31.37           C  
ATOM  14491  NE  ARG C 527     -18.741  84.361  23.327  1.00 35.03           N  
ATOM  14492  CZ  ARG C 527     -18.571  83.136  23.806  1.00 33.81           C  
ATOM  14493  NH1 ARG C 527     -19.533  82.231  23.714  1.00 35.69           N  
ATOM  14494  NH2 ARG C 527     -17.445  82.761  24.391  1.00 29.26           N  
ATOM  14495  N   ILE C 528     -18.707  84.094  17.304  1.00 41.75           N  
ATOM  14496  CA  ILE C 528     -18.170  83.202  16.300  1.00 41.06           C  
ATOM  14497  C   ILE C 528     -17.511  84.003  15.191  1.00 42.89           C  
ATOM  14498  O   ILE C 528     -16.360  83.751  14.808  1.00 41.53           O  
ATOM  14499  CB  ILE C 528     -19.261  82.265  15.755  1.00 42.13           C  
ATOM  14500  CG1 ILE C 528     -19.760  81.310  16.854  1.00 39.66           C  
ATOM  14501  CG2 ILE C 528     -18.799  81.423  14.575  1.00 38.20           C  
ATOM  14502  CD1 ILE C 528     -21.113  80.707  16.567  1.00 38.14           C  
ATOM  14503  N   LYS C 529     -18.147  85.063  14.712  1.00 43.93           N  
ATOM  14504  CA  LYS C 529     -17.590  85.916  13.682  1.00 44.97           C  
ATOM  14505  C   LYS C 529     -16.334  86.661  14.145  1.00 45.81           C  
ATOM  14506  O   LYS C 529     -15.406  86.864  13.358  1.00 45.45           O  
ATOM  14507  CB  LYS C 529     -18.570  86.988  13.216  1.00 45.80           C  
ATOM  14508  CG  LYS C 529     -19.791  86.436  12.501  1.00 49.96           C  
ATOM  14509  CD  LYS C 529     -20.596  87.587  11.922  1.00 51.14           C  
ATOM  14510  CE  LYS C 529     -21.696  87.067  11.004  1.00 55.25           C  
ATOM  14511  NZ  LYS C 529     -22.936  87.873  11.214  1.00 62.65           N  
ATOM  14512  N   LYS C 530     -16.355  87.076  15.419  1.00 44.05           N  
ATOM  14513  CA  LYS C 530     -15.198  87.767  15.952  1.00 44.83           C  
ATOM  14514  C   LYS C 530     -14.022  86.789  16.005  1.00 42.78           C  
ATOM  14515  O   LYS C 530     -12.918  87.167  15.650  1.00 42.95           O  
ATOM  14516  CB  LYS C 530     -15.528  88.397  17.300  1.00 48.40           C  
ATOM  14517  CG  LYS C 530     -14.331  88.916  18.069  1.00 50.87           C  
ATOM  14518  CD  LYS C 530     -14.668  90.219  18.771  1.00 59.47           C  
ATOM  14519  CE  LYS C 530     -13.427  90.813  19.431  1.00 60.31           C  
ATOM  14520  NZ  LYS C 530     -13.182  90.180  20.766  1.00 66.84           N  
ATOM  14521  N   PHE C 531     -14.261  85.545  16.398  1.00 41.04           N  
ATOM  14522  CA  PHE C 531     -13.232  84.522  16.409  1.00 41.16           C  
ATOM  14523  C   PHE C 531     -12.699  84.225  15.001  1.00 38.62           C  
ATOM  14524  O   PHE C 531     -11.500  84.125  14.748  1.00 36.43           O  
ATOM  14525  CB  PHE C 531     -13.747  83.227  17.049  1.00 38.70           C  
ATOM  14526  CG  PHE C 531     -12.660  82.194  17.152  1.00 40.94           C  
ATOM  14527  CD1 PHE C 531     -11.694  82.278  18.140  1.00 34.18           C  
ATOM  14528  CD2 PHE C 531     -12.604  81.146  16.238  1.00 36.05           C  
ATOM  14529  CE1 PHE C 531     -10.699  81.332  18.239  1.00 36.24           C  
ATOM  14530  CE2 PHE C 531     -11.605  80.204  16.326  1.00 33.71           C  
ATOM  14531  CZ  PHE C 531     -10.657  80.288  17.336  1.00 33.98           C  
ATOM  14532  N   SER C 532     -13.588  84.202  14.018  1.00 36.89           N  
ATOM  14533  CA  SER C 532     -13.139  83.989  12.651  1.00 38.88           C  
ATOM  14534  C   SER C 532     -12.406  85.192  12.088  1.00 41.95           C  
ATOM  14535  O   SER C 532     -11.540  85.000  11.217  1.00 43.31           O  
ATOM  14536  CB  SER C 532     -14.324  83.608  11.782  1.00 40.96           C  
ATOM  14537  OG  SER C 532     -14.486  84.580  10.777  1.00 53.48           O  
ATOM  14538  N   ALA C 533     -12.679  86.403  12.560  1.00 39.67           N  
ATOM  14539  CA  ALA C 533     -11.966  87.591  12.152  1.00 38.34           C  
ATOM  14540  C   ALA C 533     -10.554  87.508  12.743  1.00 39.31           C  
ATOM  14541  O   ALA C 533      -9.590  87.896  12.093  1.00 39.78           O  
ATOM  14542  CB  ALA C 533     -12.668  88.873  12.606  1.00 38.40           C  
ATOM  14543  N   TYR C 534     -10.440  86.941  13.947  1.00 35.72           N  
ATOM  14544  CA  TYR C 534      -9.124  86.734  14.503  1.00 36.55           C  
ATOM  14545  C   TYR C 534      -8.398  85.760  13.555  1.00 39.99           C  
ATOM  14546  O   TYR C 534      -7.331  86.098  13.047  1.00 38.36           O  
ATOM  14547  CB  TYR C 534      -9.117  86.263  15.961  1.00 35.72           C  
ATOM  14548  CG  TYR C 534      -7.856  85.462  16.265  1.00 38.38           C  
ATOM  14549  CD1 TYR C 534      -6.669  86.108  16.510  1.00 36.60           C  
ATOM  14550  CD2 TYR C 534      -7.872  84.070  16.250  1.00 35.97           C  
ATOM  14551  CE1 TYR C 534      -5.516  85.395  16.768  1.00 39.11           C  
ATOM  14552  CE2 TYR C 534      -6.713  83.350  16.499  1.00 36.16           C  
ATOM  14553  CZ  TYR C 534      -5.540  84.022  16.755  1.00 38.73           C  
ATOM  14554  OH  TYR C 534      -4.387  83.319  17.003  1.00 39.67           O  
ATOM  14555  N   LEU C 535      -8.978  84.593  13.286  1.00 38.49           N  
ATOM  14556  CA  LEU C 535      -8.356  83.606  12.415  1.00 40.38           C  
ATOM  14557  C   LEU C 535      -7.906  84.151  11.062  1.00 38.60           C  
ATOM  14558  O   LEU C 535      -6.842  83.807  10.579  1.00 35.90           O  
ATOM  14559  CB  LEU C 535      -9.291  82.430  12.138  1.00 38.53           C  
ATOM  14560  CG  LEU C 535      -9.760  81.585  13.310  1.00 35.56           C  
ATOM  14561  CD1 LEU C 535     -10.913  80.702  12.843  1.00 34.39           C  
ATOM  14562  CD2 LEU C 535      -8.610  80.781  13.900  1.00 34.23           C  
ATOM  14563  N   ASP C 536      -8.725  85.018  10.463  1.00 37.15           N  
ATOM  14564  CA  ASP C 536      -8.390  85.643   9.202  1.00 37.82           C  
ATOM  14565  C   ASP C 536      -7.346  86.744   9.316  1.00 39.18           C  
ATOM  14566  O   ASP C 536      -6.744  87.127   8.301  1.00 40.50           O  
ATOM  14567  CB  ASP C 536      -9.662  86.214   8.561  1.00 34.90           C  
ATOM  14568  CG  ASP C 536     -10.534  85.118   7.962  1.00 40.25           C  
ATOM  14569  OD1 ASP C 536     -10.156  83.922   7.818  1.00 34.96           O  
ATOM  14570  OD2 ASP C 536     -11.677  85.498   7.604  1.00 40.69           O  
ATOM  14571  N   SER C 537      -7.156  87.283  10.528  1.00 40.33           N  
ATOM  14572  CA  SER C 537      -6.216  88.383  10.680  1.00 43.19           C  
ATOM  14573  C   SER C 537      -4.790  87.982  10.359  1.00 44.03           C  
ATOM  14574  O   SER C 537      -4.350  86.852  10.481  1.00 43.34           O  
ATOM  14575  CB  SER C 537      -6.368  88.991  12.060  1.00 38.19           C  
ATOM  14576  OG  SER C 537      -5.803  88.138  13.047  1.00 40.40           O  
ATOM  14577  N   GLU C 538      -3.989  88.956   9.988  1.00 45.64           N  
ATOM  14578  CA  GLU C 538      -2.612  88.911   9.591  1.00 44.53           C  
ATOM  14579  C   GLU C 538      -1.721  88.116  10.529  1.00 44.41           C  
ATOM  14580  O   GLU C 538      -0.825  87.403  10.065  1.00 45.45           O  
ATOM  14581  CB  GLU C 538      -2.062  90.340   9.479  1.00 44.48           C  
ATOM  14582  CG  GLU C 538      -0.617  90.526   9.099  1.00 48.67           C  
ATOM  14583  CD  GLU C 538      -0.183  89.920   7.784  1.00 52.75           C  
ATOM  14584  OE1 GLU C 538      -0.919  89.945   6.761  1.00 53.56           O  
ATOM  14585  OE2 GLU C 538       0.968  89.413   7.752  1.00 57.47           O  
ATOM  14586  N   ASN C 539      -1.907  88.253  11.831  1.00 43.05           N  
ATOM  14587  CA  ASN C 539      -1.044  87.620  12.810  1.00 42.76           C  
ATOM  14588  C   ASN C 539      -1.680  86.484  13.596  1.00 41.56           C  
ATOM  14589  O   ASN C 539      -1.080  86.121  14.619  1.00 39.22           O  
ATOM  14590  CB  ASN C 539      -0.516  88.668  13.798  1.00 49.70           C  
ATOM  14591  CG  ASN C 539       0.458  89.636  13.169  1.00 52.60           C  
ATOM  14592  OD1 ASN C 539       1.528  89.265  12.707  1.00 55.81           O  
ATOM  14593  ND2 ASN C 539       0.097  90.903  13.126  1.00 53.92           N  
ATOM  14594  N   SER C 540      -2.804  85.932  13.143  1.00 38.56           N  
ATOM  14595  CA  SER C 540      -3.348  84.798  13.907  1.00 38.79           C  
ATOM  14596  C   SER C 540      -2.404  83.604  13.765  1.00 38.53           C  
ATOM  14597  O   SER C 540      -1.514  83.585  12.910  1.00 37.73           O  
ATOM  14598  CB  SER C 540      -4.713  84.375  13.383  1.00 42.23           C  
ATOM  14599  OG  SER C 540      -4.588  83.670  12.154  1.00 40.19           O  
ATOM  14600  N   VAL C 541      -2.698  82.509  14.465  1.00 39.06           N  
ATOM  14601  CA  VAL C 541      -1.863  81.312  14.354  1.00 37.36           C  
ATOM  14602  C   VAL C 541      -2.009  80.677  12.974  1.00 37.47           C  
ATOM  14603  O   VAL C 541      -1.040  80.116  12.444  1.00 39.45           O  
ATOM  14604  CB  VAL C 541      -2.197  80.307  15.451  1.00 36.46           C  
ATOM  14605  CG1 VAL C 541      -1.745  80.866  16.798  1.00 34.28           C  
ATOM  14606  CG2 VAL C 541      -3.702  80.015  15.424  1.00 31.76           C  
ATOM  14607  N   ILE C 542      -3.166  80.823  12.342  1.00 36.18           N  
ATOM  14608  CA  ILE C 542      -3.366  80.321  11.003  1.00 37.85           C  
ATOM  14609  C   ILE C 542      -2.511  81.102  10.010  1.00 39.40           C  
ATOM  14610  O   ILE C 542      -1.801  80.525   9.211  1.00 35.47           O  
ATOM  14611  CB  ILE C 542      -4.845  80.401  10.566  1.00 35.80           C  
ATOM  14612  CG1 ILE C 542      -5.717  79.788  11.655  1.00 35.60           C  
ATOM  14613  CG2 ILE C 542      -5.011  79.716   9.208  1.00 30.32           C  
ATOM  14614  CD1 ILE C 542      -5.362  78.384  12.051  1.00 33.18           C  
ATOM  14615  N   SER C 543      -2.562  82.434  10.065  1.00 39.41           N  
ATOM  14616  CA  SER C 543      -1.823  83.236   9.098  1.00 39.37           C  
ATOM  14617  C   SER C 543      -0.307  83.143   9.233  1.00 38.38           C  
ATOM  14618  O   SER C 543       0.443  83.219   8.248  1.00 37.86           O  
ATOM  14619  CB  SER C 543      -2.336  84.667   9.215  1.00 37.88           C  
ATOM  14620  OG  SER C 543      -3.708  84.678   8.830  1.00 39.93           O  
ATOM  14621  N   LEU C 544       0.166  83.040  10.461  1.00 38.96           N  
ATOM  14622  CA  LEU C 544       1.550  82.955  10.832  1.00 40.16           C  
ATOM  14623  C   LEU C 544       2.143  81.568  10.548  1.00 41.39           C  
ATOM  14624  O   LEU C 544       3.351  81.479  10.271  1.00 38.49           O  
ATOM  14625  CB  LEU C 544       1.646  83.184  12.333  1.00 41.90           C  
ATOM  14626  CG  LEU C 544       2.656  84.079  13.011  1.00 50.30           C  
ATOM  14627  CD1 LEU C 544       2.084  85.491  13.184  1.00 54.88           C  
ATOM  14628  CD2 LEU C 544       3.074  83.612  14.397  1.00 45.17           C  
ATOM  14629  N   TYR C 545       1.372  80.498  10.800  1.00 38.62           N  
ATOM  14630  CA  TYR C 545       1.987  79.180  10.745  1.00 38.82           C  
ATOM  14631  C   TYR C 545       1.739  78.368   9.496  1.00 37.37           C  
ATOM  14632  O   TYR C 545       2.350  77.300   9.385  1.00 35.76           O  
ATOM  14633  CB  TYR C 545       1.685  78.345  12.006  1.00 39.08           C  
ATOM  14634  CG  TYR C 545       2.315  79.076  13.181  1.00 39.53           C  
ATOM  14635  CD1 TYR C 545       3.699  79.193  13.272  1.00 37.17           C  
ATOM  14636  CD2 TYR C 545       1.513  79.671  14.149  1.00 38.30           C  
ATOM  14637  CE1 TYR C 545       4.283  79.882  14.326  1.00 36.97           C  
ATOM  14638  CE2 TYR C 545       2.076  80.336  15.211  1.00 37.48           C  
ATOM  14639  CZ  TYR C 545       3.447  80.447  15.291  1.00 38.35           C  
ATOM  14640  OH  TYR C 545       3.967  81.134  16.349  1.00 36.80           O  
ATOM  14641  N   THR C 546       0.928  78.881   8.582  1.00 36.48           N  
ATOM  14642  CA  THR C 546       0.742  78.152   7.335  1.00 37.84           C  
ATOM  14643  C   THR C 546       1.547  78.901   6.265  1.00 38.08           C  
ATOM  14644  O   THR C 546       1.413  80.099   6.060  1.00 37.54           O  
ATOM  14645  CB  THR C 546      -0.659  77.853   6.831  1.00 37.80           C  
ATOM  14646  OG1 THR C 546      -0.922  78.538   5.610  1.00 43.51           O  
ATOM  14647  CG2 THR C 546      -1.782  78.146   7.773  1.00 30.46           C  
ATOM  14648  N   PRO C 547       2.444  78.159   5.625  1.00 37.61           N  
ATOM  14649  CA  PRO C 547       3.285  78.706   4.575  1.00 36.31           C  
ATOM  14650  C   PRO C 547       2.490  79.421   3.508  1.00 37.46           C  
ATOM  14651  O   PRO C 547       1.375  79.031   3.159  1.00 36.27           O  
ATOM  14652  CB  PRO C 547       3.990  77.480   3.980  1.00 33.79           C  
ATOM  14653  CG  PRO C 547       3.981  76.471   5.104  1.00 35.39           C  
ATOM  14654  CD  PRO C 547       2.685  76.701   5.841  1.00 35.78           C  
ATOM  14655  N   LYS C 548       3.089  80.463   2.926  1.00 38.46           N  
ATOM  14656  CA  LYS C 548       2.468  81.182   1.828  1.00 40.30           C  
ATOM  14657  C   LYS C 548       2.080  80.176   0.744  1.00 43.91           C  
ATOM  14658  O   LYS C 548       2.756  79.242   0.334  1.00 43.55           O  
ATOM  14659  CB  LYS C 548       3.415  82.204   1.224  1.00 44.78           C  
ATOM  14660  CG  LYS C 548       2.831  82.982   0.043  1.00 49.02           C  
ATOM  14661  CD  LYS C 548       3.919  83.917  -0.487  1.00 56.73           C  
ATOM  14662  CE  LYS C 548       3.528  84.595  -1.785  1.00 59.71           C  
ATOM  14663  NZ  LYS C 548       3.006  85.974  -1.582  1.00 61.63           N  
ATOM  14664  N   VAL C 549       0.912  80.394   0.210  1.00 45.05           N  
ATOM  14665  CA  VAL C 549       0.045  79.722  -0.689  1.00 45.53           C  
ATOM  14666  C   VAL C 549      -0.220  78.247  -0.404  1.00 43.38           C  
ATOM  14667  O   VAL C 549      -0.646  77.468  -1.249  1.00 44.34           O  
ATOM  14668  CB  VAL C 549       0.076  80.053  -2.174  1.00 57.41           C  
ATOM  14669  CG1 VAL C 549      -1.403  80.146  -2.637  1.00 58.65           C  
ATOM  14670  CG2 VAL C 549       0.745  81.362  -2.573  1.00 57.30           C  
ATOM  14671  N   SER C 550      -0.145  77.858   0.868  1.00 39.46           N  
ATOM  14672  CA  SER C 550      -0.483  76.507   1.313  1.00 38.62           C  
ATOM  14673  C   SER C 550      -1.922  76.511   1.838  1.00 37.25           C  
ATOM  14674  O   SER C 550      -2.505  77.592   1.992  1.00 37.03           O  
ATOM  14675  CB  SER C 550       0.540  76.137   2.369  1.00 40.79           C  
ATOM  14676  OG  SER C 550       0.250  74.880   2.932  1.00 51.43           O  
ATOM  14677  N   ASP C 551      -2.595  75.386   1.987  1.00 36.63           N  
ATOM  14678  CA  ASP C 551      -3.976  75.381   2.477  1.00 34.00           C  
ATOM  14679  C   ASP C 551      -4.040  75.833   3.937  1.00 34.14           C  
ATOM  14680  O   ASP C 551      -3.274  75.382   4.800  1.00 33.06           O  
ATOM  14681  CB  ASP C 551      -4.612  74.007   2.284  1.00 29.90           C  
ATOM  14682  CG  ASP C 551      -6.050  73.953   2.768  1.00 36.10           C  
ATOM  14683  OD1 ASP C 551      -6.307  73.761   3.963  1.00 33.65           O  
ATOM  14684  OD2 ASP C 551      -6.978  74.128   1.973  1.00 42.04           O  
ATOM  14685  N   ARG C 552      -5.021  76.676   4.275  1.00 33.02           N  
ATOM  14686  CA  ARG C 552      -5.073  77.193   5.657  1.00 34.43           C  
ATOM  14687  C   ARG C 552      -5.529  76.209   6.709  1.00 33.73           C  
ATOM  14688  O   ARG C 552      -5.479  76.502   7.904  1.00 33.85           O  
ATOM  14689  CB  ARG C 552      -5.782  78.537   5.698  1.00 34.46           C  
ATOM  14690  CG  ARG C 552      -4.940  79.676   5.104  1.00 36.80           C  
ATOM  14691  CD  ARG C 552      -5.809  80.899   4.859  1.00 33.81           C  
ATOM  14692  NE  ARG C 552      -6.158  81.595   6.078  1.00 36.55           N  
ATOM  14693  CZ  ARG C 552      -5.510  82.505   6.766  1.00 38.76           C  
ATOM  14694  NH1 ARG C 552      -4.318  82.965   6.423  1.00 34.17           N  
ATOM  14695  NH2 ARG C 552      -6.036  83.001   7.895  1.00 40.13           N  
ATOM  14696  N   ASN C 553      -5.785  74.951   6.398  1.00 33.02           N  
ATOM  14697  CA  ASN C 553      -6.052  73.887   7.355  1.00 31.00           C  
ATOM  14698  C   ASN C 553      -4.951  72.834   7.252  1.00 31.22           C  
ATOM  14699  O   ASN C 553      -4.989  71.776   7.905  1.00 33.28           O  
ATOM  14700  CB  ASN C 553      -7.454  73.310   7.148  1.00 29.44           C  
ATOM  14701  CG  ASN C 553      -8.519  74.239   7.722  1.00 33.23           C  
ATOM  14702  OD1 ASN C 553      -8.404  74.670   8.866  1.00 32.81           O  
ATOM  14703  ND2 ASN C 553      -9.545  74.594   6.953  1.00 28.56           N  
ATOM  14704  N   SER C 554      -3.840  73.146   6.585  1.00 29.39           N  
ATOM  14705  CA  SER C 554      -2.735  72.221   6.433  1.00 31.67           C  
ATOM  14706  C   SER C 554      -1.735  72.203   7.570  1.00 32.69           C  
ATOM  14707  O   SER C 554      -0.920  71.268   7.623  1.00 30.88           O  
ATOM  14708  CB  SER C 554      -2.011  72.318   5.094  1.00 32.04           C  
ATOM  14709  OG  SER C 554      -1.203  73.430   4.890  1.00 32.43           O  
ATOM  14710  N   ARG C 555      -1.788  73.082   8.550  1.00 33.39           N  
ATOM  14711  CA  ARG C 555      -0.852  73.023   9.680  1.00 32.52           C  
ATOM  14712  C   ARG C 555      -1.620  72.952  10.984  1.00 32.19           C  
ATOM  14713  O   ARG C 555      -1.312  72.251  11.945  1.00 29.71           O  
ATOM  14714  CB  ARG C 555       0.091  74.240   9.642  1.00 33.61           C  
ATOM  14715  CG  ARG C 555       0.991  74.236   8.389  1.00 32.87           C  
ATOM  14716  CD  ARG C 555       1.879  72.977   8.390  1.00 33.47           C  
ATOM  14717  NE  ARG C 555       2.639  72.843   7.152  1.00 38.04           N  
ATOM  14718  CZ  ARG C 555       3.835  73.424   6.948  1.00 38.57           C  
ATOM  14719  NH1 ARG C 555       4.401  74.167   7.893  1.00 32.44           N  
ATOM  14720  NH2 ARG C 555       4.440  73.226   5.781  1.00 34.31           N  
ATOM  14721  N   ILE C 556      -2.617  73.844  11.009  1.00 33.15           N  
ATOM  14722  CA  ILE C 556      -3.536  73.888  12.152  1.00 31.24           C  
ATOM  14723  C   ILE C 556      -4.915  73.734  11.495  1.00 31.41           C  
ATOM  14724  O   ILE C 556      -5.334  74.539  10.661  1.00 29.64           O  
ATOM  14725  CB  ILE C 556      -3.406  75.151  12.997  1.00 31.31           C  
ATOM  14726  CG1 ILE C 556      -2.056  75.203  13.721  1.00 29.45           C  
ATOM  14727  CG2 ILE C 556      -4.533  75.208  14.026  1.00 26.80           C  
ATOM  14728  CD1 ILE C 556      -1.719  76.591  14.233  1.00 30.84           C  
ATOM  14729  N   ASP C 557      -5.551  72.630  11.791  1.00 29.05           N  
ATOM  14730  CA  ASP C 557      -6.843  72.213  11.269  1.00 29.62           C  
ATOM  14731  C   ASP C 557      -8.004  72.726  12.110  1.00 30.16           C  
ATOM  14732  O   ASP C 557      -8.198  72.365  13.270  1.00 29.53           O  
ATOM  14733  CB  ASP C 557      -6.720  70.681  11.228  1.00 25.85           C  
ATOM  14734  CG  ASP C 557      -7.805  69.945  10.480  1.00 28.23           C  
ATOM  14735  OD1 ASP C 557      -8.567  70.514   9.692  1.00 31.12           O  
ATOM  14736  OD2 ASP C 557      -7.908  68.714  10.688  1.00 28.08           O  
ATOM  14737  N   VAL C 558      -8.761  73.682  11.582  1.00 28.59           N  
ATOM  14738  CA  VAL C 558      -9.789  74.360  12.355  1.00 30.34           C  
ATOM  14739  C   VAL C 558     -11.157  73.771  12.074  1.00 31.67           C  
ATOM  14740  O   VAL C 558     -11.690  74.025  10.997  1.00 31.07           O  
ATOM  14741  CB  VAL C 558      -9.798  75.876  12.062  1.00 35.98           C  
ATOM  14742  CG1 VAL C 558     -10.907  76.558  12.842  1.00 28.77           C  
ATOM  14743  CG2 VAL C 558      -8.426  76.470  12.370  1.00 29.18           C  
ATOM  14744  N   ILE C 559     -11.669  73.010  13.026  1.00 30.06           N  
ATOM  14745  CA  ILE C 559     -12.949  72.342  12.857  1.00 33.22           C  
ATOM  14746  C   ILE C 559     -14.029  72.898  13.792  1.00 33.87           C  
ATOM  14747  O   ILE C 559     -13.834  73.080  14.992  1.00 29.65           O  
ATOM  14748  CB  ILE C 559     -12.798  70.826  13.150  1.00 33.57           C  
ATOM  14749  CG1 ILE C 559     -11.709  70.186  12.280  1.00 32.34           C  
ATOM  14750  CG2 ILE C 559     -14.115  70.115  12.954  1.00 34.00           C  
ATOM  14751  CD1 ILE C 559     -11.044  68.979  12.891  1.00 26.79           C  
ATOM  14752  N   THR C 560     -15.223  73.050  13.225  1.00 34.60           N  
ATOM  14753  CA  THR C 560     -16.347  73.582  14.002  1.00 34.66           C  
ATOM  14754  C   THR C 560     -17.443  72.567  14.296  1.00 34.51           C  
ATOM  14755  O   THR C 560     -18.055  72.002  13.366  1.00 33.20           O  
ATOM  14756  CB  THR C 560     -16.969  74.758  13.205  1.00 37.14           C  
ATOM  14757  OG1 THR C 560     -15.921  75.727  12.990  1.00 35.29           O  
ATOM  14758  CG2 THR C 560     -18.182  75.304  13.936  1.00 34.61           C  
ATOM  14759  N   ILE C 561     -17.684  72.344  15.585  1.00 32.14           N  
ATOM  14760  CA  ILE C 561     -18.785  71.507  16.025  1.00 33.97           C  
ATOM  14761  C   ILE C 561     -19.828  72.440  16.675  1.00 35.80           C  
ATOM  14762  O   ILE C 561     -19.456  73.052  17.675  1.00 33.80           O  
ATOM  14763  CB  ILE C 561     -18.409  70.405  17.014  1.00 32.30           C  
ATOM  14764  CG1 ILE C 561     -17.202  69.601  16.450  1.00 29.44           C  
ATOM  14765  CG2 ILE C 561     -19.628  69.487  17.234  1.00 25.25           C  
ATOM  14766  CD1 ILE C 561     -16.749  68.468  17.332  1.00 30.02           C  
ATOM  14767  N   HIS C 562     -21.030  72.568  16.102  1.00 35.39           N  
ATOM  14768  CA  HIS C 562     -22.041  73.436  16.688  1.00 34.90           C  
ATOM  14769  C   HIS C 562     -23.176  72.630  17.301  1.00 38.33           C  
ATOM  14770  O   HIS C 562     -23.246  71.426  17.088  1.00 35.06           O  
ATOM  14771  CB  HIS C 562     -22.567  74.426  15.655  1.00 32.64           C  
ATOM  14772  CG  HIS C 562     -23.462  73.821  14.673  1.00 36.95           C  
ATOM  14773  ND1 HIS C 562     -23.273  73.483  13.422  1.00 37.63           N  
ATOM  14774  CD2 HIS C 562     -24.655  73.384  14.518  1.00 35.09           C  
ATOM  14775  CE1 HIS C 562     -24.175  72.911  12.678  1.00 38.26           C  
ATOM  14776  NE2 HIS C 562     -25.158  72.834  13.391  1.00 39.86           N  
ATOM  14777  N   SER C 563     -24.082  73.300  18.022  1.00 38.39           N  
ATOM  14778  CA  SER C 563     -25.161  72.697  18.751  1.00 37.87           C  
ATOM  14779  C   SER C 563     -26.530  72.650  18.069  1.00 35.90           C  
ATOM  14780  O   SER C 563     -27.458  72.212  18.756  1.00 36.65           O  
ATOM  14781  CB  SER C 563     -25.452  73.491  20.058  1.00 34.01           C  
ATOM  14782  OG  SER C 563     -24.447  73.222  21.008  1.00 41.20           O  
ATOM  14783  N   CYS C 564     -26.677  73.167  16.879  1.00 35.03           N  
ATOM  14784  CA  CYS C 564     -27.976  73.233  16.254  1.00 37.11           C  
ATOM  14785  C   CYS C 564     -28.279  72.028  15.385  1.00 40.12           C  
ATOM  14786  O   CYS C 564     -27.410  71.246  14.980  1.00 40.52           O  
ATOM  14787  CB  CYS C 564     -28.051  74.523  15.409  1.00 40.59           C  
ATOM  14788  SG  CYS C 564     -27.614  75.978  16.416  1.00 48.82           S  
ATOM  14789  N   HIS C 565     -29.569  71.888  15.076  1.00 40.22           N  
ATOM  14790  CA  HIS C 565     -30.024  70.836  14.187  1.00 37.29           C  
ATOM  14791  C   HIS C 565     -29.676  71.353  12.794  1.00 38.76           C  
ATOM  14792  O   HIS C 565     -29.875  72.559  12.603  1.00 38.84           O  
ATOM  14793  CB  HIS C 565     -31.510  70.554  14.340  1.00 36.23           C  
ATOM  14794  CG  HIS C 565     -31.898  69.367  13.484  1.00 38.57           C  
ATOM  14795  ND1 HIS C 565     -32.099  69.452  12.119  1.00 42.01           N  
ATOM  14796  CD2 HIS C 565     -32.056  68.071  13.828  1.00 36.11           C  
ATOM  14797  CE1 HIS C 565     -32.395  68.248  11.675  1.00 41.91           C  
ATOM  14798  NE2 HIS C 565     -32.383  67.396  12.685  1.00 39.62           N  
ATOM  14799  N   ARG C 566     -29.311  70.523  11.824  1.00 37.67           N  
ATOM  14800  CA  ARG C 566     -28.904  71.059  10.528  1.00 36.78           C  
ATOM  14801  C   ARG C 566     -30.076  71.602   9.741  1.00 36.98           C  
ATOM  14802  O   ARG C 566     -29.840  72.238   8.708  1.00 34.86           O  
ATOM  14803  CB  ARG C 566     -28.107  70.070   9.664  1.00 41.96           C  
ATOM  14804  CG  ARG C 566     -28.702  68.700   9.418  1.00 40.10           C  
ATOM  14805  CD  ARG C 566     -27.647  67.702   8.941  1.00 39.48           C  
ATOM  14806  NE  ARG C 566     -27.350  67.876   7.529  1.00 39.46           N  
ATOM  14807  CZ  ARG C 566     -27.938  67.434   6.433  1.00 37.59           C  
ATOM  14808  NH1 ARG C 566     -29.002  66.660   6.498  1.00 35.84           N  
ATOM  14809  NH2 ARG C 566     -27.473  67.734   5.215  1.00 36.80           N  
ATOM  14810  N   ASP C 567     -31.319  71.378  10.162  1.00 36.57           N  
ATOM  14811  CA  ASP C 567     -32.431  72.053   9.506  1.00 39.92           C  
ATOM  14812  C   ASP C 567     -32.492  73.534   9.870  1.00 40.18           C  
ATOM  14813  O   ASP C 567     -33.051  74.309   9.106  1.00 40.97           O  
ATOM  14814  CB  ASP C 567     -33.755  71.405   9.888  1.00 43.07           C  
ATOM  14815  CG  ASP C 567     -33.987  70.038   9.251  1.00 46.77           C  
ATOM  14816  OD1 ASP C 567     -33.196  69.586   8.399  1.00 44.32           O  
ATOM  14817  OD2 ASP C 567     -35.011  69.419   9.649  1.00 48.69           O  
ATOM  14818  N   ASP C 568     -31.933  73.946  11.006  1.00 39.21           N  
ATOM  14819  CA  ASP C 568     -31.987  75.302  11.483  1.00 41.68           C  
ATOM  14820  C   ASP C 568     -30.857  76.241  11.109  1.00 41.96           C  
ATOM  14821  O   ASP C 568     -30.976  77.452  11.382  1.00 44.05           O  
ATOM  14822  CB  ASP C 568     -32.039  75.247  13.024  1.00 42.87           C  
ATOM  14823  CG  ASP C 568     -33.264  74.422  13.412  1.00 44.14           C  
ATOM  14824  OD1 ASP C 568     -34.261  74.568  12.667  1.00 42.71           O  
ATOM  14825  OD2 ASP C 568     -33.171  73.702  14.425  1.00 43.77           O  
ATOM  14826  N   ILE C 569     -29.775  75.713  10.558  1.00 40.31           N  
ATOM  14827  CA  ILE C 569     -28.688  76.615  10.153  1.00 39.69           C  
ATOM  14828  C   ILE C 569     -27.931  75.930   9.022  1.00 40.86           C  
ATOM  14829  O   ILE C 569     -27.925  74.703   8.956  1.00 37.98           O  
ATOM  14830  CB  ILE C 569     -27.794  76.981  11.336  1.00 37.84           C  
ATOM  14831  CG1 ILE C 569     -26.954  78.214  11.017  1.00 34.60           C  
ATOM  14832  CG2 ILE C 569     -26.934  75.803  11.777  1.00 32.47           C  
ATOM  14833  CD1 ILE C 569     -26.118  78.632  12.219  1.00 39.30           C  
ATOM  14834  N   GLU C 570     -27.415  76.724   8.099  1.00 39.27           N  
ATOM  14835  CA  GLU C 570     -26.652  76.198   6.982  1.00 38.90           C  
ATOM  14836  C   GLU C 570     -25.157  76.283   7.251  1.00 39.32           C  
ATOM  14837  O   GLU C 570     -24.726  77.143   8.034  1.00 39.73           O  
ATOM  14838  CB  GLU C 570     -27.016  76.996   5.728  1.00 40.75           C  
ATOM  14839  CG  GLU C 570     -28.515  77.111   5.492  1.00 42.84           C  
ATOM  14840  CD  GLU C 570     -29.183  75.767   5.248  1.00 45.57           C  
ATOM  14841  OE1 GLU C 570     -28.618  74.964   4.489  1.00 42.42           O  
ATOM  14842  OE2 GLU C 570     -30.253  75.492   5.858  1.00 49.82           O  
ATOM  14843  N   MET C 571     -24.362  75.494   6.539  1.00 36.43           N  
ATOM  14844  CA  MET C 571     -22.915  75.602   6.621  1.00 36.91           C  
ATOM  14845  C   MET C 571     -22.466  77.005   6.202  1.00 35.49           C  
ATOM  14846  O   MET C 571     -21.560  77.558   6.787  1.00 32.27           O  
ATOM  14847  CB  MET C 571     -22.211  74.607   5.681  1.00 32.87           C  
ATOM  14848  CG  MET C 571     -22.472  73.165   6.048  1.00 32.77           C  
ATOM  14849  SD  MET C 571     -21.651  72.038   4.951  1.00 35.86           S  
ATOM  14850  CE  MET C 571     -22.707  72.132   3.480  1.00 24.08           C  
ATOM  14851  N   HIS C 572     -23.110  77.594   5.199  1.00 34.97           N  
ATOM  14852  CA  HIS C 572     -22.784  78.914   4.719  1.00 39.46           C  
ATOM  14853  C   HIS C 572     -23.257  80.057   5.624  1.00 40.29           C  
ATOM  14854  O   HIS C 572     -23.063  81.237   5.309  1.00 39.47           O  
ATOM  14855  CB  HIS C 572     -23.265  79.084   3.277  1.00 35.01           C  
ATOM  14856  CG  HIS C 572     -24.747  79.181   3.164  1.00 38.66           C  
ATOM  14857  ND1 HIS C 572     -25.509  78.265   2.492  1.00 43.74           N  
ATOM  14858  CD2 HIS C 572     -25.636  80.076   3.642  1.00 39.99           C  
ATOM  14859  CE1 HIS C 572     -26.787  78.557   2.556  1.00 41.38           C  
ATOM  14860  NE2 HIS C 572     -26.892  79.667   3.258  1.00 42.56           N  
ATOM  14861  N   ASP C 573     -23.807  79.772   6.798  1.00 40.05           N  
ATOM  14862  CA  ASP C 573     -24.116  80.752   7.806  1.00 39.07           C  
ATOM  14863  C   ASP C 573     -22.902  80.888   8.730  1.00 39.35           C  
ATOM  14864  O   ASP C 573     -22.989  81.597   9.740  1.00 39.11           O  
ATOM  14865  CB  ASP C 573     -25.336  80.369   8.657  1.00 36.99           C  
ATOM  14866  CG  ASP C 573     -26.641  80.402   7.904  1.00 35.20           C  
ATOM  14867  OD1 ASP C 573     -26.853  81.324   7.079  1.00 41.21           O  
ATOM  14868  OD2 ASP C 573     -27.456  79.472   8.134  1.00 37.22           O  
ATOM  14869  N   PHE C 574     -21.854  80.106   8.488  1.00 38.93           N  
ATOM  14870  CA  PHE C 574     -20.635  80.235   9.309  1.00 37.85           C  
ATOM  14871  C   PHE C 574     -19.659  81.015   8.454  1.00 36.34           C  
ATOM  14872  O   PHE C 574     -19.825  80.983   7.231  1.00 37.34           O  
ATOM  14873  CB  PHE C 574     -20.106  78.883   9.753  1.00 36.14           C  
ATOM  14874  CG  PHE C 574     -20.982  78.181  10.760  1.00 36.73           C  
ATOM  14875  CD1 PHE C 574     -22.057  77.411  10.360  1.00 36.22           C  
ATOM  14876  CD2 PHE C 574     -20.730  78.283  12.108  1.00 34.52           C  
ATOM  14877  CE1 PHE C 574     -22.849  76.767  11.285  1.00 33.47           C  
ATOM  14878  CE2 PHE C 574     -21.527  77.658  13.038  1.00 31.28           C  
ATOM  14879  CZ  PHE C 574     -22.586  76.898  12.633  1.00 30.73           C  
ATOM  14880  N   PRO C 575     -18.743  81.766   9.025  1.00 37.63           N  
ATOM  14881  CA  PRO C 575     -17.746  82.498   8.278  1.00 36.00           C  
ATOM  14882  C   PRO C 575     -17.002  81.601   7.287  1.00 38.38           C  
ATOM  14883  O   PRO C 575     -16.463  80.561   7.643  1.00 36.23           O  
ATOM  14884  CB  PRO C 575     -16.778  82.934   9.363  1.00 37.03           C  
ATOM  14885  CG  PRO C 575     -17.574  83.026  10.614  1.00 39.84           C  
ATOM  14886  CD  PRO C 575     -18.560  81.878  10.494  1.00 38.83           C  
ATOM  14887  N   ALA C 576     -16.916  82.024   6.037  1.00 37.98           N  
ATOM  14888  CA  ALA C 576     -16.223  81.369   4.947  1.00 40.27           C  
ATOM  14889  C   ALA C 576     -15.187  82.305   4.363  1.00 40.11           C  
ATOM  14890  O   ALA C 576     -15.528  83.454   4.126  1.00 42.14           O  
ATOM  14891  CB  ALA C 576     -17.206  81.070   3.808  1.00 38.05           C  
ATOM  14892  N   PRO C 577     -13.944  81.876   4.215  1.00 39.12           N  
ATOM  14893  CA  PRO C 577     -13.515  80.524   4.460  1.00 37.01           C  
ATOM  14894  C   PRO C 577     -12.871  80.144   5.772  1.00 37.46           C  
ATOM  14895  O   PRO C 577     -12.260  79.077   5.818  1.00 38.81           O  
ATOM  14896  CB  PRO C 577     -12.403  80.393   3.400  1.00 34.51           C  
ATOM  14897  CG  PRO C 577     -11.751  81.727   3.383  1.00 33.79           C  
ATOM  14898  CD  PRO C 577     -12.848  82.709   3.612  1.00 36.71           C  
ATOM  14899  N   ALA C 578     -12.877  80.970   6.805  1.00 36.76           N  
ATOM  14900  CA  ALA C 578     -12.245  80.648   8.070  1.00 34.72           C  
ATOM  14901  C   ALA C 578     -12.771  79.350   8.656  1.00 35.39           C  
ATOM  14902  O   ALA C 578     -11.993  78.536   9.146  1.00 34.98           O  
ATOM  14903  CB  ALA C 578     -12.488  81.779   9.073  1.00 34.90           C  
ATOM  14904  N   LEU C 579     -14.087  79.172   8.686  1.00 33.59           N  
ATOM  14905  CA  LEU C 579     -14.692  78.008   9.316  1.00 33.61           C  
ATOM  14906  C   LEU C 579     -15.398  77.148   8.277  1.00 33.24           C  
ATOM  14907  O   LEU C 579     -15.697  75.993   8.577  1.00 32.04           O  
ATOM  14908  CB  LEU C 579     -15.721  78.405  10.389  1.00 33.27           C  
ATOM  14909  CG  LEU C 579     -15.253  79.231  11.583  1.00 30.28           C  
ATOM  14910  CD1 LEU C 579     -16.370  79.397  12.619  1.00 34.21           C  
ATOM  14911  CD2 LEU C 579     -14.025  78.616  12.221  1.00 27.10           C  
ATOM  14912  N   HIS C 580     -15.665  77.693   7.108  1.00 32.09           N  
ATOM  14913  CA  HIS C 580     -16.381  76.952   6.056  1.00 34.83           C  
ATOM  14914  C   HIS C 580     -15.561  77.039   4.762  1.00 33.69           C  
ATOM  14915  O   HIS C 580     -15.697  77.988   3.989  1.00 36.54           O  
ATOM  14916  CB  HIS C 580     -17.799  77.505   5.882  1.00 29.60           C  
ATOM  14917  CG  HIS C 580     -18.644  76.879   4.831  1.00 33.83           C  
ATOM  14918  ND1 HIS C 580     -18.704  75.510   4.635  1.00 33.65           N  
ATOM  14919  CD2 HIS C 580     -19.489  77.406   3.913  1.00 34.69           C  
ATOM  14920  CE1 HIS C 580     -19.524  75.240   3.648  1.00 33.31           C  
ATOM  14921  NE2 HIS C 580     -20.020  76.377   3.185  1.00 33.21           N  
ATOM  14922  N   PRO C 581     -14.553  76.191   4.646  1.00 32.72           N  
ATOM  14923  CA  PRO C 581     -13.511  76.355   3.645  1.00 32.68           C  
ATOM  14924  C   PRO C 581     -14.079  76.145   2.249  1.00 35.16           C  
ATOM  14925  O   PRO C 581     -15.089  75.446   2.067  1.00 33.59           O  
ATOM  14926  CB  PRO C 581     -12.428  75.357   4.026  1.00 32.00           C  
ATOM  14927  CG  PRO C 581     -12.681  75.007   5.438  1.00 31.04           C  
ATOM  14928  CD  PRO C 581     -14.182  75.127   5.617  1.00 31.68           C  
ATOM  14929  N   LYS C 582     -13.468  76.801   1.263  1.00 35.63           N  
ATOM  14930  CA  LYS C 582     -13.996  76.749  -0.091  1.00 37.77           C  
ATOM  14931  C   LYS C 582     -14.101  75.348  -0.674  1.00 39.98           C  
ATOM  14932  O   LYS C 582     -13.142  74.575  -0.788  1.00 37.24           O  
ATOM  14933  CB  LYS C 582     -13.157  77.618  -1.034  1.00 38.06           C  
ATOM  14934  CG  LYS C 582     -13.819  77.709  -2.408  1.00 45.56           C  
ATOM  14935  CD  LYS C 582     -13.142  78.784  -3.257  1.00 45.67           C  
ATOM  14936  CE  LYS C 582     -11.691  78.425  -3.511  1.00 45.59           C  
ATOM  14937  NZ  LYS C 582     -11.108  79.290  -4.576  1.00 55.25           N  
ATOM  14938  N   TRP C 583     -15.335  75.007  -1.054  1.00 37.30           N  
ATOM  14939  CA  TRP C 583     -15.654  73.710  -1.634  1.00 37.27           C  
ATOM  14940  C   TRP C 583     -15.142  72.532  -0.827  1.00 38.10           C  
ATOM  14941  O   TRP C 583     -14.776  71.512  -1.435  1.00 37.78           O  
ATOM  14942  CB  TRP C 583     -15.134  73.603  -3.072  1.00 34.22           C  
ATOM  14943  CG  TRP C 583     -15.479  74.764  -3.954  1.00 37.80           C  
ATOM  14944  CD1 TRP C 583     -16.641  75.501  -3.917  1.00 37.42           C  
ATOM  14945  CD2 TRP C 583     -14.643  75.380  -4.942  1.00 38.35           C  
ATOM  14946  NE1 TRP C 583     -16.576  76.509  -4.851  1.00 38.65           N  
ATOM  14947  CE2 TRP C 583     -15.354  76.480  -5.468  1.00 39.11           C  
ATOM  14948  CE3 TRP C 583     -13.349  75.134  -5.407  1.00 36.93           C  
ATOM  14949  CZ2 TRP C 583     -14.838  77.310  -6.458  1.00 38.38           C  
ATOM  14950  CZ3 TRP C 583     -12.854  75.920  -6.434  1.00 38.20           C  
ATOM  14951  CH2 TRP C 583     -13.589  77.011  -6.942  1.00 38.03           C  
ATOM  14952  N   GLN C 584     -15.148  72.591   0.500  1.00 36.56           N  
ATOM  14953  CA  GLN C 584     -14.670  71.535   1.368  1.00 35.46           C  
ATOM  14954  C   GLN C 584     -15.681  71.319   2.486  1.00 37.26           C  
ATOM  14955  O   GLN C 584     -16.385  72.276   2.835  1.00 37.94           O  
ATOM  14956  CB  GLN C 584     -13.313  71.814   1.995  1.00 34.96           C  
ATOM  14957  CG  GLN C 584     -12.200  71.959   0.973  1.00 34.60           C  
ATOM  14958  CD  GLN C 584     -10.954  72.557   1.586  1.00 38.21           C  
ATOM  14959  OE1 GLN C 584     -10.445  71.991   2.530  1.00 42.13           O  
ATOM  14960  NE2 GLN C 584     -10.503  73.679   1.041  1.00 43.50           N  
ATOM  14961  N   TYR C 585     -15.986  70.024   2.712  1.00 35.30           N  
ATOM  14962  CA  TYR C 585     -17.128  69.667   3.546  1.00 30.92           C  
ATOM  14963  C   TYR C 585     -16.813  68.807   4.738  1.00 31.57           C  
ATOM  14964  O   TYR C 585     -17.669  68.076   5.286  1.00 30.43           O  
ATOM  14965  CB  TYR C 585     -18.185  69.033   2.608  1.00 34.55           C  
ATOM  14966  CG  TYR C 585     -18.615  70.007   1.515  1.00 36.22           C  
ATOM  14967  CD1 TYR C 585     -19.550  71.011   1.736  1.00 36.45           C  
ATOM  14968  CD2 TYR C 585     -17.931  69.994   0.302  1.00 34.27           C  
ATOM  14969  CE1 TYR C 585     -19.845  71.938   0.739  1.00 36.57           C  
ATOM  14970  CE2 TYR C 585     -18.210  70.910  -0.690  1.00 33.84           C  
ATOM  14971  CZ  TYR C 585     -19.151  71.905  -0.453  1.00 36.92           C  
ATOM  14972  OH  TYR C 585     -19.404  72.802  -1.458  1.00 37.94           O  
ATOM  14973  N   ASP C 586     -15.571  68.895   5.228  1.00 30.73           N  
ATOM  14974  CA  ASP C 586     -15.164  68.159   6.418  1.00 32.90           C  
ATOM  14975  C   ASP C 586     -14.777  69.104   7.556  1.00 33.96           C  
ATOM  14976  O   ASP C 586     -13.725  68.933   8.185  1.00 31.41           O  
ATOM  14977  CB  ASP C 586     -13.976  67.225   6.116  1.00 32.73           C  
ATOM  14978  CG  ASP C 586     -14.376  66.230   5.050  1.00 38.44           C  
ATOM  14979  OD1 ASP C 586     -15.231  65.356   5.334  1.00 38.28           O  
ATOM  14980  OD2 ASP C 586     -13.868  66.355   3.911  1.00 40.59           O  
ATOM  14981  N   PHE C 587     -15.546  70.201   7.691  1.00 33.89           N  
ATOM  14982  CA  PHE C 587     -15.228  71.208   8.708  1.00 35.62           C  
ATOM  14983  C   PHE C 587     -16.347  71.543   9.677  1.00 32.62           C  
ATOM  14984  O   PHE C 587     -16.083  71.907  10.828  1.00 34.04           O  
ATOM  14985  CB  PHE C 587     -14.700  72.482   8.007  1.00 31.98           C  
ATOM  14986  CG  PHE C 587     -13.380  72.188   7.361  1.00 32.79           C  
ATOM  14987  CD1 PHE C 587     -12.223  72.189   8.122  1.00 32.74           C  
ATOM  14988  CD2 PHE C 587     -13.315  71.796   6.040  1.00 33.39           C  
ATOM  14989  CE1 PHE C 587     -11.017  71.876   7.545  1.00 33.67           C  
ATOM  14990  CE2 PHE C 587     -12.110  71.447   5.448  1.00 29.07           C  
ATOM  14991  CZ  PHE C 587     -10.966  71.495   6.201  1.00 30.13           C  
ATOM  14992  N   ILE C 588     -17.601  71.444   9.279  1.00 35.18           N  
ATOM  14993  CA  ILE C 588     -18.760  71.781  10.104  1.00 35.25           C  
ATOM  14994  C   ILE C 588     -19.569  70.550  10.468  1.00 35.31           C  
ATOM  14995  O   ILE C 588     -20.033  69.774   9.627  1.00 34.95           O  
ATOM  14996  CB  ILE C 588     -19.628  72.834   9.395  1.00 38.80           C  
ATOM  14997  CG1 ILE C 588     -18.817  74.144   9.307  1.00 31.83           C  
ATOM  14998  CG2 ILE C 588     -20.948  73.064  10.146  1.00 29.77           C  
ATOM  14999  CD1 ILE C 588     -19.320  75.065   8.238  1.00 38.49           C  
ATOM  15000  N   TYR C 589     -19.654  70.281  11.765  1.00 33.66           N  
ATOM  15001  CA  TYR C 589     -20.342  69.159  12.366  1.00 33.07           C  
ATOM  15002  C   TYR C 589     -21.390  69.672  13.346  1.00 34.64           C  
ATOM  15003  O   TYR C 589     -21.352  70.831  13.804  1.00 32.69           O  
ATOM  15004  CB  TYR C 589     -19.372  68.195  13.096  1.00 32.04           C  
ATOM  15005  CG  TYR C 589     -18.303  67.691  12.127  1.00 33.01           C  
ATOM  15006  CD1 TYR C 589     -17.190  68.460  11.825  1.00 31.59           C  
ATOM  15007  CD2 TYR C 589     -18.441  66.484  11.485  1.00 32.08           C  
ATOM  15008  CE1 TYR C 589     -16.252  68.054  10.910  1.00 33.67           C  
ATOM  15009  CE2 TYR C 589     -17.514  66.026  10.564  1.00 31.41           C  
ATOM  15010  CZ  TYR C 589     -16.418  66.824  10.284  1.00 33.78           C  
ATOM  15011  OH  TYR C 589     -15.470  66.421   9.387  1.00 33.20           O  
ATOM  15012  N   ALA C 590     -22.317  68.789  13.728  1.00 34.43           N  
ATOM  15013  CA  ALA C 590     -23.407  69.238  14.591  1.00 34.55           C  
ATOM  15014  C   ALA C 590     -23.698  68.255  15.698  1.00 35.30           C  
ATOM  15015  O   ALA C 590     -23.616  67.058  15.446  1.00 38.35           O  
ATOM  15016  CB  ALA C 590     -24.649  69.483  13.744  1.00 28.77           C  
ATOM  15017  N   ASP C 591     -23.985  68.743  16.893  1.00 31.74           N  
ATOM  15018  CA  ASP C 591     -24.430  67.903  17.986  1.00 35.54           C  
ATOM  15019  C   ASP C 591     -25.971  67.930  17.901  1.00 38.28           C  
ATOM  15020  O   ASP C 591     -26.562  68.771  18.562  1.00 33.46           O  
ATOM  15021  CB  ASP C 591     -24.011  68.466  19.320  1.00 35.27           C  
ATOM  15022  CG  ASP C 591     -24.207  67.610  20.533  1.00 36.15           C  
ATOM  15023  OD1 ASP C 591     -24.367  66.376  20.428  1.00 37.55           O  
ATOM  15024  OD2 ASP C 591     -24.132  68.164  21.650  1.00 37.69           O  
ATOM  15025  N   CYS C 592     -26.548  67.085  17.045  1.00 37.42           N  
ATOM  15026  CA  CYS C 592     -27.980  67.045  16.863  1.00 36.08           C  
ATOM  15027  C   CYS C 592     -28.465  65.625  16.578  1.00 39.25           C  
ATOM  15028  O   CYS C 592     -27.745  64.638  16.417  1.00 43.28           O  
ATOM  15029  CB  CYS C 592     -28.416  67.959  15.729  1.00 36.74           C  
ATOM  15030  SG  CYS C 592     -27.856  67.515  14.067  1.00 40.66           S  
ATOM  15031  N   ASP C 593     -29.763  65.509  16.490  1.00 35.97           N  
ATOM  15032  CA  ASP C 593     -30.553  64.337  16.198  1.00 37.99           C  
ATOM  15033  C   ASP C 593     -30.417  64.021  14.717  1.00 37.20           C  
ATOM  15034  O   ASP C 593     -30.159  64.902  13.886  1.00 34.82           O  
ATOM  15035  CB  ASP C 593     -31.983  64.689  16.655  1.00 38.74           C  
ATOM  15036  CG  ASP C 593     -33.030  63.861  15.964  1.00 49.45           C  
ATOM  15037  OD1 ASP C 593     -33.455  64.292  14.867  1.00 56.81           O  
ATOM  15038  OD2 ASP C 593     -33.397  62.796  16.491  1.00 48.78           O  
ATOM  15039  N   SER C 594     -30.492  62.738  14.343  1.00 35.79           N  
ATOM  15040  CA  SER C 594     -30.283  62.388  12.926  1.00 35.51           C  
ATOM  15041  C   SER C 594     -31.234  61.270  12.569  1.00 35.16           C  
ATOM  15042  O   SER C 594     -31.878  60.731  13.458  1.00 35.32           O  
ATOM  15043  CB  SER C 594     -28.833  62.072  12.644  1.00 30.26           C  
ATOM  15044  OG  SER C 594     -28.243  61.137  13.540  1.00 29.73           O  
ATOM  15045  N   TRP C 595     -31.342  60.919  11.304  1.00 36.97           N  
ATOM  15046  CA  TRP C 595     -32.250  59.859  10.898  1.00 36.03           C  
ATOM  15047  C   TRP C 595     -32.131  58.573  11.699  1.00 34.63           C  
ATOM  15048  O   TRP C 595     -33.194  57.984  11.945  1.00 38.95           O  
ATOM  15049  CB  TRP C 595     -32.017  59.528   9.417  1.00 35.85           C  
ATOM  15050  CG  TRP C 595     -31.956  60.727   8.544  1.00 36.35           C  
ATOM  15051  CD1 TRP C 595     -30.902  61.161   7.793  1.00 37.04           C  
ATOM  15052  CD2 TRP C 595     -33.027  61.645   8.289  1.00 37.84           C  
ATOM  15053  NE1 TRP C 595     -31.247  62.292   7.095  1.00 37.19           N  
ATOM  15054  CE2 TRP C 595     -32.542  62.620   7.394  1.00 34.27           C  
ATOM  15055  CE3 TRP C 595     -34.347  61.738   8.744  1.00 35.91           C  
ATOM  15056  CZ2 TRP C 595     -33.319  63.692   6.973  1.00 34.84           C  
ATOM  15057  CZ3 TRP C 595     -35.129  62.772   8.304  1.00 34.07           C  
ATOM  15058  CH2 TRP C 595     -34.622  63.736   7.433  1.00 35.65           C  
ATOM  15059  N   HIS C 596     -30.970  58.010  11.983  1.00 33.38           N  
ATOM  15060  CA  HIS C 596     -30.887  56.685  12.578  1.00 32.65           C  
ATOM  15061  C   HIS C 596     -30.469  56.673  14.022  1.00 32.76           C  
ATOM  15062  O   HIS C 596     -30.353  55.607  14.664  1.00 34.09           O  
ATOM  15063  CB  HIS C 596     -29.889  55.815  11.768  1.00 31.62           C  
ATOM  15064  CG  HIS C 596     -30.280  55.865  10.315  1.00 35.11           C  
ATOM  15065  ND1 HIS C 596     -29.718  56.738   9.403  1.00 37.53           N  
ATOM  15066  CD2 HIS C 596     -31.203  55.147   9.632  1.00 33.40           C  
ATOM  15067  CE1 HIS C 596     -30.273  56.566   8.221  1.00 34.66           C  
ATOM  15068  NE2 HIS C 596     -31.169  55.611   8.342  1.00 39.87           N  
ATOM  15069  N   HIS C 597     -30.161  57.841  14.589  1.00 30.11           N  
ATOM  15070  CA  HIS C 597     -29.668  57.837  15.973  1.00 33.02           C  
ATOM  15071  C   HIS C 597     -30.296  59.051  16.640  1.00 33.88           C  
ATOM  15072  O   HIS C 597     -30.642  60.000  15.960  1.00 35.23           O  
ATOM  15073  CB  HIS C 597     -28.137  57.965  16.069  1.00 31.74           C  
ATOM  15074  CG  HIS C 597     -27.335  56.810  15.540  1.00 35.52           C  
ATOM  15075  ND1 HIS C 597     -27.016  55.723  16.342  1.00 36.29           N  
ATOM  15076  CD2 HIS C 597     -26.873  56.509  14.314  1.00 30.53           C  
ATOM  15077  CE1 HIS C 597     -26.298  54.845  15.693  1.00 29.99           C  
ATOM  15078  NE2 HIS C 597     -26.213  55.306  14.451  1.00 30.95           N  
ATOM  15079  N   PRO C 598     -30.461  58.967  17.942  1.00 35.06           N  
ATOM  15080  CA  PRO C 598     -30.998  60.076  18.697  1.00 37.12           C  
ATOM  15081  C   PRO C 598     -29.901  61.130  18.862  1.00 38.45           C  
ATOM  15082  O   PRO C 598     -28.758  60.886  18.463  1.00 37.58           O  
ATOM  15083  CB  PRO C 598     -31.363  59.415  20.027  1.00 34.38           C  
ATOM  15084  CG  PRO C 598     -30.321  58.365  20.192  1.00 37.27           C  
ATOM  15085  CD  PRO C 598     -30.027  57.844  18.813  1.00 33.51           C  
ATOM  15086  N   HIS C 599     -30.262  62.277  19.408  1.00 38.46           N  
ATOM  15087  CA  HIS C 599     -29.317  63.342  19.721  1.00 38.07           C  
ATOM  15088  C   HIS C 599     -28.260  62.738  20.623  1.00 36.42           C  
ATOM  15089  O   HIS C 599     -28.593  62.152  21.650  1.00 39.69           O  
ATOM  15090  CB  HIS C 599     -30.065  64.480  20.429  1.00 35.19           C  
ATOM  15091  CG  HIS C 599     -29.253  65.719  20.685  1.00 36.02           C  
ATOM  15092  ND1 HIS C 599     -28.029  65.693  21.350  1.00 37.62           N  
ATOM  15093  CD2 HIS C 599     -29.473  67.007  20.358  1.00 31.74           C  
ATOM  15094  CE1 HIS C 599     -27.557  66.907  21.429  1.00 32.36           C  
ATOM  15095  NE2 HIS C 599     -28.405  67.718  20.828  1.00 35.06           N  
ATOM  15096  N   PRO C 600     -26.987  62.780  20.229  1.00 36.03           N  
ATOM  15097  CA  PRO C 600     -25.928  62.090  20.959  1.00 33.79           C  
ATOM  15098  C   PRO C 600     -25.557  62.775  22.253  1.00 35.57           C  
ATOM  15099  O   PRO C 600     -24.834  62.209  23.075  1.00 33.34           O  
ATOM  15100  CB  PRO C 600     -24.806  62.033  19.936  1.00 33.89           C  
ATOM  15101  CG  PRO C 600     -25.051  63.089  18.945  1.00 34.27           C  
ATOM  15102  CD  PRO C 600     -26.518  63.374  18.963  1.00 34.18           C  
ATOM  15103  N   LYS C 601     -26.024  64.017  22.484  1.00 35.92           N  
ATOM  15104  CA  LYS C 601     -25.628  64.749  23.691  1.00 37.04           C  
ATOM  15105  C   LYS C 601     -24.105  64.753  23.828  1.00 36.56           C  
ATOM  15106  O   LYS C 601     -23.504  64.407  24.856  1.00 35.66           O  
ATOM  15107  CB  LYS C 601     -26.359  64.177  24.909  1.00 39.08           C  
ATOM  15108  CG  LYS C 601     -27.876  64.300  24.740  1.00 41.05           C  
ATOM  15109  CD  LYS C 601     -28.501  65.379  25.596  1.00 46.96           C  
ATOM  15110  CE  LYS C 601     -28.579  66.710  24.884  1.00 52.92           C  
ATOM  15111  NZ  LYS C 601     -28.709  67.881  25.801  1.00 52.45           N  
ATOM  15112  N   SER C 602     -23.465  65.245  22.750  1.00 35.66           N  
ATOM  15113  CA  SER C 602     -21.986  65.176  22.718  1.00 36.29           C  
ATOM  15114  C   SER C 602     -21.394  66.382  23.413  1.00 36.29           C  
ATOM  15115  O   SER C 602     -20.456  66.202  24.207  1.00 36.93           O  
ATOM  15116  CB  SER C 602     -21.501  64.955  21.299  1.00 32.82           C  
ATOM  15117  OG  SER C 602     -21.820  63.607  20.899  1.00 34.00           O  
ATOM  15118  N   TYR C 603     -21.991  67.575  23.279  1.00 33.00           N  
ATOM  15119  CA  TYR C 603     -21.483  68.724  24.030  1.00 33.52           C  
ATOM  15120  C   TYR C 603     -21.399  68.395  25.525  1.00 33.10           C  
ATOM  15121  O   TYR C 603     -20.417  68.644  26.246  1.00 32.81           O  
ATOM  15122  CB  TYR C 603     -22.366  69.939  23.854  1.00 32.38           C  
ATOM  15123  CG  TYR C 603     -21.939  70.896  22.764  1.00 33.99           C  
ATOM  15124  CD1 TYR C 603     -21.774  70.519  21.431  1.00 33.52           C  
ATOM  15125  CD2 TYR C 603     -21.724  72.222  23.105  1.00 35.32           C  
ATOM  15126  CE1 TYR C 603     -21.357  71.432  20.474  1.00 33.14           C  
ATOM  15127  CE2 TYR C 603     -21.326  73.147  22.159  1.00 35.02           C  
ATOM  15128  CZ  TYR C 603     -21.135  72.743  20.848  1.00 35.42           C  
ATOM  15129  OH  TYR C 603     -20.759  73.700  19.958  1.00 34.06           O  
ATOM  15130  N   GLN C 604     -22.497  67.794  25.984  1.00 30.13           N  
ATOM  15131  CA  GLN C 604     -22.589  67.366  27.371  1.00 33.12           C  
ATOM  15132  C   GLN C 604     -21.550  66.316  27.707  1.00 31.56           C  
ATOM  15133  O   GLN C 604     -20.941  66.403  28.771  1.00 32.35           O  
ATOM  15134  CB  GLN C 604     -24.029  66.876  27.621  1.00 29.95           C  
ATOM  15135  CG  GLN C 604     -24.255  66.476  29.064  1.00 33.19           C  
ATOM  15136  CD  GLN C 604     -25.649  65.869  29.232  1.00 39.38           C  
ATOM  15137  OE1 GLN C 604     -26.668  66.498  29.515  1.00 34.56           O  
ATOM  15138  NE2 GLN C 604     -25.582  64.563  29.035  1.00 31.70           N  
ATOM  15139  N   ALA C 605     -21.304  65.349  26.815  1.00 32.23           N  
ATOM  15140  CA  ALA C 605     -20.309  64.291  27.077  1.00 30.92           C  
ATOM  15141  C   ALA C 605     -18.910  64.885  27.128  1.00 29.32           C  
ATOM  15142  O   ALA C 605     -18.002  64.460  27.846  1.00 28.35           O  
ATOM  15143  CB  ALA C 605     -20.460  63.165  26.045  1.00 25.61           C  
ATOM  15144  N   TRP C 606     -18.706  65.949  26.385  1.00 27.41           N  
ATOM  15145  CA  TRP C 606     -17.456  66.710  26.328  1.00 31.68           C  
ATOM  15146  C   TRP C 606     -17.362  67.745  27.446  1.00 35.74           C  
ATOM  15147  O   TRP C 606     -16.294  68.361  27.606  1.00 32.40           O  
ATOM  15148  CB  TRP C 606     -17.361  67.383  24.961  1.00 30.67           C  
ATOM  15149  CG  TRP C 606     -16.740  66.529  23.883  1.00 33.54           C  
ATOM  15150  CD1 TRP C 606     -15.668  65.711  24.028  1.00 29.14           C  
ATOM  15151  CD2 TRP C 606     -17.125  66.448  22.499  1.00 29.98           C  
ATOM  15152  NE1 TRP C 606     -15.335  65.151  22.826  1.00 32.20           N  
ATOM  15153  CE2 TRP C 606     -16.199  65.610  21.858  1.00 31.15           C  
ATOM  15154  CE3 TRP C 606     -18.123  67.030  21.731  1.00 30.58           C  
ATOM  15155  CZ2 TRP C 606     -16.275  65.274  20.502  1.00 28.66           C  
ATOM  15156  CZ3 TRP C 606     -18.224  66.723  20.390  1.00 29.84           C  
ATOM  15157  CH2 TRP C 606     -17.308  65.844  19.778  1.00 31.13           C  
ATOM  15158  N   GLY C 607     -18.474  67.954  28.195  1.00 34.85           N  
ATOM  15159  CA  GLY C 607     -18.492  68.892  29.293  1.00 30.80           C  
ATOM  15160  C   GLY C 607     -18.545  70.339  28.840  1.00 33.30           C  
ATOM  15161  O   GLY C 607     -18.093  71.232  29.550  1.00 32.88           O  
ATOM  15162  N   VAL C 608     -19.080  70.612  27.667  1.00 32.21           N  
ATOM  15163  CA  VAL C 608     -19.139  71.934  27.088  1.00 33.75           C  
ATOM  15164  C   VAL C 608     -20.531  72.540  27.096  1.00 36.62           C  
ATOM  15165  O   VAL C 608     -21.486  71.862  26.727  1.00 36.15           O  
ATOM  15166  CB  VAL C 608     -18.690  71.872  25.602  1.00 33.02           C  
ATOM  15167  CG1 VAL C 608     -18.770  73.236  24.919  1.00 29.72           C  
ATOM  15168  CG2 VAL C 608     -17.295  71.291  25.519  1.00 32.45           C  
ATOM  15169  N   ASP C 609     -20.609  73.832  27.408  1.00 37.04           N  
ATOM  15170  CA  ASP C 609     -21.911  74.488  27.416  1.00 36.39           C  
ATOM  15171  C   ASP C 609     -22.525  74.527  26.030  1.00 35.33           C  
ATOM  15172  O   ASP C 609     -21.961  75.105  25.102  1.00 33.48           O  
ATOM  15173  CB  ASP C 609     -21.806  75.905  27.987  1.00 36.17           C  
ATOM  15174  CG  ASP C 609     -23.196  76.518  28.033  1.00 34.05           C  
ATOM  15175  OD1 ASP C 609     -23.927  76.029  28.892  1.00 39.35           O  
ATOM  15176  OD2 ASP C 609     -23.538  77.341  27.162  1.00 35.35           O  
ATOM  15177  N   GLU C 610     -23.786  74.087  25.915  1.00 35.28           N  
ATOM  15178  CA  GLU C 610     -24.430  74.034  24.615  1.00 36.43           C  
ATOM  15179  C   GLU C 610     -24.681  75.368  23.957  1.00 37.85           C  
ATOM  15180  O   GLU C 610     -24.873  75.391  22.732  1.00 41.03           O  
ATOM  15181  CB  GLU C 610     -25.744  73.231  24.640  1.00 36.08           C  
ATOM  15182  CG  GLU C 610     -25.526  71.782  25.036  1.00 42.32           C  
ATOM  15183  CD  GLU C 610     -26.790  70.985  25.251  1.00 43.76           C  
ATOM  15184  OE1 GLU C 610     -27.862  71.633  25.223  1.00 51.84           O  
ATOM  15185  OE2 GLU C 610     -26.762  69.753  25.452  1.00 43.99           O  
ATOM  15186  N   THR C 611     -24.809  76.448  24.706  1.00 37.34           N  
ATOM  15187  CA  THR C 611     -25.114  77.735  24.128  1.00 35.87           C  
ATOM  15188  C   THR C 611     -23.837  78.484  23.793  1.00 36.73           C  
ATOM  15189  O   THR C 611     -23.758  79.028  22.696  1.00 35.38           O  
ATOM  15190  CB  THR C 611     -25.917  78.636  25.105  1.00 35.92           C  
ATOM  15191  OG1 THR C 611     -27.241  78.100  25.231  1.00 38.01           O  
ATOM  15192  CG2 THR C 611     -26.085  80.062  24.630  1.00 29.38           C  
ATOM  15193  N   LYS C 612     -22.945  78.541  24.784  1.00 36.58           N  
ATOM  15194  CA  LYS C 612     -21.763  79.379  24.599  1.00 38.41           C  
ATOM  15195  C   LYS C 612     -20.571  78.698  23.938  1.00 39.30           C  
ATOM  15196  O   LYS C 612     -19.725  79.395  23.382  1.00 39.67           O  
ATOM  15197  CB  LYS C 612     -21.337  79.925  25.968  1.00 42.59           C  
ATOM  15198  CG  LYS C 612     -22.321  80.892  26.604  1.00 43.82           C  
ATOM  15199  CD  LYS C 612     -22.384  80.597  28.094  1.00 47.59           C  
ATOM  15200  CE  LYS C 612     -21.809  81.767  28.885  1.00 50.53           C  
ATOM  15201  NZ  LYS C 612     -22.480  81.884  30.217  1.00 52.80           N  
ATOM  15202  N   GLY C 613     -20.451  77.400  24.100  1.00 38.71           N  
ATOM  15203  CA  GLY C 613     -19.387  76.632  23.521  1.00 37.34           C  
ATOM  15204  C   GLY C 613     -18.062  76.788  24.244  1.00 39.05           C  
ATOM  15205  O   GLY C 613     -17.987  76.951  25.452  1.00 36.08           O  
ATOM  15206  N   ALA C 614     -17.008  76.708  23.424  1.00 37.14           N  
ATOM  15207  CA  ALA C 614     -15.644  76.682  23.869  1.00 35.50           C  
ATOM  15208  C   ALA C 614     -14.717  76.505  22.669  1.00 37.04           C  
ATOM  15209  O   ALA C 614     -15.104  76.291  21.528  1.00 34.44           O  
ATOM  15210  CB  ALA C 614     -15.471  75.499  24.826  1.00 31.54           C  
ATOM  15211  N   VAL C 615     -13.417  76.638  22.927  1.00 36.85           N  
ATOM  15212  CA  VAL C 615     -12.378  76.422  21.926  1.00 35.18           C  
ATOM  15213  C   VAL C 615     -11.379  75.437  22.545  1.00 35.86           C  
ATOM  15214  O   VAL C 615     -10.899  75.704  23.638  1.00 34.21           O  
ATOM  15215  CB  VAL C 615     -11.652  77.683  21.444  1.00 36.23           C  
ATOM  15216  CG1 VAL C 615     -10.594  77.310  20.397  1.00 29.46           C  
ATOM  15217  CG2 VAL C 615     -12.591  78.719  20.838  1.00 32.26           C  
ATOM  15218  N   VAL C 616     -11.193  74.292  21.880  1.00 35.06           N  
ATOM  15219  CA  VAL C 616     -10.263  73.283  22.392  1.00 32.80           C  
ATOM  15220  C   VAL C 616      -9.167  72.979  21.365  1.00 34.77           C  
ATOM  15221  O   VAL C 616      -9.407  72.768  20.167  1.00 32.51           O  
ATOM  15222  CB  VAL C 616     -10.933  71.969  22.782  1.00 33.21           C  
ATOM  15223  CG1 VAL C 616      -9.884  70.978  23.300  1.00 29.42           C  
ATOM  15224  CG2 VAL C 616     -12.051  72.161  23.796  1.00 34.50           C  
ATOM  15225  N   VAL C 617      -7.928  73.076  21.849  1.00 34.88           N  
ATOM  15226  CA  VAL C 617      -6.745  72.865  21.037  1.00 32.52           C  
ATOM  15227  C   VAL C 617      -6.283  71.438  21.283  1.00 34.23           C  
ATOM  15228  O   VAL C 617      -6.160  71.004  22.421  1.00 32.10           O  
ATOM  15229  CB  VAL C 617      -5.606  73.848  21.280  1.00 36.57           C  
ATOM  15230  CG1 VAL C 617      -4.390  73.519  20.405  1.00 31.03           C  
ATOM  15231  CG2 VAL C 617      -6.040  75.280  20.949  1.00 33.56           C  
ATOM  15232  N   VAL C 618      -6.160  70.701  20.168  1.00 31.32           N  
ATOM  15233  CA  VAL C 618      -5.687  69.313  20.279  1.00 30.05           C  
ATOM  15234  C   VAL C 618      -4.343  69.133  19.589  1.00 30.18           C  
ATOM  15235  O   VAL C 618      -4.154  69.542  18.452  1.00 29.40           O  
ATOM  15236  CB  VAL C 618      -6.730  68.364  19.664  1.00 32.19           C  
ATOM  15237  CG1 VAL C 618      -6.257  66.910  19.718  1.00 28.39           C  
ATOM  15238  CG2 VAL C 618      -8.090  68.503  20.377  1.00 28.92           C  
ATOM  15239  N   ARG C 619      -3.407  68.443  20.207  1.00 31.58           N  
ATOM  15240  CA  ARG C 619      -2.101  68.108  19.631  1.00 31.90           C  
ATOM  15241  C   ARG C 619      -2.214  67.148  18.459  1.00 35.60           C  
ATOM  15242  O   ARG C 619      -3.199  66.387  18.317  1.00 32.47           O  
ATOM  15243  CB  ARG C 619      -1.227  67.436  20.706  1.00 28.91           C  
ATOM  15244  CG  ARG C 619      -0.776  68.362  21.801  1.00 31.01           C  
ATOM  15245  CD  ARG C 619      -0.628  67.710  23.167  1.00 27.70           C  
ATOM  15246  NE  ARG C 619       0.141  66.501  23.157  1.00 26.63           N  
ATOM  15247  CZ  ARG C 619       0.881  65.970  24.100  1.00 27.64           C  
ATOM  15248  NH1 ARG C 619       0.975  66.580  25.268  1.00 29.54           N  
ATOM  15249  NH2 ARG C 619       1.506  64.822  23.820  1.00 21.62           N  
ATOM  15250  N   PRO C 620      -1.129  67.021  17.696  1.00 34.42           N  
ATOM  15251  CA  PRO C 620      -1.054  66.182  16.512  1.00 32.83           C  
ATOM  15252  C   PRO C 620      -1.373  64.731  16.818  1.00 30.85           C  
ATOM  15253  O   PRO C 620      -1.881  63.950  16.041  1.00 29.40           O  
ATOM  15254  CB  PRO C 620       0.366  66.407  15.946  1.00 31.37           C  
ATOM  15255  CG  PRO C 620       0.663  67.795  16.378  1.00 31.59           C  
ATOM  15256  CD  PRO C 620       0.091  67.881  17.786  1.00 32.84           C  
ATOM  15257  N   ASP C 621      -1.065  64.324  17.998  1.00 28.31           N  
ATOM  15258  CA  ASP C 621      -1.212  63.185  18.823  1.00 28.34           C  
ATOM  15259  C   ASP C 621      -2.642  62.842  19.276  1.00 25.91           C  
ATOM  15260  O   ASP C 621      -2.906  61.843  19.955  1.00 24.90           O  
ATOM  15261  CB  ASP C 621      -0.626  63.820  20.182  1.00 36.59           C  
ATOM  15262  CG  ASP C 621       0.347  62.833  20.758  1.00 42.16           C  
ATOM  15263  OD1 ASP C 621       0.487  61.821  20.009  1.00 51.25           O  
ATOM  15264  OD2 ASP C 621       0.918  63.095  21.822  1.00 33.56           O  
ATOM  15265  N   GLY C 622      -3.523  63.843  19.243  1.00 21.85           N  
ATOM  15266  CA  GLY C 622      -4.878  63.602  19.732  1.00 30.31           C  
ATOM  15267  C   GLY C 622      -5.036  63.925  21.214  1.00 30.34           C  
ATOM  15268  O   GLY C 622      -6.053  63.514  21.760  1.00 31.07           O  
ATOM  15269  N   TYR C 623      -4.059  64.549  21.856  1.00 29.08           N  
ATOM  15270  CA  TYR C 623      -4.183  64.927  23.265  1.00 30.54           C  
ATOM  15271  C   TYR C 623      -4.548  66.394  23.407  1.00 30.60           C  
ATOM  15272  O   TYR C 623      -4.032  67.232  22.638  1.00 30.66           O  
ATOM  15273  CB  TYR C 623      -2.882  64.604  24.013  1.00 28.07           C  
ATOM  15274  CG  TYR C 623      -2.753  63.130  24.341  1.00 29.38           C  
ATOM  15275  CD1 TYR C 623      -2.425  62.217  23.356  1.00 27.73           C  
ATOM  15276  CD2 TYR C 623      -2.992  62.633  25.606  1.00 28.75           C  
ATOM  15277  CE1 TYR C 623      -2.299  60.867  23.643  1.00 28.31           C  
ATOM  15278  CE2 TYR C 623      -2.881  61.294  25.901  1.00 27.20           C  
ATOM  15279  CZ  TYR C 623      -2.538  60.407  24.913  1.00 28.15           C  
ATOM  15280  OH  TYR C 623      -2.416  59.062  25.187  1.00 28.15           O  
ATOM  15281  N   THR C 624      -5.547  66.677  24.237  1.00 31.56           N  
ATOM  15282  CA  THR C 624      -6.028  68.065  24.454  1.00 30.21           C  
ATOM  15283  C   THR C 624      -4.925  68.874  25.112  1.00 28.96           C  
ATOM  15284  O   THR C 624      -4.330  68.384  26.081  1.00 27.46           O  
ATOM  15285  CB  THR C 624      -7.292  68.035  25.326  1.00 35.23           C  
ATOM  15286  OG1 THR C 624      -8.293  67.219  24.664  1.00 30.97           O  
ATOM  15287  CG2 THR C 624      -7.845  69.422  25.679  1.00 27.48           C  
ATOM  15288  N   SER C 625      -4.632  70.062  24.622  1.00 27.67           N  
ATOM  15289  CA  SER C 625      -3.546  70.846  25.186  1.00 30.96           C  
ATOM  15290  C   SER C 625      -3.939  72.249  25.617  1.00 32.66           C  
ATOM  15291  O   SER C 625      -3.122  72.946  26.255  1.00 34.36           O  
ATOM  15292  CB  SER C 625      -2.420  70.978  24.136  1.00 26.89           C  
ATOM  15293  OG  SER C 625      -3.011  71.325  22.879  1.00 27.81           O  
ATOM  15294  N   LEU C 626      -5.153  72.664  25.275  1.00 32.07           N  
ATOM  15295  CA  LEU C 626      -5.577  73.996  25.670  1.00 34.25           C  
ATOM  15296  C   LEU C 626      -7.090  74.121  25.570  1.00 36.14           C  
ATOM  15297  O   LEU C 626      -7.716  73.678  24.599  1.00 35.29           O  
ATOM  15298  CB  LEU C 626      -4.888  75.111  24.892  1.00 31.18           C  
ATOM  15299  CG  LEU C 626      -5.256  76.536  25.333  1.00 34.95           C  
ATOM  15300  CD1 LEU C 626      -4.367  76.950  26.497  1.00 33.74           C  
ATOM  15301  CD2 LEU C 626      -5.227  77.534  24.208  1.00 32.21           C  
ATOM  15302  N   VAL C 627      -7.669  74.713  26.610  1.00 35.64           N  
ATOM  15303  CA  VAL C 627      -9.116  74.950  26.639  1.00 35.04           C  
ATOM  15304  C   VAL C 627      -9.426  76.398  27.011  1.00 35.99           C  
ATOM  15305  O   VAL C 627      -9.039  76.842  28.093  1.00 37.67           O  
ATOM  15306  CB  VAL C 627      -9.788  74.006  27.652  1.00 36.76           C  
ATOM  15307  CG1 VAL C 627     -11.231  74.427  27.936  1.00 30.65           C  
ATOM  15308  CG2 VAL C 627      -9.722  72.551  27.174  1.00 30.39           C  
ATOM  15309  N   THR C 628     -10.064  77.138  26.143  1.00 35.89           N  
ATOM  15310  CA  THR C 628     -10.434  78.505  26.301  1.00 37.48           C  
ATOM  15311  C   THR C 628     -11.834  78.761  25.697  1.00 36.68           C  
ATOM  15312  O   THR C 628     -12.598  77.872  25.330  1.00 37.71           O  
ATOM  15313  CB  THR C 628      -9.640  79.594  25.523  1.00 41.00           C  
ATOM  15314  OG1 THR C 628      -8.637  79.061  24.707  1.00 43.69           O  
ATOM  15315  CG2 THR C 628      -9.225  80.704  26.454  1.00 34.85           C  
ATOM  15316  N   ASP C 629     -12.122  80.061  25.575  1.00 35.29           N  
ATOM  15317  CA  ASP C 629     -13.371  80.512  24.988  1.00 37.97           C  
ATOM  15318  C   ASP C 629     -13.042  81.133  23.651  1.00 36.66           C  
ATOM  15319  O   ASP C 629     -11.854  81.235  23.328  1.00 38.01           O  
ATOM  15320  CB  ASP C 629     -14.108  81.417  25.967  1.00 38.43           C  
ATOM  15321  CG  ASP C 629     -13.266  82.513  26.562  1.00 42.39           C  
ATOM  15322  OD1 ASP C 629     -12.329  83.042  25.936  1.00 45.01           O  
ATOM  15323  OD2 ASP C 629     -13.564  82.869  27.714  1.00 46.10           O  
ATOM  15324  N   LEU C 630     -14.013  81.616  22.902  1.00 37.08           N  
ATOM  15325  CA  LEU C 630     -13.789  82.238  21.604  1.00 37.07           C  
ATOM  15326  C   LEU C 630     -12.981  83.518  21.724  1.00 40.86           C  
ATOM  15327  O   LEU C 630     -12.348  83.924  20.748  1.00 40.72           O  
ATOM  15328  CB  LEU C 630     -15.144  82.503  20.933  1.00 39.03           C  
ATOM  15329  CG  LEU C 630     -15.917  81.277  20.463  1.00 43.08           C  
ATOM  15330  CD1 LEU C 630     -17.360  81.536  20.101  1.00 41.64           C  
ATOM  15331  CD2 LEU C 630     -15.232  80.640  19.254  1.00 44.69           C  
ATOM  15332  N   GLU C 631     -12.979  84.155  22.899  1.00 40.02           N  
ATOM  15333  CA  GLU C 631     -12.224  85.371  23.149  1.00 40.69           C  
ATOM  15334  C   GLU C 631     -10.776  85.097  23.516  1.00 40.03           C  
ATOM  15335  O   GLU C 631      -9.942  86.001  23.482  1.00 41.71           O  
ATOM  15336  CB  GLU C 631     -12.873  86.177  24.300  1.00 41.54           C  
ATOM  15337  CG  GLU C 631     -14.225  86.756  23.939  1.00 41.41           C  
ATOM  15338  CD  GLU C 631     -15.401  85.815  24.024  1.00 43.25           C  
ATOM  15339  OE1 GLU C 631     -15.404  84.779  24.710  1.00 45.63           O  
ATOM  15340  OE2 GLU C 631     -16.431  86.064  23.371  1.00 50.81           O  
ATOM  15341  N   GLY C 632     -10.433  83.864  23.888  1.00 38.37           N  
ATOM  15342  CA  GLY C 632      -9.089  83.482  24.256  1.00 35.80           C  
ATOM  15343  C   GLY C 632      -8.104  83.303  23.095  1.00 36.92           C  
ATOM  15344  O   GLY C 632      -7.196  82.474  23.164  1.00 35.64           O  
ATOM  15345  N   THR C 633      -8.068  84.221  22.139  1.00 34.97           N  
ATOM  15346  CA  THR C 633      -7.170  84.219  21.024  1.00 38.28           C  
ATOM  15347  C   THR C 633      -5.725  84.476  21.447  1.00 39.52           C  
ATOM  15348  O   THR C 633      -4.817  83.965  20.810  1.00 41.16           O  
ATOM  15349  CB  THR C 633      -7.654  85.255  19.998  1.00 39.92           C  
ATOM  15350  OG1 THR C 633      -7.709  86.539  20.627  1.00 39.83           O  
ATOM  15351  CG2 THR C 633      -9.046  84.920  19.516  1.00 42.10           C  
ATOM  15352  N   ALA C 634      -5.509  85.208  22.540  1.00 39.29           N  
ATOM  15353  CA  ALA C 634      -4.179  85.494  23.048  1.00 39.77           C  
ATOM  15354  C   ALA C 634      -3.579  84.242  23.678  1.00 39.46           C  
ATOM  15355  O   ALA C 634      -2.409  83.922  23.449  1.00 40.90           O  
ATOM  15356  CB  ALA C 634      -4.179  86.642  24.037  1.00 33.78           C  
ATOM  15357  N   GLU C 635      -4.407  83.446  24.350  1.00 38.30           N  
ATOM  15358  CA  GLU C 635      -3.947  82.167  24.859  1.00 39.00           C  
ATOM  15359  C   GLU C 635      -3.633  81.157  23.745  1.00 39.38           C  
ATOM  15360  O   GLU C 635      -2.740  80.320  23.878  1.00 38.88           O  
ATOM  15361  CB  GLU C 635      -5.021  81.560  25.760  1.00 43.15           C  
ATOM  15362  CG  GLU C 635      -5.022  82.250  27.109  1.00 48.23           C  
ATOM  15363  CD  GLU C 635      -5.967  83.427  27.202  1.00 49.77           C  
ATOM  15364  OE1 GLU C 635      -6.491  84.041  26.253  1.00 45.47           O  
ATOM  15365  OE2 GLU C 635      -6.222  83.737  28.378  1.00 60.58           O  
ATOM  15366  N   ILE C 636      -4.357  81.206  22.637  1.00 36.67           N  
ATOM  15367  CA  ILE C 636      -4.047  80.396  21.481  1.00 39.89           C  
ATOM  15368  C   ILE C 636      -2.732  80.823  20.827  1.00 40.10           C  
ATOM  15369  O   ILE C 636      -1.929  79.954  20.465  1.00 37.82           O  
ATOM  15370  CB  ILE C 636      -5.225  80.428  20.498  1.00 40.84           C  
ATOM  15371  CG1 ILE C 636      -6.420  79.705  21.160  1.00 37.98           C  
ATOM  15372  CG2 ILE C 636      -4.866  79.812  19.161  1.00 39.59           C  
ATOM  15373  CD1 ILE C 636      -7.756  79.920  20.447  1.00 34.27           C  
ATOM  15374  N   ASP C 637      -2.512  82.131  20.662  1.00 39.87           N  
ATOM  15375  CA  ASP C 637      -1.253  82.609  20.119  1.00 40.92           C  
ATOM  15376  C   ASP C 637      -0.097  82.157  20.990  1.00 41.11           C  
ATOM  15377  O   ASP C 637       0.857  81.670  20.412  1.00 43.75           O  
ATOM  15378  CB  ASP C 637      -1.180  84.143  20.068  1.00 40.72           C  
ATOM  15379  CG  ASP C 637      -2.153  84.656  19.037  1.00 48.63           C  
ATOM  15380  OD1 ASP C 637      -2.261  84.004  17.972  1.00 49.91           O  
ATOM  15381  OD2 ASP C 637      -2.786  85.697  19.299  1.00 51.90           O  
ATOM  15382  N   ARG C 638      -0.228  82.325  22.313  1.00 38.03           N  
ATOM  15383  CA  ARG C 638       0.890  82.036  23.178  1.00 37.05           C  
ATOM  15384  C   ARG C 638       1.148  80.531  23.128  1.00 36.31           C  
ATOM  15385  O   ARG C 638       2.291  80.108  23.186  1.00 37.31           O  
ATOM  15386  CB  ARG C 638       0.739  82.484  24.618  1.00 39.20           C  
ATOM  15387  CG  ARG C 638       1.128  83.875  24.992  1.00 46.84           C  
ATOM  15388  CD  ARG C 638       1.178  84.270  26.453  1.00 50.48           C  
ATOM  15389  NE  ARG C 638       1.843  83.343  27.336  1.00 53.01           N  
ATOM  15390  CZ  ARG C 638       1.295  82.412  28.097  1.00 54.28           C  
ATOM  15391  NH1 ARG C 638      -0.025  82.248  28.107  1.00 53.61           N  
ATOM  15392  NH2 ARG C 638       2.065  81.627  28.849  1.00 55.16           N  
ATOM  15393  N   TYR C 639       0.120  79.703  23.116  1.00 34.92           N  
ATOM  15394  CA  TYR C 639       0.328  78.267  23.092  1.00 33.57           C  
ATOM  15395  C   TYR C 639       1.170  77.895  21.853  1.00 34.72           C  
ATOM  15396  O   TYR C 639       2.127  77.117  21.965  1.00 30.45           O  
ATOM  15397  CB  TYR C 639      -1.015  77.539  23.102  1.00 29.20           C  
ATOM  15398  CG  TYR C 639      -0.827  76.039  22.903  1.00 29.92           C  
ATOM  15399  CD1 TYR C 639      -0.293  75.268  23.924  1.00 27.88           C  
ATOM  15400  CD2 TYR C 639      -1.125  75.425  21.699  1.00 29.07           C  
ATOM  15401  CE1 TYR C 639      -0.065  73.925  23.767  1.00 30.54           C  
ATOM  15402  CE2 TYR C 639      -0.918  74.063  21.530  1.00 29.54           C  
ATOM  15403  CZ  TYR C 639      -0.385  73.328  22.561  1.00 30.70           C  
ATOM  15404  OH  TYR C 639      -0.169  71.990  22.399  1.00 29.73           O  
ATOM  15405  N   PHE C 640       0.843  78.431  20.690  1.00 32.92           N  
ATOM  15406  CA  PHE C 640       1.519  78.044  19.463  1.00 38.12           C  
ATOM  15407  C   PHE C 640       2.886  78.693  19.324  1.00 41.24           C  
ATOM  15408  O   PHE C 640       3.808  78.056  18.812  1.00 44.61           O  
ATOM  15409  CB  PHE C 640       0.623  78.287  18.245  1.00 34.34           C  
ATOM  15410  CG  PHE C 640      -0.453  77.258  18.078  1.00 36.23           C  
ATOM  15411  CD1 PHE C 640      -0.158  75.977  17.632  1.00 38.48           C  
ATOM  15412  CD2 PHE C 640      -1.781  77.541  18.390  1.00 36.27           C  
ATOM  15413  CE1 PHE C 640      -1.138  75.013  17.470  1.00 37.10           C  
ATOM  15414  CE2 PHE C 640      -2.768  76.597  18.228  1.00 38.86           C  
ATOM  15415  CZ  PHE C 640      -2.451  75.328  17.755  1.00 35.67           C  
ATOM  15416  N   SER C 641       3.090  79.885  19.866  1.00 40.36           N  
ATOM  15417  CA  SER C 641       4.351  80.587  19.823  1.00 39.06           C  
ATOM  15418  C   SER C 641       5.456  79.819  20.534  1.00 37.52           C  
ATOM  15419  O   SER C 641       6.602  79.846  20.066  1.00 37.77           O  
ATOM  15420  CB  SER C 641       4.240  81.955  20.540  1.00 42.09           C  
ATOM  15421  OG  SER C 641       3.731  82.923  19.662  1.00 47.82           O  
ATOM  15422  N   GLY C 642       5.095  79.124  21.626  1.00 34.39           N  
ATOM  15423  CA  GLY C 642       6.152  78.385  22.326  1.00 35.79           C  
ATOM  15424  C   GLY C 642       6.532  77.087  21.610  1.00 38.37           C  
ATOM  15425  O   GLY C 642       7.498  76.417  21.994  1.00 40.61           O  
ATOM  15426  N   ILE C 643       5.751  76.668  20.628  1.00 36.88           N  
ATOM  15427  CA  ILE C 643       5.975  75.399  19.948  1.00 36.93           C  
ATOM  15428  C   ILE C 643       6.380  75.524  18.495  1.00 35.02           C  
ATOM  15429  O   ILE C 643       7.339  74.852  18.116  1.00 36.29           O  
ATOM  15430  CB  ILE C 643       4.667  74.565  20.003  1.00 38.13           C  
ATOM  15431  CG1 ILE C 643       4.284  74.332  21.464  1.00 33.04           C  
ATOM  15432  CG2 ILE C 643       4.815  73.246  19.254  1.00 33.95           C  
ATOM  15433  CD1 ILE C 643       2.828  73.911  21.629  1.00 35.06           C  
ATOM  15434  N   LEU C 644       5.614  76.271  17.713  1.00 34.09           N  
ATOM  15435  CA  LEU C 644       5.845  76.311  16.277  1.00 35.30           C  
ATOM  15436  C   LEU C 644       6.869  77.354  15.822  1.00 39.69           C  
ATOM  15437  O   LEU C 644       7.116  78.381  16.459  1.00 38.91           O  
ATOM  15438  CB  LEU C 644       4.520  76.540  15.559  1.00 35.89           C  
ATOM  15439  CG  LEU C 644       3.414  75.497  15.743  1.00 39.62           C  
ATOM  15440  CD1 LEU C 644       2.212  75.877  14.895  1.00 36.59           C  
ATOM  15441  CD2 LEU C 644       3.914  74.097  15.375  1.00 36.63           C  
ATOM  15442  N   VAL C 645       7.493  77.051  14.688  1.00 37.85           N  
ATOM  15443  CA  VAL C 645       8.459  77.900  14.037  1.00 37.45           C  
ATOM  15444  C   VAL C 645       7.762  78.480  12.825  1.00 38.60           C  
ATOM  15445  O   VAL C 645       7.217  77.730  12.017  1.00 42.28           O  
ATOM  15446  CB  VAL C 645       9.736  77.179  13.527  1.00 39.51           C  
ATOM  15447  CG1 VAL C 645      10.661  78.144  12.789  1.00 29.65           C  
ATOM  15448  CG2 VAL C 645      10.438  76.529  14.693  1.00 32.61           C  
ATOM  15449  N   GLU C 646       7.783  79.777  12.689  1.00 38.43           N  
ATOM  15450  CA  GLU C 646       7.141  80.425  11.552  1.00 43.16           C  
ATOM  15451  C   GLU C 646       7.812  80.093  10.233  1.00 45.75           C  
ATOM  15452  O   GLU C 646       9.037  80.146  10.111  1.00 46.98           O  
ATOM  15453  CB  GLU C 646       7.224  81.917  11.852  1.00 42.54           C  
ATOM  15454  CG  GLU C 646       6.576  82.872  10.888  1.00 49.62           C  
ATOM  15455  CD  GLU C 646       6.543  84.273  11.493  1.00 55.16           C  
ATOM  15456  OE1 GLU C 646       6.394  84.396  12.723  1.00 50.37           O  
ATOM  15457  OE2 GLU C 646       6.676  85.243  10.724  1.00 57.09           O  
ATOM  15458  N   PRO C 647       7.045  79.753   9.212  1.00 47.66           N  
ATOM  15459  CA  PRO C 647       7.584  79.504   7.888  1.00 47.17           C  
ATOM  15460  C   PRO C 647       8.291  80.760   7.390  1.00 48.92           C  
ATOM  15461  O   PRO C 647       7.900  81.874   7.738  1.00 47.00           O  
ATOM  15462  CB  PRO C 647       6.392  79.184   7.009  1.00 45.29           C  
ATOM  15463  CG  PRO C 647       5.181  79.334   7.842  1.00 46.77           C  
ATOM  15464  CD  PRO C 647       5.564  79.707   9.244  1.00 46.42           C  
ATOM  15465  N   LYS C 648       9.218  80.569   6.464  1.00 49.57           N  
ATOM  15466  CA  LYS C 648       9.959  81.659   5.814  1.00 51.28           C  
ATOM  15467  C   LYS C 648       9.014  82.643   5.172  1.00 49.09           C  
ATOM  15468  O   LYS C 648       9.163  83.851   5.319  1.00 49.30           O  
ATOM  15469  CB  LYS C 648      10.941  80.997   4.849  1.00 57.95           C  
ATOM  15470  CG  LYS C 648      11.395  81.712   3.610  1.00 61.71           C  
ATOM  15471  CD  LYS C 648      12.446  80.884   2.895  1.00 66.16           C  
ATOM  15472  CE  LYS C 648      12.427  81.079   1.384  1.00 67.68           C  
ATOM  15473  NZ  LYS C 648      12.353  79.779   0.656  1.00 67.79           N  
ATOM  15474  N   GLU C 649       8.010  82.157   4.471  1.00 49.79           N  
ATOM  15475  CA  GLU C 649       6.980  82.956   3.830  1.00 49.46           C  
ATOM  15476  C   GLU C 649       5.601  82.555   4.362  1.00 48.91           C  
ATOM  15477  O   GLU C 649       5.018  81.521   4.057  1.00 47.60           O  
ATOM  15478  CB  GLU C 649       7.028  82.796   2.322  1.00 52.71           C  
ATOM  15479  CG  GLU C 649       8.210  83.477   1.626  1.00 61.62           C  
ATOM  15480  CD  GLU C 649       8.022  83.328   0.119  1.00 67.68           C  
ATOM  15481  OE1 GLU C 649       8.299  82.208  -0.379  1.00 72.83           O  
ATOM  15482  OE2 GLU C 649       7.535  84.294  -0.505  1.00 70.07           O  
ATOM  15483  N   LYS C 650       5.046  83.382   5.217  1.00 50.94           N  
ATOM  15484  CA  LYS C 650       3.774  83.213   5.881  1.00 47.34           C  
ATOM  15485  C   LYS C 650       2.617  83.391   4.919  1.00 45.77           C  
ATOM  15486  O   LYS C 650       2.697  84.185   3.980  1.00 46.22           O  
ATOM  15487  CB  LYS C 650       3.611  84.297   6.952  1.00 48.73           C  
ATOM  15488  CG  LYS C 650       4.760  84.427   7.932  1.00 55.78           C  
ATOM  15489  CD  LYS C 650       4.312  85.225   9.142  1.00 60.41           C  
ATOM  15490  CE  LYS C 650       4.530  86.720   8.979  1.00 64.02           C  
ATOM  15491  NZ  LYS C 650       3.429  87.505   9.640  1.00 63.40           N  
ATOM  15492  N   SER C 651       1.491  82.772   5.227  1.00 43.76           N  
ATOM  15493  CA  SER C 651       0.284  82.990   4.413  1.00 42.42           C  
ATOM  15494  C   SER C 651      -0.240  84.407   4.619  1.00 40.90           C  
ATOM  15495  O   SER C 651      -0.694  85.042   3.660  1.00 40.79           O  
ATOM  15496  CB  SER C 651      -0.754  81.919   4.723  1.00 41.20           C  
ATOM  15497  OG  SER C 651      -2.053  82.267   4.301  1.00 42.96           O  
ATOM  15498  N   GLY C 652      -0.140  84.967   5.826  1.00 42.49           N  
ATOM  15499  CA  GLY C 652      -0.616  86.328   6.066  1.00 42.36           C  
ATOM  15500  C   GLY C 652      -2.141  86.366   6.173  1.00 44.49           C  
ATOM  15501  O   GLY C 652      -2.774  85.316   6.207  1.00 42.95           O  
ATOM  15502  N   ALA C 653      -2.728  87.549   6.264  1.00 44.71           N  
ATOM  15503  CA  ALA C 653      -4.166  87.672   6.375  1.00 47.98           C  
ATOM  15504  C   ALA C 653      -4.940  86.961   5.273  1.00 48.58           C  
ATOM  15505  O   ALA C 653      -4.557  87.007   4.108  1.00 46.99           O  
ATOM  15506  CB  ALA C 653      -4.548  89.149   6.372  1.00 45.45           C  
ATOM  15507  N   GLN C 654      -6.064  86.360   5.626  1.00 49.64           N  
ATOM  15508  CA  GLN C 654      -6.962  85.753   4.663  1.00 51.83           C  
ATOM  15509  C   GLN C 654      -7.389  86.784   3.624  1.00 53.66           C  
ATOM  15510  O   GLN C 654      -8.132  87.697   3.974  1.00 55.23           O  
ATOM  15511  CB  GLN C 654      -8.217  85.236   5.373  1.00 53.87           C  
ATOM  15512  CG  GLN C 654      -8.912  84.027   4.778  1.00 52.08           C  
ATOM  15513  CD  GLN C 654      -9.264  84.210   3.325  1.00 54.21           C  
ATOM  15514  OE1 GLN C 654      -8.633  83.613   2.456  1.00 57.98           O  
ATOM  15515  NE2 GLN C 654     -10.219  85.100   3.062  1.00 54.14           N  
ATOM  15516  N   THR C 655      -7.116  86.580   2.357  1.00 55.13           N  
ATOM  15517  CA  THR C 655      -7.487  87.464   1.279  1.00 57.45           C  
ATOM  15518  C   THR C 655      -8.574  86.962   0.332  1.00 59.04           C  
ATOM  15519  O   THR C 655      -8.936  87.679  -0.619  1.00 60.10           O  
ATOM  15520  CB  THR C 655      -6.259  87.748   0.356  1.00 57.65           C  
ATOM  15521  OG1 THR C 655      -5.510  86.543   0.211  1.00 55.66           O  
ATOM  15522  CG2 THR C 655      -5.391  88.858   0.908  1.00 57.97           C  
ATOM  15523  N   GLU C 656      -9.097  85.756   0.507  1.00 59.11           N  
ATOM  15524  CA  GLU C 656     -10.121  85.278  -0.420  1.00 60.22           C  
ATOM  15525  C   GLU C 656     -11.517  85.773  -0.043  1.00 59.50           C  
ATOM  15526  O   GLU C 656     -11.865  85.933   1.118  1.00 58.65           O  
ATOM  15527  CB  GLU C 656     -10.133  83.761  -0.540  1.00 61.93           C  
ATOM  15528  CG  GLU C 656      -8.745  83.147  -0.535  1.00 65.56           C  
ATOM  15529  CD  GLU C 656      -8.172  82.999  -1.929  1.00 69.30           C  
ATOM  15530  OE1 GLU C 656      -8.877  83.269  -2.928  1.00 68.96           O  
ATOM  15531  OE2 GLU C 656      -6.985  82.611  -2.004  1.00 69.38           O  
ATOM  15532  N   ALA C 657     -12.286  86.037  -1.093  1.00 59.23           N  
ATOM  15533  CA  ALA C 657     -13.662  86.490  -0.974  1.00 58.07           C  
ATOM  15534  C   ALA C 657     -14.501  85.342  -0.431  1.00 56.70           C  
ATOM  15535  O   ALA C 657     -14.031  84.203  -0.515  1.00 57.32           O  
ATOM  15536  CB  ALA C 657     -14.203  86.922  -2.328  1.00 58.39           C  
ATOM  15537  N   ASP C 658     -15.627  85.642   0.190  1.00 53.66           N  
ATOM  15538  CA  ASP C 658     -16.478  84.558   0.685  1.00 53.82           C  
ATOM  15539  C   ASP C 658     -16.990  83.811  -0.551  1.00 52.56           C  
ATOM  15540  O   ASP C 658     -17.783  84.307  -1.346  1.00 52.25           O  
ATOM  15541  CB  ASP C 658     -17.573  85.121   1.569  1.00 53.91           C  
ATOM  15542  CG  ASP C 658     -18.600  84.124   2.044  1.00 57.28           C  
ATOM  15543  OD1 ASP C 658     -18.741  83.049   1.422  1.00 58.41           O  
ATOM  15544  OD2 ASP C 658     -19.298  84.397   3.043  1.00 59.87           O  
ATOM  15545  N   TRP C 659     -16.549  82.570  -0.716  1.00 49.29           N  
ATOM  15546  CA  TRP C 659     -16.902  81.737  -1.852  1.00 47.24           C  
ATOM  15547  C   TRP C 659     -18.370  81.356  -1.949  1.00 49.20           C  
ATOM  15548  O   TRP C 659     -18.835  80.984  -3.030  1.00 49.38           O  
ATOM  15549  CB  TRP C 659     -16.069  80.446  -1.832  1.00 41.94           C  
ATOM  15550  CG  TRP C 659     -16.331  79.541  -0.664  1.00 38.45           C  
ATOM  15551  CD1 TRP C 659     -15.794  79.616   0.586  1.00 34.81           C  
ATOM  15552  CD2 TRP C 659     -17.214  78.418  -0.649  1.00 34.78           C  
ATOM  15553  NE1 TRP C 659     -16.278  78.605   1.371  1.00 35.13           N  
ATOM  15554  CE2 TRP C 659     -17.153  77.854   0.638  1.00 33.62           C  
ATOM  15555  CE3 TRP C 659     -18.030  77.823  -1.613  1.00 36.73           C  
ATOM  15556  CZ2 TRP C 659     -17.881  76.725   0.986  1.00 34.00           C  
ATOM  15557  CZ3 TRP C 659     -18.759  76.702  -1.254  1.00 34.91           C  
ATOM  15558  CH2 TRP C 659     -18.679  76.169   0.019  1.00 33.83           C  
ATOM  15559  N   THR C 660     -19.104  81.404  -0.851  1.00 49.06           N  
ATOM  15560  CA  THR C 660     -20.506  81.057  -0.829  1.00 53.26           C  
ATOM  15561  C   THR C 660     -21.378  82.167  -1.403  1.00 56.46           C  
ATOM  15562  O   THR C 660     -22.515  81.899  -1.804  1.00 55.01           O  
ATOM  15563  CB  THR C 660     -20.990  80.712   0.594  1.00 52.27           C  
ATOM  15564  OG1 THR C 660     -20.903  81.857   1.434  1.00 46.50           O  
ATOM  15565  CG2 THR C 660     -20.144  79.583   1.175  1.00 50.90           C  
ATOM  15566  N   LYS C 661     -20.853  83.385  -1.419  1.00 59.89           N  
ATOM  15567  CA  LYS C 661     -21.630  84.494  -1.951  1.00 65.97           C  
ATOM  15568  C   LYS C 661     -21.276  84.731  -3.419  1.00 69.65           C  
ATOM  15569  O   LYS C 661     -22.056  85.130  -4.272  1.00 71.86           O  
ATOM  15570  CB  LYS C 661     -21.335  85.805  -1.214  1.00 62.62           C  
ATOM  15571  CG  LYS C 661     -21.537  85.687   0.275  1.00 65.92           C  
ATOM  15572  CD  LYS C 661     -23.000  85.925   0.640  1.00 67.17           C  
ATOM  15573  CE  LYS C 661     -23.078  86.365   2.098  1.00 68.27           C  
ATOM  15574  NZ  LYS C 661     -22.264  85.453   2.962  1.00 68.38           N  
ATOM  15575  N   SER C 662     -19.978  84.628  -3.638  1.00 73.57           N  
ATOM  15576  CA  SER C 662     -19.395  85.088  -4.888  1.00 76.81           C  
ATOM  15577  C   SER C 662     -19.967  84.361  -6.076  1.00 79.42           C  
ATOM  15578  O   SER C 662     -20.212  83.166  -6.124  1.00 79.91           O  
ATOM  15579  CB  SER C 662     -17.882  85.120  -4.681  1.00 76.70           C  
ATOM  15580  OG  SER C 662     -17.706  86.064  -3.597  1.00 75.94           O  
ATOM  15581  N   THR C 663     -20.258  85.171  -7.085  1.00 84.12           N  
ATOM  15582  CA  THR C 663     -20.816  84.778  -8.367  1.00 86.27           C  
ATOM  15583  C   THR C 663     -19.667  84.354  -9.275  1.00 88.97           C  
ATOM  15584  O   THR C 663     -18.602  84.988  -9.163  1.00 90.52           O  
ATOM  15585  CB  THR C 663     -21.524  86.012  -8.972  1.00 86.22           C  
ATOM  15586  OG1 THR C 663     -21.695  87.018  -7.955  1.00 84.60           O  
ATOM  15587  CG2 THR C 663     -22.873  85.636  -9.555  1.00 84.94           C  
ATOM  15588  N   ALA C 664     -19.832  83.345 -10.121  1.00 89.52           N  
ATOM  15589  CA  ALA C 664     -18.713  82.943 -10.994  1.00 91.17           C  
ATOM  15590  C   ALA C 664     -19.024  83.253 -12.460  1.00 92.27           C  
ATOM  15591  O   ALA C 664     -20.194  83.545 -12.788  1.00 93.81           O  
ATOM  15592  CB  ALA C 664     -18.450  81.439 -10.878  1.00 90.86           C  
TER   15593      ALA C 664                                                      
END
MOLECULE T0490.pdb
ATOM      1  N   THR     3      26.547  61.762   4.288  1.00 30.83           N  
ATOM      2  CA  THR     3      25.686  62.760   4.970  1.00 30.86           C  
ATOM      3  CB  THR     3      24.743  63.446   3.956  1.00 31.28           C  
ATOM      4  OG1 THR     3      23.857  62.472   3.394  1.00 33.76           O  
ATOM      5  CG2 THR     3      25.545  64.077   2.829  1.00 32.39           C  
ATOM      6  C   THR     3      24.875  62.112   6.108  1.00 29.87           C  
ATOM      7  O   THR     3      24.664  60.894   6.139  1.00 30.04      A    O  
ATOM      8  N   ASP     4      24.420  62.918   7.058  1.00 28.40      A    N  
ATOM      9  CA  ASP     4      23.613  62.360   8.116  1.00 26.82      A    C  
ATOM     10  CB  ASP     4      23.315  63.426   9.167  1.00 27.09      A    C  
ATOM     11  CG  ASP     4      24.568  63.956   9.804  1.00 27.99      A    C  
ATOM     12  OD1 ASP     4      25.591  63.256   9.689  1.00 27.47      A    O  
ATOM     13  OD2 ASP     4      24.539  65.052  10.415  1.00 27.69      A    O  
ATOM     14  C   ASP     4      22.302  61.824   7.536  1.00 25.43      A    C  
ATOM     15  O   ASP     4      21.692  62.460   6.668  1.00 25.65      A    O  
ATOM     16  N   ILE     5      21.883  60.651   7.993  1.00 22.86      A    N  
ATOM     17  CA  ILE     5      20.492  60.264   7.862  1.00 20.85      A    C  
ATOM     18  CB  ILE     5      20.306  58.784   8.160  1.00 21.43      A    C  
ATOM     19  CG1 ILE     5      21.076  57.962   7.130  1.00 21.60      A    C  
ATOM     20  CD1 ILE     5      21.089  56.510   7.429  1.00 24.74      A    C  
ATOM     21  CG2 ILE     5      18.821  58.422   8.197  1.00 20.64      A    C  
ATOM     22  C   ILE     5      19.787  61.060   8.943  1.00 19.56      A    C  
ATOM     23  O   ILE     5      20.360  61.305   9.993  1.00 19.01      A    O  
ATOM     24  N   ASP     6      18.561  61.493   8.697  1.00 17.68      A    N  
ATOM     25  CA  ASP     6      17.886  62.313   9.686  1.00 16.70      A    C  
ATOM     26  CB  ASP     6      16.604  62.919   9.115  1.00 17.32      A    C  
ATOM     27  CG  ASP     6      15.998  63.962  10.033  1.00 19.64      A    C  
ATOM     28  OD1 ASP     6      16.705  64.927  10.417  1.00 24.36      A    O  
ATOM     29  OD2 ASP     6      14.808  63.830  10.357  1.00 23.29      A    O  
ATOM     30  C   ASP     6      17.603  61.482  10.948  1.00 15.36      A    C  
ATOM     31  O   ASP     6      18.145  61.771  12.016  1.00 15.11      A    O  
ATOM     32  N   CYS     7      16.783  60.442  10.808  1.00 13.88      A    N  
ATOM     33  CA  CYS     7      16.381  59.596  11.951  1.00 13.17      A    C  
ATOM     34  CB  CYS     7      14.860  59.633  12.129  1.00 13.41      A    C  
ATOM     35  SG  CYS     7      14.137  61.228  12.616  1.00 16.56      A    S  
ATOM     36  C   CYS     7      16.756  58.134  11.726  1.00 12.09      A    C  
ATOM     37  O   CYS     7      16.460  57.589  10.666  1.00 12.24      A    O  
ATOM     38  N   ILE     8      17.398  57.503  12.711  1.00 10.67      A    N  
ATOM     39  CA  ILE     8      17.606  56.048  12.667  1.00  8.90      A    C  
ATOM     40  CB  ILE     8      19.105  55.697  12.732  1.00  9.01      A    C  
ATOM     41  CG1 ILE     8      19.794  56.208  11.453  1.00  9.20      A    C  
ATOM     42  CD1 ILE     8      21.275  55.875  11.355  1.00  9.32      A    C  
ATOM     43  CG2 ILE     8      19.326  54.187  12.879  1.00  8.23      A    C  
ATOM     44  C   ILE     8      16.821  55.421  13.821  1.00  8.24      A    C  
ATOM     45  O   ILE     8      16.911  55.882  14.954  1.00  9.14      A    O  
ATOM     46  N   VAL     9      16.027  54.403  13.517  1.00  8.44      A    N  
ATOM     47  CA  VAL     9      15.312  53.637  14.533  1.00  8.39      A    C  
ATOM     48  CB  VAL     9      13.837  53.445  14.168  1.00  9.16      A    C  
ATOM     49  CG1 VAL     9      13.112  52.551  15.201  1.00  8.57      A    C  
ATOM     50  CG2 VAL     9      13.157  54.814  14.075  1.00 10.05      A    C  
ATOM     51  C   VAL     9      15.979  52.270  14.583  1.00  8.12      A    C  
ATOM     52  O   VAL     9      16.114  51.620  13.546  1.00  8.73      A    O  
ATOM     53  N   ILE    10      16.414  51.866  15.771  1.00  7.97      A    N  
ATOM     54  CA  ILE    10      16.989  50.533  15.970  1.00  7.82      A    C  
ATOM     55  CB  ILE    10      18.113  50.529  17.022  1.00  7.94      A    C  
ATOM     56  CG1 ILE    10      19.161  51.610  16.720  1.00  7.84      A    C  
ATOM     57  CD1 ILE    10      19.863  51.460  15.338  1.00  7.30      A    C  
ATOM     58  CG2 ILE    10      18.748  49.133  17.093  1.00  8.58      A    C  
ATOM     59  C   ILE    10      15.903  49.556  16.437  1.00  7.58      A    C  
ATOM     60  O   ILE    10      15.336  49.713  17.523  1.00  7.74      A    O  
ATOM     61  N   GLY    11      15.625  48.558  15.613  1.00  7.35      A    N  
ATOM     62  CA  GLY    11      14.606  47.553  15.893  1.00  8.11      A    C  
ATOM     63  C   GLY    11      13.362  47.716  15.036  1.00  9.10      A    C  
ATOM     64  O   GLY    11      12.773  48.817  14.973  1.00  9.00      A    O  
ATOM     65  N   ALA    12      12.956  46.614  14.403  1.00  8.90      A    N  
ATOM     66  CA  ALA    12      11.758  46.579  13.569  1.00  8.90      A    C  
ATOM     67  CB  ALA    12      12.082  46.117  12.142  1.00  9.90      A    C  
ATOM     68  C   ALA    12      10.692  45.694  14.182  1.00  8.86      A    C  
ATOM     69  O   ALA    12       9.985  44.978  13.475  1.00  9.63      A    O  
ATOM     70  N   GLY    13      10.574  45.748  15.504  1.00  8.06      A    N  
ATOM     71  CA  GLY    13       9.417  45.172  16.161  1.00  7.81      A    C  
ATOM     72  C   GLY    13       8.215  46.092  16.025  1.00  8.37      A    C  
ATOM     73  O   GLY    13       8.281  47.120  15.348  1.00  8.18      A    O  
ATOM     74  N   VAL    14       7.115  45.726  16.671  1.00  8.40      A    N  
ATOM     75  CA  VAL    14       5.877  46.483  16.459  1.00  9.52      A    C  
ATOM     76  CB  VAL    14       4.647  45.799  17.117  1.00  9.86      A    C  
ATOM     77  CG1 VAL    14       4.414  44.410  16.512  1.00 12.57      A    C  
ATOM     78  CG2 VAL    14       4.782  45.739  18.645  1.00 10.08      A    C  
ATOM     79  C   VAL    14       6.022  47.925  16.935  1.00 10.04      A    C  
ATOM     80  O   VAL    14       5.447  48.863  16.341  1.00 10.04      A    O  
ATOM     81  N   VAL    15       6.785  48.101  18.012  1.00  9.60      A    N  
ATOM     82  CA  VAL    15       7.004  49.416  18.599  1.00  9.62      A    C  
ATOM     83  CB  VAL    15       7.469  49.304  20.083  1.00  9.21      A    C  
ATOM     84  CG1 VAL    15       7.758  50.667  20.637  1.00 11.32      A    C  
ATOM     85  CG2 VAL    15       6.403  48.606  20.926  1.00 10.95      A    C  
ATOM     86  C   VAL    15       7.987  50.241  17.773  1.00  9.54      A    C  
ATOM     87  O   VAL    15       7.739  51.404  17.481  1.00  9.33      A    O  
ATOM     88  N   GLY    16       9.116  49.647  17.386  1.00  9.32      A    N  
ATOM     89  CA  GLY    16      10.039  50.332  16.493  1.00  9.59      A    C  
ATOM     90  C   GLY    16       9.346  50.773  15.215  1.00  9.25      A    C  
ATOM     91  O   GLY    16       9.593  51.880  14.705  1.00  9.62      A    O  
ATOM     92  N   LEU    17       8.508  49.896  14.661  1.00  9.19      A    N  
ATOM     93  CA  LEU    17       7.808  50.214  13.417  1.00  9.11      A    C  
ATOM     94  CB  LEU    17       7.173  48.974  12.782  1.00  9.20      A    C  
ATOM     95  CG  LEU    17       8.167  47.975  12.167  1.00 10.80      A    C  
ATOM     96  CD1 LEU    17       7.497  46.667  11.777  1.00 12.92      A    C  
ATOM     97  CD2 LEU    17       8.900  48.605  10.984  1.00 13.27      A    C  
ATOM     98  C   LEU    17       6.765  51.313  13.615  1.00  9.25      A    C  
ATOM     99  O   LEU    17       6.627  52.185  12.752  1.00  9.50      A    O  
ATOM    100  N   ALA    18       6.044  51.281  14.733  1.00  8.68      A    N  
ATOM    101  CA  ALA    18       5.076  52.366  15.005  1.00  8.79      A    C  
ATOM    102  CB  ALA    18       4.306  52.119  16.285  1.00  8.59      A    C  
ATOM    103  C   ALA    18       5.797  53.708  15.076  1.00  9.13      A    C  
ATOM    104  O   ALA    18       5.309  54.716  14.585  1.00  9.58      A    O  
ATOM    105  N   ILE    19       6.962  53.724  15.714  1.00  8.73      A    N  
ATOM    106  CA  ILE    19       7.751  54.945  15.795  1.00  9.02      A    C  
ATOM    107  CB  ILE    19       8.926  54.770  16.785  1.00  8.31      A    C  
ATOM    108  CG1 ILE    19       8.387  54.535  18.208  1.00  8.79      A    C  
ATOM    109  CD1 ILE    19       9.436  53.989  19.182  1.00  8.74      A    C  
ATOM    110  CG2 ILE    19       9.870  55.980  16.722  1.00  8.49      A    C  
ATOM    111  C   ILE    19       8.283  55.405  14.433  1.00  8.99      A    C  
ATOM    112  O   ILE    19       8.202  56.591  14.106  1.00  9.86      A    O  
ATOM    113  N   ALA    20       8.825  54.478  13.641  1.00  9.69      A    N  
ATOM    114  CA  ALA    20       9.303  54.808  12.295  1.00 10.16      A    C  
ATOM    115  CB  ALA    20       9.826  53.564  11.598  1.00 10.60      A    C  
ATOM    116  C   ALA    20       8.146  55.403  11.487  1.00 10.95      A    C  
ATOM    117  O   ALA    20       8.307  56.412  10.795  1.00 12.16      A    O  
ATOM    118  N   ARG    21       6.989  54.763  11.580  1.00 10.83      A    N  
ATOM    119  CA  ARG    21       5.778  55.252  10.926  1.00 11.56      A    C  
ATOM    120  CB  ARG    21       4.606  54.300  11.199  1.00 10.87      A    C  
ATOM    121  CG  ARG    21       3.228  54.819  10.767  1.00 13.06      A    C  
ATOM    122  CD  ARG    21       2.157  53.773  11.067  1.00 13.28      A    C  
ATOM    123  NE  ARG    21       0.846  54.186  10.573  1.00 14.54      A    N  
ATOM    124  CZ  ARG    21       0.054  55.051  11.190  1.00 16.67      A    C  
ATOM    125  NH1 ARG    21       0.435  55.614  12.331  1.00 17.57      A    N  
ATOM    126  NH2 ARG    21      -1.126  55.365  10.653  1.00 16.89      A    N  
ATOM    127  C   ARG    21       5.448  56.697  11.329  1.00 11.67      A    C  
ATOM    128  O   ARG    21       5.183  57.543  10.456  1.00 12.36      A    O  
ATOM    129  N   ALA    22       5.460  56.983  12.631  1.00 12.00      A    N  
ATOM    130  CA  ALA    22       5.177  58.338  13.121  1.00 12.31      A    C  
ATOM    131  CB  ALA    22       5.071  58.339  14.617  1.00 12.63      A    C  
ATOM    132  C   ALA    22       6.227  59.361  12.649  1.00 13.41      A    C  
ATOM    133  O   ALA    22       5.882  60.457  12.175  1.00 13.54      A    O  
ATOM    134  N   LEU    23       7.504  59.011  12.786  1.00 13.21      A    N  
ATOM    135  CA  LEU    23       8.567  59.890  12.307  1.00 13.66      A    C  
ATOM    136  CB  LEU    23       9.949  59.314  12.635  1.00 13.40      A    C  
ATOM    137  CG  LEU    23      10.337  59.315  14.116  1.00 12.88      A    C  
ATOM    138  CD1 LEU    23      11.577  58.449  14.320  1.00 12.59      A    C  
ATOM    139  CD2 LEU    23      10.563  60.741  14.646  1.00 12.46      A    C  
ATOM    140  C   LEU    23       8.444  60.169  10.803  1.00 14.15      A    C  
ATOM    141  O   LEU    23       8.563  61.325  10.364  1.00 15.00      A    O  
ATOM    142  N   ALA    24       8.181  59.140  10.012  1.00 14.11      A    N  
ATOM    143  CA  ALA    24       8.135  59.318   8.565  1.00 14.56      A    C  
ATOM    144  CB  ALA    24       8.095  57.977   7.855  1.00 14.78      A    C  
ATOM    145  C   ALA    24       6.921  60.177   8.190  1.00 15.33      A    C  
ATOM    146  O   ALA    24       7.010  61.038   7.309  1.00 15.33      A    O  
ATOM    147  N   ALA    25       5.807  59.961   8.884  1.00 15.07      A    N  
ATOM    148  CA  ALA    25       4.586  60.736   8.636  1.00 15.64      A    C  
ATOM    149  CB  ALA    25       3.403  60.147   9.414  1.00 15.31      A    C  
ATOM    150  C   ALA    25       4.798  62.204   8.994  1.00 16.35      A    C  
ATOM    151  O   ALA    25       4.101  63.093   8.478  1.00 17.36      A    O  
ATOM    152  N   GLY    26       5.761  62.466   9.870  1.00 16.03      A    N  
ATOM    153  CA  GLY    26       6.092  63.834  10.270  1.00 17.08      A    C  
ATOM    154  C   GLY    26       7.062  64.494   9.305  1.00 17.67      A    C  
ATOM    155  O   GLY    26       7.528  65.605   9.554  1.00 18.13      A    O  
ATOM    156  N   GLY    27       7.380  63.800   8.214  1.00 17.65      A    N  
ATOM    157  CA  GLY    27       8.239  64.358   7.159  1.00 18.53      A    C  
ATOM    158  C   GLY    27       9.727  64.060   7.277  1.00 18.76      A    C  
ATOM    159  O   GLY    27      10.549  64.617   6.533  1.00 19.47      A    O  
ATOM    160  N   HIS    28      10.090  63.180   8.203  1.00 17.87      A    N  
ATOM    161  CA  HIS    28      11.503  62.880   8.442  1.00 17.67      A    C  
ATOM    162  CB  HIS    28      11.738  62.632   9.932  1.00 17.58      A    C  
ATOM    163  CG  HIS    28      11.363  63.797  10.788  1.00 19.97      A    C  
ATOM    164  ND1 HIS    28      12.159  64.917  10.907  1.00 21.82      A    N  
ATOM    165  CE1 HIS    28      11.565  65.792  11.698  1.00 22.25      A    C  
ATOM    166  NE2 HIS    28      10.411  65.282  12.092  1.00 23.06      A    N  
ATOM    167  CD2 HIS    28      10.257  64.038  11.533  1.00 19.91      A    C  
ATOM    168  C   HIS    28      11.987  61.688   7.643  1.00 16.83      A    C  
ATOM    169  O   HIS    28      11.272  60.712   7.498  1.00 17.40      A    O  
ATOM    170  N   GLU    29      13.212  61.773   7.130  1.00 15.93      A    N  
ATOM    171  CA  GLU    29      13.850  60.630   6.492  1.00 15.15      A    C  
ATOM    172  CB  GLU    29      15.151  61.067   5.819  1.00 14.89      A    C  
ATOM    173  CG  GLU    29      16.082  59.945   5.429  1.00 16.89      A    C  
ATOM    174  CD  GLU    29      17.484  60.441   5.095  1.00 19.01      A    C  
ATOM    175  OE1 GLU    29      17.990  61.372   5.763  1.00 19.10      A    O  
ATOM    176  OE2 GLU    29      18.076  59.895   4.146  1.00 22.56      A    O  
ATOM    177  C   GLU    29      14.141  59.630   7.600  1.00 13.93      A    C  
ATOM    178  O   GLU    29      14.684  60.003   8.626  1.00 13.78      A    O  
ATOM    179  N   VAL    30      13.751  58.379   7.396  1.00 14.02      A    N  
ATOM    180  CA  VAL    30      13.918  57.353   8.423  1.00 13.80      A    C  
ATOM    181  CB  VAL    30      12.555  56.933   9.059  1.00 13.96      A    C  
ATOM    182  CG1 VAL    30      12.774  55.824  10.061  1.00 15.38      A    C  
ATOM    183  CG2 VAL    30      11.896  58.121   9.750  1.00 13.74      A    C  
ATOM    184  C   VAL    30      14.603  56.112   7.866  1.00 13.21      A    C  
ATOM    185  O   VAL    30      14.210  55.588   6.819  1.00 13.14      A    O  
ATOM    186  N   LEU    31      15.638  55.652   8.564  1.00 12.24      A    N  
ATOM    187  CA  LEU    31      16.211  54.336   8.290  1.00 11.94      A    C  
ATOM    188  CB  LEU    31      17.712  54.442   8.031  1.00 12.23      A    C  
ATOM    189  CG  LEU    31      18.406  53.094   7.757  1.00 13.44      A    C  
ATOM    190  CD1 LEU    31      17.915  52.455   6.462  1.00 14.49      A    C  
ATOM    191  CD2 LEU    31      19.935  53.264   7.747  1.00 15.66      A    C  
ATOM    192  C   LEU    31      15.982  53.457   9.513  1.00 11.02      A    C  
ATOM    193  O   LEU    31      16.349  53.834  10.607  1.00 11.03      A    O  
ATOM    194  N   VAL    32      15.350  52.309   9.321  1.00 10.82      A    N  
ATOM    195  CA  VAL    32      15.185  51.346  10.408  1.00 10.63      A    C  
ATOM    196  CB  VAL    32      13.792  50.708  10.395  1.00 11.15      A    C  
ATOM    197  CG1 VAL    32      13.662  49.752  11.568  1.00 11.21      A    C  
ATOM    198  CG2 VAL    32      12.716  51.788  10.455  1.00 11.23      A    C  
ATOM    199  C   VAL    32      16.201  50.221  10.253  1.00 10.43      A    C  
ATOM    200  O   VAL    32      16.208  49.525   9.238  1.00 10.08      A    O  
ATOM    201  N   ALA    33      17.040  50.034  11.267  1.00  9.72      A    N  
ATOM    202  CA  ALA    33      18.043  48.965  11.245  1.00  9.59      A    C  
ATOM    203  CB  ALA    33      19.388  49.493  11.716  1.00  9.71      A    C  
ATOM    204  C   ALA    33      17.588  47.814  12.139  1.00  9.51      A    C  
ATOM    205  O   ALA    33      17.351  48.005  13.321  1.00  9.72      A    O  
ATOM    206  N   GLU    34      17.486  46.627  11.555  1.00  9.06      A    N  
ATOM    207  CA  GLU    34      17.053  45.430  12.279  1.00  9.62      A    C  
ATOM    208  CB  GLU    34      15.703  44.965  11.711  1.00  9.26      A    C  
ATOM    209  CG  GLU    34      15.284  43.565  12.117  1.00 10.47      A    C  
ATOM    210  CD  GLU    34      15.182  43.388  13.624  1.00 10.26      A    C  
ATOM    211  OE1 GLU    34      14.447  44.153  14.296  1.00 10.24      A    O  
ATOM    212  OE2 GLU    34      15.829  42.465  14.149  1.00 11.78      A    O  
ATOM    213  C   GLU    34      18.117  44.334  12.166  1.00  9.66      A    C  
ATOM    214  O   GLU    34      18.593  44.042  11.074  1.00  9.88      A    O  
ATOM    215  N   ALA    35      18.485  43.738  13.296  1.00 10.29      A    N  
ATOM    216  CA  ALA    35      19.537  42.707  13.337  1.00 11.68      A    C  
ATOM    217  CB  ALA    35      19.993  42.478  14.780  1.00 10.93      A    C  
ATOM    218  C   ALA    35      19.102  41.395  12.694  1.00 12.64      A    C  
ATOM    219  O   ALA    35      19.916  40.686  12.076  1.00 12.39      A    O  
ATOM    220  N   ALA    36      17.819  41.066  12.838  1.00 13.65      A    N  
ATOM    221  CA  ALA    36      17.259  39.828  12.264  1.00 15.76      A    C  
ATOM    222  CB  ALA    36      15.907  39.496  12.917  1.00 15.54      A    C  
ATOM    223  C   ALA    36      17.099  39.912  10.748  1.00 17.64      A    C  
ATOM    224  O   ALA    36      17.257  40.973  10.168  1.00 16.16      A    O  
ATOM    225  N   GLU    37      16.740  38.789  10.120  1.00 21.32      A    N  
ATOM    226  CA  GLU    37      16.543  38.737   8.662  1.00 25.10      A    C  
ATOM    227  CB  GLU    37      16.706  37.291   8.155  1.00 25.58      A    C  
ATOM    228  CG  GLU    37      18.139  36.772   8.251  1.00 28.03      A    C  
ATOM    229  CD  GLU    37      19.061  37.370   7.182  1.00 31.75      A    C  
ATOM    230  OE1 GLU    37      18.559  38.078   6.282  1.00 34.60      A    O  
ATOM    231  OE2 GLU    37      20.285  37.133   7.239  1.00 33.38      A    O  
ATOM    232  C   GLU    37      15.234  39.372   8.138  1.00 27.36      A    C  
ATOM    233  O   GLU    37      15.129  39.691   6.946  1.00 27.94      A    O  
ATOM    234  N   GLY    38      14.247  39.567   9.012  1.00 29.61      A    N  
ATOM    235  CA  GLY    38      13.013  40.275   8.631  1.00 32.31      A    C  
ATOM    236  C   GLY    38      12.423  41.152   9.732  1.00 34.12      A    C  
ATOM    237  O   GLY    38      13.052  41.363  10.775  1.00 34.47      A    O  
ATOM    238  N   ILE    39      11.209  41.664   9.516  1.00 35.49      A    N  
ATOM    239  CA  ILE    39      10.524  42.431  10.563  1.00 36.78      A    C  
ATOM    240  CB  ILE    39       9.467  43.442  10.014  1.00 36.73      A    C  
ATOM    241  CG1 ILE    39       8.369  42.722   9.231  1.00 37.04      A    C  
ATOM    242  CD1 ILE    39       7.213  43.626   8.867  1.00 37.54      A    C  
ATOM    243  CG2 ILE    39      10.108  44.550   9.176  1.00 37.15      A    C  
ATOM    244  C   ILE    39       9.801  41.492  11.518  1.00 37.50      A    C  
ATOM    245  O   ILE    39       9.383  40.394  11.129  1.00 37.79      A    O  
ATOM    246  N   GLY    40       9.663  41.931  12.769  1.00 38.27      A    N  
ATOM    247  CA  GLY    40       8.746  41.302  13.719  1.00 38.99      A    C  
ATOM    248  C   GLY    40       9.009  39.844  14.042  1.00 39.46      A    C  
ATOM    249  O   GLY    40       8.075  39.071  14.270  1.00 39.75      A    O  
ATOM    250  N   THR    41      10.280  39.465  14.078  1.00 39.76      A    N  
ATOM    251  CA  THR    41      10.646  38.101  14.442  1.00 40.02      A    C  
ATOM    252  CB  THR    41      11.921  37.625  13.691  1.00 40.19      A    C  
ATOM    253  OG1 THR    41      13.008  38.527  13.944  1.00 40.65      A    O  
ATOM    254  CG2 THR    41      11.668  37.549  12.190  1.00 40.45      A    C  
ATOM    255  C   THR    41      10.842  37.957  15.957  1.00 39.91      A    C  
ATOM    256  O   THR    41      10.828  36.844  16.491  1.00 40.18      A    O  
ATOM    257  N   GLY    42      11.005  39.086  16.642  1.00 39.45      A    N  
ATOM    258  CA  GLY    42      11.349  39.084  18.060  1.00 39.18      A    C  
ATOM    259  C   GLY    42      10.189  38.908  19.023  1.00 38.90      A    C  
ATOM    260  O   GLY    42       9.378  37.998  18.874  1.00 38.88      A    O  
ATOM    261  N   THR    43      10.113  39.784  20.020  1.00 38.61      A    N  
ATOM    262  CA  THR    43       9.056  39.694  21.025  1.00 38.22      A    C  
ATOM    263  CB  THR    43       9.366  40.552  22.261  1.00 38.49      A    C  
ATOM    264  OG1 THR    43      10.627  40.151  22.808  1.00 38.92      A    O  
ATOM    265  CG2 THR    43       8.276  40.392  23.324  1.00 38.36      A    C  
ATOM    266  C   THR    43       7.712  40.111  20.454  1.00 37.63      A    C  
ATOM    267  O   THR    43       6.685  40.041  21.140  1.00 37.79      A    O  
ATOM    268  N   SER    44       7.730  40.550  19.199  1.00 36.71      A    N  
ATOM    269  CA  SER    44       6.498  40.889  18.488  1.00 35.10      A    C  
ATOM    270  CB  SER    44       6.731  42.056  17.524  1.00 35.16      A    C  
ATOM    271  OG  SER    44       7.150  43.214  18.225  1.00 27.29      A    O  
ATOM    272  C   SER    44       5.930  39.685  17.746  1.00 35.80      A    C  
ATOM    273  O   SER    44       4.904  39.792  17.070  1.00 36.07      A    O  
ATOM    274  N   SER    45       6.594  38.537  17.879  1.00 35.56      A    N  
ATOM    275  CA  SER    45       6.102  37.300  17.270  1.00 35.56      A    C  
ATOM    276  CB  SER    45       7.049  36.835  16.158  1.00 35.80      A    C  
ATOM    277  OG  SER    45       8.348  36.576  16.666  1.00 37.39      A    O  
ATOM    278  C   SER    45       5.905  36.197  18.314  1.00 35.04      A    C  
ATOM    279  O   SER    45       5.666  35.030  17.980  1.00 35.06      A    O  
ATOM    280  N   ARG    46       6.002  36.576  19.585  1.00 34.21      A    N  
ATOM    281  CA  ARG    46       5.930  35.604  20.671  1.00 33.05      A    C  
ATOM    282  CB  ARG    46       7.337  35.261  21.164  1.00 33.02      A    C  
ATOM    283  CG  ARG    46       8.279  34.710  20.077  1.00 33.79      A    C  
ATOM    284  CD  ARG    46       9.714  34.607  20.592  1.00 33.38      A    C  
ATOM    285  NE  ARG    46      10.592  33.854  19.694  1.00 33.18      A    N  
ATOM    286  CZ  ARG    46      10.528  32.538  19.512  1.00 32.21      A    C  
ATOM    287  NH1 ARG    46       9.608  31.816  20.140  1.00 29.99      A    N  
ATOM    288  NH2 ARG    46      11.376  31.945  18.678  1.00 32.48      A    N  
ATOM    289  C   ARG    46       5.062  36.126  21.822  1.00 32.25      A    C  
ATOM    290  O   ARG    46       5.469  36.100  22.979  1.00 31.54      A    O  
ATOM    291  N   ASN    47       3.861  36.601  21.490  1.00 31.32      A    N  
ATOM    292  CA  ASN    47       2.918  37.090  22.497  1.00 29.78      A    C  
ATOM    293  CB  ASN    47       2.924  38.641  22.557  1.00 30.79      A    C  
ATOM    294  CG  ASN    47       2.389  39.297  21.283  1.00 32.17      A    C  
ATOM    295  OD1 ASN    47       3.152  39.631  20.366  1.00 36.00      A    O  
ATOM    296  ND2 ASN    47       1.077  39.465  21.213  1.00 33.08      A    N  
ATOM    297  C   ASN    47       1.509  36.517  22.264  1.00 28.90      A    C  
ATOM    298  O   ASN    47       1.308  35.725  21.326  1.00 28.04      A    O  
ATOM    299  N   SER    48       0.549  36.905  23.115  1.00 27.12      A    N  
ATOM    300  CA  SER    48      -0.833  36.384  23.042  1.00 25.17      A    C  
ATOM    301  CB  SER    48      -1.567  36.576  24.377  1.00 25.29      A    C  
ATOM    302  OG  SER    48      -0.702  36.976  25.409  1.00 24.10      A    O  
ATOM    303  C   SER    48      -1.642  37.094  21.956  1.00 23.84      A    C  
ATOM    304  O   SER    48      -2.697  36.612  21.513  1.00 24.97      A    O  
ATOM    305  N   GLU    49      -1.155  38.258  21.547  1.00 20.63      A    N  
ATOM    306  CA  GLU    49      -1.794  39.025  20.517  1.00 16.82      A    C  
ATOM    307  CB  GLU    49      -2.003  38.175  19.271  1.00 16.62      A    C  
ATOM    308  CG  GLU    49      -0.705  37.888  18.511  1.00 22.04      A    C  
ATOM    309  CD  GLU    49      -0.908  36.953  17.316  1.00 26.81      A    C  
ATOM    310  OE1 GLU    49      -1.726  36.017  17.441  1.00 28.52      A    O  
ATOM    311  OE2 GLU    49      -0.254  37.164  16.263  1.00 27.42      A    O  
ATOM    312  C   GLU    49      -3.114  39.565  21.036  1.00 13.38      A    C  
ATOM    313  O   GLU    49      -4.050  39.731  20.274  1.00 12.75      A    O  
ATOM    314  N   VAL    50      -3.167  39.840  22.335  1.00 10.42      A    N  
ATOM    315  CA  VAL    50      -4.378  40.409  22.941  1.00  8.31      A    C  
ATOM    316  CB  VAL    50      -4.558  39.926  24.400  1.00  8.28      A    C  
ATOM    317  CG1 VAL    50      -5.753  40.589  25.055  1.00  8.43      A    C  
ATOM    318  CG2 VAL    50      -4.737  38.411  24.448  1.00  7.04      A    C  
ATOM    319  C   VAL    50      -4.383  41.937  22.890  1.00  8.10      A    C  
ATOM    320  O   VAL    50      -3.400  42.596  23.240  1.00  7.33      A    O  
ATOM    321  N   ILE    51      -5.504  42.502  22.439  1.00  7.64      A    N  
ATOM    322  CA  ILE    51      -5.712  43.948  22.519  1.00  6.60      A    C  
ATOM    323  CB  ILE    51      -6.682  44.451  21.428  1.00  7.25      A    C  
ATOM    324  CG1 ILE    51      -6.131  44.141  20.020  1.00  6.76      A    C  
ATOM    325  CD1 ILE    51      -7.089  44.499  18.857  1.00 10.48      A    C  
ATOM    326  CG2 ILE    51      -6.880  45.976  21.583  1.00  6.93      A    C  
ATOM    327  C   ILE    51      -6.311  44.196  23.907  1.00  7.08      A    C  
ATOM    328  O   ILE    51      -7.489  43.905  24.157  1.00  7.14      A    O  
ATOM    329  N   HIS    52      -5.487  44.704  24.817  1.00  6.56      A    N  
ATOM    330  CA  HIS    52      -5.903  44.856  26.214  1.00  7.08      A    C  
ATOM    331  CB  HIS    52      -4.669  44.922  27.115  1.00  7.43      A    C  
ATOM    332  CG  HIS    52      -4.032  43.589  27.330  1.00  7.92      A    C  
ATOM    333  ND1 HIS    52      -4.608  42.624  28.125  1.00  9.54      A    N  
ATOM    334  CE1 HIS    52      -3.831  41.553  28.146  1.00  9.18      A    C  
ATOM    335  NE2 HIS    52      -2.778  41.786  27.379  1.00  7.63      A    N  
ATOM    336  CD2 HIS    52      -2.876  43.056  26.863  1.00 10.24      A    C  
ATOM    337  C   HIS    52      -6.789  46.076  26.439  1.00  7.45      A    C  
ATOM    338  O   HIS    52      -6.610  47.118  25.810  1.00  8.19      A    O  
ATOM    339  N   ALA    53      -7.735  45.928  27.364  1.00  7.73      A    N  
ATOM    340  CA  ALA    53      -8.663  47.015  27.686  1.00  7.27      A    C  
ATOM    341  CB  ALA    53      -9.899  46.476  28.408  1.00  7.32      A    C  
ATOM    342  C   ALA    53      -8.033  48.173  28.476  1.00  7.41      A    C  
ATOM    343  O   ALA    53      -8.426  49.313  28.268  1.00  7.13      A    O  
ATOM    344  N   GLY    54      -7.075  47.876  29.361  1.00  7.59      A    N  
ATOM    345  CA  GLY    54      -6.435  48.884  30.232  1.00  7.25      A    C  
ATOM    346  C   GLY    54      -6.926  48.780  31.676  1.00  7.60      A    C  
ATOM    347  O   GLY    54      -7.012  49.777  32.400  1.00  7.73      A    O  
ATOM    348  N   ILE    55      -7.203  47.555  32.105  1.00  7.33      A    N  
ATOM    349  CA  ILE    55      -7.931  47.305  33.337  1.00  8.04      A    C  
ATOM    350  CB  ILE    55      -8.519  45.865  33.313  1.00  7.29      A    C  
ATOM    351  CG1 ILE    55      -9.633  45.786  32.256  1.00  7.56      A    C  
ATOM    352  CD1 ILE    55     -10.121  44.377  31.956  1.00  7.54      A    C  
ATOM    353  CG2 ILE    55      -9.027  45.417  34.712  1.00  7.10      A    C  
ATOM    354  C   ILE    55      -7.106  47.531  34.608  1.00  8.84      A    C  
ATOM    355  O   ILE    55      -7.498  48.309  35.478  1.00 10.00      A    O  
ATOM    356  N   TYR    56      -5.962  46.861  34.741  1.00  8.60      A    N  
ATOM    357  CA  TYR    56      -5.373  46.812  36.077  1.00  9.77      A    C  
ATOM    358  CB  TYR    56      -5.237  45.357  36.541  1.00 10.58      A    C  
ATOM    359  CG  TYR    56      -5.254  45.189  38.057  1.00 11.81      A    C  
ATOM    360  CD1 TYR    56      -6.344  45.630  38.814  1.00 14.23      A    C  
ATOM    361  CE1 TYR    56      -6.365  45.504  40.192  1.00 14.92      A    C  
ATOM    362  CZ  TYR    56      -5.289  44.904  40.837  1.00 16.04      A    C  
ATOM    363  OH  TYR    56      -5.311  44.764  42.206  1.00 17.65      A    O  
ATOM    364  CE2 TYR    56      -4.201  44.442  40.110  1.00 15.78      A    C  
ATOM    365  CD2 TYR    56      -4.188  44.589  38.721  1.00 15.35      A    C  
ATOM    366  C   TYR    56      -4.061  47.572  36.277  1.00  8.88      A    C  
ATOM    367  O   TYR    56      -3.445  47.492  37.345  1.00  9.87      A    O  
ATOM    368  N   TYR    57      -3.624  48.308  35.266  1.00  8.78      A    N  
ATOM    369  CA  TYR    57      -2.401  49.107  35.405  1.00  8.91      A    C  
ATOM    370  CB  TYR    57      -1.951  49.615  34.030  1.00  8.86      A    C  
ATOM    371  CG  TYR    57      -2.024  48.506  32.997  1.00  8.56      A    C  
ATOM    372  CD1 TYR    57      -1.156  47.419  33.063  1.00  9.52      A    C  
ATOM    373  CE1 TYR    57      -1.227  46.398  32.155  1.00 10.07      A    C  
ATOM    374  CZ  TYR    57      -2.189  46.421  31.165  1.00 11.26      A    C  
ATOM    375  OH  TYR    57      -2.252  45.384  30.268  1.00 11.50      A    O  
ATOM    376  CE2 TYR    57      -3.067  47.473  31.072  1.00  9.78      A    C  
ATOM    377  CD2 TYR    57      -2.993  48.509  32.010  1.00  8.62      A    C  
ATOM    378  C   TYR    57      -2.623  50.258  36.385  1.00  9.94      A    C  
ATOM    379  O   TYR    57      -3.727  50.794  36.484  1.00 10.15      A    O  
ATOM    380  N   PRO    58      -1.570  50.640  37.121  1.00 10.87      A    N  
ATOM    381  CA  PRO    58      -1.763  51.662  38.139  1.00 11.03      A    C  
ATOM    382  CB  PRO    58      -0.398  51.719  38.847  1.00 11.42      A    C  
ATOM    383  CG  PRO    58       0.265  50.391  38.549  1.00 12.06      A    C  
ATOM    384  CD  PRO    58      -0.230  50.027  37.174  1.00 10.77      A    C  
ATOM    385  C   PRO    58      -2.124  53.026  37.526  1.00 11.15      A    C  
ATOM    386  O   PRO    58      -1.664  53.374  36.433  1.00 11.25      A    O  
ATOM    387  N   ALA    59      -2.940  53.791  38.235  1.00 11.77      A    N  
ATOM    388  CA  ALA    59      -3.418  55.068  37.707  1.00 11.98      A    C  
ATOM    389  CB  ALA    59      -4.204  55.826  38.771  1.00 11.82      A    C  
ATOM    390  C   ALA    59      -2.287  55.950  37.162  1.00 12.46      A    C  
ATOM    391  O   ALA    59      -1.243  56.110  37.801  1.00 12.86      A    O  
ATOM    392  N   ASP    60      -2.518  56.508  35.975  1.00 12.85      A    N  
ATOM    393  CA  ASP    60      -1.603  57.462  35.342  1.00 13.80      A    C  
ATOM    394  CB  ASP    60      -1.455  58.719  36.198  1.00 14.86      A    C  
ATOM    395  CG  ASP    60      -2.760  59.484  36.335  1.00 18.07      A    C  
ATOM    396  OD1 ASP    60      -3.581  59.464  35.387  1.00 20.90      A    O  
ATOM    397  OD2 ASP    60      -2.964  60.121  37.398  1.00 23.61      A    O  
ATOM    398  C   ASP    60      -0.225  56.918  34.959  1.00 13.27      A    C  
ATOM    399  O   ASP    60       0.628  57.689  34.488  1.00 13.16      A    O  
ATOM    400  N   SER    61      -0.012  55.611  35.146  1.00 12.05      A    N  
ATOM    401  CA  SER    61       1.183  54.962  34.605  1.00 10.82      A    C  
ATOM    402  CB  SER    61       1.258  53.491  35.044  1.00 11.12      A    C  
ATOM    403  OG  SER    61       0.143  52.726  34.564  1.00  8.94      A    O  
ATOM    404  C   SER    61       1.191  55.059  33.087  1.00 10.60      A    C  
ATOM    405  O   SER    61       0.143  55.250  32.457  1.00  9.42      A    O  
ATOM    406  N   LEU    62       2.368  54.912  32.480  1.00  9.61      A    N  
ATOM    407  CA  LEU    62       2.418  54.839  31.024  1.00  9.93      A    C  
ATOM    408  CB  LEU    62       3.853  54.802  30.503  1.00 10.55      A    C  
ATOM    409  CG  LEU    62       4.588  56.137  30.557  1.00 11.66      A    C  
ATOM    410  CD1 LEU    62       5.974  55.960  29.987  1.00 11.95      A    C  
ATOM    411  CD2 LEU    62       3.797  57.185  29.753  1.00 12.15      A    C  
ATOM    412  C   LEU    62       1.660  53.623  30.529  1.00  9.43      A    C  
ATOM    413  O   LEU    62       0.955  53.709  29.526  1.00  8.87      A    O  
ATOM    414  N   LYS    63       1.788  52.494  31.226  1.00  8.82      A    N  
ATOM    415  CA  LYS    63       1.018  51.327  30.853  1.00  8.38      A    C  
ATOM    416  CB  LYS    63       1.293  50.141  31.792  1.00  8.35      A    C  
ATOM    417  CG  LYS    63       2.664  49.466  31.545  1.00  8.97      A    C  
ATOM    418  CD  LYS    63       2.842  48.265  32.505  1.00 11.67      A    C  
ATOM    419  CE  LYS    63       4.199  47.588  32.325  1.00 15.61      A    C  
ATOM    420  NZ  LYS    63       4.418  47.274  30.925  1.00 22.22      A    N  
ATOM    421  C   LYS    63      -0.475  51.667  30.827  1.00  7.93      A    C  
ATOM    422  O   LYS    63      -1.169  51.331  29.887  1.00  7.25      A    O  
ATOM    423  N   ALA    64      -0.977  52.337  31.856  1.00  8.01      A    N  
ATOM    424  CA  ALA    64      -2.415  52.628  31.866  1.00  7.83      A    C  
ATOM    425  CB  ALA    64      -2.823  53.189  33.204  1.00  7.78      A    C  
ATOM    426  C   ALA    64      -2.786  53.594  30.729  1.00  8.03      A    C  
ATOM    427  O   ALA    64      -3.722  53.360  29.968  1.00  7.77      A    O  
ATOM    428  N   ARG    65      -2.067  54.701  30.642  1.00  7.68      A    N  
ATOM    429  CA  ARG    65      -2.438  55.763  29.712  1.00  8.18      A    C  
ATOM    430  CB  ARG    65      -1.611  57.009  29.993  1.00  8.94      A    C  
ATOM    431  CG  ARG    65      -1.873  58.120  29.013  1.00 11.92      A    C  
ATOM    432  CD  ARG    65      -1.428  59.454  29.582  1.00 17.28      A    C  
ATOM    433  NE  ARG    65       0.007  59.690  29.473  1.00 21.96      A    N  
ATOM    434  CZ  ARG    65       0.886  59.562  30.457  1.00 25.98      A    C  
ATOM    435  NH1 ARG    65       0.505  59.150  31.664  1.00 28.44      A    N  
ATOM    436  NH2 ARG    65       2.167  59.836  30.219  1.00 28.46      A    N  
ATOM    437  C   ARG    65      -2.286  55.331  28.260  1.00  7.67      A    C  
ATOM    438  O   ARG    65      -3.163  55.560  27.420  1.00  7.78      A    O  
ATOM    439  N   LEU    66      -1.157  54.696  27.969  1.00  7.04      A    N  
ATOM    440  CA  LEU    66      -0.856  54.285  26.610  1.00  6.40      A    C  
ATOM    441  CB  LEU    66       0.653  54.100  26.422  1.00  6.40      A    C  
ATOM    442  CG  LEU    66       1.497  55.346  26.757  1.00  6.64      A    C  
ATOM    443  CD1 LEU    66       2.959  55.113  26.363  1.00  8.12      A    C  
ATOM    444  CD2 LEU    66       0.965  56.618  26.099  1.00  8.63      A    C  
ATOM    445  C   LEU    66      -1.626  53.032  26.210  1.00  6.58      A    C  
ATOM    446  O   LEU    66      -1.909  52.843  25.034  1.00  6.70      A    O  
ATOM    447  N   CYS    67      -1.986  52.178  27.169  1.00  6.22      A    N  
ATOM    448  CA  CYS    67      -2.799  51.021  26.801  1.00  6.53      A    C  
ATOM    449  CB  CYS    67      -2.938  50.019  27.953  1.00  6.79      A    C  
ATOM    450  SG  CYS    67      -3.829  48.505  27.463  1.00  7.60      A    S  
ATOM    451  C   CYS    67      -4.172  51.491  26.335  1.00  7.50      A    C  
ATOM    452  O   CYS    67      -4.685  51.016  25.323  1.00  6.74      A    O  
ATOM    453  N   VAL    68      -4.757  52.444  27.056  1.00  8.07      A    N  
ATOM    454  CA  VAL    68      -6.140  52.835  26.752  1.00  9.14      A    C  
ATOM    455  CB  VAL    68      -6.800  53.558  27.944  1.00  9.33      A    C  
ATOM    456  CG1 VAL    68      -8.160  54.155  27.542  1.00 11.40      A    C  
ATOM    457  CG2 VAL    68      -6.967  52.597  29.137  1.00  9.68      A    C  
ATOM    458  C   VAL    68      -6.174  53.673  25.474  1.00  9.38      A    C  
ATOM    459  O   VAL    68      -6.969  53.417  24.555  1.00  9.98      A    O  
ATOM    460  N   ARG    69      -5.298  54.655  25.390  1.00  9.31      A    N  
ATOM    461  CA  ARG    69      -5.156  55.434  24.158  1.00  9.28      A    C  
ATOM    462  CB  ARG    69      -4.072  56.484  24.362  1.00  9.91      A    C  
ATOM    463  CG  ARG    69      -3.657  57.204  23.105  1.00 13.50      A    C  
ATOM    464  CD  ARG    69      -4.612  58.275  22.754  1.00 16.88      A    C  
ATOM    465  NE  ARG    69      -4.147  59.054  21.603  1.00 17.05      A    N  
ATOM    466  CZ  ARG    69      -4.958  59.788  20.852  1.00 19.86      A    C  
ATOM    467  NH1 ARG    69      -6.254  59.846  21.154  1.00 20.22      A    N  
ATOM    468  NH2 ARG    69      -4.482  60.465  19.804  1.00 17.58      A    N  
ATOM    469  C   ARG    69      -4.792  54.536  22.970  1.00  8.86      A    C  
ATOM    470  O   ARG    69      -5.351  54.656  21.882  1.00  8.88      A    O  
ATOM    471  N   GLY    70      -3.825  53.644  23.185  1.00  6.96      A    N  
ATOM    472  CA  GLY    70      -3.346  52.752  22.137  1.00  6.63      A    C  
ATOM    473  C   GLY    70      -4.444  51.845  21.631  1.00  6.86      A    C  
ATOM    474  O   GLY    70      -4.516  51.578  20.426  1.00  6.60      A    O  
ATOM    475  N   LYS    71      -5.287  51.355  22.550  1.00  6.80      A    N  
ATOM    476  CA  LYS    71      -6.410  50.489  22.187  1.00  7.04      A    C  
ATOM    477  CB  LYS    71      -7.204  50.086  23.441  1.00  7.45      A    C  
ATOM    478  CG  LYS    71      -8.485  49.291  23.146  1.00  8.10      A    C  
ATOM    479  CD  LYS    71      -9.225  48.959  24.463  1.00  9.88      A    C  
ATOM    480  CE  LYS    71      -9.950  50.190  25.052  1.00 10.93      A    C  
ATOM    481  NZ  LYS    71     -10.581  49.920  26.392  1.00 10.98      A    N  
ATOM    482  C   LYS    71      -7.337  51.212  21.221  1.00  7.19      A    C  
ATOM    483  O   LYS    71      -7.713  50.679  20.193  1.00  7.76      A    O  
ATOM    484  N   HIS    72      -7.697  52.436  21.561  1.00  7.71      A    N  
ATOM    485  CA  HIS    72      -8.559  53.212  20.675  1.00  8.31      A    C  
ATOM    486  CB  HIS    72      -8.929  54.525  21.356  1.00  9.02      A    C  
ATOM    487  CG  HIS    72      -9.755  54.321  22.590  1.00 11.38      A    C  
ATOM    488  ND1 HIS    72     -10.778  53.395  22.649  1.00 15.33      A    N  
ATOM    489  CE1 HIS    72     -11.328  53.430  23.849  1.00 15.31      A    C  
ATOM    490  NE2 HIS    72     -10.690  54.336  24.573  1.00 16.23      A    N  
ATOM    491  CD2 HIS    72      -9.711  54.914  23.805  1.00 14.76      A    C  
ATOM    492  C   HIS    72      -7.909  53.442  19.307  1.00  7.82      A    C  
ATOM    493  O   HIS    72      -8.525  53.210  18.269  1.00  8.41      A    O  
ATOM    494  N   LEU    73      -6.662  53.880  19.303  1.00  8.35      A    N  
ATOM    495  CA  LEU    73      -5.962  54.085  18.038  1.00  8.19      A    C  
ATOM    496  CB  LEU    73      -4.558  54.631  18.286  1.00  8.54      A    C  
ATOM    497  CG  LEU    73      -4.514  56.027  18.872  1.00  9.09      A    C  
ATOM    498  CD1 LEU    73      -3.078  56.401  19.189  1.00  9.03      A    C  
ATOM    499  CD2 LEU    73      -5.127  57.016  17.846  1.00 12.63      A    C  
ATOM    500  C   LEU    73      -5.873  52.797  17.231  1.00  8.07      A    C  
ATOM    501  O   LEU    73      -6.002  52.823  16.005  1.00  8.49      A    O  
ATOM    502  N   LEU    74      -5.630  51.673  17.912  1.00  7.61      A    N  
ATOM    503  CA  LEU    74      -5.379  50.408  17.221  1.00  7.20      A    C  
ATOM    504  CB  LEU    74      -4.742  49.391  18.193  1.00  7.34      A    C  
ATOM    505  CG  LEU    74      -4.428  48.008  17.635  1.00  7.42      A    C  
ATOM    506  CD1 LEU    74      -3.462  48.134  16.483  1.00  8.05      A    C  
ATOM    507  CD2 LEU    74      -3.859  47.098  18.756  1.00  7.72      A    C  
ATOM    508  C   LEU    74      -6.677  49.840  16.622  1.00  7.35      A    C  
ATOM    509  O   LEU    74      -6.686  49.339  15.503  1.00  7.49      A    O  
ATOM    510  N   TYR    75      -7.785  49.914  17.360  1.00  7.06      A    N  
ATOM    511  CA  TYR    75      -9.043  49.410  16.805  1.00  7.41      A    C  
ATOM    512  CB  TYR    75     -10.165  49.489  17.844  1.00  7.37      A    C  
ATOM    513  CG  TYR    75     -10.304  48.244  18.673  1.00  7.53      A    C  
ATOM    514  CD1 TYR    75     -10.485  47.002  18.068  1.00  8.31      A    C  
ATOM    515  CE1 TYR    75     -10.617  45.851  18.832  1.00  8.00      A    C  
ATOM    516  CZ  TYR    75     -10.585  45.945  20.213  1.00  7.54      A    C  
ATOM    517  OH  TYR    75     -10.723  44.817  20.970  1.00  9.44      A    O  
ATOM    518  CE2 TYR    75     -10.406  47.172  20.830  1.00  6.93      A    C  
ATOM    519  CD2 TYR    75     -10.262  48.302  20.059  1.00  6.95      A    C  
ATOM    520  C   TYR    75      -9.418  50.220  15.567  1.00  7.93      A    C  
ATOM    521  O   TYR    75      -9.854  49.670  14.558  1.00  8.51      A    O  
ATOM    522  N   GLU    76      -9.219  51.529  15.648  1.00  8.56      A    N  
ATOM    523  CA  GLU    76      -9.482  52.387  14.496  1.00  9.57      A    C  
ATOM    524  CB  GLU    76      -9.352  53.849  14.892  1.00 10.16      A    C  
ATOM    525  CG  GLU    76      -9.505  54.835  13.749  1.00 11.30      A    C  
ATOM    526  CD  GLU    76      -9.489  56.253  14.271  1.00 14.87      A    C  
ATOM    527  OE1 GLU    76      -8.435  56.654  14.801  1.00 17.31      A    O  
ATOM    528  OE2 GLU    76     -10.522  56.955  14.177  1.00 14.89      A    O  
ATOM    529  C   GLU    76      -8.549  52.039  13.324  1.00  9.62      A    C  
ATOM    530  O   GLU    76      -8.989  51.897  12.185  1.00  9.61      A    O  
ATOM    531  N   TYR    77      -7.254  51.884  13.622  1.00  9.34      A    N  
ATOM    532  CA  TYR    77      -6.245  51.540  12.617  1.00  9.97      A    C  
ATOM    533  CB  TYR    77      -4.843  51.445  13.269  1.00  9.16      A    C  
ATOM    534  CG  TYR    77      -3.741  51.179  12.267  1.00  9.29      A    C  
ATOM    535  CD1 TYR    77      -3.079  52.228  11.645  1.00 12.12      A    C  
ATOM    536  CE1 TYR    77      -2.077  51.991  10.716  1.00 12.93      A    C  
ATOM    537  CZ  TYR    77      -1.740  50.692  10.413  1.00 12.43      A    C  
ATOM    538  OH  TYR    77      -0.748  50.415   9.491  1.00 13.90      A    O  
ATOM    539  CE2 TYR    77      -2.390  49.645  11.012  1.00 12.32      A    C  
ATOM    540  CD2 TYR    77      -3.382  49.893  11.940  1.00 11.30      A    C  
ATOM    541  C   TYR    77      -6.588  50.227  11.932  1.00 10.77      A    C  
ATOM    542  O   TYR    77      -6.526  50.118  10.713  1.00 11.12      A    O  
ATOM    543  N   CYS    78      -6.971  49.224  12.714  1.00 11.11      A    N  
ATOM    544  CA  CYS    78      -7.256  47.917  12.148  1.00 12.12      A    C  
ATOM    545  CB  CYS    78      -7.457  46.883  13.238  1.00 12.01      A    C  
ATOM    546  SG  CYS    78      -5.887  46.440  14.033  1.00 12.83      A    S  
ATOM    547  C   CYS    78      -8.461  47.969  11.218  1.00 12.71      A    C  
ATOM    548  O   CYS    78      -8.450  47.364  10.154  1.00 13.65      A    O  
ATOM    549  N   ALA    79      -9.493  48.696  11.619  1.00 13.19      A    N  
ATOM    550  CA  ALA    79     -10.673  48.839  10.770  1.00 14.27      A    C  
ATOM    551  CB  ALA    79     -11.831  49.481  11.538  1.00 14.37      A    C  
ATOM    552  C   ALA    79     -10.336  49.651   9.517  1.00 14.88      A    C  
ATOM    553  O   ALA    79     -10.793  49.332   8.413  1.00 16.04      A    O  
ATOM    554  N   ALA    80      -9.535  50.694   9.683  1.00 15.58      A    N  
ATOM    555  CA  ALA    80      -9.218  51.596   8.580  1.00 16.51      A    C  
ATOM    556  CB  ALA    80      -8.522  52.842   9.096  1.00 16.50      A    C  
ATOM    557  C   ALA    80      -8.359  50.908   7.528  1.00 17.40      A    C  
ATOM    558  O   ALA    80      -8.511  51.158   6.324  1.00 17.37      A    O  
ATOM    559  N   ARG    81      -7.473  50.019   7.978  1.00 17.86      A    N  
ATOM    560  CA  ARG    81      -6.459  49.440   7.105  1.00 18.60      A    C  
ATOM    561  CB  ARG    81      -5.071  49.521   7.750  1.00 18.91      A    C  
ATOM    562  CG  ARG    81      -4.677  50.897   8.239  1.00 21.65      A    C  
ATOM    563  CD  ARG    81      -4.958  51.991   7.242  1.00 28.32      A    C  
ATOM    564  NE  ARG    81      -4.214  53.181   7.637  1.00 31.43      A    N  
ATOM    565  CZ  ARG    81      -2.958  53.413   7.270  1.00 32.72      A    C  
ATOM    566  NH1 ARG    81      -2.340  52.543   6.478  1.00 34.15      A    N  
ATOM    567  NH2 ARG    81      -2.329  54.509   7.685  1.00 32.17      A    N  
ATOM    568  C   ARG    81      -6.736  47.997   6.758  1.00 18.28      A    C  
ATOM    569  O   ARG    81      -6.026  47.422   5.933  1.00 19.97      A    O  
ATOM    570  N   GLY    82      -7.733  47.391   7.401  1.00 16.96      A    N  
ATOM    571  CA  GLY    82      -8.090  46.009   7.102  1.00 15.99      A    C  
ATOM    572  C   GLY    82      -7.157  44.976   7.705  1.00 15.51      A    C  
ATOM    573  O   GLY    82      -6.957  43.901   7.128  1.00 15.97      A    O  
ATOM    574  N   VAL    83      -6.578  45.293   8.863  1.00 14.33      A    N  
ATOM    575  CA  VAL    83      -5.756  44.326   9.604  1.00 13.75      A    C  
ATOM    576  CB  VAL    83      -4.874  45.009  10.675  1.00 13.17      A    C  
ATOM    577  CG1 VAL    83      -4.049  43.961  11.402  1.00 12.94      A    C  
ATOM    578  CG2 VAL    83      -3.988  46.093  10.074  1.00 13.13      A    C  
ATOM    579  C   VAL    83      -6.678  43.371  10.340  1.00 13.66      A    C  
ATOM    580  O   VAL    83      -7.575  43.813  11.072  1.00 13.98      A    O  
ATOM    581  N   PRO    84      -6.477  42.061  10.158  1.00 13.63      A    N  
ATOM    582  CA  PRO    84      -7.341  41.084  10.834  1.00 13.76      A    C  
ATOM    583  CB  PRO    84      -6.753  39.730  10.398  1.00 14.02      A    C  
ATOM    584  CG  PRO    84      -6.072  40.025   9.089  1.00 14.50      A    C  
ATOM    585  CD  PRO    84      -5.524  41.421   9.228  1.00 14.23      A    C  
ATOM    586  C   PRO    84      -7.322  41.236  12.372  1.00 13.22      A    C  
ATOM    587  O   PRO    84      -6.259  41.271  13.008  1.00 12.96      A    O  
ATOM    588  N   HIS    85      -8.508  41.339  12.953  1.00 12.91      A    N  
ATOM    589  CA  HIS    85      -8.643  41.461  14.404  1.00 12.37      A    C  
ATOM    590  CB  HIS    85      -8.352  42.893  14.842  1.00 12.88      A    C  
ATOM    591  CG  HIS    85      -9.386  43.869  14.385  1.00 13.86      A    C  
ATOM    592  ND1 HIS    85      -9.571  44.175  13.056  1.00 13.97      A    N  
ATOM    593  CE1 HIS    85     -10.551  45.056  12.943  1.00 15.14      A    C  
ATOM    594  NE2 HIS    85     -11.020  45.317  14.151  1.00 14.84      A    N  
ATOM    595  CD2 HIS    85     -10.309  44.585  15.073  1.00 14.88      A    C  
ATOM    596  C   HIS    85     -10.068  41.123  14.780  1.00 12.31      A    C  
ATOM    597  O   HIS    85     -10.965  41.143  13.926  1.00 13.00      A    O  
ATOM    598  N   GLN    86     -10.291  40.837  16.058  1.00 11.53      A    N  
ATOM    599  CA  GLN    86     -11.628  40.510  16.564  1.00 11.67      A    C  
ATOM    600  CB  GLN    86     -11.820  38.994  16.655  1.00 11.93      A    C  
ATOM    601  CG  GLN    86     -11.932  38.285  15.303  1.00 13.88      A    C  
ATOM    602  CD  GLN    86     -11.704  36.774  15.374  1.00 17.56      A    C  
ATOM    603  OE1 GLN    86     -11.899  36.136  16.414  1.00 17.76      A    O  
ATOM    604  NE2 GLN    86     -11.292  36.193  14.239  1.00 19.92      A    N  
ATOM    605  C   GLN    86     -11.823  41.102  17.946  1.00 11.71      A    C  
ATOM    606  O   GLN    86     -11.004  40.885  18.844  1.00 11.32      A    O  
ATOM    607  N   ARG    87     -12.933  41.809  18.136  1.00 11.69      A    N  
ATOM    608  CA  ARG    87     -13.265  42.348  19.462  1.00 11.99      A    C  
ATOM    609  CB  ARG    87     -14.031  43.668  19.309  1.00 12.89      A    C  
ATOM    610  CG  ARG    87     -14.273  44.445  20.605  1.00 14.41      A    C  
ATOM    611  CD  ARG    87     -15.091  45.710  20.314  1.00 20.91      A    C  
ATOM    612  NE  ARG    87     -14.431  46.515  19.294  1.00 25.76      A    N  
ATOM    613  CZ  ARG    87     -14.793  46.590  18.015  1.00 26.20      A    C  
ATOM    614  NH1 ARG    87     -15.862  45.927  17.562  1.00 27.13      A    N  
ATOM    615  NH2 ARG    87     -14.078  47.337  17.184  1.00 25.93      A    N  
ATOM    616  C   ARG    87     -14.096  41.313  20.202  1.00 12.26      A    C  
ATOM    617  O   ARG    87     -15.322  41.471  20.361  1.00 12.43      A    O  
ATOM    618  N   LEU    88     -13.453  40.236  20.648  1.00 10.62      A    N  
ATOM    619  CA  LEU    88     -14.241  39.100  21.116  1.00 11.30      A    C  
ATOM    620  CB  LEU    88     -13.617  37.759  20.741  1.00 12.92      A    C  
ATOM    621  CG  LEU    88     -12.107  37.634  20.707  1.00 16.29      A    C  
ATOM    622  CD1 LEU    88     -11.483  38.125  21.990  1.00 18.49      A    C  
ATOM    623  CD2 LEU    88     -11.729  36.191  20.433  1.00 18.42      A    C  
ATOM    624  C   LEU    88     -14.594  39.127  22.586  1.00  9.68      A    C  
ATOM    625  O   LEU    88     -15.452  38.364  23.027  1.00  9.63      A    O  
ATOM    626  N   GLY    89     -13.950  40.009  23.345  1.00  8.23      A    N  
ATOM    627  CA  GLY    89     -14.279  40.148  24.753  1.00  8.07      A    C  
ATOM    628  C   GLY    89     -13.477  39.183  25.614  1.00  7.92      A    C  
ATOM    629  O   GLY    89     -12.870  38.230  25.114  1.00  7.11      A    O  
ATOM    630  N   LYS    90     -13.508  39.426  26.918  1.00  7.81      A    N  
ATOM    631  CA  LYS    90     -12.735  38.656  27.887  1.00  7.49      A    C  
ATOM    632  CB  LYS    90     -11.427  39.394  28.131  1.00  7.84      A    C  
ATOM    633  CG  LYS    90     -10.691  39.060  29.412  1.00  9.00      A    C  
ATOM    634  CD  LYS    90      -9.432  39.914  29.414  1.00 13.02      A    C  
ATOM    635  CE  LYS    90      -8.967  40.280  30.789  1.00 16.81      A    C  
ATOM    636  NZ  LYS    90      -7.546  40.741  30.725  1.00 15.31      A    N  
ATOM    637  C   LYS    90     -13.507  38.559  29.184  1.00  7.93      A    C  
ATOM    638  O   LYS    90     -14.272  39.470  29.515  1.00  7.95      A    O  
ATOM    639  N   LEU    91     -13.337  37.448  29.903  1.00  7.09      A    N  
ATOM    640  CA  LEU    91     -13.840  37.326  31.272  1.00  7.34      A    C  
ATOM    641  CB  LEU    91     -14.664  36.055  31.441  1.00  8.01      A    C  
ATOM    642  CG  LEU    91     -15.830  35.856  30.473  1.00 12.27      A    C  
ATOM    643  CD1 LEU    91     -16.554  34.549  30.737  1.00 15.66      A    C  
ATOM    644  CD2 LEU    91     -16.777  37.000  30.617  1.00 14.57      A    C  
ATOM    645  C   LEU    91     -12.650  37.235  32.212  1.00  7.37      A    C  
ATOM    646  O   LEU    91     -11.741  36.422  31.976  1.00  6.40      A    O  
ATOM    647  N   ILE    92     -12.639  38.075  33.247  1.00  6.71      A    N  
ATOM    648  CA  ILE    92     -11.746  37.875  34.380  1.00  7.10      A    C  
ATOM    649  CB  ILE    92     -11.371  39.195  35.053  1.00  6.40      A    C  
ATOM    650  CG1 ILE    92     -10.573  40.055  34.080  1.00  8.68      A    C  
ATOM    651  CD1 ILE    92     -10.285  41.480  34.618  1.00  8.17      A    C  
ATOM    652  CG2 ILE    92     -10.529  38.921  36.285  1.00  8.16      A    C  
ATOM    653  C   ILE    92     -12.543  37.035  35.353  1.00  7.55      A    C  
ATOM    654  O   ILE    92     -13.602  37.474  35.808  1.00  7.25      A    O  
ATOM    655  N   VAL    93     -12.060  35.828  35.642  1.00  6.72      A    N  
ATOM    656  CA  VAL    93     -12.872  34.870  36.404  1.00  7.87      A    C  
ATOM    657  CB  VAL    93     -13.009  33.514  35.645  1.00  7.58      A    C  
ATOM    658  CG1 VAL    93     -13.709  33.730  34.311  1.00  8.64      A    C  
ATOM    659  CG2 VAL    93     -11.628  32.870  35.444  1.00  7.96      A    C  
ATOM    660  C   VAL    93     -12.333  34.642  37.802  1.00  8.68      A    C  
ATOM    661  O   VAL    93     -11.124  34.456  37.980  1.00  8.93      A    O  
ATOM    662  N   ALA    94     -13.237  34.689  38.788  1.00  8.80      A    N  
ATOM    663  CA  ALA    94     -12.923  34.353  40.179  1.00  9.50      A    C  
ATOM    664  CB  ALA    94     -13.704  35.269  41.152  1.00  9.26      A    C  
ATOM    665  C   ALA    94     -13.302  32.890  40.411  1.00 10.61      A    C  
ATOM    666  O   ALA    94     -14.404  32.470  40.052  1.00 11.06      A    O  
ATOM    667  N   THR    95     -12.400  32.114  41.003  1.00 11.54      A    N  
ATOM    668  CA  THR    95     -12.683  30.697  41.212  1.00 12.50      A    C  
ATOM    669  CB  THR    95     -11.698  29.798  40.436  1.00 12.97      A    C  
ATOM    670  OG1 THR    95     -10.366  30.087  40.852  1.00 13.56      A    O  
ATOM    671  CG2 THR    95     -11.841  30.043  38.944  1.00 14.34      A    C  
ATOM    672  C   THR    95     -12.754  30.313  42.701  1.00 12.82      A    C  
ATOM    673  O   THR    95     -12.652  29.134  43.063  1.00 13.39      A    O  
ATOM    674  N   SER    96     -12.962  31.318  43.548  1.00 12.55      A    N  
ATOM    675  CA  SER    96     -13.217  31.103  44.967  1.00 12.29      A    C  
ATOM    676  CB  SER    96     -11.906  30.932  45.746  1.00 12.43      A    C  
ATOM    677  OG  SER    96     -11.225  32.172  45.884  1.00 10.79      A    O  
ATOM    678  C   SER    96     -13.987  32.317  45.482  1.00 13.35      A    C  
ATOM    679  O   SER    96     -14.070  33.341  44.799  1.00 13.14      A    O  
ATOM    680  N   ASP    97     -14.578  32.201  46.668  1.00 13.76      A    N  
ATOM    681  CA  ASP    97     -15.234  33.357  47.273  1.00 14.33      A    C  
ATOM    682  CB  ASP    97     -15.897  32.977  48.602  1.00 15.48      A    C  
ATOM    683  CG  ASP    97     -17.086  32.073  48.430  1.00 18.72      A    C  
ATOM    684  OD1 ASP    97     -17.653  31.983  47.316  1.00 20.38      A    O  
ATOM    685  OD2 ASP    97     -17.480  31.454  49.447  1.00 22.82      A    O  
ATOM    686  C   ASP    97     -14.245  34.495  47.533  1.00 13.36      A    C  
ATOM    687  O   ASP    97     -14.590  35.664  47.345  1.00 13.75      A    O  
ATOM    688  N   ALA    98     -13.033  34.171  47.982  1.00 12.77      A    N  
ATOM    689  CA  ALA    98     -12.038  35.218  48.256  1.00 12.41      A    C  
ATOM    690  CB  ALA    98     -10.769  34.619  48.857  1.00 13.38      A    C  
ATOM    691  C   ALA    98     -11.716  35.984  46.972  1.00 11.71      A    C  
ATOM    692  O   ALA    98     -11.676  37.212  46.954  1.00 10.94      A    O  
ATOM    693  N   GLU    99     -11.518  35.254  45.877  1.00 11.04      A    N  
ATOM    694  CA  GLU    99     -11.274  35.910  44.589  1.00 10.61      A    C  
ATOM    695  CB  GLU    99     -10.896  34.877  43.532  1.00 10.42      A    C  
ATOM    696  CG  GLU    99      -9.552  34.251  43.837  1.00 10.44      A    C  
ATOM    697  CD  GLU    99      -9.021  33.408  42.695  1.00 11.98      A    C  
ATOM    698  OE1 GLU    99      -9.779  33.116  41.748  1.00 11.82      A    O  
ATOM    699  OE2 GLU    99      -7.832  33.046  42.759  1.00 14.81      A    O  
ATOM    700  C   GLU    99     -12.462  36.727  44.108  1.00 10.14      A    C  
ATOM    701  O   GLU    99     -12.287  37.799  43.506  1.00  9.42      A    O  
ATOM    702  N   ALA   100     -13.669  36.220  44.353  1.00  9.81      A    N  
ATOM    703  CA  ALA   100     -14.864  36.939  43.928  1.00  9.80      A    C  
ATOM    704  CB  ALA   100     -16.112  36.138  44.236  1.00 10.31      A    C  
ATOM    705  C   ALA   100     -14.913  38.301  44.619  1.00  9.95      A    C  
ATOM    706  O   ALA   100     -15.399  39.279  44.038  1.00  9.60      A    O  
ATOM    707  N   SER   101     -14.411  38.347  45.851  1.00  9.51      A    N  
ATOM    708  CA  SER   101     -14.391  39.583  46.635  1.00 10.70      A    C  
ATOM    709  CB  SER   101     -14.057  39.273  48.093  1.00 11.53      A    C  
ATOM    710  OG  SER   101     -15.161  38.608  48.693  1.00 17.43      A    O  
ATOM    711  C   SER   101     -13.428  40.629  46.090  1.00 10.14      A    C  
ATOM    712  O   SER   101     -13.536  41.822  46.439  1.00 10.35      A    O  
ATOM    713  N   GLN   102     -12.500  40.189  45.241  1.00  8.68      A    N  
ATOM    714  CA  GLN   102     -11.491  41.073  44.649  1.00  7.88      A    C  
ATOM    715  CB  GLN   102     -10.244  40.253  44.285  1.00  7.99      A    C  
ATOM    716  CG  GLN   102      -9.545  39.752  45.539  1.00  9.55      A    C  
ATOM    717  CD  GLN   102      -8.329  38.929  45.250  1.00 12.22      A    C  
ATOM    718  OE1 GLN   102      -8.312  38.164  44.297  1.00 11.23      A    O  
ATOM    719  NE2 GLN   102      -7.296  39.067  46.084  1.00 14.05      A    N  
ATOM    720  C   GLN   102     -12.004  41.836  43.439  1.00  7.47      A    C  
ATOM    721  O   GLN   102     -11.404  42.827  43.019  1.00  7.61      A    O  
ATOM    722  N   LEU   103     -13.133  41.379  42.883  1.00  7.16      A    N  
ATOM    723  CA  LEU   103     -13.582  41.909  41.593  1.00  7.26      A    C  
ATOM    724  CB  LEU   103     -14.694  41.030  41.005  1.00  6.51      A    C  
ATOM    725  CG  LEU   103     -14.328  39.589  40.608  1.00  7.86      A    C  
ATOM    726  CD1 LEU   103     -15.549  38.902  39.995  1.00  7.61      A    C  
ATOM    727  CD2 LEU   103     -13.159  39.544  39.646  1.00  8.32      A    C  
ATOM    728  C   LEU   103     -14.023  43.379  41.668  1.00  7.37      A    C  
ATOM    729  O   LEU   103     -13.803  44.160  40.728  1.00  7.45      A    O  
ATOM    730  N   ASP   104     -14.645  43.770  42.775  1.00  8.24      A    N  
ATOM    731  CA  ASP   104     -15.186  45.132  42.828  1.00  8.79      A    C  
ATOM    732  CB  ASP   104     -15.919  45.389  44.137  1.00  9.63      A    C  
ATOM    733  CG  ASP   104     -17.371  44.900  44.122  1.00 13.58      A    C  
ATOM    734  OD1 ASP   104     -17.931  44.588  43.046  1.00 16.04      A    O  
ATOM    735  OD2 ASP   104     -17.967  44.853  45.217  1.00 16.17      A    O  
ATOM    736  C   ASP   104     -14.042  46.140  42.666  1.00  8.10      A    C  
ATOM    737  O   ASP   104     -14.156  47.117  41.920  1.00  8.37      A    O  
ATOM    738  N   SER   105     -12.935  45.909  43.370  1.00  7.66      A    N  
ATOM    739  CA  SER   105     -11.822  46.866  43.350  1.00  7.70      A    C  
ATOM    740  CB  SER   105     -10.786  46.490  44.418  1.00  8.34      A    C  
ATOM    741  OG  SER   105      -9.675  47.379  44.362  1.00 13.63      A    O  
ATOM    742  C   SER   105     -11.162  46.878  41.977  1.00  7.19      A    C  
ATOM    743  O   SER   105     -10.722  47.915  41.467  1.00  7.04      A    O  
ATOM    744  N   ILE   106     -11.082  45.702  41.368  1.00  6.71      A    N  
ATOM    745  CA  ILE   106     -10.522  45.617  40.020  1.00  6.69      A    C  
ATOM    746  CB  ILE   106     -10.476  44.143  39.556  1.00  6.42      A    C  
ATOM    747  CG1 ILE   106      -9.456  43.362  40.384  1.00  6.41      A    C  
ATOM    748  CD1 ILE   106      -9.572  41.854  40.154  1.00  7.76      A    C  
ATOM    749  CG2 ILE   106     -10.096  44.037  38.076  1.00  7.38      A    C  
ATOM    750  C   ILE   106     -11.352  46.464  39.041  1.00  6.80      A    C  
ATOM    751  O   ILE   106     -10.811  47.213  38.229  1.00  7.18      A    O  
ATOM    752  N   ALA   107     -12.677  46.348  39.115  1.00  7.29      A    N  
ATOM    753  CA  ALA   107     -13.541  47.146  38.238  1.00  7.35      A    C  
ATOM    754  CB  ALA   107     -15.003  46.727  38.393  1.00  8.25      A    C  
ATOM    755  C   ALA   107     -13.392  48.646  38.508  1.00  8.04      A    C  
ATOM    756  O   ALA   107     -13.462  49.456  37.579  1.00  7.76      A    O  
ATOM    757  N   ARG   108     -13.203  49.020  39.767  1.00  7.42      A    N  
ATOM    758  CA  ARG   108     -12.992  50.438  40.090  1.00  7.90      A    C  
ATOM    759  CB  ARG   108     -13.087  50.666  41.605  1.00  8.29      A    C  
ATOM    760  CG  ARG   108     -14.499  50.462  42.121  1.00  9.36      A    C  
ATOM    761  CD  ARG   108     -14.615  50.678  43.605  1.00 15.68      A    C  
ATOM    762  NE  ARG   108     -15.910  50.199  44.077  1.00 20.10      A    N  
ATOM    763  CZ  ARG   108     -16.080  49.241  44.985  1.00 22.84      A    C  
ATOM    764  NH1 ARG   108     -15.032  48.639  45.554  1.00 22.97      A    N  
ATOM    765  NH2 ARG   108     -17.309  48.878  45.326  1.00 23.77      A    N  
ATOM    766  C   ARG   108     -11.668  50.945  39.519  1.00  7.91      A    C  
ATOM    767  O   ARG   108     -11.569  52.084  39.044  1.00  9.07      A    O  
ATOM    768  N   ARG   109     -10.638  50.104  39.542  1.00  7.76      A    N  
ATOM    769  CA  ARG   109      -9.363  50.538  38.958  1.00  8.02      A    C  
ATOM    770  CB  ARG   109      -8.236  49.535  39.225  1.00  7.91      A    C  
ATOM    771  CG  ARG   109      -6.935  50.049  38.675  1.00  7.80      A    C  
ATOM    772  CD  ARG   109      -5.766  49.156  39.053  1.00  7.81      A    C  
ATOM    773  NE  ARG   109      -5.528  49.147  40.493  1.00  9.55      A    N  
ATOM    774  CZ  ARG   109      -4.473  48.561  41.060  1.00 11.61      A    C  
ATOM    775  NH1 ARG   109      -3.556  47.968  40.289  1.00 11.06      A    N  
ATOM    776  NH2 ARG   109      -4.335  48.572  42.383  1.00 10.41      A    N  
ATOM    777  C   ARG   109      -9.514  50.766  37.464  1.00  8.06      A    C  
ATOM    778  O   ARG   109      -9.035  51.774  36.924  1.00  7.99      A    O  
ATOM    779  N   ALA   110     -10.196  49.840  36.796  1.00  8.57      A    N  
ATOM    780  CA  ALA   110     -10.429  49.939  35.355  1.00  8.03      A    C  
ATOM    781  CB  ALA   110     -11.232  48.750  34.872  1.00  8.74      A    C  
ATOM    782  C   ALA   110     -11.189  51.233  35.070  1.00  8.42      A    C  
ATOM    783  O   ALA   110     -10.843  51.970  34.155  1.00  8.72      A    O  
ATOM    784  N   GLY   111     -12.226  51.499  35.849  1.00  8.72      A    N  
ATOM    785  CA  GLY   111     -13.012  52.725  35.640  1.00  9.25      A    C  
ATOM    786  C   GLY   111     -12.139  53.965  35.705  1.00 10.46      A    C  
ATOM    787  O   GLY   111     -12.298  54.901  34.900  1.00 11.07      A    O  
ATOM    788  N   ALA   112     -11.207  53.982  36.647  1.00  9.87      A    N  
ATOM    789  CA  ALA   112     -10.353  55.142  36.839  1.00 10.21      A    C  
ATOM    790  CB  ALA   112      -9.618  55.060  38.163  1.00 10.82      A    C  
ATOM    791  C   ALA   112      -9.377  55.306  35.689  1.00 10.06      A    C  
ATOM    792  O   ALA   112      -8.877  56.405  35.445  1.00 11.14      A    O  
ATOM    793  N   ASN   113      -9.088  54.201  34.993  1.00  9.16      A    N  
ATOM    794  CA  ASN   113      -8.221  54.236  33.813  1.00  8.58      A    C  
ATOM    795  CB  ASN   113      -7.544  52.867  33.610  1.00  8.54      A    C  
ATOM    796  CG  ASN   113      -6.440  52.615  34.610  1.00  8.49      A    C  
ATOM    797  OD1 ASN   113      -5.916  53.557  35.226  1.00 10.25      A    O  
ATOM    798  ND2 ASN   113      -6.090  51.336  34.802  1.00  8.99      A    N  
ATOM    799  C   ASN   113      -8.962  54.614  32.529  1.00  9.31      A    C  
ATOM    800  O   ASN   113      -8.355  54.705  31.436  1.00  8.68      A    O  
ATOM    801  N   GLY   114     -10.267  54.817  32.654  1.00  9.70      A    N  
ATOM    802  CA  GLY   114     -11.121  55.088  31.496  1.00 11.28      A    C  
ATOM    803  C   GLY   114     -11.697  53.858  30.805  1.00 11.74      A    C  
ATOM    804  O   GLY   114     -12.109  53.922  29.638  1.00 13.21      A    O  
ATOM    805  N   VAL   115     -11.737  52.734  31.515  1.00 11.48      A    N  
ATOM    806  CA  VAL   115     -12.386  51.534  31.014  1.00 11.45      A    C  
ATOM    807  CB  VAL   115     -11.535  50.271  31.295  1.00 10.60      A    C  
ATOM    808  CG1 VAL   115     -12.212  49.040  30.711  1.00 12.53      A    C  
ATOM    809  CG2 VAL   115     -10.120  50.450  30.738  1.00 13.32      A    C  
ATOM    810  C   VAL   115     -13.709  51.420  31.746  1.00 12.02      A    C  
ATOM    811  O   VAL   115     -13.766  51.014  32.895  1.00 11.16      A    O  
ATOM    812  N   ASP   116     -14.784  51.832  31.103  1.00 13.59      A    N  
ATOM    813  CA  ASP   116     -15.992  51.963  31.880  1.00 15.54      A    C  
ATOM    814  CB  ASP   116     -16.457  53.432  31.940  1.00 16.87      A    C  
ATOM    815  CG  ASP   116     -15.604  54.279  32.907  1.00 19.81      A    C  
ATOM    816  OD1 ASP   116     -16.016  54.458  34.075  1.00 26.33      A    O  
ATOM    817  OD2 ASP   116     -14.505  54.740  32.527  1.00 21.36      A    O  
ATOM    818  C   ASP   116     -17.075  50.984  31.423  1.00 15.16      A    C  
ATOM    819  O   ASP   116     -18.230  51.092  31.840  1.00 17.09      A    O  
ATOM    820  N   ASP   117     -16.672  49.982  30.643  1.00 12.69      A    N  
ATOM    821  CA  ASP   117     -17.614  48.992  30.133  1.00 11.33      A    C  
ATOM    822  CB  ASP   117     -17.478  48.839  28.616  1.00 11.97      A    C  
ATOM    823  CG  ASP   117     -16.115  48.341  28.197  1.00 13.56      A    C  
ATOM    824  OD1 ASP   117     -15.264  48.117  29.083  1.00 11.65      A    O  
ATOM    825  OD2 ASP   117     -15.912  48.155  26.981  1.00 15.47      A    O  
ATOM    826  C   ASP   117     -17.543  47.618  30.804  1.00 10.19      A    C  
ATOM    827  O   ASP   117     -18.091  46.648  30.269  1.00  9.96      A    O  
ATOM    828  N   LEU   118     -16.887  47.511  31.957  1.00  9.45      A    N  
ATOM    829  CA  LEU   118     -16.838  46.185  32.609  1.00  9.46      A    C  
ATOM    830  CB  LEU   118     -15.809  46.120  33.738  1.00  9.00      A    C  
ATOM    831  CG  LEU   118     -14.355  46.415  33.367  1.00 11.18      A    C  
ATOM    832  CD1 LEU   118     -13.426  45.906  34.467  1.00 11.89      A    C  
ATOM    833  CD2 LEU   118     -13.983  45.779  32.025  1.00 12.04      A    C  
ATOM    834  C   LEU   118     -18.208  45.804  33.146  1.00 10.13      A    C  
ATOM    835  O   LEU   118     -19.002  46.675  33.507  1.00 10.94      A    O  
ATOM    836  N   GLN   119     -18.492  44.506  33.183  1.00  8.74      A    N  
ATOM    837  CA  GLN   119     -19.769  44.023  33.699  1.00  8.51      A    C  
ATOM    838  CB  GLN   119     -20.575  43.355  32.575  1.00  8.34      A    C  
ATOM    839  CG  GLN   119     -20.815  44.275  31.368  1.00 11.21      A    C  
ATOM    840  CD  GLN   119     -21.022  43.542  30.044  1.00 16.69      A    C  
ATOM    841  OE1 GLN   119     -20.068  43.037  29.427  1.00 21.22      A    O  
ATOM    842  NE2 GLN   119     -22.261  43.521  29.578  1.00 19.52      A    N  
ATOM    843  C   GLN   119     -19.476  42.994  34.781  1.00  8.64      A    C  
ATOM    844  O   GLN   119     -18.814  41.996  34.511  1.00  9.81      A    O  
ATOM    845  N   HIS   120     -19.995  43.216  35.983  1.00  8.48      A    N  
ATOM    846  CA  HIS   120     -19.736  42.320  37.103  1.00  8.47      A    C  
ATOM    847  CB  HIS   120     -19.609  43.152  38.379  1.00  8.76      A    C  
ATOM    848  CG  HIS   120     -19.097  42.399  39.565  1.00 10.10      A    C  
ATOM    849  ND1 HIS   120     -18.554  43.039  40.655  1.00 10.85      A    N  
ATOM    850  CE1 HIS   120     -18.200  42.140  41.560  1.00 11.17      A    C  
ATOM    851  NE2 HIS   120     -18.493  40.940  41.091  1.00 12.17      A    N  
ATOM    852  CD2 HIS   120     -19.053  41.074  39.841  1.00 11.02      A    C  
ATOM    853  C   HIS   120     -20.913  41.373  37.203  1.00  8.24      A    C  
ATOM    854  O   HIS   120     -22.040  41.826  37.399  1.00  9.20      A    O  
ATOM    855  N   ILE   121     -20.655  40.073  37.061  1.00  8.14      A    N  
ATOM    856  CA  ILE   121     -21.726  39.069  37.013  1.00  8.68      A    C  
ATOM    857  CB  ILE   121     -22.019  38.603  35.555  1.00  8.35      A    C  
ATOM    858  CG1 ILE   121     -20.833  37.820  34.976  1.00  9.73      A    C  
ATOM    859  CD1 ILE   121     -21.018  37.429  33.522  1.00  9.21      A    C  
ATOM    860  CG2 ILE   121     -22.390  39.799  34.670  1.00 10.25      A    C  
ATOM    861  C   ILE   121     -21.387  37.870  37.897  1.00  9.26      A    C  
ATOM    862  O   ILE   121     -20.231  37.678  38.255  1.00  9.54      A    O  
ATOM    863  N   ASP   122     -22.405  37.092  38.269  1.00  9.73      A    N  
ATOM    864  CA  ASP   122     -22.188  35.908  39.106  1.00 10.86      A    C  
ATOM    865  CB  ASP   122     -23.354  35.676  40.093  1.00 11.61      A    C  
ATOM    866  CG  ASP   122     -24.672  35.249  39.421  1.00 13.45      A    C  
ATOM    867  OD1 ASP   122     -24.695  34.799  38.247  1.00 14.14      A    O  
ATOM    868  OD2 ASP   122     -25.716  35.331  40.126  1.00 15.48      A    O  
ATOM    869  C   ASP   122     -21.845  34.691  38.265  1.00 10.57      A    C  
ATOM    870  O   ASP   122     -21.785  34.777  37.039  1.00 10.96      A    O  
ATOM    871  N   GLY   123     -21.563  33.559  38.908  1.00 11.14      A    N  
ATOM    872  CA  GLY   123     -21.061  32.405  38.165  1.00 11.24      A    C  
ATOM    873  C   GLY   123     -22.102  31.799  37.236  1.00 10.96      A    C  
ATOM    874  O   GLY   123     -21.777  31.279  36.165  1.00 10.79      A    O  
ATOM    875  N   ALA   124     -23.365  31.871  37.641  1.00 11.37      A    N  
ATOM    876  CA  ALA   124     -24.425  31.317  36.818  1.00 11.90      A    C  
ATOM    877  CB  ALA   124     -25.736  31.283  37.574  1.00 12.51      A    C  
ATOM    878  C   ALA   124     -24.551  32.145  35.559  1.00 11.88      A    C  
ATOM    879  O   ALA   124     -24.719  31.600  34.460  1.00 12.27      A    O  
ATOM    880  N   ALA   125     -24.464  33.468  35.710  1.00 11.08      A    N  
ATOM    881  CA  ALA   125     -24.471  34.355  34.540  1.00 11.35      A    C  
ATOM    882  CB  ALA   125     -24.527  35.840  34.954  1.00 10.70      A    C  
ATOM    883  C   ALA   125     -23.276  34.090  33.625  1.00 11.48      A    C  
ATOM    884  O   ALA   125     -23.409  34.069  32.397  1.00 12.27      A    O  
ATOM    885  N   ALA   126     -22.113  33.851  34.226  1.00 11.56      A    N  
ATOM    886  CA  ALA   126     -20.917  33.609  33.443  1.00 11.94      A    C  
ATOM    887  CB  ALA   126     -19.703  33.540  34.342  1.00 11.91      A    C  
ATOM    888  C   ALA   126     -21.073  32.313  32.670  1.00 12.63      A    C  
ATOM    889  O   ALA   126     -20.632  32.228  31.526  1.00 12.77      A    O  
ATOM    890  N   ARG   127     -21.703  31.312  33.290  1.00 13.27      A    N  
ATOM    891  CA  ARG   127     -21.963  30.046  32.598  1.00 15.12      A    C  
ATOM    892  CB  ARG   127     -22.409  28.938  33.557  1.00 15.73      A    C  
ATOM    893  CG  ARG   127     -22.422  27.574  32.871  1.00 19.72      A    C  
ATOM    894  CD  ARG   127     -23.038  26.512  33.742  1.00 28.32      A    C  
ATOM    895  NE  ARG   127     -22.144  26.082  34.814  1.00 32.45      A    N  
ATOM    896  CZ  ARG   127     -20.915  25.609  34.628  1.00 34.53      A    C  
ATOM    897  NH1 ARG   127     -20.399  25.526  33.410  1.00 36.22      A    N  
ATOM    898  NH2 ARG   127     -20.192  25.241  35.674  1.00 35.62      A    N  
ATOM    899  C   ARG   127     -22.977  30.194  31.455  1.00 15.15      A    C  
ATOM    900  O   ARG   127     -22.910  29.453  30.475  1.00 15.26      A    O  
ATOM    901  N   ARG   128     -23.908  31.142  31.563  1.00 15.50      A    N  
ATOM    902  CA  ARG   128     -24.790  31.443  30.424  1.00 16.16      A    C  
ATOM    903  CB  ARG   128     -25.851  32.486  30.767  1.00 16.85      A    C  
ATOM    904  CG  ARG   128     -26.902  32.009  31.742  1.00 20.03      A    C  
ATOM    905  CD  ARG   128     -28.158  32.920  31.714  1.00 23.38      A    C  
ATOM    906  NE  ARG   128     -27.918  34.274  32.227  1.00 25.47      A    N  
ATOM    907  CZ  ARG   128     -27.910  34.592  33.519  1.00 27.33      A    C  
ATOM    908  NH1 ARG   128     -28.118  33.653  34.446  1.00 27.69      A    N  
ATOM    909  NH2 ARG   128     -27.688  35.847  33.891  1.00 26.88      A    N  
ATOM    910  C   ARG   128     -23.991  31.946  29.232  1.00 15.98      A    C  
ATOM    911  O   ARG   128     -24.267  31.573  28.086  1.00 15.86      A    O  
ATOM    912  N   LEU   129     -23.008  32.801  29.506  1.00 14.53      A    N  
ATOM    913  CA  LEU   129     -22.157  33.354  28.466  1.00 14.54      A    C  
ATOM    914  CB  LEU   129     -21.324  34.523  29.013  1.00 14.23      A    C  
ATOM    915  CG  LEU   129     -22.077  35.802  29.379  1.00 15.66      A    C  
ATOM    916  CD1 LEU   129     -21.063  36.888  29.787  1.00 13.86      A    C  
ATOM    917  CD2 LEU   129     -22.936  36.264  28.210  1.00 17.99      A    C  
ATOM    918  C   LEU   129     -21.224  32.286  27.899  1.00 14.19      A    C  
ATOM    919  O   LEU   129     -20.954  32.262  26.691  1.00 14.72      A    O  
ATOM    920  N   GLU   130     -20.714  31.429  28.780  1.00 13.72      A    N  
ATOM    921  CA  GLU   130     -19.693  30.447  28.403  1.00 13.56      A    C  
ATOM    922  CB  GLU   130     -18.301  30.918  28.843  1.00 13.55      A    C  
ATOM    923  CG  GLU   130     -17.812  32.200  28.176  1.00 12.68      A    C  
ATOM    924  CD  GLU   130     -17.538  32.055  26.680  1.00 15.70      A    C  
ATOM    925  OE1 GLU   130     -17.409  30.913  26.192  1.00 15.22      A    O  
ATOM    926  OE2 GLU   130     -17.450  33.099  25.993  1.00 16.47      A    O  
ATOM    927  C   GLU   130     -19.994  29.120  29.069  1.00 13.88      A    C  
ATOM    928  O   GLU   130     -19.589  28.887  30.202  1.00 13.11      A    O  
ATOM    929  N   PRO   131     -20.737  28.253  28.372  1.00 14.53      A    N  
ATOM    930  CA  PRO   131     -21.213  26.989  28.923  1.00 15.31      A    C  
ATOM    931  CB  PRO   131     -21.841  26.302  27.703  1.00 15.14      A    C  
ATOM    932  CG  PRO   131     -22.378  27.450  26.909  1.00 15.68      A    C  
ATOM    933  CD  PRO   131     -21.346  28.545  27.061  1.00 15.28      A    C  
ATOM    934  C   PRO   131     -20.140  26.105  29.568  1.00 15.38      A    C  
ATOM    935  O   PRO   131     -20.448  25.354  30.491  1.00 16.32      A    O  
ATOM    936  N   ALA   132     -18.896  26.197  29.118  1.00 15.33      A    N  
ATOM    937  CA  ALA   132     -17.847  25.328  29.668  1.00 15.52      A    C  
ATOM    938  CB  ALA   132     -16.771  25.078  28.617  1.00 16.38      A    C  
ATOM    939  C   ALA   132     -17.208  25.875  30.945  1.00 15.75      A    C  
ATOM    940  O   ALA   132     -16.409  25.189  31.603  1.00 15.42      A    O  
ATOM    941  N   LEU   133     -17.577  27.104  31.303  1.00 14.25      A    N  
ATOM    942  CA  LEU   133     -16.881  27.834  32.363  1.00 14.20      A    C  
ATOM    943  CB  LEU   133     -17.013  29.332  32.104  1.00 13.32      A    C  
ATOM    944  CG  LEU   133     -16.291  30.281  33.061  1.00 13.73      A    C  
ATOM    945  CD1 LEU   133     -14.819  30.063  32.911  1.00 13.50      A    C  
ATOM    946  CD2 LEU   133     -16.631  31.749  32.722  1.00 13.79      A    C  
ATOM    947  C   LEU   133     -17.400  27.519  33.770  1.00 14.47      A    C  
ATOM    948  O   LEU   133     -18.607  27.572  34.019  1.00 15.12      A    O  
ATOM    949  N   HIS   134     -16.478  27.225  34.686  1.00 14.03      A    N  
ATOM    950  CA  HIS   134     -16.791  27.085  36.108  1.00 14.76      A    C  
ATOM    951  CB  HIS   134     -16.326  25.724  36.611  1.00 15.90      A    C  
ATOM    952  CG  HIS   134     -17.110  24.582  36.049  1.00 20.20      A    C  
ATOM    953  ND1 HIS   134     -17.115  24.268  34.704  1.00 24.70      A    N  
ATOM    954  CE1 HIS   134     -17.893  23.216  34.503  1.00 24.55      A    C  
ATOM    955  NE2 HIS   134     -18.387  22.834  35.668  1.00 26.33      A    N  
ATOM    956  CD2 HIS   134     -17.918  23.674  36.651  1.00 24.33      A    C  
ATOM    957  C   HIS   134     -16.131  28.199  36.914  1.00 13.53      A    C  
ATOM    958  O   HIS   134     -14.913  28.234  37.069  1.00 13.85      A    O  
ATOM    959  N   CYS   135     -16.927  29.153  37.383  1.00 12.51      A    N  
ATOM    960  CA  CYS   135     -16.371  30.209  38.219  1.00 11.65      A    C  
ATOM    961  CB  CYS   135     -15.875  31.389  37.375  1.00 11.43      A    C  
ATOM    962  SG  CYS   135     -17.216  32.398  36.638  1.00 12.32      A    S  
ATOM    963  C   CYS   135     -17.401  30.688  39.230  1.00 11.62      A    C  
ATOM    964  O   CYS   135     -18.592  30.391  39.108  1.00 12.40      A    O  
ATOM    965  N   THR   136     -16.925  31.458  40.205  1.00 10.92      A    N  
ATOM    966  CA  THR   136     -17.759  31.963  41.287  1.00 10.56      A    C  
ATOM    967  CB  THR   136     -16.915  32.176  42.555  1.00 11.24      A    C  
ATOM    968  OG1 THR   136     -16.345  30.909  42.944  1.00 13.55      A    O  
ATOM    969  CG2 THR   136     -17.777  32.718  43.690  1.00 11.81      A    C  
ATOM    970  C   THR   136     -18.403  33.284  40.877  1.00 10.16      A    C  
ATOM    971  O   THR   136     -19.545  33.552  41.213  1.00 10.24      A    O  
ATOM    972  N   ALA   137     -17.646  34.092  40.140  1.00  9.44      A    N  
ATOM    973  CA  ALA   137     -18.134  35.370  39.620  1.00  7.84      A    C  
ATOM    974  CB  ALA   137     -18.210  36.398  40.727  1.00  8.66      A    C  
ATOM    975  C   ALA   137     -17.164  35.822  38.552  1.00  7.88      A    C  
ATOM    976  O   ALA   137     -16.083  35.261  38.427  1.00  7.58      A    O  
ATOM    977  N   ALA   138     -17.527  36.831  37.767  1.00  6.45      A    N  
ATOM    978  CA  ALA   138     -16.600  37.287  36.739  1.00  6.77      A    C  
ATOM    979  CB  ALA   138     -16.755  36.458  35.465  1.00  5.81      A    C  
ATOM    980  C   ALA   138     -16.801  38.758  36.441  1.00  6.16      A    C  
ATOM    981  O   ALA   138     -17.863  39.324  36.754  1.00  7.09      A    O  
ATOM    982  N   LEU   139     -15.778  39.366  35.855  1.00  6.31      A    N  
ATOM    983  CA  LEU   139     -15.931  40.662  35.194  1.00  6.22      A    C  
ATOM    984  CB  LEU   139     -14.799  41.612  35.585  1.00  5.90      A    C  
ATOM    985  CG  LEU   139     -14.821  42.073  37.031  1.00  6.27      A    C  
ATOM    986  CD1 LEU   139     -13.501  42.801  37.369  1.00  8.20      A    C  
ATOM    987  CD2 LEU   139     -16.055  42.965  37.215  1.00  8.08      A    C  
ATOM    988  C   LEU   139     -15.845  40.430  33.699  1.00  6.93      A    C  
ATOM    989  O   LEU   139     -14.862  39.866  33.209  1.00  6.95      A    O  
ATOM    990  N   VAL   140     -16.857  40.882  32.971  1.00  6.51      A    N  
ATOM    991  CA  VAL   140     -16.795  40.888  31.522  1.00  7.14      A    C  
ATOM    992  CB  VAL   140     -18.203  40.794  30.884  1.00  7.16      A    C  
ATOM    993  CG1 VAL   140     -18.077  40.514  29.383  1.00  8.41      A    C  
ATOM    994  CG2 VAL   140     -19.015  39.715  31.557  1.00  8.16      A    C  
ATOM    995  C   VAL   140     -16.126  42.163  31.029  1.00  6.55      A    C  
ATOM    996  O   VAL   140     -16.484  43.262  31.452  1.00  7.58      A    O  
ATOM    997  N   SER   141     -15.179  42.009  30.103  1.00  6.10      A    N  
ATOM    998  CA  SER   141     -14.471  43.144  29.483  1.00  6.48      A    C  
ATOM    999  CB  SER   141     -12.967  43.087  29.802  1.00  5.90      A    C  
ATOM   1000  OG  SER   141     -12.256  44.072  29.083  1.00  6.81      A    O  
ATOM   1001  C   SER   141     -14.717  43.098  27.978  1.00  7.17      A    C  
ATOM   1002  O   SER   141     -13.993  42.443  27.229  1.00  7.47      A    O  
ATOM   1003  N   PRO   142     -15.766  43.796  27.523  1.00  7.70      A    N  
ATOM   1004  CA  PRO   142     -16.172  43.629  26.122  1.00  8.72      A    C  
ATOM   1005  CB  PRO   142     -17.576  44.249  26.053  1.00  9.16      A    C  
ATOM   1006  CG  PRO   142     -17.902  44.720  27.403  1.00  9.02      A    C  
ATOM   1007  CD  PRO   142     -16.733  44.549  28.335  1.00  8.19      A    C  
ATOM   1008  C   PRO   142     -15.234  44.264  25.106  1.00  9.17      A    C  
ATOM   1009  O   PRO   142     -15.268  43.884  23.930  1.00 10.78      A    O  
ATOM   1010  N   SER   143     -14.380  45.190  25.538  1.00  9.07      A    N  
ATOM   1011  CA  SER   143     -13.504  45.889  24.594  1.00  9.08      A    C  
ATOM   1012  CB  SER   143     -13.225  47.319  25.066  1.00  9.83      A    C  
ATOM   1013  OG  SER   143     -12.209  47.392  26.069  1.00 10.75      A    O  
ATOM   1014  C   SER   143     -12.193  45.128  24.333  1.00  8.98      A    C  
ATOM   1015  O   SER   143     -11.432  45.488  23.444  1.00  9.13      A    O  
ATOM   1016  N   THR   144     -11.939  44.088  25.121  1.00  7.62      A    N  
ATOM   1017  CA  THR   144     -10.721  43.289  24.934  1.00  7.76      A    C  
ATOM   1018  CB  THR   144     -10.529  42.313  26.113  1.00  7.89      A    C  
ATOM   1019  OG1 THR   144     -10.479  43.049  27.344  1.00  7.88      A    O  
ATOM   1020  CG2 THR   144      -9.238  41.507  25.945  1.00  7.59      A    C  
ATOM   1021  C   THR   144     -10.845  42.512  23.636  1.00  7.77      A    C  
ATOM   1022  O   THR   144     -11.920  41.986  23.336  1.00  8.55      A    O  
ATOM   1023  N   GLY   145      -9.767  42.459  22.853  1.00  7.14      A    N  
ATOM   1024  CA  GLY   145      -9.798  41.770  21.569  1.00  7.26      A    C  
ATOM   1025  C   GLY   145      -8.525  41.004  21.284  1.00  7.74      A    C  
ATOM   1026  O   GLY   145      -7.682  40.821  22.182  1.00  7.64      A    O  
ATOM   1027  N   ILE   146      -8.416  40.529  20.041  1.00  7.82      A    N  
ATOM   1028  CA  ILE   146      -7.192  39.904  19.534  1.00  8.08      A    C  
ATOM   1029  CB  ILE   146      -7.332  38.378  19.409  1.00  8.11      A    C  
ATOM   1030  CG1 ILE   146      -8.470  38.015  18.452  1.00  8.73      A    C  
ATOM   1031  CD1 ILE   146      -8.649  36.472  18.277  1.00  9.10      A    C  
ATOM   1032  CG2 ILE   146      -7.492  37.716  20.799  1.00  7.93      A    C  
ATOM   1033  C   ILE   146      -6.826  40.473  18.172  1.00  8.45      A    C  
ATOM   1034  O   ILE   146      -7.678  40.956  17.430  1.00  8.53      A    O  
ATOM   1035  N   VAL   147      -5.542  40.442  17.863  1.00  9.05      A    N  
ATOM   1036  CA  VAL   147      -5.032  40.986  16.605  1.00 10.93      A    C  
ATOM   1037  CB  VAL   147      -4.579  42.453  16.777  1.00 10.90      A    C  
ATOM   1038  CG1 VAL   147      -3.412  42.552  17.811  1.00 11.75      A    C  
ATOM   1039  CG2 VAL   147      -4.243  43.114  15.426  1.00 11.05      A    C  
ATOM   1040  C   VAL   147      -3.884  40.130  16.090  1.00 12.52      A    C  
ATOM   1041  O   VAL   147      -3.128  39.532  16.863  1.00 12.11      A    O  
ATOM   1042  N   ASP   148      -3.770  40.097  14.769  1.00 14.47      A    N  
ATOM   1043  CA  ASP   148      -2.664  39.450  14.093  1.00 16.95      A    C  
ATOM   1044  CB  ASP   148      -3.085  39.112  12.665  1.00 17.58      A    C  
ATOM   1045  CG  ASP   148      -1.964  38.477  11.847  1.00 21.13      A    C  
ATOM   1046  OD1 ASP   148      -0.775  38.668  12.182  1.00 23.02      A    O  
ATOM   1047  OD2 ASP   148      -2.295  37.779  10.861  1.00 24.53      A    O  
ATOM   1048  C   ASP   148      -1.506  40.422  14.093  1.00 16.87      A    C  
ATOM   1049  O   ASP   148      -1.511  41.396  13.345  1.00 17.36      A    O  
ATOM   1050  N   SER   149      -0.532  40.165  14.958  1.00 17.72      A    N  
ATOM   1051  CA  SER   149       0.528  41.121  15.224  1.00 18.68      A    C  
ATOM   1052  CB  SER   149       1.254  40.764  16.510  1.00 19.12      A    C  
ATOM   1053  OG  SER   149       1.909  39.516  16.379  1.00 22.53      A    O  
ATOM   1054  C   SER   149       1.504  41.170  14.066  1.00 18.52      A    C  
ATOM   1055  O   SER   149       2.071  42.227  13.770  1.00 18.58      A    O  
ATOM   1056  N   HIS   150       1.681  40.029  13.399  1.00 18.36      A    N  
ATOM   1057  CA  HIS   150       2.470  40.003  12.167  1.00 18.02      A    C  
ATOM   1058  CB  HIS   150       2.681  38.572  11.657  1.00 18.68      A    C  
ATOM   1059  CG  HIS   150       3.558  38.503  10.447  1.00 21.09      A    C  
ATOM   1060  ND1 HIS   150       4.884  38.882  10.472  1.00 25.40      A    N  
ATOM   1061  CE1 HIS   150       5.406  38.726   9.268  1.00 25.84      A    C  
ATOM   1062  NE2 HIS   150       4.462  38.273   8.461  1.00 25.44      A    N  
ATOM   1063  CD2 HIS   150       3.296  38.129   9.173  1.00 24.21      A    C  
ATOM   1064  C   HIS   150       1.853  40.888  11.079  1.00 16.84      A    C  
ATOM   1065  O   HIS   150       2.546  41.695  10.446  1.00 16.16      A    O  
ATOM   1066  N   ALA   151       0.545  40.763  10.873  1.00 16.24      A    N  
ATOM   1067  CA  ALA   151      -0.139  41.625   9.928  1.00 15.86      A    C  
ATOM   1068  CB  ALA   151      -1.597  41.246   9.813  1.00 16.38      A    C  
ATOM   1069  C   ALA   151      -0.014  43.080  10.356  1.00 15.47      A    C  
ATOM   1070  O   ALA   151       0.171  43.956   9.528  1.00 15.17      A    O  
ATOM   1071  N   LEU   152      -0.137  43.335  11.653  1.00 14.77      A    N  
ATOM   1072  CA  LEU   152      -0.056  44.710  12.140  1.00 14.27      A    C  
ATOM   1073  CB  LEU   152      -0.319  44.751  13.639  1.00 13.97      A    C  
ATOM   1074  CG  LEU   152      -0.373  46.128  14.281  1.00 13.87      A    C  
ATOM   1075  CD1 LEU   152      -1.591  46.910  13.748  1.00 11.37      A    C  
ATOM   1076  CD2 LEU   152      -0.468  45.935  15.789  1.00 11.28      A    C  
ATOM   1077  C   LEU   152       1.311  45.289  11.822  1.00 14.19      A    C  
ATOM   1078  O   LEU   152       1.419  46.393  11.319  1.00 13.70      A    O  
ATOM   1079  N   MET   153       2.357  44.515  12.099  1.00 14.92      A    N  
ATOM   1080  CA  MET   153       3.723  44.933  11.785  1.00 15.94      A    C  
ATOM   1081  CB  MET   153       4.716  43.865  12.236  1.00 16.58      A    C  
ATOM   1082  CG  MET   153       4.994  43.954  13.716  1.00 18.71      A    C  
ATOM   1083  SD  MET   153       6.135  42.731  14.333  1.00 25.55      A    S  
ATOM   1084  CE  MET   153       5.900  41.338  13.214  1.00 19.88      A    C  
ATOM   1085  C   MET   153       3.916  45.278  10.304  1.00 15.59      A    C  
ATOM   1086  O   MET   153       4.469  46.313   9.967  1.00 14.87      A    O  
ATOM   1087  N   LEU   154       3.444  44.406   9.426  1.00 15.91      A    N  
ATOM   1088  CA  LEU   154       3.581  44.625   7.994  1.00 16.35      A    C  
ATOM   1089  CB  LEU   154       3.024  43.412   7.241  1.00 17.02      A    C  
ATOM   1090  CG  LEU   154       3.863  42.144   7.359  1.00 19.65      A    C  
ATOM   1091  CD1 LEU   154       3.184  40.943   6.698  1.00 22.42      A    C  
ATOM   1092  CD2 LEU   154       5.226  42.393   6.731  1.00 22.25      A    C  
ATOM   1093  C   LEU   154       2.850  45.893   7.581  1.00 15.80      A    C  
ATOM   1094  O   LEU   154       3.295  46.623   6.696  1.00 15.54      A    O  
ATOM   1095  N   ALA   155       1.715  46.155   8.232  1.00 15.23      A    N  
ATOM   1096  CA  ALA   155       0.925  47.329   7.924  1.00 14.47      A    C  
ATOM   1097  CB  ALA   155      -0.490  47.232   8.577  1.00 14.80      A    C  
ATOM   1098  C   ALA   155       1.656  48.596   8.352  1.00 14.00      A    C  
ATOM   1099  O   ALA   155       1.692  49.576   7.606  1.00 14.23      A    O  
ATOM   1100  N   TYR   156       2.246  48.586   9.552  1.00 13.09      A    N  
ATOM   1101  CA  TYR   156       3.050  49.728  10.006  1.00 12.38      A    C  
ATOM   1102  CB  TYR   156       3.629  49.514  11.406  1.00 12.10      A    C  
ATOM   1103  CG  TYR   156       2.652  49.504  12.567  1.00 10.97      A    C  
ATOM   1104  CD1 TYR   156       1.308  49.845  12.400  1.00  9.82      A    C  
ATOM   1105  CE1 TYR   156       0.416  49.822  13.489  1.00 10.69      A    C  
ATOM   1106  CZ  TYR   156       0.891  49.518  14.757  1.00  9.74      A    C  
ATOM   1107  OH  TYR   156       0.036  49.505  15.850  1.00 10.56      A    O  
ATOM   1108  CE2 TYR   156       2.219  49.206  14.943  1.00 10.96      A    C  
ATOM   1109  CD2 TYR   156       3.096  49.209  13.850  1.00 11.32      A    C  
ATOM   1110  C   TYR   156       4.220  49.940   9.049  1.00 12.81      A    C  
ATOM   1111  O   TYR   156       4.559  51.070   8.709  1.00 12.43      A    O  
ATOM   1112  N   GLN   157       4.851  48.841   8.658  1.00 13.85      A    N  
ATOM   1113  CA  GLN   157       5.981  48.904   7.726  1.00 14.67      A    C  
ATOM   1114  CB  GLN   157       6.560  47.517   7.449  1.00 15.34      A    C  
ATOM   1115  CG  GLN   157       7.733  47.581   6.475  1.00 17.21      A    C  
ATOM   1116  CD  GLN   157       8.411  46.240   6.247  1.00 20.78      A    C  
ATOM   1117  OE1 GLN   157       8.147  45.261   6.941  1.00 23.92      A    O  
ATOM   1118  NE2 GLN   157       9.297  46.194   5.262  1.00 22.71      A    N  
ATOM   1119  C   GLN   157       5.576  49.552   6.417  1.00 14.89      A    C  
ATOM   1120  O   GLN   157       6.260  50.448   5.940  1.00 14.44      A    O  
ATOM   1121  N   GLY   158       4.482  49.068   5.828  1.00 15.07      A    N  
ATOM   1122  CA  GLY   158       3.913  49.666   4.616  1.00 15.81      A    C  
ATOM   1123  C   GLY   158       3.687  51.163   4.711  1.00 16.14      A    C  
ATOM   1124  O   GLY   158       4.078  51.917   3.818  1.00 16.18      A    O  
ATOM   1125  N   ASP   159       3.055  51.611   5.797  1.00 15.83      A    N  
ATOM   1126  CA  ASP   159       2.843  53.032   6.002  1.00 16.31      A    C  
ATOM   1127  CB  ASP   159       2.101  53.288   7.321  1.00 16.20      A    C  
ATOM   1128  CG  ASP   159       0.697  52.694   7.341  1.00 18.03      A    C  
ATOM   1129  OD1 ASP   159       0.209  52.235   6.279  1.00 18.03      A    O  
ATOM   1130  OD2 ASP   159       0.075  52.701   8.435  1.00 15.54      A    O  
ATOM   1131  C   ASP   159       4.153  53.809   6.029  1.00 16.11      A    C  
ATOM   1132  O   ASP   159       4.287  54.834   5.371  1.00 16.51      A    O  
ATOM   1133  N   ALA   160       5.122  53.338   6.809  1.00 16.03      A    N  
ATOM   1134  CA  ALA   160       6.379  54.061   6.948  1.00 15.64      A    C  
ATOM   1135  CB  ALA   160       7.279  53.375   7.976  1.00 15.92      A    C  
ATOM   1136  C   ALA   160       7.084  54.161   5.598  1.00 16.30      A    C  
ATOM   1137  O   ALA   160       7.596  55.223   5.225  1.00 15.95      A    O  
ATOM   1138  N   GLU   161       7.102  53.052   4.871  1.00 16.77      A    N  
ATOM   1139  CA  GLU   161       7.720  53.023   3.542  1.00 17.91      A    C  
ATOM   1140  CB  GLU   161       7.720  51.607   2.973  1.00 17.88      A    C  
ATOM   1141  CG  GLU   161       8.741  50.677   3.637  1.00 20.21      A    C  
ATOM   1142  CD  GLU   161       8.599  49.224   3.201  1.00 23.52      A    C  
ATOM   1143  OE1 GLU   161       7.532  48.844   2.680  1.00 26.93      A    O  
ATOM   1144  OE2 GLU   161       9.559  48.452   3.386  1.00 25.88      A    O  
ATOM   1145  C   GLU   161       7.024  53.986   2.584  1.00 18.29      A    C  
ATOM   1146  O   GLU   161       7.673  54.645   1.777  1.00 18.44      A    O  
ATOM   1147  N   SER   162       5.704  54.080   2.684  1.00 18.99      A    N  
ATOM   1148  CA  SER   162       4.956  55.017   1.843  1.00 19.41      A    C  
ATOM   1149  CB  SER   162       3.447  54.841   2.046  1.00 19.38      A    C  
ATOM   1150  OG  SER   162       2.985  55.633   3.131  1.00 23.20      A    O  
ATOM   1151  C   SER   162       5.377  56.468   2.090  1.00 19.47      A    C  
ATOM   1152  O   SER   162       5.243  57.324   1.206  1.00 19.90      A    O  
ATOM   1153  N   ASP   163       5.894  56.741   3.287  1.00 18.85      A    N  
ATOM   1154  CA  ASP   163       6.424  58.053   3.621  1.00 18.86      A    C  
ATOM   1155  CB  ASP   163       5.941  58.495   5.008  1.00 18.79      A    C  
ATOM   1156  CG  ASP   163       4.470  58.866   5.021  1.00 20.54      A    C  
ATOM   1157  OD1 ASP   163       3.996  59.411   3.996  1.00 20.38      A    O  
ATOM   1158  OD2 ASP   163       3.791  58.631   6.055  1.00 20.98      A    O  
ATOM   1159  C   ASP   163       7.952  58.064   3.563  1.00 18.06      A    C  
ATOM   1160  O   ASP   163       8.595  58.866   4.225  1.00 18.31      A    O  
ATOM   1161  N   GLY   164       8.512  57.166   2.760  1.00 18.01      A    N  
ATOM   1162  CA  GLY   164       9.936  57.192   2.425  1.00 17.80      A    C  
ATOM   1163  C   GLY   164      10.883  56.463   3.359  1.00 17.55      A    C  
ATOM   1164  O   GLY   164      12.110  56.488   3.159  1.00 17.16      A    O  
ATOM   1165  N   ALA   165      10.347  55.821   4.392  1.00 16.59      A    N  
ATOM   1166  CA  ALA   165      11.226  55.078   5.299  1.00 15.88      A    C  
ATOM   1167  CB  ALA   165      10.464  54.611   6.531  1.00 15.49      A    C  
ATOM   1168  C   ALA   165      11.848  53.895   4.581  1.00 15.99      A    C  
ATOM   1169  O   ALA   165      11.227  53.301   3.702  1.00 16.08      A    O  
ATOM   1170  N   GLN   166      13.089  53.572   4.946  1.00 15.87      A    N  
ATOM   1171  CA  GLN   166      13.783  52.403   4.409  1.00 16.04      A    C  
ATOM   1172  CB  GLN   166      15.063  52.818   3.694  1.00 16.57      A    C  
ATOM   1173  CG  GLN   166      14.817  53.598   2.408  1.00 17.98      A    C  
ATOM   1174  CD  GLN   166      16.094  53.867   1.628  1.00 21.08      A    C  
ATOM   1175  OE1 GLN   166      16.923  52.979   1.448  1.00 23.16      A    O  
ATOM   1176  NE2 GLN   166      16.249  55.097   1.157  1.00 20.86      A    N  
ATOM   1177  C   GLN   166      14.134  51.479   5.564  1.00 15.97      A    C  
ATOM   1178  O   GLN   166      14.580  51.938   6.615  1.00 16.12      A    O  
ATOM   1179  N   LEU   167      13.920  50.188   5.373  1.00 15.41      A    N  
ATOM   1180  CA  LEU   167      14.239  49.197   6.385  1.00 16.04      A    C  
ATOM   1181  CB  LEU   167      13.047  48.288   6.632  1.00 16.45      A    C  
ATOM   1182  CG  LEU   167      11.863  48.925   7.362  1.00 18.85      A    C  
ATOM   1183  CD1 LEU   167      10.928  49.624   6.390  1.00 21.28      A    C  
ATOM   1184  CD2 LEU   167      11.135  47.861   8.152  1.00 20.90      A    C  
ATOM   1185  C   LEU   167      15.400  48.358   5.908  1.00 15.59      A    C  
ATOM   1186  O   LEU   167      15.386  47.864   4.770  1.00 15.57      A    O  
ATOM   1187  N   VAL   168      16.401  48.187   6.769  1.00 14.78      A    N  
ATOM   1188  CA  VAL   168      17.559  47.372   6.415  1.00 14.56      A    C  
ATOM   1189  CB  VAL   168      18.876  48.187   6.329  1.00 14.89      A    C  
ATOM   1190  CG1 VAL   168      18.823  49.156   5.161  1.00 16.13      A    C  
ATOM   1191  CG2 VAL   168      19.174  48.941   7.626  1.00 15.18      A    C  
ATOM   1192  C   VAL   168      17.697  46.230   7.410  1.00 14.04      A    C  
ATOM   1193  O   VAL   168      17.853  46.465   8.608  1.00 13.41      A    O  
ATOM   1194  N   PHE   169      17.589  45.004   6.905  1.00 13.28      A    N  
ATOM   1195  CA  PHE   169      17.640  43.818   7.757  1.00 13.58      A    C  
ATOM   1196  CB  PHE   169      16.650  42.755   7.264  1.00 13.70      A    C  
ATOM   1197  CG  PHE   169      15.212  43.168   7.435  1.00 15.53      A    C  
ATOM   1198  CD1 PHE   169      14.573  43.012   8.668  1.00 16.84      A    C  
ATOM   1199  CE1 PHE   169      13.258  43.403   8.842  1.00 18.53      A    C  
ATOM   1200  CZ  PHE   169      12.567  43.973   7.779  1.00 18.35      A    C  
ATOM   1201  CE2 PHE   169      13.193  44.145   6.547  1.00 17.55      A    C  
ATOM   1202  CD2 PHE   169      14.508  43.728   6.375  1.00 16.64      A    C  
ATOM   1203  C   PHE   169      19.067  43.272   7.865  1.00 13.19      A    C  
ATOM   1204  O   PHE   169      19.973  43.773   7.201  1.00 13.60      A    O  
ATOM   1205  N   HIS   170      19.252  42.277   8.726  1.00 12.99      A    N  
ATOM   1206  CA  HIS   170      20.580  41.741   9.069  1.00 13.34      A    C  
ATOM   1207  CB  HIS   170      21.019  40.628   8.092  1.00 14.56      A    C  
ATOM   1208  CG  HIS   170      20.910  40.999   6.648  1.00 18.57      A    C  
ATOM   1209  ND1 HIS   170      21.886  41.712   5.986  1.00 21.37      A    N  
ATOM   1210  CE1 HIS   170      21.520  41.890   4.728  1.00 22.64      A    C  
ATOM   1211  NE2 HIS   170      20.346  41.311   4.549  1.00 23.50      A    N  
ATOM   1212  CD2 HIS   170      19.945  40.738   5.732  1.00 20.09      A    C  
ATOM   1213  C   HIS   170      21.641  42.840   9.242  1.00 12.40      A    C  
ATOM   1214  O   HIS   170      22.780  42.732   8.777  1.00 11.98      A    O  
ATOM   1215  N   THR   171      21.243  43.884   9.960  1.00 10.20      A    N  
ATOM   1216  CA  THR   171      22.069  45.048  10.175  1.00 10.29      A    C  
ATOM   1217  CB  THR   171      21.558  46.211   9.305  1.00  9.65      A    C  
ATOM   1218  OG1 THR   171      21.615  45.801   7.930  1.00 11.88      A    O  
ATOM   1219  CG2 THR   171      22.400  47.460   9.509  1.00 10.17      A    C  
ATOM   1220  C   THR   171      22.068  45.398  11.669  1.00  9.25      A    C  
ATOM   1221  O   THR   171      21.277  46.224  12.139  1.00 10.00      A    O  
ATOM   1222  N   PRO   172      22.937  44.735  12.440  1.00  8.33      A    N  
ATOM   1223  CA  PRO   172      22.975  44.938  13.879  1.00  8.52      A    C  
ATOM   1224  CB  PRO   172      23.712  43.681  14.377  1.00  8.27      A    C  
ATOM   1225  CG  PRO   172      24.641  43.370  13.295  1.00  8.48      A    C  
ATOM   1226  CD  PRO   172      23.925  43.729  12.001  1.00  8.85      A    C  
ATOM   1227  C   PRO   172      23.779  46.177  14.265  1.00  8.15      A    C  
ATOM   1228  O   PRO   172      24.909  46.344  13.810  1.00  8.40      A    O  
ATOM   1229  N   LEU   173      23.199  47.047  15.087  1.00  7.89      A    N  
ATOM   1230  CA  LEU   173      23.974  48.130  15.697  1.00  7.87      A    C  
ATOM   1231  CB  LEU   173      23.061  49.217  16.291  1.00  7.05      A    C  
ATOM   1232  CG  LEU   173      23.786  50.364  16.999  1.00  7.37      A    C  
ATOM   1233  CD1 LEU   173      24.775  51.011  16.041  1.00  9.34      A    C  
ATOM   1234  CD2 LEU   173      22.811  51.424  17.509  1.00  7.46      A    C  
ATOM   1235  C   LEU   173      24.885  47.573  16.790  1.00  8.11      A    C  
ATOM   1236  O   LEU   173      24.426  46.892  17.713  1.00  8.12      A    O  
ATOM   1237  N   ILE   174      26.179  47.863  16.681  1.00  8.09      A    N  
ATOM   1238  CA  ILE   174      27.158  47.291  17.621  1.00  8.42      A    C  
ATOM   1239  CB  ILE   174      28.356  46.670  16.853  1.00  8.26      A    C  
ATOM   1240  CG1 ILE   174      27.865  45.676  15.789  1.00  7.67      A    C  
ATOM   1241  CD1 ILE   174      27.054  44.487  16.336  1.00  7.85      A    C  
ATOM   1242  CG2 ILE   174      29.361  46.028  17.830  1.00  8.43      A    C  
ATOM   1243  C   ILE   174      27.652  48.314  18.624  1.00  9.03      A    C  
ATOM   1244  O   ILE   174      27.699  48.070  19.829  1.00  9.28      A    O  
ATOM   1245  N   ALA   175      28.047  49.480  18.136  1.00  9.51      A    N  
ATOM   1246  CA  ALA   175      28.565  50.498  19.019  1.00 10.45      A    C  
ATOM   1247  CB  ALA   175      30.071  50.393  19.129  1.00 10.90      A    C  
ATOM   1248  C   ALA   175      28.188  51.837  18.435  1.00 11.08      A    C  
ATOM   1249  O   ALA   175      27.962  51.946  17.233  1.00 11.71      A    O  
ATOM   1250  N   GLY   176      28.139  52.854  19.278  1.00 12.21      A    N  
ATOM   1251  CA  GLY   176      27.846  54.194  18.798  1.00 13.05      A    C  
ATOM   1252  C   GLY   176      28.436  55.230  19.731  1.00 13.92      A    C  
ATOM   1253  O   GLY   176      28.990  54.894  20.775  1.00 13.64      A    O  
ATOM   1254  N   ARG   177      28.294  56.498  19.359  1.00 15.36      A    N  
ATOM   1255  CA  ARG   177      28.721  57.593  20.213  1.00 16.27      A    C  
ATOM   1256  CB  ARG   177      30.206  57.909  20.017  1.00 17.42      A    C  
ATOM   1257  CG  ARG   177      30.658  57.827  18.593  1.00 20.25      A    C  
ATOM   1258  CD  ARG   177      31.969  57.019  18.473  1.00 23.95      A    C  
ATOM   1259  NE  ARG   177      32.031  56.407  17.152  1.00 27.37      A    N  
ATOM   1260  CZ  ARG   177      31.792  55.125  16.912  1.00 27.14      A    C  
ATOM   1261  NH1 ARG   177      31.522  54.286  17.913  1.00 26.52      A    N  
ATOM   1262  NH2 ARG   177      31.845  54.676  15.669  1.00 29.80      A    N  
ATOM   1263  C   ARG   177      27.896  58.829  19.927  1.00 16.34      A    C  
ATOM   1264  O   ARG   177      27.538  59.091  18.788  1.00 15.95      A    O  
ATOM   1265  N   VAL   178      27.570  59.556  20.980  1.00 17.04      A    N  
ATOM   1266  CA  VAL   178      26.987  60.887  20.836  1.00 18.33      A    C  
ATOM   1267  CB  VAL   178      26.464  61.400  22.181  1.00 17.81      A    C  
ATOM   1268  CG1 VAL   178      25.794  62.775  22.007  1.00 19.49      A    C  
ATOM   1269  CG2 VAL   178      25.498  60.391  22.792  1.00 18.84      A    C  
ATOM   1270  C   VAL   178      28.092  61.799  20.348  1.00 19.19      A    C  
ATOM   1271  O   VAL   178      29.158  61.865  20.962  1.00 19.66      A    O  
ATOM   1272  N   ARG   179      27.849  62.492  19.244  1.00 20.46      A    N  
ATOM   1273  CA  ARG   179      28.847  63.385  18.655  1.00 22.18      A    C  
ATOM   1274  CB  ARG   179      28.556  63.618  17.170  1.00 21.81      A    C  
ATOM   1275  CG  ARG   179      28.576  62.372  16.315  1.00 21.76      A    C  
ATOM   1276  CD  ARG   179      28.501  62.735  14.854  1.00 21.65      A    C  
ATOM   1277  NE  ARG   179      27.341  63.577  14.565  1.00 21.68      A    N  
ATOM   1278  CZ  ARG   179      26.933  63.870  13.336  1.00 21.54      A    C  
ATOM   1279  NH1 ARG   179      27.594  63.391  12.291  1.00 21.08      A    N  
ATOM   1280  NH2 ARG   179      25.867  64.630  13.152  1.00 22.04      A    N  
ATOM   1281  C   ARG   179      28.893  64.723  19.376  1.00 23.47      A    C  
ATOM   1282  O   ARG   179      27.849  65.298  19.694  1.00 23.29      A    O  
ATOM   1283  N   PRO   180      30.113  65.232  19.616  1.00 25.00      A    N  
ATOM   1284  CA  PRO   180      30.317  66.517  20.281  1.00 25.94      A    C  
ATOM   1285  CB  PRO   180      31.798  66.812  20.025  1.00 26.04      A    C  
ATOM   1286  CG  PRO   180      32.425  65.461  19.860  1.00 26.63      A    C  
ATOM   1287  CD  PRO   180      31.381  64.610  19.192  1.00 25.14      A    C  
ATOM   1288  C   PRO   180      29.443  67.608  19.658  1.00 26.39      A    C  
ATOM   1289  O   PRO   180      28.883  68.438  20.378  1.00 27.48      A    O  
ATOM   1290  N   GLU   181      29.326  67.591  18.334  1.00 26.33      A    N  
ATOM   1291  CA  GLU   181      28.523  68.571  17.599  1.00 26.44      A    C  
ATOM   1292  CB  GLU   181      29.034  68.689  16.167  1.00 26.54      A    C  
ATOM   1293  CG  GLU   181      28.729  67.484  15.304  1.00 28.19      A    C  
ATOM   1294  CD  GLU   181      29.889  66.499  15.219  1.00 30.24      A    C  
ATOM   1295  OE1 GLU   181      30.617  66.327  16.229  1.00 30.67      A    O  
ATOM   1296  OE2 GLU   181      30.074  65.903  14.133  1.00 31.19      A    O  
ATOM   1297  C   GLU   181      27.020  68.258  17.548  1.00 25.87      A    C  
ATOM   1298  O   GLU   181      26.256  68.990  16.909  1.00 26.59      A    O  
ATOM   1299  N   GLY   182      26.596  67.182  18.206  1.00 24.64      A    N  
ATOM   1300  CA  GLY   182      25.198  66.750  18.146  1.00 22.42      A    C  
ATOM   1301  C   GLY   182      25.047  65.597  17.171  1.00 21.04      A    C  
ATOM   1302  O   GLY   182      25.896  65.402  16.308  1.00 20.92      A    O  
ATOM   1303  N   GLY   183      23.974  64.819  17.302  1.00 18.80      A    N  
ATOM   1304  CA  GLY   183      23.797  63.658  16.435  1.00 16.53      A    C  
ATOM   1305  C   GLY   183      24.635  62.485  16.927  1.00 14.99      A    C  
ATOM   1306  O   GLY   183      25.215  62.537  18.016  1.00 14.84      A    O  
ATOM   1307  N   PHE   184      24.726  61.456  16.094  1.00 13.93      A    N  
ATOM   1308  CA  PHE   184      25.298  60.172  16.507  1.00 13.13      A    C  
ATOM   1309  CB  PHE   184      24.152  59.206  16.850  1.00 12.83      A    C  
ATOM   1310  CG  PHE   184      23.183  59.768  17.842  1.00 13.91      A    C  
ATOM   1311  CD1 PHE   184      23.331  59.531  19.195  1.00 12.71      A    C  
ATOM   1312  CE1 PHE   184      22.449  60.071  20.115  1.00 12.74      A    C  
ATOM   1313  CZ  PHE   184      21.412  60.880  19.677  1.00 13.24      A    C  
ATOM   1314  CE2 PHE   184      21.257  61.124  18.330  1.00 11.65      A    C  
ATOM   1315  CD2 PHE   184      22.135  60.567  17.414  1.00 12.37      A    C  
ATOM   1316  C   PHE   184      26.144  59.580  15.403  1.00 12.91      A    C  
ATOM   1317  O   PHE   184      25.842  59.757  14.227  1.00 12.12      A    O  
ATOM   1318  N   GLU   185      27.199  58.855  15.786  1.00 12.91      A    N  
ATOM   1319  CA  GLU   185      27.953  58.058  14.831  1.00 13.21      A    C  
ATOM   1320  CB  GLU   185      29.432  58.434  14.829  1.00 13.69      A    C  
ATOM   1321  CG  GLU   185      30.186  57.732  13.726  1.00 17.84      A    C  
ATOM   1322  CD  GLU   185      31.647  58.112  13.682  1.00 23.25      A    C  
ATOM   1323  OE1 GLU   185      32.325  57.987  14.729  1.00 26.33      A    O  
ATOM   1324  OE2 GLU   185      32.115  58.509  12.593  1.00 25.75      A    O  
ATOM   1325  C   GLU   185      27.767  56.613  15.255  1.00 12.22      A    C  
ATOM   1326  O   GLU   185      27.908  56.294  16.442  1.00 12.86      A    O  
ATOM   1327  N   LEU   186      27.440  55.760  14.295  1.00 11.73      A    N  
ATOM   1328  CA  LEU   186      26.991  54.399  14.607  1.00 11.35      A    C  
ATOM   1329  CB  LEU   186      25.497  54.254  14.280  1.00 11.21      A    C  
ATOM   1330  CG  LEU   186      24.556  55.239  14.990  1.00 12.19      A    C  
ATOM   1331  CD1 LEU   186      23.129  54.999  14.522  1.00 12.80      A    C  
ATOM   1332  CD2 LEU   186      24.645  55.154  16.513  1.00 11.56      A    C  
ATOM   1333  C   LEU   186      27.740  53.346  13.809  1.00 10.81      A    C  
ATOM   1334  O   LEU   186      27.823  53.435  12.582  1.00 11.13      A    O  
ATOM   1335  N   ASP   187      28.236  52.317  14.502  1.00 10.47      A    N  
ATOM   1336  CA  ASP   187      28.934  51.222  13.856  1.00 10.57      A    C  
ATOM   1337  CB  ASP   187      30.211  50.862  14.629  1.00 10.52      A    C  
ATOM   1338  CG  ASP   187      31.160  52.039  14.749  1.00 13.54      A    C  
ATOM   1339  OD1 ASP   187      31.164  52.898  13.832  1.00 16.27      A    O  
ATOM   1340  OD2 ASP   187      31.895  52.108  15.756  1.00 17.11      A    O  
ATOM   1341  C   ASP   187      28.041  50.007  13.800  1.00  9.88      A    C  
ATOM   1342  O   ASP   187      27.648  49.475  14.844  1.00  9.11      A    O  
ATOM   1343  N   PHE   188      27.708  49.589  12.580  1.00  9.80      A    N  
ATOM   1344  CA  PHE   188      26.895  48.413  12.359  1.00 10.64      A    C  
ATOM   1345  CB  PHE   188      25.886  48.681  11.251  1.00 10.49      A    C  
ATOM   1346  CG  PHE   188      24.868  49.720  11.615  1.00  9.97      A    C  
ATOM   1347  CD1 PHE   188      23.687  49.348  12.231  1.00 11.29      A    C  
ATOM   1348  CE1 PHE   188      22.736  50.296  12.573  1.00 11.93      A    C  
ATOM   1349  CZ  PHE   188      22.965  51.633  12.295  1.00 12.62      A    C  
ATOM   1350  CE2 PHE   188      24.144  52.018  11.667  1.00 11.53      A    C  
ATOM   1351  CD2 PHE   188      25.090  51.058  11.336  1.00 12.05      A    C  
ATOM   1352  C   PHE   188      27.766  47.210  12.026  1.00 10.85      A    C  
ATOM   1353  O   PHE   188      28.836  47.340  11.404  1.00 11.32      A    O  
ATOM   1354  N   GLY   189      27.317  46.036  12.454  1.00 11.23      A    N  
ATOM   1355  CA  GLY   189      28.084  44.809  12.255  1.00 11.21      A    C  
ATOM   1356  C   GLY   189      27.490  43.887  11.205  1.00 11.49      A    C  
ATOM   1357  O   GLY   189      27.011  44.338  10.148  1.00 11.13      A    O  
ATOM   1358  N   GLY   190      27.496  42.591  11.501  1.00 10.38      A    N  
ATOM   1359  CA  GLY   190      27.004  41.572  10.579  1.00 11.23      A    C  
ATOM   1360  C   GLY   190      27.962  41.298   9.425  1.00 12.17      A    C  
ATOM   1361  O   GLY   190      29.160  41.543   9.529  1.00 11.35      A    O  
ATOM   1362  N   ALA   191      27.407  40.794   8.326  1.00 13.23      A    N  
ATOM   1363  CA  ALA   191      28.196  40.384   7.170  1.00 14.28      A    C  
ATOM   1364  CB  ALA   191      27.352  39.556   6.231  1.00 14.72      A    C  
ATOM   1365  C   ALA   191      28.794  41.571   6.423  1.00 14.38      A    C  
ATOM   1366  O   ALA   191      29.802  41.424   5.738  1.00 15.35      A    O  
ATOM   1367  N   GLU   192      28.172  42.735   6.558  1.00 13.71      A    N  
ATOM   1368  CA  GLU   192      28.578  43.918   5.805  1.00 14.16      A    C  
ATOM   1369  CB  GLU   192      27.563  44.223   4.703  1.00 14.36      A    C  
ATOM   1370  CG  GLU   192      27.275  43.073   3.758  1.00 17.88      A    C  
ATOM   1371  CD  GLU   192      26.044  43.352   2.920  1.00 22.75      A    C  
ATOM   1372  OE1 GLU   192      26.112  44.221   2.011  1.00 23.54      A    O  
ATOM   1373  OE2 GLU   192      24.996  42.720   3.189  1.00 25.37      A    O  
ATOM   1374  C   GLU   192      28.691  45.132   6.723  1.00 13.02      A    C  
ATOM   1375  O   GLU   192      27.886  46.059   6.632  1.00 12.59      A    O  
ATOM   1376  N   PRO   193      29.699  45.130   7.599  1.00 12.63      A    N  
ATOM   1377  CA  PRO   193      29.825  46.204   8.582  1.00 12.57      A    C  
ATOM   1378  CB  PRO   193      31.100  45.837   9.369  1.00 12.27      A    C  
ATOM   1379  CG  PRO   193      31.795  44.797   8.571  1.00 12.67      A    C  
ATOM   1380  CD  PRO   193      30.728  44.088   7.782  1.00 12.37      A    C  
ATOM   1381  C   PRO   193      29.993  47.543   7.913  1.00 12.99      A    C  
ATOM   1382  O   PRO   193      30.588  47.639   6.827  1.00 12.51      A    O  
ATOM   1383  N   MET   194      29.452  48.570   8.546  1.00 12.97      A    N  
ATOM   1384  CA  MET   194      29.477  49.906   7.968  1.00 13.24      A    C  
ATOM   1385  CB  MET   194      28.362  50.039   6.926  1.00 13.37      A    C  
ATOM   1386  CG  MET   194      26.958  50.127   7.541  1.00 14.71      A    C  
ATOM   1387  SD  MET   194      25.659  50.420   6.309  1.00 15.17      A    S  
ATOM   1388  CE  MET   194      25.838  48.946   5.359  1.00 18.02      A    C  
ATOM   1389  C   MET   194      29.243  50.911   9.075  1.00 13.51      A    C  
ATOM   1390  O   MET   194      28.750  50.551  10.138  1.00 13.59      A    O  
ATOM   1391  N   THR   195      29.579  52.177   8.826  1.00 13.34      A    N  
ATOM   1392  CA  THR   195      29.300  53.238   9.789  1.00 13.81      A    C  
ATOM   1393  CB  THR   195      30.589  53.926  10.251  1.00 13.18      A    C  
ATOM   1394  OG1 THR   195      31.392  52.988  10.983  1.00 16.01      A    O  
ATOM   1395  CG2 THR   195      30.281  55.119  11.140  1.00 14.43      A    C  
ATOM   1396  C   THR   195      28.364  54.261   9.154  1.00 13.99      A    C  
ATOM   1397  O   THR   195      28.519  54.598   7.981  1.00 13.93      A    O  
ATOM   1398  N   LEU   196      27.372  54.709   9.912  1.00 14.13      A    N  
ATOM   1399  CA  LEU   196      26.428  55.747   9.455  1.00 14.52      A    C  
ATOM   1400  CB  LEU   196      25.045  55.160   9.131  1.00 14.58      A    C  
ATOM   1401  CG  LEU   196      24.874  54.032   8.104  1.00 15.95      A    C  
ATOM   1402  CD1 LEU   196      23.415  53.563   8.044  1.00 17.10      A    C  
ATOM   1403  CD2 LEU   196      25.362  54.456   6.716  1.00 19.76      A    C  
ATOM   1404  C   LEU   196      26.275  56.754  10.570  1.00 14.91      A    C  
ATOM   1405  O   LEU   196      26.500  56.436  11.735  1.00 15.15      A    O  
ATOM   1406  N   SER   197      25.879  57.976  10.227  1.00 14.77      A    N  
ATOM   1407  CA  SER   197      25.653  58.990  11.245  1.00 14.47      A    C  
ATOM   1408  CB  SER   197      26.655  60.123  11.101  1.00 15.04      A    C  
ATOM   1409  OG  SER   197      26.461  60.772   9.858  1.00 18.23      A    O  
ATOM   1410  C   SER   197      24.242  59.537  11.079  1.00 13.78      A    C  
ATOM   1411  O   SER   197      23.646  59.401  10.007  1.00 13.97      A    O  
ATOM   1412  N   CYS   198      23.705  60.116  12.144  1.00 13.16      A    N  
ATOM   1413  CA  CYS   198      22.302  60.558  12.139  1.00 13.65      A    C  
ATOM   1414  CB  CYS   198      21.353  59.382  12.389  1.00 13.61      A    C  
ATOM   1415  SG  CYS   198      21.509  58.584  14.007  1.00 14.33      A    S  
ATOM   1416  C   CYS   198      22.010  61.678  13.128  1.00 13.53      A    C  
ATOM   1417  O   CYS   198      22.767  61.933  14.060  1.00 13.00      A    O  
ATOM   1418  N   ARG   199      20.892  62.364  12.925  1.00 13.13      A    N  
ATOM   1419  CA  ARG   199      20.540  63.455  13.826  1.00 13.43      A    C  
ATOM   1420  CB  ARG   199      19.746  64.518  13.055  1.00 14.01      A    C  
ATOM   1421  CG  ARG   199      19.304  65.698  13.885  1.00 15.90      A    C  
ATOM   1422  CD  ARG   199      18.369  66.620  13.076  1.00 17.46      A    C  
ATOM   1423  NE  ARG   199      17.089  65.989  12.728  1.00 19.34      A    N  
ATOM   1424  CZ  ARG   199      15.982  66.055  13.471  1.00 19.42      A    C  
ATOM   1425  NH1 ARG   199      15.968  66.733  14.612  1.00 21.71      A    N  
ATOM   1426  NH2 ARG   199      14.877  65.449  13.059  1.00 19.05      A    N  
ATOM   1427  C   ARG   199      19.737  62.938  15.022  1.00 12.85      A    C  
ATOM   1428  O   ARG   199      19.931  63.371  16.153  1.00 13.63      A    O  
ATOM   1429  N   VAL   200      18.833  62.006  14.757  1.00 12.54      A    N  
ATOM   1430  CA  VAL   200      17.954  61.466  15.784  1.00 12.29      A    C  
ATOM   1431  CB  VAL   200      16.479  61.745  15.431  1.00 12.66      A    C  
ATOM   1432  CG1 VAL   200      15.559  60.936  16.316  1.00 13.14      A    C  
ATOM   1433  CG2 VAL   200      16.178  63.230  15.586  1.00 12.74      A    C  
ATOM   1434  C   VAL   200      18.160  59.963  15.875  1.00 10.71      A    C  
ATOM   1435  O   VAL   200      18.263  59.305  14.858  1.00 10.98      A    O  
ATOM   1436  N   LEU   201      18.227  59.441  17.095  1.00 10.20      A    N  
ATOM   1437  CA  LEU   201      18.374  57.997  17.309  1.00  9.78      A    C  
ATOM   1438  CB  LEU   201      19.724  57.686  17.957  1.00  9.15      A    C  
ATOM   1439  CG  LEU   201      20.035  56.192  18.146  1.00  9.59      A    C  
ATOM   1440  CD1 LEU   201      19.935  55.405  16.828  1.00 13.48      A    C  
ATOM   1441  CD2 LEU   201      21.396  56.032  18.799  1.00 10.99      A    C  
ATOM   1442  C   LEU   201      17.288  57.474  18.229  1.00  9.04      A    C  
ATOM   1443  O   LEU   201      17.150  57.940  19.348  1.00 10.07      A    O  
ATOM   1444  N   ILE   202      16.556  56.463  17.769  1.00  9.03      A    N  
ATOM   1445  CA  ILE   202      15.549  55.818  18.598  1.00  8.77      A    C  
ATOM   1446  CB  ILE   202      14.187  55.717  17.900  1.00  9.02      A    C  
ATOM   1447  CG1 ILE   202      13.730  57.073  17.344  1.00 10.37      A    C  
ATOM   1448  CD1 ILE   202      13.604  58.141  18.384  1.00  9.20      A    C  
ATOM   1449  CG2 ILE   202      13.136  55.128  18.844  1.00 10.32      A    C  
ATOM   1450  C   ILE   202      16.027  54.389  18.860  1.00  7.84      A    C  
ATOM   1451  O   ILE   202      16.199  53.596  17.934  1.00  7.98      A    O  
ATOM   1452  N   ASN   203      16.245  54.083  20.122  1.00  8.20      A    N  
ATOM   1453  CA  ASN   203      16.652  52.743  20.538  1.00  8.37      A    C  
ATOM   1454  CB  ASN   203      17.694  52.858  21.657  1.00  8.39      A    C  
ATOM   1455  CG  ASN   203      17.922  51.553  22.401  1.00  8.59      A    C  
ATOM   1456  OD1 ASN   203      17.550  50.486  21.940  1.00  8.93      A    O  
ATOM   1457  ND2 ASN   203      18.553  51.647  23.571  1.00  9.50      A    N  
ATOM   1458  C   ASN   203      15.397  51.984  20.984  1.00  7.68      A    C  
ATOM   1459  O   ASN   203      14.888  52.183  22.098  1.00  7.64      A    O  
ATOM   1460  N   ALA   204      14.887  51.160  20.074  1.00  8.08      A    N  
ATOM   1461  CA  ALA   204      13.676  50.382  20.278  1.00  7.97      A    C  
ATOM   1462  CB  ALA   204      12.617  50.733  19.203  1.00  7.84      A    C  
ATOM   1463  C   ALA   204      14.055  48.906  20.221  1.00  8.03      A    C  
ATOM   1464  O   ALA   204      13.329  48.084  19.673  1.00  8.35      A    O  
ATOM   1465  N   ALA   205      15.205  48.581  20.810  1.00  8.09      A    N  
ATOM   1466  CA  ALA   205      15.783  47.246  20.649  1.00  8.95      A    C  
ATOM   1467  CB  ALA   205      17.323  47.335  20.785  1.00  8.85      A    C  
ATOM   1468  C   ALA   205      15.215  46.155  21.572  1.00  9.22      A    C  
ATOM   1469  O   ALA   205      15.742  45.027  21.623  1.00  8.90      A    O  
ATOM   1470  N   GLY   206      14.148  46.473  22.303  1.00  8.62      A    N  
ATOM   1471  CA  GLY   206      13.441  45.455  23.082  1.00  9.18      A    C  
ATOM   1472  C   GLY   206      14.242  44.835  24.216  1.00  9.37      A    C  
ATOM   1473  O   GLY   206      14.713  45.534  25.108  1.00  9.50      A    O  
ATOM   1474  N   LEU   207      14.366  43.508  24.188  1.00 10.01      A    N  
ATOM   1475  CA  LEU   207      15.168  42.779  25.166  1.00 11.08      A    C  
ATOM   1476  CB  LEU   207      15.341  41.325  24.703  1.00 10.79      A    C  
ATOM   1477  CG  LEU   207      14.086  40.490  24.532  1.00 14.13      A    C  
ATOM   1478  CD1 LEU   207      14.495  39.061  24.245  1.00 15.21      A    C  
ATOM   1479  CD2 LEU   207      13.256  40.564  25.800  1.00 15.53      A    C  
ATOM   1480  C   LEU   207      16.565  43.363  25.332  1.00 10.50      A    C  
ATOM   1481  O   LEU   207      17.194  43.224  26.401  1.00 11.39      A    O  
ATOM   1482  N   HIS   208      17.064  43.974  24.261  1.00  9.20      A    N  
ATOM   1483  CA  HIS   208      18.441  44.424  24.218  1.00  8.94      A    C  
ATOM   1484  CB  HIS   208      19.105  43.942  22.930  1.00  9.54      A    C  
ATOM   1485  CG  HIS   208      19.232  42.457  22.868  1.00 11.80      A    C  
ATOM   1486  ND1 HIS   208      20.119  41.767  23.659  1.00 17.06      A    N  
ATOM   1487  CE1 HIS   208      20.003  40.473  23.421  1.00 16.40      A    C  
ATOM   1488  NE2 HIS   208      19.063  40.303  22.513  1.00 15.08      A    N  
ATOM   1489  CD2 HIS   208      18.547  41.528  22.166  1.00 14.31      A    C  
ATOM   1490  C   HIS   208      18.590  45.914  24.354  1.00  8.24      A    C  
ATOM   1491  O   HIS   208      19.693  46.431  24.272  1.00  7.88      A    O  
ATOM   1492  N   ALA   209      17.491  46.621  24.599  1.00  7.48      A    N  
ATOM   1493  CA  ALA   209      17.611  48.071  24.654  1.00  7.41      A    C  
ATOM   1494  CB  ALA   209      16.193  48.767  24.727  1.00  8.13      A    C  
ATOM   1495  C   ALA   209      18.562  48.604  25.741  1.00  7.41      A    C  
ATOM   1496  O   ALA   209      19.333  49.533  25.484  1.00  7.52      A    O  
ATOM   1497  N   PRO   210      18.484  48.065  26.966  1.00  6.70      A    N  
ATOM   1498  CA  PRO   210      19.398  48.607  27.994  1.00  6.94      A    C  
ATOM   1499  CB  PRO   210      18.953  47.884  29.264  1.00  6.78      A    C  
ATOM   1500  CG  PRO   210      17.477  47.528  28.989  1.00  6.88      A    C  
ATOM   1501  CD  PRO   210      17.471  47.149  27.541  1.00  6.88      A    C  
ATOM   1502  C   PRO   210      20.876  48.325  27.692  1.00  7.62      A    C  
ATOM   1503  O   PRO   210      21.725  49.223  27.831  1.00  8.12      A    O  
ATOM   1504  N   GLY   211      21.164  47.109  27.247  1.00  7.83      A    N  
ATOM   1505  CA  GLY   211      22.535  46.752  26.915  1.00  7.75      A    C  
ATOM   1506  C   GLY   211      23.031  47.566  25.745  1.00  7.91      A    C  
ATOM   1507  O   GLY   211      24.186  47.983  25.703  1.00  8.44      A    O  
ATOM   1508  N   LEU   212      22.143  47.820  24.794  1.00  7.61      A    N  
ATOM   1509  CA  LEU   212      22.512  48.622  23.633  1.00  7.74      A    C  
ATOM   1510  CB  LEU   212      21.436  48.570  22.557  1.00  7.89      A    C  
ATOM   1511  CG  LEU   212      21.705  49.413  21.301  1.00  7.60      A    C  
ATOM   1512  CD1 LEU   212      23.016  49.006  20.629  1.00  9.65      A    C  
ATOM   1513  CD2 LEU   212      20.533  49.272  20.355  1.00  8.22      A    C  
ATOM   1514  C   LEU   212      22.791  50.056  24.048  1.00  7.66      A    C  
ATOM   1515  O   LEU   212      23.723  50.670  23.558  1.00  7.84      A    O  
ATOM   1516  N   ALA   213      21.984  50.606  24.951  1.00  7.71      A    N  
ATOM   1517  CA  ALA   213      22.288  51.968  25.437  1.00  8.99      A    C  
ATOM   1518  CB  ALA   213      21.227  52.432  26.418  1.00  9.47      A    C  
ATOM   1519  C   ALA   213      23.686  52.047  26.062  1.00  8.46      A    C  
ATOM   1520  O   ALA   213      24.410  53.014  25.880  1.00  9.13      A    O  
ATOM   1521  N   ARG   214      24.073  51.000  26.781  1.00  9.00      A    N  
ATOM   1522  CA  ARG   214      25.387  50.963  27.392  1.00  9.47      A    C  
ATOM   1523  CB  ARG   214      25.490  49.759  28.333  1.00  9.19      A    C  
ATOM   1524  CG  ARG   214      26.846  49.622  29.014  1.00 12.69      A    C  
ATOM   1525  CD  ARG   214      27.115  50.790  29.974  1.00 16.75      A    C  
ATOM   1526  NE  ARG   214      28.464  50.719  30.532  1.00 19.03      A    N  
ATOM   1527  CZ  ARG   214      29.546  51.176  29.911  1.00 18.83      A    C  
ATOM   1528  NH1 ARG   214      29.426  51.726  28.720  1.00 18.92      A    N  
ATOM   1529  NH2 ARG   214      30.753  51.075  30.474  1.00 17.01      A    N  
ATOM   1530  C   ARG   214      26.487  50.910  26.311  1.00  9.83      A    C  
ATOM   1531  O   ARG   214      27.655  51.227  26.581  1.00 10.62      A    O  
ATOM   1532  N   ARG   215      26.115  50.507  25.104  1.00  9.86      A    N  
ATOM   1533  CA  ARG   215      27.077  50.438  23.990  1.00 10.74      A    C  
ATOM   1534  CB  ARG   215      26.759  49.243  23.082  1.00 10.72      A    C  
ATOM   1535  CG  ARG   215      26.999  47.900  23.784  1.00 11.69      A    C  
ATOM   1536  CD  ARG   215      26.810  46.732  22.814  1.00 11.45      A    C  
ATOM   1537  NE  ARG   215      25.406  46.368  22.525  1.00 12.73      A    N  
ATOM   1538  CZ  ARG   215      24.625  45.579  23.276  1.00 15.53      A    C  
ATOM   1539  NH1 ARG   215      25.019  45.086  24.459  1.00 17.00      A    N  
ATOM   1540  NH2 ARG   215      23.397  45.310  22.863  1.00 17.23      A    N  
ATOM   1541  C   ARG   215      27.151  51.731  23.177  1.00 11.21      A    C  
ATOM   1542  O   ARG   215      27.825  51.787  22.141  1.00 10.82      A    O  
ATOM   1543  N   ILE   216      26.442  52.764  23.634  1.00 11.14      A    N  
ATOM   1544  CA  ILE   216      26.522  54.064  22.991  1.00 11.93      A    C  
ATOM   1545  CB  ILE   216      25.128  54.655  22.678  1.00 12.14      A    C  
ATOM   1546  CG1 ILE   216      24.269  53.654  21.887  1.00 13.07      A    C  
ATOM   1547  CD1 ILE   216      24.841  53.271  20.606  1.00 15.02      A    C  
ATOM   1548  CG2 ILE   216      25.289  55.973  21.908  1.00 11.88      A    C  
ATOM   1549  C   ILE   216      27.221  55.029  23.931  1.00 12.85      A    C  
ATOM   1550  O   ILE   216      26.660  55.409  24.958  1.00 12.73      A    O  
ATOM   1551  N   GLU   217      28.447  55.414  23.590  1.00 14.04      A    N  
ATOM   1552  CA  GLU   217      29.184  56.384  24.393  1.00 15.53      A    C  
ATOM   1553  CB  GLU   217      30.568  56.656  23.802  1.00 15.92      A    C  
ATOM   1554  CG  GLU   217      31.439  55.460  23.526  1.00 20.85      A    C  
ATOM   1555  CD  GLU   217      32.748  55.894  22.888  1.00 25.38      A    C  
ATOM   1556  OE1 GLU   217      33.386  56.827  23.434  1.00 27.71      A    O  
ATOM   1557  OE2 GLU   217      33.120  55.340  21.830  1.00 28.41      A    O  
ATOM   1558  C   GLU   217      28.430  57.701  24.432  1.00 15.44      A    C  
ATOM   1559  O   GLU   217      27.964  58.193  23.396  1.00 15.76      A    O  
ATOM   1560  N   GLY   218      28.322  58.278  25.623  1.00 15.55      A    N  
ATOM   1561  CA  GLY   218      27.629  59.549  25.763  1.00 15.38      A    C  
ATOM   1562  C   GLY   218      26.256  59.414  26.402  1.00 14.83      A    C  
ATOM   1563  O   GLY   218      25.655  60.407  26.805  1.00 15.66      A    O  
ATOM   1564  N   ILE   219      25.738  58.196  26.491  1.00 14.36      A    N  
ATOM   1565  CA  ILE   219      24.507  57.981  27.258  1.00 13.63      A    C  
ATOM   1566  CB  ILE   219      23.720  56.762  26.737  1.00 13.20      A    C  
ATOM   1567  CG1 ILE   219      23.383  56.947  25.259  1.00 12.65      A    C  
ATOM   1568  CD1 ILE   219      22.522  55.819  24.641  1.00 11.72      A    C  
ATOM   1569  CG2 ILE   219      22.481  56.531  27.603  1.00 13.03      A    C  
ATOM   1570  C   ILE   219      24.870  57.738  28.723  1.00 14.02      A    C  
ATOM   1571  O   ILE   219      25.614  56.810  29.028  1.00 13.55      A    O  
ATOM   1572  N   PRO   220      24.356  58.565  29.649  1.00 13.92      A    N  
ATOM   1573  CA  PRO   220      24.803  58.390  31.036  1.00 14.13      A    C  
ATOM   1574  CB  PRO   220      23.957  59.410  31.804  1.00 14.37      A    C  
ATOM   1575  CG  PRO   220      23.595  60.440  30.772  1.00 14.39      A    C  
ATOM   1576  CD  PRO   220      23.421  59.697  29.497  1.00 14.34      A    C  
ATOM   1577  C   PRO   220      24.544  56.977  31.571  1.00 14.69      A    C  
ATOM   1578  O   PRO   220      23.426  56.480  31.479  1.00 14.21      A    O  
ATOM   1579  N   ARG   221      25.565  56.337  32.133  1.00 15.12      A    N  
ATOM   1580  CA  ARG   221      25.393  54.954  32.591  1.00 15.77      A    C  
ATOM   1581  CB  ARG   221      26.740  54.327  32.944  1.00 16.21      A    C  
ATOM   1582  CG  ARG   221      27.657  54.279  31.760  1.00 19.37      A    C  
ATOM   1583  CD  ARG   221      29.022  53.739  32.141  1.00 23.16      A    C  
ATOM   1584  NE  ARG   221      29.941  53.847  31.016  1.00 27.81      A    N  
ATOM   1585  CZ  ARG   221      30.828  54.824  30.866  1.00 30.65      A    C  
ATOM   1586  NH1 ARG   221      30.918  55.786  31.779  1.00 32.89      A    N  
ATOM   1587  NH2 ARG   221      31.627  54.834  29.807  1.00 31.61      A    N  
ATOM   1588  C   ARG   221      24.430  54.824  33.763  1.00 16.47      A    C  
ATOM   1589  O   ARG   221      23.794  53.783  33.936  1.00 15.20      A    O  
ATOM   1590  N   ASP   222      24.306  55.874  34.572  1.00 17.16      A    N  
ATOM   1591  CA  ASP   222      23.375  55.801  35.692  1.00 19.11      A    C  
ATOM   1592  CB  ASP   222      23.709  56.840  36.789  1.00 19.64      A    C  
ATOM   1593  CG  ASP   222      23.653  58.271  36.293  1.00 23.52      A    C  
ATOM   1594  OD1 ASP   222      23.065  58.536  35.223  1.00 26.62      A    O  
ATOM   1595  OD2 ASP   222      24.207  59.158  36.992  1.00 29.09      A    O  
ATOM   1596  C   ASP   222      21.902  55.879  35.257  1.00 18.79      A    C  
ATOM   1597  O   ASP   222      21.004  55.567  36.042  1.00 20.87      A    O  
ATOM   1598  N   SER   223      21.656  56.272  34.015  1.00 18.16      A    N  
ATOM   1599  CA  SER   223      20.290  56.390  33.488  1.00 17.11      A    C  
ATOM   1600  CB  SER   223      20.219  57.467  32.377  1.00 17.33      A    C  
ATOM   1601  OG  SER   223      20.706  57.016  31.092  1.00 17.09      A    O  
ATOM   1602  C   SER   223      19.755  55.061  32.957  1.00 16.25      A    C  
ATOM   1603  O   SER   223      18.566  54.931  32.666  1.00 16.02      A    O  
ATOM   1604  N   ILE   224      20.641  54.087  32.783  1.00 14.35      A    N  
ATOM   1605  CA  ILE   224      20.266  52.866  32.073  1.00 14.06      A    C  
ATOM   1606  CB  ILE   224      21.425  52.377  31.184  1.00 13.42      A    C  
ATOM   1607  CG1 ILE   224      21.955  53.519  30.317  1.00 13.48      A    C  
ATOM   1608  CD1 ILE   224      23.278  53.178  29.555  1.00 14.75      A    C  
ATOM   1609  CG2 ILE   224      20.973  51.196  30.311  1.00 14.05      A    C  
ATOM   1610  C   ILE   224      19.903  51.759  33.048  1.00 14.44      A    C  
ATOM   1611  O   ILE   224      20.720  51.386  33.879  1.00 14.31      A    O  
ATOM   1612  N   PRO   225      18.678  51.210  32.942  1.00 14.92      A    N  
ATOM   1613  CA  PRO   225      18.260  50.130  33.847  1.00 15.89      A    C  
ATOM   1614  CB  PRO   225      16.753  50.016  33.570  1.00 15.86      A    C  
ATOM   1615  CG  PRO   225      16.613  50.457  32.143  1.00 15.53      A    C  
ATOM   1616  CD  PRO   225      17.620  51.568  31.977  1.00 14.98      A    C  
ATOM   1617  C   PRO   225      18.969  48.803  33.560  1.00 16.42      A    C  
ATOM   1618  O   PRO   225      19.573  48.631  32.494  1.00 16.92      A    O  
ATOM   1619  N   PRO   226      18.947  47.877  34.528  1.00 17.30      A    N  
ATOM   1620  CA  PRO   226      19.551  46.559  34.305  1.00 18.02      A    C  
ATOM   1621  CB  PRO   226      19.604  45.934  35.710  1.00 17.82      A    C  
ATOM   1622  CG  PRO   226      18.649  46.759  36.560  1.00 18.52      A    C  
ATOM   1623  CD  PRO   226      18.459  48.084  35.900  1.00 17.38      A    C  
ATOM   1624  C   PRO   226      18.660  45.766  33.343  1.00 18.20      A    C  
ATOM   1625  O   PRO   226      17.467  46.069  33.226  1.00 19.50      A    O  
ATOM   1626  N   GLU   227      19.240  44.824  32.602  1.00 17.79      A    N  
ATOM   1627  CA  GLU   227      18.504  44.119  31.564  1.00 17.57      A    C  
ATOM   1628  CB  GLU   227      19.393  44.052  30.323  1.00 18.16      A    C  
ATOM   1629  CG  GLU   227      18.828  43.351  29.100  1.00 19.27      A    C  
ATOM   1630  CD  GLU   227      19.810  43.380  27.923  1.00 21.02      A    C  
ATOM   1631  OE1 GLU   227      20.648  44.303  27.863  1.00 15.20      A    O  
ATOM   1632  OE2 GLU   227      19.731  42.479  27.061  1.00 24.76      A    O  
ATOM   1633  C   GLU   227      18.165  42.706  32.067  1.00 17.55      A    C  
ATOM   1634  O   GLU   227      19.070  41.859  32.133  1.00 17.14      A    O  
ATOM   1635  N   TYR   228      16.903  42.446  32.448  1.00 16.08      A    N  
ATOM   1636  CA  TYR   228      16.514  41.076  32.876  1.00 15.05      A    C  
ATOM   1637  CB  TYR   228      15.735  41.023  34.203  1.00 14.76      A    C  
ATOM   1638  CG  TYR   228      16.276  41.816  35.388  1.00 15.14      A    C  
ATOM   1639  CD1 TYR   228      17.088  41.220  36.346  1.00 13.64      A    C  
ATOM   1640  CE1 TYR   228      17.550  41.942  37.441  1.00 13.97      A    C  
ATOM   1641  CZ  TYR   228      17.189  43.272  37.592  1.00 16.03      A    C  
ATOM   1642  OH  TYR   228      17.642  44.003  38.674  1.00 17.70      A    O  
ATOM   1643  CE2 TYR   228      16.367  43.880  36.667  1.00 15.34      A    C  
ATOM   1644  CD2 TYR   228      15.913  43.151  35.573  1.00 15.34      A    C  
ATOM   1645  C   TYR   228      15.647  40.405  31.810  1.00 14.44      A    C  
ATOM   1646  O   TYR   228      15.128  41.067  30.911  1.00 14.49      A    O  
ATOM   1647  N   LEU   229      15.489  39.093  31.927  1.00 13.32      A    N  
ATOM   1648  CA  LEU   229      14.704  38.316  30.970  1.00 12.69      A    C  
ATOM   1649  CB  LEU   229      15.624  37.410  30.137  1.00 12.91      A    C  
ATOM   1650  CG  LEU   229      16.713  38.104  29.320  1.00 13.86      A    C  
ATOM   1651  CD1 LEU   229      17.614  37.056  28.648  1.00 15.17      A    C  
ATOM   1652  CD2 LEU   229      16.093  39.053  28.283  1.00 14.82      A    C  
ATOM   1653  C   LEU   229      13.694  37.447  31.702  1.00 12.18      A    C  
ATOM   1654  O   LEU   229      14.059  36.702  32.600  1.00 11.13      A    O  
ATOM   1655  N   CYS   230      12.418  37.551  31.320  1.00 10.88      A    N  
ATOM   1656  CA  CYS   230      11.374  36.735  31.931  1.00 11.08      A    C  
ATOM   1657  CB  CYS   230      10.411  37.568  32.793  1.00 11.08      A    C  
ATOM   1658  SG  CYS   230       9.250  36.533  33.681  1.00 14.08      A    S  
ATOM   1659  C   CYS   230      10.608  36.025  30.832  1.00 10.66      A    C  
ATOM   1660  O   CYS   230       9.745  36.610  30.179  1.00 11.14      A    O  
ATOM   1661  N   LYS   231      10.937  34.756  30.624  1.00 10.29      A    N  
ATOM   1662  CA  LYS   231      10.368  33.967  29.558  1.00  9.63      A    C  
ATOM   1663  CB  LYS   231      11.241  32.718  29.365  1.00  9.58      A    C  
ATOM   1664  CG  LYS   231      10.856  31.787  28.219  1.00 10.04      A    C  
ATOM   1665  CD  LYS   231      11.997  30.778  28.038  1.00 10.56      A    C  
ATOM   1666  CE  LYS   231      11.748  29.766  26.939  1.00 11.08      A    C  
ATOM   1667  NZ  LYS   231      12.935  28.823  26.874  1.00 11.14      A    N  
ATOM   1668  C   LYS   231       8.926  33.562  29.848  1.00  9.99      A    C  
ATOM   1669  O   LYS   231       8.500  33.465  31.008  1.00  9.09      A    O  
ATOM   1670  N   GLY   232       8.178  33.324  28.778  1.00 10.35      A    N  
ATOM   1671  CA  GLY   232       6.808  32.826  28.886  1.00 10.08      A    C  
ATOM   1672  C   GLY   232       6.544  31.773  27.822  1.00  9.90      A    C  
ATOM   1673  O   GLY   232       6.889  31.947  26.656  1.00 10.29      A    O  
ATOM   1674  N   SER   233       5.935  30.681  28.237  1.00  9.00      A    N  
ATOM   1675  CA  SER   233       5.628  29.575  27.322  1.00  9.36      A    C  
ATOM   1676  CB  SER   233       6.169  28.264  27.884  1.00  9.85      A    C  
ATOM   1677  OG  SER   233       7.594  28.307  27.972  1.00 10.35      A    O  
ATOM   1678  C   SER   233       4.126  29.446  27.139  1.00  9.52      A    C  
ATOM   1679  O   SER   233       3.358  29.584  28.101  1.00  8.77      A    O  
ATOM   1680  N   TYR   234       3.729  29.161  25.904  1.00  9.82      A    N  
ATOM   1681  CA  TYR   234       2.329  28.898  25.569  1.00  9.97      A    C  
ATOM   1682  CB  TYR   234       1.892  29.765  24.397  1.00 10.24      A    C  
ATOM   1683  CG  TYR   234       1.810  31.257  24.618  1.00 10.05      A    C  
ATOM   1684  CD1 TYR   234       0.588  31.870  24.924  1.00 11.14      A    C  
ATOM   1685  CE1 TYR   234       0.492  33.248  25.099  1.00 12.66      A    C  
ATOM   1686  CZ  TYR   234       1.615  34.033  24.938  1.00 13.31      A    C  
ATOM   1687  OH  TYR   234       1.518  35.410  25.101  1.00 14.00      A    O  
ATOM   1688  CE2 TYR   234       2.834  33.457  24.629  1.00 12.53      A    C  
ATOM   1689  CD2 TYR   234       2.934  32.064  24.471  1.00 12.37      A    C  
ATOM   1690  C   TYR   234       2.158  27.456  25.098  1.00 10.53      A    C  
ATOM   1691  O   TYR   234       3.051  26.898  24.445  1.00 10.21      A    O  
ATOM   1692  N   PHE   235       0.994  26.888  25.385  1.00 10.27      A    N  
ATOM   1693  CA  PHE   235       0.609  25.583  24.859  1.00 11.24      A    C  
ATOM   1694  CB  PHE   235       0.581  24.562  25.987  1.00 11.15      A    C  
ATOM   1695  CG  PHE   235       1.929  24.390  26.604  1.00 12.28      A    C  
ATOM   1696  CD1 PHE   235       2.827  23.487  26.062  1.00 11.31      A    C  
ATOM   1697  CE1 PHE   235       4.105  23.345  26.609  1.00 12.46      A    C  
ATOM   1698  CZ  PHE   235       4.499  24.155  27.670  1.00 12.52      A    C  
ATOM   1699  CE2 PHE   235       3.608  25.073  28.199  1.00 13.39      A    C  
ATOM   1700  CD2 PHE   235       2.339  25.199  27.650  1.00 11.84      A    C  
ATOM   1701  C   PHE   235      -0.701  25.693  24.145  1.00 11.95      A    C  
ATOM   1702  O   PHE   235      -1.514  26.550  24.463  1.00 12.43      A    O  
ATOM   1703  N   THR   236      -0.892  24.839  23.150  1.00 12.35      A    N  
ATOM   1704  CA  THR   236      -2.040  24.959  22.281  1.00 12.91      A    C  
ATOM   1705  CB  THR   236      -1.617  25.096  20.816  1.00 12.85      A    C  
ATOM   1706  OG1 THR   236      -0.869  23.935  20.432  1.00 14.79      A    O  
ATOM   1707  CG2 THR   236      -0.759  26.369  20.609  1.00 13.66      A    C  
ATOM   1708  C   THR   236      -2.992  23.785  22.460  1.00 13.85      A    C  
ATOM   1709  O   THR   236      -2.622  22.726  22.976  1.00 13.49      A    O  
ATOM   1710  N   LEU   237      -4.235  23.997  22.050  1.00 14.70      A    N  
ATOM   1711  CA  LEU   237      -5.272  22.996  22.164  1.00 16.57      A    C  
ATOM   1712  CB  LEU   237      -6.407  23.511  23.054  1.00 16.03      A    C  
ATOM   1713  CG  LEU   237      -7.596  22.577  23.295  1.00 16.60      A    C  
ATOM   1714  CD1 LEU   237      -7.296  21.552  24.388  1.00 14.34      A    C  
ATOM   1715  CD2 LEU   237      -8.818  23.386  23.687  1.00 16.05      A    C  
ATOM   1716  C   LEU   237      -5.783  22.717  20.758  1.00 18.19      A    C  
ATOM   1717  O   LEU   237      -6.296  23.612  20.087  1.00 18.01      A    O  
ATOM   1718  N   ALA   238      -5.606  21.483  20.304  1.00 20.35      A    N  
ATOM   1719  CA  ALA   238      -6.154  21.067  19.021  1.00 22.96      A    C  
ATOM   1720  CB  ALA   238      -5.573  19.715  18.604  1.00 22.72      A    C  
ATOM   1721  C   ALA   238      -7.670  20.985  19.103  1.00 24.35      A    C  
ATOM   1722  O   ALA   238      -8.237  20.646  20.142  1.00 25.10      A    O  
ATOM   1723  N   GLY   239      -8.338  21.295  18.002  1.00 26.36      A    N  
ATOM   1724  CA  GLY   239      -9.763  21.013  17.913  1.00 27.67      A    C  
ATOM   1725  C   GLY   239     -10.698  22.091  18.429  1.00 28.61      A    C  
ATOM   1726  O   GLY   239     -11.655  21.801  19.148  1.00 29.28      A    O  
ATOM   1727  N   ARG   240     -10.440  23.340  18.061  1.00 29.10           N  
ATOM   1728  CA  ARG   240     -11.454  24.383  18.262  1.00 29.55           C  
ATOM   1729  CB  ARG   240     -12.710  24.092  17.430  1.00 30.53           C  
ATOM   1730  CG  ARG   240     -12.474  24.085  15.925  1.00 33.58           C  
ATOM   1731  CD  ARG   240     -13.762  23.880  15.149  1.00 38.33           C  
ATOM   1732  NE  ARG   240     -13.495  23.869  13.714  1.00 41.74           N  
ATOM   1733  CZ  ARG   240     -14.407  24.096  12.772  1.00 43.52           C  
ATOM   1734  NH1 ARG   240     -15.671  24.360  13.105  1.00 44.69           N  
ATOM   1735  NH2 ARG   240     -14.051  24.066  11.490  1.00 43.91           N  
ATOM   1736  C   ARG   240     -11.832  24.549  19.739  1.00 28.00           C  
ATOM   1737  O   ARG   240     -12.019  23.574  20.478  1.00 28.31      A    O  
ATOM   1738  N   ALA   241     -11.964  25.806  20.141  1.00 26.48      A    N  
ATOM   1739  CA  ALA   241     -11.861  26.187  21.535  1.00 23.91      A    C  
ATOM   1740  CB  ALA   241     -11.409  27.635  21.645  1.00 23.72      A    C  
ATOM   1741  C   ALA   241     -13.132  25.949  22.341  1.00 22.42      A    C  
ATOM   1742  O   ALA   241     -14.230  25.928  21.794  1.00 22.61      A    O  
ATOM   1743  N   PRO   242     -12.979  25.758  23.655  1.00 20.76      A    N  
ATOM   1744  CA  PRO   242     -14.138  25.532  24.494  1.00 19.21      A    C  
ATOM   1745  CB  PRO   242     -13.541  24.895  25.752  1.00 19.39      A    C  
ATOM   1746  CG  PRO   242     -12.134  25.379  25.811  1.00 20.04      A    C  
ATOM   1747  CD  PRO   242     -11.704  25.592  24.385  1.00 20.59      A    C  
ATOM   1748  C   PRO   242     -14.856  26.844  24.850  1.00 17.67      A    C  
ATOM   1749  O   PRO   242     -15.957  26.801  25.390  1.00 16.99      A    O  
ATOM   1750  N   PHE   243     -14.235  27.983  24.528  1.00 15.95      A    N  
ATOM   1751  CA  PHE   243     -14.766  29.293  24.913  1.00 14.67      A    C  
ATOM   1752  CB  PHE   243     -13.920  29.905  26.044  1.00 15.00      A    C  
ATOM   1753  CG  PHE   243     -13.950  29.112  27.324  1.00 15.67      A    C  
ATOM   1754  CD1 PHE   243     -15.092  29.062  28.094  1.00 18.34      A    C  
ATOM   1755  CE1 PHE   243     -15.122  28.326  29.287  1.00 20.63      A    C  
ATOM   1756  CZ  PHE   243     -14.010  27.635  29.693  1.00 19.05      A    C  
ATOM   1757  CE2 PHE   243     -12.865  27.676  28.938  1.00 19.00      A    C  
ATOM   1758  CD2 PHE   243     -12.835  28.420  27.751  1.00 18.95      A    C  
ATOM   1759  C   PHE   243     -14.781  30.240  23.722  1.00 13.78      A    C  
ATOM   1760  O   PHE   243     -13.987  30.084  22.784  1.00 13.18      A    O  
ATOM   1761  N   SER   244     -15.669  31.232  23.775  1.00 12.52      A    N  
ATOM   1762  CA  SER   244     -15.759  32.234  22.717  1.00 11.90      A    C  
ATOM   1763  CB  SER   244     -17.221  32.484  22.335  1.00 12.90      A    C  
ATOM   1764  OG  SER   244     -17.848  33.361  23.254  1.00 15.35      A    O  
ATOM   1765  C   SER   244     -15.059  33.551  23.088  1.00 10.91      A    C  
ATOM   1766  O   SER   244     -14.860  34.409  22.236  1.00 10.95      A    O  
ATOM   1767  N   ARG   245     -14.731  33.699  24.369  1.00  9.65      A    N  
ATOM   1768  CA  ARG   245     -14.036  34.882  24.894  1.00  8.30      A    C  
ATOM   1769  CB  ARG   245     -14.911  35.562  25.960  1.00  8.39      A    C  
ATOM   1770  CG  ARG   245     -16.202  36.209  25.429  1.00 10.64      A    C  
ATOM   1771  CD  ARG   245     -17.111  36.590  26.583  1.00 15.14      A    C  
ATOM   1772  NE  ARG   245     -18.334  37.245  26.104  1.00 15.71      A    N  
ATOM   1773  CZ  ARG   245     -19.429  36.586  25.752  1.00 17.46      A    C  
ATOM   1774  NH1 ARG   245     -19.447  35.253  25.794  1.00 18.23      A    N  
ATOM   1775  NH2 ARG   245     -20.500  37.252  25.340  1.00 18.18      A    N  
ATOM   1776  C   ARG   245     -12.728  34.434  25.539  1.00  7.69      A    C  
ATOM   1777  O   ARG   245     -12.555  33.255  25.883  1.00  7.79      A    O  
ATOM   1778  N   LEU   246     -11.809  35.383  25.711  1.00  6.72      A    N  
ATOM   1779  CA  LEU   246     -10.589  35.142  26.482  1.00  6.91      A    C  
ATOM   1780  CB  LEU   246      -9.657  36.349  26.374  1.00  6.90      A    C  
ATOM   1781  CG  LEU   246      -9.406  36.891  24.966  1.00  7.52      A    C  
ATOM   1782  CD1 LEU   246      -8.399  38.008  25.075  1.00  7.96      A    C  
ATOM   1783  CD2 LEU   246      -8.882  35.808  24.008  1.00  7.60      A    C  
ATOM   1784  C   LEU   246     -10.946  34.918  27.944  1.00  6.90      A    C  
ATOM   1785  O   LEU   246     -11.898  35.516  28.459  1.00  6.64      A    O  
ATOM   1786  N   ILE   247     -10.188  34.049  28.622  1.00  6.47      A    N  
ATOM   1787  CA  ILE   247     -10.391  33.828  30.046  1.00  7.04      A    C  
ATOM   1788  CB  ILE   247     -10.809  32.383  30.359  1.00  7.69      A    C  
ATOM   1789  CG1 ILE   247     -12.036  31.980  29.524  1.00  7.94      A    C  
ATOM   1790  CD1 ILE   247     -13.328  32.787  29.804  1.00  9.23      A    C  
ATOM   1791  CG2 ILE   247     -11.017  32.201  31.879  1.00  7.54      A    C  
ATOM   1792  C   ILE   247      -9.096  34.128  30.808  1.00  7.59      A    C  
ATOM   1793  O   ILE   247      -8.041  33.566  30.490  1.00  7.66      A    O  
ATOM   1794  N   TYR   248      -9.183  35.037  31.774  1.00  6.63      A    N  
ATOM   1795  CA  TYR   248      -8.061  35.387  32.656  1.00  7.52      A    C  
ATOM   1796  CB  TYR   248      -7.717  36.877  32.522  1.00  6.90      A    C  
ATOM   1797  CG  TYR   248      -6.871  37.252  31.325  1.00  6.89      A    C  
ATOM   1798  CD1 TYR   248      -7.283  36.959  30.031  1.00  8.25      A    C  
ATOM   1799  CE1 TYR   248      -6.493  37.307  28.918  1.00  7.50      A    C  
ATOM   1800  CZ  TYR   248      -5.300  37.970  29.107  1.00  8.26      A    C  
ATOM   1801  OH  TYR   248      -4.527  38.327  28.006  1.00  8.26      A    O  
ATOM   1802  CE2 TYR   248      -4.879  38.296  30.388  1.00  8.23      A    C  
ATOM   1803  CD2 TYR   248      -5.665  37.933  31.488  1.00  6.66      A    C  
ATOM   1804  C   TYR   248      -8.436  35.148  34.119  1.00  7.85      A    C  
ATOM   1805  O   TYR   248      -9.444  35.664  34.588  1.00  7.69      A    O  
ATOM   1806  N   PRO   249      -7.607  34.411  34.878  1.00  8.01      A    N  
ATOM   1807  CA  PRO   249      -7.784  34.403  36.333  1.00  8.05      A    C  
ATOM   1808  CB  PRO   249      -6.676  33.436  36.809  1.00  8.48      A    C  
ATOM   1809  CG  PRO   249      -6.459  32.531  35.608  1.00  8.53      A    C  
ATOM   1810  CD  PRO   249      -6.546  33.480  34.439  1.00  8.42      A    C  
ATOM   1811  C   PRO   249      -7.554  35.811  36.915  1.00  8.25      A    C  
ATOM   1812  O   PRO   249      -7.012  36.677  36.224  1.00  8.85      A    O  
ATOM   1813  N   VAL   250      -7.979  36.049  38.151  1.00  8.72      A    N  
ATOM   1814  CA  VAL   250      -7.806  37.380  38.754  1.00  9.24      A    C  
ATOM   1815  CB  VAL   250      -8.527  37.510  40.115  1.00  8.62      A    C  
ATOM   1816  CG1 VAL   250     -10.028  37.359  39.916  1.00  9.05      A    C  
ATOM   1817  CG2 VAL   250      -7.981  36.471  41.143  1.00  9.59      A    C  
ATOM   1818  C   VAL   250      -6.325  37.732  38.890  1.00 10.19      A    C  
ATOM   1819  O   VAL   250      -5.478  36.850  38.996  1.00 11.06      A    O  
ATOM   1820  N   PRO   251      -6.013  39.032  38.878  1.00 11.49      A    N  
ATOM   1821  CA  PRO   251      -4.615  39.468  38.860  1.00 12.67      A    C  
ATOM   1822  CB  PRO   251      -4.699  40.998  38.995  1.00 13.04      A    C  
ATOM   1823  CG  PRO   251      -6.090  41.374  38.662  1.00 13.39      A    C  
ATOM   1824  CD  PRO   251      -6.975  40.144  38.748  1.00 11.42      A    C  
ATOM   1825  C   PRO   251      -3.823  38.892  40.025  1.00 13.50      A    C  
ATOM   1826  O   PRO   251      -2.634  38.547  39.869  1.00 14.04      A    O  
ATOM   1827  N   GLN   252      -4.471  38.784  41.184  1.00 13.91      A    N  
ATOM   1828  CA  GLN   252      -3.800  38.367  42.401  1.00 15.27      A    C  
ATOM   1829  CB  GLN   252      -4.293  39.199  43.597  1.00 15.31      A    C  
ATOM   1830  CG  GLN   252      -3.215  39.549  44.587  1.00 17.01      A    C  
ATOM   1831  CD  GLN   252      -3.704  40.492  45.674  1.00 18.72      A    C  
ATOM   1832  OE1 GLN   252      -4.049  41.651  45.402  1.00 17.92      A    O  
ATOM   1833  NE2 GLN   252      -3.720  40.005  46.915  1.00 17.66      A    N  
ATOM   1834  C   GLN   252      -3.961  36.884  42.701  1.00 15.14      A    C  
ATOM   1835  O   GLN   252      -3.677  36.432  43.816  1.00 16.38      A    O  
ATOM   1836  N   HIS   253      -4.431  36.124  41.717  1.00 15.20      A    N  
ATOM   1837  CA  HIS   253      -4.524  34.676  41.858  1.00 14.68      A    C  
ATOM   1838  CB  HIS   253      -4.903  34.044  40.513  1.00 14.79      A    C  
ATOM   1839  CG  HIS   253      -5.038  32.553  40.563  1.00 14.76      A    C  
ATOM   1840  ND1 HIS   253      -6.113  31.921  41.152  1.00 15.27      A    N  
ATOM   1841  CE1 HIS   253      -5.958  30.611  41.054  1.00 15.48      A    C  
ATOM   1842  NE2 HIS   253      -4.822  30.372  40.421  1.00 16.56      A    N  
ATOM   1843  CD2 HIS   253      -4.224  31.569  40.107  1.00 15.28      A    C  
ATOM   1844  C   HIS   253      -3.184  34.118  42.317  1.00 14.76      A    C  
ATOM   1845  O   HIS   253      -2.138  34.479  41.782  1.00 14.89      A    O  
ATOM   1846  N   ALA   254      -3.223  33.213  43.285  1.00 15.30      A    N  
ATOM   1847  CA  ALA   254      -1.996  32.664  43.859  1.00 16.18      A    C  
ATOM   1848  CB  ALA   254      -2.328  31.861  45.092  1.00 16.78      A    C  
ATOM   1849  C   ALA   254      -1.238  31.789  42.859  1.00 16.59      A    C  
ATOM   1850  O   ALA   254      -1.829  30.920  42.214  1.00 17.65      A    O  
ATOM   1851  N   GLY   255       0.063  32.029  42.727  1.00 16.56      A    N  
ATOM   1852  CA  GLY   255       0.907  31.172  41.884  1.00 16.33      A    C  
ATOM   1853  C   GLY   255       0.601  31.357  40.410  1.00 15.39      A    C  
ATOM   1854  O   GLY   255       0.450  32.485  39.937  1.00 16.73      A    O  
ATOM   1855  N   LEU   256       0.508  30.252  39.678  1.00 13.88      A    N  
ATOM   1856  CA  LEU   256       0.411  30.324  38.224  1.00 13.15      A    C  
ATOM   1857  CB  LEU   256       0.780  28.971  37.623  1.00 12.51      A    C  
ATOM   1858  CG  LEU   256       0.705  28.845  36.106  1.00 12.90      A    C  
ATOM   1859  CD1 LEU   256       1.749  29.690  35.464  1.00 11.55      A    C  
ATOM   1860  CD2 LEU   256       0.904  27.395  35.692  1.00 13.45      A    C  
ATOM   1861  C   LEU   256      -0.984  30.708  37.755  1.00 12.43      A    C  
ATOM   1862  O   LEU   256      -1.940  29.997  38.006  1.00 12.30      A    O  
ATOM   1863  N   GLY   257      -1.093  31.831  37.057  1.00 12.39      A    N  
ATOM   1864  CA  GLY   257      -2.366  32.215  36.455  1.00 11.94      A    C  
ATOM   1865  C   GLY   257      -2.323  31.976  34.962  1.00 11.42      A    C  
ATOM   1866  O   GLY   257      -1.634  32.696  34.248  1.00 12.25      A    O  
ATOM   1867  N   VAL   258      -3.048  30.961  34.498  1.00 10.57      A    N  
ATOM   1868  CA  VAL   258      -2.984  30.582  33.097  1.00  9.65      A    C  
ATOM   1869  CB  VAL   258      -3.137  29.058  32.912  1.00  9.42      A    C  
ATOM   1870  CG1 VAL   258      -3.011  28.718  31.435  1.00  9.96      A    C  
ATOM   1871  CG2 VAL   258      -2.075  28.321  33.719  1.00 10.25      A    C  
ATOM   1872  C   VAL   258      -4.097  31.250  32.313  1.00  8.69      A    C  
ATOM   1873  O   VAL   258      -5.276  31.018  32.589  1.00  8.82      A    O  
ATOM   1874  N   HIS   259      -3.720  32.091  31.355  1.00  8.69      A    N  
ATOM   1875  CA  HIS   259      -4.708  32.697  30.470  1.00  8.52      A    C  
ATOM   1876  CB  HIS   259      -4.157  33.940  29.775  1.00  8.94      A    C  
ATOM   1877  CG  HIS   259      -3.517  34.931  30.699  1.00  8.70      A    C  
ATOM   1878  ND1 HIS   259      -2.588  35.855  30.264  1.00 11.17      A    N  
ATOM   1879  CE1 HIS   259      -2.184  36.584  31.289  1.00  9.89      A    C  
ATOM   1880  NE2 HIS   259      -2.829  36.173  32.373  1.00  9.26      A    N  
ATOM   1881  CD2 HIS   259      -3.662  35.135  32.027  1.00  9.65      A    C  
ATOM   1882  C   HIS   259      -5.134  31.723  29.387  1.00  8.75      A    C  
ATOM   1883  O   HIS   259      -4.316  30.982  28.842  1.00  8.21      A    O  
ATOM   1884  N   LEU   260      -6.416  31.751  29.058  1.00  8.61      A    N  
ATOM   1885  CA  LEU   260      -6.900  31.053  27.879  1.00  9.66      A    C  
ATOM   1886  CB  LEU   260      -8.147  30.251  28.227  1.00 10.52      A    C  
ATOM   1887  CG  LEU   260      -8.652  29.286  27.155  1.00 13.49      A    C  
ATOM   1888  CD1 LEU   260      -9.657  28.342  27.788  1.00 17.17      A    C  
ATOM   1889  CD2 LEU   260      -9.279  30.057  26.026  1.00 16.43      A    C  
ATOM   1890  C   LEU   260      -7.185  32.131  26.839  1.00 10.52      A    C  
ATOM   1891  O   LEU   260      -8.030  33.010  27.054  1.00 11.23      A    O  
ATOM   1892  N   THR   261      -6.423  32.130  25.758  1.00 10.04      A    N  
ATOM   1893  CA  THR   261      -6.660  33.112  24.697  1.00 10.77      A    C  
ATOM   1894  CB  THR   261      -5.520  34.133  24.573  1.00 11.63      A    C  
ATOM   1895  OG1 THR   261      -4.338  33.465  24.116  1.00 11.35      A    O  
ATOM   1896  CG2 THR   261      -5.246  34.799  25.932  1.00 10.48      A    C  
ATOM   1897  C   THR   261      -6.942  32.398  23.365  1.00 10.91      A    C  
ATOM   1898  O   THR   261      -6.902  31.169  23.287  1.00 10.94      A    O  
ATOM   1899  N   LEU   262      -7.303  33.167  22.346  1.00 11.44      A    N  
ATOM   1900  CA  LEU   262      -7.759  32.573  21.086  1.00 12.06      A    C  
ATOM   1901  CB  LEU   262      -9.257  32.816  20.886  1.00 11.86      A    C  
ATOM   1902  CG  LEU   262     -10.225  32.119  21.861  1.00 13.23      A    C  
ATOM   1903  CD1 LEU   262     -11.575  32.859  21.908  1.00 16.99      A    C  
ATOM   1904  CD2 LEU   262     -10.415  30.624  21.528  1.00 17.13      A    C  
ATOM   1905  C   LEU   262      -6.988  33.223  19.957  1.00 12.69      A    C  
ATOM   1906  O   LEU   262      -6.642  34.406  20.032  1.00 12.48      A    O  
ATOM   1907  N   ASP   263      -6.687  32.449  18.921  1.00 13.40      A    N  
ATOM   1908  CA  ASP   263      -6.116  33.060  17.729  1.00 15.29      A    C  
ATOM   1909  CB  ASP   263      -5.002  32.205  17.105  1.00 16.06      A    C  
ATOM   1910  CG  ASP   263      -5.496  30.896  16.566  1.00 18.95      A    C  
ATOM   1911  OD1 ASP   263      -6.674  30.822  16.152  1.00 22.94      A    O  
ATOM   1912  OD2 ASP   263      -4.685  29.936  16.531  1.00 24.02      A    O  
ATOM   1913  C   ASP   263      -7.252  33.389  16.761  1.00 15.40      A    C  
ATOM   1914  O   ASP   263      -8.402  33.042  17.010  1.00 15.48      A    O  
ATOM   1915  N   LEU   264      -6.938  34.090  15.680  1.00 16.38      A    N  
ATOM   1916  CA  LEU   264      -7.959  34.531  14.748  1.00 17.60      A    C  
ATOM   1917  CB  LEU   264      -7.346  35.483  13.731  1.00 18.04      A    C  
ATOM   1918  CG  LEU   264      -7.108  36.889  14.284  1.00 18.95      A    C  
ATOM   1919  CD1 LEU   264      -6.402  37.738  13.241  1.00 20.48      A    C  
ATOM   1920  CD2 LEU   264      -8.429  37.520  14.675  1.00 20.84      A    C  
ATOM   1921  C   LEU   264      -8.685  33.378  14.051  1.00 18.29      A    C  
ATOM   1922  O   LEU   264      -9.833  33.525  13.620  1.00 18.22      A    O  
ATOM   1923  N   GLY   265      -8.016  32.234  13.960  1.00 18.52      A    N  
ATOM   1924  CA  GLY   265      -8.620  31.038  13.369  1.00 19.30      A    C  
ATOM   1925  C   GLY   265      -9.548  30.300  14.320  1.00 19.32      A    C  
ATOM   1926  O   GLY   265     -10.167  29.304  13.942  1.00 20.36      A    O  
ATOM   1927  N   GLY   266      -9.637  30.771  15.565  1.00 18.85      A    N  
ATOM   1928  CA  GLY   266     -10.577  30.211  16.536  1.00 17.59      A    C  
ATOM   1929  C   GLY   266      -9.999  29.184  17.493  1.00 17.14      A    C  
ATOM   1930  O   GLY   266     -10.731  28.623  18.318  1.00 17.58      A    O  
ATOM   1931  N   GLN   267      -8.692  28.935  17.395  1.00 16.26      A    N  
ATOM   1932  CA  GLN   267      -8.055  27.892  18.210  1.00 15.98      A    C  
ATOM   1933  CB  GLN   267      -6.863  27.292  17.476  1.00 16.35      A    C  
ATOM   1934  CG  GLN   267      -7.210  26.755  16.080  1.00 21.10      A    C  
ATOM   1935  CD  GLN   267      -7.859  25.373  16.091  1.00 26.43      A    C  
ATOM   1936  OE1 GLN   267      -8.851  25.129  16.782  1.00 30.29      A    O  
ATOM   1937  NE2 GLN   267      -7.306  24.463  15.290  1.00 30.58      A    N  
ATOM   1938  C   GLN   267      -7.609  28.471  19.541  1.00 14.60      A    C  
ATOM   1939  O   GLN   267      -7.183  29.624  19.593  1.00 14.37      A    O  
ATOM   1940  N   ALA   268      -7.710  27.676  20.606  1.00 13.38      A    N  
ATOM   1941  CA  ALA   268      -7.384  28.160  21.941  1.00 12.52      A    C  
ATOM   1942  CB  ALA   268      -8.259  27.471  22.988  1.00 13.02      A    C  
ATOM   1943  C   ALA   268      -5.915  27.917  22.246  1.00 11.90      A    C  
ATOM   1944  O   ALA   268      -5.331  26.927  21.801  1.00 12.23      A    O  
ATOM   1945  N   LYS   269      -5.314  28.826  22.995  1.00 10.24      A    N  
ATOM   1946  CA  LYS   269      -3.986  28.578  23.550  1.00 10.60      A    C  
ATOM   1947  CB  LYS   269      -2.871  29.230  22.738  1.00 11.48      A    C  
ATOM   1948  CG  LYS   269      -2.947  30.716  22.716  1.00 13.20      A    C  
ATOM   1949  CD  LYS   269      -1.853  31.356  21.843  1.00 17.38      A    C  
ATOM   1950  CE  LYS   269      -2.293  32.753  21.451  1.00 20.16      A    C  
ATOM   1951  NZ  LYS   269      -1.334  33.490  20.577  1.00 20.54      A    N  
ATOM   1952  C   LYS   269      -3.938  28.996  25.012  1.00 10.06      A    C  
ATOM   1953  O   LYS   269      -4.770  29.771  25.472  1.00  9.28      A    O  
ATOM   1954  N   PHE   270      -2.968  28.441  25.735  1.00  8.64      A    N  
ATOM   1955  CA  PHE   270      -2.882  28.636  27.175  1.00  9.31      A    C  
ATOM   1956  CB  PHE   270      -3.107  27.301  27.876  1.00 10.08      A    C  
ATOM   1957  CG  PHE   270      -4.514  26.808  27.745  1.00 11.56      A    C  
ATOM   1958  CD1 PHE   270      -5.493  27.252  28.622  1.00 15.06      A    C  
ATOM   1959  CE1 PHE   270      -6.813  26.837  28.497  1.00 15.20      A    C  
ATOM   1960  CZ  PHE   270      -7.158  25.955  27.482  1.00 15.93      A    C  
ATOM   1961  CE2 PHE   270      -6.192  25.526  26.583  1.00 14.70      A    C  
ATOM   1962  CD2 PHE   270      -4.866  25.956  26.722  1.00 16.44      A    C  
ATOM   1963  C   PHE   270      -1.530  29.190  27.518  1.00  8.87      A    C  
ATOM   1964  O   PHE   270      -0.529  28.749  26.955  1.00  8.57      A    O  
ATOM   1965  N   GLY   271      -1.503  30.146  28.445  1.00  8.10      A    N  
ATOM   1966  CA  GLY   271      -0.254  30.823  28.796  1.00  8.35      A    C  
ATOM   1967  C   GLY   271      -0.336  32.310  28.536  1.00  8.42      A    C  
ATOM   1968  O   GLY   271      -1.385  32.808  28.124  1.00  8.25      A    O  
ATOM   1969  N   PRO   272       0.782  33.024  28.732  1.00  8.68      A    N  
ATOM   1970  CA  PRO   272       2.107  32.459  29.043  1.00  8.92      A    C  
ATOM   1971  CB  PRO   272       3.045  33.569  28.563  1.00  9.05      A    C  
ATOM   1972  CG  PRO   272       2.256  34.840  28.942  1.00  9.03      A    C  
ATOM   1973  CD  PRO   272       0.841  34.490  28.557  1.00  8.18      A    C  
ATOM   1974  C   PRO   272       2.352  32.239  30.533  1.00  9.61      A    C  
ATOM   1975  O   PRO   272       1.695  32.863  31.384  1.00  9.74      A    O  
ATOM   1976  N   ASP   273       3.305  31.366  30.862  1.00  9.99      A    N  
ATOM   1977  CA  ASP   273       3.746  31.278  32.240  1.00  9.85      A    C  
ATOM   1978  CB  ASP   273       4.195  29.841  32.616  1.00  9.69      A    C  
ATOM   1979  CG  ASP   273       5.453  29.387  31.881  1.00 10.66      A    C  
ATOM   1980  OD1 ASP   273       5.979  30.139  31.040  1.00 10.49      A    O  
ATOM   1981  OD2 ASP   273       5.917  28.246  32.154  1.00 12.27      A    O  
ATOM   1982  C   ASP   273       4.850  32.299  32.470  1.00  9.78      A    C  
ATOM   1983  O   ASP   273       5.055  33.214  31.638  1.00  9.27      A    O  
ATOM   1984  N   THR   274       5.547  32.158  33.595  1.00 10.55      A    N  
ATOM   1985  CA  THR   274       6.660  33.056  33.909  1.00 11.27      A    C  
ATOM   1986  CB  THR   274       6.322  34.072  35.011  1.00 12.04      A    C  
ATOM   1987  OG1 THR   274       5.862  33.379  36.167  1.00 14.76      A    O  
ATOM   1988  CG2 THR   274       5.248  35.032  34.541  1.00 11.04      A    C  
ATOM   1989  C   THR   274       7.901  32.272  34.325  1.00 11.15      A    C  
ATOM   1990  O   THR   274       7.835  31.367  35.162  1.00 12.09      A    O  
ATOM   1991  N   GLU   275       9.025  32.653  33.741  1.00 10.62      A    N  
ATOM   1992  CA  GLU   275      10.268  31.926  33.968  1.00 10.76      A    C  
ATOM   1993  CB  GLU   275      10.368  30.782  32.959  1.00 10.82      A    C  
ATOM   1994  CG  GLU   275      11.597  29.872  33.165  1.00 12.29      A    C  
ATOM   1995  CD  GLU   275      11.835  28.931  32.002  1.00 15.29      A    C  
ATOM   1996  OE1 GLU   275      12.893  28.229  32.001  1.00 14.65      A    O  
ATOM   1997  OE2 GLU   275      10.980  28.881  31.084  1.00 11.82      A    O  
ATOM   1998  C   GLU   275      11.452  32.866  33.805  1.00 10.62      A    C  
ATOM   1999  O   GLU   275      11.833  33.208  32.686  1.00  9.94      A    O  
ATOM   2000  N   TRP   276      12.040  33.279  34.925  1.00 11.47      A    N  
ATOM   2001  CA  TRP   276      13.182  34.184  34.858  1.00 11.40      A    C  
ATOM   2002  CB  TRP   276      13.425  34.853  36.213  1.00 11.92      A    C  
ATOM   2003  CG  TRP   276      12.284  35.761  36.620  1.00 12.48      A    C  
ATOM   2004  CD1 TRP   276      11.097  35.382  37.190  1.00 14.61      A    C  
ATOM   2005  NE1 TRP   276      10.303  36.489  37.406  1.00 16.05      A    N  
ATOM   2006  CE2 TRP   276      10.974  37.606  36.980  1.00 15.55      A    C  
ATOM   2007  CD2 TRP   276      12.226  37.186  36.478  1.00 13.93      A    C  
ATOM   2008  CE3 TRP   276      13.108  38.147  35.968  1.00 13.89      A    C  
ATOM   2009  CZ3 TRP   276      12.724  39.483  35.988  1.00 12.81      A    C  
ATOM   2010  CH2 TRP   276      11.482  39.870  36.505  1.00 13.78      A    C  
ATOM   2011  CZ2 TRP   276      10.590  38.953  36.999  1.00 13.37      A    C  
ATOM   2012  C   TRP   276      14.406  33.401  34.418  1.00 11.85      A    C  
ATOM   2013  O   TRP   276      14.698  32.349  34.993  1.00 12.20      A    O  
ATOM   2014  N   ILE   277      15.088  33.904  33.392  1.00 11.57      A    N  
ATOM   2015  CA  ILE   277      16.202  33.196  32.775  1.00 11.71      A    C  
ATOM   2016  CB  ILE   277      15.816  32.558  31.422  1.00 11.61      A    C  
ATOM   2017  CG1 ILE   277      15.292  33.628  30.441  1.00 12.57      A    C  
ATOM   2018  CD1 ILE   277      15.054  33.139  29.003  1.00 13.97      A    C  
ATOM   2019  CG2 ILE   277      14.806  31.459  31.656  1.00 10.36      A    C  
ATOM   2020  C   ILE   277      17.420  34.094  32.591  1.00 12.72      A    C  
ATOM   2021  O   ILE   277      17.313  35.316  32.642  1.00 13.24      A    O  
ATOM   2022  N   ALA   278      18.573  33.473  32.357  1.00 13.28      A    N  
ATOM   2023  CA  ALA   278      19.847  34.188  32.279  1.00 14.04      A    C  
ATOM   2024  CB  ALA   278      20.958  33.315  32.878  1.00 14.41      A    C  
ATOM   2025  C   ALA   278      20.253  34.618  30.868  1.00 14.68      A    C  
ATOM   2026  O   ALA   278      21.076  35.527  30.702  1.00 15.66      A    O  
ATOM   2027  N   THR   279      19.738  33.921  29.859  1.00 14.41      A    N  
ATOM   2028  CA  THR   279      20.135  34.169  28.482  1.00 15.06      A    C  
ATOM   2029  CB  THR   279      21.205  33.163  27.999  1.00 14.74      A    C  
ATOM   2030  OG1 THR   279      20.605  31.872  27.844  1.00 16.89      A    O  
ATOM   2031  CG2 THR   279      22.352  33.056  29.002  1.00 17.10      A    C  
ATOM   2032  C   THR   279      18.933  34.054  27.565  1.00 14.88      A    C  
ATOM   2033  O   THR   279      17.903  33.500  27.955  1.00 14.75      A    O  
ATOM   2034  N   GLU   280      19.082  34.572  26.346  1.00 15.09      A    N  
ATOM   2035  CA  GLU   280      17.990  34.642  25.385  1.00 15.97      A    C  
ATOM   2036  CB  GLU   280      18.277  35.734  24.351  1.00 16.40      A    C  
ATOM   2037  CG  GLU   280      17.062  36.105  23.512  1.00 16.26      A    C  
ATOM   2038  CD  GLU   280      17.353  37.197  22.503  1.00 17.86      A    C  
ATOM   2039  OE1 GLU   280      18.480  37.743  22.516  1.00 17.75      A    O  
ATOM   2040  OE2 GLU   280      16.447  37.510  21.699  1.00 15.48      A    O  
ATOM   2041  C   GLU   280      17.781  33.319  24.672  1.00 16.35      A    C  
ATOM   2042  O   GLU   280      18.318  33.093  23.575  1.00 17.34      A    O  
ATOM   2043  N   ASP   281      16.976  32.459  25.280  1.00 16.27      A    N  
ATOM   2044  CA  ASP   281      16.787  31.103  24.811  1.00 15.94      A    C  
ATOM   2045  CB  ASP   281      17.349  30.156  25.848  1.00 16.71      A    C  
ATOM   2046  CG  ASP   281      17.211  28.714  25.451  1.00 19.98      A    C  
ATOM   2047  OD1 ASP   281      16.590  28.437  24.404  1.00 22.88      A    O  
ATOM   2048  OD2 ASP   281      17.740  27.860  26.198  1.00 24.64      A    O  
ATOM   2049  C   ASP   281      15.296  30.830  24.614  1.00 15.49      A    C  
ATOM   2050  O   ASP   281      14.542  30.828  25.582  1.00 15.13      A    O  
ATOM   2051  N   TYR   282      14.884  30.622  23.368  1.00 15.22      A    N  
ATOM   2052  CA  TYR   282      13.450  30.475  23.022  1.00 15.44      A    C  
ATOM   2053  CB  TYR   282      13.120  31.173  21.694  1.00 15.29      A    C  
ATOM   2054  CG  TYR   282      13.325  32.658  21.760  1.00 16.45      A    C  
ATOM   2055  CD1 TYR   282      12.366  33.484  22.340  1.00 16.25      A    C  
ATOM   2056  CE1 TYR   282      12.565  34.837  22.436  1.00 16.29      A    C  
ATOM   2057  CZ  TYR   282      13.737  35.389  21.938  1.00 16.47      A    C  
ATOM   2058  OH  TYR   282      13.940  36.741  22.031  1.00 18.48      A    O  
ATOM   2059  CE2 TYR   282      14.695  34.591  21.355  1.00 16.16      A    C  
ATOM   2060  CD2 TYR   282      14.487  33.236  21.274  1.00 15.31      A    C  
ATOM   2061  C   TYR   282      12.974  29.036  22.964  1.00 15.74      A    C  
ATOM   2062  O   TYR   282      11.809  28.772  22.639  1.00 15.76      A    O  
ATOM   2063  N   THR   283      13.872  28.106  23.270  1.00 16.29      A    N  
ATOM   2064  CA  THR   283      13.540  26.694  23.216  1.00 16.87      A    C  
ATOM   2065  CB  THR   283      14.729  25.826  23.644  1.00 17.42      A    C  
ATOM   2066  OG1 THR   283      15.899  26.263  22.946  1.00 19.92      A    O  
ATOM   2067  CG2 THR   283      14.468  24.360  23.320  1.00 18.08      A    C  
ATOM   2068  C   THR   283      12.339  26.359  24.096  1.00 16.86      A    C  
ATOM   2069  O   THR   283      12.297  26.708  25.266  1.00 15.97      A    O  
ATOM   2070  N   LEU   284      11.362  25.665  23.519  1.00 17.40      A    N  
ATOM   2071  CA  LEU   284      10.183  25.252  24.271  1.00 17.56      A    C  
ATOM   2072  CB  LEU   284       8.997  25.061  23.323  1.00 17.84      A    C  
ATOM   2073  CG  LEU   284       7.692  24.549  23.951  1.00 18.55      A    C  
ATOM   2074  CD1 LEU   284       7.000  25.612  24.813  1.00 20.18      A    C  
ATOM   2075  CD2 LEU   284       6.745  24.055  22.881  1.00 20.17      A    C  
ATOM   2076  C   LEU   284      10.419  23.968  25.070  1.00 17.57      A    C  
ATOM   2077  O   LEU   284      10.850  22.939  24.518  1.00 18.00      A    O  
ATOM   2078  N   ASP   285      10.145  24.030  26.370  1.00 16.60      A    N  
ATOM   2079  CA  ASP   285      10.186  22.856  27.220  1.00 17.28      A    C  
ATOM   2080  CB  ASP   285      10.779  23.206  28.585  1.00 17.02      A    C  
ATOM   2081  CG  ASP   285      10.878  22.006  29.514  1.00 18.78      A    C  
ATOM   2082  OD1 ASP   285      10.399  20.910  29.164  1.00 18.34      A    O  
ATOM   2083  OD2 ASP   285      11.442  22.164  30.619  1.00 21.24      A    O  
ATOM   2084  C   ASP   285       8.764  22.347  27.380  1.00 17.24      A    C  
ATOM   2085  O   ASP   285       7.975  22.935  28.125  1.00 16.97      A    O  
ATOM   2086  N   PRO   286       8.418  21.263  26.667  1.00 17.26      A    N  
ATOM   2087  CA  PRO   286       7.056  20.743  26.719  1.00 17.54      A    C  
ATOM   2088  CB  PRO   286       7.129  19.466  25.872  1.00 17.50      A    C  
ATOM   2089  CG  PRO   286       8.298  19.666  24.974  1.00 18.33      A    C  
ATOM   2090  CD  PRO   286       9.285  20.459  25.791  1.00 17.69      A    C  
ATOM   2091  C   PRO   286       6.624  20.394  28.135  1.00 17.34      A    C  
ATOM   2092  O   PRO   286       5.423  20.382  28.431  1.00 17.57      A    O  
ATOM   2093  N   ARG   287       7.586  20.103  29.006  1.00 17.57      A    N  
ATOM   2094  CA  ARG   287       7.267  19.708  30.374  1.00 17.64      A    C  
ATOM   2095  CB  ARG   287       8.468  19.049  31.063  1.00 18.31      A    C  
ATOM   2096  CG  ARG   287       8.897  17.733  30.394  1.00 22.54      A    C  
ATOM   2097  CD  ARG   287       7.687  16.877  30.034  1.00 27.59      A    C  
ATOM   2098  NE  ARG   287       7.130  16.192  31.197  1.00 32.67      A    N  
ATOM   2099  CZ  ARG   287       5.889  15.711  31.256  1.00 35.40      A    C  
ATOM   2100  NH1 ARG   287       5.064  15.869  30.231  1.00 36.13      A    N  
ATOM   2101  NH2 ARG   287       5.461  15.091  32.355  1.00 37.15      A    N  
ATOM   2102  C   ARG   287       6.716  20.853  31.216  1.00 16.94      A    C  
ATOM   2103  O   ARG   287       6.134  20.629  32.268  1.00 17.31      A    O  
ATOM   2104  N   ARG   288       6.875  22.083  30.734  1.00 15.87      A    N  
ATOM   2105  CA  ARG   288       6.365  23.230  31.472  1.00 14.59      A    C  
ATOM   2106  CB  ARG   288       6.936  24.536  30.909  1.00 14.24      A    C  
ATOM   2107  CG  ARG   288       8.441  24.735  31.179  1.00 13.41      A    C  
ATOM   2108  CD  ARG   288       8.886  26.175  30.981  1.00 14.26      A    C  
ATOM   2109  NE  ARG   288       8.313  27.029  32.022  1.00 13.59      A    N  
ATOM   2110  CZ  ARG   288       8.821  27.191  33.239  1.00 14.84      A    C  
ATOM   2111  NH1 ARG   288       9.934  26.549  33.599  1.00 13.13      A    N  
ATOM   2112  NH2 ARG   288       8.203  27.985  34.105  1.00 13.55      A    N  
ATOM   2113  C   ARG   288       4.829  23.257  31.479  1.00 13.80      A    C  
ATOM   2114  O   ARG   288       4.213  23.954  32.300  1.00 12.53      A    O  
ATOM   2115  N   ALA   289       4.217  22.487  30.581  1.00 13.00      A    N  
ATOM   2116  CA  ALA   289       2.752  22.351  30.572  1.00 12.95      A    C  
ATOM   2117  CB  ALA   289       2.268  21.718  29.257  1.00 13.05      A    C  
ATOM   2118  C   ALA   289       2.201  21.553  31.762  1.00 12.66      A    C  
ATOM   2119  O   ALA   289       1.017  21.620  32.074  1.00 12.60      A    O  
ATOM   2120  N   ASP   290       3.044  20.760  32.417  1.00 13.55      A    N  
ATOM   2121  CA  ASP   290       2.541  19.898  33.475  1.00 13.88      A    C  
ATOM   2122  CB  ASP   290       3.702  19.117  34.111  1.00 14.93      A    C  
ATOM   2123  CG  ASP   290       4.303  18.102  33.169  1.00 18.97      A    C  
ATOM   2124  OD1 ASP   290       3.702  17.847  32.102  1.00 22.29      A    O  
ATOM   2125  OD2 ASP   290       5.366  17.529  33.510  1.00 22.42      A    O  
ATOM   2126  C   ASP   290       1.740  20.647  34.558  1.00 13.43      A    C  
ATOM   2127  O   ASP   290       0.681  20.189  34.999  1.00 12.95      A    O  
ATOM   2128  N   VAL   291       2.241  21.805  34.979  1.00 12.94      A    N  
ATOM   2129  CA  VAL   291       1.579  22.575  36.025  1.00 12.20      A    C  
ATOM   2130  CB  VAL   291       2.554  23.571  36.672  1.00 12.87      A    C  
ATOM   2131  CG1 VAL   291       3.669  22.836  37.399  1.00 13.57      A    C  
ATOM   2132  CG2 VAL   291       3.136  24.471  35.635  1.00 12.19      A    C  
ATOM   2133  C   VAL   291       0.364  23.350  35.495  1.00 12.43      A    C  
ATOM   2134  O   VAL   291      -0.433  23.885  36.280  1.00 12.01      A    O  
ATOM   2135  N   PHE   292       0.240  23.442  34.168  1.00 11.95      A    N  
ATOM   2136  CA  PHE   292      -0.914  24.152  33.578  1.00 10.92      A    C  
ATOM   2137  CB  PHE   292      -0.783  24.271  32.058  1.00 11.04      A    C  
ATOM   2138  CG  PHE   292       0.084  25.418  31.582  1.00 10.23      A    C  
ATOM   2139  CD1 PHE   292       1.360  25.624  32.097  1.00 10.82      A    C  
ATOM   2140  CE1 PHE   292       2.176  26.666  31.613  1.00 11.82      A    C  
ATOM   2141  CZ  PHE   292       1.696  27.517  30.616  1.00 10.93      A    C  
ATOM   2142  CE2 PHE   292       0.426  27.298  30.083  1.00 10.64      A    C  
ATOM   2143  CD2 PHE   292      -0.366  26.258  30.563  1.00 10.22      A    C  
ATOM   2144  C   PHE   292      -2.238  23.453  33.884  1.00 11.02      A    C  
ATOM   2145  O   PHE   292      -3.282  24.107  34.008  1.00 10.60      A    O  
ATOM   2146  N   TYR   293      -2.209  22.127  33.970  1.00  9.73      A    N  
ATOM   2147  CA  TYR   293      -3.455  21.374  34.016  1.00  9.69      A    C  
ATOM   2148  CB  TYR   293      -3.162  19.869  33.976  1.00  9.58      A    C  
ATOM   2149  CG  TYR   293      -2.775  19.407  32.593  1.00  9.06      A    C  
ATOM   2150  CD1 TYR   293      -3.750  18.990  31.689  1.00 11.13      A    C  
ATOM   2151  CE1 TYR   293      -3.423  18.569  30.413  1.00 10.53      A    C  
ATOM   2152  CZ  TYR   293      -2.108  18.560  30.016  1.00 10.33      A    C  
ATOM   2153  OH  TYR   293      -1.790  18.143  28.740  1.00 13.17      A    O  
ATOM   2154  CE2 TYR   293      -1.109  18.985  30.880  1.00 10.09      A    C  
ATOM   2155  CD2 TYR   293      -1.456  19.412  32.178  1.00  9.39      A    C  
ATOM   2156  C   TYR   293      -4.368  21.737  35.191  1.00  9.92      A    C  
ATOM   2157  O   TYR   293      -5.554  22.004  34.993  1.00  9.94      A    O  
ATOM   2158  N   ALA   294      -3.819  21.748  36.400  1.00 10.38      A    N  
ATOM   2159  CA  ALA   294      -4.618  22.040  37.593  1.00 10.88      A    C  
ATOM   2160  CB  ALA   294      -3.809  21.778  38.852  1.00 11.48      A    C  
ATOM   2161  C   ALA   294      -5.071  23.488  37.567  1.00 11.10      A    C  
ATOM   2162  O   ALA   294      -6.197  23.799  37.969  1.00 12.44      A    O  
ATOM   2163  N   ALA   295      -4.189  24.367  37.093  1.00 10.94      A    N  
ATOM   2164  CA  ALA   295      -4.506  25.802  37.020  1.00 10.51      A    C  
ATOM   2165  CB  ALA   295      -3.292  26.570  36.554  1.00 10.31      A    C  
ATOM   2166  C   ALA   295      -5.687  26.045  36.078  1.00 10.79      A    C  
ATOM   2167  O   ALA   295      -6.684  26.696  36.446  1.00 10.82      A    O  
ATOM   2168  N   VAL   296      -5.594  25.507  34.864  1.00 10.01      A    N  
ATOM   2169  CA  VAL   296      -6.707  25.622  33.914  1.00  9.87      A    C  
ATOM   2170  CB  VAL   296      -6.340  25.059  32.527  1.00  9.10      A    C  
ATOM   2171  CG1 VAL   296      -7.574  25.046  31.617  1.00  9.19      A    C  
ATOM   2172  CG2 VAL   296      -5.215  25.853  31.908  1.00  9.41      A    C  
ATOM   2173  C   VAL   296      -7.986  24.962  34.400  1.00  9.86      A    C  
ATOM   2174  O   VAL   296      -9.065  25.507  34.250  1.00  9.68      A    O  
ATOM   2175  N   ARG   297      -7.878  23.776  35.000  1.00 10.21      A    N  
ATOM   2176  CA  ARG   297      -9.074  23.057  35.450  1.00 11.00      A    C  
ATOM   2177  CB  ARG   297      -8.706  21.631  35.865  1.00 10.72      A    C  
ATOM   2178  CG  ARG   297      -8.517  20.756  34.627  1.00  9.80      A    C  
ATOM   2179  CD  ARG   297      -7.831  19.429  34.941  1.00  9.74      A    C  
ATOM   2180  NE  ARG   297      -7.725  18.609  33.735  1.00 11.40      A    N  
ATOM   2181  CZ  ARG   297      -6.859  17.608  33.583  1.00 11.89      A    C  
ATOM   2182  NH1 ARG   297      -6.002  17.315  34.561  1.00 11.87      A    N  
ATOM   2183  NH2 ARG   297      -6.852  16.905  32.448  1.00 12.00      A    N  
ATOM   2184  C   ARG   297      -9.886  23.767  36.537  1.00 11.44      A    C  
ATOM   2185  O   ARG   297     -11.049  23.446  36.770  1.00 12.42      A    O  
ATOM   2186  N   SER   298      -9.278  24.756  37.179  1.00 12.40      A    N  
ATOM   2187  CA  SER   298     -10.018  25.583  38.114  1.00 13.04      A    C  
ATOM   2188  CB  SER   298      -9.102  26.591  38.787  1.00 13.52      A    C  
ATOM   2189  OG  SER   298      -8.259  25.925  39.715  1.00 16.65      A    O  
ATOM   2190  C   SER   298     -11.214  26.290  37.472  1.00 12.51      A    C  
ATOM   2191  O   SER   298     -12.263  26.428  38.120  1.00 13.57      A    O  
ATOM   2192  N   TYR   299     -11.059  26.734  36.222  1.00 10.89      A    N  
ATOM   2193  CA  TYR   299     -12.162  27.386  35.502  1.00 10.28      A    C  
ATOM   2194  CB  TYR   299     -11.774  28.812  35.075  1.00  9.50      A    C  
ATOM   2195  CG  TYR   299     -10.564  28.908  34.167  1.00  9.27      A    C  
ATOM   2196  CD1 TYR   299     -10.662  28.631  32.804  1.00  8.31      A    C  
ATOM   2197  CE1 TYR   299      -9.543  28.723  31.962  1.00  7.83      A    C  
ATOM   2198  CZ  TYR   299      -8.324  29.135  32.495  1.00  9.02      A    C  
ATOM   2199  OH  TYR   299      -7.223  29.242  31.688  1.00 10.26      A    O  
ATOM   2200  CE2 TYR   299      -8.210  29.418  33.844  1.00  8.89      A    C  
ATOM   2201  CD2 TYR   299      -9.322  29.302  34.670  1.00  8.08      A    C  
ATOM   2202  C   TYR   299     -12.696  26.591  34.297  1.00 10.61      A    C  
ATOM   2203  O   TYR   299     -13.793  26.865  33.793  1.00 11.06      A    O  
ATOM   2204  N   TRP   300     -11.914  25.624  33.828  1.00 10.62      A    N  
ATOM   2205  CA  TRP   300     -12.352  24.744  32.739  1.00 11.34      A    C  
ATOM   2206  CB  TRP   300     -11.674  25.096  31.415  1.00 11.18      A    C  
ATOM   2207  CG  TRP   300     -12.158  24.197  30.274  1.00 11.38      A    C  
ATOM   2208  CD1 TRP   300     -13.417  23.712  30.106  1.00 11.92      A    C  
ATOM   2209  NE1 TRP   300     -13.485  22.936  28.964  1.00 13.28      A    N  
ATOM   2210  CE2 TRP   300     -12.242  22.897  28.387  1.00 12.66      A    C  
ATOM   2211  CD2 TRP   300     -11.376  23.671  29.189  1.00 11.25      A    C  
ATOM   2212  CE3 TRP   300     -10.036  23.800  28.807  1.00 11.05      A    C  
ATOM   2213  CZ3 TRP   300      -9.602  23.139  27.663  1.00 12.96      A    C  
ATOM   2214  CH2 TRP   300     -10.484  22.368  26.900  1.00 11.99      A    C  
ATOM   2215  CZ2 TRP   300     -11.803  22.232  27.243  1.00 13.03      A    C  
ATOM   2216  C   TRP   300     -12.051  23.295  33.111  1.00 11.84      A    C  
ATOM   2217  O   TRP   300     -11.083  22.702  32.627  1.00 11.54      A    O  
ATOM   2218  N   PRO   301     -12.873  22.733  33.992  1.00 12.67      A    N  
ATOM   2219  CA  PRO   301     -12.551  21.392  34.504  1.00 13.02      A    C  
ATOM   2220  CB  PRO   301     -13.652  21.113  35.531  1.00 13.41      A    C  
ATOM   2221  CG  PRO   301     -14.550  22.298  35.535  1.00 14.04      A    C  
ATOM   2222  CD  PRO   301     -13.949  23.403  34.745  1.00 12.33      A    C  
ATOM   2223  C   PRO   301     -12.527  20.306  33.418  1.00 13.72      A    C  
ATOM   2224  O   PRO   301     -11.853  19.276  33.604  1.00 14.48      A    O  
ATOM   2225  N   ALA   302     -13.201  20.548  32.290  1.00 13.88      A    N  
ATOM   2226  CA  ALA   302     -13.247  19.568  31.188  1.00 13.62      A    C  
ATOM   2227  CB  ALA   302     -14.469  19.799  30.299  1.00 14.40      A    C  
ATOM   2228  C   ALA   302     -11.973  19.471  30.327  1.00 13.21      A    C  
ATOM   2229  O   ALA   302     -11.924  18.685  29.372  1.00 12.71      A    O  
ATOM   2230  N   LEU   303     -10.953  20.269  30.636  1.00 12.15      A    N  
ATOM   2231  CA  LEU   303      -9.669  20.124  29.963  1.00 11.78      A    C  
ATOM   2232  CB  LEU   303      -8.616  21.028  30.628  1.00 12.03      A    C  
ATOM   2233  CG  LEU   303      -7.164  20.732  30.254  1.00 10.30      A    C  
ATOM   2234  CD1 LEU   303      -6.941  21.017  28.784  1.00 10.85      A    C  
ATOM   2235  CD2 LEU   303      -6.222  21.572  31.101  1.00 12.46      A    C  
ATOM   2236  C   LEU   303      -9.219  18.658  29.996  1.00 12.31      A    C  
ATOM   2237  O   LEU   303      -9.025  18.088  31.064  1.00 11.62      A    O  
ATOM   2238  N   PRO   304      -9.072  18.028  28.824  1.00 12.54      A    N  
ATOM   2239  CA  PRO   304      -8.681  16.600  28.863  1.00 12.74      A    C  
ATOM   2240  CB  PRO   304      -8.928  16.141  27.426  1.00 12.86      A    C  
ATOM   2241  CG  PRO   304      -9.958  17.104  26.883  1.00 12.88      A    C  
ATOM   2242  CD  PRO   304      -9.506  18.431  27.479  1.00 13.01      A    C  
ATOM   2243  C   PRO   304      -7.220  16.355  29.202  1.00 12.69      A    C  
ATOM   2244  O   PRO   304      -6.372  17.183  28.892  1.00 12.47      A    O  
ATOM   2245  N   ASP   305      -6.912  15.192  29.782  1.00 12.85      A    N  
ATOM   2246  CA  ASP   305      -5.510  14.814  29.972  1.00 13.93      A    C  
ATOM   2247  CB  ASP   305      -5.380  13.382  30.520  1.00 14.21      A    C  
ATOM   2248  CG  ASP   305      -5.872  13.231  31.946  1.00 17.28      A    C  
ATOM   2249  OD1 ASP   305      -6.049  14.241  32.660  1.00 18.05      A    O  
ATOM   2250  OD2 ASP   305      -6.076  12.062  32.361  1.00 18.72      A    O  
ATOM   2251  C   ASP   305      -4.754  14.865  28.637  1.00 13.61      A    C  
ATOM   2252  O   ASP   305      -5.281  14.452  27.591  1.00 13.18      A    O  
ATOM   2253  N   GLY   306      -3.521  15.358  28.694  1.00 14.09      A    N  
ATOM   2254  CA  GLY   306      -2.581  15.336  27.573  1.00 15.47      A    C  
ATOM   2255  C   GLY   306      -2.878  16.305  26.452  1.00 15.97      A    C  
ATOM   2256  O   GLY   306      -2.157  16.342  25.442  1.00 16.58      A    O  
ATOM   2257  N   ALA   307      -3.924  17.114  26.627  1.00 15.64      A    N  
ATOM   2258  CA  ALA   307      -4.410  17.981  25.550  1.00 15.84      A    C  
ATOM   2259  CB  ALA   307      -5.864  18.338  25.764  1.00 15.75      A    C  
ATOM   2260  C   ALA   307      -3.595  19.248  25.320  1.00 15.38      A    C  
ATOM   2261  O   ALA   307      -3.788  19.926  24.314  1.00 16.04      A    O  
ATOM   2262  N   LEU   308      -2.702  19.580  26.238  1.00 15.35      A    N  
ATOM   2263  CA  LEU   308      -1.890  20.798  26.078  1.00 15.06      A    C  
ATOM   2264  CB  LEU   308      -1.536  21.397  27.435  1.00 15.18      A    C  
ATOM   2265  CG  LEU   308      -2.718  21.870  28.281  1.00 14.77      A    C  
ATOM   2266  CD1 LEU   308      -2.198  22.497  29.562  1.00 14.10      A    C  
ATOM   2267  CD2 LEU   308      -3.618  22.855  27.503  1.00 14.87      A    C  
ATOM   2268  C   LEU   308      -0.638  20.554  25.233  1.00 15.79      A    C  
ATOM   2269  O   LEU   308       0.415  20.143  25.748  1.00 16.90      A    O  
ATOM   2270  N   ALA   309      -0.765  20.814  23.933  1.00 15.13      A    N  
ATOM   2271  CA  ALA   309       0.294  20.542  22.959  1.00 15.57      A    C  
ATOM   2272  CB  ALA   309      -0.291  20.418  21.570  1.00 15.95      A    C  
ATOM   2273  C   ALA   309       1.339  21.638  22.982  1.00 15.67      A    C  
ATOM   2274  O   ALA   309       1.038  22.791  23.307  1.00 15.40      A    O  
ATOM   2275  N   PRO   310       2.583  21.291  22.620  1.00 15.20      A    N  
ATOM   2276  CA  PRO   310       3.639  22.296  22.612  1.00 15.54      A    C  
ATOM   2277  CB  PRO   310       4.845  21.522  22.066  1.00 16.09      A    C  
ATOM   2278  CG  PRO   310       4.594  20.132  22.520  1.00 15.08      A    C  
ATOM   2279  CD  PRO   310       3.105  19.946  22.318  1.00 15.93      A    C  
ATOM   2280  C   PRO   310       3.283  23.481  21.715  1.00 15.55      A    C  
ATOM   2281  O   PRO   310       2.832  23.304  20.573  1.00 16.49      A    O  
ATOM   2282  N   GLY   311       3.466  24.683  22.245  1.00 14.91      A    N  
ATOM   2283  CA  GLY   311       3.155  25.880  21.499  1.00 13.85      A    C  
ATOM   2284  C   GLY   311       4.416  26.604  21.094  1.00 13.91      A    C  
ATOM   2285  O   GLY   311       5.090  26.215  20.126  1.00 13.87      A    O  
ATOM   2286  N   TYR   312       4.751  27.644  21.848  1.00 12.49      A    N  
ATOM   2287  CA  TYR   312       5.884  28.490  21.525  1.00 12.61      A    C  
ATOM   2288  CB  TYR   312       5.543  29.393  20.332  1.00 12.89      A    C  
ATOM   2289  CG  TYR   312       4.403  30.366  20.585  1.00 12.92      A    C  
ATOM   2290  CD1 TYR   312       4.656  31.712  20.897  1.00 14.66      A    C  
ATOM   2291  CE1 TYR   312       3.604  32.609  21.121  1.00 12.57      A    C  
ATOM   2292  CZ  TYR   312       2.301  32.162  21.036  1.00 15.48      A    C  
ATOM   2293  OH  TYR   312       1.251  33.029  21.263  1.00 14.99      A    O  
ATOM   2294  CE2 TYR   312       2.029  30.838  20.730  1.00 14.43      A    C  
ATOM   2295  CD2 TYR   312       3.085  29.949  20.505  1.00 14.65      A    C  
ATOM   2296  C   TYR   312       6.198  29.334  22.752  1.00 12.62      A    C  
ATOM   2297  O   TYR   312       5.443  29.319  23.726  1.00 12.46      A    O  
ATOM   2298  N   THR   313       7.307  30.060  22.692  1.00 12.54      A    N  
ATOM   2299  CA  THR   313       7.735  30.902  23.798  1.00 11.75      A    C  
ATOM   2300  CB  THR   313       9.086  30.437  24.360  1.00 12.16      A    C  
ATOM   2301  OG1 THR   313      10.093  30.686  23.378  1.00 13.42      A    O  
ATOM   2302  CG2 THR   313       9.062  28.946  24.713  1.00 12.33      A    C  
ATOM   2303  C   THR   313       7.926  32.344  23.362  1.00 11.63      A    C  
ATOM   2304  O   THR   313       8.047  32.664  22.165  1.00 12.08      A    O  
ATOM   2305  N   GLY   314       7.943  33.223  24.350  1.00 11.01      A    N  
ATOM   2306  CA  GLY   314       8.393  34.583  24.177  1.00 10.25      A    C  
ATOM   2307  C   GLY   314       9.214  34.979  25.387  1.00  9.80      A    C  
ATOM   2308  O   GLY   314       9.208  34.285  26.403  1.00  9.57      A    O  
ATOM   2309  N   ILE   315       9.910  36.110  25.289  1.00  9.50      A    N  
ATOM   2310  CA  ILE   315      10.694  36.606  26.413  1.00  8.89      A    C  
ATOM   2311  CB  ILE   315      12.210  36.391  26.192  1.00  9.19      A    C  
ATOM   2312  CG1 ILE   315      12.471  34.898  26.003  1.00  9.37      A    C  
ATOM   2313  CD1 ILE   315      13.918  34.578  25.628  1.00  8.98      A    C  
ATOM   2314  CG2 ILE   315      13.009  36.900  27.376  1.00  8.33      A    C  
ATOM   2315  C   ILE   315      10.362  38.082  26.642  1.00  9.46      A    C  
ATOM   2316  O   ILE   315      10.390  38.883  25.711  1.00 10.01      A    O  
ATOM   2317  N   ARG   316       9.992  38.406  27.875  1.00  8.59      A    N  
ATOM   2318  CA  ARG   316       9.627  39.775  28.254  1.00  8.99      A    C  
ATOM   2319  CB  ARG   316       8.751  39.735  29.500  1.00  8.88      A    C  
ATOM   2320  CG  ARG   316       7.509  38.861  29.385  1.00  8.68      A    C  
ATOM   2321  CD  ARG   316       6.861  38.746  30.754  1.00  9.10      A    C  
ATOM   2322  NE  ARG   316       5.680  37.885  30.804  1.00  8.89      A    N  
ATOM   2323  CZ  ARG   316       5.706  36.555  30.910  1.00  9.60      A    C  
ATOM   2324  NH1 ARG   316       6.872  35.903  30.925  1.00  8.63      A    N  
ATOM   2325  NH2 ARG   316       4.561  35.876  31.000  1.00  9.36      A    N  
ATOM   2326  C   ARG   316      10.877  40.593  28.594  1.00  9.46      A    C  
ATOM   2327  O   ARG   316      11.767  40.105  29.306  1.00  9.72      A    O  
ATOM   2328  N   PRO   317      10.934  41.846  28.120  1.00  9.31      A    N  
ATOM   2329  CA  PRO   317      12.016  42.739  28.504  1.00  9.89      A    C  
ATOM   2330  CB  PRO   317      11.975  43.827  27.427  1.00  9.59      A    C  
ATOM   2331  CG  PRO   317      10.495  43.886  26.999  1.00  8.43      A    C  
ATOM   2332  CD  PRO   317       9.954  42.483  27.213  1.00  9.11      A    C  
ATOM   2333  C   PRO   317      11.744  43.320  29.878  1.00 11.45      A    C  
ATOM   2334  O   PRO   317      10.881  44.201  30.043  1.00 13.08      A    O  
ATOM   2335  N   LYS   318      12.463  42.824  30.871  1.00 11.27      A    N  
ATOM   2336  CA  LYS   318      12.249  43.260  32.233  1.00 12.41      A    C  
ATOM   2337  CB  LYS   318      12.263  42.066  33.191  1.00 12.01      A    C  
ATOM   2338  CG  LYS   318      11.083  41.103  33.038  1.00 13.09      A    C  
ATOM   2339  CD  LYS   318       9.795  41.777  33.503  1.00 13.40      A    C  
ATOM   2340  CE  LYS   318       8.691  40.776  33.707  1.00 17.34      A    C  
ATOM   2341  NZ  LYS   318       7.410  41.441  34.119  1.00 16.28      A    N  
ATOM   2342  C   LYS   318      13.319  44.268  32.614  1.00 12.36      A    C  
ATOM   2343  O   LYS   318      14.477  44.162  32.192  1.00 13.03      A    O  
ATOM   2344  N   ILE   319      12.920  45.273  33.384  1.00 12.75      A    N  
ATOM   2345  CA  ILE   319      13.884  46.257  33.881  1.00 13.42      A    C  
ATOM   2346  CB  ILE   319      13.723  47.645  33.185  1.00 12.92      A    C  
ATOM   2347  CG1 ILE   319      12.313  48.210  33.413  1.00 12.47      A    C  
ATOM   2348  CD1 ILE   319      12.049  49.541  32.682  1.00 14.80      A    C  
ATOM   2349  CG2 ILE   319      14.100  47.515  31.707  1.00 11.76      A    C  
ATOM   2350  C   ILE   319      13.804  46.382  35.397  1.00 14.59      A    C  
ATOM   2351  O   ILE   319      14.383  47.310  35.989  1.00 15.37      A    O  
ATOM   2352  N   SER   320      13.069  45.449  36.003  1.00 15.21      A    N  
ATOM   2353  CA  SER   320      13.081  45.230  37.452  1.00 16.19      A    C  
ATOM   2354  CB  SER   320      11.847  45.846  38.087  1.00 16.25      A    C  
ATOM   2355  OG  SER   320      10.670  45.381  37.458  1.00 18.25      A    O  
ATOM   2356  C   SER   320      13.129  43.712  37.712  1.00 16.19      A    C  
ATOM   2357  O   SER   320      12.763  42.920  36.849  1.00 15.55      A    O  
ATOM   2358  N   GLY   321      13.602  43.316  38.890  1.00 16.52      A    N  
ATOM   2359  CA  GLY   321      13.882  41.896  39.162  1.00 16.25      A    C  
ATOM   2360  C   GLY   321      12.718  41.085  39.696  1.00 17.17      A    C  
ATOM   2361  O   GLY   321      11.627  41.608  39.944  1.00 16.94      A    O  
ATOM   2362  N   PRO   322      12.945  39.789  39.908  1.00 17.42      A    N  
ATOM   2363  CA  PRO   322      11.844  38.905  40.261  1.00 18.52      A    C  
ATOM   2364  CB  PRO   322      12.500  37.519  40.303  1.00 18.42      A    C  
ATOM   2365  CG  PRO   322      13.974  37.795  40.469  1.00 17.83      A    C  
ATOM   2366  CD  PRO   322      14.204  39.052  39.695  1.00 17.21      A    C  
ATOM   2367  C   PRO   322      11.161  39.229  41.593  1.00 19.93      A    C  
ATOM   2368  O   PRO   322      10.013  38.843  41.782  1.00 20.35      A    O  
ATOM   2369  N   HIS   323      11.829  39.942  42.494  1.00 20.90      A    N  
ATOM   2370  CA  HIS   323      11.185  40.255  43.772  1.00 22.55      A    C  
ATOM   2371  CB  HIS   323      12.080  39.837  44.937  1.00 22.90      A    C  
ATOM   2372  CG  HIS   323      12.218  38.359  45.062  1.00 24.46      A    C  
ATOM   2373  ND1 HIS   323      11.126  37.521  45.140  1.00 26.17      A    N  
ATOM   2374  CE1 HIS   323      11.543  36.271  45.231  1.00 27.59      A    C  
ATOM   2375  NE2 HIS   323      12.865  36.271  45.223  1.00 26.79      A    N  
ATOM   2376  CD2 HIS   323      13.311  37.563  45.110  1.00 24.98      A    C  
ATOM   2377  C   HIS   323      10.749  41.697  43.916  1.00 23.21      A    C  
ATOM   2378  O   HIS   323      10.418  42.147  45.020  1.00 23.62      A    O  
ATOM   2379  N   GLU   324      10.749  42.424  42.806  1.00 23.33      A    N  
ATOM   2380  CA  GLU   324      10.331  43.819  42.824  1.00 24.07      A    C  
ATOM   2381  CB  GLU   324      11.335  44.697  42.077  1.00 24.29      A    C  
ATOM   2382  CG  GLU   324      12.749  44.691  42.607  1.00 25.23      A    C  
ATOM   2383  CD  GLU   324      13.650  45.578  41.777  1.00 27.39      A    C  
ATOM   2384  OE1 GLU   324      14.561  45.049  41.103  1.00 27.69      A    O  
ATOM   2385  OE2 GLU   324      13.426  46.808  41.776  1.00 29.72      A    O  
ATOM   2386  C   GLU   324       8.980  43.948  42.152  1.00 24.06      A    C  
ATOM   2387  O   GLU   324       8.636  43.158  41.274  1.00 24.04      A    O  
ATOM   2388  N   PRO   325       8.210  44.973  42.541  1.00 24.33      A    N  
ATOM   2389  CA  PRO   325       6.961  45.220  41.834  1.00 24.05      A    C  
ATOM   2390  CB  PRO   325       6.363  46.420  42.576  1.00 23.88      A    C  
ATOM   2391  CG  PRO   325       7.544  47.123  43.205  1.00 24.83      A    C  
ATOM   2392  CD  PRO   325       8.617  46.083  43.422  1.00 24.45      A    C  
ATOM   2393  C   PRO   325       7.278  45.555  40.375  1.00 23.37      A    C  
ATOM   2394  O   PRO   325       8.368  46.047  40.082  1.00 23.94      A    O  
ATOM   2395  N   ALA   326       6.351  45.273  39.470  1.00 22.84      A    N  
ATOM   2396  CA  ALA   326       6.627  45.446  38.055  1.00 21.74      A    C  
ATOM   2397  CB  ALA   326       5.493  44.889  37.217  1.00 22.03      A    C  
ATOM   2398  C   ALA   326       6.882  46.916  37.723  1.00 21.03      A    C  
ATOM   2399  O   ALA   326       6.162  47.801  38.194  1.00 21.31      A    O  
ATOM   2400  N   ALA   327       7.918  47.163  36.928  1.00 19.59      A    N  
ATOM   2401  CA  ALA   327       8.256  48.506  36.477  1.00 17.91      A    C  
ATOM   2402  CB  ALA   327       9.683  48.549  35.945  1.00 18.12      A    C  
ATOM   2403  C   ALA   327       7.284  48.951  35.395  1.00 16.70      A    C  
ATOM   2404  O   ALA   327       6.733  48.127  34.673  1.00 16.86      A    O  
ATOM   2405  N   ASP   328       7.086  50.261  35.279  1.00 14.08      A    N  
ATOM   2406  CA  ASP   328       6.267  50.816  34.199  1.00 12.69      A    C  
ATOM   2407  CB  ASP   328       5.993  52.285  34.514  1.00 12.36      A    C  
ATOM   2408  CG  ASP   328       4.814  52.868  33.745  1.00 11.56      A    C  
ATOM   2409  OD1 ASP   328       4.097  52.156  33.009  1.00  9.11      A    O  
ATOM   2410  OD2 ASP   328       4.601  54.092  33.904  1.00 12.11      A    O  
ATOM   2411  C   ASP   328       7.076  50.712  32.908  1.00 11.31      A    C  
ATOM   2412  O   ASP   328       8.271  50.381  32.944  1.00 11.06      A    O  
ATOM   2413  N   PHE   329       6.435  50.966  31.769  1.00  9.85      A    N  
ATOM   2414  CA  PHE   329       7.165  51.233  30.527  1.00  9.04      A    C  
ATOM   2415  CB  PHE   329       6.235  51.797  29.445  1.00  8.38      A    C  
ATOM   2416  CG  PHE   329       5.243  50.814  28.869  1.00  7.77      A    C  
ATOM   2417  CD1 PHE   329       5.485  49.457  28.838  1.00  6.76      A    C  
ATOM   2418  CE1 PHE   329       4.554  48.588  28.282  1.00  8.22      A    C  
ATOM   2419  CZ  PHE   329       3.376  49.084  27.736  1.00  8.19      A    C  
ATOM   2420  CE2 PHE   329       3.129  50.427  27.770  1.00  8.16      A    C  
ATOM   2421  CD2 PHE   329       4.060  51.289  28.330  1.00  6.55      A    C  
ATOM   2422  C   PHE   329       8.139  52.371  30.813  1.00  9.21      A    C  
ATOM   2423  O   PHE   329       7.837  53.265  31.617  1.00  9.11      A    O  
ATOM   2424  N   ALA   330       9.288  52.361  30.140  1.00  9.36      A    N  
ATOM   2425  CA  ALA   330      10.223  53.476  30.229  1.00  9.70      A    C  
ATOM   2426  CB  ALA   330      11.544  53.016  30.846  1.00 10.09      A    C  
ATOM   2427  C   ALA   330      10.446  54.064  28.848  1.00  9.72      A    C  
ATOM   2428  O   ALA   330      10.839  53.360  27.921  1.00 10.20      A    O  
ATOM   2429  N   ILE   331      10.128  55.345  28.688  1.00  9.12      A    N  
ATOM   2430  CA  ILE   331      10.407  56.050  27.438  1.00 10.05      A    C  
ATOM   2431  CB  ILE   331       9.101  56.490  26.710  1.00  9.64      A    C  
ATOM   2432  CG1 ILE   331       8.202  55.268  26.558  1.00  9.54      A    C  
ATOM   2433  CD1 ILE   331       6.788  55.563  26.050  1.00 11.62      A    C  
ATOM   2434  CG2 ILE   331       9.426  57.131  25.363  1.00 10.71      A    C  
ATOM   2435  C   ILE   331      11.314  57.227  27.765  1.00 10.54      A    C  
ATOM   2436  O   ILE   331      10.850  58.291  28.174  1.00 11.51      A    O  
ATOM   2437  N   ALA   332      12.623  57.009  27.657  1.00 10.84      A    N  
ATOM   2438  CA  ALA   332      13.598  57.980  28.152  1.00 11.17      A    C  
ATOM   2439  CB  ALA   332      14.781  57.246  28.838  1.00 10.60      A    C  
ATOM   2440  C   ALA   332      14.107  58.910  27.061  1.00 11.87      A    C  
ATOM   2441  O   ALA   332      14.918  58.521  26.203  1.00 11.49      A    O  
ATOM   2442  N   GLY   333      13.631  60.155  27.101  1.00 13.02      A    N  
ATOM   2443  CA  GLY   333      14.023  61.183  26.144  1.00 14.29      A    C  
ATOM   2444  C   GLY   333      15.041  62.142  26.761  1.00 15.51      A    C  
ATOM   2445  O   GLY   333      15.561  61.891  27.845  1.00 15.60      A    O  
ATOM   2446  N   PRO   334      15.343  63.241  26.061  1.00 16.59      A    N  
ATOM   2447  CA  PRO   334      16.346  64.208  26.526  1.00 17.80      A    C  
ATOM   2448  CB  PRO   334      16.278  65.305  25.463  1.00 17.73      A    C  
ATOM   2449  CG  PRO   334      15.925  64.575  24.229  1.00 17.84      A    C  
ATOM   2450  CD  PRO   334      14.950  63.494  24.668  1.00 16.65      A    C  
ATOM   2451  C   PRO   334      16.105  64.778  27.933  1.00 18.66      A    C  
ATOM   2452  O   PRO   334      17.066  65.110  28.642  1.00 18.90      A    O  
ATOM   2453  N   ALA   335      14.846  64.858  28.356  1.00 19.40      A    N  
ATOM   2454  CA  ALA   335      14.533  65.424  29.665  1.00 20.51      A    C  
ATOM   2455  CB  ALA   335      13.043  65.693  29.788  1.00 20.69      A    C  
ATOM   2456  C   ALA   335      15.004  64.562  30.824  1.00 20.87      A    C  
ATOM   2457  O   ALA   335      15.080  65.028  31.956  1.00 21.60      A    O  
ATOM   2458  N   SER   336      15.310  63.295  30.562  1.00 21.26      A    N  
ATOM   2459  CA  SER   336      15.780  62.454  31.650  1.00 21.23      A    C  
ATOM   2460  CB  SER   336      14.891  61.229  31.844  1.00 22.07      A    C  
ATOM   2461  OG  SER   336      15.031  60.332  30.775  1.00 22.98      A    O  
ATOM   2462  C   SER   336      17.250  62.070  31.532  1.00 20.80      A    C  
ATOM   2463  O   SER   336      17.946  62.003  32.538  1.00 21.80      A    O  
ATOM   2464  N   HIS   337      17.733  61.838  30.318  1.00 19.40      A    N  
ATOM   2465  CA  HIS   337      19.129  61.435  30.158  1.00 18.27      A    C  
ATOM   2466  CB  HIS   337      19.247  60.170  29.305  1.00 17.22      A    C  
ATOM   2467  CG  HIS   337      18.637  60.284  27.943  1.00 16.05      A    C  
ATOM   2468  ND1 HIS   337      18.946  61.299  27.062  1.00 12.91      A    N  
ATOM   2469  CE1 HIS   337      18.270  61.122  25.939  1.00 14.15      A    C  
ATOM   2470  NE2 HIS   337      17.539  60.027  26.059  1.00 11.99      A    N  
ATOM   2471  CD2 HIS   337      17.742  59.489  27.304  1.00 13.08      A    C  
ATOM   2472  C   HIS   337      20.038  62.544  29.623  1.00 17.98      A    C  
ATOM   2473  O   HIS   337      21.265  62.390  29.586  1.00 18.39      A    O  
ATOM   2474  N   GLY   338      19.438  63.655  29.205  1.00 17.54      A    N  
ATOM   2475  CA  GLY   338      20.212  64.820  28.790  1.00 17.18      A    C  
ATOM   2476  C   GLY   338      20.767  64.798  27.381  1.00 17.65      A    C  
ATOM   2477  O   GLY   338      21.467  65.726  26.968  1.00 17.52      A    O  
ATOM   2478  N   VAL   339      20.475  63.743  26.624  1.00 16.83      A    N  
ATOM   2479  CA  VAL   339      21.014  63.639  25.279  1.00 16.57      A    C  
ATOM   2480  CB  VAL   339      21.485  62.209  24.959  1.00 15.97      A    C  
ATOM   2481  CG1 VAL   339      22.114  62.166  23.571  1.00 16.43      A    C  
ATOM   2482  CG2 VAL   339      22.463  61.726  26.015  1.00 16.35      A    C  
ATOM   2483  C   VAL   339      20.024  64.098  24.207  1.00 16.67      A    C  
ATOM   2484  O   VAL   339      19.030  63.424  23.915  1.00 16.40      A    O  
ATOM   2485  N   ALA   340      20.305  65.248  23.600  1.00 16.95      A    N  
ATOM   2486  CA  ALA   340      19.451  65.739  22.533  1.00 16.86      A    C  
ATOM   2487  CB  ALA   340      19.970  67.078  22.003  1.00 17.42      A    C  
ATOM   2488  C   ALA   340      19.325  64.715  21.393  1.00 15.91      A    C  
ATOM   2489  O   ALA   340      20.316  64.135  20.941  1.00 16.33      A    O  
ATOM   2490  N   GLY   341      18.104  64.496  20.927  1.00 14.96      A    N  
ATOM   2491  CA  GLY   341      17.891  63.665  19.740  1.00 13.79      A    C  
ATOM   2492  C   GLY   341      17.781  62.163  19.993  1.00 12.87      A    C  
ATOM   2493  O   GLY   341      17.668  61.381  19.052  1.00 12.89      A    O  
ATOM   2494  N   LEU   342      17.785  61.773  21.258  1.00 12.27      A    N  
ATOM   2495  CA  LEU   342      17.794  60.352  21.629  1.00 11.43      A    C  
ATOM   2496  CB  LEU   342      19.079  60.047  22.405  1.00 11.60      A    C  
ATOM   2497  CG  LEU   342      19.194  58.643  23.006  1.00 10.88      A    C  
ATOM   2498  CD1 LEU   342      19.352  57.606  21.904  1.00 10.65      A    C  
ATOM   2499  CD2 LEU   342      20.336  58.587  24.016  1.00 12.16      A    C  
ATOM   2500  C   LEU   342      16.579  59.938  22.470  1.00 10.74      A    C  
ATOM   2501  O   LEU   342      16.264  60.570  23.478  1.00 10.56      A    O  
ATOM   2502  N   VAL   343      15.904  58.858  22.071  1.00  9.89      A    N  
ATOM   2503  CA  VAL   343      14.918  58.247  22.940  1.00  9.41      A    C  
ATOM   2504  CB  VAL   343      13.479  58.361  22.398  1.00  9.37      A    C  
ATOM   2505  CG1 VAL   343      12.513  57.679  23.376  1.00  9.75      A    C  
ATOM   2506  CG2 VAL   343      13.097  59.851  22.249  1.00 10.33      A    C  
ATOM   2507  C   VAL   343      15.283  56.773  23.089  1.00  9.14      A    C  
ATOM   2508  O   VAL   343      15.464  56.072  22.095  1.00  8.81      A    O  
ATOM   2509  N   ASN   344      15.429  56.336  24.326  1.00  9.10      A    N  
ATOM   2510  CA  ASN   344      15.610  54.911  24.618  1.00  9.14      A    C  
ATOM   2511  CB  ASN   344      16.651  54.718  25.727  1.00  9.42      A    C  
ATOM   2512  CG  ASN   344      18.044  55.142  25.315  1.00  9.13      A    C  
ATOM   2513  OD1 ASN   344      18.576  54.657  24.325  1.00  9.81      A    O  
ATOM   2514  ND2 ASN   344      18.647  56.061  26.079  1.00 10.83      A    N  
ATOM   2515  C   ASN   344      14.281  54.391  25.125  1.00  9.30      A    C  
ATOM   2516  O   ASN   344      13.667  55.005  26.011  1.00  9.51      A    O  
ATOM   2517  N   LEU   345      13.826  53.261  24.601  1.00  9.17      A    N  
ATOM   2518  CA  LEU   345      12.637  52.643  25.164  1.00  8.30      A    C  
ATOM   2519  CB  LEU   345      11.612  52.314  24.088  1.00  8.45      A    C  
ATOM   2520  CG  LEU   345      10.956  53.550  23.454  1.00  7.71      A    C  
ATOM   2521  CD1 LEU   345      11.731  54.027  22.238  1.00  7.74      A    C  
ATOM   2522  CD2 LEU   345       9.519  53.222  23.079  1.00 10.22      A    C  
ATOM   2523  C   LEU   345      13.041  51.379  25.906  1.00  8.26      A    C  
ATOM   2524  O   LEU   345      13.699  50.507  25.325  1.00  8.86      A    O  
ATOM   2525  N   TYR   346      12.675  51.290  27.178  1.00  7.95      A    N  
ATOM   2526  CA  TYR   346      13.024  50.130  27.996  1.00  7.85      A    C  
ATOM   2527  CB  TYR   346      13.941  50.515  29.159  1.00  8.77      A    C  
ATOM   2528  CG  TYR   346      15.152  51.358  28.854  1.00  8.37      A    C  
ATOM   2529  CD1 TYR   346      16.120  50.933  27.964  1.00  7.75      A    C  
ATOM   2530  CE1 TYR   346      17.258  51.695  27.710  1.00  8.11      A    C  
ATOM   2531  CZ  TYR   346      17.440  52.888  28.373  1.00  9.48      A    C  
ATOM   2532  OH  TYR   346      18.565  53.655  28.134  1.00 11.19      A    O  
ATOM   2533  CE2 TYR   346      16.490  53.340  29.271  1.00  9.35      A    C  
ATOM   2534  CD2 TYR   346      15.352  52.564  29.512  1.00  8.85      A    C  
ATOM   2535  C   TYR   346      11.794  49.490  28.617  1.00  7.97      A    C  
ATOM   2536  O   TYR   346      10.821  50.171  28.959  1.00  8.23      A    O  
ATOM   2537  N   GLY   347      11.829  48.171  28.779  1.00  7.68      A    N  
ATOM   2538  CA  GLY   347      10.769  47.465  29.501  1.00  7.05      A    C  
ATOM   2539  C   GLY   347       9.404  47.523  28.830  1.00  6.74      A    C  
ATOM   2540  O   GLY   347       8.374  47.561  29.511  1.00  7.05      A    O  
ATOM   2541  N   ILE   348       9.395  47.483  27.504  1.00  6.52      A    N  
ATOM   2542  CA  ILE   348       8.136  47.526  26.752  1.00  6.03      A    C  
ATOM   2543  CB  ILE   348       8.285  48.276  25.391  1.00  6.46      A    C  
ATOM   2544  CG1 ILE   348       8.997  49.627  25.558  1.00  7.27      A    C  
ATOM   2545  CD1 ILE   348       8.354  50.642  26.522  1.00  9.00      A    C  
ATOM   2546  CG2 ILE   348       6.892  48.424  24.700  1.00  5.84      A    C  
ATOM   2547  C   ILE   348       7.610  46.099  26.584  1.00  5.80      A    C  
ATOM   2548  O   ILE   348       7.639  45.509  25.484  1.00  6.23      A    O  
ATOM   2549  N   GLU   349       7.145  45.554  27.706  1.00  5.60      A    N  
ATOM   2550  CA  GLU   349       6.560  44.224  27.760  1.00  6.88      A    C  
ATOM   2551  CB  GLU   349       6.842  43.567  29.129  1.00  7.34      A    C  
ATOM   2552  CG  GLU   349       6.362  44.402  30.347  1.00  7.51      A    C  
ATOM   2553  CD  GLU   349       6.334  43.614  31.656  1.00 13.20      A    C  
ATOM   2554  OE1 GLU   349       6.539  42.377  31.618  1.00 13.64      A    O  
ATOM   2555  OE2 GLU   349       6.083  44.247  32.718  1.00 11.20      A    O  
ATOM   2556  C   GLU   349       5.065  44.414  27.514  1.00  6.72      A    C  
ATOM   2557  O   GLU   349       4.665  45.454  26.982  1.00  6.59      A    O  
ATOM   2558  N   SER   350       4.238  43.448  27.888  1.00  6.51      A    N  
ATOM   2559  CA  SER   350       2.787  43.679  27.786  1.00  6.93      A    C  
ATOM   2560  CB  SER   350       2.037  42.462  28.298  1.00  7.61      A    C  
ATOM   2561  OG  SER   350       0.649  42.645  28.093  1.00  6.79      A    O  
ATOM   2562  C   SER   350       2.385  44.915  28.609  1.00  6.47      A    C  
ATOM   2563  O   SER   350       2.844  45.095  29.734  1.00  6.32      A    O  
ATOM   2564  N   PRO   351       1.469  45.748  28.091  1.00  6.20      A    N  
ATOM   2565  CA  PRO   351       0.677  45.615  26.860  1.00  6.13      A    C  
ATOM   2566  CB  PRO   351      -0.680  46.177  27.290  1.00  5.56      A    C  
ATOM   2567  CG  PRO   351      -0.291  47.324  28.201  1.00  5.26      A    C  
ATOM   2568  CD  PRO   351       0.923  46.802  28.979  1.00  6.27      A    C  
ATOM   2569  C   PRO   351       1.247  46.469  25.724  1.00  6.66      A    C  
ATOM   2570  O   PRO   351       0.535  47.297  25.141  1.00  6.93      A    O  
ATOM   2571  N   GLY   352       2.528  46.279  25.424  1.00  6.23      A    N  
ATOM   2572  CA  GLY   352       3.221  47.057  24.393  1.00  6.36      A    C  
ATOM   2573  C   GLY   352       2.611  46.989  23.010  1.00  6.31      A    C  
ATOM   2574  O   GLY   352       2.661  47.968  22.254  1.00  7.52      A    O  
ATOM   2575  N   LEU   353       2.054  45.835  22.642  1.00  6.27      A    N  
ATOM   2576  CA  LEU   353       1.455  45.707  21.318  1.00  7.16      A    C  
ATOM   2577  CB  LEU   353       1.095  44.255  21.030  1.00  7.99      A    C  
ATOM   2578  CG  LEU   353       0.158  43.990  19.855  1.00 10.82      A    C  
ATOM   2579  CD1 LEU   353       0.843  44.264  18.547  1.00 16.56      A    C  
ATOM   2580  CD2 LEU   353      -0.289  42.509  19.923  1.00 16.29      A    C  
ATOM   2581  C   LEU   353       0.205  46.589  21.288  1.00  6.93      A    C  
ATOM   2582  O   LEU   353       0.004  47.385  20.364  1.00  6.88      A    O  
ATOM   2583  N   THR   354      -0.602  46.474  22.336  1.00  6.61      A    N  
ATOM   2584  CA  THR   354      -1.850  47.248  22.409  1.00  6.44      A    C  
ATOM   2585  CB  THR   354      -2.632  46.903  23.689  1.00  6.43      A    C  
ATOM   2586  OG1 THR   354      -2.966  45.514  23.667  1.00  6.69      A    O  
ATOM   2587  CG2 THR   354      -3.918  47.731  23.786  1.00  6.28      A    C  
ATOM   2588  C   THR   354      -1.521  48.732  22.408  1.00  6.59      A    C  
ATOM   2589  O   THR   354      -2.214  49.544  21.765  1.00  6.88      A    O  
ATOM   2590  N   ALA   355      -0.462  49.090  23.129  1.00  6.00      A    N  
ATOM   2591  CA  ALA   355      -0.102  50.497  23.329  1.00  6.80      A    C  
ATOM   2592  CB  ALA   355       0.702  50.665  24.630  1.00  7.17      A    C  
ATOM   2593  C   ALA   355       0.702  51.076  22.167  1.00  6.95      A    C  
ATOM   2594  O   ALA   355       1.009  52.271  22.176  1.00  7.73      A    O  
ATOM   2595  N   SER   356       1.078  50.238  21.199  1.00  6.68      A    N  
ATOM   2596  CA  SER   356       2.108  50.626  20.216  1.00  7.20      A    C  
ATOM   2597  CB  SER   356       2.309  49.550  19.137  1.00  7.64      A    C  
ATOM   2598  OG  SER   356       1.102  49.228  18.463  1.00  8.71      A    O  
ATOM   2599  C   SER   356       1.936  52.014  19.569  1.00  7.23      A    C  
ATOM   2600  O   SER   356       2.903  52.768  19.483  1.00  7.57      A    O  
ATOM   2601  N   LEU   357       0.734  52.340  19.085  1.00  7.09      A    N  
ATOM   2602  CA  LEU   357       0.583  53.618  18.388  1.00  7.54      A    C  
ATOM   2603  CB  LEU   357      -0.721  53.673  17.576  1.00  8.40      A    C  
ATOM   2604  CG  LEU   357      -0.855  52.660  16.434  1.00  6.87      A    C  
ATOM   2605  CD1 LEU   357       0.102  52.998  15.300  1.00  8.88      A    C  
ATOM   2606  CD2 LEU   357      -2.316  52.682  15.929  1.00  9.76      A    C  
ATOM   2607  C   LEU   357       0.663  54.774  19.379  1.00  8.05      A    C  
ATOM   2608  O   LEU   357       1.137  55.866  19.034  1.00  8.30      A    O  
ATOM   2609  N   ALA   358       0.199  54.545  20.604  1.00  7.75      A    N  
ATOM   2610  CA  ALA   358       0.332  55.540  21.651  1.00  7.72      A    C  
ATOM   2611  CB  ALA   358      -0.617  55.235  22.814  1.00  8.67      A    C  
ATOM   2612  C   ALA   358       1.774  55.692  22.127  1.00  8.33      A    C  
ATOM   2613  O   ALA   358       2.228  56.795  22.417  1.00  8.54      A    O  
ATOM   2614  N   ILE   359       2.510  54.587  22.163  1.00  6.73      A    N  
ATOM   2615  CA  ILE   359       3.923  54.675  22.489  1.00  6.96      A    C  
ATOM   2616  CB  ILE   359       4.563  53.285  22.609  1.00  6.82      A    C  
ATOM   2617  CG1 ILE   359       4.046  52.571  23.861  1.00  6.31      A    C  
ATOM   2618  CD1 ILE   359       4.282  51.015  23.857  1.00  6.58      A    C  
ATOM   2619  CG2 ILE   359       6.101  53.411  22.632  1.00  6.91      A    C  
ATOM   2620  C   ILE   359       4.661  55.508  21.424  1.00  6.55      A    C  
ATOM   2621  O   ILE   359       5.545  56.303  21.766  1.00  6.92      A    O  
ATOM   2622  N   ALA   360       4.304  55.328  20.155  1.00  7.28      A    N  
ATOM   2623  CA  ALA   360       4.848  56.173  19.077  1.00  8.37      A    C  
ATOM   2624  CB  ALA   360       4.310  55.746  17.727  1.00  9.00      A    C  
ATOM   2625  C   ALA   360       4.545  57.654  19.335  1.00  9.08      A    C  
ATOM   2626  O   ALA   360       5.440  58.502  19.249  1.00  9.65      A    O  
ATOM   2627  N   GLU   361       3.298  57.979  19.666  1.00  9.42      A    N  
ATOM   2628  CA  GLU   361       2.973  59.374  19.992  1.00 10.25      A    C  
ATOM   2629  CB  GLU   361       1.509  59.498  20.414  1.00 10.25      A    C  
ATOM   2630  CG  GLU   361       0.531  59.274  19.276  1.00 11.45      A    C  
ATOM   2631  CD  GLU   361      -0.930  59.463  19.712  1.00 14.44      A    C  
ATOM   2632  OE1 GLU   361      -1.268  59.103  20.852  1.00 15.38      A    O  
ATOM   2633  OE2 GLU   361      -1.737  59.988  18.903  1.00 14.41      A    O  
ATOM   2634  C   GLU   361       3.852  59.908  21.114  1.00 10.18      A    C  
ATOM   2635  O   GLU   361       4.403  61.010  21.021  1.00 10.62      A    O  
ATOM   2636  N   GLU   362       3.984  59.117  22.175  1.00  9.87      A    N  
ATOM   2637  CA  GLU   362       4.710  59.542  23.368  1.00 10.55      A    C  
ATOM   2638  CB  GLU   362       4.427  58.588  24.539  1.00 10.82      A    C  
ATOM   2639  CG  GLU   362       4.983  59.077  25.887  1.00 12.80      A    C  
ATOM   2640  CD  GLU   362       4.281  60.333  26.433  1.00 15.84      A    C  
ATOM   2641  OE1 GLU   362       4.832  60.978  27.346  1.00 18.23      A    O  
ATOM   2642  OE2 GLU   362       3.172  60.661  25.981  1.00 15.97      A    O  
ATOM   2643  C   GLU   362       6.216  59.691  23.116  1.00 10.27      A    C  
ATOM   2644  O   GLU   362       6.875  60.577  23.677  1.00  9.43      A    O  
ATOM   2645  N   THR   363       6.759  58.832  22.261  1.00 10.60      A    N  
ATOM   2646  CA  THR   363       8.173  58.925  21.908  1.00 11.59      A    C  
ATOM   2647  CB  THR   363       8.630  57.753  21.039  1.00 12.17      A    C  
ATOM   2648  OG1 THR   363       7.900  57.757  19.815  1.00 19.07      A    O  
ATOM   2649  CG2 THR   363       8.370  56.466  21.742  1.00  7.00      A    C  
ATOM   2650  C   THR   363       8.461  60.226  21.185  1.00 12.00      A    C  
ATOM   2651  O   THR   363       9.432  60.916  21.505  1.00 12.55      A    O  
ATOM   2652  N   LEU   364       7.611  60.579  20.231  1.00 12.00      A    N  
ATOM   2653  CA  LEU   364       7.800  61.838  19.521  1.00 13.53      A    C  
ATOM   2654  CB  LEU   364       6.855  61.939  18.322  1.00 13.46      A    C  
ATOM   2655  CG  LEU   364       7.391  61.374  17.002  1.00 13.50      A    C  
ATOM   2656  CD1 LEU   364       6.438  61.706  15.872  1.00 14.21      A    C  
ATOM   2657  CD2 LEU   364       7.620  59.850  17.065  1.00 13.39      A    C  
ATOM   2658  C   LEU   364       7.650  63.028  20.473  1.00 14.28      A    C  
ATOM   2659  O   LEU   364       8.400  63.993  20.387  1.00 14.05      A    O  
ATOM   2660  N   ALA   365       6.701  62.940  21.399  1.00 14.54      A    N  
ATOM   2661  CA  ALA   365       6.456  64.017  22.362  1.00 15.78      A    C  
ATOM   2662  CB  ALA   365       5.235  63.692  23.210  1.00 15.20      A    C  
ATOM   2663  C   ALA   365       7.659  64.240  23.260  1.00 16.57      A    C  
ATOM   2664  O   ALA   365       7.978  65.380  23.628  1.00 17.17      A    O  
ATOM   2665  N   ARG   366       8.301  63.148  23.646  1.00 16.44      A    N  
ATOM   2666  CA  ARG   366       9.441  63.150  24.544  1.00 17.63      A    C  
ATOM   2667  CB  ARG   366       9.579  61.799  25.280  1.00 17.68      A    C  
ATOM   2668  CG  ARG   366       8.565  61.657  26.343  1.00 18.23      A    C  
ATOM   2669  CD  ARG   366       8.601  60.446  27.266  1.00 21.06      A    C  
ATOM   2670  NE  ARG   366       7.442  60.466  28.144  1.00 25.26      A    N  
ATOM   2671  CZ  ARG   366       7.358  59.790  29.262  1.00 22.92      A    C  
ATOM   2672  NH1 ARG   366       8.347  59.006  29.599  1.00 28.39      A    N  
ATOM   2673  NH2 ARG   366       6.331  59.852  30.060  1.00 22.15      A    N  
ATOM   2674  C   ARG   366      10.719  63.557  23.788  1.00 18.21      A    C  
ATOM   2675  O   ARG   366      11.569  64.197  24.315  1.00 18.20      A    O  
ATOM   2676  N   LEU   367      10.815  63.138  22.551  1.00 18.40      A    N  
ATOM   2677  CA  LEU   367      11.953  63.482  21.718  1.00 19.46      A    C  
ATOM   2678  CB  LEU   367      11.813  62.827  20.343  1.00 19.34      A    C  
ATOM   2679  CG  LEU   367      12.834  63.151  19.259  1.00 18.92      A    C  
ATOM   2680  CD1 LEU   367      12.482  62.407  17.961  1.00 17.71      A    C  
ATOM   2681  CD2 LEU   367      14.232  62.824  19.732  1.00 19.16      A    C  
ATOM   2682  C   LEU   367      12.005  65.005  21.610  1.00 20.53      A    C  
ATOM   2683  O   LEU   367      13.077  65.601  21.550  1.00 20.59      A    O  
ATOM   2684  N   ALA   368      10.835  65.630  21.629  1.00 21.55      A    N  
ATOM   2685  CA  ALA   368      10.751  67.091  21.637  1.00 22.12      A    C  
ATOM   2686  CB  ALA   368       9.365  67.529  21.211  1.00 22.49      A    C  
ATOM   2687  C   ALA   368      11.095  67.663  23.015  1.00 22.64      A    C  
ATOM   2688  O   ALA   368      11.340  68.879  23.162  1.00 23.74      A    O  
END
