
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  108 ( 1635),  selected  108 , name 2jre_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2jre_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    H     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    Y     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    A     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    G    10_A      S       1          3.530
LGA    F    11_A      M       2          1.504
LGA    S    12_A      E       3          1.528
LGA    L    13_A      I       4          1.005
LGA    Y    14_A      L       5          1.880
LGA    S    15_A      Q       6          1.706
LGA    V    16_A      V       7          1.491
LGA    E    17_A      A       8          1.864
LGA    L    18_A      L       9          1.067
LGA    F    19_A      H      10          1.300
LGA    R    20_A      K      11          1.971
LGA    E    21_A      R      12          2.426
LGA    K    22_A      D      13          2.906
LGA    D    23_A      S      14          5.058
LGA    T    24_A      G      15          4.626
LGA    S    25_A      E      16          3.680
LGA    S    26_A      Q      17          1.528
LGA    L    27_A      L      18          0.763
LGA    G    28_A      G      19          1.134
LGA    I    29_A      I      20          1.652
LGA    S    30_A      K      21          0.959
LGA    I    31_A      L      22          0.825
LGA    S    32_A      V      23          1.064
LGA    G    33_A      R      24          1.380
LGA    M    34_A      R      25          1.360
LGA    R    35_A      T      26          1.863
LGA    D    36_A      D      27          3.389
LGA    Q    37_A      -       -           -
LGA    S    38_A      -       -           -
LGA    T    39_A      -       -           -
LGA    T    40_A      -       -           -
LGA    G    41_A      -       -           -
LGA    E    42_A      -       -           -
LGA    A    43_A      E      28          2.696
LGA    T    44_A      P      29          2.673
LGA    G    45_A      G      30          1.593
LGA    I    46_A      V      31          0.728
LGA    Y    47_A      F      32          0.534
LGA    V    48_A      I      33          0.543
LGA    K    49_A      L      34          0.441
LGA    S    50_A      D      35          1.759
LGA    L    51_A      L      36          1.510
LGA    I    52_A      L      37          1.870
LGA    P    53_A      E      38          1.996
LGA    G    54_A      G      39          2.377
LGA    S    55_A      G      40          2.023
LGA    A    56_A      L      41          1.331
LGA    A    57_A      A      42          1.045
LGA    A    58_A      A      43          1.461
LGA    L    59_A      Q      44          1.001
LGA    D    60_A      D      45          0.614
LGA    G    61_A      G      46          1.024
LGA    R    62_A      R      47          1.262
LGA    I    63_A      L      48          1.774
LGA    E    64_A      S      49          2.035
LGA    P    65_A      S      50          1.744
LGA    N    66_A      N      51          1.996
LGA    D    67_A      D      52          1.080
LGA    K    68_A      R      53          0.974
LGA    I    69_A      V      54          0.909
LGA    L    70_A      L      55          0.662
LGA    R    71_A      A      56          1.058
LGA    V    72_A      I      57          1.177
LGA    D    73_A      N      58          1.511
LGA    D    74_A      G      59          1.635
LGA    V    75_A      H      60          1.181
LGA    N    76_A      D      61          0.983
LGA    V    77_A      L      62          0.829
LGA    Q    78_A      K      63          1.644
LGA    G    79_A      Y      64          3.004
LGA    M    80_A      G      65          2.798
LGA    A    81_A      T      66          2.809
LGA    Q    82_A      P      67          1.872
LGA    S    83_A      E      68          1.013
LGA    D    84_A      L      69          1.656
LGA    V    85_A      A      70          1.160
LGA    V    86_A      A      71          0.340
LGA    E    87_A      Q      72          1.101
LGA    V    88_A      I      73          0.384
LGA    L    89_A      I      74          0.649
LGA    R    90_A      Q      75          1.097
LGA    N    91_A      A      76          1.065
LGA    A    92_A      S      77          1.072
LGA    G    93_A      G      78          2.574
LGA    N    94_A      E      79          1.677
LGA    P    95_A      R      80          1.428
LGA    V    96_A      V      81          2.241
LGA    R    97_A      N      82          1.524
LGA    L    98_A      L      83          1.313
LGA    L    99_A      T      84          0.785
LGA    L   100_A      I      85          0.549
LGA    I   101_A      A      86          0.980
LGA    R   102_A      R      87          0.980
LGA    R   103_A      P      88          2.523
LGA    -       -      G      89           -
LGA    L   104_A      K      90          2.663
LGA    P   105_A      P      91          2.944
LGA    -       -      E      92           -
LGA    L   106_A      I      93          4.843
LGA    L   107_A      E      94          5.291
LGA    E   108_A      L      95           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  108   95    5.0     92    1.97    23.91     87.018     4.447

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.218382 * X  +  -0.670410 * Y  +   0.709126 * Z  +  11.938395
  Y_new =   0.163604 * X  +   0.691228 * Y  +   0.703873 * Z  +  17.592457
  Z_new =  -0.962051 * X  +   0.269729 * Y  +  -0.041270 * Z  +  10.026491 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.722623   -1.418970  [ DEG:    98.6990    -81.3010 ]
  Theta =   1.294423    1.847169  [ DEG:    74.1650    105.8350 ]
  Phi   =   2.498625   -0.642967  [ DEG:   143.1607    -36.8393 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jre_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jre_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  108   95   5.0   92   1.97   23.91  87.018
REMARK  ---------------------------------------------------------- 
MOLECULE 2jre_A
HEADER    DE NOVO PROTEIN                         25-JUN-07   2JRE              
TITLE     C60-1, A PDZ DOMAIN DESIGNED USING STATISTICAL COUPLING               
TITLE    2 ANALYSIS                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: C60-1 PDZ DOMAIN PEPTIDE;                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 SYNTHETIC: YES;                                                      
SOURCE   3 OTHER_DETAILS: THE PEPTIDE IS A SYNTHETIC CONSTRUCT                  
SOURCE   4 DESIGNED USING STATISTICAL COUPLING ANALYSIS AND EXPRESSED           
SOURCE   5 IN ESCHERICHIA COLI BL21 CELLS USING THE PHIS8.3 VECTOR.             
KEYWDS    C60-1, PDZ, DE NOVO PROTEIN                                           
EXPDTA    NMR, 25 STRUCTURES                                                    
AUTHOR    C.LARSON,M.STIFFLER,P.LI,M.ROSEN,G.MACBEATH,R.RANGANATHAN             
REVDAT   1   01-JUL-08 2JRE    0                                                
JRNL        AUTH   C.LARSON,M.STIFFLER,P.LI,M.ROSEN,G.MACBEATH,                 
JRNL        AUTH 2 R.RANGANATHAN                                                
JRNL        TITL   C60-1, A PDZ DOMAIN DESIGNED USING STATISTICAL               
JRNL        TITL 2 COUPLING ANALYSIS                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
SEQRES   1 A  108  GLY SER HIS GLY TYR SER ASP ALA SER GLY PHE SER LEU          
SEQRES   2 A  108  TYR SER VAL GLU LEU PHE ARG GLU LYS ASP THR SER SER          
SEQRES   3 A  108  LEU GLY ILE SER ILE SER GLY MET ARG ASP GLN SER THR          
SEQRES   4 A  108  THR GLY GLU ALA THR GLY ILE TYR VAL LYS SER LEU ILE          
SEQRES   5 A  108  PRO GLY SER ALA ALA ALA LEU ASP GLY ARG ILE GLU PRO          
SEQRES   6 A  108  ASN ASP LYS ILE LEU ARG VAL ASP ASP VAL ASN VAL GLN          
SEQRES   7 A  108  GLY MET ALA GLN SER ASP VAL VAL GLU VAL LEU ARG ASN          
SEQRES   8 A  108  ALA GLY ASN PRO VAL ARG LEU LEU LEU ILE ARG ARG LEU          
SEQRES   9 A  108  PRO LEU LEU GLU                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      31.828  23.036  10.422  1.00  7.92           N  
ATOM      2  CA  GLY A   1      30.822  22.602  11.430  1.00  7.68           C  
ATOM      3  C   GLY A   1      31.380  21.582  12.404  1.00  6.86           C  
ATOM      4  O   GLY A   1      31.940  20.566  11.995  1.00  7.03           O  
ATOM      5  H1  GLY A   1      31.407  23.730   9.772  1.00  8.13           H  
ATOM      6  H2  GLY A   1      32.157  22.217   9.871  1.00  7.98           H  
ATOM      7  H3  GLY A   1      32.645  23.470  10.896  1.00  8.10           H  
ATOM      8  HA2 GLY A   1      30.488  23.467  11.984  1.00  8.03           H  
ATOM      9  HA3 GLY A   1      29.976  22.168  10.917  1.00  8.04           H  
ATOM     10  N   SER A   2      31.229  21.858  13.697  1.00  6.24           N  
ATOM     11  CA  SER A   2      31.722  20.956  14.732  1.00  5.73           C  
ATOM     12  C   SER A   2      30.574  20.211  15.403  1.00  4.62           C  
ATOM     13  O   SER A   2      30.793  19.246  16.136  1.00  4.63           O  
ATOM     14  CB  SER A   2      32.516  21.736  15.781  1.00  6.38           C  
ATOM     15  OG  SER A   2      33.616  22.410  15.193  1.00  7.18           O  
ATOM     16  H   SER A   2      30.774  22.685  13.959  1.00  6.37           H  
ATOM     17  HA  SER A   2      32.376  20.238  14.262  1.00  6.04           H  
ATOM     18  HB2 SER A   2      31.871  22.467  16.248  1.00  6.43           H  
ATOM     19  HB3 SER A   2      32.887  21.052  16.531  1.00  6.54           H  
ATOM     20  HG  SER A   2      34.394  21.848  15.232  1.00  7.25           H  
ATOM     21  N   HIS A   3      29.350  20.664  15.149  1.00  4.05           N  
ATOM     22  CA  HIS A   3      28.170  20.038  15.733  1.00  3.23           C  
ATOM     23  C   HIS A   3      28.038  18.587  15.277  1.00  2.51           C  
ATOM     24  O   HIS A   3      27.953  18.308  14.081  1.00  2.56           O  
ATOM     25  CB  HIS A   3      26.909  20.820  15.353  1.00  3.35           C  
ATOM     26  CG  HIS A   3      27.000  22.286  15.648  1.00  4.25           C  
ATOM     27  ND1 HIS A   3      27.324  23.226  14.692  1.00  4.88           N  
ATOM     28  CD2 HIS A   3      26.803  22.974  16.798  1.00  5.02           C  
ATOM     29  CE1 HIS A   3      27.322  24.428  15.241  1.00  5.81           C  
ATOM     30  NE2 HIS A   3      27.008  24.302  16.518  1.00  5.91           N  
ATOM     31  H   HIS A   3      29.238  21.436  14.555  1.00  4.47           H  
ATOM     32  HA  HIS A   3      28.283  20.056  16.805  1.00  3.59           H  
ATOM     33  HB2 HIS A   3      26.726  20.705  14.296  1.00  3.53           H  
ATOM     34  HB3 HIS A   3      26.069  20.421  15.904  1.00  3.11           H  
ATOM     35  HD1 HIS A   3      27.527  23.040  13.752  1.00  4.91           H  
ATOM     36  HD2 HIS A   3      26.534  22.555  17.757  1.00  5.19           H  
ATOM     37  HE1 HIS A   3      27.538  25.355  14.731  1.00  6.57           H  
ATOM     38  HE2 HIS A   3      27.045  25.024  17.181  1.00  6.68           H  
ATOM     39  N   GLY A   4      28.024  17.666  16.239  1.00  2.45           N  
ATOM     40  CA  GLY A   4      27.906  16.256  15.913  1.00  2.34           C  
ATOM     41  C   GLY A   4      26.905  15.534  16.796  1.00  2.00           C  
ATOM     42  O   GLY A   4      25.923  14.977  16.302  1.00  2.37           O  
ATOM     43  H   GLY A   4      28.091  17.948  17.174  1.00  2.89           H  
ATOM     44  HA2 GLY A   4      27.594  16.160  14.885  1.00  2.71           H  
ATOM     45  HA3 GLY A   4      28.872  15.789  16.029  1.00  2.78           H  
ATOM     46  N   TYR A   5      27.154  15.541  18.104  1.00  1.70           N  
ATOM     47  CA  TYR A   5      26.268  14.882  19.061  1.00  1.43           C  
ATOM     48  C   TYR A   5      26.081  13.409  18.710  1.00  1.39           C  
ATOM     49  O   TYR A   5      24.960  12.898  18.704  1.00  1.60           O  
ATOM     50  CB  TYR A   5      24.910  15.586  19.104  1.00  1.42           C  
ATOM     51  CG  TYR A   5      24.982  17.011  19.605  1.00  1.57           C  
ATOM     52  CD1 TYR A   5      24.882  17.297  20.962  1.00  1.63           C  
ATOM     53  CD2 TYR A   5      25.150  18.070  18.723  1.00  1.84           C  
ATOM     54  CE1 TYR A   5      24.947  18.598  21.423  1.00  1.86           C  
ATOM     55  CE2 TYR A   5      25.215  19.373  19.177  1.00  2.07           C  
ATOM     56  CZ  TYR A   5      25.114  19.632  20.526  1.00  2.04           C  
ATOM     57  OH  TYR A   5      25.181  20.929  20.981  1.00  2.33           O  
ATOM     58  H   TYR A   5      27.952  16.002  18.435  1.00  1.98           H  
ATOM     59  HA  TYR A   5      26.727  14.950  20.036  1.00  1.49           H  
ATOM     60  HB2 TYR A   5      24.491  15.607  18.109  1.00  1.53           H  
ATOM     61  HB3 TYR A   5      24.248  15.036  19.757  1.00  1.41           H  
ATOM     62  HD1 TYR A   5      24.752  16.484  21.661  1.00  1.64           H  
ATOM     63  HD2 TYR A   5      25.227  17.864  17.665  1.00  1.97           H  
ATOM     64  HE1 TYR A   5      24.868  18.799  22.482  1.00  2.00           H  
ATOM     65  HE2 TYR A   5      25.347  20.184  18.473  1.00  2.36           H  
ATOM     66  HH  TYR A   5      24.645  21.494  20.419  1.00  2.46           H  
ATOM     67  N   SER A   6      27.187  12.730  18.419  1.00  1.46           N  
ATOM     68  CA  SER A   6      27.146  11.315  18.070  1.00  1.51           C  
ATOM     69  C   SER A   6      26.876  10.459  19.303  1.00  1.40           C  
ATOM     70  O   SER A   6      27.775  10.219  20.109  1.00  1.78           O  
ATOM     71  CB  SER A   6      28.462  10.890  17.417  1.00  1.86           C  
ATOM     72  OG  SER A   6      28.701  11.620  16.227  1.00  2.59           O  
ATOM     73  H   SER A   6      28.050  13.193  18.437  1.00  1.67           H  
ATOM     74  HA  SER A   6      26.341  11.170  17.364  1.00  1.53           H  
ATOM     75  HB2 SER A   6      29.276  11.069  18.103  1.00  1.99           H  
ATOM     76  HB3 SER A   6      28.420   9.837  17.176  1.00  2.19           H  
ATOM     77  HG  SER A   6      27.927  11.572  15.661  1.00  3.01           H  
ATOM     78  N   ASP A   7      25.633  10.005  19.445  1.00  1.22           N  
ATOM     79  CA  ASP A   7      25.241   9.177  20.581  1.00  1.25           C  
ATOM     80  C   ASP A   7      25.503   9.898  21.899  1.00  1.28           C  
ATOM     81  O   ASP A   7      26.561   9.733  22.510  1.00  1.58           O  
ATOM     82  CB  ASP A   7      25.993   7.844  20.555  1.00  1.48           C  
ATOM     83  CG  ASP A   7      25.749   7.067  19.275  1.00  1.96           C  
ATOM     84  OD1 ASP A   7      24.775   6.287  19.230  1.00  2.10           O  
ATOM     85  OD2 ASP A   7      26.536   7.237  18.320  1.00  2.67           O  
ATOM     86  H   ASP A   7      24.961  10.235  18.769  1.00  1.34           H  
ATOM     87  HA  ASP A   7      24.181   8.982  20.499  1.00  1.23           H  
ATOM     88  HB2 ASP A   7      27.051   8.034  20.642  1.00  1.82           H  
ATOM     89  HB3 ASP A   7      25.668   7.239  21.390  1.00  1.82           H  
ATOM     90  N   ALA A   8      24.536  10.700  22.330  1.00  1.14           N  
ATOM     91  CA  ALA A   8      24.662  11.448  23.575  1.00  1.29           C  
ATOM     92  C   ALA A   8      23.316  11.571  24.281  1.00  1.46           C  
ATOM     93  O   ALA A   8      22.474  12.382  23.895  1.00  1.58           O  
ATOM     94  CB  ALA A   8      25.246  12.826  23.303  1.00  1.28           C  
ATOM     95  H   ALA A   8      23.716  10.789  21.799  1.00  1.08           H  
ATOM     96  HA  ALA A   8      25.346  10.913  24.216  1.00  1.40           H  
ATOM     97  HB1 ALA A   8      26.187  12.723  22.783  1.00  1.74           H  
ATOM     98  HB2 ALA A   8      25.407  13.340  24.240  1.00  1.64           H  
ATOM     99  HB3 ALA A   8      24.559  13.396  22.694  1.00  1.53           H  
ATOM    100  N   SER A   9      23.123  10.758  25.316  1.00  1.63           N  
ATOM    101  CA  SER A   9      21.883  10.770  26.085  1.00  1.85           C  
ATOM    102  C   SER A   9      20.679  10.483  25.192  1.00  1.76           C  
ATOM    103  O   SER A   9      19.544  10.814  25.538  1.00  1.89           O  
ATOM    104  CB  SER A   9      21.707  12.118  26.789  1.00  2.01           C  
ATOM    105  OG  SER A   9      22.757  12.352  27.712  1.00  2.55           O  
ATOM    106  H   SER A   9      23.835  10.136  25.571  1.00  1.71           H  
ATOM    107  HA  SER A   9      21.952   9.994  26.831  1.00  2.04           H  
ATOM    108  HB2 SER A   9      21.709  12.908  26.052  1.00  2.14           H  
ATOM    109  HB3 SER A   9      20.767  12.124  27.320  1.00  2.22           H  
ATOM    110  HG  SER A   9      22.387  12.513  28.583  1.00  2.63           H  
ATOM    111  N   GLY A  10      20.934   9.866  24.042  1.00  1.58           N  
ATOM    112  CA  GLY A  10      19.861   9.541  23.120  1.00  1.55           C  
ATOM    113  C   GLY A  10      19.504  10.697  22.205  1.00  1.38           C  
ATOM    114  O   GLY A  10      18.330  10.942  21.935  1.00  1.82           O  
ATOM    115  H   GLY A  10      21.858   9.630  23.818  1.00  1.52           H  
ATOM    116  HA2 GLY A  10      20.165   8.700  22.515  1.00  1.55           H  
ATOM    117  HA3 GLY A  10      18.986   9.265  23.688  1.00  1.68           H  
ATOM    118  N   PHE A  11      20.521  11.411  21.732  1.00  1.08           N  
ATOM    119  CA  PHE A  11      20.311  12.547  20.839  1.00  0.90           C  
ATOM    120  C   PHE A  11      21.418  12.624  19.794  1.00  0.71           C  
ATOM    121  O   PHE A  11      22.594  12.769  20.130  1.00  0.83           O  
ATOM    122  CB  PHE A  11      20.262  13.854  21.637  1.00  1.02           C  
ATOM    123  CG  PHE A  11      19.082  13.962  22.561  1.00  1.18           C  
ATOM    124  CD1 PHE A  11      17.873  14.463  22.106  1.00  1.05           C  
ATOM    125  CD2 PHE A  11      19.183  13.568  23.887  1.00  1.52           C  
ATOM    126  CE1 PHE A  11      16.786  14.569  22.955  1.00  1.24           C  
ATOM    127  CE2 PHE A  11      18.101  13.673  24.740  1.00  1.70           C  
ATOM    128  CZ  PHE A  11      16.901  14.173  24.273  1.00  1.55           C  
ATOM    129  H   PHE A  11      21.434  11.169  21.990  1.00  1.29           H  
ATOM    130  HA  PHE A  11      19.367  12.406  20.334  1.00  0.86           H  
ATOM    131  HB2 PHE A  11      21.157  13.933  22.235  1.00  1.19           H  
ATOM    132  HB3 PHE A  11      20.222  14.685  20.947  1.00  0.90           H  
ATOM    133  HD1 PHE A  11      17.782  14.772  21.075  1.00  0.87           H  
ATOM    134  HD2 PHE A  11      20.122  13.177  24.252  1.00  1.68           H  
ATOM    135  HE1 PHE A  11      15.850  14.961  22.586  1.00  1.20           H  
ATOM    136  HE2 PHE A  11      18.193  13.362  25.770  1.00  1.98           H  
ATOM    137  HZ  PHE A  11      16.053  14.254  24.938  1.00  1.71           H  
ATOM    138  N   SER A  12      21.035  12.526  18.526  1.00  0.55           N  
ATOM    139  CA  SER A  12      21.998  12.583  17.431  1.00  0.45           C  
ATOM    140  C   SER A  12      21.415  13.322  16.232  1.00  0.39           C  
ATOM    141  O   SER A  12      20.220  13.223  15.947  1.00  0.38           O  
ATOM    142  CB  SER A  12      22.419  11.171  17.018  1.00  0.51           C  
ATOM    143  OG  SER A  12      23.340  11.209  15.941  1.00  0.90           O  
ATOM    144  H   SER A  12      20.085  12.413  18.321  1.00  0.62           H  
ATOM    145  HA  SER A  12      22.866  13.120  17.782  1.00  0.50           H  
ATOM    146  HB2 SER A  12      22.886  10.678  17.858  1.00  0.74           H  
ATOM    147  HB3 SER A  12      21.546  10.613  16.712  1.00  0.71           H  
ATOM    148  HG  SER A  12      24.235  11.191  16.284  1.00  1.26           H  
ATOM    149  N   LEU A  13      22.270  14.066  15.536  1.00  0.41           N  
ATOM    150  CA  LEU A  13      21.851  14.824  14.364  1.00  0.40           C  
ATOM    151  C   LEU A  13      21.763  13.920  13.140  1.00  0.45           C  
ATOM    152  O   LEU A  13      22.713  13.209  12.814  1.00  0.68           O  
ATOM    153  CB  LEU A  13      22.826  15.972  14.094  1.00  0.56           C  
ATOM    154  CG  LEU A  13      22.955  16.997  15.222  1.00  0.63           C  
ATOM    155  CD1 LEU A  13      24.068  17.988  14.916  1.00  0.89           C  
ATOM    156  CD2 LEU A  13      21.636  17.725  15.429  1.00  0.79           C  
ATOM    157  H   LEU A  13      23.207  14.105  15.818  1.00  0.47           H  
ATOM    158  HA  LEU A  13      20.872  15.234  14.566  1.00  0.37           H  
ATOM    159  HB2 LEU A  13      23.802  15.550  13.904  1.00  0.64           H  
ATOM    160  HB3 LEU A  13      22.498  16.492  13.206  1.00  0.66           H  
ATOM    161  HG  LEU A  13      23.206  16.485  16.141  1.00  0.72           H  
ATOM    162 HD11 LEU A  13      24.145  18.703  15.721  1.00  1.34           H  
ATOM    163 HD12 LEU A  13      23.848  18.504  13.993  1.00  1.49           H  
ATOM    164 HD13 LEU A  13      25.005  17.457  14.816  1.00  1.39           H  
ATOM    165 HD21 LEU A  13      21.280  18.097  14.480  1.00  1.31           H  
ATOM    166 HD22 LEU A  13      21.783  18.550  16.109  1.00  1.32           H  
ATOM    167 HD23 LEU A  13      20.910  17.041  15.844  1.00  1.36           H  
ATOM    168  N   TYR A  14      20.621  13.956  12.467  1.00  0.36           N  
ATOM    169  CA  TYR A  14      20.408  13.141  11.278  1.00  0.50           C  
ATOM    170  C   TYR A  14      20.005  14.009  10.089  1.00  0.31           C  
ATOM    171  O   TYR A  14      19.202  14.932  10.227  1.00  0.37           O  
ATOM    172  CB  TYR A  14      19.339  12.080  11.549  1.00  0.80           C  
ATOM    173  CG  TYR A  14      19.821  10.952  12.438  1.00  0.68           C  
ATOM    174  CD1 TYR A  14      20.453   9.841  11.894  1.00  1.20           C  
ATOM    175  CD2 TYR A  14      19.645  10.995  13.818  1.00  0.71           C  
ATOM    176  CE1 TYR A  14      20.898   8.808  12.694  1.00  1.90           C  
ATOM    177  CE2 TYR A  14      20.089   9.963  14.626  1.00  1.34           C  
ATOM    178  CZ  TYR A  14      20.713   8.874  14.058  1.00  1.98           C  
ATOM    179  OH  TYR A  14      21.156   7.845  14.858  1.00  2.73           O  
ATOM    180  H   TYR A  14      19.901  14.545  12.777  1.00  0.34           H  
ATOM    181  HA  TYR A  14      21.340  12.648  11.045  1.00  0.70           H  
ATOM    182  HB2 TYR A  14      18.493  12.545  12.033  1.00  1.47           H  
ATOM    183  HB3 TYR A  14      19.021  11.652  10.610  1.00  1.23           H  
ATOM    184  HD1 TYR A  14      20.597   9.792  10.824  1.00  1.18           H  
ATOM    185  HD2 TYR A  14      19.155  11.851  14.263  1.00  0.54           H  
ATOM    186  HE1 TYR A  14      21.386   7.953  12.251  1.00  2.41           H  
ATOM    187  HE2 TYR A  14      19.944  10.015  15.695  1.00  1.42           H  
ATOM    188  HH  TYR A  14      22.031   7.572  14.575  1.00  3.09           H  
ATOM    189  N   SER A  15      20.570  13.710   8.923  1.00  0.43           N  
ATOM    190  CA  SER A  15      20.275  14.471   7.716  1.00  0.38           C  
ATOM    191  C   SER A  15      19.973  13.543   6.542  1.00  0.33           C  
ATOM    192  O   SER A  15      20.706  12.589   6.288  1.00  0.41           O  
ATOM    193  CB  SER A  15      21.449  15.386   7.367  1.00  0.59           C  
ATOM    194  OG  SER A  15      22.629  14.636   7.133  1.00  1.19           O  
ATOM    195  H   SER A  15      21.201  12.962   8.875  1.00  0.67           H  
ATOM    196  HA  SER A  15      19.404  15.079   7.912  1.00  0.39           H  
ATOM    197  HB2 SER A  15      21.214  15.948   6.475  1.00  1.21           H  
ATOM    198  HB3 SER A  15      21.626  16.068   8.186  1.00  1.22           H  
ATOM    199  HG  SER A  15      22.422  13.699   7.157  1.00  1.79           H  
ATOM    200  N   VAL A  16      18.886  13.832   5.833  1.00  0.32           N  
ATOM    201  CA  VAL A  16      18.483  13.029   4.684  1.00  0.33           C  
ATOM    202  C   VAL A  16      18.487  13.869   3.410  1.00  0.31           C  
ATOM    203  O   VAL A  16      18.392  15.095   3.467  1.00  0.44           O  
ATOM    204  CB  VAL A  16      17.081  12.419   4.887  1.00  0.44           C  
ATOM    205  CG1 VAL A  16      16.820  11.325   3.864  1.00  0.53           C  
ATOM    206  CG2 VAL A  16      16.931  11.884   6.302  1.00  0.56           C  
ATOM    207  H   VAL A  16      18.341  14.606   6.087  1.00  0.37           H  
ATOM    208  HA  VAL A  16      19.193  12.221   4.575  1.00  0.37           H  
ATOM    209  HB  VAL A  16      16.348  13.199   4.740  1.00  0.47           H  
ATOM    210 HG11 VAL A  16      17.583  10.566   3.947  1.00  1.07           H  
ATOM    211 HG12 VAL A  16      16.839  11.746   2.870  1.00  1.26           H  
ATOM    212 HG13 VAL A  16      15.851  10.882   4.049  1.00  1.13           H  
ATOM    213 HG21 VAL A  16      17.674  11.122   6.481  1.00  1.21           H  
ATOM    214 HG22 VAL A  16      15.944  11.460   6.423  1.00  1.05           H  
ATOM    215 HG23 VAL A  16      17.064  12.691   7.009  1.00  1.26           H  
ATOM    216  N   GLU A  17      18.597  13.205   2.262  1.00  0.33           N  
ATOM    217  CA  GLU A  17      18.621  13.900   0.979  1.00  0.34           C  
ATOM    218  C   GLU A  17      17.337  13.651   0.189  1.00  0.32           C  
ATOM    219  O   GLU A  17      17.096  12.543  -0.291  1.00  0.38           O  
ATOM    220  CB  GLU A  17      19.831  13.449   0.159  1.00  0.45           C  
ATOM    221  CG  GLU A  17      21.155  13.617   0.883  1.00  0.71           C  
ATOM    222  CD  GLU A  17      22.339  13.167   0.050  1.00  1.18           C  
ATOM    223  OE1 GLU A  17      22.642  11.956   0.057  1.00  1.42           O  
ATOM    224  OE2 GLU A  17      22.962  14.025  -0.608  1.00  1.74           O  
ATOM    225  H   GLU A  17      18.665  12.228   2.279  1.00  0.45           H  
ATOM    226  HA  GLU A  17      18.707  14.957   1.176  1.00  0.33           H  
ATOM    227  HB2 GLU A  17      19.712  12.405  -0.093  1.00  0.57           H  
ATOM    228  HB3 GLU A  17      19.868  14.028  -0.754  1.00  0.64           H  
ATOM    229  HG2 GLU A  17      21.286  14.661   1.132  1.00  1.14           H  
ATOM    230  HG3 GLU A  17      21.130  13.033   1.792  1.00  1.15           H  
ATOM    231  N   LEU A  18      16.517  14.690   0.062  1.00  0.31           N  
ATOM    232  CA  LEU A  18      15.260  14.594  -0.675  1.00  0.34           C  
ATOM    233  C   LEU A  18      15.266  15.555  -1.859  1.00  0.38           C  
ATOM    234  O   LEU A  18      16.122  16.435  -1.947  1.00  0.68           O  
ATOM    235  CB  LEU A  18      14.070  14.898   0.242  1.00  0.40           C  
ATOM    236  CG  LEU A  18      13.540  13.710   1.053  1.00  0.46           C  
ATOM    237  CD1 LEU A  18      13.029  12.616   0.128  1.00  0.81           C  
ATOM    238  CD2 LEU A  18      14.615  13.163   1.979  1.00  0.71           C  
ATOM    239  H   LEU A  18      16.763  15.547   0.471  1.00  0.31           H  
ATOM    240  HA  LEU A  18      15.171  13.584  -1.048  1.00  0.37           H  
ATOM    241  HB2 LEU A  18      14.366  15.673   0.932  1.00  0.45           H  
ATOM    242  HB3 LEU A  18      13.262  15.274  -0.369  1.00  0.55           H  
ATOM    243  HG  LEU A  18      12.711  14.042   1.662  1.00  0.82           H  
ATOM    244 HD11 LEU A  18      12.241  13.011  -0.496  1.00  1.41           H  
ATOM    245 HD12 LEU A  18      12.645  11.797   0.718  1.00  1.25           H  
ATOM    246 HD13 LEU A  18      13.838  12.263  -0.494  1.00  1.27           H  
ATOM    247 HD21 LEU A  18      15.015  13.966   2.580  1.00  1.21           H  
ATOM    248 HD22 LEU A  18      15.408  12.724   1.391  1.00  1.25           H  
ATOM    249 HD23 LEU A  18      14.186  12.408   2.624  1.00  1.29           H  
ATOM    250  N   PHE A  19      14.317  15.383  -2.772  1.00  0.41           N  
ATOM    251  CA  PHE A  19      14.237  16.244  -3.946  1.00  0.43           C  
ATOM    252  C   PHE A  19      12.790  16.514  -4.348  1.00  0.49           C  
ATOM    253  O   PHE A  19      11.974  15.595  -4.429  1.00  0.59           O  
ATOM    254  CB  PHE A  19      14.996  15.612  -5.117  1.00  0.48           C  
ATOM    255  CG  PHE A  19      14.520  14.231  -5.470  1.00  0.82           C  
ATOM    256  CD1 PHE A  19      14.963  13.129  -4.757  1.00  0.74           C  
ATOM    257  CD2 PHE A  19      13.630  14.035  -6.513  1.00  1.50           C  
ATOM    258  CE1 PHE A  19      14.528  11.858  -5.078  1.00  1.25           C  
ATOM    259  CE2 PHE A  19      13.190  12.767  -6.840  1.00  2.08           C  
ATOM    260  CZ  PHE A  19      13.641  11.675  -6.121  1.00  1.94           C  
ATOM    261  H   PHE A  19      13.659  14.667  -2.654  1.00  0.64           H  
ATOM    262  HA  PHE A  19      14.705  17.183  -3.695  1.00  0.44           H  
ATOM    263  HB2 PHE A  19      14.880  16.236  -5.991  1.00  0.74           H  
ATOM    264  HB3 PHE A  19      16.043  15.549  -4.863  1.00  0.75           H  
ATOM    265  HD1 PHE A  19      15.656  13.270  -3.942  1.00  0.58           H  
ATOM    266  HD2 PHE A  19      13.279  14.887  -7.077  1.00  1.62           H  
ATOM    267  HE1 PHE A  19      14.881  11.007  -4.514  1.00  1.19           H  
ATOM    268  HE2 PHE A  19      12.496  12.627  -7.656  1.00  2.66           H  
ATOM    269  HZ  PHE A  19      13.298  10.683  -6.373  1.00  2.41           H  
ATOM    270  N   ARG A  20      12.479  17.784  -4.592  1.00  0.52           N  
ATOM    271  CA  ARG A  20      11.134  18.178  -5.000  1.00  0.66           C  
ATOM    272  C   ARG A  20      11.064  18.319  -6.518  1.00  0.68           C  
ATOM    273  O   ARG A  20      11.391  19.370  -7.068  1.00  0.83           O  
ATOM    274  CB  ARG A  20      10.737  19.497  -4.330  1.00  0.73           C  
ATOM    275  CG  ARG A  20       9.416  20.067  -4.828  1.00  0.99           C  
ATOM    276  CD  ARG A  20       8.227  19.292  -4.288  1.00  1.19           C  
ATOM    277  NE  ARG A  20       8.044  19.507  -2.858  1.00  1.60           N  
ATOM    278  CZ  ARG A  20       7.113  20.306  -2.344  1.00  2.26           C  
ATOM    279  NH1 ARG A  20       6.282  20.961  -3.144  1.00  2.52           N  
ATOM    280  NH2 ARG A  20       7.013  20.451  -1.029  1.00  3.06           N  
ATOM    281  H   ARG A  20      13.172  18.476  -4.492  1.00  0.51           H  
ATOM    282  HA  ARG A  20      10.451  17.401  -4.688  1.00  0.75           H  
ATOM    283  HB2 ARG A  20      10.654  19.332  -3.265  1.00  0.76           H  
ATOM    284  HB3 ARG A  20      11.512  20.226  -4.512  1.00  0.74           H  
ATOM    285  HG2 ARG A  20       9.338  21.094  -4.506  1.00  1.35           H  
ATOM    286  HG3 ARG A  20       9.402  20.026  -5.908  1.00  1.58           H  
ATOM    287  HD2 ARG A  20       7.337  19.614  -4.809  1.00  1.58           H  
ATOM    288  HD3 ARG A  20       8.387  18.238  -4.467  1.00  1.85           H  
ATOM    289  HE  ARG A  20       8.647  19.035  -2.248  1.00  1.84           H  
ATOM    290 HH11 ARG A  20       6.354  20.855  -4.136  1.00  2.39           H  
ATOM    291 HH12 ARG A  20       5.582  21.560  -2.755  1.00  3.11           H  
ATOM    292 HH21 ARG A  20       7.638  19.959  -0.424  1.00  3.29           H  
ATOM    293 HH22 ARG A  20       6.314  21.053  -0.645  1.00  3.59           H  
ATOM    294  N   GLU A  21      10.635  17.256  -7.191  1.00  0.82           N  
ATOM    295  CA  GLU A  21      10.535  17.264  -8.647  1.00  0.93           C  
ATOM    296  C   GLU A  21       9.170  16.768  -9.108  1.00  1.16           C  
ATOM    297  O   GLU A  21       8.953  16.534 -10.297  1.00  1.57           O  
ATOM    298  CB  GLU A  21      11.634  16.392  -9.256  1.00  1.09           C  
ATOM    299  CG  GLU A  21      13.043  16.863  -8.928  1.00  1.62           C  
ATOM    300  CD  GLU A  21      13.359  18.221  -9.524  1.00  2.00           C  
ATOM    301  OE1 GLU A  21      13.549  18.299 -10.755  1.00  2.21           O  
ATOM    302  OE2 GLU A  21      13.422  19.206  -8.758  1.00  2.58           O  
ATOM    303  H   GLU A  21      10.374  16.449  -6.698  1.00  1.01           H  
ATOM    304  HA  GLU A  21      10.669  18.281  -8.982  1.00  0.96           H  
ATOM    305  HB2 GLU A  21      11.522  15.383  -8.889  1.00  1.67           H  
ATOM    306  HB3 GLU A  21      11.521  16.389 -10.330  1.00  1.53           H  
ATOM    307  HG2 GLU A  21      13.147  16.925  -7.854  1.00  2.14           H  
ATOM    308  HG3 GLU A  21      13.749  16.142  -9.315  1.00  2.16           H  
ATOM    309  N   LYS A  22       8.251  16.614  -8.162  1.00  1.11           N  
ATOM    310  CA  LYS A  22       6.907  16.143  -8.474  1.00  1.40           C  
ATOM    311  C   LYS A  22       5.886  17.261  -8.295  1.00  1.31           C  
ATOM    312  O   LYS A  22       6.075  18.166  -7.482  1.00  1.38           O  
ATOM    313  CB  LYS A  22       6.544  14.950  -7.584  1.00  1.65           C  
ATOM    314  CG  LYS A  22       7.548  13.809  -7.647  1.00  2.00           C  
ATOM    315  CD  LYS A  22       7.658  13.232  -9.051  1.00  2.54           C  
ATOM    316  CE  LYS A  22       8.699  12.126  -9.118  1.00  3.05           C  
ATOM    317  NZ  LYS A  22       8.851  11.589 -10.497  1.00  3.72           N  
ATOM    318  H   LYS A  22       8.482  16.820  -7.233  1.00  1.04           H  
ATOM    319  HA  LYS A  22       6.899  15.826  -9.506  1.00  1.68           H  
ATOM    320  HB2 LYS A  22       6.480  15.288  -6.560  1.00  1.50           H  
ATOM    321  HB3 LYS A  22       5.579  14.571  -7.889  1.00  1.86           H  
ATOM    322  HG2 LYS A  22       8.516  14.178  -7.346  1.00  1.96           H  
ATOM    323  HG3 LYS A  22       7.233  13.028  -6.971  1.00  2.32           H  
ATOM    324  HD2 LYS A  22       6.700  12.828  -9.341  1.00  2.88           H  
ATOM    325  HD3 LYS A  22       7.940  14.021  -9.733  1.00  2.71           H  
ATOM    326  HE2 LYS A  22       9.649  12.522  -8.789  1.00  3.25           H  
ATOM    327  HE3 LYS A  22       8.397  11.325  -8.460  1.00  3.31           H  
ATOM    328  HZ1 LYS A  22       7.943  11.208 -10.835  1.00  4.04           H  
ATOM    329  HZ2 LYS A  22       9.559  10.828 -10.509  1.00  3.92           H  
ATOM    330  HZ3 LYS A  22       9.158  12.344 -11.143  1.00  4.19           H  
ATOM    331  N   ASP A  23       4.802  17.190  -9.063  1.00  1.46           N  
ATOM    332  CA  ASP A  23       3.746  18.194  -8.995  1.00  1.51           C  
ATOM    333  C   ASP A  23       2.816  17.929  -7.815  1.00  1.31           C  
ATOM    334  O   ASP A  23       1.704  18.456  -7.757  1.00  1.58           O  
ATOM    335  CB  ASP A  23       2.945  18.207 -10.298  1.00  1.91           C  
ATOM    336  CG  ASP A  23       2.315  16.863 -10.602  1.00  2.29           C  
ATOM    337  OD1 ASP A  23       2.998  16.012 -11.210  1.00  2.58           O  
ATOM    338  OD2 ASP A  23       1.138  16.661 -10.235  1.00  2.87           O  
ATOM    339  H   ASP A  23       4.711  16.444  -9.691  1.00  1.69           H  
ATOM    340  HA  ASP A  23       4.213  19.158  -8.860  1.00  1.52           H  
ATOM    341  HB2 ASP A  23       2.159  18.943 -10.222  1.00  2.43           H  
ATOM    342  HB3 ASP A  23       3.602  18.470 -11.114  1.00  2.15           H  
ATOM    343  N   THR A  24       3.279  17.111  -6.876  1.00  1.02           N  
ATOM    344  CA  THR A  24       2.492  16.775  -5.697  1.00  0.98           C  
ATOM    345  C   THR A  24       2.338  17.980  -4.776  1.00  1.01           C  
ATOM    346  O   THR A  24       1.545  17.957  -3.834  1.00  1.16           O  
ATOM    347  CB  THR A  24       3.132  15.620  -4.907  1.00  1.17           C  
ATOM    348  OG1 THR A  24       4.400  16.028  -4.382  1.00  1.38           O  
ATOM    349  CG2 THR A  24       3.322  14.397  -5.792  1.00  1.19           C  
ATOM    350  H   THR A  24       4.173  16.724  -6.978  1.00  1.03           H  
ATOM    351  HA  THR A  24       1.514  16.459  -6.028  1.00  1.06           H  
ATOM    352  HB  THR A  24       2.479  15.355  -4.087  1.00  1.38           H  
ATOM    353  HG1 THR A  24       5.099  15.523  -4.801  1.00  1.74           H  
ATOM    354 HG21 THR A  24       2.362  14.072  -6.167  1.00  1.64           H  
ATOM    355 HG22 THR A  24       3.772  13.602  -5.216  1.00  1.69           H  
ATOM    356 HG23 THR A  24       3.965  14.649  -6.621  1.00  1.32           H  
ATOM    357  N   SER A  25       3.105  19.031  -5.058  1.00  1.05           N  
ATOM    358  CA  SER A  25       3.061  20.256  -4.264  1.00  1.35           C  
ATOM    359  C   SER A  25       3.410  19.981  -2.805  1.00  1.17           C  
ATOM    360  O   SER A  25       3.086  20.774  -1.921  1.00  1.39           O  
ATOM    361  CB  SER A  25       1.676  20.900  -4.353  1.00  1.79           C  
ATOM    362  OG  SER A  25       1.343  21.215  -5.695  1.00  2.45           O  
ATOM    363  H   SER A  25       3.715  18.983  -5.823  1.00  0.97           H  
ATOM    364  HA  SER A  25       3.790  20.940  -4.672  1.00  1.53           H  
ATOM    365  HB2 SER A  25       0.936  20.216  -3.964  1.00  1.95           H  
ATOM    366  HB3 SER A  25       1.665  21.809  -3.770  1.00  2.24           H  
ATOM    367  HG  SER A  25       1.371  22.167  -5.816  1.00  2.79           H  
ATOM    368  N   SER A  26       4.077  18.855  -2.561  1.00  0.84           N  
ATOM    369  CA  SER A  26       4.468  18.478  -1.205  1.00  0.72           C  
ATOM    370  C   SER A  26       5.529  17.383  -1.225  1.00  0.58           C  
ATOM    371  O   SER A  26       5.675  16.661  -2.211  1.00  0.69           O  
ATOM    372  CB  SER A  26       3.245  17.998  -0.421  1.00  0.81           C  
ATOM    373  OG  SER A  26       2.685  16.837  -1.013  1.00  1.40           O  
ATOM    374  H   SER A  26       4.311  18.265  -3.307  1.00  0.78           H  
ATOM    375  HA  SER A  26       4.875  19.352  -0.720  1.00  0.78           H  
ATOM    376  HB2 SER A  26       3.538  17.764   0.591  1.00  1.33           H  
ATOM    377  HB3 SER A  26       2.499  18.778  -0.409  1.00  1.29           H  
ATOM    378  HG  SER A  26       1.786  16.719  -0.697  1.00  1.79           H  
ATOM    379  N   LEU A  27       6.269  17.267  -0.127  1.00  0.42           N  
ATOM    380  CA  LEU A  27       7.318  16.259  -0.010  1.00  0.32           C  
ATOM    381  C   LEU A  27       6.845  15.090   0.847  1.00  0.29           C  
ATOM    382  O   LEU A  27       7.487  14.043   0.891  1.00  0.41           O  
ATOM    383  CB  LEU A  27       8.584  16.869   0.596  1.00  0.35           C  
ATOM    384  CG  LEU A  27       9.319  17.870  -0.296  1.00  0.38           C  
ATOM    385  CD1 LEU A  27      10.404  18.589   0.492  1.00  0.45           C  
ATOM    386  CD2 LEU A  27       9.919  17.165  -1.505  1.00  0.43           C  
ATOM    387  H   LEU A  27       6.104  17.872   0.626  1.00  0.47           H  
ATOM    388  HA  LEU A  27       7.541  15.897  -1.003  1.00  0.37           H  
ATOM    389  HB2 LEU A  27       8.313  17.369   1.515  1.00  0.42           H  
ATOM    390  HB3 LEU A  27       9.266  16.067   0.832  1.00  0.39           H  
ATOM    391  HG  LEU A  27       8.619  18.610  -0.652  1.00  0.43           H  
ATOM    392 HD11 LEU A  27       9.957  19.114   1.323  1.00  1.13           H  
ATOM    393 HD12 LEU A  27      10.906  19.296  -0.152  1.00  1.10           H  
ATOM    394 HD13 LEU A  27      11.117  17.868   0.861  1.00  1.13           H  
ATOM    395 HD21 LEU A  27       9.128  16.727  -2.095  1.00  1.08           H  
ATOM    396 HD22 LEU A  27      10.592  16.389  -1.171  1.00  1.10           H  
ATOM    397 HD23 LEU A  27      10.463  17.879  -2.105  1.00  1.09           H  
ATOM    398  N   GLY A  28       5.720  15.283   1.527  1.00  0.29           N  
ATOM    399  CA  GLY A  28       5.177  14.240   2.377  1.00  0.31           C  
ATOM    400  C   GLY A  28       5.500  14.462   3.840  1.00  0.29           C  
ATOM    401  O   GLY A  28       5.535  13.518   4.629  1.00  0.52           O  
ATOM    402  H   GLY A  28       5.253  16.141   1.452  1.00  0.38           H  
ATOM    403  HA2 GLY A  28       4.106  14.215   2.258  1.00  0.35           H  
ATOM    404  HA3 GLY A  28       5.586  13.289   2.071  1.00  0.38           H  
ATOM    405  N   ILE A  29       5.734  15.719   4.202  1.00  0.35           N  
ATOM    406  CA  ILE A  29       6.061  16.075   5.575  1.00  0.32           C  
ATOM    407  C   ILE A  29       4.852  16.678   6.284  1.00  0.30           C  
ATOM    408  O   ILE A  29       4.365  17.743   5.906  1.00  0.35           O  
ATOM    409  CB  ILE A  29       7.232  17.075   5.625  1.00  0.37           C  
ATOM    410  CG1 ILE A  29       8.457  16.489   4.916  1.00  0.46           C  
ATOM    411  CG2 ILE A  29       7.566  17.430   7.068  1.00  0.36           C  
ATOM    412  CD1 ILE A  29       9.600  17.470   4.761  1.00  0.84           C  
ATOM    413  H   ILE A  29       5.686  16.426   3.525  1.00  0.58           H  
ATOM    414  HA  ILE A  29       6.358  15.174   6.092  1.00  0.31           H  
ATOM    415  HB  ILE A  29       6.930  17.978   5.118  1.00  0.39           H  
ATOM    416 HG12 ILE A  29       8.820  15.644   5.480  1.00  0.87           H  
ATOM    417 HG13 ILE A  29       8.167  16.158   3.929  1.00  0.92           H  
ATOM    418 HG21 ILE A  29       6.702  17.876   7.538  1.00  1.10           H  
ATOM    419 HG22 ILE A  29       8.387  18.131   7.085  1.00  1.06           H  
ATOM    420 HG23 ILE A  29       7.846  16.535   7.602  1.00  1.06           H  
ATOM    421 HD11 ILE A  29       9.267  18.325   4.191  1.00  1.33           H  
ATOM    422 HD12 ILE A  29      10.419  16.991   4.246  1.00  1.43           H  
ATOM    423 HD13 ILE A  29       9.929  17.795   5.737  1.00  1.53           H  
ATOM    424  N   SER A  30       4.371  15.987   7.314  1.00  0.27           N  
ATOM    425  CA  SER A  30       3.221  16.453   8.078  1.00  0.29           C  
ATOM    426  C   SER A  30       3.643  16.879   9.479  1.00  0.28           C  
ATOM    427  O   SER A  30       3.872  16.039  10.351  1.00  0.35           O  
ATOM    428  CB  SER A  30       2.158  15.358   8.164  1.00  0.33           C  
ATOM    429  OG  SER A  30       1.034  15.796   8.907  1.00  0.95           O  
ATOM    430  H   SER A  30       4.802  15.142   7.564  1.00  0.25           H  
ATOM    431  HA  SER A  30       2.805  17.307   7.564  1.00  0.33           H  
ATOM    432  HB2 SER A  30       1.835  15.093   7.169  1.00  0.78           H  
ATOM    433  HB3 SER A  30       2.579  14.489   8.649  1.00  0.82           H  
ATOM    434  HG  SER A  30       0.399  15.079   8.984  1.00  1.41           H  
ATOM    435  N   ILE A  31       3.746  18.187   9.690  1.00  0.25           N  
ATOM    436  CA  ILE A  31       4.146  18.725  10.985  1.00  0.27           C  
ATOM    437  C   ILE A  31       2.940  19.188  11.793  1.00  0.31           C  
ATOM    438  O   ILE A  31       1.864  19.425  11.244  1.00  0.41           O  
ATOM    439  CB  ILE A  31       5.125  19.901  10.825  1.00  0.29           C  
ATOM    440  CG1 ILE A  31       4.544  20.950   9.872  1.00  0.31           C  
ATOM    441  CG2 ILE A  31       6.474  19.402  10.326  1.00  0.35           C  
ATOM    442  CD1 ILE A  31       5.391  22.198   9.746  1.00  0.39           C  
ATOM    443  H   ILE A  31       3.547  18.806   8.957  1.00  0.28           H  
ATOM    444  HA  ILE A  31       4.650  17.937  11.529  1.00  0.31           H  
ATOM    445  HB  ILE A  31       5.273  20.352  11.796  1.00  0.32           H  
ATOM    446 HG12 ILE A  31       4.447  20.517   8.887  1.00  0.32           H  
ATOM    447 HG13 ILE A  31       3.567  21.245  10.226  1.00  0.33           H  
ATOM    448 HG21 ILE A  31       6.348  18.931   9.363  1.00  1.09           H  
ATOM    449 HG22 ILE A  31       6.874  18.684  11.027  1.00  1.07           H  
ATOM    450 HG23 ILE A  31       7.155  20.235  10.233  1.00  1.07           H  
ATOM    451 HD11 ILE A  31       6.366  21.935   9.365  1.00  1.18           H  
ATOM    452 HD12 ILE A  31       5.498  22.660  10.717  1.00  0.97           H  
ATOM    453 HD13 ILE A  31       4.914  22.890   9.068  1.00  1.10           H  
ATOM    454  N   SER A  32       3.131  19.314  13.102  1.00  0.37           N  
ATOM    455  CA  SER A  32       2.066  19.751  13.996  1.00  0.44           C  
ATOM    456  C   SER A  32       2.643  20.480  15.206  1.00  0.55           C  
ATOM    457  O   SER A  32       3.725  20.143  15.686  1.00  0.59           O  
ATOM    458  CB  SER A  32       1.235  18.552  14.457  1.00  0.48           C  
ATOM    459  OG  SER A  32       0.198  18.956  15.333  1.00  1.32           O  
ATOM    460  H   SER A  32       4.013  19.108  13.477  1.00  0.43           H  
ATOM    461  HA  SER A  32       1.430  20.431  13.449  1.00  0.49           H  
ATOM    462  HB2 SER A  32       0.797  18.069  13.597  1.00  1.10           H  
ATOM    463  HB3 SER A  32       1.876  17.852  14.974  1.00  1.10           H  
ATOM    464  HG  SER A  32      -0.632  18.566  15.047  1.00  1.79           H  
ATOM    465  N   GLY A  33       1.916  21.483  15.691  1.00  0.70           N  
ATOM    466  CA  GLY A  33       2.375  22.245  16.837  1.00  0.87           C  
ATOM    467  C   GLY A  33       1.982  21.608  18.155  1.00  0.88           C  
ATOM    468  O   GLY A  33       0.944  20.952  18.251  1.00  0.95           O  
ATOM    469  H   GLY A  33       1.059  21.704  15.267  1.00  0.73           H  
ATOM    470  HA2 GLY A  33       3.451  22.322  16.796  1.00  1.04           H  
ATOM    471  HA3 GLY A  33       1.951  23.236  16.790  1.00  0.94           H  
ATOM    472  N   MET A  34       2.813  21.803  19.175  1.00  1.12           N  
ATOM    473  CA  MET A  34       2.548  21.245  20.497  1.00  1.25           C  
ATOM    474  C   MET A  34       1.798  22.245  21.369  1.00  1.38           C  
ATOM    475  O   MET A  34       1.933  23.456  21.197  1.00  1.63           O  
ATOM    476  CB  MET A  34       3.859  20.839  21.174  1.00  1.56           C  
ATOM    477  CG  MET A  34       3.668  20.202  22.541  1.00  1.77           C  
ATOM    478  SD  MET A  34       5.225  19.713  23.305  1.00  2.04           S  
ATOM    479  CE  MET A  34       5.764  18.428  22.180  1.00  1.98           C  
ATOM    480  H   MET A  34       3.623  22.337  19.036  1.00  1.34           H  
ATOM    481  HA  MET A  34       1.935  20.366  20.367  1.00  1.26           H  
ATOM    482  HB2 MET A  34       4.375  20.132  20.541  1.00  1.66           H  
ATOM    483  HB3 MET A  34       4.475  21.718  21.293  1.00  1.81           H  
ATOM    484  HG2 MET A  34       3.175  20.913  23.188  1.00  2.04           H  
ATOM    485  HG3 MET A  34       3.045  19.326  22.431  1.00  2.06           H  
ATOM    486  HE1 MET A  34       5.024  17.641  22.153  1.00  2.48           H  
ATOM    487  HE2 MET A  34       6.706  18.025  22.518  1.00  2.33           H  
ATOM    488  HE3 MET A  34       5.883  18.843  21.189  1.00  2.20           H  
ATOM    489  N   ARG A  35       1.005  21.731  22.304  1.00  1.52           N  
ATOM    490  CA  ARG A  35       0.232  22.581  23.203  1.00  1.79           C  
ATOM    491  C   ARG A  35       0.836  22.584  24.604  1.00  2.00           C  
ATOM    492  O   ARG A  35       0.548  21.704  25.416  1.00  2.40           O  
ATOM    493  CB  ARG A  35      -1.223  22.107  23.270  1.00  2.21           C  
ATOM    494  CG  ARG A  35      -1.971  22.213  21.949  1.00  2.56           C  
ATOM    495  CD  ARG A  35      -1.609  21.078  21.002  1.00  2.88           C  
ATOM    496  NE  ARG A  35      -2.408  21.108  19.780  1.00  3.69           N  
ATOM    497  CZ  ARG A  35      -2.339  20.181  18.828  1.00  4.52           C  
ATOM    498  NH1 ARG A  35      -1.508  19.155  18.956  1.00  4.68           N  
ATOM    499  NH2 ARG A  35      -3.099  20.282  17.746  1.00  5.46           N  
ATOM    500  H   ARG A  35       0.939  20.757  22.392  1.00  1.63           H  
ATOM    501  HA  ARG A  35       0.256  23.586  22.810  1.00  1.90           H  
ATOM    502  HB2 ARG A  35      -1.236  21.074  23.582  1.00  2.53           H  
ATOM    503  HB3 ARG A  35      -1.747  22.701  24.004  1.00  2.61           H  
ATOM    504  HG2 ARG A  35      -3.032  22.178  22.146  1.00  2.85           H  
ATOM    505  HG3 ARG A  35      -1.721  23.155  21.481  1.00  3.02           H  
ATOM    506  HD2 ARG A  35      -0.565  21.164  20.740  1.00  2.95           H  
ATOM    507  HD3 ARG A  35      -1.776  20.138  21.509  1.00  3.10           H  
ATOM    508  HE  ARG A  35      -3.030  21.857  19.663  1.00  3.87           H  
ATOM    509 HH11 ARG A  35      -0.932  19.076  19.771  1.00  4.25           H  
ATOM    510 HH12 ARG A  35      -1.459  18.459  18.240  1.00  5.42           H  
ATOM    511 HH21 ARG A  35      -3.726  21.054  17.646  1.00  5.62           H  
ATOM    512 HH22 ARG A  35      -3.045  19.586  17.030  1.00  6.15           H  
ATOM    513  N   ASP A  36       1.676  23.577  24.879  1.00  2.20           N  
ATOM    514  CA  ASP A  36       2.318  23.693  26.184  1.00  2.60           C  
ATOM    515  C   ASP A  36       1.603  24.730  27.045  1.00  2.84           C  
ATOM    516  O   ASP A  36       1.323  25.839  26.592  1.00  3.13           O  
ATOM    517  CB  ASP A  36       3.791  24.073  26.021  1.00  3.10           C  
ATOM    518  CG  ASP A  36       4.565  23.048  25.215  1.00  3.69           C  
ATOM    519  OD1 ASP A  36       4.597  23.173  23.973  1.00  4.29           O  
ATOM    520  OD2 ASP A  36       5.135  22.121  25.824  1.00  4.03           O  
ATOM    521  H   ASP A  36       1.869  24.246  24.190  1.00  2.37           H  
ATOM    522  HA  ASP A  36       2.254  22.732  26.671  1.00  2.76           H  
ATOM    523  HB2 ASP A  36       3.857  25.025  25.518  1.00  3.27           H  
ATOM    524  HB3 ASP A  36       4.245  24.153  26.997  1.00  3.47           H  
ATOM    525  N   GLN A  37       1.312  24.361  28.290  1.00  3.14           N  
ATOM    526  CA  GLN A  37       0.626  25.260  29.211  1.00  3.57           C  
ATOM    527  C   GLN A  37       1.463  25.512  30.459  1.00  3.76           C  
ATOM    528  O   GLN A  37       0.979  26.076  31.442  1.00  4.28           O  
ATOM    529  CB  GLN A  37      -0.733  24.677  29.607  1.00  4.06           C  
ATOM    530  CG  GLN A  37      -1.618  24.331  28.421  1.00  4.18           C  
ATOM    531  CD  GLN A  37      -2.966  23.781  28.843  1.00  4.68           C  
ATOM    532  OE1 GLN A  37      -3.133  22.573  29.008  1.00  4.94           O  
ATOM    533  NE2 GLN A  37      -3.939  24.668  29.018  1.00  5.25           N  
ATOM    534  H   GLN A  37       1.566  23.465  28.595  1.00  3.29           H  
ATOM    535  HA  GLN A  37       0.470  26.198  28.702  1.00  3.76           H  
ATOM    536  HB2 GLN A  37      -0.572  23.777  30.182  1.00  4.39           H  
ATOM    537  HB3 GLN A  37      -1.256  25.395  30.220  1.00  4.52           H  
ATOM    538  HG2 GLN A  37      -1.778  25.223  27.833  1.00  4.16           H  
ATOM    539  HG3 GLN A  37      -1.116  23.589  27.816  1.00  4.45           H  
ATOM    540 HE21 GLN A  37      -3.736  25.615  28.868  1.00  5.31           H  
ATOM    541 HE22 GLN A  37      -4.820  24.340  29.294  1.00  5.79           H  
ATOM    542  N   SER A  38       2.723  25.095  30.414  1.00  3.75           N  
ATOM    543  CA  SER A  38       3.632  25.274  31.543  1.00  4.18           C  
ATOM    544  C   SER A  38       5.085  25.290  31.078  1.00  4.18           C  
ATOM    545  O   SER A  38       5.462  24.559  30.162  1.00  4.39           O  
ATOM    546  CB  SER A  38       3.423  24.160  32.572  1.00  4.65           C  
ATOM    547  OG  SER A  38       2.134  24.240  33.156  1.00  4.88           O  
ATOM    548  H   SER A  38       3.051  24.658  29.601  1.00  3.75           H  
ATOM    549  HA  SER A  38       3.403  26.224  32.003  1.00  4.50           H  
ATOM    550  HB2 SER A  38       3.525  23.202  32.087  1.00  4.70           H  
ATOM    551  HB3 SER A  38       4.165  24.252  33.352  1.00  5.18           H  
ATOM    552  HG  SER A  38       1.475  24.338  32.466  1.00  4.99           H  
ATOM    553  N   THR A  39       5.894  26.127  31.718  1.00  4.37           N  
ATOM    554  CA  THR A  39       7.307  26.239  31.372  1.00  4.62           C  
ATOM    555  C   THR A  39       8.138  25.194  32.107  1.00  4.92           C  
ATOM    556  O   THR A  39       7.975  24.990  33.311  1.00  5.20           O  
ATOM    557  CB  THR A  39       7.856  27.641  31.695  1.00  4.99           C  
ATOM    558  OG1 THR A  39       7.626  27.951  33.076  1.00  5.27           O  
ATOM    559  CG2 THR A  39       7.202  28.697  30.817  1.00  5.22           C  
ATOM    560  H   THR A  39       5.534  26.685  32.439  1.00  4.59           H  
ATOM    561  HA  THR A  39       7.402  26.076  30.308  1.00  4.78           H  
ATOM    562  HB  THR A  39       8.919  27.646  31.507  1.00  5.32           H  
ATOM    563  HG1 THR A  39       8.344  28.496  33.405  1.00  5.49           H  
ATOM    564 HG21 THR A  39       7.596  29.670  31.070  1.00  5.37           H  
ATOM    565 HG22 THR A  39       6.135  28.688  30.978  1.00  5.54           H  
ATOM    566 HG23 THR A  39       7.411  28.483  29.779  1.00  5.30           H  
ATOM    567  N   THR A  40       9.032  24.535  31.375  1.00  5.20           N  
ATOM    568  CA  THR A  40       9.890  23.509  31.954  1.00  5.70           C  
ATOM    569  C   THR A  40      11.178  23.356  31.149  1.00  5.69           C  
ATOM    570  O   THR A  40      11.826  22.309  31.183  1.00  6.22           O  
ATOM    571  CB  THR A  40       9.165  22.149  32.021  1.00  6.36           C  
ATOM    572  OG1 THR A  40      10.009  21.168  32.638  1.00  6.91           O  
ATOM    573  CG2 THR A  40       8.764  21.679  30.631  1.00  6.50           C  
ATOM    574  H   THR A  40       9.115  24.747  30.421  1.00  5.28           H  
ATOM    575  HA  THR A  40      10.140  23.811  32.960  1.00  5.85           H  
ATOM    576  HB  THR A  40       8.270  22.266  32.616  1.00  6.59           H  
ATOM    577  HG1 THR A  40       9.471  20.446  32.970  1.00  7.36           H  
ATOM    578 HG21 THR A  40       8.105  22.406  30.181  1.00  6.69           H  
ATOM    579 HG22 THR A  40       8.257  20.727  30.704  1.00  6.78           H  
ATOM    580 HG23 THR A  40       9.649  21.569  30.020  1.00  6.45           H  
ATOM    581  N   GLY A  41      11.545  24.411  30.425  1.00  5.25           N  
ATOM    582  CA  GLY A  41      12.751  24.380  29.618  1.00  5.36           C  
ATOM    583  C   GLY A  41      12.454  24.375  28.132  1.00  4.81           C  
ATOM    584  O   GLY A  41      13.041  25.145  27.371  1.00  4.96           O  
ATOM    585  H   GLY A  41      10.989  25.218  30.441  1.00  4.97           H  
ATOM    586  HA2 GLY A  41      13.348  25.248  29.851  1.00  5.80           H  
ATOM    587  HA3 GLY A  41      13.314  23.491  29.864  1.00  5.60           H  
ATOM    588  N   GLU A  42      11.543  23.499  27.717  1.00  4.49           N  
ATOM    589  CA  GLU A  42      11.165  23.395  26.313  1.00  4.09           C  
ATOM    590  C   GLU A  42       9.761  23.945  26.085  1.00  3.18           C  
ATOM    591  O   GLU A  42       8.919  23.915  26.983  1.00  3.30           O  
ATOM    592  CB  GLU A  42      11.242  21.944  25.853  1.00  4.75           C  
ATOM    593  CG  GLU A  42      10.412  21.012  26.706  1.00  5.90           C  
ATOM    594  CD  GLU A  42      10.589  19.554  26.328  1.00  6.74           C  
ATOM    595  OE1 GLU A  42       9.856  19.078  25.436  1.00  7.22           O  
ATOM    596  OE2 GLU A  42      11.462  18.887  26.925  1.00  7.14           O  
ATOM    597  H   GLU A  42      11.113  22.910  28.371  1.00  4.76           H  
ATOM    598  HA  GLU A  42      11.861  23.978  25.741  1.00  4.38           H  
ATOM    599  HB2 GLU A  42      10.891  21.879  24.833  1.00  4.84           H  
ATOM    600  HB3 GLU A  42      12.271  21.618  25.893  1.00  4.66           H  
ATOM    601  HG2 GLU A  42      10.704  21.143  27.736  1.00  6.12           H  
ATOM    602  HG3 GLU A  42       9.373  21.277  26.592  1.00  6.22           H  
ATOM    603  N   ALA A  43       9.515  24.448  24.878  1.00  2.78           N  
ATOM    604  CA  ALA A  43       8.216  25.008  24.532  1.00  2.36           C  
ATOM    605  C   ALA A  43       8.063  25.142  23.022  1.00  2.13           C  
ATOM    606  O   ALA A  43       8.967  25.624  22.340  1.00  2.67           O  
ATOM    607  CB  ALA A  43       8.026  26.359  25.206  1.00  3.05           C  
ATOM    608  H   ALA A  43      10.224  24.437  24.203  1.00  3.18           H  
ATOM    609  HA  ALA A  43       7.454  24.337  24.903  1.00  2.41           H  
ATOM    610  HB1 ALA A  43       7.041  26.738  24.982  1.00  3.60           H  
ATOM    611  HB2 ALA A  43       8.771  27.051  24.841  1.00  3.34           H  
ATOM    612  HB3 ALA A  43       8.134  26.246  26.276  1.00  3.34           H  
ATOM    613  N   THR A  44       6.912  24.710  22.514  1.00  1.84           N  
ATOM    614  CA  THR A  44       6.616  24.773  21.082  1.00  1.65           C  
ATOM    615  C   THR A  44       7.738  24.152  20.251  1.00  1.26           C  
ATOM    616  O   THR A  44       8.636  23.503  20.787  1.00  1.53           O  
ATOM    617  CB  THR A  44       6.377  26.224  20.611  1.00  2.07           C  
ATOM    618  OG1 THR A  44       7.558  27.012  20.806  1.00  2.30           O  
ATOM    619  CG2 THR A  44       5.214  26.852  21.362  1.00  2.53           C  
ATOM    620  H   THR A  44       6.241  24.334  23.119  1.00  2.16           H  
ATOM    621  HA  THR A  44       5.709  24.213  20.910  1.00  1.70           H  
ATOM    622  HB  THR A  44       6.138  26.208  19.558  1.00  2.04           H  
ATOM    623  HG1 THR A  44       8.029  27.097  19.974  1.00  2.57           H  
ATOM    624 HG21 THR A  44       5.417  26.829  22.423  1.00  3.02           H  
ATOM    625 HG22 THR A  44       4.311  26.295  21.156  1.00  2.77           H  
ATOM    626 HG23 THR A  44       5.088  27.875  21.042  1.00  2.71           H  
ATOM    627  N   GLY A  45       7.671  24.346  18.938  1.00  1.05           N  
ATOM    628  CA  GLY A  45       8.681  23.798  18.053  1.00  0.80           C  
ATOM    629  C   GLY A  45       8.080  23.001  16.910  1.00  0.75           C  
ATOM    630  O   GLY A  45       7.060  22.333  17.083  1.00  1.14           O  
ATOM    631  H   GLY A  45       6.927  24.867  18.566  1.00  1.36           H  
ATOM    632  HA2 GLY A  45       9.266  24.610  17.643  1.00  0.93           H  
ATOM    633  HA3 GLY A  45       9.331  23.153  18.623  1.00  0.83           H  
ATOM    634  N   ILE A  46       8.709  23.073  15.741  1.00  0.46           N  
ATOM    635  CA  ILE A  46       8.227  22.352  14.568  1.00  0.39           C  
ATOM    636  C   ILE A  46       8.795  20.935  14.523  1.00  0.39           C  
ATOM    637  O   ILE A  46      10.010  20.745  14.547  1.00  0.57           O  
ATOM    638  CB  ILE A  46       8.602  23.087  13.264  1.00  0.38           C  
ATOM    639  CG1 ILE A  46       8.128  24.544  13.313  1.00  0.65           C  
ATOM    640  CG2 ILE A  46       8.009  22.371  12.059  1.00  0.43           C  
ATOM    641  CD1 ILE A  46       6.627  24.700  13.458  1.00  0.55           C  
ATOM    642  H   ILE A  46       9.515  23.625  15.666  1.00  0.55           H  
ATOM    643  HA  ILE A  46       7.150  22.296  14.629  1.00  0.43           H  
ATOM    644  HB  ILE A  46       9.676  23.070  13.166  1.00  0.56           H  
ATOM    645 HG12 ILE A  46       8.593  25.039  14.153  1.00  0.97           H  
ATOM    646 HG13 ILE A  46       8.426  25.042  12.400  1.00  1.03           H  
ATOM    647 HG21 ILE A  46       6.934  22.334  12.156  1.00  1.11           H  
ATOM    648 HG22 ILE A  46       8.400  21.367  12.007  1.00  1.00           H  
ATOM    649 HG23 ILE A  46       8.270  22.908  11.158  1.00  1.25           H  
ATOM    650 HD11 ILE A  46       6.378  25.749  13.505  1.00  1.06           H  
ATOM    651 HD12 ILE A  46       6.302  24.212  14.364  1.00  1.28           H  
ATOM    652 HD13 ILE A  46       6.136  24.249  12.609  1.00  1.15           H  
ATOM    653  N   TYR A  47       7.906  19.947  14.459  1.00  0.30           N  
ATOM    654  CA  TYR A  47       8.324  18.549  14.409  1.00  0.30           C  
ATOM    655  C   TYR A  47       7.350  17.714  13.580  1.00  0.26           C  
ATOM    656  O   TYR A  47       6.147  17.980  13.559  1.00  0.29           O  
ATOM    657  CB  TYR A  47       8.434  17.971  15.824  1.00  0.36           C  
ATOM    658  CG  TYR A  47       7.120  17.914  16.571  1.00  0.40           C  
ATOM    659  CD1 TYR A  47       6.667  19.005  17.301  1.00  0.43           C  
ATOM    660  CD2 TYR A  47       6.335  16.768  16.548  1.00  0.48           C  
ATOM    661  CE1 TYR A  47       5.469  18.955  17.988  1.00  0.51           C  
ATOM    662  CE2 TYR A  47       5.135  16.711  17.230  1.00  0.57           C  
ATOM    663  CZ  TYR A  47       4.706  17.806  17.949  1.00  0.58           C  
ATOM    664  OH  TYR A  47       3.513  17.752  18.632  1.00  0.70           O  
ATOM    665  H   TYR A  47       6.951  20.162  14.444  1.00  0.36           H  
ATOM    666  HA  TYR A  47       9.295  18.511  13.941  1.00  0.32           H  
ATOM    667  HB2 TYR A  47       8.822  16.965  15.763  1.00  0.41           H  
ATOM    668  HB3 TYR A  47       9.117  18.579  16.399  1.00  0.39           H  
ATOM    669  HD1 TYR A  47       7.264  19.904  17.329  1.00  0.44           H  
ATOM    670  HD2 TYR A  47       6.675  15.911  15.985  1.00  0.52           H  
ATOM    671  HE1 TYR A  47       5.134  19.815  18.550  1.00  0.57           H  
ATOM    672  HE2 TYR A  47       4.539  15.811  17.200  1.00  0.67           H  
ATOM    673  HH  TYR A  47       3.441  16.910  19.084  1.00  1.08           H  
ATOM    674  N   VAL A  48       7.882  16.700  12.900  1.00  0.26           N  
ATOM    675  CA  VAL A  48       7.069  15.820  12.068  1.00  0.25           C  
ATOM    676  C   VAL A  48       6.435  14.707  12.897  1.00  0.28           C  
ATOM    677  O   VAL A  48       7.091  14.102  13.747  1.00  0.39           O  
ATOM    678  CB  VAL A  48       7.907  15.190  10.938  1.00  0.27           C  
ATOM    679  CG1 VAL A  48       7.045  14.303  10.054  1.00  0.29           C  
ATOM    680  CG2 VAL A  48       8.585  16.273  10.115  1.00  0.29           C  
ATOM    681  H   VAL A  48       8.847  16.543  12.958  1.00  0.30           H  
ATOM    682  HA  VAL A  48       6.285  16.413  11.619  1.00  0.25           H  
ATOM    683  HB  VAL A  48       8.674  14.577  11.387  1.00  0.31           H  
ATOM    684 HG11 VAL A  48       6.619  13.506  10.648  1.00  1.04           H  
ATOM    685 HG12 VAL A  48       7.653  13.878   9.269  1.00  1.01           H  
ATOM    686 HG13 VAL A  48       6.252  14.890   9.618  1.00  1.06           H  
ATOM    687 HG21 VAL A  48       7.834  16.914   9.676  1.00  1.05           H  
ATOM    688 HG22 VAL A  48       9.171  15.815   9.332  1.00  1.02           H  
ATOM    689 HG23 VAL A  48       9.230  16.857  10.753  1.00  0.99           H  
ATOM    690  N   LYS A  49       5.158  14.439  12.636  1.00  0.31           N  
ATOM    691  CA  LYS A  49       4.428  13.400  13.353  1.00  0.38           C  
ATOM    692  C   LYS A  49       3.794  12.412  12.380  1.00  0.32           C  
ATOM    693  O   LYS A  49       3.555  11.254  12.723  1.00  0.37           O  
ATOM    694  CB  LYS A  49       3.351  14.032  14.238  1.00  0.49           C  
ATOM    695  CG  LYS A  49       2.608  13.030  15.111  1.00  0.61           C  
ATOM    696  CD  LYS A  49       1.590  13.716  16.011  1.00  0.84           C  
ATOM    697  CE  LYS A  49       0.440  14.309  15.213  1.00  1.65           C  
ATOM    698  NZ  LYS A  49      -0.517  15.046  16.083  1.00  2.40           N  
ATOM    699  H   LYS A  49       4.697  14.954  11.942  1.00  0.36           H  
ATOM    700  HA  LYS A  49       5.132  12.872  13.979  1.00  0.49           H  
ATOM    701  HB2 LYS A  49       3.814  14.763  14.882  1.00  0.58           H  
ATOM    702  HB3 LYS A  49       2.630  14.529  13.605  1.00  0.48           H  
ATOM    703  HG2 LYS A  49       2.094  12.325  14.475  1.00  0.58           H  
ATOM    704  HG3 LYS A  49       3.325  12.506  15.727  1.00  0.77           H  
ATOM    705  HD2 LYS A  49       1.194  12.989  16.705  1.00  1.30           H  
ATOM    706  HD3 LYS A  49       2.083  14.505  16.558  1.00  1.47           H  
ATOM    707  HE2 LYS A  49       0.841  14.991  14.478  1.00  2.21           H  
ATOM    708  HE3 LYS A  49      -0.084  13.509  14.710  1.00  2.14           H  
ATOM    709  HZ1 LYS A  49      -0.888  14.413  16.820  1.00  2.76           H  
ATOM    710  HZ2 LYS A  49      -1.312  15.404  15.516  1.00  2.80           H  
ATOM    711  HZ3 LYS A  49      -0.041  15.849  16.540  1.00  2.89           H  
ATOM    712  N   SER A  50       3.522  12.877  11.162  1.00  0.28           N  
ATOM    713  CA  SER A  50       2.917  12.033  10.138  1.00  0.35           C  
ATOM    714  C   SER A  50       3.611  12.227   8.793  1.00  0.28           C  
ATOM    715  O   SER A  50       4.428  13.134   8.631  1.00  0.25           O  
ATOM    716  CB  SER A  50       1.424  12.343  10.008  1.00  0.49           C  
ATOM    717  OG  SER A  50       0.814  11.515   9.033  1.00  1.28           O  
ATOM    718  H   SER A  50       3.733  13.811  10.950  1.00  0.26           H  
ATOM    719  HA  SER A  50       3.036  11.005  10.446  1.00  0.47           H  
ATOM    720  HB2 SER A  50       0.939  12.174  10.958  1.00  1.18           H  
ATOM    721  HB3 SER A  50       1.297  13.376   9.718  1.00  1.20           H  
ATOM    722  HG  SER A  50       0.447  10.736   9.458  1.00  1.87           H  
ATOM    723  N   LEU A  51       3.279  11.370   7.832  1.00  0.32           N  
ATOM    724  CA  LEU A  51       3.874  11.441   6.501  1.00  0.27           C  
ATOM    725  C   LEU A  51       2.838  11.130   5.423  1.00  0.27           C  
ATOM    726  O   LEU A  51       1.802  10.528   5.700  1.00  0.42           O  
ATOM    727  CB  LEU A  51       5.046  10.463   6.393  1.00  0.30           C  
ATOM    728  CG  LEU A  51       6.202  10.726   7.362  1.00  0.33           C  
ATOM    729  CD1 LEU A  51       7.171   9.553   7.364  1.00  0.40           C  
ATOM    730  CD2 LEU A  51       6.926  12.012   6.994  1.00  0.32           C  
ATOM    731  H   LEU A  51       2.619  10.672   8.022  1.00  0.41           H  
ATOM    732  HA  LEU A  51       4.241  12.447   6.353  1.00  0.25           H  
ATOM    733  HB2 LEU A  51       4.670   9.465   6.575  1.00  0.33           H  
ATOM    734  HB3 LEU A  51       5.433  10.505   5.387  1.00  0.29           H  
ATOM    735  HG  LEU A  51       5.808  10.834   8.361  1.00  0.37           H  
ATOM    736 HD11 LEU A  51       7.982   9.757   8.048  1.00  1.19           H  
ATOM    737 HD12 LEU A  51       7.566   9.409   6.369  1.00  1.04           H  
ATOM    738 HD13 LEU A  51       6.653   8.658   7.678  1.00  1.05           H  
ATOM    739 HD21 LEU A  51       7.697  12.212   7.723  1.00  1.02           H  
ATOM    740 HD22 LEU A  51       6.220  12.831   6.983  1.00  1.05           H  
ATOM    741 HD23 LEU A  51       7.373  11.907   6.016  1.00  1.05           H  
ATOM    742  N   ILE A  52       3.126  11.548   4.192  1.00  0.24           N  
ATOM    743  CA  ILE A  52       2.222  11.311   3.071  1.00  0.24           C  
ATOM    744  C   ILE A  52       2.779  10.234   2.139  1.00  0.23           C  
ATOM    745  O   ILE A  52       3.676  10.507   1.339  1.00  0.28           O  
ATOM    746  CB  ILE A  52       1.977  12.597   2.262  1.00  0.27           C  
ATOM    747  CG1 ILE A  52       1.439  13.698   3.179  1.00  0.36           C  
ATOM    748  CG2 ILE A  52       1.007  12.324   1.119  1.00  0.31           C  
ATOM    749  CD1 ILE A  52       1.142  14.995   2.463  1.00  1.26           C  
ATOM    750  H   ILE A  52       3.967  12.027   4.034  1.00  0.34           H  
ATOM    751  HA  ILE A  52       1.276  10.982   3.472  1.00  0.28           H  
ATOM    752  HB  ILE A  52       2.915  12.916   1.837  1.00  0.27           H  
ATOM    753 HG12 ILE A  52       0.522  13.358   3.639  1.00  0.95           H  
ATOM    754 HG13 ILE A  52       2.169  13.902   3.951  1.00  0.94           H  
ATOM    755 HG21 ILE A  52       1.417  11.559   0.475  1.00  1.05           H  
ATOM    756 HG22 ILE A  52       0.855  13.229   0.550  1.00  0.98           H  
ATOM    757 HG23 ILE A  52       0.062  11.987   1.521  1.00  1.00           H  
ATOM    758 HD11 ILE A  52       2.042  15.358   1.990  1.00  1.85           H  
ATOM    759 HD12 ILE A  52       0.790  15.727   3.176  1.00  1.81           H  
ATOM    760 HD13 ILE A  52       0.384  14.826   1.715  1.00  1.83           H  
ATOM    761  N   PRO A  53       2.256   8.994   2.227  1.00  0.31           N  
ATOM    762  CA  PRO A  53       2.715   7.884   1.381  1.00  0.35           C  
ATOM    763  C   PRO A  53       2.665   8.229  -0.105  1.00  0.34           C  
ATOM    764  O   PRO A  53       1.693   8.812  -0.585  1.00  0.46           O  
ATOM    765  CB  PRO A  53       1.727   6.760   1.700  1.00  0.43           C  
ATOM    766  CG  PRO A  53       1.219   7.076   3.065  1.00  0.82           C  
ATOM    767  CD  PRO A  53       1.187   8.576   3.153  1.00  0.47           C  
ATOM    768  HA  PRO A  53       3.715   7.574   1.644  1.00  0.39           H  
ATOM    769  HB2 PRO A  53       0.930   6.759   0.972  1.00  0.46           H  
ATOM    770  HB3 PRO A  53       2.240   5.811   1.681  1.00  0.64           H  
ATOM    771  HG2 PRO A  53       0.226   6.672   3.189  1.00  1.23           H  
ATOM    772  HG3 PRO A  53       1.887   6.670   3.808  1.00  1.26           H  
ATOM    773  HD2 PRO A  53       0.227   8.953   2.830  1.00  0.56           H  
ATOM    774  HD3 PRO A  53       1.403   8.899   4.160  1.00  0.52           H  
ATOM    775  N   GLY A  54       3.722   7.865  -0.827  1.00  0.39           N  
ATOM    776  CA  GLY A  54       3.780   8.140  -2.251  1.00  0.41           C  
ATOM    777  C   GLY A  54       4.616   9.363  -2.578  1.00  0.39           C  
ATOM    778  O   GLY A  54       4.951   9.598  -3.739  1.00  0.49           O  
ATOM    779  H   GLY A  54       4.468   7.406  -0.388  1.00  0.52           H  
ATOM    780  HA2 GLY A  54       4.204   7.284  -2.754  1.00  0.45           H  
ATOM    781  HA3 GLY A  54       2.775   8.297  -2.617  1.00  0.45           H  
ATOM    782  N   SER A  55       4.954  10.142  -1.556  1.00  0.35           N  
ATOM    783  CA  SER A  55       5.756  11.345  -1.746  1.00  0.35           C  
ATOM    784  C   SER A  55       7.246  11.027  -1.675  1.00  0.32           C  
ATOM    785  O   SER A  55       7.633   9.880  -1.460  1.00  0.36           O  
ATOM    786  CB  SER A  55       5.394  12.399  -0.697  1.00  0.37           C  
ATOM    787  OG  SER A  55       4.029  12.767  -0.794  1.00  1.23           O  
ATOM    788  H   SER A  55       4.659   9.902  -0.652  1.00  0.39           H  
ATOM    789  HA  SER A  55       5.532  11.738  -2.727  1.00  0.38           H  
ATOM    790  HB2 SER A  55       5.576  11.998   0.289  1.00  1.04           H  
ATOM    791  HB3 SER A  55       6.003  13.277  -0.847  1.00  1.08           H  
ATOM    792  HG  SER A  55       3.735  12.668  -1.703  1.00  1.73           H  
ATOM    793  N   ALA A  56       8.076  12.049  -1.854  1.00  0.35           N  
ATOM    794  CA  ALA A  56       9.523  11.872  -1.815  1.00  0.36           C  
ATOM    795  C   ALA A  56       9.993  11.409  -0.439  1.00  0.32           C  
ATOM    796  O   ALA A  56      10.676  10.391  -0.315  1.00  0.34           O  
ATOM    797  CB  ALA A  56      10.221  13.167  -2.203  1.00  0.42           C  
ATOM    798  H   ALA A  56       7.707  12.940  -2.018  1.00  0.39           H  
ATOM    799  HA  ALA A  56       9.786  11.120  -2.545  1.00  0.38           H  
ATOM    800  HB1 ALA A  56       9.972  13.937  -1.487  1.00  1.07           H  
ATOM    801  HB2 ALA A  56       9.896  13.471  -3.186  1.00  1.13           H  
ATOM    802  HB3 ALA A  56      11.290  13.012  -2.208  1.00  1.03           H  
ATOM    803  N   ALA A  57       9.622  12.163   0.591  1.00  0.30           N  
ATOM    804  CA  ALA A  57      10.008  11.842   1.962  1.00  0.30           C  
ATOM    805  C   ALA A  57       9.615  10.416   2.341  1.00  0.30           C  
ATOM    806  O   ALA A  57      10.423   9.665   2.886  1.00  0.35           O  
ATOM    807  CB  ALA A  57       9.381  12.834   2.929  1.00  0.32           C  
ATOM    808  H   ALA A  57       9.076  12.959   0.425  1.00  0.31           H  
ATOM    809  HA  ALA A  57      11.082  11.940   2.034  1.00  0.32           H  
ATOM    810  HB1 ALA A  57       9.672  13.837   2.653  1.00  1.09           H  
ATOM    811  HB2 ALA A  57       9.721  12.622   3.932  1.00  1.04           H  
ATOM    812  HB3 ALA A  57       8.305  12.746   2.887  1.00  1.02           H  
ATOM    813  N   ALA A  58       8.370  10.048   2.051  1.00  0.31           N  
ATOM    814  CA  ALA A  58       7.869   8.714   2.372  1.00  0.33           C  
ATOM    815  C   ALA A  58       8.627   7.628   1.609  1.00  0.34           C  
ATOM    816  O   ALA A  58       9.194   6.715   2.208  1.00  0.44           O  
ATOM    817  CB  ALA A  58       6.380   8.625   2.073  1.00  0.37           C  
ATOM    818  H   ALA A  58       7.774  10.689   1.610  1.00  0.33           H  
ATOM    819  HA  ALA A  58       8.007   8.554   3.431  1.00  0.36           H  
ATOM    820  HB1 ALA A  58       6.217   8.756   1.013  1.00  1.01           H  
ATOM    821  HB2 ALA A  58       5.857   9.400   2.616  1.00  1.11           H  
ATOM    822  HB3 ALA A  58       6.008   7.658   2.378  1.00  1.11           H  
ATOM    823  N   LEU A  59       8.632   7.735   0.282  1.00  0.35           N  
ATOM    824  CA  LEU A  59       9.310   6.759  -0.566  1.00  0.39           C  
ATOM    825  C   LEU A  59      10.803   6.688  -0.255  1.00  0.42           C  
ATOM    826  O   LEU A  59      11.465   5.701  -0.577  1.00  0.57           O  
ATOM    827  CB  LEU A  59       9.106   7.106  -2.043  1.00  0.47           C  
ATOM    828  CG  LEU A  59       7.652   7.089  -2.519  1.00  0.53           C  
ATOM    829  CD1 LEU A  59       7.546   7.666  -3.923  1.00  0.66           C  
ATOM    830  CD2 LEU A  59       7.092   5.676  -2.478  1.00  0.61           C  
ATOM    831  H   LEU A  59       8.165   8.488  -0.136  1.00  0.41           H  
ATOM    832  HA  LEU A  59       8.871   5.792  -0.373  1.00  0.41           H  
ATOM    833  HB2 LEU A  59       9.510   8.094  -2.217  1.00  0.48           H  
ATOM    834  HB3 LEU A  59       9.663   6.399  -2.638  1.00  0.52           H  
ATOM    835  HG  LEU A  59       7.057   7.705  -1.860  1.00  0.50           H  
ATOM    836 HD11 LEU A  59       8.143   7.075  -4.600  1.00  1.12           H  
ATOM    837 HD12 LEU A  59       7.905   8.684  -3.920  1.00  1.12           H  
ATOM    838 HD13 LEU A  59       6.514   7.648  -4.242  1.00  1.29           H  
ATOM    839 HD21 LEU A  59       7.123   5.304  -1.464  1.00  1.18           H  
ATOM    840 HD22 LEU A  59       7.686   5.035  -3.115  1.00  1.10           H  
ATOM    841 HD23 LEU A  59       6.070   5.682  -2.828  1.00  1.29           H  
ATOM    842  N   ASP A  60      11.328   7.738   0.370  1.00  0.44           N  
ATOM    843  CA  ASP A  60      12.745   7.786   0.717  1.00  0.52           C  
ATOM    844  C   ASP A  60      13.124   6.623   1.625  1.00  0.61           C  
ATOM    845  O   ASP A  60      14.113   5.930   1.386  1.00  0.79           O  
ATOM    846  CB  ASP A  60      13.082   9.112   1.400  1.00  0.74           C  
ATOM    847  CG  ASP A  60      14.563   9.251   1.690  1.00  1.08           C  
ATOM    848  OD1 ASP A  60      14.996   8.834   2.785  1.00  1.86           O  
ATOM    849  OD2 ASP A  60      15.292   9.776   0.821  1.00  1.32           O  
ATOM    850  H   ASP A  60      10.752   8.494   0.605  1.00  0.52           H  
ATOM    851  HA  ASP A  60      13.312   7.711  -0.199  1.00  0.67           H  
ATOM    852  HB2 ASP A  60      12.781   9.928   0.760  1.00  1.04           H  
ATOM    853  HB3 ASP A  60      12.544   9.175   2.334  1.00  1.34           H  
ATOM    854  N   GLY A  61      12.328   6.413   2.669  1.00  0.72           N  
ATOM    855  CA  GLY A  61      12.591   5.330   3.598  1.00  1.06           C  
ATOM    856  C   GLY A  61      13.248   5.804   4.878  1.00  0.83           C  
ATOM    857  O   GLY A  61      12.816   5.446   5.973  1.00  0.94           O  
ATOM    858  H   GLY A  61      11.555   6.999   2.809  1.00  0.68           H  
ATOM    859  HA2 GLY A  61      11.657   4.848   3.843  1.00  1.32           H  
ATOM    860  HA3 GLY A  61      13.237   4.610   3.118  1.00  1.42           H  
ATOM    861  N   ARG A  62      14.297   6.613   4.743  1.00  0.63           N  
ATOM    862  CA  ARG A  62      15.013   7.132   5.902  1.00  0.59           C  
ATOM    863  C   ARG A  62      14.121   8.058   6.724  1.00  0.52           C  
ATOM    864  O   ARG A  62      14.347   8.253   7.919  1.00  0.69           O  
ATOM    865  CB  ARG A  62      16.275   7.878   5.458  1.00  0.67           C  
ATOM    866  CG  ARG A  62      17.231   7.024   4.641  1.00  0.81           C  
ATOM    867  CD  ARG A  62      18.466   7.809   4.225  1.00  1.05           C  
ATOM    868  NE  ARG A  62      19.215   8.304   5.379  1.00  1.31           N  
ATOM    869  CZ  ARG A  62      20.298   9.069   5.281  1.00  1.93           C  
ATOM    870  NH1 ARG A  62      20.752   9.437   4.091  1.00  2.26           N  
ATOM    871  NH2 ARG A  62      20.930   9.467   6.377  1.00  2.59           N  
ATOM    872  H   ARG A  62      14.594   6.862   3.844  1.00  0.65           H  
ATOM    873  HA  ARG A  62      15.301   6.293   6.516  1.00  0.75           H  
ATOM    874  HB2 ARG A  62      15.985   8.731   4.860  1.00  0.66           H  
ATOM    875  HB3 ARG A  62      16.799   8.228   6.335  1.00  0.81           H  
ATOM    876  HG2 ARG A  62      17.540   6.179   5.235  1.00  1.27           H  
ATOM    877  HG3 ARG A  62      16.721   6.679   3.754  1.00  1.16           H  
ATOM    878  HD2 ARG A  62      19.106   7.165   3.643  1.00  1.70           H  
ATOM    879  HD3 ARG A  62      18.156   8.649   3.621  1.00  1.57           H  
ATOM    880  HE  ARG A  62      18.895   8.051   6.271  1.00  1.50           H  
ATOM    881 HH11 ARG A  62      20.279   9.143   3.261  1.00  2.25           H  
ATOM    882 HH12 ARG A  62      21.567  10.014   4.023  1.00  2.78           H  
ATOM    883 HH21 ARG A  62      20.593   9.194   7.277  1.00  2.79           H  
ATOM    884 HH22 ARG A  62      21.748  10.040   6.302  1.00  3.05           H  
ATOM    885  N   ILE A  63      13.108   8.626   6.076  1.00  0.48           N  
ATOM    886  CA  ILE A  63      12.181   9.528   6.751  1.00  0.48           C  
ATOM    887  C   ILE A  63      11.191   8.745   7.607  1.00  0.49           C  
ATOM    888  O   ILE A  63      10.199   8.218   7.103  1.00  0.59           O  
ATOM    889  CB  ILE A  63      11.397  10.391   5.742  1.00  0.58           C  
ATOM    890  CG1 ILE A  63      12.357  11.108   4.785  1.00  0.66           C  
ATOM    891  CG2 ILE A  63      10.516  11.395   6.473  1.00  0.66           C  
ATOM    892  CD1 ILE A  63      13.306  12.069   5.470  1.00  0.92           C  
ATOM    893  H   ILE A  63      12.980   8.435   5.124  1.00  0.59           H  
ATOM    894  HA  ILE A  63      12.755  10.185   7.388  1.00  0.50           H  
ATOM    895  HB  ILE A  63      10.754   9.739   5.171  1.00  0.62           H  
ATOM    896 HG12 ILE A  63      12.953  10.372   4.267  1.00  1.23           H  
ATOM    897 HG13 ILE A  63      11.781  11.668   4.063  1.00  1.11           H  
ATOM    898 HG21 ILE A  63       9.798  10.867   7.084  1.00  1.24           H  
ATOM    899 HG22 ILE A  63       9.996  12.010   5.754  1.00  1.30           H  
ATOM    900 HG23 ILE A  63      11.131  12.022   7.103  1.00  1.07           H  
ATOM    901 HD11 ILE A  63      13.907  11.532   6.189  1.00  1.49           H  
ATOM    902 HD12 ILE A  63      12.740  12.836   5.975  1.00  1.38           H  
ATOM    903 HD13 ILE A  63      13.951  12.526   4.733  1.00  1.63           H  
ATOM    904  N   GLU A  64      11.470   8.671   8.906  1.00  0.51           N  
ATOM    905  CA  GLU A  64      10.602   7.951   9.828  1.00  0.58           C  
ATOM    906  C   GLU A  64       9.837   8.928  10.721  1.00  0.56           C  
ATOM    907  O   GLU A  64      10.274  10.060  10.928  1.00  0.66           O  
ATOM    908  CB  GLU A  64      11.425   6.986  10.686  1.00  0.79           C  
ATOM    909  CG  GLU A  64      12.273   7.674  11.743  1.00  1.09           C  
ATOM    910  CD  GLU A  64      13.134   6.700  12.523  1.00  1.39           C  
ATOM    911  OE1 GLU A  64      12.599   6.029  13.432  1.00  1.98           O  
ATOM    912  OE2 GLU A  64      14.344   6.607  12.225  1.00  1.67           O  
ATOM    913  H   GLU A  64      12.274   9.110   9.249  1.00  0.56           H  
ATOM    914  HA  GLU A  64       9.893   7.386   9.244  1.00  0.62           H  
ATOM    915  HB2 GLU A  64      10.752   6.304  11.185  1.00  1.16           H  
ATOM    916  HB3 GLU A  64      12.081   6.419  10.042  1.00  1.36           H  
ATOM    917  HG2 GLU A  64      12.915   8.394  11.259  1.00  1.65           H  
ATOM    918  HG3 GLU A  64      11.618   8.184  12.434  1.00  1.50           H  
ATOM    919  N   PRO A  65       8.680   8.503  11.263  1.00  0.56           N  
ATOM    920  CA  PRO A  65       7.862   9.352  12.137  1.00  0.64           C  
ATOM    921  C   PRO A  65       8.582   9.714  13.430  1.00  0.72           C  
ATOM    922  O   PRO A  65       9.667   9.201  13.710  1.00  1.44           O  
ATOM    923  CB  PRO A  65       6.635   8.482  12.435  1.00  0.77           C  
ATOM    924  CG  PRO A  65       7.099   7.087  12.208  1.00  0.83           C  
ATOM    925  CD  PRO A  65       8.081   7.170  11.077  1.00  0.62           C  
ATOM    926  HA  PRO A  65       7.552  10.257  11.633  1.00  0.65           H  
ATOM    927  HB2 PRO A  65       6.321   8.635  13.458  1.00  1.02           H  
ATOM    928  HB3 PRO A  65       5.831   8.745  11.763  1.00  0.95           H  
ATOM    929  HG2 PRO A  65       7.584   6.711  13.098  1.00  1.17           H  
ATOM    930  HG3 PRO A  65       6.265   6.459  11.936  1.00  1.16           H  
ATOM    931  HD2 PRO A  65       8.826   6.393  11.164  1.00  0.71           H  
ATOM    932  HD3 PRO A  65       7.571   7.107  10.127  1.00  0.77           H  
ATOM    933  N   ASN A  66       7.973  10.600  14.212  1.00  0.60           N  
ATOM    934  CA  ASN A  66       8.549  11.031  15.482  1.00  0.59           C  
ATOM    935  C   ASN A  66       9.937  11.635  15.284  1.00  0.51           C  
ATOM    936  O   ASN A  66      10.949  11.010  15.600  1.00  0.73           O  
ATOM    937  CB  ASN A  66       8.624   9.857  16.460  1.00  0.66           C  
ATOM    938  CG  ASN A  66       7.264   9.245  16.732  1.00  1.34           C  
ATOM    939  OD1 ASN A  66       6.243   9.933  16.695  1.00  2.15           O  
ATOM    940  ND2 ASN A  66       7.242   7.947  17.011  1.00  2.01           N  
ATOM    941  H   ASN A  66       7.113  10.975  13.928  1.00  1.09           H  
ATOM    942  HA  ASN A  66       7.899  11.788  15.897  1.00  0.64           H  
ATOM    943  HB2 ASN A  66       9.264   9.091  16.045  1.00  1.00           H  
ATOM    944  HB3 ASN A  66       9.040  10.199  17.394  1.00  1.22           H  
ATOM    945 HD21 ASN A  66       8.094   7.462  17.023  1.00  2.28           H  
ATOM    946 HD22 ASN A  66       6.376   7.527  17.191  1.00  2.63           H  
ATOM    947  N   ASP A  67       9.975  12.853  14.756  1.00  0.36           N  
ATOM    948  CA  ASP A  67      11.238  13.548  14.523  1.00  0.34           C  
ATOM    949  C   ASP A  67      11.047  15.054  14.646  1.00  0.30           C  
ATOM    950  O   ASP A  67       9.959  15.570  14.389  1.00  0.38           O  
ATOM    951  CB  ASP A  67      11.798  13.200  13.143  1.00  0.41           C  
ATOM    952  CG  ASP A  67      10.851  13.577  12.022  1.00  1.17           C  
ATOM    953  OD1 ASP A  67       9.998  12.739  11.657  1.00  2.02           O  
ATOM    954  OD2 ASP A  67      10.962  14.709  11.506  1.00  1.46           O  
ATOM    955  H   ASP A  67       9.134  13.299  14.517  1.00  0.44           H  
ATOM    956  HA  ASP A  67      11.939  13.224  15.278  1.00  0.38           H  
ATOM    957  HB2 ASP A  67      12.728  13.729  12.996  1.00  1.05           H  
ATOM    958  HB3 ASP A  67      11.982  12.137  13.093  1.00  1.13           H  
ATOM    959  N   LYS A  68      12.104  15.755  15.042  1.00  0.27           N  
ATOM    960  CA  LYS A  68      12.039  17.202  15.203  1.00  0.28           C  
ATOM    961  C   LYS A  68      12.851  17.915  14.126  1.00  0.26           C  
ATOM    962  O   LYS A  68      14.074  17.791  14.072  1.00  0.38           O  
ATOM    963  CB  LYS A  68      12.545  17.603  16.590  1.00  0.37           C  
ATOM    964  CG  LYS A  68      12.539  19.104  16.829  1.00  0.53           C  
ATOM    965  CD  LYS A  68      13.103  19.454  18.196  1.00  0.53           C  
ATOM    966  CE  LYS A  68      13.159  20.958  18.404  1.00  0.58           C  
ATOM    967  NZ  LYS A  68      13.747  21.314  19.724  1.00  1.02           N  
ATOM    968  H   LYS A  68      12.946  15.288  15.231  1.00  0.32           H  
ATOM    969  HA  LYS A  68      11.005  17.498  15.110  1.00  0.29           H  
ATOM    970  HB2 LYS A  68      11.919  17.140  17.338  1.00  0.51           H  
ATOM    971  HB3 LYS A  68      13.557  17.245  16.709  1.00  0.55           H  
ATOM    972  HG2 LYS A  68      13.138  19.582  16.070  1.00  0.84           H  
ATOM    973  HG3 LYS A  68      11.521  19.464  16.766  1.00  0.81           H  
ATOM    974  HD2 LYS A  68      12.474  19.019  18.958  1.00  0.66           H  
ATOM    975  HD3 LYS A  68      14.101  19.050  18.278  1.00  0.63           H  
ATOM    976  HE2 LYS A  68      13.763  21.395  17.621  1.00  0.77           H  
ATOM    977  HE3 LYS A  68      12.156  21.355  18.347  1.00  0.74           H  
ATOM    978  HZ1 LYS A  68      13.792  22.348  19.829  1.00  1.62           H  
ATOM    979  HZ2 LYS A  68      14.709  20.926  19.804  1.00  1.38           H  
ATOM    980  HZ3 LYS A  68      13.163  20.926  20.493  1.00  1.52           H  
ATOM    981  N   ILE A  69      12.158  18.661  13.269  1.00  0.24           N  
ATOM    982  CA  ILE A  69      12.814  19.402  12.198  1.00  0.21           C  
ATOM    983  C   ILE A  69      13.615  20.569  12.765  1.00  0.21           C  
ATOM    984  O   ILE A  69      13.171  21.244  13.694  1.00  0.29           O  
ATOM    985  CB  ILE A  69      11.792  19.947  11.180  1.00  0.23           C  
ATOM    986  CG1 ILE A  69      10.935  18.811  10.615  1.00  0.26           C  
ATOM    987  CG2 ILE A  69      12.504  20.691  10.056  1.00  0.23           C  
ATOM    988  CD1 ILE A  69      11.720  17.782   9.828  1.00  0.28           C  
ATOM    989  H   ILE A  69      11.184  18.714  13.360  1.00  0.35           H  
ATOM    990  HA  ILE A  69      13.485  18.729  11.684  1.00  0.21           H  
ATOM    991  HB  ILE A  69      11.152  20.651  11.690  1.00  0.25           H  
ATOM    992 HG12 ILE A  69      10.446  18.299  11.430  1.00  0.28           H  
ATOM    993 HG13 ILE A  69      10.184  19.228   9.960  1.00  0.28           H  
ATOM    994 HG21 ILE A  69      13.195  20.022   9.563  1.00  0.99           H  
ATOM    995 HG22 ILE A  69      13.047  21.529  10.467  1.00  1.01           H  
ATOM    996 HG23 ILE A  69      11.777  21.049   9.342  1.00  1.00           H  
ATOM    997 HD11 ILE A  69      12.452  17.318  10.471  1.00  1.00           H  
ATOM    998 HD12 ILE A  69      12.221  18.266   9.003  1.00  1.05           H  
ATOM    999 HD13 ILE A  69      11.047  17.029   9.447  1.00  1.11           H  
ATOM   1000  N   LEU A  70      14.797  20.800  12.203  1.00  0.19           N  
ATOM   1001  CA  LEU A  70      15.656  21.885  12.660  1.00  0.21           C  
ATOM   1002  C   LEU A  70      15.872  22.920  11.561  1.00  0.20           C  
ATOM   1003  O   LEU A  70      15.447  24.070  11.686  1.00  0.26           O  
ATOM   1004  CB  LEU A  70      17.003  21.332  13.131  1.00  0.25           C  
ATOM   1005  CG  LEU A  70      16.929  20.336  14.290  1.00  0.32           C  
ATOM   1006  CD1 LEU A  70      18.310  19.788  14.613  1.00  0.40           C  
ATOM   1007  CD2 LEU A  70      16.316  20.991  15.519  1.00  0.38           C  
ATOM   1008  H   LEU A  70      15.096  20.231  11.464  1.00  0.22           H  
ATOM   1009  HA  LEU A  70      15.166  22.364  13.494  1.00  0.25           H  
ATOM   1010  HB2 LEU A  70      17.481  20.845  12.293  1.00  0.26           H  
ATOM   1011  HB3 LEU A  70      17.620  22.164  13.440  1.00  0.29           H  
ATOM   1012  HG  LEU A  70      16.299  19.506  14.004  1.00  0.31           H  
ATOM   1013 HD11 LEU A  70      18.965  20.601  14.886  1.00  1.13           H  
ATOM   1014 HD12 LEU A  70      18.708  19.281  13.747  1.00  1.00           H  
ATOM   1015 HD13 LEU A  70      18.238  19.092  15.435  1.00  1.13           H  
ATOM   1016 HD21 LEU A  70      16.910  21.846  15.805  1.00  1.04           H  
ATOM   1017 HD22 LEU A  70      16.292  20.282  16.333  1.00  1.06           H  
ATOM   1018 HD23 LEU A  70      15.309  21.312  15.292  1.00  1.03           H  
ATOM   1019  N   ARG A  71      16.535  22.510  10.483  1.00  0.20           N  
ATOM   1020  CA  ARG A  71      16.812  23.417   9.372  1.00  0.25           C  
ATOM   1021  C   ARG A  71      16.668  22.716   8.024  1.00  0.18           C  
ATOM   1022  O   ARG A  71      17.148  21.599   7.837  1.00  0.26           O  
ATOM   1023  CB  ARG A  71      18.226  23.988   9.502  1.00  0.38           C  
ATOM   1024  CG  ARG A  71      18.476  24.714  10.812  1.00  0.91           C  
ATOM   1025  CD  ARG A  71      19.936  25.113  10.959  1.00  0.77           C  
ATOM   1026  NE  ARG A  71      20.340  26.091   9.953  1.00  1.38           N  
ATOM   1027  CZ  ARG A  71      21.579  26.559   9.834  1.00  1.65           C  
ATOM   1028  NH1 ARG A  71      22.535  26.128  10.646  1.00  1.17           N  
ATOM   1029  NH2 ARG A  71      21.864  27.458   8.901  1.00  2.61           N  
ATOM   1030  H   ARG A  71      16.843  21.582  10.433  1.00  0.21           H  
ATOM   1031  HA  ARG A  71      16.102  24.228   9.421  1.00  0.31           H  
ATOM   1032  HB2 ARG A  71      18.936  23.177   9.424  1.00  1.17           H  
ATOM   1033  HB3 ARG A  71      18.396  24.681   8.692  1.00  0.99           H  
ATOM   1034  HG2 ARG A  71      17.866  25.604  10.840  1.00  1.48           H  
ATOM   1035  HG3 ARG A  71      18.205  24.064  11.632  1.00  1.62           H  
ATOM   1036  HD2 ARG A  71      20.084  25.538  11.940  1.00  1.07           H  
ATOM   1037  HD3 ARG A  71      20.549  24.229  10.854  1.00  1.16           H  
ATOM   1038  HE  ARG A  71      19.651  26.418   9.337  1.00  1.91           H  
ATOM   1039 HH11 ARG A  71      22.326  25.450  11.350  1.00  0.96           H  
ATOM   1040 HH12 ARG A  71      23.466  26.484  10.555  1.00  1.43           H  
ATOM   1041 HH21 ARG A  71      21.146  27.785   8.286  1.00  3.15           H  
ATOM   1042 HH22 ARG A  71      22.796  27.808   8.812  1.00  2.85           H  
ATOM   1043  N   VAL A  72      16.000  23.385   7.091  1.00  0.21           N  
ATOM   1044  CA  VAL A  72      15.807  22.853   5.747  1.00  0.17           C  
ATOM   1045  C   VAL A  72      16.958  23.303   4.847  1.00  0.17           C  
ATOM   1046  O   VAL A  72      17.824  24.059   5.284  1.00  0.20           O  
ATOM   1047  CB  VAL A  72      14.461  23.324   5.149  1.00  0.20           C  
ATOM   1048  CG1 VAL A  72      14.094  22.522   3.907  1.00  0.22           C  
ATOM   1049  CG2 VAL A  72      13.354  23.229   6.189  1.00  0.28           C  
ATOM   1050  H   VAL A  72      15.625  24.263   7.312  1.00  0.34           H  
ATOM   1051  HA  VAL A  72      15.802  21.774   5.807  1.00  0.17           H  
ATOM   1052  HB  VAL A  72      14.562  24.360   4.862  1.00  0.25           H  
ATOM   1053 HG11 VAL A  72      13.094  22.784   3.592  1.00  1.02           H  
ATOM   1054 HG12 VAL A  72      14.136  21.467   4.134  1.00  1.04           H  
ATOM   1055 HG13 VAL A  72      14.791  22.748   3.114  1.00  1.01           H  
ATOM   1056 HG21 VAL A  72      13.250  22.204   6.510  1.00  0.98           H  
ATOM   1057 HG22 VAL A  72      12.424  23.567   5.757  1.00  1.09           H  
ATOM   1058 HG23 VAL A  72      13.604  23.850   7.038  1.00  1.02           H  
ATOM   1059  N   ASP A  73      16.986  22.819   3.610  1.00  0.18           N  
ATOM   1060  CA  ASP A  73      18.033  23.193   2.660  1.00  0.21           C  
ATOM   1061  C   ASP A  73      18.253  24.707   2.630  1.00  0.22           C  
ATOM   1062  O   ASP A  73      17.413  25.455   2.129  1.00  0.23           O  
ATOM   1063  CB  ASP A  73      17.668  22.705   1.259  1.00  0.26           C  
ATOM   1064  CG  ASP A  73      18.814  22.849   0.278  1.00  0.47           C  
ATOM   1065  OD1 ASP A  73      19.659  21.933   0.214  1.00  0.79           O  
ATOM   1066  OD2 ASP A  73      18.864  23.879  -0.426  1.00  0.56           O  
ATOM   1067  H   ASP A  73      16.301  22.176   3.334  1.00  0.19           H  
ATOM   1068  HA  ASP A  73      18.949  22.714   2.971  1.00  0.24           H  
ATOM   1069  HB2 ASP A  73      17.387  21.663   1.310  1.00  0.50           H  
ATOM   1070  HB3 ASP A  73      16.830  23.279   0.893  1.00  0.52           H  
ATOM   1071  N   ASP A  74      19.390  25.147   3.166  1.00  0.25           N  
ATOM   1072  CA  ASP A  74      19.740  26.568   3.195  1.00  0.29           C  
ATOM   1073  C   ASP A  74      18.640  27.410   3.842  1.00  0.25           C  
ATOM   1074  O   ASP A  74      18.504  28.599   3.552  1.00  0.29           O  
ATOM   1075  CB  ASP A  74      20.017  27.073   1.777  1.00  0.35           C  
ATOM   1076  CG  ASP A  74      21.159  26.329   1.111  1.00  1.20           C  
ATOM   1077  OD1 ASP A  74      22.330  26.646   1.411  1.00  1.34           O  
ATOM   1078  OD2 ASP A  74      20.883  25.429   0.290  1.00  2.01           O  
ATOM   1079  H   ASP A  74      20.013  24.497   3.554  1.00  0.27           H  
ATOM   1080  HA  ASP A  74      20.641  26.671   3.781  1.00  0.34           H  
ATOM   1081  HB2 ASP A  74      19.129  26.944   1.176  1.00  0.78           H  
ATOM   1082  HB3 ASP A  74      20.270  28.123   1.818  1.00  0.86           H  
ATOM   1083  N   VAL A  75      17.862  26.787   4.721  1.00  0.27           N  
ATOM   1084  CA  VAL A  75      16.776  27.472   5.413  1.00  0.27           C  
ATOM   1085  C   VAL A  75      16.657  26.976   6.853  1.00  0.37           C  
ATOM   1086  O   VAL A  75      17.013  25.839   7.157  1.00  0.79           O  
ATOM   1087  CB  VAL A  75      15.425  27.268   4.691  1.00  0.36           C  
ATOM   1088  CG1 VAL A  75      14.304  27.995   5.418  1.00  0.40           C  
ATOM   1089  CG2 VAL A  75      15.512  27.733   3.246  1.00  0.41           C  
ATOM   1090  H   VAL A  75      18.024  25.842   4.909  1.00  0.34           H  
ATOM   1091  HA  VAL A  75      17.001  28.528   5.424  1.00  0.24           H  
ATOM   1092  HB  VAL A  75      15.197  26.212   4.693  1.00  0.44           H  
ATOM   1093 HG11 VAL A  75      13.379  27.866   4.875  1.00  1.09           H  
ATOM   1094 HG12 VAL A  75      14.541  29.048   5.483  1.00  1.15           H  
ATOM   1095 HG13 VAL A  75      14.196  27.590   6.414  1.00  0.95           H  
ATOM   1096 HG21 VAL A  75      16.300  27.196   2.741  1.00  1.11           H  
ATOM   1097 HG22 VAL A  75      15.726  28.792   3.222  1.00  1.07           H  
ATOM   1098 HG23 VAL A  75      14.571  27.545   2.751  1.00  1.10           H  
ATOM   1099  N   ASN A  76      16.161  27.838   7.735  1.00  0.30           N  
ATOM   1100  CA  ASN A  76      15.993  27.485   9.140  1.00  0.37           C  
ATOM   1101  C   ASN A  76      14.531  27.620   9.559  1.00  0.42           C  
ATOM   1102  O   ASN A  76      13.895  28.641   9.299  1.00  0.58           O  
ATOM   1103  CB  ASN A  76      16.878  28.374  10.017  1.00  0.46           C  
ATOM   1104  CG  ASN A  76      16.606  28.183  11.497  1.00  1.35           C  
ATOM   1105  OD1 ASN A  76      17.220  27.338  12.148  1.00  2.24           O  
ATOM   1106  ND2 ASN A  76      15.682  28.971  12.035  1.00  2.08           N  
ATOM   1107  H   ASN A  76      15.902  28.733   7.432  1.00  0.54           H  
ATOM   1108  HA  ASN A  76      16.297  26.457   9.261  1.00  0.38           H  
ATOM   1109  HB2 ASN A  76      17.915  28.138   9.827  1.00  1.11           H  
ATOM   1110  HB3 ASN A  76      16.697  29.408   9.766  1.00  1.24           H  
ATOM   1111 HD21 ASN A  76      15.234  29.622  11.454  1.00  2.23           H  
ATOM   1112 HD22 ASN A  76      15.488  28.872  12.990  1.00  2.85           H  
ATOM   1113  N   VAL A  77      14.005  26.586  10.214  1.00  0.35           N  
ATOM   1114  CA  VAL A  77      12.615  26.591  10.659  1.00  0.43           C  
ATOM   1115  C   VAL A  77      12.517  26.689  12.178  1.00  0.53           C  
ATOM   1116  O   VAL A  77      11.475  26.393  12.762  1.00  0.67           O  
ATOM   1117  CB  VAL A  77      11.870  25.326  10.193  1.00  0.47           C  
ATOM   1118  CG1 VAL A  77      11.887  25.222   8.677  1.00  0.45           C  
ATOM   1119  CG2 VAL A  77      12.477  24.084  10.825  1.00  0.53           C  
ATOM   1120  H   VAL A  77      14.566  25.803  10.403  1.00  0.30           H  
ATOM   1121  HA  VAL A  77      12.130  27.451  10.222  1.00  0.44           H  
ATOM   1122  HB  VAL A  77      10.841  25.401  10.514  1.00  0.52           H  
ATOM   1123 HG11 VAL A  77      11.426  24.293   8.375  1.00  1.15           H  
ATOM   1124 HG12 VAL A  77      12.906  25.249   8.325  1.00  1.12           H  
ATOM   1125 HG13 VAL A  77      11.337  26.049   8.252  1.00  1.08           H  
ATOM   1126 HG21 VAL A  77      11.930  23.212  10.500  1.00  1.17           H  
ATOM   1127 HG22 VAL A  77      12.418  24.163  11.901  1.00  1.26           H  
ATOM   1128 HG23 VAL A  77      13.510  23.996  10.526  1.00  0.96           H  
ATOM   1129  N   GLN A  78      13.607  27.105  12.812  1.00  0.59           N  
ATOM   1130  CA  GLN A  78      13.638  27.238  14.262  1.00  0.72           C  
ATOM   1131  C   GLN A  78      13.105  28.600  14.700  1.00  0.61           C  
ATOM   1132  O   GLN A  78      13.503  29.127  15.740  1.00  0.80           O  
ATOM   1133  CB  GLN A  78      15.064  27.041  14.781  1.00  0.93           C  
ATOM   1134  CG  GLN A  78      15.642  25.672  14.463  1.00  0.62           C  
ATOM   1135  CD  GLN A  78      14.819  24.539  15.048  1.00  0.53           C  
ATOM   1136  OE1 GLN A  78      13.896  24.033  14.411  1.00  1.39           O  
ATOM   1137  NE2 GLN A  78      15.151  24.135  16.270  1.00  1.05           N  
ATOM   1138  H   GLN A  78      14.408  27.326  12.293  1.00  0.61           H  
ATOM   1139  HA  GLN A  78      13.006  26.468  14.678  1.00  0.80           H  
ATOM   1140  HB2 GLN A  78      15.703  27.789  14.336  1.00  1.40           H  
ATOM   1141  HB3 GLN A  78      15.067  27.169  15.853  1.00  1.29           H  
ATOM   1142  HG2 GLN A  78      15.676  25.550  13.391  1.00  0.70           H  
ATOM   1143  HG3 GLN A  78      16.643  25.615  14.864  1.00  1.05           H  
ATOM   1144 HE21 GLN A  78      15.897  24.585  16.720  1.00  1.74           H  
ATOM   1145 HE22 GLN A  78      14.636  23.405  16.671  1.00  1.17           H  
ATOM   1146  N   GLY A  79      12.202  29.163  13.902  1.00  0.48           N  
ATOM   1147  CA  GLY A  79      11.634  30.458  14.229  1.00  0.48           C  
ATOM   1148  C   GLY A  79      10.595  30.919  13.225  1.00  0.41           C  
ATOM   1149  O   GLY A  79      10.280  32.107  13.153  1.00  0.55           O  
ATOM   1150  H   GLY A  79      11.921  28.698  13.087  1.00  0.55           H  
ATOM   1151  HA2 GLY A  79      11.169  30.397  15.204  1.00  0.51           H  
ATOM   1152  HA3 GLY A  79      12.428  31.188  14.268  1.00  0.58           H  
ATOM   1153  N   MET A  80      10.061  29.983  12.445  1.00  0.32           N  
ATOM   1154  CA  MET A  80       9.051  30.309  11.442  1.00  0.33           C  
ATOM   1155  C   MET A  80       7.741  29.587  11.740  1.00  0.30           C  
ATOM   1156  O   MET A  80       7.741  28.465  12.246  1.00  0.34           O  
ATOM   1157  CB  MET A  80       9.545  29.938  10.044  1.00  0.39           C  
ATOM   1158  CG  MET A  80      10.887  30.560   9.686  1.00  0.46           C  
ATOM   1159  SD  MET A  80      11.295  30.379   7.938  1.00  0.52           S  
ATOM   1160  CE  MET A  80      11.175  28.603   7.736  1.00  0.48           C  
ATOM   1161  H   MET A  80      10.350  29.051  12.547  1.00  0.36           H  
ATOM   1162  HA  MET A  80       8.878  31.374  11.483  1.00  0.39           H  
ATOM   1163  HB2 MET A  80       9.643  28.864   9.981  1.00  0.39           H  
ATOM   1164  HB3 MET A  80       8.816  30.267   9.318  1.00  0.45           H  
ATOM   1165  HG2 MET A  80      10.854  31.613   9.924  1.00  0.52           H  
ATOM   1166  HG3 MET A  80      11.658  30.084  10.273  1.00  0.47           H  
ATOM   1167  HE1 MET A  80      11.439  28.337   6.724  1.00  1.06           H  
ATOM   1168  HE2 MET A  80      10.161  28.285   7.939  1.00  1.12           H  
ATOM   1169  HE3 MET A  80      11.848  28.116   8.426  1.00  1.09           H  
ATOM   1170  N   ALA A  81       6.626  30.241  11.424  1.00  0.29           N  
ATOM   1171  CA  ALA A  81       5.309  29.664  11.659  1.00  0.31           C  
ATOM   1172  C   ALA A  81       5.119  28.382  10.853  1.00  0.26           C  
ATOM   1173  O   ALA A  81       5.771  28.186   9.829  1.00  0.23           O  
ATOM   1174  CB  ALA A  81       4.221  30.671  11.317  1.00  0.39           C  
ATOM   1175  H   ALA A  81       6.693  31.131  11.022  1.00  0.31           H  
ATOM   1176  HA  ALA A  81       5.230  29.429  12.711  1.00  0.38           H  
ATOM   1177  HB1 ALA A  81       4.239  30.874  10.256  1.00  1.12           H  
ATOM   1178  HB2 ALA A  81       4.395  31.588  11.862  1.00  1.10           H  
ATOM   1179  HB3 ALA A  81       3.257  30.267  11.590  1.00  1.06           H  
ATOM   1180  N   GLN A  82       4.226  27.516  11.321  1.00  0.33           N  
ATOM   1181  CA  GLN A  82       3.958  26.248  10.646  1.00  0.35           C  
ATOM   1182  C   GLN A  82       3.657  26.465   9.165  1.00  0.31           C  
ATOM   1183  O   GLN A  82       4.340  25.921   8.296  1.00  0.31           O  
ATOM   1184  CB  GLN A  82       2.787  25.527  11.319  1.00  0.42           C  
ATOM   1185  CG  GLN A  82       2.455  24.181  10.693  1.00  0.51           C  
ATOM   1186  CD  GLN A  82       1.307  23.479  11.393  1.00  0.76           C  
ATOM   1187  OE1 GLN A  82       0.143  23.668  11.043  1.00  1.52           O  
ATOM   1188  NE2 GLN A  82       1.631  22.661  12.388  1.00  0.74           N  
ATOM   1189  H   GLN A  82       3.731  27.732  12.139  1.00  0.40           H  
ATOM   1190  HA  GLN A  82       4.842  25.635  10.733  1.00  0.37           H  
ATOM   1191  HB2 GLN A  82       3.031  25.363  12.359  1.00  0.48           H  
ATOM   1192  HB3 GLN A  82       1.910  26.154  11.258  1.00  0.40           H  
ATOM   1193  HG2 GLN A  82       2.184  24.336   9.660  1.00  0.68           H  
ATOM   1194  HG3 GLN A  82       3.330  23.550  10.744  1.00  0.73           H  
ATOM   1195 HE21 GLN A  82       2.581  22.557  12.612  1.00  1.02           H  
ATOM   1196 HE22 GLN A  82       0.910  22.194  12.858  1.00  0.99           H  
ATOM   1197  N   SER A  83       2.635  27.270   8.887  1.00  0.32           N  
ATOM   1198  CA  SER A  83       2.236  27.563   7.514  1.00  0.35           C  
ATOM   1199  C   SER A  83       3.409  28.098   6.698  1.00  0.30           C  
ATOM   1200  O   SER A  83       3.552  27.777   5.518  1.00  0.35           O  
ATOM   1201  CB  SER A  83       1.089  28.577   7.505  1.00  0.44           C  
ATOM   1202  OG  SER A  83       0.693  28.890   6.182  1.00  1.48           O  
ATOM   1203  H   SER A  83       2.136  27.677   9.626  1.00  0.35           H  
ATOM   1204  HA  SER A  83       1.892  26.643   7.067  1.00  0.40           H  
ATOM   1205  HB2 SER A  83       0.242  28.162   8.031  1.00  1.17           H  
ATOM   1206  HB3 SER A  83       1.409  29.484   7.996  1.00  0.98           H  
ATOM   1207  HG  SER A  83       1.328  28.526   5.562  1.00  2.03           H  
ATOM   1208  N   ASP A  84       4.246  28.914   7.332  1.00  0.24           N  
ATOM   1209  CA  ASP A  84       5.406  29.491   6.663  1.00  0.24           C  
ATOM   1210  C   ASP A  84       6.353  28.397   6.180  1.00  0.20           C  
ATOM   1211  O   ASP A  84       6.836  28.435   5.048  1.00  0.24           O  
ATOM   1212  CB  ASP A  84       6.147  30.444   7.604  1.00  0.27           C  
ATOM   1213  CG  ASP A  84       7.339  31.103   6.940  1.00  1.03           C  
ATOM   1214  OD1 ASP A  84       8.408  30.463   6.870  1.00  2.12           O  
ATOM   1215  OD2 ASP A  84       7.203  32.260   6.490  1.00  0.97           O  
ATOM   1216  H   ASP A  84       4.078  29.134   8.273  1.00  0.25           H  
ATOM   1217  HA  ASP A  84       5.053  30.047   5.808  1.00  0.28           H  
ATOM   1218  HB2 ASP A  84       5.467  31.218   7.930  1.00  0.94           H  
ATOM   1219  HB3 ASP A  84       6.496  29.892   8.464  1.00  0.88           H  
ATOM   1220  N   VAL A  85       6.617  27.424   7.048  1.00  0.19           N  
ATOM   1221  CA  VAL A  85       7.502  26.317   6.708  1.00  0.22           C  
ATOM   1222  C   VAL A  85       6.964  25.543   5.508  1.00  0.21           C  
ATOM   1223  O   VAL A  85       7.730  25.041   4.686  1.00  0.24           O  
ATOM   1224  CB  VAL A  85       7.682  25.351   7.896  1.00  0.27           C  
ATOM   1225  CG1 VAL A  85       8.677  24.255   7.549  1.00  0.32           C  
ATOM   1226  CG2 VAL A  85       8.124  26.109   9.137  1.00  0.30           C  
ATOM   1227  H   VAL A  85       6.203  27.450   7.936  1.00  0.20           H  
ATOM   1228  HA  VAL A  85       8.468  26.730   6.455  1.00  0.25           H  
ATOM   1229  HB  VAL A  85       6.728  24.887   8.104  1.00  0.28           H  
ATOM   1230 HG11 VAL A  85       8.810  23.607   8.403  1.00  1.05           H  
ATOM   1231 HG12 VAL A  85       9.625  24.699   7.284  1.00  1.05           H  
ATOM   1232 HG13 VAL A  85       8.304  23.678   6.716  1.00  1.08           H  
ATOM   1233 HG21 VAL A  85       9.082  26.574   8.954  1.00  1.06           H  
ATOM   1234 HG22 VAL A  85       8.210  25.421   9.966  1.00  1.00           H  
ATOM   1235 HG23 VAL A  85       7.395  26.868   9.376  1.00  1.08           H  
ATOM   1236  N   VAL A  86       5.639  25.457   5.413  1.00  0.22           N  
ATOM   1237  CA  VAL A  86       4.999  24.750   4.312  1.00  0.25           C  
ATOM   1238  C   VAL A  86       5.299  25.441   2.986  1.00  0.24           C  
ATOM   1239  O   VAL A  86       5.612  24.786   1.991  1.00  0.26           O  
ATOM   1240  CB  VAL A  86       3.471  24.666   4.507  1.00  0.30           C  
ATOM   1241  CG1 VAL A  86       2.827  23.884   3.373  1.00  0.37           C  
ATOM   1242  CG2 VAL A  86       3.141  24.036   5.852  1.00  0.34           C  
ATOM   1243  H   VAL A  86       5.081  25.878   6.099  1.00  0.24           H  
ATOM   1244  HA  VAL A  86       5.395  23.747   4.283  1.00  0.28           H  
ATOM   1245  HB  VAL A  86       3.071  25.669   4.496  1.00  0.30           H  
ATOM   1246 HG11 VAL A  86       3.246  22.890   3.335  1.00  1.06           H  
ATOM   1247 HG12 VAL A  86       3.012  24.389   2.438  1.00  1.02           H  
ATOM   1248 HG13 VAL A  86       1.761  23.818   3.541  1.00  1.07           H  
ATOM   1249 HG21 VAL A  86       3.555  24.639   6.645  1.00  1.00           H  
ATOM   1250 HG22 VAL A  86       3.562  23.043   5.896  1.00  1.07           H  
ATOM   1251 HG23 VAL A  86       2.068  23.977   5.968  1.00  0.98           H  
ATOM   1252  N   GLU A  87       5.206  26.769   2.982  1.00  0.25           N  
ATOM   1253  CA  GLU A  87       5.475  27.550   1.780  1.00  0.26           C  
ATOM   1254  C   GLU A  87       6.887  27.287   1.272  1.00  0.24           C  
ATOM   1255  O   GLU A  87       7.111  27.153   0.070  1.00  0.26           O  
ATOM   1256  CB  GLU A  87       5.291  29.043   2.061  1.00  0.32           C  
ATOM   1257  CG  GLU A  87       3.865  29.426   2.414  1.00  0.75           C  
ATOM   1258  CD  GLU A  87       3.709  30.910   2.683  1.00  1.04           C  
ATOM   1259  OE1 GLU A  87       3.500  31.671   1.713  1.00  1.19           O  
ATOM   1260  OE2 GLU A  87       3.797  31.311   3.861  1.00  1.51           O  
ATOM   1261  H   GLU A  87       4.953  27.233   3.807  1.00  0.28           H  
ATOM   1262  HA  GLU A  87       4.769  27.245   1.022  1.00  0.29           H  
ATOM   1263  HB2 GLU A  87       5.931  29.324   2.887  1.00  0.80           H  
ATOM   1264  HB3 GLU A  87       5.586  29.602   1.185  1.00  0.67           H  
ATOM   1265  HG2 GLU A  87       3.219  29.154   1.591  1.00  1.16           H  
ATOM   1266  HG3 GLU A  87       3.568  28.881   3.298  1.00  1.34           H  
ATOM   1267  N   VAL A  88       7.836  27.215   2.202  1.00  0.22           N  
ATOM   1268  CA  VAL A  88       9.230  26.961   1.857  1.00  0.22           C  
ATOM   1269  C   VAL A  88       9.373  25.659   1.076  1.00  0.23           C  
ATOM   1270  O   VAL A  88       9.969  25.631  -0.002  1.00  0.25           O  
ATOM   1271  CB  VAL A  88      10.114  26.892   3.117  1.00  0.24           C  
ATOM   1272  CG1 VAL A  88      11.498  26.352   2.778  1.00  0.26           C  
ATOM   1273  CG2 VAL A  88      10.215  28.260   3.775  1.00  0.27           C  
ATOM   1274  H   VAL A  88       7.594  27.340   3.144  1.00  0.24           H  
ATOM   1275  HA  VAL A  88       9.577  27.778   1.240  1.00  0.24           H  
ATOM   1276  HB  VAL A  88       9.652  26.213   3.819  1.00  0.24           H  
ATOM   1277 HG11 VAL A  88      11.410  25.332   2.430  1.00  1.00           H  
ATOM   1278 HG12 VAL A  88      12.121  26.379   3.660  1.00  0.99           H  
ATOM   1279 HG13 VAL A  88      11.941  26.959   2.004  1.00  1.01           H  
ATOM   1280 HG21 VAL A  88      10.838  28.193   4.655  1.00  1.06           H  
ATOM   1281 HG22 VAL A  88       9.229  28.597   4.055  1.00  1.04           H  
ATOM   1282 HG23 VAL A  88      10.651  28.962   3.079  1.00  1.03           H  
ATOM   1283  N   LEU A  89       8.823  24.583   1.631  1.00  0.24           N  
ATOM   1284  CA  LEU A  89       8.892  23.274   0.993  1.00  0.28           C  
ATOM   1285  C   LEU A  89       8.353  23.333  -0.432  1.00  0.32           C  
ATOM   1286  O   LEU A  89       8.861  22.656  -1.326  1.00  0.39           O  
ATOM   1287  CB  LEU A  89       8.102  22.247   1.807  1.00  0.32           C  
ATOM   1288  CG  LEU A  89       8.564  22.074   3.256  1.00  0.34           C  
ATOM   1289  CD1 LEU A  89       7.597  21.187   4.023  1.00  0.41           C  
ATOM   1290  CD2 LEU A  89       9.970  21.495   3.302  1.00  0.35           C  
ATOM   1291  H   LEU A  89       8.360  24.672   2.491  1.00  0.24           H  
ATOM   1292  HA  LEU A  89       9.932  22.978   0.965  1.00  0.28           H  
ATOM   1293  HB2 LEU A  89       7.065  22.546   1.814  1.00  0.35           H  
ATOM   1294  HB3 LEU A  89       8.180  21.290   1.312  1.00  0.35           H  
ATOM   1295  HG  LEU A  89       8.583  23.041   3.738  1.00  0.34           H  
ATOM   1296 HD11 LEU A  89       6.616  21.641   4.025  1.00  1.14           H  
ATOM   1297 HD12 LEU A  89       7.943  21.071   5.039  1.00  1.09           H  
ATOM   1298 HD13 LEU A  89       7.543  20.218   3.548  1.00  1.03           H  
ATOM   1299 HD21 LEU A  89       9.980  20.533   2.809  1.00  1.04           H  
ATOM   1300 HD22 LEU A  89      10.277  21.373   4.331  1.00  0.98           H  
ATOM   1301 HD23 LEU A  89      10.653  22.163   2.799  1.00  1.09           H  
ATOM   1302  N   ARG A  90       7.323  24.148  -0.636  1.00  0.31           N  
ATOM   1303  CA  ARG A  90       6.715  24.298  -1.953  1.00  0.37           C  
ATOM   1304  C   ARG A  90       7.597  25.143  -2.865  1.00  0.37           C  
ATOM   1305  O   ARG A  90       7.603  24.962  -4.083  1.00  0.48           O  
ATOM   1306  CB  ARG A  90       5.332  24.940  -1.828  1.00  0.41           C  
ATOM   1307  CG  ARG A  90       4.393  24.184  -0.904  1.00  0.49           C  
ATOM   1308  CD  ARG A  90       3.054  24.889  -0.776  1.00  0.72           C  
ATOM   1309  NE  ARG A  90       2.205  24.271   0.239  1.00  1.00           N  
ATOM   1310  CZ  ARG A  90       0.876  24.316   0.217  1.00  1.59           C  
ATOM   1311  NH1 ARG A  90       0.248  24.947  -0.767  1.00  1.82           N  
ATOM   1312  NH2 ARG A  90       0.175  23.732   1.178  1.00  2.10           N  
ATOM   1313  H   ARG A  90       6.960  24.657   0.120  1.00  0.28           H  
ATOM   1314  HA  ARG A  90       6.607  23.314  -2.384  1.00  0.40           H  
ATOM   1315  HB2 ARG A  90       5.446  25.943  -1.447  1.00  0.55           H  
ATOM   1316  HB3 ARG A  90       4.879  24.986  -2.807  1.00  0.45           H  
ATOM   1317  HG2 ARG A  90       4.232  23.193  -1.303  1.00  0.73           H  
ATOM   1318  HG3 ARG A  90       4.848  24.109   0.072  1.00  0.84           H  
ATOM   1319  HD2 ARG A  90       3.229  25.919  -0.505  1.00  0.95           H  
ATOM   1320  HD3 ARG A  90       2.548  24.848  -1.729  1.00  1.16           H  
ATOM   1321  HE  ARG A  90       2.648  23.799   0.976  1.00  0.98           H  
ATOM   1322 HH11 ARG A  90       0.772  25.389  -1.495  1.00  1.62           H  
ATOM   1323 HH12 ARG A  90      -0.752  24.981  -0.780  1.00  2.29           H  
ATOM   1324 HH21 ARG A  90       0.645  23.256   1.922  1.00  2.08           H  
ATOM   1325 HH22 ARG A  90      -0.824  23.768   1.159  1.00  2.56           H  
ATOM   1326  N   ASN A  91       8.341  26.066  -2.267  1.00  0.32           N  
ATOM   1327  CA  ASN A  91       9.229  26.942  -3.022  1.00  0.36           C  
ATOM   1328  C   ASN A  91      10.473  26.191  -3.486  1.00  0.36           C  
ATOM   1329  O   ASN A  91      11.175  26.635  -4.393  1.00  0.42           O  
ATOM   1330  CB  ASN A  91       9.632  28.149  -2.175  1.00  0.38           C  
ATOM   1331  CG  ASN A  91       8.443  28.999  -1.775  1.00  0.44           C  
ATOM   1332  OD1 ASN A  91       7.445  29.066  -2.492  1.00  1.11           O  
ATOM   1333  ND2 ASN A  91       8.543  29.655  -0.624  1.00  1.14           N  
ATOM   1334  H   ASN A  91       8.294  26.163  -1.293  1.00  0.33           H  
ATOM   1335  HA  ASN A  91       8.689  27.290  -3.892  1.00  0.42           H  
ATOM   1336  HB2 ASN A  91      10.120  27.801  -1.276  1.00  0.37           H  
ATOM   1337  HB3 ASN A  91      10.320  28.764  -2.739  1.00  0.43           H  
ATOM   1338 HD21 ASN A  91       9.368  29.556  -0.105  1.00  1.81           H  
ATOM   1339 HD22 ASN A  91       7.787  30.211  -0.341  1.00  1.19           H  
ATOM   1340  N   ALA A  92      10.738  25.050  -2.852  1.00  0.32           N  
ATOM   1341  CA  ALA A  92      11.897  24.232  -3.195  1.00  0.34           C  
ATOM   1342  C   ALA A  92      11.932  23.913  -4.689  1.00  0.46           C  
ATOM   1343  O   ALA A  92      12.618  24.588  -5.457  1.00  0.55           O  
ATOM   1344  CB  ALA A  92      11.894  22.948  -2.379  1.00  0.32           C  
ATOM   1345  H   ALA A  92      10.144  24.754  -2.131  1.00  0.30           H  
ATOM   1346  HA  ALA A  92      12.784  24.791  -2.937  1.00  0.36           H  
ATOM   1347  HB1 ALA A  92      12.779  22.374  -2.610  1.00  1.05           H  
ATOM   1348  HB2 ALA A  92      11.015  22.370  -2.623  1.00  1.04           H  
ATOM   1349  HB3 ALA A  92      11.884  23.190  -1.327  1.00  1.11           H  
ATOM   1350  N   GLY A  93      11.191  22.887  -5.095  1.00  0.53           N  
ATOM   1351  CA  GLY A  93      11.169  22.504  -6.496  1.00  0.68           C  
ATOM   1352  C   GLY A  93      12.513  21.990  -6.974  1.00  0.66           C  
ATOM   1353  O   GLY A  93      12.736  21.828  -8.173  1.00  0.76           O  
ATOM   1354  H   GLY A  93      10.657  22.391  -4.443  1.00  0.52           H  
ATOM   1355  HA2 GLY A  93      10.429  21.728  -6.634  1.00  0.76           H  
ATOM   1356  HA3 GLY A  93      10.892  23.362  -7.090  1.00  0.77           H  
ATOM   1357  N   ASN A  94      13.412  21.736  -6.029  1.00  0.54           N  
ATOM   1358  CA  ASN A  94      14.748  21.243  -6.345  1.00  0.54           C  
ATOM   1359  C   ASN A  94      15.249  20.304  -5.244  1.00  0.43           C  
ATOM   1360  O   ASN A  94      14.656  20.240  -4.166  1.00  0.39           O  
ATOM   1361  CB  ASN A  94      15.713  22.422  -6.500  1.00  0.59           C  
ATOM   1362  CG  ASN A  94      15.862  23.208  -5.214  1.00  1.57           C  
ATOM   1363  OD1 ASN A  94      15.224  24.244  -5.027  1.00  1.93           O  
ATOM   1364  ND2 ASN A  94      16.702  22.713  -4.313  1.00  2.52           N  
ATOM   1365  H   ASN A  94      13.170  21.885  -5.090  1.00  0.48           H  
ATOM   1366  HA  ASN A  94      14.695  20.700  -7.277  1.00  0.62           H  
ATOM   1367  HB2 ASN A  94      16.684  22.052  -6.789  1.00  1.09           H  
ATOM   1368  HB3 ASN A  94      15.341  23.085  -7.266  1.00  0.97           H  
ATOM   1369 HD21 ASN A  94      17.173  21.881  -4.528  1.00  2.53           H  
ATOM   1370 HD22 ASN A  94      16.810  23.194  -3.468  1.00  3.33           H  
ATOM   1371  N   PRO A  95      16.333  19.543  -5.503  1.00  0.41           N  
ATOM   1372  CA  PRO A  95      16.907  18.632  -4.505  1.00  0.35           C  
ATOM   1373  C   PRO A  95      17.290  19.376  -3.228  1.00  0.32           C  
ATOM   1374  O   PRO A  95      18.292  20.088  -3.192  1.00  0.45           O  
ATOM   1375  CB  PRO A  95      18.157  18.075  -5.194  1.00  0.44           C  
ATOM   1376  CG  PRO A  95      17.901  18.248  -6.652  1.00  0.64           C  
ATOM   1377  CD  PRO A  95      17.068  19.492  -6.782  1.00  0.51           C  
ATOM   1378  HA  PRO A  95      16.231  17.828  -4.266  1.00  0.33           H  
ATOM   1379  HB2 PRO A  95      19.024  18.634  -4.878  1.00  0.57           H  
ATOM   1380  HB3 PRO A  95      18.281  17.034  -4.937  1.00  0.49           H  
ATOM   1381  HG2 PRO A  95      18.837  18.367  -7.177  1.00  0.92           H  
ATOM   1382  HG3 PRO A  95      17.360  17.393  -7.033  1.00  0.89           H  
ATOM   1383  HD2 PRO A  95      17.701  20.359  -6.898  1.00  0.57           H  
ATOM   1384  HD3 PRO A  95      16.387  19.404  -7.614  1.00  0.61           H  
ATOM   1385  N   VAL A  96      16.488  19.205  -2.180  1.00  0.28           N  
ATOM   1386  CA  VAL A  96      16.737  19.882  -0.913  1.00  0.33           C  
ATOM   1387  C   VAL A  96      17.249  18.923   0.156  1.00  0.28           C  
ATOM   1388  O   VAL A  96      16.991  17.721   0.111  1.00  0.30           O  
ATOM   1389  CB  VAL A  96      15.464  20.576  -0.391  1.00  0.41           C  
ATOM   1390  CG1 VAL A  96      15.078  21.734  -1.294  1.00  0.64           C  
ATOM   1391  CG2 VAL A  96      14.320  19.580  -0.272  1.00  0.38           C  
ATOM   1392  H   VAL A  96      15.715  18.605  -2.260  1.00  0.31           H  
ATOM   1393  HA  VAL A  96      17.486  20.641  -1.086  1.00  0.43           H  
ATOM   1394  HB  VAL A  96      15.673  20.972   0.593  1.00  0.65           H  
ATOM   1395 HG11 VAL A  96      14.917  21.369  -2.298  1.00  1.30           H  
ATOM   1396 HG12 VAL A  96      15.871  22.467  -1.302  1.00  1.09           H  
ATOM   1397 HG13 VAL A  96      14.170  22.189  -0.927  1.00  1.32           H  
ATOM   1398 HG21 VAL A  96      13.442  20.083   0.104  1.00  1.09           H  
ATOM   1399 HG22 VAL A  96      14.601  18.789   0.408  1.00  1.12           H  
ATOM   1400 HG23 VAL A  96      14.106  19.159  -1.243  1.00  0.98           H  
ATOM   1401  N   ARG A  97      17.980  19.475   1.118  1.00  0.24           N  
ATOM   1402  CA  ARG A  97      18.532  18.697   2.215  1.00  0.22           C  
ATOM   1403  C   ARG A  97      17.713  18.927   3.478  1.00  0.18           C  
ATOM   1404  O   ARG A  97      17.243  20.041   3.731  1.00  0.18           O  
ATOM   1405  CB  ARG A  97      19.993  19.086   2.455  1.00  0.27           C  
ATOM   1406  CG  ARG A  97      20.668  18.286   3.557  1.00  0.69           C  
ATOM   1407  CD  ARG A  97      22.114  18.715   3.749  1.00  0.71           C  
ATOM   1408  NE  ARG A  97      22.773  17.960   4.810  1.00  1.21           N  
ATOM   1409  CZ  ARG A  97      24.026  18.176   5.201  1.00  1.38           C  
ATOM   1410  NH1 ARG A  97      24.755  19.115   4.616  1.00  0.88           N  
ATOM   1411  NH2 ARG A  97      24.552  17.450   6.178  1.00  2.37           N  
ATOM   1412  H   ARG A  97      18.152  20.434   1.090  1.00  0.27           H  
ATOM   1413  HA  ARG A  97      18.480  17.652   1.945  1.00  0.23           H  
ATOM   1414  HB2 ARG A  97      20.547  18.935   1.540  1.00  0.59           H  
ATOM   1415  HB3 ARG A  97      20.035  20.132   2.722  1.00  0.56           H  
ATOM   1416  HG2 ARG A  97      20.131  18.441   4.481  1.00  1.00           H  
ATOM   1417  HG3 ARG A  97      20.643  17.238   3.295  1.00  1.02           H  
ATOM   1418  HD2 ARG A  97      22.648  18.556   2.824  1.00  1.30           H  
ATOM   1419  HD3 ARG A  97      22.134  19.764   4.001  1.00  1.12           H  
ATOM   1420  HE  ARG A  97      22.255  17.257   5.256  1.00  1.81           H  
ATOM   1421 HH11 ARG A  97      24.363  19.664   3.878  1.00  1.02           H  
ATOM   1422 HH12 ARG A  97      25.697  19.276   4.914  1.00  1.01           H  
ATOM   1423 HH21 ARG A  97      24.006  16.739   6.622  1.00  3.02           H  
ATOM   1424 HH22 ARG A  97      25.495  17.612   6.469  1.00  2.51           H  
ATOM   1425  N   LEU A  98      17.542  17.873   4.267  1.00  0.19           N  
ATOM   1426  CA  LEU A  98      16.770  17.963   5.498  1.00  0.18           C  
ATOM   1427  C   LEU A  98      17.658  17.730   6.716  1.00  0.18           C  
ATOM   1428  O   LEU A  98      18.424  16.768   6.763  1.00  0.30           O  
ATOM   1429  CB  LEU A  98      15.635  16.936   5.482  1.00  0.23           C  
ATOM   1430  CG  LEU A  98      14.835  16.860   4.179  1.00  0.25           C  
ATOM   1431  CD1 LEU A  98      13.841  15.712   4.237  1.00  0.30           C  
ATOM   1432  CD2 LEU A  98      14.115  18.172   3.912  1.00  0.37           C  
ATOM   1433  H   LEU A  98      17.946  17.017   4.017  1.00  0.23           H  
ATOM   1434  HA  LEU A  98      16.347  18.954   5.558  1.00  0.19           H  
ATOM   1435  HB2 LEU A  98      16.061  15.963   5.674  1.00  0.33           H  
ATOM   1436  HB3 LEU A  98      14.952  17.177   6.282  1.00  0.31           H  
ATOM   1437  HG  LEU A  98      15.512  16.676   3.358  1.00  0.34           H  
ATOM   1438 HD11 LEU A  98      13.152  15.872   5.052  1.00  1.05           H  
ATOM   1439 HD12 LEU A  98      14.369  14.783   4.390  1.00  1.09           H  
ATOM   1440 HD13 LEU A  98      13.291  15.663   3.306  1.00  1.02           H  
ATOM   1441 HD21 LEU A  98      13.461  18.399   4.740  1.00  0.98           H  
ATOM   1442 HD22 LEU A  98      13.532  18.084   3.007  1.00  1.16           H  
ATOM   1443 HD23 LEU A  98      14.840  18.966   3.798  1.00  1.15           H  
ATOM   1444  N   LEU A  99      17.553  18.619   7.698  1.00  0.18           N  
ATOM   1445  CA  LEU A  99      18.337  18.504   8.921  1.00  0.19           C  
ATOM   1446  C   LEU A  99      17.416  18.400  10.131  1.00  0.19           C  
ATOM   1447  O   LEU A  99      16.894  19.403  10.616  1.00  0.21           O  
ATOM   1448  CB  LEU A  99      19.276  19.705   9.074  1.00  0.22           C  
ATOM   1449  CG  LEU A  99      20.161  19.689  10.324  1.00  0.29           C  
ATOM   1450  CD1 LEU A  99      21.114  18.503  10.293  1.00  0.37           C  
ATOM   1451  CD2 LEU A  99      20.934  20.994  10.443  1.00  0.36           C  
ATOM   1452  H   LEU A  99      16.934  19.372   7.598  1.00  0.27           H  
ATOM   1453  HA  LEU A  99      18.927  17.603   8.855  1.00  0.20           H  
ATOM   1454  HB2 LEU A  99      19.917  19.745   8.205  1.00  0.25           H  
ATOM   1455  HB3 LEU A  99      18.677  20.602   9.099  1.00  0.24           H  
ATOM   1456  HG  LEU A  99      19.535  19.590  11.199  1.00  0.31           H  
ATOM   1457 HD11 LEU A  99      21.731  18.562   9.409  1.00  1.04           H  
ATOM   1458 HD12 LEU A  99      20.546  17.584  10.276  1.00  1.07           H  
ATOM   1459 HD13 LEU A  99      21.741  18.523  11.171  1.00  1.05           H  
ATOM   1460 HD21 LEU A  99      21.550  20.966  11.330  1.00  1.05           H  
ATOM   1461 HD22 LEU A  99      20.241  21.818  10.512  1.00  1.10           H  
ATOM   1462 HD23 LEU A  99      21.561  21.121   9.574  1.00  1.09           H  
ATOM   1463  N   LEU A 100      17.218  17.176  10.610  1.00  0.22           N  
ATOM   1464  CA  LEU A 100      16.352  16.936  11.758  1.00  0.23           C  
ATOM   1465  C   LEU A 100      17.052  16.085  12.813  1.00  0.24           C  
ATOM   1466  O   LEU A 100      17.953  15.306  12.502  1.00  0.30           O  
ATOM   1467  CB  LEU A 100      15.056  16.254  11.305  1.00  0.25           C  
ATOM   1468  CG  LEU A 100      15.184  15.344  10.078  1.00  0.25           C  
ATOM   1469  CD1 LEU A 100      16.077  14.150  10.376  1.00  0.27           C  
ATOM   1470  CD2 LEU A 100      13.811  14.880   9.615  1.00  0.31           C  
ATOM   1471  H   LEU A 100      17.665  16.417  10.182  1.00  0.25           H  
ATOM   1472  HA  LEU A 100      16.109  17.892  12.193  1.00  0.24           H  
ATOM   1473  HB2 LEU A 100      14.679  15.663  12.128  1.00  0.27           H  
ATOM   1474  HB3 LEU A 100      14.332  17.024  11.079  1.00  0.27           H  
ATOM   1475  HG  LEU A 100      15.636  15.904   9.271  1.00  0.24           H  
ATOM   1476 HD11 LEU A 100      16.135  13.517   9.501  1.00  1.05           H  
ATOM   1477 HD12 LEU A 100      15.664  13.588  11.200  1.00  1.05           H  
ATOM   1478 HD13 LEU A 100      17.065  14.496  10.635  1.00  0.95           H  
ATOM   1479 HD21 LEU A 100      13.924  14.171   8.810  1.00  1.02           H  
ATOM   1480 HD22 LEU A 100      13.241  15.730   9.271  1.00  1.11           H  
ATOM   1481 HD23 LEU A 100      13.293  14.412  10.439  1.00  1.04           H  
ATOM   1482  N   ILE A 101      16.636  16.247  14.065  1.00  0.25           N  
ATOM   1483  CA  ILE A 101      17.218  15.490  15.167  1.00  0.29           C  
ATOM   1484  C   ILE A 101      16.313  14.328  15.560  1.00  0.32           C  
ATOM   1485  O   ILE A 101      15.089  14.469  15.610  1.00  0.32           O  
ATOM   1486  CB  ILE A 101      17.466  16.388  16.398  1.00  0.34           C  
ATOM   1487  CG1 ILE A 101      18.213  15.608  17.485  1.00  0.38           C  
ATOM   1488  CG2 ILE A 101      16.148  16.933  16.934  1.00  0.37           C  
ATOM   1489  CD1 ILE A 101      18.604  16.452  18.679  1.00  0.45           C  
ATOM   1490  H   ILE A 101      15.919  16.888  14.251  1.00  0.28           H  
ATOM   1491  HA  ILE A 101      18.168  15.097  14.835  1.00  0.30           H  
ATOM   1492  HB  ILE A 101      18.071  17.225  16.086  1.00  0.36           H  
ATOM   1493 HG12 ILE A 101      17.583  14.806  17.839  1.00  0.41           H  
ATOM   1494 HG13 ILE A 101      19.114  15.191  17.063  1.00  0.38           H  
ATOM   1495 HG21 ILE A 101      16.342  17.581  17.776  1.00  1.12           H  
ATOM   1496 HG22 ILE A 101      15.520  16.112  17.249  1.00  1.06           H  
ATOM   1497 HG23 ILE A 101      15.648  17.491  16.158  1.00  1.07           H  
ATOM   1498 HD11 ILE A 101      19.191  15.858  19.364  1.00  1.11           H  
ATOM   1499 HD12 ILE A 101      17.714  16.806  19.179  1.00  1.09           H  
ATOM   1500 HD13 ILE A 101      19.189  17.297  18.346  1.00  1.14           H  
ATOM   1501  N   ARG A 102      16.920  13.177  15.832  1.00  0.39           N  
ATOM   1502  CA  ARG A 102      16.165  11.990  16.219  1.00  0.46           C  
ATOM   1503  C   ARG A 102      16.748  11.362  17.479  1.00  0.60           C  
ATOM   1504  O   ARG A 102      17.960  11.184  17.594  1.00  0.81           O  
ATOM   1505  CB  ARG A 102      16.156  10.970  15.077  1.00  0.70           C  
ATOM   1506  CG  ARG A 102      15.438   9.670  15.417  1.00  1.27           C  
ATOM   1507  CD  ARG A 102      13.980   9.907  15.777  1.00  1.35           C  
ATOM   1508  NE  ARG A 102      13.268   8.656  16.020  1.00  1.49           N  
ATOM   1509  CZ  ARG A 102      12.306   8.514  16.927  1.00  1.87           C  
ATOM   1510  NH1 ARG A 102      11.940   9.543  17.679  1.00  2.26           N  
ATOM   1511  NH2 ARG A 102      11.711   7.338  17.083  1.00  2.20           N  
ATOM   1512  H   ARG A 102      17.899  13.125  15.775  1.00  0.41           H  
ATOM   1513  HA  ARG A 102      15.150  12.296  16.422  1.00  0.58           H  
ATOM   1514  HB2 ARG A 102      15.668  11.410  14.221  1.00  1.32           H  
ATOM   1515  HB3 ARG A 102      17.176  10.734  14.815  1.00  0.99           H  
ATOM   1516  HG2 ARG A 102      15.484   9.013  14.562  1.00  1.75           H  
ATOM   1517  HG3 ARG A 102      15.936   9.207  16.256  1.00  1.85           H  
ATOM   1518  HD2 ARG A 102      13.937  10.512  16.670  1.00  1.55           H  
ATOM   1519  HD3 ARG A 102      13.501  10.433  14.964  1.00  1.64           H  
ATOM   1520  HE  ARG A 102      13.520   7.880  15.476  1.00  1.62           H  
ATOM   1521 HH11 ARG A 102      12.386  10.430  17.565  1.00  2.28           H  
ATOM   1522 HH12 ARG A 102      11.216   9.431  18.360  1.00  2.70           H  
ATOM   1523 HH21 ARG A 102      11.985   6.560  16.519  1.00  2.28           H  
ATOM   1524 HH22 ARG A 102      10.988   7.233  17.765  1.00  2.56           H  
ATOM   1525  N   ARG A 103      15.873  11.027  18.421  1.00  0.73           N  
ATOM   1526  CA  ARG A 103      16.299  10.422  19.674  1.00  1.00           C  
ATOM   1527  C   ARG A 103      16.484   8.917  19.519  1.00  1.16           C  
ATOM   1528  O   ARG A 103      15.624   8.228  18.968  1.00  1.23           O  
ATOM   1529  CB  ARG A 103      15.274  10.713  20.772  1.00  1.28           C  
ATOM   1530  CG  ARG A 103      14.952  12.190  20.925  1.00  2.01           C  
ATOM   1531  CD  ARG A 103      13.962  12.429  22.054  1.00  2.24           C  
ATOM   1532  NE  ARG A 103      14.516  12.058  23.354  1.00  2.73           N  
ATOM   1533  CZ  ARG A 103      13.776  11.834  24.435  1.00  3.09           C  
ATOM   1534  NH1 ARG A 103      12.456  11.946  24.377  1.00  2.90           N  
ATOM   1535  NH2 ARG A 103      14.358  11.495  25.578  1.00  3.93           N  
ATOM   1536  H   ARG A 103      14.920  11.195  18.269  1.00  0.75           H  
ATOM   1537  HA  ARG A 103      17.244  10.863  19.950  1.00  1.00           H  
ATOM   1538  HB2 ARG A 103      14.358  10.188  20.543  1.00  1.61           H  
ATOM   1539  HB3 ARG A 103      15.659  10.350  21.715  1.00  1.67           H  
ATOM   1540  HG2 ARG A 103      15.862  12.727  21.140  1.00  2.53           H  
ATOM   1541  HG3 ARG A 103      14.526  12.553  20.003  1.00  2.47           H  
ATOM   1542  HD2 ARG A 103      13.700  13.477  22.071  1.00  2.36           H  
ATOM   1543  HD3 ARG A 103      13.076  11.839  21.869  1.00  2.57           H  
ATOM   1544  HE  ARG A 103      15.490  11.971  23.421  1.00  3.08           H  
ATOM   1545 HH11 ARG A 103      12.013  12.201  23.518  1.00  2.75           H  
ATOM   1546 HH12 ARG A 103      11.904  11.777  25.194  1.00  3.18           H  
ATOM   1547 HH21 ARG A 103      15.354  11.409  25.625  1.00  4.40           H  
ATOM   1548 HH22 ARG A 103      13.802  11.328  26.392  1.00  4.23           H  
ATOM   1549  N   LEU A 104      17.613   8.415  20.008  1.00  1.32           N  
ATOM   1550  CA  LEU A 104      17.914   6.990  19.926  1.00  1.57           C  
ATOM   1551  C   LEU A 104      17.605   6.298  21.253  1.00  1.89           C  
ATOM   1552  O   LEU A 104      17.726   6.905  22.318  1.00  2.00           O  
ATOM   1553  CB  LEU A 104      19.386   6.781  19.554  1.00  1.68           C  
ATOM   1554  CG  LEU A 104      19.850   7.524  18.297  1.00  1.43           C  
ATOM   1555  CD1 LEU A 104      21.329   7.268  18.044  1.00  1.46           C  
ATOM   1556  CD2 LEU A 104      19.023   7.108  17.089  1.00  1.55           C  
ATOM   1557  H   LEU A 104      18.259   9.015  20.433  1.00  1.30           H  
ATOM   1558  HA  LEU A 104      17.291   6.563  19.155  1.00  1.55           H  
ATOM   1559  HB2 LEU A 104      19.995   7.106  20.385  1.00  1.79           H  
ATOM   1560  HB3 LEU A 104      19.550   5.724  19.400  1.00  1.93           H  
ATOM   1561  HG  LEU A 104      19.716   8.585  18.446  1.00  1.25           H  
ATOM   1562 HD11 LEU A 104      21.900   7.575  18.908  1.00  1.69           H  
ATOM   1563 HD12 LEU A 104      21.649   7.834  17.182  1.00  1.93           H  
ATOM   1564 HD13 LEU A 104      21.487   6.215  17.863  1.00  1.64           H  
ATOM   1565 HD21 LEU A 104      19.343   7.669  16.223  1.00  1.96           H  
ATOM   1566 HD22 LEU A 104      17.980   7.308  17.281  1.00  1.95           H  
ATOM   1567 HD23 LEU A 104      19.160   6.053  16.904  1.00  1.75           H  
ATOM   1568  N   PRO A 105      17.198   5.014  21.210  1.00  2.13           N  
ATOM   1569  CA  PRO A 105      16.871   4.251  22.415  1.00  2.48           C  
ATOM   1570  C   PRO A 105      18.110   3.708  23.114  1.00  2.69           C  
ATOM   1571  O   PRO A 105      19.189   3.641  22.527  1.00  2.98           O  
ATOM   1572  CB  PRO A 105      16.017   3.109  21.871  1.00  2.64           C  
ATOM   1573  CG  PRO A 105      16.550   2.869  20.500  1.00  2.51           C  
ATOM   1574  CD  PRO A 105      17.029   4.204  19.987  1.00  2.16           C  
ATOM   1575  HA  PRO A 105      16.290   4.837  23.112  1.00  2.52           H  
ATOM   1576  HB2 PRO A 105      16.132   2.239  22.501  1.00  2.91           H  
ATOM   1577  HB3 PRO A 105      14.981   3.409  21.845  1.00  2.63           H  
ATOM   1578  HG2 PRO A 105      17.371   2.169  20.544  1.00  2.66           H  
ATOM   1579  HG3 PRO A 105      15.765   2.485  19.865  1.00  2.57           H  
ATOM   1580  HD2 PRO A 105      17.970   4.091  19.472  1.00  2.15           H  
ATOM   1581  HD3 PRO A 105      16.290   4.644  19.335  1.00  2.02           H  
ATOM   1582  N   LEU A 106      17.941   3.317  24.370  1.00  2.81           N  
ATOM   1583  CA  LEU A 106      19.039   2.778  25.166  1.00  3.01           C  
ATOM   1584  C   LEU A 106      18.628   1.471  25.836  1.00  3.44           C  
ATOM   1585  O   LEU A 106      18.054   1.473  26.925  1.00  3.67           O  
ATOM   1586  CB  LEU A 106      19.473   3.797  26.221  1.00  2.96           C  
ATOM   1587  CG  LEU A 106      19.929   5.152  25.670  1.00  2.78           C  
ATOM   1588  CD1 LEU A 106      20.189   6.128  26.806  1.00  2.74           C  
ATOM   1589  CD2 LEU A 106      21.175   4.987  24.810  1.00  3.01           C  
ATOM   1590  H   LEU A 106      17.051   3.388  24.774  1.00  2.96           H  
ATOM   1591  HA  LEU A 106      19.867   2.584  24.501  1.00  3.03           H  
ATOM   1592  HB2 LEU A 106      18.640   3.967  26.890  1.00  3.07           H  
ATOM   1593  HB3 LEU A 106      20.288   3.373  26.789  1.00  3.13           H  
ATOM   1594  HG  LEU A 106      19.145   5.563  25.049  1.00  2.82           H  
ATOM   1595 HD11 LEU A 106      19.280   6.273  27.372  1.00  2.90           H  
ATOM   1596 HD12 LEU A 106      20.514   7.075  26.398  1.00  2.95           H  
ATOM   1597 HD13 LEU A 106      20.958   5.733  27.453  1.00  2.98           H  
ATOM   1598 HD21 LEU A 106      20.952   4.342  23.973  1.00  3.25           H  
ATOM   1599 HD22 LEU A 106      21.965   4.548  25.401  1.00  3.17           H  
ATOM   1600 HD23 LEU A 106      21.492   5.954  24.447  1.00  3.37           H  
ATOM   1601  N   LEU A 107      18.926   0.355  25.175  1.00  3.72           N  
ATOM   1602  CA  LEU A 107      18.582  -0.960  25.700  1.00  4.24           C  
ATOM   1603  C   LEU A 107      19.735  -1.552  26.507  1.00  4.27           C  
ATOM   1604  O   LEU A 107      20.853  -1.678  26.007  1.00  4.13           O  
ATOM   1605  CB  LEU A 107      18.206  -1.900  24.555  1.00  4.67           C  
ATOM   1606  CG  LEU A 107      17.077  -1.399  23.651  1.00  4.91           C  
ATOM   1607  CD1 LEU A 107      16.789  -2.410  22.554  1.00  5.59           C  
ATOM   1608  CD2 LEU A 107      15.819  -1.123  24.464  1.00  4.58           C  
ATOM   1609  H   LEU A 107      19.388   0.420  24.314  1.00  3.68           H  
ATOM   1610  HA  LEU A 107      17.727  -0.844  26.348  1.00  4.41           H  
ATOM   1611  HB2 LEU A 107      19.084  -2.061  23.946  1.00  4.55           H  
ATOM   1612  HB3 LEU A 107      17.905  -2.847  24.979  1.00  5.03           H  
ATOM   1613  HG  LEU A 107      17.384  -0.476  23.182  1.00  5.16           H  
ATOM   1614 HD11 LEU A 107      16.484  -3.344  22.999  1.00  5.72           H  
ATOM   1615 HD12 LEU A 107      17.682  -2.564  21.966  1.00  5.93           H  
ATOM   1616 HD13 LEU A 107      15.999  -2.036  21.920  1.00  5.97           H  
ATOM   1617 HD21 LEU A 107      15.031  -0.789  23.805  1.00  4.51           H  
ATOM   1618 HD22 LEU A 107      16.026  -0.356  25.195  1.00  4.78           H  
ATOM   1619 HD23 LEU A 107      15.510  -2.026  24.967  1.00  4.65           H  
ATOM   1620  N   GLU A 108      19.449  -1.915  27.757  1.00  4.57           N  
ATOM   1621  CA  GLU A 108      20.457  -2.495  28.641  1.00  4.71           C  
ATOM   1622  C   GLU A 108      21.671  -1.577  28.768  1.00  5.10           C  
ATOM   1623  O   GLU A 108      21.648  -0.689  29.645  1.00  5.66           O  
ATOM   1624  CB  GLU A 108      20.892  -3.871  28.129  1.00  5.08           C  
ATOM   1625  CG  GLU A 108      19.839  -4.955  28.314  1.00  5.36           C  
ATOM   1626  CD  GLU A 108      18.560  -4.668  27.549  1.00  5.66           C  
ATOM   1627  OE1 GLU A 108      18.479  -5.048  26.363  1.00  5.89           O  
ATOM   1628  OE2 GLU A 108      17.640  -4.065  28.140  1.00  6.00           O  
ATOM   1629  OXT GLU A 108      22.632  -1.758  27.991  1.00  5.19           O  
ATOM   1630  H   GLU A 108      18.537  -1.787  28.092  1.00  4.78           H  
ATOM   1631  HA  GLU A 108      20.009  -2.613  29.617  1.00  4.62           H  
ATOM   1632  HB2 GLU A 108      21.116  -3.795  27.075  1.00  5.29           H  
ATOM   1633  HB3 GLU A 108      21.783  -4.175  28.656  1.00  5.41           H  
ATOM   1634  HG2 GLU A 108      20.243  -5.894  27.966  1.00  5.56           H  
ATOM   1635  HG3 GLU A 108      19.604  -5.033  29.365  1.00  5.62           H  
TER    1636      GLU A 108                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
