
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  102 (  752),  selected  102 , name 3b76_B
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 3b76_B.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N   401_B      -       -           -
LGA    L   402_B      -       -           -
LGA    Y   403_B      -       -           -
LGA    F   404_B      -       -           -
LGA    Q   405_B      -       -           -
LGA    S   406_B      S       1          3.852
LGA    M   407_B      M       2          2.030
LGA    H   408_B      E       3          0.460
LGA    E   409_B      I       4          0.875
LGA    K   410_B      L       5          0.715
LGA    V   411_B      Q       6          0.512
LGA    V   412_B      V       7          0.988
LGA    N   413_B      A       8          1.529
LGA    I   414_B      L       9          1.542
LGA    Q   415_B      H      10          1.609
LGA    K   416_B      K      11          1.773
LGA    D   417_B      R      12          1.800
LGA    P   418_B      D      13          3.077
LGA    -       -      S      14           -
LGA    G   419_B      G      15          2.292
LGA    E   420_B      E      16          0.886
LGA    S   421_B      Q      17          0.495
LGA    L   422_B      L      18          0.343
LGA    G   423_B      G      19          0.971
LGA    M   424_B      I      20          1.386
LGA    T   425_B      K      21          0.728
LGA    V   426_B      L      22          0.755
LGA    A   427_B      V      23          0.899
LGA    G   428_B      R      24          1.395
LGA    G   429_B      -       -           -
LGA    A   430_B      R      25          4.636
LGA    S   431_B      T      26          3.277
LGA    H   432_B      -       -           -
LGA    R   433_B      -       -           -
LGA    E   434_B      -       -           -
LGA    W   435_B      D      27          1.986
LGA    D   436_B      E      28          1.823
LGA    L   437_B      P      29          4.388
LGA    P   438_B      G      30          2.683
LGA    I   439_B      V      31          1.357
LGA    Y   440_B      F      32          1.142
LGA    V   441_B      I      33          1.030
LGA    I   442_B      L      34          0.940
LGA    S   443_B      D      35          1.737
LGA    V   444_B      L      36          0.797
LGA    E   445_B      L      37          1.300
LGA    P   446_B      E      38          1.767
LGA    G   447_B      G      39          1.319
LGA    G   448_B      G      40          0.979
LGA    V   449_B      L      41          0.670
LGA    I   450_B      A      42          0.566
LGA    S   451_B      A      43          1.019
LGA    R   452_B      Q      44          1.143
LGA    D   453_B      D      45          1.133
LGA    G   454_B      G      46          1.171
LGA    R   455_B      R      47          1.178
LGA    I   456_B      L      48          0.877
LGA    K   457_B      S      49          1.586
LGA    T   458_B      S      50          2.012
LGA    G   459_B      N      51          2.074
LGA    D   460_B      D      52          1.428
LGA    I   461_B      R      53          1.447
LGA    L   462_B      V      54          1.047
LGA    L   463_B      L      55          1.050
LGA    N   464_B      A      56          0.846
LGA    V   465_B      I      57          0.638
LGA    D   466_B      N      58          0.775
LGA    G   467_B      G      59          0.562
LGA    V   468_B      H      60          1.421
LGA    E   469_B      D      61          1.652
LGA    L   470_B      L      62          0.745
LGA    T   471_B      K      63          2.228
LGA    E   472_B      Y      64          4.189
LGA    V   473_B      G      65          3.602
LGA    S   474_B      T      66          4.145
LGA    R   475_B      P      67          4.079
LGA    S   476_B      E      68          1.920
LGA    E   477_B      L      69          1.214
LGA    A   478_B      A      70          2.345
LGA    V   479_B      A      71          2.620
LGA    A   480_B      Q      72          1.592
LGA    L   481_B      I      73          1.722
LGA    L   482_B      I      74          2.864
LGA    K   483_B      Q      75          2.983
LGA    R   484_B      A      76          2.762
LGA    T   485_B      S      77          4.224
LGA    S   486_B      G      78          2.316
LGA    S   487_B      E      79          0.787
LGA    S   488_B      R      80          0.823
LGA    I   489_B      V      81          0.516
LGA    V   490_B      N      82          0.597
LGA    L   491_B      L      83          0.368
LGA    K   492_B      T      84          0.696
LGA    A   493_B      I      85          0.907
LGA    L   494_B      A      86          1.481
LGA    E   495_B      R      87          1.715
LGA    V   496_B      P      88          3.503
LGA    -       -      G      89           -
LGA    K   497_B      K      90          4.225
LGA    E   498_B      P      91          3.139
LGA    G   499_B      E      92          5.321
LGA    S   500_B      I      93          4.210
LGA    I   501_B      E      94          3.388
LGA    V   502_B      L      95          2.990

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  102   95    5.0     93    2.14    21.51     85.725     4.143

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.080139 * X  +  -0.996273 * Y  +   0.031909 * Z  +  18.489416
  Y_new =  -0.948567 * X  +   0.066388 * Y  +  -0.309536 * Z  +  19.953997
  Z_new =   0.306264 * X  +  -0.055074 * Y  +  -0.950352 * Z  +  40.459053 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.083706    0.057886  [ DEG:  -176.6833      3.3167 ]
  Theta =  -0.311266   -2.830327  [ DEG:   -17.8342   -162.1658 ]
  Phi   =  -1.655081    1.486512  [ DEG:   -94.8291     85.1709 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3b76_B                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3b76_B.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  102   95   5.0   93   2.14   21.51  85.725
REMARK  ---------------------------------------------------------- 
MOLECULE 3b76_B
HEADER    LIGASE                                  30-OCT-07   3B76              
TITLE     CRYSTAL STRUCTURE OF THE THIRD PDZ DOMAIN OF HUMAN LIGAND-            
TITLE    2 OF-NUMB PROTEIN-X (LNX1) IN COMPLEX WITH THE C-TERMINAL              
TITLE    3 PEPTIDE FROM THE COXSACKIEVIRUS AND ADENOVIRUS RECEPTOR              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: E3 UBIQUITIN-PROTEIN LIGASE LNX;                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: THIRD PDZ DOMAIN: RESIDUES 504-594;                        
COMPND   5 SYNONYM: NUMB-BINDING PROTEIN 1, LIGAND OF NUMB-PROTEIN X            
COMPND   6 1;                                                                   
COMPND   7 EC: 6.3.2.-;                                                         
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: LNX1, LNX;                                                     
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-R3-ROSETTA;                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    PDZ, PEPTIDE, BOUND LIGAND, DOMAIN, STRUCTURAL GENOMICS,              
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, SGC, ALTERNATIVE SPLICING,           
KEYWDS   3 CYTOPLASM, LIGASE, METAL-BINDING, UBL CONJUGATION PATHWAY,           
KEYWDS   4 ZINC, ZINC-FINGER, STRUCTURAL GENOMICS, UNKNOWN FUNCTION             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.UGOCHUKWU,N.BURGESS-BROWN,G.BERRIDGE,J.ELKINS,G.BUNKOCZI,           
AUTHOR   2 A.C.W.PIKE,M.SUNDSTROM,C.H.ARROWSMITH,J.WEIGELT,A.M.EDWARDS,         
AUTHOR   3 O.GILEADI,F.VON DELFT,D.DOYLE,STRUCTURAL GENOMICS                    
AUTHOR   4 CONSORTIUM (SGC)                                                     
REVDAT   1   13-NOV-07 3B76    0                                                
JRNL        AUTH   E.UGOCHUKWU,N.BURGESS-BROWN,G.BERRIDGE,J.ELKINS,             
JRNL        AUTH 2 G.BUNKOCZI,A.C.W.PIKE,M.SUNDSTROM,C.H.ARROWSMITH,            
JRNL        AUTH 3 J.WEIGELT,A.M.EDWARDS,O.GILEADI,F.VON DELFT,D.DOYLE          
JRNL        TITL   CRYSTAL STRUCTURE OF THE THIRD PDZ DOMAIN OF HUMAN           
JRNL        TITL 2 LIGAND-OF-NUMB PROTEIN-X (LNX1) IN COMPLEX WITH              
JRNL        TITL 3 THE C-TERMINAL PEPTIDE FROM THE COXSACKIEVIRUS AND           
JRNL        TITL 4 ADENOVIRUS RECEPTOR.                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.75 ANGSTROMS.                                          
DBREF  3B76 A  408   498  UNP    Q8TBB1   LNX1_HUMAN     504    594             
DBREF  3B76 B  408   498  UNP    Q8TBB1   LNX1_HUMAN     504    594             
SEQRES   1 A  118  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  118  GLY THR GLU ASN LEU TYR PHE GLN SER MET HIS GLU LYS          
SEQRES   3 A  118  VAL VAL ASN ILE GLN LYS ASP PRO GLY GLU SER LEU GLY          
SEQRES   4 A  118  MET THR VAL ALA GLY GLY ALA SER HIS ARG GLU TRP ASP          
SEQRES   5 A  118  LEU PRO ILE TYR VAL ILE SER VAL GLU PRO GLY GLY VAL          
SEQRES   6 A  118  ILE SER ARG ASP GLY ARG ILE LYS THR GLY ASP ILE LEU          
SEQRES   7 A  118  LEU ASN VAL ASP GLY VAL GLU LEU THR GLU VAL SER ARG          
SEQRES   8 A  118  SER GLU ALA VAL ALA LEU LEU LYS ARG THR SER SER SER          
SEQRES   9 A  118  ILE VAL LEU LYS ALA LEU GLU VAL LYS GLU GLY SER ILE          
SEQRES  10 A  118  VAL                                                          
SEQRES   1 B  118  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  118  GLY THR GLU ASN LEU TYR PHE GLN SER MET HIS GLU LYS          
SEQRES   3 B  118  VAL VAL ASN ILE GLN LYS ASP PRO GLY GLU SER LEU GLY          
SEQRES   4 B  118  MET THR VAL ALA GLY GLY ALA SER HIS ARG GLU TRP ASP          
SEQRES   5 B  118  LEU PRO ILE TYR VAL ILE SER VAL GLU PRO GLY GLY VAL          
SEQRES   6 B  118  ILE SER ARG ASP GLY ARG ILE LYS THR GLY ASP ILE LEU          
SEQRES   7 B  118  LEU ASN VAL ASP GLY VAL GLU LEU THR GLU VAL SER ARG          
SEQRES   8 B  118  SER GLU ALA VAL ALA LEU LEU LYS ARG THR SER SER SER          
SEQRES   9 B  118  ILE VAL LEU LYS ALA LEU GLU VAL LYS GLU GLY SER ILE          
SEQRES  10 B  118  VAL                                                          
HET     NA  A 601       1                                                       
HET    EDO  B 601       4                                                       
HET    EDO  B 602       4                                                       
HETNAM      NA SODIUM ION                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   3   NA    NA 1+                                                        
FORMUL   4  EDO    2(C2 H6 O2)                                                  
FORMUL   6  HOH   *124(H2 O)                                                    
CRYST1   49.782   58.449   73.741  90.00  90.00  90.00 P 21 21 21    8          
ATOM    764  N   ASN B 401      19.632  -1.749  34.409  1.00 37.98           N  
ATOM    765  CA  ASN B 401      20.285  -0.752  35.310  1.00 41.01           C  
ATOM    766  C   ASN B 401      20.583   0.597  34.629  1.00 40.31           C  
ATOM    767  O   ASN B 401      20.722   1.627  35.305  1.00 32.55           O  
ATOM    768  CB  ASN B 401      21.580  -1.329  35.880  1.00 36.04           C  
ATOM    769  N   LEU B 402      20.694   0.607  33.304  1.00 40.67           N  
ATOM    770  CA  LEU B 402      21.051   1.851  32.623  1.00 39.20           C  
ATOM    771  C   LEU B 402      19.895   2.478  31.866  1.00 40.76           C  
ATOM    772  O   LEU B 402      19.015   1.793  31.316  1.00 40.61           O  
ATOM    773  CB  LEU B 402      22.309   1.731  31.758  1.00 43.18           C  
ATOM    774  CG  LEU B 402      22.629   0.496  30.929  1.00 46.06           C  
ATOM    775  CD1 LEU B 402      22.075   0.644  29.522  1.00 46.05           C  
ATOM    776  CD2 LEU B 402      24.146   0.336  30.918  1.00 35.25           C  
ATOM    777  N   TYR B 403      19.907   3.808  31.887  1.00 20.82           N  
ATOM    778  CA  TYR B 403      18.798   4.592  31.423  1.00 19.13           C  
ATOM    779  C   TYR B 403      19.436   5.637  30.545  1.00 22.23           C  
ATOM    780  O   TYR B 403      19.598   6.808  30.895  1.00 18.64           O  
ATOM    781  CB  TYR B 403      18.049   5.166  32.616  1.00 14.00           C  
ATOM    782  CG  TYR B 403      17.450   4.064  33.452  1.00 12.51           C  
ATOM    783  CD1 TYR B 403      16.167   3.600  33.206  1.00 17.38           C  
ATOM    784  CD2 TYR B 403      18.182   3.461  34.467  1.00 22.62           C  
ATOM    785  CE1 TYR B 403      15.618   2.584  33.957  1.00 23.04           C  
ATOM    786  CE2 TYR B 403      17.649   2.445  35.206  1.00 21.47           C  
ATOM    787  CZ  TYR B 403      16.357   2.012  34.958  1.00 31.23           C  
ATOM    788  OH  TYR B 403      15.821   0.985  35.699  1.00 30.47           O  
ATOM    789  N   PHE B 404      19.902   5.143  29.422  1.00 11.93           N  
ATOM    790  CA  PHE B 404      20.645   5.944  28.491  1.00 11.69           C  
ATOM    791  C   PHE B 404      19.696   6.413  27.398  1.00 14.42           C  
ATOM    792  O   PHE B 404      18.618   5.823  27.188  1.00 17.29           O  
ATOM    793  CB  PHE B 404      21.799   5.104  27.892  1.00 15.42           C  
ATOM    794  CG  PHE B 404      22.998   4.879  28.825  1.00 14.25           C  
ATOM    795  CD1 PHE B 404      22.912   5.006  30.216  1.00 17.89           C  
ATOM    796  CD2 PHE B 404      24.226   4.551  28.274  1.00 28.38           C  
ATOM    797  CE1 PHE B 404      24.042   4.792  31.030  1.00 19.68           C  
ATOM    798  CE2 PHE B 404      25.339   4.345  29.067  1.00 31.89           C  
ATOM    799  CZ  PHE B 404      25.243   4.470  30.441  1.00 20.67           C  
ATOM    800  N   GLN B 405      20.038   7.511  26.737  1.00 10.03           N  
ATOM    801  CA  GLN B 405      19.359   7.915  25.524  1.00 11.56           C  
ATOM    802  C   GLN B 405      20.310   8.569  24.544  1.00 12.56           C  
ATOM    803  O   GLN B 405      21.387   9.039  24.914  1.00 13.37           O  
ATOM    804  CB  GLN B 405      18.204   8.875  25.816  1.00 11.60           C  
ATOM    805  CG  GLN B 405      18.640  10.189  26.364  1.00 18.70           C  
ATOM    806  CD  GLN B 405      17.499  11.192  26.425  1.00 24.68           C  
ATOM    807  OE1 GLN B 405      16.327  10.816  26.595  1.00 18.71           O  
ATOM    808  NE2 GLN B 405      17.845  12.479  26.366  1.00 19.39           N  
ATOM    809  N   SER B 406      19.912   8.573  23.288  1.00 14.63           N  
ATOM    810  CA  SER B 406      20.715   9.193  22.258  1.00 12.29           C  
ATOM    811  C   SER B 406      19.880   9.719  21.128  1.00 18.65           C  
ATOM    812  O   SER B 406      18.870   9.108  20.732  1.00 18.55           O  
ATOM    813  CB  SER B 406      21.828   8.270  21.761  1.00 17.30           C  
ATOM    814  OG  SER B 406      21.320   7.305  20.867  0.50 29.14           O  
ATOM    816  N   MET B 407      20.272  10.892  20.629  1.00 11.48           N  
ATOM    817  CA  MET B 407      19.573  11.489  19.505  1.00 11.71           C  
ATOM    818  C   MET B 407      20.609  11.980  18.517  1.00 15.98           C  
ATOM    819  O   MET B 407      21.729  12.374  18.890  1.00 13.71           O  
ATOM    820  CB  MET B 407      18.640  12.623  19.914  1.00 17.45           C  
ATOM    821  CG  MET B 407      19.300  13.774  20.646  1.00 19.55           C  
ATOM    822  SD  MET B 407      18.015  14.882  21.283  1.00 28.91           S  
ATOM    823  CE  MET B 407      17.132  13.744  22.370  1.00 47.00           C  
ATOM    824  N   HIS B 408      20.271  11.869  17.243  1.00 12.14           N  
ATOM    825  CA  HIS B 408      21.232  12.195  16.188  1.00 13.82           C  
ATOM    826  C   HIS B 408      20.623  12.974  15.075  1.00 15.34           C  
ATOM    827  O   HIS B 408      19.486  12.743  14.702  1.00 14.90           O  
ATOM    828  CB  HIS B 408      21.937  10.959  15.607  1.00 22.38           C  
ATOM    829  CG  HIS B 408      21.017   9.985  14.950  0.50 15.15           C  
ATOM    831  ND1 HIS B 408      20.265   9.054  15.629  0.50 29.40           N  
ATOM    833  CD2 HIS B 408      20.755   9.794  13.631  0.50 21.63           C  
ATOM    835  CE1 HIS B 408      19.572   8.335  14.760  0.50 32.45           C  
ATOM    837  NE2 HIS B 408      19.851   8.765  13.542  0.50 23.31           N  
ATOM    839  N   GLU B 409      21.387  13.921  14.565  1.00 12.69           N  
ATOM    840  CA  GLU B 409      20.940  14.751  13.435  1.00 10.26           C  
ATOM    841  C   GLU B 409      21.323  14.085  12.117  1.00 15.57           C  
ATOM    842  O   GLU B 409      22.320  13.320  12.022  1.00 15.14           O  
ATOM    843  CB  GLU B 409      21.534  16.151  13.541  1.00 16.13           C  
ATOM    844  CG  GLU B 409      21.100  16.836  14.805  1.00 18.04           C  
ATOM    845  CD  GLU B 409      21.694  18.203  15.019  1.00 21.05           C  
ATOM    846  OE1 GLU B 409      22.474  18.711  14.177  1.00 16.14           O  
ATOM    847  OE2 GLU B 409      21.352  18.772  16.088  1.00 21.56           O  
ATOM    848  N   LYS B 410      20.538  14.357  11.097  1.00 15.76           N  
ATOM    849  CA  LYS B 410      20.785  13.825   9.770  1.00 14.58           C  
ATOM    850  C   LYS B 410      20.388  14.857   8.728  1.00 16.77           C  
ATOM    851  O   LYS B 410      19.410  15.559   8.911  1.00 19.26           O  
ATOM    852  CB  LYS B 410      20.031  12.525   9.537  1.00 20.06           C  
ATOM    853  CG  LYS B 410      18.574  12.594   9.744  1.00 29.17           C  
ATOM    854  CD  LYS B 410      17.951  11.201   9.890  1.00 32.58           C  
ATOM    855  CE  LYS B 410      16.471  11.335  10.054  1.00 31.02           C  
ATOM    856  NZ  LYS B 410      15.766  10.051  10.319  1.00 22.25           N  
ATOM    857  N   VAL B 411      21.170  14.927   7.645  1.00 14.12           N  
ATOM    858  CA  VAL B 411      20.892  15.861   6.540  1.00 15.53           C  
ATOM    859  C   VAL B 411      20.434  15.032   5.354  1.00 23.96           C  
ATOM    860  O   VAL B 411      21.077  14.057   4.969  1.00 17.60           O  
ATOM    861  CB  VAL B 411      22.123  16.705   6.182  1.00 24.53           C  
ATOM    862  CG1 VAL B 411      21.884  17.503   4.916  1.00 25.03           C  
ATOM    863  CG2 VAL B 411      22.437  17.630   7.307  1.00 26.96           C  
ATOM    864  N   VAL B 412      19.302  15.421   4.790  1.00 18.03           N  
ATOM    865  CA  VAL B 412      18.601  14.640   3.795  1.00 20.47           C  
ATOM    866  C   VAL B 412      18.381  15.592   2.611  1.00 20.87           C  
ATOM    867  O   VAL B 412      17.637  16.549   2.756  1.00 22.05           O  
ATOM    868  CB  VAL B 412      17.247  14.110   4.356  1.00 21.19           C  
ATOM    869  CG1 VAL B 412      16.458  13.366   3.312  1.00 27.45           C  
ATOM    870  CG2 VAL B 412      17.487  13.156   5.568  1.00 25.70           C  
ATOM    871  N   ASN B 413      19.067  15.345   1.485  1.00 21.12           N  
ATOM    872  CA  ASN B 413      18.843  16.086   0.229  1.00 16.88           C  
ATOM    873  C   ASN B 413      17.924  15.260  -0.646  1.00 17.66           C  
ATOM    874  O   ASN B 413      18.252  14.129  -1.016  1.00 18.67           O  
ATOM    875  CB  ASN B 413      20.162  16.371  -0.492  1.00 26.85           C  
ATOM    876  CG  ASN B 413      20.001  17.294  -1.735  1.00 46.84           C  
ATOM    877  OD1 ASN B 413      18.978  17.972  -1.940  1.00 41.55           O  
ATOM    878  ND2 ASN B 413      21.044  17.322  -2.564  1.00 57.45           N  
ATOM    879  N   ILE B 414      16.733  15.786  -0.906  1.00 20.31           N  
ATOM    880  CA  ILE B 414      15.743  15.059  -1.695  1.00 24.03           C  
ATOM    881  C   ILE B 414      15.525  15.734  -3.026  1.00 19.26           C  
ATOM    882  O   ILE B 414      15.394  16.948  -3.084  1.00 22.82           O  
ATOM    883  CB  ILE B 414      14.447  14.952  -0.956  1.00 25.95           C  
ATOM    884  CG1 ILE B 414      14.662  13.993   0.231  1.00 39.99           C  
ATOM    885  CG2 ILE B 414      13.291  14.498  -1.912  1.00 29.09           C  
ATOM    886  CD1 ILE B 414      13.444  13.563   0.902  1.00 24.24           C  
ATOM    887  N   GLN B 415      15.554  14.921  -4.076  1.00 26.19           N  
ATOM    888  CA  GLN B 415      15.296  15.357  -5.421  1.00 26.16           C  
ATOM    889  C   GLN B 415      13.880  14.901  -5.742  1.00 21.20           C  
ATOM    890  O   GLN B 415      13.493  13.760  -5.425  1.00 22.71           O  
ATOM    891  CB  GLN B 415      16.286  14.698  -6.389  1.00 34.90           C  
ATOM    892  CG  GLN B 415      17.754  15.077  -6.164  1.00 39.72           C  
ATOM    893  CD  GLN B 415      18.007  16.553  -6.398  1.00 50.70           C  
ATOM    894  OE1 GLN B 415      17.554  17.122  -7.396  1.00 54.07           O  
ATOM    895  NE2 GLN B 415      18.727  17.186  -5.472  1.00 54.73           N  
ATOM    896  N   LYS B 416      13.095  15.784  -6.348  1.00 20.76           N  
ATOM    897  CA  LYS B 416      11.679  15.495  -6.579  1.00 19.15           C  
ATOM    898  C   LYS B 416      11.184  16.330  -7.751  1.00 14.90           C  
ATOM    899  O   LYS B 416      11.896  17.185  -8.239  1.00 16.69           O  
ATOM    900  CB  LYS B 416      10.852  15.796  -5.333  1.00 20.32           C  
ATOM    901  CG  LYS B 416      10.969  17.241  -4.818  1.00 17.95           C  
ATOM    902  CD  LYS B 416      10.125  17.481  -3.568  1.00 29.51           C  
ATOM    903  CE  LYS B 416       9.520  18.891  -3.535  1.00 40.81           C  
ATOM    904  NZ  LYS B 416       8.482  19.159  -4.594  1.00 19.45           N  
ATOM    905  N   ASP B 417       9.950  16.078  -8.165  1.00 15.64           N  
ATOM    906  CA  ASP B 417       9.301  16.911  -9.169  1.00 14.92           C  
ATOM    907  C   ASP B 417       8.721  18.150  -8.484  1.00 18.59           C  
ATOM    908  O   ASP B 417       8.149  18.050  -7.405  1.00 15.91           O  
ATOM    909  CB  ASP B 417       8.175  16.138  -9.853  1.00 13.32           C  
ATOM    910  CG  ASP B 417       7.571  16.916 -10.989  1.00 14.58           C  
ATOM    911  OD1 ASP B 417       8.207  16.971 -12.075  1.00 14.66           O  
ATOM    912  OD2 ASP B 417       6.486  17.510 -10.758  1.00 17.73           O  
ATOM    913  N   PRO B 418       8.834  19.334  -9.115  1.00 16.92           N  
ATOM    914  CA  PRO B 418       8.242  20.544  -8.513  1.00 18.59           C  
ATOM    915  C   PRO B 418       6.743  20.489  -8.234  1.00 20.70           C  
ATOM    916  O   PRO B 418       6.250  21.220  -7.371  1.00 28.83           O  
ATOM    917  CB  PRO B 418       8.499  21.615  -9.571  1.00 20.01           C  
ATOM    918  CG  PRO B 418       9.731  21.163 -10.237  1.00 15.37           C  
ATOM    919  CD  PRO B 418       9.585  19.662 -10.339  1.00 19.67           C  
ATOM    920  N   GLY B 419       6.045  19.625  -8.965  1.00 12.31           N  
ATOM    921  CA  GLY B 419       4.599  19.433  -8.877  1.00 18.63           C  
ATOM    922  C   GLY B 419       4.153  18.472  -7.782  1.00 20.69           C  
ATOM    923  O   GLY B 419       2.967  18.413  -7.463  1.00 26.31           O  
ATOM    924  N   GLU B 420       5.101  17.755  -7.171  1.00 18.93           N  
ATOM    925  CA  GLU B 420       4.738  16.754  -6.178  1.00 20.44           C  
ATOM    926  C   GLU B 420       5.043  17.222  -4.758  1.00 21.61           C  
ATOM    927  O   GLU B 420       6.038  17.904  -4.494  1.00 20.52           O  
ATOM    928  CB  GLU B 420       5.370  15.389  -6.469  1.00 28.27           C  
ATOM    929  CG  GLU B 420       6.841  15.254  -6.262  1.00 33.00           C  
ATOM    930  CD  GLU B 420       7.367  13.868  -6.713  1.00 33.98           C  
ATOM    931  OE1 GLU B 420       6.604  12.875  -6.675  1.00 25.78           O  
ATOM    932  OE2 GLU B 420       8.560  13.774  -7.085  1.00 27.54           O  
ATOM    933  N   SER B 421       4.152  16.861  -3.856  1.00 20.42           N  
ATOM    934  CA  SER B 421       4.324  17.197  -2.473  1.00 16.17           C  
ATOM    935  C   SER B 421       5.335  16.235  -1.849  1.00 18.53           C  
ATOM    936  O   SER B 421       5.709  15.232  -2.464  1.00 19.17           O  
ATOM    937  CB  SER B 421       2.977  17.140  -1.743  1.00 31.85           C  
ATOM    938  OG  SER B 421       2.529  15.813  -1.611  1.00 30.03           O  
ATOM    939  N   LEU B 422       5.815  16.580  -0.650  1.00 16.80           N  
ATOM    940  CA  LEU B 422       6.781  15.742   0.067  1.00 18.67           C  
ATOM    941  C   LEU B 422       6.143  14.422   0.537  1.00 15.73           C  
ATOM    942  O   LEU B 422       6.834  13.406   0.702  1.00 17.37           O  
ATOM    943  CB  LEU B 422       7.409  16.455   1.266  1.00 19.59           C  
ATOM    944  CG  LEU B 422       8.329  17.651   0.982  1.00 19.81           C  
ATOM    945  CD1 LEU B 422       8.737  18.369   2.273  1.00 21.68           C  
ATOM    946  CD2 LEU B 422       9.562  17.192   0.194  1.00 22.49           C  
ATOM    947  N   GLY B 423       4.835  14.437   0.728  1.00 18.14           N  
ATOM    948  CA  GLY B 423       4.117  13.255   1.199  1.00 17.41           C  
ATOM    949  C   GLY B 423       4.375  12.969   2.665  1.00 18.05           C  
ATOM    950  O   GLY B 423       4.673  11.853   3.048  1.00 17.56           O  
ATOM    951  N   MET B 424       4.254  13.999   3.481  1.00 15.64           N  
ATOM    952  CA  MET B 424       4.308  13.827   4.912  1.00 17.58           C  
ATOM    953  C   MET B 424       3.483  14.929   5.542  1.00 18.76           C  
ATOM    954  O   MET B 424       3.141  15.911   4.893  1.00 18.87           O  
ATOM    955  CB  MET B 424       5.730  13.835   5.441  1.00 18.83           C  
ATOM    956  CG  MET B 424       6.485  15.150   5.299  1.00 20.33           C  
ATOM    957  SD  MET B 424       8.066  15.010   6.174  1.00 20.33           S  
ATOM    958  CE  MET B 424       8.764  16.651   5.868  1.00 20.41           C  
ATOM    959  N   THR B 425       3.207  14.740   6.818  1.00 16.91           N  
ATOM    960  CA  THR B 425       2.424  15.643   7.611  1.00 17.24           C  
ATOM    961  C   THR B 425       3.268  16.042   8.802  1.00 15.77           C  
ATOM    962  O   THR B 425       3.900  15.184   9.469  1.00 15.91           O  
ATOM    963  CB  THR B 425       1.113  14.971   8.073  1.00 20.11           C  
ATOM    964  OG1 THR B 425       0.412  14.457   6.936  1.00 17.75           O  
ATOM    965  CG2 THR B 425       0.234  15.953   8.816  1.00 18.77           C  
ATOM    966  N   VAL B 426       3.284  17.342   9.065  1.00 14.24           N  
ATOM    967  CA  VAL B 426       4.026  17.889  10.215  1.00 13.79           C  
ATOM    968  C   VAL B 426       3.075  18.497  11.234  1.00 17.64           C  
ATOM    969  O   VAL B 426       2.025  19.056  10.899  1.00 16.05           O  
ATOM    970  CB  VAL B 426       5.147  18.865   9.785  1.00 17.92           C  
ATOM    971  CG1 VAL B 426       6.104  18.121   8.818  1.00 15.96           C  
ATOM    972  CG2 VAL B 426       4.557  20.138   9.090  1.00 16.41           C  
ATOM    973  N   ALA B 427       3.450  18.347  12.488  1.00 15.15           N  
ATOM    974  CA  ALA B 427       2.729  18.935  13.610  1.00 15.20           C  
ATOM    975  C   ALA B 427       3.694  19.584  14.594  1.00 20.90           C  
ATOM    976  O   ALA B 427       4.916  19.589  14.387  1.00 19.48           O  
ATOM    977  CB  ALA B 427       1.873  17.881  14.292  1.00 18.06           C  
ATOM    978  N   GLY B 428       3.126  20.176  15.643  1.00 18.27           N  
ATOM    979  CA  GLY B 428       3.906  20.874  16.660  1.00 16.18           C  
ATOM    980  C   GLY B 428       4.209  22.269  16.188  1.00 21.20           C  
ATOM    981  O   GLY B 428       3.442  22.829  15.403  1.00 25.85           O  
ATOM    982  N   GLY B 429       5.325  22.835  16.637  1.00 19.95           N  
ATOM    983  CA  GLY B 429       5.628  24.231  16.362  1.00 20.97           C  
ATOM    984  C   GLY B 429       4.689  25.150  17.109  1.00 27.28           C  
ATOM    985  O   GLY B 429       4.393  26.253  16.660  1.00 34.97           O  
ATOM    986  N   ALA B 430       4.216  24.692  18.262  1.00 26.63           N  
ATOM    987  CA  ALA B 430       3.315  25.486  19.092  1.00 28.41           C  
ATOM    988  C   ALA B 430       3.439  24.957  20.499  1.00 32.88           C  
ATOM    989  O   ALA B 430       3.924  23.846  20.701  1.00 26.74           O  
ATOM    990  CB  ALA B 430       1.872  25.380  18.586  1.00 36.23           C  
ATOM    991  N   SER B 431       3.034  25.754  21.477  1.00 32.10           N  
ATOM    992  CA  SER B 431       3.206  25.360  22.875  1.00 32.81           C  
ATOM    993  C   SER B 431       1.961  24.698  23.459  1.00 33.97           C  
ATOM    994  O   SER B 431       0.830  24.981  23.057  1.00 29.75           O  
ATOM    995  CB  SER B 431       3.566  26.580  23.717  1.00 34.14           C  
ATOM    996  OG  SER B 431       2.568  27.572  23.574  1.00 40.01           O  
ATOM    997  N   HIS B 432       2.185  23.820  24.428  1.00 30.25           N  
ATOM    998  CA  HIS B 432       1.103  23.251  25.205  1.00 30.68           C  
ATOM    999  C   HIS B 432       1.448  23.488  26.671  1.00 27.03           C  
ATOM   1000  O   HIS B 432       2.415  22.912  27.180  1.00 33.04           O  
ATOM   1001  CB  HIS B 432       0.949  21.755  24.907  1.00 26.57           C  
ATOM   1002  CG  HIS B 432      -0.193  21.125  25.637  1.00 25.91           C  
ATOM   1003  ND1 HIS B 432      -1.503  21.263  25.229  1.00 29.35           N  
ATOM   1004  CD2 HIS B 432      -0.226  20.383  26.768  1.00 25.26           C  
ATOM   1005  CE1 HIS B 432      -2.293  20.622  26.072  1.00 29.20           C  
ATOM   1006  NE2 HIS B 432      -1.542  20.084  27.018  1.00 25.26           N  
ATOM   1007  N   ARG B 433       0.672  24.339  27.340  1.00 36.08           N  
ATOM   1008  CA  ARG B 433       1.003  24.797  28.694  1.00 36.27           C  
ATOM   1009  C   ARG B 433       2.427  25.387  28.669  1.00 37.94           C  
ATOM   1010  O   ARG B 433       2.711  26.253  27.835  1.00 46.78           O  
ATOM   1011  CB  ARG B 433       0.844  23.662  29.719  1.00 37.21           C  
ATOM   1012  N   GLU B 434       3.321  24.897  29.532  1.00 42.90           N  
ATOM   1013  CA  GLU B 434       4.728  25.342  29.540  1.00 41.45           C  
ATOM   1014  C   GLU B 434       5.652  24.519  28.617  1.00 39.90           C  
ATOM   1015  O   GLU B 434       6.870  24.680  28.662  1.00 33.85           O  
ATOM   1016  CB  GLU B 434       5.280  25.317  30.973  1.00 41.44           C  
ATOM   1017  N   TRP B 435       5.077  23.635  27.799  1.00 32.15           N  
ATOM   1018  CA  TRP B 435       5.845  22.839  26.857  1.00 35.84           C  
ATOM   1019  C   TRP B 435       5.820  23.506  25.485  1.00 38.51           C  
ATOM   1020  O   TRP B 435       4.754  23.880  25.001  1.00 37.86           O  
ATOM   1021  CB  TRP B 435       5.249  21.432  26.728  1.00 30.37           C  
ATOM   1022  CG  TRP B 435       5.198  20.690  28.018  1.00 33.82           C  
ATOM   1023  CD1 TRP B 435       4.161  20.656  28.919  1.00 35.00           C  
ATOM   1024  CD2 TRP B 435       6.235  19.881  28.568  1.00 49.39           C  
ATOM   1025  NE1 TRP B 435       4.498  19.866  29.996  1.00 41.77           N  
ATOM   1026  CE2 TRP B 435       5.762  19.374  29.804  1.00 42.76           C  
ATOM   1027  CE3 TRP B 435       7.523  19.530  28.139  1.00 43.30           C  
ATOM   1028  CZ2 TRP B 435       6.535  18.539  30.612  1.00 36.46           C  
ATOM   1029  CZ3 TRP B 435       8.294  18.703  28.951  1.00 43.07           C  
ATOM   1030  CH2 TRP B 435       7.797  18.215  30.164  1.00 33.53           C  
ATOM   1031  N   ASP B 436       6.993  23.631  24.865  1.00 35.59           N  
ATOM   1032  CA  ASP B 436       7.103  24.038  23.456  1.00 33.41           C  
ATOM   1033  C   ASP B 436       7.352  22.796  22.642  1.00 35.68           C  
ATOM   1034  O   ASP B 436       8.381  22.120  22.836  1.00 30.11           O  
ATOM   1035  CB  ASP B 436       8.267  25.011  23.273  1.00 42.28           C  
ATOM   1036  CG  ASP B 436       8.045  26.322  23.998  1.00 53.61           C  
ATOM   1037  OD1 ASP B 436       7.042  27.007  23.699  1.00 63.96           O  
ATOM   1038  OD2 ASP B 436       8.879  26.668  24.864  1.00 67.02           O  
ATOM   1039  N   LEU B 437       6.415  22.463  21.753  1.00 22.86           N  
ATOM   1040  CA  LEU B 437       6.577  21.297  20.940  1.00 18.40           C  
ATOM   1041  C   LEU B 437       7.350  21.729  19.688  1.00 20.49           C  
ATOM   1042  O   LEU B 437       6.894  22.615  18.944  1.00 19.27           O  
ATOM   1043  CB  LEU B 437       5.227  20.699  20.496  1.00 18.37           C  
ATOM   1044  CG  LEU B 437       4.480  19.746  21.451  1.00 34.53           C  
ATOM   1045  CD1 LEU B 437       4.647  20.134  22.916  1.00 29.39           C  
ATOM   1046  CD2 LEU B 437       3.024  19.700  21.069  1.00 32.46           C  
ATOM   1047  N   PRO B 438       8.480  21.076  19.425  1.00 15.53           N  
ATOM   1048  CA  PRO B 438       9.133  21.297  18.162  1.00 16.60           C  
ATOM   1049  C   PRO B 438       8.289  20.819  16.981  1.00 17.43           C  
ATOM   1050  O   PRO B 438       7.378  20.010  17.166  1.00 25.43           O  
ATOM   1051  CB  PRO B 438      10.390  20.424  18.275  1.00 24.00           C  
ATOM   1052  CG  PRO B 438      10.047  19.398  19.217  1.00 33.08           C  
ATOM   1053  CD  PRO B 438       9.194  20.064  20.230  1.00 25.49           C  
ATOM   1054  N   ILE B 439       8.576  21.331  15.798  1.00 15.99           N  
ATOM   1055  CA  ILE B 439       7.977  20.837  14.578  1.00 14.42           C  
ATOM   1056  C   ILE B 439       8.502  19.428  14.319  1.00 16.39           C  
ATOM   1057  O   ILE B 439       9.688  19.186  14.373  1.00 17.15           O  
ATOM   1058  CB  ILE B 439       8.332  21.712  13.352  1.00 17.92           C  
ATOM   1059  CG1 ILE B 439       7.808  23.158  13.513  1.00 29.79           C  
ATOM   1060  CG2 ILE B 439       7.823  21.065  12.071  1.00 19.12           C  
ATOM   1061  CD1 ILE B 439       6.467  23.413  12.851  1.00 38.91           C  
ATOM   1062  N   TYR B 440       7.602  18.503  14.036  1.00 17.95           N  
ATOM   1063  CA  TYR B 440       8.015  17.125  13.810  1.00 18.19           C  
ATOM   1064  C   TYR B 440       7.131  16.428  12.802  1.00 18.08           C  
ATOM   1065  O   TYR B 440       6.040  16.912  12.427  1.00 15.20           O  
ATOM   1066  CB  TYR B 440       8.032  16.417  15.150  1.00 15.65           C  
ATOM   1067  CG  TYR B 440       6.652  16.082  15.663  1.00 17.31           C  
ATOM   1068  CD1 TYR B 440       6.132  14.795  15.510  1.00 25.62           C  
ATOM   1069  CD2 TYR B 440       5.873  17.042  16.307  1.00 23.06           C  
ATOM   1070  CE1 TYR B 440       4.862  14.479  15.960  1.00 26.11           C  
ATOM   1071  CE2 TYR B 440       4.596  16.736  16.759  1.00 24.23           C  
ATOM   1072  CZ  TYR B 440       4.107  15.452  16.590  1.00 27.50           C  
ATOM   1073  OH  TYR B 440       2.837  15.149  17.038  1.00 28.65           O  
ATOM   1074  N   VAL B 441       7.595  15.271  12.368  1.00 16.41           N  
ATOM   1075  CA  VAL B 441       6.909  14.496  11.353  1.00 16.97           C  
ATOM   1076  C   VAL B 441       5.898  13.578  12.032  1.00 15.54           C  
ATOM   1077  O   VAL B 441       6.255  12.621  12.729  1.00 16.78           O  
ATOM   1078  CB  VAL B 441       7.905  13.704  10.498  1.00 14.73           C  
ATOM   1079  CG1 VAL B 441       7.143  12.841   9.500  1.00 12.59           C  
ATOM   1080  CG2 VAL B 441       8.910  14.651   9.830  1.00 23.88           C  
ATOM   1081  N   ILE B 442       4.611  13.867  11.836  1.00 17.55           N  
ATOM   1082  CA  ILE B 442       3.577  13.103  12.505  1.00 16.23           C  
ATOM   1083  C   ILE B 442       3.088  11.898  11.669  1.00 18.75           C  
ATOM   1084  O   ILE B 442       2.642  10.863  12.220  1.00 18.94           O  
ATOM   1085  CB  ILE B 442       2.403  14.036  12.953  1.00 20.20           C  
ATOM   1086  CG1 ILE B 442       1.443  13.292  13.852  1.00 24.13           C  
ATOM   1087  CG2 ILE B 442       1.650  14.663  11.776  1.00 18.62           C  
ATOM   1088  CD1 ILE B 442       0.300  14.242  14.333  1.00 22.68           C  
ATOM   1089  N   SER B 443       3.171  12.023  10.344  1.00 15.23           N  
ATOM   1090  CA  SER B 443       2.795  10.952   9.427  1.00 16.27           C  
ATOM   1091  C   SER B 443       3.685  11.035   8.180  1.00 17.31           C  
ATOM   1092  O   SER B 443       4.196  12.103   7.813  1.00 16.37           O  
ATOM   1093  CB  SER B 443       1.316  11.040   9.014  1.00 20.51           C  
ATOM   1094  OG  SER B 443       1.217  10.071   7.986  0.50 30.26           O  
ATOM   1096  N   VAL B 444       3.837   9.888   7.525  1.00 16.28           N  
ATOM   1097  CA  VAL B 444       4.501   9.801   6.222  1.00 15.53           C  
ATOM   1098  C   VAL B 444       3.566   8.996   5.297  1.00 15.30           C  
ATOM   1099  O   VAL B 444       3.072   7.905   5.661  1.00 17.48           O  
ATOM   1100  CB  VAL B 444       5.871   9.101   6.327  1.00 14.53           C  
ATOM   1101  CG1 VAL B 444       6.489   8.833   4.932  1.00 17.08           C  
ATOM   1102  CG2 VAL B 444       6.857   9.887   7.248  1.00 16.47           C  
ATOM   1103  N   GLU B 445       3.294   9.531   4.127  1.00 15.57           N  
ATOM   1104  CA  GLU B 445       2.373   8.866   3.170  1.00 12.96           C  
ATOM   1105  C   GLU B 445       3.135   7.746   2.461  1.00 17.40           C  
ATOM   1106  O   GLU B 445       4.134   7.991   1.801  1.00 16.85           O  
ATOM   1107  CB  GLU B 445       1.869   9.891   2.150  1.00 21.32           C  
ATOM   1108  CG  GLU B 445       0.827   9.372   1.172  1.00 25.73           C  
ATOM   1109  CD  GLU B 445      -0.507   8.979   1.838  1.00 49.72           C  
ATOM   1110  OE1 GLU B 445      -0.717   9.276   3.037  1.00 48.25           O  
ATOM   1111  OE2 GLU B 445      -1.359   8.362   1.155  1.00 57.64           O  
ATOM   1112  N   PRO B 446       2.673   6.498   2.600  1.00 13.93           N  
ATOM   1113  CA  PRO B 446       3.348   5.422   1.895  1.00 16.81           C  
ATOM   1114  C   PRO B 446       3.479   5.728   0.423  1.00 19.89           C  
ATOM   1115  O   PRO B 446       2.521   6.184  -0.224  1.00 19.47           O  
ATOM   1116  CB  PRO B 446       2.419   4.226   2.138  1.00 16.62           C  
ATOM   1117  CG  PRO B 446       1.800   4.514   3.426  1.00 19.99           C  
ATOM   1118  CD  PRO B 446       1.537   5.988   3.385  1.00 15.60           C  
ATOM   1119  N   GLY B 447       4.669   5.511  -0.107  1.00 18.36           N  
ATOM   1120  CA  GLY B 447       4.916   5.697  -1.526  1.00 21.11           C  
ATOM   1121  C   GLY B 447       5.134   7.118  -2.009  1.00 23.97           C  
ATOM   1122  O   GLY B 447       5.425   7.320  -3.189  1.00 22.26           O  
ATOM   1123  N   GLY B 448       5.016   8.123  -1.129  1.00 19.33           N  
ATOM   1124  CA  GLY B 448       5.307   9.496  -1.529  1.00 20.56           C  
ATOM   1125  C   GLY B 448       6.806   9.743  -1.494  1.00 16.46           C  
ATOM   1126  O   GLY B 448       7.591   8.818  -1.264  1.00 16.79           O  
ATOM   1127  N   VAL B 449       7.189  10.995  -1.681  1.00 18.21           N  
ATOM   1128  CA  VAL B 449       8.597  11.369  -1.856  1.00 18.40           C  
ATOM   1129  C   VAL B 449       9.413  10.968  -0.621  1.00 15.19           C  
ATOM   1130  O   VAL B 449      10.437  10.288  -0.710  1.00 14.94           O  
ATOM   1131  CB  VAL B 449       8.705  12.888  -2.157  1.00 17.58           C  
ATOM   1132  CG1 VAL B 449      10.113  13.443  -1.844  1.00 15.98           C  
ATOM   1133  CG2 VAL B 449       8.312  13.173  -3.618  1.00 18.09           C  
ATOM   1134  N   ILE B 450       8.914  11.347   0.546  1.00 15.22           N  
ATOM   1135  CA  ILE B 450       9.648  11.090   1.795  1.00 18.32           C  
ATOM   1136  C   ILE B 450       9.773   9.581   2.071  1.00 12.96           C  
ATOM   1137  O   ILE B 450      10.824   9.069   2.477  1.00 16.55           O  
ATOM   1138  CB  ILE B 450       8.994  11.835   2.981  1.00 15.67           C  
ATOM   1139  CG1 ILE B 450       9.228  13.349   2.853  1.00 18.21           C  
ATOM   1140  CG2 ILE B 450       9.496  11.289   4.311  1.00 14.93           C  
ATOM   1141  CD1 ILE B 450      10.641  13.822   3.083  1.00 17.69           C  
ATOM   1142  N   SER B 451       8.695   8.868   1.787  1.00 15.29           N  
ATOM   1143  CA  SER B 451       8.639   7.412   1.931  1.00 16.44           C  
ATOM   1144  C   SER B 451       9.632   6.718   1.013  1.00 16.17           C  
ATOM   1145  O   SER B 451      10.398   5.852   1.469  1.00 17.75           O  
ATOM   1146  CB  SER B 451       7.209   6.931   1.652  1.00 18.49           C  
ATOM   1147  OG  SER B 451       7.090   5.511   1.660  1.00 18.12           O  
ATOM   1148  N   ARG B 452       9.637   7.114  -0.272  1.00 16.99           N  
ATOM   1149  CA  ARG B 452      10.520   6.494  -1.258  1.00 20.25           C  
ATOM   1150  C   ARG B 452      11.964   6.764  -0.928  1.00 21.60           C  
ATOM   1151  O   ARG B 452      12.817   5.911  -1.111  1.00 21.82           O  
ATOM   1152  CB  ARG B 452      10.226   6.988  -2.680  1.00 21.80           C  
ATOM   1153  CG  ARG B 452       8.885   6.540  -3.192  1.00 23.03           C  
ATOM   1154  CD  ARG B 452       8.688   6.814  -4.678  1.00 24.75           C  
ATOM   1155  NE  ARG B 452       9.012   8.168  -5.131  1.00 24.14           N  
ATOM   1156  CZ  ARG B 452       8.174   9.200  -5.209  1.00 24.73           C  
ATOM   1157  NH1 ARG B 452       6.918   9.103  -4.813  1.00 29.17           N  
ATOM   1158  NH2 ARG B 452       8.604  10.355  -5.705  1.00 28.63           N  
ATOM   1159  N   ASP B 453      12.239   7.961  -0.438  1.00 17.91           N  
ATOM   1160  CA  ASP B 453      13.596   8.313   0.000  1.00 18.83           C  
ATOM   1161  C   ASP B 453      14.042   7.494   1.238  1.00 21.16           C  
ATOM   1162  O   ASP B 453      15.166   7.007   1.313  1.00 20.11           O  
ATOM   1163  CB  ASP B 453      13.692   9.801   0.290  1.00 20.83           C  
ATOM   1164  CG  ASP B 453      15.053  10.185   0.817  1.00 24.76           C  
ATOM   1165  OD1 ASP B 453      15.914  10.503  -0.021  1.00 26.65           O  
ATOM   1166  OD2 ASP B 453      15.279  10.132   2.046  1.00 22.87           O  
ATOM   1167  N   GLY B 454      13.158   7.366   2.222  1.00 19.61           N  
ATOM   1168  CA  GLY B 454      13.334   6.412   3.296  1.00 21.50           C  
ATOM   1169  C   GLY B 454      14.111   6.870   4.513  1.00 23.39           C  
ATOM   1170  O   GLY B 454      14.170   6.142   5.507  1.00 27.96           O  
ATOM   1171  N   ARG B 455      14.675   8.071   4.471  1.00 17.85           N  
ATOM   1172  CA  ARG B 455      15.566   8.509   5.544  1.00 17.41           C  
ATOM   1173  C   ARG B 455      14.855   9.266   6.662  1.00 18.94           C  
ATOM   1174  O   ARG B 455      15.236   9.149   7.829  1.00 24.44           O  
ATOM   1175  CB  ARG B 455      16.709   9.324   4.963  1.00 21.23           C  
ATOM   1176  CG  ARG B 455      17.588   8.528   4.041  1.00 23.63           C  
ATOM   1177  CD  ARG B 455      18.693   9.382   3.457  1.00 24.94           C  
ATOM   1178  NE  ARG B 455      18.211  10.219   2.365  1.00 26.38           N  
ATOM   1179  CZ  ARG B 455      18.965  11.108   1.728  1.00 29.08           C  
ATOM   1180  NH1 ARG B 455      20.241  11.276   2.054  1.00 29.61           N  
ATOM   1181  NH2 ARG B 455      18.449  11.816   0.756  1.00 24.60           N  
ATOM   1182  N   ILE B 456      13.811  10.000   6.306  1.00 19.08           N  
ATOM   1183  CA  ILE B 456      13.023  10.746   7.278  1.00 16.53           C  
ATOM   1184  C   ILE B 456      11.861   9.854   7.717  1.00 23.89           C  
ATOM   1185  O   ILE B 456      11.147   9.269   6.883  1.00 27.26           O  
ATOM   1186  CB  ILE B 456      12.469  12.058   6.669  1.00 16.81           C  
ATOM   1187  CG1 ILE B 456      13.582  13.000   6.208  1.00 24.09           C  
ATOM   1188  CG2 ILE B 456      11.492  12.743   7.642  1.00 20.29           C  
ATOM   1189  CD1 ILE B 456      14.254  13.783   7.312  1.00 25.78           C  
ATOM   1190  N   LYS B 457      11.672   9.767   9.024  1.00 18.94           N  
ATOM   1191  CA  LYS B 457      10.702   8.868   9.630  1.00 24.74           C  
ATOM   1192  C   LYS B 457       9.752   9.586  10.564  1.00 16.44           C  
ATOM   1193  O   LYS B 457      10.048  10.660  11.067  1.00 17.36           O  
ATOM   1194  CB  LYS B 457      11.441   7.787  10.409  1.00 29.37           C  
ATOM   1195  CG  LYS B 457      12.197   6.814   9.509  1.00 40.11           C  
ATOM   1196  CD  LYS B 457      13.628   6.586   9.978  1.00 49.75           C  
ATOM   1197  CE  LYS B 457      14.466   5.905   8.885  1.00 51.86           C  
ATOM   1198  NZ  LYS B 457      15.903   6.297   8.973  1.00 51.98           N  
ATOM   1199  N   THR B 458       8.603   8.965  10.799  1.00 18.57           N  
ATOM   1200  CA  THR B 458       7.618   9.480  11.744  1.00 18.03           C  
ATOM   1201  C   THR B 458       8.326   9.691  13.095  1.00 18.80           C  
ATOM   1202  O   THR B 458       9.168   8.879  13.527  1.00 21.31           O  
ATOM   1203  CB  THR B 458       6.413   8.504  11.865  1.00 24.51           C  
ATOM   1204  OG1 THR B 458       5.684   8.505  10.628  1.00 28.26           O  
ATOM   1205  CG2 THR B 458       5.491   8.912  12.962  1.00 32.03           C  
ATOM   1206  N   GLY B 459       8.062  10.834  13.713  1.00 16.88           N  
ATOM   1207  CA  GLY B 459       8.690  11.191  14.970  1.00 23.16           C  
ATOM   1208  C   GLY B 459       9.943  12.064  14.839  1.00 17.23           C  
ATOM   1209  O   GLY B 459      10.373  12.647  15.871  1.00 21.10           O  
ATOM   1210  N   ASP B 460      10.554  12.136  13.648  1.00 15.38           N  
ATOM   1211  CA  ASP B 460      11.746  12.979  13.441  1.00 17.36           C  
ATOM   1212  C   ASP B 460      11.378  14.435  13.695  1.00 19.81           C  
ATOM   1213  O   ASP B 460      10.340  14.937  13.220  1.00 16.72           O  
ATOM   1214  CB  ASP B 460      12.325  12.857  12.018  1.00 16.68           C  
ATOM   1215  CG  ASP B 460      13.089  11.566  11.774  1.00 21.73           C  
ATOM   1216  OD1 ASP B 460      13.280  10.758  12.713  1.00 21.13           O  
ATOM   1217  OD2 ASP B 460      13.461  11.358  10.597  1.00 26.47           O  
ATOM   1218  N   ILE B 461      12.233  15.118  14.446  1.00 14.15           N  
ATOM   1219  CA  ILE B 461      12.065  16.533  14.670  1.00 14.48           C  
ATOM   1220  C   ILE B 461      12.754  17.271  13.540  1.00 19.47           C  
ATOM   1221  O   ILE B 461      13.893  16.966  13.232  1.00 17.91           O  
ATOM   1222  CB  ILE B 461      12.643  16.947  16.030  1.00 13.70           C  
ATOM   1223  CG1 ILE B 461      11.750  16.410  17.157  1.00 21.07           C  
ATOM   1224  CG2 ILE B 461      12.814  18.457  16.053  1.00 16.94           C  
ATOM   1225  CD1 ILE B 461      12.411  16.323  18.502  1.00 20.82           C  
ATOM   1226  N   LEU B 462      12.075  18.232  12.926  1.00 14.33           N  
ATOM   1227  CA  LEU B 462      12.659  19.012  11.831  1.00 14.54           C  
ATOM   1228  C   LEU B 462      13.361  20.251  12.331  1.00 15.74           C  
ATOM   1229  O   LEU B 462      12.787  21.083  13.038  1.00 17.32           O  
ATOM   1230  CB  LEU B 462      11.622  19.353  10.746  1.00 16.24           C  
ATOM   1231  CG  LEU B 462      10.899  18.152  10.144  1.00 18.12           C  
ATOM   1232  CD1 LEU B 462       9.842  18.627   9.099  1.00 17.42           C  
ATOM   1233  CD2 LEU B 462      11.880  17.146   9.557  1.00 19.66           C  
ATOM   1234  N   LEU B 463      14.641  20.334  11.996  1.00 15.00           N  
ATOM   1235  CA  LEU B 463      15.483  21.414  12.478  1.00 15.20           C  
ATOM   1236  C   LEU B 463      15.714  22.550  11.505  1.00 17.69           C  
ATOM   1237  O   LEU B 463      15.816  23.725  11.921  1.00 19.29           O  
ATOM   1238  CB  LEU B 463      16.837  20.850  12.894  1.00 21.12           C  
ATOM   1239  CG  LEU B 463      16.906  19.775  13.968  1.00 17.80           C  
ATOM   1240  CD1 LEU B 463      18.405  19.381  14.133  1.00 18.53           C  
ATOM   1241  CD2 LEU B 463      16.295  20.215  15.258  1.00 20.94           C  
ATOM   1242  N   ASN B 464      15.894  22.223  10.231  1.00 16.51           N  
ATOM   1243  CA  ASN B 464      16.293  23.190   9.236  1.00 18.85           C  
ATOM   1244  C   ASN B 464      15.759  22.763   7.877  1.00 17.95           C  
ATOM   1245  O   ASN B 464      15.821  21.581   7.550  1.00 18.72           O  
ATOM   1246  CB  ASN B 464      17.828  23.268   9.260  1.00 22.62           C  
ATOM   1247  CG  ASN B 464      18.375  24.384   8.443  1.00 22.80           C  
ATOM   1248  OD1 ASN B 464      18.370  24.303   7.224  1.00 21.75           O  
ATOM   1249  ND2 ASN B 464      18.936  25.415   9.110  1.00 21.19           N  
ATOM   1250  N   VAL B 465      15.184  23.702   7.122  1.00 18.93           N  
ATOM   1251  CA  VAL B 465      14.733  23.467   5.758  1.00 16.12           C  
ATOM   1252  C   VAL B 465      15.428  24.484   4.860  1.00 20.77           C  
ATOM   1253  O   VAL B 465      15.275  25.686   5.065  1.00 18.66           O  
ATOM   1254  CB  VAL B 465      13.188  23.607   5.604  1.00 15.88           C  
ATOM   1255  CG1 VAL B 465      12.803  23.258   4.158  1.00 16.10           C  
ATOM   1256  CG2 VAL B 465      12.463  22.658   6.591  1.00 19.07           C  
ATOM   1257  N   ASP B 466      16.196  23.993   3.885  1.00 17.03           N  
ATOM   1258  CA  ASP B 466      16.830  24.832   2.841  1.00 17.77           C  
ATOM   1259  C   ASP B 466      17.568  26.023   3.445  1.00 24.58           C  
ATOM   1260  O   ASP B 466      17.526  27.135   2.911  1.00 30.80           O  
ATOM   1261  CB  ASP B 466      15.809  25.310   1.813  1.00 23.42           C  
ATOM   1262  CG  ASP B 466      15.283  24.183   0.956  1.00 28.85           C  
ATOM   1263  OD1 ASP B 466      16.046  23.225   0.690  1.00 22.31           O  
ATOM   1264  OD2 ASP B 466      14.123  24.263   0.545  1.00 32.19           O  
ATOM   1265  N   GLY B 467      18.272  25.759   4.537  1.00 24.38           N  
ATOM   1266  CA  GLY B 467      19.121  26.761   5.195  1.00 26.30           C  
ATOM   1267  C   GLY B 467      18.477  27.516   6.335  1.00 28.48           C  
ATOM   1268  O   GLY B 467      19.163  28.185   7.095  1.00 31.98           O  
ATOM   1269  N   VAL B 468      17.157  27.427   6.448  1.00 17.89           N  
ATOM   1270  CA  VAL B 468      16.414  28.157   7.460  1.00 20.32           C  
ATOM   1271  C   VAL B 468      16.191  27.299   8.706  1.00 20.30           C  
ATOM   1272  O   VAL B 468      15.620  26.203   8.646  1.00 20.12           O  
ATOM   1273  CB  VAL B 468      15.052  28.608   6.894  1.00 20.15           C  
ATOM   1274  CG1 VAL B 468      14.301  29.446   7.894  1.00 20.34           C  
ATOM   1275  CG2 VAL B 468      15.233  29.357   5.539  1.00 23.38           C  
ATOM   1276  N   GLU B 469      16.627  27.819   9.843  1.00 16.15           N  
ATOM   1277  CA  GLU B 469      16.510  27.134  11.129  1.00 17.10           C  
ATOM   1278  C   GLU B 469      15.099  27.348  11.634  1.00 16.15           C  
ATOM   1279  O   GLU B 469      14.683  28.487  11.848  1.00 22.65           O  
ATOM   1280  CB  GLU B 469      17.522  27.723  12.130  1.00 23.91           C  
ATOM   1281  CG  GLU B 469      17.731  26.895  13.382  1.00 26.40           C  
ATOM   1282  CD  GLU B 469      18.460  25.571  13.114  1.00 46.60           C  
ATOM   1283  OE1 GLU B 469      19.076  25.411  12.026  1.00 36.57           O  
ATOM   1284  OE2 GLU B 469      18.411  24.686  13.992  1.00 51.56           O  
ATOM   1285  N   LEU B 470      14.360  26.267  11.835  1.00 16.06           N  
ATOM   1286  CA  LEU B 470      12.926  26.403  12.092  1.00 17.02           C  
ATOM   1287  C   LEU B 470      12.590  27.041  13.461  1.00 19.68           C  
ATOM   1288  O   LEU B 470      11.532  27.640  13.611  1.00 25.43           O  
ATOM   1289  CB  LEU B 470      12.177  25.082  11.880  1.00 21.06           C  
ATOM   1290  CG  LEU B 470      12.286  24.413  10.508  1.00 16.46           C  
ATOM   1291  CD1 LEU B 470      11.372  23.187  10.433  1.00 19.71           C  
ATOM   1292  CD2 LEU B 470      11.987  25.386   9.332  1.00 19.72           C  
ATOM   1293  N   THR B 471      13.475  26.963  14.447  1.00 24.11           N  
ATOM   1294  CA  THR B 471      13.182  27.637  15.724  1.00 28.55           C  
ATOM   1295  C   THR B 471      13.218  29.163  15.568  1.00 29.80           C  
ATOM   1296  O   THR B 471      12.765  29.886  16.450  1.00 33.96           O  
ATOM   1297  CB  THR B 471      14.156  27.201  16.833  1.00 28.87           C  
ATOM   1298  OG1 THR B 471      15.499  27.369  16.373  1.00 30.22           O  
ATOM   1299  CG2 THR B 471      13.927  25.740  17.181  1.00 32.65           C  
ATOM   1300  N   GLU B 472      13.757  29.642  14.447  1.00 25.40           N  
ATOM   1301  CA  GLU B 472      13.926  31.071  14.193  1.00 28.68           C  
ATOM   1302  C   GLU B 472      12.821  31.672  13.314  1.00 27.38           C  
ATOM   1303  O   GLU B 472      12.901  32.838  12.942  1.00 26.10           O  
ATOM   1304  CB  GLU B 472      15.283  31.304  13.526  1.00 24.73           C  
ATOM   1305  CG  GLU B 472      16.471  30.962  14.420  1.00 36.04           C  
ATOM   1306  CD  GLU B 472      17.820  31.056  13.715  1.00 47.84           C  
ATOM   1307  OE1 GLU B 472      17.892  31.604  12.590  1.00 43.11           O  
ATOM   1308  OE2 GLU B 472      18.815  30.564  14.295  1.00 57.90           O  
ATOM   1309  N   VAL B 473      11.804  30.884  12.972  1.00 20.07           N  
ATOM   1310  CA  VAL B 473      10.685  31.370  12.145  1.00 18.79           C  
ATOM   1311  C   VAL B 473       9.339  30.870  12.714  1.00 22.03           C  
ATOM   1312  O   VAL B 473       9.304  29.974  13.552  1.00 18.93           O  
ATOM   1313  CB  VAL B 473      10.807  30.934  10.640  1.00 20.54           C  
ATOM   1314  CG1 VAL B 473      12.056  31.521  10.010  1.00 24.96           C  
ATOM   1315  CG2 VAL B 473      10.774  29.402  10.496  1.00 17.70           C  
ATOM   1316  N   SER B 474       8.236  31.447  12.242  1.00 23.29           N  
ATOM   1317  CA  SER B 474       6.919  31.030  12.706  1.00 26.12           C  
ATOM   1318  C   SER B 474       6.588  29.614  12.256  1.00 22.20           C  
ATOM   1319  O   SER B 474       7.196  29.086  11.315  1.00 22.47           O  
ATOM   1320  CB  SER B 474       5.849  31.992  12.201  1.00 23.86           C  
ATOM   1321  OG  SER B 474       5.753  31.979  10.784  1.00 28.31           O  
ATOM   1322  N   ARG B 475       5.619  28.993  12.917  1.00 19.96           N  
ATOM   1323  CA  ARG B 475       5.113  27.695  12.459  1.00 18.94           C  
ATOM   1324  C   ARG B 475       4.655  27.736  10.988  1.00 21.54           C  
ATOM   1325  O   ARG B 475       4.911  26.805  10.207  1.00 21.88           O  
ATOM   1326  CB  ARG B 475       3.945  27.258  13.350  1.00 24.68           C  
ATOM   1327  CG  ARG B 475       3.363  25.873  13.050  1.00 23.32           C  
ATOM   1328  CD  ARG B 475       2.155  25.575  13.975  1.00 22.75           C  
ATOM   1329  NE  ARG B 475       1.763  24.158  13.902  1.00 21.06           N  
ATOM   1330  CZ  ARG B 475       1.015  23.632  12.927  1.00 29.50           C  
ATOM   1331  NH1 ARG B 475       0.531  24.396  11.942  1.00 23.11           N  
ATOM   1332  NH2 ARG B 475       0.709  22.343  12.960  1.00 22.02           N  
ATOM   1333  N   SER B 476       3.936  28.791  10.612  1.00 19.92           N  
ATOM   1334  CA  SER B 476       3.359  28.861   9.273  1.00 17.84           C  
ATOM   1335  C   SER B 476       4.472  29.069   8.240  1.00 17.35           C  
ATOM   1336  O   SER B 476       4.382  28.587   7.100  1.00 19.12           O  
ATOM   1337  CB  SER B 476       2.302  29.967   9.197  1.00 25.70           C  
ATOM   1338  OG  SER B 476       2.896  31.209   9.481  1.00 30.04           O  
ATOM   1339  N   GLU B 477       5.546  29.756   8.635  1.00 18.53           N  
ATOM   1340  CA  GLU B 477       6.690  29.910   7.743  1.00 20.38           C  
ATOM   1341  C   GLU B 477       7.402  28.583   7.567  1.00 19.78           C  
ATOM   1342  O   GLU B 477       7.866  28.295   6.480  1.00 16.10           O  
ATOM   1343  CB  GLU B 477       7.691  31.004   8.176  1.00 31.05           C  
ATOM   1344  CG  GLU B 477       8.868  31.137   7.150  1.00 32.63           C  
ATOM   1345  CD  GLU B 477       9.661  32.456   7.191  1.00 39.13           C  
ATOM   1346  OE1 GLU B 477       9.141  33.488   7.670  1.00 34.08           O  
ATOM   1347  OE2 GLU B 477      10.817  32.451   6.702  1.00 41.48           O  
ATOM   1348  N   ALA B 478       7.485  27.784   8.635  1.00 17.05           N  
ATOM   1349  CA  ALA B 478       8.030  26.421   8.547  1.00 18.64           C  
ATOM   1350  C   ALA B 478       7.261  25.591   7.530  1.00 15.24           C  
ATOM   1351  O   ALA B 478       7.839  24.899   6.667  1.00 14.82           O  
ATOM   1352  CB  ALA B 478       7.968  25.744   9.924  1.00 19.73           C  
ATOM   1353  N   VAL B 479       5.942  25.654   7.615  1.00 18.78           N  
ATOM   1354  CA  VAL B 479       5.080  24.938   6.690  1.00 20.79           C  
ATOM   1355  C   VAL B 479       5.272  25.440   5.237  1.00 16.12           C  
ATOM   1356  O   VAL B 479       5.450  24.623   4.325  1.00 17.59           O  
ATOM   1357  CB  VAL B 479       3.604  24.974   7.144  1.00 21.66           C  
ATOM   1358  CG1 VAL B 479       2.702  24.288   6.130  1.00 20.41           C  
ATOM   1359  CG2 VAL B 479       3.457  24.326   8.561  1.00 17.26           C  
ATOM   1360  N   ALA B 480       5.328  26.757   5.049  1.00 16.72           N  
ATOM   1361  CA  ALA B 480       5.607  27.353   3.725  1.00 16.22           C  
ATOM   1362  C   ALA B 480       6.958  26.901   3.140  1.00 16.29           C  
ATOM   1363  O   ALA B 480       7.071  26.684   1.932  1.00 18.22           O  
ATOM   1364  CB  ALA B 480       5.550  28.888   3.813  1.00 17.42           C  
ATOM   1365  N   LEU B 481       7.980  26.779   3.994  1.00 17.90           N  
ATOM   1366  CA  LEU B 481       9.309  26.309   3.549  1.00 13.77           C  
ATOM   1367  C   LEU B 481       9.231  24.896   3.015  1.00 13.99           C  
ATOM   1368  O   LEU B 481       9.826  24.574   1.960  1.00 18.57           O  
ATOM   1369  CB  LEU B 481      10.329  26.381   4.691  1.00 13.53           C  
ATOM   1370  CG  LEU B 481      10.819  27.789   5.023  1.00 19.89           C  
ATOM   1371  CD1 LEU B 481      11.386  27.827   6.429  1.00 16.98           C  
ATOM   1372  CD2 LEU B 481      11.865  28.229   3.946  1.00 22.27           C  
ATOM   1373  N   LEU B 482       8.477  24.046   3.709  1.00 15.78           N  
ATOM   1374  CA  LEU B 482       8.292  22.658   3.303  1.00 15.08           C  
ATOM   1375  C   LEU B 482       7.483  22.464   2.030  1.00 17.82           C  
ATOM   1376  O   LEU B 482       7.693  21.492   1.315  1.00 21.40           O  
ATOM   1377  CB  LEU B 482       7.636  21.864   4.433  1.00 16.48           C  
ATOM   1378  CG  LEU B 482       8.553  21.670   5.633  1.00 16.62           C  
ATOM   1379  CD1 LEU B 482       7.726  21.319   6.854  1.00 17.87           C  
ATOM   1380  CD2 LEU B 482       9.650  20.629   5.369  1.00 15.81           C  
ATOM   1381  N   LYS B 483       6.573  23.394   1.771  1.00 17.96           N  
ATOM   1382  CA  LYS B 483       5.667  23.318   0.626  1.00 17.44           C  
ATOM   1383  C   LYS B 483       6.184  24.046  -0.607  1.00 20.46           C  
ATOM   1384  O   LYS B 483       5.547  23.999  -1.668  1.00 21.29           O  
ATOM   1385  CB  LYS B 483       4.291  23.850   1.022  1.00 22.24           C  
ATOM   1386  CG  LYS B 483       3.571  22.959   2.032  1.00 20.06           C  
ATOM   1387  CD  LYS B 483       2.256  23.561   2.510  1.00 30.13           C  
ATOM   1388  CE  LYS B 483       1.169  23.438   1.462  1.00 43.24           C  
ATOM   1389  NZ  LYS B 483      -0.179  23.885   1.972  1.00 41.34           N  
ATOM   1390  N   ARG B 484       7.340  24.691  -0.488  1.00 20.44           N  
ATOM   1391  CA  ARG B 484       7.938  25.414  -1.606  1.00 22.42           C  
ATOM   1392  C   ARG B 484       7.987  24.543  -2.853  1.00 25.42           C  
ATOM   1393  O   ARG B 484       8.360  23.383  -2.790  1.00 21.29           O  
ATOM   1394  CB  ARG B 484       9.364  25.844  -1.271  1.00 21.91           C  
ATOM   1395  CG  ARG B 484       9.935  26.886  -2.209  1.00 29.48           C  
ATOM   1396  CD  ARG B 484      11.446  26.796  -2.349  1.00 29.11           C  
ATOM   1397  NE  ARG B 484      12.173  26.990  -1.106  1.00 34.08           N  
ATOM   1398  CZ  ARG B 484      12.722  28.143  -0.700  1.00 47.89           C  
ATOM   1399  NH1 ARG B 484      12.655  29.248  -1.454  1.00 36.66           N  
ATOM   1400  NH2 ARG B 484      13.369  28.191   0.472  1.00 35.04           N  
ATOM   1401  N   THR B 485       7.593  25.114  -3.981  1.00 20.25           N  
ATOM   1402  CA  THR B 485       7.723  24.471  -5.268  1.00 20.29           C  
ATOM   1403  C   THR B 485       9.203  24.411  -5.597  1.00 27.10           C  
ATOM   1404  O   THR B 485       9.851  25.450  -5.768  1.00 27.95           O  
ATOM   1405  CB  THR B 485       6.996  25.309  -6.354  1.00 25.08           C  
ATOM   1406  OG1 THR B 485       5.597  25.356  -6.049  1.00 28.10           O  
ATOM   1407  CG2 THR B 485       7.207  24.699  -7.732  1.00 38.49           C  
ATOM   1408  N   SER B 486       9.758  23.208  -5.622  1.00 24.53           N  
ATOM   1409  CA  SER B 486      11.160  23.031  -5.996  1.00 21.69           C  
ATOM   1410  C   SER B 486      11.432  21.595  -6.367  1.00 17.29           C  
ATOM   1411  O   SER B 486      10.670  20.691  -5.989  1.00 20.16           O  
ATOM   1412  CB  SER B 486      12.105  23.445  -4.869  1.00 27.48           C  
ATOM   1413  OG  SER B 486      13.442  23.523  -5.357  1.00 37.65           O  
ATOM   1414  N   SER B 487      12.532  21.386  -7.091  1.00 19.38           N  
ATOM   1415  CA  SER B 487      12.961  20.059  -7.513  1.00 18.01           C  
ATOM   1416  C   SER B 487      13.955  19.468  -6.534  1.00 17.78           C  
ATOM   1417  O   SER B 487      14.386  18.334  -6.691  1.00 21.29           O  
ATOM   1418  CB  SER B 487      13.543  20.069  -8.928  1.00 21.82           C  
ATOM   1419  OG  SER B 487      14.732  20.818  -9.012  1.00 22.39           O  
ATOM   1420  N   SER B 488      14.317  20.229  -5.514  1.00 18.32           N  
ATOM   1421  CA  SER B 488      15.152  19.672  -4.456  1.00 18.07           C  
ATOM   1422  C   SER B 488      15.000  20.429  -3.166  1.00 27.76           C  
ATOM   1423  O   SER B 488      14.833  21.646  -3.161  1.00 22.52           O  
ATOM   1424  CB  SER B 488      16.614  19.626  -4.874  1.00 31.59           C  
ATOM   1425  OG  SER B 488      17.140  20.917  -4.982  1.00 30.35           O  
ATOM   1426  N   ILE B 489      15.049  19.679  -2.077  1.00 19.14           N  
ATOM   1427  CA  ILE B 489      14.847  20.210  -0.759  1.00 18.52           C  
ATOM   1428  C   ILE B 489      15.871  19.565   0.157  1.00 22.82           C  
ATOM   1429  O   ILE B 489      16.168  18.387   0.020  1.00 25.88           O  
ATOM   1430  CB  ILE B 489      13.417  19.932  -0.250  1.00 19.93           C  
ATOM   1431  CG1 ILE B 489      13.203  20.592   1.121  1.00 28.84           C  
ATOM   1432  CG2 ILE B 489      13.131  18.424  -0.246  1.00 26.13           C  
ATOM   1433  CD1 ILE B 489      11.780  20.577   1.612  1.00 34.07           C  
ATOM   1434  N   VAL B 490      16.461  20.367   1.027  1.00 17.83           N  
ATOM   1435  CA  VAL B 490      17.457  19.847   1.995  1.00 17.40           C  
ATOM   1436  C   VAL B 490      16.850  20.003   3.381  1.00 15.99           C  
ATOM   1437  O   VAL B 490      16.498  21.112   3.813  1.00 16.99           O  
ATOM   1438  CB  VAL B 490      18.810  20.607   1.936  1.00 21.67           C  
ATOM   1439  CG1 VAL B 490      19.821  20.011   2.934  1.00 21.02           C  
ATOM   1440  CG2 VAL B 490      19.391  20.600   0.525  1.00 21.99           C  
ATOM   1441  N   LEU B 491      16.729  18.877   4.074  1.00 18.18           N  
ATOM   1442  CA  LEU B 491      16.174  18.851   5.395  1.00 13.39           C  
ATOM   1443  C   LEU B 491      17.228  18.381   6.373  1.00 15.75           C  
ATOM   1444  O   LEU B 491      17.988  17.468   6.048  1.00 20.08           O  
ATOM   1445  CB  LEU B 491      14.996  17.888   5.436  1.00 21.08           C  
ATOM   1446  CG  LEU B 491      13.833  18.158   4.493  1.00 24.49           C  
ATOM   1447  CD1 LEU B 491      12.850  16.970   4.522  1.00 28.22           C  
ATOM   1448  CD2 LEU B 491      13.130  19.426   4.890  1.00 26.90           C  
ATOM   1449  N   LYS B 492      17.284  19.029   7.540  1.00 16.02           N  
ATOM   1450  CA  LYS B 492      18.045  18.516   8.689  1.00 14.96           C  
ATOM   1451  C   LYS B 492      17.042  18.117   9.740  1.00 17.09           C  
ATOM   1452  O   LYS B 492      16.186  18.933  10.138  1.00 17.26           O  
ATOM   1453  CB  LYS B 492      19.026  19.561   9.240  1.00 19.19           C  
ATOM   1454  CG  LYS B 492      19.945  19.029  10.343  1.00 22.36           C  
ATOM   1455  CD  LYS B 492      21.032  20.032  10.782  1.00 27.24           C  
ATOM   1456  CE  LYS B 492      22.145  20.230   9.720  1.00 35.04           C  
ATOM   1457  NZ  LYS B 492      23.180  21.282  10.090  1.00 28.87           N  
ATOM   1458  N   ALA B 493      17.120  16.861  10.176  1.00 15.95           N  
ATOM   1459  CA  ALA B 493      16.192  16.325  11.146  1.00 12.59           C  
ATOM   1460  C   ALA B 493      16.954  15.769  12.341  1.00 16.87           C  
ATOM   1461  O   ALA B 493      18.131  15.431  12.235  1.00 17.58           O  
ATOM   1462  CB  ALA B 493      15.342  15.228  10.518  1.00 15.78           C  
ATOM   1463  N   LEU B 494      16.250  15.656  13.456  1.00 12.54           N  
ATOM   1464  CA  LEU B 494      16.782  15.079  14.713  1.00 14.11           C  
ATOM   1465  C   LEU B 494      15.958  13.836  15.027  1.00 15.62           C  
ATOM   1466  O   LEU B 494      14.709  13.909  15.134  1.00 16.81           O  
ATOM   1467  CB  LEU B 494      16.616  16.104  15.847  1.00 16.72           C  
ATOM   1468  CG  LEU B 494      17.081  15.688  17.223  1.00 16.49           C  
ATOM   1469  CD1 LEU B 494      18.576  15.436  17.244  1.00 16.80           C  
ATOM   1470  CD2 LEU B 494      16.662  16.816  18.202  1.00 22.59           C  
ATOM   1471  N   GLU B 495      16.627  12.698  15.186  1.00 13.52           N  
ATOM   1472  CA  GLU B 495      15.976  11.422  15.407  1.00 17.44           C  
ATOM   1473  C   GLU B 495      16.414  10.876  16.761  1.00 20.38           C  
ATOM   1474  O   GLU B 495      17.589  10.866  17.098  1.00 17.49           O  
ATOM   1475  CB  GLU B 495      16.374  10.451  14.291  1.00 21.06           C  
ATOM   1476  CG  GLU B 495      15.777   9.055  14.387  1.00 27.89           C  
ATOM   1477  CD  GLU B 495      16.405   8.037  13.419  1.00 33.36           C  
ATOM   1478  OE1 GLU B 495      16.831   8.404  12.293  1.00 28.41           O  
ATOM   1479  OE2 GLU B 495      16.461   6.841  13.795  1.00 41.57           O  
ATOM   1480  N   VAL B 496      15.464  10.399  17.541  1.00 21.19           N  
ATOM   1481  CA  VAL B 496      15.816   9.628  18.741  1.00 27.43           C  
ATOM   1482  C   VAL B 496      16.144   8.171  18.407  1.00 30.27           C  
ATOM   1483  O   VAL B 496      15.260   7.417  18.013  1.00 40.68           O  
ATOM   1484  CB  VAL B 496      14.706   9.652  19.786  1.00 36.61           C  
ATOM   1485  CG1 VAL B 496      15.171   8.903  21.031  1.00 36.56           C  
ATOM   1486  CG2 VAL B 496      14.340  11.091  20.115  1.00 28.06           C  
ATOM   1487  N   LYS B 497      17.404   7.791  18.559  1.00 27.16           N  
ATOM   1488  CA  LYS B 497      17.865   6.446  18.228  1.00 26.04           C  
ATOM   1489  C   LYS B 497      17.649   5.509  19.420  1.00 36.97           C  
ATOM   1490  O   LYS B 497      17.479   4.304  19.223  1.00 37.24           O  
ATOM   1491  CB  LYS B 497      19.338   6.435  17.832  1.00 31.63           C  
ATOM   1492  N   GLU B 498      17.664   6.048  20.647  1.00 21.10           N  
ATOM   1493  CA  GLU B 498      17.667   5.203  21.841  1.00 17.36           C  
ATOM   1494  C   GLU B 498      17.052   5.946  23.015  1.00 16.73           C  
ATOM   1495  O   GLU B 498      17.266   7.140  23.206  1.00 14.87           O  
ATOM   1496  CB  GLU B 498      19.097   4.759  22.196  1.00 19.78           C  
ATOM   1497  N   GLY B 499      16.233   5.250  23.782  1.00 13.60           N  
ATOM   1498  CA  GLY B 499      15.727   5.831  24.989  1.00 12.04           C  
ATOM   1499  C   GLY B 499      15.844   4.921  26.197  1.00 13.81           C  
ATOM   1500  O   GLY B 499      16.476   3.836  26.184  1.00 17.07           O  
ATOM   1501  N   SER B 500      15.220   5.383  27.260  1.00 12.27           N  
ATOM   1502  CA  SER B 500      15.268   4.722  28.555  1.00 12.25           C  
ATOM   1503  C   SER B 500      14.065   3.849  28.820  1.00 15.80           C  
ATOM   1504  O   SER B 500      12.940   4.314  28.736  1.00 13.85           O  
ATOM   1505  CB  SER B 500      15.397   5.773  29.656  1.00 15.42           C  
ATOM   1506  OG  SER B 500      16.615   6.485  29.502  1.00 20.01           O  
ATOM   1507  N   ILE B 501      14.292   2.575  29.135  1.00 14.41           N  
ATOM   1508  CA  ILE B 501      13.193   1.638  29.355  1.00 16.02           C  
ATOM   1509  C   ILE B 501      12.697   1.721  30.793  1.00 16.00           C  
ATOM   1510  O   ILE B 501      13.485   1.567  31.725  1.00 16.32           O  
ATOM   1511  CB  ILE B 501      13.622   0.180  29.046  1.00 18.64           C  
ATOM   1512  CG1 ILE B 501      13.991   0.052  27.564  1.00 23.64           C  
ATOM   1513  CG2 ILE B 501      12.508  -0.756  29.403  1.00 18.25           C  
ATOM   1514  CD1 ILE B 501      14.601  -1.293  27.153  1.00 26.90           C  
ATOM   1515  N   VAL B 502      11.398   1.963  30.980  1.00 15.98           N  
ATOM   1516  CA  VAL B 502      10.818   2.074  32.344  1.00 16.56           C  
ATOM   1517  C   VAL B 502       9.653   1.107  32.564  1.00 20.95           C  
ATOM   1518  O   VAL B 502       9.232   0.394  31.632  1.00 17.08           O  
ATOM   1519  CB  VAL B 502      10.356   3.527  32.633  1.00 19.06           C  
ATOM   1520  CG1 VAL B 502      11.547   4.494  32.629  1.00 15.97           C  
ATOM   1521  CG2 VAL B 502       9.276   3.937  31.596  1.00 14.90           C  
ATOM   1522  OXT VAL B 502       9.122   1.007  33.702  1.00 20.23           O  
TER    1523      VAL B 502                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
