
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  742),  selected   98 , name 2opg_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2opg_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S  1623_A      -       -           -
LGA    M  1624_A      S       1          1.360
LGA    G  1625_A      M       2          0.934
LGA    C  1626_A      E       3          0.519
LGA    E  1627_A      I       4          0.319
LGA    T  1628_A      L       5          0.117
LGA    T  1629_A      Q       6          0.718
LGA    I  1630_A      V       7          1.547
LGA    E  1631_A      A       8          0.776
LGA    I  1632_A      L       9          0.607
LGA    S  1633_A      H      10          0.695
LGA    K  1634_A      K      11          2.046
LGA    G  1635_A      R      12          4.336
LGA    R  1636_A      D      13          5.855
LGA    -       -      S      14           -
LGA    -       -      G      15           -
LGA    T  1637_A      E      16          3.993
LGA    G  1638_A      Q      17          1.704
LGA    L  1639_A      L      18          0.721
LGA    G  1640_A      G      19          1.116
LGA    L  1641_A      I      20          1.087
LGA    S  1642_A      K      21          1.215
LGA    I  1643_A      L      22          0.680
LGA    V  1644_A      V      23          0.639
LGA    G  1645_A      R      24          0.861
LGA    G  1646_A      -       -           -
LGA    S  1647_A      -       -           -
LGA    D  1648_A      -       -           -
LGA    T  1649_A      R      25          4.688
LGA    L  1650_A      T      26          1.146
LGA    -       -      D      27           -
LGA    L  1651_A      E      28          3.952
LGA    G  1652_A      P      29          1.621
LGA    A  1653_A      G      30          0.956
LGA    I  1654_A      V      31          0.528
LGA    I  1655_A      F      32          0.536
LGA    I  1656_A      I      33          0.848
LGA    H  1657_A      L      34          1.182
LGA    E  1658_A      D      35          1.439
LGA    V  1659_A      L      36          0.942
LGA    Y  1660_A      L      37          1.334
LGA    E  1661_A      E      38          1.714
LGA    E  1662_A      G      39          1.082
LGA    G  1663_A      G      40          0.851
LGA    A  1664_A      L      41          0.673
LGA    A  1665_A      A      42          0.689
LGA    C  1666_A      A      43          0.827
LGA    K  1667_A      Q      44          0.890
LGA    D  1668_A      D      45          0.737
LGA    G  1669_A      G      46          0.828
LGA    R  1670_A      R      47          0.636
LGA    L  1671_A      L      48          0.634
LGA    W  1672_A      S      49          0.617
LGA    A  1673_A      S      50          1.235
LGA    G  1674_A      N      51          1.075
LGA    D  1675_A      D      52          0.656
LGA    Q  1676_A      R      53          0.876
LGA    I  1677_A      V      54          0.704
LGA    L  1678_A      L      55          0.428
LGA    E  1679_A      A      56          0.637
LGA    V  1680_A      I      57          0.774
LGA    N  1681_A      N      58          0.872
LGA    G  1682_A      G      59          0.907
LGA    I  1683_A      H      60          0.607
LGA    D  1684_A      D      61          0.465
LGA    L  1685_A      L      62          0.471
LGA    R  1686_A      K      63          0.375
LGA    K  1687_A      Y      64          0.924
LGA    A  1688_A      G      65          1.041
LGA    T  1689_A      T      66          2.715
LGA    H  1690_A      P      67          2.942
LGA    D  1691_A      E      68          2.140
LGA    E  1692_A      L      69          2.174
LGA    A  1693_A      A      70          2.392
LGA    I  1694_A      A      71          1.984
LGA    N  1695_A      Q      72          1.493
LGA    V  1696_A      I      73          1.848
LGA    L  1697_A      I      74          2.223
LGA    R  1698_A      Q      75          1.923
LGA    Q  1699_A      A      76          1.648
LGA    T  1700_A      S      77          1.428
LGA    P  1701_A      G      78          1.285
LGA    Q  1702_A      E      79          0.998
LGA    R  1703_A      R      80          0.729
LGA    V  1704_A      V      81          0.497
LGA    R  1705_A      N      82          0.969
LGA    L  1706_A      L      83          0.829
LGA    T  1707_A      T      84          0.473
LGA    L  1708_A      I      85          0.323
LGA    Y  1709_A      A      86          0.426
LGA    R  1710_A      R      87          0.347
LGA    D  1711_A      P      88          1.081
LGA    E  1712_A      G      89          1.572
LGA    -       -      K      90           -
LGA    A  1713_A      P      91           #
LGA    P  1714_A      E      92           -
LGA    Y  1715_A      I      93           -
LGA    K  1716_A      E      94           -
LGA    S  1717_A      L      95           -
LGA    T  1718_A      -       -           -
LGA    R  1719_A      -       -           -
LGA    L  1720_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   95    5.0     86    1.61    29.07     85.836     5.033

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.329654 * X  +  -0.378172 * Y  +  -0.865052 * Z  +  10.602563
  Y_new =   0.645443 * X  +  -0.578420 * Y  +   0.498832 * Z  +   7.859966
  Z_new =  -0.689007 * X  +  -0.722784 * Y  +   0.053409 * Z  +  54.795353 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.497036    1.644556  [ DEG:   -85.7739     94.2261 ]
  Theta =   0.760119    2.381474  [ DEG:    43.5516    136.4484 ]
  Phi   =   1.098593   -2.043000  [ DEG:    62.9447   -117.0553 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2opg_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2opg_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   95   5.0   86   1.61   29.07  85.836
REMARK  ---------------------------------------------------------- 
MOLECULE 2opg_A
HEADER    STRUCTURAL PROTEIN                      29-JAN-07   2OPG              
TITLE     THE CRYSTAL STRUCTURE OF THE 10TH PDZ DOMAIN OF MPDZ                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MULTIPLE PDZ DOMAIN PROTEIN;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: DOMAIN PDZ-10: RESIDUES 1625-1685;                         
COMPND   5 SYNONYM: MULTI-PDZ DOMAIN PROTEIN 1;                                 
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MPDZ, MUPP1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    STRUCTURAL PROTEIN, STRUCTURAL GENOMICS, STRUCTURAL                   
KEYWDS   2 GENOMICS CONSORTIUM, SGC                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.GILEADI,C.PHILLIPS,J.ELKINS,E.PAPAGRIGORIOU,E.UGOCHUKWU,            
AUTHOR   2 F.GORREC,P.SAVITSKY,C.UMEANO,G.BERRIDGE,O.GILEADI,E.SALAH,           
AUTHOR   3 A.EDWARDS,C.H.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,D.A.DOYLE,            
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   13-FEB-07 2OPG    0                                                
JRNL        AUTH   C.GILEADI,C.PHILLIPS,J.ELKINS,E.PAPAGRIGORIOU,               
JRNL        AUTH 2 E.UGOCHUKWU,F.GORREC,P.SAVITSKY,C.UMEANO,                    
JRNL        AUTH 3 G.BERRIDGE,O.GILEADI,E.SALAH,A.EDWARDS,                      
JRNL        AUTH 4 C.H.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,D.A.DOYLE,              
JRNL        AUTH 5 STRUCTURAL GENOMICS CONSORTIUM (SGC)                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE 10TH PDZ DOMAIN OF              
JRNL        TITL 2 MPDZ                                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2OPG A 1625  1716  UNP    O75970   MPDZ_HUMAN    1625   1716             
DBREF  2OPG B 1625  1716  UNP    O75970   MPDZ_HUMAN    1625   1716             
SEQRES   1 A   98  SER MET GLY CYS GLU THR THR ILE GLU ILE SER LYS GLY          
SEQRES   2 A   98  ARG THR GLY LEU GLY LEU SER ILE VAL GLY GLY SER ASP          
SEQRES   3 A   98  THR LEU LEU GLY ALA ILE ILE ILE HIS GLU VAL TYR GLU          
SEQRES   4 A   98  GLU GLY ALA ALA CYS LYS ASP GLY ARG LEU TRP ALA GLY          
SEQRES   5 A   98  ASP GLN ILE LEU GLU VAL ASN GLY ILE ASP LEU ARG LYS          
SEQRES   6 A   98  ALA THR HIS ASP GLU ALA ILE ASN VAL LEU ARG GLN THR          
SEQRES   7 A   98  PRO GLN ARG VAL ARG LEU THR LEU TYR ARG ASP GLU ALA          
SEQRES   8 A   98  PRO TYR LYS SER THR ARG LEU                                  
SEQRES   1 B   98  SER MET GLY CYS GLU THR THR ILE GLU ILE SER LYS GLY          
SEQRES   2 B   98  ARG THR GLY LEU GLY LEU SER ILE VAL GLY GLY SER ASP          
SEQRES   3 B   98  THR LEU LEU GLY ALA ILE ILE ILE HIS GLU VAL TYR GLU          
SEQRES   4 B   98  GLU GLY ALA ALA CYS LYS ASP GLY ARG LEU TRP ALA GLY          
SEQRES   5 B   98  ASP GLN ILE LEU GLU VAL ASN GLY ILE ASP LEU ARG LYS          
SEQRES   6 B   98  ALA THR HIS ASP GLU ALA ILE ASN VAL LEU ARG GLN THR          
SEQRES   7 B   98  PRO GLN ARG VAL ARG LEU THR LEU TYR ARG ASP GLU ALA          
SEQRES   8 B   98  PRO TYR LYS SER THR ARG LEU                                  
HET     NA      1       1                                                       
HETNAM      NA SODIUM ION                                                       
FORMUL   3   NA    NA 1+                                                        
FORMUL   4  HOH   *233(H2 O)                                                    
CRYST1   54.944   54.944  118.355  90.00  90.00 120.00 P 31 2 1     12          
ATOM      1  N   SER A1623      19.047   9.243  24.946  1.00 53.71           N  
ATOM      2  CA  SER A1623      19.836  10.079  25.912  1.00 51.11           C  
ATOM      3  C   SER A1623      20.643  11.174  25.207  1.00 44.19           C  
ATOM      4  O   SER A1623      20.704  12.288  25.709  1.00 44.19           O  
ATOM      5  CB  SER A1623      20.755   9.216  26.762  1.00 53.18           C  
ATOM      6  OG  SER A1623      21.335   9.968  27.823  1.00 56.74           O  
ATOM      7  N   MET A1624      21.282  10.851  24.076  1.00 34.75           N  
ATOM      8  CA  MET A1624      21.802  11.860  23.134  1.00 32.05           C  
ATOM      9  C   MET A1624      20.921  11.686  21.885  1.00 29.96           C  
ATOM     10  O   MET A1624      20.727  10.546  21.431  1.00 31.77           O  
ATOM     11  CB  MET A1624      23.261  11.618  22.685  1.00 32.27           C  
ATOM     12  CG  MET A1624      24.404  11.741  23.707  1.00 42.92           C  
ATOM     13  SD  MET A1624      24.876  13.463  23.923  1.00 33.91           S  
ATOM     14  CE  MET A1624      25.764  13.896  22.498  1.00 23.58           C  
ATOM     15  N   GLY A1625      20.390  12.773  21.358  1.00 24.81           N  
ATOM     16  CA  GLY A1625      19.638  12.696  20.075  1.00 20.74           C  
ATOM     17  C   GLY A1625      20.609  12.840  18.974  1.00 24.33           C  
ATOM     18  O   GLY A1625      21.802  12.988  19.232  1.00 26.57           O  
ATOM     19  N   CYS A1626      20.126  12.850  17.744  0.50 19.45           N  
ATOM     21  CA  CYS A1626      21.024  12.931  16.622  0.50 20.73           C  
ATOM     23  C   CYS A1626      20.517  13.676  15.369  0.50 17.56           C  
ATOM     25  O   CYS A1626      19.371  13.592  14.878  0.50 19.78           O  
ATOM     27  CB  CYS A1626      21.441  11.542  16.234  0.50 17.69           C  
ATOM     29  SG  CYS A1626      20.101  10.656  15.463  0.50 20.05           S  
ATOM     31  N   GLU A1627      21.459  14.385  14.821  1.00 19.21           N  
ATOM     32  CA  GLU A1627      21.178  15.260  13.672  1.00 18.02           C  
ATOM     33  C   GLU A1627      21.548  14.558  12.387  1.00 20.81           C  
ATOM     34  O   GLU A1627      22.571  13.816  12.350  1.00 19.70           O  
ATOM     35  CB  GLU A1627      21.900  16.594  13.871  1.00 26.56           C  
ATOM     36  CG  GLU A1627      21.785  17.508  12.760  1.00 26.96           C  
ATOM     37  CD  GLU A1627      22.611  18.771  12.900  1.00 26.35           C  
ATOM     38  OE1 GLU A1627      22.837  19.261  14.040  1.00 30.61           O  
ATOM     39  OE2 GLU A1627      23.017  19.323  11.863  1.00 28.17           O  
ATOM     40  N   THR A1628      20.807  14.788  11.327  1.00 18.74           N  
ATOM     41  CA  THR A1628      21.233  14.392  10.004  1.00 20.08           C  
ATOM     42  C   THR A1628      20.803  15.408   8.978  1.00 22.39           C  
ATOM     43  O   THR A1628      19.990  16.271   9.258  1.00 21.85           O  
ATOM     44  CB  THR A1628      20.796  13.014   9.574  1.00 23.68           C  
ATOM     45  OG1 THR A1628      21.510  12.657   8.367  1.00 24.98           O  
ATOM     46  CG2 THR A1628      19.293  12.979   9.247  1.00 25.09           C  
ATOM     47  N   THR A1629      21.445  15.368   7.817  1.00 21.32           N  
ATOM     48  CA  THR A1629      21.012  16.155   6.688  1.00 20.37           C  
ATOM     49  C   THR A1629      20.777  15.223   5.522  1.00 24.60           C  
ATOM     50  O   THR A1629      21.615  14.376   5.233  1.00 25.97           O  
ATOM     51  CB  THR A1629      21.998  17.278   6.274  1.00 24.77           C  
ATOM     52  OG1 THR A1629      22.104  18.257   7.336  1.00 24.32           O  
ATOM     53  CG2 THR A1629      21.541  17.982   5.000  1.00 27.68           C  
ATOM     54  N   ILE A1630      19.593  15.306   4.956  1.00 25.78           N  
ATOM     55  CA  ILE A1630      19.281  14.494   3.823  1.00 27.85           C  
ATOM     56  C   ILE A1630      18.678  15.327   2.717  1.00 27.82           C  
ATOM     57  O   ILE A1630      18.015  16.315   2.982  1.00 33.66           O  
ATOM     58  CB  ILE A1630      18.435  13.357   4.201  0.50 24.90           C  
ATOM     60  CG1 ILE A1630      17.120  13.852   4.738  0.50 15.62           C  
ATOM     62  CG2 ILE A1630      19.178  12.488   5.234  0.50 26.67           C  
ATOM     64  CD1 ILE A1630      16.053  12.762   4.704  0.50 22.98           C  
ATOM     66  N   GLU A1631      18.818  14.898   1.475  1.00 24.43           N  
ATOM     67  CA  GLU A1631      18.223  15.592   0.344  1.00 26.60           C  
ATOM     68  C   GLU A1631      17.129  14.705  -0.223  1.00 26.06           C  
ATOM     69  O   GLU A1631      17.389  13.550  -0.518  1.00 29.47           O  
ATOM     70  CB  GLU A1631      19.293  15.859  -0.721  1.00 28.25           C  
ATOM     71  N   ILE A1632      15.916  15.221  -0.285  1.00 23.11           N  
ATOM     72  CA  ILE A1632      14.784  14.507  -0.834  1.00 24.08           C  
ATOM     73  C   ILE A1632      14.414  15.190  -2.145  1.00 24.25           C  
ATOM     74  O   ILE A1632      14.181  16.395  -2.194  1.00 22.77           O  
ATOM     75  CB  ILE A1632      13.532  14.555   0.096  1.00 26.94           C  
ATOM     76  CG1 ILE A1632      13.737  13.838   1.437  1.00 27.46           C  
ATOM     77  CG2 ILE A1632      12.314  13.899  -0.593  1.00 27.39           C  
ATOM     78  CD1 ILE A1632      14.037  12.367   1.336  1.00 30.60           C  
ATOM     79  N   SER A1633      14.296  14.407  -3.212  1.00 22.68           N  
ATOM     80  CA  SER A1633      13.710  14.891  -4.451  1.00 22.85           C  
ATOM     81  C   SER A1633      12.189  14.723  -4.398  1.00 20.61           C  
ATOM     82  O   SER A1633      11.675  13.595  -4.179  1.00 23.17           O  
ATOM     83  CB  SER A1633      14.240  14.071  -5.610  1.00 21.92           C  
ATOM     84  OG  SER A1633      15.648  14.183  -5.720  1.00 30.38           O  
ATOM     85  N   LYS A1634      11.468  15.806  -4.596  1.00 18.89           N  
ATOM     86  CA  LYS A1634      10.033  15.770  -4.545  1.00 20.71           C  
ATOM     87  C   LYS A1634       9.397  14.849  -5.576  1.00 22.77           C  
ATOM     88  O   LYS A1634       9.894  14.732  -6.712  1.00 23.61           O  
ATOM     89  CB  LYS A1634       9.478  17.151  -4.754  1.00 20.13           C  
ATOM     90  CG  LYS A1634       9.686  18.030  -3.645  1.00 21.36           C  
ATOM     91  CD  LYS A1634       9.134  19.377  -3.997  1.00 22.04           C  
ATOM     92  CE  LYS A1634       9.479  20.375  -3.028  1.00 22.18           C  
ATOM     93  NZ  LYS A1634       9.079  21.743  -3.471  1.00 25.46           N  
ATOM     94  N   GLY A1635       8.264  14.208  -5.253  1.00 21.44           N  
ATOM     95  CA  GLY A1635       7.417  13.606  -6.312  1.00 20.79           C  
ATOM     96  C   GLY A1635       6.177  14.410  -6.603  1.00 22.41           C  
ATOM     97  O   GLY A1635       6.041  15.569  -6.198  1.00 23.86           O  
ATOM     98  N   ARG A1636       5.234  13.795  -7.328  1.00 25.87           N  
ATOM     99  CA  ARG A1636       3.963  14.435  -7.671  1.00 24.39           C  
ATOM    100  C   ARG A1636       3.249  14.973  -6.434  1.00 30.07           C  
ATOM    101  O   ARG A1636       2.665  16.039  -6.490  1.00 30.07           O  
ATOM    102  CB  ARG A1636       3.071  13.426  -8.376  1.00 25.17           C  
ATOM    103  CG  ARG A1636       3.495  13.213  -9.810  1.00 28.81           C  
ATOM    104  CD  ARG A1636       2.603  12.174 -10.534  1.00 33.94           C  
ATOM    105  NE  ARG A1636       2.858  12.245 -11.956  1.00 33.44           N  
ATOM    106  CZ  ARG A1636       1.925  12.339 -12.894  1.00 48.18           C  
ATOM    107  NH1 ARG A1636       0.640  12.322 -12.586  1.00 54.91           N  
ATOM    108  NH2 ARG A1636       2.291  12.416 -14.169  1.00 51.90           N  
ATOM    109  N   THR A1637       3.316  14.238  -5.321  1.00 23.87           N  
ATOM    110  CA  THR A1637       2.705  14.646  -4.060  1.00 31.49           C  
ATOM    111  C   THR A1637       3.638  15.414  -3.195  1.00 29.81           C  
ATOM    112  O   THR A1637       3.352  15.645  -1.985  1.00 34.59           O  
ATOM    113  CB  THR A1637       2.217  13.432  -3.268  1.00 35.53           C  
ATOM    114  OG1 THR A1637       3.312  12.526  -3.048  1.00 30.86           O  
ATOM    115  CG2 THR A1637       1.087  12.733  -4.023  1.00 32.03           C  
ATOM    116  N   GLY A1638       4.790  15.816  -3.741  1.00 27.56           N  
ATOM    117  CA  GLY A1638       5.703  16.674  -2.995  1.00 23.83           C  
ATOM    118  C   GLY A1638       6.678  15.851  -2.190  1.00 21.16           C  
ATOM    119  O   GLY A1638       7.168  14.826  -2.670  1.00 21.82           O  
ATOM    120  N   LEU A1639       6.869  16.289  -0.937  1.00 26.62           N  
ATOM    121  CA  LEU A1639       7.673  15.569   0.057  1.00 23.60           C  
ATOM    122  C   LEU A1639       7.032  14.287   0.574  1.00 20.17           C  
ATOM    123  O   LEU A1639       7.766  13.330   0.895  1.00 24.00           O  
ATOM    124  CB  LEU A1639       8.037  16.484   1.222  1.00 25.25           C  
ATOM    125  CG  LEU A1639       8.953  17.669   0.897  1.00 28.73           C  
ATOM    126  CD1 LEU A1639       9.227  18.580   2.100  1.00 30.17           C  
ATOM    127  CD2 LEU A1639      10.311  17.126   0.339  1.00 37.59           C  
ATOM    128  N   GLY A1640       5.684  14.191   0.620  1.00 19.54           N  
ATOM    129  CA  GLY A1640       5.068  13.020   1.156  1.00 19.82           C  
ATOM    130  C   GLY A1640       5.085  13.011   2.694  1.00 17.56           C  
ATOM    131  O   GLY A1640       5.240  11.961   3.292  1.00 22.83           O  
ATOM    132  N   LEU A1641       4.858  14.148   3.256  1.00 20.79           N  
ATOM    133  CA  LEU A1641       4.794  14.169   4.706  0.50 19.07           C  
ATOM    135  C   LEU A1641       3.824  15.216   5.241  1.00 22.03           C  
ATOM    136  O   LEU A1641       3.376  16.148   4.568  1.00 20.81           O  
ATOM    137  CB  LEU A1641       6.204  14.313   5.277  0.50 18.40           C  
ATOM    139  CG  LEU A1641       6.907  15.619   4.874  0.50 19.59           C  
ATOM    141  CD1 LEU A1641       6.467  16.807   5.699  0.50 18.34           C  
ATOM    143  CD2 LEU A1641       8.422  15.402   4.962  0.50 20.74           C  
ATOM    145  N   SER A1642       3.431  15.036   6.505  1.00 19.73           N  
ATOM    146  CA  SER A1642       2.707  16.091   7.144  1.00 20.92           C  
ATOM    147  C   SER A1642       3.439  16.597   8.325  1.00 18.38           C  
ATOM    148  O   SER A1642       4.203  15.836   8.954  1.00 20.55           O  
ATOM    149  CB  SER A1642       1.345  15.744   7.547  1.00 28.25           C  
ATOM    150  OG  SER A1642       1.330  14.761   8.481  1.00 30.10           O  
ATOM    151  N   ILE A1643       3.223  17.864   8.586  1.00 18.32           N  
ATOM    152  CA  ILE A1643       3.900  18.618   9.593  1.00 18.69           C  
ATOM    153  C   ILE A1643       2.985  19.109  10.663  1.00 18.83           C  
ATOM    154  O   ILE A1643       1.869  19.554  10.340  1.00 19.03           O  
ATOM    155  CB  ILE A1643       4.452  19.924   8.878  1.00 24.71           C  
ATOM    156  CG1 ILE A1643       5.302  19.510   7.681  1.00 35.03           C  
ATOM    157  CG2 ILE A1643       5.284  20.671   9.807  1.00 26.96           C  
ATOM    158  CD1 ILE A1643       6.497  18.789   8.196  1.00 30.82           C  
ATOM    159  N   VAL A1644       3.425  19.068  11.918  1.00 16.68           N  
ATOM    160  CA  VAL A1644       2.709  19.642  13.042  1.00 16.00           C  
ATOM    161  C   VAL A1644       3.691  20.548  13.788  1.00 17.19           C  
ATOM    162  O   VAL A1644       4.920  20.522  13.566  1.00 18.65           O  
ATOM    163  CB  VAL A1644       2.139  18.598  14.015  1.00 17.33           C  
ATOM    164  CG1 VAL A1644       1.001  17.835  13.329  1.00 18.63           C  
ATOM    165  CG2 VAL A1644       3.246  17.625  14.422  1.00 18.08           C  
ATOM    166  N   GLY A1645       3.249  21.400  14.671  1.00 17.74           N  
ATOM    167  CA  GLY A1645       4.081  22.139  15.602  1.00 17.13           C  
ATOM    168  C   GLY A1645       4.436  23.501  15.138  1.00 17.71           C  
ATOM    169  O   GLY A1645       3.787  24.060  14.266  1.00 20.85           O  
ATOM    170  N   GLY A1646       5.486  24.050  15.720  1.00 19.40           N  
ATOM    171  CA  GLY A1646       5.853  25.469  15.557  1.00 18.57           C  
ATOM    172  C   GLY A1646       6.123  26.090  16.912  1.00 21.67           C  
ATOM    173  O   GLY A1646       5.692  25.581  17.970  1.00 19.65           O  
ATOM    174  N   SER A1647       6.857  27.189  16.879  1.00 21.40           N  
ATOM    175  CA  SER A1647       7.211  27.903  18.117  1.00 21.61           C  
ATOM    176  C   SER A1647       5.967  28.438  18.797  1.00 24.93           C  
ATOM    177  O   SER A1647       6.008  28.818  19.985  1.00 29.30           O  
ATOM    178  CB  SER A1647       8.209  29.011  17.801  1.00 22.86           C  
ATOM    179  OG  SER A1647       7.674  29.940  16.878  1.00 24.39           O  
ATOM    180  N   ASP A1648       4.873  28.525  18.053  1.00 23.84           N  
ATOM    181  CA  ASP A1648       3.550  28.975  18.521  1.00 25.40           C  
ATOM    182  C   ASP A1648       2.686  27.840  19.069  1.00 26.59           C  
ATOM    183  O   ASP A1648       1.511  28.037  19.329  1.00 28.85           O  
ATOM    184  CB  ASP A1648       2.812  29.730  17.412  1.00 24.46           C  
ATOM    185  CG  ASP A1648       2.654  28.936  16.113  1.00 26.96           C  
ATOM    186  OD1 ASP A1648       3.534  28.186  15.742  1.00 23.83           O  
ATOM    187  OD2 ASP A1648       1.637  29.108  15.412  1.00 32.63           O  
ATOM    188  N   THR A1649       3.275  26.675  19.334  1.00 23.50           N  
ATOM    189  CA  THR A1649       2.546  25.475  19.752  1.00 23.17           C  
ATOM    190  C   THR A1649       3.187  24.796  20.971  1.00 25.02           C  
ATOM    191  O   THR A1649       4.309  25.077  21.286  1.00 24.88           O  
ATOM    192  CB  THR A1649       2.455  24.428  18.623  1.00 21.80           C  
ATOM    193  OG1 THR A1649       3.727  23.769  18.485  1.00 23.27           O  
ATOM    194  CG2 THR A1649       2.006  25.078  17.280  1.00 25.32           C  
ATOM    195  N   LEU A1650       2.459  23.831  21.544  1.00 26.59           N  
ATOM    196  CA  LEU A1650       2.912  22.985  22.686  1.00 26.12           C  
ATOM    197  C   LEU A1650       4.200  22.253  22.346  1.00 28.86           C  
ATOM    198  O   LEU A1650       5.067  22.099  23.191  1.00 31.59           O  
ATOM    199  CB  LEU A1650       1.797  21.997  23.001  1.00 26.26           C  
ATOM    200  CG  LEU A1650       1.866  21.164  24.267  1.00 33.07           C  
ATOM    201  CD1 LEU A1650       1.865  22.099  25.436  1.00 27.33           C  
ATOM    202  CD2 LEU A1650       0.661  20.191  24.330  1.00 37.08           C  
ATOM    203  N   LEU A1651       4.391  21.870  21.072  1.00 27.53           N  
ATOM    204  CA  LEU A1651       5.662  21.283  20.630  1.00 27.95           C  
ATOM    205  C   LEU A1651       6.865  22.163  20.569  1.00 26.15           C  
ATOM    206  O   LEU A1651       7.995  21.666  20.729  1.00 30.72           O  
ATOM    207  CB  LEU A1651       5.533  20.676  19.221  1.00 32.97           C  
ATOM    208  CG  LEU A1651       4.860  19.320  19.084  1.00 25.83           C  
ATOM    209  CD1 LEU A1651       4.552  18.895  17.703  1.00 22.91           C  
ATOM    210  CD2 LEU A1651       5.747  18.223  19.832  1.00 24.58           C  
ATOM    211  N   GLY A1652       6.696  23.447  20.257  1.00 23.23           N  
ATOM    212  CA  GLY A1652       7.718  24.377  20.120  1.00 26.90           C  
ATOM    213  C   GLY A1652       8.759  24.124  19.091  1.00 25.19           C  
ATOM    214  O   GLY A1652       9.860  24.631  19.215  1.00 29.11           O  
ATOM    215  N   ALA A1653       8.380  23.315  18.089  1.00 22.05           N  
ATOM    216  CA  ALA A1653       9.268  22.862  17.045  1.00 20.12           C  
ATOM    217  C   ALA A1653       8.446  22.329  15.878  1.00 16.16           C  
ATOM    218  O   ALA A1653       7.325  21.859  16.076  1.00 18.32           O  
ATOM    219  CB  ALA A1653      10.083  21.683  17.574  1.00 24.07           C  
ATOM    220  N   ILE A1654       9.031  22.324  14.688  1.00 17.28           N  
ATOM    221  CA  ILE A1654       8.390  21.789  13.462  1.00 16.30           C  
ATOM    222  C   ILE A1654       8.670  20.312  13.440  1.00 16.87           C  
ATOM    223  O   ILE A1654       9.847  19.918  13.281  1.00 16.74           O  
ATOM    224  CB  ILE A1654       8.934  22.521  12.204  1.00 17.12           C  
ATOM    225  CG1 ILE A1654       8.644  24.027  12.276  1.00 16.94           C  
ATOM    226  CG2 ILE A1654       8.310  21.893  10.937  1.00 17.66           C  
ATOM    227  CD1 ILE A1654       7.187  24.413  12.378  1.00 19.78           C  
ATOM    228  N   ILE A1655       7.668  19.462  13.604  1.00 16.76           N  
ATOM    229  CA  ILE A1655       7.840  18.035  13.692  1.00 16.08           C  
ATOM    230  C   ILE A1655       7.127  17.334  12.545  1.00 16.55           C  
ATOM    231  O   ILE A1655       5.984  17.723  12.176  1.00 16.49           O  
ATOM    232  CB  ILE A1655       7.263  17.570  15.019  1.00 16.56           C  
ATOM    233  CG1 ILE A1655       7.951  18.230  16.212  1.00 19.11           C  
ATOM    234  CG2 ILE A1655       7.284  16.067  15.206  1.00 19.02           C  
ATOM    235  CD1 ILE A1655       9.472  18.000  16.379  1.00 20.03           C  
ATOM    236  N   ILE A1656       7.711  16.260  12.060  1.00 16.78           N  
ATOM    237  CA  ILE A1656       7.076  15.400  11.085  1.00 17.09           C  
ATOM    238  C   ILE A1656       6.071  14.526  11.795  1.00 16.12           C  
ATOM    239  O   ILE A1656       6.411  13.713  12.684  1.00 18.41           O  
ATOM    240  CB  ILE A1656       8.078  14.553  10.314  1.00 18.10           C  
ATOM    241  CG1 ILE A1656       8.984  15.498   9.545  1.00 19.07           C  
ATOM    242  CG2 ILE A1656       7.302  13.593   9.351  1.00 20.41           C  
ATOM    243  CD1 ILE A1656      10.188  14.817   8.773  1.00 24.97           C  
ATOM    244  N   HIS A1657       4.767  14.684  11.473  1.00 16.94           N  
ATOM    245  CA  HIS A1657       3.716  13.859  12.077  1.00 16.95           C  
ATOM    246  C   HIS A1657       3.596  12.510  11.371  1.00 17.69           C  
ATOM    247  O   HIS A1657       3.365  11.468  12.014  1.00 18.67           O  
ATOM    248  CB  HIS A1657       2.377  14.590  12.004  1.00 15.16           C  
ATOM    249  CG  HIS A1657       1.191  13.710  12.281  1.00 16.36           C  
ATOM    250  ND1 HIS A1657       0.926  13.208  13.560  1.00 20.48           N  
ATOM    251  CD2 HIS A1657       0.218  13.203  11.465  1.00 17.57           C  
ATOM    252  CE1 HIS A1657      -0.148  12.425  13.483  1.00 22.45           C  
ATOM    253  NE2 HIS A1657      -0.592  12.403  12.236  1.00 20.80           N  
ATOM    254  N   GLU A1658       3.712  12.496  10.047  1.00 16.77           N  
ATOM    255  CA  GLU A1658       3.540  11.248   9.252  1.00 21.34           C  
ATOM    256  C   GLU A1658       4.321  11.319   7.967  1.00 17.84           C  
ATOM    257  O   GLU A1658       4.420  12.399   7.346  1.00 17.77           O  
ATOM    258  CB  GLU A1658       2.038  10.984   9.009  1.00 22.84           C  
ATOM    259  CG  GLU A1658       1.738   9.615   8.319  1.00 27.76           C  
ATOM    260  CD  GLU A1658       0.268   9.309   8.231  1.00 33.47           C  
ATOM    261  OE1 GLU A1658      -0.519  10.029   8.852  1.00 33.32           O  
ATOM    262  OE2 GLU A1658      -0.103   8.307   7.546  1.00 36.40           O  
ATOM    263  N   VAL A1659       4.870  10.159   7.600  1.00 19.34           N  
ATOM    264  CA  VAL A1659       5.513   9.903   6.319  1.00 20.49           C  
ATOM    265  C   VAL A1659       4.586   8.974   5.513  1.00 21.36           C  
ATOM    266  O   VAL A1659       4.255   7.855   5.954  1.00 23.10           O  
ATOM    267  CB  VAL A1659       6.882   9.296   6.481  1.00 19.67           C  
ATOM    268  CG1 VAL A1659       7.569   9.106   5.116  1.00 24.27           C  
ATOM    269  CG2 VAL A1659       7.780  10.183   7.428  1.00 22.76           C  
ATOM    270  N   TYR A1660       4.069   9.491   4.423  1.00 22.58           N  
ATOM    271  CA  TYR A1660       3.002   8.794   3.681  1.00 23.52           C  
ATOM    272  C   TYR A1660       3.556   7.677   2.821  1.00 26.11           C  
ATOM    273  O   TYR A1660       4.523   7.855   2.092  1.00 25.45           O  
ATOM    274  CB  TYR A1660       2.208   9.806   2.843  1.00 23.70           C  
ATOM    275  CG  TYR A1660       1.399  10.742   3.683  1.00 21.71           C  
ATOM    276  CD1 TYR A1660       0.369  10.259   4.442  1.00 24.03           C  
ATOM    277  CD2 TYR A1660       1.684  12.088   3.762  1.00 27.08           C  
ATOM    278  CE1 TYR A1660      -0.364  11.149   5.252  1.00 26.32           C  
ATOM    279  CE2 TYR A1660       0.982  12.928   4.514  1.00 25.53           C  
ATOM    280  CZ  TYR A1660      -0.043  12.494   5.236  1.00 24.39           C  
ATOM    281  OH  TYR A1660      -0.747  13.396   6.032  1.00 35.81           O  
ATOM    282  N   GLU A1661       2.859   6.543   2.791  1.00 28.84           N  
ATOM    283  CA  GLU A1661       3.305   5.414   1.986  1.00 28.13           C  
ATOM    284  C   GLU A1661       3.283   5.831   0.531  1.00 26.79           C  
ATOM    285  O   GLU A1661       2.383   6.554   0.098  1.00 31.85           O  
ATOM    286  CB  GLU A1661       2.429   4.166   2.248  0.50 30.43           C  
ATOM    288  CG  GLU A1661       2.546   3.719   3.718  0.50 32.75           C  
ATOM    290  CD  GLU A1661       1.894   2.385   4.056  0.50 40.14           C  
ATOM    292  OE1 GLU A1661       1.563   1.581   3.145  0.50 33.20           O  
ATOM    294  OE2 GLU A1661       1.736   2.149   5.276  0.50 36.62           O  
ATOM    296  N   GLU A1662       4.326   5.442  -0.196  1.00 29.49           N  
ATOM    297  CA  GLU A1662       4.466   5.702  -1.630  1.00 32.23           C  
ATOM    298  C   GLU A1662       4.872   7.122  -1.959  1.00 31.61           C  
ATOM    299  O   GLU A1662       5.073   7.454  -3.124  1.00 33.06           O  
ATOM    300  CB  GLU A1662       3.203   5.332  -2.455  1.00 37.31           C  
ATOM    301  CG  GLU A1662       2.658   3.913  -2.254  1.00 45.65           C  
ATOM    302  CD  GLU A1662       3.715   2.838  -2.436  1.00 60.41           C  
ATOM    303  OE1 GLU A1662       4.574   2.978  -3.339  1.00 74.16           O  
ATOM    304  OE2 GLU A1662       3.689   1.852  -1.670  1.00 69.95           O  
ATOM    305  N   GLY A1663       5.034   7.962  -0.947  1.00 22.32           N  
ATOM    306  CA  GLY A1663       5.556   9.315  -1.184  1.00 22.81           C  
ATOM    307  C   GLY A1663       7.090   9.339  -1.223  1.00 19.67           C  
ATOM    308  O   GLY A1663       7.754   8.330  -0.944  1.00 22.98           O  
ATOM    309  N   ALA A1664       7.638  10.488  -1.556  1.00 20.18           N  
ATOM    310  CA  ALA A1664       9.080  10.613  -1.708  1.00 22.34           C  
ATOM    311  C   ALA A1664       9.868  10.359  -0.444  1.00 21.65           C  
ATOM    312  O   ALA A1664      10.862   9.665  -0.465  1.00 22.35           O  
ATOM    313  CB  ALA A1664       9.459  11.958  -2.295  1.00 22.92           C  
ATOM    314  N   ALA A1665       9.388  10.882   0.663  1.00 23.92           N  
ATOM    315  CA  ALA A1665      10.065  10.666   1.904  1.00 18.97           C  
ATOM    316  C   ALA A1665      10.047   9.180   2.363  1.00 23.25           C  
ATOM    317  O   ALA A1665      11.023   8.646   2.922  1.00 22.71           O  
ATOM    318  CB  ALA A1665       9.442  11.623   3.018  1.00 21.27           C  
ATOM    319  N   CYS A1666       8.938   8.492   2.094  1.00 20.83           N  
ATOM    320  CA  CYS A1666       8.864   7.040   2.409  1.00 22.28           C  
ATOM    321  C   CYS A1666       9.873   6.238   1.600  1.00 24.63           C  
ATOM    322  O   CYS A1666      10.590   5.375   2.116  1.00 25.39           O  
ATOM    323  CB  CYS A1666       7.453   6.575   2.117  1.00 21.93           C  
ATOM    324  SG  CYS A1666       7.208   4.800   2.348  1.00 31.84           S  
ATOM    325  N   LYS A1667       9.931   6.539   0.314  1.00 23.11           N  
ATOM    326  CA  LYS A1667      10.775   5.774  -0.588  1.00 25.19           C  
ATOM    327  C   LYS A1667      12.251   6.003  -0.260  1.00 26.63           C  
ATOM    328  O   LYS A1667      13.066   5.090  -0.367  1.00 29.97           O  
ATOM    329  CB  LYS A1667      10.476   6.160  -2.040  0.50 24.45           C  
ATOM    331  CG  LYS A1667       9.078   5.800  -2.486  0.50 20.87           C  
ATOM    333  CD  LYS A1667       8.795   6.200  -3.939  0.50 28.59           C  
ATOM    335  CE  LYS A1667       7.561   5.493  -4.495  0.50 32.79           C  
ATOM    337  N   ASP A1668      12.591   7.229   0.141  1.00 26.14           N  
ATOM    338  CA  ASP A1668      13.934   7.491   0.633  1.00 23.35           C  
ATOM    339  C   ASP A1668      14.266   6.649   1.860  1.00 23.57           C  
ATOM    340  O   ASP A1668      15.377   6.165   1.996  1.00 28.04           O  
ATOM    341  CB  ASP A1668      14.160   9.006   0.812  1.00 23.08           C  
ATOM    342  CG  ASP A1668      15.506   9.316   1.429  1.00 27.98           C  
ATOM    343  OD1 ASP A1668      16.508   9.397   0.681  1.00 29.99           O  
ATOM    344  OD2 ASP A1668      15.572   9.334   2.671  1.00 25.73           O  
ATOM    345  N   GLY A1669      13.306   6.465   2.751  1.00 22.89           N  
ATOM    346  CA  GLY A1669      13.455   5.562   3.896  1.00 24.70           C  
ATOM    347  C   GLY A1669      14.017   6.123   5.188  1.00 25.91           C  
ATOM    348  O   GLY A1669      13.823   5.529   6.262  1.00 35.87           O  
ATOM    349  N   ARG A1670      14.674   7.266   5.118  1.00 22.77           N  
ATOM    350  CA  ARG A1670      15.417   7.811   6.263  1.00 22.06           C  
ATOM    351  C   ARG A1670      14.587   8.663   7.228  1.00 23.34           C  
ATOM    352  O   ARG A1670      14.825   8.589   8.427  1.00 29.51           O  
ATOM    353  CB  ARG A1670      16.617   8.613   5.738  1.00 23.33           C  
ATOM    354  CG  ARG A1670      17.595   7.705   4.989  1.00 27.32           C  
ATOM    355  CD  ARG A1670      18.815   8.451   4.513  1.00 28.52           C  
ATOM    356  NE  ARG A1670      18.468   9.290   3.378  1.00 29.26           N  
ATOM    357  CZ  ARG A1670      19.323  10.067   2.709  1.00 26.86           C  
ATOM    358  NH1 ARG A1670      20.579  10.153   3.102  1.00 32.28           N  
ATOM    359  NH2 ARG A1670      18.905  10.787   1.687  1.00 26.79           N  
ATOM    360  N   LEU A1671      13.614   9.410   6.731  1.00 20.28           N  
ATOM    361  CA  LEU A1671      12.803  10.285   7.593  1.00 17.63           C  
ATOM    362  C   LEU A1671      11.806   9.500   8.410  1.00 21.04           C  
ATOM    363  O   LEU A1671      11.160   8.614   7.896  1.00 22.06           O  
ATOM    364  CB  LEU A1671      12.050  11.318   6.783  1.00 20.89           C  
ATOM    365  CG  LEU A1671      12.849  12.389   6.079  1.00 24.37           C  
ATOM    366  CD1 LEU A1671      11.993  13.281   5.218  1.00 28.62           C  
ATOM    367  CD2 LEU A1671      13.593  13.254   7.095  1.00 28.23           C  
ATOM    368  N   TRP A1672      11.648   9.855   9.686  1.00 19.01           N  
ATOM    369  CA  TRP A1672      10.704   9.194  10.580  1.00 19.26           C  
ATOM    370  C   TRP A1672       9.777  10.192  11.198  1.00 18.14           C  
ATOM    371  O   TRP A1672      10.134  11.339  11.492  1.00 18.23           O  
ATOM    372  CB  TRP A1672      11.363   8.492  11.771  1.00 20.19           C  
ATOM    373  CG  TRP A1672      12.212   7.327  11.550  1.00 20.83           C  
ATOM    374  CD1 TRP A1672      12.466   6.729  10.391  1.00 24.68           C  
ATOM    375  CD2 TRP A1672      12.961   6.646  12.571  1.00 22.47           C  
ATOM    376  NE1 TRP A1672      13.362   5.664  10.593  1.00 30.47           N  
ATOM    377  CE2 TRP A1672      13.657   5.601  11.937  1.00 28.78           C  
ATOM    378  CE3 TRP A1672      13.069   6.795  13.961  1.00 22.46           C  
ATOM    379  CZ2 TRP A1672      14.482   4.701  12.657  1.00 26.84           C  
ATOM    380  CZ3 TRP A1672      13.890   5.927  14.658  1.00 27.26           C  
ATOM    381  CH2 TRP A1672      14.598   4.911  13.999  1.00 30.24           C  
ATOM    382  N   ALA A1673       8.525   9.798  11.446  1.00 16.64           N  
ATOM    383  CA  ALA A1673       7.659  10.619  12.282  1.00 16.66           C  
ATOM    384  C   ALA A1673       8.385  10.944  13.564  1.00 17.00           C  
ATOM    385  O   ALA A1673       9.037  10.081  14.138  1.00 18.04           O  
ATOM    386  CB  ALA A1673       6.320   9.885  12.562  1.00 18.31           C  
ATOM    387  N   GLY A1674       8.221  12.187  14.028  1.00 14.92           N  
ATOM    388  CA  GLY A1674       8.833  12.672  15.198  1.00 16.44           C  
ATOM    389  C   GLY A1674      10.111  13.457  14.959  1.00 17.32           C  
ATOM    390  O   GLY A1674      10.550  14.170  15.864  1.00 17.18           O  
ATOM    391  N   ASP A1675      10.685  13.327  13.776  1.00 15.42           N  
ATOM    392  CA  ASP A1675      11.894  14.115  13.463  1.00 15.54           C  
ATOM    393  C   ASP A1675      11.501  15.557  13.393  1.00 14.79           C  
ATOM    394  O   ASP A1675      10.419  15.945  12.917  1.00 16.38           O  
ATOM    395  CB  ASP A1675      12.444  13.632  12.098  1.00 17.18           C  
ATOM    396  CG  ASP A1675      13.075  12.229  12.134  1.00 17.19           C  
ATOM    397  OD1 ASP A1675      13.241  11.634  13.220  1.00 18.92           O  
ATOM    398  OD2 ASP A1675      13.439  11.750  11.018  1.00 20.34           O  
ATOM    399  N   GLN A1676      12.396  16.399  13.823  1.00 15.73           N  
ATOM    400  CA  GLN A1676      12.266  17.855  13.823  1.00 16.35           C  
ATOM    401  C   GLN A1676      12.997  18.405  12.637  1.00 16.86           C  
ATOM    402  O   GLN A1676      14.176  18.087  12.427  1.00 16.53           O  
ATOM    403  CB  GLN A1676      12.870  18.507  15.099  1.00 15.89           C  
ATOM    404  CG  GLN A1676      12.708  19.975  15.122  1.00 17.48           C  
ATOM    405  CD  GLN A1676      13.289  20.640  16.326  1.00 19.44           C  
ATOM    406  OE1 GLN A1676      13.664  19.979  17.291  1.00 21.01           O  
ATOM    407  NE2 GLN A1676      13.341  22.013  16.301  1.00 20.18           N  
ATOM    408  N   ILE A1677      12.361  19.271  11.880  1.00 15.97           N  
ATOM    409  CA  ILE A1677      13.033  19.985  10.795  1.00 15.12           C  
ATOM    410  C   ILE A1677      13.732  21.228  11.354  1.00 17.67           C  
ATOM    411  O   ILE A1677      13.079  22.158  11.803  1.00 18.70           O  
ATOM    412  CB  ILE A1677      12.064  20.406   9.676  1.00 16.16           C  
ATOM    413  CG1 ILE A1677      11.362  19.209   9.116  1.00 17.57           C  
ATOM    414  CG2 ILE A1677      12.876  21.106   8.568  1.00 19.85           C  
ATOM    415  CD1 ILE A1677      10.268  19.526   8.032  1.00 19.12           C  
ATOM    416  N   LEU A1678      15.049  21.191  11.432  1.00 16.21           N  
ATOM    417  CA  LEU A1678      15.871  22.309  11.852  1.00 17.94           C  
ATOM    418  C   LEU A1678      16.097  23.362  10.798  1.00 19.11           C  
ATOM    419  O   LEU A1678      16.082  24.535  11.071  1.00 17.99           O  
ATOM    420  CB  LEU A1678      17.232  21.858  12.364  1.00 16.72           C  
ATOM    421  CG  LEU A1678      17.276  20.800  13.442  1.00 16.24           C  
ATOM    422  CD1 LEU A1678      18.723  20.458  13.758  1.00 18.50           C  
ATOM    423  CD2 LEU A1678      16.541  21.312  14.727  1.00 19.38           C  
ATOM    424  N   GLU A1679      16.352  22.918   9.588  1.00 17.35           N  
ATOM    425  CA  GLU A1679      16.659  23.824   8.478  1.00 19.09           C  
ATOM    426  C   GLU A1679      16.220  23.190   7.200  1.00 18.07           C  
ATOM    427  O   GLU A1679      16.210  21.969   7.076  1.00 18.09           O  
ATOM    428  CB  GLU A1679      18.173  24.045   8.343  1.00 20.37           C  
ATOM    429  CG  GLU A1679      18.945  24.433   9.559  1.00 24.23           C  
ATOM    430  CD  GLU A1679      20.426  24.739   9.300  1.00 31.51           C  
ATOM    431  OE1 GLU A1679      20.911  24.674   8.142  1.00 30.86           O  
ATOM    432  OE2 GLU A1679      21.114  25.018  10.307  1.00 34.90           O  
ATOM    433  N   VAL A1680      15.958  24.042   6.212  1.00 19.13           N  
ATOM    434  CA  VAL A1680      15.567  23.618   4.855  1.00 18.90           C  
ATOM    435  C   VAL A1680      16.368  24.466   3.867  1.00 19.19           C  
ATOM    436  O   VAL A1680      16.215  25.675   3.862  1.00 20.54           O  
ATOM    437  CB  VAL A1680      14.079  23.562   4.653  0.50 24.36           C  
ATOM    439  CG1 VAL A1680      13.477  24.882   4.844  0.50 28.12           C  
ATOM    441  CG2 VAL A1680      13.780  22.967   3.264  0.50 28.17           C  
ATOM    443  N   ASN A1681      17.221  23.851   3.078  1.00 23.29           N  
ATOM    444  CA  ASN A1681      18.019  24.605   2.077  1.00 24.63           C  
ATOM    445  C   ASN A1681      18.613  25.932   2.628  1.00 30.28           C  
ATOM    446  O   ASN A1681      18.442  27.035   2.071  1.00 36.35           O  
ATOM    447  CB  ASN A1681      17.163  24.900   0.838  0.50 25.32           C  
ATOM    449  CG  ASN A1681      16.774  23.655   0.039  0.50 28.61           C  
ATOM    451  OD1 ASN A1681      17.214  23.487  -1.103  0.50 37.38           O  
ATOM    453  ND2 ASN A1681      15.889  22.833   0.581  0.50 22.03           N  
ATOM    455  N   GLY A1682      19.258  25.824   3.752  1.00 31.69           N  
ATOM    456  CA  GLY A1682      19.881  27.002   4.360  1.00 36.25           C  
ATOM    457  C   GLY A1682      18.973  27.986   5.084  1.00 34.48           C  
ATOM    458  O   GLY A1682      19.423  29.053   5.501  1.00 36.73           O  
ATOM    459  N   ILE A1683      17.709  27.631   5.306  1.00 26.27           N  
ATOM    460  CA  ILE A1683      16.811  28.523   6.003  1.00 21.60           C  
ATOM    461  C   ILE A1683      16.503  27.876   7.344  1.00 23.00           C  
ATOM    462  O   ILE A1683      16.071  26.717   7.414  1.00 22.20           O  
ATOM    463  CB  ILE A1683      15.584  28.761   5.203  1.00 22.62           C  
ATOM    464  CG1 ILE A1683      15.898  29.376   3.816  1.00 26.00           C  
ATOM    465  CG2 ILE A1683      14.578  29.622   5.929  1.00 23.64           C  
ATOM    466  CD1 ILE A1683      14.711  29.320   2.887  1.00 34.45           C  
ATOM    467  N   ASP A1684      16.779  28.611   8.411  1.00 21.57           N  
ATOM    468  CA  ASP A1684      16.587  28.130   9.781  1.00 20.80           C  
ATOM    469  C   ASP A1684      15.110  28.070  10.117  1.00 23.04           C  
ATOM    470  O   ASP A1684      14.380  29.063   9.956  1.00 24.91           O  
ATOM    471  CB  ASP A1684      17.337  29.086  10.719  1.00 23.03           C  
ATOM    472  CG  ASP A1684      17.422  28.636  12.153  1.00 26.76           C  
ATOM    473  OD1 ASP A1684      17.087  27.491  12.525  1.00 24.52           O  
ATOM    474  OD2 ASP A1684      17.934  29.463  12.997  1.00 29.92           O  
ATOM    475  N   LEU A1685      14.664  26.911  10.610  1.00 19.46           N  
ATOM    476  CA  LEU A1685      13.302  26.723  11.065  1.00 20.03           C  
ATOM    477  C   LEU A1685      13.242  26.371  12.559  1.00 18.60           C  
ATOM    478  O   LEU A1685      12.169  26.093  13.099  1.00 19.97           O  
ATOM    479  CB  LEU A1685      12.563  25.652  10.269  1.00 20.09           C  
ATOM    480  CG  LEU A1685      12.208  25.908   8.800  1.00 23.29           C  
ATOM    481  CD1 LEU A1685      11.324  24.760   8.382  1.00 23.08           C  
ATOM    482  CD2 LEU A1685      11.520  27.251   8.592  1.00 27.28           C  
ATOM    483  N   ARG A1686      14.348  26.494  13.274  1.00 17.72           N  
ATOM    484  CA  ARG A1686      14.394  26.130  14.674  1.00 19.15           C  
ATOM    485  C   ARG A1686      13.381  26.872  15.509  1.00 20.68           C  
ATOM    486  O   ARG A1686      12.835  26.294  16.412  1.00 26.70           O  
ATOM    487  CB  ARG A1686      15.811  26.286  15.279  1.00 18.26           C  
ATOM    488  CG  ARG A1686      16.837  25.265  14.787  1.00 21.15           C  
ATOM    489  CD  ARG A1686      18.311  25.661  15.107  1.00 19.29           C  
ATOM    490  NE  ARG A1686      19.288  24.731  14.541  1.00 22.31           N  
ATOM    491  CZ  ARG A1686      19.714  24.784  13.306  1.00 21.48           C  
ATOM    492  NH1 ARG A1686      19.263  25.716  12.498  1.00 25.97           N  
ATOM    493  NH2 ARG A1686      20.629  23.879  12.890  1.00 31.85           N  
ATOM    494  N   LYS A1687      13.146  28.142  15.213  1.00 20.60           N  
ATOM    495  CA  LYS A1687      12.199  28.922  15.992  1.00 22.58           C  
ATOM    496  C   LYS A1687      11.008  29.400  15.177  1.00 24.35           C  
ATOM    497  O   LYS A1687      10.294  30.324  15.572  1.00 24.22           O  
ATOM    498  CB  LYS A1687      12.950  30.081  16.628  1.00 26.77           C  
ATOM    499  CG  LYS A1687      13.963  29.635  17.694  1.00 33.65           C  
ATOM    500  CD  LYS A1687      14.505  30.804  18.520  1.00 42.89           C  
ATOM    501  CE  LYS A1687      13.453  31.353  19.449  1.00 46.45           C  
ATOM    502  NZ  LYS A1687      12.936  30.309  20.368  1.00 45.94           N  
ATOM    503  N   ALA A1688      10.767  28.757  14.031  1.00 21.69           N  
ATOM    504  CA  ALA A1688       9.679  29.158  13.153  1.00 19.44           C  
ATOM    505  C   ALA A1688       8.316  28.829  13.755  1.00 18.45           C  
ATOM    506  O   ALA A1688       8.152  27.769  14.380  1.00 19.91           O  
ATOM    507  CB  ALA A1688       9.796  28.443  11.827  1.00 19.75           C  
ATOM    508  N   THR A1689       7.333  29.693  13.465  1.00 18.98           N  
ATOM    509  CA  THR A1689       5.940  29.381  13.702  1.00 19.35           C  
ATOM    510  C   THR A1689       5.479  28.369  12.643  1.00 18.50           C  
ATOM    511  O   THR A1689       6.121  28.149  11.611  1.00 18.46           O  
ATOM    512  CB  THR A1689       5.016  30.585  13.580  1.00 21.42           C  
ATOM    513  OG1 THR A1689       5.021  31.062  12.241  1.00 21.82           O  
ATOM    514  CG2 THR A1689       5.400  31.727  14.571  1.00 22.00           C  
ATOM    515  N   HIS A1690       4.327  27.739  12.880  1.00 20.00           N  
ATOM    516  CA  HIS A1690       3.835  26.758  11.917  1.00 18.38           C  
ATOM    517  C   HIS A1690       3.697  27.387  10.522  1.00 18.98           C  
ATOM    518  O   HIS A1690       4.171  26.904   9.518  1.00 18.34           O  
ATOM    519  CB  HIS A1690       2.471  26.230  12.358  1.00 19.27           C  
ATOM    520  CG  HIS A1690       2.007  25.055  11.539  1.00 20.04           C  
ATOM    521  ND1 HIS A1690       2.325  23.742  11.861  1.00 19.71           N  
ATOM    522  CD2 HIS A1690       1.321  24.999  10.361  1.00 19.03           C  
ATOM    523  CE1 HIS A1690       1.789  22.934  10.935  1.00 19.23           C  
ATOM    524  NE2 HIS A1690       1.222  23.678   9.988  1.00 20.37           N  
ATOM    525  N   ASP A1691       3.048  28.543  10.470  1.00 22.52           N  
ATOM    526  CA  ASP A1691       2.841  29.209   9.179  1.00 20.25           C  
ATOM    527  C   ASP A1691       4.128  29.700   8.516  1.00 20.18           C  
ATOM    528  O   ASP A1691       4.268  29.597   7.289  1.00 20.13           O  
ATOM    529  CB  ASP A1691       1.873  30.359   9.375  1.00 24.93           C  
ATOM    530  CG  ASP A1691       0.425  29.955   9.154  1.00 39.89           C  
ATOM    531  OD1 ASP A1691       0.035  28.746   9.227  1.00 31.70           O  
ATOM    532  OD2 ASP A1691      -0.353  30.877   8.879  1.00 49.03           O  
ATOM    533  N   GLU A1692       5.110  30.127   9.299  1.00 20.19           N  
ATOM    534  CA  GLU A1692       6.392  30.499   8.706  1.00 21.00           C  
ATOM    535  C   GLU A1692       7.004  29.267   8.048  1.00 18.94           C  
ATOM    536  O   GLU A1692       7.562  29.340   6.976  1.00 19.57           O  
ATOM    537  CB  GLU A1692       7.286  31.065   9.787  1.00 19.86           C  
ATOM    538  CG  GLU A1692       6.885  32.450  10.162  1.00 19.15           C  
ATOM    539  CD  GLU A1692       7.539  32.935  11.468  1.00 26.76           C  
ATOM    540  OE1 GLU A1692       8.273  32.202  12.174  1.00 23.52           O  
ATOM    541  OE2 GLU A1692       7.331  34.142  11.757  1.00 32.28           O  
ATOM    542  N   ALA A1693       6.957  28.107   8.710  1.00 18.84           N  
ATOM    543  CA  ALA A1693       7.569  26.939   8.188  1.00 17.66           C  
ATOM    544  C   ALA A1693       6.893  26.463   6.953  1.00 17.52           C  
ATOM    545  O   ALA A1693       7.524  25.968   6.021  1.00 20.53           O  
ATOM    546  CB  ALA A1693       7.484  25.840   9.276  1.00 21.72           C  
ATOM    547  N   ILE A1694       5.580  26.533   6.903  1.00 18.00           N  
ATOM    548  CA  ILE A1694       4.858  26.081   5.723  1.00 18.83           C  
ATOM    549  C   ILE A1694       5.190  26.943   4.549  1.00 20.97           C  
ATOM    550  O   ILE A1694       5.327  26.446   3.440  1.00 20.94           O  
ATOM    551  CB  ILE A1694       3.330  26.064   5.928  1.00 22.21           C  
ATOM    552  CG1 ILE A1694       2.958  25.103   7.061  1.00 26.21           C  
ATOM    553  CG2 ILE A1694       2.592  25.768   4.591  1.00 24.53           C  
ATOM    554  CD1 ILE A1694       3.647  23.686   7.066  1.00 30.93           C  
ATOM    555  N   ASN A1695       5.310  28.238   4.783  1.00 19.34           N  
ATOM    556  CA  ASN A1695       5.690  29.122   3.710  1.00 19.30           C  
ATOM    557  C   ASN A1695       7.076  28.708   3.187  1.00 18.93           C  
ATOM    558  O   ASN A1695       7.265  28.625   1.952  1.00 20.64           O  
ATOM    559  CB  ASN A1695       5.590  30.574   4.155  1.00 20.18           C  
ATOM    560  CG  ASN A1695       4.226  31.134   3.923  1.00 27.78           C  
ATOM    561  OD1 ASN A1695       3.266  30.784   4.600  1.00 35.55           O  
ATOM    562  ND2 ASN A1695       4.140  32.071   2.965  1.00 31.63           N  
ATOM    563  N   VAL A1696       8.044  28.518   4.065  1.00 17.71           N  
ATOM    564  CA  VAL A1696       9.364  28.065   3.661  1.00 18.24           C  
ATOM    565  C   VAL A1696       9.300  26.776   2.871  1.00 20.85           C  
ATOM    566  O   VAL A1696       9.907  26.636   1.824  1.00 21.69           O  
ATOM    567  CB  VAL A1696      10.347  27.976   4.854  1.00 20.29           C  
ATOM    568  CG1 VAL A1696      11.647  27.260   4.460  1.00 22.30           C  
ATOM    569  CG2 VAL A1696      10.631  29.422   5.393  1.00 21.31           C  
ATOM    570  N   LEU A1697       8.555  25.800   3.395  1.00 18.83           N  
ATOM    571  CA  LEU A1697       8.502  24.515   2.739  1.00 18.53           C  
ATOM    572  C   LEU A1697       7.808  24.555   1.450  1.00 20.43           C  
ATOM    573  O   LEU A1697       8.159  23.865   0.523  1.00 21.42           O  
ATOM    574  CB  LEU A1697       7.897  23.484   3.695  1.00 19.83           C  
ATOM    575  CG  LEU A1697       8.817  23.136   4.862  1.00 21.05           C  
ATOM    576  CD1 LEU A1697       8.095  22.650   6.156  1.00 23.16           C  
ATOM    577  CD2 LEU A1697       9.915  22.111   4.378  1.00 24.75           C  
ATOM    578  N   ARG A1698       6.775  25.381   1.343  1.00 20.45           N  
ATOM    579  CA  ARG A1698       6.095  25.554   0.089  1.00 22.72           C  
ATOM    580  C   ARG A1698       6.999  26.074  -1.012  1.00 20.62           C  
ATOM    581  O   ARG A1698       6.862  25.728  -2.177  1.00 25.80           O  
ATOM    582  CB  ARG A1698       4.956  26.554   0.287  1.00 26.76           C  
ATOM    583  CG  ARG A1698       3.649  25.972   0.113  1.00 31.24           C  
ATOM    584  CD  ARG A1698       2.534  26.997   0.314  1.00 25.79           C  
ATOM    585  NE  ARG A1698       1.783  27.358  -0.890  1.00 21.94           N  
ATOM    586  CZ  ARG A1698       0.605  26.792  -1.251  1.00 17.92           C  
ATOM    587  NH1 ARG A1698       0.150  25.789  -0.560  1.00 18.90           N  
ATOM    588  NH2 ARG A1698      -0.021  27.255  -2.234  1.00 17.83           N  
ATOM    589  N   GLN A1699       7.916  26.945  -0.646  1.00 17.91           N  
ATOM    590  CA  GLN A1699       8.771  27.680  -1.553  1.00 20.50           C  
ATOM    591  C   GLN A1699      10.095  26.981  -1.902  1.00 23.34           C  
ATOM    592  O   GLN A1699      10.987  27.572  -2.490  1.00 32.77           O  
ATOM    593  CB  GLN A1699       9.007  29.087  -0.962  1.00 25.34           C  
ATOM    594  CG  GLN A1699       7.658  29.843  -0.869  1.00 25.11           C  
ATOM    595  CD  GLN A1699       7.617  31.031   0.114  1.00 42.83           C  
ATOM    596  OE1 GLN A1699       6.552  31.402   0.636  1.00 45.46           O  
ATOM    597  NE2 GLN A1699       8.736  31.606   0.367  1.00 30.41           N  
ATOM    598  N   THR A1700      10.176  25.693  -1.639  1.00 20.98           N  
ATOM    599  CA  THR A1700      11.404  24.946  -1.845  1.00 21.79           C  
ATOM    600  C   THR A1700      11.496  24.508  -3.295  1.00 21.00           C  
ATOM    601  O   THR A1700      10.480  24.378  -3.987  1.00 21.70           O  
ATOM    602  CB  THR A1700      11.461  23.707  -0.951  1.00 21.30           C  
ATOM    603  OG1 THR A1700      10.242  22.948  -1.093  1.00 23.08           O  
ATOM    604  CG2 THR A1700      11.683  24.095   0.491  1.00 22.38           C  
ATOM    605  N   PRO A1701      12.721  24.259  -3.746  1.00 18.44           N  
ATOM    606  CA  PRO A1701      12.870  23.723  -5.102  1.00 19.56           C  
ATOM    607  C   PRO A1701      12.609  22.231  -5.172  1.00 20.60           C  
ATOM    608  O   PRO A1701      12.148  21.641  -4.192  1.00 19.76           O  
ATOM    609  CB  PRO A1701      14.309  24.055  -5.396  1.00 20.75           C  
ATOM    610  CG  PRO A1701      15.002  24.004  -4.172  1.00 20.21           C  
ATOM    611  CD  PRO A1701      14.029  24.463  -3.117  1.00 20.88           C  
ATOM    612  N   GLN A1702      12.915  21.602  -6.303  1.00 17.52           N  
ATOM    613  CA  GLN A1702      12.679  20.168  -6.479  0.50 18.25           C  
ATOM    615  C   GLN A1702      13.460  19.292  -5.526  1.00 18.42           C  
ATOM    616  O   GLN A1702      12.942  18.267  -5.061  1.00 22.43           O  
ATOM    617  CB  GLN A1702      12.975  19.758  -7.924  0.50 18.35           C  
ATOM    619  CG  GLN A1702      11.815  20.045  -8.816  0.50 24.57           C  
ATOM    621  CD  GLN A1702      10.544  19.369  -8.365  0.50 16.84           C  
ATOM    623  OE1 GLN A1702       9.600  20.032  -7.908  0.50 29.70           O  
ATOM    625  NE2 GLN A1702      10.506  18.066  -8.467  0.50 16.86           N  
ATOM    627  N   ARG A1703      14.709  19.664  -5.231  1.00 19.89           N  
ATOM    628  CA  ARG A1703      15.577  18.954  -4.268  1.00 20.84           C  
ATOM    629  C   ARG A1703      15.674  19.731  -2.972  1.00 23.13           C  
ATOM    630  O   ARG A1703      16.135  20.876  -2.922  1.00 23.16           O  
ATOM    631  CB  ARG A1703      16.932  18.658  -4.850  1.00 26.24           C  
ATOM    632  CG  ARG A1703      16.796  17.598  -5.961  1.00 33.96           C  
ATOM    633  CD  ARG A1703      17.907  17.581  -7.021  1.00 32.05           C  
ATOM    634  NE  ARG A1703      18.088  18.862  -7.734  1.00 38.47           N  
ATOM    635  CZ  ARG A1703      17.218  19.362  -8.619  1.00 22.24           C  
ATOM    636  NH1 ARG A1703      17.458  20.498  -9.220  1.00 28.52           N  
ATOM    637  NH2 ARG A1703      16.135  18.716  -8.909  1.00 27.95           N  
ATOM    638  N   VAL A1704      15.180  19.083  -1.931  1.00 21.86           N  
ATOM    639  CA  VAL A1704      14.994  19.711  -0.663  1.00 23.37           C  
ATOM    640  C   VAL A1704      16.058  19.141   0.263  1.00 21.07           C  
ATOM    641  O   VAL A1704      16.009  17.964   0.579  1.00 23.86           O  
ATOM    642  CB  VAL A1704      13.573  19.500  -0.157  1.00 22.69           C  
ATOM    643  CG1 VAL A1704      13.413  20.241   1.147  1.00 26.49           C  
ATOM    644  CG2 VAL A1704      12.573  20.083  -1.212  1.00 22.27           C  
ATOM    645  N   ARG A1705      16.973  19.985   0.733  1.00 21.87           N  
ATOM    646  CA  ARG A1705      18.018  19.567   1.654  1.00 21.78           C  
ATOM    647  C   ARG A1705      17.520  19.869   3.096  1.00 21.14           C  
ATOM    648  O   ARG A1705      17.420  21.026   3.494  1.00 23.91           O  
ATOM    649  CB  ARG A1705      19.343  20.276   1.409  1.00 26.77           C  
ATOM    650  CG  ARG A1705      19.876  20.108  -0.009  1.00 33.57           C  
ATOM    651  N   LEU A1706      17.147  18.823   3.806  1.00 21.54           N  
ATOM    652  CA  LEU A1706      16.573  18.973   5.154  1.00 19.13           C  
ATOM    653  C   LEU A1706      17.634  18.636   6.174  1.00 20.80           C  
ATOM    654  O   LEU A1706      18.350  17.673   6.002  1.00 24.43           O  
ATOM    655  CB  LEU A1706      15.428  18.016   5.376  1.00 19.52           C  
ATOM    656  CG  LEU A1706      14.176  18.205   4.510  1.00 23.21           C  
ATOM    657  CD1 LEU A1706      13.216  16.993   4.591  1.00 27.26           C  
ATOM    658  CD2 LEU A1706      13.457  19.487   4.807  1.00 22.86           C  
ATOM    659  N   THR A1707      17.744  19.473   7.188  1.00 18.46           N  
ATOM    660  CA  THR A1707      18.578  19.150   8.377  1.00 17.49           C  
ATOM    661  C   THR A1707      17.596  18.853   9.484  1.00 18.56           C  
ATOM    662  O   THR A1707      16.680  19.647   9.723  1.00 18.32           O  
ATOM    663  CB  THR A1707      19.438  20.279   8.744  1.00 17.56           C  
ATOM    664  OG1 THR A1707      20.305  20.533   7.622  1.00 21.52           O  
ATOM    665  CG2 THR A1707      20.278  19.904   9.961  1.00 20.55           C  
ATOM    666  N   LEU A1708      17.723  17.673  10.081  1.00 16.77           N  
ATOM    667  CA  LEU A1708      16.735  17.096  11.022  1.00 17.34           C  
ATOM    668  C   LEU A1708      17.375  16.770  12.324  1.00 19.08           C  
ATOM    669  O   LEU A1708      18.553  16.435  12.390  1.00 19.31           O  
ATOM    670  CB  LEU A1708      16.193  15.824  10.464  1.00 18.91           C  
ATOM    671  CG  LEU A1708      15.577  15.925   9.066  1.00 23.52           C  
ATOM    672  CD1 LEU A1708      15.764  14.660   8.271  1.00 40.31           C  
ATOM    673  CD2 LEU A1708      14.159  16.386   9.082  1.00 24.17           C  
ATOM    674  N   TYR A1709      16.586  16.828  13.360  1.00 16.60           N  
ATOM    675  CA  TYR A1709      16.971  16.357  14.701  1.00 15.87           C  
ATOM    676  C   TYR A1709      16.055  15.251  15.096  1.00 16.28           C  
ATOM    677  O   TYR A1709      14.845  15.437  15.061  1.00 17.25           O  
ATOM    678  CB  TYR A1709      16.979  17.398  15.748  1.00 18.67           C  
ATOM    679  CG  TYR A1709      17.545  16.926  17.047  1.00 19.43           C  
ATOM    680  CD1 TYR A1709      18.910  16.822  17.220  1.00 22.20           C  
ATOM    681  CD2 TYR A1709      16.717  16.604  18.114  1.00 22.04           C  
ATOM    682  CE1 TYR A1709      19.437  16.438  18.423  1.00 25.75           C  
ATOM    683  CE2 TYR A1709      17.274  16.214  19.331  1.00 20.27           C  
ATOM    684  CZ  TYR A1709      18.575  16.140  19.451  1.00 20.41           C  
ATOM    685  OH  TYR A1709      19.107  15.765  20.713  1.00 27.64           O  
ATOM    686  N   ARG A1710      16.607  14.087  15.435  1.00 16.27           N  
ATOM    687  CA  ARG A1710      15.856  12.949  15.938  1.00 15.48           C  
ATOM    688  C   ARG A1710      16.048  12.831  17.434  1.00 16.15           C  
ATOM    689  O   ARG A1710      17.071  12.406  17.859  1.00 17.67           O  
ATOM    690  CB  ARG A1710      16.235  11.679  15.164  1.00 19.76           C  
ATOM    691  CG  ARG A1710      15.492  10.466  15.637  1.00 19.98           C  
ATOM    692  CD  ARG A1710      15.751   9.293  14.717  1.00 22.02           C  
ATOM    693  NE  ARG A1710      15.223   9.589  13.397  1.00 22.37           N  
ATOM    694  CZ  ARG A1710      15.460   8.839  12.339  1.00 21.88           C  
ATOM    695  NH1 ARG A1710      16.221   7.746  12.438  1.00 23.22           N  
ATOM    696  NH2 ARG A1710      14.950   9.197  11.175  1.00 25.03           N  
ATOM    697  N   ASP A1711      15.003  13.172  18.186  1.00 18.03           N  
ATOM    698  CA  ASP A1711      14.992  12.975  19.628  1.00 16.59           C  
ATOM    699  C   ASP A1711      14.825  11.477  19.912  1.00 17.63           C  
ATOM    700  O   ASP A1711      14.233  10.764  19.044  1.00 19.21           O  
ATOM    701  CB  ASP A1711      13.780  13.754  20.226  1.00 18.26           C  
ATOM    702  CG  ASP A1711      13.843  13.881  21.690  1.00 21.43           C  
ATOM    703  OD1 ASP A1711      14.435  14.879  22.193  1.00 22.78           O  
ATOM    704  OD2 ASP A1711      13.418  12.934  22.399  1.00 22.96           O  
ATOM    705  N   GLU A1712      15.330  10.991  21.034  1.00 19.23           N  
ATOM    706  CA  GLU A1712      15.138   9.589  21.341  1.00 22.38           C  
ATOM    707  C   GLU A1712      13.687   9.285  21.582  1.00 24.37           C  
ATOM    708  O   GLU A1712      13.274   8.128  21.466  1.00 25.30           O  
ATOM    709  CB  GLU A1712      15.949   9.149  22.533  1.00 24.39           C  
ATOM    710  CG  GLU A1712      15.419   9.560  23.867  1.00 28.35           C  
ATOM    711  CD  GLU A1712      15.855   8.674  25.012  1.00 37.67           C  
ATOM    712  OE1 GLU A1712      15.183   8.731  26.055  1.00 37.68           O  
ATOM    713  OE2 GLU A1712      16.825   7.895  24.859  1.00 35.38           O  
ATOM    714  N   ALA A1713      12.881  10.271  21.951  1.00 18.36           N  
ATOM    715  CA  ALA A1713      11.465   9.964  22.196  1.00 20.97           C  
ATOM    716  C   ALA A1713      10.744   9.399  21.021  1.00 22.68           C  
ATOM    717  O   ALA A1713      10.879   9.873  19.929  1.00 22.69           O  
ATOM    718  CB  ALA A1713      10.782  11.223  22.695  1.00 21.74           C  
ATOM    719  N   PRO A1714       9.857   8.390  21.246  1.00 21.13           N  
ATOM    720  CA  PRO A1714       9.014   7.944  20.159  1.00 23.90           C  
ATOM    721  C   PRO A1714       7.956   8.961  19.770  1.00 21.19           C  
ATOM    722  O   PRO A1714       7.530   9.738  20.646  1.00 21.58           O  
ATOM    723  CB  PRO A1714       8.337   6.682  20.739  1.00 23.72           C  
ATOM    724  CG  PRO A1714       8.375   6.887  22.119  1.00 25.06           C  
ATOM    725  CD  PRO A1714       9.583   7.679  22.488  1.00 23.66           C  
ATOM    726  N   TYR A1715       7.434   8.902  18.549  1.00 20.58           N  
ATOM    727  CA  TYR A1715       6.315   9.667  18.118  1.00 21.89           C  
ATOM    728  C   TYR A1715       5.238   8.742  17.668  1.00 25.54           C  
ATOM    729  O   TYR A1715       5.342   8.172  16.540  1.00 28.10           O  
ATOM    730  CB  TYR A1715       6.658  10.584  16.919  1.00 27.44           C  
ATOM    731  CG  TYR A1715       5.542  11.512  16.560  1.00 22.76           C  
ATOM    732  CD1 TYR A1715       5.475  12.757  17.066  1.00 28.13           C  
ATOM    733  CD2 TYR A1715       4.494  11.124  15.710  1.00 27.20           C  
ATOM    734  CE1 TYR A1715       4.440  13.621  16.774  1.00 29.19           C  
ATOM    735  CE2 TYR A1715       3.436  11.958  15.421  1.00 24.23           C  
ATOM    736  CZ  TYR A1715       3.383  13.243  15.885  1.00 21.84           C  
ATOM    737  OH  TYR A1715       2.355  14.092  15.675  1.00 25.98           O  
ATOM    738  N   LYS A1716       4.203   8.693  18.513  1.00 20.77           N  
ATOM    739  CA  LYS A1716       3.188   7.772  18.544  1.00 22.29           C  
ATOM    740  C   LYS A1716       1.922   8.342  17.904  1.00 18.98           C  
ATOM    741  O   LYS A1716       1.555   9.460  18.187  1.00 20.68           O  
ATOM    742  CB  LYS A1716       2.917   7.545  20.050  1.00 25.79           C  
ATOM    743  CG  LYS A1716       4.096   7.028  20.919  1.00 32.97           C  
ATOM    744  CD  LYS A1716       4.116   5.498  20.939  1.00 22.82           C  
ATOM    745  CE  LYS A1716       5.276   5.028  21.784  1.00 20.72           C  
ATOM    746  NZ  LYS A1716       5.629   3.729  21.257  1.00 29.36           N  
ATOM    747  N   SER A1717       1.241   7.574  17.117  1.00 18.80           N  
ATOM    748  CA  SER A1717      -0.001   7.935  16.514  1.00 19.23           C  
ATOM    749  C   SER A1717      -0.891   6.684  16.397  1.00 19.42           C  
ATOM    750  O   SER A1717      -0.439   5.673  15.844  1.00 22.78           O  
ATOM    751  CB  SER A1717       0.320   8.561  15.186  1.00 26.46           C  
ATOM    752  OG  SER A1717      -0.827   8.957  14.532  1.00 30.30           O  
ATOM    753  N   THR A1718      -2.120   6.694  16.922  1.00 15.52           N  
ATOM    754  CA  THR A1718      -3.013   5.565  16.973  1.00 15.46           C  
ATOM    755  C   THR A1718      -4.401   5.975  16.583  1.00 19.03           C  
ATOM    756  O   THR A1718      -4.976   6.896  17.217  1.00 18.84           O  
ATOM    757  CB  THR A1718      -3.022   4.908  18.384  1.00 18.55           C  
ATOM    758  OG1 THR A1718      -1.667   4.557  18.757  1.00 17.90           O  
ATOM    759  CG2 THR A1718      -3.902   3.670  18.414  1.00 20.71           C  
ATOM    760  N   ARG A1719      -5.052   5.236  15.687  1.00 18.59           N  
ATOM    761  CA  ARG A1719      -6.435   5.434  15.360  1.00 20.16           C  
ATOM    762  C   ARG A1719      -7.274   4.597  16.255  1.00 20.66           C  
ATOM    763  O   ARG A1719      -7.057   3.363  16.401  1.00 23.65           O  
ATOM    764  CB  ARG A1719      -6.669   5.026  13.884  1.00 24.91           C  
ATOM    765  CG  ARG A1719      -8.098   5.194  13.402  1.00 30.48           C  
ATOM    766  CD  ARG A1719      -8.207   5.286  11.856  1.00 34.91           C  
ATOM    767  NE  ARG A1719      -9.616   5.435  11.475  1.00 43.01           N  
ATOM    768  CZ  ARG A1719     -10.055   6.062  10.382  1.00 25.76           C  
ATOM    769  NH1 ARG A1719      -9.215   6.588   9.508  1.00 42.55           N  
ATOM    770  NH2 ARG A1719     -11.364   6.133  10.172  1.00 35.76           N  
ATOM    771  N   LEU A1720      -8.274   5.174  16.873  1.00 20.88           N  
ATOM    772  CA  LEU A1720      -9.277   4.366  17.537  1.00 27.40           C  
ATOM    773  C   LEU A1720     -10.705   4.798  17.234  1.00 32.73           C  
ATOM    774  O   LEU A1720     -11.660   4.169  17.742  1.00 35.02           O  
ATOM    775  CB  LEU A1720      -9.007   4.232  19.034  1.00 35.38           C  
ATOM    776  CG  LEU A1720      -8.730   5.446  19.899  1.00 30.38           C  
ATOM    777  CD1 LEU A1720     -10.022   6.146  20.215  1.00 39.69           C  
ATOM    778  CD2 LEU A1720      -8.041   5.041  21.190  1.00 34.98           C  
ATOM    779  OXT LEU A1720     -10.903   5.701  16.399  1.00 28.47           O  
TER     780      LEU A1720                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
