
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  114 ( 1729),  selected  114 , name 2cq2_A
# Molecule2: number of CA atoms   71 (  558),  selected   71 , name T0487_26_96.pdb
# PARAMETERS: 2cq2_A.T0487_26_96.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    18_A      P      26           -
LGA    S    19_A      -       -           -
LGA    S    20_A      -       -           -
LGA    G    21_A      -       -           -
LGA    S    22_A      -       -           -
LGA    S    23_A      -       -           -
LGA    G    24_A      -       -           -
LGA    A    25_A      -       -           -
LGA    K    26_A      -       -           -
LGA    H    27_A      -       -           -
LGA    T    28_A      -       -           -
LGA    L    29_A      -       -           -
LGA    L    30_A      -       -           -
LGA    R    31_A      -       -           -
LGA    H    32_A      -       -           -
LGA    E    33_A      -       -           -
LGA    G    34_A      -       -           -
LGA    I    35_A      -       -           -
LGA    E    36_A      -       -           -
LGA    T    37_A      -       -           -
LGA    V    38_A      -       -           -
LGA    S    39_A      -       -           -
LGA    Y    40_A      -       -           -
LGA    A    41_A      -       -           -
LGA    T    42_A      -       -           -
LGA    Q    43_A      W      27          2.553
LGA    S    44_A      R      28          1.843
LGA    L    45_A      L      29          1.231
LGA    V    46_A      E      30          1.203
LGA    V    47_A      V      31          1.213
LGA    A    48_A      V      32          0.809
LGA    N    49_A      L      33          1.151
LGA    G    50_A      D      34           #
LGA    G    51_A      P      35           -
LGA    -       -      P      36           -
LGA    -       -      P      37           -
LGA    L    52_A      G      38           #
LGA    G    53_A      R      39          2.433
LGA    N    54_A      E      40           #
LGA    G    55_A      E      41          1.775
LGA    V    56_A      V      42          3.878
LGA    S    57_A      Y      43          3.663
LGA    -       -      P      44           -
LGA    -       -      L      45           -
LGA    R    58_A      L      46          4.928
LGA    N    59_A      A      47          4.103
LGA    Q    60_A      Q      48          2.929
LGA    L    61_A      V      49          3.192
LGA    L    62_A      A      50          3.190
LGA    P    63_A      R      51          2.705
LGA    V    64_A      R      52          2.107
LGA    L    65_A      A      53          3.733
LGA    E    66_A      -       -           -
LGA    K    67_A      -       -           -
LGA    C    68_A      G      54          1.762
LGA    G    69_A      G      55          0.459
LGA    L    70_A      V      56          0.731
LGA    V    71_A      T      57          2.040
LGA    D    72_A      -       -           -
LGA    A    73_A      V      58          4.482
LGA    L    74_A      R      59          2.087
LGA    L    75_A      M      60          0.936
LGA    M    76_A      G      61          2.745
LGA    P    77_A      D      62          3.651
LGA    P    78_A      -       -           -
LGA    N    79_A      -       -           -
LGA    K    80_A      -       -           -
LGA    P    81_A      -       -           -
LGA    Y    82_A      -       -           -
LGA    S    83_A      -       -           -
LGA    F    84_A      G      63          1.717
LGA    A    85_A      L      64          1.243
LGA    R    86_A      A      65          1.493
LGA    Y    87_A      S      66          1.239
LGA    R    88_A      W      67          0.983
LGA    T    89_A      S      68          2.831
LGA    T    90_A      P      69          2.142
LGA    E    91_A      -       -           -
LGA    E    92_A      -       -           -
LGA    S    93_A      P      70          2.251
LGA    K    94_A      E      71          2.300
LGA    R    95_A      V      72          2.431
LGA    A    96_A      L      73          1.738
LGA    Y    97_A      -       -           -
LGA    V    98_A      -       -           -
LGA    T    99_A      V      74          2.506
LGA    L   100_A      L      75          3.380
LGA    N   101_A      E      76          1.645
LGA    G   102_A      -       -           -
LGA    K   103_A      G      77          1.195
LGA    E   104_A      T      78          1.028
LGA    V   105_A      L      79          0.804
LGA    V   106_A      A      80          0.842
LGA    D   107_A      R      81          2.825
LGA    D   108_A      -       -           -
LGA    L   109_A      M      82          4.578
LGA    G   110_A      G      83          2.231
LGA    Q   111_A      Q      84          2.121
LGA    K   112_A      T      85          1.856
LGA    I   113_A      Y      86          0.787
LGA    T   114_A      A      87          1.131
LGA    L   115_A      Y      88          0.671
LGA    Y   116_A      R      89          0.775
LGA    L   117_A      L      90          0.486
LGA    N   118_A      Y      91          0.801
LGA    F   119_A      P      92          1.272
LGA    V   120_A      K      93          0.354
LGA    E   121_A      G      94          2.244
LGA    -       -      R      95           -
LGA    K   122_A      R      96          5.054
LGA    V   123_A      -       -           -
LGA    Q   124_A      -       -           -
LGA    W   125_A      -       -           -
LGA    S   126_A      -       -           -
LGA    G   127_A      -       -           -
LGA    P   128_A      -       -           -
LGA    S   129_A      -       -           -
LGA    S   130_A      -       -           -
LGA    G   131_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  114   71    5.0     61    2.39    14.75     62.482     2.454

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.965451 * X  +   0.193226 * Y  +   0.174837 * Z  +  59.094402
  Y_new =  -0.055814 * X  +  -0.808705 * Y  +   0.585560 * Z  +  14.047530
  Z_new =   0.254537 * X  +   0.555571 * Y  +   0.791550 * Z  +  58.312576 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.611985   -2.529608  [ DEG:    35.0642   -144.9358 ]
  Theta =  -0.257369   -2.884224  [ DEG:   -14.7461   -165.2539 ]
  Phi   =  -3.083846    0.057747  [ DEG:  -176.6913      3.3087 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cq2_A                                        
REMARK     2: T0487_26_96.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cq2_A.T0487_26_96.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  114   71   5.0   61   2.39   14.75  62.482
REMARK  ---------------------------------------------------------- 
MOLECULE 2cq2_A
HEADER    RNA BINDING PROTEIN                     19-MAY-05   2CQ2              
TITLE     SOLUTION STRUCTURE OF RNA BINDING DOMAIN IN HYPOTHETICAL              
TITLE    2 PROTEIN LOC91801                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN LOC91801;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RNA RECOGNITION MOTIF;                                     
COMPND   5 SYNONYM: HYPOTHETICAL PROTEIN BC015183;                              
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: LOC9180;                                                       
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P041012-04;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    RRM DOMAIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT             
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.TSUDA,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,M.SHIROUZU,                  
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   19-NOV-05 2CQ2    0                                                
JRNL        AUTH   K.TSUDA,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,                    
JRNL        AUTH 2 M.SHIROUZU,S.YOKOYAMA                                        
JRNL        TITL   SOLUTION STRUCTURE OF RNA BINDING DOMAIN IN                  
JRNL        TITL 2 HYPOTHETICAL PROTEIN LOC91801                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2CQ2 A   25   125  UNP    Q8N989   Q8N989_HUMAN    25    125             
SEQRES   1 A  114  GLY SER SER GLY SER SER GLY ALA LYS HIS THR LEU LEU          
SEQRES   2 A  114  ARG HIS GLU GLY ILE GLU THR VAL SER TYR ALA THR GLN          
SEQRES   3 A  114  SER LEU VAL VAL ALA ASN GLY GLY LEU GLY ASN GLY VAL          
SEQRES   4 A  114  SER ARG ASN GLN LEU LEU PRO VAL LEU GLU LYS CYS GLY          
SEQRES   5 A  114  LEU VAL ASP ALA LEU LEU MET PRO PRO ASN LYS PRO TYR          
SEQRES   6 A  114  SER PHE ALA ARG TYR ARG THR THR GLU GLU SER LYS ARG          
SEQRES   7 A  114  ALA TYR VAL THR LEU ASN GLY LYS GLU VAL VAL ASP ASP          
SEQRES   8 A  114  LEU GLY GLN LYS ILE THR LEU TYR LEU ASN PHE VAL GLU          
SEQRES   9 A  114  LYS VAL GLN TRP SER GLY PRO SER SER GLY                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  18      72.822   6.430  79.576  1.00  0.00           N  
ATOM      2  CA  GLY A  18      73.831   6.424  78.534  1.00  0.00           C  
ATOM      3  C   GLY A  18      73.602   7.508  77.499  1.00  0.00           C  
ATOM      4  O   GLY A  18      72.718   7.390  76.652  1.00  0.00           O  
ATOM      5  HA2 GLY A  18      74.801   6.571  78.986  1.00  0.00           H  
ATOM      6  HA3 GLY A  18      73.816   5.463  78.041  1.00  0.00           H  
ATOM      7  H1  GLY A  18      72.317   7.250  79.761  1.00  0.00           H  
ATOM      8  N   SER A  19      74.402   8.568  77.568  1.00  0.00           N  
ATOM      9  CA  SER A  19      74.281   9.680  76.633  1.00  0.00           C  
ATOM     10  C   SER A  19      74.990   9.366  75.320  1.00  0.00           C  
ATOM     11  O   SER A  19      76.114   9.810  75.087  1.00  0.00           O  
ATOM     12  CB  SER A  19      74.860  10.956  77.246  1.00  0.00           C  
ATOM     13  OG  SER A  19      74.255  11.241  78.495  1.00  0.00           O  
ATOM     14  H   SER A  19      75.090   8.603  78.266  1.00  0.00           H  
ATOM     15  HA  SER A  19      73.230   9.832  76.433  1.00  0.00           H  
ATOM     16  HB2 SER A  19      75.921  10.832  77.394  1.00  0.00           H  
ATOM     17  HB3 SER A  19      74.683  11.786  76.578  1.00  0.00           H  
ATOM     18  HG  SER A  19      73.302  11.167  78.415  1.00  0.00           H  
ATOM     19  N   SER A  20      74.324   8.598  74.464  1.00  0.00           N  
ATOM     20  CA  SER A  20      74.891   8.221  73.174  1.00  0.00           C  
ATOM     21  C   SER A  20      73.865   8.391  72.058  1.00  0.00           C  
ATOM     22  O   SER A  20      72.677   8.139  72.249  1.00  0.00           O  
ATOM     23  CB  SER A  20      75.383   6.773  73.214  1.00  0.00           C  
ATOM     24  OG  SER A  20      76.002   6.411  71.990  1.00  0.00           O  
ATOM     25  H   SER A  20      73.430   8.276  74.705  1.00  0.00           H  
ATOM     26  HA  SER A  20      75.730   8.871  72.977  1.00  0.00           H  
ATOM     27  HB2 SER A  20      76.099   6.661  74.013  1.00  0.00           H  
ATOM     28  HB3 SER A  20      74.544   6.114  73.387  1.00  0.00           H  
ATOM     29  HG  SER A  20      76.953   6.511  72.072  1.00  0.00           H  
ATOM     30  N   GLY A  21      74.334   8.820  70.890  1.00  0.00           N  
ATOM     31  CA  GLY A  21      73.446   9.017  69.759  1.00  0.00           C  
ATOM     32  C   GLY A  21      74.196   9.321  68.478  1.00  0.00           C  
ATOM     33  O   GLY A  21      75.108  10.148  68.467  1.00  0.00           O  
ATOM     34  H   GLY A  21      75.293   9.005  70.795  1.00  0.00           H  
ATOM     35  HA2 GLY A  21      72.858   8.123  69.618  1.00  0.00           H  
ATOM     36  HA3 GLY A  21      72.782   9.841  69.979  1.00  0.00           H  
ATOM     37  N   SER A  22      73.812   8.651  67.397  1.00  0.00           N  
ATOM     38  CA  SER A  22      74.459   8.849  66.105  1.00  0.00           C  
ATOM     39  C   SER A  22      73.430   9.173  65.027  1.00  0.00           C  
ATOM     40  O   SER A  22      72.271   8.770  65.119  1.00  0.00           O  
ATOM     41  CB  SER A  22      75.253   7.602  65.711  1.00  0.00           C  
ATOM     42  OG  SER A  22      74.449   6.438  65.796  1.00  0.00           O  
ATOM     43  H   SER A  22      73.079   8.005  67.471  1.00  0.00           H  
ATOM     44  HA  SER A  22      75.139   9.684  66.200  1.00  0.00           H  
ATOM     45  HB2 SER A  22      75.605   7.709  64.696  1.00  0.00           H  
ATOM     46  HB3 SER A  22      76.097   7.492  66.376  1.00  0.00           H  
ATOM     47  HG  SER A  22      73.887   6.494  66.572  1.00  0.00           H  
ATOM     48  N   SER A  23      73.863   9.903  64.003  1.00  0.00           N  
ATOM     49  CA  SER A  23      72.980  10.285  62.908  1.00  0.00           C  
ATOM     50  C   SER A  23      71.689  10.901  63.440  1.00  0.00           C  
ATOM     51  O   SER A  23      70.593  10.548  63.005  1.00  0.00           O  
ATOM     52  CB  SER A  23      72.657   9.068  62.039  1.00  0.00           C  
ATOM     53  OG  SER A  23      73.819   8.298  61.786  1.00  0.00           O  
ATOM     54  H   SER A  23      74.800  10.194  63.987  1.00  0.00           H  
ATOM     55  HA  SER A  23      73.495  11.019  62.307  1.00  0.00           H  
ATOM     56  HB2 SER A  23      71.933   8.448  62.545  1.00  0.00           H  
ATOM     57  HB3 SER A  23      72.249   9.402  61.095  1.00  0.00           H  
ATOM     58  HG  SER A  23      73.585   7.527  61.264  1.00  0.00           H  
ATOM     59  N   GLY A  24      71.828  11.825  64.386  1.00  0.00           N  
ATOM     60  CA  GLY A  24      70.667  12.477  64.962  1.00  0.00           C  
ATOM     61  C   GLY A  24      70.286  13.743  64.224  1.00  0.00           C  
ATOM     62  O   GLY A  24      70.922  14.108  63.235  1.00  0.00           O  
ATOM     63  H   GLY A  24      72.728  12.067  64.694  1.00  0.00           H  
ATOM     64  HA2 GLY A  24      69.833  11.791  64.936  1.00  0.00           H  
ATOM     65  HA3 GLY A  24      70.883  12.725  65.992  1.00  0.00           H  
ATOM     66  N   ALA A  25      69.244  14.415  64.701  1.00  0.00           N  
ATOM     67  CA  ALA A  25      68.779  15.648  64.079  1.00  0.00           C  
ATOM     68  C   ALA A  25      69.826  16.750  64.195  1.00  0.00           C  
ATOM     69  O   ALA A  25      70.929  16.523  64.693  1.00  0.00           O  
ATOM     70  CB  ALA A  25      67.468  16.095  64.709  1.00  0.00           C  
ATOM     71  H   ALA A  25      68.777  14.072  65.493  1.00  0.00           H  
ATOM     72  HA  ALA A  25      68.596  15.446  63.034  1.00  0.00           H  
ATOM     73  HB1 ALA A  25      66.765  15.274  64.698  1.00  0.00           H  
ATOM     74  HB2 ALA A  25      67.644  16.404  65.728  1.00  0.00           H  
ATOM     75  HB3 ALA A  25      67.061  16.922  64.147  1.00  0.00           H  
ATOM     76  N   LYS A  26      69.473  17.945  63.734  1.00  0.00           N  
ATOM     77  CA  LYS A  26      70.382  19.084  63.786  1.00  0.00           C  
ATOM     78  C   LYS A  26      70.210  19.859  65.089  1.00  0.00           C  
ATOM     79  O   LYS A  26      71.188  20.286  65.703  1.00  0.00           O  
ATOM     80  CB  LYS A  26      70.139  20.013  62.593  1.00  0.00           C  
ATOM     81  CG  LYS A  26      71.050  21.227  62.572  1.00  0.00           C  
ATOM     82  CD  LYS A  26      72.373  20.921  61.890  1.00  0.00           C  
ATOM     83  CE  LYS A  26      73.472  21.862  62.358  1.00  0.00           C  
ATOM     84  NZ  LYS A  26      73.526  23.105  61.538  1.00  0.00           N  
ATOM     85  H   LYS A  26      68.579  18.065  63.349  1.00  0.00           H  
ATOM     86  HA  LYS A  26      71.392  18.707  63.737  1.00  0.00           H  
ATOM     87  HB2 LYS A  26      70.296  19.455  61.681  1.00  0.00           H  
ATOM     88  HB3 LYS A  26      69.115  20.356  62.623  1.00  0.00           H  
ATOM     89  HG2 LYS A  26      70.558  22.026  62.037  1.00  0.00           H  
ATOM     90  HG3 LYS A  26      71.243  21.538  63.589  1.00  0.00           H  
ATOM     91  HD2 LYS A  26      72.661  19.906  62.121  1.00  0.00           H  
ATOM     92  HD3 LYS A  26      72.250  21.028  60.822  1.00  0.00           H  
ATOM     93  HE2 LYS A  26      73.287  22.128  63.387  1.00  0.00           H  
ATOM     94  HE3 LYS A  26      74.421  21.351  62.284  1.00  0.00           H  
ATOM     95  HZ1 LYS A  26      74.514  23.384  61.378  1.00  0.00           H  
ATOM     96  HZ2 LYS A  26      73.034  23.877  62.031  1.00  0.00           H  
ATOM     97  HZ3 LYS A  26      73.068  22.946  60.619  1.00  0.00           H  
ATOM     98  N   HIS A  27      68.960  20.036  65.507  1.00  0.00           N  
ATOM     99  CA  HIS A  27      68.660  20.758  66.738  1.00  0.00           C  
ATOM    100  C   HIS A  27      68.194  19.799  67.829  1.00  0.00           C  
ATOM    101  O   HIS A  27      68.030  18.602  67.590  1.00  0.00           O  
ATOM    102  CB  HIS A  27      67.590  21.820  66.484  1.00  0.00           C  
ATOM    103  CG  HIS A  27      66.666  21.481  65.355  1.00  0.00           C  
ATOM    104  ND1 HIS A  27      65.534  20.708  65.515  1.00  0.00           N  
ATOM    105  CD2 HIS A  27      66.709  21.815  64.045  1.00  0.00           C  
ATOM    106  CE1 HIS A  27      64.922  20.582  64.351  1.00  0.00           C  
ATOM    107  NE2 HIS A  27      65.616  21.244  63.442  1.00  0.00           N  
ATOM    108  H   HIS A  27      68.223  19.673  64.973  1.00  0.00           H  
ATOM    109  HA  HIS A  27      69.566  21.243  67.067  1.00  0.00           H  
ATOM    110  HB2 HIS A  27      66.994  21.940  67.376  1.00  0.00           H  
ATOM    111  HB3 HIS A  27      68.072  22.758  66.250  1.00  0.00           H  
ATOM    112  HD2 HIS A  27      67.464  22.419  63.561  1.00  0.00           H  
ATOM    113  HE1 HIS A  27      64.012  20.030  64.172  1.00  0.00           H  
ATOM    114  HE2 HIS A  27      65.431  21.243  62.480  1.00  0.00           H  
ATOM    115  N   THR A  28      67.981  20.333  69.028  1.00  0.00           N  
ATOM    116  CA  THR A  28      67.535  19.525  70.156  1.00  0.00           C  
ATOM    117  C   THR A  28      66.013  19.483  70.234  1.00  0.00           C  
ATOM    118  O   THR A  28      65.437  18.576  70.837  1.00  0.00           O  
ATOM    119  CB  THR A  28      68.093  20.063  71.487  1.00  0.00           C  
ATOM    120  OG1 THR A  28      68.009  21.493  71.510  1.00  0.00           O  
ATOM    121  CG2 THR A  28      69.537  19.631  71.684  1.00  0.00           C  
ATOM    122  H   THR A  28      68.128  21.293  69.156  1.00  0.00           H  
ATOM    123  HA  THR A  28      67.907  18.521  70.014  1.00  0.00           H  
ATOM    124  HB  THR A  28      67.499  19.664  72.296  1.00  0.00           H  
ATOM    125  HG1 THR A  28      68.658  21.860  70.906  1.00  0.00           H  
ATOM    126 HG21 THR A  28      70.146  20.033  70.888  1.00  0.00           H  
ATOM    127 HG22 THR A  28      69.594  18.552  71.671  1.00  0.00           H  
ATOM    128 HG23 THR A  28      69.896  19.998  72.633  1.00  0.00           H  
ATOM    129  N   LEU A  29      65.366  20.469  69.624  1.00  0.00           N  
ATOM    130  CA  LEU A  29      63.909  20.544  69.623  1.00  0.00           C  
ATOM    131  C   LEU A  29      63.293  19.150  69.604  1.00  0.00           C  
ATOM    132  O   LEU A  29      62.242  18.916  70.203  1.00  0.00           O  
ATOM    133  CB  LEU A  29      63.421  21.348  68.418  1.00  0.00           C  
ATOM    134  CG  LEU A  29      63.262  22.854  68.634  1.00  0.00           C  
ATOM    135  CD1 LEU A  29      64.587  23.567  68.410  1.00  0.00           C  
ATOM    136  CD2 LEU A  29      62.190  23.415  67.711  1.00  0.00           C  
ATOM    137  H   LEU A  29      65.879  21.164  69.161  1.00  0.00           H  
ATOM    138  HA  LEU A  29      63.604  21.048  70.528  1.00  0.00           H  
ATOM    139  HB2 LEU A  29      64.127  21.203  67.615  1.00  0.00           H  
ATOM    140  HB3 LEU A  29      62.458  20.952  68.125  1.00  0.00           H  
ATOM    141  HG  LEU A  29      62.955  23.034  69.655  1.00  0.00           H  
ATOM    142 HD11 LEU A  29      64.952  23.346  67.419  1.00  0.00           H  
ATOM    143 HD12 LEU A  29      65.305  23.229  69.142  1.00  0.00           H  
ATOM    144 HD13 LEU A  29      64.444  24.633  68.513  1.00  0.00           H  
ATOM    145 HD21 LEU A  29      61.378  23.808  68.303  1.00  0.00           H  
ATOM    146 HD22 LEU A  29      61.820  22.629  67.070  1.00  0.00           H  
ATOM    147 HD23 LEU A  29      62.612  24.205  67.108  1.00  0.00           H  
ATOM    148  N   LEU A  30      63.951  18.226  68.913  1.00  0.00           N  
ATOM    149  CA  LEU A  30      63.470  16.854  68.817  1.00  0.00           C  
ATOM    150  C   LEU A  30      63.673  16.111  70.134  1.00  0.00           C  
ATOM    151  O   LEU A  30      62.748  15.494  70.661  1.00  0.00           O  
ATOM    152  CB  LEU A  30      64.189  16.116  67.686  1.00  0.00           C  
ATOM    153  CG  LEU A  30      63.791  16.517  66.265  1.00  0.00           C  
ATOM    154  CD1 LEU A  30      62.376  16.054  65.956  1.00  0.00           C  
ATOM    155  CD2 LEU A  30      63.914  18.023  66.080  1.00  0.00           C  
ATOM    156  H   LEU A  30      64.783  18.473  68.457  1.00  0.00           H  
ATOM    157  HA  LEU A  30      62.412  16.888  68.598  1.00  0.00           H  
ATOM    158  HB2 LEU A  30      65.247  16.297  67.795  1.00  0.00           H  
ATOM    159  HB3 LEU A  30      63.991  15.060  67.801  1.00  0.00           H  
ATOM    160  HG  LEU A  30      64.459  16.038  65.563  1.00  0.00           H  
ATOM    161 HD11 LEU A  30      62.275  15.890  64.894  1.00  0.00           H  
ATOM    162 HD12 LEU A  30      61.672  16.811  66.272  1.00  0.00           H  
ATOM    163 HD13 LEU A  30      62.175  15.134  66.485  1.00  0.00           H  
ATOM    164 HD21 LEU A  30      64.933  18.326  66.270  1.00  0.00           H  
ATOM    165 HD22 LEU A  30      63.253  18.525  66.772  1.00  0.00           H  
ATOM    166 HD23 LEU A  30      63.644  18.284  65.068  1.00  0.00           H  
ATOM    167  N   ARG A  31      64.892  16.177  70.661  1.00  0.00           N  
ATOM    168  CA  ARG A  31      65.219  15.512  71.916  1.00  0.00           C  
ATOM    169  C   ARG A  31      64.195  15.854  72.996  1.00  0.00           C  
ATOM    170  O   ARG A  31      63.688  14.971  73.688  1.00  0.00           O  
ATOM    171  CB  ARG A  31      66.619  15.913  72.381  1.00  0.00           C  
ATOM    172  CG  ARG A  31      67.326  14.833  73.186  1.00  0.00           C  
ATOM    173  CD  ARG A  31      67.997  13.812  72.279  1.00  0.00           C  
ATOM    174  NE  ARG A  31      68.508  12.667  73.027  1.00  0.00           N  
ATOM    175  CZ  ARG A  31      69.145  11.647  72.465  1.00  0.00           C  
ATOM    176  NH1 ARG A  31      69.348  11.629  71.155  1.00  0.00           N  
ATOM    177  NH2 ARG A  31      69.580  10.641  73.213  1.00  0.00           N  
ATOM    178  H   ARG A  31      65.589  16.684  70.193  1.00  0.00           H  
ATOM    179  HA  ARG A  31      65.197  14.445  71.742  1.00  0.00           H  
ATOM    180  HB2 ARG A  31      67.223  16.138  71.515  1.00  0.00           H  
ATOM    181  HB3 ARG A  31      66.542  16.796  72.997  1.00  0.00           H  
ATOM    182  HG2 ARG A  31      68.078  15.295  73.808  1.00  0.00           H  
ATOM    183  HG3 ARG A  31      66.602  14.328  73.807  1.00  0.00           H  
ATOM    184  HD2 ARG A  31      67.275  13.465  71.555  1.00  0.00           H  
ATOM    185  HD3 ARG A  31      68.818  14.291  71.766  1.00  0.00           H  
ATOM    186  HE  ARG A  31      68.369  12.661  73.997  1.00  0.00           H  
ATOM    187 HH11 ARG A  31      69.023  12.387  70.589  1.00  0.00           H  
ATOM    188 HH12 ARG A  31      69.829  10.860  70.734  1.00  0.00           H  
ATOM    189 HH21 ARG A  31      69.428  10.651  74.202  1.00  0.00           H  
ATOM    190 HH22 ARG A  31      70.059   9.873  72.789  1.00  0.00           H  
ATOM    191  N   HIS A  32      63.896  17.142  73.132  1.00  0.00           N  
ATOM    192  CA  HIS A  32      62.933  17.602  74.127  1.00  0.00           C  
ATOM    193  C   HIS A  32      61.589  16.902  73.946  1.00  0.00           C  
ATOM    194  O   HIS A  32      61.199  16.066  74.761  1.00  0.00           O  
ATOM    195  CB  HIS A  32      62.749  19.116  74.028  1.00  0.00           C  
ATOM    196  CG  HIS A  32      63.995  19.892  74.327  1.00  0.00           C  
ATOM    197  ND1 HIS A  32      64.447  20.926  73.534  1.00  0.00           N  
ATOM    198  CD2 HIS A  32      64.886  19.780  75.340  1.00  0.00           C  
ATOM    199  CE1 HIS A  32      65.562  21.415  74.046  1.00  0.00           C  
ATOM    200  NE2 HIS A  32      65.849  20.737  75.143  1.00  0.00           N  
ATOM    201  H   HIS A  32      64.333  17.798  72.550  1.00  0.00           H  
ATOM    202  HA  HIS A  32      63.323  17.359  75.104  1.00  0.00           H  
ATOM    203  HB2 HIS A  32      62.434  19.369  73.026  1.00  0.00           H  
ATOM    204  HB3 HIS A  32      61.988  19.427  74.729  1.00  0.00           H  
ATOM    205  HD2 HIS A  32      64.846  19.068  76.153  1.00  0.00           H  
ATOM    206  HE1 HIS A  32      66.140  22.231  73.638  1.00  0.00           H  
ATOM    207  HE2 HIS A  32      66.669  20.838  75.670  1.00  0.00           H  
ATOM    208  N   GLU A  33      60.885  17.249  72.872  1.00  0.00           N  
ATOM    209  CA  GLU A  33      59.585  16.654  72.587  1.00  0.00           C  
ATOM    210  C   GLU A  33      59.562  15.181  72.982  1.00  0.00           C  
ATOM    211  O   GLU A  33      58.560  14.680  73.492  1.00  0.00           O  
ATOM    212  CB  GLU A  33      59.249  16.800  71.101  1.00  0.00           C  
ATOM    213  CG  GLU A  33      59.014  18.237  70.668  1.00  0.00           C  
ATOM    214  CD  GLU A  33      57.657  18.762  71.096  1.00  0.00           C  
ATOM    215  OE1 GLU A  33      56.757  17.937  71.358  1.00  0.00           O  
ATOM    216  OE2 GLU A  33      57.497  19.998  71.170  1.00  0.00           O  
ATOM    217  H   GLU A  33      61.249  17.920  72.258  1.00  0.00           H  
ATOM    218  HA  GLU A  33      58.845  17.183  73.167  1.00  0.00           H  
ATOM    219  HB2 GLU A  33      60.064  16.398  70.518  1.00  0.00           H  
ATOM    220  HB3 GLU A  33      58.354  16.233  70.890  1.00  0.00           H  
ATOM    221  HG2 GLU A  33      59.779  18.861  71.106  1.00  0.00           H  
ATOM    222  HG3 GLU A  33      59.081  18.291  69.591  1.00  0.00           H  
ATOM    223  N   GLY A  34      60.674  14.493  72.744  1.00  0.00           N  
ATOM    224  CA  GLY A  34      60.761  13.083  73.080  1.00  0.00           C  
ATOM    225  C   GLY A  34      60.529  12.185  71.882  1.00  0.00           C  
ATOM    226  O   GLY A  34      59.950  11.106  72.010  1.00  0.00           O  
ATOM    227  H   GLY A  34      61.442  14.943  72.336  1.00  0.00           H  
ATOM    228  HA2 GLY A  34      61.741  12.881  73.485  1.00  0.00           H  
ATOM    229  HA3 GLY A  34      60.019  12.859  73.833  1.00  0.00           H  
ATOM    230  N   ILE A  35      60.978  12.632  70.714  1.00  0.00           N  
ATOM    231  CA  ILE A  35      60.815  11.860  69.488  1.00  0.00           C  
ATOM    232  C   ILE A  35      62.000  10.928  69.264  1.00  0.00           C  
ATOM    233  O   ILE A  35      63.134  11.380  69.098  1.00  0.00           O  
ATOM    234  CB  ILE A  35      60.659  12.780  68.261  1.00  0.00           C  
ATOM    235  CG1 ILE A  35      59.274  13.431  68.259  1.00  0.00           C  
ATOM    236  CG2 ILE A  35      60.883  11.993  66.978  1.00  0.00           C  
ATOM    237  CD1 ILE A  35      59.125  14.526  67.226  1.00  0.00           C  
ATOM    238  H   ILE A  35      61.431  13.499  70.676  1.00  0.00           H  
ATOM    239  HA  ILE A  35      59.917  11.267  69.585  1.00  0.00           H  
ATOM    240  HB  ILE A  35      61.411  13.551  68.319  1.00  0.00           H  
ATOM    241 HG12 ILE A  35      58.529  12.677  68.052  1.00  0.00           H  
ATOM    242 HG13 ILE A  35      59.086  13.861  69.230  1.00  0.00           H  
ATOM    243 HG21 ILE A  35      60.162  12.302  66.237  1.00  0.00           H  
ATOM    244 HG22 ILE A  35      61.881  12.184  66.611  1.00  0.00           H  
ATOM    245 HG23 ILE A  35      60.767  10.939  67.177  1.00  0.00           H  
ATOM    246 HD11 ILE A  35      59.180  14.100  66.236  1.00  0.00           H  
ATOM    247 HD12 ILE A  35      58.170  15.015  67.356  1.00  0.00           H  
ATOM    248 HD13 ILE A  35      59.918  15.249  67.351  1.00  0.00           H  
ATOM    249  N   GLU A  36      61.731   9.627  69.255  1.00  0.00           N  
ATOM    250  CA  GLU A  36      62.776   8.631  69.050  1.00  0.00           C  
ATOM    251  C   GLU A  36      62.861   8.229  67.580  1.00  0.00           C  
ATOM    252  O   GLU A  36      61.857   7.873  66.962  1.00  0.00           O  
ATOM    253  CB  GLU A  36      62.512   7.395  69.914  1.00  0.00           C  
ATOM    254  CG  GLU A  36      62.531   7.681  71.406  1.00  0.00           C  
ATOM    255  CD  GLU A  36      61.327   8.481  71.864  1.00  0.00           C  
ATOM    256  OE1 GLU A  36      60.255   8.345  71.238  1.00  0.00           O  
ATOM    257  OE2 GLU A  36      61.456   9.241  72.844  1.00  0.00           O  
ATOM    258  H   GLU A  36      60.806   9.330  69.393  1.00  0.00           H  
ATOM    259  HA  GLU A  36      63.715   9.072  69.345  1.00  0.00           H  
ATOM    260  HB2 GLU A  36      61.543   6.993  69.657  1.00  0.00           H  
ATOM    261  HB3 GLU A  36      63.268   6.655  69.701  1.00  0.00           H  
ATOM    262  HG2 GLU A  36      62.546   6.743  71.939  1.00  0.00           H  
ATOM    263  HG3 GLU A  36      63.426   8.240  71.641  1.00  0.00           H  
ATOM    264  N   THR A  37      64.068   8.288  67.026  1.00  0.00           N  
ATOM    265  CA  THR A  37      64.286   7.933  65.629  1.00  0.00           C  
ATOM    266  C   THR A  37      65.400   6.900  65.492  1.00  0.00           C  
ATOM    267  O   THR A  37      66.429   6.990  66.161  1.00  0.00           O  
ATOM    268  CB  THR A  37      64.642   9.169  64.783  1.00  0.00           C  
ATOM    269  OG1 THR A  37      65.973   9.603  65.087  1.00  0.00           O  
ATOM    270  CG2 THR A  37      63.661  10.303  65.044  1.00  0.00           C  
ATOM    271  H   THR A  37      64.829   8.579  67.571  1.00  0.00           H  
ATOM    272  HA  THR A  37      63.368   7.511  65.245  1.00  0.00           H  
ATOM    273  HB  THR A  37      64.590   8.900  63.738  1.00  0.00           H  
ATOM    274  HG1 THR A  37      66.153   9.458  66.018  1.00  0.00           H  
ATOM    275 HG21 THR A  37      62.808  10.198  64.389  1.00  0.00           H  
ATOM    276 HG22 THR A  37      64.147  11.249  64.853  1.00  0.00           H  
ATOM    277 HG23 THR A  37      63.334  10.266  66.072  1.00  0.00           H  
ATOM    278  N   VAL A  38      65.186   5.918  64.622  1.00  0.00           N  
ATOM    279  CA  VAL A  38      66.173   4.868  64.396  1.00  0.00           C  
ATOM    280  C   VAL A  38      67.242   5.323  63.410  1.00  0.00           C  
ATOM    281  O   VAL A  38      67.198   6.443  62.903  1.00  0.00           O  
ATOM    282  CB  VAL A  38      65.512   3.582  63.865  1.00  0.00           C  
ATOM    283  CG1 VAL A  38      64.632   2.952  64.933  1.00  0.00           C  
ATOM    284  CG2 VAL A  38      64.710   3.878  62.607  1.00  0.00           C  
ATOM    285  H   VAL A  38      64.346   5.899  64.119  1.00  0.00           H  
ATOM    286  HA  VAL A  38      66.642   4.643  65.342  1.00  0.00           H  
ATOM    287  HB  VAL A  38      66.293   2.880  63.612  1.00  0.00           H  
ATOM    288 HG11 VAL A  38      64.372   3.699  65.670  1.00  0.00           H  
ATOM    289 HG12 VAL A  38      63.733   2.566  64.476  1.00  0.00           H  
ATOM    290 HG13 VAL A  38      65.169   2.147  65.412  1.00  0.00           H  
ATOM    291 HG21 VAL A  38      64.588   2.968  62.037  1.00  0.00           H  
ATOM    292 HG22 VAL A  38      63.740   4.264  62.880  1.00  0.00           H  
ATOM    293 HG23 VAL A  38      65.233   4.609  62.008  1.00  0.00           H  
ATOM    294  N   SER A  39      68.203   4.445  63.142  1.00  0.00           N  
ATOM    295  CA  SER A  39      69.287   4.757  62.218  1.00  0.00           C  
ATOM    296  C   SER A  39      69.029   4.137  60.848  1.00  0.00           C  
ATOM    297  O   SER A  39      69.326   4.738  59.815  1.00  0.00           O  
ATOM    298  CB  SER A  39      70.621   4.255  62.773  1.00  0.00           C  
ATOM    299  OG  SER A  39      71.709   4.973  62.218  1.00  0.00           O  
ATOM    300  H   SER A  39      68.184   3.567  63.577  1.00  0.00           H  
ATOM    301  HA  SER A  39      69.333   5.831  62.110  1.00  0.00           H  
ATOM    302  HB2 SER A  39      70.632   4.382  63.846  1.00  0.00           H  
ATOM    303  HB3 SER A  39      70.736   3.208  62.534  1.00  0.00           H  
ATOM    304  HG  SER A  39      71.496   5.231  61.318  1.00  0.00           H  
ATOM    305  N   TYR A  40      68.475   2.930  60.847  1.00  0.00           N  
ATOM    306  CA  TYR A  40      68.178   2.225  59.605  1.00  0.00           C  
ATOM    307  C   TYR A  40      67.061   2.925  58.836  1.00  0.00           C  
ATOM    308  O   TYR A  40      66.556   3.963  59.259  1.00  0.00           O  
ATOM    309  CB  TYR A  40      67.783   0.778  59.898  1.00  0.00           C  
ATOM    310  CG  TYR A  40      66.796   0.637  61.034  1.00  0.00           C  
ATOM    311  CD1 TYR A  40      65.428   0.747  60.810  1.00  0.00           C  
ATOM    312  CD2 TYR A  40      67.229   0.395  62.332  1.00  0.00           C  
ATOM    313  CE1 TYR A  40      64.523   0.620  61.846  1.00  0.00           C  
ATOM    314  CE2 TYR A  40      66.331   0.265  63.373  1.00  0.00           C  
ATOM    315  CZ  TYR A  40      64.979   0.379  63.124  1.00  0.00           C  
ATOM    316  OH  TYR A  40      64.080   0.250  64.159  1.00  0.00           O  
ATOM    317  H   TYR A  40      68.260   2.501  61.702  1.00  0.00           H  
ATOM    318  HA  TYR A  40      69.073   2.228  59.001  1.00  0.00           H  
ATOM    319  HB2 TYR A  40      67.335   0.348  59.016  1.00  0.00           H  
ATOM    320  HB3 TYR A  40      68.668   0.214  60.156  1.00  0.00           H  
ATOM    321  HD1 TYR A  40      65.074   0.935  59.807  1.00  0.00           H  
ATOM    322  HD2 TYR A  40      68.289   0.305  62.523  1.00  0.00           H  
ATOM    323  HE1 TYR A  40      63.464   0.709  61.652  1.00  0.00           H  
ATOM    324  HE2 TYR A  40      66.687   0.077  64.376  1.00  0.00           H  
ATOM    325  HH  TYR A  40      64.242  -0.574  64.624  1.00  0.00           H  
ATOM    326  N   ALA A  41      66.681   2.344  57.702  1.00  0.00           N  
ATOM    327  CA  ALA A  41      65.623   2.909  56.873  1.00  0.00           C  
ATOM    328  C   ALA A  41      64.255   2.384  57.299  1.00  0.00           C  
ATOM    329  O   ALA A  41      64.093   1.196  57.579  1.00  0.00           O  
ATOM    330  CB  ALA A  41      65.877   2.597  55.407  1.00  0.00           C  
ATOM    331  H   ALA A  41      67.122   1.517  57.417  1.00  0.00           H  
ATOM    332  HA  ALA A  41      65.639   3.982  56.996  1.00  0.00           H  
ATOM    333  HB1 ALA A  41      66.788   2.022  55.314  1.00  0.00           H  
ATOM    334  HB2 ALA A  41      65.050   2.027  55.011  1.00  0.00           H  
ATOM    335  HB3 ALA A  41      65.977   3.519  54.855  1.00  0.00           H  
ATOM    336  N   THR A  42      63.271   3.277  57.343  1.00  0.00           N  
ATOM    337  CA  THR A  42      61.918   2.904  57.735  1.00  0.00           C  
ATOM    338  C   THR A  42      60.880   3.621  56.879  1.00  0.00           C  
ATOM    339  O   THR A  42      60.887   4.847  56.778  1.00  0.00           O  
ATOM    340  CB  THR A  42      61.654   3.226  59.217  1.00  0.00           C  
ATOM    341  OG1 THR A  42      61.696   4.642  59.427  1.00  0.00           O  
ATOM    342  CG2 THR A  42      62.681   2.545  60.110  1.00  0.00           C  
ATOM    343  H   THR A  42      63.461   4.209  57.107  1.00  0.00           H  
ATOM    344  HA  THR A  42      61.812   1.838  57.594  1.00  0.00           H  
ATOM    345  HB  THR A  42      60.672   2.860  59.480  1.00  0.00           H  
ATOM    346  HG1 THR A  42      62.588   4.961  59.271  1.00  0.00           H  
ATOM    347 HG21 THR A  42      62.430   2.722  61.146  1.00  0.00           H  
ATOM    348 HG22 THR A  42      63.660   2.946  59.902  1.00  0.00           H  
ATOM    349 HG23 THR A  42      62.678   1.482  59.916  1.00  0.00           H  
ATOM    350  N   GLN A  43      59.990   2.848  56.264  1.00  0.00           N  
ATOM    351  CA  GLN A  43      58.946   3.412  55.417  1.00  0.00           C  
ATOM    352  C   GLN A  43      58.426   4.724  55.992  1.00  0.00           C  
ATOM    353  O   GLN A  43      58.111   5.657  55.253  1.00  0.00           O  
ATOM    354  CB  GLN A  43      57.795   2.417  55.261  1.00  0.00           C  
ATOM    355  CG  GLN A  43      58.043   1.359  54.199  1.00  0.00           C  
ATOM    356  CD  GLN A  43      57.069   0.201  54.289  1.00  0.00           C  
ATOM    357  OE1 GLN A  43      56.985  -0.476  55.315  1.00  0.00           O  
ATOM    358  NE2 GLN A  43      56.327  -0.034  53.213  1.00  0.00           N  
ATOM    359  H   GLN A  43      60.037   1.877  56.384  1.00  0.00           H  
ATOM    360  HA  GLN A  43      59.377   3.605  54.446  1.00  0.00           H  
ATOM    361  HB2 GLN A  43      57.635   1.920  56.205  1.00  0.00           H  
ATOM    362  HB3 GLN A  43      56.900   2.960  54.994  1.00  0.00           H  
ATOM    363  HG2 GLN A  43      57.946   1.815  53.225  1.00  0.00           H  
ATOM    364  HG3 GLN A  43      59.047   0.977  54.318  1.00  0.00           H  
ATOM    365 HE21 GLN A  43      56.450   0.547  52.432  1.00  0.00           H  
ATOM    366 HE22 GLN A  43      55.690  -0.777  53.243  1.00  0.00           H  
ATOM    367  N   SER A  44      58.339   4.790  57.317  1.00  0.00           N  
ATOM    368  CA  SER A  44      57.852   5.988  57.994  1.00  0.00           C  
ATOM    369  C   SER A  44      58.987   6.983  58.218  1.00  0.00           C  
ATOM    370  O   SER A  44      60.146   6.596  58.366  1.00  0.00           O  
ATOM    371  CB  SER A  44      57.209   5.618  59.332  1.00  0.00           C  
ATOM    372  OG  SER A  44      56.308   4.535  59.183  1.00  0.00           O  
ATOM    373  H   SER A  44      58.604   4.013  57.852  1.00  0.00           H  
ATOM    374  HA  SER A  44      57.108   6.445  57.360  1.00  0.00           H  
ATOM    375  HB2 SER A  44      57.980   5.335  60.032  1.00  0.00           H  
ATOM    376  HB3 SER A  44      56.668   6.470  59.715  1.00  0.00           H  
ATOM    377  HG  SER A  44      56.763   3.711  59.371  1.00  0.00           H  
ATOM    378  N   LEU A  45      58.643   8.265  58.243  1.00  0.00           N  
ATOM    379  CA  LEU A  45      59.631   9.318  58.451  1.00  0.00           C  
ATOM    380  C   LEU A  45      59.059  10.443  59.307  1.00  0.00           C  
ATOM    381  O   LEU A  45      57.843  10.554  59.472  1.00  0.00           O  
ATOM    382  CB  LEU A  45      60.102   9.876  57.106  1.00  0.00           C  
ATOM    383  CG  LEU A  45      60.884   8.909  56.215  1.00  0.00           C  
ATOM    384  CD1 LEU A  45      60.870   9.385  54.771  1.00  0.00           C  
ATOM    385  CD2 LEU A  45      62.313   8.762  56.716  1.00  0.00           C  
ATOM    386  H   LEU A  45      57.703   8.511  58.119  1.00  0.00           H  
ATOM    387  HA  LEU A  45      60.475   8.883  58.965  1.00  0.00           H  
ATOM    388  HB2 LEU A  45      59.229  10.196  56.559  1.00  0.00           H  
ATOM    389  HB3 LEU A  45      60.734  10.729  57.306  1.00  0.00           H  
ATOM    390  HG  LEU A  45      60.414   7.937  56.250  1.00  0.00           H  
ATOM    391 HD11 LEU A  45      60.052   8.917  54.246  1.00  0.00           H  
ATOM    392 HD12 LEU A  45      61.803   9.118  54.296  1.00  0.00           H  
ATOM    393 HD13 LEU A  45      60.747  10.458  54.746  1.00  0.00           H  
ATOM    394 HD21 LEU A  45      62.812   7.985  56.155  1.00  0.00           H  
ATOM    395 HD22 LEU A  45      62.302   8.498  57.764  1.00  0.00           H  
ATOM    396 HD23 LEU A  45      62.839   9.696  56.585  1.00  0.00           H  
ATOM    397  N   VAL A  46      59.942  11.275  59.849  1.00  0.00           N  
ATOM    398  CA  VAL A  46      59.523  12.392  60.688  1.00  0.00           C  
ATOM    399  C   VAL A  46      60.101  13.709  60.178  1.00  0.00           C  
ATOM    400  O   VAL A  46      61.318  13.879  60.110  1.00  0.00           O  
ATOM    401  CB  VAL A  46      59.955  12.188  62.152  1.00  0.00           C  
ATOM    402  CG1 VAL A  46      61.467  12.274  62.280  1.00  0.00           C  
ATOM    403  CG2 VAL A  46      59.275  13.209  63.054  1.00  0.00           C  
ATOM    404  H   VAL A  46      60.896  11.133  59.683  1.00  0.00           H  
ATOM    405  HA  VAL A  46      58.445  12.448  60.656  1.00  0.00           H  
ATOM    406  HB  VAL A  46      59.645  11.202  62.463  1.00  0.00           H  
ATOM    407 HG11 VAL A  46      61.929  11.730  61.469  1.00  0.00           H  
ATOM    408 HG12 VAL A  46      61.774  13.309  62.242  1.00  0.00           H  
ATOM    409 HG13 VAL A  46      61.775  11.842  63.222  1.00  0.00           H  
ATOM    410 HG21 VAL A  46      59.603  14.201  62.783  1.00  0.00           H  
ATOM    411 HG22 VAL A  46      58.204  13.139  62.936  1.00  0.00           H  
ATOM    412 HG23 VAL A  46      59.538  13.012  64.082  1.00  0.00           H  
ATOM    413  N   VAL A  47      59.219  14.636  59.818  1.00  0.00           N  
ATOM    414  CA  VAL A  47      59.642  15.938  59.315  1.00  0.00           C  
ATOM    415  C   VAL A  47      59.936  16.900  60.461  1.00  0.00           C  
ATOM    416  O   VAL A  47      59.038  17.285  61.209  1.00  0.00           O  
ATOM    417  CB  VAL A  47      58.572  16.559  58.399  1.00  0.00           C  
ATOM    418  CG1 VAL A  47      59.186  17.630  57.511  1.00  0.00           C  
ATOM    419  CG2 VAL A  47      57.896  15.483  57.562  1.00  0.00           C  
ATOM    420  H   VAL A  47      58.263  14.440  59.895  1.00  0.00           H  
ATOM    421  HA  VAL A  47      60.544  15.795  58.736  1.00  0.00           H  
ATOM    422  HB  VAL A  47      57.822  17.026  59.022  1.00  0.00           H  
ATOM    423 HG11 VAL A  47      60.046  17.223  56.999  1.00  0.00           H  
ATOM    424 HG12 VAL A  47      58.456  17.959  56.785  1.00  0.00           H  
ATOM    425 HG13 VAL A  47      59.493  18.469  58.119  1.00  0.00           H  
ATOM    426 HG21 VAL A  47      57.205  15.945  56.874  1.00  0.00           H  
ATOM    427 HG22 VAL A  47      58.645  14.936  57.008  1.00  0.00           H  
ATOM    428 HG23 VAL A  47      57.361  14.805  58.211  1.00  0.00           H  
ATOM    429  N   ALA A  48      61.201  17.286  60.591  1.00  0.00           N  
ATOM    430  CA  ALA A  48      61.614  18.206  61.644  1.00  0.00           C  
ATOM    431  C   ALA A  48      61.538  19.653  61.169  1.00  0.00           C  
ATOM    432  O   ALA A  48      61.603  19.928  59.972  1.00  0.00           O  
ATOM    433  CB  ALA A  48      63.025  17.876  62.109  1.00  0.00           C  
ATOM    434  H   ALA A  48      61.873  16.944  59.964  1.00  0.00           H  
ATOM    435  HA  ALA A  48      60.946  18.075  62.482  1.00  0.00           H  
ATOM    436  HB1 ALA A  48      63.400  18.684  62.720  1.00  0.00           H  
ATOM    437  HB2 ALA A  48      63.009  16.965  62.689  1.00  0.00           H  
ATOM    438  HB3 ALA A  48      63.667  17.745  61.250  1.00  0.00           H  
ATOM    439  N   ASN A  49      61.397  20.574  62.116  1.00  0.00           N  
ATOM    440  CA  ASN A  49      61.309  21.994  61.795  1.00  0.00           C  
ATOM    441  C   ASN A  49      60.154  22.265  60.836  1.00  0.00           C  
ATOM    442  O   ASN A  49      60.175  23.231  60.077  1.00  0.00           O  
ATOM    443  CB  ASN A  49      62.622  22.481  61.177  1.00  0.00           C  
ATOM    444  CG  ASN A  49      63.687  22.750  62.221  1.00  0.00           C  
ATOM    445  OD1 ASN A  49      63.427  22.678  63.423  1.00  0.00           O  
ATOM    446  ND2 ASN A  49      64.896  23.063  61.768  1.00  0.00           N  
ATOM    447  H   ASN A  49      61.351  20.294  63.054  1.00  0.00           H  
ATOM    448  HA  ASN A  49      61.133  22.532  62.713  1.00  0.00           H  
ATOM    449  HB2 ASN A  49      62.994  21.728  60.498  1.00  0.00           H  
ATOM    450  HB3 ASN A  49      62.440  23.393  60.630  1.00  0.00           H  
ATOM    451 HD21 ASN A  49      65.030  23.101  60.798  1.00  0.00           H  
ATOM    452 HD22 ASN A  49      65.604  23.240  62.421  1.00  0.00           H  
ATOM    453  N   GLY A  50      59.142  21.402  60.880  1.00  0.00           N  
ATOM    454  CA  GLY A  50      57.990  21.566  60.013  1.00  0.00           C  
ATOM    455  C   GLY A  50      56.681  21.546  60.776  1.00  0.00           C  
ATOM    456  O   GLY A  50      56.500  22.301  61.731  1.00  0.00           O  
ATOM    457  H   GLY A  50      59.178  20.649  61.507  1.00  0.00           H  
ATOM    458  HA2 GLY A  50      58.076  22.507  59.492  1.00  0.00           H  
ATOM    459  HA3 GLY A  50      57.984  20.764  59.288  1.00  0.00           H  
ATOM    460  N   GLY A  51      55.765  20.680  60.356  1.00  0.00           N  
ATOM    461  CA  GLY A  51      54.476  20.583  61.017  1.00  0.00           C  
ATOM    462  C   GLY A  51      53.673  21.864  60.913  1.00  0.00           C  
ATOM    463  O   GLY A  51      54.235  22.945  60.733  1.00  0.00           O  
ATOM    464  H   GLY A  51      55.965  20.102  59.590  1.00  0.00           H  
ATOM    465  HA2 GLY A  51      53.912  19.779  60.566  1.00  0.00           H  
ATOM    466  HA3 GLY A  51      54.637  20.355  62.061  1.00  0.00           H  
ATOM    467  N   LEU A  52      52.356  21.745  61.027  1.00  0.00           N  
ATOM    468  CA  LEU A  52      51.473  22.904  60.944  1.00  0.00           C  
ATOM    469  C   LEU A  52      52.026  24.070  61.755  1.00  0.00           C  
ATOM    470  O   LEU A  52      52.133  25.190  61.257  1.00  0.00           O  
ATOM    471  CB  LEU A  52      50.074  22.539  61.443  1.00  0.00           C  
ATOM    472  CG  LEU A  52      49.378  21.389  60.713  1.00  0.00           C  
ATOM    473  CD1 LEU A  52      48.265  20.808  61.570  1.00  0.00           C  
ATOM    474  CD2 LEU A  52      48.832  21.859  59.374  1.00  0.00           C  
ATOM    475  H   LEU A  52      51.965  20.857  61.170  1.00  0.00           H  
ATOM    476  HA  LEU A  52      51.411  23.198  59.907  1.00  0.00           H  
ATOM    477  HB2 LEU A  52      50.153  22.269  62.484  1.00  0.00           H  
ATOM    478  HB3 LEU A  52      49.449  23.418  61.346  1.00  0.00           H  
ATOM    479  HG  LEU A  52      50.097  20.604  60.525  1.00  0.00           H  
ATOM    480 HD11 LEU A  52      48.345  19.733  61.585  1.00  0.00           H  
ATOM    481 HD12 LEU A  52      47.307  21.093  61.158  1.00  0.00           H  
ATOM    482 HD13 LEU A  52      48.349  21.189  62.578  1.00  0.00           H  
ATOM    483 HD21 LEU A  52      48.471  22.873  59.468  1.00  0.00           H  
ATOM    484 HD22 LEU A  52      48.019  21.215  59.070  1.00  0.00           H  
ATOM    485 HD23 LEU A  52      49.616  21.825  58.632  1.00  0.00           H  
ATOM    486  N   GLY A  53      52.380  23.798  63.008  1.00  0.00           N  
ATOM    487  CA  GLY A  53      52.922  24.834  63.866  1.00  0.00           C  
ATOM    488  C   GLY A  53      53.905  25.733  63.143  1.00  0.00           C  
ATOM    489  O   GLY A  53      53.977  26.930  63.415  1.00  0.00           O  
ATOM    490  H   GLY A  53      52.273  22.886  63.350  1.00  0.00           H  
ATOM    491  HA2 GLY A  53      52.108  25.436  64.243  1.00  0.00           H  
ATOM    492  HA3 GLY A  53      53.425  24.368  64.702  1.00  0.00           H  
ATOM    493  N   ASN A  54      54.665  25.154  62.219  1.00  0.00           N  
ATOM    494  CA  ASN A  54      55.649  25.910  61.456  1.00  0.00           C  
ATOM    495  C   ASN A  54      55.026  26.499  60.195  1.00  0.00           C  
ATOM    496  O   ASN A  54      55.684  26.626  59.165  1.00  0.00           O  
ATOM    497  CB  ASN A  54      56.833  25.014  61.083  1.00  0.00           C  
ATOM    498  CG  ASN A  54      57.600  24.532  62.298  1.00  0.00           C  
ATOM    499  OD1 ASN A  54      57.010  24.220  63.333  1.00  0.00           O  
ATOM    500  ND2 ASN A  54      58.920  24.468  62.178  1.00  0.00           N  
ATOM    501  H   ASN A  54      54.560  24.194  62.047  1.00  0.00           H  
ATOM    502  HA  ASN A  54      56.004  26.718  62.079  1.00  0.00           H  
ATOM    503  HB2 ASN A  54      56.468  24.151  60.545  1.00  0.00           H  
ATOM    504  HB3 ASN A  54      57.510  25.568  60.449  1.00  0.00           H  
ATOM    505 HD21 ASN A  54      59.321  24.733  61.323  1.00  0.00           H  
ATOM    506 HD22 ASN A  54      59.440  24.158  62.949  1.00  0.00           H  
ATOM    507  N   GLY A  55      53.749  26.858  60.285  1.00  0.00           N  
ATOM    508  CA  GLY A  55      53.056  27.431  59.145  1.00  0.00           C  
ATOM    509  C   GLY A  55      53.206  26.589  57.894  1.00  0.00           C  
ATOM    510  O   GLY A  55      53.258  27.119  56.783  1.00  0.00           O  
ATOM    511  H   GLY A  55      53.272  26.733  61.133  1.00  0.00           H  
ATOM    512  HA2 GLY A  55      52.007  27.519  59.383  1.00  0.00           H  
ATOM    513  HA3 GLY A  55      53.456  28.416  58.954  1.00  0.00           H  
ATOM    514  N   VAL A  56      53.281  25.274  58.071  1.00  0.00           N  
ATOM    515  CA  VAL A  56      53.427  24.358  56.946  1.00  0.00           C  
ATOM    516  C   VAL A  56      52.171  23.513  56.758  1.00  0.00           C  
ATOM    517  O   VAL A  56      51.917  22.583  57.523  1.00  0.00           O  
ATOM    518  CB  VAL A  56      54.637  23.422  57.139  1.00  0.00           C  
ATOM    519  CG1 VAL A  56      54.691  22.385  56.028  1.00  0.00           C  
ATOM    520  CG2 VAL A  56      55.928  24.227  57.192  1.00  0.00           C  
ATOM    521  H   VAL A  56      53.234  24.911  58.980  1.00  0.00           H  
ATOM    522  HA  VAL A  56      53.591  24.946  56.056  1.00  0.00           H  
ATOM    523  HB  VAL A  56      54.521  22.906  58.080  1.00  0.00           H  
ATOM    524 HG11 VAL A  56      55.523  21.717  56.201  1.00  0.00           H  
ATOM    525 HG12 VAL A  56      53.769  21.821  56.018  1.00  0.00           H  
ATOM    526 HG13 VAL A  56      54.820  22.881  55.078  1.00  0.00           H  
ATOM    527 HG21 VAL A  56      56.016  24.700  58.158  1.00  0.00           H  
ATOM    528 HG22 VAL A  56      56.768  23.569  57.033  1.00  0.00           H  
ATOM    529 HG23 VAL A  56      55.913  24.983  56.421  1.00  0.00           H  
ATOM    530  N   SER A  57      51.391  23.844  55.735  1.00  0.00           N  
ATOM    531  CA  SER A  57      50.159  23.118  55.447  1.00  0.00           C  
ATOM    532  C   SER A  57      50.461  21.786  54.767  1.00  0.00           C  
ATOM    533  O   SER A  57      51.564  21.567  54.269  1.00  0.00           O  
ATOM    534  CB  SER A  57      49.242  23.960  54.560  1.00  0.00           C  
ATOM    535  OG  SER A  57      48.961  25.214  55.161  1.00  0.00           O  
ATOM    536  H   SER A  57      51.648  24.596  55.161  1.00  0.00           H  
ATOM    537  HA  SER A  57      49.661  22.925  56.386  1.00  0.00           H  
ATOM    538  HB2 SER A  57      49.722  24.131  53.609  1.00  0.00           H  
ATOM    539  HB3 SER A  57      48.312  23.433  54.404  1.00  0.00           H  
ATOM    540  HG  SER A  57      48.187  25.131  55.724  1.00  0.00           H  
ATOM    541  N   ARG A  58      49.470  20.900  54.750  1.00  0.00           N  
ATOM    542  CA  ARG A  58      49.627  19.589  54.133  1.00  0.00           C  
ATOM    543  C   ARG A  58      49.850  19.719  52.629  1.00  0.00           C  
ATOM    544  O   ARG A  58      50.677  19.016  52.051  1.00  0.00           O  
ATOM    545  CB  ARG A  58      48.396  18.723  54.404  1.00  0.00           C  
ATOM    546  CG  ARG A  58      48.251  17.552  53.444  1.00  0.00           C  
ATOM    547  CD  ARG A  58      47.120  16.626  53.863  1.00  0.00           C  
ATOM    548  NE  ARG A  58      45.843  17.026  53.278  1.00  0.00           N  
ATOM    549  CZ  ARG A  58      44.678  16.479  53.613  1.00  0.00           C  
ATOM    550  NH1 ARG A  58      44.632  15.515  54.523  1.00  0.00           N  
ATOM    551  NH2 ARG A  58      43.559  16.896  53.036  1.00  0.00           N  
ATOM    552  H   ARG A  58      48.611  21.133  55.164  1.00  0.00           H  
ATOM    553  HA  ARG A  58      50.492  19.116  54.573  1.00  0.00           H  
ATOM    554  HB2 ARG A  58      48.459  18.331  55.408  1.00  0.00           H  
ATOM    555  HB3 ARG A  58      47.513  19.339  54.320  1.00  0.00           H  
ATOM    556  HG2 ARG A  58      48.044  17.932  52.455  1.00  0.00           H  
ATOM    557  HG3 ARG A  58      49.176  16.994  53.432  1.00  0.00           H  
ATOM    558  HD2 ARG A  58      47.355  15.623  53.538  1.00  0.00           H  
ATOM    559  HD3 ARG A  58      47.035  16.646  54.939  1.00  0.00           H  
ATOM    560  HE  ARG A  58      45.854  17.736  52.604  1.00  0.00           H  
ATOM    561 HH11 ARG A  58      45.475  15.199  54.959  1.00  0.00           H  
ATOM    562 HH12 ARG A  58      43.754  15.106  54.773  1.00  0.00           H  
ATOM    563 HH21 ARG A  58      43.590  17.622  52.350  1.00  0.00           H  
ATOM    564 HH22 ARG A  58      42.684  16.484  53.289  1.00  0.00           H  
ATOM    565  N   ASN A  59      49.105  20.624  52.002  1.00  0.00           N  
ATOM    566  CA  ASN A  59      49.222  20.846  50.565  1.00  0.00           C  
ATOM    567  C   ASN A  59      50.509  21.593  50.232  1.00  0.00           C  
ATOM    568  O   ASN A  59      50.816  21.827  49.064  1.00  0.00           O  
ATOM    569  CB  ASN A  59      48.013  21.633  50.051  1.00  0.00           C  
ATOM    570  CG  ASN A  59      46.778  20.768  49.906  1.00  0.00           C  
ATOM    571  OD1 ASN A  59      46.547  19.856  50.702  1.00  0.00           O  
ATOM    572  ND2 ASN A  59      45.974  21.048  48.887  1.00  0.00           N  
ATOM    573  H   ASN A  59      48.462  21.155  52.517  1.00  0.00           H  
ATOM    574  HA  ASN A  59      49.242  19.882  50.081  1.00  0.00           H  
ATOM    575  HB2 ASN A  59      47.791  22.432  50.743  1.00  0.00           H  
ATOM    576  HB3 ASN A  59      48.250  22.055  49.086  1.00  0.00           H  
ATOM    577 HD21 ASN A  59      46.220  21.789  48.294  1.00  0.00           H  
ATOM    578 HD22 ASN A  59      45.167  20.505  48.771  1.00  0.00           H  
ATOM    579  N   GLN A  60      51.256  21.963  51.267  1.00  0.00           N  
ATOM    580  CA  GLN A  60      52.511  22.683  51.083  1.00  0.00           C  
ATOM    581  C   GLN A  60      53.704  21.784  51.391  1.00  0.00           C  
ATOM    582  O   GLN A  60      54.827  22.058  50.965  1.00  0.00           O  
ATOM    583  CB  GLN A  60      52.547  23.923  51.978  1.00  0.00           C  
ATOM    584  CG  GLN A  60      53.915  24.581  52.049  1.00  0.00           C  
ATOM    585  CD  GLN A  60      54.443  24.980  50.686  1.00  0.00           C  
ATOM    586  OE1 GLN A  60      53.707  25.509  49.853  1.00  0.00           O  
ATOM    587  NE2 GLN A  60      55.726  24.729  50.451  1.00  0.00           N  
ATOM    588  H   GLN A  60      50.958  21.746  52.173  1.00  0.00           H  
ATOM    589  HA  GLN A  60      52.567  22.994  50.051  1.00  0.00           H  
ATOM    590  HB2 GLN A  60      51.842  24.647  51.598  1.00  0.00           H  
ATOM    591  HB3 GLN A  60      52.256  23.639  52.978  1.00  0.00           H  
ATOM    592  HG2 GLN A  60      53.843  25.468  52.663  1.00  0.00           H  
ATOM    593  HG3 GLN A  60      54.610  23.889  52.501  1.00  0.00           H  
ATOM    594 HE21 GLN A  60      56.252  24.305  51.162  1.00  0.00           H  
ATOM    595 HE22 GLN A  60      56.093  24.975  49.578  1.00  0.00           H  
ATOM    596  N   LEU A  61      53.455  20.712  52.133  1.00  0.00           N  
ATOM    597  CA  LEU A  61      54.509  19.772  52.500  1.00  0.00           C  
ATOM    598  C   LEU A  61      54.391  18.481  51.695  1.00  0.00           C  
ATOM    599  O   LEU A  61      55.396  17.905  51.275  1.00  0.00           O  
ATOM    600  CB  LEU A  61      54.446  19.461  53.996  1.00  0.00           C  
ATOM    601  CG  LEU A  61      55.714  18.867  54.612  1.00  0.00           C  
ATOM    602  CD1 LEU A  61      56.906  19.778  54.364  1.00  0.00           C  
ATOM    603  CD2 LEU A  61      55.522  18.631  56.103  1.00  0.00           C  
ATOM    604  H   LEU A  61      52.540  20.547  52.443  1.00  0.00           H  
ATOM    605  HA  LEU A  61      55.459  20.236  52.275  1.00  0.00           H  
ATOM    606  HB2 LEU A  61      54.226  20.382  54.515  1.00  0.00           H  
ATOM    607  HB3 LEU A  61      53.640  18.760  54.154  1.00  0.00           H  
ATOM    608  HG  LEU A  61      55.920  17.914  54.145  1.00  0.00           H  
ATOM    609 HD11 LEU A  61      56.619  20.803  54.546  1.00  0.00           H  
ATOM    610 HD12 LEU A  61      57.232  19.674  53.339  1.00  0.00           H  
ATOM    611 HD13 LEU A  61      57.712  19.505  55.029  1.00  0.00           H  
ATOM    612 HD21 LEU A  61      54.509  18.885  56.380  1.00  0.00           H  
ATOM    613 HD22 LEU A  61      56.212  19.251  56.656  1.00  0.00           H  
ATOM    614 HD23 LEU A  61      55.708  17.592  56.329  1.00  0.00           H  
ATOM    615  N   LEU A  62      53.159  18.034  51.482  1.00  0.00           N  
ATOM    616  CA  LEU A  62      52.909  16.811  50.726  1.00  0.00           C  
ATOM    617  C   LEU A  62      53.532  16.894  49.336  1.00  0.00           C  
ATOM    618  O   LEU A  62      54.140  15.944  48.845  1.00  0.00           O  
ATOM    619  CB  LEU A  62      51.405  16.560  50.609  1.00  0.00           C  
ATOM    620  CG  LEU A  62      50.965  15.643  49.467  1.00  0.00           C  
ATOM    621  CD1 LEU A  62      51.201  14.184  49.833  1.00  0.00           C  
ATOM    622  CD2 LEU A  62      49.502  15.879  49.127  1.00  0.00           C  
ATOM    623  H   LEU A  62      52.399  18.536  51.842  1.00  0.00           H  
ATOM    624  HA  LEU A  62      53.362  15.992  51.262  1.00  0.00           H  
ATOM    625  HB2 LEU A  62      51.070  16.119  51.535  1.00  0.00           H  
ATOM    626  HB3 LEU A  62      50.919  17.516  50.471  1.00  0.00           H  
ATOM    627  HG  LEU A  62      51.554  15.864  48.588  1.00  0.00           H  
ATOM    628 HD11 LEU A  62      50.804  13.550  49.055  1.00  0.00           H  
ATOM    629 HD12 LEU A  62      50.703  13.963  50.765  1.00  0.00           H  
ATOM    630 HD13 LEU A  62      52.260  14.007  49.940  1.00  0.00           H  
ATOM    631 HD21 LEU A  62      49.156  16.770  49.629  1.00  0.00           H  
ATOM    632 HD22 LEU A  62      48.914  15.032  49.452  1.00  0.00           H  
ATOM    633 HD23 LEU A  62      49.395  16.002  48.060  1.00  0.00           H  
ATOM    634  N   PRO A  63      53.381  18.059  48.688  1.00  0.00           N  
ATOM    635  CA  PRO A  63      53.925  18.295  47.347  1.00  0.00           C  
ATOM    636  C   PRO A  63      55.382  17.864  47.228  1.00  0.00           C  
ATOM    637  O   PRO A  63      55.806  17.351  46.191  1.00  0.00           O  
ATOM    638  CB  PRO A  63      53.800  19.810  47.175  1.00  0.00           C  
ATOM    639  CG  PRO A  63      52.674  20.202  48.070  1.00  0.00           C  
ATOM    640  CD  PRO A  63      52.668  19.235  49.214  1.00  0.00           C  
ATOM    641  HA  PRO A  63      53.339  17.796  46.588  1.00  0.00           H  
ATOM    642  HB2 PRO A  63      54.724  20.286  47.471  1.00  0.00           H  
ATOM    643  HB3 PRO A  63      53.582  20.044  46.144  1.00  0.00           H  
ATOM    644  HG2 PRO A  63      52.830  21.205  48.439  1.00  0.00           H  
ATOM    645  HG3 PRO A  63      51.740  20.139  47.534  1.00  0.00           H  
ATOM    646  HD2 PRO A  63      53.190  19.655  50.061  1.00  0.00           H  
ATOM    647  HD3 PRO A  63      51.653  18.981  49.482  1.00  0.00           H  
ATOM    648  N   VAL A  64      56.146  18.074  48.295  1.00  0.00           N  
ATOM    649  CA  VAL A  64      57.556  17.705  48.311  1.00  0.00           C  
ATOM    650  C   VAL A  64      57.732  16.218  48.598  1.00  0.00           C  
ATOM    651  O   VAL A  64      58.697  15.599  48.147  1.00  0.00           O  
ATOM    652  CB  VAL A  64      58.337  18.516  49.363  1.00  0.00           C  
ATOM    653  CG1 VAL A  64      59.825  18.209  49.278  1.00  0.00           C  
ATOM    654  CG2 VAL A  64      58.079  20.004  49.187  1.00  0.00           C  
ATOM    655  H   VAL A  64      55.751  18.487  49.092  1.00  0.00           H  
ATOM    656  HA  VAL A  64      57.969  17.926  47.337  1.00  0.00           H  
ATOM    657  HB  VAL A  64      57.987  18.225  50.343  1.00  0.00           H  
ATOM    658 HG11 VAL A  64      60.280  18.842  48.530  1.00  0.00           H  
ATOM    659 HG12 VAL A  64      60.286  18.394  50.236  1.00  0.00           H  
ATOM    660 HG13 VAL A  64      59.964  17.173  49.005  1.00  0.00           H  
ATOM    661 HG21 VAL A  64      58.128  20.494  50.148  1.00  0.00           H  
ATOM    662 HG22 VAL A  64      58.828  20.425  48.531  1.00  0.00           H  
ATOM    663 HG23 VAL A  64      57.100  20.153  48.756  1.00  0.00           H  
ATOM    664  N   LEU A  65      56.795  15.651  49.348  1.00  0.00           N  
ATOM    665  CA  LEU A  65      56.846  14.236  49.695  1.00  0.00           C  
ATOM    666  C   LEU A  65      56.374  13.371  48.529  1.00  0.00           C  
ATOM    667  O   LEU A  65      56.589  12.160  48.515  1.00  0.00           O  
ATOM    668  CB  LEU A  65      55.984  13.960  50.928  1.00  0.00           C  
ATOM    669  CG  LEU A  65      56.385  14.700  52.206  1.00  0.00           C  
ATOM    670  CD1 LEU A  65      55.333  14.508  53.286  1.00  0.00           C  
ATOM    671  CD2 LEU A  65      57.746  14.224  52.692  1.00  0.00           C  
ATOM    672  H   LEU A  65      56.051  16.196  49.677  1.00  0.00           H  
ATOM    673  HA  LEU A  65      57.871  13.985  49.919  1.00  0.00           H  
ATOM    674  HB2 LEU A  65      54.968  14.239  50.691  1.00  0.00           H  
ATOM    675  HB3 LEU A  65      56.028  12.900  51.132  1.00  0.00           H  
ATOM    676  HG  LEU A  65      56.456  15.759  51.993  1.00  0.00           H  
ATOM    677 HD11 LEU A  65      55.592  15.103  54.149  1.00  0.00           H  
ATOM    678 HD12 LEU A  65      55.293  13.466  53.568  1.00  0.00           H  
ATOM    679 HD13 LEU A  65      54.369  14.818  52.911  1.00  0.00           H  
ATOM    680 HD21 LEU A  65      58.510  14.558  52.005  1.00  0.00           H  
ATOM    681 HD22 LEU A  65      57.754  13.147  52.743  1.00  0.00           H  
ATOM    682 HD23 LEU A  65      57.940  14.633  53.673  1.00  0.00           H  
ATOM    683  N   GLU A  66      55.732  14.005  47.553  1.00  0.00           N  
ATOM    684  CA  GLU A  66      55.231  13.295  46.382  1.00  0.00           C  
ATOM    685  C   GLU A  66      56.265  13.297  45.260  1.00  0.00           C  
ATOM    686  O   GLU A  66      56.526  12.268  44.637  1.00  0.00           O  
ATOM    687  CB  GLU A  66      53.929  13.928  45.890  1.00  0.00           C  
ATOM    688  CG  GLU A  66      52.749  13.695  46.822  1.00  0.00           C  
ATOM    689  CD  GLU A  66      51.415  13.940  46.145  1.00  0.00           C  
ATOM    690  OE1 GLU A  66      51.207  15.060  45.632  1.00  0.00           O  
ATOM    691  OE2 GLU A  66      50.579  13.012  46.129  1.00  0.00           O  
ATOM    692  H   GLU A  66      55.591  14.972  47.621  1.00  0.00           H  
ATOM    693  HA  GLU A  66      55.036  12.272  46.672  1.00  0.00           H  
ATOM    694  HB2 GLU A  66      54.076  14.993  45.790  1.00  0.00           H  
ATOM    695  HB3 GLU A  66      53.683  13.515  44.924  1.00  0.00           H  
ATOM    696  HG2 GLU A  66      52.777  12.672  47.167  1.00  0.00           H  
ATOM    697  HG3 GLU A  66      52.836  14.362  47.665  1.00  0.00           H  
ATOM    698  N   LYS A  67      56.851  14.462  45.007  1.00  0.00           N  
ATOM    699  CA  LYS A  67      57.858  14.602  43.960  1.00  0.00           C  
ATOM    700  C   LYS A  67      58.979  13.584  44.144  1.00  0.00           C  
ATOM    701  O   LYS A  67      59.534  13.078  43.169  1.00  0.00           O  
ATOM    702  CB  LYS A  67      58.436  16.020  43.967  1.00  0.00           C  
ATOM    703  CG  LYS A  67      58.946  16.461  45.327  1.00  0.00           C  
ATOM    704  CD  LYS A  67      59.348  17.927  45.323  1.00  0.00           C  
ATOM    705  CE  LYS A  67      60.482  18.191  44.344  1.00  0.00           C  
ATOM    706  NZ  LYS A  67      60.881  19.626  44.330  1.00  0.00           N  
ATOM    707  H   LYS A  67      56.602  15.248  45.537  1.00  0.00           H  
ATOM    708  HA  LYS A  67      57.376  14.423  43.011  1.00  0.00           H  
ATOM    709  HB2 LYS A  67      59.256  16.063  43.267  1.00  0.00           H  
ATOM    710  HB3 LYS A  67      57.668  16.711  43.653  1.00  0.00           H  
ATOM    711  HG2 LYS A  67      58.167  16.315  46.060  1.00  0.00           H  
ATOM    712  HG3 LYS A  67      59.807  15.863  45.591  1.00  0.00           H  
ATOM    713  HD2 LYS A  67      58.496  18.525  45.039  1.00  0.00           H  
ATOM    714  HD3 LYS A  67      59.671  18.206  46.317  1.00  0.00           H  
ATOM    715  HE2 LYS A  67      61.334  17.592  44.629  1.00  0.00           H  
ATOM    716  HE3 LYS A  67      60.157  17.908  43.354  1.00  0.00           H  
ATOM    717  HZ1 LYS A  67      60.673  20.046  43.402  1.00  0.00           H  
ATOM    718  HZ2 LYS A  67      61.899  19.715  44.519  1.00  0.00           H  
ATOM    719  HZ3 LYS A  67      60.356  20.149  45.061  1.00  0.00           H  
ATOM    720  N   CYS A  68      59.302  13.287  45.398  1.00  0.00           N  
ATOM    721  CA  CYS A  68      60.357  12.327  45.708  1.00  0.00           C  
ATOM    722  C   CYS A  68      59.836  10.898  45.609  1.00  0.00           C  
ATOM    723  O   CYS A  68      60.345  10.094  44.828  1.00  0.00           O  
ATOM    724  CB  CYS A  68      60.912  12.584  47.111  1.00  0.00           C  
ATOM    725  SG  CYS A  68      62.254  13.795  47.162  1.00  0.00           S  
ATOM    726  H   CYS A  68      58.822  13.723  46.132  1.00  0.00           H  
ATOM    727  HA  CYS A  68      61.147  12.461  44.987  1.00  0.00           H  
ATOM    728  HB2 CYS A  68      60.116  12.951  47.743  1.00  0.00           H  
ATOM    729  HB3 CYS A  68      61.287  11.657  47.515  1.00  0.00           H  
ATOM    730  HG  CYS A  68      62.724  13.830  48.398  1.00  0.00           H  
ATOM    731  N   GLY A  69      58.818  10.586  46.406  1.00  0.00           N  
ATOM    732  CA  GLY A  69      58.247   9.252  46.393  1.00  0.00           C  
ATOM    733  C   GLY A  69      56.756   9.259  46.660  1.00  0.00           C  
ATOM    734  O   GLY A  69      56.181  10.294  46.993  1.00  0.00           O  
ATOM    735  H   GLY A  69      58.453  11.268  47.007  1.00  0.00           H  
ATOM    736  HA2 GLY A  69      58.428   8.803  45.428  1.00  0.00           H  
ATOM    737  HA3 GLY A  69      58.735   8.658  47.152  1.00  0.00           H  
ATOM    738  N   LEU A  70      56.125   8.098  46.509  1.00  0.00           N  
ATOM    739  CA  LEU A  70      54.689   7.972  46.735  1.00  0.00           C  
ATOM    740  C   LEU A  70      54.348   8.186  48.206  1.00  0.00           C  
ATOM    741  O   LEU A  70      55.000   7.633  49.093  1.00  0.00           O  
ATOM    742  CB  LEU A  70      54.200   6.596  46.281  1.00  0.00           C  
ATOM    743  CG  LEU A  70      54.301   6.309  44.783  1.00  0.00           C  
ATOM    744  CD1 LEU A  70      54.179   4.817  44.516  1.00  0.00           C  
ATOM    745  CD2 LEU A  70      53.234   7.078  44.017  1.00  0.00           C  
ATOM    746  H   LEU A  70      56.636   7.306  46.242  1.00  0.00           H  
ATOM    747  HA  LEU A  70      54.195   8.734  46.149  1.00  0.00           H  
ATOM    748  HB2 LEU A  70      54.782   5.851  46.801  1.00  0.00           H  
ATOM    749  HB3 LEU A  70      53.162   6.504  46.566  1.00  0.00           H  
ATOM    750  HG  LEU A  70      55.269   6.633  44.425  1.00  0.00           H  
ATOM    751 HD11 LEU A  70      53.920   4.307  45.432  1.00  0.00           H  
ATOM    752 HD12 LEU A  70      55.121   4.439  44.147  1.00  0.00           H  
ATOM    753 HD13 LEU A  70      53.409   4.645  43.777  1.00  0.00           H  
ATOM    754 HD21 LEU A  70      52.916   6.499  43.165  1.00  0.00           H  
ATOM    755 HD22 LEU A  70      53.641   8.022  43.682  1.00  0.00           H  
ATOM    756 HD23 LEU A  70      52.389   7.261  44.665  1.00  0.00           H  
ATOM    757  N   VAL A  71      53.320   8.990  48.460  1.00  0.00           N  
ATOM    758  CA  VAL A  71      52.890   9.274  49.823  1.00  0.00           C  
ATOM    759  C   VAL A  71      51.612   8.515  50.166  1.00  0.00           C  
ATOM    760  O   VAL A  71      50.516   8.916  49.773  1.00  0.00           O  
ATOM    761  CB  VAL A  71      52.651  10.781  50.034  1.00  0.00           C  
ATOM    762  CG1 VAL A  71      52.103  11.044  51.428  1.00  0.00           C  
ATOM    763  CG2 VAL A  71      53.935  11.561  49.801  1.00  0.00           C  
ATOM    764  H   VAL A  71      52.839   9.402  47.712  1.00  0.00           H  
ATOM    765  HA  VAL A  71      53.675   8.958  50.494  1.00  0.00           H  
ATOM    766  HB  VAL A  71      51.917  11.112  49.315  1.00  0.00           H  
ATOM    767 HG11 VAL A  71      52.101  10.125  51.994  1.00  0.00           H  
ATOM    768 HG12 VAL A  71      52.723  11.775  51.927  1.00  0.00           H  
ATOM    769 HG13 VAL A  71      51.094  11.421  51.352  1.00  0.00           H  
ATOM    770 HG21 VAL A  71      54.355  11.285  48.845  1.00  0.00           H  
ATOM    771 HG22 VAL A  71      53.720  12.621  49.807  1.00  0.00           H  
ATOM    772 HG23 VAL A  71      54.642  11.333  50.584  1.00  0.00           H  
ATOM    773  N   ASP A  72      51.761   7.419  50.899  1.00  0.00           N  
ATOM    774  CA  ASP A  72      50.619   6.603  51.296  1.00  0.00           C  
ATOM    775  C   ASP A  72      49.779   7.320  52.347  1.00  0.00           C  
ATOM    776  O   ASP A  72      48.560   7.427  52.215  1.00  0.00           O  
ATOM    777  CB  ASP A  72      51.092   5.253  51.839  1.00  0.00           C  
ATOM    778  CG  ASP A  72      49.998   4.204  51.819  1.00  0.00           C  
ATOM    779  OD1 ASP A  72      49.563   3.821  50.712  1.00  0.00           O  
ATOM    780  OD2 ASP A  72      49.575   3.768  52.910  1.00  0.00           O  
ATOM    781  H   ASP A  72      52.661   7.150  51.181  1.00  0.00           H  
ATOM    782  HA  ASP A  72      50.011   6.436  50.421  1.00  0.00           H  
ATOM    783  HB2 ASP A  72      51.916   4.899  51.235  1.00  0.00           H  
ATOM    784  HB3 ASP A  72      51.427   5.379  52.858  1.00  0.00           H  
ATOM    785  N   ALA A  73      50.438   7.811  53.392  1.00  0.00           N  
ATOM    786  CA  ALA A  73      49.752   8.521  54.465  1.00  0.00           C  
ATOM    787  C   ALA A  73      50.660   9.568  55.100  1.00  0.00           C  
ATOM    788  O   ALA A  73      51.786   9.268  55.500  1.00  0.00           O  
ATOM    789  CB  ALA A  73      49.263   7.536  55.518  1.00  0.00           C  
ATOM    790  H   ALA A  73      51.410   7.695  53.440  1.00  0.00           H  
ATOM    791  HA  ALA A  73      48.890   9.014  54.040  1.00  0.00           H  
ATOM    792  HB1 ALA A  73      48.182   7.516  55.514  1.00  0.00           H  
ATOM    793  HB2 ALA A  73      49.643   6.551  55.294  1.00  0.00           H  
ATOM    794  HB3 ALA A  73      49.613   7.847  56.490  1.00  0.00           H  
ATOM    795  N   LEU A  74      50.165  10.798  55.187  1.00  0.00           N  
ATOM    796  CA  LEU A  74      50.933  11.890  55.772  1.00  0.00           C  
ATOM    797  C   LEU A  74      50.285  12.381  57.063  1.00  0.00           C  
ATOM    798  O   LEU A  74      49.302  13.125  57.034  1.00  0.00           O  
ATOM    799  CB  LEU A  74      51.051  13.047  54.776  1.00  0.00           C  
ATOM    800  CG  LEU A  74      51.476  14.395  55.361  1.00  0.00           C  
ATOM    801  CD1 LEU A  74      52.899  14.322  55.893  1.00  0.00           C  
ATOM    802  CD2 LEU A  74      51.351  15.493  54.316  1.00  0.00           C  
ATOM    803  H   LEU A  74      49.262  10.975  54.851  1.00  0.00           H  
ATOM    804  HA  LEU A  74      51.921  11.519  55.998  1.00  0.00           H  
ATOM    805  HB2 LEU A  74      51.778  12.767  54.030  1.00  0.00           H  
ATOM    806  HB3 LEU A  74      50.087  13.179  54.307  1.00  0.00           H  
ATOM    807  HG  LEU A  74      50.825  14.643  56.188  1.00  0.00           H  
ATOM    808 HD11 LEU A  74      53.041  13.389  56.415  1.00  0.00           H  
ATOM    809 HD12 LEU A  74      53.074  15.145  56.569  1.00  0.00           H  
ATOM    810 HD13 LEU A  74      53.594  14.381  55.066  1.00  0.00           H  
ATOM    811 HD21 LEU A  74      50.440  15.351  53.753  1.00  0.00           H  
ATOM    812 HD22 LEU A  74      52.198  15.450  53.645  1.00  0.00           H  
ATOM    813 HD23 LEU A  74      51.327  16.455  54.804  1.00  0.00           H  
ATOM    814  N   LEU A  75      50.841  11.962  58.194  1.00  0.00           N  
ATOM    815  CA  LEU A  75      50.319  12.360  59.497  1.00  0.00           C  
ATOM    816  C   LEU A  75      50.832  13.742  59.891  1.00  0.00           C  
ATOM    817  O   LEU A  75      52.039  13.979  59.933  1.00  0.00           O  
ATOM    818  CB  LEU A  75      50.715  11.335  60.562  1.00  0.00           C  
ATOM    819  CG  LEU A  75      50.284  11.656  61.994  1.00  0.00           C  
ATOM    820  CD1 LEU A  75      48.803  11.363  62.185  1.00  0.00           C  
ATOM    821  CD2 LEU A  75      51.118  10.864  62.990  1.00  0.00           C  
ATOM    822  H   LEU A  75      51.621  11.372  58.154  1.00  0.00           H  
ATOM    823  HA  LEU A  75      49.242  12.396  59.425  1.00  0.00           H  
ATOM    824  HB2 LEU A  75      50.275  10.389  60.288  1.00  0.00           H  
ATOM    825  HB3 LEU A  75      51.791  11.247  60.551  1.00  0.00           H  
ATOM    826  HG  LEU A  75      50.443  12.707  62.184  1.00  0.00           H  
ATOM    827 HD11 LEU A  75      48.228  12.240  61.931  1.00  0.00           H  
ATOM    828 HD12 LEU A  75      48.620  11.097  63.215  1.00  0.00           H  
ATOM    829 HD13 LEU A  75      48.514  10.543  61.544  1.00  0.00           H  
ATOM    830 HD21 LEU A  75      51.890  10.322  62.463  1.00  0.00           H  
ATOM    831 HD22 LEU A  75      50.483  10.166  63.518  1.00  0.00           H  
ATOM    832 HD23 LEU A  75      51.574  11.542  63.697  1.00  0.00           H  
ATOM    833  N   MET A  76      49.905  14.652  60.178  1.00  0.00           N  
ATOM    834  CA  MET A  76      50.265  16.010  60.571  1.00  0.00           C  
ATOM    835  C   MET A  76      49.539  16.414  61.850  1.00  0.00           C  
ATOM    836  O   MET A  76      48.400  16.883  61.824  1.00  0.00           O  
ATOM    837  CB  MET A  76      49.932  16.992  59.448  1.00  0.00           C  
ATOM    838  CG  MET A  76      50.761  16.784  58.191  1.00  0.00           C  
ATOM    839  SD  MET A  76      50.733  18.215  57.095  1.00  0.00           S  
ATOM    840  CE  MET A  76      51.675  19.396  58.059  1.00  0.00           C  
ATOM    841  H   MET A  76      48.959  14.404  60.126  1.00  0.00           H  
ATOM    842  HA  MET A  76      51.329  16.030  60.753  1.00  0.00           H  
ATOM    843  HB2 MET A  76      48.889  16.885  59.188  1.00  0.00           H  
ATOM    844  HB3 MET A  76      50.104  17.998  59.803  1.00  0.00           H  
ATOM    845  HG2 MET A  76      51.783  16.588  58.478  1.00  0.00           H  
ATOM    846  HG3 MET A  76      50.370  15.930  57.657  1.00  0.00           H  
ATOM    847  HE1 MET A  76      52.052  18.916  58.949  1.00  0.00           H  
ATOM    848  HE2 MET A  76      52.502  19.763  57.468  1.00  0.00           H  
ATOM    849  HE3 MET A  76      51.037  20.224  58.337  1.00  0.00           H  
ATOM    850  N   PRO A  77      50.210  16.230  62.997  1.00  0.00           N  
ATOM    851  CA  PRO A  77      49.648  16.571  64.306  1.00  0.00           C  
ATOM    852  C   PRO A  77      49.521  18.077  64.509  1.00  0.00           C  
ATOM    853  O   PRO A  77      50.410  18.852  64.159  1.00  0.00           O  
ATOM    854  CB  PRO A  77      50.661  15.983  65.292  1.00  0.00           C  
ATOM    855  CG  PRO A  77      51.944  15.938  64.535  1.00  0.00           C  
ATOM    856  CD  PRO A  77      51.571  15.676  63.102  1.00  0.00           C  
ATOM    857  HA  PRO A  77      48.684  16.105  64.458  1.00  0.00           H  
ATOM    858  HB2 PRO A  77      50.735  16.621  66.160  1.00  0.00           H  
ATOM    859  HB3 PRO A  77      50.347  14.995  65.590  1.00  0.00           H  
ATOM    860  HG2 PRO A  77      52.453  16.886  64.621  1.00  0.00           H  
ATOM    861  HG3 PRO A  77      52.566  15.142  64.912  1.00  0.00           H  
ATOM    862  HD2 PRO A  77      52.249  16.188  62.436  1.00  0.00           H  
ATOM    863  HD3 PRO A  77      51.570  14.614  62.901  1.00  0.00           H  
ATOM    864  N   PRO A  78      48.387  18.503  65.087  1.00  0.00           N  
ATOM    865  CA  PRO A  78      48.118  19.920  65.350  1.00  0.00           C  
ATOM    866  C   PRO A  78      49.008  20.485  66.452  1.00  0.00           C  
ATOM    867  O   PRO A  78      49.312  19.801  67.428  1.00  0.00           O  
ATOM    868  CB  PRO A  78      46.652  19.926  65.791  1.00  0.00           C  
ATOM    869  CG  PRO A  78      46.416  18.560  66.337  1.00  0.00           C  
ATOM    870  CD  PRO A  78      47.283  17.635  65.529  1.00  0.00           C  
ATOM    871  HA  PRO A  78      48.230  20.518  64.457  1.00  0.00           H  
ATOM    872  HB2 PRO A  78      46.504  20.685  66.547  1.00  0.00           H  
ATOM    873  HB3 PRO A  78      46.018  20.127  64.942  1.00  0.00           H  
ATOM    874  HG2 PRO A  78      46.698  18.526  67.379  1.00  0.00           H  
ATOM    875  HG3 PRO A  78      45.374  18.294  66.220  1.00  0.00           H  
ATOM    876  HD2 PRO A  78      47.649  16.828  66.145  1.00  0.00           H  
ATOM    877  HD3 PRO A  78      46.736  17.248  64.682  1.00  0.00           H  
ATOM    878  N   ASN A  79      49.422  21.738  66.288  1.00  0.00           N  
ATOM    879  CA  ASN A  79      50.278  22.393  67.269  1.00  0.00           C  
ATOM    880  C   ASN A  79      51.570  21.610  67.475  1.00  0.00           C  
ATOM    881  O   ASN A  79      52.080  21.516  68.591  1.00  0.00           O  
ATOM    882  CB  ASN A  79      49.540  22.543  68.602  1.00  0.00           C  
ATOM    883  CG  ASN A  79      48.308  23.419  68.486  1.00  0.00           C  
ATOM    884  OD1 ASN A  79      48.281  24.372  67.704  1.00  0.00           O  
ATOM    885  ND2 ASN A  79      47.280  23.101  69.264  1.00  0.00           N  
ATOM    886  H   ASN A  79      49.145  22.232  65.488  1.00  0.00           H  
ATOM    887  HA  ASN A  79      50.522  23.375  66.891  1.00  0.00           H  
ATOM    888  HB2 ASN A  79      49.232  21.567  68.946  1.00  0.00           H  
ATOM    889  HB3 ASN A  79      50.206  22.984  69.328  1.00  0.00           H  
ATOM    890 HD21 ASN A  79      47.374  22.330  69.860  1.00  0.00           H  
ATOM    891 HD22 ASN A  79      46.471  23.650  69.208  1.00  0.00           H  
ATOM    892  N   LYS A  80      52.094  21.048  66.391  1.00  0.00           N  
ATOM    893  CA  LYS A  80      53.327  20.273  66.451  1.00  0.00           C  
ATOM    894  C   LYS A  80      54.263  20.651  65.307  1.00  0.00           C  
ATOM    895  O   LYS A  80      53.921  20.540  64.130  1.00  0.00           O  
ATOM    896  CB  LYS A  80      53.017  18.776  66.395  1.00  0.00           C  
ATOM    897  CG  LYS A  80      52.480  18.217  67.703  1.00  0.00           C  
ATOM    898  CD  LYS A  80      53.523  18.284  68.807  1.00  0.00           C  
ATOM    899  CE  LYS A  80      53.220  17.290  69.918  1.00  0.00           C  
ATOM    900  NZ  LYS A  80      52.096  17.746  70.780  1.00  0.00           N  
ATOM    901  H   LYS A  80      51.641  21.159  65.529  1.00  0.00           H  
ATOM    902  HA  LYS A  80      53.815  20.497  67.388  1.00  0.00           H  
ATOM    903  HB2 LYS A  80      52.281  18.601  65.624  1.00  0.00           H  
ATOM    904  HB3 LYS A  80      53.921  18.242  66.145  1.00  0.00           H  
ATOM    905  HG2 LYS A  80      51.617  18.793  68.002  1.00  0.00           H  
ATOM    906  HG3 LYS A  80      52.195  17.186  67.552  1.00  0.00           H  
ATOM    907  HD2 LYS A  80      54.492  18.056  68.389  1.00  0.00           H  
ATOM    908  HD3 LYS A  80      53.533  19.282  69.220  1.00  0.00           H  
ATOM    909  HE2 LYS A  80      52.961  16.342  69.474  1.00  0.00           H  
ATOM    910  HE3 LYS A  80      54.105  17.172  70.527  1.00  0.00           H  
ATOM    911  HZ1 LYS A  80      51.812  18.712  70.515  1.00  0.00           H  
ATOM    912  HZ2 LYS A  80      52.387  17.744  71.777  1.00  0.00           H  
ATOM    913  HZ3 LYS A  80      51.278  17.114  70.664  1.00  0.00           H  
ATOM    914  N   PRO A  81      55.475  21.109  65.659  1.00  0.00           N  
ATOM    915  CA  PRO A  81      56.484  21.510  64.676  1.00  0.00           C  
ATOM    916  C   PRO A  81      57.049  20.322  63.905  1.00  0.00           C  
ATOM    917  O   PRO A  81      57.831  20.490  62.969  1.00  0.00           O  
ATOM    918  CB  PRO A  81      57.575  22.158  65.533  1.00  0.00           C  
ATOM    919  CG  PRO A  81      57.422  21.535  66.877  1.00  0.00           C  
ATOM    920  CD  PRO A  81      55.951  21.268  67.043  1.00  0.00           C  
ATOM    921  HA  PRO A  81      56.094  22.237  63.978  1.00  0.00           H  
ATOM    922  HB2 PRO A  81      58.547  21.945  65.106  1.00  0.00           H  
ATOM    923  HB3 PRO A  81      57.420  23.225  65.573  1.00  0.00           H  
ATOM    924  HG2 PRO A  81      57.977  20.611  66.920  1.00  0.00           H  
ATOM    925  HG3 PRO A  81      57.766  22.219  67.639  1.00  0.00           H  
ATOM    926  HD2 PRO A  81      55.794  20.363  67.611  1.00  0.00           H  
ATOM    927  HD3 PRO A  81      55.466  22.106  67.522  1.00  0.00           H  
ATOM    928  N   TYR A  82      56.648  19.120  64.304  1.00  0.00           N  
ATOM    929  CA  TYR A  82      57.115  17.901  63.652  1.00  0.00           C  
ATOM    930  C   TYR A  82      55.941  17.078  63.131  1.00  0.00           C  
ATOM    931  O   TYR A  82      54.865  17.064  63.728  1.00  0.00           O  
ATOM    932  CB  TYR A  82      57.947  17.064  64.626  1.00  0.00           C  
ATOM    933  CG  TYR A  82      57.194  16.655  65.870  1.00  0.00           C  
ATOM    934  CD1 TYR A  82      56.233  15.652  65.826  1.00  0.00           C  
ATOM    935  CD2 TYR A  82      57.440  17.272  67.090  1.00  0.00           C  
ATOM    936  CE1 TYR A  82      55.542  15.275  66.961  1.00  0.00           C  
ATOM    937  CE2 TYR A  82      56.756  16.900  68.230  1.00  0.00           C  
ATOM    938  CZ  TYR A  82      55.806  15.902  68.160  1.00  0.00           C  
ATOM    939  OH  TYR A  82      55.119  15.531  69.293  1.00  0.00           O  
ATOM    940  H   TYR A  82      56.024  19.049  65.057  1.00  0.00           H  
ATOM    941  HA  TYR A  82      57.737  18.190  62.818  1.00  0.00           H  
ATOM    942  HB2 TYR A  82      58.276  16.165  64.126  1.00  0.00           H  
ATOM    943  HB3 TYR A  82      58.812  17.636  64.932  1.00  0.00           H  
ATOM    944  HD1 TYR A  82      56.028  15.162  64.885  1.00  0.00           H  
ATOM    945  HD2 TYR A  82      58.184  18.055  67.140  1.00  0.00           H  
ATOM    946  HE1 TYR A  82      54.799  14.493  66.907  1.00  0.00           H  
ATOM    947  HE2 TYR A  82      56.962  17.392  69.170  1.00  0.00           H  
ATOM    948  HH  TYR A  82      55.646  14.902  69.795  1.00  0.00           H  
ATOM    949  N   SER A  83      56.159  16.394  62.012  1.00  0.00           N  
ATOM    950  CA  SER A  83      55.119  15.569  61.408  1.00  0.00           C  
ATOM    951  C   SER A  83      55.671  14.202  61.013  1.00  0.00           C  
ATOM    952  O   SER A  83      56.867  13.943  61.140  1.00  0.00           O  
ATOM    953  CB  SER A  83      54.535  16.269  60.178  1.00  0.00           C  
ATOM    954  OG  SER A  83      53.791  17.417  60.551  1.00  0.00           O  
ATOM    955  H   SER A  83      57.039  16.445  61.584  1.00  0.00           H  
ATOM    956  HA  SER A  83      54.337  15.431  62.139  1.00  0.00           H  
ATOM    957  HB2 SER A  83      55.337  16.571  59.524  1.00  0.00           H  
ATOM    958  HB3 SER A  83      53.881  15.585  59.655  1.00  0.00           H  
ATOM    959  HG  SER A  83      52.976  17.448  60.047  1.00  0.00           H  
ATOM    960  N   PHE A  84      54.788  13.331  60.535  1.00  0.00           N  
ATOM    961  CA  PHE A  84      55.184  11.989  60.123  1.00  0.00           C  
ATOM    962  C   PHE A  84      54.588  11.639  58.763  1.00  0.00           C  
ATOM    963  O   PHE A  84      53.413  11.898  58.504  1.00  0.00           O  
ATOM    964  CB  PHE A  84      54.743  10.960  61.166  1.00  0.00           C  
ATOM    965  CG  PHE A  84      55.168  11.305  62.565  1.00  0.00           C  
ATOM    966  CD1 PHE A  84      56.399  10.890  63.051  1.00  0.00           C  
ATOM    967  CD2 PHE A  84      54.339  12.043  63.394  1.00  0.00           C  
ATOM    968  CE1 PHE A  84      56.793  11.205  64.337  1.00  0.00           C  
ATOM    969  CE2 PHE A  84      54.729  12.361  64.682  1.00  0.00           C  
ATOM    970  CZ  PHE A  84      55.957  11.941  65.154  1.00  0.00           C  
ATOM    971  H   PHE A  84      53.847  13.597  60.458  1.00  0.00           H  
ATOM    972  HA  PHE A  84      56.261  11.972  60.046  1.00  0.00           H  
ATOM    973  HB2 PHE A  84      53.666  10.888  61.156  1.00  0.00           H  
ATOM    974  HB3 PHE A  84      55.167  10.000  60.916  1.00  0.00           H  
ATOM    975  HD1 PHE A  84      57.054  10.314  62.413  1.00  0.00           H  
ATOM    976  HD2 PHE A  84      53.377  12.371  63.026  1.00  0.00           H  
ATOM    977  HE1 PHE A  84      57.754  10.875  64.704  1.00  0.00           H  
ATOM    978  HE2 PHE A  84      54.072  12.936  65.318  1.00  0.00           H  
ATOM    979  HZ  PHE A  84      56.264  12.189  66.159  1.00  0.00           H  
ATOM    980  N   ALA A  85      55.407  11.050  57.898  1.00  0.00           N  
ATOM    981  CA  ALA A  85      54.961  10.663  56.565  1.00  0.00           C  
ATOM    982  C   ALA A  85      55.121   9.164  56.348  1.00  0.00           C  
ATOM    983  O   ALA A  85      55.961   8.520  56.976  1.00  0.00           O  
ATOM    984  CB  ALA A  85      55.730  11.438  55.506  1.00  0.00           C  
ATOM    985  H   ALA A  85      56.333  10.871  58.162  1.00  0.00           H  
ATOM    986  HA  ALA A  85      53.915  10.921  56.476  1.00  0.00           H  
ATOM    987  HB1 ALA A  85      56.732  11.039  55.426  1.00  0.00           H  
ATOM    988  HB2 ALA A  85      55.227  11.343  54.555  1.00  0.00           H  
ATOM    989  HB3 ALA A  85      55.779  12.479  55.786  1.00  0.00           H  
ATOM    990  N   ARG A  86      54.308   8.610  55.452  1.00  0.00           N  
ATOM    991  CA  ARG A  86      54.359   7.184  55.153  1.00  0.00           C  
ATOM    992  C   ARG A  86      54.414   6.946  53.646  1.00  0.00           C  
ATOM    993  O   ARG A  86      53.438   7.182  52.934  1.00  0.00           O  
ATOM    994  CB  ARG A  86      53.141   6.473  55.748  1.00  0.00           C  
ATOM    995  CG  ARG A  86      53.400   5.019  56.105  1.00  0.00           C  
ATOM    996  CD  ARG A  86      52.494   4.554  57.235  1.00  0.00           C  
ATOM    997  NE  ARG A  86      51.227   4.023  56.739  1.00  0.00           N  
ATOM    998  CZ  ARG A  86      51.096   2.816  56.202  1.00  0.00           C  
ATOM    999  NH1 ARG A  86      52.149   2.017  56.093  1.00  0.00           N  
ATOM   1000  NH2 ARG A  86      49.908   2.404  55.773  1.00  0.00           N  
ATOM   1001  H   ARG A  86      53.658   9.175  54.982  1.00  0.00           H  
ATOM   1002  HA  ARG A  86      55.253   6.782  55.603  1.00  0.00           H  
ATOM   1003  HB2 ARG A  86      52.837   6.993  56.644  1.00  0.00           H  
ATOM   1004  HB3 ARG A  86      52.333   6.507  55.031  1.00  0.00           H  
ATOM   1005  HG2 ARG A  86      53.214   4.407  55.236  1.00  0.00           H  
ATOM   1006  HG3 ARG A  86      54.428   4.911  56.411  1.00  0.00           H  
ATOM   1007  HD2 ARG A  86      53.003   3.781  57.790  1.00  0.00           H  
ATOM   1008  HD3 ARG A  86      52.293   5.392  57.885  1.00  0.00           H  
ATOM   1009  HE  ARG A  86      50.436   4.597  56.810  1.00  0.00           H  
ATOM   1010 HH11 ARG A  86      53.043   2.324  56.416  1.00  0.00           H  
ATOM   1011 HH12 ARG A  86      52.047   1.107  55.690  1.00  0.00           H  
ATOM   1012 HH21 ARG A  86      49.113   3.004  55.854  1.00  0.00           H  
ATOM   1013 HH22 ARG A  86      49.811   1.495  55.369  1.00  0.00           H  
ATOM   1014  N   TYR A  87      55.562   6.478  53.170  1.00  0.00           N  
ATOM   1015  CA  TYR A  87      55.746   6.212  51.748  1.00  0.00           C  
ATOM   1016  C   TYR A  87      55.204   4.836  51.377  1.00  0.00           C  
ATOM   1017  O   TYR A  87      54.818   4.053  52.246  1.00  0.00           O  
ATOM   1018  CB  TYR A  87      57.228   6.304  51.379  1.00  0.00           C  
ATOM   1019  CG  TYR A  87      57.729   7.723  51.237  1.00  0.00           C  
ATOM   1020  CD1 TYR A  87      58.226   8.418  52.334  1.00  0.00           C  
ATOM   1021  CD2 TYR A  87      57.706   8.370  50.007  1.00  0.00           C  
ATOM   1022  CE1 TYR A  87      58.684   9.715  52.209  1.00  0.00           C  
ATOM   1023  CE2 TYR A  87      58.164   9.667  49.875  1.00  0.00           C  
ATOM   1024  CZ  TYR A  87      58.653  10.334  50.978  1.00  0.00           C  
ATOM   1025  OH  TYR A  87      59.108  11.627  50.850  1.00  0.00           O  
ATOM   1026  H   TYR A  87      56.304   6.310  53.788  1.00  0.00           H  
ATOM   1027  HA  TYR A  87      55.201   6.963  51.195  1.00  0.00           H  
ATOM   1028  HB2 TYR A  87      57.813   5.821  52.145  1.00  0.00           H  
ATOM   1029  HB3 TYR A  87      57.389   5.800  50.437  1.00  0.00           H  
ATOM   1030  HD1 TYR A  87      58.250   7.930  53.297  1.00  0.00           H  
ATOM   1031  HD2 TYR A  87      57.323   7.844  49.146  1.00  0.00           H  
ATOM   1032  HE1 TYR A  87      59.067  10.238  53.074  1.00  0.00           H  
ATOM   1033  HE2 TYR A  87      58.138  10.152  48.910  1.00  0.00           H  
ATOM   1034  HH  TYR A  87      58.708  12.031  50.076  1.00  0.00           H  
ATOM   1035  N   ARG A  88      55.176   4.548  50.080  1.00  0.00           N  
ATOM   1036  CA  ARG A  88      54.679   3.266  49.592  1.00  0.00           C  
ATOM   1037  C   ARG A  88      55.768   2.199  49.661  1.00  0.00           C  
ATOM   1038  O   ARG A  88      55.515   1.062  50.060  1.00  0.00           O  
ATOM   1039  CB  ARG A  88      54.176   3.404  48.154  1.00  0.00           C  
ATOM   1040  CG  ARG A  88      53.736   2.088  47.534  1.00  0.00           C  
ATOM   1041  CD  ARG A  88      52.303   1.746  47.911  1.00  0.00           C  
ATOM   1042  NE  ARG A  88      51.987   0.345  47.646  1.00  0.00           N  
ATOM   1043  CZ  ARG A  88      51.637  -0.116  46.450  1.00  0.00           C  
ATOM   1044  NH1 ARG A  88      51.560   0.708  45.414  1.00  0.00           N  
ATOM   1045  NH2 ARG A  88      51.364  -1.405  46.289  1.00  0.00           N  
ATOM   1046  H   ARG A  88      55.496   5.212  49.436  1.00  0.00           H  
ATOM   1047  HA  ARG A  88      53.857   2.967  50.225  1.00  0.00           H  
ATOM   1048  HB2 ARG A  88      53.333   4.081  48.143  1.00  0.00           H  
ATOM   1049  HB3 ARG A  88      54.968   3.817  47.547  1.00  0.00           H  
ATOM   1050  HG2 ARG A  88      53.805   2.167  46.460  1.00  0.00           H  
ATOM   1051  HG3 ARG A  88      54.388   1.301  47.882  1.00  0.00           H  
ATOM   1052  HD2 ARG A  88      52.164   1.944  48.963  1.00  0.00           H  
ATOM   1053  HD3 ARG A  88      51.635   2.371  47.336  1.00  0.00           H  
ATOM   1054  HE  ARG A  88      52.037  -0.281  48.397  1.00  0.00           H  
ATOM   1055 HH11 ARG A  88      51.766   1.679  45.534  1.00  0.00           H  
ATOM   1056 HH12 ARG A  88      51.297   0.358  44.516  1.00  0.00           H  
ATOM   1057 HH21 ARG A  88      51.422  -2.029  47.067  1.00  0.00           H  
ATOM   1058 HH22 ARG A  88      51.101  -1.751  45.389  1.00  0.00           H  
ATOM   1059  N   THR A  89      56.982   2.574  49.268  1.00  0.00           N  
ATOM   1060  CA  THR A  89      58.109   1.649  49.282  1.00  0.00           C  
ATOM   1061  C   THR A  89      59.316   2.267  49.979  1.00  0.00           C  
ATOM   1062  O   THR A  89      59.635   3.438  49.771  1.00  0.00           O  
ATOM   1063  CB  THR A  89      58.511   1.231  47.856  1.00  0.00           C  
ATOM   1064  OG1 THR A  89      58.920   2.379  47.105  1.00  0.00           O  
ATOM   1065  CG2 THR A  89      57.354   0.542  47.148  1.00  0.00           C  
ATOM   1066  H   THR A  89      57.121   3.494  48.960  1.00  0.00           H  
ATOM   1067  HA  THR A  89      57.808   0.764  49.824  1.00  0.00           H  
ATOM   1068  HB  THR A  89      59.339   0.538  47.921  1.00  0.00           H  
ATOM   1069  HG1 THR A  89      59.708   2.168  46.600  1.00  0.00           H  
ATOM   1070 HG21 THR A  89      56.422   0.988  47.462  1.00  0.00           H  
ATOM   1071 HG22 THR A  89      57.354  -0.508  47.399  1.00  0.00           H  
ATOM   1072 HG23 THR A  89      57.466   0.658  46.081  1.00  0.00           H  
ATOM   1073  N   THR A  90      59.988   1.471  50.806  1.00  0.00           N  
ATOM   1074  CA  THR A  90      61.161   1.940  51.533  1.00  0.00           C  
ATOM   1075  C   THR A  90      62.045   2.811  50.648  1.00  0.00           C  
ATOM   1076  O   THR A  90      62.287   3.978  50.954  1.00  0.00           O  
ATOM   1077  CB  THR A  90      61.995   0.763  52.071  1.00  0.00           C  
ATOM   1078  OG1 THR A  90      61.130  -0.284  52.525  1.00  0.00           O  
ATOM   1079  CG2 THR A  90      62.893   1.214  53.214  1.00  0.00           C  
ATOM   1080  H   THR A  90      59.686   0.548  50.930  1.00  0.00           H  
ATOM   1081  HA  THR A  90      60.819   2.527  52.373  1.00  0.00           H  
ATOM   1082  HB  THR A  90      62.617   0.385  51.272  1.00  0.00           H  
ATOM   1083  HG1 THR A  90      61.628  -0.899  53.068  1.00  0.00           H  
ATOM   1084 HG21 THR A  90      63.614   0.439  53.433  1.00  0.00           H  
ATOM   1085 HG22 THR A  90      62.293   1.407  54.090  1.00  0.00           H  
ATOM   1086 HG23 THR A  90      63.413   2.116  52.926  1.00  0.00           H  
ATOM   1087  N   GLU A  91      62.523   2.235  49.548  1.00  0.00           N  
ATOM   1088  CA  GLU A  91      63.381   2.962  48.618  1.00  0.00           C  
ATOM   1089  C   GLU A  91      62.990   4.435  48.555  1.00  0.00           C  
ATOM   1090  O   GLU A  91      63.831   5.319  48.711  1.00  0.00           O  
ATOM   1091  CB  GLU A  91      63.298   2.340  47.223  1.00  0.00           C  
ATOM   1092  CG  GLU A  91      63.794   0.905  47.166  1.00  0.00           C  
ATOM   1093  CD  GLU A  91      63.194   0.127  46.010  1.00  0.00           C  
ATOM   1094  OE1 GLU A  91      62.070   0.465  45.586  1.00  0.00           O  
ATOM   1095  OE2 GLU A  91      63.852  -0.820  45.530  1.00  0.00           O  
ATOM   1096  H   GLU A  91      62.294   1.303  49.358  1.00  0.00           H  
ATOM   1097  HA  GLU A  91      64.396   2.887  48.977  1.00  0.00           H  
ATOM   1098  HB2 GLU A  91      62.271   2.358  46.894  1.00  0.00           H  
ATOM   1099  HB3 GLU A  91      63.895   2.932  46.544  1.00  0.00           H  
ATOM   1100  HG2 GLU A  91      64.868   0.911  47.057  1.00  0.00           H  
ATOM   1101  HG3 GLU A  91      63.530   0.410  48.090  1.00  0.00           H  
ATOM   1102  N   GLU A  92      61.706   4.692  48.322  1.00  0.00           N  
ATOM   1103  CA  GLU A  92      61.203   6.057  48.236  1.00  0.00           C  
ATOM   1104  C   GLU A  92      61.546   6.844  49.499  1.00  0.00           C  
ATOM   1105  O   GLU A  92      62.207   7.880  49.437  1.00  0.00           O  
ATOM   1106  CB  GLU A  92      59.689   6.055  48.019  1.00  0.00           C  
ATOM   1107  CG  GLU A  92      59.276   5.627  46.620  1.00  0.00           C  
ATOM   1108  CD  GLU A  92      60.266   6.067  45.559  1.00  0.00           C  
ATOM   1109  OE1 GLU A  92      60.259   7.263  45.201  1.00  0.00           O  
ATOM   1110  OE2 GLU A  92      61.047   5.215  45.088  1.00  0.00           O  
ATOM   1111  H   GLU A  92      61.082   3.944  48.206  1.00  0.00           H  
ATOM   1112  HA  GLU A  92      61.678   6.534  47.391  1.00  0.00           H  
ATOM   1113  HB2 GLU A  92      59.237   5.378  48.728  1.00  0.00           H  
ATOM   1114  HB3 GLU A  92      59.311   7.052  48.194  1.00  0.00           H  
ATOM   1115  HG2 GLU A  92      59.198   4.552  46.594  1.00  0.00           H  
ATOM   1116  HG3 GLU A  92      58.313   6.062  46.395  1.00  0.00           H  
ATOM   1117  N   SER A  93      61.089   6.343  50.643  1.00  0.00           N  
ATOM   1118  CA  SER A  93      61.343   7.000  51.919  1.00  0.00           C  
ATOM   1119  C   SER A  93      62.788   7.480  52.006  1.00  0.00           C  
ATOM   1120  O   SER A  93      63.051   8.663  52.221  1.00  0.00           O  
ATOM   1121  CB  SER A  93      61.039   6.047  53.076  1.00  0.00           C  
ATOM   1122  OG  SER A  93      61.834   6.351  54.210  1.00  0.00           O  
ATOM   1123  H   SER A  93      60.567   5.513  50.626  1.00  0.00           H  
ATOM   1124  HA  SER A  93      60.688   7.856  51.987  1.00  0.00           H  
ATOM   1125  HB2 SER A  93      59.999   6.134  53.349  1.00  0.00           H  
ATOM   1126  HB3 SER A  93      61.248   5.032  52.766  1.00  0.00           H  
ATOM   1127  HG  SER A  93      61.731   5.660  54.869  1.00  0.00           H  
ATOM   1128  N   LYS A  94      63.725   6.552  51.836  1.00  0.00           N  
ATOM   1129  CA  LYS A  94      65.144   6.877  51.894  1.00  0.00           C  
ATOM   1130  C   LYS A  94      65.480   8.021  50.941  1.00  0.00           C  
ATOM   1131  O   LYS A  94      66.088   9.014  51.341  1.00  0.00           O  
ATOM   1132  CB  LYS A  94      65.986   5.647  51.544  1.00  0.00           C  
ATOM   1133  CG  LYS A  94      66.135   4.666  52.694  1.00  0.00           C  
ATOM   1134  CD  LYS A  94      66.289   3.240  52.194  1.00  0.00           C  
ATOM   1135  CE  LYS A  94      67.671   3.002  51.606  1.00  0.00           C  
ATOM   1136  NZ  LYS A  94      67.780   1.660  50.969  1.00  0.00           N  
ATOM   1137  H   LYS A  94      63.453   5.625  51.668  1.00  0.00           H  
ATOM   1138  HA  LYS A  94      65.374   7.185  52.902  1.00  0.00           H  
ATOM   1139  HB2 LYS A  94      65.521   5.131  50.717  1.00  0.00           H  
ATOM   1140  HB3 LYS A  94      66.972   5.972  51.247  1.00  0.00           H  
ATOM   1141  HG2 LYS A  94      67.008   4.930  53.271  1.00  0.00           H  
ATOM   1142  HG3 LYS A  94      65.256   4.724  53.322  1.00  0.00           H  
ATOM   1143  HD2 LYS A  94      66.139   2.559  53.020  1.00  0.00           H  
ATOM   1144  HD3 LYS A  94      65.545   3.052  51.432  1.00  0.00           H  
ATOM   1145  HE2 LYS A  94      67.867   3.760  50.863  1.00  0.00           H  
ATOM   1146  HE3 LYS A  94      68.402   3.076  52.397  1.00  0.00           H  
ATOM   1147  HZ1 LYS A  94      68.434   1.060  51.511  1.00  0.00           H  
ATOM   1148  HZ2 LYS A  94      68.137   1.753  49.997  1.00  0.00           H  
ATOM   1149  HZ3 LYS A  94      66.846   1.201  50.942  1.00  0.00           H  
ATOM   1150  N   ARG A  95      65.076   7.876  49.684  1.00  0.00           N  
ATOM   1151  CA  ARG A  95      65.334   8.898  48.677  1.00  0.00           C  
ATOM   1152  C   ARG A  95      64.969  10.283  49.200  1.00  0.00           C  
ATOM   1153  O   ARG A  95      65.708  11.246  49.003  1.00  0.00           O  
ATOM   1154  CB  ARG A  95      64.543   8.598  47.402  1.00  0.00           C  
ATOM   1155  CG  ARG A  95      64.411   9.794  46.473  1.00  0.00           C  
ATOM   1156  CD  ARG A  95      63.373   9.544  45.388  1.00  0.00           C  
ATOM   1157  NE  ARG A  95      63.948   8.879  44.222  1.00  0.00           N  
ATOM   1158  CZ  ARG A  95      63.392   8.899  43.017  1.00  0.00           C  
ATOM   1159  NH1 ARG A  95      62.252   9.546  42.819  1.00  0.00           N  
ATOM   1160  NH2 ARG A  95      63.976   8.270  42.004  1.00  0.00           N  
ATOM   1161  H   ARG A  95      64.596   7.062  49.427  1.00  0.00           H  
ATOM   1162  HA  ARG A  95      66.389   8.879  48.446  1.00  0.00           H  
ATOM   1163  HB2 ARG A  95      65.037   7.804  46.863  1.00  0.00           H  
ATOM   1164  HB3 ARG A  95      63.550   8.273  47.677  1.00  0.00           H  
ATOM   1165  HG2 ARG A  95      64.112  10.657  47.049  1.00  0.00           H  
ATOM   1166  HG3 ARG A  95      65.366   9.982  46.008  1.00  0.00           H  
ATOM   1167  HD2 ARG A  95      62.589   8.922  45.795  1.00  0.00           H  
ATOM   1168  HD3 ARG A  95      62.958  10.492  45.082  1.00  0.00           H  
ATOM   1169  HE  ARG A  95      64.791   8.396  44.346  1.00  0.00           H  
ATOM   1170 HH11 ARG A  95      61.810  10.023  43.579  1.00  0.00           H  
ATOM   1171 HH12 ARG A  95      61.836   9.561  41.909  1.00  0.00           H  
ATOM   1172 HH21 ARG A  95      64.836   7.781  42.149  1.00  0.00           H  
ATOM   1173 HH22 ARG A  95      63.557   8.285  41.097  1.00  0.00           H  
ATOM   1174  N   ALA A  96      63.825  10.374  49.871  1.00  0.00           N  
ATOM   1175  CA  ALA A  96      63.363  11.640  50.426  1.00  0.00           C  
ATOM   1176  C   ALA A  96      64.131  11.997  51.693  1.00  0.00           C  
ATOM   1177  O   ALA A  96      64.343  13.173  51.993  1.00  0.00           O  
ATOM   1178  CB  ALA A  96      61.869  11.578  50.711  1.00  0.00           C  
ATOM   1179  H   ALA A  96      63.279   9.569  49.997  1.00  0.00           H  
ATOM   1180  HA  ALA A  96      63.530  12.410  49.686  1.00  0.00           H  
ATOM   1181  HB1 ALA A  96      61.348  12.252  50.047  1.00  0.00           H  
ATOM   1182  HB2 ALA A  96      61.515  10.570  50.553  1.00  0.00           H  
ATOM   1183  HB3 ALA A  96      61.686  11.869  51.734  1.00  0.00           H  
ATOM   1184  N   TYR A  97      64.545  10.976  52.436  1.00  0.00           N  
ATOM   1185  CA  TYR A  97      65.288  11.183  53.674  1.00  0.00           C  
ATOM   1186  C   TYR A  97      66.667  11.772  53.390  1.00  0.00           C  
ATOM   1187  O   TYR A  97      67.179  12.583  54.160  1.00  0.00           O  
ATOM   1188  CB  TYR A  97      65.430   9.864  54.434  1.00  0.00           C  
ATOM   1189  CG  TYR A  97      66.553   9.866  55.446  1.00  0.00           C  
ATOM   1190  CD1 TYR A  97      66.400  10.485  56.680  1.00  0.00           C  
ATOM   1191  CD2 TYR A  97      67.766   9.248  55.168  1.00  0.00           C  
ATOM   1192  CE1 TYR A  97      67.424  10.490  57.608  1.00  0.00           C  
ATOM   1193  CE2 TYR A  97      68.794   9.247  56.092  1.00  0.00           C  
ATOM   1194  CZ  TYR A  97      68.618   9.870  57.309  1.00  0.00           C  
ATOM   1195  OH  TYR A  97      69.640   9.872  58.231  1.00  0.00           O  
ATOM   1196  H   TYR A  97      64.346  10.062  52.146  1.00  0.00           H  
ATOM   1197  HA  TYR A  97      64.730  11.880  54.282  1.00  0.00           H  
ATOM   1198  HB2 TYR A  97      64.510   9.658  54.960  1.00  0.00           H  
ATOM   1199  HB3 TYR A  97      65.621   9.068  53.729  1.00  0.00           H  
ATOM   1200  HD1 TYR A  97      65.462  10.970  56.912  1.00  0.00           H  
ATOM   1201  HD2 TYR A  97      67.900   8.761  54.213  1.00  0.00           H  
ATOM   1202  HE1 TYR A  97      67.286  10.978  58.563  1.00  0.00           H  
ATOM   1203  HE2 TYR A  97      69.731   8.762  55.856  1.00  0.00           H  
ATOM   1204  HH  TYR A  97      69.372   9.373  59.007  1.00  0.00           H  
ATOM   1205  N   VAL A  98      67.263  11.353  52.277  1.00  0.00           N  
ATOM   1206  CA  VAL A  98      68.582  11.839  51.889  1.00  0.00           C  
ATOM   1207  C   VAL A  98      68.476  13.088  51.023  1.00  0.00           C  
ATOM   1208  O   VAL A  98      69.442  13.835  50.867  1.00  0.00           O  
ATOM   1209  CB  VAL A  98      69.373  10.762  51.123  1.00  0.00           C  
ATOM   1210  CG1 VAL A  98      70.841  11.149  51.020  1.00  0.00           C  
ATOM   1211  CG2 VAL A  98      69.217   9.406  51.796  1.00  0.00           C  
ATOM   1212  H   VAL A  98      66.804  10.704  51.704  1.00  0.00           H  
ATOM   1213  HA  VAL A  98      69.127  12.083  52.791  1.00  0.00           H  
ATOM   1214  HB  VAL A  98      68.971  10.692  50.123  1.00  0.00           H  
ATOM   1215 HG11 VAL A  98      71.303  10.595  50.216  1.00  0.00           H  
ATOM   1216 HG12 VAL A  98      70.921  12.209  50.821  1.00  0.00           H  
ATOM   1217 HG13 VAL A  98      71.339  10.918  51.949  1.00  0.00           H  
ATOM   1218 HG21 VAL A  98      69.783   9.394  52.716  1.00  0.00           H  
ATOM   1219 HG22 VAL A  98      68.174   9.230  52.014  1.00  0.00           H  
ATOM   1220 HG23 VAL A  98      69.582   8.633  51.138  1.00  0.00           H  
ATOM   1221  N   THR A  99      67.292  13.312  50.460  1.00  0.00           N  
ATOM   1222  CA  THR A  99      67.057  14.472  49.609  1.00  0.00           C  
ATOM   1223  C   THR A  99      66.344  15.580  50.372  1.00  0.00           C  
ATOM   1224  O   THR A  99      66.884  16.673  50.551  1.00  0.00           O  
ATOM   1225  CB  THR A  99      66.222  14.097  48.370  1.00  0.00           C  
ATOM   1226  OG1 THR A  99      66.971  13.222  47.519  1.00  0.00           O  
ATOM   1227  CG2 THR A  99      65.818  15.343  47.593  1.00  0.00           C  
ATOM   1228  H   THR A  99      66.560  12.681  50.622  1.00  0.00           H  
ATOM   1229  HA  THR A  99      68.017  14.837  49.273  1.00  0.00           H  
ATOM   1230  HB  THR A  99      65.327  13.590  48.697  1.00  0.00           H  
ATOM   1231  HG1 THR A  99      67.055  12.363  47.939  1.00  0.00           H  
ATOM   1232 HG21 THR A  99      66.568  16.109  47.726  1.00  0.00           H  
ATOM   1233 HG22 THR A  99      64.868  15.702  47.959  1.00  0.00           H  
ATOM   1234 HG23 THR A  99      65.734  15.101  46.545  1.00  0.00           H  
ATOM   1235  N   LEU A 100      65.128  15.294  50.823  1.00  0.00           N  
ATOM   1236  CA  LEU A 100      64.339  16.266  51.570  1.00  0.00           C  
ATOM   1237  C   LEU A 100      65.108  16.771  52.786  1.00  0.00           C  
ATOM   1238  O   LEU A 100      65.193  17.975  53.024  1.00  0.00           O  
ATOM   1239  CB  LEU A 100      63.012  15.647  52.012  1.00  0.00           C  
ATOM   1240  CG  LEU A 100      62.201  14.949  50.918  1.00  0.00           C  
ATOM   1241  CD1 LEU A 100      60.845  14.517  51.455  1.00  0.00           C  
ATOM   1242  CD2 LEU A 100      62.033  15.862  49.714  1.00  0.00           C  
ATOM   1243  H   LEU A 100      64.749  14.406  50.649  1.00  0.00           H  
ATOM   1244  HA  LEU A 100      64.137  17.102  50.916  1.00  0.00           H  
ATOM   1245  HB2 LEU A 100      63.226  14.921  52.779  1.00  0.00           H  
ATOM   1246  HB3 LEU A 100      62.400  16.437  52.426  1.00  0.00           H  
ATOM   1247  HG  LEU A 100      62.730  14.063  50.598  1.00  0.00           H  
ATOM   1248 HD11 LEU A 100      60.983  13.764  52.217  1.00  0.00           H  
ATOM   1249 HD12 LEU A 100      60.252  14.110  50.649  1.00  0.00           H  
ATOM   1250 HD13 LEU A 100      60.336  15.370  51.880  1.00  0.00           H  
ATOM   1251 HD21 LEU A 100      62.910  15.795  49.086  1.00  0.00           H  
ATOM   1252 HD22 LEU A 100      61.907  16.882  50.049  1.00  0.00           H  
ATOM   1253 HD23 LEU A 100      61.163  15.557  49.150  1.00  0.00           H  
ATOM   1254  N   ASN A 101      65.667  15.841  53.554  1.00  0.00           N  
ATOM   1255  CA  ASN A 101      66.430  16.192  54.747  1.00  0.00           C  
ATOM   1256  C   ASN A 101      67.498  17.232  54.423  1.00  0.00           C  
ATOM   1257  O   ASN A 101      68.343  17.021  53.555  1.00  0.00           O  
ATOM   1258  CB  ASN A 101      67.083  14.944  55.345  1.00  0.00           C  
ATOM   1259  CG  ASN A 101      67.682  15.204  56.714  1.00  0.00           C  
ATOM   1260  OD1 ASN A 101      68.172  16.299  56.991  1.00  0.00           O  
ATOM   1261  ND2 ASN A 101      67.646  14.196  57.576  1.00  0.00           N  
ATOM   1262  H   ASN A 101      65.563  14.896  53.313  1.00  0.00           H  
ATOM   1263  HA  ASN A 101      65.744  16.609  55.468  1.00  0.00           H  
ATOM   1264  HB2 ASN A 101      66.339  14.166  55.440  1.00  0.00           H  
ATOM   1265  HB3 ASN A 101      67.869  14.605  54.686  1.00  0.00           H  
ATOM   1266 HD21 ASN A 101      67.240  13.352  57.286  1.00  0.00           H  
ATOM   1267 HD22 ASN A 101      68.026  14.337  58.469  1.00  0.00           H  
ATOM   1268  N   GLY A 102      67.451  18.359  55.128  1.00  0.00           N  
ATOM   1269  CA  GLY A 102      68.420  19.415  54.902  1.00  0.00           C  
ATOM   1270  C   GLY A 102      67.945  20.427  53.878  1.00  0.00           C  
ATOM   1271  O   GLY A 102      68.397  21.574  53.870  1.00  0.00           O  
ATOM   1272  H   GLY A 102      66.754  18.473  55.807  1.00  0.00           H  
ATOM   1273  HA2 GLY A 102      68.607  19.924  55.835  1.00  0.00           H  
ATOM   1274  HA3 GLY A 102      69.342  18.974  54.552  1.00  0.00           H  
ATOM   1275  N   LYS A 103      67.032  20.006  53.011  1.00  0.00           N  
ATOM   1276  CA  LYS A 103      66.495  20.882  51.977  1.00  0.00           C  
ATOM   1277  C   LYS A 103      65.604  21.961  52.586  1.00  0.00           C  
ATOM   1278  O   LYS A 103      64.931  21.727  53.589  1.00  0.00           O  
ATOM   1279  CB  LYS A 103      65.699  20.070  50.952  1.00  0.00           C  
ATOM   1280  CG  LYS A 103      65.360  20.846  49.691  1.00  0.00           C  
ATOM   1281  CD  LYS A 103      64.220  20.194  48.926  1.00  0.00           C  
ATOM   1282  CE  LYS A 103      63.987  20.876  47.586  1.00  0.00           C  
ATOM   1283  NZ  LYS A 103      63.607  22.307  47.751  1.00  0.00           N  
ATOM   1284  H   LYS A 103      66.710  19.081  53.068  1.00  0.00           H  
ATOM   1285  HA  LYS A 103      67.326  21.357  51.480  1.00  0.00           H  
ATOM   1286  HB2 LYS A 103      66.278  19.202  50.671  1.00  0.00           H  
ATOM   1287  HB3 LYS A 103      64.777  19.742  51.408  1.00  0.00           H  
ATOM   1288  HG2 LYS A 103      65.068  21.849  49.965  1.00  0.00           H  
ATOM   1289  HG3 LYS A 103      66.232  20.884  49.056  1.00  0.00           H  
ATOM   1290  HD2 LYS A 103      64.462  19.156  48.751  1.00  0.00           H  
ATOM   1291  HD3 LYS A 103      63.318  20.260  49.516  1.00  0.00           H  
ATOM   1292  HE2 LYS A 103      64.894  20.819  47.006  1.00  0.00           H  
ATOM   1293  HE3 LYS A 103      63.194  20.358  47.067  1.00  0.00           H  
ATOM   1294  HZ1 LYS A 103      62.806  22.389  48.410  1.00  0.00           H  
ATOM   1295  HZ2 LYS A 103      63.330  22.710  46.834  1.00  0.00           H  
ATOM   1296  HZ3 LYS A 103      64.410  22.848  48.129  1.00  0.00           H  
ATOM   1297  N   GLU A 104      65.607  23.140  51.974  1.00  0.00           N  
ATOM   1298  CA  GLU A 104      64.798  24.254  52.457  1.00  0.00           C  
ATOM   1299  C   GLU A 104      63.475  24.332  51.704  1.00  0.00           C  
ATOM   1300  O   GLU A 104      63.336  23.784  50.610  1.00  0.00           O  
ATOM   1301  CB  GLU A 104      65.563  25.571  52.306  1.00  0.00           C  
ATOM   1302  CG  GLU A 104      66.633  25.779  53.365  1.00  0.00           C  
ATOM   1303  CD  GLU A 104      67.955  25.139  52.991  1.00  0.00           C  
ATOM   1304  OE1 GLU A 104      68.026  23.892  52.973  1.00  0.00           O  
ATOM   1305  OE2 GLU A 104      68.918  25.885  52.717  1.00  0.00           O  
ATOM   1306  H   GLU A 104      66.166  23.264  51.178  1.00  0.00           H  
ATOM   1307  HA  GLU A 104      64.594  24.084  53.503  1.00  0.00           H  
ATOM   1308  HB2 GLU A 104      66.036  25.588  51.336  1.00  0.00           H  
ATOM   1309  HB3 GLU A 104      64.860  26.389  52.368  1.00  0.00           H  
ATOM   1310  HG2 GLU A 104      66.789  26.839  53.497  1.00  0.00           H  
ATOM   1311  HG3 GLU A 104      66.289  25.348  54.294  1.00  0.00           H  
ATOM   1312  N   VAL A 105      62.502  25.016  52.298  1.00  0.00           N  
ATOM   1313  CA  VAL A 105      61.188  25.168  51.684  1.00  0.00           C  
ATOM   1314  C   VAL A 105      60.474  26.407  52.211  1.00  0.00           C  
ATOM   1315  O   VAL A 105      60.456  26.660  53.416  1.00  0.00           O  
ATOM   1316  CB  VAL A 105      60.303  23.931  51.939  1.00  0.00           C  
ATOM   1317  CG1 VAL A 105      60.912  22.697  51.294  1.00  0.00           C  
ATOM   1318  CG2 VAL A 105      60.105  23.719  53.434  1.00  0.00           C  
ATOM   1319  H   VAL A 105      62.672  25.430  53.170  1.00  0.00           H  
ATOM   1320  HA  VAL A 105      61.328  25.270  50.619  1.00  0.00           H  
ATOM   1321  HB  VAL A 105      59.338  24.107  51.491  1.00  0.00           H  
ATOM   1322 HG11 VAL A 105      61.746  22.352  51.889  1.00  0.00           H  
ATOM   1323 HG12 VAL A 105      60.166  21.918  51.232  1.00  0.00           H  
ATOM   1324 HG13 VAL A 105      61.259  22.944  50.302  1.00  0.00           H  
ATOM   1325 HG21 VAL A 105      59.652  22.754  53.601  1.00  0.00           H  
ATOM   1326 HG22 VAL A 105      61.061  23.762  53.934  1.00  0.00           H  
ATOM   1327 HG23 VAL A 105      59.460  24.492  53.824  1.00  0.00           H  
ATOM   1328  N   VAL A 106      59.886  27.178  51.301  1.00  0.00           N  
ATOM   1329  CA  VAL A 106      59.170  28.391  51.674  1.00  0.00           C  
ATOM   1330  C   VAL A 106      57.902  28.062  52.454  1.00  0.00           C  
ATOM   1331  O   VAL A 106      57.068  27.279  51.999  1.00  0.00           O  
ATOM   1332  CB  VAL A 106      58.796  29.225  50.434  1.00  0.00           C  
ATOM   1333  CG1 VAL A 106      57.726  30.248  50.782  1.00  0.00           C  
ATOM   1334  CG2 VAL A 106      60.029  29.905  49.859  1.00  0.00           C  
ATOM   1335  H   VAL A 106      59.937  26.923  50.356  1.00  0.00           H  
ATOM   1336  HA  VAL A 106      59.821  28.985  52.298  1.00  0.00           H  
ATOM   1337  HB  VAL A 106      58.395  28.559  49.685  1.00  0.00           H  
ATOM   1338 HG11 VAL A 106      57.675  30.994  50.002  1.00  0.00           H  
ATOM   1339 HG12 VAL A 106      56.769  29.753  50.871  1.00  0.00           H  
ATOM   1340 HG13 VAL A 106      57.975  30.723  51.719  1.00  0.00           H  
ATOM   1341 HG21 VAL A 106      60.285  30.761  50.466  1.00  0.00           H  
ATOM   1342 HG22 VAL A 106      60.854  29.208  49.852  1.00  0.00           H  
ATOM   1343 HG23 VAL A 106      59.823  30.229  48.848  1.00  0.00           H  
ATOM   1344  N   ASP A 107      57.763  28.667  53.629  1.00  0.00           N  
ATOM   1345  CA  ASP A 107      56.595  28.440  54.471  1.00  0.00           C  
ATOM   1346  C   ASP A 107      55.485  29.431  54.139  1.00  0.00           C  
ATOM   1347  O   ASP A 107      55.627  30.262  53.241  1.00  0.00           O  
ATOM   1348  CB  ASP A 107      56.975  28.556  55.949  1.00  0.00           C  
ATOM   1349  CG  ASP A 107      56.870  29.977  56.463  1.00  0.00           C  
ATOM   1350  OD1 ASP A 107      57.587  30.854  55.938  1.00  0.00           O  
ATOM   1351  OD2 ASP A 107      56.068  30.215  57.392  1.00  0.00           O  
ATOM   1352  H   ASP A 107      58.463  29.281  53.936  1.00  0.00           H  
ATOM   1353  HA  ASP A 107      56.236  27.440  54.279  1.00  0.00           H  
ATOM   1354  HB2 ASP A 107      56.316  27.932  56.532  1.00  0.00           H  
ATOM   1355  HB3 ASP A 107      57.994  28.220  56.079  1.00  0.00           H  
ATOM   1356  N   ASP A 108      54.378  29.338  54.869  1.00  0.00           N  
ATOM   1357  CA  ASP A 108      53.242  30.227  54.653  1.00  0.00           C  
ATOM   1358  C   ASP A 108      53.676  31.688  54.717  1.00  0.00           C  
ATOM   1359  O   ASP A 108      53.239  32.512  53.912  1.00  0.00           O  
ATOM   1360  CB  ASP A 108      52.152  29.960  55.692  1.00  0.00           C  
ATOM   1361  CG  ASP A 108      50.776  30.365  55.203  1.00  0.00           C  
ATOM   1362  OD1 ASP A 108      50.565  31.570  54.955  1.00  0.00           O  
ATOM   1363  OD2 ASP A 108      49.908  29.476  55.072  1.00  0.00           O  
ATOM   1364  H   ASP A 108      54.324  28.656  55.570  1.00  0.00           H  
ATOM   1365  HA  ASP A 108      52.846  30.025  53.668  1.00  0.00           H  
ATOM   1366  HB2 ASP A 108      52.135  28.905  55.923  1.00  0.00           H  
ATOM   1367  HB3 ASP A 108      52.375  30.519  56.589  1.00  0.00           H  
ATOM   1368  N   LEU A 109      54.537  32.003  55.678  1.00  0.00           N  
ATOM   1369  CA  LEU A 109      55.029  33.365  55.848  1.00  0.00           C  
ATOM   1370  C   LEU A 109      55.837  33.808  54.632  1.00  0.00           C  
ATOM   1371  O   LEU A 109      55.912  34.996  54.323  1.00  0.00           O  
ATOM   1372  CB  LEU A 109      55.890  33.465  57.109  1.00  0.00           C  
ATOM   1373  CG  LEU A 109      55.230  33.001  58.409  1.00  0.00           C  
ATOM   1374  CD1 LEU A 109      56.198  33.132  59.575  1.00  0.00           C  
ATOM   1375  CD2 LEU A 109      53.960  33.796  58.675  1.00  0.00           C  
ATOM   1376  H   LEU A 109      54.849  31.303  56.288  1.00  0.00           H  
ATOM   1377  HA  LEU A 109      54.174  34.016  55.953  1.00  0.00           H  
ATOM   1378  HB2 LEU A 109      56.773  32.864  56.955  1.00  0.00           H  
ATOM   1379  HB3 LEU A 109      56.176  34.499  57.232  1.00  0.00           H  
ATOM   1380  HG  LEU A 109      54.959  31.959  58.316  1.00  0.00           H  
ATOM   1381 HD11 LEU A 109      55.839  32.547  60.408  1.00  0.00           H  
ATOM   1382 HD12 LEU A 109      56.270  34.169  59.867  1.00  0.00           H  
ATOM   1383 HD13 LEU A 109      57.171  32.774  59.276  1.00  0.00           H  
ATOM   1384 HD21 LEU A 109      53.192  33.491  57.980  1.00  0.00           H  
ATOM   1385 HD22 LEU A 109      54.162  34.850  58.548  1.00  0.00           H  
ATOM   1386 HD23 LEU A 109      53.625  33.612  59.686  1.00  0.00           H  
ATOM   1387  N   GLY A 110      56.441  32.842  53.944  1.00  0.00           N  
ATOM   1388  CA  GLY A 110      57.233  33.153  52.769  1.00  0.00           C  
ATOM   1389  C   GLY A 110      58.723  33.056  53.032  1.00  0.00           C  
ATOM   1390  O   GLY A 110      59.532  33.505  52.222  1.00  0.00           O  
ATOM   1391  H   GLY A 110      56.345  31.912  54.238  1.00  0.00           H  
ATOM   1392  HA2 GLY A 110      56.972  32.463  51.980  1.00  0.00           H  
ATOM   1393  HA3 GLY A 110      57.001  34.157  52.447  1.00  0.00           H  
ATOM   1394  N   GLN A 111      59.084  32.472  54.170  1.00  0.00           N  
ATOM   1395  CA  GLN A 111      60.487  32.322  54.539  1.00  0.00           C  
ATOM   1396  C   GLN A 111      60.934  30.870  54.396  1.00  0.00           C  
ATOM   1397  O   GLN A 111      60.243  29.950  54.834  1.00  0.00           O  
ATOM   1398  CB  GLN A 111      60.713  32.797  55.975  1.00  0.00           C  
ATOM   1399  CG  GLN A 111      60.372  34.264  56.190  1.00  0.00           C  
ATOM   1400  CD  GLN A 111      61.188  34.896  57.301  1.00  0.00           C  
ATOM   1401  OE1 GLN A 111      60.642  35.338  58.312  1.00  0.00           O  
ATOM   1402  NE2 GLN A 111      62.503  34.942  57.117  1.00  0.00           N  
ATOM   1403  H   GLN A 111      58.392  32.134  54.775  1.00  0.00           H  
ATOM   1404  HA  GLN A 111      61.073  32.933  53.870  1.00  0.00           H  
ATOM   1405  HB2 GLN A 111      60.100  32.207  56.639  1.00  0.00           H  
ATOM   1406  HB3 GLN A 111      61.751  32.651  56.231  1.00  0.00           H  
ATOM   1407  HG2 GLN A 111      60.562  34.803  55.274  1.00  0.00           H  
ATOM   1408  HG3 GLN A 111      59.324  34.344  56.442  1.00  0.00           H  
ATOM   1409 HE21 GLN A 111      62.866  34.570  56.285  1.00  0.00           H  
ATOM   1410 HE22 GLN A 111      63.054  35.345  57.818  1.00  0.00           H  
ATOM   1411  N   LYS A 112      62.095  30.672  53.782  1.00  0.00           N  
ATOM   1412  CA  LYS A 112      62.637  29.334  53.581  1.00  0.00           C  
ATOM   1413  C   LYS A 112      63.056  28.713  54.909  1.00  0.00           C  
ATOM   1414  O   LYS A 112      63.857  29.285  55.648  1.00  0.00           O  
ATOM   1415  CB  LYS A 112      63.833  29.382  52.628  1.00  0.00           C  
ATOM   1416  CG  LYS A 112      63.452  29.673  51.187  1.00  0.00           C  
ATOM   1417  CD  LYS A 112      64.549  29.253  50.224  1.00  0.00           C  
ATOM   1418  CE  LYS A 112      64.175  29.564  48.782  1.00  0.00           C  
ATOM   1419  NZ  LYS A 112      64.426  30.990  48.439  1.00  0.00           N  
ATOM   1420  H   LYS A 112      62.601  31.446  53.455  1.00  0.00           H  
ATOM   1421  HA  LYS A 112      61.861  28.724  53.141  1.00  0.00           H  
ATOM   1422  HB2 LYS A 112      64.512  30.153  52.961  1.00  0.00           H  
ATOM   1423  HB3 LYS A 112      64.342  28.429  52.658  1.00  0.00           H  
ATOM   1424  HG2 LYS A 112      62.550  29.129  50.947  1.00  0.00           H  
ATOM   1425  HG3 LYS A 112      63.275  30.733  51.077  1.00  0.00           H  
ATOM   1426  HD2 LYS A 112      65.456  29.784  50.471  1.00  0.00           H  
ATOM   1427  HD3 LYS A 112      64.716  28.189  50.323  1.00  0.00           H  
ATOM   1428  HE2 LYS A 112      64.762  28.937  48.130  1.00  0.00           H  
ATOM   1429  HE3 LYS A 112      63.126  29.347  48.642  1.00  0.00           H  
ATOM   1430  HZ1 LYS A 112      64.502  31.101  47.408  1.00  0.00           H  
ATOM   1431  HZ2 LYS A 112      65.313  31.313  48.877  1.00  0.00           H  
ATOM   1432  HZ3 LYS A 112      63.645  31.584  48.786  1.00  0.00           H  
ATOM   1433  N   ILE A 113      62.512  27.537  55.205  1.00  0.00           N  
ATOM   1434  CA  ILE A 113      62.833  26.837  56.443  1.00  0.00           C  
ATOM   1435  C   ILE A 113      63.574  25.534  56.163  1.00  0.00           C  
ATOM   1436  O   ILE A 113      63.313  24.861  55.165  1.00  0.00           O  
ATOM   1437  CB  ILE A 113      61.564  26.528  57.261  1.00  0.00           C  
ATOM   1438  CG1 ILE A 113      60.704  27.786  57.405  1.00  0.00           C  
ATOM   1439  CG2 ILE A 113      61.936  25.974  58.627  1.00  0.00           C  
ATOM   1440  CD1 ILE A 113      59.400  27.546  58.133  1.00  0.00           C  
ATOM   1441  H   ILE A 113      61.881  27.130  54.577  1.00  0.00           H  
ATOM   1442  HA  ILE A 113      63.469  27.480  57.034  1.00  0.00           H  
ATOM   1443  HB  ILE A 113      60.999  25.773  56.735  1.00  0.00           H  
ATOM   1444 HG12 ILE A 113      61.258  28.531  57.956  1.00  0.00           H  
ATOM   1445 HG13 ILE A 113      60.473  28.168  56.423  1.00  0.00           H  
ATOM   1446 HG21 ILE A 113      62.781  25.307  58.528  1.00  0.00           H  
ATOM   1447 HG22 ILE A 113      62.198  26.788  59.287  1.00  0.00           H  
ATOM   1448 HG23 ILE A 113      61.097  25.432  59.037  1.00  0.00           H  
ATOM   1449 HD11 ILE A 113      58.922  26.663  57.734  1.00  0.00           H  
ATOM   1450 HD12 ILE A 113      59.594  27.407  59.184  1.00  0.00           H  
ATOM   1451 HD13 ILE A 113      58.750  28.398  57.996  1.00  0.00           H  
ATOM   1452  N   THR A 114      64.499  25.183  57.050  1.00  0.00           N  
ATOM   1453  CA  THR A 114      65.277  23.960  56.899  1.00  0.00           C  
ATOM   1454  C   THR A 114      64.661  22.813  57.692  1.00  0.00           C  
ATOM   1455  O   THR A 114      64.684  22.814  58.923  1.00  0.00           O  
ATOM   1456  CB  THR A 114      66.734  24.161  57.358  1.00  0.00           C  
ATOM   1457  OG1 THR A 114      67.191  25.466  56.984  1.00  0.00           O  
ATOM   1458  CG2 THR A 114      67.644  23.106  56.748  1.00  0.00           C  
ATOM   1459  H   THR A 114      64.661  25.762  57.824  1.00  0.00           H  
ATOM   1460  HA  THR A 114      65.285  23.697  55.851  1.00  0.00           H  
ATOM   1461  HB  THR A 114      66.772  24.070  58.434  1.00  0.00           H  
ATOM   1462  HG1 THR A 114      68.147  25.460  56.903  1.00  0.00           H  
ATOM   1463 HG21 THR A 114      68.480  22.926  57.408  1.00  0.00           H  
ATOM   1464 HG22 THR A 114      68.008  23.454  55.793  1.00  0.00           H  
ATOM   1465 HG23 THR A 114      67.091  22.188  56.611  1.00  0.00           H  
ATOM   1466  N   LEU A 115      64.109  21.837  56.980  1.00  0.00           N  
ATOM   1467  CA  LEU A 115      63.486  20.684  57.618  1.00  0.00           C  
ATOM   1468  C   LEU A 115      64.424  19.480  57.603  1.00  0.00           C  
ATOM   1469  O   LEU A 115      65.214  19.308  56.675  1.00  0.00           O  
ATOM   1470  CB  LEU A 115      62.175  20.332  56.912  1.00  0.00           C  
ATOM   1471  CG  LEU A 115      61.305  21.514  56.485  1.00  0.00           C  
ATOM   1472  CD1 LEU A 115      60.028  21.024  55.818  1.00  0.00           C  
ATOM   1473  CD2 LEU A 115      60.978  22.396  57.681  1.00  0.00           C  
ATOM   1474  H   LEU A 115      64.120  21.893  56.002  1.00  0.00           H  
ATOM   1475  HA  LEU A 115      63.274  20.946  58.644  1.00  0.00           H  
ATOM   1476  HB2 LEU A 115      62.418  19.763  56.028  1.00  0.00           H  
ATOM   1477  HB3 LEU A 115      61.594  19.717  57.584  1.00  0.00           H  
ATOM   1478  HG  LEU A 115      61.848  22.112  55.766  1.00  0.00           H  
ATOM   1479 HD11 LEU A 115      60.278  20.327  55.032  1.00  0.00           H  
ATOM   1480 HD12 LEU A 115      59.496  21.865  55.399  1.00  0.00           H  
ATOM   1481 HD13 LEU A 115      59.406  20.533  56.551  1.00  0.00           H  
ATOM   1482 HD21 LEU A 115      60.954  23.430  57.370  1.00  0.00           H  
ATOM   1483 HD22 LEU A 115      61.737  22.268  58.441  1.00  0.00           H  
ATOM   1484 HD23 LEU A 115      60.016  22.116  58.083  1.00  0.00           H  
ATOM   1485  N   TYR A 116      64.328  18.648  58.633  1.00  0.00           N  
ATOM   1486  CA  TYR A 116      65.167  17.461  58.739  1.00  0.00           C  
ATOM   1487  C   TYR A 116      64.316  16.203  58.886  1.00  0.00           C  
ATOM   1488  O   TYR A 116      63.516  16.086  59.815  1.00  0.00           O  
ATOM   1489  CB  TYR A 116      66.119  17.587  59.930  1.00  0.00           C  
ATOM   1490  CG  TYR A 116      67.333  18.443  59.645  1.00  0.00           C  
ATOM   1491  CD1 TYR A 116      67.278  19.826  59.767  1.00  0.00           C  
ATOM   1492  CD2 TYR A 116      68.537  17.868  59.256  1.00  0.00           C  
ATOM   1493  CE1 TYR A 116      68.383  20.613  59.509  1.00  0.00           C  
ATOM   1494  CE2 TYR A 116      69.649  18.647  58.997  1.00  0.00           C  
ATOM   1495  CZ  TYR A 116      69.567  20.017  59.123  1.00  0.00           C  
ATOM   1496  OH  TYR A 116      70.672  20.796  58.865  1.00  0.00           O  
ATOM   1497  H   TYR A 116      63.678  18.838  59.341  1.00  0.00           H  
ATOM   1498  HA  TYR A 116      65.749  17.385  57.833  1.00  0.00           H  
ATOM   1499  HB2 TYR A 116      65.590  18.030  60.759  1.00  0.00           H  
ATOM   1500  HB3 TYR A 116      66.466  16.604  60.212  1.00  0.00           H  
ATOM   1501  HD1 TYR A 116      66.348  20.289  60.070  1.00  0.00           H  
ATOM   1502  HD2 TYR A 116      68.599  16.794  59.158  1.00  0.00           H  
ATOM   1503  HE1 TYR A 116      68.319  21.685  59.607  1.00  0.00           H  
ATOM   1504  HE2 TYR A 116      70.575  18.182  58.694  1.00  0.00           H  
ATOM   1505  HH  TYR A 116      70.576  21.644  59.307  1.00  0.00           H  
ATOM   1506  N   LEU A 117      64.496  15.264  57.964  1.00  0.00           N  
ATOM   1507  CA  LEU A 117      63.746  14.014  57.988  1.00  0.00           C  
ATOM   1508  C   LEU A 117      64.552  12.909  58.665  1.00  0.00           C  
ATOM   1509  O   LEU A 117      65.703  12.659  58.308  1.00  0.00           O  
ATOM   1510  CB  LEU A 117      63.374  13.590  56.566  1.00  0.00           C  
ATOM   1511  CG  LEU A 117      62.187  14.322  55.938  1.00  0.00           C  
ATOM   1512  CD1 LEU A 117      62.607  15.701  55.453  1.00  0.00           C  
ATOM   1513  CD2 LEU A 117      61.604  13.507  54.792  1.00  0.00           C  
ATOM   1514  H   LEU A 117      65.148  15.415  57.249  1.00  0.00           H  
ATOM   1515  HA  LEU A 117      62.842  14.181  58.555  1.00  0.00           H  
ATOM   1516  HB2 LEU A 117      64.234  13.754  55.936  1.00  0.00           H  
ATOM   1517  HB3 LEU A 117      63.140  12.535  56.587  1.00  0.00           H  
ATOM   1518  HG  LEU A 117      61.417  14.451  56.685  1.00  0.00           H  
ATOM   1519 HD11 LEU A 117      62.204  16.453  56.116  1.00  0.00           H  
ATOM   1520 HD12 LEU A 117      62.229  15.863  54.454  1.00  0.00           H  
ATOM   1521 HD13 LEU A 117      63.685  15.768  55.445  1.00  0.00           H  
ATOM   1522 HD21 LEU A 117      62.402  13.180  54.141  1.00  0.00           H  
ATOM   1523 HD22 LEU A 117      60.911  14.118  54.234  1.00  0.00           H  
ATOM   1524 HD23 LEU A 117      61.087  12.646  55.191  1.00  0.00           H  
ATOM   1525  N   ASN A 118      63.939  12.249  59.642  1.00  0.00           N  
ATOM   1526  CA  ASN A 118      64.598  11.171  60.368  1.00  0.00           C  
ATOM   1527  C   ASN A 118      63.842   9.857  60.196  1.00  0.00           C  
ATOM   1528  O   ASN A 118      62.615   9.844  60.097  1.00  0.00           O  
ATOM   1529  CB  ASN A 118      64.707  11.518  61.853  1.00  0.00           C  
ATOM   1530  CG  ASN A 118      65.975  12.287  62.176  1.00  0.00           C  
ATOM   1531  OD1 ASN A 118      67.042  12.003  61.631  1.00  0.00           O  
ATOM   1532  ND2 ASN A 118      65.862  13.265  63.068  1.00  0.00           N  
ATOM   1533  H   ASN A 118      63.020  12.495  59.882  1.00  0.00           H  
ATOM   1534  HA  ASN A 118      65.592  11.056  59.961  1.00  0.00           H  
ATOM   1535  HB2 ASN A 118      63.860  12.126  62.138  1.00  0.00           H  
ATOM   1536  HB3 ASN A 118      64.703  10.607  62.432  1.00  0.00           H  
ATOM   1537 HD21 ASN A 118      64.981  13.434  63.461  1.00  0.00           H  
ATOM   1538 HD22 ASN A 118      66.666  13.777  63.295  1.00  0.00           H  
ATOM   1539  N   PHE A 119      64.582   8.753  60.162  1.00  0.00           N  
ATOM   1540  CA  PHE A 119      63.981   7.434  60.002  1.00  0.00           C  
ATOM   1541  C   PHE A 119      63.293   6.991  61.289  1.00  0.00           C  
ATOM   1542  O   PHE A 119      63.902   6.973  62.359  1.00  0.00           O  
ATOM   1543  CB  PHE A 119      65.045   6.412  59.600  1.00  0.00           C  
ATOM   1544  CG  PHE A 119      65.478   6.528  58.166  1.00  0.00           C  
ATOM   1545  CD1 PHE A 119      64.542   6.566  57.147  1.00  0.00           C  
ATOM   1546  CD2 PHE A 119      66.823   6.602  57.838  1.00  0.00           C  
ATOM   1547  CE1 PHE A 119      64.937   6.674  55.827  1.00  0.00           C  
ATOM   1548  CE2 PHE A 119      67.225   6.710  56.521  1.00  0.00           C  
ATOM   1549  CZ  PHE A 119      66.280   6.746  55.513  1.00  0.00           C  
ATOM   1550  H   PHE A 119      65.556   8.829  60.246  1.00  0.00           H  
ATOM   1551  HA  PHE A 119      63.243   7.500  59.218  1.00  0.00           H  
ATOM   1552  HB2 PHE A 119      65.918   6.547  60.222  1.00  0.00           H  
ATOM   1553  HB3 PHE A 119      64.653   5.417  59.749  1.00  0.00           H  
ATOM   1554  HD1 PHE A 119      63.490   6.510  57.391  1.00  0.00           H  
ATOM   1555  HD2 PHE A 119      67.562   6.573  58.625  1.00  0.00           H  
ATOM   1556  HE1 PHE A 119      64.196   6.702  55.042  1.00  0.00           H  
ATOM   1557  HE2 PHE A 119      68.274   6.765  56.279  1.00  0.00           H  
ATOM   1558  HZ  PHE A 119      66.591   6.831  54.483  1.00  0.00           H  
ATOM   1559  N   VAL A 120      62.019   6.631  61.178  1.00  0.00           N  
ATOM   1560  CA  VAL A 120      61.245   6.186  62.332  1.00  0.00           C  
ATOM   1561  C   VAL A 120      60.593   4.833  62.068  1.00  0.00           C  
ATOM   1562  O   VAL A 120      59.880   4.660  61.080  1.00  0.00           O  
ATOM   1563  CB  VAL A 120      60.154   7.206  62.704  1.00  0.00           C  
ATOM   1564  CG1 VAL A 120      60.779   8.532  63.112  1.00  0.00           C  
ATOM   1565  CG2 VAL A 120      59.186   7.396  61.546  1.00  0.00           C  
ATOM   1566  H   VAL A 120      61.586   6.666  60.300  1.00  0.00           H  
ATOM   1567  HA  VAL A 120      61.921   6.091  63.170  1.00  0.00           H  
ATOM   1568  HB  VAL A 120      59.602   6.821  63.548  1.00  0.00           H  
ATOM   1569 HG11 VAL A 120      61.855   8.449  63.077  1.00  0.00           H  
ATOM   1570 HG12 VAL A 120      60.454   9.307  62.431  1.00  0.00           H  
ATOM   1571 HG13 VAL A 120      60.471   8.782  64.116  1.00  0.00           H  
ATOM   1572 HG21 VAL A 120      58.484   6.576  61.526  1.00  0.00           H  
ATOM   1573 HG22 VAL A 120      58.649   8.325  61.674  1.00  0.00           H  
ATOM   1574 HG23 VAL A 120      59.736   7.424  60.617  1.00  0.00           H  
ATOM   1575  N   GLU A 121      60.842   3.879  62.958  1.00  0.00           N  
ATOM   1576  CA  GLU A 121      60.279   2.540  62.822  1.00  0.00           C  
ATOM   1577  C   GLU A 121      58.780   2.550  63.110  1.00  0.00           C  
ATOM   1578  O   GLU A 121      57.994   1.930  62.393  1.00  0.00           O  
ATOM   1579  CB  GLU A 121      60.985   1.565  63.765  1.00  0.00           C  
ATOM   1580  CG  GLU A 121      61.080   2.065  65.196  1.00  0.00           C  
ATOM   1581  CD  GLU A 121      61.656   1.026  66.139  1.00  0.00           C  
ATOM   1582  OE1 GLU A 121      61.430  -0.180  65.903  1.00  0.00           O  
ATOM   1583  OE2 GLU A 121      62.332   1.419  67.113  1.00  0.00           O  
ATOM   1584  H   GLU A 121      61.419   4.078  63.725  1.00  0.00           H  
ATOM   1585  HA  GLU A 121      60.434   2.218  61.802  1.00  0.00           H  
ATOM   1586  HB2 GLU A 121      60.446   0.630  63.766  1.00  0.00           H  
ATOM   1587  HB3 GLU A 121      61.987   1.392  63.398  1.00  0.00           H  
ATOM   1588  HG2 GLU A 121      61.714   2.939  65.219  1.00  0.00           H  
ATOM   1589  HG3 GLU A 121      60.090   2.330  65.538  1.00  0.00           H  
ATOM   1590  N   LYS A 122      58.391   3.255  64.166  1.00  0.00           N  
ATOM   1591  CA  LYS A 122      56.988   3.348  64.552  1.00  0.00           C  
ATOM   1592  C   LYS A 122      56.585   4.798  64.794  1.00  0.00           C  
ATOM   1593  O   LYS A 122      57.425   5.645  65.098  1.00  0.00           O  
ATOM   1594  CB  LYS A 122      56.729   2.518  65.811  1.00  0.00           C  
ATOM   1595  CG  LYS A 122      57.619   2.896  66.982  1.00  0.00           C  
ATOM   1596  CD  LYS A 122      57.012   2.463  68.306  1.00  0.00           C  
ATOM   1597  CE  LYS A 122      57.451   1.057  68.688  1.00  0.00           C  
ATOM   1598  NZ  LYS A 122      56.717   0.018  67.916  1.00  0.00           N  
ATOM   1599  H   LYS A 122      59.065   3.728  64.700  1.00  0.00           H  
ATOM   1600  HA  LYS A 122      56.394   2.951  63.742  1.00  0.00           H  
ATOM   1601  HB2 LYS A 122      55.700   2.651  66.110  1.00  0.00           H  
ATOM   1602  HB3 LYS A 122      56.895   1.475  65.581  1.00  0.00           H  
ATOM   1603  HG2 LYS A 122      58.579   2.413  66.864  1.00  0.00           H  
ATOM   1604  HG3 LYS A 122      57.754   3.967  66.990  1.00  0.00           H  
ATOM   1605  HD2 LYS A 122      57.328   3.149  69.079  1.00  0.00           H  
ATOM   1606  HD3 LYS A 122      55.934   2.483  68.222  1.00  0.00           H  
ATOM   1607  HE2 LYS A 122      58.507   0.960  68.494  1.00  0.00           H  
ATOM   1608  HE3 LYS A 122      57.264   0.911  69.742  1.00  0.00           H  
ATOM   1609  HZ1 LYS A 122      55.791   0.384  67.615  1.00  0.00           H  
ATOM   1610  HZ2 LYS A 122      56.569  -0.826  68.505  1.00  0.00           H  
ATOM   1611  HZ3 LYS A 122      57.261  -0.252  67.072  1.00  0.00           H  
ATOM   1612  N   VAL A 123      55.291   5.078  64.660  1.00  0.00           N  
ATOM   1613  CA  VAL A 123      54.776   6.426  64.867  1.00  0.00           C  
ATOM   1614  C   VAL A 123      53.326   6.393  65.342  1.00  0.00           C  
ATOM   1615  O   VAL A 123      52.539   5.558  64.900  1.00  0.00           O  
ATOM   1616  CB  VAL A 123      54.863   7.265  63.578  1.00  0.00           C  
ATOM   1617  CG1 VAL A 123      54.249   8.639  63.793  1.00  0.00           C  
ATOM   1618  CG2 VAL A 123      56.308   7.383  63.117  1.00  0.00           C  
ATOM   1619  H   VAL A 123      54.671   4.361  64.416  1.00  0.00           H  
ATOM   1620  HA  VAL A 123      55.382   6.904  65.624  1.00  0.00           H  
ATOM   1621  HB  VAL A 123      54.301   6.760  62.805  1.00  0.00           H  
ATOM   1622 HG11 VAL A 123      54.147   9.140  62.841  1.00  0.00           H  
ATOM   1623 HG12 VAL A 123      53.277   8.533  64.251  1.00  0.00           H  
ATOM   1624 HG13 VAL A 123      54.889   9.223  64.438  1.00  0.00           H  
ATOM   1625 HG21 VAL A 123      56.933   7.645  63.957  1.00  0.00           H  
ATOM   1626 HG22 VAL A 123      56.634   6.438  62.707  1.00  0.00           H  
ATOM   1627 HG23 VAL A 123      56.383   8.149  62.359  1.00  0.00           H  
ATOM   1628  N   GLN A 124      52.985   7.309  66.243  1.00  0.00           N  
ATOM   1629  CA  GLN A 124      51.631   7.384  66.778  1.00  0.00           C  
ATOM   1630  C   GLN A 124      50.639   7.791  65.693  1.00  0.00           C  
ATOM   1631  O   GLN A 124      50.186   8.934  65.650  1.00  0.00           O  
ATOM   1632  CB  GLN A 124      51.572   8.379  67.937  1.00  0.00           C  
ATOM   1633  CG  GLN A 124      52.176   9.734  67.607  1.00  0.00           C  
ATOM   1634  CD  GLN A 124      51.697  10.830  68.540  1.00  0.00           C  
ATOM   1635  OE1 GLN A 124      50.952  10.572  69.486  1.00  0.00           O  
ATOM   1636  NE2 GLN A 124      52.122  12.060  68.277  1.00  0.00           N  
ATOM   1637  H   GLN A 124      53.658   7.947  66.556  1.00  0.00           H  
ATOM   1638  HA  GLN A 124      51.364   6.403  67.143  1.00  0.00           H  
ATOM   1639  HB2 GLN A 124      50.541   8.527  68.218  1.00  0.00           H  
ATOM   1640  HB3 GLN A 124      52.109   7.965  68.778  1.00  0.00           H  
ATOM   1641  HG2 GLN A 124      53.251   9.664  67.683  1.00  0.00           H  
ATOM   1642  HG3 GLN A 124      51.904   9.997  66.596  1.00  0.00           H  
ATOM   1643 HE21 GLN A 124      52.712  12.190  67.504  1.00  0.00           H  
ATOM   1644 HE22 GLN A 124      51.827  12.787  68.861  1.00  0.00           H  
ATOM   1645  N   TRP A 125      50.307   6.848  64.819  1.00  0.00           N  
ATOM   1646  CA  TRP A 125      49.368   7.109  63.732  1.00  0.00           C  
ATOM   1647  C   TRP A 125      47.946   7.251  64.264  1.00  0.00           C  
ATOM   1648  O   TRP A 125      47.647   6.827  65.380  1.00  0.00           O  
ATOM   1649  CB  TRP A 125      49.430   5.986  62.697  1.00  0.00           C  
ATOM   1650  CG  TRP A 125      50.771   5.855  62.041  1.00  0.00           C  
ATOM   1651  CD1 TRP A 125      51.724   4.914  62.306  1.00  0.00           C  
ATOM   1652  CD2 TRP A 125      51.308   6.694  61.012  1.00  0.00           C  
ATOM   1653  NE1 TRP A 125      52.822   5.118  61.505  1.00  0.00           N  
ATOM   1654  CE2 TRP A 125      52.591   6.204  60.702  1.00  0.00           C  
ATOM   1655  CE3 TRP A 125      50.829   7.812  60.323  1.00  0.00           C  
ATOM   1656  CZ2 TRP A 125      53.398   6.793  59.733  1.00  0.00           C  
ATOM   1657  CZ3 TRP A 125      51.632   8.396  59.363  1.00  0.00           C  
ATOM   1658  CH2 TRP A 125      52.904   7.886  59.073  1.00  0.00           C  
ATOM   1659  H   TRP A 125      50.702   5.955  64.905  1.00  0.00           H  
ATOM   1660  HA  TRP A 125      49.658   8.037  63.262  1.00  0.00           H  
ATOM   1661  HB2 TRP A 125      49.202   5.047  63.179  1.00  0.00           H  
ATOM   1662  HB3 TRP A 125      48.698   6.177  61.925  1.00  0.00           H  
ATOM   1663  HD1 TRP A 125      51.618   4.132  63.042  1.00  0.00           H  
ATOM   1664  HE1 TRP A 125      53.637   4.573  61.506  1.00  0.00           H  
ATOM   1665  HE3 TRP A 125      49.851   8.220  60.533  1.00  0.00           H  
ATOM   1666  HZ2 TRP A 125      54.381   6.412  59.498  1.00  0.00           H  
ATOM   1667  HZ3 TRP A 125      51.279   9.260  58.820  1.00  0.00           H  
ATOM   1668  HH2 TRP A 125      53.496   8.374  58.316  1.00  0.00           H  
ATOM   1669  N   SER A 126      47.074   7.846  63.458  1.00  0.00           N  
ATOM   1670  CA  SER A 126      45.684   8.047  63.850  1.00  0.00           C  
ATOM   1671  C   SER A 126      44.812   6.893  63.364  1.00  0.00           C  
ATOM   1672  O   SER A 126      43.713   7.102  62.854  1.00  0.00           O  
ATOM   1673  CB  SER A 126      45.158   9.369  63.288  1.00  0.00           C  
ATOM   1674  OG  SER A 126      44.988   9.294  61.883  1.00  0.00           O  
ATOM   1675  H   SER A 126      47.374   8.163  62.580  1.00  0.00           H  
ATOM   1676  HA  SER A 126      45.645   8.082  64.928  1.00  0.00           H  
ATOM   1677  HB2 SER A 126      44.206   9.597  63.742  1.00  0.00           H  
ATOM   1678  HB3 SER A 126      45.861  10.157  63.514  1.00  0.00           H  
ATOM   1679  HG  SER A 126      45.737   8.836  61.494  1.00  0.00           H  
ATOM   1680  N   GLY A 127      45.311   5.671  63.529  1.00  0.00           N  
ATOM   1681  CA  GLY A 127      44.567   4.502  63.103  1.00  0.00           C  
ATOM   1682  C   GLY A 127      44.841   3.291  63.973  1.00  0.00           C  
ATOM   1683  O   GLY A 127      45.944   3.107  64.489  1.00  0.00           O  
ATOM   1684  H   GLY A 127      46.193   5.564  63.943  1.00  0.00           H  
ATOM   1685  HA2 GLY A 127      43.512   4.726  63.139  1.00  0.00           H  
ATOM   1686  HA3 GLY A 127      44.839   4.267  62.083  1.00  0.00           H  
ATOM   1687  N   PRO A 128      43.820   2.439  64.147  1.00  0.00           N  
ATOM   1688  CA  PRO A 128      43.931   1.225  64.962  1.00  0.00           C  
ATOM   1689  C   PRO A 128      44.826   0.174  64.316  1.00  0.00           C  
ATOM   1690  O   PRO A 128      44.451  -0.449  63.322  1.00  0.00           O  
ATOM   1691  CB  PRO A 128      42.489   0.721  65.047  1.00  0.00           C  
ATOM   1692  CG  PRO A 128      41.825   1.266  63.830  1.00  0.00           C  
ATOM   1693  CD  PRO A 128      42.477   2.594  63.562  1.00  0.00           C  
ATOM   1694  HA  PRO A 128      44.298   1.446  65.955  1.00  0.00           H  
ATOM   1695  HB2 PRO A 128      42.483  -0.361  65.051  1.00  0.00           H  
ATOM   1696  HB3 PRO A 128      42.027   1.092  65.949  1.00  0.00           H  
ATOM   1697  HG2 PRO A 128      41.978   0.598  62.997  1.00  0.00           H  
ATOM   1698  HG3 PRO A 128      40.768   1.399  64.017  1.00  0.00           H  
ATOM   1699  HD2 PRO A 128      42.538   2.778  62.500  1.00  0.00           H  
ATOM   1700  HD3 PRO A 128      41.933   3.388  64.054  1.00  0.00           H  
ATOM   1701  N   SER A 129      46.011  -0.022  64.886  1.00  0.00           N  
ATOM   1702  CA  SER A 129      46.962  -0.996  64.362  1.00  0.00           C  
ATOM   1703  C   SER A 129      46.386  -2.407  64.435  1.00  0.00           C  
ATOM   1704  O   SER A 129      46.327  -3.011  65.506  1.00  0.00           O  
ATOM   1705  CB  SER A 129      48.277  -0.928  65.141  1.00  0.00           C  
ATOM   1706  OG  SER A 129      48.066  -1.185  66.520  1.00  0.00           O  
ATOM   1707  H   SER A 129      46.253   0.506  65.676  1.00  0.00           H  
ATOM   1708  HA  SER A 129      47.152  -0.750  63.329  1.00  0.00           H  
ATOM   1709  HB2 SER A 129      48.961  -1.665  64.751  1.00  0.00           H  
ATOM   1710  HB3 SER A 129      48.705   0.058  65.032  1.00  0.00           H  
ATOM   1711  HG  SER A 129      47.305  -1.760  66.625  1.00  0.00           H  
ATOM   1712  N   SER A 130      45.962  -2.927  63.287  1.00  0.00           N  
ATOM   1713  CA  SER A 130      45.388  -4.265  63.219  1.00  0.00           C  
ATOM   1714  C   SER A 130      46.447  -5.326  63.504  1.00  0.00           C  
ATOM   1715  O   SER A 130      47.523  -5.322  62.907  1.00  0.00           O  
ATOM   1716  CB  SER A 130      44.767  -4.508  61.843  1.00  0.00           C  
ATOM   1717  OG  SER A 130      44.232  -5.817  61.748  1.00  0.00           O  
ATOM   1718  H   SER A 130      46.036  -2.395  62.467  1.00  0.00           H  
ATOM   1719  HA  SER A 130      44.616  -4.334  63.971  1.00  0.00           H  
ATOM   1720  HB2 SER A 130      43.972  -3.797  61.679  1.00  0.00           H  
ATOM   1721  HB3 SER A 130      45.523  -4.385  61.083  1.00  0.00           H  
ATOM   1722  HG  SER A 130      44.690  -6.395  62.361  1.00  0.00           H  
ATOM   1723  N   GLY A 131      46.134  -6.234  64.424  1.00  0.00           N  
ATOM   1724  CA  GLY A 131      47.069  -7.288  64.775  1.00  0.00           C  
ATOM   1725  C   GLY A 131      47.853  -6.974  66.034  1.00  0.00           C  
ATOM   1726  O   GLY A 131      48.707  -7.754  66.452  1.00  0.00           O  
ATOM   1727  H   GLY A 131      45.262  -6.187  64.869  1.00  0.00           H  
ATOM   1728  HA2 GLY A 131      46.520  -8.205  64.925  1.00  0.00           H  
ATOM   1729  HA3 GLY A 131      47.762  -7.424  63.958  1.00  0.00           H  
TER    1730      GLY A 131                                                      
END
MOLECULE T0487_26_96.pdb
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
END
