
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  260 ( 2009),  selected  260 , name 2fw2_F
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 2fw2_F.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    I     1_F      -       -           -
LGA    T     2_F      -       -           -
LGA    Y     3_F      P      32          5.373
LGA    R     4_F      R      33          1.159
LGA    D     5_F      P      34          0.861
LGA    I     6_F      T      35          1.009
LGA    V     7_F      S      36          1.002
LGA    V     8_F      A      37          0.750
LGA    K     9_F      R      38          0.950
LGA    K    10_F      Q      39          0.900
LGA    E    11_F      L      40          1.109
LGA    D    12_F      D      41          1.513
LGA    G    13_F      G      42          2.184
LGA    F    14_F      I      43          1.784
LGA    T    15_F      R      44          1.221
LGA    Q    16_F      N      45          1.213
LGA    I    17_F      I      46          0.881
LGA    V    18_F      V      47          0.930
LGA    L    19_F      L      48          0.992
LGA    S    20_F      S      49          0.723
LGA    T    21_F      N      50          1.591
LGA    R    22_F      P      51           #
LGA    S    23_F      -       -           -
LGA    T    24_F      K      52          5.588
LGA    E    25_F      K      53          1.029
LGA    K    26_F      R      54          1.449
LGA    N    27_F      N      55          0.713
LGA    A    28_F      T      56          0.873
LGA    L    29_F      L      57          1.127
LGA    N    30_F      S      58          0.775
LGA    T    31_F      L      59          0.830
LGA    E    32_F      A      60          0.580
LGA    V    33_F      M      61          0.763
LGA    I    34_F      L      62          0.591
LGA    K    35_F      K      63          0.437
LGA    E    36_F      S      64          0.390
LGA    M    37_F      L      65          0.479
LGA    V    38_F      Q      66          0.535
LGA    N    39_F      S      67          0.653
LGA    A    40_F      D      68          0.600
LGA    L    41_F      I      69          0.702
LGA    N    42_F      L      70          0.633
LGA    S    43_F      H      71          0.592
LGA    A    44_F      D      72          4.946
LGA    A    45_F      A      73          1.852
LGA    A    46_F      D      74          2.939
LGA    D    47_F      S      75          3.131
LGA    D    48_F      N      76          3.035
LGA    -       -      D      77           -
LGA    S    49_F      L      78          0.947
LGA    K    50_F      K      79          1.314
LGA    L    51_F      V      80          1.236
LGA    V    52_F      I      81          0.800
LGA    L    53_F      I      82          1.087
LGA    F    54_F      I      83          1.095
LGA    S    55_F      S      84          1.139
LGA    A    56_F      A      85          1.102
LGA    A    57_F      E      86          1.410
LGA    G    58_F      G      87          1.492
LGA    S    59_F      P      88          1.484
LGA    V    60_F      V      89          1.309
LGA    F    61_F      F      90          1.082
LGA    C    62_F      S      91          1.123
LGA    C    63_F      S      92          1.179
LGA    G    64_F      G      93          0.940
LGA    L    65_F      H      94          0.823
LGA    D    66_F      D      95          1.516
LGA    F    67_F      L      96          1.144
LGA    G    68_F      K      97          3.719
LGA    Y    69_F      -       -           -
LGA    F    70_F      E      98          1.294
LGA    V    71_F      L      99          3.799
LGA    R    72_F      -       -           -
LGA    H    73_F      -       -           -
LGA    L    74_F      T     100          3.052
LGA    R    75_F      E     101          3.357
LGA    N    76_F      E     102          2.323
LGA    D    77_F      Q     103          3.642
LGA    R    78_F      G     104          2.508
LGA    N    79_F      R     105          2.851
LGA    T    80_F      D     106          3.237
LGA    A    81_F      Y     107          2.498
LGA    S    82_F      H     108          1.954
LGA    L    83_F      A     109          2.922
LGA    E    84_F      E     110          2.544
LGA    M    85_F      V     111          2.616
LGA    V    86_F      F     112          2.931
LGA    D    87_F      Q     113          2.788
LGA    T    88_F      T     114          2.293
LGA    I    89_F      C     115          2.467
LGA    K    90_F      S     116          2.721
LGA    N    91_F      K     117          2.431
LGA    F    92_F      V     118          2.446
LGA    V    93_F      M     119          2.618
LGA    N    94_F      M     120          2.434
LGA    T    95_F      H     121          2.040
LGA    F    96_F      I     122          2.347
LGA    I    97_F      R     123          3.187
LGA    Q    98_F      N     124          2.277
LGA    F    99_F      H     125          1.806
LGA    K   100_F      P     126          2.374
LGA    K   101_F      V     127          1.215
LGA    P   102_F      P     128          0.569
LGA    I   103_F      V     129          0.572
LGA    V   104_F      I     130          0.960
LGA    V   105_F      A     131          1.017
LGA    S   106_F      M     132          0.388
LGA    V   107_F      V     133          0.431
LGA    N   108_F      N     134          1.161
LGA    G   109_F      G     135          1.132
LGA    P   110_F      L     136          0.531
LGA    A   111_F      A     137          0.543
LGA    I   112_F      T     138          0.433
LGA    G   113_F      A     139          0.398
LGA    L   114_F      A     140          0.452
LGA    G   115_F      G     141          0.528
LGA    A   116_F      C     142          0.332
LGA    S   117_F      Q     143          1.489
LGA    I   118_F      L     144          2.308
LGA    L   119_F      V     145          2.056
LGA    P   120_F      A     146          2.408
LGA    L   121_F      S     147          1.965
LGA    C   122_F      C     148          1.292
LGA    D   123_F      D     149          0.955
LGA    L   124_F      I     150          0.540
LGA    V   125_F      A     151          0.444
LGA    W   126_F      V     152          0.359
LGA    A   127_F      A     153          0.448
LGA    N   128_F      S     154          0.702
LGA    E   129_F      D     155          0.734
LGA    K   130_F      K     156          0.793
LGA    A   131_F      S     157          0.536
LGA    W   132_F      S     158          0.320
LGA    F   133_F      F     159          0.415
LGA    Q   134_F      A     160          0.488
LGA    T   135_F      T     161          0.879
LGA    P   136_F      P     162          1.113
LGA    Y   137_F      G     163          2.578
LGA    T   138_F      V     164          1.695
LGA    T   139_F      N     165          1.582
LGA    F   140_F      V     166          3.022
LGA    G   141_F      G     167          2.101
LGA    Q   142_F      L     168          2.611
LGA    S   143_F      F     169          3.418
LGA    -       -      C     170           -
LGA    P   144_F      S     171          1.179
LGA    D   145_F      T     172          0.707
LGA    G   146_F      P     173          4.132
LGA    -       -      G     174           -
LGA    C   147_F      V     175          2.232
LGA    S   148_F      A     176          2.926
LGA    S   149_F      L     177           #
LGA    I   150_F      A     178          3.686
LGA    T   151_F      R     179          1.424
LGA    F   152_F      -       -           -
LGA    P   153_F      -       -           -
LGA    K   154_F      -       -           -
LGA    M   155_F      A     180          3.715
LGA    M   156_F      V     181          2.717
LGA    G   157_F      P     182          2.189
LGA    K   158_F      R     183          1.486
LGA    A   159_F      K     184          1.564
LGA    S   160_F      V     185          1.707
LGA    A   161_F      A     186          1.229
LGA    N   162_F      L     187          0.155
LGA    E   163_F      E     188          0.896
LGA    M   164_F      M     189          1.121
LGA    L   165_F      L     190          1.488
LGA    I   166_F      F     191          1.346
LGA    A   167_F      T     192          1.777
LGA    G   168_F      G     193          1.459
LGA    R   169_F      E     194          2.283
LGA    K   170_F      P     195          0.933
LGA    L   171_F      I     196          0.974
LGA    T   172_F      S     197          0.990
LGA    A   173_F      A     198          0.776
LGA    R   174_F      Q     199          0.755
LGA    E   175_F      E     200          0.668
LGA    A   176_F      A     201          0.480
LGA    C   177_F      L     202          0.426
LGA    A   178_F      L     203          0.373
LGA    K   179_F      H     204          0.709
LGA    G   180_F      G     205          0.288
LGA    L   181_F      L     206          0.192
LGA    V   182_F      L     207          0.637
LGA    S   183_F      S     208          0.774
LGA    Q   184_F      K     209          0.145
LGA    V   185_F      V     210          0.516
LGA    F   186_F      V     211          1.070
LGA    L   187_F      P     212          1.155
LGA    T   188_F      E     213          1.451
LGA    G   189_F      A     214          2.038
LGA    T   190_F      E     215          3.005
LGA    F   191_F      L     216          2.012
LGA    T   192_F      Q     217          1.654
LGA    Q   193_F      E     218          2.959
LGA    E   194_F      E     219          3.154
LGA    V   195_F      T     220          2.348
LGA    M   196_F      M     221          2.606
LGA    I   197_F      -       -           -
LGA    Q   198_F      R     222          0.533
LGA    I   199_F      I     223          3.759
LGA    -       -      A     224           -
LGA    K   200_F      R     225          1.624
LGA    E   201_F      K     226          2.438
LGA    L   202_F      I     227          2.317
LGA    A   203_F      A     228          1.254
LGA    S   204_F      S     229          0.919
LGA    Y   205_F      L     230          1.607
LGA    N   206_F      S     231          1.938
LGA    A   207_F      R     232          1.615
LGA    I   208_F      P     233          2.416
LGA    V   209_F      V     234          2.765
LGA    L   210_F      V     235          1.656
LGA    E   211_F      S     236          1.338
LGA    E   212_F      L     237          2.544
LGA    C   213_F      G     238          2.636
LGA    K   214_F      K     239          1.209
LGA    A   215_F      A     240          1.682
LGA    L   216_F      T     241          2.172
LGA    V   217_F      F     242          1.582
LGA    R   218_F      Y     243          0.823
LGA    C   219_F      K     244          0.536
LGA    N   220_F      Q     245          3.398
LGA    -       -      L     246           -
LGA    I   221_F      P     247          4.253
LGA    K   222_F      Q     248           #
LGA    L   223_F      D     249           -
LGA    E   224_F      L     250           -
LGA    L   225_F      G     251           -
LGA    E   226_F      T     252           -
LGA    Q   227_F      A     253           -
LGA    A   228_F      Y     254           -
LGA    N   229_F      Y     255           -
LGA    E   230_F      L     256           -
LGA    R   231_F      T     257           -
LGA    E   232_F      S     258           -
LGA    C   233_F      Q     259           -
LGA    E   234_F      A     260           -
LGA    V   235_F      M     261           -
LGA    L   236_F      V     262           -
LGA    R   237_F      D     263           -
LGA    K   238_F      N     264           -
LGA    I   239_F      L     265           -
LGA    W   240_F      A     266           -
LGA    S   241_F      L     267           -
LGA    S   242_F      R     268           -
LGA    A   243_F      D     269           -
LGA    Q   244_F      G     270           -
LGA    G   245_F      Q     271           -
LGA    I   246_F      E     272           -
LGA    E   247_F      G     273           -
LGA    S   248_F      I     274           -
LGA    M   249_F      T     275           -
LGA    L   250_F      A     276           -
LGA    K   251_F      F     277           -
LGA    Y   252_F      L     278           -
LGA    V   253_F      Q     279           -
LGA    E   254_F      K     280           -
LGA    N   255_F      R     281           -
LGA    K   256_F      K     282           -
LGA    I   257_F      P     283           -
LGA    D   258_F      V     284           -
LGA    E   259_F      W     285           -
LGA    F   260_F      S     286           -
LGA    -       -      H     287           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  260  256    5.0    209    1.90    26.32     73.130    10.432

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.409916 * X  +   0.908364 * Y  +  -0.082731 * Z  +   7.028333
  Y_new =  -0.897538 * X  +  -0.417854 * Y  +  -0.140793 * Z  + 113.555138
  Z_new =  -0.162461 * X  +   0.016541 * Y  +   0.986576 * Z  +  49.835361 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.016765   -3.124828  [ DEG:     0.9606   -179.0394 ]
  Theta =   0.163184    2.978409  [ DEG:     9.3498    170.6502 ]
  Phi   =  -1.999217    1.142375  [ DEG:  -114.5467     65.4533 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fw2_F                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fw2_F.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  260  256   5.0  209   1.90   26.32  73.130
REMARK  ---------------------------------------------------------- 
MOLECULE 2fw2_F
HEADER    GENE REGULATION                         31-JAN-06   2FW2              
TITLE     CATALYTIC DOMAIN OF CDY                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TESTIS-SPECIFIC CHROMODOMAIN PROTEIN Y 2;                  
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: CDY2A, CDY2;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3) CODON PLUS RIL                  
KEYWDS    CHROMODOMAIN, CHROMOSOME Y, STRUCTURAL GENOMICS, STRUCTURAL           
KEYWDS   2 GENOMICS CONSORTIUM, SGC                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.R.MIN,T.ANTOSHENKO,H.WU,J.WEIGELT,M.SUNDSTROM,                      
AUTHOR   2 C.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,A.N.PLOTNIKOV,                  
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   14-FEB-06 2FW2    0                                                
JRNL        AUTH   J.R.MIN,T.ANTOSHENKO,H.WU,J.WEIGELT,M.SUNDSTROM,             
JRNL        AUTH 2 C.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,A.N.PLOTNIKOV           
JRNL        TITL   THE CRYSTAL STRUCTURE OF CATALYTIC DOMAIN OF HUMAN           
JRNL        TITL 2 TESTIS-SPECIFIC CHROMODOMAIN PROTEIN Y.                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2FW2 A    1   260  UNP    Q9Y6F7   CDY2_HUMAN     282    541             
DBREF  2FW2 B    1   260  UNP    Q9Y6F7   CDY2_HUMAN     282    541             
DBREF  2FW2 C    1   260  UNP    Q9Y6F7   CDY2_HUMAN     282    541             
DBREF  2FW2 D    1   260  UNP    Q9Y6F7   CDY2_HUMAN     282    541             
DBREF  2FW2 E    1   260  UNP    Q9Y6F7   CDY2_HUMAN     282    541             
DBREF  2FW2 F    1   260  UNP    Q9Y6F7   CDY2_HUMAN     282    541             
SEQRES   1 A  260  ILE THR TYR ARG ASP ILE VAL VAL LYS LYS GLU ASP GLY          
SEQRES   2 A  260  PHE THR GLN ILE VAL LEU SER THR ARG SER THR GLU LYS          
SEQRES   3 A  260  ASN ALA LEU ASN THR GLU VAL ILE LYS GLU MET VAL ASN          
SEQRES   4 A  260  ALA LEU ASN SER ALA ALA ALA ASP ASP SER LYS LEU VAL          
SEQRES   5 A  260  LEU PHE SER ALA ALA GLY SER VAL PHE CYS CYS GLY LEU          
SEQRES   6 A  260  ASP PHE GLY TYR PHE VAL ARG HIS LEU ARG ASN ASP ARG          
SEQRES   7 A  260  ASN THR ALA SER LEU GLU MET VAL ASP THR ILE LYS ASN          
SEQRES   8 A  260  PHE VAL ASN THR PHE ILE GLN PHE LYS LYS PRO ILE VAL          
SEQRES   9 A  260  VAL SER VAL ASN GLY PRO ALA ILE GLY LEU GLY ALA SER          
SEQRES  10 A  260  ILE LEU PRO LEU CYS ASP LEU VAL TRP ALA ASN GLU LYS          
SEQRES  11 A  260  ALA TRP PHE GLN THR PRO TYR THR THR PHE GLY GLN SER          
SEQRES  12 A  260  PRO ASP GLY CYS SER SER ILE THR PHE PRO LYS MET MET          
SEQRES  13 A  260  GLY LYS ALA SER ALA ASN GLU MET LEU ILE ALA GLY ARG          
SEQRES  14 A  260  LYS LEU THR ALA ARG GLU ALA CYS ALA LYS GLY LEU VAL          
SEQRES  15 A  260  SER GLN VAL PHE LEU THR GLY THR PHE THR GLN GLU VAL          
SEQRES  16 A  260  MET ILE GLN ILE LYS GLU LEU ALA SER TYR ASN ALA ILE          
SEQRES  17 A  260  VAL LEU GLU GLU CYS LYS ALA LEU VAL ARG CYS ASN ILE          
SEQRES  18 A  260  LYS LEU GLU LEU GLU GLN ALA ASN GLU ARG GLU CYS GLU          
SEQRES  19 A  260  VAL LEU ARG LYS ILE TRP SER SER ALA GLN GLY ILE GLU          
SEQRES  20 A  260  SER MET LEU LYS TYR VAL GLU ASN LYS ILE ASP GLU PHE          
SEQRES   1 B  260  ILE THR TYR ARG ASP ILE VAL VAL LYS LYS GLU ASP GLY          
SEQRES   2 B  260  PHE THR GLN ILE VAL LEU SER THR ARG SER THR GLU LYS          
SEQRES   3 B  260  ASN ALA LEU ASN THR GLU VAL ILE LYS GLU MET VAL ASN          
SEQRES   4 B  260  ALA LEU ASN SER ALA ALA ALA ASP ASP SER LYS LEU VAL          
SEQRES   5 B  260  LEU PHE SER ALA ALA GLY SER VAL PHE CYS CYS GLY LEU          
SEQRES   6 B  260  ASP PHE GLY TYR PHE VAL ARG HIS LEU ARG ASN ASP ARG          
SEQRES   7 B  260  ASN THR ALA SER LEU GLU MET VAL ASP THR ILE LYS ASN          
SEQRES   8 B  260  PHE VAL ASN THR PHE ILE GLN PHE LYS LYS PRO ILE VAL          
SEQRES   9 B  260  VAL SER VAL ASN GLY PRO ALA ILE GLY LEU GLY ALA SER          
SEQRES  10 B  260  ILE LEU PRO LEU CYS ASP LEU VAL TRP ALA ASN GLU LYS          
SEQRES  11 B  260  ALA TRP PHE GLN THR PRO TYR THR THR PHE GLY GLN SER          
SEQRES  12 B  260  PRO ASP GLY CYS SER SER ILE THR PHE PRO LYS MET MET          
SEQRES  13 B  260  GLY LYS ALA SER ALA ASN GLU MET LEU ILE ALA GLY ARG          
SEQRES  14 B  260  LYS LEU THR ALA ARG GLU ALA CYS ALA LYS GLY LEU VAL          
SEQRES  15 B  260  SER GLN VAL PHE LEU THR GLY THR PHE THR GLN GLU VAL          
SEQRES  16 B  260  MET ILE GLN ILE LYS GLU LEU ALA SER TYR ASN ALA ILE          
SEQRES  17 B  260  VAL LEU GLU GLU CYS LYS ALA LEU VAL ARG CYS ASN ILE          
SEQRES  18 B  260  LYS LEU GLU LEU GLU GLN ALA ASN GLU ARG GLU CYS GLU          
SEQRES  19 B  260  VAL LEU ARG LYS ILE TRP SER SER ALA GLN GLY ILE GLU          
SEQRES  20 B  260  SER MET LEU LYS TYR VAL GLU ASN LYS ILE ASP GLU PHE          
SEQRES   1 C  260  ILE THR TYR ARG ASP ILE VAL VAL LYS LYS GLU ASP GLY          
SEQRES   2 C  260  PHE THR GLN ILE VAL LEU SER THR ARG SER THR GLU LYS          
SEQRES   3 C  260  ASN ALA LEU ASN THR GLU VAL ILE LYS GLU MET VAL ASN          
SEQRES   4 C  260  ALA LEU ASN SER ALA ALA ALA ASP ASP SER LYS LEU VAL          
SEQRES   5 C  260  LEU PHE SER ALA ALA GLY SER VAL PHE CYS CYS GLY LEU          
SEQRES   6 C  260  ASP PHE GLY TYR PHE VAL ARG HIS LEU ARG ASN ASP ARG          
SEQRES   7 C  260  ASN THR ALA SER LEU GLU MET VAL ASP THR ILE LYS ASN          
SEQRES   8 C  260  PHE VAL ASN THR PHE ILE GLN PHE LYS LYS PRO ILE VAL          
SEQRES   9 C  260  VAL SER VAL ASN GLY PRO ALA ILE GLY LEU GLY ALA SER          
SEQRES  10 C  260  ILE LEU PRO LEU CYS ASP LEU VAL TRP ALA ASN GLU LYS          
SEQRES  11 C  260  ALA TRP PHE GLN THR PRO TYR THR THR PHE GLY GLN SER          
SEQRES  12 C  260  PRO ASP GLY CYS SER SER ILE THR PHE PRO LYS MET MET          
SEQRES  13 C  260  GLY LYS ALA SER ALA ASN GLU MET LEU ILE ALA GLY ARG          
SEQRES  14 C  260  LYS LEU THR ALA ARG GLU ALA CYS ALA LYS GLY LEU VAL          
SEQRES  15 C  260  SER GLN VAL PHE LEU THR GLY THR PHE THR GLN GLU VAL          
SEQRES  16 C  260  MET ILE GLN ILE LYS GLU LEU ALA SER TYR ASN ALA ILE          
SEQRES  17 C  260  VAL LEU GLU GLU CYS LYS ALA LEU VAL ARG CYS ASN ILE          
SEQRES  18 C  260  LYS LEU GLU LEU GLU GLN ALA ASN GLU ARG GLU CYS GLU          
SEQRES  19 C  260  VAL LEU ARG LYS ILE TRP SER SER ALA GLN GLY ILE GLU          
SEQRES  20 C  260  SER MET LEU LYS TYR VAL GLU ASN LYS ILE ASP GLU PHE          
SEQRES   1 D  260  ILE THR TYR ARG ASP ILE VAL VAL LYS LYS GLU ASP GLY          
SEQRES   2 D  260  PHE THR GLN ILE VAL LEU SER THR ARG SER THR GLU LYS          
SEQRES   3 D  260  ASN ALA LEU ASN THR GLU VAL ILE LYS GLU MET VAL ASN          
SEQRES   4 D  260  ALA LEU ASN SER ALA ALA ALA ASP ASP SER LYS LEU VAL          
SEQRES   5 D  260  LEU PHE SER ALA ALA GLY SER VAL PHE CYS CYS GLY LEU          
SEQRES   6 D  260  ASP PHE GLY TYR PHE VAL ARG HIS LEU ARG ASN ASP ARG          
SEQRES   7 D  260  ASN THR ALA SER LEU GLU MET VAL ASP THR ILE LYS ASN          
SEQRES   8 D  260  PHE VAL ASN THR PHE ILE GLN PHE LYS LYS PRO ILE VAL          
SEQRES   9 D  260  VAL SER VAL ASN GLY PRO ALA ILE GLY LEU GLY ALA SER          
SEQRES  10 D  260  ILE LEU PRO LEU CYS ASP LEU VAL TRP ALA ASN GLU LYS          
SEQRES  11 D  260  ALA TRP PHE GLN THR PRO TYR THR THR PHE GLY GLN SER          
SEQRES  12 D  260  PRO ASP GLY CYS SER SER ILE THR PHE PRO LYS MET MET          
SEQRES  13 D  260  GLY LYS ALA SER ALA ASN GLU MET LEU ILE ALA GLY ARG          
SEQRES  14 D  260  LYS LEU THR ALA ARG GLU ALA CYS ALA LYS GLY LEU VAL          
SEQRES  15 D  260  SER GLN VAL PHE LEU THR GLY THR PHE THR GLN GLU VAL          
SEQRES  16 D  260  MET ILE GLN ILE LYS GLU LEU ALA SER TYR ASN ALA ILE          
SEQRES  17 D  260  VAL LEU GLU GLU CYS LYS ALA LEU VAL ARG CYS ASN ILE          
SEQRES  18 D  260  LYS LEU GLU LEU GLU GLN ALA ASN GLU ARG GLU CYS GLU          
SEQRES  19 D  260  VAL LEU ARG LYS ILE TRP SER SER ALA GLN GLY ILE GLU          
SEQRES  20 D  260  SER MET LEU LYS TYR VAL GLU ASN LYS ILE ASP GLU PHE          
SEQRES   1 E  260  ILE THR TYR ARG ASP ILE VAL VAL LYS LYS GLU ASP GLY          
SEQRES   2 E  260  PHE THR GLN ILE VAL LEU SER THR ARG SER THR GLU LYS          
SEQRES   3 E  260  ASN ALA LEU ASN THR GLU VAL ILE LYS GLU MET VAL ASN          
SEQRES   4 E  260  ALA LEU ASN SER ALA ALA ALA ASP ASP SER LYS LEU VAL          
SEQRES   5 E  260  LEU PHE SER ALA ALA GLY SER VAL PHE CYS CYS GLY LEU          
SEQRES   6 E  260  ASP PHE GLY TYR PHE VAL ARG HIS LEU ARG ASN ASP ARG          
SEQRES   7 E  260  ASN THR ALA SER LEU GLU MET VAL ASP THR ILE LYS ASN          
SEQRES   8 E  260  PHE VAL ASN THR PHE ILE GLN PHE LYS LYS PRO ILE VAL          
SEQRES   9 E  260  VAL SER VAL ASN GLY PRO ALA ILE GLY LEU GLY ALA SER          
SEQRES  10 E  260  ILE LEU PRO LEU CYS ASP LEU VAL TRP ALA ASN GLU LYS          
SEQRES  11 E  260  ALA TRP PHE GLN THR PRO TYR THR THR PHE GLY GLN SER          
SEQRES  12 E  260  PRO ASP GLY CYS SER SER ILE THR PHE PRO LYS MET MET          
SEQRES  13 E  260  GLY LYS ALA SER ALA ASN GLU MET LEU ILE ALA GLY ARG          
SEQRES  14 E  260  LYS LEU THR ALA ARG GLU ALA CYS ALA LYS GLY LEU VAL          
SEQRES  15 E  260  SER GLN VAL PHE LEU THR GLY THR PHE THR GLN GLU VAL          
SEQRES  16 E  260  MET ILE GLN ILE LYS GLU LEU ALA SER TYR ASN ALA ILE          
SEQRES  17 E  260  VAL LEU GLU GLU CYS LYS ALA LEU VAL ARG CYS ASN ILE          
SEQRES  18 E  260  LYS LEU GLU LEU GLU GLN ALA ASN GLU ARG GLU CYS GLU          
SEQRES  19 E  260  VAL LEU ARG LYS ILE TRP SER SER ALA GLN GLY ILE GLU          
SEQRES  20 E  260  SER MET LEU LYS TYR VAL GLU ASN LYS ILE ASP GLU PHE          
SEQRES   1 F  260  ILE THR TYR ARG ASP ILE VAL VAL LYS LYS GLU ASP GLY          
SEQRES   2 F  260  PHE THR GLN ILE VAL LEU SER THR ARG SER THR GLU LYS          
SEQRES   3 F  260  ASN ALA LEU ASN THR GLU VAL ILE LYS GLU MET VAL ASN          
SEQRES   4 F  260  ALA LEU ASN SER ALA ALA ALA ASP ASP SER LYS LEU VAL          
SEQRES   5 F  260  LEU PHE SER ALA ALA GLY SER VAL PHE CYS CYS GLY LEU          
SEQRES   6 F  260  ASP PHE GLY TYR PHE VAL ARG HIS LEU ARG ASN ASP ARG          
SEQRES   7 F  260  ASN THR ALA SER LEU GLU MET VAL ASP THR ILE LYS ASN          
SEQRES   8 F  260  PHE VAL ASN THR PHE ILE GLN PHE LYS LYS PRO ILE VAL          
SEQRES   9 F  260  VAL SER VAL ASN GLY PRO ALA ILE GLY LEU GLY ALA SER          
SEQRES  10 F  260  ILE LEU PRO LEU CYS ASP LEU VAL TRP ALA ASN GLU LYS          
SEQRES  11 F  260  ALA TRP PHE GLN THR PRO TYR THR THR PHE GLY GLN SER          
SEQRES  12 F  260  PRO ASP GLY CYS SER SER ILE THR PHE PRO LYS MET MET          
SEQRES  13 F  260  GLY LYS ALA SER ALA ASN GLU MET LEU ILE ALA GLY ARG          
SEQRES  14 F  260  LYS LEU THR ALA ARG GLU ALA CYS ALA LYS GLY LEU VAL          
SEQRES  15 F  260  SER GLN VAL PHE LEU THR GLY THR PHE THR GLN GLU VAL          
SEQRES  16 F  260  MET ILE GLN ILE LYS GLU LEU ALA SER TYR ASN ALA ILE          
SEQRES  17 F  260  VAL LEU GLU GLU CYS LYS ALA LEU VAL ARG CYS ASN ILE          
SEQRES  18 F  260  LYS LEU GLU LEU GLU GLN ALA ASN GLU ARG GLU CYS GLU          
SEQRES  19 F  260  VAL LEU ARG LYS ILE TRP SER SER ALA GLN GLY ILE GLU          
SEQRES  20 F  260  SER MET LEU LYS TYR VAL GLU ASN LYS ILE ASP GLU PHE          
FORMUL   7  HOH   *664(H2 O)                                                    
CRYST1   80.454  133.579   82.328  90.00 117.56  90.00 P 1 21 1     12          
ATOM   9974  N   ILE F   1     -36.261 107.643  25.864  1.00 45.36           N  
ATOM   9975  CA  ILE F   1     -35.905 109.074  25.652  1.00 45.24           C  
ATOM   9976  C   ILE F   1     -35.577 109.371  24.188  1.00 45.21           C  
ATOM   9977  O   ILE F   1     -35.070 108.507  23.465  1.00 45.13           O  
ATOM   9978  CB  ILE F   1     -34.735 109.463  26.541  1.00 45.14           C  
ATOM   9979  N   THR F   2     -35.895 110.593  23.760  1.00 44.93           N  
ATOM   9980  CA  THR F   2     -35.367 111.148  22.517  1.00 44.70           C  
ATOM   9981  C   THR F   2     -34.309 112.158  22.922  1.00 44.57           C  
ATOM   9982  O   THR F   2     -34.468 112.847  23.937  1.00 44.33           O  
ATOM   9983  CB  THR F   2     -36.440 111.852  21.662  1.00 44.84           C  
ATOM   9984  OG1 THR F   2     -36.996 112.957  22.390  1.00 44.66           O  
ATOM   9985  CG2 THR F   2     -37.545 110.874  21.253  1.00 45.17           C  
ATOM   9986  N   TYR F   3     -33.231 112.232  22.139  1.00 44.51           N  
ATOM   9987  CA  TYR F   3     -32.091 113.091  22.464  1.00 44.40           C  
ATOM   9988  C   TYR F   3     -31.872 114.203  21.429  1.00 44.11           C  
ATOM   9989  O   TYR F   3     -32.155 114.024  20.241  1.00 44.11           O  
ATOM   9990  CB  TYR F   3     -30.808 112.257  22.633  1.00 44.22           C  
ATOM   9991  CG  TYR F   3     -30.919 111.063  23.574  1.00 44.23           C  
ATOM   9992  CD1 TYR F   3     -31.234 109.783  23.089  1.00 44.39           C  
ATOM   9993  CD2 TYR F   3     -30.699 111.209  24.942  1.00 43.73           C  
ATOM   9994  CE1 TYR F   3     -31.334 108.673  23.957  1.00 43.42           C  
ATOM   9995  CE2 TYR F   3     -30.797 110.115  25.812  1.00 43.39           C  
ATOM   9996  CZ  TYR F   3     -31.115 108.856  25.317  1.00 43.44           C  
ATOM   9997  OH  TYR F   3     -31.208 107.791  26.188  1.00 43.17           O  
ATOM   9998  N   ARG F   4     -31.368 115.344  21.900  1.00 43.72           N  
ATOM   9999  CA  ARG F   4     -30.945 116.451  21.036  1.00 43.79           C  
ATOM  10000  C   ARG F   4     -29.805 116.061  20.105  1.00 43.35           C  
ATOM  10001  O   ARG F   4     -29.885 116.281  18.902  1.00 43.23           O  
ATOM  10002  CB  ARG F   4     -30.488 117.661  21.867  1.00 43.83           C  
ATOM  10003  CG  ARG F   4     -31.595 118.388  22.628  1.00 44.91           C  
ATOM  10004  CD  ARG F   4     -31.041 119.337  23.698  1.00 44.90           C  
ATOM  10005  NE  ARG F   4     -32.108 119.841  24.564  1.00 47.59           N  
ATOM  10006  CZ  ARG F   4     -31.936 120.675  25.595  1.00 48.94           C  
ATOM  10007  NH1 ARG F   4     -30.724 121.123  25.916  1.00 49.73           N  
ATOM  10008  NH2 ARG F   4     -32.989 121.068  26.310  1.00 47.82           N  
ATOM  10009  N   ASP F   5     -28.760 115.470  20.678  1.00 42.94           N  
ATOM  10010  CA  ASP F   5     -27.445 115.373  20.045  1.00 42.87           C  
ATOM  10011  C   ASP F   5     -27.046 113.953  19.661  1.00 42.91           C  
ATOM  10012  O   ASP F   5     -25.943 113.737  19.157  1.00 42.87           O  
ATOM  10013  CB  ASP F   5     -26.370 115.950  20.987  1.00 42.92           C  
ATOM  10014  CG  ASP F   5     -26.571 117.444  21.291  1.00 42.51           C  
ATOM  10015  OD1 ASP F   5     -26.200 118.291  20.450  1.00 42.76           O  
ATOM  10016  OD2 ASP F   5     -27.065 117.771  22.388  1.00 41.04           O  
ATOM  10017  N   ILE F   6     -27.913 112.983  19.954  1.00 43.05           N  
ATOM  10018  CA  ILE F   6     -27.727 111.598  19.523  1.00 43.20           C  
ATOM  10019  C   ILE F   6     -29.056 110.946  19.121  1.00 43.52           C  
ATOM  10020  O   ILE F   6     -30.131 111.330  19.602  1.00 43.36           O  
ATOM  10021  CB  ILE F   6     -26.965 110.693  20.591  1.00 43.38           C  
ATOM  10022  CG1 ILE F   6     -27.940 110.022  21.571  1.00 43.20           C  
ATOM  10023  CG2 ILE F   6     -25.804 111.451  21.295  1.00 42.75           C  
ATOM  10024  CD1 ILE F   6     -27.329 109.615  22.889  1.00 43.48           C  
ATOM  10025  N   VAL F   7     -28.960 109.958  18.235  1.00 44.15           N  
ATOM  10026  CA  VAL F   7     -30.082 109.093  17.866  1.00 44.51           C  
ATOM  10027  C   VAL F   7     -29.824 107.662  18.360  1.00 44.59           C  
ATOM  10028  O   VAL F   7     -28.728 107.133  18.198  1.00 44.91           O  
ATOM  10029  CB  VAL F   7     -30.314 109.099  16.332  1.00 44.39           C  
ATOM  10030  CG1 VAL F   7     -31.271 107.984  15.911  1.00 44.38           C  
ATOM  10031  CG2 VAL F   7     -30.848 110.459  15.877  1.00 44.89           C  
ATOM  10032  N   VAL F   8     -30.834 107.046  18.964  1.00 44.78           N  
ATOM  10033  CA  VAL F   8     -30.751 105.644  19.379  1.00 45.03           C  
ATOM  10034  C   VAL F   8     -31.746 104.777  18.574  1.00 45.28           C  
ATOM  10035  O   VAL F   8     -32.898 105.164  18.370  1.00 45.10           O  
ATOM  10036  CB  VAL F   8     -30.920 105.495  20.924  1.00 45.02           C  
ATOM  10037  CG1 VAL F   8     -31.307 104.076  21.324  1.00 45.09           C  
ATOM  10038  CG2 VAL F   8     -29.637 105.923  21.642  1.00 44.74           C  
ATOM  10039  N   LYS F   9     -31.264 103.618  18.114  1.00 45.64           N  
ATOM  10040  CA  LYS F   9     -32.031 102.684  17.288  1.00 45.87           C  
ATOM  10041  C   LYS F   9     -31.951 101.268  17.870  1.00 45.94           C  
ATOM  10042  O   LYS F   9     -30.920 100.587  17.751  1.00 45.42           O  
ATOM  10043  CB  LYS F   9     -31.517 102.691  15.842  1.00 46.03           C  
ATOM  10044  CG  LYS F   9     -31.255 104.074  15.248  1.00 46.38           C  
ATOM  10045  CD  LYS F   9     -31.393 104.058  13.741  1.00 47.33           C  
ATOM  10046  CE  LYS F   9     -31.168 105.445  13.170  1.00 48.56           C  
ATOM  10047  NZ  LYS F   9     -32.330 105.889  12.340  1.00 47.31           N  
ATOM  10048  N   LYS F  10     -33.047 100.834  18.496  1.00 46.09           N  
ATOM  10049  CA  LYS F  10     -33.103  99.530  19.168  1.00 46.15           C  
ATOM  10050  C   LYS F  10     -33.574  98.426  18.214  1.00 46.54           C  
ATOM  10051  O   LYS F  10     -34.736  98.393  17.805  1.00 46.73           O  
ATOM  10052  CB  LYS F  10     -33.980  99.601  20.430  1.00 46.13           C  
ATOM  10053  CG  LYS F  10     -33.492 100.632  21.458  1.00 45.53           C  
ATOM  10054  CD  LYS F  10     -34.473 100.838  22.599  1.00 45.21           C  
ATOM  10055  CE  LYS F  10     -34.528  99.633  23.521  1.00 43.24           C  
ATOM  10056  NZ  LYS F  10     -35.841  99.566  24.185  1.00 41.41           N  
ATOM  10057  N   GLU F  11     -32.640  97.545  17.854  1.00 46.80           N  
ATOM  10058  CA  GLU F  11     -32.876  96.417  16.947  1.00 47.05           C  
ATOM  10059  C   GLU F  11     -32.884  95.094  17.726  1.00 46.67           C  
ATOM  10060  O   GLU F  11     -32.640  95.079  18.930  1.00 46.76           O  
ATOM  10061  CB  GLU F  11     -31.776  96.383  15.872  1.00 47.24           C  
ATOM  10062  CG  GLU F  11     -32.173  96.905  14.480  1.00 49.23           C  
ATOM  10063  CD  GLU F  11     -32.242  98.432  14.372  1.00 51.24           C  
ATOM  10064  OE1 GLU F  11     -31.851  99.131  15.333  1.00 51.12           O  
ATOM  10065  OE2 GLU F  11     -32.690  98.929  13.309  1.00 51.64           O  
ATOM  10066  N   ASP F  12     -33.162  93.981  17.052  1.00 46.41           N  
ATOM  10067  CA  ASP F  12     -33.120  92.688  17.739  1.00 46.14           C  
ATOM  10068  C   ASP F  12     -31.699  92.143  17.826  1.00 45.77           C  
ATOM  10069  O   ASP F  12     -31.038  91.895  16.806  1.00 45.73           O  
ATOM  10070  CB  ASP F  12     -34.104  91.665  17.142  1.00 46.21           C  
ATOM  10071  CG  ASP F  12     -34.035  91.595  15.635  1.00 46.99           C  
ATOM  10072  OD1 ASP F  12     -33.662  92.613  15.004  1.00 47.67           O  
ATOM  10073  OD2 ASP F  12     -34.366  90.519  15.081  1.00 47.22           O  
ATOM  10074  N   GLY F  13     -31.231  91.985  19.062  1.00 45.26           N  
ATOM  10075  CA  GLY F  13     -29.884  91.505  19.329  1.00 44.89           C  
ATOM  10076  C   GLY F  13     -28.867  92.617  19.526  1.00 44.54           C  
ATOM  10077  O   GLY F  13     -27.825  92.384  20.133  1.00 44.59           O  
ATOM  10078  N   PHE F  14     -29.160  93.817  19.014  1.00 44.16           N  
ATOM  10079  CA  PHE F  14     -28.256  94.970  19.166  1.00 43.81           C  
ATOM  10080  C   PHE F  14     -28.962  96.326  19.230  1.00 43.77           C  
ATOM  10081  O   PHE F  14     -30.051  96.500  18.695  1.00 43.44           O  
ATOM  10082  CB  PHE F  14     -27.180  94.990  18.071  1.00 43.38           C  
ATOM  10083  CG  PHE F  14     -27.681  95.453  16.732  1.00 43.34           C  
ATOM  10084  CD1 PHE F  14     -27.507  96.776  16.329  1.00 42.54           C  
ATOM  10085  CD2 PHE F  14     -28.323  94.561  15.863  1.00 41.96           C  
ATOM  10086  CE1 PHE F  14     -27.974  97.201  15.093  1.00 41.69           C  
ATOM  10087  CE2 PHE F  14     -28.787  94.982  14.631  1.00 40.45           C  
ATOM  10088  CZ  PHE F  14     -28.615  96.297  14.245  1.00 41.31           C  
ATOM  10089  N   THR F  15     -28.308  97.274  19.900  1.00 43.80           N  
ATOM  10090  CA  THR F  15     -28.744  98.668  19.973  1.00 43.93           C  
ATOM  10091  C   THR F  15     -27.707  99.564  19.299  1.00 43.77           C  
ATOM  10092  O   THR F  15     -26.516  99.460  19.565  1.00 44.11           O  
ATOM  10093  CB  THR F  15     -28.942  99.127  21.442  1.00 43.92           C  
ATOM  10094  OG1 THR F  15     -29.974  98.338  22.046  1.00 43.81           O  
ATOM  10095  CG2 THR F  15     -29.326 100.606  21.516  1.00 43.66           C  
ATOM  10096  N   GLN F  16     -28.186 100.426  18.412  1.00 43.70           N  
ATOM  10097  CA  GLN F  16     -27.392 101.443  17.745  1.00 43.39           C  
ATOM  10098  C   GLN F  16     -27.457 102.713  18.568  1.00 42.81           C  
ATOM  10099  O   GLN F  16     -28.537 103.104  19.012  1.00 43.52           O  
ATOM  10100  CB  GLN F  16     -28.010 101.735  16.380  1.00 43.94           C  
ATOM  10101  CG  GLN F  16     -27.198 101.365  15.170  1.00 45.12           C  
ATOM  10102  CD  GLN F  16     -26.372 102.527  14.700  1.00 46.25           C  
ATOM  10103  OE1 GLN F  16     -26.036 103.411  15.490  1.00 48.11           O  
ATOM  10104  NE2 GLN F  16     -26.031 102.539  13.419  1.00 44.27           N  
ATOM  10105  N   ILE F  17     -26.304 103.350  18.770  1.00 41.96           N  
ATOM  10106  CA  ILE F  17     -26.208 104.684  19.372  1.00 40.96           C  
ATOM  10107  C   ILE F  17     -25.449 105.574  18.391  1.00 40.63           C  
ATOM  10108  O   ILE F  17     -24.258 105.347  18.134  1.00 40.65           O  
ATOM  10109  CB  ILE F  17     -25.447 104.669  20.739  1.00 40.93           C  
ATOM  10110  CG1 ILE F  17     -26.247 103.903  21.796  1.00 40.50           C  
ATOM  10111  CG2 ILE F  17     -25.154 106.105  21.205  1.00 41.33           C  
ATOM  10112  CD1 ILE F  17     -25.585 103.804  23.155  1.00 40.56           C  
ATOM  10113  N   VAL F  18     -26.124 106.578  17.843  1.00 39.75           N  
ATOM  10114  CA  VAL F  18     -25.537 107.390  16.769  1.00 39.61           C  
ATOM  10115  C   VAL F  18     -25.252 108.785  17.275  1.00 39.77           C  
ATOM  10116  O   VAL F  18     -26.191 109.507  17.635  1.00 39.49           O  
ATOM  10117  CB  VAL F  18     -26.482 107.513  15.506  1.00 39.54           C  
ATOM  10118  CG1 VAL F  18     -25.726 108.064  14.308  1.00 39.10           C  
ATOM  10119  CG2 VAL F  18     -27.111 106.191  15.141  1.00 38.21           C  
ATOM  10120  N   LEU F  19     -23.971 109.165  17.311  1.00 39.71           N  
ATOM  10121  CA  LEU F  19     -23.587 110.538  17.680  1.00 40.14           C  
ATOM  10122  C   LEU F  19     -23.964 111.452  16.516  1.00 39.87           C  
ATOM  10123  O   LEU F  19     -23.460 111.288  15.406  1.00 39.48           O  
ATOM  10124  CB  LEU F  19     -22.081 110.654  17.963  1.00 39.85           C  
ATOM  10125  CG  LEU F  19     -21.492 111.430  19.153  1.00 41.30           C  
ATOM  10126  CD1 LEU F  19     -20.039 111.863  18.850  1.00 40.34           C  
ATOM  10127  CD2 LEU F  19     -22.322 112.629  19.632  1.00 38.43           C  
ATOM  10128  N   SER F  20     -24.855 112.405  16.771  1.00 40.28           N  
ATOM  10129  CA  SER F  20     -25.374 113.276  15.712  1.00 41.13           C  
ATOM  10130  C   SER F  20     -25.709 114.654  16.272  1.00 41.34           C  
ATOM  10131  O   SER F  20     -26.872 114.953  16.544  1.00 41.93           O  
ATOM  10132  CB  SER F  20     -26.609 112.643  15.078  1.00 40.67           C  
ATOM  10133  OG  SER F  20     -27.048 113.414  13.979  1.00 42.13           O  
ATOM  10134  N   THR F  21     -24.690 115.489  16.446  1.00 41.78           N  
ATOM  10135  CA  THR F  21     -24.833 116.652  17.310  1.00 42.73           C  
ATOM  10136  C   THR F  21     -25.519 117.812  16.621  1.00 43.38           C  
ATOM  10137  O   THR F  21     -25.497 117.937  15.396  1.00 43.66           O  
ATOM  10138  CB  THR F  21     -23.495 117.118  17.957  1.00 42.44           C  
ATOM  10139  OG1 THR F  21     -22.639 117.683  16.961  1.00 42.48           O  
ATOM  10140  CG2 THR F  21     -22.790 115.961  18.660  1.00 42.02           C  
ATOM  10141  N   ARG F  22     -26.150 118.644  17.439  1.00 44.20           N  
ATOM  10142  CA  ARG F  22     -26.823 119.837  16.977  1.00 44.80           C  
ATOM  10143  C   ARG F  22     -26.260 121.086  17.656  1.00 44.95           C  
ATOM  10144  O   ARG F  22     -26.202 122.154  17.040  1.00 45.36           O  
ATOM  10145  CB  ARG F  22     -28.320 119.715  17.241  1.00 45.03           C  
ATOM  10146  CG  ARG F  22     -29.109 119.112  16.090  1.00 46.69           C  
ATOM  10147  CD  ARG F  22     -29.189 117.605  16.161  1.00 48.66           C  
ATOM  10148  NE  ARG F  22     -30.080 117.067  15.131  1.00 50.21           N  
ATOM  10149  CZ  ARG F  22     -30.166 115.777  14.799  1.00 52.26           C  
ATOM  10150  NH1 ARG F  22     -29.413 114.857  15.417  1.00 50.30           N  
ATOM  10151  NH2 ARG F  22     -31.014 115.406  13.835  1.00 52.41           N  
ATOM  10152  N   SER F  23     -25.848 120.950  18.917  1.00 44.89           N  
ATOM  10153  CA  SER F  23     -25.348 122.090  19.705  1.00 44.86           C  
ATOM  10154  C   SER F  23     -23.843 122.325  19.518  1.00 44.56           C  
ATOM  10155  O   SER F  23     -23.278 123.277  20.070  1.00 44.51           O  
ATOM  10156  CB  SER F  23     -25.702 121.928  21.192  1.00 44.80           C  
ATOM  10157  OG  SER F  23     -25.319 120.659  21.690  1.00 45.19           O  
ATOM  10158  N   THR F  24     -23.213 121.442  18.740  1.00 44.05           N  
ATOM  10159  CA  THR F  24     -21.789 121.518  18.401  1.00 43.43           C  
ATOM  10160  C   THR F  24     -21.594 121.143  16.925  1.00 42.97           C  
ATOM  10161  O   THR F  24     -22.494 120.586  16.293  1.00 42.80           O  
ATOM  10162  CB  THR F  24     -20.919 120.576  19.303  1.00 43.49           C  
ATOM  10163  OG1 THR F  24     -21.346 119.218  19.158  1.00 43.62           O  
ATOM  10164  CG2 THR F  24     -21.005 120.963  20.772  1.00 43.15           C  
ATOM  10165  N   GLU F  25     -20.429 121.453  16.370  1.00 42.35           N  
ATOM  10166  CA  GLU F  25     -20.147 121.105  14.978  1.00 41.90           C  
ATOM  10167  C   GLU F  25     -19.262 119.858  14.925  1.00 41.09           C  
ATOM  10168  O   GLU F  25     -18.454 119.625  15.825  1.00 40.90           O  
ATOM  10169  CB  GLU F  25     -19.508 122.279  14.215  1.00 41.95           C  
ATOM  10170  CG  GLU F  25     -20.205 123.629  14.419  1.00 43.83           C  
ATOM  10171  CD  GLU F  25     -21.700 123.640  14.037  1.00 46.24           C  
ATOM  10172  OE1 GLU F  25     -22.029 123.613  12.830  1.00 46.74           O  
ATOM  10173  OE2 GLU F  25     -22.550 123.713  14.952  1.00 47.04           O  
ATOM  10174  N   LYS F  26     -19.441 119.071  13.865  1.00 40.09           N  
ATOM  10175  CA  LYS F  26     -18.741 117.811  13.633  1.00 39.43           C  
ATOM  10176  C   LYS F  26     -18.574 116.951  14.895  1.00 38.55           C  
ATOM  10177  O   LYS F  26     -17.483 116.475  15.205  1.00 38.15           O  
ATOM  10178  CB  LYS F  26     -17.414 118.020  12.871  1.00 39.77           C  
ATOM  10179  CG  LYS F  26     -16.433 119.050  13.461  1.00 40.52           C  
ATOM  10180  CD  LYS F  26     -15.218 119.281  12.562  1.00 40.14           C  
ATOM  10181  CE  LYS F  26     -15.610 119.714  11.145  1.00 41.93           C  
ATOM  10182  NZ  LYS F  26     -16.210 121.096  11.090  1.00 43.01           N  
ATOM  10183  N   ASN F  27     -19.685 116.783  15.612  1.00 37.22           N  
ATOM  10184  CA  ASN F  27     -19.805 115.834  16.709  1.00 36.36           C  
ATOM  10185  C   ASN F  27     -18.829 116.125  17.852  1.00 35.59           C  
ATOM  10186  O   ASN F  27     -18.358 115.219  18.518  1.00 34.87           O  
ATOM  10187  CB  ASN F  27     -19.676 114.381  16.195  1.00 36.41           C  
ATOM  10188  CG  ASN F  27     -20.780 113.996  15.213  1.00 35.28           C  
ATOM  10189  OD1 ASN F  27     -20.524 113.352  14.195  1.00 34.62           O  
ATOM  10190  ND2 ASN F  27     -22.009 114.363  15.530  1.00 32.94           N  
ATOM  10191  N   ALA F  28     -18.538 117.409  18.051  1.00 35.25           N  
ATOM  10192  CA  ALA F  28     -17.734 117.872  19.170  1.00 35.10           C  
ATOM  10193  C   ALA F  28     -18.423 117.550  20.489  1.00 34.92           C  
ATOM  10194  O   ALA F  28     -19.659 117.500  20.562  1.00 35.40           O  
ATOM  10195  CB  ALA F  28     -17.477 119.358  19.057  1.00 35.32           C  
ATOM  10196  N   LEU F  29     -17.625 117.330  21.527  1.00 34.22           N  
ATOM  10197  CA  LEU F  29     -18.146 116.954  22.843  1.00 33.69           C  
ATOM  10198  C   LEU F  29     -18.142 118.126  23.810  1.00 33.78           C  
ATOM  10199  O   LEU F  29     -17.091 118.660  24.168  1.00 34.37           O  
ATOM  10200  CB  LEU F  29     -17.365 115.758  23.422  1.00 33.43           C  
ATOM  10201  CG  LEU F  29     -17.329 114.459  22.589  1.00 30.58           C  
ATOM  10202  CD1 LEU F  29     -16.615 113.368  23.335  1.00 27.54           C  
ATOM  10203  CD2 LEU F  29     -18.729 113.988  22.212  1.00 29.47           C  
ATOM  10204  N   ASN F  30     -19.337 118.553  24.195  1.00 33.79           N  
ATOM  10205  CA  ASN F  30     -19.503 119.495  25.282  1.00 33.36           C  
ATOM  10206  C   ASN F  30     -20.197 118.740  26.421  1.00 33.90           C  
ATOM  10207  O   ASN F  30     -20.507 117.554  26.265  1.00 33.92           O  
ATOM  10208  CB  ASN F  30     -20.236 120.763  24.811  1.00 32.97           C  
ATOM  10209  CG  ASN F  30     -21.709 120.526  24.454  1.00 32.31           C  
ATOM  10210  OD1 ASN F  30     -22.270 119.462  24.706  1.00 32.29           O  
ATOM  10211  ND2 ASN F  30     -22.349 121.550  23.898  1.00 30.40           N  
ATOM  10212  N   THR F  31     -20.414 119.392  27.561  1.00 34.21           N  
ATOM  10213  CA  THR F  31     -21.075 118.754  28.709  1.00 34.54           C  
ATOM  10214  C   THR F  31     -22.376 118.023  28.376  1.00 34.51           C  
ATOM  10215  O   THR F  31     -22.581 116.884  28.806  1.00 34.73           O  
ATOM  10216  CB  THR F  31     -21.396 119.770  29.784  1.00 34.70           C  
ATOM  10217  OG1 THR F  31     -20.254 120.607  29.985  1.00 37.15           O  
ATOM  10218  CG2 THR F  31     -21.767 119.072  31.101  1.00 35.37           C  
ATOM  10219  N   GLU F  32     -23.252 118.680  27.621  1.00 34.17           N  
ATOM  10220  CA  GLU F  32     -24.583 118.139  27.318  1.00 34.38           C  
ATOM  10221  C   GLU F  32     -24.549 116.863  26.454  1.00 33.53           C  
ATOM  10222  O   GLU F  32     -25.213 115.871  26.779  1.00 33.49           O  
ATOM  10223  CB  GLU F  32     -25.475 119.243  26.709  1.00 34.61           C  
ATOM  10224  CG  GLU F  32     -26.840 118.777  26.172  1.00 38.45           C  
ATOM  10225  CD  GLU F  32     -27.875 118.449  27.261  1.00 43.70           C  
ATOM  10226  OE1 GLU F  32     -27.525 118.449  28.467  1.00 45.43           O  
ATOM  10227  OE2 GLU F  32     -29.056 118.196  26.901  1.00 45.64           O  
ATOM  10228  N   VAL F  33     -23.783 116.896  25.362  1.00 32.74           N  
ATOM  10229  CA  VAL F  33     -23.610 115.749  24.475  1.00 32.35           C  
ATOM  10230  C   VAL F  33     -23.111 114.530  25.269  1.00 32.16           C  
ATOM  10231  O   VAL F  33     -23.622 113.419  25.089  1.00 31.81           O  
ATOM  10232  CB  VAL F  33     -22.616 116.069  23.307  1.00 32.86           C  
ATOM  10233  CG1 VAL F  33     -22.433 114.861  22.393  1.00 32.67           C  
ATOM  10234  CG2 VAL F  33     -23.093 117.259  22.502  1.00 32.42           C  
ATOM  10235  N   ILE F  34     -22.136 114.762  26.155  1.00 31.76           N  
ATOM  10236  CA  ILE F  34     -21.558 113.721  27.024  1.00 31.96           C  
ATOM  10237  C   ILE F  34     -22.576 113.068  27.970  1.00 31.71           C  
ATOM  10238  O   ILE F  34     -22.588 111.850  28.123  1.00 31.88           O  
ATOM  10239  CB  ILE F  34     -20.296 114.232  27.811  1.00 31.56           C  
ATOM  10240  CG1 ILE F  34     -19.123 114.481  26.847  1.00 32.00           C  
ATOM  10241  CG2 ILE F  34     -19.875 113.228  28.888  1.00 32.55           C  
ATOM  10242  CD1 ILE F  34     -17.904 115.200  27.465  1.00 31.72           C  
ATOM  10243  N   LYS F  35     -23.437 113.870  28.584  1.00 32.07           N  
ATOM  10244  CA  LYS F  35     -24.472 113.353  29.488  1.00 32.36           C  
ATOM  10245  C   LYS F  35     -25.561 112.587  28.716  1.00 32.29           C  
ATOM  10246  O   LYS F  35     -26.077 111.595  29.214  1.00 32.13           O  
ATOM  10247  CB  LYS F  35     -25.071 114.482  30.331  1.00 32.64           C  
ATOM  10248  CG  LYS F  35     -24.043 115.236  31.197  1.00 34.97           C  
ATOM  10249  CD  LYS F  35     -24.426 116.698  31.381  1.00 37.75           C  
ATOM  10250  CE  LYS F  35     -24.976 116.992  32.774  1.00 39.17           C  
ATOM  10251  NZ  LYS F  35     -23.861 117.273  33.730  1.00 39.86           N  
ATOM  10252  N   GLU F  36     -25.901 113.044  27.510  1.00 32.26           N  
ATOM  10253  CA  GLU F  36     -26.749 112.267  26.600  1.00 32.82           C  
ATOM  10254  C   GLU F  36     -26.137 110.911  26.236  1.00 33.36           C  
ATOM  10255  O   GLU F  36     -26.842 109.891  26.224  1.00 33.50           O  
ATOM  10256  CB  GLU F  36     -27.009 113.053  25.323  1.00 33.19           C  
ATOM  10257  CG  GLU F  36     -27.779 114.338  25.536  1.00 34.20           C  
ATOM  10258  CD  GLU F  36     -27.980 115.104  24.247  1.00 36.13           C  
ATOM  10259  OE1 GLU F  36     -28.642 114.574  23.327  1.00 35.15           O  
ATOM  10260  OE2 GLU F  36     -27.471 116.240  24.157  1.00 37.75           O  
ATOM  10261  N   MET F  37     -24.832 110.911  25.936  1.00 33.53           N  
ATOM  10262  CA  MET F  37     -24.094 109.689  25.611  1.00 34.13           C  
ATOM  10263  C   MET F  37     -24.107 108.685  26.765  1.00 33.38           C  
ATOM  10264  O   MET F  37     -24.537 107.550  26.572  1.00 33.61           O  
ATOM  10265  CB  MET F  37     -22.659 109.983  25.157  1.00 34.40           C  
ATOM  10266  CG  MET F  37     -22.474 110.262  23.665  1.00 36.69           C  
ATOM  10267  SD  MET F  37     -22.963 108.938  22.512  1.00 42.51           S  
ATOM  10268  CE  MET F  37     -21.918 107.570  23.048  1.00 41.25           C  
ATOM  10269  N   VAL F  38     -23.655 109.106  27.945  1.00 32.76           N  
ATOM  10270  CA  VAL F  38     -23.696 108.276  29.172  1.00 32.24           C  
ATOM  10271  C   VAL F  38     -25.114 107.739  29.453  1.00 32.26           C  
ATOM  10272  O   VAL F  38     -25.288 106.561  29.729  1.00 32.27           O  
ATOM  10273  CB  VAL F  38     -23.151 109.051  30.406  1.00 32.15           C  
ATOM  10274  CG1 VAL F  38     -23.338 108.254  31.693  1.00 30.94           C  
ATOM  10275  CG2 VAL F  38     -21.691 109.431  30.208  1.00 32.08           C  
ATOM  10276  N   ASN F  39     -26.112 108.618  29.362  1.00 32.65           N  
ATOM  10277  CA  ASN F  39     -27.535 108.257  29.390  1.00 32.82           C  
ATOM  10278  C   ASN F  39     -27.967 107.151  28.385  1.00 32.76           C  
ATOM  10279  O   ASN F  39     -28.565 106.135  28.779  1.00 32.12           O  
ATOM  10280  CB  ASN F  39     -28.389 109.518  29.208  1.00 33.36           C  
ATOM  10281  CG  ASN F  39     -28.526 110.348  30.504  1.00 36.50           C  
ATOM  10282  OD1 ASN F  39     -28.989 111.502  30.471  1.00 38.89           O  
ATOM  10283  ND2 ASN F  39     -28.138 109.764  31.646  1.00 38.10           N  
ATOM  10284  N   ALA F  40     -27.660 107.344  27.102  1.00 32.55           N  
ATOM  10285  CA  ALA F  40     -27.906 106.310  26.079  1.00 32.92           C  
ATOM  10286  C   ALA F  40     -27.164 104.994  26.346  1.00 33.25           C  
ATOM  10287  O   ALA F  40     -27.709 103.920  26.103  1.00 34.07           O  
ATOM  10288  CB  ALA F  40     -27.560 106.828  24.703  1.00 32.57           C  
ATOM  10289  N   LEU F  41     -25.933 105.074  26.849  1.00 33.06           N  
ATOM  10290  CA  LEU F  41     -25.175 103.876  27.235  1.00 33.10           C  
ATOM  10291  C   LEU F  41     -25.797 103.121  28.405  1.00 33.31           C  
ATOM  10292  O   LEU F  41     -25.966 101.902  28.340  1.00 32.98           O  
ATOM  10293  CB  LEU F  41     -23.712 104.222  27.538  1.00 32.67           C  
ATOM  10294  CG  LEU F  41     -22.881 104.603  26.307  1.00 32.86           C  
ATOM  10295  CD1 LEU F  41     -21.590 105.363  26.684  1.00 32.78           C  
ATOM  10296  CD2 LEU F  41     -22.603 103.368  25.422  1.00 32.23           C  
ATOM  10297  N   ASN F  42     -26.140 103.851  29.467  1.00 33.56           N  
ATOM  10298  CA  ASN F  42     -26.809 103.266  30.639  1.00 33.92           C  
ATOM  10299  C   ASN F  42     -28.091 102.507  30.279  1.00 33.94           C  
ATOM  10300  O   ASN F  42     -28.336 101.403  30.771  1.00 33.25           O  
ATOM  10301  CB  ASN F  42     -27.113 104.348  31.684  1.00 33.43           C  
ATOM  10302  CG  ASN F  42     -25.871 104.828  32.415  1.00 33.37           C  
ATOM  10303  OD1 ASN F  42     -25.920 105.811  33.154  1.00 32.27           O  
ATOM  10304  ND2 ASN F  42     -24.755 104.127  32.227  1.00 33.03           N  
ATOM  10305  N   SER F  43     -28.902 103.128  29.425  1.00 34.78           N  
ATOM  10306  CA  SER F  43     -30.129 102.524  28.922  1.00 35.15           C  
ATOM  10307  C   SER F  43     -29.816 101.284  28.093  1.00 35.43           C  
ATOM  10308  O   SER F  43     -30.410 100.230  28.314  1.00 35.96           O  
ATOM  10309  CB  SER F  43     -30.905 103.530  28.083  1.00 35.18           C  
ATOM  10310  OG  SER F  43     -30.999 104.780  28.737  1.00 35.72           O  
ATOM  10311  N   ALA F  44     -28.878 101.414  27.148  1.00 35.37           N  
ATOM  10312  CA  ALA F  44     -28.445 100.286  26.302  1.00 35.46           C  
ATOM  10313  C   ALA F  44     -27.880  99.107  27.117  1.00 35.44           C  
ATOM  10314  O   ALA F  44     -27.969  97.943  26.701  1.00 35.25           O  
ATOM  10315  CB  ALA F  44     -27.432 100.753  25.232  1.00 34.89           C  
ATOM  10316  N   ALA F  45     -27.303  99.424  28.271  1.00 35.19           N  
ATOM  10317  CA  ALA F  45     -26.829  98.425  29.231  1.00 35.67           C  
ATOM  10318  C   ALA F  45     -27.972  97.582  29.783  1.00 35.82           C  
ATOM  10319  O   ALA F  45     -27.772  96.426  30.167  1.00 36.15           O  
ATOM  10320  CB  ALA F  45     -26.097  99.114  30.396  1.00 34.75           C  
ATOM  10321  N   ALA F  46     -29.162  98.174  29.826  1.00 36.04           N  
ATOM  10322  CA  ALA F  46     -30.279  97.602  30.563  1.00 36.46           C  
ATOM  10323  C   ALA F  46     -31.318  96.969  29.657  1.00 36.76           C  
ATOM  10324  O   ALA F  46     -32.102  96.129  30.106  1.00 36.60           O  
ATOM  10325  CB  ALA F  46     -30.920  98.655  31.466  1.00 36.30           C  
ATOM  10326  N   ASP F  47     -31.320  97.357  28.384  1.00 37.08           N  
ATOM  10327  CA  ASP F  47     -32.288  96.813  27.444  1.00 37.36           C  
ATOM  10328  C   ASP F  47     -31.965  95.359  27.061  1.00 37.71           C  
ATOM  10329  O   ASP F  47     -31.089  94.724  27.662  1.00 37.61           O  
ATOM  10330  CB  ASP F  47     -32.449  97.730  26.223  1.00 37.45           C  
ATOM  10331  CG  ASP F  47     -31.255  97.695  25.292  1.00 37.63           C  
ATOM  10332  OD1 ASP F  47     -31.186  98.562  24.400  1.00 37.54           O  
ATOM  10333  OD2 ASP F  47     -30.394  96.802  25.436  1.00 39.44           O  
ATOM  10334  N   ASP F  48     -32.676  94.839  26.063  1.00 37.94           N  
ATOM  10335  CA  ASP F  48     -32.578  93.428  25.705  1.00 38.16           C  
ATOM  10336  C   ASP F  48     -31.545  93.094  24.611  1.00 37.89           C  
ATOM  10337  O   ASP F  48     -31.492  91.958  24.131  1.00 38.03           O  
ATOM  10338  CB  ASP F  48     -33.971  92.878  25.370  1.00 38.10           C  
ATOM  10339  CG  ASP F  48     -34.822  92.634  26.617  1.00 39.27           C  
ATOM  10340  OD1 ASP F  48     -34.291  92.080  27.608  1.00 40.86           O  
ATOM  10341  OD2 ASP F  48     -36.029  92.971  26.609  1.00 39.87           O  
ATOM  10342  N   SER F  49     -30.715  94.070  24.244  1.00 37.44           N  
ATOM  10343  CA  SER F  49     -29.661  93.861  23.246  1.00 36.84           C  
ATOM  10344  C   SER F  49     -28.517  92.993  23.780  1.00 36.54           C  
ATOM  10345  O   SER F  49     -28.311  92.901  24.991  1.00 36.31           O  
ATOM  10346  CB  SER F  49     -29.122  95.199  22.768  1.00 36.84           C  
ATOM  10347  OG  SER F  49     -28.636  95.949  23.861  1.00 37.12           O  
ATOM  10348  N   LYS F  50     -27.791  92.349  22.867  1.00 36.10           N  
ATOM  10349  CA  LYS F  50     -26.637  91.517  23.211  1.00 35.97           C  
ATOM  10350  C   LYS F  50     -25.362  92.344  23.127  1.00 36.05           C  
ATOM  10351  O   LYS F  50     -24.349  92.017  23.750  1.00 36.21           O  
ATOM  10352  CB  LYS F  50     -26.514  90.334  22.248  1.00 35.88           C  
ATOM  10353  CG  LYS F  50     -27.656  89.341  22.255  1.00 36.04           C  
ATOM  10354  CD  LYS F  50     -27.374  88.254  21.228  1.00 38.39           C  
ATOM  10355  CE  LYS F  50     -28.435  87.154  21.213  1.00 38.81           C  
ATOM  10356  NZ  LYS F  50     -29.740  87.635  20.697  1.00 40.04           N  
ATOM  10357  N   LEU F  51     -25.425  93.411  22.333  1.00 35.75           N  
ATOM  10358  CA  LEU F  51     -24.285  94.281  22.074  1.00 35.28           C  
ATOM  10359  C   LEU F  51     -24.774  95.667  21.624  1.00 34.84           C  
ATOM  10360  O   LEU F  51     -25.976  95.871  21.393  1.00 34.80           O  
ATOM  10361  CB  LEU F  51     -23.337  93.650  21.021  1.00 35.23           C  
ATOM  10362  CG  LEU F  51     -23.825  93.491  19.568  1.00 35.74           C  
ATOM  10363  CD1 LEU F  51     -23.342  94.636  18.697  1.00 36.40           C  
ATOM  10364  CD2 LEU F  51     -23.378  92.181  18.971  1.00 34.49           C  
ATOM  10365  N   VAL F  52     -23.824  96.597  21.498  1.00 33.89           N  
ATOM  10366  CA  VAL F  52     -24.084  97.967  21.111  1.00 32.58           C  
ATOM  10367  C   VAL F  52     -23.235  98.321  19.904  1.00 32.36           C  
ATOM  10368  O   VAL F  52     -22.059  97.980  19.858  1.00 32.00           O  
ATOM  10369  CB  VAL F  52     -23.830  98.942  22.318  1.00 32.76           C  
ATOM  10370  CG1 VAL F  52     -23.501 100.376  21.873  1.00 31.44           C  
ATOM  10371  CG2 VAL F  52     -25.025  98.931  23.244  1.00 31.43           C  
ATOM  10372  N   LEU F  53     -23.856  98.967  18.912  1.00 31.93           N  
ATOM  10373  CA  LEU F  53     -23.113  99.641  17.844  1.00 31.98           C  
ATOM  10374  C   LEU F  53     -23.039 101.141  18.137  1.00 32.24           C  
ATOM  10375  O   LEU F  53     -24.063 101.817  18.247  1.00 31.76           O  
ATOM  10376  CB  LEU F  53     -23.723  99.388  16.451  1.00 31.75           C  
ATOM  10377  CG  LEU F  53     -23.090 100.095  15.241  1.00 31.22           C  
ATOM  10378  CD1 LEU F  53     -21.617  99.702  15.045  1.00 30.01           C  
ATOM  10379  CD2 LEU F  53     -23.895  99.828  13.966  1.00 31.74           C  
ATOM  10380  N   PHE F  54     -21.809 101.631  18.286  1.00 32.69           N  
ATOM  10381  CA  PHE F  54     -21.529 103.044  18.462  1.00 32.57           C  
ATOM  10382  C   PHE F  54     -21.025 103.597  17.139  1.00 32.67           C  
ATOM  10383  O   PHE F  54     -19.953 103.249  16.671  1.00 32.66           O  
ATOM  10384  CB  PHE F  54     -20.509 103.221  19.588  1.00 32.97           C  
ATOM  10385  CG  PHE F  54     -20.075 104.648  19.836  1.00 32.69           C  
ATOM  10386  CD1 PHE F  54     -20.927 105.720  19.598  1.00 32.76           C  
ATOM  10387  CD2 PHE F  54     -18.814 104.902  20.385  1.00 33.20           C  
ATOM  10388  CE1 PHE F  54     -20.523 107.025  19.836  1.00 32.16           C  
ATOM  10389  CE2 PHE F  54     -18.394 106.199  20.630  1.00 32.51           C  
ATOM  10390  CZ  PHE F  54     -19.258 107.271  20.350  1.00 33.43           C  
ATOM  10391  N   SER F  55     -21.832 104.454  16.529  1.00 33.00           N  
ATOM  10392  CA  SER F  55     -21.506 105.048  15.249  1.00 33.17           C  
ATOM  10393  C   SER F  55     -21.799 106.543  15.308  1.00 33.19           C  
ATOM  10394  O   SER F  55     -22.301 107.026  16.316  1.00 32.86           O  
ATOM  10395  CB  SER F  55     -22.304 104.365  14.135  1.00 33.08           C  
ATOM  10396  OG  SER F  55     -23.666 104.233  14.503  1.00 33.42           O  
ATOM  10397  N   ALA F  56     -21.465 107.261  14.235  1.00 33.46           N  
ATOM  10398  CA  ALA F  56     -21.651 108.706  14.170  1.00 33.76           C  
ATOM  10399  C   ALA F  56     -22.299 109.121  12.857  1.00 34.12           C  
ATOM  10400  O   ALA F  56     -22.174 108.424  11.861  1.00 34.64           O  
ATOM  10401  CB  ALA F  56     -20.328 109.416  14.358  1.00 33.57           C  
ATOM  10402  N   ALA F  57     -22.996 110.259  12.866  1.00 34.89           N  
ATOM  10403  CA  ALA F  57     -23.619 110.801  11.659  1.00 35.35           C  
ATOM  10404  C   ALA F  57     -22.820 111.962  11.053  1.00 35.78           C  
ATOM  10405  O   ALA F  57     -22.259 112.793  11.780  1.00 35.83           O  
ATOM  10406  CB  ALA F  57     -25.054 111.230  11.957  1.00 35.29           C  
ATOM  10407  N   GLY F  58     -22.780 112.011   9.718  1.00 36.34           N  
ATOM  10408  CA  GLY F  58     -22.122 113.097   8.977  1.00 36.21           C  
ATOM  10409  C   GLY F  58     -20.673 112.858   8.582  1.00 36.31           C  
ATOM  10410  O   GLY F  58     -20.254 111.714   8.355  1.00 36.23           O  
ATOM  10411  N   SER F  59     -19.909 113.948   8.510  1.00 36.44           N  
ATOM  10412  CA  SER F  59     -18.533 113.934   7.977  1.00 36.64           C  
ATOM  10413  C   SER F  59     -17.498 113.336   8.919  1.00 36.26           C  
ATOM  10414  O   SER F  59     -16.808 112.388   8.548  1.00 36.20           O  
ATOM  10415  CB  SER F  59     -18.083 115.342   7.542  1.00 36.86           C  
ATOM  10416  OG  SER F  59     -18.371 115.577   6.176  1.00 37.40           O  
ATOM  10417  N   VAL F  60     -17.377 113.892  10.127  1.00 36.02           N  
ATOM  10418  CA  VAL F  60     -16.378 113.386  11.072  1.00 35.10           C  
ATOM  10419  C   VAL F  60     -17.022 112.453  12.103  1.00 34.55           C  
ATOM  10420  O   VAL F  60     -18.228 112.553  12.351  1.00 34.65           O  
ATOM  10421  CB  VAL F  60     -15.472 114.524  11.683  1.00 35.26           C  
ATOM  10422  CG1 VAL F  60     -15.446 115.770  10.787  1.00 34.64           C  
ATOM  10423  CG2 VAL F  60     -15.870 114.889  13.084  1.00 35.38           C  
ATOM  10424  N   PHE F  61     -16.243 111.525  12.661  1.00 33.35           N  
ATOM  10425  CA  PHE F  61     -16.764 110.621  13.683  1.00 32.86           C  
ATOM  10426  C   PHE F  61     -16.956 111.387  14.992  1.00 32.77           C  
ATOM  10427  O   PHE F  61     -18.067 111.482  15.518  1.00 32.73           O  
ATOM  10428  CB  PHE F  61     -15.872 109.371  13.877  1.00 32.74           C  
ATOM  10429  CG  PHE F  61     -16.265 108.530  15.070  1.00 32.36           C  
ATOM  10430  CD1 PHE F  61     -17.356 107.657  14.999  1.00 32.20           C  
ATOM  10431  CD2 PHE F  61     -15.567 108.631  16.274  1.00 31.27           C  
ATOM  10432  CE1 PHE F  61     -17.739 106.897  16.101  1.00 31.54           C  
ATOM  10433  CE2 PHE F  61     -15.944 107.880  17.382  1.00 30.80           C  
ATOM  10434  CZ  PHE F  61     -17.035 107.015  17.302  1.00 31.66           C  
ATOM  10435  N   CYS F  62     -15.862 111.939  15.503  1.00 32.95           N  
ATOM  10436  CA  CYS F  62     -15.883 112.763  16.703  1.00 33.46           C  
ATOM  10437  C   CYS F  62     -14.575 113.542  16.732  1.00 33.94           C  
ATOM  10438  O   CYS F  62     -13.482 112.933  16.638  1.00 33.57           O  
ATOM  10439  CB  CYS F  62     -16.024 111.891  17.955  1.00 33.32           C  
ATOM  10440  SG  CYS F  62     -16.162 112.816  19.473  1.00 32.09           S  
ATOM  10441  N   CYS F  63     -14.689 114.871  16.828  1.00 33.81           N  
ATOM  10442  CA  CYS F  63     -13.518 115.746  16.855  1.00 34.48           C  
ATOM  10443  C   CYS F  63     -12.981 115.927  18.276  1.00 34.30           C  
ATOM  10444  O   CYS F  63     -11.935 116.557  18.480  1.00 34.81           O  
ATOM  10445  CB  CYS F  63     -13.784 117.091  16.142  1.00 34.59           C  
ATOM  10446  SG  CYS F  63     -14.991 118.198  16.954  1.00 36.87           S  
ATOM  10447  N   GLY F  64     -13.678 115.334  19.248  1.00 34.27           N  
ATOM  10448  CA  GLY F  64     -13.226 115.279  20.649  1.00 33.05           C  
ATOM  10449  C   GLY F  64     -13.862 116.385  21.458  1.00 32.92           C  
ATOM  10450  O   GLY F  64     -14.981 116.819  21.146  1.00 32.10           O  
ATOM  10451  N   LEU F  65     -13.156 116.867  22.485  1.00 32.18           N  
ATOM  10452  CA  LEU F  65     -13.682 118.000  23.263  1.00 31.89           C  
ATOM  10453  C   LEU F  65     -13.825 119.244  22.411  1.00 31.80           C  
ATOM  10454  O   LEU F  65     -12.988 119.523  21.556  1.00 31.39           O  
ATOM  10455  CB  LEU F  65     -12.866 118.305  24.536  1.00 31.25           C  
ATOM  10456  CG  LEU F  65     -12.768 117.124  25.510  1.00 30.10           C  
ATOM  10457  CD1 LEU F  65     -11.659 117.345  26.505  1.00 27.34           C  
ATOM  10458  CD2 LEU F  65     -14.124 116.846  26.196  1.00 28.91           C  
ATOM  10459  N   ASP F  66     -14.926 119.952  22.663  1.00 31.91           N  
ATOM  10460  CA  ASP F  66     -15.210 121.273  22.118  1.00 32.03           C  
ATOM  10461  C   ASP F  66     -14.561 122.325  23.000  1.00 31.50           C  
ATOM  10462  O   ASP F  66     -15.210 122.898  23.879  1.00 31.42           O  
ATOM  10463  CB  ASP F  66     -16.731 121.500  22.063  1.00 32.15           C  
ATOM  10464  CG  ASP F  66     -17.117 122.704  21.231  1.00 33.68           C  
ATOM  10465  OD1 ASP F  66     -18.318 122.846  20.920  1.00 33.95           O  
ATOM  10466  OD2 ASP F  66     -16.226 123.511  20.877  1.00 36.32           O  
ATOM  10467  N   PHE F  67     -13.279 122.569  22.755  1.00 31.22           N  
ATOM  10468  CA  PHE F  67     -12.497 123.539  23.515  1.00 31.82           C  
ATOM  10469  C   PHE F  67     -12.999 124.979  23.368  1.00 31.86           C  
ATOM  10470  O   PHE F  67     -12.914 125.752  24.308  1.00 31.92           O  
ATOM  10471  CB  PHE F  67     -11.016 123.460  23.141  1.00 31.35           C  
ATOM  10472  CG  PHE F  67     -10.392 122.143  23.438  1.00 31.49           C  
ATOM  10473  CD1 PHE F  67     -10.199 121.730  24.749  1.00 31.63           C  
ATOM  10474  CD2 PHE F  67      -9.979 121.310  22.404  1.00 31.30           C  
ATOM  10475  CE1 PHE F  67      -9.619 120.510  25.020  1.00 30.63           C  
ATOM  10476  CE2 PHE F  67      -9.392 120.089  22.672  1.00 30.24           C  
ATOM  10477  CZ  PHE F  67      -9.214 119.689  23.972  1.00 30.88           C  
ATOM  10478  N   GLY F  68     -13.518 125.327  22.190  1.00 32.43           N  
ATOM  10479  CA  GLY F  68     -14.171 126.622  21.968  1.00 32.29           C  
ATOM  10480  C   GLY F  68     -15.272 126.877  22.990  1.00 32.76           C  
ATOM  10481  O   GLY F  68     -15.469 127.998  23.454  1.00 32.86           O  
ATOM  10482  N   TYR F  69     -15.969 125.814  23.366  1.00 33.11           N  
ATOM  10483  CA  TYR F  69     -17.036 125.889  24.356  1.00 33.43           C  
ATOM  10484  C   TYR F  69     -16.498 125.912  25.804  1.00 33.68           C  
ATOM  10485  O   TYR F  69     -16.925 126.730  26.628  1.00 33.38           O  
ATOM  10486  CB  TYR F  69     -17.979 124.709  24.129  1.00 33.53           C  
ATOM  10487  CG  TYR F  69     -18.963 124.441  25.229  1.00 34.29           C  
ATOM  10488  CD1 TYR F  69     -18.594 123.703  26.353  1.00 34.03           C  
ATOM  10489  CD2 TYR F  69     -20.270 124.900  25.140  1.00 34.58           C  
ATOM  10490  CE1 TYR F  69     -19.489 123.451  27.363  1.00 34.50           C  
ATOM  10491  CE2 TYR F  69     -21.181 124.652  26.159  1.00 36.67           C  
ATOM  10492  CZ  TYR F  69     -20.780 123.921  27.263  1.00 35.19           C  
ATOM  10493  OH  TYR F  69     -21.678 123.662  28.271  1.00 35.70           O  
ATOM  10494  N   PHE F  70     -15.569 125.006  26.101  1.00 33.80           N  
ATOM  10495  CA  PHE F  70     -15.052 124.843  27.442  1.00 33.93           C  
ATOM  10496  C   PHE F  70     -14.141 125.981  27.882  1.00 33.64           C  
ATOM  10497  O   PHE F  70     -14.044 126.259  29.083  1.00 33.41           O  
ATOM  10498  CB  PHE F  70     -14.289 123.525  27.573  1.00 34.41           C  
ATOM  10499  CG  PHE F  70     -15.169 122.321  27.759  1.00 36.13           C  
ATOM  10500  CD1 PHE F  70     -15.190 121.301  26.799  1.00 36.65           C  
ATOM  10501  CD2 PHE F  70     -15.960 122.186  28.908  1.00 36.85           C  
ATOM  10502  CE1 PHE F  70     -16.000 120.182  26.968  1.00 36.82           C  
ATOM  10503  CE2 PHE F  70     -16.772 121.068  29.087  1.00 37.36           C  
ATOM  10504  CZ  PHE F  70     -16.788 120.061  28.121  1.00 37.19           C  
ATOM  10505  N   VAL F  71     -13.442 126.599  26.926  1.00 33.00           N  
ATOM  10506  CA  VAL F  71     -12.508 127.674  27.245  1.00 32.66           C  
ATOM  10507  C   VAL F  71     -13.234 128.950  27.739  1.00 33.10           C  
ATOM  10508  O   VAL F  71     -12.683 129.708  28.531  1.00 32.83           O  
ATOM  10509  CB  VAL F  71     -11.538 127.978  26.080  1.00 32.48           C  
ATOM  10510  CG1 VAL F  71     -12.198 128.854  25.008  1.00 31.91           C  
ATOM  10511  CG2 VAL F  71     -10.266 128.632  26.613  1.00 31.81           C  
ATOM  10512  N   ARG F  72     -14.463 129.161  27.269  1.00 33.50           N  
ATOM  10513  CA  ARG F  72     -15.315 130.253  27.737  1.00 34.41           C  
ATOM  10514  C   ARG F  72     -15.652 130.060  29.208  1.00 34.81           C  
ATOM  10515  O   ARG F  72     -15.708 131.020  29.978  1.00 34.67           O  
ATOM  10516  CB  ARG F  72     -16.624 130.268  26.957  1.00 34.53           C  
ATOM  10517  CG  ARG F  72     -16.569 130.824  25.555  1.00 35.25           C  
ATOM  10518  CD  ARG F  72     -17.911 130.525  24.908  1.00 36.99           C  
ATOM  10519  NE  ARG F  72     -18.261 131.435  23.820  1.00 38.70           N  
ATOM  10520  CZ  ARG F  72     -18.443 131.049  22.561  1.00 39.19           C  
ATOM  10521  NH1 ARG F  72     -18.774 131.939  21.631  1.00 38.14           N  
ATOM  10522  NH2 ARG F  72     -18.298 129.766  22.235  1.00 38.74           N  
ATOM  10523  N   HIS F  73     -15.874 128.800  29.577  1.00 35.24           N  
ATOM  10524  CA  HIS F  73     -16.352 128.430  30.901  1.00 35.91           C  
ATOM  10525  C   HIS F  73     -15.254 128.454  31.951  1.00 36.16           C  
ATOM  10526  O   HIS F  73     -15.473 128.890  33.087  1.00 35.89           O  
ATOM  10527  CB  HIS F  73     -17.027 127.065  30.821  1.00 36.14           C  
ATOM  10528  CG  HIS F  73     -18.334 127.101  30.094  1.00 37.44           C  
ATOM  10529  ND1 HIS F  73     -19.287 126.116  30.225  1.00 39.10           N  
ATOM  10530  CD2 HIS F  73     -18.864 128.029  29.261  1.00 38.05           C  
ATOM  10531  CE1 HIS F  73     -20.338 126.426  29.485  1.00 40.25           C  
ATOM  10532  NE2 HIS F  73     -20.106 127.582  28.889  1.00 38.32           N  
ATOM  10533  N   LEU F  74     -14.078 127.987  31.551  1.00 36.69           N  
ATOM  10534  CA  LEU F  74     -12.872 128.058  32.361  1.00 37.48           C  
ATOM  10535  C   LEU F  74     -12.357 129.501  32.481  1.00 38.29           C  
ATOM  10536  O   LEU F  74     -11.761 129.865  33.493  1.00 38.40           O  
ATOM  10537  CB  LEU F  74     -11.799 127.174  31.732  1.00 37.39           C  
ATOM  10538  CG  LEU F  74     -11.468 125.743  32.156  1.00 35.91           C  
ATOM  10539  CD1 LEU F  74     -12.647 124.885  32.455  1.00 35.69           C  
ATOM  10540  CD2 LEU F  74     -10.663 125.151  31.014  1.00 36.94           C  
ATOM  10541  N   ARG F  75     -12.576 130.306  31.440  1.00 39.49           N  
ATOM  10542  CA  ARG F  75     -12.256 131.751  31.448  1.00 40.66           C  
ATOM  10543  C   ARG F  75     -13.188 132.507  32.426  1.00 40.58           C  
ATOM  10544  O   ARG F  75     -12.745 133.378  33.176  1.00 40.40           O  
ATOM  10545  CB  ARG F  75     -12.366 132.336  30.030  1.00 40.38           C  
ATOM  10546  CG  ARG F  75     -11.157 133.150  29.552  1.00 41.93           C  
ATOM  10547  CD  ARG F  75     -11.508 134.206  28.465  1.00 42.10           C  
ATOM  10548  NE  ARG F  75     -11.800 133.600  27.161  1.00 45.09           N  
ATOM  10549  CZ  ARG F  75     -13.027 133.384  26.676  1.00 45.75           C  
ATOM  10550  NH1 ARG F  75     -13.180 132.815  25.483  1.00 45.15           N  
ATOM  10551  NH2 ARG F  75     -14.107 133.730  27.377  1.00 44.84           N  
ATOM  10552  N   ASN F  76     -14.473 132.142  32.412  1.00 40.99           N  
ATOM  10553  CA  ASN F  76     -15.482 132.643  33.352  1.00 41.01           C  
ATOM  10554  C   ASN F  76     -15.237 132.283  34.835  1.00 40.86           C  
ATOM  10555  O   ASN F  76     -15.486 133.105  35.721  1.00 40.95           O  
ATOM  10556  CB  ASN F  76     -16.888 132.164  32.927  1.00 41.40           C  
ATOM  10557  CG  ASN F  76     -17.650 133.198  32.069  1.00 42.72           C  
ATOM  10558  OD1 ASN F  76     -17.369 134.403  32.119  1.00 43.72           O  
ATOM  10559  ND2 ASN F  76     -18.640 132.723  31.300  1.00 42.52           N  
ATOM  10560  N   ASP F  77     -14.762 131.061  35.088  1.00 40.40           N  
ATOM  10561  CA  ASP F  77     -14.576 130.499  36.441  1.00 40.03           C  
ATOM  10562  C   ASP F  77     -13.761 129.201  36.311  1.00 39.99           C  
ATOM  10563  O   ASP F  77     -14.329 128.152  36.050  1.00 39.54           O  
ATOM  10564  CB  ASP F  77     -15.941 130.182  37.073  1.00 39.95           C  
ATOM  10565  CG  ASP F  77     -15.847 129.725  38.544  1.00 39.98           C  
ATOM  10566  OD1 ASP F  77     -14.742 129.447  39.061  1.00 40.82           O  
ATOM  10567  OD2 ASP F  77     -16.905 129.651  39.196  1.00 38.23           O  
ATOM  10568  N   ARG F  78     -12.445 129.267  36.492  1.00 40.21           N  
ATOM  10569  CA  ARG F  78     -11.587 128.126  36.144  1.00 40.74           C  
ATOM  10570  C   ARG F  78     -11.635 126.991  37.151  1.00 40.86           C  
ATOM  10571  O   ARG F  78     -11.493 125.821  36.780  1.00 41.16           O  
ATOM  10572  CB  ARG F  78     -10.133 128.555  35.880  1.00 40.72           C  
ATOM  10573  CG  ARG F  78      -9.316 128.910  37.116  1.00 40.85           C  
ATOM  10574  CD  ARG F  78      -7.949 129.475  36.746  1.00 41.32           C  
ATOM  10575  NE  ARG F  78      -8.048 130.771  36.082  1.00 42.48           N  
ATOM  10576  CZ  ARG F  78      -7.032 131.613  35.895  1.00 43.44           C  
ATOM  10577  NH1 ARG F  78      -7.241 132.763  35.271  1.00 43.58           N  
ATOM  10578  NH2 ARG F  78      -5.812 131.320  36.335  1.00 43.82           N  
ATOM  10579  N   ASN F  79     -11.823 127.331  38.420  1.00 40.88           N  
ATOM  10580  CA  ASN F  79     -11.761 126.326  39.468  1.00 40.97           C  
ATOM  10581  C   ASN F  79     -13.007 125.482  39.606  1.00 40.52           C  
ATOM  10582  O   ASN F  79     -12.919 124.290  39.901  1.00 40.33           O  
ATOM  10583  CB  ASN F  79     -11.325 126.936  40.789  1.00 41.13           C  
ATOM  10584  CG  ASN F  79      -9.814 127.053  40.882  1.00 42.50           C  
ATOM  10585  OD1 ASN F  79      -9.097 126.047  40.786  1.00 42.99           O  
ATOM  10586  ND2 ASN F  79      -9.317 128.277  41.049  1.00 42.72           N  
ATOM  10587  N   THR F  80     -14.159 126.101  39.367  1.00 39.94           N  
ATOM  10588  CA  THR F  80     -15.427 125.381  39.321  1.00 39.36           C  
ATOM  10589  C   THR F  80     -15.561 124.607  38.002  1.00 38.86           C  
ATOM  10590  O   THR F  80     -15.932 123.423  37.988  1.00 38.70           O  
ATOM  10591  CB  THR F  80     -16.606 126.352  39.503  1.00 39.15           C  
ATOM  10592  OG1 THR F  80     -16.623 126.824  40.857  1.00 40.17           O  
ATOM  10593  CG2 THR F  80     -17.937 125.688  39.180  1.00 39.09           C  
ATOM  10594  N   ALA F  81     -15.252 125.287  36.898  1.00 38.04           N  
ATOM  10595  CA  ALA F  81     -15.500 124.748  35.575  1.00 37.24           C  
ATOM  10596  C   ALA F  81     -14.588 123.576  35.200  1.00 36.88           C  
ATOM  10597  O   ALA F  81     -14.994 122.730  34.399  1.00 36.39           O  
ATOM  10598  CB  ALA F  81     -15.442 125.838  34.537  1.00 36.99           C  
ATOM  10599  N   SER F  82     -13.386 123.520  35.788  1.00 36.26           N  
ATOM  10600  CA  SER F  82     -12.457 122.412  35.533  1.00 35.82           C  
ATOM  10601  C   SER F  82     -12.774 121.212  36.414  1.00 35.64           C  
ATOM  10602  O   SER F  82     -12.429 120.078  36.073  1.00 34.81           O  
ATOM  10603  CB  SER F  82     -10.998 122.824  35.717  1.00 35.67           C  
ATOM  10604  OG  SER F  82     -10.740 123.280  37.032  1.00 36.34           O  
ATOM  10605  N   LEU F  83     -13.436 121.473  37.541  1.00 35.04           N  
ATOM  10606  CA  LEU F  83     -13.906 120.418  38.431  1.00 34.65           C  
ATOM  10607  C   LEU F  83     -15.052 119.670  37.733  1.00 34.58           C  
ATOM  10608  O   LEU F  83     -15.038 118.426  37.637  1.00 33.82           O  
ATOM  10609  CB  LEU F  83     -14.365 121.038  39.754  1.00 34.72           C  
ATOM  10610  CG  LEU F  83     -13.938 120.548  41.149  1.00 35.07           C  
ATOM  10611  CD1 LEU F  83     -12.619 119.794  41.199  1.00 35.76           C  
ATOM  10612  CD2 LEU F  83     -13.854 121.762  42.051  1.00 33.52           C  
ATOM  10613  N   GLU F  84     -16.022 120.443  37.233  1.00 34.53           N  
ATOM  10614  CA  GLU F  84     -17.156 119.922  36.473  1.00 34.58           C  
ATOM  10615  C   GLU F  84     -16.688 119.248  35.194  1.00 34.89           C  
ATOM  10616  O   GLU F  84     -17.120 118.147  34.893  1.00 34.58           O  
ATOM  10617  CB  GLU F  84     -18.119 121.048  36.109  1.00 34.78           C  
ATOM  10618  CG  GLU F  84     -19.066 121.489  37.230  1.00 35.54           C  
ATOM  10619  CD  GLU F  84     -19.626 122.884  36.981  1.00 37.94           C  
ATOM  10620  OE1 GLU F  84     -19.048 123.616  36.144  1.00 38.56           O  
ATOM  10621  OE2 GLU F  84     -20.635 123.259  37.626  1.00 38.80           O  
ATOM  10622  N   MET F  85     -15.791 119.920  34.470  1.00 34.54           N  
ATOM  10623  CA  MET F  85     -15.237 119.437  33.208  1.00 35.39           C  
ATOM  10624  C   MET F  85     -14.611 118.058  33.352  1.00 33.97           C  
ATOM  10625  O   MET F  85     -14.940 117.126  32.630  1.00 33.59           O  
ATOM  10626  CB  MET F  85     -14.190 120.434  32.695  1.00 35.07           C  
ATOM  10627  CG  MET F  85     -13.765 120.221  31.261  1.00 36.96           C  
ATOM  10628  SD  MET F  85     -12.709 121.575  30.701  1.00 37.92           S  
ATOM  10629  CE  MET F  85     -12.242 120.981  29.073  1.00 35.09           C  
ATOM  10630  N   VAL F  86     -13.699 117.960  34.306  1.00 33.55           N  
ATOM  10631  CA  VAL F  86     -12.955 116.759  34.570  1.00 32.91           C  
ATOM  10632  C   VAL F  86     -13.864 115.666  35.135  1.00 32.49           C  
ATOM  10633  O   VAL F  86     -13.720 114.507  34.769  1.00 32.13           O  
ATOM  10634  CB  VAL F  86     -11.758 117.057  35.503  1.00 32.90           C  
ATOM  10635  CG1 VAL F  86     -11.134 115.778  36.027  1.00 33.96           C  
ATOM  10636  CG2 VAL F  86     -10.713 117.873  34.752  1.00 33.25           C  
ATOM  10637  N   ASP F  87     -14.803 116.033  36.007  1.00 32.01           N  
ATOM  10638  CA  ASP F  87     -15.763 115.057  36.506  1.00 32.08           C  
ATOM  10639  C   ASP F  87     -16.648 114.459  35.398  1.00 32.03           C  
ATOM  10640  O   ASP F  87     -16.943 113.272  35.435  1.00 32.44           O  
ATOM  10641  CB  ASP F  87     -16.602 115.606  37.663  1.00 31.38           C  
ATOM  10642  CG  ASP F  87     -17.587 114.592  38.200  1.00 32.07           C  
ATOM  10643  OD1 ASP F  87     -17.157 113.580  38.815  1.00 31.44           O  
ATOM  10644  OD2 ASP F  87     -18.801 114.813  38.008  1.00 32.82           O  
ATOM  10645  N   THR F  88     -17.058 115.249  34.410  1.00 32.15           N  
ATOM  10646  CA  THR F  88     -17.908 114.666  33.361  1.00 32.92           C  
ATOM  10647  C   THR F  88     -17.119 113.779  32.378  1.00 32.65           C  
ATOM  10648  O   THR F  88     -17.676 112.845  31.815  1.00 33.13           O  
ATOM  10649  CB  THR F  88     -18.864 115.699  32.616  1.00 33.08           C  
ATOM  10650  OG1 THR F  88     -18.401 115.965  31.295  1.00 34.69           O  
ATOM  10651  CG2 THR F  88     -19.049 116.989  33.386  1.00 32.62           C  
ATOM  10652  N   ILE F  89     -15.828 114.070  32.197  1.00 32.23           N  
ATOM  10653  CA  ILE F  89     -14.959 113.292  31.325  1.00 31.12           C  
ATOM  10654  C   ILE F  89     -14.664 111.935  31.955  1.00 31.60           C  
ATOM  10655  O   ILE F  89     -14.769 110.906  31.286  1.00 32.19           O  
ATOM  10656  CB  ILE F  89     -13.638 114.047  30.998  1.00 31.37           C  
ATOM  10657  CG1 ILE F  89     -13.869 115.073  29.890  1.00 30.68           C  
ATOM  10658  CG2 ILE F  89     -12.473 113.060  30.648  1.00 29.54           C  
ATOM  10659  CD1 ILE F  89     -12.695 116.011  29.695  1.00 27.90           C  
ATOM  10660  N   LYS F  90     -14.279 111.953  33.229  1.00 30.93           N  
ATOM  10661  CA  LYS F  90     -14.060 110.760  34.031  1.00 31.15           C  
ATOM  10662  C   LYS F  90     -15.267 109.797  34.045  1.00 31.29           C  
ATOM  10663  O   LYS F  90     -15.110 108.585  33.876  1.00 31.47           O  
ATOM  10664  CB  LYS F  90     -13.708 111.183  35.458  1.00 30.63           C  
ATOM  10665  CG  LYS F  90     -13.330 110.043  36.357  1.00 31.66           C  
ATOM  10666  CD  LYS F  90     -12.683 110.515  37.647  1.00 32.45           C  
ATOM  10667  CE  LYS F  90     -13.719 110.861  38.684  1.00 34.92           C  
ATOM  10668  NZ  LYS F  90     -13.099 110.790  40.058  1.00 38.11           N  
ATOM  10669  N   ASN F  91     -16.450 110.358  34.261  1.00 31.20           N  
ATOM  10670  CA  ASN F  91     -17.731 109.644  34.251  1.00 31.59           C  
ATOM  10671  C   ASN F  91     -18.004 109.013  32.883  1.00 31.07           C  
ATOM  10672  O   ASN F  91     -18.503 107.889  32.787  1.00 32.06           O  
ATOM  10673  CB  ASN F  91     -18.857 110.630  34.628  1.00 31.49           C  
ATOM  10674  CG  ASN F  91     -20.237 109.971  34.723  1.00 34.73           C  
ATOM  10675  OD1 ASN F  91     -21.196 110.419  34.081  1.00 37.36           O  
ATOM  10676  ND2 ASN F  91     -20.351 108.923  35.544  1.00 37.12           N  
ATOM  10677  N   PHE F  92     -17.678 109.758  31.836  1.00 30.12           N  
ATOM  10678  CA  PHE F  92     -17.803 109.321  30.462  1.00 29.50           C  
ATOM  10679  C   PHE F  92     -16.914 108.106  30.207  1.00 29.26           C  
ATOM  10680  O   PHE F  92     -17.394 107.056  29.764  1.00 28.94           O  
ATOM  10681  CB  PHE F  92     -17.399 110.471  29.562  1.00 29.41           C  
ATOM  10682  CG  PHE F  92     -17.575 110.207  28.106  1.00 30.07           C  
ATOM  10683  CD1 PHE F  92     -18.808 109.801  27.599  1.00 30.84           C  
ATOM  10684  CD2 PHE F  92     -16.510 110.402  27.224  1.00 29.70           C  
ATOM  10685  CE1 PHE F  92     -18.970 109.576  26.233  1.00 30.71           C  
ATOM  10686  CE2 PHE F  92     -16.662 110.196  25.859  1.00 29.87           C  
ATOM  10687  CZ  PHE F  92     -17.887 109.776  25.358  1.00 30.57           C  
ATOM  10688  N   VAL F  93     -15.630 108.264  30.527  1.00 29.00           N  
ATOM  10689  CA  VAL F  93     -14.611 107.228  30.355  1.00 29.09           C  
ATOM  10690  C   VAL F  93     -14.928 105.934  31.151  1.00 29.38           C  
ATOM  10691  O   VAL F  93     -14.925 104.848  30.579  1.00 29.04           O  
ATOM  10692  CB  VAL F  93     -13.192 107.813  30.624  1.00 29.07           C  
ATOM  10693  CG1 VAL F  93     -12.137 106.737  30.544  1.00 27.98           C  
ATOM  10694  CG2 VAL F  93     -12.875 108.938  29.589  1.00 28.53           C  
ATOM  10695  N   ASN F  94     -15.215 106.076  32.445  1.00 28.73           N  
ATOM  10696  CA  ASN F  94     -15.743 104.997  33.285  1.00 28.81           C  
ATOM  10697  C   ASN F  94     -16.991 104.252  32.758  1.00 28.66           C  
ATOM  10698  O   ASN F  94     -17.111 103.030  32.927  1.00 29.49           O  
ATOM  10699  CB  ASN F  94     -16.033 105.533  34.679  1.00 29.09           C  
ATOM  10700  CG  ASN F  94     -16.106 104.440  35.712  1.00 29.53           C  
ATOM  10701  OD1 ASN F  94     -17.094 104.324  36.447  1.00 29.59           O  
ATOM  10702  ND2 ASN F  94     -15.061 103.632  35.778  1.00 26.83           N  
ATOM  10703  N   THR F  95     -17.925 104.968  32.151  1.00 27.93           N  
ATOM  10704  CA  THR F  95     -19.065 104.331  31.474  1.00 27.24           C  
ATOM  10705  C   THR F  95     -18.613 103.283  30.423  1.00 26.52           C  
ATOM  10706  O   THR F  95     -19.139 102.142  30.384  1.00 25.49           O  
ATOM  10707  CB  THR F  95     -19.993 105.396  30.869  1.00 27.49           C  
ATOM  10708  OG1 THR F  95     -20.435 106.263  31.926  1.00 28.94           O  
ATOM  10709  CG2 THR F  95     -21.200 104.764  30.183  1.00 26.57           C  
ATOM  10710  N   PHE F  96     -17.622 103.659  29.608  1.00 25.42           N  
ATOM  10711  CA  PHE F  96     -16.959 102.699  28.723  1.00 24.87           C  
ATOM  10712  C   PHE F  96     -16.211 101.616  29.514  1.00 24.54           C  
ATOM  10713  O   PHE F  96     -16.384 100.435  29.248  1.00 24.80           O  
ATOM  10714  CB  PHE F  96     -16.056 103.406  27.692  1.00 24.99           C  
ATOM  10715  CG  PHE F  96     -16.816 104.218  26.667  1.00 24.72           C  
ATOM  10716  CD1 PHE F  96     -17.339 103.610  25.524  1.00 24.54           C  
ATOM  10717  CD2 PHE F  96     -17.019 105.597  26.851  1.00 25.23           C  
ATOM  10718  CE1 PHE F  96     -18.067 104.335  24.573  1.00 22.63           C  
ATOM  10719  CE2 PHE F  96     -17.734 106.337  25.908  1.00 24.71           C  
ATOM  10720  CZ  PHE F  96     -18.252 105.700  24.753  1.00 24.88           C  
ATOM  10721  N   ILE F  97     -15.417 101.996  30.514  1.00 24.87           N  
ATOM  10722  CA  ILE F  97     -14.666 100.996  31.311  1.00 24.36           C  
ATOM  10723  C   ILE F  97     -15.590  99.947  31.953  1.00 24.78           C  
ATOM  10724  O   ILE F  97     -15.273  98.756  31.971  1.00 25.52           O  
ATOM  10725  CB  ILE F  97     -13.757 101.628  32.394  1.00 24.25           C  
ATOM  10726  CG1 ILE F  97     -12.706 102.564  31.778  1.00 23.42           C  
ATOM  10727  CG2 ILE F  97     -13.088 100.530  33.244  1.00 23.27           C  
ATOM  10728  CD1 ILE F  97     -12.021 103.455  32.815  1.00 23.58           C  
ATOM  10729  N   GLN F  98     -16.740 100.384  32.452  1.00 25.01           N  
ATOM  10730  CA  GLN F  98     -17.646  99.490  33.159  1.00 25.40           C  
ATOM  10731  C   GLN F  98     -18.621  98.688  32.270  1.00 25.69           C  
ATOM  10732  O   GLN F  98     -19.293  97.787  32.765  1.00 26.03           O  
ATOM  10733  CB  GLN F  98     -18.411 100.256  34.247  1.00 25.07           C  
ATOM  10734  CG  GLN F  98     -17.530 101.051  35.218  1.00 24.90           C  
ATOM  10735  CD  GLN F  98     -16.499 100.180  35.896  1.00 24.28           C  
ATOM  10736  OE1 GLN F  98     -16.775  99.033  36.214  1.00 24.45           O  
ATOM  10737  NE2 GLN F  98     -15.301 100.716  36.106  1.00 23.77           N  
ATOM  10738  N   PHE F  99     -18.683  98.997  30.978  1.00 26.12           N  
ATOM  10739  CA  PHE F  99     -19.721  98.433  30.097  1.00 26.36           C  
ATOM  10740  C   PHE F  99     -19.623  96.903  29.940  1.00 26.98           C  
ATOM  10741  O   PHE F  99     -18.553  96.366  29.592  1.00 27.11           O  
ATOM  10742  CB  PHE F  99     -19.728  99.137  28.742  1.00 26.25           C  
ATOM  10743  CG  PHE F  99     -21.086  99.175  28.088  1.00 25.71           C  
ATOM  10744  CD1 PHE F  99     -22.089 100.009  28.581  1.00 26.01           C  
ATOM  10745  CD2 PHE F  99     -21.361  98.385  26.982  1.00 24.28           C  
ATOM  10746  CE1 PHE F  99     -23.353 100.035  27.992  1.00 25.08           C  
ATOM  10747  CE2 PHE F  99     -22.617  98.393  26.389  1.00 24.63           C  
ATOM  10748  CZ  PHE F  99     -23.614  99.226  26.885  1.00 25.95           C  
ATOM  10749  N   LYS F 100     -20.736  96.215  30.219  1.00 26.53           N  
ATOM  10750  CA  LYS F 100     -20.736  94.758  30.268  1.00 27.34           C  
ATOM  10751  C   LYS F 100     -20.897  94.104  28.901  1.00 26.77           C  
ATOM  10752  O   LYS F 100     -20.259  93.092  28.627  1.00 26.45           O  
ATOM  10753  CB  LYS F 100     -21.762  94.207  31.273  1.00 27.63           C  
ATOM  10754  CG  LYS F 100     -21.433  94.561  32.728  1.00 30.51           C  
ATOM  10755  CD  LYS F 100     -22.037  93.569  33.712  1.00 34.34           C  
ATOM  10756  CE  LYS F 100     -20.941  92.744  34.385  1.00 37.42           C  
ATOM  10757  NZ  LYS F 100     -20.120  93.529  35.365  1.00 37.64           N  
ATOM  10758  N   LYS F 101     -21.740  94.693  28.055  1.00 26.71           N  
ATOM  10759  CA  LYS F 101     -22.006  94.180  26.713  1.00 26.49           C  
ATOM  10760  C   LYS F 101     -20.886  94.601  25.752  1.00 26.43           C  
ATOM  10761  O   LYS F 101     -20.268  95.645  25.963  1.00 26.11           O  
ATOM  10762  CB  LYS F 101     -23.337  94.724  26.202  1.00 26.13           C  
ATOM  10763  CG  LYS F 101     -24.544  94.215  26.939  1.00 27.51           C  
ATOM  10764  CD  LYS F 101     -25.803  94.904  26.436  1.00 28.52           C  
ATOM  10765  CE  LYS F 101     -26.994  94.624  27.342  1.00 28.36           C  
ATOM  10766  NZ  LYS F 101     -28.253  95.177  26.747  1.00 27.90           N  
ATOM  10767  N   PRO F 102     -20.628  93.801  24.691  1.00 26.07           N  
ATOM  10768  CA  PRO F 102     -19.611  94.220  23.723  1.00 26.07           C  
ATOM  10769  C   PRO F 102     -20.038  95.497  22.995  1.00 25.90           C  
ATOM  10770  O   PRO F 102     -21.223  95.671  22.693  1.00 24.83           O  
ATOM  10771  CB  PRO F 102     -19.532  93.033  22.738  1.00 25.95           C  
ATOM  10772  CG  PRO F 102     -20.192  91.868  23.457  1.00 25.87           C  
ATOM  10773  CD  PRO F 102     -21.238  92.508  24.324  1.00 26.21           C  
ATOM  10774  N   ILE F 103     -19.080  96.388  22.759  1.00 25.76           N  
ATOM  10775  CA  ILE F 103     -19.342  97.595  21.981  1.00 26.29           C  
ATOM  10776  C   ILE F 103     -18.546  97.563  20.696  1.00 26.68           C  
ATOM  10777  O   ILE F 103     -17.315  97.548  20.709  1.00 27.43           O  
ATOM  10778  CB  ILE F 103     -18.990  98.917  22.742  1.00 26.10           C  
ATOM  10779  CG1 ILE F 103     -19.902  99.114  23.949  1.00 25.29           C  
ATOM  10780  CG2 ILE F 103     -19.152 100.134  21.810  1.00 26.25           C  
ATOM  10781  CD1 ILE F 103     -19.584 100.372  24.768  1.00 25.96           C  
ATOM  10782  N   VAL F 104     -19.246  97.550  19.578  1.00 26.92           N  
ATOM  10783  CA  VAL F 104     -18.576  97.751  18.317  1.00 26.97           C  
ATOM  10784  C   VAL F 104     -18.666  99.230  17.990  1.00 27.07           C  
ATOM  10785  O   VAL F 104     -19.757  99.799  17.963  1.00 27.59           O  
ATOM  10786  CB  VAL F 104     -19.218  96.948  17.193  1.00 26.90           C  
ATOM  10787  CG1 VAL F 104     -18.373  97.061  15.945  1.00 26.31           C  
ATOM  10788  CG2 VAL F 104     -19.397  95.506  17.608  1.00 26.69           C  
ATOM  10789  N   VAL F 105     -17.520  99.862  17.776  1.00 26.99           N  
ATOM  10790  CA  VAL F 105     -17.531 101.231  17.307  1.00 26.56           C  
ATOM  10791  C   VAL F 105     -17.249 101.310  15.809  1.00 26.89           C  
ATOM  10792  O   VAL F 105     -16.343 100.652  15.287  1.00 26.89           O  
ATOM  10793  CB  VAL F 105     -16.673 102.198  18.178  1.00 26.64           C  
ATOM  10794  CG1 VAL F 105     -15.248 101.736  18.287  1.00 25.19           C  
ATOM  10795  CG2 VAL F 105     -16.792 103.652  17.660  1.00 24.84           C  
ATOM  10796  N   SER F 106     -18.065 102.111  15.130  1.00 27.09           N  
ATOM  10797  CA  SER F 106     -18.036 102.226  13.683  1.00 27.22           C  
ATOM  10798  C   SER F 106     -17.625 103.643  13.312  1.00 27.03           C  
ATOM  10799  O   SER F 106     -18.370 104.595  13.555  1.00 26.50           O  
ATOM  10800  CB  SER F 106     -19.417 101.895  13.122  1.00 27.22           C  
ATOM  10801  OG  SER F 106     -19.327 101.715  11.733  1.00 28.74           O  
ATOM  10802  N   VAL F 107     -16.437 103.773  12.719  1.00 26.75           N  
ATOM  10803  CA  VAL F 107     -15.795 105.078  12.536  1.00 26.34           C  
ATOM  10804  C   VAL F 107     -15.822 105.534  11.067  1.00 26.95           C  
ATOM  10805  O   VAL F 107     -15.092 105.020  10.218  1.00 26.49           O  
ATOM  10806  CB  VAL F 107     -14.331 105.070  13.066  1.00 26.09           C  
ATOM  10807  CG1 VAL F 107     -13.714 106.460  12.981  1.00 24.69           C  
ATOM  10808  CG2 VAL F 107     -14.262 104.523  14.493  1.00 24.86           C  
ATOM  10809  N   ASN F 108     -16.657 106.526  10.790  1.00 27.87           N  
ATOM  10810  CA  ASN F 108     -16.917 106.976   9.425  1.00 28.75           C  
ATOM  10811  C   ASN F 108     -15.915 108.005   8.934  1.00 28.39           C  
ATOM  10812  O   ASN F 108     -15.765 108.205   7.733  1.00 29.64           O  
ATOM  10813  CB  ASN F 108     -18.328 107.552   9.341  1.00 29.36           C  
ATOM  10814  CG  ASN F 108     -18.591 108.620  10.420  1.00 31.82           C  
ATOM  10815  OD1 ASN F 108     -18.859 109.796  10.107  1.00 35.40           O  
ATOM  10816  ND2 ASN F 108     -18.504 108.216  11.683  1.00 29.59           N  
ATOM  10817  N   GLY F 109     -15.229 108.664   9.859  1.00 28.18           N  
ATOM  10818  CA  GLY F 109     -14.351 109.777   9.499  1.00 27.47           C  
ATOM  10819  C   GLY F 109     -13.356 110.090  10.595  1.00 26.69           C  
ATOM  10820  O   GLY F 109     -13.101 109.241  11.452  1.00 27.32           O  
ATOM  10821  N   PRO F 110     -12.769 111.299  10.566  1.00 25.95           N  
ATOM  10822  CA  PRO F 110     -11.801 111.753  11.572  1.00 25.43           C  
ATOM  10823  C   PRO F 110     -12.238 111.513  13.023  1.00 24.94           C  
ATOM  10824  O   PRO F 110     -13.348 111.873  13.387  1.00 24.82           O  
ATOM  10825  CB  PRO F 110     -11.697 113.256  11.295  1.00 25.93           C  
ATOM  10826  CG  PRO F 110     -12.005 113.383   9.817  1.00 25.37           C  
ATOM  10827  CD  PRO F 110     -12.983 112.301   9.501  1.00 25.58           C  
ATOM  10828  N   ALA F 111     -11.375 110.864  13.818  1.00 24.15           N  
ATOM  10829  CA  ALA F 111     -11.558 110.744  15.274  1.00 23.15           C  
ATOM  10830  C   ALA F 111     -10.366 111.414  15.959  1.00 23.13           C  
ATOM  10831  O   ALA F 111      -9.219 111.015  15.748  1.00 22.84           O  
ATOM  10832  CB  ALA F 111     -11.698 109.298  15.714  1.00 22.40           C  
ATOM  10833  N   ILE F 112     -10.651 112.437  16.765  1.00 22.73           N  
ATOM  10834  CA  ILE F 112      -9.618 113.362  17.246  1.00 22.69           C  
ATOM  10835  C   ILE F 112      -9.721 113.511  18.750  1.00 22.54           C  
ATOM  10836  O   ILE F 112     -10.831 113.630  19.285  1.00 22.46           O  
ATOM  10837  CB  ILE F 112      -9.704 114.780  16.565  1.00 22.20           C  
ATOM  10838  CG1 ILE F 112      -9.743 114.663  15.046  1.00 22.48           C  
ATOM  10839  CG2 ILE F 112      -8.504 115.653  16.949  1.00 23.38           C  
ATOM  10840  CD1 ILE F 112      -9.908 116.029  14.304  1.00 23.46           C  
ATOM  10841  N   GLY F 113      -8.563 113.482  19.427  1.00 22.18           N  
ATOM  10842  CA  GLY F 113      -8.487 113.769  20.852  1.00 21.86           C  
ATOM  10843  C   GLY F 113      -9.280 112.740  21.618  1.00 22.44           C  
ATOM  10844  O   GLY F 113      -9.040 111.536  21.478  1.00 22.55           O  
ATOM  10845  N   LEU F 114     -10.241 113.204  22.411  1.00 22.55           N  
ATOM  10846  CA  LEU F 114     -11.102 112.291  23.186  1.00 22.71           C  
ATOM  10847  C   LEU F 114     -11.981 111.406  22.294  1.00 22.58           C  
ATOM  10848  O   LEU F 114     -12.350 110.303  22.693  1.00 23.21           O  
ATOM  10849  CB  LEU F 114     -11.935 113.048  24.241  1.00 22.43           C  
ATOM  10850  CG  LEU F 114     -12.735 112.238  25.284  1.00 22.33           C  
ATOM  10851  CD1 LEU F 114     -11.858 111.329  26.131  1.00 22.60           C  
ATOM  10852  CD2 LEU F 114     -13.580 113.143  26.180  1.00 22.64           C  
ATOM  10853  N   GLY F 115     -12.297 111.875  21.088  1.00 23.26           N  
ATOM  10854  CA  GLY F 115     -13.006 111.039  20.087  1.00 22.33           C  
ATOM  10855  C   GLY F 115     -12.200 109.832  19.610  1.00 22.40           C  
ATOM  10856  O   GLY F 115     -12.778 108.825  19.185  1.00 21.51           O  
ATOM  10857  N   ALA F 116     -10.868 109.949  19.694  1.00 22.32           N  
ATOM  10858  CA  ALA F 116      -9.923 108.893  19.365  1.00 22.81           C  
ATOM  10859  C   ALA F 116      -9.555 108.012  20.561  1.00 23.27           C  
ATOM  10860  O   ALA F 116      -9.575 106.798  20.443  1.00 23.59           O  
ATOM  10861  CB  ALA F 116      -8.652 109.479  18.712  1.00 22.78           C  
ATOM  10862  N   SER F 117      -9.239 108.613  21.711  1.00 24.44           N  
ATOM  10863  CA  SER F 117      -8.757 107.853  22.880  1.00 25.34           C  
ATOM  10864  C   SER F 117      -9.786 106.906  23.543  1.00 26.01           C  
ATOM  10865  O   SER F 117      -9.397 105.965  24.249  1.00 26.58           O  
ATOM  10866  CB  SER F 117      -8.116 108.788  23.920  1.00 25.34           C  
ATOM  10867  OG  SER F 117      -9.092 109.504  24.655  1.00 25.28           O  
ATOM  10868  N   ILE F 118     -11.081 107.151  23.333  1.00 26.43           N  
ATOM  10869  CA  ILE F 118     -12.110 106.231  23.834  1.00 27.00           C  
ATOM  10870  C   ILE F 118     -12.244 104.954  23.009  1.00 26.89           C  
ATOM  10871  O   ILE F 118     -12.825 103.973  23.490  1.00 27.11           O  
ATOM  10872  CB  ILE F 118     -13.510 106.867  23.916  1.00 27.12           C  
ATOM  10873  CG1 ILE F 118     -13.964 107.326  22.524  1.00 28.76           C  
ATOM  10874  CG2 ILE F 118     -13.521 107.995  24.963  1.00 28.18           C  
ATOM  10875  CD1 ILE F 118     -15.472 107.536  22.381  1.00 29.22           C  
ATOM  10876  N   LEU F 119     -11.722 104.973  21.781  1.00 26.05           N  
ATOM  10877  CA  LEU F 119     -11.839 103.852  20.877  1.00 25.88           C  
ATOM  10878  C   LEU F 119     -11.302 102.537  21.459  1.00 25.89           C  
ATOM  10879  O   LEU F 119     -12.014 101.534  21.413  1.00 25.67           O  
ATOM  10880  CB  LEU F 119     -11.246 104.169  19.487  1.00 25.74           C  
ATOM  10881  CG  LEU F 119     -11.965 105.262  18.651  1.00 25.07           C  
ATOM  10882  CD1 LEU F 119     -11.186 105.556  17.364  1.00 22.01           C  
ATOM  10883  CD2 LEU F 119     -13.443 104.954  18.362  1.00 22.00           C  
ATOM  10884  N   PRO F 120     -10.071 102.545  22.031  1.00 26.17           N  
ATOM  10885  CA  PRO F 120      -9.546 101.340  22.670  1.00 26.21           C  
ATOM  10886  C   PRO F 120     -10.380 100.812  23.825  1.00 26.53           C  
ATOM  10887  O   PRO F 120     -10.153  99.683  24.265  1.00 26.16           O  
ATOM  10888  CB  PRO F 120      -8.159 101.777  23.176  1.00 26.71           C  
ATOM  10889  CG  PRO F 120      -7.806 102.947  22.370  1.00 25.64           C  
ATOM  10890  CD  PRO F 120      -9.086 103.647  22.095  1.00 26.04           C  
ATOM  10891  N   LEU F 121     -11.345 101.603  24.304  1.00 26.59           N  
ATOM  10892  CA  LEU F 121     -12.210 101.165  25.405  1.00 26.64           C  
ATOM  10893  C   LEU F 121     -13.397 100.330  24.917  1.00 26.33           C  
ATOM  10894  O   LEU F 121     -14.108  99.702  25.711  1.00 26.32           O  
ATOM  10895  CB  LEU F 121     -12.692 102.366  26.234  1.00 26.79           C  
ATOM  10896  CG  LEU F 121     -11.633 103.259  26.887  1.00 27.01           C  
ATOM  10897  CD1 LEU F 121     -12.291 104.474  27.557  1.00 25.97           C  
ATOM  10898  CD2 LEU F 121     -10.778 102.468  27.889  1.00 27.86           C  
ATOM  10899  N   CYS F 122     -13.611 100.324  23.608  1.00 26.15           N  
ATOM  10900  CA  CYS F 122     -14.652  99.488  23.017  1.00 25.83           C  
ATOM  10901  C   CYS F 122     -14.042  98.157  22.579  1.00 25.58           C  
ATOM  10902  O   CYS F 122     -12.839  97.935  22.753  1.00 26.50           O  
ATOM  10903  CB  CYS F 122     -15.329 100.219  21.866  1.00 25.36           C  
ATOM  10904  SG  CYS F 122     -15.899 101.872  22.335  1.00 25.79           S  
ATOM  10905  N   ASP F 123     -14.847  97.287  21.995  1.00 24.92           N  
ATOM  10906  CA  ASP F 123     -14.424  95.900  21.792  1.00 25.24           C  
ATOM  10907  C   ASP F 123     -13.979  95.572  20.390  1.00 24.75           C  
ATOM  10908  O   ASP F 123     -13.105  94.738  20.188  1.00 24.38           O  
ATOM  10909  CB  ASP F 123     -15.518  94.983  22.292  1.00 24.97           C  
ATOM  10910  CG  ASP F 123     -15.789  95.230  23.738  1.00 26.73           C  
ATOM  10911  OD1 ASP F 123     -15.000  94.691  24.534  1.00 29.16           O  
ATOM  10912  OD2 ASP F 123     -16.700  96.030  24.079  1.00 27.30           O  
ATOM  10913  N   LEU F 124     -14.578  96.269  19.431  1.00 25.16           N  
ATOM  10914  CA  LEU F 124     -14.197  96.194  18.033  1.00 25.50           C  
ATOM  10915  C   LEU F 124     -14.253  97.607  17.495  1.00 25.66           C  
ATOM  10916  O   LEU F 124     -15.197  98.352  17.792  1.00 25.77           O  
ATOM  10917  CB  LEU F 124     -15.135  95.250  17.260  1.00 25.54           C  
ATOM  10918  CG  LEU F 124     -15.104  93.741  17.585  1.00 26.28           C  
ATOM  10919  CD1 LEU F 124     -16.245  92.973  16.924  1.00 26.12           C  
ATOM  10920  CD2 LEU F 124     -13.781  93.117  17.183  1.00 27.21           C  
ATOM  10921  N   VAL F 125     -13.213  97.983  16.749  1.00 26.31           N  
ATOM  10922  CA  VAL F 125     -13.140  99.290  16.065  1.00 26.70           C  
ATOM  10923  C   VAL F 125     -13.161  99.086  14.541  1.00 26.59           C  
ATOM  10924  O   VAL F 125     -12.202  98.604  13.952  1.00 26.43           O  
ATOM  10925  CB  VAL F 125     -11.903 100.137  16.506  1.00 26.49           C  
ATOM  10926  CG1 VAL F 125     -11.908 101.498  15.803  1.00 26.78           C  
ATOM  10927  CG2 VAL F 125     -11.895 100.320  18.013  1.00 26.24           C  
ATOM  10928  N   TRP F 126     -14.282  99.454  13.925  1.00 26.95           N  
ATOM  10929  CA  TRP F 126     -14.477  99.311  12.466  1.00 26.89           C  
ATOM  10930  C   TRP F 126     -14.404 100.669  11.796  1.00 26.46           C  
ATOM  10931  O   TRP F 126     -15.218 101.546  12.058  1.00 26.26           O  
ATOM  10932  CB  TRP F 126     -15.818  98.638  12.140  1.00 26.47           C  
ATOM  10933  CG  TRP F 126     -15.859  97.209  12.565  1.00 26.85           C  
ATOM  10934  CD1 TRP F 126     -14.789  96.435  12.948  1.00 26.06           C  
ATOM  10935  CD2 TRP F 126     -17.014  96.364  12.645  1.00 26.65           C  
ATOM  10936  NE1 TRP F 126     -15.209  95.179  13.266  1.00 25.36           N  
ATOM  10937  CE2 TRP F 126     -16.569  95.099  13.089  1.00 26.66           C  
ATOM  10938  CE3 TRP F 126     -18.386  96.553  12.386  1.00 27.15           C  
ATOM  10939  CZ2 TRP F 126     -17.447  94.016  13.276  1.00 27.15           C  
ATOM  10940  CZ3 TRP F 126     -19.255  95.491  12.579  1.00 26.05           C  
ATOM  10941  CH2 TRP F 126     -18.781  94.232  13.018  1.00 26.96           C  
ATOM  10942  N   ALA F 127     -13.394 100.833  10.956  1.00 26.71           N  
ATOM  10943  CA  ALA F 127     -13.113 102.117  10.348  1.00 26.44           C  
ATOM  10944  C   ALA F 127     -13.345 102.069   8.852  1.00 26.89           C  
ATOM  10945  O   ALA F 127     -12.980 101.099   8.173  1.00 26.85           O  
ATOM  10946  CB  ALA F 127     -11.695 102.548  10.639  1.00 26.01           C  
ATOM  10947  N   ASN F 128     -13.977 103.129   8.357  1.00 26.99           N  
ATOM  10948  CA  ASN F 128     -13.950 103.484   6.950  1.00 27.63           C  
ATOM  10949  C   ASN F 128     -12.519 103.803   6.571  1.00 28.04           C  
ATOM  10950  O   ASN F 128     -11.811 104.444   7.336  1.00 28.33           O  
ATOM  10951  CB  ASN F 128     -14.830 104.714   6.735  1.00 27.17           C  
ATOM  10952  CG  ASN F 128     -14.965 105.095   5.293  1.00 26.82           C  
ATOM  10953  OD1 ASN F 128     -14.074 104.850   4.474  1.00 26.95           O  
ATOM  10954  ND2 ASN F 128     -16.074 105.741   4.971  1.00 24.95           N  
ATOM  10955  N   GLU F 129     -12.101 103.369   5.385  1.00 29.06           N  
ATOM  10956  CA  GLU F 129     -10.709 103.526   4.921  1.00 29.48           C  
ATOM  10957  C   GLU F 129     -10.237 104.992   4.841  1.00 29.25           C  
ATOM  10958  O   GLU F 129      -9.030 105.273   4.849  1.00 29.02           O  
ATOM  10959  CB  GLU F 129     -10.537 102.832   3.563  1.00 29.43           C  
ATOM  10960  CG  GLU F 129     -11.365 103.462   2.438  1.00 29.94           C  
ATOM  10961  CD  GLU F 129     -11.238 102.742   1.112  1.00 30.86           C  
ATOM  10962  OE1 GLU F 129     -10.114 102.298   0.757  1.00 32.94           O  
ATOM  10963  OE2 GLU F 129     -12.276 102.636   0.412  1.00 32.07           O  
ATOM  10964  N   LYS F 130     -11.208 105.906   4.760  1.00 29.21           N  
ATOM  10965  CA  LYS F 130     -10.979 107.347   4.653  1.00 28.78           C  
ATOM  10966  C   LYS F 130     -10.907 108.054   6.012  1.00 28.22           C  
ATOM  10967  O   LYS F 130     -10.621 109.253   6.067  1.00 28.41           O  
ATOM  10968  CB  LYS F 130     -12.093 107.994   3.812  1.00 29.23           C  
ATOM  10969  CG  LYS F 130     -12.440 107.287   2.500  1.00 29.80           C  
ATOM  10970  CD  LYS F 130     -11.425 107.625   1.406  1.00 31.50           C  
ATOM  10971  CE  LYS F 130     -11.455 106.605   0.266  1.00 30.44           C  
ATOM  10972  NZ  LYS F 130     -10.406 106.912  -0.742  1.00 30.13           N  
ATOM  10973  N   ALA F 131     -11.176 107.334   7.104  1.00 27.50           N  
ATOM  10974  CA  ALA F 131     -11.006 107.906   8.460  1.00 26.69           C  
ATOM  10975  C   ALA F 131      -9.535 108.025   8.818  1.00 26.15           C  
ATOM  10976  O   ALA F 131      -8.712 107.263   8.336  1.00 26.17           O  
ATOM  10977  CB  ALA F 131     -11.742 107.072   9.514  1.00 26.19           C  
ATOM  10978  N   TRP F 132      -9.209 108.994   9.656  1.00 26.11           N  
ATOM  10979  CA  TRP F 132      -7.869 109.087  10.252  1.00 25.89           C  
ATOM  10980  C   TRP F 132      -7.978 109.428  11.745  1.00 25.57           C  
ATOM  10981  O   TRP F 132      -9.037 109.812  12.220  1.00 25.45           O  
ATOM  10982  CB  TRP F 132      -6.970 110.073   9.493  1.00 26.05           C  
ATOM  10983  CG  TRP F 132      -7.593 111.414   9.271  1.00 25.57           C  
ATOM  10984  CD1 TRP F 132      -8.306 111.809   8.176  1.00 25.88           C  
ATOM  10985  CD2 TRP F 132      -7.545 112.543  10.148  1.00 25.59           C  
ATOM  10986  NE1 TRP F 132      -8.708 113.106   8.315  1.00 25.11           N  
ATOM  10987  CE2 TRP F 132      -8.262 113.588   9.517  1.00 26.09           C  
ATOM  10988  CE3 TRP F 132      -6.987 112.767  11.419  1.00 25.28           C  
ATOM  10989  CZ2 TRP F 132      -8.435 114.852  10.108  1.00 26.30           C  
ATOM  10990  CZ3 TRP F 132      -7.143 114.025  12.006  1.00 26.60           C  
ATOM  10991  CH2 TRP F 132      -7.862 115.056  11.349  1.00 26.44           C  
ATOM  10992  N   PHE F 133      -6.880 109.272  12.476  1.00 25.33           N  
ATOM  10993  CA  PHE F 133      -6.921 109.209  13.935  1.00 24.81           C  
ATOM  10994  C   PHE F 133      -5.805 110.063  14.483  1.00 24.47           C  
ATOM  10995  O   PHE F 133      -4.700 110.003  13.963  1.00 23.60           O  
ATOM  10996  CB  PHE F 133      -6.799 107.739  14.390  1.00 24.42           C  
ATOM  10997  CG  PHE F 133      -7.912 106.870  13.862  1.00 24.78           C  
ATOM  10998  CD1 PHE F 133      -9.038 106.623  14.626  1.00 24.25           C  
ATOM  10999  CD2 PHE F 133      -7.866 106.355  12.557  1.00 24.33           C  
ATOM  11000  CE1 PHE F 133     -10.081 105.856  14.113  1.00 24.35           C  
ATOM  11001  CE2 PHE F 133      -8.917 105.605  12.044  1.00 23.30           C  
ATOM  11002  CZ  PHE F 133     -10.021 105.353  12.818  1.00 23.14           C  
ATOM  11003  N   GLN F 134      -6.108 110.868  15.510  1.00 23.73           N  
ATOM  11004  CA  GLN F 134      -5.123 111.775  16.113  1.00 23.97           C  
ATOM  11005  C   GLN F 134      -5.467 112.104  17.570  1.00 24.39           C  
ATOM  11006  O   GLN F 134      -6.641 112.292  17.916  1.00 24.67           O  
ATOM  11007  CB  GLN F 134      -5.027 113.083  15.289  1.00 23.59           C  
ATOM  11008  CG  GLN F 134      -3.775 113.913  15.559  1.00 23.17           C  
ATOM  11009  CD  GLN F 134      -3.835 115.305  14.937  1.00 24.45           C  
ATOM  11010  OE1 GLN F 134      -4.906 115.790  14.576  1.00 23.81           O  
ATOM  11011  NE2 GLN F 134      -2.673 115.951  14.800  1.00 23.44           N  
ATOM  11012  N   THR F 135      -4.445 112.171  18.424  1.00 24.88           N  
ATOM  11013  CA  THR F 135      -4.603 112.647  19.800  1.00 25.23           C  
ATOM  11014  C   THR F 135      -3.587 113.780  20.037  1.00 25.05           C  
ATOM  11015  O   THR F 135      -2.553 113.577  20.696  1.00 24.79           O  
ATOM  11016  CB  THR F 135      -4.385 111.517  20.844  1.00 25.66           C  
ATOM  11017  OG1 THR F 135      -3.137 110.876  20.581  1.00 25.12           O  
ATOM  11018  CG2 THR F 135      -5.520 110.466  20.823  1.00 25.70           C  
ATOM  11019  N   PRO F 136      -3.872 114.979  19.490  1.00 25.05           N  
ATOM  11020  CA  PRO F 136      -2.903 116.077  19.502  1.00 24.96           C  
ATOM  11021  C   PRO F 136      -2.861 116.787  20.863  1.00 25.06           C  
ATOM  11022  O   PRO F 136      -3.120 117.987  20.936  1.00 24.65           O  
ATOM  11023  CB  PRO F 136      -3.449 117.023  18.426  1.00 25.17           C  
ATOM  11024  CG  PRO F 136      -4.898 116.822  18.444  1.00 24.70           C  
ATOM  11025  CD  PRO F 136      -5.143 115.383  18.854  1.00 24.93           C  
ATOM  11026  N   TYR F 137      -2.531 116.036  21.916  1.00 25.11           N  
ATOM  11027  CA  TYR F 137      -2.562 116.548  23.291  1.00 25.43           C  
ATOM  11028  C   TYR F 137      -1.642 117.746  23.528  1.00 25.45           C  
ATOM  11029  O   TYR F 137      -2.052 118.717  24.141  1.00 25.43           O  
ATOM  11030  CB  TYR F 137      -2.279 115.430  24.302  1.00 24.80           C  
ATOM  11031  CG  TYR F 137      -3.335 114.346  24.320  1.00 23.96           C  
ATOM  11032  CD1 TYR F 137      -4.684 114.665  24.371  1.00 23.45           C  
ATOM  11033  CD2 TYR F 137      -2.974 112.997  24.306  1.00 23.34           C  
ATOM  11034  CE1 TYR F 137      -5.652 113.665  24.409  1.00 24.40           C  
ATOM  11035  CE2 TYR F 137      -3.935 112.000  24.346  1.00 23.20           C  
ATOM  11036  CZ  TYR F 137      -5.262 112.348  24.403  1.00 23.55           C  
ATOM  11037  OH  TYR F 137      -6.207 111.385  24.427  1.00 24.95           O  
ATOM  11038  N   THR F 138      -0.411 117.657  23.031  1.00 26.42           N  
ATOM  11039  CA  THR F 138       0.575 118.736  23.115  1.00 27.24           C  
ATOM  11040  C   THR F 138       0.166 120.010  22.355  1.00 27.40           C  
ATOM  11041  O   THR F 138       0.544 121.107  22.758  1.00 28.13           O  
ATOM  11042  CB  THR F 138       1.981 118.261  22.661  1.00 27.42           C  
ATOM  11043  OG1 THR F 138       1.869 117.502  21.452  1.00 28.66           O  
ATOM  11044  CG2 THR F 138       2.616 117.366  23.724  1.00 27.93           C  
ATOM  11045  N   THR F 139      -0.600 119.869  21.273  1.00 27.44           N  
ATOM  11046  CA  THR F 139      -1.199 121.023  20.578  1.00 27.84           C  
ATOM  11047  C   THR F 139      -2.299 121.651  21.437  1.00 27.58           C  
ATOM  11048  O   THR F 139      -2.337 122.875  21.583  1.00 27.68           O  
ATOM  11049  CB  THR F 139      -1.738 120.664  19.154  1.00 27.87           C  
ATOM  11050  OG1 THR F 139      -0.667 120.159  18.364  1.00 29.31           O  
ATOM  11051  CG2 THR F 139      -2.286 121.890  18.425  1.00 28.91           C  
ATOM  11052  N   PHE F 140      -3.161 120.807  22.017  1.00 27.21           N  
ATOM  11053  CA  PHE F 140      -4.217 121.245  22.929  1.00 27.06           C  
ATOM  11054  C   PHE F 140      -3.630 121.955  24.161  1.00 27.25           C  
ATOM  11055  O   PHE F 140      -4.190 122.930  24.636  1.00 27.38           O  
ATOM  11056  CB  PHE F 140      -5.058 120.059  23.437  1.00 27.02           C  
ATOM  11057  CG  PHE F 140      -5.876 119.317  22.368  1.00 27.13           C  
ATOM  11058  CD1 PHE F 140      -6.240 119.909  21.161  1.00 26.56           C  
ATOM  11059  CD2 PHE F 140      -6.331 118.018  22.630  1.00 25.93           C  
ATOM  11060  CE1 PHE F 140      -7.014 119.197  20.221  1.00 27.69           C  
ATOM  11061  CE2 PHE F 140      -7.092 117.306  21.715  1.00 25.14           C  
ATOM  11062  CZ  PHE F 140      -7.443 117.892  20.509  1.00 26.44           C  
ATOM  11063  N   GLY F 141      -2.511 121.448  24.683  1.00 27.69           N  
ATOM  11064  CA  GLY F 141      -1.969 121.899  25.979  1.00 27.06           C  
ATOM  11065  C   GLY F 141      -2.500 121.111  27.177  1.00 26.54           C  
ATOM  11066  O   GLY F 141      -2.643 121.647  28.275  1.00 25.94           O  
ATOM  11067  N   GLN F 142      -2.810 119.835  26.946  1.00 26.67           N  
ATOM  11068  CA  GLN F 142      -3.245 118.902  27.993  1.00 26.02           C  
ATOM  11069  C   GLN F 142      -2.418 117.625  27.903  1.00 25.71           C  
ATOM  11070  O   GLN F 142      -1.804 117.334  26.873  1.00 25.72           O  
ATOM  11071  CB  GLN F 142      -4.744 118.563  27.860  1.00 26.49           C  
ATOM  11072  CG  GLN F 142      -5.077 117.764  26.605  1.00 25.39           C  
ATOM  11073  CD  GLN F 142      -6.493 117.200  26.565  1.00 25.81           C  
ATOM  11074  OE1 GLN F 142      -7.341 117.699  25.816  1.00 25.14           O  
ATOM  11075  NE2 GLN F 142      -6.742 116.121  27.323  1.00 22.38           N  
ATOM  11076  N   SER F 143      -2.398 116.884  29.005  1.00 25.25           N  
ATOM  11077  CA  SER F 143      -1.936 115.495  29.044  1.00 24.45           C  
ATOM  11078  C   SER F 143      -3.051 114.524  28.555  1.00 23.71           C  
ATOM  11079  O   SER F 143      -4.172 114.952  28.324  1.00 22.86           O  
ATOM  11080  CB  SER F 143      -1.530 115.196  30.481  1.00 25.06           C  
ATOM  11081  OG  SER F 143      -2.559 115.630  31.350  1.00 25.21           O  
ATOM  11082  N   PRO F 144      -2.740 113.224  28.355  1.00 23.53           N  
ATOM  11083  CA  PRO F 144      -3.772 112.264  27.838  1.00 23.27           C  
ATOM  11084  C   PRO F 144      -5.124 112.146  28.577  1.00 23.14           C  
ATOM  11085  O   PRO F 144      -5.217 112.395  29.782  1.00 23.65           O  
ATOM  11086  CB  PRO F 144      -3.061 110.907  27.850  1.00 22.91           C  
ATOM  11087  CG  PRO F 144      -1.563 111.226  27.836  1.00 23.17           C  
ATOM  11088  CD  PRO F 144      -1.406 112.601  28.501  1.00 23.14           C  
ATOM  11089  N   ASP F 145      -6.158 111.774  27.827  1.00 22.62           N  
ATOM  11090  CA  ASP F 145      -7.435 111.363  28.389  1.00 22.79           C  
ATOM  11091  C   ASP F 145      -7.886 110.023  27.781  1.00 22.14           C  
ATOM  11092  O   ASP F 145      -7.211 109.480  26.902  1.00 22.83           O  
ATOM  11093  CB  ASP F 145      -8.497 112.439  28.185  1.00 22.68           C  
ATOM  11094  CG  ASP F 145      -8.624 112.862  26.751  1.00 22.98           C  
ATOM  11095  OD1 ASP F 145      -8.531 112.003  25.822  1.00 22.58           O  
ATOM  11096  OD2 ASP F 145      -8.819 114.077  26.557  1.00 25.32           O  
ATOM  11097  N   GLY F 146      -9.008 109.495  28.262  1.00 21.50           N  
ATOM  11098  CA  GLY F 146      -9.569 108.237  27.768  1.00 21.20           C  
ATOM  11099  C   GLY F 146      -8.783 106.971  28.085  1.00 21.38           C  
ATOM  11100  O   GLY F 146      -9.039 105.931  27.493  1.00 21.88           O  
ATOM  11101  N   CYS F 147      -7.867 107.052  29.048  1.00 22.04           N  
ATOM  11102  CA  CYS F 147      -6.914 105.970  29.417  1.00 22.39           C  
ATOM  11103  C   CYS F 147      -5.861 105.729  28.346  1.00 22.39           C  
ATOM  11104  O   CYS F 147      -5.211 104.685  28.352  1.00 22.93           O  
ATOM  11105  CB  CYS F 147      -7.602 104.636  29.771  1.00 22.24           C  
ATOM  11106  SG  CYS F 147      -8.982 104.692  30.908  1.00 24.73           S  
ATOM  11107  N   SER F 148      -5.692 106.676  27.423  1.00 22.59           N  
ATOM  11108  CA  SER F 148      -4.788 106.476  26.293  1.00 23.19           C  
ATOM  11109  C   SER F 148      -3.332 106.437  26.768  1.00 23.36           C  
ATOM  11110  O   SER F 148      -2.459 105.949  26.056  1.00 23.54           O  
ATOM  11111  CB  SER F 148      -5.019 107.512  25.176  1.00 22.74           C  
ATOM  11112  OG  SER F 148      -4.782 108.841  25.625  1.00 24.89           O  
ATOM  11113  N   SER F 149      -3.108 106.908  27.997  1.00 23.86           N  
ATOM  11114  CA  SER F 149      -1.804 106.903  28.633  1.00 24.33           C  
ATOM  11115  C   SER F 149      -1.337 105.468  28.961  1.00 24.80           C  
ATOM  11116  O   SER F 149      -0.147 105.241  29.140  1.00 24.46           O  
ATOM  11117  CB  SER F 149      -1.822 107.783  29.900  1.00 24.09           C  
ATOM  11118  OG  SER F 149      -2.808 107.358  30.837  1.00 23.23           O  
ATOM  11119  N   ILE F 150      -2.272 104.513  29.065  1.00 24.67           N  
ATOM  11120  CA  ILE F 150      -1.879 103.105  29.128  1.00 24.36           C  
ATOM  11121  C   ILE F 150      -2.260 102.320  27.866  1.00 24.91           C  
ATOM  11122  O   ILE F 150      -1.492 101.496  27.418  1.00 25.81           O  
ATOM  11123  CB  ILE F 150      -2.379 102.356  30.412  1.00 24.73           C  
ATOM  11124  CG1 ILE F 150      -3.907 102.252  30.463  1.00 24.02           C  
ATOM  11125  CG2 ILE F 150      -1.765 102.963  31.674  1.00 23.68           C  
ATOM  11126  CD1 ILE F 150      -4.383 101.165  31.400  1.00 27.73           C  
ATOM  11127  N   THR F 151      -3.429 102.571  27.283  1.00 25.12           N  
ATOM  11128  CA  THR F 151      -3.909 101.731  26.178  1.00 25.36           C  
ATOM  11129  C   THR F 151      -3.079 101.869  24.890  1.00 25.58           C  
ATOM  11130  O   THR F 151      -2.902 100.903  24.151  1.00 26.04           O  
ATOM  11131  CB  THR F 151      -5.375 102.048  25.816  1.00 25.80           C  
ATOM  11132  OG1 THR F 151      -5.512 103.451  25.568  1.00 26.17           O  
ATOM  11133  CG2 THR F 151      -6.339 101.616  26.908  1.00 24.16           C  
ATOM  11134  N   PHE F 152      -2.609 103.076  24.602  1.00 25.98           N  
ATOM  11135  CA  PHE F 152      -1.748 103.311  23.440  1.00 26.10           C  
ATOM  11136  C   PHE F 152      -0.399 102.578  23.581  1.00 26.76           C  
ATOM  11137  O   PHE F 152      -0.045 101.797  22.694  1.00 27.02           O  
ATOM  11138  CB  PHE F 152      -1.560 104.816  23.171  1.00 25.34           C  
ATOM  11139  CG  PHE F 152      -2.731 105.475  22.473  1.00 25.47           C  
ATOM  11140  CD1 PHE F 152      -4.030 104.968  22.599  1.00 24.97           C  
ATOM  11141  CD2 PHE F 152      -2.533 106.627  21.695  1.00 24.41           C  
ATOM  11142  CE1 PHE F 152      -5.116 105.581  21.954  1.00 22.78           C  
ATOM  11143  CE2 PHE F 152      -3.602 107.235  21.043  1.00 25.89           C  
ATOM  11144  CZ  PHE F 152      -4.907 106.711  21.184  1.00 24.60           C  
ATOM  11145  N   PRO F 153       0.358 102.817  24.685  1.00 27.14           N  
ATOM  11146  CA  PRO F 153       1.619 102.052  24.825  1.00 27.82           C  
ATOM  11147  C   PRO F 153       1.429 100.534  24.808  1.00 28.59           C  
ATOM  11148  O   PRO F 153       2.271  99.821  24.272  1.00 28.52           O  
ATOM  11149  CB  PRO F 153       2.165 102.501  26.185  1.00 27.42           C  
ATOM  11150  CG  PRO F 153       1.550 103.840  26.436  1.00 27.34           C  
ATOM  11151  CD  PRO F 153       0.166 103.751  25.812  1.00 26.90           C  
ATOM  11152  N   LYS F 154       0.328 100.053  25.384  1.00 29.44           N  
ATOM  11153  CA  LYS F 154       0.021  98.628  25.387  1.00 30.35           C  
ATOM  11154  C   LYS F 154      -0.238  98.020  24.003  1.00 30.71           C  
ATOM  11155  O   LYS F 154       0.178  96.896  23.755  1.00 30.54           O  
ATOM  11156  CB  LYS F 154      -1.113  98.318  26.366  1.00 30.52           C  
ATOM  11157  CG  LYS F 154      -0.577  97.942  27.734  1.00 32.62           C  
ATOM  11158  CD  LYS F 154      -1.193  98.740  28.861  1.00 37.26           C  
ATOM  11159  CE  LYS F 154      -0.165  98.994  29.991  1.00 40.41           C  
ATOM  11160  NZ  LYS F 154       0.855 100.078  29.654  1.00 40.91           N  
ATOM  11161  N   MET F 155      -0.910  98.746  23.111  1.00 31.48           N  
ATOM  11162  CA  MET F 155      -1.237  98.200  21.783  1.00 32.74           C  
ATOM  11163  C   MET F 155      -0.157  98.489  20.730  1.00 32.70           C  
ATOM  11164  O   MET F 155      -0.026  97.748  19.763  1.00 33.12           O  
ATOM  11165  CB  MET F 155      -2.656  98.614  21.307  1.00 32.13           C  
ATOM  11166  CG  MET F 155      -2.748  99.873  20.421  1.00 33.96           C  
ATOM  11167  SD  MET F 155      -4.363 100.729  20.387  1.00 34.19           S  
ATOM  11168  CE  MET F 155      -5.398  99.445  21.077  1.00 34.96           C  
ATOM  11169  N   MET F 156       0.617  99.557  20.906  1.00 33.31           N  
ATOM  11170  CA  MET F 156       1.615  99.908  19.882  1.00 33.14           C  
ATOM  11171  C   MET F 156       3.066 100.006  20.355  1.00 33.46           C  
ATOM  11172  O   MET F 156       3.981 100.152  19.538  1.00 34.17           O  
ATOM  11173  CB  MET F 156       1.190 101.153  19.070  1.00 33.24           C  
ATOM  11174  CG  MET F 156       0.750 102.355  19.878  1.00 32.96           C  
ATOM  11175  SD  MET F 156      -0.035 103.683  18.943  1.00 31.99           S  
ATOM  11176  CE  MET F 156      -1.789 103.344  19.066  1.00 29.92           C  
ATOM  11177  N   GLY F 157       3.288  99.877  21.655  1.00 33.36           N  
ATOM  11178  CA  GLY F 157       4.609 100.124  22.229  1.00 33.24           C  
ATOM  11179  C   GLY F 157       4.684 101.571  22.659  1.00 33.06           C  
ATOM  11180  O   GLY F 157       4.009 102.422  22.096  1.00 33.10           O  
ATOM  11181  N   LYS F 158       5.525 101.852  23.646  1.00 33.34           N  
ATOM  11182  CA  LYS F 158       5.654 103.207  24.206  1.00 33.44           C  
ATOM  11183  C   LYS F 158       6.197 104.275  23.234  1.00 33.37           C  
ATOM  11184  O   LYS F 158       5.744 105.419  23.261  1.00 33.96           O  
ATOM  11185  CB  LYS F 158       6.522 103.171  25.461  1.00 33.45           C  
ATOM  11186  CG  LYS F 158       6.676 104.506  26.138  1.00 33.76           C  
ATOM  11187  CD  LYS F 158       7.683 104.443  27.254  1.00 33.90           C  
ATOM  11188  CE  LYS F 158       9.086 104.516  26.718  1.00 33.63           C  
ATOM  11189  NZ  LYS F 158      10.068 104.647  27.820  1.00 34.81           N  
ATOM  11190  N   ALA F 159       7.173 103.911  22.404  1.00 33.20           N  
ATOM  11191  CA  ALA F 159       7.732 104.833  21.421  1.00 32.48           C  
ATOM  11192  C   ALA F 159       6.679 105.254  20.394  1.00 32.48           C  
ATOM  11193  O   ALA F 159       6.432 106.445  20.228  1.00 32.35           O  
ATOM  11194  CB  ALA F 159       8.938 104.221  20.741  1.00 32.60           C  
ATOM  11195  N   SER F 160       6.067 104.278  19.718  1.00 32.41           N  
ATOM  11196  CA  SER F 160       4.989 104.538  18.755  1.00 33.25           C  
ATOM  11197  C   SER F 160       3.809 105.302  19.360  1.00 32.41           C  
ATOM  11198  O   SER F 160       3.249 106.176  18.715  1.00 32.66           O  
ATOM  11199  CB  SER F 160       4.466 103.241  18.133  1.00 33.02           C  
ATOM  11200  OG  SER F 160       5.444 102.634  17.316  1.00 35.98           O  
ATOM  11201  N   ALA F 161       3.436 104.964  20.590  1.00 32.25           N  
ATOM  11202  CA  ALA F 161       2.329 105.631  21.272  1.00 31.36           C  
ATOM  11203  C   ALA F 161       2.629 107.113  21.512  1.00 31.17           C  
ATOM  11204  O   ALA F 161       1.753 107.964  21.318  1.00 31.21           O  
ATOM  11205  CB  ALA F 161       2.026 104.936  22.571  1.00 31.15           C  
ATOM  11206  N   ASN F 162       3.858 107.405  21.942  1.00 30.49           N  
ATOM  11207  CA  ASN F 162       4.340 108.779  22.103  1.00 30.10           C  
ATOM  11208  C   ASN F 162       4.389 109.598  20.818  1.00 30.48           C  
ATOM  11209  O   ASN F 162       4.381 110.828  20.874  1.00 30.18           O  
ATOM  11210  CB  ASN F 162       5.690 108.820  22.810  1.00 29.50           C  
ATOM  11211  CG  ASN F 162       5.571 108.564  24.285  1.00 28.27           C  
ATOM  11212  OD1 ASN F 162       6.511 108.120  24.926  1.00 27.43           O  
ATOM  11213  ND2 ASN F 162       4.403 108.835  24.837  1.00 28.88           N  
ATOM  11214  N   GLU F 163       4.393 108.931  19.666  1.00 30.74           N  
ATOM  11215  CA  GLU F 163       4.346 109.675  18.408  1.00 31.75           C  
ATOM  11216  C   GLU F 163       2.987 110.307  18.244  1.00 31.94           C  
ATOM  11217  O   GLU F 163       2.874 111.396  17.685  1.00 31.84           O  
ATOM  11218  CB  GLU F 163       4.671 108.811  17.193  1.00 31.46           C  
ATOM  11219  CG  GLU F 163       6.112 108.477  17.082  1.00 33.04           C  
ATOM  11220  CD  GLU F 163       6.999 109.664  16.756  1.00 32.74           C  
ATOM  11221  OE1 GLU F 163       6.500 110.728  16.382  1.00 35.96           O  
ATOM  11222  OE2 GLU F 163       8.213 109.522  16.871  1.00 32.23           O  
ATOM  11223  N   MET F 164       1.971 109.605  18.743  1.00 32.46           N  
ATOM  11224  CA  MET F 164       0.624 110.133  18.849  1.00 32.48           C  
ATOM  11225  C   MET F 164       0.459 111.062  20.043  1.00 32.12           C  
ATOM  11226  O   MET F 164      -0.084 112.149  19.905  1.00 32.51           O  
ATOM  11227  CB  MET F 164      -0.389 108.994  18.918  1.00 32.26           C  
ATOM  11228  CG  MET F 164      -0.640 108.342  17.560  1.00 32.52           C  
ATOM  11229  SD  MET F 164      -2.107 107.315  17.591  1.00 34.19           S  
ATOM  11230  CE  MET F 164      -3.400 108.537  17.299  1.00 31.24           C  
ATOM  11231  N   LEU F 165       0.943 110.645  21.208  1.00 31.90           N  
ATOM  11232  CA  LEU F 165       0.682 111.375  22.451  1.00 31.81           C  
ATOM  11233  C   LEU F 165       1.476 112.682  22.563  1.00 32.00           C  
ATOM  11234  O   LEU F 165       0.900 113.704  22.933  1.00 31.92           O  
ATOM  11235  CB  LEU F 165       0.891 110.469  23.681  1.00 31.44           C  
ATOM  11236  CG  LEU F 165      -0.019 109.225  23.806  1.00 32.29           C  
ATOM  11237  CD1 LEU F 165       0.429 108.291  24.947  1.00 32.69           C  
ATOM  11238  CD2 LEU F 165      -1.526 109.595  23.941  1.00 29.39           C  
ATOM  11239  N   ILE F 166       2.778 112.638  22.247  1.00 31.87           N  
ATOM  11240  CA  ILE F 166       3.686 113.804  22.342  1.00 32.54           C  
ATOM  11241  C   ILE F 166       3.759 114.570  21.013  1.00 32.79           C  
ATOM  11242  O   ILE F 166       3.537 115.786  20.966  1.00 32.69           O  
ATOM  11243  CB  ILE F 166       5.170 113.387  22.726  1.00 32.99           C  
ATOM  11244  CG1 ILE F 166       5.234 112.410  23.912  1.00 33.61           C  
ATOM  11245  CG2 ILE F 166       6.055 114.592  22.953  1.00 32.96           C  
ATOM  11246  CD1 ILE F 166       4.748 112.950  25.231  1.00 36.52           C  
ATOM  11247  N   ALA F 167       4.072 113.840  19.937  1.00 32.69           N  
ATOM  11248  CA  ALA F 167       4.324 114.417  18.617  1.00 32.41           C  
ATOM  11249  C   ALA F 167       3.063 114.757  17.825  1.00 32.29           C  
ATOM  11250  O   ALA F 167       3.155 115.361  16.763  1.00 32.86           O  
ATOM  11251  CB  ALA F 167       5.207 113.479  17.809  1.00 32.25           C  
ATOM  11252  N   GLY F 168       1.898 114.348  18.321  1.00 32.42           N  
ATOM  11253  CA  GLY F 168       0.594 114.657  17.685  1.00 31.55           C  
ATOM  11254  C   GLY F 168       0.418 114.197  16.244  1.00 31.09           C  
ATOM  11255  O   GLY F 168      -0.214 114.886  15.443  1.00 30.21           O  
ATOM  11256  N   ARG F 169       0.965 113.022  15.923  1.00 30.99           N  
ATOM  11257  CA  ARG F 169       0.922 112.462  14.568  1.00 31.42           C  
ATOM  11258  C   ARG F 169      -0.438 111.862  14.225  1.00 31.31           C  
ATOM  11259  O   ARG F 169      -1.084 111.256  15.077  1.00 30.63           O  
ATOM  11260  CB  ARG F 169       2.020 111.402  14.382  1.00 32.10           C  
ATOM  11261  CG  ARG F 169       3.467 111.888  14.683  1.00 34.16           C  
ATOM  11262  CD  ARG F 169       4.035 112.817  13.620  1.00 38.33           C  
ATOM  11263  NE  ARG F 169       5.458 113.103  13.828  1.00 41.85           N  
ATOM  11264  CZ  ARG F 169       5.944 114.252  14.305  1.00 44.17           C  
ATOM  11265  NH1 ARG F 169       5.128 115.251  14.641  1.00 44.65           N  
ATOM  11266  NH2 ARG F 169       7.257 114.409  14.454  1.00 45.09           N  
ATOM  11267  N   LYS F 170      -0.872 112.062  12.978  1.00 31.44           N  
ATOM  11268  CA  LYS F 170      -2.118 111.494  12.472  1.00 31.95           C  
ATOM  11269  C   LYS F 170      -1.836 110.113  11.906  1.00 32.23           C  
ATOM  11270  O   LYS F 170      -0.707 109.819  11.493  1.00 32.24           O  
ATOM  11271  CB  LYS F 170      -2.747 112.356  11.371  1.00 31.69           C  
ATOM  11272  CG  LYS F 170      -3.081 113.778  11.744  1.00 32.47           C  
ATOM  11273  CD  LYS F 170      -3.740 114.506  10.567  1.00 32.84           C  
ATOM  11274  CE  LYS F 170      -4.043 115.964  10.908  1.00 34.14           C  
ATOM  11275  NZ  LYS F 170      -4.934 116.634   9.913  1.00 34.76           N  
ATOM  11276  N   LEU F 171      -2.879 109.287  11.872  1.00 31.91           N  
ATOM  11277  CA  LEU F 171      -2.814 107.925  11.387  1.00 32.13           C  
ATOM  11278  C   LEU F 171      -4.019 107.671  10.486  1.00 31.96           C  
ATOM  11279  O   LEU F 171      -5.161 107.868  10.911  1.00 31.70           O  
ATOM  11280  CB  LEU F 171      -2.920 106.961  12.576  1.00 32.69           C  
ATOM  11281  CG  LEU F 171      -1.762 106.152  13.175  1.00 32.46           C  
ATOM  11282  CD1 LEU F 171      -0.422 106.866  13.239  1.00 32.65           C  
ATOM  11283  CD2 LEU F 171      -2.198 105.687  14.531  1.00 33.13           C  
ATOM  11284  N   THR F 172      -3.774 107.190   9.267  1.00 31.40           N  
ATOM  11285  CA  THR F 172      -4.862 106.748   8.399  1.00 31.21           C  
ATOM  11286  C   THR F 172      -5.524 105.550   9.053  1.00 31.20           C  
ATOM  11287  O   THR F 172      -4.942 104.935   9.940  1.00 30.51           O  
ATOM  11288  CB  THR F 172      -4.357 106.308   6.992  1.00 31.31           C  
ATOM  11289  OG1 THR F 172      -3.596 105.090   7.090  1.00 29.64           O  
ATOM  11290  CG2 THR F 172      -3.519 107.412   6.323  1.00 31.07           C  
ATOM  11291  N   ALA F 173      -6.728 105.201   8.603  1.00 31.60           N  
ATOM  11292  CA  ALA F 173      -7.382 103.989   9.079  1.00 31.99           C  
ATOM  11293  C   ALA F 173      -6.463 102.762   8.981  1.00 32.22           C  
ATOM  11294  O   ALA F 173      -6.366 102.003   9.937  1.00 32.68           O  
ATOM  11295  CB  ALA F 173      -8.687 103.754   8.342  1.00 32.39           C  
ATOM  11296  N   ARG F 174      -5.784 102.580   7.846  1.00 32.61           N  
ATOM  11297  CA  ARG F 174      -4.849 101.455   7.659  1.00 32.62           C  
ATOM  11298  C   ARG F 174      -3.606 101.475   8.550  1.00 32.13           C  
ATOM  11299  O   ARG F 174      -3.146 100.424   8.975  1.00 32.19           O  
ATOM  11300  CB  ARG F 174      -4.444 101.302   6.189  1.00 33.30           C  
ATOM  11301  CG  ARG F 174      -5.328 100.319   5.425  1.00 34.42           C  
ATOM  11302  CD  ARG F 174      -5.264 100.510   3.918  1.00 36.70           C  
ATOM  11303  NE  ARG F 174      -6.467  99.974   3.277  1.00 38.91           N  
ATOM  11304  CZ  ARG F 174      -7.328 100.694   2.550  1.00 41.16           C  
ATOM  11305  NH1 ARG F 174      -7.118 101.993   2.339  1.00 40.93           N  
ATOM  11306  NH2 ARG F 174      -8.399 100.114   2.012  1.00 41.33           N  
ATOM  11307  N   GLU F 175      -3.061 102.656   8.831  1.00 31.82           N  
ATOM  11308  CA  GLU F 175      -1.981 102.781   9.820  1.00 31.40           C  
ATOM  11309  C   GLU F 175      -2.473 102.552  11.249  1.00 31.32           C  
ATOM  11310  O   GLU F 175      -1.764 101.960  12.056  1.00 30.94           O  
ATOM  11311  CB  GLU F 175      -1.286 104.145   9.739  1.00 31.37           C  
ATOM  11312  CG  GLU F 175      -0.598 104.440   8.415  1.00 31.36           C  
ATOM  11313  CD  GLU F 175      -0.378 105.931   8.190  1.00 32.37           C  
ATOM  11314  OE1 GLU F 175       0.414 106.294   7.296  1.00 33.29           O  
ATOM  11315  OE2 GLU F 175      -1.007 106.745   8.890  1.00 30.67           O  
ATOM  11316  N   ALA F 176      -3.671 103.043  11.566  1.00 31.29           N  
ATOM  11317  CA  ALA F 176      -4.235 102.862  12.906  1.00 31.33           C  
ATOM  11318  C   ALA F 176      -4.462 101.367  13.145  1.00 31.41           C  
ATOM  11319  O   ALA F 176      -4.091 100.838  14.193  1.00 31.05           O  
ATOM  11320  CB  ALA F 176      -5.534 103.686  13.099  1.00 30.53           C  
ATOM  11321  N   CYS F 177      -5.018 100.699  12.133  1.00 32.25           N  
ATOM  11322  CA  CYS F 177      -5.228  99.239  12.118  1.00 32.02           C  
ATOM  11323  C   CYS F 177      -3.944  98.406  12.333  1.00 31.88           C  
ATOM  11324  O   CYS F 177      -3.974  97.384  13.032  1.00 31.72           O  
ATOM  11325  CB  CYS F 177      -5.922  98.849  10.817  1.00 32.24           C  
ATOM  11326  SG  CYS F 177      -6.590  97.168  10.723  1.00 33.32           S  
ATOM  11327  N   ALA F 178      -2.825  98.857  11.754  1.00 31.19           N  
ATOM  11328  CA  ALA F 178      -1.529  98.172  11.869  1.00 30.78           C  
ATOM  11329  C   ALA F 178      -0.949  98.337  13.265  1.00 30.47           C  
ATOM  11330  O   ALA F 178      -0.197  97.500  13.761  1.00 29.84           O  
ATOM  11331  CB  ALA F 178      -0.568  98.716  10.851  1.00 30.72           C  
ATOM  11332  N   LYS F 179      -1.309  99.456  13.880  1.00 31.05           N  
ATOM  11333  CA  LYS F 179      -0.884  99.823  15.230  1.00 30.77           C  
ATOM  11334  C   LYS F 179      -1.858  99.324  16.299  1.00 30.07           C  
ATOM  11335  O   LYS F 179      -1.652  99.588  17.480  1.00 30.56           O  
ATOM  11336  CB  LYS F 179      -0.728 101.348  15.316  1.00 31.20           C  
ATOM  11337  CG  LYS F 179       0.513 101.892  14.579  1.00 32.40           C  
ATOM  11338  CD  LYS F 179       1.773 101.597  15.380  1.00 34.35           C  
ATOM  11339  CE  LYS F 179       2.949 101.224  14.496  1.00 35.79           C  
ATOM  11340  NZ  LYS F 179       4.083 100.771  15.359  1.00 36.36           N  
ATOM  11341  N   GLY F 180      -2.918  98.630  15.882  1.00 29.49           N  
ATOM  11342  CA  GLY F 180      -3.890  98.027  16.806  1.00 29.26           C  
ATOM  11343  C   GLY F 180      -5.070  98.893  17.232  1.00 28.95           C  
ATOM  11344  O   GLY F 180      -5.981  98.410  17.903  1.00 29.01           O  
ATOM  11345  N   LEU F 181      -5.072 100.164  16.829  1.00 28.74           N  
ATOM  11346  CA  LEU F 181      -6.111 101.111  17.250  1.00 28.51           C  
ATOM  11347  C   LEU F 181      -7.451 100.757  16.602  1.00 28.82           C  
ATOM  11348  O   LEU F 181      -8.511 100.871  17.226  1.00 28.85           O  
ATOM  11349  CB  LEU F 181      -5.689 102.558  16.922  1.00 28.36           C  
ATOM  11350  CG  LEU F 181      -6.617 103.723  17.322  1.00 28.71           C  
ATOM  11351  CD1 LEU F 181      -6.945 103.708  18.833  1.00 26.94           C  
ATOM  11352  CD2 LEU F 181      -6.038 105.084  16.899  1.00 27.49           C  
ATOM  11353  N   VAL F 182      -7.359 100.322  15.347  1.00 28.74           N  
ATOM  11354  CA  VAL F 182      -8.482  99.923  14.513  1.00 28.61           C  
ATOM  11355  C   VAL F 182      -8.351  98.424  14.267  1.00 28.76           C  
ATOM  11356  O   VAL F 182      -7.254  97.923  14.041  1.00 28.89           O  
ATOM  11357  CB  VAL F 182      -8.506 100.764  13.193  1.00 27.97           C  
ATOM  11358  CG1 VAL F 182      -9.319 100.100  12.104  1.00 28.42           C  
ATOM  11359  CG2 VAL F 182      -9.053 102.163  13.485  1.00 27.49           C  
ATOM  11360  N   SER F 183      -9.461  97.703  14.357  1.00 29.44           N  
ATOM  11361  CA  SER F 183      -9.419  96.249  14.210  1.00 30.31           C  
ATOM  11362  C   SER F 183      -9.880  95.742  12.841  1.00 31.04           C  
ATOM  11363  O   SER F 183      -9.545  94.621  12.448  1.00 31.70           O  
ATOM  11364  CB  SER F 183     -10.149  95.535  15.364  1.00 29.99           C  
ATOM  11365  OG  SER F 183     -11.508  95.919  15.510  1.00 29.35           O  
ATOM  11366  N   GLN F 184     -10.658  96.553  12.126  1.00 32.03           N  
ATOM  11367  CA  GLN F 184     -11.005  96.253  10.734  1.00 32.24           C  
ATOM  11368  C   GLN F 184     -11.213  97.506   9.889  1.00 32.38           C  
ATOM  11369  O   GLN F 184     -11.838  98.482  10.333  1.00 32.37           O  
ATOM  11370  CB  GLN F 184     -12.213  95.317  10.632  1.00 32.81           C  
ATOM  11371  CG  GLN F 184     -12.694  95.148   9.201  1.00 34.62           C  
ATOM  11372  CD  GLN F 184     -13.157  93.773   8.860  1.00 38.57           C  
ATOM  11373  OE1 GLN F 184     -12.421  92.794   9.042  1.00 41.75           O  
ATOM  11374  NE2 GLN F 184     -14.367  93.677   8.302  1.00 38.93           N  
ATOM  11375  N   VAL F 185     -10.691  97.464   8.665  1.00 32.44           N  
ATOM  11376  CA  VAL F 185     -10.862  98.555   7.714  1.00 32.64           C  
ATOM  11377  C   VAL F 185     -11.858  98.134   6.629  1.00 32.78           C  
ATOM  11378  O   VAL F 185     -11.822  96.994   6.165  1.00 32.54           O  
ATOM  11379  CB  VAL F 185      -9.504  98.975   7.094  1.00 32.89           C  
ATOM  11380  CG1 VAL F 185      -9.684 100.039   6.009  1.00 31.79           C  
ATOM  11381  CG2 VAL F 185      -8.555  99.472   8.193  1.00 32.88           C  
ATOM  11382  N   PHE F 186     -12.752  99.058   6.256  1.00 32.44           N  
ATOM  11383  CA  PHE F 186     -13.763  98.814   5.224  1.00 32.17           C  
ATOM  11384  C   PHE F 186     -13.631  99.772   4.053  1.00 32.52           C  
ATOM  11385  O   PHE F 186     -13.319 100.965   4.231  1.00 32.10           O  
ATOM  11386  CB  PHE F 186     -15.185  98.970   5.773  1.00 31.65           C  
ATOM  11387  CG  PHE F 186     -15.553  97.997   6.852  1.00 31.78           C  
ATOM  11388  CD1 PHE F 186     -16.613  97.130   6.675  1.00 31.82           C  
ATOM  11389  CD2 PHE F 186     -14.875  97.977   8.072  1.00 32.78           C  
ATOM  11390  CE1 PHE F 186     -16.991  96.250   7.684  1.00 31.06           C  
ATOM  11391  CE2 PHE F 186     -15.242  97.098   9.077  1.00 31.49           C  
ATOM  11392  CZ  PHE F 186     -16.299  96.235   8.880  1.00 31.52           C  
ATOM  11393  N   LEU F 187     -13.905  99.240   2.860  1.00 33.01           N  
ATOM  11394  CA  LEU F 187     -14.084 100.046   1.660  1.00 33.74           C  
ATOM  11395  C   LEU F 187     -15.198 101.053   1.906  1.00 34.35           C  
ATOM  11396  O   LEU F 187     -16.232 100.717   2.500  1.00 34.46           O  
ATOM  11397  CB  LEU F 187     -14.431  99.156   0.463  1.00 33.69           C  
ATOM  11398  CG  LEU F 187     -13.302  98.270  -0.097  1.00 34.02           C  
ATOM  11399  CD1 LEU F 187     -13.820  97.291  -1.159  1.00 33.00           C  
ATOM  11400  CD2 LEU F 187     -12.138  99.119  -0.639  1.00 34.03           C  
ATOM  11401  N   THR F 188     -14.982 102.287   1.461  1.00 35.08           N  
ATOM  11402  CA  THR F 188     -15.925 103.378   1.733  1.00 35.90           C  
ATOM  11403  C   THR F 188     -17.307 103.221   1.079  1.00 36.23           C  
ATOM  11404  O   THR F 188     -18.327 103.533   1.706  1.00 36.68           O  
ATOM  11405  CB  THR F 188     -15.324 104.779   1.405  1.00 36.00           C  
ATOM  11406  OG1 THR F 188     -16.245 105.798   1.818  1.00 36.34           O  
ATOM  11407  CG2 THR F 188     -15.012 104.931  -0.087  1.00 35.44           C  
ATOM  11408  N   GLY F 189     -17.333 102.745  -0.166  1.00 36.29           N  
ATOM  11409  CA  GLY F 189     -18.567 102.607  -0.935  1.00 36.31           C  
ATOM  11410  C   GLY F 189     -19.689 101.861  -0.229  1.00 36.25           C  
ATOM  11411  O   GLY F 189     -20.842 102.276  -0.301  1.00 36.22           O  
ATOM  11412  N   THR F 190     -19.346 100.770   0.450  1.00 35.99           N  
ATOM  11413  CA  THR F 190     -20.328  99.895   1.086  1.00 36.20           C  
ATOM  11414  C   THR F 190     -20.190  99.854   2.626  1.00 36.66           C  
ATOM  11415  O   THR F 190     -20.703  98.940   3.281  1.00 36.59           O  
ATOM  11416  CB  THR F 190     -20.226  98.461   0.527  1.00 35.92           C  
ATOM  11417  OG1 THR F 190     -18.848  98.081   0.443  1.00 35.70           O  
ATOM  11418  CG2 THR F 190     -20.871  98.360  -0.867  1.00 36.39           C  
ATOM  11419  N   PHE F 191     -19.517 100.859   3.186  1.00 36.99           N  
ATOM  11420  CA  PHE F 191     -19.205 100.924   4.603  1.00 37.26           C  
ATOM  11421  C   PHE F 191     -20.385 100.541   5.492  1.00 37.51           C  
ATOM  11422  O   PHE F 191     -20.325  99.548   6.210  1.00 37.35           O  
ATOM  11423  CB  PHE F 191     -18.648 102.309   4.964  1.00 37.44           C  
ATOM  11424  CG  PHE F 191     -18.141 102.423   6.392  1.00 37.74           C  
ATOM  11425  CD1 PHE F 191     -17.255 101.478   6.913  1.00 37.07           C  
ATOM  11426  CD2 PHE F 191     -18.549 103.485   7.211  1.00 37.91           C  
ATOM  11427  CE1 PHE F 191     -16.780 101.578   8.227  1.00 38.08           C  
ATOM  11428  CE2 PHE F 191     -18.079 103.598   8.535  1.00 37.21           C  
ATOM  11429  CZ  PHE F 191     -17.194 102.639   9.039  1.00 37.93           C  
ATOM  11430  N   THR F 192     -21.469 101.305   5.416  1.00 38.33           N  
ATOM  11431  CA  THR F 192     -22.607 101.112   6.331  1.00 39.00           C  
ATOM  11432  C   THR F 192     -23.405  99.805   6.142  1.00 39.61           C  
ATOM  11433  O   THR F 192     -23.953  99.269   7.110  1.00 39.99           O  
ATOM  11434  CB  THR F 192     -23.576 102.322   6.328  1.00 38.91           C  
ATOM  11435  OG1 THR F 192     -24.111 102.496   5.017  1.00 38.78           O  
ATOM  11436  CG2 THR F 192     -22.869 103.594   6.769  1.00 37.97           C  
ATOM  11437  N   GLN F 193     -23.478  99.290   4.917  1.00 40.22           N  
ATOM  11438  CA  GLN F 193     -24.133  98.005   4.708  1.00 40.89           C  
ATOM  11439  C   GLN F 193     -23.227  96.862   5.159  1.00 41.42           C  
ATOM  11440  O   GLN F 193     -23.704  95.861   5.700  1.00 41.44           O  
ATOM  11441  CB  GLN F 193     -24.655  97.813   3.262  1.00 40.87           C  
ATOM  11442  CG  GLN F 193     -23.745  98.319   2.142  1.00 41.41           C  
ATOM  11443  CD  GLN F 193     -24.004  99.778   1.754  1.00 40.94           C  
ATOM  11444  OE1 GLN F 193     -23.346 100.700   2.255  1.00 39.73           O  
ATOM  11445  NE2 GLN F 193     -24.955  99.989   0.847  1.00 40.78           N  
ATOM  11446  N   GLU F 194     -21.924  97.028   4.958  1.00 42.05           N  
ATOM  11447  CA  GLU F 194     -20.944  96.028   5.385  1.00 43.36           C  
ATOM  11448  C   GLU F 194     -20.897  95.963   6.923  1.00 42.83           C  
ATOM  11449  O   GLU F 194     -20.976  94.881   7.508  1.00 43.15           O  
ATOM  11450  CB  GLU F 194     -19.570  96.337   4.784  1.00 43.25           C  
ATOM  11451  CG  GLU F 194     -18.806  95.116   4.274  1.00 45.17           C  
ATOM  11452  CD  GLU F 194     -17.439  95.469   3.674  1.00 45.78           C  
ATOM  11453  OE1 GLU F 194     -17.357  96.488   2.924  1.00 48.62           O  
ATOM  11454  OE2 GLU F 194     -16.454  94.724   3.950  1.00 46.88           O  
ATOM  11455  N   VAL F 195     -20.798  97.124   7.569  1.00 42.48           N  
ATOM  11456  CA  VAL F 195     -20.982  97.220   9.019  1.00 42.21           C  
ATOM  11457  C   VAL F 195     -22.340  96.637   9.453  1.00 42.08           C  
ATOM  11458  O   VAL F 195     -22.408  95.842  10.381  1.00 42.00           O  
ATOM  11459  CB  VAL F 195     -20.811  98.692   9.532  1.00 42.18           C  
ATOM  11460  CG1 VAL F 195     -21.263  98.831  10.990  1.00 40.89           C  
ATOM  11461  CG2 VAL F 195     -19.361  99.149   9.374  1.00 42.33           C  
ATOM  11462  N   MET F 196     -23.416  97.023   8.778  1.00 42.21           N  
ATOM  11463  CA  MET F 196     -24.733  96.498   9.113  1.00 42.48           C  
ATOM  11464  C   MET F 196     -24.809  94.969   8.998  1.00 42.28           C  
ATOM  11465  O   MET F 196     -25.395  94.318   9.859  1.00 41.97           O  
ATOM  11466  CB  MET F 196     -25.820  97.187   8.283  1.00 42.91           C  
ATOM  11467  CG  MET F 196     -26.688  98.248   9.002  1.00 44.11           C  
ATOM  11468  SD  MET F 196     -26.219  98.828  10.654  1.00 50.42           S  
ATOM  11469  CE  MET F 196     -27.313  97.803  11.629  1.00 48.40           C  
ATOM  11470  N   ILE F 197     -24.200  94.390   7.962  1.00 42.63           N  
ATOM  11471  CA  ILE F 197     -24.254  92.926   7.794  1.00 42.91           C  
ATOM  11472  C   ILE F 197     -23.374  92.150   8.790  1.00 42.61           C  
ATOM  11473  O   ILE F 197     -23.744  91.046   9.202  1.00 42.66           O  
ATOM  11474  CB  ILE F 197     -24.031  92.439   6.326  1.00 42.99           C  
ATOM  11475  CG1 ILE F 197     -24.543  90.999   6.156  1.00 44.78           C  
ATOM  11476  CG2 ILE F 197     -22.576  92.505   5.922  1.00 43.30           C  
ATOM  11477  CD1 ILE F 197     -26.081  90.866   5.945  1.00 46.34           C  
ATOM  11478  N   GLN F 198     -22.234  92.728   9.177  1.00 42.05           N  
ATOM  11479  CA  GLN F 198     -21.360  92.116  10.178  1.00 41.52           C  
ATOM  11480  C   GLN F 198     -21.901  92.261  11.602  1.00 41.22           C  
ATOM  11481  O   GLN F 198     -21.763  91.345  12.413  1.00 41.03           O  
ATOM  11482  CB  GLN F 198     -19.937  92.659  10.076  1.00 41.32           C  
ATOM  11483  CG  GLN F 198     -19.143  92.084   8.927  1.00 41.76           C  
ATOM  11484  CD  GLN F 198     -17.682  92.483   8.967  1.00 42.44           C  
ATOM  11485  OE1 GLN F 198     -17.188  92.932   9.990  1.00 44.34           O  
ATOM  11486  NE2 GLN F 198     -16.986  92.329   7.844  1.00 42.58           N  
ATOM  11487  N   ILE F 199     -22.520  93.401  11.903  1.00 40.90           N  
ATOM  11488  CA  ILE F 199     -23.191  93.573  13.195  1.00 41.04           C  
ATOM  11489  C   ILE F 199     -24.330  92.563  13.418  1.00 40.81           C  
ATOM  11490  O   ILE F 199     -24.508  92.065  14.526  1.00 40.55           O  
ATOM  11491  CB  ILE F 199     -23.659  95.054  13.467  1.00 40.89           C  
ATOM  11492  CG1 ILE F 199     -23.535  95.390  14.951  1.00 41.12           C  
ATOM  11493  CG2 ILE F 199     -25.086  95.306  13.015  1.00 41.65           C  
ATOM  11494  CD1 ILE F 199     -22.145  95.920  15.340  1.00 41.15           C  
ATOM  11495  N   LYS F 200     -25.092  92.255  12.369  1.00 41.22           N  
ATOM  11496  CA  LYS F 200     -26.199  91.318  12.510  1.00 41.46           C  
ATOM  11497  C   LYS F 200     -25.688  89.891  12.671  1.00 41.41           C  
ATOM  11498  O   LYS F 200     -26.333  89.068  13.320  1.00 41.37           O  
ATOM  11499  CB  LYS F 200     -27.193  91.443  11.347  1.00 41.59           C  
ATOM  11500  CG  LYS F 200     -28.413  92.312  11.684  1.00 41.62           C  
ATOM  11501  CD  LYS F 200     -29.174  92.780  10.444  1.00 42.24           C  
ATOM  11502  CE  LYS F 200     -28.551  94.044   9.839  1.00 43.17           C  
ATOM  11503  NZ  LYS F 200     -29.502  94.747   8.930  1.00 43.34           N  
ATOM  11504  N   GLU F 201     -24.522  89.615  12.096  1.00 41.59           N  
ATOM  11505  CA  GLU F 201     -23.841  88.340  12.302  1.00 42.30           C  
ATOM  11506  C   GLU F 201     -23.445  88.148  13.769  1.00 42.33           C  
ATOM  11507  O   GLU F 201     -23.711  87.093  14.357  1.00 42.71           O  
ATOM  11508  CB  GLU F 201     -22.635  88.206  11.363  1.00 42.16           C  
ATOM  11509  CG  GLU F 201     -23.062  87.957   9.920  1.00 42.82           C  
ATOM  11510  CD  GLU F 201     -21.950  88.102   8.889  1.00 43.24           C  
ATOM  11511  OE1 GLU F 201     -22.159  87.649   7.735  1.00 44.91           O  
ATOM  11512  OE2 GLU F 201     -20.890  88.675   9.209  1.00 44.50           O  
ATOM  11513  N   LEU F 202     -22.841  89.177  14.362  1.00 42.24           N  
ATOM  11514  CA  LEU F 202     -22.467  89.150  15.784  1.00 42.32           C  
ATOM  11515  C   LEU F 202     -23.667  89.042  16.730  1.00 42.26           C  
ATOM  11516  O   LEU F 202     -23.583  88.389  17.764  1.00 42.55           O  
ATOM  11517  CB  LEU F 202     -21.604  90.366  16.151  1.00 42.08           C  
ATOM  11518  CG  LEU F 202     -20.231  90.366  15.480  1.00 42.30           C  
ATOM  11519  CD1 LEU F 202     -19.683  91.780  15.370  1.00 42.71           C  
ATOM  11520  CD2 LEU F 202     -19.239  89.411  16.174  1.00 41.28           C  
ATOM  11521  N   ALA F 203     -24.777  89.672  16.360  1.00 42.17           N  
ATOM  11522  CA  ALA F 203     -25.997  89.632  17.152  1.00 42.07           C  
ATOM  11523  C   ALA F 203     -26.679  88.256  17.151  1.00 42.18           C  
ATOM  11524  O   ALA F 203     -27.543  87.988  17.988  1.00 42.21           O  
ATOM  11525  CB  ALA F 203     -26.959  90.703  16.670  1.00 42.48           C  
ATOM  11526  N   SER F 204     -26.284  87.382  16.225  1.00 42.11           N  
ATOM  11527  CA  SER F 204     -26.866  86.042  16.136  1.00 41.87           C  
ATOM  11528  C   SER F 204     -26.161  85.028  17.044  1.00 41.46           C  
ATOM  11529  O   SER F 204     -26.631  83.909  17.210  1.00 41.54           O  
ATOM  11530  CB  SER F 204     -26.915  85.552  14.678  1.00 41.93           C  
ATOM  11531  OG  SER F 204     -25.625  85.230  14.188  1.00 42.56           O  
ATOM  11532  N   TYR F 205     -25.042  85.426  17.638  1.00 41.45           N  
ATOM  11533  CA  TYR F 205     -24.311  84.561  18.567  1.00 41.21           C  
ATOM  11534  C   TYR F 205     -24.967  84.485  19.955  1.00 41.08           C  
ATOM  11535  O   TYR F 205     -25.799  85.324  20.307  1.00 40.92           O  
ATOM  11536  CB  TYR F 205     -22.860  85.018  18.709  1.00 41.36           C  
ATOM  11537  CG  TYR F 205     -22.016  84.912  17.459  1.00 41.58           C  
ATOM  11538  CD1 TYR F 205     -22.044  83.769  16.652  1.00 41.81           C  
ATOM  11539  CD2 TYR F 205     -21.152  85.944  17.104  1.00 41.82           C  
ATOM  11540  CE1 TYR F 205     -21.250  83.679  15.500  1.00 42.54           C  
ATOM  11541  CE2 TYR F 205     -20.353  85.863  15.968  1.00 41.14           C  
ATOM  11542  CZ  TYR F 205     -20.399  84.737  15.176  1.00 42.52           C  
ATOM  11543  OH  TYR F 205     -19.598  84.680  14.054  1.00 42.99           O  
ATOM  11544  N   ASN F 206     -24.586  83.468  20.728  1.00 40.77           N  
ATOM  11545  CA  ASN F 206     -25.073  83.282  22.090  1.00 40.27           C  
ATOM  11546  C   ASN F 206     -24.719  84.491  22.951  1.00 40.31           C  
ATOM  11547  O   ASN F 206     -23.547  84.856  23.059  1.00 40.33           O  
ATOM  11548  CB  ASN F 206     -24.471  81.995  22.674  1.00 40.17           C  
ATOM  11549  CG  ASN F 206     -25.137  81.555  23.971  1.00 39.30           C  
ATOM  11550  OD1 ASN F 206     -26.242  81.023  23.967  1.00 39.80           O  
ATOM  11551  ND2 ASN F 206     -24.446  81.743  25.079  1.00 37.94           N  
ATOM  11552  N   ALA F 207     -25.735  85.112  23.550  1.00 40.38           N  
ATOM  11553  CA  ALA F 207     -25.559  86.298  24.405  1.00 40.19           C  
ATOM  11554  C   ALA F 207     -24.594  86.056  25.559  1.00 40.28           C  
ATOM  11555  O   ALA F 207     -23.759  86.914  25.864  1.00 40.84           O  
ATOM  11556  CB  ALA F 207     -26.897  86.784  24.938  1.00 40.36           C  
ATOM  11557  N   ILE F 208     -24.698  84.886  26.183  1.00 39.87           N  
ATOM  11558  CA  ILE F 208     -23.851  84.540  27.312  1.00 39.70           C  
ATOM  11559  C   ILE F 208     -22.394  84.338  26.861  1.00 39.75           C  
ATOM  11560  O   ILE F 208     -21.478  84.833  27.520  1.00 39.89           O  
ATOM  11561  CB  ILE F 208     -24.449  83.348  28.132  1.00 39.93           C  
ATOM  11562  CG1 ILE F 208     -25.793  83.770  28.748  1.00 39.39           C  
ATOM  11563  CG2 ILE F 208     -23.467  82.825  29.204  1.00 39.59           C  
ATOM  11564  CD1 ILE F 208     -26.570  82.671  29.442  1.00 39.80           C  
ATOM  11565  N   VAL F 209     -22.194  83.656  25.729  1.00 39.81           N  
ATOM  11566  CA  VAL F 209     -20.860  83.492  25.114  1.00 39.59           C  
ATOM  11567  C   VAL F 209     -20.226  84.871  24.851  1.00 39.65           C  
ATOM  11568  O   VAL F 209     -19.057  85.086  25.166  1.00 39.31           O  
ATOM  11569  CB  VAL F 209     -20.896  82.607  23.809  1.00 39.40           C  
ATOM  11570  CG1 VAL F 209     -19.525  82.555  23.122  1.00 39.59           C  
ATOM  11571  CG2 VAL F 209     -21.321  81.191  24.124  1.00 39.01           C  
ATOM  11572  N   LEU F 210     -21.023  85.798  24.315  1.00 39.89           N  
ATOM  11573  CA  LEU F 210     -20.588  87.175  24.067  1.00 40.06           C  
ATOM  11574  C   LEU F 210     -20.204  87.940  25.325  1.00 40.18           C  
ATOM  11575  O   LEU F 210     -19.119  88.522  25.363  1.00 39.88           O  
ATOM  11576  CB  LEU F 210     -21.632  87.954  23.250  1.00 39.91           C  
ATOM  11577  CG  LEU F 210     -21.752  87.606  21.760  1.00 39.50           C  
ATOM  11578  CD1 LEU F 210     -22.849  88.419  21.087  1.00 39.95           C  
ATOM  11579  CD2 LEU F 210     -20.443  87.781  21.021  1.00 39.00           C  
ATOM  11580  N   GLU F 211     -21.087  87.939  26.338  1.00 41.30           N  
ATOM  11581  CA  GLU F 211     -20.810  88.555  27.657  1.00 42.14           C  
ATOM  11582  C   GLU F 211     -19.600  87.922  28.343  1.00 41.60           C  
ATOM  11583  O   GLU F 211     -18.801  88.635  28.933  1.00 41.72           O  
ATOM  11584  CB  GLU F 211     -22.026  88.499  28.608  1.00 42.58           C  
ATOM  11585  CG  GLU F 211     -22.983  89.728  28.572  1.00 43.75           C  
ATOM  11586  CD  GLU F 211     -23.945  89.805  29.790  1.00 44.69           C  
ATOM  11587  OE1 GLU F 211     -25.198  89.833  29.590  1.00 46.72           O  
ATOM  11588  OE2 GLU F 211     -23.448  89.851  30.950  1.00 46.27           O  
ATOM  11589  N   GLU F 212     -19.466  86.595  28.248  1.00 41.47           N  
ATOM  11590  CA  GLU F 212     -18.329  85.882  28.841  1.00 41.77           C  
ATOM  11591  C   GLU F 212     -17.003  86.148  28.146  1.00 41.86           C  
ATOM  11592  O   GLU F 212     -15.983  86.314  28.824  1.00 42.01           O  
ATOM  11593  CB  GLU F 212     -18.586  84.369  28.956  1.00 42.19           C  
ATOM  11594  CG  GLU F 212     -19.599  83.963  30.064  1.00 43.69           C  
ATOM  11595  CD  GLU F 212     -19.115  84.220  31.502  1.00 46.52           C  
ATOM  11596  OE1 GLU F 212     -17.954  84.665  31.713  1.00 47.48           O  
ATOM  11597  OE2 GLU F 212     -19.908  83.948  32.439  1.00 47.32           O  
ATOM  11598  N   CYS F 213     -17.007  86.183  26.809  1.00 41.48           N  
ATOM  11599  CA  CYS F 213     -15.814  86.592  26.047  1.00 41.25           C  
ATOM  11600  C   CYS F 213     -15.309  87.944  26.527  1.00 40.22           C  
ATOM  11601  O   CYS F 213     -14.115  88.110  26.774  1.00 40.10           O  
ATOM  11602  CB  CYS F 213     -16.069  86.643  24.536  1.00 41.50           C  
ATOM  11603  SG  CYS F 213     -16.111  85.043  23.695  1.00 43.18           S  
ATOM  11604  N   LYS F 214     -16.228  88.894  26.676  1.00 39.23           N  
ATOM  11605  CA  LYS F 214     -15.874  90.247  27.091  1.00 37.97           C  
ATOM  11606  C   LYS F 214     -15.496  90.336  28.566  1.00 37.79           C  
ATOM  11607  O   LYS F 214     -14.568  91.070  28.910  1.00 38.44           O  
ATOM  11608  CB  LYS F 214     -16.976  91.239  26.742  1.00 37.79           C  
ATOM  11609  CG  LYS F 214     -16.945  92.493  27.579  1.00 36.15           C  
ATOM  11610  CD  LYS F 214     -17.518  93.668  26.871  1.00 34.91           C  
ATOM  11611  CE  LYS F 214     -16.735  94.918  27.249  1.00 34.62           C  
ATOM  11612  NZ  LYS F 214     -17.543  96.110  26.889  1.00 34.91           N  
ATOM  11613  N   ALA F 215     -16.206  89.599  29.420  1.00 36.79           N  
ATOM  11614  CA  ALA F 215     -15.909  89.552  30.854  1.00 36.47           C  
ATOM  11615  C   ALA F 215     -14.511  89.019  31.150  1.00 36.30           C  
ATOM  11616  O   ALA F 215     -13.800  89.565  32.008  1.00 36.41           O  
ATOM  11617  CB  ALA F 215     -16.966  88.719  31.614  1.00 36.04           C  
ATOM  11618  N   LEU F 216     -14.136  87.945  30.451  1.00 35.86           N  
ATOM  11619  CA  LEU F 216     -12.849  87.281  30.650  1.00 35.17           C  
ATOM  11620  C   LEU F 216     -11.670  88.126  30.209  1.00 35.26           C  
ATOM  11621  O   LEU F 216     -10.657  88.189  30.907  1.00 35.10           O  
ATOM  11622  CB  LEU F 216     -12.822  85.947  29.920  1.00 35.01           C  
ATOM  11623  CG  LEU F 216     -13.511  84.782  30.610  1.00 34.78           C  
ATOM  11624  CD1 LEU F 216     -13.840  83.699  29.603  1.00 35.49           C  
ATOM  11625  CD2 LEU F 216     -12.613  84.243  31.710  1.00 37.08           C  
ATOM  11626  N   VAL F 217     -11.808  88.760  29.042  1.00 34.85           N  
ATOM  11627  CA  VAL F 217     -10.830  89.728  28.533  1.00 34.68           C  
ATOM  11628  C   VAL F 217     -10.682  90.933  29.494  1.00 35.37           C  
ATOM  11629  O   VAL F 217      -9.578  91.431  29.724  1.00 35.39           O  
ATOM  11630  CB  VAL F 217     -11.205  90.198  27.080  1.00 34.34           C  
ATOM  11631  CG1 VAL F 217     -10.385  91.399  26.637  1.00 32.62           C  
ATOM  11632  CG2 VAL F 217     -11.048  89.045  26.075  1.00 33.35           C  
ATOM  11633  N   ARG F 218     -11.798  91.362  30.073  1.00 35.93           N  
ATOM  11634  CA  ARG F 218     -11.856  92.594  30.864  1.00 36.86           C  
ATOM  11635  C   ARG F 218     -11.312  92.482  32.308  1.00 37.07           C  
ATOM  11636  O   ARG F 218     -10.877  93.490  32.882  1.00 37.06           O  
ATOM  11637  CB  ARG F 218     -13.276  93.193  30.770  1.00 36.82           C  
ATOM  11638  CG  ARG F 218     -13.943  93.620  32.065  1.00 37.25           C  
ATOM  11639  CD  ARG F 218     -15.401  93.169  32.056  1.00 38.93           C  
ATOM  11640  NE  ARG F 218     -16.218  93.926  32.994  1.00 39.34           N  
ATOM  11641  CZ  ARG F 218     -16.783  95.094  32.713  1.00 40.93           C  
ATOM  11642  NH1 ARG F 218     -16.619  95.638  31.507  1.00 41.04           N  
ATOM  11643  NH2 ARG F 218     -17.517  95.720  33.637  1.00 40.79           N  
ATOM  11644  N   CYS F 219     -11.314  91.259  32.853  1.00 37.52           N  
ATOM  11645  CA  CYS F 219     -10.747  90.917  34.169  1.00 37.79           C  
ATOM  11646  C   CYS F 219      -9.449  91.637  34.520  1.00 37.95           C  
ATOM  11647  O   CYS F 219      -9.441  92.489  35.417  1.00 38.88           O  
ATOM  11648  CB  CYS F 219     -10.488  89.409  34.275  1.00 37.86           C  
ATOM  11649  SG  CYS F 219     -11.901  88.381  34.648  1.00 39.06           S  
ATOM  11650  N   ASN F 220      -8.355  91.288  33.835  1.00 37.56           N  
ATOM  11651  CA  ASN F 220      -7.027  91.778  34.212  1.00 37.34           C  
ATOM  11652  C   ASN F 220      -6.595  93.085  33.521  1.00 36.97           C  
ATOM  11653  O   ASN F 220      -5.390  93.386  33.445  1.00 37.01           O  
ATOM  11654  CB  ASN F 220      -5.955  90.679  34.047  1.00 37.96           C  
ATOM  11655  CG  ASN F 220      -5.531  90.482  32.597  1.00 38.59           C  
ATOM  11656  OD1 ASN F 220      -6.351  90.572  31.670  1.00 40.30           O  
ATOM  11657  ND2 ASN F 220      -4.244  90.223  32.397  1.00 38.38           N  
ATOM  11658  N   ILE F 221      -7.572  93.848  33.023  1.00 35.87           N  
ATOM  11659  CA  ILE F 221      -7.306  95.192  32.487  1.00 35.24           C  
ATOM  11660  C   ILE F 221      -8.169  96.278  33.148  1.00 34.20           C  
ATOM  11661  O   ILE F 221      -7.785  97.444  33.163  1.00 34.60           O  
ATOM  11662  CB  ILE F 221      -7.392  95.288  30.917  1.00 35.15           C  
ATOM  11663  CG1 ILE F 221      -8.834  95.132  30.409  1.00 36.45           C  
ATOM  11664  CG2 ILE F 221      -6.424  94.295  30.231  1.00 35.43           C  
ATOM  11665  CD1 ILE F 221      -9.098  95.742  28.985  1.00 35.16           C  
ATOM  11666  N   LYS F 222      -9.314  95.888  33.700  1.00 32.69           N  
ATOM  11667  CA  LYS F 222     -10.282  96.851  34.236  1.00 31.30           C  
ATOM  11668  C   LYS F 222      -9.719  97.796  35.319  1.00 30.08           C  
ATOM  11669  O   LYS F 222      -9.864  99.010  35.201  1.00 29.03           O  
ATOM  11670  CB  LYS F 222     -11.540  96.133  34.724  1.00 31.22           C  
ATOM  11671  CG  LYS F 222     -12.796  97.017  34.735  1.00 31.93           C  
ATOM  11672  CD  LYS F 222     -14.039  96.223  35.143  1.00 31.44           C  
ATOM  11673  CE  LYS F 222     -14.040  95.882  36.628  1.00 31.40           C  
ATOM  11674  NZ  LYS F 222     -14.643  96.964  37.453  1.00 32.39           N  
ATOM  11675  N   LEU F 223      -9.072  97.243  36.350  1.00 29.14           N  
ATOM  11676  CA  LEU F 223      -8.457  98.063  37.418  1.00 28.51           C  
ATOM  11677  C   LEU F 223      -7.344  99.007  36.909  1.00 27.60           C  
ATOM  11678  O   LEU F 223      -7.234 100.140  37.362  1.00 27.27           O  
ATOM  11679  CB  LEU F 223      -7.948  97.202  38.573  1.00 28.23           C  
ATOM  11680  CG  LEU F 223      -7.127  97.947  39.649  1.00 29.32           C  
ATOM  11681  CD1 LEU F 223      -7.972  98.935  40.498  1.00 30.00           C  
ATOM  11682  CD2 LEU F 223      -6.371  96.976  40.542  1.00 29.07           C  
ATOM  11683  N   GLU F 224      -6.541  98.537  35.957  1.00 26.94           N  
ATOM  11684  CA  GLU F 224      -5.591  99.394  35.239  1.00 26.37           C  
ATOM  11685  C   GLU F 224      -6.272 100.559  34.536  1.00 24.82           C  
ATOM  11686  O   GLU F 224      -5.762 101.668  34.540  1.00 24.93           O  
ATOM  11687  CB  GLU F 224      -4.859  98.598  34.178  1.00 26.60           C  
ATOM  11688  CG  GLU F 224      -3.659  97.870  34.673  1.00 30.83           C  
ATOM  11689  CD  GLU F 224      -3.336  96.700  33.774  1.00 36.29           C  
ATOM  11690  OE1 GLU F 224      -3.969  96.591  32.684  1.00 38.77           O  
ATOM  11691  OE2 GLU F 224      -2.460  95.894  34.156  1.00 36.39           O  
ATOM  11692  N   LEU F 225      -7.414 100.300  33.917  1.00 23.97           N  
ATOM  11693  CA  LEU F 225      -8.134 101.339  33.165  1.00 23.09           C  
ATOM  11694  C   LEU F 225      -8.765 102.348  34.110  1.00 23.19           C  
ATOM  11695  O   LEU F 225      -8.773 103.552  33.831  1.00 23.26           O  
ATOM  11696  CB  LEU F 225      -9.186 100.743  32.227  1.00 22.12           C  
ATOM  11697  CG  LEU F 225      -8.715  99.884  31.060  1.00 21.84           C  
ATOM  11698  CD1 LEU F 225      -9.883  99.110  30.481  1.00 19.95           C  
ATOM  11699  CD2 LEU F 225      -8.015 100.710  29.973  1.00 21.23           C  
ATOM  11700  N   GLU F 226      -9.287 101.848  35.228  1.00 22.99           N  
ATOM  11701  CA  GLU F 226      -9.863 102.694  36.258  1.00 22.91           C  
ATOM  11702  C   GLU F 226      -8.828 103.672  36.809  1.00 22.90           C  
ATOM  11703  O   GLU F 226      -9.078 104.871  36.884  1.00 22.24           O  
ATOM  11704  CB  GLU F 226     -10.471 101.826  37.366  1.00 22.99           C  
ATOM  11705  CG  GLU F 226     -11.698 101.074  36.882  1.00 23.54           C  
ATOM  11706  CD  GLU F 226     -12.310 100.159  37.916  1.00 24.00           C  
ATOM  11707  OE1 GLU F 226     -11.638  99.812  38.887  1.00 26.11           O  
ATOM  11708  OE2 GLU F 226     -13.480  99.770  37.745  1.00 25.50           O  
ATOM  11709  N   GLN F 227      -7.655 103.141  37.154  1.00 23.55           N  
ATOM  11710  CA  GLN F 227      -6.551 103.932  37.695  1.00 23.68           C  
ATOM  11711  C   GLN F 227      -5.989 104.944  36.718  1.00 23.18           C  
ATOM  11712  O   GLN F 227      -5.794 106.091  37.105  1.00 23.46           O  
ATOM  11713  CB  GLN F 227      -5.450 103.023  38.232  1.00 24.19           C  
ATOM  11714  CG  GLN F 227      -6.020 101.826  38.964  1.00 27.68           C  
ATOM  11715  CD  GLN F 227      -4.989 101.048  39.746  1.00 32.70           C  
ATOM  11716  OE1 GLN F 227      -4.465 100.022  39.276  1.00 33.37           O  
ATOM  11717  NE2 GLN F 227      -4.687 101.528  40.958  1.00 35.16           N  
ATOM  11718  N   ALA F 228      -5.747 104.539  35.464  1.00 22.85           N  
ATOM  11719  CA  ALA F 228      -5.314 105.474  34.404  1.00 22.96           C  
ATOM  11720  C   ALA F 228      -6.296 106.630  34.255  1.00 23.60           C  
ATOM  11721  O   ALA F 228      -5.885 107.769  34.098  1.00 24.65           O  
ATOM  11722  CB  ALA F 228      -5.169 104.765  33.080  1.00 22.32           C  
ATOM  11723  N   ASN F 229      -7.589 106.322  34.298  1.00 23.24           N  
ATOM  11724  CA  ASN F 229      -8.636 107.316  34.174  1.00 23.27           C  
ATOM  11725  C   ASN F 229      -8.552 108.314  35.331  1.00 23.56           C  
ATOM  11726  O   ASN F 229      -8.477 109.527  35.100  1.00 23.69           O  
ATOM  11727  CB  ASN F 229     -10.015 106.617  34.130  1.00 22.74           C  
ATOM  11728  CG  ASN F 229     -11.172 107.583  33.825  1.00 22.57           C  
ATOM  11729  OD1 ASN F 229     -10.991 108.622  33.192  1.00 21.07           O  
ATOM  11730  ND2 ASN F 229     -12.363 107.228  34.277  1.00 21.48           N  
ATOM  11731  N   GLU F 230      -8.566 107.780  36.561  1.00 23.76           N  
ATOM  11732  CA  GLU F 230      -8.373 108.541  37.803  1.00 24.24           C  
ATOM  11733  C   GLU F 230      -7.093 109.394  37.764  1.00 23.94           C  
ATOM  11734  O   GLU F 230      -7.123 110.567  38.125  1.00 24.33           O  
ATOM  11735  CB  GLU F 230      -8.329 107.598  39.019  1.00 23.78           C  
ATOM  11736  CG  GLU F 230      -9.663 106.902  39.363  1.00 25.13           C  
ATOM  11737  CD  GLU F 230      -9.493 105.602  40.169  1.00 25.63           C  
ATOM  11738  OE1 GLU F 230     -10.512 105.040  40.632  1.00 29.69           O  
ATOM  11739  OE2 GLU F 230      -8.349 105.139  40.371  1.00 27.69           O  
ATOM  11740  N   ARG F 231      -5.983 108.810  37.320  1.00 23.80           N  
ATOM  11741  CA  ARG F 231      -4.709 109.531  37.261  1.00 24.40           C  
ATOM  11742  C   ARG F 231      -4.700 110.638  36.220  1.00 24.47           C  
ATOM  11743  O   ARG F 231      -4.192 111.725  36.478  1.00 25.27           O  
ATOM  11744  CB  ARG F 231      -3.557 108.580  36.993  1.00 24.71           C  
ATOM  11745  CG  ARG F 231      -3.290 107.587  38.097  1.00 26.52           C  
ATOM  11746  CD  ARG F 231      -1.872 107.079  37.979  1.00 32.24           C  
ATOM  11747  NE  ARG F 231      -1.765 105.650  38.280  1.00 35.40           N  
ATOM  11748  CZ  ARG F 231      -1.883 104.683  37.367  1.00 38.19           C  
ATOM  11749  NH1 ARG F 231      -2.109 104.973  36.074  1.00 37.18           N  
ATOM  11750  NH2 ARG F 231      -1.767 103.414  37.745  1.00 39.12           N  
ATOM  11751  N   GLU F 232      -5.267 110.365  35.047  1.00 24.22           N  
ATOM  11752  CA  GLU F 232      -5.301 111.333  33.957  1.00 23.93           C  
ATOM  11753  C   GLU F 232      -6.146 112.531  34.365  1.00 24.08           C  
ATOM  11754  O   GLU F 232      -5.768 113.669  34.128  1.00 23.74           O  
ATOM  11755  CB  GLU F 232      -5.883 110.695  32.695  1.00 23.68           C  
ATOM  11756  CG  GLU F 232      -4.951 109.723  31.977  1.00 23.73           C  
ATOM  11757  CD  GLU F 232      -5.615 109.021  30.795  1.00 24.76           C  
ATOM  11758  OE1 GLU F 232      -6.864 109.099  30.627  1.00 26.02           O  
ATOM  11759  OE2 GLU F 232      -4.880 108.382  30.027  1.00 25.10           O  
ATOM  11760  N   CYS F 233      -7.285 112.252  34.987  1.00 24.13           N  
ATOM  11761  CA  CYS F 233      -8.244 113.275  35.387  1.00 24.92           C  
ATOM  11762  C   CYS F 233      -7.690 114.197  36.480  1.00 25.17           C  
ATOM  11763  O   CYS F 233      -7.800 115.411  36.377  1.00 25.21           O  
ATOM  11764  CB  CYS F 233      -9.563 112.616  35.793  1.00 24.53           C  
ATOM  11765  SG  CYS F 233     -10.496 112.067  34.323  1.00 26.65           S  
ATOM  11766  N   GLU F 234      -7.053 113.621  37.493  1.00 25.15           N  
ATOM  11767  CA  GLU F 234      -6.334 114.411  38.467  1.00 25.93           C  
ATOM  11768  C   GLU F 234      -5.348 115.406  37.841  1.00 25.65           C  
ATOM  11769  O   GLU F 234      -5.332 116.582  38.213  1.00 25.53           O  
ATOM  11770  CB  GLU F 234      -5.665 113.505  39.487  1.00 26.23           C  
ATOM  11771  CG  GLU F 234      -6.645 113.087  40.572  1.00 28.93           C  
ATOM  11772  CD  GLU F 234      -6.495 111.637  41.005  1.00 32.69           C  
ATOM  11773  OE1 GLU F 234      -7.529 111.041  41.391  1.00 34.02           O  
ATOM  11774  OE2 GLU F 234      -5.360 111.096  40.960  1.00 33.53           O  
ATOM  11775  N   VAL F 235      -4.562 114.940  36.871  1.00 25.58           N  
ATOM  11776  CA  VAL F 235      -3.628 115.807  36.152  1.00 25.38           C  
ATOM  11777  C   VAL F 235      -4.319 116.911  35.327  1.00 25.71           C  
ATOM  11778  O   VAL F 235      -3.856 118.048  35.326  1.00 26.20           O  
ATOM  11779  CB  VAL F 235      -2.649 114.982  35.296  1.00 25.69           C  
ATOM  11780  CG1 VAL F 235      -1.783 115.893  34.450  1.00 24.78           C  
ATOM  11781  CG2 VAL F 235      -1.766 114.091  36.211  1.00 24.28           C  
ATOM  11782  N   LEU F 236      -5.433 116.580  34.669  1.00 25.65           N  
ATOM  11783  CA  LEU F 236      -6.203 117.515  33.856  1.00 25.98           C  
ATOM  11784  C   LEU F 236      -6.907 118.579  34.695  1.00 26.84           C  
ATOM  11785  O   LEU F 236      -7.137 119.700  34.224  1.00 27.00           O  
ATOM  11786  CB  LEU F 236      -7.263 116.768  33.043  1.00 25.64           C  
ATOM  11787  CG  LEU F 236      -6.817 115.892  31.877  1.00 25.41           C  
ATOM  11788  CD1 LEU F 236      -7.902 114.866  31.441  1.00 21.08           C  
ATOM  11789  CD2 LEU F 236      -6.333 116.769  30.694  1.00 26.52           C  
ATOM  11790  N   ARG F 237      -7.264 118.231  35.930  1.00 27.08           N  
ATOM  11791  CA  ARG F 237      -7.887 119.201  36.809  1.00 27.87           C  
ATOM  11792  C   ARG F 237      -6.867 120.274  37.228  1.00 27.74           C  
ATOM  11793  O   ARG F 237      -7.234 121.425  37.391  1.00 27.78           O  
ATOM  11794  CB  ARG F 237      -8.543 118.521  38.022  1.00 27.87           C  
ATOM  11795  CG  ARG F 237      -7.804 118.720  39.335  1.00 29.59           C  
ATOM  11796  CD  ARG F 237      -8.538 119.637  40.319  1.00 32.88           C  
ATOM  11797  NE  ARG F 237      -9.183 120.813  39.713  1.00 35.00           N  
ATOM  11798  CZ  ARG F 237      -9.636 121.863  40.405  1.00 33.89           C  
ATOM  11799  NH1 ARG F 237     -10.206 122.881  39.773  1.00 34.04           N  
ATOM  11800  NH2 ARG F 237      -9.511 121.905  41.725  1.00 34.51           N  
ATOM  11801  N   LYS F 238      -5.599 119.898  37.386  1.00 27.45           N  
ATOM  11802  CA  LYS F 238      -4.586 120.880  37.731  1.00 28.14           C  
ATOM  11803  C   LYS F 238      -4.060 121.706  36.547  1.00 27.68           C  
ATOM  11804  O   LYS F 238      -3.708 122.874  36.723  1.00 27.67           O  
ATOM  11805  CB  LYS F 238      -3.459 120.293  38.585  1.00 28.45           C  
ATOM  11806  CG  LYS F 238      -2.711 119.121  38.025  1.00 30.58           C  
ATOM  11807  CD  LYS F 238      -1.973 118.411  39.176  1.00 33.46           C  
ATOM  11808  CE  LYS F 238      -0.635 117.841  38.741  1.00 33.72           C  
ATOM  11809  NZ  LYS F 238       0.236 118.891  38.089  1.00 34.47           N  
ATOM  11810  N   ILE F 239      -4.060 121.116  35.356  1.00 27.22           N  
ATOM  11811  CA  ILE F 239      -3.738 121.835  34.131  1.00 27.54           C  
ATOM  11812  C   ILE F 239      -4.853 122.821  33.745  1.00 27.44           C  
ATOM  11813  O   ILE F 239      -4.583 124.010  33.553  1.00 28.15           O  
ATOM  11814  CB  ILE F 239      -3.362 120.869  32.940  1.00 27.13           C  
ATOM  11815  CG1 ILE F 239      -1.946 120.319  33.116  1.00 28.40           C  
ATOM  11816  CG2 ILE F 239      -3.454 121.598  31.603  1.00 27.67           C  
ATOM  11817  CD1 ILE F 239      -1.626 119.051  32.287  1.00 28.18           C  
ATOM  11818  N   TRP F 240      -6.095 122.338  33.651  1.00 27.12           N  
ATOM  11819  CA  TRP F 240      -7.232 123.177  33.268  1.00 26.53           C  
ATOM  11820  C   TRP F 240      -7.606 124.261  34.286  1.00 26.86           C  
ATOM  11821  O   TRP F 240      -8.278 125.226  33.930  1.00 27.24           O  
ATOM  11822  CB  TRP F 240      -8.456 122.324  32.874  1.00 26.60           C  
ATOM  11823  CG  TRP F 240      -8.265 121.591  31.528  1.00 26.55           C  
ATOM  11824  CD1 TRP F 240      -7.460 121.985  30.498  1.00 25.41           C  
ATOM  11825  CD2 TRP F 240      -8.868 120.354  31.110  1.00 25.40           C  
ATOM  11826  NE1 TRP F 240      -7.529 121.089  29.472  1.00 25.37           N  
ATOM  11827  CE2 TRP F 240      -8.385 120.075  29.816  1.00 26.58           C  
ATOM  11828  CE3 TRP F 240      -9.782 119.462  31.700  1.00 26.15           C  
ATOM  11829  CZ2 TRP F 240      -8.780 118.935  29.091  1.00 25.53           C  
ATOM  11830  CZ3 TRP F 240     -10.180 118.336  30.986  1.00 24.57           C  
ATOM  11831  CH2 TRP F 240      -9.670 118.078  29.698  1.00 27.09           C  
ATOM  11832  N   SER F 241      -7.189 124.122  35.542  1.00 26.06           N  
ATOM  11833  CA  SER F 241      -7.381 125.216  36.491  1.00 25.86           C  
ATOM  11834  C   SER F 241      -6.172 126.148  36.589  1.00 25.72           C  
ATOM  11835  O   SER F 241      -6.182 127.090  37.383  1.00 26.08           O  
ATOM  11836  CB  SER F 241      -7.790 124.716  37.880  1.00 25.26           C  
ATOM  11837  OG  SER F 241      -6.867 123.785  38.373  1.00 24.84           O  
ATOM  11838  N   SER F 242      -5.144 125.889  35.781  1.00 25.55           N  
ATOM  11839  CA  SER F 242      -3.936 126.716  35.793  1.00 24.99           C  
ATOM  11840  C   SER F 242      -3.984 127.822  34.752  1.00 25.14           C  
ATOM  11841  O   SER F 242      -4.713 127.732  33.750  1.00 24.15           O  
ATOM  11842  CB  SER F 242      -2.672 125.873  35.601  1.00 24.68           C  
ATOM  11843  OG  SER F 242      -2.546 125.432  34.259  1.00 24.72           O  
ATOM  11844  N   ALA F 243      -3.183 128.861  35.003  1.00 25.60           N  
ATOM  11845  CA  ALA F 243      -3.063 129.991  34.105  1.00 26.24           C  
ATOM  11846  C   ALA F 243      -2.515 129.555  32.742  1.00 26.79           C  
ATOM  11847  O   ALA F 243      -3.062 129.957  31.707  1.00 27.28           O  
ATOM  11848  CB  ALA F 243      -2.201 131.094  34.732  1.00 26.13           C  
ATOM  11849  N   GLN F 244      -1.476 128.716  32.726  1.00 27.05           N  
ATOM  11850  CA  GLN F 244      -0.927 128.255  31.442  1.00 27.94           C  
ATOM  11851  C   GLN F 244      -1.860 127.354  30.628  1.00 27.57           C  
ATOM  11852  O   GLN F 244      -1.879 127.457  29.402  1.00 27.40           O  
ATOM  11853  CB  GLN F 244       0.499 127.664  31.530  1.00 28.02           C  
ATOM  11854  CG  GLN F 244       0.966 127.093  32.861  1.00 28.70           C  
ATOM  11855  CD  GLN F 244       2.468 126.771  32.840  1.00 29.57           C  
ATOM  11856  OE1 GLN F 244       3.287 127.434  33.509  1.00 29.95           O  
ATOM  11857  NE2 GLN F 244       2.837 125.761  32.049  1.00 30.25           N  
ATOM  11858  N   GLY F 245      -2.622 126.498  31.311  1.00 27.41           N  
ATOM  11859  CA  GLY F 245      -3.505 125.523  30.658  1.00 27.68           C  
ATOM  11860  C   GLY F 245      -4.683 126.184  29.969  1.00 27.86           C  
ATOM  11861  O   GLY F 245      -5.082 125.783  28.872  1.00 27.49           O  
ATOM  11862  N   ILE F 246      -5.245 127.192  30.633  1.00 28.56           N  
ATOM  11863  CA  ILE F 246      -6.287 128.059  30.059  1.00 29.03           C  
ATOM  11864  C   ILE F 246      -5.765 128.827  28.837  1.00 28.59           C  
ATOM  11865  O   ILE F 246      -6.456 128.929  27.826  1.00 28.24           O  
ATOM  11866  CB  ILE F 246      -6.790 129.089  31.093  1.00 29.24           C  
ATOM  11867  CG1 ILE F 246      -7.369 128.381  32.320  1.00 30.85           C  
ATOM  11868  CG2 ILE F 246      -7.795 130.061  30.461  1.00 29.42           C  
ATOM  11869  CD1 ILE F 246      -8.777 127.920  32.169  1.00 31.26           C  
ATOM  11870  N   GLU F 247      -4.557 129.376  28.970  1.00 28.53           N  
ATOM  11871  CA  GLU F 247      -3.907 130.160  27.934  1.00 28.95           C  
ATOM  11872  C   GLU F 247      -3.661 129.257  26.728  1.00 27.96           C  
ATOM  11873  O   GLU F 247      -3.994 129.628  25.600  1.00 27.85           O  
ATOM  11874  CB  GLU F 247      -2.597 130.756  28.480  1.00 28.97           C  
ATOM  11875  CG  GLU F 247      -1.744 131.581  27.498  1.00 30.79           C  
ATOM  11876  CD  GLU F 247      -0.291 131.819  28.001  1.00 31.73           C  
ATOM  11877  OE1 GLU F 247       0.346 132.826  27.576  1.00 34.16           O  
ATOM  11878  OE2 GLU F 247       0.221 130.997  28.812  1.00 34.22           O  
ATOM  11879  N   SER F 248      -3.114 128.065  26.994  1.00 26.81           N  
ATOM  11880  CA  SER F 248      -2.873 127.030  25.994  1.00 25.74           C  
ATOM  11881  C   SER F 248      -4.124 126.672  25.210  1.00 24.94           C  
ATOM  11882  O   SER F 248      -4.067 126.540  23.993  1.00 24.46           O  
ATOM  11883  CB  SER F 248      -2.353 125.757  26.668  1.00 26.03           C  
ATOM  11884  OG  SER F 248      -1.010 125.880  27.103  1.00 26.55           O  
ATOM  11885  N   MET F 249      -5.236 126.468  25.926  1.00 24.44           N  
ATOM  11886  CA  MET F 249      -6.534 126.167  25.322  1.00 23.66           C  
ATOM  11887  C   MET F 249      -7.039 127.348  24.475  1.00 24.39           C  
ATOM  11888  O   MET F 249      -7.536 127.161  23.355  1.00 24.47           O  
ATOM  11889  CB  MET F 249      -7.552 125.784  26.404  1.00 23.57           C  
ATOM  11890  CG  MET F 249      -8.911 125.320  25.876  1.00 22.11           C  
ATOM  11891  SD  MET F 249     -10.094 124.833  27.161  1.00 22.46           S  
ATOM  11892  CE  MET F 249      -9.190 123.505  27.965  1.00 19.46           C  
ATOM  11893  N   LEU F 250      -6.884 128.553  25.006  1.00 24.71           N  
ATOM  11894  CA  LEU F 250      -7.250 129.781  24.302  1.00 25.84           C  
ATOM  11895  C   LEU F 250      -6.489 129.895  22.987  1.00 26.11           C  
ATOM  11896  O   LEU F 250      -7.077 130.076  21.916  1.00 25.61           O  
ATOM  11897  CB  LEU F 250      -6.934 131.006  25.172  1.00 25.92           C  
ATOM  11898  CG  LEU F 250      -7.944 131.533  26.188  1.00 27.63           C  
ATOM  11899  CD1 LEU F 250      -7.218 132.388  27.236  1.00 30.38           C  
ATOM  11900  CD2 LEU F 250      -9.047 132.351  25.501  1.00 27.27           C  
ATOM  11901  N   LYS F 251      -5.171 129.781  23.104  1.00 26.88           N  
ATOM  11902  CA  LYS F 251      -4.244 129.879  21.993  1.00 27.75           C  
ATOM  11903  C   LYS F 251      -4.615 128.870  20.899  1.00 27.76           C  
ATOM  11904  O   LYS F 251      -4.652 129.211  19.713  1.00 27.90           O  
ATOM  11905  CB  LYS F 251      -2.812 129.646  22.523  1.00 27.97           C  
ATOM  11906  CG  LYS F 251      -1.679 130.126  21.625  1.00 30.00           C  
ATOM  11907  CD  LYS F 251      -1.361 129.158  20.487  1.00 33.40           C  
ATOM  11908  CE  LYS F 251      -0.782 127.825  20.989  1.00 35.35           C  
ATOM  11909  NZ  LYS F 251      -0.654 126.794  19.900  1.00 36.21           N  
ATOM  11910  N   TYR F 252      -4.897 127.636  21.310  1.00 28.05           N  
ATOM  11911  CA  TYR F 252      -5.304 126.580  20.391  1.00 28.62           C  
ATOM  11912  C   TYR F 252      -6.592 126.924  19.612  1.00 29.16           C  
ATOM  11913  O   TYR F 252      -6.653 126.728  18.401  1.00 29.18           O  
ATOM  11914  CB  TYR F 252      -5.434 125.226  21.116  1.00 28.00           C  
ATOM  11915  CG  TYR F 252      -6.188 124.214  20.296  1.00 27.78           C  
ATOM  11916  CD1 TYR F 252      -5.540 123.456  19.328  1.00 26.10           C  
ATOM  11917  CD2 TYR F 252      -7.569 124.056  20.448  1.00 27.97           C  
ATOM  11918  CE1 TYR F 252      -6.227 122.558  18.548  1.00 26.74           C  
ATOM  11919  CE2 TYR F 252      -8.270 123.154  19.665  1.00 27.82           C  
ATOM  11920  CZ  TYR F 252      -7.590 122.409  18.721  1.00 27.73           C  
ATOM  11921  OH  TYR F 252      -8.276 121.498  17.955  1.00 28.81           O  
ATOM  11922  N   VAL F 253      -7.605 127.431  20.308  1.00 29.98           N  
ATOM  11923  CA  VAL F 253      -8.902 127.748  19.689  1.00 31.29           C  
ATOM  11924  C   VAL F 253      -8.807 128.914  18.693  1.00 33.08           C  
ATOM  11925  O   VAL F 253      -9.420 128.878  17.621  1.00 33.21           O  
ATOM  11926  CB  VAL F 253     -10.003 128.019  20.769  1.00 31.18           C  
ATOM  11927  CG1 VAL F 253     -11.273 128.626  20.163  1.00 29.37           C  
ATOM  11928  CG2 VAL F 253     -10.330 126.736  21.517  1.00 29.11           C  
ATOM  11929  N   GLU F 254      -8.040 129.940  19.056  1.00 34.95           N  
ATOM  11930  CA  GLU F 254      -7.838 131.108  18.206  1.00 37.12           C  
ATOM  11931  C   GLU F 254      -7.104 130.751  16.925  1.00 38.07           C  
ATOM  11932  O   GLU F 254      -7.378 131.319  15.886  1.00 38.32           O  
ATOM  11933  CB  GLU F 254      -7.089 132.203  18.969  1.00 37.18           C  
ATOM  11934  CG  GLU F 254      -8.016 133.255  19.596  1.00 39.17           C  
ATOM  11935  CD  GLU F 254      -7.497 133.797  20.924  1.00 40.75           C  
ATOM  11936  OE1 GLU F 254      -8.324 134.242  21.757  1.00 41.60           O  
ATOM  11937  OE2 GLU F 254      -6.265 133.766  21.142  1.00 41.13           O  
ATOM  11938  N   ASN F 255      -6.172 129.808  17.018  1.00 39.55           N  
ATOM  11939  CA  ASN F 255      -5.453 129.306  15.866  1.00 41.14           C  
ATOM  11940  C   ASN F 255      -6.328 128.409  14.996  1.00 42.09           C  
ATOM  11941  O   ASN F 255      -6.292 128.512  13.765  1.00 42.37           O  
ATOM  11942  CB  ASN F 255      -4.199 128.545  16.306  1.00 41.43           C  
ATOM  11943  CG  ASN F 255      -3.082 129.466  16.779  1.00 42.56           C  
ATOM  11944  OD1 ASN F 255      -3.328 130.542  17.338  1.00 43.65           O  
ATOM  11945  ND2 ASN F 255      -1.841 129.040  16.561  1.00 43.20           N  
ATOM  11946  N   LYS F 256      -7.104 127.533  15.635  1.00 42.76           N  
ATOM  11947  CA  LYS F 256      -7.938 126.577  14.923  1.00 43.70           C  
ATOM  11948  C   LYS F 256      -8.921 127.305  14.017  1.00 44.13           C  
ATOM  11949  O   LYS F 256      -9.158 126.878  12.890  1.00 44.46           O  
ATOM  11950  CB  LYS F 256      -8.685 125.658  15.903  1.00 43.66           C  
ATOM  11951  CG  LYS F 256      -9.359 124.455  15.249  1.00 44.00           C  
ATOM  11952  CD  LYS F 256     -10.327 123.747  16.210  1.00 44.07           C  
ATOM  11953  CE  LYS F 256     -11.006 122.533  15.564  1.00 44.38           C  
ATOM  11954  NZ  LYS F 256     -11.895 122.885  14.406  1.00 44.44           N  
ATOM  11955  N   ILE F 257      -9.485 128.404  14.520  1.00 44.62           N  
ATOM  11956  CA  ILE F 257     -10.456 129.209  13.784  1.00 44.87           C  
ATOM  11957  C   ILE F 257      -9.806 130.092  12.698  1.00 45.17           C  
ATOM  11958  O   ILE F 257     -10.457 130.436  11.705  1.00 45.25           O  
ATOM  11959  CB  ILE F 257     -11.302 130.055  14.760  1.00 44.98           C  
ATOM  11960  N   ASP F 258      -8.528 130.433  12.887  1.00 45.33           N  
ATOM  11961  CA  ASP F 258      -7.776 131.314  11.970  1.00 45.58           C  
ATOM  11962  C   ASP F 258      -7.216 130.623  10.710  1.00 45.94           C  
ATOM  11963  O   ASP F 258      -6.005 130.424  10.577  1.00 45.97           O  
ATOM  11964  CB  ASP F 258      -6.659 132.055  12.720  1.00 45.31           C  
ATOM  11965  CG  ASP F 258      -5.885 133.018  11.826  1.00 44.85           C  
ATOM  11966  OD1 ASP F 258      -4.670 133.164  12.039  1.00 43.19           O  
ATOM  11967  OD2 ASP F 258      -6.479 133.615  10.901  1.00 45.15           O  
ATOM  11968  N   GLU F 259      -8.116 130.277   9.790  1.00 46.30           N  
ATOM  11969  CA  GLU F 259      -7.777 129.682   8.501  1.00 45.93           C  
ATOM  11970  C   GLU F 259      -8.873 130.003   7.492  1.00 45.75           C  
ATOM  11971  O   GLU F 259      -9.974 130.402   7.874  1.00 45.76           O  
ATOM  11972  N   PHE F 260      -8.562 129.855   6.206  1.00 45.43           N  
ATOM  11973  CA  PHE F 260      -9.538 130.060   5.141  1.00 45.08           C  
ATOM  11974  C   PHE F 260     -10.327 128.770   4.886  1.00 45.07           C  
ATOM  11975  O   PHE F 260      -9.964 127.690   5.368  1.00 44.54           O  
ATOM  11976  CB  PHE F 260      -8.862 130.519   3.843  1.00 45.02           C  
ATOM  11977  CG  PHE F 260      -8.157 131.863   3.937  1.00 45.03           C  
ATOM  11978  CD1 PHE F 260      -6.769 131.931   4.006  1.00 44.36           C  
ATOM  11979  CD2 PHE F 260      -8.880 133.058   3.925  1.00 45.48           C  
ATOM  11980  CE1 PHE F 260      -6.102 133.168   4.077  1.00 44.66           C  
ATOM  11981  CE2 PHE F 260      -8.221 134.301   3.998  1.00 45.48           C  
ATOM  11982  CZ  PHE F 260      -6.828 134.350   4.075  1.00 44.61           C  
TER   11983      PHE F 260                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
