
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  260 ( 1975),  selected  260 , name 1dub_A
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 1dub_A.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A    31_A      -       -           -
LGA    N    32_A      -       -           -
LGA    F    33_A      P      32          4.529
LGA    Q    34_A      R      33          1.542
LGA    Y    35_A      P      34          0.442
LGA    I    36_A      T      35          1.132
LGA    I    37_A      S      36          1.448
LGA    T    38_A      A      37          1.105
LGA    E    39_A      R      38          1.692
LGA    K    40_A      Q      39          1.966
LGA    K    41_A      L      40          3.794
LGA    G    42_A      -       -           -
LGA    K    43_A      -       -           -
LGA    N    44_A      -       -           -
LGA    S    45_A      D      41          1.654
LGA    S    46_A      G      42          1.496
LGA    V    47_A      I      43          0.690
LGA    G    48_A      R      44          0.521
LGA    L    49_A      N      45          0.521
LGA    I    50_A      I      46          0.642
LGA    Q    51_A      V      47          0.422
LGA    L    52_A      L      48          0.287
LGA    N    53_A      S      49          0.284
LGA    R    54_A      N      50          0.434
LGA    P    55_A      P      51          0.227
LGA    K    56_A      K      52          0.864
LGA    A    57_A      K      53          1.122
LGA    L    58_A      R      54          0.616
LGA    N    59_A      N      55          0.357
LGA    A    60_A      T      56          0.421
LGA    L    61_A      L      57          0.419
LGA    C    62_A      S      58          0.737
LGA    N    63_A      L      59          0.940
LGA    G    64_A      A      60          0.850
LGA    L    65_A      M      61          0.898
LGA    I    66_A      L      62          1.013
LGA    E    67_A      K      63          0.842
LGA    E    68_A      S      64          0.868
LGA    L    69_A      L      65          0.781
LGA    N    70_A      Q      66          1.068
LGA    Q    71_A      S      67          1.069
LGA    A    72_A      D      68          0.774
LGA    L    73_A      I      69          0.753
LGA    E    74_A      L      70          1.205
LGA    T    75_A      H      71          1.745
LGA    F    76_A      D      72          5.078
LGA    E    77_A      A      73          1.792
LGA    E    78_A      D      74          3.595
LGA    D    79_A      S      75          3.462
LGA    P    80_A      N      76          2.404
LGA    A    81_A      D      77          1.618
LGA    V    82_A      L      78          1.836
LGA    G    83_A      K      79          0.197
LGA    A    84_A      V      80          0.202
LGA    I    85_A      I      81          0.491
LGA    V    86_A      I      82          0.338
LGA    L    87_A      I      83          0.363
LGA    T    88_A      S      84          0.378
LGA    G    89_A      A      85          0.731
LGA    G    90_A      E      86          2.415
LGA    E    91_A      G      87          3.805
LGA    K    92_A      P      88          0.555
LGA    A    93_A      V      89          1.479
LGA    F    94_A      F      90          1.381
LGA    A    95_A      S      91          0.910
LGA    A    96_A      S      92          0.940
LGA    G    97_A      G      93          0.603
LGA    A    98_A      H      94          1.140
LGA    D    99_A      D      95          1.320
LGA    I   100_A      L      96          1.181
LGA    K   101_A      K      97          1.403
LGA    E   102_A      E      98          1.177
LGA    M   103_A      L      99          1.364
LGA    Q   104_A      T     100          1.992
LGA    N   105_A      E     101          2.824
LGA    -       -      E     102           -
LGA    R   106_A      Q     103          4.468
LGA    T   107_A      G     104          4.560
LGA    F   108_A      R     105          4.715
LGA    Q   109_A      -       -           -
LGA    D   110_A      D     106          2.643
LGA    C   111_A      -       -           -
LGA    Y   112_A      -       -           -
LGA    S   113_A      -       -           -
LGA    G   114_A      -       -           -
LGA    K   115_A      Y     107           #
LGA    -       -      H     108           -
LGA    -       -      A     109           -
LGA    F   116_A      E     110          2.642
LGA    L   117_A      V     111          3.410
LGA    -       -      F     112           -
LGA    S   118_A      Q     113          1.944
LGA    H   119_A      T     114          2.129
LGA    W   120_A      C     115          1.606
LGA    D   121_A      S     116          3.334
LGA    H   122_A      K     117          3.519
LGA    I   123_A      V     118          3.890
LGA    -       -      M     119           -
LGA    T   124_A      M     120          2.749
LGA    R   125_A      H     121          2.621
LGA    -       -      I     122           -
LGA    -       -      R     123           -
LGA    -       -      N     124           -
LGA    I   126_A      H     125          1.695
LGA    K   127_A      P     126          1.574
LGA    K   128_A      V     127          0.730
LGA    P   129_A      P     128          0.532
LGA    V   130_A      V     129          0.352
LGA    I   131_A      I     130          0.159
LGA    A   132_A      A     131          0.270
LGA    A   133_A      M     132          0.266
LGA    V   134_A      V     133          0.931
LGA    N   135_A      N     134          1.041
LGA    G   136_A      G     135          0.621
LGA    Y   137_A      L     136          1.040
LGA    A   138_A      A     137          1.006
LGA    L   139_A      T     138          0.681
LGA    G   140_A      A     139          0.526
LGA    G   141_A      A     140          0.499
LGA    G   142_A      G     141          0.500
LGA    C   143_A      C     142          0.606
LGA    E   144_A      Q     143          0.541
LGA    L   145_A      L     144          0.870
LGA    A   146_A      V     145          1.001
LGA    M   147_A      A     146          1.266
LGA    M   148_A      S     147          1.273
LGA    C   149_A      C     148          0.807
LGA    D   150_A      D     149          0.543
LGA    I   151_A      I     150          0.561
LGA    I   152_A      A     151          0.663
LGA    Y   153_A      V     152          0.540
LGA    A   154_A      A     153          0.772
LGA    G   155_A      S     154          1.055
LGA    E   156_A      D     155          1.264
LGA    K   157_A      K     156          1.050
LGA    A   158_A      S     157          0.842
LGA    Q   159_A      S     158          0.840
LGA    F   160_A      F     159          0.781
LGA    G   161_A      A     160          1.092
LGA    Q   162_A      T     161          0.682
LGA    P   163_A      P     162          0.919
LGA    E   164_A      G     163          1.266
LGA    I   165_A      V     164          1.610
LGA    L   166_A      N     165          1.520
LGA    L   167_A      V     166          1.758
LGA    G   168_A      G     167          1.368
LGA    T   169_A      L     168          1.953
LGA    I   170_A      F     169          2.307
LGA    P   171_A      C     170          2.421
LGA    G   172_A      S     171          4.336
LGA    A   173_A      T     172          3.354
LGA    G   174_A      -       -           -
LGA    G   175_A      P     173          2.063
LGA    T   176_A      G     174          1.658
LGA    Q   177_A      V     175          2.413
LGA    R   178_A      A     176          2.350
LGA    L   179_A      L     177          1.213
LGA    T   180_A      A     178          1.884
LGA    R   181_A      R     179          2.445
LGA    A   182_A      A     180          1.979
LGA    V   183_A      V     181          1.055
LGA    G   184_A      P     182          0.418
LGA    K   185_A      R     183          0.684
LGA    S   186_A      K     184          0.396
LGA    L   187_A      V     185          0.408
LGA    A   188_A      A     186          0.310
LGA    M   189_A      L     187          0.438
LGA    E   190_A      E     188          0.269
LGA    M   191_A      M     189          0.313
LGA    V   192_A      L     190          0.656
LGA    L   193_A      F     191          0.720
LGA    T   194_A      T     192          0.671
LGA    G   195_A      G     193          0.834
LGA    D   196_A      E     194          0.902
LGA    R   197_A      P     195          0.526
LGA    I   198_A      I     196          0.374
LGA    S   199_A      S     197          0.332
LGA    A   200_A      A     198          0.455
LGA    Q   201_A      Q     199          0.221
LGA    D   202_A      E     200          0.295
LGA    A   203_A      A     201          0.399
LGA    K   204_A      L     202          0.251
LGA    Q   205_A      L     203          0.633
LGA    A   206_A      H     204          0.554
LGA    G   207_A      G     205          1.158
LGA    L   208_A      L     206          0.846
LGA    V   209_A      L     207          0.383
LGA    S   210_A      S     208          1.018
LGA    K   211_A      K     209          0.289
LGA    I   212_A      V     210          0.674
LGA    F   213_A      V     211          1.789
LGA    P   214_A      P     212          1.864
LGA    V   215_A      E     213          1.826
LGA    E   216_A      A     214          3.438
LGA    T   217_A      E     215          3.180
LGA    L   218_A      L     216          1.425
LGA    V   219_A      Q     217          2.910
LGA    E   220_A      E     218          3.192
LGA    E   221_A      E     219          1.995
LGA    A   222_A      T     220          1.163
LGA    I   223_A      M     221          2.239
LGA    Q   224_A      R     222          2.213
LGA    C   225_A      I     223          0.753
LGA    A   226_A      A     224          1.088
LGA    E   227_A      R     225          1.127
LGA    K   228_A      K     226          0.584
LGA    I   229_A      I     227          0.721
LGA    A   230_A      A     228          1.295
LGA    N   231_A      S     229          1.086
LGA    N   232_A      L     230          0.922
LGA    S   233_A      S     231          0.927
LGA    K   234_A      R     232          0.727
LGA    I   235_A      P     233          1.083
LGA    I   236_A      V     234          0.949
LGA    V   237_A      V     235          0.489
LGA    A   238_A      S     236          0.851
LGA    M   239_A      L     237          1.262
LGA    A   240_A      G     238          1.126
LGA    K   241_A      K     239          1.088
LGA    E   242_A      A     240          1.529
LGA    S   243_A      T     241          2.359
LGA    V   244_A      F     242          2.405
LGA    N   245_A      Y     243          1.894
LGA    A   246_A      K     244          2.900
LGA    A   247_A      Q     245          4.860
LGA    F   248_A      L     246          4.124
LGA    E   249_A      P     247          2.734
LGA    M   250_A      Q     248          2.218
LGA    T   251_A      D     249          2.401
LGA    L   252_A      L     250          2.743
LGA    T   253_A      G     251          2.620
LGA    E   254_A      T     252          2.009
LGA    G   255_A      A     253          2.212
LGA    N   256_A      Y     254          2.369
LGA    K   257_A      Y     255          1.967
LGA    L   258_A      L     256          1.733
LGA    E   259_A      T     257          1.501
LGA    K   260_A      S     258          1.469
LGA    K   261_A      Q     259          1.847
LGA    L   262_A      A     260          1.372
LGA    F   263_A      M     261          1.266
LGA    Y   264_A      V     262          1.461
LGA    S   265_A      D     263          1.181
LGA    T   266_A      N     264          0.429
LGA    F   267_A      L     265          1.747
LGA    A   268_A      A     266          2.122
LGA    T   269_A      L     267          0.676
LGA    D   270_A      R     268          0.169
LGA    D   271_A      D     269          0.338
LGA    R   272_A      G     270          0.191
LGA    R   273_A      Q     271          0.451
LGA    E   274_A      E     272          0.318
LGA    G   275_A      G     273          0.416
LGA    M   276_A      I     274          0.312
LGA    S   277_A      T     275          0.332
LGA    A   278_A      A     276          0.533
LGA    F   279_A      F     277          0.619
LGA    V   280_A      L     278          0.475
LGA    E   281_A      Q     279          0.621
LGA    K   282_A      K     280          0.695
LGA    R   283_A      R     281          0.420
LGA    K   284_A      K     282          0.323
LGA    A   285_A      P     283          0.663
LGA    N   286_A      V     284          0.934
LGA    F   287_A      W     285          0.998
LGA    K   288_A      S     286          1.218
LGA    D   289_A      H     287          1.245
LGA    H   290_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  260  256    5.0    247    1.69    29.55     88.038    13.799

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.925664 * X  +   0.341105 * Y  +  -0.163690 * Z  + -73.621826
  Y_new =   0.166189 * X  +   0.022099 * Y  +   0.985846 * Z  + -70.492416
  Z_new =   0.339894 * X  +  -0.939765 * Y  +  -0.036232 * Z  + 107.195541 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.609331    1.532262  [ DEG:   -92.2079     87.7921 ]
  Theta =  -0.346805   -2.794788  [ DEG:   -19.8704   -160.1296 ]
  Phi   =   0.177643   -2.963950  [ DEG:    10.1782   -169.8218 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1dub_A                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1dub_A.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  260  256   5.0  247   1.69   29.55  88.038
REMARK  ---------------------------------------------------------- 
MOLECULE 1dub_A
HEADER    LYASE                                   10-JUN-96   1DUB              
TITLE     2-ENOYL-COA HYDRATASE, DATA COLLECTED AT 100 K, PH 6.5                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 2-ENOYL-COA HYDRATASE;                                     
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 SYNONYM: CROTONASE, ENOYL-COA HYDRATASE 1;                           
COMPND   5 EC: 4.2.1.17                                                         
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 ORGAN: LIVER                                                         
KEYWDS    BETA-OXIDATION, COA, CROTONASE, ENOYL-COA HYDRATASE, FATTY            
KEYWDS   2 ACID METABOLISM, LYASE                                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.K.WIERENGA,C.K.ENGEL                                                
REVDAT   1   07-JUL-97 1DUB    0                                                
JRNL        AUTH   C.K.ENGEL,M.MATHIEU,J.P.ZEELEN,J.K.HILTUNEN,                 
JRNL        AUTH 2 R.K.WIERENGA                                                 
JRNL        TITL   CRYSTAL STRUCTURE OF ENOYL-COENZYME A (COA)                  
JRNL        TITL 2 HYDRATASE AT 2.5 ANGSTROMS RESOLUTION: A SPIRAL              
JRNL        TITL 3 FOLD DEFINES THE COA-BINDING POCKET.                         
JRNL        REF    EMBO J.                       V.  15  5135 1996              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1DUB A   30   290  UNP    P14604   ECHM_RAT        30    290             
DBREF  1DUB B   30   290  UNP    P14604   ECHM_RAT        30    290             
DBREF  1DUB C   30   290  UNP    P14604   ECHM_RAT        30    290             
DBREF  1DUB D   30   290  UNP    P14604   ECHM_RAT        30    290             
DBREF  1DUB E   30   290  UNP    P14604   ECHM_RAT        30    290             
DBREF  1DUB F   30   290  UNP    P14604   ECHM_RAT        30    290             
SEQRES   1 A  261  GLY ALA ASN PHE GLN TYR ILE ILE THR GLU LYS LYS GLY          
SEQRES   2 A  261  LYS ASN SER SER VAL GLY LEU ILE GLN LEU ASN ARG PRO          
SEQRES   3 A  261  LYS ALA LEU ASN ALA LEU CYS ASN GLY LEU ILE GLU GLU          
SEQRES   4 A  261  LEU ASN GLN ALA LEU GLU THR PHE GLU GLU ASP PRO ALA          
SEQRES   5 A  261  VAL GLY ALA ILE VAL LEU THR GLY GLY GLU LYS ALA PHE          
SEQRES   6 A  261  ALA ALA GLY ALA ASP ILE LYS GLU MET GLN ASN ARG THR          
SEQRES   7 A  261  PHE GLN ASP CYS TYR SER GLY LYS PHE LEU SER HIS TRP          
SEQRES   8 A  261  ASP HIS ILE THR ARG ILE LYS LYS PRO VAL ILE ALA ALA          
SEQRES   9 A  261  VAL ASN GLY TYR ALA LEU GLY GLY GLY CYS GLU LEU ALA          
SEQRES  10 A  261  MET MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN          
SEQRES  11 A  261  PHE GLY GLN PRO GLU ILE LEU LEU GLY THR ILE PRO GLY          
SEQRES  12 A  261  ALA GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS          
SEQRES  13 A  261  SER LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE          
SEQRES  14 A  261  SER ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS          
SEQRES  15 A  261  ILE PHE PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN          
SEQRES  16 A  261  CYS ALA GLU LYS ILE ALA ASN ASN SER LYS ILE ILE VAL          
SEQRES  17 A  261  ALA MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET          
SEQRES  18 A  261  THR LEU THR GLU GLY ASN LYS LEU GLU LYS LYS LEU PHE          
SEQRES  19 A  261  TYR SER THR PHE ALA THR ASP ASP ARG ARG GLU GLY MET          
SEQRES  20 A  261  SER ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP          
SEQRES  21 A  261  HIS                                                          
SEQRES   1 B  261  GLY ALA ASN PHE GLN TYR ILE ILE THR GLU LYS LYS GLY          
SEQRES   2 B  261  LYS ASN SER SER VAL GLY LEU ILE GLN LEU ASN ARG PRO          
SEQRES   3 B  261  LYS ALA LEU ASN ALA LEU CYS ASN GLY LEU ILE GLU GLU          
SEQRES   4 B  261  LEU ASN GLN ALA LEU GLU THR PHE GLU GLU ASP PRO ALA          
SEQRES   5 B  261  VAL GLY ALA ILE VAL LEU THR GLY GLY GLU LYS ALA PHE          
SEQRES   6 B  261  ALA ALA GLY ALA ASP ILE LYS GLU MET GLN ASN ARG THR          
SEQRES   7 B  261  PHE GLN ASP CYS TYR SER GLY LYS PHE LEU SER HIS TRP          
SEQRES   8 B  261  ASP HIS ILE THR ARG ILE LYS LYS PRO VAL ILE ALA ALA          
SEQRES   9 B  261  VAL ASN GLY TYR ALA LEU GLY GLY GLY CYS GLU LEU ALA          
SEQRES  10 B  261  MET MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN          
SEQRES  11 B  261  PHE GLY GLN PRO GLU ILE LEU LEU GLY THR ILE PRO GLY          
SEQRES  12 B  261  ALA GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS          
SEQRES  13 B  261  SER LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE          
SEQRES  14 B  261  SER ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS          
SEQRES  15 B  261  ILE PHE PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN          
SEQRES  16 B  261  CYS ALA GLU LYS ILE ALA ASN ASN SER LYS ILE ILE VAL          
SEQRES  17 B  261  ALA MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET          
SEQRES  18 B  261  THR LEU THR GLU GLY ASN LYS LEU GLU LYS LYS LEU PHE          
SEQRES  19 B  261  TYR SER THR PHE ALA THR ASP ASP ARG ARG GLU GLY MET          
SEQRES  20 B  261  SER ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP          
SEQRES  21 B  261  HIS                                                          
SEQRES   1 C  261  GLY ALA ASN PHE GLN TYR ILE ILE THR GLU LYS LYS GLY          
SEQRES   2 C  261  LYS ASN SER SER VAL GLY LEU ILE GLN LEU ASN ARG PRO          
SEQRES   3 C  261  LYS ALA LEU ASN ALA LEU CYS ASN GLY LEU ILE GLU GLU          
SEQRES   4 C  261  LEU ASN GLN ALA LEU GLU THR PHE GLU GLU ASP PRO ALA          
SEQRES   5 C  261  VAL GLY ALA ILE VAL LEU THR GLY GLY GLU LYS ALA PHE          
SEQRES   6 C  261  ALA ALA GLY ALA ASP ILE LYS GLU MET GLN ASN ARG THR          
SEQRES   7 C  261  PHE GLN ASP CYS TYR SER GLY LYS PHE LEU SER HIS TRP          
SEQRES   8 C  261  ASP HIS ILE THR ARG ILE LYS LYS PRO VAL ILE ALA ALA          
SEQRES   9 C  261  VAL ASN GLY TYR ALA LEU GLY GLY GLY CYS GLU LEU ALA          
SEQRES  10 C  261  MET MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN          
SEQRES  11 C  261  PHE GLY GLN PRO GLU ILE LEU LEU GLY THR ILE PRO GLY          
SEQRES  12 C  261  ALA GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS          
SEQRES  13 C  261  SER LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE          
SEQRES  14 C  261  SER ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS          
SEQRES  15 C  261  ILE PHE PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN          
SEQRES  16 C  261  CYS ALA GLU LYS ILE ALA ASN ASN SER LYS ILE ILE VAL          
SEQRES  17 C  261  ALA MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET          
SEQRES  18 C  261  THR LEU THR GLU GLY ASN LYS LEU GLU LYS LYS LEU PHE          
SEQRES  19 C  261  TYR SER THR PHE ALA THR ASP ASP ARG ARG GLU GLY MET          
SEQRES  20 C  261  SER ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP          
SEQRES  21 C  261  HIS                                                          
SEQRES   1 D  261  GLY ALA ASN PHE GLN TYR ILE ILE THR GLU LYS LYS GLY          
SEQRES   2 D  261  LYS ASN SER SER VAL GLY LEU ILE GLN LEU ASN ARG PRO          
SEQRES   3 D  261  LYS ALA LEU ASN ALA LEU CYS ASN GLY LEU ILE GLU GLU          
SEQRES   4 D  261  LEU ASN GLN ALA LEU GLU THR PHE GLU GLU ASP PRO ALA          
SEQRES   5 D  261  VAL GLY ALA ILE VAL LEU THR GLY GLY GLU LYS ALA PHE          
SEQRES   6 D  261  ALA ALA GLY ALA ASP ILE LYS GLU MET GLN ASN ARG THR          
SEQRES   7 D  261  PHE GLN ASP CYS TYR SER GLY LYS PHE LEU SER HIS TRP          
SEQRES   8 D  261  ASP HIS ILE THR ARG ILE LYS LYS PRO VAL ILE ALA ALA          
SEQRES   9 D  261  VAL ASN GLY TYR ALA LEU GLY GLY GLY CYS GLU LEU ALA          
SEQRES  10 D  261  MET MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN          
SEQRES  11 D  261  PHE GLY GLN PRO GLU ILE LEU LEU GLY THR ILE PRO GLY          
SEQRES  12 D  261  ALA GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS          
SEQRES  13 D  261  SER LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE          
SEQRES  14 D  261  SER ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS          
SEQRES  15 D  261  ILE PHE PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN          
SEQRES  16 D  261  CYS ALA GLU LYS ILE ALA ASN ASN SER LYS ILE ILE VAL          
SEQRES  17 D  261  ALA MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET          
SEQRES  18 D  261  THR LEU THR GLU GLY ASN LYS LEU GLU LYS LYS LEU PHE          
SEQRES  19 D  261  TYR SER THR PHE ALA THR ASP ASP ARG ARG GLU GLY MET          
SEQRES  20 D  261  SER ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP          
SEQRES  21 D  261  HIS                                                          
SEQRES   1 E  261  GLY ALA ASN PHE GLN TYR ILE ILE THR GLU LYS LYS GLY          
SEQRES   2 E  261  LYS ASN SER SER VAL GLY LEU ILE GLN LEU ASN ARG PRO          
SEQRES   3 E  261  LYS ALA LEU ASN ALA LEU CYS ASN GLY LEU ILE GLU GLU          
SEQRES   4 E  261  LEU ASN GLN ALA LEU GLU THR PHE GLU GLU ASP PRO ALA          
SEQRES   5 E  261  VAL GLY ALA ILE VAL LEU THR GLY GLY GLU LYS ALA PHE          
SEQRES   6 E  261  ALA ALA GLY ALA ASP ILE LYS GLU MET GLN ASN ARG THR          
SEQRES   7 E  261  PHE GLN ASP CYS TYR SER GLY LYS PHE LEU SER HIS TRP          
SEQRES   8 E  261  ASP HIS ILE THR ARG ILE LYS LYS PRO VAL ILE ALA ALA          
SEQRES   9 E  261  VAL ASN GLY TYR ALA LEU GLY GLY GLY CYS GLU LEU ALA          
SEQRES  10 E  261  MET MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN          
SEQRES  11 E  261  PHE GLY GLN PRO GLU ILE LEU LEU GLY THR ILE PRO GLY          
SEQRES  12 E  261  ALA GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS          
SEQRES  13 E  261  SER LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE          
SEQRES  14 E  261  SER ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS          
SEQRES  15 E  261  ILE PHE PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN          
SEQRES  16 E  261  CYS ALA GLU LYS ILE ALA ASN ASN SER LYS ILE ILE VAL          
SEQRES  17 E  261  ALA MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET          
SEQRES  18 E  261  THR LEU THR GLU GLY ASN LYS LEU GLU LYS LYS LEU PHE          
SEQRES  19 E  261  TYR SER THR PHE ALA THR ASP ASP ARG ARG GLU GLY MET          
SEQRES  20 E  261  SER ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP          
SEQRES  21 E  261  HIS                                                          
SEQRES   1 F  261  GLY ALA ASN PHE GLN TYR ILE ILE THR GLU LYS LYS GLY          
SEQRES   2 F  261  LYS ASN SER SER VAL GLY LEU ILE GLN LEU ASN ARG PRO          
SEQRES   3 F  261  LYS ALA LEU ASN ALA LEU CYS ASN GLY LEU ILE GLU GLU          
SEQRES   4 F  261  LEU ASN GLN ALA LEU GLU THR PHE GLU GLU ASP PRO ALA          
SEQRES   5 F  261  VAL GLY ALA ILE VAL LEU THR GLY GLY GLU LYS ALA PHE          
SEQRES   6 F  261  ALA ALA GLY ALA ASP ILE LYS GLU MET GLN ASN ARG THR          
SEQRES   7 F  261  PHE GLN ASP CYS TYR SER GLY LYS PHE LEU SER HIS TRP          
SEQRES   8 F  261  ASP HIS ILE THR ARG ILE LYS LYS PRO VAL ILE ALA ALA          
SEQRES   9 F  261  VAL ASN GLY TYR ALA LEU GLY GLY GLY CYS GLU LEU ALA          
SEQRES  10 F  261  MET MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN          
SEQRES  11 F  261  PHE GLY GLN PRO GLU ILE LEU LEU GLY THR ILE PRO GLY          
SEQRES  12 F  261  ALA GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS          
SEQRES  13 F  261  SER LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE          
SEQRES  14 F  261  SER ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS          
SEQRES  15 F  261  ILE PHE PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN          
SEQRES  16 F  261  CYS ALA GLU LYS ILE ALA ASN ASN SER LYS ILE ILE VAL          
SEQRES  17 F  261  ALA MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET          
SEQRES  18 F  261  THR LEU THR GLU GLY ASN LYS LEU GLU LYS LYS LEU PHE          
SEQRES  19 F  261  TYR SER THR PHE ALA THR ASP ASP ARG ARG GLU GLY MET          
SEQRES  20 F  261  SER ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP          
SEQRES  21 F  261  HIS                                                          
HET    CAA  A 300      54                                                       
HET    CAA  B 300      54                                                       
HET    CAA  C 300      54                                                       
HET    CAA  E 300      54                                                       
HET    CAA  F 300      54                                                       
HETNAM     CAA ACETOACETYL-COENZYME A                                           
FORMUL   7  CAA    5(C25 H40 N7 O18 P3 S)                                       
FORMUL  12  HOH   *595(H2 O)                                                    
CRYST1   75.972   93.635  246.818  90.00  90.00  90.00 P 21 21 21   24          
ATOM      1  N   ALA A  31     -34.991 109.062  24.826  1.00 78.37           N  
ATOM      2  CA  ALA A  31     -35.559 110.346  25.350  1.00 75.98           C  
ATOM      3  C   ALA A  31     -35.537 111.388  24.228  1.00 74.72           C  
ATOM      4  O   ALA A  31     -35.360 111.018  23.064  1.00 76.72           O  
ATOM      5  CB  ALA A  31     -34.748 110.832  26.556  1.00 74.09           C  
ATOM      6  N   ASN A  32     -35.749 112.663  24.571  1.00 71.06           N  
ATOM      7  CA  ASN A  32     -35.752 113.776  23.601  1.00 65.19           C  
ATOM      8  C   ASN A  32     -34.320 114.261  23.339  1.00 59.29           C  
ATOM      9  O   ASN A  32     -33.863 115.249  23.930  1.00 59.83           O  
ATOM     10  CB  ASN A  32     -36.613 114.921  24.136  1.00 67.98           C  
ATOM     11  N   PHE A  33     -33.637 113.582  22.412  1.00 50.83           N  
ATOM     12  CA  PHE A  33     -32.232 113.869  22.114  1.00 40.00           C  
ATOM     13  C   PHE A  33     -31.913 115.043  21.209  1.00 37.86           C  
ATOM     14  O   PHE A  33     -32.371 115.132  20.072  1.00 35.04           O  
ATOM     15  CB  PHE A  33     -31.507 112.614  21.597  1.00 31.92           C  
ATOM     16  CG  PHE A  33     -31.462 111.476  22.590  1.00 25.81           C  
ATOM     17  CD1 PHE A  33     -31.264 111.720  23.949  1.00 23.27           C  
ATOM     18  CD2 PHE A  33     -31.584 110.157  22.154  1.00 22.47           C  
ATOM     19  CE1 PHE A  33     -31.186 110.664  24.865  1.00 20.90           C  
ATOM     20  CE2 PHE A  33     -31.511 109.101  23.049  1.00 21.13           C  
ATOM     21  CZ  PHE A  33     -31.312 109.354  24.414  1.00 20.49           C  
ATOM     22  N   GLN A  34     -31.056 115.911  21.726  1.00 35.45           N  
ATOM     23  CA  GLN A  34     -30.601 117.082  21.016  1.00 32.01           C  
ATOM     24  C   GLN A  34     -29.362 116.750  20.221  1.00 31.52           C  
ATOM     25  O   GLN A  34     -29.268 117.095  19.061  1.00 31.81           O  
ATOM     26  CB  GLN A  34     -30.257 118.181  22.012  1.00 39.14           C  
ATOM     27  CG  GLN A  34     -30.259 119.564  21.408  1.00 52.20           C  
ATOM     28  CD  GLN A  34     -29.645 120.641  22.310  1.00 58.36           C  
ATOM     29  OE1 GLN A  34     -28.937 121.529  21.823  1.00 60.21           O  
ATOM     30  NE2 GLN A  34     -29.934 120.587  23.613  1.00 59.24           N  
ATOM     31  N   TYR A  35     -28.431 116.023  20.843  1.00 34.00           N  
ATOM     32  CA  TYR A  35     -27.145 115.687  20.206  1.00 29.46           C  
ATOM     33  C   TYR A  35     -26.910 114.312  19.563  1.00 30.59           C  
ATOM     34  O   TYR A  35     -25.866 114.099  18.927  1.00 21.98           O  
ATOM     35  CB  TYR A  35     -26.022 115.930  21.196  1.00 22.69           C  
ATOM     36  CG  TYR A  35     -26.119 117.241  21.879  1.00 18.37           C  
ATOM     37  CD1 TYR A  35     -25.739 118.401  21.228  1.00 21.76           C  
ATOM     38  CD2 TYR A  35     -26.543 117.321  23.190  1.00 19.66           C  
ATOM     39  CE1 TYR A  35     -25.770 119.625  21.873  1.00 27.83           C  
ATOM     40  CE2 TYR A  35     -26.576 118.536  23.857  1.00 27.72           C  
ATOM     41  CZ  TYR A  35     -26.184 119.694  23.192  1.00 27.60           C  
ATOM     42  OH  TYR A  35     -26.166 120.905  23.849  1.00 35.34           O  
ATOM     43  N   ILE A  36     -27.817 113.358  19.769  1.00 30.54           N  
ATOM     44  CA  ILE A  36     -27.611 112.023  19.203  1.00 26.24           C  
ATOM     45  C   ILE A  36     -28.855 111.425  18.637  1.00 26.13           C  
ATOM     46  O   ILE A  36     -29.969 111.728  19.051  1.00 29.34           O  
ATOM     47  CB  ILE A  36     -27.089 110.996  20.243  1.00 25.99           C  
ATOM     48  CG1 ILE A  36     -28.110 110.829  21.357  1.00 19.32           C  
ATOM     49  CG2 ILE A  36     -25.724 111.403  20.829  1.00 22.26           C  
ATOM     50  CD1 ILE A  36     -27.888 109.632  22.179  1.00 18.97           C  
ATOM     51  N   ILE A  37     -28.628 110.471  17.759  1.00 28.49           N  
ATOM     52  CA  ILE A  37     -29.689 109.744  17.096  1.00 29.79           C  
ATOM     53  C   ILE A  37     -29.534 108.260  17.450  1.00 30.96           C  
ATOM     54  O   ILE A  37     -28.473 107.676  17.196  1.00 34.77           O  
ATOM     55  CB  ILE A  37     -29.531 109.869  15.555  1.00 31.94           C  
ATOM     56  CG1 ILE A  37     -29.664 111.331  15.113  1.00 32.01           C  
ATOM     57  CG2 ILE A  37     -30.528 108.985  14.834  1.00 29.54           C  
ATOM     58  CD1 ILE A  37     -29.394 111.554  13.649  1.00 24.17           C  
ATOM     59  N   THR A  38     -30.535 107.667  18.093  1.00 28.62           N  
ATOM     60  CA  THR A  38     -30.465 106.237  18.386  1.00 28.56           C  
ATOM     61  C   THR A  38     -31.382 105.459  17.434  1.00 30.71           C  
ATOM     62  O   THR A  38     -32.375 105.991  16.952  1.00 39.80           O  
ATOM     63  CB  THR A  38     -30.788 105.922  19.845  1.00 24.00           C  
ATOM     64  OG1 THR A  38     -32.095 106.379  20.167  1.00 29.59           O  
ATOM     65  CG2 THR A  38     -29.804 106.615  20.746  1.00 26.97           C  
ATOM     66  N   GLU A  39     -31.036 104.218  17.130  1.00 30.89           N  
ATOM     67  CA  GLU A  39     -31.829 103.403  16.220  1.00 27.25           C  
ATOM     68  C   GLU A  39     -31.536 101.937  16.569  1.00 30.08           C  
ATOM     69  O   GLU A  39     -30.462 101.643  17.076  1.00 32.64           O  
ATOM     70  CB  GLU A  39     -31.339 103.676  14.821  1.00 26.83           C  
ATOM     71  CG  GLU A  39     -32.378 103.787  13.743  1.00 42.94           C  
ATOM     72  CD  GLU A  39     -31.730 104.089  12.379  1.00 53.31           C  
ATOM     73  OE1 GLU A  39     -30.828 104.969  12.330  1.00 58.84           O  
ATOM     74  OE2 GLU A  39     -32.097 103.435  11.366  1.00 57.54           O  
ATOM     75  N   LYS A  40     -32.500 101.035  16.392  1.00 29.98           N  
ATOM     76  CA  LYS A  40     -32.283  99.596  16.648  1.00 23.95           C  
ATOM     77  C   LYS A  40     -32.198  98.938  15.297  1.00 22.17           C  
ATOM     78  O   LYS A  40     -33.152  98.926  14.537  1.00 23.11           O  
ATOM     79  CB  LYS A  40     -33.414  98.956  17.428  1.00 19.82           C  
ATOM     80  CG  LYS A  40     -33.270  99.120  18.923  1.00 28.68           C  
ATOM     81  CD  LYS A  40     -34.494  98.590  19.677  1.00 36.93           C  
ATOM     82  CE  LYS A  40     -34.598  97.046  19.638  1.00 46.77           C  
ATOM     83  NZ  LYS A  40     -35.797  96.492  20.375  1.00 51.11           N  
ATOM     84  N   LYS A  41     -31.020  98.463  14.958  1.00 22.31           N  
ATOM     85  CA  LYS A  41     -30.841  97.852  13.670  1.00 21.95           C  
ATOM     86  C   LYS A  41     -30.584  96.364  13.700  1.00 18.80           C  
ATOM     87  O   LYS A  41     -30.739  95.709  14.725  1.00 15.45           O  
ATOM     88  CB  LYS A  41     -29.734  98.575  12.893  1.00 22.50           C  
ATOM     89  CG  LYS A  41     -30.005 100.073  12.744  1.00 24.43           C  
ATOM     90  CD  LYS A  41     -29.549 100.625  11.405  1.00 28.41           C  
ATOM     91  CE  LYS A  41     -30.571 100.415  10.288  1.00 35.18           C  
ATOM     92  NZ  LYS A  41     -30.162 101.106   8.993  1.00 43.10           N  
ATOM     93  N   GLY A  42     -30.252  95.843  12.526  1.00 19.36           N  
ATOM     94  CA  GLY A  42     -29.959  94.443  12.371  1.00 23.59           C  
ATOM     95  C   GLY A  42     -31.120  93.470  12.513  1.00 28.50           C  
ATOM     96  O   GLY A  42     -32.278  93.814  12.828  1.00 28.39           O  
ATOM     97  N   LYS A  43     -30.767  92.219  12.266  1.00 30.74           N  
ATOM     98  CA  LYS A  43     -31.662  91.079  12.339  1.00 33.38           C  
ATOM     99  C   LYS A  43     -32.338  91.059  13.693  1.00 30.52           C  
ATOM    100  O   LYS A  43     -31.675  91.008  14.725  1.00 31.21           O  
ATOM    101  CB  LYS A  43     -30.846  89.783  12.165  1.00 38.34           C  
ATOM    102  CG  LYS A  43     -31.618  88.477  12.349  1.00 44.02           C  
ATOM    103  CD  LYS A  43     -31.965  87.842  10.993  1.00 49.43           C  
ATOM    104  CE  LYS A  43     -32.841  86.579  11.146  1.00 53.45           C  
ATOM    105  NZ  LYS A  43     -34.151  86.855  11.848  1.00 51.47           N  
ATOM    106  N   ASN A  44     -33.663  91.095  13.681  1.00 29.69           N  
ATOM    107  CA  ASN A  44     -34.431  91.056  14.917  1.00 26.89           C  
ATOM    108  C   ASN A  44     -34.222  92.316  15.779  1.00 25.70           C  
ATOM    109  O   ASN A  44     -34.672  92.396  16.945  1.00 20.29           O  
ATOM    110  CB  ASN A  44     -34.110  89.750  15.679  1.00 31.68           C  
ATOM    111  CG  ASN A  44     -34.262  88.474  14.795  1.00 32.94           C  
ATOM    112  OD1 ASN A  44     -35.277  88.273  14.117  1.00 34.54           O  
ATOM    113  ND2 ASN A  44     -33.241  87.626  14.807  1.00 32.74           N  
ATOM    114  N   SER A  45     -33.622  93.332  15.149  1.00 25.32           N  
ATOM    115  CA  SER A  45     -33.356  94.616  15.798  1.00 23.24           C  
ATOM    116  C   SER A  45     -32.596  94.410  17.098  1.00 18.75           C  
ATOM    117  O   SER A  45     -32.911  94.951  18.161  1.00 19.24           O  
ATOM    118  CB  SER A  45     -34.673  95.352  15.980  1.00 25.07           C  
ATOM    119  OG  SER A  45     -35.249  95.497  14.682  1.00 30.88           O  
ATOM    120  N   SER A  46     -31.556  93.604  16.939  1.00 23.36           N  
ATOM    121  CA  SER A  46     -30.638  93.183  18.003  1.00 25.42           C  
ATOM    122  C   SER A  46     -29.497  94.177  18.267  1.00 22.96           C  
ATOM    123  O   SER A  46     -28.936  94.221  19.370  1.00 23.48           O  
ATOM    124  CB  SER A  46     -30.056  91.792  17.649  1.00 20.02           C  
ATOM    125  OG  SER A  46     -29.505  91.744  16.324  1.00 15.44           O  
ATOM    126  N   VAL A  47     -29.160  94.952  17.242  1.00 18.86           N  
ATOM    127  CA  VAL A  47     -28.097  95.941  17.312  1.00 20.67           C  
ATOM    128  C   VAL A  47     -28.658  97.344  17.639  1.00 22.83           C  
ATOM    129  O   VAL A  47     -29.503  97.876  16.917  1.00 26.91           O  
ATOM    130  CB  VAL A  47     -27.345  96.007  15.970  1.00 17.59           C  
ATOM    131  CG1 VAL A  47     -26.152  96.928  16.103  1.00 18.46           C  
ATOM    132  CG2 VAL A  47     -26.882  94.620  15.516  1.00 16.47           C  
ATOM    133  N   GLY A  48     -28.198  97.925  18.738  1.00 20.01           N  
ATOM    134  CA  GLY A  48     -28.641  99.253  19.122  1.00 18.59           C  
ATOM    135  C   GLY A  48     -27.644 100.240  18.538  1.00 20.17           C  
ATOM    136  O   GLY A  48     -26.485 100.232  18.939  1.00 22.49           O  
ATOM    137  N   LEU A  49     -28.048 101.026  17.540  1.00 20.33           N  
ATOM    138  CA  LEU A  49     -27.172 102.024  16.899  1.00 21.24           C  
ATOM    139  C   LEU A  49     -27.243 103.386  17.575  1.00 19.12           C  
ATOM    140  O   LEU A  49     -28.329 103.867  17.849  1.00 22.44           O  
ATOM    141  CB  LEU A  49     -27.544 102.191  15.426  1.00 17.37           C  
ATOM    142  CG  LEU A  49     -26.886 103.369  14.728  1.00 14.01           C  
ATOM    143  CD1 LEU A  49     -25.432 103.074  14.415  1.00 15.18           C  
ATOM    144  CD2 LEU A  49     -27.646 103.610  13.458  1.00 12.90           C  
ATOM    145  N   ILE A  50     -26.082 103.971  17.872  1.00 19.17           N  
ATOM    146  CA  ILE A  50     -25.999 105.281  18.498  1.00 15.32           C  
ATOM    147  C   ILE A  50     -25.171 106.123  17.566  1.00 21.99           C  
ATOM    148  O   ILE A  50     -24.050 105.745  17.196  1.00 19.81           O  
ATOM    149  CB  ILE A  50     -25.304 105.251  19.866  1.00 15.88           C  
ATOM    150  CG1 ILE A  50     -26.190 104.513  20.870  1.00 15.05           C  
ATOM    151  CG2 ILE A  50     -25.048 106.689  20.383  1.00 15.08           C  
ATOM    152  CD1 ILE A  50     -25.654 104.453  22.286  1.00  5.84           C  
ATOM    153  N   GLN A  51     -25.744 107.245  17.137  1.00 22.24           N  
ATOM    154  CA  GLN A  51     -25.038 108.135  16.233  1.00 22.74           C  
ATOM    155  C   GLN A  51     -24.911 109.483  16.893  1.00 21.34           C  
ATOM    156  O   GLN A  51     -25.905 110.034  17.390  1.00 19.55           O  
ATOM    157  CB  GLN A  51     -25.798 108.283  14.931  1.00 23.40           C  
ATOM    158  CG  GLN A  51     -25.002 108.896  13.811  1.00 31.70           C  
ATOM    159  CD  GLN A  51     -25.883 109.317  12.653  1.00 39.60           C  
ATOM    160  OE1 GLN A  51     -25.937 110.502  12.300  1.00 41.62           O  
ATOM    161  NE2 GLN A  51     -26.606 108.353  12.069  1.00 45.08           N  
ATOM    162  N   LEU A  52     -23.673 109.955  16.991  1.00 20.15           N  
ATOM    163  CA  LEU A  52     -23.386 111.265  17.557  1.00 16.87           C  
ATOM    164  C   LEU A  52     -23.814 112.233  16.463  1.00 14.02           C  
ATOM    165  O   LEU A  52     -23.417 112.135  15.309  1.00  9.71           O  
ATOM    166  CB  LEU A  52     -21.898 111.381  17.872  1.00 17.97           C  
ATOM    167  CG  LEU A  52     -21.432 110.370  18.923  1.00 14.92           C  
ATOM    168  CD1 LEU A  52     -19.979 110.663  19.325  1.00 12.40           C  
ATOM    169  CD2 LEU A  52     -22.365 110.447  20.153  1.00  9.99           C  
ATOM    170  N   ASN A  53     -24.691 113.139  16.814  1.00 18.48           N  
ATOM    171  CA  ASN A  53     -25.195 114.020  15.818  1.00 24.04           C  
ATOM    172  C   ASN A  53     -25.092 115.473  16.249  1.00 28.64           C  
ATOM    173  O   ASN A  53     -26.047 116.079  16.756  1.00 32.03           O  
ATOM    174  CB  ASN A  53     -26.617 113.601  15.550  1.00 27.14           C  
ATOM    175  CG  ASN A  53     -27.165 114.185  14.299  1.00 31.27           C  
ATOM    176  OD1 ASN A  53     -28.299 114.611  14.280  1.00 31.21           O  
ATOM    177  ND2 ASN A  53     -26.387 114.174  13.228  1.00 24.66           N  
ATOM    178  N   ARG A  54     -23.896 116.013  16.065  1.00 26.92           N  
ATOM    179  CA  ARG A  54     -23.591 117.394  16.384  1.00 21.62           C  
ATOM    180  C   ARG A  54     -22.501 117.766  15.363  1.00 22.23           C  
ATOM    181  O   ARG A  54     -21.446 118.283  15.712  1.00 21.35           O  
ATOM    182  CB  ARG A  54     -23.095 117.500  17.825  1.00 14.74           C  
ATOM    183  CG  ARG A  54     -22.747 118.914  18.226  1.00 15.27           C  
ATOM    184  CD  ARG A  54     -22.083 118.981  19.560  1.00 23.14           C  
ATOM    185  NE  ARG A  54     -22.043 120.341  20.076  1.00 30.56           N  
ATOM    186  CZ  ARG A  54     -21.010 120.879  20.714  1.00 38.18           C  
ATOM    187  NH1 ARG A  54     -19.900 120.187  20.910  1.00 43.28           N  
ATOM    188  NH2 ARG A  54     -21.117 122.087  21.235  1.00 45.67           N  
ATOM    189  N   PRO A  55     -22.810 117.596  14.064  1.00 25.71           N  
ATOM    190  CA  PRO A  55     -21.859 117.888  12.984  1.00 27.32           C  
ATOM    191  C   PRO A  55     -21.261 119.284  12.952  1.00 31.07           C  
ATOM    192  O   PRO A  55     -20.139 119.471  12.497  1.00 31.82           O  
ATOM    193  CB  PRO A  55     -22.660 117.555  11.719  1.00 22.18           C  
ATOM    194  CG  PRO A  55     -24.041 117.889  12.101  1.00 19.78           C  
ATOM    195  CD  PRO A  55     -24.164 117.369  13.517  1.00 20.98           C  
ATOM    196  N   LYS A  56     -21.987 120.261  13.475  1.00 34.95           N  
ATOM    197  CA  LYS A  56     -21.497 121.632  13.453  1.00 39.26           C  
ATOM    198  C   LYS A  56     -20.262 121.843  14.301  1.00 34.42           C  
ATOM    199  O   LYS A  56     -19.491 122.758  14.054  1.00 36.82           O  
ATOM    200  CB  LYS A  56     -22.609 122.596  13.825  1.00 48.21           C  
ATOM    201  CG  LYS A  56     -23.712 122.613  12.789  1.00 59.46           C  
ATOM    202  CD  LYS A  56     -24.741 123.666  13.105  1.00 70.96           C  
ATOM    203  CE  LYS A  56     -25.698 123.860  11.941  1.00 77.86           C  
ATOM    204  NZ  LYS A  56     -26.697 124.933  12.213  1.00 81.47           N  
ATOM    205  N   ALA A  57     -20.097 120.995  15.311  1.00 27.26           N  
ATOM    206  CA  ALA A  57     -18.942 121.044  16.191  1.00 21.59           C  
ATOM    207  C   ALA A  57     -18.170 119.758  16.001  1.00 18.38           C  
ATOM    208  O   ALA A  57     -17.495 119.295  16.913  1.00 17.50           O  
ATOM    209  CB  ALA A  57     -19.377 121.175  17.634  1.00 15.36           C  
ATOM    210  N   LEU A  58     -18.281 119.180  14.812  1.00 19.37           N  
ATOM    211  CA  LEU A  58     -17.626 117.921  14.485  1.00 19.90           C  
ATOM    212  C   LEU A  58     -17.777 116.924  15.632  1.00 22.23           C  
ATOM    213  O   LEU A  58     -16.818 116.283  16.043  1.00 24.35           O  
ATOM    214  CB  LEU A  58     -16.157 118.144  14.203  1.00 19.41           C  
ATOM    215  CG  LEU A  58     -15.804 118.912  12.955  1.00 18.22           C  
ATOM    216  CD1 LEU A  58     -14.288 118.977  12.885  1.00 20.10           C  
ATOM    217  CD2 LEU A  58     -16.342 118.246  11.751  1.00 10.76           C  
ATOM    218  N   ASN A  59     -18.986 116.824  16.168  1.00 23.29           N  
ATOM    219  CA  ASN A  59     -19.284 115.919  17.287  1.00 23.53           C  
ATOM    220  C   ASN A  59     -18.437 116.093  18.550  1.00 22.46           C  
ATOM    221  O   ASN A  59     -18.242 115.123  19.282  1.00 20.65           O  
ATOM    222  CB  ASN A  59     -19.224 114.453  16.858  1.00 20.82           C  
ATOM    223  CG  ASN A  59     -20.328 114.083  15.898  1.00 21.67           C  
ATOM    224  OD1 ASN A  59     -21.438 114.610  15.968  1.00 16.39           O  
ATOM    225  ND2 ASN A  59     -20.019 113.195  14.971  1.00 23.08           N  
ATOM    226  N   ALA A  60     -17.982 117.319  18.836  1.00 22.16           N  
ATOM    227  CA  ALA A  60     -17.163 117.589  20.025  1.00 16.08           C  
ATOM    228  C   ALA A  60     -17.989 117.148  21.204  1.00 15.53           C  
ATOM    229  O   ALA A  60     -19.171 117.438  21.288  1.00 16.21           O  
ATOM    230  CB  ALA A  60     -16.800 119.070  20.127  1.00 10.43           C  
ATOM    231  N   LEU A  61     -17.357 116.441  22.125  1.00 21.64           N  
ATOM    232  CA  LEU A  61     -18.038 115.862  23.283  1.00 20.81           C  
ATOM    233  C   LEU A  61     -18.447 116.785  24.420  1.00 21.42           C  
ATOM    234  O   LEU A  61     -17.900 116.737  25.534  1.00 20.46           O  
ATOM    235  CB  LEU A  61     -17.208 114.678  23.810  1.00 19.34           C  
ATOM    236  CG  LEU A  61     -16.760 113.673  22.730  1.00 12.51           C  
ATOM    237  CD1 LEU A  61     -15.755 112.732  23.321  1.00 10.85           C  
ATOM    238  CD2 LEU A  61     -17.923 112.921  22.138  1.00 10.12           C  
ATOM    239  N   CYS A  62     -19.454 117.602  24.167  1.00 24.02           N  
ATOM    240  CA  CYS A  62     -19.893 118.536  25.208  1.00 25.53           C  
ATOM    241  C   CYS A  62     -20.634 117.775  26.285  1.00 24.13           C  
ATOM    242  O   CYS A  62     -21.140 116.695  26.021  1.00 26.92           O  
ATOM    243  CB  CYS A  62     -20.782 119.649  24.618  1.00 23.82           C  
ATOM    244  SG  CYS A  62     -22.309 119.103  23.813  1.00 21.26           S  
ATOM    245  N   ASN A  63     -20.727 118.345  27.482  1.00 24.62           N  
ATOM    246  CA  ASN A  63     -21.433 117.697  28.583  1.00 27.46           C  
ATOM    247  C   ASN A  63     -22.816 117.165  28.197  1.00 26.96           C  
ATOM    248  O   ASN A  63     -23.187 116.064  28.579  1.00 33.03           O  
ATOM    249  CB  ASN A  63     -21.574 118.637  29.786  1.00 37.30           C  
ATOM    250  CG  ASN A  63     -20.232 119.006  30.409  1.00 50.15           C  
ATOM    251  OD1 ASN A  63     -19.313 118.183  30.480  1.00 60.24           O  
ATOM    252  ND2 ASN A  63     -20.107 120.260  30.845  1.00 57.90           N  
ATOM    253  N   GLY A  64     -23.564 117.934  27.418  1.00 23.12           N  
ATOM    254  CA  GLY A  64     -24.885 117.517  27.009  1.00 14.46           C  
ATOM    255  C   GLY A  64     -24.862 116.311  26.107  1.00 16.00           C  
ATOM    256  O   GLY A  64     -25.691 115.412  26.238  1.00 16.73           O  
ATOM    257  N   LEU A  65     -23.933 116.295  25.164  1.00 16.01           N  
ATOM    258  CA  LEU A  65     -23.793 115.172  24.250  1.00 19.44           C  
ATOM    259  C   LEU A  65     -23.461 113.941  25.133  1.00 24.67           C  
ATOM    260  O   LEU A  65     -24.131 112.928  25.041  1.00 26.22           O  
ATOM    261  CB  LEU A  65     -22.661 115.470  23.260  1.00 17.80           C  
ATOM    262  CG  LEU A  65     -22.037 114.605  22.147  1.00 17.32           C  
ATOM    263  CD1 LEU A  65     -22.045 113.144  22.502  1.00 20.57           C  
ATOM    264  CD2 LEU A  65     -22.672 114.853  20.826  1.00  4.57           C  
ATOM    265  N   ILE A  66     -22.504 114.053  26.056  1.00 22.70           N  
ATOM    266  CA  ILE A  66     -22.124 112.911  26.893  1.00 18.69           C  
ATOM    267  C   ILE A  66     -23.279 112.417  27.733  1.00 23.67           C  
ATOM    268  O   ILE A  66     -23.463 111.217  27.882  1.00 28.06           O  
ATOM    269  CB  ILE A  66     -20.898 113.204  27.833  1.00 16.60           C  
ATOM    270  CG1 ILE A  66     -19.600 113.331  27.031  1.00 10.57           C  
ATOM    271  CG2 ILE A  66     -20.728 112.080  28.875  1.00 11.51           C  
ATOM    272  CD1 ILE A  66     -19.312 112.126  26.165  1.00 19.81           C  
ATOM    273  N   GLU A  67     -24.077 113.335  28.260  1.00 26.77           N  
ATOM    274  CA  GLU A  67     -25.202 112.970  29.113  1.00 23.35           C  
ATOM    275  C   GLU A  67     -26.218 112.164  28.313  1.00 25.77           C  
ATOM    276  O   GLU A  67     -26.810 111.204  28.816  1.00 30.75           O  
ATOM    277  CB  GLU A  67     -25.840 114.225  29.664  1.00 30.38           C  
ATOM    278  CG  GLU A  67     -26.832 114.029  30.786  1.00 51.72           C  
ATOM    279  CD  GLU A  67     -27.629 115.314  31.077  1.00 66.19           C  
ATOM    280  OE1 GLU A  67     -28.481 115.695  30.232  1.00 73.14           O  
ATOM    281  OE2 GLU A  67     -27.392 115.954  32.136  1.00 73.64           O  
ATOM    282  N   GLU A  68     -26.384 112.507  27.046  1.00 20.46           N  
ATOM    283  CA  GLU A  68     -27.341 111.798  26.225  1.00 17.67           C  
ATOM    284  C   GLU A  68     -26.769 110.470  25.803  1.00 18.39           C  
ATOM    285  O   GLU A  68     -27.477 109.468  25.783  1.00 25.31           O  
ATOM    286  CB  GLU A  68     -27.704 112.621  24.995  1.00 17.59           C  
ATOM    287  CG  GLU A  68     -28.441 113.892  25.317  1.00 17.46           C  
ATOM    288  CD  GLU A  68     -29.044 114.576  24.088  1.00 17.89           C  
ATOM    289  OE1 GLU A  68     -28.597 114.343  22.964  1.00 17.62           O  
ATOM    290  OE2 GLU A  68     -29.982 115.365  24.248  1.00 26.50           O  
ATOM    291  N   LEU A  69     -25.494 110.462  25.435  1.00 17.87           N  
ATOM    292  CA  LEU A  69     -24.801 109.254  25.005  1.00 11.90           C  
ATOM    293  C   LEU A  69     -24.958 108.247  26.116  1.00 13.29           C  
ATOM    294  O   LEU A  69     -25.388 107.134  25.873  1.00 19.09           O  
ATOM    295  CB  LEU A  69     -23.318 109.527  24.768  1.00 12.90           C  
ATOM    296  CG  LEU A  69     -22.357 108.347  24.557  1.00 16.00           C  
ATOM    297  CD1 LEU A  69     -22.706 107.537  23.304  1.00  9.03           C  
ATOM    298  CD2 LEU A  69     -20.925 108.862  24.497  1.00  9.66           C  
ATOM    299  N   ASN A  70     -24.676 108.649  27.342  1.00  6.59           N  
ATOM    300  CA  ASN A  70     -24.808 107.741  28.461  1.00 12.79           C  
ATOM    301  C   ASN A  70     -26.241 107.291  28.654  1.00 20.35           C  
ATOM    302  O   ASN A  70     -26.458 106.160  29.062  1.00 26.93           O  
ATOM    303  CB  ASN A  70     -24.301 108.356  29.752  1.00 10.81           C  
ATOM    304  CG  ASN A  70     -22.800 108.535  29.767  1.00 13.46           C  
ATOM    305  OD1 ASN A  70     -22.066 107.905  28.999  1.00 14.05           O  
ATOM    306  ND2 ASN A  70     -22.325 109.367  30.681  1.00 14.37           N  
ATOM    307  N   GLN A  71     -27.226 108.154  28.416  1.00 22.21           N  
ATOM    308  CA  GLN A  71     -28.631 107.735  28.563  1.00 22.24           C  
ATOM    309  C   GLN A  71     -28.926 106.675  27.512  1.00 22.91           C  
ATOM    310  O   GLN A  71     -29.512 105.644  27.815  1.00 28.24           O  
ATOM    311  CB  GLN A  71     -29.603 108.871  28.327  1.00 28.00           C  
ATOM    312  CG  GLN A  71     -29.860 109.767  29.522  1.00 43.27           C  
ATOM    313  CD  GLN A  71     -30.601 111.068  29.150  1.00 50.78           C  
ATOM    314  OE1 GLN A  71     -31.435 111.100  28.225  1.00 54.27           O  
ATOM    315  NE2 GLN A  71     -30.269 112.151  29.855  1.00 50.76           N  
ATOM    316  N   ALA A  72     -28.508 106.916  26.274  1.00 13.96           N  
ATOM    317  CA  ALA A  72     -28.755 105.961  25.215  1.00 13.24           C  
ATOM    318  C   ALA A  72     -28.066 104.603  25.487  1.00 22.72           C  
ATOM    319  O   ALA A  72     -28.640 103.541  25.214  1.00 27.06           O  
ATOM    320  CB  ALA A  72     -28.303 106.524  23.923  1.00  4.76           C  
ATOM    321  N   LEU A  73     -26.852 104.634  26.040  1.00 23.29           N  
ATOM    322  CA  LEU A  73     -26.101 103.416  26.335  1.00 16.19           C  
ATOM    323  C   LEU A  73     -26.846 102.619  27.384  1.00 13.90           C  
ATOM    324  O   LEU A  73     -27.041 101.431  27.235  1.00 20.28           O  
ATOM    325  CB  LEU A  73     -24.714 103.745  26.876  1.00  8.29           C  
ATOM    326  CG  LEU A  73     -23.726 104.288  25.853  1.00  7.70           C  
ATOM    327  CD1 LEU A  73     -22.520 104.839  26.596  1.00  5.27           C  
ATOM    328  CD2 LEU A  73     -23.338 103.245  24.844  1.00  2.00           C  
ATOM    329  N   GLU A  74     -27.267 103.287  28.440  1.00  9.46           N  
ATOM    330  CA  GLU A  74     -27.962 102.643  29.520  1.00 13.97           C  
ATOM    331  C   GLU A  74     -29.242 102.032  29.009  1.00 19.70           C  
ATOM    332  O   GLU A  74     -29.631 100.938  29.415  1.00 25.16           O  
ATOM    333  CB  GLU A  74     -28.286 103.645  30.620  1.00 10.17           C  
ATOM    334  CG  GLU A  74     -28.441 103.022  31.993  1.00 34.34           C  
ATOM    335  CD  GLU A  74     -27.283 102.066  32.342  1.00 41.24           C  
ATOM    336  OE1 GLU A  74     -26.107 102.441  32.119  1.00 40.29           O  
ATOM    337  OE2 GLU A  74     -27.550 100.937  32.831  1.00 47.55           O  
ATOM    338  N   THR A  75     -29.869 102.694  28.054  1.00 20.86           N  
ATOM    339  CA  THR A  75     -31.122 102.204  27.540  1.00 19.38           C  
ATOM    340  C   THR A  75     -30.934 100.921  26.782  1.00 15.50           C  
ATOM    341  O   THR A  75     -31.592  99.938  27.076  1.00 19.20           O  
ATOM    342  CB  THR A  75     -31.829 103.269  26.716  1.00 21.07           C  
ATOM    343  OG1 THR A  75     -32.360 104.243  27.626  1.00 23.37           O  
ATOM    344  CG2 THR A  75     -32.958 102.649  25.851  1.00 19.44           C  
ATOM    345  N   PHE A  76     -30.045 100.936  25.806  1.00 10.53           N  
ATOM    346  CA  PHE A  76     -29.740  99.744  25.035  1.00 12.26           C  
ATOM    347  C   PHE A  76     -29.233  98.651  25.983  1.00 17.28           C  
ATOM    348  O   PHE A  76     -29.456  97.473  25.764  1.00 22.60           O  
ATOM    349  CB  PHE A  76     -28.660 100.037  23.997  1.00  4.94           C  
ATOM    350  CG  PHE A  76     -29.190 100.697  22.772  1.00 17.74           C  
ATOM    351  CD1 PHE A  76     -30.502 100.429  22.339  1.00 15.74           C  
ATOM    352  CD2 PHE A  76     -28.393 101.581  22.036  1.00 15.81           C  
ATOM    353  CE1 PHE A  76     -31.020 101.037  21.183  1.00 14.82           C  
ATOM    354  CE2 PHE A  76     -28.890 102.196  20.880  1.00 18.09           C  
ATOM    355  CZ  PHE A  76     -30.211 101.924  20.446  1.00 17.82           C  
ATOM    356  N   GLU A  77     -28.553  99.045  27.045  1.00 19.28           N  
ATOM    357  CA  GLU A  77     -28.018  98.095  27.987  1.00 18.05           C  
ATOM    358  C   GLU A  77     -29.167  97.375  28.668  1.00 23.59           C  
ATOM    359  O   GLU A  77     -29.109  96.170  28.879  1.00 25.51           O  
ATOM    360  CB  GLU A  77     -27.174  98.832  29.015  1.00 16.61           C  
ATOM    361  CG  GLU A  77     -26.780  97.991  30.208  1.00 17.34           C  
ATOM    362  CD  GLU A  77     -25.567  97.102  29.945  1.00 20.63           C  
ATOM    363  OE1 GLU A  77     -25.216  96.701  28.900  1.00 21.18           O  
ATOM    364  OE2 GLU A  77     -24.860  96.708  30.782  1.00 15.99           O  
ATOM    365  N   GLU A  78     -30.225  98.110  28.987  1.00 25.69           N  
ATOM    366  CA  GLU A  78     -31.365  97.523  29.678  1.00 24.92           C  
ATOM    367  C   GLU A  78     -32.358  96.884  28.724  1.00 21.29           C  
ATOM    368  O   GLU A  78     -33.347  96.279  29.121  1.00 27.60           O  
ATOM    369  CB  GLU A  78     -32.021  98.594  30.538  1.00 29.96           C  
ATOM    370  CG  GLU A  78     -31.160  98.978  31.720  1.00 46.87           C  
ATOM    371  CD  GLU A  78     -31.627 100.247  32.397  1.00 61.38           C  
ATOM    372  OE1 GLU A  78     -31.885 101.238  31.664  1.00 68.86           O  
ATOM    373  OE2 GLU A  78     -31.736 100.250  33.655  1.00 68.05           O  
ATOM    374  N   ASP A  79     -32.020  96.912  27.455  1.00 17.41           N  
ATOM    375  CA  ASP A  79     -32.910  96.401  26.458  1.00 17.27           C  
ATOM    376  C   ASP A  79     -32.656  94.948  26.072  1.00 23.71           C  
ATOM    377  O   ASP A  79     -31.750  94.649  25.277  1.00 24.92           O  
ATOM    378  CB  ASP A  79     -32.832  97.283  25.249  1.00 15.89           C  
ATOM    379  CG  ASP A  79     -33.920  97.015  24.318  1.00 24.93           C  
ATOM    380  OD1 ASP A  79     -35.061  96.886  24.808  1.00 29.80           O  
ATOM    381  OD2 ASP A  79     -33.624  96.888  23.113  1.00 29.76           O  
ATOM    382  N   PRO A  80     -33.570  94.051  26.484  1.00 25.90           N  
ATOM    383  CA  PRO A  80     -33.513  92.604  26.226  1.00 18.45           C  
ATOM    384  C   PRO A  80     -33.287  92.163  24.800  1.00 17.88           C  
ATOM    385  O   PRO A  80     -32.786  91.079  24.573  1.00 20.55           O  
ATOM    386  CB  PRO A  80     -34.868  92.122  26.684  1.00 20.99           C  
ATOM    387  CG  PRO A  80     -35.193  93.063  27.785  1.00 25.58           C  
ATOM    388  CD  PRO A  80     -34.815  94.394  27.191  1.00 24.60           C  
ATOM    389  N   ALA A  81     -33.693  92.965  23.829  1.00 20.65           N  
ATOM    390  CA  ALA A  81     -33.536  92.562  22.431  1.00 16.83           C  
ATOM    391  C   ALA A  81     -32.183  92.953  21.872  1.00 19.85           C  
ATOM    392  O   ALA A  81     -31.787  92.486  20.786  1.00 17.85           O  
ATOM    393  CB  ALA A  81     -34.650  93.171  21.570  1.00 16.76           C  
ATOM    394  N   VAL A  82     -31.497  93.854  22.574  1.00 18.55           N  
ATOM    395  CA  VAL A  82     -30.202  94.331  22.107  1.00 15.62           C  
ATOM    396  C   VAL A  82     -29.075  93.556  22.777  1.00 16.76           C  
ATOM    397  O   VAL A  82     -29.022  93.397  24.006  1.00 14.37           O  
ATOM    398  CB  VAL A  82     -30.063  95.857  22.309  1.00 20.52           C  
ATOM    399  CG1 VAL A  82     -28.678  96.334  21.841  1.00 17.28           C  
ATOM    400  CG2 VAL A  82     -31.159  96.573  21.508  1.00 12.50           C  
ATOM    401  N   GLY A  83     -28.236  92.987  21.926  1.00 15.42           N  
ATOM    402  CA  GLY A  83     -27.111  92.193  22.376  1.00 14.11           C  
ATOM    403  C   GLY A  83     -25.779  92.876  22.141  1.00 16.58           C  
ATOM    404  O   GLY A  83     -24.752  92.453  22.670  1.00 19.42           O  
ATOM    405  N   ALA A  84     -25.780  93.912  21.321  1.00 12.81           N  
ATOM    406  CA  ALA A  84     -24.581  94.677  21.037  1.00 15.19           C  
ATOM    407  C   ALA A  84     -24.964  96.091  20.544  1.00 17.98           C  
ATOM    408  O   ALA A  84     -26.030  96.309  19.961  1.00 16.07           O  
ATOM    409  CB  ALA A  84     -23.701  93.947  20.011  1.00 11.07           C  
ATOM    410  N   ILE A  85     -24.077  97.036  20.799  1.00 14.57           N  
ATOM    411  CA  ILE A  85     -24.271  98.419  20.428  1.00 11.73           C  
ATOM    412  C   ILE A  85     -23.200  98.879  19.424  1.00 14.91           C  
ATOM    413  O   ILE A  85     -22.060  98.430  19.451  1.00 20.19           O  
ATOM    414  CB  ILE A  85     -24.177  99.285  21.682  1.00  8.16           C  
ATOM    415  CG1 ILE A  85     -25.237  98.815  22.695  1.00  2.81           C  
ATOM    416  CG2 ILE A  85     -24.221 100.766  21.310  1.00  8.71           C  
ATOM    417  CD1 ILE A  85     -25.089  99.343  24.098  1.00  2.00           C  
ATOM    418  N   VAL A  86     -23.590  99.714  18.483  1.00 15.27           N  
ATOM    419  CA  VAL A  86     -22.646 100.261  17.524  1.00 14.06           C  
ATOM    420  C   VAL A  86     -22.731 101.776  17.702  1.00 15.71           C  
ATOM    421  O   VAL A  86     -23.824 102.355  17.680  1.00 12.16           O  
ATOM    422  CB  VAL A  86     -23.012  99.926  16.088  1.00 15.84           C  
ATOM    423  CG1 VAL A  86     -22.167 100.772  15.121  1.00  7.96           C  
ATOM    424  CG2 VAL A  86     -22.809  98.456  15.846  1.00 10.58           C  
ATOM    425  N   LEU A  87     -21.585 102.382  18.000  1.00 16.29           N  
ATOM    426  CA  LEU A  87     -21.480 103.817  18.207  1.00 12.97           C  
ATOM    427  C   LEU A  87     -20.756 104.393  16.966  1.00 16.35           C  
ATOM    428  O   LEU A  87     -19.774 103.820  16.490  1.00 18.30           O  
ATOM    429  CB  LEU A  87     -20.686 104.055  19.482  1.00 12.27           C  
ATOM    430  CG  LEU A  87     -20.324 105.482  19.872  1.00 18.46           C  
ATOM    431  CD1 LEU A  87     -21.610 106.275  20.157  1.00 14.45           C  
ATOM    432  CD2 LEU A  87     -19.423 105.413  21.108  1.00 13.75           C  
ATOM    433  N   THR A  88     -21.315 105.454  16.380  1.00 20.15           N  
ATOM    434  CA  THR A  88     -20.739 106.117  15.198  1.00 13.82           C  
ATOM    435  C   THR A  88     -21.056 107.627  15.234  1.00 17.78           C  
ATOM    436  O   THR A  88     -21.791 108.111  16.110  1.00 17.57           O  
ATOM    437  CB  THR A  88     -21.264 105.474  13.863  1.00 14.99           C  
ATOM    438  OG1 THR A  88     -20.478 105.892  12.735  1.00 12.20           O  
ATOM    439  CG2 THR A  88     -22.687 105.863  13.601  1.00 16.03           C  
ATOM    440  N   GLY A  89     -20.416 108.375  14.343  1.00 18.80           N  
ATOM    441  CA  GLY A  89     -20.662 109.799  14.277  1.00 21.11           C  
ATOM    442  C   GLY A  89     -21.100 110.046  12.856  1.00 22.26           C  
ATOM    443  O   GLY A  89     -21.889 109.288  12.304  1.00 30.35           O  
ATOM    444  N   GLY A  90     -20.544 111.063  12.233  1.00 21.95           N  
ATOM    445  CA  GLY A  90     -20.883 111.358  10.860  1.00 17.35           C  
ATOM    446  C   GLY A  90     -19.799 110.886   9.931  1.00 21.83           C  
ATOM    447  O   GLY A  90     -18.778 110.371  10.370  1.00 31.70           O  
ATOM    448  N   GLU A  91     -19.998 111.089   8.643  1.00 22.82           N  
ATOM    449  CA  GLU A  91     -19.032 110.666   7.658  1.00 29.06           C  
ATOM    450  C   GLU A  91     -17.707 111.413   7.810  1.00 29.07           C  
ATOM    451  O   GLU A  91     -16.648 110.854   7.563  1.00 27.05           O  
ATOM    452  CB  GLU A  91     -19.630 110.885   6.279  1.00 32.97           C  
ATOM    453  CG  GLU A  91     -18.696 110.643   5.128  1.00 51.78           C  
ATOM    454  CD  GLU A  91     -19.436 110.529   3.811  1.00 62.81           C  
ATOM    455  OE1 GLU A  91     -20.272 109.593   3.682  1.00 70.19           O  
ATOM    456  OE2 GLU A  91     -19.181 111.369   2.913  1.00 66.29           O  
ATOM    457  N   LYS A  92     -17.792 112.679   8.229  1.00 31.26           N  
ATOM    458  CA  LYS A  92     -16.627 113.550   8.369  1.00 31.81           C  
ATOM    459  C   LYS A  92     -15.918 113.402   9.698  1.00 27.54           C  
ATOM    460  O   LYS A  92     -14.703 113.571   9.801  1.00 22.79           O  
ATOM    461  CB  LYS A  92     -17.034 115.013   8.189  1.00 37.80           C  
ATOM    462  CG  LYS A  92     -15.843 115.934   7.912  1.00 51.37           C  
ATOM    463  CD  LYS A  92     -16.197 117.430   7.899  1.00 57.94           C  
ATOM    464  CE  LYS A  92     -14.985 118.302   7.539  1.00 61.70           C  
ATOM    465  NZ  LYS A  92     -15.259 119.778   7.548  1.00 62.60           N  
ATOM    466  N   ALA A  93     -16.670 113.100  10.735  1.00 23.15           N  
ATOM    467  CA  ALA A  93     -16.046 112.962  12.026  1.00 21.32           C  
ATOM    468  C   ALA A  93     -16.814 112.108  12.996  1.00 24.55           C  
ATOM    469  O   ALA A  93     -18.016 112.273  13.187  1.00 27.46           O  
ATOM    470  CB  ALA A  93     -15.836 114.311  12.630  1.00 18.91           C  
ATOM    471  N   PHE A  94     -16.087 111.222  13.656  1.00 22.76           N  
ATOM    472  CA  PHE A  94     -16.650 110.359  14.683  1.00 17.19           C  
ATOM    473  C   PHE A  94     -16.837 111.312  15.887  1.00 16.25           C  
ATOM    474  O   PHE A  94     -17.914 111.401  16.457  1.00 16.54           O  
ATOM    475  CB  PHE A  94     -15.662 109.204  15.000  1.00 14.11           C  
ATOM    476  CG  PHE A  94     -16.077 108.347  16.167  1.00 10.10           C  
ATOM    477  CD1 PHE A  94     -17.053 107.345  16.009  1.00 10.26           C  
ATOM    478  CD2 PHE A  94     -15.493 108.543  17.435  1.00  4.35           C  
ATOM    479  CE1 PHE A  94     -17.441 106.539  17.114  1.00  5.67           C  
ATOM    480  CE2 PHE A  94     -15.862 107.761  18.529  1.00  5.33           C  
ATOM    481  CZ  PHE A  94     -16.842 106.750  18.370  1.00  7.91           C  
ATOM    482  N   ALA A  95     -15.773 112.019  16.263  1.00 12.07           N  
ATOM    483  CA  ALA A  95     -15.804 112.992  17.358  1.00 10.69           C  
ATOM    484  C   ALA A  95     -14.454 113.672  17.337  1.00 14.20           C  
ATOM    485  O   ALA A  95     -13.429 112.996  17.384  1.00 20.82           O  
ATOM    486  CB  ALA A  95     -16.024 112.331  18.670  1.00  6.17           C  
ATOM    487  N   ALA A  96     -14.447 114.999  17.247  1.00 17.14           N  
ATOM    488  CA  ALA A  96     -13.197 115.761  17.173  1.00 15.20           C  
ATOM    489  C   ALA A  96     -12.534 116.042  18.517  1.00 12.83           C  
ATOM    490  O   ALA A  96     -11.521 116.720  18.585  1.00 14.95           O  
ATOM    491  CB  ALA A  96     -13.409 117.037  16.422  1.00 19.19           C  
ATOM    492  N   GLY A  97     -13.131 115.571  19.595  1.00  9.59           N  
ATOM    493  CA  GLY A  97     -12.515 115.761  20.879  1.00  9.41           C  
ATOM    494  C   GLY A  97     -13.492 116.228  21.891  1.00 14.81           C  
ATOM    495  O   GLY A  97     -14.678 116.202  21.624  1.00 22.47           O  
ATOM    496  N   ALA A  98     -13.010 116.589  23.070  1.00 17.15           N  
ATOM    497  CA  ALA A  98     -13.855 117.126  24.129  1.00 17.87           C  
ATOM    498  C   ALA A  98     -14.177 118.534  23.675  1.00 17.61           C  
ATOM    499  O   ALA A  98     -13.531 119.032  22.751  1.00 21.13           O  
ATOM    500  CB  ALA A  98     -13.077 117.181  25.407  1.00 16.29           C  
ATOM    501  N   ASP A  99     -15.153 119.184  24.301  1.00 23.23           N  
ATOM    502  CA  ASP A  99     -15.506 120.555  23.920  1.00 27.16           C  
ATOM    503  C   ASP A  99     -14.492 121.553  24.525  1.00 24.61           C  
ATOM    504  O   ASP A  99     -14.514 121.830  25.731  1.00 17.85           O  
ATOM    505  CB  ASP A  99     -16.926 120.883  24.383  1.00 31.44           C  
ATOM    506  CG  ASP A  99     -17.533 122.049  23.641  1.00 31.62           C  
ATOM    507  OD1 ASP A  99     -16.846 123.060  23.429  1.00 31.61           O  
ATOM    508  OD2 ASP A  99     -18.717 121.952  23.270  1.00 38.44           O  
ATOM    509  N   ILE A 100     -13.637 122.113  23.669  1.00 21.92           N  
ATOM    510  CA  ILE A 100     -12.611 123.050  24.103  1.00 21.14           C  
ATOM    511  C   ILE A 100     -13.202 124.304  24.673  1.00 19.05           C  
ATOM    512  O   ILE A 100     -12.725 124.812  25.670  1.00 22.11           O  
ATOM    513  CB  ILE A 100     -11.654 123.370  22.961  1.00 19.55           C  
ATOM    514  CG1 ILE A 100     -11.049 122.066  22.448  1.00 16.80           C  
ATOM    515  CG2 ILE A 100     -10.569 124.301  23.441  1.00 16.33           C  
ATOM    516  CD1 ILE A 100     -10.379 122.154  21.116  1.00 15.52           C  
ATOM    517  N   LYS A 101     -14.312 124.732  24.103  1.00 19.44           N  
ATOM    518  CA  LYS A 101     -14.985 125.922  24.560  1.00 22.58           C  
ATOM    519  C   LYS A 101     -15.485 125.744  25.968  1.00 20.81           C  
ATOM    520  O   LYS A 101     -15.395 126.648  26.786  1.00 26.36           O  
ATOM    521  CB  LYS A 101     -16.106 126.253  23.597  1.00 28.85           C  
ATOM    522  CG  LYS A 101     -15.569 126.364  22.189  1.00 35.95           C  
ATOM    523  CD  LYS A 101     -16.542 126.969  21.236  1.00 42.92           C  
ATOM    524  CE  LYS A 101     -15.920 127.005  19.862  1.00 51.07           C  
ATOM    525  NZ  LYS A 101     -16.867 127.494  18.834  1.00 52.06           N  
ATOM    526  N   GLU A 102     -15.894 124.532  26.293  1.00 23.89           N  
ATOM    527  CA  GLU A 102     -16.388 124.264  27.630  1.00 25.81           C  
ATOM    528  C   GLU A 102     -15.277 124.083  28.648  1.00 25.02           C  
ATOM    529  O   GLU A 102     -15.500 124.233  29.835  1.00 30.94           O  
ATOM    530  CB  GLU A 102     -17.266 123.030  27.643  1.00 28.23           C  
ATOM    531  CG  GLU A 102     -18.521 123.141  26.864  1.00 34.61           C  
ATOM    532  CD  GLU A 102     -19.530 122.066  27.222  1.00 39.19           C  
ATOM    533  OE1 GLU A 102     -19.144 121.010  27.778  1.00 42.31           O  
ATOM    534  OE2 GLU A 102     -20.728 122.279  26.943  1.00 40.32           O  
ATOM    535  N   MET A 103     -14.076 123.764  28.203  1.00 24.76           N  
ATOM    536  CA  MET A 103     -12.987 123.558  29.146  1.00 23.62           C  
ATOM    537  C   MET A 103     -12.190 124.805  29.350  1.00 23.44           C  
ATOM    538  O   MET A 103     -11.593 125.001  30.396  1.00 26.67           O  
ATOM    539  CB  MET A 103     -12.054 122.476  28.651  1.00 26.82           C  
ATOM    540  CG  MET A 103     -12.728 121.171  28.453  1.00 26.12           C  
ATOM    541  SD  MET A 103     -11.540 119.883  28.420  1.00 27.13           S  
ATOM    542  CE  MET A 103     -11.071 119.936  26.717  1.00 19.51           C  
ATOM    543  N   GLN A 104     -12.202 125.662  28.345  1.00 25.69           N  
ATOM    544  CA  GLN A 104     -11.453 126.904  28.352  1.00 26.59           C  
ATOM    545  C   GLN A 104     -11.363 127.657  29.662  1.00 23.48           C  
ATOM    546  O   GLN A 104     -10.292 128.077  30.034  1.00 31.07           O  
ATOM    547  CB  GLN A 104     -11.970 127.841  27.260  1.00 25.55           C  
ATOM    548  CG  GLN A 104     -11.020 128.952  26.909  1.00 27.31           C  
ATOM    549  CD  GLN A 104     -11.667 130.084  26.121  1.00 32.40           C  
ATOM    550  OE1 GLN A 104     -12.772 129.957  25.612  1.00 32.45           O  
ATOM    551  NE2 GLN A 104     -10.964 131.206  26.026  1.00 30.77           N  
ATOM    552  N   ASN A 105     -12.465 127.811  30.384  1.00 26.61           N  
ATOM    553  CA  ASN A 105     -12.428 128.607  31.605  1.00 27.80           C  
ATOM    554  C   ASN A 105     -12.244 127.868  32.896  1.00 26.35           C  
ATOM    555  O   ASN A 105     -12.310 128.474  33.967  1.00 30.65           O  
ATOM    556  CB  ASN A 105     -13.644 129.530  31.659  1.00 34.00           C  
ATOM    557  CG  ASN A 105     -13.683 130.503  30.486  1.00 37.99           C  
ATOM    558  OD1 ASN A 105     -12.669 131.116  30.126  1.00 41.69           O  
ATOM    559  ND2 ASN A 105     -14.841 130.605  29.848  1.00 40.69           N  
ATOM    560  N   ARG A 106     -11.965 126.571  32.795  1.00 24.39           N  
ATOM    561  CA  ARG A 106     -11.762 125.708  33.956  1.00 22.90           C  
ATOM    562  C   ARG A 106     -10.451 125.986  34.662  1.00 19.25           C  
ATOM    563  O   ARG A 106      -9.456 126.348  34.037  1.00 18.68           O  
ATOM    564  CB  ARG A 106     -11.788 124.223  33.559  1.00 29.45           C  
ATOM    565  CG  ARG A 106     -13.094 123.669  33.034  1.00 35.07           C  
ATOM    566  CD  ARG A 106     -14.265 124.026  33.941  1.00 46.17           C  
ATOM    567  NE  ARG A 106     -15.177 124.944  33.256  1.00 59.99           N  
ATOM    568  CZ  ARG A 106     -15.623 126.095  33.751  1.00 64.58           C  
ATOM    569  NH1 ARG A 106     -15.268 126.491  34.969  1.00 69.05           N  
ATOM    570  NH2 ARG A 106     -16.383 126.884  32.997  1.00 66.30           N  
ATOM    571  N   THR A 107     -10.471 125.873  35.977  1.00 19.83           N  
ATOM    572  CA  THR A 107      -9.270 126.049  36.760  1.00 26.35           C  
ATOM    573  C   THR A 107      -8.877 124.660  37.276  1.00 27.07           C  
ATOM    574  O   THR A 107      -9.662 123.702  37.174  1.00 26.66           O  
ATOM    575  CB  THR A 107      -9.513 127.009  37.963  1.00 31.23           C  
ATOM    576  OG1 THR A 107     -10.498 126.456  38.851  1.00 29.65           O  
ATOM    577  CG2 THR A 107      -9.962 128.379  37.464  1.00 24.99           C  
ATOM    578  N   PHE A 108      -7.678 124.558  37.841  1.00 22.34           N  
ATOM    579  CA  PHE A 108      -7.205 123.299  38.393  1.00 20.39           C  
ATOM    580  C   PHE A 108      -8.191 122.890  39.500  1.00 22.51           C  
ATOM    581  O   PHE A 108      -8.636 121.736  39.579  1.00 18.99           O  
ATOM    582  CB  PHE A 108      -5.785 123.482  38.939  1.00 17.30           C  
ATOM    583  CG  PHE A 108      -5.381 122.434  39.890  1.00  8.57           C  
ATOM    584  CD1 PHE A 108      -5.003 121.198  39.419  1.00  9.18           C  
ATOM    585  CD2 PHE A 108      -5.457 122.654  41.258  1.00  5.80           C  
ATOM    586  CE1 PHE A 108      -4.721 120.190  40.303  1.00 13.26           C  
ATOM    587  CE2 PHE A 108      -5.177 121.661  42.151  1.00  4.11           C  
ATOM    588  CZ  PHE A 108      -4.811 120.425  41.675  1.00  5.80           C  
ATOM    589  N   GLN A 109      -8.613 123.888  40.272  1.00 20.17           N  
ATOM    590  CA  GLN A 109      -9.519 123.671  41.364  1.00 19.90           C  
ATOM    591  C   GLN A 109     -10.892 123.254  40.876  1.00 17.76           C  
ATOM    592  O   GLN A 109     -11.588 122.523  41.559  1.00 23.75           O  
ATOM    593  CB  GLN A 109      -9.579 124.914  42.242  1.00 19.53           C  
ATOM    594  CG  GLN A 109      -8.255 125.206  42.968  1.00 15.34           C  
ATOM    595  CD  GLN A 109      -7.396 126.215  42.238  1.00 13.24           C  
ATOM    596  OE1 GLN A 109      -7.575 126.483  41.050  1.00 17.06           O  
ATOM    597  NE2 GLN A 109      -6.464 126.783  42.941  1.00 12.99           N  
ATOM    598  N   ASP A 110     -11.267 123.663  39.674  1.00 15.23           N  
ATOM    599  CA  ASP A 110     -12.593 123.295  39.149  1.00 18.15           C  
ATOM    600  C   ASP A 110     -12.559 121.836  38.820  1.00 18.03           C  
ATOM    601  O   ASP A 110     -13.463 121.090  39.092  1.00 16.31           O  
ATOM    602  CB  ASP A 110     -12.913 124.014  37.842  1.00 19.42           C  
ATOM    603  CG  ASP A 110     -13.208 125.483  38.015  1.00 23.04           C  
ATOM    604  OD1 ASP A 110     -13.307 126.000  39.137  1.00 30.16           O  
ATOM    605  OD2 ASP A 110     -13.352 126.149  36.990  1.00 29.97           O  
ATOM    606  N   CYS A 111     -11.496 121.468  38.144  1.00 25.87           N  
ATOM    607  CA  CYS A 111     -11.251 120.122  37.707  1.00 23.84           C  
ATOM    608  C   CYS A 111     -11.336 119.166  38.848  1.00 25.42           C  
ATOM    609  O   CYS A 111     -12.174 118.269  38.882  1.00 26.70           O  
ATOM    610  CB  CYS A 111      -9.858 120.070  37.124  1.00 11.17           C  
ATOM    611  SG  CYS A 111      -9.930 120.739  35.513  1.00 29.26           S  
ATOM    612  N   TYR A 112     -10.520 119.447  39.838  1.00 28.60           N  
ATOM    613  CA  TYR A 112     -10.428 118.589  40.975  1.00 33.08           C  
ATOM    614  C   TYR A 112     -11.757 118.459  41.685  1.00 36.25           C  
ATOM    615  O   TYR A 112     -12.385 117.402  41.616  1.00 43.64           O  
ATOM    616  CB  TYR A 112      -9.293 119.037  41.899  1.00 32.85           C  
ATOM    617  CG  TYR A 112      -8.655 117.854  42.522  1.00 30.16           C  
ATOM    618  CD1 TYR A 112      -9.214 117.305  43.670  1.00 30.20           C  
ATOM    619  CD2 TYR A 112      -7.624 117.150  41.865  1.00 29.47           C  
ATOM    620  CE1 TYR A 112      -8.816 116.101  44.147  1.00 33.52           C  
ATOM    621  CE2 TYR A 112      -7.197 115.932  42.340  1.00 28.92           C  
ATOM    622  CZ  TYR A 112      -7.818 115.406  43.498  1.00 36.55           C  
ATOM    623  OH  TYR A 112      -7.496 114.193  44.047  1.00 43.04           O  
ATOM    624  N   SER A 113     -12.221 119.548  42.286  1.00 38.01           N  
ATOM    625  CA  SER A 113     -13.487 119.593  43.029  1.00 41.81           C  
ATOM    626  C   SER A 113     -14.743 119.185  42.228  1.00 45.56           C  
ATOM    627  O   SER A 113     -15.669 118.548  42.747  1.00 48.86           O  
ATOM    628  CB  SER A 113     -13.663 120.999  43.591  1.00 44.24           C  
ATOM    629  OG  SER A 113     -12.439 121.424  44.183  1.00 48.34           O  
ATOM    630  N   GLY A 114     -14.766 119.550  40.955  1.00 47.71           N  
ATOM    631  CA  GLY A 114     -15.902 119.223  40.119  1.00 50.60           C  
ATOM    632  C   GLY A 114     -15.826 117.872  39.429  1.00 53.78           C  
ATOM    633  O   GLY A 114     -16.682 117.570  38.594  1.00 59.37           O  
ATOM    634  N   LYS A 115     -14.829 117.057  39.756  1.00 54.81           N  
ATOM    635  CA  LYS A 115     -14.665 115.723  39.145  1.00 53.23           C  
ATOM    636  C   LYS A 115     -14.849 115.815  37.631  1.00 52.30           C  
ATOM    637  O   LYS A 115     -15.635 115.066  37.025  1.00 50.41           O  
ATOM    638  CB  LYS A 115     -15.687 114.743  39.717  1.00 54.26           C  
ATOM    639  CG  LYS A 115     -15.717 114.658  41.231  1.00 60.39           C  
ATOM    640  CD  LYS A 115     -16.743 113.609  41.686  1.00 65.24           C  
ATOM    641  CE  LYS A 115     -17.072 113.737  43.181  1.00 68.06           C  
ATOM    642  NZ  LYS A 115     -17.881 112.586  43.708  1.00 68.47           N  
ATOM    643  N   PHE A 116     -14.136 116.770  37.041  1.00 50.94           N  
ATOM    644  CA  PHE A 116     -14.183 117.039  35.600  1.00 48.47           C  
ATOM    645  C   PHE A 116     -13.969 115.767  34.741  1.00 46.20           C  
ATOM    646  O   PHE A 116     -13.020 115.006  34.962  1.00 39.00           O  
ATOM    647  CB  PHE A 116     -13.144 118.123  35.268  1.00 45.75           C  
ATOM    648  CG  PHE A 116     -13.353 118.778  33.949  1.00 47.16           C  
ATOM    649  CD1 PHE A 116     -14.637 119.123  33.537  1.00 53.13           C  
ATOM    650  CD2 PHE A 116     -12.262 119.061  33.111  1.00 48.97           C  
ATOM    651  CE1 PHE A 116     -14.849 119.745  32.293  1.00 56.81           C  
ATOM    652  CE2 PHE A 116     -12.447 119.677  31.875  1.00 49.02           C  
ATOM    653  CZ  PHE A 116     -13.750 120.019  31.459  1.00 54.30           C  
ATOM    654  N   LEU A 117     -14.880 115.547  33.794  1.00 43.44           N  
ATOM    655  CA  LEU A 117     -14.831 114.403  32.886  1.00 46.25           C  
ATOM    656  C   LEU A 117     -15.226 113.064  33.526  1.00 47.74           C  
ATOM    657  O   LEU A 117     -14.998 111.990  32.942  1.00 49.83           O  
ATOM    658  CB  LEU A 117     -13.442 114.273  32.229  1.00 44.36           C  
ATOM    659  CG  LEU A 117     -13.251 114.716  30.775  1.00 40.75           C  
ATOM    660  CD1 LEU A 117     -13.027 116.172  30.659  1.00 34.17           C  
ATOM    661  CD2 LEU A 117     -12.080 114.010  30.228  1.00 36.17           C  
ATOM    662  N   SER A 118     -15.920 113.123  34.658  1.00 49.70           N  
ATOM    663  CA  SER A 118     -16.346 111.915  35.380  1.00 51.24           C  
ATOM    664  C   SER A 118     -17.359 111.035  34.664  1.00 53.44           C  
ATOM    665  O   SER A 118     -17.401 109.822  34.876  1.00 59.33           O  
ATOM    666  CB  SER A 118     -16.949 112.286  36.730  1.00 47.25           C  
ATOM    667  OG  SER A 118     -15.979 112.304  37.747  1.00 47.17           O  
ATOM    668  N   HIS A 119     -18.222 111.645  33.862  1.00 49.57           N  
ATOM    669  CA  HIS A 119     -19.236 110.865  33.189  1.00 47.74           C  
ATOM    670  C   HIS A 119     -18.788 110.377  31.833  1.00 41.95           C  
ATOM    671  O   HIS A 119     -19.506 109.647  31.161  1.00 38.00           O  
ATOM    672  CB  HIS A 119     -20.527 111.671  33.127  1.00 56.06           C  
ATOM    673  CG  HIS A 119     -21.030 112.065  34.484  1.00 63.14           C  
ATOM    674  ND1 HIS A 119     -21.110 113.375  34.901  1.00 67.83           N  
ATOM    675  CD2 HIS A 119     -21.394 111.311  35.544  1.00 65.83           C  
ATOM    676  CE1 HIS A 119     -21.493 113.410  36.164  1.00 70.62           C  
ATOM    677  NE2 HIS A 119     -21.673 112.171  36.578  1.00 70.01           N  
ATOM    678  N   TRP A 120     -17.538 110.688  31.515  1.00 40.42           N  
ATOM    679  CA  TRP A 120     -16.910 110.336  30.244  1.00 40.48           C  
ATOM    680  C   TRP A 120     -16.689 108.870  29.996  1.00 38.37           C  
ATOM    681  O   TRP A 120     -16.790 108.417  28.855  1.00 37.41           O  
ATOM    682  CB  TRP A 120     -15.581 111.044  30.103  1.00 44.50           C  
ATOM    683  CG  TRP A 120     -15.711 112.273  29.325  1.00 52.25           C  
ATOM    684  CD1 TRP A 120     -16.635 113.258  29.506  1.00 53.63           C  
ATOM    685  CD2 TRP A 120     -14.930 112.657  28.185  1.00 54.85           C  
ATOM    686  NE1 TRP A 120     -16.481 114.232  28.550  1.00 58.53           N  
ATOM    687  CE2 TRP A 120     -15.433 113.888  27.730  1.00 58.24           C  
ATOM    688  CE3 TRP A 120     -13.845 112.083  27.515  1.00 51.25           C  
ATOM    689  CZ2 TRP A 120     -14.893 114.552  26.624  1.00 57.33           C  
ATOM    690  CZ3 TRP A 120     -13.303 112.746  26.420  1.00 51.50           C  
ATOM    691  CH2 TRP A 120     -13.825 113.964  25.989  1.00 56.88           C  
ATOM    692  N   ASP A 121     -16.332 108.127  31.040  1.00 34.52           N  
ATOM    693  CA  ASP A 121     -16.109 106.706  30.841  1.00 38.20           C  
ATOM    694  C   ASP A 121     -17.208 105.802  31.416  1.00 34.50           C  
ATOM    695  O   ASP A 121     -16.950 104.740  31.976  1.00 35.11           O  
ATOM    696  CB  ASP A 121     -14.710 106.285  31.304  1.00 40.84           C  
ATOM    697  CG  ASP A 121     -14.513 106.423  32.794  1.00 46.23           C  
ATOM    698  OD1 ASP A 121     -15.480 106.284  33.581  1.00 45.21           O  
ATOM    699  OD2 ASP A 121     -13.343 106.648  33.171  1.00 58.49           O  
ATOM    700  N   HIS A 122     -18.450 106.226  31.262  1.00 29.08           N  
ATOM    701  CA  HIS A 122     -19.562 105.426  31.728  1.00 24.32           C  
ATOM    702  C   HIS A 122     -19.717 104.280  30.742  1.00 19.30           C  
ATOM    703  O   HIS A 122     -20.182 103.213  31.101  1.00 14.96           O  
ATOM    704  CB  HIS A 122     -20.838 106.273  31.764  1.00 28.15           C  
ATOM    705  CG  HIS A 122     -22.074 105.481  32.066  1.00 30.61           C  
ATOM    706  ND1 HIS A 122     -22.995 105.148  31.093  1.00 33.02           N  
ATOM    707  CD2 HIS A 122     -22.521 104.928  33.215  1.00 33.55           C  
ATOM    708  CE1 HIS A 122     -23.957 104.421  31.630  1.00 32.91           C  
ATOM    709  NE2 HIS A 122     -23.698 104.273  32.917  1.00 35.78           N  
ATOM    710  N   ILE A 123     -19.327 104.520  29.498  1.00 14.20           N  
ATOM    711  CA  ILE A 123     -19.405 103.535  28.444  1.00 17.24           C  
ATOM    712  C   ILE A 123     -18.665 102.252  28.842  1.00 18.66           C  
ATOM    713  O   ILE A 123     -19.037 101.161  28.424  1.00 22.26           O  
ATOM    714  CB  ILE A 123     -18.814 104.108  27.146  1.00 15.77           C  
ATOM    715  CG1 ILE A 123     -19.027 103.156  26.000  1.00  9.64           C  
ATOM    716  CG2 ILE A 123     -17.334 104.418  27.296  1.00 15.51           C  
ATOM    717  CD1 ILE A 123     -18.677 103.791  24.678  1.00 12.87           C  
ATOM    718  N   THR A 124     -17.663 102.390  29.707  1.00 18.39           N  
ATOM    719  CA  THR A 124     -16.864 101.264  30.166  1.00 16.99           C  
ATOM    720  C   THR A 124     -17.601 100.443  31.227  1.00 19.19           C  
ATOM    721  O   THR A 124     -17.106  99.425  31.674  1.00 25.53           O  
ATOM    722  CB  THR A 124     -15.483 101.713  30.744  1.00 13.46           C  
ATOM    723  OG1 THR A 124     -15.681 102.377  31.995  1.00 19.40           O  
ATOM    724  CG2 THR A 124     -14.770 102.638  29.803  1.00  8.54           C  
ATOM    725  N   ARG A 125     -18.765 100.896  31.660  1.00 21.20           N  
ATOM    726  CA  ARG A 125     -19.538 100.159  32.648  1.00 20.30           C  
ATOM    727  C   ARG A 125     -20.633  99.352  31.946  1.00 18.18           C  
ATOM    728  O   ARG A 125     -21.419  98.664  32.579  1.00 20.44           O  
ATOM    729  CB  ARG A 125     -20.158 101.101  33.681  1.00 30.83           C  
ATOM    730  CG  ARG A 125     -19.132 101.947  34.424  1.00 49.03           C  
ATOM    731  CD  ARG A 125     -19.542 102.322  35.849  1.00 62.85           C  
ATOM    732  NE  ARG A 125     -20.648 103.270  35.910  1.00 79.18           N  
ATOM    733  CZ  ARG A 125     -21.844 102.984  36.415  1.00 90.55           C  
ATOM    734  NH1 ARG A 125     -22.096 101.775  36.903  1.00 97.11           N  
ATOM    735  NH2 ARG A 125     -22.795 103.905  36.441  1.00 95.92           N  
ATOM    736  N   ILE A 126     -20.695  99.444  30.630  1.00 14.09           N  
ATOM    737  CA  ILE A 126     -21.706  98.740  29.868  1.00 14.23           C  
ATOM    738  C   ILE A 126     -21.222  97.320  29.677  1.00 17.51           C  
ATOM    739  O   ILE A 126     -20.099  97.109  29.200  1.00 20.67           O  
ATOM    740  CB  ILE A 126     -21.904  99.434  28.494  1.00 15.09           C  
ATOM    741  CG1 ILE A 126     -22.469 100.846  28.701  1.00 12.09           C  
ATOM    742  CG2 ILE A 126     -22.821  98.608  27.589  1.00 14.51           C  
ATOM    743  CD1 ILE A 126     -23.753 100.892  29.533  1.00 15.29           C  
ATOM    744  N   LYS A 127     -22.052  96.350  30.060  1.00 18.91           N  
ATOM    745  CA  LYS A 127     -21.694  94.920  29.921  1.00 15.74           C  
ATOM    746  C   LYS A 127     -21.764  94.379  28.478  1.00 18.05           C  
ATOM    747  O   LYS A 127     -20.940  93.551  28.070  1.00 18.66           O  
ATOM    748  CB  LYS A 127     -22.579  94.050  30.814  1.00 14.71           C  
ATOM    749  CG  LYS A 127     -22.472  94.361  32.285  1.00 25.09           C  
ATOM    750  CD  LYS A 127     -21.038  94.204  32.765  1.00 42.17           C  
ATOM    751  CE  LYS A 127     -20.857  94.868  34.132  1.00 54.80           C  
ATOM    752  NZ  LYS A 127     -19.413  95.029  34.538  1.00 57.83           N  
ATOM    753  N   LYS A 128     -22.744  94.839  27.705  1.00 15.25           N  
ATOM    754  CA  LYS A 128     -22.904  94.378  26.326  1.00 12.42           C  
ATOM    755  C   LYS A 128     -21.809  94.978  25.529  1.00 11.38           C  
ATOM    756  O   LYS A 128     -21.342  96.048  25.851  1.00 21.59           O  
ATOM    757  CB  LYS A 128     -24.240  94.844  25.741  1.00 16.53           C  
ATOM    758  CG  LYS A 128     -25.440  94.394  26.546  1.00 15.16           C  
ATOM    759  CD  LYS A 128     -26.743  94.735  25.893  1.00 13.10           C  
ATOM    760  CE  LYS A 128     -27.854  94.116  26.719  1.00 14.24           C  
ATOM    761  NZ  LYS A 128     -29.196  94.595  26.364  1.00 14.37           N  
ATOM    762  N   PRO A 129     -21.367  94.322  24.480  1.00 10.35           N  
ATOM    763  CA  PRO A 129     -20.282  94.839  23.638  1.00 10.41           C  
ATOM    764  C   PRO A 129     -20.678  96.117  22.904  1.00 12.36           C  
ATOM    765  O   PRO A 129     -21.845  96.277  22.535  1.00 14.30           O  
ATOM    766  CB  PRO A 129     -20.039  93.714  22.633  1.00  4.41           C  
ATOM    767  CG  PRO A 129     -20.500  92.529  23.356  1.00  7.36           C  
ATOM    768  CD  PRO A 129     -21.761  92.978  24.037  1.00  3.61           C  
ATOM    769  N   VAL A 130     -19.704  97.009  22.708  1.00 14.38           N  
ATOM    770  CA  VAL A 130     -19.899  98.254  21.984  1.00  7.04           C  
ATOM    771  C   VAL A 130     -18.833  98.258  20.918  1.00  9.58           C  
ATOM    772  O   VAL A 130     -17.665  98.013  21.201  1.00 12.10           O  
ATOM    773  CB  VAL A 130     -19.711  99.515  22.841  1.00  5.28           C  
ATOM    774  CG1 VAL A 130     -20.115 100.716  22.034  1.00  3.16           C  
ATOM    775  CG2 VAL A 130     -20.565  99.482  24.074  1.00  2.00           C  
ATOM    776  N   ILE A 131     -19.248  98.497  19.680  1.00 10.80           N  
ATOM    777  CA  ILE A 131     -18.346  98.533  18.545  1.00 10.03           C  
ATOM    778  C   ILE A 131     -18.411  99.966  18.043  1.00 16.28           C  
ATOM    779  O   ILE A 131     -19.509 100.516  17.888  1.00 16.56           O  
ATOM    780  CB  ILE A 131     -18.842  97.603  17.394  1.00 11.42           C  
ATOM    781  CG1 ILE A 131     -18.856  96.154  17.860  1.00  8.79           C  
ATOM    782  CG2 ILE A 131     -17.967  97.744  16.125  1.00  7.83           C  
ATOM    783  CD1 ILE A 131     -19.302  95.188  16.788  1.00 14.06           C  
ATOM    784  N   ALA A 132     -17.241 100.573  17.832  1.00 16.35           N  
ATOM    785  CA  ALA A 132     -17.136 101.935  17.341  1.00 11.32           C  
ATOM    786  C   ALA A 132     -16.918 101.908  15.844  1.00 11.96           C  
ATOM    787  O   ALA A 132     -15.979 101.275  15.359  1.00 14.75           O  
ATOM    788  CB  ALA A 132     -15.987 102.633  18.005  1.00 13.76           C  
ATOM    789  N   ALA A 133     -17.800 102.565  15.101  1.00 10.91           N  
ATOM    790  CA  ALA A 133     -17.691 102.602  13.654  1.00 12.05           C  
ATOM    791  C   ALA A 133     -17.161 103.991  13.360  1.00 16.03           C  
ATOM    792  O   ALA A 133     -17.913 104.960  13.221  1.00 17.15           O  
ATOM    793  CB  ALA A 133     -19.061 102.379  13.020  1.00  9.25           C  
ATOM    794  N   VAL A 134     -15.839 104.088  13.323  1.00 18.56           N  
ATOM    795  CA  VAL A 134     -15.172 105.359  13.138  1.00 14.54           C  
ATOM    796  C   VAL A 134     -14.973 105.811  11.710  1.00 18.89           C  
ATOM    797  O   VAL A 134     -14.158 105.254  10.970  1.00 21.07           O  
ATOM    798  CB  VAL A 134     -13.817 105.396  13.860  1.00 11.63           C  
ATOM    799  CG1 VAL A 134     -13.106 106.744  13.590  1.00  9.49           C  
ATOM    800  CG2 VAL A 134     -14.019 105.178  15.349  1.00  8.00           C  
ATOM    801  N   ASN A 135     -15.709 106.859  11.339  1.00 21.09           N  
ATOM    802  CA  ASN A 135     -15.600 107.460  10.012  1.00 18.51           C  
ATOM    803  C   ASN A 135     -15.006 108.834  10.247  1.00 16.56           C  
ATOM    804  O   ASN A 135     -15.402 109.523  11.192  1.00 18.00           O  
ATOM    805  CB  ASN A 135     -16.986 107.622   9.381  1.00 15.67           C  
ATOM    806  CG  ASN A 135     -17.195 106.723   8.184  1.00 13.98           C  
ATOM    807  OD1 ASN A 135     -16.246 106.391   7.458  1.00 14.42           O  
ATOM    808  ND2 ASN A 135     -18.453 106.372   7.929  1.00 12.71           N  
ATOM    809  N   GLY A 136     -14.011 109.198   9.455  1.00 15.30           N  
ATOM    810  CA  GLY A 136     -13.412 110.510   9.591  1.00 16.83           C  
ATOM    811  C   GLY A 136     -12.587 110.749  10.831  1.00 15.83           C  
ATOM    812  O   GLY A 136     -11.886 109.867  11.286  1.00 26.16           O  
ATOM    813  N   TYR A 137     -12.670 111.946  11.386  1.00 20.06           N  
ATOM    814  CA  TYR A 137     -11.884 112.316  12.558  1.00 16.88           C  
ATOM    815  C   TYR A 137     -12.315 111.670  13.834  1.00 18.34           C  
ATOM    816  O   TYR A 137     -13.491 111.741  14.197  1.00 20.06           O  
ATOM    817  CB  TYR A 137     -11.952 113.829  12.818  1.00 16.21           C  
ATOM    818  CG  TYR A 137     -11.306 114.691  11.794  1.00 15.74           C  
ATOM    819  CD1 TYR A 137      -9.933 114.638  11.579  1.00 15.78           C  
ATOM    820  CD2 TYR A 137     -12.073 115.539  10.996  1.00 21.18           C  
ATOM    821  CE1 TYR A 137      -9.336 115.390  10.595  1.00 20.65           C  
ATOM    822  CE2 TYR A 137     -11.484 116.309   9.997  1.00 23.10           C  
ATOM    823  CZ  TYR A 137     -10.111 116.230   9.802  1.00 24.94           C  
ATOM    824  OH  TYR A 137      -9.518 116.997   8.837  1.00 32.21           O  
ATOM    825  N   ALA A 138     -11.345 111.105  14.545  1.00 17.24           N  
ATOM    826  CA  ALA A 138     -11.564 110.517  15.865  1.00 17.46           C  
ATOM    827  C   ALA A 138     -10.346 111.051  16.621  1.00 20.57           C  
ATOM    828  O   ALA A 138      -9.325 110.365  16.747  1.00 20.83           O  
ATOM    829  CB  ALA A 138     -11.542 109.009  15.818  1.00 14.54           C  
ATOM    830  N   LEU A 139     -10.445 112.306  17.068  1.00 16.24           N  
ATOM    831  CA  LEU A 139      -9.349 112.978  17.736  1.00  9.07           C  
ATOM    832  C   LEU A 139      -9.632 113.300  19.163  1.00  9.54           C  
ATOM    833  O   LEU A 139     -10.778 113.442  19.551  1.00 15.19           O  
ATOM    834  CB  LEU A 139      -8.988 114.274  17.006  1.00  6.27           C  
ATOM    835  CG  LEU A 139      -8.986 114.270  15.474  1.00  9.49           C  
ATOM    836  CD1 LEU A 139      -8.721 115.661  14.965  1.00 11.68           C  
ATOM    837  CD2 LEU A 139      -7.955 113.330  14.926  1.00  9.26           C  
ATOM    838  N   GLY A 140      -8.577 113.375  19.964  1.00 11.89           N  
ATOM    839  CA  GLY A 140      -8.735 113.719  21.363  1.00 12.08           C  
ATOM    840  C   GLY A 140      -9.761 112.857  22.063  1.00 12.89           C  
ATOM    841  O   GLY A 140      -9.725 111.622  21.967  1.00 21.62           O  
ATOM    842  N   GLY A 141     -10.701 113.490  22.738  1.00 14.31           N  
ATOM    843  CA  GLY A 141     -11.735 112.743  23.428  1.00  6.45           C  
ATOM    844  C   GLY A 141     -12.480 111.789  22.505  1.00  6.62           C  
ATOM    845  O   GLY A 141     -13.061 110.822  22.963  1.00  8.95           O  
ATOM    846  N   GLY A 142     -12.451 112.058  21.207  1.00  6.00           N  
ATOM    847  CA  GLY A 142     -13.111 111.209  20.239  1.00  9.09           C  
ATOM    848  C   GLY A 142     -12.351 109.918  20.038  1.00 10.65           C  
ATOM    849  O   GLY A 142     -12.951 108.882  19.888  1.00 14.62           O  
ATOM    850  N   CYS A 143     -11.027 109.983  20.022  1.00 14.36           N  
ATOM    851  CA  CYS A 143     -10.178 108.808  19.855  1.00 10.89           C  
ATOM    852  C   CYS A 143     -10.362 107.976  21.096  1.00 11.29           C  
ATOM    853  O   CYS A 143     -10.589 106.771  21.025  1.00 11.91           O  
ATOM    854  CB  CYS A 143      -8.713 109.212  19.751  1.00 11.59           C  
ATOM    855  SG  CYS A 143      -7.570 107.843  19.383  1.00 13.60           S  
ATOM    856  N   GLU A 144     -10.318 108.641  22.236  1.00  6.48           N  
ATOM    857  CA  GLU A 144     -10.465 107.968  23.497  1.00  7.77           C  
ATOM    858  C   GLU A 144     -11.797 107.276  23.616  1.00  8.65           C  
ATOM    859  O   GLU A 144     -11.871 106.194  24.176  1.00 16.79           O  
ATOM    860  CB  GLU A 144     -10.286 108.950  24.635  1.00 10.22           C  
ATOM    861  CG  GLU A 144      -8.908 109.585  24.667  1.00  9.86           C  
ATOM    862  CD  GLU A 144      -8.827 110.634  25.744  1.00 13.45           C  
ATOM    863  OE1 GLU A 144      -9.826 111.346  25.927  1.00  9.71           O  
ATOM    864  OE2 GLU A 144      -7.786 110.733  26.430  1.00 11.34           O  
ATOM    865  N   LEU A 145     -12.859 107.901  23.121  1.00 13.14           N  
ATOM    866  CA  LEU A 145     -14.205 107.299  23.174  1.00 12.54           C  
ATOM    867  C   LEU A 145     -14.220 106.006  22.331  1.00 12.30           C  
ATOM    868  O   LEU A 145     -14.742 104.982  22.763  1.00 10.46           O  
ATOM    869  CB  LEU A 145     -15.266 108.281  22.662  1.00 12.43           C  
ATOM    870  CG  LEU A 145     -16.722 107.807  22.573  1.00 11.51           C  
ATOM    871  CD1 LEU A 145     -17.257 107.516  23.935  1.00  5.15           C  
ATOM    872  CD2 LEU A 145     -17.579 108.867  21.882  1.00  9.57           C  
ATOM    873  N   ALA A 146     -13.638 106.067  21.140  1.00  2.61           N  
ATOM    874  CA  ALA A 146     -13.563 104.935  20.255  1.00  6.53           C  
ATOM    875  C   ALA A 146     -12.731 103.829  20.937  1.00 13.89           C  
ATOM    876  O   ALA A 146     -13.067 102.633  20.888  1.00 15.25           O  
ATOM    877  CB  ALA A 146     -12.917 105.347  18.938  1.00  2.00           C  
ATOM    878  N   MET A 147     -11.653 104.225  21.599  1.00 12.39           N  
ATOM    879  CA  MET A 147     -10.811 103.251  22.268  1.00  7.07           C  
ATOM    880  C   MET A 147     -11.502 102.629  23.471  1.00  7.76           C  
ATOM    881  O   MET A 147     -11.146 101.527  23.888  1.00 11.58           O  
ATOM    882  CB  MET A 147      -9.473 103.869  22.672  1.00  9.12           C  
ATOM    883  CG  MET A 147      -8.623 104.248  21.483  1.00  5.93           C  
ATOM    884  SD  MET A 147      -6.952 104.636  21.929  1.00 10.40           S  
ATOM    885  CE  MET A 147      -7.166 106.154  23.013  1.00  4.61           C  
ATOM    886  N   MET A 148     -12.473 103.334  24.053  1.00  7.41           N  
ATOM    887  CA  MET A 148     -13.193 102.798  25.207  1.00  4.02           C  
ATOM    888  C   MET A 148     -14.087 101.673  24.715  1.00  9.60           C  
ATOM    889  O   MET A 148     -14.500 100.798  25.471  1.00 13.93           O  
ATOM    890  CB  MET A 148     -14.028 103.866  25.899  1.00  3.74           C  
ATOM    891  CG  MET A 148     -13.273 104.681  26.930  1.00 12.29           C  
ATOM    892  SD  MET A 148     -14.266 105.857  27.878  1.00 20.71           S  
ATOM    893  CE  MET A 148     -13.326 107.288  27.672  1.00 20.54           C  
ATOM    894  N   CYS A 149     -14.388 101.703  23.428  1.00  9.26           N  
ATOM    895  CA  CYS A 149     -15.222 100.688  22.830  1.00 11.02           C  
ATOM    896  C   CYS A 149     -14.419  99.396  22.769  1.00 15.20           C  
ATOM    897  O   CYS A 149     -13.182  99.402  22.736  1.00 12.90           O  
ATOM    898  CB  CYS A 149     -15.701 101.128  21.434  1.00  5.94           C  
ATOM    899  SG  CYS A 149     -16.880 102.535  21.512  1.00 16.10           S  
ATOM    900  N   ASP A 150     -15.150  98.289  22.710  1.00 15.14           N  
ATOM    901  CA  ASP A 150     -14.555  96.972  22.659  1.00 10.83           C  
ATOM    902  C   ASP A 150     -13.878  96.662  21.344  1.00  7.13           C  
ATOM    903  O   ASP A 150     -12.812  96.049  21.316  1.00  9.55           O  
ATOM    904  CB  ASP A 150     -15.625  95.942  22.951  1.00  7.18           C  
ATOM    905  CG  ASP A 150     -16.284  96.160  24.291  1.00 11.33           C  
ATOM    906  OD1 ASP A 150     -15.557  96.272  25.293  1.00  9.08           O  
ATOM    907  OD2 ASP A 150     -17.532  96.213  24.351  1.00 17.00           O  
ATOM    908  N   ILE A 151     -14.518  97.051  20.251  1.00  7.70           N  
ATOM    909  CA  ILE A 151     -14.000  96.802  18.912  1.00  2.00           C  
ATOM    910  C   ILE A 151     -14.060  98.108  18.126  1.00  6.17           C  
ATOM    911  O   ILE A 151     -14.984  98.898  18.304  1.00  7.80           O  
ATOM    912  CB  ILE A 151     -14.909  95.783  18.172  1.00  2.00           C  
ATOM    913  CG1 ILE A 151     -14.989  94.465  18.944  1.00  8.09           C  
ATOM    914  CG2 ILE A 151     -14.406  95.531  16.797  1.00  2.00           C  
ATOM    915  CD1 ILE A 151     -16.065  93.523  18.446  1.00  5.12           C  
ATOM    916  N   ILE A 152     -13.069  98.362  17.283  1.00  8.09           N  
ATOM    917  CA  ILE A 152     -13.114  99.548  16.456  1.00  8.98           C  
ATOM    918  C   ILE A 152     -13.001  99.201  14.989  1.00  8.74           C  
ATOM    919  O   ILE A 152     -12.040  98.556  14.571  1.00  8.43           O  
ATOM    920  CB  ILE A 152     -11.976 100.554  16.713  1.00 12.84           C  
ATOM    921  CG1 ILE A 152     -12.009 101.083  18.148  1.00 15.61           C  
ATOM    922  CG2 ILE A 152     -12.139 101.731  15.756  1.00  5.92           C  
ATOM    923  CD1 ILE A 152     -10.963 102.152  18.392  1.00  9.25           C  
ATOM    924  N   TYR A 153     -14.007  99.610  14.224  1.00 13.37           N  
ATOM    925  CA  TYR A 153     -14.014  99.429  12.776  1.00 16.25           C  
ATOM    926  C   TYR A 153     -13.780 100.850  12.244  1.00 16.85           C  
ATOM    927  O   TYR A 153     -14.339 101.817  12.776  1.00 12.79           O  
ATOM    928  CB  TYR A 153     -15.354  98.893  12.280  1.00 19.18           C  
ATOM    929  CG  TYR A 153     -15.504  97.402  12.341  1.00 22.17           C  
ATOM    930  CD1 TYR A 153     -14.654  96.605  13.127  1.00 23.38           C  
ATOM    931  CD2 TYR A 153     -16.500  96.780  11.620  1.00 21.21           C  
ATOM    932  CE1 TYR A 153     -14.814  95.225  13.178  1.00 22.84           C  
ATOM    933  CE2 TYR A 153     -16.668  95.422  11.663  1.00 26.59           C  
ATOM    934  CZ  TYR A 153     -15.834  94.638  12.439  1.00 27.66           C  
ATOM    935  OH  TYR A 153     -16.077  93.284  12.469  1.00 29.64           O  
ATOM    936  N   ALA A 154     -12.951 100.973  11.215  1.00 14.76           N  
ATOM    937  CA  ALA A 154     -12.624 102.278  10.675  1.00 15.44           C  
ATOM    938  C   ALA A 154     -12.931 102.443   9.187  1.00 16.91           C  
ATOM    939  O   ALA A 154     -12.664 101.541   8.394  1.00 18.12           O  
ATOM    940  CB  ALA A 154     -11.155 102.568  10.929  1.00  9.56           C  
ATOM    941  N   GLY A 155     -13.466 103.615   8.823  1.00 15.84           N  
ATOM    942  CA  GLY A 155     -13.768 103.926   7.441  1.00 15.58           C  
ATOM    943  C   GLY A 155     -12.451 104.163   6.725  1.00 17.61           C  
ATOM    944  O   GLY A 155     -11.447 104.486   7.363  1.00 19.03           O  
ATOM    945  N   GLU A 156     -12.425 104.040   5.409  1.00 20.86           N  
ATOM    946  CA  GLU A 156     -11.171 104.226   4.702  1.00 26.75           C  
ATOM    947  C   GLU A 156     -10.524 105.584   4.920  1.00 26.53           C  
ATOM    948  O   GLU A 156      -9.295 105.699   4.893  1.00 29.05           O  
ATOM    949  CB  GLU A 156     -11.343 103.964   3.220  1.00 27.65           C  
ATOM    950  CG  GLU A 156     -11.091 102.539   2.838  1.00 42.40           C  
ATOM    951  CD  GLU A 156     -11.743 102.153   1.511  1.00 53.61           C  
ATOM    952  OE1 GLU A 156     -12.506 102.970   0.946  1.00 58.92           O  
ATOM    953  OE2 GLU A 156     -11.505 101.013   1.038  1.00 59.97           O  
ATOM    954  N   LYS A 157     -11.350 106.597   5.167  1.00 24.94           N  
ATOM    955  CA  LYS A 157     -10.868 107.970   5.362  1.00 26.60           C  
ATOM    956  C   LYS A 157     -10.737 108.382   6.831  1.00 26.74           C  
ATOM    957  O   LYS A 157     -10.576 109.567   7.122  1.00 26.57           O  
ATOM    958  CB  LYS A 157     -11.814 108.964   4.672  1.00 28.85           C  
ATOM    959  CG  LYS A 157     -11.967 108.802   3.168  1.00 36.83           C  
ATOM    960  CD  LYS A 157     -10.805 109.407   2.408  1.00 50.33           C  
ATOM    961  CE  LYS A 157     -11.122 109.574   0.904  1.00 63.50           C  
ATOM    962  NZ  LYS A 157     -12.075 110.701   0.568  1.00 68.18           N  
ATOM    963  N   ALA A 158     -10.831 107.428   7.760  1.00 24.09           N  
ATOM    964  CA  ALA A 158     -10.735 107.753   9.186  1.00 17.90           C  
ATOM    965  C   ALA A 158      -9.342 108.196   9.570  1.00 14.82           C  
ATOM    966  O   ALA A 158      -8.368 107.860   8.893  1.00 11.81           O  
ATOM    967  CB  ALA A 158     -11.183 106.579  10.080  1.00 18.36           C  
ATOM    968  N   GLN A 159      -9.273 108.978  10.644  1.00 11.13           N  
ATOM    969  CA  GLN A 159      -8.012 109.507  11.163  1.00 13.77           C  
ATOM    970  C   GLN A 159      -8.097 109.536  12.655  1.00  9.18           C  
ATOM    971  O   GLN A 159      -9.119 109.902  13.224  1.00 10.69           O  
ATOM    972  CB  GLN A 159      -7.732 110.916  10.646  1.00 16.61           C  
ATOM    973  CG  GLN A 159      -7.216 110.966   9.230  1.00 21.89           C  
ATOM    974  CD  GLN A 159      -6.819 112.348   8.821  1.00 24.65           C  
ATOM    975  OE1 GLN A 159      -7.662 113.142   8.455  1.00 30.10           O  
ATOM    976  NE2 GLN A 159      -5.526 112.661   8.910  1.00 36.21           N  
ATOM    977  N   PHE A 160      -7.038 109.077  13.292  1.00 12.32           N  
ATOM    978  CA  PHE A 160      -7.003 109.014  14.742  1.00  6.62           C  
ATOM    979  C   PHE A 160      -5.864 109.876  15.216  1.00  2.88           C  
ATOM    980  O   PHE A 160      -4.859 110.014  14.513  1.00  5.71           O  
ATOM    981  CB  PHE A 160      -6.760 107.564  15.195  1.00 10.47           C  
ATOM    982  CG  PHE A 160      -7.894 106.622  14.865  1.00  8.39           C  
ATOM    983  CD1 PHE A 160      -7.971 106.010  13.610  1.00  2.55           C  
ATOM    984  CD2 PHE A 160      -8.889 106.353  15.809  1.00  2.25           C  
ATOM    985  CE1 PHE A 160      -9.037 105.138  13.301  1.00  2.48           C  
ATOM    986  CE2 PHE A 160      -9.944 105.493  15.510  1.00  3.67           C  
ATOM    987  CZ  PHE A 160     -10.020 104.883  14.248  1.00  2.00           C  
ATOM    988  N   GLY A 161      -6.025 110.467  16.389  1.00  2.00           N  
ATOM    989  CA  GLY A 161      -4.978 111.291  16.931  1.00  3.55           C  
ATOM    990  C   GLY A 161      -5.298 111.830  18.302  1.00  6.85           C  
ATOM    991  O   GLY A 161      -6.444 111.784  18.756  1.00  5.89           O  
ATOM    992  N   GLN A 162      -4.275 112.322  18.983  1.00  6.03           N  
ATOM    993  CA  GLN A 162      -4.415 112.903  20.305  1.00 12.40           C  
ATOM    994  C   GLN A 162      -3.772 114.288  20.249  1.00 14.44           C  
ATOM    995  O   GLN A 162      -2.649 114.471  20.685  1.00 12.81           O  
ATOM    996  CB  GLN A 162      -3.735 112.035  21.369  1.00 10.66           C  
ATOM    997  CG  GLN A 162      -4.277 110.579  21.493  1.00 10.52           C  
ATOM    998  CD  GLN A 162      -5.690 110.437  22.087  1.00 11.12           C  
ATOM    999  OE1 GLN A 162      -6.371 109.430  21.851  1.00 14.72           O  
ATOM   1000  NE2 GLN A 162      -6.118 111.412  22.878  1.00 13.58           N  
ATOM   1001  N   PRO A 163      -4.505 115.285  19.711  1.00 17.76           N  
ATOM   1002  CA  PRO A 163      -4.013 116.672  19.586  1.00 16.35           C  
ATOM   1003  C   PRO A 163      -4.045 117.493  20.869  1.00 12.56           C  
ATOM   1004  O   PRO A 163      -3.751 118.675  20.838  1.00 18.32           O  
ATOM   1005  CB  PRO A 163      -4.951 117.269  18.540  1.00 12.66           C  
ATOM   1006  CG  PRO A 163      -6.251 116.605  18.889  1.00 11.74           C  
ATOM   1007  CD  PRO A 163      -5.860 115.161  19.135  1.00 12.66           C  
ATOM   1008  N   GLU A 164      -4.320 116.863  21.999  1.00 11.77           N  
ATOM   1009  CA  GLU A 164      -4.392 117.562  23.269  1.00 11.75           C  
ATOM   1010  C   GLU A 164      -3.162 118.426  23.587  1.00 14.98           C  
ATOM   1011  O   GLU A 164      -3.302 119.514  24.147  1.00 17.40           O  
ATOM   1012  CB  GLU A 164      -4.614 116.572  24.398  1.00 13.66           C  
ATOM   1013  CG  GLU A 164      -6.031 116.023  24.518  1.00 18.41           C  
ATOM   1014  CD  GLU A 164      -6.277 114.724  23.745  1.00 14.73           C  
ATOM   1015  OE1 GLU A 164      -5.478 114.367  22.855  1.00 14.51           O  
ATOM   1016  OE2 GLU A 164      -7.287 114.059  24.042  1.00 15.68           O  
ATOM   1017  N   ILE A 165      -1.979 117.956  23.194  1.00 15.80           N  
ATOM   1018  CA  ILE A 165      -0.704 118.635  23.456  1.00 10.99           C  
ATOM   1019  C   ILE A 165      -0.649 120.010  22.772  1.00 13.00           C  
ATOM   1020  O   ILE A 165      -0.075 120.982  23.298  1.00 13.43           O  
ATOM   1021  CB  ILE A 165       0.496 117.757  23.009  1.00  7.33           C  
ATOM   1022  CG1 ILE A 165       1.814 118.329  23.538  1.00  5.13           C  
ATOM   1023  CG2 ILE A 165       0.474 117.545  21.495  1.00  2.99           C  
ATOM   1024  CD1 ILE A 165       1.922 118.269  25.032  1.00  5.65           C  
ATOM   1025  N   LEU A 166      -1.317 120.099  21.627  1.00 12.95           N  
ATOM   1026  CA  LEU A 166      -1.390 121.335  20.848  1.00  9.26           C  
ATOM   1027  C   LEU A 166      -2.227 122.389  21.576  1.00 10.66           C  
ATOM   1028  O   LEU A 166      -2.180 123.560  21.223  1.00 15.17           O  
ATOM   1029  CB  LEU A 166      -2.012 121.029  19.482  1.00  2.81           C  
ATOM   1030  CG  LEU A 166      -1.231 119.959  18.703  1.00  9.58           C  
ATOM   1031  CD1 LEU A 166      -1.812 119.741  17.314  1.00  2.77           C  
ATOM   1032  CD2 LEU A 166       0.235 120.410  18.579  1.00  5.34           C  
ATOM   1033  N   LEU A 167      -3.010 121.953  22.564  1.00  8.45           N  
ATOM   1034  CA  LEU A 167      -3.878 122.829  23.343  1.00  5.48           C  
ATOM   1035  C   LEU A 167      -3.314 123.079  24.700  1.00  5.52           C  
ATOM   1036  O   LEU A 167      -4.021 123.591  25.570  1.00  7.75           O  
ATOM   1037  CB  LEU A 167      -5.249 122.198  23.560  1.00  4.05           C  
ATOM   1038  CG  LEU A 167      -6.089 121.771  22.345  1.00  8.97           C  
ATOM   1039  CD1 LEU A 167      -7.409 121.284  22.894  1.00  3.23           C  
ATOM   1040  CD2 LEU A 167      -6.309 122.899  21.371  1.00  6.02           C  
ATOM   1041  N   GLY A 168      -2.067 122.663  24.908  1.00  4.58           N  
ATOM   1042  CA  GLY A 168      -1.446 122.833  26.201  1.00  4.05           C  
ATOM   1043  C   GLY A 168      -1.974 121.881  27.265  1.00  6.30           C  
ATOM   1044  O   GLY A 168      -1.899 122.158  28.455  1.00  6.51           O  
ATOM   1045  N   THR A 169      -2.542 120.760  26.859  1.00  9.78           N  
ATOM   1046  CA  THR A 169      -3.022 119.781  27.843  1.00 10.82           C  
ATOM   1047  C   THR A 169      -2.616 118.383  27.344  1.00 12.51           C  
ATOM   1048  O   THR A 169      -1.901 118.264  26.327  1.00  8.98           O  
ATOM   1049  CB  THR A 169      -4.573 119.885  28.081  1.00 10.85           C  
ATOM   1050  OG1 THR A 169      -4.937 119.159  29.273  1.00 11.89           O  
ATOM   1051  CG2 THR A 169      -5.397 119.363  26.860  1.00  2.00           C  
ATOM   1052  N   ILE A 170      -2.985 117.342  28.100  1.00 11.85           N  
ATOM   1053  CA  ILE A 170      -2.705 115.967  27.692  1.00  9.12           C  
ATOM   1054  C   ILE A 170      -4.042 115.198  27.575  1.00  9.89           C  
ATOM   1055  O   ILE A 170      -5.108 115.734  27.894  1.00 10.33           O  
ATOM   1056  CB  ILE A 170      -1.766 115.206  28.668  1.00  8.31           C  
ATOM   1057  CG1 ILE A 170      -2.515 114.811  29.921  1.00  6.15           C  
ATOM   1058  CG2 ILE A 170      -0.556 116.038  29.066  1.00  8.34           C  
ATOM   1059  CD1 ILE A 170      -1.751 113.914  30.769  1.00  3.80           C  
ATOM   1060  N   PRO A 171      -4.019 113.965  27.039  1.00  9.60           N  
ATOM   1061  CA  PRO A 171      -5.273 113.222  26.923  1.00  5.84           C  
ATOM   1062  C   PRO A 171      -5.784 112.938  28.315  1.00  6.04           C  
ATOM   1063  O   PRO A 171      -5.020 112.576  29.183  1.00 11.05           O  
ATOM   1064  CB  PRO A 171      -4.867 111.968  26.200  1.00  2.00           C  
ATOM   1065  CG  PRO A 171      -3.774 112.468  25.304  1.00  2.00           C  
ATOM   1066  CD  PRO A 171      -2.962 113.301  26.256  1.00  6.68           C  
ATOM   1067  N   GLY A 172      -7.083 113.104  28.523  1.00  9.78           N  
ATOM   1068  CA  GLY A 172      -7.653 112.902  29.850  1.00  6.53           C  
ATOM   1069  C   GLY A 172      -8.707 111.828  30.042  1.00 10.42           C  
ATOM   1070  O   GLY A 172      -9.355 111.782  31.077  1.00  6.72           O  
ATOM   1071  N   ALA A 173      -8.900 110.962  29.052  1.00 13.53           N  
ATOM   1072  CA  ALA A 173      -9.829 109.845  29.199  1.00 13.77           C  
ATOM   1073  C   ALA A 173      -9.231 108.562  28.559  1.00 15.05           C  
ATOM   1074  O   ALA A 173      -9.870 107.901  27.753  1.00 12.23           O  
ATOM   1075  CB  ALA A 173     -11.174 110.184  28.616  1.00 13.88           C  
ATOM   1076  N   GLY A 174      -7.972 108.262  28.889  1.00 13.74           N  
ATOM   1077  CA  GLY A 174      -7.292 107.076  28.383  1.00  2.02           C  
ATOM   1078  C   GLY A 174      -6.449 107.200  27.122  1.00 10.95           C  
ATOM   1079  O   GLY A 174      -5.890 106.210  26.672  1.00 16.23           O  
ATOM   1080  N   GLY A 175      -6.282 108.396  26.568  1.00 11.31           N  
ATOM   1081  CA  GLY A 175      -5.509 108.529  25.349  1.00  9.63           C  
ATOM   1082  C   GLY A 175      -4.037 108.201  25.510  1.00 12.15           C  
ATOM   1083  O   GLY A 175      -3.350 107.912  24.525  1.00 11.37           O  
ATOM   1084  N   THR A 176      -3.515 108.297  26.729  1.00  7.17           N  
ATOM   1085  CA  THR A 176      -2.105 107.967  26.948  1.00  7.83           C  
ATOM   1086  C   THR A 176      -2.019 106.516  27.431  1.00  8.57           C  
ATOM   1087  O   THR A 176      -0.941 105.936  27.483  1.00 13.48           O  
ATOM   1088  CB  THR A 176      -1.434 108.839  28.043  1.00  5.05           C  
ATOM   1089  OG1 THR A 176      -2.109 108.632  29.297  1.00  5.50           O  
ATOM   1090  CG2 THR A 176      -1.399 110.326  27.647  1.00  2.00           C  
ATOM   1091  N   GLN A 177      -3.168 105.913  27.706  1.00  9.52           N  
ATOM   1092  CA  GLN A 177      -3.214 104.561  28.253  1.00  3.61           C  
ATOM   1093  C   GLN A 177      -3.666 103.490  27.295  1.00  4.53           C  
ATOM   1094  O   GLN A 177      -2.938 102.542  27.048  1.00  6.87           O  
ATOM   1095  CB  GLN A 177      -4.094 104.556  29.492  1.00  2.00           C  
ATOM   1096  CG  GLN A 177      -3.548 105.403  30.610  1.00  8.07           C  
ATOM   1097  CD  GLN A 177      -2.129 105.001  31.008  1.00 11.25           C  
ATOM   1098  OE1 GLN A 177      -1.891 103.883  31.500  1.00 16.34           O  
ATOM   1099  NE2 GLN A 177      -1.187 105.920  30.839  1.00  9.94           N  
ATOM   1100  N   ARG A 178      -4.862 103.633  26.746  1.00  2.00           N  
ATOM   1101  CA  ARG A 178      -5.388 102.643  25.821  1.00  2.00           C  
ATOM   1102  C   ARG A 178      -4.656 102.705  24.505  1.00  6.18           C  
ATOM   1103  O   ARG A 178      -4.506 101.693  23.827  1.00  7.65           O  
ATOM   1104  CB  ARG A 178      -6.874 102.869  25.574  1.00  3.51           C  
ATOM   1105  CG  ARG A 178      -7.730 102.693  26.794  1.00  2.00           C  
ATOM   1106  CD  ARG A 178      -9.196 102.609  26.458  1.00  2.00           C  
ATOM   1107  NE  ARG A 178      -9.970 102.236  27.636  1.00  2.45           N  
ATOM   1108  CZ  ARG A 178     -10.399 103.086  28.564  1.00  4.76           C  
ATOM   1109  NH1 ARG A 178     -10.163 104.397  28.460  1.00  6.11           N  
ATOM   1110  NH2 ARG A 178     -11.001 102.616  29.635  1.00  2.00           N  
ATOM   1111  N   LEU A 179      -4.207 103.900  24.131  1.00  8.09           N  
ATOM   1112  CA  LEU A 179      -3.501 104.098  22.857  1.00  9.27           C  
ATOM   1113  C   LEU A 179      -2.181 103.337  22.912  1.00 11.31           C  
ATOM   1114  O   LEU A 179      -1.914 102.462  22.086  1.00 14.30           O  
ATOM   1115  CB  LEU A 179      -3.239 105.600  22.622  1.00  6.15           C  
ATOM   1116  CG  LEU A 179      -2.481 105.924  21.345  1.00  3.88           C  
ATOM   1117  CD1 LEU A 179      -3.267 105.449  20.119  1.00  5.99           C  
ATOM   1118  CD2 LEU A 179      -2.192 107.388  21.283  1.00  5.30           C  
ATOM   1119  N   THR A 180      -1.402 103.637  23.948  1.00 10.08           N  
ATOM   1120  CA  THR A 180      -0.113 103.010  24.194  1.00 11.78           C  
ATOM   1121  C   THR A 180      -0.238 101.484  24.223  1.00 10.95           C  
ATOM   1122  O   THR A 180       0.525 100.784  23.572  1.00 13.70           O  
ATOM   1123  CB  THR A 180       0.417 103.500  25.531  1.00  8.33           C  
ATOM   1124  OG1 THR A 180       0.250 104.911  25.551  1.00 10.08           O  
ATOM   1125  CG2 THR A 180       1.908 103.140  25.731  1.00  3.48           C  
ATOM   1126  N   ARG A 181      -1.226 100.984  24.952  1.00  9.68           N  
ATOM   1127  CA  ARG A 181      -1.431  99.563  25.051  1.00  6.19           C  
ATOM   1128  C   ARG A 181      -1.796  98.934  23.707  1.00  9.97           C  
ATOM   1129  O   ARG A 181      -1.434  97.803  23.448  1.00 20.95           O  
ATOM   1130  CB  ARG A 181      -2.475  99.258  26.104  1.00  2.00           C  
ATOM   1131  CG  ARG A 181      -2.037  99.610  27.481  1.00  2.00           C  
ATOM   1132  CD  ARG A 181      -3.163  99.404  28.425  1.00  2.00           C  
ATOM   1133  NE  ARG A 181      -2.683  99.303  29.789  1.00  3.47           N  
ATOM   1134  CZ  ARG A 181      -2.326 100.336  30.533  1.00  3.16           C  
ATOM   1135  NH1 ARG A 181      -2.375 101.553  30.028  1.00 14.77           N  
ATOM   1136  NH2 ARG A 181      -2.009 100.165  31.800  1.00  2.00           N  
ATOM   1137  N   ALA A 182      -2.464  99.661  22.821  1.00 13.59           N  
ATOM   1138  CA  ALA A 182      -2.819  99.062  21.533  1.00 13.06           C  
ATOM   1139  C   ALA A 182      -1.748  99.232  20.474  1.00 16.19           C  
ATOM   1140  O   ALA A 182      -1.415  98.317  19.744  1.00 19.98           O  
ATOM   1141  CB  ALA A 182      -4.104  99.667  21.018  1.00  9.78           C  
ATOM   1142  N   VAL A 183      -1.117 100.384  20.494  1.00 17.28           N  
ATOM   1143  CA  VAL A 183      -0.197 100.765  19.457  1.00 10.01           C  
ATOM   1144  C   VAL A 183       1.314 100.652  19.731  1.00 10.46           C  
ATOM   1145  O   VAL A 183       2.120 100.621  18.796  1.00  9.33           O  
ATOM   1146  CB  VAL A 183      -0.685 102.195  19.054  1.00  9.90           C  
ATOM   1147  CG1 VAL A 183       0.431 103.171  18.912  1.00 11.28           C  
ATOM   1148  CG2 VAL A 183      -1.604 102.118  17.850  1.00  8.34           C  
ATOM   1149  N   GLY A 184       1.697 100.545  20.998  1.00  8.35           N  
ATOM   1150  CA  GLY A 184       3.107 100.496  21.317  1.00  6.80           C  
ATOM   1151  C   GLY A 184       3.590 101.863  21.767  1.00 11.53           C  
ATOM   1152  O   GLY A 184       3.033 102.894  21.367  1.00 14.35           O  
ATOM   1153  N   LYS A 185       4.655 101.877  22.566  1.00 13.37           N  
ATOM   1154  CA  LYS A 185       5.228 103.109  23.111  1.00 14.54           C  
ATOM   1155  C   LYS A 185       5.669 104.130  22.079  1.00 12.52           C  
ATOM   1156  O   LYS A 185       5.320 105.287  22.192  1.00 17.55           O  
ATOM   1157  CB  LYS A 185       6.404 102.816  24.067  1.00  8.92           C  
ATOM   1158  CG  LYS A 185       6.793 104.025  24.898  1.00  4.68           C  
ATOM   1159  CD  LYS A 185       7.981 103.819  25.811  1.00  2.41           C  
ATOM   1160  CE  LYS A 185       9.246 103.591  24.998  1.00  2.00           C  
ATOM   1161  NZ  LYS A 185      10.412 103.766  25.895  1.00  2.61           N  
ATOM   1162  N   SER A 186       6.424 103.709  21.078  1.00 13.28           N  
ATOM   1163  CA  SER A 186       6.915 104.637  20.080  1.00 10.43           C  
ATOM   1164  C   SER A 186       5.820 105.381  19.336  1.00 10.88           C  
ATOM   1165  O   SER A 186       5.859 106.595  19.276  1.00 18.19           O  
ATOM   1166  CB  SER A 186       7.872 103.933  19.133  1.00  9.96           C  
ATOM   1167  OG  SER A 186       8.317 104.773  18.094  1.00  8.56           O  
ATOM   1168  N   LEU A 187       4.811 104.697  18.806  1.00 13.06           N  
ATOM   1169  CA  LEU A 187       3.744 105.414  18.104  1.00  9.29           C  
ATOM   1170  C   LEU A 187       2.894 106.229  19.057  1.00  7.58           C  
ATOM   1171  O   LEU A 187       2.562 107.350  18.769  1.00 16.68           O  
ATOM   1172  CB  LEU A 187       2.887 104.476  17.278  1.00  9.61           C  
ATOM   1173  CG  LEU A 187       1.916 105.207  16.344  1.00 16.95           C  
ATOM   1174  CD1 LEU A 187       2.654 106.169  15.447  1.00 12.44           C  
ATOM   1175  CD2 LEU A 187       1.093 104.248  15.508  1.00 10.87           C  
ATOM   1176  N   ALA A 188       2.600 105.712  20.235  1.00  9.27           N  
ATOM   1177  CA  ALA A 188       1.823 106.451  21.217  1.00  5.39           C  
ATOM   1178  C   ALA A 188       2.552 107.725  21.616  1.00  8.37           C  
ATOM   1179  O   ALA A 188       1.978 108.804  21.590  1.00 15.60           O  
ATOM   1180  CB  ALA A 188       1.567 105.609  22.433  1.00  7.98           C  
ATOM   1181  N   MET A 189       3.820 107.617  21.967  1.00  4.75           N  
ATOM   1182  CA  MET A 189       4.609 108.775  22.357  1.00  4.22           C  
ATOM   1183  C   MET A 189       4.575 109.779  21.223  1.00 10.12           C  
ATOM   1184  O   MET A 189       4.304 110.951  21.436  1.00 18.15           O  
ATOM   1185  CB  MET A 189       6.077 108.398  22.593  1.00  2.00           C  
ATOM   1186  CG  MET A 189       6.395 107.770  23.914  1.00  2.00           C  
ATOM   1187  SD  MET A 189       6.143 108.860  25.234  1.00  8.89           S  
ATOM   1188  CE  MET A 189       6.613 107.868  26.612  1.00  7.80           C  
ATOM   1189  N   GLU A 190       4.830 109.315  20.010  1.00  4.94           N  
ATOM   1190  CA  GLU A 190       4.850 110.183  18.861  1.00  7.70           C  
ATOM   1191  C   GLU A 190       3.506 110.909  18.654  1.00 12.63           C  
ATOM   1192  O   GLU A 190       3.467 112.120  18.471  1.00 15.62           O  
ATOM   1193  CB  GLU A 190       5.254 109.381  17.638  1.00  4.29           C  
ATOM   1194  CG  GLU A 190       5.282 110.170  16.401  1.00  3.37           C  
ATOM   1195  CD  GLU A 190       5.898 109.430  15.247  1.00 11.03           C  
ATOM   1196  OE1 GLU A 190       5.963 108.185  15.253  1.00  9.82           O  
ATOM   1197  OE2 GLU A 190       6.313 110.119  14.295  1.00 16.81           O  
ATOM   1198  N   MET A 191       2.407 110.182  18.760  1.00 10.20           N  
ATOM   1199  CA  MET A 191       1.097 110.757  18.589  1.00  6.51           C  
ATOM   1200  C   MET A 191       0.741 111.742  19.689  1.00  8.48           C  
ATOM   1201  O   MET A 191       0.226 112.815  19.418  1.00 14.63           O  
ATOM   1202  CB  MET A 191       0.044 109.662  18.568  1.00  7.51           C  
ATOM   1203  CG  MET A 191      -0.002 108.864  17.281  1.00 10.15           C  
ATOM   1204  SD  MET A 191      -1.199 107.552  17.423  1.00 14.51           S  
ATOM   1205  CE  MET A 191      -2.755 108.387  17.206  1.00 11.65           C  
ATOM   1206  N   VAL A 192       0.999 111.376  20.935  1.00  5.68           N  
ATOM   1207  CA  VAL A 192       0.666 112.200  22.090  1.00  5.48           C  
ATOM   1208  C   VAL A 192       1.553 113.448  22.248  1.00  9.89           C  
ATOM   1209  O   VAL A 192       1.104 114.487  22.693  1.00 11.60           O  
ATOM   1210  CB  VAL A 192       0.743 111.332  23.390  1.00  3.83           C  
ATOM   1211  CG1 VAL A 192       0.657 112.174  24.650  1.00  5.25           C  
ATOM   1212  CG2 VAL A 192      -0.369 110.320  23.413  1.00  5.34           C  
ATOM   1213  N   LEU A 193       2.815 113.332  21.882  1.00 11.41           N  
ATOM   1214  CA  LEU A 193       3.754 114.421  22.030  1.00 10.65           C  
ATOM   1215  C   LEU A 193       3.769 115.393  20.866  1.00 14.20           C  
ATOM   1216  O   LEU A 193       4.197 116.542  21.027  1.00 12.13           O  
ATOM   1217  CB  LEU A 193       5.163 113.874  22.263  1.00 10.37           C  
ATOM   1218  CG  LEU A 193       5.336 113.005  23.511  1.00  8.00           C  
ATOM   1219  CD1 LEU A 193       6.813 112.702  23.663  1.00  2.97           C  
ATOM   1220  CD2 LEU A 193       4.769 113.692  24.756  1.00  2.00           C  
ATOM   1221  N   THR A 194       3.395 114.933  19.676  1.00 10.16           N  
ATOM   1222  CA  THR A 194       3.362 115.832  18.537  1.00 10.72           C  
ATOM   1223  C   THR A 194       1.941 116.283  18.145  1.00 11.39           C  
ATOM   1224  O   THR A 194       1.762 117.360  17.558  1.00 16.33           O  
ATOM   1225  CB  THR A 194       4.015 115.215  17.309  1.00  8.07           C  
ATOM   1226  OG1 THR A 194       3.190 114.164  16.820  1.00 10.36           O  
ATOM   1227  CG2 THR A 194       5.385 114.725  17.626  1.00  8.99           C  
ATOM   1228  N   GLY A 195       0.949 115.455  18.459  1.00  9.03           N  
ATOM   1229  CA  GLY A 195      -0.428 115.746  18.107  1.00  4.91           C  
ATOM   1230  C   GLY A 195      -0.731 115.262  16.692  1.00  7.70           C  
ATOM   1231  O   GLY A 195      -1.805 115.493  16.177  1.00 10.01           O  
ATOM   1232  N   ASP A 196       0.218 114.604  16.041  1.00  9.25           N  
ATOM   1233  CA  ASP A 196       0.009 114.091  14.695  1.00 11.73           C  
ATOM   1234  C   ASP A 196      -1.059 113.006  14.596  1.00 13.66           C  
ATOM   1235  O   ASP A 196      -1.205 112.169  15.479  1.00  8.82           O  
ATOM   1236  CB  ASP A 196       1.309 113.515  14.146  1.00 16.56           C  
ATOM   1237  CG  ASP A 196       2.335 114.566  13.850  1.00 21.75           C  
ATOM   1238  OD1 ASP A 196       1.984 115.767  13.762  1.00 26.20           O  
ATOM   1239  OD2 ASP A 196       3.512 114.188  13.700  1.00 29.22           O  
ATOM   1240  N   ARG A 197      -1.755 112.997  13.468  1.00 14.71           N  
ATOM   1241  CA  ARG A 197      -2.795 112.024  13.194  1.00 17.09           C  
ATOM   1242  C   ARG A 197      -2.246 110.835  12.430  1.00 20.33           C  
ATOM   1243  O   ARG A 197      -1.260 110.954  11.691  1.00 22.78           O  
ATOM   1244  CB  ARG A 197      -3.894 112.639  12.327  1.00 13.49           C  
ATOM   1245  CG  ARG A 197      -4.774 113.676  12.988  1.00 20.57           C  
ATOM   1246  CD  ARG A 197      -5.859 114.138  12.002  1.00 22.00           C  
ATOM   1247  NE  ARG A 197      -5.916 115.589  11.935  1.00 30.96           N  
ATOM   1248  CZ  ARG A 197      -5.491 116.304  10.904  1.00 27.59           C  
ATOM   1249  NH1 ARG A 197      -4.995 115.717   9.840  1.00 32.16           N  
ATOM   1250  NH2 ARG A 197      -5.488 117.609  10.977  1.00 28.15           N  
ATOM   1251  N   ILE A 198      -2.914 109.699  12.581  1.00 17.91           N  
ATOM   1252  CA  ILE A 198      -2.535 108.510  11.855  1.00 16.20           C  
ATOM   1253  C   ILE A 198      -3.765 108.132  11.063  1.00 16.14           C  
ATOM   1254  O   ILE A 198      -4.892 108.485  11.434  1.00 17.20           O  
ATOM   1255  CB  ILE A 198      -2.092 107.368  12.799  1.00 15.60           C  
ATOM   1256  CG1 ILE A 198      -3.262 106.887  13.663  1.00  5.57           C  
ATOM   1257  CG2 ILE A 198      -0.898 107.828  13.639  1.00  5.71           C  
ATOM   1258  CD1 ILE A 198      -2.909 105.706  14.535  1.00  9.31           C  
ATOM   1259  N   SER A 199      -3.540 107.468   9.941  1.00 18.25           N  
ATOM   1260  CA  SER A 199      -4.626 107.044   9.062  1.00 18.57           C  
ATOM   1261  C   SER A 199      -5.307 105.778   9.551  1.00 20.05           C  
ATOM   1262  O   SER A 199      -4.851 105.141  10.510  1.00 24.71           O  
ATOM   1263  CB  SER A 199      -4.074 106.779   7.675  1.00 11.37           C  
ATOM   1264  OG  SER A 199      -3.072 105.788   7.741  1.00 23.57           O  
ATOM   1265  N   ALA A 200      -6.348 105.377   8.832  1.00 18.47           N  
ATOM   1266  CA  ALA A 200      -7.092 104.163   9.157  1.00 23.28           C  
ATOM   1267  C   ALA A 200      -6.128 102.979   9.066  1.00 24.00           C  
ATOM   1268  O   ALA A 200      -6.056 102.151   9.973  1.00 24.04           O  
ATOM   1269  CB  ALA A 200      -8.256 103.981   8.180  1.00 22.30           C  
ATOM   1270  N   GLN A 201      -5.308 102.972   8.020  1.00 24.06           N  
ATOM   1271  CA  GLN A 201      -4.367 101.892   7.849  1.00 26.87           C  
ATOM   1272  C   GLN A 201      -3.302 101.808   8.908  1.00 25.85           C  
ATOM   1273  O   GLN A 201      -3.010 100.718   9.393  1.00 32.40           O  
ATOM   1274  CB  GLN A 201      -3.777 101.910   6.469  1.00 34.90           C  
ATOM   1275  CG  GLN A 201      -4.796 101.411   5.508  1.00 51.49           C  
ATOM   1276  CD  GLN A 201      -4.273 101.324   4.121  1.00 62.58           C  
ATOM   1277  OE1 GLN A 201      -4.795 101.968   3.207  1.00 69.22           O  
ATOM   1278  NE2 GLN A 201      -3.228 100.529   3.937  1.00 64.66           N  
ATOM   1279  N   ASP A 202      -2.750 102.937   9.319  1.00 21.03           N  
ATOM   1280  CA  ASP A 202      -1.733 102.906  10.357  1.00 19.54           C  
ATOM   1281  C   ASP A 202      -2.381 102.379  11.610  1.00 16.30           C  
ATOM   1282  O   ASP A 202      -1.754 101.672  12.389  1.00 17.28           O  
ATOM   1283  CB  ASP A 202      -1.203 104.301  10.658  1.00 25.38           C  
ATOM   1284  CG  ASP A 202      -0.491 104.930   9.484  1.00 28.53           C  
ATOM   1285  OD1 ASP A 202       0.048 104.177   8.655  1.00 35.13           O  
ATOM   1286  OD2 ASP A 202      -0.456 106.183   9.402  1.00 35.24           O  
ATOM   1287  N   ALA A 203      -3.644 102.732  11.797  1.00 14.84           N  
ATOM   1288  CA  ALA A 203      -4.383 102.313  12.978  1.00 16.81           C  
ATOM   1289  C   ALA A 203      -4.617 100.811  12.965  1.00 20.17           C  
ATOM   1290  O   ALA A 203      -4.494 100.148  14.006  1.00 21.12           O  
ATOM   1291  CB  ALA A 203      -5.714 103.056  13.079  1.00  4.58           C  
ATOM   1292  N   LYS A 204      -4.907 100.253  11.789  1.00 20.11           N  
ATOM   1293  CA  LYS A 204      -5.153  98.827  11.711  1.00 19.34           C  
ATOM   1294  C   LYS A 204      -3.836  98.074  11.835  1.00 21.63           C  
ATOM   1295  O   LYS A 204      -3.729  97.112  12.609  1.00 22.02           O  
ATOM   1296  CB  LYS A 204      -5.849  98.445  10.426  1.00 18.38           C  
ATOM   1297  CG  LYS A 204      -6.219  96.945  10.382  1.00 24.89           C  
ATOM   1298  CD  LYS A 204      -6.600  96.539   8.964  1.00 29.02           C  
ATOM   1299  CE  LYS A 204      -6.740  95.023   8.696  1.00 33.32           C  
ATOM   1300  NZ  LYS A 204      -6.678  94.093   9.848  1.00 43.14           N  
ATOM   1301  N   GLN A 205      -2.826  98.526  11.101  1.00 20.08           N  
ATOM   1302  CA  GLN A 205      -1.519  97.894  11.152  1.00 22.20           C  
ATOM   1303  C   GLN A 205      -1.038  97.844  12.609  1.00 19.79           C  
ATOM   1304  O   GLN A 205      -0.493  96.846  13.083  1.00 30.09           O  
ATOM   1305  CB  GLN A 205      -0.537  98.676  10.315  1.00 26.76           C  
ATOM   1306  CG  GLN A 205       0.810  97.991  10.126  1.00 53.21           C  
ATOM   1307  CD  GLN A 205       1.832  98.884   9.409  1.00 66.23           C  
ATOM   1308  OE1 GLN A 205       1.569 100.064   9.151  1.00 72.69           O  
ATOM   1309  NE2 GLN A 205       2.997  98.316   9.073  1.00 69.21           N  
ATOM   1310  N   ALA A 206      -1.277  98.925  13.328  1.00 15.11           N  
ATOM   1311  CA  ALA A 206      -0.875  99.017  14.712  1.00 11.61           C  
ATOM   1312  C   ALA A 206      -1.806  98.301  15.693  1.00 13.56           C  
ATOM   1313  O   ALA A 206      -1.448  98.139  16.852  1.00 23.47           O  
ATOM   1314  CB  ALA A 206      -0.707 100.466  15.083  1.00  9.27           C  
ATOM   1315  N   GLY A 207      -2.983  97.863  15.253  1.00 13.32           N  
ATOM   1316  CA  GLY A 207      -3.884  97.154  16.152  1.00  8.97           C  
ATOM   1317  C   GLY A 207      -4.827  98.017  16.947  1.00 11.90           C  
ATOM   1318  O   GLY A 207      -5.458  97.573  17.906  1.00 14.93           O  
ATOM   1319  N   LEU A 208      -4.923  99.277  16.568  1.00 13.02           N  
ATOM   1320  CA  LEU A 208      -5.829 100.171  17.267  1.00 13.81           C  
ATOM   1321  C   LEU A 208      -7.244  99.784  16.823  1.00 11.36           C  
ATOM   1322  O   LEU A 208      -8.189  99.780  17.612  1.00 12.34           O  
ATOM   1323  CB  LEU A 208      -5.486 101.632  16.928  1.00 12.50           C  
ATOM   1324  CG  LEU A 208      -6.289 102.768  17.592  1.00  8.82           C  
ATOM   1325  CD1 LEU A 208      -6.270 102.625  19.099  1.00  5.94           C  
ATOM   1326  CD2 LEU A 208      -5.727 104.136  17.160  1.00  3.94           C  
ATOM   1327  N   VAL A 209      -7.363  99.437  15.548  1.00 11.36           N  
ATOM   1328  CA  VAL A 209      -8.649  99.055  14.939  1.00 14.03           C  
ATOM   1329  C   VAL A 209      -8.447  97.689  14.286  1.00 14.83           C  
ATOM   1330  O   VAL A 209      -7.359  97.393  13.787  1.00 17.75           O  
ATOM   1331  CB  VAL A 209      -9.165 100.104  13.846  1.00  9.28           C  
ATOM   1332  CG1 VAL A 209      -9.111 101.526  14.373  1.00  5.53           C  
ATOM   1333  CG2 VAL A 209      -8.364 100.035  12.599  1.00  5.21           C  
ATOM   1334  N   SER A 210      -9.477  96.850  14.280  1.00 17.03           N  
ATOM   1335  CA  SER A 210      -9.293  95.534  13.698  1.00 13.69           C  
ATOM   1336  C   SER A 210      -9.786  95.374  12.286  1.00 15.85           C  
ATOM   1337  O   SER A 210      -9.420  94.417  11.621  1.00 20.86           O  
ATOM   1338  CB  SER A 210      -9.896  94.467  14.595  1.00 12.71           C  
ATOM   1339  OG  SER A 210     -11.199  94.836  14.962  1.00 14.64           O  
ATOM   1340  N   LYS A 211     -10.573  96.318  11.785  1.00 21.06           N  
ATOM   1341  CA  LYS A 211     -11.095  96.185  10.421  1.00 17.24           C  
ATOM   1342  C   LYS A 211     -11.270  97.537   9.784  1.00 15.72           C  
ATOM   1343  O   LYS A 211     -11.568  98.495  10.478  1.00 17.96           O  
ATOM   1344  CB  LYS A 211     -12.465  95.502  10.475  1.00 18.73           C  
ATOM   1345  CG  LYS A 211     -12.631  94.416   9.461  1.00 18.74           C  
ATOM   1346  CD  LYS A 211     -11.774  93.217   9.810  1.00 21.31           C  
ATOM   1347  CE  LYS A 211     -12.480  92.341  10.822  1.00 26.41           C  
ATOM   1348  NZ  LYS A 211     -11.559  91.372  11.489  1.00 29.35           N  
ATOM   1349  N   ILE A 212     -11.013  97.633   8.485  1.00 17.90           N  
ATOM   1350  CA  ILE A 212     -11.219  98.886   7.751  1.00 19.09           C  
ATOM   1351  C   ILE A 212     -12.255  98.612   6.664  1.00 21.93           C  
ATOM   1352  O   ILE A 212     -12.155  97.620   5.928  1.00 25.59           O  
ATOM   1353  CB  ILE A 212      -9.945  99.418   7.040  1.00 17.76           C  
ATOM   1354  CG1 ILE A 212      -8.881  99.818   8.048  1.00 18.64           C  
ATOM   1355  CG2 ILE A 212     -10.266 100.669   6.220  1.00 12.90           C  
ATOM   1356  CD1 ILE A 212      -7.613 100.245   7.394  1.00 14.35           C  
ATOM   1357  N   PHE A 213     -13.248  99.482   6.570  1.00 24.07           N  
ATOM   1358  CA  PHE A 213     -14.302  99.343   5.564  1.00 25.87           C  
ATOM   1359  C   PHE A 213     -14.545 100.673   4.833  1.00 27.34           C  
ATOM   1360  O   PHE A 213     -14.156 101.741   5.316  1.00 27.80           O  
ATOM   1361  CB  PHE A 213     -15.610  98.901   6.215  1.00 20.81           C  
ATOM   1362  CG  PHE A 213     -15.620  97.471   6.622  1.00 24.17           C  
ATOM   1363  CD1 PHE A 213     -15.642  96.462   5.648  1.00 22.03           C  
ATOM   1364  CD2 PHE A 213     -15.584  97.123   7.971  1.00 22.00           C  
ATOM   1365  CE1 PHE A 213     -15.626  95.121   6.012  1.00 21.19           C  
ATOM   1366  CE2 PHE A 213     -15.569  95.789   8.359  1.00 18.73           C  
ATOM   1367  CZ  PHE A 213     -15.587  94.783   7.379  1.00 21.36           C  
ATOM   1368  N   PRO A 214     -15.109 100.612   3.617  1.00 25.76           N  
ATOM   1369  CA  PRO A 214     -15.387 101.829   2.858  1.00 22.82           C  
ATOM   1370  C   PRO A 214     -16.291 102.726   3.686  1.00 22.74           C  
ATOM   1371  O   PRO A 214     -17.143 102.246   4.452  1.00 21.90           O  
ATOM   1372  CB  PRO A 214     -16.124 101.302   1.630  1.00 24.93           C  
ATOM   1373  CG  PRO A 214     -15.430  99.999   1.392  1.00 24.08           C  
ATOM   1374  CD  PRO A 214     -15.407  99.422   2.806  1.00 29.14           C  
ATOM   1375  N   VAL A 215     -16.101 104.028   3.520  1.00 20.20           N  
ATOM   1376  CA  VAL A 215     -16.870 105.040   4.243  1.00 24.75           C  
ATOM   1377  C   VAL A 215     -18.372 104.766   4.231  1.00 25.02           C  
ATOM   1378  O   VAL A 215     -19.036 104.806   5.256  1.00 29.45           O  
ATOM   1379  CB  VAL A 215     -16.623 106.481   3.647  1.00 19.87           C  
ATOM   1380  CG1 VAL A 215     -17.479 107.509   4.342  1.00  7.88           C  
ATOM   1381  CG2 VAL A 215     -15.168 106.874   3.786  1.00 17.11           C  
ATOM   1382  N   GLU A 216     -18.882 104.401   3.070  1.00 28.28           N  
ATOM   1383  CA  GLU A 216     -20.305 104.159   2.889  1.00 36.85           C  
ATOM   1384  C   GLU A 216     -20.877 102.882   3.509  1.00 33.69           C  
ATOM   1385  O   GLU A 216     -22.007 102.886   3.990  1.00 34.54           O  
ATOM   1386  CB  GLU A 216     -20.670 104.264   1.399  1.00 46.51           C  
ATOM   1387  CG  GLU A 216     -19.608 103.711   0.405  1.00 67.70           C  
ATOM   1388  CD  GLU A 216     -18.418 104.669   0.123  1.00 77.76           C  
ATOM   1389  OE1 GLU A 216     -18.479 105.484  -0.830  1.00 84.97           O  
ATOM   1390  OE2 GLU A 216     -17.394 104.584   0.831  1.00 78.35           O  
ATOM   1391  N   THR A 217     -20.091 101.806   3.544  1.00 29.12           N  
ATOM   1392  CA  THR A 217     -20.561 100.544   4.090  1.00 22.28           C  
ATOM   1393  C   THR A 217     -20.130 100.265   5.510  1.00 22.55           C  
ATOM   1394  O   THR A 217     -20.610  99.321   6.125  1.00 28.34           O  
ATOM   1395  CB  THR A 217     -20.116  99.413   3.200  1.00 23.26           C  
ATOM   1396  OG1 THR A 217     -18.684  99.405   3.097  1.00 27.78           O  
ATOM   1397  CG2 THR A 217     -20.714  99.606   1.811  1.00 16.44           C  
ATOM   1398  N   LEU A 218     -19.273 101.115   6.051  1.00 18.77           N  
ATOM   1399  CA  LEU A 218     -18.751 100.964   7.402  1.00 16.47           C  
ATOM   1400  C   LEU A 218     -19.751 100.652   8.516  1.00 16.33           C  
ATOM   1401  O   LEU A 218     -19.601  99.638   9.192  1.00 24.20           O  
ATOM   1402  CB  LEU A 218     -17.933 102.191   7.787  1.00 16.58           C  
ATOM   1403  CG  LEU A 218     -17.409 102.118   9.202  1.00 18.55           C  
ATOM   1404  CD1 LEU A 218     -16.255 101.134   9.273  1.00 19.09           C  
ATOM   1405  CD2 LEU A 218     -16.973 103.484   9.633  1.00 21.41           C  
ATOM   1406  N   VAL A 219     -20.755 101.500   8.734  1.00 16.15           N  
ATOM   1407  CA  VAL A 219     -21.742 101.285   9.812  1.00 15.45           C  
ATOM   1408  C   VAL A 219     -22.541 100.009   9.575  1.00 20.54           C  
ATOM   1409  O   VAL A 219     -22.902  99.310  10.523  1.00 24.63           O  
ATOM   1410  CB  VAL A 219     -22.720 102.505   9.983  1.00 11.29           C  
ATOM   1411  CG1 VAL A 219     -23.782 102.256  11.084  1.00  2.62           C  
ATOM   1412  CG2 VAL A 219     -21.927 103.763  10.338  1.00 11.04           C  
ATOM   1413  N   GLU A 220     -22.793  99.708   8.308  1.00 20.89           N  
ATOM   1414  CA  GLU A 220     -23.521  98.518   7.917  1.00 25.60           C  
ATOM   1415  C   GLU A 220     -22.690  97.308   8.366  1.00 25.00           C  
ATOM   1416  O   GLU A 220     -23.188  96.390   9.050  1.00 24.05           O  
ATOM   1417  CB  GLU A 220     -23.662  98.527   6.406  1.00 33.58           C  
ATOM   1418  CG  GLU A 220     -24.443  97.383   5.807  1.00 52.07           C  
ATOM   1419  CD  GLU A 220     -24.330  97.359   4.282  1.00 62.52           C  
ATOM   1420  OE1 GLU A 220     -24.814  98.323   3.628  1.00 64.89           O  
ATOM   1421  OE2 GLU A 220     -23.736  96.387   3.745  1.00 64.53           O  
ATOM   1422  N   GLU A 221     -21.402  97.369   8.030  1.00 18.43           N  
ATOM   1423  CA  GLU A 221     -20.447  96.342   8.366  1.00 16.93           C  
ATOM   1424  C   GLU A 221     -20.293  96.149   9.867  1.00 21.15           C  
ATOM   1425  O   GLU A 221     -20.265  95.001  10.353  1.00 27.88           O  
ATOM   1426  CB  GLU A 221     -19.122  96.672   7.741  1.00 15.71           C  
ATOM   1427  CG  GLU A 221     -19.124  96.532   6.238  1.00 20.50           C  
ATOM   1428  CD  GLU A 221     -19.197  95.079   5.751  1.00 26.46           C  
ATOM   1429  OE1 GLU A 221     -19.049  94.110   6.554  1.00 29.43           O  
ATOM   1430  OE2 GLU A 221     -19.382  94.915   4.529  1.00 30.65           O  
ATOM   1431  N   ALA A 222     -20.271  97.250  10.613  1.00 15.33           N  
ATOM   1432  CA  ALA A 222     -20.149  97.185  12.053  1.00  9.80           C  
ATOM   1433  C   ALA A 222     -21.426  96.595  12.605  1.00 14.23           C  
ATOM   1434  O   ALA A 222     -21.397  95.837  13.572  1.00 23.51           O  
ATOM   1435  CB  ALA A 222     -19.899  98.550  12.631  1.00  8.81           C  
ATOM   1436  N   ILE A 223     -22.557  96.881  11.982  1.00 15.82           N  
ATOM   1437  CA  ILE A 223     -23.830  96.337  12.472  1.00 18.32           C  
ATOM   1438  C   ILE A 223     -23.878  94.813  12.260  1.00 16.45           C  
ATOM   1439  O   ILE A 223     -24.380  94.067  13.111  1.00 14.94           O  
ATOM   1440  CB  ILE A 223     -25.043  97.072  11.815  1.00 21.58           C  
ATOM   1441  CG1 ILE A 223     -25.173  98.477  12.443  1.00 18.04           C  
ATOM   1442  CG2 ILE A 223     -26.369  96.275  12.015  1.00 21.52           C  
ATOM   1443  CD1 ILE A 223     -26.014  99.448  11.643  1.00 12.49           C  
ATOM   1444  N   GLN A 224     -23.298  94.360  11.155  1.00 15.74           N  
ATOM   1445  CA  GLN A 224     -23.243  92.935  10.869  1.00 21.46           C  
ATOM   1446  C   GLN A 224     -22.440  92.248  11.963  1.00 23.68           C  
ATOM   1447  O   GLN A 224     -22.861  91.218  12.505  1.00 28.66           O  
ATOM   1448  CB  GLN A 224     -22.596  92.680   9.519  1.00 24.59           C  
ATOM   1449  CG  GLN A 224     -23.500  92.987   8.381  1.00 37.85           C  
ATOM   1450  CD  GLN A 224     -22.932  92.532   7.053  1.00 51.09           C  
ATOM   1451  OE1 GLN A 224     -22.931  93.300   6.085  1.00 57.34           O  
ATOM   1452  NE2 GLN A 224     -22.448  91.277   6.988  1.00 55.17           N  
ATOM   1453  N   CYS A 225     -21.315  92.861  12.334  1.00 23.80           N  
ATOM   1454  CA  CYS A 225     -20.461  92.317  13.382  1.00 19.78           C  
ATOM   1455  C   CYS A 225     -21.205  92.311  14.696  1.00 14.31           C  
ATOM   1456  O   CYS A 225     -21.177  91.323  15.415  1.00 25.77           O  
ATOM   1457  CB  CYS A 225     -19.172  93.120  13.471  1.00 20.67           C  
ATOM   1458  SG  CYS A 225     -18.089  92.676  14.840  1.00 29.48           S  
ATOM   1459  N   ALA A 226     -21.951  93.367  14.969  1.00 11.22           N  
ATOM   1460  CA  ALA A 226     -22.706  93.442  16.214  1.00 13.37           C  
ATOM   1461  C   ALA A 226     -23.815  92.420  16.184  1.00 12.46           C  
ATOM   1462  O   ALA A 226     -24.266  91.933  17.210  1.00 17.89           O  
ATOM   1463  CB  ALA A 226     -23.275  94.833  16.386  1.00 14.51           C  
ATOM   1464  N   GLU A 227     -24.221  92.060  14.982  1.00 14.83           N  
ATOM   1465  CA  GLU A 227     -25.286  91.107  14.784  1.00 17.57           C  
ATOM   1466  C   GLU A 227     -24.827  89.753  15.232  1.00 19.00           C  
ATOM   1467  O   GLU A 227     -25.487  89.103  16.050  1.00 23.39           O  
ATOM   1468  CB  GLU A 227     -25.634  91.035  13.325  1.00 20.14           C  
ATOM   1469  CG  GLU A 227     -27.115  90.963  13.112  1.00 36.37           C  
ATOM   1470  CD  GLU A 227     -27.457  90.710  11.680  1.00 41.00           C  
ATOM   1471  OE1 GLU A 227     -27.259  89.555  11.220  1.00 43.46           O  
ATOM   1472  OE2 GLU A 227     -27.917  91.671  11.020  1.00 45.47           O  
ATOM   1473  N   LYS A 228     -23.692  89.320  14.684  1.00 17.30           N  
ATOM   1474  CA  LYS A 228     -23.105  88.028  15.054  1.00 14.22           C  
ATOM   1475  C   LYS A 228     -23.004  87.940  16.563  1.00 16.36           C  
ATOM   1476  O   LYS A 228     -23.433  86.977  17.169  1.00 28.41           O  
ATOM   1477  CB  LYS A 228     -21.696  87.886  14.521  1.00 11.11           C  
ATOM   1478  CG  LYS A 228     -21.584  87.857  13.038  1.00 13.47           C  
ATOM   1479  CD  LYS A 228     -20.136  87.796  12.701  1.00 22.01           C  
ATOM   1480  CE  LYS A 228     -19.930  87.886  11.211  1.00 31.36           C  
ATOM   1481  NZ  LYS A 228     -18.588  88.479  10.879  1.00 40.36           N  
ATOM   1482  N   ILE A 229     -22.485  88.981  17.185  1.00 18.56           N  
ATOM   1483  CA  ILE A 229     -22.324  88.980  18.626  1.00 16.85           C  
ATOM   1484  C   ILE A 229     -23.673  88.882  19.305  1.00 17.03           C  
ATOM   1485  O   ILE A 229     -23.841  88.124  20.253  1.00 22.22           O  
ATOM   1486  CB  ILE A 229     -21.573  90.239  19.078  1.00 15.69           C  
ATOM   1487  CG1 ILE A 229     -20.153  90.228  18.479  1.00 14.61           C  
ATOM   1488  CG2 ILE A 229     -21.573  90.337  20.578  1.00 13.47           C  
ATOM   1489  CD1 ILE A 229     -19.371  91.535  18.644  1.00 11.40           C  
ATOM   1490  N   ALA A 230     -24.658  89.603  18.794  1.00 19.69           N  
ATOM   1491  CA  ALA A 230     -25.963  89.563  19.429  1.00 20.91           C  
ATOM   1492  C   ALA A 230     -26.642  88.202  19.267  1.00 19.30           C  
ATOM   1493  O   ALA A 230     -27.570  87.881  20.020  1.00 21.22           O  
ATOM   1494  CB  ALA A 230     -26.825  90.688  18.924  1.00 19.06           C  
ATOM   1495  N   ASN A 231     -26.143  87.404  18.319  1.00 18.69           N  
ATOM   1496  CA  ASN A 231     -26.667  86.046  18.078  1.00 24.25           C  
ATOM   1497  C   ASN A 231     -26.258  85.083  19.187  1.00 24.45           C  
ATOM   1498  O   ASN A 231     -26.941  84.096  19.445  1.00 30.12           O  
ATOM   1499  CB  ASN A 231     -26.158  85.442  16.759  1.00 29.58           C  
ATOM   1500  CG  ASN A 231     -26.644  86.203  15.517  1.00 42.55           C  
ATOM   1501  OD1 ASN A 231     -27.649  86.945  15.556  1.00 52.17           O  
ATOM   1502  ND2 ASN A 231     -25.919  86.033  14.404  1.00 37.89           N  
ATOM   1503  N   ASN A 232     -25.105  85.318  19.795  1.00 21.09           N  
ATOM   1504  CA  ASN A 232     -24.636  84.441  20.855  1.00 14.17           C  
ATOM   1505  C   ASN A 232     -25.358  84.748  22.155  1.00 13.58           C  
ATOM   1506  O   ASN A 232     -26.201  85.639  22.201  1.00 19.69           O  
ATOM   1507  CB  ASN A 232     -23.128  84.562  21.013  1.00  9.04           C  
ATOM   1508  CG  ASN A 232     -22.389  84.270  19.738  1.00 11.71           C  
ATOM   1509  OD1 ASN A 232     -22.702  83.326  19.034  1.00 20.53           O  
ATOM   1510  ND2 ASN A 232     -21.387  85.062  19.442  1.00 16.62           N  
ATOM   1511  N   SER A 233     -25.055  83.994  23.209  1.00 12.03           N  
ATOM   1512  CA  SER A 233     -25.679  84.205  24.509  1.00 13.42           C  
ATOM   1513  C   SER A 233     -25.229  85.538  25.082  1.00 16.17           C  
ATOM   1514  O   SER A 233     -24.031  85.817  25.133  1.00 24.52           O  
ATOM   1515  CB  SER A 233     -25.289  83.085  25.467  1.00 10.57           C  
ATOM   1516  OG  SER A 233     -25.791  83.359  26.772  1.00 14.08           O  
ATOM   1517  N   LYS A 234     -26.158  86.358  25.548  1.00 17.52           N  
ATOM   1518  CA  LYS A 234     -25.758  87.640  26.119  1.00 15.74           C  
ATOM   1519  C   LYS A 234     -24.961  87.475  27.419  1.00 17.29           C  
ATOM   1520  O   LYS A 234     -23.945  88.172  27.585  1.00 23.44           O  
ATOM   1521  CB  LYS A 234     -26.955  88.586  26.305  1.00 15.50           C  
ATOM   1522  CG  LYS A 234     -27.557  89.086  24.996  1.00 16.05           C  
ATOM   1523  CD  LYS A 234     -28.743  90.004  25.250  1.00 17.10           C  
ATOM   1524  CE  LYS A 234     -29.851  89.760  24.244  1.00 17.05           C  
ATOM   1525  NZ  LYS A 234     -29.341  89.515  22.855  1.00 23.23           N  
ATOM   1526  N   ILE A 235     -25.371  86.551  28.305  1.00 13.31           N  
ATOM   1527  CA  ILE A 235     -24.648  86.318  29.564  1.00 10.05           C  
ATOM   1528  C   ILE A 235     -23.235  85.792  29.323  1.00 11.02           C  
ATOM   1529  O   ILE A 235     -22.306  86.205  29.977  1.00 17.79           O  
ATOM   1530  CB  ILE A 235     -25.399  85.378  30.506  1.00  8.68           C  
ATOM   1531  CG1 ILE A 235     -24.589  85.170  31.768  1.00  7.54           C  
ATOM   1532  CG2 ILE A 235     -25.802  84.061  29.785  1.00 15.11           C  
ATOM   1533  CD1 ILE A 235     -25.422  84.593  32.903  1.00  9.00           C  
ATOM   1534  N   ILE A 236     -23.060  84.962  28.311  1.00 10.55           N  
ATOM   1535  CA  ILE A 236     -21.741  84.425  28.029  1.00 15.64           C  
ATOM   1536  C   ILE A 236     -20.906  85.511  27.392  1.00 14.59           C  
ATOM   1537  O   ILE A 236     -19.723  85.669  27.723  1.00 18.04           O  
ATOM   1538  CB  ILE A 236     -21.790  83.178  27.092  1.00 10.07           C  
ATOM   1539  CG1 ILE A 236     -22.690  82.090  27.681  1.00  8.97           C  
ATOM   1540  CG2 ILE A 236     -20.407  82.654  26.848  1.00  9.75           C  
ATOM   1541  CD1 ILE A 236     -22.425  81.731  29.166  1.00  7.78           C  
ATOM   1542  N   VAL A 237     -21.513  86.253  26.469  1.00 13.52           N  
ATOM   1543  CA  VAL A 237     -20.817  87.353  25.792  1.00 10.45           C  
ATOM   1544  C   VAL A 237     -20.321  88.401  26.800  1.00  9.43           C  
ATOM   1545  O   VAL A 237     -19.230  88.939  26.663  1.00 15.01           O  
ATOM   1546  CB  VAL A 237     -21.697  88.040  24.748  1.00 10.42           C  
ATOM   1547  CG1 VAL A 237     -21.094  89.367  24.363  1.00  5.31           C  
ATOM   1548  CG2 VAL A 237     -21.768  87.186  23.493  1.00  9.23           C  
ATOM   1549  N   ALA A 238     -21.106  88.650  27.831  1.00  8.48           N  
ATOM   1550  CA  ALA A 238     -20.735  89.598  28.868  1.00  9.18           C  
ATOM   1551  C   ALA A 238     -19.546  89.068  29.679  1.00 12.95           C  
ATOM   1552  O   ALA A 238     -18.662  89.845  30.080  1.00 17.51           O  
ATOM   1553  CB  ALA A 238     -21.916  89.859  29.789  1.00  3.59           C  
ATOM   1554  N   MET A 239     -19.518  87.753  29.902  1.00 15.05           N  
ATOM   1555  CA  MET A 239     -18.452  87.083  30.642  1.00  7.35           C  
ATOM   1556  C   MET A 239     -17.166  87.131  29.864  1.00  8.43           C  
ATOM   1557  O   MET A 239     -16.124  87.503  30.413  1.00  8.08           O  
ATOM   1558  CB  MET A 239     -18.848  85.660  30.931  1.00  6.25           C  
ATOM   1559  CG  MET A 239     -19.916  85.536  32.031  1.00  7.45           C  
ATOM   1560  SD  MET A 239     -20.356  83.791  32.232  1.00 18.55           S  
ATOM   1561  CE  MET A 239     -21.694  83.945  33.377  1.00 21.10           C  
ATOM   1562  N   ALA A 240     -17.266  86.860  28.564  1.00  2.05           N  
ATOM   1563  CA  ALA A 240     -16.123  86.891  27.658  1.00  6.97           C  
ATOM   1564  C   ALA A 240     -15.499  88.292  27.569  1.00 12.61           C  
ATOM   1565  O   ALA A 240     -14.274  88.446  27.578  1.00 16.80           O  
ATOM   1566  CB  ALA A 240     -16.550  86.426  26.249  1.00  4.71           C  
ATOM   1567  N   LYS A 241     -16.344  89.311  27.428  1.00 14.83           N  
ATOM   1568  CA  LYS A 241     -15.888  90.692  27.321  1.00 13.07           C  
ATOM   1569  C   LYS A 241     -15.187  91.114  28.612  1.00  8.22           C  
ATOM   1570  O   LYS A 241     -14.169  91.793  28.584  1.00  9.53           O  
ATOM   1571  CB  LYS A 241     -17.074  91.612  27.001  1.00 16.74           C  
ATOM   1572  CG  LYS A 241     -16.826  93.058  27.306  1.00 16.60           C  
ATOM   1573  CD  LYS A 241     -17.961  93.934  26.864  1.00 14.85           C  
ATOM   1574  CE  LYS A 241     -17.711  95.312  27.404  1.00 14.41           C  
ATOM   1575  NZ  LYS A 241     -18.694  96.266  26.875  1.00 17.39           N  
ATOM   1576  N   GLU A 242     -15.743  90.702  29.740  1.00  7.60           N  
ATOM   1577  CA  GLU A 242     -15.163  91.013  31.044  1.00 10.28           C  
ATOM   1578  C   GLU A 242     -13.817  90.291  31.228  1.00 13.89           C  
ATOM   1579  O   GLU A 242     -12.923  90.798  31.878  1.00 19.32           O  
ATOM   1580  CB  GLU A 242     -16.129  90.593  32.120  1.00 10.67           C  
ATOM   1581  CG  GLU A 242     -15.924  91.239  33.433  1.00 30.65           C  
ATOM   1582  CD  GLU A 242     -17.223  91.380  34.172  1.00 37.82           C  
ATOM   1583  OE1 GLU A 242     -17.959  90.384  34.322  1.00 33.26           O  
ATOM   1584  OE2 GLU A 242     -17.524  92.514  34.592  1.00 55.40           O  
ATOM   1585  N   SER A 243     -13.667  89.132  30.608  1.00 12.66           N  
ATOM   1586  CA  SER A 243     -12.456  88.361  30.672  1.00  8.07           C  
ATOM   1587  C   SER A 243     -11.385  89.062  29.836  1.00  4.33           C  
ATOM   1588  O   SER A 243     -10.278  89.282  30.304  1.00  7.97           O  
ATOM   1589  CB  SER A 243     -12.730  86.955  30.130  1.00 10.46           C  
ATOM   1590  OG  SER A 243     -11.617  86.110  30.298  1.00  6.84           O  
ATOM   1591  N   VAL A 244     -11.692  89.396  28.594  1.00  2.46           N  
ATOM   1592  CA  VAL A 244     -10.738  90.092  27.732  1.00  4.72           C  
ATOM   1593  C   VAL A 244     -10.297  91.433  28.357  1.00  9.64           C  
ATOM   1594  O   VAL A 244      -9.119  91.788  28.346  1.00 14.06           O  
ATOM   1595  CB  VAL A 244     -11.339  90.354  26.346  1.00  4.80           C  
ATOM   1596  CG1 VAL A 244     -10.394  91.198  25.517  1.00  7.76           C  
ATOM   1597  CG2 VAL A 244     -11.637  89.027  25.643  1.00  2.58           C  
ATOM   1598  N   ASN A 245     -11.232  92.181  28.920  1.00  9.65           N  
ATOM   1599  CA  ASN A 245     -10.869  93.441  29.549  1.00  6.86           C  
ATOM   1600  C   ASN A 245      -9.861  93.239  30.677  1.00  5.98           C  
ATOM   1601  O   ASN A 245      -8.978  94.073  30.903  1.00  9.57           O  
ATOM   1602  CB  ASN A 245     -12.089  94.110  30.128  1.00  2.67           C  
ATOM   1603  CG  ASN A 245     -12.808  94.939  29.127  1.00  6.17           C  
ATOM   1604  OD1 ASN A 245     -12.215  95.406  28.153  1.00  6.94           O  
ATOM   1605  ND2 ASN A 245     -14.101  95.137  29.347  1.00  7.38           N  
ATOM   1606  N   ALA A 246      -9.991  92.132  31.391  1.00  6.09           N  
ATOM   1607  CA  ALA A 246      -9.085  91.825  32.499  1.00  6.07           C  
ATOM   1608  C   ALA A 246      -7.644  91.662  32.063  1.00  2.00           C  
ATOM   1609  O   ALA A 246      -6.766  91.757  32.899  1.00  4.54           O  
ATOM   1610  CB  ALA A 246      -9.552  90.599  33.267  1.00  7.43           C  
ATOM   1611  N   ALA A 247      -7.403  91.483  30.768  1.00  2.00           N  
ATOM   1612  CA  ALA A 247      -6.040  91.393  30.263  1.00  2.85           C  
ATOM   1613  C   ALA A 247      -5.246  92.683  30.507  1.00  7.81           C  
ATOM   1614  O   ALA A 247      -4.027  92.700  30.344  1.00 16.54           O  
ATOM   1615  CB  ALA A 247      -6.034  91.072  28.745  1.00  2.00           C  
ATOM   1616  N   PHE A 248      -5.919  93.774  30.860  1.00  5.00           N  
ATOM   1617  CA  PHE A 248      -5.214  95.030  31.088  1.00  2.10           C  
ATOM   1618  C   PHE A 248      -5.211  95.388  32.550  1.00  3.16           C  
ATOM   1619  O   PHE A 248      -4.647  96.416  32.923  1.00  7.49           O  
ATOM   1620  CB  PHE A 248      -5.868  96.165  30.300  1.00  3.31           C  
ATOM   1621  CG  PHE A 248      -6.000  95.873  28.847  1.00  2.00           C  
ATOM   1622  CD1 PHE A 248      -4.889  95.970  28.018  1.00  2.00           C  
ATOM   1623  CD2 PHE A 248      -7.215  95.473  28.304  1.00  2.00           C  
ATOM   1624  CE1 PHE A 248      -4.975  95.664  26.661  1.00  2.00           C  
ATOM   1625  CE2 PHE A 248      -7.325  95.168  26.943  1.00  2.00           C  
ATOM   1626  CZ  PHE A 248      -6.200  95.260  26.123  1.00  2.00           C  
ATOM   1627  N   GLU A 249      -5.776  94.522  33.386  1.00  2.00           N  
ATOM   1628  CA  GLU A 249      -5.877  94.813  34.804  1.00  2.00           C  
ATOM   1629  C   GLU A 249      -5.167  93.869  35.737  1.00  5.67           C  
ATOM   1630  O   GLU A 249      -5.276  94.026  36.965  1.00  7.33           O  
ATOM   1631  CB  GLU A 249      -7.345  94.839  35.218  1.00  2.00           C  
ATOM   1632  CG  GLU A 249      -8.279  95.597  34.281  1.00  4.00           C  
ATOM   1633  CD  GLU A 249      -8.042  97.096  34.260  1.00  8.07           C  
ATOM   1634  OE1 GLU A 249      -7.510  97.628  35.253  1.00 10.08           O  
ATOM   1635  OE2 GLU A 249      -8.411  97.741  33.259  1.00  8.99           O  
ATOM   1636  N   MET A 250      -4.451  92.883  35.198  1.00  7.03           N  
ATOM   1637  CA  MET A 250      -3.788  91.870  36.038  1.00  6.23           C  
ATOM   1638  C   MET A 250      -2.623  91.280  35.347  1.00  5.01           C  
ATOM   1639  O   MET A 250      -2.541  91.350  34.110  1.00  3.81           O  
ATOM   1640  CB  MET A 250      -4.716  90.670  36.221  1.00 12.22           C  
ATOM   1641  CG  MET A 250      -5.885  90.862  37.103  1.00 17.79           C  
ATOM   1642  SD  MET A 250      -7.001  89.618  36.677  1.00 14.59           S  
ATOM   1643  CE  MET A 250      -8.253  89.987  37.694  1.00 20.21           C  
ATOM   1644  N   THR A 251      -1.867  90.488  36.114  1.00  5.50           N  
ATOM   1645  CA  THR A 251      -0.721  89.753  35.565  1.00  5.25           C  
ATOM   1646  C   THR A 251      -1.360  88.606  34.779  1.00  5.84           C  
ATOM   1647  O   THR A 251      -2.525  88.237  35.033  1.00 10.41           O  
ATOM   1648  CB  THR A 251       0.125  89.129  36.659  1.00  2.00           C  
ATOM   1649  OG1 THR A 251      -0.717  88.305  37.456  1.00  4.55           O  
ATOM   1650  CG2 THR A 251       0.765  90.206  37.546  1.00  2.15           C  
ATOM   1651  N   LEU A 252      -0.596  87.996  33.889  1.00  3.18           N  
ATOM   1652  CA  LEU A 252      -1.103  86.903  33.084  1.00  4.10           C  
ATOM   1653  C   LEU A 252      -1.550  85.752  33.968  1.00 10.05           C  
ATOM   1654  O   LEU A 252      -2.559  85.117  33.697  1.00 17.39           O  
ATOM   1655  CB  LEU A 252      -0.040  86.449  32.109  1.00  6.07           C  
ATOM   1656  CG  LEU A 252      -0.481  85.347  31.176  1.00  3.21           C  
ATOM   1657  CD1 LEU A 252      -1.819  85.644  30.572  1.00  5.14           C  
ATOM   1658  CD2 LEU A 252       0.602  85.213  30.118  1.00  2.00           C  
ATOM   1659  N   THR A 253      -0.823  85.492  35.048  1.00  7.45           N  
ATOM   1660  CA  THR A 253      -1.217  84.442  35.976  1.00  4.65           C  
ATOM   1661  C   THR A 253      -2.637  84.639  36.484  1.00  5.25           C  
ATOM   1662  O   THR A 253      -3.456  83.742  36.377  1.00 14.97           O  
ATOM   1663  CB  THR A 253      -0.293  84.414  37.164  1.00  2.50           C  
ATOM   1664  OG1 THR A 253       0.985  83.978  36.724  1.00  8.36           O  
ATOM   1665  CG2 THR A 253      -0.766  83.480  38.214  1.00  2.00           C  
ATOM   1666  N   GLU A 254      -2.931  85.816  37.030  1.00  9.67           N  
ATOM   1667  CA  GLU A 254      -4.267  86.128  37.559  1.00  3.88           C  
ATOM   1668  C   GLU A 254      -5.351  86.297  36.506  1.00  8.30           C  
ATOM   1669  O   GLU A 254      -6.515  85.930  36.738  1.00 10.45           O  
ATOM   1670  CB  GLU A 254      -4.198  87.343  38.437  1.00  3.47           C  
ATOM   1671  CG  GLU A 254      -3.290  87.138  39.617  1.00  7.10           C  
ATOM   1672  CD  GLU A 254      -3.712  85.980  40.511  1.00 11.45           C  
ATOM   1673  OE1 GLU A 254      -4.907  85.857  40.830  1.00 17.06           O  
ATOM   1674  OE2 GLU A 254      -2.840  85.198  40.931  1.00 15.76           O  
ATOM   1675  N   GLY A 255      -4.975  86.808  35.339  1.00  4.32           N  
ATOM   1676  CA  GLY A 255      -5.931  86.942  34.260  1.00  6.37           C  
ATOM   1677  C   GLY A 255      -6.433  85.553  33.908  1.00 10.88           C  
ATOM   1678  O   GLY A 255      -7.651  85.318  33.858  1.00 15.34           O  
ATOM   1679  N   ASN A 256      -5.491  84.626  33.699  1.00 14.81           N  
ATOM   1680  CA  ASN A 256      -5.779  83.217  33.395  1.00  6.47           C  
ATOM   1681  C   ASN A 256      -6.665  82.572  34.489  1.00  8.81           C  
ATOM   1682  O   ASN A 256      -7.620  81.873  34.175  1.00 15.81           O  
ATOM   1683  CB  ASN A 256      -4.482  82.454  33.255  1.00  2.00           C  
ATOM   1684  CG  ASN A 256      -3.897  82.608  31.909  1.00  2.07           C  
ATOM   1685  OD1 ASN A 256      -4.548  83.089  31.005  1.00 11.00           O  
ATOM   1686  ND2 ASN A 256      -2.673  82.178  31.740  1.00 11.53           N  
ATOM   1687  N   LYS A 257      -6.404  82.860  35.762  1.00  3.80           N  
ATOM   1688  CA  LYS A 257      -7.212  82.307  36.837  1.00  6.10           C  
ATOM   1689  C   LYS A 257      -8.616  82.873  36.849  1.00 12.41           C  
ATOM   1690  O   LYS A 257      -9.583  82.160  37.166  1.00 17.18           O  
ATOM   1691  CB  LYS A 257      -6.577  82.561  38.191  1.00  8.93           C  
ATOM   1692  CG  LYS A 257      -5.304  81.737  38.504  1.00 15.35           C  
ATOM   1693  CD  LYS A 257      -5.033  81.756  40.027  1.00 17.42           C  
ATOM   1694  CE  LYS A 257      -3.545  81.635  40.332  1.00 29.47           C  
ATOM   1695  NZ  LYS A 257      -3.140  82.197  41.679  1.00 34.10           N  
ATOM   1696  N   LEU A 258      -8.735  84.176  36.601  1.00 13.76           N  
ATOM   1697  CA  LEU A 258     -10.043  84.825  36.554  1.00 11.69           C  
ATOM   1698  C   LEU A 258     -10.813  84.212  35.369  1.00 13.02           C  
ATOM   1699  O   LEU A 258     -11.974  83.824  35.488  1.00 15.29           O  
ATOM   1700  CB  LEU A 258      -9.898  86.329  36.308  1.00 16.26           C  
ATOM   1701  CG  LEU A 258     -11.233  87.046  36.031  1.00  8.85           C  
ATOM   1702  CD1 LEU A 258     -11.946  87.411  37.307  1.00  5.94           C  
ATOM   1703  CD2 LEU A 258     -10.981  88.233  35.233  1.00  4.20           C  
ATOM   1704  N   GLU A 259     -10.156  84.151  34.221  1.00 12.10           N  
ATOM   1705  CA  GLU A 259     -10.756  83.578  33.038  1.00 11.29           C  
ATOM   1706  C   GLU A 259     -11.273  82.165  33.337  1.00 14.94           C  
ATOM   1707  O   GLU A 259     -12.395  81.839  32.978  1.00 17.87           O  
ATOM   1708  CB  GLU A 259      -9.734  83.515  31.928  1.00  2.00           C  
ATOM   1709  CG  GLU A 259     -10.291  82.959  30.671  1.00  2.50           C  
ATOM   1710  CD  GLU A 259      -9.204  82.443  29.772  1.00  9.01           C  
ATOM   1711  OE1 GLU A 259      -8.690  81.354  30.060  1.00 20.90           O  
ATOM   1712  OE2 GLU A 259      -8.833  83.107  28.793  1.00 15.63           O  
ATOM   1713  N   LYS A 260     -10.463  81.347  34.015  1.00 16.81           N  
ATOM   1714  CA  LYS A 260     -10.831  79.964  34.332  1.00 13.68           C  
ATOM   1715  C   LYS A 260     -12.086  79.973  35.168  1.00 13.95           C  
ATOM   1716  O   LYS A 260     -12.986  79.181  34.928  1.00 20.52           O  
ATOM   1717  CB  LYS A 260      -9.714  79.248  35.097  1.00 12.04           C  
ATOM   1718  CG  LYS A 260      -9.888  77.735  35.220  1.00 17.64           C  
ATOM   1719  CD  LYS A 260      -9.485  76.963  33.930  1.00 19.17           C  
ATOM   1720  CE  LYS A 260      -7.971  77.010  33.716  1.00 20.48           C  
ATOM   1721  NZ  LYS A 260      -7.455  76.260  32.533  1.00 25.59           N  
ATOM   1722  N   LYS A 261     -12.176  80.913  36.103  1.00 11.43           N  
ATOM   1723  CA  LYS A 261     -13.342  81.010  36.969  1.00 11.38           C  
ATOM   1724  C   LYS A 261     -14.610  81.419  36.249  1.00 14.87           C  
ATOM   1725  O   LYS A 261     -15.713  80.997  36.616  1.00 20.32           O  
ATOM   1726  CB  LYS A 261     -13.052  81.903  38.167  1.00 13.07           C  
ATOM   1727  CG  LYS A 261     -12.201  81.172  39.218  1.00 14.88           C  
ATOM   1728  CD  LYS A 261     -11.803  82.072  40.366  1.00 21.96           C  
ATOM   1729  CE  LYS A 261     -10.890  81.359  41.378  1.00 21.80           C  
ATOM   1730  NZ  LYS A 261      -9.630  80.900  40.749  1.00 21.69           N  
ATOM   1731  N   LEU A 262     -14.458  82.224  35.209  1.00 14.13           N  
ATOM   1732  CA  LEU A 262     -15.585  82.658  34.403  1.00 13.87           C  
ATOM   1733  C   LEU A 262     -15.991  81.475  33.540  1.00 15.12           C  
ATOM   1734  O   LEU A 262     -17.184  81.193  33.380  1.00 19.52           O  
ATOM   1735  CB  LEU A 262     -15.198  83.859  33.526  1.00  6.74           C  
ATOM   1736  CG  LEU A 262     -15.148  85.171  34.336  1.00  8.34           C  
ATOM   1737  CD1 LEU A 262     -14.633  86.292  33.483  1.00  8.73           C  
ATOM   1738  CD2 LEU A 262     -16.534  85.531  34.884  1.00  5.42           C  
ATOM   1739  N   PHE A 263     -14.978  80.765  33.041  1.00 15.78           N  
ATOM   1740  CA  PHE A 263     -15.137  79.578  32.202  1.00 10.84           C  
ATOM   1741  C   PHE A 263     -15.953  78.575  32.992  1.00 11.26           C  
ATOM   1742  O   PHE A 263     -16.943  78.078  32.513  1.00 17.96           O  
ATOM   1743  CB  PHE A 263     -13.776  79.009  31.842  1.00  4.78           C  
ATOM   1744  CG  PHE A 263     -13.840  77.678  31.195  1.00 11.37           C  
ATOM   1745  CD1 PHE A 263     -14.378  77.537  29.914  1.00 14.29           C  
ATOM   1746  CD2 PHE A 263     -13.366  76.543  31.868  1.00 11.86           C  
ATOM   1747  CE1 PHE A 263     -14.458  76.263  29.287  1.00 13.32           C  
ATOM   1748  CE2 PHE A 263     -13.432  75.275  31.272  1.00 14.14           C  
ATOM   1749  CZ  PHE A 263     -13.981  75.131  29.975  1.00 11.53           C  
ATOM   1750  N   TYR A 264     -15.598  78.341  34.240  1.00 10.23           N  
ATOM   1751  CA  TYR A 264     -16.351  77.396  35.067  1.00 14.07           C  
ATOM   1752  C   TYR A 264     -17.805  77.899  35.248  1.00 17.28           C  
ATOM   1753  O   TYR A 264     -18.756  77.109  35.317  1.00 21.43           O  
ATOM   1754  CB  TYR A 264     -15.700  77.239  36.459  1.00  2.92           C  
ATOM   1755  CG  TYR A 264     -14.349  76.563  36.491  1.00  8.79           C  
ATOM   1756  CD1 TYR A 264     -13.842  75.896  35.382  1.00 10.38           C  
ATOM   1757  CD2 TYR A 264     -13.583  76.568  37.665  1.00 10.44           C  
ATOM   1758  CE1 TYR A 264     -12.609  75.253  35.447  1.00 13.27           C  
ATOM   1759  CE2 TYR A 264     -12.367  75.933  37.745  1.00  7.56           C  
ATOM   1760  CZ  TYR A 264     -11.879  75.272  36.640  1.00 17.24           C  
ATOM   1761  OH  TYR A 264     -10.676  74.610  36.755  1.00 27.90           O  
ATOM   1762  N   SER A 265     -17.963  79.213  35.372  1.00 16.69           N  
ATOM   1763  CA  SER A 265     -19.260  79.848  35.551  1.00 12.85           C  
ATOM   1764  C   SER A 265     -20.195  79.592  34.388  1.00 13.70           C  
ATOM   1765  O   SER A 265     -21.403  79.465  34.588  1.00 13.19           O  
ATOM   1766  CB  SER A 265     -19.081  81.348  35.679  1.00 14.00           C  
ATOM   1767  OG  SER A 265     -18.703  81.700  36.990  1.00 25.33           O  
ATOM   1768  N   THR A 266     -19.646  79.509  33.174  1.00 10.69           N  
ATOM   1769  CA  THR A 266     -20.474  79.281  32.004  1.00  9.90           C  
ATOM   1770  C   THR A 266     -21.226  77.959  32.133  1.00 19.57           C  
ATOM   1771  O   THR A 266     -22.342  77.829  31.639  1.00 24.04           O  
ATOM   1772  CB  THR A 266     -19.684  79.352  30.680  1.00 11.77           C  
ATOM   1773  OG1 THR A 266     -18.757  78.259  30.544  1.00 12.87           O  
ATOM   1774  CG2 THR A 266     -18.928  80.631  30.610  1.00  9.99           C  
ATOM   1775  N   PHE A 267     -20.656  77.017  32.893  1.00 22.05           N  
ATOM   1776  CA  PHE A 267     -21.266  75.698  33.104  1.00 18.24           C  
ATOM   1777  C   PHE A 267     -22.476  75.810  34.022  1.00 17.07           C  
ATOM   1778  O   PHE A 267     -23.230  74.862  34.172  1.00 20.60           O  
ATOM   1779  CB  PHE A 267     -20.230  74.695  33.630  1.00 10.48           C  
ATOM   1780  CG  PHE A 267     -19.299  74.212  32.567  1.00 16.07           C  
ATOM   1781  CD1 PHE A 267     -18.285  75.028  32.103  1.00 13.68           C  
ATOM   1782  CD2 PHE A 267     -19.506  72.981  31.941  1.00 16.63           C  
ATOM   1783  CE1 PHE A 267     -17.488  74.645  31.006  1.00 19.74           C  
ATOM   1784  CE2 PHE A 267     -18.718  72.581  30.846  1.00 17.15           C  
ATOM   1785  CZ  PHE A 267     -17.716  73.414  30.374  1.00 18.41           C  
ATOM   1786  N   ALA A 268     -22.681  76.986  34.604  1.00 11.22           N  
ATOM   1787  CA  ALA A 268     -23.825  77.210  35.484  1.00 11.38           C  
ATOM   1788  C   ALA A 268     -25.008  77.749  34.676  1.00 17.88           C  
ATOM   1789  O   ALA A 268     -26.078  78.001  35.232  1.00 17.68           O  
ATOM   1790  CB  ALA A 268     -23.474  78.204  36.592  1.00  6.27           C  
ATOM   1791  N   THR A 269     -24.809  77.949  33.370  1.00 18.64           N  
ATOM   1792  CA  THR A 269     -25.869  78.473  32.517  1.00 17.32           C  
ATOM   1793  C   THR A 269     -26.481  77.420  31.575  1.00 22.78           C  
ATOM   1794  O   THR A 269     -25.843  76.400  31.223  1.00 27.96           O  
ATOM   1795  CB  THR A 269     -25.346  79.669  31.657  1.00 10.21           C  
ATOM   1796  OG1 THR A 269     -24.528  79.182  30.584  1.00 14.96           O  
ATOM   1797  CG2 THR A 269     -24.555  80.627  32.508  1.00  5.14           C  
ATOM   1798  N   ASP A 270     -27.692  77.710  31.106  1.00 19.99           N  
ATOM   1799  CA  ASP A 270     -28.370  76.826  30.189  1.00 18.08           C  
ATOM   1800  C   ASP A 270     -27.776  76.935  28.796  1.00 20.23           C  
ATOM   1801  O   ASP A 270     -27.690  75.934  28.055  1.00 25.11           O  
ATOM   1802  CB  ASP A 270     -29.848  77.164  30.161  1.00 20.84           C  
ATOM   1803  CG  ASP A 270     -30.509  76.957  31.500  1.00 25.88           C  
ATOM   1804  OD1 ASP A 270     -30.313  75.881  32.117  1.00 34.66           O  
ATOM   1805  OD2 ASP A 270     -31.223  77.874  31.948  1.00 27.36           O  
ATOM   1806  N   ASP A 271     -27.360  78.150  28.455  1.00 16.37           N  
ATOM   1807  CA  ASP A 271     -26.786  78.446  27.153  1.00 16.54           C  
ATOM   1808  C   ASP A 271     -25.571  77.623  26.802  1.00 13.25           C  
ATOM   1809  O   ASP A 271     -25.419  77.222  25.645  1.00 17.93           O  
ATOM   1810  CB  ASP A 271     -26.483  79.940  27.042  1.00 23.47           C  
ATOM   1811  CG  ASP A 271     -27.748  80.776  26.828  1.00 29.02           C  
ATOM   1812  OD1 ASP A 271     -28.644  80.352  26.088  1.00 25.43           O  
ATOM   1813  OD2 ASP A 271     -27.856  81.865  27.398  1.00 32.38           O  
ATOM   1814  N   ARG A 272     -24.723  77.362  27.796  1.00 14.53           N  
ATOM   1815  CA  ARG A 272     -23.526  76.557  27.594  1.00 15.58           C  
ATOM   1816  C   ARG A 272     -23.965  75.142  27.299  1.00 13.28           C  
ATOM   1817  O   ARG A 272     -23.446  74.520  26.388  1.00 19.73           O  
ATOM   1818  CB  ARG A 272     -22.632  76.582  28.810  1.00 15.64           C  
ATOM   1819  CG  ARG A 272     -21.413  75.770  28.589  1.00 13.36           C  
ATOM   1820  CD  ARG A 272     -21.300  74.809  29.739  1.00 22.40           C  
ATOM   1821  NE  ARG A 272     -21.852  73.488  29.434  1.00 24.04           N  
ATOM   1822  CZ  ARG A 272     -22.818  72.889  30.132  1.00 27.22           C  
ATOM   1823  NH1 ARG A 272     -23.400  73.496  31.187  1.00 23.06           N  
ATOM   1824  NH2 ARG A 272     -23.141  71.642  29.825  1.00 23.93           N  
ATOM   1825  N   ARG A 273     -24.946  74.657  28.057  1.00 17.55           N  
ATOM   1826  CA  ARG A 273     -25.528  73.326  27.852  1.00 22.90           C  
ATOM   1827  C   ARG A 273     -25.978  73.247  26.385  1.00 23.25           C  
ATOM   1828  O   ARG A 273     -25.550  72.374  25.606  1.00 27.24           O  
ATOM   1829  CB  ARG A 273     -26.757  73.181  28.747  1.00 26.55           C  
ATOM   1830  CG  ARG A 273     -27.133  71.741  29.081  1.00 39.46           C  
ATOM   1831  CD  ARG A 273     -27.950  71.685  30.381  1.00 51.87           C  
ATOM   1832  NE  ARG A 273     -27.307  72.435  31.478  1.00 63.97           N  
ATOM   1833  CZ  ARG A 273     -27.902  72.755  32.628  1.00 66.37           C  
ATOM   1834  NH1 ARG A 273     -29.156  72.399  32.840  1.00 68.11           N  
ATOM   1835  NH2 ARG A 273     -27.261  73.447  33.580  1.00 64.87           N  
ATOM   1836  N   GLU A 274     -26.763  74.248  26.003  1.00 18.75           N  
ATOM   1837  CA  GLU A 274     -27.307  74.388  24.680  1.00 14.52           C  
ATOM   1838  C   GLU A 274     -26.271  74.481  23.578  1.00 18.54           C  
ATOM   1839  O   GLU A 274     -26.369  73.791  22.547  1.00 22.86           O  
ATOM   1840  CB  GLU A 274     -28.205  75.626  24.634  1.00 17.29           C  
ATOM   1841  CG  GLU A 274     -28.743  75.971  23.232  1.00 23.10           C  
ATOM   1842  CD  GLU A 274     -29.482  74.811  22.576  1.00 29.11           C  
ATOM   1843  OE1 GLU A 274     -29.978  73.913  23.293  1.00 32.94           O  
ATOM   1844  OE2 GLU A 274     -29.572  74.783  21.338  1.00 32.64           O  
ATOM   1845  N   GLY A 275     -25.268  75.318  23.779  1.00 14.03           N  
ATOM   1846  CA  GLY A 275     -24.290  75.483  22.726  1.00 15.43           C  
ATOM   1847  C   GLY A 275     -23.450  74.265  22.494  1.00 18.49           C  
ATOM   1848  O   GLY A 275     -23.031  74.005  21.371  1.00 19.07           O  
ATOM   1849  N   MET A 276     -23.185  73.519  23.567  1.00 21.26           N  
ATOM   1850  CA  MET A 276     -22.352  72.326  23.473  1.00 22.29           C  
ATOM   1851  C   MET A 276     -23.115  71.106  22.949  1.00 24.91           C  
ATOM   1852  O   MET A 276     -22.579  70.313  22.145  1.00 24.29           O  
ATOM   1853  CB  MET A 276     -21.707  72.054  24.819  1.00 19.53           C  
ATOM   1854  CG  MET A 276     -20.708  73.103  25.170  1.00 19.06           C  
ATOM   1855  SD  MET A 276     -19.385  72.409  26.092  1.00 29.35           S  
ATOM   1856  CE  MET A 276     -18.583  73.919  26.742  1.00 25.89           C  
ATOM   1857  N   SER A 277     -24.363  70.969  23.393  1.00 21.37           N  
ATOM   1858  CA  SER A 277     -25.195  69.869  22.951  1.00 23.44           C  
ATOM   1859  C   SER A 277     -25.403  70.030  21.447  1.00 26.36           C  
ATOM   1860  O   SER A 277     -25.209  69.083  20.680  1.00 27.36           O  
ATOM   1861  CB  SER A 277     -26.524  69.880  23.687  1.00 23.95           C  
ATOM   1862  OG  SER A 277     -26.330  69.669  25.082  1.00 32.08           O  
ATOM   1863  N   ALA A 278     -25.659  71.262  21.019  1.00 20.03           N  
ATOM   1864  CA  ALA A 278     -25.892  71.546  19.617  1.00 18.48           C  
ATOM   1865  C   ALA A 278     -24.735  71.146  18.705  1.00 25.23           C  
ATOM   1866  O   ALA A 278     -24.955  70.748  17.556  1.00 33.28           O  
ATOM   1867  CB  ALA A 278     -26.190  72.998  19.447  1.00 18.94           C  
ATOM   1868  N   PHE A 279     -23.501  71.240  19.190  1.00 26.52           N  
ATOM   1869  CA  PHE A 279     -22.328  70.870  18.377  1.00 25.04           C  
ATOM   1870  C   PHE A 279     -22.346  69.336  18.226  1.00 29.64           C  
ATOM   1871  O   PHE A 279     -22.213  68.795  17.113  1.00 28.47           O  
ATOM   1872  CB  PHE A 279     -21.036  71.315  19.084  1.00 21.24           C  
ATOM   1873  CG  PHE A 279     -19.772  70.925  18.350  1.00 22.10           C  
ATOM   1874  CD1 PHE A 279     -19.372  71.634  17.222  1.00 19.45           C  
ATOM   1875  CD2 PHE A 279     -19.002  69.822  18.768  1.00 22.63           C  
ATOM   1876  CE1 PHE A 279     -18.225  71.269  16.493  1.00 21.67           C  
ATOM   1877  CE2 PHE A 279     -17.850  69.432  18.066  1.00 22.27           C  
ATOM   1878  CZ  PHE A 279     -17.458  70.160  16.913  1.00 22.70           C  
ATOM   1879  N   VAL A 280     -22.540  68.661  19.368  1.00 30.34           N  
ATOM   1880  CA  VAL A 280     -22.593  67.207  19.463  1.00 31.93           C  
ATOM   1881  C   VAL A 280     -23.769  66.685  18.632  1.00 35.66           C  
ATOM   1882  O   VAL A 280     -23.595  65.787  17.796  1.00 40.11           O  
ATOM   1883  CB  VAL A 280     -22.753  66.765  20.945  1.00 31.61           C  
ATOM   1884  CG1 VAL A 280     -22.796  65.253  21.046  1.00 32.04           C  
ATOM   1885  CG2 VAL A 280     -21.565  67.279  21.775  1.00 30.76           C  
ATOM   1886  N   GLU A 281     -24.949  67.285  18.856  1.00 33.53           N  
ATOM   1887  CA  GLU A 281     -26.201  66.954  18.158  1.00 29.59           C  
ATOM   1888  C   GLU A 281     -26.198  67.490  16.738  1.00 30.33           C  
ATOM   1889  O   GLU A 281     -27.209  67.417  16.036  1.00 33.51           O  
ATOM   1890  CB  GLU A 281     -27.422  67.521  18.895  1.00 23.03           C  
ATOM   1891  CG  GLU A 281     -27.731  66.787  20.179  1.00 27.75           C  
ATOM   1892  CD  GLU A 281     -28.921  67.369  20.928  1.00 31.49           C  
ATOM   1893  OE1 GLU A 281     -29.704  68.109  20.296  1.00 36.09           O  
ATOM   1894  OE2 GLU A 281     -29.089  67.069  22.143  1.00 31.88           O  
ATOM   1895  N   LYS A 282     -25.087  68.091  16.343  1.00 31.99           N  
ATOM   1896  CA  LYS A 282     -24.938  68.631  15.007  1.00 34.77           C  
ATOM   1897  C   LYS A 282     -26.125  69.432  14.493  1.00 35.47           C  
ATOM   1898  O   LYS A 282     -26.536  69.303  13.334  1.00 39.83           O  
ATOM   1899  CB  LYS A 282     -24.608  67.510  14.041  1.00 39.53           C  
ATOM   1900  CG  LYS A 282     -23.283  66.858  14.348  1.00 43.49           C  
ATOM   1901  CD  LYS A 282     -22.680  66.283  13.097  1.00 48.06           C  
ATOM   1902  CE  LYS A 282     -21.234  65.904  13.337  1.00 52.73           C  
ATOM   1903  NZ  LYS A 282     -20.623  65.354  12.100  1.00 58.00           N  
ATOM   1904  N   ARG A 283     -26.646  70.292  15.354  1.00 34.59           N  
ATOM   1905  CA  ARG A 283     -27.768  71.165  15.013  1.00 32.62           C  
ATOM   1906  C   ARG A 283     -27.391  72.600  15.374  1.00 35.62           C  
ATOM   1907  O   ARG A 283     -26.260  72.870  15.792  1.00 39.75           O  
ATOM   1908  CB  ARG A 283     -28.982  70.771  15.840  1.00 28.93           C  
ATOM   1909  CG  ARG A 283     -28.702  70.866  17.302  1.00 25.15           C  
ATOM   1910  CD  ARG A 283     -29.935  70.628  18.090  1.00 23.71           C  
ATOM   1911  NE  ARG A 283     -29.613  70.658  19.503  1.00 19.99           N  
ATOM   1912  CZ  ARG A 283     -29.937  71.653  20.308  1.00 21.03           C  
ATOM   1913  NH1 ARG A 283     -30.589  72.715  19.844  1.00 25.69           N  
ATOM   1914  NH2 ARG A 283     -29.675  71.545  21.594  1.00 24.35           N  
ATOM   1915  N   LYS A 284     -28.366  73.502  15.282  1.00 39.17           N  
ATOM   1916  CA  LYS A 284     -28.169  74.930  15.610  1.00 39.17           C  
ATOM   1917  C   LYS A 284     -28.502  75.210  17.078  1.00 39.90           C  
ATOM   1918  O   LYS A 284     -29.542  74.762  17.596  1.00 43.10           O  
ATOM   1919  CB  LYS A 284     -29.049  75.823  14.726  1.00 42.08           C  
ATOM   1920  CG  LYS A 284     -28.652  77.285  14.687  1.00 50.03           C  
ATOM   1921  CD  LYS A 284     -29.643  78.061  13.830  1.00 59.17           C  
ATOM   1922  CE  LYS A 284     -29.123  79.432  13.364  1.00 63.54           C  
ATOM   1923  NZ  LYS A 284     -30.212  80.232  12.692  1.00 66.29           N  
ATOM   1924  N   ALA A 285     -27.633  75.996  17.718  1.00 39.59           N  
ATOM   1925  CA  ALA A 285     -27.760  76.368  19.123  1.00 31.40           C  
ATOM   1926  C   ALA A 285     -28.868  77.387  19.236  1.00 30.08           C  
ATOM   1927  O   ALA A 285     -28.984  78.246  18.373  1.00 34.44           O  
ATOM   1928  CB  ALA A 285     -26.444  76.970  19.604  1.00 26.10           C  
ATOM   1929  N   ASN A 286     -29.681  77.289  20.284  1.00 29.89           N  
ATOM   1930  CA  ASN A 286     -30.793  78.224  20.519  1.00 28.70           C  
ATOM   1931  C   ASN A 286     -30.562  78.894  21.853  1.00 27.27           C  
ATOM   1932  O   ASN A 286     -31.037  78.404  22.904  1.00 23.81           O  
ATOM   1933  CB  ASN A 286     -32.113  77.486  20.643  1.00 40.84           C  
ATOM   1934  CG  ASN A 286     -32.734  77.151  19.319  1.00 48.39           C  
ATOM   1935  OD1 ASN A 286     -33.789  77.693  18.977  1.00 57.27           O  
ATOM   1936  ND2 ASN A 286     -32.157  76.176  18.611  1.00 45.71           N  
ATOM   1937  N   PHE A 287     -29.835  80.011  21.829  1.00 25.12           N  
ATOM   1938  CA  PHE A 287     -29.515  80.729  23.071  1.00 23.62           C  
ATOM   1939  C   PHE A 287     -30.679  81.524  23.614  1.00 19.38           C  
ATOM   1940  O   PHE A 287     -31.488  82.035  22.865  1.00 26.73           O  
ATOM   1941  CB  PHE A 287     -28.303  81.634  22.903  1.00 17.76           C  
ATOM   1942  CG  PHE A 287     -27.078  80.903  22.482  1.00 15.49           C  
ATOM   1943  CD1 PHE A 287     -26.538  79.907  23.301  1.00 15.06           C  
ATOM   1944  CD2 PHE A 287     -26.466  81.192  21.261  1.00 15.42           C  
ATOM   1945  CE1 PHE A 287     -25.397  79.197  22.916  1.00 14.18           C  
ATOM   1946  CE2 PHE A 287     -25.303  80.491  20.840  1.00 19.17           C  
ATOM   1947  CZ  PHE A 287     -24.768  79.486  21.669  1.00 13.37           C  
ATOM   1948  N   LYS A 288     -30.789  81.553  24.934  1.00 17.59           N  
ATOM   1949  CA  LYS A 288     -31.850  82.267  25.621  1.00 17.65           C  
ATOM   1950  C   LYS A 288     -31.327  83.179  26.733  1.00 21.13           C  
ATOM   1951  O   LYS A 288     -32.021  83.518  27.732  1.00 15.15           O  
ATOM   1952  CB  LYS A 288     -32.872  81.286  26.151  1.00 23.09           C  
ATOM   1953  CG  LYS A 288     -33.760  80.814  25.045  1.00 32.11           C  
ATOM   1954  CD  LYS A 288     -34.601  79.693  25.523  1.00 46.64           C  
ATOM   1955  CE  LYS A 288     -35.554  79.276  24.420  1.00 55.89           C  
ATOM   1956  NZ  LYS A 288     -34.894  78.968  23.106  1.00 59.97           N  
ATOM   1957  N   ASP A 289     -30.062  83.538  26.560  1.00 19.78           N  
ATOM   1958  CA  ASP A 289     -29.392  84.445  27.456  1.00 16.38           C  
ATOM   1959  C   ASP A 289     -29.400  84.120  28.947  1.00 15.68           C  
ATOM   1960  O   ASP A 289     -29.559  84.992  29.789  1.00 18.86           O  
ATOM   1961  CB  ASP A 289     -29.877  85.854  27.164  1.00 15.75           C  
ATOM   1962  CG  ASP A 289     -29.869  86.170  25.659  1.00 18.98           C  
ATOM   1963  OD1 ASP A 289     -28.978  85.684  24.898  1.00 17.18           O  
ATOM   1964  OD2 ASP A 289     -30.787  86.909  25.228  1.00 29.01           O  
ATOM   1965  N   HIS A 290     -29.325  82.837  29.260  1.00 19.74           N  
ATOM   1966  CA  HIS A 290     -29.194  82.386  30.636  1.00 21.09           C  
ATOM   1967  C   HIS A 290     -28.770  80.937  30.745  1.00 19.71           C  
ATOM   1968  O   HIS A 290     -28.280  80.406  29.717  1.00 11.85           O  
ATOM   1969  CB  HIS A 290     -30.328  82.835  31.596  1.00 29.27           C  
ATOM   1970  CG  HIS A 290     -31.548  81.962  31.644  1.00 44.94           C  
ATOM   1971  ND1 HIS A 290     -32.377  81.742  30.556  1.00 46.76           N  
ATOM   1972  CD2 HIS A 290     -32.150  81.355  32.698  1.00 49.16           C  
ATOM   1973  CE1 HIS A 290     -33.428  81.039  30.943  1.00 49.89           C  
ATOM   1974  NE2 HIS A 290     -33.317  80.792  32.235  1.00 52.16           N  
ATOM   1975  OXT HIS A 290     -28.738  80.428  31.881  1.00 19.18           O  
TER    1976      HIS A 290                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
