
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  251 ( 1928),  selected  251 , name 2vsu_C
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 2vsu_C.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     6_C      -       -           -
LGA    R     7_C      -       -           -
LGA    W     8_C      P      32           #
LGA    K     9_C      R      33          0.773
LGA    T    10_C      P      34          0.748
LGA    V    11_C      T      35          0.422
LGA    K    12_C      S      36          0.456
LGA    V    13_C      A      37          0.767
LGA    E    14_C      R      38          1.894
LGA    I    15_C      Q      39          1.916
LGA    E    16_C      L      40          2.715
LGA    D    17_C      D      41          2.346
LGA    G    18_C      G      42          1.988
LGA    I    19_C      I      43          1.321
LGA    A    20_C      R      44          0.970
LGA    F    21_C      N      45          0.847
LGA    V    22_C      I      46          0.715
LGA    I    23_C      V      47          0.248
LGA    L    24_C      L      48          0.846
LGA    N    25_C      S      49          1.043
LGA    R    26_C      N      50          0.901
LGA    P    27_C      P      51          0.859
LGA    E    28_C      K      52          0.566
LGA    K    29_C      K      53          0.846
LGA    R    30_C      R      54          0.972
LGA    N    31_C      N      55          0.599
LGA    A    32_C      T      56          0.696
LGA    M    33_C      L      57          0.206
LGA    S    34_C      S      58          0.408
LGA    P    35_C      L      59          0.311
LGA    T    36_C      A      60          0.600
LGA    L    37_C      M      61          1.029
LGA    N    38_C      L      62          1.167
LGA    R    39_C      K      63          1.367
LGA    E    40_C      S      64          1.519
LGA    M    41_C      L      65          1.601
LGA    I    42_C      Q      66          1.714
LGA    D    43_C      S      67          1.364
LGA    V    44_C      D      68          1.121
LGA    L    45_C      I      69          1.200
LGA    E    46_C      L      70          1.097
LGA    T    47_C      H      71          0.343
LGA    L    48_C      D      72          4.327
LGA    E    49_C      A      73          0.942
LGA    Q    50_C      D      74          3.632
LGA    D    51_C      S      75          4.136
LGA    P    52_C      N      76          3.579
LGA    A    53_C      D      77          3.119
LGA    A    54_C      L      78          2.572
LGA    G    55_C      K      79          1.248
LGA    V    56_C      V      80          0.936
LGA    L    57_C      I      81          0.451
LGA    V    58_C      I      82          0.408
LGA    L    59_C      I      83          0.541
LGA    T    60_C      S      84          0.493
LGA    G    61_C      A      85          0.585
LGA    A    62_C      E      86          1.038
LGA    G    63_C      G      87          1.292
LGA    E    64_C      P      88          1.362
LGA    A    65_C      V      89          1.793
LGA    W    66_C      F      90          1.440
LGA    T    67_C      S      91          1.120
LGA    A    68_C      S      92          1.282
LGA    G    69_C      G      93          1.159
LGA    M    70_C      H      94          1.242
LGA    D    71_C      D      95          1.666
LGA    L    72_C      L      96          1.561
LGA    K    73_C      K      97          1.693
LGA    E    74_C      E      98          3.845
LGA    Y    75_C      -       -           -
LGA    F    76_C      L      99          2.855
LGA    R    77_C      T     100          6.875
LGA    E    78_C      E     101           -
LGA    V    79_C      E     102           #
LGA    D    80_C      Q     103          1.154
LGA    A    81_C      -       -           -
LGA    G    82_C      -       -           -
LGA    P    83_C      G     104          4.855
LGA    E    84_C      R     105          3.408
LGA    I    85_C      D     106          3.285
LGA    L    86_C      Y     107          3.751
LGA    Q    87_C      H     108          3.448
LGA    E    88_C      A     109          3.326
LGA    K    89_C      E     110          3.206
LGA    I    90_C      V     111          3.102
LGA    R    91_C      F     112          2.408
LGA    R    92_C      Q     113          1.924
LGA    E    93_C      T     114          1.338
LGA    A    94_C      C     115          1.315
LGA    S    95_C      S     116          1.073
LGA    Q    96_C      K     117          1.106
LGA    W    97_C      V     118          1.143
LGA    Q    98_C      M     119          2.392
LGA    W    99_C      -       -           -
LGA    K   100_C      M     120          1.392
LGA    L   101_C      H     121          0.606
LGA    L   102_C      I     122          0.682
LGA    R   103_C      R     123          1.319
LGA    M   104_C      N     124          2.232
LGA    Y   105_C      H     125          1.280
LGA    A   106_C      P     126          0.639
LGA    K   107_C      V     127          0.511
LGA    P   108_C      P     128          1.142
LGA    T   109_C      V     129          1.127
LGA    I   110_C      I     130          0.625
LGA    A   111_C      A     131          0.482
LGA    M   112_C      M     132          0.296
LGA    V   113_C      V     133          0.648
LGA    N   114_C      N     134          1.427
LGA    G   115_C      G     135          1.395
LGA    W   116_C      L     136          1.366
LGA    C   117_C      A     137          0.376
LGA    F   118_C      T     138          0.354
LGA    G   119_C      A     139          0.547
LGA    G   120_C      A     140          1.102
LGA    G   121_C      G     141          1.609
LGA    F   122_C      C     142          2.487
LGA    A   123_C      Q     143          2.404
LGA    P   124_C      L     144          2.128
LGA    L   125_C      V     145          1.402
LGA    V   126_C      A     146          2.074
LGA    A   127_C      S     147          2.005
LGA    C   128_C      C     148          0.935
LGA    D   129_C      D     149          0.571
LGA    L   130_C      I     150          0.467
LGA    A   131_C      A     151          0.563
LGA    I   132_C      V     152          0.469
LGA    C   133_C      A     153          0.242
LGA    A   134_C      S     154          0.636
LGA    D   135_C      D     155          0.451
LGA    E   136_C      K     156          0.817
LGA    A   137_C      S     157          0.888
LGA    T   138_C      S     158          1.786
LGA    F   139_C      F     159          1.151
LGA    G   140_C      A     160          0.861
LGA    L   141_C      T     161          1.177
LGA    S   142_C      P     162          0.819
LGA    E   143_C      G     163          1.300
LGA    I   144_C      V     164          1.973
LGA    N   145_C      N     165          1.742
LGA    W   146_C      V     166          1.919
LGA    G   147_C      G     167          1.813
LGA    I   148_C      L     168          2.264
LGA    P   149_C      F     169          1.941
LGA    P   150_C      C     170          1.439
LGA    G   151_C      S     171          3.057
LGA    N   152_C      T     172          2.193
LGA    L   153_C      -       -           -
LGA    V   154_C      P     173          1.531
LGA    S   155_C      G     174          1.276
LGA    K   156_C      V     175          2.185
LGA    A   157_C      A     176          1.185
LGA    M   158_C      L     177          1.528
LGA    A   159_C      A     178          1.698
LGA    D   160_C      R     179          1.441
LGA    T   161_C      A     180          1.640
LGA    V   162_C      V     181          0.735
LGA    G   163_C      P     182          1.417
LGA    H   164_C      R     183          1.928
LGA    R   165_C      K     184          1.454
LGA    Q   166_C      V     185          1.420
LGA    S   167_C      A     186          1.518
LGA    L   168_C      L     187          1.489
LGA    Y   169_C      E     188          1.537
LGA    Y   170_C      M     189          1.419
LGA    I   171_C      L     190          1.494
LGA    M   172_C      F     191          1.731
LGA    T   173_C      T     192          1.549
LGA    G   174_C      G     193          1.144
LGA    K   175_C      E     194          1.025
LGA    T   176_C      P     195          1.028
LGA    F   177_C      I     196          1.940
LGA    G   178_C      S     197          1.741
LGA    G   179_C      A     198          1.377
LGA    Q   180_C      Q     199          1.537
LGA    K   181_C      E     200          1.689
LGA    A   182_C      A     201          1.412
LGA    A   183_C      L     202          0.844
LGA    E   184_C      L     203          1.506
LGA    M   185_C      H     204          1.500
LGA    G   186_C      G     205          1.155
LGA    L   187_C      L     206          0.439
LGA    V   188_C      L     207          0.240
LGA    N   189_C      S     208          0.663
LGA    E   190_C      K     209          1.132
LGA    S   191_C      V     210          0.792
LGA    V   192_C      V     211          0.657
LGA    P   193_C      P     212          0.881
LGA    L   194_C      E     213          0.872
LGA    A   195_C      A     214          1.295
LGA    Q   196_C      E     215          1.092
LGA    L   197_C      L     216          0.546
LGA    R   198_C      Q     217          0.377
LGA    E   199_C      E     218          0.579
LGA    V   200_C      E     219          0.564
LGA    T   201_C      T     220          0.381
LGA    I   202_C      M     221          0.268
LGA    E   203_C      R     222          0.774
LGA    L   204_C      I     223          1.035
LGA    A   205_C      A     224          0.793
LGA    R   206_C      R     225          0.979
LGA    N   207_C      K     226          1.043
LGA    L   208_C      I     227          0.994
LGA    L   209_C      A     228          1.131
LGA    E   210_C      S     229          1.719
LGA    K   211_C      L     230          1.640
LGA    N   212_C      S     231          1.203
LGA    P   213_C      R     232          1.207
LGA    V   214_C      P     233          1.779
LGA    V   215_C      V     234          1.336
LGA    L   216_C      V     235          1.161
LGA    R   217_C      S     236          1.770
LGA    A   218_C      L     237          2.061
LGA    A   219_C      G     238          1.826
LGA    K   220_C      K     239          2.476
LGA    H   221_C      A     240          2.784
LGA    G   222_C      T     241          2.382
LGA    F   223_C      F     242          2.429
LGA    K   224_C      Y     243          2.738
LGA    R   225_C      K     244          3.001
LGA    C   226_C      Q     245          2.241
LGA    R   227_C      L     246          2.544
LGA    E   228_C      P     247          0.839
LGA    L   229_C      Q     248          0.563
LGA    T   230_C      D     249          0.334
LGA    W   231_C      L     250          0.898
LGA    E   232_C      G     251          1.329
LGA    Q   233_C      T     252          1.372
LGA    N   234_C      A     253          1.085
LGA    E   235_C      Y     254          2.378
LGA    D   236_C      Y     255          2.432
LGA    Y   237_C      L     256          1.992
LGA    L   238_C      T     257          1.575
LGA    Y   239_C      S     258          2.722
LGA    A   240_C      Q     259          3.607
LGA    K   241_C      A     260          3.068
LGA    L   242_C      M     261          3.117
LGA    D   243_C      V     262          4.313
LGA    Q   244_C      D     263          4.644
LGA    S   245_C      N     264          4.197
LGA    R   246_C      L     265          5.059
LGA    L   247_C      A     266           #
LGA    L   248_C      L     267           #
LGA    D   249_C      -       -           -
LGA    T   250_C      -       -           -
LGA    G   251_C      R     268          4.740
LGA    G   252_C      D     269          2.211
LGA    R   253_C      G     270          0.870
LGA    E   254_C      Q     271          2.232
LGA    -       -      E     272           -
LGA    -       -      G     273           -
LGA    Q   255_C      I     274          0.634
LGA    G   256_C      T     275          4.074
LGA    -       -      A     276           -
LGA    -       -      F     277           -
LGA    -       -      L     278           -
LGA    -       -      Q     279           -
LGA    -       -      K     280           -
LGA    -       -      R     281           -
LGA    -       -      K     282           -
LGA    -       -      P     283           -
LGA    -       -      V     284           -
LGA    -       -      W     285           -
LGA    -       -      S     286           -
LGA    -       -      H     287           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  251  256    5.0    237    1.87    22.78     83.585    12.035

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.369318 * X  +  -0.925672 * Y  +  -0.082074 * Z  + -25.979656
  Y_new =   0.810265 * X  +   0.364000 * Y  +  -0.459320 * Z  +  71.227081
  Z_new =   0.455054 * X  +   0.103133 * Y  +   0.884471 * Z  +  62.955807 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.116080   -3.025512  [ DEG:     6.6509   -173.3491 ]
  Theta =  -0.472433   -2.669160  [ DEG:   -27.0684   -152.9316 ]
  Phi   =   1.143130   -1.998462  [ DEG:    65.4965   -114.5035 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2vsu_C                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2vsu_C.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  251  256   5.0  237   1.87   22.78  83.585
REMARK  ---------------------------------------------------------- 
MOLECULE 2vsu_C
HEADER    LYASE                                   29-APR-08   2VSU              
TITLE     A TERNARY COMPLEX OF HYDROXYCINNAMOYL-COA HYDRATASE-LYASE (           
TITLE    2 HCHL) WITH ACETYL-COENZYME A AND VANILLIN GIVES INSIGHTS             
TITLE    3 INTO SUBSTRATE SPECIFICITY AND MECHANISM.                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND   3 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE S123A MUTANT;          
COMPND   4 CHAIN: A, B, D;                                                      
COMPND   5 EC: 4.2.1.101;                                                       
COMPND   6 MUTATION: YES;                                                       
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND  10 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE S123A MUTANT;          
COMPND  11 CHAIN: E;                                                            
COMPND  12 EC: 4.2.1.101;                                                       
COMPND  13 MUTATION: YES;                                                       
COMPND  14 ENGINEERED: YES;                                                     
COMPND  15 MOL_ID: 3;                                                           
COMPND  16 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND  17 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE S123A MUTANT;          
COMPND  18 CHAIN: C;                                                            
COMPND  19 FRAGMENT: RESIDUES 1-250, 252-276;                                   
COMPND  20 EC: 4.2.1.101;                                                       
COMPND  21 MUTATION: YES;                                                       
COMPND  22 ENGINEERED: YES;                                                     
COMPND  23 MOL_ID: 4;                                                           
COMPND  24 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND  25 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE S123A MUTANT;          
COMPND  26 CHAIN: F;                                                            
COMPND  27 EC: 4.2.1.101;                                                       
COMPND  28 MUTATION: YES;                                                       
COMPND  29 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   4 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE   5 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE   6 STRAIN: AN103;                                                       
SOURCE   7 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH UK;               
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  12 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  13 STRAIN: AN103;                                                       
SOURCE  14 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH UK;               
SOURCE  15 MOL_ID: 3;                                                           
SOURCE  16 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  17 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  19 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  20 STRAIN: AN103;                                                       
SOURCE  21 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH UK;               
SOURCE  22 MOL_ID: 4;                                                           
SOURCE  23 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  24 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE  25 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  26 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  27 STRAIN: AN103;                                                       
SOURCE  28 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH UK                
KEYWDS    LYASE, ALDOLASE, CROTONASE, HYDRATASE                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.P.BENNETT,L.M.BERTIN,A.M.BRZOZOWSKI,N.J.WALTON,G.GROGAN             
REVDAT   1   27-MAY-08 2VSU    0                                                
JRNL        AUTH   J.P.BENNETT,L.M.BERTIN,B.MOULTON,I.J.S.FAIRLAMB,             
JRNL        AUTH 2 A.M.BRZOZOWSKI,N.J.WALTON,G.GROGAN                           
JRNL        TITL   A TERNARY COMPLEX OF HYDROXYCINNAMOYL-COA                    
JRNL        TITL 2 HYDRATASE-LYASE (HCHL) WITH ACETYL-COENZYME A AND            
JRNL        TITL 3 VANILLIN GIVES INSIGHTS INTO SUBSTRATE SPECIFICITY           
JRNL        TITL 4 AND MECHANISM.                                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.9  ANGSTROMS.                                          
DBREF  2VSU A    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSU B    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSU C    1   250  UNP    O69762   O69762_PSEFL     1    250             
DBREF  2VSU C  251   275  UNP    O69762   O69762_PSEFL   252    276             
DBREF  2VSU D    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSU E    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSU F    1   276  UNP    O69762   O69762_PSEFL     1    276             
SEQRES   1 A  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 A  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 A  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 A  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 A  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 A  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 A  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 A  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 A  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 A  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 A  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 A  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 A  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 A  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 A  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 A  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 A  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 A  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 A  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 A  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 A  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 A  276  TYR LYS ARG                                                  
SEQRES   1 B  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 B  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 B  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 B  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 B  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 B  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 B  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 B  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 B  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 B  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 B  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 B  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 B  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 B  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 B  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 B  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 B  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 B  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 B  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 B  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 B  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 B  276  TYR LYS ARG                                                  
SEQRES   1 C  275  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 C  275  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 C  275  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 C  275  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 C  275  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 C  275  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 C  275  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 C  275  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 C  275  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 C  275  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 C  275  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 C  275  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 C  275  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 C  275  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 C  275  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 C  275  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 C  275  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 C  275  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 C  275  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 C  275  LEU ASP THR GLY GLY ARG GLU GLN GLY MET LYS GLN PHE          
SEQRES  21 C  275  LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA TYR          
SEQRES  22 C  275  LYS ARG                                                      
SEQRES   1 D  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 D  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 D  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 D  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 D  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 D  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 D  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 D  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 D  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 D  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 D  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 D  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 D  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 D  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 D  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 D  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 D  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 D  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 D  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 D  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 D  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 D  276  TYR LYS ARG                                                  
SEQRES   1 E  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 E  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 E  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 E  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 E  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 E  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 E  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 E  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 E  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 E  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 E  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 E  276  ILE ASN TYR GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 E  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 E  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 E  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 E  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 E  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 E  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 E  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 E  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 E  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 E  276  TYR LYS ARG                                                  
SEQRES   1 F  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 F  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 F  276  PRO GLU ARG ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 F  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 F  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 F  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 F  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 F  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 F  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 F  276  PHE GLY GLY GLY PHE ALA PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 F  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 F  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 F  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 F  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 F  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 F  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 F  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 F  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 F  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 F  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 F  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 F  276  TYR LYS ARG                                                  
HET    ACO  A1250      51                                                       
HET    ACO  B1251      51                                                       
HET    ACO  D1250      51                                                       
HET    ACO  E1250      51                                                       
HET    ACO  F1249      51                                                       
HET    V55  D1251      11                                                       
HETNAM     ACO ACETYL COENZYME *A                                               
HETNAM     V55 4-HYDROXY-3-METHOXYBENZALDEHYDE                                  
FORMUL   7  ACO    5(C23 H38 N7 O17 P3 S1)                                      
FORMUL   8  V55    C8 H8 O3                                                     
FORMUL   9  HOH   *488(H2 O1)                                                   
CRYST1   90.081  130.122  144.743  90.00  90.00  90.00 P 21 21 21   12          
ATOM   3823  N   GLY C   6     -36.349 111.244  19.226  1.00 32.75           N  
ATOM   3824  CA  GLY C   6     -36.061 112.572  19.831  1.00 33.79           C  
ATOM   3825  C   GLY C   6     -35.876 112.582  21.341  1.00 33.92           C  
ATOM   3826  O   GLY C   6     -36.181 113.582  21.998  1.00 33.90           O  
ATOM   3827  N   ARG C   7     -35.347 111.491  21.910  1.00 34.13           N  
ATOM   3828  CA  ARG C   7     -35.084 111.424  23.352  1.00 33.38           C  
ATOM   3829  C   ARG C   7     -33.885 112.279  23.816  1.00 32.77           C  
ATOM   3830  O   ARG C   7     -33.905 112.849  24.925  1.00 32.27           O  
ATOM   3831  CB  ARG C   7     -34.900 109.961  23.819  1.00 33.88           C  
ATOM   3832  CG  ARG C   7     -34.495 109.847  25.284  1.00 34.72           C  
ATOM   3833  CD  ARG C   7     -34.731 108.478  25.872  1.00 37.47           C  
ATOM   3834  NE  ARG C   7     -34.450 108.469  27.305  1.00 37.92           N  
ATOM   3835  CZ  ARG C   7     -34.639 107.424  28.105  1.00 38.92           C  
ATOM   3836  NH1 ARG C   7     -35.121 106.290  27.609  1.00 40.16           N  
ATOM   3837  NH2 ARG C   7     -34.346 107.509  29.397  1.00 37.49           N  
ATOM   3838  N   TRP C   8     -32.830 112.338  23.012  1.00 31.64           N  
ATOM   3839  CA  TRP C   8     -31.616 113.073  23.419  1.00 31.26           C  
ATOM   3840  C   TRP C   8     -31.308 114.168  22.446  1.00 30.88           C  
ATOM   3841  O   TRP C   8     -31.507 114.000  21.246  1.00 31.05           O  
ATOM   3842  CB  TRP C   8     -30.367 112.158  23.549  1.00 30.37           C  
ATOM   3843  CG  TRP C   8     -30.519 111.184  24.626  1.00 29.54           C  
ATOM   3844  CD1 TRP C   8     -30.399 111.421  25.969  1.00 29.81           C  
ATOM   3845  CD2 TRP C   8     -30.860 109.798  24.492  1.00 28.76           C  
ATOM   3846  NE1 TRP C   8     -30.655 110.274  26.675  1.00 29.73           N  
ATOM   3847  CE2 TRP C   8     -30.920 109.255  25.797  1.00 29.74           C  
ATOM   3848  CE3 TRP C   8     -31.121 108.967  23.404  1.00 29.12           C  
ATOM   3849  CZ2 TRP C   8     -31.240 107.910  26.039  1.00 30.20           C  
ATOM   3850  CZ3 TRP C   8     -31.429 107.634  23.643  1.00 29.77           C  
ATOM   3851  CH2 TRP C   8     -31.498 107.122  24.950  1.00 28.70           C  
ATOM   3852  N   LYS C   9     -30.745 115.240  22.984  1.00 31.01           N  
ATOM   3853  CA  LYS C   9     -30.405 116.454  22.248  1.00 31.34           C  
ATOM   3854  C   LYS C   9     -29.234 116.213  21.320  1.00 30.38           C  
ATOM   3855  O   LYS C   9     -29.272 116.591  20.152  1.00 29.91           O  
ATOM   3856  CB  LYS C   9     -30.058 117.552  23.278  1.00 32.71           C  
ATOM   3857  CG  LYS C   9     -29.362 118.818  22.750  1.00 35.17           C  
ATOM   3858  CD  LYS C   9     -30.345 119.853  22.281  1.00 39.41           C  
ATOM   3859  CE  LYS C   9     -29.741 120.654  21.153  1.00 41.22           C  
ATOM   3860  NZ  LYS C   9     -30.823 121.303  20.373  1.00 42.14           N  
ATOM   3861  N   THR C  10     -28.210 115.545  21.848  1.00 29.38           N  
ATOM   3862  CA  THR C  10     -26.890 115.440  21.210  1.00 28.53           C  
ATOM   3863  C   THR C  10     -26.545 114.028  20.724  1.00 28.07           C  
ATOM   3864  O   THR C  10     -25.406 113.783  20.298  1.00 27.68           O  
ATOM   3865  CB  THR C  10     -25.785 115.843  22.207  1.00 29.22           C  
ATOM   3866  OG1 THR C  10     -25.654 114.807  23.193  1.00 27.14           O  
ATOM   3867  CG2 THR C  10     -26.112 117.158  22.923  1.00 28.32           C  
ATOM   3868  N   VAL C  11     -27.496 113.091  20.817  1.00 28.09           N  
ATOM   3869  CA  VAL C  11     -27.254 111.663  20.420  1.00 28.47           C  
ATOM   3870  C   VAL C  11     -28.542 111.038  19.880  1.00 28.97           C  
ATOM   3871  O   VAL C  11     -29.611 111.268  20.452  1.00 28.84           O  
ATOM   3872  CB  VAL C  11     -26.780 110.714  21.619  1.00 28.82           C  
ATOM   3873  CG1 VAL C  11     -26.451 109.327  21.114  1.00 26.10           C  
ATOM   3874  CG2 VAL C  11     -25.589 111.282  22.450  1.00 29.12           C  
ATOM   3875  N   LYS C  12     -28.432 110.265  18.792  1.00 30.08           N  
ATOM   3876  CA  LYS C  12     -29.544 109.477  18.215  1.00 30.84           C  
ATOM   3877  C   LYS C  12     -29.305 107.978  18.364  1.00 30.53           C  
ATOM   3878  O   LYS C  12     -28.190 107.508  18.163  1.00 31.10           O  
ATOM   3879  CB  LYS C  12     -29.680 109.743  16.715  1.00 30.64           C  
ATOM   3880  CG  LYS C  12     -30.388 110.995  16.351  1.00 33.88           C  
ATOM   3881  CD  LYS C  12     -30.979 110.806  14.966  1.00 34.54           C  
ATOM   3882  CE  LYS C  12     -30.583 111.943  14.071  1.00 36.81           C  
ATOM   3883  NZ  LYS C  12     -31.265 111.814  12.751  1.00 36.76           N  
ATOM   3884  N   VAL C  13     -30.349 107.216  18.678  1.00 30.54           N  
ATOM   3885  CA  VAL C  13     -30.210 105.744  18.745  1.00 31.13           C  
ATOM   3886  C   VAL C  13     -31.224 105.108  17.799  1.00 31.99           C  
ATOM   3887  O   VAL C  13     -32.403 105.506  17.785  1.00 30.79           O  
ATOM   3888  CB  VAL C  13     -30.440 105.171  20.181  1.00 31.13           C  
ATOM   3889  CG1 VAL C  13     -30.356 103.657  20.178  1.00 29.84           C  
ATOM   3890  CG2 VAL C  13     -29.513 105.805  21.230  1.00 31.55           C  
ATOM   3891  N   GLU C  14     -30.758 104.160  16.986  1.00 32.38           N  
ATOM   3892  CA  GLU C  14     -31.615 103.390  16.080  1.00 33.65           C  
ATOM   3893  C   GLU C  14     -31.350 101.903  16.275  1.00 32.42           C  
ATOM   3894  O   GLU C  14     -30.210 101.475  16.215  1.00 32.97           O  
ATOM   3895  CB  GLU C  14     -31.392 103.793  14.605  1.00 33.57           C  
ATOM   3896  CG  GLU C  14     -30.977 105.275  14.412  1.00 36.29           C  
ATOM   3897  CD  GLU C  14     -31.211 105.817  13.007  1.00 37.43           C  
ATOM   3898  OE1 GLU C  14     -30.836 105.155  12.003  1.00 40.77           O  
ATOM   3899  OE2 GLU C  14     -31.779 106.929  12.907  1.00 42.15           O  
ATOM   3900  N   ILE C  15     -32.401 101.125  16.533  1.00 32.01           N  
ATOM   3901  CA  ILE C  15     -32.271  99.673  16.697  1.00 31.84           C  
ATOM   3902  C   ILE C  15     -32.938  98.928  15.555  1.00 31.43           C  
ATOM   3903  O   ILE C  15     -34.163  99.056  15.343  1.00 30.87           O  
ATOM   3904  CB  ILE C  15     -32.855  99.145  18.030  1.00 32.28           C  
ATOM   3905  CG1 ILE C  15     -32.135  99.798  19.228  1.00 32.55           C  
ATOM   3906  CG2 ILE C  15     -32.777  97.593  18.036  1.00 31.88           C  
ATOM   3907  CD1 ILE C  15     -32.832  99.720  20.578  1.00 32.01           C  
ATOM   3908  N   GLU C  16     -32.113  98.176  14.823  1.00 31.13           N  
ATOM   3909  CA  GLU C  16     -32.545  97.349  13.695  1.00 30.27           C  
ATOM   3910  C   GLU C  16     -31.995  95.938  13.855  1.00 29.57           C  
ATOM   3911  O   GLU C  16     -30.779  95.757  14.001  1.00 29.80           O  
ATOM   3912  CB  GLU C  16     -32.063  97.950  12.375  1.00 30.49           C  
ATOM   3913  N   ASP C  17     -32.901  94.953  13.837  1.00 29.12           N  
ATOM   3914  CA  ASP C  17     -32.573  93.519  14.024  1.00 28.82           C  
ATOM   3915  C   ASP C  17     -31.575  93.253  15.202  1.00 28.16           C  
ATOM   3916  O   ASP C  17     -30.646  92.434  15.116  1.00 27.42           O  
ATOM   3917  CB  ASP C  17     -32.095  92.891  12.709  1.00 29.01           C  
ATOM   3918  CG  ASP C  17     -33.132  93.003  11.601  1.00 30.62           C  
ATOM   3919  OD1 ASP C  17     -34.326  92.757  11.869  1.00 30.28           O  
ATOM   3920  OD2 ASP C  17     -32.768  93.327  10.448  1.00 35.80           O  
ATOM   3921  N   GLY C  18     -31.767  93.972  16.295  1.00 28.09           N  
ATOM   3922  CA  GLY C  18     -30.995  93.713  17.498  1.00 28.22           C  
ATOM   3923  C   GLY C  18     -29.717  94.537  17.626  1.00 28.55           C  
ATOM   3924  O   GLY C  18     -29.026  94.471  18.664  1.00 28.06           O  
ATOM   3925  N   ILE C  19     -29.408  95.302  16.574  1.00 28.59           N  
ATOM   3926  CA  ILE C  19     -28.260  96.215  16.554  1.00 28.65           C  
ATOM   3927  C   ILE C  19     -28.674  97.642  16.886  1.00 29.26           C  
ATOM   3928  O   ILE C  19     -29.480  98.272  16.159  1.00 28.92           O  
ATOM   3929  CB  ILE C  19     -27.574  96.236  15.183  1.00 28.05           C  
ATOM   3930  CG1 ILE C  19     -27.104  94.836  14.792  1.00 29.10           C  
ATOM   3931  CG2 ILE C  19     -26.435  97.247  15.164  1.00 27.59           C  
ATOM   3932  CD1 ILE C  19     -26.891  94.650  13.289  1.00 27.02           C  
ATOM   3933  N   ALA C  20     -28.126  98.157  17.984  1.00 29.39           N  
ATOM   3934  CA  ALA C  20     -28.347  99.555  18.390  1.00 30.22           C  
ATOM   3935  C   ALA C  20     -27.221 100.475  17.903  1.00 30.20           C  
ATOM   3936  O   ALA C  20     -26.137 100.486  18.477  1.00 30.06           O  
ATOM   3937  CB  ALA C  20     -28.511  99.656  19.901  1.00 29.61           C  
ATOM   3938  N   PHE C  21     -27.504 101.237  16.853  1.00 30.70           N  
ATOM   3939  CA  PHE C  21     -26.627 102.300  16.363  1.00 30.93           C  
ATOM   3940  C   PHE C  21     -26.756 103.501  17.270  1.00 31.11           C  
ATOM   3941  O   PHE C  21     -27.832 104.138  17.335  1.00 31.62           O  
ATOM   3942  CB  PHE C  21     -26.996 102.680  14.909  1.00 31.91           C  
ATOM   3943  CG  PHE C  21     -26.597 101.648  13.905  1.00 33.50           C  
ATOM   3944  CD1 PHE C  21     -27.443 100.573  13.617  1.00 34.51           C  
ATOM   3945  CD2 PHE C  21     -25.363 101.731  13.254  1.00 34.52           C  
ATOM   3946  CE1 PHE C  21     -27.059  99.601  12.690  1.00 35.22           C  
ATOM   3947  CE2 PHE C  21     -24.973 100.770  12.326  1.00 34.14           C  
ATOM   3948  CZ  PHE C  21     -25.812  99.700  12.046  1.00 33.34           C  
ATOM   3949  N   VAL C  22     -25.680 103.780  18.008  1.00 30.55           N  
ATOM   3950  CA  VAL C  22     -25.592 104.942  18.877  1.00 29.70           C  
ATOM   3951  C   VAL C  22     -24.825 106.008  18.093  1.00 29.05           C  
ATOM   3952  O   VAL C  22     -23.614 105.874  17.850  1.00 28.16           O  
ATOM   3953  CB  VAL C  22     -24.879 104.629  20.214  1.00 29.60           C  
ATOM   3954  CG1 VAL C  22     -24.724 105.883  21.043  1.00 30.57           C  
ATOM   3955  CG2 VAL C  22     -25.627 103.562  20.980  1.00 29.11           C  
ATOM   3956  N   ILE C  23     -25.551 107.053  17.699  1.00 27.91           N  
ATOM   3957  CA  ILE C  23     -25.036 108.027  16.768  1.00 27.88           C  
ATOM   3958  C   ILE C  23     -24.849 109.335  17.455  1.00 27.91           C  
ATOM   3959  O   ILE C  23     -25.852 110.051  17.738  1.00 27.80           O  
ATOM   3960  CB  ILE C  23     -26.011 108.251  15.583  1.00 28.85           C  
ATOM   3961  CG1 ILE C  23     -26.406 106.907  14.939  1.00 28.98           C  
ATOM   3962  CG2 ILE C  23     -25.428 109.265  14.547  1.00 27.85           C  
ATOM   3963  CD1 ILE C  23     -27.778 106.945  14.297  1.00 29.52           C  
ATOM   3964  N   LEU C  24     -23.582 109.657  17.698  1.00 28.07           N  
ATOM   3965  CA  LEU C  24     -23.196 110.956  18.229  1.00 28.74           C  
ATOM   3966  C   LEU C  24     -23.718 111.944  17.245  1.00 29.18           C  
ATOM   3967  O   LEU C  24     -23.481 111.811  16.053  1.00 29.38           O  
ATOM   3968  CB  LEU C  24     -21.688 111.128  18.319  1.00 28.59           C  
ATOM   3969  CG  LEU C  24     -20.873 110.237  19.255  1.00 27.63           C  
ATOM   3970  CD1 LEU C  24     -19.390 110.564  19.110  1.00 25.89           C  
ATOM   3971  CD2 LEU C  24     -21.322 110.364  20.720  1.00 28.77           C  
ATOM   3972  N   ASN C  25     -24.440 112.929  17.756  1.00 30.62           N  
ATOM   3973  CA  ASN C  25     -25.277 113.764  16.913  1.00 31.34           C  
ATOM   3974  C   ASN C  25     -25.116 115.252  17.197  1.00 31.57           C  
ATOM   3975  O   ASN C  25     -26.078 115.933  17.526  1.00 31.74           O  
ATOM   3976  CB  ASN C  25     -26.734 113.300  17.044  1.00 31.35           C  
ATOM   3977  CG  ASN C  25     -27.646 113.907  15.987  1.00 32.58           C  
ATOM   3978  OD1 ASN C  25     -28.821 114.170  16.256  1.00 33.11           O  
ATOM   3979  ND2 ASN C  25     -27.112 114.137  14.791  1.00 30.84           N  
ATOM   3980  N   ARG C  26     -23.888 115.750  17.052  1.00 32.25           N  
ATOM   3981  CA  ARG C  26     -23.613 117.202  16.997  1.00 32.86           C  
ATOM   3982  C   ARG C  26     -22.827 117.541  15.707  1.00 32.96           C  
ATOM   3983  O   ARG C  26     -21.753 118.161  15.783  1.00 33.00           O  
ATOM   3984  CB  ARG C  26     -22.831 117.679  18.231  1.00 32.80           C  
ATOM   3985  CG  ARG C  26     -23.580 117.532  19.564  1.00 33.19           C  
ATOM   3986  CD  ARG C  26     -22.772 118.051  20.744  1.00 33.52           C  
ATOM   3987  NE  ARG C  26     -22.739 119.514  20.814  1.00 33.47           N  
ATOM   3988  CZ  ARG C  26     -21.642 120.253  20.974  1.00 32.75           C  
ATOM   3989  NH1 ARG C  26     -20.449 119.695  21.069  1.00 29.17           N  
ATOM   3990  NH2 ARG C  26     -21.746 121.569  21.047  1.00 32.73           N  
ATOM   3991  N   PRO C  27     -23.368 117.153  14.521  1.00 32.79           N  
ATOM   3992  CA  PRO C  27     -22.568 117.254  13.305  1.00 33.05           C  
ATOM   3993  C   PRO C  27     -21.979 118.635  13.056  1.00 33.34           C  
ATOM   3994  O   PRO C  27     -20.836 118.723  12.617  1.00 33.24           O  
ATOM   3995  CB  PRO C  27     -23.547 116.851  12.192  1.00 33.29           C  
ATOM   3996  CG  PRO C  27     -24.912 117.008  12.790  1.00 33.60           C  
ATOM   3997  CD  PRO C  27     -24.714 116.622  14.229  1.00 32.38           C  
ATOM   3998  N   GLU C  28     -22.742 119.692  13.362  1.00 34.03           N  
ATOM   3999  CA  GLU C  28     -22.318 121.100  13.158  1.00 34.52           C  
ATOM   4000  C   GLU C  28     -21.026 121.409  13.914  1.00 34.15           C  
ATOM   4001  O   GLU C  28     -20.315 122.356  13.582  1.00 34.02           O  
ATOM   4002  CB  GLU C  28     -23.415 122.117  13.557  1.00 34.67           C  
ATOM   4003  CG  GLU C  28     -24.860 121.565  13.651  1.00 36.17           C  
ATOM   4004  CD  GLU C  28     -25.045 120.569  14.823  1.00 38.48           C  
ATOM   4005  OE1 GLU C  28     -24.427 120.763  15.895  1.00 34.88           O  
ATOM   4006  OE2 GLU C  28     -25.808 119.586  14.661  1.00 40.99           O  
ATOM   4007  N   LYS C  29     -20.720 120.577  14.906  1.00 34.33           N  
ATOM   4008  CA  LYS C  29     -19.531 120.742  15.728  1.00 33.96           C  
ATOM   4009  C   LYS C  29     -18.564 119.563  15.543  1.00 33.83           C  
ATOM   4010  O   LYS C  29     -17.643 119.355  16.357  1.00 34.18           O  
ATOM   4011  CB  LYS C  29     -19.932 120.883  17.207  1.00 33.67           C  
ATOM   4012  N   ARG C  30     -18.782 118.788  14.481  1.00 33.13           N  
ATOM   4013  CA  ARG C  30     -18.020 117.550  14.235  1.00 32.63           C  
ATOM   4014  C   ARG C  30     -18.131 116.568  15.429  1.00 31.25           C  
ATOM   4015  O   ARG C  30     -17.160 115.901  15.780  1.00 31.41           O  
ATOM   4016  CB  ARG C  30     -16.545 117.852  13.901  1.00 32.44           C  
ATOM   4017  CG  ARG C  30     -16.319 118.693  12.628  1.00 33.79           C  
ATOM   4018  CD  ARG C  30     -14.889 118.472  12.025  1.00 35.30           C  
ATOM   4019  NE  ARG C  30     -14.698 119.267  10.799  1.00 39.99           N  
ATOM   4020  CZ  ARG C  30     -13.550 119.466  10.131  1.00 40.08           C  
ATOM   4021  NH1 ARG C  30     -13.555 120.254   9.019  1.00 38.10           N  
ATOM   4022  NH2 ARG C  30     -12.414 118.924  10.564  1.00 40.32           N  
ATOM   4023  N   ASN C  31     -19.320 116.495  16.036  1.00 29.63           N  
ATOM   4024  CA  ASN C  31     -19.611 115.584  17.162  1.00 28.63           C  
ATOM   4025  C   ASN C  31     -18.670 115.746  18.362  1.00 28.36           C  
ATOM   4026  O   ASN C  31     -18.411 114.789  19.097  1.00 27.82           O  
ATOM   4027  CB  ASN C  31     -19.736 114.094  16.692  1.00 27.40           C  
ATOM   4028  CG  ASN C  31     -20.801 113.908  15.574  1.00 27.77           C  
ATOM   4029  OD1 ASN C  31     -21.924 114.437  15.659  1.00 27.95           O  
ATOM   4030  ND2 ASN C  31     -20.434 113.190  14.514  1.00 25.46           N  
ATOM   4031  N   ALA C  32     -18.173 116.961  18.588  1.00 28.25           N  
ATOM   4032  CA  ALA C  32     -17.314 117.198  19.751  1.00 28.48           C  
ATOM   4033  C   ALA C  32     -18.030 116.854  21.053  1.00 28.71           C  
ATOM   4034  O   ALA C  32     -19.258 117.018  21.155  1.00 29.26           O  
ATOM   4035  CB  ALA C  32     -16.806 118.620  19.786  1.00 27.96           C  
ATOM   4036  N   MET C  33     -17.263 116.401  22.051  1.00 27.80           N  
ATOM   4037  CA  MET C  33     -17.848 115.955  23.305  1.00 28.41           C  
ATOM   4038  C   MET C  33     -17.970 117.069  24.335  1.00 28.11           C  
ATOM   4039  O   MET C  33     -16.987 117.458  24.999  1.00 28.06           O  
ATOM   4040  CB  MET C  33     -17.099 114.726  23.856  1.00 27.17           C  
ATOM   4041  CG  MET C  33     -17.221 113.526  22.926  1.00 26.62           C  
ATOM   4042  SD  MET C  33     -16.128 112.151  23.351  1.00 31.26           S  
ATOM   4043  CE  MET C  33     -14.565 112.852  22.668  1.00 22.40           C  
ATOM   4044  N   SER C  34     -19.197 117.567  24.458  1.00 26.74           N  
ATOM   4045  CA  SER C  34     -19.520 118.526  25.479  1.00 27.04           C  
ATOM   4046  C   SER C  34     -19.994 117.853  26.773  1.00 27.26           C  
ATOM   4047  O   SER C  34     -20.285 116.643  26.809  1.00 27.53           O  
ATOM   4048  CB  SER C  34     -20.594 119.490  24.949  1.00 26.32           C  
ATOM   4049  OG  SER C  34     -21.743 118.757  24.569  1.00 24.08           O  
ATOM   4050  N   PRO C  35     -20.031 118.622  27.871  1.00 27.77           N  
ATOM   4051  CA  PRO C  35     -20.641 118.067  29.080  1.00 27.71           C  
ATOM   4052  C   PRO C  35     -22.084 117.542  28.885  1.00 28.15           C  
ATOM   4053  O   PRO C  35     -22.416 116.459  29.390  1.00 28.61           O  
ATOM   4054  CB  PRO C  35     -20.548 119.235  30.074  1.00 28.64           C  
ATOM   4055  CG  PRO C  35     -19.306 119.987  29.628  1.00 27.33           C  
ATOM   4056  CD  PRO C  35     -19.410 119.940  28.113  1.00 27.62           C  
ATOM   4057  N   THR C  36     -22.915 118.279  28.139  1.00 28.72           N  
ATOM   4058  CA  THR C  36     -24.234 117.778  27.729  1.00 28.39           C  
ATOM   4059  C   THR C  36     -24.137 116.417  27.046  1.00 27.73           C  
ATOM   4060  O   THR C  36     -24.822 115.447  27.435  1.00 27.13           O  
ATOM   4061  CB  THR C  36     -24.959 118.767  26.811  1.00 28.85           C  
ATOM   4062  OG1 THR C  36     -25.163 119.980  27.527  1.00 27.31           O  
ATOM   4063  CG2 THR C  36     -26.329 118.233  26.359  1.00 30.75           C  
ATOM   4064  N   LEU C  37     -23.295 116.335  26.028  1.00 27.01           N  
ATOM   4065  CA  LEU C  37     -23.123 115.050  25.341  1.00 26.87           C  
ATOM   4066  C   LEU C  37     -22.698 113.942  26.308  1.00 26.49           C  
ATOM   4067  O   LEU C  37     -23.261 112.829  26.266  1.00 26.04           O  
ATOM   4068  CB  LEU C  37     -22.191 115.171  24.120  1.00 26.12           C  
ATOM   4069  CG  LEU C  37     -22.048 113.884  23.308  1.00 25.66           C  
ATOM   4070  CD1 LEU C  37     -21.874 114.208  21.824  1.00 25.83           C  
ATOM   4071  CD2 LEU C  37     -20.876 113.069  23.855  1.00 24.34           C  
ATOM   4072  N   ASN C  38     -21.751 114.262  27.194  1.00 26.93           N  
ATOM   4073  CA  ASN C  38     -21.255 113.311  28.181  1.00 27.18           C  
ATOM   4074  C   ASN C  38     -22.352 112.763  29.064  1.00 28.32           C  
ATOM   4075  O   ASN C  38     -22.483 111.524  29.224  1.00 28.45           O  
ATOM   4076  CB  ASN C  38     -20.148 113.924  29.043  1.00 27.52           C  
ATOM   4077  CG  ASN C  38     -18.887 114.222  28.251  1.00 27.77           C  
ATOM   4078  OD1 ASN C  38     -18.620 113.601  27.222  1.00 26.88           O  
ATOM   4079  ND2 ASN C  38     -18.110 115.176  28.730  1.00 28.04           N  
ATOM   4080  N   ARG C  39     -23.123 113.704  29.632  1.00 28.09           N  
ATOM   4081  CA  ARG C  39     -24.243 113.396  30.495  1.00 28.62           C  
ATOM   4082  C   ARG C  39     -25.280 112.575  29.773  1.00 28.38           C  
ATOM   4083  O   ARG C  39     -25.838 111.640  30.354  1.00 28.51           O  
ATOM   4084  CB  ARG C  39     -24.882 114.687  31.038  1.00 28.66           C  
ATOM   4085  CG  ARG C  39     -24.070 115.285  32.157  1.00 30.07           C  
ATOM   4086  CD  ARG C  39     -24.811 116.382  32.876  1.00 32.85           C  
ATOM   4087  NE  ARG C  39     -24.803 117.611  32.089  1.00 36.02           N  
ATOM   4088  CZ  ARG C  39     -23.820 118.513  32.088  1.00 36.29           C  
ATOM   4089  NH1 ARG C  39     -22.730 118.345  32.847  1.00 32.91           N  
ATOM   4090  NH2 ARG C  39     -23.937 119.589  31.316  1.00 37.50           N  
ATOM   4091  N   GLU C  40     -25.553 112.927  28.515  1.00 27.51           N  
ATOM   4092  CA  GLU C  40     -26.556 112.204  27.746  1.00 27.05           C  
ATOM   4093  C   GLU C  40     -26.089 110.778  27.337  1.00 26.77           C  
ATOM   4094  O   GLU C  40     -26.885 109.837  27.352  1.00 26.59           O  
ATOM   4095  CB  GLU C  40     -27.004 113.021  26.532  1.00 27.74           C  
ATOM   4096  CG  GLU C  40     -27.916 114.193  26.886  1.00 25.75           C  
ATOM   4097  CD  GLU C  40     -28.587 114.786  25.663  1.00 27.39           C  
ATOM   4098  OE1 GLU C  40     -27.933 114.823  24.594  1.00 27.04           O  
ATOM   4099  OE2 GLU C  40     -29.770 115.217  25.770  1.00 24.32           O  
ATOM   4100  N   MET C  41     -24.807 110.629  27.007  1.00 25.04           N  
ATOM   4101  CA  MET C  41     -24.212 109.334  26.715  1.00 24.93           C  
ATOM   4102  C   MET C  41     -24.263 108.350  27.896  1.00 25.34           C  
ATOM   4103  O   MET C  41     -24.445 107.143  27.693  1.00 26.31           O  
ATOM   4104  CB  MET C  41     -22.776 109.513  26.227  1.00 24.73           C  
ATOM   4105  CG  MET C  41     -22.668 109.721  24.676  1.00 24.25           C  
ATOM   4106  SD  MET C  41     -23.592 108.466  23.710  1.00 24.52           S  
ATOM   4107  CE  MET C  41     -22.886 106.905  24.272  1.00 23.66           C  
ATOM   4108  N   ILE C  42     -24.142 108.869  29.116  1.00 24.78           N  
ATOM   4109  CA  ILE C  42     -24.348 108.054  30.308  1.00 24.48           C  
ATOM   4110  C   ILE C  42     -25.764 107.476  30.269  1.00 24.50           C  
ATOM   4111  O   ILE C  42     -25.967 106.257  30.423  1.00 23.89           O  
ATOM   4112  CB  ILE C  42     -24.104 108.840  31.620  1.00 25.03           C  
ATOM   4113  CG1 ILE C  42     -22.616 109.219  31.742  1.00 24.51           C  
ATOM   4114  CG2 ILE C  42     -24.545 108.007  32.872  1.00 26.82           C  
ATOM   4115  CD1 ILE C  42     -22.291 110.261  32.784  1.00 23.93           C  
ATOM   4116  N   ASP C  43     -26.744 108.364  30.097  1.00 24.13           N  
ATOM   4117  CA  ASP C  43     -28.124 107.960  30.047  1.00 24.80           C  
ATOM   4118  C   ASP C  43     -28.339 106.949  28.897  1.00 24.13           C  
ATOM   4119  O   ASP C  43     -29.047 105.957  29.067  1.00 24.34           O  
ATOM   4120  CB  ASP C  43     -29.023 109.196  29.896  1.00 24.43           C  
ATOM   4121  CG  ASP C  43     -30.479 108.888  30.145  1.00 27.48           C  
ATOM   4122  OD1 ASP C  43     -30.798 108.076  31.039  1.00 32.33           O  
ATOM   4123  OD2 ASP C  43     -31.318 109.465  29.437  1.00 29.39           O  
ATOM   4124  N   VAL C  44     -27.697 107.183  27.761  1.00 23.27           N  
ATOM   4125  CA  VAL C  44     -27.845 106.290  26.608  1.00 25.57           C  
ATOM   4126  C   VAL C  44     -27.338 104.867  26.931  1.00 25.57           C  
ATOM   4127  O   VAL C  44     -28.052 103.845  26.718  1.00 25.06           O  
ATOM   4128  CB  VAL C  44     -27.108 106.868  25.384  1.00 25.30           C  
ATOM   4129  CG1 VAL C  44     -27.136 105.871  24.163  1.00 27.32           C  
ATOM   4130  CG2 VAL C  44     -27.724 108.204  24.992  1.00 26.50           C  
ATOM   4131  N   LEU C  45     -26.108 104.804  27.449  1.00 26.14           N  
ATOM   4132  CA  LEU C  45     -25.510 103.540  27.826  1.00 26.48           C  
ATOM   4133  C   LEU C  45     -26.351 102.850  28.899  1.00 27.24           C  
ATOM   4134  O   LEU C  45     -26.604 101.646  28.811  1.00 28.43           O  
ATOM   4135  CB  LEU C  45     -24.057 103.733  28.272  1.00 26.66           C  
ATOM   4136  CG  LEU C  45     -23.058 104.225  27.208  1.00 26.45           C  
ATOM   4137  CD1 LEU C  45     -21.587 104.316  27.755  1.00 24.22           C  
ATOM   4138  CD2 LEU C  45     -23.092 103.334  25.956  1.00 25.56           C  
ATOM   4139  N   GLU C  46     -26.827 103.613  29.882  1.00 28.10           N  
ATOM   4140  CA  GLU C  46     -27.650 103.057  30.936  1.00 28.90           C  
ATOM   4141  C   GLU C  46     -28.985 102.553  30.388  1.00 28.49           C  
ATOM   4142  O   GLU C  46     -29.455 101.478  30.762  1.00 29.09           O  
ATOM   4143  CB  GLU C  46     -27.875 104.092  32.027  1.00 28.75           C  
ATOM   4144  CG  GLU C  46     -26.736 104.205  33.023  1.00 29.35           C  
ATOM   4145  CD  GLU C  46     -26.946 105.357  34.017  1.00 31.92           C  
ATOM   4146  OE1 GLU C  46     -27.975 106.102  33.935  1.00 33.88           O  
ATOM   4147  OE2 GLU C  46     -26.058 105.525  34.866  1.00 36.92           O  
ATOM   4148  N   THR C  47     -29.583 103.316  29.479  1.00 28.53           N  
ATOM   4149  CA  THR C  47     -30.852 102.925  28.859  1.00 28.08           C  
ATOM   4150  C   THR C  47     -30.757 101.652  28.026  1.00 28.08           C  
ATOM   4151  O   THR C  47     -31.516 100.683  28.246  1.00 27.54           O  
ATOM   4152  CB  THR C  47     -31.423 104.095  28.027  1.00 28.02           C  
ATOM   4153  OG1 THR C  47     -31.672 105.191  28.917  1.00 25.90           O  
ATOM   4154  CG2 THR C  47     -32.723 103.698  27.327  1.00 27.63           C  
ATOM   4155  N   LEU C  48     -29.839 101.668  27.068  1.00 28.15           N  
ATOM   4156  CA  LEU C  48     -29.611 100.544  26.160  1.00 28.60           C  
ATOM   4157  C   LEU C  48     -29.209  99.229  26.872  1.00 28.74           C  
ATOM   4158  O   LEU C  48     -29.491  98.138  26.375  1.00 28.38           O  
ATOM   4159  CB  LEU C  48     -28.550 100.932  25.135  1.00 28.85           C  
ATOM   4160  CG  LEU C  48     -29.060 101.938  24.087  1.00 29.48           C  
ATOM   4161  CD1 LEU C  48     -27.958 102.334  23.132  1.00 28.35           C  
ATOM   4162  CD2 LEU C  48     -30.215 101.344  23.299  1.00 33.44           C  
ATOM   4163  N   GLU C  49     -28.563  99.360  28.030  1.00 28.55           N  
ATOM   4164  CA  GLU C  49     -28.187  98.216  28.845  1.00 29.74           C  
ATOM   4165  C   GLU C  49     -29.430  97.383  29.242  1.00 30.03           C  
ATOM   4166  O   GLU C  49     -29.378  96.138  29.277  1.00 28.48           O  
ATOM   4167  CB  GLU C  49     -27.442  98.710  30.084  1.00 30.81           C  
ATOM   4168  CG  GLU C  49     -26.715  97.646  30.804  1.00 33.10           C  
ATOM   4169  CD  GLU C  49     -26.152  98.139  32.110  1.00 36.82           C  
ATOM   4170  OE1 GLU C  49     -26.696  99.081  32.719  1.00 39.06           O  
ATOM   4171  OE2 GLU C  49     -25.158  97.553  32.534  1.00 35.31           O  
ATOM   4172  N   GLN C  50     -30.544  98.086  29.506  1.00 29.28           N  
ATOM   4173  CA  GLN C  50     -31.779  97.470  29.972  1.00 29.71           C  
ATOM   4174  C   GLN C  50     -32.734  97.126  28.818  1.00 29.59           C  
ATOM   4175  O   GLN C  50     -33.842  96.586  29.035  1.00 29.58           O  
ATOM   4176  CB  GLN C  50     -32.478  98.415  30.908  1.00 30.35           C  
ATOM   4177  CG  GLN C  50     -31.925  98.435  32.334  1.00 32.73           C  
ATOM   4178  CD  GLN C  50     -32.970  98.990  33.284  1.00 39.90           C  
ATOM   4179  OE1 GLN C  50     -32.791 100.068  33.837  1.00 44.40           O  
ATOM   4180  NE2 GLN C  50     -34.105  98.284  33.431  1.00 42.52           N  
ATOM   4181  N   ASP C  51     -32.321  97.458  27.604  1.00 28.18           N  
ATOM   4182  CA  ASP C  51     -33.208  97.280  26.447  1.00 29.29           C  
ATOM   4183  C   ASP C  51     -33.065  95.872  25.790  1.00 28.84           C  
ATOM   4184  O   ASP C  51     -32.083  95.610  25.107  1.00 28.00           O  
ATOM   4185  CB  ASP C  51     -32.974  98.410  25.445  1.00 28.29           C  
ATOM   4186  CG  ASP C  51     -34.018  98.443  24.392  1.00 30.95           C  
ATOM   4187  OD1 ASP C  51     -34.727  97.420  24.284  1.00 29.68           O  
ATOM   4188  OD2 ASP C  51     -34.133  99.466  23.681  1.00 29.65           O  
ATOM   4189  N   PRO C  52     -34.043  94.953  26.012  1.00 29.69           N  
ATOM   4190  CA  PRO C  52     -33.857  93.548  25.557  1.00 30.00           C  
ATOM   4191  C   PRO C  52     -33.824  93.469  24.055  1.00 30.24           C  
ATOM   4192  O   PRO C  52     -33.446  92.429  23.492  1.00 30.80           O  
ATOM   4193  CB  PRO C  52     -35.139  92.845  26.022  1.00 30.21           C  
ATOM   4194  CG  PRO C  52     -36.173  93.972  26.072  1.00 30.93           C  
ATOM   4195  CD  PRO C  52     -35.362  95.133  26.650  1.00 30.19           C  
ATOM   4196  N   ALA C  53     -34.209  94.559  23.405  1.00 29.35           N  
ATOM   4197  CA  ALA C  53     -34.208  94.575  21.941  1.00 30.15           C  
ATOM   4198  C   ALA C  53     -32.805  94.840  21.433  1.00 30.58           C  
ATOM   4199  O   ALA C  53     -32.511  94.571  20.291  1.00 31.50           O  
ATOM   4200  CB  ALA C  53     -35.168  95.609  21.406  1.00 29.80           C  
ATOM   4201  N   ALA C  54     -31.940  95.383  22.284  1.00 31.15           N  
ATOM   4202  CA  ALA C  54     -30.604  95.742  21.813  1.00 31.04           C  
ATOM   4203  C   ALA C  54     -29.582  94.689  22.257  1.00 30.89           C  
ATOM   4204  O   ALA C  54     -29.429  94.415  23.456  1.00 30.43           O  
ATOM   4205  CB  ALA C  54     -30.227  97.144  22.312  1.00 31.32           C  
ATOM   4206  N   GLY C  55     -28.896  94.083  21.301  1.00 29.67           N  
ATOM   4207  CA  GLY C  55     -27.937  93.061  21.652  1.00 29.95           C  
ATOM   4208  C   GLY C  55     -26.485  93.426  21.369  1.00 29.59           C  
ATOM   4209  O   GLY C  55     -25.593  92.759  21.865  1.00 28.74           O  
ATOM   4210  N   VAL C  56     -26.268  94.426  20.507  1.00 29.53           N  
ATOM   4211  CA  VAL C  56     -24.927  94.927  20.159  1.00 29.48           C  
ATOM   4212  C   VAL C  56     -25.050  96.429  19.981  1.00 29.06           C  
ATOM   4213  O   VAL C  56     -26.069  96.897  19.469  1.00 29.21           O  
ATOM   4214  CB  VAL C  56     -24.326  94.304  18.826  1.00 29.59           C  
ATOM   4215  CG1 VAL C  56     -23.003  94.973  18.438  1.00 28.36           C  
ATOM   4216  CG2 VAL C  56     -24.056  92.821  18.942  1.00 32.37           C  
ATOM   4217  N   LEU C  57     -24.054  97.189  20.446  1.00 28.63           N  
ATOM   4218  CA  LEU C  57     -24.029  98.635  20.257  1.00 29.17           C  
ATOM   4219  C   LEU C  57     -23.000  99.005  19.233  1.00 28.74           C  
ATOM   4220  O   LEU C  57     -21.903  98.524  19.284  1.00 30.92           O  
ATOM   4221  CB  LEU C  57     -23.730  99.379  21.579  1.00 29.96           C  
ATOM   4222  CG  LEU C  57     -24.934  99.762  22.439  1.00 30.17           C  
ATOM   4223  CD1 LEU C  57     -25.617  98.516  23.045  1.00 31.02           C  
ATOM   4224  CD2 LEU C  57     -24.520 100.760  23.543  1.00 33.00           C  
ATOM   4225  N   VAL C  58     -23.349  99.873  18.306  1.00 28.62           N  
ATOM   4226  CA  VAL C  58     -22.387 100.381  17.314  1.00 27.98           C  
ATOM   4227  C   VAL C  58     -22.290 101.878  17.506  1.00 27.91           C  
ATOM   4228  O   VAL C  58     -23.287 102.624  17.308  1.00 28.36           O  
ATOM   4229  CB  VAL C  58     -22.779 100.049  15.839  1.00 27.75           C  
ATOM   4230  CG1 VAL C  58     -21.828 100.733  14.867  1.00 25.34           C  
ATOM   4231  CG2 VAL C  58     -22.814  98.536  15.613  1.00 27.76           C  
ATOM   4232  N   LEU C  59     -21.108 102.322  17.912  1.00 27.69           N  
ATOM   4233  CA  LEU C  59     -20.911 103.728  18.273  1.00 27.33           C  
ATOM   4234  C   LEU C  59     -20.303 104.407  17.056  1.00 28.12           C  
ATOM   4235  O   LEU C  59     -19.222 104.021  16.592  1.00 27.03           O  
ATOM   4236  CB  LEU C  59     -20.041 103.882  19.536  1.00 26.04           C  
ATOM   4237  CG  LEU C  59     -19.536 105.265  19.997  1.00 27.39           C  
ATOM   4238  CD1 LEU C  59     -20.683 106.269  20.161  1.00 26.15           C  
ATOM   4239  CD2 LEU C  59     -18.735 105.231  21.291  1.00 25.76           C  
ATOM   4240  N   THR C  60     -21.044 105.384  16.522  1.00 28.38           N  
ATOM   4241  CA  THR C  60     -20.667 106.097  15.306  1.00 29.07           C  
ATOM   4242  C   THR C  60     -21.003 107.600  15.418  1.00 29.54           C  
ATOM   4243  O   THR C  60     -21.637 108.038  16.415  1.00 29.80           O  
ATOM   4244  CB  THR C  60     -21.325 105.421  14.060  1.00 29.38           C  
ATOM   4245  OG1 THR C  60     -20.626 105.788  12.851  1.00 29.52           O  
ATOM   4246  CG2 THR C  60     -22.845 105.769  13.938  1.00 30.58           C  
ATOM   4247  N   GLY C  61     -20.585 108.380  14.418  1.00 29.55           N  
ATOM   4248  CA  GLY C  61     -20.889 109.814  14.360  1.00 29.29           C  
ATOM   4249  C   GLY C  61     -21.805 110.272  13.225  1.00 29.77           C  
ATOM   4250  O   GLY C  61     -21.838 109.667  12.159  1.00 29.47           O  
ATOM   4251  N   ALA C  62     -22.551 111.350  13.474  1.00 29.85           N  
ATOM   4252  CA  ALA C  62     -23.377 111.998  12.475  1.00 30.95           C  
ATOM   4253  C   ALA C  62     -22.500 112.885  11.596  1.00 30.95           C  
ATOM   4254  O   ALA C  62     -21.542 113.500  12.089  1.00 31.39           O  
ATOM   4255  CB  ALA C  62     -24.464 112.825  13.146  1.00 30.59           C  
ATOM   4256  N   GLY C  63     -22.837 112.971  10.308  1.00 31.37           N  
ATOM   4257  CA  GLY C  63     -22.021 113.726   9.373  1.00 30.47           C  
ATOM   4258  C   GLY C  63     -20.646 113.137   9.135  1.00 29.90           C  
ATOM   4259  O   GLY C  63     -20.460 111.909   9.141  1.00 30.09           O  
ATOM   4260  N   GLU C  64     -19.666 114.007   8.915  1.00 30.05           N  
ATOM   4261  CA  GLU C  64     -18.360 113.520   8.445  1.00 30.41           C  
ATOM   4262  C   GLU C  64     -17.488 112.993   9.561  1.00 30.02           C  
ATOM   4263  O   GLU C  64     -16.629 112.147   9.319  1.00 30.19           O  
ATOM   4264  CB  GLU C  64     -17.604 114.569   7.602  1.00 31.11           C  
ATOM   4265  CG  GLU C  64     -17.269 115.885   8.310  1.00 32.84           C  
ATOM   4266  N   ALA C  65     -17.724 113.460  10.786  1.00 29.53           N  
ATOM   4267  CA  ALA C  65     -16.863 113.089  11.916  1.00 28.85           C  
ATOM   4268  C   ALA C  65     -17.375 111.885  12.689  1.00 28.84           C  
ATOM   4269  O   ALA C  65     -18.591 111.626  12.753  1.00 28.19           O  
ATOM   4270  CB  ALA C  65     -16.715 114.249  12.856  1.00 29.20           C  
ATOM   4271  N   TRP C  66     -16.441 111.151  13.290  1.00 28.37           N  
ATOM   4272  CA  TRP C  66     -16.806 110.212  14.324  1.00 28.76           C  
ATOM   4273  C   TRP C  66     -16.941 111.071  15.592  1.00 29.67           C  
ATOM   4274  O   TRP C  66     -18.061 111.342  16.030  1.00 30.67           O  
ATOM   4275  CB  TRP C  66     -15.768 109.067  14.436  1.00 27.61           C  
ATOM   4276  CG  TRP C  66     -16.212 107.959  15.333  1.00 27.55           C  
ATOM   4277  CD1 TRP C  66     -17.242 107.080  15.110  1.00 29.16           C  
ATOM   4278  CD2 TRP C  66     -15.679 107.633  16.608  1.00 27.07           C  
ATOM   4279  NE1 TRP C  66     -17.358 106.206  16.163  1.00 26.07           N  
ATOM   4280  CE2 TRP C  66     -16.418 106.532  17.105  1.00 28.49           C  
ATOM   4281  CE3 TRP C  66     -14.633 108.151  17.383  1.00 23.60           C  
ATOM   4282  CZ2 TRP C  66     -16.136 105.937  18.340  1.00 27.80           C  
ATOM   4283  CZ3 TRP C  66     -14.362 107.575  18.622  1.00 26.28           C  
ATOM   4284  CH2 TRP C  66     -15.118 106.481  19.094  1.00 28.75           C  
ATOM   4285  N   THR C  67     -15.818 111.533  16.156  1.00 30.13           N  
ATOM   4286  CA  THR C  67     -15.808 112.706  17.057  1.00 29.26           C  
ATOM   4287  C   THR C  67     -14.490 113.452  16.866  1.00 30.25           C  
ATOM   4288  O   THR C  67     -13.434 112.835  16.752  1.00 29.42           O  
ATOM   4289  CB  THR C  67     -16.008 112.381  18.578  1.00 30.64           C  
ATOM   4290  OG1 THR C  67     -15.835 113.577  19.349  1.00 28.15           O  
ATOM   4291  CG2 THR C  67     -14.998 111.301  19.092  1.00 26.90           C  
ATOM   4292  N   ALA C  68     -14.570 114.778  16.832  1.00 30.10           N  
ATOM   4293  CA  ALA C  68     -13.401 115.649  16.748  1.00 31.08           C  
ATOM   4294  C   ALA C  68     -12.764 115.815  18.135  1.00 32.63           C  
ATOM   4295  O   ALA C  68     -11.721 116.476  18.295  1.00 32.42           O  
ATOM   4296  CB  ALA C  68     -13.795 117.018  16.134  1.00 31.78           C  
ATOM   4297  N   GLY C  69     -13.373 115.162  19.131  1.00 33.23           N  
ATOM   4298  CA  GLY C  69     -12.805 115.090  20.482  1.00 35.42           C  
ATOM   4299  C   GLY C  69     -13.575 115.927  21.490  1.00 36.68           C  
ATOM   4300  O   GLY C  69     -14.774 116.169  21.330  1.00 37.02           O  
ATOM   4301  N   MET C  70     -12.881 116.391  22.517  1.00 37.85           N  
ATOM   4302  CA  MET C  70     -13.522 117.164  23.572  1.00 40.27           C  
ATOM   4303  C   MET C  70     -13.955 118.514  23.000  1.00 38.76           C  
ATOM   4304  O   MET C  70     -13.214 119.124  22.226  1.00 37.61           O  
ATOM   4305  CB  MET C  70     -12.577 117.352  24.759  1.00 40.31           C  
ATOM   4306  CG  MET C  70     -11.556 118.495  24.616  1.00 43.11           C  
ATOM   4307  SD  MET C  70     -10.956 119.202  26.208  1.00 47.25           S  
ATOM   4308  CE  MET C  70     -12.445 119.276  27.205  1.00 46.49           C  
ATOM   4309  N   ASP C  71     -15.156 118.961  23.357  1.00 38.13           N  
ATOM   4310  CA  ASP C  71     -15.626 120.291  22.939  1.00 37.91           C  
ATOM   4311  C   ASP C  71     -15.007 121.273  23.919  1.00 38.79           C  
ATOM   4312  O   ASP C  71     -15.477 121.390  25.059  1.00 38.01           O  
ATOM   4313  CB  ASP C  71     -17.156 120.359  23.010  1.00 37.07           C  
ATOM   4314  CG  ASP C  71     -17.731 121.668  22.442  1.00 35.29           C  
ATOM   4315  OD1 ASP C  71     -17.097 122.739  22.567  1.00 28.60           O  
ATOM   4316  OD2 ASP C  71     -18.828 121.612  21.856  1.00 33.34           O  
ATOM   4317  N   LEU C  72     -13.935 121.948  23.506  1.00 39.99           N  
ATOM   4318  CA  LEU C  72     -13.181 122.777  24.466  1.00 41.62           C  
ATOM   4319  C   LEU C  72     -13.854 124.101  24.864  1.00 42.96           C  
ATOM   4320  O   LEU C  72     -13.645 124.593  25.987  1.00 43.61           O  
ATOM   4321  CB  LEU C  72     -11.734 123.002  24.008  1.00 41.85           C  
ATOM   4322  CG  LEU C  72     -10.737 123.514  25.057  0.50 41.89           C  
ATOM   4323  CD1 LEU C  72     -10.695 122.605  26.282  0.50 42.75           C  
ATOM   4324  CD2 LEU C  72      -9.341 123.671  24.461  0.50 42.62           C  
ATOM   4325  N   LYS C  73     -14.669 124.670  23.977  1.00 44.13           N  
ATOM   4326  CA  LYS C  73     -15.457 125.844  24.357  1.00 45.43           C  
ATOM   4327  C   LYS C  73     -16.532 125.449  25.377  1.00 46.35           C  
ATOM   4328  O   LYS C  73     -16.636 126.040  26.452  1.00 46.18           O  
ATOM   4329  CB  LYS C  73     -16.062 126.529  23.136  0.50 45.32           C  
ATOM   4330  CG  LYS C  73     -15.038 127.285  22.298  0.50 45.83           C  
ATOM   4331  CD  LYS C  73     -15.650 128.536  21.674  0.50 46.43           C  
ATOM   4332  CE  LYS C  73     -14.666 129.232  20.738  0.50 46.36           C  
ATOM   4333  NZ  LYS C  73     -15.212 130.516  20.212  0.50 46.34           N  
ATOM   4334  N   GLU C  74     -17.298 124.419  25.036  1.00 47.85           N  
ATOM   4335  CA  GLU C  74     -18.387 123.903  25.867  1.00 49.78           C  
ATOM   4336  C   GLU C  74     -17.921 123.394  27.256  1.00 51.10           C  
ATOM   4337  O   GLU C  74     -18.674 123.468  28.240  1.00 51.08           O  
ATOM   4338  CB  GLU C  74     -19.103 122.803  25.088  1.00 49.77           C  
ATOM   4339  CG  GLU C  74     -20.615 122.866  25.076  1.00 51.06           C  
ATOM   4340  CD  GLU C  74     -21.161 124.223  24.747  1.00 52.69           C  
ATOM   4341  OE1 GLU C  74     -20.691 124.852  23.777  1.00 53.69           O  
ATOM   4342  OE2 GLU C  74     -22.077 124.661  25.466  1.00 53.74           O  
ATOM   4343  N   TYR C  75     -16.682 122.893  27.325  1.00 52.63           N  
ATOM   4344  CA  TYR C  75     -16.011 122.542  28.593  1.00 54.22           C  
ATOM   4345  C   TYR C  75     -15.709 123.771  29.475  1.00 55.00           C  
ATOM   4346  O   TYR C  75     -16.109 123.806  30.636  1.00 55.15           O  
ATOM   4347  CB  TYR C  75     -14.716 121.773  28.308  1.00 54.76           C  
ATOM   4348  CG  TYR C  75     -13.846 121.484  29.518  1.00 55.74           C  
ATOM   4349  CD1 TYR C  75     -12.889 122.411  29.955  1.00 56.76           C  
ATOM   4350  CD2 TYR C  75     -13.957 120.270  30.212  1.00 56.77           C  
ATOM   4351  CE1 TYR C  75     -12.083 122.153  31.078  1.00 57.24           C  
ATOM   4352  CE2 TYR C  75     -13.144 119.990  31.333  1.00 56.80           C  
ATOM   4353  CZ  TYR C  75     -12.213 120.939  31.755  1.00 56.76           C  
ATOM   4354  OH  TYR C  75     -11.416 120.682  32.853  1.00 57.61           O  
ATOM   4355  N   PHE C  76     -14.985 124.752  28.926  1.00 55.91           N  
ATOM   4356  CA  PHE C  76     -14.646 125.990  29.644  1.00 56.75           C  
ATOM   4357  C   PHE C  76     -15.876 126.791  30.035  1.00 56.71           C  
ATOM   4358  O   PHE C  76     -15.879 127.439  31.083  1.00 57.09           O  
ATOM   4359  CB  PHE C  76     -13.707 126.889  28.820  1.00 57.30           C  
ATOM   4360  CG  PHE C  76     -12.293 126.384  28.737  1.00 58.62           C  
ATOM   4361  CD1 PHE C  76     -11.743 125.626  29.772  1.00 59.84           C  
ATOM   4362  CD2 PHE C  76     -11.501 126.685  27.631  1.00 60.15           C  
ATOM   4363  CE1 PHE C  76     -10.429 125.151  29.698  1.00 60.04           C  
ATOM   4364  CE2 PHE C  76     -10.179 126.223  27.549  1.00 60.08           C  
ATOM   4365  CZ  PHE C  76      -9.646 125.458  28.587  1.00 59.51           C  
ATOM   4366  N   ARG C  77     -16.904 126.758  29.185  1.00 56.55           N  
ATOM   4367  CA  ARG C  77     -18.175 127.425  29.460  1.00 55.98           C  
ATOM   4368  C   ARG C  77     -18.632 127.096  30.880  1.00 55.79           C  
ATOM   4369  O   ARG C  77     -18.964 127.996  31.652  1.00 55.95           O  
ATOM   4370  N   GLU C  78     -18.619 125.808  31.220  1.00 55.46           N  
ATOM   4371  CA  GLU C  78     -19.039 125.343  32.545  1.00 55.15           C  
ATOM   4372  C   GLU C  78     -17.957 125.495  33.634  1.00 54.98           C  
ATOM   4373  O   GLU C  78     -18.249 125.991  34.725  1.00 55.06           O  
ATOM   4374  CB  GLU C  78     -19.575 123.900  32.478  1.00 55.14           C  
ATOM   4375  CG  GLU C  78     -20.716 123.697  31.462  1.00 55.09           C  
ATOM   4376  CD  GLU C  78     -21.421 122.336  31.554  1.00 55.05           C  
ATOM   4377  OE1 GLU C  78     -21.297 121.645  32.596  1.00 54.72           O  
ATOM   4378  OE2 GLU C  78     -22.115 121.964  30.575  1.00 53.40           O  
ATOM   4379  N   VAL C  79     -16.719 125.096  33.322  1.00 54.87           N  
ATOM   4380  CA  VAL C  79     -15.605 125.057  34.297  1.00 54.70           C  
ATOM   4381  C   VAL C  79     -15.204 126.420  34.894  1.00 54.63           C  
ATOM   4382  O   VAL C  79     -14.782 126.495  36.059  1.00 54.96           O  
ATOM   4383  CB  VAL C  79     -14.341 124.375  33.707  1.00 54.52           C  
ATOM   4384  N   ASP C  80     -15.341 127.487  34.105  1.00 54.05           N  
ATOM   4385  CA  ASP C  80     -14.996 128.844  34.550  1.00 53.11           C  
ATOM   4386  C   ASP C  80     -16.183 129.591  35.176  1.00 52.32           C  
ATOM   4387  O   ASP C  80     -16.004 130.651  35.791  1.00 52.35           O  
ATOM   4388  CB  ASP C  80     -14.403 129.651  33.392  1.00 53.46           C  
ATOM   4389  CG  ASP C  80     -13.174 128.982  32.779  1.00 53.93           C  
ATOM   4390  N   ALA C  81     -17.389 129.039  35.025  1.00 50.98           N  
ATOM   4391  CA  ALA C  81     -18.591 129.614  35.652  1.00 49.48           C  
ATOM   4392  C   ALA C  81     -18.847 129.005  37.033  1.00 48.27           C  
ATOM   4393  O   ALA C  81     -19.726 129.456  37.770  1.00 48.33           O  
ATOM   4394  CB  ALA C  81     -19.819 129.446  34.750  1.00 49.55           C  
ATOM   4395  N   GLY C  82     -18.078 127.971  37.368  1.00 46.70           N  
ATOM   4396  CA  GLY C  82     -18.184 127.316  38.667  1.00 44.14           C  
ATOM   4397  C   GLY C  82     -16.850 127.233  39.381  1.00 42.12           C  
ATOM   4398  O   GLY C  82     -15.792 127.441  38.775  1.00 42.06           O  
ATOM   4399  N   PRO C  83     -16.885 126.897  40.673  1.00 40.69           N  
ATOM   4400  CA  PRO C  83     -15.672 126.795  41.485  1.00 39.41           C  
ATOM   4401  C   PRO C  83     -14.837 125.577  41.052  1.00 38.00           C  
ATOM   4402  O   PRO C  83     -15.321 124.759  40.256  1.00 37.14           O  
ATOM   4403  CB  PRO C  83     -16.228 126.622  42.900  1.00 39.97           C  
ATOM   4404  CG  PRO C  83     -17.539 125.931  42.690  1.00 40.58           C  
ATOM   4405  CD  PRO C  83     -18.094 126.539  41.433  1.00 40.68           C  
ATOM   4406  N   GLU C  84     -13.603 125.471  41.552  1.00 36.67           N  
ATOM   4407  CA  GLU C  84     -12.687 124.377  41.180  1.00 35.36           C  
ATOM   4408  C   GLU C  84     -13.377 123.008  41.172  1.00 34.54           C  
ATOM   4409  O   GLU C  84     -13.167 122.191  40.254  1.00 33.41           O  
ATOM   4410  CB  GLU C  84     -11.448 124.368  42.101  1.00 35.85           C  
ATOM   4411  CG  GLU C  84     -10.357 123.290  41.812  1.00 36.77           C  
ATOM   4412  CD  GLU C  84     -10.673 121.899  42.414  1.00 37.84           C  
ATOM   4413  OE1 GLU C  84     -11.301 121.831  43.496  1.00 38.48           O  
ATOM   4414  OE2 GLU C  84     -10.284 120.872  41.801  1.00 39.23           O  
ATOM   4415  N   ILE C  85     -14.195 122.758  42.195  1.00 33.54           N  
ATOM   4416  CA  ILE C  85     -14.763 121.430  42.394  1.00 33.28           C  
ATOM   4417  C   ILE C  85     -15.701 120.982  41.280  1.00 32.66           C  
ATOM   4418  O   ILE C  85     -15.918 119.782  41.094  1.00 32.02           O  
ATOM   4419  CB  ILE C  85     -15.408 121.269  43.786  1.00 33.67           C  
ATOM   4420  CG1 ILE C  85     -15.496 119.768  44.138  1.00 34.70           C  
ATOM   4421  CG2 ILE C  85     -16.746 122.021  43.859  1.00 33.35           C  
ATOM   4422  CD1 ILE C  85     -15.411 119.485  45.615  1.00 35.99           C  
ATOM   4423  N   LEU C  86     -16.234 121.942  40.522  1.00 32.38           N  
ATOM   4424  CA  LEU C  86     -17.046 121.619  39.348  1.00 32.37           C  
ATOM   4425  C   LEU C  86     -16.259 120.757  38.329  1.00 32.73           C  
ATOM   4426  O   LEU C  86     -16.819 119.860  37.680  1.00 32.44           O  
ATOM   4427  CB  LEU C  86     -17.578 122.895  38.681  1.00 32.14           C  
ATOM   4428  CG  LEU C  86     -18.624 122.715  37.576  1.00 32.29           C  
ATOM   4429  CD1 LEU C  86     -19.660 121.611  37.885  1.00 34.19           C  
ATOM   4430  CD2 LEU C  86     -19.309 124.046  37.239  1.00 33.30           C  
ATOM   4431  N   GLN C  87     -14.965 121.047  38.194  1.00 32.96           N  
ATOM   4432  CA  GLN C  87     -14.096 120.309  37.293  1.00 34.23           C  
ATOM   4433  C   GLN C  87     -14.094 118.796  37.612  1.00 33.77           C  
ATOM   4434  O   GLN C  87     -14.125 117.958  36.692  1.00 33.72           O  
ATOM   4435  CB  GLN C  87     -12.692 120.908  37.344  1.00 33.68           C  
ATOM   4436  CG  GLN C  87     -11.704 120.306  36.350  1.00 36.41           C  
ATOM   4437  CD  GLN C  87     -10.264 120.739  36.638  1.00 37.21           C  
ATOM   4438  OE1 GLN C  87      -9.733 120.492  37.730  1.00 42.35           O  
ATOM   4439  NE2 GLN C  87      -9.639 121.399  35.672  1.00 37.43           N  
ATOM   4440  N   GLU C  88     -14.080 118.459  38.906  1.00 33.33           N  
ATOM   4441  CA  GLU C  88     -14.136 117.059  39.359  1.00 33.11           C  
ATOM   4442  C   GLU C  88     -15.312 116.346  38.699  1.00 32.11           C  
ATOM   4443  O   GLU C  88     -15.135 115.303  38.039  1.00 30.66           O  
ATOM   4444  CB  GLU C  88     -14.260 116.948  40.894  1.00 33.35           C  
ATOM   4445  CG  GLU C  88     -13.078 117.481  41.696  1.00 37.61           C  
ATOM   4446  CD  GLU C  88     -11.875 116.554  41.656  1.00 44.46           C  
ATOM   4447  OE1 GLU C  88     -11.795 115.612  42.490  1.00 47.63           O  
ATOM   4448  OE2 GLU C  88     -11.001 116.778  40.786  1.00 46.20           O  
ATOM   4449  N   LYS C  89     -16.501 116.930  38.865  1.00 30.21           N  
ATOM   4450  CA  LYS C  89     -17.743 116.385  38.310  1.00 29.78           C  
ATOM   4451  C   LYS C  89     -17.727 116.267  36.776  1.00 28.70           C  
ATOM   4452  O   LYS C  89     -18.176 115.252  36.219  1.00 26.32           O  
ATOM   4453  CB  LYS C  89     -18.944 117.222  38.775  1.00 30.14           C  
ATOM   4454  CG  LYS C  89     -20.300 116.898  38.116  1.00 30.26           C  
ATOM   4455  CD  LYS C  89     -21.359 117.863  38.682  1.00 30.78           C  
ATOM   4456  CE  LYS C  89     -22.723 117.779  37.979  1.00 34.27           C  
ATOM   4457  NZ  LYS C  89     -22.714 118.236  36.509  1.00 35.84           N  
ATOM   4458  N   ILE C  90     -17.228 117.306  36.110  1.00 27.67           N  
ATOM   4459  CA  ILE C  90     -17.213 117.338  34.651  1.00 27.21           C  
ATOM   4460  C   ILE C  90     -16.282 116.237  34.100  1.00 27.78           C  
ATOM   4461  O   ILE C  90     -16.620 115.545  33.140  1.00 27.54           O  
ATOM   4462  CB  ILE C  90     -16.870 118.754  34.143  1.00 27.48           C  
ATOM   4463  CG1 ILE C  90     -18.080 119.689  34.353  1.00 28.43           C  
ATOM   4464  CG2 ILE C  90     -16.491 118.754  32.654  1.00 27.86           C  
ATOM   4465  CD1 ILE C  90     -17.679 121.122  34.606  1.00 31.85           C  
ATOM   4466  N   ARG C  91     -15.130 116.043  34.746  1.00 27.53           N  
ATOM   4467  CA  ARG C  91     -14.236 114.931  34.381  1.00 27.69           C  
ATOM   4468  C   ARG C  91     -14.815 113.558  34.688  1.00 27.82           C  
ATOM   4469  O   ARG C  91     -14.674 112.640  33.879  1.00 28.08           O  
ATOM   4470  CB  ARG C  91     -12.857 115.092  35.030  1.00 26.61           C  
ATOM   4471  CG  ARG C  91     -12.041 116.265  34.448  1.00 27.73           C  
ATOM   4472  CD  ARG C  91     -10.936 116.620  35.434  1.00 27.14           C  
ATOM   4473  NE  ARG C  91      -9.920 117.487  34.845  1.00 28.48           N  
ATOM   4474  CZ  ARG C  91      -8.760 117.794  35.427  1.00 28.89           C  
ATOM   4475  NH1 ARG C  91      -8.445 117.308  36.648  1.00 30.35           N  
ATOM   4476  NH2 ARG C  91      -7.911 118.595  34.807  1.00 22.68           N  
ATOM   4477  N   ARG C  92     -15.437 113.398  35.853  1.00 28.34           N  
ATOM   4478  CA  ARG C  92     -16.059 112.116  36.173  1.00 30.30           C  
ATOM   4479  C   ARG C  92     -17.089 111.729  35.081  1.00 29.58           C  
ATOM   4480  O   ARG C  92     -17.162 110.559  34.693  1.00 29.72           O  
ATOM   4481  CB  ARG C  92     -16.665 112.126  37.594  1.00 30.00           C  
ATOM   4482  CG  ARG C  92     -17.569 110.894  37.904  1.00 34.24           C  
ATOM   4483  CD  ARG C  92     -18.429 111.098  39.187  1.00 33.69           C  
ATOM   4484  NE  ARG C  92     -17.629 111.876  40.107  1.00 38.23           N  
ATOM   4485  CZ  ARG C  92     -17.945 113.048  40.653  1.00 37.48           C  
ATOM   4486  NH1 ARG C  92     -19.128 113.634  40.481  1.00 35.04           N  
ATOM   4487  NH2 ARG C  92     -17.039 113.598  41.432  1.00 39.66           N  
ATOM   4488  N   GLU C  93     -17.833 112.716  34.554  1.00 28.76           N  
ATOM   4489  CA  GLU C  93     -18.930 112.460  33.615  1.00 27.26           C  
ATOM   4490  C   GLU C  93     -18.431 111.989  32.262  1.00 26.14           C  
ATOM   4491  O   GLU C  93     -18.990 111.061  31.685  1.00 25.25           O  
ATOM   4492  CB  GLU C  93     -19.801 113.717  33.436  1.00 27.48           C  
ATOM   4493  CG  GLU C  93     -20.779 113.932  34.599  1.00 28.04           C  
ATOM   4494  CD  GLU C  93     -21.447 115.331  34.654  1.00 27.67           C  
ATOM   4495  OE1 GLU C  93     -21.223 116.209  33.773  1.00 27.91           O  
ATOM   4496  OE2 GLU C  93     -22.209 115.529  35.616  1.00 29.53           O  
ATOM   4497  N   ALA C  94     -17.369 112.634  31.787  1.00 24.43           N  
ATOM   4498  CA  ALA C  94     -16.675 112.231  30.566  1.00 24.66           C  
ATOM   4499  C   ALA C  94     -16.155 110.800  30.707  1.00 25.11           C  
ATOM   4500  O   ALA C  94     -16.436 109.954  29.862  1.00 25.45           O  
ATOM   4501  CB  ALA C  94     -15.550 113.212  30.254  1.00 23.66           C  
ATOM   4502  N   SER C  95     -15.479 110.518  31.818  1.00 24.56           N  
ATOM   4503  CA  SER C  95     -14.946 109.178  32.078  1.00 25.85           C  
ATOM   4504  C   SER C  95     -16.069 108.166  32.213  1.00 25.82           C  
ATOM   4505  O   SER C  95     -15.953 107.035  31.718  1.00 25.87           O  
ATOM   4506  CB  SER C  95     -14.120 109.189  33.355  1.00 25.88           C  
ATOM   4507  OG  SER C  95     -12.830 109.654  33.063  1.00 26.78           O  
ATOM   4508  N   GLN C  96     -17.169 108.587  32.840  1.00 25.22           N  
ATOM   4509  CA  GLN C  96     -18.247 107.674  33.135  1.00 25.91           C  
ATOM   4510  C   GLN C  96     -18.784 106.955  31.914  1.00 25.47           C  
ATOM   4511  O   GLN C  96     -18.870 105.734  31.921  1.00 24.46           O  
ATOM   4512  CB  GLN C  96     -19.365 108.342  33.928  1.00 27.20           C  
ATOM   4513  CG  GLN C  96     -20.493 107.364  34.275  1.00 30.43           C  
ATOM   4514  CD  GLN C  96     -20.118 106.382  35.386  1.00 29.23           C  
ATOM   4515  OE1 GLN C  96     -19.008 106.407  35.910  1.00 32.87           O  
ATOM   4516  NE2 GLN C  96     -21.043 105.493  35.722  1.00 28.88           N  
ATOM   4517  N   TRP C  97     -19.110 107.696  30.855  1.00 25.16           N  
ATOM   4518  CA  TRP C  97     -19.541 107.072  29.611  1.00 25.91           C  
ATOM   4519  C   TRP C  97     -18.411 106.612  28.688  1.00 26.12           C  
ATOM   4520  O   TRP C  97     -18.541 105.578  28.037  1.00 26.67           O  
ATOM   4521  CB  TRP C  97     -20.522 107.968  28.837  1.00 25.94           C  
ATOM   4522  CG  TRP C  97     -19.883 108.954  27.901  1.00 27.13           C  
ATOM   4523  CD1 TRP C  97     -19.612 110.276  28.161  1.00 27.23           C  
ATOM   4524  CD2 TRP C  97     -19.481 108.724  26.539  1.00 27.70           C  
ATOM   4525  NE1 TRP C  97     -19.053 110.867  27.062  1.00 25.98           N  
ATOM   4526  CE2 TRP C  97     -18.968 109.950  26.047  1.00 26.29           C  
ATOM   4527  CE3 TRP C  97     -19.478 107.593  25.693  1.00 26.84           C  
ATOM   4528  CZ2 TRP C  97     -18.468 110.092  24.737  1.00 26.67           C  
ATOM   4529  CZ3 TRP C  97     -18.979 107.734  24.373  1.00 27.86           C  
ATOM   4530  CH2 TRP C  97     -18.477 108.982  23.920  1.00 28.42           C  
ATOM   4531  N   GLN C  98     -17.339 107.391  28.578  1.00 25.36           N  
ATOM   4532  CA  GLN C  98     -16.228 107.004  27.729  1.00 24.39           C  
ATOM   4533  C   GLN C  98     -15.587 105.645  28.052  1.00 24.74           C  
ATOM   4534  O   GLN C  98     -15.210 104.919  27.149  1.00 23.18           O  
ATOM   4535  CB  GLN C  98     -15.160 108.068  27.732  1.00 24.49           C  
ATOM   4536  CG  GLN C  98     -15.699 109.385  27.173  1.00 25.57           C  
ATOM   4537  CD  GLN C  98     -14.657 110.480  27.080  1.00 27.40           C  
ATOM   4538  OE1 GLN C  98     -13.497 110.324  27.499  1.00 31.18           O  
ATOM   4539  NE2 GLN C  98     -15.069 111.605  26.541  1.00 30.33           N  
ATOM   4540  N   TRP C  99     -15.444 105.295  29.323  1.00 25.05           N  
ATOM   4541  CA  TRP C  99     -14.806 104.002  29.638  1.00 25.49           C  
ATOM   4542  C   TRP C  99     -15.298 103.330  30.922  1.00 26.70           C  
ATOM   4543  O   TRP C  99     -15.271 102.094  31.006  1.00 26.90           O  
ATOM   4544  CB  TRP C  99     -13.274 104.134  29.613  1.00 25.77           C  
ATOM   4545  CG  TRP C  99     -12.703 105.163  30.604  1.00 27.01           C  
ATOM   4546  CD1 TRP C  99     -12.441 106.474  30.331  1.00 27.34           C  
ATOM   4547  CD2 TRP C  99     -12.321 104.959  31.981  1.00 26.70           C  
ATOM   4548  NE1 TRP C  99     -11.936 107.105  31.432  1.00 25.59           N  
ATOM   4549  CE2 TRP C  99     -11.854 106.212  32.467  1.00 28.52           C  
ATOM   4550  CE3 TRP C  99     -12.335 103.860  32.851  1.00 25.86           C  
ATOM   4551  CZ2 TRP C  99     -11.411 106.399  33.777  1.00 26.71           C  
ATOM   4552  CZ3 TRP C  99     -11.881 104.038  34.195  1.00 26.09           C  
ATOM   4553  CH2 TRP C  99     -11.430 105.304  34.635  1.00 26.60           C  
ATOM   4554  N   LYS C 100     -15.736 104.098  31.926  1.00 26.54           N  
ATOM   4555  CA  LYS C 100     -16.110 103.451  33.171  1.00 27.47           C  
ATOM   4556  C   LYS C 100     -17.268 102.518  32.884  1.00 27.73           C  
ATOM   4557  O   LYS C 100     -17.237 101.367  33.310  1.00 28.77           O  
ATOM   4558  CB  LYS C 100     -16.431 104.420  34.328  1.00 27.99           C  
ATOM   4559  CG  LYS C 100     -15.246 105.240  34.831  1.00 27.91           C  
ATOM   4560  CD  LYS C 100     -15.589 106.019  36.076  1.00 30.37           C  
ATOM   4561  CE  LYS C 100     -14.458 106.943  36.576  1.00 29.44           C  
ATOM   4562  NZ  LYS C 100     -13.649 106.125  37.448  1.00 34.96           N  
ATOM   4563  N   LEU C 101     -18.292 102.997  32.171  1.00 26.33           N  
ATOM   4564  CA  LEU C 101     -19.361 102.100  31.751  1.00 25.87           C  
ATOM   4565  C   LEU C 101     -18.993 101.339  30.490  1.00 25.71           C  
ATOM   4566  O   LEU C 101     -19.351 100.163  30.361  1.00 25.12           O  
ATOM   4567  CB  LEU C 101     -20.653 102.863  31.449  1.00 26.62           C  
ATOM   4568  CG  LEU C 101     -21.386 103.584  32.552  1.00 25.29           C  
ATOM   4569  CD1 LEU C 101     -22.675 104.279  31.929  1.00 23.26           C  
ATOM   4570  CD2 LEU C 101     -21.717 102.635  33.690  1.00 27.39           C  
ATOM   4571  N   LEU C 102     -18.291 102.007  29.574  1.00 25.31           N  
ATOM   4572  CA  LEU C 102     -18.157 101.492  28.224  1.00 25.19           C  
ATOM   4573  C   LEU C 102     -17.152 100.339  28.147  1.00 25.64           C  
ATOM   4574  O   LEU C 102     -17.429  99.318  27.526  1.00 25.95           O  
ATOM   4575  CB  LEU C 102     -17.787 102.627  27.243  1.00 26.47           C  
ATOM   4576  CG  LEU C 102     -17.855 102.397  25.714  1.00 26.81           C  
ATOM   4577  CD1 LEU C 102     -19.117 101.653  25.206  1.00 28.07           C  
ATOM   4578  CD2 LEU C 102     -17.632 103.656  24.886  1.00 28.03           C  
ATOM   4579  N   ARG C 103     -16.009 100.474  28.821  1.00 24.65           N  
ATOM   4580  CA  ARG C 103     -14.908  99.523  28.583  1.00 24.13           C  
ATOM   4581  C   ARG C 103     -15.342  98.109  28.970  1.00 24.58           C  
ATOM   4582  O   ARG C 103     -15.102  97.132  28.217  1.00 24.97           O  
ATOM   4583  CB  ARG C 103     -13.637  99.971  29.298  1.00 22.07           C  
ATOM   4584  CG  ARG C 103     -12.471  98.937  29.237  1.00 23.01           C  
ATOM   4585  CD  ARG C 103     -11.189  99.601  29.642  1.00 23.38           C  
ATOM   4586  NE  ARG C 103     -10.143  98.607  29.925  1.00 26.08           N  
ATOM   4587  CZ  ARG C 103      -9.764  98.178  31.124  1.00 24.90           C  
ATOM   4588  NH1 ARG C 103     -10.360  98.611  32.252  1.00 22.80           N  
ATOM   4589  NH2 ARG C 103      -8.767  97.288  31.203  1.00 24.43           N  
ATOM   4590  N   MET C 104     -15.990  97.988  30.120  1.00 23.51           N  
ATOM   4591  CA  MET C 104     -16.514  96.712  30.560  1.00 24.21           C  
ATOM   4592  C   MET C 104     -18.062  96.701  30.395  1.00 24.64           C  
ATOM   4593  O   MET C 104     -18.788  96.288  31.309  1.00 24.73           O  
ATOM   4594  CB  MET C 104     -16.133  96.441  32.035  1.00 24.06           C  
ATOM   4595  CG  MET C 104     -14.631  96.374  32.302  1.00 24.87           C  
ATOM   4596  SD  MET C 104     -13.852  95.005  31.417  1.00 24.32           S  
ATOM   4597  CE  MET C 104     -12.223  94.963  32.181  1.00 25.26           C  
ATOM   4598  N   TYR C 105     -18.548  97.167  29.259  1.00 25.23           N  
ATOM   4599  CA  TYR C 105     -20.013  97.244  28.997  1.00 25.66           C  
ATOM   4600  C   TYR C 105     -20.685  95.861  28.982  1.00 25.44           C  
ATOM   4601  O   TYR C 105     -20.068  94.880  28.603  1.00 24.87           O  
ATOM   4602  CB  TYR C 105     -20.289  97.998  27.711  1.00 25.94           C  
ATOM   4603  CG  TYR C 105     -21.726  98.459  27.584  1.00 25.70           C  
ATOM   4604  CD1 TYR C 105     -22.501  98.075  26.484  1.00 26.09           C  
ATOM   4605  CD2 TYR C 105     -22.306  99.275  28.554  1.00 23.89           C  
ATOM   4606  CE1 TYR C 105     -23.852  98.522  26.337  1.00 23.88           C  
ATOM   4607  CE2 TYR C 105     -23.670  99.721  28.440  1.00 22.82           C  
ATOM   4608  CZ  TYR C 105     -24.424  99.337  27.307  1.00 26.29           C  
ATOM   4609  OH  TYR C 105     -25.753  99.755  27.177  1.00 28.14           O  
ATOM   4610  N   ALA C 106     -21.923  95.778  29.452  1.00 25.48           N  
ATOM   4611  CA  ALA C 106     -22.616  94.481  29.557  1.00 26.03           C  
ATOM   4612  C   ALA C 106     -22.751  93.837  28.184  1.00 26.67           C  
ATOM   4613  O   ALA C 106     -22.749  92.596  28.066  1.00 26.80           O  
ATOM   4614  CB  ALA C 106     -24.007  94.656  30.241  1.00 26.35           C  
ATOM   4615  N   LYS C 107     -22.801  94.677  27.142  1.00 26.05           N  
ATOM   4616  CA  LYS C 107     -23.116  94.242  25.795  1.00 27.69           C  
ATOM   4617  C   LYS C 107     -21.929  94.471  24.858  1.00 27.37           C  
ATOM   4618  O   LYS C 107     -21.074  95.338  25.123  1.00 28.50           O  
ATOM   4619  CB  LYS C 107     -24.402  94.930  25.247  1.00 26.86           C  
ATOM   4620  CG  LYS C 107     -25.648  94.511  26.036  1.00 29.03           C  
ATOM   4621  CD  LYS C 107     -26.928  95.267  25.634  1.00 27.73           C  
ATOM   4622  CE  LYS C 107     -28.136  94.718  26.445  1.00 27.08           C  
ATOM   4623  NZ  LYS C 107     -29.459  95.324  25.995  1.00 25.95           N  
ATOM   4624  N   PRO C 108     -21.844  93.675  23.784  1.00 28.10           N  
ATOM   4625  CA  PRO C 108     -20.726  93.856  22.863  1.00 27.78           C  
ATOM   4626  C   PRO C 108     -20.829  95.217  22.193  1.00 26.99           C  
ATOM   4627  O   PRO C 108     -21.942  95.698  21.911  1.00 27.05           O  
ATOM   4628  CB  PRO C 108     -20.909  92.733  21.840  1.00 27.64           C  
ATOM   4629  CG  PRO C 108     -22.320  92.333  21.947  1.00 28.81           C  
ATOM   4630  CD  PRO C 108     -22.719  92.559  23.375  1.00 28.50           C  
ATOM   4631  N   THR C 109     -19.676  95.831  21.959  1.00 25.90           N  
ATOM   4632  CA  THR C 109     -19.597  97.173  21.415  1.00 26.31           C  
ATOM   4633  C   THR C 109     -18.619  97.234  20.249  1.00 26.19           C  
ATOM   4634  O   THR C 109     -17.557  96.597  20.251  1.00 25.84           O  
ATOM   4635  CB  THR C 109     -19.173  98.231  22.492  1.00 27.08           C  
ATOM   4636  OG1 THR C 109     -17.942  97.847  23.111  1.00 27.23           O  
ATOM   4637  CG2 THR C 109     -20.251  98.393  23.600  1.00 25.97           C  
ATOM   4638  N   ILE C 110     -19.009  97.989  19.224  1.00 26.85           N  
ATOM   4639  CA  ILE C 110     -18.183  98.197  18.054  1.00 27.09           C  
ATOM   4640  C   ILE C 110     -18.148  99.694  17.807  1.00 27.53           C  
ATOM   4641  O   ILE C 110     -19.205 100.344  17.763  1.00 29.24           O  
ATOM   4642  CB  ILE C 110     -18.761  97.455  16.800  1.00 26.99           C  
ATOM   4643  CG1 ILE C 110     -19.054  95.973  17.149  1.00 28.11           C  
ATOM   4644  CG2 ILE C 110     -17.821  97.598  15.589  1.00 26.52           C  
ATOM   4645  CD1 ILE C 110     -20.040  95.291  16.179  1.00 26.65           C  
ATOM   4646  N   ALA C 111     -16.951 100.250  17.678  1.00 27.11           N  
ATOM   4647  CA  ALA C 111     -16.805 101.604  17.175  1.00 27.60           C  
ATOM   4648  C   ALA C 111     -16.810 101.556  15.658  1.00 27.99           C  
ATOM   4649  O   ALA C 111     -15.911 100.962  15.064  1.00 28.42           O  
ATOM   4650  CB  ALA C 111     -15.508 102.223  17.668  1.00 25.90           C  
ATOM   4651  N   MET C 112     -17.802 102.174  15.024  1.00 28.40           N  
ATOM   4652  CA  MET C 112     -17.804 102.319  13.558  1.00 28.83           C  
ATOM   4653  C   MET C 112     -17.350 103.735  13.214  1.00 29.18           C  
ATOM   4654  O   MET C 112     -18.180 104.669  13.129  1.00 28.35           O  
ATOM   4655  CB  MET C 112     -19.186 101.994  12.938  1.00 28.21           C  
ATOM   4656  CG  MET C 112     -19.288 102.092  11.382  1.00 29.20           C  
ATOM   4657  SD  MET C 112     -20.959 101.650  10.815  1.00 29.20           S  
ATOM   4658  CE  MET C 112     -21.921 103.145  11.178  1.00 27.81           C  
ATOM   4659  N   VAL C 113     -16.034 103.871  13.037  1.00 28.98           N  
ATOM   4660  CA  VAL C 113     -15.398 105.171  12.861  1.00 28.47           C  
ATOM   4661  C   VAL C 113     -15.547 105.620  11.427  1.00 29.05           C  
ATOM   4662  O   VAL C 113     -14.758 105.234  10.537  1.00 29.01           O  
ATOM   4663  CB  VAL C 113     -13.925 105.182  13.246  1.00 29.31           C  
ATOM   4664  CG1 VAL C 113     -13.430 106.642  13.290  1.00 28.64           C  
ATOM   4665  CG2 VAL C 113     -13.712 104.492  14.624  1.00 25.47           C  
ATOM   4666  N   ASN C 114     -16.568 106.438  11.216  1.00 27.84           N  
ATOM   4667  CA  ASN C 114     -16.938 106.896   9.883  1.00 28.54           C  
ATOM   4668  C   ASN C 114     -16.108 108.054   9.331  1.00 29.11           C  
ATOM   4669  O   ASN C 114     -16.226 108.391   8.145  1.00 28.82           O  
ATOM   4670  CB  ASN C 114     -18.413 107.273   9.872  1.00 28.15           C  
ATOM   4671  CG  ASN C 114     -18.755 108.247  10.956  1.00 27.53           C  
ATOM   4672  OD1 ASN C 114     -18.730 107.911  12.173  1.00 26.95           O  
ATOM   4673  ND2 ASN C 114     -19.060 109.466  10.550  1.00 26.24           N  
ATOM   4674  N   GLY C 115     -15.254 108.638  10.171  1.00 29.36           N  
ATOM   4675  CA  GLY C 115     -14.546 109.867   9.813  1.00 29.28           C  
ATOM   4676  C   GLY C 115     -13.742 110.394  10.977  1.00 29.46           C  
ATOM   4677  O   GLY C 115     -13.256 109.611  11.779  1.00 29.33           O  
ATOM   4678  N   TRP C 116     -13.599 111.718  11.064  1.00 29.97           N  
ATOM   4679  CA  TRP C 116     -12.718 112.368  12.059  1.00 31.05           C  
ATOM   4680  C   TRP C 116     -12.703 111.730  13.460  1.00 30.60           C  
ATOM   4681  O   TRP C 116     -13.748 111.566  14.105  1.00 30.76           O  
ATOM   4682  CB  TRP C 116     -13.078 113.851  12.192  1.00 32.60           C  
ATOM   4683  CG  TRP C 116     -13.121 114.623  10.851  1.00 33.72           C  
ATOM   4684  CD1 TRP C 116     -14.234 115.071  10.191  1.00 35.54           C  
ATOM   4685  CD2 TRP C 116     -11.995 115.052  10.074  1.00 34.79           C  
ATOM   4686  NE1 TRP C 116     -13.869 115.734   9.030  1.00 34.78           N  
ATOM   4687  CE2 TRP C 116     -12.502 115.746   8.941  1.00 35.69           C  
ATOM   4688  CE3 TRP C 116     -10.602 114.903  10.216  1.00 35.75           C  
ATOM   4689  CZ2 TRP C 116     -11.661 116.298   7.958  1.00 36.72           C  
ATOM   4690  CZ3 TRP C 116      -9.766 115.443   9.248  1.00 36.06           C  
ATOM   4691  CH2 TRP C 116     -10.295 116.130   8.129  1.00 35.82           C  
ATOM   4692  N   CYS C 117     -11.511 111.395  13.928  1.00 29.96           N  
ATOM   4693  CA  CYS C 117     -11.336 110.887  15.293  1.00 29.74           C  
ATOM   4694  C   CYS C 117     -10.096 111.521  15.911  1.00 29.19           C  
ATOM   4695  O   CYS C 117      -8.972 111.106  15.653  1.00 29.49           O  
ATOM   4696  CB  CYS C 117     -11.274 109.339  15.314  1.00 28.89           C  
ATOM   4697  SG  CYS C 117     -11.072 108.605  16.950  1.00 29.90           S  
ATOM   4698  N   PHE C 118     -10.305 112.538  16.727  1.00 29.23           N  
ATOM   4699  CA  PHE C 118      -9.187 113.203  17.377  1.00 30.27           C  
ATOM   4700  C   PHE C 118      -9.275 113.162  18.900  1.00 29.59           C  
ATOM   4701  O   PHE C 118     -10.363 113.024  19.498  1.00 29.25           O  
ATOM   4702  CB  PHE C 118      -9.053 114.664  16.898  1.00 31.66           C  
ATOM   4703  CG  PHE C 118      -8.659 114.815  15.452  1.00 34.74           C  
ATOM   4704  CD1 PHE C 118      -9.632 114.920  14.453  1.00 39.41           C  
ATOM   4705  CD2 PHE C 118      -7.331 114.932  15.092  1.00 36.57           C  
ATOM   4706  CE1 PHE C 118      -9.278 115.085  13.101  1.00 40.67           C  
ATOM   4707  CE2 PHE C 118      -6.954 115.096  13.765  1.00 37.47           C  
ATOM   4708  CZ  PHE C 118      -7.928 115.165  12.752  1.00 38.06           C  
ATOM   4709  N   GLY C 119      -8.103 113.260  19.518  1.00 29.78           N  
ATOM   4710  CA  GLY C 119      -7.949 113.509  20.951  1.00 29.45           C  
ATOM   4711  C   GLY C 119      -8.718 112.566  21.844  1.00 29.85           C  
ATOM   4712  O   GLY C 119      -8.562 111.335  21.793  1.00 30.74           O  
ATOM   4713  N   GLY C 120      -9.589 113.158  22.638  1.00 28.67           N  
ATOM   4714  CA  GLY C 120     -10.321 112.435  23.652  1.00 26.15           C  
ATOM   4715  C   GLY C 120     -11.192 111.368  23.053  1.00 26.03           C  
ATOM   4716  O   GLY C 120     -11.576 110.432  23.743  1.00 25.01           O  
ATOM   4717  N   GLY C 121     -11.489 111.495  21.757  1.00 24.40           N  
ATOM   4718  CA  GLY C 121     -12.187 110.442  21.030  1.00 24.60           C  
ATOM   4719  C   GLY C 121     -11.504 109.067  21.171  1.00 24.78           C  
ATOM   4720  O   GLY C 121     -12.163 108.032  21.038  1.00 24.42           O  
ATOM   4721  N   PHE C 122     -10.199 109.055  21.431  1.00 23.58           N  
ATOM   4722  CA  PHE C 122      -9.447 107.763  21.484  1.00 24.63           C  
ATOM   4723  C   PHE C 122      -9.874 106.903  22.655  1.00 24.33           C  
ATOM   4724  O   PHE C 122      -9.733 105.684  22.590  1.00 24.59           O  
ATOM   4725  CB  PHE C 122      -7.923 107.980  21.534  1.00 24.49           C  
ATOM   4726  CG  PHE C 122      -7.299 108.304  20.201  1.00 27.39           C  
ATOM   4727  CD1 PHE C 122      -6.262 107.516  19.699  1.00 26.08           C  
ATOM   4728  CD2 PHE C 122      -7.724 109.410  19.448  1.00 28.40           C  
ATOM   4729  CE1 PHE C 122      -5.682 107.800  18.467  1.00 26.44           C  
ATOM   4730  CE2 PHE C 122      -7.120 109.718  18.225  1.00 29.08           C  
ATOM   4731  CZ  PHE C 122      -6.100 108.908  17.731  1.00 26.77           C  
ATOM   4732  N   ALA C 123     -10.401 107.522  23.715  1.00 24.92           N  
ATOM   4733  CA  ALA C 123     -10.775 106.747  24.916  1.00 24.28           C  
ATOM   4734  C   ALA C 123     -12.046 105.896  24.662  1.00 24.36           C  
ATOM   4735  O   ALA C 123     -11.999 104.662  24.819  1.00 24.26           O  
ATOM   4736  CB  ALA C 123     -10.943 107.658  26.153  1.00 25.66           C  
ATOM   4737  N   PRO C 124     -13.161 106.517  24.212  1.00 25.48           N  
ATOM   4738  CA  PRO C 124     -14.295 105.637  23.892  1.00 25.49           C  
ATOM   4739  C   PRO C 124     -14.002 104.675  22.749  1.00 25.86           C  
ATOM   4740  O   PRO C 124     -14.488 103.549  22.785  1.00 26.56           O  
ATOM   4741  CB  PRO C 124     -15.443 106.617  23.558  1.00 25.00           C  
ATOM   4742  CG  PRO C 124     -14.781 107.866  23.233  1.00 26.30           C  
ATOM   4743  CD  PRO C 124     -13.506 107.937  23.977  1.00 23.85           C  
ATOM   4744  N   LEU C 125     -13.211 105.106  21.766  1.00 26.30           N  
ATOM   4745  CA  LEU C 125     -12.699 104.248  20.694  1.00 25.70           C  
ATOM   4746  C   LEU C 125     -12.129 102.917  21.180  1.00 25.89           C  
ATOM   4747  O   LEU C 125     -12.473 101.839  20.647  1.00 26.33           O  
ATOM   4748  CB  LEU C 125     -11.604 104.968  19.883  1.00 25.65           C  
ATOM   4749  CG  LEU C 125     -10.965 104.191  18.700  1.00 26.68           C  
ATOM   4750  CD1 LEU C 125     -12.034 103.646  17.720  1.00 25.73           C  
ATOM   4751  CD2 LEU C 125      -9.929 105.014  17.925  1.00 23.36           C  
ATOM   4752  N   VAL C 126     -11.280 102.998  22.195  1.00 25.12           N  
ATOM   4753  CA  VAL C 126     -10.575 101.822  22.671  1.00 24.31           C  
ATOM   4754  C   VAL C 126     -11.410 101.102  23.737  1.00 25.04           C  
ATOM   4755  O   VAL C 126     -11.325  99.884  23.908  1.00 24.98           O  
ATOM   4756  CB  VAL C 126      -9.113 102.183  23.049  1.00 24.56           C  
ATOM   4757  CG1 VAL C 126      -8.399 101.018  23.745  1.00 22.95           C  
ATOM   4758  CG2 VAL C 126      -8.348 102.614  21.784  1.00 25.33           C  
ATOM   4759  N   ALA C 127     -12.252 101.868  24.434  1.00 24.11           N  
ATOM   4760  CA  ALA C 127     -13.276 101.303  25.292  1.00 24.22           C  
ATOM   4761  C   ALA C 127     -14.189 100.359  24.512  1.00 24.38           C  
ATOM   4762  O   ALA C 127     -14.533  99.291  25.022  1.00 23.48           O  
ATOM   4763  CB  ALA C 127     -14.124 102.422  25.919  1.00 24.10           C  
ATOM   4764  N   CYS C 128     -14.648 100.785  23.326  1.00 22.47           N  
ATOM   4765  CA  CYS C 128     -15.398  99.900  22.446  1.00 23.87           C  
ATOM   4766  C   CYS C 128     -14.595  98.618  22.162  1.00 23.97           C  
ATOM   4767  O   CYS C 128     -13.398  98.676  21.864  1.00 21.72           O  
ATOM   4768  CB  CYS C 128     -15.735 100.606  21.134  1.00 24.10           C  
ATOM   4769  SG  CYS C 128     -17.062 101.810  21.375  1.00 25.93           S  
ATOM   4770  N   ASP C 129     -15.272  97.469  22.222  1.00 23.83           N  
ATOM   4771  CA  ASP C 129     -14.564  96.209  22.213  1.00 24.63           C  
ATOM   4772  C   ASP C 129     -13.777  96.075  20.916  1.00 24.96           C  
ATOM   4773  O   ASP C 129     -12.550  95.883  20.935  1.00 24.45           O  
ATOM   4774  CB  ASP C 129     -15.528  95.023  22.411  1.00 25.61           C  
ATOM   4775  CG  ASP C 129     -16.211  95.042  23.764  1.00 24.41           C  
ATOM   4776  OD1 ASP C 129     -15.566  95.326  24.806  1.00 26.73           O  
ATOM   4777  OD2 ASP C 129     -17.412  94.713  23.792  1.00 28.09           O  
ATOM   4778  N   LEU C 130     -14.492  96.227  19.799  1.00 23.84           N  
ATOM   4779  CA  LEU C 130     -13.917  96.141  18.435  1.00 24.97           C  
ATOM   4780  C   LEU C 130     -14.137  97.443  17.677  1.00 24.24           C  
ATOM   4781  O   LEU C 130     -14.941  98.289  18.087  1.00 22.98           O  
ATOM   4782  CB  LEU C 130     -14.540  94.981  17.655  1.00 25.20           C  
ATOM   4783  CG  LEU C 130     -14.461  93.654  18.408  1.00 25.62           C  
ATOM   4784  CD1 LEU C 130     -15.468  92.630  17.898  1.00 28.97           C  
ATOM   4785  CD2 LEU C 130     -13.045  93.112  18.347  1.00 28.49           C  
ATOM   4786  N   ALA C 131     -13.411  97.631  16.587  1.00 25.17           N  
ATOM   4787  CA  ALA C 131     -13.592  98.884  15.811  1.00 25.78           C  
ATOM   4788  C   ALA C 131     -13.246  98.687  14.336  1.00 26.29           C  
ATOM   4789  O   ALA C 131     -12.192  98.103  14.027  1.00 25.86           O  
ATOM   4790  CB  ALA C 131     -12.730  99.988  16.431  1.00 25.71           C  
ATOM   4791  N   ILE C 132     -14.157  99.138  13.457  1.00 25.30           N  
ATOM   4792  CA  ILE C 132     -13.965  99.180  12.003  1.00 26.96           C  
ATOM   4793  C   ILE C 132     -14.030 100.651  11.616  1.00 27.64           C  
ATOM   4794  O   ILE C 132     -14.990 101.383  12.002  1.00 26.37           O  
ATOM   4795  CB  ILE C 132     -15.139  98.485  11.202  1.00 26.64           C  
ATOM   4796  CG1 ILE C 132     -15.578  97.134  11.803  1.00 28.33           C  
ATOM   4797  CG2 ILE C 132     -14.756  98.287   9.727  1.00 26.85           C  
ATOM   4798  CD1 ILE C 132     -14.443  96.074  11.880  1.00 30.22           C  
ATOM   4799  N   CYS C 133     -13.029 101.101  10.864  1.00 28.16           N  
ATOM   4800  CA  CYS C 133     -13.034 102.488  10.387  1.00 28.95           C  
ATOM   4801  C   CYS C 133     -13.117 102.551   8.874  1.00 29.89           C  
ATOM   4802  O   CYS C 133     -12.879 101.555   8.188  1.00 29.03           O  
ATOM   4803  CB  CYS C 133     -11.809 103.257  10.876  1.00 28.55           C  
ATOM   4804  SG  CYS C 133     -10.251 102.628  10.260  1.00 27.67           S  
ATOM   4805  N   ALA C 134     -13.457 103.742   8.372  1.00 30.37           N  
ATOM   4806  CA  ALA C 134     -13.426 104.049   6.946  1.00 31.59           C  
ATOM   4807  C   ALA C 134     -11.969 104.299   6.590  1.00 31.47           C  
ATOM   4808  O   ALA C 134     -11.233 104.861   7.397  1.00 31.99           O  
ATOM   4809  CB  ALA C 134     -14.247 105.269   6.670  1.00 31.05           C  
ATOM   4810  N   ASP C 135     -11.549 103.821   5.421  1.00 31.49           N  
ATOM   4811  CA  ASP C 135     -10.213 104.108   4.886  1.00 31.36           C  
ATOM   4812  C   ASP C 135      -9.978 105.617   4.924  1.00 31.01           C  
ATOM   4813  O   ASP C 135      -8.873 106.083   5.188  1.00 29.61           O  
ATOM   4814  CB  ASP C 135     -10.122 103.658   3.432  1.00 31.28           C  
ATOM   4815  CG  ASP C 135     -10.098 102.153   3.269  1.00 33.20           C  
ATOM   4816  OD1 ASP C 135      -9.668 101.439   4.203  1.00 31.60           O  
ATOM   4817  OD2 ASP C 135     -10.498 101.683   2.160  1.00 30.06           O  
ATOM   4818  N   GLU C 136     -11.048 106.359   4.627  1.00 31.07           N  
ATOM   4819  CA  GLU C 136     -11.019 107.810   4.508  1.00 32.02           C  
ATOM   4820  C   GLU C 136     -10.977 108.546   5.868  1.00 32.31           C  
ATOM   4821  O   GLU C 136     -10.837 109.780   5.928  1.00 32.97           O  
ATOM   4822  CB  GLU C 136     -12.216 108.264   3.660  1.00 31.89           C  
ATOM   4823  CG  GLU C 136     -12.203 107.696   2.223  1.00 32.01           C  
ATOM   4824  CD  GLU C 136     -13.067 106.451   2.011  1.00 31.78           C  
ATOM   4825  OE1 GLU C 136     -13.133 105.545   2.867  1.00 33.05           O  
ATOM   4826  OE2 GLU C 136     -13.696 106.385   0.935  1.00 35.19           O  
ATOM   4827  N   ALA C 137     -11.118 107.806   6.959  1.00 32.37           N  
ATOM   4828  CA  ALA C 137     -11.111 108.444   8.284  1.00 32.49           C  
ATOM   4829  C   ALA C 137      -9.709 108.983   8.575  1.00 32.90           C  
ATOM   4830  O   ALA C 137      -8.707 108.374   8.147  1.00 33.35           O  
ATOM   4831  CB  ALA C 137     -11.543 107.450   9.376  1.00 32.28           C  
ATOM   4832  N   THR C 138      -9.639 110.117   9.282  1.00 32.03           N  
ATOM   4833  CA  THR C 138      -8.360 110.684   9.745  1.00 31.27           C  
ATOM   4834  C   THR C 138      -8.349 110.758  11.270  1.00 30.77           C  
ATOM   4835  O   THR C 138      -9.304 111.244  11.888  1.00 31.40           O  
ATOM   4836  CB  THR C 138      -8.036 112.078   9.061  1.00 31.51           C  
ATOM   4837  OG1 THR C 138      -7.728 111.867   7.677  1.00 30.76           O  
ATOM   4838  CG2 THR C 138      -6.818 112.771   9.712  1.00 30.85           C  
ATOM   4839  N   PHE C 139      -7.283 110.245  11.869  1.00 29.79           N  
ATOM   4840  CA  PHE C 139      -7.137 110.208  13.327  1.00 29.61           C  
ATOM   4841  C   PHE C 139      -6.005 111.138  13.714  1.00 29.50           C  
ATOM   4842  O   PHE C 139      -5.079 111.345  12.931  1.00 29.50           O  
ATOM   4843  CB  PHE C 139      -6.737 108.790  13.806  1.00 28.20           C  
ATOM   4844  CG  PHE C 139      -7.725 107.705  13.444  1.00 28.29           C  
ATOM   4845  CD1 PHE C 139      -7.813 107.206  12.130  1.00 27.82           C  
ATOM   4846  CD2 PHE C 139      -8.558 107.171  14.419  1.00 27.39           C  
ATOM   4847  CE1 PHE C 139      -8.737 106.196  11.802  1.00 27.74           C  
ATOM   4848  CE2 PHE C 139      -9.471 106.151  14.109  1.00 28.17           C  
ATOM   4849  CZ  PHE C 139      -9.576 105.671  12.822  1.00 26.43           C  
ATOM   4850  N   GLY C 140      -6.028 111.644  14.936  1.00 29.52           N  
ATOM   4851  CA  GLY C 140      -4.870 112.372  15.428  1.00 30.31           C  
ATOM   4852  C   GLY C 140      -4.922 112.665  16.902  1.00 30.99           C  
ATOM   4853  O   GLY C 140      -6.001 112.813  17.498  1.00 31.33           O  
ATOM   4854  N   LEU C 141      -3.739 112.734  17.488  1.00 31.98           N  
ATOM   4855  CA  LEU C 141      -3.587 113.074  18.904  1.00 32.81           C  
ATOM   4856  C   LEU C 141      -3.043 114.502  18.893  1.00 32.46           C  
ATOM   4857  O   LEU C 141      -1.863 114.761  19.126  1.00 31.46           O  
ATOM   4858  CB  LEU C 141      -2.648 112.085  19.601  1.00 33.03           C  
ATOM   4859  CG  LEU C 141      -3.218 110.684  19.823  1.00 35.12           C  
ATOM   4860  CD1 LEU C 141      -2.280 109.883  20.665  1.00 36.01           C  
ATOM   4861  CD2 LEU C 141      -4.579 110.765  20.527  1.00 36.41           C  
ATOM   4862  N   SER C 142      -3.941 115.417  18.549  1.00 32.80           N  
ATOM   4863  CA  SER C 142      -3.635 116.833  18.387  1.00 33.01           C  
ATOM   4864  C   SER C 142      -3.317 117.538  19.724  1.00 32.64           C  
ATOM   4865  O   SER C 142      -2.705 118.613  19.731  1.00 32.67           O  
ATOM   4866  CB  SER C 142      -4.835 117.511  17.710  1.00 32.87           C  
ATOM   4867  OG  SER C 142      -6.029 117.030  18.327  1.00 33.00           O  
ATOM   4868  N   GLU C 143      -3.674 116.910  20.849  1.00 32.71           N  
ATOM   4869  CA  GLU C 143      -3.433 117.482  22.179  1.00 32.41           C  
ATOM   4870  C   GLU C 143      -2.140 118.285  22.255  1.00 31.79           C  
ATOM   4871  O   GLU C 143      -2.163 119.446  22.655  1.00 32.15           O  
ATOM   4872  CB  GLU C 143      -3.443 116.380  23.251  1.00 31.96           C  
ATOM   4873  CG  GLU C 143      -4.846 115.961  23.627  1.00 34.04           C  
ATOM   4874  CD  GLU C 143      -5.316 114.702  22.911  1.00 36.99           C  
ATOM   4875  OE1 GLU C 143      -4.779 114.390  21.826  1.00 34.53           O  
ATOM   4876  OE2 GLU C 143      -6.238 114.018  23.447  1.00 40.40           O  
ATOM   4877  N   ILE C 144      -1.026 117.666  21.858  1.00 31.76           N  
ATOM   4878  CA  ILE C 144       0.311 118.277  21.974  1.00 31.54           C  
ATOM   4879  C   ILE C 144       0.405 119.653  21.265  1.00 32.44           C  
ATOM   4880  O   ILE C 144       1.029 120.579  21.785  1.00 32.69           O  
ATOM   4881  CB  ILE C 144       1.452 117.310  21.475  1.00 31.47           C  
ATOM   4882  CG1 ILE C 144       2.843 117.934  21.643  1.00 31.37           C  
ATOM   4883  CG2 ILE C 144       1.247 116.921  20.026  1.00 29.56           C  
ATOM   4884  CD1 ILE C 144       3.356 117.965  23.080  1.00 29.70           C  
ATOM   4885  N   ASN C 145      -0.223 119.772  20.099  1.00 32.78           N  
ATOM   4886  CA  ASN C 145      -0.174 121.017  19.320  1.00 34.07           C  
ATOM   4887  C   ASN C 145      -1.100 122.059  19.944  1.00 34.61           C  
ATOM   4888  O   ASN C 145      -0.973 123.267  19.677  1.00 34.69           O  
ATOM   4889  CB  ASN C 145      -0.529 120.761  17.848  1.00 34.15           C  
ATOM   4890  CG  ASN C 145       0.466 119.828  17.150  1.00 34.87           C  
ATOM   4891  OD1 ASN C 145       1.677 119.903  17.373  1.00 35.44           O  
ATOM   4892  ND2 ASN C 145      -0.045 118.955  16.284  1.00 36.25           N  
ATOM   4893  N   TRP C 146      -2.014 121.591  20.795  1.00 34.60           N  
ATOM   4894  CA  TRP C 146      -2.877 122.512  21.533  1.00 35.15           C  
ATOM   4895  C   TRP C 146      -2.283 122.901  22.907  1.00 35.27           C  
ATOM   4896  O   TRP C 146      -2.844 123.749  23.612  1.00 35.84           O  
ATOM   4897  CB  TRP C 146      -4.323 121.974  21.636  1.00 34.75           C  
ATOM   4898  CG  TRP C 146      -5.031 121.925  20.303  0.50 34.73           C  
ATOM   4899  CD1 TRP C 146      -5.616 120.840  19.730  0.50 34.37           C  
ATOM   4900  CD2 TRP C 146      -5.202 123.009  19.375  0.50 34.96           C  
ATOM   4901  NE1 TRP C 146      -6.148 121.174  18.507  0.50 35.06           N  
ATOM   4902  CE2 TRP C 146      -5.905 122.499  18.263  0.50 35.23           C  
ATOM   4903  CE3 TRP C 146      -4.831 124.365  19.378  0.50 35.46           C  
ATOM   4904  CZ2 TRP C 146      -6.255 123.298  17.160  0.50 35.54           C  
ATOM   4905  CZ3 TRP C 146      -5.172 125.159  18.274  0.50 35.33           C  
ATOM   4906  CH2 TRP C 146      -5.877 124.619  17.184  0.50 34.78           C  
ATOM   4907  N   GLY C 147      -1.149 122.295  23.268  1.00 35.14           N  
ATOM   4908  CA  GLY C 147      -0.428 122.639  24.505  1.00 34.03           C  
ATOM   4909  C   GLY C 147      -0.818 121.883  25.772  1.00 33.81           C  
ATOM   4910  O   GLY C 147      -0.578 122.361  26.892  1.00 33.90           O  
ATOM   4911  N   ILE C 148      -1.457 120.727  25.609  1.00 32.91           N  
ATOM   4912  CA  ILE C 148      -1.751 119.850  26.742  1.00 32.14           C  
ATOM   4913  C   ILE C 148      -1.310 118.433  26.379  1.00 31.31           C  
ATOM   4914  O   ILE C 148      -1.353 118.062  25.209  1.00 31.74           O  
ATOM   4915  CB  ILE C 148      -3.251 119.870  27.177  1.00 32.55           C  
ATOM   4916  CG1 ILE C 148      -4.192 119.501  26.017  1.00 34.40           C  
ATOM   4917  CG2 ILE C 148      -3.616 121.217  27.879  1.00 31.88           C  
ATOM   4918  CD1 ILE C 148      -5.430 118.730  26.487  1.00 39.33           C  
ATOM   4919  N   PRO C 149      -0.858 117.652  27.374  1.00 30.82           N  
ATOM   4920  CA  PRO C 149      -0.630 116.249  27.146  1.00 30.12           C  
ATOM   4921  C   PRO C 149      -2.020 115.613  26.941  1.00 30.02           C  
ATOM   4922  O   PRO C 149      -3.037 116.269  27.233  1.00 29.52           O  
ATOM   4923  CB  PRO C 149      -0.003 115.780  28.481  1.00 30.67           C  
ATOM   4924  CG  PRO C 149      -0.545 116.756  29.499  1.00 30.14           C  
ATOM   4925  CD  PRO C 149      -0.567 118.054  28.766  1.00 30.78           C  
ATOM   4926  N   PRO C 150      -2.085 114.374  26.435  1.00 28.81           N  
ATOM   4927  CA  PRO C 150      -3.402 113.744  26.333  1.00 29.12           C  
ATOM   4928  C   PRO C 150      -4.166 113.646  27.661  1.00 29.34           C  
ATOM   4929  O   PRO C 150      -3.603 113.223  28.687  1.00 29.87           O  
ATOM   4930  CB  PRO C 150      -3.082 112.354  25.751  1.00 30.44           C  
ATOM   4931  CG  PRO C 150      -1.788 112.571  24.960  1.00 27.67           C  
ATOM   4932  CD  PRO C 150      -1.018 113.542  25.828  1.00 29.55           C  
ATOM   4933  N   GLY C 151      -5.428 114.075  27.632  1.00 29.00           N  
ATOM   4934  CA  GLY C 151      -6.285 114.142  28.833  1.00 29.20           C  
ATOM   4935  C   GLY C 151      -7.087 112.868  28.982  1.00 28.52           C  
ATOM   4936  O   GLY C 151      -7.144 112.047  28.064  1.00 28.54           O  
ATOM   4937  N   ASN C 152      -7.721 112.712  30.137  1.00 28.58           N  
ATOM   4938  CA  ASN C 152      -8.494 111.515  30.436  1.00 28.57           C  
ATOM   4939  C   ASN C 152      -7.622 110.265  30.193  1.00 27.27           C  
ATOM   4940  O   ASN C 152      -6.450 110.246  30.601  1.00 26.07           O  
ATOM   4941  CB  ASN C 152      -9.813 111.494  29.646  1.00 28.38           C  
ATOM   4942  CG  ASN C 152     -10.927 110.729  30.374  1.00 30.66           C  
ATOM   4943  OD1 ASN C 152     -11.043 109.519  30.230  1.00 34.73           O  
ATOM   4944  ND2 ASN C 152     -11.734 111.434  31.172  1.00 34.05           N  
ATOM   4945  N   LEU C 153      -8.184 109.263  29.510  1.00 26.02           N  
ATOM   4946  CA  LEU C 153      -7.555 107.939  29.369  1.00 25.26           C  
ATOM   4947  C   LEU C 153      -6.942 107.722  28.007  1.00 26.19           C  
ATOM   4948  O   LEU C 153      -6.546 106.622  27.649  1.00 26.65           O  
ATOM   4949  CB  LEU C 153      -8.587 106.881  29.665  1.00 24.53           C  
ATOM   4950  CG  LEU C 153      -8.547 106.432  31.125  1.00 22.32           C  
ATOM   4951  CD1 LEU C 153      -7.316 105.561  31.358  1.00 20.61           C  
ATOM   4952  CD2 LEU C 153      -8.596 107.621  32.134  1.00 23.49           C  
ATOM   4953  N   VAL C 154      -6.819 108.816  27.273  1.00 26.12           N  
ATOM   4954  CA  VAL C 154      -6.306 108.793  25.914  1.00 26.60           C  
ATOM   4955  C   VAL C 154      -4.994 108.024  25.797  1.00 27.92           C  
ATOM   4956  O   VAL C 154      -4.869 107.177  24.891  1.00 27.42           O  
ATOM   4957  CB  VAL C 154      -6.205 110.198  25.339  1.00 27.06           C  
ATOM   4958  CG1 VAL C 154      -5.331 110.230  24.093  1.00 26.35           C  
ATOM   4959  CG2 VAL C 154      -7.624 110.747  25.045  1.00 25.90           C  
ATOM   4960  N   SER C 155      -4.042 108.297  26.698  1.00 27.16           N  
ATOM   4961  CA  SER C 155      -2.701 107.707  26.549  1.00 27.00           C  
ATOM   4962  C   SER C 155      -2.746 106.216  26.859  1.00 26.79           C  
ATOM   4963  O   SER C 155      -1.983 105.446  26.300  1.00 26.99           O  
ATOM   4964  CB  SER C 155      -1.671 108.397  27.442  1.00 27.21           C  
ATOM   4965  OG  SER C 155      -1.337 109.681  26.940  1.00 26.27           O  
ATOM   4966  N   LYS C 156      -3.666 105.820  27.741  1.00 26.26           N  
ATOM   4967  CA  LYS C 156      -3.835 104.404  28.111  1.00 25.34           C  
ATOM   4968  C   LYS C 156      -4.522 103.672  26.948  1.00 25.12           C  
ATOM   4969  O   LYS C 156      -4.187 102.529  26.647  1.00 24.77           O  
ATOM   4970  CB  LYS C 156      -4.613 104.303  29.434  1.00 25.12           C  
ATOM   4971  CG  LYS C 156      -4.731 102.927  30.042  1.00 23.96           C  
ATOM   4972  CD  LYS C 156      -3.392 102.147  30.066  1.00 20.36           C  
ATOM   4973  CE  LYS C 156      -3.572 100.728  30.638  1.00 20.32           C  
ATOM   4974  NZ  LYS C 156      -2.271 100.108  30.947  1.00 22.34           N  
ATOM   4975  N   ALA C 157      -5.437 104.364  26.264  1.00 24.16           N  
ATOM   4976  CA  ALA C 157      -6.151 103.824  25.126  1.00 23.92           C  
ATOM   4977  C   ALA C 157      -5.088 103.459  24.056  1.00 24.49           C  
ATOM   4978  O   ALA C 157      -5.131 102.375  23.517  1.00 25.08           O  
ATOM   4979  CB  ALA C 157      -7.250 104.816  24.600  1.00 22.11           C  
ATOM   4980  N   MET C 158      -4.094 104.323  23.849  1.00 25.07           N  
ATOM   4981  CA  MET C 158      -3.015 104.047  22.899  1.00 25.29           C  
ATOM   4982  C   MET C 158      -2.166 102.881  23.401  1.00 25.85           C  
ATOM   4983  O   MET C 158      -1.861 101.927  22.650  1.00 26.14           O  
ATOM   4984  CB  MET C 158      -2.134 105.289  22.706  1.00 24.90           C  
ATOM   4985  CG  MET C 158      -2.805 106.404  21.855  1.00 29.12           C  
ATOM   4986  SD  MET C 158      -3.086 105.878  20.142  1.00 30.86           S  
ATOM   4987  CE  MET C 158      -1.438 106.009  19.400  1.00 28.59           C  
ATOM   4988  N   ALA C 159      -1.787 102.959  24.672  1.00 25.81           N  
ATOM   4989  CA  ALA C 159      -0.952 101.922  25.273  1.00 24.70           C  
ATOM   4990  C   ALA C 159      -1.537 100.534  25.013  1.00 24.69           C  
ATOM   4991  O   ALA C 159      -0.796  99.584  24.758  1.00 23.88           O  
ATOM   4992  CB  ALA C 159      -0.755 102.180  26.754  1.00 25.31           C  
ATOM   4993  N   ASP C 160      -2.865 100.421  25.104  1.00 25.63           N  
ATOM   4994  CA  ASP C 160      -3.559  99.136  25.049  1.00 26.10           C  
ATOM   4995  C   ASP C 160      -3.528  98.545  23.628  1.00 26.49           C  
ATOM   4996  O   ASP C 160      -3.600  97.327  23.444  1.00 28.04           O  
ATOM   4997  CB  ASP C 160      -5.028  99.289  25.515  1.00 24.83           C  
ATOM   4998  CG  ASP C 160      -5.215  99.124  27.070  1.00 24.57           C  
ATOM   4999  OD1 ASP C 160      -4.236  98.860  27.827  1.00 24.00           O  
ATOM   5000  OD2 ASP C 160      -6.383  99.221  27.526  1.00 25.22           O  
ATOM   5001  N   THR C 161      -3.430  99.400  22.626  1.00 26.37           N  
ATOM   5002  CA  THR C 161      -3.736  98.985  21.250  1.00 26.11           C  
ATOM   5003  C   THR C 161      -2.619  99.233  20.251  1.00 26.90           C  
ATOM   5004  O   THR C 161      -2.605  98.615  19.152  1.00 26.64           O  
ATOM   5005  CB  THR C 161      -5.010  99.714  20.660  1.00 25.36           C  
ATOM   5006  OG1 THR C 161      -4.884 101.146  20.764  1.00 24.86           O  
ATOM   5007  CG2 THR C 161      -6.307  99.264  21.337  1.00 23.07           C  
ATOM   5008  N   VAL C 162      -1.725 100.165  20.586  1.00 26.21           N  
ATOM   5009  CA  VAL C 162      -0.713 100.619  19.636  1.00 25.58           C  
ATOM   5010  C   VAL C 162       0.688 100.483  20.264  1.00 25.05           C  
ATOM   5011  O   VAL C 162       0.893 100.863  21.430  1.00 25.13           O  
ATOM   5012  CB  VAL C 162      -0.972 102.074  19.201  1.00 26.27           C  
ATOM   5013  CG1 VAL C 162       0.181 102.569  18.390  1.00 25.12           C  
ATOM   5014  CG2 VAL C 162      -2.290 102.192  18.417  1.00 24.37           C  
ATOM   5015  N   GLY C 163       1.631  99.942  19.483  1.00 24.14           N  
ATOM   5016  CA  GLY C 163       2.999  99.691  19.946  1.00 24.94           C  
ATOM   5017  C   GLY C 163       3.600 100.902  20.606  1.00 24.94           C  
ATOM   5018  O   GLY C 163       3.224 102.034  20.288  1.00 24.80           O  
ATOM   5019  N   HIS C 164       4.572 100.658  21.482  1.00 24.92           N  
ATOM   5020  CA  HIS C 164       5.258 101.678  22.266  1.00 25.72           C  
ATOM   5021  C   HIS C 164       5.814 102.815  21.375  1.00 26.43           C  
ATOM   5022  O   HIS C 164       5.507 104.012  21.582  1.00 26.36           O  
ATOM   5023  CB  HIS C 164       6.364 100.974  23.036  1.00 23.99           C  
ATOM   5024  CG  HIS C 164       7.236 101.861  23.867  1.00 23.91           C  
ATOM   5025  ND1 HIS C 164       7.010 102.088  25.206  1.00 21.25           N  
ATOM   5026  CD2 HIS C 164       8.365 102.539  23.558  1.00 22.27           C  
ATOM   5027  CE1 HIS C 164       7.968 102.859  25.693  1.00 25.13           C  
ATOM   5028  NE2 HIS C 164       8.796 103.160  24.709  1.00 28.61           N  
ATOM   5029  N   ARG C 165       6.619 102.434  20.384  1.00 26.68           N  
ATOM   5030  CA  ARG C 165       7.273 103.414  19.520  1.00 26.59           C  
ATOM   5031  C   ARG C 165       6.294 104.269  18.744  1.00 27.48           C  
ATOM   5032  O   ARG C 165       6.438 105.508  18.717  1.00 27.54           O  
ATOM   5033  CB  ARG C 165       8.216 102.739  18.523  1.00 26.63           C  
ATOM   5034  CG  ARG C 165       9.431 102.123  19.148  1.00 25.85           C  
ATOM   5035  CD  ARG C 165      10.390 103.133  19.778  1.00 27.18           C  
ATOM   5036  NE  ARG C 165      11.710 102.541  19.963  1.00 28.27           N  
ATOM   5037  CZ  ARG C 165      12.721 103.089  20.629  1.00 28.22           C  
ATOM   5038  NH1 ARG C 165      12.584 104.287  21.208  1.00 28.22           N  
ATOM   5039  NH2 ARG C 165      13.877 102.437  20.726  1.00 25.39           N  
ATOM   5040  N   GLN C 166       5.311 103.621  18.119  1.00 26.68           N  
ATOM   5041  CA  GLN C 166       4.292 104.334  17.334  1.00 27.39           C  
ATOM   5042  C   GLN C 166       3.388 105.202  18.232  1.00 26.40           C  
ATOM   5043  O   GLN C 166       3.009 106.321  17.857  1.00 25.43           O  
ATOM   5044  CB  GLN C 166       3.456 103.343  16.532  1.00 27.14           C  
ATOM   5045  CG  GLN C 166       4.129 102.758  15.273  1.00 28.72           C  
ATOM   5046  CD  GLN C 166       3.323 101.603  14.681  1.00 30.16           C  
ATOM   5047  OE1 GLN C 166       3.007 100.604  15.366  1.00 34.69           O  
ATOM   5048  NE2 GLN C 166       3.007 101.719  13.409  1.00 34.50           N  
ATOM   5049  N   SER C 167       3.073 104.707  19.435  1.00 26.02           N  
ATOM   5050  CA  SER C 167       2.283 105.472  20.394  1.00 26.09           C  
ATOM   5051  C   SER C 167       2.985 106.792  20.740  1.00 26.98           C  
ATOM   5052  O   SER C 167       2.382 107.862  20.619  1.00 27.09           O  
ATOM   5053  CB  SER C 167       2.012 104.681  21.678  1.00 25.99           C  
ATOM   5054  OG  SER C 167       0.964 103.753  21.502  1.00 24.27           O  
ATOM   5055  N   LEU C 168       4.241 106.698  21.177  1.00 26.12           N  
ATOM   5056  CA  LEU C 168       5.075 107.852  21.446  1.00 25.76           C  
ATOM   5057  C   LEU C 168       5.186 108.792  20.257  1.00 26.31           C  
ATOM   5058  O   LEU C 168       5.015 110.011  20.386  1.00 26.62           O  
ATOM   5059  CB  LEU C 168       6.448 107.390  21.914  1.00 25.82           C  
ATOM   5060  CG  LEU C 168       6.383 107.052  23.418  1.00 22.87           C  
ATOM   5061  CD1 LEU C 168       7.572 106.163  23.811  1.00 23.73           C  
ATOM   5062  CD2 LEU C 168       6.309 108.304  24.340  1.00 25.68           C  
ATOM   5063  N   TYR C 169       5.458 108.234  19.091  1.00 26.59           N  
ATOM   5064  CA  TYR C 169       5.514 109.054  17.884  1.00 26.80           C  
ATOM   5065  C   TYR C 169       4.277 109.960  17.679  1.00 27.01           C  
ATOM   5066  O   TYR C 169       4.421 111.187  17.498  1.00 26.80           O  
ATOM   5067  CB  TYR C 169       5.768 108.183  16.655  1.00 28.25           C  
ATOM   5068  CG  TYR C 169       5.922 108.985  15.365  1.00 29.87           C  
ATOM   5069  CD1 TYR C 169       4.834 109.218  14.528  1.00 30.83           C  
ATOM   5070  CD2 TYR C 169       7.162 109.528  14.998  1.00 28.98           C  
ATOM   5071  CE1 TYR C 169       4.979 109.953  13.348  1.00 31.49           C  
ATOM   5072  CE2 TYR C 169       7.309 110.275  13.813  1.00 29.88           C  
ATOM   5073  CZ  TYR C 169       6.222 110.486  13.009  1.00 30.43           C  
ATOM   5074  OH  TYR C 169       6.383 111.224  11.836  1.00 34.01           O  
ATOM   5075  N   TYR C 170       3.087 109.363  17.670  1.00 26.92           N  
ATOM   5076  CA  TYR C 170       1.851 110.090  17.429  1.00 27.29           C  
ATOM   5077  C   TYR C 170       1.429 110.991  18.582  1.00 26.91           C  
ATOM   5078  O   TYR C 170       0.874 112.046  18.344  1.00 27.15           O  
ATOM   5079  CB  TYR C 170       0.703 109.143  16.996  1.00 28.28           C  
ATOM   5080  CG  TYR C 170       0.951 108.549  15.628  1.00 28.79           C  
ATOM   5081  CD1 TYR C 170       0.959 109.360  14.470  1.00 27.76           C  
ATOM   5082  CD2 TYR C 170       1.210 107.198  15.485  1.00 27.72           C  
ATOM   5083  CE1 TYR C 170       1.229 108.827  13.243  1.00 29.20           C  
ATOM   5084  CE2 TYR C 170       1.482 106.656  14.261  1.00 29.53           C  
ATOM   5085  CZ  TYR C 170       1.493 107.474  13.138  1.00 30.89           C  
ATOM   5086  OH  TYR C 170       1.748 106.891  11.919  1.00 31.82           O  
ATOM   5087  N   ILE C 171       1.707 110.584  19.830  1.00 27.34           N  
ATOM   5088  CA  ILE C 171       1.487 111.472  20.976  1.00 26.60           C  
ATOM   5089  C   ILE C 171       2.416 112.691  20.917  1.00 27.27           C  
ATOM   5090  O   ILE C 171       1.960 113.855  21.065  1.00 27.21           O  
ATOM   5091  CB  ILE C 171       1.695 110.715  22.302  1.00 25.81           C  
ATOM   5092  CG1 ILE C 171       0.537 109.739  22.510  1.00 26.85           C  
ATOM   5093  CG2 ILE C 171       1.735 111.679  23.475  1.00 26.52           C  
ATOM   5094  CD1 ILE C 171       0.718 108.771  23.669  1.00 26.34           C  
ATOM   5095  N   MET C 172       3.701 112.428  20.650  1.00 27.46           N  
ATOM   5096  CA  MET C 172       4.743 113.457  20.706  1.00 27.57           C  
ATOM   5097  C   MET C 172       4.678 114.472  19.558  1.00 27.64           C  
ATOM   5098  O   MET C 172       4.854 115.673  19.800  1.00 27.89           O  
ATOM   5099  CB  MET C 172       6.146 112.855  20.796  1.00 27.00           C  
ATOM   5100  CG  MET C 172       6.474 112.257  22.194  1.00 28.37           C  
ATOM   5101  SD  MET C 172       8.043 111.325  22.350  1.00 30.24           S  
ATOM   5102  CE  MET C 172       9.278 112.623  22.415  1.00 26.49           C  
ATOM   5103  N   THR C 173       4.429 113.985  18.340  1.00 27.46           N  
ATOM   5104  CA  THR C 173       4.397 114.835  17.134  1.00 26.63           C  
ATOM   5105  C   THR C 173       3.006 115.405  16.841  1.00 27.27           C  
ATOM   5106  O   THR C 173       2.878 116.466  16.210  1.00 27.04           O  
ATOM   5107  CB  THR C 173       4.870 114.072  15.860  1.00 26.43           C  
ATOM   5108  OG1 THR C 173       3.923 113.056  15.511  1.00 26.62           O  
ATOM   5109  CG2 THR C 173       6.206 113.477  16.021  1.00 26.23           C  
ATOM   5110  N   GLY C 174       1.963 114.706  17.281  1.00 27.25           N  
ATOM   5111  CA  GLY C 174       0.577 115.057  16.971  1.00 27.08           C  
ATOM   5112  C   GLY C 174       0.210 114.870  15.486  1.00 27.74           C  
ATOM   5113  O   GLY C 174      -0.782 115.424  15.029  1.00 28.18           O  
ATOM   5114  N   LYS C 175       0.974 114.078  14.738  1.00 28.62           N  
ATOM   5115  CA  LYS C 175       0.675 113.876  13.306  1.00 30.22           C  
ATOM   5116  C   LYS C 175      -0.553 112.993  13.129  1.00 29.77           C  
ATOM   5117  O   LYS C 175      -0.800 112.101  13.946  1.00 30.66           O  
ATOM   5118  CB  LYS C 175       1.873 113.273  12.576  1.00 30.80           C  
ATOM   5119  CG  LYS C 175       3.131 114.104  12.771  1.00 34.07           C  
ATOM   5120  CD  LYS C 175       4.254 113.733  11.808  1.00 40.71           C  
ATOM   5121  CE  LYS C 175       5.340 114.802  11.847  1.00 42.52           C  
ATOM   5122  NZ  LYS C 175       4.845 116.027  11.165  1.00 45.09           N  
ATOM   5123  N   THR C 176      -1.315 113.264  12.070  1.00 29.52           N  
ATOM   5124  CA  THR C 176      -2.554 112.559  11.757  1.00 27.74           C  
ATOM   5125  C   THR C 176      -2.202 111.304  10.969  1.00 27.97           C  
ATOM   5126  O   THR C 176      -1.086 111.180  10.475  1.00 26.70           O  
ATOM   5127  CB  THR C 176      -3.499 113.445  10.907  1.00 29.16           C  
ATOM   5128  OG1 THR C 176      -2.791 113.896   9.755  1.00 26.02           O  
ATOM   5129  CG2 THR C 176      -3.989 114.672  11.688  1.00 25.85           C  
ATOM   5130  N   PHE C 177      -3.134 110.354  10.910  1.00 27.70           N  
ATOM   5131  CA  PHE C 177      -2.971 109.123  10.131  1.00 27.64           C  
ATOM   5132  C   PHE C 177      -4.319 108.638   9.623  1.00 27.33           C  
ATOM   5133  O   PHE C 177      -5.352 109.003  10.183  1.00 27.60           O  
ATOM   5134  CB  PHE C 177      -2.233 108.013  10.934  1.00 27.22           C  
ATOM   5135  CG  PHE C 177      -2.752 107.781  12.347  1.00 27.95           C  
ATOM   5136  CD1 PHE C 177      -2.273 108.554  13.419  1.00 26.78           C  
ATOM   5137  CD2 PHE C 177      -3.695 106.774  12.610  1.00 26.51           C  
ATOM   5138  CE1 PHE C 177      -2.715 108.328  14.751  1.00 28.55           C  
ATOM   5139  CE2 PHE C 177      -4.137 106.533  13.939  1.00 29.04           C  
ATOM   5140  CZ  PHE C 177      -3.645 107.315  14.995  1.00 28.26           C  
ATOM   5141  N   GLY C 178      -4.319 107.818   8.574  1.00 27.38           N  
ATOM   5142  CA  GLY C 178      -5.563 107.379   7.945  1.00 28.06           C  
ATOM   5143  C   GLY C 178      -6.020 106.034   8.471  1.00 28.67           C  
ATOM   5144  O   GLY C 178      -5.305 105.395   9.258  1.00 29.37           O  
ATOM   5145  N   GLY C 179      -7.210 105.603   8.049  1.00 28.84           N  
ATOM   5146  CA  GLY C 179      -7.797 104.357   8.568  1.00 29.76           C  
ATOM   5147  C   GLY C 179      -6.929 103.121   8.323  1.00 30.22           C  
ATOM   5148  O   GLY C 179      -6.810 102.263   9.185  1.00 28.53           O  
ATOM   5149  N   GLN C 180      -6.352 103.015   7.124  1.00 30.61           N  
ATOM   5150  CA  GLN C 180      -5.445 101.895   6.802  1.00 31.23           C  
ATOM   5151  C   GLN C 180      -4.285 101.831   7.786  1.00 30.58           C  
ATOM   5152  O   GLN C 180      -3.981 100.755   8.311  1.00 30.29           O  
ATOM   5153  CB  GLN C 180      -4.900 101.990   5.360  1.00 31.75           C  
ATOM   5154  CG  GLN C 180      -5.896 101.505   4.272  1.00 35.30           C  
ATOM   5155  CD  GLN C 180      -6.300 100.029   4.441  1.00 39.04           C  
ATOM   5156  OE1 GLN C 180      -5.493  99.207   4.890  1.00 39.40           O  
ATOM   5157  NE2 GLN C 180      -7.555  99.699   4.094  1.00 37.84           N  
ATOM   5158  N   LYS C 181      -3.676 102.987   8.070  1.00 30.16           N  
ATOM   5159  CA  LYS C 181      -2.551 103.044   9.013  1.00 30.01           C  
ATOM   5160  C   LYS C 181      -3.022 102.807  10.460  1.00 29.88           C  
ATOM   5161  O   LYS C 181      -2.263 102.297  11.275  1.00 29.70           O  
ATOM   5162  CB  LYS C 181      -1.778 104.352   8.887  1.00 29.31           C  
ATOM   5163  N   ALA C 182      -4.280 103.153  10.761  1.00 30.08           N  
ATOM   5164  CA  ALA C 182      -4.885 102.848  12.070  1.00 29.57           C  
ATOM   5165  C   ALA C 182      -5.088 101.335  12.245  1.00 29.39           C  
ATOM   5166  O   ALA C 182      -4.906 100.803  13.345  1.00 30.24           O  
ATOM   5167  CB  ALA C 182      -6.217 103.566  12.226  1.00 29.64           C  
ATOM   5168  N   ALA C 183      -5.492 100.659  11.167  1.00 29.53           N  
ATOM   5169  CA  ALA C 183      -5.658  99.195  11.162  1.00 29.18           C  
ATOM   5170  C   ALA C 183      -4.309  98.560  11.347  1.00 29.57           C  
ATOM   5171  O   ALA C 183      -4.130  97.638  12.160  1.00 30.34           O  
ATOM   5172  CB  ALA C 183      -6.294  98.719   9.871  1.00 28.57           C  
ATOM   5173  N   GLU C 184      -3.342  99.119  10.641  1.00 28.63           N  
ATOM   5174  CA  GLU C 184      -1.990  98.608  10.616  1.00 29.41           C  
ATOM   5175  C   GLU C 184      -1.415  98.647  12.013  1.00 28.72           C  
ATOM   5176  O   GLU C 184      -0.843  97.663  12.497  1.00 28.86           O  
ATOM   5177  CB  GLU C 184      -1.163  99.480   9.655  1.00 28.89           C  
ATOM   5178  CG  GLU C 184       0.319  99.098   9.442  1.00 31.78           C  
ATOM   5179  CD  GLU C 184       1.049 100.148   8.598  0.50 31.06           C  
ATOM   5180  OE1 GLU C 184       0.399 100.776   7.722  0.50 31.49           O  
ATOM   5181  OE2 GLU C 184       2.269 100.339   8.803  0.50 32.61           O  
ATOM   5182  N   MET C 185      -1.585  99.771  12.692  1.00 28.45           N  
ATOM   5183  CA  MET C 185      -0.902  99.942  13.984  1.00 28.84           C  
ATOM   5184  C   MET C 185      -1.613  99.231  15.148  1.00 26.88           C  
ATOM   5185  O   MET C 185      -1.079  99.141  16.261  1.00 24.21           O  
ATOM   5186  CB  MET C 185      -0.629 101.420  14.268  1.00 28.85           C  
ATOM   5187  CG  MET C 185      -1.847 102.224  14.669  1.00 31.53           C  
ATOM   5188  SD  MET C 185      -1.550 104.023  14.861  1.00 35.51           S  
ATOM   5189  CE  MET C 185      -1.117 104.516  13.208  1.00 31.46           C  
ATOM   5190  N   GLY C 186      -2.813  98.727  14.891  1.00 26.03           N  
ATOM   5191  CA  GLY C 186      -3.560  97.977  15.903  1.00 25.42           C  
ATOM   5192  C   GLY C 186      -4.615  98.831  16.606  1.00 25.42           C  
ATOM   5193  O   GLY C 186      -5.379  98.322  17.420  1.00 24.35           O  
ATOM   5194  N   LEU C 187      -4.663 100.131  16.319  1.00 25.46           N  
ATOM   5195  CA  LEU C 187      -5.731 100.960  16.881  1.00 25.54           C  
ATOM   5196  C   LEU C 187      -7.152 100.452  16.626  1.00 26.67           C  
ATOM   5197  O   LEU C 187      -8.011 100.507  17.536  1.00 27.45           O  
ATOM   5198  CB  LEU C 187      -5.596 102.426  16.499  1.00 25.80           C  
ATOM   5199  CG  LEU C 187      -6.551 103.444  17.154  1.00 25.50           C  
ATOM   5200  CD1 LEU C 187      -6.348 103.518  18.707  1.00 27.17           C  
ATOM   5201  CD2 LEU C 187      -6.327 104.818  16.487  1.00 25.04           C  
ATOM   5202  N   VAL C 188      -7.423  99.993  15.405  1.00 25.80           N  
ATOM   5203  CA  VAL C 188      -8.747  99.430  15.071  1.00 26.05           C  
ATOM   5204  C   VAL C 188      -8.575  97.998  14.549  1.00 26.13           C  
ATOM   5205  O   VAL C 188      -7.451  97.588  14.286  1.00 25.77           O  
ATOM   5206  CB  VAL C 188      -9.525 100.307  14.033  1.00 26.72           C  
ATOM   5207  CG1 VAL C 188      -9.873 101.703  14.638  1.00 24.12           C  
ATOM   5208  CG2 VAL C 188      -8.742 100.442  12.727  1.00 27.27           C  
ATOM   5209  N   ASN C 189      -9.661  97.234  14.444  1.00 25.89           N  
ATOM   5210  CA  ASN C 189      -9.600  95.907  13.823  1.00 26.77           C  
ATOM   5211  C   ASN C 189      -9.372  95.934  12.323  1.00 27.09           C  
ATOM   5212  O   ASN C 189      -8.557  95.186  11.802  1.00 25.84           O  
ATOM   5213  CB  ASN C 189     -10.864  95.078  14.100  1.00 27.11           C  
ATOM   5214  CG  ASN C 189     -10.990  94.703  15.527  1.00 25.68           C  
ATOM   5215  OD1 ASN C 189     -11.524  95.478  16.335  1.00 24.97           O  
ATOM   5216  ND2 ASN C 189     -10.445  93.513  15.885  1.00 23.00           N  
ATOM   5217  N   GLU C 190     -10.087  96.801  11.618  1.00 27.96           N  
ATOM   5218  CA  GLU C 190     -10.075  96.816  10.145  1.00 29.39           C  
ATOM   5219  C   GLU C 190     -10.402  98.219   9.673  1.00 28.12           C  
ATOM   5220  O   GLU C 190     -11.097  98.997  10.368  1.00 27.52           O  
ATOM   5221  CB  GLU C 190     -11.217  95.986   9.546  1.00 29.60           C  
ATOM   5222  CG  GLU C 190     -11.346  94.507   9.841  1.00 33.99           C  
ATOM   5223  CD  GLU C 190     -12.554  93.958   9.085  1.00 34.80           C  
ATOM   5224  OE1 GLU C 190     -12.485  93.943   7.833  1.00 42.35           O  
ATOM   5225  OE2 GLU C 190     -13.589  93.625   9.720  1.00 40.83           O  
ATOM   5226  N   SER C 191      -9.972  98.502   8.453  1.00 26.71           N  
ATOM   5227  CA  SER C 191     -10.323  99.707   7.772  1.00 26.05           C  
ATOM   5228  C   SER C 191     -10.800  99.214   6.377  1.00 26.32           C  
ATOM   5229  O   SER C 191     -10.165  98.336   5.776  1.00 24.49           O  
ATOM   5230  CB  SER C 191      -9.087 100.588   7.653  1.00 25.07           C  
ATOM   5231  OG  SER C 191      -9.348 101.785   6.963  1.00 29.42           O  
ATOM   5232  N   VAL C 192     -11.934  99.757   5.932  1.00 27.14           N  
ATOM   5233  CA  VAL C 192     -12.589  99.418   4.644  1.00 27.08           C  
ATOM   5234  C   VAL C 192     -13.116 100.735   4.058  1.00 27.85           C  
ATOM   5235  O   VAL C 192     -13.282 101.703   4.802  1.00 28.15           O  
ATOM   5236  CB  VAL C 192     -13.761  98.381   4.863  1.00 27.69           C  
ATOM   5237  CG1 VAL C 192     -13.259  97.103   5.582  1.00 27.64           C  
ATOM   5238  CG2 VAL C 192     -14.919  98.993   5.663  1.00 25.71           C  
ATOM   5239  N   PRO C 193     -13.368 100.786   2.727  1.00 28.91           N  
ATOM   5240  CA  PRO C 193     -13.897 102.020   2.109  1.00 28.98           C  
ATOM   5241  C   PRO C 193     -15.186 102.488   2.798  1.00 29.44           C  
ATOM   5242  O   PRO C 193     -16.022 101.657   3.169  1.00 29.20           O  
ATOM   5243  CB  PRO C 193     -14.163 101.594   0.655  1.00 29.70           C  
ATOM   5244  CG  PRO C 193     -13.168 100.439   0.405  1.00 29.25           C  
ATOM   5245  CD  PRO C 193     -13.169  99.706   1.735  1.00 28.04           C  
ATOM   5246  N   LEU C 194     -15.335 103.798   2.986  1.00 29.43           N  
ATOM   5247  CA  LEU C 194     -16.517 104.326   3.666  1.00 30.09           C  
ATOM   5248  C   LEU C 194     -17.801 103.714   3.089  1.00 30.97           C  
ATOM   5249  O   LEU C 194     -18.742 103.410   3.842  1.00 33.05           O  
ATOM   5250  CB  LEU C 194     -16.567 105.863   3.612  1.00 29.19           C  
ATOM   5251  CG  LEU C 194     -17.737 106.593   4.308  1.00 28.86           C  
ATOM   5252  CD1 LEU C 194     -17.779 106.399   5.853  1.00 25.71           C  
ATOM   5253  CD2 LEU C 194     -17.748 108.064   3.970  1.00 25.09           C  
ATOM   5254  N   ALA C 195     -17.831 103.516   1.773  1.00 31.36           N  
ATOM   5255  CA  ALA C 195     -19.022 102.994   1.099  1.00 30.48           C  
ATOM   5256  C   ALA C 195     -19.411 101.604   1.626  1.00 30.23           C  
ATOM   5257  O   ALA C 195     -20.586 101.238   1.613  1.00 29.34           O  
ATOM   5258  CB  ALA C 195     -18.825 102.980  -0.419  1.00 30.79           C  
ATOM   5259  N   GLN C 196     -18.435 100.848   2.136  1.00 29.61           N  
ATOM   5260  CA  GLN C 196     -18.715  99.523   2.697  1.00 29.16           C  
ATOM   5261  C   GLN C 196     -18.662  99.452   4.251  1.00 29.68           C  
ATOM   5262  O   GLN C 196     -18.944  98.397   4.846  1.00 27.67           O  
ATOM   5263  CB  GLN C 196     -17.802  98.471   2.055  1.00 30.02           C  
ATOM   5264  N   LEU C 197     -18.375 100.591   4.886  1.00 28.80           N  
ATOM   5265  CA  LEU C 197     -18.193 100.639   6.332  1.00 29.23           C  
ATOM   5266  C   LEU C 197     -19.454 100.121   7.012  1.00 29.04           C  
ATOM   5267  O   LEU C 197     -19.353  99.235   7.830  1.00 28.66           O  
ATOM   5268  CB  LEU C 197     -17.834 102.055   6.813  1.00 28.93           C  
ATOM   5269  CG  LEU C 197     -17.508 102.199   8.312  1.00 29.70           C  
ATOM   5270  CD1 LEU C 197     -16.419 101.243   8.728  1.00 28.15           C  
ATOM   5271  CD2 LEU C 197     -17.080 103.612   8.641  1.00 30.03           C  
ATOM   5272  N   ARG C 198     -20.642 100.631   6.658  1.00 28.69           N  
ATOM   5273  CA  ARG C 198     -21.827 100.145   7.364  1.00 30.00           C  
ATOM   5274  C   ARG C 198     -22.096  98.627   7.206  1.00 29.87           C  
ATOM   5275  O   ARG C 198     -22.364  97.930   8.205  1.00 30.22           O  
ATOM   5276  CB  ARG C 198     -23.056 101.028   7.109  1.00 29.41           C  
ATOM   5277  CG  ARG C 198     -24.360 100.548   7.740  1.00 30.02           C  
ATOM   5278  CD  ARG C 198     -25.496 101.537   7.359  1.00 31.68           C  
ATOM   5279  NE  ARG C 198     -26.824 101.098   7.814  1.00 35.71           N  
ATOM   5280  CZ  ARG C 198     -27.422 101.506   8.934  1.00 37.10           C  
ATOM   5281  NH1 ARG C 198     -26.806 102.379   9.749  1.00 37.70           N  
ATOM   5282  NH2 ARG C 198     -28.638 101.040   9.250  1.00 36.64           N  
ATOM   5283  N   GLU C 199     -21.952  98.104   5.983  1.00 30.30           N  
ATOM   5284  CA  GLU C 199     -22.235  96.679   5.743  1.00 30.39           C  
ATOM   5285  C   GLU C 199     -21.226  95.774   6.448  1.00 29.00           C  
ATOM   5286  O   GLU C 199     -21.606  94.757   7.014  1.00 28.43           O  
ATOM   5287  CB  GLU C 199     -22.366  96.343   4.247  1.00 30.00           C  
ATOM   5288  CG  GLU C 199     -21.036  96.235   3.508  1.00 31.55           C  
ATOM   5289  CD  GLU C 199     -21.191  96.223   1.995  1.00 32.93           C  
ATOM   5290  OE1 GLU C 199     -22.173  96.822   1.494  1.00 34.53           O  
ATOM   5291  OE2 GLU C 199     -20.310  95.630   1.336  1.00 36.81           O  
ATOM   5292  N   VAL C 200     -19.958  96.167   6.431  1.00 28.35           N  
ATOM   5293  CA  VAL C 200     -18.902  95.409   7.110  1.00 27.96           C  
ATOM   5294  C   VAL C 200     -19.176  95.364   8.634  1.00 28.19           C  
ATOM   5295  O   VAL C 200     -19.069  94.305   9.266  1.00 28.87           O  
ATOM   5296  CB  VAL C 200     -17.484  95.986   6.803  1.00 27.34           C  
ATOM   5297  CG1 VAL C 200     -16.414  95.263   7.591  1.00 28.31           C  
ATOM   5298  CG2 VAL C 200     -17.154  95.932   5.273  1.00 27.39           C  
ATOM   5299  N   THR C 201     -19.563  96.508   9.221  1.00 27.78           N  
ATOM   5300  CA  THR C 201     -19.824  96.587  10.672  1.00 27.64           C  
ATOM   5301  C   THR C 201     -21.036  95.739  11.061  1.00 28.06           C  
ATOM   5302  O   THR C 201     -21.004  95.038  12.090  1.00 27.70           O  
ATOM   5303  CB  THR C 201     -20.023  98.049  11.123  1.00 27.55           C  
ATOM   5304  OG1 THR C 201     -18.862  98.814  10.750  1.00 27.95           O  
ATOM   5305  CG2 THR C 201     -20.276  98.155  12.679  1.00 27.11           C  
ATOM   5306  N   ILE C 202     -22.075  95.774  10.214  1.00 28.06           N  
ATOM   5307  CA  ILE C 202     -23.290  95.018  10.458  1.00 28.19           C  
ATOM   5308  C   ILE C 202     -23.109  93.493  10.373  1.00 27.97           C  
ATOM   5309  O   ILE C 202     -23.701  92.756  11.175  1.00 27.11           O  
ATOM   5310  CB  ILE C 202     -24.446  95.495   9.558  1.00 28.26           C  
ATOM   5311  CG1 ILE C 202     -24.890  96.891   9.998  1.00 28.58           C  
ATOM   5312  CG2 ILE C 202     -25.604  94.487   9.561  1.00 30.09           C  
ATOM   5313  CD1 ILE C 202     -26.113  97.472   9.255  1.00 28.83           C  
ATOM   5314  N   GLU C 203     -22.323  93.016   9.405  1.00 27.29           N  
ATOM   5315  CA  GLU C 203     -21.996  91.592   9.357  1.00 27.40           C  
ATOM   5316  C   GLU C 203     -21.259  91.162  10.632  1.00 27.40           C  
ATOM   5317  O   GLU C 203     -21.593  90.119  11.211  1.00 27.98           O  
ATOM   5318  CB  GLU C 203     -21.190  91.212   8.092  1.00 27.38           C  
ATOM   5319  N   LEU C 204     -20.274  91.952  11.072  1.00 26.89           N  
ATOM   5320  CA  LEU C 204     -19.624  91.697  12.385  1.00 26.86           C  
ATOM   5321  C   LEU C 204     -20.629  91.687  13.560  1.00 27.78           C  
ATOM   5322  O   LEU C 204     -20.640  90.761  14.401  1.00 27.04           O  
ATOM   5323  CB  LEU C 204     -18.511  92.708  12.645  1.00 26.06           C  
ATOM   5324  CG  LEU C 204     -17.807  92.591  14.002  1.00 24.56           C  
ATOM   5325  CD1 LEU C 204     -17.345  91.159  14.231  1.00 21.59           C  
ATOM   5326  CD2 LEU C 204     -16.639  93.533  14.117  1.00 26.21           C  
ATOM   5327  N   ALA C 205     -21.493  92.707  13.579  1.00 28.14           N  
ATOM   5328  CA  ALA C 205     -22.503  92.863  14.612  1.00 28.73           C  
ATOM   5329  C   ALA C 205     -23.452  91.665  14.663  1.00 29.19           C  
ATOM   5330  O   ALA C 205     -23.833  91.219  15.757  1.00 29.91           O  
ATOM   5331  CB  ALA C 205     -23.287  94.162  14.388  1.00 28.03           C  
ATOM   5332  N   ARG C 206     -23.832  91.167  13.483  1.00 29.43           N  
ATOM   5333  CA  ARG C 206     -24.747  90.025  13.365  1.00 31.43           C  
ATOM   5334  C   ARG C 206     -24.083  88.784  13.946  1.00 30.80           C  
ATOM   5335  O   ARG C 206     -24.725  88.007  14.680  1.00 30.87           O  
ATOM   5336  CB  ARG C 206     -25.147  89.756  11.900  1.00 30.94           C  
ATOM   5337  CG  ARG C 206     -26.248  90.665  11.354  1.00 34.10           C  
ATOM   5338  CD  ARG C 206     -26.884  90.086  10.090  1.00 35.14           C  
ATOM   5339  NE  ARG C 206     -25.897  89.992   9.007  1.00 42.59           N  
ATOM   5340  CZ  ARG C 206     -25.815  90.828   7.969  1.00 44.89           C  
ATOM   5341  NH1 ARG C 206     -24.855  90.659   7.061  1.00 43.12           N  
ATOM   5342  NH2 ARG C 206     -26.682  91.835   7.847  1.00 46.00           N  
ATOM   5343  N   ASN C 207     -22.797  88.606  13.608  1.00 29.91           N  
ATOM   5344  CA  ASN C 207     -22.015  87.517  14.172  1.00 29.33           C  
ATOM   5345  C   ASN C 207     -22.085  87.541  15.688  1.00 28.36           C  
ATOM   5346  O   ASN C 207     -22.390  86.521  16.296  1.00 28.84           O  
ATOM   5347  CB  ASN C 207     -20.556  87.508  13.700  1.00 29.71           C  
ATOM   5348  CG  ASN C 207     -19.786  86.292  14.228  1.00 31.55           C  
ATOM   5349  OD1 ASN C 207     -19.718  85.247  13.571  1.00 35.24           O  
ATOM   5350  ND2 ASN C 207     -19.268  86.401  15.440  1.00 30.47           N  
ATOM   5351  N   LEU C 208     -21.855  88.710  16.282  1.00 27.16           N  
ATOM   5352  CA  LEU C 208     -21.873  88.871  17.729  1.00 26.94           C  
ATOM   5353  C   LEU C 208     -23.249  88.670  18.408  1.00 27.23           C  
ATOM   5354  O   LEU C 208     -23.327  88.149  19.536  1.00 25.82           O  
ATOM   5355  CB  LEU C 208     -21.271  90.227  18.119  1.00 26.79           C  
ATOM   5356  CG  LEU C 208     -19.784  90.456  17.750  1.00 25.90           C  
ATOM   5357  CD1 LEU C 208     -19.398  91.896  18.087  1.00 24.48           C  
ATOM   5358  CD2 LEU C 208     -18.788  89.452  18.462  1.00 20.43           C  
ATOM   5359  N   LEU C 209     -24.331  89.063  17.720  1.00 28.08           N  
ATOM   5360  CA  LEU C 209     -25.695  88.828  18.234  1.00 28.84           C  
ATOM   5361  C   LEU C 209     -26.024  87.343  18.315  1.00 30.13           C  
ATOM   5362  O   LEU C 209     -26.887  86.937  19.078  1.00 31.66           O  
ATOM   5363  CB  LEU C 209     -26.733  89.480  17.329  1.00 28.82           C  
ATOM   5364  CG  LEU C 209     -26.868  90.987  17.359  1.00 28.18           C  
ATOM   5365  CD1 LEU C 209     -27.872  91.384  16.325  1.00 27.25           C  
ATOM   5366  CD2 LEU C 209     -27.329  91.405  18.731  1.00 26.70           C  
ATOM   5367  N   GLU C 210     -25.354  86.538  17.504  1.00 32.25           N  
ATOM   5368  CA  GLU C 210     -25.584  85.103  17.514  1.00 33.68           C  
ATOM   5369  C   GLU C 210     -25.062  84.478  18.814  1.00 33.24           C  
ATOM   5370  O   GLU C 210     -25.485  83.376  19.166  1.00 33.77           O  
ATOM   5371  CB  GLU C 210     -24.941  84.419  16.305  1.00 33.98           C  
ATOM   5372  CG  GLU C 210     -25.592  84.671  14.932  1.00 35.71           C  
ATOM   5373  CD  GLU C 210     -24.716  84.198  13.758  0.50 36.35           C  
ATOM   5374  OE1 GLU C 210     -23.676  83.549  13.978  1.00 40.17           O  
ATOM   5375  OE2 GLU C 210     -25.066  84.467  12.590  1.00 42.63           O  
ATOM   5376  N   LYS C 211     -24.170  85.174  19.539  1.00 32.54           N  
ATOM   5377  CA  LYS C 211     -23.510  84.560  20.698  1.00 31.13           C  
ATOM   5378  C   LYS C 211     -24.392  84.715  21.922  1.00 31.15           C  
ATOM   5379  O   LYS C 211     -25.205  85.616  21.972  1.00 30.46           O  
ATOM   5380  CB  LYS C 211     -22.138  85.190  20.989  1.00 31.39           C  
ATOM   5381  CG  LYS C 211     -21.268  85.449  19.768  1.00 28.16           C  
ATOM   5382  CD  LYS C 211     -21.000  84.195  18.965  1.00 26.38           C  
ATOM   5383  CE  LYS C 211     -19.933  84.529  17.937  1.00 26.08           C  
ATOM   5384  NZ  LYS C 211     -19.825  83.585  16.836  1.00 28.73           N  
ATOM   5385  N   ASN C 212     -24.237  83.818  22.890  1.00 30.40           N  
ATOM   5386  CA  ASN C 212     -24.889  83.979  24.181  1.00 30.82           C  
ATOM   5387  C   ASN C 212     -24.381  85.268  24.847  1.00 29.71           C  
ATOM   5388  O   ASN C 212     -23.182  85.440  25.000  1.00 30.32           O  
ATOM   5389  CB  ASN C 212     -24.645  82.737  25.040  1.00 30.88           C  
ATOM   5390  CG  ASN C 212     -25.394  82.785  26.347  1.00 32.88           C  
ATOM   5391  OD1 ASN C 212     -25.051  83.547  27.268  1.00 35.93           O  
ATOM   5392  ND2 ASN C 212     -26.428  81.957  26.452  1.00 35.61           N  
ATOM   5393  N   PRO C 213     -25.284  86.233  25.128  1.00 29.23           N  
ATOM   5394  CA  PRO C 213     -24.921  87.514  25.747  1.00 27.58           C  
ATOM   5395  C   PRO C 213     -24.067  87.458  26.999  1.00 26.40           C  
ATOM   5396  O   PRO C 213     -23.081  88.164  27.075  1.00 27.04           O  
ATOM   5397  CB  PRO C 213     -26.286  88.163  26.038  1.00 27.92           C  
ATOM   5398  CG  PRO C 213     -27.114  87.704  24.821  1.00 28.90           C  
ATOM   5399  CD  PRO C 213     -26.704  86.227  24.681  1.00 28.51           C  
ATOM   5400  N   VAL C 214     -24.447  86.640  27.969  1.00 24.89           N  
ATOM   5401  CA  VAL C 214     -23.747  86.563  29.240  1.00 24.28           C  
ATOM   5402  C   VAL C 214     -22.341  85.961  29.006  1.00 23.90           C  
ATOM   5403  O   VAL C 214     -21.358  86.347  29.664  1.00 23.46           O  
ATOM   5404  CB  VAL C 214     -24.606  85.783  30.275  1.00 24.63           C  
ATOM   5405  CG1 VAL C 214     -23.786  85.430  31.561  1.00 23.80           C  
ATOM   5406  CG2 VAL C 214     -25.886  86.601  30.645  1.00 24.51           C  
ATOM   5407  N   VAL C 215     -22.266  85.051  28.037  1.00 24.52           N  
ATOM   5408  CA  VAL C 215     -21.015  84.306  27.770  1.00 25.46           C  
ATOM   5409  C   VAL C 215     -20.054  85.225  27.023  1.00 25.35           C  
ATOM   5410  O   VAL C 215     -18.880  85.349  27.384  1.00 24.41           O  
ATOM   5411  CB  VAL C 215     -21.276  82.977  27.014  1.00 25.84           C  
ATOM   5412  CG1 VAL C 215     -19.994  82.299  26.631  1.00 23.77           C  
ATOM   5413  CG2 VAL C 215     -22.152  82.028  27.869  1.00 25.74           C  
ATOM   5414  N   LEU C 216     -20.554  85.891  25.989  1.00 24.44           N  
ATOM   5415  CA  LEU C 216     -19.764  86.929  25.326  1.00 24.35           C  
ATOM   5416  C   LEU C 216     -19.264  87.974  26.328  1.00 25.01           C  
ATOM   5417  O   LEU C 216     -18.108  88.376  26.298  1.00 24.93           O  
ATOM   5418  CB  LEU C 216     -20.579  87.603  24.215  1.00 23.90           C  
ATOM   5419  CG  LEU C 216     -19.793  88.531  23.299  1.00 24.29           C  
ATOM   5420  CD1 LEU C 216     -18.508  87.838  22.799  1.00 22.48           C  
ATOM   5421  CD2 LEU C 216     -20.677  88.963  22.108  1.00 22.54           C  
ATOM   5422  N   ARG C 217     -20.136  88.413  27.225  1.00 26.03           N  
ATOM   5423  CA  ARG C 217     -19.728  89.367  28.244  1.00 26.63           C  
ATOM   5424  C   ARG C 217     -18.546  88.832  29.063  1.00 25.60           C  
ATOM   5425  O   ARG C 217     -17.555  89.539  29.291  1.00 24.60           O  
ATOM   5426  CB  ARG C 217     -20.918  89.703  29.169  1.00 26.28           C  
ATOM   5427  CG  ARG C 217     -20.632  90.846  30.103  1.00 30.20           C  
ATOM   5428  CD  ARG C 217     -21.592  90.826  31.317  1.00 33.39           C  
ATOM   5429  NE  ARG C 217     -22.996  90.820  30.892  1.00 33.08           N  
ATOM   5430  CZ  ARG C 217     -24.050  90.758  31.703  1.00 36.48           C  
ATOM   5431  NH1 ARG C 217     -23.889  90.695  33.035  1.00 38.37           N  
ATOM   5432  NH2 ARG C 217     -25.280  90.752  31.182  1.00 34.01           N  
ATOM   5433  N   ALA C 218     -18.662  87.591  29.528  1.00 25.20           N  
ATOM   5434  CA  ALA C 218     -17.636  86.996  30.387  1.00 25.33           C  
ATOM   5435  C   ALA C 218     -16.309  86.884  29.616  1.00 25.75           C  
ATOM   5436  O   ALA C 218     -15.220  87.120  30.169  1.00 24.66           O  
ATOM   5437  CB  ALA C 218     -18.088  85.616  30.860  1.00 24.94           C  
ATOM   5438  N   ALA C 219     -16.426  86.543  28.333  1.00 25.08           N  
ATOM   5439  CA  ALA C 219     -15.266  86.355  27.465  1.00 25.52           C  
ATOM   5440  C   ALA C 219     -14.518  87.676  27.239  1.00 25.69           C  
ATOM   5441  O   ALA C 219     -13.294  87.756  27.452  1.00 24.97           O  
ATOM   5442  CB  ALA C 219     -15.680  85.730  26.146  1.00 25.34           C  
ATOM   5443  N   LYS C 220     -15.236  88.709  26.802  1.00 25.33           N  
ATOM   5444  CA  LYS C 220     -14.620  90.010  26.486  1.00 23.57           C  
ATOM   5445  C   LYS C 220     -14.082  90.748  27.751  1.00 24.36           C  
ATOM   5446  O   LYS C 220     -12.972  91.322  27.712  1.00 23.39           O  
ATOM   5447  CB  LYS C 220     -15.565  90.858  25.599  1.00 24.42           C  
ATOM   5448  CG  LYS C 220     -16.737  91.528  26.348  1.00 23.69           C  
ATOM   5449  CD  LYS C 220     -17.939  91.836  25.422  1.00 23.17           C  
ATOM   5450  CE  LYS C 220     -18.965  92.727  26.120  1.00 23.94           C  
ATOM   5451  NZ  LYS C 220     -18.551  94.210  26.038  1.00 19.28           N  
ATOM   5452  N   HIS C 221     -14.837  90.740  28.860  1.00 23.89           N  
ATOM   5453  CA  HIS C 221     -14.362  91.353  30.111  1.00 23.43           C  
ATOM   5454  C   HIS C 221     -13.091  90.637  30.604  1.00 24.06           C  
ATOM   5455  O   HIS C 221     -12.099  91.284  31.010  1.00 23.55           O  
ATOM   5456  CB  HIS C 221     -15.425  91.310  31.226  1.00 23.23           C  
ATOM   5457  CG  HIS C 221     -16.614  92.207  30.962  1.00 25.47           C  
ATOM   5458  ND1 HIS C 221     -17.632  92.398  31.874  1.00 25.22           N  
ATOM   5459  CD2 HIS C 221     -16.944  92.943  29.876  1.00 25.54           C  
ATOM   5460  CE1 HIS C 221     -18.539  93.215  31.360  1.00 24.74           C  
ATOM   5461  NE2 HIS C 221     -18.146  93.560  30.149  1.00 25.65           N  
ATOM   5462  N   GLY C 222     -13.150  89.299  30.559  1.00 23.07           N  
ATOM   5463  CA  GLY C 222     -12.095  88.450  31.070  1.00 22.57           C  
ATOM   5464  C   GLY C 222     -10.830  88.730  30.292  1.00 22.06           C  
ATOM   5465  O   GLY C 222      -9.741  88.847  30.855  1.00 21.64           O  
ATOM   5466  N   PHE C 223     -10.959  88.846  28.983  1.00 21.33           N  
ATOM   5467  CA  PHE C 223      -9.770  89.176  28.215  1.00 21.39           C  
ATOM   5468  C   PHE C 223      -9.144  90.526  28.689  1.00 22.18           C  
ATOM   5469  O   PHE C 223      -7.922  90.608  28.975  1.00 20.03           O  
ATOM   5470  CB  PHE C 223     -10.011  89.187  26.674  1.00 20.67           C  
ATOM   5471  CG  PHE C 223      -8.802  89.688  25.934  1.00 18.57           C  
ATOM   5472  CD1 PHE C 223      -8.651  91.054  25.649  1.00 19.55           C  
ATOM   5473  CD2 PHE C 223      -7.741  88.818  25.652  1.00 21.53           C  
ATOM   5474  CE1 PHE C 223      -7.489  91.522  25.091  1.00 19.60           C  
ATOM   5475  CE2 PHE C 223      -6.584  89.282  25.034  1.00 22.42           C  
ATOM   5476  CZ  PHE C 223      -6.444  90.626  24.753  1.00 22.71           C  
ATOM   5477  N   LYS C 224      -9.980  91.567  28.794  1.00 20.78           N  
ATOM   5478  CA  LYS C 224      -9.479  92.919  29.049  1.00 21.41           C  
ATOM   5479  C   LYS C 224      -8.804  92.965  30.422  1.00 22.94           C  
ATOM   5480  O   LYS C 224      -7.734  93.569  30.579  1.00 24.01           O  
ATOM   5481  CB  LYS C 224     -10.623  94.002  28.920  1.00 19.44           C  
ATOM   5482  CG  LYS C 224     -11.148  94.215  27.486  1.00 21.86           C  
ATOM   5483  CD  LYS C 224     -12.158  95.403  27.425  1.00 21.26           C  
ATOM   5484  CE  LYS C 224     -12.682  95.671  25.940  1.00 19.96           C  
ATOM   5485  NZ  LYS C 224     -13.239  97.121  25.800  1.00 20.24           N  
ATOM   5486  N   ARG C 225      -9.422  92.296  31.406  1.00 21.95           N  
ATOM   5487  CA  ARG C 225      -8.878  92.238  32.741  1.00 21.81           C  
ATOM   5488  C   ARG C 225      -7.637  91.355  32.803  1.00 22.44           C  
ATOM   5489  O   ARG C 225      -6.718  91.673  33.524  1.00 22.01           O  
ATOM   5490  CB  ARG C 225      -9.908  91.686  33.726  1.00 21.69           C  
ATOM   5491  CG  ARG C 225      -9.437  91.638  35.221  1.00 23.67           C  
ATOM   5492  CD  ARG C 225      -9.452  92.980  35.922  1.00 24.36           C  
ATOM   5493  NE  ARG C 225     -10.769  93.598  35.852  1.00 28.56           N  
ATOM   5494  CZ  ARG C 225     -10.999  94.905  35.746  1.00 28.86           C  
ATOM   5495  NH1 ARG C 225     -12.256  95.349  35.679  1.00 23.34           N  
ATOM   5496  NH2 ARG C 225      -9.981  95.764  35.684  1.00 26.83           N  
ATOM   5497  N   CYS C 226      -7.616  90.229  32.091  1.00 20.82           N  
ATOM   5498  CA  CYS C 226      -6.456  89.284  32.232  1.00 20.61           C  
ATOM   5499  C   CYS C 226      -5.142  89.907  31.805  1.00 20.79           C  
ATOM   5500  O   CYS C 226      -4.102  89.516  32.297  1.00 18.45           O  
ATOM   5501  CB  CYS C 226      -6.680  87.949  31.512  1.00 19.63           C  
ATOM   5502  SG  CYS C 226      -6.282  87.913  29.740  1.00 23.13           S  
ATOM   5503  N   ARG C 227      -5.207  90.916  30.931  1.00 21.03           N  
ATOM   5504  CA  ARG C 227      -3.963  91.662  30.558  1.00 21.93           C  
ATOM   5505  C   ARG C 227      -3.226  92.252  31.781  1.00 23.10           C  
ATOM   5506  O   ARG C 227      -2.012  92.377  31.787  1.00 23.04           O  
ATOM   5507  CB  ARG C 227      -4.294  92.767  29.557  1.00 23.93           C  
ATOM   5508  CG  ARG C 227      -4.902  92.233  28.277  1.00 23.38           C  
ATOM   5509  CD  ARG C 227      -4.937  93.356  27.201  1.00 20.82           C  
ATOM   5510  NE  ARG C 227      -3.551  93.731  26.849  1.00 22.92           N  
ATOM   5511  CZ  ARG C 227      -3.208  94.767  26.102  1.00 25.22           C  
ATOM   5512  NH1 ARG C 227      -4.147  95.558  25.581  1.00 26.33           N  
ATOM   5513  NH2 ARG C 227      -1.906  94.983  25.830  1.00 23.49           N  
ATOM   5514  N   GLU C 228      -3.979  92.624  32.812  1.00 22.78           N  
ATOM   5515  CA  GLU C 228      -3.443  93.224  34.061  1.00 22.04           C  
ATOM   5516  C   GLU C 228      -2.932  92.224  35.079  1.00 21.39           C  
ATOM   5517  O   GLU C 228      -2.278  92.614  36.080  1.00 21.97           O  
ATOM   5518  CB  GLU C 228      -4.596  93.994  34.743  1.00 22.56           C  
ATOM   5519  CG  GLU C 228      -5.308  94.901  33.799  1.00 20.13           C  
ATOM   5520  CD  GLU C 228      -6.461  95.648  34.377  1.00 24.39           C  
ATOM   5521  OE1 GLU C 228      -6.972  95.261  35.446  1.00 19.27           O  
ATOM   5522  OE2 GLU C 228      -6.907  96.617  33.703  1.00 25.47           O  
ATOM   5523  N   LEU C 229      -3.235  90.946  34.879  0.50 20.30           N  
ATOM   5524  CA  LEU C 229      -2.949  89.925  35.919  0.50 20.48           C  
ATOM   5525  C   LEU C 229      -1.803  89.000  35.530  0.50 20.31           C  
ATOM   5526  O   LEU C 229      -1.476  88.905  34.362  0.50 21.68           O  
ATOM   5527  CB  LEU C 229      -4.220  89.107  36.212  0.50 19.67           C  
ATOM   5528  CG  LEU C 229      -5.381  89.972  36.731  0.50 20.59           C  
ATOM   5529  CD1 LEU C 229      -6.692  89.207  36.735  0.50 15.96           C  
ATOM   5530  CD2 LEU C 229      -5.081  90.601  38.113  0.50 18.58           C  
ATOM   5539  N   THR C 230      -1.206  88.314  36.499  1.00 20.71           N  
ATOM   5540  CA  THR C 230      -0.159  87.325  36.207  1.00 20.07           C  
ATOM   5541  C   THR C 230      -0.881  86.048  35.669  1.00 20.64           C  
ATOM   5542  O   THR C 230      -2.119  85.989  35.687  1.00 19.17           O  
ATOM   5543  CB  THR C 230       0.669  86.932  37.449  1.00 20.55           C  
ATOM   5544  OG1 THR C 230      -0.228  86.365  38.376  1.00 19.02           O  
ATOM   5545  CG2 THR C 230       1.299  88.150  38.123  1.00 18.51           C  
ATOM   5546  N   TRP C 231      -0.131  85.067  35.145  1.00 20.49           N  
ATOM   5547  CA  TRP C 231      -0.754  83.760  34.805  1.00 20.14           C  
ATOM   5548  C   TRP C 231      -1.431  83.124  36.023  1.00 21.06           C  
ATOM   5549  O   TRP C 231      -2.569  82.675  35.951  1.00 20.53           O  
ATOM   5550  CB  TRP C 231       0.305  82.799  34.228  1.00 20.79           C  
ATOM   5551  CG  TRP C 231       0.636  83.242  32.789  1.00 18.29           C  
ATOM   5552  CD1 TRP C 231       1.055  84.475  32.378  1.00 22.26           C  
ATOM   5553  CD2 TRP C 231       0.479  82.456  31.597  1.00 19.30           C  
ATOM   5554  NE1 TRP C 231       1.204  84.506  31.006  1.00 17.26           N  
ATOM   5555  CE2 TRP C 231       0.863  83.270  30.503  1.00 20.81           C  
ATOM   5556  CE3 TRP C 231       0.061  81.139  31.352  1.00 20.53           C  
ATOM   5557  CZ2 TRP C 231       0.848  82.805  29.166  1.00 21.03           C  
ATOM   5558  CZ3 TRP C 231       0.066  80.678  30.023  1.00 20.28           C  
ATOM   5559  CH2 TRP C 231       0.437  81.518  28.951  1.00 21.93           C  
ATOM   5560  N   GLU C 232      -0.722  83.081  37.146  1.00 19.76           N  
ATOM   5561  CA  GLU C 232      -1.285  82.457  38.340  1.00 20.71           C  
ATOM   5562  C   GLU C 232      -2.504  83.204  38.889  1.00 20.41           C  
ATOM   5563  O   GLU C 232      -3.488  82.560  39.322  1.00 22.57           O  
ATOM   5564  CB  GLU C 232      -0.185  82.277  39.384  1.00 21.52           C  
ATOM   5565  CG  GLU C 232       0.951  81.331  38.858  1.00 26.66           C  
ATOM   5566  CD  GLU C 232       2.012  82.031  37.936  1.00 32.66           C  
ATOM   5567  OE1 GLU C 232       2.031  83.325  37.811  1.00 30.91           O  
ATOM   5568  OE2 GLU C 232       2.856  81.262  37.364  1.00 31.69           O  
ATOM   5569  N   GLN C 233      -2.479  84.543  38.859  1.00 20.14           N  
ATOM   5570  CA  GLN C 233      -3.703  85.334  39.168  1.00 20.37           C  
ATOM   5571  C   GLN C 233      -4.864  85.045  38.197  1.00 20.23           C  
ATOM   5572  O   GLN C 233      -6.018  84.955  38.611  1.00 21.26           O  
ATOM   5573  CB  GLN C 233      -3.434  86.831  39.155  1.00 20.12           C  
ATOM   5574  CG  GLN C 233      -2.546  87.318  40.355  1.00 21.78           C  
ATOM   5575  CD  GLN C 233      -2.157  88.772  40.233  1.00 21.74           C  
ATOM   5576  OE1 GLN C 233      -1.952  89.277  39.139  1.00 19.31           O  
ATOM   5577  NE2 GLN C 233      -2.027  89.455  41.378  1.00 21.54           N  
ATOM   5578  N   ASN C 234      -4.559  84.857  36.926  1.00 19.65           N  
ATOM   5579  CA  ASN C 234      -5.574  84.501  35.925  1.00 20.21           C  
ATOM   5580  C   ASN C 234      -6.137  83.101  36.075  1.00 20.68           C  
ATOM   5581  O   ASN C 234      -7.292  82.844  35.736  1.00 21.76           O  
ATOM   5582  CB  ASN C 234      -5.000  84.729  34.539  1.00 19.55           C  
ATOM   5583  CG  ASN C 234      -5.116  86.183  34.142  1.00 19.82           C  
ATOM   5584  OD1 ASN C 234      -6.185  86.744  34.275  1.00 19.95           O  
ATOM   5585  ND2 ASN C 234      -4.031  86.816  33.700  1.00 21.72           N  
ATOM   5586  N   GLU C 235      -5.320  82.180  36.543  1.00 20.00           N  
ATOM   5587  CA  GLU C 235      -5.842  80.828  36.749  1.00 19.76           C  
ATOM   5588  C   GLU C 235      -7.114  80.998  37.585  1.00 20.04           C  
ATOM   5589  O   GLU C 235      -8.148  80.444  37.285  1.00 20.61           O  
ATOM   5590  CB  GLU C 235      -4.836  79.924  37.458  1.00 21.16           C  
ATOM   5591  CG  GLU C 235      -5.437  78.519  37.581  1.00 21.98           C  
ATOM   5592  CD  GLU C 235      -4.629  77.516  38.343  1.00 26.11           C  
ATOM   5593  OE1 GLU C 235      -3.894  77.876  39.290  1.00 28.57           O  
ATOM   5594  OE2 GLU C 235      -4.770  76.318  38.010  1.00 25.39           O  
ATOM   5595  N   ASP C 236      -7.003  81.802  38.629  1.00 19.84           N  
ATOM   5596  CA  ASP C 236      -8.067  82.033  39.609  1.00 19.81           C  
ATOM   5597  C   ASP C 236      -9.150  82.883  38.959  1.00 18.32           C  
ATOM   5598  O   ASP C 236     -10.325  82.477  38.900  1.00 18.27           O  
ATOM   5599  CB  ASP C 236      -7.438  82.758  40.818  1.00 19.45           C  
ATOM   5600  CG  ASP C 236      -8.424  82.971  41.993  1.00 24.18           C  
ATOM   5601  OD1 ASP C 236      -9.611  82.617  41.881  1.00 25.24           O  
ATOM   5602  OD2 ASP C 236      -7.991  83.542  43.017  1.00 20.06           O  
ATOM   5603  N   TYR C 237      -8.765  84.044  38.435  1.00 18.23           N  
ATOM   5604  CA  TYR C 237      -9.730  84.993  37.875  1.00 18.87           C  
ATOM   5605  C   TYR C 237     -10.509  84.394  36.653  1.00 18.74           C  
ATOM   5606  O   TYR C 237     -11.734  84.480  36.600  1.00 18.45           O  
ATOM   5607  CB  TYR C 237      -9.074  86.359  37.517  1.00 19.09           C  
ATOM   5608  CG  TYR C 237      -9.936  87.259  36.626  1.00 21.51           C  
ATOM   5609  CD1 TYR C 237      -9.685  87.357  35.264  1.00 21.95           C  
ATOM   5610  CD2 TYR C 237     -11.001  88.018  37.161  1.00 21.96           C  
ATOM   5611  CE1 TYR C 237     -10.475  88.155  34.451  1.00 21.19           C  
ATOM   5612  CE2 TYR C 237     -11.824  88.808  36.338  1.00 18.95           C  
ATOM   5613  CZ  TYR C 237     -11.548  88.899  35.014  1.00 20.34           C  
ATOM   5614  OH  TYR C 237     -12.366  89.717  34.250  1.00 20.95           O  
ATOM   5615  N   LEU C 238      -9.809  83.839  35.662  1.00 18.30           N  
ATOM   5616  CA  LEU C 238     -10.481  83.353  34.477  1.00 19.28           C  
ATOM   5617  C   LEU C 238     -11.391  82.165  34.763  1.00 19.92           C  
ATOM   5618  O   LEU C 238     -12.436  82.014  34.104  1.00 20.78           O  
ATOM   5619  CB  LEU C 238      -9.503  83.031  33.287  1.00 19.55           C  
ATOM   5620  CG  LEU C 238      -8.734  84.277  32.824  1.00 19.86           C  
ATOM   5621  CD1 LEU C 238      -7.478  83.852  32.013  1.00 21.03           C  
ATOM   5622  CD2 LEU C 238      -9.630  85.324  32.079  1.00 17.04           C  
ATOM   5623  N   TYR C 239     -11.016  81.290  35.695  1.00 19.67           N  
ATOM   5624  CA  TYR C 239     -11.943  80.226  36.025  1.00 19.98           C  
ATOM   5625  C   TYR C 239     -13.128  80.805  36.740  1.00 20.44           C  
ATOM   5626  O   TYR C 239     -14.264  80.414  36.454  1.00 20.92           O  
ATOM   5627  CB  TYR C 239     -11.318  79.139  36.888  1.00 19.39           C  
ATOM   5628  CG  TYR C 239     -10.721  78.018  36.061  1.00 21.10           C  
ATOM   5629  CD1 TYR C 239      -9.350  77.747  36.112  1.00 24.25           C  
ATOM   5630  CD2 TYR C 239     -11.516  77.271  35.155  1.00 21.72           C  
ATOM   5631  CE1 TYR C 239      -8.792  76.696  35.344  1.00 20.58           C  
ATOM   5632  CE2 TYR C 239     -10.970  76.232  34.366  1.00 22.57           C  
ATOM   5633  CZ  TYR C 239      -9.601  75.945  34.486  1.00 22.43           C  
ATOM   5634  OH  TYR C 239      -8.998  74.936  33.743  1.00 18.99           O  
ATOM   5635  N   ALA C 240     -12.892  81.732  37.673  1.00 20.10           N  
ATOM   5636  CA  ALA C 240     -14.051  82.472  38.237  1.00 20.00           C  
ATOM   5637  C   ALA C 240     -14.987  83.092  37.207  1.00 19.57           C  
ATOM   5638  O   ALA C 240     -16.203  82.934  37.357  1.00 20.82           O  
ATOM   5639  CB  ALA C 240     -13.652  83.446  39.321  1.00 19.70           C  
ATOM   5640  N   LYS C 241     -14.477  83.783  36.184  1.00 19.66           N  
ATOM   5641  CA  LYS C 241     -15.372  84.293  35.134  1.00 20.39           C  
ATOM   5642  C   LYS C 241     -16.139  83.201  34.408  1.00 21.35           C  
ATOM   5643  O   LYS C 241     -17.287  83.412  34.020  1.00 20.61           O  
ATOM   5644  CB  LYS C 241     -14.653  85.140  34.074  1.00 20.78           C  
ATOM   5645  CG  LYS C 241     -13.898  86.370  34.620  1.00 20.67           C  
ATOM   5646  CD  LYS C 241     -14.772  87.310  35.377  1.00 20.51           C  
ATOM   5647  CE  LYS C 241     -15.667  88.161  34.487  1.00 18.56           C  
ATOM   5648  NZ  LYS C 241     -16.500  89.091  35.398  1.00 20.30           N  
ATOM   5649  N   LEU C 242     -15.488  82.056  34.176  1.00 22.23           N  
ATOM   5650  CA  LEU C 242     -16.146  80.914  33.533  1.00 22.47           C  
ATOM   5651  C   LEU C 242     -17.322  80.424  34.375  1.00 21.81           C  
ATOM   5652  O   LEU C 242     -18.422  80.230  33.837  1.00 21.87           O  
ATOM   5653  CB  LEU C 242     -15.127  79.745  33.329  1.00 23.53           C  
ATOM   5654  CG  LEU C 242     -15.415  78.482  32.488  1.00 24.88           C  
ATOM   5655  CD1 LEU C 242     -16.151  77.359  33.233  1.00 31.60           C  
ATOM   5656  CD2 LEU C 242     -16.137  78.806  31.185  1.00 27.81           C  
ATOM   5657  N   ASP C 243     -17.074  80.193  35.659  1.00 20.40           N  
ATOM   5658  CA  ASP C 243     -18.109  79.735  36.619  1.00 21.49           C  
ATOM   5659  C   ASP C 243     -19.228  80.732  36.875  1.00 20.86           C  
ATOM   5660  O   ASP C 243     -20.419  80.372  37.060  1.00 21.92           O  
ATOM   5661  CB  ASP C 243     -17.445  79.346  37.934  1.00 21.04           C  
ATOM   5662  CG  ASP C 243     -16.575  78.072  37.802  1.00 24.02           C  
ATOM   5663  OD1 ASP C 243     -16.760  77.315  36.841  1.00 24.27           O  
ATOM   5664  OD2 ASP C 243     -15.711  77.841  38.668  1.00 26.46           O  
ATOM   5665  N   GLN C 244     -18.858  82.004  36.859  1.00 21.44           N  
ATOM   5666  CA  GLN C 244     -19.834  83.090  36.941  1.00 21.98           C  
ATOM   5667  C   GLN C 244     -20.730  83.113  35.710  1.00 22.85           C  
ATOM   5668  O   GLN C 244     -21.955  83.267  35.841  1.00 22.58           O  
ATOM   5669  CB  GLN C 244     -19.087  84.410  37.108  1.00 22.54           C  
ATOM   5670  CG  GLN C 244     -19.958  85.668  36.906  1.00 22.18           C  
ATOM   5671  CD  GLN C 244     -19.159  86.911  37.159  1.00 24.52           C  
ATOM   5672  OE1 GLN C 244     -18.170  87.167  36.475  1.00 23.82           O  
ATOM   5673  NE2 GLN C 244     -19.573  87.691  38.160  1.00 23.05           N  
ATOM   5674  N   SER C 245     -20.124  82.949  34.535  0.50 23.73           N  
ATOM   5675  CA  SER C 245     -20.849  82.915  33.269  0.50 24.53           C  
ATOM   5676  C   SER C 245     -21.881  81.782  33.217  0.50 24.55           C  
ATOM   5677  O   SER C 245     -22.978  81.968  32.701  0.50 24.77           O  
ATOM   5678  CB  SER C 245     -19.886  82.789  32.087  0.50 24.89           C  
ATOM   5679  OG  SER C 245     -20.593  82.871  30.870  0.50 26.60           O  
ATOM   5686  N   ARG C 246     -21.512  80.620  33.735  1.00 24.25           N  
ATOM   5687  CA  ARG C 246     -22.423  79.481  33.865  1.00 26.80           C  
ATOM   5688  C   ARG C 246     -23.604  79.777  34.779  1.00 27.42           C  
ATOM   5689  O   ARG C 246     -24.743  79.496  34.419  1.00 26.68           O  
ATOM   5690  CB  ARG C 246     -21.685  78.227  34.322  1.00 27.04           C  
ATOM   5691  CG  ARG C 246     -20.800  77.686  33.236  1.00 32.59           C  
ATOM   5692  CD  ARG C 246     -19.742  76.728  33.738  1.00 40.29           C  
ATOM   5693  NE  ARG C 246     -20.285  75.500  34.324  1.00 45.78           N  
ATOM   5694  CZ  ARG C 246     -19.616  74.761  35.218  1.00 48.04           C  
ATOM   5695  NH1 ARG C 246     -18.407  75.150  35.640  1.00 45.50           N  
ATOM   5696  NH2 ARG C 246     -20.159  73.650  35.713  1.00 47.41           N  
ATOM   5697  N   LEU C 247     -23.350  80.398  35.923  1.00 27.38           N  
ATOM   5698  CA  LEU C 247     -24.465  80.826  36.800  1.00 28.54           C  
ATOM   5699  C   LEU C 247     -25.385  81.904  36.194  1.00 29.54           C  
ATOM   5700  O   LEU C 247     -26.592  81.761  36.212  1.00 30.08           O  
ATOM   5701  CB  LEU C 247     -23.926  81.308  38.147  1.00 27.36           C  
ATOM   5702  CG  LEU C 247     -24.993  81.846  39.116  1.00 28.37           C  
ATOM   5703  CD1 LEU C 247     -25.662  80.688  39.850  1.00 28.59           C  
ATOM   5704  CD2 LEU C 247     -24.412  82.860  40.097  1.00 26.80           C  
ATOM   5705  N   LEU C 248     -24.808  82.991  35.679  1.00 31.32           N  
ATOM   5706  CA  LEU C 248     -25.571  84.155  35.240  1.00 33.17           C  
ATOM   5707  C   LEU C 248     -26.292  83.922  33.938  1.00 34.82           C  
ATOM   5708  O   LEU C 248     -27.249  84.648  33.605  1.00 34.51           O  
ATOM   5709  CB  LEU C 248     -24.668  85.379  35.087  1.00 32.48           C  
ATOM   5710  CG  LEU C 248     -24.024  85.901  36.363  1.00 32.58           C  
ATOM   5711  CD1 LEU C 248     -23.224  87.174  36.042  1.00 27.22           C  
ATOM   5712  CD2 LEU C 248     -25.074  86.150  37.436  1.00 32.13           C  
ATOM   5713  N   ASP C 249     -25.841  82.915  33.193  1.00 36.26           N  
ATOM   5714  CA  ASP C 249     -26.464  82.628  31.902  1.00 38.30           C  
ATOM   5715  C   ASP C 249     -27.699  81.721  32.014  1.00 39.57           C  
ATOM   5716  O   ASP C 249     -27.594  80.513  32.252  1.00 40.00           O  
ATOM   5717  CB  ASP C 249     -25.460  82.076  30.901  1.00 37.50           C  
ATOM   5718  CG  ASP C 249     -26.130  81.407  29.753  1.00 38.75           C  
ATOM   5719  OD1 ASP C 249     -27.150  81.974  29.255  1.00 35.36           O  
ATOM   5720  OD2 ASP C 249     -25.646  80.313  29.376  1.00 36.81           O  
ATOM   5721  N   THR C 250     -28.861  82.311  31.892  1.00 41.75           N  
ATOM   5722  CA  THR C 250     -30.068  81.620  32.329  1.00 42.84           C  
ATOM   5723  C   THR C 250     -30.656  80.729  31.267  1.00 43.70           C  
ATOM   5724  O   THR C 250     -30.838  79.533  31.485  1.00 45.39           O  
ATOM   5725  CB  THR C 250     -31.091  82.538  32.965  1.00 42.89           C  
ATOM   5726  OG1 THR C 250     -30.566  82.999  34.220  1.00 42.32           O  
ATOM   5727  CG2 THR C 250     -31.432  83.697  32.064  1.00 42.48           C  
ATOM   5728  N   GLY C 251     -30.804  81.241  30.062  1.00 20.00           N  
ATOM   5729  CA  GLY C 251     -29.807  81.041  29.027  1.00 20.00           C  
ATOM   5730  C   GLY C 251     -29.430  79.641  28.584  1.00 20.00           C  
ATOM   5731  O   GLY C 251     -29.846  79.246  27.529  1.00 20.00           O  
ATOM   5732  N   GLY C 252     -28.583  78.925  29.347  1.00 20.00           N  
ATOM   5733  CA  GLY C 252     -27.827  77.751  28.889  1.00 20.00           C  
ATOM   5734  C   GLY C 252     -26.557  77.844  28.028  1.00 20.00           C  
ATOM   5735  O   GLY C 252     -26.452  78.653  27.148  1.00 20.00           O  
ATOM   5736  N   ARG C 253     -25.631  76.904  28.249  1.00 20.00           N  
ATOM   5737  CA  ARG C 253     -24.381  76.716  27.465  1.00 20.00           C  
ATOM   5738  C   ARG C 253     -24.219  75.310  26.883  1.00 20.00           C  
ATOM   5739  O   ARG C 253     -23.676  74.393  27.527  1.00 20.00           O  
ATOM   5740  CB  ARG C 253     -23.175  77.003  28.343  1.00 20.00           C  
ATOM   5741  CG  ARG C 253     -22.252  75.854  28.575  1.00 20.00           C  
ATOM   5742  CD  ARG C 253     -21.840  75.746  30.035  1.00 20.00           C  
ATOM   5743  NE  ARG C 253     -21.009  74.577  30.334  1.00 20.00           N  
ATOM   5744  CZ  ARG C 253     -20.022  74.555  31.235  1.00 20.00           C  
ATOM   5745  NH1 ARG C 253     -19.728  75.634  31.935  1.00 20.00           N  
ATOM   5746  NH2 ARG C 253     -19.332  73.457  31.454  1.00 20.00           N  
ATOM   5747  N   GLU C 254     -24.801  75.126  25.720  1.00 20.00           N  
ATOM   5748  CA  GLU C 254     -25.511  73.889  25.407  1.00 20.00           C  
ATOM   5749  C   GLU C 254     -24.873  73.364  24.144  1.00 20.00           C  
ATOM   5750  O   GLU C 254     -25.413  72.466  23.503  1.00 20.00           O  
ATOM   5751  CB  GLU C 254     -26.968  74.205  25.115  1.00 20.00           C  
ATOM   5752  CG  GLU C 254     -27.068  75.120  23.953  1.00 20.00           C  
ATOM   5753  CD  GLU C 254     -28.464  75.507  23.612  1.00 20.00           C  
ATOM   5754  OE1 GLU C 254     -29.367  75.148  24.403  1.00 20.00           O  
ATOM   5755  OE2 GLU C 254     -28.653  76.169  22.549  1.00 20.00           O  
ATOM   5756  N   GLN C 255     -23.643  73.758  23.857  1.00 20.00           N  
ATOM   5757  CA  GLN C 255     -22.692  72.773  23.342  1.00 20.00           C  
ATOM   5758  C   GLN C 255     -23.023  71.362  23.865  1.00 20.00           C  
ATOM   5759  O   GLN C 255     -23.639  70.550  23.175  1.00 20.00           O  
ATOM   5760  CB  GLN C 255     -21.271  73.160  23.718  1.00 20.00           C  
ATOM   5761  N   GLY C 256     -22.587  71.103  25.111  1.00 20.00           N  
ATOM   5762  CA  GLY C 256     -22.796  69.861  25.834  1.00 20.00           C  
ATOM   5763  C   GLY C 256     -23.895  69.015  25.225  1.00 20.00           C  
ATOM   5764  O   GLY C 256     -23.879  67.792  25.280  1.00 20.00           O  
TER    5765      GLY C 256                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
