
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  264 ( 2068),  selected  264 , name 2ppy_A
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 2ppy_A.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     2_A      -       -           -
LGA    A     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    K     7_A      -       -           -
LGA    K     8_A      P      32          4.945
LGA    Q     9_A      R      33          1.067
LGA    Y    10_A      P      34          0.772
LGA    L    11_A      T      35          0.578
LGA    T    12_A      S      36          1.101
LGA    V    13_A      A      37          1.176
LGA    F    14_A      R      38          0.758
LGA    K    15_A      Q      39          0.892
LGA    E    16_A      L      40          1.150
LGA    D    17_A      D      41          1.135
LGA    G    18_A      G      42          1.235
LGA    I    19_A      I      43          1.045
LGA    A    20_A      R      44          0.682
LGA    E    21_A      N      45          0.689
LGA    I    22_A      I      46          0.398
LGA    H    23_A      V      47          0.832
LGA    L    24_A      L      48          0.921
LGA    H    25_A      S      49          0.429
LGA    I    26_A      N      50          1.912
LGA    N    27_A      P      51          3.309
LGA    K    28_A      K      52          2.137
LGA    -       -      K      53           -
LGA    S    29_A      R      54          0.758
LGA    N    30_A      N      55          0.516
LGA    S    31_A      T      56          0.982
LGA    Y    32_A      L      57          2.107
LGA    D    33_A      S      58          1.032
LGA    L    34_A      L      59          0.837
LGA    E    35_A      A      60          1.458
LGA    F    36_A      M      61          1.404
LGA    Y    37_A      L      62          1.203
LGA    K    38_A      K      63          1.358
LGA    E    39_A      S      64          1.543
LGA    F    40_A      L      65          1.464
LGA    N    41_A      Q      66          1.498
LGA    A    42_A      S      67          1.610
LGA    A    43_A      D      68          1.763
LGA    I    44_A      I      69          2.027
LGA    D    45_A      L      70          1.709
LGA    D    46_A      H      71          1.035
LGA    I    47_A      D      72          4.015
LGA    R    48_A      A      73          1.677
LGA    F    49_A      D      74          2.729
LGA    D    50_A      S      75          2.126
LGA    P    51_A      N      76          2.242
LGA    D    52_A      D      77          1.528
LGA    I    53_A      L      78          0.837
LGA    K    54_A      K      79          1.469
LGA    V    55_A      V      80          0.596
LGA    V    56_A      I      81          0.353
LGA    I    57_A      I      82          0.281
LGA    V    58_A      I      83          0.335
LGA    X    59_A      S      84          0.570
LGA    S    60_A      A      85          0.646
LGA    D    61_A      E      86          1.698
LGA    V    62_A      G      87          2.245
LGA    P    63_A      -       -           -
LGA    K    64_A      P      88          0.651
LGA    F    65_A      V      89          1.111
LGA    F    66_A      F      90          0.965
LGA    S    67_A      S      91          0.676
LGA    A    68_A      S      92          0.868
LGA    G    69_A      G      93          0.609
LGA    A    70_A      H      94          0.732
LGA    D    71_A      D      95          1.322
LGA    I    72_A      L      96          1.688
LGA    N    73_A      K      97          2.305
LGA    F    74_A      E      98          2.812
LGA    L    75_A      L      99          2.805
LGA    R    76_A      T     100          2.416
LGA    -       -      E     101           -
LGA    S    77_A      E     102          4.449
LGA    A    78_A      Q     103          2.105
LGA    D    79_A      G     104          1.581
LGA    P    80_A      R     105          2.658
LGA    R    81_A      D     106          3.208
LGA    F    82_A      Y     107          1.961
LGA    K    83_A      H     108          0.810
LGA    T    84_A      A     109          1.937
LGA    Q    85_A      E     110          2.706
LGA    F    86_A      V     111          1.917
LGA    C    87_A      F     112          0.679
LGA    L    88_A      Q     113          1.412
LGA    F    89_A      T     114          2.009
LGA    C    90_A      C     115          1.249
LGA    N    91_A      S     116          0.520
LGA    E    92_A      K     117          1.710
LGA    T    93_A      V     118          1.935
LGA    L    94_A      M     119          1.032
LGA    D    95_A      M     120          0.942
LGA    K    96_A      H     121          1.416
LGA    I    97_A      I     122          1.239
LGA    A    98_A      R     123          1.076
LGA    R    99_A      N     124          0.959
LGA    S   100_A      H     125          0.972
LGA    P   101_A      P     126          1.118
LGA    Q   102_A      V     127          0.607
LGA    V   103_A      P     128          0.350
LGA    Y   104_A      V     129          0.478
LGA    I   105_A      I     130          0.344
LGA    A   106_A      A     131          0.217
LGA    C   107_A      M     132          0.198
LGA    L   108_A      V     133          0.337
LGA    E   109_A      N     134          0.845
LGA    G   110_A      G     135          1.541
LGA    H   111_A      L     136          0.802
LGA    T   112_A      A     137          0.815
LGA    V   113_A      T     138          0.906
LGA    G   114_A      A     139          0.838
LGA    G   115_A      A     140          0.845
LGA    G   116_A      G     141          0.566
LGA    L   117_A      C     142          0.670
LGA    E   118_A      Q     143          0.610
LGA    X   119_A      L     144          1.001
LGA    A   120_A      V     145          1.020
LGA    L   121_A      A     146          1.344
LGA    A   122_A      S     147          1.220
LGA    C   123_A      C     148          0.928
LGA    D   124_A      D     149          0.549
LGA    L   125_A      I     150          1.069
LGA    R   126_A      A     151          0.908
LGA    F   127_A      V     152          0.509
LGA    X   128_A      A     153          0.294
LGA    G   129_A      S     154          0.314
LGA    D   130_A      D     155          1.065
LGA    E   131_A      K     156          1.779
LGA    A   132_A      S     157          2.539
LGA    G   133_A      -       -           -
LGA    K   134_A      S     158          2.229
LGA    I   135_A      F     159          0.778
LGA    G   136_A      A     160          1.524
LGA    L   137_A      T     161          0.837
LGA    P   138_A      P     162          0.795
LGA    E   139_A      G     163          0.886
LGA    V   140_A      V     164          1.193
LGA    S   141_A      N     165          0.926
LGA    L   142_A      V     166          1.013
LGA    G   143_A      G     167          1.072
LGA    V   144_A      L     168          1.382
LGA    L   145_A      F     169          1.809
LGA    A   146_A      C     170          1.836
LGA    G   147_A      S     171          3.610
LGA    T   148_A      -       -           -
LGA    G   149_A      T     172          3.489
LGA    G   150_A      P     173          1.523
LGA    T   151_A      G     174          1.168
LGA    Q   152_A      V     175          1.880
LGA    R   153_A      A     176          1.861
LGA    L   154_A      L     177          0.996
LGA    A   155_A      A     178          1.242
LGA    R   156_A      R     179          1.892
LGA    L   157_A      A     180          1.604
LGA    I   158_A      V     181          0.945
LGA    G   159_A      P     182          1.821
LGA    Y   160_A      R     183          2.055
LGA    S   161_A      K     184          2.600
LGA    R   162_A      V     185          2.059
LGA    A   163_A      A     186          0.883
LGA    L   164_A      L     187          1.311
LGA    D   165_A      E     188          1.561
LGA    X   166_A      M     189          1.133
LGA    N   167_A      L     190          0.644
LGA    I   168_A      F     191          0.679
LGA    T   169_A      T     192          0.784
LGA    G   170_A      G     193          0.960
LGA    E   171_A      E     194          0.818
LGA    T   172_A      P     195          0.391
LGA    I   173_A      I     196          1.180
LGA    T   174_A      S     197          1.047
LGA    P   175_A      A     198          0.907
LGA    Q   176_A      Q     199          0.945
LGA    E   177_A      E     200          1.323
LGA    A   178_A      A     201          1.156
LGA    L   179_A      L     202          0.809
LGA    E   180_A      L     203          1.111
LGA    I   181_A      H     204          1.060
LGA    G   182_A      G     205          1.273
LGA    L   183_A      L     206          1.095
LGA    V   184_A      L     207          0.623
LGA    N   185_A      S     208          0.778
LGA    R   186_A      K     209          0.295
LGA    V   187_A      V     210          0.203
LGA    F   188_A      V     211          1.090
LGA    P   189_A      P     212          1.002
LGA    Q   190_A      E     213          0.608
LGA    A   191_A      A     214          1.639
LGA    E   192_A      E     215          1.722
LGA    T   193_A      L     216          0.609
LGA    R   194_A      Q     217          1.390
LGA    E   195_A      E     218          1.733
LGA    R   196_A      E     219          1.234
LGA    T   197_A      T     220          0.220
LGA    R   198_A      M     221          1.114
LGA    E   199_A      R     222          1.716
LGA    Y   200_A      I     223          1.270
LGA    A   201_A      A     224          0.451
LGA    R   202_A      R     225          0.257
LGA    K   203_A      K     226          0.934
LGA    L   204_A      I     227          1.048
LGA    A   205_A      A     228          0.688
LGA    N   206_A      S     229          0.557
LGA    S   207_A      L     230          1.915
LGA    A   208_A      S     231          2.811
LGA    T   209_A      R     232          3.095
LGA    Y   210_A      P     233          2.492
LGA    A   211_A      V     234          2.274
LGA    V   212_A      V     235          2.177
LGA    S   213_A      S     236          2.148
LGA    N   214_A      L     237          1.857
LGA    I   215_A      G     238          1.906
LGA    K   216_A      K     239          1.784
LGA    L   217_A      A     240          1.698
LGA    A   218_A      T     241          1.900
LGA    I   219_A      F     242          1.920
LGA    X   220_A      Y     243          2.329
LGA    N   221_A      K     244          2.988
LGA    G   222_A      Q     245          2.151
LGA    K   223_A      L     246          1.356
LGA    E   224_A      P     247          2.363
LGA    X   225_A      Q     248          2.449
LGA    P   226_A      D     249          2.505
LGA    L   227_A      L     250          2.374
LGA    N   228_A      G     251          1.997
LGA    V   229_A      T     252          1.872
LGA    A   230_A      A     253          2.345
LGA    I   231_A      Y     254          2.551
LGA    R   232_A      Y     255          2.958
LGA    Y   233_A      L     256          2.879
LGA    E   234_A      T     257          1.973
LGA    G   235_A      S     258          3.054
LGA    E   236_A      Q     259          3.765
LGA    L   237_A      A     260          2.869
LGA    Q   238_A      M     261          2.342
LGA    N   239_A      V     262          3.158
LGA    L   240_A      D     263          2.981
LGA    L   241_A      N     264          1.364
LGA    F   242_A      L     265          1.042
LGA    R   243_A      A     266          1.550
LGA    S   244_A      L     267          1.324
LGA    E   245_A      R     268          1.446
LGA    D   246_A      D     269          1.250
LGA    A   247_A      G     270          1.223
LGA    K   248_A      Q     271          1.126
LGA    E   249_A      E     272          0.935
LGA    G   250_A      G     273          0.942
LGA    L   251_A      I     274          1.094
LGA    S   252_A      T     275          0.949
LGA    A   253_A      A     276          1.142
LGA    F   254_A      F     277          1.268
LGA    L   255_A      L     278          1.192
LGA    E   256_A      Q     279          1.006
LGA    K   257_A      K     280          1.109
LGA    R   258_A      R     281          1.272
LGA    Q   259_A      K     282          1.624
LGA    P   260_A      P     283          1.568
LGA    N   261_A      V     284          1.500
LGA    W   262_A      W     285          2.002
LGA    K   263_A      S     286          2.239
LGA    G   264_A      H     287          2.434
LGA    I   265_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  264  256    5.0    254    1.64    28.35     90.397    14.604

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.376071 * X  +  -0.053030 * Y  +   0.925072 * Z  + -68.434517
  Y_new =  -0.074748 * X  +   0.993371 * Y  +   0.087332 * Z  +  59.319336
  Z_new =  -0.923571 * X  +  -0.101990 * Y  +   0.369614 * Z  +  55.990345 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.269238    2.872355  [ DEG:   -15.4262    164.5738 ]
  Theta =   1.177292    1.964301  [ DEG:    67.4538    112.5462 ]
  Phi   =  -0.196203    2.945389  [ DEG:   -11.2416    168.7584 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ppy_A                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ppy_A.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  264  256   5.0  254   1.64   28.35  90.397
REMARK  ---------------------------------------------------------- 
MOLECULE 2ppy_A
HEADER    LYASE                                   01-MAY-07   2PPY              
TITLE     CRYSTAL STRUCTURE OF ENOYL-COA HYDRATES (GK_1992) FROM                
TITLE    2 GEOBACILLUS KAUSTOPHILUS HTA426                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ENOYL-COA HYDRATASE;                                       
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 EC: 4.2.1.17;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: GEOBACILLUS KAUSTOPHILUS;                       
SOURCE   3 STRAIN: HTA426;                                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: ROSETTA834(DE3);                           
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    BETA-OXIDATION, COA, ENOYL-COA HYDRATASE, FATTY ACID                  
KEYWDS   2 METABOLISM, LYASE, STRUCTURAL GENOMICS, NPPSFA, NATIONAL             
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.P.KANAUJIA,J.JEYAKANTHAN,M.KAVYASHREE,K.SEKAR,A.EBIHARA,            
AUTHOR   2 S.KURAMITSU,A.SHINKAI,Y.SHIRO,S.YOKOYAMA,RIKEN STRUCTURAL            
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   06-MAY-08 2PPY    0                                                
JRNL        AUTH   S.P.KANAUJIA,J.JEYAKANTHAN,M.KAVYASHREE,K.SEKAR,             
JRNL        AUTH 2 A.EBIHARA,S.KURAMITSU,A.SHINKAI,Y.SHIRO,S.YOKOYAMA           
JRNL        TITL   CRYSTAL STRUCTURE OF ENOYL-COA HYDRATES (GK_1992)            
JRNL        TITL 2 FROM GEOBACILLUS KAUSTOPHILUS HTA426                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.16 ANGSTROMS.                                          
DBREF  2PPY A    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY B    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY C    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY D    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY E    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY F    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
SEQRES   1 A  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 A  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 A  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 A  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 A  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 A  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 A  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 A  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 A  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 A  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 A  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 A  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 A  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 A  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 A  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 A  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 A  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 A  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 A  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 A  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 A  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 B  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 B  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 B  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 B  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 B  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 B  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 B  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 B  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 B  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 B  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 B  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 B  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 B  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 B  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 B  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 B  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 B  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 B  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 B  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 B  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 B  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 C  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 C  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 C  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 C  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 C  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 C  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 C  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 C  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 C  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 C  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 C  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 C  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 C  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 C  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 C  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 C  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 C  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 C  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 C  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 C  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 C  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 D  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 D  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 D  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 D  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 D  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 D  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 D  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 D  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 D  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 D  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 D  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 D  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 D  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 D  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 D  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 D  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 D  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 D  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 D  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 D  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 D  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 E  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 E  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 E  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 E  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 E  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 E  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 E  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 E  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 E  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 E  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 E  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 E  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 E  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 E  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 E  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 E  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 E  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 E  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 E  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 E  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 E  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 F  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 F  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 F  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 F  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 F  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 F  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 F  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 F  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 F  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 F  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 F  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 F  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 F  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 F  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 F  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 F  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 F  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 F  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 F  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 F  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 F  265  ASN TRP LYS GLY ILE                                          
HET    MSE  A  59       8                                                       
HET    MSE  A 119       8                                                       
HET    MSE  A 128       8                                                       
HET    MSE  A 166       8                                                       
HET    MSE  A 220       8                                                       
HET    MSE  A 225       8                                                       
HET    MSE  B  59       8                                                       
HET    MSE  B 119       8                                                       
HET    MSE  B 128       8                                                       
HET    MSE  B 166       8                                                       
HET    MSE  B 220       8                                                       
HET    MSE  B 225       8                                                       
HET    MSE  C  59       8                                                       
HET    MSE  C 119       8                                                       
HET    MSE  C 128       8                                                       
HET    MSE  C 166       8                                                       
HET    MSE  C 220       8                                                       
HET    MSE  C 225       8                                                       
HET    MSE  D  59       8                                                       
HET    MSE  D 119       8                                                       
HET    MSE  D 128       8                                                       
HET    MSE  D 166       8                                                       
HET    MSE  D 220       8                                                       
HET    MSE  D 225       8                                                       
HET    MSE  E  59       8                                                       
HET    MSE  E 119       8                                                       
HET    MSE  E 128       8                                                       
HET    MSE  E 166       8                                                       
HET    MSE  E 220       8                                                       
HET    MSE  E 225       8                                                       
HET    MSE  F  59       8                                                       
HET    MSE  F 119       8                                                       
HET    MSE  F 128       8                                                       
HET    MSE  F 166       8                                                       
HET    MSE  F 220       8                                                       
HET    MSE  F 225       8                                                       
HET    EDO  C 266       4                                                       
HET    EDO  D 266       4                                                       
HET    PEG  B 266       7                                                       
HET    PEG  B 267       7                                                       
HET    PEG  C 267       7                                                       
HET    PEG  C 268       7                                                       
HET    PEG  F 266       7                                                       
HET    PEG  F 267       7                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    36(C5 H11 N O2 SE)                                           
FORMUL   7  EDO    2(C2 H6 O2)                                                  
FORMUL   9  PEG    6(C4 H10 O3)                                                 
FORMUL  15  HOH   *1098(H2 O)                                                   
CRYST1  136.201  137.345   79.131  90.00  90.00  90.00 P 21 21 2    24          
ATOM      1  N   THR A   2     -42.407  97.735  15.648  1.00 89.14           N  
ATOM      2  CA  THR A   2     -41.407  96.665  15.933  1.00 90.92           C  
ATOM      3  C   THR A   2     -40.073  97.237  16.403  1.00 93.40           C  
ATOM      4  O   THR A   2     -39.612  96.935  17.506  1.00 92.91           O  
ATOM      5  CB  THR A   2     -41.154  95.795  14.687  1.00 89.80           C  
ATOM      6  OG1 THR A   2     -40.061  94.904  14.939  1.00 89.91           O  
ATOM      7  CG2 THR A   2     -40.828  96.665  13.487  1.00 89.43           C  
ATOM      8  N   ALA A   3     -39.456  98.060  15.560  1.00 95.74           N  
ATOM      9  CA  ALA A   3     -38.175  98.680  15.881  1.00 96.53           C  
ATOM     10  C   ALA A   3     -38.395  99.980  16.648  1.00 97.93           C  
ATOM     11  O   ALA A   3     -39.023 100.910  16.140  1.00 98.57           O  
ATOM     12  CB  ALA A   3     -37.395  98.955  14.599  1.00 93.58           C  
ATOM     13  N   VAL A   4     -37.878 100.038  17.873  1.00 98.89           N  
ATOM     14  CA  VAL A   4     -38.024 101.225  18.710  1.00 98.22           C  
ATOM     15  C   VAL A   4     -36.873 102.206  18.540  1.00 97.25           C  
ATOM     16  O   VAL A   4     -35.727 101.810  18.325  1.00 95.61           O  
ATOM     17  CB  VAL A   4     -38.136 100.847  20.200  1.00 99.08           C  
ATOM     18  CG1 VAL A   4     -39.455 100.140  20.456  1.00100.42           C  
ATOM     19  CG2 VAL A   4     -36.969  99.959  20.601  1.00 99.08           C  
ATOM     20  N   GLU A   5     -37.195 103.492  18.644  1.00 97.20           N  
ATOM     21  CA  GLU A   5     -36.211 104.556  18.488  1.00 96.69           C  
ATOM     22  C   GLU A   5     -36.470 105.658  19.517  1.00 95.22           C  
ATOM     23  O   GLU A   5     -37.586 106.163  19.629  1.00 96.03           O  
ATOM     24  CB  GLU A   5     -36.310 105.141  17.075  1.00 98.64           C  
ATOM     25  CG  GLU A   5     -36.390 104.087  15.976  1.00100.33           C  
ATOM     26  CD  GLU A   5     -36.841 104.658  14.643  1.00100.30           C  
ATOM     27  OE1 GLU A   5     -37.924 105.279  14.598  1.00100.42           O  
ATOM     28  OE2 GLU A   5     -36.120 104.480  13.639  1.00100.42           O  
ATOM     29  N   THR A   6     -35.436 106.018  20.269  1.00 92.83           N  
ATOM     30  CA  THR A   6     -35.544 107.067  21.278  1.00 89.92           C  
ATOM     31  C   THR A   6     -34.495 108.130  20.958  1.00 89.86           C  
ATOM     32  O   THR A   6     -33.343 107.804  20.665  1.00 88.16           O  
ATOM     33  CB  THR A   6     -35.316 106.497  22.697  1.00 88.08           C  
ATOM     34  OG1 THR A   6     -35.416 107.550  23.663  1.00 87.62           O  
ATOM     35  CG2 THR A   6     -33.950 105.842  22.798  1.00 87.02           C  
ATOM     36  N   LYS A   7     -34.886 109.400  21.015  1.00 89.42           N  
ATOM     37  CA  LYS A   7     -33.967 110.479  20.669  1.00 90.00           C  
ATOM     38  C   LYS A   7     -33.830 111.612  21.682  1.00 88.34           C  
ATOM     39  O   LYS A   7     -34.711 111.848  22.509  1.00 87.89           O  
ATOM     40  CB  LYS A   7     -34.388 111.082  19.327  1.00 92.98           C  
ATOM     41  CG  LYS A   7     -34.838 110.051  18.308  1.00 97.46           C  
ATOM     42  CD  LYS A   7     -35.671 110.682  17.207  1.00 99.01           C  
ATOM     43  CE  LYS A   7     -36.278 109.617  16.308  1.00 99.16           C  
ATOM     44  NZ  LYS A   7     -37.231 110.198  15.325  1.00100.42           N  
ATOM     45  N   LYS A   8     -32.699 112.307  21.588  1.00 85.78           N  
ATOM     46  CA  LYS A   8     -32.383 113.459  22.423  1.00 83.29           C  
ATOM     47  C   LYS A   8     -31.813 114.494  21.459  1.00 77.50           C  
ATOM     48  O   LYS A   8     -32.010 114.374  20.251  1.00 79.30           O  
ATOM     49  CB  LYS A   8     -31.360 113.099  23.504  1.00 87.67           C  
ATOM     50  CG  LYS A   8     -31.955 112.319  24.672  1.00 92.30           C  
ATOM     51  CD  LYS A   8     -30.973 112.191  25.827  1.00 97.09           C  
ATOM     52  CE  LYS A   8     -31.640 111.576  27.051  1.00100.12           C  
ATOM     53  NZ  LYS A   8     -30.720 111.499  28.221  1.00 99.49           N  
ATOM     54  N   GLN A   9     -31.111 115.502  21.966  1.00 70.41           N  
ATOM     55  CA  GLN A   9     -30.558 116.519  21.076  1.00 62.62           C  
ATOM     56  C   GLN A   9     -29.122 116.269  20.634  1.00 56.91           C  
ATOM     57  O   GLN A   9     -28.725 116.691  19.548  1.00 60.87           O  
ATOM     58  CB  GLN A   9     -30.660 117.908  21.713  1.00 60.70           C  
ATOM     59  CG  GLN A   9     -30.212 117.987  23.159  1.00 58.89           C  
ATOM     60  CD  GLN A   9     -30.119 119.421  23.648  1.00 63.62           C  
ATOM     61  OE1 GLN A   9     -30.799 120.309  23.131  1.00 63.16           O  
ATOM     62  NE2 GLN A   9     -29.284 119.653  24.656  1.00 59.60           N  
ATOM     63  N   TYR A  10     -28.347 115.580  21.464  1.00 48.42           N  
ATOM     64  CA  TYR A  10     -26.951 115.299  21.140  1.00 40.37           C  
ATOM     65  C   TYR A  10     -26.764 113.935  20.492  1.00 34.42           C  
ATOM     66  O   TYR A  10     -25.812 113.719  19.740  1.00 31.34           O  
ATOM     67  CB  TYR A  10     -26.094 115.360  22.403  1.00 36.84           C  
ATOM     68  CG  TYR A  10     -25.977 116.728  23.025  1.00 36.08           C  
ATOM     69  CD1 TYR A  10     -25.055 117.656  22.548  1.00 41.41           C  
ATOM     70  CD2 TYR A  10     -26.770 117.087  24.111  1.00 37.66           C  
ATOM     71  CE1 TYR A  10     -24.921 118.909  23.142  1.00 43.24           C  
ATOM     72  CE2 TYR A  10     -26.643 118.335  24.710  1.00 39.32           C  
ATOM     73  CZ  TYR A  10     -25.719 119.240  24.224  1.00 39.20           C  
ATOM     74  OH  TYR A  10     -25.586 120.469  24.826  1.00 46.52           O  
ATOM     75  N   LEU A  11     -27.670 113.010  20.784  1.00 32.50           N  
ATOM     76  CA  LEU A  11     -27.555 111.670  20.237  1.00 30.34           C  
ATOM     77  C   LEU A  11     -28.893 110.952  20.205  1.00 29.63           C  
ATOM     78  O   LEU A  11     -29.841 111.354  20.879  1.00 24.43           O  
ATOM     79  CB  LEU A  11     -26.540 110.874  21.076  1.00 31.93           C  
ATOM     80  CG  LEU A  11     -26.904 109.688  21.988  1.00 36.37           C  
ATOM     81  CD1 LEU A  11     -25.708 109.417  22.895  1.00 37.59           C  
ATOM     82  CD2 LEU A  11     -28.116 109.968  22.853  1.00 34.28           C  
ATOM     83  N   THR A  12     -28.955 109.878  19.423  1.00 29.86           N  
ATOM     84  CA  THR A  12     -30.158 109.067  19.301  1.00 28.02           C  
ATOM     85  C   THR A  12     -29.797 107.591  19.442  1.00 29.15           C  
ATOM     86  O   THR A  12     -28.790 107.132  18.901  1.00 30.83           O  
ATOM     87  CB  THR A  12     -30.845 109.287  17.935  1.00 31.86           C  
ATOM     88  OG1 THR A  12     -31.299 110.640  17.842  1.00 34.48           O  
ATOM     89  CG2 THR A  12     -32.032 108.352  17.771  1.00 29.26           C  
ATOM     90  N   VAL A  13     -30.619 106.850  20.178  1.00 28.65           N  
ATOM     91  CA  VAL A  13     -30.387 105.426  20.378  1.00 25.92           C  
ATOM     92  C   VAL A  13     -31.454 104.617  19.648  1.00 27.40           C  
ATOM     93  O   VAL A  13     -32.648 104.854  19.821  1.00 30.35           O  
ATOM     94  CB  VAL A  13     -30.425 105.047  21.882  1.00 25.41           C  
ATOM     95  CG1 VAL A  13     -30.196 103.550  22.047  1.00 26.09           C  
ATOM     96  CG2 VAL A  13     -29.370 105.825  22.647  1.00 26.60           C  
ATOM     97  N   PHE A  14     -31.010 103.670  18.829  1.00 23.89           N  
ATOM     98  CA  PHE A  14     -31.906 102.797  18.077  1.00 25.94           C  
ATOM     99  C   PHE A  14     -31.692 101.373  18.579  1.00 29.73           C  
ATOM    100  O   PHE A  14     -30.553 100.921  18.697  1.00 31.85           O  
ATOM    101  CB  PHE A  14     -31.582 102.849  16.580  1.00 32.33           C  
ATOM    102  CG  PHE A  14     -31.823 104.188  15.946  1.00 36.92           C  
ATOM    103  CD1 PHE A  14     -33.116 104.666  15.763  1.00 38.10           C  
ATOM    104  CD2 PHE A  14     -30.754 104.972  15.521  1.00 39.79           C  
ATOM    105  CE1 PHE A  14     -33.344 105.908  15.163  1.00 39.95           C  
ATOM    106  CE2 PHE A  14     -30.968 106.214  14.921  1.00 39.70           C  
ATOM    107  CZ  PHE A  14     -32.267 106.682  14.743  1.00 41.46           C  
ATOM    108  N   LYS A  15     -32.779 100.667  18.879  1.00 30.16           N  
ATOM    109  CA  LYS A  15     -32.677  99.294  19.360  1.00 27.03           C  
ATOM    110  C   LYS A  15     -33.423  98.353  18.433  1.00 32.64           C  
ATOM    111  O   LYS A  15     -34.578  98.602  18.081  1.00 30.63           O  
ATOM    112  CB  LYS A  15     -33.253  99.162  20.770  1.00 23.27           C  
ATOM    113  CG  LYS A  15     -32.473  99.899  21.851  1.00 24.25           C  
ATOM    114  CD  LYS A  15     -33.080  99.603  23.207  1.00 29.91           C  
ATOM    115  CE  LYS A  15     -32.430 100.407  24.318  1.00 34.91           C  
ATOM    116  NZ  LYS A  15     -33.065 100.091  25.631  1.00 31.21           N  
ATOM    117  N   GLU A  16     -32.767  97.266  18.048  1.00 32.29           N  
ATOM    118  CA  GLU A  16     -33.383  96.302  17.155  1.00 37.23           C  
ATOM    119  C   GLU A  16     -32.612  94.989  17.132  1.00 34.63           C  
ATOM    120  O   GLU A  16     -31.395  94.976  16.979  1.00 36.99           O  
ATOM    121  CB  GLU A  16     -33.462  96.897  15.745  1.00 43.33           C  
ATOM    122  CG  GLU A  16     -34.196  96.048  14.725  1.00 55.22           C  
ATOM    123  CD  GLU A  16     -34.409  96.786  13.413  1.00 65.67           C  
ATOM    124  OE1 GLU A  16     -33.408  97.206  12.790  1.00 67.58           O  
ATOM    125  OE2 GLU A  16     -35.580  96.947  13.004  1.00 67.65           O  
ATOM    126  N   ASP A  17     -33.339  93.892  17.304  1.00 34.56           N  
ATOM    127  CA  ASP A  17     -32.773  92.545  17.289  1.00 36.38           C  
ATOM    128  C   ASP A  17     -31.451  92.348  18.032  1.00 35.67           C  
ATOM    129  O   ASP A  17     -30.485  91.823  17.471  1.00 31.38           O  
ATOM    130  CB  ASP A  17     -32.623  92.068  15.843  1.00 42.72           C  
ATOM    131  CG  ASP A  17     -33.961  91.886  15.150  1.00 49.21           C  
ATOM    132  OD1 ASP A  17     -34.769  91.061  15.632  1.00 50.20           O  
ATOM    133  OD2 ASP A  17     -34.206  92.567  14.129  1.00 49.72           O  
ATOM    134  N   GLY A  18     -31.414  92.760  19.295  1.00 34.80           N  
ATOM    135  CA  GLY A  18     -30.210  92.589  20.090  1.00 34.29           C  
ATOM    136  C   GLY A  18     -29.069  93.554  19.819  1.00 29.55           C  
ATOM    137  O   GLY A  18     -27.971  93.379  20.348  1.00 32.59           O  
ATOM    138  N   ILE A  19     -29.315  94.567  18.997  1.00 26.47           N  
ATOM    139  CA  ILE A  19     -28.287  95.554  18.689  1.00 24.09           C  
ATOM    140  C   ILE A  19     -28.804  96.961  18.957  1.00 26.39           C  
ATOM    141  O   ILE A  19     -29.957  97.279  18.663  1.00 26.34           O  
ATOM    142  CB  ILE A  19     -27.849  95.482  17.212  1.00 24.78           C  
ATOM    143  CG1 ILE A  19     -27.238  94.112  16.911  1.00 28.21           C  
ATOM    144  CG2 ILE A  19     -26.845  96.586  16.912  1.00 18.67           C  
ATOM    145  CD1 ILE A  19     -26.900  93.904  15.448  1.00 18.38           C  
ATOM    146  N   ALA A  20     -27.947  97.798  19.531  1.00 21.28           N  
ATOM    147  CA  ALA A  20     -28.308  99.178  19.809  1.00 19.07           C  
ATOM    148  C   ALA A  20     -27.301 100.052  19.091  1.00 21.11           C  
ATOM    149  O   ALA A  20     -26.103  99.774  19.109  1.00 25.92           O  
ATOM    150  CB  ALA A  20     -28.266  99.455  21.308  1.00 16.17           C  
ATOM    151  N   GLU A  21     -27.784 101.096  18.432  1.00 21.62           N  
ATOM    152  CA  GLU A  21     -26.892 101.998  17.729  1.00 21.12           C  
ATOM    153  C   GLU A  21     -27.025 103.367  18.357  1.00 24.84           C  
ATOM    154  O   GLU A  21     -28.122 103.909  18.460  1.00 22.34           O  
ATOM    155  CB  GLU A  21     -27.244 102.092  16.243  1.00 21.29           C  
ATOM    156  CG  GLU A  21     -27.327 100.769  15.516  1.00 25.27           C  
ATOM    157  CD  GLU A  21     -27.333 100.943  14.005  1.00 25.61           C  
ATOM    158  OE1 GLU A  21     -27.801 101.997  13.529  1.00 31.23           O  
ATOM    159  OE2 GLU A  21     -26.878 100.023  13.293  1.00 26.86           O  
ATOM    160  N   ILE A  22     -25.900 103.916  18.794  1.00 25.58           N  
ATOM    161  CA  ILE A  22     -25.896 105.236  19.393  1.00 22.44           C  
ATOM    162  C   ILE A  22     -25.376 106.181  18.321  1.00 26.23           C  
ATOM    163  O   ILE A  22     -24.179 106.191  18.016  1.00 21.53           O  
ATOM    164  CB  ILE A  22     -24.971 105.292  20.627  1.00 18.93           C  
ATOM    165  CG1 ILE A  22     -25.374 104.212  21.637  1.00 14.55           C  
ATOM    166  CG2 ILE A  22     -25.056 106.670  21.266  1.00 18.32           C  
ATOM    167  CD1 ILE A  22     -24.485 104.147  22.879  1.00 18.31           C  
ATOM    168  N   HIS A  23     -26.282 106.952  17.726  1.00 25.12           N  
ATOM    169  CA  HIS A  23     -25.895 107.894  16.686  1.00 24.00           C  
ATOM    170  C   HIS A  23     -25.578 109.244  17.295  1.00 24.80           C  
ATOM    171  O   HIS A  23     -26.361 109.781  18.074  1.00 23.77           O  
ATOM    172  CB  HIS A  23     -27.009 108.041  15.650  1.00 26.07           C  
ATOM    173  CG  HIS A  23     -27.177 106.842  14.771  1.00 27.12           C  
ATOM    174  ND1 HIS A  23     -26.911 106.867  13.418  1.00 28.88           N  
ATOM    175  CD2 HIS A  23     -27.578 105.579  15.053  1.00 24.14           C  
ATOM    176  CE1 HIS A  23     -27.144 105.672  12.905  1.00 32.53           C  
ATOM    177  NE2 HIS A  23     -27.550 104.873  13.875  1.00 32.43           N  
ATOM    178  N   LEU A  24     -24.422 109.788  16.935  1.00 26.88           N  
ATOM    179  CA  LEU A  24     -23.997 111.078  17.444  1.00 25.15           C  
ATOM    180  C   LEU A  24     -24.323 112.187  16.441  1.00 26.15           C  
ATOM    181  O   LEU A  24     -23.959 112.102  15.270  1.00 23.60           O  
ATOM    182  CB  LEU A  24     -22.490 111.057  17.714  1.00 25.36           C  
ATOM    183  CG  LEU A  24     -21.953 109.887  18.554  1.00 27.34           C  
ATOM    184  CD1 LEU A  24     -20.441 110.019  18.706  1.00 28.34           C  
ATOM    185  CD2 LEU A  24     -22.620 109.872  19.916  1.00 20.62           C  
ATOM    186  N   HIS A  25     -25.022 113.215  16.906  1.00 26.17           N  
ATOM    187  CA  HIS A  25     -25.382 114.357  16.070  1.00 29.83           C  
ATOM    188  C   HIS A  25     -25.346 115.613  16.934  1.00 31.33           C  
ATOM    189  O   HIS A  25     -26.380 116.164  17.291  1.00 33.27           O  
ATOM    190  CB  HIS A  25     -26.781 114.175  15.447  1.00 25.00           C  
ATOM    191  CG  HIS A  25     -27.841 113.778  16.430  1.00 19.13           C  
ATOM    192  ND1 HIS A  25     -28.389 112.515  16.458  1.00 28.00           N  
ATOM    193  CD2 HIS A  25     -28.464 114.480  17.407  1.00 18.92           C  
ATOM    194  CE1 HIS A  25     -29.305 112.455  17.409  1.00 20.70           C  
ATOM    195  NE2 HIS A  25     -29.368 113.634  18.001  1.00 23.39           N  
ATOM    196  N   ILE A  26     -24.142 116.067  17.259  1.00 29.86           N  
ATOM    197  CA  ILE A  26     -23.961 117.230  18.109  1.00 30.64           C  
ATOM    198  C   ILE A  26     -23.775 118.532  17.337  1.00 34.67           C  
ATOM    199  O   ILE A  26     -24.377 119.556  17.660  1.00 34.05           O  
ATOM    200  CB  ILE A  26     -22.743 117.043  19.022  1.00 28.19           C  
ATOM    201  CG1 ILE A  26     -22.809 115.673  19.699  1.00 30.40           C  
ATOM    202  CG2 ILE A  26     -22.694 118.144  20.065  1.00 21.57           C  
ATOM    203  CD1 ILE A  26     -21.482 115.218  20.280  1.00 32.77           C  
ATOM    204  N   ASN A  27     -22.916 118.491  16.328  1.00 30.83           N  
ATOM    205  CA  ASN A  27     -22.633 119.666  15.518  1.00 30.67           C  
ATOM    206  C   ASN A  27     -21.713 119.303  14.362  1.00 30.75           C  
ATOM    207  O   ASN A  27     -21.415 118.132  14.136  1.00 29.50           O  
ATOM    208  CB  ASN A  27     -22.001 120.784  16.376  1.00 27.13           C  
ATOM    209  CG  ASN A  27     -20.787 120.319  17.159  1.00 31.60           C  
ATOM    210  OD1 ASN A  27     -19.978 119.540  16.661  1.00 28.41           O  
ATOM    211  ND2 ASN A  27     -20.640 120.820  18.387  1.00 23.00           N  
ATOM    212  N   LYS A  28     -21.277 120.329  13.641  1.00 32.63           N  
ATOM    213  CA  LYS A  28     -20.424 120.153  12.476  1.00 32.77           C  
ATOM    214  C   LYS A  28     -19.287 119.150  12.644  1.00 31.59           C  
ATOM    215  O   LYS A  28     -18.964 118.409  11.709  1.00 31.51           O  
ATOM    216  CB  LYS A  28     -19.830 121.510  12.077  1.00 41.07           C  
ATOM    217  CG  LYS A  28     -19.101 122.186  13.248  1.00 52.55           C  
ATOM    218  CD  LYS A  28     -18.602 123.605  12.938  1.00 56.59           C  
ATOM    219  CE  LYS A  28     -19.194 124.193  11.671  1.00 56.06           C  
ATOM    220  NZ  LYS A  28     -18.725 125.608  11.485  1.00 60.13           N  
ATOM    221  N   SER A  29     -18.674 119.120  13.826  1.00 28.74           N  
ATOM    222  CA  SER A  29     -17.553 118.205  14.073  1.00 24.94           C  
ATOM    223  C   SER A  29     -17.774 117.338  15.311  1.00 26.58           C  
ATOM    224  O   SER A  29     -16.852 116.695  15.807  1.00 26.91           O  
ATOM    225  CB  SER A  29     -16.246 118.996  14.231  1.00 24.82           C  
ATOM    226  OG  SER A  29     -16.326 119.916  15.292  1.00 27.53           O  
ATOM    227  N   ASN A  30     -19.019 117.297  15.780  1.00 24.75           N  
ATOM    228  CA  ASN A  30     -19.378 116.542  16.970  1.00 23.25           C  
ATOM    229  C   ASN A  30     -18.491 116.880  18.163  1.00 25.60           C  
ATOM    230  O   ASN A  30     -18.096 115.988  18.919  1.00 23.46           O  
ATOM    231  CB  ASN A  30     -19.341 115.030  16.713  1.00 22.28           C  
ATOM    232  CG  ASN A  30     -20.620 114.516  16.078  1.00 25.40           C  
ATOM    233  OD1 ASN A  30     -21.716 114.955  16.423  1.00 25.18           O  
ATOM    234  ND2 ASN A  30     -20.487 113.567  15.160  1.00 26.11           N  
ATOM    235  N   SER A  31     -18.161 118.163  18.322  1.00 18.17           N  
ATOM    236  CA  SER A  31     -17.366 118.608  19.468  1.00 23.39           C  
ATOM    237  C   SER A  31     -18.332 118.605  20.643  1.00 25.99           C  
ATOM    238  O   SER A  31     -19.341 119.308  20.624  1.00 32.02           O  
ATOM    239  CB  SER A  31     -16.825 120.016  19.233  1.00 20.90           C  
ATOM    240  OG  SER A  31     -15.831 119.997  18.228  1.00 33.58           O  
ATOM    241  N   TYR A  32     -18.018 117.822  21.668  1.00 25.76           N  
ATOM    242  CA  TYR A  32     -18.911 117.678  22.816  1.00 20.13           C  
ATOM    243  C   TYR A  32     -18.671 118.561  24.029  1.00 20.41           C  
ATOM    244  O   TYR A  32     -17.638 119.219  24.152  1.00 21.14           O  
ATOM    245  CB  TYR A  32     -18.901 116.220  23.275  1.00 19.99           C  
ATOM    246  CG  TYR A  32     -17.538 115.742  23.728  1.00 16.38           C  
ATOM    247  CD1 TYR A  32     -16.697 115.032  22.867  1.00 15.54           C  
ATOM    248  CD2 TYR A  32     -17.077 116.021  25.015  1.00 16.61           C  
ATOM    249  CE1 TYR A  32     -15.426 114.611  23.286  1.00 16.57           C  
ATOM    250  CE2 TYR A  32     -15.812 115.609  25.438  1.00 19.35           C  
ATOM    251  CZ  TYR A  32     -14.995 114.906  24.571  1.00 18.35           C  
ATOM    252  OH  TYR A  32     -13.747 114.518  24.993  1.00 19.61           O  
ATOM    253  N   ASP A  33     -19.654 118.549  24.927  1.00 20.14           N  
ATOM    254  CA  ASP A  33     -19.605 119.294  26.182  1.00 22.33           C  
ATOM    255  C   ASP A  33     -20.040 118.337  27.293  1.00 21.06           C  
ATOM    256  O   ASP A  33     -20.138 117.132  27.070  1.00 22.65           O  
ATOM    257  CB  ASP A  33     -20.548 120.502  26.147  1.00 23.28           C  
ATOM    258  CG  ASP A  33     -21.970 120.123  25.777  1.00 26.37           C  
ATOM    259  OD1 ASP A  33     -22.366 118.957  25.991  1.00 28.24           O  
ATOM    260  OD2 ASP A  33     -22.702 121.001  25.280  1.00 33.65           O  
ATOM    261  N   LEU A  34     -20.315 118.866  28.481  1.00 19.95           N  
ATOM    262  CA  LEU A  34     -20.723 118.021  29.597  1.00 20.64           C  
ATOM    263  C   LEU A  34     -22.076 117.371  29.357  1.00 22.08           C  
ATOM    264  O   LEU A  34     -22.262 116.192  29.645  1.00 28.63           O  
ATOM    265  CB  LEU A  34     -20.763 118.825  30.906  1.00 18.77           C  
ATOM    266  CG  LEU A  34     -21.233 118.056  32.152  1.00 19.90           C  
ATOM    267  CD1 LEU A  34     -20.409 116.783  32.320  1.00 15.71           C  
ATOM    268  CD2 LEU A  34     -21.110 118.940  33.387  1.00 19.60           C  
ATOM    269  N   GLU A  35     -23.021 118.140  28.826  1.00 21.48           N  
ATOM    270  CA  GLU A  35     -24.354 117.622  28.566  1.00 23.77           C  
ATOM    271  C   GLU A  35     -24.324 116.413  27.626  1.00 23.18           C  
ATOM    272  O   GLU A  35     -25.112 115.479  27.784  1.00 22.35           O  
ATOM    273  CB  GLU A  35     -25.238 118.731  27.984  1.00 28.22           C  
ATOM    274  CG  GLU A  35     -26.718 118.403  27.961  1.00 40.66           C  
ATOM    275  CD  GLU A  35     -27.267 118.061  29.336  1.00 53.07           C  
ATOM    276  OE1 GLU A  35     -27.068 118.860  30.280  1.00 53.29           O  
ATOM    277  OE2 GLU A  35     -27.904 116.993  29.469  1.00 56.96           O  
ATOM    278  N   PHE A  36     -23.423 116.423  26.647  1.00 20.83           N  
ATOM    279  CA  PHE A  36     -23.335 115.290  25.734  1.00 23.28           C  
ATOM    280  C   PHE A  36     -23.008 114.023  26.505  1.00 21.47           C  
ATOM    281  O   PHE A  36     -23.673 113.000  26.348  1.00 20.19           O  
ATOM    282  CB  PHE A  36     -22.246 115.484  24.678  1.00 26.25           C  
ATOM    283  CG  PHE A  36     -21.840 114.195  24.009  1.00 26.76           C  
ATOM    284  CD1 PHE A  36     -22.731 113.516  23.182  1.00 25.79           C  
ATOM    285  CD2 PHE A  36     -20.593 113.627  24.258  1.00 28.58           C  
ATOM    286  CE1 PHE A  36     -22.391 112.278  22.621  1.00 24.37           C  
ATOM    287  CE2 PHE A  36     -20.243 112.389  23.702  1.00 22.66           C  
ATOM    288  CZ  PHE A  36     -21.144 111.717  22.881  1.00 18.43           C  
ATOM    289  N   TYR A  37     -21.966 114.094  27.331  1.00 24.64           N  
ATOM    290  CA  TYR A  37     -21.552 112.938  28.114  1.00 17.61           C  
ATOM    291  C   TYR A  37     -22.601 112.495  29.115  1.00 19.40           C  
ATOM    292  O   TYR A  37     -22.685 111.313  29.445  1.00 21.68           O  
ATOM    293  CB  TYR A  37     -20.215 113.214  28.803  1.00 19.70           C  
ATOM    294  CG  TYR A  37     -19.062 112.552  28.075  1.00 20.34           C  
ATOM    295  CD1 TYR A  37     -18.888 111.168  28.129  1.00 21.22           C  
ATOM    296  CD2 TYR A  37     -18.185 113.296  27.284  1.00 21.13           C  
ATOM    297  CE1 TYR A  37     -17.870 110.538  27.414  1.00 26.74           C  
ATOM    298  CE2 TYR A  37     -17.161 112.675  26.562  1.00 28.12           C  
ATOM    299  CZ  TYR A  37     -17.011 111.295  26.634  1.00 25.66           C  
ATOM    300  OH  TYR A  37     -16.000 110.672  25.936  1.00 25.39           O  
ATOM    301  N   LYS A  38     -23.411 113.436  29.590  1.00 16.86           N  
ATOM    302  CA  LYS A  38     -24.468 113.085  30.528  1.00 21.83           C  
ATOM    303  C   LYS A  38     -25.484 112.225  29.778  1.00 19.09           C  
ATOM    304  O   LYS A  38     -26.041 111.283  30.336  1.00 19.71           O  
ATOM    305  CB  LYS A  38     -25.119 114.352  31.096  1.00 20.91           C  
ATOM    306  CG  LYS A  38     -24.176 115.134  32.004  1.00 24.08           C  
ATOM    307  CD  LYS A  38     -24.681 116.528  32.335  1.00 35.02           C  
ATOM    308  CE  LYS A  38     -25.960 116.500  33.143  1.00 42.88           C  
ATOM    309  NZ  LYS A  38     -26.388 117.884  33.492  1.00 54.37           N  
ATOM    310  N   GLU A  39     -25.696 112.534  28.499  1.00 20.92           N  
ATOM    311  CA  GLU A  39     -26.627 111.762  27.682  1.00 19.49           C  
ATOM    312  C   GLU A  39     -26.009 110.422  27.284  1.00 20.25           C  
ATOM    313  O   GLU A  39     -26.687 109.395  27.290  1.00 17.18           O  
ATOM    314  CB  GLU A  39     -27.019 112.533  26.418  1.00 29.49           C  
ATOM    315  CG  GLU A  39     -27.693 113.879  26.670  1.00 40.32           C  
ATOM    316  CD  GLU A  39     -28.462 114.379  25.457  1.00 47.89           C  
ATOM    317  OE1 GLU A  39     -27.916 114.317  24.337  1.00 50.11           O  
ATOM    318  OE2 GLU A  39     -29.613 114.837  25.620  1.00 47.89           O  
ATOM    319  N   PHE A  40     -24.724 110.435  26.938  1.00 18.97           N  
ATOM    320  CA  PHE A  40     -24.031 109.209  26.548  1.00 19.38           C  
ATOM    321  C   PHE A  40     -24.017 108.241  27.734  1.00 18.71           C  
ATOM    322  O   PHE A  40     -24.203 107.031  27.568  1.00 17.93           O  
ATOM    323  CB  PHE A  40     -22.594 109.518  26.109  1.00 20.85           C  
ATOM    324  CG  PHE A  40     -21.905 108.363  25.430  1.00 24.86           C  
ATOM    325  CD1 PHE A  40     -22.408 107.837  24.246  1.00 27.88           C  
ATOM    326  CD2 PHE A  40     -20.757 107.800  25.975  1.00 28.19           C  
ATOM    327  CE1 PHE A  40     -21.774 106.771  23.608  1.00 31.02           C  
ATOM    328  CE2 PHE A  40     -20.115 106.731  25.345  1.00 31.31           C  
ATOM    329  CZ  PHE A  40     -20.627 106.215  24.161  1.00 25.33           C  
ATOM    330  N   ASN A  41     -23.800 108.786  28.929  1.00 15.83           N  
ATOM    331  CA  ASN A  41     -23.790 107.987  30.152  1.00 16.73           C  
ATOM    332  C   ASN A  41     -25.160 107.355  30.381  1.00 18.73           C  
ATOM    333  O   ASN A  41     -25.263 106.188  30.756  1.00 21.20           O  
ATOM    334  CB  ASN A  41     -23.444 108.866  31.356  1.00 17.40           C  
ATOM    335  CG  ASN A  41     -23.436 108.088  32.654  1.00 21.00           C  
ATOM    336  OD1 ASN A  41     -22.587 107.225  32.869  1.00 18.87           O  
ATOM    337  ND2 ASN A  41     -24.393 108.379  33.522  1.00 20.96           N  
ATOM    338  N   ALA A  42     -26.216 108.135  30.159  1.00 20.85           N  
ATOM    339  CA  ALA A  42     -27.583 107.643  30.334  1.00 20.91           C  
ATOM    340  C   ALA A  42     -27.884 106.512  29.356  1.00 17.46           C  
ATOM    341  O   ALA A  42     -28.556 105.542  29.706  1.00 21.35           O  
ATOM    342  CB  ALA A  42     -28.580 108.779  30.140  1.00 13.70           C  
ATOM    343  N   ALA A  43     -27.386 106.642  28.129  1.00 15.73           N  
ATOM    344  CA  ALA A  43     -27.601 105.624  27.106  1.00 16.65           C  
ATOM    345  C   ALA A  43     -26.945 104.320  27.545  1.00 20.43           C  
ATOM    346  O   ALA A  43     -27.511 103.235  27.389  1.00 22.39           O  
ATOM    347  CB  ALA A  43     -27.013 106.085  25.781  1.00 21.12           C  
ATOM    348  N   ILE A  44     -25.743 104.435  28.099  1.00 20.76           N  
ATOM    349  CA  ILE A  44     -25.017 103.266  28.578  1.00 18.98           C  
ATOM    350  C   ILE A  44     -25.813 102.581  29.688  1.00 19.82           C  
ATOM    351  O   ILE A  44     -26.036 101.367  29.637  1.00 22.01           O  
ATOM    352  CB  ILE A  44     -23.619 103.659  29.105  1.00 17.33           C  
ATOM    353  CG1 ILE A  44     -22.777 104.212  27.948  1.00 18.88           C  
ATOM    354  CG2 ILE A  44     -22.938 102.454  29.723  1.00 15.76           C  
ATOM    355  CD1 ILE A  44     -21.395 104.673  28.341  1.00 18.06           C  
ATOM    356  N   ASP A  45     -26.251 103.354  30.682  1.00 14.96           N  
ATOM    357  CA  ASP A  45     -27.030 102.786  31.782  1.00 21.87           C  
ATOM    358  C   ASP A  45     -28.308 102.138  31.257  1.00 23.14           C  
ATOM    359  O   ASP A  45     -28.655 101.021  31.646  1.00 29.03           O  
ATOM    360  CB  ASP A  45     -27.394 103.858  32.817  1.00 20.79           C  
ATOM    361  CG  ASP A  45     -26.211 104.280  33.662  1.00 23.22           C  
ATOM    362  OD1 ASP A  45     -25.278 103.469  33.828  1.00 24.73           O  
ATOM    363  OD2 ASP A  45     -26.220 105.418  34.176  1.00 21.57           O  
ATOM    364  N   ASP A  46     -29.003 102.842  30.370  1.00 20.36           N  
ATOM    365  CA  ASP A  46     -30.233 102.316  29.789  1.00 23.89           C  
ATOM    366  C   ASP A  46     -29.984 100.978  29.108  1.00 23.19           C  
ATOM    367  O   ASP A  46     -30.686 100.001  29.362  1.00 24.74           O  
ATOM    368  CB  ASP A  46     -30.800 103.282  28.753  1.00 25.86           C  
ATOM    369  CG  ASP A  46     -32.005 102.706  28.034  1.00 32.26           C  
ATOM    370  OD1 ASP A  46     -33.071 102.587  28.671  1.00 38.96           O  
ATOM    371  OD2 ASP A  46     -31.884 102.360  26.839  1.00 30.12           O  
ATOM    372  N   ILE A  47     -28.984 100.946  28.234  1.00 25.15           N  
ATOM    373  CA  ILE A  47     -28.646  99.737  27.501  1.00 17.82           C  
ATOM    374  C   ILE A  47     -28.250  98.587  28.420  1.00 21.69           C  
ATOM    375  O   ILE A  47     -28.585  97.432  28.149  1.00 16.18           O  
ATOM    376  CB  ILE A  47     -27.525 100.015  26.477  1.00 22.73           C  
ATOM    377  CG1 ILE A  47     -28.038 101.007  25.424  1.00 23.52           C  
ATOM    378  CG2 ILE A  47     -27.084  98.718  25.812  1.00 22.47           C  
ATOM    379  CD1 ILE A  47     -26.992 101.503  24.454  1.00 21.29           C  
ATOM    380  N   ARG A  48     -27.546  98.903  29.509  1.00 22.36           N  
ATOM    381  CA  ARG A  48     -27.123  97.886  30.471  1.00 18.75           C  
ATOM    382  C   ARG A  48     -28.330  97.176  31.071  1.00 19.57           C  
ATOM    383  O   ARG A  48     -28.349  95.956  31.195  1.00 23.58           O  
ATOM    384  CB  ARG A  48     -26.333  98.516  31.623  1.00 16.47           C  
ATOM    385  CG  ARG A  48     -24.856  98.754  31.391  1.00 19.92           C  
ATOM    386  CD  ARG A  48     -24.290  99.460  32.618  1.00 24.20           C  
ATOM    387  NE  ARG A  48     -22.832  99.541  32.639  1.00 18.69           N  
ATOM    388  CZ  ARG A  48     -22.139  99.974  33.686  1.00 21.24           C  
ATOM    389  NH1 ARG A  48     -22.775 100.362  34.784  1.00 19.52           N  
ATOM    390  NH2 ARG A  48     -20.815 100.013  33.645  1.00 23.03           N  
ATOM    391  N   PHE A  49     -29.334  97.956  31.460  1.00 18.47           N  
ATOM    392  CA  PHE A  49     -30.531  97.401  32.073  1.00 24.90           C  
ATOM    393  C   PHE A  49     -31.503  96.805  31.063  1.00 29.04           C  
ATOM    394  O   PHE A  49     -32.618  96.429  31.419  1.00 34.39           O  
ATOM    395  CB  PHE A  49     -31.227  98.477  32.916  1.00 24.69           C  
ATOM    396  CG  PHE A  49     -30.615  98.666  34.276  1.00 22.99           C  
ATOM    397  CD1 PHE A  49     -31.102  97.963  35.377  1.00 28.70           C  
ATOM    398  CD2 PHE A  49     -29.545  99.535  34.460  1.00 28.43           C  
ATOM    399  CE1 PHE A  49     -30.535  98.124  36.640  1.00 24.69           C  
ATOM    400  CE2 PHE A  49     -28.970  99.703  35.719  1.00 26.39           C  
ATOM    401  CZ  PHE A  49     -29.468  98.996  36.810  1.00 28.71           C  
ATOM    402  N   ASP A  50     -31.078  96.718  29.807  1.00 28.38           N  
ATOM    403  CA  ASP A  50     -31.911  96.146  28.752  1.00 27.61           C  
ATOM    404  C   ASP A  50     -31.298  94.814  28.327  1.00 27.59           C  
ATOM    405  O   ASP A  50     -30.422  94.775  27.469  1.00 31.49           O  
ATOM    406  CB  ASP A  50     -31.971  97.089  27.551  1.00 26.55           C  
ATOM    407  CG  ASP A  50     -32.986  96.644  26.511  1.00 24.01           C  
ATOM    408  OD1 ASP A  50     -33.348  95.450  26.502  1.00 25.15           O  
ATOM    409  OD2 ASP A  50     -33.411  97.488  25.695  1.00 28.26           O  
ATOM    410  N   PRO A  51     -31.772  93.702  28.915  1.00 29.65           N  
ATOM    411  CA  PRO A  51     -31.321  92.328  28.663  1.00 31.75           C  
ATOM    412  C   PRO A  51     -31.263  91.897  27.200  1.00 33.65           C  
ATOM    413  O   PRO A  51     -30.475  91.025  26.835  1.00 34.23           O  
ATOM    414  CB  PRO A  51     -32.325  91.485  29.448  1.00 31.76           C  
ATOM    415  CG  PRO A  51     -32.748  92.391  30.544  1.00 40.16           C  
ATOM    416  CD  PRO A  51     -32.928  93.697  29.826  1.00 35.53           C  
ATOM    417  N   ASP A  52     -32.097  92.504  26.366  1.00 33.68           N  
ATOM    418  CA  ASP A  52     -32.145  92.134  24.958  1.00 32.71           C  
ATOM    419  C   ASP A  52     -30.994  92.657  24.113  1.00 27.11           C  
ATOM    420  O   ASP A  52     -30.725  92.116  23.041  1.00 27.57           O  
ATOM    421  CB  ASP A  52     -33.475  92.585  24.346  1.00 37.64           C  
ATOM    422  CG  ASP A  52     -34.674  91.934  25.012  1.00 45.51           C  
ATOM    423  OD1 ASP A  52     -34.714  90.686  25.088  1.00 43.84           O  
ATOM    424  OD2 ASP A  52     -35.578  92.674  25.457  1.00 50.71           O  
ATOM    425  N   ILE A  53     -30.317  93.700  24.581  1.00 23.86           N  
ATOM    426  CA  ILE A  53     -29.206  94.264  23.817  1.00 20.78           C  
ATOM    427  C   ILE A  53     -27.904  93.540  24.132  1.00 22.57           C  
ATOM    428  O   ILE A  53     -27.470  93.491  25.281  1.00 21.33           O  
ATOM    429  CB  ILE A  53     -29.019  95.766  24.106  1.00 19.33           C  
ATOM    430  CG1 ILE A  53     -30.353  96.504  23.953  1.00 19.95           C  
ATOM    431  CG2 ILE A  53     -27.993  96.352  23.131  1.00 16.05           C  
ATOM    432  CD1 ILE A  53     -30.946  96.428  22.553  1.00 24.94           C  
ATOM    433  N   LYS A  54     -27.283  92.978  23.103  1.00 21.45           N  
ATOM    434  CA  LYS A  54     -26.040  92.249  23.277  1.00 21.42           C  
ATOM    435  C   LYS A  54     -24.855  92.957  22.614  1.00 24.92           C  
ATOM    436  O   LYS A  54     -23.699  92.686  22.933  1.00 24.87           O  
ATOM    437  CB  LYS A  54     -26.192  90.834  22.713  1.00 30.85           C  
ATOM    438  CG  LYS A  54     -27.078  89.900  23.553  1.00 36.76           C  
ATOM    439  CD  LYS A  54     -28.543  90.295  23.522  1.00 34.32           C  
ATOM    440  CE  LYS A  54     -29.447  89.179  24.060  1.00 35.15           C  
ATOM    441  NZ  LYS A  54     -29.285  88.902  25.517  1.00 23.18           N  
ATOM    442  N   VAL A  55     -25.149  93.864  21.690  1.00 21.02           N  
ATOM    443  CA  VAL A  55     -24.107  94.599  20.994  1.00 19.97           C  
ATOM    444  C   VAL A  55     -24.472  96.069  20.842  1.00 19.62           C  
ATOM    445  O   VAL A  55     -25.636  96.419  20.651  1.00 23.98           O  
ATOM    446  CB  VAL A  55     -23.854  94.017  19.581  1.00 21.75           C  
ATOM    447  CG1 VAL A  55     -22.711  94.765  18.907  1.00 17.63           C  
ATOM    448  CG2 VAL A  55     -23.536  92.533  19.674  1.00 17.13           C  
ATOM    449  N   VAL A  56     -23.470  96.932  20.930  1.00 23.88           N  
ATOM    450  CA  VAL A  56     -23.705  98.359  20.776  1.00 18.56           C  
ATOM    451  C   VAL A  56     -22.754  98.934  19.739  1.00 18.71           C  
ATOM    452  O   VAL A  56     -21.541  98.742  19.820  1.00 20.27           O  
ATOM    453  CB  VAL A  56     -23.500  99.123  22.095  1.00 22.69           C  
ATOM    454  CG1 VAL A  56     -23.717 100.619  21.861  1.00 21.56           C  
ATOM    455  CG2 VAL A  56     -24.458  98.603  23.160  1.00 12.84           C  
ATOM    456  N   ILE A  57     -23.313  99.618  18.748  1.00 17.76           N  
ATOM    457  CA  ILE A  57     -22.496 100.244  17.722  1.00 17.06           C  
ATOM    458  C   ILE A  57     -22.578 101.752  17.912  1.00 17.77           C  
ATOM    459  O   ILE A  57     -23.664 102.325  17.957  1.00 18.76           O  
ATOM    460  CB  ILE A  57     -22.995  99.940  16.295  1.00 15.19           C  
ATOM    461  CG1 ILE A  57     -23.020  98.436  16.038  1.00  9.83           C  
ATOM    462  CG2 ILE A  57     -22.070 100.611  15.285  1.00 14.87           C  
ATOM    463  CD1 ILE A  57     -23.639  98.066  14.688  1.00 13.19           C  
ATOM    464  N   VAL A  58     -21.431 102.399  18.030  1.00 18.74           N  
ATOM    465  CA  VAL A  58     -21.435 103.838  18.179  1.00 21.18           C  
ATOM    466  C   VAL A  58     -21.019 104.415  16.832  1.00 22.51           C  
ATOM    467  O   VAL A  58     -19.949 104.096  16.321  1.00 20.99           O  
ATOM    468  CB  VAL A  58     -20.456 104.288  19.279  1.00 15.38           C  
ATOM    469  CG1 VAL A  58     -20.503 105.805  19.434  1.00 16.89           C  
ATOM    470  CG2 VAL A  58     -20.809 103.599  20.594  1.00  9.62           C  
HETATM  471  N   MSE A  59     -21.890 105.227  16.241  1.00 20.73           N  
HETATM  472  CA  MSE A  59     -21.590 105.847  14.957  1.00 23.82           C  
HETATM  473  C   MSE A  59     -21.982 107.316  14.931  1.00 21.13           C  
HETATM  474  O   MSE A  59     -22.632 107.812  15.849  1.00 20.03           O  
HETATM  475  CB  MSE A  59     -22.260 105.085  13.803  1.00 28.39           C  
HETATM  476  CG  MSE A  59     -23.632 104.503  14.091  1.00 36.74           C  
HETATM  477 SE   MSE A  59     -24.411 103.659  12.509  1.00 48.92          SE  
HETATM  478  CE  MSE A  59     -23.738 101.863  12.690  1.00 38.77           C  
ATOM    479  N   SER A  60     -21.566 108.011  13.879  1.00 25.57           N  
ATOM    480  CA  SER A  60     -21.839 109.434  13.732  1.00 26.32           C  
ATOM    481  C   SER A  60     -22.688 109.736  12.507  1.00 27.61           C  
ATOM    482  O   SER A  60     -22.516 109.111  11.456  1.00 28.29           O  
ATOM    483  CB  SER A  60     -20.514 110.200  13.631  1.00 26.67           C  
ATOM    484  OG  SER A  60     -20.720 111.571  13.336  1.00 18.57           O  
ATOM    485  N   ASP A  61     -23.600 110.693  12.643  1.00 26.78           N  
ATOM    486  CA  ASP A  61     -24.459 111.086  11.531  1.00 27.52           C  
ATOM    487  C   ASP A  61     -23.901 112.341  10.876  1.00 30.27           C  
ATOM    488  O   ASP A  61     -24.517 112.901   9.972  1.00 35.43           O  
ATOM    489  CB  ASP A  61     -25.889 111.364  12.002  1.00 27.17           C  
ATOM    490  CG  ASP A  61     -26.575 110.133  12.558  1.00 28.64           C  
ATOM    491  OD1 ASP A  61     -26.355 109.025  12.020  1.00 31.61           O  
ATOM    492  OD2 ASP A  61     -27.353 110.280  13.524  1.00 36.93           O  
ATOM    493  N   VAL A  62     -22.740 112.787  11.344  1.00 29.44           N  
ATOM    494  CA  VAL A  62     -22.102 113.976  10.793  1.00 29.87           C  
ATOM    495  C   VAL A  62     -21.160 113.567   9.658  1.00 32.62           C  
ATOM    496  O   VAL A  62     -20.290 112.711   9.825  1.00 27.61           O  
ATOM    497  CB  VAL A  62     -21.322 114.745  11.880  1.00 30.61           C  
ATOM    498  CG1 VAL A  62     -20.665 115.981  11.283  1.00 27.97           C  
ATOM    499  CG2 VAL A  62     -22.274 115.150  13.001  1.00 32.95           C  
ATOM    500  N   PRO A  63     -21.330 114.189   8.484  1.00 34.89           N  
ATOM    501  CA  PRO A  63     -20.552 113.947   7.268  1.00 39.59           C  
ATOM    502  C   PRO A  63     -19.081 113.526   7.370  1.00 38.68           C  
ATOM    503  O   PRO A  63     -18.756 112.351   7.187  1.00 43.29           O  
ATOM    504  CB  PRO A  63     -20.739 115.247   6.493  1.00 40.34           C  
ATOM    505  CG  PRO A  63     -22.166 115.566   6.787  1.00 36.89           C  
ATOM    506  CD  PRO A  63     -22.256 115.321   8.285  1.00 33.67           C  
ATOM    507  N   LYS A  64     -18.197 114.475   7.658  1.00 33.55           N  
ATOM    508  CA  LYS A  64     -16.762 114.188   7.708  1.00 33.98           C  
ATOM    509  C   LYS A  64     -16.141 113.894   9.073  1.00 31.81           C  
ATOM    510  O   LYS A  64     -14.923 113.737   9.172  1.00 26.04           O  
ATOM    511  CB  LYS A  64     -15.995 115.351   7.072  1.00 34.86           C  
ATOM    512  CG  LYS A  64     -16.462 115.721   5.671  1.00 39.39           C  
ATOM    513  CD  LYS A  64     -16.166 114.608   4.679  1.00 46.35           C  
ATOM    514  CE  LYS A  64     -16.605 114.984   3.272  1.00 45.53           C  
ATOM    515  NZ  LYS A  64     -16.287 113.912   2.285  1.00 46.30           N  
ATOM    516  N   PHE A  65     -16.955 113.816  10.121  1.00 28.01           N  
ATOM    517  CA  PHE A  65     -16.411 113.567  11.452  1.00 28.31           C  
ATOM    518  C   PHE A  65     -17.138 112.513  12.259  1.00 28.09           C  
ATOM    519  O   PHE A  65     -18.357 112.367  12.165  1.00 29.92           O  
ATOM    520  CB  PHE A  65     -16.439 114.833  12.317  1.00 24.87           C  
ATOM    521  CG  PHE A  65     -15.633 115.980  11.783  1.00 29.95           C  
ATOM    522  CD1 PHE A  65     -15.987 116.616  10.598  1.00 29.89           C  
ATOM    523  CD2 PHE A  65     -14.562 116.478  12.513  1.00 27.30           C  
ATOM    524  CE1 PHE A  65     -15.286 117.730  10.153  1.00 28.25           C  
ATOM    525  CE2 PHE A  65     -13.854 117.593  12.073  1.00 30.49           C  
ATOM    526  CZ  PHE A  65     -14.218 118.221  10.895  1.00 27.99           C  
ATOM    527  N   PHE A  66     -16.369 111.778  13.055  1.00 26.56           N  
ATOM    528  CA  PHE A  66     -16.948 110.817  13.979  1.00 23.50           C  
ATOM    529  C   PHE A  66     -17.093 111.785  15.149  1.00 21.13           C  
ATOM    530  O   PHE A  66     -18.178 111.973  15.695  1.00 23.60           O  
ATOM    531  CB  PHE A  66     -15.956 109.710  14.341  1.00 22.79           C  
ATOM    532  CG  PHE A  66     -16.393 108.873  15.511  1.00 18.02           C  
ATOM    533  CD1 PHE A  66     -17.466 108.001  15.396  1.00 16.42           C  
ATOM    534  CD2 PHE A  66     -15.757 108.991  16.743  1.00 16.62           C  
ATOM    535  CE1 PHE A  66     -17.903 107.259  16.486  1.00 15.81           C  
ATOM    536  CE2 PHE A  66     -16.186 108.255  17.841  1.00 18.84           C  
ATOM    537  CZ  PHE A  66     -17.264 107.385  17.712  1.00 16.23           C  
ATOM    538  N   SER A  67     -15.972 112.427  15.484  1.00 20.68           N  
ATOM    539  CA  SER A  67     -15.902 113.421  16.552  1.00 20.65           C  
ATOM    540  C   SER A  67     -14.500 114.012  16.647  1.00 22.88           C  
ATOM    541  O   SER A  67     -13.500 113.287  16.584  1.00 21.19           O  
ATOM    542  CB  SER A  67     -16.283 112.807  17.901  1.00 19.62           C  
ATOM    543  OG  SER A  67     -16.098 113.748  18.944  1.00 14.84           O  
ATOM    544  N   ALA A  68     -14.426 115.332  16.799  1.00 23.32           N  
ATOM    545  CA  ALA A  68     -13.137 116.008  16.913  1.00 20.78           C  
ATOM    546  C   ALA A  68     -12.766 116.265  18.372  1.00 20.59           C  
ATOM    547  O   ALA A  68     -11.875 117.058  18.657  1.00 22.87           O  
ATOM    548  CB  ALA A  68     -13.161 117.323  16.140  1.00 25.11           C  
ATOM    549  N   GLY A  69     -13.455 115.603  19.296  1.00 20.79           N  
ATOM    550  CA  GLY A  69     -13.142 115.786  20.702  1.00 21.22           C  
ATOM    551  C   GLY A  69     -13.976 116.821  21.436  1.00 22.84           C  
ATOM    552  O   GLY A  69     -15.099 117.134  21.042  1.00 29.26           O  
ATOM    553  N   ALA A  70     -13.421 117.362  22.513  1.00 19.71           N  
ATOM    554  CA  ALA A  70     -14.125 118.354  23.317  1.00 22.72           C  
ATOM    555  C   ALA A  70     -14.231 119.716  22.638  1.00 23.62           C  
ATOM    556  O   ALA A  70     -13.312 120.155  21.946  1.00 19.60           O  
ATOM    557  CB  ALA A  70     -13.440 118.503  24.674  1.00 13.42           C  
ATOM    558  N   ASP A  71     -15.366 120.379  22.846  1.00 26.85           N  
ATOM    559  CA  ASP A  71     -15.606 121.706  22.289  1.00 27.48           C  
ATOM    560  C   ASP A  71     -14.673 122.696  22.990  1.00 27.61           C  
ATOM    561  O   ASP A  71     -14.813 122.945  24.183  1.00 24.21           O  
ATOM    562  CB  ASP A  71     -17.065 122.108  22.524  1.00 35.64           C  
ATOM    563  CG  ASP A  71     -17.421 123.431  21.870  1.00 37.85           C  
ATOM    564  OD1 ASP A  71     -16.768 124.449  22.179  1.00 38.55           O  
ATOM    565  OD2 ASP A  71     -18.361 123.449  21.050  1.00 45.63           O  
ATOM    566  N   ILE A  72     -13.722 123.255  22.249  1.00 27.67           N  
ATOM    567  CA  ILE A  72     -12.761 124.198  22.816  1.00 30.49           C  
ATOM    568  C   ILE A  72     -13.423 125.434  23.412  1.00 34.78           C  
ATOM    569  O   ILE A  72     -12.920 126.002  24.381  1.00 34.44           O  
ATOM    570  CB  ILE A  72     -11.738 124.649  21.762  1.00 30.07           C  
ATOM    571  CG1 ILE A  72     -11.063 123.425  21.133  1.00 31.35           C  
ATOM    572  CG2 ILE A  72     -10.702 125.562  22.403  1.00 29.99           C  
ATOM    573  CD1 ILE A  72     -10.376 122.515  22.128  1.00 35.75           C  
ATOM    574  N   ASN A  73     -14.542 125.856  22.827  1.00 40.37           N  
ATOM    575  CA  ASN A  73     -15.268 127.017  23.330  1.00 46.97           C  
ATOM    576  C   ASN A  73     -15.826 126.684  24.703  1.00 46.58           C  
ATOM    577  O   ASN A  73     -15.711 127.470  25.644  1.00 48.02           O  
ATOM    578  CB  ASN A  73     -16.417 127.394  22.391  1.00 53.52           C  
ATOM    579  CG  ASN A  73     -15.940 128.096  21.137  1.00 64.30           C  
ATOM    580  OD1 ASN A  73     -15.264 129.126  21.208  1.00 70.08           O  
ATOM    581  ND2 ASN A  73     -16.291 127.547  19.979  1.00 66.69           N  
ATOM    582  N   PHE A  74     -16.431 125.508  24.814  1.00 45.40           N  
ATOM    583  CA  PHE A  74     -16.986 125.074  26.084  1.00 47.16           C  
ATOM    584  C   PHE A  74     -15.846 124.757  27.040  1.00 52.18           C  
ATOM    585  O   PHE A  74     -15.831 125.227  28.177  1.00 52.66           O  
ATOM    586  CB  PHE A  74     -17.870 123.839  25.890  1.00 40.15           C  
ATOM    587  CG  PHE A  74     -18.393 123.264  27.175  1.00 40.06           C  
ATOM    588  CD1 PHE A  74     -17.629 122.363  27.913  1.00 37.03           C  
ATOM    589  CD2 PHE A  74     -19.634 123.650  27.671  1.00 39.02           C  
ATOM    590  CE1 PHE A  74     -18.092 121.857  29.126  1.00 34.36           C  
ATOM    591  CE2 PHE A  74     -20.105 123.150  28.885  1.00 37.49           C  
ATOM    592  CZ  PHE A  74     -19.331 122.251  29.613  1.00 33.39           C  
ATOM    593  N   LEU A  75     -14.891 123.961  26.568  1.00 60.61           N  
ATOM    594  CA  LEU A  75     -13.736 123.567  27.370  1.00 67.39           C  
ATOM    595  C   LEU A  75     -13.164 124.789  28.073  1.00 72.59           C  
ATOM    596  O   LEU A  75     -13.117 124.836  29.301  1.00 76.22           O  
ATOM    597  CB  LEU A  75     -12.675 122.915  26.475  1.00 71.31           C  
ATOM    598  CG  LEU A  75     -11.460 122.232  27.115  1.00 74.79           C  
ATOM    599  CD1 LEU A  75     -10.770 121.366  26.073  1.00 75.99           C  
ATOM    600  CD2 LEU A  75     -10.496 123.269  27.675  1.00 78.02           C  
ATOM    601  N   ARG A  76     -12.728 125.779  27.300  1.00 77.21           N  
ATOM    602  CA  ARG A  76     -12.190 126.989  27.901  1.00 80.59           C  
ATOM    603  C   ARG A  76     -13.371 127.762  28.464  1.00 78.95           C  
ATOM    604  O   ARG A  76     -14.516 127.344  28.303  1.00 81.79           O  
ATOM    605  CB  ARG A  76     -11.450 127.838  26.866  1.00 86.35           C  
ATOM    606  CG  ARG A  76     -10.683 129.009  27.478  1.00 94.55           C  
ATOM    607  CD  ARG A  76      -9.729 128.528  28.573  1.00 99.36           C  
ATOM    608  NE  ARG A  76      -8.991 129.620  29.204  1.00 99.88           N  
ATOM    609  CZ  ARG A  76      -8.124 130.404  28.571  1.00100.42           C  
ATOM    610  NH1 ARG A  76      -7.880 130.225  27.280  1.00100.42           N  
ATOM    611  NH2 ARG A  76      -7.500 131.370  29.232  1.00100.42           N  
ATOM    612  N   SER A  77     -13.097 128.886  29.116  1.00 75.72           N  
ATOM    613  CA  SER A  77     -14.151 129.696  29.716  1.00 73.23           C  
ATOM    614  C   SER A  77     -14.673 128.979  30.959  1.00 67.91           C  
ATOM    615  O   SER A  77     -15.633 129.419  31.592  1.00 68.65           O  
ATOM    616  CB  SER A  77     -15.294 129.918  28.721  1.00 76.27           C  
ATOM    617  OG  SER A  77     -16.345 130.665  29.308  1.00 85.69           O  
ATOM    618  N   ALA A  78     -14.029 127.867  31.296  1.00 59.05           N  
ATOM    619  CA  ALA A  78     -14.408 127.083  32.462  1.00 49.90           C  
ATOM    620  C   ALA A  78     -13.276 127.098  33.482  1.00 44.30           C  
ATOM    621  O   ALA A  78     -12.103 127.062  33.121  1.00 42.11           O  
ATOM    622  CB  ALA A  78     -14.729 125.650  32.050  1.00 44.65           C  
ATOM    623  N   ASP A  79     -13.642 127.164  34.757  1.00 40.35           N  
ATOM    624  CA  ASP A  79     -12.679 127.174  35.851  1.00 42.01           C  
ATOM    625  C   ASP A  79     -11.904 125.857  35.894  1.00 37.05           C  
ATOM    626  O   ASP A  79     -12.437 124.804  35.546  1.00 34.11           O  
ATOM    627  CB  ASP A  79     -13.424 127.405  37.173  1.00 49.97           C  
ATOM    628  CG  ASP A  79     -12.819 126.641  38.335  1.00 66.30           C  
ATOM    629  OD1 ASP A  79     -11.642 126.883  38.677  1.00 75.27           O  
ATOM    630  OD2 ASP A  79     -13.530 125.794  38.913  1.00 76.97           O  
ATOM    631  N   PRO A  80     -10.626 125.901  36.311  1.00 35.47           N  
ATOM    632  CA  PRO A  80      -9.799 124.693  36.389  1.00 32.39           C  
ATOM    633  C   PRO A  80     -10.436 123.574  37.212  1.00 29.02           C  
ATOM    634  O   PRO A  80     -10.212 122.392  36.943  1.00 27.47           O  
ATOM    635  CB  PRO A  80      -8.506 125.205  37.010  1.00 33.24           C  
ATOM    636  CG  PRO A  80      -8.403 126.576  36.434  1.00 35.77           C  
ATOM    637  CD  PRO A  80      -9.815 127.100  36.592  1.00 29.00           C  
ATOM    638  N   ARG A  81     -11.231 123.939  38.212  1.00 22.39           N  
ATOM    639  CA  ARG A  81     -11.872 122.925  39.037  1.00 25.77           C  
ATOM    640  C   ARG A  81     -13.079 122.328  38.334  1.00 23.95           C  
ATOM    641  O   ARG A  81     -13.436 121.179  38.577  1.00 22.65           O  
ATOM    642  CB  ARG A  81     -12.259 123.502  40.399  1.00 27.47           C  
ATOM    643  CG  ARG A  81     -11.066 123.649  41.330  1.00 32.61           C  
ATOM    644  CD  ARG A  81     -11.467 124.132  42.710  1.00 43.96           C  
ATOM    645  NE  ARG A  81     -11.970 125.502  42.691  1.00 51.13           N  
ATOM    646  CZ  ARG A  81     -12.206 126.225  43.782  1.00 54.27           C  
ATOM    647  NH1 ARG A  81     -11.984 125.708  44.985  1.00 56.75           N  
ATOM    648  NH2 ARG A  81     -12.654 127.467  43.671  1.00 49.70           N  
ATOM    649  N   PHE A  82     -13.704 123.106  37.455  1.00 25.71           N  
ATOM    650  CA  PHE A  82     -14.847 122.605  36.704  1.00 20.22           C  
ATOM    651  C   PHE A  82     -14.302 121.655  35.636  1.00 17.97           C  
ATOM    652  O   PHE A  82     -14.908 120.628  35.344  1.00 20.09           O  
ATOM    653  CB  PHE A  82     -15.609 123.740  36.018  1.00 18.71           C  
ATOM    654  CG  PHE A  82     -16.741 123.259  35.145  1.00 22.36           C  
ATOM    655  CD1 PHE A  82     -17.993 122.994  35.689  1.00 22.81           C  
ATOM    656  CD2 PHE A  82     -16.534 123.006  33.792  1.00 23.57           C  
ATOM    657  CE1 PHE A  82     -19.021 122.481  34.899  1.00 19.70           C  
ATOM    658  CE2 PHE A  82     -17.551 122.493  32.997  1.00 23.81           C  
ATOM    659  CZ  PHE A  82     -18.798 122.230  33.551  1.00 25.30           C  
ATOM    660  N   LYS A  83     -13.158 122.012  35.056  1.00 17.82           N  
ATOM    661  CA  LYS A  83     -12.524 121.189  34.024  1.00 23.73           C  
ATOM    662  C   LYS A  83     -12.133 119.837  34.608  1.00 22.76           C  
ATOM    663  O   LYS A  83     -12.261 118.799  33.957  1.00 20.76           O  
ATOM    664  CB  LYS A  83     -11.273 121.878  33.477  1.00 25.23           C  
ATOM    665  CG  LYS A  83     -11.534 123.153  32.689  1.00 29.71           C  
ATOM    666  CD  LYS A  83     -10.234 123.743  32.168  1.00 29.92           C  
ATOM    667  CE  LYS A  83     -10.475 124.996  31.354  1.00 37.27           C  
ATOM    668  NZ  LYS A  83      -9.202 125.561  30.824  1.00 37.68           N  
ATOM    669  N   THR A  84     -11.646 119.867  35.844  1.00 23.30           N  
ATOM    670  CA  THR A  84     -11.240 118.660  36.542  1.00 17.75           C  
ATOM    671  C   THR A  84     -12.438 117.735  36.701  1.00 16.84           C  
ATOM    672  O   THR A  84     -12.346 116.542  36.427  1.00 17.81           O  
ATOM    673  CB  THR A  84     -10.672 118.995  37.942  1.00 18.29           C  
ATOM    674  OG1 THR A  84      -9.469 119.758  37.797  1.00 13.84           O  
ATOM    675  CG2 THR A  84     -10.382 117.720  38.727  1.00 14.02           C  
ATOM    676  N   GLN A  85     -13.567 118.287  37.137  1.00 13.55           N  
ATOM    677  CA  GLN A  85     -14.761 117.478  37.326  1.00 15.02           C  
ATOM    678  C   GLN A  85     -15.398 117.071  36.001  1.00 17.62           C  
ATOM    679  O   GLN A  85     -16.014 116.012  35.899  1.00 16.66           O  
ATOM    680  CB  GLN A  85     -15.773 118.219  38.202  1.00 20.13           C  
ATOM    681  CG  GLN A  85     -15.278 118.459  39.619  1.00 18.42           C  
ATOM    682  CD  GLN A  85     -14.684 117.205  40.243  1.00 16.97           C  
ATOM    683  OE1 GLN A  85     -15.306 116.140  40.242  1.00 22.23           O  
ATOM    684  NE2 GLN A  85     -13.475 117.328  40.784  1.00 16.68           N  
ATOM    685  N   PHE A  86     -15.250 117.917  34.988  1.00 18.58           N  
ATOM    686  CA  PHE A  86     -15.783 117.613  33.669  1.00 15.85           C  
ATOM    687  C   PHE A  86     -15.035 116.390  33.139  1.00 16.02           C  
ATOM    688  O   PHE A  86     -15.643 115.425  32.669  1.00 18.71           O  
ATOM    689  CB  PHE A  86     -15.568 118.804  32.728  1.00 19.24           C  
ATOM    690  CG  PHE A  86     -15.793 118.482  31.272  1.00 21.00           C  
ATOM    691  CD1 PHE A  86     -17.030 118.035  30.822  1.00 26.66           C  
ATOM    692  CD2 PHE A  86     -14.765 118.636  30.348  1.00 25.75           C  
ATOM    693  CE1 PHE A  86     -17.241 117.747  29.472  1.00 26.01           C  
ATOM    694  CE2 PHE A  86     -14.965 118.351  28.997  1.00 24.92           C  
ATOM    695  CZ  PHE A  86     -16.204 117.907  28.559  1.00 22.12           C  
ATOM    696  N   CYS A  87     -13.709 116.435  33.227  1.00 19.29           N  
ATOM    697  CA  CYS A  87     -12.868 115.339  32.759  1.00 19.75           C  
ATOM    698  C   CYS A  87     -13.107 114.050  33.535  1.00 16.05           C  
ATOM    699  O   CYS A  87     -13.196 112.980  32.942  1.00 20.99           O  
ATOM    700  CB  CYS A  87     -11.392 115.738  32.840  1.00 16.17           C  
ATOM    701  SG  CYS A  87     -10.928 117.032  31.640  1.00 24.91           S  
ATOM    702  N   LEU A  88     -13.218 114.154  34.857  1.00 14.94           N  
ATOM    703  CA  LEU A  88     -13.453 112.982  35.694  1.00 15.24           C  
ATOM    704  C   LEU A  88     -14.741 112.275  35.287  1.00 14.18           C  
ATOM    705  O   LEU A  88     -14.760 111.056  35.142  1.00 17.66           O  
ATOM    706  CB  LEU A  88     -13.524 113.376  37.174  1.00 11.32           C  
ATOM    707  CG  LEU A  88     -13.769 112.248  38.184  1.00 21.28           C  
ATOM    708  CD1 LEU A  88     -12.788 111.090  37.953  1.00 13.57           C  
ATOM    709  CD2 LEU A  88     -13.604 112.806  39.601  1.00 15.11           C  
ATOM    710  N   PHE A  89     -15.810 113.038  35.089  1.00 17.62           N  
ATOM    711  CA  PHE A  89     -17.090 112.448  34.694  1.00 17.66           C  
ATOM    712  C   PHE A  89     -17.012 111.760  33.331  1.00 11.38           C  
ATOM    713  O   PHE A  89     -17.569 110.676  33.140  1.00 14.76           O  
ATOM    714  CB  PHE A  89     -18.194 113.507  34.645  1.00 20.01           C  
ATOM    715  CG  PHE A  89     -19.539 112.944  34.290  1.00 16.69           C  
ATOM    716  CD1 PHE A  89     -20.273 112.225  35.225  1.00 20.17           C  
ATOM    717  CD2 PHE A  89     -20.045 113.079  33.003  1.00 17.19           C  
ATOM    718  CE1 PHE A  89     -21.492 111.643  34.881  1.00 22.65           C  
ATOM    719  CE2 PHE A  89     -21.262 112.501  32.647  1.00 20.67           C  
ATOM    720  CZ  PHE A  89     -21.986 111.780  33.588  1.00 17.98           C  
ATOM    721  N   CYS A  90     -16.340 112.397  32.378  1.00 15.51           N  
ATOM    722  CA  CYS A  90     -16.200 111.812  31.047  1.00 15.27           C  
ATOM    723  C   CYS A  90     -15.439 110.489  31.130  1.00 14.94           C  
ATOM    724  O   CYS A  90     -15.828 109.503  30.505  1.00 13.83           O  
ATOM    725  CB  CYS A  90     -15.456 112.773  30.118  1.00 18.67           C  
ATOM    726  SG  CYS A  90     -16.350 114.302  29.768  1.00 19.91           S  
ATOM    727  N   ASN A  91     -14.354 110.478  31.900  1.00 13.47           N  
ATOM    728  CA  ASN A  91     -13.548 109.276  32.064  1.00 17.73           C  
ATOM    729  C   ASN A  91     -14.346 108.141  32.698  1.00 13.33           C  
ATOM    730  O   ASN A  91     -14.325 107.010  32.209  1.00 17.17           O  
ATOM    731  CB  ASN A  91     -12.301 109.574  32.904  1.00 10.82           C  
ATOM    732  CG  ASN A  91     -11.173 110.162  32.081  1.00 17.06           C  
ATOM    733  OD1 ASN A  91     -10.796 109.608  31.052  1.00 19.42           O  
ATOM    734  ND2 ASN A  91     -10.618 111.283  32.537  1.00 14.14           N  
ATOM    735  N   GLU A  92     -15.055 108.441  33.781  1.00 14.36           N  
ATOM    736  CA  GLU A  92     -15.858 107.428  34.453  1.00 16.02           C  
ATOM    737  C   GLU A  92     -16.927 106.896  33.504  1.00 17.07           C  
ATOM    738  O   GLU A  92     -17.283 105.717  33.550  1.00 12.22           O  
ATOM    739  CB  GLU A  92     -16.504 108.012  35.715  1.00 16.04           C  
ATOM    740  CG  GLU A  92     -15.478 108.493  36.740  1.00 22.58           C  
ATOM    741  CD  GLU A  92     -16.105 108.993  38.029  1.00 21.26           C  
ATOM    742  OE1 GLU A  92     -17.181 109.620  37.960  1.00 21.56           O  
ATOM    743  OE2 GLU A  92     -15.511 108.773  39.110  1.00 17.03           O  
ATOM    744  N   THR A  93     -17.436 107.765  32.635  1.00 14.15           N  
ATOM    745  CA  THR A  93     -18.450 107.339  31.679  1.00 16.40           C  
ATOM    746  C   THR A  93     -17.812 106.342  30.714  1.00 17.27           C  
ATOM    747  O   THR A  93     -18.337 105.251  30.498  1.00 16.32           O  
ATOM    748  CB  THR A  93     -19.012 108.530  30.883  1.00 16.34           C  
ATOM    749  OG1 THR A  93     -19.681 109.427  31.783  1.00 19.23           O  
ATOM    750  CG2 THR A  93     -20.003 108.044  29.818  1.00 13.75           C  
ATOM    751  N   LEU A  94     -16.669 106.713  30.147  1.00 15.38           N  
ATOM    752  CA  LEU A  94     -15.983 105.822  29.224  1.00 16.92           C  
ATOM    753  C   LEU A  94     -15.592 104.520  29.929  1.00 14.98           C  
ATOM    754  O   LEU A  94     -15.653 103.449  29.331  1.00  9.86           O  
ATOM    755  CB  LEU A  94     -14.740 106.505  28.639  1.00 12.38           C  
ATOM    756  CG  LEU A  94     -14.988 107.714  27.722  1.00 18.77           C  
ATOM    757  CD1 LEU A  94     -13.678 108.084  27.025  1.00 10.59           C  
ATOM    758  CD2 LEU A  94     -16.066 107.389  26.672  1.00  9.55           C  
ATOM    759  N   ASP A  95     -15.214 104.609  31.201  1.00 14.68           N  
ATOM    760  CA  ASP A  95     -14.822 103.417  31.955  1.00 16.40           C  
ATOM    761  C   ASP A  95     -15.940 102.374  32.043  1.00 16.28           C  
ATOM    762  O   ASP A  95     -15.669 101.173  32.123  1.00 17.33           O  
ATOM    763  CB  ASP A  95     -14.393 103.781  33.389  1.00 16.55           C  
ATOM    764  CG  ASP A  95     -13.179 104.694  33.437  1.00 19.78           C  
ATOM    765  OD1 ASP A  95     -12.348 104.654  32.506  1.00 20.81           O  
ATOM    766  OD2 ASP A  95     -13.049 105.444  34.430  1.00 22.90           O  
ATOM    767  N   LYS A  96     -17.189 102.834  32.040  1.00 13.78           N  
ATOM    768  CA  LYS A  96     -18.340 101.939  32.147  1.00 11.36           C  
ATOM    769  C   LYS A  96     -18.490 100.915  31.015  1.00 12.10           C  
ATOM    770  O   LYS A  96     -19.065  99.847  31.211  1.00 14.28           O  
ATOM    771  CB  LYS A  96     -19.619 102.773  32.283  1.00 12.14           C  
ATOM    772  CG  LYS A  96     -19.615 103.623  33.555  1.00 13.20           C  
ATOM    773  CD  LYS A  96     -20.784 104.597  33.659  1.00 14.25           C  
ATOM    774  CE  LYS A  96     -22.101 103.893  33.957  1.00 18.33           C  
ATOM    775  NZ  LYS A  96     -23.104 104.856  34.505  1.00 20.32           N  
ATOM    776  N   ILE A  97     -17.961 101.236  29.839  1.00 12.79           N  
ATOM    777  CA  ILE A  97     -18.056 100.340  28.689  1.00 15.97           C  
ATOM    778  C   ILE A  97     -17.373  98.985  28.912  1.00 17.30           C  
ATOM    779  O   ILE A  97     -17.949  97.937  28.618  1.00 23.78           O  
ATOM    780  CB  ILE A  97     -17.463 101.017  27.421  1.00 15.63           C  
ATOM    781  CG1 ILE A  97     -18.286 102.260  27.074  1.00 11.78           C  
ATOM    782  CG2 ILE A  97     -17.475 100.044  26.246  1.00 16.83           C  
ATOM    783  CD1 ILE A  97     -17.737 103.068  25.924  1.00 14.39           C  
ATOM    784  N   ALA A  98     -16.151  99.003  29.431  1.00 13.08           N  
ATOM    785  CA  ALA A  98     -15.419  97.766  29.679  1.00 14.95           C  
ATOM    786  C   ALA A  98     -16.132  96.881  30.700  1.00 14.71           C  
ATOM    787  O   ALA A  98     -15.924  95.672  30.728  1.00 14.15           O  
ATOM    788  CB  ALA A  98     -14.008  98.083  30.162  1.00 15.00           C  
ATOM    789  N   ARG A  99     -16.973  97.484  31.536  1.00 13.72           N  
ATOM    790  CA  ARG A  99     -17.700  96.734  32.552  1.00 15.51           C  
ATOM    791  C   ARG A  99     -19.080  96.279  32.083  1.00 14.53           C  
ATOM    792  O   ARG A  99     -19.733  95.491  32.769  1.00 17.97           O  
ATOM    793  CB  ARG A  99     -17.862  97.582  33.821  1.00  9.91           C  
ATOM    794  CG  ARG A  99     -16.563  98.153  34.352  1.00 15.92           C  
ATOM    795  CD  ARG A  99     -16.752  98.839  35.698  1.00  9.79           C  
ATOM    796  NE  ARG A  99     -15.569  99.614  36.066  1.00  6.39           N  
ATOM    797  CZ  ARG A  99     -15.537 100.940  36.146  1.00 14.55           C  
ATOM    798  NH1 ARG A  99     -16.629 101.657  35.893  1.00  9.75           N  
ATOM    799  NH2 ARG A  99     -14.407 101.555  36.461  1.00 10.66           N  
ATOM    800  N   SER A 100     -19.524  96.778  30.929  1.00 13.35           N  
ATOM    801  CA  SER A 100     -20.843  96.437  30.386  1.00 14.50           C  
ATOM    802  C   SER A 100     -20.918  95.072  29.693  1.00 18.10           C  
ATOM    803  O   SER A 100     -19.954  94.620  29.079  1.00 16.29           O  
ATOM    804  CB  SER A 100     -21.299  97.524  29.407  1.00 17.67           C  
ATOM    805  OG  SER A 100     -21.390  98.783  30.052  1.00 16.06           O  
ATOM    806  N   PRO A 101     -22.083  94.408  29.767  1.00 20.45           N  
ATOM    807  CA  PRO A 101     -22.265  93.095  29.143  1.00 21.62           C  
ATOM    808  C   PRO A 101     -22.179  93.136  27.623  1.00 20.56           C  
ATOM    809  O   PRO A 101     -21.736  92.171  27.001  1.00 24.06           O  
ATOM    810  CB  PRO A 101     -23.663  92.670  29.607  1.00 22.53           C  
ATOM    811  CG  PRO A 101     -23.901  93.475  30.842  1.00 23.53           C  
ATOM    812  CD  PRO A 101     -23.302  94.810  30.486  1.00 24.63           C  
ATOM    813  N   GLN A 102     -22.616  94.247  27.030  1.00 18.37           N  
ATOM    814  CA  GLN A 102     -22.612  94.400  25.575  1.00 20.88           C  
ATOM    815  C   GLN A 102     -21.235  94.674  25.006  1.00 24.06           C  
ATOM    816  O   GLN A 102     -20.393  95.291  25.658  1.00 17.80           O  
ATOM    817  CB  GLN A 102     -23.506  95.565  25.123  1.00 24.05           C  
ATOM    818  CG  GLN A 102     -24.985  95.452  25.415  1.00 24.19           C  
ATOM    819  CD  GLN A 102     -25.323  95.790  26.847  1.00 27.48           C  
ATOM    820  OE1 GLN A 102     -24.595  96.532  27.512  1.00 19.80           O  
ATOM    821  NE2 GLN A 102     -26.443  95.263  27.328  1.00 18.85           N  
ATOM    822  N   VAL A 103     -21.026  94.229  23.771  1.00 22.52           N  
ATOM    823  CA  VAL A 103     -19.778  94.472  23.073  1.00 18.27           C  
ATOM    824  C   VAL A 103     -19.953  95.835  22.407  1.00 21.97           C  
ATOM    825  O   VAL A 103     -20.898  96.045  21.641  1.00 19.92           O  
ATOM    826  CB  VAL A 103     -19.516  93.401  21.991  1.00 18.94           C  
ATOM    827  CG1 VAL A 103     -18.347  93.814  21.106  1.00 14.50           C  
ATOM    828  CG2 VAL A 103     -19.222  92.067  22.652  1.00 25.13           C  
ATOM    829  N   TYR A 104     -19.058  96.764  22.717  1.00 19.30           N  
ATOM    830  CA  TYR A 104     -19.115  98.100  22.139  1.00 18.55           C  
ATOM    831  C   TYR A 104     -18.184  98.239  20.931  1.00 19.67           C  
ATOM    832  O   TYR A 104     -16.979  98.013  21.030  1.00 20.22           O  
ATOM    833  CB  TYR A 104     -18.760  99.148  23.200  1.00 18.03           C  
ATOM    834  CG  TYR A 104     -19.943  99.605  24.034  1.00 17.76           C  
ATOM    835  CD1 TYR A 104     -20.639  98.712  24.849  1.00 18.81           C  
ATOM    836  CD2 TYR A 104     -20.384 100.925  23.977  1.00 12.60           C  
ATOM    837  CE1 TYR A 104     -21.755  99.127  25.587  1.00 17.58           C  
ATOM    838  CE2 TYR A 104     -21.493 101.349  24.706  1.00 17.56           C  
ATOM    839  CZ  TYR A 104     -22.172 100.447  25.505  1.00 15.94           C  
ATOM    840  OH  TYR A 104     -23.272 100.870  26.204  1.00 15.04           O  
ATOM    841  N   ILE A 105     -18.757  98.611  19.792  1.00 19.33           N  
ATOM    842  CA  ILE A 105     -17.994  98.778  18.561  1.00 18.87           C  
ATOM    843  C   ILE A 105     -18.082 100.225  18.091  1.00 21.97           C  
ATOM    844  O   ILE A 105     -19.174 100.780  17.975  1.00 23.33           O  
ATOM    845  CB  ILE A 105     -18.544  97.882  17.426  1.00 13.20           C  
ATOM    846  CG1 ILE A 105     -18.629  96.431  17.895  1.00 11.55           C  
ATOM    847  CG2 ILE A 105     -17.641  97.980  16.189  1.00  6.07           C  
ATOM    848  CD1 ILE A 105     -19.277  95.515  16.877  1.00 14.15           C  
ATOM    849  N   ALA A 106     -16.932 100.830  17.825  1.00 17.30           N  
ATOM    850  CA  ALA A 106     -16.891 102.201  17.339  1.00 17.64           C  
ATOM    851  C   ALA A 106     -16.868 102.148  15.816  1.00 23.73           C  
ATOM    852  O   ALA A 106     -15.927 101.621  15.227  1.00 20.73           O  
ATOM    853  CB  ALA A 106     -15.648 102.898  17.848  1.00 14.12           C  
ATOM    854  N   CYS A 107     -17.910 102.677  15.182  1.00 25.22           N  
ATOM    855  CA  CYS A 107     -17.981 102.688  13.726  1.00 23.87           C  
ATOM    856  C   CYS A 107     -17.422 104.024  13.256  1.00 23.86           C  
ATOM    857  O   CYS A 107     -18.126 105.032  13.254  1.00 23.96           O  
ATOM    858  CB  CYS A 107     -19.430 102.532  13.257  1.00 20.29           C  
ATOM    859  SG  CYS A 107     -19.600 102.337  11.459  1.00 23.39           S  
ATOM    860  N   LEU A 108     -16.156 104.027  12.852  1.00 20.18           N  
ATOM    861  CA  LEU A 108     -15.502 105.255  12.424  1.00 19.20           C  
ATOM    862  C   LEU A 108     -15.607 105.522  10.921  1.00 22.03           C  
ATOM    863  O   LEU A 108     -14.986 104.836  10.106  1.00 20.55           O  
ATOM    864  CB  LEU A 108     -14.037 105.215  12.864  1.00 16.15           C  
ATOM    865  CG  LEU A 108     -13.838 104.863  14.347  1.00 15.85           C  
ATOM    866  CD1 LEU A 108     -12.345 104.746  14.651  1.00 16.93           C  
ATOM    867  CD2 LEU A 108     -14.487 105.929  15.238  1.00 15.36           C  
ATOM    868  N   GLU A 109     -16.397 106.532  10.564  1.00 20.65           N  
ATOM    869  CA  GLU A 109     -16.595 106.895   9.165  1.00 23.62           C  
ATOM    870  C   GLU A 109     -16.014 108.260   8.827  1.00 21.97           C  
ATOM    871  O   GLU A 109     -16.005 108.666   7.668  1.00 26.28           O  
ATOM    872  CB  GLU A 109     -18.084 106.875   8.819  1.00 22.70           C  
ATOM    873  CG  GLU A 109     -18.683 105.484   8.751  1.00 26.57           C  
ATOM    874  CD  GLU A 109     -20.184 105.512   8.553  1.00 32.20           C  
ATOM    875  OE1 GLU A 109     -20.903 105.875   9.507  1.00 33.64           O  
ATOM    876  OE2 GLU A 109     -20.645 105.180   7.440  1.00 34.77           O  
ATOM    877  N   GLY A 110     -15.529 108.968   9.842  1.00 25.21           N  
ATOM    878  CA  GLY A 110     -14.949 110.281   9.616  1.00 24.97           C  
ATOM    879  C   GLY A 110     -13.789 110.547  10.555  1.00 24.61           C  
ATOM    880  O   GLY A 110     -13.316 109.640  11.235  1.00 25.59           O  
ATOM    881  N   HIS A 111     -13.330 111.792  10.594  1.00 24.80           N  
ATOM    882  CA  HIS A 111     -12.223 112.168  11.461  1.00 21.19           C  
ATOM    883  C   HIS A 111     -12.496 111.734  12.893  1.00 20.92           C  
ATOM    884  O   HIS A 111     -13.566 112.012  13.445  1.00 18.47           O  
ATOM    885  CB  HIS A 111     -11.998 113.682  11.415  1.00 20.77           C  
ATOM    886  CG  HIS A 111     -11.515 114.184  10.089  1.00 25.04           C  
ATOM    887  ND1 HIS A 111     -12.148 115.198   9.401  1.00 30.38           N  
ATOM    888  CD2 HIS A 111     -10.462 113.811   9.324  1.00 24.97           C  
ATOM    889  CE1 HIS A 111     -11.504 115.426   8.268  1.00 26.72           C  
ATOM    890  NE2 HIS A 111     -10.481 114.600   8.199  1.00 29.88           N  
ATOM    891  N   THR A 112     -11.517 111.050  13.482  1.00 20.76           N  
ATOM    892  CA  THR A 112     -11.603 110.550  14.852  1.00 21.18           C  
ATOM    893  C   THR A 112     -10.365 111.038  15.593  1.00 16.24           C  
ATOM    894  O   THR A 112      -9.350 110.346  15.641  1.00 17.83           O  
ATOM    895  CB  THR A 112     -11.630 109.002  14.869  1.00 18.75           C  
ATOM    896  OG1 THR A 112     -12.718 108.537  14.062  1.00 21.15           O  
ATOM    897  CG2 THR A 112     -11.810 108.479  16.281  1.00 11.48           C  
ATOM    898  N   VAL A 113     -10.448 112.233  16.170  1.00 14.29           N  
ATOM    899  CA  VAL A 113      -9.308 112.812  16.861  1.00 16.92           C  
ATOM    900  C   VAL A 113      -9.600 113.317  18.268  1.00 16.68           C  
ATOM    901  O   VAL A 113     -10.751 113.576  18.626  1.00 20.16           O  
ATOM    902  CB  VAL A 113      -8.700 113.968  16.026  1.00 18.13           C  
ATOM    903  CG1 VAL A 113      -8.197 113.433  14.690  1.00 14.43           C  
ATOM    904  CG2 VAL A 113      -9.742 115.052  15.794  1.00 16.13           C  
ATOM    905  N   GLY A 114      -8.537 113.461  19.056  1.00 13.57           N  
ATOM    906  CA  GLY A 114      -8.669 113.924  20.428  1.00 10.65           C  
ATOM    907  C   GLY A 114      -9.728 113.138  21.172  1.00 10.74           C  
ATOM    908  O   GLY A 114      -9.771 111.911  21.095  1.00 17.09           O  
ATOM    909  N   GLY A 115     -10.587 113.853  21.891  1.00 13.20           N  
ATOM    910  CA  GLY A 115     -11.652 113.210  22.633  1.00 12.03           C  
ATOM    911  C   GLY A 115     -12.441 112.230  21.790  1.00 14.64           C  
ATOM    912  O   GLY A 115     -13.023 111.287  22.319  1.00 11.79           O  
ATOM    913  N   GLY A 116     -12.470 112.452  20.477  1.00 17.31           N  
ATOM    914  CA  GLY A 116     -13.199 111.552  19.601  1.00 14.60           C  
ATOM    915  C   GLY A 116     -12.550 110.177  19.596  1.00 15.17           C  
ATOM    916  O   GLY A 116     -13.230 109.147  19.649  1.00 13.88           O  
ATOM    917  N   LEU A 117     -11.224 110.161  19.525  1.00 14.26           N  
ATOM    918  CA  LEU A 117     -10.483 108.908  19.531  1.00 16.21           C  
ATOM    919  C   LEU A 117     -10.551 108.295  20.926  1.00 11.84           C  
ATOM    920  O   LEU A 117     -10.660 107.079  21.079  1.00 12.10           O  
ATOM    921  CB  LEU A 117      -9.021 109.139  19.140  1.00 11.43           C  
ATOM    922  CG  LEU A 117      -8.143 107.882  19.220  1.00 16.48           C  
ATOM    923  CD1 LEU A 117      -8.774 106.764  18.404  1.00 15.72           C  
ATOM    924  CD2 LEU A 117      -6.746 108.189  18.711  1.00 17.42           C  
ATOM    925  N   GLU A 118     -10.501 109.143  21.945  1.00 15.82           N  
ATOM    926  CA  GLU A 118     -10.560 108.652  23.315  1.00 10.92           C  
ATOM    927  C   GLU A 118     -11.841 107.859  23.548  1.00 14.73           C  
ATOM    928  O   GLU A 118     -11.821 106.812  24.189  1.00 14.84           O  
ATOM    929  CB  GLU A 118     -10.448 109.823  24.292  1.00  8.17           C  
ATOM    930  CG  GLU A 118      -9.113 110.528  24.174  1.00 10.94           C  
ATOM    931  CD  GLU A 118      -8.969 111.689  25.121  1.00 21.07           C  
ATOM    932  OE1 GLU A 118      -9.664 112.711  24.927  1.00 24.43           O  
ATOM    933  OE2 GLU A 118      -8.154 111.578  26.059  1.00 16.76           O  
HETATM  934  N   MSE A 119     -12.954 108.349  23.015  1.00 14.33           N  
HETATM  935  CA  MSE A 119     -14.224 107.645  23.159  1.00 16.97           C  
HETATM  936  C   MSE A 119     -14.130 106.307  22.438  1.00 16.34           C  
HETATM  937  O   MSE A 119     -14.608 105.287  22.932  1.00 15.82           O  
HETATM  938  CB  MSE A 119     -15.364 108.459  22.542  1.00 17.62           C  
HETATM  939  CG  MSE A 119     -16.727 107.797  22.657  1.00 31.85           C  
HETATM  940 SE   MSE A 119     -18.127 108.835  21.802  1.00 50.78          SE  
HETATM  941  CE  MSE A 119     -17.644 110.587  22.456  1.00 39.27           C  
ATOM    942  N   ALA A 120     -13.510 106.329  21.260  1.00 14.41           N  
ATOM    943  CA  ALA A 120     -13.341 105.136  20.440  1.00 15.55           C  
ATOM    944  C   ALA A 120     -12.396 104.125  21.093  1.00 16.12           C  
ATOM    945  O   ALA A 120     -12.590 102.916  20.960  1.00 12.21           O  
ATOM    946  CB  ALA A 120     -12.816 105.527  19.064  1.00 11.62           C  
ATOM    947  N   LEU A 121     -11.380 104.624  21.796  1.00  8.11           N  
ATOM    948  CA  LEU A 121     -10.417 103.756  22.475  1.00 12.02           C  
ATOM    949  C   LEU A 121     -11.079 103.012  23.630  1.00 17.32           C  
ATOM    950  O   LEU A 121     -10.666 101.904  23.980  1.00 12.96           O  
ATOM    951  CB  LEU A 121      -9.233 104.574  23.011  1.00  9.31           C  
ATOM    952  CG  LEU A 121      -8.198 105.101  22.006  1.00 12.90           C  
ATOM    953  CD1 LEU A 121      -7.245 106.082  22.688  1.00  5.31           C  
ATOM    954  CD2 LEU A 121      -7.423 103.934  21.417  1.00 13.33           C  
ATOM    955  N   ALA A 122     -12.109 103.625  24.214  1.00 15.20           N  
ATOM    956  CA  ALA A 122     -12.829 103.025  25.339  1.00 12.66           C  
ATOM    957  C   ALA A 122     -13.793 101.920  24.897  1.00 15.60           C  
ATOM    958  O   ALA A 122     -14.286 101.157  25.721  1.00 16.14           O  
ATOM    959  CB  ALA A 122     -13.581 104.101  26.115  1.00  5.72           C  
ATOM    960  N   CYS A 123     -14.065 101.840  23.596  1.00 15.54           N  
ATOM    961  CA  CYS A 123     -14.943 100.795  23.077  1.00 13.59           C  
ATOM    962  C   CYS A 123     -14.129  99.509  22.915  1.00 11.78           C  
ATOM    963  O   CYS A 123     -12.900  99.554  22.872  1.00  9.00           O  
ATOM    964  CB  CYS A 123     -15.535 101.212  21.728  1.00 13.09           C  
ATOM    965  SG  CYS A 123     -16.631 102.648  21.807  1.00 22.32           S  
ATOM    966  N   ASP A 124     -14.813  98.372  22.822  1.00 12.23           N  
ATOM    967  CA  ASP A 124     -14.148  97.075  22.685  1.00 13.53           C  
ATOM    968  C   ASP A 124     -13.478  96.866  21.328  1.00 16.76           C  
ATOM    969  O   ASP A 124     -12.448  96.196  21.238  1.00 15.88           O  
ATOM    970  CB  ASP A 124     -15.153  95.938  22.933  1.00 10.05           C  
ATOM    971  CG  ASP A 124     -15.846  96.057  24.281  1.00 19.39           C  
ATOM    972  OD1 ASP A 124     -15.145  96.321  25.276  1.00 19.42           O  
ATOM    973  OD2 ASP A 124     -17.085  95.882  24.354  1.00 12.13           O  
ATOM    974  N   LEU A 125     -14.065  97.434  20.278  1.00 14.31           N  
ATOM    975  CA  LEU A 125     -13.524  97.296  18.930  1.00 15.07           C  
ATOM    976  C   LEU A 125     -13.679  98.595  18.147  1.00 13.06           C  
ATOM    977  O   LEU A 125     -14.542  99.409  18.453  1.00 12.59           O  
ATOM    978  CB  LEU A 125     -14.251  96.175  18.180  1.00 12.49           C  
ATOM    979  CG  LEU A 125     -14.223  94.754  18.746  1.00 20.63           C  
ATOM    980  CD1 LEU A 125     -15.316  93.912  18.085  1.00 13.71           C  
ATOM    981  CD2 LEU A 125     -12.850  94.138  18.533  1.00 12.76           C  
ATOM    982  N   ARG A 126     -12.846  98.769  17.126  1.00 13.41           N  
ATOM    983  CA  ARG A 126     -12.888  99.956  16.280  1.00 18.11           C  
ATOM    984  C   ARG A 126     -12.793  99.573  14.805  1.00 19.37           C  
ATOM    985  O   ARG A 126     -11.814  98.958  14.390  1.00 19.99           O  
ATOM    986  CB  ARG A 126     -11.731 100.895  16.640  1.00 15.35           C  
ATOM    987  CG  ARG A 126     -11.880 101.589  17.996  1.00 17.66           C  
ATOM    988  CD  ARG A 126     -10.519 101.964  18.568  1.00 11.28           C  
ATOM    989  NE  ARG A 126      -9.772 100.767  18.946  1.00 15.26           N  
ATOM    990  CZ  ARG A 126     -10.069 100.002  19.994  1.00 15.92           C  
ATOM    991  NH1 ARG A 126     -11.097 100.311  20.777  1.00  8.76           N  
ATOM    992  NH2 ARG A 126      -9.355  98.913  20.248  1.00 14.78           N  
ATOM    993  N   PHE A 127     -13.820  99.922  14.027  1.00 19.48           N  
ATOM    994  CA  PHE A 127     -13.851  99.644  12.584  1.00 16.69           C  
ATOM    995  C   PHE A 127     -13.852 100.996  11.874  1.00 14.96           C  
ATOM    996  O   PHE A 127     -14.645 101.874  12.210  1.00 15.99           O  
ATOM    997  CB  PHE A 127     -15.114  98.861  12.185  1.00 12.51           C  
ATOM    998  CG  PHE A 127     -15.247  97.505  12.846  1.00 13.52           C  
ATOM    999  CD1 PHE A 127     -14.145  96.865  13.417  1.00 15.05           C  
ATOM   1000  CD2 PHE A 127     -16.483  96.859  12.882  1.00 14.39           C  
ATOM   1001  CE1 PHE A 127     -14.277  95.601  14.022  1.00 13.53           C  
ATOM   1002  CE2 PHE A 127     -16.626  95.598  13.481  1.00 14.55           C  
ATOM   1003  CZ  PHE A 127     -15.518  94.968  14.050  1.00 15.87           C  
HETATM 1004  N   MSE A 128     -12.977 101.169  10.889  1.00 18.32           N  
HETATM 1005  CA  MSE A 128     -12.885 102.449  10.193  1.00 19.90           C  
HETATM 1006  C   MSE A 128     -12.972 102.367   8.668  1.00 20.27           C  
HETATM 1007  O   MSE A 128     -12.521 101.395   8.067  1.00 20.89           O  
HETATM 1008  CB  MSE A 128     -11.580 103.132  10.607  1.00 20.63           C  
HETATM 1009  CG  MSE A 128     -11.375 104.536  10.076  1.00 20.84           C  
HETATM 1010 SE   MSE A 128      -9.940 105.398  11.047  1.00 35.26          SE  
HETATM 1011  CE  MSE A 128     -10.746 107.132  11.337  1.00 25.02           C  
ATOM   1012  N   GLY A 129     -13.550 103.401   8.053  1.00 19.59           N  
ATOM   1013  CA  GLY A 129     -13.676 103.441   6.603  1.00 22.42           C  
ATOM   1014  C   GLY A 129     -12.353 103.788   5.942  1.00 23.53           C  
ATOM   1015  O   GLY A 129     -11.573 104.557   6.505  1.00 19.84           O  
ATOM   1016  N   ASP A 130     -12.094 103.253   4.748  1.00 19.07           N  
ATOM   1017  CA  ASP A 130     -10.816 103.532   4.096  1.00 25.00           C  
ATOM   1018  C   ASP A 130     -10.609 104.968   3.622  1.00 22.67           C  
ATOM   1019  O   ASP A 130      -9.548 105.305   3.107  1.00 23.78           O  
ATOM   1020  CB  ASP A 130     -10.543 102.537   2.950  1.00 26.83           C  
ATOM   1021  CG  ASP A 130     -11.598 102.568   1.855  1.00 26.90           C  
ATOM   1022  OD1 ASP A 130     -11.480 101.739   0.930  1.00 27.56           O  
ATOM   1023  OD2 ASP A 130     -12.529 103.397   1.903  1.00 32.50           O  
ATOM   1024  N   GLU A 131     -11.616 105.813   3.817  1.00 24.05           N  
ATOM   1025  CA  GLU A 131     -11.520 107.221   3.443  1.00 24.13           C  
ATOM   1026  C   GLU A 131     -12.055 108.066   4.600  1.00 26.46           C  
ATOM   1027  O   GLU A 131     -12.422 109.228   4.420  1.00 25.05           O  
ATOM   1028  CB  GLU A 131     -12.340 107.503   2.176  1.00 32.55           C  
ATOM   1029  CG  GLU A 131     -11.904 106.714   0.949  1.00 37.43           C  
ATOM   1030  CD  GLU A 131     -12.638 107.145  -0.314  1.00 44.58           C  
ATOM   1031  OE1 GLU A 131     -12.459 108.306  -0.740  1.00 41.90           O  
ATOM   1032  OE2 GLU A 131     -13.394 106.326  -0.883  1.00 36.48           O  
ATOM   1033  N   ALA A 132     -12.082 107.467   5.790  1.00 26.51           N  
ATOM   1034  CA  ALA A 132     -12.585 108.121   6.997  1.00 24.22           C  
ATOM   1035  C   ALA A 132     -11.839 109.385   7.407  1.00 19.91           C  
ATOM   1036  O   ALA A 132     -12.365 110.195   8.165  1.00 27.56           O  
ATOM   1037  CB  ALA A 132     -12.591 107.127   8.161  1.00 22.20           C  
ATOM   1038  N   GLY A 133     -10.614 109.554   6.926  1.00 19.89           N  
ATOM   1039  CA  GLY A 133      -9.870 110.752   7.274  1.00 20.97           C  
ATOM   1040  C   GLY A 133      -8.695 110.574   8.213  1.00 20.96           C  
ATOM   1041  O   GLY A 133      -7.860 109.689   8.017  1.00 23.32           O  
ATOM   1042  N   LYS A 134      -8.642 111.421   9.239  1.00 24.78           N  
ATOM   1043  CA  LYS A 134      -7.555 111.419  10.224  1.00 24.97           C  
ATOM   1044  C   LYS A 134      -7.928 110.795  11.560  1.00 24.38           C  
ATOM   1045  O   LYS A 134      -9.065 110.902  12.023  1.00 24.09           O  
ATOM   1046  CB  LYS A 134      -7.094 112.851  10.512  1.00 29.36           C  
ATOM   1047  CG  LYS A 134      -6.789 113.721   9.305  1.00 38.86           C  
ATOM   1048  CD  LYS A 134      -6.491 115.144   9.773  1.00 45.57           C  
ATOM   1049  CE  LYS A 134      -6.201 116.090   8.622  1.00 47.91           C  
ATOM   1050  NZ  LYS A 134      -5.915 117.471   9.111  1.00 46.29           N  
ATOM   1051  N   ILE A 135      -6.951 110.156  12.190  1.00 21.76           N  
ATOM   1052  CA  ILE A 135      -7.161 109.549  13.496  1.00 20.26           C  
ATOM   1053  C   ILE A 135      -5.898 109.791  14.324  1.00 20.31           C  
ATOM   1054  O   ILE A 135      -4.785 109.522  13.869  1.00 22.57           O  
ATOM   1055  CB  ILE A 135      -7.475 108.030  13.369  1.00 18.53           C  
ATOM   1056  CG1 ILE A 135      -7.656 107.412  14.757  1.00 12.39           C  
ATOM   1057  CG2 ILE A 135      -6.378 107.328  12.582  1.00 12.09           C  
ATOM   1058  CD1 ILE A 135      -8.290 106.038  14.725  1.00 11.20           C  
ATOM   1059  N   GLY A 136      -6.080 110.333  15.526  1.00 20.85           N  
ATOM   1060  CA  GLY A 136      -4.955 110.623  16.401  1.00 11.64           C  
ATOM   1061  C   GLY A 136      -5.333 111.485  17.595  1.00 16.30           C  
ATOM   1062  O   GLY A 136      -6.512 111.748  17.836  1.00 15.74           O  
ATOM   1063  N   LEU A 137      -4.327 111.930  18.343  1.00 14.40           N  
ATOM   1064  CA  LEU A 137      -4.536 112.752  19.531  1.00 12.95           C  
ATOM   1065  C   LEU A 137      -3.697 114.034  19.444  1.00 17.59           C  
ATOM   1066  O   LEU A 137      -2.548 114.068  19.885  1.00 20.22           O  
ATOM   1067  CB  LEU A 137      -4.141 111.953  20.774  1.00  8.45           C  
ATOM   1068  CG  LEU A 137      -4.872 110.629  21.044  1.00 12.27           C  
ATOM   1069  CD1 LEU A 137      -4.195 109.898  22.192  1.00  8.89           C  
ATOM   1070  CD2 LEU A 137      -6.333 110.886  21.367  1.00  8.77           C  
ATOM   1071  N   PRO A 138      -4.268 115.108  18.874  1.00 17.22           N  
ATOM   1072  CA  PRO A 138      -3.550 116.377  18.733  1.00 17.05           C  
ATOM   1073  C   PRO A 138      -3.635 117.371  19.897  1.00 18.84           C  
ATOM   1074  O   PRO A 138      -3.237 118.522  19.743  1.00 18.25           O  
ATOM   1075  CB  PRO A 138      -4.144 116.950  17.454  1.00 21.29           C  
ATOM   1076  CG  PRO A 138      -5.579 116.561  17.581  1.00 16.56           C  
ATOM   1077  CD  PRO A 138      -5.512 115.121  18.079  1.00 15.20           C  
ATOM   1078  N   GLU A 139      -4.129 116.932  21.051  1.00 15.10           N  
ATOM   1079  CA  GLU A 139      -4.265 117.812  22.214  1.00 15.66           C  
ATOM   1080  C   GLU A 139      -3.029 118.636  22.574  1.00 19.40           C  
ATOM   1081  O   GLU A 139      -3.146 119.752  23.085  1.00 14.21           O  
ATOM   1082  CB  GLU A 139      -4.691 117.008  23.447  1.00 15.01           C  
ATOM   1083  CG  GLU A 139      -6.129 116.525  23.406  1.00 18.52           C  
ATOM   1084  CD  GLU A 139      -6.290 115.155  22.774  1.00 17.82           C  
ATOM   1085  OE1 GLU A 139      -5.533 114.821  21.836  1.00 18.14           O  
ATOM   1086  OE2 GLU A 139      -7.196 114.417  23.213  1.00 16.67           O  
ATOM   1087  N   VAL A 140      -1.845 118.089  22.324  1.00 14.88           N  
ATOM   1088  CA  VAL A 140      -0.614 118.799  22.647  1.00 19.01           C  
ATOM   1089  C   VAL A 140      -0.516 120.143  21.914  1.00 21.45           C  
ATOM   1090  O   VAL A 140       0.131 121.072  22.399  1.00 21.16           O  
ATOM   1091  CB  VAL A 140       0.636 117.951  22.295  1.00 18.70           C  
ATOM   1092  CG1 VAL A 140       0.780 117.824  20.782  1.00 17.19           C  
ATOM   1093  CG2 VAL A 140       1.875 118.584  22.890  1.00 16.57           C  
ATOM   1094  N   SER A 141      -1.156 120.245  20.751  1.00 17.69           N  
ATOM   1095  CA  SER A 141      -1.107 121.484  19.977  1.00 21.90           C  
ATOM   1096  C   SER A 141      -1.869 122.602  20.676  1.00 23.59           C  
ATOM   1097  O   SER A 141      -1.767 123.764  20.287  1.00 23.12           O  
ATOM   1098  CB  SER A 141      -1.667 121.268  18.563  1.00 15.83           C  
ATOM   1099  OG  SER A 141      -3.048 120.964  18.585  1.00 21.94           O  
ATOM   1100  N   LEU A 142      -2.622 122.245  21.713  1.00 23.20           N  
ATOM   1101  CA  LEU A 142      -3.396 123.213  22.486  1.00 19.80           C  
ATOM   1102  C   LEU A 142      -2.754 123.458  23.851  1.00 19.55           C  
ATOM   1103  O   LEU A 142      -3.248 124.260  24.641  1.00 20.60           O  
ATOM   1104  CB  LEU A 142      -4.824 122.704  22.698  1.00 20.08           C  
ATOM   1105  CG  LEU A 142      -5.676 122.364  21.474  1.00 25.77           C  
ATOM   1106  CD1 LEU A 142      -6.878 121.533  21.920  1.00 26.06           C  
ATOM   1107  CD2 LEU A 142      -6.126 123.637  20.768  1.00 15.79           C  
ATOM   1108  N   GLY A 143      -1.660 122.758  24.131  1.00 18.70           N  
ATOM   1109  CA  GLY A 143      -0.995 122.929  25.409  1.00 18.96           C  
ATOM   1110  C   GLY A 143      -1.511 122.011  26.506  1.00 21.92           C  
ATOM   1111  O   GLY A 143      -1.179 122.197  27.677  1.00 20.92           O  
ATOM   1112  N   VAL A 144      -2.337 121.033  26.135  1.00 16.50           N  
ATOM   1113  CA  VAL A 144      -2.872 120.066  27.095  1.00 17.46           C  
ATOM   1114  C   VAL A 144      -2.619 118.653  26.558  1.00 18.52           C  
ATOM   1115  O   VAL A 144      -1.975 118.487  25.527  1.00 18.96           O  
ATOM   1116  CB  VAL A 144      -4.393 120.256  27.326  1.00 20.08           C  
ATOM   1117  CG1 VAL A 144      -4.665 121.639  27.904  1.00 21.20           C  
ATOM   1118  CG2 VAL A 144      -5.154 120.064  26.020  1.00 18.48           C  
ATOM   1119  N   LEU A 145      -3.117 117.635  27.253  1.00 18.69           N  
ATOM   1120  CA  LEU A 145      -2.912 116.267  26.802  1.00 12.06           C  
ATOM   1121  C   LEU A 145      -4.224 115.513  26.678  1.00 10.45           C  
ATOM   1122  O   LEU A 145      -5.270 116.025  27.059  1.00 10.33           O  
ATOM   1123  CB  LEU A 145      -1.966 115.531  27.755  1.00 10.93           C  
ATOM   1124  CG  LEU A 145      -2.297 115.488  29.250  1.00 11.10           C  
ATOM   1125  CD1 LEU A 145      -3.592 114.727  29.505  1.00 10.89           C  
ATOM   1126  CD2 LEU A 145      -1.133 114.825  29.982  1.00 14.90           C  
ATOM   1127  N   ALA A 146      -4.162 114.303  26.124  1.00 15.24           N  
ATOM   1128  CA  ALA A 146      -5.350 113.465  25.963  1.00 15.67           C  
ATOM   1129  C   ALA A 146      -5.780 113.033  27.365  1.00 17.08           C  
ATOM   1130  O   ALA A 146      -5.456 111.928  27.816  1.00 16.80           O  
ATOM   1131  CB  ALA A 146      -5.013 112.247  25.105  1.00 10.92           C  
ATOM   1132  N   GLY A 147      -6.507 113.920  28.043  1.00 22.35           N  
ATOM   1133  CA  GLY A 147      -6.940 113.673  29.408  1.00 16.79           C  
ATOM   1134  C   GLY A 147      -8.191 112.859  29.662  1.00 17.33           C  
ATOM   1135  O   GLY A 147      -8.653 112.777  30.802  1.00 17.81           O  
ATOM   1136  N   THR A 148      -8.762 112.269  28.624  1.00 14.85           N  
ATOM   1137  CA  THR A 148      -9.939 111.439  28.823  1.00 17.80           C  
ATOM   1138  C   THR A 148      -9.552 109.984  28.542  1.00 18.49           C  
ATOM   1139  O   THR A 148     -10.252 109.266  27.829  1.00 11.30           O  
ATOM   1140  CB  THR A 148     -11.109 111.862  27.900  1.00 20.13           C  
ATOM   1141  OG1 THR A 148     -11.257 113.286  27.933  1.00 22.14           O  
ATOM   1142  CG2 THR A 148     -12.415 111.245  28.393  1.00 14.25           C  
ATOM   1143  N   GLY A 149      -8.416 109.567  29.099  1.00 15.67           N  
ATOM   1144  CA  GLY A 149      -7.951 108.198  28.919  1.00 16.81           C  
ATOM   1145  C   GLY A 149      -7.066 107.951  27.706  1.00 16.51           C  
ATOM   1146  O   GLY A 149      -6.516 106.863  27.544  1.00 15.41           O  
ATOM   1147  N   GLY A 150      -6.910 108.964  26.864  1.00 13.05           N  
ATOM   1148  CA  GLY A 150      -6.100 108.819  25.669  1.00 13.76           C  
ATOM   1149  C   GLY A 150      -4.663 108.351  25.846  1.00 18.05           C  
ATOM   1150  O   GLY A 150      -4.248 107.394  25.186  1.00 17.77           O  
ATOM   1151  N   THR A 151      -3.896 109.011  26.717  1.00 13.62           N  
ATOM   1152  CA  THR A 151      -2.495 108.633  26.923  1.00 14.94           C  
ATOM   1153  C   THR A 151      -2.359 107.202  27.422  1.00 15.85           C  
ATOM   1154  O   THR A 151      -1.464 106.473  27.006  1.00 19.24           O  
ATOM   1155  CB  THR A 151      -1.768 109.559  27.949  1.00 14.41           C  
ATOM   1156  OG1 THR A 151      -2.290 109.335  29.266  1.00 11.29           O  
ATOM   1157  CG2 THR A 151      -1.942 111.028  27.577  1.00  9.88           C  
ATOM   1158  N   GLN A 152      -3.263 106.806  28.308  1.00 14.90           N  
ATOM   1159  CA  GLN A 152      -3.234 105.478  28.892  1.00 12.50           C  
ATOM   1160  C   GLN A 152      -3.745 104.346  27.998  1.00 13.99           C  
ATOM   1161  O   GLN A 152      -3.088 103.314  27.865  1.00 11.98           O  
ATOM   1162  CB  GLN A 152      -4.002 105.498  30.218  1.00 13.02           C  
ATOM   1163  CG  GLN A 152      -3.404 106.465  31.237  1.00 15.04           C  
ATOM   1164  CD  GLN A 152      -1.883 106.323  31.351  1.00 13.58           C  
ATOM   1165  OE1 GLN A 152      -1.136 107.249  31.040  1.00 22.80           O  
ATOM   1166  NE2 GLN A 152      -1.427 105.159  31.792  1.00  9.22           N  
ATOM   1167  N   ARG A 153      -4.912 104.529  27.385  1.00 14.56           N  
ATOM   1168  CA  ARG A 153      -5.457 103.485  26.530  1.00  9.62           C  
ATOM   1169  C   ARG A 153      -4.671 103.332  25.230  1.00 10.73           C  
ATOM   1170  O   ARG A 153      -4.488 102.215  24.742  1.00 13.39           O  
ATOM   1171  CB  ARG A 153      -6.942 103.736  26.235  1.00  6.22           C  
ATOM   1172  CG  ARG A 153      -7.858 103.598  27.464  1.00  9.46           C  
ATOM   1173  CD  ARG A 153      -9.314 103.351  27.054  1.00  9.82           C  
ATOM   1174  NE  ARG A 153     -10.173 103.057  28.200  1.00 13.32           N  
ATOM   1175  CZ  ARG A 153     -10.671 103.974  29.025  1.00 16.86           C  
ATOM   1176  NH1 ARG A 153     -10.408 105.259  28.831  1.00 13.08           N  
ATOM   1177  NH2 ARG A 153     -11.419 103.606  30.058  1.00 11.56           N  
ATOM   1178  N   LEU A 154      -4.193 104.437  24.666  1.00  9.58           N  
ATOM   1179  CA  LEU A 154      -3.413 104.344  23.430  1.00 13.21           C  
ATOM   1180  C   LEU A 154      -2.140 103.537  23.679  1.00 12.32           C  
ATOM   1181  O   LEU A 154      -1.771 102.682  22.876  1.00 11.61           O  
ATOM   1182  CB  LEU A 154      -3.023 105.731  22.900  1.00 14.74           C  
ATOM   1183  CG  LEU A 154      -2.431 105.716  21.480  1.00 18.09           C  
ATOM   1184  CD1 LEU A 154      -3.446 105.111  20.515  1.00 17.85           C  
ATOM   1185  CD2 LEU A 154      -2.074 107.127  21.040  1.00 17.34           C  
ATOM   1186  N   ALA A 155      -1.476 103.814  24.798  1.00 10.18           N  
ATOM   1187  CA  ALA A 155      -0.243 103.120  25.143  1.00 12.22           C  
ATOM   1188  C   ALA A 155      -0.472 101.624  25.305  1.00 11.21           C  
ATOM   1189  O   ALA A 155       0.331 100.817  24.842  1.00 11.97           O  
ATOM   1190  CB  ALA A 155       0.352 103.703  26.429  1.00  7.88           C  
ATOM   1191  N   ARG A 156      -1.566 101.260  25.960  1.00  9.41           N  
ATOM   1192  CA  ARG A 156      -1.891  99.858  26.183  1.00 14.79           C  
ATOM   1193  C   ARG A 156      -2.322  99.165  24.896  1.00 13.76           C  
ATOM   1194  O   ARG A 156      -2.072  97.977  24.711  1.00 18.25           O  
ATOM   1195  CB  ARG A 156      -2.994  99.729  27.245  1.00 10.98           C  
ATOM   1196  CG  ARG A 156      -2.515 100.066  28.668  1.00 15.54           C  
ATOM   1197  CD  ARG A 156      -3.671 100.234  29.656  1.00  7.26           C  
ATOM   1198  NE  ARG A 156      -3.198 100.428  31.028  1.00 16.95           N  
ATOM   1199  CZ  ARG A 156      -2.514 101.488  31.455  1.00 12.84           C  
ATOM   1200  NH1 ARG A 156      -2.215 102.473  30.620  1.00  9.89           N  
ATOM   1201  NH2 ARG A 156      -2.116 101.561  32.719  1.00  4.33           N  
ATOM   1202  N   LEU A 157      -2.957  99.908  23.998  1.00 16.11           N  
ATOM   1203  CA  LEU A 157      -3.416  99.316  22.748  1.00 14.53           C  
ATOM   1204  C   LEU A 157      -2.314  99.145  21.703  1.00 15.17           C  
ATOM   1205  O   LEU A 157      -2.137  98.048  21.173  1.00 16.48           O  
ATOM   1206  CB  LEU A 157      -4.558 100.144  22.144  1.00 12.83           C  
ATOM   1207  CG  LEU A 157      -5.186  99.587  20.858  1.00 13.80           C  
ATOM   1208  CD1 LEU A 157      -5.841  98.239  21.142  1.00 10.49           C  
ATOM   1209  CD2 LEU A 157      -6.218 100.569  20.316  1.00 10.69           C  
ATOM   1210  N   ILE A 158      -1.561 100.206  21.419  1.00 10.19           N  
ATOM   1211  CA  ILE A 158      -0.516 100.118  20.395  1.00 10.33           C  
ATOM   1212  C   ILE A 158       0.933 100.067  20.880  1.00 12.67           C  
ATOM   1213  O   ILE A 158       1.850  99.944  20.063  1.00 10.88           O  
ATOM   1214  CB  ILE A 158      -0.622 101.293  19.381  1.00 11.49           C  
ATOM   1215  CG1 ILE A 158      -0.332 102.625  20.078  1.00 14.65           C  
ATOM   1216  CG2 ILE A 158      -1.999 101.321  18.753  1.00  8.41           C  
ATOM   1217  CD1 ILE A 158      -0.225 103.800  19.115  1.00 11.52           C  
ATOM   1218  N   GLY A 159       1.145 100.163  22.190  1.00 11.75           N  
ATOM   1219  CA  GLY A 159       2.500 100.150  22.719  1.00  9.04           C  
ATOM   1220  C   GLY A 159       2.851 101.517  23.283  1.00 14.15           C  
ATOM   1221  O   GLY A 159       2.547 102.543  22.666  1.00 12.27           O  
ATOM   1222  N   TYR A 160       3.508 101.543  24.440  1.00  8.12           N  
ATOM   1223  CA  TYR A 160       3.846 102.806  25.087  1.00 11.04           C  
ATOM   1224  C   TYR A 160       4.742 103.776  24.314  1.00 13.31           C  
ATOM   1225  O   TYR A 160       4.480 104.977  24.297  1.00 13.21           O  
ATOM   1226  CB  TYR A 160       4.424 102.541  26.489  1.00  8.46           C  
ATOM   1227  CG  TYR A 160       5.682 101.684  26.547  1.00 14.32           C  
ATOM   1228  CD1 TYR A 160       6.945 102.244  26.356  1.00 10.75           C  
ATOM   1229  CD2 TYR A 160       5.607 100.318  26.848  1.00 12.84           C  
ATOM   1230  CE1 TYR A 160       8.104 101.469  26.473  1.00 12.45           C  
ATOM   1231  CE2 TYR A 160       6.762  99.536  26.963  1.00 12.64           C  
ATOM   1232  CZ  TYR A 160       8.007 100.118  26.778  1.00 16.61           C  
ATOM   1233  OH  TYR A 160       9.156  99.356  26.918  1.00 12.98           O  
ATOM   1234  N   SER A 161       5.786 103.275  23.663  1.00 11.77           N  
ATOM   1235  CA  SER A 161       6.676 104.155  22.917  1.00  8.38           C  
ATOM   1236  C   SER A 161       5.970 104.733  21.692  1.00 15.08           C  
ATOM   1237  O   SER A 161       6.088 105.927  21.400  1.00 13.07           O  
ATOM   1238  CB  SER A 161       7.933 103.403  22.489  1.00 12.43           C  
ATOM   1239  OG  SER A 161       8.870 104.281  21.888  1.00 16.69           O  
ATOM   1240  N   ARG A 162       5.237 103.880  20.978  1.00 12.46           N  
ATOM   1241  CA  ARG A 162       4.494 104.309  19.800  1.00 14.59           C  
ATOM   1242  C   ARG A 162       3.427 105.325  20.174  1.00 13.52           C  
ATOM   1243  O   ARG A 162       3.170 106.266  19.432  1.00 14.78           O  
ATOM   1244  CB  ARG A 162       3.843 103.108  19.108  1.00 12.64           C  
ATOM   1245  CG  ARG A 162       4.830 102.297  18.297  1.00 20.38           C  
ATOM   1246  CD  ARG A 162       4.178 101.162  17.543  1.00 23.58           C  
ATOM   1247  NE  ARG A 162       5.114 100.597  16.576  1.00 27.13           N  
ATOM   1248  CZ  ARG A 162       4.864  99.535  15.820  1.00 29.71           C  
ATOM   1249  NH1 ARG A 162       3.700  98.906  15.916  1.00 26.12           N  
ATOM   1250  NH2 ARG A 162       5.780  99.103  14.963  1.00 23.84           N  
ATOM   1251  N   ALA A 163       2.809 105.128  21.332  1.00 12.72           N  
ATOM   1252  CA  ALA A 163       1.783 106.041  21.808  1.00 13.94           C  
ATOM   1253  C   ALA A 163       2.447 107.347  22.247  1.00 13.32           C  
ATOM   1254  O   ALA A 163       1.905 108.433  22.046  1.00 18.23           O  
ATOM   1255  CB  ALA A 163       1.028 105.417  22.978  1.00  6.99           C  
ATOM   1256  N   LEU A 164       3.627 107.235  22.849  1.00  8.36           N  
ATOM   1257  CA  LEU A 164       4.346 108.413  23.315  1.00 11.23           C  
ATOM   1258  C   LEU A 164       4.635 109.299  22.116  1.00 11.97           C  
ATOM   1259  O   LEU A 164       4.386 110.502  22.146  1.00 17.06           O  
ATOM   1260  CB  LEU A 164       5.648 107.995  24.004  1.00 13.88           C  
ATOM   1261  CG  LEU A 164       6.511 109.079  24.654  1.00 17.96           C  
ATOM   1262  CD1 LEU A 164       7.156 108.521  25.921  1.00 20.26           C  
ATOM   1263  CD2 LEU A 164       7.571 109.557  23.673  1.00 18.59           C  
ATOM   1264  N   ASP A 165       5.143 108.683  21.055  1.00 13.27           N  
ATOM   1265  CA  ASP A 165       5.467 109.392  19.823  1.00 12.04           C  
ATOM   1266  C   ASP A 165       4.245 110.136  19.293  1.00 16.18           C  
ATOM   1267  O   ASP A 165       4.307 111.340  19.043  1.00 17.01           O  
ATOM   1268  CB  ASP A 165       5.999 108.384  18.794  1.00 15.49           C  
ATOM   1269  CG  ASP A 165       6.184 108.982  17.413  1.00 21.69           C  
ATOM   1270  OD1 ASP A 165       6.445 110.201  17.296  1.00 20.82           O  
ATOM   1271  OD2 ASP A 165       6.086 108.212  16.434  1.00 23.29           O  
HETATM 1272  N   MSE A 166       3.127 109.431  19.141  1.00 10.78           N  
HETATM 1273  CA  MSE A 166       1.915 110.063  18.628  1.00 15.31           C  
HETATM 1274  C   MSE A 166       1.374 111.187  19.499  1.00 16.76           C  
HETATM 1275  O   MSE A 166       0.915 112.204  18.978  1.00 15.79           O  
HETATM 1276  CB  MSE A 166       0.809 109.023  18.410  1.00 15.65           C  
HETATM 1277  CG  MSE A 166       1.001 108.169  17.169  1.00 18.09           C  
HETATM 1278 SE   MSE A 166      -0.467 106.954  16.875  1.00 32.58          SE  
HETATM 1279  CE  MSE A 166      -1.819 108.208  16.289  1.00 16.68           C  
ATOM   1280  N   ASN A 167       1.426 111.008  20.819  1.00 14.38           N  
ATOM   1281  CA  ASN A 167       0.924 112.012  21.757  1.00 14.06           C  
ATOM   1282  C   ASN A 167       1.772 113.286  21.858  1.00 13.34           C  
ATOM   1283  O   ASN A 167       1.219 114.390  21.908  1.00 16.27           O  
ATOM   1284  CB  ASN A 167       0.771 111.399  23.160  1.00 15.57           C  
ATOM   1285  CG  ASN A 167      -0.554 110.666  23.350  1.00 15.39           C  
ATOM   1286  OD1 ASN A 167      -1.567 111.268  23.716  1.00 18.27           O  
ATOM   1287  ND2 ASN A 167      -0.553 109.365  23.095  1.00 13.82           N  
ATOM   1288  N   ILE A 168       3.097 113.151  21.899  1.00 11.39           N  
ATOM   1289  CA  ILE A 168       3.948 114.334  22.024  1.00 11.08           C  
ATOM   1290  C   ILE A 168       4.046 115.168  20.742  1.00 14.93           C  
ATOM   1291  O   ILE A 168       4.297 116.371  20.808  1.00 13.73           O  
ATOM   1292  CB  ILE A 168       5.382 113.987  22.514  1.00 10.12           C  
ATOM   1293  CG1 ILE A 168       6.102 113.120  21.484  1.00 12.76           C  
ATOM   1294  CG2 ILE A 168       5.319 113.290  23.879  1.00 11.94           C  
ATOM   1295  CD1 ILE A 168       7.543 112.848  21.845  1.00  6.73           C  
ATOM   1296  N   THR A 169       3.855 114.541  19.582  1.00 12.67           N  
ATOM   1297  CA  THR A 169       3.902 115.276  18.316  1.00 19.78           C  
ATOM   1298  C   THR A 169       2.490 115.763  17.980  1.00 17.16           C  
ATOM   1299  O   THR A 169       2.314 116.824  17.396  1.00 16.56           O  
ATOM   1300  CB  THR A 169       4.398 114.397  17.138  1.00 17.58           C  
ATOM   1301  OG1 THR A 169       3.431 113.379  16.859  1.00 20.04           O  
ATOM   1302  CG2 THR A 169       5.736 113.752  17.464  1.00 19.69           C  
ATOM   1303  N   GLY A 170       1.488 114.972  18.357  1.00 21.34           N  
ATOM   1304  CA  GLY A 170       0.104 115.332  18.100  1.00 17.02           C  
ATOM   1305  C   GLY A 170      -0.317 115.039  16.676  1.00 20.59           C  
ATOM   1306  O   GLY A 170      -1.413 115.400  16.248  1.00 21.70           O  
ATOM   1307  N   GLU A 171       0.556 114.374  15.933  1.00 24.72           N  
ATOM   1308  CA  GLU A 171       0.265 114.058  14.545  1.00 26.85           C  
ATOM   1309  C   GLU A 171      -0.738 112.932  14.356  1.00 23.54           C  
ATOM   1310  O   GLU A 171      -0.717 111.929  15.064  1.00 27.70           O  
ATOM   1311  CB  GLU A 171       1.572 113.760  13.802  1.00 34.49           C  
ATOM   1312  CG  GLU A 171       2.275 115.029  13.317  1.00 41.19           C  
ATOM   1313  CD  GLU A 171       3.747 114.829  13.018  1.00 46.19           C  
ATOM   1314  OE1 GLU A 171       4.102 113.816  12.381  1.00 52.49           O  
ATOM   1315  OE2 GLU A 171       4.552 115.699  13.415  1.00 49.43           O  
ATOM   1316  N   THR A 172      -1.627 113.123  13.389  1.00 17.23           N  
ATOM   1317  CA  THR A 172      -2.654 112.145  13.080  1.00 21.11           C  
ATOM   1318  C   THR A 172      -2.201 111.236  11.939  1.00 20.14           C  
ATOM   1319  O   THR A 172      -1.315 111.590  11.159  1.00 20.68           O  
ATOM   1320  CB  THR A 172      -3.969 112.848  12.685  1.00 27.95           C  
ATOM   1321  OG1 THR A 172      -3.757 113.636  11.508  1.00 32.26           O  
ATOM   1322  CG2 THR A 172      -4.435 113.768  13.810  1.00 25.88           C  
ATOM   1323  N   ILE A 173      -2.806 110.058  11.847  1.00 18.08           N  
ATOM   1324  CA  ILE A 173      -2.455 109.107  10.805  1.00 17.74           C  
ATOM   1325  C   ILE A 173      -3.678 108.707   9.985  1.00 16.04           C  
ATOM   1326  O   ILE A 173      -4.784 109.174  10.240  1.00 20.17           O  
ATOM   1327  CB  ILE A 173      -1.804 107.845  11.415  1.00 16.45           C  
ATOM   1328  CG1 ILE A 173      -2.761 107.190  12.414  1.00 14.33           C  
ATOM   1329  CG2 ILE A 173      -0.502 108.222  12.106  1.00 16.59           C  
ATOM   1330  CD1 ILE A 173      -2.222 105.908  13.027  1.00 17.46           C  
ATOM   1331  N   THR A 174      -3.473 107.836   9.004  1.00 17.33           N  
ATOM   1332  CA  THR A 174      -4.554 107.373   8.141  1.00 15.16           C  
ATOM   1333  C   THR A 174      -5.180 106.100   8.691  1.00 22.54           C  
ATOM   1334  O   THR A 174      -4.627 105.461   9.587  1.00 22.26           O  
ATOM   1335  CB  THR A 174      -4.038 107.057   6.718  1.00 17.94           C  
ATOM   1336  OG1 THR A 174      -3.090 105.983   6.783  1.00 15.36           O  
ATOM   1337  CG2 THR A 174      -3.368 108.283   6.100  1.00 14.69           C  
ATOM   1338  N   PRO A 175      -6.354 105.717   8.158  1.00 23.17           N  
ATOM   1339  CA  PRO A 175      -7.045 104.502   8.601  1.00 20.78           C  
ATOM   1340  C   PRO A 175      -6.140 103.293   8.393  1.00 18.77           C  
ATOM   1341  O   PRO A 175      -6.050 102.417   9.255  1.00 13.47           O  
ATOM   1342  CB  PRO A 175      -8.276 104.457   7.696  1.00 24.13           C  
ATOM   1343  CG  PRO A 175      -8.561 105.905   7.451  1.00 25.53           C  
ATOM   1344  CD  PRO A 175      -7.180 106.472   7.200  1.00 22.98           C  
ATOM   1345  N   GLN A 176      -5.474 103.258   7.238  1.00 16.60           N  
ATOM   1346  CA  GLN A 176      -4.564 102.170   6.897  1.00 17.22           C  
ATOM   1347  C   GLN A 176      -3.434 102.061   7.917  1.00 19.91           C  
ATOM   1348  O   GLN A 176      -3.152 100.975   8.423  1.00 25.02           O  
ATOM   1349  CB  GLN A 176      -3.959 102.382   5.502  1.00 23.90           C  
ATOM   1350  CG  GLN A 176      -4.934 102.250   4.328  1.00 26.67           C  
ATOM   1351  CD  GLN A 176      -5.954 103.377   4.259  1.00 27.49           C  
ATOM   1352  OE1 GLN A 176      -5.648 104.528   4.574  1.00 26.32           O  
ATOM   1353  NE2 GLN A 176      -7.167 103.053   3.823  1.00 25.54           N  
ATOM   1354  N   GLU A 177      -2.785 103.184   8.212  1.00 16.42           N  
ATOM   1355  CA  GLU A 177      -1.689 103.193   9.177  1.00 17.13           C  
ATOM   1356  C   GLU A 177      -2.221 102.766  10.538  1.00 20.61           C  
ATOM   1357  O   GLU A 177      -1.545 102.060  11.292  1.00 22.16           O  
ATOM   1358  CB  GLU A 177      -1.067 104.589   9.261  1.00 16.50           C  
ATOM   1359  CG  GLU A 177      -0.536 105.096   7.915  1.00 30.80           C  
ATOM   1360  CD  GLU A 177      -0.032 106.531   7.966  1.00 33.58           C  
ATOM   1361  OE1 GLU A 177      -0.722 107.386   8.557  1.00 31.91           O  
ATOM   1362  OE2 GLU A 177       1.049 106.804   7.401  1.00 40.19           O  
ATOM   1363  N   ALA A 178      -3.443 103.188  10.846  1.00 15.58           N  
ATOM   1364  CA  ALA A 178      -4.066 102.835  12.110  1.00 16.69           C  
ATOM   1365  C   ALA A 178      -4.221 101.320  12.188  1.00 17.19           C  
ATOM   1366  O   ALA A 178      -3.988 100.709  13.231  1.00 19.25           O  
ATOM   1367  CB  ALA A 178      -5.429 103.512  12.229  1.00 20.06           C  
ATOM   1368  N   LEU A 179      -4.616 100.712  11.075  1.00 16.15           N  
ATOM   1369  CA  LEU A 179      -4.792  99.267  11.033  1.00 18.02           C  
ATOM   1370  C   LEU A 179      -3.474  98.521  11.271  1.00 19.44           C  
ATOM   1371  O   LEU A 179      -3.433  97.535  12.006  1.00 22.16           O  
ATOM   1372  CB  LEU A 179      -5.385  98.842   9.683  1.00 16.59           C  
ATOM   1373  CG  LEU A 179      -5.647  97.338   9.520  1.00 18.65           C  
ATOM   1374  CD1 LEU A 179      -6.661  96.882  10.567  1.00 10.83           C  
ATOM   1375  CD2 LEU A 179      -6.167  97.051   8.107  1.00 14.54           C  
ATOM   1376  N   GLU A 180      -2.394  98.988  10.656  1.00 19.64           N  
ATOM   1377  CA  GLU A 180      -1.120  98.310  10.824  1.00 23.75           C  
ATOM   1378  C   GLU A 180      -0.543  98.383  12.236  1.00 23.39           C  
ATOM   1379  O   GLU A 180       0.149  97.459  12.659  1.00 21.53           O  
ATOM   1380  CB  GLU A 180      -0.108  98.806   9.787  1.00 30.26           C  
ATOM   1381  CG  GLU A 180      -0.014 100.304   9.638  1.00 51.01           C  
ATOM   1382  CD  GLU A 180       0.548 100.712   8.285  1.00 59.90           C  
ATOM   1383  OE1 GLU A 180      -0.172 100.568   7.271  1.00 63.56           O  
ATOM   1384  OE2 GLU A 180       1.710 101.170   8.231  1.00 63.28           O  
ATOM   1385  N   ILE A 181      -0.832  99.445  12.985  1.00 19.80           N  
ATOM   1386  CA  ILE A 181      -0.300  99.515  14.344  1.00 18.29           C  
ATOM   1387  C   ILE A 181      -1.290  98.977  15.379  1.00 17.81           C  
ATOM   1388  O   ILE A 181      -1.014  98.988  16.581  1.00 18.19           O  
ATOM   1389  CB  ILE A 181       0.109 100.949  14.740  1.00 14.71           C  
ATOM   1390  CG1 ILE A 181      -1.120 101.859  14.790  1.00  5.29           C  
ATOM   1391  CG2 ILE A 181       1.145 101.477  13.763  1.00 17.50           C  
ATOM   1392  CD1 ILE A 181      -0.815 103.258  15.325  1.00 11.91           C  
ATOM   1393  N   GLY A 182      -2.439  98.502  14.908  1.00 15.04           N  
ATOM   1394  CA  GLY A 182      -3.439  97.954  15.808  1.00 14.43           C  
ATOM   1395  C   GLY A 182      -4.366  98.971  16.451  1.00 14.36           C  
ATOM   1396  O   GLY A 182      -5.050  98.653  17.422  1.00 16.11           O  
ATOM   1397  N   LEU A 183      -4.400 100.188  15.916  1.00 12.88           N  
ATOM   1398  CA  LEU A 183      -5.267 101.232  16.462  1.00 13.57           C  
ATOM   1399  C   LEU A 183      -6.738 100.927  16.165  1.00 13.58           C  
ATOM   1400  O   LEU A 183      -7.623 101.284  16.942  1.00 17.38           O  
ATOM   1401  CB  LEU A 183      -4.898 102.594  15.872  1.00 10.69           C  
ATOM   1402  CG  LEU A 183      -4.945 103.806  16.811  1.00 16.55           C  
ATOM   1403  CD1 LEU A 183      -5.112 105.061  15.972  1.00 10.84           C  
ATOM   1404  CD2 LEU A 183      -6.080 103.695  17.806  1.00  9.51           C  
ATOM   1405  N   VAL A 184      -6.997 100.297  15.021  1.00 17.57           N  
ATOM   1406  CA  VAL A 184      -8.357  99.901  14.644  1.00 12.55           C  
ATOM   1407  C   VAL A 184      -8.276  98.416  14.349  1.00 13.44           C  
ATOM   1408  O   VAL A 184      -7.187  97.909  14.072  1.00 14.01           O  
ATOM   1409  CB  VAL A 184      -8.874 100.651  13.378  1.00 13.14           C  
ATOM   1410  CG1 VAL A 184      -8.891 102.149  13.640  1.00  6.51           C  
ATOM   1411  CG2 VAL A 184      -8.007 100.319  12.157  1.00 10.59           C  
ATOM   1412  N   ASN A 185      -9.410  97.719  14.415  1.00 12.86           N  
ATOM   1413  CA  ASN A 185      -9.443  96.277  14.152  1.00 15.14           C  
ATOM   1414  C   ASN A 185      -9.798  95.923  12.712  1.00 18.45           C  
ATOM   1415  O   ASN A 185      -9.497  94.825  12.244  1.00 17.31           O  
ATOM   1416  CB  ASN A 185     -10.451  95.586  15.071  1.00 14.39           C  
ATOM   1417  CG  ASN A 185     -10.229  95.921  16.527  1.00 20.64           C  
ATOM   1418  OD1 ASN A 185     -10.617  96.991  16.995  1.00 17.82           O  
ATOM   1419  ND2 ASN A 185      -9.590  95.007  17.250  1.00 18.03           N  
ATOM   1420  N   ARG A 186     -10.453  96.846  12.020  1.00 14.54           N  
ATOM   1421  CA  ARG A 186     -10.860  96.619  10.637  1.00 16.29           C  
ATOM   1422  C   ARG A 186     -10.907  97.919   9.860  1.00 17.43           C  
ATOM   1423  O   ARG A 186     -11.207  98.975  10.412  1.00 17.63           O  
ATOM   1424  CB  ARG A 186     -12.264  96.013  10.578  1.00 13.72           C  
ATOM   1425  CG  ARG A 186     -12.442  94.674  11.246  1.00 20.63           C  
ATOM   1426  CD  ARG A 186     -12.185  93.534  10.289  1.00 11.82           C  
ATOM   1427  NE  ARG A 186     -12.649  92.274  10.859  1.00 24.10           N  
ATOM   1428  CZ  ARG A 186     -12.136  91.714  11.948  1.00 24.65           C  
ATOM   1429  NH1 ARG A 186     -11.127  92.298  12.588  1.00 23.53           N  
ATOM   1430  NH2 ARG A 186     -12.639  90.578  12.407  1.00 18.09           N  
ATOM   1431  N   VAL A 187     -10.606  97.830   8.572  1.00 19.87           N  
ATOM   1432  CA  VAL A 187     -10.687  98.975   7.678  1.00 20.34           C  
ATOM   1433  C   VAL A 187     -11.563  98.473   6.540  1.00 23.20           C  
ATOM   1434  O   VAL A 187     -11.188  97.541   5.828  1.00 20.74           O  
ATOM   1435  CB  VAL A 187      -9.312  99.403   7.126  1.00 22.13           C  
ATOM   1436  CG1 VAL A 187      -9.504 100.285   5.888  1.00 25.29           C  
ATOM   1437  CG2 VAL A 187      -8.549 100.187   8.190  1.00 16.68           C  
ATOM   1438  N   PHE A 188     -12.743  99.069   6.397  1.00 19.91           N  
ATOM   1439  CA  PHE A 188     -13.686  98.669   5.357  1.00 21.00           C  
ATOM   1440  C   PHE A 188     -13.786  99.721   4.255  1.00 23.31           C  
ATOM   1441  O   PHE A 188     -13.409 100.883   4.452  1.00 23.17           O  
ATOM   1442  CB  PHE A 188     -15.093  98.488   5.942  1.00 21.92           C  
ATOM   1443  CG  PHE A 188     -15.198  97.463   7.042  1.00 23.45           C  
ATOM   1444  CD1 PHE A 188     -14.696  96.174   6.875  1.00 22.31           C  
ATOM   1445  CD2 PHE A 188     -15.880  97.769   8.220  1.00 17.43           C  
ATOM   1446  CE1 PHE A 188     -14.892  95.202   7.860  1.00 24.19           C  
ATOM   1447  CE2 PHE A 188     -16.081  96.806   9.206  1.00 17.97           C  
ATOM   1448  CZ  PHE A 188     -15.583  95.521   9.029  1.00 20.60           C  
ATOM   1449  N   PRO A 189     -14.281  99.322   3.069  1.00 27.13           N  
ATOM   1450  CA  PRO A 189     -14.422 100.293   1.979  1.00 25.25           C  
ATOM   1451  C   PRO A 189     -15.402 101.333   2.523  1.00 21.65           C  
ATOM   1452  O   PRO A 189     -16.454 100.972   3.049  1.00 21.20           O  
ATOM   1453  CB  PRO A 189     -15.032  99.462   0.853  1.00 24.97           C  
ATOM   1454  CG  PRO A 189     -14.459  98.106   1.091  1.00 30.64           C  
ATOM   1455  CD  PRO A 189     -14.565  97.954   2.595  1.00 24.88           C  
ATOM   1456  N   GLN A 190     -15.054 102.609   2.407  1.00 20.20           N  
ATOM   1457  CA  GLN A 190     -15.885 103.692   2.929  1.00 23.92           C  
ATOM   1458  C   GLN A 190     -17.404 103.503   2.866  1.00 28.53           C  
ATOM   1459  O   GLN A 190     -18.079 103.521   3.895  1.00 30.02           O  
ATOM   1460  CB  GLN A 190     -15.515 105.006   2.239  1.00 22.49           C  
ATOM   1461  CG  GLN A 190     -16.031 106.259   2.940  1.00 22.96           C  
ATOM   1462  CD  GLN A 190     -15.440 106.448   4.334  1.00 19.59           C  
ATOM   1463  OE1 GLN A 190     -14.251 106.212   4.554  1.00 21.63           O  
ATOM   1464  NE2 GLN A 190     -16.267 106.893   5.276  1.00 20.75           N  
ATOM   1465  N   ALA A 191     -17.946 103.319   1.668  1.00 30.27           N  
ATOM   1466  CA  ALA A 191     -19.388 103.173   1.504  1.00 29.73           C  
ATOM   1467  C   ALA A 191     -19.988 101.896   2.089  1.00 31.37           C  
ATOM   1468  O   ALA A 191     -21.208 101.747   2.134  1.00 33.23           O  
ATOM   1469  CB  ALA A 191     -19.745 103.282   0.023  1.00 36.04           C  
ATOM   1470  N   GLU A 192     -19.140 100.981   2.541  1.00 30.23           N  
ATOM   1471  CA  GLU A 192     -19.616  99.723   3.108  1.00 30.88           C  
ATOM   1472  C   GLU A 192     -19.335  99.615   4.606  1.00 28.33           C  
ATOM   1473  O   GLU A 192     -19.640  98.598   5.231  1.00 25.31           O  
ATOM   1474  CB  GLU A 192     -18.943  98.555   2.389  1.00 33.73           C  
ATOM   1475  CG  GLU A 192     -19.181  98.525   0.890  1.00 41.14           C  
ATOM   1476  CD  GLU A 192     -18.210  97.613   0.169  1.00 41.84           C  
ATOM   1477  OE1 GLU A 192     -18.078  96.439   0.581  1.00 35.70           O  
ATOM   1478  OE2 GLU A 192     -17.583  98.074  -0.808  1.00 44.04           O  
ATOM   1479  N   THR A 193     -18.769 100.670   5.181  1.00 28.21           N  
ATOM   1480  CA  THR A 193     -18.413 100.667   6.596  1.00 25.79           C  
ATOM   1481  C   THR A 193     -19.559 100.335   7.542  1.00 26.87           C  
ATOM   1482  O   THR A 193     -19.440  99.429   8.371  1.00 24.84           O  
ATOM   1483  CB  THR A 193     -17.782 102.010   6.995  1.00 26.34           C  
ATOM   1484  OG1 THR A 193     -16.620 102.235   6.191  1.00 19.47           O  
ATOM   1485  CG2 THR A 193     -17.370 102.001   8.461  1.00 24.11           C  
ATOM   1486  N   ARG A 194     -20.667 101.060   7.425  1.00 25.97           N  
ATOM   1487  CA  ARG A 194     -21.821 100.812   8.282  1.00 26.89           C  
ATOM   1488  C   ARG A 194     -22.389  99.428   8.029  1.00 30.83           C  
ATOM   1489  O   ARG A 194     -22.767  98.712   8.958  1.00 26.94           O  
ATOM   1490  CB  ARG A 194     -22.915 101.848   8.027  1.00 28.55           C  
ATOM   1491  CG  ARG A 194     -22.598 103.226   8.541  1.00 26.82           C  
ATOM   1492  CD  ARG A 194     -23.864 104.036   8.687  1.00 25.03           C  
ATOM   1493  NE  ARG A 194     -23.598 105.346   9.269  1.00 25.15           N  
ATOM   1494  CZ  ARG A 194     -24.543 106.180   9.684  1.00 29.41           C  
ATOM   1495  NH1 ARG A 194     -25.823 105.838   9.582  1.00 28.91           N  
ATOM   1496  NH2 ARG A 194     -24.206 107.349  10.210  1.00 30.76           N  
ATOM   1497  N   GLU A 195     -22.448  99.067   6.753  1.00 34.42           N  
ATOM   1498  CA  GLU A 195     -22.968  97.779   6.329  1.00 37.51           C  
ATOM   1499  C   GLU A 195     -22.182  96.629   6.952  1.00 33.64           C  
ATOM   1500  O   GLU A 195     -22.753  95.761   7.608  1.00 35.89           O  
ATOM   1501  CB  GLU A 195     -22.901  97.679   4.804  1.00 49.72           C  
ATOM   1502  CG  GLU A 195     -23.591  96.461   4.215  1.00 70.32           C  
ATOM   1503  CD  GLU A 195     -23.322  96.308   2.728  1.00 83.52           C  
ATOM   1504  OE1 GLU A 195     -22.901  97.297   2.092  1.00 89.84           O  
ATOM   1505  OE2 GLU A 195     -23.542  95.200   2.193  1.00 93.48           O  
ATOM   1506  N   ARG A 196     -20.870  96.627   6.749  1.00 27.49           N  
ATOM   1507  CA  ARG A 196     -20.033  95.560   7.280  1.00 24.42           C  
ATOM   1508  C   ARG A 196     -19.936  95.569   8.807  1.00 22.44           C  
ATOM   1509  O   ARG A 196     -19.791  94.517   9.425  1.00 23.87           O  
ATOM   1510  CB  ARG A 196     -18.650  95.624   6.629  1.00 26.32           C  
ATOM   1511  CG  ARG A 196     -18.728  95.511   5.102  1.00 31.33           C  
ATOM   1512  CD  ARG A 196     -17.371  95.313   4.462  1.00 38.25           C  
ATOM   1513  NE  ARG A 196     -16.719  94.109   4.962  1.00 47.84           N  
ATOM   1514  CZ  ARG A 196     -15.525  93.689   4.562  1.00 50.18           C  
ATOM   1515  NH1 ARG A 196     -14.853  94.376   3.647  1.00 51.22           N  
ATOM   1516  NH2 ARG A 196     -14.997  92.590   5.086  1.00 51.15           N  
ATOM   1517  N   THR A 197     -20.024  96.749   9.418  1.00 16.57           N  
ATOM   1518  CA  THR A 197     -19.985  96.837  10.875  1.00 18.84           C  
ATOM   1519  C   THR A 197     -21.250  96.173  11.417  1.00 20.02           C  
ATOM   1520  O   THR A 197     -21.188  95.360  12.345  1.00 18.67           O  
ATOM   1521  CB  THR A 197     -19.947  98.305  11.366  1.00 17.73           C  
ATOM   1522  OG1 THR A 197     -18.726  98.921  10.942  1.00 20.02           O  
ATOM   1523  CG2 THR A 197     -20.034  98.364  12.892  1.00 15.78           C  
ATOM   1524  N   ARG A 198     -22.396  96.520  10.830  1.00 23.84           N  
ATOM   1525  CA  ARG A 198     -23.679  95.951  11.244  1.00 22.70           C  
ATOM   1526  C   ARG A 198     -23.712  94.447  11.011  1.00 22.31           C  
ATOM   1527  O   ARG A 198     -24.308  93.702  11.789  1.00 25.96           O  
ATOM   1528  CB  ARG A 198     -24.832  96.614  10.482  1.00 22.76           C  
ATOM   1529  CG  ARG A 198     -25.247  97.958  11.055  1.00 25.80           C  
ATOM   1530  CD  ARG A 198     -26.056  98.780  10.071  1.00 24.41           C  
ATOM   1531  NE  ARG A 198     -26.476 100.044  10.663  1.00 23.53           N  
ATOM   1532  CZ  ARG A 198     -26.770 101.139   9.968  1.00 26.41           C  
ATOM   1533  NH1 ARG A 198     -26.689 101.128   8.643  1.00 24.69           N  
ATOM   1534  NH2 ARG A 198     -27.140 102.247  10.598  1.00 23.24           N  
ATOM   1535  N   GLU A 199     -23.070  94.008   9.932  1.00 23.33           N  
ATOM   1536  CA  GLU A 199     -23.015  92.589   9.602  1.00 29.44           C  
ATOM   1537  C   GLU A 199     -22.242  91.841  10.685  1.00 26.54           C  
ATOM   1538  O   GLU A 199     -22.615  90.734  11.071  1.00 26.51           O  
ATOM   1539  CB  GLU A 199     -22.340  92.397   8.244  1.00 35.70           C  
ATOM   1540  CG  GLU A 199     -22.212  90.954   7.800  1.00 55.20           C  
ATOM   1541  CD  GLU A 199     -21.634  90.833   6.401  1.00 67.86           C  
ATOM   1542  OE1 GLU A 199     -22.254  91.371   5.458  1.00 74.12           O  
ATOM   1543  OE2 GLU A 199     -20.562  90.206   6.245  1.00 71.59           O  
ATOM   1544  N   TYR A 200     -21.171  92.458  11.177  1.00 28.07           N  
ATOM   1545  CA  TYR A 200     -20.347  91.862  12.225  1.00 24.15           C  
ATOM   1546  C   TYR A 200     -21.164  91.774  13.504  1.00 20.40           C  
ATOM   1547  O   TYR A 200     -21.184  90.737  14.167  1.00 25.99           O  
ATOM   1548  CB  TYR A 200     -19.095  92.717  12.447  1.00 21.18           C  
ATOM   1549  CG  TYR A 200     -18.110  92.183  13.468  1.00 19.19           C  
ATOM   1550  CD1 TYR A 200     -18.337  92.335  14.837  1.00 16.65           C  
ATOM   1551  CD2 TYR A 200     -16.923  91.570  13.063  1.00 18.64           C  
ATOM   1552  CE1 TYR A 200     -17.399  91.895  15.782  1.00 13.61           C  
ATOM   1553  CE2 TYR A 200     -15.980  91.124  13.998  1.00 17.62           C  
ATOM   1554  CZ  TYR A 200     -16.225  91.295  15.356  1.00 19.85           C  
ATOM   1555  OH  TYR A 200     -15.289  90.888  16.285  1.00 15.25           O  
ATOM   1556  N   ALA A 201     -21.846  92.865  13.842  1.00 24.64           N  
ATOM   1557  CA  ALA A 201     -22.673  92.904  15.042  1.00 22.04           C  
ATOM   1558  C   ALA A 201     -23.801  91.881  14.938  1.00 27.59           C  
ATOM   1559  O   ALA A 201     -24.133  91.212  15.917  1.00 27.27           O  
ATOM   1560  CB  ALA A 201     -23.242  94.304  15.245  1.00 19.21           C  
ATOM   1561  N   ARG A 202     -24.394  91.762  13.752  1.00 29.80           N  
ATOM   1562  CA  ARG A 202     -25.470  90.801  13.550  1.00 29.87           C  
ATOM   1563  C   ARG A 202     -25.010  89.393  13.914  1.00 27.07           C  
ATOM   1564  O   ARG A 202     -25.702  88.684  14.648  1.00 25.96           O  
ATOM   1565  CB  ARG A 202     -25.962  90.825  12.096  1.00 39.19           C  
ATOM   1566  CG  ARG A 202     -26.888  91.991  11.761  1.00 53.97           C  
ATOM   1567  CD  ARG A 202     -27.554  91.802  10.398  1.00 61.84           C  
ATOM   1568  NE  ARG A 202     -26.642  92.023   9.273  1.00 69.86           N  
ATOM   1569  CZ  ARG A 202     -26.356  93.218   8.763  1.00 69.46           C  
ATOM   1570  NH1 ARG A 202     -26.910  94.309   9.275  1.00 71.24           N  
ATOM   1571  NH2 ARG A 202     -25.518  93.324   7.741  1.00 70.92           N  
ATOM   1572  N   LYS A 203     -23.846  88.993  13.406  1.00 23.79           N  
ATOM   1573  CA  LYS A 203     -23.309  87.665  13.694  1.00 29.13           C  
ATOM   1574  C   LYS A 203     -23.135  87.442  15.197  1.00 29.86           C  
ATOM   1575  O   LYS A 203     -23.398  86.350  15.704  1.00 30.55           O  
ATOM   1576  CB  LYS A 203     -21.966  87.452  12.987  1.00 30.44           C  
ATOM   1577  CG  LYS A 203     -22.056  87.248  11.476  1.00 37.03           C  
ATOM   1578  CD  LYS A 203     -20.700  86.838  10.902  1.00 39.69           C  
ATOM   1579  CE  LYS A 203     -20.772  86.515   9.412  1.00 49.35           C  
ATOM   1580  NZ  LYS A 203     -21.081  87.707   8.574  1.00 50.49           N  
ATOM   1581  N   LEU A 204     -22.686  88.469  15.911  1.00 26.44           N  
ATOM   1582  CA  LEU A 204     -22.510  88.347  17.355  1.00 25.88           C  
ATOM   1583  C   LEU A 204     -23.864  88.176  18.027  1.00 24.91           C  
ATOM   1584  O   LEU A 204     -24.057  87.261  18.831  1.00 23.99           O  
ATOM   1585  CB  LEU A 204     -21.812  89.585  17.934  1.00 21.06           C  
ATOM   1586  CG  LEU A 204     -20.327  89.789  17.626  1.00 25.18           C  
ATOM   1587  CD1 LEU A 204     -19.823  91.030  18.350  1.00 23.56           C  
ATOM   1588  CD2 LEU A 204     -19.540  88.561  18.069  1.00 19.85           C  
ATOM   1589  N   ALA A 205     -24.803  89.056  17.689  1.00 24.44           N  
ATOM   1590  CA  ALA A 205     -26.141  89.014  18.269  1.00 27.21           C  
ATOM   1591  C   ALA A 205     -26.861  87.695  18.000  1.00 29.50           C  
ATOM   1592  O   ALA A 205     -27.734  87.288  18.765  1.00 29.20           O  
ATOM   1593  CB  ALA A 205     -26.971  90.173  17.739  1.00 28.65           C  
ATOM   1594  N   ASN A 206     -26.491  87.032  16.911  1.00 35.40           N  
ATOM   1595  CA  ASN A 206     -27.109  85.766  16.540  1.00 35.83           C  
ATOM   1596  C   ASN A 206     -26.400  84.532  17.071  1.00 35.20           C  
ATOM   1597  O   ASN A 206     -26.798  83.411  16.765  1.00 39.48           O  
ATOM   1598  CB  ASN A 206     -27.215  85.660  15.020  1.00 38.46           C  
ATOM   1599  CG  ASN A 206     -28.345  86.488  14.467  1.00 43.17           C  
ATOM   1600  OD1 ASN A 206     -29.511  86.234  14.762  1.00 52.63           O  
ATOM   1601  ND2 ASN A 206     -28.009  87.491  13.665  1.00 46.78           N  
ATOM   1602  N   SER A 207     -25.351  84.727  17.860  1.00 31.37           N  
ATOM   1603  CA  SER A 207     -24.620  83.591  18.410  1.00 29.60           C  
ATOM   1604  C   SER A 207     -24.903  83.442  19.902  1.00 28.63           C  
ATOM   1605  O   SER A 207     -25.906  83.952  20.405  1.00 25.61           O  
ATOM   1606  CB  SER A 207     -23.115  83.761  18.165  1.00 31.62           C  
ATOM   1607  OG  SER A 207     -22.632  84.977  18.711  1.00 26.60           O  
ATOM   1608  N   ALA A 208     -24.028  82.726  20.603  1.00 30.36           N  
ATOM   1609  CA  ALA A 208     -24.184  82.527  22.038  1.00 24.18           C  
ATOM   1610  C   ALA A 208     -23.751  83.822  22.711  1.00 28.66           C  
ATOM   1611  O   ALA A 208     -22.630  83.936  23.211  1.00 30.06           O  
ATOM   1612  CB  ALA A 208     -23.317  81.365  22.503  1.00 26.88           C  
ATOM   1613  N   THR A 209     -24.658  84.792  22.724  1.00 27.23           N  
ATOM   1614  CA  THR A 209     -24.391  86.106  23.287  1.00 24.76           C  
ATOM   1615  C   THR A 209     -23.954  86.143  24.752  1.00 23.75           C  
ATOM   1616  O   THR A 209     -23.288  87.092  25.174  1.00 25.38           O  
ATOM   1617  CB  THR A 209     -25.609  87.037  23.077  1.00 21.01           C  
ATOM   1618  OG1 THR A 209     -26.759  86.497  23.739  1.00 19.02           O  
ATOM   1619  CG2 THR A 209     -25.913  87.167  21.590  1.00 19.42           C  
ATOM   1620  N   TYR A 210     -24.315  85.126  25.526  1.00 23.42           N  
ATOM   1621  CA  TYR A 210     -23.915  85.081  26.932  1.00 20.01           C  
ATOM   1622  C   TYR A 210     -22.419  84.782  26.963  1.00 21.69           C  
ATOM   1623  O   TYR A 210     -21.678  85.316  27.785  1.00 23.56           O  
ATOM   1624  CB  TYR A 210     -24.688  83.988  27.670  1.00 22.31           C  
ATOM   1625  CG  TYR A 210     -24.579  84.017  29.184  1.00 19.37           C  
ATOM   1626  CD1 TYR A 210     -23.990  85.091  29.850  1.00 24.29           C  
ATOM   1627  CD2 TYR A 210     -25.112  82.983  29.953  1.00 23.74           C  
ATOM   1628  CE1 TYR A 210     -23.939  85.135  31.240  1.00 21.90           C  
ATOM   1629  CE2 TYR A 210     -25.069  83.017  31.342  1.00 25.28           C  
ATOM   1630  CZ  TYR A 210     -24.483  84.094  31.979  1.00 28.11           C  
ATOM   1631  OH  TYR A 210     -24.454  84.133  33.352  1.00 30.19           O  
ATOM   1632  N   ALA A 211     -21.984  83.923  26.047  1.00 22.25           N  
ATOM   1633  CA  ALA A 211     -20.579  83.561  25.946  1.00 21.57           C  
ATOM   1634  C   ALA A 211     -19.817  84.773  25.431  1.00 20.49           C  
ATOM   1635  O   ALA A 211     -18.757  85.121  25.948  1.00 25.15           O  
ATOM   1636  CB  ALA A 211     -20.403  82.382  24.989  1.00 13.65           C  
ATOM   1637  N   VAL A 212     -20.370  85.418  24.410  1.00 17.42           N  
ATOM   1638  CA  VAL A 212     -19.743  86.599  23.832  1.00 15.37           C  
ATOM   1639  C   VAL A 212     -19.542  87.648  24.916  1.00 19.62           C  
ATOM   1640  O   VAL A 212     -18.462  88.222  25.054  1.00 19.15           O  
ATOM   1641  CB  VAL A 212     -20.621  87.210  22.719  1.00 15.23           C  
ATOM   1642  CG1 VAL A 212     -20.138  88.615  22.384  1.00 17.52           C  
ATOM   1643  CG2 VAL A 212     -20.565  86.328  21.472  1.00 18.69           C  
ATOM   1644  N   SER A 213     -20.596  87.882  25.687  1.00 16.31           N  
ATOM   1645  CA  SER A 213     -20.567  88.870  26.751  1.00 21.57           C  
ATOM   1646  C   SER A 213     -19.534  88.554  27.836  1.00 22.63           C  
ATOM   1647  O   SER A 213     -18.724  89.410  28.199  1.00 24.71           O  
ATOM   1648  CB  SER A 213     -21.962  88.999  27.366  1.00 15.75           C  
ATOM   1649  OG  SER A 213     -21.973  89.999  28.366  1.00 35.13           O  
ATOM   1650  N   ASN A 214     -19.558  87.328  28.350  1.00 15.41           N  
ATOM   1651  CA  ASN A 214     -18.610  86.937  29.384  1.00 16.31           C  
ATOM   1652  C   ASN A 214     -17.170  86.961  28.862  1.00 17.11           C  
ATOM   1653  O   ASN A 214     -16.240  87.217  29.620  1.00 16.55           O  
ATOM   1654  CB  ASN A 214     -18.976  85.553  29.942  1.00 17.27           C  
ATOM   1655  CG  ASN A 214     -20.036  85.627  31.028  1.00 18.32           C  
ATOM   1656  OD1 ASN A 214     -20.751  86.625  31.146  1.00 18.09           O  
ATOM   1657  ND2 ASN A 214     -20.149  84.568  31.827  1.00 18.78           N  
ATOM   1658  N   ILE A 215     -16.985  86.706  27.569  1.00 22.44           N  
ATOM   1659  CA  ILE A 215     -15.646  86.740  26.975  1.00 20.05           C  
ATOM   1660  C   ILE A 215     -15.114  88.176  27.008  1.00 20.57           C  
ATOM   1661  O   ILE A 215     -13.958  88.419  27.371  1.00 17.03           O  
ATOM   1662  CB  ILE A 215     -15.658  86.266  25.501  1.00 17.37           C  
ATOM   1663  CG1 ILE A 215     -15.846  84.750  25.436  1.00 18.45           C  
ATOM   1664  CG2 ILE A 215     -14.359  86.670  24.809  1.00 15.72           C  
ATOM   1665  CD1 ILE A 215     -16.034  84.221  24.023  1.00 20.10           C  
ATOM   1666  N   LYS A 216     -15.971  89.118  26.616  1.00 15.14           N  
ATOM   1667  CA  LYS A 216     -15.622  90.532  26.595  1.00 15.50           C  
ATOM   1668  C   LYS A 216     -15.260  91.008  27.997  1.00 10.59           C  
ATOM   1669  O   LYS A 216     -14.323  91.776  28.168  1.00  9.40           O  
ATOM   1670  CB  LYS A 216     -16.785  91.355  26.011  1.00 16.50           C  
ATOM   1671  CG  LYS A 216     -16.691  92.872  26.211  1.00 16.19           C  
ATOM   1672  CD  LYS A 216     -17.274  93.286  27.563  1.00 17.21           C  
ATOM   1673  CE  LYS A 216     -17.020  94.753  27.879  1.00 14.29           C  
ATOM   1674  NZ  LYS A 216     -17.719  95.684  26.952  1.00 15.12           N  
ATOM   1675  N   LEU A 217     -16.002  90.551  29.000  1.00 12.64           N  
ATOM   1676  CA  LEU A 217     -15.718  90.928  30.378  1.00 13.08           C  
ATOM   1677  C   LEU A 217     -14.394  90.313  30.833  1.00 17.14           C  
ATOM   1678  O   LEU A 217     -13.579  90.961  31.491  1.00 15.63           O  
ATOM   1679  CB  LEU A 217     -16.836  90.448  31.310  1.00 12.07           C  
ATOM   1680  CG  LEU A 217     -18.203  91.127  31.191  1.00 14.78           C  
ATOM   1681  CD1 LEU A 217     -19.192  90.429  32.111  1.00 11.23           C  
ATOM   1682  CD2 LEU A 217     -18.079  92.605  31.546  1.00 11.33           C  
ATOM   1683  N   ALA A 218     -14.193  89.050  30.482  1.00 13.20           N  
ATOM   1684  CA  ALA A 218     -12.981  88.339  30.857  1.00 18.23           C  
ATOM   1685  C   ALA A 218     -11.716  89.048  30.391  1.00 15.10           C  
ATOM   1686  O   ALA A 218     -10.761  89.203  31.154  1.00 14.27           O  
ATOM   1687  CB  ALA A 218     -13.019  86.919  30.292  1.00 13.87           C  
ATOM   1688  N   ILE A 219     -11.715  89.492  29.141  1.00 15.10           N  
ATOM   1689  CA  ILE A 219     -10.542  90.148  28.573  1.00 15.23           C  
ATOM   1690  C   ILE A 219     -10.335  91.606  28.984  1.00 16.41           C  
ATOM   1691  O   ILE A 219      -9.231  91.990  29.367  1.00 18.38           O  
ATOM   1692  CB  ILE A 219     -10.574  90.063  27.035  1.00 21.81           C  
ATOM   1693  CG1 ILE A 219     -10.578  88.592  26.602  1.00 18.17           C  
ATOM   1694  CG2 ILE A 219      -9.374  90.799  26.440  1.00 16.16           C  
ATOM   1695  CD1 ILE A 219     -10.755  88.398  25.107  1.00 21.92           C  
HETATM 1696  N   MSE A 220     -11.384  92.415  28.912  1.00 14.47           N  
HETATM 1697  CA  MSE A 220     -11.252  93.827  29.256  1.00 20.28           C  
HETATM 1698  C   MSE A 220     -10.903  94.085  30.721  1.00 17.51           C  
HETATM 1699  O   MSE A 220     -10.150  95.005  31.028  1.00 19.69           O  
HETATM 1700  CB  MSE A 220     -12.527  94.585  28.875  1.00 16.34           C  
HETATM 1701  CG  MSE A 220     -12.835  94.548  27.379  1.00 19.36           C  
HETATM 1702 SE   MSE A 220     -11.289  94.985  26.279  1.00 30.34          SE  
HETATM 1703  CE  MSE A 220     -10.843  96.695  27.080  1.00 19.42           C  
ATOM   1704  N   ASN A 221     -11.448  93.275  31.622  1.00 14.66           N  
ATOM   1705  CA  ASN A 221     -11.172  93.443  33.045  1.00 14.30           C  
ATOM   1706  C   ASN A 221     -10.052  92.516  33.507  1.00 12.79           C  
ATOM   1707  O   ASN A 221      -9.363  92.803  34.483  1.00 15.30           O  
ATOM   1708  CB  ASN A 221     -12.446  93.186  33.856  1.00 15.06           C  
ATOM   1709  CG  ASN A 221     -13.552  94.185  33.533  1.00 21.16           C  
ATOM   1710  OD1 ASN A 221     -13.446  95.378  33.844  1.00 18.16           O  
ATOM   1711  ND2 ASN A 221     -14.615  93.705  32.898  1.00 19.67           N  
ATOM   1712  N   GLY A 222      -9.867  91.406  32.798  1.00  9.68           N  
ATOM   1713  CA  GLY A 222      -8.817  90.472  33.164  1.00  9.60           C  
ATOM   1714  C   GLY A 222      -7.431  90.974  32.798  1.00 12.82           C  
ATOM   1715  O   GLY A 222      -6.435  90.558  33.390  1.00 11.35           O  
ATOM   1716  N   LYS A 223      -7.352  91.882  31.831  1.00 12.30           N  
ATOM   1717  CA  LYS A 223      -6.052  92.393  31.423  1.00 14.82           C  
ATOM   1718  C   LYS A 223      -5.417  93.274  32.492  1.00  9.26           C  
ATOM   1719  O   LYS A 223      -4.233  93.566  32.425  1.00 19.02           O  
ATOM   1720  CB  LYS A 223      -6.160  93.150  30.090  1.00 18.26           C  
ATOM   1721  CG  LYS A 223      -6.923  94.459  30.118  1.00 17.67           C  
ATOM   1722  CD  LYS A 223      -6.949  95.071  28.720  1.00 16.58           C  
ATOM   1723  CE  LYS A 223      -7.449  96.497  28.745  1.00 14.70           C  
ATOM   1724  NZ  LYS A 223      -6.481  97.385  29.446  1.00 17.16           N  
ATOM   1725  N   GLU A 224      -6.205  93.678  33.483  1.00 15.74           N  
ATOM   1726  CA  GLU A 224      -5.718  94.518  34.576  1.00 12.68           C  
ATOM   1727  C   GLU A 224      -5.201  93.692  35.746  1.00 16.51           C  
ATOM   1728  O   GLU A 224      -4.657  94.245  36.705  1.00 18.57           O  
ATOM   1729  CB  GLU A 224      -6.838  95.418  35.106  1.00 15.84           C  
ATOM   1730  CG  GLU A 224      -7.484  96.320  34.076  1.00 15.52           C  
ATOM   1731  CD  GLU A 224      -6.491  97.234  33.403  1.00 20.62           C  
ATOM   1732  OE1 GLU A 224      -5.588  97.750  34.097  1.00 26.09           O  
ATOM   1733  OE2 GLU A 224      -6.621  97.450  32.182  1.00 19.85           O  
HETATM 1734  N   MSE A 225      -5.371  92.374  35.671  1.00 12.53           N  
HETATM 1735  CA  MSE A 225      -4.953  91.483  36.755  1.00 13.86           C  
HETATM 1736  C   MSE A 225      -3.709  90.652  36.446  1.00 12.55           C  
HETATM 1737  O   MSE A 225      -3.342  90.466  35.286  1.00 16.03           O  
HETATM 1738  CB  MSE A 225      -6.090  90.504  37.092  1.00 13.09           C  
HETATM 1739  CG  MSE A 225      -7.501  91.084  37.068  1.00 15.17           C  
HETATM 1740 SE   MSE A 225      -8.840  89.665  37.131  1.00 29.55          SE  
HETATM 1741  CE  MSE A 225     -10.454  90.718  37.287  1.00 16.28           C  
ATOM   1742  N   PRO A 226      -3.029  90.161  37.494  1.00 17.70           N  
ATOM   1743  CA  PRO A 226      -1.838  89.332  37.279  1.00 15.17           C  
ATOM   1744  C   PRO A 226      -2.366  88.048  36.638  1.00 15.02           C  
ATOM   1745  O   PRO A 226      -3.489  87.631  36.933  1.00 12.55           O  
ATOM   1746  CB  PRO A 226      -1.326  89.100  38.696  1.00 14.02           C  
ATOM   1747  CG  PRO A 226      -1.703  90.378  39.387  1.00 14.57           C  
ATOM   1748  CD  PRO A 226      -3.106  90.612  38.897  1.00 13.31           C  
ATOM   1749  N   LEU A 227      -1.573  87.419  35.779  1.00  9.28           N  
ATOM   1750  CA  LEU A 227      -2.020  86.217  35.086  1.00 13.28           C  
ATOM   1751  C   LEU A 227      -2.600  85.103  35.963  1.00 14.26           C  
ATOM   1752  O   LEU A 227      -3.675  84.587  35.671  1.00 16.18           O  
ATOM   1753  CB  LEU A 227      -0.878  85.642  34.242  1.00 12.39           C  
ATOM   1754  CG  LEU A 227      -1.279  84.495  33.302  1.00 12.57           C  
ATOM   1755  CD1 LEU A 227      -2.325  84.992  32.305  1.00 13.16           C  
ATOM   1756  CD2 LEU A 227      -0.050  83.970  32.565  1.00 13.69           C  
ATOM   1757  N   ASN A 228      -1.897  84.733  37.028  1.00 18.26           N  
ATOM   1758  CA  ASN A 228      -2.352  83.656  37.897  1.00 15.55           C  
ATOM   1759  C   ASN A 228      -3.749  83.846  38.490  1.00 21.12           C  
ATOM   1760  O   ASN A 228      -4.449  82.864  38.744  1.00 27.45           O  
ATOM   1761  CB  ASN A 228      -1.337  83.400  39.020  1.00 14.43           C  
ATOM   1762  CG  ASN A 228      -1.523  82.031  39.672  1.00 21.87           C  
ATOM   1763  OD1 ASN A 228      -1.706  81.928  40.882  1.00 19.95           O  
ATOM   1764  ND2 ASN A 228      -1.481  80.975  38.862  1.00 14.70           N  
ATOM   1765  N   VAL A 229      -4.166  85.089  38.722  1.00 17.00           N  
ATOM   1766  CA  VAL A 229      -5.511  85.315  39.251  1.00 15.55           C  
ATOM   1767  C   VAL A 229      -6.476  85.718  38.142  1.00 16.52           C  
ATOM   1768  O   VAL A 229      -7.696  85.597  38.293  1.00 14.30           O  
ATOM   1769  CB  VAL A 229      -5.536  86.390  40.370  1.00 15.95           C  
ATOM   1770  CG1 VAL A 229      -4.906  85.821  41.638  1.00 21.86           C  
ATOM   1771  CG2 VAL A 229      -4.808  87.645  39.921  1.00 13.57           C  
ATOM   1772  N   ALA A 230      -5.928  86.196  37.025  1.00 13.17           N  
ATOM   1773  CA  ALA A 230      -6.752  86.594  35.884  1.00 11.67           C  
ATOM   1774  C   ALA A 230      -7.504  85.369  35.379  1.00 13.13           C  
ATOM   1775  O   ALA A 230      -8.672  85.442  34.990  1.00 11.00           O  
ATOM   1776  CB  ALA A 230      -5.875  87.154  34.770  1.00  6.77           C  
ATOM   1777  N   ILE A 231      -6.817  84.236  35.380  1.00 14.55           N  
ATOM   1778  CA  ILE A 231      -7.425  83.005  34.925  1.00 14.63           C  
ATOM   1779  C   ILE A 231      -8.501  82.556  35.922  1.00 17.14           C  
ATOM   1780  O   ILE A 231      -9.415  81.823  35.562  1.00 15.50           O  
ATOM   1781  CB  ILE A 231      -6.344  81.930  34.706  1.00 19.47           C  
ATOM   1782  CG1 ILE A 231      -5.369  82.426  33.621  1.00 15.09           C  
ATOM   1783  CG2 ILE A 231      -6.988  80.607  34.287  1.00 16.86           C  
ATOM   1784  CD1 ILE A 231      -4.176  81.531  33.366  1.00 14.07           C  
ATOM   1785  N   ARG A 232      -8.405  83.010  37.169  1.00 12.96           N  
ATOM   1786  CA  ARG A 232      -9.423  82.662  38.159  1.00 16.49           C  
ATOM   1787  C   ARG A 232     -10.703  83.429  37.794  1.00 19.08           C  
ATOM   1788  O   ARG A 232     -11.808  82.897  37.883  1.00 21.07           O  
ATOM   1789  CB  ARG A 232      -8.983  83.065  39.574  1.00 15.58           C  
ATOM   1790  CG  ARG A 232      -7.706  82.403  40.089  1.00 21.14           C  
ATOM   1791  CD  ARG A 232      -7.904  80.929  40.417  1.00 25.19           C  
ATOM   1792  NE  ARG A 232      -7.929  80.090  39.222  1.00 22.08           N  
ATOM   1793  CZ  ARG A 232      -6.867  79.837  38.467  1.00 22.56           C  
ATOM   1794  NH1 ARG A 232      -6.983  79.061  37.394  1.00 19.24           N  
ATOM   1795  NH2 ARG A 232      -5.691  80.356  38.789  1.00 17.58           N  
ATOM   1796  N   TYR A 233     -10.542  84.686  37.388  1.00 16.09           N  
ATOM   1797  CA  TYR A 233     -11.673  85.533  37.004  1.00 16.07           C  
ATOM   1798  C   TYR A 233     -12.325  84.919  35.766  1.00 16.03           C  
ATOM   1799  O   TYR A 233     -13.550  84.868  35.640  1.00 14.93           O  
ATOM   1800  CB  TYR A 233     -11.165  86.952  36.715  1.00 12.50           C  
ATOM   1801  CG  TYR A 233     -12.180  87.918  36.137  1.00 14.06           C  
ATOM   1802  CD1 TYR A 233     -13.345  88.254  36.833  1.00 20.42           C  
ATOM   1803  CD2 TYR A 233     -11.951  88.533  34.907  1.00 14.02           C  
ATOM   1804  CE1 TYR A 233     -14.252  89.183  36.316  1.00  9.21           C  
ATOM   1805  CE2 TYR A 233     -12.845  89.456  34.385  1.00 12.76           C  
ATOM   1806  CZ  TYR A 233     -13.990  89.778  35.092  1.00 16.95           C  
ATOM   1807  OH  TYR A 233     -14.864  90.699  34.562  1.00 18.01           O  
ATOM   1808  N   GLU A 234     -11.480  84.441  34.861  1.00 21.13           N  
ATOM   1809  CA  GLU A 234     -11.928  83.801  33.634  1.00 18.14           C  
ATOM   1810  C   GLU A 234     -12.654  82.507  33.976  1.00 20.77           C  
ATOM   1811  O   GLU A 234     -13.616  82.128  33.307  1.00 21.66           O  
ATOM   1812  CB  GLU A 234     -10.719  83.501  32.751  1.00 20.02           C  
ATOM   1813  CG  GLU A 234     -10.917  82.382  31.738  1.00 27.17           C  
ATOM   1814  CD  GLU A 234      -9.607  81.961  31.090  1.00 28.96           C  
ATOM   1815  OE1 GLU A 234      -9.072  82.734  30.263  1.00 22.85           O  
ATOM   1816  OE2 GLU A 234      -9.105  80.863  31.427  1.00 26.66           O  
ATOM   1817  N   GLY A 235     -12.189  81.837  35.026  1.00 24.00           N  
ATOM   1818  CA  GLY A 235     -12.793  80.582  35.441  1.00 19.86           C  
ATOM   1819  C   GLY A 235     -14.181  80.743  36.023  1.00 21.48           C  
ATOM   1820  O   GLY A 235     -15.016  79.852  35.883  1.00 22.46           O  
ATOM   1821  N   GLU A 236     -14.427  81.867  36.690  1.00 20.70           N  
ATOM   1822  CA  GLU A 236     -15.737  82.118  37.278  1.00 19.43           C  
ATOM   1823  C   GLU A 236     -16.719  82.482  36.173  1.00 23.14           C  
ATOM   1824  O   GLU A 236     -17.894  82.108  36.224  1.00 17.85           O  
ATOM   1825  CB  GLU A 236     -15.666  83.247  38.310  1.00 25.84           C  
ATOM   1826  CG  GLU A 236     -14.803  82.930  39.523  1.00 28.71           C  
ATOM   1827  CD  GLU A 236     -15.054  81.532  40.081  1.00 37.50           C  
ATOM   1828  OE1 GLU A 236     -16.232  81.168  40.303  1.00 30.22           O  
ATOM   1829  OE2 GLU A 236     -14.066  80.798  40.300  1.00 35.79           O  
ATOM   1830  N   LEU A 237     -16.234  83.216  35.174  1.00 18.96           N  
ATOM   1831  CA  LEU A 237     -17.068  83.599  34.047  1.00 22.70           C  
ATOM   1832  C   LEU A 237     -17.436  82.330  33.282  1.00 26.17           C  
ATOM   1833  O   LEU A 237     -18.556  82.199  32.778  1.00 24.89           O  
ATOM   1834  CB  LEU A 237     -16.321  84.576  33.137  1.00 17.98           C  
ATOM   1835  CG  LEU A 237     -16.217  86.011  33.664  1.00 23.11           C  
ATOM   1836  CD1 LEU A 237     -15.038  86.718  33.023  1.00 23.86           C  
ATOM   1837  CD2 LEU A 237     -17.521  86.757  33.391  1.00 19.55           C  
ATOM   1838  N   GLN A 238     -16.491  81.396  33.208  1.00 24.76           N  
ATOM   1839  CA  GLN A 238     -16.719  80.125  32.527  1.00 25.02           C  
ATOM   1840  C   GLN A 238     -17.709  79.292  33.342  1.00 24.62           C  
ATOM   1841  O   GLN A 238     -18.533  78.569  32.783  1.00 24.15           O  
ATOM   1842  CB  GLN A 238     -15.409  79.352  32.374  1.00 23.46           C  
ATOM   1843  CG  GLN A 238     -15.553  77.991  31.684  1.00 22.96           C  
ATOM   1844  CD  GLN A 238     -15.647  78.098  30.173  1.00 23.92           C  
ATOM   1845  OE1 GLN A 238     -16.543  78.749  29.639  1.00 22.97           O  
ATOM   1846  NE2 GLN A 238     -14.716  77.452  29.476  1.00 20.02           N  
ATOM   1847  N   ASN A 239     -17.620  79.389  34.665  1.00 21.61           N  
ATOM   1848  CA  ASN A 239     -18.532  78.652  35.529  1.00 25.13           C  
ATOM   1849  C   ASN A 239     -19.958  79.078  35.194  1.00 29.02           C  
ATOM   1850  O   ASN A 239     -20.846  78.243  35.046  1.00 27.33           O  
ATOM   1851  CB  ASN A 239     -18.230  78.938  37.003  1.00 19.92           C  
ATOM   1852  CG  ASN A 239     -17.099  78.081  37.548  1.00 21.77           C  
ATOM   1853  OD1 ASN A 239     -16.507  78.401  38.580  1.00 20.83           O  
ATOM   1854  ND2 ASN A 239     -16.803  76.983  36.866  1.00 16.59           N  
ATOM   1855  N   LEU A 240     -20.171  80.383  35.067  1.00 25.67           N  
ATOM   1856  CA  LEU A 240     -21.491  80.905  34.734  1.00 26.60           C  
ATOM   1857  C   LEU A 240     -21.960  80.350  33.392  1.00 27.75           C  
ATOM   1858  O   LEU A 240     -23.141  80.052  33.214  1.00 25.94           O  
ATOM   1859  CB  LEU A 240     -21.456  82.436  34.691  1.00 21.23           C  
ATOM   1860  CG  LEU A 240     -21.431  83.091  36.072  1.00 15.64           C  
ATOM   1861  CD1 LEU A 240     -20.882  84.499  35.989  1.00 18.04           C  
ATOM   1862  CD2 LEU A 240     -22.844  83.089  36.631  1.00 14.96           C  
ATOM   1863  N   LEU A 241     -21.029  80.207  32.453  1.00 25.29           N  
ATOM   1864  CA  LEU A 241     -21.354  79.685  31.130  1.00 25.28           C  
ATOM   1865  C   LEU A 241     -21.673  78.192  31.161  1.00 28.97           C  
ATOM   1866  O   LEU A 241     -22.527  77.728  30.408  1.00 33.14           O  
ATOM   1867  CB  LEU A 241     -20.201  79.959  30.157  1.00 22.59           C  
ATOM   1868  CG  LEU A 241     -20.308  81.180  29.230  1.00 23.33           C  
ATOM   1869  CD1 LEU A 241     -21.129  82.295  29.864  1.00 22.33           C  
ATOM   1870  CD2 LEU A 241     -18.912  81.655  28.886  1.00 14.22           C  
ATOM   1871  N   PHE A 242     -20.994  77.441  32.025  1.00 27.23           N  
ATOM   1872  CA  PHE A 242     -21.250  76.007  32.128  1.00 27.97           C  
ATOM   1873  C   PHE A 242     -22.632  75.780  32.708  1.00 28.34           C  
ATOM   1874  O   PHE A 242     -23.234  74.731  32.488  1.00 29.98           O  
ATOM   1875  CB  PHE A 242     -20.225  75.303  33.029  1.00 27.08           C  
ATOM   1876  CG  PHE A 242     -18.915  75.005  32.354  1.00 30.06           C  
ATOM   1877  CD1 PHE A 242     -18.872  74.624  31.017  1.00 32.65           C  
ATOM   1878  CD2 PHE A 242     -17.726  75.066  33.068  1.00 25.92           C  
ATOM   1879  CE1 PHE A 242     -17.663  74.313  30.402  1.00 27.72           C  
ATOM   1880  CE2 PHE A 242     -16.512  74.756  32.463  1.00 25.96           C  
ATOM   1881  CZ  PHE A 242     -16.483  74.377  31.127  1.00 26.84           C  
ATOM   1882  N   ARG A 243     -23.128  76.762  33.453  1.00 27.43           N  
ATOM   1883  CA  ARG A 243     -24.446  76.654  34.065  1.00 29.52           C  
ATOM   1884  C   ARG A 243     -25.567  77.271  33.230  1.00 31.06           C  
ATOM   1885  O   ARG A 243     -26.723  77.255  33.647  1.00 34.74           O  
ATOM   1886  CB  ARG A 243     -24.456  77.299  35.456  1.00 30.09           C  
ATOM   1887  CG  ARG A 243     -23.802  76.480  36.564  1.00 30.60           C  
ATOM   1888  CD  ARG A 243     -22.288  76.594  36.541  1.00 41.18           C  
ATOM   1889  NE  ARG A 243     -21.648  75.849  37.622  1.00 38.11           N  
ATOM   1890  CZ  ARG A 243     -21.950  75.989  38.907  1.00 33.66           C  
ATOM   1891  NH1 ARG A 243     -22.887  76.848  39.282  1.00 35.51           N  
ATOM   1892  NH2 ARG A 243     -21.319  75.262  39.817  1.00 38.30           N  
ATOM   1893  N   SER A 244     -25.239  77.811  32.060  1.00 29.46           N  
ATOM   1894  CA  SER A 244     -26.261  78.432  31.221  1.00 30.95           C  
ATOM   1895  C   SER A 244     -26.943  77.421  30.309  1.00 35.37           C  
ATOM   1896  O   SER A 244     -26.484  76.287  30.160  1.00 35.08           O  
ATOM   1897  CB  SER A 244     -25.658  79.555  30.367  1.00 28.76           C  
ATOM   1898  OG  SER A 244     -24.878  79.039  29.295  1.00 25.55           O  
ATOM   1899  N   GLU A 245     -28.040  77.847  29.691  1.00 39.00           N  
ATOM   1900  CA  GLU A 245     -28.793  76.986  28.792  1.00 40.79           C  
ATOM   1901  C   GLU A 245     -28.124  76.901  27.428  1.00 39.38           C  
ATOM   1902  O   GLU A 245     -28.142  75.854  26.782  1.00 42.10           O  
ATOM   1903  CB  GLU A 245     -30.224  77.507  28.650  1.00 47.21           C  
ATOM   1904  CG  GLU A 245     -31.024  77.414  29.939  1.00 61.11           C  
ATOM   1905  CD  GLU A 245     -32.386  78.066  29.835  1.00 69.49           C  
ATOM   1906  OE1 GLU A 245     -33.146  77.718  28.906  1.00 75.19           O  
ATOM   1907  OE2 GLU A 245     -32.699  78.923  30.688  1.00 72.18           O  
ATOM   1908  N   ASP A 246     -27.526  78.002  26.990  1.00 34.07           N  
ATOM   1909  CA  ASP A 246     -26.855  78.020  25.699  1.00 33.66           C  
ATOM   1910  C   ASP A 246     -25.713  77.017  25.658  1.00 31.43           C  
ATOM   1911  O   ASP A 246     -25.443  76.423  24.617  1.00 30.02           O  
ATOM   1912  CB  ASP A 246     -26.336  79.426  25.395  1.00 39.50           C  
ATOM   1913  CG  ASP A 246     -27.431  80.355  24.914  1.00 40.68           C  
ATOM   1914  OD1 ASP A 246     -28.585  80.193  25.362  1.00 43.12           O  
ATOM   1915  OD2 ASP A 246     -27.137  81.251  24.097  1.00 43.75           O  
ATOM   1916  N   ALA A 247     -25.040  76.832  26.792  1.00 31.88           N  
ATOM   1917  CA  ALA A 247     -23.930  75.886  26.879  1.00 32.05           C  
ATOM   1918  C   ALA A 247     -24.473  74.484  26.644  1.00 30.40           C  
ATOM   1919  O   ALA A 247     -23.934  73.716  25.846  1.00 31.64           O  
ATOM   1920  CB  ALA A 247     -23.271  75.971  28.254  1.00 25.33           C  
ATOM   1921  N   LYS A 248     -25.546  74.158  27.358  1.00 35.67           N  
ATOM   1922  CA  LYS A 248     -26.198  72.863  27.223  1.00 36.29           C  
ATOM   1923  C   LYS A 248     -26.540  72.696  25.747  1.00 36.72           C  
ATOM   1924  O   LYS A 248     -26.132  71.732  25.102  1.00 33.71           O  
ATOM   1925  CB  LYS A 248     -27.480  72.836  28.060  1.00 42.79           C  
ATOM   1926  CG  LYS A 248     -27.265  72.914  29.567  1.00 55.84           C  
ATOM   1927  CD  LYS A 248     -28.544  73.350  30.281  1.00 69.34           C  
ATOM   1928  CE  LYS A 248     -28.543  72.977  31.765  1.00 74.62           C  
ATOM   1929  NZ  LYS A 248     -27.375  73.509  32.521  1.00 74.33           N  
ATOM   1930  N   GLU A 249     -27.281  73.667  25.224  1.00 34.79           N  
ATOM   1931  CA  GLU A 249     -27.702  73.678  23.829  1.00 38.27           C  
ATOM   1932  C   GLU A 249     -26.524  73.589  22.864  1.00 39.90           C  
ATOM   1933  O   GLU A 249     -26.553  72.819  21.907  1.00 43.77           O  
ATOM   1934  CB  GLU A 249     -28.497  74.958  23.551  1.00 38.09           C  
ATOM   1935  CG  GLU A 249     -28.939  75.144  22.108  1.00 41.94           C  
ATOM   1936  CD  GLU A 249     -29.829  74.019  21.614  1.00 48.79           C  
ATOM   1937  OE1 GLU A 249     -30.760  73.627  22.351  1.00 53.53           O  
ATOM   1938  OE2 GLU A 249     -29.604  73.536  20.485  1.00 44.13           O  
ATOM   1939  N   GLY A 250     -25.488  74.384  23.124  1.00 44.01           N  
ATOM   1940  CA  GLY A 250     -24.318  74.396  22.265  1.00 37.93           C  
ATOM   1941  C   GLY A 250     -23.597  73.067  22.174  1.00 42.15           C  
ATOM   1942  O   GLY A 250     -23.171  72.662  21.095  1.00 42.30           O  
ATOM   1943  N   LEU A 251     -23.448  72.387  23.306  1.00 46.89           N  
ATOM   1944  CA  LEU A 251     -22.768  71.099  23.319  1.00 51.60           C  
ATOM   1945  C   LEU A 251     -23.610  70.014  22.651  1.00 53.32           C  
ATOM   1946  O   LEU A 251     -23.079  69.163  21.937  1.00 53.30           O  
ATOM   1947  CB  LEU A 251     -22.412  70.701  24.757  1.00 55.51           C  
ATOM   1948  CG  LEU A 251     -21.146  71.344  25.351  1.00 60.56           C  
ATOM   1949  CD1 LEU A 251     -21.236  72.861  25.283  1.00 56.98           C  
ATOM   1950  CD2 LEU A 251     -20.962  70.886  26.790  1.00 61.74           C  
ATOM   1951  N   SER A 252     -24.921  70.051  22.871  1.00 54.22           N  
ATOM   1952  CA  SER A 252     -25.819  69.069  22.267  1.00 54.50           C  
ATOM   1953  C   SER A 252     -25.812  69.203  20.753  1.00 54.67           C  
ATOM   1954  O   SER A 252     -25.577  68.233  20.033  1.00 54.48           O  
ATOM   1955  CB  SER A 252     -27.251  69.257  22.777  1.00 53.78           C  
ATOM   1956  OG  SER A 252     -27.360  68.909  24.146  1.00 59.33           O  
ATOM   1957  N   ALA A 253     -26.072  70.416  20.277  1.00 53.75           N  
ATOM   1958  CA  ALA A 253     -26.103  70.690  18.847  1.00 52.72           C  
ATOM   1959  C   ALA A 253     -24.834  70.207  18.155  1.00 53.29           C  
ATOM   1960  O   ALA A 253     -24.882  69.716  17.030  1.00 55.01           O  
ATOM   1961  CB  ALA A 253     -26.293  72.182  18.610  1.00 49.07           C  
ATOM   1962  N   PHE A 254     -23.699  70.340  18.831  1.00 57.28           N  
ATOM   1963  CA  PHE A 254     -22.430  69.912  18.260  1.00 59.98           C  
ATOM   1964  C   PHE A 254     -22.350  68.395  18.126  1.00 62.30           C  
ATOM   1965  O   PHE A 254     -21.961  67.883  17.077  1.00 66.45           O  
ATOM   1966  CB  PHE A 254     -21.266  70.431  19.112  1.00 59.90           C  
ATOM   1967  CG  PHE A 254     -19.910  70.029  18.600  1.00 58.33           C  
ATOM   1968  CD1 PHE A 254     -19.335  68.819  18.981  1.00 55.98           C  
ATOM   1969  CD2 PHE A 254     -19.211  70.854  17.725  1.00 57.44           C  
ATOM   1970  CE1 PHE A 254     -18.085  68.440  18.496  1.00 57.83           C  
ATOM   1971  CE2 PHE A 254     -17.961  70.484  17.235  1.00 54.37           C  
ATOM   1972  CZ  PHE A 254     -17.397  69.275  17.621  1.00 56.74           C  
ATOM   1973  N   LEU A 255     -22.715  67.677  19.185  1.00 62.56           N  
ATOM   1974  CA  LEU A 255     -22.681  66.217  19.164  1.00 62.83           C  
ATOM   1975  C   LEU A 255     -23.788  65.648  18.280  1.00 64.43           C  
ATOM   1976  O   LEU A 255     -23.606  64.621  17.624  1.00 65.91           O  
ATOM   1977  CB  LEU A 255     -22.818  65.656  20.581  1.00 60.67           C  
ATOM   1978  CG  LEU A 255     -21.646  65.891  21.536  1.00 60.08           C  
ATOM   1979  CD1 LEU A 255     -21.948  65.244  22.879  1.00 59.97           C  
ATOM   1980  CD2 LEU A 255     -20.369  65.310  20.941  1.00 59.46           C  
ATOM   1981  N   GLU A 256     -24.935  66.320  18.274  1.00 63.10           N  
ATOM   1982  CA  GLU A 256     -26.075  65.899  17.469  1.00 58.92           C  
ATOM   1983  C   GLU A 256     -25.999  66.516  16.075  1.00 60.60           C  
ATOM   1984  O   GLU A 256     -26.936  66.416  15.284  1.00 60.60           O  
ATOM   1985  CB  GLU A 256     -27.377  66.280  18.176  1.00 57.05           C  
ATOM   1986  CG  GLU A 256     -27.651  65.459  19.426  1.00 57.21           C  
ATOM   1987  CD  GLU A 256     -28.786  66.017  20.262  1.00 58.11           C  
ATOM   1988  OE1 GLU A 256     -29.861  66.306  19.694  1.00 55.62           O  
ATOM   1989  OE2 GLU A 256     -28.603  66.161  21.490  1.00 61.81           O  
ATOM   1990  N   LYS A 257     -24.866  67.154  15.793  1.00 59.95           N  
ATOM   1991  CA  LYS A 257     -24.603  67.797  14.509  1.00 59.84           C  
ATOM   1992  C   LYS A 257     -25.761  68.585  13.894  1.00 58.74           C  
ATOM   1993  O   LYS A 257     -26.190  68.310  12.775  1.00 62.04           O  
ATOM   1994  CB  LYS A 257     -24.091  66.777  13.490  1.00 60.39           C  
ATOM   1995  CG  LYS A 257     -22.963  65.893  14.002  1.00 61.23           C  
ATOM   1996  CD  LYS A 257     -22.456  64.968  12.906  1.00 62.46           C  
ATOM   1997  CE  LYS A 257     -21.608  63.839  13.469  1.00 64.04           C  
ATOM   1998  NZ  LYS A 257     -20.416  64.329  14.210  1.00 64.84           N  
ATOM   1999  N   ARG A 258     -26.257  69.572  14.631  1.00 59.29           N  
ATOM   2000  CA  ARG A 258     -27.354  70.416  14.170  1.00 57.55           C  
ATOM   2001  C   ARG A 258     -27.134  71.857  14.614  1.00 57.71           C  
ATOM   2002  O   ARG A 258     -26.432  72.108  15.593  1.00 61.20           O  
ATOM   2003  CB  ARG A 258     -28.655  69.872  14.767  1.00 55.61           C  
ATOM   2004  CG  ARG A 258     -28.598  69.618  16.264  1.00 55.51           C  
ATOM   2005  CD  ARG A 258     -29.524  70.544  17.027  1.00 56.02           C  
ATOM   2006  NE  ARG A 258     -29.503  70.262  18.460  1.00 55.31           N  
ATOM   2007  CZ  ARG A 258     -30.245  70.901  19.358  1.00 55.46           C  
ATOM   2008  NH1 ARG A 258     -31.072  71.867  18.974  1.00 51.86           N  
ATOM   2009  NH2 ARG A 258     -30.160  70.575  20.641  1.00 58.49           N  
ATOM   2010  N   GLN A 259     -27.724  72.803  13.894  1.00 55.56           N  
ATOM   2011  CA  GLN A 259     -27.557  74.207  14.236  1.00 52.43           C  
ATOM   2012  C   GLN A 259     -28.158  74.508  15.604  1.00 51.21           C  
ATOM   2013  O   GLN A 259     -29.342  74.270  15.840  1.00 47.93           O  
ATOM   2014  CB  GLN A 259     -28.215  75.102  13.188  1.00 53.48           C  
ATOM   2015  CG  GLN A 259     -27.783  76.558  13.288  1.00 62.63           C  
ATOM   2016  CD  GLN A 259     -28.688  77.497  12.519  1.00 65.03           C  
ATOM   2017  OE1 GLN A 259     -28.933  77.307  11.328  1.00 67.88           O  
ATOM   2018  NE2 GLN A 259     -29.190  78.523  13.199  1.00 66.03           N  
ATOM   2019  N   PRO A 260     -27.341  75.038  16.529  1.00 48.52           N  
ATOM   2020  CA  PRO A 260     -27.801  75.371  17.878  1.00 45.67           C  
ATOM   2021  C   PRO A 260     -28.705  76.591  17.868  1.00 45.03           C  
ATOM   2022  O   PRO A 260     -28.542  77.485  17.039  1.00 44.79           O  
ATOM   2023  CB  PRO A 260     -26.499  75.623  18.628  1.00 45.78           C  
ATOM   2024  CG  PRO A 260     -25.632  76.218  17.569  1.00 45.71           C  
ATOM   2025  CD  PRO A 260     -25.901  75.320  16.385  1.00 45.85           C  
ATOM   2026  N   ASN A 261     -29.664  76.618  18.789  1.00 46.64           N  
ATOM   2027  CA  ASN A 261     -30.596  77.733  18.894  1.00 49.12           C  
ATOM   2028  C   ASN A 261     -30.337  78.498  20.186  1.00 44.69           C  
ATOM   2029  O   ASN A 261     -30.863  78.166  21.251  1.00 40.49           O  
ATOM   2030  CB  ASN A 261     -32.036  77.220  18.852  1.00 58.78           C  
ATOM   2031  CG  ASN A 261     -32.340  76.448  17.579  1.00 69.19           C  
ATOM   2032  OD1 ASN A 261     -32.172  76.963  16.472  1.00 73.56           O  
ATOM   2033  ND2 ASN A 261     -32.787  75.207  17.733  1.00 75.13           N  
ATOM   2034  N   TRP A 262     -29.516  79.532  20.068  1.00 42.87           N  
ATOM   2035  CA  TRP A 262     -29.129  80.367  21.195  1.00 37.41           C  
ATOM   2036  C   TRP A 262     -30.280  81.159  21.792  1.00 36.68           C  
ATOM   2037  O   TRP A 262     -31.085  81.745  21.071  1.00 39.26           O  
ATOM   2038  CB  TRP A 262     -28.034  81.327  20.750  1.00 31.46           C  
ATOM   2039  CG  TRP A 262     -26.926  80.645  20.025  1.00 23.21           C  
ATOM   2040  CD1 TRP A 262     -26.515  80.886  18.746  1.00 22.42           C  
ATOM   2041  CD2 TRP A 262     -26.063  79.624  20.541  1.00 21.71           C  
ATOM   2042  NE1 TRP A 262     -25.446  80.080  18.434  1.00 27.19           N  
ATOM   2043  CE2 TRP A 262     -25.151  79.295  19.516  1.00 22.34           C  
ATOM   2044  CE3 TRP A 262     -25.976  78.953  21.768  1.00 23.26           C  
ATOM   2045  CZ2 TRP A 262     -24.155  78.327  19.684  1.00 23.67           C  
ATOM   2046  CZ3 TRP A 262     -24.988  77.990  21.934  1.00 21.08           C  
ATOM   2047  CH2 TRP A 262     -24.092  77.685  20.893  1.00 20.87           C  
ATOM   2048  N   LYS A 263     -30.344  81.177  23.118  1.00 40.09           N  
ATOM   2049  CA  LYS A 263     -31.387  81.907  23.823  1.00 44.87           C  
ATOM   2050  C   LYS A 263     -30.796  83.098  24.567  1.00 42.55           C  
ATOM   2051  O   LYS A 263     -31.525  83.959  25.055  1.00 46.60           O  
ATOM   2052  CB  LYS A 263     -32.116  80.974  24.795  1.00 53.76           C  
ATOM   2053  CG  LYS A 263     -33.047  79.985  24.102  1.00 67.27           C  
ATOM   2054  CD  LYS A 263     -33.519  78.883  25.038  1.00 80.42           C  
ATOM   2055  CE  LYS A 263     -32.377  77.941  25.403  1.00 87.65           C  
ATOM   2056  NZ  LYS A 263     -32.835  76.793  26.234  1.00 90.10           N  
ATOM   2057  N   GLY A 264     -29.470  83.143  24.645  1.00 40.09           N  
ATOM   2058  CA  GLY A 264     -28.805  84.246  25.317  1.00 39.32           C  
ATOM   2059  C   GLY A 264     -28.658  84.077  26.816  1.00 37.40           C  
ATOM   2060  O   GLY A 264     -28.116  84.951  27.490  1.00 33.13           O  
ATOM   2061  N   ILE A 265     -29.145  82.959  27.341  1.00 36.00           N  
ATOM   2062  CA  ILE A 265     -29.053  82.684  28.770  1.00 34.17           C  
ATOM   2063  C   ILE A 265     -28.554  81.262  28.997  1.00 32.47           C  
ATOM   2064  O   ILE A 265     -28.265  80.576  27.996  1.00 22.36           O  
ATOM   2065  CB  ILE A 265     -30.423  82.844  29.462  1.00 42.51           C  
ATOM   2066  CG1 ILE A 265     -31.400  81.784  28.947  1.00 47.32           C  
ATOM   2067  CG2 ILE A 265     -30.977  84.236  29.196  1.00 42.40           C  
ATOM   2068  CD1 ILE A 265     -32.746  81.801  29.646  1.00 52.79           C  
TER    2069      ILE A 265                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
