
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  255 ( 1971),  selected  255 , name 2pbp_A
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 2pbp_A.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    F     4_A      P      32          5.462
LGA    V     5_A      R      33          0.958
LGA    S     6_A      P      34          0.270
LGA    I     7_A      T      35          0.642
LGA    A     8_A      S      36          0.564
LGA    A     9_A      A      37          0.504
LGA    R    10_A      R      38          0.482
LGA    Q    11_A      Q      39          1.336
LGA    E    12_A      L      40          2.318
LGA    G    13_A      D      41          0.769
LGA    A    14_A      G      42          0.907
LGA    V    15_A      I      43          0.445
LGA    G    16_A      R      44          0.536
LGA    I    17_A      N      45          0.536
LGA    I    18_A      I      46          0.217
LGA    E    19_A      V      47          0.442
LGA    L    20_A      L      48          0.620
LGA    A    21_A      S      49          0.545
LGA    R    22_A      N      50          0.344
LGA    P    23_A      P      51          0.797
LGA    D    24_A      K      52          0.777
LGA    V    25_A      K      53          1.000
LGA    L    26_A      R      54          1.080
LGA    N    27_A      N      55          0.610
LGA    A    28_A      T      56          0.691
LGA    L    29_A      L      57          0.820
LGA    S    30_A      S      58          0.934
LGA    R    31_A      L      59          1.397
LGA    Q    32_A      A      60          1.198
LGA    M    33_A      M      61          0.507
LGA    V    34_A      L      62          0.851
LGA    A    35_A      K      63          1.138
LGA    E    36_A      S      64          0.881
LGA    I    37_A      L      65          0.520
LGA    V    38_A      Q      66          0.725
LGA    A    39_A      S      67          0.872
LGA    A    40_A      D      68          0.567
LGA    V    41_A      I      69          0.459
LGA    E    42_A      L      70          0.943
LGA    A    43_A      H      71          0.995
LGA    F    44_A      D      72          4.818
LGA    D    45_A      A      73          2.510
LGA    R    46_A      D      74          2.798
LGA    N    47_A      S      75          2.609
LGA    E    48_A      N      76          2.035
LGA    K    49_A      D      77          0.683
LGA    V    50_A      L      78          0.974
LGA    R    51_A      K      79          0.523
LGA    V    52_A      V      80          0.467
LGA    I    53_A      I      81          0.250
LGA    V    54_A      I      82          0.277
LGA    L    55_A      I      83          0.279
LGA    T    56_A      S      84          0.068
LGA    G    57_A      A      85          0.175
LGA    R    58_A      E      86          0.539
LGA    G    59_A      G      87          1.025
LGA    R    60_A      P      88          1.135
LGA    A    61_A      V      89          1.607
LGA    F    62_A      F      90          1.288
LGA    A    63_A      S      91          1.159
LGA    A    64_A      S      92          1.171
LGA    G    65_A      G      93          1.031
LGA    A    66_A      H      94          1.629
LGA    D    67_A      D      95          2.449
LGA    I    68_A      L      96          2.371
LGA    Q    69_A      K      97          1.996
LGA    E    70_A      E      98          2.141
LGA    M    71_A      L      99          1.998
LGA    A    72_A      T     100          2.040
LGA    K    73_A      E     101          4.124
LGA    D    74_A      E     102          5.911
LGA    D    75_A      Q     103           #
LGA    P    76_A      -       -           -
LGA    I    77_A      -       -           -
LGA    R    78_A      G     104          3.130
LGA    L    79_A      R     105          3.148
LGA    E    80_A      D     106          4.636
LGA    W    81_A      Y     107          6.016
LGA    L    82_A      H     108          5.089
LGA    N    83_A      A     109          3.364
LGA    Q    84_A      E     110          2.760
LGA    -       -      V     111           -
LGA    F    85_A      F     112          3.100
LGA    A    86_A      Q     113          3.109
LGA    D    87_A      T     114          2.478
LGA    W    88_A      C     115          3.137
LGA    D    89_A      S     116          3.566
LGA    R    90_A      K     117          2.954
LGA    -       -      V     118           -
LGA    L    91_A      M     119          3.174
LGA    S    92_A      M     120          1.720
LGA    I    93_A      H     121          3.541
LGA    V    94_A      I     122          3.646
LGA    -       -      R     123           -
LGA    -       -      N     124           -
LGA    -       -      H     125           -
LGA    K    95_A      P     126          2.704
LGA    T    96_A      V     127          1.308
LGA    P    97_A      P     128          0.381
LGA    M    98_A      V     129          0.303
LGA    I    99_A      I     130          0.120
LGA    A   100_A      A     131          0.356
LGA    A   101_A      M     132          0.205
LGA    V   102_A      V     133          0.382
LGA    N   103_A      N     134          1.273
LGA    G   104_A      G     135          1.178
LGA    L   105_A      L     136          0.963
LGA    A   106_A      A     137          0.765
LGA    L   107_A      T     138          0.473
LGA    G   108_A      A     139          0.745
LGA    G   109_A      A     140          0.845
LGA    G   110_A      G     141          0.616
LGA    F   111_A      C     142          0.405
LGA    E   112_A      Q     143          0.593
LGA    L   113_A      L     144          0.726
LGA    A   114_A      V     145          0.647
LGA    L   115_A      A     146          1.096
LGA    S   116_A      S     147          1.198
LGA    C   117_A      C     148          0.576
LGA    D   118_A      D     149          0.181
LGA    L   119_A      I     150          0.269
LGA    I   120_A      A     151          0.223
LGA    V   121_A      V     152          0.428
LGA    A   122_A      A     153          0.413
LGA    S   123_A      S     154          0.785
LGA    S   124_A      D     155          1.700
LGA    A   125_A      K     156          2.506
LGA    A   126_A      S     157          1.078
LGA    E   127_A      S     158          0.773
LGA    F   128_A      F     159          0.681
LGA    G   129_A      A     160          0.751
LGA    F   130_A      T     161          0.513
LGA    P   131_A      P     162          0.884
LGA    E   132_A      G     163          0.581
LGA    V   133_A      V     164          1.208
LGA    N   134_A      N     165          0.955
LGA    L   135_A      V     166          0.802
LGA    G   136_A      G     167          0.905
LGA    V   137_A      L     168          1.203
LGA    M   138_A      F     169          1.679
LGA    P   139_A      C     170          2.075
LGA    G   140_A      S     171          4.236
LGA    A   141_A      T     172          3.192
LGA    G   142_A      -       -           -
LGA    G   143_A      P     173          1.781
LGA    T   144_A      G     174          1.199
LGA    Q   145_A      V     175          1.915
LGA    R   146_A      A     176          2.150
LGA    L   147_A      L     177          1.508
LGA    T   148_A      A     178          1.605
LGA    K   149_A      R     179          2.528
LGA    L   150_A      A     180          2.610
LGA    I   151_A      V     181          2.155
LGA    G   152_A      P     182          2.564
LGA    P   153_A      R     183          1.914
LGA    K   154_A      K     184          2.071
LGA    R   155_A      V     185          2.110
LGA    A   156_A      A     186          1.233
LGA    L   157_A      L     187          0.763
LGA    E   158_A      E     188          0.714
LGA    W   159_A      M     189          0.749
LGA    L   160_A      L     190          0.664
LGA    W   161_A      F     191          0.504
LGA    T   162_A      T     192          0.535
LGA    G   163_A      G     193          0.665
LGA    A   164_A      E     194          0.544
LGA    R   165_A      P     195          0.376
LGA    M   166_A      I     196          0.914
LGA    S   167_A      S     197          0.379
LGA    A   168_A      A     198          0.445
LGA    K   169_A      Q     199          0.449
LGA    E   170_A      E     200          0.457
LGA    A   171_A      A     201          0.536
LGA    E   172_A      L     202          0.486
LGA    Q   173_A      L     203          0.629
LGA    L   174_A      H     204          0.713
LGA    G   175_A      G     205          1.665
LGA    I   176_A      L     206          1.476
LGA    V   177_A      L     207          0.649
LGA    N   178_A      S     208          0.824
LGA    R   179_A      K     209          0.804
LGA    V   180_A      V     210          0.804
LGA    V   181_A      V     211          1.146
LGA    S   182_A      P     212          1.290
LGA    P   183_A      E     213          1.343
LGA    E   184_A      A     214          2.529
LGA    L   185_A      E     215          2.201
LGA    L   186_A      L     216          1.182
LGA    M   187_A      Q     217          1.439
LGA    E   188_A      E     218          1.968
LGA    E   189_A      E     219          1.550
LGA    T   190_A      T     220          0.659
LGA    M   191_A      M     221          1.315
LGA    R   192_A      R     222          1.971
LGA    L   193_A      I     223          1.423
LGA    A   194_A      A     224          0.221
LGA    G   195_A      R     225          0.275
LGA    R   196_A      K     226          0.759
LGA    L   197_A      I     227          1.110
LGA    A   198_A      A     228          0.988
LGA    E   199_A      S     229          1.118
LGA    Q   200_A      L     230          1.652
LGA    P   201_A      S     231          1.916
LGA    P   202_A      R     232          1.432
LGA    L   203_A      P     233          1.874
LGA    A   204_A      V     234          2.026
LGA    L   205_A      V     235          1.551
LGA    R   206_A      S     236          1.347
LGA    L   207_A      L     237          1.799
LGA    I   208_A      G     238          1.698
LGA    K   209_A      K     239          1.450
LGA    E   210_A      A     240          1.654
LGA    A   211_A      T     241          2.348
LGA    V   212_A      F     242          2.223
LGA    Q   213_A      Y     243          1.273
LGA    K   214_A      K     244          2.579
LGA    A   215_A      Q     245          3.763
LGA    V   216_A      L     246          3.475
LGA    D   217_A      P     247          2.235
LGA    Y   218_A      Q     248          2.265
LGA    P   219_A      D     249          2.319
LGA    L   220_A      L     250          2.196
LGA    Y   221_A      G     251          2.238
LGA    E   222_A      T     252          2.252
LGA    G   223_A      A     253          2.442
LGA    M   224_A      Y     254          2.520
LGA    Q   225_A      Y     255          2.736
LGA    F   226_A      L     256          2.466
LGA    E   227_A      T     257          1.862
LGA    R   228_A      S     258          2.571
LGA    K   229_A      Q     259          3.068
LGA    N   230_A      A     260          2.152
LGA    F   231_A      M     261          1.918
LGA    Y   232_A      V     262          2.573
LGA    L   233_A      D     263          2.140
LGA    L   234_A      N     264          1.398
LGA    F   235_A      L     265          2.372
LGA    A   236_A      A     266          2.847
LGA    S   237_A      L     267          1.468
LGA    E   238_A      R     268          1.067
LGA    D   239_A      D     269          0.435
LGA    Q   240_A      G     270          0.791
LGA    K   241_A      Q     271          1.385
LGA    E   242_A      E     272          0.737
LGA    G   243_A      G     273          0.305
LGA    M   244_A      I     274          1.016
LGA    A   245_A      T     275          1.233
LGA    A   246_A      A     276          0.498
LGA    F   247_A      F     277          0.388
LGA    L   248_A      L     278          0.919
LGA    E   249_A      Q     279          1.044
LGA    K   250_A      K     280          0.670
LGA    R   251_A      R     281          1.152
LGA    K   252_A      K     282          1.579
LGA    P   253_A      P     283          1.341
LGA    R   254_A      V     284          1.844
LGA    F   255_A      W     285          1.797
LGA    Q   256_A      S     286          2.482
LGA    G   257_A      H     287          1.685
LGA    K   258_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  255  256    5.0    250    1.82    30.80     88.411    13.049

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.574101 * X  +   0.808934 * Y  +  -0.126628 * Z  + -70.943817
  Y_new =  -0.810638 * X  +   0.583312 * Y  +   0.051121 * Z  +  86.363693
  Z_new =   0.115218 * X  +   0.073301 * Y  +   0.990632 * Z  +  -2.068665 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.073860   -3.067733  [ DEG:     4.2318   -175.7682 ]
  Theta =  -0.115474   -3.026119  [ DEG:    -6.6162   -173.3838 ]
  Phi   =  -0.954582    2.187010  [ DEG:   -54.6935    125.3065 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pbp_A                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pbp_A.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  255  256   5.0  250   1.82   30.80  88.411
REMARK  ---------------------------------------------------------- 
MOLECULE 2pbp_A
HEADER    LYASE                                   29-MAR-07   2PBP              
TITLE     CRYSTAL STRUCTURE OF ENOYL-COA HYDRATES SUBUNIT I (GK_2039)           
TITLE    2 FROM GEOBACILLUS KAUSTOPHILUS HTA426                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ENOYL-COA HYDRATASE SUBUNIT I;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: PHENYLACETIC ACID CATABOLISM;                               
COMPND   5 EC: 4.2.1.17;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: GEOBACILLUS KAUSTOPHILUS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HTA426;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL-21 CONDON PLUS (DE3)-RIL;               
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    HYDRATASE, B-OXIDATION, STRUCTURAL GENOMICS, NPPSFA,                  
KEYWDS   2 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   3 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   4 RSGI, LYASE                                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.JEYAKANTHAN,S.P.KANAUJIA,R.C.VASUKI,K.SEKAR,Y.AGARI,                
AUTHOR   2 A.EBIHARA,S.KURAMITSU,A.SHINKAI,Y.SHIRO,S.YOKOYAMA,RIKEN             
AUTHOR   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   02-OCT-07 2PBP    0                                                
JRNL        AUTH   J.JEYAKANTHAN,S.P.KANAUJIA,R.C.VASUKI,K.SEKAR,               
JRNL        AUTH 2 Y.AGARI,A.EBIHARA,S.KURAMITSU,A.SHINKAI,Y.SHIRO,             
JRNL        AUTH 3 S.YOKOYAMA                                                   
JRNL        TITL   CRYSTAL STRUCTURE OF ENOYL-COA HYDRATES SUBUNIT I            
JRNL        TITL 2 (GK_2039) FROM GEOBACILLUS KAUSTOPHILUS HTA426               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2PBP A    1   258  UNP    Q5KYB2   Q5KYB2_GEOKA     1    258             
SEQRES   1 A  258  MET SER GLU PHE VAL SER ILE ALA ALA ARG GLN GLU GLY          
SEQRES   2 A  258  ALA VAL GLY ILE ILE GLU LEU ALA ARG PRO ASP VAL LEU          
SEQRES   3 A  258  ASN ALA LEU SER ARG GLN MET VAL ALA GLU ILE VAL ALA          
SEQRES   4 A  258  ALA VAL GLU ALA PHE ASP ARG ASN GLU LYS VAL ARG VAL          
SEQRES   5 A  258  ILE VAL LEU THR GLY ARG GLY ARG ALA PHE ALA ALA GLY          
SEQRES   6 A  258  ALA ASP ILE GLN GLU MET ALA LYS ASP ASP PRO ILE ARG          
SEQRES   7 A  258  LEU GLU TRP LEU ASN GLN PHE ALA ASP TRP ASP ARG LEU          
SEQRES   8 A  258  SER ILE VAL LYS THR PRO MET ILE ALA ALA VAL ASN GLY          
SEQRES   9 A  258  LEU ALA LEU GLY GLY GLY PHE GLU LEU ALA LEU SER CYS          
SEQRES  10 A  258  ASP LEU ILE VAL ALA SER SER ALA ALA GLU PHE GLY PHE          
SEQRES  11 A  258  PRO GLU VAL ASN LEU GLY VAL MET PRO GLY ALA GLY GLY          
SEQRES  12 A  258  THR GLN ARG LEU THR LYS LEU ILE GLY PRO LYS ARG ALA          
SEQRES  13 A  258  LEU GLU TRP LEU TRP THR GLY ALA ARG MET SER ALA LYS          
SEQRES  14 A  258  GLU ALA GLU GLN LEU GLY ILE VAL ASN ARG VAL VAL SER          
SEQRES  15 A  258  PRO GLU LEU LEU MET GLU GLU THR MET ARG LEU ALA GLY          
SEQRES  16 A  258  ARG LEU ALA GLU GLN PRO PRO LEU ALA LEU ARG LEU ILE          
SEQRES  17 A  258  LYS GLU ALA VAL GLN LYS ALA VAL ASP TYR PRO LEU TYR          
SEQRES  18 A  258  GLU GLY MET GLN PHE GLU ARG LYS ASN PHE TYR LEU LEU          
SEQRES  19 A  258  PHE ALA SER GLU ASP GLN LYS GLU GLY MET ALA ALA PHE          
SEQRES  20 A  258  LEU GLU LYS ARG LYS PRO ARG PHE GLN GLY LYS                  
FORMUL   2  HOH   *359(H2 O)                                                    
CRYST1   75.801   75.801  137.060  90.00  90.00 120.00 P 63 2 2     12          
ATOM      1  N   PHE A   4     -33.025 113.364  24.253  1.00 40.54           N  
ATOM      2  CA  PHE A   4     -31.645 113.676  23.783  1.00 40.39           C  
ATOM      3  C   PHE A   4     -31.670 114.733  22.685  1.00 38.14           C  
ATOM      4  O   PHE A   4     -32.528 114.706  21.802  1.00 38.23           O  
ATOM      5  CB  PHE A   4     -30.967 112.405  23.262  1.00 40.92           C  
ATOM      6  CG  PHE A   4     -30.694 111.383  24.328  1.00 42.30           C  
ATOM      7  CD1 PHE A   4     -29.745 111.624  25.318  1.00 42.33           C  
ATOM      8  CD2 PHE A   4     -31.392 110.180  24.348  1.00 42.51           C  
ATOM      9  CE1 PHE A   4     -29.494 110.678  26.312  1.00 38.51           C  
ATOM     10  CE2 PHE A   4     -31.150 109.230  25.338  1.00 40.59           C  
ATOM     11  CZ  PHE A   4     -30.199 109.480  26.322  1.00 40.67           C  
ATOM     12  N   VAL A   5     -30.723 115.660  22.744  1.00 32.63           N  
ATOM     13  CA  VAL A   5     -30.647 116.725  21.757  1.00 30.87           C  
ATOM     14  C   VAL A   5     -29.340 116.706  20.972  1.00 28.42           C  
ATOM     15  O   VAL A   5     -29.184 117.455  20.010  1.00 29.98           O  
ATOM     16  CB  VAL A   5     -30.800 118.110  22.425  1.00 33.04           C  
ATOM     17  CG1 VAL A   5     -32.185 118.244  23.030  1.00 31.95           C  
ATOM     18  CG2 VAL A   5     -29.736 118.291  23.500  1.00 33.28           C  
ATOM     19  N   SER A   6     -28.408 115.845  21.374  1.00 21.47           N  
ATOM     20  CA  SER A   6     -27.118 115.760  20.695  1.00 18.24           C  
ATOM     21  C   SER A   6     -26.851 114.400  20.057  1.00 15.53           C  
ATOM     22  O   SER A   6     -25.882 114.241  19.317  1.00 12.06           O  
ATOM     23  CB  SER A   6     -25.989 116.094  21.673  1.00 18.74           C  
ATOM     24  OG  SER A   6     -26.167 117.386  22.227  1.00 23.92           O  
ATOM     25  N   ILE A   7     -27.699 113.421  20.350  1.00 13.36           N  
ATOM     26  CA  ILE A   7     -27.534 112.086  19.785  1.00 13.37           C  
ATOM     27  C   ILE A   7     -28.872 111.518  19.340  1.00 13.76           C  
ATOM     28  O   ILE A   7     -29.926 112.040  19.699  1.00 11.92           O  
ATOM     29  CB  ILE A   7     -26.883 111.111  20.812  1.00 14.76           C  
ATOM     30  CG1 ILE A   7     -27.767 110.961  22.054  1.00 16.47           C  
ATOM     31  CG2 ILE A   7     -25.511 111.628  21.221  1.00 13.87           C  
ATOM     32  CD1 ILE A   7     -28.857 109.908  21.939  1.00 13.93           C  
ATOM     33  N   ALA A   8     -28.816 110.450  18.551  1.00 11.60           N  
ATOM     34  CA  ALA A   8     -30.012 109.778  18.062  1.00 12.42           C  
ATOM     35  C   ALA A   8     -29.798 108.278  18.221  1.00 13.90           C  
ATOM     36  O   ALA A   8     -28.836 107.724  17.686  1.00 13.88           O  
ATOM     37  CB  ALA A   8     -30.251 110.124  16.600  1.00 12.56           C  
ATOM     38  N   ALA A   9     -30.684 107.628  18.967  1.00 13.32           N  
ATOM     39  CA  ALA A   9     -30.574 106.192  19.194  1.00 12.96           C  
ATOM     40  C   ALA A   9     -31.687 105.425  18.495  1.00 14.95           C  
ATOM     41  O   ALA A   9     -32.810 105.915  18.360  1.00 16.00           O  
ATOM     42  CB  ALA A   9     -30.597 105.896  20.692  1.00 13.71           C  
ATOM     43  N   ARG A  10     -31.366 104.216  18.050  1.00 14.49           N  
ATOM     44  CA  ARG A  10     -32.329 103.363  17.368  1.00 14.31           C  
ATOM     45  C   ARG A  10     -31.900 101.912  17.502  1.00 14.08           C  
ATOM     46  O   ARG A  10     -30.765 101.625  17.882  1.00 10.69           O  
ATOM     47  CB  ARG A  10     -32.428 103.733  15.884  1.00 13.43           C  
ATOM     48  CG  ARG A  10     -31.159 103.491  15.076  1.00 15.28           C  
ATOM     49  CD  ARG A  10     -31.308 104.032  13.655  1.00 18.27           C  
ATOM     50  NE  ARG A  10     -30.087 103.887  12.867  1.00 22.67           N  
ATOM     51  CZ  ARG A  10     -29.699 102.760  12.275  1.00 25.73           C  
ATOM     52  NH1 ARG A  10     -30.438 101.661  12.373  1.00 27.31           N  
ATOM     53  NH2 ARG A  10     -28.565 102.733  11.588  1.00 28.82           N  
ATOM     54  N   GLN A  11     -32.807 100.998  17.186  1.00 13.34           N  
ATOM     55  CA  GLN A  11     -32.494  99.582  17.278  1.00 15.56           C  
ATOM     56  C   GLN A  11     -32.755  98.854  15.974  1.00 14.30           C  
ATOM     57  O   GLN A  11     -33.713  99.146  15.260  1.00 15.40           O  
ATOM     58  CB  GLN A  11     -33.301  98.936  18.403  1.00 16.29           C  
ATOM     59  CG  GLN A  11     -32.994  99.520  19.768  1.00 22.42           C  
ATOM     60  CD  GLN A  11     -33.878  98.960  20.858  1.00 22.86           C  
ATOM     61  OE1 GLN A  11     -33.817  97.771  21.175  1.00 19.82           O  
ATOM     62  NE2 GLN A  11     -34.713  99.817  21.438  1.00 22.68           N  
ATOM     63  N   GLU A  12     -31.876  97.912  15.667  1.00 12.88           N  
ATOM     64  CA  GLU A  12     -31.983  97.100  14.465  1.00 14.81           C  
ATOM     65  C   GLU A  12     -31.782  95.679  14.964  1.00 12.75           C  
ATOM     66  O   GLU A  12     -30.652  95.223  15.130  1.00 11.17           O  
ATOM     67  CB  GLU A  12     -30.884  97.479  13.468  1.00 19.97           C  
ATOM     68  CG  GLU A  12     -30.980  96.778  12.123  1.00 27.87           C  
ATOM     69  CD  GLU A  12     -32.287  97.065  11.407  1.00 32.64           C  
ATOM     70  OE1 GLU A  12     -32.679  98.251  11.336  1.00 36.04           O  
ATOM     71  OE2 GLU A  12     -32.916  96.106  10.908  1.00 36.12           O  
ATOM     72  N   GLY A  13     -32.887  94.985  15.225  1.00 10.56           N  
ATOM     73  CA  GLY A  13     -32.788  93.635  15.739  1.00 10.15           C  
ATOM     74  C   GLY A  13     -32.251  93.706  17.158  1.00  9.35           C  
ATOM     75  O   GLY A  13     -32.778  94.450  17.984  1.00 10.40           O  
ATOM     76  N   ALA A  14     -31.195  92.950  17.441  1.00  8.53           N  
ATOM     77  CA  ALA A  14     -30.594  92.936  18.773  1.00  8.92           C  
ATOM     78  C   ALA A  14     -29.413  93.901  18.857  1.00  8.74           C  
ATOM     79  O   ALA A  14     -28.607  93.832  19.786  1.00  9.13           O  
ATOM     80  CB  ALA A  14     -30.137  91.522  19.121  1.00 11.00           C  
ATOM     81  N   VAL A  15     -29.320  94.804  17.887  1.00  7.84           N  
ATOM     82  CA  VAL A  15     -28.234  95.780  17.845  1.00  7.58           C  
ATOM     83  C   VAL A  15     -28.740  97.188  18.158  1.00  9.59           C  
ATOM     84  O   VAL A  15     -29.664  97.684  17.513  1.00 11.10           O  
ATOM     85  CB  VAL A  15     -27.552  95.794  16.446  1.00  5.65           C  
ATOM     86  CG1 VAL A  15     -26.423  96.820  16.416  1.00  6.92           C  
ATOM     87  CG2 VAL A  15     -27.010  94.407  16.123  1.00  7.73           C  
ATOM     88  N   GLY A  16     -28.138  97.822  19.161  1.00  9.32           N  
ATOM     89  CA  GLY A  16     -28.531  99.172  19.520  1.00  8.79           C  
ATOM     90  C   GLY A  16     -27.541 100.121  18.872  1.00 11.45           C  
ATOM     91  O   GLY A  16     -26.330  99.934  18.991  1.00 10.51           O  
ATOM     92  N   ILE A  17     -28.054 101.132  18.176  1.00  8.12           N  
ATOM     93  CA  ILE A  17     -27.198 102.100  17.503  1.00  9.25           C  
ATOM     94  C   ILE A  17     -27.308 103.485  18.134  1.00  8.55           C  
ATOM     95  O   ILE A  17     -28.406 103.985  18.378  1.00  9.24           O  
ATOM     96  CB  ILE A  17     -27.560 102.229  15.991  1.00 10.87           C  
ATOM     97  CG1 ILE A  17     -27.530 100.853  15.318  1.00 14.96           C  
ATOM     98  CG2 ILE A  17     -26.594 103.179  15.300  1.00 12.41           C  
ATOM     99  CD1 ILE A  17     -26.201 100.066  15.359  1.00 13.93           C  
ATOM    100  N   ILE A  18     -26.161 104.094  18.404  1.00  7.59           N  
ATOM    101  CA  ILE A  18     -26.134 105.438  18.953  1.00  8.10           C  
ATOM    102  C   ILE A  18     -25.358 106.287  17.952  1.00 10.48           C  
ATOM    103  O   ILE A  18     -24.165 106.075  17.726  1.00 10.16           O  
ATOM    104  CB  ILE A  18     -25.440 105.486  20.328  1.00  8.01           C  
ATOM    105  CG1 ILE A  18     -26.264 104.690  21.349  1.00  8.59           C  
ATOM    106  CG2 ILE A  18     -25.281 106.930  20.772  1.00  9.07           C  
ATOM    107  CD1 ILE A  18     -25.536 104.366  22.651  1.00 13.93           C  
ATOM    108  N   GLU A  19     -26.052 107.233  17.333  1.00  9.21           N  
ATOM    109  CA  GLU A  19     -25.440 108.103  16.343  1.00  9.40           C  
ATOM    110  C   GLU A  19     -25.259 109.506  16.902  1.00  8.14           C  
ATOM    111  O   GLU A  19     -26.233 110.158  17.282  1.00  9.44           O  
ATOM    112  CB  GLU A  19     -26.319 108.145  15.083  1.00 12.87           C  
ATOM    113  CG  GLU A  19     -25.942 109.219  14.077  1.00 20.24           C  
ATOM    114  CD  GLU A  19     -26.890 109.259  12.887  1.00 25.53           C  
ATOM    115  OE1 GLU A  19     -28.083 108.931  13.066  1.00 30.25           O  
ATOM    116  OE2 GLU A  19     -26.447 109.631  11.779  1.00 25.79           O  
ATOM    117  N   LEU A  20     -24.012 109.963  16.978  1.00  6.53           N  
ATOM    118  CA  LEU A  20     -23.751 111.317  17.462  1.00  8.15           C  
ATOM    119  C   LEU A  20     -24.409 112.199  16.408  1.00  8.99           C  
ATOM    120  O   LEU A  20     -24.144 112.043  15.213  1.00  9.38           O  
ATOM    121  CB  LEU A  20     -22.245 111.585  17.537  1.00  6.99           C  
ATOM    122  CG  LEU A  20     -21.441 110.541  18.323  1.00 11.98           C  
ATOM    123  CD1 LEU A  20     -20.019 111.042  18.538  1.00 10.12           C  
ATOM    124  CD2 LEU A  20     -22.112 110.270  19.658  1.00 11.79           C  
ATOM    125  N   ALA A  21     -25.262 113.120  16.848  1.00 10.17           N  
ATOM    126  CA  ALA A  21     -26.004 113.966  15.921  1.00 12.46           C  
ATOM    127  C   ALA A  21     -25.740 115.471  15.940  1.00 12.38           C  
ATOM    128  O   ALA A  21     -26.683 116.266  15.935  1.00 13.24           O  
ATOM    129  CB  ALA A  21     -27.496 113.710  16.100  1.00 10.35           C  
ATOM    130  N   ARG A  22     -24.470 115.865  15.959  1.00  9.49           N  
ATOM    131  CA  ARG A  22     -24.121 117.281  15.928  1.00  9.13           C  
ATOM    132  C   ARG A  22     -23.046 117.510  14.870  1.00  8.65           C  
ATOM    133  O   ARG A  22     -21.979 118.053  15.156  1.00  9.23           O  
ATOM    134  CB  ARG A  22     -23.633 117.761  17.302  1.00 10.39           C  
ATOM    135  CG  ARG A  22     -24.743 117.931  18.337  1.00 11.68           C  
ATOM    136  CD  ARG A  22     -25.803 118.941  17.876  1.00 12.80           C  
ATOM    137  NE  ARG A  22     -25.237 120.258  17.585  1.00 10.12           N  
ATOM    138  CZ  ARG A  22     -24.851 121.141  18.504  1.00 11.68           C  
ATOM    139  NH1 ARG A  22     -24.971 120.865  19.795  1.00 13.58           N  
ATOM    140  NH2 ARG A  22     -24.330 122.301  18.128  1.00 11.56           N  
ATOM    141  N   PRO A  23     -23.324 117.100  13.620  1.00  7.74           N  
ATOM    142  CA  PRO A  23     -22.375 117.261  12.517  1.00  9.43           C  
ATOM    143  C   PRO A  23     -22.001 118.717  12.264  1.00  9.07           C  
ATOM    144  O   PRO A  23     -20.940 118.999  11.719  1.00 10.79           O  
ATOM    145  CB  PRO A  23     -23.109 116.628  11.336  1.00 10.28           C  
ATOM    146  CG  PRO A  23     -24.544 116.897  11.660  1.00 10.68           C  
ATOM    147  CD  PRO A  23     -24.608 116.568  13.126  1.00  7.80           C  
ATOM    148  N   ASP A  24     -22.879 119.631  12.669  1.00 11.79           N  
ATOM    149  CA  ASP A  24     -22.636 121.062  12.497  1.00 11.35           C  
ATOM    150  C   ASP A  24     -21.374 121.494  13.250  1.00 12.66           C  
ATOM    151  O   ASP A  24     -20.753 122.502  12.913  1.00 13.77           O  
ATOM    152  CB  ASP A  24     -23.842 121.861  12.988  1.00 10.80           C  
ATOM    153  CG  ASP A  24     -24.198 121.556  14.427  1.00 12.09           C  
ATOM    154  OD1 ASP A  24     -24.564 120.398  14.722  1.00 14.25           O  
ATOM    155  OD2 ASP A  24     -24.107 122.474  15.265  1.00 11.64           O  
ATOM    156  N   VAL A  25     -21.003 120.731  14.275  1.00 11.58           N  
ATOM    157  CA  VAL A  25     -19.792 121.018  15.040  1.00  9.22           C  
ATOM    158  C   VAL A  25     -18.908 119.771  15.079  1.00 11.54           C  
ATOM    159  O   VAL A  25     -18.128 119.563  16.009  1.00 11.03           O  
ATOM    160  CB  VAL A  25     -20.118 121.484  16.484  1.00 10.77           C  
ATOM    161  CG1 VAL A  25     -20.786 122.853  16.441  1.00 12.69           C  
ATOM    162  CG2 VAL A  25     -21.027 120.481  17.179  1.00 11.00           C  
ATOM    163  N   LEU A  26     -19.042 118.946  14.046  1.00 10.47           N  
ATOM    164  CA  LEU A  26     -18.266 117.718  13.920  1.00 12.01           C  
ATOM    165  C   LEU A  26     -18.396 116.806  15.139  1.00  9.74           C  
ATOM    166  O   LEU A  26     -17.427 116.168  15.556  1.00  8.41           O  
ATOM    167  CB  LEU A  26     -16.793 118.054  13.672  1.00 14.27           C  
ATOM    168  CG  LEU A  26     -16.511 118.934  12.451  1.00 15.27           C  
ATOM    169  CD1 LEU A  26     -15.013 119.137  12.308  1.00 17.87           C  
ATOM    170  CD2 LEU A  26     -17.091 118.288  11.200  1.00 14.32           C  
ATOM    171  N   ASN A  27     -19.602 116.751  15.698  1.00  7.29           N  
ATOM    172  CA  ASN A  27     -19.905 115.918  16.860  1.00  9.71           C  
ATOM    173  C   ASN A  27     -18.928 116.126  18.012  1.00 11.51           C  
ATOM    174  O   ASN A  27     -18.498 115.168  18.651  1.00 12.19           O  
ATOM    175  CB  ASN A  27     -19.918 114.441  16.452  1.00  8.65           C  
ATOM    176  CG  ASN A  27     -20.930 114.156  15.361  1.00  9.49           C  
ATOM    177  OD1 ASN A  27     -22.072 114.604  15.436  1.00  9.27           O  
ATOM    178  ND2 ASN A  27     -20.516 113.410  14.340  1.00  9.14           N  
ATOM    179  N   ALA A  28     -18.596 117.387  18.274  1.00  9.16           N  
ATOM    180  CA  ALA A  28     -17.665 117.732  19.343  1.00  9.66           C  
ATOM    181  C   ALA A  28     -18.088 117.117  20.671  1.00  7.21           C  
ATOM    182  O   ALA A  28     -19.229 117.276  21.109  1.00  6.29           O  
ATOM    183  CB  ALA A  28     -17.569 119.247  19.475  1.00  9.43           C  
ATOM    184  N   LEU A  29     -17.160 116.416  21.314  1.00  7.69           N  
ATOM    185  CA  LEU A  29     -17.451 115.776  22.588  1.00  6.67           C  
ATOM    186  C   LEU A  29     -17.358 116.725  23.779  1.00  7.95           C  
ATOM    187  O   LEU A  29     -16.427 116.652  24.580  1.00  9.84           O  
ATOM    188  CB  LEU A  29     -16.526 114.574  22.803  1.00  7.81           C  
ATOM    189  CG  LEU A  29     -16.760 113.437  21.807  1.00 10.03           C  
ATOM    190  CD1 LEU A  29     -15.856 112.261  22.131  1.00 12.53           C  
ATOM    191  CD2 LEU A  29     -18.220 113.020  21.865  1.00 12.11           C  
ATOM    192  N   SER A  30     -18.332 117.621  23.880  1.00 10.37           N  
ATOM    193  CA  SER A  30     -18.395 118.566  24.989  1.00  9.37           C  
ATOM    194  C   SER A  30     -18.881 117.753  26.181  1.00  9.17           C  
ATOM    195  O   SER A  30     -19.293 116.606  26.015  1.00  6.43           O  
ATOM    196  CB  SER A  30     -19.411 119.664  24.683  1.00  9.63           C  
ATOM    197  OG  SER A  30     -20.698 119.102  24.471  1.00 12.06           O  
ATOM    198  N   ARG A  31     -18.840 118.327  27.378  1.00  7.38           N  
ATOM    199  CA  ARG A  31     -19.307 117.592  28.543  1.00  8.96           C  
ATOM    200  C   ARG A  31     -20.770 117.184  28.364  1.00 10.00           C  
ATOM    201  O   ARG A  31     -21.175 116.101  28.787  1.00  9.22           O  
ATOM    202  CB  ARG A  31     -19.150 118.427  29.818  1.00  9.08           C  
ATOM    203  CG  ARG A  31     -17.706 118.707  30.221  1.00 11.48           C  
ATOM    204  CD  ARG A  31     -17.634 119.210  31.657  1.00 13.89           C  
ATOM    205  NE  ARG A  31     -18.472 120.389  31.868  1.00 19.79           N  
ATOM    206  CZ  ARG A  31     -18.156 121.614  31.465  1.00 20.26           C  
ATOM    207  NH1 ARG A  31     -17.013 121.832  30.829  1.00 23.12           N  
ATOM    208  NH2 ARG A  31     -18.987 122.622  31.692  1.00 22.96           N  
ATOM    209  N   GLN A  32     -21.560 118.044  27.725  1.00  9.09           N  
ATOM    210  CA  GLN A  32     -22.974 117.750  27.503  1.00 11.59           C  
ATOM    211  C   GLN A  32     -23.149 116.550  26.574  1.00  9.82           C  
ATOM    212  O   GLN A  32     -23.963 115.663  26.837  1.00  8.60           O  
ATOM    213  CB  GLN A  32     -23.685 118.972  26.913  1.00 14.93           C  
ATOM    214  CG  GLN A  32     -25.162 118.757  26.597  1.00 18.81           C  
ATOM    215  CD  GLN A  32     -25.952 118.262  27.793  1.00 26.12           C  
ATOM    216  OE1 GLN A  32     -25.700 118.665  28.930  1.00 29.21           O  
ATOM    217  NE2 GLN A  32     -26.926 117.391  27.539  1.00 30.04           N  
ATOM    218  N   MET A  33     -22.385 116.531  25.486  1.00  8.47           N  
ATOM    219  CA  MET A  33     -22.447 115.436  24.518  1.00 10.22           C  
ATOM    220  C   MET A  33     -22.061 114.115  25.183  1.00  9.35           C  
ATOM    221  O   MET A  33     -22.744 113.103  25.021  1.00  7.91           O  
ATOM    222  CB  MET A  33     -21.506 115.726  23.340  1.00  9.11           C  
ATOM    223  CG  MET A  33     -21.340 114.575  22.345  1.00 12.09           C  
ATOM    224  SD  MET A  33     -22.839 114.155  21.422  1.00 13.16           S  
ATOM    225  CE  MET A  33     -22.600 115.163  19.936  1.00 11.82           C  
ATOM    226  N   VAL A  34     -20.966 114.128  25.935  1.00  8.98           N  
ATOM    227  CA  VAL A  34     -20.511 112.923  26.621  1.00  7.63           C  
ATOM    228  C   VAL A  34     -21.579 112.403  27.580  1.00  8.09           C  
ATOM    229  O   VAL A  34     -21.835 111.199  27.634  1.00  8.64           O  
ATOM    230  CB  VAL A  34     -19.203 113.185  27.403  1.00  5.07           C  
ATOM    231  CG1 VAL A  34     -18.810 111.943  28.206  1.00  6.62           C  
ATOM    232  CG2 VAL A  34     -18.091 113.563  26.429  1.00  5.72           C  
ATOM    233  N   ALA A  35     -22.209 113.307  28.329  1.00  6.54           N  
ATOM    234  CA  ALA A  35     -23.245 112.908  29.273  1.00  8.56           C  
ATOM    235  C   ALA A  35     -24.389 112.200  28.552  1.00  8.87           C  
ATOM    236  O   ALA A  35     -24.908 111.199  29.039  1.00  9.03           O  
ATOM    237  CB  ALA A  35     -23.770 114.122  30.034  1.00  7.63           C  
ATOM    238  N   GLU A  36     -24.778 112.714  27.389  1.00  9.22           N  
ATOM    239  CA  GLU A  36     -25.858 112.094  26.626  1.00 11.14           C  
ATOM    240  C   GLU A  36     -25.440 110.716  26.123  1.00 10.31           C  
ATOM    241  O   GLU A  36     -26.233 109.772  26.137  1.00  7.25           O  
ATOM    242  CB  GLU A  36     -26.269 112.985  25.451  1.00 11.91           C  
ATOM    243  CG  GLU A  36     -27.031 114.234  25.883  1.00 15.61           C  
ATOM    244  CD  GLU A  36     -27.572 115.029  24.713  1.00 20.00           C  
ATOM    245  OE1 GLU A  36     -28.222 114.426  23.834  1.00 18.51           O  
ATOM    246  OE2 GLU A  36     -27.354 116.259  24.673  1.00 25.45           O  
ATOM    247  N   ILE A  37     -24.192 110.603  25.685  1.00 10.50           N  
ATOM    248  CA  ILE A  37     -23.676 109.331  25.198  1.00  8.96           C  
ATOM    249  C   ILE A  37     -23.703 108.311  26.333  1.00  9.88           C  
ATOM    250  O   ILE A  37     -24.138 107.179  26.147  1.00 10.40           O  
ATOM    251  CB  ILE A  37     -22.233 109.478  24.667  1.00  7.32           C  
ATOM    252  CG1 ILE A  37     -22.225 110.409  23.449  1.00 10.13           C  
ATOM    253  CG2 ILE A  37     -21.666 108.110  24.316  1.00  8.85           C  
ATOM    254  CD1 ILE A  37     -20.844 110.912  23.034  1.00 13.93           C  
ATOM    255  N   VAL A  38     -23.248 108.721  27.515  1.00 10.24           N  
ATOM    256  CA  VAL A  38     -23.230 107.833  28.678  1.00 12.82           C  
ATOM    257  C   VAL A  38     -24.637 107.348  29.022  1.00 11.10           C  
ATOM    258  O   VAL A  38     -24.854 106.161  29.282  1.00 10.14           O  
ATOM    259  CB  VAL A  38     -22.637 108.542  29.918  1.00 12.89           C  
ATOM    260  CG1 VAL A  38     -22.839 107.682  31.161  1.00 16.21           C  
ATOM    261  CG2 VAL A  38     -21.161 108.806  29.701  1.00 15.23           C  
ATOM    262  N   ALA A  39     -25.590 108.273  29.016  1.00  9.79           N  
ATOM    263  CA  ALA A  39     -26.969 107.938  29.332  1.00  8.94           C  
ATOM    264  C   ALA A  39     -27.531 106.941  28.320  1.00  7.70           C  
ATOM    265  O   ALA A  39     -28.161 105.955  28.696  1.00  9.84           O  
ATOM    266  CB  ALA A  39     -27.817 109.201  29.356  1.00 11.04           C  
ATOM    267  N   ALA A  40     -27.289 107.197  27.040  1.00  7.95           N  
ATOM    268  CA  ALA A  40     -27.785 106.318  25.984  1.00  8.89           C  
ATOM    269  C   ALA A  40     -27.132 104.940  26.046  1.00  8.63           C  
ATOM    270  O   ALA A  40     -27.808 103.916  25.908  1.00  8.61           O  
ATOM    271  CB  ALA A  40     -27.541 106.950  24.617  1.00 10.25           C  
ATOM    272  N   VAL A  41     -25.818 104.912  26.250  1.00  7.65           N  
ATOM    273  CA  VAL A  41     -25.105 103.642  26.324  1.00  8.70           C  
ATOM    274  C   VAL A  41     -25.529 102.819  27.540  1.00  8.88           C  
ATOM    275  O   VAL A  41     -25.729 101.611  27.435  1.00  8.84           O  
ATOM    276  CB  VAL A  41     -23.575 103.855  26.365  1.00  9.35           C  
ATOM    277  CG1 VAL A  41     -22.868 102.527  26.594  1.00 11.80           C  
ATOM    278  CG2 VAL A  41     -23.106 104.473  25.053  1.00  9.03           C  
ATOM    279  N   GLU A  42     -25.670 103.461  28.697  1.00  8.14           N  
ATOM    280  CA  GLU A  42     -26.076 102.726  29.885  1.00  9.90           C  
ATOM    281  C   GLU A  42     -27.492 102.177  29.720  1.00 10.50           C  
ATOM    282  O   GLU A  42     -27.804 101.102  30.224  1.00 13.41           O  
ATOM    283  CB  GLU A  42     -25.974 103.609  31.136  1.00  8.29           C  
ATOM    284  CG  GLU A  42     -24.537 104.021  31.466  1.00  8.76           C  
ATOM    285  CD  GLU A  42     -24.406 104.684  32.825  1.00 14.21           C  
ATOM    286  OE1 GLU A  42     -25.381 105.327  33.270  1.00 14.75           O  
ATOM    287  OE2 GLU A  42     -23.325 104.578  33.441  1.00 13.07           O  
ATOM    288  N   ALA A  43     -28.337 102.905  28.996  1.00 11.41           N  
ATOM    289  CA  ALA A  43     -29.708 102.462  28.763  1.00 12.91           C  
ATOM    290  C   ALA A  43     -29.702 101.169  27.944  1.00 12.50           C  
ATOM    291  O   ALA A  43     -30.376 100.198  28.292  1.00 11.39           O  
ATOM    292  CB  ALA A  43     -30.487 103.540  28.033  1.00 12.71           C  
ATOM    293  N   PHE A  44     -28.940 101.161  26.854  1.00 11.10           N  
ATOM    294  CA  PHE A  44     -28.845  99.973  26.012  1.00 10.90           C  
ATOM    295  C   PHE A  44     -28.145  98.839  26.766  1.00 10.93           C  
ATOM    296  O   PHE A  44     -28.462  97.668  26.570  1.00 11.11           O  
ATOM    297  CB  PHE A  44     -28.058 100.268  24.724  1.00 11.52           C  
ATOM    298  CG  PHE A  44     -28.874 100.910  23.624  1.00 11.57           C  
ATOM    299  CD1 PHE A  44     -30.238 100.656  23.499  1.00 12.71           C  
ATOM    300  CD2 PHE A  44     -28.256 101.718  22.672  1.00 12.85           C  
ATOM    301  CE1 PHE A  44     -30.972 101.194  22.439  1.00 12.76           C  
ATOM    302  CE2 PHE A  44     -28.978 102.261  21.608  1.00 12.55           C  
ATOM    303  CZ  PHE A  44     -30.340 101.997  21.491  1.00 10.63           C  
ATOM    304  N   ASP A  45     -27.188  99.191  27.620  1.00 10.51           N  
ATOM    305  CA  ASP A  45     -26.443  98.196  28.392  1.00 11.46           C  
ATOM    306  C   ASP A  45     -27.369  97.444  29.350  1.00 13.61           C  
ATOM    307  O   ASP A  45     -27.182  96.249  29.586  1.00 12.20           O  
ATOM    308  CB  ASP A  45     -25.300  98.878  29.163  1.00 11.59           C  
ATOM    309  CG  ASP A  45     -24.281  97.888  29.727  1.00 15.40           C  
ATOM    310  OD1 ASP A  45     -24.103  96.791  29.156  1.00 13.65           O  
ATOM    311  OD2 ASP A  45     -23.632  98.218  30.742  1.00 20.14           O  
ATOM    312  N   ARG A  46     -28.372  98.143  29.880  1.00 13.56           N  
ATOM    313  CA  ARG A  46     -29.332  97.544  30.812  1.00 17.17           C  
ATOM    314  C   ARG A  46     -30.433  96.751  30.098  1.00 16.04           C  
ATOM    315  O   ARG A  46     -31.109  95.927  30.715  1.00 15.11           O  
ATOM    316  CB  ARG A  46     -29.999  98.625  31.670  1.00 19.96           C  
ATOM    317  CG  ARG A  46     -29.058  99.478  32.509  1.00 26.93           C  
ATOM    318  CD  ARG A  46     -29.848 100.387  33.453  1.00 29.69           C  
ATOM    319  NE  ARG A  46     -30.668 101.378  32.754  1.00 32.62           N  
ATOM    320  CZ  ARG A  46     -30.259 102.604  32.431  1.00 32.70           C  
ATOM    321  NH1 ARG A  46     -29.034 103.004  32.742  1.00 31.55           N  
ATOM    322  NH2 ARG A  46     -31.079 103.432  31.799  1.00 33.66           N  
ATOM    323  N   ASN A  47     -30.614  97.013  28.805  1.00 15.20           N  
ATOM    324  CA  ASN A  47     -31.639  96.346  27.998  1.00 14.39           C  
ATOM    325  C   ASN A  47     -31.140  94.985  27.506  1.00 14.51           C  
ATOM    326  O   ASN A  47     -30.281  94.914  26.629  1.00 12.03           O  
ATOM    327  CB  ASN A  47     -31.995  97.224  26.790  1.00 15.21           C  
ATOM    328  CG  ASN A  47     -33.234  96.739  26.050  1.00 16.59           C  
ATOM    329  OD1 ASN A  47     -33.579  95.558  26.090  1.00 13.69           O  
ATOM    330  ND2 ASN A  47     -33.899  97.655  25.354  1.00 17.56           N  
ATOM    331  N   GLU A  48     -31.686  93.907  28.053  1.00 14.39           N  
ATOM    332  CA  GLU A  48     -31.252  92.577  27.646  1.00 15.92           C  
ATOM    333  C   GLU A  48     -31.596  92.232  26.202  1.00 13.96           C  
ATOM    334  O   GLU A  48     -31.112  91.236  25.665  1.00 16.08           O  
ATOM    335  CB  GLU A  48     -31.807  91.520  28.609  1.00 21.81           C  
ATOM    336  CG  GLU A  48     -31.026  91.464  29.921  1.00 26.47           C  
ATOM    337  CD  GLU A  48     -31.568  90.445  30.905  1.00 30.02           C  
ATOM    338  OE1 GLU A  48     -31.672  89.253  30.540  1.00 30.64           O  
ATOM    339  OE2 GLU A  48     -31.884  90.839  32.048  1.00 31.63           O  
ATOM    340  N   LYS A  49     -32.419  93.062  25.568  1.00 10.54           N  
ATOM    341  CA  LYS A  49     -32.792  92.841  24.173  1.00 12.14           C  
ATOM    342  C   LYS A  49     -31.661  93.285  23.260  1.00 10.62           C  
ATOM    343  O   LYS A  49     -31.609  92.915  22.086  1.00 11.05           O  
ATOM    344  CB  LYS A  49     -34.057  93.628  23.831  1.00 14.95           C  
ATOM    345  CG  LYS A  49     -35.326  93.006  24.373  1.00 20.39           C  
ATOM    346  CD  LYS A  49     -35.526  91.632  23.765  1.00 24.32           C  
ATOM    347  CE  LYS A  49     -35.594  91.683  22.237  1.00 28.32           C  
ATOM    348  NZ  LYS A  49     -35.479  90.332  21.607  1.00 29.36           N  
ATOM    349  N   VAL A  50     -30.765  94.093  23.811  1.00  7.71           N  
ATOM    350  CA  VAL A  50     -29.626  94.608  23.066  1.00  8.30           C  
ATOM    351  C   VAL A  50     -28.392  93.768  23.369  1.00  9.83           C  
ATOM    352  O   VAL A  50     -27.918  93.724  24.505  1.00 11.13           O  
ATOM    353  CB  VAL A  50     -29.351  96.078  23.437  1.00  7.33           C  
ATOM    354  CG1 VAL A  50     -28.134  96.590  22.685  1.00  7.71           C  
ATOM    355  CG2 VAL A  50     -30.570  96.920  23.114  1.00  7.45           C  
ATOM    356  N   ARG A  51     -27.875  93.102  22.346  1.00  7.65           N  
ATOM    357  CA  ARG A  51     -26.706  92.249  22.508  1.00  6.95           C  
ATOM    358  C   ARG A  51     -25.414  92.913  22.050  1.00  6.54           C  
ATOM    359  O   ARG A  51     -24.322  92.500  22.443  1.00  6.01           O  
ATOM    360  CB  ARG A  51     -26.916  90.942  21.746  1.00  8.32           C  
ATOM    361  CG  ARG A  51     -28.140  90.172  22.204  1.00 11.18           C  
ATOM    362  CD  ARG A  51     -28.210  88.802  21.548  1.00  8.18           C  
ATOM    363  NE  ARG A  51     -29.283  87.991  22.115  1.00 11.36           N  
ATOM    364  CZ  ARG A  51     -29.425  86.686  21.900  1.00 12.44           C  
ATOM    365  NH1 ARG A  51     -28.560  86.039  21.125  1.00  9.57           N  
ATOM    366  NH2 ARG A  51     -30.429  86.029  22.465  1.00 11.73           N  
ATOM    367  N   VAL A  52     -25.542  93.936  21.212  1.00  5.75           N  
ATOM    368  CA  VAL A  52     -24.384  94.672  20.706  1.00  6.22           C  
ATOM    369  C   VAL A  52     -24.760  96.143  20.566  1.00  5.45           C  
ATOM    370  O   VAL A  52     -25.874  96.476  20.158  1.00  8.10           O  
ATOM    371  CB  VAL A  52     -23.928  94.148  19.317  1.00  4.70           C  
ATOM    372  CG1 VAL A  52     -22.623  94.830  18.902  1.00  6.80           C  
ATOM    373  CG2 VAL A  52     -23.744  92.636  19.356  1.00  5.77           C  
ATOM    374  N   ILE A  53     -23.827  97.015  20.920  1.00  6.33           N  
ATOM    375  CA  ILE A  53     -24.036  98.452  20.825  1.00  5.83           C  
ATOM    376  C   ILE A  53     -23.037  98.995  19.813  1.00  7.78           C  
ATOM    377  O   ILE A  53     -21.847  98.685  19.879  1.00  8.14           O  
ATOM    378  CB  ILE A  53     -23.794  99.142  22.189  1.00  6.26           C  
ATOM    379  CG1 ILE A  53     -24.792  98.614  23.222  1.00  6.83           C  
ATOM    380  CG2 ILE A  53     -23.898 100.658  22.041  1.00  6.43           C  
ATOM    381  CD1 ILE A  53     -24.454  98.948  24.673  1.00 13.93           C  
ATOM    382  N   VAL A  54     -23.526  99.794  18.872  1.00  7.06           N  
ATOM    383  CA  VAL A  54     -22.669 100.393  17.856  1.00  5.82           C  
ATOM    384  C   VAL A  54     -22.707 101.912  17.983  1.00  5.91           C  
ATOM    385  O   VAL A  54     -23.782 102.505  18.063  1.00  6.39           O  
ATOM    386  CB  VAL A  54     -23.125 100.003  16.429  1.00  5.81           C  
ATOM    387  CG1 VAL A  54     -22.327 100.786  15.387  1.00  6.07           C  
ATOM    388  CG2 VAL A  54     -22.942  98.508  16.216  1.00  6.68           C  
ATOM    389  N   LEU A  55     -21.530 102.528  18.020  1.00  6.23           N  
ATOM    390  CA  LEU A  55     -21.424 103.978  18.113  1.00  6.53           C  
ATOM    391  C   LEU A  55     -20.899 104.485  16.779  1.00  7.18           C  
ATOM    392  O   LEU A  55     -19.971 103.909  16.210  1.00  6.35           O  
ATOM    393  CB  LEU A  55     -20.438 104.398  19.204  1.00  6.99           C  
ATOM    394  CG  LEU A  55     -20.632 103.929  20.644  1.00  9.00           C  
ATOM    395  CD1 LEU A  55     -19.580 104.600  21.519  1.00  8.79           C  
ATOM    396  CD2 LEU A  55     -22.029 104.274  21.128  1.00 10.11           C  
ATOM    397  N   THR A  56     -21.492 105.563  16.280  1.00  4.26           N  
ATOM    398  CA  THR A  56     -21.041 106.138  15.026  1.00  6.10           C  
ATOM    399  C   THR A  56     -21.429 107.612  14.985  1.00  6.55           C  
ATOM    400  O   THR A  56     -22.225 108.076  15.803  1.00  7.53           O  
ATOM    401  CB  THR A  56     -21.646 105.391  13.815  1.00  6.66           C  
ATOM    402  OG1 THR A  56     -20.886 105.698  12.640  1.00  8.54           O  
ATOM    403  CG2 THR A  56     -23.095 105.802  13.593  1.00  8.53           C  
ATOM    404  N   GLY A  57     -20.855 108.349  14.043  1.00  6.79           N  
ATOM    405  CA  GLY A  57     -21.159 109.763  13.943  1.00  9.24           C  
ATOM    406  C   GLY A  57     -21.874 110.151  12.668  1.00 10.46           C  
ATOM    407  O   GLY A  57     -21.706 109.521  11.625  1.00 12.43           O  
ATOM    408  N   ARG A  58     -22.689 111.195  12.756  1.00 11.85           N  
ATOM    409  CA  ARG A  58     -23.422 111.686  11.601  1.00 12.60           C  
ATOM    410  C   ARG A  58     -22.531 112.692  10.881  1.00 13.38           C  
ATOM    411  O   ARG A  58     -21.772 113.424  11.516  1.00 12.38           O  
ATOM    412  CB  ARG A  58     -24.721 112.355  12.054  1.00 15.93           C  
ATOM    413  CG  ARG A  58     -25.610 112.852  10.924  1.00 19.73           C  
ATOM    414  CD  ARG A  58     -26.896 113.455  11.477  1.00 22.90           C  
ATOM    415  NE  ARG A  58     -27.709 112.467  12.182  1.00 22.65           N  
ATOM    416  CZ  ARG A  58     -28.838 112.751  12.827  1.00 24.82           C  
ATOM    417  NH1 ARG A  58     -29.289 113.998  12.860  1.00 26.49           N  
ATOM    418  NH2 ARG A  58     -29.518 111.789  13.433  1.00 21.85           N  
ATOM    419  N   GLY A  59     -22.611 112.723   9.556  1.00 15.74           N  
ATOM    420  CA  GLY A  59     -21.795 113.662   8.807  1.00 16.53           C  
ATOM    421  C   GLY A  59     -20.441 113.099   8.424  1.00 17.69           C  
ATOM    422  O   GLY A  59     -20.274 111.885   8.326  1.00 18.22           O  
ATOM    423  N   ARG A  60     -19.460 113.976   8.226  1.00 17.88           N  
ATOM    424  CA  ARG A  60     -18.134 113.530   7.820  1.00 19.60           C  
ATOM    425  C   ARG A  60     -17.197 113.158   8.968  1.00 17.68           C  
ATOM    426  O   ARG A  60     -16.147 112.558   8.741  1.00 18.67           O  
ATOM    427  CB  ARG A  60     -17.462 114.588   6.935  1.00 24.40           C  
ATOM    428  CG  ARG A  60     -16.730 115.700   7.678  1.00 32.37           C  
ATOM    429  CD  ARG A  60     -15.819 116.454   6.712  1.00 39.07           C  
ATOM    430  NE  ARG A  60     -14.854 117.324   7.385  1.00 44.89           N  
ATOM    431  CZ  ARG A  60     -15.144 118.507   7.914  1.00 47.41           C  
ATOM    432  NH1 ARG A  60     -16.381 118.980   7.855  1.00 47.91           N  
ATOM    433  NH2 ARG A  60     -14.192 119.222   8.499  1.00 48.66           N  
ATOM    434  N   ALA A  61     -17.566 113.505  10.196  1.00 14.49           N  
ATOM    435  CA  ALA A  61     -16.716 113.182  11.336  1.00 11.71           C  
ATOM    436  C   ALA A  61     -17.365 112.195  12.293  1.00  9.52           C  
ATOM    437  O   ALA A  61     -18.591 112.136  12.409  1.00  8.60           O  
ATOM    438  CB  ALA A  61     -16.351 114.452  12.090  1.00 13.16           C  
ATOM    439  N   PHE A  62     -16.531 111.405  12.963  1.00  7.27           N  
ATOM    440  CA  PHE A  62     -17.011 110.459  13.960  1.00  7.34           C  
ATOM    441  C   PHE A  62     -17.249 111.351  15.171  1.00  7.36           C  
ATOM    442  O   PHE A  62     -18.375 111.477  15.653  1.00  7.52           O  
ATOM    443  CB  PHE A  62     -15.933 109.415  14.270  1.00  7.16           C  
ATOM    444  CG  PHE A  62     -16.266 108.504  15.428  1.00  7.62           C  
ATOM    445  CD1 PHE A  62     -17.292 107.568  15.331  1.00  6.62           C  
ATOM    446  CD2 PHE A  62     -15.526 108.565  16.608  1.00  7.92           C  
ATOM    447  CE1 PHE A  62     -17.575 106.702  16.392  1.00  9.34           C  
ATOM    448  CE2 PHE A  62     -15.799 107.706  17.674  1.00  8.07           C  
ATOM    449  CZ  PHE A  62     -16.828 106.770  17.565  1.00  8.09           C  
ATOM    450  N   ALA A  63     -16.180 111.991  15.637  1.00  7.73           N  
ATOM    451  CA  ALA A  63     -16.264 112.896  16.778  1.00  8.25           C  
ATOM    452  C   ALA A  63     -14.968 113.665  16.997  1.00 10.04           C  
ATOM    453  O   ALA A  63     -13.880 113.097  16.946  1.00  7.55           O  
ATOM    454  CB  ALA A  63     -16.618 112.117  18.042  1.00  8.44           C  
ATOM    455  N   ALA A  64     -15.095 114.968  17.225  1.00 12.93           N  
ATOM    456  CA  ALA A  64     -13.940 115.811  17.498  1.00 14.48           C  
ATOM    457  C   ALA A  64     -13.940 116.021  19.009  1.00 15.32           C  
ATOM    458  O   ALA A  64     -14.856 115.576  19.698  1.00 16.14           O  
ATOM    459  CB  ALA A  64     -14.070 117.150  16.774  1.00 14.54           C  
ATOM    460  N   GLY A  65     -12.919 116.690  19.528  1.00 14.08           N  
ATOM    461  CA  GLY A  65     -12.867 116.919  20.960  1.00 14.45           C  
ATOM    462  C   GLY A  65     -13.683 118.128  21.366  1.00 15.00           C  
ATOM    463  O   GLY A  65     -14.252 118.814  20.514  1.00 14.53           O  
ATOM    464  N   ALA A  66     -13.751 118.386  22.668  1.00 14.84           N  
ATOM    465  CA  ALA A  66     -14.490 119.534  23.177  1.00 14.84           C  
ATOM    466  C   ALA A  66     -13.921 120.790  22.531  1.00 16.69           C  
ATOM    467  O   ALA A  66     -12.712 120.887  22.316  1.00 16.34           O  
ATOM    468  CB  ALA A  66     -14.359 119.613  24.695  1.00 16.52           C  
ATOM    469  N   ASP A  67     -14.791 121.746  22.220  1.00 18.04           N  
ATOM    470  CA  ASP A  67     -14.367 122.989  21.584  1.00 19.99           C  
ATOM    471  C   ASP A  67     -13.518 123.847  22.514  1.00 18.40           C  
ATOM    472  O   ASP A  67     -13.603 123.728  23.738  1.00 17.27           O  
ATOM    473  CB  ASP A  67     -15.584 123.792  21.127  1.00 23.60           C  
ATOM    474  CG  ASP A  67     -16.538 124.083  22.263  1.00 27.08           C  
ATOM    475  OD1 ASP A  67     -17.296 123.171  22.661  1.00 30.98           O  
ATOM    476  OD2 ASP A  67     -16.517 125.222  22.769  1.00 29.72           O  
ATOM    477  N   ILE A  68     -12.709 124.722  21.923  1.00 16.31           N  
ATOM    478  CA  ILE A  68     -11.835 125.598  22.695  1.00 17.85           C  
ATOM    479  C   ILE A  68     -12.599 126.542  23.614  1.00 16.57           C  
ATOM    480  O   ILE A  68     -12.155 126.818  24.729  1.00 16.33           O  
ATOM    481  CB  ILE A  68     -10.907 126.434  21.771  1.00 19.79           C  
ATOM    482  CG1 ILE A  68      -9.742 125.568  21.284  1.00 24.23           C  
ATOM    483  CG2 ILE A  68     -10.373 127.654  22.520  1.00 18.11           C  
ATOM    484  CD1 ILE A  68      -8.778 125.017  22.365  1.00 13.93           C  
ATOM    485  N   GLN A  69     -13.744 127.043  23.157  1.00 15.84           N  
ATOM    486  CA  GLN A  69     -14.510 127.955  23.988  1.00 16.12           C  
ATOM    487  C   GLN A  69     -14.872 127.310  25.324  1.00 14.17           C  
ATOM    488  O   GLN A  69     -14.809 127.960  26.366  1.00 15.58           O  
ATOM    489  CB  GLN A  69     -15.780 128.417  23.269  1.00 20.62           C  
ATOM    490  CG  GLN A  69     -16.528 129.495  24.047  1.00 25.89           C  
ATOM    491  CD  GLN A  69     -17.594 130.187  23.225  1.00 28.87           C  
ATOM    492  OE1 GLN A  69     -17.313 130.739  22.162  1.00 33.07           O  
ATOM    493  NE2 GLN A  69     -18.827 130.168  23.718  1.00 29.32           N  
ATOM    494  N   GLU A  70     -15.240 126.032  25.299  1.00 12.11           N  
ATOM    495  CA  GLU A  70     -15.593 125.343  26.537  1.00 11.60           C  
ATOM    496  C   GLU A  70     -14.351 125.084  27.389  1.00  9.05           C  
ATOM    497  O   GLU A  70     -14.369 125.282  28.606  1.00 10.41           O  
ATOM    498  CB  GLU A  70     -16.309 124.024  26.231  1.00 12.80           C  
ATOM    499  CG  GLU A  70     -16.592 123.171  27.465  1.00 13.25           C  
ATOM    500  CD  GLU A  70     -17.641 122.101  27.212  1.00 13.66           C  
ATOM    501  OE1 GLU A  70     -18.808 122.464  26.960  1.00 13.55           O  
ATOM    502  OE2 GLU A  70     -17.299 120.901  27.266  1.00  9.78           O  
ATOM    503  N   MET A  71     -13.270 124.654  26.748  1.00  9.39           N  
ATOM    504  CA  MET A  71     -12.032 124.374  27.467  1.00  9.46           C  
ATOM    505  C   MET A  71     -11.383 125.629  28.039  1.00  9.55           C  
ATOM    506  O   MET A  71     -10.780 125.585  29.111  1.00 10.62           O  
ATOM    507  CB  MET A  71     -11.021 123.670  26.557  1.00 11.38           C  
ATOM    508  CG  MET A  71     -11.448 122.294  26.076  1.00 12.99           C  
ATOM    509  SD  MET A  71     -10.054 121.377  25.376  1.00 17.78           S  
ATOM    510  CE  MET A  71      -9.941 122.086  23.742  1.00 19.07           C  
ATOM    511  N   ALA A  72     -11.502 126.745  27.325  1.00  9.18           N  
ATOM    512  CA  ALA A  72     -10.899 127.998  27.767  1.00 10.63           C  
ATOM    513  C   ALA A  72     -11.500 128.521  29.066  1.00 10.27           C  
ATOM    514  O   ALA A  72     -10.892 129.340  29.747  1.00 11.32           O  
ATOM    515  CB  ALA A  72     -11.024 129.055  26.670  1.00 12.08           C  
ATOM    516  N   LYS A  73     -12.695 128.049  29.407  1.00 10.19           N  
ATOM    517  CA  LYS A  73     -13.355 128.479  30.636  1.00 13.12           C  
ATOM    518  C   LYS A  73     -12.779 127.789  31.869  1.00 12.76           C  
ATOM    519  O   LYS A  73     -12.966 128.249  32.995  1.00 12.77           O  
ATOM    520  CB  LYS A  73     -14.850 128.163  30.576  1.00 14.33           C  
ATOM    521  CG  LYS A  73     -15.638 128.906  29.519  1.00 16.56           C  
ATOM    522  CD  LYS A  73     -17.104 128.490  29.575  1.00 21.49           C  
ATOM    523  CE  LYS A  73     -17.698 128.738  30.959  1.00 22.62           C  
ATOM    524  NZ  LYS A  73     -19.091 128.222  31.082  1.00 26.14           N  
ATOM    525  N   ASP A  74     -12.079 126.682  31.653  1.00 12.42           N  
ATOM    526  CA  ASP A  74     -11.534 125.911  32.761  1.00 10.90           C  
ATOM    527  C   ASP A  74     -10.222 126.361  33.395  1.00 10.89           C  
ATOM    528  O   ASP A  74      -9.433 127.099  32.805  1.00  9.90           O  
ATOM    529  CB  ASP A  74     -11.401 124.445  32.339  1.00 11.34           C  
ATOM    530  CG  ASP A  74     -12.720 123.849  31.879  1.00 12.71           C  
ATOM    531  OD1 ASP A  74     -13.766 124.188  32.475  1.00 13.55           O  
ATOM    532  OD2 ASP A  74     -12.711 123.028  30.933  1.00 11.10           O  
ATOM    533  N   ASP A  75     -10.025 125.896  34.627  1.00 11.10           N  
ATOM    534  CA  ASP A  75      -8.830 126.138  35.427  1.00 10.73           C  
ATOM    535  C   ASP A  75      -8.735 124.897  36.325  1.00  9.87           C  
ATOM    536  O   ASP A  75      -9.686 124.120  36.409  1.00  8.55           O  
ATOM    537  CB  ASP A  75      -8.952 127.440  36.241  1.00 12.43           C  
ATOM    538  CG  ASP A  75     -10.153 127.453  37.169  1.00 14.12           C  
ATOM    539  OD1 ASP A  75     -10.127 126.736  38.187  1.00 10.15           O  
ATOM    540  OD2 ASP A  75     -11.122 128.189  36.879  1.00 15.33           O  
ATOM    541  N   PRO A  76      -7.592 124.687  36.996  1.00  8.25           N  
ATOM    542  CA  PRO A  76      -7.420 123.514  37.862  1.00  8.90           C  
ATOM    543  C   PRO A  76      -8.536 123.202  38.864  1.00  8.41           C  
ATOM    544  O   PRO A  76      -8.990 122.063  38.954  1.00  5.58           O  
ATOM    545  CB  PRO A  76      -6.088 123.793  38.557  1.00  7.92           C  
ATOM    546  CG  PRO A  76      -5.335 124.572  37.516  1.00  5.95           C  
ATOM    547  CD  PRO A  76      -6.387 125.530  37.011  1.00  7.19           C  
ATOM    548  N   ILE A  77      -8.972 124.205  39.617  1.00  7.41           N  
ATOM    549  CA  ILE A  77     -10.012 123.997  40.623  1.00  9.17           C  
ATOM    550  C   ILE A  77     -11.389 123.741  40.016  1.00  7.75           C  
ATOM    551  O   ILE A  77     -12.122 122.863  40.477  1.00  7.01           O  
ATOM    552  CB  ILE A  77     -10.079 125.190  41.602  1.00  9.75           C  
ATOM    553  CG1 ILE A  77      -8.698 125.421  42.226  1.00 10.45           C  
ATOM    554  CG2 ILE A  77     -11.105 124.915  42.692  1.00 10.01           C  
ATOM    555  CD1 ILE A  77      -8.076 124.260  43.054  1.00 13.93           C  
ATOM    556  N   ARG A  78     -11.738 124.506  38.986  1.00  8.62           N  
ATOM    557  CA  ARG A  78     -13.016 124.328  38.307  1.00  7.65           C  
ATOM    558  C   ARG A  78     -13.094 122.894  37.771  1.00  7.22           C  
ATOM    559  O   ARG A  78     -14.126 122.230  37.891  1.00  6.36           O  
ATOM    560  CB  ARG A  78     -13.145 125.331  37.151  1.00  9.18           C  
ATOM    561  CG  ARG A  78     -14.355 125.106  36.243  1.00 10.20           C  
ATOM    562  CD  ARG A  78     -14.432 126.188  35.163  1.00 10.98           C  
ATOM    563  NE  ARG A  78     -15.289 125.818  34.034  1.00 13.76           N  
ATOM    564  CZ  ARG A  78     -16.618 125.864  34.032  1.00 15.74           C  
ATOM    565  NH1 ARG A  78     -17.284 126.272  35.107  1.00 17.94           N  
ATOM    566  NH2 ARG A  78     -17.286 125.504  32.944  1.00 14.73           N  
ATOM    567  N   LEU A  79     -11.996 122.416  37.191  1.00  6.43           N  
ATOM    568  CA  LEU A  79     -11.957 121.059  36.648  1.00  6.40           C  
ATOM    569  C   LEU A  79     -12.053 120.012  37.753  1.00  6.73           C  
ATOM    570  O   LEU A  79     -12.731 118.994  37.598  1.00  5.51           O  
ATOM    571  CB  LEU A  79     -10.677 120.848  35.835  1.00  6.84           C  
ATOM    572  CG  LEU A  79     -10.651 121.590  34.494  1.00  7.09           C  
ATOM    573  CD1 LEU A  79      -9.244 121.576  33.907  1.00  8.71           C  
ATOM    574  CD2 LEU A  79     -11.656 120.938  33.542  1.00  7.15           C  
ATOM    575  N   GLU A  80     -11.378 120.262  38.870  1.00  6.40           N  
ATOM    576  CA  GLU A  80     -11.414 119.329  39.990  1.00  7.35           C  
ATOM    577  C   GLU A  80     -12.858 119.119  40.452  1.00  5.93           C  
ATOM    578  O   GLU A  80     -13.292 117.987  40.658  1.00  5.08           O  
ATOM    579  CB  GLU A  80     -10.563 119.858  41.146  1.00  7.58           C  
ATOM    580  CG  GLU A  80     -10.599 118.998  42.407  1.00  9.41           C  
ATOM    581  CD  GLU A  80     -10.080 117.583  42.191  1.00  8.74           C  
ATOM    582  OE1 GLU A  80      -8.953 117.419  41.674  1.00  9.64           O  
ATOM    583  OE2 GLU A  80     -10.801 116.630  42.552  1.00  8.80           O  
ATOM    584  N   TRP A  81     -13.607 120.205  40.599  1.00  6.14           N  
ATOM    585  CA  TRP A  81     -14.999 120.094  41.032  1.00  7.65           C  
ATOM    586  C   TRP A  81     -15.899 119.502  39.943  1.00  7.90           C  
ATOM    587  O   TRP A  81     -16.860 118.794  40.244  1.00  7.34           O  
ATOM    588  CB  TRP A  81     -15.536 121.462  41.468  1.00  7.42           C  
ATOM    589  CG  TRP A  81     -14.984 121.965  42.783  1.00  7.46           C  
ATOM    590  CD1 TRP A  81     -14.345 123.152  43.000  1.00  8.37           C  
ATOM    591  CD2 TRP A  81     -15.078 121.319  44.063  1.00  7.39           C  
ATOM    592  NE1 TRP A  81     -14.038 123.290  44.335  1.00  9.94           N  
ATOM    593  CE2 TRP A  81     -14.476 122.182  45.010  1.00  7.21           C  
ATOM    594  CE3 TRP A  81     -15.613 120.102  44.504  1.00  7.54           C  
ATOM    595  CZ2 TRP A  81     -14.395 121.863  46.372  1.00  8.73           C  
ATOM    596  CZ3 TRP A  81     -15.532 119.784  45.862  1.00  8.08           C  
ATOM    597  CH2 TRP A  81     -14.926 120.665  46.778  1.00  8.71           C  
ATOM    598  N   LEU A  82     -15.598 119.798  38.681  1.00  7.22           N  
ATOM    599  CA  LEU A  82     -16.386 119.267  37.570  1.00  7.34           C  
ATOM    600  C   LEU A  82     -16.301 117.745  37.503  1.00  7.08           C  
ATOM    601  O   LEU A  82     -17.303 117.076  37.251  1.00  6.37           O  
ATOM    602  CB  LEU A  82     -15.914 119.855  36.235  1.00  7.92           C  
ATOM    603  CG  LEU A  82     -16.439 121.243  35.856  1.00  8.91           C  
ATOM    604  CD1 LEU A  82     -15.784 121.706  34.561  1.00  9.21           C  
ATOM    605  CD2 LEU A  82     -17.950 121.194  35.703  1.00 10.99           C  
ATOM    606  N   ASN A  83     -15.103 117.208  37.721  1.00  5.63           N  
ATOM    607  CA  ASN A  83     -14.881 115.763  37.683  1.00  7.40           C  
ATOM    608  C   ASN A  83     -15.555 115.168  36.445  1.00  7.25           C  
ATOM    609  O   ASN A  83     -16.233 114.140  36.514  1.00  6.10           O  
ATOM    610  CB  ASN A  83     -15.431 115.123  38.962  1.00  7.57           C  
ATOM    611  CG  ASN A  83     -15.062 113.657  39.088  1.00 10.41           C  
ATOM    612  OD1 ASN A  83     -14.126 113.184  38.446  1.00  7.91           O  
ATOM    613  ND2 ASN A  83     -15.790 112.933  39.931  1.00  8.00           N  
ATOM    614  N   GLN A  84     -15.340 115.820  35.307  1.00  6.75           N  
ATOM    615  CA  GLN A  84     -15.944 115.409  34.044  1.00  7.21           C  
ATOM    616  C   GLN A  84     -15.535 114.031  33.540  1.00  6.76           C  
ATOM    617  O   GLN A  84     -16.268 113.403  32.777  1.00  8.83           O  
ATOM    618  CB  GLN A  84     -15.631 116.442  32.959  1.00  5.01           C  
ATOM    619  CG  GLN A  84     -14.203 116.379  32.428  1.00  7.45           C  
ATOM    620  CD  GLN A  84     -13.821 117.631  31.658  1.00 10.24           C  
ATOM    621  OE1 GLN A  84     -13.714 118.710  32.236  1.00 10.08           O  
ATOM    622  NE2 GLN A  84     -13.620 117.492  30.351  1.00  6.89           N  
ATOM    623  N   PHE A  85     -14.374 113.549  33.956  1.00  6.21           N  
ATOM    624  CA  PHE A  85     -13.926 112.255  33.470  1.00  6.60           C  
ATOM    625  C   PHE A  85     -14.573 111.065  34.159  1.00  7.74           C  
ATOM    626  O   PHE A  85     -14.336 109.919  33.783  1.00  5.43           O  
ATOM    627  CB  PHE A  85     -12.401 112.197  33.518  1.00  6.20           C  
ATOM    628  CG  PHE A  85     -11.755 113.250  32.668  1.00  5.74           C  
ATOM    629  CD1 PHE A  85     -11.943 113.252  31.285  1.00  5.99           C  
ATOM    630  CD2 PHE A  85     -11.033 114.286  33.249  1.00  7.01           C  
ATOM    631  CE1 PHE A  85     -11.423 114.277  30.494  1.00  9.96           C  
ATOM    632  CE2 PHE A  85     -10.510 115.316  32.470  1.00  7.39           C  
ATOM    633  CZ  PHE A  85     -10.705 115.313  31.089  1.00  8.01           C  
ATOM    634  N   ALA A  86     -15.408 111.337  35.160  1.00  7.77           N  
ATOM    635  CA  ALA A  86     -16.119 110.259  35.840  1.00  8.01           C  
ATOM    636  C   ALA A  86     -17.095 109.671  34.823  1.00  7.25           C  
ATOM    637  O   ALA A  86     -17.409 108.482  34.867  1.00  5.92           O  
ATOM    638  CB  ALA A  86     -16.874 110.793  37.046  1.00  6.55           C  
ATOM    639  N   ASP A  87     -17.573 110.510  33.906  1.00  8.28           N  
ATOM    640  CA  ASP A  87     -18.493 110.044  32.870  1.00  8.32           C  
ATOM    641  C   ASP A  87     -17.759 109.088  31.938  1.00  7.59           C  
ATOM    642  O   ASP A  87     -18.338 108.124  31.441  1.00  7.05           O  
ATOM    643  CB  ASP A  87     -19.056 111.217  32.059  1.00  9.99           C  
ATOM    644  CG  ASP A  87     -20.338 111.774  32.649  1.00 15.95           C  
ATOM    645  OD1 ASP A  87     -20.824 111.217  33.657  1.00 17.22           O  
ATOM    646  OD2 ASP A  87     -20.864 112.766  32.098  1.00 16.22           O  
ATOM    647  N   TRP A  88     -16.480 109.355  31.697  1.00  7.10           N  
ATOM    648  CA  TRP A  88     -15.707 108.479  30.833  1.00  6.62           C  
ATOM    649  C   TRP A  88     -15.469 107.145  31.529  1.00  7.87           C  
ATOM    650  O   TRP A  88     -15.404 106.099  30.881  1.00  9.24           O  
ATOM    651  CB  TRP A  88     -14.375 109.128  30.448  1.00  6.49           C  
ATOM    652  CG  TRP A  88     -14.528 110.207  29.418  1.00  5.66           C  
ATOM    653  CD1 TRP A  88     -14.779 111.535  29.641  1.00  4.57           C  
ATOM    654  CD2 TRP A  88     -14.464 110.044  27.995  1.00  5.25           C  
ATOM    655  NE1 TRP A  88     -14.874 112.205  28.443  1.00  6.93           N  
ATOM    656  CE2 TRP A  88     -14.685 111.317  27.419  1.00  6.09           C  
ATOM    657  CE3 TRP A  88     -14.243 108.945  27.152  1.00  5.30           C  
ATOM    658  CZ2 TRP A  88     -14.689 111.521  26.032  1.00  6.72           C  
ATOM    659  CZ3 TRP A  88     -14.247 109.148  25.771  1.00  5.56           C  
ATOM    660  CH2 TRP A  88     -14.469 110.429  25.227  1.00  6.18           C  
ATOM    661  N   ASP A  89     -15.351 107.173  32.852  1.00  5.41           N  
ATOM    662  CA  ASP A  89     -15.147 105.938  33.597  1.00  6.57           C  
ATOM    663  C   ASP A  89     -16.394 105.066  33.481  1.00  5.39           C  
ATOM    664  O   ASP A  89     -16.303 103.843  33.461  1.00  6.38           O  
ATOM    665  CB  ASP A  89     -14.862 106.222  35.076  1.00  6.56           C  
ATOM    666  CG  ASP A  89     -13.548 106.955  35.293  1.00  9.73           C  
ATOM    667  OD1 ASP A  89     -12.604 106.743  34.501  1.00  8.58           O  
ATOM    668  OD2 ASP A  89     -13.457 107.730  36.268  1.00  9.77           O  
ATOM    669  N   ARG A  90     -17.560 105.702  33.412  1.00  5.68           N  
ATOM    670  CA  ARG A  90     -18.812 104.961  33.290  1.00  8.05           C  
ATOM    671  C   ARG A  90     -18.851 104.235  31.951  1.00 10.13           C  
ATOM    672  O   ARG A  90     -19.398 103.138  31.846  1.00  8.94           O  
ATOM    673  CB  ARG A  90     -20.008 105.911  33.431  1.00 10.69           C  
ATOM    674  CG  ARG A  90     -20.153 106.455  34.851  1.00 11.37           C  
ATOM    675  CD  ARG A  90     -21.157 107.587  34.963  1.00 15.92           C  
ATOM    676  NE  ARG A  90     -22.521 107.155  34.686  1.00 19.52           N  
ATOM    677  CZ  ARG A  90     -23.602 107.837  35.051  1.00 25.18           C  
ATOM    678  NH1 ARG A  90     -23.475 108.982  35.709  1.00 28.83           N  
ATOM    679  NH2 ARG A  90     -24.809 107.372  34.763  1.00 26.29           N  
ATOM    680  N   LEU A  91     -18.255 104.842  30.930  1.00  9.64           N  
ATOM    681  CA  LEU A  91     -18.220 104.226  29.609  1.00 11.09           C  
ATOM    682  C   LEU A  91     -17.300 103.009  29.640  1.00 12.56           C  
ATOM    683  O   LEU A  91     -17.563 101.999  28.983  1.00 14.87           O  
ATOM    684  CB  LEU A  91     -17.726 105.229  28.561  1.00 10.10           C  
ATOM    685  CG  LEU A  91     -18.684 106.367  28.194  1.00 13.22           C  
ATOM    686  CD1 LEU A  91     -18.030 107.278  27.164  1.00 12.64           C  
ATOM    687  CD2 LEU A  91     -19.982 105.787  27.638  1.00 16.83           C  
ATOM    688  N   SER A  92     -16.231 103.111  30.424  1.00  9.70           N  
ATOM    689  CA  SER A  92     -15.253 102.039  30.556  1.00 11.14           C  
ATOM    690  C   SER A  92     -15.810 100.757  31.171  1.00 12.03           C  
ATOM    691  O   SER A  92     -15.282  99.674  30.922  1.00 13.02           O  
ATOM    692  CB  SER A  92     -14.068 102.508  31.404  1.00  9.63           C  
ATOM    693  OG  SER A  92     -13.427 103.631  30.829  1.00 11.51           O  
ATOM    694  N   ILE A  93     -16.868 100.869  31.971  1.00  9.88           N  
ATOM    695  CA  ILE A  93     -17.429  99.687  32.617  1.00 11.49           C  
ATOM    696  C   ILE A  93     -18.684  99.092  31.978  1.00 11.63           C  
ATOM    697  O   ILE A  93     -19.334  98.232  32.572  1.00 10.72           O  
ATOM    698  CB  ILE A  93     -17.712  99.951  34.112  1.00 10.69           C  
ATOM    699  CG1 ILE A  93     -18.784 101.030  34.271  1.00 13.09           C  
ATOM    700  CG2 ILE A  93     -16.426 100.364  34.809  1.00 14.49           C  
ATOM    701  CD1 ILE A  93     -19.397 101.128  35.666  1.00 13.93           C  
ATOM    702  N   VAL A  94     -19.027  99.550  30.779  1.00 10.46           N  
ATOM    703  CA  VAL A  94     -20.188  99.014  30.071  1.00 11.13           C  
ATOM    704  C   VAL A  94     -19.867  97.551  29.764  1.00  8.95           C  
ATOM    705  O   VAL A  94     -18.809  97.245  29.215  1.00  9.92           O  
ATOM    706  CB  VAL A  94     -20.440  99.794  28.767  1.00 13.39           C  
ATOM    707  CG1 VAL A  94     -21.506  99.099  27.923  1.00 13.93           C  
ATOM    708  CG2 VAL A  94     -20.880 101.212  29.105  1.00 12.98           C  
ATOM    709  N   LYS A  95     -20.768  96.644  30.129  1.00  8.82           N  
ATOM    710  CA  LYS A  95     -20.517  95.221  29.917  1.00  8.19           C  
ATOM    711  C   LYS A  95     -20.942  94.659  28.570  1.00  7.28           C  
ATOM    712  O   LYS A  95     -20.363  93.680  28.097  1.00  9.08           O  
ATOM    713  CB  LYS A  95     -21.163  94.408  31.042  1.00 10.69           C  
ATOM    714  CG  LYS A  95     -20.496  94.632  32.391  1.00 10.75           C  
ATOM    715  CD  LYS A  95     -21.054  93.710  33.456  1.00 13.70           C  
ATOM    716  CE  LYS A  95     -20.368  93.937  34.792  1.00 12.44           C  
ATOM    717  NZ  LYS A  95     -18.905  93.673  34.720  1.00 12.81           N  
ATOM    718  N   THR A  96     -21.940  95.274  27.953  1.00  6.76           N  
ATOM    719  CA  THR A  96     -22.429  94.814  26.658  1.00  7.22           C  
ATOM    720  C   THR A  96     -21.396  95.100  25.569  1.00  6.65           C  
ATOM    721  O   THR A  96     -20.704  96.115  25.615  1.00  5.70           O  
ATOM    722  CB  THR A  96     -23.747  95.526  26.290  1.00  9.10           C  
ATOM    723  OG1 THR A  96     -24.731  95.255  27.299  1.00 10.48           O  
ATOM    724  CG2 THR A  96     -24.262  95.044  24.944  1.00  6.27           C  
ATOM    725  N   PRO A  97     -21.258  94.191  24.589  1.00  6.11           N  
ATOM    726  CA  PRO A  97     -20.289  94.416  23.514  1.00  7.65           C  
ATOM    727  C   PRO A  97     -20.542  95.756  22.821  1.00  8.37           C  
ATOM    728  O   PRO A  97     -21.684  96.095  22.494  1.00  6.86           O  
ATOM    729  CB  PRO A  97     -20.524  93.225  22.588  1.00  6.83           C  
ATOM    730  CG  PRO A  97     -20.853  92.132  23.556  1.00  8.95           C  
ATOM    731  CD  PRO A  97     -21.814  92.827  24.513  1.00  6.59           C  
ATOM    732  N   MET A  98     -19.471  96.515  22.611  1.00  8.38           N  
ATOM    733  CA  MET A  98     -19.561  97.819  21.962  1.00  9.61           C  
ATOM    734  C   MET A  98     -18.612  97.933  20.783  1.00  8.01           C  
ATOM    735  O   MET A  98     -17.423  97.624  20.890  1.00  8.23           O  
ATOM    736  CB  MET A  98     -19.241  98.942  22.948  1.00 12.23           C  
ATOM    737  CG  MET A  98     -20.401  99.387  23.805  1.00 19.11           C  
ATOM    738  SD  MET A  98     -20.319 101.174  24.037  1.00 22.20           S  
ATOM    739  CE  MET A  98     -18.764 101.314  24.928  1.00 19.43           C  
ATOM    740  N   ILE A  99     -19.147  98.395  19.659  1.00  6.85           N  
ATOM    741  CA  ILE A  99     -18.361  98.557  18.443  1.00  5.90           C  
ATOM    742  C   ILE A  99     -18.428  99.999  17.962  1.00  5.61           C  
ATOM    743  O   ILE A  99     -19.496 100.613  17.948  1.00  5.95           O  
ATOM    744  CB  ILE A  99     -18.897  97.657  17.306  1.00  5.29           C  
ATOM    745  CG1 ILE A  99     -18.898  96.193  17.748  1.00  6.90           C  
ATOM    746  CG2 ILE A  99     -18.049  97.854  16.042  1.00  6.00           C  
ATOM    747  CD1 ILE A  99     -17.663  95.645  18.430  1.00 13.93           C  
ATOM    748  N   ALA A 100     -17.283 100.540  17.568  1.00  5.35           N  
ATOM    749  CA  ALA A 100     -17.246 101.897  17.057  1.00  4.65           C  
ATOM    750  C   ALA A 100     -17.138 101.827  15.543  1.00  4.44           C  
ATOM    751  O   ALA A 100     -16.245 101.176  15.015  1.00  7.49           O  
ATOM    752  CB  ALA A 100     -16.046 102.655  17.631  1.00  5.55           C  
ATOM    753  N   ALA A 101     -18.075 102.470  14.854  1.00  4.39           N  
ATOM    754  CA  ALA A 101     -18.049 102.531  13.397  1.00  4.79           C  
ATOM    755  C   ALA A 101     -17.536 103.939  13.115  1.00  5.35           C  
ATOM    756  O   ALA A 101     -18.312 104.892  13.053  1.00  6.60           O  
ATOM    757  CB  ALA A 101     -19.449 102.348  12.822  1.00  5.72           C  
ATOM    758  N   VAL A 102     -16.222 104.064  12.971  1.00  5.62           N  
ATOM    759  CA  VAL A 102     -15.602 105.365  12.748  1.00  6.63           C  
ATOM    760  C   VAL A 102     -15.693 105.798  11.288  1.00  6.63           C  
ATOM    761  O   VAL A 102     -14.917 105.363  10.440  1.00  7.29           O  
ATOM    762  CB  VAL A 102     -14.136 105.341  13.222  1.00  7.83           C  
ATOM    763  CG1 VAL A 102     -13.545 106.748  13.179  1.00  4.02           C  
ATOM    764  CG2 VAL A 102     -14.075 104.796  14.649  1.00  9.63           C  
ATOM    765  N   ASN A 103     -16.662 106.671  11.026  1.00  8.21           N  
ATOM    766  CA  ASN A 103     -16.961 107.192   9.696  1.00  8.27           C  
ATOM    767  C   ASN A 103     -16.084 108.343   9.226  1.00 11.77           C  
ATOM    768  O   ASN A 103     -16.204 108.783   8.082  1.00 13.92           O  
ATOM    769  CB  ASN A 103     -18.412 107.656   9.654  1.00  8.19           C  
ATOM    770  CG  ASN A 103     -18.718 108.668  10.738  1.00 10.29           C  
ATOM    771  OD1 ASN A 103     -18.713 108.334  11.926  1.00  6.51           O  
ATOM    772  ND2 ASN A 103     -18.972 109.912  10.341  1.00 10.81           N  
ATOM    773  N   GLY A 104     -15.219 108.845  10.101  1.00 10.48           N  
ATOM    774  CA  GLY A 104     -14.361 109.952   9.722  1.00 12.74           C  
ATOM    775  C   GLY A 104     -13.418 110.361  10.833  1.00 11.20           C  
ATOM    776  O   GLY A 104     -12.881 109.509  11.537  1.00 10.76           O  
ATOM    777  N   LEU A 105     -13.215 111.666  10.988  1.00  9.39           N  
ATOM    778  CA  LEU A 105     -12.323 112.180  12.019  1.00  9.78           C  
ATOM    779  C   LEU A 105     -12.715 111.728  13.420  1.00  8.68           C  
ATOM    780  O   LEU A 105     -13.874 111.829  13.818  1.00  8.12           O  
ATOM    781  CB  LEU A 105     -12.299 113.710  11.991  1.00 14.04           C  
ATOM    782  CG  LEU A 105     -11.836 114.429  10.725  1.00 17.41           C  
ATOM    783  CD1 LEU A 105     -11.979 115.931  10.926  1.00 17.07           C  
ATOM    784  CD2 LEU A 105     -10.396 114.064  10.412  1.00 18.83           C  
ATOM    785  N   ALA A 106     -11.726 111.228  14.153  1.00  7.56           N  
ATOM    786  CA  ALA A 106     -11.887 110.787  15.533  1.00  7.35           C  
ATOM    787  C   ALA A 106     -10.658 111.383  16.215  1.00  6.50           C  
ATOM    788  O   ALA A 106      -9.636 110.718  16.377  1.00  7.25           O  
ATOM    789  CB  ALA A 106     -11.866 109.260  15.618  1.00  6.67           C  
ATOM    790  N   LEU A 107     -10.764 112.658  16.583  1.00  8.26           N  
ATOM    791  CA  LEU A 107      -9.659 113.389  17.202  1.00  8.70           C  
ATOM    792  C   LEU A 107      -9.907 113.749  18.661  1.00  7.55           C  
ATOM    793  O   LEU A 107     -11.023 114.115  19.042  1.00  7.27           O  
ATOM    794  CB  LEU A 107      -9.396 114.669  16.405  1.00  8.21           C  
ATOM    795  CG  LEU A 107      -9.275 114.500  14.886  1.00  8.58           C  
ATOM    796  CD1 LEU A 107      -9.285 115.869  14.219  1.00 10.72           C  
ATOM    797  CD2 LEU A 107      -8.006 113.739  14.546  1.00 11.64           C  
ATOM    798  N   GLY A 108      -8.850 113.664  19.467  1.00  7.14           N  
ATOM    799  CA  GLY A 108      -8.958 113.983  20.881  1.00  6.47           C  
ATOM    800  C   GLY A 108      -9.968 113.082  21.560  1.00  8.45           C  
ATOM    801  O   GLY A 108      -9.824 111.862  21.547  1.00  5.79           O  
ATOM    802  N   GLY A 109     -10.993 113.682  22.158  1.00  6.26           N  
ATOM    803  CA  GLY A 109     -12.018 112.897  22.820  1.00  7.43           C  
ATOM    804  C   GLY A 109     -12.617 111.885  21.860  1.00  5.97           C  
ATOM    805  O   GLY A 109     -13.034 110.803  22.268  1.00  7.76           O  
ATOM    806  N   GLY A 110     -12.661 112.237  20.577  1.00  6.27           N  
ATOM    807  CA  GLY A 110     -13.208 111.334  19.578  1.00  7.38           C  
ATOM    808  C   GLY A 110     -12.421 110.041  19.488  1.00  6.01           C  
ATOM    809  O   GLY A 110     -12.996 108.955  19.374  1.00  5.00           O  
ATOM    810  N   PHE A 111     -11.096 110.155  19.535  1.00  4.45           N  
ATOM    811  CA  PHE A 111     -10.225 108.985  19.485  1.00  4.75           C  
ATOM    812  C   PHE A 111     -10.446 108.202  20.782  1.00  3.57           C  
ATOM    813  O   PHE A 111     -10.532 106.975  20.773  1.00  4.97           O  
ATOM    814  CB  PHE A 111      -8.761 109.439  19.368  1.00  3.75           C  
ATOM    815  CG  PHE A 111      -7.790 108.347  18.965  1.00  4.14           C  
ATOM    816  CD1 PHE A 111      -8.203 107.030  18.781  1.00  5.39           C  
ATOM    817  CD2 PHE A 111      -6.442 108.652  18.782  1.00  5.86           C  
ATOM    818  CE1 PHE A 111      -7.290 106.034  18.424  1.00  5.97           C  
ATOM    819  CE2 PHE A 111      -5.520 107.667  18.427  1.00  6.18           C  
ATOM    820  CZ  PHE A 111      -5.946 106.352  18.247  1.00  6.11           C  
ATOM    821  N   GLU A 112     -10.552 108.919  21.897  1.00  4.61           N  
ATOM    822  CA  GLU A 112     -10.767 108.272  23.188  1.00  5.39           C  
ATOM    823  C   GLU A 112     -12.105 107.534  23.244  1.00  5.42           C  
ATOM    824  O   GLU A 112     -12.219 106.503  23.905  1.00  5.10           O  
ATOM    825  CB  GLU A 112     -10.647 109.307  24.316  1.00  6.66           C  
ATOM    826  CG  GLU A 112      -9.200 109.778  24.488  1.00  6.78           C  
ATOM    827  CD  GLU A 112      -9.051 111.009  25.361  1.00  9.21           C  
ATOM    828  OE1 GLU A 112      -9.736 112.019  25.091  1.00 10.80           O  
ATOM    829  OE2 GLU A 112      -8.235 110.969  26.307  1.00  7.29           O  
ATOM    830  N   LEU A 113     -13.111 108.048  22.540  1.00  4.78           N  
ATOM    831  CA  LEU A 113     -14.414 107.387  22.511  1.00  5.34           C  
ATOM    832  C   LEU A 113     -14.291 106.069  21.740  1.00  5.83           C  
ATOM    833  O   LEU A 113     -14.795 105.033  22.177  1.00  5.67           O  
ATOM    834  CB  LEU A 113     -15.462 108.287  21.847  1.00  5.83           C  
ATOM    835  CG  LEU A 113     -16.878 107.711  21.726  1.00  6.82           C  
ATOM    836  CD1 LEU A 113     -17.445 107.402  23.115  1.00  6.98           C  
ATOM    837  CD2 LEU A 113     -17.772 108.709  20.998  1.00  7.47           C  
ATOM    838  N   ALA A 114     -13.613 106.102  20.596  1.00  4.59           N  
ATOM    839  CA  ALA A 114     -13.440 104.887  19.806  1.00  6.89           C  
ATOM    840  C   ALA A 114     -12.645 103.848  20.599  1.00  6.54           C  
ATOM    841  O   ALA A 114     -12.981 102.663  20.597  1.00  5.90           O  
ATOM    842  CB  ALA A 114     -12.728 105.201  18.492  1.00  5.58           C  
ATOM    843  N   LEU A 115     -11.597 104.297  21.285  1.00  6.19           N  
ATOM    844  CA  LEU A 115     -10.763 103.396  22.071  1.00  5.36           C  
ATOM    845  C   LEU A 115     -11.535 102.764  23.233  1.00  6.70           C  
ATOM    846  O   LEU A 115     -11.175 101.686  23.708  1.00  6.63           O  
ATOM    847  CB  LEU A 115      -9.528 104.142  22.596  1.00  6.34           C  
ATOM    848  CG  LEU A 115      -8.511 104.579  21.530  1.00  4.88           C  
ATOM    849  CD1 LEU A 115      -7.477 105.502  22.147  1.00  6.51           C  
ATOM    850  CD2 LEU A 115      -7.837 103.351  20.916  1.00  6.32           C  
ATOM    851  N   SER A 116     -12.595 103.433  23.680  1.00  6.43           N  
ATOM    852  CA  SER A 116     -13.417 102.926  24.776  1.00  6.21           C  
ATOM    853  C   SER A 116     -14.297 101.761  24.319  1.00  7.69           C  
ATOM    854  O   SER A 116     -14.845 101.030  25.138  1.00  7.46           O  
ATOM    855  CB  SER A 116     -14.298 104.041  25.350  1.00  8.32           C  
ATOM    856  OG  SER A 116     -13.512 105.079  25.909  1.00 11.02           O  
ATOM    857  N   CYS A 117     -14.435 101.591  23.007  1.00  5.49           N  
ATOM    858  CA  CYS A 117     -15.238 100.496  22.478  1.00  6.44           C  
ATOM    859  C   CYS A 117     -14.389  99.228  22.433  1.00  5.76           C  
ATOM    860  O   CYS A 117     -13.168  99.293  22.562  1.00  6.26           O  
ATOM    861  CB  CYS A 117     -15.759 100.847  21.083  1.00  2.85           C  
ATOM    862  SG  CYS A 117     -16.951 102.220  21.112  1.00  6.80           S  
ATOM    863  N   ASP A 118     -15.034  98.079  22.254  1.00  4.19           N  
ATOM    864  CA  ASP A 118     -14.321  96.800  22.222  1.00  5.16           C  
ATOM    865  C   ASP A 118     -13.686  96.463  20.882  1.00  6.83           C  
ATOM    866  O   ASP A 118     -12.637  95.815  20.829  1.00  7.17           O  
ATOM    867  CB  ASP A 118     -15.270  95.675  22.625  1.00  6.04           C  
ATOM    868  CG  ASP A 118     -15.941  95.942  23.949  1.00  5.87           C  
ATOM    869  OD1 ASP A 118     -15.214  96.189  24.935  1.00  6.33           O  
ATOM    870  OD2 ASP A 118     -17.191  95.913  24.004  1.00  8.04           O  
ATOM    871  N   LEU A 119     -14.344  96.879  19.808  1.00  5.32           N  
ATOM    872  CA  LEU A 119     -13.856  96.644  18.455  1.00  5.62           C  
ATOM    873  C   LEU A 119     -14.076  97.927  17.683  1.00  6.09           C  
ATOM    874  O   LEU A 119     -15.012  98.679  17.971  1.00  4.87           O  
ATOM    875  CB  LEU A 119     -14.645  95.527  17.766  1.00  3.78           C  
ATOM    876  CG  LEU A 119     -14.697  94.134  18.392  1.00  4.98           C  
ATOM    877  CD1 LEU A 119     -15.626  93.251  17.577  1.00  6.12           C  
ATOM    878  CD2 LEU A 119     -13.301  93.537  18.449  1.00  6.07           C  
ATOM    879  N   ILE A 120     -13.224  98.173  16.694  1.00  5.11           N  
ATOM    880  CA  ILE A 120     -13.361  99.371  15.879  1.00  6.36           C  
ATOM    881  C   ILE A 120     -13.357  99.012  14.393  1.00  7.21           C  
ATOM    882  O   ILE A 120     -12.418  98.390  13.904  1.00  8.05           O  
ATOM    883  CB  ILE A 120     -12.207 100.370  16.131  1.00  4.99           C  
ATOM    884  CG1 ILE A 120     -12.161 100.779  17.605  1.00  5.10           C  
ATOM    885  CG2 ILE A 120     -12.381 101.594  15.239  1.00  7.95           C  
ATOM    886  CD1 ILE A 120     -10.871 101.471  18.041  1.00 13.93           C  
ATOM    887  N   VAL A 121     -14.420  99.388  13.691  1.00  5.48           N  
ATOM    888  CA  VAL A 121     -14.513  99.161  12.251  1.00  6.74           C  
ATOM    889  C   VAL A 121     -14.392 100.571  11.702  1.00  9.00           C  
ATOM    890  O   VAL A 121     -15.180 101.446  12.065  1.00  8.60           O  
ATOM    891  CB  VAL A 121     -15.870  98.571  11.840  1.00  7.24           C  
ATOM    892  CG1 VAL A 121     -15.937  98.439  10.322  1.00  7.99           C  
ATOM    893  CG2 VAL A 121     -16.068  97.214  12.501  1.00  5.54           C  
ATOM    894  N   ALA A 122     -13.410 100.800  10.837  1.00  8.75           N  
ATOM    895  CA  ALA A 122     -13.197 102.139  10.313  1.00  7.41           C  
ATOM    896  C   ALA A 122     -13.352 102.296   8.816  1.00 10.69           C  
ATOM    897  O   ALA A 122     -13.110 101.372   8.040  1.00  7.98           O  
ATOM    898  CB  ALA A 122     -11.813 102.639  10.734  1.00 10.10           C  
ATOM    899  N   SER A 123     -13.766 103.498   8.433  1.00 11.55           N  
ATOM    900  CA  SER A 123     -13.924 103.874   7.039  1.00 15.69           C  
ATOM    901  C   SER A 123     -12.558 104.355   6.572  1.00 18.70           C  
ATOM    902  O   SER A 123     -11.666 104.603   7.384  1.00 17.42           O  
ATOM    903  CB  SER A 123     -14.928 105.021   6.908  1.00 19.19           C  
ATOM    904  OG  SER A 123     -14.735 105.734   5.694  1.00 18.40           O  
ATOM    905  N   SER A 124     -12.399 104.484   5.260  1.00 20.01           N  
ATOM    906  CA  SER A 124     -11.153 104.980   4.702  1.00 21.54           C  
ATOM    907  C   SER A 124     -11.104 106.484   4.964  1.00 19.96           C  
ATOM    908  O   SER A 124     -10.061 107.119   4.843  1.00 20.79           O  
ATOM    909  CB  SER A 124     -11.100 104.703   3.197  1.00 24.04           C  
ATOM    910  OG  SER A 124     -11.081 103.314   2.926  1.00 24.11           O  
ATOM    911  N   ALA A 125     -12.252 107.047   5.325  1.00 22.04           N  
ATOM    912  CA  ALA A 125     -12.365 108.472   5.605  1.00 21.23           C  
ATOM    913  C   ALA A 125     -11.913 108.779   7.031  1.00 21.67           C  
ATOM    914  O   ALA A 125     -11.844 109.941   7.433  1.00 22.95           O  
ATOM    915  CB  ALA A 125     -13.811 108.923   5.417  1.00 21.12           C  
ATOM    916  N   ALA A 126     -11.599 107.733   7.790  1.00 19.27           N  
ATOM    917  CA  ALA A 126     -11.202 107.898   9.185  1.00 14.91           C  
ATOM    918  C   ALA A 126      -9.742 108.239   9.450  1.00 13.65           C  
ATOM    919  O   ALA A 126      -8.831 107.749   8.784  1.00 14.98           O  
ATOM    920  CB  ALA A 126     -11.584 106.645   9.975  1.00 13.71           C  
ATOM    921  N   GLU A 127      -9.544 109.088  10.451  1.00 12.44           N  
ATOM    922  CA  GLU A 127      -8.223 109.508  10.896  1.00 11.32           C  
ATOM    923  C   GLU A 127      -8.326 109.593  12.411  1.00  8.56           C  
ATOM    924  O   GLU A 127      -9.346 110.021  12.938  1.00  9.44           O  
ATOM    925  CB  GLU A 127      -7.849 110.876  10.321  1.00 12.90           C  
ATOM    926  CG  GLU A 127      -7.354 110.831   8.883  1.00 16.83           C  
ATOM    927  CD  GLU A 127      -6.675 112.124   8.467  1.00 18.10           C  
ATOM    928  OE1 GLU A 127      -7.370 113.157   8.368  1.00 16.67           O  
ATOM    929  OE2 GLU A 127      -5.444 112.108   8.246  1.00 19.53           O  
ATOM    930  N   PHE A 128      -7.273 109.176  13.101  1.00  8.21           N  
ATOM    931  CA  PHE A 128      -7.256 109.184  14.559  1.00  6.69           C  
ATOM    932  C   PHE A 128      -6.075 110.007  15.046  1.00  8.21           C  
ATOM    933  O   PHE A 128      -4.990 109.939  14.474  1.00 10.42           O  
ATOM    934  CB  PHE A 128      -7.117 107.754  15.086  1.00  6.36           C  
ATOM    935  CG  PHE A 128      -8.170 106.812  14.577  1.00  7.52           C  
ATOM    936  CD1 PHE A 128      -9.345 106.608  15.294  1.00  9.56           C  
ATOM    937  CD2 PHE A 128      -7.987 106.125  13.377  1.00  9.23           C  
ATOM    938  CE1 PHE A 128     -10.323 105.732  14.830  1.00  7.67           C  
ATOM    939  CE2 PHE A 128      -8.958 105.246  12.901  1.00  9.76           C  
ATOM    940  CZ  PHE A 128     -10.130 105.048  13.630  1.00  8.40           C  
ATOM    941  N   GLY A 129      -6.278 110.780  16.104  1.00  6.45           N  
ATOM    942  CA  GLY A 129      -5.178 111.577  16.614  1.00  9.24           C  
ATOM    943  C   GLY A 129      -5.494 112.311  17.900  1.00  7.93           C  
ATOM    944  O   GLY A 129      -6.652 112.391  18.311  1.00 10.55           O  
ATOM    945  N   PHE A 130      -4.449 112.847  18.524  1.00  7.26           N  
ATOM    946  CA  PHE A 130      -4.566 113.596  19.771  1.00  6.21           C  
ATOM    947  C   PHE A 130      -3.903 114.956  19.592  1.00  6.41           C  
ATOM    948  O   PHE A 130      -2.746 115.150  19.961  1.00  9.78           O  
ATOM    949  CB  PHE A 130      -3.884 112.837  20.909  1.00  8.60           C  
ATOM    950  CG  PHE A 130      -4.616 111.599  21.329  1.00  7.71           C  
ATOM    951  CD1 PHE A 130      -5.891 111.687  21.880  1.00  8.40           C  
ATOM    952  CD2 PHE A 130      -4.037 110.345  21.169  1.00  7.88           C  
ATOM    953  CE1 PHE A 130      -6.582 110.540  22.266  1.00  7.93           C  
ATOM    954  CE2 PHE A 130      -4.718 109.192  21.553  1.00  8.26           C  
ATOM    955  CZ  PHE A 130      -5.994 109.291  22.103  1.00  7.34           C  
ATOM    956  N   PRO A 131      -4.635 115.917  19.016  1.00  8.49           N  
ATOM    957  CA  PRO A 131      -4.104 117.260  18.785  1.00  9.06           C  
ATOM    958  C   PRO A 131      -4.051 118.128  20.039  1.00  9.99           C  
ATOM    959  O   PRO A 131      -3.593 119.269  19.979  1.00 10.67           O  
ATOM    960  CB  PRO A 131      -5.049 117.818  17.726  1.00 11.66           C  
ATOM    961  CG  PRO A 131      -6.362 117.227  18.134  1.00 11.73           C  
ATOM    962  CD  PRO A 131      -5.990 115.783  18.448  1.00  9.65           C  
ATOM    963  N   GLU A 132      -4.498 117.581  21.169  1.00  7.06           N  
ATOM    964  CA  GLU A 132      -4.508 118.324  22.430  1.00 11.01           C  
ATOM    965  C   GLU A 132      -3.177 118.987  22.761  1.00  9.00           C  
ATOM    966  O   GLU A 132      -3.147 120.114  23.257  1.00  7.09           O  
ATOM    967  CB  GLU A 132      -4.908 117.422  23.606  1.00  9.98           C  
ATOM    968  CG  GLU A 132      -6.375 117.033  23.634  1.00 13.46           C  
ATOM    969  CD  GLU A 132      -6.626 115.663  23.036  1.00 13.80           C  
ATOM    970  OE1 GLU A 132      -5.947 115.311  22.052  1.00 10.15           O  
ATOM    971  OE2 GLU A 132      -7.511 114.943  23.546  1.00 20.70           O  
ATOM    972  N   VAL A 133      -2.078 118.288  22.496  1.00  8.02           N  
ATOM    973  CA  VAL A 133      -0.757 118.826  22.798  1.00  8.54           C  
ATOM    974  C   VAL A 133      -0.485 120.164  22.110  1.00  7.98           C  
ATOM    975  O   VAL A 133       0.212 121.022  22.663  1.00  8.01           O  
ATOM    976  CB  VAL A 133       0.359 117.815  22.421  1.00  6.59           C  
ATOM    977  CG1 VAL A 133       0.342 117.537  20.922  1.00  8.20           C  
ATOM    978  CG2 VAL A 133       1.715 118.353  22.850  1.00  8.25           C  
ATOM    979  N   ASN A 134      -1.034 120.355  20.915  1.00  7.53           N  
ATOM    980  CA  ASN A 134      -0.803 121.600  20.194  1.00  9.08           C  
ATOM    981  C   ASN A 134      -1.540 122.786  20.803  1.00  9.76           C  
ATOM    982  O   ASN A 134      -1.291 123.937  20.436  1.00 12.41           O  
ATOM    983  CB  ASN A 134      -1.170 121.441  18.716  1.00  9.96           C  
ATOM    984  CG  ASN A 134      -0.293 120.424  18.016  1.00 10.65           C  
ATOM    985  OD1 ASN A 134       0.914 120.368  18.252  1.00 11.06           O  
ATOM    986  ND2 ASN A 134      -0.889 119.620  17.146  1.00 11.72           N  
ATOM    987  N   LEU A 135      -2.437 122.506  21.743  1.00  8.42           N  
ATOM    988  CA  LEU A 135      -3.187 123.560  22.411  1.00  8.64           C  
ATOM    989  C   LEU A 135      -2.563 123.831  23.774  1.00  7.85           C  
ATOM    990  O   LEU A 135      -3.058 124.658  24.538  1.00  8.47           O  
ATOM    991  CB  LEU A 135      -4.650 123.144  22.598  1.00 11.79           C  
ATOM    992  CG  LEU A 135      -5.472 122.862  21.340  1.00 12.34           C  
ATOM    993  CD1 LEU A 135      -6.889 122.481  21.745  1.00 15.50           C  
ATOM    994  CD2 LEU A 135      -5.486 124.086  20.437  1.00 13.53           C  
ATOM    995  N   GLY A 136      -1.475 123.128  24.076  1.00  6.34           N  
ATOM    996  CA  GLY A 136      -0.819 123.312  25.358  1.00  6.25           C  
ATOM    997  C   GLY A 136      -1.330 122.368  26.438  1.00  7.23           C  
ATOM    998  O   GLY A 136      -0.911 122.457  27.593  1.00  9.77           O  
ATOM    999  N   VAL A 137      -2.236 121.462  26.077  1.00  5.91           N  
ATOM   1000  CA  VAL A 137      -2.773 120.516  27.052  1.00  7.53           C  
ATOM   1001  C   VAL A 137      -2.473 119.059  26.674  1.00  8.52           C  
ATOM   1002  O   VAL A 137      -1.455 118.786  26.034  1.00  7.93           O  
ATOM   1003  CB  VAL A 137      -4.299 120.728  27.257  1.00  8.45           C  
ATOM   1004  CG1 VAL A 137      -4.545 122.086  27.910  1.00  8.91           C  
ATOM   1005  CG2 VAL A 137      -5.033 120.649  25.930  1.00 10.60           C  
ATOM   1006  N   MET A 138      -3.343 118.133  27.069  1.00  6.57           N  
ATOM   1007  CA  MET A 138      -3.135 116.712  26.782  1.00  5.30           C  
ATOM   1008  C   MET A 138      -4.443 115.922  26.820  1.00  4.34           C  
ATOM   1009  O   MET A 138      -5.489 116.455  27.189  1.00  5.08           O  
ATOM   1010  CB  MET A 138      -2.174 116.117  27.819  1.00  4.37           C  
ATOM   1011  CG  MET A 138      -2.725 116.085  29.246  1.00  5.87           C  
ATOM   1012  SD  MET A 138      -1.544 115.475  30.484  1.00  7.36           S  
ATOM   1013  CE  MET A 138      -1.775 113.689  30.344  1.00  7.48           C  
ATOM   1014  N   PRO A 139      -4.402 114.642  26.415  1.00  5.97           N  
ATOM   1015  CA  PRO A 139      -5.630 113.843  26.453  1.00  6.43           C  
ATOM   1016  C   PRO A 139      -5.942 113.596  27.930  1.00  7.23           C  
ATOM   1017  O   PRO A 139      -5.037 113.323  28.716  1.00  7.41           O  
ATOM   1018  CB  PRO A 139      -5.232 112.564  25.725  1.00  7.97           C  
ATOM   1019  CG  PRO A 139      -4.210 113.057  24.727  1.00  7.51           C  
ATOM   1020  CD  PRO A 139      -3.377 113.988  25.579  1.00  4.78           C  
ATOM   1021  N   GLY A 140      -7.209 113.692  28.313  1.00  6.46           N  
ATOM   1022  CA  GLY A 140      -7.553 113.484  29.709  1.00  7.74           C  
ATOM   1023  C   GLY A 140      -8.600 112.417  29.945  1.00  7.03           C  
ATOM   1024  O   GLY A 140      -9.016 112.201  31.083  1.00  6.86           O  
ATOM   1025  N   ALA A 141      -9.014 111.743  28.875  1.00  6.53           N  
ATOM   1026  CA  ALA A 141     -10.032 110.701  28.970  1.00  7.72           C  
ATOM   1027  C   ALA A 141      -9.539 109.310  28.564  1.00  7.32           C  
ATOM   1028  O   ALA A 141     -10.218 108.596  27.821  1.00  7.85           O  
ATOM   1029  CB  ALA A 141     -11.246 111.093  28.124  1.00  9.29           C  
ATOM   1030  N   GLY A 142      -8.356 108.934  29.043  1.00  6.53           N  
ATOM   1031  CA  GLY A 142      -7.818 107.619  28.747  1.00  6.87           C  
ATOM   1032  C   GLY A 142      -6.930 107.500  27.523  1.00  5.86           C  
ATOM   1033  O   GLY A 142      -6.290 106.471  27.323  1.00  7.34           O  
ATOM   1034  N   GLY A 143      -6.892 108.545  26.703  1.00  3.87           N  
ATOM   1035  CA  GLY A 143      -6.076 108.521  25.501  1.00  5.57           C  
ATOM   1036  C   GLY A 143      -4.630 108.092  25.704  1.00  6.57           C  
ATOM   1037  O   GLY A 143      -4.132 107.230  24.978  1.00  6.36           O  
ATOM   1038  N   THR A 144      -3.949 108.680  26.683  1.00  5.76           N  
ATOM   1039  CA  THR A 144      -2.552 108.328  26.923  1.00  6.25           C  
ATOM   1040  C   THR A 144      -2.413 106.905  27.452  1.00  5.73           C  
ATOM   1041  O   THR A 144      -1.403 106.244  27.214  1.00  6.94           O  
ATOM   1042  CB  THR A 144      -1.875 109.283  27.934  1.00  4.95           C  
ATOM   1043  OG1 THR A 144      -2.473 109.125  29.226  1.00  6.27           O  
ATOM   1044  CG2 THR A 144      -2.019 110.723  27.485  1.00  7.27           C  
ATOM   1045  N   GLN A 145      -3.434 106.434  28.160  1.00  4.13           N  
ATOM   1046  CA  GLN A 145      -3.400 105.097  28.736  1.00  5.25           C  
ATOM   1047  C   GLN A 145      -3.711 103.995  27.733  1.00  5.17           C  
ATOM   1048  O   GLN A 145      -2.910 103.079  27.536  1.00  5.27           O  
ATOM   1049  CB  GLN A 145      -4.380 105.006  29.909  1.00  5.59           C  
ATOM   1050  CG  GLN A 145      -4.141 106.042  31.002  1.00  6.19           C  
ATOM   1051  CD  GLN A 145      -2.717 106.011  31.526  1.00  5.68           C  
ATOM   1052  OE1 GLN A 145      -1.935 106.937  31.293  1.00  9.53           O  
ATOM   1053  NE2 GLN A 145      -2.367 104.939  32.226  1.00  2.51           N  
ATOM   1054  N   ARG A 146      -4.874 104.083  27.098  1.00  4.74           N  
ATOM   1055  CA  ARG A 146      -5.270 103.066  26.136  1.00  6.29           C  
ATOM   1056  C   ARG A 146      -4.342 102.969  24.929  1.00  5.72           C  
ATOM   1057  O   ARG A 146      -4.053 101.866  24.463  1.00  5.66           O  
ATOM   1058  CB  ARG A 146      -6.716 103.294  25.685  1.00  6.25           C  
ATOM   1059  CG  ARG A 146      -7.753 103.052  26.789  1.00  7.60           C  
ATOM   1060  CD  ARG A 146      -9.156 102.913  26.205  1.00  8.64           C  
ATOM   1061  NE  ARG A 146     -10.136 102.436  27.181  1.00  9.01           N  
ATOM   1062  CZ  ARG A 146     -10.883 103.222  27.951  1.00 10.27           C  
ATOM   1063  NH1 ARG A 146     -10.776 104.542  27.872  1.00 10.49           N  
ATOM   1064  NH2 ARG A 146     -11.747 102.682  28.803  1.00 12.92           N  
ATOM   1065  N   LEU A 147      -3.858 104.101  24.425  1.00  5.58           N  
ATOM   1066  CA  LEU A 147      -2.961 104.058  23.272  1.00  5.19           C  
ATOM   1067  C   LEU A 147      -1.648 103.361  23.629  1.00  6.20           C  
ATOM   1068  O   LEU A 147      -1.154 102.526  22.872  1.00  5.73           O  
ATOM   1069  CB  LEU A 147      -2.662 105.471  22.746  1.00  4.87           C  
ATOM   1070  CG  LEU A 147      -1.933 105.503  21.394  1.00  5.21           C  
ATOM   1071  CD1 LEU A 147      -2.875 104.994  20.309  1.00  4.69           C  
ATOM   1072  CD2 LEU A 147      -1.481 106.922  21.057  1.00  5.91           C  
ATOM   1073  N   THR A 148      -1.089 103.698  24.788  1.00  5.21           N  
ATOM   1074  CA  THR A 148       0.167 103.101  25.227  1.00  5.17           C  
ATOM   1075  C   THR A 148       0.048 101.589  25.422  1.00  6.05           C  
ATOM   1076  O   THR A 148       0.952 100.833  25.062  1.00  6.04           O  
ATOM   1077  CB  THR A 148       0.655 103.748  26.539  1.00  6.51           C  
ATOM   1078  OG1 THR A 148       0.891 105.145  26.317  1.00  6.43           O  
ATOM   1079  CG2 THR A 148       1.949 103.092  27.014  1.00  5.60           C  
ATOM   1080  N   LYS A 149      -1.063 101.145  25.996  1.00  7.76           N  
ATOM   1081  CA  LYS A 149      -1.256  99.716  26.210  1.00  8.12           C  
ATOM   1082  C   LYS A 149      -1.383  98.977  24.882  1.00  8.50           C  
ATOM   1083  O   LYS A 149      -0.960  97.829  24.762  1.00 10.31           O  
ATOM   1084  CB  LYS A 149      -2.497  99.462  27.071  1.00  7.95           C  
ATOM   1085  CG  LYS A 149      -2.350  99.930  28.515  1.00 11.05           C  
ATOM   1086  CD  LYS A 149      -3.494  99.434  29.383  1.00 14.61           C  
ATOM   1087  CE  LYS A 149      -3.355  99.913  30.824  1.00 16.48           C  
ATOM   1088  NZ  LYS A 149      -2.104  99.432  31.479  1.00 13.75           N  
ATOM   1089  N   LEU A 150      -1.950  99.639  23.879  1.00  7.97           N  
ATOM   1090  CA  LEU A 150      -2.127  99.010  22.577  1.00  8.68           C  
ATOM   1091  C   LEU A 150      -0.890  98.969  21.684  1.00  8.14           C  
ATOM   1092  O   LEU A 150      -0.633  97.956  21.035  1.00  8.22           O  
ATOM   1093  CB  LEU A 150      -3.261  99.691  21.807  1.00  7.53           C  
ATOM   1094  CG  LEU A 150      -4.688  99.424  22.291  1.00  7.67           C  
ATOM   1095  CD1 LEU A 150      -5.656 100.336  21.551  1.00  9.40           C  
ATOM   1096  CD2 LEU A 150      -5.042  97.960  22.050  1.00  8.58           C  
ATOM   1097  N   ILE A 151      -0.122 100.056  21.643  1.00  8.44           N  
ATOM   1098  CA  ILE A 151       1.042 100.093  20.765  1.00  6.83           C  
ATOM   1099  C   ILE A 151       2.412 100.315  21.407  1.00  7.63           C  
ATOM   1100  O   ILE A 151       3.416 100.438  20.701  1.00  8.76           O  
ATOM   1101  CB  ILE A 151       0.815 101.143  19.637  1.00  8.43           C  
ATOM   1102  CG1 ILE A 151       0.723 102.556  20.212  1.00  8.86           C  
ATOM   1103  CG2 ILE A 151      -0.511 100.861  18.937  1.00  7.22           C  
ATOM   1104  CD1 ILE A 151       0.927 103.681  19.196  1.00 13.93           C  
ATOM   1105  N   GLY A 152       2.458 100.368  22.734  1.00  7.34           N  
ATOM   1106  CA  GLY A 152       3.727 100.564  23.417  1.00  6.75           C  
ATOM   1107  C   GLY A 152       4.084 102.027  23.613  1.00  6.51           C  
ATOM   1108  O   GLY A 152       3.612 102.879  22.865  1.00  6.73           O  
ATOM   1109  N   PRO A 153       4.935 102.350  24.599  1.00  7.00           N  
ATOM   1110  CA  PRO A 153       5.334 103.736  24.872  1.00  6.89           C  
ATOM   1111  C   PRO A 153       6.158 104.437  23.790  1.00  7.29           C  
ATOM   1112  O   PRO A 153       6.033 105.652  23.605  1.00  5.82           O  
ATOM   1113  CB  PRO A 153       6.097 103.618  26.187  1.00  7.94           C  
ATOM   1114  CG  PRO A 153       6.747 102.279  26.061  1.00  9.49           C  
ATOM   1115  CD  PRO A 153       5.621 101.421  25.514  1.00  7.43           C  
ATOM   1116  N   LYS A 154       7.001 103.687  23.086  1.00  7.68           N  
ATOM   1117  CA  LYS A 154       7.839 104.270  22.036  1.00  8.73           C  
ATOM   1118  C   LYS A 154       6.984 104.882  20.923  1.00  9.46           C  
ATOM   1119  O   LYS A 154       7.174 106.038  20.532  1.00  8.39           O  
ATOM   1120  CB  LYS A 154       8.776 103.202  21.450  1.00  8.34           C  
ATOM   1121  CG  LYS A 154       9.845 102.685  22.418  1.00  7.48           C  
ATOM   1122  CD  LYS A 154      10.994 103.678  22.571  1.00  9.23           C  
ATOM   1123  CE  LYS A 154      12.054 103.184  23.550  1.00  6.35           C  
ATOM   1124  NZ  LYS A 154      11.573 103.190  24.967  1.00  5.31           N  
ATOM   1125  N   ARG A 155       6.034 104.109  20.412  1.00  6.92           N  
ATOM   1126  CA  ARG A 155       5.175 104.611  19.353  1.00  6.77           C  
ATOM   1127  C   ARG A 155       4.124 105.583  19.887  1.00  5.64           C  
ATOM   1128  O   ARG A 155       3.812 106.585  19.245  1.00  5.87           O  
ATOM   1129  CB  ARG A 155       4.522 103.436  18.612  1.00  6.78           C  
ATOM   1130  CG  ARG A 155       5.527 102.636  17.786  1.00 10.25           C  
ATOM   1131  CD  ARG A 155       4.898 101.473  17.040  1.00 13.51           C  
ATOM   1132  NE  ARG A 155       4.380 100.468  17.959  1.00 13.38           N  
ATOM   1133  CZ  ARG A 155       4.190  99.192  17.644  1.00 15.57           C  
ATOM   1134  NH1 ARG A 155       4.479  98.759  16.426  1.00 15.38           N  
ATOM   1135  NH2 ARG A 155       3.713  98.350  18.551  1.00 14.96           N  
ATOM   1136  N   ALA A 156       3.605 105.308  21.079  1.00  6.78           N  
ATOM   1137  CA  ALA A 156       2.584 106.166  21.672  1.00  6.23           C  
ATOM   1138  C   ALA A 156       3.058 107.600  21.865  1.00  8.91           C  
ATOM   1139  O   ALA A 156       2.337 108.543  21.533  1.00  5.79           O  
ATOM   1140  CB  ALA A 156       2.130 105.592  23.005  1.00  7.45           C  
ATOM   1141  N   LEU A 157       4.263 107.767  22.404  1.00  7.20           N  
ATOM   1142  CA  LEU A 157       4.790 109.109  22.643  1.00  7.84           C  
ATOM   1143  C   LEU A 157       4.961 109.900  21.354  1.00  7.71           C  
ATOM   1144  O   LEU A 157       4.801 111.120  21.341  1.00  6.97           O  
ATOM   1145  CB  LEU A 157       6.112 109.035  23.412  1.00  7.08           C  
ATOM   1146  CG  LEU A 157       5.937 108.687  24.897  1.00  6.12           C  
ATOM   1147  CD1 LEU A 157       7.294 108.476  25.550  1.00  8.21           C  
ATOM   1148  CD2 LEU A 157       5.165 109.811  25.593  1.00  6.24           C  
ATOM   1149  N   GLU A 158       5.274 109.204  20.268  1.00  8.37           N  
ATOM   1150  CA  GLU A 158       5.436 109.860  18.979  1.00  8.97           C  
ATOM   1151  C   GLU A 158       4.115 110.553  18.626  1.00  9.44           C  
ATOM   1152  O   GLU A 158       4.081 111.746  18.320  1.00  8.94           O  
ATOM   1153  CB  GLU A 158       5.789 108.822  17.906  1.00 11.22           C  
ATOM   1154  CG  GLU A 158       6.241 109.409  16.579  1.00 16.06           C  
ATOM   1155  CD  GLU A 158       6.448 108.346  15.511  1.00 18.01           C  
ATOM   1156  OE1 GLU A 158       7.094 107.320  15.805  1.00 20.02           O  
ATOM   1157  OE2 GLU A 158       5.966 108.538  14.376  1.00 25.96           O  
ATOM   1158  N   TRP A 159       3.019 109.805  18.692  1.00  8.13           N  
ATOM   1159  CA  TRP A 159       1.714 110.361  18.362  1.00  5.40           C  
ATOM   1160  C   TRP A 159       1.196 111.382  19.368  1.00  4.18           C  
ATOM   1161  O   TRP A 159       0.626 112.404  18.983  1.00  4.49           O  
ATOM   1162  CB  TRP A 159       0.688 109.235  18.203  1.00  7.46           C  
ATOM   1163  CG  TRP A 159       1.035 108.297  17.092  1.00  8.63           C  
ATOM   1164  CD1 TRP A 159       1.626 107.072  17.204  1.00  9.04           C  
ATOM   1165  CD2 TRP A 159       0.860 108.533  15.693  1.00  7.00           C  
ATOM   1166  NE1 TRP A 159       1.831 106.528  15.958  1.00  7.94           N  
ATOM   1167  CE2 TRP A 159       1.369 107.405  15.013  1.00  8.82           C  
ATOM   1168  CE3 TRP A 159       0.324 109.589  14.946  1.00  8.71           C  
ATOM   1169  CZ2 TRP A 159       1.357 107.302  13.616  1.00  9.63           C  
ATOM   1170  CZ3 TRP A 159       0.312 109.488  13.554  1.00  8.71           C  
ATOM   1171  CH2 TRP A 159       0.826 108.351  12.908  1.00 11.65           C  
ATOM   1172  N   LEU A 160       1.389 111.103  20.653  1.00  4.84           N  
ATOM   1173  CA  LEU A 160       0.917 111.995  21.706  1.00  3.65           C  
ATOM   1174  C   LEU A 160       1.681 113.317  21.769  1.00  5.33           C  
ATOM   1175  O   LEU A 160       1.087 114.366  22.009  1.00  7.97           O  
ATOM   1176  CB  LEU A 160       0.990 111.278  23.060  1.00  3.08           C  
ATOM   1177  CG  LEU A 160       0.057 110.069  23.196  1.00  5.67           C  
ATOM   1178  CD1 LEU A 160       0.453 109.235  24.404  1.00  5.28           C  
ATOM   1179  CD2 LEU A 160      -1.387 110.555  23.321  1.00  4.65           C  
ATOM   1180  N   TRP A 161       2.990 113.265  21.541  1.00  5.98           N  
ATOM   1181  CA  TRP A 161       3.819 114.471  21.584  1.00  5.31           C  
ATOM   1182  C   TRP A 161       3.679 115.378  20.359  1.00  7.69           C  
ATOM   1183  O   TRP A 161       3.799 116.598  20.473  1.00  7.05           O  
ATOM   1184  CB  TRP A 161       5.294 114.097  21.744  1.00  3.29           C  
ATOM   1185  CG  TRP A 161       5.728 113.751  23.141  1.00  6.05           C  
ATOM   1186  CD1 TRP A 161       5.026 113.938  24.302  1.00  5.46           C  
ATOM   1187  CD2 TRP A 161       7.004 113.231  23.523  1.00  6.35           C  
ATOM   1188  NE1 TRP A 161       5.792 113.570  25.384  1.00  5.71           N  
ATOM   1189  CE2 TRP A 161       7.013 113.132  24.934  1.00  6.80           C  
ATOM   1190  CE3 TRP A 161       8.148 112.842  22.812  1.00  5.81           C  
ATOM   1191  CZ2 TRP A 161       8.119 112.660  25.646  1.00  6.94           C  
ATOM   1192  CZ3 TRP A 161       9.249 112.372  23.518  1.00  5.71           C  
ATOM   1193  CH2 TRP A 161       9.226 112.286  24.924  1.00  4.10           C  
ATOM   1194  N   THR A 162       3.428 114.786  19.192  1.00  8.33           N  
ATOM   1195  CA  THR A 162       3.305 115.556  17.950  1.00  8.83           C  
ATOM   1196  C   THR A 162       1.881 115.945  17.565  1.00  9.39           C  
ATOM   1197  O   THR A 162       1.673 116.942  16.868  1.00  8.92           O  
ATOM   1198  CB  THR A 162       3.913 114.791  16.755  1.00 10.46           C  
ATOM   1199  OG1 THR A 162       3.142 113.609  16.495  1.00  9.96           O  
ATOM   1200  CG2 THR A 162       5.349 114.409  17.049  1.00  9.29           C  
ATOM   1201  N   GLY A 163       0.907 115.156  18.004  1.00  8.46           N  
ATOM   1202  CA  GLY A 163      -0.476 115.441  17.676  1.00  7.89           C  
ATOM   1203  C   GLY A 163      -0.820 115.123  16.230  1.00  9.59           C  
ATOM   1204  O   GLY A 163      -1.867 115.535  15.733  1.00  8.31           O  
ATOM   1205  N   ALA A 164       0.056 114.383  15.556  1.00  7.22           N  
ATOM   1206  CA  ALA A 164      -0.166 114.021  14.159  1.00  9.14           C  
ATOM   1207  C   ALA A 164      -1.327 113.046  14.008  1.00  7.41           C  
ATOM   1208  O   ALA A 164      -1.643 112.292  14.928  1.00  7.38           O  
ATOM   1209  CB  ALA A 164       1.102 113.412  13.570  1.00  8.97           C  
ATOM   1210  N   ARG A 165      -1.957 113.055  12.839  1.00  8.38           N  
ATOM   1211  CA  ARG A 165      -3.079 112.162  12.592  1.00  8.61           C  
ATOM   1212  C   ARG A 165      -2.648 110.813  12.037  1.00  9.66           C  
ATOM   1213  O   ARG A 165      -1.797 110.725  11.152  1.00  7.52           O  
ATOM   1214  CB  ARG A 165      -4.072 112.806  11.631  1.00 11.31           C  
ATOM   1215  CG  ARG A 165      -4.797 114.000  12.201  1.00 11.95           C  
ATOM   1216  CD  ARG A 165      -5.767 114.545  11.182  1.00 14.18           C  
ATOM   1217  NE  ARG A 165      -6.412 115.770  11.636  1.00 15.94           N  
ATOM   1218  CZ  ARG A 165      -7.262 116.473  10.898  1.00 16.34           C  
ATOM   1219  NH1 ARG A 165      -7.564 116.066   9.672  1.00 18.76           N  
ATOM   1220  NH2 ARG A 165      -7.800 117.583  11.380  1.00 19.09           N  
ATOM   1221  N   MET A 166      -3.268 109.766  12.565  1.00  9.38           N  
ATOM   1222  CA  MET A 166      -2.990 108.396  12.166  1.00 12.21           C  
ATOM   1223  C   MET A 166      -4.067 107.949  11.174  1.00 12.27           C  
ATOM   1224  O   MET A 166      -5.260 108.124  11.424  1.00 10.91           O  
ATOM   1225  CB  MET A 166      -3.009 107.515  13.419  1.00 12.40           C  
ATOM   1226  CG  MET A 166      -2.610 106.074  13.221  1.00 15.74           C  
ATOM   1227  SD  MET A 166      -2.940 105.163  14.739  1.00 15.66           S  
ATOM   1228  CE  MET A 166      -1.596 105.719  15.792  1.00 18.42           C  
ATOM   1229  N   SER A 167      -3.654 107.386  10.042  1.00 11.90           N  
ATOM   1230  CA  SER A 167      -4.626 106.929   9.052  1.00 15.08           C  
ATOM   1231  C   SER A 167      -5.279 105.640   9.544  1.00 11.86           C  
ATOM   1232  O   SER A 167      -4.749 104.962  10.422  1.00 15.42           O  
ATOM   1233  CB  SER A 167      -3.942 106.665   7.706  1.00 13.36           C  
ATOM   1234  OG  SER A 167      -3.019 105.600   7.817  1.00 17.43           O  
ATOM   1235  N   ALA A 168      -6.430 105.304   8.973  1.00 14.20           N  
ATOM   1236  CA  ALA A 168      -7.129 104.088   9.361  1.00 14.22           C  
ATOM   1237  C   ALA A 168      -6.245 102.871   9.108  1.00 15.02           C  
ATOM   1238  O   ALA A 168      -6.215 101.939   9.910  1.00 14.45           O  
ATOM   1239  CB  ALA A 168      -8.434 103.963   8.584  1.00 14.91           C  
ATOM   1240  N   LYS A 169      -5.515 102.887   7.995  1.00 15.65           N  
ATOM   1241  CA  LYS A 169      -4.643 101.770   7.652  1.00 17.53           C  
ATOM   1242  C   LYS A 169      -3.541 101.491   8.674  1.00 15.04           C  
ATOM   1243  O   LYS A 169      -3.304 100.336   9.021  1.00 18.80           O  
ATOM   1244  CB  LYS A 169      -4.021 101.982   6.267  1.00 20.85           C  
ATOM   1245  CG  LYS A 169      -3.118 100.838   5.812  1.00 25.10           C  
ATOM   1246  CD  LYS A 169      -3.825  99.483   5.900  1.00 31.66           C  
ATOM   1247  CE  LYS A 169      -5.094  99.443   5.057  1.00 33.88           C  
ATOM   1248  NZ  LYS A 169      -5.847  98.167   5.245  1.00 36.76           N  
ATOM   1249  N   GLU A 170      -2.859 102.524   9.161  1.00 17.67           N  
ATOM   1250  CA  GLU A 170      -1.804 102.273  10.134  1.00 16.97           C  
ATOM   1251  C   GLU A 170      -2.416 101.857  11.461  1.00 13.40           C  
ATOM   1252  O   GLU A 170      -1.830 101.069  12.199  1.00 14.73           O  
ATOM   1253  CB  GLU A 170      -0.915 103.499  10.349  1.00 19.06           C  
ATOM   1254  CG  GLU A 170       0.432 103.110  10.954  1.00 21.39           C  
ATOM   1255  CD  GLU A 170       1.319 104.294  11.265  1.00 20.57           C  
ATOM   1256  OE1 GLU A 170       1.243 105.304  10.537  1.00 19.10           O  
ATOM   1257  OE2 GLU A 170       2.107 104.203  12.233  1.00 22.55           O  
ATOM   1258  N   ALA A 171      -3.598 102.391  11.756  1.00 13.50           N  
ATOM   1259  CA  ALA A 171      -4.292 102.052  12.992  1.00 13.54           C  
ATOM   1260  C   ALA A 171      -4.607 100.559  12.985  1.00 12.74           C  
ATOM   1261  O   ALA A 171      -4.537  99.893  14.016  1.00 13.91           O  
ATOM   1262  CB  ALA A 171      -5.577 102.865  13.115  1.00 12.16           C  
ATOM   1263  N   GLU A 172      -4.952 100.036  11.812  1.00 14.95           N  
ATOM   1264  CA  GLU A 172      -5.260  98.618  11.683  1.00 16.40           C  
ATOM   1265  C   GLU A 172      -3.990  97.787  11.813  1.00 15.53           C  
ATOM   1266  O   GLU A 172      -3.988  96.745  12.462  1.00 16.34           O  
ATOM   1267  CB  GLU A 172      -5.920  98.323  10.335  1.00 17.51           C  
ATOM   1268  CG  GLU A 172      -6.149  96.835  10.106  1.00 17.76           C  
ATOM   1269  CD  GLU A 172      -6.743  96.533   8.749  1.00 22.40           C  
ATOM   1270  OE1 GLU A 172      -6.200  97.034   7.745  1.00 19.13           O  
ATOM   1271  OE2 GLU A 172      -7.748  95.790   8.690  1.00 24.03           O  
ATOM   1272  N   GLN A 173      -2.910  98.252  11.195  1.00 18.59           N  
ATOM   1273  CA  GLN A 173      -1.637  97.541  11.254  1.00 20.56           C  
ATOM   1274  C   GLN A 173      -1.121  97.481  12.691  1.00 20.91           C  
ATOM   1275  O   GLN A 173      -0.459  96.518  13.083  1.00 19.35           O  
ATOM   1276  CB  GLN A 173      -0.597  98.234  10.369  1.00 26.84           C  
ATOM   1277  CG  GLN A 173      -0.980  98.378   8.898  1.00 33.50           C  
ATOM   1278  CD  GLN A 173      -1.237  97.048   8.209  1.00 38.70           C  
ATOM   1279  OE1 GLN A 173      -2.372  96.566   8.162  1.00 41.59           O  
ATOM   1280  NE2 GLN A 173      -0.179  96.446   7.677  1.00 40.79           N  
ATOM   1281  N   LEU A 174      -1.431  98.513  13.472  1.00 18.60           N  
ATOM   1282  CA  LEU A 174      -1.000  98.585  14.864  1.00 16.24           C  
ATOM   1283  C   LEU A 174      -1.899  97.785  15.800  1.00 16.90           C  
ATOM   1284  O   LEU A 174      -1.577  97.605  16.975  1.00 19.00           O  
ATOM   1285  CB  LEU A 174      -0.941 100.047  15.324  1.00 18.43           C  
ATOM   1286  CG  LEU A 174       0.146 100.922  14.690  1.00 17.93           C  
ATOM   1287  CD1 LEU A 174      -0.051 102.372  15.104  1.00 19.16           C  
ATOM   1288  CD2 LEU A 174       1.521 100.424  15.115  1.00 18.25           C  
ATOM   1289  N   GLY A 175      -3.025  97.304  15.284  1.00 14.32           N  
ATOM   1290  CA  GLY A 175      -3.925  96.520  16.110  1.00 15.16           C  
ATOM   1291  C   GLY A 175      -4.945  97.343  16.873  1.00 13.77           C  
ATOM   1292  O   GLY A 175      -5.570  96.856  17.816  1.00 14.24           O  
ATOM   1293  N   ILE A 176      -5.100  98.603  16.476  1.00 11.06           N  
ATOM   1294  CA  ILE A 176      -6.066  99.487  17.115  1.00  8.19           C  
ATOM   1295  C   ILE A 176      -7.422  99.307  16.431  1.00  9.12           C  
ATOM   1296  O   ILE A 176      -8.459  99.227  17.094  1.00  9.28           O  
ATOM   1297  CB  ILE A 176      -5.633 100.960  16.995  1.00  6.62           C  
ATOM   1298  CG1 ILE A 176      -4.284 101.159  17.696  1.00  6.29           C  
ATOM   1299  CG2 ILE A 176      -6.702 101.867  17.597  1.00  5.73           C  
ATOM   1300  CD1 ILE A 176      -3.579 102.474  17.372  1.00 13.93           C  
ATOM   1301  N   VAL A 177      -7.397  99.249  15.102  1.00  7.67           N  
ATOM   1302  CA  VAL A 177      -8.604  99.068  14.299  1.00 10.67           C  
ATOM   1303  C   VAL A 177      -8.679  97.620  13.816  1.00 12.79           C  
ATOM   1304  O   VAL A 177      -7.677  97.045  13.386  1.00 14.42           O  
ATOM   1305  CB  VAL A 177      -8.615 100.024  13.082  1.00 11.09           C  
ATOM   1306  CG1 VAL A 177      -9.669  99.585  12.068  1.00 13.92           C  
ATOM   1307  CG2 VAL A 177      -8.912 101.449  13.549  1.00 11.28           C  
ATOM   1308  N   ASN A 178      -9.870  97.035  13.890  1.00 11.59           N  
ATOM   1309  CA  ASN A 178     -10.061  95.644  13.486  1.00 12.98           C  
ATOM   1310  C   ASN A 178     -10.151  95.447  11.974  1.00 14.33           C  
ATOM   1311  O   ASN A 178      -9.660  94.447  11.441  1.00 14.33           O  
ATOM   1312  CB  ASN A 178     -11.301  95.079  14.179  1.00 13.20           C  
ATOM   1313  CG  ASN A 178     -11.104  94.925  15.686  1.00 15.42           C  
ATOM   1314  OD1 ASN A 178     -10.497  93.959  16.152  1.00 16.29           O  
ATOM   1315  ND2 ASN A 178     -11.602  95.888  16.449  1.00 14.22           N  
ATOM   1316  N   ARG A 179     -10.781  96.390  11.282  1.00 13.09           N  
ATOM   1317  CA  ARG A 179     -10.900  96.308   9.832  1.00 17.91           C  
ATOM   1318  C   ARG A 179     -11.239  97.663   9.232  1.00 17.05           C  
ATOM   1319  O   ARG A 179     -11.829  98.524   9.892  1.00 15.07           O  
ATOM   1320  CB  ARG A 179     -11.968  95.287   9.427  1.00 26.12           C  
ATOM   1321  CG  ARG A 179     -13.395  95.730   9.680  1.00 34.04           C  
ATOM   1322  CD  ARG A 179     -14.389  94.728   9.111  1.00 43.02           C  
ATOM   1323  NE  ARG A 179     -14.151  94.458   7.695  1.00 50.84           N  
ATOM   1324  CZ  ARG A 179     -14.992  93.793   6.908  1.00 54.55           C  
ATOM   1325  NH1 ARG A 179     -16.134  93.329   7.397  1.00 56.00           N  
ATOM   1326  NH2 ARG A 179     -14.690  93.590   5.632  1.00 55.89           N  
ATOM   1327  N   VAL A 180     -10.861  97.843   7.971  1.00 14.55           N  
ATOM   1328  CA  VAL A 180     -11.103  99.087   7.259  1.00 14.66           C  
ATOM   1329  C   VAL A 180     -11.910  98.807   5.996  1.00 16.90           C  
ATOM   1330  O   VAL A 180     -11.625  97.857   5.265  1.00 16.20           O  
ATOM   1331  CB  VAL A 180      -9.769  99.757   6.858  1.00 15.76           C  
ATOM   1332  CG1 VAL A 180     -10.033 101.070   6.142  1.00 14.17           C  
ATOM   1333  CG2 VAL A 180      -8.909  99.976   8.096  1.00 17.22           C  
ATOM   1334  N   VAL A 181     -12.922  99.628   5.752  1.00 14.18           N  
ATOM   1335  CA  VAL A 181     -13.757  99.472   4.568  1.00 14.55           C  
ATOM   1336  C   VAL A 181     -14.073 100.836   3.973  1.00 14.62           C  
ATOM   1337  O   VAL A 181     -13.946 101.861   4.642  1.00 14.60           O  
ATOM   1338  CB  VAL A 181     -15.082  98.753   4.896  1.00 15.59           C  
ATOM   1339  CG1 VAL A 181     -14.801  97.315   5.313  1.00 14.47           C  
ATOM   1340  CG2 VAL A 181     -15.817  99.495   6.000  1.00 15.33           C  
ATOM   1341  N   SER A 182     -14.479 100.842   2.709  1.00 14.83           N  
ATOM   1342  CA  SER A 182     -14.815 102.083   2.028  1.00 15.33           C  
ATOM   1343  C   SER A 182     -15.969 102.767   2.759  1.00 14.97           C  
ATOM   1344  O   SER A 182     -16.814 102.106   3.362  1.00 14.79           O  
ATOM   1345  CB  SER A 182     -15.199 101.790   0.575  1.00 16.71           C  
ATOM   1346  OG  SER A 182     -15.314 102.987  -0.172  1.00 22.73           O  
ATOM   1347  N   PRO A 183     -16.018 104.108   2.716  1.00 15.62           N  
ATOM   1348  CA  PRO A 183     -17.065 104.895   3.378  1.00 15.79           C  
ATOM   1349  C   PRO A 183     -18.502 104.408   3.212  1.00 13.27           C  
ATOM   1350  O   PRO A 183     -19.232 104.276   4.196  1.00 14.05           O  
ATOM   1351  CB  PRO A 183     -16.863 106.290   2.790  1.00 16.27           C  
ATOM   1352  CG  PRO A 183     -15.383 106.346   2.613  1.00 15.45           C  
ATOM   1353  CD  PRO A 183     -15.062 104.993   2.024  1.00 17.37           C  
ATOM   1354  N   GLU A 184     -18.913 104.136   1.979  1.00 11.84           N  
ATOM   1355  CA  GLU A 184     -20.284 103.708   1.734  1.00 12.07           C  
ATOM   1356  C   GLU A 184     -20.614 102.290   2.197  1.00 10.13           C  
ATOM   1357  O   GLU A 184     -21.770 101.881   2.147  1.00 10.17           O  
ATOM   1358  CB  GLU A 184     -20.639 103.866   0.248  1.00 16.12           C  
ATOM   1359  CG  GLU A 184     -20.071 102.812  -0.694  1.00 18.54           C  
ATOM   1360  CD  GLU A 184     -18.558 102.814  -0.765  1.00 23.63           C  
ATOM   1361  OE1 GLU A 184     -17.943 103.885  -0.563  1.00 25.38           O  
ATOM   1362  OE2 GLU A 184     -17.982 101.742  -1.048  1.00 25.77           O  
ATOM   1363  N   LEU A 185     -19.608 101.552   2.658  1.00 10.02           N  
ATOM   1364  CA  LEU A 185     -19.822 100.183   3.125  1.00  9.62           C  
ATOM   1365  C   LEU A 185     -19.658 100.052   4.637  1.00  9.39           C  
ATOM   1366  O   LEU A 185     -19.947  99.001   5.206  1.00  8.50           O  
ATOM   1367  CB  LEU A 185     -18.835  99.229   2.445  1.00  9.86           C  
ATOM   1368  CG  LEU A 185     -18.920  99.083   0.926  1.00 10.74           C  
ATOM   1369  CD1 LEU A 185     -17.809  98.158   0.437  1.00 13.29           C  
ATOM   1370  CD2 LEU A 185     -20.283  98.536   0.547  1.00 14.10           C  
ATOM   1371  N   LEU A 186     -19.199 101.119   5.283  1.00 10.08           N  
ATOM   1372  CA  LEU A 186     -18.961 101.098   6.726  1.00  9.27           C  
ATOM   1373  C   LEU A 186     -20.115 100.587   7.592  1.00  8.60           C  
ATOM   1374  O   LEU A 186     -19.951  99.619   8.339  1.00  7.81           O  
ATOM   1375  CB  LEU A 186     -18.546 102.492   7.213  1.00  9.34           C  
ATOM   1376  CG  LEU A 186     -18.344 102.603   8.729  1.00 11.07           C  
ATOM   1377  CD1 LEU A 186     -17.246 101.640   9.170  1.00 10.67           C  
ATOM   1378  CD2 LEU A 186     -17.991 104.027   9.099  1.00 14.74           C  
ATOM   1379  N   MET A 187     -21.274 101.233   7.508  1.00  9.64           N  
ATOM   1380  CA  MET A 187     -22.412 100.815   8.325  1.00 10.40           C  
ATOM   1381  C   MET A 187     -22.896  99.416   7.984  1.00  9.81           C  
ATOM   1382  O   MET A 187     -23.204  98.624   8.876  1.00  9.38           O  
ATOM   1383  CB  MET A 187     -23.568 101.812   8.202  1.00 11.07           C  
ATOM   1384  CG  MET A 187     -23.304 103.138   8.901  1.00 16.41           C  
ATOM   1385  SD  MET A 187     -22.703 102.917  10.602  1.00 22.54           S  
ATOM   1386  CE  MET A 187     -24.156 102.268  11.401  1.00 20.27           C  
ATOM   1387  N   GLU A 188     -22.965  99.112   6.692  1.00  9.89           N  
ATOM   1388  CA  GLU A 188     -23.407  97.796   6.252  1.00 11.48           C  
ATOM   1389  C   GLU A 188     -22.502  96.721   6.844  1.00 11.13           C  
ATOM   1390  O   GLU A 188     -22.978  95.729   7.405  1.00  9.64           O  
ATOM   1391  CB  GLU A 188     -23.362  97.711   4.729  1.00 13.32           C  
ATOM   1392  CG  GLU A 188     -23.732  96.351   4.179  1.00 20.10           C  
ATOM   1393  CD  GLU A 188     -23.389  96.218   2.708  1.00 22.00           C  
ATOM   1394  OE1 GLU A 188     -23.794  97.101   1.926  1.00 24.24           O  
ATOM   1395  OE2 GLU A 188     -22.719  95.232   2.339  1.00 25.05           O  
ATOM   1396  N   GLU A 189     -21.194  96.920   6.716  1.00  9.78           N  
ATOM   1397  CA  GLU A 189     -20.232  95.958   7.240  1.00  9.38           C  
ATOM   1398  C   GLU A 189     -20.276  95.874   8.764  1.00  7.82           C  
ATOM   1399  O   GLU A 189     -20.218  94.783   9.328  1.00  7.16           O  
ATOM   1400  CB  GLU A 189     -18.816  96.316   6.782  1.00 12.56           C  
ATOM   1401  CG  GLU A 189     -18.584  96.126   5.287  1.00 19.33           C  
ATOM   1402  CD  GLU A 189     -18.768  94.683   4.847  1.00 24.00           C  
ATOM   1403  OE1 GLU A 189     -18.163  93.790   5.474  1.00 25.05           O  
ATOM   1404  OE2 GLU A 189     -19.513  94.441   3.872  1.00 24.60           O  
ATOM   1405  N   THR A 190     -20.373  97.022   9.426  1.00  5.10           N  
ATOM   1406  CA  THR A 190     -20.420  97.044  10.888  1.00  6.29           C  
ATOM   1407  C   THR A 190     -21.670  96.339  11.409  1.00  7.15           C  
ATOM   1408  O   THR A 190     -21.598  95.558  12.356  1.00  6.21           O  
ATOM   1409  CB  THR A 190     -20.400  98.487  11.439  1.00  8.27           C  
ATOM   1410  OG1 THR A 190     -19.221  99.159  10.980  1.00  9.46           O  
ATOM   1411  CG2 THR A 190     -20.393  98.472  12.964  1.00  9.59           C  
ATOM   1412  N   MET A 191     -22.814  96.612  10.790  1.00  7.36           N  
ATOM   1413  CA  MET A 191     -24.059  95.987  11.222  1.00  7.17           C  
ATOM   1414  C   MET A 191     -24.051  94.481  10.966  1.00  8.89           C  
ATOM   1415  O   MET A 191     -24.653  93.714  11.718  1.00  6.29           O  
ATOM   1416  CB  MET A 191     -25.254  96.636  10.522  1.00  7.50           C  
ATOM   1417  CG  MET A 191     -25.497  98.079  10.942  1.00  9.89           C  
ATOM   1418  SD  MET A 191     -25.720  98.255  12.733  1.00 11.39           S  
ATOM   1419  CE  MET A 191     -27.275  97.378  12.964  1.00 12.67           C  
ATOM   1420  N   ARG A 192     -23.375  94.058   9.905  1.00  8.50           N  
ATOM   1421  CA  ARG A 192     -23.295  92.636   9.607  1.00 10.88           C  
ATOM   1422  C   ARG A 192     -22.485  91.960  10.708  1.00  9.57           C  
ATOM   1423  O   ARG A 192     -22.852  90.892  11.200  1.00  7.61           O  
ATOM   1424  CB  ARG A 192     -22.627  92.407   8.251  1.00 13.54           C  
ATOM   1425  CG  ARG A 192     -22.505  90.946   7.868  1.00 21.67           C  
ATOM   1426  CD  ARG A 192     -22.203  90.792   6.386  1.00 24.57           C  
ATOM   1427  NE  ARG A 192     -23.246  91.395   5.562  1.00 26.64           N  
ATOM   1428  CZ  ARG A 192     -23.072  92.477   4.810  1.00 29.00           C  
ATOM   1429  NH1 ARG A 192     -21.893  93.081   4.775  1.00 26.07           N  
ATOM   1430  NH2 ARG A 192     -24.081  92.959   4.094  1.00 30.49           N  
ATOM   1431  N   LEU A 193     -21.383  92.595  11.096  1.00  6.87           N  
ATOM   1432  CA  LEU A 193     -20.523  92.069  12.150  1.00  7.46           C  
ATOM   1433  C   LEU A 193     -21.282  92.022  13.475  1.00  8.10           C  
ATOM   1434  O   LEU A 193     -21.245  91.016  14.189  1.00  8.52           O  
ATOM   1435  CB  LEU A 193     -19.275  92.945  12.304  1.00  7.23           C  
ATOM   1436  CG  LEU A 193     -18.373  92.634  13.502  1.00  9.46           C  
ATOM   1437  CD1 LEU A 193     -17.823  91.216  13.385  1.00  9.00           C  
ATOM   1438  CD2 LEU A 193     -17.240  93.650  13.561  1.00  9.64           C  
ATOM   1439  N   ALA A 194     -21.973  93.113  13.796  1.00  6.97           N  
ATOM   1440  CA  ALA A 194     -22.741  93.191  15.034  1.00  7.01           C  
ATOM   1441  C   ALA A 194     -23.831  92.125  15.025  1.00  6.93           C  
ATOM   1442  O   ALA A 194     -24.115  91.504  16.051  1.00  6.62           O  
ATOM   1443  CB  ALA A 194     -23.359  94.580  15.182  1.00  6.60           C  
ATOM   1444  N   GLY A 195     -24.435  91.922  13.856  1.00  7.80           N  
ATOM   1445  CA  GLY A 195     -25.477  90.922  13.717  1.00  7.73           C  
ATOM   1446  C   GLY A 195     -24.940  89.540  14.030  1.00  8.74           C  
ATOM   1447  O   GLY A 195     -25.596  88.749  14.715  1.00  9.18           O  
ATOM   1448  N   ARG A 196     -23.743  89.242  13.534  1.00  7.33           N  
ATOM   1449  CA  ARG A 196     -23.130  87.946  13.788  1.00  8.70           C  
ATOM   1450  C   ARG A 196     -22.826  87.778  15.274  1.00  9.04           C  
ATOM   1451  O   ARG A 196     -23.046  86.708  15.839  1.00  7.88           O  
ATOM   1452  CB  ARG A 196     -21.848  87.783  12.970  1.00 12.17           C  
ATOM   1453  CG  ARG A 196     -22.093  87.520  11.490  1.00 14.92           C  
ATOM   1454  CD  ARG A 196     -20.862  86.907  10.839  1.00 21.45           C  
ATOM   1455  NE  ARG A 196     -19.785  87.869  10.637  1.00 25.80           N  
ATOM   1456  CZ  ARG A 196     -19.665  88.641   9.559  1.00 29.73           C  
ATOM   1457  NH1 ARG A 196     -20.557  88.561   8.581  1.00 30.81           N  
ATOM   1458  NH2 ARG A 196     -18.652  89.489   9.456  1.00 32.83           N  
ATOM   1459  N   LEU A 197     -22.318  88.834  15.907  1.00  6.36           N  
ATOM   1460  CA  LEU A 197     -22.013  88.767  17.334  1.00  7.31           C  
ATOM   1461  C   LEU A 197     -23.306  88.606  18.138  1.00  7.55           C  
ATOM   1462  O   LEU A 197     -23.324  87.932  19.166  1.00  6.69           O  
ATOM   1463  CB  LEU A 197     -21.262  90.026  17.786  1.00  8.06           C  
ATOM   1464  CG  LEU A 197     -19.818  90.166  17.288  1.00 10.70           C  
ATOM   1465  CD1 LEU A 197     -19.279  91.544  17.637  1.00 10.31           C  
ATOM   1466  CD2 LEU A 197     -18.951  89.083  17.920  1.00 10.58           C  
ATOM   1467  N   ALA A 198     -24.389  89.213  17.660  1.00  6.07           N  
ATOM   1468  CA  ALA A 198     -25.676  89.114  18.344  1.00  9.39           C  
ATOM   1469  C   ALA A 198     -26.196  87.673  18.346  1.00  9.64           C  
ATOM   1470  O   ALA A 198     -27.078  87.328  19.131  1.00 11.49           O  
ATOM   1471  CB  ALA A 198     -26.697  90.038  17.682  1.00  8.93           C  
ATOM   1472  N   GLU A 199     -25.653  86.836  17.464  1.00  7.60           N  
ATOM   1473  CA  GLU A 199     -26.070  85.435  17.378  1.00  7.70           C  
ATOM   1474  C   GLU A 199     -25.262  84.540  18.314  1.00  7.67           C  
ATOM   1475  O   GLU A 199     -25.572  83.358  18.481  1.00  5.53           O  
ATOM   1476  CB  GLU A 199     -25.936  84.922  15.942  1.00 12.86           C  
ATOM   1477  CG  GLU A 199     -26.925  85.539  14.972  1.00 17.99           C  
ATOM   1478  CD  GLU A 199     -28.363  85.222  15.332  1.00 24.60           C  
ATOM   1479  OE1 GLU A 199     -28.745  84.032  15.273  1.00 26.27           O  
ATOM   1480  OE2 GLU A 199     -29.111  86.162  15.678  1.00 28.20           O  
ATOM   1481  N   GLN A 200     -24.220  85.105  18.915  1.00  5.26           N  
ATOM   1482  CA  GLN A 200     -23.371  84.367  19.844  1.00  6.30           C  
ATOM   1483  C   GLN A 200     -24.038  84.382  21.221  1.00  5.31           C  
ATOM   1484  O   GLN A 200     -25.001  85.120  21.434  1.00  6.91           O  
ATOM   1485  CB  GLN A 200     -21.990  85.028  19.922  1.00  5.84           C  
ATOM   1486  CG  GLN A 200     -21.180  84.933  18.631  1.00  7.89           C  
ATOM   1487  CD  GLN A 200     -20.850  83.498  18.261  1.00  7.30           C  
ATOM   1488  OE1 GLN A 200     -21.722  82.736  17.843  1.00  8.78           O  
ATOM   1489  NE2 GLN A 200     -19.587  83.121  18.423  1.00  6.81           N  
ATOM   1490  N   PRO A 201     -23.545  83.564  22.167  1.00  5.70           N  
ATOM   1491  CA  PRO A 201     -24.118  83.510  23.520  1.00  7.25           C  
ATOM   1492  C   PRO A 201     -23.858  84.831  24.243  1.00  4.29           C  
ATOM   1493  O   PRO A 201     -22.713  85.175  24.500  1.00  6.56           O  
ATOM   1494  CB  PRO A 201     -23.357  82.356  24.183  1.00  6.84           C  
ATOM   1495  CG  PRO A 201     -22.816  81.555  23.028  1.00  8.43           C  
ATOM   1496  CD  PRO A 201     -22.432  82.610  22.035  1.00  7.33           C  
ATOM   1497  N   PRO A 202     -24.919  85.583  24.586  1.00  4.61           N  
ATOM   1498  CA  PRO A 202     -24.736  86.867  25.277  1.00  4.30           C  
ATOM   1499  C   PRO A 202     -23.895  86.790  26.556  1.00  6.35           C  
ATOM   1500  O   PRO A 202     -23.042  87.651  26.799  1.00  6.48           O  
ATOM   1501  CB  PRO A 202     -26.172  87.318  25.550  1.00  6.17           C  
ATOM   1502  CG  PRO A 202     -26.934  86.732  24.388  1.00  6.72           C  
ATOM   1503  CD  PRO A 202     -26.344  85.332  24.311  1.00  2.82           C  
ATOM   1504  N   LEU A 203     -24.134  85.766  27.372  1.00  4.86           N  
ATOM   1505  CA  LEU A 203     -23.389  85.606  28.620  1.00  5.90           C  
ATOM   1506  C   LEU A 203     -21.925  85.291  28.332  1.00  5.45           C  
ATOM   1507  O   LEU A 203     -21.029  85.758  29.039  1.00  3.52           O  
ATOM   1508  CB  LEU A 203     -24.010  84.496  29.475  1.00  5.30           C  
ATOM   1509  CG  LEU A 203     -25.386  84.819  30.063  1.00  7.32           C  
ATOM   1510  CD1 LEU A 203     -26.088  83.532  30.475  1.00  9.28           C  
ATOM   1511  CD2 LEU A 203     -25.233  85.766  31.249  1.00  9.48           C  
ATOM   1512  N   ALA A 204     -21.681  84.504  27.289  1.00  5.44           N  
ATOM   1513  CA  ALA A 204     -20.313  84.165  26.924  1.00  5.78           C  
ATOM   1514  C   ALA A 204     -19.576  85.421  26.455  1.00  5.28           C  
ATOM   1515  O   ALA A 204     -18.445  85.663  26.873  1.00  4.85           O  
ATOM   1516  CB  ALA A 204     -20.300  83.091  25.829  1.00  5.51           C  
ATOM   1517  N   LEU A 205     -20.201  86.231  25.600  1.00  4.54           N  
ATOM   1518  CA  LEU A 205     -19.531  87.447  25.133  1.00  4.50           C  
ATOM   1519  C   LEU A 205     -19.261  88.403  26.299  1.00  5.11           C  
ATOM   1520  O   LEU A 205     -18.202  89.027  26.378  1.00  4.80           O  
ATOM   1521  CB  LEU A 205     -20.369  88.171  24.072  1.00  4.50           C  
ATOM   1522  CG  LEU A 205     -20.674  87.442  22.760  1.00  4.76           C  
ATOM   1523  CD1 LEU A 205     -21.087  88.468  21.705  1.00  4.52           C  
ATOM   1524  CD2 LEU A 205     -19.457  86.669  22.286  1.00  4.93           C  
ATOM   1525  N   ARG A 206     -20.226  88.497  27.207  1.00  3.78           N  
ATOM   1526  CA  ARG A 206     -20.137  89.365  28.375  1.00  5.96           C  
ATOM   1527  C   ARG A 206     -18.998  88.961  29.310  1.00  7.48           C  
ATOM   1528  O   ARG A 206     -18.172  89.794  29.692  1.00  4.29           O  
ATOM   1529  CB  ARG A 206     -21.466  89.323  29.132  1.00  6.32           C  
ATOM   1530  CG  ARG A 206     -21.563  90.168  30.402  1.00  7.47           C  
ATOM   1531  CD  ARG A 206     -22.834  89.756  31.144  1.00  9.19           C  
ATOM   1532  NE  ARG A 206     -23.122  90.506  32.365  1.00  7.23           N  
ATOM   1533  CZ  ARG A 206     -23.716  91.695  32.396  1.00  8.77           C  
ATOM   1534  NH1 ARG A 206     -24.082  92.289  31.268  1.00  7.66           N  
ATOM   1535  NH2 ARG A 206     -23.991  92.269  33.564  1.00  8.91           N  
ATOM   1536  N   LEU A 207     -18.955  87.684  29.675  1.00  5.86           N  
ATOM   1537  CA  LEU A 207     -17.921  87.195  30.581  1.00  5.93           C  
ATOM   1538  C   LEU A 207     -16.537  87.117  29.940  1.00  5.51           C  
ATOM   1539  O   LEU A 207     -15.522  87.226  30.630  1.00  3.90           O  
ATOM   1540  CB  LEU A 207     -18.336  85.843  31.172  1.00  5.67           C  
ATOM   1541  CG  LEU A 207     -19.226  85.968  32.424  1.00  8.61           C  
ATOM   1542  CD1 LEU A 207     -20.410  86.889  32.140  1.00  8.18           C  
ATOM   1543  CD2 LEU A 207     -19.706  84.592  32.866  1.00  7.42           C  
ATOM   1544  N   ILE A 208     -16.490  86.923  28.625  1.00  3.78           N  
ATOM   1545  CA  ILE A 208     -15.206  86.888  27.929  1.00  6.27           C  
ATOM   1546  C   ILE A 208     -14.637  88.303  27.972  1.00  6.18           C  
ATOM   1547  O   ILE A 208     -13.445  88.508  28.226  1.00  3.65           O  
ATOM   1548  CB  ILE A 208     -15.361  86.455  26.442  1.00  6.67           C  
ATOM   1549  CG1 ILE A 208     -15.470  84.930  26.350  1.00 10.65           C  
ATOM   1550  CG2 ILE A 208     -14.179  86.976  25.623  1.00  4.96           C  
ATOM   1551  CD1 ILE A 208     -14.266  84.097  26.866  1.00 13.93           C  
ATOM   1552  N   LYS A 209     -15.503  89.278  27.714  1.00  6.21           N  
ATOM   1553  CA  LYS A 209     -15.099  90.674  27.728  1.00  5.59           C  
ATOM   1554  C   LYS A 209     -14.563  91.052  29.110  1.00  6.04           C  
ATOM   1555  O   LYS A 209     -13.547  91.741  29.216  1.00  5.48           O  
ATOM   1556  CB  LYS A 209     -16.284  91.568  27.346  1.00  6.35           C  
ATOM   1557  CG  LYS A 209     -15.997  93.057  27.462  1.00  8.82           C  
ATOM   1558  CD  LYS A 209     -17.146  93.894  26.910  1.00  5.45           C  
ATOM   1559  CE  LYS A 209     -16.961  95.356  27.274  1.00  9.14           C  
ATOM   1560  NZ  LYS A 209     -17.987  96.234  26.636  1.00  6.33           N  
ATOM   1561  N   GLU A 210     -15.239  90.605  30.167  1.00  4.34           N  
ATOM   1562  CA  GLU A 210     -14.787  90.912  31.523  1.00  6.10           C  
ATOM   1563  C   GLU A 210     -13.397  90.338  31.755  1.00  4.61           C  
ATOM   1564  O   GLU A 210     -12.532  90.995  32.335  1.00  6.18           O  
ATOM   1565  CB  GLU A 210     -15.726  90.320  32.575  1.00  7.71           C  
ATOM   1566  CG  GLU A 210     -17.127  90.875  32.583  1.00 12.01           C  
ATOM   1567  CD  GLU A 210     -17.919  90.357  33.768  1.00 18.01           C  
ATOM   1568  OE1 GLU A 210     -17.776  89.157  34.090  1.00 17.20           O  
ATOM   1569  OE2 GLU A 210     -18.679  91.141  34.373  1.00 20.55           O  
ATOM   1570  N   ALA A 211     -13.193  89.102  31.311  1.00  6.32           N  
ATOM   1571  CA  ALA A 211     -11.902  88.444  31.478  1.00  6.05           C  
ATOM   1572  C   ALA A 211     -10.816  89.203  30.720  1.00  7.15           C  
ATOM   1573  O   ALA A 211      -9.719  89.406  31.234  1.00  5.63           O  
ATOM   1574  CB  ALA A 211     -11.981  87.000  30.985  1.00  6.34           C  
ATOM   1575  N   VAL A 212     -11.126  89.627  29.497  1.00  5.43           N  
ATOM   1576  CA  VAL A 212     -10.159  90.366  28.699  1.00  6.04           C  
ATOM   1577  C   VAL A 212      -9.810  91.694  29.368  1.00  8.09           C  
ATOM   1578  O   VAL A 212      -8.663  92.136  29.319  1.00  8.57           O  
ATOM   1579  CB  VAL A 212     -10.693  90.624  27.270  1.00  2.66           C  
ATOM   1580  CG1 VAL A 212      -9.777  91.589  26.528  1.00  5.71           C  
ATOM   1581  CG2 VAL A 212     -10.781  89.307  26.518  1.00  3.70           C  
ATOM   1582  N   GLN A 213     -10.795  92.324  30.004  1.00 10.14           N  
ATOM   1583  CA  GLN A 213     -10.560  93.594  30.682  1.00 12.98           C  
ATOM   1584  C   GLN A 213      -9.521  93.385  31.787  1.00 13.10           C  
ATOM   1585  O   GLN A 213      -8.652  94.228  31.999  1.00 14.67           O  
ATOM   1586  CB  GLN A 213     -11.852  94.138  31.306  1.00 16.70           C  
ATOM   1587  CG  GLN A 213     -13.078  94.187  30.393  1.00 24.31           C  
ATOM   1588  CD  GLN A 213     -12.845  94.922  29.082  1.00 25.24           C  
ATOM   1589  OE1 GLN A 213     -12.383  94.336  28.099  1.00 23.43           O  
ATOM   1590  NE2 GLN A 213     -13.166  96.213  29.062  1.00 24.58           N  
ATOM   1591  N   LYS A 214      -9.615  92.258  32.488  1.00 12.74           N  
ATOM   1592  CA  LYS A 214      -8.674  91.951  33.561  1.00 12.06           C  
ATOM   1593  C   LYS A 214      -7.295  91.620  32.984  1.00 11.81           C  
ATOM   1594  O   LYS A 214      -6.272  91.975  33.566  1.00 11.70           O  
ATOM   1595  CB  LYS A 214      -9.172  90.763  34.395  1.00 13.32           C  
ATOM   1596  CG  LYS A 214     -10.632  90.855  34.847  1.00 13.91           C  
ATOM   1597  CD  LYS A 214     -10.919  92.141  35.609  1.00 15.79           C  
ATOM   1598  CE  LYS A 214     -12.360  92.179  36.108  1.00 14.82           C  
ATOM   1599  NZ  LYS A 214     -12.712  93.512  36.672  1.00 16.97           N  
ATOM   1600  N   ALA A 215      -7.276  90.945  31.835  1.00  8.14           N  
ATOM   1601  CA  ALA A 215      -6.024  90.558  31.185  1.00  8.69           C  
ATOM   1602  C   ALA A 215      -5.147  91.758  30.858  1.00  9.58           C  
ATOM   1603  O   ALA A 215      -3.922  91.655  30.827  1.00  9.66           O  
ATOM   1604  CB  ALA A 215      -6.316  89.769  29.914  1.00  6.55           C  
ATOM   1605  N   VAL A 216      -5.782  92.895  30.602  1.00  9.68           N  
ATOM   1606  CA  VAL A 216      -5.056  94.117  30.278  1.00 12.83           C  
ATOM   1607  C   VAL A 216      -4.331  94.689  31.498  1.00 15.22           C  
ATOM   1608  O   VAL A 216      -3.263  95.288  31.364  1.00 18.10           O  
ATOM   1609  CB  VAL A 216      -6.019  95.200  29.719  1.00 13.24           C  
ATOM   1610  CG1 VAL A 216      -5.283  96.516  29.534  1.00 16.34           C  
ATOM   1611  CG2 VAL A 216      -6.604  94.740  28.387  1.00 14.50           C  
ATOM   1612  N   ASP A 217      -4.901  94.490  32.683  1.00 15.98           N  
ATOM   1613  CA  ASP A 217      -4.320  95.028  33.915  1.00 20.05           C  
ATOM   1614  C   ASP A 217      -3.693  93.997  34.865  1.00 21.27           C  
ATOM   1615  O   ASP A 217      -2.569  94.174  35.340  1.00 23.76           O  
ATOM   1616  CB  ASP A 217      -5.392  95.813  34.685  1.00 21.38           C  
ATOM   1617  CG  ASP A 217      -6.091  96.859  33.826  1.00 21.90           C  
ATOM   1618  OD1 ASP A 217      -5.398  97.582  33.082  1.00 20.56           O  
ATOM   1619  OD2 ASP A 217      -7.336  96.966  33.906  1.00 23.24           O  
ATOM   1620  N   TYR A 218      -4.440  92.934  35.136  1.00 18.89           N  
ATOM   1621  CA  TYR A 218      -4.047  91.858  36.050  1.00 18.45           C  
ATOM   1622  C   TYR A 218      -2.796  91.047  35.743  1.00 13.97           C  
ATOM   1623  O   TYR A 218      -2.454  90.818  34.585  1.00 12.40           O  
ATOM   1624  CB  TYR A 218      -5.167  90.822  36.148  1.00 20.53           C  
ATOM   1625  CG  TYR A 218      -6.371  91.159  36.987  1.00 21.57           C  
ATOM   1626  CD1 TYR A 218      -6.983  92.409  36.916  1.00 23.16           C  
ATOM   1627  CD2 TYR A 218      -6.965  90.176  37.778  1.00 21.21           C  
ATOM   1628  CE1 TYR A 218      -8.165  92.666  37.611  1.00 21.69           C  
ATOM   1629  CE2 TYR A 218      -8.140  90.420  38.472  1.00 22.54           C  
ATOM   1630  CZ  TYR A 218      -8.738  91.662  38.382  1.00 21.91           C  
ATOM   1631  OH  TYR A 218      -9.918  91.877  39.053  1.00 23.13           O  
ATOM   1632  N   PRO A 219      -2.098  90.597  36.797  1.00 12.44           N  
ATOM   1633  CA  PRO A 219      -0.902  89.776  36.590  1.00 13.15           C  
ATOM   1634  C   PRO A 219      -1.521  88.467  36.083  1.00 11.91           C  
ATOM   1635  O   PRO A 219      -2.638  88.125  36.479  1.00  9.91           O  
ATOM   1636  CB  PRO A 219      -0.342  89.625  38.001  1.00 13.68           C  
ATOM   1637  CG  PRO A 219      -0.725  90.912  38.648  1.00 16.71           C  
ATOM   1638  CD  PRO A 219      -2.152  91.102  38.180  1.00 13.50           C  
ATOM   1639  N   LEU A 220      -0.817  87.741  35.223  1.00 10.15           N  
ATOM   1640  CA  LEU A 220      -1.347  86.501  34.654  1.00 12.18           C  
ATOM   1641  C   LEU A 220      -2.065  85.545  35.608  1.00 10.92           C  
ATOM   1642  O   LEU A 220      -3.222  85.187  35.378  1.00  8.17           O  
ATOM   1643  CB  LEU A 220      -0.234  85.737  33.932  1.00 12.25           C  
ATOM   1644  CG  LEU A 220      -0.638  84.407  33.290  1.00 13.96           C  
ATOM   1645  CD1 LEU A 220      -1.696  84.649  32.220  1.00 14.52           C  
ATOM   1646  CD2 LEU A 220       0.590  83.742  32.683  1.00 14.50           C  
ATOM   1647  N   TYR A 221      -1.384  85.124  36.670  1.00  9.59           N  
ATOM   1648  CA  TYR A 221      -1.974  84.183  37.617  1.00 11.93           C  
ATOM   1649  C   TYR A 221      -3.336  84.622  38.147  1.00 11.89           C  
ATOM   1650  O   TYR A 221      -4.276  83.828  38.184  1.00 10.16           O  
ATOM   1651  CB  TYR A 221      -1.029  83.946  38.798  1.00 15.00           C  
ATOM   1652  CG  TYR A 221      -1.505  82.856  39.735  1.00 17.92           C  
ATOM   1653  CD1 TYR A 221      -1.400  81.512  39.382  1.00 19.05           C  
ATOM   1654  CD2 TYR A 221      -2.077  83.171  40.966  1.00 20.01           C  
ATOM   1655  CE1 TYR A 221      -1.854  80.507  40.232  1.00 21.38           C  
ATOM   1656  CE2 TYR A 221      -2.536  82.176  41.824  1.00 21.51           C  
ATOM   1657  CZ  TYR A 221      -2.421  80.845  41.452  1.00 22.27           C  
ATOM   1658  OH  TYR A 221      -2.867  79.856  42.301  1.00 23.38           O  
ATOM   1659  N   GLU A 222      -3.444  85.879  38.562  1.00 10.05           N  
ATOM   1660  CA  GLU A 222      -4.706  86.384  39.090  1.00 10.66           C  
ATOM   1661  C   GLU A 222      -5.748  86.612  37.992  1.00  8.66           C  
ATOM   1662  O   GLU A 222      -6.951  86.532  38.241  1.00  7.77           O  
ATOM   1663  CB  GLU A 222      -4.471  87.666  39.891  1.00 14.13           C  
ATOM   1664  CG  GLU A 222      -3.642  87.466  41.171  1.00 16.60           C  
ATOM   1665  CD  GLU A 222      -4.195  86.373  42.091  1.00 17.93           C  
ATOM   1666  OE1 GLU A 222      -5.432  86.214  42.167  1.00 17.43           O  
ATOM   1667  OE2 GLU A 222      -3.392  85.680  42.754  1.00 18.87           O  
ATOM   1668  N   GLY A 223      -5.287  86.886  36.775  1.00  7.40           N  
ATOM   1669  CA  GLY A 223      -6.212  87.078  35.671  1.00  6.22           C  
ATOM   1670  C   GLY A 223      -6.866  85.741  35.366  1.00  5.16           C  
ATOM   1671  O   GLY A 223      -8.055  85.666  35.050  1.00  4.18           O  
ATOM   1672  N   MET A 224      -6.078  84.676  35.468  1.00  3.94           N  
ATOM   1673  CA  MET A 224      -6.580  83.329  35.223  1.00  5.57           C  
ATOM   1674  C   MET A 224      -7.508  82.892  36.359  1.00  6.44           C  
ATOM   1675  O   MET A 224      -8.457  82.139  36.138  1.00  5.84           O  
ATOM   1676  CB  MET A 224      -5.404  82.355  35.063  1.00  5.83           C  
ATOM   1677  CG  MET A 224      -4.696  82.515  33.712  1.00  5.60           C  
ATOM   1678  SD  MET A 224      -3.217  81.502  33.505  1.00  9.21           S  
ATOM   1679  CE  MET A 224      -3.950  79.875  33.472  1.00  7.26           C  
ATOM   1680  N   GLN A 225      -7.234  83.372  37.569  1.00  7.54           N  
ATOM   1681  CA  GLN A 225      -8.073  83.056  38.726  1.00  6.68           C  
ATOM   1682  C   GLN A 225      -9.479  83.602  38.490  1.00  7.59           C  
ATOM   1683  O   GLN A 225     -10.474  82.955  38.817  1.00  8.06           O  
ATOM   1684  CB  GLN A 225      -7.496  83.688  39.997  1.00  8.82           C  
ATOM   1685  CG  GLN A 225      -6.370  82.902  40.638  1.00 11.79           C  
ATOM   1686  CD  GLN A 225      -6.880  81.667  41.358  1.00 19.76           C  
ATOM   1687  OE1 GLN A 225      -7.570  81.764  42.381  1.00 22.37           O  
ATOM   1688  NE2 GLN A 225      -6.553  80.499  40.823  1.00 16.12           N  
ATOM   1689  N   PHE A 226      -9.551  84.804  37.925  1.00  6.91           N  
ATOM   1690  CA  PHE A 226     -10.834  85.442  37.644  1.00  7.05           C  
ATOM   1691  C   PHE A 226     -11.487  84.746  36.453  1.00  4.93           C  
ATOM   1692  O   PHE A 226     -12.676  84.435  36.469  1.00  5.80           O  
ATOM   1693  CB  PHE A 226     -10.624  86.925  37.323  1.00  7.70           C  
ATOM   1694  CG  PHE A 226     -11.903  87.688  37.107  1.00 12.45           C  
ATOM   1695  CD1 PHE A 226     -12.547  88.313  38.172  1.00 15.93           C  
ATOM   1696  CD2 PHE A 226     -12.474  87.764  35.842  1.00 11.79           C  
ATOM   1697  CE1 PHE A 226     -13.748  89.006  37.976  1.00 14.31           C  
ATOM   1698  CE2 PHE A 226     -13.672  88.450  35.635  1.00 16.41           C  
ATOM   1699  CZ  PHE A 226     -14.309  89.071  36.704  1.00 14.69           C  
ATOM   1700  N   GLU A 227     -10.691  84.509  35.418  1.00  4.31           N  
ATOM   1701  CA  GLU A 227     -11.162  83.859  34.202  1.00  5.14           C  
ATOM   1702  C   GLU A 227     -11.929  82.562  34.477  1.00  5.29           C  
ATOM   1703  O   GLU A 227     -13.045  82.373  33.980  1.00  4.87           O  
ATOM   1704  CB  GLU A 227      -9.964  83.568  33.300  1.00  5.20           C  
ATOM   1705  CG  GLU A 227     -10.295  82.894  31.983  1.00  5.26           C  
ATOM   1706  CD  GLU A 227      -9.045  82.353  31.321  1.00  9.64           C  
ATOM   1707  OE1 GLU A 227      -8.403  81.480  31.936  1.00 10.07           O  
ATOM   1708  OE2 GLU A 227      -8.699  82.799  30.204  1.00  7.46           O  
ATOM   1709  N   ARG A 228     -11.341  81.672  35.270  1.00  3.64           N  
ATOM   1710  CA  ARG A 228     -11.989  80.396  35.564  1.00  5.37           C  
ATOM   1711  C   ARG A 228     -13.295  80.530  36.348  1.00  5.68           C  
ATOM   1712  O   ARG A 228     -14.166  79.662  36.247  1.00  7.05           O  
ATOM   1713  CB  ARG A 228     -11.015  79.451  36.284  1.00  7.66           C  
ATOM   1714  CG  ARG A 228     -10.557  79.895  37.660  1.00  5.42           C  
ATOM   1715  CD  ARG A 228      -9.344  79.087  38.113  1.00  3.23           C  
ATOM   1716  NE  ARG A 228      -8.211  79.280  37.211  1.00  5.28           N  
ATOM   1717  CZ  ARG A 228      -6.979  78.827  37.431  1.00  6.28           C  
ATOM   1718  NH1 ARG A 228      -6.703  78.142  38.537  1.00  6.30           N  
ATOM   1719  NH2 ARG A 228      -6.022  79.055  36.540  1.00  6.08           N  
ATOM   1720  N   LYS A 229     -13.440  81.599  37.130  1.00  5.91           N  
ATOM   1721  CA  LYS A 229     -14.678  81.805  37.875  1.00  5.28           C  
ATOM   1722  C   LYS A 229     -15.797  82.067  36.868  1.00  5.27           C  
ATOM   1723  O   LYS A 229     -16.916  81.570  37.022  1.00  3.74           O  
ATOM   1724  CB  LYS A 229     -14.551  82.988  38.846  1.00  6.89           C  
ATOM   1725  CG  LYS A 229     -13.716  82.681  40.081  1.00  9.20           C  
ATOM   1726  CD  LYS A 229     -14.388  81.619  40.947  1.00  9.20           C  
ATOM   1727  CE  LYS A 229     -13.507  81.213  42.117  1.00 11.72           C  
ATOM   1728  NZ  LYS A 229     -14.229  80.353  43.085  1.00 10.21           N  
ATOM   1729  N   ASN A 230     -15.493  82.851  35.835  1.00  4.21           N  
ATOM   1730  CA  ASN A 230     -16.479  83.135  34.797  1.00  5.59           C  
ATOM   1731  C   ASN A 230     -16.765  81.851  34.021  1.00  4.18           C  
ATOM   1732  O   ASN A 230     -17.895  81.616  33.595  1.00  4.65           O  
ATOM   1733  CB  ASN A 230     -15.990  84.249  33.859  1.00  3.56           C  
ATOM   1734  CG  ASN A 230     -16.365  85.639  34.364  1.00  5.89           C  
ATOM   1735  OD1 ASN A 230     -16.987  85.774  35.419  1.00  6.89           O  
ATOM   1736  ND2 ASN A 230     -15.997  86.675  33.609  1.00  4.31           N  
ATOM   1737  N   PHE A 231     -15.740  81.022  33.844  1.00  3.84           N  
ATOM   1738  CA  PHE A 231     -15.905  79.742  33.154  1.00  3.45           C  
ATOM   1739  C   PHE A 231     -16.927  78.906  33.940  1.00  5.42           C  
ATOM   1740  O   PHE A 231     -17.859  78.338  33.367  1.00  5.03           O  
ATOM   1741  CB  PHE A 231     -14.565  78.996  33.105  1.00  3.78           C  
ATOM   1742  CG  PHE A 231     -14.623  77.676  32.374  1.00  6.93           C  
ATOM   1743  CD1 PHE A 231     -14.512  77.625  30.989  1.00  7.85           C  
ATOM   1744  CD2 PHE A 231     -14.781  76.482  33.077  1.00  6.91           C  
ATOM   1745  CE1 PHE A 231     -14.556  76.405  30.310  1.00  7.92           C  
ATOM   1746  CE2 PHE A 231     -14.826  75.257  32.408  1.00  7.40           C  
ATOM   1747  CZ  PHE A 231     -14.712  75.220  31.021  1.00  7.36           C  
ATOM   1748  N   TYR A 232     -16.748  78.833  35.258  1.00  4.95           N  
ATOM   1749  CA  TYR A 232     -17.668  78.069  36.101  1.00  5.40           C  
ATOM   1750  C   TYR A 232     -19.092  78.588  35.959  1.00  4.95           C  
ATOM   1751  O   TYR A 232     -20.042  77.811  35.826  1.00  4.30           O  
ATOM   1752  CB  TYR A 232     -17.295  78.175  37.586  1.00  3.09           C  
ATOM   1753  CG  TYR A 232     -15.953  77.608  37.995  1.00  6.65           C  
ATOM   1754  CD1 TYR A 232     -15.188  76.833  37.119  1.00  8.00           C  
ATOM   1755  CD2 TYR A 232     -15.461  77.827  39.281  1.00  7.16           C  
ATOM   1756  CE1 TYR A 232     -13.961  76.289  37.522  1.00  5.79           C  
ATOM   1757  CE2 TYR A 232     -14.242  77.290  39.693  1.00  6.95           C  
ATOM   1758  CZ  TYR A 232     -13.498  76.524  38.810  1.00  9.63           C  
ATOM   1759  OH  TYR A 232     -12.294  75.995  39.227  1.00  8.98           O  
ATOM   1760  N   LEU A 233     -19.230  79.911  36.005  1.00  2.70           N  
ATOM   1761  CA  LEU A 233     -20.535  80.556  35.918  1.00  5.04           C  
ATOM   1762  C   LEU A 233     -21.298  80.265  34.638  1.00  4.68           C  
ATOM   1763  O   LEU A 233     -22.524  80.143  34.660  1.00  6.36           O  
ATOM   1764  CB  LEU A 233     -20.388  82.071  36.099  1.00  4.49           C  
ATOM   1765  CG  LEU A 233     -20.184  82.522  37.550  1.00  6.91           C  
ATOM   1766  CD1 LEU A 233     -19.835  84.009  37.598  1.00  8.10           C  
ATOM   1767  CD2 LEU A 233     -21.452  82.237  38.349  1.00  7.22           C  
ATOM   1768  N   LEU A 234     -20.589  80.150  33.520  1.00  4.39           N  
ATOM   1769  CA  LEU A 234     -21.267  79.870  32.262  1.00  5.29           C  
ATOM   1770  C   LEU A 234     -21.943  78.501  32.268  1.00  5.52           C  
ATOM   1771  O   LEU A 234     -22.877  78.268  31.503  1.00  7.55           O  
ATOM   1772  CB  LEU A 234     -20.293  80.000  31.084  1.00  4.82           C  
ATOM   1773  CG  LEU A 234     -19.877  81.447  30.781  1.00  5.09           C  
ATOM   1774  CD1 LEU A 234     -18.880  81.467  29.632  1.00  8.03           C  
ATOM   1775  CD2 LEU A 234     -21.107  82.285  30.420  1.00  6.50           C  
ATOM   1776  N   PHE A 235     -21.496  77.601  33.142  1.00  6.30           N  
ATOM   1777  CA  PHE A 235     -22.119  76.285  33.215  1.00  6.46           C  
ATOM   1778  C   PHE A 235     -23.409  76.298  34.028  1.00  8.02           C  
ATOM   1779  O   PHE A 235     -24.009  75.257  34.289  1.00  8.79           O  
ATOM   1780  CB  PHE A 235     -21.134  75.242  33.756  1.00  7.81           C  
ATOM   1781  CG  PHE A 235     -20.156  74.768  32.719  1.00  6.86           C  
ATOM   1782  CD1 PHE A 235     -19.070  75.560  32.358  1.00  7.07           C  
ATOM   1783  CD2 PHE A 235     -20.372  73.577  32.035  1.00  6.69           C  
ATOM   1784  CE1 PHE A 235     -18.215  75.176  31.325  1.00  7.27           C  
ATOM   1785  CE2 PHE A 235     -19.524  73.181  30.997  1.00  9.18           C  
ATOM   1786  CZ  PHE A 235     -18.445  73.985  30.642  1.00  8.01           C  
ATOM   1787  N   ALA A 236     -23.833  77.495  34.424  1.00  7.96           N  
ATOM   1788  CA  ALA A 236     -25.079  77.654  35.160  1.00  8.68           C  
ATOM   1789  C   ALA A 236     -26.117  78.154  34.162  1.00  8.99           C  
ATOM   1790  O   ALA A 236     -27.301  78.266  34.484  1.00 10.34           O  
ATOM   1791  CB  ALA A 236     -24.909  78.669  36.282  1.00  7.48           C  
ATOM   1792  N   SER A 237     -25.668  78.443  32.942  1.00  6.98           N  
ATOM   1793  CA  SER A 237     -26.569  78.959  31.916  1.00  7.75           C  
ATOM   1794  C   SER A 237     -27.219  77.879  31.067  1.00  5.68           C  
ATOM   1795  O   SER A 237     -26.646  76.808  30.835  1.00  5.52           O  
ATOM   1796  CB  SER A 237     -25.829  79.935  30.991  1.00  6.07           C  
ATOM   1797  OG  SER A 237     -24.920  79.259  30.134  1.00  6.59           O  
ATOM   1798  N   GLU A 238     -28.431  78.169  30.611  1.00  4.90           N  
ATOM   1799  CA  GLU A 238     -29.152  77.247  29.750  1.00  7.76           C  
ATOM   1800  C   GLU A 238     -28.468  77.279  28.386  1.00  5.34           C  
ATOM   1801  O   GLU A 238     -28.453  76.280  27.668  1.00  5.96           O  
ATOM   1802  CB  GLU A 238     -30.618  77.676  29.629  1.00  9.20           C  
ATOM   1803  CG  GLU A 238     -31.385  77.546  30.940  1.00 16.65           C  
ATOM   1804  CD  GLU A 238     -32.762  78.175  30.884  1.00 25.60           C  
ATOM   1805  OE1 GLU A 238     -33.528  77.849  29.952  1.00 29.33           O  
ATOM   1806  OE2 GLU A 238     -33.077  78.993  31.775  1.00 30.30           O  
ATOM   1807  N   ASP A 239     -27.883  78.426  28.043  1.00  5.57           N  
ATOM   1808  CA  ASP A 239     -27.193  78.567  26.762  1.00  6.95           C  
ATOM   1809  C   ASP A 239     -26.024  77.593  26.640  1.00  6.70           C  
ATOM   1810  O   ASP A 239     -25.693  77.150  25.540  1.00  8.96           O  
ATOM   1811  CB  ASP A 239     -26.684  80.002  26.566  1.00  4.95           C  
ATOM   1812  CG  ASP A 239     -27.763  80.941  26.054  1.00  4.91           C  
ATOM   1813  OD1 ASP A 239     -28.853  80.458  25.681  1.00  6.66           O  
ATOM   1814  OD2 ASP A 239     -27.517  82.165  26.010  1.00  6.82           O  
ATOM   1815  N   GLN A 240     -25.386  77.266  27.760  1.00  6.06           N  
ATOM   1816  CA  GLN A 240     -24.276  76.322  27.719  1.00  6.43           C  
ATOM   1817  C   GLN A 240     -24.823  74.950  27.324  1.00  6.24           C  
ATOM   1818  O   GLN A 240     -24.223  74.237  26.520  1.00  7.28           O  
ATOM   1819  CB  GLN A 240     -23.580  76.262  29.081  1.00  6.72           C  
ATOM   1820  CG  GLN A 240     -22.636  75.086  29.262  1.00  7.80           C  
ATOM   1821  CD  GLN A 240     -23.310  73.924  29.960  1.00  9.81           C  
ATOM   1822  OE1 GLN A 240     -23.895  74.093  31.027  1.00 10.48           O  
ATOM   1823  NE2 GLN A 240     -23.224  72.737  29.369  1.00  9.90           N  
ATOM   1824  N   LYS A 241     -25.966  74.585  27.892  1.00  6.38           N  
ATOM   1825  CA  LYS A 241     -26.591  73.309  27.560  1.00  6.60           C  
ATOM   1826  C   LYS A 241     -27.002  73.299  26.085  1.00  7.04           C  
ATOM   1827  O   LYS A 241     -26.778  72.316  25.378  1.00  7.06           O  
ATOM   1828  CB  LYS A 241     -27.818  73.072  28.442  1.00  8.77           C  
ATOM   1829  CG  LYS A 241     -27.482  72.701  29.878  1.00 16.25           C  
ATOM   1830  CD  LYS A 241     -28.746  72.429  30.677  1.00 22.15           C  
ATOM   1831  CE  LYS A 241     -28.433  71.791  32.020  1.00 27.18           C  
ATOM   1832  NZ  LYS A 241     -27.584  72.654  32.880  1.00 30.36           N  
ATOM   1833  N   GLU A 242     -27.599  74.398  25.633  1.00  7.99           N  
ATOM   1834  CA  GLU A 242     -28.042  74.538  24.244  1.00  8.42           C  
ATOM   1835  C   GLU A 242     -26.868  74.455  23.270  1.00  9.55           C  
ATOM   1836  O   GLU A 242     -26.935  73.747  22.260  1.00  8.17           O  
ATOM   1837  CB  GLU A 242     -28.785  75.872  24.074  1.00  9.19           C  
ATOM   1838  CG  GLU A 242     -28.980  76.370  22.635  1.00  8.24           C  
ATOM   1839  CD  GLU A 242     -29.803  75.439  21.760  1.00 11.94           C  
ATOM   1840  OE1 GLU A 242     -30.456  74.510  22.287  1.00  8.10           O  
ATOM   1841  OE2 GLU A 242     -29.802  75.650  20.529  1.00 10.13           O  
ATOM   1842  N   GLY A 243     -25.792  75.172  23.579  1.00  7.59           N  
ATOM   1843  CA  GLY A 243     -24.628  75.160  22.710  1.00  7.29           C  
ATOM   1844  C   GLY A 243     -24.049  73.773  22.496  1.00  9.16           C  
ATOM   1845  O   GLY A 243     -23.705  73.396  21.376  1.00  8.56           O  
ATOM   1846  N   MET A 244     -23.947  73.001  23.571  1.00  9.03           N  
ATOM   1847  CA  MET A 244     -23.387  71.663  23.468  1.00 10.81           C  
ATOM   1848  C   MET A 244     -24.348  70.666  22.824  1.00  9.99           C  
ATOM   1849  O   MET A 244     -23.916  69.751  22.124  1.00 11.05           O  
ATOM   1850  CB  MET A 244     -22.929  71.193  24.849  1.00  9.85           C  
ATOM   1851  CG  MET A 244     -21.843  72.109  25.410  1.00 13.03           C  
ATOM   1852  SD  MET A 244     -21.093  71.589  26.952  1.00 14.30           S  
ATOM   1853  CE  MET A 244     -19.852  72.878  27.163  1.00 12.22           C  
ATOM   1854  N   ALA A 245     -25.647  70.845  23.042  1.00  8.20           N  
ATOM   1855  CA  ALA A 245     -26.623  69.948  22.429  1.00  9.18           C  
ATOM   1856  C   ALA A 245     -26.649  70.228  20.924  1.00 10.87           C  
ATOM   1857  O   ALA A 245     -26.724  69.307  20.111  1.00 10.16           O  
ATOM   1858  CB  ALA A 245     -28.010  70.169  23.033  1.00  7.78           C  
ATOM   1859  N   ALA A 246     -26.578  71.506  20.562  1.00  9.72           N  
ATOM   1860  CA  ALA A 246     -26.589  71.910  19.158  1.00 10.90           C  
ATOM   1861  C   ALA A 246     -25.357  71.376  18.433  1.00 11.87           C  
ATOM   1862  O   ALA A 246     -25.440  70.952  17.280  1.00 13.01           O  
ATOM   1863  CB  ALA A 246     -26.638  73.433  19.047  1.00 10.71           C  
ATOM   1864  N   PHE A 247     -24.213  71.408  19.109  1.00 11.82           N  
ATOM   1865  CA  PHE A 247     -22.977  70.918  18.512  1.00 15.45           C  
ATOM   1866  C   PHE A 247     -23.074  69.424  18.214  1.00 15.14           C  
ATOM   1867  O   PHE A 247     -22.680  68.970  17.139  1.00 14.47           O  
ATOM   1868  CB  PHE A 247     -21.795  71.162  19.447  1.00 17.08           C  
ATOM   1869  CG  PHE A 247     -20.464  70.870  18.816  1.00 22.91           C  
ATOM   1870  CD1 PHE A 247     -19.921  71.743  17.880  1.00 25.00           C  
ATOM   1871  CD2 PHE A 247     -19.765  69.712  19.141  1.00 24.43           C  
ATOM   1872  CE1 PHE A 247     -18.696  71.466  17.272  1.00 26.68           C  
ATOM   1873  CE2 PHE A 247     -18.539  69.427  18.539  1.00 25.84           C  
ATOM   1874  CZ  PHE A 247     -18.006  70.306  17.604  1.00 25.63           C  
ATOM   1875  N   LEU A 248     -23.591  68.665  19.177  1.00 13.96           N  
ATOM   1876  CA  LEU A 248     -23.742  67.219  19.029  1.00 14.26           C  
ATOM   1877  C   LEU A 248     -24.759  66.865  17.949  1.00 14.77           C  
ATOM   1878  O   LEU A 248     -24.597  65.882  17.229  1.00 14.93           O  
ATOM   1879  CB  LEU A 248     -24.184  66.590  20.353  1.00 14.53           C  
ATOM   1880  CG  LEU A 248     -23.180  66.575  21.506  1.00 16.64           C  
ATOM   1881  CD1 LEU A 248     -23.819  65.919  22.721  1.00 18.91           C  
ATOM   1882  CD2 LEU A 248     -21.925  65.817  21.091  1.00 20.34           C  
ATOM   1883  N   GLU A 249     -25.810  67.672  17.844  1.00 13.52           N  
ATOM   1884  CA  GLU A 249     -26.853  67.434  16.858  1.00 14.02           C  
ATOM   1885  C   GLU A 249     -26.498  68.017  15.498  1.00 13.93           C  
ATOM   1886  O   GLU A 249     -27.248  67.864  14.536  1.00 13.38           O  
ATOM   1887  CB  GLU A 249     -28.172  68.026  17.350  1.00 13.98           C  
ATOM   1888  CG  GLU A 249     -28.803  67.240  18.487  1.00 15.30           C  
ATOM   1889  CD  GLU A 249     -30.001  67.945  19.081  1.00 14.59           C  
ATOM   1890  OE1 GLU A 249     -30.779  68.544  18.311  1.00 15.79           O  
ATOM   1891  OE2 GLU A 249     -30.172  67.888  20.315  1.00 17.79           O  
ATOM   1892  N   LYS A 250     -25.349  68.680  15.428  1.00 12.22           N  
ATOM   1893  CA  LYS A 250     -24.880  69.294  14.195  1.00 14.95           C  
ATOM   1894  C   LYS A 250     -25.894  70.279  13.619  1.00 15.06           C  
ATOM   1895  O   LYS A 250     -26.212  70.239  12.426  1.00 13.43           O  
ATOM   1896  CB  LYS A 250     -24.542  68.217  13.157  1.00 17.52           C  
ATOM   1897  CG  LYS A 250     -23.506  67.208  13.639  1.00 21.91           C  
ATOM   1898  CD  LYS A 250     -22.850  66.460  12.484  1.00 27.63           C  
ATOM   1899  CE  LYS A 250     -23.878  65.810  11.572  1.00 32.79           C  
ATOM   1900  NZ  LYS A 250     -24.780  64.890  12.316  1.00 35.87           N  
ATOM   1901  N   ARG A 251     -26.401  71.157  14.481  1.00 11.70           N  
ATOM   1902  CA  ARG A 251     -27.362  72.182  14.087  1.00 11.29           C  
ATOM   1903  C   ARG A 251     -26.899  73.504  14.697  1.00 11.43           C  
ATOM   1904  O   ARG A 251     -26.081  73.517  15.619  1.00 11.20           O  
ATOM   1905  CB  ARG A 251     -28.766  71.851  14.611  1.00 10.53           C  
ATOM   1906  CG  ARG A 251     -28.900  71.925  16.131  1.00 11.54           C  
ATOM   1907  CD  ARG A 251     -30.324  71.634  16.579  1.00  9.13           C  
ATOM   1908  NE  ARG A 251     -30.420  71.467  18.027  1.00 10.31           N  
ATOM   1909  CZ  ARG A 251     -30.375  72.460  18.910  1.00  8.03           C  
ATOM   1910  NH1 ARG A 251     -30.237  73.717  18.502  1.00  8.85           N  
ATOM   1911  NH2 ARG A 251     -30.461  72.192  20.207  1.00  7.84           N  
ATOM   1912  N   LYS A 252     -27.418  74.614  14.187  1.00 11.46           N  
ATOM   1913  CA  LYS A 252     -27.043  75.919  14.718  1.00 11.41           C  
ATOM   1914  C   LYS A 252     -27.622  76.114  16.113  1.00  9.81           C  
ATOM   1915  O   LYS A 252     -28.773  75.759  16.369  1.00 10.51           O  
ATOM   1916  CB  LYS A 252     -27.559  77.042  13.810  1.00 14.91           C  
ATOM   1917  CG  LYS A 252     -26.871  77.132  12.457  1.00 18.51           C  
ATOM   1918  CD  LYS A 252     -27.197  78.452  11.778  1.00 22.52           C  
ATOM   1919  CE  LYS A 252     -26.360  78.651  10.526  1.00 26.37           C  
ATOM   1920  NZ  LYS A 252     -26.510  80.032   9.986  1.00 27.91           N  
ATOM   1921  N   PRO A 253     -26.826  76.665  17.043  1.00  7.92           N  
ATOM   1922  CA  PRO A 253     -27.330  76.889  18.401  1.00  8.15           C  
ATOM   1923  C   PRO A 253     -28.254  78.107  18.395  1.00  8.03           C  
ATOM   1924  O   PRO A 253     -28.091  79.014  17.573  1.00  9.91           O  
ATOM   1925  CB  PRO A 253     -26.054  77.120  19.207  1.00  8.49           C  
ATOM   1926  CG  PRO A 253     -25.159  77.791  18.213  1.00  9.18           C  
ATOM   1927  CD  PRO A 253     -25.386  76.965  16.964  1.00  7.67           C  
ATOM   1928  N   ARG A 254     -29.227  78.119  19.299  1.00  8.44           N  
ATOM   1929  CA  ARG A 254     -30.177  79.222  19.394  1.00  8.40           C  
ATOM   1930  C   ARG A 254     -30.077  79.799  20.804  1.00  8.01           C  
ATOM   1931  O   ARG A 254     -30.871  79.471  21.683  1.00 10.07           O  
ATOM   1932  CB  ARG A 254     -31.595  78.704  19.122  1.00  9.16           C  
ATOM   1933  CG  ARG A 254     -31.737  77.957  17.794  1.00 11.28           C  
ATOM   1934  CD  ARG A 254     -31.437  78.867  16.607  1.00 12.79           C  
ATOM   1935  NE  ARG A 254     -31.429  78.142  15.336  1.00 11.78           N  
ATOM   1936  CZ  ARG A 254     -31.224  78.711  14.151  1.00 16.33           C  
ATOM   1937  NH1 ARG A 254     -31.009  80.018  14.067  1.00 16.67           N  
ATOM   1938  NH2 ARG A 254     -31.231  77.973  13.049  1.00 17.09           N  
ATOM   1939  N   PHE A 255     -29.086  80.658  21.015  1.00  8.08           N  
ATOM   1940  CA  PHE A 255     -28.857  81.252  22.328  1.00  6.31           C  
ATOM   1941  C   PHE A 255     -29.911  82.276  22.726  1.00  8.79           C  
ATOM   1942  O   PHE A 255     -30.359  83.076  21.904  1.00  8.57           O  
ATOM   1943  CB  PHE A 255     -27.458  81.862  22.360  1.00  7.29           C  
ATOM   1944  CG  PHE A 255     -26.366  80.865  22.061  1.00  6.92           C  
ATOM   1945  CD1 PHE A 255     -26.153  79.778  22.904  1.00  7.56           C  
ATOM   1946  CD2 PHE A 255     -25.572  80.998  20.926  1.00  7.54           C  
ATOM   1947  CE1 PHE A 255     -25.161  78.834  22.623  1.00  7.98           C  
ATOM   1948  CE2 PHE A 255     -24.576  80.059  20.634  1.00  9.50           C  
ATOM   1949  CZ  PHE A 255     -24.371  78.976  21.484  1.00  6.69           C  
ATOM   1950  N   GLN A 256     -30.295  82.251  24.001  1.00  6.01           N  
ATOM   1951  CA  GLN A 256     -31.320  83.154  24.511  1.00  8.21           C  
ATOM   1952  C   GLN A 256     -30.838  84.110  25.602  1.00  8.96           C  
ATOM   1953  O   GLN A 256     -31.623  84.884  26.142  1.00 11.42           O  
ATOM   1954  CB  GLN A 256     -32.505  82.332  25.031  1.00  9.23           C  
ATOM   1955  CG  GLN A 256     -33.098  81.402  23.974  1.00 16.30           C  
ATOM   1956  CD  GLN A 256     -34.455  80.847  24.367  1.00 22.19           C  
ATOM   1957  OE1 GLN A 256     -35.385  81.600  24.647  1.00 26.06           O  
ATOM   1958  NE2 GLN A 256     -34.575  79.524  24.378  1.00 24.72           N  
ATOM   1959  N   GLY A 257     -29.551  84.054  25.930  1.00  9.02           N  
ATOM   1960  CA  GLY A 257     -29.017  84.939  26.950  1.00  8.63           C  
ATOM   1961  C   GLY A 257     -29.412  84.564  28.366  1.00  8.68           C  
ATOM   1962  O   GLY A 257     -29.608  85.437  29.211  1.00  9.49           O  
ATOM   1963  N   LYS A 258     -29.532  83.265  28.624  1.00  8.65           N  
ATOM   1964  CA  LYS A 258     -29.889  82.767  29.950  1.00  7.88           C  
ATOM   1965  C   LYS A 258     -29.244  81.402  30.164  1.00  8.48           C  
ATOM   1966  O   LYS A 258     -28.605  80.903  29.214  1.00 13.93           O  
ATOM   1967  CB  LYS A 258     -31.410  82.652  30.086  1.00 10.60           C  
ATOM   1968  CG  LYS A 258     -32.051  81.668  29.123  1.00 14.47           C  
ATOM   1969  CD  LYS A 258     -33.567  81.717  29.215  1.00 17.30           C  
ATOM   1970  CE  LYS A 258     -34.221  80.749  28.243  1.00 19.33           C  
ATOM   1971  NZ  LYS A 258     -35.707  80.880  28.258  1.00 18.44           N  
TER    1972      LYS A 258                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
