
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  258 ( 2004),  selected  258 , name 2gtr_A
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 2gtr_A.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R     3_A      -       -           -
LGA    Y     4_A      P      32          5.418
LGA    R     5_A      R      33          0.742
LGA    D     6_A      P      34          0.540
LGA    I     7_A      T      35          0.767
LGA    V     8_A      S      36          0.857
LGA    V     9_A      A      37          0.602
LGA    R    10_A      R      38          0.392
LGA    K    11_A      Q      39          0.937
LGA    Q    12_A      L      40          0.687
LGA    D    13_A      D      41          0.694
LGA    G    14_A      G      42          1.078
LGA    F    15_A      I      43          1.820
LGA    T    16_A      R      44          1.094
LGA    H    17_A      N      45          1.079
LGA    I    18_A      I      46          0.522
LGA    L    19_A      V      47          0.576
LGA    L    20_A      L      48          0.655
LGA    S    21_A      S      49          0.338
LGA    T    22_A      N      50          1.966
LGA    K    23_A      P      51           #
LGA    S    24_A      -       -           -
LGA    S    25_A      K      52           #
LGA    E    26_A      K      53          0.522
LGA    N    27_A      R      54          1.032
LGA    N    28_A      N      55          0.490
LGA    S    29_A      T      56          0.517
LGA    L    30_A      L      57          0.707
LGA    N    31_A      S      58          0.581
LGA    P    32_A      L      59          0.664
LGA    E    33_A      A      60          0.747
LGA    V    34_A      M      61          0.657
LGA    M    35_A      L      62          0.382
LGA    R    36_A      K      63          0.545
LGA    E    37_A      S      64          0.843
LGA    V    38_A      L      65          0.863
LGA    Q    39_A      Q      66          0.791
LGA    S    40_A      S      67          0.889
LGA    A    41_A      D      68          0.877
LGA    L    42_A      I      69          0.803
LGA    S    43_A      L      70          0.719
LGA    T    44_A      H      71          1.052
LGA    A    45_A      D      72          4.458
LGA    A    46_A      A      73          1.796
LGA    A    47_A      D      74          2.365
LGA    D    48_A      S      75          2.094
LGA    D    49_A      N      76          2.454
LGA    -       -      D      77           -
LGA    S    50_A      L      78          0.419
LGA    K    51_A      K      79          0.736
LGA    L    52_A      V      80          1.038
LGA    V    53_A      I      81          0.561
LGA    L    54_A      I      82          0.991
LGA    L    55_A      I      83          0.941
LGA    S    56_A      S      84          0.758
LGA    A    57_A      A      85          0.826
LGA    V    58_A      E      86          1.265
LGA    G    59_A      G      87          1.304
LGA    S    60_A      P      88          1.332
LGA    V    61_A      V      89          1.286
LGA    F    62_A      F      90          0.993
LGA    C    63_A      S      91          1.016
LGA    C    64_A      S      92          0.919
LGA    G    65_A      G      93          0.622
LGA    L    66_A      H      94          0.535
LGA    D    67_A      D      95          1.213
LGA    F    68_A      L      96          0.848
LGA    I    69_A      K      97          3.006
LGA    Y    70_A      E      98          4.335
LGA    F    71_A      L      99          3.384
LGA    I    72_A      T     100          2.758
LGA    R    73_A      -       -           -
LGA    R    74_A      -       -           -
LGA    L    75_A      E     101          3.399
LGA    T    76_A      E     102          2.321
LGA    D    77_A      -       -           -
LGA    D    78_A      Q     103          4.007
LGA    R    79_A      G     104          2.613
LGA    K    80_A      R     105          3.341
LGA    R    81_A      D     106          3.412
LGA    E    82_A      Y     107          2.682
LGA    S    83_A      H     108          2.514
LGA    T    84_A      A     109          2.914
LGA    K    85_A      E     110          2.859
LGA    M    86_A      V     111          2.702
LGA    A    87_A      F     112          3.199
LGA    E    88_A      Q     113          2.757
LGA    A    89_A      T     114          2.782
LGA    I    90_A      C     115          2.823
LGA    R    91_A      S     116          3.112
LGA    N    92_A      K     117          2.801
LGA    F    93_A      V     118          2.862
LGA    V    94_A      M     119          2.958
LGA    N    95_A      M     120          2.893
LGA    T    96_A      H     121          2.377
LGA    F    97_A      I     122          2.566
LGA    I    98_A      R     123          3.347
LGA    Q    99_A      N     124          2.516
LGA    F   100_A      H     125          1.990
LGA    K   101_A      P     126          2.680
LGA    K   102_A      V     127          1.484
LGA    P   103_A      P     128          0.260
LGA    I   104_A      V     129          0.137
LGA    I   105_A      I     130          0.845
LGA    V   106_A      A     131          1.162
LGA    A   107_A      M     132          0.589
LGA    V   108_A      V     133          0.367
LGA    N   109_A      N     134          0.607
LGA    G   110_A      G     135          1.119
LGA    P   111_A      L     136          0.539
LGA    A   112_A      A     137          0.642
LGA    I   113_A      T     138          0.505
LGA    G   114_A      A     139          0.378
LGA    L   115_A      A     140          0.701
LGA    G   116_A      G     141          0.708
LGA    A   117_A      C     142          0.592
LGA    S   118_A      Q     143          1.271
LGA    I   119_A      L     144          2.320
LGA    L   120_A      V     145          2.281
LGA    P   121_A      A     146          2.668
LGA    L   122_A      S     147          2.184
LGA    C   123_A      C     148          1.141
LGA    D   124_A      D     149          0.623
LGA    V   125_A      I     150          0.458
LGA    V   126_A      A     151          0.273
LGA    W   127_A      V     152          0.390
LGA    A   128_A      A     153          0.532
LGA    N   129_A      S     154          0.715
LGA    E   130_A      D     155          1.437
LGA    K   131_A      K     156          2.112
LGA    A   132_A      S     157          1.007
LGA    W   133_A      S     158          0.520
LGA    F   134_A      F     159          0.312
LGA    Q   135_A      A     160          0.415
LGA    T   136_A      T     161          0.754
LGA    P   137_A      P     162          0.677
LGA    Y   138_A      G     163          2.037
LGA    T   139_A      V     164          1.642
LGA    T   140_A      N     165          1.549
LGA    F   141_A      V     166          2.347
LGA    G   142_A      G     167          1.838
LGA    Q   143_A      L     168          2.376
LGA    S   144_A      F     169          3.338
LGA    P   145_A      C     170          3.011
LGA    D   146_A      S     171          4.182
LGA    G   147_A      T     172          4.189
LGA    C   148_A      P     173           #
LGA    S   149_A      G     174          2.663
LGA    T   150_A      V     175          3.282
LGA    V   151_A      -       -           -
LGA    M   152_A      A     176          3.862
LGA    F   153_A      L     177          2.662
LGA    P   154_A      A     178          3.143
LGA    K   155_A      R     179          3.476
LGA    I   156_A      A     180          2.877
LGA    M   157_A      V     181          2.011
LGA    G   158_A      P     182          1.635
LGA    G   159_A      R     183          1.237
LGA    A   160_A      K     184          0.904
LGA    S   161_A      V     185          1.006
LGA    A   162_A      A     186          1.156
LGA    N   163_A      L     187          0.646
LGA    E   164_A      E     188          0.777
LGA    M   165_A      M     189          1.300
LGA    L   166_A      L     190          1.542
LGA    L   167_A      F     191          1.455
LGA    S   168_A      T     192          1.506
LGA    G   169_A      G     193          1.011
LGA    R   170_A      E     194          2.248
LGA    K   171_A      P     195          0.505
LGA    L   172_A      I     196          0.824
LGA    T   173_A      S     197          0.911
LGA    A   174_A      A     198          0.727
LGA    Q   175_A      Q     199          0.521
LGA    E   176_A      E     200          0.793
LGA    A   177_A      A     201          0.697
LGA    C   178_A      L     202          0.450
LGA    G   179_A      L     203          0.981
LGA    K   180_A      H     204          1.514
LGA    G   181_A      G     205          0.642
LGA    L   182_A      L     206          0.539
LGA    V   183_A      L     207          0.565
LGA    S   184_A      S     208          0.524
LGA    Q   185_A      K     209          0.841
LGA    V   186_A      V     210          0.401
LGA    F   187_A      V     211          0.520
LGA    W   188_A      P     212          1.031
LGA    P   189_A      E     213          1.349
LGA    G   190_A      A     214          1.779
LGA    T   191_A      E     215          2.216
LGA    F   192_A      L     216          1.650
LGA    T   193_A      Q     217          1.476
LGA    Q   194_A      E     218          1.859
LGA    E   195_A      E     219          2.066
LGA    V   196_A      T     220          1.854
LGA    M   197_A      M     221          1.760
LGA    V   198_A      R     222          2.704
LGA    R   199_A      I     223          2.736
LGA    I   200_A      A     224          1.708
LGA    K   201_A      R     225          1.608
LGA    E   202_A      K     226          1.909
LGA    L   203_A      I     227          1.758
LGA    A   204_A      A     228          0.934
LGA    S   205_A      S     229          0.788
LGA    C   206_A      L     230          1.076
LGA    N   207_A      S     231          1.183
LGA    P   208_A      R     232          1.382
LGA    V   209_A      P     233          1.781
LGA    V   210_A      V     234          2.149
LGA    L   211_A      V     235          1.540
LGA    E   212_A      S     236          1.029
LGA    E   213_A      L     237          1.806
LGA    S   214_A      G     238          1.885
LGA    K   215_A      K     239          1.093
LGA    A   216_A      A     240          1.426
LGA    L   217_A      T     241          2.287
LGA    V   218_A      F     242          1.852
LGA    R   219_A      Y     243          1.114
LGA    C   220_A      K     244          1.070
LGA    N   221_A      Q     245          3.422
LGA    -       -      L     246           -
LGA    M   222_A      P     247          4.438
LGA    K   223_A      Q     248           -
LGA    M   224_A      D     249           -
LGA    E   225_A      L     250           -
LGA    L   226_A      G     251           -
LGA    E   227_A      T     252           -
LGA    Q   228_A      A     253           -
LGA    A   229_A      Y     254           -
LGA    N   230_A      Y     255           -
LGA    E   231_A      L     256           -
LGA    R   232_A      T     257           -
LGA    E   233_A      S     258           -
LGA    C   234_A      Q     259           -
LGA    E   235_A      A     260           -
LGA    V   236_A      M     261           -
LGA    L   237_A      V     262           -
LGA    K   238_A      D     263           -
LGA    K   239_A      N     264           -
LGA    I   240_A      L     265           -
LGA    W   241_A      A     266           -
LGA    G   242_A      L     267           -
LGA    S   243_A      R     268           -
LGA    A   244_A      D     269           -
LGA    Q   245_A      G     270           -
LGA    G   246_A      Q     271           -
LGA    M   247_A      E     272           -
LGA    D   248_A      G     273           -
LGA    S   249_A      I     274           -
LGA    M   250_A      T     275           -
LGA    L   251_A      A     276           -
LGA    K   252_A      F     277           -
LGA    Y   253_A      L     278           -
LGA    L   254_A      Q     279           -
LGA    Q   255_A      K     280           -
LGA    R   256_A      R     281           -
LGA    K   257_A      K     282           -
LGA    I   258_A      P     283           -
LGA    D   259_A      V     284           -
LGA    E   260_A      W     285           -
LGA    -       -      S     286           -
LGA    -       -      H     287           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  258  256    5.0    211    1.87    26.07     74.382    10.732

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.565003 * X  +  -0.158267 * Y  +   0.809767 * Z  +  19.378614
  Y_new =   0.042574 * X  +  -0.985715 * Y  +  -0.162950 * Z  + 101.302170
  Z_new =   0.823990 * X  +  -0.057592 * Y  +   0.563670 * Z  +  52.422905 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.101820    3.039772  [ DEG:    -5.8339    174.1661 ]
  Theta =  -0.968417   -2.173176  [ DEG:   -55.4862   -124.5138 ]
  Phi   =   3.066382   -0.075210  [ DEG:   175.6908     -4.3092 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gtr_A                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gtr_A.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  258  256   5.0  211   1.87   26.07  74.382
REMARK  ---------------------------------------------------------- 
MOLECULE 2gtr_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   28-APR-06   2GTR              
TITLE     HUMAN CHROMODOMAIN Y-LIKE PROTEIN                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CHROMODOMAIN Y-LIKE PROTEIN;                               
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: CDY-LIKE;                                                   
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: CDYL, CDYL1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    CHROMODOMAIN Y-LIKE PROTEIN, STRUCTURAL GENOMICS,                     
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, SGC                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.MIN,H.WU,T.ANTOSHENKO,P.LOPPNAU,J.WEIGELT,M.SUNDSTROM,              
AUTHOR   2 C.H.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,A.N.PLOTNIKOV,                
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   09-MAY-06 2GTR    0                                                
JRNL        AUTH   T.ANTOSHENKO,J.MIN,H.WU,P.LOPPNAU,J.WEIGELT,                 
JRNL        AUTH 2 M.SUNDSTROM,C.H.ARROWSMITH,A.M.EDWARDS,A.BOCHKAREV,          
JRNL        AUTH 3 A.N.PLOTNIKOV                                                
JRNL        TITL   THE CRYSTAL STRUCTURE OF HUMAN CHROMODOMAIN Y-LIKE           
JRNL        TITL 2 PROTEIN.                                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2GTR A    1   261  UNP    Q9Y232   CDYL1_HUMAN    338    598             
DBREF  2GTR B    1   261  UNP    Q9Y232   CDYL1_HUMAN    338    598             
DBREF  2GTR C    1   261  UNP    Q9Y232   CDYL1_HUMAN    338    598             
SEQRES   1 A  261  ALA TYR ARG TYR ARG ASP ILE VAL VAL ARG LYS GLN ASP          
SEQRES   2 A  261  GLY PHE THR HIS ILE LEU LEU SER THR LYS SER SER GLU          
SEQRES   3 A  261  ASN ASN SER LEU ASN PRO GLU VAL MET ARG GLU VAL GLN          
SEQRES   4 A  261  SER ALA LEU SER THR ALA ALA ALA ASP ASP SER LYS LEU          
SEQRES   5 A  261  VAL LEU LEU SER ALA VAL GLY SER VAL PHE CYS CYS GLY          
SEQRES   6 A  261  LEU ASP PHE ILE TYR PHE ILE ARG ARG LEU THR ASP ASP          
SEQRES   7 A  261  ARG LYS ARG GLU SER THR LYS MET ALA GLU ALA ILE ARG          
SEQRES   8 A  261  ASN PHE VAL ASN THR PHE ILE GLN PHE LYS LYS PRO ILE          
SEQRES   9 A  261  ILE VAL ALA VAL ASN GLY PRO ALA ILE GLY LEU GLY ALA          
SEQRES  10 A  261  SER ILE LEU PRO LEU CYS ASP VAL VAL TRP ALA ASN GLU          
SEQRES  11 A  261  LYS ALA TRP PHE GLN THR PRO TYR THR THR PHE GLY GLN          
SEQRES  12 A  261  SER PRO ASP GLY CYS SER THR VAL MET PHE PRO LYS ILE          
SEQRES  13 A  261  MET GLY GLY ALA SER ALA ASN GLU MET LEU LEU SER GLY          
SEQRES  14 A  261  ARG LYS LEU THR ALA GLN GLU ALA CYS GLY LYS GLY LEU          
SEQRES  15 A  261  VAL SER GLN VAL PHE TRP PRO GLY THR PHE THR GLN GLU          
SEQRES  16 A  261  VAL MET VAL ARG ILE LYS GLU LEU ALA SER CYS ASN PRO          
SEQRES  17 A  261  VAL VAL LEU GLU GLU SER LYS ALA LEU VAL ARG CYS ASN          
SEQRES  18 A  261  MET LYS MET GLU LEU GLU GLN ALA ASN GLU ARG GLU CYS          
SEQRES  19 A  261  GLU VAL LEU LYS LYS ILE TRP GLY SER ALA GLN GLY MET          
SEQRES  20 A  261  ASP SER MET LEU LYS TYR LEU GLN ARG LYS ILE ASP GLU          
SEQRES  21 A  261  PHE                                                          
SEQRES   1 B  261  ALA TYR ARG TYR ARG ASP ILE VAL VAL ARG LYS GLN ASP          
SEQRES   2 B  261  GLY PHE THR HIS ILE LEU LEU SER THR LYS SER SER GLU          
SEQRES   3 B  261  ASN ASN SER LEU ASN PRO GLU VAL MET ARG GLU VAL GLN          
SEQRES   4 B  261  SER ALA LEU SER THR ALA ALA ALA ASP ASP SER LYS LEU          
SEQRES   5 B  261  VAL LEU LEU SER ALA VAL GLY SER VAL PHE CYS CYS GLY          
SEQRES   6 B  261  LEU ASP PHE ILE TYR PHE ILE ARG ARG LEU THR ASP ASP          
SEQRES   7 B  261  ARG LYS ARG GLU SER THR LYS MET ALA GLU ALA ILE ARG          
SEQRES   8 B  261  ASN PHE VAL ASN THR PHE ILE GLN PHE LYS LYS PRO ILE          
SEQRES   9 B  261  ILE VAL ALA VAL ASN GLY PRO ALA ILE GLY LEU GLY ALA          
SEQRES  10 B  261  SER ILE LEU PRO LEU CYS ASP VAL VAL TRP ALA ASN GLU          
SEQRES  11 B  261  LYS ALA TRP PHE GLN THR PRO TYR THR THR PHE GLY GLN          
SEQRES  12 B  261  SER PRO ASP GLY CYS SER THR VAL MET PHE PRO LYS ILE          
SEQRES  13 B  261  MET GLY GLY ALA SER ALA ASN GLU MET LEU LEU SER GLY          
SEQRES  14 B  261  ARG LYS LEU THR ALA GLN GLU ALA CYS GLY LYS GLY LEU          
SEQRES  15 B  261  VAL SER GLN VAL PHE TRP PRO GLY THR PHE THR GLN GLU          
SEQRES  16 B  261  VAL MET VAL ARG ILE LYS GLU LEU ALA SER CYS ASN PRO          
SEQRES  17 B  261  VAL VAL LEU GLU GLU SER LYS ALA LEU VAL ARG CYS ASN          
SEQRES  18 B  261  MET LYS MET GLU LEU GLU GLN ALA ASN GLU ARG GLU CYS          
SEQRES  19 B  261  GLU VAL LEU LYS LYS ILE TRP GLY SER ALA GLN GLY MET          
SEQRES  20 B  261  ASP SER MET LEU LYS TYR LEU GLN ARG LYS ILE ASP GLU          
SEQRES  21 B  261  PHE                                                          
SEQRES   1 C  261  ALA TYR ARG TYR ARG ASP ILE VAL VAL ARG LYS GLN ASP          
SEQRES   2 C  261  GLY PHE THR HIS ILE LEU LEU SER THR LYS SER SER GLU          
SEQRES   3 C  261  ASN ASN SER LEU ASN PRO GLU VAL MET ARG GLU VAL GLN          
SEQRES   4 C  261  SER ALA LEU SER THR ALA ALA ALA ASP ASP SER LYS LEU          
SEQRES   5 C  261  VAL LEU LEU SER ALA VAL GLY SER VAL PHE CYS CYS GLY          
SEQRES   6 C  261  LEU ASP PHE ILE TYR PHE ILE ARG ARG LEU THR ASP ASP          
SEQRES   7 C  261  ARG LYS ARG GLU SER THR LYS MET ALA GLU ALA ILE ARG          
SEQRES   8 C  261  ASN PHE VAL ASN THR PHE ILE GLN PHE LYS LYS PRO ILE          
SEQRES   9 C  261  ILE VAL ALA VAL ASN GLY PRO ALA ILE GLY LEU GLY ALA          
SEQRES  10 C  261  SER ILE LEU PRO LEU CYS ASP VAL VAL TRP ALA ASN GLU          
SEQRES  11 C  261  LYS ALA TRP PHE GLN THR PRO TYR THR THR PHE GLY GLN          
SEQRES  12 C  261  SER PRO ASP GLY CYS SER THR VAL MET PHE PRO LYS ILE          
SEQRES  13 C  261  MET GLY GLY ALA SER ALA ASN GLU MET LEU LEU SER GLY          
SEQRES  14 C  261  ARG LYS LEU THR ALA GLN GLU ALA CYS GLY LYS GLY LEU          
SEQRES  15 C  261  VAL SER GLN VAL PHE TRP PRO GLY THR PHE THR GLN GLU          
SEQRES  16 C  261  VAL MET VAL ARG ILE LYS GLU LEU ALA SER CYS ASN PRO          
SEQRES  17 C  261  VAL VAL LEU GLU GLU SER LYS ALA LEU VAL ARG CYS ASN          
SEQRES  18 C  261  MET LYS MET GLU LEU GLU GLN ALA ASN GLU ARG GLU CYS          
SEQRES  19 C  261  GLU VAL LEU LYS LYS ILE TRP GLY SER ALA GLN GLY MET          
SEQRES  20 C  261  ASP SER MET LEU LYS TYR LEU GLN ARG LYS ILE ASP GLU          
SEQRES  21 C  261  PHE                                                          
FORMUL   4  HOH   *532(H2 O)                                                    
CRYST1   76.207  132.739  100.361  90.00 102.92  90.00 C 1 2 1      12          
ATOM      1  N   ARG A   3     -36.351 113.315  22.476  1.00 39.54           N  
ATOM      2  CA  ARG A   3     -35.859 114.154  23.608  1.00 38.67           C  
ATOM      3  C   ARG A   3     -34.316 114.137  23.728  1.00 36.48           C  
ATOM      4  O   ARG A   3     -33.774 115.161  24.157  1.00 35.71           O  
ATOM      5  CB  ARG A   3     -36.537 113.884  25.002  1.00 39.39           C  
ATOM      6  CG  ARG A   3     -38.056 113.496  25.041  1.00 42.97           C  
ATOM      7  CD  ARG A   3     -39.117 114.645  24.864  1.00 46.74           C  
ATOM      8  NE  ARG A   3     -38.669 115.978  25.309  1.00 48.35           N  
ATOM      9  CZ  ARG A   3     -39.077 117.138  24.768  1.00 50.54           C  
ATOM     10  NH1 ARG A   3     -39.961 117.155  23.761  1.00 49.86           N  
ATOM     11  NH2 ARG A   3     -38.603 118.292  25.241  1.00 49.71           N  
ATOM     12  N   TYR A   4     -33.588 113.059  23.364  1.00 33.87           N  
ATOM     13  CA  TYR A   4     -32.113 113.279  23.205  1.00 30.66           C  
ATOM     14  C   TYR A   4     -31.919 114.318  22.131  1.00 30.23           C  
ATOM     15  O   TYR A   4     -32.555 114.248  21.074  1.00 30.73           O  
ATOM     16  CB  TYR A   4     -31.267 112.052  22.814  1.00 29.82           C  
ATOM     17  CG  TYR A   4     -31.135 111.009  23.861  1.00 25.16           C  
ATOM     18  CD1 TYR A   4     -30.662 111.317  25.123  1.00 27.66           C  
ATOM     19  CD2 TYR A   4     -31.501 109.697  23.584  1.00 26.16           C  
ATOM     20  CE1 TYR A   4     -30.592 110.353  26.106  1.00 26.38           C  
ATOM     21  CE2 TYR A   4     -31.423 108.700  24.563  1.00 26.77           C  
ATOM     22  CZ  TYR A   4     -30.939 109.039  25.795  1.00 28.11           C  
ATOM     23  OH  TYR A   4     -30.879 108.087  26.763  1.00 28.38           O  
ATOM     24  N   ARG A   5     -31.010 115.238  22.368  1.00 28.47           N  
ATOM     25  CA  ARG A   5     -30.774 116.309  21.428  1.00 28.26           C  
ATOM     26  C   ARG A   5     -29.519 116.061  20.556  1.00 26.55           C  
ATOM     27  O   ARG A   5     -29.462 116.465  19.391  1.00 26.34           O  
ATOM     28  CB  ARG A   5     -30.660 117.596  22.215  1.00 27.65           C  
ATOM     29  CG  ARG A   5     -30.207 118.765  21.428  1.00 33.89           C  
ATOM     30  CD  ARG A   5     -30.234 120.044  22.278  1.00 45.61           C  
ATOM     31  NE  ARG A   5     -29.459 121.123  21.656  1.00 52.11           N  
ATOM     32  CZ  ARG A   5     -29.936 121.979  20.756  1.00 54.59           C  
ATOM     33  NH1 ARG A   5     -31.204 121.891  20.349  1.00 55.81           N  
ATOM     34  NH2 ARG A   5     -29.133 122.925  20.264  1.00 56.71           N  
ATOM     35  N   ASP A   6     -28.522 115.391  21.128  1.00 24.53           N  
ATOM     36  CA  ASP A   6     -27.191 115.347  20.527  1.00 22.95           C  
ATOM     37  C   ASP A   6     -26.822 113.974  19.949  1.00 21.34           C  
ATOM     38  O   ASP A   6     -25.767 113.831  19.313  1.00 21.36           O  
ATOM     39  CB  ASP A   6     -26.164 115.800  21.548  1.00 21.88           C  
ATOM     40  CG  ASP A   6     -26.287 117.270  21.863  1.00 27.67           C  
ATOM     41  OD1 ASP A   6     -26.425 118.094  20.920  1.00 28.25           O  
ATOM     42  OD2 ASP A   6     -26.163 117.616  23.045  1.00 29.93           O  
ATOM     43  N   ILE A   7     -27.682 112.994  20.180  1.00 21.13           N  
ATOM     44  CA  ILE A   7     -27.526 111.618  19.682  1.00 21.74           C  
ATOM     45  C   ILE A   7     -28.849 111.089  19.107  1.00 21.98           C  
ATOM     46  O   ILE A   7     -29.930 111.585  19.426  1.00 22.22           O  
ATOM     47  CB  ILE A   7     -26.997 110.638  20.800  1.00 22.21           C  
ATOM     48  CG1 ILE A   7     -27.887 110.622  22.051  1.00 23.11           C  
ATOM     49  CG2 ILE A   7     -25.611 111.010  21.220  1.00 22.15           C  
ATOM     50  CD1 ILE A   7     -27.496 109.472  23.038  1.00 22.28           C  
ATOM     51  N   VAL A   8     -28.766 110.089  18.242  1.00 21.74           N  
ATOM     52  CA  VAL A   8     -29.923 109.374  17.795  1.00 22.66           C  
ATOM     53  C   VAL A   8     -29.764 107.955  18.301  1.00 21.45           C  
ATOM     54  O   VAL A   8     -28.672 107.326  18.160  1.00 21.78           O  
ATOM     55  CB  VAL A   8     -29.919 109.330  16.228  1.00 23.30           C  
ATOM     56  CG1 VAL A   8     -31.044 108.443  15.697  1.00 25.26           C  
ATOM     57  CG2 VAL A   8     -30.004 110.730  15.652  1.00 27.23           C  
ATOM     58  N   VAL A   9     -30.811 107.423  18.912  1.00 21.72           N  
ATOM     59  CA  VAL A   9     -30.742 106.044  19.379  1.00 23.07           C  
ATOM     60  C   VAL A   9     -31.808 105.157  18.737  1.00 25.41           C  
ATOM     61  O   VAL A   9     -32.990 105.526  18.699  1.00 25.74           O  
ATOM     62  CB  VAL A   9     -30.849 105.967  20.915  1.00 23.30           C  
ATOM     63  CG1 VAL A   9     -30.594 104.541  21.395  1.00 23.55           C  
ATOM     64  CG2 VAL A   9     -29.872 106.896  21.520  1.00 24.90           C  
ATOM     65  N   ARG A  10     -31.416 103.975  18.274  1.00 25.15           N  
ATOM     66  CA  ARG A  10     -32.355 103.067  17.656  1.00 27.12           C  
ATOM     67  C   ARG A  10     -32.152 101.677  18.231  1.00 27.45           C  
ATOM     68  O   ARG A  10     -31.034 101.159  18.206  1.00 26.69           O  
ATOM     69  CB  ARG A  10     -32.023 102.953  16.182  1.00 27.01           C  
ATOM     70  CG  ARG A  10     -32.202 104.190  15.392  1.00 32.11           C  
ATOM     71  CD  ARG A  10     -32.325 103.691  13.973  1.00 39.83           C  
ATOM     72  NE  ARG A  10     -31.090 103.729  13.196  1.00 41.55           N  
ATOM     73  CZ  ARG A  10     -30.683 104.819  12.553  1.00 42.20           C  
ATOM     74  NH1 ARG A  10     -31.391 105.945  12.640  1.00 41.46           N  
ATOM     75  NH2 ARG A  10     -29.567 104.789  11.845  1.00 40.88           N  
ATOM     76  N   LYS A  11     -33.219 101.045  18.683  1.00 28.33           N  
ATOM     77  CA  LYS A  11     -33.116  99.704  19.232  1.00 30.46           C  
ATOM     78  C   LYS A  11     -33.903  98.698  18.371  1.00 31.53           C  
ATOM     79  O   LYS A  11     -35.115  98.813  18.240  1.00 32.00           O  
ATOM     80  CB  LYS A  11     -33.571  99.688  20.700  1.00 30.37           C  
ATOM     81  CG  LYS A  11     -33.276  98.327  21.345  1.00 33.53           C  
ATOM     82  CD  LYS A  11     -33.736  98.221  22.800  1.00 31.61           C  
ATOM     83  CE  LYS A  11     -34.317  96.841  23.067  1.00 36.64           C  
ATOM     84  NZ  LYS A  11     -33.687  95.835  22.164  1.00 41.73           N  
ATOM     85  N   GLN A  12     -33.222  97.735  17.750  1.00 32.58           N  
ATOM     86  CA  GLN A  12     -33.887  96.865  16.769  1.00 34.46           C  
ATOM     87  C   GLN A  12     -32.990  95.684  16.528  1.00 33.89           C  
ATOM     88  O   GLN A  12     -31.804  95.808  16.718  1.00 34.87           O  
ATOM     89  CB  GLN A  12     -34.101  97.617  15.443  1.00 35.10           C  
ATOM     90  CG  GLN A  12     -32.827  97.851  14.607  1.00 37.93           C  
ATOM     91  CD  GLN A  12     -31.975  99.004  15.157  1.00 44.50           C  
ATOM     92  OE1 GLN A  12     -30.876  98.818  15.763  1.00 41.82           O  
ATOM     93  NE2 GLN A  12     -32.512 100.219  14.993  1.00 47.36           N  
ATOM     94  N   ASP A  13     -33.544  94.554  16.099  1.00 32.90           N  
ATOM     95  CA  ASP A  13     -32.747  93.390  15.683  1.00 32.57           C  
ATOM     96  C   ASP A  13     -31.664  92.936  16.700  1.00 30.37           C  
ATOM     97  O   ASP A  13     -30.583  92.522  16.297  1.00 30.02           O  
ATOM     98  CB  ASP A  13     -32.128  93.637  14.286  1.00 34.38           C  
ATOM     99  CG  ASP A  13     -33.094  94.347  13.321  1.00 37.29           C  
ATOM    100  OD1 ASP A  13     -34.314  94.082  13.380  1.00 42.78           O  
ATOM    101  OD2 ASP A  13     -32.640  95.193  12.531  1.00 43.46           O  
ATOM    102  N   GLY A  14     -31.975  93.046  17.999  1.00 28.40           N  
ATOM    103  CA  GLY A  14     -31.110  92.571  19.089  1.00 27.32           C  
ATOM    104  C   GLY A  14     -29.936  93.456  19.578  1.00 25.67           C  
ATOM    105  O   GLY A  14     -29.035  92.974  20.257  1.00 26.49           O  
ATOM    106  N   PHE A  15     -29.932  94.732  19.232  1.00 24.07           N  
ATOM    107  CA  PHE A  15     -28.830  95.625  19.554  1.00 23.33           C  
ATOM    108  C   PHE A  15     -29.331  97.070  19.568  1.00 22.68           C  
ATOM    109  O   PHE A  15     -30.372  97.423  18.943  1.00 22.43           O  
ATOM    110  CB  PHE A  15     -27.609  95.448  18.588  1.00 22.90           C  
ATOM    111  CG  PHE A  15     -27.836  96.001  17.159  1.00 24.80           C  
ATOM    112  CD1 PHE A  15     -27.379  97.262  16.806  1.00 25.12           C  
ATOM    113  CD2 PHE A  15     -28.476  95.209  16.188  1.00 25.56           C  
ATOM    114  CE1 PHE A  15     -27.581  97.759  15.496  1.00 28.23           C  
ATOM    115  CE2 PHE A  15     -28.677  95.666  14.900  1.00 26.70           C  
ATOM    116  CZ  PHE A  15     -28.232  96.963  14.558  1.00 26.36           C  
ATOM    117  N   THR A  16     -28.611  97.899  20.308  1.00 20.77           N  
ATOM    118  CA  THR A  16     -28.841  99.322  20.301  1.00 20.45           C  
ATOM    119  C   THR A  16     -27.825 100.023  19.429  1.00 19.90           C  
ATOM    120  O   THR A  16     -26.605  99.774  19.509  1.00 17.57           O  
ATOM    121  CB  THR A  16     -28.863  99.885  21.738  1.00 19.70           C  
ATOM    122  OG1 THR A  16     -30.006  99.341  22.399  1.00 22.29           O  
ATOM    123  CG2 THR A  16     -28.960 101.441  21.766  1.00 18.70           C  
ATOM    124  N   HIS A  17     -28.344 100.885  18.574  1.00 18.81           N  
ATOM    125  CA  HIS A  17     -27.505 101.726  17.764  1.00 18.76           C  
ATOM    126  C   HIS A  17     -27.555 103.174  18.244  1.00 18.02           C  
ATOM    127  O   HIS A  17     -28.595 103.868  18.219  1.00 17.98           O  
ATOM    128  CB  HIS A  17     -27.923 101.580  16.282  1.00 19.50           C  
ATOM    129  CG  HIS A  17     -26.981 102.205  15.305  1.00 18.77           C  
ATOM    130  ND1 HIS A  17     -27.266 102.248  13.944  1.00 21.39           N  
ATOM    131  CD2 HIS A  17     -25.751 102.770  15.450  1.00 16.21           C  
ATOM    132  CE1 HIS A  17     -26.257 102.820  13.302  1.00 19.88           C  
ATOM    133  NE2 HIS A  17     -25.334 103.165  14.190  1.00 20.81           N  
ATOM    134  N   ILE A  18     -26.399 103.654  18.672  1.00 17.92           N  
ATOM    135  CA  ILE A  18     -26.230 105.031  19.109  1.00 18.47           C  
ATOM    136  C   ILE A  18     -25.429 105.759  18.048  1.00 19.42           C  
ATOM    137  O   ILE A  18     -24.315 105.342  17.666  1.00 18.86           O  
ATOM    138  CB  ILE A  18     -25.447 105.111  20.433  1.00 19.75           C  
ATOM    139  CG1 ILE A  18     -26.192 104.338  21.542  1.00 19.27           C  
ATOM    140  CG2 ILE A  18     -25.204 106.559  20.830  1.00 18.50           C  
ATOM    141  CD1 ILE A  18     -25.382 104.159  22.807  1.00 19.86           C  
ATOM    142  N   LEU A  19     -25.998 106.846  17.576  1.00 19.07           N  
ATOM    143  CA  LEU A  19     -25.331 107.680  16.573  1.00 20.77           C  
ATOM    144  C   LEU A  19     -25.072 109.068  17.109  1.00 19.80           C  
ATOM    145  O   LEU A  19     -26.010 109.767  17.540  1.00 21.18           O  
ATOM    146  CB  LEU A  19     -26.187 107.765  15.279  1.00 20.84           C  
ATOM    147  CG  LEU A  19     -26.576 106.434  14.656  1.00 21.57           C  
ATOM    148  CD1 LEU A  19     -27.923 105.909  15.114  1.00 25.30           C  
ATOM    149  CD2 LEU A  19     -26.577 106.667  13.109  1.00 27.42           C  
ATOM    150  N   LEU A  20     -23.800 109.470  17.122  1.00 19.90           N  
ATOM    151  CA  LEU A  20     -23.403 110.808  17.525  1.00 21.37           C  
ATOM    152  C   LEU A  20     -23.874 111.777  16.453  1.00 22.22           C  
ATOM    153  O   LEU A  20     -23.615 111.560  15.253  1.00 19.26           O  
ATOM    154  CB  LEU A  20     -21.878 110.922  17.665  1.00 21.23           C  
ATOM    155  CG  LEU A  20     -21.200 110.104  18.742  1.00 25.37           C  
ATOM    156  CD1 LEU A  20     -19.762 110.684  18.861  1.00 25.68           C  
ATOM    157  CD2 LEU A  20     -21.922 110.320  20.063  1.00 27.91           C  
ATOM    158  N   SER A  21     -24.595 112.820  16.884  1.00 22.67           N  
ATOM    159  CA  SER A  21     -25.191 113.763  15.942  1.00 23.34           C  
ATOM    160  C   SER A  21     -25.405 115.102  16.642  1.00 23.14           C  
ATOM    161  O   SER A  21     -26.549 115.507  16.885  1.00 23.79           O  
ATOM    162  CB  SER A  21     -26.534 113.218  15.415  1.00 24.38           C  
ATOM    163  OG  SER A  21     -26.892 113.968  14.277  1.00 27.19           O  
ATOM    164  N   THR A  22     -24.320 115.769  16.981  1.00 23.49           N  
ATOM    165  CA  THR A  22     -24.370 116.791  18.029  1.00 24.44           C  
ATOM    166  C   THR A  22     -24.949 118.090  17.462  1.00 25.00           C  
ATOM    167  O   THR A  22     -24.670 118.478  16.307  1.00 22.43           O  
ATOM    168  CB  THR A  22     -23.044 117.052  18.720  1.00 23.83           C  
ATOM    169  OG1 THR A  22     -22.163 117.724  17.819  1.00 27.23           O  
ATOM    170  CG2 THR A  22     -22.374 115.742  19.273  1.00 24.33           C  
ATOM    171  N   LYS A  23     -25.820 118.692  18.261  1.00 26.41           N  
ATOM    172  CA  LYS A  23     -26.469 119.971  17.927  1.00 28.64           C  
ATOM    173  C   LYS A  23     -26.066 121.063  18.930  1.00 30.07           C  
ATOM    174  O   LYS A  23     -25.937 122.230  18.558  1.00 30.24           O  
ATOM    175  CB  LYS A  23     -27.978 119.793  17.852  1.00 28.53           C  
ATOM    176  CG  LYS A  23     -28.449 118.685  16.943  1.00 29.66           C  
ATOM    177  CD  LYS A  23     -28.230 118.999  15.412  1.00 36.93           C  
ATOM    178  CE  LYS A  23     -28.629 117.780  14.538  1.00 38.03           C  
ATOM    179  NZ  LYS A  23     -27.594 117.408  13.461  1.00 42.14           N  
ATOM    180  N   SER A  24     -25.804 120.695  20.187  1.00 30.65           N  
ATOM    181  CA  SER A  24     -25.266 121.660  21.177  1.00 31.13           C  
ATOM    182  C   SER A  24     -23.782 122.006  20.970  1.00 31.87           C  
ATOM    183  O   SER A  24     -23.238 122.937  21.599  1.00 32.71           O  
ATOM    184  CB  SER A  24     -25.466 121.145  22.603  1.00 31.39           C  
ATOM    185  OG  SER A  24     -24.620 120.047  22.844  1.00 31.03           O  
ATOM    186  N   SER A  25     -23.116 121.256  20.101  1.00 31.75           N  
ATOM    187  CA  SER A  25     -21.726 121.515  19.749  1.00 32.74           C  
ATOM    188  C   SER A  25     -21.588 121.149  18.265  1.00 32.25           C  
ATOM    189  O   SER A  25     -22.360 120.353  17.741  1.00 31.36           O  
ATOM    190  CB  SER A  25     -20.801 120.620  20.580  1.00 34.13           C  
ATOM    191  OG  SER A  25     -21.046 119.237  20.224  1.00 37.44           O  
ATOM    192  N   GLU A  26     -20.618 121.736  17.596  1.00 31.42           N  
ATOM    193  CA  GLU A  26     -20.413 121.478  16.180  1.00 31.65           C  
ATOM    194  C   GLU A  26     -19.556 120.256  15.948  1.00 29.83           C  
ATOM    195  O   GLU A  26     -18.684 119.893  16.775  1.00 28.19           O  
ATOM    196  CB  GLU A  26     -19.731 122.694  15.539  1.00 31.05           C  
ATOM    197  CG  GLU A  26     -20.724 123.798  15.152  1.00 34.00           C  
ATOM    198  CD  GLU A  26     -20.037 125.040  14.604  1.00 35.00           C  
ATOM    199  OE1 GLU A  26     -18.871 124.952  14.125  1.00 40.45           O  
ATOM    200  OE2 GLU A  26     -20.698 126.113  14.616  1.00 41.85           O  
ATOM    201  N   ASN A  27     -19.796 119.603  14.806  1.00 27.88           N  
ATOM    202  CA  ASN A  27     -18.894 118.574  14.315  1.00 28.05           C  
ATOM    203  C   ASN A  27     -18.687 117.412  15.262  1.00 25.54           C  
ATOM    204  O   ASN A  27     -17.565 116.929  15.406  1.00 26.96           O  
ATOM    205  CB  ASN A  27     -17.540 119.179  14.005  1.00 29.59           C  
ATOM    206  CG  ASN A  27     -17.549 119.953  12.708  1.00 35.29           C  
ATOM    207  OD1 ASN A  27     -18.585 120.043  12.017  1.00 36.67           O  
ATOM    208  ND2 ASN A  27     -16.397 120.507  12.361  1.00 40.95           N  
ATOM    209  N   ASN A  28     -19.763 116.967  15.892  1.00 23.13           N  
ATOM    210  CA  ASN A  28     -19.680 115.901  16.894  1.00 24.00           C  
ATOM    211  C   ASN A  28     -18.581 116.120  17.917  1.00 23.38           C  
ATOM    212  O   ASN A  28     -17.848 115.162  18.286  1.00 25.70           O  
ATOM    213  CB  ASN A  28     -19.555 114.516  16.239  1.00 22.06           C  
ATOM    214  CG  ASN A  28     -20.844 114.093  15.590  1.00 24.54           C  
ATOM    215  OD1 ASN A  28     -21.917 114.546  16.011  1.00 21.60           O  
ATOM    216  ND2 ASN A  28     -20.767 113.265  14.536  1.00 26.05           N  
ATOM    217  N   SER A  29     -18.489 117.346  18.422  1.00 22.46           N  
ATOM    218  CA  SER A  29     -17.570 117.649  19.525  1.00 23.98           C  
ATOM    219  C   SER A  29     -18.248 117.291  20.851  1.00 22.31           C  
ATOM    220  O   SER A  29     -19.468 117.293  20.955  1.00 22.54           O  
ATOM    221  CB  SER A  29     -17.264 119.131  19.578  1.00 24.26           C  
ATOM    222  OG  SER A  29     -16.718 119.548  18.368  1.00 35.17           O  
ATOM    223  N   LEU A  30     -17.459 117.041  21.877  1.00 22.82           N  
ATOM    224  CA  LEU A  30     -18.015 116.655  23.184  1.00 24.17           C  
ATOM    225  C   LEU A  30     -18.085 117.872  24.111  1.00 24.56           C  
ATOM    226  O   LEU A  30     -17.178 118.724  24.149  1.00 25.96           O  
ATOM    227  CB  LEU A  30     -17.197 115.522  23.843  1.00 23.72           C  
ATOM    228  CG  LEU A  30     -16.979 114.287  22.959  1.00 25.18           C  
ATOM    229  CD1 LEU A  30     -16.046 113.281  23.615  1.00 29.34           C  
ATOM    230  CD2 LEU A  30     -18.374 113.688  22.551  1.00 27.34           C  
ATOM    231  N   ASN A  31     -19.208 117.988  24.782  1.00 25.08           N  
ATOM    232  CA  ASN A  31     -19.347 118.863  25.936  1.00 24.57           C  
ATOM    233  C   ASN A  31     -20.047 118.041  27.058  1.00 25.07           C  
ATOM    234  O   ASN A  31     -20.464 116.881  26.814  1.00 23.89           O  
ATOM    235  CB  ASN A  31     -20.080 120.131  25.523  1.00 25.03           C  
ATOM    236  CG  ASN A  31     -21.446 119.860  25.022  1.00 24.95           C  
ATOM    237  OD1 ASN A  31     -22.175 119.048  25.582  1.00 29.32           O  
ATOM    238  ND2 ASN A  31     -21.808 120.490  23.942  1.00 26.71           N  
ATOM    239  N   PRO A  32     -20.142 118.587  28.300  1.00 24.92           N  
ATOM    240  CA  PRO A  32     -20.821 117.717  29.281  1.00 24.68           C  
ATOM    241  C   PRO A  32     -22.247 117.234  28.950  1.00 22.97           C  
ATOM    242  O   PRO A  32     -22.589 116.143  29.345  1.00 21.90           O  
ATOM    243  CB  PRO A  32     -20.769 118.536  30.612  1.00 24.46           C  
ATOM    244  CG  PRO A  32     -19.578 119.494  30.413  1.00 26.17           C  
ATOM    245  CD  PRO A  32     -19.648 119.833  28.926  1.00 24.33           C  
ATOM    246  N   GLU A  33     -23.037 118.037  28.239  0.50 22.80           N  
ATOM    248  CA  GLU A  33     -24.390 117.642  27.808  0.50 22.90           C  
ATOM    250  C   GLU A  33     -24.369 116.420  26.844  0.50 22.49           C  
ATOM    252  O   GLU A  33     -25.182 115.486  26.985  0.50 20.43           O  
ATOM    254  CB  GLU A  33     -25.122 118.823  27.119  0.50 23.83           C  
ATOM    256  CG  GLU A  33     -25.218 120.175  27.893  0.50 26.91           C  
ATOM    258  CD  GLU A  33     -24.117 121.197  27.540  0.50 31.63           C  
ATOM    260  OE1 GLU A  33     -22.986 121.092  28.074  0.50 29.15           O  
ATOM    262  OE2 GLU A  33     -24.396 122.126  26.734  0.50 32.46           O  
ATOM    264  N   VAL A  34     -23.463 116.442  25.849  1.00 22.02           N  
ATOM    265  CA  VAL A  34     -23.308 115.294  24.924  1.00 21.73           C  
ATOM    266  C   VAL A  34     -22.857 114.039  25.697  1.00 20.19           C  
ATOM    267  O   VAL A  34     -23.386 112.968  25.499  1.00 19.43           O  
ATOM    268  CB  VAL A  34     -22.358 115.580  23.728  1.00 22.09           C  
ATOM    269  CG1 VAL A  34     -22.335 114.381  22.702  1.00 23.96           C  
ATOM    270  CG2 VAL A  34     -22.770 116.869  23.042  1.00 22.33           C  
ATOM    271  N   MET A  35     -21.876 114.207  26.559  1.00 20.37           N  
ATOM    272  CA  MET A  35     -21.319 113.130  27.348  1.00 23.63           C  
ATOM    273  C   MET A  35     -22.404 112.471  28.208  1.00 22.95           C  
ATOM    274  O   MET A  35     -22.450 111.243  28.314  1.00 22.22           O  
ATOM    275  CB  MET A  35     -20.144 113.631  28.188  1.00 22.84           C  
ATOM    276  CG  MET A  35     -18.829 113.867  27.405  1.00 25.14           C  
ATOM    277  SD  MET A  35     -17.609 114.640  28.486  1.00 31.54           S  
ATOM    278  CE  MET A  35     -16.981 115.966  27.448  1.00 31.67           C  
ATOM    279  N   ARG A  36     -23.295 113.280  28.781  1.00 22.13           N  
ATOM    280  CA  ARG A  36     -24.387 112.751  29.618  1.00 22.11           C  
ATOM    281  C   ARG A  36     -25.415 111.951  28.867  1.00 20.48           C  
ATOM    282  O   ARG A  36     -25.868 110.927  29.375  1.00 19.45           O  
ATOM    283  CB  ARG A  36     -25.074 113.867  30.406  1.00 21.43           C  
ATOM    284  CG  ARG A  36     -24.199 114.159  31.658  1.00 27.02           C  
ATOM    285  CD  ARG A  36     -24.922 115.035  32.647  1.00 34.17           C  
ATOM    286  NE  ARG A  36     -23.920 115.672  33.474  1.00 46.01           N  
ATOM    287  CZ  ARG A  36     -23.553 116.943  33.346  1.00 49.68           C  
ATOM    288  NH1 ARG A  36     -24.163 117.739  32.459  1.00 52.68           N  
ATOM    289  NH2 ARG A  36     -22.598 117.423  34.130  1.00 53.48           N  
ATOM    290  N   GLU A  37     -25.778 112.434  27.675  1.00 19.87           N  
ATOM    291  CA  GLU A  37     -26.664 111.684  26.820  1.00 21.92           C  
ATOM    292  C   GLU A  37     -26.087 110.318  26.377  1.00 19.43           C  
ATOM    293  O   GLU A  37     -26.811 109.333  26.381  1.00 18.28           O  
ATOM    294  CB  GLU A  37     -27.141 112.493  25.597  1.00 20.83           C  
ATOM    295  CG  GLU A  37     -27.921 113.814  25.886  1.00 25.95           C  
ATOM    296  CD  GLU A  37     -28.511 114.403  24.632  1.00 25.60           C  
ATOM    297  OE1 GLU A  37     -28.129 113.929  23.535  1.00 28.33           O  
ATOM    298  OE2 GLU A  37     -29.426 115.268  24.712  1.00 31.98           O  
ATOM    299  N   VAL A  38     -24.819 110.249  25.947  1.00 19.86           N  
ATOM    300  CA  VAL A  38     -24.171 108.946  25.697  1.00 17.98           C  
ATOM    301  C   VAL A  38     -24.224 108.051  26.939  1.00 18.67           C  
ATOM    302  O   VAL A  38     -24.572 106.869  26.852  1.00 18.15           O  
ATOM    303  CB  VAL A  38     -22.701 109.102  25.156  1.00 18.77           C  
ATOM    304  CG1 VAL A  38     -22.069 107.718  24.929  1.00 14.88           C  
ATOM    305  CG2 VAL A  38     -22.680 109.960  23.836  1.00 19.07           C  
ATOM    306  N   GLN A  39     -23.887 108.588  28.116  1.00 17.70           N  
ATOM    307  CA  GLN A  39     -23.962 107.755  29.324  1.00 19.55           C  
ATOM    308  C   GLN A  39     -25.377 107.235  29.554  1.00 19.21           C  
ATOM    309  O   GLN A  39     -25.551 106.058  29.792  1.00 20.99           O  
ATOM    310  CB  GLN A  39     -23.512 108.554  30.551  1.00 20.13           C  
ATOM    311  CG  GLN A  39     -22.030 108.776  30.539  1.00 21.49           C  
ATOM    312  CD  GLN A  39     -21.615 109.896  31.458  1.00 28.60           C  
ATOM    313  OE1 GLN A  39     -21.949 109.877  32.690  1.00 28.09           O  
ATOM    314  NE2 GLN A  39     -20.920 110.885  30.894  1.00 20.88           N  
ATOM    315  N   SER A  40     -26.387 108.107  29.417  1.00 20.54           N  
ATOM    316  CA  SER A  40     -27.793 107.682  29.570  1.00 21.02           C  
ATOM    317  C   SER A  40     -28.147 106.596  28.539  1.00 20.57           C  
ATOM    318  O   SER A  40     -28.755 105.591  28.876  1.00 20.05           O  
ATOM    319  CB  SER A  40     -28.759 108.862  29.473  1.00 20.99           C  
ATOM    320  OG  SER A  40     -30.138 108.412  29.498  1.00 27.54           O  
ATOM    321  N   ALA A  41     -27.777 106.794  27.281  1.00 18.69           N  
ATOM    322  CA  ALA A  41     -28.096 105.767  26.273  1.00 18.53           C  
ATOM    323  C   ALA A  41     -27.413 104.400  26.551  1.00 17.26           C  
ATOM    324  O   ALA A  41     -28.059 103.336  26.364  1.00 20.22           O  
ATOM    325  CB  ALA A  41     -27.825 106.294  24.843  1.00 16.99           C  
ATOM    326  N   LEU A  42     -26.149 104.419  26.982  1.00 16.66           N  
ATOM    327  CA  LEU A  42     -25.408 103.218  27.316  1.00 17.23           C  
ATOM    328  C   LEU A  42     -25.993 102.563  28.586  1.00 18.57           C  
ATOM    329  O   LEU A  42     -26.089 101.336  28.651  1.00 18.10           O  
ATOM    330  CB  LEU A  42     -23.913 103.495  27.555  1.00 17.36           C  
ATOM    331  CG  LEU A  42     -23.040 103.690  26.301  1.00 16.70           C  
ATOM    332  CD1 LEU A  42     -21.706 104.212  26.727  1.00 17.77           C  
ATOM    333  CD2 LEU A  42     -22.964 102.375  25.548  1.00 17.75           C  
ATOM    334  N   SER A  43     -26.356 103.384  29.573  1.00 19.86           N  
ATOM    335  CA  SER A  43     -27.082 102.861  30.782  1.00 22.63           C  
ATOM    336  C   SER A  43     -28.337 102.068  30.477  1.00 22.82           C  
ATOM    337  O   SER A  43     -28.533 100.953  31.034  1.00 23.43           O  
ATOM    338  CB  SER A  43     -27.473 103.984  31.728  1.00 23.76           C  
ATOM    339  OG  SER A  43     -26.273 104.519  32.221  1.00 30.93           O  
ATOM    340  N   THR A  44     -29.181 102.624  29.591  1.00 22.64           N  
ATOM    341  CA  THR A  44     -30.378 101.900  29.135  1.00 22.40           C  
ATOM    342  C   THR A  44     -30.012 100.575  28.415  1.00 22.26           C  
ATOM    343  O   THR A  44     -30.677  99.518  28.650  1.00 20.71           O  
ATOM    344  CB  THR A  44     -31.242 102.812  28.256  1.00 23.13           C  
ATOM    345  OG1 THR A  44     -31.619 103.969  28.992  1.00 23.54           O  
ATOM    346  CG2 THR A  44     -32.523 102.138  27.734  1.00 24.66           C  
ATOM    347  N   ALA A  45     -29.006 100.623  27.497  1.00 21.80           N  
ATOM    348  CA  ALA A  45     -28.606  99.430  26.756  1.00 20.37           C  
ATOM    349  C   ALA A  45     -28.048  98.386  27.709  1.00 20.42           C  
ATOM    350  O   ALA A  45     -28.200  97.199  27.485  1.00 20.95           O  
ATOM    351  CB  ALA A  45     -27.548  99.791  25.681  1.00 20.09           C  
ATOM    352  N   ALA A  46     -27.422  98.827  28.792  1.00 20.61           N  
ATOM    353  CA  ALA A  46     -26.809  97.865  29.707  1.00 21.35           C  
ATOM    354  C   ALA A  46     -27.927  97.102  30.463  1.00 22.82           C  
ATOM    355  O   ALA A  46     -27.779  95.922  30.800  1.00 23.33           O  
ATOM    356  CB  ALA A  46     -25.836  98.563  30.694  1.00 20.77           C  
ATOM    357  N   ALA A  47     -29.061  97.756  30.617  1.00 23.93           N  
ATOM    358  CA  ALA A  47     -30.167  97.184  31.399  1.00 25.68           C  
ATOM    359  C   ALA A  47     -31.249  96.524  30.536  1.00 25.53           C  
ATOM    360  O   ALA A  47     -32.093  95.841  31.062  1.00 27.64           O  
ATOM    361  CB  ALA A  47     -30.790  98.266  32.341  1.00 23.44           C  
ATOM    362  N   ASP A  48     -31.275  96.728  29.219  1.00 25.91           N  
ATOM    363  CA  ASP A  48     -32.357  96.137  28.455  1.00 25.05           C  
ATOM    364  C   ASP A  48     -31.897  94.858  27.763  1.00 24.39           C  
ATOM    365  O   ASP A  48     -30.829  94.356  28.084  1.00 23.13           O  
ATOM    366  CB  ASP A  48     -33.077  97.160  27.545  1.00 26.28           C  
ATOM    367  CG  ASP A  48     -32.178  97.708  26.393  1.00 29.11           C  
ATOM    368  OD1 ASP A  48     -31.128  97.100  26.129  1.00 27.52           O  
ATOM    369  OD2 ASP A  48     -32.581  98.736  25.771  1.00 29.38           O  
ATOM    370  N   ASP A  49     -32.656  94.322  26.806  1.00 24.70           N  
ATOM    371  CA  ASP A  49     -32.221  93.067  26.223  1.00 25.50           C  
ATOM    372  C   ASP A  49     -31.212  93.184  25.066  1.00 25.44           C  
ATOM    373  O   ASP A  49     -30.898  92.162  24.422  1.00 25.96           O  
ATOM    374  CB  ASP A  49     -33.390  92.186  25.827  1.00 26.81           C  
ATOM    375  CG  ASP A  49     -34.271  92.805  24.788  1.00 31.72           C  
ATOM    376  OD1 ASP A  49     -33.990  93.910  24.260  1.00 37.36           O  
ATOM    377  OD2 ASP A  49     -35.300  92.170  24.495  1.00 39.49           O  
ATOM    378  N   SER A  50     -30.777  94.409  24.755  1.00 24.63           N  
ATOM    379  CA  SER A  50     -29.680  94.613  23.812  1.00 23.08           C  
ATOM    380  C   SER A  50     -28.575  93.603  24.007  1.00 23.09           C  
ATOM    381  O   SER A  50     -28.060  93.401  25.145  1.00 21.59           O  
ATOM    382  CB  SER A  50     -29.074  96.023  23.977  1.00 23.79           C  
ATOM    383  OG  SER A  50     -30.004  97.015  23.608  1.00 23.56           O  
ATOM    384  N   LYS A  51     -28.153  92.963  22.908  1.00 23.44           N  
ATOM    385  CA  LYS A  51     -27.027  92.016  23.005  1.00 22.74           C  
ATOM    386  C   LYS A  51     -25.680  92.734  22.929  1.00 20.71           C  
ATOM    387  O   LYS A  51     -24.664  92.194  23.333  1.00 19.81           O  
ATOM    388  CB  LYS A  51     -27.116  90.983  21.866  1.00 23.96           C  
ATOM    389  CG  LYS A  51     -28.433  90.206  21.845  1.00 26.42           C  
ATOM    390  CD  LYS A  51     -28.297  88.983  20.962  1.00 32.27           C  
ATOM    391  CE  LYS A  51     -29.538  88.069  20.997  1.00 32.97           C  
ATOM    392  NZ  LYS A  51     -29.240  86.685  20.314  1.00 34.59           N  
ATOM    393  N   LEU A  52     -25.686  93.915  22.307  1.00 19.58           N  
ATOM    394  CA  LEU A  52     -24.499  94.716  22.064  1.00 19.58           C  
ATOM    395  C   LEU A  52     -24.918  96.141  21.647  1.00 18.66           C  
ATOM    396  O   LEU A  52     -26.103  96.420  21.377  1.00 17.26           O  
ATOM    397  CB  LEU A  52     -23.598  94.082  20.963  1.00 18.90           C  
ATOM    398  CG  LEU A  52     -24.244  94.052  19.556  1.00 24.98           C  
ATOM    399  CD1 LEU A  52     -23.990  95.331  18.740  1.00 26.43           C  
ATOM    400  CD2 LEU A  52     -23.825  92.794  18.769  1.00 28.84           C  
ATOM    401  N   VAL A  53     -23.952  97.059  21.630  1.00 17.48           N  
ATOM    402  CA  VAL A  53     -24.177  98.427  21.148  1.00 16.63           C  
ATOM    403  C   VAL A  53     -23.324  98.682  19.946  1.00 16.98           C  
ATOM    404  O   VAL A  53     -22.110  98.362  19.923  1.00 16.08           O  
ATOM    405  CB  VAL A  53     -23.720  99.427  22.225  1.00 18.23           C  
ATOM    406  CG1 VAL A  53     -23.697 100.880  21.719  1.00 17.37           C  
ATOM    407  CG2 VAL A  53     -24.636  99.264  23.475  1.00 18.69           C  
ATOM    408  N   LEU A  54     -23.927  99.276  18.941  1.00 15.56           N  
ATOM    409  CA  LEU A  54     -23.151  99.791  17.828  1.00 16.55           C  
ATOM    410  C   LEU A  54     -23.125 101.313  17.982  1.00 17.09           C  
ATOM    411  O   LEU A  54     -24.173 101.983  18.077  1.00 17.44           O  
ATOM    412  CB  LEU A  54     -23.819  99.402  16.469  1.00 16.15           C  
ATOM    413  CG  LEU A  54     -23.228 100.127  15.255  1.00 15.78           C  
ATOM    414  CD1 LEU A  54     -21.774  99.667  15.023  1.00 18.17           C  
ATOM    415  CD2 LEU A  54     -24.146  99.815  14.020  1.00 18.16           C  
ATOM    416  N   LEU A  55     -21.924 101.872  18.034  1.00 16.82           N  
ATOM    417  CA  LEU A  55     -21.736 103.308  18.088  1.00 17.42           C  
ATOM    418  C   LEU A  55     -21.187 103.824  16.727  1.00 17.64           C  
ATOM    419  O   LEU A  55     -20.172 103.362  16.229  1.00 19.25           O  
ATOM    420  CB  LEU A  55     -20.733 103.623  19.154  1.00 17.19           C  
ATOM    421  CG  LEU A  55     -20.367 105.080  19.312  1.00 19.30           C  
ATOM    422  CD1 LEU A  55     -21.574 105.914  19.738  1.00 14.01           C  
ATOM    423  CD2 LEU A  55     -19.194 105.098  20.316  1.00 20.40           C  
ATOM    424  N   SER A  56     -21.872 104.781  16.148  1.00 18.42           N  
ATOM    425  CA  SER A  56     -21.374 105.394  14.907  1.00 18.76           C  
ATOM    426  C   SER A  56     -21.709 106.890  14.907  1.00 19.74           C  
ATOM    427  O   SER A  56     -22.133 107.431  15.922  1.00 17.59           O  
ATOM    428  CB  SER A  56     -21.937 104.639  13.696  1.00 18.57           C  
ATOM    429  OG  SER A  56     -23.313 104.908  13.541  1.00 21.79           O  
ATOM    430  N   ALA A  57     -21.508 107.592  13.790  1.00 19.30           N  
ATOM    431  CA  ALA A  57     -21.716 109.036  13.794  1.00 21.00           C  
ATOM    432  C   ALA A  57     -22.446 109.461  12.523  1.00 22.53           C  
ATOM    433  O   ALA A  57     -22.262 108.848  11.462  1.00 21.57           O  
ATOM    434  CB  ALA A  57     -20.386 109.770  13.896  1.00 20.60           C  
ATOM    435  N   VAL A  58     -23.301 110.476  12.665  1.00 23.09           N  
ATOM    436  CA  VAL A  58     -23.918 111.139  11.539  1.00 24.50           C  
ATOM    437  C   VAL A  58     -22.970 112.213  10.998  1.00 25.12           C  
ATOM    438  O   VAL A  58     -22.392 112.999  11.772  1.00 24.47           O  
ATOM    439  CB  VAL A  58     -25.281 111.754  11.974  1.00 25.38           C  
ATOM    440  CG1 VAL A  58     -25.973 112.461  10.823  1.00 26.67           C  
ATOM    441  CG2 VAL A  58     -26.193 110.668  12.590  1.00 22.68           C  
ATOM    442  N   GLY A  59     -22.800 112.256   9.661  1.00 24.95           N  
ATOM    443  CA  GLY A  59     -22.009 113.308   9.014  1.00 24.19           C  
ATOM    444  C   GLY A  59     -20.549 112.940   8.800  1.00 25.10           C  
ATOM    445  O   GLY A  59     -20.206 111.769   8.883  1.00 25.35           O  
ATOM    446  N   SER A  60     -19.707 113.917   8.461  1.00 23.29           N  
ATOM    447  CA  SER A  60     -18.382 113.637   7.981  1.00 23.59           C  
ATOM    448  C   SER A  60     -17.315 113.536   9.079  1.00 23.01           C  
ATOM    449  O   SER A  60     -16.185 113.246   8.758  1.00 21.84           O  
ATOM    450  CB  SER A  60     -17.909 114.714   7.029  1.00 25.12           C  
ATOM    451  OG  SER A  60     -17.907 115.955   7.697  1.00 28.78           O  
ATOM    452  N   VAL A  61     -17.682 113.722  10.362  1.00 22.20           N  
ATOM    453  CA  VAL A  61     -16.679 113.633  11.476  1.00 22.03           C  
ATOM    454  C   VAL A  61     -17.198 112.563  12.437  1.00 21.82           C  
ATOM    455  O   VAL A  61     -18.362 112.556  12.761  1.00 21.69           O  
ATOM    456  CB  VAL A  61     -16.513 115.011  12.229  1.00 22.61           C  
ATOM    457  CG1 VAL A  61     -15.688 114.885  13.602  1.00 21.11           C  
ATOM    458  CG2 VAL A  61     -15.841 116.039  11.323  1.00 25.19           C  
ATOM    459  N   PHE A  62     -16.350 111.650  12.889  1.00 19.35           N  
ATOM    460  CA  PHE A  62     -16.838 110.705  13.911  1.00 19.92           C  
ATOM    461  C   PHE A  62     -17.022 111.490  15.229  1.00 19.56           C  
ATOM    462  O   PHE A  62     -18.135 111.537  15.785  1.00 18.79           O  
ATOM    463  CB  PHE A  62     -15.836 109.556  14.085  1.00 20.24           C  
ATOM    464  CG  PHE A  62     -16.179 108.629  15.230  1.00 18.75           C  
ATOM    465  CD1 PHE A  62     -17.274 107.761  15.127  1.00 19.61           C  
ATOM    466  CD2 PHE A  62     -15.441 108.671  16.452  1.00 18.72           C  
ATOM    467  CE1 PHE A  62     -17.619 106.896  16.245  1.00 21.37           C  
ATOM    468  CE2 PHE A  62     -15.798 107.851  17.518  1.00 19.23           C  
ATOM    469  CZ  PHE A  62     -16.883 106.955  17.406  1.00 19.11           C  
ATOM    470  N   CYS A  63     -15.921 112.113  15.679  1.00 21.10           N  
ATOM    471  CA  CYS A  63     -15.873 112.828  16.978  1.00 21.28           C  
ATOM    472  C   CYS A  63     -14.618 113.661  17.089  1.00 22.92           C  
ATOM    473  O   CYS A  63     -13.500 113.128  17.028  1.00 23.16           O  
ATOM    474  CB  CYS A  63     -16.038 111.850  18.166  1.00 22.18           C  
ATOM    475  SG  CYS A  63     -16.018 112.750  19.779  1.00 22.23           S  
ATOM    476  N   CYS A  64     -14.808 114.988  17.189  1.00 24.77           N  
ATOM    477  CA  CYS A  64     -13.750 116.002  17.340  1.00 27.62           C  
ATOM    478  C   CYS A  64     -13.160 116.109  18.741  1.00 25.93           C  
ATOM    479  O   CYS A  64     -12.257 116.912  18.952  1.00 26.26           O  
ATOM    480  CB  CYS A  64     -14.330 117.401  17.044  1.00 29.10           C  
ATOM    481  SG  CYS A  64     -13.804 117.956  15.566  1.00 46.52           S  
ATOM    482  N   GLY A  65     -13.636 115.311  19.689  1.00 24.56           N  
ATOM    483  CA  GLY A  65     -13.145 115.377  21.072  1.00 24.48           C  
ATOM    484  C   GLY A  65     -13.738 116.608  21.725  1.00 24.15           C  
ATOM    485  O   GLY A  65     -14.763 117.123  21.288  1.00 22.25           O  
ATOM    486  N   LEU A  66     -13.062 117.089  22.749  1.00 23.75           N  
ATOM    487  CA  LEU A  66     -13.610 118.135  23.586  1.00 25.22           C  
ATOM    488  C   LEU A  66     -13.865 119.430  22.782  1.00 24.08           C  
ATOM    489  O   LEU A  66     -12.997 119.825  22.004  1.00 23.97           O  
ATOM    490  CB  LEU A  66     -12.528 118.405  24.615  1.00 26.03           C  
ATOM    491  CG  LEU A  66     -12.758 118.282  26.084  1.00 30.93           C  
ATOM    492  CD1 LEU A  66     -12.713 119.680  26.715  1.00 32.27           C  
ATOM    493  CD2 LEU A  66     -14.028 117.501  26.377  1.00 35.46           C  
ATOM    494  N   ASP A  67     -15.004 120.099  22.978  1.00 24.46           N  
ATOM    495  CA  ASP A  67     -15.248 121.450  22.380  1.00 25.34           C  
ATOM    496  C   ASP A  67     -14.562 122.514  23.265  1.00 26.01           C  
ATOM    497  O   ASP A  67     -15.161 122.945  24.281  1.00 25.66           O  
ATOM    498  CB  ASP A  67     -16.749 121.697  22.331  1.00 24.28           C  
ATOM    499  CG  ASP A  67     -17.142 123.067  21.722  1.00 27.69           C  
ATOM    500  OD1 ASP A  67     -16.306 123.977  21.561  1.00 28.23           O  
ATOM    501  OD2 ASP A  67     -18.353 123.247  21.438  1.00 30.32           O  
ATOM    502  N   PHE A  68     -13.322 122.885  22.916  1.00 26.60           N  
ATOM    503  CA  PHE A  68     -12.530 123.852  23.689  1.00 27.97           C  
ATOM    504  C   PHE A  68     -13.068 125.300  23.687  1.00 28.29           C  
ATOM    505  O   PHE A  68     -12.837 126.048  24.636  1.00 27.54           O  
ATOM    506  CB  PHE A  68     -11.078 123.811  23.257  1.00 28.97           C  
ATOM    507  CG  PHE A  68     -10.296 122.742  23.946  1.00 30.59           C  
ATOM    508  CD1 PHE A  68      -9.652 122.996  25.148  1.00 33.83           C  
ATOM    509  CD2 PHE A  68     -10.230 121.470  23.411  1.00 34.22           C  
ATOM    510  CE1 PHE A  68      -8.942 121.993  25.791  1.00 36.04           C  
ATOM    511  CE2 PHE A  68      -9.519 120.450  24.059  1.00 35.44           C  
ATOM    512  CZ  PHE A  68      -8.898 120.710  25.240  1.00 34.08           C  
ATOM    513  N   ILE A  69     -13.739 125.703  22.620  1.00 28.15           N  
ATOM    514  CA  ILE A  69     -14.463 127.002  22.635  1.00 30.51           C  
ATOM    515  C   ILE A  69     -15.635 127.044  23.668  1.00 30.29           C  
ATOM    516  O   ILE A  69     -15.775 128.007  24.407  1.00 32.45           O  
ATOM    517  CB  ILE A  69     -14.953 127.411  21.229  1.00 30.01           C  
ATOM    518  CG1 ILE A  69     -13.742 127.644  20.321  1.00 30.96           C  
ATOM    519  CG2 ILE A  69     -15.822 128.698  21.300  1.00 29.87           C  
ATOM    520  CD1 ILE A  69     -14.086 127.857  18.801  1.00 33.03           C  
ATOM    521  N   TYR A  70     -16.452 126.006  23.718  1.00 29.86           N  
ATOM    522  CA  TYR A  70     -17.432 125.841  24.768  1.00 30.36           C  
ATOM    523  C   TYR A  70     -16.716 125.903  26.145  1.00 30.37           C  
ATOM    524  O   TYR A  70     -17.157 126.614  27.096  1.00 29.83           O  
ATOM    525  CB  TYR A  70     -18.186 124.503  24.581  1.00 32.09           C  
ATOM    526  CG  TYR A  70     -19.005 124.084  25.803  1.00 33.50           C  
ATOM    527  CD1 TYR A  70     -20.391 124.177  25.802  1.00 33.70           C  
ATOM    528  CD2 TYR A  70     -18.369 123.625  26.963  1.00 32.36           C  
ATOM    529  CE1 TYR A  70     -21.137 123.808  26.940  1.00 36.00           C  
ATOM    530  CE2 TYR A  70     -19.076 123.293  28.102  1.00 32.53           C  
ATOM    531  CZ  TYR A  70     -20.452 123.370  28.092  1.00 35.96           C  
ATOM    532  OH  TYR A  70     -21.173 122.995  29.222  1.00 38.24           O  
ATOM    533  N   PHE A  71     -15.588 125.205  26.235  1.00 27.86           N  
ATOM    534  CA  PHE A  71     -14.886 125.061  27.497  1.00 28.99           C  
ATOM    535  C   PHE A  71     -14.263 126.409  27.975  1.00 29.12           C  
ATOM    536  O   PHE A  71     -14.371 126.753  29.155  1.00 28.87           O  
ATOM    537  CB  PHE A  71     -13.827 123.958  27.389  1.00 26.76           C  
ATOM    538  CG  PHE A  71     -13.142 123.641  28.669  1.00 27.42           C  
ATOM    539  CD1 PHE A  71     -13.816 123.775  29.896  1.00 27.60           C  
ATOM    540  CD2 PHE A  71     -11.823 123.190  28.671  1.00 25.50           C  
ATOM    541  CE1 PHE A  71     -13.165 123.462  31.109  1.00 26.18           C  
ATOM    542  CE2 PHE A  71     -11.179 122.884  29.875  1.00 30.05           C  
ATOM    543  CZ  PHE A  71     -11.876 123.021  31.098  1.00 27.60           C  
ATOM    544  N   ILE A  72     -13.586 127.128  27.086  1.00 29.38           N  
ATOM    545  CA  ILE A  72     -12.963 128.387  27.473  1.00 30.97           C  
ATOM    546  C   ILE A  72     -13.992 129.386  28.035  1.00 31.44           C  
ATOM    547  O   ILE A  72     -13.706 130.077  29.036  1.00 31.22           O  
ATOM    548  CB  ILE A  72     -12.081 129.013  26.334  1.00 30.99           C  
ATOM    549  CG1 ILE A  72     -11.367 130.289  26.819  1.00 32.39           C  
ATOM    550  CG2 ILE A  72     -12.925 129.381  25.093  1.00 31.97           C  
ATOM    551  CD1 ILE A  72     -10.392 130.071  27.949  1.00 37.86           C  
ATOM    552  N   ARG A  73     -15.187 129.410  27.430  1.00 31.48           N  
ATOM    553  CA  ARG A  73     -16.278 130.281  27.861  1.00 32.47           C  
ATOM    554  C   ARG A  73     -16.690 129.955  29.291  1.00 33.97           C  
ATOM    555  O   ARG A  73     -16.839 130.864  30.103  1.00 35.15           O  
ATOM    556  CB  ARG A  73     -17.446 130.242  26.879  1.00 31.88           C  
ATOM    557  CG  ARG A  73     -17.053 130.740  25.457  1.00 33.07           C  
ATOM    558  CD  ARG A  73     -16.286 132.080  25.495  1.00 32.49           C  
ATOM    559  NE  ARG A  73     -17.181 133.163  25.921  1.00 34.39           N  
ATOM    560  CZ  ARG A  73     -16.803 134.275  26.552  1.00 34.90           C  
ATOM    561  NH1 ARG A  73     -15.526 134.466  26.876  1.00 36.64           N  
ATOM    562  NH2 ARG A  73     -17.721 135.197  26.877  1.00 35.90           N  
ATOM    563  N   ARG A  74     -16.808 128.666  29.610  1.00 33.88           N  
ATOM    564  CA  ARG A  74     -17.028 128.198  30.984  1.00 34.12           C  
ATOM    565  C   ARG A  74     -15.887 128.640  31.944  1.00 34.28           C  
ATOM    566  O   ARG A  74     -16.146 129.086  33.068  1.00 34.44           O  
ATOM    567  CB  ARG A  74     -17.196 126.664  31.007  1.00 34.71           C  
ATOM    568  CG  ARG A  74     -18.469 126.142  30.342  1.00 37.19           C  
ATOM    569  CD  ARG A  74     -19.495 127.245  30.340  1.00 44.23           C  
ATOM    570  NE  ARG A  74     -20.802 126.830  29.851  1.00 53.19           N  
ATOM    571  CZ  ARG A  74     -21.195 126.857  28.567  1.00 55.65           C  
ATOM    572  NH1 ARG A  74     -20.362 127.264  27.588  1.00 53.15           N  
ATOM    573  NH2 ARG A  74     -22.437 126.461  28.270  1.00 54.97           N  
ATOM    574  N   LEU A  75     -14.640 128.520  31.495  1.00 33.82           N  
ATOM    575  CA  LEU A  75     -13.496 128.835  32.310  1.00 34.43           C  
ATOM    576  C   LEU A  75     -13.402 130.338  32.602  1.00 36.21           C  
ATOM    577  O   LEU A  75     -12.830 130.726  33.633  1.00 35.18           O  
ATOM    578  CB  LEU A  75     -12.198 128.365  31.657  1.00 33.80           C  
ATOM    579  CG  LEU A  75     -11.904 126.867  31.744  1.00 33.86           C  
ATOM    580  CD1 LEU A  75     -10.694 126.580  30.911  1.00 31.70           C  
ATOM    581  CD2 LEU A  75     -11.724 126.361  33.175  1.00 29.19           C  
ATOM    582  N   THR A  76     -13.915 131.168  31.688  1.00 37.15           N  
ATOM    583  CA  THR A  76     -13.892 132.628  31.901  1.00 38.93           C  
ATOM    584  C   THR A  76     -14.896 133.040  32.957  1.00 39.52           C  
ATOM    585  O   THR A  76     -14.730 134.066  33.573  1.00 41.37           O  
ATOM    586  CB  THR A  76     -14.186 133.481  30.636  1.00 38.76           C  
ATOM    587  OG1 THR A  76     -15.607 133.521  30.383  1.00 40.83           O  
ATOM    588  CG2 THR A  76     -13.408 132.981  29.441  1.00 37.54           C  
ATOM    589  N   ASP A  77     -15.957 132.261  33.118  1.00 39.58           N  
ATOM    590  CA  ASP A  77     -16.953 132.485  34.146  1.00 40.68           C  
ATOM    591  C   ASP A  77     -16.387 132.183  35.540  1.00 39.26           C  
ATOM    592  O   ASP A  77     -16.411 133.038  36.426  1.00 38.53           O  
ATOM    593  CB  ASP A  77     -18.199 131.651  33.831  1.00 41.84           C  
ATOM    594  CG  ASP A  77     -19.342 131.924  34.765  1.00 47.98           C  
ATOM    595  OD1 ASP A  77     -19.388 133.023  35.389  1.00 55.64           O  
ATOM    596  OD2 ASP A  77     -20.227 131.038  34.866  1.00 53.75           O  
ATOM    597  N   ASP A  78     -15.830 130.989  35.722  1.00 37.03           N  
ATOM    598  CA  ASP A  78     -15.287 130.587  37.021  1.00 35.11           C  
ATOM    599  C   ASP A  78     -14.304 129.473  36.761  1.00 34.09           C  
ATOM    600  O   ASP A  78     -14.699 128.283  36.695  1.00 33.49           O  
ATOM    601  CB  ASP A  78     -16.390 130.107  37.974  1.00 34.38           C  
ATOM    602  CG  ASP A  78     -15.852 129.731  39.372  1.00 36.95           C  
ATOM    603  OD1 ASP A  78     -14.663 129.383  39.529  1.00 33.72           O  
ATOM    604  OD2 ASP A  78     -16.651 129.772  40.336  1.00 39.65           O  
ATOM    605  N   ARG A  79     -13.052 129.857  36.584  1.00 32.14           N  
ATOM    606  CA  ARG A  79     -11.986 128.922  36.243  1.00 32.23           C  
ATOM    607  C   ARG A  79     -11.873 127.737  37.200  1.00 32.03           C  
ATOM    608  O   ARG A  79     -11.770 126.586  36.755  1.00 30.64           O  
ATOM    609  CB  ARG A  79     -10.659 129.647  36.170  1.00 32.74           C  
ATOM    610  CG  ARG A  79      -9.490 128.796  35.737  1.00 35.68           C  
ATOM    611  CD  ARG A  79      -8.181 129.551  35.895  1.00 39.59           C  
ATOM    612  NE  ARG A  79      -8.290 130.845  35.255  1.00 45.42           N  
ATOM    613  CZ  ARG A  79      -7.772 131.979  35.728  1.00 48.28           C  
ATOM    614  NH1 ARG A  79      -7.079 131.996  36.857  1.00 47.55           N  
ATOM    615  NH2 ARG A  79      -7.954 133.103  35.050  1.00 50.70           N  
ATOM    616  N   LYS A  80     -11.826 127.994  38.506  1.00 31.49           N  
ATOM    617  CA  LYS A  80     -11.637 126.892  39.461  1.00 32.18           C  
ATOM    618  C   LYS A  80     -12.798 125.894  39.462  1.00 31.33           C  
ATOM    619  O   LYS A  80     -12.587 124.679  39.429  1.00 31.54           O  
ATOM    620  CB  LYS A  80     -11.450 127.405  40.890  1.00 33.20           C  
ATOM    621  CG  LYS A  80     -11.200 126.277  41.820  1.00 37.74           C  
ATOM    622  CD  LYS A  80     -12.267 126.234  42.916  1.00 47.48           C  
ATOM    623  CE  LYS A  80     -11.810 126.967  44.177  1.00 48.02           C  
ATOM    624  NZ  LYS A  80     -10.514 126.373  44.661  1.00 50.72           N  
ATOM    625  N   ARG A  81     -14.020 126.405  39.530  1.00 30.76           N  
ATOM    626  CA  ARG A  81     -15.214 125.568  39.490  1.00 32.03           C  
ATOM    627  C   ARG A  81     -15.356 124.810  38.128  1.00 30.55           C  
ATOM    628  O   ARG A  81     -15.675 123.630  38.114  1.00 29.42           O  
ATOM    629  CB  ARG A  81     -16.440 126.443  39.744  1.00 31.89           C  
ATOM    630  CG  ARG A  81     -17.782 125.734  39.853  1.00 34.44           C  
ATOM    631  CD  ARG A  81     -18.933 126.743  39.658  1.00 36.21           C  
ATOM    632  NE  ARG A  81     -18.989 127.240  38.271  1.00 41.21           N  
ATOM    633  CZ  ARG A  81     -19.487 128.418  37.891  1.00 43.52           C  
ATOM    634  NH1 ARG A  81     -19.998 129.278  38.782  1.00 46.01           N  
ATOM    635  NH2 ARG A  81     -19.471 128.748  36.605  1.00 44.58           N  
ATOM    636  N   GLU A  82     -15.110 125.490  37.016  1.00 29.90           N  
ATOM    637  CA  GLU A  82     -15.381 124.901  35.691  1.00 31.61           C  
ATOM    638  C   GLU A  82     -14.333 123.865  35.282  1.00 31.12           C  
ATOM    639  O   GLU A  82     -14.652 122.874  34.608  1.00 31.94           O  
ATOM    640  CB  GLU A  82     -15.540 125.982  34.647  1.00 31.64           C  
ATOM    641  CG  GLU A  82     -16.798 126.819  34.875  1.00 35.47           C  
ATOM    642  CD  GLU A  82     -18.069 125.985  34.855  1.00 41.61           C  
ATOM    643  OE1 GLU A  82     -18.221 125.127  33.959  1.00 42.99           O  
ATOM    644  OE2 GLU A  82     -18.921 126.188  35.738  1.00 44.12           O  
ATOM    645  N   SER A  83     -13.086 124.071  35.709  1.00 30.44           N  
ATOM    646  CA  SER A  83     -12.049 123.125  35.407  1.00 30.19           C  
ATOM    647  C   SER A  83     -12.282 121.820  36.151  1.00 29.91           C  
ATOM    648  O   SER A  83     -12.094 120.769  35.559  1.00 27.93           O  
ATOM    649  CB  SER A  83     -10.673 123.667  35.711  1.00 30.28           C  
ATOM    650  OG  SER A  83     -10.594 124.085  37.069  1.00 33.26           O  
ATOM    651  N   THR A  84     -12.684 121.895  37.443  1.00 28.90           N  
ATOM    652  CA  THR A  84     -13.091 120.732  38.197  1.00 28.88           C  
ATOM    653  C   THR A  84     -14.268 120.026  37.525  1.00 27.62           C  
ATOM    654  O   THR A  84     -14.283 118.795  37.421  1.00 26.32           O  
ATOM    655  CB  THR A  84     -13.455 121.081  39.711  1.00 30.53           C  
ATOM    656  OG1 THR A  84     -12.313 121.671  40.325  1.00 32.34           O  
ATOM    657  CG2 THR A  84     -13.769 119.856  40.502  1.00 29.98           C  
ATOM    658  N   LYS A  85     -15.253 120.811  37.109  1.00 26.26           N  
ATOM    659  CA  LYS A  85     -16.467 120.257  36.527  1.00 27.34           C  
ATOM    660  C   LYS A  85     -16.147 119.550  35.181  1.00 24.89           C  
ATOM    661  O   LYS A  85     -16.649 118.482  34.918  1.00 22.98           O  
ATOM    662  CB  LYS A  85     -17.514 121.331  36.312  1.00 27.66           C  
ATOM    663  CG  LYS A  85     -18.486 121.540  37.537  1.00 30.30           C  
ATOM    664  CD  LYS A  85     -19.247 122.889  37.473  1.00 33.10           C  
ATOM    665  CE  LYS A  85     -20.451 122.864  36.540  1.00 37.76           C  
ATOM    666  NZ  LYS A  85     -21.083 124.239  36.573  1.00 44.59           N  
ATOM    667  N   MET A  86     -15.282 120.135  34.391  1.00 22.74           N  
ATOM    668  CA  MET A  86     -14.938 119.468  33.121  1.00 23.44           C  
ATOM    669  C   MET A  86     -14.130 118.172  33.377  1.00 23.32           C  
ATOM    670  O   MET A  86     -14.411 117.132  32.767  1.00 22.87           O  
ATOM    671  CB  MET A  86     -14.169 120.425  32.249  1.00 23.48           C  
ATOM    672  CG  MET A  86     -13.959 119.916  30.781  1.00 26.21           C  
ATOM    673  SD  MET A  86     -15.516 119.457  29.991  1.00 33.12           S  
ATOM    674  CE  MET A  86     -16.188 121.000  29.389  1.00 30.80           C  
ATOM    675  N   ALA A  87     -13.123 118.224  34.266  1.00 22.84           N  
ATOM    676  CA  ALA A  87     -12.389 117.024  34.594  1.00 23.33           C  
ATOM    677  C   ALA A  87     -13.267 115.899  35.158  1.00 23.22           C  
ATOM    678  O   ALA A  87     -13.021 114.719  34.849  1.00 21.02           O  
ATOM    679  CB  ALA A  87     -11.227 117.321  35.552  1.00 23.81           C  
ATOM    680  N   GLU A  88     -14.216 116.221  36.050  1.00 23.02           N  
ATOM    681  CA  GLU A  88     -15.185 115.201  36.531  1.00 24.45           C  
ATOM    682  C   GLU A  88     -16.097 114.679  35.416  1.00 22.36           C  
ATOM    683  O   GLU A  88     -16.400 113.492  35.404  1.00 20.13           O  
ATOM    684  CB  GLU A  88     -16.047 115.704  37.700  1.00 24.52           C  
ATOM    685  CG  GLU A  88     -15.201 115.866  38.996  1.00 30.07           C  
ATOM    686  CD  GLU A  88     -15.930 116.667  40.109  1.00 31.92           C  
ATOM    687  OE1 GLU A  88     -17.116 117.069  39.909  1.00 40.56           O  
ATOM    688  OE2 GLU A  88     -15.267 116.926  41.157  1.00 41.43           O  
ATOM    689  N   ALA A  89     -16.561 115.559  34.525  1.00 21.69           N  
ATOM    690  CA  ALA A  89     -17.448 115.129  33.407  1.00 20.90           C  
ATOM    691  C   ALA A  89     -16.688 114.102  32.570  1.00 20.56           C  
ATOM    692  O   ALA A  89     -17.209 113.008  32.298  1.00 20.13           O  
ATOM    693  CB  ALA A  89     -17.892 116.306  32.503  1.00 21.02           C  
ATOM    694  N   ILE A  90     -15.461 114.435  32.200  1.00 21.49           N  
ATOM    695  CA  ILE A  90     -14.606 113.525  31.409  1.00 21.41           C  
ATOM    696  C   ILE A  90     -14.441 112.217  32.160  1.00 20.65           C  
ATOM    697  O   ILE A  90     -14.643 111.145  31.589  1.00 18.63           O  
ATOM    698  CB  ILE A  90     -13.247 114.154  31.059  1.00 20.47           C  
ATOM    699  CG1 ILE A  90     -13.450 115.336  30.078  1.00 21.38           C  
ATOM    700  CG2 ILE A  90     -12.247 113.078  30.521  1.00 19.60           C  
ATOM    701  CD1 ILE A  90     -12.115 116.121  29.773  1.00 21.90           C  
ATOM    702  N   ARG A  91     -14.051 112.286  33.454  1.00 21.38           N  
ATOM    703  CA  ARG A  91     -13.868 111.095  34.256  1.00 21.41           C  
ATOM    704  C   ARG A  91     -15.096 110.205  34.244  1.00 20.84           C  
ATOM    705  O   ARG A  91     -14.945 108.987  34.091  1.00 20.67           O  
ATOM    706  CB  ARG A  91     -13.397 111.401  35.698  1.00 22.66           C  
ATOM    707  CG  ARG A  91     -13.066 110.186  36.576  1.00 27.10           C  
ATOM    708  CD  ARG A  91     -14.296 109.955  37.455  1.00 38.60           C  
ATOM    709  NE  ARG A  91     -14.322 108.736  38.274  1.00 43.95           N  
ATOM    710  CZ  ARG A  91     -15.445 108.164  38.730  1.00 45.39           C  
ATOM    711  NH1 ARG A  91     -16.637 108.698  38.444  1.00 44.19           N  
ATOM    712  NH2 ARG A  91     -15.380 107.065  39.485  1.00 40.34           N  
ATOM    713  N   ASN A  92     -16.278 110.780  34.441  1.00 21.33           N  
ATOM    714  CA  ASN A  92     -17.494 109.993  34.489  1.00 21.82           C  
ATOM    715  C   ASN A  92     -17.803 109.361  33.112  1.00 19.50           C  
ATOM    716  O   ASN A  92     -18.244 108.226  33.046  1.00 20.25           O  
ATOM    717  CB  ASN A  92     -18.714 110.816  34.900  1.00 22.29           C  
ATOM    718  CG  ASN A  92     -18.696 111.243  36.394  1.00 28.58           C  
ATOM    719  OD1 ASN A  92     -19.245 112.290  36.734  1.00 34.79           O  
ATOM    720  ND2 ASN A  92     -18.125 110.439  37.252  1.00 26.77           N  
ATOM    721  N   PHE A  93     -17.617 110.141  32.076  1.00 19.54           N  
ATOM    722  CA  PHE A  93     -17.804 109.708  30.654  1.00 18.30           C  
ATOM    723  C   PHE A  93     -16.903 108.509  30.383  1.00 18.22           C  
ATOM    724  O   PHE A  93     -17.383 107.466  29.943  1.00 19.07           O  
ATOM    725  CB  PHE A  93     -17.464 110.861  29.717  1.00 18.61           C  
ATOM    726  CG  PHE A  93     -17.636 110.533  28.198  1.00 18.83           C  
ATOM    727  CD1 PHE A  93     -18.918 110.290  27.635  1.00 17.55           C  
ATOM    728  CD2 PHE A  93     -16.505 110.489  27.363  1.00 20.73           C  
ATOM    729  CE1 PHE A  93     -19.063 110.056  26.216  1.00 19.52           C  
ATOM    730  CE2 PHE A  93     -16.632 110.221  25.936  1.00 18.48           C  
ATOM    731  CZ  PHE A  93     -17.874 110.009  25.391  1.00 16.43           C  
ATOM    732  N   VAL A  94     -15.606 108.650  30.687  1.00 17.37           N  
ATOM    733  CA  VAL A  94     -14.674 107.583  30.478  1.00 17.38           C  
ATOM    734  C   VAL A  94     -15.033 106.315  31.316  1.00 18.59           C  
ATOM    735  O   VAL A  94     -15.020 105.154  30.803  1.00 16.02           O  
ATOM    736  CB  VAL A  94     -13.193 108.060  30.731  1.00 15.81           C  
ATOM    737  CG1 VAL A  94     -12.231 106.903  30.737  1.00 17.52           C  
ATOM    738  CG2 VAL A  94     -12.709 109.122  29.633  1.00 15.92           C  
ATOM    739  N   ASN A  95     -15.319 106.540  32.611  1.00 17.37           N  
ATOM    740  CA  ASN A  95     -15.744 105.448  33.430  1.00 18.48           C  
ATOM    741  C   ASN A  95     -16.940 104.647  32.881  1.00 18.32           C  
ATOM    742  O   ASN A  95     -17.009 103.407  33.079  1.00 17.90           O  
ATOM    743  CB  ASN A  95     -16.006 105.976  34.883  1.00 16.67           C  
ATOM    744  CG  ASN A  95     -16.257 104.849  35.831  1.00 20.79           C  
ATOM    745  OD1 ASN A  95     -15.423 103.973  35.962  1.00 24.41           O  
ATOM    746  ND2 ASN A  95     -17.387 104.882  36.521  1.00 23.97           N  
ATOM    747  N   THR A  96     -17.857 105.318  32.152  1.00 19.04           N  
ATOM    748  CA  THR A  96     -19.043 104.650  31.611  1.00 20.18           C  
ATOM    749  C   THR A  96     -18.579 103.544  30.655  1.00 18.48           C  
ATOM    750  O   THR A  96     -19.125 102.410  30.669  1.00 17.88           O  
ATOM    751  CB  THR A  96     -19.932 105.645  30.802  1.00 20.50           C  
ATOM    752  OG1 THR A  96     -20.405 106.650  31.673  1.00 23.41           O  
ATOM    753  CG2 THR A  96     -21.142 104.998  30.175  1.00 23.64           C  
ATOM    754  N   PHE A  97     -17.563 103.885  29.835  1.00 18.66           N  
ATOM    755  CA  PHE A  97     -16.975 102.907  28.905  1.00 18.61           C  
ATOM    756  C   PHE A  97     -16.243 101.793  29.640  1.00 18.06           C  
ATOM    757  O   PHE A  97     -16.423 100.622  29.334  1.00 18.40           O  
ATOM    758  CB  PHE A  97     -16.072 103.577  27.844  1.00 17.78           C  
ATOM    759  CG  PHE A  97     -16.841 104.373  26.824  1.00 20.39           C  
ATOM    760  CD1 PHE A  97     -17.311 103.764  25.659  1.00 21.43           C  
ATOM    761  CD2 PHE A  97     -17.113 105.714  27.017  1.00 19.72           C  
ATOM    762  CE1 PHE A  97     -18.056 104.503  24.720  1.00 20.45           C  
ATOM    763  CE2 PHE A  97     -17.848 106.444  26.111  1.00 24.13           C  
ATOM    764  CZ  PHE A  97     -18.354 105.825  24.949  1.00 22.61           C  
ATOM    765  N   ILE A  98     -15.432 102.141  30.634  1.00 18.37           N  
ATOM    766  CA  ILE A  98     -14.776 101.115  31.479  1.00 19.32           C  
ATOM    767  C   ILE A  98     -15.742 100.084  32.120  1.00 18.80           C  
ATOM    768  O   ILE A  98     -15.402  98.881  32.174  1.00 19.31           O  
ATOM    769  CB  ILE A  98     -13.887 101.772  32.642  1.00 18.40           C  
ATOM    770  CG1 ILE A  98     -12.728 102.563  32.073  1.00 20.16           C  
ATOM    771  CG2 ILE A  98     -13.337 100.664  33.558  1.00 20.18           C  
ATOM    772  CD1 ILE A  98     -12.095 103.637  33.092  1.00 18.49           C  
ATOM    773  N   GLN A  99     -16.914 100.525  32.581  1.00 19.52           N  
ATOM    774  CA  GLN A  99     -17.849  99.672  33.359  1.00 20.90           C  
ATOM    775  C   GLN A  99     -18.849  98.937  32.404  1.00 21.40           C  
ATOM    776  O   GLN A  99     -19.500  97.960  32.774  1.00 21.75           O  
ATOM    777  CB  GLN A  99     -18.676 100.496  34.399  1.00 20.19           C  
ATOM    778  CG  GLN A  99     -17.871 101.356  35.403  1.00 20.98           C  
ATOM    779  CD  GLN A  99     -16.879 100.569  36.171  1.00 23.19           C  
ATOM    780  OE1 GLN A  99     -17.102  99.382  36.422  1.00 25.09           O  
ATOM    781  NE2 GLN A  99     -15.730 101.188  36.524  1.00 21.49           N  
ATOM    782  N   PHE A 100     -18.989  99.416  31.178  1.00 20.94           N  
ATOM    783  CA  PHE A 100     -20.025  98.844  30.341  1.00 20.55           C  
ATOM    784  C   PHE A 100     -19.772  97.342  30.059  1.00 20.11           C  
ATOM    785  O   PHE A 100     -18.711  96.990  29.536  1.00 20.02           O  
ATOM    786  CB  PHE A 100     -20.134  99.632  29.033  1.00 21.59           C  
ATOM    787  CG  PHE A 100     -21.372  99.273  28.229  1.00 19.13           C  
ATOM    788  CD1 PHE A 100     -22.615  99.768  28.592  1.00 24.92           C  
ATOM    789  CD2 PHE A 100     -21.260  98.500  27.087  1.00 21.85           C  
ATOM    790  CE1 PHE A 100     -23.749  99.491  27.853  1.00 22.88           C  
ATOM    791  CE2 PHE A 100     -22.405  98.190  26.341  1.00 21.54           C  
ATOM    792  CZ  PHE A 100     -23.638  98.660  26.731  1.00 25.24           C  
ATOM    793  N   LYS A 101     -20.719  96.475  30.434  1.00 19.73           N  
ATOM    794  CA  LYS A 101     -20.539  95.013  30.389  1.00 21.54           C  
ATOM    795  C   LYS A 101     -20.813  94.296  29.052  1.00 20.97           C  
ATOM    796  O   LYS A 101     -20.467  93.114  28.892  1.00 22.64           O  
ATOM    797  CB  LYS A 101     -21.354  94.311  31.478  1.00 21.66           C  
ATOM    798  CG  LYS A 101     -22.809  94.065  31.083  1.00 26.51           C  
ATOM    799  CD  LYS A 101     -23.636  93.380  32.278  1.00 26.10           C  
ATOM    800  CE  LYS A 101     -25.141  93.289  31.917  1.00 27.59           C  
ATOM    801  NZ  LYS A 101     -26.007  93.031  33.185  1.00 29.71           N  
ATOM    802  N   LYS A 102     -21.462  94.958  28.121  1.00 20.59           N  
ATOM    803  CA  LYS A 102     -21.781  94.291  26.845  1.00 20.60           C  
ATOM    804  C   LYS A 102     -20.830  94.809  25.740  1.00 19.46           C  
ATOM    805  O   LYS A 102     -20.195  95.817  25.925  1.00 18.79           O  
ATOM    806  CB  LYS A 102     -23.224  94.583  26.457  1.00 19.37           C  
ATOM    807  CG  LYS A 102     -24.255  93.973  27.411  1.00 21.84           C  
ATOM    808  CD  LYS A 102     -25.654  94.483  27.014  1.00 17.63           C  
ATOM    809  CE  LYS A 102     -26.694  93.955  28.032  1.00 18.80           C  
ATOM    810  NZ  LYS A 102     -28.043  94.318  27.692  1.00 18.29           N  
ATOM    811  N   PRO A 103     -20.721  94.095  24.593  1.00 20.36           N  
ATOM    812  CA  PRO A 103     -19.786  94.634  23.542  1.00 18.82           C  
ATOM    813  C   PRO A 103     -20.191  95.969  22.957  1.00 16.05           C  
ATOM    814  O   PRO A 103     -21.388  96.243  22.728  1.00 16.54           O  
ATOM    815  CB  PRO A 103     -19.786  93.534  22.459  1.00 18.93           C  
ATOM    816  CG  PRO A 103     -20.346  92.322  23.135  1.00 19.58           C  
ATOM    817  CD  PRO A 103     -21.326  92.821  24.175  1.00 20.12           C  
ATOM    818  N   ILE A 104     -19.225  96.855  22.811  1.00 15.62           N  
ATOM    819  CA  ILE A 104     -19.451  98.103  22.081  1.00 16.51           C  
ATOM    820  C   ILE A 104     -18.649  97.983  20.760  1.00 16.69           C  
ATOM    821  O   ILE A 104     -17.399  97.837  20.723  1.00 18.28           O  
ATOM    822  CB  ILE A 104     -19.057  99.377  22.782  1.00 16.73           C  
ATOM    823  CG1 ILE A 104     -19.891  99.551  24.118  1.00 15.62           C  
ATOM    824  CG2 ILE A 104     -19.268 100.593  21.791  1.00 16.73           C  
ATOM    825  CD1 ILE A 104     -19.342 100.741  25.033  1.00 17.24           C  
ATOM    826  N   ILE A 105     -19.370  98.060  19.686  1.00 16.82           N  
ATOM    827  CA  ILE A 105     -18.748  97.947  18.384  1.00 15.71           C  
ATOM    828  C   ILE A 105     -18.790  99.355  17.776  1.00 16.59           C  
ATOM    829  O   ILE A 105     -19.863  99.975  17.747  1.00 19.23           O  
ATOM    830  CB  ILE A 105     -19.551  96.956  17.498  1.00 17.00           C  
ATOM    831  CG1 ILE A 105     -19.914  95.598  18.197  1.00 17.16           C  
ATOM    832  CG2 ILE A 105     -18.797  96.826  16.113  1.00 15.74           C  
ATOM    833  CD1 ILE A 105     -18.712  94.828  18.707  1.00 14.63           C  
ATOM    834  N   VAL A 106     -17.679  99.876  17.284  1.00 16.92           N  
ATOM    835  CA  VAL A 106     -17.647 101.228  16.764  1.00 18.03           C  
ATOM    836  C   VAL A 106     -17.431 101.219  15.222  1.00 17.61           C  
ATOM    837  O   VAL A 106     -16.540 100.519  14.706  1.00 18.80           O  
ATOM    838  CB  VAL A 106     -16.584 102.100  17.474  1.00 17.91           C  
ATOM    839  CG1 VAL A 106     -16.726 103.580  17.107  1.00 19.94           C  
ATOM    840  CG2 VAL A 106     -16.616 101.916  19.057  1.00 18.15           C  
ATOM    841  N   ALA A 107     -18.272 101.970  14.516  1.00 18.08           N  
ATOM    842  CA  ALA A 107     -18.048 102.257  13.084  1.00 18.31           C  
ATOM    843  C   ALA A 107     -17.566 103.720  12.952  1.00 18.49           C  
ATOM    844  O   ALA A 107     -18.311 104.677  13.189  1.00 19.03           O  
ATOM    845  CB  ALA A 107     -19.323 102.012  12.228  1.00 18.87           C  
ATOM    846  N   VAL A 108     -16.310 103.854  12.538  1.00 17.77           N  
ATOM    847  CA  VAL A 108     -15.654 105.141  12.348  1.00 18.38           C  
ATOM    848  C   VAL A 108     -15.552 105.494  10.855  1.00 20.50           C  
ATOM    849  O   VAL A 108     -14.884 104.802  10.068  1.00 19.85           O  
ATOM    850  CB  VAL A 108     -14.267 105.218  12.997  1.00 18.59           C  
ATOM    851  CG1 VAL A 108     -13.728 106.693  12.930  1.00 14.29           C  
ATOM    852  CG2 VAL A 108     -14.331 104.684  14.533  1.00 18.94           C  
ATOM    853  N   ASN A 109     -16.150 106.610  10.517  1.00 21.82           N  
ATOM    854  CA  ASN A 109     -16.375 106.985   9.107  1.00 25.80           C  
ATOM    855  C   ASN A 109     -15.800 108.381   8.811  1.00 25.74           C  
ATOM    856  O   ASN A 109     -16.078 108.972   7.775  1.00 26.27           O  
ATOM    857  CB  ASN A 109     -17.906 106.992   8.847  1.00 27.38           C  
ATOM    858  CG  ASN A 109     -18.227 107.110   7.389  1.00 33.23           C  
ATOM    859  OD1 ASN A 109     -17.482 106.575   6.525  1.00 37.04           O  
ATOM    860  ND2 ASN A 109     -19.291 107.860   7.071  1.00 37.24           N  
ATOM    861  N   GLY A 110     -15.012 108.915   9.740  1.00 24.05           N  
ATOM    862  CA  GLY A 110     -14.474 110.268   9.604  1.00 23.23           C  
ATOM    863  C   GLY A 110     -13.431 110.472  10.714  1.00 22.65           C  
ATOM    864  O   GLY A 110     -13.145 109.536  11.486  1.00 20.85           O  
ATOM    865  N   PRO A 111     -12.856 111.679  10.803  1.00 21.83           N  
ATOM    866  CA  PRO A 111     -11.882 111.934  11.865  1.00 21.18           C  
ATOM    867  C   PRO A 111     -12.365 111.601  13.288  1.00 19.58           C  
ATOM    868  O   PRO A 111     -13.501 111.947  13.666  1.00 17.78           O  
ATOM    869  CB  PRO A 111     -11.714 113.462  11.790  1.00 22.42           C  
ATOM    870  CG  PRO A 111     -11.853 113.748  10.349  1.00 24.57           C  
ATOM    871  CD  PRO A 111     -13.006 112.856   9.923  1.00 24.01           C  
ATOM    872  N   ALA A 112     -11.436 111.050  14.073  1.00 17.32           N  
ATOM    873  CA  ALA A 112     -11.629 110.738  15.496  1.00 17.93           C  
ATOM    874  C   ALA A 112     -10.455 111.406  16.206  1.00 17.92           C  
ATOM    875  O   ALA A 112      -9.309 111.027  15.963  1.00 17.81           O  
ATOM    876  CB  ALA A 112     -11.609 109.225  15.718  1.00 16.23           C  
ATOM    877  N   ILE A 113     -10.739 112.454  17.004  1.00 18.01           N  
ATOM    878  CA  ILE A 113      -9.701 113.363  17.516  1.00 18.04           C  
ATOM    879  C   ILE A 113      -9.779 113.498  19.071  1.00 17.30           C  
ATOM    880  O   ILE A 113     -10.840 113.717  19.595  1.00 16.85           O  
ATOM    881  CB  ILE A 113      -9.894 114.763  16.845  1.00 19.07           C  
ATOM    882  CG1 ILE A 113      -9.779 114.640  15.296  1.00 20.25           C  
ATOM    883  CG2 ILE A 113      -8.815 115.766  17.295  1.00 18.53           C  
ATOM    884  CD1 ILE A 113     -10.112 115.965  14.643  1.00 23.37           C  
ATOM    885  N   GLY A 114      -8.658 113.418  19.758  1.00 18.73           N  
ATOM    886  CA  GLY A 114      -8.638 113.777  21.161  1.00 18.93           C  
ATOM    887  C   GLY A 114      -9.356 112.656  21.851  1.00 18.26           C  
ATOM    888  O   GLY A 114      -9.080 111.468  21.607  1.00 19.42           O  
ATOM    889  N   LEU A 115     -10.320 113.023  22.682  1.00 21.42           N  
ATOM    890  CA  LEU A 115     -11.112 112.052  23.397  1.00 21.33           C  
ATOM    891  C   LEU A 115     -11.942 111.187  22.444  1.00 21.38           C  
ATOM    892  O   LEU A 115     -12.231 110.041  22.763  1.00 19.02           O  
ATOM    893  CB  LEU A 115     -12.054 112.793  24.340  1.00 23.40           C  
ATOM    894  CG  LEU A 115     -12.739 112.038  25.482  1.00 24.20           C  
ATOM    895  CD1 LEU A 115     -11.780 111.109  26.357  1.00 26.41           C  
ATOM    896  CD2 LEU A 115     -13.496 113.139  26.341  1.00 22.05           C  
ATOM    897  N   GLY A 116     -12.295 111.721  21.262  1.00 19.81           N  
ATOM    898  CA  GLY A 116     -12.982 110.872  20.225  1.00 19.44           C  
ATOM    899  C   GLY A 116     -12.166 109.665  19.750  1.00 19.61           C  
ATOM    900  O   GLY A 116     -12.726 108.691  19.249  1.00 21.89           O  
ATOM    901  N   ALA A 117     -10.843 109.745  19.865  1.00 19.58           N  
ATOM    902  CA  ALA A 117      -9.951 108.608  19.541  1.00 20.38           C  
ATOM    903  C   ALA A 117      -9.569 107.839  20.811  1.00 20.79           C  
ATOM    904  O   ALA A 117      -9.400 106.624  20.761  1.00 18.96           O  
ATOM    905  CB  ALA A 117      -8.686 109.056  18.824  1.00 20.65           C  
ATOM    906  N   SER A 118      -9.383 108.558  21.938  1.00 20.89           N  
ATOM    907  CA  SER A 118      -8.949 107.912  23.179  1.00 20.94           C  
ATOM    908  C   SER A 118      -9.918 106.913  23.732  1.00 21.54           C  
ATOM    909  O   SER A 118      -9.485 105.977  24.430  1.00 22.46           O  
ATOM    910  CB  SER A 118      -8.757 108.982  24.293  1.00 21.21           C  
ATOM    911  OG  SER A 118      -7.457 109.432  24.034  1.00 25.16           O  
ATOM    912  N   ILE A 119     -11.211 107.129  23.485  1.00 21.48           N  
ATOM    913  CA  ILE A 119     -12.249 106.220  23.995  1.00 22.63           C  
ATOM    914  C   ILE A 119     -12.261 104.901  23.196  1.00 21.64           C  
ATOM    915  O   ILE A 119     -12.789 103.904  23.688  1.00 17.28           O  
ATOM    916  CB  ILE A 119     -13.697 106.824  23.989  1.00 23.58           C  
ATOM    917  CG1 ILE A 119     -14.213 107.018  22.548  1.00 23.30           C  
ATOM    918  CG2 ILE A 119     -13.838 108.096  24.897  1.00 26.90           C  
ATOM    919  CD1 ILE A 119     -15.533 107.666  22.418  1.00 26.13           C  
ATOM    920  N   LEU A 120     -11.735 104.913  21.948  1.00 18.70           N  
ATOM    921  CA  LEU A 120     -11.834 103.704  21.084  1.00 18.83           C  
ATOM    922  C   LEU A 120     -11.233 102.436  21.738  1.00 18.01           C  
ATOM    923  O   LEU A 120     -11.869 101.422  21.743  1.00 19.41           O  
ATOM    924  CB  LEU A 120     -11.187 103.979  19.695  1.00 16.10           C  
ATOM    925  CG  LEU A 120     -11.905 105.081  18.952  1.00 16.91           C  
ATOM    926  CD1 LEU A 120     -11.220 105.324  17.534  1.00 18.68           C  
ATOM    927  CD2 LEU A 120     -13.329 104.724  18.798  1.00 15.10           C  
ATOM    928  N   PRO A 121     -10.028 102.506  22.320  1.00 18.68           N  
ATOM    929  CA  PRO A 121      -9.501 101.307  23.038  1.00 20.05           C  
ATOM    930  C   PRO A 121     -10.335 100.779  24.239  1.00 19.79           C  
ATOM    931  O   PRO A 121     -10.103  99.629  24.702  1.00 19.60           O  
ATOM    932  CB  PRO A 121      -8.123 101.759  23.536  1.00 17.27           C  
ATOM    933  CG  PRO A 121      -7.791 103.011  22.781  1.00 21.13           C  
ATOM    934  CD  PRO A 121      -9.068 103.638  22.355  1.00 20.50           C  
ATOM    935  N   LEU A 122     -11.333 101.557  24.662  1.00 20.31           N  
ATOM    936  CA  LEU A 122     -12.253 101.157  25.743  1.00 21.32           C  
ATOM    937  C   LEU A 122     -13.491 100.476  25.150  1.00 22.72           C  
ATOM    938  O   LEU A 122     -14.301  99.904  25.905  1.00 22.94           O  
ATOM    939  CB  LEU A 122     -12.694 102.376  26.587  1.00 19.58           C  
ATOM    940  CG  LEU A 122     -11.609 103.284  27.138  1.00 23.01           C  
ATOM    941  CD1 LEU A 122     -12.165 104.398  28.010  1.00 22.05           C  
ATOM    942  CD2 LEU A 122     -10.625 102.443  27.862  1.00 23.86           C  
ATOM    943  N   CYS A 123     -13.680 100.576  23.824  1.00 21.39           N  
ATOM    944  CA  CYS A 123     -14.777  99.873  23.172  1.00 20.50           C  
ATOM    945  C   CYS A 123     -14.256  98.516  22.834  1.00 20.43           C  
ATOM    946  O   CYS A 123     -13.109  98.195  23.222  1.00 21.24           O  
ATOM    947  CB  CYS A 123     -15.308 100.657  21.965  1.00 21.23           C  
ATOM    948  SG  CYS A 123     -15.909 102.250  22.473  1.00 21.24           S  
ATOM    949  N   ASP A 124     -15.041  97.653  22.190  1.00 18.03           N  
ATOM    950  CA  ASP A 124     -14.551  96.296  21.933  1.00 18.43           C  
ATOM    951  C   ASP A 124     -13.942  96.075  20.523  1.00 19.04           C  
ATOM    952  O   ASP A 124     -12.813  95.560  20.397  1.00 20.13           O  
ATOM    953  CB  ASP A 124     -15.651  95.294  22.286  1.00 18.82           C  
ATOM    954  CG  ASP A 124     -15.989  95.442  23.771  1.00 22.81           C  
ATOM    955  OD1 ASP A 124     -15.081  95.100  24.605  1.00 24.74           O  
ATOM    956  OD2 ASP A 124     -17.004  96.087  24.069  1.00 23.17           O  
ATOM    957  N   VAL A 125     -14.643  96.519  19.514  1.00 18.27           N  
ATOM    958  CA  VAL A 125     -14.229  96.277  18.080  1.00 18.42           C  
ATOM    959  C   VAL A 125     -14.333  97.628  17.396  1.00 15.80           C  
ATOM    960  O   VAL A 125     -15.288  98.387  17.666  1.00 16.92           O  
ATOM    961  CB  VAL A 125     -15.181  95.252  17.391  1.00 18.44           C  
ATOM    962  CG1 VAL A 125     -14.870  95.121  15.844  1.00 17.38           C  
ATOM    963  CG2 VAL A 125     -15.104  93.839  18.068  1.00 19.82           C  
ATOM    964  N   VAL A 126     -13.324  97.992  16.608  1.00 16.48           N  
ATOM    965  CA  VAL A 126     -13.439  99.213  15.842  1.00 16.92           C  
ATOM    966  C   VAL A 126     -13.293  98.939  14.327  1.00 16.76           C  
ATOM    967  O   VAL A 126     -12.267  98.426  13.886  1.00 15.66           O  
ATOM    968  CB  VAL A 126     -12.376 100.241  16.288  1.00 16.67           C  
ATOM    969  CG1 VAL A 126     -12.533 101.501  15.329  1.00 15.06           C  
ATOM    970  CG2 VAL A 126     -12.548 100.608  17.784  1.00 18.73           C  
ATOM    971  N   TRP A 127     -14.288  99.319  13.544  1.00 16.71           N  
ATOM    972  CA  TRP A 127     -14.235  99.127  12.086  1.00 19.63           C  
ATOM    973  C   TRP A 127     -14.250 100.502  11.426  1.00 19.49           C  
ATOM    974  O   TRP A 127     -15.052 101.349  11.803  1.00 20.25           O  
ATOM    975  CB  TRP A 127     -15.414  98.287  11.575  1.00 19.40           C  
ATOM    976  CG  TRP A 127     -15.327  96.850  11.942  1.00 20.05           C  
ATOM    977  CD1 TRP A 127     -14.197  96.032  11.913  1.00 19.14           C  
ATOM    978  CD2 TRP A 127     -16.390  96.047  12.423  1.00 20.12           C  
ATOM    979  NE1 TRP A 127     -14.540  94.763  12.326  1.00 22.34           N  
ATOM    980  CE2 TRP A 127     -15.864  94.754  12.672  1.00 21.88           C  
ATOM    981  CE3 TRP A 127     -17.759  96.294  12.661  1.00 19.65           C  
ATOM    982  CZ2 TRP A 127     -16.667  93.688  13.134  1.00 23.39           C  
ATOM    983  CZ3 TRP A 127     -18.551  95.235  13.130  1.00 22.60           C  
ATOM    984  CH2 TRP A 127     -17.987  93.973  13.412  1.00 19.56           C  
ATOM    985  N   ALA A 128     -13.333 100.745  10.492  1.00 18.25           N  
ATOM    986  CA  ALA A 128     -13.165 102.058   9.948  1.00 20.83           C  
ATOM    987  C   ALA A 128     -13.178 101.943   8.418  1.00 21.74           C  
ATOM    988  O   ALA A 128     -13.021 100.861   7.878  1.00 20.95           O  
ATOM    989  CB  ALA A 128     -11.863 102.611  10.381  1.00 20.39           C  
ATOM    990  N   ASN A 129     -13.338 103.061   7.744  1.00 24.88           N  
ATOM    991  CA  ASN A 129     -12.959 103.091   6.307  1.00 26.20           C  
ATOM    992  C   ASN A 129     -11.860 104.082   6.084  1.00 26.48           C  
ATOM    993  O   ASN A 129     -11.512 104.814   7.009  1.00 22.70           O  
ATOM    994  CB  ASN A 129     -14.171 103.291   5.384  1.00 27.76           C  
ATOM    995  CG  ASN A 129     -14.814 104.637   5.512  1.00 28.57           C  
ATOM    996  OD1 ASN A 129     -14.228 105.660   5.208  1.00 33.51           O  
ATOM    997  ND2 ASN A 129     -16.044 104.630   5.841  1.00 34.09           N  
ATOM    998  N   GLU A 130     -11.329 104.161   4.843  1.00 26.72           N  
ATOM    999  CA  GLU A 130     -10.252 105.120   4.565  1.00 28.51           C  
ATOM   1000  C   GLU A 130     -10.526 106.617   4.742  1.00 28.60           C  
ATOM   1001  O   GLU A 130      -9.573 107.404   4.862  1.00 30.65           O  
ATOM   1002  CB  GLU A 130      -9.652 104.801   3.166  1.00 30.74           C  
ATOM   1003  CG  GLU A 130      -9.409 106.018   2.300  1.00 30.57           C  
ATOM   1004  CD  GLU A 130      -8.554 105.732   1.050  1.00 32.19           C  
ATOM   1005  OE1 GLU A 130      -9.097 106.067  -0.038  1.00 26.94           O  
ATOM   1006  OE2 GLU A 130      -7.410 105.163   1.195  1.00 36.45           O  
ATOM   1007  N   LYS A 131     -11.791 107.042   4.777  1.00 27.90           N  
ATOM   1008  CA  LYS A 131     -12.110 108.423   5.138  1.00 28.91           C  
ATOM   1009  C   LYS A 131     -11.785 108.763   6.627  1.00 26.94           C  
ATOM   1010  O   LYS A 131     -11.726 109.942   7.009  1.00 26.12           O  
ATOM   1011  CB  LYS A 131     -13.594 108.752   4.902  1.00 29.76           C  
ATOM   1012  CG  LYS A 131     -14.228 108.365   3.550  1.00 32.49           C  
ATOM   1013  CD  LYS A 131     -15.555 109.161   3.335  1.00 34.93           C  
ATOM   1014  CE  LYS A 131     -16.844 108.519   3.938  1.00 42.94           C  
ATOM   1015  NZ  LYS A 131     -17.731 107.876   2.885  1.00 45.52           N  
ATOM   1016  N   ALA A 132     -11.629 107.735   7.472  1.00 23.83           N  
ATOM   1017  CA  ALA A 132     -11.346 107.960   8.886  1.00 22.27           C  
ATOM   1018  C   ALA A 132      -9.855 108.248   9.086  1.00 21.52           C  
ATOM   1019  O   ALA A 132      -9.012 107.663   8.406  1.00 20.34           O  
ATOM   1020  CB  ALA A 132     -11.828 106.715   9.729  1.00 20.29           C  
ATOM   1021  N   TRP A 133      -9.526 109.209   9.948  1.00 19.08           N  
ATOM   1022  CA  TRP A 133      -8.164 109.330  10.461  1.00 20.54           C  
ATOM   1023  C   TRP A 133      -8.252 109.610  11.974  1.00 19.01           C  
ATOM   1024  O   TRP A 133      -9.352 109.860  12.497  1.00 19.43           O  
ATOM   1025  CB  TRP A 133      -7.334 110.387   9.731  1.00 20.96           C  
ATOM   1026  CG  TRP A 133      -7.981 111.715   9.497  1.00 23.57           C  
ATOM   1027  CD1 TRP A 133      -8.814 112.064   8.447  1.00 28.30           C  
ATOM   1028  CD2 TRP A 133      -7.850 112.886  10.314  1.00 26.24           C  
ATOM   1029  NE1 TRP A 133      -9.197 113.388   8.574  1.00 27.45           N  
ATOM   1030  CE2 TRP A 133      -8.623 113.911   9.712  1.00 26.19           C  
ATOM   1031  CE3 TRP A 133      -7.170 113.160  11.524  1.00 25.12           C  
ATOM   1032  CZ2 TRP A 133      -8.720 115.207  10.266  1.00 25.39           C  
ATOM   1033  CZ3 TRP A 133      -7.261 114.446  12.078  1.00 24.50           C  
ATOM   1034  CH2 TRP A 133      -8.027 115.453  11.453  1.00 27.37           C  
ATOM   1035  N   PHE A 134      -7.123 109.504  12.644  1.00 17.78           N  
ATOM   1036  CA  PHE A 134      -7.080 109.401  14.118  1.00 17.02           C  
ATOM   1037  C   PHE A 134      -5.916 110.244  14.611  1.00 17.08           C  
ATOM   1038  O   PHE A 134      -4.754 110.203  14.079  1.00 16.66           O  
ATOM   1039  CB  PHE A 134      -6.941 107.927  14.633  1.00 15.34           C  
ATOM   1040  CG  PHE A 134      -7.983 106.980  14.053  1.00 19.49           C  
ATOM   1041  CD1 PHE A 134      -9.131 106.616  14.801  1.00 19.33           C  
ATOM   1042  CD2 PHE A 134      -7.872 106.516  12.724  1.00 15.53           C  
ATOM   1043  CE1 PHE A 134     -10.129 105.749  14.256  1.00 20.58           C  
ATOM   1044  CE2 PHE A 134      -8.880 105.696  12.156  1.00 19.09           C  
ATOM   1045  CZ  PHE A 134     -10.021 105.310  12.913  1.00 19.09           C  
ATOM   1046  N   GLN A 135      -6.210 111.061  15.614  1.00 17.08           N  
ATOM   1047  CA  GLN A 135      -5.167 111.951  16.108  1.00 17.13           C  
ATOM   1048  C   GLN A 135      -5.508 112.247  17.568  1.00 17.33           C  
ATOM   1049  O   GLN A 135      -6.672 112.288  17.901  1.00 16.22           O  
ATOM   1050  CB  GLN A 135      -5.202 113.262  15.325  1.00 16.71           C  
ATOM   1051  CG  GLN A 135      -3.998 114.181  15.664  1.00 18.84           C  
ATOM   1052  CD  GLN A 135      -4.167 115.604  15.103  1.00 18.57           C  
ATOM   1053  OE1 GLN A 135      -5.282 116.044  14.872  1.00 25.38           O  
ATOM   1054  NE2 GLN A 135      -3.059 116.283  14.838  1.00 22.60           N  
ATOM   1055  N   THR A 136      -4.490 112.369  18.408  1.00 17.27           N  
ATOM   1056  CA  THR A 136      -4.677 112.877  19.788  1.00 18.19           C  
ATOM   1057  C   THR A 136      -3.746 114.091  19.966  1.00 17.92           C  
ATOM   1058  O   THR A 136      -2.602 113.961  20.465  1.00 18.94           O  
ATOM   1059  CB  THR A 136      -4.333 111.790  20.853  1.00 18.28           C  
ATOM   1060  OG1 THR A 136      -3.090 111.166  20.482  1.00 19.55           O  
ATOM   1061  CG2 THR A 136      -5.403 110.728  20.928  1.00 20.61           C  
ATOM   1062  N   PRO A 137      -4.188 115.282  19.493  1.00 20.36           N  
ATOM   1063  CA  PRO A 137      -3.327 116.498  19.525  1.00 20.47           C  
ATOM   1064  C   PRO A 137      -3.295 117.219  20.917  1.00 22.40           C  
ATOM   1065  O   PRO A 137      -3.373 118.476  21.009  1.00 22.55           O  
ATOM   1066  CB  PRO A 137      -3.962 117.385  18.466  1.00 21.91           C  
ATOM   1067  CG  PRO A 137      -5.439 117.087  18.503  1.00 19.85           C  
ATOM   1068  CD  PRO A 137      -5.531 115.585  18.947  1.00 18.51           C  
ATOM   1069  N   TYR A 138      -3.108 116.428  21.958  1.00 21.71           N  
ATOM   1070  CA  TYR A 138      -3.147 116.885  23.363  1.00 24.01           C  
ATOM   1071  C   TYR A 138      -2.126 118.004  23.634  1.00 24.06           C  
ATOM   1072  O   TYR A 138      -2.500 119.098  24.080  1.00 23.71           O  
ATOM   1073  CB  TYR A 138      -2.857 115.703  24.260  1.00 22.87           C  
ATOM   1074  CG  TYR A 138      -3.970 114.695  24.276  1.00 23.73           C  
ATOM   1075  CD1 TYR A 138      -5.280 115.099  24.398  1.00 24.58           C  
ATOM   1076  CD2 TYR A 138      -3.700 113.316  24.213  1.00 23.91           C  
ATOM   1077  CE1 TYR A 138      -6.286 114.177  24.464  1.00 25.97           C  
ATOM   1078  CE2 TYR A 138      -4.718 112.371  24.256  1.00 23.43           C  
ATOM   1079  CZ  TYR A 138      -6.013 112.830  24.378  1.00 22.59           C  
ATOM   1080  OH  TYR A 138      -7.108 111.991  24.402  1.00 29.07           O  
ATOM   1081  N   THR A 139      -0.863 117.762  23.303  1.00 26.55           N  
ATOM   1082  CA  THR A 139       0.211 118.774  23.497  1.00 29.33           C  
ATOM   1083  C   THR A 139      -0.047 120.113  22.793  1.00 29.23           C  
ATOM   1084  O   THR A 139       0.178 121.149  23.398  1.00 30.59           O  
ATOM   1085  CB  THR A 139       1.630 118.217  23.216  1.00 30.24           C  
ATOM   1086  OG1 THR A 139       1.728 117.802  21.836  1.00 31.79           O  
ATOM   1087  CG2 THR A 139       1.873 117.041  24.127  1.00 28.97           C  
ATOM   1088  N   THR A 140      -0.567 120.075  21.566  1.00 30.21           N  
ATOM   1089  CA  THR A 140      -1.050 121.246  20.821  1.00 30.98           C  
ATOM   1090  C   THR A 140      -2.127 122.026  21.591  1.00 30.34           C  
ATOM   1091  O   THR A 140      -2.130 123.258  21.629  1.00 30.23           O  
ATOM   1092  CB  THR A 140      -1.664 120.786  19.452  1.00 31.08           C  
ATOM   1093  OG1 THR A 140      -0.615 120.282  18.630  1.00 35.04           O  
ATOM   1094  CG2 THR A 140      -2.421 121.895  18.721  1.00 32.50           C  
ATOM   1095  N   PHE A 141      -3.064 121.312  22.177  1.00 29.16           N  
ATOM   1096  CA  PHE A 141      -4.132 121.948  22.931  1.00 28.51           C  
ATOM   1097  C   PHE A 141      -3.692 122.226  24.367  1.00 27.31           C  
ATOM   1098  O   PHE A 141      -4.468 122.733  25.146  1.00 28.19           O  
ATOM   1099  CB  PHE A 141      -5.418 121.095  22.868  1.00 27.91           C  
ATOM   1100  CG  PHE A 141      -6.182 121.269  21.569  1.00 33.24           C  
ATOM   1101  CD1 PHE A 141      -7.222 122.229  21.478  1.00 35.48           C  
ATOM   1102  CD2 PHE A 141      -5.836 120.557  20.439  1.00 32.78           C  
ATOM   1103  CE1 PHE A 141      -7.934 122.428  20.256  1.00 35.66           C  
ATOM   1104  CE2 PHE A 141      -6.547 120.735  19.210  1.00 34.89           C  
ATOM   1105  CZ  PHE A 141      -7.579 121.677  19.117  1.00 32.63           C  
ATOM   1106  N   GLY A 142      -2.458 121.891  24.697  1.00 26.90           N  
ATOM   1107  CA  GLY A 142      -1.870 122.179  26.011  1.00 26.96           C  
ATOM   1108  C   GLY A 142      -2.390 121.317  27.166  1.00 27.31           C  
ATOM   1109  O   GLY A 142      -2.386 121.750  28.347  1.00 26.60           O  
ATOM   1110  N   GLN A 143      -2.781 120.076  26.862  1.00 27.10           N  
ATOM   1111  CA  GLN A 143      -3.268 119.156  27.935  1.00 27.00           C  
ATOM   1112  C   GLN A 143      -2.507 117.855  27.955  1.00 26.73           C  
ATOM   1113  O   GLN A 143      -1.942 117.437  26.948  1.00 27.19           O  
ATOM   1114  CB  GLN A 143      -4.780 118.889  27.812  1.00 27.29           C  
ATOM   1115  CG  GLN A 143      -5.186 118.106  26.555  1.00 27.06           C  
ATOM   1116  CD  GLN A 143      -6.616 117.564  26.621  1.00 28.44           C  
ATOM   1117  OE1 GLN A 143      -6.907 116.557  27.283  1.00 28.34           O  
ATOM   1118  NE2 GLN A 143      -7.508 118.202  25.884  1.00 33.12           N  
ATOM   1119  N   SER A 144      -2.481 117.224  29.115  1.00 26.55           N  
ATOM   1120  CA  SER A 144      -2.027 115.870  29.200  1.00 26.32           C  
ATOM   1121  C   SER A 144      -3.141 114.966  28.635  1.00 25.08           C  
ATOM   1122  O   SER A 144      -4.263 115.412  28.365  1.00 23.53           O  
ATOM   1123  CB  SER A 144      -1.712 115.562  30.676  1.00 27.02           C  
ATOM   1124  OG  SER A 144      -2.802 116.027  31.461  1.00 29.62           O  
ATOM   1125  N   PRO A 145      -2.846 113.689  28.444  1.00 25.68           N  
ATOM   1126  CA  PRO A 145      -3.871 112.840  27.801  1.00 25.35           C  
ATOM   1127  C   PRO A 145      -5.085 112.436  28.639  1.00 25.93           C  
ATOM   1128  O   PRO A 145      -5.040 112.496  29.876  1.00 27.41           O  
ATOM   1129  CB  PRO A 145      -3.072 111.601  27.409  1.00 23.36           C  
ATOM   1130  CG  PRO A 145      -1.637 112.052  27.415  1.00 25.76           C  
ATOM   1131  CD  PRO A 145      -1.599 112.942  28.655  1.00 24.84           C  
ATOM   1132  N   ASP A 146      -6.138 111.958  27.967  1.00 25.87           N  
ATOM   1133  CA  ASP A 146      -7.371 111.482  28.624  1.00 25.39           C  
ATOM   1134  C   ASP A 146      -7.889 110.147  28.046  1.00 23.70           C  
ATOM   1135  O   ASP A 146      -7.258 109.568  27.155  1.00 22.09           O  
ATOM   1136  CB  ASP A 146      -8.434 112.565  28.543  1.00 26.11           C  
ATOM   1137  CG  ASP A 146      -8.637 113.087  27.113  1.00 31.34           C  
ATOM   1138  OD1 ASP A 146      -8.612 112.267  26.156  1.00 35.91           O  
ATOM   1139  OD2 ASP A 146      -8.869 114.317  26.941  1.00 39.60           O  
ATOM   1140  N   GLY A 147      -8.993 109.641  28.591  1.00 21.51           N  
ATOM   1141  CA  GLY A 147      -9.652 108.431  28.103  1.00 20.50           C  
ATOM   1142  C   GLY A 147      -8.828 107.182  28.370  1.00 21.15           C  
ATOM   1143  O   GLY A 147      -8.969 106.180  27.664  1.00 22.26           O  
ATOM   1144  N   CYS A 148      -7.959 107.240  29.386  1.00 19.12           N  
ATOM   1145  CA  CYS A 148      -7.012 106.160  29.734  1.00 20.45           C  
ATOM   1146  C   CYS A 148      -5.985 105.899  28.646  1.00 19.37           C  
ATOM   1147  O   CYS A 148      -5.373 104.843  28.638  1.00 18.41           O  
ATOM   1148  CB  CYS A 148      -7.704 104.797  30.052  1.00 20.29           C  
ATOM   1149  SG  CYS A 148      -9.083 104.774  31.197  1.00 22.88           S  
ATOM   1150  N   SER A 149      -5.769 106.863  27.745  1.00 18.64           N  
ATOM   1151  CA  SER A 149      -4.799 106.638  26.652  1.00 19.66           C  
ATOM   1152  C   SER A 149      -3.368 106.548  27.173  1.00 19.44           C  
ATOM   1153  O   SER A 149      -2.545 105.923  26.540  1.00 18.04           O  
ATOM   1154  CB  SER A 149      -4.927 107.725  25.567  1.00 19.21           C  
ATOM   1155  OG  SER A 149      -4.590 109.031  26.119  1.00 22.17           O  
ATOM   1156  N   THR A 150      -3.064 107.153  28.329  1.00 18.99           N  
ATOM   1157  CA  THR A 150      -1.728 107.047  28.880  1.00 20.74           C  
ATOM   1158  C   THR A 150      -1.334 105.592  29.169  1.00 20.41           C  
ATOM   1159  O   THR A 150      -0.137 105.249  29.114  1.00 23.25           O  
ATOM   1160  CB  THR A 150      -1.522 107.926  30.194  1.00 19.86           C  
ATOM   1161  OG1 THR A 150      -2.398 107.458  31.236  1.00 18.46           O  
ATOM   1162  CG2 THR A 150      -1.743 109.418  29.889  1.00 21.95           C  
ATOM   1163  N   VAL A 151      -2.289 104.742  29.504  1.00 20.76           N  
ATOM   1164  CA  VAL A 151      -2.008 103.300  29.610  1.00 20.20           C  
ATOM   1165  C   VAL A 151      -2.408 102.454  28.378  1.00 19.65           C  
ATOM   1166  O   VAL A 151      -1.729 101.491  28.001  1.00 21.01           O  
ATOM   1167  CB  VAL A 151      -2.548 102.626  30.924  1.00 20.64           C  
ATOM   1168  CG1 VAL A 151      -2.095 103.458  32.150  1.00 21.93           C  
ATOM   1169  CG2 VAL A 151      -4.041 102.456  30.924  1.00 21.46           C  
ATOM   1170  N   MET A 152      -3.506 102.808  27.754  1.00 18.81           N  
ATOM   1171  CA  MET A 152      -4.035 101.982  26.660  1.00 17.28           C  
ATOM   1172  C   MET A 152      -3.208 102.128  25.369  1.00 16.60           C  
ATOM   1173  O   MET A 152      -2.979 101.094  24.695  1.00 16.33           O  
ATOM   1174  CB  MET A 152      -5.534 102.275  26.370  1.00 15.09           C  
ATOM   1175  CG  MET A 152      -6.531 101.710  27.442  1.00 17.11           C  
ATOM   1176  SD  MET A 152      -6.217  99.944  27.724  1.00 29.76           S  
ATOM   1177  CE  MET A 152      -6.478  99.217  26.107  1.00 27.98           C  
ATOM   1178  N   PHE A 153      -2.765 103.336  25.041  1.00 16.27           N  
ATOM   1179  CA  PHE A 153      -1.978 103.504  23.762  1.00 18.71           C  
ATOM   1180  C   PHE A 153      -0.644 102.716  23.837  1.00 18.77           C  
ATOM   1181  O   PHE A 153      -0.340 101.940  22.935  1.00 18.04           O  
ATOM   1182  CB  PHE A 153      -1.738 105.000  23.397  1.00 18.80           C  
ATOM   1183  CG  PHE A 153      -2.891 105.678  22.703  1.00 19.01           C  
ATOM   1184  CD1 PHE A 153      -4.222 105.252  22.891  1.00 20.34           C  
ATOM   1185  CD2 PHE A 153      -2.647 106.786  21.865  1.00 21.79           C  
ATOM   1186  CE1 PHE A 153      -5.272 105.865  22.263  1.00 20.89           C  
ATOM   1187  CE2 PHE A 153      -3.724 107.429  21.244  1.00 23.36           C  
ATOM   1188  CZ  PHE A 153      -5.029 106.944  21.439  1.00 24.23           C  
ATOM   1189  N   PRO A 154       0.130 102.823  24.967  1.00 19.10           N  
ATOM   1190  CA  PRO A 154       1.300 101.943  24.990  1.00 20.61           C  
ATOM   1191  C   PRO A 154       0.944 100.466  24.885  1.00 21.32           C  
ATOM   1192  O   PRO A 154       1.685  99.713  24.246  1.00 22.26           O  
ATOM   1193  CB  PRO A 154       1.962 102.288  26.351  1.00 20.31           C  
ATOM   1194  CG  PRO A 154       1.571 103.656  26.603  1.00 19.31           C  
ATOM   1195  CD  PRO A 154       0.093 103.642  26.186  1.00 21.34           C  
ATOM   1196  N   LYS A 155      -0.201 100.050  25.454  1.00 22.97           N  
ATOM   1197  CA  LYS A 155      -0.647  98.665  25.370  1.00 23.05           C  
ATOM   1198  C   LYS A 155      -0.982  98.176  23.957  1.00 23.73           C  
ATOM   1199  O   LYS A 155      -0.672  97.045  23.656  1.00 26.59           O  
ATOM   1200  CB  LYS A 155      -1.748  98.344  26.375  1.00 23.23           C  
ATOM   1201  CG  LYS A 155      -1.187  98.215  27.830  1.00 24.98           C  
ATOM   1202  CD  LYS A 155      -2.267  97.988  28.857  1.00 25.77           C  
ATOM   1203  CE  LYS A 155      -1.597  97.962  30.240  1.00 32.89           C  
ATOM   1204  NZ  LYS A 155      -0.787  96.698  30.446  1.00 33.26           N  
ATOM   1205  N   ILE A 156      -1.528  99.014  23.079  1.00 23.02           N  
ATOM   1206  CA  ILE A 156      -2.025  98.556  21.779  1.00 21.55           C  
ATOM   1207  C   ILE A 156      -1.000  98.806  20.646  1.00 22.88           C  
ATOM   1208  O   ILE A 156      -1.054  98.122  19.616  1.00 22.34           O  
ATOM   1209  CB  ILE A 156      -3.398  99.190  21.427  1.00 20.99           C  
ATOM   1210  CG1 ILE A 156      -3.252 100.715  21.135  1.00 18.91           C  
ATOM   1211  CG2 ILE A 156      -4.435  98.925  22.560  1.00 18.85           C  
ATOM   1212  CD1 ILE A 156      -4.615 101.496  20.819  1.00 22.18           C  
ATOM   1213  N   MET A 157      -0.093  99.771  20.823  1.00 21.09           N  
ATOM   1214  CA  MET A 157       0.890 100.101  19.777  1.00 22.17           C  
ATOM   1215  C   MET A 157       2.356 100.129  20.214  1.00 21.32           C  
ATOM   1216  O   MET A 157       3.251 100.315  19.405  1.00 22.57           O  
ATOM   1217  CB  MET A 157       0.475 101.388  19.075  1.00 21.02           C  
ATOM   1218  CG  MET A 157       0.553 102.695  19.938  1.00 20.00           C  
ATOM   1219  SD  MET A 157      -0.069 104.188  19.169  1.00 22.39           S  
ATOM   1220  CE  MET A 157      -1.820 103.856  19.031  1.00 22.15           C  
ATOM   1221  N   GLY A 158       2.577  99.988  21.513  1.00 21.07           N  
ATOM   1222  CA  GLY A 158       3.909 100.019  22.105  1.00 20.86           C  
ATOM   1223  C   GLY A 158       4.310 101.456  22.404  1.00 22.20           C  
ATOM   1224  O   GLY A 158       3.743 102.396  21.838  1.00 21.51           O  
ATOM   1225  N   GLY A 159       5.290 101.640  23.287  1.00 21.59           N  
ATOM   1226  CA  GLY A 159       5.653 103.002  23.741  1.00 22.11           C  
ATOM   1227  C   GLY A 159       6.080 104.011  22.699  1.00 21.20           C  
ATOM   1228  O   GLY A 159       5.619 105.166  22.733  1.00 22.26           O  
ATOM   1229  N   ALA A 160       6.922 103.586  21.745  1.00 20.62           N  
ATOM   1230  CA  ALA A 160       7.471 104.503  20.756  1.00 21.19           C  
ATOM   1231  C   ALA A 160       6.326 105.115  19.972  1.00 20.41           C  
ATOM   1232  O   ALA A 160       6.242 106.334  19.841  1.00 21.64           O  
ATOM   1233  CB  ALA A 160       8.522 103.808  19.821  1.00 20.73           C  
ATOM   1234  N   SER A 161       5.421 104.273  19.491  1.00 20.86           N  
ATOM   1235  CA  SER A 161       4.252 104.751  18.733  1.00 20.37           C  
ATOM   1236  C   SER A 161       3.271 105.527  19.601  1.00 18.78           C  
ATOM   1237  O   SER A 161       2.712 106.509  19.151  1.00 17.55           O  
ATOM   1238  CB  SER A 161       3.531 103.587  18.045  1.00 21.63           C  
ATOM   1239  OG  SER A 161       4.322 103.065  16.951  1.00 24.88           O  
ATOM   1240  N   ALA A 162       3.038 105.052  20.818  1.00 18.49           N  
ATOM   1241  CA  ALA A 162       2.090 105.735  21.727  1.00 18.27           C  
ATOM   1242  C   ALA A 162       2.586 107.162  22.071  1.00 17.82           C  
ATOM   1243  O   ALA A 162       1.828 108.094  21.999  1.00 18.36           O  
ATOM   1244  CB  ALA A 162       1.908 104.888  23.021  1.00 14.90           C  
ATOM   1245  N   ASN A 163       3.846 107.321  22.428  1.00 18.95           N  
ATOM   1246  CA  ASN A 163       4.452 108.663  22.675  1.00 19.85           C  
ATOM   1247  C   ASN A 163       4.444 109.577  21.479  1.00 20.89           C  
ATOM   1248  O   ASN A 163       4.151 110.768  21.608  1.00 21.16           O  
ATOM   1249  CB  ASN A 163       5.869 108.518  23.219  1.00 20.88           C  
ATOM   1250  CG  ASN A 163       5.877 107.964  24.629  1.00 25.43           C  
ATOM   1251  OD1 ASN A 163       6.617 107.024  24.953  1.00 27.16           O  
ATOM   1252  ND2 ASN A 163       4.975 108.475  25.447  1.00 27.29           N  
ATOM   1253  N   GLU A 164       4.672 109.008  20.285  1.00 19.43           N  
ATOM   1254  CA  GLU A 164       4.537 109.813  19.089  1.00 19.82           C  
ATOM   1255  C   GLU A 164       3.100 110.395  18.954  1.00 18.65           C  
ATOM   1256  O   GLU A 164       2.920 111.588  18.651  1.00 20.09           O  
ATOM   1257  CB  GLU A 164       5.009 109.007  17.890  1.00 17.85           C  
ATOM   1258  CG  GLU A 164       5.452 109.974  16.776  1.00 24.97           C  
ATOM   1259  CD  GLU A 164       5.322 109.395  15.389  1.00 26.29           C  
ATOM   1260  OE1 GLU A 164       4.628 108.357  15.234  1.00 24.14           O  
ATOM   1261  OE2 GLU A 164       5.905 110.003  14.455  1.00 27.02           O  
ATOM   1262  N   MET A 165       2.079 109.568  19.189  1.00 19.05           N  
ATOM   1263  CA  MET A 165       0.687 110.038  19.133  1.00 19.53           C  
ATOM   1264  C   MET A 165       0.419 111.033  20.247  1.00 20.85           C  
ATOM   1265  O   MET A 165      -0.181 112.033  19.986  1.00 22.68           O  
ATOM   1266  CB  MET A 165      -0.351 108.887  19.251  1.00 16.27           C  
ATOM   1267  CG  MET A 165      -0.273 107.830  18.144  1.00 21.48           C  
ATOM   1268  SD  MET A 165      -0.748 108.750  16.660  1.00 25.81           S  
ATOM   1269  CE  MET A 165      -2.518 108.799  16.973  1.00 27.57           C  
ATOM   1270  N   LEU A 166       0.844 110.731  21.479  1.00 20.86           N  
ATOM   1271  CA  LEU A 166       0.439 111.519  22.637  1.00 22.91           C  
ATOM   1272  C   LEU A 166       1.233 112.837  22.827  1.00 23.63           C  
ATOM   1273  O   LEU A 166       0.626 113.826  23.258  1.00 25.88           O  
ATOM   1274  CB  LEU A 166       0.440 110.683  23.950  1.00 22.26           C  
ATOM   1275  CG  LEU A 166      -0.532 109.491  24.045  1.00 22.03           C  
ATOM   1276  CD1 LEU A 166      -0.238 108.673  25.314  1.00 24.34           C  
ATOM   1277  CD2 LEU A 166      -1.964 109.922  24.001  1.00 22.17           C  
ATOM   1278  N   LEU A 167       2.536 112.839  22.508  1.00 24.10           N  
ATOM   1279  CA  LEU A 167       3.419 114.013  22.552  1.00 25.60           C  
ATOM   1280  C   LEU A 167       3.453 114.781  21.246  1.00 27.14           C  
ATOM   1281  O   LEU A 167       3.570 116.020  21.271  1.00 27.91           O  
ATOM   1282  CB  LEU A 167       4.860 113.598  22.927  1.00 26.19           C  
ATOM   1283  CG  LEU A 167       4.920 112.811  24.220  1.00 27.76           C  
ATOM   1284  CD1 LEU A 167       6.339 112.380  24.583  1.00 30.50           C  
ATOM   1285  CD2 LEU A 167       4.251 113.622  25.361  1.00 32.52           C  
ATOM   1286  N   SER A 168       3.383 114.070  20.110  1.00 26.70           N  
ATOM   1287  CA  SER A 168       3.698 114.695  18.809  1.00 27.73           C  
ATOM   1288  C   SER A 168       2.473 115.095  17.994  1.00 27.00           C  
ATOM   1289  O   SER A 168       2.618 115.832  16.996  1.00 27.42           O  
ATOM   1290  CB  SER A 168       4.621 113.799  17.969  1.00 28.33           C  
ATOM   1291  OG  SER A 168       5.937 113.768  18.553  1.00 34.07           O  
ATOM   1292  N   GLY A 169       1.277 114.628  18.391  1.00 25.01           N  
ATOM   1293  CA  GLY A 169       0.072 114.934  17.622  1.00 25.66           C  
ATOM   1294  C   GLY A 169       0.080 114.327  16.196  1.00 25.11           C  
ATOM   1295  O   GLY A 169      -0.611 114.841  15.270  1.00 26.33           O  
ATOM   1296  N   ARG A 170       0.788 113.216  16.025  1.00 24.71           N  
ATOM   1297  CA  ARG A 170       0.750 112.499  14.737  1.00 24.95           C  
ATOM   1298  C   ARG A 170      -0.698 112.130  14.317  1.00 25.21           C  
ATOM   1299  O   ARG A 170      -1.475 111.650  15.137  1.00 23.49           O  
ATOM   1300  CB  ARG A 170       1.652 111.287  14.705  1.00 24.24           C  
ATOM   1301  CG  ARG A 170       1.698 110.698  13.208  1.00 25.88           C  
ATOM   1302  CD  ARG A 170       2.450 109.462  13.187  1.00 25.57           C  
ATOM   1303  NE  ARG A 170       2.264 108.744  11.932  1.00 20.95           N  
ATOM   1304  CZ  ARG A 170       2.917 107.640  11.645  1.00 23.68           C  
ATOM   1305  NH1 ARG A 170       3.762 107.154  12.527  1.00 20.26           N  
ATOM   1306  NH2 ARG A 170       2.732 107.027  10.464  1.00 28.82           N  
ATOM   1307  N   LYS A 171      -1.069 112.430  13.066  1.00 25.13           N  
ATOM   1308  CA  LYS A 171      -2.317 111.952  12.481  1.00 26.38           C  
ATOM   1309  C   LYS A 171      -2.113 110.601  11.777  1.00 26.22           C  
ATOM   1310  O   LYS A 171      -1.199 110.431  10.944  1.00 28.85           O  
ATOM   1311  CB  LYS A 171      -2.897 112.939  11.439  1.00 26.38           C  
ATOM   1312  CG  LYS A 171      -3.282 114.344  11.936  1.00 28.80           C  
ATOM   1313  CD  LYS A 171      -4.022 115.197  10.855  1.00 29.92           C  
ATOM   1314  CE  LYS A 171      -3.896 116.692  11.213  1.00 35.25           C  
ATOM   1315  NZ  LYS A 171      -4.791 117.592  10.405  1.00 35.90           N  
ATOM   1316  N   LEU A 172      -2.965 109.643  12.070  1.00 23.62           N  
ATOM   1317  CA  LEU A 172      -2.872 108.307  11.427  1.00 22.06           C  
ATOM   1318  C   LEU A 172      -3.971 108.128  10.409  1.00 21.08           C  
ATOM   1319  O   LEU A 172      -5.111 108.372  10.730  1.00 20.13           O  
ATOM   1320  CB  LEU A 172      -3.051 107.230  12.486  1.00 22.01           C  
ATOM   1321  CG  LEU A 172      -2.054 107.150  13.634  1.00 21.06           C  
ATOM   1322  CD1 LEU A 172      -2.478 106.030  14.635  1.00 22.15           C  
ATOM   1323  CD2 LEU A 172      -0.656 106.884  13.063  1.00 20.58           C  
ATOM   1324  N   THR A 173      -3.671 107.609   9.207  1.00 20.23           N  
ATOM   1325  CA  THR A 173      -4.752 107.150   8.332  1.00 19.80           C  
ATOM   1326  C   THR A 173      -5.343 105.910   9.009  1.00 19.83           C  
ATOM   1327  O   THR A 173      -4.775 105.409  10.005  1.00 18.06           O  
ATOM   1328  CB  THR A 173      -4.240 106.674   6.943  1.00 18.87           C  
ATOM   1329  OG1 THR A 173      -3.313 105.614   7.161  1.00 19.24           O  
ATOM   1330  CG2 THR A 173      -3.541 107.797   6.239  1.00 21.81           C  
ATOM   1331  N   ALA A 174      -6.497 105.491   8.509  1.00 18.32           N  
ATOM   1332  CA  ALA A 174      -7.242 104.289   8.909  1.00 18.21           C  
ATOM   1333  C   ALA A 174      -6.355 103.038   8.867  1.00 17.97           C  
ATOM   1334  O   ALA A 174      -6.220 102.315   9.883  1.00 16.26           O  
ATOM   1335  CB  ALA A 174      -8.600 104.129   8.043  1.00 18.01           C  
ATOM   1336  N   GLN A 175      -5.651 102.838   7.746  1.00 18.14           N  
ATOM   1337  CA  GLN A 175      -4.709 101.767   7.606  1.00 19.30           C  
ATOM   1338  C   GLN A 175      -3.592 101.848   8.592  1.00 17.97           C  
ATOM   1339  O   GLN A 175      -3.188 100.788   9.107  1.00 17.62           O  
ATOM   1340  CB  GLN A 175      -4.064 101.708   6.196  1.00 20.40           C  
ATOM   1341  CG  GLN A 175      -5.057 101.521   5.054  1.00 30.40           C  
ATOM   1342  CD  GLN A 175      -5.450 100.053   4.882  1.00 42.04           C  
ATOM   1343  OE1 GLN A 175      -6.518  99.720   4.313  1.00 44.05           O  
ATOM   1344  NE2 GLN A 175      -4.564  99.156   5.354  1.00 46.50           N  
ATOM   1345  N   GLU A 176      -3.043 103.035   8.838  1.00 17.48           N  
ATOM   1346  CA  GLU A 176      -1.947 103.120   9.832  1.00 19.90           C  
ATOM   1347  C   GLU A 176      -2.496 102.849  11.259  1.00 18.16           C  
ATOM   1348  O   GLU A 176      -1.782 102.271  12.107  1.00 19.59           O  
ATOM   1349  CB  GLU A 176      -1.274 104.473   9.876  1.00 19.13           C  
ATOM   1350  CG  GLU A 176      -0.522 104.838   8.598  1.00 24.48           C  
ATOM   1351  CD  GLU A 176       0.004 106.282   8.607  1.00 25.34           C  
ATOM   1352  OE1 GLU A 176      -0.704 107.281   8.980  1.00 25.82           O  
ATOM   1353  OE2 GLU A 176       1.182 106.401   8.191  1.00 30.49           O  
ATOM   1354  N   ALA A 177      -3.715 103.309  11.525  1.00 17.62           N  
ATOM   1355  CA  ALA A 177      -4.367 103.065  12.864  1.00 17.06           C  
ATOM   1356  C   ALA A 177      -4.647 101.584  13.070  1.00 18.93           C  
ATOM   1357  O   ALA A 177      -4.570 101.062  14.226  1.00 18.34           O  
ATOM   1358  CB  ALA A 177      -5.601 103.821  12.993  1.00 15.71           C  
ATOM   1359  N   CYS A 178      -4.939 100.869  11.983  1.00 19.77           N  
ATOM   1360  CA  CYS A 178      -5.062  99.422  12.032  1.00 20.61           C  
ATOM   1361  C   CYS A 178      -3.713  98.767  12.429  1.00 20.16           C  
ATOM   1362  O   CYS A 178      -3.682  97.948  13.343  1.00 19.60           O  
ATOM   1363  CB  CYS A 178      -5.652  98.875  10.706  1.00 20.11           C  
ATOM   1364  SG  CYS A 178      -6.108  97.207  10.754  1.00 27.40           S  
ATOM   1365  N   GLY A 179      -2.625  99.114  11.744  1.00 20.64           N  
ATOM   1366  CA  GLY A 179      -1.241  98.719  12.133  1.00 21.32           C  
ATOM   1367  C   GLY A 179      -0.887  99.032  13.589  1.00 21.75           C  
ATOM   1368  O   GLY A 179      -0.200  98.238  14.265  1.00 23.31           O  
ATOM   1369  N   LYS A 180      -1.385 100.143  14.088  1.00 19.14           N  
ATOM   1370  CA  LYS A 180      -1.043 100.595  15.452  1.00 21.66           C  
ATOM   1371  C   LYS A 180      -2.074 100.137  16.499  1.00 22.10           C  
ATOM   1372  O   LYS A 180      -2.098 100.739  17.575  1.00 23.80           O  
ATOM   1373  CB  LYS A 180      -1.005 102.131  15.526  1.00 19.75           C  
ATOM   1374  CG  LYS A 180      -0.069 102.820  14.568  1.00 26.69           C  
ATOM   1375  CD  LYS A 180       1.322 102.876  14.953  1.00 29.52           C  
ATOM   1376  CE  LYS A 180       2.034 103.951  14.066  1.00 30.48           C  
ATOM   1377  NZ  LYS A 180       3.490 103.956  14.335  1.00 29.02           N  
ATOM   1378  N   GLY A 181      -2.971  99.197  16.147  1.00 21.12           N  
ATOM   1379  CA  GLY A 181      -3.881  98.524  17.115  1.00 20.11           C  
ATOM   1380  C   GLY A 181      -5.104  99.288  17.534  1.00 19.54           C  
ATOM   1381  O   GLY A 181      -5.836  98.858  18.460  1.00 18.35           O  
ATOM   1382  N   LEU A 182      -5.345 100.440  16.913  1.00 18.42           N  
ATOM   1383  CA  LEU A 182      -6.521 101.265  17.256  1.00 19.57           C  
ATOM   1384  C   LEU A 182      -7.783 100.777  16.577  1.00 19.13           C  
ATOM   1385  O   LEU A 182      -8.884 100.857  17.153  1.00 18.29           O  
ATOM   1386  CB  LEU A 182      -6.332 102.709  16.827  1.00 20.70           C  
ATOM   1387  CG  LEU A 182      -6.044 103.778  17.842  1.00 24.38           C  
ATOM   1388  CD1 LEU A 182      -5.778 105.176  17.089  1.00 24.29           C  
ATOM   1389  CD2 LEU A 182      -7.210 103.846  18.946  1.00 21.28           C  
ATOM   1390  N   VAL A 183      -7.609 100.233  15.366  1.00 18.03           N  
ATOM   1391  CA  VAL A 183      -8.700  99.852  14.471  1.00 17.85           C  
ATOM   1392  C   VAL A 183      -8.564  98.320  14.226  1.00 18.67           C  
ATOM   1393  O   VAL A 183      -7.458  97.848  13.959  1.00 19.40           O  
ATOM   1394  CB  VAL A 183      -8.633 100.655  13.089  1.00 17.42           C  
ATOM   1395  CG1 VAL A 183      -9.509 100.019  12.023  1.00 20.63           C  
ATOM   1396  CG2 VAL A 183      -9.042 102.176  13.275  1.00 15.36           C  
ATOM   1397  N   SER A 184      -9.696  97.599  14.231  1.00 17.81           N  
ATOM   1398  CA  SER A 184      -9.722  96.158  14.064  1.00 18.26           C  
ATOM   1399  C   SER A 184      -9.543  95.817  12.599  1.00 19.30           C  
ATOM   1400  O   SER A 184      -8.765  94.929  12.260  1.00 17.99           O  
ATOM   1401  CB  SER A 184     -11.076  95.582  14.532  1.00 19.11           C  
ATOM   1402  OG  SER A 184     -11.409  95.876  15.899  1.00 20.72           O  
ATOM   1403  N   GLN A 185     -10.290  96.507  11.742  1.00 19.75           N  
ATOM   1404  CA  GLN A 185     -10.214  96.235  10.320  1.00 20.61           C  
ATOM   1405  C   GLN A 185     -10.710  97.452   9.560  1.00 19.68           C  
ATOM   1406  O   GLN A 185     -11.567  98.166  10.073  1.00 19.02           O  
ATOM   1407  CB  GLN A 185     -11.083  94.999  10.006  1.00 20.45           C  
ATOM   1408  CG  GLN A 185     -10.894  94.504   8.518  1.00 19.66           C  
ATOM   1409  CD  GLN A 185     -11.604  93.191   8.259  1.00 22.21           C  
ATOM   1410  OE1 GLN A 185     -12.193  92.544   9.166  1.00 19.33           O  
ATOM   1411  NE2 GLN A 185     -11.580  92.785   7.014  1.00 21.88           N  
ATOM   1412  N   VAL A 186     -10.185  97.659   8.330  1.00 20.16           N  
ATOM   1413  CA  VAL A 186     -10.530  98.784   7.465  1.00 20.95           C  
ATOM   1414  C   VAL A 186     -11.286  98.260   6.218  1.00 22.51           C  
ATOM   1415  O   VAL A 186     -10.891  97.250   5.638  1.00 22.16           O  
ATOM   1416  CB  VAL A 186      -9.293  99.591   7.020  1.00 21.44           C  
ATOM   1417  CG1 VAL A 186      -9.686 100.813   6.090  1.00 18.77           C  
ATOM   1418  CG2 VAL A 186      -8.495 100.087   8.228  1.00 21.69           C  
ATOM   1419  N   PHE A 187     -12.411  98.892   5.877  1.00 23.02           N  
ATOM   1420  CA  PHE A 187     -13.211  98.458   4.735  1.00 25.56           C  
ATOM   1421  C   PHE A 187     -13.213  99.544   3.685  1.00 26.53           C  
ATOM   1422  O   PHE A 187     -12.988 100.693   4.002  1.00 26.14           O  
ATOM   1423  CB  PHE A 187     -14.646  98.168   5.158  1.00 24.34           C  
ATOM   1424  CG  PHE A 187     -14.762  97.095   6.218  1.00 26.87           C  
ATOM   1425  CD1 PHE A 187     -14.464  95.767   5.925  1.00 26.80           C  
ATOM   1426  CD2 PHE A 187     -15.128  97.422   7.519  1.00 26.36           C  
ATOM   1427  CE1 PHE A 187     -14.528  94.771   6.937  1.00 26.54           C  
ATOM   1428  CE2 PHE A 187     -15.210  96.418   8.521  1.00 26.00           C  
ATOM   1429  CZ  PHE A 187     -14.922  95.108   8.205  1.00 26.48           C  
ATOM   1430  N   TRP A 188     -13.503  99.206   2.429  1.00 29.88           N  
ATOM   1431  CA  TRP A 188     -13.693 100.278   1.437  1.00 33.89           C  
ATOM   1432  C   TRP A 188     -14.877 101.167   1.805  1.00 33.98           C  
ATOM   1433  O   TRP A 188     -15.871 100.667   2.313  1.00 31.93           O  
ATOM   1434  CB  TRP A 188     -13.940  99.746   0.040  1.00 37.21           C  
ATOM   1435  CG  TRP A 188     -12.715  99.497  -0.781  1.00 43.40           C  
ATOM   1436  CD1 TRP A 188     -11.614  98.732  -0.432  1.00 46.51           C  
ATOM   1437  CD2 TRP A 188     -12.482  99.953  -2.138  1.00 46.54           C  
ATOM   1438  NE1 TRP A 188     -10.720  98.693  -1.494  1.00 49.43           N  
ATOM   1439  CE2 TRP A 188     -11.226  99.422  -2.549  1.00 48.07           C  
ATOM   1440  CE3 TRP A 188     -13.224 100.737  -3.049  1.00 48.81           C  
ATOM   1441  CZ2 TRP A 188     -10.679  99.663  -3.839  1.00 45.34           C  
ATOM   1442  CZ3 TRP A 188     -12.676 100.979  -4.340  1.00 46.69           C  
ATOM   1443  CH2 TRP A 188     -11.421 100.432  -4.707  1.00 45.39           C  
ATOM   1444  N   PRO A 189     -14.776 102.486   1.524  1.00 34.87           N  
ATOM   1445  CA  PRO A 189     -15.844 103.403   1.883  1.00 35.45           C  
ATOM   1446  C   PRO A 189     -17.195 103.056   1.253  1.00 36.73           C  
ATOM   1447  O   PRO A 189     -18.218 103.183   1.916  1.00 36.76           O  
ATOM   1448  CB  PRO A 189     -15.327 104.757   1.378  1.00 35.13           C  
ATOM   1449  CG  PRO A 189     -13.903 104.636   1.358  1.00 35.14           C  
ATOM   1450  CD  PRO A 189     -13.650 103.212   0.903  1.00 35.07           C  
ATOM   1451  N   GLY A 190     -17.185 102.592  -0.004  1.00 37.14           N  
ATOM   1452  CA  GLY A 190     -18.402 102.294  -0.728  1.00 37.31           C  
ATOM   1453  C   GLY A 190     -19.265 101.177  -0.184  1.00 37.66           C  
ATOM   1454  O   GLY A 190     -20.483 101.214  -0.315  1.00 38.91           O  
ATOM   1455  N   THR A 191     -18.637 100.188   0.432  1.00 36.77           N  
ATOM   1456  CA  THR A 191     -19.341  99.055   1.001  1.00 35.47           C  
ATOM   1457  C   THR A 191     -19.242  98.999   2.554  1.00 33.82           C  
ATOM   1458  O   THR A 191     -19.667  98.032   3.169  1.00 33.34           O  
ATOM   1459  CB  THR A 191     -18.748  97.765   0.438  1.00 36.03           C  
ATOM   1460  OG1 THR A 191     -17.324  97.811   0.601  1.00 35.97           O  
ATOM   1461  CG2 THR A 191     -19.093  97.634  -1.074  1.00 37.39           C  
ATOM   1462  N   PHE A 192     -18.697 100.045   3.170  1.00 32.37           N  
ATOM   1463  CA  PHE A 192     -18.492 100.099   4.636  1.00 29.75           C  
ATOM   1464  C   PHE A 192     -19.775  99.756   5.422  1.00 29.48           C  
ATOM   1465  O   PHE A 192     -19.744  98.924   6.335  1.00 27.94           O  
ATOM   1466  CB  PHE A 192     -17.922 101.474   5.018  1.00 29.47           C  
ATOM   1467  CG  PHE A 192     -17.738 101.692   6.525  1.00 28.16           C  
ATOM   1468  CD1 PHE A 192     -16.760 100.988   7.242  1.00 24.46           C  
ATOM   1469  CD2 PHE A 192     -18.527 102.623   7.191  1.00 29.00           C  
ATOM   1470  CE1 PHE A 192     -16.576 101.204   8.670  1.00 26.78           C  
ATOM   1471  CE2 PHE A 192     -18.352 102.846   8.595  1.00 29.52           C  
ATOM   1472  CZ  PHE A 192     -17.373 102.128   9.305  1.00 24.52           C  
ATOM   1473  N   THR A 193     -20.902 100.369   5.063  1.00 29.16           N  
ATOM   1474  CA  THR A 193     -22.107 100.182   5.847  1.00 30.68           C  
ATOM   1475  C   THR A 193     -22.570  98.738   5.802  1.00 29.97           C  
ATOM   1476  O   THR A 193     -22.950  98.155   6.840  1.00 28.69           O  
ATOM   1477  CB  THR A 193     -23.261 101.106   5.397  1.00 31.34           C  
ATOM   1478  OG1 THR A 193     -22.844 102.464   5.480  1.00 33.78           O  
ATOM   1479  CG2 THR A 193     -24.453 100.909   6.288  1.00 32.87           C  
ATOM   1480  N   GLN A 194     -22.539  98.156   4.606  1.00 29.35           N  
ATOM   1481  CA  GLN A 194     -22.946  96.769   4.482  1.00 30.19           C  
ATOM   1482  C   GLN A 194     -21.990  95.786   5.183  1.00 28.37           C  
ATOM   1483  O   GLN A 194     -22.441  94.842   5.830  1.00 26.95           O  
ATOM   1484  CB  GLN A 194     -23.238  96.406   3.019  1.00 32.99           C  
ATOM   1485  CG  GLN A 194     -22.075  96.329   2.103  1.00 40.00           C  
ATOM   1486  CD  GLN A 194     -22.275  95.278   0.993  1.00 50.82           C  
ATOM   1487  OE1 GLN A 194     -23.204  94.437   1.067  1.00 55.49           O  
ATOM   1488  NE2 GLN A 194     -21.398  95.308  -0.030  1.00 49.15           N  
ATOM   1489  N   GLU A 195     -20.685  96.041   5.109  1.00 26.23           N  
ATOM   1490  CA  GLU A 195     -19.707  95.170   5.776  1.00 26.77           C  
ATOM   1491  C   GLU A 195     -19.883  95.253   7.309  1.00 25.92           C  
ATOM   1492  O   GLU A 195     -19.770  94.224   7.981  1.00 24.54           O  
ATOM   1493  CB  GLU A 195     -18.260  95.550   5.399  1.00 27.28           C  
ATOM   1494  CG  GLU A 195     -17.852  95.235   3.910  1.00 33.51           C  
ATOM   1495  CD  GLU A 195     -17.685  93.746   3.570  1.00 40.77           C  
ATOM   1496  OE1 GLU A 195     -17.872  92.850   4.437  1.00 42.69           O  
ATOM   1497  OE2 GLU A 195     -17.355  93.462   2.389  1.00 45.45           O  
ATOM   1498  N   VAL A 196     -20.159  96.467   7.824  1.00 24.97           N  
ATOM   1499  CA  VAL A 196     -20.434  96.635   9.263  1.00 23.95           C  
ATOM   1500  C   VAL A 196     -21.744  95.896   9.667  1.00 24.00           C  
ATOM   1501  O   VAL A 196     -21.729  95.100  10.606  1.00 22.75           O  
ATOM   1502  CB  VAL A 196     -20.434  98.117   9.735  1.00 22.85           C  
ATOM   1503  CG1 VAL A 196     -21.007  98.197  11.198  1.00 22.52           C  
ATOM   1504  CG2 VAL A 196     -19.036  98.714   9.649  1.00 21.91           C  
ATOM   1505  N   MET A 197     -22.854  96.174   8.962  1.00 23.22           N  
ATOM   1506  CA  MET A 197     -24.175  95.585   9.304  1.00 23.74           C  
ATOM   1507  C   MET A 197     -24.249  94.064   9.190  1.00 24.37           C  
ATOM   1508  O   MET A 197     -24.886  93.426  10.006  1.00 25.63           O  
ATOM   1509  CB  MET A 197     -25.335  96.280   8.583  1.00 23.62           C  
ATOM   1510  CG  MET A 197     -25.430  97.784   8.838  1.00 28.06           C  
ATOM   1511  SD  MET A 197     -25.268  98.279  10.655  1.00 33.39           S  
ATOM   1512  CE  MET A 197     -26.584  97.323  11.362  1.00 32.12           C  
ATOM   1513  N   VAL A 198     -23.525  93.468   8.251  1.00 23.98           N  
ATOM   1514  CA  VAL A 198     -23.534  92.023   8.146  1.00 24.86           C  
ATOM   1515  C   VAL A 198     -22.866  91.390   9.370  1.00 23.43           C  
ATOM   1516  O   VAL A 198     -23.388  90.414   9.931  1.00 22.58           O  
ATOM   1517  CB  VAL A 198     -22.949  91.523   6.746  1.00 25.30           C  
ATOM   1518  CG1 VAL A 198     -21.466  91.843   6.608  1.00 26.81           C  
ATOM   1519  CG2 VAL A 198     -23.131  90.022   6.607  1.00 27.48           C  
ATOM   1520  N   ARG A 199     -21.801  92.023   9.862  1.00 22.79           N  
ATOM   1521  CA  ARG A 199     -21.115  91.492  11.008  1.00 22.41           C  
ATOM   1522  C   ARG A 199     -21.885  91.762  12.302  1.00 23.01           C  
ATOM   1523  O   ARG A 199     -21.851  90.927  13.223  1.00 21.69           O  
ATOM   1524  CB  ARG A 199     -19.694  92.060  11.118  1.00 23.43           C  
ATOM   1525  CG  ARG A 199     -18.763  91.456  10.029  1.00 22.28           C  
ATOM   1526  CD  ARG A 199     -17.618  92.402   9.805  1.00 22.44           C  
ATOM   1527  NE  ARG A 199     -16.590  91.810   8.969  1.00 26.23           N  
ATOM   1528  CZ  ARG A 199     -16.624  91.867   7.626  1.00 23.73           C  
ATOM   1529  NH1 ARG A 199     -17.632  92.491   7.014  1.00 21.75           N  
ATOM   1530  NH2 ARG A 199     -15.637  91.340   6.913  1.00 22.93           N  
ATOM   1531  N   ILE A 200     -22.551  92.914  12.371  1.00 22.20           N  
ATOM   1532  CA  ILE A 200     -23.431  93.196  13.535  1.00 23.89           C  
ATOM   1533  C   ILE A 200     -24.575  92.138  13.578  1.00 24.46           C  
ATOM   1534  O   ILE A 200     -24.878  91.578  14.632  1.00 24.08           O  
ATOM   1535  CB  ILE A 200     -23.973  94.627  13.523  1.00 23.43           C  
ATOM   1536  CG1 ILE A 200     -22.859  95.676  13.748  1.00 23.78           C  
ATOM   1537  CG2 ILE A 200     -25.057  94.810  14.615  1.00 26.06           C  
ATOM   1538  CD1 ILE A 200     -22.210  95.647  15.182  1.00 25.01           C  
ATOM   1539  N   LYS A 201     -25.193  91.853  12.430  0.50 25.06           N  
ATOM   1541  CA  LYS A 201     -26.233  90.804  12.396  0.50 26.78           C  
ATOM   1543  C   LYS A 201     -25.667  89.484  12.904  0.50 26.21           C  
ATOM   1545  O   LYS A 201     -26.258  88.894  13.790  0.50 27.11           O  
ATOM   1547  CB  LYS A 201     -26.861  90.623  11.002  0.50 26.76           C  
ATOM   1549  CG  LYS A 201     -27.734  89.360  10.870  0.50 27.06           C  
ATOM   1551  CD  LYS A 201     -28.795  89.466   9.770  0.50 28.02           C  
ATOM   1553  CE  LYS A 201     -28.226  89.340   8.375  0.50 29.53           C  
ATOM   1555  NZ  LYS A 201     -29.151  88.501   7.553  0.50 28.13           N  
ATOM   1557  N   GLU A 202     -24.509  89.061  12.395  1.00 26.45           N  
ATOM   1558  CA  GLU A 202     -23.867  87.813  12.856  1.00 28.43           C  
ATOM   1559  C   GLU A 202     -23.665  87.880  14.354  1.00 26.91           C  
ATOM   1560  O   GLU A 202     -23.978  86.943  15.037  1.00 26.33           O  
ATOM   1561  CB  GLU A 202     -22.502  87.580  12.221  1.00 27.73           C  
ATOM   1562  CG  GLU A 202     -22.498  87.018  10.807  1.00 34.72           C  
ATOM   1563  CD  GLU A 202     -21.160  87.236  10.057  1.00 36.42           C  
ATOM   1564  OE1 GLU A 202     -20.088  87.497  10.704  1.00 44.97           O  
ATOM   1565  OE2 GLU A 202     -21.198  87.157   8.800  1.00 46.36           O  
ATOM   1566  N   LEU A 203     -23.128  88.992  14.868  1.00 26.92           N  
ATOM   1567  CA  LEU A 203     -22.885  89.110  16.323  1.00 26.88           C  
ATOM   1568  C   LEU A 203     -24.171  89.047  17.149  1.00 27.61           C  
ATOM   1569  O   LEU A 203     -24.206  88.396  18.178  1.00 28.68           O  
ATOM   1570  CB  LEU A 203     -22.157  90.414  16.655  1.00 27.37           C  
ATOM   1571  CG  LEU A 203     -20.631  90.462  16.602  1.00 28.74           C  
ATOM   1572  CD1 LEU A 203     -20.089  91.905  16.767  1.00 31.72           C  
ATOM   1573  CD2 LEU A 203     -20.058  89.528  17.685  1.00 32.83           C  
ATOM   1574  N   ALA A 204     -25.207  89.755  16.712  1.00 27.63           N  
ATOM   1575  CA  ALA A 204     -26.497  89.768  17.364  1.00 29.33           C  
ATOM   1576  C   ALA A 204     -27.213  88.407  17.281  1.00 30.70           C  
ATOM   1577  O   ALA A 204     -28.196  88.204  17.983  1.00 33.64           O  
ATOM   1578  CB  ALA A 204     -27.364  90.883  16.767  1.00 29.21           C  
ATOM   1579  N   SER A 205     -26.757  87.489  16.420  1.00 31.07           N  
ATOM   1580  CA  SER A 205     -27.332  86.126  16.350  1.00 31.90           C  
ATOM   1581  C   SER A 205     -26.660  85.144  17.325  1.00 32.23           C  
ATOM   1582  O   SER A 205     -27.135  84.015  17.465  1.00 32.64           O  
ATOM   1583  CB  SER A 205     -27.210  85.559  14.930  1.00 32.02           C  
ATOM   1584  OG  SER A 205     -25.875  85.073  14.669  1.00 33.76           O  
ATOM   1585  N   CYS A 206     -25.556  85.557  17.958  1.00 30.55           N  
ATOM   1586  CA  CYS A 206     -24.852  84.743  18.967  1.00 31.12           C  
ATOM   1587  C   CYS A 206     -25.592  84.738  20.298  1.00 30.34           C  
ATOM   1588  O   CYS A 206     -26.457  85.560  20.553  1.00 30.72           O  
ATOM   1589  CB  CYS A 206     -23.453  85.297  19.232  1.00 29.50           C  
ATOM   1590  SG  CYS A 206     -22.337  85.074  17.811  1.00 35.40           S  
ATOM   1591  N   ASN A 207     -25.228  83.822  21.164  1.00 31.13           N  
ATOM   1592  CA  ASN A 207     -25.788  83.820  22.509  1.00 31.53           C  
ATOM   1593  C   ASN A 207     -25.265  85.054  23.270  1.00 31.04           C  
ATOM   1594  O   ASN A 207     -24.072  85.167  23.480  1.00 30.86           O  
ATOM   1595  CB  ASN A 207     -25.339  82.535  23.178  1.00 32.36           C  
ATOM   1596  CG  ASN A 207     -25.996  82.284  24.535  1.00 34.71           C  
ATOM   1597  OD1 ASN A 207     -26.328  83.202  25.294  1.00 37.93           O  
ATOM   1598  ND2 ASN A 207     -26.171  80.999  24.847  1.00 39.05           N  
ATOM   1599  N   PRO A 208     -26.150  85.958  23.726  1.00 31.43           N  
ATOM   1600  CA  PRO A 208     -25.594  87.173  24.342  1.00 31.29           C  
ATOM   1601  C   PRO A 208     -24.872  86.874  25.655  1.00 30.94           C  
ATOM   1602  O   PRO A 208     -24.059  87.679  26.093  1.00 31.03           O  
ATOM   1603  CB  PRO A 208     -26.838  88.013  24.641  1.00 32.14           C  
ATOM   1604  CG  PRO A 208     -27.969  86.987  24.823  1.00 31.37           C  
ATOM   1605  CD  PRO A 208     -27.630  85.961  23.756  1.00 32.45           C  
ATOM   1606  N   VAL A 209     -25.142  85.718  26.260  1.00 30.38           N  
ATOM   1607  CA  VAL A 209     -24.387  85.282  27.448  1.00 30.11           C  
ATOM   1608  C   VAL A 209     -22.925  84.977  27.105  1.00 28.54           C  
ATOM   1609  O   VAL A 209     -21.993  85.304  27.867  1.00 29.19           O  
ATOM   1610  CB  VAL A 209     -25.047  84.042  28.132  1.00 29.37           C  
ATOM   1611  CG1 VAL A 209     -24.259  83.607  29.351  1.00 31.35           C  
ATOM   1612  CG2 VAL A 209     -26.505  84.366  28.508  1.00 33.56           C  
ATOM   1613  N   VAL A 210     -22.715  84.301  25.988  1.00 27.32           N  
ATOM   1614  CA  VAL A 210     -21.364  83.991  25.539  1.00 27.30           C  
ATOM   1615  C   VAL A 210     -20.634  85.289  25.227  1.00 25.62           C  
ATOM   1616  O   VAL A 210     -19.479  85.411  25.592  1.00 25.49           O  
ATOM   1617  CB  VAL A 210     -21.364  83.049  24.319  1.00 27.59           C  
ATOM   1618  CG1 VAL A 210     -19.975  82.849  23.778  1.00 28.41           C  
ATOM   1619  CG2 VAL A 210     -22.016  81.697  24.699  1.00 28.45           C  
ATOM   1620  N   LEU A 211     -21.296  86.249  24.577  1.00 25.35           N  
ATOM   1621  CA  LEU A 211     -20.688  87.588  24.316  1.00 24.44           C  
ATOM   1622  C   LEU A 211     -20.213  88.268  25.624  1.00 24.62           C  
ATOM   1623  O   LEU A 211     -19.082  88.752  25.746  1.00 23.20           O  
ATOM   1624  CB  LEU A 211     -21.693  88.466  23.584  1.00 25.70           C  
ATOM   1625  CG  LEU A 211     -22.023  88.086  22.114  1.00 26.14           C  
ATOM   1626  CD1 LEU A 211     -22.880  89.155  21.338  1.00 24.83           C  
ATOM   1627  CD2 LEU A 211     -20.766  87.715  21.328  1.00 27.80           C  
ATOM   1628  N   GLU A 212     -21.098  88.272  26.603  1.00 23.64           N  
ATOM   1629  CA  GLU A 212     -20.847  88.942  27.870  1.00 24.61           C  
ATOM   1630  C   GLU A 212     -19.753  88.271  28.649  1.00 23.68           C  
ATOM   1631  O   GLU A 212     -18.918  88.962  29.196  1.00 22.35           O  
ATOM   1632  CB  GLU A 212     -22.091  88.939  28.716  1.00 25.51           C  
ATOM   1633  CG  GLU A 212     -22.409  90.302  29.166  1.00 32.17           C  
ATOM   1634  CD  GLU A 212     -23.564  90.338  30.136  1.00 36.82           C  
ATOM   1635  OE1 GLU A 212     -23.284  90.388  31.350  1.00 38.83           O  
ATOM   1636  OE2 GLU A 212     -24.720  90.316  29.682  1.00 37.13           O  
ATOM   1637  N   GLU A 213     -19.758  86.936  28.671  1.00 22.98           N  
ATOM   1638  CA  GLU A 213     -18.729  86.170  29.402  1.00 24.86           C  
ATOM   1639  C   GLU A 213     -17.368  86.401  28.810  1.00 23.45           C  
ATOM   1640  O   GLU A 213     -16.390  86.485  29.548  1.00 21.56           O  
ATOM   1641  CB  GLU A 213     -18.990  84.654  29.388  1.00 24.77           C  
ATOM   1642  CG  GLU A 213     -20.235  84.217  30.121  1.00 33.84           C  
ATOM   1643  CD  GLU A 213     -20.111  84.295  31.655  1.00 40.76           C  
ATOM   1644  OE1 GLU A 213     -18.981  84.436  32.180  1.00 41.63           O  
ATOM   1645  OE2 GLU A 213     -21.169  84.206  32.321  1.00 44.77           O  
ATOM   1646  N   SER A 214     -17.307  86.438  27.467  1.00 22.40           N  
ATOM   1647  CA  SER A 214     -16.055  86.612  26.761  1.00 23.58           C  
ATOM   1648  C   SER A 214     -15.518  88.005  27.009  1.00 21.95           C  
ATOM   1649  O   SER A 214     -14.365  88.180  27.222  1.00 21.17           O  
ATOM   1650  CB  SER A 214     -16.247  86.334  25.239  1.00 23.64           C  
ATOM   1651  OG  SER A 214     -16.708  84.994  25.023  1.00 27.24           O  
ATOM   1652  N   LYS A 215     -16.374  89.008  26.976  1.00 22.85           N  
ATOM   1653  CA  LYS A 215     -15.881  90.367  27.223  1.00 23.55           C  
ATOM   1654  C   LYS A 215     -15.391  90.494  28.677  1.00 23.65           C  
ATOM   1655  O   LYS A 215     -14.332  91.105  28.932  1.00 21.22           O  
ATOM   1656  CB  LYS A 215     -16.944  91.417  26.934  1.00 24.59           C  
ATOM   1657  CG  LYS A 215     -16.536  92.820  27.498  1.00 27.21           C  
ATOM   1658  CD  LYS A 215     -17.290  93.948  26.845  1.00 25.96           C  
ATOM   1659  CE  LYS A 215     -16.754  95.342  27.344  1.00 25.08           C  
ATOM   1660  NZ  LYS A 215     -17.425  96.466  26.597  1.00 26.90           N  
ATOM   1661  N   ALA A 216     -16.159  89.898  29.604  1.00 22.66           N  
ATOM   1662  CA  ALA A 216     -15.768  89.849  31.016  1.00 23.97           C  
ATOM   1663  C   ALA A 216     -14.388  89.225  31.152  1.00 22.84           C  
ATOM   1664  O   ALA A 216     -13.527  89.800  31.775  1.00 23.24           O  
ATOM   1665  CB  ALA A 216     -16.855  89.100  31.896  1.00 22.70           C  
ATOM   1666  N   LEU A 217     -14.143  88.091  30.499  1.00 23.56           N  
ATOM   1667  CA  LEU A 217     -12.791  87.491  30.491  1.00 22.44           C  
ATOM   1668  C   LEU A 217     -11.708  88.419  29.921  1.00 22.73           C  
ATOM   1669  O   LEU A 217     -10.586  88.436  30.393  1.00 21.61           O  
ATOM   1670  CB  LEU A 217     -12.794  86.147  29.686  1.00 21.66           C  
ATOM   1671  CG  LEU A 217     -13.519  84.952  30.345  1.00 24.23           C  
ATOM   1672  CD1 LEU A 217     -13.693  83.729  29.422  1.00 23.89           C  
ATOM   1673  CD2 LEU A 217     -12.746  84.547  31.664  1.00 18.49           C  
ATOM   1674  N   VAL A 218     -12.011  89.168  28.868  1.00 22.03           N  
ATOM   1675  CA  VAL A 218     -10.958  90.045  28.290  1.00 22.86           C  
ATOM   1676  C   VAL A 218     -10.723  91.292  29.206  1.00 24.39           C  
ATOM   1677  O   VAL A 218      -9.585  91.717  29.379  1.00 25.13           O  
ATOM   1678  CB  VAL A 218     -11.267  90.481  26.811  1.00 21.84           C  
ATOM   1679  CG1 VAL A 218     -10.235  91.536  26.301  1.00 22.94           C  
ATOM   1680  CG2 VAL A 218     -11.230  89.268  25.868  1.00 20.93           C  
ATOM   1681  N   ARG A 219     -11.789  91.819  29.822  1.00 25.24           N  
ATOM   1682  CA  ARG A 219     -11.770  93.121  30.499  1.00 27.81           C  
ATOM   1683  C   ARG A 219     -11.294  93.034  31.954  1.00 29.84           C  
ATOM   1684  O   ARG A 219     -10.803  94.016  32.523  1.00 28.87           O  
ATOM   1685  CB  ARG A 219     -13.155  93.776  30.381  1.00 27.98           C  
ATOM   1686  CG  ARG A 219     -13.384  95.077  31.191  1.00 32.68           C  
ATOM   1687  CD  ARG A 219     -12.586  96.342  30.713  1.00 39.60           C  
ATOM   1688  NE  ARG A 219     -12.572  96.645  29.265  1.00 39.16           N  
ATOM   1689  CZ  ARG A 219     -13.346  97.556  28.650  1.00 41.64           C  
ATOM   1690  NH1 ARG A 219     -14.298  98.220  29.308  1.00 37.82           N  
ATOM   1691  NH2 ARG A 219     -13.214  97.761  27.347  1.00 43.83           N  
ATOM   1692  N   CYS A 220     -11.342  91.845  32.538  1.00 32.44           N  
ATOM   1693  CA  CYS A 220     -11.080  91.726  33.988  1.00 35.81           C  
ATOM   1694  C   CYS A 220      -9.650  91.974  34.464  1.00 36.13           C  
ATOM   1695  O   CYS A 220      -9.479  92.606  35.501  1.00 36.54           O  
ATOM   1696  CB  CYS A 220     -11.587  90.396  34.545  1.00 36.30           C  
ATOM   1697  SG  CYS A 220     -10.735  89.020  33.823  1.00 42.58           S  
ATOM   1698  N   ASN A 221      -8.628  91.524  33.724  1.00 36.29           N  
ATOM   1699  CA  ASN A 221      -7.239  91.877  34.082  1.00 35.46           C  
ATOM   1700  C   ASN A 221      -6.899  93.396  33.987  1.00 34.98           C  
ATOM   1701  O   ASN A 221      -5.799  93.802  34.400  1.00 35.66           O  
ATOM   1702  CB  ASN A 221      -6.158  90.998  33.358  1.00 35.24           C  
ATOM   1703  CG  ASN A 221      -5.796  91.496  31.910  1.00 36.69           C  
ATOM   1704  OD1 ASN A 221      -6.556  92.246  31.296  1.00 38.58           O  
ATOM   1705  ND2 ASN A 221      -4.642  91.033  31.360  1.00 36.23           N  
ATOM   1706  N   MET A 222      -7.801  94.216  33.432  1.00 33.39           N  
ATOM   1707  CA  MET A 222      -7.467  95.614  33.116  1.00 32.02           C  
ATOM   1708  C   MET A 222      -8.378  96.644  33.800  1.00 30.07           C  
ATOM   1709  O   MET A 222      -8.056  97.831  33.827  1.00 26.40           O  
ATOM   1710  CB  MET A 222      -7.483  95.872  31.587  1.00 33.74           C  
ATOM   1711  CG  MET A 222      -6.076  95.810  30.888  1.00 35.96           C  
ATOM   1712  SD  MET A 222      -4.680  96.655  31.697  1.00 42.17           S  
ATOM   1713  CE  MET A 222      -4.999  98.397  31.330  1.00 40.13           C  
ATOM   1714  N   LYS A 223      -9.481  96.176  34.384  1.00 29.57           N  
ATOM   1715  CA  LYS A 223     -10.546  97.084  34.856  1.00 29.90           C  
ATOM   1716  C   LYS A 223     -10.009  98.064  35.908  1.00 28.89           C  
ATOM   1717  O   LYS A 223     -10.198  99.302  35.799  1.00 27.63           O  
ATOM   1718  CB  LYS A 223     -11.750  96.291  35.386  1.00 31.60           C  
ATOM   1719  CG  LYS A 223     -12.968  97.100  35.786  1.00 33.56           C  
ATOM   1720  CD  LYS A 223     -14.236  96.259  35.555  1.00 37.88           C  
ATOM   1721  CE  LYS A 223     -15.485  96.933  36.127  1.00 42.55           C  
ATOM   1722  NZ  LYS A 223     -15.463  97.232  37.629  1.00 42.48           N  
ATOM   1723  N   MET A 224      -9.339  97.497  36.913  0.50 28.39           N  
ATOM   1725  CA  MET A 224      -8.715  98.259  38.001  0.50 29.43           C  
ATOM   1727  C   MET A 224      -7.730  99.309  37.480  0.50 27.27           C  
ATOM   1729  O   MET A 224      -7.770 100.474  37.881  0.50 25.67           O  
ATOM   1731  CB  MET A 224      -7.913  97.315  38.908  0.50 29.33           C  
ATOM   1733  CG  MET A 224      -8.613  96.819  40.154  0.50 32.39           C  
ATOM   1735  SD  MET A 224      -7.540  97.001  41.635  0.50 35.18           S  
ATOM   1737  CE  MET A 224      -5.859  96.761  41.033  0.50 34.27           C  
ATOM   1739  N   GLU A 225      -6.836  98.847  36.608  1.00 25.85           N  
ATOM   1740  CA  GLU A 225      -5.829  99.661  35.982  1.00 25.96           C  
ATOM   1741  C   GLU A 225      -6.458 100.764  35.128  1.00 23.09           C  
ATOM   1742  O   GLU A 225      -5.914 101.867  35.085  1.00 23.52           O  
ATOM   1743  CB  GLU A 225      -4.917  98.819  35.099  1.00 27.21           C  
ATOM   1744  CG  GLU A 225      -3.843  98.065  35.859  1.00 35.91           C  
ATOM   1745  CD  GLU A 225      -3.059  97.166  34.927  1.00 45.59           C  
ATOM   1746  OE1 GLU A 225      -2.460  97.693  33.930  1.00 44.49           O  
ATOM   1747  OE2 GLU A 225      -3.081  95.922  35.190  1.00 51.13           O  
ATOM   1748  N   LEU A 226      -7.570 100.473  34.458  1.00 21.36           N  
ATOM   1749  CA  LEU A 226      -8.246 101.515  33.691  1.00 19.53           C  
ATOM   1750  C   LEU A 226      -8.788 102.603  34.609  1.00 20.04           C  
ATOM   1751  O   LEU A 226      -8.625 103.803  34.336  1.00 19.01           O  
ATOM   1752  CB  LEU A 226      -9.350 100.921  32.780  1.00 20.96           C  
ATOM   1753  CG  LEU A 226      -8.745 100.148  31.565  1.00 19.11           C  
ATOM   1754  CD1 LEU A 226      -9.881  99.401  30.877  1.00 19.81           C  
ATOM   1755  CD2 LEU A 226      -8.044 101.065  30.555  1.00 18.95           C  
ATOM   1756  N   GLU A 227      -9.493 102.177  35.663  1.00 19.17           N  
ATOM   1757  CA  GLU A 227     -10.046 103.117  36.690  1.00 22.14           C  
ATOM   1758  C   GLU A 227      -9.007 104.027  37.287  1.00 20.65           C  
ATOM   1759  O   GLU A 227      -9.211 105.247  37.323  1.00 19.66           O  
ATOM   1760  CB  GLU A 227     -10.768 102.348  37.812  1.00 19.85           C  
ATOM   1761  CG  GLU A 227     -12.117 101.713  37.331  1.00 21.75           C  
ATOM   1762  CD  GLU A 227     -12.595 100.640  38.356  1.00 25.79           C  
ATOM   1763  OE1 GLU A 227     -11.836 100.424  39.313  1.00 34.49           O  
ATOM   1764  OE2 GLU A 227     -13.677 100.026  38.214  1.00 26.28           O  
ATOM   1765  N   GLN A 228      -7.901 103.419  37.709  1.00 20.85           N  
ATOM   1766  CA  GLN A 228      -6.745 104.151  38.254  1.00 23.17           C  
ATOM   1767  C   GLN A 228      -6.136 105.145  37.250  1.00 21.94           C  
ATOM   1768  O   GLN A 228      -5.903 106.299  37.616  1.00 19.93           O  
ATOM   1769  CB  GLN A 228      -5.702 103.184  38.793  1.00 22.11           C  
ATOM   1770  CG  GLN A 228      -6.279 102.361  39.971  1.00 26.97           C  
ATOM   1771  CD  GLN A 228      -5.387 101.204  40.434  1.00 28.10           C  
ATOM   1772  OE1 GLN A 228      -4.421 100.791  39.754  1.00 33.69           O  
ATOM   1773  NE2 GLN A 228      -5.725 100.655  41.622  1.00 34.09           N  
ATOM   1774  N   ALA A 229      -5.900 104.710  35.996  1.00 20.69           N  
ATOM   1775  CA  ALA A 229      -5.508 105.638  34.883  1.00 20.23           C  
ATOM   1776  C   ALA A 229      -6.459 106.800  34.655  1.00 19.78           C  
ATOM   1777  O   ALA A 229      -6.028 107.956  34.557  1.00 21.10           O  
ATOM   1778  CB  ALA A 229      -5.266 104.870  33.514  1.00 18.40           C  
ATOM   1779  N   ASN A 230      -7.751 106.525  34.533  1.00 20.16           N  
ATOM   1780  CA  ASN A 230      -8.740 107.565  34.338  1.00 19.90           C  
ATOM   1781  C   ASN A 230      -8.646 108.641  35.465  1.00 21.44           C  
ATOM   1782  O   ASN A 230      -8.558 109.843  35.213  1.00 21.19           O  
ATOM   1783  CB  ASN A 230     -10.128 106.903  34.266  1.00 19.41           C  
ATOM   1784  CG  ASN A 230     -11.239 107.864  34.014  1.00 20.78           C  
ATOM   1785  OD1 ASN A 230     -11.065 108.929  33.353  1.00 20.47           O  
ATOM   1786  ND2 ASN A 230     -12.434 107.474  34.449  1.00 18.05           N  
ATOM   1787  N   GLU A 231      -8.612 108.176  36.712  1.00 22.17           N  
ATOM   1788  CA  GLU A 231      -8.464 109.086  37.875  1.00 23.35           C  
ATOM   1789  C   GLU A 231      -7.159 109.901  37.910  1.00 21.27           C  
ATOM   1790  O   GLU A 231      -7.207 111.117  38.099  1.00 21.38           O  
ATOM   1791  CB  GLU A 231      -8.778 108.320  39.175  1.00 23.58           C  
ATOM   1792  CG  GLU A 231     -10.316 108.060  39.181  1.00 32.65           C  
ATOM   1793  CD  GLU A 231     -10.856 107.356  40.405  1.00 45.18           C  
ATOM   1794  OE1 GLU A 231     -10.038 106.928  41.249  1.00 47.79           O  
ATOM   1795  OE2 GLU A 231     -12.108 107.227  40.496  1.00 48.21           O  
ATOM   1796  N   ARG A 232      -6.024 109.259  37.659  1.00 20.30           N  
ATOM   1797  CA  ARG A 232      -4.763 110.019  37.507  1.00 21.88           C  
ATOM   1798  C   ARG A 232      -4.837 111.053  36.425  1.00 20.91           C  
ATOM   1799  O   ARG A 232      -4.370 112.197  36.619  1.00 20.26           O  
ATOM   1800  CB  ARG A 232      -3.574 109.127  37.159  1.00 21.11           C  
ATOM   1801  CG  ARG A 232      -3.089 108.221  38.224  1.00 22.62           C  
ATOM   1802  CD  ARG A 232      -1.734 107.573  37.809  1.00 21.62           C  
ATOM   1803  NE  ARG A 232      -1.771 106.762  36.545  1.00 22.80           N  
ATOM   1804  CZ  ARG A 232      -2.021 105.459  36.565  1.00 25.38           C  
ATOM   1805  NH1 ARG A 232      -2.233 104.862  37.770  1.00 24.52           N  
ATOM   1806  NH2 ARG A 232      -1.981 104.717  35.448  1.00 24.41           N  
ATOM   1807  N   GLU A 233      -5.355 110.659  35.244  1.00 20.01           N  
ATOM   1808  CA  GLU A 233      -5.379 111.604  34.132  1.00 19.98           C  
ATOM   1809  C   GLU A 233      -6.256 112.822  34.468  1.00 20.72           C  
ATOM   1810  O   GLU A 233      -5.903 113.967  34.161  1.00 21.45           O  
ATOM   1811  CB  GLU A 233      -5.884 110.916  32.826  1.00 19.25           C  
ATOM   1812  CG  GLU A 233      -4.821 110.015  32.150  1.00 17.57           C  
ATOM   1813  CD  GLU A 233      -5.477 109.037  31.130  1.00 21.19           C  
ATOM   1814  OE1 GLU A 233      -6.731 109.130  30.937  1.00 22.19           O  
ATOM   1815  OE2 GLU A 233      -4.724 108.171  30.596  1.00 23.71           O  
ATOM   1816  N   CYS A 234      -7.411 112.560  35.045  1.00 22.02           N  
ATOM   1817  CA  CYS A 234      -8.334 113.615  35.371  1.00 24.11           C  
ATOM   1818  C   CYS A 234      -7.793 114.594  36.466  1.00 23.92           C  
ATOM   1819  O   CYS A 234      -7.973 115.805  36.374  1.00 22.43           O  
ATOM   1820  CB  CYS A 234      -9.701 113.012  35.673  1.00 25.40           C  
ATOM   1821  SG  CYS A 234     -10.474 112.439  34.016  1.00 27.36           S  
ATOM   1822  N   GLU A 235      -7.072 114.045  37.432  1.00 24.51           N  
ATOM   1823  CA  GLU A 235      -6.423 114.874  38.441  1.00 26.28           C  
ATOM   1824  C   GLU A 235      -5.380 115.808  37.800  1.00 25.98           C  
ATOM   1825  O   GLU A 235      -5.246 116.968  38.216  1.00 24.83           O  
ATOM   1826  CB  GLU A 235      -5.797 114.012  39.519  1.00 26.49           C  
ATOM   1827  CG  GLU A 235      -6.808 113.372  40.435  1.00 31.65           C  
ATOM   1828  CD  GLU A 235      -7.647 114.407  41.172  1.00 39.93           C  
ATOM   1829  OE1 GLU A 235      -7.207 114.810  42.279  1.00 43.65           O  
ATOM   1830  OE2 GLU A 235      -8.709 114.843  40.651  1.00 40.15           O  
ATOM   1831  N   VAL A 236      -4.656 115.321  36.784  1.00 25.19           N  
ATOM   1832  CA  VAL A 236      -3.709 116.204  36.069  1.00 24.63           C  
ATOM   1833  C   VAL A 236      -4.438 117.299  35.308  1.00 24.17           C  
ATOM   1834  O   VAL A 236      -4.054 118.478  35.370  1.00 23.92           O  
ATOM   1835  CB  VAL A 236      -2.679 115.428  35.185  1.00 25.79           C  
ATOM   1836  CG1 VAL A 236      -1.739 116.417  34.408  1.00 24.13           C  
ATOM   1837  CG2 VAL A 236      -1.850 114.469  36.071  1.00 23.62           C  
ATOM   1838  N   LEU A 237      -5.498 116.939  34.590  1.00 22.80           N  
ATOM   1839  CA  LEU A 237      -6.278 117.933  33.861  1.00 22.95           C  
ATOM   1840  C   LEU A 237      -6.849 119.058  34.750  1.00 23.60           C  
ATOM   1841  O   LEU A 237      -6.843 120.224  34.354  1.00 23.01           O  
ATOM   1842  CB  LEU A 237      -7.440 117.267  33.142  1.00 22.46           C  
ATOM   1843  CG  LEU A 237      -6.980 116.327  31.997  1.00 22.30           C  
ATOM   1844  CD1 LEU A 237      -8.245 115.576  31.539  1.00 22.50           C  
ATOM   1845  CD2 LEU A 237      -6.335 117.102  30.841  1.00 24.62           C  
ATOM   1846  N   LYS A 238      -7.354 118.702  35.923  1.00 24.70           N  
ATOM   1847  CA  LYS A 238      -7.732 119.706  36.921  1.00 28.27           C  
ATOM   1848  C   LYS A 238      -6.625 120.702  37.198  1.00 27.88           C  
ATOM   1849  O   LYS A 238      -6.886 121.907  37.207  1.00 29.85           O  
ATOM   1850  CB  LYS A 238      -8.121 119.044  38.246  1.00 28.71           C  
ATOM   1851  CG  LYS A 238      -9.531 118.558  38.336  1.00 31.55           C  
ATOM   1852  CD  LYS A 238      -9.911 118.012  39.787  1.00 31.84           C  
ATOM   1853  CE  LYS A 238     -11.068 116.981  39.617  1.00 34.12           C  
ATOM   1854  NZ  LYS A 238     -11.524 116.256  40.853  1.00 37.25           N  
ATOM   1855  N   LYS A 239      -5.406 120.210  37.443  1.00 29.54           N  
ATOM   1856  CA  LYS A 239      -4.212 121.030  37.681  1.00 30.48           C  
ATOM   1857  C   LYS A 239      -4.002 122.007  36.524  1.00 29.88           C  
ATOM   1858  O   LYS A 239      -3.944 123.216  36.716  1.00 28.83           O  
ATOM   1859  CB  LYS A 239      -2.959 120.154  37.825  1.00 30.99           C  
ATOM   1860  CG  LYS A 239      -2.684 119.535  39.235  1.00 35.69           C  
ATOM   1861  CD  LYS A 239      -1.727 118.242  39.145  1.00 35.90           C  
ATOM   1862  CE  LYS A 239      -2.268 116.999  39.974  1.00 40.24           C  
ATOM   1863  NZ  LYS A 239      -1.741 115.588  39.607  1.00 38.01           N  
ATOM   1864  N   ILE A 240      -3.909 121.476  35.306  1.00 27.49           N  
ATOM   1865  CA  ILE A 240      -3.679 122.282  34.093  1.00 27.01           C  
ATOM   1866  C   ILE A 240      -4.818 123.267  33.790  1.00 26.05           C  
ATOM   1867  O   ILE A 240      -4.585 124.461  33.635  1.00 27.48           O  
ATOM   1868  CB  ILE A 240      -3.458 121.330  32.832  1.00 26.66           C  
ATOM   1869  CG1 ILE A 240      -2.206 120.450  33.023  1.00 26.47           C  
ATOM   1870  CG2 ILE A 240      -3.441 122.158  31.455  1.00 27.60           C  
ATOM   1871  CD1 ILE A 240      -2.031 119.385  31.844  1.00 27.77           C  
ATOM   1872  N   TRP A 241      -6.051 122.789  33.702  1.00 26.04           N  
ATOM   1873  CA  TRP A 241      -7.164 123.683  33.403  1.00 26.45           C  
ATOM   1874  C   TRP A 241      -7.529 124.716  34.496  1.00 27.68           C  
ATOM   1875  O   TRP A 241      -8.113 125.756  34.194  1.00 26.59           O  
ATOM   1876  CB  TRP A 241      -8.369 122.875  33.017  1.00 26.16           C  
ATOM   1877  CG  TRP A 241      -8.156 122.130  31.742  1.00 25.90           C  
ATOM   1878  CD1 TRP A 241      -7.321 122.479  30.698  1.00 26.24           C  
ATOM   1879  CD2 TRP A 241      -8.834 120.918  31.350  1.00 23.19           C  
ATOM   1880  NE1 TRP A 241      -7.443 121.528  29.670  1.00 24.91           N  
ATOM   1881  CE2 TRP A 241      -8.384 120.591  30.036  1.00 24.79           C  
ATOM   1882  CE3 TRP A 241      -9.827 120.124  31.956  1.00 26.59           C  
ATOM   1883  CZ2 TRP A 241      -8.861 119.471  29.337  1.00 22.72           C  
ATOM   1884  CZ3 TRP A 241     -10.289 118.971  31.285  1.00 24.94           C  
ATOM   1885  CH2 TRP A 241      -9.809 118.674  29.959  1.00 25.72           C  
ATOM   1886  N   GLY A 242      -7.152 124.435  35.747  1.00 28.69           N  
ATOM   1887  CA  GLY A 242      -7.353 125.408  36.824  1.00 30.62           C  
ATOM   1888  C   GLY A 242      -6.307 126.517  36.914  1.00 31.99           C  
ATOM   1889  O   GLY A 242      -6.496 127.453  37.673  1.00 33.26           O  
ATOM   1890  N   SER A 243      -5.199 126.416  36.186  1.00 33.35           N  
ATOM   1891  CA  SER A 243      -4.179 127.472  36.131  1.00 34.99           C  
ATOM   1892  C   SER A 243      -4.468 128.569  35.082  1.00 35.78           C  
ATOM   1893  O   SER A 243      -5.155 128.329  34.071  1.00 34.24           O  
ATOM   1894  CB  SER A 243      -2.800 126.850  35.903  1.00 35.70           C  
ATOM   1895  OG  SER A 243      -2.606 126.466  34.545  1.00 37.99           O  
ATOM   1896  N   ALA A 244      -3.954 129.776  35.320  1.00 36.18           N  
ATOM   1897  CA  ALA A 244      -4.316 130.941  34.482  1.00 37.15           C  
ATOM   1898  C   ALA A 244      -3.856 130.782  33.033  1.00 37.32           C  
ATOM   1899  O   ALA A 244      -4.487 131.295  32.111  1.00 37.55           O  
ATOM   1900  CB  ALA A 244      -3.747 132.269  35.079  1.00 37.25           C  
ATOM   1901  N   GLN A 245      -2.752 130.063  32.865  1.00 38.11           N  
ATOM   1902  CA  GLN A 245      -2.125 129.863  31.566  1.00 39.67           C  
ATOM   1903  C   GLN A 245      -2.612 128.572  30.841  1.00 38.86           C  
ATOM   1904  O   GLN A 245      -2.053 128.187  29.806  1.00 38.66           O  
ATOM   1905  CB  GLN A 245      -0.587 129.858  31.735  1.00 41.18           C  
ATOM   1906  CG  GLN A 245       0.007 128.580  32.419  1.00 46.41           C  
ATOM   1907  CD  GLN A 245       0.399 128.779  33.910  1.00 54.94           C  
ATOM   1908  OE1 GLN A 245       1.515 128.416  34.321  1.00 55.85           O  
ATOM   1909  NE2 GLN A 245      -0.520 129.340  34.719  1.00 55.38           N  
ATOM   1910  N   GLY A 246      -3.652 127.922  31.384  1.00 37.98           N  
ATOM   1911  CA  GLY A 246      -4.110 126.599  30.929  1.00 36.92           C  
ATOM   1912  C   GLY A 246      -4.580 126.599  29.491  1.00 36.42           C  
ATOM   1913  O   GLY A 246      -4.384 125.609  28.762  1.00 35.62           O  
ATOM   1914  N   MET A 247      -5.186 127.713  29.078  1.00 35.74           N  
ATOM   1915  CA  MET A 247      -5.694 127.846  27.702  1.00 35.81           C  
ATOM   1916  C   MET A 247      -4.731 128.438  26.648  1.00 35.21           C  
ATOM   1917  O   MET A 247      -5.094 128.540  25.461  1.00 33.99           O  
ATOM   1918  CB  MET A 247      -7.056 128.573  27.684  1.00 37.51           C  
ATOM   1919  CG  MET A 247      -8.213 127.745  28.329  1.00 39.37           C  
ATOM   1920  SD  MET A 247      -8.528 126.163  27.470  1.00 42.80           S  
ATOM   1921  CE  MET A 247     -10.277 126.088  27.296  1.00 43.98           C  
ATOM   1922  N   ASP A 248      -3.523 128.817  27.070  1.00 34.15           N  
ATOM   1923  CA  ASP A 248      -2.562 129.466  26.169  1.00 34.44           C  
ATOM   1924  C   ASP A 248      -2.203 128.682  24.882  1.00 34.71           C  
ATOM   1925  O   ASP A 248      -2.191 129.258  23.768  1.00 34.87           O  
ATOM   1926  CB  ASP A 248      -1.293 129.870  26.923  1.00 34.77           C  
ATOM   1927  CG  ASP A 248      -1.557 131.002  27.982  1.00 37.36           C  
ATOM   1928  OD1 ASP A 248      -2.714 131.479  28.135  1.00 39.48           O  
ATOM   1929  OD2 ASP A 248      -0.589 131.435  28.616  1.00 37.51           O  
ATOM   1930  N   SER A 249      -1.906 127.386  25.031  1.00 33.26           N  
ATOM   1931  CA  SER A 249      -1.570 126.548  23.877  1.00 33.41           C  
ATOM   1932  C   SER A 249      -2.771 126.455  22.939  1.00 32.62           C  
ATOM   1933  O   SER A 249      -2.602 126.559  21.723  1.00 32.93           O  
ATOM   1934  CB  SER A 249      -1.095 125.160  24.314  1.00 31.66           C  
ATOM   1935  OG  SER A 249       0.239 125.240  24.810  1.00 35.02           O  
ATOM   1936  N   MET A 250      -3.974 126.320  23.506  1.00 31.58           N  
ATOM   1937  CA  MET A 250      -5.200 126.201  22.693  1.00 33.59           C  
ATOM   1938  C   MET A 250      -5.478 127.472  21.872  1.00 33.50           C  
ATOM   1939  O   MET A 250      -5.886 127.434  20.678  1.00 32.43           O  
ATOM   1940  CB  MET A 250      -6.394 125.856  23.583  1.00 32.51           C  
ATOM   1941  CG  MET A 250      -7.695 125.600  22.825  1.00 36.96           C  
ATOM   1942  SD  MET A 250      -8.657 127.095  22.399  1.00 44.62           S  
ATOM   1943  CE  MET A 250      -9.299 127.604  24.030  1.00 40.42           C  
ATOM   1944  N   LEU A 251      -5.301 128.601  22.547  1.00 34.55           N  
ATOM   1945  CA  LEU A 251      -5.386 129.923  21.915  1.00 35.14           C  
ATOM   1946  C   LEU A 251      -4.388 130.105  20.739  1.00 35.55           C  
ATOM   1947  O   LEU A 251      -4.797 130.550  19.662  1.00 35.62           O  
ATOM   1948  CB  LEU A 251      -5.274 131.017  22.993  1.00 35.44           C  
ATOM   1949  CG  LEU A 251      -6.511 131.037  23.936  1.00 35.12           C  
ATOM   1950  CD1 LEU A 251      -6.253 131.797  25.255  1.00 35.72           C  
ATOM   1951  CD2 LEU A 251      -7.779 131.537  23.202  1.00 34.58           C  
ATOM   1952  N   LYS A 252      -3.120 129.723  20.931  1.00 35.39           N  
ATOM   1953  CA  LYS A 252      -2.109 129.763  19.850  1.00 36.40           C  
ATOM   1954  C   LYS A 252      -2.507 128.893  18.666  1.00 36.61           C  
ATOM   1955  O   LYS A 252      -2.344 129.286  17.502  1.00 35.44           O  
ATOM   1956  CB  LYS A 252      -0.724 129.315  20.361  1.00 37.29           C  
ATOM   1957  CG  LYS A 252      -0.116 130.194  21.453  1.00 39.66           C  
ATOM   1958  CD  LYS A 252       1.408 130.028  21.509  1.00 45.42           C  
ATOM   1959  CE  LYS A 252       1.989 130.748  22.748  1.00 51.49           C  
ATOM   1960  NZ  LYS A 252       1.807 129.932  23.991  1.00 52.02           N  
ATOM   1961  N   TYR A 253      -2.988 127.685  18.962  1.00 36.68           N  
ATOM   1962  CA  TYR A 253      -3.561 126.814  17.949  1.00 37.62           C  
ATOM   1963  C   TYR A 253      -4.688 127.522  17.172  1.00 37.59           C  
ATOM   1964  O   TYR A 253      -4.662 127.557  15.930  1.00 36.12           O  
ATOM   1965  CB  TYR A 253      -4.066 125.480  18.542  1.00 38.68           C  
ATOM   1966  CG  TYR A 253      -4.805 124.663  17.491  1.00 41.32           C  
ATOM   1967  CD1 TYR A 253      -4.100 123.957  16.485  1.00 43.57           C  
ATOM   1968  CD2 TYR A 253      -6.202 124.623  17.464  1.00 41.33           C  
ATOM   1969  CE1 TYR A 253      -4.782 123.213  15.477  1.00 42.22           C  
ATOM   1970  CE2 TYR A 253      -6.887 123.896  16.474  1.00 44.67           C  
ATOM   1971  CZ  TYR A 253      -6.172 123.186  15.493  1.00 43.91           C  
ATOM   1972  OH  TYR A 253      -6.870 122.481  14.533  1.00 44.80           O  
ATOM   1973  N   LEU A 254      -5.663 128.099  17.898  1.00 37.54           N  
ATOM   1974  CA  LEU A 254      -6.751 128.857  17.237  1.00 37.87           C  
ATOM   1975  C   LEU A 254      -6.233 130.022  16.378  1.00 38.11           C  
ATOM   1976  O   LEU A 254      -6.726 130.223  15.267  1.00 38.17           O  
ATOM   1977  CB  LEU A 254      -7.828 129.321  18.222  1.00 36.97           C  
ATOM   1978  CG  LEU A 254      -8.718 128.212  18.813  1.00 37.21           C  
ATOM   1979  CD1 LEU A 254      -9.750 128.798  19.760  1.00 38.16           C  
ATOM   1980  CD2 LEU A 254      -9.393 127.350  17.751  1.00 37.41           C  
ATOM   1981  N   GLN A 255      -5.225 130.730  16.882  1.00 38.97           N  
ATOM   1982  CA  GLN A 255      -4.596 131.843  16.165  1.00 41.14           C  
ATOM   1983  C   GLN A 255      -4.025 131.390  14.815  1.00 42.49           C  
ATOM   1984  O   GLN A 255      -4.282 132.034  13.802  1.00 42.07           O  
ATOM   1985  CB  GLN A 255      -3.508 132.505  17.027  1.00 41.99           C  
ATOM   1986  CG  GLN A 255      -3.012 133.845  16.452  1.00 43.94           C  
ATOM   1987  CD  GLN A 255      -4.147 134.845  16.420  1.00 47.54           C  
ATOM   1988  OE1 GLN A 255      -4.618 135.301  17.475  1.00 49.44           O  
ATOM   1989  NE2 GLN A 255      -4.642 135.146  15.213  1.00 47.79           N  
ATOM   1990  N   ARG A 256      -3.273 130.281  14.822  1.00 43.74           N  
ATOM   1991  CA  ARG A 256      -2.749 129.626  13.606  1.00 46.15           C  
ATOM   1992  C   ARG A 256      -3.862 129.233  12.651  1.00 46.29           C  
ATOM   1993  O   ARG A 256      -3.750 129.512  11.448  1.00 46.63           O  
ATOM   1994  CB  ARG A 256      -1.910 128.378  13.931  1.00 45.70           C  
ATOM   1995  CG  ARG A 256      -0.590 128.659  14.676  1.00 48.15           C  
ATOM   1996  CD  ARG A 256       0.377 127.429  14.649  1.00 48.60           C  
ATOM   1997  NE  ARG A 256      -0.080 126.328  15.518  1.00 52.53           N  
ATOM   1998  CZ  ARG A 256       0.207 126.194  16.824  1.00 54.72           C  
ATOM   1999  NH1 ARG A 256       0.975 127.081  17.464  1.00 54.68           N  
ATOM   2000  NH2 ARG A 256      -0.277 125.155  17.502  1.00 52.10           N  
ATOM   2001  N   LYS A 257      -4.917 128.588  13.181  1.00 46.85           N  
ATOM   2002  CA  LYS A 257      -6.092 128.170  12.374  1.00 47.77           C  
ATOM   2003  C   LYS A 257      -6.790 129.339  11.656  1.00 48.57           C  
ATOM   2004  O   LYS A 257      -7.154 129.219  10.472  1.00 48.35           O  
ATOM   2005  CB  LYS A 257      -7.118 127.350  13.190  1.00 46.96           C  
ATOM   2006  CG  LYS A 257      -6.832 125.830  13.258  1.00 49.23           C  
ATOM   2007  CD  LYS A 257      -6.894 125.120  11.886  1.00 50.41           C  
ATOM   2008  CE  LYS A 257      -8.299 124.596  11.592  1.00 52.71           C  
ATOM   2009  NZ  LYS A 257      -8.443 124.013  10.212  1.00 53.31           N  
ATOM   2010  N   ILE A 258      -6.969 130.457  12.363  1.00 48.92           N  
ATOM   2011  CA  ILE A 258      -7.634 131.631  11.775  1.00 49.99           C  
ATOM   2012  C   ILE A 258      -6.734 132.446  10.835  1.00 50.84           C  
ATOM   2013  O   ILE A 258      -7.250 133.149   9.950  1.00 51.12           O  
ATOM   2014  CB  ILE A 258      -8.336 132.547  12.832  1.00 49.86           C  
ATOM   2015  CG1 ILE A 258      -7.336 133.086  13.870  1.00 49.61           C  
ATOM   2016  CG2 ILE A 258      -9.510 131.820  13.491  1.00 49.94           C  
ATOM   2017  CD1 ILE A 258      -7.932 134.092  14.825  1.00 49.89           C  
ATOM   2018  N   ASP A 259      -5.415 132.364  11.050  1.00 51.56           N  
ATOM   2019  CA  ASP A 259      -4.413 133.028  10.205  1.00 52.43           C  
ATOM   2020  C   ASP A 259      -4.212 132.289   8.876  1.00 53.74           C  
ATOM   2021  O   ASP A 259      -3.974 132.943   7.844  1.00 54.46           O  
ATOM   2022  CB  ASP A 259      -3.058 133.180  10.927  1.00 51.93           C  
ATOM   2023  CG  ASP A 259      -3.112 134.163  12.115  1.00 50.78           C  
ATOM   2024  OD1 ASP A 259      -4.127 134.879  12.256  1.00 50.06           O  
ATOM   2025  OD2 ASP A 259      -2.145 134.207  12.919  1.00 48.04           O  
ATOM   2026  N   GLU A 260      -4.300 130.948   8.910  1.00 54.24           N  
ATOM   2027  CA  GLU A 260      -4.158 130.089   7.730  1.00 54.55           C  
ATOM   2028  C   GLU A 260      -5.033 130.532   6.533  1.00 55.15           C  
ATOM   2029  O   GLU A 260      -6.271 130.585   6.597  1.00 55.44           O  
ATOM   2030  CB  GLU A 260      -4.411 128.618   8.092  1.00 54.34           C  
TER    2031      GLU A 260                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
