
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  275 ( 2125),  selected  275 , name 1dci_A
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 1dci_A.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A    53_A      -       -           -
LGA    Y    54_A      P      32           #
LGA    E    55_A      R      33          1.279
LGA    S    56_A      P      34          1.297
LGA    I    57_A      T      35          0.770
LGA    Q    58_A      S      36          0.791
LGA    V    59_A      A      37          0.652
LGA    T    60_A      R      38          0.725
LGA    S    61_A      Q      39          1.269
LGA    A    62_A      L      40          3.873
LGA    Q    63_A      D      41          2.949
LGA    K    64_A      -       -           -
LGA    H    65_A      G      42          1.120
LGA    V    66_A      I      43          0.991
LGA    L    67_A      R      44          0.718
LGA    H    68_A      N      45          0.648
LGA    V    69_A      I      46          1.007
LGA    Q    70_A      V      47          0.748
LGA    L    71_A      L      48          0.646
LGA    N    72_A      S      49          0.863
LGA    R    73_A      N      50          0.805
LGA    P    74_A      P      51          2.012
LGA    E    75_A      K      52          2.205
LGA    K    76_A      K      53          1.930
LGA    R    77_A      R      54          1.846
LGA    N    78_A      N      55          1.200
LGA    A    79_A      T      56          1.515
LGA    M    80_A      L      57          1.481
LGA    N    81_A      S      58          1.791
LGA    R    82_A      L      59          1.981
LGA    A    83_A      A      60          0.548
LGA    F    84_A      M      61          1.183
LGA    W    85_A      L      62          1.723
LGA    R    86_A      K      63          1.557
LGA    E    87_A      S      64          1.935
LGA    L    88_A      L      65          2.075
LGA    V    89_A      Q      66          2.061
LGA    E    90_A      S      67          2.113
LGA    C    91_A      D      68          2.295
LGA    F    92_A      I      69          1.966
LGA    Q    93_A      L      70          2.159
LGA    K    94_A      H      71          2.203
LGA    I    95_A      D      72          4.954
LGA    S    96_A      A      73          3.072
LGA    K    97_A      D      74          2.220
LGA    D    98_A      S      75          2.688
LGA    S    99_A      N      76          2.307
LGA    D   100_A      D      77          1.428
LGA    C   101_A      L      78          0.986
LGA    R   102_A      K      79          1.355
LGA    A   103_A      V      80          1.039
LGA    V   104_A      I      81          1.002
LGA    V   105_A      I      82          0.910
LGA    V   106_A      I      83          1.056
LGA    S   107_A      S      84          0.641
LGA    G   108_A      A      85          0.392
LGA    A   109_A      E      86          0.945
LGA    G   110_A      G      87          1.748
LGA    K   111_A      P      88          2.141
LGA    M   112_A      V      89          2.345
LGA    F   113_A      F      90          1.243
LGA    T   114_A      S      91          1.463
LGA    S   115_A      S      92          1.999
LGA    G   116_A      G      93          1.916
LGA    I   117_A      H      94          1.533
LGA    D   118_A      D      95          1.606
LGA    L   119_A      L      96          1.578
LGA    M   120_A      K      97          1.573
LGA    D   121_A      E      98          2.637
LGA    M   122_A      L      99          2.935
LGA    A   123_A      T     100          2.495
LGA    S   124_A      -       -           -
LGA    D   125_A      -       -           -
LGA    I   126_A      -       -           -
LGA    L   127_A      E     101          1.746
LGA    Q   128_A      E     102          1.805
LGA    P   129_A      Q     103          3.987
LGA    P   130_A      G     104          4.172
LGA    G   131_A      -       -           -
LGA    D   132_A      -       -           -
LGA    D   133_A      -       -           -
LGA    V   134_A      -       -           -
LGA    A   135_A      -       -           -
LGA    R   136_A      -       -           -
LGA    I   137_A      R     105          4.557
LGA    A   138_A      -       -           -
LGA    W   139_A      -       -           -
LGA    Y   140_A      -       -           -
LGA    L   141_A      D     106          4.260
LGA    R   142_A      Y     107           -
LGA    -       -      H     108           -
LGA    D   143_A      A     109          4.471
LGA    L   144_A      E     110          2.133
LGA    -       -      V     111           -
LGA    I   145_A      F     112          2.968
LGA    S   146_A      Q     113          2.297
LGA    R   147_A      T     114          2.741
LGA    Y   148_A      C     115          2.558
LGA    Q   149_A      S     116          1.109
LGA    K   150_A      K     117          0.867
LGA    T   151_A      V     118          2.078
LGA    F   152_A      M     119          1.734
LGA    T   153_A      M     120          1.563
LGA    V   154_A      H     121          0.986
LGA    I   155_A      I     122          0.767
LGA    E   156_A      R     123          0.812
LGA    K   157_A      N     124          1.047
LGA    C   158_A      H     125          0.600
LGA    P   159_A      P     126          2.226
LGA    K   160_A      V     127          0.935
LGA    P   161_A      P     128          0.916
LGA    V   162_A      V     129          0.891
LGA    I   163_A      I     130          0.856
LGA    A   164_A      A     131          0.712
LGA    A   165_A      M     132          0.936
LGA    I   166_A      V     133          0.646
LGA    H   167_A      N     134          0.610
LGA    G   168_A      G     135          0.809
LGA    G   169_A      L     136          0.575
LGA    C   170_A      A     137          0.611
LGA    I   171_A      T     138          0.990
LGA    G   172_A      A     139          1.108
LGA    G   173_A      A     140          1.085
LGA    G   174_A      G     141          1.005
LGA    V   175_A      C     142          0.994
LGA    D   176_A      Q     143          0.899
LGA    L   177_A      L     144          0.449
LGA    I   178_A      V     145          1.003
LGA    S   179_A      A     146          1.342
LGA    A   180_A      S     147          1.103
LGA    C   181_A      C     148          0.405
LGA    D   182_A      D     149          0.640
LGA    I   183_A      I     150          0.679
LGA    R   184_A      A     151          0.980
LGA    Y   185_A      V     152          0.880
LGA    C   186_A      A     153          0.602
LGA    T   187_A      S     154          0.510
LGA    Q   188_A      D     155          1.332
LGA    D   189_A      K     156          0.802
LGA    A   190_A      S     157          0.319
LGA    F   191_A      S     158          0.458
LGA    F   192_A      F     159          0.276
LGA    Q   193_A      A     160          0.550
LGA    V   194_A      T     161          1.006
LGA    K   195_A      P     162          1.900
LGA    E   196_A      G     163          1.813
LGA    V   197_A      V     164          1.973
LGA    D   198_A      N     165          2.027
LGA    V   199_A      V     166          2.407
LGA    G   200_A      G     167          1.642
LGA    L   201_A      L     168          2.287
LGA    A   202_A      F     169          2.827
LGA    A   203_A      C     170          2.518
LGA    D   204_A      S     171          4.123
LGA    V   205_A      T     172          3.490
LGA    G   206_A      -       -           -
LGA    T   207_A      P     173          2.421
LGA    L   208_A      G     174          1.870
LGA    Q   209_A      V     175          1.931
LGA    R   210_A      A     176          2.247
LGA    L   211_A      L     177          1.718
LGA    P   212_A      A     178          1.941
LGA    K   213_A      R     179          1.647
LGA    V   214_A      A     180          2.280
LGA    I   215_A      V     181          2.834
LGA    G   216_A      P     182          3.838
LGA    N   217_A      -       -           -
LGA    R   218_A      R     183          1.787
LGA    S   219_A      K     184          0.848
LGA    L   220_A      V     185          1.006
LGA    V   221_A      A     186          1.148
LGA    N   222_A      L     187          0.863
LGA    E   223_A      E     188          0.416
LGA    L   224_A      M     189          0.738
LGA    T   225_A      L     190          1.062
LGA    F   226_A      F     191          0.893
LGA    T   227_A      T     192          0.667
LGA    A   228_A      G     193          0.905
LGA    R   229_A      E     194          0.424
LGA    K   230_A      P     195          0.707
LGA    M   231_A      I     196          0.632
LGA    M   232_A      S     197          1.111
LGA    A   233_A      A     198          1.797
LGA    D   234_A      Q     199          1.905
LGA    E   235_A      E     200          1.488
LGA    A   236_A      A     201          1.709
LGA    L   237_A      L     202          1.769
LGA    D   238_A      L     203          1.932
LGA    S   239_A      H     204          1.563
LGA    G   240_A      G     205          2.442
LGA    L   241_A      L     206          1.381
LGA    V   242_A      L     207          1.344
LGA    S   243_A      S     208          2.238
LGA    R   244_A      K     209          1.511
LGA    V   245_A      V     210          1.214
LGA    F   246_A      V     211          1.259
LGA    P   247_A      P     212          1.163
LGA    D   248_A      E     213          0.833
LGA    K   249_A      -       -           -
LGA    D   250_A      A     214          4.316
LGA    V   251_A      E     215          1.672
LGA    M   252_A      L     216          0.566
LGA    L   253_A      Q     217          1.306
LGA    N   254_A      E     218          1.177
LGA    A   255_A      E     219          1.153
LGA    A   256_A      T     220          0.679
LGA    F   257_A      M     221          1.307
LGA    A   258_A      R     222          1.638
LGA    L   259_A      I     223          0.815
LGA    A   260_A      A     224          0.756
LGA    A   261_A      R     225          0.821
LGA    D   262_A      K     226          0.443
LGA    I   263_A      I     227          1.203
LGA    S   264_A      A     228          1.681
LGA    S   265_A      S     229          1.369
LGA    K   266_A      L     230          1.578
LGA    S   267_A      S     231          1.817
LGA    P   268_A      R     232          1.688
LGA    V   269_A      P     233          2.107
LGA    A   270_A      V     234          2.025
LGA    V   271_A      V     235          1.328
LGA    Q   272_A      S     236          1.365
LGA    G   273_A      L     237          1.390
LGA    S   274_A      G     238          1.493
LGA    K   275_A      K     239          1.168
LGA    I   276_A      A     240          0.990
LGA    N   277_A      T     241          1.621
LGA    L   278_A      F     242          1.631
LGA    I   279_A      Y     243          1.022
LGA    Y   280_A      K     244          1.345
LGA    S   281_A      Q     245          2.058
LGA    R   282_A      L     246          2.221
LGA    D   283_A      P     247          2.184
LGA    H   284_A      Q     248          2.294
LGA    S   285_A      D     249          1.933
LGA    V   286_A      L     250          2.122
LGA    D   287_A      G     251          2.266
LGA    E   288_A      T     252          2.496
LGA    S   289_A      A     253          2.530
LGA    L   290_A      Y     254          2.665
LGA    D   291_A      Y     255          2.989
LGA    Y   292_A      L     256          2.900
LGA    M   293_A      T     257          2.783
LGA    A   294_A      S     258          4.381
LGA    T   295_A      Q     259          4.726
LGA    W   296_A      A     260          3.935
LGA    N   297_A      M     261          4.487
LGA    M   298_A      V     262          4.798
LGA    S   299_A      D     263          3.720
LGA    M   300_A      N     264          3.578
LGA    L   301_A      L     265          2.757
LGA    Q   302_A      A     266          1.495
LGA    T   303_A      L     267          0.974
LGA    Q   304_A      R     268          0.996
LGA    D   305_A      D     269          0.606
LGA    I   306_A      G     270          1.960
LGA    I   307_A      Q     271          2.163
LGA    K   308_A      E     272          1.360
LGA    S   309_A      G     273          0.819
LGA    V   310_A      I     274          1.832
LGA    Q   311_A      T     275          2.567
LGA    A   312_A      A     276          2.125
LGA    A   313_A      F     277          1.403
LGA    M   314_A      L     278          2.566
LGA    E   315_A      Q     279          3.612
LGA    K   316_A      K     280          2.976
LGA    K   317_A      R     281          3.228
LGA    D   318_A      K     282          4.134
LGA    S   319_A      -       -           -
LGA    K   320_A      -       -           -
LGA    S   321_A      P     283           #
LGA    I   322_A      V     284          1.800
LGA    T   323_A      W     285          2.986
LGA    F   324_A      S     286          2.586
LGA    S   325_A      H     287          2.108
LGA    K   326_A      -       -           -
LGA    L   327_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  275  256    5.0    251    1.98    22.71     86.231    12.060

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.077412 * X  +   0.996980 * Y  +   0.006182 * Z  + -48.349548
  Y_new =  -0.988208 * X  +   0.077549 * Y  +  -0.132025 * Z  + 202.158997
  Z_new =  -0.132105 * X  +   0.004111 * Y  +   0.991227 * Z  +  40.721592 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.004147   -3.137445  [ DEG:     0.2376   -179.7624 ]
  Theta =   0.132493    3.009100  [ DEG:     7.5913    172.4087 ]
  Phi   =  -1.492620    1.648972  [ DEG:   -85.5208     94.4792 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1dci_A                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1dci_A.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  275  256   5.0  251   1.98   22.71  86.231
REMARK  ---------------------------------------------------------- 
MOLECULE 1dci_A
HEADER    LYASE                                   13-FEB-98   1DCI              
TITLE     DIENOYL-COA ISOMERASE                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DIENOYL-COA ISOMERASE;                                     
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: DELTA3,5,DELTA2,4-DIENOYL-COENZYME A ISOMERASE,             
COMPND   5 PROBABLE PEROXISOMAL ENOYL-COA HYDRATASE;                            
COMPND   6 EC: 4.2.1.17;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 STRAIN: WISTAR;                                                      
SOURCE   5 CELL_LINE: BL21;                                                     
SOURCE   6 ORGAN: LIVER;                                                        
SOURCE   7 ORGANELLE: PEROXISOME, MITOCHONDRIA;                                 
SOURCE   8 CELLULAR_LOCATION: PEROXISOME, MITOCHONDRIA;                         
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3) LYSS;                           
SOURCE  11 EXPRESSION_SYSTEM_CELLULAR_LOCATION: CYTOPLASM;                      
SOURCE  12 EXPRESSION_SYSTEM_PLASMID: PET3A (NOVAGEN)                           
KEYWDS    LYASE, DIENOYL-COA ISOMERASE                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.MODIS,S.A.FILPPULA,D.NOVIKOV,B.NORLEDGE,J.K.HILTUNEN,               
AUTHOR   2 R.K.WIERENGA                                                         
REVDAT   1   30-MAR-99 1DCI    0                                                
JRNL        AUTH   Y.MODIS,S.A.FILPPULA,D.K.NOVIKOV,B.NORLEDGE,                 
JRNL        AUTH 2 J.K.HILTUNEN,R.K.WIERENGA                                    
JRNL        TITL   THE CRYSTAL STRUCTURE OF DIENOYL-COA ISOMERASE AT            
JRNL        TITL 2 1.5 A RESOLUTION REVEALS THE IMPORTANCE OF                   
JRNL        TITL 3 ASPARTATE AND GLUTAMATE SIDECHAINS FOR CATALYSIS.            
JRNL        REF    STRUCTURE                     V.   6   957 1998              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  1DCI A   54   327  UNP    Q62651   ECH1_RAT        54    327             
DBREF  1DCI B   54   327  UNP    Q62651   ECH1_RAT        54    327             
DBREF  1DCI C   54   327  UNP    Q62651   ECH1_RAT        54    327             
SEQRES   1 A  275  ALA TYR GLU SER ILE GLN VAL THR SER ALA GLN LYS HIS          
SEQRES   2 A  275  VAL LEU HIS VAL GLN LEU ASN ARG PRO GLU LYS ARG ASN          
SEQRES   3 A  275  ALA MET ASN ARG ALA PHE TRP ARG GLU LEU VAL GLU CYS          
SEQRES   4 A  275  PHE GLN LYS ILE SER LYS ASP SER ASP CYS ARG ALA VAL          
SEQRES   5 A  275  VAL VAL SER GLY ALA GLY LYS MET PHE THR SER GLY ILE          
SEQRES   6 A  275  ASP LEU MET ASP MET ALA SER ASP ILE LEU GLN PRO PRO          
SEQRES   7 A  275  GLY ASP ASP VAL ALA ARG ILE ALA TRP TYR LEU ARG ASP          
SEQRES   8 A  275  LEU ILE SER ARG TYR GLN LYS THR PHE THR VAL ILE GLU          
SEQRES   9 A  275  LYS CYS PRO LYS PRO VAL ILE ALA ALA ILE HIS GLY GLY          
SEQRES  10 A  275  CYS ILE GLY GLY GLY VAL ASP LEU ILE SER ALA CYS ASP          
SEQRES  11 A  275  ILE ARG TYR CYS THR GLN ASP ALA PHE PHE GLN VAL LYS          
SEQRES  12 A  275  GLU VAL ASP VAL GLY LEU ALA ALA ASP VAL GLY THR LEU          
SEQRES  13 A  275  GLN ARG LEU PRO LYS VAL ILE GLY ASN ARG SER LEU VAL          
SEQRES  14 A  275  ASN GLU LEU THR PHE THR ALA ARG LYS MET MET ALA ASP          
SEQRES  15 A  275  GLU ALA LEU ASP SER GLY LEU VAL SER ARG VAL PHE PRO          
SEQRES  16 A  275  ASP LYS ASP VAL MET LEU ASN ALA ALA PHE ALA LEU ALA          
SEQRES  17 A  275  ALA ASP ILE SER SER LYS SER PRO VAL ALA VAL GLN GLY          
SEQRES  18 A  275  SER LYS ILE ASN LEU ILE TYR SER ARG ASP HIS SER VAL          
SEQRES  19 A  275  ASP GLU SER LEU ASP TYR MET ALA THR TRP ASN MET SER          
SEQRES  20 A  275  MET LEU GLN THR GLN ASP ILE ILE LYS SER VAL GLN ALA          
SEQRES  21 A  275  ALA MET GLU LYS LYS ASP SER LYS SER ILE THR PHE SER          
SEQRES  22 A  275  LYS LEU                                                      
SEQRES   1 B  275  ALA TYR GLU SER ILE GLN VAL THR SER ALA GLN LYS HIS          
SEQRES   2 B  275  VAL LEU HIS VAL GLN LEU ASN ARG PRO GLU LYS ARG ASN          
SEQRES   3 B  275  ALA MET ASN ARG ALA PHE TRP ARG GLU LEU VAL GLU CYS          
SEQRES   4 B  275  PHE GLN LYS ILE SER LYS ASP SER ASP CYS ARG ALA VAL          
SEQRES   5 B  275  VAL VAL SER GLY ALA GLY LYS MET PHE THR SER GLY ILE          
SEQRES   6 B  275  ASP LEU MET ASP MET ALA SER ASP ILE LEU GLN PRO PRO          
SEQRES   7 B  275  GLY ASP ASP VAL ALA ARG ILE ALA TRP TYR LEU ARG ASP          
SEQRES   8 B  275  LEU ILE SER ARG TYR GLN LYS THR PHE THR VAL ILE GLU          
SEQRES   9 B  275  LYS CYS PRO LYS PRO VAL ILE ALA ALA ILE HIS GLY GLY          
SEQRES  10 B  275  CYS ILE GLY GLY GLY VAL ASP LEU ILE SER ALA CYS ASP          
SEQRES  11 B  275  ILE ARG TYR CYS THR GLN ASP ALA PHE PHE GLN VAL LYS          
SEQRES  12 B  275  GLU VAL ASP VAL GLY LEU ALA ALA ASP VAL GLY THR LEU          
SEQRES  13 B  275  GLN ARG LEU PRO LYS VAL ILE GLY ASN ARG SER LEU VAL          
SEQRES  14 B  275  ASN GLU LEU THR PHE THR ALA ARG LYS MET MET ALA ASP          
SEQRES  15 B  275  GLU ALA LEU ASP SER GLY LEU VAL SER ARG VAL PHE PRO          
SEQRES  16 B  275  ASP LYS ASP VAL MET LEU ASN ALA ALA PHE ALA LEU ALA          
SEQRES  17 B  275  ALA ASP ILE SER SER LYS SER PRO VAL ALA VAL GLN GLY          
SEQRES  18 B  275  SER LYS ILE ASN LEU ILE TYR SER ARG ASP HIS SER VAL          
SEQRES  19 B  275  ASP GLU SER LEU ASP TYR MET ALA THR TRP ASN MET SER          
SEQRES  20 B  275  MET LEU GLN THR GLN ASP ILE ILE LYS SER VAL GLN ALA          
SEQRES  21 B  275  ALA MET GLU LYS LYS ASP SER LYS SER ILE THR PHE SER          
SEQRES  22 B  275  LYS LEU                                                      
SEQRES   1 C  275  ALA TYR GLU SER ILE GLN VAL THR SER ALA GLN LYS HIS          
SEQRES   2 C  275  VAL LEU HIS VAL GLN LEU ASN ARG PRO GLU LYS ARG ASN          
SEQRES   3 C  275  ALA MET ASN ARG ALA PHE TRP ARG GLU LEU VAL GLU CYS          
SEQRES   4 C  275  PHE GLN LYS ILE SER LYS ASP SER ASP CYS ARG ALA VAL          
SEQRES   5 C  275  VAL VAL SER GLY ALA GLY LYS MET PHE THR SER GLY ILE          
SEQRES   6 C  275  ASP LEU MET ASP MET ALA SER ASP ILE LEU GLN PRO PRO          
SEQRES   7 C  275  GLY ASP ASP VAL ALA ARG ILE ALA TRP TYR LEU ARG ASP          
SEQRES   8 C  275  LEU ILE SER ARG TYR GLN LYS THR PHE THR VAL ILE GLU          
SEQRES   9 C  275  LYS CYS PRO LYS PRO VAL ILE ALA ALA ILE HIS GLY GLY          
SEQRES  10 C  275  CYS ILE GLY GLY GLY VAL ASP LEU ILE SER ALA CYS ASP          
SEQRES  11 C  275  ILE ARG TYR CYS THR GLN ASP ALA PHE PHE GLN VAL LYS          
SEQRES  12 C  275  GLU VAL ASP VAL GLY LEU ALA ALA ASP VAL GLY THR LEU          
SEQRES  13 C  275  GLN ARG LEU PRO LYS VAL ILE GLY ASN ARG SER LEU VAL          
SEQRES  14 C  275  ASN GLU LEU THR PHE THR ALA ARG LYS MET MET ALA ASP          
SEQRES  15 C  275  GLU ALA LEU ASP SER GLY LEU VAL SER ARG VAL PHE PRO          
SEQRES  16 C  275  ASP LYS ASP VAL MET LEU ASN ALA ALA PHE ALA LEU ALA          
SEQRES  17 C  275  ALA ASP ILE SER SER LYS SER PRO VAL ALA VAL GLN GLY          
SEQRES  18 C  275  SER LYS ILE ASN LEU ILE TYR SER ARG ASP HIS SER VAL          
SEQRES  19 C  275  ASP GLU SER LEU ASP TYR MET ALA THR TRP ASN MET SER          
SEQRES  20 C  275  MET LEU GLN THR GLN ASP ILE ILE LYS SER VAL GLN ALA          
SEQRES  21 C  275  ALA MET GLU LYS LYS ASP SER LYS SER ILE THR PHE SER          
SEQRES  22 C  275  LYS LEU                                                      
HET    SO4      8       5                                                       
HET    SO4      9       5                                                       
HET    SO4     10       5                                                       
HET    SO4     11       5                                                       
HET    SO4     12       5                                                       
HET    SO4     13       5                                                       
HET    SO4     14       5                                                       
HET    SO4     15       5                                                       
HET     MG     17       1                                                       
HET     MG     18       1                                                       
HET     MG     19       1                                                       
HET     MG     20       1                                                       
HET    EDO      1       4                                                       
HET    EDO      2       4                                                       
HET    EDO      3       4                                                       
HET    EDO      4       4                                                       
HET    EDO      5       4                                                       
HET    EDO      6       4                                                       
HET    EDO      7       4                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   4  SO4    8(O4 S 2-)                                                   
FORMUL  12   MG    4(MG 2+)                                                     
FORMUL  16  EDO    7(C2 H6 O2)                                                  
FORMUL  23  HOH   *973(H2 O)                                                    
CRYST1  131.543  131.543   96.731  90.00  90.00 120.00 P 31 2 1     18          
ATOM      1  N   ALA A  53     -35.270 112.381  22.865  1.00 46.54           N  
ATOM      2  CA  ALA A  53     -34.559 112.009  24.123  1.00 44.06           C  
ATOM      3  C   ALA A  53     -33.261 112.795  24.277  1.00 40.87           C  
ATOM      4  O   ALA A  53     -33.220 113.806  24.983  1.00 43.81           O  
ATOM      5  CB  ALA A  53     -34.337 110.502  24.201  1.00 50.72           C  
ATOM      6  N   TYR A  54     -32.195 112.367  23.618  1.00 33.80           N  
ATOM      7  CA  TYR A  54     -30.897 113.009  23.773  1.00 27.59           C  
ATOM      8  C   TYR A  54     -30.669 114.195  22.849  1.00 27.60           C  
ATOM      9  O   TYR A  54     -31.180 114.246  21.733  1.00 28.19           O  
ATOM     10  CB  TYR A  54     -29.835 111.941  23.475  1.00 26.45           C  
ATOM     11  CG  TYR A  54     -29.865 110.733  24.386  1.00 22.34           C  
ATOM     12  CD1 TYR A  54     -29.537 110.823  25.725  1.00 21.67           C  
ATOM     13  CD2 TYR A  54     -30.210 109.483  23.873  1.00 21.37           C  
ATOM     14  CE1 TYR A  54     -29.553 109.710  26.550  1.00 23.53           C  
ATOM     15  CE2 TYR A  54     -30.226 108.363  24.692  1.00 22.72           C  
ATOM     16  CZ  TYR A  54     -29.905 108.480  26.021  1.00 20.62           C  
ATOM     17  OH  TYR A  54     -29.924 107.385  26.855  1.00 26.53           O  
ATOM     18  N   GLU A  55     -29.857 115.144  23.295  1.00 24.67           N  
ATOM     19  CA  GLU A  55     -29.491 116.319  22.515  1.00 27.88           C  
ATOM     20  C   GLU A  55     -28.281 116.063  21.622  1.00 27.56           C  
ATOM     21  O   GLU A  55     -28.194 116.560  20.498  1.00 27.97           O  
ATOM     22  CB  GLU A  55     -29.124 117.452  23.485  1.00 28.65           C  
ATOM     23  CG  GLU A  55     -30.161 117.776  24.549  0.70 32.17           C  
ATOM     25  CD  GLU A  55     -31.372 118.497  23.980  0.70 34.17           C  
ATOM     27  OE1 GLU A  55     -31.247 119.083  22.885  0.70 33.28           O  
ATOM     29  OE2 GLU A  55     -32.454 118.466  24.606  0.70 34.36           O  
ATOM     31  N   SER A  56     -27.328 115.223  22.069  1.00 24.14           N  
ATOM     32  CA  SER A  56     -26.077 115.121  21.302  1.00 25.07           C  
ATOM     33  C   SER A  56     -25.837 113.784  20.627  1.00 24.21           C  
ATOM     34  O   SER A  56     -24.904 113.607  19.826  1.00 23.97           O  
ATOM     35  CB  SER A  56     -24.919 115.411  22.283  1.00 24.46           C  
ATOM     36  OG  SER A  56     -24.967 116.810  22.621  0.60 23.53           O  
ATOM     38  N   ILE A  57     -26.632 112.778  20.970  1.00 24.03           N  
ATOM     39  CA  ILE A  57     -26.535 111.431  20.428  1.00 24.30           C  
ATOM     40  C   ILE A  57     -27.906 110.902  20.022  1.00 25.92           C  
ATOM     41  O   ILE A  57     -28.901 111.492  20.446  1.00 25.39           O  
ATOM     42  CB  ILE A  57     -25.934 110.411  21.428  1.00 23.08           C  
ATOM     43  CG1 ILE A  57     -26.758 110.321  22.709  1.00 22.82           C  
ATOM     44  CG2 ILE A  57     -24.474 110.761  21.703  1.00 23.47           C  
ATOM     45  CD1 ILE A  57     -26.330 109.217  23.677  1.00 20.79           C  
ATOM     46  N   GLN A  58     -27.944 109.848  19.225  1.00 24.58           N  
ATOM     47  CA  GLN A  58     -29.191 109.217  18.814  1.00 24.91           C  
ATOM     48  C   GLN A  58     -29.024 107.700  18.920  1.00 27.02           C  
ATOM     49  O   GLN A  58     -28.030 107.157  18.429  1.00 27.55           O  
ATOM     50  CB  GLN A  58     -29.590 109.581  17.388  1.00 26.80           C  
ATOM     51  CG  GLN A  58     -30.893 108.963  16.906  1.00 35.52           C  
ATOM     52  CD  GLN A  58     -31.494 109.759  15.759  1.00 37.62           C  
ATOM     53  OE1 GLN A  58     -31.212 109.488  14.591  1.00 42.35           O  
ATOM     54  NE2 GLN A  58     -32.344 110.724  16.081  1.00 40.20           N  
ATOM     55  N   VAL A  59     -29.959 107.037  19.589  1.00 24.70           N  
ATOM     56  CA  VAL A  59     -29.868 105.592  19.762  1.00 23.36           C  
ATOM     57  C   VAL A  59     -31.015 104.882  19.054  1.00 25.07           C  
ATOM     58  O   VAL A  59     -32.184 105.214  19.273  1.00 26.51           O  
ATOM     59  CB  VAL A  59     -29.861 105.208  21.245  1.00 22.75           C  
ATOM     60  CG1 VAL A  59     -29.663 103.704  21.417  1.00 25.17           C  
ATOM     61  CG2 VAL A  59     -28.785 105.958  22.019  1.00 23.30           C  
ATOM     62  N   THR A  60     -30.692 103.951  18.178  1.00 22.24           N  
ATOM     63  CA  THR A  60     -31.729 103.235  17.428  1.00 24.32           C  
ATOM     64  C   THR A  60     -31.510 101.733  17.530  1.00 26.32           C  
ATOM     65  O   THR A  60     -30.379 101.299  17.731  1.00 23.42           O  
ATOM     66  CB  THR A  60     -31.745 103.612  15.940  1.00 28.08           C  
ATOM     67  OG1 THR A  60     -30.415 103.509  15.401  1.00 29.22           O  
ATOM     68  CG2 THR A  60     -32.270 105.027  15.728  1.00 28.47           C  
ATOM     69  N   SER A  61     -32.580 100.969  17.350  1.00 26.69           N  
ATOM     70  CA  SER A  61     -32.436  99.512  17.351  1.00 30.96           C  
ATOM     71  C   SER A  61     -32.142  99.144  15.899  1.00 35.00           C  
ATOM     72  O   SER A  61     -32.981  99.454  15.053  1.00 36.52           O  
ATOM     73  CB  SER A  61     -33.667  98.802  17.879  1.00 31.56           C  
ATOM     74  OG  SER A  61     -33.859  99.046  19.258  0.60 34.27           O  
ATOM     76  N   ALA A  62     -30.909  98.727  15.618  1.00 34.74           N  
ATOM     77  CA  ALA A  62     -30.553  98.454  14.230  1.00 38.30           C  
ATOM     78  C   ALA A  62     -31.314  97.227  13.730  1.00 38.11           C  
ATOM     79  O   ALA A  62     -32.022  97.245  12.734  1.00 41.76           O  
ATOM     80  CB  ALA A  62     -29.059  98.218  14.085  1.00 39.12           C  
ATOM     81  N   GLN A  63     -31.131  96.144  14.459  1.00 37.61           N  
ATOM     82  CA  GLN A  63     -31.708  94.844  14.197  1.00 33.65           C  
ATOM     83  C   GLN A  63     -31.798  94.110  15.534  1.00 31.78           C  
ATOM     84  O   GLN A  63     -31.386  94.661  16.554  1.00 26.82           O  
ATOM     85  CB  GLN A  63     -30.894  94.055  13.189  1.00 38.41           C  
ATOM     86  CG  GLN A  63     -29.394  93.997  13.416  1.00 40.57           C  
ATOM     87  CD  GLN A  63     -28.698  93.367  12.218  1.00 43.37           C  
ATOM     88  OE1 GLN A  63     -28.096  94.059  11.395  1.00 42.39           O  
ATOM     89  NE2 GLN A  63     -28.805  92.042  12.129  1.00 43.46           N  
ATOM     90  N   LYS A  64     -32.343  92.903  15.539  1.00 29.29           N  
ATOM     91  CA  LYS A  64     -32.503  92.160  16.775  1.00 25.26           C  
ATOM     92  C   LYS A  64     -31.225  92.127  17.610  1.00 23.73           C  
ATOM     93  O   LYS A  64     -30.166  91.731  17.123  1.00 24.17           O  
ATOM     94  CB  LYS A  64     -32.963  90.718  16.492  1.00 29.88           C  
ATOM     95  CG  LYS A  64     -33.565  90.083  17.738  1.00 34.01           C  
ATOM     96  CD  LYS A  64     -33.968  88.630  17.484  1.00 35.63           C  
ATOM     97  CE  LYS A  64     -34.635  88.057  18.726  1.00 40.92           C  
ATOM     98  NZ  LYS A  64     -35.897  88.777  19.065  1.00 45.07           N  
ATOM     99  N   HIS A  65     -31.352  92.583  18.846  1.00 22.34           N  
ATOM    100  CA  HIS A  65     -30.283  92.562  19.841  1.00 19.15           C  
ATOM    101  C   HIS A  65     -29.201  93.609  19.660  1.00 20.93           C  
ATOM    102  O   HIS A  65     -28.307  93.686  20.518  1.00 18.34           O  
ATOM    103  CB  HIS A  65     -29.582  91.187  19.894  1.00 19.21           C  
ATOM    104  CG  HIS A  65     -30.457  90.057  20.342  1.00 19.00           C  
ATOM    105  ND1 HIS A  65     -30.584  88.879  19.630  1.00 23.83           N  
ATOM    106  CD2 HIS A  65     -31.258  89.951  21.413  1.00 17.61           C  
ATOM    107  CE1 HIS A  65     -31.429  88.104  20.292  1.00 19.55           C  
ATOM    108  NE2 HIS A  65     -31.860  88.712  21.371  1.00 24.31           N  
ATOM    109  N   VAL A  66     -29.193  94.352  18.572  1.00 18.74           N  
ATOM    110  CA  VAL A  66     -28.151  95.327  18.289  1.00 19.13           C  
ATOM    111  C   VAL A  66     -28.654  96.753  18.449  1.00 21.35           C  
ATOM    112  O   VAL A  66     -29.635  97.152  17.811  1.00 20.59           O  
ATOM    113  CB  VAL A  66     -27.612  95.152  16.860  1.00 18.88           C  
ATOM    114  CG1 VAL A  66     -26.495  96.142  16.536  1.00 20.08           C  
ATOM    115  CG2 VAL A  66     -27.108  93.726  16.635  1.00 19.28           C  
ATOM    116  N   LEU A  67     -27.909  97.554  19.197  1.00 18.78           N  
ATOM    117  CA  LEU A  67     -28.231  98.978  19.334  1.00 18.15           C  
ATOM    118  C   LEU A  67     -27.172  99.784  18.594  1.00 23.66           C  
ATOM    119  O   LEU A  67     -25.984  99.446  18.627  1.00 20.70           O  
ATOM    120  CB  LEU A  67     -28.273  99.429  20.784  1.00 18.01           C  
ATOM    121  CG  LEU A  67     -29.377  98.880  21.689  1.00 22.24           C  
ATOM    122  CD1 LEU A  67     -29.225  99.481  23.076  1.00 23.50           C  
ATOM    123  CD2 LEU A  67     -30.759  99.173  21.112  1.00 28.10           C  
ATOM    124  N   HIS A  68     -27.611 100.853  17.941  1.00 20.89           N  
ATOM    125  CA  HIS A  68     -26.743 101.760  17.221  1.00 19.45           C  
ATOM    126  C   HIS A  68     -26.730 103.092  17.978  1.00 21.26           C  
ATOM    127  O   HIS A  68     -27.790 103.726  18.162  1.00 20.10           O  
ATOM    128  CB  HIS A  68     -27.265 102.030  15.815  1.00 20.25           C  
ATOM    129  CG  HIS A  68     -26.382 102.865  14.943  1.00 21.96           C  
ATOM    130  ND1 HIS A  68     -26.827 103.344  13.732  1.00 23.12           N  
ATOM    131  CD2 HIS A  68     -25.081 103.257  15.042  1.00 21.37           C  
ATOM    132  CE1 HIS A  68     -25.858 103.985  13.116  1.00 23.16           C  
ATOM    133  NE2 HIS A  68     -24.791 103.966  13.900  1.00 22.02           N  
ATOM    134  N   VAL A  69     -25.552 103.451  18.476  1.00 18.82           N  
ATOM    135  CA  VAL A  69     -25.366 104.705  19.190  1.00 18.57           C  
ATOM    136  C   VAL A  69     -24.649 105.655  18.234  1.00 19.04           C  
ATOM    137  O   VAL A  69     -23.541 105.367  17.802  1.00 17.42           O  
ATOM    138  CB  VAL A  69     -24.563 104.524  20.480  1.00 17.74           C  
ATOM    139  CG1 VAL A  69     -24.312 105.871  21.167  1.00 17.96           C  
ATOM    140  CG2 VAL A  69     -25.323 103.621  21.453  1.00 18.77           C  
ATOM    141  N   GLN A  70     -25.345 106.699  17.779  1.00 20.23           N  
ATOM    142  CA  GLN A  70     -24.771 107.573  16.765  1.00 23.33           C  
ATOM    143  C   GLN A  70     -24.487 108.955  17.334  1.00 24.30           C  
ATOM    144  O   GLN A  70     -25.386 109.532  17.954  1.00 25.79           O  
ATOM    145  CB  GLN A  70     -25.750 107.660  15.581  1.00 24.48           C  
ATOM    146  CG  GLN A  70     -25.174 108.341  14.353  1.00 28.22           C  
ATOM    147  CD  GLN A  70     -26.228 108.667  13.303  1.00 31.65           C  
ATOM    148  OE1 GLN A  70     -26.019 108.428  12.113  1.00 31.73           O  
ATOM    149  NE2 GLN A  70     -27.313 109.296  13.754  1.00 33.31           N  
ATOM    150  N   LEU A  71     -23.245 109.434  17.190  1.00 22.82           N  
ATOM    151  CA  LEU A  71     -22.955 110.802  17.642  1.00 22.35           C  
ATOM    152  C   LEU A  71     -23.777 111.708  16.719  1.00 23.05           C  
ATOM    153  O   LEU A  71     -23.739 111.423  15.527  1.00 20.33           O  
ATOM    154  CB  LEU A  71     -21.462 111.104  17.494  1.00 23.49           C  
ATOM    155  CG  LEU A  71     -20.545 110.029  18.110  1.00 27.92           C  
ATOM    156  CD1 LEU A  71     -19.082 110.416  18.012  1.00 29.39           C  
ATOM    157  CD2 LEU A  71     -20.924 109.775  19.558  1.00 28.00           C  
ATOM    158  N   ASN A  72     -24.564 112.640  17.259  1.00 23.11           N  
ATOM    159  CA  ASN A  72     -25.566 113.243  16.365  1.00 25.00           C  
ATOM    160  C   ASN A  72     -25.650 114.746  16.467  1.00 24.92           C  
ATOM    161  O   ASN A  72     -26.691 115.336  16.790  1.00 27.14           O  
ATOM    162  CB  ASN A  72     -26.917 112.568  16.643  1.00 26.86           C  
ATOM    163  CG  ASN A  72     -27.976 112.961  15.629  1.00 28.37           C  
ATOM    164  OD1 ASN A  72     -29.150 113.073  15.970  1.00 27.04           O  
ATOM    165  ND2 ASN A  72     -27.539 113.068  14.382  1.00 31.19           N  
ATOM    166  N   ARG A  73     -24.563 115.414  16.079  1.00 22.18           N  
ATOM    167  CA  ARG A  73     -24.512 116.877  15.946  1.00 22.58           C  
ATOM    168  C   ARG A  73     -23.711 117.156  14.672  1.00 20.42           C  
ATOM    169  O   ARG A  73     -22.629 117.737  14.703  1.00 21.11           O  
ATOM    170  CB  ARG A  73     -23.870 117.563  17.135  1.00 21.16           C  
ATOM    171  CG  ARG A  73     -24.430 117.286  18.515  1.00 24.48           C  
ATOM    172  CD  ARG A  73     -23.659 117.985  19.613  1.00 23.88           C  
ATOM    173  NE  ARG A  73     -23.844 119.442  19.558  1.00 25.12           N  
ATOM    174  CZ  ARG A  73     -22.851 120.312  19.603  1.00 26.17           C  
ATOM    175  NH1 ARG A  73     -21.596 119.892  19.703  1.00 23.72           N  
ATOM    176  NH2 ARG A  73     -23.104 121.619  19.547  1.00 26.41           N  
ATOM    177  N   PRO A  74     -24.193 116.682  13.525  1.00 23.09           N  
ATOM    178  CA  PRO A  74     -23.498 116.720  12.260  1.00 23.52           C  
ATOM    179  C   PRO A  74     -23.150 118.095  11.734  1.00 25.89           C  
ATOM    180  O   PRO A  74     -22.106 118.292  11.111  1.00 25.91           O  
ATOM    181  CB  PRO A  74     -24.391 115.960  11.279  1.00 25.33           C  
ATOM    182  CG  PRO A  74     -25.747 116.038  11.882  1.00 25.62           C  
ATOM    183  CD  PRO A  74     -25.501 115.992  13.368  1.00 22.99           C  
ATOM    184  N   GLU A  75     -23.974 119.080  12.086  1.00 25.53           N  
ATOM    185  CA  GLU A  75     -23.689 120.468  11.721  1.00 25.66           C  
ATOM    186  C   GLU A  75     -22.515 121.036  12.500  1.00 25.88           C  
ATOM    187  O   GLU A  75     -21.948 122.064  12.125  1.00 25.29           O  
ATOM    188  CB  GLU A  75     -24.950 121.317  11.963  1.00 30.08           C  
ATOM    189  CG  GLU A  75     -25.262 121.580  13.421  1.00 36.86           C  
ATOM    190  CD  GLU A  75     -25.851 120.460  14.247  1.00 40.33           C  
ATOM    191  OE1 GLU A  75     -26.240 119.375  13.764  1.00 38.14           O  
ATOM    192  OE2 GLU A  75     -25.951 120.661  15.483  1.00 42.70           O  
ATOM    193  N   LYS A  76     -22.144 120.404  13.616  1.00 25.90           N  
ATOM    194  CA  LYS A  76     -21.048 120.825  14.464  1.00 23.75           C  
ATOM    195  C   LYS A  76     -19.931 119.782  14.460  1.00 24.60           C  
ATOM    196  O   LYS A  76     -19.101 119.719  15.364  1.00 24.71           O  
ATOM    197  CB  LYS A  76     -21.520 121.065  15.899  1.00 28.81           C  
ATOM    198  CG  LYS A  76     -22.609 122.117  16.059  1.00 32.43           C  
ATOM    199  CD  LYS A  76     -22.099 123.493  15.660  1.00 36.53           C  
ATOM    200  CE  LYS A  76     -23.250 124.424  15.300  1.00 41.43           C  
ATOM    201  NZ  LYS A  76     -23.563 125.342  16.430  1.00 44.60           N  
ATOM    202  N   ARG A  77     -19.967 118.902  13.470  1.00 22.19           N  
ATOM    203  CA  ARG A  77     -18.991 117.829  13.280  1.00 23.79           C  
ATOM    204  C   ARG A  77     -18.932 116.906  14.493  1.00 23.60           C  
ATOM    205  O   ARG A  77     -17.852 116.471  14.913  1.00 22.33           O  
ATOM    206  CB  ARG A  77     -17.615 118.427  12.985  1.00 28.91           C  
ATOM    207  CG  ARG A  77     -17.507 119.182  11.665  0.60 29.79           C  
ATOM    209  CD  ARG A  77     -16.106 119.763  11.509  0.60 33.93           C  
ATOM    211  NE  ARG A  77     -15.969 120.587  10.320  0.60 36.41           N  
ATOM    213  CZ  ARG A  77     -15.737 120.162   9.086  0.60 38.26           C  
ATOM    215  NH1 ARG A  77     -15.604 118.866   8.830  0.60 37.25           N  
ATOM    217  NH2 ARG A  77     -15.639 121.051   8.104  0.60 36.56           N  
ATOM    219  N   ASN A  78     -20.079 116.684  15.137  1.00 20.14           N  
ATOM    220  CA  ASN A  78     -20.190 115.855  16.322  1.00 21.51           C  
ATOM    221  C   ASN A  78     -19.250 116.267  17.435  1.00 21.64           C  
ATOM    222  O   ASN A  78     -18.700 115.439  18.176  1.00 19.33           O  
ATOM    223  CB  ASN A  78     -20.010 114.365  15.989  1.00 20.19           C  
ATOM    224  CG  ASN A  78     -21.005 113.891  14.947  1.00 23.27           C  
ATOM    225  OD1 ASN A  78     -22.147 114.355  14.960  1.00 22.46           O  
ATOM    226  ND2 ASN A  78     -20.591 113.005  14.052  1.00 19.53           N  
ATOM    227  N   ALA A  79     -19.065 117.578  17.614  1.00 20.12           N  
ATOM    228  CA  ALA A  79     -18.224 118.069  18.697  1.00 17.55           C  
ATOM    229  C   ALA A  79     -18.843 117.611  20.018  1.00 19.97           C  
ATOM    230  O   ALA A  79     -20.069 117.544  20.183  1.00 18.74           O  
ATOM    231  CB  ALA A  79     -18.140 119.589  18.652  1.00 21.64           C  
ATOM    232  N   MET A  80     -17.995 117.314  20.990  1.00 17.23           N  
ATOM    233  CA  MET A  80     -18.396 116.824  22.291  1.00 16.89           C  
ATOM    234  C   MET A  80     -18.620 117.978  23.263  1.00 19.23           C  
ATOM    235  O   MET A  80     -17.715 118.471  23.926  1.00 17.87           O  
ATOM    236  CB  MET A  80     -17.354 115.810  22.810  1.00 17.09           C  
ATOM    237  CG  MET A  80     -17.276 114.583  21.892  1.00 17.08           C  
ATOM    238  SD  MET A  80     -15.788 113.628  22.364  1.00 17.47           S  
ATOM    239  CE  MET A  80     -16.031 112.176  21.340  1.00 17.57           C  
ATOM    240  N   ASN A  81     -19.877 118.438  23.263  1.00 19.70           N  
ATOM    241  CA  ASN A  81     -20.243 119.566  24.136  1.00 18.78           C  
ATOM    242  C   ASN A  81     -20.699 119.054  25.477  1.00 19.13           C  
ATOM    243  O   ASN A  81     -20.758 117.844  25.708  1.00 17.29           O  
ATOM    244  CB  ASN A  81     -21.301 120.430  23.477  1.00 18.31           C  
ATOM    245  CG  ASN A  81     -22.601 119.720  23.207  1.00 20.02           C  
ATOM    246  OD1 ASN A  81     -22.692 118.497  23.248  1.00 18.92           O  
ATOM    247  ND2 ASN A  81     -23.652 120.495  22.928  1.00 18.87           N  
ATOM    248  N   ARG A  82     -21.105 119.938  26.377  1.00 16.20           N  
ATOM    249  CA  ARG A  82     -21.411 119.565  27.746  1.00 15.60           C  
ATOM    250  C   ARG A  82     -22.427 118.440  27.870  1.00 17.65           C  
ATOM    251  O   ARG A  82     -22.224 117.504  28.653  1.00 17.69           O  
ATOM    252  CB  ARG A  82     -21.818 120.805  28.558  1.00 16.85           C  
ATOM    253  CG  ARG A  82     -21.717 120.614  30.051  1.00 16.04           C  
ATOM    254  CD  ARG A  82     -21.929 121.927  30.802  1.00 17.65           C  
ATOM    255  NE  ARG A  82     -20.854 122.865  30.503  1.00 17.80           N  
ATOM    256  CZ  ARG A  82     -21.022 123.995  29.813  1.00 18.70           C  
ATOM    257  NH1 ARG A  82     -22.222 124.304  29.317  1.00 16.56           N  
ATOM    258  NH2 ARG A  82     -19.992 124.804  29.587  1.00 20.84           N  
ATOM    259  N   ALA A  83     -23.496 118.516  27.072  1.00 18.33           N  
ATOM    260  CA  ALA A  83     -24.515 117.473  27.132  1.00 16.96           C  
ATOM    261  C   ALA A  83     -23.991 116.088  26.756  1.00 18.82           C  
ATOM    262  O   ALA A  83     -24.416 115.105  27.369  1.00 17.37           O  
ATOM    263  CB  ALA A  83     -25.652 117.840  26.173  1.00 18.35           C  
ATOM    264  N   PHE A  84     -23.153 116.039  25.730  1.00 15.46           N  
ATOM    265  CA  PHE A  84     -22.568 114.760  25.315  1.00 16.16           C  
ATOM    266  C   PHE A  84     -21.924 114.014  26.472  1.00 17.43           C  
ATOM    267  O   PHE A  84     -22.143 112.793  26.583  1.00 15.54           O  
ATOM    268  CB  PHE A  84     -21.535 115.010  24.206  1.00 16.28           C  
ATOM    269  CG  PHE A  84     -20.696 113.790  23.898  1.00 17.15           C  
ATOM    270  CD1 PHE A  84     -21.176 112.872  22.986  1.00 20.37           C  
ATOM    271  CD2 PHE A  84     -19.484 113.575  24.530  1.00 19.71           C  
ATOM    272  CE1 PHE A  84     -20.432 111.734  22.684  1.00 20.87           C  
ATOM    273  CE2 PHE A  84     -18.750 112.436  24.243  1.00 20.50           C  
ATOM    274  CZ  PHE A  84     -19.209 111.560  23.301  1.00 19.29           C  
ATOM    275  N   TRP A  85     -21.140 114.639  27.335  1.00 16.07           N  
ATOM    276  CA  TRP A  85     -20.475 113.948  28.430  1.00 18.03           C  
ATOM    277  C   TRP A  85     -21.406 113.316  29.429  1.00 18.15           C  
ATOM    278  O   TRP A  85     -21.151 112.231  29.973  1.00 20.23           O  
ATOM    279  CB  TRP A  85     -19.461 114.888  29.103  1.00 14.93           C  
ATOM    280  CG  TRP A  85     -18.463 115.416  28.108  1.00 18.77           C  
ATOM    281  CD1 TRP A  85     -18.557 116.590  27.415  1.00 19.70           C  
ATOM    282  CD2 TRP A  85     -17.230 114.818  27.694  1.00 17.69           C  
ATOM    283  NE1 TRP A  85     -17.479 116.728  26.570  1.00 19.89           N  
ATOM    284  CE2 TRP A  85     -16.648 115.635  26.712  1.00 17.86           C  
ATOM    285  CE3 TRP A  85     -16.562 113.627  28.046  1.00 18.69           C  
ATOM    286  CZ2 TRP A  85     -15.441 115.358  26.078  1.00 18.73           C  
ATOM    287  CZ3 TRP A  85     -15.358 113.358  27.417  1.00 15.26           C  
ATOM    288  CH2 TRP A  85     -14.806 114.190  26.434  1.00 17.30           C  
ATOM    289  N   ARG A  86     -22.562 113.930  29.696  1.00 16.87           N  
ATOM    290  CA  ARG A  86     -23.612 113.375  30.499  1.00 17.85           C  
ATOM    291  C   ARG A  86     -24.395 112.269  29.754  1.00 16.62           C  
ATOM    292  O   ARG A  86     -24.644 111.216  30.331  1.00 18.41           O  
ATOM    293  CB  ARG A  86     -24.649 114.463  30.845  1.00 18.44           C  
ATOM    294  CG  ARG A  86     -24.219 115.465  31.897  1.00 24.57           C  
ATOM    295  CD  ARG A  86     -25.446 116.229  32.423  1.00 26.13           C  
ATOM    296  NE  ARG A  86     -26.204 116.834  31.335  1.00 24.93           N  
ATOM    297  CZ  ARG A  86     -25.937 118.029  30.790  1.00 24.33           C  
ATOM    298  NH1 ARG A  86     -24.929 118.784  31.207  1.00 23.92           N  
ATOM    299  NH2 ARG A  86     -26.721 118.451  29.806  1.00 25.19           N  
ATOM    300  N   GLU A  87     -24.789 112.568  28.529  1.00 17.63           N  
ATOM    301  CA  GLU A  87     -25.625 111.644  27.760  1.00 18.55           C  
ATOM    302  C   GLU A  87     -24.988 110.306  27.455  1.00 18.57           C  
ATOM    303  O   GLU A  87     -25.727 109.315  27.539  1.00 18.76           O  
ATOM    304  CB  GLU A  87     -26.118 112.301  26.467  1.00 18.26           C  
ATOM    305  CG  GLU A  87     -27.148 113.387  26.781  1.00 20.57           C  
ATOM    306  CD  GLU A  87     -27.597 114.110  25.533  1.00 20.21           C  
ATOM    307  OE1 GLU A  87     -27.010 113.976  24.452  1.00 20.85           O  
ATOM    308  OE2 GLU A  87     -28.621 114.836  25.650  1.00 23.22           O  
ATOM    309  N   LEU A  88     -23.690 110.283  27.149  1.00 16.84           N  
ATOM    310  CA  LEU A  88     -23.121 108.960  26.844  1.00 16.24           C  
ATOM    311  C   LEU A  88     -23.148 108.098  28.086  1.00 17.74           C  
ATOM    312  O   LEU A  88     -23.339 106.869  27.975  1.00 18.69           O  
ATOM    313  CB  LEU A  88     -21.709 109.072  26.267  1.00 14.83           C  
ATOM    314  CG  LEU A  88     -21.366 107.994  25.220  1.00 15.08           C  
ATOM    315  CD1 LEU A  88     -22.170 108.166  23.933  1.00 18.26           C  
ATOM    316  CD2 LEU A  88     -19.874 108.036  24.911  1.00 17.88           C  
ATOM    317  N   VAL A  89     -22.939 108.642  29.270  1.00 15.67           N  
ATOM    318  CA  VAL A  89     -22.992 107.922  30.520  1.00 16.35           C  
ATOM    319  C   VAL A  89     -24.415 107.383  30.703  1.00 16.80           C  
ATOM    320  O   VAL A  89     -24.603 106.170  30.891  1.00 18.26           O  
ATOM    321  CB  VAL A  89     -22.635 108.753  31.760  1.00 16.36           C  
ATOM    322  CG1 VAL A  89     -22.952 108.032  33.052  1.00 17.39           C  
ATOM    323  CG2 VAL A  89     -21.151 109.131  31.655  1.00 17.69           C  
ATOM    324  N   GLU A  90     -25.422 108.241  30.577  1.00 17.12           N  
ATOM    325  CA  GLU A  90     -26.806 107.772  30.702  1.00 17.69           C  
ATOM    326  C   GLU A  90     -27.083 106.637  29.720  1.00 17.29           C  
ATOM    327  O   GLU A  90     -27.699 105.630  30.088  1.00 19.90           O  
ATOM    328  CB  GLU A  90     -27.759 108.940  30.386  1.00 19.08           C  
ATOM    329  CG  GLU A  90     -29.215 108.627  30.704  1.00 26.51           C  
ATOM    330  CD  GLU A  90     -30.172 109.708  30.228  1.00 34.48           C  
ATOM    331  OE1 GLU A  90     -29.770 110.885  30.108  1.00 34.22           O  
ATOM    332  OE2 GLU A  90     -31.347 109.368  29.958  1.00 35.79           O  
ATOM    333  N   CYS A  91     -26.654 106.805  28.481  1.00 14.79           N  
ATOM    334  CA  CYS A  91     -26.894 105.808  27.436  1.00 19.09           C  
ATOM    335  C   CYS A  91     -26.311 104.431  27.715  1.00 18.08           C  
ATOM    336  O   CYS A  91     -27.036 103.428  27.735  1.00 19.05           O  
ATOM    337  CB  CYS A  91     -26.347 106.360  26.129  1.00 17.63           C  
ATOM    338  SG  CYS A  91     -26.449 105.257  24.709  1.00 21.26           S  
ATOM    339  N   PHE A  92     -24.987 104.390  27.923  1.00 18.57           N  
ATOM    340  CA  PHE A  92     -24.366 103.078  28.176  1.00 16.39           C  
ATOM    341  C   PHE A  92     -24.766 102.475  29.497  1.00 19.79           C  
ATOM    342  O   PHE A  92     -24.767 101.228  29.614  1.00 19.63           O  
ATOM    343  CB  PHE A  92     -22.847 103.195  28.013  1.00 15.10           C  
ATOM    344  CG  PHE A  92     -22.471 103.099  26.555  1.00 15.44           C  
ATOM    345  CD1 PHE A  92     -22.275 101.848  25.954  1.00 17.39           C  
ATOM    346  CD2 PHE A  92     -22.357 104.228  25.776  1.00 15.63           C  
ATOM    347  CE1 PHE A  92     -21.939 101.761  24.624  1.00 16.09           C  
ATOM    348  CE2 PHE A  92     -22.014 104.153  24.442  1.00 15.54           C  
ATOM    349  CZ  PHE A  92     -21.811 102.911  23.850  1.00 16.89           C  
ATOM    350  N   GLN A  93     -25.136 103.234  30.521  1.00 19.56           N  
ATOM    351  CA  GLN A  93     -25.634 102.659  31.759  1.00 19.49           C  
ATOM    352  C   GLN A  93     -26.966 101.955  31.472  1.00 19.04           C  
ATOM    353  O   GLN A  93     -27.186 100.844  31.976  1.00 19.63           O  
ATOM    354  CB  GLN A  93     -25.842 103.701  32.854  1.00 21.30           C  
ATOM    355  CG  GLN A  93     -24.534 104.302  33.365  1.00 26.24           C  
ATOM    356  CD  GLN A  93     -24.867 105.367  34.416  1.00 25.68           C  
ATOM    357  OE1 GLN A  93     -24.109 105.441  35.506  1.00 32.47           O  
ATOM    358  NE2 GLN A  93     -25.779 106.133  34.189  1.00 33.08           N  
ATOM    359  N   LYS A  94     -27.815 102.568  30.653  1.00 19.59           N  
ATOM    360  CA  LYS A  94     -29.060 101.899  30.273  1.00 20.87           C  
ATOM    361  C   LYS A  94     -28.770 100.676  29.405  1.00 20.99           C  
ATOM    362  O   LYS A  94     -29.375  99.610  29.640  1.00 21.36           O  
ATOM    363  CB  LYS A  94     -29.969 102.861  29.527  1.00 22.88           C  
ATOM    364  CG  LYS A  94     -30.849 103.671  30.485  0.60 27.23           C  
ATOM    366  CD  LYS A  94     -31.643 104.706  29.700  0.60 30.46           C  
ATOM    368  CE  LYS A  94     -31.622 106.062  30.382  0.60 34.94           C  
ATOM    370  NZ  LYS A  94     -31.960 105.978  31.828  0.60 37.02           N  
ATOM    372  N   ILE A  95     -27.865 100.761  28.434  1.00 17.27           N  
ATOM    373  CA  ILE A  95     -27.543  99.604  27.596  1.00 17.80           C  
ATOM    374  C   ILE A  95     -26.980  98.482  28.462  1.00 17.79           C  
ATOM    375  O   ILE A  95     -27.314  97.304  28.195  1.00 20.41           O  
ATOM    376  CB  ILE A  95     -26.543  99.978  26.482  1.00 18.22           C  
ATOM    377  CG1 ILE A  95     -27.175 100.979  25.514  1.00 21.19           C  
ATOM    378  CG2 ILE A  95     -26.046  98.736  25.746  1.00 18.63           C  
ATOM    379  CD1 ILE A  95     -26.312 101.508  24.394  1.00 21.00           C  
ATOM    380  N   SER A  96     -26.162  98.779  29.470  1.00 19.85           N  
ATOM    381  CA  SER A  96     -25.607  97.741  30.330  1.00 20.97           C  
ATOM    382  C   SER A  96     -26.679  96.929  31.044  1.00 24.66           C  
ATOM    383  O   SER A  96     -26.434  95.753  31.292  1.00 25.42           O  
ATOM    384  CB  SER A  96     -24.629  98.316  31.368  1.00 21.49           C  
ATOM    385  OG  SER A  96     -23.605  98.981  30.633  1.00 23.99           O  
ATOM    386  N   LYS A  97     -27.800  97.540  31.415  1.00 22.18           N  
ATOM    387  CA  LYS A  97     -28.883  96.817  32.048  1.00 25.58           C  
ATOM    388  C   LYS A  97     -29.928  96.335  31.046  1.00 22.59           C  
ATOM    389  O   LYS A  97     -30.917  95.763  31.526  1.00 27.55           O  
ATOM    390  CB  LYS A  97     -29.574  97.718  33.080  1.00 27.76           C  
ATOM    391  CG  LYS A  97     -28.654  98.367  34.094  1.00 36.45           C  
ATOM    392  CD  LYS A  97     -29.380  98.596  35.413  1.00 43.53           C  
ATOM    393  CE  LYS A  97     -29.676 100.069  35.643  1.00 46.24           C  
ATOM    394  NZ  LYS A  97     -28.716 100.673  36.610  1.00 48.98           N  
ATOM    395  N   ASP A  98     -29.797  96.575  29.753  1.00 19.79           N  
ATOM    396  CA  ASP A  98     -30.800  96.166  28.776  1.00 20.71           C  
ATOM    397  C   ASP A  98     -30.592  94.697  28.425  1.00 22.24           C  
ATOM    398  O   ASP A  98     -29.673  94.322  27.700  1.00 21.01           O  
ATOM    399  CB  ASP A  98     -30.721  97.060  27.558  1.00 23.11           C  
ATOM    400  CG  ASP A  98     -31.659  96.760  26.423  1.00 24.89           C  
ATOM    401  OD1 ASP A  98     -32.342  95.704  26.442  1.00 25.26           O  
ATOM    402  OD2 ASP A  98     -31.711  97.576  25.483  1.00 28.41           O  
ATOM    403  N   SER A  99     -31.534  93.871  28.889  1.00 19.49           N  
ATOM    404  CA  SER A  99     -31.408  92.432  28.708  1.00 18.75           C  
ATOM    405  C   SER A  99     -31.627  91.953  27.303  1.00 16.54           C  
ATOM    406  O   SER A  99     -31.332  90.778  27.005  1.00 19.95           O  
ATOM    407  CB  SER A  99     -32.323  91.693  29.693  1.00 19.57           C  
ATOM    408  OG  SER A  99     -33.679  91.880  29.326  1.00 21.91           O  
ATOM    409  N   ASP A 100     -32.103  92.796  26.392  1.00 18.92           N  
ATOM    410  CA  ASP A 100     -32.286  92.395  25.013  1.00 20.12           C  
ATOM    411  C   ASP A 100     -31.090  92.782  24.161  1.00 22.43           C  
ATOM    412  O   ASP A 100     -30.905  92.217  23.091  1.00 25.14           O  
ATOM    413  CB  ASP A 100     -33.579  93.018  24.472  1.00 26.98           C  
ATOM    414  CG  ASP A 100     -33.925  92.571  23.070  1.00 31.70           C  
ATOM    415  OD1 ASP A 100     -34.147  91.355  22.878  1.00 33.03           O  
ATOM    416  OD2 ASP A 100     -33.963  93.432  22.163  1.00 34.34           O  
ATOM    417  N   CYS A 101     -30.239  93.708  24.612  1.00 19.23           N  
ATOM    418  CA  CYS A 101     -29.095  94.111  23.779  1.00 17.52           C  
ATOM    419  C   CYS A 101     -27.904  93.177  23.971  1.00 17.37           C  
ATOM    420  O   CYS A 101     -27.633  92.820  25.124  1.00 18.27           O  
ATOM    421  CB  CYS A 101     -28.720  95.553  24.154  1.00 18.39           C  
ATOM    422  SG  CYS A 101     -27.291  96.160  23.191  1.00 18.29           S  
ATOM    423  N   ARG A 102     -27.261  92.754  22.898  1.00 16.60           N  
ATOM    424  CA  ARG A 102     -26.087  91.889  22.992  1.00 17.48           C  
ATOM    425  C   ARG A 102     -24.849  92.492  22.346  1.00 15.23           C  
ATOM    426  O   ARG A 102     -23.728  91.978  22.529  1.00 16.24           O  
ATOM    427  CB  ARG A 102     -26.418  90.532  22.312  1.00 16.76           C  
ATOM    428  CG  ARG A 102     -27.462  89.737  23.079  1.00 17.24           C  
ATOM    429  CD  ARG A 102     -27.799  88.407  22.390  1.00 18.10           C  
ATOM    430  NE  ARG A 102     -28.873  87.762  23.155  1.00 17.84           N  
ATOM    431  CZ  ARG A 102     -29.398  86.575  22.820  1.00 18.71           C  
ATOM    432  NH1 ARG A 102     -28.936  85.942  21.754  1.00 19.93           N  
ATOM    433  NH2 ARG A 102     -30.381  86.127  23.606  1.00 18.11           N  
ATOM    434  N   ALA A 103     -24.989  93.565  21.577  1.00 17.00           N  
ATOM    435  CA  ALA A 103     -23.856  94.198  20.902  1.00 16.07           C  
ATOM    436  C   ALA A 103     -24.265  95.617  20.503  1.00 17.62           C  
ATOM    437  O   ALA A 103     -25.459  95.899  20.336  1.00 17.46           O  
ATOM    438  CB  ALA A 103     -23.421  93.445  19.663  1.00 16.73           C  
ATOM    439  N   VAL A 104     -23.278  96.507  20.453  1.00 16.58           N  
ATOM    440  CA  VAL A 104     -23.494  97.906  20.143  1.00 17.36           C  
ATOM    441  C   VAL A 104     -22.567  98.375  19.035  1.00 17.34           C  
ATOM    442  O   VAL A 104     -21.385  97.993  18.930  1.00 17.45           O  
ATOM    443  CB  VAL A 104     -23.223  98.793  21.383  1.00 13.53           C  
ATOM    444  CG1 VAL A 104     -23.567 100.261  21.090  1.00 15.75           C  
ATOM    445  CG2 VAL A 104     -23.958  98.355  22.650  1.00 16.92           C  
ATOM    446  N   VAL A 105     -23.075  99.219  18.146  1.00 17.41           N  
ATOM    447  CA  VAL A 105     -22.290  99.849  17.104  1.00 16.60           C  
ATOM    448  C   VAL A 105     -22.328 101.364  17.366  1.00 17.07           C  
ATOM    449  O   VAL A 105     -23.400 101.913  17.623  1.00 16.95           O  
ATOM    450  CB  VAL A 105     -22.782  99.587  15.664  1.00 16.97           C  
ATOM    451  CG1 VAL A 105     -21.990 100.358  14.617  1.00 18.91           C  
ATOM    452  CG2 VAL A 105     -22.725  98.084  15.353  1.00 16.15           C  
ATOM    453  N   VAL A 106     -21.147 101.977  17.375  1.00 16.02           N  
ATOM    454  CA  VAL A 106     -21.055 103.423  17.556  1.00 15.37           C  
ATOM    455  C   VAL A 106     -20.542 104.044  16.263  1.00 17.22           C  
ATOM    456  O   VAL A 106     -19.509 103.619  15.756  1.00 16.43           O  
ATOM    457  CB  VAL A 106     -20.093 103.802  18.688  1.00 17.67           C  
ATOM    458  CG1 VAL A 106     -19.983 105.330  18.804  1.00 14.73           C  
ATOM    459  CG2 VAL A 106     -20.563 103.244  20.011  1.00 15.28           C  
ATOM    460  N   SER A 107     -21.235 105.078  15.759  1.00 17.21           N  
ATOM    461  CA  SER A 107     -20.781 105.770  14.554  1.00 18.13           C  
ATOM    462  C   SER A 107     -21.138 107.259  14.712  1.00 16.99           C  
ATOM    463  O   SER A 107     -21.709 107.589  15.744  1.00 18.02           O  
ATOM    464  CB  SER A 107     -21.430 105.223  13.285  1.00 22.49           C  
ATOM    465  OG  SER A 107     -22.802 105.573  13.207  1.00 22.37           O  
ATOM    466  N   GLY A 108     -20.780 108.062  13.729  1.00 19.86           N  
ATOM    467  CA  GLY A 108     -21.100 109.489  13.786  1.00 19.04           C  
ATOM    468  C   GLY A 108     -21.880 109.901  12.537  1.00 20.38           C  
ATOM    469  O   GLY A 108     -21.646 109.404  11.439  1.00 19.61           O  
ATOM    470  N   ALA A 109     -22.804 110.834  12.754  1.00 21.63           N  
ATOM    471  CA  ALA A 109     -23.624 111.329  11.638  1.00 23.68           C  
ATOM    472  C   ALA A 109     -22.871 112.403  10.869  1.00 24.32           C  
ATOM    473  O   ALA A 109     -21.964 113.026  11.425  1.00 23.29           O  
ATOM    474  CB  ALA A 109     -24.919 111.907  12.196  1.00 25.64           C  
ATOM    475  N   GLY A 110     -23.204 112.638   9.599  1.00 26.62           N  
ATOM    476  CA  GLY A 110     -22.530 113.683   8.848  1.00 26.38           C  
ATOM    477  C   GLY A 110     -21.158 113.337   8.293  1.00 24.86           C  
ATOM    478  O   GLY A 110     -20.843 112.197   7.968  1.00 28.55           O  
ATOM    479  N   LYS A 111     -20.326 114.345   8.115  1.00 25.98           N  
ATOM    480  CA  LYS A 111     -19.041 114.278   7.461  1.00 26.00           C  
ATOM    481  C   LYS A 111     -17.954 113.479   8.162  1.00 24.59           C  
ATOM    482  O   LYS A 111     -17.036 113.001   7.485  1.00 24.03           O  
ATOM    483  CB  LYS A 111     -18.497 115.712   7.246  1.00 29.29           C  
ATOM    484  CG  LYS A 111     -18.811 116.213   5.841  1.00 38.35           C  
ATOM    485  CD  LYS A 111     -19.964 117.200   5.828  1.00 41.28           C  
ATOM    486  CE  LYS A 111     -20.195 117.761   4.428  1.00 44.13           C  
ATOM    487  NZ  LYS A 111     -20.936 116.807   3.555  1.00 45.94           N  
ATOM    488  N   MET A 112     -17.951 113.474   9.486  1.00 24.16           N  
ATOM    489  CA  MET A 112     -16.836 112.856  10.212  1.00 23.00           C  
ATOM    490  C   MET A 112     -17.303 112.259  11.534  1.00 21.91           C  
ATOM    491  O   MET A 112     -18.300 112.673  12.130  1.00 21.60           O  
ATOM    492  CB  MET A 112     -15.725 113.882  10.454  1.00 22.90           C  
ATOM    493  CG  MET A 112     -16.125 115.036  11.353  1.00 25.24           C  
ATOM    494  SD  MET A 112     -14.903 116.349  11.507  1.00 28.59           S  
ATOM    495  CE  MET A 112     -13.421 115.452  11.909  1.00 26.61           C  
ATOM    496  N   PHE A 113     -16.536 111.277  12.026  1.00 19.53           N  
ATOM    497  CA  PHE A 113     -16.847 110.677  13.322  1.00 18.95           C  
ATOM    498  C   PHE A 113     -16.924 111.748  14.405  1.00 19.06           C  
ATOM    499  O   PHE A 113     -17.995 111.863  15.019  1.00 19.00           O  
ATOM    500  CB  PHE A 113     -15.806 109.596  13.620  1.00 17.29           C  
ATOM    501  CG  PHE A 113     -16.089 108.777  14.844  1.00 19.22           C  
ATOM    502  CD1 PHE A 113     -17.108 107.828  14.836  1.00 21.36           C  
ATOM    503  CD2 PHE A 113     -15.328 108.936  15.987  1.00 20.02           C  
ATOM    504  CE1 PHE A 113     -17.360 107.073  15.970  1.00 21.00           C  
ATOM    505  CE2 PHE A 113     -15.578 108.175  17.121  1.00 18.22           C  
ATOM    506  CZ  PHE A 113     -16.595 107.239  17.105  1.00 20.24           C  
ATOM    507  N   THR A 114     -15.838 112.491  14.642  1.00 18.12           N  
ATOM    508  CA  THR A 114     -15.929 113.582  15.605  1.00 18.58           C  
ATOM    509  C   THR A 114     -14.730 114.514  15.531  1.00 19.49           C  
ATOM    510  O   THR A 114     -13.585 114.104  15.347  1.00 17.54           O  
ATOM    511  CB  THR A 114     -16.131 113.154  17.065  1.00 18.12           C  
ATOM    512  OG1 THR A 114     -16.247 114.315  17.917  1.00 18.24           O  
ATOM    513  CG2 THR A 114     -14.944 112.350  17.596  1.00 18.57           C  
ATOM    514  N   SER A 115     -15.047 115.811  15.676  1.00 20.60           N  
ATOM    515  CA  SER A 115     -13.993 116.828  15.734  1.00 17.67           C  
ATOM    516  C   SER A 115     -13.416 116.916  17.133  1.00 20.58           C  
ATOM    517  O   SER A 115     -12.442 117.637  17.393  1.00 22.76           O  
ATOM    518  CB  SER A 115     -14.582 118.186  15.312  1.00 23.18           C  
ATOM    519  OG  SER A 115     -15.707 118.498  16.123  1.00 22.70           O  
ATOM    520  N   GLY A 116     -14.007 116.236  18.095  1.00 19.38           N  
ATOM    521  CA  GLY A 116     -13.560 116.202  19.464  1.00 20.00           C  
ATOM    522  C   GLY A 116     -14.237 117.200  20.379  1.00 21.52           C  
ATOM    523  O   GLY A 116     -15.394 117.546  20.153  1.00 21.93           O  
ATOM    524  N   ILE A 117     -13.586 117.533  21.488  1.00 21.38           N  
ATOM    525  CA  ILE A 117     -14.212 118.365  22.510  1.00 22.02           C  
ATOM    526  C   ILE A 117     -14.569 119.747  21.994  1.00 23.08           C  
ATOM    527  O   ILE A 117     -13.889 120.339  21.162  1.00 20.83           O  
ATOM    528  CB  ILE A 117     -13.334 118.465  23.779  1.00 26.85           C  
ATOM    529  CG1 ILE A 117     -14.168 118.961  24.959  1.00 29.05           C  
ATOM    530  CG2 ILE A 117     -12.141 119.386  23.562  1.00 27.84           C  
ATOM    531  CD1 ILE A 117     -13.518 118.838  26.318  1.00 34.35           C  
ATOM    532  N   ASP A 118     -15.719 120.234  22.470  1.00 21.13           N  
ATOM    533  CA  ASP A 118     -16.124 121.627  22.239  1.00 21.83           C  
ATOM    534  C   ASP A 118     -15.220 122.495  23.116  1.00 20.50           C  
ATOM    535  O   ASP A 118     -15.326 122.485  24.349  1.00 20.78           O  
ATOM    536  CB  ASP A 118     -17.590 121.748  22.616  1.00 19.24           C  
ATOM    537  CG  ASP A 118     -18.146 123.158  22.513  1.00 24.38           C  
ATOM    538  OD1 ASP A 118     -17.402 124.141  22.678  1.00 23.72           O  
ATOM    539  OD2 ASP A 118     -19.353 123.268  22.280  1.00 26.71           O  
ATOM    540  N   LEU A 119     -14.339 123.259  22.483  1.00 24.19           N  
ATOM    541  CA  LEU A 119     -13.366 124.089  23.189  1.00 26.19           C  
ATOM    542  C   LEU A 119     -13.975 125.218  24.007  1.00 20.92           C  
ATOM    543  O   LEU A 119     -13.421 125.591  25.044  1.00 24.34           O  
ATOM    544  CB  LEU A 119     -12.364 124.650  22.175  1.00 28.21           C  
ATOM    545  CG  LEU A 119     -10.932 124.138  22.115  1.00 35.77           C  
ATOM    546  CD1 LEU A 119     -10.769 122.738  22.670  1.00 31.24           C  
ATOM    547  CD2 LEU A 119     -10.417 124.196  20.678  1.00 34.35           C  
ATOM    548  N   MET A 120     -15.099 125.761  23.547  1.00 22.39           N  
ATOM    549  CA  MET A 120     -15.742 126.868  24.261  1.00 21.58           C  
ATOM    550  C   MET A 120     -16.340 126.344  25.547  1.00 18.75           C  
ATOM    551  O   MET A 120     -16.195 126.932  26.614  1.00 18.10           O  
ATOM    552  CB  MET A 120     -16.776 127.555  23.381  1.00 23.67           C  
ATOM    553  CG  MET A 120     -16.171 128.000  22.046  1.00 28.05           C  
ATOM    554  SD  MET A 120     -14.829 129.195  22.311  1.00 31.21           S  
ATOM    555  CE  MET A 120     -15.850 130.653  22.561  1.00 32.54           C  
ATOM    556  N   ASP A 121     -17.012 125.170  25.443  1.00 16.75           N  
ATOM    557  CA  ASP A 121     -17.566 124.605  26.672  1.00 16.42           C  
ATOM    558  C   ASP A 121     -16.414 124.193  27.611  1.00 17.50           C  
ATOM    559  O   ASP A 121     -16.527 124.370  28.821  1.00 18.31           O  
ATOM    560  CB  ASP A 121     -18.429 123.373  26.396  1.00 18.29           C  
ATOM    561  CG  ASP A 121     -19.836 123.723  25.922  1.00 21.36           C  
ATOM    562  OD1 ASP A 121     -20.175 124.913  25.783  1.00 18.88           O  
ATOM    563  OD2 ASP A 121     -20.627 122.782  25.648  1.00 18.36           O  
ATOM    564  N   MET A 122     -15.338 123.666  27.010  1.00 19.23           N  
ATOM    565  CA  MET A 122     -14.213 123.245  27.846  1.00 22.52           C  
ATOM    566  C   MET A 122     -13.627 124.437  28.600  1.00 21.24           C  
ATOM    567  O   MET A 122     -13.429 124.322  29.811  1.00 22.95           O  
ATOM    568  CB  MET A 122     -13.160 122.550  26.992  1.00 24.37           C  
ATOM    569  CG  MET A 122     -12.090 121.935  27.915  1.00 21.60           C  
ATOM    570  SD  MET A 122     -10.584 121.638  26.956  1.00 28.81           S  
ATOM    571  CE  MET A 122     -10.011 123.340  26.823  1.00 25.55           C  
ATOM    572  N   ALA A 123     -13.423 125.551  27.911  1.00 22.85           N  
ATOM    573  CA  ALA A 123     -12.899 126.750  28.569  1.00 23.83           C  
ATOM    574  C   ALA A 123     -13.833 127.212  29.666  1.00 24.37           C  
ATOM    575  O   ALA A 123     -13.450 127.453  30.817  1.00 23.69           O  
ATOM    576  CB  ALA A 123     -12.714 127.854  27.529  1.00 26.47           C  
ATOM    577  N   SER A 124     -15.157 127.247  29.397  1.00 21.12           N  
ATOM    578  CA  SER A 124     -16.080 127.612  30.468  1.00 22.05           C  
ATOM    579  C   SER A 124     -15.925 126.679  31.662  1.00 24.22           C  
ATOM    580  O   SER A 124     -15.910 127.135  32.804  1.00 23.90           O  
ATOM    581  CB  SER A 124     -17.533 127.603  29.968  1.00 22.44           C  
ATOM    582  OG  SER A 124     -18.402 127.892  31.038  0.65 21.11           O  
ATOM    584  N   ASP A 125     -15.829 125.368  31.405  1.00 21.78           N  
ATOM    585  CA  ASP A 125     -15.740 124.419  32.506  1.00 21.10           C  
ATOM    586  C   ASP A 125     -14.363 124.470  33.200  1.00 20.08           C  
ATOM    587  O   ASP A 125     -14.413 124.380  34.418  1.00 23.73           O  
ATOM    588  CB  ASP A 125     -15.994 122.991  32.050  1.00 20.45           C  
ATOM    589  CG  ASP A 125     -17.362 122.679  31.477  1.00 26.81           C  
ATOM    590  OD1 ASP A 125     -18.326 123.412  31.751  1.00 27.93           O  
ATOM    591  OD2 ASP A 125     -17.464 121.647  30.768  1.00 31.25           O  
ATOM    592  N   ILE A 126     -13.312 124.710  32.461  1.00 26.11           N  
ATOM    593  CA  ILE A 126     -11.917 124.591  32.860  1.00 32.34           C  
ATOM    594  C   ILE A 126     -11.129 125.879  32.948  1.00 33.62           C  
ATOM    595  O   ILE A 126     -10.247 125.974  33.824  1.00 32.54           O  
ATOM    596  CB  ILE A 126     -11.256 123.571  31.896  1.00 35.61           C  
ATOM    597  CG1 ILE A 126     -11.372 122.177  32.536  1.00 41.11           C  
ATOM    598  CG2 ILE A 126      -9.830 123.846  31.494  1.00 35.86           C  
ATOM    599  CD1 ILE A 126     -11.708 121.091  31.533  1.00 41.66           C  
ATOM    600  N   LEU A 127     -11.389 126.913  32.148  1.00 34.29           N  
ATOM    601  CA  LEU A 127     -10.690 128.185  32.248  1.00 36.27           C  
ATOM    602  C   LEU A 127     -11.491 129.199  33.068  1.00 36.61           C  
ATOM    603  O   LEU A 127     -11.012 130.291  33.382  1.00 33.87           O  
ATOM    604  CB  LEU A 127     -10.342 128.825  30.908  1.00 36.51           C  
ATOM    605  CG  LEU A 127      -9.698 127.990  29.809  1.00 41.03           C  
ATOM    606  CD1 LEU A 127      -9.083 128.897  28.743  1.00 39.06           C  
ATOM    607  CD2 LEU A 127      -8.624 127.051  30.336  1.00 41.34           C  
ATOM    608  N   GLN A 128     -12.685 128.824  33.517  1.00 35.90           N  
ATOM    609  CA  GLN A 128     -13.550 129.623  34.358  1.00 38.56           C  
ATOM    610  C   GLN A 128     -14.141 128.810  35.511  1.00 35.72           C  
ATOM    611  O   GLN A 128     -15.347 128.596  35.651  1.00 36.81           O  
ATOM    612  CB  GLN A 128     -14.709 130.197  33.540  1.00 42.25           C  
ATOM    613  CG  GLN A 128     -14.452 131.199  32.445  1.00 49.41           C  
ATOM    614  CD  GLN A 128     -14.709 132.633  32.858  1.00 51.95           C  
ATOM    615  OE1 GLN A 128     -15.866 133.050  32.914  1.00 54.92           O  
ATOM    616  NE2 GLN A 128     -13.664 133.403  33.133  1.00 53.91           N  
ATOM    617  N   PRO A 129     -13.298 128.219  36.351  1.00 38.53           N  
ATOM    618  CA  PRO A 129     -13.761 127.355  37.416  1.00 36.44           C  
ATOM    619  C   PRO A 129     -14.153 128.077  38.684  1.00 36.92           C  
ATOM    620  O   PRO A 129     -13.542 129.094  39.012  1.00 39.67           O  
ATOM    621  CB  PRO A 129     -12.493 126.563  37.784  1.00 38.32           C  
ATOM    622  CG  PRO A 129     -11.367 127.499  37.508  1.00 37.06           C  
ATOM    623  CD  PRO A 129     -11.823 128.347  36.357  1.00 38.24           C  
ATOM    624  N   PRO A 130     -15.077 127.501  39.434  1.00 33.84           N  
ATOM    625  CA  PRO A 130     -15.431 128.022  40.747  1.00 30.58           C  
ATOM    626  C   PRO A 130     -14.212 127.729  41.631  1.00 32.23           C  
ATOM    627  O   PRO A 130     -13.399 126.906  41.161  1.00 31.61           O  
ATOM    628  CB  PRO A 130     -16.601 127.159  41.171  1.00 32.56           C  
ATOM    629  CG  PRO A 130     -16.491 125.891  40.396  1.00 31.65           C  
ATOM    630  CD  PRO A 130     -15.790 126.240  39.111  1.00 34.44           C  
ATOM    631  N   GLY A 131     -14.129 128.209  42.863  1.00 29.57           N  
ATOM    632  CA  GLY A 131     -12.984 127.916  43.741  1.00 28.36           C  
ATOM    633  C   GLY A 131     -12.265 129.226  44.074  1.00 28.85           C  
ATOM    634  O   GLY A 131     -11.832 129.882  43.117  1.00 28.70           O  
ATOM    635  N   ASP A 132     -12.122 129.611  45.346  1.00 25.40           N  
ATOM    636  CA  ASP A 132     -11.484 130.877  45.678  1.00 27.88           C  
ATOM    637  C   ASP A 132      -9.988 130.798  45.918  1.00 26.76           C  
ATOM    638  O   ASP A 132      -9.326 131.772  46.279  1.00 28.86           O  
ATOM    639  CB  ASP A 132     -12.206 131.546  46.860  1.00 28.65           C  
ATOM    640  CG  ASP A 132     -12.027 130.926  48.217  1.00 29.27           C  
ATOM    641  OD1 ASP A 132     -11.309 129.921  48.353  1.00 31.32           O  
ATOM    642  OD2 ASP A 132     -12.568 131.450  49.229  1.00 32.31           O  
ATOM    643  N   ASP A 133      -9.415 129.630  45.691  1.00 23.15           N  
ATOM    644  CA  ASP A 133      -7.992 129.371  45.821  1.00 16.66           C  
ATOM    645  C   ASP A 133      -7.720 128.129  44.971  1.00 16.68           C  
ATOM    646  O   ASP A 133      -8.635 127.410  44.561  1.00 15.94           O  
ATOM    647  CB  ASP A 133      -7.440 129.266  47.212  1.00 23.10           C  
ATOM    648  CG  ASP A 133      -7.742 128.118  48.117  1.00 19.26           C  
ATOM    649  OD1 ASP A 133      -8.202 127.034  47.672  1.00 21.34           O  
ATOM    650  OD2 ASP A 133      -7.549 128.205  49.345  1.00 20.00           O  
ATOM    651  N   VAL A 134      -6.462 127.947  44.621  1.00 17.76           N  
ATOM    652  CA  VAL A 134      -6.014 126.874  43.748  1.00 15.14           C  
ATOM    653  C   VAL A 134      -6.416 125.512  44.259  1.00 14.92           C  
ATOM    654  O   VAL A 134      -6.820 124.681  43.435  1.00 15.32           O  
ATOM    655  CB  VAL A 134      -4.476 126.985  43.556  1.00 16.36           C  
ATOM    656  CG1 VAL A 134      -3.919 125.745  42.870  1.00 17.56           C  
ATOM    657  CG2 VAL A 134      -4.189 128.246  42.743  1.00 20.26           C  
ATOM    658  N   ALA A 135      -6.338 125.247  45.559  1.00 15.60           N  
ATOM    659  CA  ALA A 135      -6.749 123.926  46.060  1.00 13.99           C  
ATOM    660  C   ALA A 135      -8.228 123.675  45.783  1.00 15.14           C  
ATOM    661  O   ALA A 135      -8.651 122.574  45.412  1.00 15.58           O  
ATOM    662  CB  ALA A 135      -6.504 123.798  47.555  1.00 14.26           C  
ATOM    663  N   ARG A 136      -9.064 124.705  45.982  1.00 13.99           N  
ATOM    664  CA  ARG A 136     -10.505 124.557  45.813  1.00 14.21           C  
ATOM    665  C   ARG A 136     -10.857 124.459  44.345  1.00 13.34           C  
ATOM    666  O   ARG A 136     -11.780 123.693  43.961  1.00 14.67           O  
ATOM    667  CB  ARG A 136     -11.224 125.719  46.545  1.00 13.53           C  
ATOM    668  CG  ARG A 136     -11.136 125.464  48.046  1.00 14.00           C  
ATOM    669  CD  ARG A 136     -11.503 126.655  48.928  1.00 12.36           C  
ATOM    670  NE  ARG A 136     -11.645 126.300  50.327  1.00 15.51           N  
ATOM    671  CZ  ARG A 136     -10.641 126.127  51.188  1.00 10.56           C  
ATOM    672  NH1 ARG A 136      -9.393 126.337  50.732  1.00 14.61           N  
ATOM    673  NH2 ARG A 136     -10.845 125.811  52.444  1.00 12.53           N  
ATOM    674  N   ILE A 137     -10.104 125.112  43.466  1.00 12.11           N  
ATOM    675  CA  ILE A 137     -10.227 124.971  42.037  1.00 14.69           C  
ATOM    676  C   ILE A 137      -9.875 123.504  41.689  1.00 14.26           C  
ATOM    677  O   ILE A 137     -10.600 122.881  40.908  1.00 14.29           O  
ATOM    678  CB  ILE A 137      -9.353 125.917  41.211  1.00 12.99           C  
ATOM    679  CG1 ILE A 137      -9.898 127.353  41.432  1.00 17.05           C  
ATOM    680  CG2 ILE A 137      -9.362 125.563  39.745  1.00 15.00           C  
ATOM    681  CD1 ILE A 137      -8.949 128.417  40.922  1.00 17.60           C  
ATOM    682  N   ALA A 138      -8.764 122.995  42.244  1.00 13.82           N  
ATOM    683  CA  ALA A 138      -8.376 121.610  41.941  1.00 13.56           C  
ATOM    684  C   ALA A 138      -9.447 120.642  42.428  1.00 13.44           C  
ATOM    685  O   ALA A 138      -9.672 119.654  41.705  1.00 13.33           O  
ATOM    686  CB  ALA A 138      -7.030 121.303  42.588  1.00 13.42           C  
ATOM    687  N   TRP A 139     -10.014 120.871  43.602  1.00 13.50           N  
ATOM    688  CA  TRP A 139     -11.078 119.976  44.087  1.00 14.77           C  
ATOM    689  C   TRP A 139     -12.193 119.852  43.056  1.00 15.11           C  
ATOM    690  O   TRP A 139     -12.678 118.745  42.759  1.00 15.65           O  
ATOM    691  CB  TRP A 139     -11.663 120.532  45.379  1.00 15.19           C  
ATOM    692  CG  TRP A 139     -12.196 119.543  46.357  1.00 16.72           C  
ATOM    693  CD1 TRP A 139     -13.494 119.106  46.473  1.00 21.58           C  
ATOM    694  CD2 TRP A 139     -11.436 118.839  47.349  1.00 19.26           C  
ATOM    695  NE1 TRP A 139     -13.571 118.201  47.513  1.00 24.25           N  
ATOM    696  CE2 TRP A 139     -12.328 118.020  48.061  1.00 22.40           C  
ATOM    697  CE3 TRP A 139     -10.094 118.902  47.750  1.00 21.97           C  
ATOM    698  CZ2 TRP A 139     -11.908 117.217  49.125  1.00 22.17           C  
ATOM    699  CZ3 TRP A 139      -9.683 118.104  48.808  1.00 26.50           C  
ATOM    700  CH2 TRP A 139     -10.580 117.262  49.479  1.00 22.99           C  
ATOM    701  N   TYR A 140     -12.614 120.989  42.496  1.00 13.39           N  
ATOM    702  CA  TYR A 140     -13.624 120.996  41.435  1.00 14.45           C  
ATOM    703  C   TYR A 140     -13.134 120.336  40.168  1.00 14.27           C  
ATOM    704  O   TYR A 140     -13.855 119.525  39.555  1.00 14.89           O  
ATOM    705  CB  TYR A 140     -14.057 122.456  41.166  1.00 17.04           C  
ATOM    706  CG  TYR A 140     -14.652 122.681  39.787  1.00 18.30           C  
ATOM    707  CD1 TYR A 140     -16.025 122.488  39.603  1.00 20.24           C  
ATOM    708  CD2 TYR A 140     -13.919 123.064  38.692  1.00 17.36           C  
ATOM    709  CE1 TYR A 140     -16.602 122.700  38.359  1.00 19.58           C  
ATOM    710  CE2 TYR A 140     -14.475 123.251  37.433  1.00 18.34           C  
ATOM    711  CZ  TYR A 140     -15.838 123.064  37.289  1.00 21.37           C  
ATOM    712  OH  TYR A 140     -16.396 123.248  36.035  1.00 22.59           O  
ATOM    713  N   LEU A 141     -11.885 120.550  39.720  1.00 11.62           N  
ATOM    714  CA  LEU A 141     -11.397 120.003  38.474  1.00 12.93           C  
ATOM    715  C   LEU A 141     -11.210 118.483  38.598  1.00 12.08           C  
ATOM    716  O   LEU A 141     -11.471 117.799  37.599  1.00 14.30           O  
ATOM    717  CB  LEU A 141     -10.060 120.636  38.049  1.00 13.91           C  
ATOM    718  CG  LEU A 141     -10.156 122.099  37.596  1.00 13.19           C  
ATOM    719  CD1 LEU A 141      -8.722 122.640  37.458  1.00 14.22           C  
ATOM    720  CD2 LEU A 141     -10.843 122.242  36.248  1.00 14.14           C  
ATOM    721  N   ARG A 142     -10.851 118.041  39.807  1.00 13.38           N  
ATOM    722  CA  ARG A 142     -10.704 116.572  39.959  1.00 14.03           C  
ATOM    723  C   ARG A 142     -12.017 115.860  39.655  1.00 14.72           C  
ATOM    724  O   ARG A 142     -12.084 114.817  38.992  1.00 14.95           O  
ATOM    725  CB  ARG A 142     -10.244 116.208  41.366  1.00 13.52           C  
ATOM    726  CG  ARG A 142      -9.646 114.795  41.359  1.00 14.35           C  
ATOM    727  CD  ARG A 142      -9.313 114.279  42.767  1.00 16.08           C  
ATOM    728  NE  ARG A 142      -8.733 112.947  42.453  1.00 23.54           N  
ATOM    729  CZ  ARG A 142      -9.427 111.896  42.031  1.00 27.22           C  
ATOM    730  NH1 ARG A 142     -10.767 111.945  41.991  1.00 27.22           N  
ATOM    731  NH2 ARG A 142      -8.793 110.779  41.665  1.00 22.70           N  
ATOM    732  N   ASP A 143     -13.096 116.457  40.169  1.00 14.53           N  
ATOM    733  CA  ASP A 143     -14.435 115.891  39.954  1.00 14.25           C  
ATOM    734  C   ASP A 143     -14.849 116.016  38.503  1.00 16.12           C  
ATOM    735  O   ASP A 143     -15.451 115.070  37.950  1.00 15.41           O  
ATOM    736  CB  ASP A 143     -15.430 116.592  40.887  1.00 16.87           C  
ATOM    737  CG  ASP A 143     -16.867 116.117  40.630  1.00 21.47           C  
ATOM    738  OD1 ASP A 143     -17.201 115.027  41.125  1.00 24.76           O  
ATOM    739  OD2 ASP A 143     -17.579 116.835  39.919  1.00 23.40           O  
ATOM    740  N   LEU A 144     -14.559 117.137  37.853  1.00 12.33           N  
ATOM    741  CA  LEU A 144     -14.868 117.352  36.456  1.00 13.79           C  
ATOM    742  C   LEU A 144     -14.175 116.310  35.589  1.00 16.03           C  
ATOM    743  O   LEU A 144     -14.792 115.646  34.762  1.00 14.69           O  
ATOM    744  CB  LEU A 144     -14.445 118.761  36.001  1.00 14.45           C  
ATOM    745  CG  LEU A 144     -14.480 119.047  34.510  1.00 16.48           C  
ATOM    746  CD1 LEU A 144     -15.924 119.029  33.995  1.00 22.76           C  
ATOM    747  CD2 LEU A 144     -13.893 120.441  34.224  1.00 20.73           C  
ATOM    748  N   ILE A 145     -12.854 116.125  35.793  1.00 14.27           N  
ATOM    749  CA  ILE A 145     -12.100 115.152  35.018  1.00 13.65           C  
ATOM    750  C   ILE A 145     -12.668 113.740  35.274  1.00 11.93           C  
ATOM    751  O   ILE A 145     -12.865 112.988  34.309  1.00 14.04           O  
ATOM    752  CB  ILE A 145     -10.618 115.186  35.433  1.00 12.84           C  
ATOM    753  CG1 ILE A 145      -9.977 116.538  35.067  1.00 13.91           C  
ATOM    754  CG2 ILE A 145      -9.893 114.056  34.700  1.00 13.47           C  
ATOM    755  CD1 ILE A 145      -8.798 116.802  36.010  1.00 13.90           C  
ATOM    756  N   SER A 146     -12.952 113.447  36.527  1.00 13.32           N  
ATOM    757  CA  SER A 146     -13.514 112.133  36.854  1.00 12.71           C  
ATOM    758  C   SER A 146     -14.833 111.860  36.156  1.00 14.83           C  
ATOM    759  O   SER A 146     -15.064 110.759  35.634  1.00 15.37           O  
ATOM    760  CB  SER A 146     -13.712 112.014  38.371  1.00 14.87           C  
ATOM    761  OG  SER A 146     -12.455 112.056  39.029  1.00 21.14           O  
ATOM    762  N   ARG A 147     -15.693 112.892  36.115  1.00 14.59           N  
ATOM    763  CA  ARG A 147     -16.978 112.710  35.418  1.00 15.81           C  
ATOM    764  C   ARG A 147     -16.790 112.538  33.925  1.00 17.13           C  
ATOM    765  O   ARG A 147     -17.524 111.766  33.277  1.00 17.30           O  
ATOM    766  CB  ARG A 147     -17.877 113.933  35.671  1.00 16.15           C  
ATOM    767  CG  ARG A 147     -18.434 114.100  37.061  1.00 21.57           C  
ATOM    768  CD  ARG A 147     -19.431 115.264  37.084  1.00 22.53           C  
ATOM    769  NE  ARG A 147     -18.780 116.568  37.307  1.00 22.74           N  
ATOM    770  CZ  ARG A 147     -18.796 117.560  36.432  1.00 23.59           C  
ATOM    771  NH1 ARG A 147     -19.392 117.506  35.243  1.00 19.68           N  
ATOM    772  NH2 ARG A 147     -18.182 118.708  36.729  1.00 24.07           N  
ATOM    773  N   TYR A 148     -15.832 113.234  33.291  1.00 14.92           N  
ATOM    774  CA  TYR A 148     -15.654 113.140  31.837  1.00 13.53           C  
ATOM    775  C   TYR A 148     -15.012 111.814  31.466  1.00 15.49           C  
ATOM    776  O   TYR A 148     -15.225 111.275  30.375  1.00 16.56           O  
ATOM    777  CB  TYR A 148     -14.891 114.377  31.340  1.00 15.15           C  
ATOM    778  CG  TYR A 148     -15.799 115.600  31.177  1.00 17.15           C  
ATOM    779  CD1 TYR A 148     -16.926 115.739  31.972  1.00 19.81           C  
ATOM    780  CD2 TYR A 148     -15.582 116.510  30.163  1.00 22.72           C  
ATOM    781  CE1 TYR A 148     -17.810 116.797  31.811  1.00 20.33           C  
ATOM    782  CE2 TYR A 148     -16.443 117.592  29.998  1.00 21.44           C  
ATOM    783  CZ  TYR A 148     -17.540 117.711  30.822  1.00 22.44           C  
ATOM    784  OH  TYR A 148     -18.410 118.787  30.680  1.00 26.01           O  
ATOM    785  N   GLN A 149     -14.160 111.315  32.371  1.00 14.23           N  
ATOM    786  CA  GLN A 149     -13.603 109.962  32.160  1.00 12.72           C  
ATOM    787  C   GLN A 149     -14.735 108.932  32.140  1.00 16.17           C  
ATOM    788  O   GLN A 149     -14.644 107.947  31.395  1.00 13.20           O  
ATOM    789  CB  GLN A 149     -12.637 109.568  33.287  1.00 14.08           C  
ATOM    790  CG  GLN A 149     -11.345 110.399  33.247  1.00 13.08           C  
ATOM    791  CD  GLN A 149     -10.480 110.159  34.473  1.00 13.85           C  
ATOM    792  OE1 GLN A 149     -10.962 109.723  35.501  1.00 15.68           O  
ATOM    793  NE2 GLN A 149      -9.199 110.465  34.272  1.00 13.39           N  
ATOM    794  N   LYS A 150     -15.720 109.115  33.016  1.00 14.12           N  
ATOM    795  CA  LYS A 150     -16.849 108.157  33.065  1.00 13.34           C  
ATOM    796  C   LYS A 150     -17.558 108.082  31.731  1.00 14.69           C  
ATOM    797  O   LYS A 150     -18.020 106.978  31.370  1.00 14.85           O  
ATOM    798  CB  LYS A 150     -17.772 108.535  34.217  1.00 18.16           C  
ATOM    799  CG  LYS A 150     -18.963 107.599  34.407  1.00 20.61           C  
ATOM    800  CD  LYS A 150     -19.675 108.047  35.690  1.00 27.63           C  
ATOM    801  CE  LYS A 150     -20.903 107.206  35.985  1.00 32.09           C  
ATOM    802  NZ  LYS A 150     -21.451 107.481  37.347  1.00 38.60           N  
ATOM    803  N   THR A 151     -17.626 109.123  30.928  1.00 13.75           N  
ATOM    804  CA  THR A 151     -18.231 109.119  29.609  1.00 15.42           C  
ATOM    805  C   THR A 151     -17.743 107.947  28.787  1.00 15.69           C  
ATOM    806  O   THR A 151     -18.493 107.382  27.985  1.00 14.85           O  
ATOM    807  CB  THR A 151     -17.924 110.461  28.931  1.00 16.68           C  
ATOM    808  OG1 THR A 151     -18.397 111.478  29.850  1.00 16.32           O  
ATOM    809  CG2 THR A 151     -18.552 110.638  27.570  1.00 16.34           C  
ATOM    810  N   PHE A 152     -16.428 107.645  28.854  1.00 13.38           N  
ATOM    811  CA  PHE A 152     -15.891 106.536  28.061  1.00 13.82           C  
ATOM    812  C   PHE A 152     -15.686 105.250  28.837  1.00 14.42           C  
ATOM    813  O   PHE A 152     -15.843 104.158  28.283  1.00 14.81           O  
ATOM    814  CB  PHE A 152     -14.600 106.966  27.329  1.00 13.75           C  
ATOM    815  CG  PHE A 152     -14.876 108.190  26.476  1.00 13.40           C  
ATOM    816  CD1 PHE A 152     -15.981 108.265  25.641  1.00 14.36           C  
ATOM    817  CD2 PHE A 152     -14.006 109.273  26.534  1.00 13.12           C  
ATOM    818  CE1 PHE A 152     -16.225 109.386  24.873  1.00 13.90           C  
ATOM    819  CE2 PHE A 152     -14.260 110.398  25.762  1.00 15.11           C  
ATOM    820  CZ  PHE A 152     -15.365 110.474  24.917  1.00 14.09           C  
ATOM    821  N   THR A 153     -15.519 105.365  30.146  1.00 11.82           N  
ATOM    822  CA  THR A 153     -15.388 104.172  30.998  1.00 13.71           C  
ATOM    823  C   THR A 153     -16.672 103.353  30.982  1.00 14.36           C  
ATOM    824  O   THR A 153     -16.587 102.126  31.007  1.00 15.45           O  
ATOM    825  CB  THR A 153     -15.021 104.569  32.429  1.00 13.71           C  
ATOM    826  OG1 THR A 153     -13.724 105.177  32.306  1.00 14.13           O  
ATOM    827  CG2 THR A 153     -14.904 103.364  33.344  1.00 12.35           C  
ATOM    828  N   VAL A 154     -17.843 103.981  30.876  1.00 14.39           N  
ATOM    829  CA  VAL A 154     -19.085 103.198  30.791  1.00 14.14           C  
ATOM    830  C   VAL A 154     -19.081 102.310  29.556  1.00 14.27           C  
ATOM    831  O   VAL A 154     -19.819 101.299  29.633  1.00 15.63           O  
ATOM    832  CB  VAL A 154     -20.336 104.117  30.744  1.00 14.75           C  
ATOM    833  CG1 VAL A 154     -20.541 104.755  32.111  1.00 18.34           C  
ATOM    834  CG2 VAL A 154     -20.257 105.139  29.642  1.00 14.86           C  
ATOM    835  N   ILE A 155     -18.341 102.585  28.502  1.00 13.47           N  
ATOM    836  CA  ILE A 155     -18.303 101.728  27.330  1.00 13.46           C  
ATOM    837  C   ILE A 155     -17.555 100.440  27.677  1.00 16.70           C  
ATOM    838  O   ILE A 155     -17.978  99.340  27.281  1.00 15.01           O  
ATOM    839  CB  ILE A 155     -17.644 102.450  26.142  1.00 14.30           C  
ATOM    840  CG1 ILE A 155     -18.481 103.704  25.787  1.00 14.65           C  
ATOM    841  CG2 ILE A 155     -17.568 101.523  24.941  1.00 15.71           C  
ATOM    842  CD1 ILE A 155     -17.791 104.568  24.742  1.00 15.72           C  
ATOM    843  N   GLU A 156     -16.446 100.606  28.434  1.00 13.94           N  
ATOM    844  CA  GLU A 156     -15.688  99.419  28.860  1.00 13.96           C  
ATOM    845  C   GLU A 156     -16.444  98.610  29.902  1.00 15.59           C  
ATOM    846  O   GLU A 156     -16.385  97.371  29.859  1.00 16.57           O  
ATOM    847  CB  GLU A 156     -14.305  99.896  29.384  1.00 13.69           C  
ATOM    848  CG  GLU A 156     -13.522  98.764  30.040  1.00 14.35           C  
ATOM    849  CD  GLU A 156     -12.085  99.184  30.409  1.00 16.61           C  
ATOM    850  OE1 GLU A 156     -11.409  99.621  29.487  1.00 16.74           O  
ATOM    851  OE2 GLU A 156     -11.789  99.000  31.600  1.00 18.67           O  
ATOM    852  N   LYS A 157     -17.178  99.222  30.828  1.00 12.86           N  
ATOM    853  CA  LYS A 157     -17.895  98.549  31.890  1.00 14.92           C  
ATOM    854  C   LYS A 157     -19.215  97.967  31.398  1.00 15.66           C  
ATOM    855  O   LYS A 157     -19.854  97.232  32.125  1.00 19.00           O  
ATOM    856  CB  LYS A 157     -18.069  99.494  33.096  1.00 17.46           C  
ATOM    857  CG  LYS A 157     -16.679  99.972  33.518  1.00 23.43           C  
ATOM    858  CD  LYS A 157     -16.403 100.047  34.994  1.00 26.18           C  
ATOM    859  CE  LYS A 157     -14.943 100.416  35.242  1.00 23.85           C  
ATOM    860  NZ  LYS A 157     -14.161  99.294  35.836  1.00 22.69           N  
ATOM    861  N   CYS A 158     -19.615  98.302  30.188  1.00 13.78           N  
ATOM    862  CA  CYS A 158     -20.798  97.702  29.554  1.00 15.35           C  
ATOM    863  C   CYS A 158     -20.369  96.303  29.113  1.00 14.90           C  
ATOM    864  O   CYS A 158     -19.432  96.193  28.339  1.00 14.79           O  
ATOM    865  CB  CYS A 158     -21.216  98.550  28.347  1.00 15.74           C  
ATOM    866  SG  CYS A 158     -22.754  97.883  27.689  0.40 13.05           S  
ATOM    868  N   PRO A 159     -21.060  95.280  29.582  1.00 16.81           N  
ATOM    869  CA  PRO A 159     -20.664  93.905  29.278  1.00 16.67           C  
ATOM    870  C   PRO A 159     -20.855  93.505  27.835  1.00 16.79           C  
ATOM    871  O   PRO A 159     -20.266  92.535  27.330  1.00 15.69           O  
ATOM    872  CB  PRO A 159     -21.487  93.080  30.274  1.00 19.59           C  
ATOM    873  CG  PRO A 159     -22.684  93.926  30.550  1.00 22.94           C  
ATOM    874  CD  PRO A 159     -22.183  95.352  30.541  1.00 18.64           C  
ATOM    875  N   LYS A 160     -21.666  94.235  27.074  1.00 15.41           N  
ATOM    876  CA  LYS A 160     -21.850  93.941  25.665  1.00 15.98           C  
ATOM    877  C   LYS A 160     -20.697  94.475  24.844  1.00 15.92           C  
ATOM    878  O   LYS A 160     -20.245  95.611  25.051  1.00 15.70           O  
ATOM    879  CB  LYS A 160     -23.127  94.669  25.172  1.00 17.90           C  
ATOM    880  CG  LYS A 160     -24.443  94.094  25.653  1.00 17.56           C  
ATOM    881  CD  LYS A 160     -24.865  94.581  27.021  1.00 20.53           C  
ATOM    882  CE  LYS A 160     -26.365  94.378  27.223  1.00 22.30           C  
ATOM    883  NZ  LYS A 160     -26.779  94.365  28.625  1.00 24.28           N  
ATOM    884  N   PRO A 161     -20.238  93.754  23.833  1.00 16.11           N  
ATOM    885  CA  PRO A 161     -19.215  94.208  22.924  1.00 15.40           C  
ATOM    886  C   PRO A 161     -19.666  95.459  22.186  1.00 16.08           C  
ATOM    887  O   PRO A 161     -20.842  95.613  21.818  1.00 15.49           O  
ATOM    888  CB  PRO A 161     -19.013  93.073  21.927  1.00 17.69           C  
ATOM    889  CG  PRO A 161     -19.370  91.882  22.781  1.00 15.48           C  
ATOM    890  CD  PRO A 161     -20.642  92.351  23.492  1.00 15.09           C  
ATOM    891  N   VAL A 162     -18.766  96.426  22.057  1.00 14.54           N  
ATOM    892  CA  VAL A 162     -19.051  97.719  21.441  1.00 15.27           C  
ATOM    893  C   VAL A 162     -18.087  97.928  20.294  1.00 13.93           C  
ATOM    894  O   VAL A 162     -16.868  97.830  20.416  1.00 12.83           O  
ATOM    895  CB  VAL A 162     -18.900  98.879  22.446  1.00 12.28           C  
ATOM    896  CG1 VAL A 162     -19.242 100.211  21.781  1.00 15.96           C  
ATOM    897  CG2 VAL A 162     -19.756  98.643  23.677  1.00 14.09           C  
ATOM    898  N   ILE A 163     -18.621  98.100  19.090  1.00 15.21           N  
ATOM    899  CA  ILE A 163     -17.891  98.213  17.853  1.00 16.00           C  
ATOM    900  C   ILE A 163     -17.886  99.667  17.379  1.00 17.77           C  
ATOM    901  O   ILE A 163     -18.987 100.208  17.162  1.00 17.45           O  
ATOM    902  CB  ILE A 163     -18.578  97.366  16.758  1.00 16.37           C  
ATOM    903  CG1 ILE A 163     -18.616  95.878  17.147  1.00 18.67           C  
ATOM    904  CG2 ILE A 163     -17.926  97.550  15.398  1.00 16.47           C  
ATOM    905  CD1 ILE A 163     -19.786  95.127  16.535  1.00 18.98           C  
ATOM    906  N   ALA A 164     -16.725 100.276  17.239  1.00 15.78           N  
ATOM    907  CA  ALA A 164     -16.613 101.637  16.730  1.00 17.41           C  
ATOM    908  C   ALA A 164     -16.432 101.575  15.217  1.00 18.05           C  
ATOM    909  O   ALA A 164     -15.578 100.851  14.722  1.00 17.56           O  
ATOM    910  CB  ALA A 164     -15.450 102.389  17.372  1.00 16.78           C  
ATOM    911  N   ALA A 165     -17.249 102.326  14.495  1.00 18.22           N  
ATOM    912  CA  ALA A 165     -17.199 102.363  13.036  1.00 17.66           C  
ATOM    913  C   ALA A 165     -16.953 103.831  12.671  1.00 19.23           C  
ATOM    914  O   ALA A 165     -17.837 104.679  12.684  1.00 18.63           O  
ATOM    915  CB  ALA A 165     -18.501 101.830  12.468  1.00 19.11           C  
ATOM    916  N   ILE A 166     -15.698 104.090  12.345  1.00 17.42           N  
ATOM    917  CA  ILE A 166     -15.174 105.417  12.127  1.00 18.78           C  
ATOM    918  C   ILE A 166     -15.085 105.776  10.651  1.00 19.03           C  
ATOM    919  O   ILE A 166     -14.362 105.109   9.896  1.00 17.71           O  
ATOM    920  CB  ILE A 166     -13.761 105.536  12.750  1.00 17.72           C  
ATOM    921  CG1 ILE A 166     -13.836 105.242  14.251  1.00 17.81           C  
ATOM    922  CG2 ILE A 166     -13.187 106.930  12.507  1.00 17.96           C  
ATOM    923  CD1 ILE A 166     -13.191 103.948  14.691  1.00 16.10           C  
ATOM    924  N   HIS A 167     -15.596 106.974  10.331  1.00 20.40           N  
ATOM    925  CA  HIS A 167     -15.321 107.556   9.016  1.00 19.46           C  
ATOM    926  C   HIS A 167     -14.786 108.980   9.181  1.00 17.63           C  
ATOM    927  O   HIS A 167     -15.053 109.641  10.189  1.00 17.88           O  
ATOM    928  CB  HIS A 167     -16.531 107.519   8.095  1.00 20.35           C  
ATOM    929  CG  HIS A 167     -17.570 108.544   8.434  1.00 21.15           C  
ATOM    930  ND1 HIS A 167     -18.290 108.509   9.597  1.00 22.99           N  
ATOM    931  CD2 HIS A 167     -17.980 109.644   7.742  1.00 22.64           C  
ATOM    932  CE1 HIS A 167     -19.129 109.535   9.623  1.00 23.12           C  
ATOM    933  NE2 HIS A 167     -18.951 110.241   8.521  1.00 22.94           N  
ATOM    934  N   GLY A 168     -13.999 109.429   8.213  1.00 19.09           N  
ATOM    935  CA  GLY A 168     -13.428 110.775   8.293  1.00 20.77           C  
ATOM    936  C   GLY A 168     -12.615 110.930   9.590  1.00 20.43           C  
ATOM    937  O   GLY A 168     -12.146 109.937  10.155  1.00 19.38           O  
ATOM    938  N   GLY A 169     -12.469 112.168  10.034  1.00 20.75           N  
ATOM    939  CA  GLY A 169     -11.677 112.464  11.224  1.00 19.14           C  
ATOM    940  C   GLY A 169     -12.244 111.936  12.528  1.00 19.47           C  
ATOM    941  O   GLY A 169     -13.437 112.022  12.805  1.00 19.11           O  
ATOM    942  N   CYS A 170     -11.338 111.404  13.344  1.00 17.86           N  
ATOM    943  CA  CYS A 170     -11.604 110.970  14.709  1.00 16.10           C  
ATOM    944  C   CYS A 170     -10.554 111.654  15.596  1.00 17.36           C  
ATOM    945  O   CYS A 170      -9.432 111.187  15.730  1.00 15.37           O  
ATOM    946  CB  CYS A 170     -11.512 109.444  14.792  1.00 14.17           C  
ATOM    947  SG  CYS A 170     -11.774 108.802  16.466  1.00 16.98           S  
ATOM    948  N   ILE A 171     -10.899 112.858  16.053  1.00 17.15           N  
ATOM    949  CA  ILE A 171      -9.942 113.746  16.699  1.00 16.32           C  
ATOM    950  C   ILE A 171     -10.149 113.914  18.189  1.00 17.19           C  
ATOM    951  O   ILE A 171     -11.236 114.064  18.725  1.00 16.98           O  
ATOM    952  CB  ILE A 171     -10.078 115.150  16.029  1.00 17.00           C  
ATOM    953  CG1 ILE A 171      -9.783 115.073  14.529  1.00 19.27           C  
ATOM    954  CG2 ILE A 171      -9.203 116.154  16.759  1.00 17.96           C  
ATOM    955  CD1 ILE A 171     -10.283 116.294  13.767  1.00 22.90           C  
ATOM    956  N   GLY A 172      -9.023 113.848  18.914  1.00 16.11           N  
ATOM    957  CA  GLY A 172      -8.950 114.180  20.337  1.00 16.65           C  
ATOM    958  C   GLY A 172      -9.802 113.263  21.179  1.00 18.33           C  
ATOM    959  O   GLY A 172      -9.567 112.038  21.222  1.00 16.45           O  
ATOM    960  N   GLY A 173     -10.946 113.761  21.664  1.00 16.74           N  
ATOM    961  CA  GLY A 173     -11.935 112.993  22.382  1.00 13.76           C  
ATOM    962  C   GLY A 173     -12.409 111.767  21.605  1.00 13.83           C  
ATOM    963  O   GLY A 173     -12.784 110.788  22.259  1.00 17.87           O  
ATOM    964  N   GLY A 174     -12.362 111.841  20.289  1.00 15.78           N  
ATOM    965  CA  GLY A 174     -12.736 110.648  19.499  1.00 14.91           C  
ATOM    966  C   GLY A 174     -11.767 109.487  19.765  1.00 14.03           C  
ATOM    967  O   GLY A 174     -12.225 108.327  19.723  1.00 15.33           O  
ATOM    968  N   VAL A 175     -10.479 109.740  19.980  1.00 15.74           N  
ATOM    969  CA  VAL A 175      -9.566 108.597  20.228  1.00 16.49           C  
ATOM    970  C   VAL A 175      -9.802 108.057  21.622  1.00 14.59           C  
ATOM    971  O   VAL A 175      -9.724 106.832  21.857  1.00 14.51           O  
ATOM    972  CB  VAL A 175      -8.095 108.969  20.019  1.00 16.12           C  
ATOM    973  CG1 VAL A 175      -7.155 107.794  20.350  1.00 14.25           C  
ATOM    974  CG2 VAL A 175      -7.879 109.350  18.556  1.00 18.59           C  
ATOM    975  N   ASP A 176     -10.159 108.912  22.581  1.00 14.17           N  
ATOM    976  CA  ASP A 176     -10.481 108.465  23.923  1.00 14.31           C  
ATOM    977  C   ASP A 176     -11.704 107.547  23.861  1.00 16.14           C  
ATOM    978  O   ASP A 176     -11.805 106.537  24.546  1.00 16.91           O  
ATOM    979  CB  ASP A 176     -10.736 109.634  24.871  1.00 16.56           C  
ATOM    980  CG  ASP A 176      -9.607 110.647  24.991  1.00 18.08           C  
ATOM    981  OD1 ASP A 176      -9.534 111.531  24.113  1.00 17.93           O  
ATOM    982  OD2 ASP A 176      -8.826 110.625  25.967  1.00 15.46           O  
ATOM    983  N   LEU A 177     -12.685 107.931  23.025  1.00 14.84           N  
ATOM    984  CA  LEU A 177     -13.893 107.121  22.884  1.00 15.40           C  
ATOM    985  C   LEU A 177     -13.570 105.778  22.236  1.00 14.26           C  
ATOM    986  O   LEU A 177     -13.919 104.734  22.806  1.00 15.91           O  
ATOM    987  CB  LEU A 177     -14.891 107.895  21.993  1.00 16.85           C  
ATOM    988  CG  LEU A 177     -16.319 107.356  21.907  1.00 17.07           C  
ATOM    989  CD1 LEU A 177     -17.190 108.435  21.223  1.00 17.07           C  
ATOM    990  CD2 LEU A 177     -16.477 106.065  21.127  1.00 20.15           C  
ATOM    991  N   ILE A 178     -12.932 105.805  21.067  1.00 13.79           N  
ATOM    992  CA  ILE A 178     -12.733 104.498  20.380  1.00 14.72           C  
ATOM    993  C   ILE A 178     -11.781 103.590  21.118  1.00 15.35           C  
ATOM    994  O   ILE A 178     -11.931 102.346  21.001  1.00 13.85           O  
ATOM    995  CB  ILE A 178     -12.372 104.638  18.897  1.00 15.24           C  
ATOM    996  CG1 ILE A 178     -10.957 105.190  18.742  1.00 17.36           C  
ATOM    997  CG2 ILE A 178     -13.403 105.520  18.164  1.00 16.03           C  
ATOM    998  CD1 ILE A 178     -10.442 105.173  17.329  1.00 19.32           C  
ATOM    999  N   SER A 179     -10.831 104.126  21.888  1.00 14.57           N  
ATOM   1000  CA  SER A 179      -9.955 103.228  22.637  1.00 12.99           C  
ATOM   1001  C   SER A 179     -10.646 102.596  23.836  1.00 15.81           C  
ATOM   1002  O   SER A 179     -10.058 101.658  24.399  1.00 14.12           O  
ATOM   1003  CB  SER A 179      -8.652 103.919  23.034  1.00 15.40           C  
ATOM   1004  OG  SER A 179      -8.873 105.094  23.802  1.00 15.49           O  
ATOM   1005  N   ALA A 180     -11.877 102.969  24.191  1.00 13.66           N  
ATOM   1006  CA  ALA A 180     -12.685 102.317  25.209  1.00 14.25           C  
ATOM   1007  C   ALA A 180     -13.681 101.309  24.590  1.00 12.72           C  
ATOM   1008  O   ALA A 180     -14.319 100.568  25.342  1.00 16.67           O  
ATOM   1009  CB  ALA A 180     -13.423 103.297  26.100  1.00 14.16           C  
ATOM   1010  N   CYS A 181     -13.770 101.328  23.272  1.00 14.09           N  
ATOM   1011  CA  CYS A 181     -14.637 100.357  22.592  1.00 13.96           C  
ATOM   1012  C   CYS A 181     -13.813  99.077  22.439  1.00 16.39           C  
ATOM   1013  O   CYS A 181     -12.602  99.058  22.674  1.00 16.42           O  
ATOM   1014  CB  CYS A 181     -15.024 100.851  21.196  1.00 13.53           C  
ATOM   1015  SG  CYS A 181     -16.125 102.301  21.290  1.00 15.85           S  
ATOM   1016  N   ASP A 182     -14.502  98.011  22.009  1.00 14.20           N  
ATOM   1017  CA  ASP A 182     -13.796  96.729  21.878  1.00 15.41           C  
ATOM   1018  C   ASP A 182     -13.203  96.467  20.523  1.00 15.14           C  
ATOM   1019  O   ASP A 182     -12.094  95.901  20.396  1.00 16.03           O  
ATOM   1020  CB  ASP A 182     -14.806  95.604  22.229  1.00 13.69           C  
ATOM   1021  CG  ASP A 182     -15.327  95.847  23.626  1.00 16.50           C  
ATOM   1022  OD1 ASP A 182     -14.535  95.796  24.593  1.00 15.69           O  
ATOM   1023  OD2 ASP A 182     -16.525  96.176  23.747  1.00 15.70           O  
ATOM   1024  N   ILE A 183     -13.923  96.766  19.444  1.00 14.57           N  
ATOM   1025  CA  ILE A 183     -13.528  96.463  18.084  1.00 15.04           C  
ATOM   1026  C   ILE A 183     -13.641  97.755  17.286  1.00 17.88           C  
ATOM   1027  O   ILE A 183     -14.576  98.522  17.577  1.00 16.36           O  
ATOM   1028  CB  ILE A 183     -14.404  95.342  17.504  1.00 15.32           C  
ATOM   1029  CG1 ILE A 183     -14.136  94.002  18.225  1.00 16.03           C  
ATOM   1030  CG2 ILE A 183     -14.104  95.167  16.018  1.00 16.54           C  
ATOM   1031  CD1 ILE A 183     -15.259  92.993  17.999  1.00 16.72           C  
ATOM   1032  N   ARG A 184     -12.639  98.023  16.463  1.00 14.90           N  
ATOM   1033  CA  ARG A 184     -12.617  99.295  15.724  1.00 15.84           C  
ATOM   1034  C   ARG A 184     -12.498  99.060  14.226  1.00 17.92           C  
ATOM   1035  O   ARG A 184     -11.595  98.345  13.787  1.00 16.12           O  
ATOM   1036  CB  ARG A 184     -11.423 100.140  16.205  1.00 16.27           C  
ATOM   1037  CG  ARG A 184     -11.576 100.692  17.613  1.00 15.53           C  
ATOM   1038  CD  ARG A 184     -10.232 101.180  18.194  1.00 14.61           C  
ATOM   1039  NE  ARG A 184      -9.455 100.042  18.685  1.00 14.98           N  
ATOM   1040  CZ  ARG A 184      -9.707  99.364  19.787  1.00 15.93           C  
ATOM   1041  NH1 ARG A 184     -10.675  99.695  20.645  1.00 15.29           N  
ATOM   1042  NH2 ARG A 184      -8.993  98.263  20.088  1.00 16.57           N  
ATOM   1043  N   TYR A 185     -13.413  99.604  13.432  1.00 15.60           N  
ATOM   1044  CA  TYR A 185     -13.389  99.515  11.978  1.00 17.41           C  
ATOM   1045  C   TYR A 185     -13.339 100.958  11.430  1.00 15.86           C  
ATOM   1046  O   TYR A 185     -13.829 101.823  12.156  1.00 18.74           O  
ATOM   1047  CB  TYR A 185     -14.664  98.868  11.433  1.00 19.23           C  
ATOM   1048  CG  TYR A 185     -14.797  97.366  11.549  1.00 20.64           C  
ATOM   1049  CD1 TYR A 185     -13.815  96.540  12.077  1.00 19.39           C  
ATOM   1050  CD2 TYR A 185     -15.973  96.747  11.111  1.00 22.09           C  
ATOM   1051  CE1 TYR A 185     -13.954  95.168  12.174  1.00 18.17           C  
ATOM   1052  CE2 TYR A 185     -16.117  95.373  11.189  1.00 21.09           C  
ATOM   1053  CZ  TYR A 185     -15.121  94.587  11.716  1.00 22.44           C  
ATOM   1054  OH  TYR A 185     -15.276  93.212  11.783  1.00 22.63           O  
ATOM   1055  N   CYS A 186     -12.716 101.146  10.265  1.00 17.08           N  
ATOM   1056  CA  CYS A 186     -12.767 102.515   9.739  1.00 17.33           C  
ATOM   1057  C   CYS A 186     -12.865 102.480   8.210  1.00 17.92           C  
ATOM   1058  O   CYS A 186     -12.801 101.425   7.589  1.00 19.03           O  
ATOM   1059  CB  CYS A 186     -11.604 103.373  10.204  1.00 17.96           C  
ATOM   1060  SG  CYS A 186     -10.003 103.038   9.454  1.00 18.24           S  
ATOM   1061  N   THR A 187     -13.027 103.680   7.668  1.00 20.12           N  
ATOM   1062  CA  THR A 187     -13.077 103.844   6.218  1.00 18.62           C  
ATOM   1063  C   THR A 187     -11.706 104.244   5.709  1.00 18.59           C  
ATOM   1064  O   THR A 187     -10.838 104.728   6.457  1.00 18.24           O  
ATOM   1065  CB  THR A 187     -14.092 104.932   5.804  1.00 21.09           C  
ATOM   1066  OG1 THR A 187     -13.690 106.167   6.412  1.00 20.97           O  
ATOM   1067  CG2 THR A 187     -15.500 104.567   6.215  1.00 20.13           C  
ATOM   1068  N   GLN A 188     -11.529 104.176   4.377  1.00 20.98           N  
ATOM   1069  CA  GLN A 188     -10.267 104.534   3.752  1.00 22.33           C  
ATOM   1070  C   GLN A 188      -9.856 105.980   3.968  1.00 21.31           C  
ATOM   1071  O   GLN A 188      -8.665 106.300   4.043  1.00 23.29           O  
ATOM   1072  CB  GLN A 188     -10.328 104.183   2.252  1.00 23.51           C  
ATOM   1073  CG  GLN A 188      -8.977 104.266   1.574  1.00 27.98           C  
ATOM   1074  CD  GLN A 188      -7.934 103.301   2.095  1.00 31.18           C  
ATOM   1075  OE1 GLN A 188      -8.177 102.089   2.192  1.00 36.48           O  
ATOM   1076  NE2 GLN A 188      -6.747 103.788   2.447  1.00 32.16           N  
ATOM   1077  N   ASP A 189     -10.814 106.880   4.156  1.00 21.45           N  
ATOM   1078  CA  ASP A 189     -10.593 108.294   4.381  1.00 21.64           C  
ATOM   1079  C   ASP A 189     -10.509 108.692   5.850  1.00 21.52           C  
ATOM   1080  O   ASP A 189     -10.368 109.887   6.142  1.00 22.59           O  
ATOM   1081  CB  ASP A 189     -11.696 109.107   3.684  1.00 23.05           C  
ATOM   1082  CG  ASP A 189     -13.010 109.254   4.400  1.00 30.34           C  
ATOM   1083  OD1 ASP A 189     -13.387 108.489   5.311  1.00 29.38           O  
ATOM   1084  OD2 ASP A 189     -13.781 110.208   4.109  1.00 35.78           O  
ATOM   1085  N   ALA A 190     -10.609 107.730   6.769  1.00 19.27           N  
ATOM   1086  CA  ALA A 190     -10.553 108.060   8.181  1.00 18.18           C  
ATOM   1087  C   ALA A 190      -9.157 108.488   8.617  1.00 18.21           C  
ATOM   1088  O   ALA A 190      -8.126 108.108   8.064  1.00 19.37           O  
ATOM   1089  CB  ALA A 190     -10.906 106.830   9.018  1.00 19.75           C  
ATOM   1090  N   PHE A 191      -9.136 109.254   9.706  1.00 18.16           N  
ATOM   1091  CA  PHE A 191      -7.862 109.595  10.332  1.00 19.05           C  
ATOM   1092  C   PHE A 191      -8.086 109.808  11.820  1.00 18.74           C  
ATOM   1093  O   PHE A 191      -9.218 109.941  12.300  1.00 18.69           O  
ATOM   1094  CB  PHE A 191      -7.167 110.783   9.690  1.00 19.53           C  
ATOM   1095  CG  PHE A 191      -7.814 112.119   9.939  1.00 21.38           C  
ATOM   1096  CD1 PHE A 191      -7.528 112.869  11.067  1.00 22.37           C  
ATOM   1097  CD2 PHE A 191      -8.732 112.596   9.014  1.00 22.69           C  
ATOM   1098  CE1 PHE A 191      -8.127 114.101  11.261  1.00 23.62           C  
ATOM   1099  CE2 PHE A 191      -9.344 113.825   9.212  1.00 22.29           C  
ATOM   1100  CZ  PHE A 191      -9.024 114.583  10.324  1.00 23.08           C  
ATOM   1101  N   PHE A 192      -6.989 109.589  12.556  1.00 17.28           N  
ATOM   1102  CA  PHE A 192      -7.018 109.546  14.021  1.00 14.82           C  
ATOM   1103  C   PHE A 192      -5.965 110.520  14.543  1.00 14.52           C  
ATOM   1104  O   PHE A 192      -4.877 110.600  13.946  1.00 17.60           O  
ATOM   1105  CB  PHE A 192      -6.674 108.126  14.550  1.00 15.84           C  
ATOM   1106  CG  PHE A 192      -7.639 107.124  13.965  1.00 15.89           C  
ATOM   1107  CD1 PHE A 192      -7.385 106.524  12.739  1.00 18.57           C  
ATOM   1108  CD2 PHE A 192      -8.836 106.878  14.611  1.00 18.82           C  
ATOM   1109  CE1 PHE A 192      -8.296 105.650  12.163  1.00 17.16           C  
ATOM   1110  CE2 PHE A 192      -9.756 106.003  14.039  1.00 18.01           C  
ATOM   1111  CZ  PHE A 192      -9.478 105.395  12.830  1.00 18.19           C  
ATOM   1112  N   GLN A 193      -6.308 111.235  15.608  1.00 17.08           N  
ATOM   1113  CA  GLN A 193      -5.348 112.216  16.103  1.00 15.79           C  
ATOM   1114  C   GLN A 193      -5.489 112.381  17.603  1.00 17.68           C  
ATOM   1115  O   GLN A 193      -6.560 112.715  18.132  1.00 17.25           O  
ATOM   1116  CB  GLN A 193      -5.674 113.532  15.361  1.00 18.29           C  
ATOM   1117  CG  GLN A 193      -4.719 114.663  15.711  1.00 20.21           C  
ATOM   1118  CD  GLN A 193      -4.993 115.886  14.851  1.00 20.72           C  
ATOM   1119  OE1 GLN A 193      -6.137 116.113  14.430  1.00 22.61           O  
ATOM   1120  NE2 GLN A 193      -3.947 116.651  14.563  1.00 20.13           N  
ATOM   1121  N   VAL A 194      -4.363 112.182  18.297  1.00 15.31           N  
ATOM   1122  CA  VAL A 194      -4.312 112.400  19.747  1.00 16.46           C  
ATOM   1123  C   VAL A 194      -3.998 113.886  19.899  1.00 16.44           C  
ATOM   1124  O   VAL A 194      -2.868 114.331  20.067  1.00 16.36           O  
ATOM   1125  CB  VAL A 194      -3.261 111.538  20.449  1.00 14.19           C  
ATOM   1126  CG1 VAL A 194      -3.389 111.640  21.964  1.00 15.97           C  
ATOM   1127  CG2 VAL A 194      -3.440 110.074  20.026  1.00 16.28           C  
ATOM   1128  N   LYS A 195      -5.069 114.688  19.753  1.00 16.72           N  
ATOM   1129  CA  LYS A 195      -4.897 116.125  19.640  1.00 17.17           C  
ATOM   1130  C   LYS A 195      -4.641 116.910  20.896  1.00 17.51           C  
ATOM   1131  O   LYS A 195      -4.254 118.089  20.793  1.00 18.23           O  
ATOM   1132  CB  LYS A 195      -6.196 116.647  18.983  1.00 16.96           C  
ATOM   1133  CG  LYS A 195      -6.324 118.100  18.553  1.00 19.11           C  
ATOM   1134  CD  LYS A 195      -5.372 118.481  17.432  1.00 20.44           C  
ATOM   1135  CE  LYS A 195      -5.484 119.988  17.172  1.00 21.79           C  
ATOM   1136  NZ  LYS A 195      -4.353 120.508  16.371  1.00 22.28           N  
ATOM   1137  N   GLU A 196      -4.861 116.340  22.065  1.00 17.39           N  
ATOM   1138  CA  GLU A 196      -4.769 117.081  23.311  1.00 17.22           C  
ATOM   1139  C   GLU A 196      -3.536 117.905  23.533  1.00 17.61           C  
ATOM   1140  O   GLU A 196      -3.703 119.066  23.994  1.00 17.21           O  
ATOM   1141  CB  GLU A 196      -5.111 116.145  24.477  1.00 17.40           C  
ATOM   1142  CG  GLU A 196      -6.609 115.816  24.516  1.00 18.46           C  
ATOM   1143  CD  GLU A 196      -7.000 114.495  23.864  1.00 23.74           C  
ATOM   1144  OE1 GLU A 196      -6.285 114.074  22.923  1.00 18.85           O  
ATOM   1145  OE2 GLU A 196      -8.037 113.905  24.321  1.00 22.64           O  
ATOM   1146  N   VAL A 197      -2.315 117.489  23.183  1.00 15.40           N  
ATOM   1147  CA  VAL A 197      -1.157 118.342  23.453  1.00 18.08           C  
ATOM   1148  C   VAL A 197      -1.297 119.674  22.709  1.00 18.83           C  
ATOM   1149  O   VAL A 197      -0.835 120.694  23.227  1.00 19.37           O  
ATOM   1150  CB  VAL A 197       0.234 117.741  23.187  1.00 21.40           C  
ATOM   1151  CG1 VAL A 197       0.476 116.565  24.139  1.00 17.74           C  
ATOM   1152  CG2 VAL A 197       0.428 117.393  21.730  1.00 26.49           C  
ATOM   1153  N   ASP A 198      -1.945 119.699  21.545  1.00 17.19           N  
ATOM   1154  CA  ASP A 198      -2.144 120.940  20.790  1.00 18.90           C  
ATOM   1155  C   ASP A 198      -3.132 121.871  21.482  1.00 18.25           C  
ATOM   1156  O   ASP A 198      -3.215 123.041  21.055  1.00 22.38           O  
ATOM   1157  CB  ASP A 198      -2.640 120.664  19.373  1.00 19.82           C  
ATOM   1158  CG  ASP A 198      -1.559 120.262  18.398  1.00 19.94           C  
ATOM   1159  OD1 ASP A 198      -0.362 120.262  18.756  1.00 22.22           O  
ATOM   1160  OD2 ASP A 198      -1.927 119.885  17.255  1.00 22.34           O  
ATOM   1161  N   VAL A 199      -3.867 121.445  22.479  1.00 18.23           N  
ATOM   1162  CA  VAL A 199      -4.784 122.271  23.258  1.00 19.28           C  
ATOM   1163  C   VAL A 199      -4.119 122.728  24.541  1.00 18.22           C  
ATOM   1164  O   VAL A 199      -4.667 123.493  25.338  1.00 18.92           O  
ATOM   1165  CB  VAL A 199      -6.075 121.480  23.585  1.00 24.87           C  
ATOM   1166  CG1 VAL A 199      -7.094 122.339  24.326  1.00 25.32           C  
ATOM   1167  CG2 VAL A 199      -6.713 120.940  22.324  1.00 25.35           C  
ATOM   1168  N   GLY A 200      -2.927 122.182  24.864  1.00 17.81           N  
ATOM   1169  CA  GLY A 200      -2.208 122.546  26.055  1.00 16.45           C  
ATOM   1170  C   GLY A 200      -2.393 121.635  27.253  1.00 15.91           C  
ATOM   1171  O   GLY A 200      -2.099 122.002  28.394  1.00 16.53           O  
ATOM   1172  N   LEU A 201      -2.918 120.413  26.990  1.00 14.56           N  
ATOM   1173  CA  LEU A 201      -3.119 119.500  28.104  1.00 16.06           C  
ATOM   1174  C   LEU A 201      -2.751 118.060  27.718  1.00 13.49           C  
ATOM   1175  O   LEU A 201      -2.820 117.711  26.564  1.00 16.22           O  
ATOM   1176  CB  LEU A 201      -4.573 119.518  28.600  1.00 17.99           C  
ATOM   1177  CG  LEU A 201      -5.642 119.189  27.539  1.00 18.35           C  
ATOM   1178  CD1 LEU A 201      -6.349 117.893  27.895  1.00 21.45           C  
ATOM   1179  CD2 LEU A 201      -6.681 120.314  27.500  1.00 23.30           C  
ATOM   1180  N   ALA A 202      -2.397 117.277  28.746  1.00 13.85           N  
ATOM   1181  CA  ALA A 202      -2.221 115.834  28.518  1.00 15.68           C  
ATOM   1182  C   ALA A 202      -3.633 115.227  28.527  1.00 12.99           C  
ATOM   1183  O   ALA A 202      -4.414 115.448  29.452  1.00 15.22           O  
ATOM   1184  CB  ALA A 202      -1.356 115.277  29.644  1.00 13.28           C  
ATOM   1185  N   ALA A 203      -3.930 114.418  27.519  1.00 14.05           N  
ATOM   1186  CA  ALA A 203      -5.246 113.788  27.416  1.00 13.13           C  
ATOM   1187  C   ALA A 203      -5.622 113.098  28.702  1.00 15.62           C  
ATOM   1188  O   ALA A 203      -4.829 112.275  29.174  1.00 15.11           O  
ATOM   1189  CB  ALA A 203      -5.226 112.792  26.270  1.00 14.66           C  
ATOM   1190  N   ASP A 204      -6.840 113.334  29.210  1.00 14.71           N  
ATOM   1191  CA  ASP A 204      -7.173 112.809  30.525  1.00 15.07           C  
ATOM   1192  C   ASP A 204      -8.459 111.989  30.544  1.00 13.76           C  
ATOM   1193  O   ASP A 204      -8.804 111.504  31.612  1.00 16.06           O  
ATOM   1194  CB  ASP A 204      -7.195 113.967  31.543  1.00 15.00           C  
ATOM   1195  CG  ASP A 204      -8.159 115.094  31.216  1.00 18.94           C  
ATOM   1196  OD1 ASP A 204      -9.018 114.916  30.337  1.00 18.22           O  
ATOM   1197  OD2 ASP A 204      -8.074 116.213  31.804  1.00 15.87           O  
ATOM   1198  N   VAL A 205      -9.113 111.787  29.382  1.00 13.93           N  
ATOM   1199  CA  VAL A 205     -10.361 111.020  29.428  1.00 14.11           C  
ATOM   1200  C   VAL A 205     -10.245 109.618  28.858  1.00 14.76           C  
ATOM   1201  O   VAL A 205     -11.274 108.960  28.662  1.00 14.98           O  
ATOM   1202  CB  VAL A 205     -11.570 111.794  28.858  1.00 14.23           C  
ATOM   1203  CG1 VAL A 205     -11.834 112.998  29.752  1.00 15.65           C  
ATOM   1204  CG2 VAL A 205     -11.364 112.187  27.414  1.00 15.39           C  
ATOM   1205  N   GLY A 206      -9.004 109.103  28.771  1.00 14.18           N  
ATOM   1206  CA  GLY A 206      -8.835 107.697  28.460  1.00 14.27           C  
ATOM   1207  C   GLY A 206      -7.771 107.316  27.501  1.00 12.83           C  
ATOM   1208  O   GLY A 206      -7.202 106.210  27.589  1.00 14.01           O  
ATOM   1209  N   THR A 207      -7.454 108.149  26.514  1.00 12.35           N  
ATOM   1210  CA  THR A 207      -6.459 107.756  25.518  1.00 13.43           C  
ATOM   1211  C   THR A 207      -5.141 107.283  26.123  1.00 13.73           C  
ATOM   1212  O   THR A 207      -4.606 106.233  25.731  1.00 14.58           O  
ATOM   1213  CB  THR A 207      -6.157 108.929  24.570  1.00 13.41           C  
ATOM   1214  OG1 THR A 207      -7.362 109.134  23.816  1.00 15.15           O  
ATOM   1215  CG2 THR A 207      -4.985 108.647  23.648  1.00 14.76           C  
ATOM   1216  N   LEU A 208      -4.579 108.040  27.083  1.00 12.49           N  
ATOM   1217  CA  LEU A 208      -3.259 107.628  27.563  1.00 12.00           C  
ATOM   1218  C   LEU A 208      -3.346 106.310  28.325  1.00 11.16           C  
ATOM   1219  O   LEU A 208      -2.345 105.604  28.454  1.00 14.65           O  
ATOM   1220  CB  LEU A 208      -2.639 108.701  28.478  1.00 11.38           C  
ATOM   1221  CG  LEU A 208      -2.562 110.112  27.848  1.00 12.51           C  
ATOM   1222  CD1 LEU A 208      -1.839 111.042  28.818  1.00 17.43           C  
ATOM   1223  CD2 LEU A 208      -1.864 110.120  26.495  1.00 14.10           C  
ATOM   1224  N   GLN A 209      -4.502 106.015  28.930  1.00 12.86           N  
ATOM   1225  CA  GLN A 209      -4.661 104.824  29.768  1.00 13.87           C  
ATOM   1226  C   GLN A 209      -5.016 103.612  28.908  1.00 15.79           C  
ATOM   1227  O   GLN A 209      -4.589 102.503  29.288  1.00 14.02           O  
ATOM   1228  CB  GLN A 209      -5.758 105.067  30.807  1.00 14.28           C  
ATOM   1229  CG  GLN A 209      -5.411 106.055  31.918  1.00 13.56           C  
ATOM   1230  CD  GLN A 209      -5.395 107.502  31.446  1.00 14.81           C  
ATOM   1231  OE1 GLN A 209      -6.226 107.872  30.624  1.00 14.04           O  
ATOM   1232  NE2 GLN A 209      -4.433 108.270  31.961  1.00 13.84           N  
ATOM   1233  N   ARG A 210      -5.730 103.816  27.801  1.00 13.94           N  
ATOM   1234  CA  ARG A 210      -6.166 102.683  26.985  1.00 12.15           C  
ATOM   1235  C   ARG A 210      -5.514 102.521  25.633  1.00 15.34           C  
ATOM   1236  O   ARG A 210      -5.323 101.375  25.177  1.00 14.87           O  
ATOM   1237  CB  ARG A 210      -7.693 102.745  26.783  1.00 13.35           C  
ATOM   1238  CG  ARG A 210      -8.521 102.665  28.040  1.00 14.40           C  
ATOM   1239  CD  ARG A 210     -10.005 102.375  27.737  1.00 12.16           C  
ATOM   1240  NE  ARG A 210     -10.774 102.385  28.990  1.00 12.98           N  
ATOM   1241  CZ  ARG A 210     -11.318 103.451  29.583  1.00 12.71           C  
ATOM   1242  NH1 ARG A 210     -11.198 104.655  29.011  1.00 15.28           N  
ATOM   1243  NH2 ARG A 210     -11.941 103.324  30.745  1.00 13.16           N  
ATOM   1244  N   LEU A 211      -5.128 103.584  24.929  1.00 14.38           N  
ATOM   1245  CA  LEU A 211      -4.502 103.444  23.624  1.00 13.48           C  
ATOM   1246  C   LEU A 211      -3.258 102.571  23.609  1.00 15.96           C  
ATOM   1247  O   LEU A 211      -3.173 101.622  22.797  1.00 14.39           O  
ATOM   1248  CB  LEU A 211      -4.239 104.801  22.949  1.00 15.75           C  
ATOM   1249  CG  LEU A 211      -3.492 104.742  21.612  1.00 18.84           C  
ATOM   1250  CD1 LEU A 211      -4.280 104.025  20.538  1.00 17.99           C  
ATOM   1251  CD2 LEU A 211      -3.123 106.163  21.185  1.00 16.69           C  
ATOM   1252  N   PRO A 212      -2.345 102.690  24.568  1.00 14.81           N  
ATOM   1253  CA  PRO A 212      -1.168 101.835  24.632  1.00 15.90           C  
ATOM   1254  C   PRO A 212      -1.516 100.399  25.005  1.00 16.06           C  
ATOM   1255  O   PRO A 212      -0.648  99.522  24.911  1.00 17.36           O  
ATOM   1256  CB  PRO A 212      -0.244 102.456  25.672  1.00 14.26           C  
ATOM   1257  CG  PRO A 212      -0.801 103.816  25.917  1.00 16.11           C  
ATOM   1258  CD  PRO A 212      -2.278 103.738  25.619  1.00 15.74           C  
ATOM   1259  N   LYS A 213      -2.766 100.162  25.420  1.00 14.32           N  
ATOM   1260  CA  LYS A 213      -3.227  98.826  25.750  1.00 14.95           C  
ATOM   1261  C   LYS A 213      -4.155  98.277  24.679  1.00 15.74           C  
ATOM   1262  O   LYS A 213      -4.846  97.274  24.967  1.00 19.99           O  
ATOM   1263  CB  LYS A 213      -3.862  98.772  27.131  1.00 15.49           C  
ATOM   1264  CG  LYS A 213      -2.839  99.012  28.236  1.00 17.82           C  
ATOM   1265  CD  LYS A 213      -3.526  99.150  29.596  1.00 17.29           C  
ATOM   1266  CE  LYS A 213      -2.385  99.229  30.615  1.00 21.53           C  
ATOM   1267  NZ  LYS A 213      -2.877  99.255  32.010  1.00 25.30           N  
ATOM   1268  N   VAL A 214      -4.180  98.878  23.492  1.00 13.29           N  
ATOM   1269  CA  VAL A 214      -4.974  98.320  22.402  1.00 16.29           C  
ATOM   1270  C   VAL A 214      -4.083  98.074  21.194  1.00 16.38           C  
ATOM   1271  O   VAL A 214      -4.510  97.420  20.223  1.00 15.30           O  
ATOM   1272  CB  VAL A 214      -6.239  99.078  21.966  1.00 15.22           C  
ATOM   1273  CG1 VAL A 214      -7.199  99.293  23.126  1.00 16.47           C  
ATOM   1274  CG2 VAL A 214      -5.918 100.387  21.255  1.00 15.31           C  
ATOM   1275  N   ILE A 215      -2.859  98.611  21.157  1.00 15.00           N  
ATOM   1276  CA  ILE A 215      -1.922  98.374  20.071  1.00 14.82           C  
ATOM   1277  C   ILE A 215      -0.540  98.122  20.693  1.00 14.72           C  
ATOM   1278  O   ILE A 215      -0.292  98.502  21.841  1.00 16.11           O  
ATOM   1279  CB  ILE A 215      -1.808  99.472  18.999  1.00 16.76           C  
ATOM   1280  CG1 ILE A 215      -1.316 100.807  19.587  1.00 16.49           C  
ATOM   1281  CG2 ILE A 215      -3.149  99.673  18.295  1.00 17.15           C  
ATOM   1282  CD1 ILE A 215      -0.917 101.801  18.498  1.00 21.35           C  
ATOM   1283  N   GLY A 216       0.300  97.441  19.923  1.00 14.28           N  
ATOM   1284  CA  GLY A 216       1.607  97.049  20.428  1.00 15.02           C  
ATOM   1285  C   GLY A 216       2.768  98.018  20.331  1.00 14.98           C  
ATOM   1286  O   GLY A 216       3.694  97.927  21.143  1.00 18.13           O  
ATOM   1287  N   ASN A 217       2.762  98.865  19.319  1.00 16.01           N  
ATOM   1288  CA  ASN A 217       3.909  99.725  19.004  1.00 16.21           C  
ATOM   1289  C   ASN A 217       3.942 100.960  19.882  1.00 15.74           C  
ATOM   1290  O   ASN A 217       3.268 101.953  19.618  1.00 14.61           O  
ATOM   1291  CB  ASN A 217       3.840 100.090  17.532  1.00 17.09           C  
ATOM   1292  CG  ASN A 217       5.024 100.866  16.999  1.00 15.63           C  
ATOM   1293  OD1 ASN A 217       5.785 101.528  17.734  1.00 16.18           O  
ATOM   1294  ND2 ASN A 217       5.209 100.846  15.682  1.00 16.39           N  
ATOM   1295  N   ARG A 218       4.775 100.946  20.911  1.00 14.98           N  
ATOM   1296  CA  ARG A 218       4.799 102.069  21.849  1.00 14.74           C  
ATOM   1297  C   ARG A 218       5.580 103.243  21.280  1.00 17.07           C  
ATOM   1298  O   ARG A 218       5.245 104.381  21.651  1.00 14.43           O  
ATOM   1299  CB  ARG A 218       5.405 101.622  23.182  1.00 15.23           C  
ATOM   1300  CG  ARG A 218       5.262 102.677  24.268  1.00 15.51           C  
ATOM   1301  CD  ARG A 218       5.747 102.201  25.637  1.00 16.81           C  
ATOM   1302  NE  ARG A 218       4.745 101.282  26.167  1.00 23.38           N  
ATOM   1303  CZ  ARG A 218       3.677 101.695  26.877  1.00 24.84           C  
ATOM   1304  NH1 ARG A 218       3.472 102.954  27.177  1.00 24.61           N  
ATOM   1305  NH2 ARG A 218       2.827 100.776  27.296  1.00 27.46           N  
ATOM   1306  N   SER A 219       6.529 103.010  20.377  1.00 14.50           N  
ATOM   1307  CA  SER A 219       7.226 104.161  19.766  1.00 15.40           C  
ATOM   1308  C   SER A 219       6.190 105.006  19.012  1.00 14.72           C  
ATOM   1309  O   SER A 219       6.215 106.249  19.127  1.00 14.62           O  
ATOM   1310  CB  SER A 219       8.341 103.651  18.861  1.00 14.12           C  
ATOM   1311  OG  SER A 219       9.086 104.743  18.291  1.00 14.54           O  
ATOM   1312  N   LEU A 220       5.311 104.352  18.245  1.00 14.05           N  
ATOM   1313  CA  LEU A 220       4.235 105.049  17.536  1.00 15.97           C  
ATOM   1314  C   LEU A 220       3.270 105.732  18.502  1.00 16.31           C  
ATOM   1315  O   LEU A 220       2.936 106.907  18.312  1.00 15.70           O  
ATOM   1316  CB  LEU A 220       3.428 104.017  16.731  1.00 15.78           C  
ATOM   1317  CG  LEU A 220       2.203 104.572  15.976  1.00 15.92           C  
ATOM   1318  CD1 LEU A 220       2.582 105.664  14.996  1.00 17.20           C  
ATOM   1319  CD2 LEU A 220       1.479 103.402  15.304  1.00 18.04           C  
ATOM   1320  N   VAL A 221       2.823 105.039  19.563  1.00 14.91           N  
ATOM   1321  CA  VAL A 221       1.944 105.664  20.558  1.00 16.90           C  
ATOM   1322  C   VAL A 221       2.548 106.976  21.073  1.00 15.87           C  
ATOM   1323  O   VAL A 221       1.878 108.010  21.160  1.00 14.56           O  
ATOM   1324  CB  VAL A 221       1.661 104.748  21.763  1.00 18.39           C  
ATOM   1325  CG1 VAL A 221       0.985 105.497  22.908  1.00 20.50           C  
ATOM   1326  CG2 VAL A 221       0.792 103.562  21.337  1.00 20.21           C  
ATOM   1327  N   ASN A 222       3.834 106.932  21.437  1.00 15.78           N  
ATOM   1328  CA  ASN A 222       4.520 108.105  21.972  1.00 15.30           C  
ATOM   1329  C   ASN A 222       4.649 109.175  20.905  1.00 16.70           C  
ATOM   1330  O   ASN A 222       4.316 110.336  21.213  1.00 15.14           O  
ATOM   1331  CB  ASN A 222       5.903 107.693  22.486  1.00 16.24           C  
ATOM   1332  CG  ASN A 222       5.865 106.933  23.793  1.00 20.07           C  
ATOM   1333  OD1 ASN A 222       4.956 107.112  24.623  1.00 21.84           O  
ATOM   1334  ND2 ASN A 222       6.835 106.083  24.064  1.00 19.47           N  
ATOM   1335  N   GLU A 223       4.954 108.816  19.662  1.00 15.30           N  
ATOM   1336  CA  GLU A 223       5.069 109.874  18.649  1.00 16.98           C  
ATOM   1337  C   GLU A 223       3.717 110.535  18.386  1.00 17.50           C  
ATOM   1338  O   GLU A 223       3.612 111.763  18.280  1.00 16.84           O  
ATOM   1339  CB  GLU A 223       5.684 109.376  17.343  1.00 20.80           C  
ATOM   1340  CG  GLU A 223       5.817 110.551  16.361  1.00 25.88           C  
ATOM   1341  CD  GLU A 223       5.249 110.158  15.010  1.00 34.57           C  
ATOM   1342  OE1 GLU A 223       4.382 109.257  15.024  1.00 40.18           O  
ATOM   1343  OE2 GLU A 223       5.684 110.741  13.992  1.00 32.20           O  
ATOM   1344  N   LEU A 224       2.661 109.735  18.341  1.00 14.47           N  
ATOM   1345  CA  LEU A 224       1.324 110.273  18.090  1.00 13.69           C  
ATOM   1346  C   LEU A 224       0.929 111.220  19.217  1.00 15.93           C  
ATOM   1347  O   LEU A 224       0.350 112.284  18.995  1.00 15.84           O  
ATOM   1348  CB  LEU A 224       0.280 109.149  18.037  1.00 14.81           C  
ATOM   1349  CG  LEU A 224       0.356 108.259  16.802  1.00 14.82           C  
ATOM   1350  CD1 LEU A 224      -0.737 107.190  16.873  1.00 15.76           C  
ATOM   1351  CD2 LEU A 224       0.195 109.062  15.514  1.00 15.95           C  
ATOM   1352  N   THR A 225       1.211 110.815  20.446  1.00 14.65           N  
ATOM   1353  CA  THR A 225       0.834 111.614  21.605  1.00 15.27           C  
ATOM   1354  C   THR A 225       1.623 112.907  21.719  1.00 15.86           C  
ATOM   1355  O   THR A 225       1.039 113.966  22.020  1.00 16.03           O  
ATOM   1356  CB  THR A 225       0.975 110.794  22.905  1.00 17.90           C  
ATOM   1357  OG1 THR A 225       0.186 109.598  22.772  1.00 15.02           O  
ATOM   1358  CG2 THR A 225       0.429 111.549  24.116  1.00 15.80           C  
ATOM   1359  N   PHE A 226       2.946 112.849  21.553  1.00 15.31           N  
ATOM   1360  CA  PHE A 226       3.754 114.053  21.772  1.00 15.44           C  
ATOM   1361  C   PHE A 226       3.673 115.030  20.609  1.00 16.64           C  
ATOM   1362  O   PHE A 226       3.911 116.236  20.864  1.00 17.80           O  
ATOM   1363  CB  PHE A 226       5.209 113.663  22.051  1.00 15.48           C  
ATOM   1364  CG  PHE A 226       5.382 112.719  23.209  1.00 13.53           C  
ATOM   1365  CD1 PHE A 226       4.635 112.746  24.365  1.00 15.09           C  
ATOM   1366  CD2 PHE A 226       6.426 111.806  23.097  1.00 14.37           C  
ATOM   1367  CE1 PHE A 226       4.873 111.861  25.404  1.00 17.52           C  
ATOM   1368  CE2 PHE A 226       6.673 110.913  24.131  1.00 15.31           C  
ATOM   1369  CZ  PHE A 226       5.922 110.946  25.275  1.00 15.12           C  
ATOM   1370  N   THR A 227       3.349 114.582  19.415  1.00 16.65           N  
ATOM   1371  CA  THR A 227       3.280 115.512  18.278  1.00 17.13           C  
ATOM   1372  C   THR A 227       1.856 115.866  17.880  1.00 17.79           C  
ATOM   1373  O   THR A 227       1.635 116.759  17.029  1.00 18.28           O  
ATOM   1374  CB  THR A 227       3.957 114.929  17.024  1.00 15.41           C  
ATOM   1375  OG1 THR A 227       3.202 113.787  16.580  1.00 18.68           O  
ATOM   1376  CG2 THR A 227       5.392 114.471  17.265  1.00 17.89           C  
ATOM   1377  N   ALA A 228       0.858 115.093  18.346  1.00 16.46           N  
ATOM   1378  CA  ALA A 228      -0.519 115.303  17.904  1.00 16.60           C  
ATOM   1379  C   ALA A 228      -0.709 115.180  16.404  1.00 17.65           C  
ATOM   1380  O   ALA A 228      -1.695 115.700  15.864  1.00 18.53           O  
ATOM   1381  CB  ALA A 228      -1.045 116.638  18.432  1.00 19.79           C  
ATOM   1382  N   ARG A 229       0.112 114.411  15.693  1.00 16.25           N  
ATOM   1383  CA  ARG A 229      -0.011 114.281  14.255  1.00 18.96           C  
ATOM   1384  C   ARG A 229      -1.146 113.325  13.893  1.00 20.76           C  
ATOM   1385  O   ARG A 229      -1.556 112.476  14.693  1.00 19.85           O  
ATOM   1386  CB  ARG A 229       1.295 113.797  13.624  1.00 20.73           C  
ATOM   1387  CG  ARG A 229       1.632 112.341  13.981  1.00 22.88           C  
ATOM   1388  CD  ARG A 229       2.440 111.779  12.811  1.00 24.92           C  
ATOM   1389  NE  ARG A 229       2.930 110.421  12.999  1.00 22.66           N  
ATOM   1390  CZ  ARG A 229       2.369 109.319  12.507  1.00 22.17           C  
ATOM   1391  NH1 ARG A 229       1.273 109.335  11.768  1.00 21.58           N  
ATOM   1392  NH2 ARG A 229       2.974 108.159  12.745  1.00 20.23           N  
ATOM   1393  N   LYS A 230      -1.633 113.481  12.673  1.00 19.29           N  
ATOM   1394  CA  LYS A 230      -2.705 112.644  12.169  1.00 18.31           C  
ATOM   1395  C   LYS A 230      -2.166 111.286  11.747  1.00 18.81           C  
ATOM   1396  O   LYS A 230      -1.083 111.178  11.167  1.00 20.21           O  
ATOM   1397  CB  LYS A 230      -3.390 113.358  10.984  1.00 19.98           C  
ATOM   1398  CG  LYS A 230      -4.187 114.581  11.437  1.00 19.94           C  
ATOM   1399  CD  LYS A 230      -4.804 115.289  10.228  1.00 24.65           C  
ATOM   1400  CE  LYS A 230      -5.472 116.572  10.722  1.00 24.41           C  
ATOM   1401  NZ  LYS A 230      -6.119 117.307   9.594  1.00 31.18           N  
ATOM   1402  N   MET A 231      -2.952 110.254  12.029  1.00 17.64           N  
ATOM   1403  CA  MET A 231      -2.624 108.906  11.572  1.00 18.73           C  
ATOM   1404  C   MET A 231      -3.747 108.509  10.617  1.00 17.28           C  
ATOM   1405  O   MET A 231      -4.908 108.475  11.024  1.00 18.04           O  
ATOM   1406  CB  MET A 231      -2.484 107.887  12.706  1.00 18.04           C  
ATOM   1407  CG  MET A 231      -2.331 106.459  12.166  1.00 17.09           C  
ATOM   1408  SD  MET A 231      -1.751 105.283  13.425  1.00 18.74           S  
ATOM   1409  CE  MET A 231      -3.139 105.270  14.546  1.00 18.01           C  
ATOM   1410  N   MET A 232      -3.424 108.260   9.352  1.00 20.00           N  
ATOM   1411  CA  MET A 232      -4.437 107.915   8.356  1.00 20.20           C  
ATOM   1412  C   MET A 232      -4.809 106.445   8.387  1.00 20.25           C  
ATOM   1413  O   MET A 232      -4.193 105.646   9.094  1.00 18.36           O  
ATOM   1414  CB  MET A 232      -3.983 108.417   6.981  1.00 20.69           C  
ATOM   1415  CG  MET A 232      -4.530 109.805   6.651  1.00 27.38           C  
ATOM   1416  SD  MET A 232      -4.115 111.104   7.817  1.00 26.78           S  
ATOM   1417  CE  MET A 232      -2.330 111.126   7.709  1.00 32.29           C  
ATOM   1418  N   ALA A 233      -5.843 106.036   7.650  1.00 21.67           N  
ATOM   1419  CA  ALA A 233      -6.364 104.685   7.683  1.00 18.82           C  
ATOM   1420  C   ALA A 233      -5.355 103.583   7.405  1.00 20.26           C  
ATOM   1421  O   ALA A 233      -5.385 102.598   8.160  1.00 20.22           O  
ATOM   1422  CB  ALA A 233      -7.540 104.546   6.708  1.00 20.13           C  
ATOM   1423  N   ASP A 234      -4.505 103.712   6.372  1.00 19.53           N  
ATOM   1424  CA  ASP A 234      -3.562 102.633   6.098  1.00 20.15           C  
ATOM   1425  C   ASP A 234      -2.654 102.377   7.303  1.00 18.45           C  
ATOM   1426  O   ASP A 234      -2.457 101.209   7.679  1.00 19.51           O  
ATOM   1427  CB  ASP A 234      -2.687 102.910   4.878  1.00 22.17           C  
ATOM   1428  CG  ASP A 234      -3.417 102.784   3.554  1.00 28.31           C  
ATOM   1429  OD1 ASP A 234      -4.543 102.259   3.501  1.00 29.04           O  
ATOM   1430  OD2 ASP A 234      -2.856 103.264   2.546  1.00 33.44           O  
ATOM   1431  N   GLU A 235      -2.152 103.447   7.913  1.00 20.58           N  
ATOM   1432  CA  GLU A 235      -1.293 103.284   9.082  1.00 18.44           C  
ATOM   1433  C   GLU A 235      -2.068 102.821  10.309  1.00 19.90           C  
ATOM   1434  O   GLU A 235      -1.584 102.015  11.114  1.00 18.85           O  
ATOM   1435  CB  GLU A 235      -0.556 104.592   9.368  1.00 18.53           C  
ATOM   1436  CG  GLU A 235       0.440 104.466  10.524  1.00 22.02           C  
ATOM   1437  CD  GLU A 235       1.196 105.753  10.784  1.00 23.74           C  
ATOM   1438  OE1 GLU A 235       0.694 106.834  10.382  1.00 22.79           O  
ATOM   1439  OE2 GLU A 235       2.297 105.684  11.365  1.00 22.66           O  
ATOM   1440  N   ALA A 236      -3.338 103.211  10.416  1.00 18.71           N  
ATOM   1441  CA  ALA A 236      -4.165 102.765  11.528  1.00 17.38           C  
ATOM   1442  C   ALA A 236      -4.355 101.252  11.447  1.00 18.81           C  
ATOM   1443  O   ALA A 236      -4.324 100.581  12.476  1.00 19.27           O  
ATOM   1444  CB  ALA A 236      -5.519 103.466  11.514  1.00 17.17           C  
ATOM   1445  N   LEU A 237      -4.539 100.732  10.230  1.00 18.09           N  
ATOM   1446  CA  LEU A 237      -4.707  99.292  10.047  1.00 19.75           C  
ATOM   1447  C   LEU A 237      -3.392  98.572  10.332  1.00 18.82           C  
ATOM   1448  O   LEU A 237      -3.331  97.575  11.055  1.00 20.26           O  
ATOM   1449  CB  LEU A 237      -5.130  98.981   8.608  1.00 18.14           C  
ATOM   1450  CG  LEU A 237      -5.368  97.492   8.304  1.00 20.31           C  
ATOM   1451  CD1 LEU A 237      -6.486  96.946   9.174  1.00 18.87           C  
ATOM   1452  CD2 LEU A 237      -5.697  97.345   6.824  1.00 22.00           C  
ATOM   1453  N   ASP A 238      -2.298  99.144   9.823  1.00 19.47           N  
ATOM   1454  CA  ASP A 238      -0.978  98.545  10.040  1.00 17.97           C  
ATOM   1455  C   ASP A 238      -0.621  98.433  11.522  1.00 19.87           C  
ATOM   1456  O   ASP A 238      -0.061  97.428  11.979  1.00 19.42           O  
ATOM   1457  CB  ASP A 238       0.061  99.435   9.370  1.00 20.61           C  
ATOM   1458  CG  ASP A 238       1.428  98.803   9.234  1.00 26.89           C  
ATOM   1459  OD1 ASP A 238       1.537  97.827   8.462  1.00 28.64           O  
ATOM   1460  OD2 ASP A 238       2.381  99.331   9.841  1.00 28.50           O  
ATOM   1461  N   SER A 239      -1.010  99.449  12.290  1.00 16.58           N  
ATOM   1462  CA  SER A 239      -0.691  99.497  13.715  1.00 18.11           C  
ATOM   1463  C   SER A 239      -1.576  98.575  14.537  1.00 16.25           C  
ATOM   1464  O   SER A 239      -1.299  98.374  15.722  1.00 19.31           O  
ATOM   1465  CB  SER A 239      -0.839 100.925  14.277  1.00 17.50           C  
ATOM   1466  OG  SER A 239      -2.185 101.338  14.324  1.00 18.44           O  
ATOM   1467  N   GLY A 240      -2.707  98.172  13.971  1.00 17.16           N  
ATOM   1468  CA  GLY A 240      -3.689  97.362  14.654  1.00 17.76           C  
ATOM   1469  C   GLY A 240      -4.729  98.191  15.383  1.00 15.51           C  
ATOM   1470  O   GLY A 240      -5.612  97.612  16.025  1.00 17.45           O  
ATOM   1471  N   LEU A 241      -4.684  99.537  15.267  1.00 15.50           N  
ATOM   1472  CA  LEU A 241      -5.693 100.338  15.963  1.00 17.34           C  
ATOM   1473  C   LEU A 241      -7.089  99.952  15.457  1.00 16.79           C  
ATOM   1474  O   LEU A 241      -8.018  99.873  16.250  1.00 16.80           O  
ATOM   1475  CB  LEU A 241      -5.425 101.836  15.840  1.00 16.03           C  
ATOM   1476  CG  LEU A 241      -6.500 102.751  16.443  1.00 19.49           C  
ATOM   1477  CD1 LEU A 241      -6.647 102.533  17.940  1.00 15.76           C  
ATOM   1478  CD2 LEU A 241      -6.181 104.218  16.136  1.00 18.82           C  
ATOM   1479  N   VAL A 242      -7.200  99.798  14.147  1.00 16.65           N  
ATOM   1480  CA  VAL A 242      -8.425  99.305  13.526  1.00 16.60           C  
ATOM   1481  C   VAL A 242      -8.105  97.907  12.993  1.00 20.22           C  
ATOM   1482  O   VAL A 242      -6.931  97.700  12.661  1.00 20.51           O  
ATOM   1483  CB  VAL A 242      -8.968 100.195  12.400  1.00 18.10           C  
ATOM   1484  CG1 VAL A 242      -9.257 101.597  12.938  1.00 19.21           C  
ATOM   1485  CG2 VAL A 242      -8.034 100.319  11.205  1.00 20.59           C  
ATOM   1486  N   SER A 243      -9.103  97.031  12.974  1.00 18.46           N  
ATOM   1487  CA  SER A 243      -8.763  95.682  12.476  1.00 20.68           C  
ATOM   1488  C   SER A 243      -9.312  95.475  11.086  1.00 20.11           C  
ATOM   1489  O   SER A 243      -8.933  94.494  10.432  1.00 19.31           O  
ATOM   1490  CB  SER A 243      -9.126  94.643  13.520  1.00 23.56           C  
ATOM   1491  OG  SER A 243     -10.459  94.755  13.980  1.00 20.68           O  
ATOM   1492  N   ARG A 244     -10.108  96.389  10.543  1.00 19.85           N  
ATOM   1493  CA  ARG A 244     -10.590  96.314   9.173  1.00 21.19           C  
ATOM   1494  C   ARG A 244     -10.802  97.731   8.628  1.00 21.54           C  
ATOM   1495  O   ARG A 244     -11.217  98.627   9.375  1.00 21.18           O  
ATOM   1496  CB  ARG A 244     -11.916  95.566   9.002  1.00 23.26           C  
ATOM   1497  CG  ARG A 244     -11.902  94.076   9.293  1.00 24.76           C  
ATOM   1498  CD  ARG A 244     -13.135  93.386   8.727  1.00 27.25           C  
ATOM   1499  NE  ARG A 244     -13.050  93.324   7.270  1.00 29.43           N  
ATOM   1500  CZ  ARG A 244     -14.014  92.868   6.476  1.00 31.39           C  
ATOM   1501  NH1 ARG A 244     -15.171  92.454   6.974  1.00 30.35           N  
ATOM   1502  NH2 ARG A 244     -13.837  92.857   5.160  1.00 31.22           N  
ATOM   1503  N   VAL A 245     -10.471  97.921   7.361  1.00 21.27           N  
ATOM   1504  CA  VAL A 245     -10.663  99.172   6.641  1.00 20.59           C  
ATOM   1505  C   VAL A 245     -11.571  98.900   5.444  1.00 23.86           C  
ATOM   1506  O   VAL A 245     -11.484  97.839   4.819  1.00 23.16           O  
ATOM   1507  CB  VAL A 245      -9.348  99.786   6.145  1.00 19.58           C  
ATOM   1508  CG1 VAL A 245      -9.593 101.059   5.324  1.00 20.49           C  
ATOM   1509  CG2 VAL A 245      -8.438 100.110   7.325  1.00 18.14           C  
ATOM   1510  N   PHE A 246     -12.492  99.828   5.182  1.00 22.13           N  
ATOM   1511  CA  PHE A 246     -13.490  99.716   4.123  1.00 23.82           C  
ATOM   1512  C   PHE A 246     -13.476 100.924   3.210  1.00 26.20           C  
ATOM   1513  O   PHE A 246     -13.131 102.039   3.612  1.00 26.60           O  
ATOM   1514  CB  PHE A 246     -14.894  99.596   4.752  1.00 21.39           C  
ATOM   1515  CG  PHE A 246     -15.028  98.406   5.659  1.00 22.84           C  
ATOM   1516  CD1 PHE A 246     -15.407  97.163   5.169  1.00 23.20           C  
ATOM   1517  CD2 PHE A 246     -14.751  98.536   7.017  1.00 21.19           C  
ATOM   1518  CE1 PHE A 246     -15.520  96.072   6.011  1.00 24.10           C  
ATOM   1519  CE2 PHE A 246     -14.862  97.449   7.858  1.00 21.48           C  
ATOM   1520  CZ  PHE A 246     -15.246  96.213   7.362  1.00 22.67           C  
ATOM   1521  N   PRO A 247     -13.865 100.757   1.941  1.00 26.38           N  
ATOM   1522  CA  PRO A 247     -13.872 101.835   0.976  1.00 28.10           C  
ATOM   1523  C   PRO A 247     -14.804 102.980   1.301  1.00 26.49           C  
ATOM   1524  O   PRO A 247     -14.468 104.118   0.933  1.00 29.88           O  
ATOM   1525  CB  PRO A 247     -14.210 101.182  -0.360  1.00 27.96           C  
ATOM   1526  CG  PRO A 247     -14.383  99.732  -0.117  1.00 30.38           C  
ATOM   1527  CD  PRO A 247     -14.293  99.465   1.358  1.00 29.25           C  
ATOM   1528  N   ASP A 248     -15.958 102.749   1.904  1.00 28.46           N  
ATOM   1529  CA  ASP A 248     -16.849 103.842   2.280  1.00 26.92           C  
ATOM   1530  C   ASP A 248     -17.675 103.530   3.521  1.00 24.30           C  
ATOM   1531  O   ASP A 248     -17.711 102.399   3.993  1.00 24.81           O  
ATOM   1532  CB  ASP A 248     -17.773 104.272   1.139  1.00 28.68           C  
ATOM   1533  CG  ASP A 248     -18.644 103.145   0.637  1.00 31.79           C  
ATOM   1534  OD1 ASP A 248     -19.347 102.475   1.417  1.00 33.12           O  
ATOM   1535  OD2 ASP A 248     -18.652 102.908  -0.588  1.00 36.41           O  
ATOM   1536  N   LYS A 249     -18.364 104.547   4.034  1.00 22.54           N  
ATOM   1537  CA  LYS A 249     -19.134 104.441   5.259  1.00 24.31           C  
ATOM   1538  C   LYS A 249     -20.239 103.401   5.170  1.00 26.10           C  
ATOM   1539  O   LYS A 249     -20.450 102.644   6.117  1.00 22.66           O  
ATOM   1540  CB  LYS A 249     -19.670 105.810   5.678  1.00 22.75           C  
ATOM   1541  CG  LYS A 249     -20.334 105.809   7.040  1.00 22.80           C  
ATOM   1542  CD  LYS A 249     -20.919 107.172   7.376  1.00 24.92           C  
ATOM   1543  CE  LYS A 249     -21.524 107.144   8.771  1.00 25.67           C  
ATOM   1544  NZ  LYS A 249     -22.418 108.312   8.993  1.00 28.73           N  
ATOM   1545  N   ASP A 250     -20.970 103.366   4.062  1.00 24.32           N  
ATOM   1546  CA  ASP A 250     -22.019 102.381   3.854  1.00 26.38           C  
ATOM   1547  C   ASP A 250     -21.514 100.949   3.931  1.00 24.31           C  
ATOM   1548  O   ASP A 250     -22.089 100.132   4.653  1.00 25.56           O  
ATOM   1549  CB  ASP A 250     -22.649 102.621   2.472  1.00 31.15           C  
ATOM   1550  CG  ASP A 250     -23.596 103.803   2.488  0.60 32.90           C  
ATOM   1552  OD1 ASP A 250     -24.069 104.179   3.581  0.60 34.88           O  
ATOM   1554  OD2 ASP A 250     -23.852 104.356   1.397  0.60 37.04           O  
ATOM   1556  N   VAL A 251     -20.430 100.628   3.244  1.00 22.98           N  
ATOM   1557  CA  VAL A 251     -19.848  99.292   3.279  1.00 24.55           C  
ATOM   1558  C   VAL A 251     -19.353  98.981   4.692  1.00 23.36           C  
ATOM   1559  O   VAL A 251     -19.496  97.858   5.180  1.00 23.98           O  
ATOM   1560  CB  VAL A 251     -18.720  99.139   2.248  1.00 26.78           C  
ATOM   1561  CG1 VAL A 251     -18.025  97.794   2.354  1.00 28.61           C  
ATOM   1562  CG2 VAL A 251     -19.283  99.298   0.835  1.00 29.76           C  
ATOM   1563  N   MET A 252     -18.772  99.992   5.349  1.00 22.45           N  
ATOM   1564  CA  MET A 252     -18.276  99.797   6.706  1.00 21.07           C  
ATOM   1565  C   MET A 252     -19.410  99.462   7.663  1.00 21.52           C  
ATOM   1566  O   MET A 252     -19.353  98.533   8.470  1.00 20.96           O  
ATOM   1567  CB  MET A 252     -17.546 101.059   7.207  1.00 19.86           C  
ATOM   1568  CG  MET A 252     -17.190 100.902   8.689  1.00 18.20           C  
ATOM   1569  SD  MET A 252     -16.322 102.334   9.331  1.00 19.74           S  
ATOM   1570  CE  MET A 252     -17.604 103.603   9.212  1.00 18.96           C  
ATOM   1571  N   LEU A 253     -20.461 100.288   7.632  1.00 20.88           N  
ATOM   1572  CA  LEU A 253     -21.615 100.059   8.497  1.00 20.36           C  
ATOM   1573  C   LEU A 253     -22.254  98.708   8.225  1.00 23.54           C  
ATOM   1574  O   LEU A 253     -22.681  98.038   9.177  1.00 21.78           O  
ATOM   1575  CB  LEU A 253     -22.617 101.206   8.410  1.00 24.50           C  
ATOM   1576  CG  LEU A 253     -22.193 102.504   9.108  1.00 24.95           C  
ATOM   1577  CD1 LEU A 253     -23.307 103.537   9.007  1.00 27.28           C  
ATOM   1578  CD2 LEU A 253     -21.852 102.257  10.574  1.00 26.80           C  
ATOM   1579  N   ASN A 254     -22.340  98.296   6.954  1.00 24.06           N  
ATOM   1580  CA  ASN A 254     -22.931  96.982   6.673  1.00 25.61           C  
ATOM   1581  C   ASN A 254     -22.122  95.896   7.388  1.00 21.52           C  
ATOM   1582  O   ASN A 254     -22.678  94.992   8.003  1.00 22.00           O  
ATOM   1583  CB  ASN A 254     -22.966  96.687   5.173  1.00 26.98           C  
ATOM   1584  CG  ASN A 254     -24.007  97.478   4.406  1.00 31.40           C  
ATOM   1585  OD1 ASN A 254     -24.938  98.047   4.969  1.00 34.50           O  
ATOM   1586  ND2 ASN A 254     -23.828  97.535   3.090  1.00 33.88           N  
ATOM   1587  N   ALA A 255     -20.789  95.961   7.320  1.00 23.16           N  
ATOM   1588  CA  ALA A 255     -19.939  94.991   8.004  1.00 20.30           C  
ATOM   1589  C   ALA A 255     -20.009  95.103   9.520  1.00 21.50           C  
ATOM   1590  O   ALA A 255     -20.017  94.078  10.210  1.00 20.36           O  
ATOM   1591  CB  ALA A 255     -18.504  95.162   7.518  1.00 20.21           C  
ATOM   1592  N   ALA A 256     -20.107  96.310  10.069  1.00 18.27           N  
ATOM   1593  CA  ALA A 256     -20.187  96.455  11.536  1.00 18.94           C  
ATOM   1594  C   ALA A 256     -21.462  95.841  12.081  1.00 19.67           C  
ATOM   1595  O   ALA A 256     -21.533  95.167  13.120  1.00 18.85           O  
ATOM   1596  CB  ALA A 256     -20.074  97.923  11.930  1.00 19.63           C  
ATOM   1597  N   PHE A 257     -22.575  96.087  11.357  1.00 19.90           N  
ATOM   1598  CA  PHE A 257     -23.863  95.543  11.787  1.00 21.27           C  
ATOM   1599  C   PHE A 257     -23.892  94.028  11.609  1.00 20.32           C  
ATOM   1600  O   PHE A 257     -24.458  93.350  12.478  1.00 19.41           O  
ATOM   1601  CB  PHE A 257     -25.065  96.230  11.116  1.00 22.50           C  
ATOM   1602  CG  PHE A 257     -25.285  97.608  11.689  1.00 23.07           C  
ATOM   1603  CD1 PHE A 257     -25.588  97.755  13.031  1.00 21.64           C  
ATOM   1604  CD2 PHE A 257     -25.186  98.745  10.905  1.00 24.50           C  
ATOM   1605  CE1 PHE A 257     -25.764  99.007  13.590  1.00 24.69           C  
ATOM   1606  CE2 PHE A 257     -25.374 100.002  11.461  1.00 28.29           C  
ATOM   1607  CZ  PHE A 257     -25.668 100.132  12.796  1.00 25.82           C  
ATOM   1608  N   ALA A 258     -23.228  93.506  10.598  1.00 20.98           N  
ATOM   1609  CA  ALA A 258     -23.182  92.061  10.371  1.00 21.46           C  
ATOM   1610  C   ALA A 258     -22.373  91.396  11.482  1.00 21.05           C  
ATOM   1611  O   ALA A 258     -22.712  90.331  11.996  1.00 20.59           O  
ATOM   1612  CB  ALA A 258     -22.635  91.716   9.004  1.00 21.34           C  
ATOM   1613  N   LEU A 259     -21.296  92.087  11.885  1.00 21.19           N  
ATOM   1614  CA  LEU A 259     -20.450  91.604  12.982  1.00 17.81           C  
ATOM   1615  C   LEU A 259     -21.258  91.601  14.270  1.00 16.82           C  
ATOM   1616  O   LEU A 259     -21.238  90.656  15.043  1.00 18.54           O  
ATOM   1617  CB  LEU A 259     -19.214  92.502  13.136  1.00 19.46           C  
ATOM   1618  CG  LEU A 259     -18.376  92.294  14.412  1.00 19.32           C  
ATOM   1619  CD1 LEU A 259     -17.750  90.903  14.389  1.00 18.06           C  
ATOM   1620  CD2 LEU A 259     -17.311  93.366  14.567  1.00 20.14           C  
ATOM   1621  N   ALA A 260     -21.999  92.688  14.525  1.00 18.43           N  
ATOM   1622  CA  ALA A 260     -22.820  92.772  15.718  1.00 16.84           C  
ATOM   1623  C   ALA A 260     -23.881  91.660  15.730  1.00 17.20           C  
ATOM   1624  O   ALA A 260     -24.154  91.116  16.790  1.00 18.25           O  
ATOM   1625  CB  ALA A 260     -23.503  94.120  15.873  1.00 19.69           C  
ATOM   1626  N   ALA A 261     -24.445  91.368  14.555  1.00 19.82           N  
ATOM   1627  CA  ALA A 261     -25.444  90.301  14.481  1.00 22.28           C  
ATOM   1628  C   ALA A 261     -24.818  88.924  14.721  1.00 20.06           C  
ATOM   1629  O   ALA A 261     -25.424  88.111  15.431  1.00 21.36           O  
ATOM   1630  CB  ALA A 261     -26.110  90.305  13.111  1.00 21.25           C  
ATOM   1631  N   ASP A 262     -23.625  88.719  14.186  1.00 20.03           N  
ATOM   1632  CA  ASP A 262     -22.915  87.455  14.436  1.00 17.66           C  
ATOM   1633  C   ASP A 262     -22.658  87.286  15.919  1.00 18.55           C  
ATOM   1634  O   ASP A 262     -22.937  86.274  16.550  1.00 19.37           O  
ATOM   1635  CB  ASP A 262     -21.640  87.440  13.600  1.00 20.42           C  
ATOM   1636  CG  ASP A 262     -20.961  86.087  13.636  1.00 20.28           C  
ATOM   1637  OD1 ASP A 262     -21.688  85.067  13.765  1.00 27.19           O  
ATOM   1638  OD2 ASP A 262     -19.731  86.054  13.486  1.00 23.12           O  
ATOM   1639  N   ILE A 263     -22.116  88.347  16.545  1.00 19.52           N  
ATOM   1640  CA  ILE A 263     -21.851  88.304  17.982  1.00 16.18           C  
ATOM   1641  C   ILE A 263     -23.117  88.021  18.774  1.00 17.67           C  
ATOM   1642  O   ILE A 263     -23.126  87.229  19.716  1.00 17.99           O  
ATOM   1643  CB  ILE A 263     -21.217  89.636  18.464  1.00 16.54           C  
ATOM   1644  CG1 ILE A 263     -19.844  89.765  17.788  1.00 18.46           C  
ATOM   1645  CG2 ILE A 263     -21.149  89.700  19.971  1.00 16.71           C  
ATOM   1646  CD1 ILE A 263     -19.112  91.072  18.078  1.00 18.56           C  
ATOM   1647  N   SER A 264     -24.207  88.697  18.412  1.00 17.39           N  
ATOM   1648  CA  SER A 264     -25.493  88.536  19.077  1.00 16.50           C  
ATOM   1649  C   SER A 264     -26.116  87.152  18.866  1.00 17.93           C  
ATOM   1650  O   SER A 264     -26.975  86.772  19.665  1.00 18.22           O  
ATOM   1651  CB  SER A 264     -26.478  89.587  18.518  1.00 19.53           C  
ATOM   1652  OG  SER A 264     -26.074  90.908  18.886  1.00 19.33           O  
ATOM   1653  N   SER A 265     -25.693  86.395  17.865  1.00 18.92           N  
ATOM   1654  CA  SER A 265     -26.196  85.037  17.653  1.00 21.00           C  
ATOM   1655  C   SER A 265     -25.594  84.042  18.639  1.00 22.62           C  
ATOM   1656  O   SER A 265     -26.109  82.933  18.836  1.00 21.86           O  
ATOM   1657  CB  SER A 265     -25.927  84.581  16.218  1.00 19.40           C  
ATOM   1658  OG  SER A 265     -24.586  84.204  15.989  1.00 21.61           O  
ATOM   1659  N   LYS A 266     -24.492  84.389  19.291  1.00 20.95           N  
ATOM   1660  CA  LYS A 266     -23.815  83.550  20.267  1.00 17.93           C  
ATOM   1661  C   LYS A 266     -24.415  83.677  21.651  1.00 17.81           C  
ATOM   1662  O   LYS A 266     -25.113  84.645  21.970  1.00 18.27           O  
ATOM   1663  CB  LYS A 266     -22.321  83.943  20.329  1.00 15.67           C  
ATOM   1664  CG  LYS A 266     -21.645  84.086  18.978  1.00 18.52           C  
ATOM   1665  CD  LYS A 266     -21.603  82.779  18.195  1.00 19.53           C  
ATOM   1666  CE  LYS A 266     -20.893  82.966  16.868  1.00 21.92           C  
ATOM   1667  NZ  LYS A 266     -20.892  81.698  16.084  1.00 23.40           N  
ATOM   1668  N   SER A 267     -24.161  82.712  22.527  1.00 14.72           N  
ATOM   1669  CA  SER A 267     -24.598  82.789  23.899  1.00 14.41           C  
ATOM   1670  C   SER A 267     -24.188  84.148  24.473  1.00 16.10           C  
ATOM   1671  O   SER A 267     -22.992  84.415  24.511  1.00 16.82           O  
ATOM   1672  CB  SER A 267     -23.830  81.717  24.690  1.00 18.37           C  
ATOM   1673  OG  SER A 267     -23.873  81.947  26.079  1.00 16.58           O  
ATOM   1674  N   PRO A 268     -25.120  84.911  25.012  1.00 15.48           N  
ATOM   1675  CA  PRO A 268     -24.733  86.190  25.635  1.00 13.20           C  
ATOM   1676  C   PRO A 268     -23.952  85.980  26.915  1.00 15.74           C  
ATOM   1677  O   PRO A 268     -23.146  86.840  27.326  1.00 16.04           O  
ATOM   1678  CB  PRO A 268     -26.065  86.897  25.839  1.00 16.15           C  
ATOM   1679  CG  PRO A 268     -27.077  85.784  25.900  1.00 16.59           C  
ATOM   1680  CD  PRO A 268     -26.579  84.715  24.956  1.00 15.92           C  
ATOM   1681  N   VAL A 269     -24.147  84.892  27.638  1.00 14.49           N  
ATOM   1682  CA  VAL A 269     -23.399  84.573  28.850  1.00 13.15           C  
ATOM   1683  C   VAL A 269     -21.923  84.405  28.447  1.00 16.24           C  
ATOM   1684  O   VAL A 269     -21.014  84.949  29.093  1.00 15.59           O  
ATOM   1685  CB  VAL A 269     -23.895  83.279  29.513  1.00 15.43           C  
ATOM   1686  CG1 VAL A 269     -22.957  82.733  30.593  1.00 14.01           C  
ATOM   1687  CG2 VAL A 269     -25.286  83.494  30.125  1.00 16.12           C  
ATOM   1688  N   ALA A 270     -21.687  83.659  27.377  1.00 14.94           N  
ATOM   1689  CA  ALA A 270     -20.327  83.378  26.924  1.00 15.68           C  
ATOM   1690  C   ALA A 270     -19.652  84.639  26.385  1.00 16.59           C  
ATOM   1691  O   ALA A 270     -18.488  84.908  26.720  1.00 15.26           O  
ATOM   1692  CB  ALA A 270     -20.360  82.359  25.784  1.00 14.81           C  
ATOM   1693  N   VAL A 271     -20.370  85.410  25.564  1.00 15.05           N  
ATOM   1694  CA  VAL A 271     -19.766  86.609  24.989  1.00 13.98           C  
ATOM   1695  C   VAL A 271     -19.518  87.678  26.054  1.00 15.04           C  
ATOM   1696  O   VAL A 271     -18.400  88.230  26.086  1.00 14.37           O  
ATOM   1697  CB  VAL A 271     -20.664  87.207  23.888  1.00 15.93           C  
ATOM   1698  CG1 VAL A 271     -20.225  88.604  23.465  1.00 17.47           C  
ATOM   1699  CG2 VAL A 271     -20.704  86.324  22.639  1.00 17.01           C  
ATOM   1700  N   GLN A 272     -20.518  87.941  26.884  1.00 15.80           N  
ATOM   1701  CA  GLN A 272     -20.339  89.034  27.874  1.00 12.55           C  
ATOM   1702  C   GLN A 272     -19.375  88.633  28.970  1.00 16.24           C  
ATOM   1703  O   GLN A 272     -18.556  89.469  29.418  1.00 13.93           O  
ATOM   1704  CB  GLN A 272     -21.715  89.492  28.378  1.00 12.83           C  
ATOM   1705  CG  GLN A 272     -22.453  90.121  27.192  1.00 14.02           C  
ATOM   1706  CD  GLN A 272     -23.869  90.516  27.584  1.00 16.14           C  
ATOM   1707  OE1 GLN A 272     -24.139  90.918  28.703  1.00 16.93           O  
ATOM   1708  NE2 GLN A 272     -24.797  90.262  26.664  1.00 15.80           N  
ATOM   1709  N   GLY A 273     -19.348  87.360  29.339  1.00 14.59           N  
ATOM   1710  CA  GLY A 273     -18.367  86.861  30.312  1.00 14.23           C  
ATOM   1711  C   GLY A 273     -16.968  86.946  29.666  1.00 14.43           C  
ATOM   1712  O   GLY A 273     -16.013  87.189  30.416  1.00 13.49           O  
ATOM   1713  N   SER A 274     -16.855  86.722  28.371  1.00 13.48           N  
ATOM   1714  CA  SER A 274     -15.570  86.856  27.671  1.00 13.00           C  
ATOM   1715  C   SER A 274     -15.085  88.315  27.748  1.00 13.71           C  
ATOM   1716  O   SER A 274     -13.912  88.528  28.081  1.00 13.43           O  
ATOM   1717  CB  SER A 274     -15.652  86.410  26.220  1.00 14.53           C  
ATOM   1718  OG  SER A 274     -15.856  84.987  26.124  1.00 14.21           O  
ATOM   1719  N   LYS A 275     -15.960  89.293  27.447  1.00 12.99           N  
ATOM   1720  CA  LYS A 275     -15.515  90.684  27.559  1.00 13.02           C  
ATOM   1721  C   LYS A 275     -15.099  91.013  28.987  1.00 12.68           C  
ATOM   1722  O   LYS A 275     -13.999  91.593  29.195  1.00 13.74           O  
ATOM   1723  CB  LYS A 275     -16.663  91.651  27.169  1.00 13.06           C  
ATOM   1724  CG  LYS A 275     -16.207  93.112  27.363  1.00 13.88           C  
ATOM   1725  CD  LYS A 275     -17.121  94.090  26.595  1.00 13.42           C  
ATOM   1726  CE  LYS A 275     -16.786  95.527  27.056  1.00 14.30           C  
ATOM   1727  NZ  LYS A 275     -17.641  96.517  26.304  1.00 14.32           N  
ATOM   1728  N   ILE A 276     -15.923  90.646  29.972  1.00 13.25           N  
ATOM   1729  CA  ILE A 276     -15.596  90.949  31.362  1.00 13.30           C  
ATOM   1730  C   ILE A 276     -14.232  90.388  31.733  1.00 14.83           C  
ATOM   1731  O   ILE A 276     -13.412  91.048  32.391  1.00 14.05           O  
ATOM   1732  CB  ILE A 276     -16.709  90.435  32.299  1.00 13.21           C  
ATOM   1733  CG1 ILE A 276     -17.889  91.408  32.089  1.00 13.31           C  
ATOM   1734  CG2 ILE A 276     -16.270  90.383  33.742  1.00 13.89           C  
ATOM   1735  CD1 ILE A 276     -19.225  90.820  32.525  1.00 14.18           C  
ATOM   1736  N   ASN A 277     -13.971  89.141  31.336  1.00 12.47           N  
ATOM   1737  CA  ASN A 277     -12.674  88.558  31.732  1.00 13.56           C  
ATOM   1738  C   ASN A 277     -11.498  88.996  30.885  1.00 12.87           C  
ATOM   1739  O   ASN A 277     -10.368  89.020  31.452  1.00 13.32           O  
ATOM   1740  CB  ASN A 277     -12.817  87.025  31.746  1.00 12.93           C  
ATOM   1741  CG  ASN A 277     -13.496  86.657  33.037  1.00 12.59           C  
ATOM   1742  OD1 ASN A 277     -12.893  86.624  34.107  1.00 14.57           O  
ATOM   1743  ND2 ASN A 277     -14.832  86.401  33.025  1.00 12.57           N  
ATOM   1744  N   LEU A 278     -11.702  89.392  29.640  1.00 13.48           N  
ATOM   1745  CA  LEU A 278     -10.632  90.009  28.854  1.00 12.31           C  
ATOM   1746  C   LEU A 278     -10.199  91.317  29.533  1.00 11.97           C  
ATOM   1747  O   LEU A 278      -8.993  91.609  29.603  1.00 12.71           O  
ATOM   1748  CB  LEU A 278     -11.091  90.303  27.425  1.00 12.05           C  
ATOM   1749  CG  LEU A 278     -11.161  89.043  26.523  1.00 13.21           C  
ATOM   1750  CD1 LEU A 278     -11.989  89.293  25.264  1.00 12.86           C  
ATOM   1751  CD2 LEU A 278      -9.716  88.621  26.208  1.00 14.38           C  
ATOM   1752  N   ILE A 279     -11.171  92.111  29.960  1.00 14.12           N  
ATOM   1753  CA  ILE A 279     -10.829  93.376  30.644  1.00 12.51           C  
ATOM   1754  C   ILE A 279     -10.151  93.090  31.965  1.00 13.61           C  
ATOM   1755  O   ILE A 279      -9.124  93.713  32.293  1.00 14.76           O  
ATOM   1756  CB  ILE A 279     -12.119  94.192  30.849  1.00 16.24           C  
ATOM   1757  CG1 ILE A 279     -12.590  94.707  29.477  1.00 15.36           C  
ATOM   1758  CG2 ILE A 279     -11.871  95.356  31.813  1.00 15.54           C  
ATOM   1759  CD1 ILE A 279     -14.052  95.164  29.566  1.00 18.03           C  
ATOM   1760  N   TYR A 280     -10.659  92.183  32.787  1.00 12.53           N  
ATOM   1761  CA  TYR A 280     -10.000  91.871  34.049  1.00 12.99           C  
ATOM   1762  C   TYR A 280      -8.559  91.404  33.779  1.00 14.46           C  
ATOM   1763  O   TYR A 280      -7.621  91.853  34.420  1.00 13.85           O  
ATOM   1764  CB  TYR A 280     -10.782  90.769  34.761  1.00 12.19           C  
ATOM   1765  CG  TYR A 280     -10.293  90.563  36.169  1.00 15.85           C  
ATOM   1766  CD1 TYR A 280      -9.173  89.769  36.431  1.00 15.25           C  
ATOM   1767  CD2 TYR A 280     -10.947  91.211  37.214  1.00 18.25           C  
ATOM   1768  CE1 TYR A 280      -8.744  89.610  37.743  1.00 18.00           C  
ATOM   1769  CE2 TYR A 280     -10.520  91.027  38.515  1.00 21.44           C  
ATOM   1770  CZ  TYR A 280      -9.410  90.264  38.764  1.00 19.78           C  
ATOM   1771  OH  TYR A 280      -9.022  90.079  40.076  1.00 32.70           O  
ATOM   1772  N   SER A 281      -8.395  90.539  32.770  1.00 13.38           N  
ATOM   1773  CA  SER A 281      -7.078  89.968  32.503  1.00 13.79           C  
ATOM   1774  C   SER A 281      -6.091  90.991  32.015  1.00 15.12           C  
ATOM   1775  O   SER A 281      -4.876  90.782  32.165  1.00 14.52           O  
ATOM   1776  CB  SER A 281      -7.226  88.839  31.470  1.00 14.94           C  
ATOM   1777  OG  SER A 281      -8.009  87.777  32.014  1.00 14.23           O  
ATOM   1778  N   ARG A 282      -6.529  92.070  31.357  1.00 14.87           N  
ATOM   1779  CA  ARG A 282      -5.606  93.122  30.918  1.00 14.90           C  
ATOM   1780  C   ARG A 282      -4.926  93.743  32.127  1.00 15.25           C  
ATOM   1781  O   ARG A 282      -3.745  94.114  32.005  1.00 17.15           O  
ATOM   1782  CB  ARG A 282      -6.426  94.224  30.199  1.00 16.13           C  
ATOM   1783  CG  ARG A 282      -5.647  95.386  29.602  1.00 14.77           C  
ATOM   1784  CD  ARG A 282      -6.587  96.549  29.229  1.00 14.42           C  
ATOM   1785  NE  ARG A 282      -7.295  97.038  30.424  1.00 12.75           N  
ATOM   1786  CZ  ARG A 282      -8.479  97.694  30.339  1.00 12.28           C  
ATOM   1787  NH1 ARG A 282      -8.964  98.011  29.146  1.00 16.11           N  
ATOM   1788  NH2 ARG A 282      -9.043  97.964  31.500  1.00 14.52           N  
ATOM   1789  N   ASP A 283      -5.678  93.905  33.211  1.00 14.71           N  
ATOM   1790  CA  ASP A 283      -5.181  94.724  34.323  1.00 20.87           C  
ATOM   1791  C   ASP A 283      -4.613  93.965  35.496  1.00 19.47           C  
ATOM   1792  O   ASP A 283      -4.264  94.589  36.513  1.00 20.80           O  
ATOM   1793  CB  ASP A 283      -6.340  95.609  34.798  1.00 20.73           C  
ATOM   1794  CG  ASP A 283      -6.802  96.713  33.854  1.00 22.20           C  
ATOM   1795  OD1 ASP A 283      -6.030  97.136  33.000  1.00 22.35           O  
ATOM   1796  OD2 ASP A 283      -8.010  97.029  33.948  1.00 29.50           O  
ATOM   1797  N   HIS A 284      -4.600  92.625  35.433  1.00 16.22           N  
ATOM   1798  CA  HIS A 284      -4.124  91.824  36.557  1.00 14.56           C  
ATOM   1799  C   HIS A 284      -3.109  90.791  36.061  1.00 13.05           C  
ATOM   1800  O   HIS A 284      -3.050  90.599  34.839  1.00 15.08           O  
ATOM   1801  CB  HIS A 284      -5.286  91.141  37.271  1.00 16.91           C  
ATOM   1802  CG  HIS A 284      -6.311  92.055  37.865  1.00 17.82           C  
ATOM   1803  ND1 HIS A 284      -7.266  92.652  37.056  1.00 17.90           N  
ATOM   1804  CD2 HIS A 284      -6.485  92.537  39.113  1.00 22.57           C  
ATOM   1805  CE1 HIS A 284      -8.031  93.428  37.820  1.00 22.21           C  
ATOM   1806  NE2 HIS A 284      -7.588  93.362  39.060  1.00 22.98           N  
ATOM   1807  N   SER A 285      -2.392  90.124  36.956  1.00 14.53           N  
ATOM   1808  CA  SER A 285      -1.441  89.114  36.484  1.00 13.24           C  
ATOM   1809  C   SER A 285      -2.242  87.952  35.872  1.00 14.21           C  
ATOM   1810  O   SER A 285      -3.427  87.737  36.184  1.00 14.58           O  
ATOM   1811  CB  SER A 285      -0.585  88.588  37.635  1.00 12.38           C  
ATOM   1812  OG  SER A 285      -1.351  87.841  38.555  1.00 15.13           O  
ATOM   1813  N   VAL A 286      -1.498  87.129  35.140  1.00 13.06           N  
ATOM   1814  CA  VAL A 286      -2.159  85.932  34.565  1.00 13.73           C  
ATOM   1815  C   VAL A 286      -2.662  85.080  35.709  1.00 13.24           C  
ATOM   1816  O   VAL A 286      -3.824  84.609  35.621  1.00 13.57           O  
ATOM   1817  CB  VAL A 286      -1.199  85.171  33.649  1.00 14.18           C  
ATOM   1818  CG1 VAL A 286      -1.766  83.794  33.245  1.00 13.95           C  
ATOM   1819  CG2 VAL A 286      -0.952  85.990  32.388  1.00 13.03           C  
ATOM   1820  N   ASP A 287      -1.898  84.819  36.761  1.00 12.08           N  
ATOM   1821  CA  ASP A 287      -2.368  83.991  37.863  1.00 14.43           C  
ATOM   1822  C   ASP A 287      -3.576  84.581  38.582  1.00 15.92           C  
ATOM   1823  O   ASP A 287      -4.533  83.828  38.832  1.00 15.57           O  
ATOM   1824  CB  ASP A 287      -1.284  83.637  38.865  1.00 16.36           C  
ATOM   1825  CG  ASP A 287      -0.218  82.699  38.311  1.00 18.38           C  
ATOM   1826  OD1 ASP A 287      -0.455  81.948  37.344  1.00 16.93           O  
ATOM   1827  OD2 ASP A 287       0.890  82.777  38.873  1.00 18.68           O  
ATOM   1828  N   GLU A 288      -3.610  85.878  38.844  1.00 14.37           N  
ATOM   1829  CA  GLU A 288      -4.794  86.479  39.464  1.00 12.04           C  
ATOM   1830  C   GLU A 288      -5.986  86.346  38.518  1.00 11.13           C  
ATOM   1831  O   GLU A 288      -7.098  86.178  39.022  1.00 13.78           O  
ATOM   1832  CB  GLU A 288      -4.529  87.981  39.683  1.00 16.33           C  
ATOM   1833  CG  GLU A 288      -3.442  88.219  40.719  1.00 22.52           C  
ATOM   1834  CD  GLU A 288      -2.953  89.643  40.740  1.00 27.75           C  
ATOM   1835  OE1 GLU A 288      -3.011  90.488  39.790  1.00 24.13           O  
ATOM   1836  OE2 GLU A 288      -2.453  90.067  41.816  1.00 27.77           O  
ATOM   1837  N   SER A 289      -5.735  86.551  37.226  1.00 12.38           N  
ATOM   1838  CA  SER A 289      -6.845  86.532  36.258  1.00 11.81           C  
ATOM   1839  C   SER A 289      -7.394  85.115  36.111  1.00 13.86           C  
ATOM   1840  O   SER A 289      -8.608  84.967  35.910  1.00 13.09           O  
ATOM   1841  CB  SER A 289      -6.391  87.097  34.912  1.00 13.37           C  
ATOM   1842  OG  SER A 289      -5.866  88.422  35.096  1.00 16.07           O  
ATOM   1843  N   LEU A 290      -6.545  84.093  36.174  1.00 13.01           N  
ATOM   1844  CA  LEU A 290      -7.026  82.719  36.116  1.00 12.15           C  
ATOM   1845  C   LEU A 290      -7.870  82.418  37.336  1.00 13.11           C  
ATOM   1846  O   LEU A 290      -8.923  81.756  37.269  1.00 13.17           O  
ATOM   1847  CB  LEU A 290      -5.839  81.724  36.035  1.00 11.46           C  
ATOM   1848  CG  LEU A 290      -5.119  81.737  34.689  1.00 12.69           C  
ATOM   1849  CD1 LEU A 290      -3.807  80.968  34.837  1.00 14.51           C  
ATOM   1850  CD2 LEU A 290      -5.962  81.097  33.584  1.00 12.85           C  
ATOM   1851  N   ASP A 291      -7.473  82.874  38.520  1.00 11.91           N  
ATOM   1852  CA  ASP A 291      -8.216  82.663  39.760  1.00 14.08           C  
ATOM   1853  C   ASP A 291      -9.589  83.321  39.637  1.00 14.68           C  
ATOM   1854  O   ASP A 291     -10.631  82.731  39.977  1.00 15.55           O  
ATOM   1855  CB  ASP A 291      -7.416  83.220  40.935  1.00 14.92           C  
ATOM   1856  CG  ASP A 291      -8.156  83.092  42.245  1.00 20.97           C  
ATOM   1857  OD1 ASP A 291      -9.009  83.982  42.454  1.00 22.37           O  
ATOM   1858  OD2 ASP A 291      -7.943  82.171  43.057  1.00 26.39           O  
ATOM   1859  N   TYR A 292      -9.605  84.569  39.140  1.00 13.09           N  
ATOM   1860  CA  TYR A 292     -10.884  85.254  38.931  1.00 12.63           C  
ATOM   1861  C   TYR A 292     -11.759  84.480  37.948  1.00 14.13           C  
ATOM   1862  O   TYR A 292     -12.981  84.406  38.125  1.00 14.73           O  
ATOM   1863  CB  TYR A 292     -10.639  86.642  38.309  1.00 14.24           C  
ATOM   1864  CG  TYR A 292     -11.828  87.579  38.415  1.00 14.82           C  
ATOM   1865  CD1 TYR A 292     -12.025  88.233  39.619  1.00 15.69           C  
ATOM   1866  CD2 TYR A 292     -12.655  87.820  37.335  1.00 13.13           C  
ATOM   1867  CE1 TYR A 292     -13.110  89.109  39.758  1.00 18.18           C  
ATOM   1868  CE2 TYR A 292     -13.734  88.701  37.458  1.00 15.63           C  
ATOM   1869  CZ  TYR A 292     -13.922  89.330  38.663  1.00 16.01           C  
ATOM   1870  OH  TYR A 292     -14.945  90.261  38.841  1.00 20.11           O  
ATOM   1871  N   MET A 293     -11.170  84.016  36.850  1.00 11.74           N  
ATOM   1872  CA  MET A 293     -11.913  83.257  35.839  1.00 11.71           C  
ATOM   1873  C   MET A 293     -12.550  81.990  36.404  1.00 13.04           C  
ATOM   1874  O   MET A 293     -13.666  81.605  36.012  1.00 12.58           O  
ATOM   1875  CB  MET A 293     -10.958  82.903  34.690  1.00 13.95           C  
ATOM   1876  CG  MET A 293     -11.628  82.193  33.513  0.60 17.11           C  
ATOM   1878  SD  MET A 293     -12.509  83.561  32.728  0.60 15.05           S  
ATOM   1880  CE  MET A 293     -14.056  82.753  32.308  0.60 15.24           C  
ATOM   1882  N   ALA A 294     -11.863  81.311  37.332  1.00 13.86           N  
ATOM   1883  CA  ALA A 294     -12.474  80.122  37.938  1.00 13.54           C  
ATOM   1884  C   ALA A 294     -13.651  80.496  38.833  1.00 14.03           C  
ATOM   1885  O   ALA A 294     -14.699  79.844  38.878  1.00 14.26           O  
ATOM   1886  CB  ALA A 294     -11.396  79.380  38.743  1.00 13.49           C  
ATOM   1887  N   THR A 295     -13.565  81.624  39.549  1.00 13.25           N  
ATOM   1888  CA  THR A 295     -14.628  82.107  40.438  1.00 12.78           C  
ATOM   1889  C   THR A 295     -15.783  82.634  39.585  1.00 13.61           C  
ATOM   1890  O   THR A 295     -16.949  82.507  39.992  1.00 13.61           O  
ATOM   1891  CB  THR A 295     -14.044  83.179  41.377  1.00 15.76           C  
ATOM   1892  OG1 THR A 295     -13.098  82.545  42.270  1.00 18.39           O  
ATOM   1893  CG2 THR A 295     -15.111  83.753  42.305  1.00 19.17           C  
ATOM   1894  N   TRP A 296     -15.518  83.140  38.404  1.00 12.66           N  
ATOM   1895  CA  TRP A 296     -16.534  83.584  37.465  1.00 14.19           C  
ATOM   1896  C   TRP A 296     -17.262  82.387  36.847  1.00 14.57           C  
ATOM   1897  O   TRP A 296     -18.483  82.316  36.952  1.00 14.06           O  
ATOM   1898  CB  TRP A 296     -15.881  84.406  36.339  1.00 14.40           C  
ATOM   1899  CG  TRP A 296     -16.853  84.883  35.300  1.00 12.37           C  
ATOM   1900  CD1 TRP A 296     -17.172  84.274  34.125  1.00 12.71           C  
ATOM   1901  CD2 TRP A 296     -17.669  86.068  35.363  1.00 12.38           C  
ATOM   1902  NE1 TRP A 296     -18.122  84.992  33.436  1.00 13.94           N  
ATOM   1903  CE2 TRP A 296     -18.420  86.106  34.175  1.00 12.75           C  
ATOM   1904  CE3 TRP A 296     -17.777  87.100  36.302  1.00 16.96           C  
ATOM   1905  CZ2 TRP A 296     -19.352  87.125  33.911  1.00 13.98           C  
ATOM   1906  CZ3 TRP A 296     -18.708  88.103  36.039  1.00 16.85           C  
ATOM   1907  CH2 TRP A 296     -19.469  88.086  34.878  1.00 15.40           C  
ATOM   1908  N   ASN A 297     -16.541  81.432  36.249  1.00 13.02           N  
ATOM   1909  CA  ASN A 297     -17.204  80.324  35.540  1.00 11.34           C  
ATOM   1910  C   ASN A 297     -17.766  79.297  36.481  1.00 12.44           C  
ATOM   1911  O   ASN A 297     -18.625  78.518  35.997  1.00 13.38           O  
ATOM   1912  CB  ASN A 297     -16.261  79.715  34.492  1.00 11.95           C  
ATOM   1913  CG  ASN A 297     -16.515  80.187  33.077  1.00 15.09           C  
ATOM   1914  OD1 ASN A 297     -17.273  81.135  32.851  1.00 13.56           O  
ATOM   1915  ND2 ASN A 297     -15.834  79.540  32.134  1.00 13.88           N  
ATOM   1916  N   MET A 298     -17.491  79.310  37.767  1.00 12.64           N  
ATOM   1917  CA  MET A 298     -18.134  78.359  38.676  1.00 14.91           C  
ATOM   1918  C   MET A 298     -19.640  78.666  38.737  1.00 16.93           C  
ATOM   1919  O   MET A 298     -20.416  77.742  39.039  1.00 15.99           O  
ATOM   1920  CB  MET A 298     -17.531  78.314  40.060  1.00 13.66           C  
ATOM   1921  CG  MET A 298     -17.818  79.565  40.890  1.00 14.42           C  
ATOM   1922  SD  MET A 298     -16.943  79.419  42.459  1.00 15.12           S  
ATOM   1923  CE  MET A 298     -17.414  80.984  43.203  1.00 13.39           C  
ATOM   1924  N   SER A 299     -20.062  79.885  38.405  1.00 13.97           N  
ATOM   1925  CA  SER A 299     -21.502  80.117  38.247  1.00 14.76           C  
ATOM   1926  C   SER A 299     -21.860  80.083  36.766  1.00 14.02           C  
ATOM   1927  O   SER A 299     -22.875  79.477  36.355  1.00 15.45           O  
ATOM   1928  CB  SER A 299     -22.019  81.487  38.680  1.00 18.18           C  
ATOM   1929  OG  SER A 299     -21.197  82.500  38.222  0.50 16.40           O  
ATOM   1931  N   MET A 300     -21.111  80.697  35.847  1.00 14.02           N  
ATOM   1932  CA  MET A 300     -21.522  80.929  34.481  1.00 13.97           C  
ATOM   1933  C   MET A 300     -21.532  79.696  33.596  1.00 14.91           C  
ATOM   1934  O   MET A 300     -22.222  79.690  32.570  1.00 15.73           O  
ATOM   1935  CB  MET A 300     -20.779  82.100  33.805  1.00 13.58           C  
ATOM   1936  CG  MET A 300     -20.960  83.425  34.551  0.60 14.74           C  
ATOM   1938  SD  MET A 300     -22.684  83.978  34.449  0.60 13.12           S  
ATOM   1940  CE  MET A 300     -22.707  85.219  35.736  0.60 14.19           C  
ATOM   1942  N   LEU A 301     -20.866  78.624  34.012  1.00 14.14           N  
ATOM   1943  CA  LEU A 301     -20.941  77.359  33.298  1.00 13.91           C  
ATOM   1944  C   LEU A 301     -22.268  76.673  33.625  1.00 16.33           C  
ATOM   1945  O   LEU A 301     -22.626  75.710  32.920  1.00 16.58           O  
ATOM   1946  CB  LEU A 301     -19.792  76.414  33.649  1.00 15.47           C  
ATOM   1947  CG  LEU A 301     -18.386  76.859  33.210  1.00 14.25           C  
ATOM   1948  CD1 LEU A 301     -17.372  75.928  33.869  1.00 17.43           C  
ATOM   1949  CD2 LEU A 301     -18.262  76.866  31.700  1.00 14.16           C  
ATOM   1950  N   GLN A 302     -22.969  77.128  34.654  1.00 15.72           N  
ATOM   1951  CA  GLN A 302     -24.273  76.521  34.986  1.00 15.48           C  
ATOM   1952  C   GLN A 302     -25.354  77.210  34.162  1.00 15.06           C  
ATOM   1953  O   GLN A 302     -26.163  78.000  34.679  1.00 17.46           O  
ATOM   1954  CB  GLN A 302     -24.500  76.629  36.483  1.00 14.43           C  
ATOM   1955  CG  GLN A 302     -23.468  75.958  37.375  1.00 15.14           C  
ATOM   1956  CD  GLN A 302     -23.845  75.877  38.821  1.00 17.16           C  
ATOM   1957  OE1 GLN A 302     -24.902  75.314  39.164  1.00 17.53           O  
ATOM   1958  NE2 GLN A 302     -23.046  76.403  39.757  1.00 16.28           N  
ATOM   1959  N   THR A 303     -25.345  76.970  32.860  1.00 15.96           N  
ATOM   1960  CA  THR A 303     -26.274  77.607  31.941  1.00 16.65           C  
ATOM   1961  C   THR A 303     -26.751  76.588  30.907  1.00 18.03           C  
ATOM   1962  O   THR A 303     -26.020  75.718  30.426  1.00 18.40           O  
ATOM   1963  CB  THR A 303     -25.628  78.813  31.243  1.00 19.42           C  
ATOM   1964  OG1 THR A 303     -26.499  79.375  30.243  1.00 17.58           O  
ATOM   1965  CG2 THR A 303     -24.345  78.400  30.526  1.00 19.11           C  
ATOM   1966  N   GLN A 304     -27.997  76.812  30.481  1.00 19.28           N  
ATOM   1967  CA  GLN A 304     -28.555  76.078  29.360  1.00 20.03           C  
ATOM   1968  C   GLN A 304     -27.897  76.469  28.051  1.00 20.17           C  
ATOM   1969  O   GLN A 304     -28.089  75.745  27.077  1.00 20.61           O  
ATOM   1970  CB  GLN A 304     -30.070  76.341  29.235  1.00 23.00           C  
ATOM   1971  CG  GLN A 304     -30.872  75.890  30.448  1.00 29.86           C  
ATOM   1972  CD  GLN A 304     -30.740  74.399  30.694  1.00 32.96           C  
ATOM   1973  OE1 GLN A 304     -31.097  73.604  29.828  1.00 35.69           O  
ATOM   1974  NE2 GLN A 304     -30.210  74.023  31.853  1.00 38.34           N  
ATOM   1975  N   ASP A 305     -27.100  77.552  27.981  1.00 17.66           N  
ATOM   1976  CA  ASP A 305     -26.485  77.914  26.714  1.00 18.73           C  
ATOM   1977  C   ASP A 305     -25.494  76.863  26.220  1.00 16.83           C  
ATOM   1978  O   ASP A 305     -25.246  76.803  25.021  1.00 19.07           O  
ATOM   1979  CB  ASP A 305     -25.791  79.289  26.867  1.00 18.75           C  
ATOM   1980  CG  ASP A 305     -26.759  80.416  27.140  1.00 21.83           C  
ATOM   1981  OD1 ASP A 305     -27.923  80.186  27.520  1.00 20.38           O  
ATOM   1982  OD2 ASP A 305     -26.383  81.604  26.992  1.00 17.81           O  
ATOM   1983  N   ILE A 306     -24.889  76.104  27.126  1.00 18.43           N  
ATOM   1984  CA  ILE A 306     -23.943  75.055  26.695  1.00 18.11           C  
ATOM   1985  C   ILE A 306     -24.693  73.897  26.030  1.00 19.49           C  
ATOM   1986  O   ILE A 306     -24.356  73.583  24.883  1.00 20.99           O  
ATOM   1987  CB  ILE A 306     -23.098  74.586  27.884  1.00 19.76           C  
ATOM   1988  CG1 ILE A 306     -22.214  75.751  28.363  1.00 21.10           C  
ATOM   1989  CG2 ILE A 306     -22.224  73.390  27.524  1.00 17.91           C  
ATOM   1990  CD1 ILE A 306     -21.490  75.432  29.662  1.00 24.34           C  
ATOM   1991  N   ILE A 307     -25.709  73.383  26.716  1.00 23.37           N  
ATOM   1992  CA  ILE A 307     -26.530  72.303  26.144  1.00 27.59           C  
ATOM   1993  C   ILE A 307     -27.050  72.706  24.780  1.00 25.43           C  
ATOM   1994  O   ILE A 307     -26.973  71.985  23.779  1.00 26.20           O  
ATOM   1995  CB  ILE A 307     -27.667  71.978  27.143  1.00 33.95           C  
ATOM   1996  CG1 ILE A 307     -27.259  70.803  28.044  1.00 39.91           C  
ATOM   1997  CG2 ILE A 307     -29.008  71.696  26.504  1.00 37.58           C  
ATOM   1998  CD1 ILE A 307     -27.825  70.892  29.455  1.00 42.67           C  
ATOM   1999  N   LYS A 308     -27.632  73.910  24.687  1.00 23.16           N  
ATOM   2000  CA  LYS A 308     -28.137  74.420  23.422  1.00 22.21           C  
ATOM   2001  C   LYS A 308     -27.067  74.525  22.346  1.00 23.52           C  
ATOM   2002  O   LYS A 308     -27.295  74.158  21.190  1.00 25.49           O  
ATOM   2003  CB  LYS A 308     -28.819  75.776  23.600  1.00 21.80           C  
ATOM   2004  CG  LYS A 308     -29.942  75.801  24.633  1.00 21.32           C  
ATOM   2005  CD  LYS A 308     -30.624  77.176  24.583  1.00 20.78           C  
ATOM   2006  CE  LYS A 308     -31.774  77.240  25.568  1.00 23.09           C  
ATOM   2007  NZ  LYS A 308     -32.350  78.606  25.663  1.00 23.38           N  
ATOM   2008  N   SER A 309     -25.877  75.039  22.690  1.00 21.35           N  
ATOM   2009  CA  SER A 309     -24.831  75.223  21.690  1.00 22.69           C  
ATOM   2010  C   SER A 309     -24.249  73.897  21.218  1.00 23.53           C  
ATOM   2011  O   SER A 309     -23.877  73.767  20.057  1.00 26.34           O  
ATOM   2012  CB  SER A 309     -23.709  76.117  22.238  1.00 19.73           C  
ATOM   2013  OG  SER A 309     -24.235  77.381  22.608  1.00 20.68           O  
ATOM   2014  N   VAL A 310     -24.078  72.964  22.141  1.00 24.50           N  
ATOM   2015  CA  VAL A 310     -23.552  71.637  21.848  1.00 30.07           C  
ATOM   2016  C   VAL A 310     -24.541  70.822  21.023  1.00 31.19           C  
ATOM   2017  O   VAL A 310     -24.155  70.240  20.005  1.00 30.00           O  
ATOM   2018  CB  VAL A 310     -23.227  70.958  23.189  1.00 29.41           C  
ATOM   2019  CG1 VAL A 310     -23.100  69.454  23.077  1.00 32.88           C  
ATOM   2020  CG2 VAL A 310     -21.946  71.601  23.719  1.00 30.83           C  
ATOM   2021  N   GLN A 311     -25.816  70.870  21.404  1.00 32.01           N  
ATOM   2022  CA  GLN A 311     -26.840  70.178  20.616  1.00 34.58           C  
ATOM   2023  C   GLN A 311     -26.821  70.688  19.182  1.00 36.15           C  
ATOM   2024  O   GLN A 311     -26.833  69.892  18.236  1.00 35.94           O  
ATOM   2025  CB  GLN A 311     -28.221  70.352  21.236  1.00 37.64           C  
ATOM   2026  CG  GLN A 311     -29.274  69.405  20.690  1.00 45.23           C  
ATOM   2027  CD  GLN A 311     -30.648  70.012  20.525  1.00 49.42           C  
ATOM   2028  OE1 GLN A 311     -31.025  70.928  21.268  1.00 51.35           O  
ATOM   2029  NE2 GLN A 311     -31.419  69.546  19.545  1.00 51.02           N  
ATOM   2030  N   ALA A 312     -26.765  72.006  18.979  1.00 35.04           N  
ATOM   2031  CA  ALA A 312     -26.728  72.579  17.639  1.00 36.03           C  
ATOM   2032  C   ALA A 312     -25.516  72.106  16.847  1.00 37.80           C  
ATOM   2033  O   ALA A 312     -25.633  71.744  15.670  1.00 35.40           O  
ATOM   2034  CB  ALA A 312     -26.758  74.100  17.704  1.00 35.80           C  
ATOM   2035  N   ALA A 313     -24.351  72.045  17.490  1.00 38.06           N  
ATOM   2036  CA  ALA A 313     -23.137  71.528  16.877  1.00 38.50           C  
ATOM   2037  C   ALA A 313     -23.298  70.076  16.430  1.00 40.07           C  
ATOM   2038  O   ALA A 313     -22.869  69.706  15.336  1.00 40.22           O  
ATOM   2039  CB  ALA A 313     -21.967  71.624  17.846  1.00 37.23           C  
ATOM   2040  N   MET A 314     -23.921  69.250  17.264  1.00 38.98           N  
ATOM   2041  CA  MET A 314     -24.154  67.850  16.948  1.00 38.74           C  
ATOM   2042  C   MET A 314     -25.060  67.686  15.735  1.00 39.49           C  
ATOM   2043  O   MET A 314     -24.827  66.791  14.916  1.00 36.83           O  
ATOM   2044  CB  MET A 314     -24.759  67.136  18.164  1.00 38.22           C  
ATOM   2045  CG  MET A 314     -23.722  66.985  19.273  1.00 37.24           C  
ATOM   2046  SD  MET A 314     -24.355  66.199  20.748  1.00 37.06           S  
ATOM   2047  CE  MET A 314     -24.932  64.632  20.097  1.00 35.95           C  
ATOM   2048  N   GLU A 315     -26.021  68.586  15.557  1.00 38.06           N  
ATOM   2049  CA  GLU A 315     -26.920  68.558  14.416  1.00 40.60           C  
ATOM   2050  C   GLU A 315     -26.431  69.397  13.243  1.00 40.62           C  
ATOM   2051  O   GLU A 315     -27.138  69.575  12.250  1.00 37.68           O  
ATOM   2052  CB  GLU A 315     -28.306  69.062  14.836  1.00 43.98           C  
ATOM   2053  CG  GLU A 315     -29.083  68.091  15.709  1.00 48.65           C  
ATOM   2054  CD  GLU A 315     -30.361  68.722  16.236  1.00 51.41           C  
ATOM   2055  OE1 GLU A 315     -31.347  68.767  15.472  1.00 54.02           O  
ATOM   2056  OE2 GLU A 315     -30.362  69.185  17.393  1.00 54.10           O  
ATOM   2057  N   LYS A 316     -25.252  69.997  13.371  1.00 41.69           N  
ATOM   2058  CA  LYS A 316     -24.664  70.824  12.323  1.00 43.48           C  
ATOM   2059  C   LYS A 316     -25.516  72.044  12.015  1.00 43.55           C  
ATOM   2060  O   LYS A 316     -25.672  72.463  10.866  1.00 45.22           O  
ATOM   2061  CB  LYS A 316     -24.404  69.963  11.088  1.00 43.80           C  
ATOM   2062  CG  LYS A 316     -23.588  70.558   9.968  0.65 45.96           C  
ATOM   2064  CD  LYS A 316     -22.098  70.572  10.255  0.65 47.76           C  
ATOM   2066  CE  LYS A 316     -21.297  70.566   8.960  0.65 47.77           C  
ATOM   2068  NZ  LYS A 316     -21.741  71.633   8.023  0.65 49.93           N  
ATOM   2070  N   LYS A 317     -26.054  72.666  13.062  1.00 42.67           N  
ATOM   2071  CA  LYS A 317     -26.872  73.867  12.917  1.00 40.83           C  
ATOM   2072  C   LYS A 317     -26.064  75.067  13.405  1.00 41.07           C  
ATOM   2073  O   LYS A 317     -25.205  74.906  14.276  1.00 39.42           O  
ATOM   2074  CB  LYS A 317     -28.177  73.743  13.692  1.00 43.00           C  
ATOM   2075  CG  LYS A 317     -29.157  72.737  13.101  1.00 44.00           C  
ATOM   2076  CD  LYS A 317     -30.534  72.936  13.713  1.00 47.39           C  
ATOM   2077  CE  LYS A 317     -31.393  71.689  13.613  1.00 48.21           C  
ATOM   2078  NZ  LYS A 317     -32.115  71.434  14.896  1.00 51.24           N  
ATOM   2079  N   ASP A 318     -26.325  76.231  12.828  1.00 39.66           N  
ATOM   2080  CA  ASP A 318     -25.570  77.424  13.209  1.00 40.55           C  
ATOM   2081  C   ASP A 318     -26.141  78.086  14.454  1.00 38.71           C  
ATOM   2082  O   ASP A 318     -27.273  77.837  14.873  1.00 35.44           O  
ATOM   2083  CB  ASP A 318     -25.490  78.404  12.042  1.00 44.72           C  
ATOM   2084  CG  ASP A 318     -26.822  78.691  11.383  1.00 51.37           C  
ATOM   2085  OD1 ASP A 318     -27.852  78.667  12.092  1.00 53.34           O  
ATOM   2086  OD2 ASP A 318     -26.844  78.962  10.156  1.00 54.20           O  
ATOM   2087  N   SER A 319     -25.346  78.984  15.038  1.00 35.29           N  
ATOM   2088  CA  SER A 319     -25.723  79.718  16.236  1.00 31.99           C  
ATOM   2089  C   SER A 319     -27.027  80.477  16.073  1.00 32.13           C  
ATOM   2090  O   SER A 319     -27.856  80.448  16.979  1.00 28.78           O  
ATOM   2091  CB  SER A 319     -24.632  80.744  16.605  1.00 29.99           C  
ATOM   2092  OG  SER A 319     -23.396  80.082  16.762  1.00 30.01           O  
ATOM   2093  N   LYS A 320     -27.279  81.071  14.913  1.00 31.42           N  
ATOM   2094  CA  LYS A 320     -28.493  81.806  14.621  1.00 34.79           C  
ATOM   2095  C   LYS A 320     -29.771  80.980  14.705  1.00 34.20           C  
ATOM   2096  O   LYS A 320     -30.863  81.544  14.811  1.00 34.46           O  
ATOM   2097  CB  LYS A 320     -28.406  82.414  13.208  1.00 36.40           C  
ATOM   2098  CG  LYS A 320     -27.081  83.092  12.905  1.00 42.69           C  
ATOM   2099  CD  LYS A 320     -26.097  82.164  12.202  1.00 43.70           C  
ATOM   2100  CE  LYS A 320     -24.945  81.768  13.099  1.00 43.67           C  
ATOM   2101  NZ  LYS A 320     -23.745  81.298  12.358  1.00 48.68           N  
ATOM   2102  N   SER A 321     -29.686  79.659  14.652  1.00 33.91           N  
ATOM   2103  CA  SER A 321     -30.836  78.776  14.752  1.00 32.52           C  
ATOM   2104  C   SER A 321     -31.243  78.542  16.203  1.00 32.23           C  
ATOM   2105  O   SER A 321     -32.332  78.054  16.501  1.00 33.21           O  
ATOM   2106  CB  SER A 321     -30.511  77.444  14.078  1.00 34.31           C  
ATOM   2107  OG  SER A 321     -29.745  76.613  14.926  1.00 36.21           O  
ATOM   2108  N   ILE A 322     -30.373  78.918  17.141  1.00 28.33           N  
ATOM   2109  CA  ILE A 322     -30.633  78.754  18.557  1.00 28.25           C  
ATOM   2110  C   ILE A 322     -31.284  79.993  19.155  1.00 24.44           C  
ATOM   2111  O   ILE A 322     -30.966  81.116  18.756  1.00 27.77           O  
ATOM   2112  CB  ILE A 322     -29.301  78.534  19.316  1.00 24.80           C  
ATOM   2113  CG1 ILE A 322     -28.513  77.365  18.699  1.00 26.29           C  
ATOM   2114  CG2 ILE A 322     -29.505  78.294  20.800  1.00 26.08           C  
ATOM   2115  CD1 ILE A 322     -27.078  77.293  19.205  1.00 24.98           C  
ATOM   2116  N   THR A 323     -32.141  79.783  20.148  1.00 24.20           N  
ATOM   2117  CA  THR A 323     -32.721  80.881  20.894  1.00 23.85           C  
ATOM   2118  C   THR A 323     -32.141  80.850  22.309  1.00 21.76           C  
ATOM   2119  O   THR A 323     -32.450  79.954  23.099  1.00 23.88           O  
ATOM   2120  CB  THR A 323     -34.257  80.850  20.949  1.00 27.06           C  
ATOM   2121  OG1 THR A 323     -34.742  81.034  19.608  1.00 28.45           O  
ATOM   2122  CG2 THR A 323     -34.800  81.980  21.814  1.00 28.67           C  
ATOM   2123  N   PHE A 324     -31.251  81.814  22.614  1.00 19.59           N  
ATOM   2124  CA  PHE A 324     -30.704  81.858  23.966  1.00 19.74           C  
ATOM   2125  C   PHE A 324     -31.550  82.857  24.757  1.00 17.06           C  
ATOM   2126  O   PHE A 324     -32.025  83.834  24.174  1.00 19.78           O  
ATOM   2127  CB  PHE A 324     -29.252  82.350  23.943  1.00 17.09           C  
ATOM   2128  CG  PHE A 324     -28.278  81.449  23.248  1.00 17.13           C  
ATOM   2129  CD1 PHE A 324     -27.850  80.283  23.864  1.00 17.58           C  
ATOM   2130  CD2 PHE A 324     -27.774  81.781  21.998  1.00 16.10           C  
ATOM   2131  CE1 PHE A 324     -26.952  79.447  23.216  1.00 16.99           C  
ATOM   2132  CE2 PHE A 324     -26.880  80.944  21.358  1.00 17.60           C  
ATOM   2133  CZ  PHE A 324     -26.464  79.783  21.976  1.00 19.21           C  
ATOM   2134  N   SER A 325     -31.709  82.620  26.048  1.00 18.01           N  
ATOM   2135  CA  SER A 325     -32.523  83.529  26.854  1.00 17.84           C  
ATOM   2136  C   SER A 325     -31.846  84.899  27.014  1.00 18.81           C  
ATOM   2137  O   SER A 325     -30.629  85.032  26.834  1.00 18.22           O  
ATOM   2138  CB  SER A 325     -32.800  82.904  28.220  1.00 19.66           C  
ATOM   2139  OG  SER A 325     -33.564  81.708  27.959  1.00 20.48           O  
ATOM   2140  N   LYS A 326     -32.656  85.863  27.434  1.00 17.53           N  
ATOM   2141  CA  LYS A 326     -32.152  87.216  27.676  1.00 18.48           C  
ATOM   2142  C   LYS A 326     -31.138  87.208  28.818  1.00 18.06           C  
ATOM   2143  O   LYS A 326     -31.081  86.322  29.664  1.00 17.92           O  
ATOM   2144  CB  LYS A 326     -33.335  88.130  28.032  1.00 17.25           C  
ATOM   2145  CG  LYS A 326     -33.897  87.860  29.412  1.00 19.88           C  
ATOM   2146  CD  LYS A 326     -35.287  88.438  29.627  1.00 23.37           C  
ATOM   2147  CE  LYS A 326     -35.660  88.271  31.098  1.00 25.16           C  
ATOM   2148  NZ  LYS A 326     -36.952  88.950  31.399  1.00 31.01           N  
ATOM   2149  N   LEU A 327     -30.349  88.294  28.815  1.00 18.88           N  
ATOM   2150  CA  LEU A 327     -29.333  88.455  29.858  1.00 18.18           C  
ATOM   2151  C   LEU A 327     -29.185  89.933  30.215  1.00 17.39           C  
ATOM   2152  O   LEU A 327     -28.684  90.714  29.379  1.00 18.64           O  
ATOM   2153  CB  LEU A 327     -27.988  87.905  29.360  1.00 16.49           C  
ATOM   2154  CG  LEU A 327     -26.867  87.989  30.413  1.00 16.09           C  
ATOM   2155  CD1 LEU A 327     -27.108  87.012  31.547  1.00 17.60           C  
ATOM   2156  CD2 LEU A 327     -25.515  87.699  29.763  1.00 17.40           C  
ATOM   2157  OXT LEU A 327     -29.583  90.273  31.344  1.00 20.88           O  
TER    2158      LEU A 327                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
