
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  238 ( 1839),  selected  238 , name 2vss_A
# Molecule2: number of CA atoms  201 ( 1504),  selected  201 , name T0486_32_232.pdb
# PARAMETERS: 2vss_A.T0486_32_232.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    G     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    W     8_A      P      32          5.455
LGA    K     9_A      R      33          0.993
LGA    T    10_A      P      34          0.370
LGA    V    11_A      T      35          0.213
LGA    K    12_A      S      36          0.382
LGA    V    13_A      A      37          0.633
LGA    E    14_A      R      38          1.882
LGA    I    15_A      Q      39          1.708
LGA    E    16_A      L      40          2.490
LGA    D    17_A      D      41          1.632
LGA    G    18_A      G      42          1.557
LGA    I    19_A      I      43          1.113
LGA    A    20_A      R      44          0.776
LGA    F    21_A      N      45          0.745
LGA    V    22_A      I      46          0.666
LGA    I    23_A      V      47          0.213
LGA    L    24_A      L      48          0.489
LGA    N    25_A      S      49          0.882
LGA    R    26_A      N      50          0.558
LGA    P    27_A      P      51          0.690
LGA    E    28_A      K      52          0.613
LGA    K    29_A      K      53          0.961
LGA    R    30_A      R      54          1.082
LGA    N    31_A      N      55          0.554
LGA    A    32_A      T      56          0.749
LGA    M    33_A      L      57          0.689
LGA    S    34_A      S      58          0.725
LGA    P    35_A      L      59          0.721
LGA    T    36_A      A      60          0.559
LGA    L    37_A      M      61          0.652
LGA    N    38_A      L      62          1.161
LGA    R    39_A      K      63          1.428
LGA    E    40_A      S      64          1.288
LGA    M    41_A      L      65          1.522
LGA    I    42_A      Q      66          1.719
LGA    D    43_A      S      67          1.426
LGA    V    44_A      D      68          1.279
LGA    L    45_A      I      69          1.307
LGA    E    46_A      L      70          1.180
LGA    T    47_A      X      71          0.432
LGA    L    48_A      D      72          4.316
LGA    E    49_A      A      73          0.904
LGA    Q    50_A      D      74          3.574
LGA    D    51_A      S      75          4.001
LGA    P    52_A      N      76          3.658
LGA    A    53_A      D      77          3.392
LGA    A    54_A      L      78          2.651
LGA    G    55_A      K      79          1.254
LGA    V    56_A      V      80          0.433
LGA    L    57_A      I      81          0.276
LGA    V    58_A      I      82          0.282
LGA    L    59_A      I      83          0.597
LGA    T    60_A      S      84          0.488
LGA    G    61_A      A      85          0.463
LGA    A    62_A      E      86          0.896
LGA    G    63_A      G      87          1.225
LGA    E    64_A      P      88          1.239
LGA    A    65_A      V      89          1.728
LGA    W    66_A      F      90          1.384
LGA    T    67_A      S      91          0.965
LGA    A    68_A      S      92          1.350
LGA    G    69_A      G      93          1.221
LGA    M    70_A      X      94          1.095
LGA    D    71_A      D      95          1.521
LGA    L    72_A      L      96          1.648
LGA    -       -      K      97           -
LGA    -       -      E      98           -
LGA    -       -      L      99           -
LGA    -       -      T     100           -
LGA    -       -      E     101           -
LGA    A    81_A      E     102          3.629
LGA    G    82_A      Q     103          3.657
LGA    P    83_A      G     104          4.369
LGA    E    84_A      R     105          3.429
LGA    I    85_A      D     106          2.486
LGA    L    86_A      Y     107          2.816
LGA    Q    87_A      X     108          2.655
LGA    E    88_A      A     109          2.617
LGA    K    89_A      E     110          2.446
LGA    I    90_A      V     111          2.605
LGA    R    91_A      F     112          2.238
LGA    R    92_A      Q     113          1.670
LGA    E    93_A      T     114          1.428
LGA    A    94_A      C     115          1.821
LGA    S    95_A      S     116          1.473
LGA    Q    96_A      K     117          1.544
LGA    W    97_A      V     118          1.172
LGA    Q    98_A      M     119          2.823
LGA    W    99_A      -       -           -
LGA    K   100_A      M     120          1.740
LGA    L   101_A      X     121          0.890
LGA    L   102_A      I     122          1.152
LGA    R   103_A      R     123          1.637
LGA    M   104_A      N     124          1.902
LGA    Y   105_A      X     125          1.184
LGA    A   106_A      P     126          1.076
LGA    K   107_A      V     127          0.816
LGA    P   108_A      P     128          0.752
LGA    T   109_A      V     129          0.727
LGA    I   110_A      I     130          0.516
LGA    A   111_A      A     131          0.571
LGA    M   112_A      M     132          0.484
LGA    V   113_A      V     133          0.803
LGA    N   114_A      N     134          1.310
LGA    G   115_A      G     135          1.289
LGA    W   116_A      L     136          1.184
LGA    C   117_A      A     137          0.334
LGA    F   118_A      T     138          0.197
LGA    G   119_A      A     139          0.479
LGA    G   120_A      A     140          0.886
LGA    G   121_A      G     141          1.383
LGA    F   122_A      C     142          2.364
LGA    S   123_A      Q     143          2.253
LGA    P   124_A      L     144          1.914
LGA    L   125_A      V     145          1.404
LGA    V   126_A      A     146          1.975
LGA    A   127_A      S     147          1.977
LGA    C   128_A      C     148          1.013
LGA    D   129_A      D     149          0.415
LGA    L   130_A      I     150          0.614
LGA    A   131_A      A     151          0.639
LGA    I   132_A      V     152          0.480
LGA    C   133_A      A     153          0.522
LGA    A   134_A      S     154          0.576
LGA    D   135_A      D     155          0.378
LGA    E   136_A      K     156          0.750
LGA    A   137_A      S     157          0.877
LGA    T   138_A      S     158          1.826
LGA    F   139_A      F     159          1.236
LGA    G   140_A      A     160          1.110
LGA    L   141_A      T     161          1.349
LGA    S   142_A      P     162          1.239
LGA    E   143_A      G     163          1.147
LGA    I   144_A      V     164          1.751
LGA    N   145_A      N     165          1.784
LGA    W   146_A      V     166          1.825
LGA    G   147_A      G     167          2.003
LGA    I   148_A      L     168          1.882
LGA    P   149_A      F     169          1.266
LGA    P   150_A      C     170          0.901
LGA    G   151_A      S     171          3.228
LGA    N   152_A      T     172          2.223
LGA    L   153_A      -       -           -
LGA    V   154_A      P     173          0.982
LGA    S   155_A      G     174          0.819
LGA    K   156_A      V     175          1.705
LGA    A   157_A      A     176          1.004
LGA    M   158_A      L     177          1.279
LGA    A   159_A      A     178          1.168
LGA    D   160_A      R     179          0.917
LGA    T   161_A      A     180          1.350
LGA    V   162_A      V     181          0.437
LGA    G   163_A      P     182          0.895
LGA    H   164_A      R     183          1.571
LGA    R   165_A      K     184          1.191
LGA    Q   166_A      V     185          1.140
LGA    S   167_A      A     186          1.158
LGA    L   168_A      L     187          1.156
LGA    Y   169_A      E     188          1.340
LGA    Y   170_A      M     189          1.339
LGA    I   171_A      L     190          1.321
LGA    M   172_A      F     191          1.574
LGA    T   173_A      T     192          1.614
LGA    G   174_A      G     193          1.036
LGA    K   175_A      E     194          1.083
LGA    T   176_A      P     195          1.219
LGA    F   177_A      I     196          1.937
LGA    G   178_A      S     197          1.713
LGA    G   179_A      A     198          1.362
LGA    Q   180_A      Q     199          1.249
LGA    K   181_A      E     200          1.428
LGA    A   182_A      A     201          1.299
LGA    A   183_A      L     202          0.423
LGA    E   184_A      L     203          0.934
LGA    M   185_A      X     204          1.265
LGA    G   186_A      G     205          0.838
LGA    L   187_A      L     206          0.349
LGA    V   188_A      L     207          0.562
LGA    N   189_A      S     208          0.547
LGA    E   190_A      K     209          1.222
LGA    S   191_A      V     210          0.766
LGA    V   192_A      V     211          0.525
LGA    P   193_A      P     212          0.650
LGA    L   194_A      E     213          0.744
LGA    A   195_A      A     214          0.848
LGA    Q   196_A      E     215          0.622
LGA    L   197_A      L     216          0.470
LGA    R   198_A      Q     217          0.498
LGA    E   199_A      E     218          0.286
LGA    V   200_A      E     219          0.451
LGA    T   201_A      T     220          0.514
LGA    I   202_A      M     221          0.303
LGA    E   203_A      R     222          0.250
LGA    L   204_A      I     223          0.718
LGA    A   205_A      A     224          0.784
LGA    R   206_A      R     225          1.378
LGA    N   207_A      K     226          1.499
LGA    L   208_A      I     227          1.344
LGA    L   209_A      A     228          1.640
LGA    E   210_A      S     229          2.505
LGA    K   211_A      L     230          2.402
LGA    N   212_A      S     231          1.780
LGA    P   213_A      R     232          1.756
LGA    V   214_A      -       -           -
LGA    V   215_A      -       -           -
LGA    L   216_A      -       -           -
LGA    R   217_A      -       -           -
LGA    A   218_A      -       -           -
LGA    A   219_A      -       -           -
LGA    K   220_A      -       -           -
LGA    H   221_A      -       -           -
LGA    G   222_A      -       -           -
LGA    F   223_A      -       -           -
LGA    K   224_A      -       -           -
LGA    R   225_A      -       -           -
LGA    C   226_A      -       -           -
LGA    R   227_A      -       -           -
LGA    E   228_A      -       -           -
LGA    L   229_A      -       -           -
LGA    T   230_A      -       -           -
LGA    W   231_A      -       -           -
LGA    E   232_A      -       -           -
LGA    Q   233_A      -       -           -
LGA    N   234_A      -       -           -
LGA    E   235_A      -       -           -
LGA    D   236_A      -       -           -
LGA    Y   237_A      -       -           -
LGA    L   238_A      -       -           -
LGA    Y   239_A      -       -           -
LGA    A   240_A      -       -           -
LGA    K   241_A      -       -           -
LGA    L   242_A      -       -           -
LGA    D   243_A      -       -           -
LGA    Q   244_A      -       -           -
LGA    S   245_A      -       -           -
LGA    R   246_A      -       -           -
LGA    L   247_A      -       -           -
LGA    L   248_A      -       -           -
LGA    D   249_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  238  201    5.0    196    1.58    25.00     90.451    11.670

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.915233 * X  +   0.147372 * Y  +   0.375007 * Z  +  33.791676
  Y_new =  -0.027405 * X  +  -0.951324 * Y  +   0.306972 * Z  +  89.615166
  Z_new =   0.401992 * X  +   0.270674 * Y  +   0.874722 * Z  +  67.350479 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.300094   -2.841498  [ DEG:    17.1941   -162.8059 ]
  Theta =  -0.413692   -2.727901  [ DEG:   -23.7028   -156.2972 ]
  Phi   =  -3.111658    0.029934  [ DEG:  -178.2849      1.7151 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2vss_A                                        
REMARK     2: T0486_32_232.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2vss_A.T0486_32_232.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  238  201   5.0  196   1.58   25.00  90.451
REMARK  ---------------------------------------------------------- 
MOLECULE 2vss_A
HEADER    LYASE                                   29-APR-08   2VSS              
TITLE     WILD-TYPE HYDROXYCINNAMOYL-COA HYDRATASE LYASE IN COMPLEX             
TITLE    2 WITH ACETYL-COA AND VANILLIN                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND   3 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE;                       
COMPND   4 CHAIN: A, B, C, D;                                                   
COMPND   5 EC: 4.2.1.101;                                                       
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND   9 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE;                       
COMPND  10 CHAIN: E;                                                            
COMPND  11 EC: 4.2.1.101;                                                       
COMPND  12 ENGINEERED: YES;                                                     
COMPND  13 MOL_ID: 3;                                                           
COMPND  14 MOLECULE: P-HYDROXYCINNAMOYL COA HYDRATASE/LYASE;                    
COMPND  15 SYNONYM: HYDROXYCINNAMOYL-COA HYDRATASE-LYASE;                       
COMPND  16 CHAIN: F;                                                            
COMPND  17 EC: 4.2.1.101;                                                       
COMPND  18 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   4 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE   5 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE   6 STRAIN: AN103;                                                       
SOURCE   7 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH U.K.;             
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  10 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  12 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  13 STRAIN: AN103;                                                       
SOURCE  14 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH U.K.;             
SOURCE  15 MOL_ID: 3;                                                           
SOURCE  16 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  17 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: YSBLIC-3C;                                
SOURCE  19 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE  20 STRAIN: AN103;                                                       
SOURCE  21 OTHER_DETAILS: INSTITUTE OF FOOD RESEARCH, NORWICH U.K.              
KEYWDS    LYASE, ALDOLASE, CROTONASE, HYDRATASE                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.P.BENNETT,L.M.BERTIN,A.M.BRZOZOWSKI,N.J.WALTON,G.GROGAN             
REVDAT   1   27-MAY-08 2VSS    0                                                
JRNL        AUTH   J.P.BENNETT,L.M.BERTIN,B.MOULTON,I.J.S.FAIRLAMB,             
JRNL        AUTH 2 A.M.BRZOZOWSKI,N.J.WALTON,G.GROGAN                           
JRNL        TITL   A TERNARY COMPLEX OF HYDROXYCINNAMOYL-COA                    
JRNL        TITL 2 HYDRATASE-LYASE (HCHL) WITH ACETYL-COENZYME A AND            
JRNL        TITL 3 VANILLIN GIVES INSIGHTS INTO SUBSTRATE SPECIFICITY           
JRNL        TITL 4 AND MECHANISM.                                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.22 ANGSTROMS.                                          
DBREF  2VSS A    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS B    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS C    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS D    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS E    1   276  UNP    O69762   O69762_PSEFL     1    276             
DBREF  2VSS F    1   276  UNP    O69762   O69762_PSEFL     1    276             
SEQRES   1 A  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 A  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 A  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 A  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 A  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 A  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 A  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 A  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 A  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 A  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 A  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 A  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 A  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 A  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 A  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 A  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 A  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 A  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 A  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 A  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 A  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 A  276  TYR LYS ARG                                                  
SEQRES   1 B  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 B  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 B  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 B  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 B  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 B  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 B  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 B  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 B  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 B  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 B  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 B  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 B  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 B  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 B  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 B  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 B  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 B  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 B  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 B  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 B  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 B  276  TYR LYS ARG                                                  
SEQRES   1 C  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 C  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 C  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 C  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 C  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 C  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 C  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 C  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 C  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 C  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 C  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 C  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 C  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 C  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 C  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 C  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 C  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 C  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 C  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 C  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 C  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 C  276  TYR LYS ARG                                                  
SEQRES   1 D  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 D  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 D  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 D  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 D  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 D  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 D  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 D  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 D  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 D  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 D  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 D  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 D  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 D  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 D  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 D  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 D  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 D  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 D  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 D  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 D  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 D  276  TYR LYS ARG                                                  
SEQRES   1 E  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 E  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 E  276  PRO GLU LYS ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 E  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 E  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 E  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 E  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 E  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 E  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 E  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 E  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 E  276  ILE ASN TYR GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 E  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 E  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 E  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 E  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 E  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 E  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 E  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 E  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 E  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 E  276  TYR LYS ARG                                                  
SEQRES   1 F  276  MET SER THR TYR GLU GLY ARG TRP LYS THR VAL LYS VAL          
SEQRES   2 F  276  GLU ILE GLU ASP GLY ILE ALA PHE VAL ILE LEU ASN ARG          
SEQRES   3 F  276  PRO GLU ARG ARG ASN ALA MET SER PRO THR LEU ASN ARG          
SEQRES   4 F  276  GLU MET ILE ASP VAL LEU GLU THR LEU GLU GLN ASP PRO          
SEQRES   5 F  276  ALA ALA GLY VAL LEU VAL LEU THR GLY ALA GLY GLU ALA          
SEQRES   6 F  276  TRP THR ALA GLY MET ASP LEU LYS GLU TYR PHE ARG GLU          
SEQRES   7 F  276  VAL ASP ALA GLY PRO GLU ILE LEU GLN GLU LYS ILE ARG          
SEQRES   8 F  276  ARG GLU ALA SER GLN TRP GLN TRP LYS LEU LEU ARG MET          
SEQRES   9 F  276  TYR ALA LYS PRO THR ILE ALA MET VAL ASN GLY TRP CYS          
SEQRES  10 F  276  PHE GLY GLY GLY PHE SER PRO LEU VAL ALA CYS ASP LEU          
SEQRES  11 F  276  ALA ILE CYS ALA ASP GLU ALA THR PHE GLY LEU SER GLU          
SEQRES  12 F  276  ILE ASN TRP GLY ILE PRO PRO GLY ASN LEU VAL SER LYS          
SEQRES  13 F  276  ALA MET ALA ASP THR VAL GLY HIS ARG GLN SER LEU TYR          
SEQRES  14 F  276  TYR ILE MET THR GLY LYS THR PHE GLY GLY GLN LYS ALA          
SEQRES  15 F  276  ALA GLU MET GLY LEU VAL ASN GLU SER VAL PRO LEU ALA          
SEQRES  16 F  276  GLN LEU ARG GLU VAL THR ILE GLU LEU ALA ARG ASN LEU          
SEQRES  17 F  276  LEU GLU LYS ASN PRO VAL VAL LEU ARG ALA ALA LYS HIS          
SEQRES  18 F  276  GLY PHE LYS ARG CYS ARG GLU LEU THR TRP GLU GLN ASN          
SEQRES  19 F  276  GLU ASP TYR LEU TYR ALA LYS LEU ASP GLN SER ARG LEU          
SEQRES  20 F  276  LEU ASP THR GLU GLY GLY ARG GLU GLN GLY MET LYS GLN          
SEQRES  21 F  276  PHE LEU ASP ASP LYS SER ILE LYS PRO GLY LEU GLN ALA          
SEQRES  22 F  276  TYR LYS ARG                                                  
HET    ACO  B1251      51                                                       
HET    ACO  D1249      51                                                       
HET    ACO  E1250      51                                                       
HET    ACO  F1249      51                                                       
HET    V55  D1250      11                                                       
HETNAM     ACO ACETYL COENZYME *A                                               
HETNAM     V55 4-HYDROXY-3-METHOXYBENZALDEHYDE                                  
FORMUL   7  ACO    4(C23 H38 N7 O17 P3 S1)                                      
FORMUL   8  V55    C8 H8 O3                                                     
FORMUL   9  HOH   *316(H2 O1)                                                   
CRYST1   90.223  130.595  144.663  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   TYR A   4     -36.676 105.737  20.467  1.00 52.70           N  
ATOM      2  CA  TYR A   4     -35.823 106.861  20.956  1.00 52.68           C  
ATOM      3  C   TYR A   4     -35.902 108.117  20.102  1.00 53.39           C  
ATOM      4  O   TYR A   4     -35.054 109.012  20.203  1.00 53.33           O  
ATOM      5  CB  TYR A   4     -34.397 106.372  21.119  1.00 52.14           C  
ATOM      6  CG  TYR A   4     -34.305 105.289  22.162  1.00 51.85           C  
ATOM      7  CD1 TYR A   4     -34.526 105.575  23.504  1.00 51.89           C  
ATOM      8  CD2 TYR A   4     -34.023 103.970  21.808  1.00 51.04           C  
ATOM      9  CE1 TYR A   4     -34.463 104.569  24.474  1.00 52.66           C  
ATOM     10  CE2 TYR A   4     -33.954 102.963  22.768  1.00 50.62           C  
ATOM     11  CZ  TYR A   4     -34.176 103.269  24.098  1.00 51.85           C  
ATOM     12  OH  TYR A   4     -34.124 102.274  25.059  1.00 52.37           O  
ATOM     13  N   GLU A   5     -36.953 108.186  19.281  1.00 54.37           N  
ATOM     14  CA  GLU A   5     -37.252 109.335  18.426  1.00 54.37           C  
ATOM     15  C   GLU A   5     -37.185 110.639  19.233  1.00 54.31           C  
ATOM     16  O   GLU A   5     -37.972 110.822  20.177  1.00 53.71           O  
ATOM     17  CB  GLU A   5     -38.638 109.121  17.766  1.00 55.30           C  
ATOM     18  CG  GLU A   5     -39.289 110.315  16.965  1.00 55.19           C  
ATOM     19  CD  GLU A   5     -38.447 110.815  15.785  1.00 55.44           C  
ATOM     20  OE1 GLU A   5     -37.208 110.606  15.790  1.00 55.38           O  
ATOM     21  OE2 GLU A   5     -39.014 111.423  14.850  1.00 51.44           O  
ATOM     22  N   GLY A   6     -36.197 111.486  18.900  1.00 53.65           N  
ATOM     23  CA  GLY A   6     -36.041 112.841  19.469  1.00 53.25           C  
ATOM     24  C   GLY A   6     -35.907 113.001  20.984  1.00 53.18           C  
ATOM     25  O   GLY A   6     -36.263 114.046  21.532  1.00 53.68           O  
ATOM     26  N   ARG A   7     -35.386 111.971  21.652  1.00 52.58           N  
ATOM     27  CA  ARG A   7     -35.158 111.947  23.105  1.00 51.78           C  
ATOM     28  C   ARG A   7     -33.923 112.747  23.605  1.00 51.23           C  
ATOM     29  O   ARG A   7     -33.930 113.332  24.716  1.00 51.20           O  
ATOM     30  CB  ARG A   7     -35.011 110.495  23.538  1.00 51.76           C  
ATOM     31  CG  ARG A   7     -34.864 110.340  25.028  1.00 54.38           C  
ATOM     32  CD  ARG A   7     -35.482 109.042  25.523  1.00 59.41           C  
ATOM     33  NE  ARG A   7     -34.911 108.660  26.817  1.00 62.58           N  
ATOM     34  CZ  ARG A   7     -35.109 107.477  27.399  1.00 65.29           C  
ATOM     35  NH1 ARG A   7     -35.862 106.556  26.788  1.00 64.86           N  
ATOM     36  NH2 ARG A   7     -34.544 107.205  28.582  1.00 64.86           N  
ATOM     37  N   TRP A   8     -32.855 112.728  22.804  1.00 50.09           N  
ATOM     38  CA  TRP A   8     -31.598 113.395  23.158  1.00 48.84           C  
ATOM     39  C   TRP A   8     -31.265 114.479  22.181  1.00 49.18           C  
ATOM     40  O   TRP A   8     -31.468 114.327  20.965  1.00 48.12           O  
ATOM     41  CB  TRP A   8     -30.425 112.400  23.272  1.00 47.73           C  
ATOM     42  CG  TRP A   8     -30.661 111.441  24.372  1.00 45.51           C  
ATOM     43  CD1 TRP A   8     -30.594 111.695  25.706  1.00 44.67           C  
ATOM     44  CD2 TRP A   8     -31.088 110.086  24.236  1.00 44.04           C  
ATOM     45  NE1 TRP A   8     -30.941 110.561  26.423  1.00 45.06           N  
ATOM     46  CE2 TRP A   8     -31.240 109.562  25.538  1.00 43.99           C  
ATOM     47  CE3 TRP A   8     -31.327 109.256  23.141  1.00 44.17           C  
ATOM     48  CZ2 TRP A   8     -31.617 108.240  25.774  1.00 47.35           C  
ATOM     49  CZ3 TRP A   8     -31.700 107.943  23.370  1.00 45.31           C  
ATOM     50  CH2 TRP A   8     -31.853 107.450  24.679  1.00 46.17           C  
ATOM     51  N   LYS A   9     -30.760 115.566  22.748  1.00 49.75           N  
ATOM     52  CA  LYS A   9     -30.442 116.772  22.018  1.00 50.96           C  
ATOM     53  C   LYS A   9     -29.202 116.594  21.126  1.00 50.99           C  
ATOM     54  O   LYS A   9     -29.208 116.992  19.964  1.00 51.53           O  
ATOM     55  CB  LYS A   9     -30.221 117.906  23.022  1.00 51.58           C  
ATOM     56  CG  LYS A   9     -30.992 119.170  22.715  1.00 54.89           C  
ATOM     57  CD  LYS A   9     -30.677 120.261  23.733  1.00 59.81           C  
ATOM     58  CE  LYS A   9     -31.641 120.219  24.939  1.00 62.58           C  
ATOM     59  NZ  LYS A   9     -31.205 121.129  26.061  1.00 62.36           N  
ATOM     60  N   THR A  10     -28.143 115.981  21.659  1.00 50.52           N  
ATOM     61  CA  THR A  10     -26.872 115.886  20.911  1.00 49.65           C  
ATOM     62  C   THR A  10     -26.511 114.464  20.422  1.00 49.30           C  
ATOM     63  O   THR A  10     -25.522 114.296  19.727  1.00 49.12           O  
ATOM     64  CB  THR A  10     -25.678 116.499  21.710  1.00 49.54           C  
ATOM     65  OG1 THR A  10     -25.438 115.706  22.866  1.00 49.88           O  
ATOM     66  CG2 THR A  10     -25.926 117.938  22.156  1.00 47.87           C  
ATOM     67  N   VAL A  11     -27.316 113.457  20.780  1.00 49.53           N  
ATOM     68  CA  VAL A  11     -27.119 112.052  20.358  1.00 49.87           C  
ATOM     69  C   VAL A  11     -28.390 111.444  19.735  1.00 50.54           C  
ATOM     70  O   VAL A  11     -29.504 111.895  20.039  1.00 50.71           O  
ATOM     71  CB  VAL A  11     -26.723 111.157  21.559  1.00 49.85           C  
ATOM     72  CG1 VAL A  11     -26.153 109.817  21.076  1.00 49.76           C  
ATOM     73  CG2 VAL A  11     -25.717 111.879  22.453  1.00 50.34           C  
ATOM     74  N   LYS A  12     -28.234 110.400  18.909  1.00 50.85           N  
ATOM     75  CA  LYS A  12     -29.400 109.669  18.350  1.00 51.59           C  
ATOM     76  C   LYS A  12     -29.364 108.123  18.566  1.00 51.75           C  
ATOM     77  O   LYS A  12     -28.301 107.508  18.441  1.00 52.05           O  
ATOM     78  CB  LYS A  12     -29.581 110.015  16.856  1.00 50.99           C  
ATOM     79  N   VAL A  13     -30.502 107.478  18.878  1.00 51.89           N  
ATOM     80  CA  VAL A  13     -30.489 105.999  18.907  1.00 51.51           C  
ATOM     81  C   VAL A  13     -31.393 105.313  17.862  1.00 51.86           C  
ATOM     82  O   VAL A  13     -32.548 105.694  17.637  1.00 51.62           O  
ATOM     83  CB  VAL A  13     -30.579 105.392  20.362  1.00 51.78           C  
ATOM     84  CG1 VAL A  13     -30.295 103.881  20.365  1.00 51.24           C  
ATOM     85  CG2 VAL A  13     -29.557 106.067  21.264  1.00 50.38           C  
ATOM     86  N   GLU A  14     -30.817 104.316  17.203  1.00 52.30           N  
ATOM     87  CA  GLU A  14     -31.482 103.551  16.156  1.00 53.17           C  
ATOM     88  C   GLU A  14     -31.191 102.063  16.301  1.00 53.39           C  
ATOM     89  O   GLU A  14     -30.111 101.604  15.883  1.00 53.57           O  
ATOM     90  CB  GLU A  14     -30.997 104.025  14.790  1.00 52.82           C  
ATOM     91  CG  GLU A  14     -31.704 105.300  14.309  1.00 54.48           C  
ATOM     92  CD  GLU A  14     -31.154 105.859  12.985  1.00 54.28           C  
ATOM     93  OE1 GLU A  14     -30.290 105.209  12.333  1.00 55.63           O  
ATOM     94  OE2 GLU A  14     -31.584 106.975  12.610  1.00 55.56           O  
ATOM     95  N   ILE A  15     -32.120 101.315  16.903  1.00 53.41           N  
ATOM     96  CA  ILE A  15     -31.968  99.870  16.969  1.00 54.58           C  
ATOM     97  C   ILE A  15     -32.574  99.248  15.717  1.00 55.34           C  
ATOM     98  O   ILE A  15     -33.656  99.644  15.265  1.00 55.42           O  
ATOM     99  CB  ILE A  15     -32.647  99.222  18.211  1.00 55.24           C  
ATOM    100  CG1 ILE A  15     -32.202  99.860  19.541  1.00 55.93           C  
ATOM    101  CG2 ILE A  15     -32.405  97.697  18.245  1.00 55.96           C  
ATOM    102  CD1 ILE A  15     -33.229 100.782  20.129  1.00 56.53           C  
ATOM    103  N   GLU A  16     -31.871  98.274  15.149  1.00 55.95           N  
ATOM    104  CA  GLU A  16     -32.399  97.482  14.041  1.00 56.41           C  
ATOM    105  C   GLU A  16     -31.967  96.038  14.254  1.00 56.62           C  
ATOM    106  O   GLU A  16     -30.788  95.703  14.121  1.00 56.77           O  
ATOM    107  CB  GLU A  16     -31.959  98.029  12.661  1.00 56.79           C  
ATOM    108  CG  GLU A  16     -30.525  98.563  12.534  1.00 56.16           C  
ATOM    109  CD  GLU A  16     -29.999  98.519  11.095  1.00 57.31           C  
ATOM    110  OE1 GLU A  16     -30.067  97.411  10.522  1.00 59.04           O  
ATOM    111  OE2 GLU A  16     -29.504  99.552  10.539  1.00 56.09           O  
ATOM    112  N   ASP A  17     -32.928  95.205  14.646  1.00 56.92           N  
ATOM    113  CA  ASP A  17     -32.714  93.767  14.823  1.00 56.98           C  
ATOM    114  C   ASP A  17     -31.520  93.433  15.726  1.00 56.24           C  
ATOM    115  O   ASP A  17     -30.623  92.670  15.330  1.00 56.57           O  
ATOM    116  N   GLY A  18     -31.518  94.002  16.928  1.00 55.30           N  
ATOM    117  CA  GLY A  18     -30.494  93.692  17.932  1.00 53.59           C  
ATOM    118  C   GLY A  18     -29.385  94.719  18.028  1.00 51.99           C  
ATOM    119  O   GLY A  18     -28.890  95.001  19.117  1.00 51.95           O  
ATOM    120  N   ILE A  19     -28.989  95.288  16.895  1.00 50.99           N  
ATOM    121  CA  ILE A  19     -27.927  96.306  16.886  1.00 48.90           C  
ATOM    122  C   ILE A  19     -28.471  97.670  17.256  1.00 47.60           C  
ATOM    123  O   ILE A  19     -29.324  98.190  16.551  1.00 46.30           O  
ATOM    124  CB  ILE A  19     -27.289  96.437  15.498  1.00 49.79           C  
ATOM    125  CG1 ILE A  19     -27.239  95.054  14.801  1.00 49.28           C  
ATOM    126  CG2 ILE A  19     -25.934  97.151  15.606  1.00 47.98           C  
ATOM    127  CD1 ILE A  19     -26.431  95.030  13.499  1.00 48.94           C  
ATOM    128  N   ALA A  20     -27.991  98.250  18.358  1.00 45.98           N  
ATOM    129  CA  ALA A  20     -28.252  99.664  18.594  1.00 45.31           C  
ATOM    130  C   ALA A  20     -27.100 100.527  18.095  1.00 45.01           C  
ATOM    131  O   ALA A  20     -26.030 100.543  18.688  1.00 45.31           O  
ATOM    132  CB  ALA A  20     -28.541  99.956  20.036  1.00 43.99           C  
ATOM    133  N   PHE A  21     -27.349 101.268  17.022  1.00 45.17           N  
ATOM    134  CA  PHE A  21     -26.452 102.344  16.567  1.00 45.59           C  
ATOM    135  C   PHE A  21     -26.576 103.576  17.466  1.00 45.55           C  
ATOM    136  O   PHE A  21     -27.655 104.176  17.583  1.00 46.28           O  
ATOM    137  CB  PHE A  21     -26.758 102.713  15.114  1.00 45.78           C  
ATOM    138  CG  PHE A  21     -26.479 101.596  14.162  1.00 46.58           C  
ATOM    139  CD1 PHE A  21     -27.376 100.530  14.036  1.00 46.69           C  
ATOM    140  CD2 PHE A  21     -25.295 101.572  13.438  1.00 44.21           C  
ATOM    141  CE1 PHE A  21     -27.090  99.481  13.164  1.00 47.84           C  
ATOM    142  CE2 PHE A  21     -25.011 100.528  12.586  1.00 45.05           C  
ATOM    143  CZ  PHE A  21     -25.901  99.483  12.437  1.00 44.91           C  
ATOM    144  N   VAL A  22     -25.491 103.923  18.133  1.00 44.60           N  
ATOM    145  CA  VAL A  22     -25.461 105.136  18.906  1.00 45.18           C  
ATOM    146  C   VAL A  22     -24.752 106.174  18.035  1.00 45.70           C  
ATOM    147  O   VAL A  22     -23.585 106.017  17.715  1.00 44.92           O  
ATOM    148  CB  VAL A  22     -24.690 104.916  20.236  1.00 45.82           C  
ATOM    149  CG1 VAL A  22     -24.500 106.234  20.975  1.00 45.55           C  
ATOM    150  CG2 VAL A  22     -25.382 103.845  21.110  1.00 44.77           C  
ATOM    151  N   ILE A  23     -25.468 107.220  17.650  1.00 45.92           N  
ATOM    152  CA  ILE A  23     -24.937 108.201  16.727  1.00 46.75           C  
ATOM    153  C   ILE A  23     -24.655 109.547  17.394  1.00 46.95           C  
ATOM    154  O   ILE A  23     -25.584 110.283  17.787  1.00 47.19           O  
ATOM    155  CB  ILE A  23     -25.885 108.421  15.557  1.00 46.40           C  
ATOM    156  CG1 ILE A  23     -26.278 107.075  14.951  1.00 47.57           C  
ATOM    157  CG2 ILE A  23     -25.237 109.284  14.499  1.00 47.21           C  
ATOM    158  CD1 ILE A  23     -27.713 107.059  14.379  1.00 48.72           C  
ATOM    159  N   LEU A  24     -23.366 109.863  17.516  1.00 46.58           N  
ATOM    160  CA  LEU A  24     -22.954 111.221  17.928  1.00 46.25           C  
ATOM    161  C   LEU A  24     -23.517 112.295  16.978  1.00 45.84           C  
ATOM    162  O   LEU A  24     -23.310 112.246  15.782  1.00 45.37           O  
ATOM    163  CB  LEU A  24     -21.441 111.332  18.118  1.00 45.53           C  
ATOM    164  CG  LEU A  24     -20.767 110.329  19.082  1.00 44.21           C  
ATOM    165  CD1 LEU A  24     -19.281 110.572  19.082  1.00 42.51           C  
ATOM    166  CD2 LEU A  24     -21.296 110.388  20.493  1.00 44.53           C  
ATOM    167  N   ASN A  25     -24.238 113.259  17.535  1.00 46.66           N  
ATOM    168  CA  ASN A  25     -25.114 114.069  16.712  1.00 48.11           C  
ATOM    169  C   ASN A  25     -24.968 115.598  16.862  1.00 49.16           C  
ATOM    170  O   ASN A  25     -25.936 116.330  17.160  1.00 48.97           O  
ATOM    171  CB  ASN A  25     -26.559 113.585  16.875  1.00 47.56           C  
ATOM    172  CG  ASN A  25     -27.460 113.995  15.716  1.00 48.45           C  
ATOM    173  OD1 ASN A  25     -28.667 114.099  15.898  1.00 47.23           O  
ATOM    174  ND2 ASN A  25     -26.888 114.220  14.527  1.00 47.55           N  
ATOM    175  N   ARG A  26     -23.743 116.067  16.610  1.00 49.56           N  
ATOM    176  CA  ARG A  26     -23.471 117.484  16.414  1.00 50.47           C  
ATOM    177  C   ARG A  26     -22.585 117.612  15.163  1.00 51.08           C  
ATOM    178  O   ARG A  26     -21.431 118.050  15.257  1.00 51.32           O  
ATOM    179  CB  ARG A  26     -22.798 118.085  17.662  1.00 50.32           C  
ATOM    180  CG  ARG A  26     -23.590 117.807  18.939  1.00 50.89           C  
ATOM    181  CD  ARG A  26     -22.904 118.275  20.185  1.00 52.20           C  
ATOM    182  NE  ARG A  26     -22.877 119.735  20.282  1.00 51.87           N  
ATOM    183  CZ  ARG A  26     -21.772 120.476  20.306  1.00 50.95           C  
ATOM    184  NH1 ARG A  26     -20.563 119.915  20.250  1.00 46.95           N  
ATOM    185  NH2 ARG A  26     -21.884 121.796  20.398  1.00 49.20           N  
ATOM    186  N   PRO A  27     -23.116 117.215  13.988  1.00 51.22           N  
ATOM    187  CA  PRO A  27     -22.275 117.131  12.802  1.00 51.80           C  
ATOM    188  C   PRO A  27     -21.775 118.528  12.369  1.00 52.09           C  
ATOM    189  O   PRO A  27     -20.697 118.659  11.802  1.00 51.27           O  
ATOM    190  CB  PRO A  27     -23.199 116.493  11.755  1.00 51.86           C  
ATOM    191  CG  PRO A  27     -24.557 116.792  12.195  1.00 52.08           C  
ATOM    192  CD  PRO A  27     -24.514 116.851  13.696  1.00 51.74           C  
ATOM    193  N   GLU A  28     -22.576 119.537  12.701  1.00 53.06           N  
ATOM    194  CA  GLU A  28     -22.273 120.957  12.571  1.00 54.03           C  
ATOM    195  C   GLU A  28     -21.050 121.407  13.410  1.00 53.70           C  
ATOM    196  O   GLU A  28     -20.414 122.436  13.108  1.00 53.48           O  
ATOM    197  CB  GLU A  28     -23.530 121.746  12.976  1.00 54.83           C  
ATOM    198  CG  GLU A  28     -23.484 123.224  12.686  1.00 58.09           C  
ATOM    199  CD  GLU A  28     -24.798 123.740  12.091  1.00 64.79           C  
ATOM    200  OE1 GLU A  28     -25.152 123.376  10.929  1.00 62.98           O  
ATOM    201  OE2 GLU A  28     -25.479 124.526  12.803  1.00 69.08           O  
ATOM    202  N   LYS A  29     -20.726 120.655  14.461  1.00 52.72           N  
ATOM    203  CA  LYS A  29     -19.526 120.941  15.234  1.00 52.02           C  
ATOM    204  C   LYS A  29     -18.597 119.749  15.137  1.00 51.72           C  
ATOM    205  O   LYS A  29     -17.680 119.619  15.929  1.00 52.07           O  
ATOM    206  CB  LYS A  29     -19.871 121.265  16.694  1.00 52.31           C  
ATOM    207  CG  LYS A  29     -20.698 122.544  16.924  1.00 52.45           C  
ATOM    208  CD  LYS A  29     -19.903 123.783  16.640  1.00 53.74           C  
ATOM    209  CE  LYS A  29     -20.679 125.039  16.906  1.00 55.18           C  
ATOM    210  NZ  LYS A  29     -19.911 126.230  16.365  1.00 57.72           N  
ATOM    211  N   ARG A  30     -18.841 118.885  14.150  1.00 51.47           N  
ATOM    212  CA  ARG A  30     -18.001 117.698  13.872  1.00 51.43           C  
ATOM    213  C   ARG A  30     -18.082 116.685  15.018  1.00 50.88           C  
ATOM    214  O   ARG A  30     -17.130 115.942  15.271  1.00 50.18           O  
ATOM    215  CB  ARG A  30     -16.539 118.084  13.566  1.00 51.57           C  
ATOM    216  CG  ARG A  30     -16.176 118.200  12.065  1.00 54.10           C  
ATOM    217  CD  ARG A  30     -17.025 119.254  11.380  1.00 58.64           C  
ATOM    218  NE  ARG A  30     -17.036 119.161   9.917  1.00 61.84           N  
ATOM    219  CZ  ARG A  30     -17.985 119.688   9.143  1.00 63.02           C  
ATOM    220  NH1 ARG A  30     -17.910 119.569   7.828  1.00 64.27           N  
ATOM    221  NH2 ARG A  30     -19.027 120.317   9.680  1.00 62.84           N  
ATOM    222  N   ASN A  31     -19.245 116.702  15.687  1.00 49.91           N  
ATOM    223  CA  ASN A  31     -19.617 115.849  16.833  1.00 48.60           C  
ATOM    224  C   ASN A  31     -18.717 116.083  18.036  1.00 47.78           C  
ATOM    225  O   ASN A  31     -18.426 115.154  18.826  1.00 46.86           O  
ATOM    226  CB  ASN A  31     -19.691 114.371  16.451  1.00 49.00           C  
ATOM    227  CG  ASN A  31     -20.550 114.123  15.216  1.00 49.97           C  
ATOM    228  OD1 ASN A  31     -21.618 114.722  15.055  1.00 50.81           O  
ATOM    229  ND2 ASN A  31     -20.111 113.210  14.364  1.00 49.85           N  
ATOM    230  N   ALA A  32     -18.294 117.338  18.176  1.00 46.82           N  
ATOM    231  CA  ALA A  32     -17.413 117.717  19.280  1.00 47.20           C  
ATOM    232  C   ALA A  32     -18.121 117.443  20.599  1.00 46.91           C  
ATOM    233  O   ALA A  32     -19.348 117.622  20.721  1.00 47.26           O  
ATOM    234  CB  ALA A  32     -16.901 119.170  19.160  1.00 46.79           C  
ATOM    235  N   MET A  33     -17.354 116.926  21.564  1.00 46.65           N  
ATOM    236  CA  MET A  33     -17.925 116.472  22.843  1.00 45.89           C  
ATOM    237  C   MET A  33     -18.083 117.579  23.890  1.00 44.87           C  
ATOM    238  O   MET A  33     -17.152 117.876  24.603  1.00 44.89           O  
ATOM    239  CB  MET A  33     -17.109 115.300  23.369  1.00 45.68           C  
ATOM    240  CG  MET A  33     -17.080 114.147  22.376  1.00 45.55           C  
ATOM    241  SD  MET A  33     -16.125 112.748  22.914  1.00 46.25           S  
ATOM    242  CE  MET A  33     -14.573 113.180  22.202  1.00 47.16           C  
ATOM    243  N   SER A  34     -19.260 118.209  23.934  1.00 44.15           N  
ATOM    244  CA  SER A  34     -19.608 119.216  24.947  1.00 43.25           C  
ATOM    245  C   SER A  34     -20.071 118.554  26.218  1.00 43.48           C  
ATOM    246  O   SER A  34     -20.441 117.369  26.197  1.00 44.04           O  
ATOM    247  CB  SER A  34     -20.757 120.080  24.463  1.00 43.01           C  
ATOM    248  OG  SER A  34     -21.834 119.262  24.101  1.00 41.06           O  
ATOM    249  N   PRO A  35     -20.069 119.307  27.348  1.00 43.50           N  
ATOM    250  CA  PRO A  35     -20.681 118.762  28.557  1.00 43.27           C  
ATOM    251  C   PRO A  35     -22.101 118.225  28.318  1.00 44.36           C  
ATOM    252  O   PRO A  35     -22.510 117.259  28.962  1.00 45.36           O  
ATOM    253  CB  PRO A  35     -20.685 119.963  29.504  1.00 43.37           C  
ATOM    254  CG  PRO A  35     -19.528 120.758  29.102  1.00 41.97           C  
ATOM    255  CD  PRO A  35     -19.478 120.638  27.602  1.00 42.74           C  
ATOM    256  N   THR A  36     -22.853 118.826  27.404  1.00 44.13           N  
ATOM    257  CA  THR A  36     -24.227 118.392  27.174  1.00 43.82           C  
ATOM    258  C   THR A  36     -24.227 116.965  26.604  1.00 44.65           C  
ATOM    259  O   THR A  36     -24.936 116.094  27.123  1.00 45.79           O  
ATOM    260  CB  THR A  36     -25.051 119.415  26.329  1.00 43.88           C  
ATOM    261  OG1 THR A  36     -25.274 120.585  27.122  1.00 41.39           O  
ATOM    262  CG2 THR A  36     -26.419 118.818  25.936  1.00 43.59           C  
ATOM    263  N   LEU A  37     -23.401 116.742  25.578  1.00 44.41           N  
ATOM    264  CA  LEU A  37     -23.117 115.432  25.018  1.00 44.93           C  
ATOM    265  C   LEU A  37     -22.659 114.381  26.064  1.00 45.24           C  
ATOM    266  O   LEU A  37     -23.127 113.253  26.039  1.00 46.46           O  
ATOM    267  CB  LEU A  37     -22.065 115.562  23.905  1.00 45.04           C  
ATOM    268  CG  LEU A  37     -21.922 114.339  23.012  1.00 44.99           C  
ATOM    269  CD1 LEU A  37     -21.840 114.751  21.599  1.00 41.95           C  
ATOM    270  CD2 LEU A  37     -20.715 113.513  23.423  1.00 47.74           C  
ATOM    271  N   ASN A  38     -21.784 114.771  26.981  1.00 44.58           N  
ATOM    272  CA  ASN A  38     -21.291 113.883  27.994  1.00 44.60           C  
ATOM    273  C   ASN A  38     -22.421 113.382  28.921  1.00 45.20           C  
ATOM    274  O   ASN A  38     -22.561 112.175  29.101  1.00 45.80           O  
ATOM    275  CB  ASN A  38     -20.115 114.513  28.775  1.00 42.98           C  
ATOM    276  CG  ASN A  38     -18.895 114.796  27.890  1.00 41.68           C  
ATOM    277  OD1 ASN A  38     -18.664 114.130  26.877  1.00 41.98           O  
ATOM    278  ND2 ASN A  38     -18.089 115.760  28.299  1.00 35.48           N  
ATOM    279  N   ARG A  39     -23.223 114.302  29.469  1.00 46.03           N  
ATOM    280  CA  ARG A  39     -24.394 113.974  30.276  1.00 46.85           C  
ATOM    281  C   ARG A  39     -25.337 113.062  29.506  1.00 47.38           C  
ATOM    282  O   ARG A  39     -25.779 112.049  30.065  1.00 48.83           O  
ATOM    283  CB  ARG A  39     -25.146 115.246  30.700  1.00 46.78           C  
ATOM    284  CG  ARG A  39     -24.330 116.121  31.638  1.00 48.11           C  
ATOM    285  CD  ARG A  39     -25.141 117.246  32.292  1.00 47.94           C  
ATOM    286  NE  ARG A  39     -25.057 118.466  31.482  1.00 50.79           N  
ATOM    287  CZ  ARG A  39     -24.047 119.347  31.533  1.00 52.07           C  
ATOM    288  NH1 ARG A  39     -23.003 119.166  32.367  1.00 50.49           N  
ATOM    289  NH2 ARG A  39     -24.089 120.424  30.748  1.00 51.46           N  
ATOM    290  N   GLU A  40     -25.636 113.383  28.237  1.00 46.15           N  
ATOM    291  CA  GLU A  40     -26.649 112.583  27.483  1.00 45.38           C  
ATOM    292  C   GLU A  40     -26.181 111.165  27.179  1.00 44.75           C  
ATOM    293  O   GLU A  40     -26.984 110.196  27.255  1.00 44.30           O  
ATOM    294  CB  GLU A  40     -27.103 113.265  26.205  1.00 44.56           C  
ATOM    295  CG  GLU A  40     -27.798 114.565  26.451  1.00 46.81           C  
ATOM    296  CD  GLU A  40     -28.488 115.088  25.216  1.00 49.42           C  
ATOM    297  OE1 GLU A  40     -27.875 115.028  24.142  1.00 51.43           O  
ATOM    298  OE2 GLU A  40     -29.643 115.567  25.314  1.00 50.16           O  
ATOM    299  N   MET A  41     -24.879 111.058  26.875  1.00 44.45           N  
ATOM    300  CA  MET A  41     -24.203 109.758  26.651  1.00 43.09           C  
ATOM    301  C   MET A  41     -24.242 108.845  27.851  1.00 41.58           C  
ATOM    302  O   MET A  41     -24.446 107.666  27.705  1.00 41.10           O  
ATOM    303  CB  MET A  41     -22.776 109.941  26.169  1.00 43.61           C  
ATOM    304  CG  MET A  41     -22.666 110.266  24.656  1.00 43.49           C  
ATOM    305  SD  MET A  41     -23.405 109.019  23.558  1.00 42.52           S  
ATOM    306  CE  MET A  41     -22.412 107.575  24.043  1.00 43.93           C  
ATOM    307  N   ILE A  42     -24.072 109.401  29.041  1.00 41.69           N  
ATOM    308  CA  ILE A  42     -24.284 108.639  30.275  1.00 41.29           C  
ATOM    309  C   ILE A  42     -25.688 108.030  30.273  1.00 41.62           C  
ATOM    310  O   ILE A  42     -25.875 106.807  30.427  1.00 41.48           O  
ATOM    311  CB  ILE A  42     -24.149 109.534  31.563  1.00 41.94           C  
ATOM    312  CG1 ILE A  42     -22.743 110.169  31.670  1.00 39.81           C  
ATOM    313  CG2 ILE A  42     -24.670 108.740  32.818  1.00 39.49           C  
ATOM    314  CD1 ILE A  42     -22.530 111.134  32.824  1.00 39.86           C  
ATOM    315  N   ASP A  43     -26.660 108.912  30.062  1.00 42.19           N  
ATOM    316  CA  ASP A  43     -28.086 108.569  30.028  1.00 43.62           C  
ATOM    317  C   ASP A  43     -28.396 107.527  28.946  1.00 43.17           C  
ATOM    318  O   ASP A  43     -29.118 106.566  29.206  1.00 43.14           O  
ATOM    319  CB  ASP A  43     -28.900 109.842  29.752  1.00 44.36           C  
ATOM    320  CG  ASP A  43     -30.391 109.610  29.821  1.00 46.61           C  
ATOM    321  OD1 ASP A  43     -30.832 108.673  30.531  1.00 46.79           O  
ATOM    322  OD2 ASP A  43     -31.114 110.399  29.170  1.00 51.94           O  
ATOM    323  N   VAL A  44     -27.858 107.746  27.746  1.00 42.17           N  
ATOM    324  CA  VAL A  44     -27.939 106.785  26.649  1.00 41.72           C  
ATOM    325  C   VAL A  44     -27.442 105.383  27.031  1.00 42.89           C  
ATOM    326  O   VAL A  44     -28.186 104.412  26.844  1.00 42.04           O  
ATOM    327  CB  VAL A  44     -27.134 107.279  25.440  1.00 41.08           C  
ATOM    328  CG1 VAL A  44     -26.919 106.156  24.424  1.00 39.99           C  
ATOM    329  CG2 VAL A  44     -27.803 108.493  24.832  1.00 40.81           C  
ATOM    330  N   LEU A  45     -26.196 105.306  27.548  1.00 43.42           N  
ATOM    331  CA  LEU A  45     -25.519 104.034  27.876  1.00 44.31           C  
ATOM    332  C   LEU A  45     -26.197 103.277  29.005  1.00 45.72           C  
ATOM    333  O   LEU A  45     -26.224 102.050  29.009  1.00 46.31           O  
ATOM    334  CB  LEU A  45     -24.050 104.249  28.259  1.00 42.74           C  
ATOM    335  CG  LEU A  45     -23.134 104.760  27.172  1.00 40.74           C  
ATOM    336  CD1 LEU A  45     -21.696 104.689  27.663  1.00 37.73           C  
ATOM    337  CD2 LEU A  45     -23.314 103.980  25.862  1.00 40.13           C  
ATOM    338  N   GLU A  46     -26.740 104.016  29.963  1.00 47.28           N  
ATOM    339  CA  GLU A  46     -27.519 103.429  31.029  1.00 48.69           C  
ATOM    340  C   GLU A  46     -28.852 102.831  30.510  1.00 49.64           C  
ATOM    341  O   GLU A  46     -29.181 101.665  30.806  1.00 51.05           O  
ATOM    342  CB  GLU A  46     -27.777 104.490  32.086  1.00 49.22           C  
ATOM    343  CG  GLU A  46     -26.590 104.713  32.993  1.00 50.45           C  
ATOM    344  CD  GLU A  46     -26.750 105.895  33.945  1.00 52.73           C  
ATOM    345  OE1 GLU A  46     -27.643 106.745  33.768  1.00 55.94           O  
ATOM    346  OE2 GLU A  46     -25.959 105.984  34.890  1.00 55.89           O  
ATOM    347  N   THR A  47     -29.603 103.629  29.747  1.00 49.41           N  
ATOM    348  CA  THR A  47     -30.861 103.218  29.099  1.00 49.20           C  
ATOM    349  C   THR A  47     -30.714 102.027  28.178  1.00 48.68           C  
ATOM    350  O   THR A  47     -31.537 101.111  28.210  1.00 49.48           O  
ATOM    351  CB  THR A  47     -31.443 104.373  28.296  1.00 48.91           C  
ATOM    352  OG1 THR A  47     -31.620 105.458  29.196  1.00 50.86           O  
ATOM    353  CG2 THR A  47     -32.813 104.028  27.697  1.00 48.34           C  
ATOM    354  N   LEU A  48     -29.685 102.038  27.351  1.00 47.50           N  
ATOM    355  CA  LEU A  48     -29.451 100.916  26.453  1.00 46.60           C  
ATOM    356  C   LEU A  48     -29.049  99.603  27.189  1.00 46.71           C  
ATOM    357  O   LEU A  48     -29.284  98.486  26.673  1.00 45.96           O  
ATOM    358  CB  LEU A  48     -28.457 101.308  25.353  1.00 45.78           C  
ATOM    359  CG  LEU A  48     -28.974 102.244  24.254  1.00 45.24           C  
ATOM    360  CD1 LEU A  48     -27.869 102.691  23.245  1.00 42.31           C  
ATOM    361  CD2 LEU A  48     -30.146 101.560  23.491  1.00 43.23           C  
ATOM    362  N   GLU A  49     -28.493  99.747  28.400  1.00 46.29           N  
ATOM    363  CA  GLU A  49     -28.051  98.617  29.196  1.00 46.37           C  
ATOM    364  C   GLU A  49     -29.251  97.769  29.675  1.00 46.53           C  
ATOM    365  O   GLU A  49     -29.123  96.567  29.926  1.00 46.13           O  
ATOM    366  CB  GLU A  49     -27.226  99.092  30.410  1.00 46.44           C  
ATOM    367  CG  GLU A  49     -26.435  97.971  31.042  1.00 47.83           C  
ATOM    368  CD  GLU A  49     -26.114  98.162  32.517  1.00 51.45           C  
ATOM    369  OE1 GLU A  49     -26.976  98.572  33.338  1.00 54.82           O  
ATOM    370  OE2 GLU A  49     -24.971  97.876  32.875  1.00 52.43           O  
ATOM    371  N   GLN A  50     -30.405  98.404  29.820  1.00 47.12           N  
ATOM    372  CA  GLN A  50     -31.567  97.762  30.454  1.00 48.39           C  
ATOM    373  C   GLN A  50     -32.617  97.399  29.428  1.00 48.78           C  
ATOM    374  O   GLN A  50     -33.632  96.799  29.758  1.00 50.12           O  
ATOM    375  CB  GLN A  50     -32.145  98.698  31.521  1.00 48.27           C  
ATOM    376  CG  GLN A  50     -31.151  98.980  32.668  1.00 49.21           C  
ATOM    377  CD  GLN A  50     -30.870  97.720  33.506  1.00 50.87           C  
ATOM    378  OE1 GLN A  50     -29.711  97.376  33.793  1.00 52.86           O  
ATOM    379  NE2 GLN A  50     -31.934  97.032  33.896  1.00 48.32           N  
ATOM    380  N   ASP A  51     -32.368  97.787  28.186  1.00 49.25           N  
ATOM    381  CA  ASP A  51     -33.262  97.540  27.072  1.00 50.13           C  
ATOM    382  C   ASP A  51     -32.962  96.152  26.508  1.00 50.82           C  
ATOM    383  O   ASP A  51     -31.837  95.945  26.015  1.00 51.03           O  
ATOM    384  CB  ASP A  51     -33.034  98.601  25.997  1.00 49.69           C  
ATOM    385  CG  ASP A  51     -34.045  98.535  24.865  1.00 50.88           C  
ATOM    386  OD1 ASP A  51     -34.903  97.629  24.868  1.00 53.69           O  
ATOM    387  OD2 ASP A  51     -33.979  99.388  23.946  1.00 52.55           O  
ATOM    388  N   PRO A  52     -33.944  95.194  26.577  1.00 50.90           N  
ATOM    389  CA  PRO A  52     -33.766  93.888  25.920  1.00 50.83           C  
ATOM    390  C   PRO A  52     -33.532  94.040  24.422  1.00 50.77           C  
ATOM    391  O   PRO A  52     -32.837  93.213  23.824  1.00 51.35           O  
ATOM    392  CB  PRO A  52     -35.094  93.160  26.195  1.00 50.15           C  
ATOM    393  CG  PRO A  52     -35.630  93.788  27.392  1.00 49.28           C  
ATOM    394  CD  PRO A  52     -35.257  95.244  27.259  1.00 51.56           C  
ATOM    395  N   ALA A  53     -34.061  95.113  23.834  1.00 50.80           N  
ATOM    396  CA  ALA A  53     -33.977  95.320  22.372  1.00 51.00           C  
ATOM    397  C   ALA A  53     -32.536  95.425  21.804  1.00 50.55           C  
ATOM    398  O   ALA A  53     -32.235  94.807  20.791  1.00 51.31           O  
ATOM    399  CB  ALA A  53     -34.873  96.522  21.923  1.00 50.84           C  
ATOM    400  N   ALA A  54     -31.668  96.185  22.475  1.00 50.12           N  
ATOM    401  CA  ALA A  54     -30.233  96.341  22.135  1.00 48.68           C  
ATOM    402  C   ALA A  54     -29.375  95.185  22.611  1.00 47.77           C  
ATOM    403  O   ALA A  54     -29.292  94.923  23.796  1.00 47.65           O  
ATOM    404  CB  ALA A  54     -29.707  97.615  22.774  1.00 48.70           C  
ATOM    405  N   GLY A  55     -28.706  94.516  21.697  1.00 47.16           N  
ATOM    406  CA  GLY A  55     -27.865  93.383  22.064  1.00 46.77           C  
ATOM    407  C   GLY A  55     -26.381  93.675  21.880  1.00 46.62           C  
ATOM    408  O   GLY A  55     -25.531  93.042  22.515  1.00 47.06           O  
ATOM    409  N   VAL A  56     -26.087  94.645  21.013  1.00 46.03           N  
ATOM    410  CA  VAL A  56     -24.722  95.079  20.676  1.00 45.76           C  
ATOM    411  C   VAL A  56     -24.858  96.548  20.287  1.00 45.46           C  
ATOM    412  O   VAL A  56     -25.832  96.914  19.620  1.00 43.84           O  
ATOM    413  CB  VAL A  56     -24.031  94.214  19.535  1.00 44.73           C  
ATOM    414  CG1 VAL A  56     -24.963  94.001  18.395  1.00 46.11           C  
ATOM    415  CG2 VAL A  56     -22.700  94.825  19.076  1.00 45.20           C  
ATOM    416  N   LEU A  57     -23.923  97.377  20.772  1.00 44.31           N  
ATOM    417  CA  LEU A  57     -23.960  98.799  20.481  1.00 43.87           C  
ATOM    418  C   LEU A  57     -22.864  99.195  19.507  1.00 43.59           C  
ATOM    419  O   LEU A  57     -21.794  98.665  19.543  1.00 43.35           O  
ATOM    420  CB  LEU A  57     -23.877  99.632  21.757  1.00 44.25           C  
ATOM    421  CG  LEU A  57     -25.132  99.943  22.580  1.00 42.25           C  
ATOM    422  CD1 LEU A  57     -25.825  98.685  23.112  1.00 40.32           C  
ATOM    423  CD2 LEU A  57     -24.670 100.868  23.703  1.00 41.19           C  
ATOM    424  N   VAL A  58     -23.170 100.102  18.610  1.00 43.86           N  
ATOM    425  CA  VAL A  58     -22.245 100.468  17.569  1.00 45.13           C  
ATOM    426  C   VAL A  58     -22.144 101.981  17.672  1.00 45.42           C  
ATOM    427  O   VAL A  58     -23.172 102.677  17.630  1.00 45.64           O  
ATOM    428  CB  VAL A  58     -22.707 100.009  16.100  1.00 44.83           C  
ATOM    429  CG1 VAL A  58     -21.844 100.673  15.021  1.00 44.03           C  
ATOM    430  CG2 VAL A  58     -22.594  98.511  15.934  1.00 44.20           C  
ATOM    431  N   LEU A  59     -20.919 102.478  17.828  1.00 44.97           N  
ATOM    432  CA  LEU A  59     -20.756 103.872  18.214  1.00 44.89           C  
ATOM    433  C   LEU A  59     -20.155 104.600  17.085  1.00 44.17           C  
ATOM    434  O   LEU A  59     -19.006 104.339  16.687  1.00 43.72           O  
ATOM    435  CB  LEU A  59     -19.901 104.057  19.478  1.00 45.30           C  
ATOM    436  CG  LEU A  59     -19.578 105.530  19.832  1.00 45.53           C  
ATOM    437  CD1 LEU A  59     -20.840 106.330  20.209  1.00 43.24           C  
ATOM    438  CD2 LEU A  59     -18.549 105.582  20.973  1.00 44.83           C  
ATOM    439  N   THR A  60     -20.961 105.511  16.573  1.00 43.26           N  
ATOM    440  CA  THR A  60     -20.682 106.136  15.315  1.00 43.70           C  
ATOM    441  C   THR A  60     -21.063 107.621  15.337  1.00 43.90           C  
ATOM    442  O   THR A  60     -21.626 108.109  16.316  1.00 42.44           O  
ATOM    443  CB  THR A  60     -21.261 105.283  14.122  1.00 43.88           C  
ATOM    444  OG1 THR A  60     -20.490 105.523  12.952  1.00 42.31           O  
ATOM    445  CG2 THR A  60     -22.765 105.507  13.842  1.00 44.50           C  
ATOM    446  N   GLY A  61     -20.711 108.338  14.272  1.00 44.61           N  
ATOM    447  CA  GLY A  61     -20.938 109.789  14.224  1.00 45.56           C  
ATOM    448  C   GLY A  61     -21.776 110.261  13.034  1.00 45.93           C  
ATOM    449  O   GLY A  61     -21.630 109.755  11.902  1.00 45.19           O  
ATOM    450  N   ALA A  62     -22.665 111.222  13.302  1.00 46.26           N  
ATOM    451  CA  ALA A  62     -23.449 111.825  12.258  1.00 46.71           C  
ATOM    452  C   ALA A  62     -22.519 112.680  11.378  1.00 47.33           C  
ATOM    453  O   ALA A  62     -21.627 113.375  11.911  1.00 47.33           O  
ATOM    454  CB  ALA A  62     -24.597 112.666  12.859  1.00 46.67           C  
ATOM    455  N   GLY A  63     -22.700 112.603  10.049  1.00 46.72           N  
ATOM    456  CA  GLY A  63     -21.969 113.475   9.136  1.00 47.27           C  
ATOM    457  C   GLY A  63     -20.580 112.937   8.861  1.00 48.11           C  
ATOM    458  O   GLY A  63     -20.376 111.722   8.867  1.00 48.57           O  
ATOM    459  N   GLU A  64     -19.616 113.838   8.647  1.00 48.33           N  
ATOM    460  CA  GLU A  64     -18.257 113.461   8.222  1.00 49.05           C  
ATOM    461  C   GLU A  64     -17.348 112.974   9.355  1.00 48.22           C  
ATOM    462  O   GLU A  64     -16.359 112.290   9.100  1.00 48.68           O  
ATOM    463  CB  GLU A  64     -17.545 114.652   7.584  1.00 48.56           C  
ATOM    464  CG  GLU A  64     -18.180 115.365   6.382  1.00 51.47           C  
ATOM    465  CD  GLU A  64     -17.194 116.431   5.849  1.00 52.33           C  
ATOM    466  OE1 GLU A  64     -16.172 116.777   6.551  1.00 58.09           O  
ATOM    467  OE2 GLU A  64     -17.422 116.911   4.734  1.00 55.64           O  
ATOM    468  N   ALA A  65     -17.636 113.395  10.584  1.00 47.05           N  
ATOM    469  CA  ALA A  65     -16.798 113.076  11.725  1.00 46.33           C  
ATOM    470  C   ALA A  65     -17.309 111.857  12.506  1.00 46.36           C  
ATOM    471  O   ALA A  65     -18.522 111.590  12.602  1.00 45.38           O  
ATOM    472  CB  ALA A  65     -16.704 114.264  12.637  1.00 45.84           C  
ATOM    473  N   TRP A  66     -16.360 111.094  13.039  1.00 46.20           N  
ATOM    474  CA  TRP A  66     -16.690 110.203  14.093  1.00 46.13           C  
ATOM    475  C   TRP A  66     -16.874 111.150  15.311  1.00 45.75           C  
ATOM    476  O   TRP A  66     -18.001 111.412  15.706  1.00 44.66           O  
ATOM    477  CB  TRP A  66     -15.632 109.101  14.237  1.00 45.68           C  
ATOM    478  CG  TRP A  66     -16.042 108.072  15.252  1.00 46.56           C  
ATOM    479  CD1 TRP A  66     -17.087 107.157  15.156  1.00 45.29           C  
ATOM    480  CD2 TRP A  66     -15.436 107.858  16.543  1.00 48.33           C  
ATOM    481  NE1 TRP A  66     -17.143 106.387  16.306  1.00 48.63           N  
ATOM    482  CE2 TRP A  66     -16.151 106.795  17.175  1.00 48.59           C  
ATOM    483  CE3 TRP A  66     -14.379 108.481  17.245  1.00 46.18           C  
ATOM    484  CZ2 TRP A  66     -15.825 106.338  18.472  1.00 47.09           C  
ATOM    485  CZ3 TRP A  66     -14.069 108.026  18.517  1.00 46.37           C  
ATOM    486  CH2 TRP A  66     -14.792 106.960  19.120  1.00 44.34           C  
ATOM    487  N   THR A  67     -15.772 111.694  15.842  1.00 46.45           N  
ATOM    488  CA  THR A  67     -15.767 112.896  16.731  1.00 47.35           C  
ATOM    489  C   THR A  67     -14.435 113.674  16.565  1.00 48.10           C  
ATOM    490  O   THR A  67     -13.364 113.079  16.394  1.00 47.96           O  
ATOM    491  CB  THR A  67     -16.089 112.583  18.268  1.00 47.03           C  
ATOM    492  OG1 THR A  67     -15.911 113.752  19.075  1.00 47.18           O  
ATOM    493  CG2 THR A  67     -15.182 111.532  18.849  1.00 47.09           C  
ATOM    494  N   ALA A  68     -14.519 114.999  16.578  1.00 49.10           N  
ATOM    495  CA  ALA A  68     -13.339 115.863  16.430  1.00 49.58           C  
ATOM    496  C   ALA A  68     -12.688 116.166  17.827  1.00 50.17           C  
ATOM    497  O   ALA A  68     -11.815 117.089  17.970  1.00 50.55           O  
ATOM    498  CB  ALA A  68     -13.695 117.150  15.652  1.00 48.80           C  
ATOM    499  N   GLY A  69     -13.108 115.365  18.820  1.00 49.37           N  
ATOM    500  CA  GLY A  69     -12.636 115.430  20.193  1.00 49.44           C  
ATOM    501  C   GLY A  69     -13.480 116.332  21.072  1.00 50.12           C  
ATOM    502  O   GLY A  69     -14.621 116.593  20.733  1.00 49.05           O  
ATOM    503  N   MET A  70     -12.911 116.816  22.195  1.00 50.94           N  
ATOM    504  CA  MET A  70     -13.658 117.704  23.100  1.00 51.93           C  
ATOM    505  C   MET A  70     -14.000 119.073  22.495  1.00 51.24           C  
ATOM    506  O   MET A  70     -13.208 119.675  21.786  1.00 50.01           O  
ATOM    507  CB  MET A  70     -12.999 117.881  24.493  1.00 52.63           C  
ATOM    508  CG  MET A  70     -12.690 116.597  25.277  1.00 56.54           C  
ATOM    509  SD  MET A  70     -13.944 115.275  25.608  1.00 62.40           S  
ATOM    510  CE  MET A  70     -15.045 115.997  26.862  1.00 62.45           C  
ATOM    511  N   ASP A  71     -15.212 119.535  22.793  1.00 52.19           N  
ATOM    512  CA  ASP A  71     -15.680 120.865  22.432  1.00 54.09           C  
ATOM    513  C   ASP A  71     -14.937 121.957  23.242  1.00 55.84           C  
ATOM    514  O   ASP A  71     -15.200 122.139  24.456  1.00 55.01           O  
ATOM    515  CB  ASP A  71     -17.182 120.932  22.703  1.00 54.09           C  
ATOM    516  CG  ASP A  71     -17.861 122.073  21.998  1.00 54.40           C  
ATOM    517  OD1 ASP A  71     -17.409 123.224  22.122  1.00 54.80           O  
ATOM    518  OD2 ASP A  71     -18.881 121.811  21.334  1.00 56.52           O  
ATOM    519  N   LEU A  72     -14.012 122.656  22.564  1.00 57.60           N  
ATOM    520  CA  LEU A  72     -13.301 123.837  23.100  1.00 58.96           C  
ATOM    521  C   LEU A  72     -14.215 125.066  23.045  1.00 59.51           C  
ATOM    522  O   LEU A  72     -14.645 125.566  24.084  1.00 60.30           O  
ATOM    523  N   ALA A  81     -14.376 128.858  33.211  1.00 66.85           N  
ATOM    524  CA  ALA A  81     -15.782 128.464  33.391  1.00 66.18           C  
ATOM    525  C   ALA A  81     -16.447 129.277  34.528  1.00 66.25           C  
ATOM    526  O   ALA A  81     -16.593 130.524  34.418  1.00 65.88           O  
ATOM    527  CB  ALA A  81     -15.899 126.919  33.628  1.00 66.15           C  
ATOM    528  N   GLY A  82     -16.831 128.553  35.599  1.00 65.67           N  
ATOM    529  CA  GLY A  82     -17.579 129.060  36.810  1.00 64.10           C  
ATOM    530  C   GLY A  82     -16.709 128.812  38.045  1.00 61.26           C  
ATOM    531  O   GLY A  82     -15.488 129.059  37.962  1.00 61.96           O  
ATOM    532  N   PRO A  83     -17.287 128.274  39.169  1.00 58.98           N  
ATOM    533  CA  PRO A  83     -16.443 127.927  40.361  1.00 56.04           C  
ATOM    534  C   PRO A  83     -15.498 126.770  40.037  1.00 53.16           C  
ATOM    535  O   PRO A  83     -15.800 125.948  39.138  1.00 52.21           O  
ATOM    536  CB  PRO A  83     -17.452 127.510  41.437  1.00 56.41           C  
ATOM    537  CG  PRO A  83     -18.698 127.107  40.692  1.00 58.41           C  
ATOM    538  CD  PRO A  83     -18.710 127.920  39.376  1.00 59.45           C  
ATOM    539  N   GLU A  84     -14.361 126.717  40.732  1.00 49.97           N  
ATOM    540  CA  GLU A  84     -13.330 125.670  40.472  1.00 47.40           C  
ATOM    541  C   GLU A  84     -13.930 124.234  40.438  1.00 44.78           C  
ATOM    542  O   GLU A  84     -13.604 123.448  39.518  1.00 43.59           O  
ATOM    543  CB  GLU A  84     -12.185 125.755  41.501  1.00 47.41           C  
ATOM    544  CG  GLU A  84     -10.993 124.756  41.275  1.00 50.15           C  
ATOM    545  CD  GLU A  84     -11.294 123.262  41.621  1.00 52.26           C  
ATOM    546  OE1 GLU A  84     -12.211 122.974  42.435  1.00 50.52           O  
ATOM    547  OE2 GLU A  84     -10.578 122.376  41.076  1.00 52.31           O  
ATOM    548  N   ILE A  85     -14.791 123.931  41.435  1.00 41.64           N  
ATOM    549  CA  ILE A  85     -15.490 122.647  41.592  1.00 40.34           C  
ATOM    550  C   ILE A  85     -16.238 122.169  40.366  1.00 39.82           C  
ATOM    551  O   ILE A  85     -16.320 120.964  40.103  1.00 40.02           O  
ATOM    552  CB  ILE A  85     -16.424 122.573  42.906  1.00 40.74           C  
ATOM    553  CG1 ILE A  85     -16.619 121.116  43.335  1.00 40.49           C  
ATOM    554  CG2 ILE A  85     -17.794 123.338  42.784  1.00 38.12           C  
ATOM    555  CD1 ILE A  85     -15.437 120.580  44.112  1.00 36.58           C  
ATOM    556  N   LEU A  86     -16.751 123.092  39.575  1.00 40.01           N  
ATOM    557  CA  LEU A  86     -17.488 122.663  38.381  1.00 41.84           C  
ATOM    558  C   LEU A  86     -16.703 121.713  37.461  1.00 42.50           C  
ATOM    559  O   LEU A  86     -17.303 120.794  36.885  1.00 43.76           O  
ATOM    560  CB  LEU A  86     -18.043 123.868  37.616  1.00 41.40           C  
ATOM    561  CG  LEU A  86     -18.984 123.596  36.446  1.00 44.06           C  
ATOM    562  CD1 LEU A  86     -20.174 122.631  36.795  1.00 46.24           C  
ATOM    563  CD2 LEU A  86     -19.463 124.945  35.926  1.00 46.38           C  
ATOM    564  N   GLN A  87     -15.391 121.969  37.310  1.00 43.22           N  
ATOM    565  CA  GLN A  87     -14.415 121.153  36.513  1.00 45.08           C  
ATOM    566  C   GLN A  87     -14.344 119.683  36.908  1.00 44.20           C  
ATOM    567  O   GLN A  87     -14.293 118.813  36.039  1.00 43.30           O  
ATOM    568  CB  GLN A  87     -12.996 121.728  36.675  1.00 44.52           C  
ATOM    569  CG  GLN A  87     -12.032 121.314  35.587  1.00 47.58           C  
ATOM    570  CD  GLN A  87     -10.603 121.898  35.783  1.00 48.70           C  
ATOM    571  OE1 GLN A  87      -9.946 121.704  36.843  1.00 50.70           O  
ATOM    572  NE2 GLN A  87     -10.131 122.614  34.770  1.00 48.00           N  
ATOM    573  N   GLU A  88     -14.290 119.425  38.223  1.00 44.49           N  
ATOM    574  CA  GLU A  88     -14.371 118.079  38.768  1.00 43.75           C  
ATOM    575  C   GLU A  88     -15.541 117.357  38.152  1.00 42.87           C  
ATOM    576  O   GLU A  88     -15.369 116.255  37.685  1.00 42.51           O  
ATOM    577  CB  GLU A  88     -14.589 118.087  40.293  1.00 44.82           C  
ATOM    578  CG  GLU A  88     -13.519 118.760  41.147  1.00 48.55           C  
ATOM    579  CD  GLU A  88     -12.251 117.978  41.119  1.00 57.69           C  
ATOM    580  OE1 GLU A  88     -12.109 117.078  41.999  1.00 60.47           O  
ATOM    581  OE2 GLU A  88     -11.440 118.204  40.168  1.00 62.23           O  
ATOM    582  N   LYS A  89     -16.732 117.983  38.149  1.00 42.56           N  
ATOM    583  CA  LYS A  89     -17.972 117.380  37.623  1.00 41.59           C  
ATOM    584  C   LYS A  89     -17.907 117.108  36.127  1.00 41.38           C  
ATOM    585  O   LYS A  89     -18.230 116.026  35.678  1.00 41.15           O  
ATOM    586  CB  LYS A  89     -19.162 118.313  37.902  1.00 41.81           C  
ATOM    587  CG  LYS A  89     -20.470 117.793  37.375  1.00 40.23           C  
ATOM    588  CD  LYS A  89     -21.709 118.560  37.956  1.00 43.68           C  
ATOM    589  N   ILE A  90     -17.479 118.119  35.367  1.00 40.50           N  
ATOM    590  CA  ILE A  90     -17.331 118.035  33.948  1.00 40.03           C  
ATOM    591  C   ILE A  90     -16.250 117.010  33.556  1.00 40.45           C  
ATOM    592  O   ILE A  90     -16.469 116.231  32.668  1.00 41.52           O  
ATOM    593  CB  ILE A  90     -17.147 119.483  33.320  1.00 40.31           C  
ATOM    594  CG1 ILE A  90     -18.484 120.264  33.396  1.00 39.59           C  
ATOM    595  CG2 ILE A  90     -16.626 119.439  31.867  1.00 38.70           C  
ATOM    596  CD1 ILE A  90     -18.344 121.686  32.940  1.00 40.60           C  
ATOM    597  N   ARG A  91     -15.103 116.984  34.220  1.00 39.54           N  
ATOM    598  CA  ARG A  91     -14.139 115.905  34.018  1.00 38.36           C  
ATOM    599  C   ARG A  91     -14.773 114.534  34.388  1.00 39.39           C  
ATOM    600  O   ARG A  91     -14.650 113.591  33.633  1.00 39.92           O  
ATOM    601  CB  ARG A  91     -12.845 116.184  34.802  1.00 36.87           C  
ATOM    602  CG  ARG A  91     -12.047 117.364  34.194  1.00 34.97           C  
ATOM    603  CD  ARG A  91     -10.755 117.640  34.945  1.00 35.70           C  
ATOM    604  NE  ARG A  91      -9.870 118.571  34.223  1.00 34.61           N  
ATOM    605  CZ  ARG A  91      -8.722 119.008  34.709  1.00 34.27           C  
ATOM    606  NH1 ARG A  91      -8.359 118.595  35.909  1.00 32.41           N  
ATOM    607  NH2 ARG A  91      -7.929 119.816  34.005  1.00 32.89           N  
ATOM    608  N   ARG A  92     -15.528 114.444  35.486  1.00 40.33           N  
ATOM    609  CA  ARG A  92     -16.147 113.174  35.872  1.00 40.41           C  
ATOM    610  C   ARG A  92     -17.142 112.651  34.846  1.00 40.30           C  
ATOM    611  O   ARG A  92     -17.142 111.470  34.540  1.00 40.90           O  
ATOM    612  CB  ARG A  92     -16.827 113.277  37.212  1.00 41.63           C  
ATOM    613  CG  ARG A  92     -17.338 111.864  37.717  1.00 45.11           C  
ATOM    614  CD  ARG A  92     -18.327 111.991  38.866  1.00 46.22           C  
ATOM    615  NE  ARG A  92     -18.076 113.197  39.649  1.00 46.28           N  
ATOM    616  CZ  ARG A  92     -19.018 114.087  39.893  1.00 49.67           C  
ATOM    617  NH1 ARG A  92     -20.250 113.881  39.411  1.00 49.19           N  
ATOM    618  NH2 ARG A  92     -18.747 115.149  40.629  1.00 48.93           N  
ATOM    619  N   GLU A  93     -17.927 113.541  34.261  1.00 40.25           N  
ATOM    620  CA  GLU A  93     -18.977 113.155  33.323  1.00 40.28           C  
ATOM    621  C   GLU A  93     -18.431 112.813  31.953  1.00 39.66           C  
ATOM    622  O   GLU A  93     -18.985 111.917  31.287  1.00 39.55           O  
ATOM    623  CB  GLU A  93     -20.065 114.233  33.174  1.00 40.34           C  
ATOM    624  CG  GLU A  93     -20.542 114.838  34.446  1.00 41.57           C  
ATOM    625  CD  GLU A  93     -21.564 115.958  34.197  1.00 43.40           C  
ATOM    626  OE1 GLU A  93     -21.397 116.790  33.237  1.00 43.83           O  
ATOM    627  OE2 GLU A  93     -22.546 115.982  35.005  1.00 49.70           O  
ATOM    628  N   ALA A  94     -17.397 113.538  31.496  1.00 37.92           N  
ATOM    629  CA  ALA A  94     -16.603 113.055  30.366  1.00 37.21           C  
ATOM    630  C   ALA A  94     -16.219 111.580  30.640  1.00 37.92           C  
ATOM    631  O   ALA A  94     -16.576 110.729  29.888  1.00 39.05           O  
ATOM    632  CB  ALA A  94     -15.352 113.938  30.141  1.00 36.79           C  
ATOM    633  N   SER A  95     -15.499 111.260  31.713  1.00 38.92           N  
ATOM    634  CA  SER A  95     -14.980 109.898  31.864  1.00 40.09           C  
ATOM    635  C   SER A  95     -16.100 108.899  32.058  1.00 40.34           C  
ATOM    636  O   SER A  95     -15.946 107.743  31.729  1.00 39.96           O  
ATOM    637  CB  SER A  95     -14.093 109.756  33.092  1.00 40.12           C  
ATOM    638  OG  SER A  95     -13.307 110.887  33.370  1.00 44.27           O  
ATOM    639  N   GLN A  96     -17.223 109.349  32.627  1.00 41.22           N  
ATOM    640  CA  GLN A  96     -18.291 108.449  32.994  1.00 41.74           C  
ATOM    641  C   GLN A  96     -18.800 107.625  31.791  1.00 42.04           C  
ATOM    642  O   GLN A  96     -18.987 106.415  31.918  1.00 41.80           O  
ATOM    643  CB  GLN A  96     -19.400 109.202  33.733  1.00 41.77           C  
ATOM    644  CG  GLN A  96     -20.472 108.270  34.346  1.00 44.64           C  
ATOM    645  CD  GLN A  96     -19.920 107.306  35.418  1.00 49.61           C  
ATOM    646  OE1 GLN A  96     -18.738 107.379  35.810  1.00 52.48           O  
ATOM    647  NE2 GLN A  96     -20.777 106.419  35.902  1.00 48.27           N  
ATOM    648  N   TRP A  97     -18.971 108.255  30.620  1.00 41.44           N  
ATOM    649  CA  TRP A  97     -19.448 107.498  29.459  1.00 41.53           C  
ATOM    650  C   TRP A  97     -18.304 106.989  28.569  1.00 41.98           C  
ATOM    651  O   TRP A  97     -18.434 105.911  27.910  1.00 42.71           O  
ATOM    652  CB  TRP A  97     -20.477 108.271  28.609  1.00 40.45           C  
ATOM    653  CG  TRP A  97     -19.895 109.380  27.705  1.00 41.12           C  
ATOM    654  CD1 TRP A  97     -19.724 110.731  28.028  1.00 41.28           C  
ATOM    655  CD2 TRP A  97     -19.460 109.246  26.339  1.00 39.21           C  
ATOM    656  NE1 TRP A  97     -19.229 111.418  26.938  1.00 40.16           N  
ATOM    657  CE2 TRP A  97     -19.049 110.538  25.898  1.00 38.98           C  
ATOM    658  CE3 TRP A  97     -19.360 108.159  25.449  1.00 37.85           C  
ATOM    659  CZ2 TRP A  97     -18.569 110.763  24.624  1.00 37.92           C  
ATOM    660  CZ3 TRP A  97     -18.890 108.398  24.182  1.00 39.56           C  
ATOM    661  CH2 TRP A  97     -18.511 109.695  23.775  1.00 39.06           C  
ATOM    662  N   GLN A  98     -17.216 107.768  28.509  1.00 40.82           N  
ATOM    663  CA  GLN A  98     -16.159 107.477  27.570  1.00 40.66           C  
ATOM    664  C   GLN A  98     -15.518 106.134  27.870  1.00 40.11           C  
ATOM    665  O   GLN A  98     -15.127 105.431  26.940  1.00 41.26           O  
ATOM    666  CB  GLN A  98     -15.125 108.606  27.542  1.00 40.20           C  
ATOM    667  CG  GLN A  98     -15.668 109.872  26.835  1.00 41.56           C  
ATOM    668  CD  GLN A  98     -14.659 110.988  26.773  1.00 42.79           C  
ATOM    669  OE1 GLN A  98     -14.929 112.095  26.248  1.00 45.79           O  
ATOM    670  NE2 GLN A  98     -13.477 110.713  27.296  1.00 44.19           N  
ATOM    671  N   TRP A  99     -15.400 105.777  29.154  1.00 39.39           N  
ATOM    672  CA  TRP A  99     -14.734 104.544  29.518  1.00 38.95           C  
ATOM    673  C   TRP A  99     -15.223 103.906  30.838  1.00 40.16           C  
ATOM    674  O   TRP A  99     -15.210 102.676  30.958  1.00 40.87           O  
ATOM    675  CB  TRP A  99     -13.184 104.727  29.508  1.00 38.27           C  
ATOM    676  CG  TRP A  99     -12.677 105.854  30.448  1.00 37.93           C  
ATOM    677  CD1 TRP A  99     -12.546 107.169  30.137  1.00 35.98           C  
ATOM    678  CD2 TRP A  99     -12.324 105.741  31.845  1.00 35.37           C  
ATOM    679  NE1 TRP A  99     -12.106 107.868  31.210  1.00 33.70           N  
ATOM    680  CE2 TRP A  99     -11.940 107.023  32.274  1.00 37.76           C  
ATOM    681  CE3 TRP A  99     -12.238 104.665  32.754  1.00 37.54           C  
ATOM    682  CZ2 TRP A  99     -11.533 107.288  33.597  1.00 35.77           C  
ATOM    683  CZ3 TRP A  99     -11.837 104.912  34.058  1.00 34.73           C  
ATOM    684  CH2 TRP A  99     -11.501 106.226  34.470  1.00 36.38           C  
ATOM    685  N   LYS A 100     -15.619 104.708  31.824  1.00 40.39           N  
ATOM    686  CA  LYS A 100     -16.018 104.175  33.144  1.00 42.29           C  
ATOM    687  C   LYS A 100     -17.260 103.291  32.966  1.00 42.07           C  
ATOM    688  O   LYS A 100     -17.305 102.180  33.437  1.00 42.82           O  
ATOM    689  CB  LYS A 100     -16.332 105.284  34.158  1.00 40.41           C  
ATOM    690  CG  LYS A 100     -15.170 106.085  34.584  1.00 43.93           C  
ATOM    691  CD  LYS A 100     -15.449 106.966  35.864  1.00 43.98           C  
ATOM    692  CE  LYS A 100     -14.121 107.152  36.624  1.00 46.20           C  
ATOM    693  NZ  LYS A 100     -14.066 108.275  37.606  1.00 47.09           N  
ATOM    694  N   LEU A 101     -18.282 103.784  32.283  1.00 42.46           N  
ATOM    695  CA  LEU A 101     -19.355 102.878  31.888  1.00 42.58           C  
ATOM    696  C   LEU A 101     -18.908 102.035  30.705  1.00 42.74           C  
ATOM    697  O   LEU A 101     -19.146 100.830  30.729  1.00 45.28           O  
ATOM    698  CB  LEU A 101     -20.662 103.610  31.568  1.00 41.99           C  
ATOM    699  CG  LEU A 101     -21.489 104.247  32.680  1.00 41.76           C  
ATOM    700  CD1 LEU A 101     -22.552 105.206  32.126  1.00 38.09           C  
ATOM    701  CD2 LEU A 101     -22.140 103.124  33.472  1.00 41.67           C  
ATOM    702  N   LEU A 102     -18.268 102.633  29.689  1.00 41.20           N  
ATOM    703  CA  LEU A 102     -18.058 101.943  28.418  1.00 40.77           C  
ATOM    704  C   LEU A 102     -17.006 100.853  28.403  1.00 41.32           C  
ATOM    705  O   LEU A 102     -17.213  99.813  27.748  1.00 41.48           O  
ATOM    706  CB  LEU A 102     -17.788 102.923  27.268  1.00 41.93           C  
ATOM    707  CG  LEU A 102     -17.872 102.485  25.784  1.00 42.16           C  
ATOM    708  CD1 LEU A 102     -19.259 101.855  25.546  1.00 38.46           C  
ATOM    709  CD2 LEU A 102     -17.581 103.651  24.806  1.00 44.64           C  
ATOM    710  N   ARG A 103     -15.865 101.058  29.063  1.00 40.07           N  
ATOM    711  CA  ARG A 103     -14.809 100.061  28.901  1.00 39.52           C  
ATOM    712  C   ARG A 103     -15.240  98.622  29.323  1.00 39.19           C  
ATOM    713  O   ARG A 103     -14.999  97.647  28.619  1.00 39.19           O  
ATOM    714  CB  ARG A 103     -13.509 100.522  29.545  1.00 38.26           C  
ATOM    715  CG  ARG A 103     -12.440  99.513  29.546  1.00 37.25           C  
ATOM    716  CD  ARG A 103     -11.225 100.129  30.061  1.00 38.56           C  
ATOM    717  NE  ARG A 103     -10.136  99.198  30.249  1.00 31.66           N  
ATOM    718  CZ  ARG A 103      -9.669  98.773  31.411  1.00 36.91           C  
ATOM    719  NH1 ARG A 103     -10.230  99.139  32.555  1.00 35.58           N  
ATOM    720  NH2 ARG A 103      -8.630  97.931  31.412  1.00 37.57           N  
ATOM    721  N   MET A 104     -15.884  98.509  30.470  1.00 40.51           N  
ATOM    722  CA  MET A 104     -16.432  97.235  30.958  1.00 39.09           C  
ATOM    723  C   MET A 104     -17.993  97.218  30.803  1.00 40.05           C  
ATOM    724  O   MET A 104     -18.715  96.634  31.652  1.00 40.07           O  
ATOM    725  CB  MET A 104     -16.043  97.040  32.433  1.00 39.85           C  
ATOM    726  CG  MET A 104     -14.533  96.989  32.757  1.00 39.22           C  
ATOM    727  SD  MET A 104     -13.679  95.559  32.009  1.00 43.08           S  
ATOM    728  CE  MET A 104     -12.052  95.885  32.611  1.00 45.22           C  
ATOM    729  N   TYR A 105     -18.541  97.819  29.743  1.00 38.55           N  
ATOM    730  CA  TYR A 105     -20.011  97.779  29.533  1.00 38.37           C  
ATOM    731  C   TYR A 105     -20.575  96.338  29.492  1.00 38.96           C  
ATOM    732  O   TYR A 105     -19.924  95.436  28.936  1.00 39.83           O  
ATOM    733  CB  TYR A 105     -20.347  98.458  28.218  1.00 38.15           C  
ATOM    734  CG  TYR A 105     -21.792  98.974  28.058  1.00 39.42           C  
ATOM    735  CD1 TYR A 105     -22.600  98.510  27.016  1.00 39.06           C  
ATOM    736  CD2 TYR A 105     -22.334  99.938  28.941  1.00 37.35           C  
ATOM    737  CE1 TYR A 105     -23.894  98.994  26.825  1.00 38.43           C  
ATOM    738  CE2 TYR A 105     -23.616 100.423  28.761  1.00 39.14           C  
ATOM    739  CZ  TYR A 105     -24.392  99.947  27.675  1.00 38.47           C  
ATOM    740  OH  TYR A 105     -25.669 100.438  27.444  1.00 39.25           O  
ATOM    741  N   ALA A 106     -21.774  96.124  30.039  1.00 38.69           N  
ATOM    742  CA  ALA A 106     -22.409  94.793  30.035  1.00 40.46           C  
ATOM    743  C   ALA A 106     -22.519  94.108  28.652  1.00 41.03           C  
ATOM    744  O   ALA A 106     -22.279  92.905  28.517  1.00 41.32           O  
ATOM    745  CB  ALA A 106     -23.814  94.836  30.718  1.00 40.07           C  
ATOM    746  N   LYS A 107     -22.898  94.896  27.651  1.00 42.51           N  
ATOM    747  CA  LYS A 107     -23.123  94.429  26.296  1.00 43.41           C  
ATOM    748  C   LYS A 107     -21.921  94.699  25.367  1.00 43.76           C  
ATOM    749  O   LYS A 107     -21.145  95.661  25.572  1.00 43.73           O  
ATOM    750  CB  LYS A 107     -24.362  95.136  25.745  1.00 43.75           C  
ATOM    751  CG  LYS A 107     -25.609  94.874  26.591  1.00 45.80           C  
ATOM    752  CD  LYS A 107     -26.851  95.632  26.153  1.00 44.36           C  
ATOM    753  CE  LYS A 107     -28.062  94.946  26.796  1.00 46.66           C  
ATOM    754  NZ  LYS A 107     -29.261  95.703  26.412  1.00 49.15           N  
ATOM    755  N   PRO A 108     -21.773  93.874  24.311  1.00 44.16           N  
ATOM    756  CA  PRO A 108     -20.605  94.161  23.458  1.00 43.36           C  
ATOM    757  C   PRO A 108     -20.775  95.486  22.721  1.00 43.44           C  
ATOM    758  O   PRO A 108     -21.920  95.948  22.482  1.00 43.47           O  
ATOM    759  CB  PRO A 108     -20.549  92.967  22.495  1.00 42.99           C  
ATOM    760  CG  PRO A 108     -21.895  92.331  22.554  1.00 44.14           C  
ATOM    761  CD  PRO A 108     -22.578  92.723  23.829  1.00 42.81           C  
ATOM    762  N   THR A 109     -19.630  96.093  22.397  1.00 42.77           N  
ATOM    763  CA  THR A 109     -19.559  97.420  21.816  1.00 41.66           C  
ATOM    764  C   THR A 109     -18.534  97.388  20.707  1.00 42.52           C  
ATOM    765  O   THR A 109     -17.463  96.747  20.830  1.00 42.67           O  
ATOM    766  CB  THR A 109     -19.130  98.463  22.854  1.00 42.29           C  
ATOM    767  OG1 THR A 109     -17.803  98.170  23.350  1.00 39.19           O  
ATOM    768  CG2 THR A 109     -20.122  98.505  23.996  1.00 36.85           C  
ATOM    769  N   ILE A 110     -18.904  98.019  19.603  1.00 43.08           N  
ATOM    770  CA  ILE A 110     -18.022  98.224  18.467  1.00 43.65           C  
ATOM    771  C   ILE A 110     -18.018  99.698  18.073  1.00 43.71           C  
ATOM    772  O   ILE A 110     -19.068 100.306  17.857  1.00 44.06           O  
ATOM    773  CB  ILE A 110     -18.490  97.412  17.212  1.00 44.20           C  
ATOM    774  CG1 ILE A 110     -18.745  95.929  17.553  1.00 42.91           C  
ATOM    775  CG2 ILE A 110     -17.464  97.537  16.120  1.00 42.09           C  
ATOM    776  CD1 ILE A 110     -19.386  95.087  16.393  1.00 43.16           C  
ATOM    777  N   ALA A 111     -16.830 100.258  17.941  1.00 43.51           N  
ATOM    778  CA  ALA A 111     -16.681 101.587  17.340  1.00 43.35           C  
ATOM    779  C   ALA A 111     -16.657 101.450  15.829  1.00 43.08           C  
ATOM    780  O   ALA A 111     -15.846 100.705  15.286  1.00 43.53           O  
ATOM    781  CB  ALA A 111     -15.428 102.275  17.833  1.00 42.26           C  
ATOM    782  N   MET A 112     -17.572 102.157  15.171  1.00 42.41           N  
ATOM    783  CA  MET A 112     -17.618 102.258  13.724  1.00 42.67           C  
ATOM    784  C   MET A 112     -17.187 103.664  13.333  1.00 41.82           C  
ATOM    785  O   MET A 112     -17.998 104.598  13.305  1.00 40.62           O  
ATOM    786  CB  MET A 112     -19.022 101.952  13.200  1.00 42.82           C  
ATOM    787  CG  MET A 112     -19.168 101.877  11.653  1.00 43.52           C  
ATOM    788  SD  MET A 112     -20.804 101.321  11.103  1.00 45.51           S  
ATOM    789  CE  MET A 112     -21.895 102.617  11.648  1.00 45.91           C  
ATOM    790  N   VAL A 113     -15.896 103.787  13.038  1.00 41.95           N  
ATOM    791  CA  VAL A 113     -15.225 105.097  12.885  1.00 41.90           C  
ATOM    792  C   VAL A 113     -15.317 105.551  11.439  1.00 42.66           C  
ATOM    793  O   VAL A 113     -14.501 105.193  10.603  1.00 43.31           O  
ATOM    794  CB  VAL A 113     -13.763 105.067  13.400  1.00 41.11           C  
ATOM    795  CG1 VAL A 113     -13.196 106.453  13.488  1.00 40.95           C  
ATOM    796  CG2 VAL A 113     -13.678 104.391  14.715  1.00 38.54           C  
ATOM    797  N   ASN A 114     -16.343 106.346  11.174  1.00 43.35           N  
ATOM    798  CA  ASN A 114     -16.729 106.753   9.838  1.00 43.74           C  
ATOM    799  C   ASN A 114     -15.888 107.880   9.266  1.00 44.94           C  
ATOM    800  O   ASN A 114     -15.873 108.082   8.027  1.00 46.17           O  
ATOM    801  CB  ASN A 114     -18.225 107.155   9.826  1.00 43.16           C  
ATOM    802  CG  ASN A 114     -18.568 108.163  10.919  1.00 43.52           C  
ATOM    803  OD1 ASN A 114     -18.519 107.868  12.127  1.00 41.15           O  
ATOM    804  ND2 ASN A 114     -18.912 109.354  10.505  1.00 42.90           N  
ATOM    805  N   GLY A 115     -15.207 108.634  10.140  1.00 45.57           N  
ATOM    806  CA  GLY A 115     -14.436 109.814   9.725  1.00 44.86           C  
ATOM    807  C   GLY A 115     -13.631 110.398  10.876  1.00 45.77           C  
ATOM    808  O   GLY A 115     -13.248 109.634  11.821  1.00 45.23           O  
ATOM    809  N   TRP A 116     -13.385 111.730  10.808  1.00 44.95           N  
ATOM    810  CA  TRP A 116     -12.566 112.466  11.799  1.00 44.91           C  
ATOM    811  C   TRP A 116     -12.610 111.841  13.211  1.00 44.39           C  
ATOM    812  O   TRP A 116     -13.685 111.695  13.829  1.00 43.69           O  
ATOM    813  CB  TRP A 116     -12.939 113.938  11.861  1.00 46.47           C  
ATOM    814  CG  TRP A 116     -13.006 114.649  10.491  1.00 48.19           C  
ATOM    815  CD1 TRP A 116     -14.130 114.999   9.804  1.00 50.52           C  
ATOM    816  CD2 TRP A 116     -11.902 115.107   9.699  1.00 50.77           C  
ATOM    817  NE1 TRP A 116     -13.807 115.643   8.612  1.00 53.00           N  
ATOM    818  CE2 TRP A 116     -12.443 115.719   8.523  1.00 52.15           C  
ATOM    819  CE3 TRP A 116     -10.507 115.039   9.846  1.00 51.04           C  
ATOM    820  CZ2 TRP A 116     -11.632 116.263   7.506  1.00 51.11           C  
ATOM    821  CZ3 TRP A 116      -9.689 115.605   8.830  1.00 51.86           C  
ATOM    822  CH2 TRP A 116     -10.261 116.203   7.679  1.00 50.80           C  
ATOM    823  N   CYS A 117     -11.447 111.403  13.681  1.00 42.74           N  
ATOM    824  CA  CYS A 117     -11.328 110.951  15.059  1.00 41.79           C  
ATOM    825  C   CYS A 117     -10.147 111.681  15.711  1.00 41.02           C  
ATOM    826  O   CYS A 117      -9.014 111.384  15.371  1.00 41.44           O  
ATOM    827  CB  CYS A 117     -11.180 109.436  15.092  1.00 41.62           C  
ATOM    828  SG  CYS A 117     -11.107 108.773  16.753  1.00 42.70           S  
ATOM    829  N   PHE A 118     -10.409 112.671  16.581  1.00 39.85           N  
ATOM    830  CA  PHE A 118      -9.342 113.430  17.255  1.00 39.87           C  
ATOM    831  C   PHE A 118      -9.372 113.384  18.764  1.00 39.65           C  
ATOM    832  O   PHE A 118     -10.412 113.105  19.340  1.00 39.26           O  
ATOM    833  CB  PHE A 118      -9.340 114.865  16.840  1.00 39.25           C  
ATOM    834  CG  PHE A 118      -8.871 115.051  15.462  1.00 43.04           C  
ATOM    835  CD1 PHE A 118      -9.768 115.235  14.442  1.00 44.09           C  
ATOM    836  CD2 PHE A 118      -7.494 115.019  15.169  1.00 45.54           C  
ATOM    837  CE1 PHE A 118      -9.311 115.401  13.155  1.00 48.57           C  
ATOM    838  CE2 PHE A 118      -7.025 115.188  13.894  1.00 46.90           C  
ATOM    839  CZ  PHE A 118      -7.925 115.370  12.875  1.00 46.54           C  
ATOM    840  N   GLY A 119      -8.197 113.603  19.354  1.00 38.90           N  
ATOM    841  CA  GLY A 119      -8.008 113.930  20.774  1.00 39.66           C  
ATOM    842  C   GLY A 119      -8.838 113.087  21.710  1.00 40.24           C  
ATOM    843  O   GLY A 119      -8.694 111.875  21.722  1.00 41.18           O  
ATOM    844  N   GLY A 120      -9.730 113.722  22.462  1.00 40.58           N  
ATOM    845  CA  GLY A 120     -10.513 113.034  23.470  1.00 41.16           C  
ATOM    846  C   GLY A 120     -11.361 111.869  22.968  1.00 41.60           C  
ATOM    847  O   GLY A 120     -11.856 111.049  23.796  1.00 41.32           O  
ATOM    848  N   GLY A 121     -11.507 111.777  21.639  1.00 41.45           N  
ATOM    849  CA  GLY A 121     -12.245 110.694  20.964  1.00 41.50           C  
ATOM    850  C   GLY A 121     -11.557 109.328  21.054  1.00 43.18           C  
ATOM    851  O   GLY A 121     -12.170 108.298  20.747  1.00 43.71           O  
ATOM    852  N   PHE A 122     -10.284 109.280  21.450  1.00 42.44           N  
ATOM    853  CA  PHE A 122      -9.593 108.001  21.518  1.00 41.92           C  
ATOM    854  C   PHE A 122      -9.978 107.212  22.746  1.00 42.78           C  
ATOM    855  O   PHE A 122      -9.869 105.977  22.737  1.00 44.61           O  
ATOM    856  CB  PHE A 122      -8.084 108.181  21.502  1.00 41.35           C  
ATOM    857  CG  PHE A 122      -7.507 108.514  20.132  1.00 42.35           C  
ATOM    858  CD1 PHE A 122      -7.831 109.711  19.490  1.00 41.34           C  
ATOM    859  CD2 PHE A 122      -6.561 107.673  19.539  1.00 41.62           C  
ATOM    860  CE1 PHE A 122      -7.297 110.020  18.239  1.00 41.30           C  
ATOM    861  CE2 PHE A 122      -6.000 107.994  18.270  1.00 42.88           C  
ATOM    862  CZ  PHE A 122      -6.371 109.165  17.637  1.00 39.82           C  
ATOM    863  N   SER A 123     -10.367 107.899  23.829  1.00 41.65           N  
ATOM    864  CA  SER A 123     -10.879 107.225  25.009  1.00 41.07           C  
ATOM    865  C   SER A 123     -12.137 106.358  24.658  1.00 40.34           C  
ATOM    866  O   SER A 123     -12.049 105.171  24.713  1.00 40.41           O  
ATOM    867  CB  SER A 123     -11.110 108.212  26.180  1.00 41.00           C  
ATOM    868  OG  SER A 123      -9.896 108.832  26.607  1.00 40.28           O  
ATOM    869  N   PRO A 124     -13.289 106.945  24.256  1.00 39.75           N  
ATOM    870  CA  PRO A 124     -14.381 106.005  23.886  1.00 39.50           C  
ATOM    871  C   PRO A 124     -14.010 105.001  22.745  1.00 39.16           C  
ATOM    872  O   PRO A 124     -14.532 103.895  22.716  1.00 39.28           O  
ATOM    873  CB  PRO A 124     -15.527 106.933  23.470  1.00 38.85           C  
ATOM    874  CG  PRO A 124     -14.867 108.244  23.165  1.00 39.27           C  
ATOM    875  CD  PRO A 124     -13.695 108.345  24.087  1.00 39.05           C  
ATOM    876  N   LEU A 125     -13.116 105.386  21.829  1.00 38.70           N  
ATOM    877  CA  LEU A 125     -12.627 104.476  20.809  1.00 37.97           C  
ATOM    878  C   LEU A 125     -12.019 103.184  21.371  1.00 38.26           C  
ATOM    879  O   LEU A 125     -12.238 102.068  20.823  1.00 38.74           O  
ATOM    880  CB  LEU A 125     -11.545 105.156  19.941  1.00 37.32           C  
ATOM    881  CG  LEU A 125     -10.889 104.337  18.805  1.00 35.16           C  
ATOM    882  CD1 LEU A 125     -11.901 103.890  17.778  1.00 33.89           C  
ATOM    883  CD2 LEU A 125      -9.726 105.081  18.139  1.00 35.94           C  
ATOM    884  N   VAL A 126     -11.120 103.338  22.350  1.00 38.51           N  
ATOM    885  CA  VAL A 126     -10.448 102.175  22.880  1.00 37.54           C  
ATOM    886  C   VAL A 126     -11.309 101.394  23.881  1.00 38.73           C  
ATOM    887  O   VAL A 126     -11.277 100.160  23.861  1.00 38.91           O  
ATOM    888  CB  VAL A 126      -8.990 102.468  23.243  1.00 37.96           C  
ATOM    889  CG1 VAL A 126      -8.294 101.206  23.863  1.00 40.63           C  
ATOM    890  CG2 VAL A 126      -8.252 102.878  21.982  1.00 33.69           C  
ATOM    891  N   ALA A 127     -12.161 102.112  24.656  1.00 39.14           N  
ATOM    892  CA  ALA A 127     -13.200 101.515  25.543  1.00 38.61           C  
ATOM    893  C   ALA A 127     -14.173 100.547  24.829  1.00 39.66           C  
ATOM    894  O   ALA A 127     -14.381  99.406  25.288  1.00 38.99           O  
ATOM    895  CB  ALA A 127     -13.952 102.606  26.281  1.00 37.70           C  
ATOM    896  N   CYS A 128     -14.755 100.978  23.702  1.00 40.29           N  
ATOM    897  CA  CYS A 128     -15.420 100.035  22.787  1.00 40.30           C  
ATOM    898  C   CYS A 128     -14.555  98.759  22.611  1.00 41.02           C  
ATOM    899  O   CYS A 128     -13.296  98.815  22.589  1.00 40.32           O  
ATOM    900  CB  CYS A 128     -15.723 100.686  21.433  1.00 40.55           C  
ATOM    901  SG  CYS A 128     -16.979 102.012  21.480  1.00 39.14           S  
ATOM    902  N   ASP A 129     -15.215  97.602  22.529  1.00 40.76           N  
ATOM    903  CA  ASP A 129     -14.453  96.377  22.537  1.00 41.12           C  
ATOM    904  C   ASP A 129     -13.691  96.221  21.233  1.00 41.84           C  
ATOM    905  O   ASP A 129     -12.456  96.066  21.246  1.00 41.61           O  
ATOM    906  CB  ASP A 129     -15.322  95.171  22.822  1.00 40.59           C  
ATOM    907  CG  ASP A 129     -16.073  95.298  24.101  1.00 41.33           C  
ATOM    908  OD1 ASP A 129     -15.493  95.744  25.140  1.00 40.57           O  
ATOM    909  OD2 ASP A 129     -17.254  94.921  24.079  1.00 37.56           O  
ATOM    910  N   LEU A 130     -14.433  96.308  20.124  1.00 41.88           N  
ATOM    911  CA  LEU A 130     -13.858  96.164  18.805  1.00 41.63           C  
ATOM    912  C   LEU A 130     -14.015  97.457  18.051  1.00 41.67           C  
ATOM    913  O   LEU A 130     -14.777  98.308  18.462  1.00 40.65           O  
ATOM    914  CB  LEU A 130     -14.518  94.987  18.078  1.00 42.02           C  
ATOM    915  CG  LEU A 130     -14.363  93.655  18.839  1.00 41.90           C  
ATOM    916  CD1 LEU A 130     -15.210  92.534  18.292  1.00 39.56           C  
ATOM    917  CD2 LEU A 130     -12.871  93.253  18.899  1.00 44.83           C  
ATOM    918  N   ALA A 131     -13.273  97.622  16.956  1.00 41.73           N  
ATOM    919  CA  ALA A 131     -13.442  98.808  16.123  1.00 42.38           C  
ATOM    920  C   ALA A 131     -13.180  98.575  14.636  1.00 43.28           C  
ATOM    921  O   ALA A 131     -12.229  97.915  14.250  1.00 44.30           O  
ATOM    922  CB  ALA A 131     -12.588  99.969  16.652  1.00 41.94           C  
ATOM    923  N   ILE A 132     -14.052  99.138  13.805  1.00 43.55           N  
ATOM    924  CA  ILE A 132     -13.818  99.218  12.382  1.00 43.42           C  
ATOM    925  C   ILE A 132     -13.866 100.688  11.940  1.00 42.90           C  
ATOM    926  O   ILE A 132     -14.771 101.443  12.273  1.00 42.58           O  
ATOM    927  CB  ILE A 132     -14.820  98.293  11.573  1.00 44.22           C  
ATOM    928  CG1 ILE A 132     -14.720  96.829  12.064  1.00 43.82           C  
ATOM    929  CG2 ILE A 132     -14.567  98.375  10.062  1.00 42.24           C  
ATOM    930  CD1 ILE A 132     -15.979  96.133  12.156  1.00 45.41           C  
ATOM    931  N   CYS A 133     -12.877 101.097  11.186  1.00 42.39           N  
ATOM    932  CA  CYS A 133     -12.903 102.436  10.629  1.00 42.63           C  
ATOM    933  C   CYS A 133     -12.949 102.376   9.098  1.00 42.83           C  
ATOM    934  O   CYS A 133     -12.554 101.356   8.498  1.00 43.08           O  
ATOM    935  CB  CYS A 133     -11.682 103.243  11.087  1.00 40.23           C  
ATOM    936  SG  CYS A 133     -10.182 102.550  10.466  1.00 40.18           S  
ATOM    937  N   ALA A 134     -13.392 103.481   8.487  1.00 43.46           N  
ATOM    938  CA  ALA A 134     -13.254 103.727   7.033  1.00 43.52           C  
ATOM    939  C   ALA A 134     -11.807 104.118   6.669  1.00 44.38           C  
ATOM    940  O   ALA A 134     -11.189 104.912   7.388  1.00 45.52           O  
ATOM    941  CB  ALA A 134     -14.190 104.852   6.651  1.00 42.73           C  
ATOM    942  N   ASP A 135     -11.260 103.583   5.573  1.00 44.31           N  
ATOM    943  CA  ASP A 135      -9.917 103.957   5.050  1.00 44.98           C  
ATOM    944  C   ASP A 135      -9.721 105.481   5.011  1.00 45.86           C  
ATOM    945  O   ASP A 135      -8.585 106.029   5.176  1.00 45.43           O  
ATOM    946  CB  ASP A 135      -9.708 103.391   3.603  1.00 43.84           C  
ATOM    947  CG  ASP A 135      -9.601 101.860   3.570  1.00 43.38           C  
ATOM    948  OD1 ASP A 135      -9.159 101.263   4.573  1.00 42.25           O  
ATOM    949  OD2 ASP A 135      -9.946 101.223   2.551  1.00 44.19           O  
ATOM    950  N   GLU A 136     -10.859 106.135   4.746  1.00 46.58           N  
ATOM    951  CA  GLU A 136     -10.968 107.556   4.465  1.00 46.99           C  
ATOM    952  C   GLU A 136     -10.945 108.367   5.741  1.00 46.95           C  
ATOM    953  O   GLU A 136     -10.735 109.561   5.716  1.00 48.20           O  
ATOM    954  CB  GLU A 136     -12.255 107.848   3.670  1.00 47.59           C  
ATOM    955  CG  GLU A 136     -12.310 107.249   2.215  1.00 48.02           C  
ATOM    956  CD  GLU A 136     -13.053 105.886   2.062  1.00 49.44           C  
ATOM    957  OE1 GLU A 136     -13.323 105.117   3.055  1.00 47.33           O  
ATOM    958  OE2 GLU A 136     -13.340 105.566   0.877  1.00 50.75           O  
ATOM    959  N   ALA A 137     -11.140 107.718   6.872  1.00 46.83           N  
ATOM    960  CA  ALA A 137     -11.093 108.411   8.156  1.00 46.17           C  
ATOM    961  C   ALA A 137      -9.685 108.913   8.540  1.00 44.80           C  
ATOM    962  O   ALA A 137      -8.669 108.251   8.298  1.00 44.10           O  
ATOM    963  CB  ALA A 137     -11.702 107.507   9.270  1.00 46.50           C  
ATOM    964  N   THR A 138      -9.659 110.087   9.158  1.00 43.57           N  
ATOM    965  CA  THR A 138      -8.435 110.672   9.698  1.00 42.98           C  
ATOM    966  C   THR A 138      -8.423 110.730  11.256  1.00 42.35           C  
ATOM    967  O   THR A 138      -9.356 111.233  11.897  1.00 41.65           O  
ATOM    968  CB  THR A 138      -8.128 112.104   9.059  1.00 43.32           C  
ATOM    969  OG1 THR A 138      -8.230 112.038   7.623  1.00 42.76           O  
ATOM    970  CG2 THR A 138      -6.761 112.626   9.444  1.00 42.41           C  
ATOM    971  N   PHE A 139      -7.325 110.255  11.831  1.00 41.38           N  
ATOM    972  CA  PHE A 139      -7.114 110.299  13.278  1.00 42.05           C  
ATOM    973  C   PHE A 139      -5.975 111.217  13.564  1.00 42.27           C  
ATOM    974  O   PHE A 139      -5.106 111.405  12.723  1.00 43.83           O  
ATOM    975  CB  PHE A 139      -6.740 108.925  13.875  1.00 41.10           C  
ATOM    976  CG  PHE A 139      -7.697 107.790  13.545  1.00 40.61           C  
ATOM    977  CD1 PHE A 139      -7.751 107.242  12.255  1.00 39.79           C  
ATOM    978  CD2 PHE A 139      -8.506 107.236  14.543  1.00 39.70           C  
ATOM    979  CE1 PHE A 139      -8.605 106.182  11.956  1.00 40.15           C  
ATOM    980  CE2 PHE A 139      -9.360 106.179  14.255  1.00 38.52           C  
ATOM    981  CZ  PHE A 139      -9.418 105.649  12.946  1.00 39.08           C  
ATOM    982  N   GLY A 140      -5.927 111.760  14.779  1.00 42.95           N  
ATOM    983  CA  GLY A 140      -4.754 112.464  15.198  1.00 41.68           C  
ATOM    984  C   GLY A 140      -4.888 112.899  16.627  1.00 42.92           C  
ATOM    985  O   GLY A 140      -5.991 113.091  17.157  1.00 42.84           O  
ATOM    986  N   LEU A 141      -3.738 113.054  17.255  1.00 43.20           N  
ATOM    987  CA  LEU A 141      -3.666 113.427  18.640  1.00 43.44           C  
ATOM    988  C   LEU A 141      -3.125 114.835  18.627  1.00 43.37           C  
ATOM    989  O   LEU A 141      -1.999 115.094  18.978  1.00 40.88           O  
ATOM    990  CB  LEU A 141      -2.770 112.452  19.415  1.00 43.23           C  
ATOM    991  CG  LEU A 141      -3.269 111.040  19.353  1.00 42.45           C  
ATOM    992  CD1 LEU A 141      -2.161 110.113  19.725  1.00 47.19           C  
ATOM    993  CD2 LEU A 141      -4.430 110.874  20.255  1.00 39.38           C  
ATOM    994  N   SER A 142      -4.018 115.725  18.231  1.00 45.09           N  
ATOM    995  CA  SER A 142      -3.773 117.148  17.967  1.00 46.80           C  
ATOM    996  C   SER A 142      -3.511 117.979  19.249  1.00 46.87           C  
ATOM    997  O   SER A 142      -3.043 119.123  19.172  1.00 48.06           O  
ATOM    998  CB  SER A 142      -5.036 117.699  17.310  1.00 46.40           C  
ATOM    999  OG  SER A 142      -6.158 117.301  18.138  1.00 51.02           O  
ATOM   1000  N   GLU A 143      -3.818 117.414  20.413  1.00 45.77           N  
ATOM   1001  CA  GLU A 143      -3.552 118.080  21.670  1.00 45.34           C  
ATOM   1002  C   GLU A 143      -2.259 118.882  21.678  1.00 44.43           C  
ATOM   1003  O   GLU A 143      -2.296 120.101  21.795  1.00 44.53           O  
ATOM   1004  CB  GLU A 143      -3.488 117.037  22.771  1.00 45.74           C  
ATOM   1005  CG  GLU A 143      -4.854 116.576  23.205  1.00 46.86           C  
ATOM   1006  CD  GLU A 143      -5.254 115.271  22.569  1.00 46.87           C  
ATOM   1007  OE1 GLU A 143      -4.727 114.915  21.530  1.00 46.18           O  
ATOM   1008  OE2 GLU A 143      -6.111 114.581  23.132  1.00 51.72           O  
ATOM   1009  N   ILE A 144      -1.138 118.176  21.528  1.00 42.91           N  
ATOM   1010  CA  ILE A 144       0.220 118.724  21.593  1.00 42.02           C  
ATOM   1011  C   ILE A 144       0.348 120.033  20.786  1.00 42.39           C  
ATOM   1012  O   ILE A 144       0.920 121.011  21.255  1.00 41.97           O  
ATOM   1013  CB  ILE A 144       1.249 117.630  21.131  1.00 40.41           C  
ATOM   1014  CG1 ILE A 144       2.711 117.987  21.453  1.00 40.33           C  
ATOM   1015  CG2 ILE A 144       1.130 117.358  19.628  1.00 40.79           C  
ATOM   1016  CD1 ILE A 144       3.030 118.276  22.874  1.00 39.88           C  
ATOM   1017  N   ASN A 145      -0.234 120.039  19.589  1.00 44.21           N  
ATOM   1018  CA  ASN A 145      -0.307 121.216  18.727  1.00 46.69           C  
ATOM   1019  C   ASN A 145      -1.067 122.433  19.308  1.00 47.25           C  
ATOM   1020  O   ASN A 145      -0.648 123.575  19.112  1.00 47.75           O  
ATOM   1021  CB  ASN A 145      -0.852 120.789  17.369  1.00 46.92           C  
ATOM   1022  CG  ASN A 145       0.132 119.896  16.625  1.00 47.96           C  
ATOM   1023  OD1 ASN A 145       1.349 119.985  16.840  1.00 45.24           O  
ATOM   1024  ND2 ASN A 145      -0.383 119.032  15.763  1.00 45.34           N  
ATOM   1025  N   TRP A 146      -2.146 122.173  20.050  1.00 48.24           N  
ATOM   1026  CA  TRP A 146      -2.885 123.224  20.807  1.00 48.68           C  
ATOM   1027  C   TRP A 146      -2.260 123.568  22.172  1.00 47.75           C  
ATOM   1028  O   TRP A 146      -2.839 124.329  22.931  1.00 47.76           O  
ATOM   1029  CB  TRP A 146      -4.331 122.764  21.036  1.00 48.59           C  
ATOM   1030  CG  TRP A 146      -5.216 122.883  19.820  1.00 52.07           C  
ATOM   1031  CD1 TRP A 146      -5.752 121.841  19.123  1.00 55.73           C  
ATOM   1032  NE1 TRP A 146      -6.513 122.312  18.106  1.00 59.08           N  
ATOM   1033  N   GLY A 147      -1.123 122.951  22.515  1.00 47.22           N  
ATOM   1034  CA  GLY A 147      -0.401 123.251  23.745  1.00 45.75           C  
ATOM   1035  C   GLY A 147      -0.992 122.563  24.942  1.00 45.55           C  
ATOM   1036  O   GLY A 147      -0.845 123.050  26.063  1.00 46.12           O  
ATOM   1037  N   ILE A 148      -1.671 121.430  24.738  1.00 44.55           N  
ATOM   1038  CA  ILE A 148      -1.961 120.528  25.875  1.00 42.91           C  
ATOM   1039  C   ILE A 148      -1.463 119.088  25.686  1.00 41.81           C  
ATOM   1040  O   ILE A 148      -1.533 118.533  24.604  1.00 41.24           O  
ATOM   1041  CB  ILE A 148      -3.426 120.506  26.307  1.00 42.77           C  
ATOM   1042  CG1 ILE A 148      -4.336 120.214  25.112  1.00 44.82           C  
ATOM   1043  CG2 ILE A 148      -3.790 121.811  27.043  1.00 43.67           C  
ATOM   1044  CD1 ILE A 148      -5.709 119.589  25.520  1.00 48.23           C  
ATOM   1045  N   PRO A 149      -0.986 118.456  26.761  1.00 41.26           N  
ATOM   1046  CA  PRO A 149      -0.679 117.026  26.616  1.00 39.73           C  
ATOM   1047  C   PRO A 149      -2.019 116.305  26.531  1.00 39.42           C  
ATOM   1048  O   PRO A 149      -3.069 116.931  26.805  1.00 39.66           O  
ATOM   1049  CB  PRO A 149       0.049 116.708  27.936  1.00 40.45           C  
ATOM   1050  CG  PRO A 149      -0.471 117.641  28.912  1.00 41.05           C  
ATOM   1051  CD  PRO A 149      -0.742 118.945  28.135  1.00 40.62           C  
ATOM   1052  N   PRO A 150      -2.047 115.027  26.119  1.00 38.42           N  
ATOM   1053  CA  PRO A 150      -3.413 114.462  25.999  1.00 37.25           C  
ATOM   1054  C   PRO A 150      -4.182 114.319  27.342  1.00 38.14           C  
ATOM   1055  O   PRO A 150      -3.616 113.864  28.354  1.00 38.11           O  
ATOM   1056  CB  PRO A 150      -3.160 113.085  25.352  1.00 37.15           C  
ATOM   1057  CG  PRO A 150      -1.826 113.187  24.696  1.00 36.80           C  
ATOM   1058  CD  PRO A 150      -1.012 114.078  25.658  1.00 38.15           C  
ATOM   1059  N   GLY A 151      -5.480 114.630  27.354  1.00 38.11           N  
ATOM   1060  CA  GLY A 151      -6.233 114.623  28.599  1.00 37.64           C  
ATOM   1061  C   GLY A 151      -7.164 113.417  28.752  1.00 38.27           C  
ATOM   1062  O   GLY A 151      -7.367 112.661  27.802  1.00 39.41           O  
ATOM   1063  N   ASN A 152      -7.780 113.267  29.928  1.00 37.44           N  
ATOM   1064  CA  ASN A 152      -8.627 112.119  30.220  1.00 37.38           C  
ATOM   1065  C   ASN A 152      -7.806 110.881  29.936  1.00 38.16           C  
ATOM   1066  O   ASN A 152      -6.610 110.903  30.264  1.00 38.78           O  
ATOM   1067  CB  ASN A 152      -9.973 112.156  29.479  1.00 36.62           C  
ATOM   1068  CG  ASN A 152     -11.029 111.326  30.162  1.00 37.27           C  
ATOM   1069  OD1 ASN A 152     -11.093 110.111  29.973  1.00 41.33           O  
ATOM   1070  ND2 ASN A 152     -11.876 111.960  30.936  1.00 37.79           N  
ATOM   1071  N   LEU A 153      -8.383 109.829  29.321  1.00 36.82           N  
ATOM   1072  CA  LEU A 153      -7.667 108.528  29.266  1.00 35.47           C  
ATOM   1073  C   LEU A 153      -7.003 108.336  27.894  1.00 35.15           C  
ATOM   1074  O   LEU A 153      -6.688 107.235  27.496  1.00 35.89           O  
ATOM   1075  CB  LEU A 153      -8.614 107.329  29.627  1.00 34.64           C  
ATOM   1076  CG  LEU A 153      -8.580 106.843  31.066  1.00 31.73           C  
ATOM   1077  CD1 LEU A 153      -7.376 105.933  31.295  1.00 33.29           C  
ATOM   1078  CD2 LEU A 153      -8.494 108.039  31.943  1.00 28.48           C  
ATOM   1079  N   VAL A 154      -6.850 109.417  27.149  1.00 35.43           N  
ATOM   1080  CA  VAL A 154      -6.345 109.358  25.772  1.00 35.02           C  
ATOM   1081  C   VAL A 154      -5.017 108.564  25.704  1.00 35.90           C  
ATOM   1082  O   VAL A 154      -4.939 107.565  24.951  1.00 36.98           O  
ATOM   1083  CB  VAL A 154      -6.232 110.804  25.159  1.00 35.60           C  
ATOM   1084  CG1 VAL A 154      -5.530 110.815  23.850  1.00 34.85           C  
ATOM   1085  CG2 VAL A 154      -7.637 111.421  25.018  1.00 31.47           C  
ATOM   1086  N   SER A 155      -4.024 108.916  26.525  1.00 34.52           N  
ATOM   1087  CA  SER A 155      -2.709 108.254  26.403  1.00 34.32           C  
ATOM   1088  C   SER A 155      -2.783 106.784  26.733  1.00 35.14           C  
ATOM   1089  O   SER A 155      -2.012 106.025  26.210  1.00 36.54           O  
ATOM   1090  CB  SER A 155      -1.630 108.955  27.231  1.00 32.00           C  
ATOM   1091  OG  SER A 155      -1.483 110.206  26.642  1.00 33.49           O  
ATOM   1092  N   LYS A 156      -3.750 106.381  27.565  1.00 36.50           N  
ATOM   1093  CA  LYS A 156      -3.889 104.987  28.015  1.00 35.63           C  
ATOM   1094  C   LYS A 156      -4.574 104.155  26.961  1.00 36.97           C  
ATOM   1095  O   LYS A 156      -4.198 102.972  26.719  1.00 38.25           O  
ATOM   1096  CB  LYS A 156      -4.629 104.918  29.365  1.00 35.79           C  
ATOM   1097  CG  LYS A 156      -4.715 103.506  30.045  1.00 34.43           C  
ATOM   1098  CD  LYS A 156      -3.352 102.901  30.238  1.00 29.72           C  
ATOM   1099  CE  LYS A 156      -3.513 101.525  30.945  1.00 36.07           C  
ATOM   1100  NZ  LYS A 156      -2.198 101.153  31.529  1.00 32.06           N  
ATOM   1101  N   ALA A 157      -5.582 104.760  26.343  1.00 37.16           N  
ATOM   1102  CA  ALA A 157      -6.177 104.243  25.121  1.00 37.26           C  
ATOM   1103  C   ALA A 157      -5.094 103.908  24.076  1.00 37.08           C  
ATOM   1104  O   ALA A 157      -5.084 102.826  23.541  1.00 38.28           O  
ATOM   1105  CB  ALA A 157      -7.206 105.235  24.567  1.00 35.40           C  
ATOM   1106  N   MET A 158      -4.173 104.812  23.800  1.00 36.71           N  
ATOM   1107  CA  MET A 158      -2.998 104.462  22.977  1.00 36.46           C  
ATOM   1108  C   MET A 158      -2.170 103.297  23.588  1.00 37.24           C  
ATOM   1109  O   MET A 158      -1.950 102.275  22.930  1.00 38.34           O  
ATOM   1110  CB  MET A 158      -2.084 105.712  22.795  1.00 36.77           C  
ATOM   1111  CG  MET A 158      -2.702 106.844  21.933  1.00 37.09           C  
ATOM   1112  SD  MET A 158      -3.035 106.279  20.229  1.00 38.88           S  
ATOM   1113  CE  MET A 158      -1.409 106.331  19.430  1.00 37.32           C  
ATOM   1114  N   ALA A 159      -1.745 103.447  24.841  1.00 36.23           N  
ATOM   1115  CA  ALA A 159      -0.904 102.476  25.506  1.00 37.66           C  
ATOM   1116  C   ALA A 159      -1.467 101.067  25.365  1.00 38.31           C  
ATOM   1117  O   ALA A 159      -0.678 100.108  25.251  1.00 40.10           O  
ATOM   1118  CB  ALA A 159      -0.675 102.822  27.012  1.00 35.48           C  
ATOM   1119  N   ASP A 160      -2.790 100.935  25.356  1.00 37.46           N  
ATOM   1120  CA  ASP A 160      -3.425  99.609  25.324  1.00 38.21           C  
ATOM   1121  C   ASP A 160      -3.449  98.973  23.955  1.00 37.40           C  
ATOM   1122  O   ASP A 160      -3.447  97.761  23.849  1.00 39.32           O  
ATOM   1123  CB  ASP A 160      -4.882  99.684  25.838  1.00 37.71           C  
ATOM   1124  CG  ASP A 160      -4.989  99.579  27.372  1.00 39.33           C  
ATOM   1125  OD1 ASP A 160      -3.967  99.453  28.124  1.00 39.22           O  
ATOM   1126  OD2 ASP A 160      -6.131  99.626  27.830  1.00 41.65           O  
ATOM   1127  N   THR A 161      -3.501  99.780  22.890  1.00 36.95           N  
ATOM   1128  CA  THR A 161      -3.708  99.214  21.543  1.00 35.51           C  
ATOM   1129  C   THR A 161      -2.536  99.412  20.594  1.00 34.38           C  
ATOM   1130  O   THR A 161      -2.410  98.717  19.609  1.00 33.80           O  
ATOM   1131  CB  THR A 161      -4.966  99.813  20.912  1.00 35.76           C  
ATOM   1132  OG1 THR A 161      -4.860 101.243  20.930  1.00 38.56           O  
ATOM   1133  CG2 THR A 161      -6.216  99.418  21.704  1.00 34.57           C  
ATOM   1134  N   VAL A 162      -1.720 100.429  20.841  1.00 35.51           N  
ATOM   1135  CA  VAL A 162      -0.736 100.860  19.853  1.00 34.98           C  
ATOM   1136  C   VAL A 162       0.604 100.695  20.561  1.00 35.78           C  
ATOM   1137  O   VAL A 162       0.693 100.948  21.761  1.00 35.46           O  
ATOM   1138  CB  VAL A 162      -0.933 102.323  19.373  1.00 35.70           C  
ATOM   1139  CG1 VAL A 162       0.190 102.727  18.378  1.00 33.56           C  
ATOM   1140  CG2 VAL A 162      -2.325 102.541  18.761  1.00 31.69           C  
ATOM   1141  N   GLY A 163       1.619 100.258  19.814  1.00 35.06           N  
ATOM   1142  CA  GLY A 163       2.941 100.017  20.352  1.00 33.60           C  
ATOM   1143  C   GLY A 163       3.587 101.287  20.920  1.00 33.39           C  
ATOM   1144  O   GLY A 163       3.128 102.428  20.663  1.00 31.33           O  
ATOM   1145  N   HIS A 164       4.659 101.062  21.688  1.00 32.62           N  
ATOM   1146  CA  HIS A 164       5.344 102.088  22.436  1.00 32.24           C  
ATOM   1147  C   HIS A 164       5.908 103.205  21.515  1.00 33.56           C  
ATOM   1148  O   HIS A 164       5.567 104.409  21.683  1.00 33.91           O  
ATOM   1149  CB  HIS A 164       6.383 101.396  23.336  1.00 30.83           C  
ATOM   1150  CG  HIS A 164       7.276 102.333  24.086  1.00 31.63           C  
ATOM   1151  ND1 HIS A 164       7.013 102.754  25.376  1.00 27.49           N  
ATOM   1152  CD2 HIS A 164       8.436 102.939  23.715  1.00 31.24           C  
ATOM   1153  CE1 HIS A 164       7.962 103.596  25.757  1.00 28.10           C  
ATOM   1154  NE2 HIS A 164       8.844 103.718  24.767  1.00 28.46           N  
ATOM   1155  N   ARG A 165       6.727 102.831  20.526  1.00 33.68           N  
ATOM   1156  CA  ARG A 165       7.378 103.825  19.613  1.00 34.49           C  
ATOM   1157  C   ARG A 165       6.355 104.692  18.811  1.00 35.09           C  
ATOM   1158  O   ARG A 165       6.488 105.939  18.723  1.00 35.40           O  
ATOM   1159  CB  ARG A 165       8.353 103.104  18.625  1.00 33.20           C  
ATOM   1160  CG  ARG A 165       9.594 102.472  19.278  1.00 31.43           C  
ATOM   1161  CD  ARG A 165      10.466 103.542  19.988  1.00 27.74           C  
ATOM   1162  NE  ARG A 165      11.783 103.013  20.223  1.00 25.10           N  
ATOM   1163  CZ  ARG A 165      12.731 103.595  20.947  1.00 26.90           C  
ATOM   1164  NH1 ARG A 165      12.478 104.748  21.551  1.00 27.33           N  
ATOM   1165  NH2 ARG A 165      13.914 102.987  21.103  1.00 27.05           N  
ATOM   1166  N   GLN A 166       5.399 104.005  18.176  1.00 35.88           N  
ATOM   1167  CA  GLN A 166       4.243 104.610  17.519  1.00 37.64           C  
ATOM   1168  C   GLN A 166       3.352 105.488  18.396  1.00 36.04           C  
ATOM   1169  O   GLN A 166       2.989 106.579  17.994  1.00 35.41           O  
ATOM   1170  CB  GLN A 166       3.379 103.540  16.800  1.00 37.41           C  
ATOM   1171  CG  GLN A 166       4.205 102.706  15.813  1.00 41.24           C  
ATOM   1172  CD  GLN A 166       3.380 101.784  14.900  1.00 41.97           C  
ATOM   1173  OE1 GLN A 166       3.241 102.048  13.712  1.00 51.21           O  
ATOM   1174  NE2 GLN A 166       2.844 100.715  15.449  1.00 45.56           N  
ATOM   1175  N   SER A 167       2.924 104.996  19.554  1.00 36.57           N  
ATOM   1176  CA  SER A 167       2.172 105.859  20.474  1.00 34.61           C  
ATOM   1177  C   SER A 167       2.937 107.195  20.722  1.00 34.93           C  
ATOM   1178  O   SER A 167       2.406 108.294  20.528  1.00 34.06           O  
ATOM   1179  CB  SER A 167       1.904 105.176  21.791  1.00 33.29           C  
ATOM   1180  OG  SER A 167       0.943 104.189  21.657  1.00 31.16           O  
ATOM   1181  N   LEU A 168       4.167 107.072  21.167  1.00 34.50           N  
ATOM   1182  CA  LEU A 168       4.969 108.225  21.497  1.00 35.48           C  
ATOM   1183  C   LEU A 168       5.142 109.128  20.255  1.00 36.68           C  
ATOM   1184  O   LEU A 168       5.057 110.346  20.366  1.00 37.66           O  
ATOM   1185  CB  LEU A 168       6.324 107.786  22.077  1.00 33.82           C  
ATOM   1186  CG  LEU A 168       6.405 107.470  23.582  1.00 32.89           C  
ATOM   1187  CD1 LEU A 168       7.833 106.837  23.889  1.00 29.35           C  
ATOM   1188  CD2 LEU A 168       6.063 108.716  24.501  1.00 30.35           C  
ATOM   1189  N   TYR A 169       5.364 108.541  19.081  1.00 37.70           N  
ATOM   1190  CA  TYR A 169       5.432 109.315  17.830  1.00 37.94           C  
ATOM   1191  C   TYR A 169       4.227 110.255  17.606  1.00 38.13           C  
ATOM   1192  O   TYR A 169       4.410 111.459  17.421  1.00 37.80           O  
ATOM   1193  CB  TYR A 169       5.527 108.396  16.623  1.00 38.91           C  
ATOM   1194  CG  TYR A 169       5.763 109.180  15.318  1.00 38.89           C  
ATOM   1195  CD1 TYR A 169       7.058 109.576  14.944  1.00 39.35           C  
ATOM   1196  CD2 TYR A 169       4.716 109.467  14.451  1.00 37.15           C  
ATOM   1197  CE1 TYR A 169       7.298 110.257  13.785  1.00 38.74           C  
ATOM   1198  CE2 TYR A 169       4.944 110.178  13.263  1.00 41.76           C  
ATOM   1199  CZ  TYR A 169       6.244 110.541  12.927  1.00 39.80           C  
ATOM   1200  OH  TYR A 169       6.505 111.229  11.736  1.00 44.66           O  
ATOM   1201  N   TYR A 170       3.032 109.679  17.567  1.00 37.51           N  
ATOM   1202  CA  TYR A 170       1.774 110.374  17.295  1.00 38.42           C  
ATOM   1203  C   TYR A 170       1.377 111.372  18.410  1.00 37.44           C  
ATOM   1204  O   TYR A 170       0.800 112.422  18.169  1.00 36.76           O  
ATOM   1205  CB  TYR A 170       0.656 109.303  16.996  1.00 39.72           C  
ATOM   1206  CG  TYR A 170       0.905 108.678  15.596  1.00 42.11           C  
ATOM   1207  CD1 TYR A 170       0.933 109.495  14.457  1.00 43.99           C  
ATOM   1208  CD2 TYR A 170       1.181 107.324  15.417  1.00 44.23           C  
ATOM   1209  CE1 TYR A 170       1.204 109.017  13.208  1.00 45.15           C  
ATOM   1210  CE2 TYR A 170       1.454 106.806  14.090  1.00 43.93           C  
ATOM   1211  CZ  TYR A 170       1.452 107.675  13.006  1.00 44.60           C  
ATOM   1212  OH  TYR A 170       1.721 107.244  11.719  1.00 40.27           O  
ATOM   1213  N   ILE A 171       1.670 111.017  19.645  1.00 36.82           N  
ATOM   1214  CA  ILE A 171       1.446 111.890  20.772  1.00 35.07           C  
ATOM   1215  C   ILE A 171       2.409 113.077  20.695  1.00 36.24           C  
ATOM   1216  O   ILE A 171       1.974 114.249  20.778  1.00 38.51           O  
ATOM   1217  CB  ILE A 171       1.606 111.115  22.090  1.00 35.31           C  
ATOM   1218  CG1 ILE A 171       0.413 110.151  22.317  1.00 32.89           C  
ATOM   1219  CG2 ILE A 171       1.736 112.066  23.359  1.00 33.29           C  
ATOM   1220  CD1 ILE A 171       0.666 109.250  23.584  1.00 33.80           C  
ATOM   1221  N   MET A 172       3.690 112.796  20.524  1.00 34.81           N  
ATOM   1222  CA  MET A 172       4.667 113.825  20.494  1.00 35.03           C  
ATOM   1223  C   MET A 172       4.621 114.715  19.249  1.00 36.58           C  
ATOM   1224  O   MET A 172       4.819 115.929  19.371  1.00 37.68           O  
ATOM   1225  CB  MET A 172       6.074 113.252  20.693  1.00 36.79           C  
ATOM   1226  CG  MET A 172       6.312 112.703  22.084  1.00 32.98           C  
ATOM   1227  SD  MET A 172       7.823 111.754  22.180  1.00 31.73           S  
ATOM   1228  CE  MET A 172       9.158 113.017  22.212  1.00 27.30           C  
ATOM   1229  N   THR A 173       4.340 114.158  18.064  1.00 36.31           N  
ATOM   1230  CA  THR A 173       4.348 114.959  16.858  1.00 35.49           C  
ATOM   1231  C   THR A 173       3.004 115.603  16.571  1.00 36.38           C  
ATOM   1232  O   THR A 173       2.985 116.657  15.959  1.00 37.45           O  
ATOM   1233  CB  THR A 173       4.768 114.161  15.575  1.00 35.74           C  
ATOM   1234  OG1 THR A 173       3.803 113.136  15.339  1.00 37.35           O  
ATOM   1235  CG2 THR A 173       6.164 113.562  15.679  1.00 31.87           C  
ATOM   1236  N   GLY A 174       1.883 114.988  16.967  1.00 36.56           N  
ATOM   1237  CA  GLY A 174       0.552 115.518  16.645  1.00 36.53           C  
ATOM   1238  C   GLY A 174       0.129 115.255  15.184  1.00 38.76           C  
ATOM   1239  O   GLY A 174      -0.859 115.855  14.699  1.00 38.44           O  
ATOM   1240  N   LYS A 175       0.875 114.381  14.485  1.00 39.68           N  
ATOM   1241  CA  LYS A 175       0.631 113.996  13.082  1.00 40.78           C  
ATOM   1242  C   LYS A 175      -0.588 113.083  12.920  1.00 40.56           C  
ATOM   1243  O   LYS A 175      -0.877 112.234  13.755  1.00 39.87           O  
ATOM   1244  CB  LYS A 175       1.907 113.352  12.456  1.00 40.99           C  
ATOM   1245  CG  LYS A 175       3.081 114.373  12.105  1.00 42.62           C  
ATOM   1246  CD  LYS A 175       4.374 113.597  11.910  1.00 44.62           C  
ATOM   1247  CE  LYS A 175       5.576 114.519  11.567  1.00 50.24           C  
ATOM   1248  NZ  LYS A 175       5.352 115.292  10.284  1.00 58.87           N  
ATOM   1249  N   THR A 176      -1.318 113.294  11.830  1.00 41.29           N  
ATOM   1250  CA  THR A 176      -2.565 112.579  11.557  1.00 41.32           C  
ATOM   1251  C   THR A 176      -2.219 111.291  10.778  1.00 41.89           C  
ATOM   1252  O   THR A 176      -1.152 111.179  10.190  1.00 41.54           O  
ATOM   1253  CB  THR A 176      -3.558 113.452  10.725  1.00 40.58           C  
ATOM   1254  OG1 THR A 176      -2.900 113.876   9.538  1.00 41.09           O  
ATOM   1255  CG2 THR A 176      -4.000 114.660  11.454  1.00 40.62           C  
ATOM   1256  N   PHE A 177      -3.105 110.302  10.812  1.00 41.98           N  
ATOM   1257  CA  PHE A 177      -2.873 109.090  10.079  1.00 42.18           C  
ATOM   1258  C   PHE A 177      -4.237 108.620   9.645  1.00 42.82           C  
ATOM   1259  O   PHE A 177      -5.233 108.960  10.269  1.00 42.97           O  
ATOM   1260  CB  PHE A 177      -2.118 108.050  10.910  1.00 41.88           C  
ATOM   1261  CG  PHE A 177      -2.689 107.823  12.299  1.00 41.28           C  
ATOM   1262  CD1 PHE A 177      -2.344 108.659  13.362  1.00 41.52           C  
ATOM   1263  CD2 PHE A 177      -3.544 106.776  12.538  1.00 38.62           C  
ATOM   1264  CE1 PHE A 177      -2.882 108.438  14.628  1.00 43.37           C  
ATOM   1265  CE2 PHE A 177      -4.067 106.545  13.793  1.00 41.22           C  
ATOM   1266  CZ  PHE A 177      -3.738 107.383  14.843  1.00 41.70           C  
ATOM   1267  N   GLY A 178      -4.284 107.879   8.548  1.00 42.55           N  
ATOM   1268  CA  GLY A 178      -5.547 107.460   7.990  1.00 43.42           C  
ATOM   1269  C   GLY A 178      -5.990 106.113   8.549  1.00 44.53           C  
ATOM   1270  O   GLY A 178      -5.296 105.514   9.396  1.00 44.58           O  
ATOM   1271  N   GLY A 179      -7.164 105.666   8.110  1.00 44.78           N  
ATOM   1272  CA  GLY A 179      -7.733 104.371   8.514  1.00 46.27           C  
ATOM   1273  C   GLY A 179      -6.847 103.140   8.332  1.00 46.93           C  
ATOM   1274  O   GLY A 179      -6.830 102.270   9.202  1.00 48.12           O  
ATOM   1275  N   GLN A 180      -6.113 103.041   7.223  1.00 47.56           N  
ATOM   1276  CA  GLN A 180      -5.231 101.870   6.999  1.00 47.76           C  
ATOM   1277  C   GLN A 180      -4.046 101.816   7.989  1.00 47.06           C  
ATOM   1278  O   GLN A 180      -3.656 100.722   8.475  1.00 47.70           O  
ATOM   1279  CB  GLN A 180      -4.729 101.786   5.549  1.00 47.28           C  
ATOM   1280  CG  GLN A 180      -5.770 101.211   4.572  1.00 49.36           C  
ATOM   1281  CD  GLN A 180      -5.947  99.672   4.648  1.00 51.52           C  
ATOM   1282  OE1 GLN A 180      -7.078  99.156   4.689  1.00 47.66           O  
ATOM   1283  NE2 GLN A 180      -4.827  98.950   4.662  1.00 53.71           N  
ATOM   1284  N   LYS A 181      -3.493 102.984   8.293  1.00 45.36           N  
ATOM   1285  CA  LYS A 181      -2.437 103.059   9.269  1.00 44.23           C  
ATOM   1286  C   LYS A 181      -2.990 102.774  10.662  1.00 42.74           C  
ATOM   1287  O   LYS A 181      -2.316 102.136  11.437  1.00 41.08           O  
ATOM   1288  CB  LYS A 181      -1.717 104.402   9.206  1.00 45.18           C  
ATOM   1289  CG  LYS A 181      -0.575 104.571  10.224  1.00 47.15           C  
ATOM   1290  CD  LYS A 181       0.445 103.405  10.205  1.00 50.51           C  
ATOM   1291  CE  LYS A 181       1.920 103.894  10.107  1.00 52.44           C  
ATOM   1292  NZ  LYS A 181       2.572 104.312  11.399  1.00 50.06           N  
ATOM   1293  N   ALA A 182      -4.208 103.228  10.962  1.00 41.30           N  
ATOM   1294  CA  ALA A 182      -4.864 102.872  12.206  1.00 41.30           C  
ATOM   1295  C   ALA A 182      -4.929 101.336  12.448  1.00 41.87           C  
ATOM   1296  O   ALA A 182      -4.549 100.863  13.535  1.00 40.67           O  
ATOM   1297  CB  ALA A 182      -6.266 103.514  12.284  1.00 41.20           C  
ATOM   1298  N   ALA A 183      -5.395 100.575  11.447  1.00 42.63           N  
ATOM   1299  CA  ALA A 183      -5.427  99.095  11.523  1.00 44.15           C  
ATOM   1300  C   ALA A 183      -4.047  98.425  11.637  1.00 44.73           C  
ATOM   1301  O   ALA A 183      -3.884  97.444  12.356  1.00 45.60           O  
ATOM   1302  CB  ALA A 183      -6.221  98.486  10.348  1.00 42.47           C  
ATOM   1303  N   GLU A 184      -3.051  98.936  10.946  1.00 45.18           N  
ATOM   1304  CA  GLU A 184      -1.734  98.325  11.048  1.00 47.59           C  
ATOM   1305  C   GLU A 184      -1.043  98.596  12.420  1.00 45.71           C  
ATOM   1306  O   GLU A 184      -0.221  97.804  12.879  1.00 45.73           O  
ATOM   1307  CB  GLU A 184      -0.861  98.737   9.867  1.00 47.19           C  
ATOM   1308  CG  GLU A 184       0.495  99.344  10.261  1.00 52.95           C  
ATOM   1309  CD  GLU A 184       1.334  99.814   9.058  1.00 54.92           C  
ATOM   1310  OE1 GLU A 184       0.749 100.099   7.959  1.00 66.10           O  
ATOM   1311  OE2 GLU A 184       2.590  99.911   9.210  1.00 62.79           O  
ATOM   1312  N   MET A 185      -1.380  99.714  13.049  0.50 44.95           N  
ATOM   1313  CA  MET A 185      -0.877 100.039  14.366  0.50 44.09           C  
ATOM   1314  C   MET A 185      -1.510  99.159  15.442  0.50 43.82           C  
ATOM   1315  O   MET A 185      -0.847  98.782  16.396  0.50 43.15           O  
ATOM   1316  CB  MET A 185      -1.137 101.505  14.670  0.50 44.10           C  
ATOM   1317  CG  MET A 185       0.038 102.397  14.295  0.50 44.35           C  
ATOM   1318  SD  MET A 185      -0.485 104.090  14.066  0.50 43.98           S  
ATOM   1319  CE  MET A 185      -1.390 104.514  15.553  0.50 41.73           C  
ATOM   1328  N   GLY A 186      -2.784  98.821  15.255  1.00 43.04           N  
ATOM   1329  CA  GLY A 186      -3.547  98.080  16.249  1.00 42.66           C  
ATOM   1330  C   GLY A 186      -4.593  98.933  16.952  1.00 42.11           C  
ATOM   1331  O   GLY A 186      -5.198  98.492  17.917  1.00 40.94           O  
ATOM   1332  N   LEU A 187      -4.798 100.166  16.465  1.00 41.61           N  
ATOM   1333  CA  LEU A 187      -5.765 101.070  17.077  1.00 41.30           C  
ATOM   1334  C   LEU A 187      -7.202 100.538  16.910  1.00 41.06           C  
ATOM   1335  O   LEU A 187      -8.055 100.676  17.781  1.00 40.27           O  
ATOM   1336  CB  LEU A 187      -5.608 102.471  16.493  1.00 40.80           C  
ATOM   1337  CG  LEU A 187      -6.396 103.562  17.182  1.00 41.78           C  
ATOM   1338  CD1 LEU A 187      -5.780 103.821  18.621  1.00 37.47           C  
ATOM   1339  CD2 LEU A 187      -6.476 104.854  16.340  1.00 42.04           C  
ATOM   1340  N   VAL A 188      -7.439  99.905  15.769  1.00 41.49           N  
ATOM   1341  CA  VAL A 188      -8.758  99.388  15.393  1.00 40.65           C  
ATOM   1342  C   VAL A 188      -8.534  97.978  14.822  1.00 41.43           C  
ATOM   1343  O   VAL A 188      -7.370  97.597  14.504  1.00 40.17           O  
ATOM   1344  CB  VAL A 188      -9.471 100.347  14.372  1.00 40.16           C  
ATOM   1345  CG1 VAL A 188      -9.807 101.738  15.015  1.00 35.84           C  
ATOM   1346  CG2 VAL A 188      -8.609 100.495  13.070  1.00 40.46           C  
ATOM   1347  N   ASN A 189      -9.621  97.195  14.716  1.00 41.43           N  
ATOM   1348  CA  ASN A 189      -9.537  95.841  14.156  1.00 42.54           C  
ATOM   1349  C   ASN A 189      -9.200  95.770  12.643  1.00 43.87           C  
ATOM   1350  O   ASN A 189      -8.407  94.902  12.204  1.00 43.44           O  
ATOM   1351  CB  ASN A 189     -10.791  94.990  14.487  1.00 42.32           C  
ATOM   1352  CG  ASN A 189     -10.927  94.710  15.983  1.00 42.16           C  
ATOM   1353  OD1 ASN A 189     -11.536  95.487  16.697  1.00 40.28           O  
ATOM   1354  ND2 ASN A 189     -10.309  93.626  16.466  1.00 44.84           N  
ATOM   1355  N   GLU A 190      -9.791  96.684  11.871  1.00 44.86           N  
ATOM   1356  CA  GLU A 190      -9.805  96.581  10.424  1.00 46.06           C  
ATOM   1357  C   GLU A 190     -10.107  97.935   9.794  1.00 45.78           C  
ATOM   1358  O   GLU A 190     -10.792  98.743  10.389  1.00 46.38           O  
ATOM   1359  CB  GLU A 190     -10.907  95.619  10.064  1.00 46.72           C  
ATOM   1360  CG  GLU A 190     -10.627  94.706   8.906  1.00 50.32           C  
ATOM   1361  CD  GLU A 190     -11.788  93.720   8.744  1.00 54.09           C  
ATOM   1362  OE1 GLU A 190     -12.660  93.675   9.683  1.00 53.06           O  
ATOM   1363  OE2 GLU A 190     -11.816  93.013   7.699  1.00 52.20           O  
ATOM   1364  N   SER A 191      -9.567  98.196   8.610  1.00 46.01           N  
ATOM   1365  CA  SER A 191      -9.935  99.401   7.882  1.00 46.26           C  
ATOM   1366  C   SER A 191     -10.579  98.954   6.573  1.00 46.72           C  
ATOM   1367  O   SER A 191      -9.971  98.163   5.841  1.00 47.41           O  
ATOM   1368  CB  SER A 191      -8.691 100.264   7.607  1.00 46.77           C  
ATOM   1369  OG  SER A 191      -8.999 101.647   7.579  1.00 43.63           O  
ATOM   1370  N   VAL A 192     -11.802  99.420   6.288  1.00 46.99           N  
ATOM   1371  CA  VAL A 192     -12.502  99.058   5.022  1.00 47.99           C  
ATOM   1372  C   VAL A 192     -12.839 100.335   4.216  1.00 48.75           C  
ATOM   1373  O   VAL A 192     -12.862 101.419   4.797  1.00 49.34           O  
ATOM   1374  CB  VAL A 192     -13.773  98.150   5.261  1.00 47.73           C  
ATOM   1375  CG1 VAL A 192     -13.372  96.807   5.834  1.00 46.75           C  
ATOM   1376  CG2 VAL A 192     -14.767  98.800   6.186  1.00 47.34           C  
ATOM   1377  N   PRO A 193     -13.062 100.246   2.885  1.00 49.10           N  
ATOM   1378  CA  PRO A 193     -13.639 101.515   2.387  1.00 50.15           C  
ATOM   1379  C   PRO A 193     -14.917 101.981   3.134  1.00 50.01           C  
ATOM   1380  O   PRO A 193     -15.613 101.166   3.727  1.00 50.54           O  
ATOM   1381  CB  PRO A 193     -13.856 101.256   0.873  1.00 49.53           C  
ATOM   1382  CG  PRO A 193     -12.859 100.204   0.537  1.00 49.12           C  
ATOM   1383  CD  PRO A 193     -12.810  99.299   1.786  1.00 49.13           C  
ATOM   1384  N   LEU A 194     -15.157 103.292   3.155  1.00 50.17           N  
ATOM   1385  CA  LEU A 194     -16.374 103.860   3.748  1.00 50.00           C  
ATOM   1386  C   LEU A 194     -17.631 103.219   3.203  1.00 50.57           C  
ATOM   1387  O   LEU A 194     -18.545 102.854   3.972  1.00 50.17           O  
ATOM   1388  CB  LEU A 194     -16.414 105.376   3.536  1.00 49.69           C  
ATOM   1389  CG  LEU A 194     -17.569 106.189   4.108  1.00 49.13           C  
ATOM   1390  CD1 LEU A 194     -17.808 105.872   5.568  1.00 45.77           C  
ATOM   1391  CD2 LEU A 194     -17.243 107.685   3.905  1.00 45.54           C  
ATOM   1392  N   ALA A 195     -17.656 103.059   1.875  1.00 51.05           N  
ATOM   1393  CA  ALA A 195     -18.786 102.482   1.171  1.00 51.35           C  
ATOM   1394  C   ALA A 195     -19.196 101.152   1.799  1.00 51.80           C  
ATOM   1395  O   ALA A 195     -20.376 100.781   1.773  1.00 52.31           O  
ATOM   1396  CB  ALA A 195     -18.428 102.298  -0.325  1.00 51.84           C  
ATOM   1397  N   GLN A 196     -18.221 100.450   2.375  1.00 52.14           N  
ATOM   1398  CA  GLN A 196     -18.409  99.120   2.979  1.00 53.03           C  
ATOM   1399  C   GLN A 196     -18.345  99.056   4.557  1.00 53.34           C  
ATOM   1400  O   GLN A 196     -18.359  97.952   5.175  1.00 54.35           O  
ATOM   1401  CB  GLN A 196     -17.411  98.175   2.305  1.00 53.13           C  
ATOM   1402  CG  GLN A 196     -17.603  98.166   0.768  1.00 56.52           C  
ATOM   1403  CD  GLN A 196     -16.298  98.101  -0.005  1.00 60.48           C  
ATOM   1404  OE1 GLN A 196     -15.436  97.254   0.276  1.00 62.48           O  
ATOM   1405  NE2 GLN A 196     -16.143  98.994  -0.998  1.00 61.15           N  
ATOM   1406  N   LEU A 197     -18.318 100.223   5.213  1.00 52.46           N  
ATOM   1407  CA  LEU A 197     -18.230 100.293   6.687  1.00 51.46           C  
ATOM   1408  C   LEU A 197     -19.449  99.718   7.416  1.00 51.08           C  
ATOM   1409  O   LEU A 197     -19.291  98.916   8.339  1.00 50.77           O  
ATOM   1410  CB  LEU A 197     -17.967 101.735   7.162  1.00 50.90           C  
ATOM   1411  CG  LEU A 197     -17.597 101.898   8.638  1.00 51.12           C  
ATOM   1412  CD1 LEU A 197     -16.376 101.088   8.960  1.00 50.58           C  
ATOM   1413  CD2 LEU A 197     -17.381 103.329   9.004  1.00 50.84           C  
ATOM   1414  N   ARG A 198     -20.650 100.152   7.026  1.00 50.88           N  
ATOM   1415  CA  ARG A 198     -21.886  99.766   7.737  1.00 51.10           C  
ATOM   1416  C   ARG A 198     -22.156  98.244   7.656  1.00 50.47           C  
ATOM   1417  O   ARG A 198     -22.634  97.636   8.606  1.00 50.66           O  
ATOM   1418  CB  ARG A 198     -23.077 100.589   7.229  1.00 50.92           C  
ATOM   1419  CG  ARG A 198     -24.304 100.512   8.130  1.00 51.71           C  
ATOM   1420  CD  ARG A 198     -25.491 101.331   7.609  1.00 52.13           C  
ATOM   1421  NE  ARG A 198     -26.579 101.360   8.591  1.00 53.68           N  
ATOM   1422  CZ  ARG A 198     -26.604 102.134   9.695  1.00 57.84           C  
ATOM   1423  NH1 ARG A 198     -25.594 102.986   9.995  1.00 56.04           N  
ATOM   1424  NH2 ARG A 198     -27.652 102.057  10.533  1.00 56.87           N  
ATOM   1425  N   GLU A 199     -21.780  97.660   6.520  1.00 50.29           N  
ATOM   1426  CA  GLU A 199     -21.945  96.254   6.166  1.00 50.14           C  
ATOM   1427  C   GLU A 199     -20.976  95.363   6.937  1.00 49.41           C  
ATOM   1428  O   GLU A 199     -21.363  94.364   7.582  1.00 49.52           O  
ATOM   1429  CB  GLU A 199     -21.648  96.131   4.676  1.00 49.96           C  
ATOM   1430  CG  GLU A 199     -21.895  94.755   4.021  1.00 51.28           C  
ATOM   1431  CD  GLU A 199     -21.755  94.834   2.468  1.00 52.25           C  
ATOM   1432  OE1 GLU A 199     -20.726  95.393   1.949  1.00 48.50           O  
ATOM   1433  OE2 GLU A 199     -22.694  94.346   1.774  1.00 54.75           O  
ATOM   1434  N   VAL A 200     -19.706  95.716   6.843  1.00 48.43           N  
ATOM   1435  CA  VAL A 200     -18.673  94.955   7.502  1.00 47.85           C  
ATOM   1436  C   VAL A 200     -18.951  94.920   9.003  1.00 47.54           C  
ATOM   1437  O   VAL A 200     -18.850  93.842   9.651  1.00 47.34           O  
ATOM   1438  CB  VAL A 200     -17.283  95.509   7.149  1.00 47.59           C  
ATOM   1439  CG1 VAL A 200     -16.229  95.011   8.144  1.00 47.68           C  
ATOM   1440  CG2 VAL A 200     -16.907  95.105   5.710  1.00 46.02           C  
ATOM   1441  N   THR A 201     -19.372  96.082   9.519  1.00 47.03           N  
ATOM   1442  CA  THR A 201     -19.640  96.276  10.956  1.00 47.26           C  
ATOM   1443  C   THR A 201     -20.854  95.489  11.397  1.00 47.31           C  
ATOM   1444  O   THR A 201     -20.832  94.848  12.453  1.00 47.24           O  
ATOM   1445  CB  THR A 201     -19.878  97.768  11.306  1.00 46.93           C  
ATOM   1446  OG1 THR A 201     -18.672  98.528  11.087  1.00 47.42           O  
ATOM   1447  CG2 THR A 201     -20.341  97.930  12.749  1.00 46.49           C  
ATOM   1448  N   ILE A 202     -21.914  95.539  10.583  1.00 47.73           N  
ATOM   1449  CA  ILE A 202     -23.163  94.840  10.907  1.00 47.38           C  
ATOM   1450  C   ILE A 202     -22.905  93.353  10.957  1.00 47.71           C  
ATOM   1451  O   ILE A 202     -23.431  92.659  11.801  1.00 47.29           O  
ATOM   1452  CB  ILE A 202     -24.313  95.263   9.955  1.00 47.51           C  
ATOM   1453  CG1 ILE A 202     -25.007  96.483  10.542  1.00 45.72           C  
ATOM   1454  CG2 ILE A 202     -25.320  94.104   9.653  1.00 46.40           C  
ATOM   1455  CD1 ILE A 202     -25.651  97.310   9.521  1.00 47.69           C  
ATOM   1456  N   GLU A 203     -22.051  92.876  10.066  1.00 48.52           N  
ATOM   1457  CA  GLU A 203     -21.745  91.458  10.029  1.00 49.67           C  
ATOM   1458  C   GLU A 203     -20.983  90.959  11.273  1.00 49.65           C  
ATOM   1459  O   GLU A 203     -21.249  89.860  11.810  1.00 49.78           O  
ATOM   1460  CB  GLU A 203     -20.969  91.155   8.774  1.00 49.65           C  
ATOM   1461  CG  GLU A 203     -21.008  89.739   8.392  1.00 52.70           C  
ATOM   1462  CD  GLU A 203     -20.316  89.578   7.111  1.00 58.21           C  
ATOM   1463  OE1 GLU A 203     -19.115  89.216   7.162  1.00 61.14           O  
ATOM   1464  OE2 GLU A 203     -20.929  89.911   6.066  1.00 60.20           O  
ATOM   1465  N   LEU A 204     -20.021  91.760  11.723  1.00 49.59           N  
ATOM   1466  CA  LEU A 204     -19.393  91.490  12.997  1.00 48.81           C  
ATOM   1467  C   LEU A 204     -20.403  91.628  14.144  1.00 47.96           C  
ATOM   1468  O   LEU A 204     -20.497  90.733  14.968  1.00 48.63           O  
ATOM   1469  CB  LEU A 204     -18.179  92.374  13.185  1.00 49.06           C  
ATOM   1470  CG  LEU A 204     -17.426  92.249  14.485  1.00 48.79           C  
ATOM   1471  CD1 LEU A 204     -16.792  90.858  14.515  1.00 49.42           C  
ATOM   1472  CD2 LEU A 204     -16.408  93.362  14.443  1.00 47.91           C  
ATOM   1473  N   ALA A 205     -21.178  92.711  14.179  1.00 47.27           N  
ATOM   1474  CA  ALA A 205     -22.237  92.865  15.195  1.00 47.01           C  
ATOM   1475  C   ALA A 205     -23.102  91.621  15.293  1.00 47.16           C  
ATOM   1476  O   ALA A 205     -23.403  91.172  16.360  1.00 48.26           O  
ATOM   1477  CB  ALA A 205     -23.103  94.099  14.906  1.00 46.69           C  
ATOM   1478  N   ARG A 206     -23.487  91.061  14.157  1.00 47.57           N  
ATOM   1479  CA  ARG A 206     -24.304  89.880  14.108  1.00 48.38           C  
ATOM   1480  C   ARG A 206     -23.633  88.589  14.565  1.00 48.21           C  
ATOM   1481  O   ARG A 206     -24.320  87.702  15.121  1.00 48.11           O  
ATOM   1482  CB  ARG A 206     -24.910  89.719  12.711  1.00 49.18           C  
ATOM   1483  CG  ARG A 206     -26.345  90.179  12.746  1.00 52.61           C  
ATOM   1484  CD  ARG A 206     -26.766  90.985  11.557  1.00 57.38           C  
ATOM   1485  NE  ARG A 206     -28.005  91.698  11.878  1.00 60.44           N  
ATOM   1486  CZ  ARG A 206     -28.757  92.328  10.978  1.00 62.33           C  
ATOM   1487  NH1 ARG A 206     -29.858  92.945  11.379  1.00 64.10           N  
ATOM   1488  NH2 ARG A 206     -28.406  92.350   9.683  1.00 60.28           N  
ATOM   1489  N   ASN A 207     -22.320  88.458  14.337  1.00 47.89           N  
ATOM   1490  CA  ASN A 207     -21.600  87.287  14.870  1.00 47.68           C  
ATOM   1491  C   ASN A 207     -21.645  87.255  16.420  1.00 47.47           C  
ATOM   1492  O   ASN A 207     -21.754  86.183  17.069  1.00 47.45           O  
ATOM   1493  CB  ASN A 207     -20.162  87.207  14.339  1.00 47.48           C  
ATOM   1494  CG  ASN A 207     -19.346  86.130  15.050  1.00 48.35           C  
ATOM   1495  OD1 ASN A 207     -19.240  84.988  14.589  1.00 50.43           O  
ATOM   1496  ND2 ASN A 207     -18.826  86.471  16.219  1.00 48.59           N  
ATOM   1497  N   LEU A 208     -21.579  88.454  16.992  1.00 46.70           N  
ATOM   1498  CA  LEU A 208     -21.557  88.647  18.437  1.00 45.55           C  
ATOM   1499  C   LEU A 208     -22.934  88.403  19.044  1.00 44.95           C  
ATOM   1500  O   LEU A 208     -23.047  87.982  20.199  1.00 45.50           O  
ATOM   1501  CB  LEU A 208     -21.083  90.076  18.766  1.00 44.98           C  
ATOM   1502  CG  LEU A 208     -19.684  90.592  18.348  1.00 44.10           C  
ATOM   1503  CD1 LEU A 208     -19.460  91.994  18.880  1.00 39.00           C  
ATOM   1504  CD2 LEU A 208     -18.552  89.649  18.780  1.00 43.91           C  
ATOM   1505  N   LEU A 209     -23.978  88.704  18.286  1.00 44.26           N  
ATOM   1506  CA  LEU A 209     -25.356  88.565  18.782  1.00 44.34           C  
ATOM   1507  C   LEU A 209     -25.774  87.103  18.946  1.00 44.09           C  
ATOM   1508  O   LEU A 209     -26.723  86.789  19.644  1.00 43.70           O  
ATOM   1509  CB  LEU A 209     -26.324  89.267  17.830  1.00 43.84           C  
ATOM   1510  CG  LEU A 209     -26.452  90.742  18.119  1.00 42.83           C  
ATOM   1511  CD1 LEU A 209     -27.309  91.367  17.030  1.00 43.16           C  
ATOM   1512  CD2 LEU A 209     -27.067  90.889  19.505  1.00 39.75           C  
ATOM   1513  N   GLU A 210     -25.046  86.244  18.245  1.00 44.83           N  
ATOM   1514  CA  GLU A 210     -25.159  84.811  18.298  1.00 45.65           C  
ATOM   1515  C   GLU A 210     -24.536  84.231  19.569  1.00 46.18           C  
ATOM   1516  O   GLU A 210     -24.806  83.078  19.916  1.00 46.57           O  
ATOM   1517  CB  GLU A 210     -24.484  84.227  17.059  1.00 45.50           C  
ATOM   1518  CG  GLU A 210     -25.294  84.494  15.842  1.00 48.75           C  
ATOM   1519  CD  GLU A 210     -24.622  84.015  14.577  1.00 54.58           C  
ATOM   1520  OE1 GLU A 210     -23.684  83.179  14.686  1.00 56.14           O  
ATOM   1521  OE2 GLU A 210     -25.028  84.486  13.474  1.00 54.13           O  
ATOM   1522  N   LYS A 211     -23.716  85.023  20.276  1.00 46.07           N  
ATOM   1523  CA  LYS A 211     -23.144  84.555  21.540  1.00 45.70           C  
ATOM   1524  C   LYS A 211     -24.133  84.748  22.714  1.00 46.21           C  
ATOM   1525  O   LYS A 211     -24.941  85.687  22.701  1.00 46.55           O  
ATOM   1526  CB  LYS A 211     -21.778  85.208  21.823  1.00 44.51           C  
ATOM   1527  CG  LYS A 211     -20.794  85.338  20.606  1.00 43.36           C  
ATOM   1528  CD  LYS A 211     -20.399  84.008  19.883  1.00 41.15           C  
ATOM   1529  CE  LYS A 211     -19.447  84.254  18.692  1.00 40.96           C  
ATOM   1530  NZ  LYS A 211     -19.333  83.047  17.806  1.00 43.14           N  
ATOM   1531  N   ASN A 212     -24.094  83.835  23.689  1.00 45.70           N  
ATOM   1532  CA  ASN A 212     -24.754  84.063  24.957  1.00 46.27           C  
ATOM   1533  C   ASN A 212     -24.176  85.365  25.591  1.00 46.69           C  
ATOM   1534  O   ASN A 212     -22.960  85.448  25.857  1.00 46.13           O  
ATOM   1535  CB  ASN A 212     -24.561  82.828  25.846  1.00 45.73           C  
ATOM   1536  CG  ASN A 212     -25.432  82.847  27.131  1.00 46.89           C  
ATOM   1537  OD1 ASN A 212     -25.709  83.902  27.719  1.00 48.27           O  
ATOM   1538  ND2 ASN A 212     -25.810  81.643  27.596  1.00 42.47           N  
ATOM   1539  N   PRO A 213     -25.035  86.396  25.805  1.00 47.21           N  
ATOM   1540  CA  PRO A 213     -24.541  87.697  26.317  1.00 47.02           C  
ATOM   1541  C   PRO A 213     -23.689  87.580  27.594  1.00 47.36           C  
ATOM   1542  O   PRO A 213     -22.574  88.131  27.637  1.00 48.12           O  
ATOM   1543  CB  PRO A 213     -25.822  88.513  26.591  1.00 47.78           C  
ATOM   1544  CG  PRO A 213     -26.937  87.814  25.889  1.00 46.91           C  
ATOM   1545  CD  PRO A 213     -26.498  86.390  25.566  1.00 47.11           C  
ATOM   1546  N   VAL A 214     -24.187  86.870  28.616  1.00 46.47           N  
ATOM   1547  CA  VAL A 214     -23.481  86.772  29.913  1.00 45.78           C  
ATOM   1548  C   VAL A 214     -22.073  86.156  29.805  1.00 45.30           C  
ATOM   1549  O   VAL A 214     -21.153  86.556  30.510  1.00 45.31           O  
ATOM   1550  CB  VAL A 214     -24.318  85.987  30.948  1.00 45.61           C  
ATOM   1551  CG1 VAL A 214     -23.535  85.785  32.243  1.00 45.78           C  
ATOM   1552  CG2 VAL A 214     -25.656  86.698  31.200  1.00 44.15           C  
ATOM   1553  N   VAL A 215     -21.958  85.167  28.924  1.00 45.25           N  
ATOM   1554  CA  VAL A 215     -20.731  84.463  28.547  1.00 44.68           C  
ATOM   1555  C   VAL A 215     -19.790  85.387  27.771  1.00 45.00           C  
ATOM   1556  O   VAL A 215     -18.578  85.258  27.905  1.00 46.10           O  
ATOM   1557  CB  VAL A 215     -21.096  83.191  27.700  1.00 44.49           C  
ATOM   1558  CG1 VAL A 215     -19.869  82.454  27.174  1.00 43.48           C  
ATOM   1559  CG2 VAL A 215     -21.924  82.256  28.530  1.00 43.95           C  
ATOM   1560  N   LEU A 216     -20.348  86.315  26.985  1.00 44.45           N  
ATOM   1561  CA  LEU A 216     -19.567  87.224  26.168  1.00 44.61           C  
ATOM   1562  C   LEU A 216     -18.964  88.304  27.077  1.00 45.53           C  
ATOM   1563  O   LEU A 216     -17.796  88.704  26.925  1.00 45.19           O  
ATOM   1564  CB  LEU A 216     -20.446  87.897  25.092  1.00 44.34           C  
ATOM   1565  CG  LEU A 216     -19.923  88.214  23.673  1.00 42.91           C  
ATOM   1566  CD1 LEU A 216     -20.760  89.271  23.014  1.00 40.55           C  
ATOM   1567  CD2 LEU A 216     -18.469  88.571  23.618  1.00 40.34           C  
ATOM   1568  N   ARG A 217     -19.786  88.774  28.014  1.00 45.99           N  
ATOM   1569  CA  ARG A 217     -19.376  89.749  29.014  1.00 45.95           C  
ATOM   1570  C   ARG A 217     -18.238  89.188  29.888  1.00 44.96           C  
ATOM   1571  O   ARG A 217     -17.273  89.858  30.135  1.00 45.03           O  
ATOM   1572  CB  ARG A 217     -20.604  90.099  29.864  1.00 46.13           C  
ATOM   1573  CG  ARG A 217     -20.474  91.347  30.705  1.00 49.50           C  
ATOM   1574  CD  ARG A 217     -21.546  91.397  31.800  1.00 51.76           C  
ATOM   1575  NE  ARG A 217     -22.864  91.230  31.192  1.00 55.59           N  
ATOM   1576  CZ  ARG A 217     -23.910  90.679  31.801  1.00 54.89           C  
ATOM   1577  NH1 ARG A 217     -23.785  90.235  33.034  1.00 53.46           N  
ATOM   1578  NH2 ARG A 217     -25.068  90.543  31.151  1.00 54.39           N  
ATOM   1579  N   ALA A 218     -18.344  87.947  30.329  1.00 44.04           N  
ATOM   1580  CA  ALA A 218     -17.289  87.315  31.134  1.00 42.66           C  
ATOM   1581  C   ALA A 218     -15.951  87.262  30.396  1.00 41.21           C  
ATOM   1582  O   ALA A 218     -14.866  87.425  30.985  1.00 39.75           O  
ATOM   1583  CB  ALA A 218     -17.722  85.870  31.509  1.00 43.30           C  
ATOM   1584  N   ALA A 219     -16.046  86.965  29.105  1.00 40.43           N  
ATOM   1585  CA  ALA A 219     -14.860  86.721  28.301  1.00 40.35           C  
ATOM   1586  C   ALA A 219     -14.109  88.053  27.983  1.00 40.38           C  
ATOM   1587  O   ALA A 219     -12.896  88.137  28.194  1.00 40.40           O  
ATOM   1588  CB  ALA A 219     -15.219  85.893  27.003  1.00 39.35           C  
ATOM   1589  N   LYS A 220     -14.850  89.080  27.566  1.00 39.57           N  
ATOM   1590  CA  LYS A 220     -14.278  90.390  27.213  1.00 40.61           C  
ATOM   1591  C   LYS A 220     -13.828  91.236  28.408  1.00 41.44           C  
ATOM   1592  O   LYS A 220     -12.816  91.894  28.353  1.00 42.86           O  
ATOM   1593  CB  LYS A 220     -15.249  91.176  26.315  1.00 39.84           C  
ATOM   1594  CG  LYS A 220     -16.504  91.705  26.997  1.00 40.37           C  
ATOM   1595  CD  LYS A 220     -17.649  91.912  25.995  1.00 40.59           C  
ATOM   1596  CE  LYS A 220     -18.782  92.742  26.578  1.00 43.65           C  
ATOM   1597  NZ  LYS A 220     -18.294  94.131  26.953  1.00 44.23           N  
ATOM   1598  N   HIS A 221     -14.583  91.213  29.502  1.00 42.70           N  
ATOM   1599  CA  HIS A 221     -14.172  91.832  30.764  1.00 40.92           C  
ATOM   1600  C   HIS A 221     -13.002  91.103  31.354  1.00 40.62           C  
ATOM   1601  O   HIS A 221     -12.078  91.732  31.862  1.00 41.63           O  
ATOM   1602  CB  HIS A 221     -15.316  91.754  31.764  1.00 41.06           C  
ATOM   1603  CG  HIS A 221     -16.470  92.613  31.391  1.00 38.18           C  
ATOM   1604  ND1 HIS A 221     -17.528  92.838  32.232  1.00 39.33           N  
ATOM   1605  CD2 HIS A 221     -16.735  93.291  30.252  1.00 38.59           C  
ATOM   1606  CE1 HIS A 221     -18.386  93.655  31.645  1.00 42.98           C  
ATOM   1607  NE2 HIS A 221     -17.934  93.934  30.433  1.00 41.47           N  
ATOM   1608  N   GLY A 222     -13.046  89.780  31.313  1.00 39.95           N  
ATOM   1609  CA  GLY A 222     -11.922  88.998  31.807  1.00 38.83           C  
ATOM   1610  C   GLY A 222     -10.649  89.248  31.023  1.00 38.22           C  
ATOM   1611  O   GLY A 222      -9.577  89.332  31.592  1.00 37.97           O  
ATOM   1612  N   PHE A 223     -10.749  89.395  29.708  1.00 38.85           N  
ATOM   1613  CA  PHE A 223      -9.558  89.670  28.947  1.00 38.98           C  
ATOM   1614  C   PHE A 223      -8.935  91.033  29.275  1.00 39.87           C  
ATOM   1615  O   PHE A 223      -7.715  91.106  29.430  1.00 41.72           O  
ATOM   1616  CB  PHE A 223      -9.744  89.524  27.437  1.00 39.02           C  
ATOM   1617  CG  PHE A 223      -8.525  89.952  26.677  1.00 39.16           C  
ATOM   1618  CD1 PHE A 223      -8.366  91.297  26.269  1.00 40.58           C  
ATOM   1619  CD2 PHE A 223      -7.486  89.071  26.460  1.00 39.67           C  
ATOM   1620  CE1 PHE A 223      -7.213  91.736  25.638  1.00 36.55           C  
ATOM   1621  CE2 PHE A 223      -6.333  89.514  25.823  1.00 38.48           C  
ATOM   1622  CZ  PHE A 223      -6.209  90.871  25.426  1.00 37.30           C  
ATOM   1623  N   LYS A 224      -9.731  92.108  29.358  1.00 39.17           N  
ATOM   1624  CA  LYS A 224      -9.199  93.435  29.577  1.00 38.23           C  
ATOM   1625  C   LYS A 224      -8.566  93.510  30.956  1.00 39.16           C  
ATOM   1626  O   LYS A 224      -7.532  94.208  31.140  1.00 37.96           O  
ATOM   1627  CB  LYS A 224     -10.312  94.474  29.529  1.00 38.81           C  
ATOM   1628  CG  LYS A 224     -11.110  94.452  28.256  1.00 38.18           C  
ATOM   1629  CD  LYS A 224     -11.692  95.812  27.939  1.00 33.78           C  
ATOM   1630  CE  LYS A 224     -12.679  95.738  26.815  1.00 36.79           C  
ATOM   1631  NZ  LYS A 224     -13.320  97.089  26.454  1.00 34.47           N  
ATOM   1632  N   ARG A 225      -9.193  92.808  31.934  1.00 38.25           N  
ATOM   1633  CA  ARG A 225      -8.713  92.809  33.317  1.00 36.76           C  
ATOM   1634  C   ARG A 225      -7.484  91.974  33.466  1.00 35.78           C  
ATOM   1635  O   ARG A 225      -6.625  92.330  34.223  1.00 36.72           O  
ATOM   1636  CB  ARG A 225      -9.784  92.346  34.314  1.00 36.83           C  
ATOM   1637  CG  ARG A 225      -9.306  92.361  35.782  1.00 39.16           C  
ATOM   1638  CD  ARG A 225      -9.343  93.759  36.339  1.00 41.58           C  
ATOM   1639  NE  ARG A 225     -10.694  94.337  36.287  1.00 43.89           N  
ATOM   1640  CZ  ARG A 225     -10.932  95.643  36.219  1.00 43.52           C  
ATOM   1641  NH1 ARG A 225     -12.185  96.066  36.190  1.00 37.55           N  
ATOM   1642  NH2 ARG A 225      -9.907  96.523  36.166  1.00 41.19           N  
ATOM   1643  N   CYS A 226      -7.380  90.862  32.758  1.00 34.93           N  
ATOM   1644  CA  CYS A 226      -6.214  89.984  32.939  1.00 35.38           C  
ATOM   1645  C   CYS A 226      -4.840  90.589  32.548  1.00 35.76           C  
ATOM   1646  O   CYS A 226      -3.762  90.167  33.081  1.00 35.88           O  
ATOM   1647  CB  CYS A 226      -6.445  88.626  32.260  1.00 35.66           C  
ATOM   1648  SG  CYS A 226      -6.044  88.514  30.502  1.00 35.58           S  
ATOM   1649  N   ARG A 227      -4.895  91.551  31.625  1.00 35.56           N  
ATOM   1650  CA  ARG A 227      -3.764  92.384  31.221  1.00 35.12           C  
ATOM   1651  C   ARG A 227      -3.154  93.103  32.453  1.00 36.01           C  
ATOM   1652  O   ARG A 227      -1.963  93.400  32.521  1.00 36.61           O  
ATOM   1653  CB  ARG A 227      -4.284  93.412  30.215  1.00 35.07           C  
ATOM   1654  CG  ARG A 227      -4.984  92.809  28.956  1.00 33.18           C  
ATOM   1655  CD  ARG A 227      -4.949  93.821  27.744  1.00 35.20           C  
ATOM   1656  NE  ARG A 227      -3.569  94.239  27.469  1.00 34.38           N  
ATOM   1657  CZ  ARG A 227      -3.216  95.262  26.679  1.00 38.00           C  
ATOM   1658  NH1 ARG A 227      -4.126  95.971  26.048  1.00 33.18           N  
ATOM   1659  NH2 ARG A 227      -1.921  95.570  26.494  1.00 32.39           N  
ATOM   1660  N   GLU A 228      -3.955  93.340  33.481  1.00 36.78           N  
ATOM   1661  CA  GLU A 228      -3.462  94.047  34.674  1.00 35.49           C  
ATOM   1662  C   GLU A 228      -2.882  93.100  35.760  1.00 35.93           C  
ATOM   1663  O   GLU A 228      -2.264  93.538  36.760  1.00 34.94           O  
ATOM   1664  CB  GLU A 228      -4.607  94.878  35.183  1.00 35.69           C  
ATOM   1665  CG  GLU A 228      -5.298  95.801  34.100  1.00 34.88           C  
ATOM   1666  CD  GLU A 228      -6.537  96.520  34.665  1.00 36.31           C  
ATOM   1667  OE1 GLU A 228      -7.013  96.126  35.743  1.00 39.72           O  
ATOM   1668  OE2 GLU A 228      -7.037  97.495  34.083  1.00 36.80           O  
ATOM   1669  N   LEU A 229      -3.110  91.791  35.590  1.00 35.86           N  
ATOM   1670  CA  LEU A 229      -2.861  90.823  36.661  1.00 35.16           C  
ATOM   1671  C   LEU A 229      -1.770  89.915  36.276  1.00 34.22           C  
ATOM   1672  O   LEU A 229      -1.638  89.619  35.110  1.00 35.58           O  
ATOM   1673  CB  LEU A 229      -4.142  90.011  36.953  1.00 36.35           C  
ATOM   1674  CG  LEU A 229      -5.119  90.541  38.029  1.00 38.38           C  
ATOM   1675  CD1 LEU A 229      -5.182  92.033  38.121  1.00 37.39           C  
ATOM   1676  CD2 LEU A 229      -6.523  89.990  37.861  1.00 36.56           C  
ATOM   1677  N   THR A 230      -0.998  89.428  37.244  1.00 34.06           N  
ATOM   1678  CA  THR A 230      -0.001  88.372  37.005  1.00 32.69           C  
ATOM   1679  C   THR A 230      -0.720  87.045  36.634  1.00 34.23           C  
ATOM   1680  O   THR A 230      -1.969  86.968  36.700  1.00 34.13           O  
ATOM   1681  CB  THR A 230       0.871  88.125  38.244  1.00 31.17           C  
ATOM   1682  OG1 THR A 230       0.037  87.560  39.286  1.00 32.21           O  
ATOM   1683  CG2 THR A 230       1.495  89.414  38.729  1.00 30.16           C  
ATOM   1684  N   TRP A 231       0.066  86.027  36.240  1.00 33.26           N  
ATOM   1685  CA  TRP A 231      -0.458  84.701  35.932  1.00 34.71           C  
ATOM   1686  C   TRP A 231      -1.120  84.055  37.169  1.00 35.63           C  
ATOM   1687  O   TRP A 231      -2.235  83.512  37.104  1.00 36.69           O  
ATOM   1688  CB  TRP A 231       0.660  83.789  35.359  1.00 33.29           C  
ATOM   1689  CG  TRP A 231       0.940  84.050  33.880  1.00 35.36           C  
ATOM   1690  CD1 TRP A 231       1.398  85.216  33.315  1.00 32.03           C  
ATOM   1691  CD2 TRP A 231       0.733  83.130  32.776  1.00 33.98           C  
ATOM   1692  NE1 TRP A 231       1.499  85.089  31.969  1.00 30.37           N  
ATOM   1693  CE2 TRP A 231       1.108  83.824  31.593  1.00 35.14           C  
ATOM   1694  CE3 TRP A 231       0.295  81.796  32.684  1.00 30.76           C  
ATOM   1695  CZ2 TRP A 231       1.066  83.217  30.308  1.00 33.37           C  
ATOM   1696  CZ3 TRP A 231       0.254  81.173  31.402  1.00 33.81           C  
ATOM   1697  CH2 TRP A 231       0.620  81.900  30.233  1.00 34.96           C  
ATOM   1698  N   GLU A 232      -0.436  84.125  38.305  1.00 36.37           N  
ATOM   1699  CA  GLU A 232      -1.006  83.636  39.529  1.00 36.93           C  
ATOM   1700  C   GLU A 232      -2.283  84.346  39.953  1.00 36.09           C  
ATOM   1701  O   GLU A 232      -3.182  83.686  40.498  1.00 37.31           O  
ATOM   1702  CB  GLU A 232       0.023  83.749  40.645  1.00 37.34           C  
ATOM   1703  CG  GLU A 232       1.291  82.942  40.305  1.00 46.02           C  
ATOM   1704  CD  GLU A 232       2.337  83.660  39.332  1.00 54.36           C  
ATOM   1705  OE1 GLU A 232       2.500  84.960  39.321  1.00 48.56           O  
ATOM   1706  OE2 GLU A 232       3.010  82.833  38.615  1.00 56.91           O  
ATOM   1707  N   GLN A 233      -2.337  85.679  39.817  1.00 34.42           N  
ATOM   1708  CA  GLN A 233      -3.561  86.430  40.162  1.00 33.14           C  
ATOM   1709  C   GLN A 233      -4.668  86.026  39.239  1.00 32.34           C  
ATOM   1710  O   GLN A 233      -5.831  85.860  39.658  1.00 31.47           O  
ATOM   1711  CB  GLN A 233      -3.367  87.962  40.117  1.00 32.04           C  
ATOM   1712  CG  GLN A 233      -2.461  88.456  41.270  1.00 31.33           C  
ATOM   1713  CD  GLN A 233      -2.085  89.967  41.120  1.00 34.22           C  
ATOM   1714  OE1 GLN A 233      -1.964  90.712  42.106  1.00 35.54           O  
ATOM   1715  NE2 GLN A 233      -1.888  90.385  39.914  1.00 34.89           N  
ATOM   1716  N   ASN A 234      -4.284  85.821  37.989  1.00 32.26           N  
ATOM   1717  CA  ASN A 234      -5.244  85.424  36.955  1.00 34.16           C  
ATOM   1718  C   ASN A 234      -5.831  83.984  37.100  1.00 34.02           C  
ATOM   1719  O   ASN A 234      -6.936  83.739  36.695  1.00 35.04           O  
ATOM   1720  CB  ASN A 234      -4.682  85.691  35.554  1.00 33.37           C  
ATOM   1721  CG  ASN A 234      -4.946  87.099  35.086  1.00 33.95           C  
ATOM   1722  OD1 ASN A 234      -6.058  87.632  35.251  1.00 36.21           O  
ATOM   1723  ND2 ASN A 234      -3.950  87.710  34.457  1.00 29.38           N  
ATOM   1724  N   GLU A 235      -5.123  83.067  37.730  1.00 34.86           N  
ATOM   1725  CA  GLU A 235      -5.666  81.755  37.925  1.00 36.23           C  
ATOM   1726  C   GLU A 235      -6.914  81.874  38.791  1.00 37.00           C  
ATOM   1727  O   GLU A 235      -7.934  81.261  38.503  1.00 37.27           O  
ATOM   1728  CB  GLU A 235      -4.659  80.832  38.636  1.00 37.41           C  
ATOM   1729  CG  GLU A 235      -5.158  79.356  38.637  1.00 34.10           C  
ATOM   1730  CD  GLU A 235      -4.344  78.443  39.522  1.00 37.23           C  
ATOM   1731  OE1 GLU A 235      -3.672  78.937  40.495  1.00 32.63           O  
ATOM   1732  OE2 GLU A 235      -4.410  77.199  39.240  1.00 38.40           O  
ATOM   1733  N   ASP A 236      -6.781  82.668  39.857  1.00 36.78           N  
ATOM   1734  CA  ASP A 236      -7.857  83.007  40.770  1.00 37.28           C  
ATOM   1735  C   ASP A 236      -8.948  83.815  40.044  1.00 36.46           C  
ATOM   1736  O   ASP A 236     -10.124  83.474  40.085  1.00 37.20           O  
ATOM   1737  CB  ASP A 236      -7.267  83.782  41.957  1.00 36.99           C  
ATOM   1738  CG  ASP A 236      -8.273  84.094  42.993  1.00 38.02           C  
ATOM   1739  OD1 ASP A 236      -9.450  83.761  42.744  1.00 38.05           O  
ATOM   1740  OD2 ASP A 236      -7.888  84.673  44.045  1.00 32.06           O  
ATOM   1741  N   TYR A 237      -8.547  84.871  39.354  1.00 36.01           N  
ATOM   1742  CA  TYR A 237      -9.482  85.825  38.825  1.00 33.48           C  
ATOM   1743  C   TYR A 237     -10.269  85.230  37.616  1.00 34.19           C  
ATOM   1744  O   TYR A 237     -11.504  85.418  37.528  1.00 33.41           O  
ATOM   1745  CB  TYR A 237      -8.719  87.091  38.411  1.00 33.57           C  
ATOM   1746  CG  TYR A 237      -9.589  87.936  37.514  1.00 33.18           C  
ATOM   1747  CD1 TYR A 237      -9.505  87.875  36.129  1.00 34.08           C  
ATOM   1748  CD2 TYR A 237     -10.575  88.733  38.066  1.00 36.78           C  
ATOM   1749  CE1 TYR A 237     -10.355  88.650  35.324  1.00 32.77           C  
ATOM   1750  CE2 TYR A 237     -11.426  89.490  37.277  1.00 37.39           C  
ATOM   1751  CZ  TYR A 237     -11.324  89.446  35.923  1.00 33.74           C  
ATOM   1752  OH  TYR A 237     -12.231  90.247  35.237  1.00 32.50           O  
ATOM   1753  N   LEU A 238      -9.564  84.571  36.662  1.00 32.77           N  
ATOM   1754  CA  LEU A 238     -10.251  83.994  35.459  1.00 33.38           C  
ATOM   1755  C   LEU A 238     -11.169  82.806  35.758  1.00 33.87           C  
ATOM   1756  O   LEU A 238     -12.152  82.624  35.091  1.00 33.61           O  
ATOM   1757  CB  LEU A 238      -9.258  83.605  34.372  1.00 31.42           C  
ATOM   1758  CG  LEU A 238      -8.437  84.791  33.849  1.00 33.71           C  
ATOM   1759  CD1 LEU A 238      -7.073  84.400  33.125  1.00 31.68           C  
ATOM   1760  CD2 LEU A 238      -9.353  85.730  33.016  1.00 29.49           C  
ATOM   1761  N   TYR A 239     -10.829  82.003  36.770  1.00 35.35           N  
ATOM   1762  CA  TYR A 239     -11.670  80.881  37.174  1.00 35.10           C  
ATOM   1763  C   TYR A 239     -12.858  81.425  37.903  1.00 35.15           C  
ATOM   1764  O   TYR A 239     -13.923  80.889  37.743  1.00 36.04           O  
ATOM   1765  CB  TYR A 239     -10.917  79.851  38.015  1.00 34.71           C  
ATOM   1766  CG  TYR A 239     -10.305  78.710  37.218  1.00 34.96           C  
ATOM   1767  CD1 TYR A 239      -8.938  78.428  37.314  1.00 36.10           C  
ATOM   1768  CD2 TYR A 239     -11.084  77.896  36.388  1.00 35.02           C  
ATOM   1769  CE1 TYR A 239      -8.366  77.348  36.625  1.00 35.99           C  
ATOM   1770  CE2 TYR A 239     -10.516  76.805  35.662  1.00 34.31           C  
ATOM   1771  CZ  TYR A 239      -9.150  76.537  35.790  1.00 35.50           C  
ATOM   1772  OH  TYR A 239      -8.531  75.478  35.106  1.00 32.53           O  
ATOM   1773  N   ALA A 240     -12.699  82.524  38.649  1.00 35.93           N  
ATOM   1774  CA  ALA A 240     -13.853  83.198  39.259  1.00 36.55           C  
ATOM   1775  C   ALA A 240     -14.751  83.767  38.164  1.00 37.01           C  
ATOM   1776  O   ALA A 240     -15.976  83.680  38.250  1.00 38.47           O  
ATOM   1777  CB  ALA A 240     -13.443  84.290  40.296  1.00 36.01           C  
ATOM   1778  N   LYS A 241     -14.174  84.319  37.114  1.00 36.81           N  
ATOM   1779  CA  LYS A 241     -15.043  84.952  36.116  1.00 37.12           C  
ATOM   1780  C   LYS A 241     -15.867  83.881  35.436  1.00 37.16           C  
ATOM   1781  O   LYS A 241     -17.016  84.118  35.103  1.00 39.05           O  
ATOM   1782  CB  LYS A 241     -14.248  85.779  35.077  1.00 35.83           C  
ATOM   1783  CG  LYS A 241     -13.783  87.131  35.536  1.00 34.10           C  
ATOM   1784  CD  LYS A 241     -14.897  87.979  36.182  1.00 34.98           C  
ATOM   1785  CE  LYS A 241     -15.591  88.882  35.186  1.00 30.62           C  
ATOM   1786  NZ  LYS A 241     -16.557  89.821  35.807  1.00 30.15           N  
ATOM   1787  N   LEU A 242     -15.250  82.720  35.200  1.00 37.01           N  
ATOM   1788  CA  LEU A 242     -15.825  81.579  34.472  1.00 36.74           C  
ATOM   1789  C   LEU A 242     -16.988  81.035  35.256  1.00 37.02           C  
ATOM   1790  O   LEU A 242     -18.001  80.685  34.650  1.00 37.70           O  
ATOM   1791  CB  LEU A 242     -14.764  80.460  34.339  1.00 37.45           C  
ATOM   1792  CG  LEU A 242     -14.809  79.049  33.695  1.00 36.33           C  
ATOM   1793  CD1 LEU A 242     -15.558  78.012  34.443  1.00 37.89           C  
ATOM   1794  CD2 LEU A 242     -15.350  79.112  32.352  1.00 40.04           C  
ATOM   1795  N   ASP A 243     -16.821  80.953  36.583  1.00 36.09           N  
ATOM   1796  CA  ASP A 243     -17.803  80.360  37.523  1.00 37.24           C  
ATOM   1797  C   ASP A 243     -18.978  81.298  37.787  1.00 38.54           C  
ATOM   1798  O   ASP A 243     -20.121  80.834  37.966  1.00 37.48           O  
ATOM   1799  CB  ASP A 243     -17.166  80.056  38.887  1.00 35.95           C  
ATOM   1800  CG  ASP A 243     -16.314  78.795  38.896  1.00 35.95           C  
ATOM   1801  OD1 ASP A 243     -16.385  77.954  37.960  1.00 37.04           O  
ATOM   1802  OD2 ASP A 243     -15.575  78.623  39.893  1.00 35.52           O  
ATOM   1803  N   GLN A 244     -18.675  82.609  37.882  1.00 38.72           N  
ATOM   1804  CA  GLN A 244     -19.685  83.671  37.814  1.00 39.70           C  
ATOM   1805  C   GLN A 244     -20.532  83.574  36.510  1.00 40.84           C  
ATOM   1806  O   GLN A 244     -21.765  83.721  36.527  1.00 41.27           O  
ATOM   1807  CB  GLN A 244     -18.968  85.045  37.939  1.00 40.60           C  
ATOM   1808  CG  GLN A 244     -19.836  86.311  37.791  1.00 39.87           C  
ATOM   1809  CD  GLN A 244     -19.026  87.621  37.877  1.00 39.10           C  
ATOM   1810  OE1 GLN A 244     -19.225  88.415  38.800  1.00 37.54           O  
ATOM   1811  NE2 GLN A 244     -18.132  87.849  36.902  1.00 35.18           N  
ATOM   1812  N   SER A 245     -19.875  83.313  35.386  1.00 41.64           N  
ATOM   1813  CA  SER A 245     -20.557  83.116  34.133  1.00 43.24           C  
ATOM   1814  C   SER A 245     -21.582  81.956  34.206  1.00 45.46           C  
ATOM   1815  O   SER A 245     -22.766  82.118  33.879  1.00 45.80           O  
ATOM   1816  CB  SER A 245     -19.550  82.785  33.057  1.00 42.87           C  
ATOM   1817  OG  SER A 245     -20.171  82.833  31.793  1.00 39.95           O  
ATOM   1818  N   ARG A 246     -21.106  80.793  34.632  1.00 47.27           N  
ATOM   1819  CA  ARG A 246     -21.904  79.580  34.706  1.00 48.58           C  
ATOM   1820  C   ARG A 246     -23.117  79.747  35.628  1.00 49.86           C  
ATOM   1821  O   ARG A 246     -24.043  78.976  35.533  1.00 50.65           O  
ATOM   1822  CB  ARG A 246     -21.014  78.398  35.129  1.00 48.57           C  
ATOM   1823  N   LEU A 247     -23.113  80.760  36.494  1.00 51.76           N  
ATOM   1824  CA  LEU A 247     -24.213  81.036  37.440  1.00 53.14           C  
ATOM   1825  C   LEU A 247     -25.255  82.001  36.865  1.00 54.79           C  
ATOM   1826  O   LEU A 247     -26.453  81.803  37.002  1.00 55.16           O  
ATOM   1827  CB  LEU A 247     -23.659  81.615  38.754  1.00 52.36           C  
ATOM   1828  CG  LEU A 247     -24.684  82.179  39.772  1.00 52.63           C  
ATOM   1829  CD1 LEU A 247     -25.279  81.087  40.678  1.00 51.23           C  
ATOM   1830  CD2 LEU A 247     -24.141  83.325  40.621  1.00 52.60           C  
ATOM   1831  N   LEU A 248     -24.772  83.066  36.245  1.00 57.33           N  
ATOM   1832  CA  LEU A 248     -25.609  84.112  35.676  1.00 59.41           C  
ATOM   1833  C   LEU A 248     -26.115  83.645  34.321  1.00 61.01           C  
ATOM   1834  O   LEU A 248     -27.064  84.211  33.780  1.00 61.74           O  
ATOM   1835  CB  LEU A 248     -24.811  85.431  35.622  1.00 59.58           C  
ATOM   1836  CG  LEU A 248     -24.202  85.797  36.990  1.00 59.37           C  
ATOM   1837  CD1 LEU A 248     -23.282  86.981  36.883  1.00 61.45           C  
ATOM   1838  CD2 LEU A 248     -25.305  86.048  38.045  1.00 60.45           C  
ATOM   1839  N   ASP A 249     -25.411  82.642  33.781  1.00 62.81           N  
ATOM   1840  CA  ASP A 249     -25.923  81.495  32.967  1.00 64.71           C  
ATOM   1841  C   ASP A 249     -26.049  81.648  31.481  1.00 65.38           C  
ATOM   1842  O   ASP A 249     -25.153  81.081  30.856  1.00 66.42           O  
ATOM   1843  CB  ASP A 249     -27.071  80.634  33.629  1.00 65.15           C  
ATOM   1844  CG  ASP A 249     -28.480  80.872  33.028  1.00 66.92           C  
ATOM   1845  OD1 ASP A 249     -29.079  79.927  32.450  1.00 67.21           O  
ATOM   1846  OD2 ASP A 249     -29.013  81.992  33.165  1.00 68.40           O  
ATOM   1847  N   THR A 250     -26.961  82.264  30.909  1.00 65.85           N  
TER    1848      THR A 250                                                      
END
MOLECULE T0486_32_232.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37          
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38          
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70          
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10          
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93          
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74          
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85          
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52          
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98          
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20          
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12          
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44          
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76          
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22          
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88          
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19          
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16          
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96          
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90          
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60          
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42          
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04          
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80          
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60          
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72          
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90          
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12          
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50          
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34          
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08          
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98          
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83          
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38          
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75          
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55          
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93          
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57          
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02          
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96          
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11          
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60          
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34          
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07          
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41          
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20          
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68          
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69          
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47          
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71          
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50          
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89          
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00          
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56          
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50          
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27          
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41          
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43          
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76          
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82          
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67          
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57          
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80          
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33          
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93          
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93          
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82          
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78          
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15          
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38          
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92          
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12          
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46          
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32          
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91          
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72          
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36          
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80          
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87          
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53          
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42          
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29          
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56          
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21          
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49          
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12          
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15          
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41          
ATOM    177  CD  ILE    43     -27.448  94.223  14.517  1.00 10.50          
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46          
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28          
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83          
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01          
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37          
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76          
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54          
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79          
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47          
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91          
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61          
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62          
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83          
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07          
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00          
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31          
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09          
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78          
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25          
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97          
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17          
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97          
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93          
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48          
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23          
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43          
ATOM    234  CD  ILE    46     -25.395 104.142  22.715  1.00 16.72          
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84          
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86          
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65          
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12          
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92          
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43          
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15          
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51          
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23          
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54          
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26          
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61          
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28          
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00          
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01          
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34          
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02          
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61          
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00          
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54          
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42          
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18          
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35          
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03          
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55          
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37          
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55          
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36          
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36          
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58          
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76          
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99          
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55          
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89          
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83          
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67          
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65          
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99          
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27          
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59          
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04          
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46          
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43          
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83          
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90          
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95          
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04          
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00          
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27          
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34          
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68          
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09          
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62          
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41          
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15          
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39          
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49          
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24          
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47          
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32          
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47          
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75          
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96          
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60          
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42          
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25          
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54          
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50          
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41          
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53          
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60          
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75          
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70          
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45          
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17          
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76          
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81          
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14          
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32          
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51          
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32          
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23          
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89          
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28          
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00          
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16          
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91          
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44          
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04          
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02          
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07          
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63          
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85          
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18          
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08          
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91          
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31          
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05          
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20          
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29          
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34          
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50          
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33          
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25          
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30          
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56          
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09          
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39          
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42          
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30          
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87          
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95          
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26          
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67          
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86          
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50          
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05          
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43          
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64          
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44          
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71          
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89          
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69          
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86          
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70          
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18          
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85          
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45          
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19          
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09          
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16          
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99          
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16          
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71          
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48          
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11          
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90          
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94          
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77          
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75          
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13          
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27          
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28          
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72          
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12          
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44          
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60          
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61          
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10          
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81          
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04          
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45          
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57          
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02          
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66          
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55          
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80          
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36          
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20          
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85          
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35          
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94          
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79          
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43          
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76          
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98          
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92          
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43          
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46          
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12          
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47          
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25          
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17          
ATOM    620  CD  ILE    69     -21.812 104.999  25.889  1.00 15.75          
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24          
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01          
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70          
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44          
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51          
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02          
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56          
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10          
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31          
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99          
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34          
ATOM    650  N   HSD    71     -29.119 103.103  29.061  1.00 19.25          
ATOM    651  CA  HSD    71     -30.548 102.931  29.018  1.00 19.59          
ATOM    653  CB  HSD    71     -31.131 103.739  27.866  1.00 19.71          
ATOM    656  CG  HSD    71     -32.594 103.546  27.715  1.00 19.32          
ATOM    657  ND1 HSD    71     -33.145 102.695  26.782  1.00 19.54          
ATOM    659  CE1 HSD    71     -34.464 102.709  26.910  1.00 20.43          
ATOM    661  NE2 HSD    71     -34.779 103.515  27.909  1.00 19.47          
ATOM    663  CD2 HSD    71     -33.628 104.049  28.430  1.00 20.71          
ATOM    665  C   HSD    71     -30.896 101.469  28.799  1.00 20.07          
ATOM    666  O   HSD    71     -30.428 100.917  27.828  1.00 18.82          
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27          
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29          
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59          
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09          
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24          
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83          
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15          
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16          
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79          
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44          
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97          
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85          
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76          
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22          
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54          
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82          
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77          
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27          
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12          
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04          
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85          
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85          
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91          
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24          
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89          
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93          
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07          
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63          
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95          
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11          
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98          
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45          
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14          
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54          
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30          
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44          
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82          
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94          
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35          
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79          
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58          
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61          
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66          
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80          
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27          
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54          
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70          
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97          
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55          
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24          
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67          
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68          
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82          
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73          
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59          
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06          
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62          
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95          
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41          
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62          
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50          
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60          
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76          
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79          
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47          
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02          
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93          
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52          
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56          
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15          
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39          
ATOM    804  CD  ILE    81     -24.524  99.793  24.350  1.00 11.87          
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92          
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42          
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24          
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63          
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36          
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79          
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81          
ATOM    823  CD  ILE    82     -23.912  98.475  14.628  1.00 16.96          
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37          
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01          
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00          
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53          
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80          
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01          
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25          
ATOM    842  CD  ILE    83     -20.076 104.162  22.048  1.00 18.56          
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42          
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12          
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77          
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80          
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15          
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26          
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91          
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70          
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67          
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33          
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13          
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26          
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58          
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18          
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55          
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31          
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00          
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95          
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72          
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93          
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70          
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87          
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05          
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92          
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95          
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41          
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86          
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29          
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91          
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21          
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92          
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77          
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24          
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80          
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65          
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88          
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80          
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50          
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64          
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43          
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91          
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72          
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43          
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48          
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01          
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39          
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93          
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39          
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94          
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60          
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11          
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10          
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30          
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57          
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84          
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57          
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11          
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08          
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15          
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23          
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94          
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78          
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25          
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40          
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58          
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95          
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47          
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34          
ATOM    975  N   HSD    94     -13.252 117.343  23.149  1.00 19.02          
ATOM    976  CA  HSD    94     -13.913 118.258  24.010  1.00 18.65          
ATOM    978  CB  HSD    94     -13.212 118.340  25.388  1.00 18.04          
ATOM    981  CG  HSD    94     -13.222 117.059  26.144  1.00 17.83          
ATOM    982  ND1 HSD    94     -14.362 116.316  26.320  1.00 19.55          
ATOM    984  CE1 HSD    94     -14.074 115.230  27.024  1.00 19.25          
ATOM    986  NE2 HSD    94     -12.801 115.280  27.377  1.00 19.12          
ATOM    988  CD2 HSD    94     -12.241 116.403  26.821  1.00 20.68          
ATOM    990  C   HSD    94     -13.972 119.647  23.426  1.00 18.42          
ATOM    991  O   HSD    94     -13.158 120.042  22.633  1.00 17.03          
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61          
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31          
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16          
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32          
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64          
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08          
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37          
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35          
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38          
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46          
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82          
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57          
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98          
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21          
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43          
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95          
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91          
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00          
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56          
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92          
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08          
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41          
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52          
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48          
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64          
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13          
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89          
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08          
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54          
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91          
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23          
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69          
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39          
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44          
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57          
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88          
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81          
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91          
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10          
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60          
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08          
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98          
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61          
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62          
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09          
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66          
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75          
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40          
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75          
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54          
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95          
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65          
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16          
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26          
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97          
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85          
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24          
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48          
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28          
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28          
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17          
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37          
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64          
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75          
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36          
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79          
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97          
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27          
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37          
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59          
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51          
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69          
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46          
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92          
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77          
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10          
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66          
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90          
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12          
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60          
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31          
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56          
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52          
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52          
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48          
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75          
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33          
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71          
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38          
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17          
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80          
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17          
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03          
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77          
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59          
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31          
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79          
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16          
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38          
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07          
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22          
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26          
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97          
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44          
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92          
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19          
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10          
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19          
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43          
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44          
ATOM   1205  N   HSD   108     -14.322 122.108  34.838  1.00 16.53          
ATOM   1206  CA  HSD   108     -13.307 121.377  34.111  1.00 15.88          
ATOM   1208  CB  HSD   108     -11.916 121.949  34.329  1.00 16.59          
ATOM   1211  CG  HSD   108     -11.718 123.383  33.917  1.00 16.50          
ATOM   1212  ND1 HSD   108     -10.588 124.083  34.293  1.00 15.51          
ATOM   1214  CE1 HSD   108     -10.637 125.301  33.769  1.00 16.01          
ATOM   1216  NE2 HSD   108     -11.757 125.417  33.086  1.00 15.37          
ATOM   1218  CD2 HSD   108     -12.459 124.234  33.166  1.00 16.00          
ATOM   1220  C   HSD   108     -13.235 119.921  34.646  1.00 15.19          
ATOM   1221  O   HSD   108     -13.155 118.995  33.914  1.00 14.28          
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65          
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05          
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64          
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76          
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84          
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11          
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64          
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98          
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86          
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30          
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93          
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70          
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32          
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73          
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93          
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74          
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83          
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21          
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98          
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31          
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55          
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15          
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93          
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07          
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16          
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43          
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85          
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99          
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71          
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39          
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61          
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84          
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47          
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19          
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12          
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34          
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02          
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19          
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41          
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00          
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33          
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93          
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45          
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41          
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14          
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13          
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45          
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46          
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05          
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54          
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42          
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64          
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36          
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12          
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47          
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74          
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02          
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25          
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27          
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02          
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76          
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73          
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80          
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09          
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44          
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03          
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49          
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56          
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05          
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45          
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58          
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05          
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04          
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61          
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33          
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93          
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29          
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83          
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48          
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68          
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44          
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86          
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68          
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23          
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82          
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90          
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49          
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43          
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50          
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80          
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07          
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76          
ATOM   1409  N   HSD   121     -18.020 102.936  31.379  1.00 18.02          
ATOM   1410  CA  HSD   121     -19.310 102.326  31.191  1.00 16.84          
ATOM   1412  CB  HSD   121     -20.401 103.380  30.986  1.00 16.90          
ATOM   1415  CG  HSD   121     -20.886 104.029  32.249  1.00 15.18          
ATOM   1416  ND1 HSD   121     -21.278 103.309  33.350  1.00 17.39          
ATOM   1418  CE1 HSD   121     -21.695 104.137  34.298  1.00 19.88          
ATOM   1420  NE2 HSD   121     -21.639 105.370  33.820  1.00 19.45          
ATOM   1422  CD2 HSD   121     -21.103 105.327  32.553  1.00 15.34          
ATOM   1424  C   HSD   121     -19.233 101.442  29.958  1.00 17.12          
ATOM   1425  O   HSD   121     -19.898 100.408  29.892  1.00 17.67          
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86          
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65          
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30          
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20          
ATOM   1435  CD  ILE   122     -17.690 103.930  25.081  1.00 12.70          
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97          
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69          
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26          
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27          
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81          
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77          
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13          
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58          
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44          
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28          
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74          
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97          
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26          
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36          
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97          
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12          
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76          
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50          
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01          
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81          
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10          
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88          
ATOM   1504  N   HSD   125     -19.703  97.442  30.336  1.00 16.02          
ATOM   1505  CA  HSD   125     -21.006  97.198  29.804  1.00 15.87          
ATOM   1507  CB  HSD   125     -21.182  97.819  28.406  1.00 16.42          
ATOM   1510  CG  HSD   125     -22.595  98.294  28.145  1.00 17.72          
ATOM   1511  ND1 HSD   125     -23.591  97.471  27.649  1.00 20.32          
ATOM   1513  CE1 HSD   125     -24.728  98.144  27.578  1.00 20.03          
ATOM   1515  NE2 HSD   125     -24.512  99.385  27.985  1.00 17.52          
ATOM   1517  CD2 HSD   125     -23.184  99.504  28.354  1.00 18.22          
ATOM   1519  C   HSD   125     -21.288  95.703  29.677  1.00 17.08          
ATOM   1520  O   HSD   125     -20.352  94.926  29.505  1.00 17.32          
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94          
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53          
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78          
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31          
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45          
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77          
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83          
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26          
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48          
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44          
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02          
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24          
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76          
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29          
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02          
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57          
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89          
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79          
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73          
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69          
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31          
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44          
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97          
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20          
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24          
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88          
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07          
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83          
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20          
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93          
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69          
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43          
ATOM   1590  CD  ILE   130     -19.975  95.634  16.659  1.00 15.03          
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90          
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42          
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47          
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18          
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55          
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89          
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09          
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65          
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32          
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93          
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98          
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51          
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40          
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32          
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19          
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29          
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14          
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83          
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70          
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23          
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76          
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21          
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77          
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70          
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80          
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10          
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58          
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83          
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19          
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29          
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58          
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25          
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79          
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04          
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93          
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81          
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63          
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59          
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05          
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99          
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77          
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44          
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39          
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97          
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20          
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24          
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75          
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76          
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53          
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52          
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69          
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82          
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09          
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59          
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31          
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84          
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64          
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76          
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52          
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92          
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51          
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46          
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96          
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99          
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32          
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55          
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29          
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38          
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86          
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34          
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07          
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75          
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27          
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69          
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11          
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10          
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70          
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37          
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50          
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66          
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03          
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30          
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94          
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30          
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72          
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83          
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53          
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08          
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29          
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43          
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09          
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00          
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98          
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78          
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20          
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90          
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21          
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76          
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27          
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28          
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65          
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90          
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55          
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77          
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98          
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16          
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86          
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51          
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07          
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98          
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13          
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71          
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29          
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48          
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21          
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90          
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56          
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21          
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52          
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68          
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98          
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31          
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93          
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16          
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57          
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31          
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77          
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91          
ATOM   1850  CD  ILE   150     -16.059  93.224  18.301  1.00 13.77          
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56          
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95          
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22          
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47          
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55          
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16          
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59          
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67          
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17          
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54          
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14          
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83          
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37          
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05          
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86          
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38          
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80          
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60          
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53          
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86          
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43          
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76          
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71          
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86          
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98          
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86          
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20          
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53          
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70          
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16          
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18          
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33          
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69          
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26          
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70          
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36          
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32          
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72          
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34          
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53          
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70          
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12          
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94          
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93          
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77          
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82          
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81          
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72          
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23          
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89          
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21          
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57          
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65          
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60          
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35          
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31          
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16          
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50          
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84          
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81          
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96          
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89          
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53          
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37          
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23          
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55          
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91          
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63          
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32          
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81          
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16          
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40          
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46          
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70          
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82          
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62          
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93          
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89          
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68          
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50          
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91          
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72          
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02          
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71          
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59          
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57          
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24          
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04          
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72          
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79          
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89          
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65          
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97          
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86          
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61          
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93          
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04          
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55          
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16          
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81          
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41          
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60          
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76          
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72          
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92          
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58          
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92          
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18          
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71          
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26          
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86          
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52          
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88          
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87          
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70          
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15          
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27          
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54          
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01          
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44          
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90          
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66          
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16          
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84          
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52          
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49          
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77          
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12          
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77          
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20          
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08          
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90          
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86          
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35          
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41          
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88          
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34          
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15          
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88          
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10          
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47          
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97          
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81          
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21          
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85          
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57          
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91          
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21          
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99          
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90          
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58          
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24          
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96          
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79          
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93          
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71          
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71          
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35          
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61          
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27          
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70          
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44          
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28          
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27          
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76          
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71          
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70          
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32          
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63          
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93          
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71          
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13          
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80          
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01          
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04          
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17          
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93          
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60          
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99          
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86          
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70          
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41          
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61          
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97          
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02          
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58          
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50          
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24          
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17          
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68          
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53          
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34          
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74          
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81          
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74          
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14          
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19          
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79          
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40          
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16          
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66          
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32          
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90          
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18          
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33          
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22          
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85          
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98          
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73          
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22          
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16          
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82          
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19          
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75          
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53          
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09          
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60          
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83          
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62          
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44          
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38          
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77          
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09          
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29          
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27          
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69          
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43          
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30          
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18          
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34          
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19          
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56          
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75          
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21          
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47          
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16          
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42          
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21          
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28          
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20          
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76          
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98          
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73          
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89          
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72          
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67          
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27          
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47          
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23          
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39          
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13          
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68          
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98          
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33          
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86          
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26          
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79          
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07          
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86          
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26          
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66          
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77          
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44          
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65          
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68          
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00          
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10          
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11          
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67          
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76          
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05          
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41          
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18          
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20          
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16          
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74          
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46          
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26          
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76          
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20          
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62          
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41          
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41          
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31          
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82          
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38          
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20          
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67          
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51          
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34          
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42          
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47          
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04          
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04          
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78          
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16          
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89          
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82          
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98          
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48          
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50          
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91          
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16          
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21          
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47          
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68          
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01          
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76          
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80          
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11          
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74          
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22          
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60          
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67          
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15          
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69          
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86          
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80          
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58          
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77          
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58          
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63          
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84          
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45          
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39          
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65          
ATOM   2517  CD  ILE   196      -2.544 105.621  14.499  1.00 11.63          
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20          
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62          
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49          
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08          
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10          
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64          
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41          
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85          
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13          
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74          
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91          
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76          
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33          
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30          
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46          
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62          
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95          
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74          
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57          
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03          
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76          
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07          
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01          
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39          
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75          
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59          
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47          
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04          
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16          
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47          
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53          
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24          
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46          
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81          
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82          
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05          
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65          
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15          
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60          
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11          
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17          
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30          
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93          
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80          
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48          
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59          
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35          
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94          
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00          
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89          
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89          
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20          
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33          
ATOM   2629  N   HSD   204      -1.273  98.900  13.907  1.00 17.02          
ATOM   2630  CA  HSD   204      -0.728  99.131  15.234  1.00 17.25          
ATOM   2632  CB  HSD   204      -0.203 100.553  15.369  1.00 16.74          
ATOM   2635  CG  HSD   204       1.093 100.729  14.676  1.00 18.87          
ATOM   2636  ND1 HSD   204       2.157  99.882  14.902  1.00 22.98          
ATOM   2638  CE1 HSD   204       3.153 100.212  14.106  1.00 21.31          
ATOM   2640  NE2 HSD   204       2.756 101.220  13.350  1.00 20.85          
ATOM   2642  CD2 HSD   204       1.477 101.566  13.687  1.00 18.98          
ATOM   2644  C   HSD   204      -1.654  98.782  16.358  1.00 16.73          
ATOM   2645  O   HSD   204      -1.243  98.784  17.497  1.00 18.93          
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80          
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30          
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34          
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11          
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87          
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55          
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16          
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78          
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82          
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60          
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99          
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65          
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78          
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16          
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90          
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55          
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59          
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65          
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12          
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49          
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66          
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66          
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97          
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76          
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17          
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84          
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33          
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92          
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35          
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64          
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11          
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47          
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65          
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36          
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46          
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08          
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57          
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71          
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35          
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35          
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68          
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03          
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64          
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09          
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09          
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13          
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98          
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77          
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73          
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06          
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19          
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82          
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04          
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13          
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76          
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33          
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25          
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79          
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02          
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18          
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14          
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50          
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21          
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38          
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43          
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19          
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15          
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33          
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74          
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74          
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29          
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39          
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99          
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86          
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03          
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52          
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48          
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50          
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73          
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86          
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44          
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79          
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12          
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83          
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01          
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22          
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13          
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03          
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43          
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69          
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96          
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30          
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19          
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41          
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28          
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33          
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93          
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99          
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20          
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40          
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43          
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00          
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45          
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20          
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78          
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03          
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56          
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48          
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49          
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58          
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57          
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06          
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74          
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10          
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51          
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78          
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27          
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78          
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86          
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39          
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62          
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50          
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34          
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93          
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23          
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57          
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33          
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15          
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60          
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61          
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05          
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43          
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56          
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18          
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51          
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92          
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49          
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66          
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99          
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12          
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21          
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43          
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78          
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99          
ATOM   2940  CD  ILE   223     -16.388  93.920  13.040  1.00 15.84          
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85          
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64          
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90          
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31          
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78          
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62          
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91          
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13          
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23          
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23          
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86          
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23          
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65          
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44          
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85          
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04          
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54          
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34          
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15          
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65          
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61          
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11          
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61          
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54          
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02          
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57          
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66          
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10          
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72          
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33          
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82          
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84          
ATOM   3015  CD  ILE   227     -19.874  91.755  18.995  1.00  9.69          
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42          
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80          
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94          
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71          
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02          
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51          
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09          
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60          
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04          
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66          
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33          
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00          
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70          
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93          
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97          
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95          
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31          
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28          
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01          
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08          
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72          
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55          
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96          
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31          
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96          
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33          
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36          
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12          
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66          
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70          
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46          
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14          
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44          
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71          
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46          
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91          
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29          
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71          
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88          
END
