
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  236 ( 1827),  selected  236 , name 3bxo_A
# Molecule2: number of CA atoms  218 ( 1715),  selected  218 , name T0485.pdb
# PARAMETERS: 3bxo_A.T0485.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y     2_A      M       1           -
LGA    E     3_A      S       2           -
LGA    V     4_A      E       3           -
LGA    -       -      N       4           -
LGA    -       -      K       5           -
LGA    -       -      K       6           -
LGA    -       -      K       7           -
LGA    -       -      F       8           -
LGA    -       -      D       9           -
LGA    -       -      K      10           -
LGA    D     5_A      K      11           #
LGA    H     6_A      G      12          4.734
LGA    A     7_A      A      13          3.084
LGA    D     8_A      K      14          3.696
LGA    V     9_A      N      15          3.691
LGA    Y    10_A      M      16          2.926
LGA    D    11_A      D      17          2.764
LGA    L    12_A      E      18          2.962
LGA    F    13_A      I      19          2.837
LGA    Y    14_A      S      20          4.193
LGA    L    15_A      K      21          3.907
LGA    G    16_A      T      22          2.994
LGA    R    17_A      L      23          2.116
LGA    G    18_A      F      24          4.738
LGA    K    19_A      A      25          4.415
LGA    D    20_A      P      26          1.656
LGA    -       -      I      27           -
LGA    Y    21_A      Y      28          1.062
LGA    A    22_A      P      29          1.359
LGA    A    23_A      I      30          1.619
LGA    E    24_A      I      31          1.556
LGA    A    25_A      A      32          1.527
LGA    S    26_A      E      33          1.657
LGA    D    27_A      N      34          1.115
LGA    I    28_A      I      35          1.648
LGA    A    29_A      I      36          2.281
LGA    D    30_A      N      37          2.004
LGA    L    31_A      R      38          2.141
LGA    V    32_A      F      39          3.094
LGA    R    33_A      G      40          1.951
LGA    S    34_A      -       -           -
LGA    R    35_A      -       -           -
LGA    T    36_A      -       -           -
LGA    P    37_A      I      41          4.575
LGA    E    38_A      T      42           #
LGA    A    39_A      A      43          5.133
LGA    S    40_A      G      44          2.011
LGA    S    41_A      N      45          1.521
LGA    L    42_A      C      46          0.576
LGA    L    43_A      I      47          0.325
LGA    D    44_A      D      48          0.221
LGA    V    45_A      I      49          0.343
LGA    A    46_A      G      50          0.298
LGA    C    47_A      S      51          0.418
LGA    G    48_A      G      52          0.424
LGA    T    49_A      P      53          0.653
LGA    G    50_A      G      54          0.480
LGA    T    51_A      A      55          0.635
LGA    H    52_A      L      56          0.748
LGA    L    53_A      S      57          0.539
LGA    E    54_A      I      58          1.014
LGA    H    55_A      A      59          2.058
LGA    F    56_A      L      60          1.788
LGA    T    57_A      A      61          2.325
LGA    K    58_A      K      62          3.310
LGA    E    59_A      Q      63          3.827
LGA    F    60_A      S      64          4.155
LGA    -       -      D      65           -
LGA    G    61_A      F      66          2.564
LGA    D    62_A      S      67          1.039
LGA    T    63_A      I      68          1.066
LGA    A    64_A      R      69          0.430
LGA    G    65_A      A      70          0.993
LGA    L    66_A      L      71          0.601
LGA    E    67_A      D      72          0.207
LGA    L    68_A      F      73          0.721
LGA    S    69_A      S      74          0.509
LGA    E    70_A      K      75          0.518
LGA    D    71_A      H      76          0.414
LGA    M    72_A      M      77          0.365
LGA    L    73_A      N      78          0.361
LGA    T    74_A      E      79          0.352
LGA    H    75_A      I      80          0.629
LGA    A    76_A      A      81          0.705
LGA    R    77_A      L      82          0.626
LGA    K    78_A      K      83          0.727
LGA    R    79_A      N      84          1.257
LGA    L    80_A      I      85          1.557
LGA    P    81_A      A      86          3.705
LGA    -       -      D      87           -
LGA    -       -      A      88           -
LGA    -       -      D      89           -
LGA    -       -      L      90           -
LGA    D    82_A      N      91          1.952
LGA    -       -      D      92           -
LGA    -       -      R      93           -
LGA    A    83_A      I      94          2.571
LGA    T    84_A      Q      95          1.253
LGA    L    85_A      I      96          1.518
LGA    H    86_A      V      97          1.149
LGA    Q    87_A      Q      98          1.159
LGA    G    88_A      G      99          1.225
LGA    D    89_A      D     100          1.273
LGA    M    90_A      V     101          0.759
LGA    R    91_A      H     102          1.652
LGA    D    92_A      N     103          2.101
LGA    F    93_A      I     104          1.603
LGA    R    94_A      P     105          2.975
LGA    L    95_A      I     106          1.125
LGA    G    96_A      E     107          2.095
LGA    R    97_A      D     108          5.348
LGA    -       -      N     109           -
LGA    K    98_A      Y     110          0.662
LGA    F    99_A      A     111          0.999
LGA    S   100_A      D     112          0.308
LGA    A   101_A      L     113          0.616
LGA    V   102_A      I     114          0.857
LGA    V   103_A      V     115          1.251
LGA    S   104_A      S     116          1.152
LGA    M   105_A      R     117          1.007
LGA    F   106_A      G     118          2.284
LGA    S   107_A      -       -           -
LGA    S   108_A      S     119          0.842
LGA    V   109_A      V     120          1.013
LGA    G   110_A      F     121          0.944
LGA    Y   111_A      F     122          0.547
LGA    L   112_A      W     123          1.730
LGA    K   113_A      E     124          3.280
LGA    T   114_A      -       -           -
LGA    T   115_A      -       -           -
LGA    E   116_A      -       -           -
LGA    E   117_A      D     125          1.210
LGA    L   118_A      V     126          1.024
LGA    G   119_A      T     127          1.429
LGA    A   120_A      T     128          1.130
LGA    A   121_A      A     129          0.818
LGA    V   122_A      F     130          1.068
LGA    A   123_A      R     131          1.186
LGA    S   124_A      E     132          0.812
LGA    F   125_A      I     133          0.841
LGA    A   126_A      Y     134          0.801
LGA    E   127_A      R     135          0.778
LGA    H   128_A      I     136          0.866
LGA    L   129_A      L     137          0.757
LGA    E   130_A      K     138          0.901
LGA    P   131_A      S     139          1.086
LGA    G   132_A      G     140          0.339
LGA    G   133_A      G     141          0.339
LGA    V   134_A      K     142          0.580
LGA    V   135_A      T     143          1.307
LGA    V   136_A      Y     144          1.287
LGA    V   137_A      I     145          1.074
LGA    E   138_A      G     146          0.935
LGA    P   139_A      -       -           -
LGA    W   140_A      G     147           #
LGA    W   141_A      G     148           -
LGA    F   142_A      F     149           -
LGA    P   143_A      G     150           -
LGA    E   144_A      N     151           -
LGA    T   145_A      K     152           -
LGA    F   146_A      E     153           -
LGA    A   147_A      L     154           -
LGA    D   148_A      R     155           -
LGA    G   149_A      D     156           -
LGA    W   150_A      S     157           -
LGA    V   151_A      I     158           -
LGA    -       -      S     159           -
LGA    -       -      A     160           -
LGA    -       -      E     161           -
LGA    S   152_A      M     162          4.496
LGA    A   153_A      I     163          3.762
LGA    D   154_A      R     164          3.573
LGA    V   155_A      K     165           #
LGA    V   156_A      -       -           -
LGA    R   157_A      -       -           -
LGA    R   158_A      -       -           -
LGA    D   159_A      -       -           -
LGA    G   160_A      -       -           -
LGA    R   161_A      -       -           -
LGA    T   162_A      -       -           -
LGA    V   163_A      -       -           -
LGA    A   164_A      -       -           -
LGA    R   165_A      -       -           -
LGA    V   166_A      N     166          2.034
LGA    S   167_A      P     167          3.560
LGA    H   168_A      D     168          1.554
LGA    S   169_A      W     169          4.975
LGA    V   170_A      K     170           -
LGA    R   171_A      E     171           -
LGA    E   172_A      -       -           -
LGA    G   173_A      -       -           -
LGA    N   174_A      -       -           -
LGA    A   175_A      -       -           -
LGA    T   176_A      F     172          4.894
LGA    R   177_A      -       -           -
LGA    M   178_A      -       -           -
LGA    E   179_A      -       -           -
LGA    V   180_A      -       -           -
LGA    H   181_A      -       -           -
LGA    F   182_A      -       -           -
LGA    T   183_A      -       -           -
LGA    V   184_A      -       -           -
LGA    A   185_A      -       -           -
LGA    D   186_A      -       -           -
LGA    P   187_A      -       -           -
LGA    G   188_A      -       -           -
LGA    K   189_A      -       -           -
LGA    G   190_A      -       -           -
LGA    V   191_A      -       -           -
LGA    R   192_A      -       -           -
LGA    H   193_A      -       -           -
LGA    F   194_A      -       -           -
LGA    S   195_A      -       -           -
LGA    D   196_A      -       -           -
LGA    V   197_A      -       -           -
LGA    H   198_A      -       -           -
LGA    L   199_A      -       -           -
LGA    I   200_A      N     173           #
LGA    T   201_A      R     174           -
LGA    L   202_A      K     175          5.730
LGA    F   203_A      N     176           -
LGA    -       -      I     177           -
LGA    -       -      S     178           -
LGA    -       -      Q     179           -
LGA    H   204_A      E     180          3.121
LGA    -       -      N     181           -
LGA    Q   205_A      V     182          1.823
LGA    A   206_A      E     183          2.216
LGA    E   207_A      R     184          2.123
LGA    Y   208_A      F     185          0.274
LGA    E   209_A      Q     186          1.461
LGA    A   210_A      N     187          2.560
LGA    A   211_A      V     188          2.274
LGA    F   212_A      L     189          2.493
LGA    T   213_A      D     190          3.314
LGA    A   214_A      E     191          3.906
LGA    A   215_A      I     192          3.991
LGA    G   216_A      G     193          4.546
LGA    L   217_A      V     194          3.140
LGA    -       -      S     195           -
LGA    R   218_A      S     196          1.644
LGA    V   219_A      Y     197          1.615
LGA    E   220_A      E     198          1.164
LGA    Y   221_A      I     199          1.990
LGA    L   222_A      I     200          1.782
LGA    E   223_A      L     201          2.051
LGA    G   224_A      E     202          1.919
LGA    G   225_A      D     203           #
LGA    P   226_A      E     204          3.671
LGA    S   227_A      -       -           -
LGA    G   228_A      -       -           -
LGA    R   229_A      G     205          3.828
LGA    G   230_A      F     206          2.089
LGA    L   231_A      W     207          1.437
LGA    F   232_A      I     208          1.714
LGA    V   233_A      I     209          0.961
LGA    G   234_A      I     210          0.971
LGA    V   235_A      S     211          0.486
LGA    P   236_A      K     212          1.866
LGA    A   237_A      T     213          4.420
LGA    -       -      D     214           -
LGA    -       -      Q     215           -
LGA    -       -      E     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  236  218    5.0    165    2.26    16.97     58.463     6.992

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.952603 * X  +   0.298676 * Y  +   0.057798 * Z  +  -4.915568
  Y_new =  -0.294056 * X  +   0.855321 * Y  +   0.426565 * Z  +   1.494084
  Z_new =   0.077968 * X  +  -0.423343 * Y  +   0.902608 * Z  +   0.328697 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.438559    2.703034  [ DEG:   -25.1276    154.8724 ]
  Theta =  -0.078048   -3.063545  [ DEG:    -4.4718   -175.5282 ]
  Phi   =  -0.299407    2.842185  [ DEG:   -17.1548    162.8452 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bxo_A                                        
REMARK     2: T0485.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bxo_A.T0485.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  236  218   5.0  165   2.26   16.97  58.463
REMARK  ---------------------------------------------------------- 
MOLECULE 3bxo_A
HEADER    TRANSFERASE                             14-JAN-08   3BXO              
TITLE     CRYSTAL STRUCTURE OF STREPTOMYCES VENEZUELAE DESVI                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: N,N-DIMETHYLTRANSFERASE;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES VENEZUELAE;                        
SOURCE   3 STRAIN: ATCC NO. 15,439;                                             
SOURCE   4 GENE: DESVI;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: ROSETTA (DE3);                             
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28B(+)                                 
KEYWDS    METHYLTRANSFERASE, DESOSAMINE, SUGAR, CARBOHYDRATE,                   
KEYWDS   2 ANTIBIOTIC, SAM, ADOMET                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.M.HOLDEN,E.S.BURGIE                                                 
REVDAT   2   08-APR-08 3BXO    1       JRNL                                     
REVDAT   1   25-MAR-08 3BXO    0                                                
JRNL        AUTH   E.S.BURGIE,H.M.HOLDEN                                        
JRNL        TITL   THREE-DIMENSIONAL STRUCTURE OF DESVI FROM                    
JRNL        TITL 2 STREPTOMYCES VENEZUELAE: A SUGAR                             
JRNL        TITL 3 N,N-DIMETHYLTRANSFERASE REQUIRED FOR                         
JRNL        TITL 4 DTDP-DESOSAMINE BIOSYNTHESIS.                                
JRNL        REF    BIOCHEMISTRY                  V.  47  3982 2008              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  3BXO A    1   237  UNP    Q9ZGH6   Q9ZGH6_9ACTO     1    237             
DBREF  3BXO B    1   237  UNP    Q9ZGH6   Q9ZGH6_9ACTO     1    237             
SEQRES   1 A  239  GLY HIS MET TYR GLU VAL ASP HIS ALA ASP VAL TYR ASP          
SEQRES   2 A  239  LEU PHE TYR LEU GLY ARG GLY LYS ASP TYR ALA ALA GLU          
SEQRES   3 A  239  ALA SER ASP ILE ALA ASP LEU VAL ARG SER ARG THR PRO          
SEQRES   4 A  239  GLU ALA SER SER LEU LEU ASP VAL ALA CYS GLY THR GLY          
SEQRES   5 A  239  THR HIS LEU GLU HIS PHE THR LYS GLU PHE GLY ASP THR          
SEQRES   6 A  239  ALA GLY LEU GLU LEU SER GLU ASP MET LEU THR HIS ALA          
SEQRES   7 A  239  ARG LYS ARG LEU PRO ASP ALA THR LEU HIS GLN GLY ASP          
SEQRES   8 A  239  MET ARG ASP PHE ARG LEU GLY ARG LYS PHE SER ALA VAL          
SEQRES   9 A  239  VAL SER MET PHE SER SER VAL GLY TYR LEU LYS THR THR          
SEQRES  10 A  239  GLU GLU LEU GLY ALA ALA VAL ALA SER PHE ALA GLU HIS          
SEQRES  11 A  239  LEU GLU PRO GLY GLY VAL VAL VAL VAL GLU PRO TRP TRP          
SEQRES  12 A  239  PHE PRO GLU THR PHE ALA ASP GLY TRP VAL SER ALA ASP          
SEQRES  13 A  239  VAL VAL ARG ARG ASP GLY ARG THR VAL ALA ARG VAL SER          
SEQRES  14 A  239  HIS SER VAL ARG GLU GLY ASN ALA THR ARG MET GLU VAL          
SEQRES  15 A  239  HIS PHE THR VAL ALA ASP PRO GLY LYS GLY VAL ARG HIS          
SEQRES  16 A  239  PHE SER ASP VAL HIS LEU ILE THR LEU PHE HIS GLN ALA          
SEQRES  17 A  239  GLU TYR GLU ALA ALA PHE THR ALA ALA GLY LEU ARG VAL          
SEQRES  18 A  239  GLU TYR LEU GLU GLY GLY PRO SER GLY ARG GLY LEU PHE          
SEQRES  19 A  239  VAL GLY VAL PRO ALA                                          
SEQRES   1 B  239  GLY HIS MET TYR GLU VAL ASP HIS ALA ASP VAL TYR ASP          
SEQRES   2 B  239  LEU PHE TYR LEU GLY ARG GLY LYS ASP TYR ALA ALA GLU          
SEQRES   3 B  239  ALA SER ASP ILE ALA ASP LEU VAL ARG SER ARG THR PRO          
SEQRES   4 B  239  GLU ALA SER SER LEU LEU ASP VAL ALA CYS GLY THR GLY          
SEQRES   5 B  239  THR HIS LEU GLU HIS PHE THR LYS GLU PHE GLY ASP THR          
SEQRES   6 B  239  ALA GLY LEU GLU LEU SER GLU ASP MET LEU THR HIS ALA          
SEQRES   7 B  239  ARG LYS ARG LEU PRO ASP ALA THR LEU HIS GLN GLY ASP          
SEQRES   8 B  239  MET ARG ASP PHE ARG LEU GLY ARG LYS PHE SER ALA VAL          
SEQRES   9 B  239  VAL SER MET PHE SER SER VAL GLY TYR LEU LYS THR THR          
SEQRES  10 B  239  GLU GLU LEU GLY ALA ALA VAL ALA SER PHE ALA GLU HIS          
SEQRES  11 B  239  LEU GLU PRO GLY GLY VAL VAL VAL VAL GLU PRO TRP TRP          
SEQRES  12 B  239  PHE PRO GLU THR PHE ALA ASP GLY TRP VAL SER ALA ASP          
SEQRES  13 B  239  VAL VAL ARG ARG ASP GLY ARG THR VAL ALA ARG VAL SER          
SEQRES  14 B  239  HIS SER VAL ARG GLU GLY ASN ALA THR ARG MET GLU VAL          
SEQRES  15 B  239  HIS PHE THR VAL ALA ASP PRO GLY LYS GLY VAL ARG HIS          
SEQRES  16 B  239  PHE SER ASP VAL HIS LEU ILE THR LEU PHE HIS GLN ALA          
SEQRES  17 B  239  GLU TYR GLU ALA ALA PHE THR ALA ALA GLY LEU ARG VAL          
SEQRES  18 B  239  GLU TYR LEU GLU GLY GLY PRO SER GLY ARG GLY LEU PHE          
SEQRES  19 B  239  VAL GLY VAL PRO ALA                                          
HET    SAM  A 238      27                                                       
HET    SAM  B 238      27                                                       
HET    UPP  A 239      31                                                       
HET    UPP  B 239      31                                                       
HET    EDO  B 240       4                                                       
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
HETNAM     UPP PHENYL-URIDINE-5'-DIPHOSPHATE                                    
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   3  SAM    2(C15 H22 N6 O5 S)                                           
FORMUL   5  UPP    2(C15 H18 N2 O12 P2)                                         
FORMUL   7  EDO    C2 H6 O2                                                     
FORMUL   8  HOH   *544(H2 O)                                                    
CRYST1   46.170   56.096  116.482  90.00  92.50  90.00 P 1 21 1      4          
ATOM      1  N   TYR A   2      -4.695   7.091  44.698  1.00 56.57           N  
ATOM      2  CA  TYR A   2      -4.959   8.084  43.661  1.00 48.80           C  
ATOM      3  C   TYR A   2      -4.575   7.602  42.280  1.00 99.75           C  
ATOM      4  O   TYR A   2      -3.396   7.390  41.993  1.00 48.45           O  
ATOM      5  CB  TYR A   2      -4.202   9.383  43.895  1.00 99.75           C  
ATOM      6  CG  TYR A   2      -4.710  10.517  43.032  1.00 63.63           C  
ATOM      7  CD1 TYR A   2      -5.983  10.469  42.450  1.00 99.75           C  
ATOM      8  CD2 TYR A   2      -3.918  11.611  42.756  1.00 26.91           C  
ATOM      9  CE1 TYR A   2      -6.441  11.511  41.671  1.00 99.75           C  
ATOM     10  CE2 TYR A   2      -4.377  12.643  41.979  1.00 80.77           C  
ATOM     11  CZ  TYR A   2      -5.626  12.588  41.422  1.00 43.73           C  
ATOM     12  OH  TYR A   2      -6.026  13.665  40.668  1.00 85.33           O  
ATOM     13  N   GLU A   3      -5.588   7.457  41.434  1.00 24.46           N  
ATOM     14  CA  GLU A   3      -5.371   6.978  40.077  1.00 99.75           C  
ATOM     15  C   GLU A   3      -5.238   8.007  38.972  1.00 60.82           C  
ATOM     16  O   GLU A   3      -5.764   9.110  39.055  1.00 37.15           O  
ATOM     17  CB  GLU A   3      -6.427   5.940  39.732  1.00 19.32           C  
ATOM     18  CG  GLU A   3      -6.491   4.828  40.766  1.00 99.75           C  
ATOM     19  CD  GLU A   3      -7.422   5.182  41.914  1.00 99.75           C  
ATOM     20  OE1 GLU A   3      -8.490   5.783  41.639  1.00 99.75           O  
ATOM     21  OE2 GLU A   3      -7.068   4.866  43.078  1.00 99.75           O  
ATOM     22  N   VAL A   4      -4.515   7.621  37.930  1.00 22.60           N  
ATOM     23  CA  VAL A   4      -4.265   8.479  36.780  1.00 26.95           C  
ATOM     24  C   VAL A   4      -4.268   7.588  35.529  1.00 20.70           C  
ATOM     25  O   VAL A   4      -3.833   6.437  35.608  1.00 20.95           O  
ATOM     26  CB  VAL A   4      -2.897   9.114  37.018  1.00 22.39           C  
ATOM     27  CG1 VAL A   4      -1.995   9.016  35.793  1.00 24.21           C  
ATOM     28  CG2 VAL A   4      -3.023  10.477  37.692  1.00 12.84           C  
ATOM     29  N   ASP A   5      -4.756   8.105  34.399  1.00 16.65           N  
ATOM     30  CA  ASP A   5      -4.840   7.401  33.118  1.00 12.40           C  
ATOM     31  C   ASP A   5      -3.486   7.509  32.389  1.00  4.66           C  
ATOM     32  O   ASP A   5      -3.049   8.603  31.967  1.00 18.61           O  
ATOM     33  CB  ASP A   5      -5.985   8.021  32.309  1.00 18.55           C  
ATOM     34  CG  ASP A   5      -6.159   7.417  30.912  1.00 15.72           C  
ATOM     35  OD1 ASP A   5      -5.231   7.503  30.097  1.00 18.68           O  
ATOM     36  OD2 ASP A   5      -7.256   6.929  30.577  1.00 57.84           O  
ATOM     37  N   HIS A   6      -2.768   6.395  32.250  1.00  7.12           N  
ATOM     38  CA  HIS A   6      -1.442   6.516  31.587  1.00 15.39           C  
ATOM     39  C   HIS A   6      -1.295   7.241  30.248  1.00 14.28           C  
ATOM     40  O   HIS A   6      -0.523   8.198  30.120  1.00 13.06           O  
ATOM     41  CB  HIS A   6      -0.751   5.177  31.563  1.00 12.64           C  
ATOM     42  CG  HIS A   6      -0.660   4.567  32.919  1.00 14.62           C  
ATOM     43  ND1 HIS A   6      -0.019   3.373  33.159  1.00  6.20           N  
ATOM     44  CD2 HIS A   6      -1.116   5.006  34.113  1.00  3.04           C  
ATOM     45  CE1 HIS A   6      -0.093   3.092  34.448  1.00 44.84           C  
ATOM     46  NE2 HIS A   6      -0.748   4.070  35.050  1.00 12.60           N  
ATOM     47  N   ALA A   7      -2.053   6.777  29.255  1.00 18.23           N  
ATOM     48  CA  ALA A   7      -2.028   7.383  27.929  1.00 56.12           C  
ATOM     49  C   ALA A   7      -2.316   8.884  28.021  1.00 15.94           C  
ATOM     50  O   ALA A   7      -1.697   9.688  27.331  1.00 14.22           O  
ATOM     51  CB  ALA A   7      -3.035   6.687  27.008  1.00 20.69           C  
ATOM     52  N   ASP A   8      -3.259   9.275  28.880  1.00 19.03           N  
ATOM     53  CA  ASP A   8      -3.614  10.682  29.055  1.00 20.99           C  
ATOM     54  C   ASP A   8      -2.392  11.410  29.608  1.00 10.14           C  
ATOM     55  O   ASP A   8      -2.119  12.567  29.235  1.00 11.26           O  
ATOM     56  CB  ASP A   8      -4.797  10.835  30.019  1.00 13.94           C  
ATOM     57  CG  ASP A   8      -6.156  10.578  29.373  1.00  8.55           C  
ATOM     58  OD1 ASP A   8      -6.284  10.399  28.135  1.00 11.91           O  
ATOM     59  OD2 ASP A   8      -7.127  10.552  30.163  1.00 19.65           O  
ATOM     60  N   VAL A   9      -1.664  10.700  30.474  1.00  6.88           N  
ATOM     61  CA  VAL A   9      -0.429  11.217  31.068  1.00 15.98           C  
ATOM     62  C   VAL A   9       0.604  11.321  29.947  1.00 14.81           C  
ATOM     63  O   VAL A   9       1.234  12.365  29.799  1.00 10.84           O  
ATOM     64  CB  VAL A   9       0.133  10.388  32.234  1.00  6.37           C  
ATOM     65  CG1 VAL A   9       1.491  10.946  32.648  1.00  3.83           C  
ATOM     66  CG2 VAL A   9      -0.809  10.472  33.400  1.00 12.12           C  
ATOM     67  N   TYR A  10       0.771  10.287  29.128  1.00  5.34           N  
ATOM     68  CA  TYR A  10       1.720  10.433  28.029  1.00  1.00           C  
ATOM     69  C   TYR A  10       1.288  11.600  27.153  1.00 14.89           C  
ATOM     70  O   TYR A  10       2.127  12.348  26.661  1.00  6.96           O  
ATOM     71  CB  TYR A  10       1.640   9.252  27.067  1.00 12.83           C  
ATOM     72  CG  TYR A  10       1.880   7.943  27.765  1.00 18.01           C  
ATOM     73  CD1 TYR A  10       2.659   7.905  28.905  1.00  6.03           C  
ATOM     74  CD2 TYR A  10       1.316   6.752  27.310  1.00 18.99           C  
ATOM     75  CE1 TYR A  10       2.898   6.693  29.595  1.00 11.55           C  
ATOM     76  CE2 TYR A  10       1.533   5.563  27.979  1.00 99.75           C  
ATOM     77  CZ  TYR A  10       2.306   5.534  29.128  1.00  9.76           C  
ATOM     78  OH  TYR A  10       2.511   4.319  29.755  1.00 46.07           O  
ATOM     79  N   ASP A  11      -0.005  11.748  26.886  1.00 18.11           N  
ATOM     80  CA  ASP A  11      -0.420  12.841  26.011  1.00  8.42           C  
ATOM     81  C   ASP A  11      -0.075  14.214  26.565  1.00 13.88           C  
ATOM     82  O   ASP A  11       0.537  15.042  25.870  1.00 14.50           O  
ATOM     83  CB  ASP A  11      -1.917  12.776  25.583  1.00  8.35           C  
ATOM     84  CG  ASP A  11      -2.244  11.612  24.622  1.00 30.99           C  
ATOM     85  OD1 ASP A  11      -1.397  11.065  23.849  1.00 18.08           O  
ATOM     86  OD2 ASP A  11      -3.439  11.257  24.625  1.00 32.07           O  
ATOM     87  N   LEU A  12      -0.476  14.471  27.809  1.00  9.22           N  
ATOM     88  CA  LEU A  12      -0.182  15.775  28.394  1.00  2.92           C  
ATOM     89  C   LEU A  12       1.332  16.028  28.424  1.00 22.50           C  
ATOM     90  O   LEU A  12       1.816  17.127  28.121  1.00  9.73           O  
ATOM     91  CB  LEU A  12      -0.739  15.888  29.814  1.00 17.25           C  
ATOM     92  CG  LEU A  12      -0.744  17.311  30.362  1.00 18.76           C  
ATOM     93  CD1 LEU A  12      -2.139  17.604  30.852  1.00 31.33           C  
ATOM     94  CD2 LEU A  12       0.237  17.486  31.532  1.00 13.29           C  
ATOM     95  N   PHE A  13       2.098  14.998  28.769  1.00  9.28           N  
ATOM     96  CA  PHE A  13       3.555  15.193  28.793  1.00 14.39           C  
ATOM     97  C   PHE A  13       4.167  15.651  27.470  1.00 11.51           C  
ATOM     98  O   PHE A  13       4.869  16.676  27.411  1.00 11.18           O  
ATOM     99  CB  PHE A  13       4.353  13.967  29.256  1.00  7.72           C  
ATOM    100  CG  PHE A  13       5.852  14.187  29.184  1.00 50.50           C  
ATOM    101  CD1 PHE A  13       6.516  14.965  30.138  1.00 13.39           C  
ATOM    102  CD2 PHE A  13       6.613  13.642  28.151  1.00 37.74           C  
ATOM    103  CE1 PHE A  13       7.884  15.209  30.057  1.00  8.65           C  
ATOM    104  CE2 PHE A  13       7.999  13.858  28.070  1.00 15.33           C  
ATOM    105  CZ  PHE A  13       8.643  14.634  29.032  1.00  5.63           C  
ATOM    106  N   TYR A  14       3.941  14.884  26.405  1.00 10.75           N  
ATOM    107  CA  TYR A  14       4.549  15.286  25.141  1.00  5.88           C  
ATOM    108  C   TYR A  14       4.061  16.642  24.658  1.00  1.88           C  
ATOM    109  O   TYR A  14       4.794  17.344  23.948  1.00 16.31           O  
ATOM    110  CB  TYR A  14       4.486  14.198  24.063  1.00 20.15           C  
ATOM    111  CG  TYR A  14       5.418  13.046  24.373  1.00  9.86           C  
ATOM    112  CD1 TYR A  14       6.776  13.126  24.057  1.00 13.91           C  
ATOM    113  CD2 TYR A  14       4.954  11.893  25.000  1.00  5.72           C  
ATOM    114  CE1 TYR A  14       7.671  12.111  24.378  1.00 18.40           C  
ATOM    115  CE2 TYR A  14       5.850  10.863  25.322  1.00 12.56           C  
ATOM    116  CZ  TYR A  14       7.203  10.973  25.000  1.00  9.41           C  
ATOM    117  OH  TYR A  14       8.089   9.956  25.284  1.00 10.82           O  
ATOM    118  N   LEU A  15       2.830  17.018  25.033  1.00 10.42           N  
ATOM    119  CA  LEU A  15       2.311  18.328  24.601  1.00  8.34           C  
ATOM    120  C   LEU A  15       3.079  19.373  25.378  1.00 28.05           C  
ATOM    121  O   LEU A  15       3.622  20.328  24.820  1.00  7.39           O  
ATOM    122  CB  LEU A  15       0.852  18.496  24.995  1.00 18.71           C  
ATOM    123  CG  LEU A  15      -0.136  18.032  23.924  1.00 99.75           C  
ATOM    124  CD1 LEU A  15      -1.583  18.307  24.358  1.00 25.52           C  
ATOM    125  CD2 LEU A  15       0.195  18.671  22.574  1.00 51.57           C  
ATOM    126  N   GLY A  16       3.113  19.158  26.688  1.00 16.25           N  
ATOM    127  CA  GLY A  16       3.829  20.094  27.533  1.00  8.68           C  
ATOM    128  C   GLY A  16       5.312  20.076  27.175  1.00 21.33           C  
ATOM    129  O   GLY A  16       5.979  21.099  27.296  1.00 15.15           O  
ATOM    130  N   ARG A  17       5.837  18.928  26.750  1.00  6.35           N  
ATOM    131  CA  ARG A  17       7.249  18.862  26.413  1.00  9.79           C  
ATOM    132  C   ARG A  17       7.533  19.732  25.211  1.00 21.04           C  
ATOM    133  O   ARG A  17       8.669  20.159  24.943  1.00 18.88           O  
ATOM    134  CB  ARG A  17       7.717  17.438  26.078  1.00  5.32           C  
ATOM    135  CG  ARG A  17       9.219  17.266  26.327  1.00 12.38           C  
ATOM    136  CD  ARG A  17       9.756  16.033  25.609  1.00 16.64           C  
ATOM    137  NE  ARG A  17      10.850  15.402  26.339  1.00 23.74           N  
ATOM    138  CZ  ARG A  17      11.311  14.168  26.100  1.00 17.75           C  
ATOM    139  NH1 ARG A  17      10.795  13.412  25.131  1.00  5.38           N  
ATOM    140  NH2 ARG A  17      12.311  13.680  26.821  1.00 18.51           N  
ATOM    141  N   GLY A  18       6.482  19.978  24.452  1.00 16.39           N  
ATOM    142  CA  GLY A  18       6.748  20.790  23.292  1.00 18.85           C  
ATOM    143  C   GLY A  18       6.718  19.964  22.008  1.00 13.07           C  
ATOM    144  O   GLY A  18       6.952  20.537  20.927  1.00 18.18           O  
ATOM    145  N   LYS A  19       6.429  18.660  22.095  1.00 22.66           N  
ATOM    146  CA  LYS A  19       6.379  17.895  20.841  1.00  9.16           C  
ATOM    147  C   LYS A  19       5.174  18.531  20.099  1.00 24.20           C  
ATOM    148  O   LYS A  19       4.077  18.663  20.645  1.00 22.39           O  
ATOM    149  CB  LYS A  19       6.119  16.392  21.034  1.00 15.10           C  
ATOM    150  CG  LYS A  19       6.095  15.592  19.727  1.00  7.47           C  
ATOM    151  CD  LYS A  19       6.244  14.095  20.046  1.00 18.42           C  
ATOM    152  CE  LYS A  19       6.094  13.156  18.845  1.00  6.35           C  
ATOM    153  NZ  LYS A  19       7.339  13.164  17.980  1.00  8.69           N  
ATOM    154  N   ASP A  20       5.386  18.940  18.856  1.00 31.28           N  
ATOM    155  CA  ASP A  20       4.327  19.556  18.084  1.00 21.73           C  
ATOM    156  C   ASP A  20       3.823  18.656  16.964  1.00 12.70           C  
ATOM    157  O   ASP A  20       4.355  18.686  15.829  1.00 10.57           O  
ATOM    158  CB  ASP A  20       4.835  20.860  17.464  1.00 16.43           C  
ATOM    159  CG  ASP A  20       3.750  21.568  16.663  1.00 26.90           C  
ATOM    160  OD1 ASP A  20       2.758  20.896  16.317  1.00 70.21           O  
ATOM    161  OD2 ASP A  20       3.894  22.763  16.348  1.00 18.89           O  
ATOM    162  N   TYR A  21       2.794  17.881  17.295  1.00 19.62           N  
ATOM    163  CA  TYR A  21       2.161  16.940  16.370  1.00 11.32           C  
ATOM    164  C   TYR A  21       1.607  17.560  15.079  1.00 31.86           C  
ATOM    165  O   TYR A  21       1.651  16.974  13.991  1.00 19.94           O  
ATOM    166  CB  TYR A  21       1.060  16.169  17.096  1.00  2.98           C  
ATOM    167  CG  TYR A  21       1.590  15.036  17.961  1.00 17.51           C  
ATOM    168  CD1 TYR A  21       1.987  15.237  19.288  1.00 26.27           C  
ATOM    169  CD2 TYR A  21       1.695  13.749  17.456  1.00 45.61           C  
ATOM    170  CE1 TYR A  21       2.468  14.180  20.076  1.00 31.94           C  
ATOM    171  CE2 TYR A  21       2.172  12.701  18.223  1.00 27.00           C  
ATOM    172  CZ  TYR A  21       2.555  12.904  19.532  1.00 21.68           C  
ATOM    173  OH  TYR A  21       3.024  11.812  20.256  1.00 16.07           O  
ATOM    174  N   ALA A  22       1.079  18.768  15.217  1.00 17.16           N  
ATOM    175  CA  ALA A  22       0.481  19.530  14.136  1.00  8.82           C  
ATOM    176  C   ALA A  22       1.529  19.846  13.088  1.00 24.36           C  
ATOM    177  O   ALA A  22       1.364  19.521  11.904  1.00 18.76           O  
ATOM    178  CB  ALA A  22      -0.072  20.820  14.713  1.00 13.26           C  
ATOM    179  N   ALA A  23       2.600  20.483  13.558  1.00 17.30           N  
ATOM    180  CA  ALA A  23       3.719  20.860  12.695  1.00 23.22           C  
ATOM    181  C   ALA A  23       4.305  19.582  12.123  1.00 17.02           C  
ATOM    182  O   ALA A  23       4.636  19.523  10.946  1.00 11.94           O  
ATOM    183  CB  ALA A  23       4.767  21.603  13.456  1.00 15.04           C  
ATOM    184  N   GLU A  24       4.411  18.546  12.954  1.00 14.85           N  
ATOM    185  CA  GLU A  24       4.956  17.296  12.449  1.00  2.41           C  
ATOM    186  C   GLU A  24       4.055  16.762  11.338  1.00 15.45           C  
ATOM    187  O   GLU A  24       4.496  16.387  10.252  1.00 11.49           O  
ATOM    188  CB  GLU A  24       5.077  16.246  13.561  1.00 24.89           C  
ATOM    189  CG  GLU A  24       6.312  16.428  14.446  1.00 16.48           C  
ATOM    190  CD  GLU A  24       6.540  15.287  15.417  1.00 17.27           C  
ATOM    191  OE1 GLU A  24       5.965  14.197  15.165  1.00 15.12           O  
ATOM    192  OE2 GLU A  24       7.263  15.490  16.432  1.00 14.53           O  
ATOM    193  N   ALA A  25       2.767  16.724  11.624  1.00  6.79           N  
ATOM    194  CA  ALA A  25       1.826  16.200  10.661  1.00 36.03           C  
ATOM    195  C   ALA A  25       1.926  16.955   9.344  1.00 51.38           C  
ATOM    196  O   ALA A  25       1.932  16.371   8.264  1.00 14.39           O  
ATOM    197  CB  ALA A  25       0.417  16.243  11.248  1.00 19.80           C  
ATOM    198  N   SER A  26       2.019  18.272   9.436  1.00 17.86           N  
ATOM    199  CA  SER A  26       2.104  19.079   8.244  1.00 12.35           C  
ATOM    200  C   SER A  26       3.359  18.844   7.416  1.00 19.86           C  
ATOM    201  O   SER A  26       3.278  18.744   6.188  1.00 34.14           O  
ATOM    202  CB  SER A  26       1.983  20.554   8.603  1.00 17.54           C  
ATOM    203  OG  SER A  26       2.539  21.317   7.548  1.00 30.90           O  
ATOM    204  N   ASP A  27       4.516  18.771   8.068  1.00 29.40           N  
ATOM    205  CA  ASP A  27       5.771  18.539   7.344  1.00  5.24           C  
ATOM    206  C   ASP A  27       5.696  17.192   6.599  1.00 11.06           C  
ATOM    207  O   ASP A  27       6.120  17.048   5.460  1.00 18.62           O  
ATOM    208  CB  ASP A  27       6.914  18.517   8.361  1.00  9.56           C  
ATOM    209  CG  ASP A  27       7.284  19.905   8.855  1.00  9.66           C  
ATOM    210  OD1 ASP A  27       6.733  20.892   8.328  1.00 19.04           O  
ATOM    211  OD2 ASP A  27       8.107  20.010   9.787  1.00 18.16           O  
ATOM    212  N   ILE A  28       5.156  16.180   7.268  1.00  6.20           N  
ATOM    213  CA  ILE A  28       5.015  14.854   6.663  1.00  8.37           C  
ATOM    214  C   ILE A  28       4.081  14.943   5.437  1.00 31.58           C  
ATOM    215  O   ILE A  28       4.352  14.360   4.388  1.00 27.77           O  
ATOM    216  CB  ILE A  28       4.356  13.879   7.703  1.00 10.68           C  
ATOM    217  CG1 ILE A  28       5.281  13.624   8.902  1.00 19.49           C  
ATOM    218  CG2 ILE A  28       3.954  12.542   7.010  1.00 10.35           C  
ATOM    219  CD1 ILE A  28       6.694  13.150   8.545  1.00 14.22           C  
ATOM    220  N   ALA A  29       2.972  15.669   5.568  1.00 11.10           N  
ATOM    221  CA  ALA A  29       2.012  15.808   4.473  1.00  7.78           C  
ATOM    222  C   ALA A  29       2.753  16.418   3.284  1.00 14.75           C  
ATOM    223  O   ALA A  29       2.579  15.944   2.177  1.00 10.58           O  
ATOM    224  CB  ALA A  29       0.872  16.707   4.906  1.00 14.05           C  
ATOM    225  N   ASP A  30       3.579  17.442   3.498  1.00  6.83           N  
ATOM    226  CA  ASP A  30       4.325  18.031   2.371  1.00 13.26           C  
ATOM    227  C   ASP A  30       5.293  17.015   1.761  1.00  8.00           C  
ATOM    228  O   ASP A  30       5.508  16.923   0.523  1.00 20.16           O  
ATOM    229  CB  ASP A  30       5.220  19.193   2.827  1.00 22.83           C  
ATOM    230  CG  ASP A  30       4.449  20.371   3.416  1.00 24.68           C  
ATOM    231  OD1 ASP A  30       3.219  20.484   3.217  1.00 20.22           O  
ATOM    232  OD2 ASP A  30       5.099  21.215   4.080  1.00 22.47           O  
ATOM    233  N   LEU A  31       5.921  16.281   2.677  1.00 18.70           N  
ATOM    234  CA  LEU A  31       6.869  15.239   2.330  1.00 20.89           C  
ATOM    235  C   LEU A  31       6.084  14.287   1.435  1.00 23.75           C  
ATOM    236  O   LEU A  31       6.487  13.912   0.310  1.00  5.78           O  
ATOM    237  CB  LEU A  31       7.226  14.449   3.576  1.00  4.93           C  
ATOM    238  CG  LEU A  31       8.350  13.477   3.158  1.00 20.70           C  
ATOM    239  CD1 LEU A  31       9.566  14.121   2.488  1.00 29.31           C  
ATOM    240  CD2 LEU A  31       8.872  12.635   4.318  1.00 22.59           C  
ATOM    241  N   VAL A  32       4.927  13.892   1.954  1.00 11.69           N  
ATOM    242  CA  VAL A  32       4.093  12.991   1.180  1.00  4.17           C  
ATOM    243  C   VAL A  32       3.774  13.563  -0.209  1.00 11.38           C  
ATOM    244  O   VAL A  32       3.927  12.873  -1.228  1.00 13.08           O  
ATOM    245  CB  VAL A  32       2.803  12.672   1.938  1.00  8.03           C  
ATOM    246  CG1 VAL A  32       1.711  12.173   0.970  1.00  2.96           C  
ATOM    247  CG2 VAL A  32       3.155  11.632   2.989  1.00  6.56           C  
ATOM    248  N   ARG A  33       3.326  14.820  -0.254  0.50 32.09           N  
ATOM    250  CA  ARG A  33       2.977  15.442  -1.537  0.50  1.00           C  
ATOM    252  C   ARG A  33       4.159  15.541  -2.490  0.50  4.69           C  
ATOM    254  O   ARG A  33       4.003  15.399  -3.708  0.50 17.40           O  
ATOM    256  CB  ARG A  33       2.063  16.658  -1.407  0.50  2.97           C  
ATOM    258  CG  ARG A  33       0.669  16.339  -0.827  0.50 14.37           C  
ATOM    260  CD  ARG A  33      -0.327  17.505  -0.849  0.50  7.79           C  
ATOM    262  NE  ARG A  33      -0.953  17.704   0.461  0.50 24.15           N  
ATOM    264  CZ  ARG A  33      -0.428  18.432   1.444  0.50  1.00           C  
ATOM    266  NH1 ARG A  33       0.756  19.042   1.296  0.50 11.46           N  
ATOM    268  NH2 ARG A  33      -1.077  18.539   2.591  0.50 44.08           N  
ATOM    270  N   SER A  34       5.346  15.730  -1.924  1.00 27.16           N  
ATOM    271  CA  SER A  34       6.577  15.806  -2.705  1.00 29.66           C  
ATOM    272  C   SER A  34       6.868  14.566  -3.557  1.00 40.43           C  
ATOM    273  O   SER A  34       7.602  14.681  -4.529  1.00 18.24           O  
ATOM    274  CB  SER A  34       7.776  16.108  -1.800  1.00 13.06           C  
ATOM    275  OG  SER A  34       8.283  14.923  -1.211  1.00 18.63           O  
ATOM    276  N   ARG A  35       6.321  13.401  -3.205  1.00 14.34           N  
ATOM    277  CA  ARG A  35       6.553  12.154  -3.942  1.00 29.40           C  
ATOM    278  C   ARG A  35       5.277  11.662  -4.595  1.00 29.64           C  
ATOM    279  O   ARG A  35       5.308  10.923  -5.581  1.00 22.71           O  
ATOM    280  CB  ARG A  35       6.987  11.027  -2.994  1.00 12.20           C  
ATOM    281  CG  ARG A  35       8.523  10.828  -2.764  1.00 26.06           C  
ATOM    282  CD  ARG A  35       9.329  12.041  -2.294  1.00 42.50           C  
ATOM    283  NE  ARG A  35      10.656  11.740  -1.732  1.00 25.84           N  
ATOM    284  CZ  ARG A  35      11.428  12.643  -1.121  1.00 99.75           C  
ATOM    285  NH1 ARG A  35      11.006  13.899  -1.008  1.00 19.66           N  
ATOM    286  NH2 ARG A  35      12.622  12.317  -0.622  1.00 24.74           N  
ATOM    287  N   THR A  36       4.158  12.084  -4.020  1.00  5.93           N  
ATOM    288  CA  THR A  36       2.821  11.700  -4.504  1.00  8.72           C  
ATOM    289  C   THR A  36       1.953  12.943  -4.443  1.00 28.47           C  
ATOM    290  O   THR A  36       1.200  13.167  -3.483  1.00 25.91           O  
ATOM    291  CB  THR A  36       2.313  10.592  -3.554  1.00 12.27           C  
ATOM    292  OG1 THR A  36       3.244   9.508  -3.702  1.00 11.63           O  
ATOM    293  CG2 THR A  36       0.937  10.112  -3.953  1.00  7.21           C  
ATOM    294  N   PRO A  37       2.088  13.759  -5.485  1.00 30.01           N  
ATOM    295  CA  PRO A  37       1.343  15.004  -5.527  1.00 13.85           C  
ATOM    296  C   PRO A  37      -0.145  14.816  -5.524  1.00 10.07           C  
ATOM    297  O   PRO A  37      -0.875  15.665  -5.046  1.00 12.91           O  
ATOM    298  CB  PRO A  37       1.833  15.718  -6.789  1.00 15.53           C  
ATOM    299  CG  PRO A  37       2.614  14.743  -7.540  1.00 29.79           C  
ATOM    300  CD  PRO A  37       3.075  13.681  -6.573  1.00 13.99           C  
ATOM    301  N   GLU A  38      -0.623  13.703  -6.060  1.00 14.75           N  
ATOM    302  CA  GLU A  38      -2.063  13.630  -6.034  1.00  3.94           C  
ATOM    303  C   GLU A  38      -2.588  12.903  -4.814  1.00 28.81           C  
ATOM    304  O   GLU A  38      -3.755  12.540  -4.755  1.00  8.98           O  
ATOM    305  CB  GLU A  38      -2.546  13.122  -7.396  1.00 11.73           C  
ATOM    306  CG  GLU A  38      -2.526  14.237  -8.461  1.00 12.92           C  
ATOM    307  CD  GLU A  38      -2.928  13.718  -9.818  1.00 99.75           C  
ATOM    308  OE1 GLU A  38      -3.348  12.549  -9.898  1.00 29.74           O  
ATOM    309  OE2 GLU A  38      -2.813  14.454 -10.809  1.00 13.43           O  
ATOM    310  N   ALA A  39      -1.710  12.731  -3.831  1.00 18.24           N  
ATOM    311  CA  ALA A  39      -2.061  12.053  -2.589  1.00 14.85           C  
ATOM    312  C   ALA A  39      -3.439  12.466  -2.118  1.00 13.11           C  
ATOM    313  O   ALA A  39      -3.685  13.660  -1.989  1.00 20.02           O  
ATOM    314  CB  ALA A  39      -1.033  12.354  -1.491  1.00 12.07           C  
ATOM    315  N   SER A  40      -4.310  11.481  -1.858  1.00 16.04           N  
ATOM    316  CA  SER A  40      -5.674  11.722  -1.381  1.00  9.67           C  
ATOM    317  C   SER A  40      -6.189  10.872  -0.194  1.00 16.77           C  
ATOM    318  O   SER A  40      -7.334  11.016   0.222  1.00 15.74           O  
ATOM    319  CB  SER A  40      -6.670  11.652  -2.533  1.00 22.06           C  
ATOM    320  OG  SER A  40      -6.667  10.346  -3.066  1.00 16.93           O  
ATOM    321  N   SER A  41      -5.356  10.000   0.363  1.00 10.55           N  
ATOM    322  CA  SER A  41      -5.738   9.149   1.509  1.00  5.08           C  
ATOM    323  C   SER A  41      -4.455   8.808   2.267  1.00 19.79           C  
ATOM    324  O   SER A  41      -3.346   8.816   1.718  1.00 15.01           O  
ATOM    325  CB  SER A  41      -6.457   7.870   1.037  1.00 11.76           C  
ATOM    326  OG  SER A  41      -5.686   7.164   0.060  1.00  9.23           O  
ATOM    327  N   LEU A  42      -4.576   8.510   3.546  1.00 12.10           N  
ATOM    328  CA  LEU A  42      -3.359   8.210   4.283  1.00  5.76           C  
ATOM    329  C   LEU A  42      -3.696   7.278   5.431  1.00 13.67           C  
ATOM    330  O   LEU A  42      -4.753   7.408   6.044  1.00  7.40           O  
ATOM    331  CB  LEU A  42      -2.793   9.512   4.881  1.00  6.06           C  
ATOM    332  CG  LEU A  42      -1.652   9.301   5.892  1.00 21.24           C  
ATOM    333  CD1 LEU A  42      -0.620  10.425   5.910  1.00  1.79           C  
ATOM    334  CD2 LEU A  42      -2.138   9.075   7.304  1.00 10.57           C  
ATOM    335  N   LEU A  43      -2.785   6.342   5.677  1.00 13.97           N  
ATOM    336  CA  LEU A  43      -2.897   5.363   6.751  1.00 13.59           C  
ATOM    337  C   LEU A  43      -1.780   5.592   7.787  1.00 12.43           C  
ATOM    338  O   LEU A  43      -0.597   5.629   7.461  1.00  9.71           O  
ATOM    339  CB  LEU A  43      -2.758   3.944   6.213  1.00  1.00           C  
ATOM    340  CG  LEU A  43      -2.659   2.894   7.329  1.00  1.87           C  
ATOM    341  CD1 LEU A  43      -3.992   2.869   8.093  1.00  2.41           C  
ATOM    342  CD2 LEU A  43      -2.402   1.570   6.587  1.00  8.79           C  
ATOM    343  N   ASP A  44      -2.178   5.731   9.044  1.00 24.13           N  
ATOM    344  CA  ASP A  44      -1.248   5.937  10.141  1.00  4.00           C  
ATOM    345  C   ASP A  44      -1.159   4.640  10.903  1.00  7.61           C  
ATOM    346  O   ASP A  44      -2.091   4.256  11.632  1.00  8.90           O  
ATOM    347  CB  ASP A  44      -1.840   6.963  11.109  1.00 23.98           C  
ATOM    348  CG  ASP A  44      -0.800   7.585  12.033  1.00 23.10           C  
ATOM    349  OD1 ASP A  44       0.357   7.115  12.113  1.00 36.48           O  
ATOM    350  OD2 ASP A  44      -1.167   8.592  12.665  1.00 30.05           O  
ATOM    351  N   VAL A  45      -0.023   3.985  10.707  1.00  5.45           N  
ATOM    352  CA  VAL A  45       0.261   2.709  11.342  1.00  6.38           C  
ATOM    353  C   VAL A  45       0.801   2.997  12.750  1.00 27.40           C  
ATOM    354  O   VAL A  45       1.698   3.831  12.917  1.00 10.90           O  
ATOM    355  CB  VAL A  45       1.265   1.989  10.460  1.00  8.23           C  
ATOM    356  CG1 VAL A  45       1.872   0.819  11.206  1.00  3.13           C  
ATOM    357  CG2 VAL A  45       0.606   1.659   9.139  1.00 14.00           C  
ATOM    358  N   ALA A  46       0.246   2.319  13.752  1.00 10.70           N  
ATOM    359  CA  ALA A  46       0.620   2.522  15.172  1.00 17.02           C  
ATOM    360  C   ALA A  46       0.368   3.991  15.522  1.00  8.70           C  
ATOM    361  O   ALA A  46       1.210   4.700  16.096  1.00  6.78           O  
ATOM    362  CB  ALA A  46       2.058   2.138  15.463  1.00 11.01           C  
ATOM    363  N   CYS A  47      -0.819   4.442  15.147  1.00 11.88           N  
ATOM    364  CA  CYS A  47      -1.253   5.825  15.356  1.00  8.14           C  
ATOM    365  C   CYS A  47      -1.357   6.295  16.807  1.00 16.52           C  
ATOM    366  O   CYS A  47      -1.597   7.487  17.055  1.00 12.10           O  
ATOM    367  CB  CYS A  47      -2.644   6.001  14.724  1.00 16.81           C  
ATOM    368  SG  CYS A  47      -4.007   5.010  15.459  1.00 12.02           S  
ATOM    369  N   GLY A  48      -1.219   5.367  17.744  1.00  8.82           N  
ATOM    370  CA  GLY A  48      -1.321   5.680  19.175  1.00  7.85           C  
ATOM    371  C   GLY A  48      -2.696   6.273  19.549  1.00  8.72           C  
ATOM    372  O   GLY A  48      -3.733   5.690  19.250  1.00 10.97           O  
ATOM    373  N   THR A  49      -2.692   7.443  20.184  1.00 21.19           N  
ATOM    374  CA  THR A  49      -3.924   8.120  20.574  1.00 19.85           C  
ATOM    375  C   THR A  49      -4.407   9.017  19.424  1.00 41.46           C  
ATOM    376  O   THR A  49      -5.325   9.811  19.621  1.00 15.68           O  
ATOM    377  CB  THR A  49      -3.812   8.973  21.867  1.00  7.10           C  
ATOM    378  OG1 THR A  49      -2.922  10.069  21.605  1.00 12.08           O  
ATOM    379  CG2 THR A  49      -3.315   8.152  23.071  1.00  2.33           C  
ATOM    380  N   GLY A  50      -3.813   8.914  18.237  1.00  6.10           N  
ATOM    381  CA  GLY A  50      -4.300   9.713  17.111  1.00 15.12           C  
ATOM    382  C   GLY A  50      -4.063  11.191  16.907  1.00 12.00           C  
ATOM    383  O   GLY A  50      -4.723  11.875  16.100  1.00  8.65           O  
ATOM    384  N   THR A  51      -3.079  11.683  17.638  1.00  7.51           N  
ATOM    385  CA  THR A  51      -2.778  13.094  17.509  1.00 17.78           C  
ATOM    386  C   THR A  51      -2.339  13.409  16.098  1.00 12.63           C  
ATOM    387  O   THR A  51      -2.880  14.351  15.529  1.00 18.15           O  
ATOM    388  CB  THR A  51      -1.818  13.611  18.593  1.00  6.94           C  
ATOM    389  OG1 THR A  51      -2.233  13.081  19.857  1.00 23.46           O  
ATOM    390  CG2 THR A  51      -1.861  15.116  18.625  1.00 17.48           C  
ATOM    391  N   HIS A  52      -1.395  12.668  15.504  1.00 15.96           N  
ATOM    392  CA  HIS A  52      -1.032  13.024  14.126  1.00 11.19           C  
ATOM    393  C   HIS A  52      -2.277  12.728  13.266  1.00  3.66           C  
ATOM    394  O   HIS A  52      -2.631  13.520  12.381  1.00 10.68           O  
ATOM    395  CB  HIS A  52       0.142  12.188  13.493  1.00 31.18           C  
ATOM    396  CG  HIS A  52       1.478  12.381  14.141  1.00 17.77           C  
ATOM    397  ND1 HIS A  52       2.113  11.371  14.834  1.00 17.37           N  
ATOM    398  CD2 HIS A  52       2.302  13.452  14.202  1.00 12.86           C  
ATOM    399  CE1 HIS A  52       3.262  11.817  15.312  1.00 20.13           C  
ATOM    400  NE2 HIS A  52       3.403  13.078  14.936  1.00 11.44           N  
ATOM    401  N   LEU A  53      -2.935  11.596  13.516  1.00  7.52           N  
ATOM    402  CA  LEU A  53      -4.110  11.265  12.704  1.00 13.46           C  
ATOM    403  C   LEU A  53      -5.111  12.396  12.585  1.00 19.11           C  
ATOM    404  O   LEU A  53      -5.671  12.651  11.530  1.00 11.18           O  
ATOM    405  CB  LEU A  53      -4.818  10.016  13.172  1.00 15.70           C  
ATOM    406  CG  LEU A  53      -5.875   9.594  12.147  1.00 25.88           C  
ATOM    407  CD1 LEU A  53      -5.385   9.477  10.695  1.00  8.73           C  
ATOM    408  CD2 LEU A  53      -6.330   8.245  12.654  1.00  3.32           C  
ATOM    409  N   GLU A  54      -5.315  13.092  13.688  1.00 11.68           N  
ATOM    410  CA  GLU A  54      -6.257  14.202  13.629  1.00 11.96           C  
ATOM    411  C   GLU A  54      -5.897  15.145  12.480  1.00 37.25           C  
ATOM    412  O   GLU A  54      -6.713  15.396  11.597  1.00 16.90           O  
ATOM    413  CB  GLU A  54      -6.279  14.931  14.978  1.00 19.63           C  
ATOM    414  CG  GLU A  54      -7.417  15.936  15.170  1.00 19.88           C  
ATOM    415  CD  GLU A  54      -7.222  16.735  16.453  1.00 24.79           C  
ATOM    416  OE1 GLU A  54      -7.128  16.089  17.515  1.00 30.46           O  
ATOM    417  OE2 GLU A  54      -7.107  17.983  16.398  1.00 99.75           O  
ATOM    418  N   HIS A  55      -4.668  15.658  12.511  1.00 11.09           N  
ATOM    419  CA  HIS A  55      -4.130  16.582  11.516  1.00  6.84           C  
ATOM    420  C   HIS A  55      -4.013  15.974  10.122  1.00 21.73           C  
ATOM    421  O   HIS A  55      -4.233  16.622   9.077  1.00 13.98           O  
ATOM    422  CB  HIS A  55      -2.751  17.032  12.038  1.00 14.11           C  
ATOM    423  CG  HIS A  55      -2.801  17.601  13.421  1.00 55.76           C  
ATOM    424  ND1 HIS A  55      -3.248  18.878  13.691  1.00 20.22           N  
ATOM    425  CD2 HIS A  55      -2.461  17.066  14.613  1.00 19.55           C  
ATOM    426  CE1 HIS A  55      -3.184  19.107  14.990  1.00 99.75           C  
ATOM    427  NE2 HIS A  55      -2.707  18.023  15.570  1.00 20.61           N  
ATOM    428  N   PHE A  56      -3.669  14.695  10.097  1.00  6.77           N  
ATOM    429  CA  PHE A  56      -3.554  14.078   8.775  1.00  2.13           C  
ATOM    430  C   PHE A  56      -4.961  14.051   8.216  1.00 10.40           C  
ATOM    431  O   PHE A  56      -5.147  14.173   7.010  1.00 25.30           O  
ATOM    432  CB  PHE A  56      -3.076  12.617   8.826  1.00 10.17           C  
ATOM    433  CG  PHE A  56      -1.606  12.453   9.080  1.00 34.71           C  
ATOM    434  CD1 PHE A  56      -0.700  13.375   8.569  1.00  8.68           C  
ATOM    435  CD2 PHE A  56      -1.140  11.366   9.833  1.00  2.83           C  
ATOM    436  CE1 PHE A  56       0.647  13.215   8.789  1.00  6.01           C  
ATOM    437  CE2 PHE A  56       0.218  11.199  10.061  1.00  9.35           C  
ATOM    438  CZ  PHE A  56       1.111  12.136   9.553  1.00 18.04           C  
ATOM    439  N   THR A  57      -5.945  13.847   9.087  1.00 12.63           N  
ATOM    440  CA  THR A  57      -7.313  13.792   8.580  1.00  9.09           C  
ATOM    441  C   THR A  57      -7.664  15.114   7.928  1.00 41.67           C  
ATOM    442  O   THR A  57      -8.296  15.122   6.874  1.00 13.37           O  
ATOM    443  CB  THR A  57      -8.364  13.321   9.623  1.00  9.54           C  
ATOM    444  OG1 THR A  57      -8.067  11.967   9.948  1.00 14.62           O  
ATOM    445  CG2 THR A  57      -9.770  13.297   8.986  1.00 14.17           C  
ATOM    446  N   LYS A  58      -7.244  16.217   8.544  1.00 12.70           N  
ATOM    447  CA  LYS A  58      -7.541  17.516   7.950  1.00 13.35           C  
ATOM    448  C   LYS A  58      -6.750  17.690   6.653  1.00 30.14           C  
ATOM    449  O   LYS A  58      -7.188  18.322   5.699  1.00 32.03           O  
ATOM    450  CB  LYS A  58      -7.207  18.662   8.905  1.00 19.53           C  
ATOM    451  CG  LYS A  58      -7.987  19.931   8.570  1.00 48.58           C  
ATOM    452  CD  LYS A  58      -8.769  20.422   9.791  1.00 99.75           C  
ATOM    453  CE  LYS A  58      -9.390  21.801   9.571  1.00 99.75           C  
ATOM    454  NZ  LYS A  58      -9.818  22.028   8.154  1.00 99.75           N  
ATOM    455  N   GLU A  59      -5.560  17.119   6.602  1.00 13.02           N  
ATOM    456  CA  GLU A  59      -4.773  17.264   5.390  1.00 12.97           C  
ATOM    457  C   GLU A  59      -5.328  16.519   4.184  1.00 28.39           C  
ATOM    458  O   GLU A  59      -5.459  17.089   3.101  1.00 15.34           O  
ATOM    459  CB  GLU A  59      -3.342  16.730   5.610  1.00 17.18           C  
ATOM    460  CG  GLU A  59      -2.403  17.637   6.427  1.00 14.50           C  
ATOM    461  CD  GLU A  59      -1.822  18.774   5.594  1.00 99.75           C  
ATOM    462  OE1 GLU A  59      -2.319  18.978   4.458  1.00 26.04           O  
ATOM    463  OE2 GLU A  59      -0.889  19.466   6.082  1.00 46.61           O  
ATOM    464  N   PHE A  60      -5.620  15.236   4.358  1.00  6.75           N  
ATOM    465  CA  PHE A  60      -6.100  14.388   3.266  1.00 11.03           C  
ATOM    466  C   PHE A  60      -7.540  13.926   3.280  1.00 15.30           C  
ATOM    467  O   PHE A  60      -8.019  13.353   2.296  1.00 17.89           O  
ATOM    468  CB  PHE A  60      -5.170  13.169   3.162  1.00 11.14           C  
ATOM    469  CG  PHE A  60      -3.748  13.557   2.858  1.00 12.06           C  
ATOM    470  CD1 PHE A  60      -3.398  13.893   1.584  1.00 12.84           C  
ATOM    471  CD2 PHE A  60      -2.777  13.608   3.843  1.00 24.42           C  
ATOM    472  CE1 PHE A  60      -2.104  14.267   1.277  1.00 20.07           C  
ATOM    473  CE2 PHE A  60      -1.460  13.983   3.539  1.00 10.02           C  
ATOM    474  CZ  PHE A  60      -1.135  14.319   2.251  1.00 32.85           C  
ATOM    475  N   GLY A  61      -8.220  14.167   4.397  1.00 17.68           N  
ATOM    476  CA  GLY A  61      -9.616  13.756   4.509  1.00 24.40           C  
ATOM    477  C   GLY A  61      -9.911  12.257   4.614  1.00 17.56           C  
ATOM    478  O   GLY A  61     -10.566  11.835   5.570  1.00 27.01           O  
ATOM    479  N   ASP A  62      -9.431  11.472   3.649  1.00 15.95           N  
ATOM    480  CA  ASP A  62      -9.660  10.027   3.644  1.00 10.46           C  
ATOM    481  C   ASP A  62      -8.518   9.372   4.400  1.00 11.92           C  
ATOM    482  O   ASP A  62      -7.467   9.019   3.835  1.00 10.97           O  
ATOM    483  CB  ASP A  62      -9.759   9.505   2.198  1.00  7.53           C  
ATOM    484  CG  ASP A  62      -9.967   7.985   2.116  1.00 12.77           C  
ATOM    485  OD1 ASP A  62     -10.211   7.366   3.170  1.00 16.57           O  
ATOM    486  OD2 ASP A  62      -9.833   7.399   1.020  1.00 12.42           O  
ATOM    487  N   THR A  63      -8.708   9.188   5.698  1.00 12.60           N  
ATOM    488  CA  THR A  63      -7.613   8.580   6.453  1.00  7.06           C  
ATOM    489  C   THR A  63      -8.051   7.410   7.359  1.00 92.62           C  
ATOM    490  O   THR A  63      -9.227   7.238   7.656  1.00 10.79           O  
ATOM    491  CB  THR A  63      -6.994   9.690   7.357  1.00 14.25           C  
ATOM    492  OG1 THR A  63      -8.024  10.226   8.197  1.00 12.07           O  
ATOM    493  CG2 THR A  63      -6.390  10.852   6.570  1.00  7.48           C  
ATOM    494  N   ALA A  64      -7.114   6.585   7.814  1.00  7.73           N  
ATOM    495  CA  ALA A  64      -7.445   5.491   8.726  1.00 20.64           C  
ATOM    496  C   ALA A  64      -6.279   5.287   9.685  1.00 20.29           C  
ATOM    497  O   ALA A  64      -5.151   5.712   9.409  1.00 11.70           O  
ATOM    498  CB  ALA A  64      -7.778   4.190   8.020  1.00 12.09           C  
ATOM    499  N   GLY A  65      -6.548   4.615  10.801  1.00  9.28           N  
ATOM    500  CA  GLY A  65      -5.508   4.347  11.771  1.00  1.00           C  
ATOM    501  C   GLY A  65      -5.450   2.858  12.114  1.00  8.77           C  
ATOM    502  O   GLY A  65      -6.477   2.172  12.117  1.00  8.93           O  
ATOM    503  N   LEU A  66      -4.237   2.405  12.439  1.00  6.04           N  
ATOM    504  CA  LEU A  66      -3.973   1.028  12.826  1.00 17.29           C  
ATOM    505  C   LEU A  66      -3.189   1.077  14.149  1.00 10.05           C  
ATOM    506  O   LEU A  66      -2.223   1.841  14.301  1.00 14.76           O  
ATOM    507  CB  LEU A  66      -3.142   0.289  11.780  1.00  8.25           C  
ATOM    508  CG  LEU A  66      -2.878  -1.181  12.128  1.00 24.72           C  
ATOM    509  CD1 LEU A  66      -4.101  -2.000  11.752  1.00 17.92           C  
ATOM    510  CD2 LEU A  66      -1.609  -1.753  11.450  1.00 11.95           C  
ATOM    511  N   GLU A  67      -3.618   0.260  15.106  1.00  9.68           N  
ATOM    512  CA  GLU A  67      -2.969   0.197  16.407  1.00 26.57           C  
ATOM    513  C   GLU A  67      -3.162  -1.212  16.944  1.00 23.35           C  
ATOM    514  O   GLU A  67      -4.234  -1.816  16.834  1.00 19.55           O  
ATOM    515  CB  GLU A  67      -3.688   1.132  17.380  1.00 16.67           C  
ATOM    516  CG  GLU A  67      -2.895   2.207  18.129  1.00 18.91           C  
ATOM    517  CD  GLU A  67      -1.494   1.841  18.598  1.00 14.43           C  
ATOM    518  OE1 GLU A  67      -0.625   2.726  18.389  1.00 12.15           O  
ATOM    519  OE2 GLU A  67      -1.241   0.757  19.201  1.00 14.51           O  
ATOM    520  N   LEU A  68      -2.103  -1.708  17.558  1.00 14.23           N  
ATOM    521  CA  LEU A  68      -2.099  -3.037  18.156  1.00 15.54           C  
ATOM    522  C   LEU A  68      -2.755  -2.943  19.544  1.00 90.91           C  
ATOM    523  O   LEU A  68      -3.442  -3.865  19.977  1.00  8.50           O  
ATOM    524  CB  LEU A  68      -0.634  -3.549  18.227  1.00 11.28           C  
ATOM    525  CG  LEU A  68      -0.361  -4.735  19.142  1.00  7.48           C  
ATOM    526  CD1 LEU A  68      -1.177  -5.928  18.691  1.00 12.87           C  
ATOM    527  CD2 LEU A  68       1.095  -5.120  19.277  1.00  5.23           C  
ATOM    528  N   SER A  69      -2.557  -1.823  20.233  1.00 14.93           N  
ATOM    529  CA  SER A  69      -3.123  -1.620  21.568  1.00 16.89           C  
ATOM    530  C   SER A  69      -4.580  -1.165  21.639  1.00 23.47           C  
ATOM    531  O   SER A  69      -4.997  -0.179  21.044  1.00 13.58           O  
ATOM    532  CB  SER A  69      -2.282  -0.612  22.351  1.00 12.70           C  
ATOM    533  OG  SER A  69      -3.065   0.050  23.329  1.00 12.22           O  
ATOM    534  N   GLU A  70      -5.374  -1.886  22.405  1.00 11.31           N  
ATOM    535  CA  GLU A  70      -6.770  -1.514  22.530  1.00 20.18           C  
ATOM    536  C   GLU A  70      -6.932  -0.239  23.293  1.00 10.84           C  
ATOM    537  O   GLU A  70      -7.837   0.579  23.031  1.00 19.17           O  
ATOM    538  CB  GLU A  70      -7.515  -2.546  23.372  1.00  4.95           C  
ATOM    539  CG  GLU A  70      -8.710  -3.137  22.668  1.00 30.31           C  
ATOM    540  CD  GLU A  70      -9.285  -2.186  21.636  1.00 99.75           C  
ATOM    541  OE1 GLU A  70      -9.632  -1.009  21.944  1.00 34.22           O  
ATOM    542  OE2 GLU A  70      -9.374  -2.692  20.496  1.00 27.03           O  
ATOM    543  N   ASP A  71      -6.055  -0.093  24.276  1.00  4.05           N  
ATOM    544  CA  ASP A  71      -6.148   1.102  25.099  1.00 15.37           C  
ATOM    545  C   ASP A  71      -5.808   2.345  24.286  1.00 20.25           C  
ATOM    546  O   ASP A  71      -6.405   3.417  24.460  1.00 19.88           O  
ATOM    547  CB  ASP A  71      -5.282   0.977  26.344  1.00  8.58           C  
ATOM    548  CG  ASP A  71      -5.372   2.223  27.200  1.00 34.40           C  
ATOM    549  OD1 ASP A  71      -6.461   2.456  27.750  1.00 27.82           O  
ATOM    550  OD2 ASP A  71      -4.395   2.986  27.317  1.00 20.76           O  
ATOM    551  N   MET A  72      -4.846   2.192  23.385  1.00  8.15           N  
ATOM    552  CA  MET A  72      -4.436   3.307  22.523  1.00  6.40           C  
ATOM    553  C   MET A  72      -5.684   3.609  21.705  1.00  7.97           C  
ATOM    554  O   MET A  72      -6.138   4.763  21.625  1.00 12.73           O  
ATOM    555  CB  MET A  72      -3.268   2.878  21.642  1.00 14.03           C  
ATOM    556  CG  MET A  72      -1.946   2.966  22.431  1.00  6.12           C  
ATOM    557  SD  MET A  72      -1.811   4.550  23.265  1.00 16.41           S  
ATOM    558  CE  MET A  72      -1.315   5.593  22.094  1.00 23.39           C  
ATOM    559  N   LEU A  73      -6.257   2.542  21.147  1.00  9.29           N  
ATOM    560  CA  LEU A  73      -7.486   2.633  20.332  1.00 13.56           C  
ATOM    561  C   LEU A  73      -8.651   3.363  21.017  1.00 39.40           C  
ATOM    562  O   LEU A  73      -9.351   4.206  20.447  1.00 11.47           O  
ATOM    563  CB  LEU A  73      -7.923   1.225  19.887  1.00 17.92           C  
ATOM    564  CG  LEU A  73      -7.185   0.641  18.678  1.00 27.45           C  
ATOM    565  CD1 LEU A  73      -7.482  -0.834  18.438  1.00  7.44           C  
ATOM    566  CD2 LEU A  73      -7.491   1.450  17.423  1.00  1.80           C  
ATOM    567  N   THR A  74      -8.877   3.012  22.274  1.00  2.18           N  
ATOM    568  CA  THR A  74      -9.949   3.652  23.022  1.00 14.49           C  
ATOM    569  C   THR A  74      -9.714   5.170  23.115  1.00 13.03           C  
ATOM    570  O   THR A  74     -10.597   6.009  22.985  1.00 13.68           O  
ATOM    571  CB  THR A  74      -9.896   3.052  24.410  1.00 13.84           C  
ATOM    572  OG1 THR A  74     -10.276   1.666  24.302  1.00 21.16           O  
ATOM    573  CG2 THR A  74     -10.768   3.882  25.347  1.00 26.92           C  
ATOM    574  N   HIS A  75      -8.478   5.553  23.335  1.00  6.90           N  
ATOM    575  CA  HIS A  75      -8.185   6.966  23.449  1.00  3.95           C  
ATOM    576  C   HIS A  75      -8.292   7.654  22.116  1.00 16.39           C  
ATOM    577  O   HIS A  75      -8.740   8.800  22.046  1.00 11.49           O  
ATOM    578  CB  HIS A  75      -6.796   7.163  24.014  1.00 12.07           C  
ATOM    579  CG  HIS A  75      -6.709   6.876  25.477  1.00  8.80           C  
ATOM    580  ND1 HIS A  75      -6.671   5.592  25.981  1.00 20.75           N  
ATOM    581  CD2 HIS A  75      -6.627   7.713  26.540  1.00 17.12           C  
ATOM    582  CE1 HIS A  75      -6.577   5.654  27.299  1.00 13.20           C  
ATOM    583  NE2 HIS A  75      -6.547   6.924  27.662  1.00 29.44           N  
ATOM    584  N   ALA A  76      -7.886   6.935  21.078  1.00  8.37           N  
ATOM    585  CA  ALA A  76      -7.941   7.478  19.721  1.00 27.51           C  
ATOM    586  C   ALA A  76      -9.383   7.752  19.328  1.00  7.95           C  
ATOM    587  O   ALA A  76      -9.718   8.738  18.634  1.00  5.91           O  
ATOM    588  CB  ALA A  76      -7.329   6.489  18.749  1.00  9.27           C  
ATOM    589  N   ARG A  77     -10.253   6.838  19.744  1.00 13.74           N  
ATOM    590  CA  ARG A  77     -11.662   6.969  19.404  1.00 14.19           C  
ATOM    591  C   ARG A  77     -12.260   8.133  20.170  1.00 35.51           C  
ATOM    592  O   ARG A  77     -13.034   8.931  19.656  1.00 17.68           O  
ATOM    593  CB  ARG A  77     -12.394   5.645  19.628  1.00  8.61           C  
ATOM    594  CG  ARG A  77     -13.832   5.595  19.093  1.00 59.96           C  
ATOM    595  CD  ARG A  77     -14.727   5.086  20.211  1.00 28.47           C  
ATOM    596  NE  ARG A  77     -14.187   5.515  21.499  1.00 99.75           N  
ATOM    597  CZ  ARG A  77     -13.842   4.759  22.538  1.00 99.75           C  
ATOM    598  NH1 ARG A  77     -13.338   5.383  23.605  1.00 20.56           N  
ATOM    599  NH2 ARG A  77     -13.963   3.426  22.554  1.00 25.42           N  
ATOM    600  N   LYS A  78     -11.876   8.221  21.437  1.00  7.71           N  
ATOM    601  CA  LYS A  78     -12.385   9.323  22.222  1.00 15.20           C  
ATOM    602  C   LYS A  78     -11.984  10.626  21.544  1.00 11.86           C  
ATOM    603  O   LYS A  78     -12.759  11.557  21.478  1.00 13.98           O  
ATOM    604  CB  LYS A  78     -11.729   9.285  23.598  1.00 12.00           C  
ATOM    605  CG  LYS A  78     -12.006  10.551  24.361  1.00 21.74           C  
ATOM    606  CD  LYS A  78     -12.265  10.235  25.809  1.00 42.59           C  
ATOM    607  CE  LYS A  78     -12.187  11.498  26.649  1.00 99.75           C  
ATOM    608  NZ  LYS A  78     -11.402  11.310  27.907  1.00 52.40           N  
ATOM    609  N   ARG A  79     -10.766  10.739  21.039  1.00  3.61           N  
ATOM    610  CA  ARG A  79     -10.322  11.970  20.387  1.00  8.41           C  
ATOM    611  C   ARG A  79     -10.945  12.146  19.015  1.00 12.72           C  
ATOM    612  O   ARG A  79     -11.262  13.262  18.597  1.00  8.32           O  
ATOM    613  CB  ARG A  79      -8.806  11.906  20.186  1.00 13.30           C  
ATOM    614  CG  ARG A  79      -8.153  13.226  19.729  1.00  1.44           C  
ATOM    615  CD  ARG A  79      -6.831  13.017  18.959  1.00  6.73           C  
ATOM    616  NE  ARG A  79      -5.860  12.377  19.828  1.00  9.55           N  
ATOM    617  CZ  ARG A  79      -5.249  13.015  20.820  1.00 46.54           C  
ATOM    618  NH1 ARG A  79      -5.516  14.295  21.004  1.00  9.12           N  
ATOM    619  NH2 ARG A  79      -4.382  12.407  21.620  1.00 16.33           N  
ATOM    620  N   LEU A  80     -11.105  11.041  18.308  1.00  9.26           N  
ATOM    621  CA  LEU A  80     -11.676  11.083  16.961  1.00  9.61           C  
ATOM    622  C   LEU A  80     -12.824  10.111  16.834  1.00  7.16           C  
ATOM    623  O   LEU A  80     -12.666   9.008  16.300  1.00 15.39           O  
ATOM    624  CB  LEU A  80     -10.606  10.676  15.950  1.00 17.99           C  
ATOM    625  CG  LEU A  80      -9.361  11.583  15.987  1.00 11.82           C  
ATOM    626  CD1 LEU A  80      -8.171  10.959  15.271  1.00  7.07           C  
ATOM    627  CD2 LEU A  80      -9.562  13.074  15.585  1.00 12.14           C  
ATOM    628  N   PRO A  81     -14.002  10.512  17.304  1.00 10.80           N  
ATOM    629  CA  PRO A  81     -15.145   9.611  17.215  1.00  4.02           C  
ATOM    630  C   PRO A  81     -15.507   9.170  15.789  1.00 16.04           C  
ATOM    631  O   PRO A  81     -16.145   8.102  15.616  1.00  8.20           O  
ATOM    632  CB  PRO A  81     -16.313  10.402  17.838  1.00 11.61           C  
ATOM    633  CG  PRO A  81     -15.943  11.834  17.618  1.00  2.58           C  
ATOM    634  CD  PRO A  81     -14.394  11.889  17.619  1.00  6.32           C  
ATOM    635  N   ASP A  82     -15.128   9.951  14.777  1.00  3.32           N  
ATOM    636  CA  ASP A  82     -15.500   9.539  13.416  1.00  3.79           C  
ATOM    637  C   ASP A  82     -14.363   8.991  12.573  1.00 10.79           C  
ATOM    638  O   ASP A  82     -14.488   8.819  11.356  1.00 12.38           O  
ATOM    639  CB  ASP A  82     -16.140  10.685  12.656  1.00 10.23           C  
ATOM    640  CG  ASP A  82     -17.355  11.205  13.346  1.00 26.55           C  
ATOM    641  OD1 ASP A  82     -18.397  10.598  13.070  1.00 19.46           O  
ATOM    642  OD2 ASP A  82     -17.279  12.167  14.138  1.00  9.94           O  
ATOM    643  N   ALA A  83     -13.242   8.744  13.224  1.00 11.88           N  
ATOM    644  CA  ALA A  83     -12.080   8.226  12.511  1.00 13.78           C  
ATOM    645  C   ALA A  83     -12.267   6.747  12.231  1.00 12.68           C  
ATOM    646  O   ALA A  83     -12.952   6.070  12.996  1.00 11.92           O  
ATOM    647  CB  ALA A  83     -10.817   8.408  13.371  1.00 15.93           C  
ATOM    648  N   THR A  84     -11.628   6.268  11.166  1.00 11.90           N  
ATOM    649  CA  THR A  84     -11.667   4.857  10.798  1.00  6.12           C  
ATOM    650  C   THR A  84     -10.444   4.260  11.484  1.00  6.62           C  
ATOM    651  O   THR A  84      -9.323   4.558  11.147  1.00  8.79           O  
ATOM    652  CB  THR A  84     -11.530   4.624   9.295  1.00 12.05           C  
ATOM    653  OG1 THR A  84     -12.734   5.103   8.685  1.00 14.28           O  
ATOM    654  CG2 THR A  84     -11.360   3.120   9.068  1.00  5.09           C  
ATOM    655  N   LEU A  85     -10.670   3.416  12.480  1.00  2.04           N  
ATOM    656  CA  LEU A  85      -9.556   2.858  13.188  1.00  2.64           C  
ATOM    657  C   LEU A  85      -9.571   1.352  13.227  1.00 13.50           C  
ATOM    658  O   LEU A  85     -10.630   0.740  13.350  1.00 10.93           O  
ATOM    659  CB  LEU A  85      -9.585   3.415  14.613  1.00 12.43           C  
ATOM    660  CG  LEU A  85      -9.790   4.908  14.859  1.00 18.18           C  
ATOM    661  CD1 LEU A  85     -10.220   5.231  16.320  1.00  4.11           C  
ATOM    662  CD2 LEU A  85      -8.524   5.658  14.526  1.00 16.93           C  
ATOM    663  N   HIS A  86      -8.394   0.751  13.121  1.00  8.62           N  
ATOM    664  CA  HIS A  86      -8.369  -0.689  13.161  1.00  8.17           C  
ATOM    665  C   HIS A  86      -7.446  -1.271  14.223  1.00 11.01           C  
ATOM    666  O   HIS A  86      -6.381  -0.726  14.484  1.00 16.11           O  
ATOM    667  CB  HIS A  86      -7.863  -1.221  11.831  1.00 12.62           C  
ATOM    668  CG  HIS A  86      -8.536  -0.608  10.644  1.00 12.24           C  
ATOM    669  ND1 HIS A  86      -9.711  -1.102  10.113  1.00 10.97           N  
ATOM    670  CD2 HIS A  86      -8.195   0.466   9.888  1.00 17.24           C  
ATOM    671  CE1 HIS A  86     -10.062  -0.353   9.077  1.00 23.35           C  
ATOM    672  NE2 HIS A  86      -9.166   0.611   8.925  1.00 19.95           N  
ATOM    673  N   GLN A  87      -7.831  -2.400  14.812  1.00 13.13           N  
ATOM    674  CA  GLN A  87      -6.948  -3.017  15.787  1.00  1.97           C  
ATOM    675  C   GLN A  87      -6.163  -3.979  14.882  1.00 15.74           C  
ATOM    676  O   GLN A  87      -6.707  -4.528  13.919  1.00 22.25           O  
ATOM    677  CB  GLN A  87      -7.704  -3.795  16.855  1.00  5.99           C  
ATOM    678  CG  GLN A  87      -6.727  -4.176  17.994  1.00 18.92           C  
ATOM    679  CD  GLN A  87      -5.806  -5.364  17.682  1.00 57.56           C  
ATOM    680  OE1 GLN A  87      -6.143  -6.230  16.883  1.00 20.65           O  
ATOM    681  NE2 GLN A  87      -4.651  -5.432  18.338  1.00 22.24           N  
ATOM    682  N   GLY A  88      -4.885  -4.186  15.155  1.00  7.67           N  
ATOM    683  CA  GLY A  88      -4.115  -5.089  14.304  1.00  8.76           C  
ATOM    684  C   GLY A  88      -2.619  -4.894  14.542  1.00 20.33           C  
ATOM    685  O   GLY A  88      -2.215  -3.973  15.249  1.00 14.49           O  
ATOM    686  N   ASP A  89      -1.811  -5.765  13.940  1.00 12.35           N  
ATOM    687  CA  ASP A  89      -0.358  -5.759  14.036  1.00  4.60           C  
ATOM    688  C   ASP A  89       0.203  -5.250  12.735  1.00 20.67           C  
ATOM    689  O   ASP A  89      -0.132  -5.771  11.668  1.00 10.76           O  
ATOM    690  CB  ASP A  89       0.105  -7.200  14.160  1.00  8.27           C  
ATOM    691  CG  ASP A  89       1.443  -7.312  14.839  1.00 20.85           C  
ATOM    692  OD1 ASP A  89       2.430  -6.697  14.376  1.00 13.13           O  
ATOM    693  OD2 ASP A  89       1.484  -8.010  15.865  1.00 41.02           O  
ATOM    694  N   MET A  90       1.079  -4.257  12.807  1.00  7.09           N  
ATOM    695  CA  MET A  90       1.639  -3.735  11.554  1.00 10.99           C  
ATOM    696  C   MET A  90       2.318  -4.829  10.755  1.00  6.17           C  
ATOM    697  O   MET A  90       2.497  -4.767   9.537  1.00 13.67           O  
ATOM    698  CB  MET A  90       2.705  -2.716  11.904  1.00 13.76           C  
ATOM    699  CG  MET A  90       3.824  -3.210  12.780  1.00  5.27           C  
ATOM    700  SD  MET A  90       5.007  -1.764  12.828  1.00 14.39           S  
ATOM    701  CE  MET A  90       4.439  -0.919  14.320  1.00 11.59           C  
ATOM    702  N   ARG A  91       2.717  -5.845  11.508  1.00  8.18           N  
ATOM    703  CA  ARG A  91       3.377  -7.000  10.934  1.00 15.50           C  
ATOM    704  C   ARG A  91       2.586  -7.695   9.826  1.00 26.14           C  
ATOM    705  O   ARG A  91       3.159  -8.047   8.791  1.00  8.85           O  
ATOM    706  CB  ARG A  91       3.535  -8.007  12.083  1.00 99.75           C  
ATOM    707  CG  ARG A  91       4.957  -8.335  12.506  1.00 25.03           C  
ATOM    708  CD  ARG A  91       5.240  -8.040  13.967  1.00 16.85           C  
ATOM    709  NE  ARG A  91       4.696  -9.001  14.926  1.00 42.65           N  
ATOM    710  CZ  ARG A  91       4.579  -8.745  16.233  1.00 99.75           C  
ATOM    711  NH1 ARG A  91       4.966  -7.582  16.748  1.00 88.37           N  
ATOM    712  NH2 ARG A  91       4.074  -9.676  17.031  1.00 99.75           N  
ATOM    713  N   ASP A  92       1.284  -7.905  10.035  1.00 15.40           N  
ATOM    714  CA  ASP A  92       0.523  -8.622   9.022  1.00 25.92           C  
ATOM    715  C   ASP A  92      -0.943  -8.255   8.752  1.00 23.45           C  
ATOM    716  O   ASP A  92      -1.725  -9.091   8.294  1.00 23.79           O  
ATOM    717  CB  ASP A  92       0.468 -10.001   9.643  1.00  5.45           C  
ATOM    718  CG  ASP A  92      -0.314  -9.974  10.950  1.00 66.63           C  
ATOM    719  OD1 ASP A  92      -0.698  -8.863  11.382  1.00 44.47           O  
ATOM    720  OD2 ASP A  92      -0.571 -11.030  11.557  1.00 32.34           O  
ATOM    721  N   PHE A  93      -1.320  -7.016   9.035  1.00 33.27           N  
ATOM    722  CA  PHE A  93      -2.695  -6.578   8.834  1.00 20.50           C  
ATOM    723  C   PHE A  93      -3.060  -6.540   7.368  1.00  9.43           C  
ATOM    724  O   PHE A  93      -2.180  -6.447   6.508  1.00  7.00           O  
ATOM    725  CB  PHE A  93      -2.879  -5.169   9.416  1.00  7.24           C  
ATOM    726  CG  PHE A  93      -2.099  -4.098   8.675  1.00 16.56           C  
ATOM    727  CD1 PHE A  93      -0.718  -4.016   8.767  1.00 11.44           C  
ATOM    728  CD2 PHE A  93      -2.748  -3.149   7.890  1.00 13.07           C  
ATOM    729  CE1 PHE A  93      -0.023  -3.011   8.068  1.00 15.02           C  
ATOM    730  CE2 PHE A  93      -2.068  -2.144   7.212  1.00  8.58           C  
ATOM    731  CZ  PHE A  93      -0.692  -2.081   7.289  1.00 19.57           C  
ATOM    732  N   ARG A  94      -4.369  -6.613   7.124  1.00  1.97           N  
ATOM    733  CA  ARG A  94      -4.995  -6.564   5.799  1.00  9.20           C  
ATOM    734  C   ARG A  94      -6.265  -5.760   5.947  1.00  4.36           C  
ATOM    735  O   ARG A  94      -7.209  -6.209   6.589  1.00 16.94           O  
ATOM    736  CB  ARG A  94      -5.353  -7.944   5.317  1.00 13.65           C  
ATOM    737  CG  ARG A  94      -4.126  -8.703   4.881  1.00 21.74           C  
ATOM    738  CD  ARG A  94      -3.156  -7.865   4.033  1.00 70.37           C  
ATOM    739  NE  ARG A  94      -2.009  -8.640   3.549  1.00 99.75           N  
ATOM    740  CZ  ARG A  94      -2.052  -9.906   3.122  1.00 99.75           C  
ATOM    741  NH1 ARG A  94      -3.188 -10.606   3.103  1.00 99.75           N  
ATOM    742  NH2 ARG A  94      -0.930 -10.491   2.708  1.00 99.75           N  
ATOM    743  N   LEU A  95      -6.262  -4.561   5.371  1.00 11.19           N  
ATOM    744  CA  LEU A  95      -7.418  -3.679   5.465  1.00 10.74           C  
ATOM    745  C   LEU A  95      -8.380  -3.740   4.281  1.00 12.32           C  
ATOM    746  O   LEU A  95      -9.456  -3.175   4.362  1.00 20.34           O  
ATOM    747  CB  LEU A  95      -6.923  -2.247   5.628  1.00 10.92           C  
ATOM    748  CG  LEU A  95      -6.066  -1.959   6.854  1.00 15.09           C  
ATOM    749  CD1 LEU A  95      -5.821  -0.460   6.926  1.00  7.44           C  
ATOM    750  CD2 LEU A  95      -6.507  -2.583   8.197  1.00  7.41           C  
ATOM    751  N   GLY A  96      -8.014  -4.423   3.204  1.00 26.25           N  
ATOM    752  CA  GLY A  96      -8.884  -4.533   2.040  1.00 13.17           C  
ATOM    753  C   GLY A  96      -9.030  -3.264   1.214  1.00 12.77           C  
ATOM    754  O   GLY A  96      -9.988  -3.076   0.464  1.00 99.75           O  
ATOM    755  N   ARG A  97      -8.038  -2.392   1.357  1.00 17.43           N  
ATOM    756  CA  ARG A  97      -8.029  -1.140   0.608  1.00 24.01           C  
ATOM    757  C   ARG A  97      -6.593  -0.650   0.513  1.00 33.90           C  
ATOM    758  O   ARG A  97      -5.685  -1.219   1.127  1.00 14.95           O  
ATOM    759  CB  ARG A  97      -8.962  -0.085   1.220  1.00  8.89           C  
ATOM    760  CG  ARG A  97      -8.384   0.498   2.528  1.00  1.00           C  
ATOM    761  CD  ARG A  97      -9.032   1.837   2.707  1.00  7.14           C  
ATOM    762  NE  ARG A  97      -8.376   2.834   1.850  1.00 15.41           N  
ATOM    763  CZ  ARG A  97      -8.694   4.126   1.843  1.00 13.63           C  
ATOM    764  NH1 ARG A  97      -9.629   4.593   2.669  1.00  7.85           N  
ATOM    765  NH2 ARG A  97      -8.064   4.962   1.027  1.00 10.55           N  
ATOM    766  N   LYS A  98      -6.393   0.401  -0.271  1.00 18.58           N  
ATOM    767  CA  LYS A  98      -5.065   0.970  -0.467  1.00  8.16           C  
ATOM    768  C   LYS A  98      -5.162   2.442  -0.088  1.00 31.56           C  
ATOM    769  O   LYS A  98      -6.264   2.962   0.058  1.00 10.92           O  
ATOM    770  CB  LYS A  98      -4.696   0.891  -1.944  1.00 33.04           C  
ATOM    771  CG  LYS A  98      -3.795  -0.272  -2.314  1.00 39.95           C  
ATOM    772  CD  LYS A  98      -4.577  -1.576  -2.444  1.00 25.95           C  
ATOM    773  CE  LYS A  98      -3.743  -2.562  -3.278  1.00 22.99           C  
ATOM    774  NZ  LYS A  98      -2.627  -1.837  -3.979  1.00 99.75           N  
ATOM    775  N   PHE A  99      -4.019   3.100   0.071  1.00 14.39           N  
ATOM    776  CA  PHE A  99      -3.969   4.521   0.415  1.00  1.00           C  
ATOM    777  C   PHE A  99      -2.816   5.118  -0.390  1.00 28.55           C  
ATOM    778  O   PHE A  99      -1.863   4.449  -0.787  1.00 21.74           O  
ATOM    779  CB  PHE A  99      -3.573   4.664   1.905  1.00 12.37           C  
ATOM    780  CG  PHE A  99      -4.507   3.952   2.846  1.00  7.50           C  
ATOM    781  CD1 PHE A  99      -4.470   2.578   2.972  1.00 13.51           C  
ATOM    782  CD2 PHE A  99      -5.423   4.663   3.602  1.00  3.69           C  
ATOM    783  CE1 PHE A  99      -5.316   1.944   3.852  1.00  1.00           C  
ATOM    784  CE2 PHE A  99      -6.297   4.033   4.477  1.00  9.57           C  
ATOM    785  CZ  PHE A  99      -6.237   2.660   4.583  1.00  5.63           C  
ATOM    786  N   SER A 100      -2.911   6.413  -0.622  1.00  7.87           N  
ATOM    787  CA  SER A 100      -1.883   7.138  -1.360  1.00  9.57           C  
ATOM    788  C   SER A 100      -0.637   7.116  -0.492  1.00 18.15           C  
ATOM    789  O   SER A 100       0.474   7.025  -1.006  1.00 11.91           O  
ATOM    790  CB  SER A 100      -2.319   8.600  -1.491  1.00  1.00           C  
ATOM    791  OG  SER A 100      -3.564   8.607  -2.172  1.00 11.72           O  
ATOM    792  N   ALA A 101      -0.832   7.222   0.821  1.00 10.09           N  
ATOM    793  CA  ALA A 101       0.312   7.193   1.715  1.00 13.05           C  
ATOM    794  C   ALA A 101       0.086   6.346   2.945  1.00 13.94           C  
ATOM    795  O   ALA A 101      -1.018   6.295   3.528  1.00  5.27           O  
ATOM    796  CB  ALA A 101       0.716   8.592   2.131  1.00 11.53           C  
ATOM    797  N   VAL A 102       1.173   5.684   3.323  1.00  1.57           N  
ATOM    798  CA  VAL A 102       1.197   4.862   4.530  1.00 34.76           C  
ATOM    799  C   VAL A 102       2.374   5.374   5.363  1.00 25.06           C  
ATOM    800  O   VAL A 102       3.532   5.342   4.934  1.00 18.61           O  
ATOM    801  CB  VAL A 102       1.415   3.374   4.284  1.00  1.91           C  
ATOM    802  CG1 VAL A 102       1.576   2.602   5.609  1.00  7.86           C  
ATOM    803  CG2 VAL A 102       0.372   2.822   3.312  1.00  6.24           C  
ATOM    804  N   VAL A 103       2.081   5.852   6.566  1.00 10.38           N  
ATOM    805  CA  VAL A 103       3.144   6.358   7.413  1.00  7.16           C  
ATOM    806  C   VAL A 103       3.133   5.760   8.833  1.00  6.28           C  
ATOM    807  O   VAL A 103       2.094   5.399   9.388  1.00 16.08           O  
ATOM    808  CB  VAL A 103       3.058   7.916   7.489  1.00  1.12           C  
ATOM    809  CG1 VAL A 103       2.805   8.526   6.094  1.00  1.67           C  
ATOM    810  CG2 VAL A 103       1.913   8.368   8.384  1.00 12.08           C  
ATOM    811  N   SER A 104       4.315   5.686   9.419  1.00 15.08           N  
ATOM    812  CA  SER A 104       4.462   5.197  10.778  1.00 19.11           C  
ATOM    813  C   SER A 104       5.380   6.205  11.493  1.00 15.06           C  
ATOM    814  O   SER A 104       6.543   6.330  11.152  1.00  9.64           O  
ATOM    815  CB  SER A 104       4.986   3.774  10.800  1.00  8.02           C  
ATOM    816  OG  SER A 104       4.763   3.227  12.088  1.00  8.48           O  
ATOM    817  N   MET A 105       4.844   6.941  12.465  1.00  7.42           N  
ATOM    818  CA  MET A 105       5.593   7.958  13.202  1.00 11.04           C  
ATOM    819  C   MET A 105       6.023   7.550  14.582  1.00  9.96           C  
ATOM    820  O   MET A 105       5.469   6.625  15.202  1.00  2.59           O  
ATOM    821  CB  MET A 105       4.667   9.179  13.477  1.00  9.86           C  
ATOM    822  CG  MET A 105       3.914   9.759  12.239  1.00 11.96           C  
ATOM    823  SD  MET A 105       5.176  10.091  11.011  1.00 14.42           S  
ATOM    824  CE  MET A 105       5.982  11.539  11.830  1.00 14.79           C  
ATOM    825  N   PHE A 106       6.968   8.352  15.060  1.00  9.37           N  
ATOM    826  CA  PHE A 106       7.499   8.219  16.408  1.00  3.52           C  
ATOM    827  C   PHE A 106       8.138   6.865  16.800  1.00 16.90           C  
ATOM    828  O   PHE A 106       8.000   6.332  17.920  1.00  7.86           O  
ATOM    829  CB  PHE A 106       6.422   8.760  17.372  1.00  1.00           C  
ATOM    830  CG  PHE A 106       6.962   9.449  18.576  1.00  7.08           C  
ATOM    831  CD1 PHE A 106       8.182  10.110  18.542  1.00  8.47           C  
ATOM    832  CD2 PHE A 106       6.251   9.443  19.764  1.00 16.83           C  
ATOM    833  CE1 PHE A 106       8.668  10.754  19.696  1.00 22.14           C  
ATOM    834  CE2 PHE A 106       6.725  10.074  20.903  1.00 13.62           C  
ATOM    835  CZ  PHE A 106       7.932  10.722  20.876  1.00  8.80           C  
ATOM    836  N   SER A 107       8.846   6.307  15.824  1.00 11.40           N  
ATOM    837  CA  SER A 107       9.597   5.086  16.022  1.00  5.88           C  
ATOM    838  C   SER A 107       8.905   3.816  16.372  1.00 19.10           C  
ATOM    839  O   SER A 107       9.517   2.934  16.961  1.00  5.16           O  
ATOM    840  CB  SER A 107      10.549   5.339  17.193  1.00  4.37           C  
ATOM    841  OG  SER A 107      11.307   6.537  17.043  1.00 10.82           O  
ATOM    842  N   SER A 108       7.646   3.720  15.997  1.00 11.09           N  
ATOM    843  CA  SER A 108       6.900   2.518  16.320  1.00 12.59           C  
ATOM    844  C   SER A 108       7.418   1.174  15.804  1.00 12.19           C  
ATOM    845  O   SER A 108       7.258   0.150  16.487  1.00 11.63           O  
ATOM    846  CB  SER A 108       5.440   2.730  15.922  1.00 21.69           C  
ATOM    847  OG  SER A 108       5.031   3.999  16.404  1.00 12.37           O  
ATOM    848  N   VAL A 109       8.012   1.188  14.609  1.00 17.70           N  
ATOM    849  CA  VAL A 109       8.537  -0.024  13.975  1.00 10.16           C  
ATOM    850  C   VAL A 109       9.688  -0.582  14.764  1.00 13.21           C  
ATOM    851  O   VAL A 109      10.079  -1.734  14.537  1.00 12.62           O  
ATOM    852  CB  VAL A 109       9.090   0.286  12.597  1.00  5.14           C  
ATOM    853  CG1 VAL A 109       7.921   0.598  11.636  1.00  1.00           C  
ATOM    854  CG2 VAL A 109       9.905   1.520  12.749  1.00 16.72           C  
ATOM    855  N   GLY A 110      10.217   0.233  15.679  1.00 17.15           N  
ATOM    856  CA  GLY A 110      11.343  -0.140  16.552  1.00  2.60           C  
ATOM    857  C   GLY A 110      10.850  -1.192  17.540  1.00 10.38           C  
ATOM    858  O   GLY A 110      11.637  -1.931  18.124  1.00 16.48           O  
ATOM    859  N   TYR A 111       9.533  -1.269  17.723  1.00 13.36           N  
ATOM    860  CA  TYR A 111       8.996  -2.263  18.643  1.00 13.00           C  
ATOM    861  C   TYR A 111       8.931  -3.643  17.983  1.00 16.77           C  
ATOM    862  O   TYR A 111       8.477  -4.622  18.583  1.00 31.90           O  
ATOM    863  CB  TYR A 111       7.629  -1.834  19.157  1.00 11.07           C  
ATOM    864  CG  TYR A 111       7.759  -0.720  20.197  1.00  5.07           C  
ATOM    865  CD1 TYR A 111       8.211  -0.970  21.518  1.00  9.94           C  
ATOM    866  CD2 TYR A 111       7.441   0.579  19.845  1.00 27.68           C  
ATOM    867  CE1 TYR A 111       8.343   0.099  22.451  1.00 19.31           C  
ATOM    868  CE2 TYR A 111       7.558   1.610  20.734  1.00 21.23           C  
ATOM    869  CZ  TYR A 111       7.994   1.381  22.028  1.00 35.14           C  
ATOM    870  OH  TYR A 111       8.061   2.513  22.805  1.00 36.08           O  
ATOM    871  N   LEU A 112       9.376  -3.689  16.731  1.00 23.68           N  
ATOM    872  CA  LEU A 112       9.415  -4.912  15.947  1.00 23.04           C  
ATOM    873  C   LEU A 112      10.753  -5.478  16.395  1.00 27.87           C  
ATOM    874  O   LEU A 112      11.772  -4.765  16.503  1.00  7.13           O  
ATOM    875  CB  LEU A 112       9.419  -4.600  14.459  1.00 11.85           C  
ATOM    876  CG  LEU A 112       8.038  -4.139  14.026  1.00  9.30           C  
ATOM    877  CD1 LEU A 112       8.109  -4.279  12.537  1.00 18.50           C  
ATOM    878  CD2 LEU A 112       6.902  -4.993  14.526  1.00  7.17           C  
ATOM    879  N   LYS A 113      10.693  -6.777  16.665  1.00  6.07           N  
ATOM    880  CA  LYS A 113      11.813  -7.557  17.168  1.00 19.16           C  
ATOM    881  C   LYS A 113      12.942  -8.089  16.312  1.00 36.10           C  
ATOM    882  O   LYS A 113      14.027  -8.291  16.820  1.00 14.57           O  
ATOM    883  CB  LYS A 113      11.309  -8.571  18.183  1.00 16.48           C  
ATOM    884  CG  LYS A 113      10.605  -7.877  19.371  1.00 26.34           C  
ATOM    885  CD  LYS A 113      10.270  -8.841  20.512  1.00 69.52           C  
ATOM    886  CE  LYS A 113      10.530  -8.211  21.886  1.00 99.75           C  
ATOM    887  NZ  LYS A 113      11.666  -8.808  22.663  1.00 80.32           N  
ATOM    888  N   THR A 114      12.710  -8.330  15.029  1.00 19.17           N  
ATOM    889  CA  THR A 114      13.778  -8.849  14.198  1.00 16.41           C  
ATOM    890  C   THR A 114      13.648  -8.281  12.807  1.00 18.47           C  
ATOM    891  O   THR A 114      12.615  -7.708  12.470  1.00 10.24           O  
ATOM    892  CB  THR A 114      13.597 -10.343  14.004  1.00 12.93           C  
ATOM    893  OG1 THR A 114      12.327 -10.570  13.394  1.00  5.49           O  
ATOM    894  CG2 THR A 114      13.641 -11.053  15.330  1.00 14.76           C  
ATOM    895  N   THR A 115      14.678  -8.441  11.986  1.00 15.13           N  
ATOM    896  CA  THR A 115      14.573  -7.906  10.639  1.00 29.33           C  
ATOM    897  C   THR A 115      13.469  -8.605   9.876  1.00 31.80           C  
ATOM    898  O   THR A 115      12.891  -8.027   8.963  1.00 15.14           O  
ATOM    899  CB  THR A 115      15.845  -8.146   9.832  1.00 44.76           C  
ATOM    900  OG1 THR A 115      16.224  -9.521   9.969  1.00 22.09           O  
ATOM    901  CG2 THR A 115      16.939  -7.187  10.275  1.00 19.51           C  
ATOM    902  N   GLU A 116      13.192  -9.849  10.237  1.00 10.12           N  
ATOM    903  CA  GLU A 116      12.144 -10.564   9.529  1.00 30.88           C  
ATOM    904  C   GLU A 116      10.821  -9.884   9.819  1.00 18.74           C  
ATOM    905  O   GLU A 116       9.941  -9.814   8.957  1.00 21.75           O  
ATOM    906  CB  GLU A 116      12.095 -12.032   9.946  1.00 25.33           C  
ATOM    907  CG  GLU A 116      13.235 -12.868   9.403  1.00 22.99           C  
ATOM    908  CD  GLU A 116      14.426 -12.903  10.345  1.00 99.75           C  
ATOM    909  OE1 GLU A 116      14.406 -12.268  11.422  1.00 20.89           O  
ATOM    910  OE2 GLU A 116      15.390 -13.612  10.010  1.00 34.81           O  
ATOM    911  N   GLU A 117      10.661  -9.378  11.032  1.00 17.48           N  
ATOM    912  CA  GLU A 117       9.396  -8.708  11.343  1.00 26.81           C  
ATOM    913  C   GLU A 117       9.339  -7.349  10.668  1.00  5.73           C  
ATOM    914  O   GLU A 117       8.304  -6.957  10.141  1.00 15.46           O  
ATOM    915  CB  GLU A 117       9.187  -8.472  12.831  1.00  3.17           C  
ATOM    916  CG  GLU A 117       8.985  -9.753  13.585  1.00 10.03           C  
ATOM    917  CD  GLU A 117       8.917  -9.505  15.064  1.00 29.47           C  
ATOM    918  OE1 GLU A 117       8.813  -8.322  15.487  1.00 19.75           O  
ATOM    919  OE2 GLU A 117       9.001 -10.525  15.772  1.00 22.17           O  
ATOM    920  N   LEU A 118      10.459  -6.639  10.683  1.00 26.96           N  
ATOM    921  CA  LEU A 118      10.499  -5.323  10.055  1.00 11.19           C  
ATOM    922  C   LEU A 118      10.113  -5.523   8.598  1.00 12.45           C  
ATOM    923  O   LEU A 118       9.268  -4.833   8.036  1.00 15.41           O  
ATOM    924  CB  LEU A 118      11.921  -4.761  10.185  1.00  6.81           C  
ATOM    925  CG  LEU A 118      12.199  -3.351   9.662  1.00 10.87           C  
ATOM    926  CD1 LEU A 118      11.454  -2.355  10.575  1.00  9.28           C  
ATOM    927  CD2 LEU A 118      13.725  -3.164   9.763  1.00  1.00           C  
ATOM    928  N   GLY A 119      10.754  -6.495   7.969  1.00 27.79           N  
ATOM    929  CA  GLY A 119      10.466  -6.739   6.567  1.00  8.52           C  
ATOM    930  C   GLY A 119       9.006  -6.989   6.300  1.00  8.51           C  
ATOM    931  O   GLY A 119       8.409  -6.469   5.340  1.00 16.40           O  
ATOM    932  N   ALA A 120       8.422  -7.831   7.148  1.00  5.36           N  
ATOM    933  CA  ALA A 120       7.028  -8.151   6.970  1.00 10.65           C  
ATOM    934  C   ALA A 120       6.135  -6.924   7.146  1.00 23.59           C  
ATOM    935  O   ALA A 120       5.124  -6.768   6.456  1.00 12.96           O  
ATOM    936  CB  ALA A 120       6.630  -9.181   8.001  1.00  9.70           C  
ATOM    937  N   ALA A 121       6.499  -6.069   8.094  1.00  4.08           N  
ATOM    938  CA  ALA A 121       5.684  -4.879   8.360  1.00 14.67           C  
ATOM    939  C   ALA A 121       5.833  -3.919   7.208  1.00 19.05           C  
ATOM    940  O   ALA A 121       4.877  -3.230   6.842  1.00 10.71           O  
ATOM    941  CB  ALA A 121       6.100  -4.209   9.644  1.00  2.32           C  
ATOM    942  N   VAL A 122       7.031  -3.875   6.640  1.00  3.98           N  
ATOM    943  CA  VAL A 122       7.224  -2.951   5.531  1.00 13.62           C  
ATOM    944  C   VAL A 122       6.498  -3.471   4.294  1.00 16.32           C  
ATOM    945  O   VAL A 122       5.973  -2.712   3.469  1.00  9.12           O  
ATOM    946  CB  VAL A 122       8.726  -2.607   5.329  1.00  8.62           C  
ATOM    947  CG1 VAL A 122       8.946  -1.700   4.098  1.00 19.59           C  
ATOM    948  CG2 VAL A 122       9.272  -1.887   6.575  1.00  8.65           C  
ATOM    949  N   ALA A 123       6.448  -4.789   4.183  1.00 17.39           N  
ATOM    950  CA  ALA A 123       5.787  -5.389   3.025  1.00 14.68           C  
ATOM    951  C   ALA A 123       4.309  -5.042   3.110  1.00 17.24           C  
ATOM    952  O   ALA A 123       3.707  -4.669   2.105  1.00 12.09           O  
ATOM    953  CB  ALA A 123       6.030  -6.948   2.990  1.00 14.13           C  
ATOM    954  N   SER A 124       3.755  -5.155   4.317  1.00 17.69           N  
ATOM    955  CA  SER A 124       2.349  -4.855   4.561  1.00 18.90           C  
ATOM    956  C   SER A 124       2.059  -3.408   4.215  1.00  4.83           C  
ATOM    957  O   SER A 124       0.969  -3.075   3.683  1.00 10.45           O  
ATOM    958  CB  SER A 124       1.966  -5.087   6.020  1.00 10.22           C  
ATOM    959  OG  SER A 124       2.167  -6.433   6.425  1.00 11.75           O  
ATOM    960  N   PHE A 125       3.027  -2.547   4.517  1.00 11.55           N  
ATOM    961  CA  PHE A 125       2.816  -1.130   4.200  1.00  9.98           C  
ATOM    962  C   PHE A 125       2.703  -1.118   2.680  1.00 13.68           C  
ATOM    963  O   PHE A 125       1.725  -0.632   2.102  1.00 18.37           O  
ATOM    964  CB  PHE A 125       4.001  -0.260   4.640  1.00  7.08           C  
ATOM    965  CG  PHE A 125       4.249  -0.274   6.137  1.00  2.17           C  
ATOM    966  CD1 PHE A 125       3.411  -0.972   6.998  1.00  6.98           C  
ATOM    967  CD2 PHE A 125       5.339   0.401   6.674  1.00  7.46           C  
ATOM    968  CE1 PHE A 125       3.671  -1.020   8.377  1.00  9.97           C  
ATOM    969  CE2 PHE A 125       5.591   0.394   8.040  1.00  3.61           C  
ATOM    970  CZ  PHE A 125       4.753  -0.329   8.895  1.00 13.83           C  
ATOM    971  N   ALA A 126       3.715  -1.667   2.019  1.00 21.95           N  
ATOM    972  CA  ALA A 126       3.679  -1.713   0.560  1.00 16.62           C  
ATOM    973  C   ALA A 126       2.352  -2.268   0.039  1.00  3.10           C  
ATOM    974  O   ALA A 126       1.786  -1.780  -0.954  1.00 11.69           O  
ATOM    975  CB  ALA A 126       4.804  -2.588   0.026  1.00 15.43           C  
ATOM    976  N   GLU A 127       1.859  -3.316   0.674  1.00 25.67           N  
ATOM    977  CA  GLU A 127       0.617  -3.892   0.179  1.00 31.30           C  
ATOM    978  C   GLU A 127      -0.625  -3.000   0.195  1.00 26.70           C  
ATOM    979  O   GLU A 127      -1.570  -3.264  -0.543  1.00 15.54           O  
ATOM    980  CB  GLU A 127       0.338  -5.227   0.861  1.00 12.27           C  
ATOM    981  CG  GLU A 127       0.623  -6.430   0.004  1.00 54.01           C  
ATOM    982  CD  GLU A 127       1.949  -7.064   0.367  1.00 99.75           C  
ATOM    983  OE1 GLU A 127       1.981  -7.828   1.358  1.00 99.75           O  
ATOM    984  OE2 GLU A 127       2.953  -6.772  -0.329  1.00 99.75           O  
ATOM    985  N   HIS A 128      -0.640  -1.954   1.015  1.00 16.40           N  
ATOM    986  CA  HIS A 128      -1.809  -1.067   1.099  1.00  3.30           C  
ATOM    987  C   HIS A 128      -1.499   0.226   0.347  1.00 28.28           C  
ATOM    988  O   HIS A 128      -2.176   1.247   0.430  1.00 13.86           O  
ATOM    989  CB  HIS A 128      -2.083  -0.780   2.607  1.00  4.53           C  
ATOM    990  CG  HIS A 128      -2.522  -1.990   3.376  1.00 39.39           C  
ATOM    991  ND1 HIS A 128      -1.659  -3.002   3.749  1.00 21.47           N  
ATOM    992  CD2 HIS A 128      -3.744  -2.351   3.841  1.00 14.95           C  
ATOM    993  CE1 HIS A 128      -2.328  -3.926   4.422  1.00  7.02           C  
ATOM    994  NE2 HIS A 128      -3.596  -3.556   4.485  1.00 14.24           N  
ATOM    995  N   LEU A 129      -0.433   0.170  -0.424  1.00 11.69           N  
ATOM    996  CA  LEU A 129      -0.031   1.366  -1.141  1.00 15.91           C  
ATOM    997  C   LEU A 129      -0.591   1.545  -2.545  1.00 23.36           C  
ATOM    998  O   LEU A 129      -0.499   0.617  -3.354  1.00 25.24           O  
ATOM    999  CB  LEU A 129       1.511   1.442  -1.094  1.00 13.08           C  
ATOM   1000  CG  LEU A 129       2.098   2.839  -1.275  1.00 33.11           C  
ATOM   1001  CD1 LEU A 129       1.996   3.667   0.006  1.00  7.28           C  
ATOM   1002  CD2 LEU A 129       3.478   2.832  -1.916  1.00 14.14           C  
ATOM   1003  N   GLU A 130      -1.169   2.713  -2.844  1.00 20.21           N  
ATOM   1004  CA  GLU A 130      -1.664   2.886  -4.203  1.00  9.80           C  
ATOM   1005  C   GLU A 130      -0.459   3.018  -5.145  1.00 15.73           C  
ATOM   1006  O   GLU A 130       0.688   3.291  -4.760  1.00 11.46           O  
ATOM   1007  CB  GLU A 130      -2.549   4.111  -4.355  1.00  6.29           C  
ATOM   1008  CG  GLU A 130      -3.657   4.200  -3.351  1.00 10.75           C  
ATOM   1009  CD  GLU A 130      -4.356   5.484  -3.572  1.00 51.05           C  
ATOM   1010  OE1 GLU A 130      -3.625   6.360  -4.095  1.00 12.36           O  
ATOM   1011  OE2 GLU A 130      -5.568   5.573  -3.267  1.00 27.51           O  
ATOM   1012  N   PRO A 131      -0.730   2.845  -6.428  1.00 20.28           N  
ATOM   1013  CA  PRO A 131       0.327   2.972  -7.409  1.00 15.63           C  
ATOM   1014  C   PRO A 131       0.743   4.422  -7.257  1.00 18.42           C  
ATOM   1015  O   PRO A 131      -0.100   5.312  -7.095  1.00 13.48           O  
ATOM   1016  CB  PRO A 131      -0.435   2.853  -8.726  1.00 12.27           C  
ATOM   1017  CG  PRO A 131      -1.610   1.950  -8.394  1.00 44.22           C  
ATOM   1018  CD  PRO A 131      -1.810   1.964  -6.903  1.00 40.21           C  
ATOM   1019  N   GLY A 132       2.045   4.650  -7.331  1.00 12.83           N  
ATOM   1020  CA  GLY A 132       2.576   5.999  -7.214  1.00 22.10           C  
ATOM   1021  C   GLY A 132       2.471   6.557  -5.793  1.00 24.98           C  
ATOM   1022  O   GLY A 132       2.568   7.768  -5.571  1.00 10.24           O  
ATOM   1023  N   GLY A 133       2.267   5.661  -4.834  1.00  6.50           N  
ATOM   1024  CA  GLY A 133       2.143   6.083  -3.448  1.00 14.17           C  
ATOM   1025  C   GLY A 133       3.493   6.296  -2.771  1.00 13.15           C  
ATOM   1026  O   GLY A 133       4.556   6.258  -3.372  1.00 10.42           O  
ATOM   1027  N   VAL A 134       3.459   6.538  -1.479  1.00  3.82           N  
ATOM   1028  CA  VAL A 134       4.703   6.745  -0.793  1.00  1.54           C  
ATOM   1029  C   VAL A 134       4.545   6.275   0.645  1.00 32.31           C  
ATOM   1030  O   VAL A 134       3.473   6.463   1.234  1.00 17.83           O  
ATOM   1031  CB  VAL A 134       5.000   8.248  -0.762  1.00 12.67           C  
ATOM   1032  CG1 VAL A 134       3.804   9.028  -0.235  1.00 15.34           C  
ATOM   1033  CG2 VAL A 134       6.158   8.451   0.149  1.00  8.91           C  
ATOM   1034  N   VAL A 135       5.616   5.661   1.158  1.00  9.09           N  
ATOM   1035  CA  VAL A 135       5.704   5.132   2.515  1.00 10.98           C  
ATOM   1036  C   VAL A 135       6.713   5.977   3.288  1.00  8.13           C  
ATOM   1037  O   VAL A 135       7.797   6.254   2.786  1.00 15.75           O  
ATOM   1038  CB  VAL A 135       6.211   3.673   2.521  1.00 35.74           C  
ATOM   1039  CG1 VAL A 135       6.625   3.257   3.940  1.00 12.67           C  
ATOM   1040  CG2 VAL A 135       5.137   2.734   1.954  1.00  6.12           C  
ATOM   1041  N   VAL A 136       6.356   6.397   4.490  1.00 12.11           N  
ATOM   1042  CA  VAL A 136       7.217   7.226   5.324  1.00  9.39           C  
ATOM   1043  C   VAL A 136       7.289   6.576   6.681  1.00 20.99           C  
ATOM   1044  O   VAL A 136       6.242   6.414   7.310  1.00 15.49           O  
ATOM   1045  CB  VAL A 136       6.619   8.628   5.526  1.00 12.64           C  
ATOM   1046  CG1 VAL A 136       7.524   9.462   6.455  1.00  7.27           C  
ATOM   1047  CG2 VAL A 136       6.423   9.312   4.156  1.00  7.05           C  
ATOM   1048  N   VAL A 137       8.495   6.206   7.114  1.00  6.06           N  
ATOM   1049  CA  VAL A 137       8.688   5.563   8.414  1.00  7.17           C  
ATOM   1050  C   VAL A 137       9.692   6.325   9.273  1.00  6.25           C  
ATOM   1051  O   VAL A 137      10.793   6.655   8.830  1.00 12.84           O  
ATOM   1052  CB  VAL A 137       9.136   4.103   8.260  1.00 10.72           C  
ATOM   1053  CG1 VAL A 137       9.541   3.499   9.626  1.00  7.82           C  
ATOM   1054  CG2 VAL A 137       8.037   3.283   7.569  1.00  2.44           C  
ATOM   1055  N   GLU A 138       9.301   6.647  10.493  1.00 11.22           N  
ATOM   1056  CA  GLU A 138      10.218   7.374  11.384  1.00  5.50           C  
ATOM   1057  C   GLU A 138      10.707   6.216  12.236  1.00 42.06           C  
ATOM   1058  O   GLU A 138       9.937   5.610  12.967  1.00  4.20           O  
ATOM   1059  CB  GLU A 138       9.482   8.351  12.306  1.00  3.68           C  
ATOM   1060  CG  GLU A 138      10.500   9.079  13.209  1.00 15.53           C  
ATOM   1061  CD  GLU A 138       9.876  10.199  14.064  1.00 18.31           C  
ATOM   1062  OE1 GLU A 138       8.624  10.276  14.152  1.00 19.47           O  
ATOM   1063  OE2 GLU A 138      10.649  10.971  14.678  1.00  5.89           O  
ATOM   1064  N   PRO A 139      11.981   5.881  12.113  1.00 21.74           N  
ATOM   1065  CA  PRO A 139      12.579   4.775  12.855  1.00 19.71           C  
ATOM   1066  C   PRO A 139      13.054   5.187  14.256  1.00  9.96           C  
ATOM   1067  O   PRO A 139      12.950   6.360  14.677  1.00  7.20           O  
ATOM   1068  CB  PRO A 139      13.840   4.473  12.009  1.00 12.94           C  
ATOM   1069  CG  PRO A 139      14.254   5.847  11.445  1.00 10.23           C  
ATOM   1070  CD  PRO A 139      12.971   6.682  11.377  1.00  5.10           C  
ATOM   1071  N   TRP A 140      13.595   4.191  14.956  1.00  9.09           N  
ATOM   1072  CA  TRP A 140      14.149   4.369  16.287  1.00 13.27           C  
ATOM   1073  C   TRP A 140      15.613   4.624  15.916  1.00 36.80           C  
ATOM   1074  O   TRP A 140      15.939   4.592  14.748  1.00 12.87           O  
ATOM   1075  CB  TRP A 140      14.090   3.045  17.049  1.00 15.65           C  
ATOM   1076  CG  TRP A 140      14.765   3.119  18.412  1.00 16.71           C  
ATOM   1077  CD1 TRP A 140      15.734   2.282  18.899  1.00  2.08           C  
ATOM   1078  CD2 TRP A 140      14.538   4.096  19.426  1.00 12.81           C  
ATOM   1079  NE1 TRP A 140      16.095   2.643  20.176  1.00  8.55           N  
ATOM   1080  CE2 TRP A 140      15.392   3.771  20.518  1.00 23.42           C  
ATOM   1081  CE3 TRP A 140      13.677   5.206  19.534  1.00  2.48           C  
ATOM   1082  CZ2 TRP A 140      15.424   4.524  21.703  1.00 11.19           C  
ATOM   1083  CZ3 TRP A 140      13.712   5.955  20.726  1.00  9.11           C  
ATOM   1084  CH2 TRP A 140      14.576   5.606  21.790  1.00 18.95           C  
ATOM   1085  N   TRP A 141      16.498   4.865  16.875  1.00 10.37           N  
ATOM   1086  CA  TRP A 141      17.910   5.119  16.645  1.00 12.48           C  
ATOM   1087  C   TRP A 141      18.609   3.916  16.025  1.00 34.17           C  
ATOM   1088  O   TRP A 141      18.074   2.799  16.037  1.00  8.78           O  
ATOM   1089  CB  TRP A 141      18.564   5.401  18.000  1.00 19.09           C  
ATOM   1090  CG  TRP A 141      18.101   6.703  18.551  1.00 17.61           C  
ATOM   1091  CD1 TRP A 141      17.189   6.898  19.528  1.00  3.33           C  
ATOM   1092  CD2 TRP A 141      18.553   8.005  18.150  1.00  3.60           C  
ATOM   1093  NE1 TRP A 141      17.028   8.251  19.773  1.00 14.21           N  
ATOM   1094  CE2 TRP A 141      17.858   8.948  18.933  1.00 12.41           C  
ATOM   1095  CE3 TRP A 141      19.470   8.455  17.197  1.00 25.13           C  
ATOM   1096  CZ2 TRP A 141      18.038  10.319  18.785  1.00  6.80           C  
ATOM   1097  CZ3 TRP A 141      19.663   9.816  17.064  1.00  9.59           C  
ATOM   1098  CH2 TRP A 141      18.949  10.731  17.852  1.00 18.36           C  
ATOM   1099  N   PHE A 142      19.806   4.143  15.480  1.00 17.29           N  
ATOM   1100  CA  PHE A 142      20.569   3.045  14.866  1.00 17.88           C  
ATOM   1101  C   PHE A 142      21.626   2.656  15.890  1.00 28.23           C  
ATOM   1102  O   PHE A 142      21.935   3.502  16.737  1.00 12.93           O  
ATOM   1103  CB  PHE A 142      21.325   3.530  13.625  1.00 24.13           C  
ATOM   1104  CG  PHE A 142      20.445   4.086  12.543  1.00  4.99           C  
ATOM   1105  CD1 PHE A 142      19.160   3.612  12.366  1.00  1.00           C  
ATOM   1106  CD2 PHE A 142      20.926   5.085  11.695  1.00  9.12           C  
ATOM   1107  CE1 PHE A 142      18.355   4.141  11.353  1.00 29.89           C  
ATOM   1108  CE2 PHE A 142      20.137   5.611  10.687  1.00  6.97           C  
ATOM   1109  CZ  PHE A 142      18.848   5.146  10.510  1.00 20.55           C  
ATOM   1110  N   PRO A 143      22.148   1.423  15.811  1.00 20.51           N  
ATOM   1111  CA  PRO A 143      23.186   0.960  16.735  1.00 13.75           C  
ATOM   1112  C   PRO A 143      24.270   2.031  16.771  1.00 12.38           C  
ATOM   1113  O   PRO A 143      24.748   2.401  17.835  1.00 12.73           O  
ATOM   1114  CB  PRO A 143      23.705  -0.315  16.072  1.00 15.03           C  
ATOM   1115  CG  PRO A 143      22.485  -0.854  15.444  1.00 20.70           C  
ATOM   1116  CD  PRO A 143      21.724   0.337  14.921  1.00  9.55           C  
ATOM   1117  N   GLU A 144      24.636   2.551  15.607  1.00 14.46           N  
ATOM   1118  CA  GLU A 144      25.665   3.584  15.523  1.00 19.14           C  
ATOM   1119  C   GLU A 144      25.339   4.958  16.070  1.00 27.91           C  
ATOM   1120  O   GLU A 144      26.251   5.769  16.271  1.00 22.19           O  
ATOM   1121  CB  GLU A 144      26.096   3.798  14.065  1.00 12.61           C  
ATOM   1122  CG  GLU A 144      26.536   2.530  13.322  1.00 18.23           C  
ATOM   1123  CD  GLU A 144      25.389   1.693  12.750  1.00 26.63           C  
ATOM   1124  OE1 GLU A 144      24.211   2.012  12.997  1.00 19.55           O  
ATOM   1125  OE2 GLU A 144      25.655   0.688  12.046  1.00 28.53           O  
ATOM   1126  N   THR A 145      24.062   5.262  16.281  1.00 18.34           N  
ATOM   1127  CA  THR A 145      23.717   6.605  16.770  1.00 19.20           C  
ATOM   1128  C   THR A 145      23.109   6.562  18.172  1.00 17.33           C  
ATOM   1129  O   THR A 145      22.799   7.611  18.744  1.00 26.92           O  
ATOM   1130  CB  THR A 145      22.724   7.308  15.780  1.00  7.20           C  
ATOM   1131  OG1 THR A 145      21.671   6.390  15.434  1.00 16.26           O  
ATOM   1132  CG2 THR A 145      23.476   7.598  14.480  1.00 10.61           C  
ATOM   1133  N   PHE A 146      22.941   5.347  18.700  1.00 13.30           N  
ATOM   1134  CA  PHE A 146      22.349   5.180  20.010  1.00 10.76           C  
ATOM   1135  C   PHE A 146      23.222   5.764  21.107  1.00 13.11           C  
ATOM   1136  O   PHE A 146      24.424   5.568  21.059  1.00 15.81           O  
ATOM   1137  CB  PHE A 146      22.178   3.696  20.299  1.00 12.38           C  
ATOM   1138  CG  PHE A 146      21.648   3.416  21.680  1.00 14.35           C  
ATOM   1139  CD1 PHE A 146      20.520   4.098  22.138  1.00  9.94           C  
ATOM   1140  CD2 PHE A 146      22.271   2.485  22.520  1.00 24.71           C  
ATOM   1141  CE1 PHE A 146      20.018   3.838  23.432  1.00 17.33           C  
ATOM   1142  CE2 PHE A 146      21.784   2.226  23.795  1.00 17.74           C  
ATOM   1143  CZ  PHE A 146      20.653   2.900  24.243  1.00 14.57           C  
ATOM   1144  N   ALA A 147      22.650   6.462  22.082  1.00  9.95           N  
ATOM   1145  CA  ALA A 147      23.458   7.022  23.179  1.00  7.61           C  
ATOM   1146  C   ALA A 147      23.122   6.162  24.408  1.00 26.47           C  
ATOM   1147  O   ALA A 147      22.092   6.330  25.072  1.00 13.54           O  
ATOM   1148  CB  ALA A 147      23.071   8.460  23.419  1.00  8.58           C  
ATOM   1149  N   ASP A 148      23.986   5.207  24.712  1.00  9.30           N  
ATOM   1150  CA  ASP A 148      23.740   4.303  25.834  1.00 10.48           C  
ATOM   1151  C   ASP A 148      23.802   5.001  27.187  1.00 29.05           C  
ATOM   1152  O   ASP A 148      24.588   5.925  27.375  1.00 11.22           O  
ATOM   1153  CB  ASP A 148      24.821   3.216  25.773  1.00 10.73           C  
ATOM   1154  CG  ASP A 148      24.412   1.938  26.442  1.00  6.88           C  
ATOM   1155  OD1 ASP A 148      23.270   1.821  26.971  1.00 13.25           O  
ATOM   1156  OD2 ASP A 148      25.309   1.068  26.434  1.00 15.93           O  
ATOM   1157  N   GLY A 149      22.991   4.581  28.147  1.00 10.84           N  
ATOM   1158  CA  GLY A 149      23.036   5.210  29.478  1.00 12.71           C  
ATOM   1159  C   GLY A 149      22.363   6.579  29.537  1.00 12.57           C  
ATOM   1160  O   GLY A 149      22.402   7.281  30.537  1.00 14.58           O  
ATOM   1161  N   TRP A 150      21.703   6.951  28.456  1.00  7.03           N  
ATOM   1162  CA  TRP A 150      21.018   8.236  28.391  1.00  9.49           C  
ATOM   1163  C   TRP A 150      19.930   8.428  29.434  1.00  8.58           C  
ATOM   1164  O   TRP A 150      19.031   7.593  29.585  1.00  7.84           O  
ATOM   1165  CB  TRP A 150      20.397   8.420  26.979  1.00  8.52           C  
ATOM   1166  CG  TRP A 150      19.748   9.772  26.740  1.00  6.58           C  
ATOM   1167  CD1 TRP A 150      18.501  10.182  27.147  1.00 15.39           C  
ATOM   1168  CD2 TRP A 150      20.303  10.883  26.029  1.00 11.79           C  
ATOM   1169  NE1 TRP A 150      18.256  11.479  26.748  1.00  6.21           N  
ATOM   1170  CE2 TRP A 150      19.347  11.929  26.065  1.00 14.23           C  
ATOM   1171  CE3 TRP A 150      21.519  11.106  25.381  1.00 17.64           C  
ATOM   1172  CZ2 TRP A 150      19.550  13.150  25.434  1.00 14.04           C  
ATOM   1173  CZ3 TRP A 150      21.735  12.344  24.796  1.00 11.49           C  
ATOM   1174  CH2 TRP A 150      20.759  13.339  24.817  1.00 13.60           C  
ATOM   1175  N   VAL A 151      19.987   9.554  30.138  1.00  7.48           N  
ATOM   1176  CA  VAL A 151      18.952   9.820  31.136  1.00  8.87           C  
ATOM   1177  C   VAL A 151      18.180  11.052  30.674  1.00 29.56           C  
ATOM   1178  O   VAL A 151      18.796  12.053  30.301  1.00  8.70           O  
ATOM   1179  CB  VAL A 151      19.554  10.221  32.518  1.00  6.81           C  
ATOM   1180  CG1 VAL A 151      18.413  10.715  33.419  1.00  6.16           C  
ATOM   1181  CG2 VAL A 151      20.299   9.037  33.141  1.00  3.65           C  
ATOM   1182  N   SER A 152      16.851  11.001  30.687  1.00  6.61           N  
ATOM   1183  CA  SER A 152      16.048  12.168  30.312  1.00  5.37           C  
ATOM   1184  C   SER A 152      15.299  12.447  31.600  1.00  1.66           C  
ATOM   1185  O   SER A 152      14.792  11.521  32.222  1.00 12.20           O  
ATOM   1186  CB  SER A 152      14.970  11.885  29.235  1.00  7.30           C  
ATOM   1187  OG  SER A 152      15.389  12.173  27.915  1.00 36.78           O  
ATOM   1188  N   ALA A 153      15.173  13.717  31.962  1.00 10.95           N  
ATOM   1189  CA  ALA A 153      14.427  14.093  33.160  1.00 10.52           C  
ATOM   1190  C   ALA A 153      13.732  15.424  32.856  1.00 38.28           C  
ATOM   1191  O   ALA A 153      14.383  16.413  32.551  1.00  5.45           O  
ATOM   1192  CB  ALA A 153      15.340  14.082  34.409  1.00  4.81           C  
ATOM   1193  N   ASP A 154      12.400  15.437  32.867  1.00  4.80           N  
ATOM   1194  CA  ASP A 154      11.689  16.658  32.576  1.00  3.91           C  
ATOM   1195  C   ASP A 154      10.480  16.831  33.440  1.00  3.07           C  
ATOM   1196  O   ASP A 154       9.858  15.851  33.863  1.00 10.89           O  
ATOM   1197  CB  ASP A 154      11.090  16.573  31.170  1.00  1.00           C  
ATOM   1198  CG  ASP A 154      12.169  16.471  30.092  1.00 15.84           C  
ATOM   1199  OD1 ASP A 154      12.839  17.480  29.809  1.00 17.08           O  
ATOM   1200  OD2 ASP A 154      12.413  15.373  29.570  1.00 12.46           O  
ATOM   1201  N   VAL A 155      10.116  18.095  33.630  1.00 11.10           N  
ATOM   1202  CA  VAL A 155       8.920  18.419  34.405  1.00  1.12           C  
ATOM   1203  C   VAL A 155       8.079  19.302  33.518  1.00 14.54           C  
ATOM   1204  O   VAL A 155       8.559  20.257  32.910  1.00 14.88           O  
ATOM   1205  CB  VAL A 155       9.244  19.238  35.659  1.00  7.69           C  
ATOM   1206  CG1 VAL A 155       7.942  19.906  36.188  1.00  6.10           C  
ATOM   1207  CG2 VAL A 155       9.923  18.329  36.670  1.00  5.49           C  
ATOM   1208  N   VAL A 156       6.812  18.934  33.459  1.00 14.80           N  
ATOM   1209  CA  VAL A 156       5.831  19.644  32.665  1.00  9.12           C  
ATOM   1210  C   VAL A 156       4.634  19.928  33.541  1.00  1.00           C  
ATOM   1211  O   VAL A 156       4.287  19.161  34.444  1.00 15.24           O  
ATOM   1212  CB  VAL A 156       5.282  18.782  31.511  1.00 11.56           C  
ATOM   1213  CG1 VAL A 156       4.233  19.557  30.785  1.00 28.28           C  
ATOM   1214  CG2 VAL A 156       6.388  18.459  30.525  1.00 14.90           C  
ATOM   1215  N   ARG A 157       4.001  21.054  33.266  1.00 20.84           N  
ATOM   1216  CA  ARG A 157       2.808  21.422  34.008  1.00 26.97           C  
ATOM   1217  C   ARG A 157       1.888  21.978  32.927  1.00 17.82           C  
ATOM   1218  O   ARG A 157       2.186  22.983  32.269  1.00 20.97           O  
ATOM   1219  CB  ARG A 157       3.059  22.379  35.175  1.00 16.95           C  
ATOM   1220  CG  ARG A 157       4.334  23.137  35.044  1.00 18.72           C  
ATOM   1221  CD  ARG A 157       4.967  23.531  36.369  1.00 41.00           C  
ATOM   1222  NE  ARG A 157       6.367  23.839  36.087  1.00 99.75           N  
ATOM   1223  CZ  ARG A 157       7.384  23.533  36.884  1.00 99.75           C  
ATOM   1224  NH1 ARG A 157       8.625  23.849  36.535  1.00 99.75           N  
ATOM   1225  NH2 ARG A 157       7.158  22.913  38.034  1.00 32.39           N  
ATOM   1226  N   ARG A 158       0.758  21.315  32.717  1.00 13.27           N  
ATOM   1227  CA  ARG A 158      -0.173  21.787  31.696  1.00 20.80           C  
ATOM   1228  C   ARG A 158      -1.549  21.482  32.262  1.00 21.17           C  
ATOM   1229  O   ARG A 158      -1.730  20.433  32.904  1.00 18.20           O  
ATOM   1230  CB  ARG A 158       0.093  21.041  30.390  1.00 39.79           C  
ATOM   1231  CG  ARG A 158      -0.384  21.680  29.095  1.00 15.03           C  
ATOM   1232  CD  ARG A 158      -0.300  20.558  28.044  1.00 27.39           C  
ATOM   1233  NE  ARG A 158      -0.660  20.882  26.664  1.00 38.06           N  
ATOM   1234  CZ  ARG A 158      -0.221  21.950  26.009  1.00 26.40           C  
ATOM   1235  NH1 ARG A 158      -0.598  22.151  24.755  1.00 59.87           N  
ATOM   1236  NH2 ARG A 158       0.584  22.817  26.618  1.00 26.31           N  
ATOM   1237  N   ASP A 159      -2.480  22.405  32.020  1.00 15.97           N  
ATOM   1238  CA  ASP A 159      -3.865  22.332  32.471  1.00  9.04           C  
ATOM   1239  C   ASP A 159      -3.951  22.023  33.940  1.00 24.82           C  
ATOM   1240  O   ASP A 159      -4.756  21.174  34.319  1.00 32.60           O  
ATOM   1241  CB  ASP A 159      -4.621  21.201  31.785  1.00 17.17           C  
ATOM   1242  CG  ASP A 159      -4.496  21.248  30.280  1.00 38.13           C  
ATOM   1243  OD1 ASP A 159      -4.438  22.357  29.718  1.00 21.45           O  
ATOM   1244  OD2 ASP A 159      -4.484  20.172  29.653  1.00 15.51           O  
ATOM   1245  N   GLY A 160      -3.142  22.685  34.760  1.00 23.46           N  
ATOM   1246  CA  GLY A 160      -3.155  22.463  36.205  1.00 14.54           C  
ATOM   1247  C   GLY A 160      -2.443  21.223  36.725  1.00 23.17           C  
ATOM   1248  O   GLY A 160      -2.239  21.109  37.939  1.00 31.36           O  
ATOM   1249  N   ARG A 161      -2.068  20.308  35.827  1.00 20.29           N  
ATOM   1250  CA  ARG A 161      -1.379  19.069  36.200  1.00 16.39           C  
ATOM   1251  C   ARG A 161       0.130  19.169  36.047  1.00 21.20           C  
ATOM   1252  O   ARG A 161       0.646  19.789  35.124  1.00 15.70           O  
ATOM   1253  CB  ARG A 161      -1.690  17.977  35.191  1.00 11.94           C  
ATOM   1254  CG  ARG A 161      -3.082  17.482  35.044  1.00 38.55           C  
ATOM   1255  CD  ARG A 161      -2.929  16.046  34.598  1.00 59.77           C  
ATOM   1256  NE  ARG A 161      -3.362  15.118  35.633  1.00 31.44           N  
ATOM   1257  CZ  ARG A 161      -3.622  13.839  35.397  1.00 45.13           C  
ATOM   1258  NH1 ARG A 161      -3.480  13.383  34.165  1.00 17.76           N  
ATOM   1259  NH2 ARG A 161      -4.063  13.050  36.378  1.00 25.22           N  
ATOM   1260  N   THR A 162       0.856  18.522  36.943  1.00  9.88           N  
ATOM   1261  CA  THR A 162       2.300  18.579  36.817  1.00  7.21           C  
ATOM   1262  C   THR A 162       2.706  17.134  36.606  1.00 18.72           C  
ATOM   1263  O   THR A 162       2.207  16.232  37.296  1.00 12.78           O  
ATOM   1264  CB  THR A 162       2.910  18.997  38.141  1.00  3.90           C  
ATOM   1265  OG1 THR A 162       2.504  20.327  38.389  1.00  8.62           O  
ATOM   1266  CG2 THR A 162       4.390  19.030  38.026  1.00 12.24           C  
ATOM   1267  N   VAL A 163       3.622  16.920  35.670  1.00 19.40           N  
ATOM   1268  CA  VAL A 163       4.115  15.569  35.385  1.00  5.83           C  
ATOM   1269  C   VAL A 163       5.647  15.590  35.362  1.00 22.35           C  
ATOM   1270  O   VAL A 163       6.231  16.401  34.636  1.00  6.55           O  
ATOM   1271  CB  VAL A 163       3.585  15.072  33.985  1.00  1.01           C  
ATOM   1272  CG1 VAL A 163       4.328  13.835  33.489  1.00  5.78           C  
ATOM   1273  CG2 VAL A 163       2.122  14.707  34.071  1.00  6.29           C  
ATOM   1274  N   ALA A 164       6.298  14.723  36.144  1.00 16.61           N  
ATOM   1275  CA  ALA A 164       7.763  14.647  36.133  1.00  1.00           C  
ATOM   1276  C   ALA A 164       8.055  13.341  35.437  1.00 11.46           C  
ATOM   1277  O   ALA A 164       7.375  12.349  35.667  1.00  9.69           O  
ATOM   1278  CB  ALA A 164       8.380  14.597  37.502  1.00  3.36           C  
ATOM   1279  N   ARG A 165       9.053  13.312  34.568  1.00  9.61           N  
ATOM   1280  CA  ARG A 165       9.286  12.055  33.886  1.00  4.95           C  
ATOM   1281  C   ARG A 165      10.766  11.972  33.739  1.00 10.76           C  
ATOM   1282  O   ARG A 165      11.416  12.972  33.405  1.00  5.92           O  
ATOM   1283  CB  ARG A 165       8.730  12.104  32.431  1.00 10.33           C  
ATOM   1284  CG  ARG A 165       8.837  10.807  31.557  1.00  7.01           C  
ATOM   1285  CD  ARG A 165       8.637  11.079  30.046  1.00  6.50           C  
ATOM   1286  NE  ARG A 165       9.017   9.910  29.264  1.00  7.76           N  
ATOM   1287  CZ  ARG A 165      10.151   9.762  28.566  1.00 19.85           C  
ATOM   1288  NH1 ARG A 165      11.066  10.721  28.482  1.00  9.25           N  
ATOM   1289  NH2 ARG A 165      10.376   8.629  27.917  1.00  4.30           N  
ATOM   1290  N   VAL A 166      11.241  10.752  33.973  1.00  9.53           N  
ATOM   1291  CA  VAL A 166      12.642  10.408  33.871  1.00  1.60           C  
ATOM   1292  C   VAL A 166      12.790   9.064  33.193  1.00 10.92           C  
ATOM   1293  O   VAL A 166      12.111   8.093  33.542  1.00  8.99           O  
ATOM   1294  CB  VAL A 166      13.178  10.189  35.283  1.00  7.15           C  
ATOM   1295  CG1 VAL A 166      14.687   9.748  35.292  1.00 10.60           C  
ATOM   1296  CG2 VAL A 166      12.964  11.440  36.095  1.00  1.00           C  
ATOM   1297  N   SER A 167      13.682   8.978  32.217  1.00 10.43           N  
ATOM   1298  CA  SER A 167      13.857   7.671  31.587  1.00 18.08           C  
ATOM   1299  C   SER A 167      15.348   7.437  31.595  1.00 18.15           C  
ATOM   1300  O   SER A 167      16.154   8.373  31.528  1.00 10.66           O  
ATOM   1301  CB  SER A 167      13.440   7.650  30.113  1.00  7.36           C  
ATOM   1302  OG  SER A 167      14.238   8.590  29.401  1.00  7.03           O  
ATOM   1303  N   HIS A 168      15.694   6.165  31.658  1.00  9.49           N  
ATOM   1304  CA  HIS A 168      17.094   5.764  31.618  1.00  3.81           C  
ATOM   1305  C   HIS A 168      17.132   4.714  30.511  1.00  6.32           C  
ATOM   1306  O   HIS A 168      16.300   3.812  30.511  1.00 10.75           O  
ATOM   1307  CB  HIS A 168      17.639   5.191  32.918  1.00  5.70           C  
ATOM   1308  CG  HIS A 168      19.091   4.834  32.801  1.00  8.09           C  
ATOM   1309  ND1 HIS A 168      19.558   3.562  33.050  1.00  7.24           N  
ATOM   1310  CD2 HIS A 168      20.167   5.576  32.427  1.00 12.17           C  
ATOM   1311  CE1 HIS A 168      20.869   3.536  32.848  1.00  1.80           C  
ATOM   1312  NE2 HIS A 168      21.263   4.745  32.465  1.00 10.98           N  
ATOM   1313  N   SER A 169      18.065   4.849  29.559  1.00  9.00           N  
ATOM   1314  CA  SER A 169      18.182   3.936  28.416  1.00 13.06           C  
ATOM   1315  C   SER A 169      19.537   3.219  28.410  1.00 13.54           C  
ATOM   1316  O   SER A 169      20.595   3.836  28.590  1.00 10.39           O  
ATOM   1317  CB  SER A 169      17.926   4.675  27.066  1.00  2.99           C  
ATOM   1318  OG  SER A 169      16.608   5.227  26.961  1.00  4.61           O  
ATOM   1319  N   VAL A 170      19.507   1.906  28.213  1.00 10.01           N  
ATOM   1320  CA  VAL A 170      20.729   1.128  28.209  1.00 24.66           C  
ATOM   1321  C   VAL A 170      20.587   0.082  27.128  1.00 88.22           C  
ATOM   1322  O   VAL A 170      19.564  -0.567  26.952  1.00  8.27           O  
ATOM   1323  CB  VAL A 170      21.011   0.363  29.553  1.00 25.98           C  
ATOM   1324  CG1 VAL A 170      20.839   1.216  30.780  1.00 14.69           C  
ATOM   1325  CG2 VAL A 170      20.227  -0.928  29.669  1.00 30.54           C  
ATOM   1326  N   ARG A 171      21.649  -0.108  26.382  1.00 10.72           N  
ATOM   1327  CA  ARG A 171      21.557  -1.117  25.343  1.00 20.99           C  
ATOM   1328  C   ARG A 171      21.543  -2.562  25.926  1.00 36.73           C  
ATOM   1329  O   ARG A 171      22.301  -2.929  26.813  1.00 17.11           O  
ATOM   1330  CB  ARG A 171      22.769  -0.927  24.439  1.00 20.32           C  
ATOM   1331  CG  ARG A 171      23.065  -2.101  23.539  1.00 24.46           C  
ATOM   1332  CD  ARG A 171      23.265  -1.564  22.143  1.00 13.50           C  
ATOM   1333  NE  ARG A 171      23.279  -2.644  21.153  1.00 18.25           N  
ATOM   1334  CZ  ARG A 171      24.003  -2.559  20.040  1.00 36.06           C  
ATOM   1335  NH1 ARG A 171      24.716  -1.457  19.840  1.00  5.38           N  
ATOM   1336  NH2 ARG A 171      24.034  -3.533  19.135  1.00 16.56           N  
ATOM   1337  N   GLU A 172      20.689  -3.394  25.365  0.50  3.05           N  
ATOM   1339  CA  GLU A 172      20.632  -4.762  25.817  0.50  1.00           C  
ATOM   1341  C   GLU A 172      20.466  -5.511  24.510  0.50  4.30           C  
ATOM   1343  O   GLU A 172      19.460  -5.366  23.813  0.50 31.29           O  
ATOM   1345  CB  GLU A 172      19.497  -4.948  26.807  0.50  3.79           C  
ATOM   1347  CG  GLU A 172      19.831  -4.231  28.087  0.50 15.95           C  
ATOM   1349  CD  GLU A 172      18.946  -4.698  29.201  0.50 99.75           C  
ATOM   1351  OE1 GLU A 172      18.036  -5.498  28.883  0.50  6.91           O  
ATOM   1353  OE2 GLU A 172      19.165  -4.248  30.347  0.50 17.40           O  
ATOM   1355  N   GLY A 173      21.499  -6.267  24.161  1.00 12.71           N  
ATOM   1356  CA  GLY A 173      21.476  -7.001  22.900  1.00  9.63           C  
ATOM   1357  C   GLY A 173      21.468  -5.929  21.806  1.00 14.03           C  
ATOM   1358  O   GLY A 173      22.190  -4.910  21.863  1.00  3.59           O  
ATOM   1359  N   ASN A 174      20.618  -6.165  20.809  1.00 17.94           N  
ATOM   1360  CA  ASN A 174      20.451  -5.229  19.701  1.00 16.45           C  
ATOM   1361  C   ASN A 174      19.213  -4.379  20.000  1.00  5.24           C  
ATOM   1362  O   ASN A 174      18.498  -4.029  19.077  1.00 13.49           O  
ATOM   1363  CB  ASN A 174      20.184  -5.931  18.374  1.00 25.65           C  
ATOM   1364  CG  ASN A 174      18.861  -6.675  18.390  1.00 99.75           C  
ATOM   1365  OD1 ASN A 174      18.229  -6.768  19.443  1.00 36.99           O  
ATOM   1366  ND2 ASN A 174      18.427  -7.187  17.239  1.00 99.75           N  
ATOM   1367  N   ALA A 175      18.963  -4.049  21.261  1.00  5.12           N  
ATOM   1368  CA  ALA A 175      17.803  -3.217  21.580  1.00  2.28           C  
ATOM   1369  C   ALA A 175      18.104  -2.215  22.694  1.00 23.94           C  
ATOM   1370  O   ALA A 175      19.086  -2.367  23.426  1.00 10.03           O  
ATOM   1371  CB  ALA A 175      16.573  -4.052  21.915  1.00  6.52           C  
ATOM   1372  N   THR A 176      17.256  -1.191  22.812  1.00  7.97           N  
ATOM   1373  CA  THR A 176      17.390  -0.184  23.860  1.00 10.18           C  
ATOM   1374  C   THR A 176      16.365  -0.610  24.898  1.00  8.17           C  
ATOM   1375  O   THR A 176      15.198  -0.867  24.562  1.00  4.40           O  
ATOM   1376  CB  THR A 176      16.879   1.216  23.429  1.00  5.01           C  
ATOM   1377  OG1 THR A 176      17.749   1.718  22.407  1.00 11.67           O  
ATOM   1378  CG2 THR A 176      16.863   2.176  24.675  1.00  5.98           C  
ATOM   1379  N   ARG A 177      16.789  -0.691  26.154  1.00 15.17           N  
ATOM   1380  CA  ARG A 177      15.854  -1.056  27.221  1.00  7.07           C  
ATOM   1381  C   ARG A 177      15.704   0.268  27.951  1.00 13.79           C  
ATOM   1382  O   ARG A 177      16.599   0.671  28.688  1.00  8.45           O  
ATOM   1383  CB  ARG A 177      16.357  -2.084  28.238  1.00 10.40           C  
ATOM   1384  CG  ARG A 177      15.264  -2.426  29.273  1.00 21.01           C  
ATOM   1385  CD  ARG A 177      15.859  -3.237  30.430  1.00 25.96           C  
ATOM   1386  NE  ARG A 177      14.964  -3.625  31.524  1.00 16.99           N  
ATOM   1387  CZ  ARG A 177      14.526  -2.832  32.505  1.00 22.21           C  
ATOM   1388  NH1 ARG A 177      14.874  -1.551  32.588  1.00 13.57           N  
ATOM   1389  NH2 ARG A 177      13.726  -3.341  33.432  1.00 16.85           N  
ATOM   1390  N   MET A 178      14.568   0.929  27.725  1.00 12.65           N  
ATOM   1391  CA  MET A 178      14.263   2.218  28.324  1.00  8.62           C  
ATOM   1392  C   MET A 178      13.259   2.083  29.480  1.00 16.20           C  
ATOM   1393  O   MET A 178      12.117   1.645  29.291  1.00 10.08           O  
ATOM   1394  CB  MET A 178      13.673   3.161  27.260  1.00  7.84           C  
ATOM   1395  CG  MET A 178      13.265   4.526  27.848  1.00 13.97           C  
ATOM   1396  SD  MET A 178      12.341   5.633  26.763  1.00  9.65           S  
ATOM   1397  CE  MET A 178      13.642   6.132  25.596  1.00  1.00           C  
ATOM   1398  N   GLU A 179      13.681   2.467  30.684  1.00  5.29           N  
ATOM   1399  CA  GLU A 179      12.757   2.390  31.798  1.00  6.05           C  
ATOM   1400  C   GLU A 179      12.376   3.837  32.097  1.00 19.96           C  
ATOM   1401  O   GLU A 179      13.221   4.724  32.229  1.00 10.57           O  
ATOM   1402  CB  GLU A 179      13.411   1.743  32.988  1.00  1.00           C  
ATOM   1403  CG  GLU A 179      12.536   1.737  34.148  1.00  6.16           C  
ATOM   1404  CD  GLU A 179      13.181   0.940  35.259  1.00 28.87           C  
ATOM   1405  OE1 GLU A 179      13.922  -0.017  34.932  1.00 21.36           O  
ATOM   1406  OE2 GLU A 179      12.983   1.326  36.430  1.00 15.91           O  
ATOM   1407  N   VAL A 180      11.068   4.037  32.186  1.00 15.25           N  
ATOM   1408  CA  VAL A 180      10.443   5.330  32.410  1.00 17.82           C  
ATOM   1409  C   VAL A 180       9.609   5.356  33.652  1.00 19.99           C  
ATOM   1410  O   VAL A 180       8.850   4.429  33.930  1.00  8.71           O  
ATOM   1411  CB  VAL A 180       9.468   5.647  31.243  1.00 11.61           C  
ATOM   1412  CG1 VAL A 180       9.037   7.091  31.271  1.00  1.03           C  
ATOM   1413  CG2 VAL A 180      10.173   5.429  29.946  1.00  6.54           C  
ATOM   1414  N   HIS A 181       9.803   6.459  34.365  1.00 15.69           N  
ATOM   1415  CA  HIS A 181       9.135   6.769  35.607  1.00  1.00           C  
ATOM   1416  C   HIS A 181       8.355   8.052  35.509  1.00  5.44           C  
ATOM   1417  O   HIS A 181       8.903   9.135  35.242  1.00 13.04           O  
ATOM   1418  CB  HIS A 181      10.179   6.827  36.726  1.00  1.00           C  
ATOM   1419  CG  HIS A 181      10.671   5.459  37.048  1.00 25.94           C  
ATOM   1420  ND1 HIS A 181      10.095   4.668  38.018  1.00  8.85           N  
ATOM   1421  CD2 HIS A 181      11.632   4.709  36.462  1.00  5.29           C  
ATOM   1422  CE1 HIS A 181      10.714   3.502  38.049  1.00  9.24           C  
ATOM   1423  NE2 HIS A 181      11.648   3.500  37.117  1.00 10.19           N  
ATOM   1424  N   PHE A 182       7.058   7.915  35.725  1.00 12.37           N  
ATOM   1425  CA  PHE A 182       6.208   9.093  35.647  1.00 12.60           C  
ATOM   1426  C   PHE A 182       5.706   9.448  37.011  1.00 99.75           C  
ATOM   1427  O   PHE A 182       5.239   8.597  37.764  1.00  1.26           O  
ATOM   1428  CB  PHE A 182       4.950   8.869  34.796  1.00 11.11           C  
ATOM   1429  CG  PHE A 182       5.174   9.022  33.312  1.00  4.32           C  
ATOM   1430  CD1 PHE A 182       5.135  10.277  32.709  1.00 24.14           C  
ATOM   1431  CD2 PHE A 182       5.430   7.902  32.535  1.00 12.18           C  
ATOM   1432  CE1 PHE A 182       5.338  10.418  31.325  1.00  8.52           C  
ATOM   1433  CE2 PHE A 182       5.658   8.024  31.162  1.00 10.01           C  
ATOM   1434  CZ  PHE A 182       5.608   9.285  30.557  1.00  8.92           C  
ATOM   1435  N   THR A 183       5.801  10.730  37.307  1.00  4.71           N  
ATOM   1436  CA  THR A 183       5.290  11.192  38.584  1.00 18.85           C  
ATOM   1437  C   THR A 183       4.273  12.243  38.214  1.00 20.00           C  
ATOM   1438  O   THR A 183       4.635  13.232  37.533  1.00  6.65           O  
ATOM   1439  CB  THR A 183       6.341  11.685  39.577  1.00  9.57           C  
ATOM   1440  OG1 THR A 183       7.143  10.543  39.916  1.00 10.11           O  
ATOM   1441  CG2 THR A 183       5.593  12.141  40.822  1.00  4.76           C  
ATOM   1442  N   VAL A 184       3.032  11.999  38.655  1.00  9.54           N  
ATOM   1443  CA  VAL A 184       1.914  12.918  38.364  1.00 14.30           C  
ATOM   1444  C   VAL A 184       1.173  13.533  39.549  1.00 15.55           C  
ATOM   1445  O   VAL A 184       0.720  12.836  40.454  1.00 13.16           O  
ATOM   1446  CB  VAL A 184       0.847  12.201  37.558  1.00 13.10           C  
ATOM   1447  CG1 VAL A 184      -0.275  13.174  37.108  1.00 19.09           C  
ATOM   1448  CG2 VAL A 184       1.505  11.364  36.467  1.00 15.69           C  
ATOM   1449  N   ALA A 185       1.048  14.848  39.538  1.00 10.80           N  
ATOM   1450  CA  ALA A 185       0.349  15.508  40.632  1.00  9.45           C  
ATOM   1451  C   ALA A 185      -0.696  16.523  40.188  1.00 14.30           C  
ATOM   1452  O   ALA A 185      -0.484  17.340  39.272  1.00 18.06           O  
ATOM   1453  CB  ALA A 185       1.326  16.140  41.581  1.00  3.44           C  
ATOM   1454  N   ASP A 186      -1.832  16.447  40.872  1.00 13.83           N  
ATOM   1455  CA  ASP A 186      -2.981  17.316  40.648  1.00 15.06           C  
ATOM   1456  C   ASP A 186      -3.243  17.957  41.983  1.00 35.48           C  
ATOM   1457  O   ASP A 186      -3.646  17.324  42.961  1.00 12.31           O  
ATOM   1458  CB  ASP A 186      -4.188  16.498  40.227  1.00 42.48           C  
ATOM   1459  CG  ASP A 186      -3.957  15.854  38.892  1.00 15.43           C  
ATOM   1460  OD1 ASP A 186      -3.399  16.572  38.038  1.00 41.09           O  
ATOM   1461  OD2 ASP A 186      -4.267  14.657  38.733  1.00 44.50           O  
ATOM   1462  N   PRO A 187      -2.983  19.247  41.999  1.00  9.60           N  
ATOM   1463  CA  PRO A 187      -3.157  20.020  43.210  1.00 10.61           C  
ATOM   1464  C   PRO A 187      -4.441  19.691  43.946  1.00 11.04           C  
ATOM   1465  O   PRO A 187      -5.497  19.582  43.332  1.00 29.68           O  
ATOM   1466  CB  PRO A 187      -3.151  21.466  42.699  1.00 15.53           C  
ATOM   1467  CG  PRO A 187      -2.212  21.401  41.487  1.00  6.17           C  
ATOM   1468  CD  PRO A 187      -2.368  20.014  40.897  1.00 13.70           C  
ATOM   1469  N   GLY A 188      -4.334  19.517  45.255  1.00  7.40           N  
ATOM   1470  CA  GLY A 188      -5.492  19.217  46.087  1.00 10.67           C  
ATOM   1471  C   GLY A 188      -6.116  17.876  45.743  1.00 34.14           C  
ATOM   1472  O   GLY A 188      -7.142  17.522  46.302  1.00 25.78           O  
ATOM   1473  N   LYS A 189      -5.534  17.107  44.831  1.00 16.81           N  
ATOM   1474  CA  LYS A 189      -6.159  15.826  44.530  1.00 21.03           C  
ATOM   1475  C   LYS A 189      -5.232  14.687  44.871  1.00 27.67           C  
ATOM   1476  O   LYS A 189      -5.639  13.694  45.450  1.00 19.13           O  
ATOM   1477  CB  LYS A 189      -6.723  15.797  43.123  1.00 21.50           C  
ATOM   1478  CG  LYS A 189      -7.643  17.010  42.976  1.00 28.69           C  
ATOM   1479  CD  LYS A 189      -7.691  17.554  41.538  1.00 39.25           C  
ATOM   1480  CE  LYS A 189      -8.916  17.042  40.747  1.00 99.75           C  
ATOM   1481  NZ  LYS A 189      -9.103  17.670  39.400  1.00 99.75           N  
ATOM   1482  N   GLY A 190      -3.960  14.846  44.551  1.00 13.31           N  
ATOM   1483  CA  GLY A 190      -3.029  13.783  44.884  1.00 16.97           C  
ATOM   1484  C   GLY A 190      -1.843  13.814  43.928  1.00  9.26           C  
ATOM   1485  O   GLY A 190      -1.763  14.692  43.041  1.00  6.96           O  
ATOM   1486  N   VAL A 191      -0.974  12.829  44.157  1.00 15.04           N  
ATOM   1487  CA  VAL A 191       0.254  12.580  43.422  1.00  5.17           C  
ATOM   1488  C   VAL A 191       0.286  11.077  43.263  1.00 28.34           C  
ATOM   1489  O   VAL A 191      -0.087  10.326  44.171  1.00 13.96           O  
ATOM   1490  CB  VAL A 191       1.473  13.067  44.176  1.00  8.58           C  
ATOM   1491  CG1 VAL A 191       1.365  12.736  45.683  1.00 18.98           C  
ATOM   1492  CG2 VAL A 191       2.729  12.518  43.518  1.00 13.88           C  
ATOM   1493  N   ARG A 192       0.712  10.662  42.074  1.00 15.46           N  
ATOM   1494  CA  ARG A 192       0.784   9.256  41.705  1.00 16.68           C  
ATOM   1495  C   ARG A 192       2.013   8.947  40.840  1.00  5.60           C  
ATOM   1496  O   ARG A 192       2.470   9.788  40.044  1.00 15.41           O  
ATOM   1497  CB  ARG A 192      -0.521   8.894  40.977  1.00 15.33           C  
ATOM   1498  CG  ARG A 192      -0.722   7.417  40.782  1.00 63.22           C  
ATOM   1499  CD  ARG A 192      -0.697   6.744  42.125  1.00 84.15           C  
ATOM   1500  NE  ARG A 192      -0.401   5.322  42.008  1.00 29.78           N  
ATOM   1501  CZ  ARG A 192      -1.225   4.402  41.501  1.00 99.75           C  
ATOM   1502  NH1 ARG A 192      -2.431   4.711  41.030  1.00 25.33           N  
ATOM   1503  NH2 ARG A 192      -0.829   3.135  41.457  1.00 99.75           N  
ATOM   1504  N   HIS A 193       2.555   7.741  41.005  1.00 20.90           N  
ATOM   1505  CA  HIS A 193       3.730   7.345  40.229  1.00 10.33           C  
ATOM   1506  C   HIS A 193       3.493   6.069  39.455  1.00 21.27           C  
ATOM   1507  O   HIS A 193       2.775   5.183  39.894  1.00 12.20           O  
ATOM   1508  CB  HIS A 193       4.981   7.102  41.152  1.00 12.80           C  
ATOM   1509  CG  HIS A 193       6.044   6.243  40.531  1.00 13.33           C  
ATOM   1510  ND1 HIS A 193       6.062   4.872  40.665  1.00  7.85           N  
ATOM   1511  CD2 HIS A 193       7.121   6.555  39.769  1.00  1.71           C  
ATOM   1512  CE1 HIS A 193       7.096   4.374  40.007  1.00  2.10           C  
ATOM   1513  NE2 HIS A 193       7.762   5.378  39.462  1.00 13.77           N  
ATOM   1514  N   PHE A 194       4.132   5.964  38.306  1.00  9.71           N  
ATOM   1515  CA  PHE A 194       4.010   4.737  37.539  1.00  2.88           C  
ATOM   1516  C   PHE A 194       5.233   4.657  36.619  1.00  6.56           C  
ATOM   1517  O   PHE A 194       5.854   5.667  36.251  1.00 13.14           O  
ATOM   1518  CB  PHE A 194       2.657   4.593  36.806  1.00  1.00           C  
ATOM   1519  CG  PHE A 194       2.491   5.461  35.584  1.00  5.77           C  
ATOM   1520  CD1 PHE A 194       2.832   4.999  34.331  1.00  4.40           C  
ATOM   1521  CD2 PHE A 194       1.944   6.725  35.688  1.00  1.80           C  
ATOM   1522  CE1 PHE A 194       2.655   5.810  33.219  1.00 15.71           C  
ATOM   1523  CE2 PHE A 194       1.729   7.530  34.578  1.00 11.54           C  
ATOM   1524  CZ  PHE A 194       2.105   7.075  33.343  1.00 17.83           C  
ATOM   1525  N   SER A 195       5.579   3.428  36.274  1.00  8.46           N  
ATOM   1526  CA  SER A 195       6.698   3.216  35.384  1.00 14.01           C  
ATOM   1527  C   SER A 195       6.354   2.212  34.276  1.00 23.22           C  
ATOM   1528  O   SER A 195       5.447   1.361  34.383  1.00  7.45           O  
ATOM   1529  CB  SER A 195       7.960   2.798  36.142  1.00  5.26           C  
ATOM   1530  OG  SER A 195       7.731   1.590  36.830  1.00 12.08           O  
ATOM   1531  N   ASP A 196       7.113   2.332  33.193  1.00 13.35           N  
ATOM   1532  CA  ASP A 196       6.969   1.472  32.022  1.00 17.54           C  
ATOM   1533  C   ASP A 196       8.375   1.074  31.561  1.00  6.65           C  
ATOM   1534  O   ASP A 196       9.335   1.827  31.743  1.00 10.69           O  
ATOM   1535  CB  ASP A 196       6.424   2.265  30.818  1.00  7.22           C  
ATOM   1536  CG  ASP A 196       5.003   2.787  30.994  1.00  7.14           C  
ATOM   1537  OD1 ASP A 196       4.069   2.053  31.345  1.00  9.05           O  
ATOM   1538  OD2 ASP A 196       4.805   3.973  30.739  1.00 13.33           O  
ATOM   1539  N   VAL A 197       8.485  -0.092  30.935  1.00  6.18           N  
ATOM   1540  CA  VAL A 197       9.779  -0.550  30.401  1.00  5.97           C  
ATOM   1541  C   VAL A 197       9.503  -0.816  28.928  1.00 10.43           C  
ATOM   1542  O   VAL A 197       8.562  -1.548  28.609  1.00 10.01           O  
ATOM   1543  CB  VAL A 197      10.265  -1.854  31.043  1.00  9.06           C  
ATOM   1544  CG1 VAL A 197      11.508  -2.418  30.321  1.00 14.24           C  
ATOM   1545  CG2 VAL A 197      10.557  -1.593  32.489  1.00  9.04           C  
ATOM   1546  N   HIS A 198      10.309  -0.209  28.055  1.00  5.68           N  
ATOM   1547  CA  HIS A 198      10.159  -0.360  26.601  1.00  5.53           C  
ATOM   1548  C   HIS A 198      11.402  -0.985  26.028  1.00 13.41           C  
ATOM   1549  O   HIS A 198      12.481  -0.608  26.426  1.00 15.11           O  
ATOM   1550  CB  HIS A 198      10.094   1.051  25.964  1.00  1.00           C  
ATOM   1551  CG  HIS A 198       8.988   1.905  26.516  1.00 14.06           C  
ATOM   1552  ND1 HIS A 198       7.727   1.924  25.967  1.00 23.33           N  
ATOM   1553  CD2 HIS A 198       8.942   2.745  27.578  1.00 20.32           C  
ATOM   1554  CE1 HIS A 198       6.955   2.746  26.650  1.00 26.19           C  
ATOM   1555  NE2 HIS A 198       7.668   3.259  27.632  1.00 10.22           N  
ATOM   1556  N   LEU A 199      11.253  -1.921  25.102  1.00 16.07           N  
ATOM   1557  CA  LEU A 199      12.401  -2.566  24.482  1.00 13.47           C  
ATOM   1558  C   LEU A 199      12.323  -2.146  23.025  1.00 27.96           C  
ATOM   1559  O   LEU A 199      11.441  -2.599  22.302  1.00 23.37           O  
ATOM   1560  CB  LEU A 199      12.289  -4.077  24.620  1.00 12.13           C  
ATOM   1561  CG  LEU A 199      12.624  -4.302  26.098  1.00 31.61           C  
ATOM   1562  CD1 LEU A 199      11.545  -5.053  26.859  1.00 99.75           C  
ATOM   1563  CD2 LEU A 199      13.985  -4.974  26.230  1.00 99.75           C  
ATOM   1564  N   ILE A 200      13.219  -1.268  22.600  1.00  5.71           N  
ATOM   1565  CA  ILE A 200      13.180  -0.792  21.216  1.00 12.58           C  
ATOM   1566  C   ILE A 200      14.406  -1.241  20.448  1.00  7.64           C  
ATOM   1567  O   ILE A 200      15.539  -0.874  20.766  1.00 10.33           O  
ATOM   1568  CB  ILE A 200      13.135   0.735  21.193  1.00  6.61           C  
ATOM   1569  CG1 ILE A 200      12.826   1.221  22.610  1.00 15.45           C  
ATOM   1570  CG2 ILE A 200      12.170   1.287  20.110  1.00  2.23           C  
ATOM   1571  CD1 ILE A 200      11.685   2.054  22.647  1.00 10.19           C  
ATOM   1572  N   THR A 201      14.152  -2.043  19.418  1.00 14.33           N  
ATOM   1573  CA  THR A 201      15.214  -2.597  18.576  1.00  9.79           C  
ATOM   1574  C   THR A 201      16.081  -1.550  17.890  1.00 10.93           C  
ATOM   1575  O   THR A 201      15.564  -0.564  17.367  1.00 10.56           O  
ATOM   1576  CB  THR A 201      14.603  -3.522  17.526  1.00 13.17           C  
ATOM   1577  OG1 THR A 201      13.699  -4.429  18.176  1.00  8.64           O  
ATOM   1578  CG2 THR A 201      15.694  -4.291  16.748  1.00  6.19           C  
ATOM   1579  N   LEU A 202      17.392  -1.786  17.885  1.00  6.11           N  
ATOM   1580  CA  LEU A 202      18.351  -0.899  17.241  1.00 17.96           C  
ATOM   1581  C   LEU A 202      18.649  -1.567  15.914  1.00 33.17           C  
ATOM   1582  O   LEU A 202      19.519  -2.436  15.811  1.00 10.00           O  
ATOM   1583  CB  LEU A 202      19.632  -0.815  18.070  1.00 14.71           C  
ATOM   1584  CG  LEU A 202      19.329  -0.171  19.436  1.00 17.95           C  
ATOM   1585  CD1 LEU A 202      20.389  -0.534  20.504  1.00 14.79           C  
ATOM   1586  CD2 LEU A 202      19.233   1.360  19.237  1.00  5.20           C  
ATOM   1587  N   PHE A 203      17.918  -1.189  14.876  1.00 11.97           N  
ATOM   1588  CA  PHE A 203      18.192  -1.821  13.583  1.00  9.08           C  
ATOM   1589  C   PHE A 203      19.216  -0.916  12.909  1.00 14.44           C  
ATOM   1590  O   PHE A 203      19.195   0.309  13.095  1.00 11.14           O  
ATOM   1591  CB  PHE A 203      16.952  -1.807  12.664  1.00  9.62           C  
ATOM   1592  CG  PHE A 203      15.868  -2.784  13.027  1.00  7.27           C  
ATOM   1593  CD1 PHE A 203      16.025  -4.147  12.775  1.00  2.89           C  
ATOM   1594  CD2 PHE A 203      14.689  -2.337  13.625  1.00  7.55           C  
ATOM   1595  CE1 PHE A 203      14.997  -5.045  13.109  1.00 18.22           C  
ATOM   1596  CE2 PHE A 203      13.649  -3.214  13.957  1.00  2.27           C  
ATOM   1597  CZ  PHE A 203      13.823  -4.590  13.684  1.00  7.88           C  
ATOM   1598  N   HIS A 204      20.127  -1.486  12.132  1.00 11.49           N  
ATOM   1599  CA  HIS A 204      21.078  -0.609  11.440  1.00  6.45           C  
ATOM   1600  C   HIS A 204      20.236   0.013  10.284  1.00 18.19           C  
ATOM   1601  O   HIS A 204      19.210  -0.541   9.834  1.00 18.20           O  
ATOM   1602  CB  HIS A 204      22.203  -1.465  10.774  1.00 10.07           C  
ATOM   1603  CG  HIS A 204      23.052  -2.162  11.776  1.00 10.71           C  
ATOM   1604  ND1 HIS A 204      24.158  -1.566  12.346  1.00 13.65           N  
ATOM   1605  CD2 HIS A 204      22.941  -3.389  12.345  1.00 16.90           C  
ATOM   1606  CE1 HIS A 204      24.701  -2.409  13.208  1.00  9.44           C  
ATOM   1607  NE2 HIS A 204      23.993  -3.526  13.215  1.00 15.32           N  
ATOM   1608  N   GLN A 205      20.662   1.164   9.781  1.00 11.49           N  
ATOM   1609  CA  GLN A 205      19.931   1.798   8.686  1.00 20.93           C  
ATOM   1610  C   GLN A 205      19.806   0.824   7.499  1.00 27.82           C  
ATOM   1611  O   GLN A 205      18.764   0.679   6.830  1.00 16.53           O  
ATOM   1612  CB  GLN A 205      20.731   3.033   8.289  1.00 10.95           C  
ATOM   1613  CG  GLN A 205      20.456   3.553   6.912  1.00 10.22           C  
ATOM   1614  CD  GLN A 205      21.182   4.854   6.653  1.00 16.46           C  
ATOM   1615  OE1 GLN A 205      21.951   5.316   7.490  1.00 26.42           O  
ATOM   1616  NE2 GLN A 205      20.961   5.442   5.475  1.00 23.65           N  
ATOM   1617  N   ALA A 206      20.896   0.112   7.233  1.00 13.07           N  
ATOM   1618  CA  ALA A 206      20.861  -0.825   6.118  1.00 11.04           C  
ATOM   1619  C   ALA A 206      19.808  -1.891   6.372  1.00 28.88           C  
ATOM   1620  O   ALA A 206      19.213  -2.420   5.433  1.00 15.03           O  
ATOM   1621  CB  ALA A 206      22.270  -1.435   5.871  1.00 12.01           C  
ATOM   1622  N   GLU A 207      19.559  -2.219   7.633  1.00  6.45           N  
ATOM   1623  CA  GLU A 207      18.537  -3.242   7.841  1.00 17.11           C  
ATOM   1624  C   GLU A 207      17.169  -2.689   7.436  1.00 22.69           C  
ATOM   1625  O   GLU A 207      16.342  -3.363   6.806  1.00 11.10           O  
ATOM   1626  CB  GLU A 207      18.591  -3.796   9.257  1.00  5.89           C  
ATOM   1627  CG  GLU A 207      19.838  -4.645   9.472  1.00  4.43           C  
ATOM   1628  CD  GLU A 207      19.979  -5.064  10.907  1.00 21.37           C  
ATOM   1629  OE1 GLU A 207      19.792  -4.222  11.799  1.00 10.89           O  
ATOM   1630  OE2 GLU A 207      20.221  -6.259  11.144  1.00 17.47           O  
ATOM   1631  N   TYR A 208      16.972  -1.426   7.785  1.00 17.38           N  
ATOM   1632  CA  TYR A 208      15.739  -0.720   7.464  1.00 28.01           C  
ATOM   1633  C   TYR A 208      15.560  -0.649   5.948  1.00 34.70           C  
ATOM   1634  O   TYR A 208      14.483  -0.922   5.400  1.00  8.89           O  
ATOM   1635  CB  TYR A 208      15.891   0.713   7.959  1.00 24.94           C  
ATOM   1636  CG  TYR A 208      15.451   0.902   9.394  1.00 20.63           C  
ATOM   1637  CD1 TYR A 208      14.117   0.748   9.747  1.00 28.45           C  
ATOM   1638  CD2 TYR A 208      16.374   1.232  10.386  1.00 16.49           C  
ATOM   1639  CE1 TYR A 208      13.710   0.924  11.064  1.00 32.57           C  
ATOM   1640  CE2 TYR A 208      15.981   1.414  11.701  1.00  6.92           C  
ATOM   1641  CZ  TYR A 208      14.643   1.256  12.031  1.00 35.77           C  
ATOM   1642  OH  TYR A 208      14.222   1.414  13.324  1.00 11.02           O  
ATOM   1643  N   GLU A 209      16.634  -0.261   5.271  1.00 18.84           N  
ATOM   1644  CA  GLU A 209      16.566  -0.140   3.823  1.00 18.21           C  
ATOM   1645  C   GLU A 209      16.304  -1.482   3.154  1.00  5.21           C  
ATOM   1646  O   GLU A 209      15.576  -1.605   2.171  1.00 16.73           O  
ATOM   1647  CB  GLU A 209      17.793   0.584   3.290  1.00 18.36           C  
ATOM   1648  CG  GLU A 209      17.822   2.027   3.755  1.00  8.94           C  
ATOM   1649  CD  GLU A 209      19.076   2.751   3.306  1.00 46.71           C  
ATOM   1650  OE1 GLU A 209      19.932   2.069   2.707  1.00 55.45           O  
ATOM   1651  OE2 GLU A 209      19.216   3.972   3.556  1.00 28.45           O  
ATOM   1652  N   ALA A 210      16.894  -2.512   3.724  1.00 17.47           N  
ATOM   1653  CA  ALA A 210      16.690  -3.827   3.159  1.00 22.75           C  
ATOM   1654  C   ALA A 210      15.210  -4.175   3.216  1.00 15.41           C  
ATOM   1655  O   ALA A 210      14.687  -4.722   2.257  1.00 12.60           O  
ATOM   1656  CB  ALA A 210      17.541  -4.857   3.873  1.00 26.47           C  
ATOM   1657  N   ALA A 211      14.545  -3.861   4.328  1.00 17.37           N  
ATOM   1658  CA  ALA A 211      13.132  -4.163   4.489  1.00 12.75           C  
ATOM   1659  C   ALA A 211      12.283  -3.464   3.427  1.00 34.32           C  
ATOM   1660  O   ALA A 211      11.289  -4.011   2.935  1.00 15.07           O  
ATOM   1661  CB  ALA A 211      12.655  -3.914   5.917  1.00  7.97           C  
ATOM   1662  N   PHE A 212      12.700  -2.260   3.055  1.00  8.63           N  
ATOM   1663  CA  PHE A 212      12.013  -1.493   2.023  1.00 10.43           C  
ATOM   1664  C   PHE A 212      12.328  -2.156   0.666  1.00 10.99           C  
ATOM   1665  O   PHE A 212      11.470  -2.376  -0.177  1.00 10.07           O  
ATOM   1666  CB  PHE A 212      12.559  -0.067   2.031  1.00  1.47           C  
ATOM   1667  CG  PHE A 212      11.755   0.901   2.883  1.00 14.27           C  
ATOM   1668  CD1 PHE A 212      11.853   0.905   4.272  1.00 21.46           C  
ATOM   1669  CD2 PHE A 212      10.907   1.845   2.289  1.00 18.80           C  
ATOM   1670  CE1 PHE A 212      11.109   1.822   5.071  1.00  4.93           C  
ATOM   1671  CE2 PHE A 212      10.139   2.759   3.056  1.00  9.84           C  
ATOM   1672  CZ  PHE A 212      10.238   2.756   4.460  1.00  3.93           C  
ATOM   1673  N   THR A 213      13.577  -2.512   0.428  1.00 11.22           N  
ATOM   1674  CA  THR A 213      13.857  -3.139  -0.845  1.00 15.71           C  
ATOM   1675  C   THR A 213      13.112  -4.440  -1.018  1.00 11.81           C  
ATOM   1676  O   THR A 213      12.563  -4.739  -2.083  1.00 16.03           O  
ATOM   1677  CB  THR A 213      15.351  -3.417  -0.996  1.00 22.52           C  
ATOM   1678  OG1 THR A 213      16.025  -2.154  -1.049  1.00 23.92           O  
ATOM   1679  CG2 THR A 213      15.614  -4.092  -2.329  1.00 16.90           C  
ATOM   1680  N   ALA A 214      13.094  -5.255   0.021  1.00  7.25           N  
ATOM   1681  CA  ALA A 214      12.396  -6.521  -0.139  1.00  9.65           C  
ATOM   1682  C   ALA A 214      10.926  -6.343  -0.412  1.00 18.95           C  
ATOM   1683  O   ALA A 214      10.304  -7.216  -1.001  1.00 26.48           O  
ATOM   1684  CB  ALA A 214      12.565  -7.399   1.080  1.00  8.60           C  
ATOM   1685  N   ALA A 215      10.367  -5.224   0.029  1.00 22.15           N  
ATOM   1686  CA  ALA A 215       8.952  -4.980  -0.170  1.00 14.03           C  
ATOM   1687  C   ALA A 215       8.712  -4.349  -1.543  1.00 11.41           C  
ATOM   1688  O   ALA A 215       7.600  -3.919  -1.825  1.00 18.65           O  
ATOM   1689  CB  ALA A 215       8.477  -4.020   0.904  1.00  6.84           C  
ATOM   1690  N   GLY A 216       9.747  -4.259  -2.372  1.00 18.87           N  
ATOM   1691  CA  GLY A 216       9.626  -3.665  -3.696  1.00 18.43           C  
ATOM   1692  C   GLY A 216       9.615  -2.142  -3.684  1.00 26.08           C  
ATOM   1693  O   GLY A 216       9.150  -1.519  -4.643  1.00 14.68           O  
ATOM   1694  N   LEU A 217      10.130  -1.543  -2.612  1.00 20.82           N  
ATOM   1695  CA  LEU A 217      10.155  -0.091  -2.500  1.00 13.60           C  
ATOM   1696  C   LEU A 217      11.538   0.480  -2.662  1.00 25.57           C  
ATOM   1697  O   LEU A 217      12.467  -0.087  -2.112  1.00 20.76           O  
ATOM   1698  CB  LEU A 217       9.693   0.362  -1.105  1.00  8.03           C  
ATOM   1699  CG  LEU A 217       8.295  -0.098  -0.684  1.00  7.36           C  
ATOM   1700  CD1 LEU A 217       8.074   0.240   0.801  1.00  9.44           C  
ATOM   1701  CD2 LEU A 217       7.221   0.623  -1.533  1.00 31.24           C  
ATOM   1702  N   ARG A 218      11.654   1.594  -3.380  1.00 17.06           N  
ATOM   1703  CA  ARG A 218      12.935   2.250  -3.556  1.00 14.08           C  
ATOM   1704  C   ARG A 218      12.894   3.115  -2.298  1.00 17.78           C  
ATOM   1705  O   ARG A 218      11.888   3.732  -1.996  1.00 15.11           O  
ATOM   1706  CB  ARG A 218      12.868   3.119  -4.804  1.00  9.23           C  
ATOM   1707  CG  ARG A 218      13.725   4.370  -4.758  1.00 15.43           C  
ATOM   1708  CD  ARG A 218      14.075   4.787  -6.198  1.00 18.49           C  
ATOM   1709  NE  ARG A 218      12.918   5.303  -6.931  1.00 45.15           N  
ATOM   1710  CZ  ARG A 218      12.536   6.578  -6.960  1.00 34.83           C  
ATOM   1711  NH1 ARG A 218      13.237   7.485  -6.292  1.00 62.01           N  
ATOM   1712  NH2 ARG A 218      11.465   6.947  -7.666  1.00 42.00           N  
ATOM   1713  N   VAL A 219      13.977   3.170  -1.542  1.00 15.99           N  
ATOM   1714  CA  VAL A 219      13.962   3.956  -0.325  1.00  9.41           C  
ATOM   1715  C   VAL A 219      15.089   4.972  -0.173  1.00 29.84           C  
ATOM   1716  O   VAL A 219      16.173   4.825  -0.735  1.00 19.69           O  
ATOM   1717  CB  VAL A 219      14.079   2.986   0.863  1.00 16.85           C  
ATOM   1718  CG1 VAL A 219      15.362   2.130   0.753  1.00 16.98           C  
ATOM   1719  CG2 VAL A 219      14.020   3.766   2.165  1.00 16.37           C  
ATOM   1720  N   GLU A 220      14.845   6.014   0.604  1.00 25.95           N  
ATOM   1721  CA  GLU A 220      15.900   6.997   0.830  1.00 14.70           C  
ATOM   1722  C   GLU A 220      15.822   7.425   2.305  1.00 24.47           C  
ATOM   1723  O   GLU A 220      14.725   7.529   2.838  1.00 13.12           O  
ATOM   1724  CB  GLU A 220      15.898   8.116  -0.212  1.00 14.52           C  
ATOM   1725  CG  GLU A 220      15.107   9.346   0.100  1.00 22.68           C  
ATOM   1726  CD  GLU A 220      15.570  10.495  -0.771  1.00 99.75           C  
ATOM   1727  OE1 GLU A 220      16.424  11.302  -0.332  1.00 33.90           O  
ATOM   1728  OE2 GLU A 220      15.093  10.561  -1.918  1.00 99.75           O  
ATOM   1729  N   TYR A 221      16.955   7.637   2.974  1.00 11.63           N  
ATOM   1730  CA  TYR A 221      16.935   8.031   4.381  1.00 11.16           C  
ATOM   1731  C   TYR A 221      17.170   9.507   4.466  1.00 21.74           C  
ATOM   1732  O   TYR A 221      18.019  10.044   3.756  1.00 24.25           O  
ATOM   1733  CB  TYR A 221      18.019   7.305   5.173  1.00  7.84           C  
ATOM   1734  CG  TYR A 221      18.148   7.757   6.618  1.00 12.91           C  
ATOM   1735  CD1 TYR A 221      17.136   7.474   7.554  1.00 18.98           C  
ATOM   1736  CD2 TYR A 221      19.297   8.411   7.064  1.00 26.39           C  
ATOM   1737  CE1 TYR A 221      17.241   7.851   8.889  1.00  3.71           C  
ATOM   1738  CE2 TYR A 221      19.410   8.806   8.404  1.00 21.79           C  
ATOM   1739  CZ  TYR A 221      18.380   8.518   9.313  1.00  6.26           C  
ATOM   1740  OH  TYR A 221      18.531   8.911  10.633  1.00 15.76           O  
ATOM   1741  N   LEU A 222      16.387  10.150   5.323  1.00 43.89           N  
ATOM   1742  CA  LEU A 222      16.473  11.585   5.529  1.00 12.78           C  
ATOM   1743  C   LEU A 222      16.891  11.867   6.973  1.00 10.49           C  
ATOM   1744  O   LEU A 222      16.212  11.432   7.901  1.00 33.67           O  
ATOM   1745  CB  LEU A 222      15.146  12.264   5.189  1.00 36.41           C  
ATOM   1746  CG  LEU A 222      14.657  12.059   3.746  1.00 43.01           C  
ATOM   1747  CD1 LEU A 222      13.186  12.438   3.622  1.00 53.98           C  
ATOM   1748  CD2 LEU A 222      15.473  12.829   2.708  1.00 33.85           C  
ATOM   1749  N   GLU A 223      18.007  12.581   7.131  1.00  9.10           N  
ATOM   1750  CA  GLU A 223      18.557  12.936   8.448  1.00 28.44           C  
ATOM   1751  C   GLU A 223      17.665  13.941   9.102  1.00 13.75           C  
ATOM   1752  O   GLU A 223      17.042  14.739   8.410  1.00 20.17           O  
ATOM   1753  CB  GLU A 223      19.874  13.729   8.347  1.00 15.94           C  
ATOM   1754  CG  GLU A 223      20.970  13.120   7.501  1.00 28.89           C  
ATOM   1755  CD  GLU A 223      21.697  11.993   8.198  1.00 99.75           C  
ATOM   1756  OE1 GLU A 223      21.780  12.028   9.445  1.00 96.81           O  
ATOM   1757  OE2 GLU A 223      22.185  11.085   7.492  1.00 42.90           O  
ATOM   1758  N   GLY A 224      17.638  13.926  10.425  1.00 23.19           N  
ATOM   1759  CA  GLY A 224      16.846  14.868  11.204  1.00 31.60           C  
ATOM   1760  C   GLY A 224      15.542  14.252  11.637  1.00 16.40           C  
ATOM   1761  O   GLY A 224      15.476  13.516  12.632  1.00 21.95           O  
ATOM   1762  N   GLY A 225      14.517  14.564  10.858  1.00 25.22           N  
ATOM   1763  CA  GLY A 225      13.175  14.059  11.108  1.00 20.59           C  
ATOM   1764  C   GLY A 225      12.634  14.742  12.360  1.00 44.95           C  
ATOM   1765  O   GLY A 225      13.323  15.486  13.059  1.00 26.41           O  
ATOM   1766  N   PRO A 226      11.368  14.477  12.638  1.00 51.33           N  
ATOM   1767  CA  PRO A 226      10.710  15.063  13.797  1.00  8.59           C  
ATOM   1768  C   PRO A 226      11.452  14.924  15.116  1.00 21.73           C  
ATOM   1769  O   PRO A 226      11.358  15.819  15.942  1.00 16.67           O  
ATOM   1770  CB  PRO A 226       9.403  14.256  13.911  1.00 17.83           C  
ATOM   1771  CG  PRO A 226       9.139  13.754  12.546  1.00 22.92           C  
ATOM   1772  CD  PRO A 226      10.519  13.496  11.940  1.00 20.02           C  
ATOM   1773  N   SER A 227      12.148  13.804  15.329  1.00 16.15           N  
ATOM   1774  CA  SER A 227      12.850  13.576  16.592  1.00  7.87           C  
ATOM   1775  C   SER A 227      14.358  13.412  16.511  1.00 28.97           C  
ATOM   1776  O   SER A 227      14.988  12.969  17.473  1.00 18.78           O  
ATOM   1777  CB  SER A 227      12.283  12.301  17.233  1.00 29.79           C  
ATOM   1778  OG  SER A 227      10.912  12.118  16.902  1.00 20.60           O  
ATOM   1779  N   GLY A 228      14.962  13.744  15.382  1.00  9.54           N  
ATOM   1780  CA  GLY A 228      16.411  13.575  15.313  1.00 11.78           C  
ATOM   1781  C   GLY A 228      16.797  12.134  14.954  1.00 13.81           C  
ATOM   1782  O   GLY A 228      17.963  11.741  14.942  1.00 23.44           O  
ATOM   1783  N   ARG A 229      15.813  11.321  14.635  1.00  3.74           N  
ATOM   1784  CA  ARG A 229      16.135   9.945  14.260  1.00 14.07           C  
ATOM   1785  C   ARG A 229      16.065   9.817  12.732  1.00 14.42           C  
ATOM   1786  O   ARG A 229      16.292   8.749  12.182  1.00 11.46           O  
ATOM   1787  CB  ARG A 229      15.144   8.997  14.953  1.00  6.12           C  
ATOM   1788  CG  ARG A 229      15.386   8.909  16.425  1.00 11.82           C  
ATOM   1789  CD  ARG A 229      14.141   8.492  17.144  1.00  6.66           C  
ATOM   1790  NE  ARG A 229      14.133   9.071  18.477  1.00 16.47           N  
ATOM   1791  CZ  ARG A 229      13.126   9.011  19.344  1.00 48.88           C  
ATOM   1792  NH1 ARG A 229      11.979   8.396  19.040  1.00 21.50           N  
ATOM   1793  NH2 ARG A 229      13.291   9.600  20.527  1.00 12.65           N  
ATOM   1794  N   GLY A 230      15.746  10.914  12.052  1.00 17.69           N  
ATOM   1795  CA  GLY A 230      15.630  10.961  10.592  1.00 11.38           C  
ATOM   1796  C   GLY A 230      14.317  10.350  10.087  1.00 10.71           C  
ATOM   1797  O   GLY A 230      13.394  10.113  10.874  1.00 17.06           O  
ATOM   1798  N   LEU A 231      14.203  10.086   8.788  1.00  9.26           N  
ATOM   1799  CA  LEU A 231      12.972   9.475   8.262  1.00  9.06           C  
ATOM   1800  C   LEU A 231      13.306   8.663   7.023  1.00 29.68           C  
ATOM   1801  O   LEU A 231      14.133   9.101   6.246  1.00 12.07           O  
ATOM   1802  CB  LEU A 231      12.023  10.533   7.722  1.00  8.78           C  
ATOM   1803  CG  LEU A 231      11.347  11.512   8.660  1.00 17.51           C  
ATOM   1804  CD1 LEU A 231      10.826  12.553   7.686  1.00 22.07           C  
ATOM   1805  CD2 LEU A 231      10.224  10.790   9.437  1.00 10.35           C  
ATOM   1806  N   PHE A 232      12.656   7.518   6.836  1.00 10.59           N  
ATOM   1807  CA  PHE A 232      12.856   6.688   5.660  1.00  4.81           C  
ATOM   1808  C   PHE A 232      11.631   6.911   4.763  1.00 16.67           C  
ATOM   1809  O   PHE A 232      10.475   6.824   5.198  1.00  8.39           O  
ATOM   1810  CB  PHE A 232      12.902   5.207   6.015  1.00 10.38           C  
ATOM   1811  CG  PHE A 232      14.223   4.775   6.563  1.00 29.12           C  
ATOM   1812  CD1 PHE A 232      15.316   4.635   5.723  1.00 10.47           C  
ATOM   1813  CD2 PHE A 232      14.367   4.510   7.913  1.00 16.67           C  
ATOM   1814  CE1 PHE A 232      16.536   4.244   6.184  1.00  3.68           C  
ATOM   1815  CE2 PHE A 232      15.598   4.125   8.408  1.00 13.34           C  
ATOM   1816  CZ  PHE A 232      16.677   4.002   7.545  1.00 17.01           C  
ATOM   1817  N   VAL A 233      11.891   7.198   3.495  1.00 15.09           N  
ATOM   1818  CA  VAL A 233      10.836   7.447   2.514  1.00 16.03           C  
ATOM   1819  C   VAL A 233      10.894   6.413   1.387  1.00 47.13           C  
ATOM   1820  O   VAL A 233      11.918   6.276   0.725  1.00 11.02           O  
ATOM   1821  CB  VAL A 233      10.970   8.875   1.929  1.00 15.54           C  
ATOM   1822  CG1 VAL A 233       9.811   9.152   0.978  1.00 11.42           C  
ATOM   1823  CG2 VAL A 233      10.927   9.890   3.048  1.00 15.27           C  
ATOM   1824  N   GLY A 234       9.818   5.664   1.159  1.00  8.73           N  
ATOM   1825  CA  GLY A 234       9.844   4.660   0.099  1.00 16.14           C  
ATOM   1826  C   GLY A 234       8.742   4.859  -0.909  1.00 19.78           C  
ATOM   1827  O   GLY A 234       7.710   5.444  -0.591  1.00 11.12           O  
ATOM   1828  N   VAL A 235       8.993   4.376  -2.123  1.00 25.47           N  
ATOM   1829  CA  VAL A 235       8.043   4.461  -3.224  1.00 21.44           C  
ATOM   1830  C   VAL A 235       8.256   3.221  -4.072  1.00 14.02           C  
ATOM   1831  O   VAL A 235       9.336   2.635  -4.095  1.00 11.22           O  
ATOM   1832  CB  VAL A 235       8.218   5.709  -4.054  1.00 19.40           C  
ATOM   1833  CG1 VAL A 235       8.212   6.920  -3.129  1.00 12.16           C  
ATOM   1834  CG2 VAL A 235       9.511   5.586  -4.832  1.00 17.39           C  
ATOM   1835  N   PRO A 236       7.212   2.799  -4.764  1.00 27.67           N  
ATOM   1836  CA  PRO A 236       7.366   1.593  -5.567  1.00  8.09           C  
ATOM   1837  C   PRO A 236       8.613   1.688  -6.454  1.00  8.36           C  
ATOM   1838  O   PRO A 236       8.911   2.710  -7.082  1.00 26.45           O  
ATOM   1839  CB  PRO A 236       6.028   1.494  -6.301  1.00  8.54           C  
ATOM   1840  CG  PRO A 236       5.071   2.282  -5.435  1.00 25.50           C  
ATOM   1841  CD  PRO A 236       5.919   3.458  -5.023  1.00 13.42           C  
ATOM   1842  N   ALA A 237       9.383   0.609  -6.480  1.00 25.54           N  
ATOM   1843  CA  ALA A 237      10.587   0.618  -7.295  1.00 19.79           C  
ATOM   1844  C   ALA A 237      10.077   0.602  -8.728  1.00 99.75           C  
ATOM   1845  O   ALA A 237      10.732   1.244  -9.571  1.00 38.64           O  
ATOM   1846  CB  ALA A 237      11.455  -0.619  -6.984  1.00 17.03           C  
ATOM   1847  OXT ALA A 237       9.016  -0.030  -8.939  1.00 44.46           O  
TER    1848      ALA A 237                                                      
END
MOLECULE T0485.pdb
ATOM      5  N   MET     1      -1.481 -13.150  43.871  1.00  8.67           N  
ATOM      6  CA  MET     1      -1.996 -12.142  42.964  0.70  8.34           C  
ATOM      8  C   MET     1      -0.843 -11.344  42.396  1.00  7.61           C  
ATOM      9  O   MET     1       0.307 -11.417  42.868  1.00  8.27           O  
ATOM     10  CB  MET     1      -3.060 -11.257  43.656  0.70  7.93           C  
ATOM     12  CG  MET     1      -2.578 -10.402  44.794  0.70  6.92           C  
ATOM     14  SD  MET     1      -1.632  -8.771  44.313  0.53  6.93          SE  
ATOM     16  CE  MET     1      -3.050  -7.819  43.355  0.70 10.03           C  
ATOM     18  N   SER     2      -1.143 -10.624  41.351  1.00  7.85           N  
ATOM     19  CA  SER     2      -0.222  -9.690  40.807  1.00  9.16           C  
ATOM     20  C   SER     2      -0.898  -8.470  40.231  1.00  9.17           C  
ATOM     21  O   SER     2      -2.095  -8.531  39.828  1.00 10.71           O  
ATOM     22  CB  SER     2       0.615 -10.344  39.753  1.00  9.64           C  
ATOM     23  OG  SER     2      -0.120 -10.696  38.610  1.00 11.89           O  
ATOM     24  N   GLU     3      -0.151  -7.389  40.224  1.00  8.77           N  
ATOM     25  CA  GLU     3      -0.509  -6.172  39.524  0.53  8.19           C  
ATOM     27  C   GLU     3       0.562  -6.069  38.444  1.00  8.87           C  
ATOM     28  O   GLU     3       1.745  -6.166  38.752  1.00 12.42           O  
ATOM     29  CB  GLU     3      -0.448  -4.997  40.483  0.53 10.65           C  
ATOM     31  CG  GLU     3      -0.721  -3.646  39.850  0.53 12.43           C  
ATOM     33  CD  GLU     3      -2.150  -3.481  39.333  0.53 14.52           C  
ATOM     35  OE1 GLU     3      -3.058  -4.169  39.799  0.53 14.77           O  
ATOM     37  OE2 GLU     3      -2.356  -2.624  38.458  0.53 21.83           O  
ATOM     39  N   ASN     4       0.176  -5.885  37.205  1.00  8.06           N  
ATOM     40  CA  ASN     4       1.062  -5.959  36.055  0.74  9.14           C  
ATOM     42  C   ASN     4       1.002  -4.687  35.236  1.00  9.09           C  
ATOM     43  O   ASN     4      -0.074  -4.130  35.035  1.00 13.07           O  
ATOM     44  CB  ASN     4       0.606  -7.129  35.142  0.74 10.42           C  
ATOM     46  CG  ASN     4       0.724  -8.489  35.798  0.74 10.49           C  
ATOM     48  OD1 ASN     4       1.608  -9.290  35.448  0.74 13.87           O  
ATOM     50  ND2 ASN     4      -0.134  -8.756  36.763  0.74  9.20           N  
ATOM     52  N   LYS     5       2.150  -4.296  34.746  1.00  6.87           N  
ATOM     53  CA  LYS     5       2.324  -3.143  33.860  1.00  7.01           C  
ATOM     54  C   LYS     5       3.179  -3.619  32.700  1.00  7.25           C  
ATOM     55  O   LYS     5       4.205  -4.240  32.901  1.00  7.40           O  
ATOM     56  CB  LYS     5       2.998  -2.001  34.624  1.00  7.11           C  
ATOM     57  CG  LYS     5       3.426  -0.860  33.745  1.00  7.50           C  
ATOM     58  CD  LYS     5       2.280   0.049  33.310  1.00  7.49           C  
ATOM     59  CE  LYS     5       2.719   1.051  32.232  1.00  8.04           C  
ATOM     60  NZ  LYS     5       2.947   0.397  30.922  1.00  8.27           N  
ATOM     61  N   LYS     6       2.719  -3.369  31.473  1.00  7.17           N  
ATOM     62  CA  LYS     6       3.456  -3.757  30.274  1.00  8.10           C  
ATOM     63  C   LYS     6       3.233  -2.708  29.204  1.00  7.31           C  
ATOM     64  O   LYS     6       2.310  -1.895  29.289  1.00  7.86           O  
ATOM     65  CB  LYS     6       3.043  -5.126  29.805  1.00  9.03           C  
ATOM     66  CG  LYS     6       1.599  -5.244  29.462  1.00  9.62           C  
ATOM     67  CD  LYS     6       1.186  -6.709  29.147  1.00 12.22           C  
ATOM     68  CE  LYS     6      -0.336  -6.926  28.980  1.00 14.34           C  
ATOM     69  NZ  LYS     6      -1.001  -6.893  30.345  1.00 15.98           N  
ATOM     70  N   LYS     7       4.087  -2.694  28.194  1.00  7.80           N  
ATOM     71  CA  LYS     7       3.964  -1.662  27.190  1.00  7.69           C  
ATOM     72  C   LYS     7       2.617  -1.682  26.492  1.00  7.66           C  
ATOM     73  O   LYS     7       2.071  -2.728  26.148  1.00  8.71           O  
ATOM     74  CB  LYS     7       5.046  -1.755  26.125  1.00  8.86           C  
ATOM     75  CG  LYS     7       6.450  -1.501  26.628  1.00 11.03           C  
ATOM     76  CD  LYS     7       7.438  -1.209  25.488  1.00 13.56           C  
ATOM     77  CE  LYS     7       7.589  -2.328  24.501  1.00 13.98           C  
ATOM     78  NZ  LYS     7       8.191  -3.588  25.051  1.00 17.04           N  
ATOM     79  N   PHE     8       2.096  -0.482  26.317  1.00  7.70           N  
ATOM     80  CA  PHE     8       0.891  -0.214  25.527  1.00  7.42           C  
ATOM     81  C   PHE     8      -0.409  -0.656  26.170  1.00  7.87           C  
ATOM     82  O   PHE     8      -1.454  -0.771  25.521  1.00  9.21           O  
ATOM     83  CB  PHE     8       1.015  -0.731  24.073  1.00  9.35           C  
ATOM     84  CG  PHE     8       2.397  -0.542  23.487  1.00  8.92           C  
ATOM     85  CD1 PHE     8       2.987   0.706  23.481  1.00  9.86           C  
ATOM     86  CD2 PHE     8       3.069  -1.598  22.920  1.00 10.18           C  
ATOM     87  CE1 PHE     8       4.256   0.904  22.946  1.00  9.67           C  
ATOM     88  CE2 PHE     8       4.353  -1.418  22.365  1.00 11.24           C  
ATOM     89  CZ  PHE     8       4.922  -0.179  22.389  1.00 10.77           C  
ATOM     90  N   ASP     9      -0.325  -0.887  27.471  1.00  7.13           N  
ATOM     91  CA  ASP     9      -1.507  -1.238  28.276  1.00  7.67           C  
ATOM     92  C   ASP     9      -2.276   0.016  28.676  1.00  7.69           C  
ATOM     93  O   ASP     9      -2.012   1.098  28.184  1.00  7.72           O  
ATOM     94  CB  ASP     9      -1.129  -2.123  29.468  1.00  8.06           C  
ATOM     95  CG  ASP     9      -0.247  -1.442  30.510  1.00  6.85           C  
ATOM     96  OD1 ASP     9       0.092  -0.248  30.352  1.00  7.29           O  
ATOM     97  OD2 ASP     9       0.069  -2.129  31.524  1.00  7.83           O  
ATOM     98  N   LYS    10      -3.267  -0.124  29.545  1.00  8.67           N  
ATOM     99  CA  LYS    10      -4.080   1.031  29.882  1.00  9.26           C  
ATOM    100  C   LYS    10      -3.265   2.158  30.504  1.00  8.69           C  
ATOM    101  O   LYS    10      -3.387   3.323  30.124  1.00  8.94           O  
ATOM    102  CB  LYS    10      -5.210   0.623  30.806  1.00 11.99           C  
ATOM    103  CG  LYS    10      -6.173   1.746  31.093  1.00 16.97           C  
ATOM    104  CD  LYS    10      -7.405   1.342  31.886  1.00 22.29           C  
ATOM    105  CE  LYS    10      -8.364   2.546  31.946  1.00 27.25           C  
ATOM    106  NZ  LYS    10      -9.627   2.275  32.678  1.00 32.98           N  
ATOM    107  N   LYS    11      -2.416   1.817  31.462  1.00  8.37           N  
ATOM    108  CA  LYS    11      -1.579   2.828  32.078  1.00  8.68           C  
ATOM    109  C   LYS    11      -0.591   3.451  31.102  1.00  7.99           C  
ATOM    110  O   LYS    11      -0.346   4.666  31.124  1.00  8.73           O  
ATOM    111  CB  LYS    11      -0.858   2.193  33.240  1.00  9.97           C  
ATOM    112  CG  LYS    11      -1.736   1.893  34.432  1.00 14.76           C  
ATOM    113  CD  LYS    11      -1.059   1.146  35.513  1.00 18.41           C  
ATOM    114  CE  LYS    11      -1.984   1.067  36.712  1.00 20.58           C  
ATOM    115  NZ  LYS    11      -1.315   0.442  37.822  1.00 22.46           N  
ATOM    116  N   GLY    12      -0.010   2.630  30.240  1.00  7.91           N  
ATOM    117  CA  GLY    12       0.930   3.141  29.266  1.00  7.46           C  
ATOM    118  C   GLY    12       0.271   4.038  28.242  1.00  7.46           C  
ATOM    119  O   GLY    12       0.847   5.037  27.807  1.00  8.40           O  
ATOM    120  N   ALA    13      -0.950   3.685  27.854  1.00  7.42           N  
ATOM    121  CA  ALA    13      -1.714   4.493  26.900  1.00  7.56           C  
ATOM    122  C   ALA    13      -1.979   5.875  27.498  1.00  7.04           C  
ATOM    123  O   ALA    13      -1.894   6.900  26.820  1.00  7.99           O  
ATOM    124  CB  ALA    13      -3.037   3.792  26.547  1.00  9.11           C  
ATOM    125  N   LYS    14      -2.325   5.905  28.784  1.00  7.10           N  
ATOM    126  CA  LYS    14      -2.545   7.170  29.482  0.53  7.27           C  
ATOM    128  C   LYS    14      -1.266   8.025  29.468  1.00  7.21           C  
ATOM    129  O   LYS    14      -1.321   9.233  29.257  1.00  8.68           O  
ATOM    130  CB  LYS    14      -3.017   6.888  30.918  0.53  8.25           C  
ATOM    132  CG  LYS    14      -3.209   8.137  31.782  0.53 10.78           C  
ATOM    134  CD  LYS    14      -3.717   7.767  33.194  0.53 16.27           C  
ATOM    136  CE  LYS    14      -3.901   8.984  34.108  0.53 20.54           C  
ATOM    138  NZ  LYS    14      -2.629   9.615  34.533  0.53 23.85           N  
ATOM    140  N   ASN    15      -0.131   7.406  29.726  1.00  7.92           N  
ATOM    141  CA  ASN    15       1.136   8.159  29.717  1.00  8.53           C  
ATOM    142  C   ASN    15       1.440   8.737  28.345  1.00  8.17           C  
ATOM    143  O   ASN    15       1.852   9.887  28.230  1.00  8.82           O  
ATOM    144  CB  ASN    15       2.283   7.276  30.135  1.00  8.79           C  
ATOM    145  CG  ASN    15       2.242   6.898  31.574  1.00 11.44           C  
ATOM    146  OD1 ASN    15       1.482   7.460  32.353  1.00 15.16           O  
ATOM    147  ND2 ASN    15       3.084   5.969  31.954  1.00 11.41           N  
ATOM    148  N   MET    16       1.247   7.925  27.308  1.00  7.21           N  
ATOM    149  CA  MET    16       1.480   8.381  25.957  1.00  8.03           C  
ATOM    150  C   MET    16       0.532   9.535  25.607  1.00  7.68           C  
ATOM    151  O   MET    16       0.938  10.534  24.994  1.00  8.53           O  
ATOM    152  CB  MET    16       1.325   7.241  24.978  1.00  7.51           C  
ATOM    153  CG  MET    16       1.698   7.583  23.517  1.00  8.88           C  
ATOM    154  SD  MET    16       3.579   7.936  23.215  0.75  8.58          SE  
ATOM    155  CE  MET    16       3.470   9.822  22.762  1.00 11.14           C  
ATOM    156  N   ASP    17      -0.734   9.395  25.990  1.00  6.41           N  
ATOM    157  CA  ASP    17      -1.721  10.420  25.724  1.00  7.06           C  
ATOM    158  C   ASP    17      -1.319  11.732  26.416  1.00  7.51           C  
ATOM    159  O   ASP    17      -1.372  12.815  25.830  1.00  8.29           O  
ATOM    160  CB  ASP    17      -3.080   9.966  26.240  1.00  7.74           C  
ATOM    161  CG  ASP    17      -4.196  10.927  25.886  1.00  7.94           C  
ATOM    162  OD1 ASP    17      -4.289  11.351  24.720  1.00  8.94           O  
ATOM    163  OD2 ASP    17      -5.028  11.219  26.778  1.00 11.58           O  
ATOM    164  N   GLU    18      -0.932  11.629  27.682  1.00  7.26           N  
ATOM    165  CA  GLU    18      -0.554  12.836  28.434  1.00  8.48           C  
ATOM    166  C   GLU    18       0.619  13.553  27.809  1.00  7.65           C  
ATOM    167  O   GLU    18       0.628  14.774  27.698  1.00  9.54           O  
ATOM    168  CB  GLU    18      -0.270  12.467  29.894  1.00  9.41           C  
ATOM    169  CG  GLU    18      -1.569  12.133  30.631  1.00 13.91           C  
ATOM    170  CD  GLU    18      -1.395  11.689  32.079  1.00 22.47           C  
ATOM    171  OE1 GLU    18      -0.237  11.582  32.552  1.00 28.94           O  
ATOM    172  OE2 GLU    18      -2.447  11.400  32.719  1.00 26.09           O  
ATOM    173  N   ILE    19       1.617  12.801  27.380  1.00  7.61           N  
ATOM    174  CA  ILE    19       2.804  13.388  26.737  1.00  7.85           C  
ATOM    175  C   ILE    19       2.432  13.988  25.377  1.00  6.82           C  
ATOM    176  O   ILE    19       2.850  15.102  25.029  1.00  8.10           O  
ATOM    177  CB  ILE    19       3.937  12.371  26.646  1.00  8.65           C  
ATOM    178  CG1 ILE    19       4.522  12.143  28.043  1.00 10.43           C  
ATOM    179  CG2 ILE    19       5.033  12.856  25.661  1.00 10.37           C  
ATOM    180  CD1 ILE    19       5.343  13.325  28.598  1.00 14.31           C  
ATOM    181  N   SER    20       1.610  13.265  24.615  1.00  7.24           N  
ATOM    182  CA  SER    20       1.135  13.685  23.306  0.50  7.20           C  
ATOM    184  C   SER    20       0.420  15.055  23.364  1.00  8.01           C  
ATOM    185  O   SER    20       0.459  15.856  22.444  1.00  9.90           O  
ATOM    186  CB  SER    20       0.168  12.600  22.787  0.50  6.57           C  
ATOM    188  OG  SER    20      -0.448  12.996  21.591  0.50 10.00           O  
ATOM    190  N   LYS    21      -0.305  15.269  24.453  1.00  8.12           N  
ATOM    191  CA  LYS    21      -1.128  16.476  24.694  0.52  8.74           C  
ATOM    193  C   LYS    21      -0.354  17.626  25.305  1.00  8.20           C  
ATOM    194  O   LYS    21      -0.855  18.749  25.389  1.00  9.65           O  
ATOM    195  CB  LYS    21      -2.311  16.147  25.637  0.52  8.96           C  
ATOM    197  CG  LYS    21      -3.427  15.322  24.947  0.52 10.89           C  
ATOM    199  CD  LYS    21      -4.560  14.849  25.851  0.52 14.15           C  
ATOM    201  CE  LYS    21      -5.655  14.138  25.022  0.52 14.68           C  
ATOM    203  NZ  LYS    21      -6.579  13.275  25.848  0.52 13.50           N  
ATOM    205  N   THR    22       0.857  17.327  25.765  1.00  8.24           N  
ATOM    206  CA  THR    22       1.672  18.314  26.464  1.00  8.54           C  
ATOM    207  C   THR    22       3.023  18.504  25.783  1.00  8.63           C  
ATOM    208  O   THR    22       3.145  19.231  24.793  1.00  9.20           O  
ATOM    209  CB  THR    22       1.763  18.000  27.992  1.00 10.21           C  
ATOM    210  OG1 THR    22       2.381  16.735  28.229  1.00  9.41           O  
ATOM    211  CG2 THR    22       0.403  18.068  28.666  1.00 11.24           C  
ATOM    212  N   LEU    23       4.030  17.846  26.288  1.00  8.41           N  
ATOM    213  CA  LEU    23       5.393  18.041  25.817  1.00  9.05           C  
ATOM    214  C   LEU    23       5.555  17.805  24.314  1.00  8.93           C  
ATOM    215  O   LEU    23       6.243  18.561  23.636  1.00  9.40           O  
ATOM    216  CB  LEU    23       6.288  17.088  26.585  1.00 10.54           C  
ATOM    217  CG  LEU    23       7.755  17.241  26.300  1.00 13.35           C  
ATOM    218  CD1 LEU    23       8.234  18.660  26.616  1.00 13.77           C  
ATOM    219  CD2 LEU    23       8.515  16.191  27.077  1.00 15.65           C  
ATOM    220  N   PHE    24       4.921  16.768  23.780  1.00  7.77           N  
ATOM    221  CA  PHE    24       5.067  16.460  22.361  1.00  7.58           C  
ATOM    222  C   PHE    24       4.078  17.202  21.464  1.00  7.62           C  
ATOM    223  O   PHE    24       4.204  17.173  20.245  1.00  8.46           O  
ATOM    224  CB  PHE    24       4.886  14.960  22.066  1.00  7.43           C  
ATOM    225  CG  PHE    24       6.000  14.056  22.471  1.00  7.96           C  
ATOM    226  CD1 PHE    24       7.061  14.462  23.247  1.00  8.92           C  
ATOM    227  CD2 PHE    24       5.931  12.739  22.097  1.00  8.54           C  
ATOM    228  CE1 PHE    24       8.022  13.538  23.649  1.00  9.73           C  
ATOM    229  CE2 PHE    24       6.904  11.835  22.495  1.00 10.13           C  
ATOM    230  CZ  PHE    24       7.948  12.221  23.230  1.00  9.82           C  
ATOM    231  N   ALA    25       3.091  17.867  22.052  1.00  8.31           N  
ATOM    232  CA  ALA    25       2.015  18.435  21.232  1.00  8.01           C  
ATOM    233  C   ALA    25       2.484  19.228  20.000  1.00  8.06           C  
ATOM    234  O   ALA    25       1.914  19.078  18.920  1.00  8.05           O  
ATOM    235  CB  ALA    25       1.051  19.291  22.060  1.00  9.40           C  
ATOM    236  N   PRO    26       3.494  20.097  20.126  1.00  8.11           N  
ATOM    237  CA  PRO    26       3.866  20.886  18.956  1.00  8.19           C  
ATOM    238  C   PRO    26       4.464  20.111  17.785  1.00  7.84           C  
ATOM    239  O   PRO    26       4.461  20.600  16.647  1.00  8.42           O  
ATOM    240  CB  PRO    26       4.912  21.858  19.489  1.00 10.25           C  
ATOM    241  CG  PRO    26       5.213  21.496  20.784  1.00 15.30           C  
ATOM    242  CD  PRO    26       4.235  20.516  21.324  1.00  9.57           C  
ATOM    243  N   ILE    27       4.940  18.897  18.046  1.00  7.18           N  
ATOM    244  CA  ILE    27       5.610  18.172  16.962  1.00  7.05           C  
ATOM    245  C   ILE    27       4.629  17.692  15.910  1.00  6.91           C  
ATOM    246  O   ILE    27       5.002  17.552  14.740  1.00  7.44           O  
ATOM    247  CB  ILE    27       6.453  16.990  17.458  1.00  7.30           C  
ATOM    248  CG1 ILE    27       5.629  15.768  17.830  1.00  7.74           C  
ATOM    249  CG2 ILE    27       7.385  17.453  18.598  1.00  8.53           C  
ATOM    250  CD1 ILE    27       6.414  14.665  18.487  1.00  9.05           C  
ATOM    251  N   TYR    28       3.379  17.437  16.300  1.00  6.72           N  
ATOM    252  CA  TYR    28       2.470  16.771  15.368  1.00  7.01           C  
ATOM    253  C   TYR    28       2.098  17.686  14.170  1.00  6.99           C  
ATOM    254  O   TYR    28       2.157  17.224  13.039  1.00  7.14           O  
ATOM    255  CB  TYR    28       1.268  16.172  16.092  1.00  7.55           C  
ATOM    256  CG  TYR    28       1.700  15.172  17.130  1.00  6.77           C  
ATOM    257  CD1 TYR    28       2.076  13.900  16.777  1.00  7.31           C  
ATOM    258  CD2 TYR    28       1.712  15.496  18.476  1.00  7.57           C  
ATOM    259  CE1 TYR    28       2.502  12.982  17.725  1.00  6.97           C  
ATOM    260  CE2 TYR    28       2.133  14.588  19.435  1.00  7.99           C  
ATOM    261  CZ  TYR    28       2.498  13.336  19.065  1.00  7.33           C  
ATOM    262  OH  TYR    28       2.883  12.442  20.051  1.00  9.14           O  
ATOM    263  N   PRO    29       1.728  18.953  14.417  1.00  6.96           N  
ATOM    264  CA  PRO    29       1.485  19.814  13.265  1.00  7.46           C  
ATOM    265  C   PRO    29       2.723  20.018  12.400  1.00  7.10           C  
ATOM    266  O   PRO    29       2.605  20.183  11.192  1.00  7.69           O  
ATOM    267  CB  PRO    29       0.974  21.118  13.866  1.00  8.48           C  
ATOM    268  CG  PRO    29       1.138  20.983  15.303  1.00 13.62           C  
ATOM    269  CD  PRO    29       1.334  19.581  15.680  1.00  8.11           C  
ATOM    270  N   ILE    30       3.905  20.050  13.004  1.00  7.19           N  
ATOM    271  CA  ILE    30       5.143  20.237  12.242  1.00  6.88           C  
ATOM    272  C   ILE    30       5.403  19.006  11.355  1.00  7.03           C  
ATOM    273  O   ILE    30       5.741  19.136  10.183  1.00  7.09           O  
ATOM    274  CB  ILE    30       6.351  20.520  13.169  1.00  7.04           C  
ATOM    275  CG1 ILE    30       6.168  21.881  13.877  1.00  8.69           C  
ATOM    276  CG2 ILE    30       7.679  20.458  12.422  1.00  9.30           C  
ATOM    277  CD1 ILE    30       6.185  23.079  12.950  1.00 10.79           C  
ATOM    278  N   ILE    31       5.272  17.819  11.925  1.00  6.61           N  
ATOM    279  CA  ILE    31       5.492  16.611  11.159  1.00  6.92           C  
ATOM    280  C   ILE    31       4.456  16.528  10.042  1.00  6.73           C  
ATOM    281  O   ILE    31       4.786  16.171   8.892  1.00  6.99           O  
ATOM    282  CB  ILE    31       5.472  15.375  12.054  1.00  7.14           C  
ATOM    283  CG1 ILE    31       6.700  15.397  12.998  1.00  6.96           C  
ATOM    284  CG2 ILE    31       5.478  14.099  11.208  1.00  8.22           C  
ATOM    285  CD1 ILE    31       6.661  14.361  14.125  1.00  8.75           C  
ATOM    286  N   ALA    32       3.195  16.817  10.341  1.00  6.98           N  
ATOM    287  CA  ALA    32       2.162  16.816   9.305  1.00  7.60           C  
ATOM    288  C   ALA    32       2.490  17.772   8.173  1.00  6.55           C  
ATOM    289  O   ALA    32       2.366  17.453   6.998  1.00  6.98           O  
ATOM    290  CB  ALA    32       0.793  17.136   9.928  1.00  7.82           C  
ATOM    291  N   GLU    33       2.943  18.965   8.533  1.00  6.56           N  
ATOM    292  CA  GLU    33       3.330  19.953   7.552  1.00  7.54           C  
ATOM    293  C   GLU    33       4.509  19.462   6.732  1.00  7.00           C  
ATOM    294  O   GLU    33       4.548  19.633   5.506  1.00  7.66           O  
ATOM    295  CB  GLU    33       3.661  21.262   8.272  1.00  7.76           C  
ATOM    296  CG  GLU    33       4.174  22.352   7.390  1.00 10.06           C  
ATOM    297  CD  GLU    33       4.400  23.640   8.136  1.00 12.92           C  
ATOM    298  OE1 GLU    33       5.047  23.663   9.184  1.00 17.46           O  
ATOM    299  OE2 GLU    33       3.891  24.633   7.658  1.00 18.89           O  
ATOM    300  N   ASN    34       5.482  18.836   7.386  1.00  7.18           N  
ATOM    301  CA  ASN    34       6.636  18.291   6.686  1.00  7.24           C  
ATOM    302  C   ASN    34       6.184  17.268   5.636  1.00  7.17           C  
ATOM    303  O   ASN    34       6.698  17.263   4.500  1.00  7.61           O  
ATOM    304  CB  ASN    34       7.619  17.610   7.640  1.00  7.23           C  
ATOM    305  CG  ASN    34       8.377  18.580   8.503  1.00  8.40           C  
ATOM    306  OD1 ASN    34       8.422  19.779   8.205  1.00  9.80           O  
ATOM    307  ND2 ASN    34       9.018  18.060   9.551  1.00  9.22           N  
ATOM    308  N   ILE    35       5.227  16.404   6.002  1.00  7.02           N  
ATOM    309  CA  ILE    35       4.750  15.360   5.117  1.00  7.18           C  
ATOM    310  C   ILE    35       4.006  15.973   3.924  1.00  6.48           C  
ATOM    311  O   ILE    35       4.217  15.581   2.755  1.00  7.12           O  
ATOM    312  CB  ILE    35       3.846  14.379   5.893  1.00  7.39           C  
ATOM    313  CG1 ILE    35       4.678  13.599   6.915  1.00  8.00           C  
ATOM    314  CG2 ILE    35       3.077  13.456   4.933  1.00  9.13           C  
ATOM    315  CD1 ILE    35       3.808  12.938   7.996  1.00  9.04           C  
ATOM    316  N   ILE    36       3.135  16.920   4.199  1.00  6.43           N  
ATOM    317  CA  ILE    36       2.396  17.615   3.134  1.00  6.88           C  
ATOM    318  C   ILE    36       3.357  18.290   2.181  1.00  7.45           C  
ATOM    319  O   ILE    36       3.210  18.201   0.954  1.00  7.42           O  
ATOM    320  CB  ILE    36       1.361  18.589   3.754  1.00  7.55           C  
ATOM    321  CG1 ILE    36       0.248  17.777   4.421  1.00  8.70           C  
ATOM    322  CG2 ILE    36       0.837  19.572   2.683  1.00  9.97           C  
ATOM    323  CD1 ILE    36      -0.653  18.558   5.339  1.00 12.24           C  
ATOM    324  N   ASN    37       4.329  18.991   2.745  1.00  7.38           N  
ATOM    325  CA  ASN    37       5.276  19.736   1.919  1.00  8.10           C  
ATOM    326  C   ASN    37       6.164  18.813   1.110  1.00  7.67           C  
ATOM    327  O   ASN    37       6.515  19.126  -0.030  1.00  9.85           O  
ATOM    328  CB  ASN    37       6.151  20.633   2.769  1.00  8.87           C  
ATOM    329  CG  ASN    37       5.412  21.835   3.316  1.00 10.85           C  
ATOM    330  OD1 ASN    37       4.281  22.121   2.904  1.00 12.97           O  
ATOM    331  ND2 ASN    37       6.019  22.525   4.284  1.00 13.28           N  
ATOM    332  N   ARG    38       6.538  17.670   1.678  1.00  7.47           N  
ATOM    333  CA  ARG    38       7.474  16.807   1.003  0.52  8.07           C  
ATOM    335  C   ARG    38       6.876  16.121  -0.239  1.00 10.01           C  
ATOM    336  O   ARG    38       7.538  16.008  -1.253  1.00 10.10           O  
ATOM    337  CB  ARG    38       8.042  15.816   2.010  0.52  7.49           C  
ATOM    339  CG  ARG    38       9.277  15.167   1.514  0.52  7.20           C  
ATOM    341  CD  ARG    38       9.981  14.327   2.572  0.52  7.52           C  
ATOM    343  NE  ARG    38      11.111  13.683   1.952  0.52  6.54           N  
ATOM    345  CZ  ARG    38      12.386  13.780   2.326  0.52  8.59           C  
ATOM    347  NH1 ARG    38      12.775  14.317   3.477  0.52  7.08           N  
ATOM    349  NH2 ARG    38      13.282  13.207   1.572  0.52  7.93           N  
ATOM    351  N   PHE    39       5.654  15.552  -0.094  1.00  9.61           N  
ATOM    352  CA  PHE    39       5.065  14.786  -1.146  1.00  8.65           C  
ATOM    353  C   PHE    39       3.976  15.460  -1.928  1.00  8.39           C  
ATOM    354  O   PHE    39       3.674  15.014  -3.023  1.00  9.72           O  
ATOM    355  CB  PHE    39       4.540  13.467  -0.594  1.00  8.88           C  
ATOM    356  CG  PHE    39       5.532  12.708   0.247  1.00  8.23           C  
ATOM    357  CD1 PHE    39       6.722  12.259  -0.278  1.00  8.94           C  
ATOM    358  CD2 PHE    39       5.284  12.480   1.575  1.00 10.04           C  
ATOM    359  CE1 PHE    39       7.620  11.571   0.495  1.00  9.70           C  
ATOM    360  CE2 PHE    39       6.179  11.796   2.364  1.00 12.97           C  
ATOM    361  CZ  PHE    39       7.356  11.341   1.817  1.00 12.09           C  
ATOM    362  N   GLY    40       3.388  16.521  -1.409  1.00  7.85           N  
ATOM    363  CA  GLY    40       2.312  17.174  -2.138  1.00  8.79           C  
ATOM    364  C   GLY    40       1.030  16.367  -2.229  1.00  8.85           C  
ATOM    365  O   GLY    40       0.188  16.673  -3.083  1.00 10.77           O  
ATOM    366  N   ILE    41       0.882  15.345  -1.375  1.00  8.99           N  
ATOM    367  CA  ILE    41      -0.336  14.518  -1.300  1.00  9.47           C  
ATOM    368  C   ILE    41      -1.213  15.140  -0.236  1.00  8.66           C  
ATOM    369  O   ILE    41      -0.787  15.277   0.913  1.00  9.73           O  
ATOM    370  CB  ILE    41      -0.058  13.034  -0.988  1.00  9.34           C  
ATOM    371  CG1 ILE    41       1.083  12.448  -1.847  1.00  9.24           C  
ATOM    372  CG2 ILE    41      -1.336  12.233  -1.198  1.00 10.11           C  
ATOM    373  CD1 ILE    41       1.665  11.148  -1.289  1.00 12.39           C  
ATOM    374  N   THR    42      -2.415  15.581  -0.628  1.00  9.48           N  
ATOM    375  CA  THR    42      -3.275  16.361   0.307  1.00 10.42           C  
ATOM    376  C   THR    42      -4.692  15.755   0.480  1.00  9.48           C  
ATOM    377  O   THR    42      -5.541  16.311   1.133  1.00 10.21           O  
ATOM    378  CB  THR    42      -3.376  17.807  -0.171  1.00 11.69           C  
ATOM    379  OG1 THR    42      -3.894  17.844  -1.506  1.00 14.96           O  
ATOM    380  CG2 THR    42      -2.011  18.491  -0.160  1.00 14.68           C  
ATOM    381  N   ALA    43      -4.956  14.730  -0.309  1.00  9.15           N  
ATOM    382  CA  ALA    43      -6.217  14.028  -0.314  1.00  9.37           C  
ATOM    383  C   ALA    43      -6.043  12.572  -0.708  1.00  9.19           C  
ATOM    384  O   ALA    43      -4.960  12.147  -1.105  1.00 11.46           O  
ATOM    385  CB  ALA    43      -7.258  14.742  -1.240  1.00 10.44           C  
ATOM    386  N   GLY    44      -7.126  11.829  -0.664  1.00 10.43           N  
ATOM    387  CA  GLY    44      -7.098  10.385  -0.901  1.00 10.01           C  
ATOM    388  C   GLY    44      -7.096   9.682   0.450  1.00 10.00           C  
ATOM    389  O   GLY    44      -7.731  10.144   1.407  1.00 11.67           O  
ATOM    390  N   ASN    45      -6.362   8.594   0.535  1.00  8.32           N  
ATOM    391  CA  ASN    45      -6.335   7.768   1.732  1.00  8.24           C  
ATOM    392  C   ASN    45      -4.975   7.794   2.398  1.00  8.40           C  
ATOM    393  O   ASN    45      -3.927   7.720   1.753  1.00  9.29           O  
ATOM    394  CB  ASN    45      -6.695   6.336   1.331  1.00  9.68           C  
ATOM    397  N   CYS    46      -5.000   7.940   3.707  1.00  7.79           N  
ATOM    398  CA  CYS    46      -3.796   7.934   4.538  1.00  7.37           C  
ATOM    399  C   CYS    46      -3.960   6.957   5.687  1.00  6.93           C  
ATOM    400  O   CYS    46      -4.992   6.985   6.372  1.00  8.49           O  
ATOM    401  CB  CYS    46      -3.532   9.335   5.099  1.00  8.02           C  
ATOM    402  SG  CYS    46      -2.142   9.452   6.229  1.00 10.58           S  
ATOM    403  N   ILE    47      -2.977   6.083   5.859  1.00  6.83           N  
ATOM    404  CA  ILE    47      -2.969   5.136   6.973  1.00  6.92           C  
ATOM    405  C   ILE    47      -1.869   5.568   7.934  1.00  6.74           C  
ATOM    406  O   ILE    47      -0.734   5.773   7.511  1.00  7.56           O  
ATOM    407  CB  ILE    47      -2.696   3.684   6.527  1.00  8.48           C  
ATOM    408  CG1 ILE    47      -3.578   3.260   5.350  1.00 10.58           C  
ATOM    409  CG2 ILE    47      -2.814   2.742   7.694  1.00 10.64           C  
ATOM    410  CD1 ILE    47      -5.056   3.398   5.512  1.00 12.24           C  
ATOM    411  N   ASP    48      -2.222   5.749   9.213  1.00  7.07           N  
ATOM    412  CA  ASP    48      -1.302   6.081  10.300  1.00  6.60           C  
ATOM    413  C   ASP    48      -1.114   4.801  11.114  1.00  6.67           C  
ATOM    414  O   ASP    48      -2.003   4.357  11.833  1.00  8.14           O  
ATOM    415  CB  ASP    48      -1.906   7.217  11.122  1.00  7.17           C  
ATOM    416  CG  ASP    48      -1.052   7.660  12.289  1.00  7.98           C  
ATOM    417  OD1 ASP    48       0.114   7.232  12.370  1.00  9.38           O  
ATOM    418  OD2 ASP    48      -1.585   8.439  13.116  1.00  8.93           O  
ATOM    419  N   ILE    49       0.060   4.189  10.967  1.00  6.49           N  
ATOM    420  CA  ILE    49       0.363   2.908  11.602  1.00  6.46           C  
ATOM    421  C   ILE    49       0.972   3.136  12.977  1.00  6.15           C  
ATOM    422  O   ILE    49       1.947   3.859  13.134  1.00  7.92           O  
ATOM    423  CB  ILE    49       1.274   2.053  10.725  1.00  7.77           C  
ATOM    424  CG1 ILE    49       0.588   1.788   9.356  1.00  9.01           C  
ATOM    425  CG2 ILE    49       1.630   0.728  11.446  1.00  8.68           C  
ATOM    426  CD1 ILE    49       1.448   0.984   8.392  1.00 10.96           C  
ATOM    427  N   GLY    50       0.397   2.484  13.975  1.00  6.58           N  
ATOM    428  CA  GLY    50       0.799   2.677  15.352  1.00  6.69           C  
ATOM    429  C   GLY    50       0.390   4.064  15.811  1.00  6.03           C  
ATOM    430  O   GLY    50       1.177   4.805  16.412  1.00  7.71           O  
ATOM    431  N   SER    51      -0.872   4.400  15.538  1.00  6.38           N  
ATOM    432  CA  SER    51      -1.406   5.722  15.732  1.00  6.50           C  
ATOM    433  C   SER    51      -1.492   6.169  17.198  1.00  6.71           C  
ATOM    434  O   SER    51      -1.535   7.367  17.477  1.00  7.54           O  
ATOM    435  CB  SER    51      -2.787   5.792  15.058  1.00  7.66           C  
ATOM    436  OG  SER    51      -3.566   4.627  15.335  1.00  7.63           O  
ATOM    437  N   GLY    52      -1.540   5.209  18.122  1.00  6.79           N  
ATOM    438  CA  GLY    52      -1.511   5.535  19.525  1.00  7.71           C  
ATOM    439  C   GLY    52      -2.698   6.405  19.913  1.00  7.28           C  
ATOM    440  O   GLY    52      -3.822   6.137  19.521  1.00  7.82           O  
ATOM    441  N   PRO    53      -2.472   7.474  20.700  1.00  7.60           N  
ATOM    442  CA  PRO    53      -3.569   8.361  21.066  1.00  8.11           C  
ATOM    443  C   PRO    53      -4.139   9.195  19.911  1.00  7.80           C  
ATOM    444  O   PRO    53      -5.121   9.900  20.106  1.00  8.40           O  
ATOM    445  CB  PRO    53      -2.948   9.283  22.121  1.00 10.37           C  
ATOM    446  CG  PRO    53      -1.764   8.546  22.652  1.00 11.26           C  
ATOM    447  CD  PRO    53      -1.246   7.779  21.461  1.00  9.95           C  
ATOM    448  N   GLY    54      -3.515   9.113  18.725  1.00  7.73           N  
ATOM    449  CA  GLY    54      -4.052   9.702  17.521  1.00  7.97           C  
ATOM    450  C   GLY    54      -3.551  11.055  17.113  1.00  7.36           C  
ATOM    451  O   GLY    54      -4.084  11.644  16.173  1.00  8.91           O  
ATOM    452  N   ALA    55      -2.528  11.586  17.785  1.00  8.21           N  
ATOM    453  CA  ALA    55      -2.156  12.975  17.554  1.00  8.70           C  
ATOM    454  C   ALA    55      -1.640  13.243  16.152  1.00  7.97           C  
ATOM    455  O   ALA    55      -1.848  14.334  15.648  1.00  9.08           O  
ATOM    456  CB  ALA    55      -1.178  13.479  18.609  1.00 11.23           C  
ATOM    457  N   LEU    56      -0.946  12.297  15.527  1.00  7.81           N  
ATOM    458  CA  LEU    56      -0.446  12.560  14.163  1.00  8.20           C  
ATOM    459  C   LEU    56      -1.617  12.570  13.176  1.00  7.59           C  
ATOM    460  O   LEU    56      -1.687  13.404  12.287  1.00  8.15           O  
ATOM    461  CB  LEU    56       0.637  11.561  13.728  1.00  8.89           C  
ATOM    462  CG  LEU    56       1.266  11.813  12.358  1.00  9.14           C  
ATOM    463  CD1 LEU    56       1.879  13.237  12.252  1.00 11.63           C  
ATOM    464  CD2 LEU    56       2.290  10.716  12.080  1.00 11.52           C  
ATOM    465  N   SER    57      -2.551  11.652  13.357  1.00  7.75           N  
ATOM    466  CA  SER    57      -3.743  11.610  12.512  1.00  7.27           C  
ATOM    467  C   SER    57      -4.557  12.903  12.649  1.00  7.41           C  
ATOM    468  O   SER    57      -5.066  13.452  11.671  1.00  7.91           O  
ATOM    469  CB  SER    57      -4.618  10.406  12.841  1.00  8.21           C  
ATOM    470  OG  SER    57      -4.062   9.190  12.378  1.00  8.44           O  
ATOM    471  N   ILE    58      -4.745  13.345  13.890  1.00  7.25           N  
ATOM    472  CA  ILE    58      -5.480  14.585  14.156  1.00  7.79           C  
ATOM    473  C   ILE    58      -4.773  15.785  13.471  1.00  7.84           C  
ATOM    474  O   ILE    58      -5.433  16.583  12.792  1.00  8.09           O  
ATOM    475  CB  ILE    58      -5.685  14.796  15.672  1.00  8.23           C  
ATOM    476  CG1 ILE    58      -6.683  13.739  16.214  1.00  9.21           C  
ATOM    477  CG2 ILE    58      -6.082  16.223  15.953  1.00 10.08           C  
ATOM    478  CD1 ILE    58      -6.760  13.695  17.734  1.00 11.50           C  
ATOM    479  N   ALA    59      -3.452  15.866  13.587  1.00  8.01           N  
ATOM    480  CA  ALA    59      -2.736  16.967  12.980  1.00  8.60           C  
ATOM    481  C   ALA    59      -2.859  16.937  11.458  1.00  8.17           C  
ATOM    482  O   ALA    59      -3.075  17.959  10.817  1.00  9.25           O  
ATOM    483  CB  ALA    59      -1.268  16.929  13.417  1.00  9.10           C  
ATOM    484  N   LEU    60      -2.754  15.752  10.874  1.00  8.03           N  
ATOM    485  CA  LEU    60      -2.905  15.615   9.418  0.76  8.55           C  
ATOM    487  C   LEU    60      -4.306  15.997   8.963  1.00  8.29           C  
ATOM    488  O   LEU    60      -4.483  16.669   7.945  1.00  9.33           O  
ATOM    489  CB  LEU    60      -2.542  14.195   8.942  0.76  8.80           C  
ATOM    491  CG  LEU    60      -1.070  13.885   8.762  0.76  8.87           C  
ATOM    493  CD1 LEU    60      -0.846  12.360   8.732  0.76 11.37           C  
ATOM    495  CD2 LEU    60      -0.509  14.531   7.485  0.76  9.21           C  
ATOM    497  N   ALA    61      -5.316  15.564   9.715  1.00  8.32           N  
ATOM    498  CA  ALA    61      -6.703  15.897   9.354  1.00  7.81           C  
ATOM    499  C   ALA    61      -6.910  17.405   9.315  1.00  8.61           C  
ATOM    500  O   ALA    61      -7.605  17.940   8.454  1.00  9.99           O  
ATOM    501  CB  ALA    61      -7.672  15.232  10.329  1.00  9.68           C  
ATOM    502  N   LYS    62      -6.312  18.105  10.265  1.00  8.27           N  
ATOM    503  CA  LYS    62      -6.511  19.548  10.351  1.00 10.14           C  
ATOM    504  C   LYS    62      -5.826  20.333   9.239  1.00 10.18           C  
ATOM    505  O   LYS    62      -6.210  21.467   8.971  1.00 13.87           O  
ATOM    506  CB  LYS    62      -6.037  20.060  11.707  1.00 10.06           C  
ATOM    507  CG  LYS    62      -6.911  19.610  12.875  1.00 12.40           C  
ATOM    508  CD  LYS    62      -6.321  20.107  14.178  1.00 15.89           C  
ATOM    509  CE  LYS    62      -7.123  19.696  15.395  1.00 21.55           C  
ATOM    510  NZ  LYS    62      -6.366  20.077  16.635  1.00 25.13           N  
ATOM    511  N   GLN    63      -4.879  19.706   8.559  1.00  8.63           N  
ATOM    512  CA  GLN    63      -4.116  20.380   7.512  1.00  8.33           C  
ATOM    513  C   GLN    63      -4.371  19.866   6.115  1.00  8.54           C  
ATOM    514  O   GLN    63      -3.744  20.365   5.180  1.00 10.07           O  
ATOM    515  CB  GLN    63      -2.608  20.289   7.767  1.00  9.53           C  
ATOM    516  CG  GLN    63      -2.132  21.066   8.946  1.00  9.43           C  
ATOM    517  CD  GLN    63      -0.626  21.029   9.102  1.00  9.46           C  
ATOM    518  OE1 GLN    63       0.141  21.216   8.140  1.00 10.56           O  
ATOM    519  NE2 GLN    63      -0.199  20.877  10.335  1.00 10.08           N  
ATOM    520  N   SER    64      -5.287  18.914   5.933  1.00  8.57           N  
ATOM    521  CA  SER    64      -5.479  18.261   4.636  1.00  9.29           C  
ATOM    522  C   SER    64      -6.902  17.778   4.470  1.00  9.12           C  
ATOM    523  O   SER    64      -7.704  17.887   5.394  1.00  9.90           O  
ATOM    524  CB  SER    64      -4.581  17.021   4.542  1.00 10.86           C  
ATOM    525  OG  SER    64      -5.081  15.978   5.391  1.00 12.56           O  
ATOM    526  N   ASP    65      -7.146  17.145   3.326  1.00  8.63           N  
ATOM    527  CA  ASP    65      -8.441  16.564   2.997  1.00  8.06           C  
ATOM    528  C   ASP    65      -8.403  15.029   2.964  1.00  8.02           C  
ATOM    529  O   ASP    65      -9.255  14.405   2.356  1.00 10.25           O  
ATOM    530  CB  ASP    65      -8.965  17.103   1.651  1.00  8.89           C  
ATOM    531  CG  ASP    65      -9.006  18.598   1.610  1.00 10.85           C  
ATOM    532  OD1 ASP    65      -9.445  19.186   2.588  1.00 13.30           O  
ATOM    533  OD2 ASP    65      -8.576  19.191   0.595  1.00  9.68           O  
ATOM    534  N   PHE    66      -7.401  14.428   3.580  1.00  7.91           N  
ATOM    535  CA  PHE    66      -7.343  12.989   3.603  1.00  8.61           C  
ATOM    536  C   PHE    66      -8.453  12.304   4.378  1.00  7.63           C  
ATOM    537  O   PHE    66      -8.965  12.850   5.360  1.00  8.56           O  
ATOM    538  CB  PHE    66      -6.057  12.491   4.328  1.00  9.45           C  
ATOM    539  CG  PHE    66      -4.795  12.575   3.523  1.00  8.86           C  
ATOM    540  CD1 PHE    66      -4.565  11.692   2.481  1.00  9.16           C  
ATOM    541  CD2 PHE    66      -3.790  13.435   3.872  1.00 10.05           C  
ATOM    542  CE1 PHE    66      -3.384  11.729   1.776  1.00  9.50           C  
ATOM    543  CE2 PHE    66      -2.602  13.475   3.144  1.00 10.62           C  
ATOM    544  CZ  PHE    66      -2.412  12.618   2.118  1.00 10.79           C  
ATOM    545  N   SER    67      -8.799  11.109   3.900  1.00  7.80           N  
ATOM    546  CA  SER    67      -9.575  10.149   4.672  0.48  7.51           C  
ATOM    549  C   SER    67      -8.512   9.324   5.388  1.00  7.49           C  
ATOM    550  O   SER    67      -7.698   8.663   4.745  1.00  9.48           O  
ATOM    551  CB  SER    67     -10.411   9.241   3.776  0.48  8.28           C  
ATOM    554  OG  SER    67     -11.327   9.975   2.955  0.48 10.11           O  
ATOM    557  N   ILE    68      -8.496   9.367   6.710  1.00  7.00           N  
ATOM    558  CA  ILE    68      -7.434   8.716   7.495  1.00  7.24           C  
ATOM    559  C   ILE    68      -7.918   7.521   8.263  1.00  6.90           C  
ATOM    560  O   ILE    68      -9.043   7.525   8.805  1.00  7.69           O  
ATOM    561  CB  ILE    68      -6.872   9.760   8.505  1.00  7.71           C  
ATOM    562  CG1 ILE    68      -6.289  10.976   7.751  1.00  8.62           C  
ATOM    563  CG2 ILE    68      -5.800   9.127   9.439  1.00  9.32           C  
ATOM    564  CD1 ILE    68      -6.111  12.217   8.602  1.00 12.10           C  
ATOM    565  N   ARG    69      -7.104   6.471   8.250  1.00  7.48           N  
ATOM    566  CA  ARG    69      -7.347   5.293   9.095  0.61  8.21           C  
ATOM    568  C   ARG    69      -6.157   5.189  10.026  1.00  8.11           C  
ATOM    569  O   ARG    69      -4.998   5.202   9.601  1.00  9.74           O  
ATOM    570  CB  ARG    69      -7.496   4.020   8.300  0.61  9.63           C  
ATOM    572  CG  ARG    69      -8.781   4.018   7.536  0.61 11.35           C  
ATOM    574  CD  ARG    69      -8.976   2.762   6.779  0.61 16.48           C  
ATOM    576  NE  ARG    69     -10.115   2.894   5.885  0.61 17.32           N  
ATOM    578  CZ  ARG    69     -10.615   1.895   5.178  0.61 21.59           C  
ATOM    580  NH1 ARG    69     -10.051   0.697   5.246  0.61 26.13           N  
ATOM    582  NH2 ARG    69     -11.671   2.106   4.393  0.61 28.13           N  
ATOM    584  N   ALA    70      -6.461   5.169  11.310  1.00  7.66           N  
ATOM    585  CA  ALA    70      -5.496   5.103  12.415  1.00  7.76           C  
ATOM    586  C   ALA    70      -5.467   3.679  12.936  1.00  7.29           C  
ATOM    587  O   ALA    70      -6.409   3.202  13.557  1.00  8.29           O  
ATOM    588  CB  ALA    70      -5.913   6.079  13.493  1.00  8.97           C  
ATOM    589  N   LEU    71      -4.387   2.974  12.603  1.00  6.50           N  
ATOM    590  CA  LEU    71      -4.237   1.560  12.921  1.00  7.24           C  
ATOM    591  C   LEU    71      -3.357   1.378  14.154  1.00  6.48           C  
ATOM    592  O   LEU    71      -2.228   1.856  14.201  1.00  7.37           O  
ATOM    593  CB  LEU    71      -3.557   0.870  11.729  1.00  7.97           C  
ATOM    594  CG  LEU    71      -3.259  -0.619  11.891  1.00  8.45           C  
ATOM    595  CD1 LEU    71      -4.535  -1.453  11.817  1.00 10.23           C  
ATOM    596  CD2 LEU    71      -2.287  -1.128  10.823  1.00 11.95           C  
ATOM    597  N   ASP    72      -3.857   0.666  15.143  1.00  7.11           N  
ATOM    598  CA  ASP    72      -3.058   0.368  16.333  1.00  6.22           C  
ATOM    599  C   ASP    72      -3.479  -0.977  16.901  1.00  6.55           C  
ATOM    600  O   ASP    72      -4.660  -1.320  16.882  1.00  7.28           O  
ATOM    601  CB  ASP    72      -3.210   1.474  17.369  1.00  7.24           C  
ATOM    602  CG  ASP    72      -2.052   1.496  18.358  1.00  7.04           C  
ATOM    603  OD1 ASP    72      -1.958   0.596  19.211  1.00  7.74           O  
ATOM    604  OD2 ASP    72      -1.204   2.424  18.262  1.00  7.78           O  
ATOM    605  N   PHE    73      -2.521  -1.745  17.392  1.00  6.76           N  
ATOM    606  CA  PHE    73      -2.785  -3.063  17.933  1.00  6.81           C  
ATOM    607  C   PHE    73      -3.192  -3.074  19.382  1.00  6.80           C  
ATOM    608  O   PHE    73      -3.543  -4.141  19.891  1.00  8.21           O  
ATOM    609  CB  PHE    73      -1.632  -4.070  17.627  1.00  7.26           C  
ATOM    610  CG  PHE    73      -0.408  -3.996  18.517  1.00  7.03           C  
ATOM    611  CD1 PHE    73      -0.103  -2.904  19.316  1.00  7.74           C  
ATOM    612  CD2 PHE    73       0.468  -5.064  18.492  1.00  8.56           C  
ATOM    613  CE1 PHE    73       1.057  -2.920  20.091  1.00  8.30           C  
ATOM    614  CE2 PHE    73       1.611  -5.070  19.245  1.00 10.15           C  
ATOM    615  CZ  PHE    73       1.916  -3.997  20.054  1.00  9.14           C  
ATOM    616  N   SER    74      -3.220  -1.909  20.032  1.00  7.40           N  
ATOM    617  CA  SER    74      -3.577  -1.811  21.438  1.00  7.37           C  
ATOM    618  C   SER    74      -4.983  -1.276  21.611  1.00  7.52           C  
ATOM    619  O   SER    74      -5.278  -0.117  21.260  1.00  7.51           O  
ATOM    620  CB  SER    74      -2.592  -0.915  22.189  1.00  8.08           C  
ATOM    621  OG  SER    74      -3.141  -0.600  23.453  1.00  7.86           O  
ATOM    622  N   LYS    75      -5.874  -2.111  22.137  1.00  7.72           N  
ATOM    623  CA  LYS    75      -7.243  -1.709  22.446  0.50  7.68           C  
ATOM    625  C   LYS    75      -7.239  -0.477  23.337  1.00  7.92           C  
ATOM    626  O   LYS    75      -8.090   0.378  23.236  1.00  8.31           O  
ATOM    627  CB  LYS    75      -7.968  -2.849  23.193  0.50  8.60           C  
ATOM    629  CG  LYS    75      -9.367  -2.509  23.636  0.50 12.08           C  
ATOM    631  CD  LYS    75     -10.242  -2.238  22.487  0.50 16.33           C  
ATOM    633  CE  LYS    75     -11.699  -2.068  22.902  0.50 20.58           C  
ATOM    635  NZ  LYS    75     -12.563  -1.881  21.707  0.50 23.27           N  
ATOM    637  N   HIS    76      -6.295  -0.409  24.277  1.00  8.95           N  
ATOM    638  CA  HIS    76      -6.227   0.715  25.224  1.00  9.08           C  
ATOM    639  C   HIS    76      -5.877   2.024  24.535  1.00  9.07           C  
ATOM    640  O   HIS    76      -6.462   3.065  24.834  1.00  9.81           O  
ATOM    641  CB  HIS    76      -5.234   0.422  26.320  1.00 10.32           C  
ATOM    642  CG  HIS    76      -5.512  -0.864  26.956  1.00 12.91           C  
ATOM    643  ND1 HIS    76      -6.633  -1.045  27.719  1.00 14.05           N  
ATOM    644  CD2 HIS    76      -4.936  -2.075  26.818  1.00 14.52           C  
ATOM    645  CE1 HIS    76      -6.696  -2.310  28.103  1.00 17.11           C  
ATOM    646  NE2 HIS    76      -5.683  -2.958  27.554  1.00 16.00           N  
ATOM    647  N   MET    77      -4.961   1.953  23.581  1.00  8.90           N  
ATOM    648  CA  MET    77      -4.631   3.129  22.776  1.00  9.49           C  
ATOM    649  C   MET    77      -5.863   3.537  21.978  1.00  8.75           C  
ATOM    650  O   MET    77      -6.177   4.714  21.870  1.00  9.24           O  
ATOM    651  CB  MET    77      -3.506   2.837  21.793  1.00 10.74           C  
ATOM    652  CG  MET    77      -2.139   2.700  22.390  1.00 10.69           C  
ATOM    653  SD  MET    77      -1.598   4.441  23.137  0.75  9.35          SE  
ATOM    654  CE  MET    77       0.124   3.861  23.515  1.00 15.04           C  
ATOM    655  N   ASN    78      -6.548   2.563  21.394  1.00  8.02           N  
ATOM    656  CA  ASN    78      -7.679   2.871  20.522  1.00  8.28           C  
ATOM    657  C   ASN    78      -8.843   3.499  21.267  1.00  8.77           C  
ATOM    658  O   ASN    78      -9.546   4.359  20.736  1.00  9.68           O  
ATOM    659  CB  ASN    78      -8.073   1.659  19.685  1.00  8.29           C  
ATOM    660  CG  ASN    78      -7.029   1.345  18.643  1.00  8.37           C  
ATOM    661  OD1 ASN    78      -6.336   2.253  18.171  1.00  9.60           O  
ATOM    662  ND2 ASN    78      -6.911   0.096  18.276  1.00  9.01           N  
ATOM    663  N   GLU    79      -9.033   3.088  22.518  1.00  9.15           N  
ATOM    664  CA  GLU    79     -10.096   3.685  23.340  0.53  9.33           C  
ATOM    666  C   GLU    79      -9.804   5.165  23.561  1.00  9.02           C  
ATOM    667  O   GLU    79     -10.703   6.022  23.470  1.00 10.17           O  
ATOM    668  CB  GLU    79     -10.245   2.954  24.677  0.53 10.77           C  
ATOM    670  CG  GLU    79     -10.824   1.545  24.551  0.53 12.41           C  
ATOM    672  CD  GLU    79     -10.675   0.682  25.807  0.53 20.98           C  
ATOM    674  OE1 GLU    79     -10.045   1.116  26.788  0.53 24.38           O  
ATOM    676  OE2 GLU    79     -11.183  -0.455  25.806  0.53 27.07           O  
ATOM    678  N   ILE    80      -8.553   5.487  23.865  1.00  8.61           N  
ATOM    679  CA  ILE    80      -8.171   6.885  24.073  1.00  9.00           C  
ATOM    680  C   ILE    80      -8.276   7.657  22.745  1.00  8.58           C  
ATOM    681  O   ILE    80      -8.730   8.779  22.727  1.00  8.80           O  
ATOM    682  CB  ILE    80      -6.768   7.009  24.660  1.00  9.84           C  
ATOM    683  CG1 ILE    80      -6.757   6.509  26.078  1.00 12.57           C  
ATOM    684  CG2 ILE    80      -6.278   8.439  24.535  1.00 14.37           C  
ATOM    685  CD1 ILE    80      -5.376   6.543  26.731  1.00 15.85           C  
ATOM    686  N   ALA    81      -7.800   7.050  21.663  1.00  8.09           N  
ATOM    687  CA  ALA    81      -7.807   7.734  20.364  1.00  8.26           C  
ATOM    688  C   ALA    81      -9.247   8.071  19.970  1.00  8.09           C  
ATOM    689  O   ALA    81      -9.524   9.139  19.443  1.00  9.02           O  
ATOM    690  CB  ALA    81      -7.123   6.881  19.289  1.00  9.00           C  
ATOM    691  N   LEU    82     -10.168   7.136  20.206  1.00  8.33           N  
ATOM    692  CA  LEU    82     -11.561   7.378  19.867  0.52  9.58           C  
ATOM    694  C   LEU    82     -12.093   8.620  20.584  1.00  9.47           C  
ATOM    695  O   LEU    82     -12.780   9.465  19.999  1.00 10.24           O  
ATOM    696  CB  LEU    82     -12.439   6.151  20.195  0.52 11.15           C  
ATOM    698  CG  LEU    82     -12.276   4.934  19.274  0.52 10.73           C  
ATOM    700  CD1 LEU    82     -12.788   3.634  19.891  0.52 15.40           C  
ATOM    702  CD2 LEU    82     -12.948   5.175  17.927  0.52 10.68           C  
ATOM    704  N   LYS    83     -11.774   8.727  21.865  1.00  9.39           N  
ATOM    705  CA  LYS    83     -12.185   9.866  22.663  1.00 10.85           C  
ATOM    706  C   LYS    83     -11.520  11.129  22.114  1.00  9.83           C  
ATOM    707  O   LYS    83     -12.163  12.168  21.975  1.00 10.35           O  
ATOM    708  CB  LYS    83     -11.818   9.705  24.137  1.00 11.92           C  
ATOM    709  CG  LYS    83     -12.210  10.893  24.977  1.00 17.87           C  
ATOM    710  CD  LYS    83     -11.780  10.785  26.442  1.00 22.59           C  
ATOM    711  CE  LYS    83     -12.327  11.963  27.272  1.00 24.59           C  
ATOM    712  NZ  LYS    83     -11.687  13.294  26.957  1.00 24.18           N  
ATOM    713  N   ASN    84     -10.218  11.069  21.816  1.00  9.60           N  
ATOM    714  CA  ASN    84      -9.518  12.244  21.313  1.00  9.05           C  
ATOM    715  C   ASN    84     -10.066  12.752  19.982  1.00  8.21           C  
ATOM    716  O   ASN    84     -10.231  13.968  19.778  1.00  9.30           O  
ATOM    717  CB  ASN    84      -8.011  11.971  21.175  1.00  8.02           C  
ATOM    718  CG  ASN    84      -7.310  11.857  22.512  1.00  9.68           C  
ATOM    719  OD1 ASN    84      -7.819  12.367  23.524  1.00 11.50           O  
ATOM    720  ND2 ASN    84      -6.142  11.228  22.538  1.00  8.90           N  
ATOM    721  N   ILE    85     -10.366  11.829  19.076  1.00  8.79           N  
ATOM    722  CA  ILE    85     -10.894  12.158  17.771  0.54  7.79           C  
ATOM    724  C   ILE    85     -12.278  12.804  17.903  1.00  8.39           C  
ATOM    725  O   ILE    85     -12.602  13.793  17.243  1.00  9.86           O  
ATOM    726  CB  ILE    85     -10.876  10.913  16.879  0.54  6.47           C  
ATOM    728  CG1 ILE    85      -9.432  10.550  16.556  0.54  9.65           C  
ATOM    730  CG2 ILE    85     -11.584  11.180  15.583  0.54  8.26           C  
ATOM    732  CD1 ILE    85      -9.270   9.157  16.129  0.54 12.10           C  
ATOM    734  N   ALA    86     -13.074  12.230  18.788  1.00  9.18           N  
ATOM    735  CA  ALA    86     -14.424  12.759  19.032  1.00  9.31           C  
ATOM    736  C   ALA    86     -14.342  14.170  19.652  1.00 10.03           C  
ATOM    737  O   ALA    86     -15.078  15.098  19.269  1.00 11.39           O  
ATOM    738  CB  ALA    86     -15.221  11.821  19.931  1.00 11.37           C  
ATOM    739  N   ASP    87     -13.472  14.336  20.634  1.00 10.44           N  
ATOM    740  CA  ASP    87     -13.315  15.623  21.304  1.00 11.59           C  
ATOM    741  C   ASP    87     -12.910  16.684  20.303  1.00 11.12           C  
ATOM    742  O   ASP    87     -13.283  17.840  20.431  1.00 12.81           O  
ATOM    743  CB  ASP    87     -12.240  15.552  22.380  1.00 12.32           C  
ATOM    744  CG  ASP    87     -12.645  14.822  23.637  1.00 15.89           C  
ATOM    745  OD1 ASP    87     -13.825  14.539  23.843  1.00 17.53           O  
ATOM    746  OD2 ASP    87     -11.754  14.535  24.467  1.00 17.49           O  
ATOM    747  N   ALA    88     -12.123  16.299  19.315  1.00 10.27           N  
ATOM    748  CA  ALA    88     -11.632  17.200  18.272  1.00 11.37           C  
ATOM    749  C   ALA    88     -12.626  17.420  17.135  1.00 11.38           C  
ATOM    750  O   ALA    88     -12.344  18.164  16.201  1.00 12.62           O  
ATOM    751  CB  ALA    88     -10.307  16.697  17.698  1.00 11.36           C  
ATOM    752  N   ASP    89     -13.777  16.756  17.208  1.00 10.69           N  
ATOM    753  CA  ASP    89     -14.796  16.825  16.148  0.49 12.07           C  
ATOM    755  C   ASP    89     -14.249  16.319  14.821  1.00 11.64           C  
ATOM    756  O   ASP    89     -14.501  16.912  13.772  1.00 13.00           O  
ATOM    757  CB  ASP    89     -15.345  18.249  15.991  0.49 13.69           C  
ATOM    759  CG  ASP    89     -16.216  18.668  17.160  0.49 15.45           C  
ATOM    761  OD1 ASP    89     -16.952  17.859  17.725  0.49 16.47           O  
ATOM    763  OD2 ASP    89     -16.148  19.942  17.518  0.49 19.08           N  
ATOM    765  N   LEU    90     -13.515  15.208  14.875  1.00 10.06           N  
ATOM    766  CA  LEU    90     -12.896  14.624  13.694  1.00  9.34           C  
ATOM    767  C   LEU    90     -13.303  13.178  13.407  1.00  8.79           C  
ATOM    768  O   LEU    90     -12.630  12.467  12.684  1.00  8.62           O  
ATOM    769  CB  LEU    90     -11.382  14.738  13.810  1.00  9.05           C  
ATOM    770  CG  LEU    90     -10.842  16.157  13.746  1.00 10.32           C  
ATOM    771  CD1 LEU    90      -9.371  16.121  14.137  1.00 12.89           C  
ATOM    772  CD2 LEU    90     -11.040  16.784  12.365  1.00 13.60           C  
ATOM    773  N   ASN    91     -14.418  12.742  13.962  1.00 10.00           N  
ATOM    774  CA  ASN    91     -14.896  11.371  13.717  0.41 10.39           C  
ATOM    777  C   ASN    91     -15.133  11.097  12.255  1.00  9.16           C  
ATOM    778  O   ASN    91     -15.039   9.957  11.810  1.00 10.41           O  
ATOM    779  CB  ASN    91     -16.205  11.067  14.453  0.41 12.20           C  
ATOM    782  CG  ASN    91     -16.051  11.137  15.929  0.41 13.74           C  
ATOM    785  OD1 ASN    91     -14.981  10.839  16.447  0.41 14.20           O  
ATOM    788  ND2 ASN    91     -17.101  11.528  16.625  0.41 15.67           N  
ATOM    791  N   ASP    92     -15.486  12.139  11.525  1.00  8.87           N  
ATOM    792  CA  ASP    92     -15.703  12.038  10.080  1.00  9.57           C  
ATOM    793  C   ASP    92     -14.416  11.908   9.278  1.00  9.19           C  
ATOM    794  O   ASP    92     -14.467  11.547   8.117  1.00 11.83           O  
ATOM    795  CB  ASP    92     -16.464  13.270   9.561  1.00 11.13           C  
ATOM    796  CG  ASP    92     -15.755  14.592   9.875  1.00 12.48           C  
ATOM    797  OD1 ASP    92     -15.213  14.735  10.979  1.00 15.33           O  
ATOM    798  OD2 ASP    92     -15.714  15.498   9.019  1.00 16.48           O  
ATOM    799  N   ARG    93     -13.296  12.252   9.895  1.00  8.70           N  
ATOM    800  CA  ARG    93     -12.004  12.308   9.205  1.00  8.60           C  
ATOM    801  C   ARG    93     -11.094  11.128   9.474  1.00  8.42           C  
ATOM    802  O   ARG    93     -10.192  10.838   8.652  1.00  8.42           O  
ATOM    803  CB  ARG    93     -11.278  13.589   9.583  1.00  8.88           C  
ATOM    804  CG  ARG    93     -12.061  14.879   9.264  1.00 10.10           C  
ATOM    805  CD  ARG    93     -12.375  15.021   7.752  1.00 10.78           C  
ATOM    806  NE  ARG    93     -11.154  14.900   6.981  1.00  9.70           N  
ATOM    807  CZ  ARG    93     -10.140  15.754   7.001  1.00  9.21           C  
ATOM    808  NH1 ARG    93     -10.204  16.913   7.631  1.00 10.09           N  
ATOM    809  NH2 ARG    93      -9.042  15.429   6.379  1.00  9.76           N  
ATOM    810  N   ILE    94     -11.255  10.500  10.639  1.00  7.68           N  
ATOM    811  CA  ILE    94     -10.338   9.492  11.106  1.00  7.34           C  
ATOM    812  C   ILE    94     -11.125   8.296  11.635  1.00  8.11           C  
ATOM    813  O   ILE    94     -11.981   8.427  12.502  1.00 10.46           O  
ATOM    814  CB  ILE    94      -9.452  10.016  12.246  1.00  8.13           C  
ATOM    815  CG1 ILE    94      -8.662  11.242  11.805  1.00  8.13           C  
ATOM    816  CG2 ILE    94      -8.480   8.920  12.750  1.00  8.96           C  
ATOM    817  CD1 ILE    94      -8.146  12.102  12.990  1.00  9.32           C  
ATOM    818  N   GLN    95     -10.845   7.146  11.052  1.00  7.68           N  
ATOM    819  CA  GLN    95     -11.400   5.872  11.482  1.00  7.54           C  
ATOM    820  C   GLN    95     -10.349   5.113  12.264  1.00  8.31           C  
ATOM    821  O   GLN    95      -9.242   4.918  11.759  1.00  9.00           O  
ATOM    822  CB  GLN    95     -11.798   5.024  10.271  1.00  9.36           C  
ATOM    823  CG  GLN    95     -12.374   3.687  10.694  1.00 11.15           C  
ATOM    824  CD  GLN    95     -12.741   2.784   9.532  1.00 15.09           C  
ATOM    825  OE1 GLN    95     -12.534   3.118   8.363  1.00 23.64           O  
ATOM    826  NE2 GLN    95     -13.323   1.631   9.849  1.00 21.71           N  
ATOM    827  N   ILE    96     -10.674   4.684  13.476  1.00  8.48           N  
ATOM    828  CA  ILE    96      -9.758   3.892  14.281  1.00  9.41           C  
ATOM    829  C   ILE    96      -9.917   2.438  13.865  1.00 10.76           C  
ATOM    830  O   ILE    96     -11.026   1.924  13.776  1.00 14.33           O  
ATOM    831  CB  ILE    96     -10.047   4.124  15.794  1.00 11.62           C  
ATOM    832  CG1 ILE    96      -9.938   5.621  16.183  1.00 14.56           C  
ATOM    833  CG2 ILE    96      -9.151   3.290  16.653  1.00 15.64           C  
ATOM    834  CD1 ILE    96      -8.660   6.355  15.883  1.00 20.14           C  
ATOM    835  N   VAL    97      -8.783   1.797  13.584  1.00  9.63           N  
ATOM    836  CA  VAL    97      -8.751   0.395  13.166  1.00 10.25           C  
ATOM    837  C   VAL    97      -7.899  -0.417  14.134  1.00  9.21           C  
ATOM    838  O   VAL    97      -6.724  -0.152  14.346  1.00  9.63           O  
ATOM    839  CB  VAL    97      -8.192   0.290  11.745  1.00 10.48           C  
ATOM    840  CG1 VAL    97      -8.176  -1.145  11.280  1.00 13.10           C  
ATOM    841  CG2 VAL    97      -8.964   1.213  10.794  1.00 12.97           C  
ATOM    842  N   GLN    98      -8.528  -1.405  14.729  1.00  8.92           N  
ATOM    843  CA  GLN    98      -7.858  -2.314  15.644  1.00  8.81           C  
ATOM    844  C   GLN    98      -7.120  -3.331  14.800  1.00  8.74           C  
ATOM    845  O   GLN    98      -7.738  -4.084  14.040  1.00 11.10           O  
ATOM    846  CB  GLN    98      -8.911  -2.983  16.547  1.00  9.76           C  
ATOM    847  CG  GLN    98      -8.408  -3.986  17.507  1.00 12.22           C  
ATOM    848  CD  GLN    98      -7.655  -3.356  18.635  1.00 12.03           C  
ATOM    849  OE1 GLN    98      -8.102  -2.368  19.246  1.00 14.32           O  
ATOM    850  NE2 GLN    98      -6.489  -3.935  18.947  1.00 13.93           N  
ATOM    851  N   GLY    99      -5.803  -3.371  14.870  1.00  8.36           N  
ATOM    852  CA  GLY    99      -5.061  -4.339  14.094  1.00  8.48           C  
ATOM    853  C   GLY    99      -3.575  -4.113  14.186  1.00  7.51           C  
ATOM    854  O   GLY    99      -3.088  -3.169  14.776  1.00  8.37           O  
ATOM    855  N   ASP   100      -2.856  -5.022  13.555  1.00  9.15           N  
ATOM    856  CA  ASP   100      -1.406  -5.155  13.640  1.00  8.65           C  
ATOM    857  C   ASP   100      -0.763  -4.958  12.280  1.00  8.18           C  
ATOM    858  O   ASP   100      -1.281  -5.423  11.245  1.00  8.84           O  
ATOM    859  CB  ASP   100      -1.120  -6.598  14.152  1.00 10.11           C  
ATOM    860  CG  ASP   100       0.258  -6.814  14.679  1.00 10.02           C  
ATOM    861  OD1 ASP   100       1.245  -6.493  13.994  1.00  9.84           O  
ATOM    862  OD2 ASP   100       0.370  -7.312  15.827  1.00 11.81           O  
ATOM    863  N   VAL   101       0.370  -4.265  12.274  1.00  7.91           N  
ATOM    864  CA  VAL   101       1.136  -4.015  11.059  1.00  8.03           C  
ATOM    865  C   VAL   101       1.521  -5.325  10.343  1.00  8.12           C  
ATOM    866  O   VAL   101       1.772  -5.334   9.147  1.00  8.41           O  
ATOM    867  CB  VAL   101       2.393  -3.156  11.367  1.00  7.51           C  
ATOM    868  CG1 VAL   101       3.426  -3.915  12.194  1.00  8.68           C  
ATOM    869  CG2 VAL   101       2.983  -2.609  10.063  1.00  7.72           C  
ATOM    870  N   HIS   102       1.564  -6.427  11.087  1.00  8.09           N  
ATOM    871  CA  HIS   102       1.951  -7.701  10.481  1.00  9.26           C  
ATOM    872  C   HIS   102       0.804  -8.396   9.777  1.00  9.67           C  
ATOM    873  O   HIS   102       1.015  -9.439   9.151  1.00 11.32           O  
ATOM    874  CB  HIS   102       2.540  -8.660  11.508  1.00  9.93           C  
ATOM    875  CG  HIS   102       3.762  -8.134  12.176  1.00 10.27           C  
ATOM    876  ND1 HIS   102       3.700  -7.419  13.347  1.00 10.22           N  
ATOM    877  CD2 HIS   102       5.064  -8.137  11.803  1.00 11.57           C  
ATOM    878  CE1 HIS   102       4.929  -7.066  13.697  1.00 10.76           C  
ATOM    879  NE2 HIS   102       5.772  -7.483  12.776  1.00 12.79           N  
ATOM    880  N   ASN   103      -0.401  -7.845   9.864  1.00  8.87           N  
ATOM    881  CA  ASN   103      -1.562  -8.444   9.214  1.00  9.43           C  
ATOM    882  C   ASN   103      -2.628  -7.361   9.105  1.00  9.27           C  
ATOM    883  O   ASN   103      -3.615  -7.331   9.823  1.00 10.60           O  
ATOM    884  CB  ASN   103      -2.025  -9.649  10.024  1.00 10.11           C  
ATOM    885  CG  ASN   103      -3.163 -10.342   9.372  1.00 12.51           C  
ATOM    886  OD1 ASN   103      -3.107 -10.581   8.180  1.00 16.56           O  
ATOM    887  ND2 ASN   103      -4.194 -10.712  10.143  1.00 15.23           N  
ATOM    888  N   ILE   104      -2.375  -6.437   8.199  1.00  9.26           N  
ATOM    889  CA  ILE   104      -3.174  -5.215   8.139  1.00  9.26           C  
ATOM    890  C   ILE   104      -4.531  -5.478   7.509  1.00  9.79           C  
ATOM    891  O   ILE   104      -4.590  -5.997   6.394  1.00 10.42           O  
ATOM    892  CB  ILE   104      -2.441  -4.112   7.342  1.00  8.65           C  
ATOM    893  CG1 ILE   104      -1.059  -3.842   7.938  1.00  9.12           C  
ATOM    894  CG2 ILE   104      -3.309  -2.825   7.312  1.00 10.10           C  
ATOM    895  CD1 ILE   104      -0.191  -2.832   7.128  1.00  9.92           C  
ATOM    896  N   PRO   105      -5.622  -5.109   8.191  1.00 10.93           N  
ATOM    897  CA  PRO   105      -6.983  -5.393   7.678  1.00 12.42           C  
ATOM    898  C   PRO   105      -7.459  -4.339   6.695  1.00 12.67           C  
ATOM    899  O   PRO   105      -8.493  -3.688   6.872  1.00 15.50           O  
ATOM    900  CB  PRO   105      -7.825  -5.406   8.949  1.00 14.01           C  
ATOM    901  CG  PRO   105      -7.205  -4.354   9.782  1.00 14.91           C  
ATOM    902  CD  PRO   105      -5.690  -4.524   9.549  1.00 12.35           C  
ATOM    903  N   ILE   106      -6.643  -4.177   5.668  1.00 11.77           N  
ATOM    904  CA  ILE   106      -6.881  -3.223   4.588  0.67 11.84           C  
ATOM    906  C   ILE   106      -6.548  -3.916   3.271  1.00 11.58           C  
ATOM    907  O   ILE   106      -5.611  -4.719   3.199  1.00 11.45           O  
ATOM    908  CB  ILE   106      -6.038  -1.927   4.810  0.67 11.08           C  
ATOM    910  CG1 ILE   106      -6.460  -1.241   6.115  0.67 11.15           C  
ATOM    912  CG2 ILE   106      -6.165  -0.965   3.623  0.67 13.85           C  
ATOM    914  CD1 ILE   106      -5.566  -0.069   6.504  0.67 12.34           C  
ATOM    916  N   GLU   107      -7.332  -3.611   2.246  1.00 12.90           N  
ATOM    917  CA  GLU   107      -7.126  -4.227   0.943  1.00 13.99           C  
ATOM    918  C   GLU   107      -5.833  -3.800   0.268  1.00 12.73           C  
ATOM    919  O   GLU   107      -5.212  -2.789   0.589  1.00 12.05           O  
ATOM    920  CB  GLU   107      -8.312  -3.989  -0.008  1.00 17.33           C  
ATOM    921  CG  GLU   107      -8.524  -2.583  -0.495  1.00 22.38           C  
ATOM    922  CD  GLU   107      -9.760  -2.476  -1.402  1.00 28.40           C  
ATOM    923  OE1 GLU   107     -10.717  -3.260  -1.216  1.00 33.83           O  
ATOM    924  OE2 GLU   107      -9.785  -1.617  -2.297  1.00 30.51           O  
ATOM    925  N   ASP   108      -5.464  -4.590  -0.712  1.00 12.22           N  
ATOM    926  CA  ASP   108      -4.290  -4.320  -1.513  1.00 12.45           C  
ATOM    927  C   ASP   108      -4.400  -2.958  -2.213  1.00 10.68           C  
ATOM    928  O   ASP   108      -5.476  -2.568  -2.677  1.00 12.03           O  
ATOM    929  CB  ASP   108      -4.134  -5.335  -2.645  1.00 13.84           C  
ATOM    930  CG  ASP   108      -3.947  -6.776  -2.178  1.00 16.95           C  
ATOM    931  OD1 ASP   108      -3.780  -7.071  -0.986  1.00 13.62           O  
ATOM    932  OD2 ASP   108      -3.970  -7.651  -3.071  1.00 20.93           O  
ATOM    933  N   ASN   109      -3.273  -2.250  -2.290  1.00 10.55           N  
ATOM    934  CA  ASN   109      -3.160  -1.049  -3.140  1.00 11.25           C  
ATOM    935  C   ASN   109      -4.129   0.053  -2.789  1.00 11.87           C  
ATOM    936  O   ASN   109      -4.549   0.799  -3.650  1.00 16.02           O  
ATOM    937  CB  ASN   109      -3.354  -1.459  -4.608  1.00 11.88           C  
ATOM    938  CG  ASN   109      -2.355  -2.481  -5.039  1.00 13.39           C  
ATOM    939  OD1 ASN   109      -1.186  -2.404  -4.683  1.00 15.54           O  
ATOM    940  ND2 ASN   109      -2.795  -3.450  -5.846  1.00 15.63           N  
ATOM    941  N   TYR   110      -4.427   0.176  -1.516  1.00 10.52           N  
ATOM    942  CA  TYR   110      -5.407   1.106  -1.017  1.00 10.42           C  
ATOM    943  C   TYR   110      -4.907   2.506  -0.669  1.00  8.87           C  
ATOM    944  O   TYR   110      -5.642   3.483  -0.873  1.00  9.76           O  
ATOM    945  CB  TYR   110      -6.053   0.510   0.246  1.00 12.46           C  
ATOM    946  CG  TYR   110      -7.104   1.377   0.887  1.00 14.30           C  
ATOM    947  CD1 TYR   110      -8.381   1.387   0.390  1.00 18.22           C  
ATOM    948  CD2 TYR   110      -6.805   2.179   1.988  1.00 15.21           C  
ATOM    949  CE1 TYR   110      -9.366   2.194   0.960  1.00 20.62           C  
ATOM    950  CE2 TYR   110      -7.772   2.978   2.562  1.00 17.07           C  
ATOM    951  CZ  TYR   110      -9.041   2.971   2.048  1.00 17.95           C  
ATOM    952  OH  TYR   110      -9.980   3.781   2.629  1.00 22.89           O  
ATOM    953  N   ALA   111      -3.706   2.608  -0.106  1.00  7.93           N  
ATOM    954  CA  ALA   111      -3.256   3.832   0.534  1.00  7.78           C  
ATOM    955  C   ALA   111      -2.441   4.734  -0.382  1.00  7.24           C  
ATOM    956  O   ALA   111      -1.429   4.325  -0.913  1.00  8.08           O  
ATOM    957  CB  ALA   111      -2.384   3.448   1.772  1.00  8.73           C  
ATOM    958  N   ASP   112      -2.847   5.979  -0.465  1.00  7.19           N  
ATOM    959  CA  ASP   112      -2.016   6.980  -1.132  1.00  7.38           C  
ATOM    960  C   ASP   112      -0.779   7.364  -0.324  1.00  6.64           C  
ATOM    961  O   ASP   112       0.254   7.715  -0.874  1.00  8.16           O  
ATOM    962  CB  ASP   112      -2.863   8.227  -1.419  1.00  8.05           C  
ATOM    963  CG  ASP   112      -3.992   7.941  -2.393  1.00  9.94           C  
ATOM    964  OD1 ASP   112      -3.699   7.605  -3.563  1.00 14.44           O  
ATOM    965  OD2 ASP   112      -5.149   8.049  -1.998  1.00 11.64           O  
ATOM    966  N   LEU   113      -0.933   7.323   0.986  1.00  6.67           N  
ATOM    967  CA  LEU   113       0.098   7.729   1.930  1.00  6.74           C  
ATOM    968  C   LEU   113       0.039   6.863   3.163  1.00  5.77           C  
ATOM    969  O   LEU   113      -1.041   6.579   3.653  1.00  6.67           O  
ATOM    970  CB  LEU   113      -0.100   9.189   2.342  1.00  7.25           C  
ATOM    971  CG  LEU   113       0.868   9.769   3.363  1.00  8.21           C  
ATOM    972  CD1 LEU   113       2.308   9.837   2.842  1.00  9.19           C  
ATOM    973  CD2 LEU   113       0.358  11.175   3.810  1.00 10.58           C  
ATOM    974  N   ILE   114       1.187   6.389   3.617  1.00  5.65           N  
ATOM    975  CA  ILE   114       1.290   5.643   4.870  1.00  5.52           C  
ATOM    976  C   ILE   114       2.287   6.367   5.751  1.00  6.04           C  
ATOM    977  O   ILE   114       3.442   6.581   5.348  1.00  7.49           O  
ATOM    978  CB  ILE   114       1.729   4.181   4.657  1.00  6.16           C  
ATOM    979  CG1 ILE   114       0.757   3.469   3.721  1.00  7.43           C  
ATOM    980  CG2 ILE   114       1.897   3.471   5.972  1.00  7.77           C  
ATOM    981  CD1 ILE   114       1.197   2.051   3.299  1.00  8.26           C  
ATOM    982  N   VAL   115       1.852   6.746   6.949  1.00  5.68           N  
ATOM    983  CA  VAL   115       2.699   7.415   7.911  1.00  6.11           C  
ATOM    984  C   VAL   115       2.771   6.585   9.188  1.00  5.70           C  
ATOM    985  O   VAL   115       1.896   5.796   9.471  1.00  6.47           O  
ATOM    986  CB  VAL   115       2.175   8.852   8.227  1.00  7.08           C  
ATOM    987  CG1 VAL   115       2.042   9.681   6.939  1.00  8.57           C  
ATOM    988  CG2 VAL   115       0.842   8.828   8.995  1.00  8.27           C  
ATOM    989  N   SER   116       3.828   6.784   9.961  1.00  6.22           N  
ATOM    990  CA  SER   116       3.959   6.117  11.254  1.00  6.34           C  
ATOM    991  C   SER   116       5.050   6.795  12.050  1.00  6.36           C  
ATOM    992  O   SER   116       6.172   6.958  11.554  1.00  6.83           O  
ATOM    993  CB  SER   116       4.370   4.687  11.048  1.00  7.27           C  
ATOM    994  OG  SER   116       4.530   4.002  12.275  1.00  7.35           O  
ATOM    995  N   ARG   117       4.725   7.183  13.288  1.00  5.94           N  
ATOM    996  CA  ARG   117       5.689   7.793  14.190  1.00  6.28           C  
ATOM    997  C   ARG   117       5.848   6.963  15.427  1.00  6.61           C  
ATOM    998  O   ARG   117       4.872   6.634  16.100  1.00  8.17           O  
ATOM    999  CB  ARG   117       5.271   9.209  14.597  1.00  6.35           C  
ATOM   1000  CG  ARG   117       6.278   9.874  15.491  1.00  7.49           C  
ATOM   1001  CD  ARG   117       5.787  11.216  16.100  1.00  7.54           C  
ATOM   1002  NE  ARG   117       6.813  11.705  16.992  1.00  8.26           N  
ATOM   1003  CZ  ARG   117       7.035  11.197  18.209  1.00  8.17           C  
ATOM   1004  NH1 ARG   117       6.177  10.346  18.728  1.00  9.56           N  
ATOM   1005  NH2 ARG   117       8.084  11.585  18.897  1.00  9.70           N  
ATOM   1006  N   GLY   118       7.080   6.679  15.792  0.50  6.73           N  
ATOM   1008  CA  GLY   118       7.345   6.035  17.059  0.50  7.78           C  
ATOM   1010  C   GLY   118       6.883   4.622  17.261  0.50  7.67           C  
ATOM   1012  O   GLY   118       6.770   4.211  18.414  0.50  8.95           O  
ATOM   1014  N   SER   119       6.488   3.932  16.189  1.00  9.05           N  
ATOM   1015  CA  SER   119       6.063   2.545  16.230  1.00  7.91           C  
ATOM   1016  C   SER   119       7.072   1.539  15.673  1.00  8.02           C  
ATOM   1017  O   SER   119       7.247   0.464  16.249  1.00  8.54           O  
ATOM   1018  CB  SER   119       4.719   2.482  15.496  1.00  9.18           C  
ATOM   1019  OG  SER   119       4.007   1.292  15.769  1.00  8.94           O  
ATOM   1020  N   VAL   120       7.744   1.903  14.581  1.00  7.52           N  
ATOM   1021  CA  VAL   120       8.625   0.982  13.893  1.00  7.57           C  
ATOM   1022  C   VAL   120       9.710   0.407  14.782  1.00  8.43           C  
ATOM   1023  O   VAL   120      10.150  -0.710  14.566  1.00  9.93           O  
ATOM   1024  CB  VAL   120       9.231   1.645  12.614  1.00  7.75           C  
ATOM   1025  CG1 VAL   120      10.155   2.803  12.967  1.00  8.23           C  
ATOM   1026  CG2 VAL   120       9.943   0.616  11.742  1.00  9.64           C  
ATOM   1027  N   PHE   121      10.139   1.180  15.778  1.00  7.65           N  
ATOM   1028  CA  PHE   121      11.227   0.789  16.672  1.00  8.29           C  
ATOM   1029  C   PHE   121      10.838  -0.354  17.590  1.00  9.16           C  
ATOM   1030  O   PHE   121      11.701  -0.978  18.191  1.00 11.83           O  
ATOM   1031  CB  PHE   121      11.701   2.005  17.476  1.00  9.11           C  
ATOM   1032  CG  PHE   121      12.051   3.175  16.614  1.00  8.92           C  
ATOM   1033  CD1 PHE   121      13.062   3.123  15.690  1.00 10.11           C  
ATOM   1034  CD2 PHE   121      11.303   4.311  16.678  1.00 10.96           C  
ATOM   1035  CE1 PHE   121      13.337   4.198  14.883  1.00 11.17           C  
ATOM   1036  CE2 PHE   121      11.568   5.396  15.858  1.00 12.91           C  
ATOM   1037  CZ  PHE   121      12.584   5.339  14.977  1.00 12.80           C  
ATOM   1038  N   PHE   122       9.549  -0.654  17.658  1.00  8.40           N  
ATOM   1039  CA  PHE   122       9.036  -1.735  18.507  1.00 10.10           C  
ATOM   1040  C   PHE   122       8.657  -2.996  17.732  1.00 10.76           C  
ATOM   1041  O   PHE   122       8.508  -4.058  18.336  1.00 15.74           O  
ATOM   1042  CB  PHE   122       7.786  -1.274  19.286  1.00  9.79           C  
ATOM   1043  CG  PHE   122       8.044  -0.136  20.228  1.00  8.46           C  
ATOM   1044  CD1 PHE   122       8.756  -0.318  21.398  1.00  9.80           C  
ATOM   1045  CD2 PHE   122       7.549   1.121  19.968  1.00  8.61           C  
ATOM   1046  CE1 PHE   122       8.932   0.778  22.286  1.00 10.79           C  
ATOM   1047  CE2 PHE   122       7.722   2.159  20.830  1.00 10.41           C  
ATOM   1048  CZ  PHE   122       8.448   1.998  21.964  1.00 10.35           C  
ATOM   1049  N   TRP   123       8.480  -2.918  16.427  1.00 10.63           N  
ATOM   1050  CA  TRP   123       7.933  -4.056  15.695  1.00 10.83           C  
ATOM   1051  C   TRP   123       8.798  -5.278  15.710  1.00 11.50           C  
ATOM   1052  O   TRP   123       9.982  -5.188  15.477  1.00 11.52           O  
ATOM   1053  CB  TRP   123       7.615  -3.724  14.220  1.00 10.25           C  
ATOM   1054  CG  TRP   123       6.671  -2.596  14.046  1.00  9.23           C  
ATOM   1055  CD1 TRP   123       5.778  -2.098  14.966  1.00  9.94           C  
ATOM   1056  CD2 TRP   123       6.501  -1.807  12.865  1.00  9.22           C  
ATOM   1057  NE1 TRP   123       5.085  -1.041  14.431  1.00 10.84           N  
ATOM   1058  CE2 TRP   123       5.541  -0.818  13.156  1.00  8.27           C  
ATOM   1059  CE3 TRP   123       7.075  -1.821  11.599  1.00  9.17           C  
ATOM   1060  CZ2 TRP   123       5.148   0.123  12.214  1.00  9.88           C  
ATOM   1061  CZ3 TRP   123       6.705  -0.862  10.681  1.00 10.31           C  
ATOM   1062  CH2 TRP   123       5.753   0.096  10.996  1.00  9.71           C  
ATOM   1063  N   GLU   124       8.162  -6.414  15.977  1.00 11.93           N  
ATOM   1064  CA  GLU   124       8.804  -7.719  15.871  0.50 13.50           C  
ATOM   1066  C   GLU   124       8.807  -8.022  14.343  1.00 13.77           C  
ATOM   1067  O   GLU   124       8.147  -7.340  13.608  1.00 15.88           O  
ATOM   1068  CB  GLU   124       7.964  -8.760  16.664  0.50 14.72           C  
ATOM   1070  CG  GLU   124       7.881  -8.458  18.169  0.50 19.73           C  
ATOM   1072  CD  GLU   124       6.848  -9.303  18.942  0.50 22.67           C  
ATOM   1074  OE1 GLU   124       6.138 -10.144  18.336  0.50 21.97           O  
ATOM   1076  OE2 GLU   124       6.743  -9.103  20.176  0.50 24.70           O  
ATOM   1078  N   ASP   125       9.537  -8.988  13.834  1.00 16.25           N  
ATOM   1079  CA  ASP   125       9.376  -9.299  12.398  1.00 11.58           C  
ATOM   1080  C   ASP   125       9.118  -8.159  11.382  1.00 10.07           C  
ATOM   1081  O   ASP   125       8.089  -8.079  10.691  1.00  9.50           O  
ATOM   1082  CB  ASP   125       8.298 -10.362  12.241  1.00 11.92           C  
ATOM   1083  CG  ASP   125       8.424 -11.094  10.925  1.00 10.36           C  
ATOM   1084  OD1 ASP   125       9.361 -10.777  10.144  1.00 12.78           O  
ATOM   1085  OD2 ASP   125       7.558 -11.943  10.656  1.00 12.56           O  
ATOM   1086  N   VAL   126      10.140  -7.333  11.250  1.00  9.61           N  
ATOM   1087  CA  VAL   126      10.030  -6.169  10.391  0.82  8.89           C  
ATOM   1089  C   VAL   126       9.921  -6.518   8.908  1.00  8.30           C  
ATOM   1090  O   VAL   126       9.327  -5.754   8.155  1.00  8.51           O  
ATOM   1091  CB  VAL   126      11.111  -5.126  10.654  0.82  9.68           C  
ATOM   1093  CG1 VAL   126      10.883  -4.500  12.054  0.82 11.15           C  
ATOM   1095  CG2 VAL   126      12.502  -5.701  10.517  0.82 10.67           C  
ATOM   1097  N   THR   127      10.460  -7.660   8.491  1.00  8.00           N  
ATOM   1098  CA  THR   127      10.320  -8.063   7.084  1.00  7.90           C  
ATOM   1099  C   THR   127       8.839  -8.233   6.748  1.00  8.19           C  
ATOM   1100  O   THR   127       8.355  -7.760   5.719  1.00  8.41           O  
ATOM   1101  CB  THR   127      11.069  -9.352   6.808  1.00 10.87           C  
ATOM   1102  N   THR   128       8.110  -8.942   7.601  1.00  7.52           N  
ATOM   1103  CA  THR   128       6.695  -9.148   7.386  1.00  7.95           C  
ATOM   1104  C   THR   128       5.935  -7.825   7.439  1.00  7.92           C  
ATOM   1105  O   THR   128       5.034  -7.573   6.625  1.00  8.44           O  
ATOM   1106  CB  THR   128       6.130 -10.147   8.402  1.00  9.79           C  
ATOM   1107  OG1 THR   128       6.767 -11.405   8.181  1.00 10.06           O  
ATOM   1108  CG2 THR   128       4.608 -10.286   8.313  1.00 11.49           C  
ATOM   1109  N   ALA   129       6.289  -6.980   8.393  1.00  7.72           N  
ATOM   1110  CA  ALA   129       5.626  -5.676   8.532  1.00  7.74           C  
ATOM   1111  C   ALA   129       5.776  -4.862   7.243  1.00  7.05           C  
ATOM   1112  O   ALA   129       4.816  -4.300   6.751  1.00  7.71           O  
ATOM   1113  CB  ALA   129       6.207  -4.909   9.705  1.00  8.15           C  
ATOM   1114  N   PHE   130       6.995  -4.789   6.706  1.00  7.37           N  
ATOM   1115  CA  PHE   130       7.212  -4.018   5.487  1.00  7.45           C  
ATOM   1116  C   PHE   130       6.612  -4.628   4.238  1.00  7.36           C  
ATOM   1117  O   PHE   130       6.203  -3.912   3.349  1.00  7.74           O  
ATOM   1118  CB  PHE   130       8.674  -3.598   5.341  1.00  7.32           C  
ATOM   1119  CG  PHE   130       8.978  -2.364   6.166  1.00  7.34           C  
ATOM   1120  CD1 PHE   130       8.687  -1.097   5.678  1.00  8.48           C  
ATOM   1121  CD2 PHE   130       9.426  -2.475   7.473  1.00  8.55           C  
ATOM   1122  CE1 PHE   130       8.887   0.015   6.465  1.00  9.14           C  
ATOM   1123  CE2 PHE   130       9.623  -1.357   8.257  1.00  9.73           C  
ATOM   1124  CZ  PHE   130       9.347  -0.118   7.751  1.00  9.56           C  
ATOM   1125  N   ARG   131       6.492  -5.946   4.179  1.00  7.37           N  
ATOM   1126  CA  ARG   131       5.727  -6.571   3.093  1.00  7.62           C  
ATOM   1127  C   ARG   131       4.263  -6.164   3.158  1.00  7.56           C  
ATOM   1128  O   ARG   131       3.634  -5.914   2.126  1.00  8.19           O  
ATOM   1129  CB  ARG   131       5.892  -8.091   3.103  1.00  7.21           C  
ATOM   1130  CG  ARG   131       7.254  -8.524   2.540  1.00  8.66           C  
ATOM   1131  CD  ARG   131       7.352 -10.056   2.457  1.00  8.42           C  
ATOM   1132  NE  ARG   131       8.440 -10.466   1.588  1.00  9.16           N  
ATOM   1133  CZ  ARG   131       9.687 -10.589   1.960  1.00  9.13           C  
ATOM   1134  NH1 ARG   131      10.036 -10.523   3.221  1.00 11.02           N  
ATOM   1135  NH2 ARG   131      10.621 -10.811   1.041  1.00  9.82           N  
ATOM   1136  N   GLU   132       3.713  -6.106   4.372  1.00  7.44           N  
ATOM   1137  CA  GLU   132       2.309  -5.665   4.518  1.00  7.89           C  
ATOM   1138  C   GLU   132       2.126  -4.197   4.125  1.00  7.73           C  
ATOM   1139  O   GLU   132       1.162  -3.815   3.468  1.00  8.05           O  
ATOM   1140  CB  GLU   132       1.816  -5.911   5.957  1.00  8.39           C  
ATOM   1141  CG  GLU   132       1.390  -7.325   6.199  1.00  9.26           C  
ATOM   1142  CD  GLU   132       0.113  -7.614   5.431  1.00  9.17           C  
ATOM   1143  OE1 GLU   132      -0.984  -7.205   5.892  1.00 10.47           O  
ATOM   1144  OE2 GLU   132       0.199  -8.204   4.337  1.00  9.94           O  
ATOM   1145  N   ILE   133       3.051  -3.352   4.574  1.00  7.41           N  
ATOM   1146  CA  ILE   133       3.039  -1.941   4.222  1.00  7.93           C  
ATOM   1147  C   ILE   133       3.071  -1.791   2.710  1.00  7.75           C  
ATOM   1148  O   ILE   133       2.316  -1.018   2.119  1.00  8.20           O  
ATOM   1149  CB  ILE   133       4.202  -1.217   4.909  1.00  7.60           C  
ATOM   1150  CG1 ILE   133       3.890  -1.130   6.410  1.00  7.93           C  
ATOM   1151  CG2 ILE   133       4.464   0.166   4.313  1.00  8.43           C  
ATOM   1152  CD1 ILE   133       5.100  -0.804   7.300  1.00  9.23           C  
ATOM   1153  N   TYR   134       3.951  -2.537   2.057  1.00  7.52           N  
ATOM   1154  CA  TYR   134       4.042  -2.425   0.607  1.00  7.77           C  
ATOM   1155  C   TYR   134       2.772  -2.933  -0.056  1.00  8.48           C  
ATOM   1156  O   TYR   134       2.344  -2.357  -1.071  1.00  8.98           O  
ATOM   1157  CB  TYR   134       5.282  -3.144   0.070  1.00  8.17           C  
ATOM   1158  CG  TYR   134       5.763  -2.642  -1.268  1.00  8.07           C  
ATOM   1159  CD1 TYR   134       6.219  -1.348  -1.396  1.00  9.13           C  
ATOM   1160  CD2 TYR   134       5.800  -3.438  -2.384  1.00 10.07           C  
ATOM   1161  CE1 TYR   134       6.716  -0.861  -2.558  1.00 10.00           C  
ATOM   1162  CE2 TYR   134       6.331  -2.955  -3.606  1.00 10.31           C  
ATOM   1163  CZ  TYR   134       6.784  -1.660  -3.665  1.00  9.15           C  
ATOM   1164  OH  TYR   134       7.277  -1.111  -4.831  1.00 10.03           O  
ATOM   1165  N   ARG   135       2.174  -3.994   0.507  1.00  8.18           N  
ATOM   1166  CA  ARG   135       0.976  -4.538  -0.063  1.00  9.41           C  
ATOM   1167  C   ARG   135      -0.168  -3.521  -0.105  1.00  8.81           C  
ATOM   1168  O   ARG   135      -0.911  -3.436  -1.102  1.00  9.48           O  
ATOM   1169  CB  ARG   135       0.537  -5.789   0.708  1.00  9.49           C  
ATOM   1170  CG  ARG   135      -0.741  -6.408   0.167  1.00  9.61           C  
ATOM   1171  CD  ARG   135      -1.222  -7.593   1.016  1.00 10.56           C  
ATOM   1172  NE  ARG   135      -1.602  -7.228   2.373  1.00 10.04           N  
ATOM   1173  CZ  ARG   135      -2.723  -6.591   2.702  1.00 11.05           C  
ATOM   1174  NH1 ARG   135      -3.607  -6.225   1.787  1.00 10.99           N  
ATOM   1175  NH2 ARG   135      -2.950  -6.308   3.985  1.00 11.47           N  
ATOM   1176  N   ILE   136      -0.348  -2.788   0.993  1.00  8.02           N  
ATOM   1177  CA  ILE   136      -1.481  -1.869   1.094  1.00  8.77           C  
ATOM   1178  C   ILE   136      -1.229  -0.509   0.424  1.00  8.64           C  
ATOM   1179  O   ILE   136      -2.140   0.279   0.270  1.00 10.16           O  
ATOM   1180  CB  ILE   136      -1.964  -1.672   2.562  1.00  8.62           C  
ATOM   1181  CG1 ILE   136      -0.901  -0.989   3.433  1.00  9.51           C  
ATOM   1182  CG2 ILE   136      -2.444  -3.012   3.170  1.00 10.74           C  
ATOM   1183  CD1 ILE   136      -1.474  -0.170   4.556  1.00 10.37           C  
ATOM   1184  N   LEU   137       0.004  -0.220   0.057  1.00  8.25           N  
ATOM   1185  CA  LEU   137       0.379   1.019  -0.607  1.00  8.41           C  
ATOM   1186  C   LEU   137      -0.077   0.986  -2.072  1.00  8.83           C  
ATOM   1187  O   LEU   137       0.149   0.008  -2.782  1.00 10.37           O  
ATOM   1188  CB  LEU   137       1.916   1.175  -0.521  1.00  8.67           C  
ATOM   1189  CG  LEU   137       2.524   2.497  -0.967  1.00  9.05           C  
ATOM   1190  CD1 LEU   137       1.952   3.672  -0.154  1.00  9.55           C  
ATOM   1191  CD2 LEU   137       4.052   2.432  -0.820  1.00  9.56           C  
ATOM   1192  N   LYS   138      -0.700   2.077  -2.498  0.57  8.62           N  
ATOM   1194  CA  LYS   138      -1.125   2.244  -3.871  0.57  9.34           C  
ATOM   1196  C   LYS   138       0.093   2.534  -4.750  0.57 10.25           C  
ATOM   1198  O   LYS   138       1.030   3.220  -4.345  0.57  9.47           O  
ATOM   1200  CB  LYS   138      -2.136   3.405  -3.979  0.57  9.61           C  
ATOM   1202  CG  LYS   138      -2.873   3.440  -5.298  0.57 10.76           C  
ATOM   1204  CD  LYS   138      -3.817   4.658  -5.366  0.57 12.36           C  
ATOM   1206  CE  LYS   138      -4.828   4.646  -4.271  0.57 14.49           C  
ATOM   1208  NZ  LYS   138      -5.760   5.780  -4.509  0.57 18.01           N  
ATOM   1210  N   SER   139       0.064   2.008  -5.966  0.57 10.87           N  
ATOM   1212  CA  SER   139       1.083   2.343  -6.950  0.57 12.67           C  
ATOM   1214  C   SER   139       1.123   3.868  -7.065  0.57 11.08           C  
ATOM   1216  O   SER   139       0.103   4.527  -7.272  0.57 12.04           O  
ATOM   1218  CB  SER   139       0.766   1.684  -8.296  0.57 14.08           C  
ATOM   1220  OG  SER   139       1.772   1.944  -9.248  0.57 19.45           O  
ATOM   1222  N   GLY   140       2.320   4.420  -6.967  1.00 11.25           N  
ATOM   1223  CA  GLY   140       2.540   5.857  -6.908  1.00 11.39           C  
ATOM   1224  C   GLY   140       2.460   6.449  -5.516  1.00 12.04           C  
ATOM   1225  O   GLY   140       2.731   7.613  -5.331  1.00 14.89           O  
ATOM   1226  N   GLY   141       2.097   5.630  -4.543  1.00 10.70           N  
ATOM   1227  CA  GLY   141       1.996   6.029  -3.148  1.00  9.69           C  
ATOM   1228  C   GLY   141       3.340   6.229  -2.482  1.00 10.19           C  
ATOM   1229  O   GLY   141       4.361   5.740  -2.961  1.00 11.81           O  
ATOM   1230  N   LYS   142       3.300   6.878  -1.314  1.00  7.88           N  
ATOM   1231  CA  LYS   142       4.488   7.211  -0.523  1.00  7.53           C  
ATOM   1232  C   LYS   142       4.319   6.792   0.930  1.00  7.09           C  
ATOM   1233  O   LYS   142       3.193   6.747   1.437  1.00  7.75           O  
ATOM   1234  CB  LYS   142       4.753   8.735  -0.530  1.00  8.17           C  
ATOM   1235  CG  LYS   142       4.943   9.374  -1.903  1.00 10.76           C  
ATOM   1236  CD  LYS   142       6.261   9.017  -2.514  1.00 11.66           C  
ATOM   1237  CE  LYS   142       6.456   9.706  -3.853  1.00 13.32           C  
ATOM   1238  NZ  LYS   142       7.759   9.410  -4.431  1.00 13.44           N  
ATOM   1239  N   THR   143       5.442   6.528   1.594  1.00  6.74           N  
ATOM   1240  CA  THR   143       5.447   6.303   3.036  1.00  6.51           C  
ATOM   1241  C   THR   143       6.321   7.336   3.745  1.00  6.36           C  
ATOM   1242  O   THR   143       7.189   7.964   3.156  1.00  6.85           O  
ATOM   1243  CB  THR   143       5.923   4.885   3.452  1.00  6.63           C  
ATOM   1244  OG1 THR   143       7.351   4.758   3.358  1.00  6.25           O  
ATOM   1245  CG2 THR   143       5.300   3.805   2.613  1.00  8.11           C  
ATOM   1246  N   TYR   144       6.095   7.457   5.054  1.00  6.31           N  
ATOM   1247  CA  TYR   144       6.905   8.318   5.931  1.00  5.84           C  
ATOM   1248  C   TYR   144       6.808   7.655   7.301  1.00  5.77           C  
ATOM   1249  O   TYR   144       5.934   7.952   8.106  1.00  6.22           O  
ATOM   1250  CB  TYR   144       6.354   9.727   5.910  1.00  6.64           C  
ATOM   1251  CG  TYR   144       7.273  10.798   6.464  1.00  6.36           C  
ATOM   1252  CD1 TYR   144       8.263  11.377   5.686  1.00  7.88           C  
ATOM   1253  CD2 TYR   144       7.099  11.301   7.741  1.00  7.13           C  
ATOM   1254  CE1 TYR   144       9.037  12.401   6.151  1.00  8.39           C  
ATOM   1255  CE2 TYR   144       7.875  12.335   8.208  1.00  7.78           C  
ATOM   1256  CZ  TYR   144       8.846  12.885   7.413  1.00  7.67           C  
ATOM   1257  OH  TYR   144       9.585  13.925   7.919  1.00 10.26           O  
ATOM   1258  N   ILE   145       7.723   6.706   7.515  1.00  5.59           N  
ATOM   1259  CA  ILE   145       7.663   5.766   8.662  1.00  5.49           C  
ATOM   1260  C   ILE   145       8.935   5.867   9.464  1.00  5.52           C  
ATOM   1261  O   ILE   145      10.037   5.618   8.960  1.00  6.01           O  
ATOM   1262  CB  ILE   145       7.469   4.320   8.138  1.00  6.70           C  
ATOM   1263  CG1 ILE   145       6.103   4.200   7.445  1.00  6.92           C  
ATOM   1264  CG2 ILE   145       7.672   3.304   9.251  1.00  6.86           C  
ATOM   1265  CD1 ILE   145       5.958   2.972   6.594  1.00  8.71           C  
ATOM   1266  N   GLY   146       8.815   6.253  10.731  1.00  5.56           N  
ATOM   1267  CA  GLY   146      10.031   6.466  11.509  1.00  5.84           C  
ATOM   1268  C   GLY   146       9.725   7.121  12.819  1.00  5.82           C  
ATOM   1269  O   GLY   146       8.775   6.723  13.506  1.00  6.49           O  
ATOM   1270  N   GLY   147      10.505   8.124  13.158  1.00  6.23           N  
ATOM   1271  CA  GLY   147      10.296   8.863  14.402  1.00  6.62           C  
ATOM   1272  C   GLY   147      11.058  10.149  14.432  1.00  6.55           C  
ATOM   1273  O   GLY   147      11.913  10.375  13.610  1.00  7.94           O  
ATOM   1274  N   GLY   148      10.727  11.001  15.383  1.00  8.32           N  
ATOM   1275  CA  GLY   148      11.368  12.281  15.490  1.00  8.78           C  
ATOM   1276  C   GLY   148      10.430  13.334  16.028  1.00  7.34           C  
ATOM   1277  O   GLY   148       9.316  13.061  16.480  1.00  7.05           O  
ATOM   1278  N   PHE   149      10.921  14.563  15.920  1.00  7.26           N  
ATOM   1279  CA  PHE   149      10.301  15.728  16.544  0.83  7.47           C  
ATOM   1281  C   PHE   149       9.975  16.866  15.602  1.00  8.23           C  
ATOM   1282  O   PHE   149       9.602  17.919  16.041  1.00 10.56           O  
ATOM   1283  CB  PHE   149      11.128  16.161  17.767  0.83  8.05           C  
ATOM   1285  CG  PHE   149      11.263  15.051  18.742  0.83  8.81           C  
ATOM   1287  CD1 PHE   149      10.250  14.783  19.652  0.83  9.60           C  
ATOM   1289  CD2 PHE   149      12.306  14.126  18.623  0.83 12.55           C  
ATOM   1291  CE1 PHE   149      10.307  13.703  20.507  0.83 10.47           C  
ATOM   1293  CE2 PHE   149      12.352  13.008  19.456  0.83 13.97           C  
ATOM   1295  CZ  PHE   149      11.356  12.809  20.413  0.83 14.66           C  
ATOM   1297  N   GLY   150      10.130  16.622  14.310  1.00  9.02           N  
ATOM   1298  CA  GLY   150       9.732  17.586  13.297  1.00  9.85           C  
ATOM   1299  C   GLY   150      10.760  18.630  12.908  1.00  8.62           C  
ATOM   1300  O   GLY   150      10.877  18.942  11.727  1.00  9.04           O  
ATOM   1301  N   ASN   151      11.444  19.220  13.889  1.00  8.76           N  
ATOM   1302  CA  ASN   151      12.527  20.139  13.570  1.00  9.02           C  
ATOM   1303  C   ASN   151      13.524  20.165  14.724  1.00  8.46           C  
ATOM   1304  O   ASN   151      13.291  19.593  15.794  1.00  8.74           O  
ATOM   1305  CB  ASN   151      11.979  21.509  13.184  1.00  9.98           C  
ATOM   1306  CG  ASN   151      11.258  22.214  14.317  1.00 10.21           C  
ATOM   1307  OD1 ASN   151      11.717  22.197  15.450  1.00 11.18           O  
ATOM   1308  ND2 ASN   151      10.143  22.882  14.001  1.00 11.44           N  
ATOM   1309  N   LYS   152      14.653  20.826  14.496  1.00  8.67           N  
ATOM   1310  CA  LYS   152      15.721  20.826  15.479  1.00  9.44           C  
ATOM   1311  C   LYS   152      15.338  21.524  16.770  1.00  9.39           C  
ATOM   1312  O   LYS   152      15.720  21.082  17.853  1.00  9.72           O  
ATOM   1313  CB  LYS   152      16.957  21.503  14.892  1.00 10.99           C  
ATOM   1314  CG  LYS   152      18.158  21.503  15.799  1.00 13.50           C  
ATOM   1315  CD  LYS   152      19.343  22.199  15.162  1.00 15.84           C  
ATOM   1316  CE  LYS   152      20.586  22.091  15.987  1.00 21.48           C  
ATOM   1317  NZ  LYS   152      21.726  22.714  15.268  1.00 26.36           N  
ATOM   1318  N   GLU   153      14.614  22.628  16.669  1.00  9.85           N  
ATOM   1319  CA  GLU   153      14.264  23.428  17.852  0.51 10.41           C  
ATOM   1321  C   GLU   153      13.413  22.595  18.813  1.00  9.57           C  
ATOM   1322  O   GLU   153      13.663  22.553  20.017  1.00 10.01           O  
ATOM   1323  CB  GLU   153      13.537  24.752  17.484  0.51 11.47           C  
ATOM   1325  CG  GLU   153      13.073  25.576  18.734  0.51 17.67           C  
ATOM   1327  CD  GLU   153      12.583  27.014  18.444  0.51 21.20           C  
ATOM   1329  OE1 GLU   153      12.468  27.407  17.265  0.51 25.98           O  
ATOM   1331  OE2 GLU   153      12.266  27.747  19.414  0.51 23.32           O  
ATOM   1333  N   LEU   154      12.401  21.940  18.268  1.00  8.79           N  
ATOM   1334  CA  LEU   154      11.535  21.090  19.079  1.00  8.92           C  
ATOM   1335  C   LEU   154      12.280  19.876  19.570  1.00  7.91           C  
ATOM   1336  O   LEU   154      12.140  19.469  20.720  1.00  8.79           O  
ATOM   1337  CB  LEU   154      10.276  20.699  18.315  1.00  9.43           C  
ATOM   1338  CG  LEU   154       9.331  21.841  17.953  1.00  9.85           C  
ATOM   1339  CD1 LEU   154       8.190  21.292  17.134  1.00 10.67           C  
ATOM   1340  CD2 LEU   154       8.822  22.565  19.214  1.00 13.40           C  
ATOM   1341  N   ARG   155      13.090  19.277  18.711  1.00  7.63           N  
ATOM   1342  CA  ARG   155      13.862  18.133  19.131  1.00  8.32           C  
ATOM   1343  C   ARG   155      14.668  18.467  20.394  1.00  9.00           C  
ATOM   1344  O   ARG   155      14.694  17.731  21.391  1.00  9.61           O  
ATOM   1345  CB  ARG   155      14.808  17.663  18.024  1.00  8.41           C  
ATOM   1346  CG  ARG   155      15.656  16.493  18.400  1.00  9.22           C  
ATOM   1347  CD  ARG   155      16.797  16.292  17.398  1.00 10.33           C  
ATOM   1348  NE  ARG   155      17.769  17.358  17.568  1.00 11.99           N  
ATOM   1349  CZ  ARG   155      18.828  17.530  16.808  1.00 14.45           C  
ATOM   1350  NH1 ARG   155      19.024  16.722  15.791  1.00 15.52           N  
ATOM   1351  NH2 ARG   155      19.670  18.528  17.054  1.00 16.84           N  
ATOM   1352  N   ASP   156      15.362  19.584  20.332  1.00  9.30           N  
ATOM   1353  CA  ASP   156      16.298  19.952  21.405  1.00  9.93           C  
ATOM   1354  C   ASP   156      15.545  20.301  22.697  1.00  9.88           C  
ATOM   1355  O   ASP   156      15.968  19.913  23.810  1.00 11.08           O  
ATOM   1356  CB  ASP   156      17.200  21.090  20.947  1.00 12.09           C  
ATOM   1357  CG  ASP   156      18.225  20.653  19.904  1.00 13.32           C  
ATOM   1358  OD1 ASP   156      18.384  19.421  19.664  1.00 14.73           O  
ATOM   1359  OD2 ASP   156      18.899  21.574  19.376  1.00 17.02           O  
ATOM   1360  N   SER   157      14.455  21.054  22.589  1.00 10.33           N  
ATOM   1361  CA  SER   157      13.734  21.453  23.796  1.00 10.24           C  
ATOM   1362  C   SER   157      13.044  20.269  24.425  1.00 10.07           C  
ATOM   1363  O   SER   157      13.045  20.094  25.659  1.00 10.76           O  
ATOM   1364  CB  SER   157      12.756  22.581  23.556  1.00 12.70           C  
ATOM   1365  OG  SER   157      11.741  22.238  22.668  1.00 13.44           O  
ATOM   1366  N   ILE   158      12.435  19.435  23.599  1.00  8.70           N  
ATOM   1367  CA  ILE   158      11.747  18.261  24.120  1.00  8.89           C  
ATOM   1368  C   ILE   158      12.722  17.276  24.713  1.00  9.69           C  
ATOM   1369  O   ILE   158      12.473  16.699  25.778  1.00 10.84           O  
ATOM   1370  CB  ILE   158      10.876  17.594  23.019  1.00  8.88           C  
ATOM   1371  CG1 ILE   158       9.724  18.515  22.676  1.00 10.25           C  
ATOM   1372  CG2 ILE   158      10.386  16.204  23.471  1.00 11.17           C  
ATOM   1373  CD1 ILE   158       8.942  18.115  21.441  1.00 11.33           C  
ATOM   1374  N   SER   159      13.871  17.108  24.068  1.00 10.59           N  
ATOM   1375  CA  SER   159      14.876  16.162  24.577  0.49 11.67           C  
ATOM   1377  C   SER   159      15.283  16.503  25.973  1.00 10.55           C  
ATOM   1378  O   SER   159      15.410  15.630  26.837  1.00 12.90           O  
ATOM   1379  CB  SER   159      16.165  16.114  23.731  0.49 12.50           C  
ATOM   1381  OG  SER   159      17.221  15.442  24.443  0.49 14.69           O  
ATOM   1383  N   ALA   160      15.535  17.779  26.218  1.00 11.61           N  
ATOM   1384  CA  ALA   160      15.970  18.189  27.524  1.00 11.74           C  
ATOM   1385  C   ALA   160      14.956  17.798  28.587  1.00 12.77           C  
ATOM   1386  O   ALA   160      15.308  17.287  29.665  1.00 13.22           O  
ATOM   1387  CB  ALA   160      16.236  19.673  27.560  1.00 13.46           C  
ATOM   1388  N   GLU   161      13.680  18.009  28.292  1.00 12.13           N  
ATOM   1389  CA  GLU   161      12.634  17.667  29.251  0.55 12.38           C  
ATOM   1391  C   GLU   161      12.479  16.147  29.390  1.00 11.75           C  
ATOM   1392  O   GLU   161      12.273  15.633  30.509  1.00 13.35           O  
ATOM   1393  CB  GLU   161      11.303  18.312  28.880  0.55 13.15           C  
ATOM   1395  CG  GLU   161      10.244  18.097  29.926  0.55 16.08           C  
ATOM   1397  CD  GLU   161      10.558  18.730  31.262  0.55 21.94           C  
ATOM   1399  OE1 GLU   161      11.519  19.524  31.366  0.55 22.75           O  
ATOM   1401  OE2 GLU   161       9.803  18.436  32.217  0.55 26.74           O  
ATOM   1403  N   MET   162      12.535  15.402  28.295  1.00 11.57           N  
ATOM   1404  CA  MET   162      12.399  13.929  28.363  0.50 11.42           C  
ATOM   1406  C   MET   162      13.510  13.312  29.181  1.00 11.89           C  
ATOM   1407  O   MET   162      13.281  12.381  29.952  1.00 13.08           O  
ATOM   1408  CB  MET   162      12.330  13.252  26.986  0.50 10.93           C  
ATOM   1410  CG  MET   162      11.018  13.450  26.238  0.50  8.70           C  
ATOM   1412  SD  MET   162       9.464  12.746  27.149  0.38  6.08          SE  
ATOM   1414  CE  MET   162       9.887  10.868  26.999  0.50  7.35           C  
ATOM   1416  N   ILE   163      14.704  13.857  29.032  1.00 11.81           N  
ATOM   1417  CA  ILE   163      15.870  13.343  29.768  1.00 12.25           C  
ATOM   1418  C   ILE   163      15.686  13.582  31.270  1.00 12.44           C  
ATOM   1419  O   ILE   163      16.041  12.741  32.087  1.00 14.51           O  
ATOM   1420  CB  ILE   163      17.184  13.964  29.232  1.00 14.26           C  
ATOM   1421  CG1 ILE   163      17.425  13.418  27.830  1.00 14.80           C  
ATOM   1422  CG2 ILE   163      18.326  13.625  30.164  1.00 17.53           C  
ATOM   1423  CD1 ILE   163      18.497  14.126  27.067  1.00 18.03           C  
ATOM   1424  N   ARG   164      15.092  14.718  31.626  1.00 12.19           N  
ATOM   1425  CA  ARG   164      14.834  15.022  33.023  0.48 12.98           C  
ATOM   1427  C   ARG   164      13.788  14.056  33.608  1.00 12.06           C  
ATOM   1428  O   ARG   164      13.915  13.561  34.729  1.00 13.99           O  
ATOM   1429  CB  ARG   164      14.347  16.464  33.145  0.48 14.17           C  
ATOM   1431  CG  ARG   164      14.229  16.975  34.550  0.48 15.40           C  
ATOM   1433  CD  ARG   164      13.494  18.309  34.559  0.48 19.98           C  
ATOM   1435  NE  ARG   164      12.106  18.124  34.158  0.48 22.85           N  
ATOM   1437  CZ  ARG   164      11.158  17.694  34.981  0.48 20.45           C  
ATOM   1439  NH1 ARG   164      11.457  17.429  36.253  0.48 31.20           N  
ATOM   1441  NH2 ARG   164       9.922  17.531  34.543  0.48 27.60           N  
ATOM   1443  N   LYS   165      12.741  13.799  32.844  1.00 11.55           N  
ATOM   1444  CA  LYS   165      11.677  12.906  33.329  0.48 11.53           C  
ATOM   1446  C   LYS   165      12.099  11.445  33.360  1.00 10.63           C  
ATOM   1447  O   LYS   165      11.835  10.745  34.325  1.00 11.54           O  
ATOM   1448  CB  LYS   165      10.411  13.043  32.468  0.48 13.02           C  
ATOM   1450  CG  LYS   165       9.806  14.437  32.478  0.48 16.74           C  
ATOM   1452  CD  LYS   165       8.644  14.537  31.511  0.48 20.80           C  
ATOM   1454  CE  LYS   165       7.442  13.749  31.989  0.48 23.80           C  
ATOM   1456  NZ  LYS   165       6.840  14.325  33.224  0.48 26.95           N  
ATOM   1458  N   ASN   166      12.724  11.014  32.281  1.00 10.82           N  
ATOM   1459  CA  ASN   166      13.063   9.611  32.048  1.00 10.88           C  
ATOM   1460  C   ASN   166      14.519   9.498  31.579  1.00 11.38           C  
ATOM   1461  O   ASN   166      14.790   9.500  30.365  1.00 11.73           O  
ATOM   1462  CB  ASN   166      12.188   9.035  30.918  1.00 11.30           C  
ATOM   1463  CG  ASN   166      10.682   9.108  31.149  1.00 11.26           C  
ATOM   1464  OD1 ASN   166       9.917   9.301  30.187  1.00 11.85           O  
ATOM   1465  ND2 ASN   166      10.236   8.879  32.391  1.00 13.52           N  
ATOM   1466  N   PRO   167      15.457   9.423  32.517  1.00 10.53           N  
ATOM   1467  CA  PRO   167      16.849   9.532  32.099  1.00 11.73           C  
ATOM   1468  C   PRO   167      17.292   8.496  31.045  1.00 11.00           C  
ATOM   1469  O   PRO   167      18.087   8.832  30.160  1.00 13.71           O  
ATOM   1470  CB  PRO   167      17.612   9.368  33.404  1.00 13.75           C  
ATOM   1471  CG  PRO   167      16.643   9.861  34.436  1.00 13.20           C  
ATOM   1472  CD  PRO   167      15.288   9.488  33.977  1.00 11.16           C  
ATOM   1473  N   ASP   168      16.740   7.289  31.089  1.00 10.51           N  
ATOM   1474  CA  ASP   168      17.151   6.227  30.136  1.00 10.92           C  
ATOM   1475  C   ASP   168      16.623   6.452  28.726  1.00 10.34           C  
ATOM   1476  O   ASP   168      17.076   5.820  27.778  1.00 11.40           O  
ATOM   1477  CB  ASP   168      16.721   4.848  30.635  1.00 11.57           C  
ATOM   1478  CG  ASP   168      17.242   4.556  32.003  1.00 12.24           C  
ATOM   1479  OD1 ASP   168      18.445   4.301  32.146  1.00 15.10           O  
ATOM   1480  OD2 ASP   168      16.460   4.670  32.983  1.00 13.85           O  
ATOM   1481  N   TRP   169      15.652   7.357  28.572  1.00  9.95           N  
ATOM   1482  CA  TRP   169      15.118   7.675  27.240  1.00 10.25           C  
ATOM   1483  C   TRP   169      16.244   8.220  26.370  1.00 10.22           C  
ATOM   1484  O   TRP   169      16.245   8.017  25.159  1.00 11.17           O  
ATOM   1485  CB  TRP   169      13.975   8.700  27.355  1.00  9.83           C  
ATOM   1486  CG  TRP   169      13.529   9.285  26.049  1.00  9.55           C  
ATOM   1487  CD1 TRP   169      12.517   8.847  25.253  1.00 11.31           C  
ATOM   1488  CD2 TRP   169      14.071  10.429  25.412  1.00  9.57           C  
ATOM   1489  NE1 TRP   169      12.414   9.630  24.143  1.00 11.66           N  
ATOM   1490  CE2 TRP   169      13.379  10.600  24.204  1.00 10.57           C  
ATOM   1491  CE3 TRP   169      15.128  11.290  25.714  1.00 10.85           C  
ATOM   1492  CZ2 TRP   169      13.663  11.638  23.329  1.00 13.28           C  
ATOM   1493  CZ3 TRP   169      15.410  12.309  24.846  1.00 14.36           C  
ATOM   1494  CH2 TRP   169      14.704  12.468  23.666  1.00 14.08           C  
ATOM   1495  N   LYS   170      17.231   8.889  26.968  1.00 10.69           N  
ATOM   1496  CA  LYS   170      18.315   9.501  26.190  1.00 11.77           C  
ATOM   1497  C   LYS   170      18.976   8.440  25.285  1.00 11.41           C  
ATOM   1498  O   LYS   170      19.142   8.615  24.069  1.00 13.09           O  
ATOM   1499  CB  LYS   170      19.370  10.100  27.125  1.00 13.56           C  
ATOM   1500  CG  LYS   170      20.482  10.898  26.427  1.00 15.07           C  
ATOM   1501  CD  LYS   170      21.455  11.468  27.480  1.00 20.05           C  
ATOM   1502  CE  LYS   170      22.623  12.226  26.872  1.00 22.38           C  
ATOM   1503  NZ  LYS   170      23.477  12.888  27.928  1.00 26.03           N  
ATOM   1504  N   GLU   171      19.317   7.299  25.884  1.00 12.60           N  
ATOM   1505  CA  GLU   171      19.985   6.258  25.107  1.00 14.39           C  
ATOM   1506  C   GLU   171      19.083   5.553  24.118  1.00 13.40           C  
ATOM   1507  O   GLU   171      19.553   5.179  23.038  1.00 15.61           O  
ATOM   1508  CB  GLU   171      20.696   5.269  26.029  1.00 17.57           C  
ATOM   1509  CG  GLU   171      21.903   5.891  26.707  1.00 20.31           C  
ATOM   1510  CD  GLU   171      21.571   6.779  27.905  1.00 23.03           C  
ATOM   1511  OE1 GLU   171      20.478   6.635  28.536  1.00 21.01           O  
ATOM   1512  OE2 GLU   171      22.421   7.644  28.227  1.00 25.17           O  
ATOM   1513  N   PHE   172      17.814   5.350  24.454  1.00 12.47           N  
ATOM   1514  CA  PHE   172      16.885   4.673  23.532  1.00 12.40           C  
ATOM   1515  C   PHE   172      16.661   5.563  22.323  1.00 10.95           C  
ATOM   1516  O   PHE   172      16.792   5.140  21.194  1.00 12.60           O  
ATOM   1517  CB  PHE   172      15.588   4.311  24.259  1.00 12.73           C  
ATOM   1518  CG  PHE   172      14.576   3.593  23.425  1.00 11.50           C  
ATOM   1519  CD1 PHE   172      14.937   2.661  22.466  1.00 12.62           C  
ATOM   1520  CD2 PHE   172      13.219   3.757  23.674  1.00 11.41           C  
ATOM   1521  CE1 PHE   172      13.977   1.982  21.757  1.00 14.13           C  
ATOM   1522  CE2 PHE   172      12.275   3.071  22.952  1.00 12.14           C  
ATOM   1523  CZ  PHE   172      12.655   2.198  21.989  1.00 12.34           C  
ATOM   1524  N   ASN   173      16.402   6.833  22.570  1.00 10.78           N  
ATOM   1525  CA  ASN   173      16.220   7.780  21.470  1.00 11.90           C  
ATOM   1526  C   ASN   173      17.456   7.850  20.578  1.00 13.16           C  
ATOM   1527  O   ASN   173      17.347   7.880  19.350  1.00 13.46           O  
ATOM   1528  CB  ASN   173      15.864   9.156  22.037  1.00 12.64           C  
ATOM   1529  CG  ASN   173      15.897  10.241  20.994  1.00 13.41           C  
ATOM   1530  OD1 ASN   173      16.769  11.119  21.034  1.00 16.00           O  
ATOM   1531  ND2 ASN   173      14.958  10.210  20.068  1.00 14.40           N  
ATOM   1532  N   ARG   174      18.649   7.858  21.186  1.00 13.04           N  
ATOM   1533  CA  ARG   174      19.901   7.930  20.425  0.48 14.77           C  
ATOM   1535  C   ARG   174      20.096   6.693  19.544  1.00 16.70           C  
ATOM   1536  O   ARG   174      20.609   6.780  18.432  1.00 20.85           O  
ATOM   1537  CB  ARG   174      21.099   8.222  21.333  0.48 16.10           C  
ATOM   1539  CG  ARG   174      21.052   9.689  21.766  0.48 17.56           C  
ATOM   1541  CD  ARG   174      22.141  10.214  22.690  0.48 15.61           C  
ATOM   1543  NE  ARG   174      22.118  11.677  22.677  0.48 15.38           N  
ATOM   1545  CZ  ARG   174      23.148  12.434  23.062  0.48 13.73           C  
ATOM   1547  NH1 ARG   174      24.245  11.846  23.518  0.48 12.38           N  
ATOM   1549  NH2 ARG   174      23.073  13.755  22.962  0.48 16.09           N  
ATOM   1551  N   LYS   175      19.647   5.550  20.010  1.00 16.04           N  
ATOM   1552  CA  LYS   175      19.687   4.319  19.196  1.00 15.62           C  
ATOM   1553  C   LYS   175      18.639   4.400  18.071  1.00 15.85           C  
ATOM   1554  O   LYS   175      18.934   4.046  16.920  1.00 18.40           O  
ATOM   1555  CB  LYS   175      19.432   3.092  20.053  1.00 19.52           C  
ATOM   1556  N   ASN   176      17.441   4.873  18.364  1.00 12.96           N  
ATOM   1557  CA  ASN   176      16.359   4.951  17.389  1.00 13.62           C  
ATOM   1558  C   ASN   176      16.675   5.877  16.204  1.00 12.82           C  
ATOM   1559  O   ASN   176      16.535   5.495  15.045  1.00 12.24           O  
ATOM   1560  CB  ASN   176      15.063   5.432  18.048  1.00 13.13           C  
ATOM   1561  CG  ASN   176      14.461   4.409  18.990  1.00 12.85           C  
ATOM   1562  OD1 ASN   176      14.782   3.232  18.934  1.00 14.11           O  
ATOM   1563  ND2 ASN   176      13.585   4.866  19.853  1.00 12.52           N  
ATOM   1564  N   ILE   177      17.118   7.084  16.523  1.00 12.61           N  
ATOM   1565  CA  ILE   177      17.308   8.114  15.502  1.00 13.60           C  
ATOM   1566  C   ILE   177      18.782   8.149  15.140  1.00 15.44           C  
ATOM   1567  O   ILE   177      19.509   9.067  15.487  1.00 16.67           O  
ATOM   1568  CB  ILE   177      16.792   9.483  15.994  1.00 15.08           C  
ATOM   1569  CG1 ILE   177      15.396   9.382  16.617  1.00 18.27           C  
ATOM   1570  CG2 ILE   177      16.807  10.509  14.844  1.00 17.17           C  
ATOM   1571  CD1 ILE   177      14.325   8.832  15.691  1.00 18.17           C  
ATOM   1572  N   SER   178      19.239   7.101  14.460  1.00 15.05           N  
ATOM   1573  CA  SER   178      20.612   7.012  14.057  1.00 15.96           C  
ATOM   1574  C   SER   178      20.837   6.112  12.866  1.00 13.51           C  
ATOM   1575  O   SER   178      19.916   5.470  12.347  1.00 13.40           O  
ATOM   1576  CB  SER   178      21.474   6.475  15.191  1.00 18.42           C  
ATOM   1577  OG  SER   178      21.264   5.106  15.353  1.00 21.32           O  
ATOM   1578  N   GLN   179      22.111   6.052  12.446  1.00 12.66           N  
ATOM   1579  CA  GLN   179      22.465   5.275  11.267  1.00 11.66           C  
ATOM   1580  C   GLN   179      22.336   3.788  11.483  1.00 12.77           C  
ATOM   1581  O   GLN   179      22.332   3.027  10.526  1.00 12.79           O  
ATOM   1582  CB  GLN   179      23.813   5.688  10.698  1.00 11.62           C  
ATOM   1583  CG  GLN   179      23.701   7.044  10.037  1.00 10.61           C  
ATOM   1584  CD  GLN   179      24.906   7.306   9.178  1.00 11.06           C  
ATOM   1585  OE1 GLN   179      25.158   6.546   8.222  1.00 14.43           O  
ATOM   1586  NE2 GLN   179      25.689   8.341   9.513  1.00 11.50           N  
ATOM   1587  N   GLU   180      22.236   3.362  12.739  1.00 13.28           N  
ATOM   1588  CA  GLU   180      22.004   1.933  12.996  1.00 15.08           C  
ATOM   1589  C   GLU   180      20.712   1.501  12.323  1.00 13.96           C  
ATOM   1590  O   GLU   180      20.633   0.430  11.717  1.00 14.16           O  
ATOM   1591  CB  GLU   180      21.925   1.653  14.478  1.00 16.38           C  
ATOM   1592  N   ASN   181      19.689   2.321  12.437  1.00 11.35           N  
ATOM   1593  CA  ASN   181      18.395   2.062  11.840  1.00 11.90           C  
ATOM   1594  C   ASN   181      18.380   2.340  10.369  1.00 10.50           C  
ATOM   1595  O   ASN   181      17.599   1.680   9.651  1.00 11.78           O  
ATOM   1596  CB  ASN   181      17.262   2.736  12.601  1.00 11.76           C  
ATOM   1597  CG  ASN   181      16.897   1.951  13.810  1.00 12.13           C  
ATOM   1598  OD1 ASN   181      16.926   0.701  13.778  1.00 14.58           O  
ATOM   1599  ND2 ASN   181      16.579   2.629  14.879  1.00 13.07           N  
ATOM   1600  N   VAL   182      19.204   3.283   9.912  1.00  9.58           N  
ATOM   1601  CA  VAL   182      19.272   3.485   8.479  1.00  8.94           C  
ATOM   1602  C   VAL   182      19.767   2.174   7.856  1.00  9.93           C  
ATOM   1603  O   VAL   182      19.159   1.675   6.880  1.00 10.78           O  
ATOM   1604  CB  VAL   182      20.145   4.664   8.107  1.00  9.53           C  
ATOM   1605  CG1 VAL   182      20.256   4.772   6.608  1.00 11.17           C  
ATOM   1606  CG2 VAL   182      19.567   5.967   8.706  1.00 10.62           C  
ATOM   1607  N   GLU   183      20.825   1.598   8.421  1.00  9.99           N  
ATOM   1608  CA  GLU   183      21.371   0.354   7.924  0.50 10.11           C  
ATOM   1610  C   GLU   183      20.409  -0.811   8.080  1.00  9.86           C  
ATOM   1611  O   GLU   183      20.173  -1.614   7.176  1.00 10.02           O  
ATOM   1612  CB  GLU   183      22.661   0.012   8.643  0.50 11.35           C  
ATOM   1614  CG  GLU   183      23.194  -1.326   8.178  0.50 15.01           C  
ATOM   1616  CD  GLU   183      24.666  -1.300   7.952  0.50 15.08           C  
ATOM   1618  OE1 GLU   183      25.108  -0.396   7.213  0.50 30.11           O  
ATOM   1620  OE2 GLU   183      25.371  -2.198   8.448  0.50 31.87           O  
ATOM   1622  N   ARG   184      19.834  -0.915   9.260  1.00 10.06           N  
ATOM   1623  CA  ARG   184      18.922  -2.019   9.533  1.00 10.17           C  
ATOM   1624  C   ARG   184      17.794  -2.061   8.513  1.00 10.00           C  
ATOM   1625  O   ARG   184      17.482  -3.102   7.929  1.00  9.98           O  
ATOM   1626  CB  ARG   184      18.309  -1.917  10.925  1.00 11.15           C  
ATOM   1627  CG  ARG   184      17.365  -3.060  11.290  1.00 12.30           C  
ATOM   1628  CD  ARG   184      16.673  -2.910  12.630  1.00 14.09           C  
ATOM   1629  NE  ARG   184      15.909  -4.137  12.851  1.00 15.57           N  
ATOM   1630  CZ  ARG   184      14.839  -4.272  13.608  1.00 16.60           C  
ATOM   1631  NH1 ARG   184      14.346  -3.265  14.264  1.00 17.24           N  
ATOM   1632  NH2 ARG   184      14.261  -5.452  13.681  1.00 18.03           N  
ATOM   1633  N   PHE   185      17.158  -0.913   8.327  1.00  9.53           N  
ATOM   1634  CA  PHE   185      15.985  -0.841   7.456  1.00  8.59           C  
ATOM   1635  C   PHE   185      16.310  -0.868   5.975  1.00  9.00           C  
ATOM   1636  O   PHE   185      15.525  -1.396   5.205  1.00  9.94           O  
ATOM   1637  CB  PHE   185      15.022   0.247   7.929  1.00  9.55           C  
ATOM   1638  CG  PHE   185      14.341  -0.144   9.178  1.00  9.01           C  
ATOM   1639  CD1 PHE   185      13.326  -1.089   9.134  1.00 10.44           C  
ATOM   1640  CD2 PHE   185      14.745   0.311  10.394  1.00 10.18           C  
ATOM   1641  CE1 PHE   185      12.731  -1.530  10.291  1.00 10.34           C  
ATOM   1642  CE2 PHE   185      14.155  -0.112  11.546  1.00 11.02           C  
ATOM   1643  CZ  PHE   185      13.150  -1.037  11.509  1.00 10.75           C  
ATOM   1644  N   GLN   186      17.472  -0.352   5.587  1.00  8.84           N  
ATOM   1645  CA  GLN   186      17.917  -0.531   4.218  1.00  9.83           C  
ATOM   1646  C   GLN   186      17.985  -2.034   3.954  1.00  9.36           C  
ATOM   1647  O   GLN   186      17.537  -2.522   2.916  1.00  9.42           O  
ATOM   1648  CB  GLN   186      19.305   0.129   4.042  1.00 12.65           C  
ATOM   1649  CG  GLN   186      20.120  -0.095   2.882  1.00 18.81           C  
ATOM   1650  CD  GLN   186      21.548   0.468   3.124  1.00 22.78           C  
ATOM   1651  OE1 GLN   186      22.411   0.262   2.315  1.00 33.67           O  
ATOM   1652  NE2 GLN   186      21.755   1.195   4.243  1.00 25.78           N  
ATOM   1653  N   ASN   187      18.574  -2.780   4.901  1.00  8.98           N  
ATOM   1654  CA  ASN   187      18.703  -4.226   4.689  1.00  9.69           C  
ATOM   1655  C   ASN   187      17.351  -4.932   4.599  1.00  8.77           C  
ATOM   1656  O   ASN   187      17.148  -5.820   3.770  1.00  9.73           O  
ATOM   1657  CB  ASN   187      19.556  -4.867   5.772  1.00  9.65           C  
ATOM   1658  CG  ASN   187      21.018  -4.446   5.706  1.00 12.77           C  
ATOM   1659  OD1 ASN   187      21.483  -3.948   4.685  1.00 16.60           O  
ATOM   1660  ND2 ASN   187      21.743  -4.623   6.805  1.00 15.21           N  
ATOM   1661  N   VAL   188      16.389  -4.487   5.393  1.00  8.25           N  
ATOM   1662  CA  VAL   188      15.047  -5.049   5.336  1.00  8.78           C  
ATOM   1663  C   VAL   188      14.388  -4.804   3.984  1.00  8.05           C  
ATOM   1664  O   VAL   188      13.844  -5.713   3.339  1.00  7.98           O  
ATOM   1665  CB  VAL   188      14.137  -4.456   6.454  1.00  9.61           C  
ATOM   1666  CG1 VAL   188      12.671  -4.878   6.284  1.00 11.93           C  
ATOM   1667  CG2 VAL   188      14.637  -4.839   7.854  1.00 11.67           C  
ATOM   1668  N   LEU   189      14.438  -3.562   3.511  1.00  7.78           N  
ATOM   1669  CA  LEU   189      13.810  -3.207   2.247  1.00  8.02           C  
ATOM   1670  C   LEU   189      14.519  -3.911   1.101  1.00  7.78           C  
ATOM   1671  O   LEU   189      13.890  -4.315   0.122  1.00  8.52           O  
ATOM   1672  CB  LEU   189      13.816  -1.686   2.040  1.00  8.06           C  
ATOM   1673  CG  LEU   189      13.040  -0.877   3.107  1.00  8.50           C  
ATOM   1674  CD1 LEU   189      12.931   0.554   2.625  1.00 10.54           C  
ATOM   1675  CD2 LEU   189      11.636  -1.447   3.420  1.00 10.09           C  
ATOM   1676  N   ASP   190      15.834  -4.068   1.212  1.00  7.87           N  
ATOM   1677  CA  ASP   190      16.601  -4.713   0.145  1.00  8.50           C  
ATOM   1678  C   ASP   190      16.271  -6.199   0.063  1.00  8.73           C  
ATOM   1679  O   ASP   190      16.233  -6.759  -1.037  1.00  9.75           O  
ATOM   1680  CB  ASP   190      18.082  -4.445   0.330  1.00  9.21           C  
ATOM   1681  CG  ASP   190      18.453  -2.983   0.110  1.00 10.79           C  
ATOM   1682  OD1 ASP   190      17.642  -2.201  -0.440  1.00 10.77           O  
ATOM   1683  OD2 ASP   190      19.584  -2.637   0.479  1.00 13.31           O  
ATOM   1684  N   GLU   191      16.024  -6.844   1.197  1.00  8.92           N  
ATOM   1685  CA  GLU   191      15.633  -8.271   1.170  1.00  9.18           C  
ATOM   1686  C   GLU   191      14.268  -8.414   0.494  1.00  9.15           C  
ATOM   1687  O   GLU   191      14.035  -9.403  -0.227  1.00 10.43           O  
ATOM   1688  CB  GLU   191      15.612  -8.868   2.567  1.00 10.40           C  
ATOM   1689  CG  GLU   191      15.204 -10.367   2.612  1.00 11.99           C  
ATOM   1690  CD  GLU   191      13.683 -10.691   2.617  1.00 12.18           C  
ATOM   1691  OE1 GLU   191      12.889  -9.991   3.258  1.00 13.76           O  
ATOM   1692  OE2 GLU   191      13.263 -11.738   2.018  1.00 15.64           O  
ATOM   1693  N   ILE   192      13.353  -7.475   0.691  1.00  8.64           N  
ATOM   1694  CA  ILE   192      12.043  -7.496   0.030  1.00  9.11           C  
ATOM   1695  C   ILE   192      12.183  -7.248  -1.450  1.00  9.06           C  
ATOM   1696  O   ILE   192      11.431  -7.781  -2.257  1.00  9.77           O  
ATOM   1697  CB  ILE   192      11.068  -6.503   0.695  1.00  9.34           C  
ATOM   1698  CG1 ILE   192      10.788  -6.949   2.134  1.00  8.99           C  
ATOM   1699  CG2 ILE   192       9.760  -6.398  -0.105  1.00 11.12           C  
ATOM   1700  CD1 ILE   192      10.126  -5.867   2.992  1.00 10.95           C  
ATOM   1701  N   GLY   193      13.144  -6.415  -1.808  1.00  8.48           N  
ATOM   1702  CA  GLY   193      13.440  -6.090  -3.201  1.00  8.98           C  
ATOM   1703  C   GLY   193      12.861  -4.806  -3.741  1.00  8.30           C  
ATOM   1704  O   GLY   193      12.757  -4.611  -4.937  1.00  8.89           O  
ATOM   1705  N   VAL   194      12.532  -3.893  -2.833  1.00  7.89           N  
ATOM   1706  CA  VAL   194      11.916  -2.609  -3.147  0.51  7.79           C  
ATOM   1708  C   VAL   194      12.786  -1.844  -4.138  1.00  7.24           C  
ATOM   1709  O   VAL   194      13.965  -1.612  -3.880  1.00  8.42           O  
ATOM   1710  CB  VAL   194      11.754  -1.756  -1.841  0.51  7.93           C  
ATOM   1712  CG1 VAL   194      10.847  -2.466  -0.813  0.51  8.64           C  
ATOM   1714  CG2 VAL   194      11.224  -0.366  -2.159  0.51  8.88           C  
ATOM   1718  N   SER   195      12.197  -1.421  -5.252  1.00  7.24           N  
ATOM   1719  CA  SER   195      12.967  -0.743  -6.320  1.00  7.37           C  
ATOM   1720  C   SER   195      13.335   0.701  -6.038  1.00  7.01           C  
ATOM   1721  O   SER   195      14.316   1.197  -6.559  1.00  7.47           O  
ATOM   1722  CB  SER   195      12.163  -0.766  -7.641  1.00  8.14           C  
ATOM   1723  OG  SER   195      11.981  -2.081  -8.152  1.00  8.78           O  
ATOM   1724  N   SER   196      12.468   1.389  -5.289  1.00  6.94           N  
ATOM   1725  CA  SER   196      12.607   2.835  -5.057  1.00  6.98           C  
ATOM   1726  C   SER   196      12.274   3.215  -3.630  1.00  6.76           C  
ATOM   1727  O   SER   196      11.174   3.030  -3.178  1.00  7.30           O  
ATOM   1728  CB  SER   196      11.649   3.562  -6.000  1.00  8.24           C  
ATOM   1729  OG  SER   196      11.766   4.957  -5.877  1.00 13.11           O  
ATOM   1730  N   TYR   197      13.265   3.786  -2.951  1.00  6.84           N  
ATOM   1731  CA  TYR   197      13.055   4.342  -1.605  1.00  7.15           C  
ATOM   1732  C   TYR   197      14.146   5.331  -1.250  1.00  6.91           C  
ATOM   1733  O   TYR   197      15.220   5.364  -1.855  1.00  7.22           O  
ATOM   1734  CB  TYR   197      12.968   3.226  -0.522  1.00  7.54           C  
ATOM   1735  CG  TYR   197      14.250   2.433  -0.278  1.00  7.94           C  
ATOM   1736  CD1 TYR   197      15.315   2.975   0.407  1.00  7.60           C  
ATOM   1737  CD2 TYR   197      14.379   1.132  -0.695  1.00  8.03           C  
ATOM   1738  CE1 TYR   197      16.481   2.241   0.648  1.00  8.83           C  
ATOM   1739  CE2 TYR   197      15.537   0.397  -0.475  1.00  7.92           C  
ATOM   1740  CZ  TYR   197      16.576   0.945   0.222  1.00  8.01           C  
ATOM   1741  OH  TYR   197      17.767   0.278   0.428  1.00  9.56           O  
ATOM   1742  N   GLU   198      13.835   6.124  -0.230  1.00  6.59           N  
ATOM   1743  CA  GLU   198      14.793   6.930   0.476  1.00  6.92           C  
ATOM   1744  C   GLU   198      14.661   6.600   1.966  1.00  6.27           C  
ATOM   1745  O   GLU   198      13.552   6.411   2.453  1.00  7.47           O  
ATOM   1746  CB  GLU   198      14.472   8.434   0.367  1.00  8.45           C  
ATOM   1747  CG  GLU   198      14.424   9.011  -1.009  1.00  9.66           C  
ATOM   1748  CD  GLU   198      13.665  10.326  -1.024  1.00 10.13           C  
ATOM   1749  OE1 GLU   198      12.453  10.271  -0.705  1.00 12.22           O  
ATOM   1750  OE2 GLU   198      14.270  11.365  -1.314  1.00 11.95           O  
ATOM   1751  N   ILE   199      15.766   6.531   2.680  1.00  7.15           N  
ATOM   1752  CA  ILE   199      15.745   6.453   4.152  1.00  6.80           C  
ATOM   1753  C   ILE   199      16.548   7.648   4.584  1.00  7.33           C  
ATOM   1754  O   ILE   199      17.709   7.774   4.207  1.00  8.81           O  
ATOM   1755  CB  ILE   199      16.281   5.152   4.712  1.00  8.16           C  
ATOM   1756  CG1 ILE   199      15.483   3.958   4.181  1.00  8.20           C  
ATOM   1757  CG2 ILE   199      16.222   5.172   6.218  1.00  9.74           C  
ATOM   1758  CD1 ILE   199      16.030   2.597   4.607  1.00 11.40           C  
ATOM   1759  N   ILE   200      15.932   8.530   5.353  1.00  6.71           N  
ATOM   1760  CA  ILE   200      16.532   9.816   5.736  0.51  7.29           C  
ATOM   1762  C   ILE   200      16.774   9.915   7.225  1.00  7.22           C  
ATOM   1763  O   ILE   200      16.058   9.315   8.048  1.00  7.79           O  
ATOM   1764  CB  ILE   200      15.663  11.043   5.332  0.51  6.86           C  
ATOM   1766  CG1 ILE   200      14.341  11.073   6.081  0.51  7.78           C  
ATOM   1768  CG2 ILE   200      15.423  11.099   3.796  0.51  9.15           C  
ATOM   1770  CD1 ILE   200      13.596  12.351   5.802  0.51  9.79           C  
ATOM   1772  N   LEU   201      17.775  10.704   7.570  1.00  7.47           N  
ATOM   1773  CA  LEU   201      18.106  10.998   8.946  1.00  7.40           C  
ATOM   1774  C   LEU   201      18.587  12.431   9.000  1.00  7.56           C  
ATOM   1775  O   LEU   201      19.544  12.790   8.349  1.00  9.03           O  
ATOM   1776  CB  LEU   201      19.164  10.022   9.454  1.00  8.16           C  
ATOM   1777  CG  LEU   201      19.712  10.249  10.831  1.00 10.34           C  
ATOM   1778  CD1 LEU   201      18.664  10.070  11.893  1.00 13.16           C  
ATOM   1779  CD2 LEU   201      20.915   9.304  11.050  1.00 13.25           C  
ATOM   1780  N   GLU   202      17.900  13.238   9.787  1.00  8.39           N  
ATOM   1781  CA  GLU   202      18.265  14.623   9.936  1.00  9.66           C  
ATOM   1782  C   GLU   202      17.541  15.269  11.080  1.00  9.31           C  
ATOM   1783  O   GLU   202      17.020  14.596  11.960  1.00  9.63           O  
ATOM   1784  N   ASP   203      17.484  16.584  11.052  1.00 10.94           N  
ATOM   1785  CA  ASP   203      16.906  17.309  12.187  1.00 12.13           C  
ATOM   1786  C   ASP   203      15.431  17.019  12.393  1.00 11.44           C  
ATOM   1787  O   ASP   203      14.918  17.250  13.478  1.00 12.93           O  
ATOM   1788  CB  ASP   203      17.175  18.812  12.072  1.00 14.32           C  
ATOM   1789  CG  ASP   203      18.660  19.168  12.294  1.00 15.59           C  
ATOM   1790  OD1 ASP   203      19.428  18.384  12.885  1.00 17.55           O  
ATOM   1791  OD2 ASP   203      19.060  20.272  11.925  1.00 21.01           O  
ATOM   1792  N   GLU   204      14.757  16.514  11.387  0.51 10.46           N  
ATOM   1794  CA  GLU   204      13.337  16.242  11.520  0.51 10.84           C  
ATOM   1796  C   GLU   204      13.061  14.843  12.010  0.51 10.34           C  
ATOM   1798  O   GLU   204      11.934  14.482  12.340  0.51 10.98           O  
ATOM   1800  CB  GLU   204      12.628  16.441  10.193  0.51 11.71           C  
ATOM   1802  CG  GLU   204      13.002  15.418   9.132  0.51 12.75           C  
ATOM   1804  CD  GLU   204      14.113  15.834   8.179  0.51 13.60           C  
ATOM   1806  OE1 GLU   204      15.214  16.370   8.566  0.51 14.70           O  
ATOM   1808  OE2 GLU   204      13.877  15.583   6.979  0.51 15.00           O  
ATOM   1810  N   GLY   205      14.119  14.063  12.056  1.00  9.31           N  
ATOM   1811  CA  GLY   205      14.065  12.680  12.560  1.00  9.02           C  
ATOM   1812  C   GLY   205      14.623  11.644  11.596  1.00  8.05           C  
ATOM   1813  O   GLY   205      15.423  11.968  10.705  1.00  8.62           O  
ATOM   1814  N   PHE   206      14.190  10.405  11.815  1.00  7.06           N  
ATOM   1815  CA  PHE   206      14.561   9.218  11.017  1.00  6.37           C  
ATOM   1816  C   PHE   206      13.286   8.781  10.308  1.00  6.15           C  
ATOM   1817  O   PHE   206      12.287   8.508  10.975  1.00  6.14           O  
ATOM   1818  CB  PHE   206      15.040   8.099  11.939  1.00  7.23           C  
ATOM   1819  CG  PHE   206      15.071   6.743  11.261  1.00  8.04           C  
ATOM   1820  CD1 PHE   206      16.090   6.393  10.396  1.00  9.90           C  
ATOM   1821  CD2 PHE   206      14.064   5.842  11.437  1.00  9.37           C  
ATOM   1822  CE1 PHE   206      16.076   5.167   9.762  1.00 10.64           C  
ATOM   1823  CE2 PHE   206      14.067   4.597  10.797  1.00 10.05           C  
ATOM   1824  CZ  PHE   206      15.066   4.283   9.978  1.00  9.14           C  
ATOM   1825  N   TRP   207      13.302   8.677   8.971  1.00  5.96           N  
ATOM   1826  CA  TRP   207      12.075   8.353   8.231  1.00  5.95           C  
ATOM   1827  C   TRP   207      12.387   7.496   7.015  1.00  6.25           C  
ATOM   1828  O   TRP   207      13.307   7.774   6.248  1.00  7.20           O  
ATOM   1829  CB  TRP   207      11.338   9.619   7.803  1.00  6.22           C  
ATOM   1830  CG  TRP   207      11.025  10.523   8.968  1.00  6.85           C  
ATOM   1831  CD1 TRP   207      11.767  11.579   9.408  1.00  7.54           C  
ATOM   1832  CD2 TRP   207       9.936  10.403   9.871  1.00  6.13           C  
ATOM   1833  NE1 TRP   207      11.189  12.128  10.521  1.00  7.82           N  
ATOM   1834  CE2 TRP   207      10.062  11.424  10.828  1.00  6.99           C  
ATOM   1835  CE3 TRP   207       8.857   9.532   9.965  1.00  7.19           C  
ATOM   1836  CZ2 TRP   207       9.123  11.610  11.854  1.00  7.88           C  
ATOM   1837  CZ3 TRP   207       7.911   9.720  10.987  1.00  7.28           C  
ATOM   1838  CH2 TRP   207       8.067  10.745  11.909  1.00  8.41           C  
ATOM   1839  N   ILE   208      11.558   6.463   6.848  1.00  5.94           N  
ATOM   1840  CA  ILE   208      11.600   5.524   5.739  1.00  6.12           C  
ATOM   1841  C   ILE   208      10.537   5.928   4.739  1.00  5.45           C  
ATOM   1842  O   ILE   208       9.349   5.952   5.059  1.00  6.40           O  
ATOM   1843  CB  ILE   208      11.359   4.101   6.262  1.00  5.82           C  
ATOM   1844  CG1 ILE   208      12.436   3.678   7.274  1.00  7.29           C  
ATOM   1845  CG2 ILE   208      11.250   3.117   5.101  1.00  8.18           C  
ATOM   1846  CD1 ILE   208      12.021   2.499   8.167  1.00  7.79           C  
ATOM   1847  N   ILE   209      10.987   6.219   3.519  1.00  5.86           N  
ATOM   1848  CA  ILE   209      10.141   6.784   2.468  1.00  6.44           C  
ATOM   1849  C   ILE   209      10.178   5.901   1.224  1.00  5.76           C  
ATOM   1850  O   ILE   209      11.044   6.015   0.339  1.00  6.98           O  
ATOM   1851  CB  ILE   209      10.618   8.215   2.113  1.00  6.53           C  
ATOM   1852  CG1 ILE   209      10.623   9.090   3.364  1.00  7.73           C  
ATOM   1853  CG2 ILE   209       9.744   8.827   1.014  1.00  7.77           C  
ATOM   1854  CD1 ILE   209      11.241  10.463   3.206  1.00  9.24           C  
ATOM   1855  N   ILE   210       9.238   4.975   1.184  1.00  6.60           N  
ATOM   1856  CA  ILE   210       9.101   4.036   0.090  1.00  6.60           C  
ATOM   1857  C   ILE   210       8.194   4.654  -0.956  1.00  7.33           C  
ATOM   1858  O   ILE   210       7.182   5.254  -0.639  1.00  8.13           O  
ATOM   1859  CB  ILE   210       8.496   2.718   0.596  1.00  7.30           C  
ATOM   1860  CG1 ILE   210       9.459   2.044   1.593  1.00  8.56           C  
ATOM   1861  CG2 ILE   210       8.152   1.778  -0.566  1.00  9.41           C  
ATOM   1862  CD1 ILE   210       8.779   1.030   2.522  1.00 10.57           C  
ATOM   1863  N   SER   211       8.542   4.428  -2.218  1.00  7.80           N  
ATOM   1864  CA  SER   211       7.704   4.787  -3.346  1.00  9.51           C  
ATOM   1865  C   SER   211       7.310   3.536  -4.068  1.00  9.69           C  
ATOM   1866  O   SER   211       8.175   2.864  -4.583  1.00 14.81           O  
ATOM   1867  CB  SER   211       8.463   5.621  -4.353  1.00 10.93           C  
ATOM   1868  OG  SER   211       8.739   6.890  -3.859  1.00 12.33           O  
ATOM   1869  N   LYS   212       6.037   3.229  -4.210  1.00 10.63           N  
ATOM   1870  CA  LYS   212       5.665   2.060  -4.958  1.00 10.65           C  
ATOM   1871  C   LYS   212       5.632   2.404  -6.409  1.00  9.76           C  
ATOM   1872  O   LYS   212       4.902   3.275  -6.862  1.00 12.14           O  
ATOM   1873  CB  LYS   212       4.309   1.506  -4.519  1.00 11.11           C  
ATOM   1874  CG  LYS   212       3.923   0.279  -5.352  1.00 13.46           C  
ATOM   1875  CD  LYS   212       2.588  -0.397  -5.039  1.00 18.87           C  
ATOM   1876  CE  LYS   212       2.723  -1.451  -4.033  1.00 15.44           C  
ATOM   1877  NZ  LYS   212       1.493  -2.207  -3.667  1.00  9.74           N  
ATOM   1878  N   THR   213       6.431   1.694  -7.159  1.00 12.74           N  
ATOM   1879  CA  THR   213       6.569   1.950  -8.568  1.00 12.48           C  
ATOM   1880  C   THR   213       6.693   0.638  -9.305  1.00 10.87           C  
ATOM   1881  O   THR   213       7.025  -0.379  -8.733  1.00 13.74           O  
ATOM   1882  CB  THR   213       7.791   2.873  -8.803  1.00 13.61           C  
ATOM   1883  OG1 THR   213       7.713   3.501 -10.087  1.00 17.55           O  
ATOM   1884  CG2 THR   213       9.149   2.143  -8.597  1.00 15.43           C  
ATOM   1885  N   ASP   214       6.456   0.674 -10.605  1.00 10.89           N  
ATOM   1886  CA  ASP   214       6.591  -0.516 -11.448  1.00 10.60           C  
ATOM   1887  C   ASP   214       8.030  -1.029 -11.294  1.00 11.07           C  
ATOM   1888  O   ASP   214       8.984  -0.292 -11.512  1.00 11.94           O  
ATOM   1889  CB  ASP   214       6.265  -0.193 -12.889  1.00 12.55           C  
ATOM   1890  CG  ASP   214       4.780   0.093 -13.126  1.00 13.76           C  
ATOM   1891  OD1 ASP   214       3.917  -0.336 -12.313  1.00 15.87           O  
ATOM   1892  OD2 ASP   214       4.482   0.751 -14.144  1.00 17.35           O  
ATOM   1893  N   GLN   215       8.167  -2.276 -10.897  1.00  9.57           N  
ATOM   1894  CA  GLN   215       9.446  -2.776 -10.472  1.00  8.21           C  
ATOM   1895  C   GLN   215      10.493  -2.921 -11.555  1.00  8.15           C  
ATOM   1896  O   GLN   215      10.210  -3.132 -12.735  1.00  9.83           O  
ATOM   1897  CB  GLN   215       9.325  -4.059  -9.688  1.00  9.05           C  
ATOM   1898  CG  GLN   215       8.982  -5.284 -10.470  1.00 10.29           C  
ATOM   1899  CD  GLN   215       9.012  -6.495  -9.570  1.00  9.65           C  
ATOM   1900  OE1 GLN   215       8.463  -6.458  -8.451  1.00 10.50           O  
ATOM   1901  NE2 GLN   215       9.664  -7.570 -10.003  1.00  9.58           N  
ATOM   1902  N   GLU   216      11.743  -2.895 -11.125  1.00  8.07           N  
ATOM   1903  CA  GLU   216      12.863  -2.943 -12.054  1.00  8.31           C  
ATOM   1904  C   GLU   216      13.142  -4.322 -12.618  1.00  8.10           C  
ATOM   1905  O   GLU   216      13.691  -4.421 -13.713  1.00  9.58           O  
ATOM   1906  CB  GLU   216      14.129  -2.364 -11.402  1.00  9.90           C  
ATOM   1907  CG  GLU   216      14.607  -3.115 -10.206  1.00  8.84           C  
ATOM   1908  CD  GLU   216      15.623  -2.326  -9.428  1.00  9.44           C  
ATOM   1909  OE1 GLU   216      16.487  -1.646 -10.041  1.00 11.52           O  
ATOM   1910  OE2 GLU   216      15.587  -2.398  -8.197  1.00 10.51           O  
ATOM   1911  N   VAL   217      12.804  -5.374 -11.889  1.00  7.86           N  
ATOM   1912  CA  VAL   217      13.046  -6.739 -12.369  1.00  8.11           C  
ATOM   1913  C   VAL   217      11.827  -7.236 -13.112  1.00  7.99           C  
ATOM   1914  O   VAL   217      10.778  -7.528 -12.532  1.00  9.26           O  
ATOM   1915  CB  VAL   217      13.419  -7.703 -11.210  1.00  8.89           C  
ATOM   1916  CG1 VAL   217      13.576  -9.130 -11.753  1.00 11.10           C  
ATOM   1917  CG2 VAL   217      14.685  -7.236 -10.507  1.00 10.59           C  
ATOM   1918  N   ILE   218      11.981  -7.338 -14.425  1.00  8.45           N  
ATOM   1919  CA  ILE   218      10.971  -7.885 -15.321  1.00  9.15           C  
ATOM   1920  C   ILE   218      11.632  -8.729 -16.414  1.00 10.29           C  
ATOM   1921  O   ILE   218      12.876  -8.674 -16.590  1.00 10.34           O  
ATOM   1922  CB  ILE   218      10.052  -6.829 -15.982  1.00 10.14           C  
ATOM   1923  CG1 ILE   218      10.841  -5.840 -16.818  1.00  9.54           C  
ATOM   1924  CG2 ILE   218       9.197  -6.156 -14.932  1.00 11.46           C  
ATOM   1925  CD1 ILE   218       9.974  -4.931 -17.648  1.00 11.50           C  
ATOM   1926  OXT ILE   218      10.883  -9.441 -17.135  1.00 11.01           O  
END
